package net.codinux.i18n

import kotlin.String
import net.codinux.collections.ImmutableMap
import net.codinux.collections.immutableMapOf

internal object AvailableLanguageTags {
  val availableLanguageTags: ImmutableMap<String, LanguageTag> = immutableMapOf(
    "aa" to LanguageTag.parse("aa"),
    "aa-DJ" to LanguageTag.parse("aa-DJ"),
    "aa-ER" to LanguageTag.parse("aa-ER"),
    "ab" to LanguageTag.parse("ab"),
    "af" to LanguageTag.parse("af"),
    "af-NA" to LanguageTag.parse("af-NA"),
    "agq" to LanguageTag.parse("agq"),
    "ak" to LanguageTag.parse("ak"),
    "am" to LanguageTag.parse("am"),
    "an" to LanguageTag.parse("an"),
    "ann" to LanguageTag.parse("ann"),
    "apc" to LanguageTag.parse("apc"),
    "ar" to LanguageTag.parse("ar"),
    "ar-AE" to LanguageTag.parse("ar-AE"),
    "ar-BH" to LanguageTag.parse("ar-BH"),
    "ar-DJ" to LanguageTag.parse("ar-DJ"),
    "ar-DZ" to LanguageTag.parse("ar-DZ"),
    "ar-EG" to LanguageTag.parse("ar-EG"),
    "ar-EH" to LanguageTag.parse("ar-EH"),
    "ar-ER" to LanguageTag.parse("ar-ER"),
    "ar-IL" to LanguageTag.parse("ar-IL"),
    "ar-IQ" to LanguageTag.parse("ar-IQ"),
    "ar-JO" to LanguageTag.parse("ar-JO"),
    "ar-KM" to LanguageTag.parse("ar-KM"),
    "ar-KW" to LanguageTag.parse("ar-KW"),
    "ar-LB" to LanguageTag.parse("ar-LB"),
    "ar-LY" to LanguageTag.parse("ar-LY"),
    "ar-MA" to LanguageTag.parse("ar-MA"),
    "ar-MR" to LanguageTag.parse("ar-MR"),
    "ar-OM" to LanguageTag.parse("ar-OM"),
    "ar-PS" to LanguageTag.parse("ar-PS"),
    "ar-QA" to LanguageTag.parse("ar-QA"),
    "ar-SA" to LanguageTag.parse("ar-SA"),
    "ar-SD" to LanguageTag.parse("ar-SD"),
    "ar-SO" to LanguageTag.parse("ar-SO"),
    "ar-SS" to LanguageTag.parse("ar-SS"),
    "ar-SY" to LanguageTag.parse("ar-SY"),
    "ar-TD" to LanguageTag.parse("ar-TD"),
    "ar-TN" to LanguageTag.parse("ar-TN"),
    "ar-YE" to LanguageTag.parse("ar-YE"),
    "arn" to LanguageTag.parse("arn"),
    "as" to LanguageTag.parse("as"),
    "asa" to LanguageTag.parse("asa"),
    "ast" to LanguageTag.parse("ast"),
    "az" to LanguageTag.parse("az"),
    "az-Arab" to LanguageTag.parse("az-Arab"),
    "az-Arab-IQ" to LanguageTag.parse("az-Arab-IQ"),
    "az-Arab-TR" to LanguageTag.parse("az-Arab-TR"),
    "az-Cyrl" to LanguageTag.parse("az-Cyrl"),
    "az-Latn" to LanguageTag.parse("az-Latn"),
    "ba" to LanguageTag.parse("ba"),
    "bal" to LanguageTag.parse("bal"),
    "bal-Arab" to LanguageTag.parse("bal-Arab"),
    "bal-Latn" to LanguageTag.parse("bal-Latn"),
    "bas" to LanguageTag.parse("bas"),
    "be" to LanguageTag.parse("be"),
    "be-tarask" to LanguageTag.parse("be-tarask"),
    "bem" to LanguageTag.parse("bem"),
    "bew" to LanguageTag.parse("bew"),
    "bez" to LanguageTag.parse("bez"),
    "bg" to LanguageTag.parse("bg"),
    "bgc" to LanguageTag.parse("bgc"),
    "bgn" to LanguageTag.parse("bgn"),
    "bgn-AE" to LanguageTag.parse("bgn-AE"),
    "bgn-AF" to LanguageTag.parse("bgn-AF"),
    "bgn-IR" to LanguageTag.parse("bgn-IR"),
    "bgn-OM" to LanguageTag.parse("bgn-OM"),
    "bho" to LanguageTag.parse("bho"),
    "blo" to LanguageTag.parse("blo"),
    "blt" to LanguageTag.parse("blt"),
    "bm" to LanguageTag.parse("bm"),
    "bm-Nkoo" to LanguageTag.parse("bm-Nkoo"),
    "bn" to LanguageTag.parse("bn"),
    "bn-IN" to LanguageTag.parse("bn-IN"),
    "bo" to LanguageTag.parse("bo"),
    "bo-IN" to LanguageTag.parse("bo-IN"),
    "br" to LanguageTag.parse("br"),
    "brx" to LanguageTag.parse("brx"),
    "bs" to LanguageTag.parse("bs"),
    "bs-Cyrl" to LanguageTag.parse("bs-Cyrl"),
    "bs-Latn" to LanguageTag.parse("bs-Latn"),
    "bss" to LanguageTag.parse("bss"),
    "byn" to LanguageTag.parse("byn"),
    "ca" to LanguageTag.parse("ca"),
    "ca-AD" to LanguageTag.parse("ca-AD"),
    "ca-ES-valencia" to LanguageTag.parse("ca-ES-valencia"),
    "ca-FR" to LanguageTag.parse("ca-FR"),
    "ca-IT" to LanguageTag.parse("ca-IT"),
    "cad" to LanguageTag.parse("cad"),
    "cch" to LanguageTag.parse("cch"),
    "ccp" to LanguageTag.parse("ccp"),
    "ccp-IN" to LanguageTag.parse("ccp-IN"),
    "ce" to LanguageTag.parse("ce"),
    "ceb" to LanguageTag.parse("ceb"),
    "cgg" to LanguageTag.parse("cgg"),
    "cho" to LanguageTag.parse("cho"),
    "chr" to LanguageTag.parse("chr"),
    "cic" to LanguageTag.parse("cic"),
    "ckb" to LanguageTag.parse("ckb"),
    "ckb-IR" to LanguageTag.parse("ckb-IR"),
    "co" to LanguageTag.parse("co"),
    "cs" to LanguageTag.parse("cs"),
    "csw" to LanguageTag.parse("csw"),
    "cu" to LanguageTag.parse("cu"),
    "cv" to LanguageTag.parse("cv"),
    "cy" to LanguageTag.parse("cy"),
    "da" to LanguageTag.parse("da"),
    "da-GL" to LanguageTag.parse("da-GL"),
    "dav" to LanguageTag.parse("dav"),
    "de" to LanguageTag.parse("de"),
    "de-AT" to LanguageTag.parse("de-AT"),
    "de-BE" to LanguageTag.parse("de-BE"),
    "de-CH" to LanguageTag.parse("de-CH"),
    "de-IT" to LanguageTag.parse("de-IT"),
    "de-LI" to LanguageTag.parse("de-LI"),
    "de-LU" to LanguageTag.parse("de-LU"),
    "dje" to LanguageTag.parse("dje"),
    "doi" to LanguageTag.parse("doi"),
    "dsb" to LanguageTag.parse("dsb"),
    "dua" to LanguageTag.parse("dua"),
    "dv" to LanguageTag.parse("dv"),
    "dyo" to LanguageTag.parse("dyo"),
    "dz" to LanguageTag.parse("dz"),
    "ebu" to LanguageTag.parse("ebu"),
    "ee" to LanguageTag.parse("ee"),
    "ee-TG" to LanguageTag.parse("ee-TG"),
    "el" to LanguageTag.parse("el"),
    "el-CY" to LanguageTag.parse("el-CY"),
    "el-polyton" to LanguageTag.parse("el-polyton"),
    "en" to LanguageTag.parse("en"),
    "en-001" to LanguageTag.parse("en-001"),
    "en-150" to LanguageTag.parse("en-150"),
    "en-AE" to LanguageTag.parse("en-AE"),
    "en-AG" to LanguageTag.parse("en-AG"),
    "en-AI" to LanguageTag.parse("en-AI"),
    "en-AS" to LanguageTag.parse("en-AS"),
    "en-AT" to LanguageTag.parse("en-AT"),
    "en-AU" to LanguageTag.parse("en-AU"),
    "en-BB" to LanguageTag.parse("en-BB"),
    "en-BE" to LanguageTag.parse("en-BE"),
    "en-BI" to LanguageTag.parse("en-BI"),
    "en-BM" to LanguageTag.parse("en-BM"),
    "en-BS" to LanguageTag.parse("en-BS"),
    "en-BW" to LanguageTag.parse("en-BW"),
    "en-BZ" to LanguageTag.parse("en-BZ"),
    "en-CA" to LanguageTag.parse("en-CA"),
    "en-CC" to LanguageTag.parse("en-CC"),
    "en-CH" to LanguageTag.parse("en-CH"),
    "en-CK" to LanguageTag.parse("en-CK"),
    "en-CM" to LanguageTag.parse("en-CM"),
    "en-CX" to LanguageTag.parse("en-CX"),
    "en-CY" to LanguageTag.parse("en-CY"),
    "en-DE" to LanguageTag.parse("en-DE"),
    "en-DG" to LanguageTag.parse("en-DG"),
    "en-DK" to LanguageTag.parse("en-DK"),
    "en-DM" to LanguageTag.parse("en-DM"),
    "en-Dsrt" to LanguageTag.parse("en-Dsrt"),
    "en-ER" to LanguageTag.parse("en-ER"),
    "en-FI" to LanguageTag.parse("en-FI"),
    "en-FJ" to LanguageTag.parse("en-FJ"),
    "en-FK" to LanguageTag.parse("en-FK"),
    "en-FM" to LanguageTag.parse("en-FM"),
    "en-GB" to LanguageTag.parse("en-GB"),
    "en-GD" to LanguageTag.parse("en-GD"),
    "en-GG" to LanguageTag.parse("en-GG"),
    "en-GH" to LanguageTag.parse("en-GH"),
    "en-GI" to LanguageTag.parse("en-GI"),
    "en-GM" to LanguageTag.parse("en-GM"),
    "en-GU" to LanguageTag.parse("en-GU"),
    "en-GY" to LanguageTag.parse("en-GY"),
    "en-HK" to LanguageTag.parse("en-HK"),
    "en-ID" to LanguageTag.parse("en-ID"),
    "en-IE" to LanguageTag.parse("en-IE"),
    "en-IL" to LanguageTag.parse("en-IL"),
    "en-IM" to LanguageTag.parse("en-IM"),
    "en-IN" to LanguageTag.parse("en-IN"),
    "en-IO" to LanguageTag.parse("en-IO"),
    "en-JE" to LanguageTag.parse("en-JE"),
    "en-JM" to LanguageTag.parse("en-JM"),
    "en-KE" to LanguageTag.parse("en-KE"),
    "en-KI" to LanguageTag.parse("en-KI"),
    "en-KN" to LanguageTag.parse("en-KN"),
    "en-KY" to LanguageTag.parse("en-KY"),
    "en-LC" to LanguageTag.parse("en-LC"),
    "en-LR" to LanguageTag.parse("en-LR"),
    "en-LS" to LanguageTag.parse("en-LS"),
    "en-MG" to LanguageTag.parse("en-MG"),
    "en-MH" to LanguageTag.parse("en-MH"),
    "en-MO" to LanguageTag.parse("en-MO"),
    "en-MP" to LanguageTag.parse("en-MP"),
    "en-MS" to LanguageTag.parse("en-MS"),
    "en-MT" to LanguageTag.parse("en-MT"),
    "en-MU" to LanguageTag.parse("en-MU"),
    "en-MV" to LanguageTag.parse("en-MV"),
    "en-MW" to LanguageTag.parse("en-MW"),
    "en-MY" to LanguageTag.parse("en-MY"),
    "en-NA" to LanguageTag.parse("en-NA"),
    "en-NF" to LanguageTag.parse("en-NF"),
    "en-NG" to LanguageTag.parse("en-NG"),
    "en-NL" to LanguageTag.parse("en-NL"),
    "en-NR" to LanguageTag.parse("en-NR"),
    "en-NU" to LanguageTag.parse("en-NU"),
    "en-NZ" to LanguageTag.parse("en-NZ"),
    "en-PG" to LanguageTag.parse("en-PG"),
    "en-PH" to LanguageTag.parse("en-PH"),
    "en-PK" to LanguageTag.parse("en-PK"),
    "en-PN" to LanguageTag.parse("en-PN"),
    "en-PR" to LanguageTag.parse("en-PR"),
    "en-PW" to LanguageTag.parse("en-PW"),
    "en-RW" to LanguageTag.parse("en-RW"),
    "en-SB" to LanguageTag.parse("en-SB"),
    "en-SC" to LanguageTag.parse("en-SC"),
    "en-SD" to LanguageTag.parse("en-SD"),
    "en-SE" to LanguageTag.parse("en-SE"),
    "en-SG" to LanguageTag.parse("en-SG"),
    "en-SH" to LanguageTag.parse("en-SH"),
    "en-SI" to LanguageTag.parse("en-SI"),
    "en-SL" to LanguageTag.parse("en-SL"),
    "en-SS" to LanguageTag.parse("en-SS"),
    "en-SX" to LanguageTag.parse("en-SX"),
    "en-SZ" to LanguageTag.parse("en-SZ"),
    "en-Shaw" to LanguageTag.parse("en-Shaw"),
    "en-TC" to LanguageTag.parse("en-TC"),
    "en-TK" to LanguageTag.parse("en-TK"),
    "en-TO" to LanguageTag.parse("en-TO"),
    "en-TT" to LanguageTag.parse("en-TT"),
    "en-TV" to LanguageTag.parse("en-TV"),
    "en-TZ" to LanguageTag.parse("en-TZ"),
    "en-UG" to LanguageTag.parse("en-UG"),
    "en-UM" to LanguageTag.parse("en-UM"),
    "en-VC" to LanguageTag.parse("en-VC"),
    "en-VG" to LanguageTag.parse("en-VG"),
    "en-VI" to LanguageTag.parse("en-VI"),
    "en-VU" to LanguageTag.parse("en-VU"),
    "en-WS" to LanguageTag.parse("en-WS"),
    "en-ZA" to LanguageTag.parse("en-ZA"),
    "en-ZM" to LanguageTag.parse("en-ZM"),
    "en-ZW" to LanguageTag.parse("en-ZW"),
    "eo" to LanguageTag.parse("eo"),
    "es" to LanguageTag.parse("es"),
    "es-419" to LanguageTag.parse("es-419"),
    "es-AR" to LanguageTag.parse("es-AR"),
    "es-BO" to LanguageTag.parse("es-BO"),
    "es-BR" to LanguageTag.parse("es-BR"),
    "es-BZ" to LanguageTag.parse("es-BZ"),
    "es-CL" to LanguageTag.parse("es-CL"),
    "es-CO" to LanguageTag.parse("es-CO"),
    "es-CR" to LanguageTag.parse("es-CR"),
    "es-CU" to LanguageTag.parse("es-CU"),
    "es-DO" to LanguageTag.parse("es-DO"),
    "es-EA" to LanguageTag.parse("es-EA"),
    "es-EC" to LanguageTag.parse("es-EC"),
    "es-GQ" to LanguageTag.parse("es-GQ"),
    "es-GT" to LanguageTag.parse("es-GT"),
    "es-HN" to LanguageTag.parse("es-HN"),
    "es-IC" to LanguageTag.parse("es-IC"),
    "es-MX" to LanguageTag.parse("es-MX"),
    "es-NI" to LanguageTag.parse("es-NI"),
    "es-PA" to LanguageTag.parse("es-PA"),
    "es-PE" to LanguageTag.parse("es-PE"),
    "es-PH" to LanguageTag.parse("es-PH"),
    "es-PR" to LanguageTag.parse("es-PR"),
    "es-PY" to LanguageTag.parse("es-PY"),
    "es-SV" to LanguageTag.parse("es-SV"),
    "es-US" to LanguageTag.parse("es-US"),
    "es-UY" to LanguageTag.parse("es-UY"),
    "es-VE" to LanguageTag.parse("es-VE"),
    "et" to LanguageTag.parse("et"),
    "eu" to LanguageTag.parse("eu"),
    "ewo" to LanguageTag.parse("ewo"),
    "fa" to LanguageTag.parse("fa"),
    "fa-AF" to LanguageTag.parse("fa-AF"),
    "ff" to LanguageTag.parse("ff"),
    "ff-Adlm" to LanguageTag.parse("ff-Adlm"),
    "ff-Adlm-BF" to LanguageTag.parse("ff-Adlm-BF"),
    "ff-Adlm-CM" to LanguageTag.parse("ff-Adlm-CM"),
    "ff-Adlm-GH" to LanguageTag.parse("ff-Adlm-GH"),
    "ff-Adlm-GM" to LanguageTag.parse("ff-Adlm-GM"),
    "ff-Adlm-GW" to LanguageTag.parse("ff-Adlm-GW"),
    "ff-Adlm-LR" to LanguageTag.parse("ff-Adlm-LR"),
    "ff-Adlm-MR" to LanguageTag.parse("ff-Adlm-MR"),
    "ff-Adlm-NE" to LanguageTag.parse("ff-Adlm-NE"),
    "ff-Adlm-NG" to LanguageTag.parse("ff-Adlm-NG"),
    "ff-Adlm-SL" to LanguageTag.parse("ff-Adlm-SL"),
    "ff-Adlm-SN" to LanguageTag.parse("ff-Adlm-SN"),
    "ff-Latn" to LanguageTag.parse("ff-Latn"),
    "ff-Latn-BF" to LanguageTag.parse("ff-Latn-BF"),
    "ff-Latn-CM" to LanguageTag.parse("ff-Latn-CM"),
    "ff-Latn-GH" to LanguageTag.parse("ff-Latn-GH"),
    "ff-Latn-GM" to LanguageTag.parse("ff-Latn-GM"),
    "ff-Latn-GN" to LanguageTag.parse("ff-Latn-GN"),
    "ff-Latn-GW" to LanguageTag.parse("ff-Latn-GW"),
    "ff-Latn-LR" to LanguageTag.parse("ff-Latn-LR"),
    "ff-Latn-MR" to LanguageTag.parse("ff-Latn-MR"),
    "ff-Latn-NE" to LanguageTag.parse("ff-Latn-NE"),
    "ff-Latn-NG" to LanguageTag.parse("ff-Latn-NG"),
    "ff-Latn-SL" to LanguageTag.parse("ff-Latn-SL"),
    "fi" to LanguageTag.parse("fi"),
    "fil" to LanguageTag.parse("fil"),
    "fo" to LanguageTag.parse("fo"),
    "fo-DK" to LanguageTag.parse("fo-DK"),
    "fr" to LanguageTag.parse("fr"),
    "fr-BE" to LanguageTag.parse("fr-BE"),
    "fr-BF" to LanguageTag.parse("fr-BF"),
    "fr-BI" to LanguageTag.parse("fr-BI"),
    "fr-BJ" to LanguageTag.parse("fr-BJ"),
    "fr-BL" to LanguageTag.parse("fr-BL"),
    "fr-CA" to LanguageTag.parse("fr-CA"),
    "fr-CD" to LanguageTag.parse("fr-CD"),
    "fr-CF" to LanguageTag.parse("fr-CF"),
    "fr-CG" to LanguageTag.parse("fr-CG"),
    "fr-CH" to LanguageTag.parse("fr-CH"),
    "fr-CI" to LanguageTag.parse("fr-CI"),
    "fr-CM" to LanguageTag.parse("fr-CM"),
    "fr-DJ" to LanguageTag.parse("fr-DJ"),
    "fr-DZ" to LanguageTag.parse("fr-DZ"),
    "fr-GA" to LanguageTag.parse("fr-GA"),
    "fr-GF" to LanguageTag.parse("fr-GF"),
    "fr-GN" to LanguageTag.parse("fr-GN"),
    "fr-GP" to LanguageTag.parse("fr-GP"),
    "fr-GQ" to LanguageTag.parse("fr-GQ"),
    "fr-HT" to LanguageTag.parse("fr-HT"),
    "fr-KM" to LanguageTag.parse("fr-KM"),
    "fr-LU" to LanguageTag.parse("fr-LU"),
    "fr-MA" to LanguageTag.parse("fr-MA"),
    "fr-MC" to LanguageTag.parse("fr-MC"),
    "fr-MF" to LanguageTag.parse("fr-MF"),
    "fr-MG" to LanguageTag.parse("fr-MG"),
    "fr-ML" to LanguageTag.parse("fr-ML"),
    "fr-MQ" to LanguageTag.parse("fr-MQ"),
    "fr-MR" to LanguageTag.parse("fr-MR"),
    "fr-MU" to LanguageTag.parse("fr-MU"),
    "fr-NC" to LanguageTag.parse("fr-NC"),
    "fr-NE" to LanguageTag.parse("fr-NE"),
    "fr-PF" to LanguageTag.parse("fr-PF"),
    "fr-PM" to LanguageTag.parse("fr-PM"),
    "fr-RE" to LanguageTag.parse("fr-RE"),
    "fr-RW" to LanguageTag.parse("fr-RW"),
    "fr-SC" to LanguageTag.parse("fr-SC"),
    "fr-SN" to LanguageTag.parse("fr-SN"),
    "fr-SY" to LanguageTag.parse("fr-SY"),
    "fr-TD" to LanguageTag.parse("fr-TD"),
    "fr-TG" to LanguageTag.parse("fr-TG"),
    "fr-TN" to LanguageTag.parse("fr-TN"),
    "fr-VU" to LanguageTag.parse("fr-VU"),
    "fr-WF" to LanguageTag.parse("fr-WF"),
    "fr-YT" to LanguageTag.parse("fr-YT"),
    "frr" to LanguageTag.parse("frr"),
    "fur" to LanguageTag.parse("fur"),
    "fy" to LanguageTag.parse("fy"),
    "ga" to LanguageTag.parse("ga"),
    "ga-GB" to LanguageTag.parse("ga-GB"),
    "gaa" to LanguageTag.parse("gaa"),
    "gd" to LanguageTag.parse("gd"),
    "gez" to LanguageTag.parse("gez"),
    "gez-ER" to LanguageTag.parse("gez-ER"),
    "gl" to LanguageTag.parse("gl"),
    "gn" to LanguageTag.parse("gn"),
    "gsw" to LanguageTag.parse("gsw"),
    "gsw-FR" to LanguageTag.parse("gsw-FR"),
    "gsw-LI" to LanguageTag.parse("gsw-LI"),
    "gu" to LanguageTag.parse("gu"),
    "guz" to LanguageTag.parse("guz"),
    "gv" to LanguageTag.parse("gv"),
    "ha" to LanguageTag.parse("ha"),
    "ha-Arab" to LanguageTag.parse("ha-Arab"),
    "ha-Arab-SD" to LanguageTag.parse("ha-Arab-SD"),
    "ha-GH" to LanguageTag.parse("ha-GH"),
    "ha-NE" to LanguageTag.parse("ha-NE"),
    "haw" to LanguageTag.parse("haw"),
    "he" to LanguageTag.parse("he"),
    "hi" to LanguageTag.parse("hi"),
    "hi-Latn" to LanguageTag.parse("hi-Latn"),
    "hnj" to LanguageTag.parse("hnj"),
    "hnj-Hmnp" to LanguageTag.parse("hnj-Hmnp"),
    "hr" to LanguageTag.parse("hr"),
    "hr-BA" to LanguageTag.parse("hr-BA"),
    "hsb" to LanguageTag.parse("hsb"),
    "hu" to LanguageTag.parse("hu"),
    "hy" to LanguageTag.parse("hy"),
    "ia" to LanguageTag.parse("ia"),
    "id" to LanguageTag.parse("id"),
    "ie" to LanguageTag.parse("ie"),
    "ig" to LanguageTag.parse("ig"),
    "ii" to LanguageTag.parse("ii"),
    "io" to LanguageTag.parse("io"),
    "is" to LanguageTag.parse("is"),
    "it" to LanguageTag.parse("it"),
    "it-CH" to LanguageTag.parse("it-CH"),
    "it-SM" to LanguageTag.parse("it-SM"),
    "it-VA" to LanguageTag.parse("it-VA"),
    "iu" to LanguageTag.parse("iu"),
    "iu-Latn" to LanguageTag.parse("iu-Latn"),
    "ja" to LanguageTag.parse("ja"),
    "jbo" to LanguageTag.parse("jbo"),
    "jgo" to LanguageTag.parse("jgo"),
    "jmc" to LanguageTag.parse("jmc"),
    "jv" to LanguageTag.parse("jv"),
    "ka" to LanguageTag.parse("ka"),
    "kaa" to LanguageTag.parse("kaa"),
    "kaa-Cyrl" to LanguageTag.parse("kaa-Cyrl"),
    "kaa-Latn" to LanguageTag.parse("kaa-Latn"),
    "kab" to LanguageTag.parse("kab"),
    "kaj" to LanguageTag.parse("kaj"),
    "kam" to LanguageTag.parse("kam"),
    "kcg" to LanguageTag.parse("kcg"),
    "kde" to LanguageTag.parse("kde"),
    "kea" to LanguageTag.parse("kea"),
    "ken" to LanguageTag.parse("ken"),
    "kgp" to LanguageTag.parse("kgp"),
    "khq" to LanguageTag.parse("khq"),
    "ki" to LanguageTag.parse("ki"),
    "kk" to LanguageTag.parse("kk"),
    "kk-Arab" to LanguageTag.parse("kk-Arab"),
    "kk-Cyrl" to LanguageTag.parse("kk-Cyrl"),
    "kk-KZ" to LanguageTag.parse("kk-KZ"),
    "kkj" to LanguageTag.parse("kkj"),
    "kl" to LanguageTag.parse("kl"),
    "kln" to LanguageTag.parse("kln"),
    "km" to LanguageTag.parse("km"),
    "kn" to LanguageTag.parse("kn"),
    "ko" to LanguageTag.parse("ko"),
    "ko-CN" to LanguageTag.parse("ko-CN"),
    "ko-KP" to LanguageTag.parse("ko-KP"),
    "kok" to LanguageTag.parse("kok"),
    "kok-Deva" to LanguageTag.parse("kok-Deva"),
    "kok-Latn" to LanguageTag.parse("kok-Latn"),
    "kpe" to LanguageTag.parse("kpe"),
    "kpe-GN" to LanguageTag.parse("kpe-GN"),
    "ks" to LanguageTag.parse("ks"),
    "ks-Arab" to LanguageTag.parse("ks-Arab"),
    "ks-Deva" to LanguageTag.parse("ks-Deva"),
    "ksb" to LanguageTag.parse("ksb"),
    "ksf" to LanguageTag.parse("ksf"),
    "ksh" to LanguageTag.parse("ksh"),
    "ku" to LanguageTag.parse("ku"),
    "kw" to LanguageTag.parse("kw"),
    "kxv" to LanguageTag.parse("kxv"),
    "kxv-Deva" to LanguageTag.parse("kxv-Deva"),
    "kxv-Latn" to LanguageTag.parse("kxv-Latn"),
    "kxv-Orya" to LanguageTag.parse("kxv-Orya"),
    "kxv-Telu" to LanguageTag.parse("kxv-Telu"),
    "ky" to LanguageTag.parse("ky"),
    "la" to LanguageTag.parse("la"),
    "lag" to LanguageTag.parse("lag"),
    "lb" to LanguageTag.parse("lb"),
    "lg" to LanguageTag.parse("lg"),
    "lij" to LanguageTag.parse("lij"),
    "lkt" to LanguageTag.parse("lkt"),
    "lld" to LanguageTag.parse("lld"),
    "lmo" to LanguageTag.parse("lmo"),
    "ln" to LanguageTag.parse("ln"),
    "ln-AO" to LanguageTag.parse("ln-AO"),
    "ln-CF" to LanguageTag.parse("ln-CF"),
    "ln-CG" to LanguageTag.parse("ln-CG"),
    "lo" to LanguageTag.parse("lo"),
    "lrc" to LanguageTag.parse("lrc"),
    "lrc-IQ" to LanguageTag.parse("lrc-IQ"),
    "lt" to LanguageTag.parse("lt"),
    "ltg" to LanguageTag.parse("ltg"),
    "lu" to LanguageTag.parse("lu"),
    "luo" to LanguageTag.parse("luo"),
    "luy" to LanguageTag.parse("luy"),
    "lv" to LanguageTag.parse("lv"),
    "mai" to LanguageTag.parse("mai"),
    "mas" to LanguageTag.parse("mas"),
    "mas-TZ" to LanguageTag.parse("mas-TZ"),
    "mdf" to LanguageTag.parse("mdf"),
    "mer" to LanguageTag.parse("mer"),
    "mfe" to LanguageTag.parse("mfe"),
    "mg" to LanguageTag.parse("mg"),
    "mgh" to LanguageTag.parse("mgh"),
    "mgo" to LanguageTag.parse("mgo"),
    "mhn" to LanguageTag.parse("mhn"),
    "mi" to LanguageTag.parse("mi"),
    "mic" to LanguageTag.parse("mic"),
    "mk" to LanguageTag.parse("mk"),
    "ml" to LanguageTag.parse("ml"),
    "mn" to LanguageTag.parse("mn"),
    "mn-Mong" to LanguageTag.parse("mn-Mong"),
    "mn-Mong-MN" to LanguageTag.parse("mn-Mong-MN"),
    "mni" to LanguageTag.parse("mni"),
    "mni-Beng" to LanguageTag.parse("mni-Beng"),
    "mni-Mtei" to LanguageTag.parse("mni-Mtei"),
    "moh" to LanguageTag.parse("moh"),
    "mr" to LanguageTag.parse("mr"),
    "ms" to LanguageTag.parse("ms"),
    "ms-Arab" to LanguageTag.parse("ms-Arab"),
    "ms-Arab-BN" to LanguageTag.parse("ms-Arab-BN"),
    "ms-BN" to LanguageTag.parse("ms-BN"),
    "ms-ID" to LanguageTag.parse("ms-ID"),
    "ms-SG" to LanguageTag.parse("ms-SG"),
    "mt" to LanguageTag.parse("mt"),
    "mua" to LanguageTag.parse("mua"),
    "mus" to LanguageTag.parse("mus"),
    "my" to LanguageTag.parse("my"),
    "myv" to LanguageTag.parse("myv"),
    "mzn" to LanguageTag.parse("mzn"),
    "naq" to LanguageTag.parse("naq"),
    "nb" to LanguageTag.parse("nb"),
    "nb-SJ" to LanguageTag.parse("nb-SJ"),
    "nd" to LanguageTag.parse("nd"),
    "nds" to LanguageTag.parse("nds"),
    "nds-NL" to LanguageTag.parse("nds-NL"),
    "ne" to LanguageTag.parse("ne"),
    "ne-IN" to LanguageTag.parse("ne-IN"),
    "nl" to LanguageTag.parse("nl"),
    "nl-AW" to LanguageTag.parse("nl-AW"),
    "nl-BE" to LanguageTag.parse("nl-BE"),
    "nl-BQ" to LanguageTag.parse("nl-BQ"),
    "nl-CW" to LanguageTag.parse("nl-CW"),
    "nl-SR" to LanguageTag.parse("nl-SR"),
    "nl-SX" to LanguageTag.parse("nl-SX"),
    "nmg" to LanguageTag.parse("nmg"),
    "nn" to LanguageTag.parse("nn"),
    "nnh" to LanguageTag.parse("nnh"),
    "no" to LanguageTag.parse("no"),
    "nqo" to LanguageTag.parse("nqo"),
    "nr" to LanguageTag.parse("nr"),
    "nso" to LanguageTag.parse("nso"),
    "nus" to LanguageTag.parse("nus"),
    "nv" to LanguageTag.parse("nv"),
    "ny" to LanguageTag.parse("ny"),
    "nyn" to LanguageTag.parse("nyn"),
    "oc" to LanguageTag.parse("oc"),
    "oc-ES" to LanguageTag.parse("oc-ES"),
    "om" to LanguageTag.parse("om"),
    "om-KE" to LanguageTag.parse("om-KE"),
    "or" to LanguageTag.parse("or"),
    "os" to LanguageTag.parse("os"),
    "os-RU" to LanguageTag.parse("os-RU"),
    "osa" to LanguageTag.parse("osa"),
    "pa" to LanguageTag.parse("pa"),
    "pa-Arab" to LanguageTag.parse("pa-Arab"),
    "pa-Guru" to LanguageTag.parse("pa-Guru"),
    "pap" to LanguageTag.parse("pap"),
    "pap-AW" to LanguageTag.parse("pap-AW"),
    "pcm" to LanguageTag.parse("pcm"),
    "pis" to LanguageTag.parse("pis"),
    "pl" to LanguageTag.parse("pl"),
    "prg" to LanguageTag.parse("prg"),
    "ps" to LanguageTag.parse("ps"),
    "ps-PK" to LanguageTag.parse("ps-PK"),
    "pt" to LanguageTag.parse("pt"),
    "pt-AO" to LanguageTag.parse("pt-AO"),
    "pt-CH" to LanguageTag.parse("pt-CH"),
    "pt-CV" to LanguageTag.parse("pt-CV"),
    "pt-GQ" to LanguageTag.parse("pt-GQ"),
    "pt-GW" to LanguageTag.parse("pt-GW"),
    "pt-LU" to LanguageTag.parse("pt-LU"),
    "pt-MO" to LanguageTag.parse("pt-MO"),
    "pt-MZ" to LanguageTag.parse("pt-MZ"),
    "pt-PT" to LanguageTag.parse("pt-PT"),
    "pt-ST" to LanguageTag.parse("pt-ST"),
    "pt-TL" to LanguageTag.parse("pt-TL"),
    "qu" to LanguageTag.parse("qu"),
    "qu-BO" to LanguageTag.parse("qu-BO"),
    "qu-EC" to LanguageTag.parse("qu-EC"),
    "quc" to LanguageTag.parse("quc"),
    "raj" to LanguageTag.parse("raj"),
    "rhg" to LanguageTag.parse("rhg"),
    "rhg-Rohg" to LanguageTag.parse("rhg-Rohg"),
    "rhg-Rohg-BD" to LanguageTag.parse("rhg-Rohg-BD"),
    "rif" to LanguageTag.parse("rif"),
    "rm" to LanguageTag.parse("rm"),
    "rn" to LanguageTag.parse("rn"),
    "ro" to LanguageTag.parse("ro"),
    "ro-MD" to LanguageTag.parse("ro-MD"),
    "rof" to LanguageTag.parse("rof"),
    "ru" to LanguageTag.parse("ru"),
    "ru-BY" to LanguageTag.parse("ru-BY"),
    "ru-KG" to LanguageTag.parse("ru-KG"),
    "ru-KZ" to LanguageTag.parse("ru-KZ"),
    "ru-MD" to LanguageTag.parse("ru-MD"),
    "ru-UA" to LanguageTag.parse("ru-UA"),
    "rw" to LanguageTag.parse("rw"),
    "rwk" to LanguageTag.parse("rwk"),
    "sa" to LanguageTag.parse("sa"),
    "sah" to LanguageTag.parse("sah"),
    "saq" to LanguageTag.parse("saq"),
    "sat" to LanguageTag.parse("sat"),
    "sat-Deva" to LanguageTag.parse("sat-Deva"),
    "sat-Olck" to LanguageTag.parse("sat-Olck"),
    "sbp" to LanguageTag.parse("sbp"),
    "sc" to LanguageTag.parse("sc"),
    "scn" to LanguageTag.parse("scn"),
    "sd" to LanguageTag.parse("sd"),
    "sd-Arab" to LanguageTag.parse("sd-Arab"),
    "sd-Deva" to LanguageTag.parse("sd-Deva"),
    "sdh" to LanguageTag.parse("sdh"),
    "sdh-IQ" to LanguageTag.parse("sdh-IQ"),
    "se" to LanguageTag.parse("se"),
    "se-FI" to LanguageTag.parse("se-FI"),
    "se-SE" to LanguageTag.parse("se-SE"),
    "seh" to LanguageTag.parse("seh"),
    "ses" to LanguageTag.parse("ses"),
    "sg" to LanguageTag.parse("sg"),
    "shi" to LanguageTag.parse("shi"),
    "shi-Latn" to LanguageTag.parse("shi-Latn"),
    "shi-Tfng" to LanguageTag.parse("shi-Tfng"),
    "shn" to LanguageTag.parse("shn"),
    "shn-TH" to LanguageTag.parse("shn-TH"),
    "si" to LanguageTag.parse("si"),
    "sid" to LanguageTag.parse("sid"),
    "sk" to LanguageTag.parse("sk"),
    "skr" to LanguageTag.parse("skr"),
    "sl" to LanguageTag.parse("sl"),
    "sma" to LanguageTag.parse("sma"),
    "sma-NO" to LanguageTag.parse("sma-NO"),
    "smj" to LanguageTag.parse("smj"),
    "smj-NO" to LanguageTag.parse("smj-NO"),
    "smn" to LanguageTag.parse("smn"),
    "sms" to LanguageTag.parse("sms"),
    "sn" to LanguageTag.parse("sn"),
    "so" to LanguageTag.parse("so"),
    "so-DJ" to LanguageTag.parse("so-DJ"),
    "so-ET" to LanguageTag.parse("so-ET"),
    "so-KE" to LanguageTag.parse("so-KE"),
    "sq" to LanguageTag.parse("sq"),
    "sq-MK" to LanguageTag.parse("sq-MK"),
    "sq-XK" to LanguageTag.parse("sq-XK"),
    "sr" to LanguageTag.parse("sr"),
    "sr-Cyrl" to LanguageTag.parse("sr-Cyrl"),
    "sr-Cyrl-BA" to LanguageTag.parse("sr-Cyrl-BA"),
    "sr-Cyrl-ME" to LanguageTag.parse("sr-Cyrl-ME"),
    "sr-Cyrl-XK" to LanguageTag.parse("sr-Cyrl-XK"),
    "sr-Latn" to LanguageTag.parse("sr-Latn"),
    "sr-Latn-BA" to LanguageTag.parse("sr-Latn-BA"),
    "sr-Latn-ME" to LanguageTag.parse("sr-Latn-ME"),
    "sr-Latn-XK" to LanguageTag.parse("sr-Latn-XK"),
    "ss" to LanguageTag.parse("ss"),
    "ss-SZ" to LanguageTag.parse("ss-SZ"),
    "ssy" to LanguageTag.parse("ssy"),
    "st" to LanguageTag.parse("st"),
    "st-LS" to LanguageTag.parse("st-LS"),
    "su" to LanguageTag.parse("su"),
    "su-Latn" to LanguageTag.parse("su-Latn"),
    "sv" to LanguageTag.parse("sv"),
    "sv-AX" to LanguageTag.parse("sv-AX"),
    "sv-FI" to LanguageTag.parse("sv-FI"),
    "sw" to LanguageTag.parse("sw"),
    "sw-CD" to LanguageTag.parse("sw-CD"),
    "sw-KE" to LanguageTag.parse("sw-KE"),
    "sw-UG" to LanguageTag.parse("sw-UG"),
    "syr" to LanguageTag.parse("syr"),
    "syr-SY" to LanguageTag.parse("syr-SY"),
    "szl" to LanguageTag.parse("szl"),
    "ta" to LanguageTag.parse("ta"),
    "ta-LK" to LanguageTag.parse("ta-LK"),
    "ta-MY" to LanguageTag.parse("ta-MY"),
    "ta-SG" to LanguageTag.parse("ta-SG"),
    "te" to LanguageTag.parse("te"),
    "teo" to LanguageTag.parse("teo"),
    "teo-KE" to LanguageTag.parse("teo-KE"),
    "tg" to LanguageTag.parse("tg"),
    "th" to LanguageTag.parse("th"),
    "ti" to LanguageTag.parse("ti"),
    "ti-ER" to LanguageTag.parse("ti-ER"),
    "tig" to LanguageTag.parse("tig"),
    "tk" to LanguageTag.parse("tk"),
    "tn" to LanguageTag.parse("tn"),
    "tn-BW" to LanguageTag.parse("tn-BW"),
    "to" to LanguageTag.parse("to"),
    "tok" to LanguageTag.parse("tok"),
    "tpi" to LanguageTag.parse("tpi"),
    "tr" to LanguageTag.parse("tr"),
    "tr-CY" to LanguageTag.parse("tr-CY"),
    "trv" to LanguageTag.parse("trv"),
    "trw" to LanguageTag.parse("trw"),
    "ts" to LanguageTag.parse("ts"),
    "tt" to LanguageTag.parse("tt"),
    "twq" to LanguageTag.parse("twq"),
    "tyv" to LanguageTag.parse("tyv"),
    "tzm" to LanguageTag.parse("tzm"),
    "ug" to LanguageTag.parse("ug"),
    "uk" to LanguageTag.parse("uk"),
    "und" to LanguageTag.parse("und"),
    "ur" to LanguageTag.parse("ur"),
    "ur-IN" to LanguageTag.parse("ur-IN"),
    "uz" to LanguageTag.parse("uz"),
    "uz-Arab" to LanguageTag.parse("uz-Arab"),
    "uz-Cyrl" to LanguageTag.parse("uz-Cyrl"),
    "uz-Latn" to LanguageTag.parse("uz-Latn"),
    "vai" to LanguageTag.parse("vai"),
    "vai-Latn" to LanguageTag.parse("vai-Latn"),
    "vai-Vaii" to LanguageTag.parse("vai-Vaii"),
    "ve" to LanguageTag.parse("ve"),
    "vec" to LanguageTag.parse("vec"),
    "vi" to LanguageTag.parse("vi"),
    "vmw" to LanguageTag.parse("vmw"),
    "vo" to LanguageTag.parse("vo"),
    "vun" to LanguageTag.parse("vun"),
    "wa" to LanguageTag.parse("wa"),
    "wae" to LanguageTag.parse("wae"),
    "wal" to LanguageTag.parse("wal"),
    "wbp" to LanguageTag.parse("wbp"),
    "wo" to LanguageTag.parse("wo"),
    "xh" to LanguageTag.parse("xh"),
    "xnr" to LanguageTag.parse("xnr"),
    "xog" to LanguageTag.parse("xog"),
    "yav" to LanguageTag.parse("yav"),
    "yi" to LanguageTag.parse("yi"),
    "yo" to LanguageTag.parse("yo"),
    "yo-BJ" to LanguageTag.parse("yo-BJ"),
    "yrl" to LanguageTag.parse("yrl"),
    "yrl-CO" to LanguageTag.parse("yrl-CO"),
    "yrl-VE" to LanguageTag.parse("yrl-VE"),
    "yue" to LanguageTag.parse("yue"),
    "yue-Hans" to LanguageTag.parse("yue-Hans"),
    "yue-Hant" to LanguageTag.parse("yue-Hant"),
    "yue-Hant-CN" to LanguageTag.parse("yue-Hant-CN"),
    "za" to LanguageTag.parse("za"),
    "zgh" to LanguageTag.parse("zgh"),
    "zh" to LanguageTag.parse("zh"),
    "zh-Hans" to LanguageTag.parse("zh-Hans"),
    "zh-Hans-HK" to LanguageTag.parse("zh-Hans-HK"),
    "zh-Hans-MO" to LanguageTag.parse("zh-Hans-MO"),
    "zh-Hans-MY" to LanguageTag.parse("zh-Hans-MY"),
    "zh-Hans-SG" to LanguageTag.parse("zh-Hans-SG"),
    "zh-Hant" to LanguageTag.parse("zh-Hant"),
    "zh-Hant-HK" to LanguageTag.parse("zh-Hant-HK"),
    "zh-Hant-MO" to LanguageTag.parse("zh-Hant-MO"),
    "zh-Hant-MY" to LanguageTag.parse("zh-Hant-MY"),
    "zh-Latn" to LanguageTag.parse("zh-Latn"),
    "zu" to LanguageTag.parse("zu"),
  )
}
