/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.i18n.datetime;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.csv.reader.CsvReader;
import net.codinux.csv.reader.CsvRow;
import net.codinux.i18n.LanguageTag;
import net.codinux.i18n.datetime.AllLocalizedDateTimeFormats;
import net.codinux.i18n.datetime.DateOrTimeFormats;
import net.codinux.i18n.datetime.LocalizedDateTimeFormats;
import net.codinux.i18n.datetime.LocalizedDateTimeFormatsLookup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/codinux/i18n/datetime/LocalizedDateTimeFormatsResolver;", "", "()V", "csvReader", "Lnet/codinux/csv/reader/CsvReader;", "getDateTimeFormatsForLocale", "Lnet/codinux/i18n/datetime/LocalizedDateTimeFormats;", "locale", "Lnet/codinux/i18n/LanguageTag;", "getDateTimeFormatsForLocaleOrNull", "mapFormat", "Lnet/codinux/i18n/datetime/DateOrTimeFormats;", "formatsCsv", "", "mapFormats", "lookup", "Lnet/codinux/i18n/datetime/LocalizedDateTimeFormatsLookup;", "Companion", "k-i18n"})
public final class LocalizedDateTimeFormatsResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CsvReader csvReader = new CsvReader('|');
    public static final char CsvFormatsSeparator = '|';

    @NotNull
    public final LocalizedDateTimeFormats getDateTimeFormatsForLocale(@NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        LocalizedDateTimeFormats localizedDateTimeFormats = this.getDateTimeFormatsForLocaleOrNull(locale);
        if (localizedDateTimeFormats == null) {
            throw new IllegalArgumentException("Localized date time formats not found for locale '" + locale + "' or its parents. Are you sure this locale exists?");
        }
        return localizedDateTimeFormats;
    }

    @Nullable
    public final LocalizedDateTimeFormats getDateTimeFormatsForLocaleOrNull(@NotNull LanguageTag locale) {
        LanguageTag parent2;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        LocalizedDateTimeFormatsLookup lookup = AllLocalizedDateTimeFormats.INSTANCE.getDateTimeFormatsForLocale(locale.getTag());
        LanguageTag languageTag = locale.getParent();
        if (languageTag == null) {
            languageTag = parent2 = LanguageTag.Companion.getRoot();
        }
        while ((lookup.getDate() == null || lookup.getTime() == null || lookup.getDateTime() == null) && parent2 != null) {
            LanguageTag languageTag2;
            LocalizedDateTimeFormatsLookup parentLookup = AllLocalizedDateTimeFormats.INSTANCE.getDateTimeFormatsForLocale(parent2.getTag());
            if (lookup.getDate() == null) {
                lookup.setDate(parentLookup.getDate());
            }
            if (lookup.getTime() == null) {
                lookup.setTime(parentLookup.getTime());
            }
            if (lookup.getDateTime() == null) {
                lookup.setDateTime(parentLookup.getDateTime());
            }
            if (Intrinsics.areEqual((Object)parent2, (Object)LanguageTag.Companion.getRoot())) {
                languageTag2 = null;
            } else {
                languageTag2 = parent2.getParent();
                if (languageTag2 == null) {
                    languageTag2 = LanguageTag.Companion.getRoot();
                }
            }
            parent2 = languageTag2;
        }
        return this.mapFormats(lookup);
    }

    private final LocalizedDateTimeFormats mapFormats(LocalizedDateTimeFormatsLookup lookup) {
        if (lookup.getDate() == null || lookup.getTime() == null || lookup.getDateTime() == null) {
            return null;
        }
        String string = lookup.getDate();
        Intrinsics.checkNotNull((Object)string);
        DateOrTimeFormats dateOrTimeFormats = this.mapFormat(string);
        String string2 = lookup.getTime();
        Intrinsics.checkNotNull((Object)string2);
        DateOrTimeFormats dateOrTimeFormats2 = this.mapFormat(string2);
        String string3 = lookup.getDateTime();
        Intrinsics.checkNotNull((Object)string3);
        return new LocalizedDateTimeFormats(dateOrTimeFormats, dateOrTimeFormats2, this.mapFormat(string3));
    }

    private final DateOrTimeFormats mapFormat(String formatsCsv) {
        CsvRow formatsRow = (CsvRow)CollectionsKt.first((Iterable)((Iterable)this.csvReader.read(formatsCsv)));
        return new DateOrTimeFormats(formatsRow.getString(0), formatsRow.getString(1), formatsRow.getString(2), formatsRow.getString(3));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/codinux/i18n/datetime/LocalizedDateTimeFormatsResolver$Companion;", "", "()V", "CsvFormatsSeparator", "", "k-i18n"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

