/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.i18n;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.codinux.i18n.Language;
import net.codinux.i18n.LanguageTag;
import net.codinux.i18n.ParentLocales;
import net.codinux.i18n.Region;
import net.codinux.i18n.Script;
import net.codinux.i18n.Variant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0004J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u00a8\u0006\u001a"}, d2={"Lnet/codinux/i18n/LanguageTagService;", "", "()V", "createTag", "", "language", "Lnet/codinux/i18n/Language;", "region", "Lnet/codinux/i18n/Region;", "script", "Lnet/codinux/i18n/Script;", "variant", "Lnet/codinux/i18n/Variant;", "findLanguage", "findLanguageOrNull", "findRegionOrNull", "regionCode", "findScriptOrNull", "scriptCode", "findVariantOrNull", "variantCode", "parse", "Lnet/codinux/i18n/LanguageTag;", "languageTag", "parseOrNull", "tryFindParent", "k-i18n"})
@SourceDebugExtension(value={"SMAP\nLanguageTagService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageTagService.kt\nnet/codinux/i18n/LanguageTagService\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1083#2,2:136\n1064#2,2:139\n1064#2,2:143\n1064#2,2:147\n288#3:138\n289#3:141\n288#3:142\n289#3:145\n288#3:146\n289#3:149\n288#3,2:150\n288#3,2:152\n288#3,2:154\n288#3,2:156\n*S KotlinDebug\n*F\n+ 1 LanguageTagService.kt\nnet/codinux/i18n/LanguageTagService\n*L\n10#1:136,2\n16#1:139,2\n20#1:143,2\n23#1:147,2\n14#1:138\n14#1:141\n20#1:142\n20#1:145\n23#1:146\n23#1:149\n116#1:150,2\n123#1:152,2\n130#1:154,2\n133#1:156,2\n*E\n"})
public final class LanguageTagService {
    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final LanguageTag parseOrNull(@NotNull String languageTag) {
        Object v11;
        String scriptCode;
        String regionCode;
        String languageCode;
        List parts;
        String tag;
        block23: {
            Object element$iv;
            boolean bl;
            Object v7;
            block21: {
                Object element$iv2;
                boolean bl2;
                int element$iv3;
                Object v3;
                block18: {
                    Object element$iv4;
                    boolean bl3;
                    Intrinsics.checkNotNullParameter((Object)languageTag, (String)"languageTag");
                    tag = StringsKt.replace$default((String)languageTag, (char)'_', (char)'-', (boolean)false, (int)4, null);
                    char[] cArray = new char[]{'-'};
                    parts = StringsKt.split$default((CharSequence)tag, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    languageCode = (String)parts.get(0);
                    int n = languageCode.length();
                    if (2 > n) return null;
                    if (n >= 4) return null;
                    boolean bl4 = true;
                    if (!bl4) return null;
                    CharSequence $this$any$iv = languageCode;
                    boolean $i$f$any = false;
                    for (int i = 0; i < $this$any$iv.length(); ++i) {
                        char element$iv5;
                        char it = element$iv5 = $this$any$iv.charAt(i);
                        boolean bl5 = false;
                        if (Character.isLetter(it) && !Character.isLowerCase(it)) {
                            return null;
                        }
                        boolean bl6 = false;
                        if (!bl6) continue;
                        return null;
                    }
                    boolean bl7 = false;
                    if (bl7) {
                        return null;
                    }
                    Iterable $this$firstOrNull$iv = CollectionsKt.drop((Iterable)parts, (int)1);
                    boolean $i$f$firstOrNull = false;
                    Iterator element$iv5 = $this$firstOrNull$iv.iterator();
                    do {
                        block29: {
                            block28: {
                                boolean bl8;
                                block20: {
                                    int it;
                                    int n2;
                                    boolean $i$f$all;
                                    CharSequence $this$all$iv;
                                    String it2;
                                    block26: {
                                        boolean bl9;
                                        block19: {
                                            block27: {
                                                block25: {
                                                    if (!element$iv5.hasNext()) break block25;
                                                    element$iv4 = element$iv5.next();
                                                    it2 = (String)element$iv4;
                                                    boolean bl10 = false;
                                                    if (it2.length() != 2) break block26;
                                                    $this$all$iv = it2;
                                                    $i$f$all = false;
                                                    break block27;
                                                }
                                                v3 = null;
                                                break block18;
                                            }
                                            for (n2 = 0; n2 < $this$all$iv.length(); ++n2) {
                                                it = element$iv3 = $this$all$iv.charAt(n2);
                                                boolean bl11 = false;
                                                if (Character.isUpperCase((char)it)) continue;
                                                bl9 = false;
                                                break block19;
                                            }
                                            bl9 = true;
                                        }
                                        if (bl9) break block28;
                                    }
                                    if (it2.length() != 3) break block29;
                                    $this$all$iv = it2;
                                    $i$f$all = false;
                                    for (n2 = 0; n2 < $this$all$iv.length(); ++n2) {
                                        it = element$iv3 = $this$all$iv.charAt(n2);
                                        boolean bl12 = false;
                                        if (Character.isDigit((char)it)) continue;
                                        bl8 = false;
                                        break block20;
                                    }
                                    bl8 = true;
                                }
                                if (!bl8) break block29;
                            }
                            bl3 = true;
                            continue;
                        }
                        bl3 = false;
                    } while (!bl3);
                    v3 = element$iv4;
                }
                regionCode = v3;
                Iterable $this$firstOrNull$iv = CollectionsKt.drop((Iterable)parts, (int)1);
                boolean $i$f$firstOrNull = false;
                Iterator element$iv4 = $this$firstOrNull$iv.iterator();
                do {
                    block31: {
                        boolean bl13;
                        block22: {
                            CharSequence $this$all$iv;
                            block32: {
                                block30: {
                                    if (!element$iv4.hasNext()) break block30;
                                    element$iv2 = element$iv4.next();
                                    String it = (String)element$iv2;
                                    boolean bl14 = false;
                                    if (it.length() != 4 || !Character.isUpperCase(it.charAt(0))) break block31;
                                    $this$all$iv = StringsKt.drop((String)it, (int)1);
                                    boolean $i$f$all = false;
                                    break block32;
                                }
                                v7 = null;
                                break block21;
                            }
                            for (element$iv3 = 0; element$iv3 < $this$all$iv.length(); ++element$iv3) {
                                char element$iv6;
                                char it = element$iv6 = $this$all$iv.charAt(element$iv3);
                                boolean bl15 = false;
                                if (Character.isLowerCase(it)) continue;
                                bl13 = false;
                                break block22;
                            }
                            bl13 = true;
                        }
                        if (bl13) {
                            bl2 = true;
                            continue;
                        }
                    }
                    bl2 = false;
                } while (!bl2);
                v7 = element$iv2;
            }
            scriptCode = v7;
            Iterable $this$firstOrNull$iv = CollectionsKt.drop((Iterable)parts, (int)1);
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            do {
                block34: {
                    boolean bl16;
                    block24: {
                        CharSequence $this$all$iv;
                        block35: {
                            block33: {
                                if (!iterator.hasNext()) break block33;
                                element$iv = iterator.next();
                                String it = (String)element$iv;
                                boolean bl17 = false;
                                int $i$f$all = it.length();
                                boolean bl18 = 5 <= $i$f$all ? $i$f$all < 9 : false;
                                if (!bl18) break block34;
                                $this$all$iv = it;
                                boolean $i$f$all2 = false;
                                break block35;
                            }
                            v11 = null;
                            break block23;
                        }
                        for (int i = 0; i < $this$all$iv.length(); ++i) {
                            char element$iv7;
                            char it = element$iv7 = $this$all$iv.charAt(i);
                            boolean bl19 = false;
                            if (Character.isLowerCase(it)) continue;
                            bl16 = false;
                            break block24;
                        }
                        bl16 = true;
                    }
                    if (bl16) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            v11 = element$iv;
        }
        String variant2 = v11;
        int countNonNull = (regionCode == null ? 0 : 1) + (scriptCode == null ? 0 : 1) + (variant2 != null ? 0 : 1);
        if (parts.size() == 2) {
            if (countNonNull == 1) return null;
        }
        if (parts.size() == 3) {
            if (countNonNull == 2) return null;
        }
        if (parts.size() == 4) {
            if (countNonNull == 3) return null;
        }
        if (parts.size() > 4) return null;
        return new LanguageTag(tag, languageCode, regionCode, scriptCode, variant2, null, null, null, null, 480, null);
    }

    @NotNull
    public final LanguageTag parse(@NotNull String languageTag) {
        Intrinsics.checkNotNullParameter((Object)languageTag, (String)"languageTag");
        LanguageTag languageTag2 = this.parseOrNull(languageTag);
        if (languageTag2 == null) {
            throw new IllegalArgumentException("Cannot create a LanguageTag from string '" + languageTag + "'. A valid LanguageTag starts with two- or three lower case characters for the language, see [Language] class for available values. Optionally, all separated by hyphens, a two-letter upper case or three-digit region code and a four-letter script code in title case follow.");
        }
        return languageTag2;
    }

    @NotNull
    public final String createTag(@NotNull Language language2, @Nullable Region region2, @Nullable Script script2, @Nullable Variant variant2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        StringBuilder builder = new StringBuilder(language2.getIsoCode());
        if (script2 != null) {
            builder.append("-" + script2.getCode());
        }
        if (region2 != null) {
            builder.append("-" + region2.getCode());
        }
        if (variant2 != null) {
            builder.append("-" + variant2.getCode());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public final LanguageTag tryFindParent(@NotNull LanguageTag languageTag) {
        Language language2;
        Intrinsics.checkNotNullParameter((Object)languageTag, (String)"languageTag");
        LanguageTag fromParentLocales = (LanguageTag)ParentLocales.INSTANCE.getParentLocales().get((Object)languageTag.getTag());
        if (fromParentLocales != null) {
            return Intrinsics.areEqual((Object)fromParentLocales, (Object)LanguageTag.Companion.getRoot()) ? null : fromParentLocales;
        }
        return languageTag.getVariantCode() != null ? LanguageTag.Companion.parse(StringsKt.replace$default((String)languageTag.getTag(), (String)("-" + languageTag.getVariantCode()), (String)"", (boolean)false, (int)4, null)) : (languageTag.getRegionCode() != null ? LanguageTag.Companion.parse(StringsKt.replace$default((String)languageTag.getTag(), (String)("-" + languageTag.getRegionCode()), (String)"", (boolean)false, (int)4, null)) : (languageTag.getScriptCode() != null && Intrinsics.areEqual((Object)languageTag.getScriptCode(), (language2 = languageTag.getLanguage()) != null && (language2 = language2.getDefaultScript()) != null ? language2.getCode() : null) ? LanguageTag.Companion.parse(StringsKt.replace$default((String)languageTag.getTag(), (String)("-" + languageTag.getScriptCode()), (String)"", (boolean)false, (int)4, null)) : null));
    }

    @Nullable
    public final Language findLanguageOrNull(@NotNull String language2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
            Iterable $this$firstOrNull$iv = (Iterable)EntriesMappings.entries$0;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Language it = (Language)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getIsoCode(), (String)language2, (boolean)true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Language findLanguage(@NotNull String language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Language language3 = this.findLanguageOrNull(language2);
        if (language3 == null) {
            throw new IllegalArgumentException("Language with ISO code '" + language2 + "' not found in Language enum. Parameter language must be a two- or three-letter ISO 639 language code. See Language enum for possible values.");
        }
        return language3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Region findRegionOrNull(@NotNull String regionCode) {
        Object element$iv;
        Object v0;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)regionCode, (String)"regionCode");
        Iterable $this$firstOrNull$iv = (Iterable)EntriesMappings.entries$1;
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            block6: {
                block5: {
                    if (!iterator.hasNext()) {
                        v0 = null;
                        return v0;
                    }
                    element$iv = iterator.next();
                    Region it = (Region)element$iv;
                    boolean bl2 = false;
                    if (StringsKt.equals((String)regionCode, (String)it.getAlpha2Code(), (boolean)true) || StringsKt.equals((String)regionCode, (String)it.getAlpha3Code(), (boolean)true) || StringsKt.equals((String)regionCode, (String)it.getNumericCodeAsString(), (boolean)true)) break block5;
                    Integer n = it.getNumericCode();
                    if (!StringsKt.equals((String)regionCode, (String)(n != null ? n.toString() : null), (boolean)true)) break block6;
                }
                bl = true;
                continue;
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    @Nullable
    public final Script findScriptOrNull(@NotNull String scriptCode) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)scriptCode, (String)"scriptCode");
            Iterable $this$firstOrNull$iv = (Iterable)EntriesMappings.entries$2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Script it = (Script)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)scriptCode, (String)it.getCode(), (boolean)true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Variant findVariantOrNull(@NotNull String variantCode) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)variantCode, (String)"variantCode");
            Iterable $this$firstOrNull$iv = (Iterable)EntriesMappings.entries$3;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Variant it = (Variant)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)variantCode, (String)it.getCode(), (boolean)true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Language> entries$0;
        public static final /* synthetic */ EnumEntries<Region> entries$1;
        public static final /* synthetic */ EnumEntries<Script> entries$2;
        public static final /* synthetic */ EnumEntries<Variant> entries$3;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Language.values()));
            entries$1 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Region.values()));
            entries$2 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Script.values()));
            entries$3 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Variant.values()));
        }
    }
}

