/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.i18n.datetime;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.csv.reader.CsvReader;
import net.codinux.csv.reader.CsvRow;
import net.codinux.i18n.LanguageTag;
import net.codinux.i18n.datetime.DateTimeDisplayNames;
import net.codinux.i18n.datetime.DateTimeDisplayNamesLookup;
import net.codinux.i18n.datetime.DateTimeDisplayNamesResolver;
import net.codinux.i18n.datetime.DayDisplayNames;
import net.codinux.i18n.datetime.DayPeriodDisplayNames;
import net.codinux.i18n.datetime.DisplayNameSet;
import net.codinux.i18n.datetime.MonthDisplayNames;
import net.codinux.i18n.datetime.QuarterDisplayNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00170 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/codinux/i18n/datetime/DateTimeDisplayNamesResolver;", "", "()V", "csvReader", "Lnet/codinux/csv/reader/CsvReader;", "getLocalizedFormatDisplayNames", "Lnet/codinux/i18n/datetime/DateTimeDisplayNames;", "locale", "Lnet/codinux/i18n/LanguageTag;", "getLocalizedStandaloneDisplayNames", "mapDayDisplayNames", "Lnet/codinux/i18n/datetime/DayDisplayNames;", "row", "Lnet/codinux/csv/reader/CsvRow;", "mapDayPeriodDisplayNames", "Lnet/codinux/i18n/datetime/DayPeriodDisplayNames;", "mapDayPeriods", "Lnet/codinux/i18n/datetime/DisplayNameSet;", "csv", "", "mapDays", "mapDisplayNames", "lookup", "Lnet/codinux/i18n/datetime/DateTimeDisplayNamesLookup;", "mapMonthDisplayNames", "Lnet/codinux/i18n/datetime/MonthDisplayNames;", "mapMonths", "mapQuarterDisplayNames", "Lnet/codinux/i18n/datetime/QuarterDisplayNames;", "mapQuarters", "resolve", "getDisplayNames", "Lkotlin/Function1;", "Companion", "k-i18n"})
public final class DateTimeDisplayNamesResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CsvReader csvReader = new CsvReader('|');
    public static final char CsvFormatsSeparator = '|';

    @Nullable
    public final DateTimeDisplayNames getLocalizedFormatDisplayNames(@NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.resolve(locale, (Function1<? super LanguageTag, DateTimeDisplayNamesLookup>)((Function1)getLocalizedFormatDisplayNames.1.INSTANCE));
    }

    @Nullable
    public final DateTimeDisplayNames getLocalizedStandaloneDisplayNames(@NotNull LanguageTag locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.resolve(locale, (Function1<? super LanguageTag, DateTimeDisplayNamesLookup>)((Function1)getLocalizedStandaloneDisplayNames.1.INSTANCE));
    }

    private final DateTimeDisplayNames resolve(LanguageTag locale, Function1<? super LanguageTag, DateTimeDisplayNamesLookup> getDisplayNames) {
        LanguageTag parent2;
        DateTimeDisplayNamesLookup lookup = (DateTimeDisplayNamesLookup)getDisplayNames.invoke((Object)locale);
        LanguageTag languageTag = locale.getParent();
        if (languageTag == null) {
            languageTag = parent2 = LanguageTag.Companion.getRoot();
        }
        while ((lookup.getMonths() == null || lookup.getDays() == null || lookup.getQuarters() == null || lookup.getDayPeriods() == null) && parent2 != null) {
            LanguageTag languageTag2;
            DateTimeDisplayNamesLookup parentLookup = (DateTimeDisplayNamesLookup)getDisplayNames.invoke((Object)parent2);
            if (lookup.getMonths() == null) {
                lookup.setMonths(parentLookup.getMonths());
            }
            if (lookup.getDays() == null) {
                lookup.setDays(parentLookup.getDays());
            }
            if (lookup.getQuarters() == null) {
                lookup.setQuarters(parentLookup.getQuarters());
            }
            if (lookup.getDayPeriods() == null) {
                lookup.setDayPeriods(parentLookup.getDayPeriods());
            }
            if (Intrinsics.areEqual((Object)parent2, (Object)LanguageTag.Companion.getRoot())) {
                languageTag2 = null;
            } else {
                languageTag2 = parent2.getParent();
                if (languageTag2 == null) {
                    languageTag2 = LanguageTag.Companion.getRoot();
                }
            }
            parent2 = languageTag2;
        }
        return this.mapDisplayNames(lookup);
    }

    private final DateTimeDisplayNames mapDisplayNames(DateTimeDisplayNamesLookup lookup) {
        if (lookup.getMonths() == null || lookup.getDays() == null || lookup.getQuarters() == null || lookup.getDayPeriods() == null) {
            return null;
        }
        String string = lookup.getMonths();
        Intrinsics.checkNotNull((Object)string);
        DisplayNameSet<MonthDisplayNames> displayNameSet = this.mapMonths(string);
        String string2 = lookup.getDays();
        Intrinsics.checkNotNull((Object)string2);
        DisplayNameSet<DayDisplayNames> displayNameSet2 = this.mapDays(string2);
        String string3 = lookup.getQuarters();
        Intrinsics.checkNotNull((Object)string3);
        DisplayNameSet<QuarterDisplayNames> displayNameSet3 = this.mapQuarters(string3);
        String string4 = lookup.getDayPeriods();
        Intrinsics.checkNotNull((Object)string4);
        return new DateTimeDisplayNames(displayNameSet, displayNameSet2, displayNameSet3, this.mapDayPeriods(string4));
    }

    private final DisplayNameSet<MonthDisplayNames> mapMonths(String csv) {
        List rows = CollectionsKt.toList((Iterable)((Iterable)this.csvReader.read(csv)));
        return new DisplayNameSet<MonthDisplayNames>(this.mapMonthDisplayNames((CsvRow)rows.get(0)), this.mapMonthDisplayNames((CsvRow)rows.get(1)), this.mapMonthDisplayNames((CsvRow)rows.get(2)), null, 8, null);
    }

    private final MonthDisplayNames mapMonthDisplayNames(CsvRow row) {
        return new MonthDisplayNames(row.getString(0), row.getString(1), row.getString(2), row.getString(3), row.getString(4), row.getString(5), row.getString(6), row.getString(7), row.getString(8), row.getString(9), row.getString(10), row.getString(11));
    }

    private final DisplayNameSet<DayDisplayNames> mapDays(String csv) {
        List rows = CollectionsKt.toList((Iterable)((Iterable)this.csvReader.read(csv)));
        return new DisplayNameSet<Object>(this.mapDayDisplayNames((CsvRow)rows.get(0)), this.mapDayDisplayNames((CsvRow)rows.get(1)), this.mapDayDisplayNames((CsvRow)rows.get(2)), (rows.size() > 3 ? this.mapDayDisplayNames((CsvRow)rows.get(3)) : null));
    }

    private final DayDisplayNames mapDayDisplayNames(CsvRow row) {
        return new DayDisplayNames(row.getString(0), row.getString(1), row.getString(2), row.getString(3), row.getString(4), row.getString(5), row.getString(6));
    }

    private final DisplayNameSet<QuarterDisplayNames> mapQuarters(String csv) {
        List rows = CollectionsKt.toList((Iterable)((Iterable)this.csvReader.read(csv)));
        return new DisplayNameSet<QuarterDisplayNames>(this.mapQuarterDisplayNames((CsvRow)rows.get(0)), this.mapQuarterDisplayNames((CsvRow)rows.get(1)), this.mapQuarterDisplayNames((CsvRow)rows.get(2)), null, 8, null);
    }

    private final QuarterDisplayNames mapQuarterDisplayNames(CsvRow row) {
        return new QuarterDisplayNames(row.getString(0), row.getString(1), row.getString(2), row.getString(3));
    }

    private final DisplayNameSet<DayPeriodDisplayNames> mapDayPeriods(String csv) {
        List rows = CollectionsKt.toList((Iterable)((Iterable)this.csvReader.read(csv)));
        return new DisplayNameSet<DayPeriodDisplayNames>(this.mapDayPeriodDisplayNames((CsvRow)rows.get(0)), this.mapDayPeriodDisplayNames((CsvRow)rows.get(1)), this.mapDayPeriodDisplayNames((CsvRow)rows.get(2)), null, 8, null);
    }

    private final DayPeriodDisplayNames mapDayPeriodDisplayNames(CsvRow row) {
        return new DayPeriodDisplayNames(row.getString(0), row.getString(1), row.getStringOrNull(2), row.getStringOrNull(3));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/codinux/i18n/datetime/DateTimeDisplayNamesResolver$Companion;", "", "()V", "CsvFormatsSeparator", "", "k-i18n"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

