package net.codinux.i18n

import kotlin.String

/**
 * Had to switch from Map<String, String> to CSV as compiler complained about too many parameters in function, wasmJs didn't even start in release build
 */
object RegionDisplayNames {
  val af: String by lazy { """
      001:wêreld
      002:Afrika
      003:Noord-Amerika
      005:Suid-Amerika
      009:Oseanië
      011:Wes-Afrika
      013:Sentraal-Amerika
      014:Oos-Afrika
      015:Noord-Afrika
      017:Midde-Afrika
      018:Suider-Afrika
      019:Amerikas
      021:Noordelike Amerika
      029:Karibiese streek
      030:Oos-Asië
      034:Suid-Asië
      035:Suidoos-Asië
      039:Suid-Europa
      053:Australasië
      054:Melanesië
      057:Mikronesiese streek
      061:Polinesië
      142:Asië
      143:Sentraal-Asië
      145:Wes-Asië
      150:Europa
      151:Oos-Europa
      154:Noord-Europa
      155:Wes-Europa
      202:Afrika suid van die Sahara
      419:Latyns-Amerika
      AC:Ascensioneiland
      AD:Andorra
      AE:Verenigde Arabiese Emirate
      AF:Afganistan
      AG:Antigua en Barbuda
      AI:Anguilla
      AL:Albanië
      AM:Armenië
      AO:Angola
      AQ:Antarktika
      AR:Argentinië
      AS:Amerikaanse Samoa
      AT:Oostenryk
      AU:Australië
      AW:Aruba
      AX:Ålandeilande
      AZ:Azerbeidjan
      BA:Bosnië en Herzegowina
      BB:Barbados
      BD:Bangladesj
      BE:België
      BF:Burkina Faso
      BG:Bulgarye
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Sint Barthélemy
      BM:Bermuda
      BN:Broenei
      BO:Bolivië
      BQ:Karibiese Nederland
      BR:Brasilië
      BS:Bahamas
      BT:Bhoetan
      BV:Bouvet-eiland
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Kanada
      CC:Kokoseilande
      CD:Demokratiese Republiek van die Kongo
      CF:Sentraal-Afrikaanse Republiek
      CG:Kongo-Brazzaville
      CH:Switserland
      CI:Ivoorkus
      CK:Cookeilande
      CL:Chili
      CM:Kameroen
      CN:China
      CO:Colombië
      CP:Clippertoneiland
      CR:Costa Rica
      CU:Kuba
      CV:Kaap Verde
      CW:Curaçao
      CX:Kerseiland
      CY:Siprus
      CZ:Tsjeggië
      DE:Duitsland
      DG:Diego Garcia
      DJ:Djiboeti
      DK:Denemarke
      DM:Dominica
      DO:Dominikaanse Republiek
      DZ:Algerië
      EA:Ceuta en Melilla
      EC:Ecuador
      EE:Estland
      EG:Egipte
      EH:Wes-Sahara
      ER:Eritrea
      ES:Spanje
      ET:Ethiopië
      EU:Europese Unie
      EZ:Eurosone
      FI:Finland
      FJ:Fidji
      FK:Falklandeilande
      FM:Mikronesië
      FO:Faroëreilande
      FR:Frankryk
      GA:Gaboen
      GB:Verenigde Koninkryk
      GD:Grenada
      GE:Georgië
      GF:Frans-Guyana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Groenland
      GM:Gambië
      GN:Guinee
      GP:Guadeloupe
      GQ:Ekwatoriaal-Guinee
      GR:Griekeland
      GS:Suid-Georgië en die Suidelike Sandwicheilande
      GT:Guatemala
      GU:Guam
      GW:Guinee-Bissau
      GY:Guyana
      HK:Hongkong SAS China
      HM:Heardeiland en McDonaldeilande
      HN:Honduras
      HR:Kroasië
      HT:Haïti
      HU:Hongarye
      IC:Kanariese Eilande
      ID:Indonesië
      IE:Ierland
      IL:Israel
      IM:Eiland Man
      IN:Indië
      IO:Brits-Indiese Oseaangebied
      IQ:Irak
      IR:Iran
      IS:Ysland
      IT:Italië
      JE:Jersey
      JM:Jamaika
      JO:Jordanië
      JP:Japan
      KE:Kenia
      KG:Kirgistan
      KH:Kambodja
      KI:Kiribati
      KM:Comore
      KN:Sint Kitts en Nevis
      KP:Noord-Korea
      KR:Suid-Korea
      KW:Koeweit
      KY:Kaaimanseilande
      KZ:Kazakstan
      LA:Laos
      LB:Libanon
      LC:Sint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberië
      LS:Lesotho
      LT:Litaue
      LU:Luxemburg
      LV:Letland
      LY:Libië
      MA:Marokko
      MC:Monaco
      MD:Moldowa
      ME:Montenegro
      MF:Sint Martin
      MG:Madagaskar
      MH:Marshalleilande
      MK:Noord-Macedonië
      ML:Mali
      MM:Mianmar (Birma)
      MN:Mongolië
      MO:Macau SAS China
      MP:Noord-Mariane-eilande
      MQ:Martinique
      MR:Mauritanië
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maledive
      MW:Malawi
      MX:Meksiko
      MY:Maleisië
      MZ:Mosambiek
      NA:Namibië
      NC:Nieu-Kaledonië
      NE:Niger
      NF:Norfolkeiland
      NG:Nigerië
      NI:Nicaragua
      NL:Nederland
      NO:Noorweë
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nieu-Seeland
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Frans-Polinesië
      PG:Papoea-Nieu-Guinee
      PH:Filippyne
      PK:Pakistan
      PL:Pole
      PM:Sint Pierre en Miquelon
      PN:Pitcairneilande
      PR:Puerto Rico
      PS:Palestynse Grondgebiede
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Katar
      QO:Afgeleë Oseanië
      RE:Réunion
      RO:Roemenië
      RS:Serwië
      RU:Rusland
      RW:Rwanda
      SA:Saoedi-Arabië
      SB:Salomonseilande
      SC:Seychelle
      SD:Soedan
      SE:Swede
      SG:Singapoer
      SH:Sint Helena
      SI:Slowenië
      SJ:Spitsbergen en Jan Mayen
      SK:Slowakye
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalië
      SR:Suriname
      SS:Suid-Soedan
      ST:São Tomé en Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Sirië
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks- en Caicoseilande
      TD:Tsjad
      TF:Franse Suidelike Gebiede
      TG:Togo
      TH:Thailand
      TJ:Tadjikistan
      TK:Tokelau
      TL:Oos-Timor
      TM:Turkmenistan
      TN:Tunisië
      TO:Tonga
      TR:Turkye
      TT:Trinidad en Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzanië
      UA:Oekraïne
      UG:Uganda
      UM:Klein afgeleë eilande van die VSA
      UN:Verenigde Nasies
      US:Verenigde State van Amerika
      UY:Uruguay
      UZ:Oesbekistan
      VA:Vatikaanstad
      VC:Sint Vincent en die Grenadine
      VE:Venezuela
      VG:Britse Maagde-eilande
      VI:VSA se Maagde-eilande
      VN:Viëtnam
      VU:Vanuatu
      WF:Wallis en Futuna
      WS:Samoa
      XA:Pseudoaksente
      XB:Pseudotweerigting
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Suid-Afrika
      ZM:Zambië
      ZW:Zimbabwe
      ZZ:Onbekende gebied
      """.trimIndent() }

  val af_NA: String? = null

  val agq: String by lazy { """
      AD:Àndolà
      AE:Yùnaetɛ Alab ɛmelɛ̀
      AF:Àfɨ̀ganìsɨ̀tân
      AG:Àntigwà à Bàbudà
      AI:Àŋgwilà
      AL:Àabɛnìa
      AM:Àmɛnyìa
      AO:Àŋgolà
      AR:Àdzɛ̀ntinà
      AS:Àmɛlekan Samwà
      AT:Usɨtɨ̀là
      AU:Ùsɨ̀tɛ̀lɛlìa
      AW:Àlubà
      AZ:Àzɨbɛ̀dzân
      BA:Bosɨnyìa à Hɛ̀zɛ̀gòvinà
      BB:Bàbadòs
      BD:Baŋgɨ̀làdɛ̂
      BE:Bɛɛdzwùm
      BF:Bùkinà Fasò
      BG:Bùugɛlìa
      BH:Bàlaen
      BI:Bùlundì
      BJ:Bɛ̀nɨ̂ŋ
      BM:Bɛ̀mudà
      BN:Bɨ̀lunè
      BO:Bòlevà
      BR:Bɨ̀làzîi
      BS:Bàhamàs
      BT:Mbutàn
      BW:Bòtɨ̀swǎnà
      BY:Bɛlàlûs
      BZ:Bɛ̀lezɨ̀
      CA:Kanadà
      CD:Dɛ̀mùkàlatì Lèkpubèlè è Kuŋgù
      CF:Sɛnta Afɨlekan Lèkpobèlè
      CG:Kuŋgù
      CH:Suezàlân
      CI:Ku Dɨ̀vûa
      CK:Chwɨla ŋ̀ Kûʔ
      CL:Chilè
      CM:Kàmàlûŋ
      CN:Chaenà
      CO:Kòlombìa
      CR:Kòsɨ̀tà Lekà
      CU:Kuuwbà
      CV:Chwɨla ŋ̀ Kɛ̀b Vɛ̂ɛ
      CY:Saekpùlù
      CZ:Chɛ̂ Lèkpubèlè
      DE:Dzamanè
      DJ:Dzìbuwtì
      DK:Dɛnɨmà
      DM:Dòmenekà
      DO:Dòmenekà Lèkpubèlè
      DZ:Àadzɛlìa
      EC:Ekwadò
      EE:Èsɨ̀tonyìa
      EG:Edzì
      ER:Èletɨ̀là
      ES:Sɨ̀kpɛ̂n
      ET:Ètyǒpìa
      FI:Fɨnlàn
      FJ:Fidzi
      FK:Chwɨlà fɨ Fakɨlàn
      FM:Maekòlòneshìa
      FR:Fàlâŋnsì
      GA:Gàbûn
      GB:Yùnaetɛ Kiŋdɔ̀m
      GD:Gɨ̀lɛnadà
      GE:Dzɔɔdzìa
      GF:Gàyanà è Fàlâŋnsì
      GH:Gaanà
      GI:Dzibɨ̀latà
      GL:Gɨ̀lenlân
      GM:Gambìa
      GN:Ginè
      GP:Gwadalukpɛ̀
      GQ:Èkwɛ̀tolia Ginè
      GR:Gɨ̀lês
      GT:Gwàtɨ̀malà
      GU:Gwam
      GW:Ginè Bìsawù
      GY:Gùyanà
      HN:Hɔndulàs
      HR:Kòwɛshìa
      HT:Hǎetì
      HU:Hɔŋgàlè
      ID:Èndòneshìa
      IE:Aelɨ̀lân
      IL:Ezɨ̀lɛ̂
      IN:Endìa
      IQ:Èlâkɨ̀
      IR:Èlân
      IS:Aesɨ̀lân
      IT:Etalè
      JM:Dzàmɛkà
      JO:Dzodàn
      JP:Dzàkpân
      KE:Kɨnyà
      KG:Kìdzisɨ̀tân
      KH:Kàmbodìa
      KI:Kèlèbati
      KM:Komolòs
      KN:Sɛ̀n Kî à Nevì
      KP:Kùulîa, Ekùw
      KR:Kùulîa, Emàm
      KW:Kùwɛ̂
      KY:Chwɨlà ŋ̀ Kaemàn
      KZ:Kàzasɨ̀tân
      LA:Làwos
      LB:Lɛbanè
      LC:Sɛ̀n Lushìa
      LI:Letɨnshɨ̀n
      LK:Sɨ̀le Laŋkà
      LR:Làebɛlìa
      LS:Lɛ̀sotù
      LT:Lètwǎnyìa
      LU:Luzɨmbùʔ
      LV:Làtɨva
      LY:Lebìa
      MA:Mòlokò
      MC:Mùnaku
      MD:Mòodovà
      MG:Màdàgasɨkà
      MH:Chwɨlà fɨ Mashà
      ML:Malè
      MM:Mǐanmà
      MN:Mùŋgolìa
      MP:Chwɨlà m̀ Màlǐanà mɨ̀ Ekùw mò
      MQ:Màtìnekì
      MR:Mùlètanyìa
      MS:Mùŋtselà
      MT:Maatà
      MU:Mùleshwɨ̀s
      MV:Màdivè
      MW:Màlawì
      MX:Mɛkɨzikù
      MY:Màlɛshìa
      MZ:Mùzàmbî
      NA:Nàmibìa
      NC:Kàlèdonyìa È fūghū
      NE:Naedzà
      NF:Chwɨlà fɨ Nufòʔ
      NG:Gɨ̀anyɨ
      NI:Nikàlagwà
      NL:Nedàlân
      NO:Noowɛ̂ɛ
      NP:Nɛkpâa
      NR:Nàwulù
      NU:Niyu
      NZ:Zìlân È fūghū
      OM:Umàn
      PA:Kpanàma
      PE:Kpɛlû
      PF:Kpoleneshìa è Fàlâŋnsì
      PG:Kpakpua Ginè È fūghū
      PH:Felèkpî
      PK:Kpakìsɨ̀tân
      PL:Kpulàn
      PM:Sɛ̀n Kpiyɛ̀ à Mikelɔŋ
      PN:Kpitɨ̀kalè
      PR:Kpǒto Leko
      PS:Adzɨmā kɨ ŋgùŋ kɨ Palɛsɨtɨnyia à kɨ Gazà kò
      PT:Kputuwgà
      PW:Kpàlawù
      PY:Kpalàgwɛ̂
      QA:Katà
      RE:Lèyunyɔ̀ŋ
      RO:Lùmanyìa
      RU:Loshìa
      RW:Lùwandà
      SA:Sawudi Alabi
      SB:Chwɨlà fɨ Solomwɨ̀n
      SC:Sɛchɛ̀lɛ̀s
      SD:Sùdân
      SE:Suedɨ̀n
      SG:Siŋgàkpôo
      SH:Sɛ̀n Èlenà
      SI:Sɨ̀lòvɨnyìa
      SK:Sɨ̀lòvɨkɨ̀a
      SL:Silìa lûŋ
      SM:Sàn Màlenù
      SN:Sɛ̀nɛ̀gâa
      SO:Sòmalìa
      SR:Sulènamè
      ST:Sawo Tɔ̀me à Kpèlènsikpɛ̀
      SV:Esàvadò
      SY:Silîa
      SZ:Shǔazìlân
      TC:Chwɨla n Tɨtê à Kaekùs
      TD:Châ
      TG:Tugù
      TH:Taelàn
      TJ:Tàdzikìsɨ̀tân
      TK:Tuwkelawù
      TL:Ês Taemò
      TM:Tekɨmènèsɨ̀tân
      TN:Tùneshìa
      TO:Tuŋgà
      TR:Teekì
      TT:Tèlenedà à Tòbagù
      TV:Tuwvalùw
      TW:Taewàn
      TZ:Tàanzanyìa
      UA:Yùkɛ̀lɛ̂
      UG:Yùgandà
      US:USA
      UY:Yulùgwɛ̂
      UZ:Yùzɨ̀bɛkìsɨ̀tân
      VA:Vatikàn Sɨ̀tɛ̂
      VC:Sɛ̀n Vinsɨ̀n à Gɨlenadi Ù tē
      VE:Vɛ̀nɛ̀zǔɛɛlà
      VG:Chwɨlà m̀ Vidzinyìa m̀ Bɨ̀letì mò
      VI:U. S. Chwɨlà fɨ Mbuʔmbu
      VN:Vìyɛnàm
      VU:Vànǔatùw
      WF:Wales à Fùwtuwnà
      WS:Sàmowà
      YE:Yɛmɛ̀n
      YT:Màyotì
      ZA:Afɨlekà ghɨ Emàm ghò
      ZM:Zambìa
      ZW:Zìmbagbɛ̀
      """.trimIndent() }

  val ak: String by lazy { """
      001:wiase
      002:Abibirem
      003:Amɛrika Atifi
      005:Amɛrika Anaafoɔ
      009:Osiana
      011:Abibirem Atɔeɛ Fam
      013:Amɛrika Mfimfini
      014:Abibirem Apueiɛ Fam
      015:Abibirem Atifi Fam
      017:Abibirem Mfimfini
      018:Abibirem Anaafoɔ Fam
      019:Amɛrikafoɔ
      021:Amɛrika Atifi Fam
      029:Karibia
      030:Asia Apueiɛ
      034:Asia Anaafoɔ
      035:Asia Anaafoɔ Apuieɛ
      039:Yuropu Anaafoɔ
      053:Ɔstrelia ne Asia
      054:Melanesia
      057:Micronesia Mantam
      061:Pɔlenesia
      142:Asia
      143:Asia Mfimfini
      145:Asia Atɔeɛ
      150:Yuropu
      151:Yuropu Apuieɛ
      154:Yuropu Atifi
      155:Yuropu Atɔeɛ
      202:Abibirem Mpaprɛ Anaafoɔ
      419:Laaten Amɛrika
      AC:Asɛnhyin
      AD:Andora
      AE:United Arab Emirates
      AF:Afganistan
      AG:Antigua ne Baabuda
      AI:Anguila
      AL:Albenia
      AM:Aamenia
      AO:Angola
      AQ:Antaatika
      AR:Agyɛntina
      AS:Amɛrika Samoa
      AT:Ɔstria
      AU:Ɔstrelia
      AW:Aruba
      AX:Aland Aeland
      AZ:Asabegyan
      BA:Bosnia ne Hɛzegovina
      BB:Baabados
      BD:Bangladɛhye
      BE:Bɛlgyium
      BF:Bɔkina Faso
      BG:Bɔlgeria
      BH:Baren
      BI:Burundi
      BJ:Bɛnin
      BL:St. Baatilemi
      BM:Bɛmuda
      BN:Brunae
      BO:Bolivia
      BQ:Caribbean Netherlands
      BR:Brazil
      BS:Bahama
      BT:Butan
      BV:Bouvet Island
      BW:Bɔtswana
      BY:Bɛlarus
      BZ:Beliz
      CA:Kanada
      CC:Kokoso Supɔ
      CD:Kongo Kinhyaahya
      CF:Afrika Finimfin Man
      CG:Kongo
      CH:Swetzaland
      CI:Kodivuwa
      CK:Kuk Nsupɔ
      CL:Kyili
      CM:Kamɛrun
      CN:Kyaena
      CO:Kolombia
      CP:Klepatin Aeland
      CR:Kɔsta Rika
      CU:Kuba
      CV:Kepvɛdfo Islands
      CW:Kurakaw
      CX:Buronya Supɔ
      CY:Saeprɔso
      CZ:Kyɛk
      DE:Gyaaman
      DG:Diɛgo Gaasia
      DJ:Gyibuti
      DK:Dɛnmak
      DM:Dɔmeneka
      DO:Dɔmeneka Man
      DZ:Ɔlgyeria
      EA:Ceuta ne Melilla
      EC:Yikuwedɔ
      EE:Ɛstonia
      EG:Misrim
      EH:Sahara Atɔeɛ
      ER:Ɛritrea
      ES:Spain
      ET:Ithiopia
      EU:Yuropu Nkabomkuo
      EZ:Yuropu Fam
      FI:Finland
      FJ:Figyi
      FK:Fɔkman Aeland
      FM:Maekronehyia
      FO:Faro Aeland
      FR:Franse
      GA:Gabɔn
      GB:UK
      GD:Grenada
      GE:Gyɔgyea
      GF:Frɛnkye Gayana
      GG:Guɛnse
      GH:Gaana
      GI:Gyebralta
      GL:Greenman
      GM:Gambia
      GN:Gini
      GP:Guwadelup
      GQ:Gini Ikuweta
      GR:Greekman
      GS:Gyɔɔgyia Anaafoɔ ne Sandwich Aeland Anaafoɔ
      GT:Guwatemala
      GU:Guam
      GW:Gini Bisaw
      GY:Gayana
      HK:Hɔnkɔn Kyaena
      HM:Heard ne McDonald Supɔ
      HN:Hɔnduras
      HR:Krowehyia
      HT:Heiti
      HU:Hangari
      IC:Canary Islands
      ID:Indɔnehyia
      IE:Aereland
      IL:Israe
      IM:Isle of Man
      IN:India
      IO:Britenfo Man Wɔ India Po No Mu
      IQ:Irak
      IR:Iran
      IS:Aesland
      IT:Itali
      JE:Gyɛsi
      JM:Gyameka
      JO:Gyɔdan
      JP:Gyapan
      KE:Kenya
      KG:Kɛɛgestan
      KH:Kambodia
      KI:Kiribati
      KM:Kɔmɔrɔs
      KN:Saint Kitts ne Nɛves
      KP:Korea Atifi
      KR:Korea Anaafoɔ
      KW:Kuweti
      KY:Kemanfo Islands
      KZ:Kazakstan
      LA:Laos
      LB:Lɛbanɔn
      LC:Saint Lucia
      LI:Lektenstaen
      LK:Sri Lanka
      LR:Laeberia
      LS:Lesoto
      LT:Lituwenia
      LU:Lusimbɛg
      LV:Latvia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Mɔldova
      ME:Mɔntenegro
      MF:St. Maatin
      MG:Madagaska
      MH:Mahyaa Aeland
      MK:Mesidonia Atifi
      ML:Mali
      MM:Mayaama (Bɛɛma)
      MN:Mɔngolia
      MO:Makaw Kyaena
      MP:Mariana Atifi Fam Aeland
      MQ:Matinik
      MR:Mɔretenia
      MS:Mantserat
      MT:Mɔlta
      MU:Mɔrehyeɔs
      MV:Maldives
      MW:Malawi
      MX:Mɛksiko
      MY:Malehyia
      MZ:Mozambik
      NA:Namibia
      NC:Kaledonia Foforo
      NE:Nigyɛɛ
      NF:Norfold Supɔ
      NG:Naegyeria
      NI:Nekaraguwa
      NL:Nɛdɛland
      NO:Nɔɔwe
      NP:Nɛpal
      NR:Naworu
      NU:Niyu
      NZ:Ziland Foforo
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Frɛnkye Pɔlenehyia
      PG:Papua Gini Foforɔ
      PH:Filipin
      PK:Pakistan
      PL:Pɔland
      PM:Saint Pierre ne Miquelon
      PN:Pitkaan Nsupɔ
      PR:Puɛto Riko
      PS:Palestaen West Bank ne Gaza
      PT:Pɔtugal
      PW:Palau
      PY:Paraguae
      QA:Kata
      QO:Osiana Ano Ano
      RE:Reyuniɔn
      RO:Romenia
      RS:Sɛbia
      RU:Rɔhyea
      RW:Rewanda
      SA:Saudi Arabia
      SB:Solomɔn Aeland
      SC:Seyhyɛl
      SD:Sudan
      SE:Sweden
      SG:Singapɔ
      SH:Saint Helena
      SI:Slovinia
      SJ:Svalbard ne Jan Mayen
      SK:Slovakia
      SL:Sɛra Liɔn
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:Sudan Anaafoɔ
      ST:São Tomé ne Príncipe
      SV:Ɛl Salvadɔ
      SX:Sint Maaten
      SY:Siria
      SZ:Swaziland
      TA:Tristan da Kuna
      TC:Turks ne Caicos Islands
      TD:Kyad
      TF:Franse Anaafoɔ Nsaase
      TG:Togo
      TH:Taeland
      TJ:Tagyikistan
      TK:Tokelau
      TL:Timɔ Boka
      TM:Tɛkmɛnistan
      TN:Tunihyia
      TO:Tonga
      TR:Tɛɛki
      TT:Trinidad ne Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansania
      UA:Ukren
      UG:Yuganda
      UM:U.S. Nkyɛnnkyɛn Supɔ Ahodoɔ
      UN:Amansan Nkabomkuo
      US:Amɛrika
      UY:Yurugwae
      UZ:Usbɛkistan
      VA:Vatican Man
      VC:Saint Vincent ne Grenadines
      VE:Venezuela
      VG:Ngresifoɔ Virgin Island
      VI:Amɛrika Virgin Islands
      VN:Viɛtnam
      VU:Vanuatu
      WF:Wallis ne Futuna
      WS:Samoa
      XA:Anto Kasa
      XB:Anto Bidi
      XK:Kosovo
      YE:Yɛmɛn
      YT:Mayɔte
      ZA:Abibirem Anaafoɔ
      ZM:Zambia
      ZW:Zimbabue
      ZZ:Mantam a Yɛnnim
      """.trimIndent() }

  val am: String by lazy { """
      001:ዓለም
      002:አፍሪካ
      003:ሰሜን አሜሪካ
      005:ደቡብ አሜሪካ
      009:ኦሺያንያ
      011:ምዕራባዊ አፍሪካ
      013:መካከለኛው አሜሪካ
      014:ምስራቅ አፍሪካ
      015:ሰሜናዊ አፍሪካ
      017:መካከለኛው አፍሪካ
      018:ደቡባዊ አፍሪካ
      019:አሜሪካ
      021:ሰሜናዊ አሜሪካ
      029:ካሪቢያን
      030:ምስራቃዊ እስያ
      034:ደቡባዊ እስያ
      035:ደቡብ ምስራቅ እስያ
      039:ደቡባዊ አውሮፓ
      053:አውስትራሌዥያ
      054:ሜላኔዥያ
      057:የማይክሮኔዥያን ክልል
      061:ፖሊኔዥያ
      142:እስያ
      143:መካከለኛው እስያ
      145:ምዕራባዊ እስያ
      150:አውሮፓ
      151:ምስራቅ አውሮፓ
      154:ሰሜናዊ አውሮፓ
      155:ምዕራብ አውሮፓ
      202:ከሰሃራ በታች አፍሪካ
      419:ላቲን አሜሪካ
      AC:አሴንሽን ደሴት
      AD:አንዶራ
      AE:የተባበሩት ዓረብ ኤምሬትስ
      AF:አፍጋኒስታን
      AG:አንቲጓ እና ባርቡዳ
      AI:አንጉይላ
      AL:አልባኒያ
      AM:አርሜኒያ
      AO:አንጐላ
      AQ:አንታርክቲካ
      AR:አርጀንቲና
      AS:የአሜሪካ ሳሞአ
      AT:ኦስትሪያ
      AU:አውስትራልያ
      AW:አሩባ
      AX:የአላንድ ደሴቶች
      AZ:አዘርባጃን
      BA:ቦስኒያ እና ሄርዞጎቪኒያ
      BB:ባርቤዶስ
      BD:ባንግላዲሽ
      BE:ቤልጄም
      BF:ቡርኪና ፋሶ
      BG:ቡልጋሪያ
      BH:ባህሬን
      BI:ብሩንዲ
      BJ:ቤኒን
      BL:ሴንት ባርቴሌሚ
      BM:ቤርሙዳ
      BN:ብሩኒ
      BO:ቦሊቪያ
      BQ:የካሪቢያን ኔዘርላንድስ
      BR:ብራዚል
      BS:ባሃማስ
      BT:ቡህታን
      BV:ቡቬት ደሴት
      BW:ቦትስዋና
      BY:ቤላሩስ
      BZ:በሊዝ
      CA:ካናዳ
      CC:ኮኮስ(ኬሊንግ) ደሴቶች
      CD:ኮንጎ-ኪንሻሳ
      CF:ማዕከላዊ አፍሪካ ሪፑብሊክ
      CG:ኮንጎ ብራዛቪል
      CH:ስዊዘርላንድ
      CI:ኮትዲቯር
      CK:ኩክ ደሴቶች
      CL:ቺሊ
      CM:ካሜሩን
      CN:ቻይና
      CO:ኮሎምቢያ
      CP:ክሊፐርቶን ደሴት
      CR:ኮስታሪካ
      CU:ኩባ
      CV:ኬፕቨርዴ
      CW:ኩራሳዎ
      CX:ክሪስማስ ደሴት
      CY:ሳይፕረስ
      CZ:ቼቺያ
      DE:ጀርመን
      DG:ዲዬጎ ጋርሲያ
      DJ:ጂቡቲ
      DK:ዴንማርክ
      DM:ዶሚኒካ
      DO:ዶመኒካን ሪፑብሊክ
      DZ:አልጄሪያ
      EA:ሴኡታና ሜሊላ
      EC:ኢኳዶር
      EE:ኤስቶኒያ
      EG:ግብጽ
      EH:ምዕራባዊ ሳህራ
      ER:ኤርትራ
      ES:ስፔን
      ET:ኢትዮጵያ
      EU:የአውሮፓ ህብረት
      EZ:የዩሮ ዞን
      FI:ፊንላንድ
      FJ:ፊጂ
      FK:የፎክላንድ ደሴቶች
      FM:ማይክሮኔዢያ
      FO:የፋሮ ደሴቶች
      FR:ፈረንሳይ
      GA:ጋቦን
      GB:ዩናይትድ ኪንግደም
      GD:ግሬናዳ
      GE:ጆርጂያ
      GF:የፈረንሳይ ጉዊአና
      GG:ጉርነሲ
      GH:ጋና
      GI:ጂብራልተር
      GL:ግሪንላንድ
      GM:ጋምቢያ
      GN:ጊኒ
      GP:ጉዋደሉፕ
      GQ:ኢኳቶሪያል ጊኒ
      GR:ግሪክ
      GS:ደቡብ ጆርጂያ እና የደቡብ ሳንድዊች ደሴቶች
      GT:ጉዋቲማላ
      GU:ጉዋም
      GW:ጊኒ-ቢሳው
      GY:ጉያና
      HK:ሆንግ ኮንግ ልዩ የአስተዳደር ክልል ቻይና
      HM:ኽርድ ኣና ማክዶናልድ ደሴቶች
      HN:ሆንዱራስ
      HR:ክሮኤሽያ
      HT:ሀይቲ
      HU:ሀንጋሪ
      IC:የካናሪ ደሴቶች
      ID:ኢንዶኔዢያ
      IE:አየርላንድ
      IL:እስራኤል
      IM:አይል ኦፍ ማን
      IN:ህንድ
      IO:የብሪታኒያ ህንድ ውቂያኖስ ግዛት
      IQ:ኢራቅ
      IR:ኢራን
      IS:አይስላንድ
      IT:ጣሊያን
      JE:ጀርዚ
      JM:ጃማይካ
      JO:ጆርዳን
      JP:ጃፓን
      KE:ኬንያ
      KG:ኪርጊስታን
      KH:ካምቦዲያ
      KI:ኪሪባቲ
      KM:ኮሞሮስ
      KN:ቅዱስ ኪትስ እና ኔቪስ
      KP:ሰሜን ኮሪያ
      KR:ደቡብ ኮሪያ
      KW:ኩዌት
      KY:ካይማን ደሴቶች
      KZ:ካዛኪስታን
      LA:ላኦስ
      LB:ሊባኖስ
      LC:ሴንት ሉቺያ
      LI:ሊችተንስታይን
      LK:ሲሪላንካ
      LR:ላይቤሪያ
      LS:ሌሶቶ
      LT:ሊቱዌኒያ
      LU:ሉክሰምበርግ
      LV:ላትቪያ
      LY:ሊቢያ
      MA:ሞሮኮ
      MC:ሞናኮ
      MD:ሞልዶቫ
      ME:ሞንተኔግሮ
      MF:ሴንት ማርቲን
      MG:ማዳጋስካር
      MH:ማርሻል ደሴቶች
      MK:ሰሜን መቄዶንያ
      ML:ማሊ
      MM:ማይናማር(በርማ)
      MN:ሞንጎሊያ
      MO:ማካኦ ልዩ የአስተዳደር ክልል ቻይና
      MP:የሰሜናዊ ማሪያና ደሴቶች
      MQ:ማርቲኒክ
      MR:ሞሪቴኒያ
      MS:ሞንትሴራት
      MT:ማልታ
      MU:ሞሪሸስ
      MV:ማልዲቭስ
      MW:ማላዊ
      MX:ሜክሲኮ
      MY:ማሌዢያ
      MZ:ሞዛምቢክ
      NA:ናሚቢያ
      NC:ኒው ካሌዶኒያ
      NE:ኒጀር
      NF:ኖርፎልክ ደሴት
      NG:ናይጄሪያ
      NI:ኒካራጓ
      NL:ኔዘርላንድ
      NO:ኖርዌይ
      NP:ኔፓል
      NR:ናኡሩ
      NU:ኒዌ
      NZ:ኒው ዚላንድ
      OM:ኦማን
      PA:ፓናማ
      PE:ፔሩ
      PF:የፈረንሳይ ፖሊኔዢያ
      PG:ፓፑዋ ኒው ጊኒ
      PH:ፊሊፒንስ
      PK:ፓኪስታን
      PL:ፖላንድ
      PM:ሴንት ፒዬር እና ሚኩኤሎን
      PN:ፒትካኢርን ደሴቶች
      PR:ፑዌርቶ ሪኮ
      PS:የፍልስጤም ግዛት
      PT:ፖርቱጋል
      PW:ፓላው
      PY:ፓራጓይ
      QA:ኳታር
      QO:የኦሺያንያ ዳርቻ
      RE:ሪዩኒየን
      RO:ሮሜኒያ
      RS:ሰርብያ
      RU:ሩስያ
      RW:ሩዋንዳ
      SA:ሳውድአረቢያ
      SB:ሰለሞን ደሴቶች
      SC:ሲሼልስ
      SD:ሱዳን
      SE:ስዊድን
      SG:ሲንጋፖር
      SH:ሴንት ሄለና
      SI:ስሎቬኒያ
      SJ:ስቫልባርድ እና ጃን ማየን
      SK:ስሎቫኪያ
      SL:ሴራሊዮን
      SM:ሳን ማሪኖ
      SN:ሴኔጋል
      SO:ሶማሊያ
      SR:ሱሪናም
      SS:ደቡብ ሱዳን
      ST:ሳኦ ቶሜ እና ፕሪንሲፔ
      SV:ኤል ሳልቫዶር
      SX:ሲንት ማርተን
      SY:ሶሪያ
      SZ:ኤስዋቲኒ
      TA:ትሪስታን ዳ ኩንሃ
      TC:የቱርኮችና የካኢኮስ ደሴቶች
      TD:ቻድ
      TF:የፈረንሳይ ደቡባዊ ግዛቶች
      TG:ቶጐ
      TH:ታይላንድ
      TJ:ታጃኪስታን
      TK:ቶክላው
      TL:ቲሞር ሌስቴ
      TM:ቱርክሜኒስታን
      TN:ቱኒዚያ
      TO:ቶንጋ
      TR:ቱርክ
      TT:ትሪናዳድ እና ቶቤጎ
      TV:ቱቫሉ
      TW:ታይዋን
      TZ:ታንዛኒያ
      UA:ዩክሬን
      UG:ዩጋንዳ
      UM:የዩ ኤስ ጠረፍ ላይ ያሉ ደሴቶች
      UN:የተባበሩት መንግስታት
      US:ዩናይትድ ስቴትስ
      UY:ኡራጓይ
      UZ:ኡዝቤኪስታን
      VA:ቫቲካን ከተማ
      VC:ሴንት ቪንሴንት እና ግሬናዲንስ
      VE:ቬንዙዌላ
      VG:የእንግሊዝ ቨርጂን ደሴቶች
      VI:የአሜሪካ ቨርጂን ደሴቶች
      VN:ቬትናም
      VU:ቫኑአቱ
      WF:ዋሊስ እና ፉቱና ደሴቶች
      WS:ሳሞአ
      XA:የሀሰት ትእምርት
      XB:የሀሰት ባለሁለት አቅጣጫ
      XK:ኮሶቮ
      YE:የመን
      YT:ሜይኦቴ
      ZA:ደቡብ አፍሪካ
      ZM:ዛምቢያ
      ZW:ዚምቧቤ
      ZZ:ያልታወቀ ክልል
      """.trimIndent() }

  val ar: String by lazy { """
      001:العالم
      002:أفريقيا
      003:أمريكا الشمالية
      005:أمريكا الجنوبية
      009:أوقيانوسيا
      011:غرب أفريقيا
      013:أمريكا الوسطى
      014:شرق أفريقيا
      015:شمال أفريقيا
      017:وسط أفريقيا
      018:أفريقيا الجنوبية
      019:الأمريكتان
      021:شمال أمريكا
      029:الكاريبي
      030:شرق آسيا
      034:جنوب آسيا
      035:جنوب شرق آسيا
      039:جنوب أوروبا
      053:أسترالاسيا
      054:ميلانيزيا
      057:الجزر الميكرونيزية
      061:بولينيزيا
      142:آسيا
      143:وسط آسيا
      145:غرب آسيا
      150:أوروبا
      151:شرق أوروبا
      154:شمال أوروبا
      155:غرب أوروبا
      202:أفريقيا جنوب الصحراء الكبرى
      419:أمريكا اللاتينية
      AC:جزيرة أسينشيون
      AD:أندورا
      AE:الإمارات العربية المتحدة
      AF:أفغانستان
      AG:أنتيغوا وبربودا
      AI:أنغويلا
      AL:ألبانيا
      AM:أرمينيا
      AO:أنغولا
      AQ:أنتاركتيكا
      AR:الأرجنتين
      AS:ساموا الأمريكية
      AT:النمسا
      AU:أستراليا
      AW:أروبا
      AX:جزر آلاند
      AZ:أذربيجان
      BA:البوسنة والهرسك
      BB:بربادوس
      BD:بنغلاديش
      BE:بلجيكا
      BF:بوركينا فاسو
      BG:بلغاريا
      BH:البحرين
      BI:بوروندي
      BJ:بنين
      BL:سان بارتليمي
      BM:برمودا
      BN:بروناي
      BO:بوليفيا
      BQ:هولندا الكاريبية
      BR:البرازيل
      BS:جزر البهاما
      BT:بوتان
      BV:جزيرة بوفيه
      BW:بوتسوانا
      BY:بيلاروس
      BZ:بليز
      CA:كندا
      CC:جزر كوكوس (كيلينغ)
      CD:الكونغو - كينشاسا
      CF:جمهورية أفريقيا الوسطى
      CG:الكونغو - برازافيل
      CH:سويسرا
      CI:ساحل العاج
      CK:جزر كوك
      CL:تشيلي
      CM:الكاميرون
      CN:الصين
      CO:كولومبيا
      CP:جزيرة كليبيرتون
      CR:كوستاريكا
      CU:كوبا
      CV:الرأس الأخضر
      CW:كوراساو
      CX:جزيرة كريسماس
      CY:قبرص
      CZ:التشيك
      DE:ألمانيا
      DG:دييغو غارسيا
      DJ:جيبوتي
      DK:الدانمرك
      DM:دومينيكا
      DO:جمهورية الدومينيكان
      DZ:الجزائر
      EA:سيوتا وميليلا
      EC:الإكوادور
      EE:إستونيا
      EG:مصر
      EH:الصحراء الغربية
      ER:إريتريا
      ES:إسبانيا
      ET:إثيوبيا
      EU:الاتحاد الأوروبي
      EZ:منطقة اليورو
      FI:فنلندا
      FJ:فيجي
      FK:جزر فوكلاند
      FM:ميكرونيزيا
      FO:جزر فارو
      FR:فرنسا
      GA:الغابون
      GB:المملكة المتحدة
      GD:غرينادا
      GE:جورجيا
      GF:غويانا الفرنسية
      GG:غيرنزي
      GH:غانا
      GI:جبل طارق
      GL:غرينلاند
      GM:غامبيا
      GN:غينيا
      GP:غوادلوب
      GQ:غينيا الاستوائية
      GR:اليونان
      GS:جورجيا الجنوبية وجزر ساندويتش الجنوبية
      GT:غواتيمالا
      GU:غوام
      GW:غينيا بيساو
      GY:غيانا
      HK:هونغ كونغ الصينية (منطقة إدارية خاصة)
      HM:جزيرة هيرد وجزر ماكدونالد
      HN:هندوراس
      HR:كرواتيا
      HT:هايتي
      HU:هنغاريا
      IC:جزر الكناري
      ID:إندونيسيا
      IE:أيرلندا
      IL:إسرائيل
      IM:جزيرة مان
      IN:الهند
      IO:الإقليم البريطاني في المحيط الهندي
      IQ:العراق
      IR:إيران
      IS:آيسلندا
      IT:إيطاليا
      JE:جيرسي
      JM:جامايكا
      JO:الأردن
      JP:اليابان
      KE:كينيا
      KG:قيرغيزستان
      KH:كمبوديا
      KI:كيريباتي
      KM:جزر القمر
      KN:سانت كيتس ونيفيس
      KP:كوريا الشمالية
      KR:كوريا الجنوبية
      KW:الكويت
      KY:جزر كايمان
      KZ:كازاخستان
      LA:لاوس
      LB:لبنان
      LC:سانت لوسيا
      LI:ليختنشتاين
      LK:سريلانكا
      LR:ليبيريا
      LS:ليسوتو
      LT:ليتوانيا
      LU:لوكسمبورغ
      LV:لاتفيا
      LY:ليبيا
      MA:المغرب
      MC:موناكو
      MD:مولدوفا
      ME:الجبل الأسود
      MF:سان مارتن
      MG:مدغشقر
      MH:جزر مارشال
      MK:مقدونيا الشمالية
      ML:مالي
      MM:ميانمار (بورما)
      MN:منغوليا
      MO:منطقة ماكاو الإدارية الخاصة
      MP:جزر ماريانا الشمالية
      MQ:جزر المارتينيك
      MR:موريتانيا
      MS:مونتسرات
      MT:مالطا
      MU:موريشيوس
      MV:جزر المالديف
      MW:ملاوي
      MX:المكسيك
      MY:ماليزيا
      MZ:موزمبيق
      NA:ناميبيا
      NC:كاليدونيا الجديدة
      NE:النيجر
      NF:جزيرة نورفولك
      NG:نيجيريا
      NI:نيكاراغوا
      NL:هولندا
      NO:النرويج
      NP:نيبال
      NR:ناورو
      NU:نيوي
      NZ:نيوزيلندا
      OM:عُمان
      PA:بنما
      PE:بيرو
      PF:بولينيزيا الفرنسية
      PG:بابوا غينيا الجديدة
      PH:الفلبين
      PK:باكستان
      PL:بولندا
      PM:سان بيير ومكويلون
      PN:جزر بيتكيرن
      PR:بورتوريكو
      PS:الأراضي الفلسطينية
      PT:البرتغال
      PW:بالاو
      PY:باراغواي
      QA:قطر
      QO:أوقيانوسيا النائية
      RE:روينيون
      RO:رومانيا
      RS:صربيا
      RU:روسيا
      RW:رواندا
      SA:المملكة العربية السعودية
      SB:جزر سليمان
      SC:سيشل
      SD:السودان
      SE:السويد
      SG:سنغافورة
      SH:سانت هيلينا
      SI:سلوفينيا
      SJ:سفالبارد وجان ماين
      SK:سلوفاكيا
      SL:سيراليون
      SM:سان مارينو
      SN:السنغال
      SO:الصومال
      SR:سورينام
      SS:جنوب السودان
      ST:ساو تومي وبرينسيبي
      SV:السلفادور
      SX:سانت مارتن
      SY:سوريا
      SZ:إسواتيني
      TA:تريستان دا كونا
      TC:جزر توركس وكايكوس
      TD:تشاد
      TF:الأقاليم الجنوبية الفرنسية
      TG:توغو
      TH:تايلاند
      TJ:طاجيكستان
      TK:توكيلاو
      TL:تيمور - ليشتي
      TM:تركمانستان
      TN:تونس
      TO:تونغا
      TR:تركيا
      TT:ترينيداد وتوباغو
      TV:توفالو
      TW:تايوان
      TZ:تنزانيا
      UA:أوكرانيا
      UG:أوغندا
      UM:جزر الولايات المتحدة النائية
      UN:الأمم المتحدة
      US:الولايات المتحدة
      UY:أورغواي
      UZ:أوزبكستان
      VA:الفاتيكان
      VC:سانت فنسنت وجزر غرينادين
      VE:فنزويلا
      VG:جزر فيرجن البريطانية
      VI:جزر فيرجن الأمريكية
      VN:فيتنام
      VU:فانواتو
      WF:جزر والس وفوتونا
      WS:ساموا
      XA:لكنات تجريبية غير أصلية
      XB:لكنات تجريبية ثنائية الاتجاه
      XK:كوسوفو
      YE:اليمن
      YT:مايوت
      ZA:جنوب أفريقيا
      ZM:زامبيا
      ZW:زيمبابوي
      ZZ:منطقة غير معروفة
      """.trimIndent() }

  val ar_AE: String? = null

  val ar_BH: String? = null

  val ar_DJ: String? = null

  val ar_DZ: String? = null

  val ar_EG: String? = null

  val ar_EH: String? = null

  val ar_ER: String? = null

  val ar_IL: String? = null

  val ar_IQ: String? = null

  val ar_JO: String? = null

  val ar_KM: String? = null

  val ar_KW: String? = null

  val ar_LB: String? = null

  val ar_LY: String by lazy { """
      EA:سبتة ومليلية
      MS:مونتيسيرات
      UY:أوروغواي
      """.trimIndent() }

  val ar_MA: String? = null

  val ar_MR: String? = null

  val ar_OM: String? = null

  val ar_PS: String? = null

  val ar_QA: String? = null

  val ar_SA: String by lazy { """
      AC:جزيرة أسينشين
      EA:سبتة ومليلية
      MO:ماكاو الصينية (منطقة إدارية خاصة)
      MS:مونتيسيرات
      UY:أوروغواي
      """.trimIndent() }

  val ar_SD: String? = null

  val ar_SO: String? = null

  val ar_SS: String? = null

  val ar_SY: String? = null

  val ar_TD: String? = null

  val ar_TN: String? = null

  val ar_YE: String? = null

  val `as`: String by lazy { """
      001:বিশ্ব
      002:আফ্ৰিকা
      003:উত্তৰ আমেৰিকা
      005:দক্ষিণ আমেৰিকা
      009:অ’চেনীয়া
      011:পাশ্চাত্য আফ্ৰিকা
      013:মধ্য আমেৰিকা
      014:প্ৰাচ্য আফ্ৰিকা
      015:উদীচ্য আফ্ৰিকা
      017:মধ্য আফ্ৰিকা
      018:দাক্ষিণাত্য আফ্ৰিকা
      019:আমেৰিকাছ্
      021:উদীচ্য আমেৰিকা
      029:কেৰিবিয়ান
      030:প্ৰাচ্য এছিয়া
      034:দাক্ষিণাত্য এছিয়া
      035:দক্ষিণ-পূব এছিয়া
      039:দাক্ষিণাত্য ইউৰোপ
      053:অষ্ট্ৰেলেছিয়া
      054:মেলানেছিয়া
      057:মাইক্ৰোনেচিয় ক্ষেত্ৰ
      061:পলিনেচিয়া
      142:এছিয়া
      143:মধ্য এছিয়া
      145:পাশ্চাত্য এছিয়া
      150:ইউৰোপ
      151:প্ৰাচ্য ইউৰোপ
      154:উদীচ্য ইউৰোপ
      155:পাশ্চাত্য ইউৰোপ
      202:উপ-ছাহাৰান আফ্ৰিকা
      419:লেটিন আমেৰিকা
      AC:এচেনচিয়ন দ্বীপ
      AD:আন্দোৰা
      AE:সংযুক্ত আৰব আমিৰাত
      AF:আফগানিস্তান
      AG:এণ্টিগুৱা আৰু বাৰ্বুডা
      AI:এনগুইলা
      AL:আলবেনিয়া
      AM:আৰ্মেনিয়া
      AO:এংগোলা
      AQ:এণ্টাৰ্কটিকা
      AR:আৰ্জেণ্টিনা
      AS:আমেৰিকান চামোৱা
      AT:অষ্ট্ৰিয়া
      AU:অষ্ট্ৰেলিয়া
      AW:আৰুবা
      AX:আলণ্ড দ্বীপপুঞ্জ
      AZ:আজাৰবেইজান
      BA:ব’ছনিয়া আৰু হাৰ্জেগ’ভিনা
      BB:বাৰ্বাডোচ
      BD:বাংলাদেশ
      BE:বেলজিয়াম
      BF:বুৰকিনা ফাচো
      BG:বুলগেৰিয়া
      BH:বাহৰেইন
      BI:বুৰুণ্ডি
      BJ:বেনিন
      BL:ছেইণ্ট বাৰ্থলেমে
      BM:বাৰ্মুডা
      BN:ব্ৰুনেই
      BO:বলিভিয়া
      BQ:কেৰিবিয়ান নেদাৰলেণ্ডছ
      BR:ব্ৰাজিল
      BS:বাহামাছ
      BT:ভুটান
      BV:বুভে দ্বীপ
      BW:ব’টচোৱানা
      BY:বেলাৰুছ
      BZ:বেলিজ
      CA:কানাডা
      CC:কোকোচ (কীলিং) দ্বীপপুঞ্জ
      CD:কঙ্গো - কিনচাছা
      CF:মধ্য আফ্রিকান প্রজাতন্ত্র
      CG:কঙ্গো - ব্রাজাভিল
      CH:চুইজাৰলেণ্ড
      CI:কোটে ডি আইভৰ
      CK:কুক দ্বীপপুঞ্জ
      CL:চিলি
      CM:কেমেৰুণ
      CN:চীন
      CO:কলম্বিয়া
      CP:ক্লিপাৰটোন দ্বীপ
      CR:কোষ্টা ৰিকা
      CU:কিউবা
      CV:কেপ ভার্দে
      CW:কুৰাকাও
      CX:খ্ৰীষ্টমাছ দ্বীপ
      CY:চাইপ্ৰাছ
      CZ:চিজেচিয়া
      DE:জাৰ্মানী
      DG:ডিয়েগো গাৰ্চিয়া
      DJ:জিবুটি
      DK:ডেনমাৰ্ক
      DM:ড’মিনিকা
      DO:ড’মিনিকান ৰিপাব্লিক
      DZ:আলজেৰিয়া
      EA:চেউটা আৰু মেলিলা
      EC:ইকুৱেডৰ
      EE:ইষ্টোনিয়া
      EG:ইজিপ্ত
      EH:পশ্চিমীয় ছাহাৰা
      ER:এৰিত্ৰিয়া
      ES:স্পেইন
      ET:ইথিঅ’পিয়া
      EU:ইউৰোপীয় সংঘ
      EZ:ইউৰোজ’ন
      FI:ফিনলেণ্ড
      FJ:ফিজি
      FK:ফকলেণ্ড দ্বীপপুঞ্জ
      FM:মাইক্ৰোনেচিয়া
      FO:ফাৰো দ্বীপপুঞ্জ
      FR:ফ্ৰান্স
      GA:গেবন
      GB:সংযুক্ত ৰাজ্য
      GD:গ্ৰেনাডা
      GE:জৰ্জিয়া
      GF:ফ্ৰান্স গয়ানা
      GG:গোৰেনচি
      GH:ঘানা
      GI:জিব্ৰাল্টৰ
      GL:গ্ৰীণলেণ্ড
      GM:গাম্বিয়া
      GN:গিনি
      GP:গুৱাডেলুপ
      GQ:ইকুৱেটৰিয়েল গিনি
      GR:গ্ৰীচ
      GS:দক্ষিণ জৰ্জিয়া আৰু দক্ষিণ চেণ্ডৱিচ দ্বীপপুঞ্জ
      GT:গুৱাটেমালা
      GU:গুৱাম
      GW:গিনি-বিছাও
      GY:গায়ানা
      HK:হং কং এছ. এ. আৰ. চীন
      HM:হাৰ্ড দ্বীপ আৰু মেকডোনাল্ড দ্বীপপুঞ্জ
      HN:হন্দুৰাছ
      HR:ক্ৰোৱেছিয়া
      HT:হাইটি
      HU:হাংগেৰী
      IC:কেনেৰী দ্বীপপুঞ্জ
      ID:ইণ্ডোনেচিয়া
      IE:আয়াৰলেণ্ড
      IL:ইজৰাইল
      IM:আইল অফ মেন
      IN:ভাৰত
      IO:ব্ৰিটিছ ইণ্ডিয়ান অ’চন টেৰিট’ৰি
      IQ:ইৰাক
      IR:ইৰান
      IS:আইচলেণ্ড
      IT:ইটালি
      JE:জাৰ্চি
      JM:জামাইকা
      JO:জৰ্ডান
      JP:জাপান
      KE:কেনিয়া
      KG:কিৰ্গিজস্তান
      KH:কম্বোডিয়া
      KI:কিৰিবাটি
      KM:কোমোৰোজ
      KN:ছেইণ্ট কিটছ আৰু নেভিছ
      KP:উত্তৰ কোৰিয়া
      KR:দক্ষিণ কোৰিয়া
      KW:কুৱেইট
      KY:কেইমেন দ্বীপপুঞ্জ
      KZ:কাজাখাস্তান
      LA:লাওচ
      LB:লেবানন
      LC:ছেইণ্ট লুচিয়া
      LI:লিচটেনষ্টেইন
      LK:শ্রীলংকা
      LR:লিবেৰিয়া
      LS:লেছ’থ’
      LT:লিথুৱানিয়া
      LU:লাক্সেমবাৰ্গ
      LV:লাটভিয়া
      LY:লিবিয়া
      MA:মৰক্কো
      MC:মোনাকো
      MD:মোলডোভা
      ME:মণ্টেনেগ্ৰু
      MF:ছেইণ্ট মাৰ্টিন
      MG:মাদাগাস্কাৰ
      MH:মাৰ্শ্বাল দ্বীপপুঞ্জ
      MK:উত্তৰ মেচিডোনীয়া
      ML:মালি
      MM:ম্যানমাৰ (বাৰ্মা)
      MN:মঙ্গোলিয়া
      MO:মাকাও এছ. এ. আৰ. চীন
      MP:উত্তৰ মাৰিয়ানা দ্বীপপুঞ্জ
      MQ:মাৰ্টিনিক
      MR:মাউৰিটানিয়া
      MS:ম’ণ্টছেৰাট
      MT:মাল্টা
      MU:মৰিছাছ
      MV:মালদ্বীপ
      MW:মালাৱি
      MX:মেক্সিকো
      MY:মালয়েচিয়া
      MZ:ম’জামবিক
      NA:নামিবিয়া
      NC:নিউ কেলিডোনিয়া
      NE:নাইজাৰ
      NF:ন’ৰফ’ক দ্বীপ
      NG:নাইজেৰিয়া
      NI:নিকাৰাগুৱা
      NL:নেডাৰলেণ্ড
      NO:নৰৱে
      NP:নেপাল
      NR:নাউৰু
      NU:নিউ
      NZ:নিউজিলেণ্ড
      OM:ওমান
      PA:পানামা
      PE:পেৰু
      PF:ফ্ৰান্স পোলেনচিয়া
      PG:পাপুৱা নিউ গিনি
      PH:ফিলিপাইনছ
      PK:পাকিস্তান
      PL:পোলেণ্ড
      PM:ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলন
      PN:পিটকেইৰ্ণ দ্বীপপুঞ্জ
      PR:পুৱেৰ্টো ৰিকো
      PS:ফিলিস্তিন অঞ্চল
      PT:পৰ্তুগাল
      PW:পালাউ
      PY:পাৰাগুৱে
      QA:কাটাৰ
      QO:আউটলায়িং অ’চিয়ানিয়া
      RE:ৰিইউনিয়ন
      RO:ৰোমানিয়া
      RS:ছাৰ্বিয়া
      RU:ৰাছিয়া
      RW:ৰোৱাণ্ডা
      SA:চৌডি আৰবিয়া
      SB:চোলোমোন দ্বীপপুঞ্জ
      SC:ছিচিলিছ
      SD:চুডান
      SE:চুইডেন
      SG:ছিংগাপুৰ
      SH:ছেইণ্ট হেলেনা
      SI:শ্লোভেনিয়া
      SJ:চাভালবাৰ্ড আৰু জন মেয়ন
      SK:শ্লোভাকিয়া
      SL:চিয়েৰা লিঅ’ন
      SM:চান মাৰিনো
      SN:চেনেগাল
      SO:চোমালিয়া
      SR:ছুৰিনাম
      SS:দক্ষিণ চুডান
      ST:চাও টোমে আৰু প্ৰিনচিপে
      SV:এল ছেলভেড’ৰ
      SX:চিণ্ট মাৰ্টেন
      SY:চিৰিয়া
      SZ:ইচ্চুটিনি
      TA:ত্ৰিস্তান দ্যা কুনহা
      TC:টাৰ্কছ অৰু কেইক’ছ দ্বীপপুঞ্জ
      TD:চাড
      TF:দক্ষিণ ফ্ৰান্সৰ অঞ্চল
      TG:টোগো
      TH:থাইলেণ্ড
      TJ:তাজিকিস্তান
      TK:টোকেলাউ
      TL:টিমোৰ-লেচটে
      TM:তুৰ্কমেনিস্তান
      TN:টুনিচিয়া
      TO:টংগা
      TR:তুৰ্কিয়ে
      TT:ট্ৰিনিডাড আৰু টোবাগো
      TV:টুভালু
      TW:টাইৱান
      TZ:তাঞ্জানিয়া
      UA:ইউক্ৰেইন
      UG:উগাণ্ডা
      UM:ইউ. এছ. আউটলায়িং দ্বীপপুঞ্জ
      UN:ৰাষ্ট্ৰসংঘ
      US:মাৰ্কিন যুক্তৰাষ্ট্ৰ
      UY:উৰুগুৱে
      UZ:উজবেকিস্তান
      VA:ভেটিকান চিটি
      VC:ছেইণ্ট ভিনচেণ্ট আৰু গ্ৰীণাডাইনছ
      VE:ভেনিজুৱেলা
      VG:ব্ৰিটিছ ভাৰ্জিন দ্বীপপুঞ্জ
      VI:ইউ. এছ. ভাৰ্জিন দ্বীপপুঞ্জ
      VN:ভিয়েটনাম
      VU:ভানাটু
      WF:ৱালিছ আৰু ফুটুনা
      WS:চামোৱা
      XA:ছুডু-একচেণ্ট
      XB:ছুডু-বিডি
      XK:কচ’ভ’
      YE:য়েমেন
      YT:মায়োট্টে
      ZA:দক্ষিণ আফ্রিকা
      ZM:জাম্বিয়া
      ZW:জিম্বাবৱে
      ZZ:অজ্ঞাত ক্ষেত্ৰ
      """.trimIndent() }

  val asa: String by lazy { """
      AD:Andora
      AE:Falme dha Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Thamoa ya Marekani
      AT:Authtria
      AU:Authtralia
      AW:Aruba
      AZ:Adhabajani
      BA:Bothnia na Hedhegovina
      BB:Babadothi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafatho
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botthwana
      BY:Belaruthi
      BZ:Belidhe
      CA:Kanada
      CD:Jamhuri ya Kidemokrathia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uthwithi
      CI:Kodivaa
      CK:Vithiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kothtarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprothi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Ethtonia
      EG:Mithri
      ER:Eritrea
      ES:Hithpania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Vithiwa vya Falkland
      FM:Mikronethia
      FR:Ufarantha
      GA:Gaboni
      GB:Uingeredha
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufarantha
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurathi
      HR:Korathia
      HT:Haiti
      HU:Hungaria
      ID:Indonethia
      IE:Ayalandi
      IL:Ithraeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aithlandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizithtani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Thantakitdhi na Nevith
      KP:Korea Kathkazini
      KR:Korea Kuthini
      KW:Kuwaiti
      KY:Vithiwa vya Kayman
      KZ:Kazakithtani
      LA:Laothi
      LB:Lebanoni
      LC:Thantaluthia
      LI:Lishenteni
      LK:Thirilanka
      LR:Liberia
      LS:Lethoto
      LT:Litwania
      LU:Lathembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Vithiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Vithiwa vya Mariana vya Kathkazini
      MQ:Martiniki
      MR:Moritania
      MS:Monttherrati
      MT:Malta
      MU:Morithi
      MV:Modivu
      MW:Malawi
      MX:Mekthiko
      MY:Malethia
      MZ:Mthumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kithiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholandhi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyudhilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufarantha
      PG:Papua
      PH:Filipino
      PK:Pakithtani
      PL:Polandi
      PM:Thantapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Uruthi
      RW:Rwanda
      SA:Thaudi
      SB:Vithiwa vya Tholomon
      SC:Shelisheli
      SD:Thudani
      SE:Uthwidi
      SG:Thingapoo
      SH:Thantahelena
      SI:Thlovenia
      SK:Tholvakia
      SL:Thiera Leoni
      SM:Thamarino
      SN:Thenegali
      SO:Thomalia
      SR:Thurinamu
      ST:Thao Tome na Principe
      SV:Elsavado
      SY:Thiria
      SZ:Uthwadhi
      TC:Vithiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikithtani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenithtani
      TN:Tunithia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tadhania
      UG:Uganda
      US:Marekani
      UY:Urugwai
      UZ:Udhibekithtani
      VA:Vatikani
      VC:Thantavithenti na Grenadini
      VE:Venezuela
      VG:Vithiwa vya Virgin vya Uingeredha
      VI:Vithiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walith na Futuna
      WS:Thamoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kuthini
      ZM:Dhambia
      ZW:Dhimbabwe
      """.trimIndent() }

  val ast: String by lazy { """
      001:Mundu
      002:África
      003:Norteamérica
      005:América del Sur
      009:Oceanía
      011:África Occidental
      013:América Central
      014:África Oriental
      015:África del Norte
      017:África Central
      018:África del Sur
      019:América
      021:América del Norte
      029:Caribe
      030:Asia Oriental
      034:Asia del Sur
      035:Sureste Asiáticu
      039:Europa del Sur
      053:Australasia
      054:Melanesia
      057:Rexón de Micronesia
      061:Polinesia
      142:Asia
      143:Asia Central
      145:Asia Occidental
      150:Europa
      151:Europa Oriental
      154:Europa del Norte
      155:Europa Occidental
      419:América Llatina
      AC:Islla Ascensión
      AD:Andorra
      AE:Emiratos Árabes Xuníos
      AF:Afganistán
      AG:Antigua y Barbuda
      AI:Anguila
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:L’Antártida
      AR:Arxentina
      AS:Samoa Americana
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Islles Aland
      AZ:Azerbaixán
      BA:Bosnia y Herzegovina
      BB:Barbados
      BD:Bangladex
      BE:Bélxica
      BF:Burkina Fasu
      BG:Bulgaria
      BH:Baḥréin
      BI:Burundi
      BJ:Benín
      BL:San Bartolomé
      BM:Les Bermudes
      BN:Brunéi
      BO:Bolivia
      BQ:Caribe neerlandés
      BR:Brasil
      BS:Les Bahames
      BT:Bután
      BV:Islla Bouvet
      BW:Botsuana
      BY:Bielorrusia
      BZ:Belize
      CA:Canadá
      CC:Islles Cocos (Keeling)
      CD:Congu - Kinxasa
      CF:República Centroafricana
      CG:Congu - Brazzaville
      CH:Suiza
      CI:Costa de Marfil
      CK:Islles Cook
      CL:Chile
      CM:Camerún
      CN:China
      CO:Colombia
      CP:Islla Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cabu Verde
      CW:Curaçao
      CX:Islla Christmas
      CY:Xipre
      CZ:Chequia
      DE:Alemaña
      DG:Diego Garcia
      DJ:Xibuti
      DK:Dinamarca
      DM:Dominica
      DO:República Dominicana
      DZ:Arxelia
      EA:Ceuta y Melilla
      EC:Ecuador
      EE:Estonia
      EG:Exiptu
      EH:Sáḥara Occidental
      ER:Eritrea
      ES:España
      ET:Etiopía
      EU:Xunión Europea
      EZ:Eurozona
      FI:Finlandia
      FJ:Islles Fixi
      FK:Falkland Islands
      FM:Micronesia
      FO:Islles Feroe
      FR:Francia
      GA:Gabón
      GB:Reinu Xuníu
      GD:Granada
      GE:Xeorxa
      GF:Guyana Francesa
      GG:Guernsey
      GH:Ghana
      GI:Xibraltar
      GL:Groenlandia
      GM:Gambia
      GN:Guinea
      GP:Guadalupe
      GQ:Guinea Ecuatorial
      GR:Grecia
      GS:Islles Xeorxa del Sur y Sandwich del Sur
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bisáu
      GY:Guyana
      HK:ARE China de Ḥong Kong
      HM:Islles Heard y McDonald
      HN:Hondures
      HR:Croacia
      HT:Haití
      HU:Hungría
      IC:Islles Canaries
      ID:Indonesia
      IE:Irlanda
      IL:Israel
      IM:Islla de Man
      IN:India
      IQ:Iraq
      IR:Irán
      IS:Islandia
      IT:Italia
      JE:Jersey
      JM:Xamaica
      JO:Xordania
      JP:Xapón
      KE:Kenia
      KG:Kirguistán
      KH:Camboya
      KI:Kiribati
      KM:Les Comores
      KN:Saint Kitts y Nevis
      KP:Corea del Norte
      KR:Corea del Sur
      KW:Kuwait
      KY:Islles Caimán
      KZ:Kazakstán
      LA:Laos
      LB:Líbanu
      LC:Santa Llucía
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesothu
      LT:Lituania
      LU:Luxemburgu
      LV:Letonia
      LY:Libia
      MA:Marruecos
      MC:Mónacu
      MD:Moldavia
      ME:Montenegru
      MF:Saint Martin
      MG:Madagascar
      MH:Islles Marshall
      ML:Malí
      MM:Myanmar (Birmania)
      MN:Mongolia
      MO:ARE China de Macáu
      MP:Islles Marianes del Norte
      MQ:La Martinica
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauriciu
      MV:Les Maldives
      MW:Malaui
      MX:Méxicu
      MY:Malasia
      MZ:Mozambique
      NA:Namibia
      NC:Nueva Caledonia
      NE:El Níxer
      NF:Islla Norfolk
      NG:Nixeria
      NI:Nicaragua
      NL:Países Baxos
      NO:Noruega
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nueva Zelanda
      OM:Omán
      PA:Panamá
      PE:Perú
      PF:Polinesia Francesa
      PG:Papúa Nueva Guinea
      PH:Filipines
      PK:Paquistán
      PL:Polonia
      PM:Saint Pierre y Miquelon
      PN:Islles Pitcairn
      PR:Puertu Ricu
      PS:Territorios Palestinos
      PT:Portugal
      PW:Paláu
      PY:Paraguái
      QA:Qatar
      QO:Oceanía esterior
      RE:Reunión
      RO:Rumanía
      RS:Serbia
      RU:Rusia
      RW:Ruanda
      SA:Arabia Saudita
      SB:Islles Salomón
      SC:Les Seixeles
      SD:Sudán
      SE:Suecia
      SG:Singapur
      SH:Santa Helena
      SI:Eslovenia
      SJ:Svalbard ya Islla Jan Mayen
      SK:Eslovaquia
      SL:Sierra Lleona
      SM:San Marín
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Sudán del Sur
      ST:Santu Tomé y Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Siria
      SZ:Suazilandia
      TA:Tristán da Cunha
      TC:Islles Turques y Caicos
      TD:Chad
      TF:Tierres Australes Franceses
      TG:Togu
      TH:Tailandia
      TJ:Taxiquistán
      TK:Tokeláu
      TL:Timor Oriental
      TM:Turkmenistán
      TN:Tunicia
      TO:Tonga
      TR:Turquía
      TT:Trinidá y Tobagu
      TV:Tuvalu
      TW:Taiwán
      TZ:Tanzania
      UA:Ucraína
      UG:Uganda
      UM:Islles Perifériques Menores de los EE.XX.
      UN:Naciones Xuníes
      US:Estaos Xuníos
      UY:Uruguái
      UZ:Uzbequistán
      VA:Ciudá del Vaticanu
      VC:San Vicente y Granadines
      VE:Venezuela
      VG:Islles Vírxenes Britániques
      VI:Islles Vírxenes Americanes
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis y Futuna
      WS:Samoa
      XK:Kosovu
      YE:Yemen
      YT:Mayotte
      ZA:Sudáfrica
      ZM:Zambia
      ZW:Zimbabue
      ZZ:Rexón desconocida
      """.trimIndent() }

  val az: String by lazy { """
      001:Dünya
      002:Afrika
      003:Şimali Amerika
      005:Cənubi Amerika
      009:Okeaniya
      011:Qərbi Afrika
      013:Mərkəzi Amerika
      014:Şərqi Afrika
      015:Şimali Afrika
      017:Mərkəzi Afrika
      018:Cənubi Afrika
      019:Amerika
      021:Şimal Amerikası
      029:Karib
      030:Şərqi Asiya
      034:Cənubi Asiya
      035:Cənub-Şərqi Asiya
      039:Cənubi Avropa
      053:Avstralaziya
      054:Melaneziya
      057:Mikroneziya Regionu
      061:Polineziya
      142:Asiya
      143:Mərkəzi Asiya
      145:Qərbi Asiya
      150:Avropa
      151:Şərqi Avropa
      154:Şimali Avropa
      155:Qərbi Avropa
      202:Saharadan cənub
      419:Latın Amerikası
      AC:Askenson adası
      AD:Andorra
      AE:Birləşmiş Ərəb Əmirlikləri
      AF:Əfqanıstan
      AG:Antiqua və Barbuda
      AI:Angilya
      AL:Albaniya
      AM:Ermənistan
      AO:Anqola
      AQ:Antarktika
      AR:Argentina
      AS:Amerika Samoası
      AT:Avstriya
      AU:Avstraliya
      AW:Aruba
      AX:Aland adaları
      AZ:Azərbaycan
      BA:Bosniya və Herseqovina
      BB:Barbados
      BD:Banqladeş
      BE:Belçika
      BF:Burkina Faso
      BG:Bolqarıstan
      BH:Bəhreyn
      BI:Burundi
      BJ:Benin
      BL:Sent-Bartelemi
      BM:Bermud adaları
      BN:Bruney
      BO:Boliviya
      BQ:Karib Niderlandı
      BR:Braziliya
      BS:Baham adaları
      BT:Butan
      BV:Buve adası
      BW:Botsvana
      BY:Belarus
      BZ:Beliz
      CA:Kanada
      CC:Kokos (Kilinq) adaları
      CD:Konqo - Kinşasa
      CF:Mərkəzi Afrika Respublikası
      CG:Konqo - Brazzavil
      CH:İsveçrə
      CI:Kotd’ivuar
      CK:Kuk adaları
      CL:Çili
      CM:Kamerun
      CN:Çin
      CO:Kolumbiya
      CP:Klipperton adası
      CR:Kosta Rika
      CU:Kuba
      CV:Kabo-Verde
      CW:Kurasao
      CX:Milad adası
      CY:Kipr
      CZ:Çexiya
      DE:Almaniya
      DG:Dieqo Qarsiya
      DJ:Cibuti
      DK:Danimarka
      DM:Dominika
      DO:Dominikan Respublikası
      DZ:Əlcəzair
      EA:Seuta və Melilya
      EC:Ekvador
      EE:Estoniya
      EG:Misir
      EH:Qərbi Saxara
      ER:Eritreya
      ES:İspaniya
      ET:Efiopiya
      EU:Avropa Birliyi
      EZ:Avrozona
      FI:Finlandiya
      FJ:Fici
      FK:Folklend adaları
      FM:Mikroneziya
      FO:Farer adaları
      FR:Fransa
      GA:Qabon
      GB:Birləşmiş Krallıq
      GD:Qrenada
      GE:Gürcüstan
      GF:Fransa Qvianası
      GG:Gernsi
      GH:Qana
      GI:Cəbəllütariq
      GL:Qrenlandiya
      GM:Qambiya
      GN:Qvineya
      GP:Qvadelupa
      GQ:Ekvatorial Qvineya
      GR:Yunanıstan
      GS:Cənubi Corciya və Cənubi Sendviç adaları
      GT:Qvatemala
      GU:Quam
      GW:Qvineya-Bisau
      GY:Qayana
      HK:Honq Konq Xüsusi İnzibati Rayonu Çin
      HM:Herd və Makdonald adaları
      HN:Honduras
      HR:Xorvatiya
      HT:Haiti
      HU:Macarıstan
      IC:Kanar adaları
      ID:İndoneziya
      IE:İrlandiya
      IL:İsrail
      IM:Men adası
      IN:Hindistan
      IO:Britaniyanın Hind Okeanı Ərazisi
      IQ:İraq
      IR:İran
      IS:İslandiya
      IT:İtaliya
      JE:Cersi
      JM:Yamayka
      JO:İordaniya
      JP:Yaponiya
      KE:Keniya
      KG:Qırğızıstan
      KH:Kamboca
      KI:Kiribati
      KM:Komor adaları
      KN:Sent-Kits və Nevis
      KP:Şimali Koreya
      KR:Cənubi Koreya
      KW:Küveyt
      KY:Kayman adaları
      KZ:Qazaxıstan
      LA:Laos
      LB:Livan
      LC:Sent-Lusiya
      LI:Lixtenşteyn
      LK:Şri-Lanka
      LR:Liberiya
      LS:Lesoto
      LT:Litva
      LU:Lüksemburq
      LV:Latviya
      LY:Liviya
      MA:Mərakeş
      MC:Monako
      MD:Moldova
      ME:Monteneqro
      MF:Sent Martin
      MG:Madaqaskar
      MH:Marşal adaları
      MK:Şimali Makedoniya
      ML:Mali
      MM:Myanma
      MN:Monqolustan
      MO:Makao XİR Çin
      MP:Şimali Marian adaları
      MQ:Martinik
      MR:Mavritaniya
      MS:Monserat
      MT:Malta
      MU:Mavriki
      MV:Maldiv adaları
      MW:Malavi
      MX:Meksika
      MY:Malayziya
      MZ:Mozambik
      NA:Namibiya
      NC:Yeni Kaledoniya
      NE:Niger
      NF:Norfolk adası
      NG:Nigeriya
      NI:Nikaraqua
      NL:Niderland
      NO:Norveç
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Yeni Zelandiya
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Fransa Polineziyası
      PG:Papua-Yeni Qvineya
      PH:Filippin
      PK:Pakistan
      PL:Polşa
      PM:Müqəddəs Pyer və Mikelon
      PN:Pitkern adaları
      PR:Puerto Riko
      PS:Fələstin Əraziləri
      PT:Portuqaliya
      PW:Palau
      PY:Paraqvay
      QA:Qətər
      QO:Uzaq Okeaniya
      RE:Reyunyon
      RO:Rumıniya
      RS:Serbiya
      RU:Rusiya
      RW:Ruanda
      SA:Səudiyyə Ərəbistanı
      SB:Solomon adaları
      SC:Seyşel adaları
      SD:Sudan
      SE:İsveç
      SG:Sinqapur
      SH:Müqəddəs Yelena
      SI:Sloveniya
      SJ:Svalbard və Yan-Mayen
      SK:Slovakiya
      SL:Syerra-Leone
      SM:San-Marino
      SN:Seneqal
      SO:Somali
      SR:Surinam
      SS:Cənubi Sudan
      ST:San-Tome və Prinsipi
      SV:Salvador
      SX:Sint-Marten
      SY:Suriya
      SZ:Esvatini
      TA:Tristan da Kunya
      TC:Törks və Kaykos adaları
      TD:Çad
      TF:Fransanın Cənub Əraziləri
      TG:Toqo
      TH:Tailand
      TJ:Tacikistan
      TK:Tokelau
      TL:Şərqi Timor
      TM:Türkmənistan
      TN:Tunis
      TO:Tonqa
      TR:Türkiyə
      TT:Trinidad və Tobaqo
      TV:Tuvalu
      TW:Tayvan
      TZ:Tanzaniya
      UA:Ukrayna
      UG:Uqanda
      UM:ABŞ-a bağlı kiçik adacıqlar
      UN:Birləşmiş Millətlər Təşkilatı
      US:Amerika Birləşmiş Ştatları
      UY:Uruqvay
      UZ:Özbəkistan
      VA:Vatikan
      VC:Sent-Vinsent və Qrenadinlər
      VE:Venesuela
      VG:Britaniyanın Virgin adaları
      VI:ABŞ Virgin adaları
      VN:Vyetnam
      VU:Vanuatu
      WF:Uollis və Futuna
      WS:Samoa
      XA:Psevdo-Aksent
      XB:Psevdo-Bidi
      XK:Kosovo
      YE:Yəmən
      YT:Mayot
      ZA:Cənub Afrika
      ZM:Zambiya
      ZW:Zimbabve
      ZZ:Naməlum Region
      """.trimIndent() }

  val az_Arab: String by lazy { """
      001:دۆنیا
      """.trimIndent() }

  val az_Arab_IQ: String? = null

  val az_Arab_TR: String? = null

  val az_Cyrl: String by lazy { """
      001:Дүнја
      002:Африка
      003:Шимали Америка
      005:Ҹәнуби Америка
      009:Океанија
      011:Гәрби Африка
      013:Мәркәзи Америка
      014:Шәрги Африка
      015:Шимали Африка
      017:Мәркәзи Африка
      018:Ҹәнуби Африка
      019:Америка
      021:Шимал Америкасы
      029:Кариб
      030:Шәрги Асија
      034:Ҹәнуби Асија
      035:Ҹәнуб-Шәрги Асија
      039:Ҹәнуби Авропа
      053:Австралазија
      054:Меланезија
      057:Микронезија Реҝиону
      061:Полинезија
      142:Асија
      143:Мәркәзи Асија
      145:Гәрби Асија
      150:Авропа
      151:Шәрги Авропа
      154:Шимали Авропа
      155:Гәрби Авропа
      419:Латын Америкасы
      AC:Аскенсон адасы
      AD:Андорра
      AE:Бирләшмиш Әрәб Әмирликләри
      AF:Әфганыстан
      AG:Антигуа вә Барбуда
      AI:Анҝилја
      AL:Албанија
      AM:Ермәнистан
      AO:Ангола
      AQ:Антарктика
      AR:Арҝентина
      AS:Америка Самоасы
      AT:Австрија
      AU:Австралија
      AW:Аруба
      AX:Аланд адалары
      AZ:Азәрбајҹан
      BA:Боснија вә Һерсеговина
      BB:Барбадос
      BD:Бангладеш
      BE:Белчика
      BF:Буркина Фасо
      BG:Болгарыстан
      BH:Бәһрејн
      BI:Бурунди
      BJ:Бенин
      BL:Сент-Бартелеми
      BM:Бермуд адалары
      BN:Брунеј
      BO:Боливија
      BR:Бразилија
      BS:Баһам адалары
      BT:Бутан
      BV:Буве адасы
      BW:Ботсвана
      BY:Беларус
      BZ:Белиз
      CA:Канада
      CC:Кокос (Килинг) адалары
      CD:Конго-Киншаса
      CF:Мәркәзи Африка Республикасы
      CG:Конго-Браззавил
      CH:Исвечрә
      CI:Котд’ивуар
      CK:Кук адалары
      CL:Чили
      CM:Камерун
      CN:Чин
      CO:Колумбија
      CP:Клиппертон адасы
      CR:Коста Рика
      CU:Куба
      CV:Кабо-Верде
      CW:Курасао
      CX:Милад адасы
      CY:Кипр
      CZ:Чехија
      DE:Алманија
      DG:Диего Гарсија
      DJ:Ҹибути
      DK:Данимарка
      DM:Доминика
      DO:Доминикан Республикасы
      DZ:Әлҹәзаир
      EA:Сеута вә Мелилја
      EC:Еквадор
      EE:Естонија
      EG:Мисир
      ER:Еритреја
      ES:Испанија
      ET:Ефиопија
      EU:Авропа Бирлији
      FI:Финландија
      FJ:Фиҹи
      FK:Фолкленд адалары
      FM:Микронезија
      FO:Фарер адалары
      FR:Франса
      GA:Габон
      GB:Бирләшмиш Краллыг
      GD:Гренада
      GE:Ҝүрҹүстан
      GF:Франса Гвианасы
      GG:Ҝернси
      GH:Гана
      GI:Ҹәбәллүтариг
      GL:Гренландија
      GM:Гамбија
      GN:Гвинеја
      GP:Гваделупа
      GQ:Екваториал Гвинеја
      GR:Јунаныстан
      GS:Ҹәнуби Ҹорҹија вә Ҹәнуби Сендвич адалары
      GT:Гватемала
      GU:Гуам
      GW:Гвинеја-Бисау
      GY:Гајана
      HK:Һонк Конг Хүсуси Инзибати Әрази Чин
      HM:Һерд вә Макдоналд адалары
      HN:Һондурас
      HR:Хорватија
      HT:Һаити
      HU:Маҹарыстан
      IC:Канар адалары
      ID:Индонезија
      IE:Ирландија
      IL:Исраил
      IM:Мен адасы
      IN:Һиндистан
      IQ:Ираг
      IR:Иран
      IS:Исландија
      IT:Италија
      JE:Ҹерси
      JM:Јамајка
      JO:Иорданија
      JP:Јапонија
      KE:Кенија
      KG:Гырғызыстан
      KH:Камбоҹа
      KI:Кирибати
      KM:Комор адалары
      KN:Сент-Китс вә Невис
      KP:Шимали Кореја
      KR:Ҹәнуби Кореја
      KW:Күвејт
      KY:Кајман адалары
      KZ:Газахыстан
      LA:Лаос
      LB:Ливан
      LC:Сент-Лусија
      LI:Лихтенштејн
      LK:Шри-Ланка
      LR:Либерија
      LS:Лесото
      LT:Литва
      LU:Лүксембург
      LV:Латвија
      LY:Ливија
      MA:Мәракеш
      MC:Монако
      MD:Молдова
      ME:Монтенегро
      MF:Сент Мартин
      MG:Мадагаскар
      MH:Маршал адалары
      ML:Мали
      MM:Мјанма
      MN:Монголустан
      MO:Макао Хүсуси Инзибати Әрази Чин
      MP:Шимали Мариан адалары
      MQ:Мартиник
      MR:Мавританија
      MS:Монсерат
      MT:Малта
      MU:Маврики
      MV:Малдив адалары
      MW:Малави
      MX:Мексика
      MY:Малајзија
      MZ:Мозамбик
      NA:Намибија
      NC:Јени Каледонија
      NE:Ниҝер
      NF:Норфолк адасы
      NG:Ниҝерија
      NI:Никарагуа
      NL:Нидерланд
      NO:Норвеч
      NP:Непал
      NR:Науру
      NU:Ниуе
      NZ:Јени Зеландија
      OM:Оман
      PA:Панама
      PE:Перу
      PF:Франса Полинезијасы
      PG:Папуа-Јени Гвинеја
      PH:Филиппин
      PK:Пакистан
      PL:Полша
      PM:Мүгәддәс Пјер вә Микелон
      PN:Питкерн адалары
      PR:Пуерто Рико
      PT:Португалија
      PW:Палау
      PY:Парагвај
      QA:Гәтәр
      QO:Узаг Океанија
      RE:Рејунјон
      RO:Румынија
      RS:Сербија
      RU:Русија
      RW:Руанда
      SA:Сәудијјә Әрәбистаны
      SB:Соломон адалары
      SC:Сејшел адалары
      SD:Судан
      SE:Исвеч
      SG:Сингапур
      SH:Мүгәддәс Јелена
      SI:Словенија
      SJ:Свалбард вә Јан-Мајен
      SK:Словакија
      SL:Сјерра-Леоне
      SM:Сан-Марино
      SN:Сенегал
      SO:Сомали
      SR:Суринам
      SS:Ҹәнуби Судан
      ST:Сан-Томе вә Принсипи
      SV:Салвадор
      SX:Синт-Мартен
      SY:Сурија
      SZ:Свазиленд
      TA:Тристан да Кунја
      TC:Төркс вә Кајкос адалары
      TD:Чад
      TF:Франсанын Ҹәнуб Әразиләри
      TG:Того
      TH:Таиланд
      TJ:Таҹикистан
      TK:Токелау
      TL:Шәрги Тимор
      TM:Түркмәнистан
      TN:Тунис
      TO:Тонга
      TR:Түркијә
      TT:Тринидад вә Тобаго
      TV:Тувалу
      TW:Тајван
      TZ:Танзанија
      UA:Украјна
      UG:Уганда
      UM:АБШ-а бағлы кичик адаҹыглар
      US:Америка Бирләшмиш Штатлары
      UY:Уругвај
      UZ:Өзбәкистан
      VA:Ватикан
      VC:Сент-Винсент вә Гренадинләр
      VE:Венесуела
      VG:Британијанын Вирҝин адалары
      VI:АБШ Вирҝин адалары
      VN:Вјетнам
      VU:Вануату
      WF:Уоллис вә Футуна
      WS:Самоа
      XK:Косово
      YE:Јәмән
      YT:Мајот
      ZA:Ҹәнуб Африка
      ZM:Замбија
      ZW:Зимбабве
      ZZ:Намәлум Реҝион
      """.trimIndent() }

  val az_Latn: String? = null

  val bal_Latn: String by lazy { """
      001:Donyá
      002:Afriká
      003:Shemáli Amriká
      005:Zerbári Amriká
      009:Ushiáná
      011:Rónendi Apriká
      013:Myáni Amriká
      014:Ródarátki Apriká
      015:Shemáli Apriká
      017:Myáni Apriká
      018:Jonubi Apriká
      019:Amriká
      021:Shemáli Amrika
      029:Kerébian
      030:Ródarátki Ásiá
      034:Zerbári Ásiá
      035:Zerbárródarátki Ásiá
      039:Zerbári Yurop
      053:Ástrálásiá
      054:Melanésiá
      057:Máekrónési Damag
      061:Pólinisiá
      142:Ásiá
      143:Myáni Ásiá
      145:Rónendi Ásiá
      150:Yurop
      151:Ródarátki Yurop
      154:Shemáli Yurop
      155:Rónendi Yurop
      202:Sab-Sahári Apriká
      419:Látini Amriká
      AC:Asenshan Islánd
      AD:Andorrá
      AE:Emárát
      AF:Awghánestán
      AG:Antiga o Barbuda
      AI:Angwila
      AL:Albániá
      AM:Árminiá
      AO:Angólá
      AQ:Antárktiká
      AR:Arjentiná
      AS:Amriki Samóá
      AT:Ástriá
      AU:Ásthréliá
      AW:Aruba
      AX:Áwlánd Islánd
      AZ:Ázerbáiján
      BA:Bósniá
      BB:Barbadós
      BD:Bangaladésh
      BE:Béljiam
      BF:Burkiná Pásó
      BG:Balgáriá
      BH:Bahren
      BI:Borondi
      BJ:Benin
      BL:St. Bartélémi
      BM:Barmudá
      BN:Brunái
      BO:Boliwiá
      BQ:Kerébi Nedarlánd
      BR:Brázil
      BS:Bahamas
      BT:Buthán
      BV:Bówet Islánd
      BW:Bostwáná
      BY:Bélárus
      BZ:Belize
      CA:Kaynadhá
      CC:Kukus Islánd (Kileng)
      CD:Kángó-Kenshásá
      CF:Myáni Apriki Eshtán
      CG:Kángó-Brázáwille
      CH:Swizarlánd
      CI:Kóté diáwóri
      CK:Kuk Islánd
      CL:Chilay
      CM:Kaymrun
      CN:Chin
      CO:Kólambiá
      CP:Klipperton Islánd
      CQ:Sárk
      CR:Kóstá Riká
      CU:Kyubá
      CV:Kap Wardé
      CW:Churácháó
      CX:Kresmes Islánd
      CY:Sáipras
      CZ:Chéchiá
      DE:Jarmani
      DG:Diégó Gárshiá
      DJ:Djebuti
      DK:Denmárk
      DM:Duminiká
      DO:Duminiki Están
      DZ:Aljiriá
      EA:Siótó o Melilá
      EC:Ekwádór
      EE:Estóniá
      EG:Mesr
      EH:Róbarkati Sahárá
      ER:Eritiriá
      ES:Espin
      ET:Etupiá
      EU:Yuropi Yunian
      EZ:Yurop-damag
      FI:Fenlánd
      FJ:Fiji
      FK:Páklánd Islánd
      FM:Mikrónéshiá
      FO:Faróé Islánd
      FR:Paráns
      GA:Gabon
      GB:Bartániá
      GD:Gerená
      GE:Járjiá
      GF:Pránsi Gwiáná
      GG:Gwernsay
      GH:Gáná
      GI:Gibráltar
      GL:Grinlánd
      GM:Gambiá
      GN:Giniá
      GP:Gwádelóp
      GQ:Ekwáturi Giniá
      GR:Yunán
      GS:Zerbári Járjiá
      GT:Gwátémálá
      GU:Guám
      GW:Giniá-Bissáu
      GY:Goyáná
      HK:Háng Káng o SAR Chin
      HM:Hard o Mekdónald Islánd
      HN:Honduras
      HR:Króshiá
      HT:Hayti
      HU:Hangari
      IC:Kanaray Islánd
      ID:Endhonéshiá
      IE:Áerlánd
      IL:Esráil
      IM:Áisale Mardom
      IN:Hendostán
      IO:Bartáni Hendi Zerdamag
      IQ:Erák
      IR:Érán
      IS:Áeslánd
      IT:Itáliá
      JE:Jersé
      JM:Jamáeká
      JO:Ordon
      JP:Jápán
      KE:Kiniá
      KG:Karghazestán
      KH:Kambódhiá
      KI:Kiribáti
      KM:Komórós
      KN:St. Kitts o Newis
      KP:Shamáli Kóriá
      KR:Zerbári Kóriá
      KW:Kwayt
      KY:Kaymi Islánd
      KZ:Kázakhestán
      LA:Láus
      LB:Lebnán
      LC:St. Lusiá
      LI:Lichtenstén
      LK:Sari Lanká
      LR:Láibériá
      LS:Lesótó
      LT:Lituániá
      LU:Loksembórg
      LV:Latwiá
      LY:Libyá
      MA:Morókó
      MC:Monákó
      MD:Moldowá
      ME:Montenegró
      MF:St. Mártin
      MG:Madagáskar
      MH:Marshall Islánd
      MK:Shemáli Makduniá
      ML:Máli
      MM:Myanmár (Barmá)
      MN:Mangóliá
      MO:Makaó SAR Chin
      MP:Shemáli Máriáná Islánd
      MQ:Mártinik
      MR:Muritániá
      MS:Montserrat
      MT:Máltá
      MU:Murishias
      MV:Máldip
      MW:Maláwi
      MX:Meksikó
      MY:Maléshiá
      MZ:Mózambik
      NA:Namibiá
      NC:Niu Káledóniá
      NE:Náiger
      NF:Nórfolk Islánd
      NG:Náijériá
      NI:Nekárágóá
      NL:Nedarlánd
      NO:Nárway
      NP:Népál
      NR:Náuru
      NU:Niué
      NZ:Nyu Zilánd
      OM:Omán
      PA:Pánámá
      PE:Péru
      PF:Paránsi Pulinishiá
      PG:Pápuá Niu Giniá
      PH:Pelpin
      PK:Pákestán
      PL:Pólánd
      PM:St. Péri o Mikwélin
      PN:Pitkarén Islánd
      PR:Piuró Rikó
      PS:Palastinay Damag
      PT:Portogál
      PW:Paláu
      PY:Parágóay
      QA:Gatar
      QO:Tálánén Zerbahrag
      RE:Réyunian
      RO:Rumániá
      RS:Sarbiá
      RU:Rus
      RW:Rwándhá
      SA:Saudi Arab
      SB:Solomán Islánd
      SC:Sécheles
      SD:Sudán
      SE:Swidhan
      SG:Sengápur
      SH:St. Heléná
      SI:Slowiniá
      SJ:Swalbard o Jan Mayén
      SK:Slowákiá
      SL:Sierrá Leóne
      SM:San Mariánó
      SN:Senigál
      SO:Sómáliá
      SR:Surinaym
      SS:Zerbári Sudán
      ST:Sáó Tóme o Prensip
      SV:El Salwadór
      SX:Sint Márten
      SY:Suriá
      SZ:Eswatini
      TA:Tristan dá Chonhá
      TC:Tork o Káikói Islánd
      TD:Chád
      TF:Pránsi Zerbári Damag
      TG:Tógó
      TH:Táilánd
      TJ:Tájekestán
      TK:Tokéláu
      TL:Témur-Leste
      TM:Torkmenestán
      TN:Tunishiá
      TO:Tongá
      TR:Turkiye
      TT:Trinidad o Tobágó
      TV:Tuwalu
      TW:Táiwán
      TZ:Tanzániá
      UA:Yukrén
      UG:Yugandhá
      UM:U.S. Daráén Islánd
      UN:Myánostománi Gal
      US:Amrikáay Tepákén Están
      UY:Yurógóay
      UZ:Ozbekestán
      VA:Wátikán Sethi
      VC:St. Wensent o Grenádin
      VE:Wenezwélá
      VG:Bretáni Ajgén Islánd
      VI:Amriki Ajgén Islánd
      VN:Wietnám
      VU:Wanuátu
      WF:Wális o Futuná
      WS:Samóá
      XA:Kesási-Gálwár
      XB:Kesási- Bidi
      XK:Kósówó
      YE:Yaman
      YT:Mayotte
      ZA:Zerbári Apriká
      ZM:Zambiá
      ZW:Zembábwé
      ZZ:Nagisshetagén damag
      """.trimIndent() }

  val bas: String by lazy { """
      AD:Àŋdɔ̂r
      AE:Àdnà i Bilɔ̀ŋ bi Arābìà
      AF:Àfgànìstâŋ
      AG:Àŋtigà ɓɔ Bàrbudà
      AI:Àŋgiyà
      AL:Àlbanìà
      AM:Àrmenìà
      AO:Àŋgolà
      AR:Àrgàŋtinà
      AT:Òstrǐk
      AU:Òstralìà
      AW:Àrubà
      AZ:Àzɛ̀rbajàŋ
      BA:Bòhnià Ɛrzègòvinà
      BB:Bàrbadò
      BD:Bàŋglàdɛ̂s
      BE:Bɛlgyùm
      BF:Bùrkìnà Fasò
      BG:Bùlgarìà
      BH:Bàraìn
      BI:Bùrundì
      BJ:Bènɛ̂ŋ
      BM:Bɛ̀rmudà
      BN:Brunei
      BO:Bòlivìà
      BR:Bràsîl
      BS:Bàhamàs
      BT:Bùtân
      BW:Bòdsùanà
      BY:Bèlarùs
      BZ:Bèlîs
      CA:Kànadà
      CD:Kòŋgo ìkɛŋi
      CF:Ŋ̀ɛm Afrīkà
      CG:Kòŋgo
      CH:Sùwîs
      CI:Màŋ mi Njɔ̂k
      CK:Bìòn bi Kook
      CL:Kìlî
      CM:Kàmɛ̀rûn
      CN:Kinà
      CO:Kɔ̀lɔmbìà
      CR:Kòstà Rikà
      CU:Kubà
      CV:Kabwɛ᷆r
      CY:Kiprò
      DE:Jamân
      DJ:Jìbutì
      DK:Dànmârk
      DM:Dòmnîk
      DO:Dòmnikà
      DZ:Àlgerìà
      EC:Èkwàtorìà
      EE:Èstonìà
      EG:Ègîptò
      ER:Èrìtrěà
      ES:Pànya
      ET:Ètìopìà
      FI:Fìnlând
      FJ:Fiji
      FK:Bìòn bi Falkland
      FM:Mìkrònesìà
      FR:Pùlàsi / Fɛ̀lɛ̀nsi /
      GA:Gàbɔ̂ŋ
      GB:Àdnà i Lɔ̂ŋ
      GD:Grènadà
      GE:Gèɔrgìà
      GF:Gùyanà Pùlàsi
      GH:Ganà
      GI:Gìlbràtâr
      GL:Grǐnlànd
      GM:Gàmbià
      GN:Gìnê
      GP:Gwàdèlûp
      GQ:Gìne Èkwàtorìà
      GR:Grǐkyà
      GT:Gwàtèmalà
      GU:Gùâm
      GW:Gìne Bìsàô
      GY:Gùyanà
      HN:Ɔ̀ŋduràs
      HR:Kròasìà
      HT:Àitì
      HU:Ɔ̀ŋgriì
      ID:Indònèsià
      IE:Ìrlând
      IL:Isràɛ̂l
      IN:Indìà
      IQ:Ìrâk
      IR:Ìrâŋ
      IS:Ìslandìà
      IT:Ìtalìà
      JM:Jàmàikà
      JO:Yɔ̀rdanià
      KE:Kenìà
      KG:Kìrgìzìstàŋ
      KH:Kàmbodìà
      KI:Kìrìbatì
      KM:Kɔ̀mɔ̂r
      KN:Nûmpubi Kîts nì Nevìs
      KP:Kɔ̀re ì Ŋ̀ɔmbɔk
      KR:Kɔ̀re ì Ŋ̀wɛ̀lmbɔk
      KW:Kòwêt
      KY:Bìòn bi Kaymàn
      KZ:Kàzàkstâŋ
      LA:Làôs
      LB:Lèbanòn
      LC:Nûmpubi Lusì
      LI:Ligstɛntàn
      LK:Srìlaŋkà
      LR:Lìberìà
      LS:Lesòtò
      LT:Lìtùanìà
      LU:Lùgsàmbûr
      LV:Làdvià
      LY:Libìà
      MA:Màrokò
      MC:Mònakò
      MD:Moldavìà
      MG:Màdàgàskâr
      MH:Bìòn bi Marcàl
      ML:Màli
      MM:Myànmâr
      MN:Mòŋgolìà
      MP:Bìòn bi Marìanà ŋ̀ɔmbɔk
      MQ:Màrtìnîk
      MR:Mòrìtanìà
      MS:Mɔ̀ŋseràt
      MT:Maltà
      MU:Mòrîs
      MV:Màldîf
      MW:Màlàwi
      MX:Mɛ̀gsîk
      MY:Màlɛ̀sìà
      MZ:Mòsàmbîk
      NA:Nàmibìà
      NC:Kàlèdonìà Yɔ̀ndɔ
      NE:Nìjɛ̂r
      NF:Òn i Nɔrfɔ̂k
      NG:Nìgerìà
      NI:Nìkàragwà
      NL:Ǹlɛndi
      NO:Nɔ̀rvegìà
      NP:Nèpâl
      NR:Nerù
      NU:Nìuɛ̀
      NZ:Sìlând Yɔ̀ndɔ
      OM:Òmân
      PA:Pànàma
      PE:Pèrû
      PF:Pòlìnesìà Pùlàsi
      PG:Gìne ì Pàpu
      PH:Fìlìpîn
      PK:Pàkìstân
      PL:Pòlànd
      PM:Nûmpubi Petrò nì Mikèlôn
      PN:Pìdkaìrn
      PR:Pɔ̀rtò Rikò
      PS:Pàlɛ̀htinà Hyɔ̀ŋg nì Gazà
      PT:Pɔ̀tɔkì
      PW:Pàlaù
      PY:Pàràgwê
      QA:Kàtâr
      RE:Rèunyɔ̂ŋ
      RO:Rùmanìà
      RU:Ruslànd
      RW:Rùandà
      SA:Sàudi Àrabìà
      SB:Bìòn bi Salōmò
      SC:Sèsɛ̂l
      SD:Sùdâŋ
      SE:Swedɛ̀n
      SG:Sìŋgàpûr
      SH:Nûmpubi Ɛlēnà
      SI:Slòvanìà
      SK:Slòvakìà
      SL:Sièra Lèɔ̂n
      SM:Nûmpubi Māatìn
      SN:Sènègâl
      SO:Sòmalìà
      SR:Sùrinâm
      ST:Sào Tòme ɓɔ Prɛ̀ŋcipè
      SV:Sàlvàdɔ̂r
      SY:Sirìà
      SZ:Swàzìlând
      TC:Bìòn bi Tûrks nì Kalkòs
      TD:Câd
      TG:Tògo
      TH:Taylànd
      TJ:Tàjìkìstaŋ
      TK:Tòkèlaò
      TL:Tìmɔ̂r lìkòl
      TM:Tùrgmènìstân
      TN:Tùnisìà
      TO:Tɔŋgà
      TR:Tùrkây
      TT:Trìnidàd ɓɔ Tòbagò
      TV:Tùvàlù
      TW:Tàywân
      TZ:Tànzànià
      UA:Ùkrɛ̌n
      UG:Ùgandà
      US:Àdnà i Bilɔ̀ŋ bi Amerkà
      UY:Ùrùgwêy
      UZ:Ùzbèkìstân
      VA:Vàtìkâŋ
      VC:Nûmpubi Vɛ̂ŋsâŋ nì grènàdîn
      VE:Vènèzùelà
      VG:Bìòn bi kɔnji bi Ŋgisì
      VI:Bìòn bi kɔnji bi U.S.
      VN:Vìɛ̀dnâm
      VU:Vànùatù
      WF:Wàlîs nì Fùtunà
      WS:Sàmoà
      YE:Yèmɛ̂n
      YT:Màyɔ̂t
      ZA:Àfrǐkà Sɔ̀
      ZM:Zàmbià
      ZW:Zìmbàbwê
      """.trimIndent() }

  val be: String by lazy { """
      001:Свет
      002:Афрыка
      003:Паўночная Амерыка
      005:Паўднёвая Амерыка
      009:Акіянія
      011:Заходняя Афрыка
      013:Цэнтральная Амерыка
      014:Усходняя Афрыка
      015:Паўночная Афрыка
      017:Сярэдняя Афрыка
      018:Паўднёвая Афрыка
      019:Паўночная і Паўднёвая Амерыкі
      021:Паўночнаамерыканскі рэгіён
      029:Карыбскі рэгіён
      030:Усходняя Азія
      034:Паўднёвая Азія
      035:Паўднёва-Усходняя Азія
      039:Паўднёвая Еўропа
      053:Аўстралазія
      054:Меланезія
      057:Мікранезійскі рэгіён
      061:Палінезія
      142:Азія
      143:Цэнтральная Азія
      145:Заходняя Азія
      150:Еўропа
      151:Усходняя Еўропа
      154:Паўночная Еўропа
      155:Заходняя Еўропа
      202:Трапічная Афрыка
      419:Лацінская Амерыка
      AC:Востраў Узнясення
      AD:Андора
      AE:Аб’яднаныя Арабскія Эміраты
      AF:Афганістан
      AG:Антыгуа і Барбуда
      AI:Ангілья
      AL:Албанія
      AM:Арменія
      AO:Ангола
      AQ:Антарктыка
      AR:Аргенціна
      AS:Амерыканскае Самоа
      AT:Аўстрыя
      AU:Аўстралія
      AW:Аруба
      AX:Аландскія астравы
      AZ:Азербайджан
      BA:Боснія і Герцагавіна
      BB:Барбадас
      BD:Бангладэш
      BE:Бельгія
      BF:Буркіна-Фасо
      BG:Балгарыя
      BH:Бахрэйн
      BI:Бурундзі
      BJ:Бенін
      BL:Сен-Бартэльмі
      BM:Бермудскія астравы
      BN:Бруней
      BO:Балівія
      BQ:Карыбскія Нідэрланды
      BR:Бразілія
      BS:Багамскія астравы
      BT:Бутан
      BV:Востраў Бувэ
      BW:Батсвана
      BY:Беларусь
      BZ:Беліз
      CA:Канада
      CC:Какосавыя (Кілінг) астравы
      CD:Конга (Кіншаса)
      CF:Цэнтральна-Афрыканская Рэспубліка
      CG:Конга - Бразавіль
      CH:Швейцарыя
      CI:Кот-д’Івуар
      CK:Астравы Кука
      CL:Чылі
      CM:Камерун
      CN:Кітай
      CO:Калумбія
      CP:Востраў Кліпертан
      CR:Коста-Рыка
      CU:Куба
      CV:Каба-Вердэ
      CW:Кюрасаа
      CX:Востраў Каляд
      CY:Кіпр
      CZ:Чэхія
      DE:Германія
      DG:Востраў Дыега-Гарсія
      DJ:Джыбуці
      DK:Данія
      DM:Дамініка
      DO:Дамініканская Рэспубліка
      DZ:Алжыр
      EA:Сеута і Мелілья
      EC:Эквадор
      EE:Эстонія
      EG:Егіпет
      EH:Заходняя Сахара
      ER:Эрытрэя
      ES:Іспанія
      ET:Эфіопія
      EU:Еўрапейскі саюз
      EZ:Еўразона
      FI:Фінляндыя
      FJ:Фіджы
      FK:Фалклендскія астравы
      FM:Мікранезія
      FO:Фарэрскія астравы
      FR:Францыя
      GA:Габон
      GB:Вялікабрытанія
      GD:Грэнада
      GE:Грузія
      GF:Французская Гвіяна
      GG:Гернсі
      GH:Гана
      GI:Гібралтар
      GL:Грэнландыя
      GM:Гамбія
      GN:Гвінея
      GP:Гвадэлупа
      GQ:Экватарыяльная Гвінея
      GR:Грэцыя
      GS:Паўднёвая Георгія і Паўднёвыя Сандвічавы астравы
      GT:Гватэмала
      GU:Гуам
      GW:Гвінея-Бісау
      GY:Гаяна
      HK:Ганконг, САР (Кітай)
      HM:Астравы Херд і Макдональд
      HN:Гандурас
      HR:Харватыя
      HT:Гаіці
      HU:Венгрыя
      IC:Канарскія астравы
      ID:Інданезія
      IE:Ірландыя
      IL:Ізраіль
      IM:Востраў Мэн
      IN:Індыя
      IO:Брытанская тэрыторыя ў Індыйскім акіяне
      IQ:Ірак
      IR:Іран
      IS:Ісландыя
      IT:Італія
      JE:Джэрсі
      JM:Ямайка
      JO:Іарданія
      JP:Японія
      KE:Кенія
      KG:Кыргызстан
      KH:Камбоджа
      KI:Кірыбаці
      KM:Каморскія астравы
      KN:Сент-Кітс і Невіс
      KP:Паўночная Карэя
      KR:Паўднёвая Карэя
      KW:Кувейт
      KY:Кайманавы астравы
      KZ:Казахстан
      LA:Лаос
      LB:Ліван
      LC:Сент-Люсія
      LI:Ліхтэнштэйн
      LK:Шры-Ланка
      LR:Ліберыя
      LS:Лесота
      LT:Літва
      LU:Люксембург
      LV:Латвія
      LY:Лівія
      MA:Марока
      MC:Манака
      MD:Малдова
      ME:Чарнагорыя
      MF:Сен-Мартэн
      MG:Мадагаскар
      MH:Маршалавы астравы
      MK:Паўночная Македонія
      ML:Малі
      MM:М’янма (Бірма)
      MN:Манголія
      MO:Макаа, САР (Кітай)
      MP:Паўночныя Марыянскія астравы
      MQ:Марцініка
      MR:Маўрытанія
      MS:Мантсерат
      MT:Мальта
      MU:Маўрыкій
      MV:Мальдывы
      MW:Малаві
      MX:Мексіка
      MY:Малайзія
      MZ:Мазамбік
      NA:Намібія
      NC:Новая Каледонія
      NE:Нігер
      NF:Востраў Норфалк
      NG:Нігерыя
      NI:Нікарагуа
      NL:Нідэрланды
      NO:Нарвегія
      NP:Непал
      NR:Науру
      NU:Ніуэ
      NZ:Новая Зеландыя
      OM:Аман
      PA:Панама
      PE:Перу
      PF:Французская Палінезія
      PG:Папуа-Новая Гвінея
      PH:Філіпіны
      PK:Пакістан
      PL:Польшча
      PM:Сен-П’ер і Мікелон
      PN:Астравы Піткэрн
      PR:Пуэрта-Рыка
      PS:Палесцінскія Тэрыторыі
      PT:Партугалія
      PW:Палау
      PY:Парагвай
      QA:Катар
      QO:Аддаленыя тэрыторыі Акіяніі
      RE:Рэюньён
      RO:Румынія
      RS:Сербія
      RU:Расія
      RW:Руанда
      SA:Саудаўская Аравія
      SB:Саламонавы астравы
      SC:Сейшэльскія астравы
      SD:Судан
      SE:Швецыя
      SG:Сінгапур
      SH:Востраў Святой Алены
      SI:Славенія
      SJ:Шпіцберген і Ян-Маен
      SK:Славакія
      SL:Сьера-Леонэ
      SM:Сан-Марына
      SN:Сенегал
      SO:Самалі
      SR:Сурынам
      SS:Паўднёвы Судан
      ST:Сан-Тамэ і Прынсіпі
      SV:Сальвадор
      SX:Сінт-Мартэн
      SY:Сірыя
      SZ:Эсватыні
      TA:Трыстан-да-Кунья
      TC:Астравы Цёркс і Кайкас
      TD:Чад
      TF:Французскія паўднёвыя тэрыторыі
      TG:Тога
      TH:Тайланд
      TJ:Таджыкістан
      TK:Такелау
      TL:Тымор-Лешці
      TM:Туркменістан
      TN:Туніс
      TO:Тонга
      TR:Турцыя
      TT:Трынідад і Табага
      TV:Тувалу
      TW:Тайвань
      TZ:Танзанія
      UA:Украіна
      UG:Уганда
      UM:Малыя Аддаленыя астравы ЗША
      UN:Арганізацыя Аб’яднаных Нацый
      US:Злучаныя Штаты Амерыкі
      UY:Уругвай
      UZ:Узбекістан
      VA:Ватыкан
      VC:Сент-Вінсент і Грэнадзіны
      VE:Венесуэла
      VG:Брытанскія Віргінскія астравы
      VI:Амерыканскія Віргінскія астравы
      VN:В’етнам
      VU:Вануату
      WF:Уоліс і Футуна
      WS:Самоа
      XA:Псеўдаакцэнты
      XB:Псеўдадвухнапрамкавы
      XK:Косава
      YE:Емен
      YT:Маёта
      ZA:Паўднёва-Афрыканская Рэспубліка
      ZM:Замбія
      ZW:Зімбабвэ
      ZZ:Невядомы рэгіён
      """.trimIndent() }

  val be_tarask: String? = null

  val bem: String by lazy { """
      ZM:Zambia
      """.trimIndent() }

  val bez: String by lazy { """
      AD:Huandola
      AE:Hufalme dza Hihalabu
      AF:Huafuganistani
      AG:Huantigua na Hubarubuda
      AI:Huanguila
      AL:Hualbania
      AM:Huamenia
      AO:Huangola
      AR:Huajendina
      AS:Husamoa ya Humalekani
      AT:Huastlia
      AU:Huaustlalia
      AW:Hualuba
      AZ:Huazabajani
      BA:Hubosinia na Huhezegovina
      BB:Hubabadosi
      BD:Hubangaladeshi
      BE:Huubelgiji
      BF:Hubukinafaso
      BG:Hubulgaria
      BH:Hubahaleni
      BI:Huburundi
      BJ:Hubenini
      BM:Hubelmuda
      BN:Hubrunei
      BO:Hubolivia
      BR:Hublazili
      BS:Hubahama
      BT:Hubutani
      BW:Hubotiswana
      BY:Hubelalusi
      BZ:Hubelize
      CA:Hukanada
      CD:Ijamhuri ya Hidemokrasi ya Hukongo
      CF:Ijamhuri ya Afrika ya Pagati
      CG:Hukongo
      CH:Huuswisi
      CI:Hukodivaa
      CK:Ifisima fya Kook
      CL:Huchile
      CM:Hukameruni
      CN:Huchina
      CO:Hukolombia
      CR:Hukostarika
      CU:Hukuba
      CV:Hukepuvede
      CY:Hukuprosi
      CZ:Ijamhuri ya Cheki
      DE:Huujerumani
      DJ:Hujibuti
      DK:Hudenmaki
      DM:Hudominika
      DO:Ijamhuri ya Hudominika
      DZ:Hualjelia
      EC:Huekwado
      EE:Huestonia
      EG:Humisri
      ER:Hueritrea
      ES:Huhispania
      ET:Huuhabeshi
      FI:Huufini
      FJ:Hufiji
      FK:Ifisima fya Falkland
      FM:Humikronesia
      FR:Huufaransa
      GA:Hugaboni
      GB:Huuingereza
      GD:Hugrenada
      GE:Hujojia
      GF:Hugwiyana ya Huufaransa
      GH:Hughana
      GI:Hujiblalta
      GL:Hujinlandi
      GM:Hugambia
      GN:Hujine
      GP:Hugwadelupe
      GQ:Huginekweta
      GR:Huugiliki
      GT:Hugwatemala
      GU:Hugwam
      GW:Huginebisau
      GY:Huguyana
      HN:Huhondulasi
      HR:Hukorasia
      HT:Huhaiti
      HU:Huhungalia
      ID:Huindonesia
      IE:Huayalandi
      IL:Huislaheli
      IN:Huindia
      IQ:Huilaki
      IR:Huuajemi
      IS:Huaislandi
      IT:Huitalia
      JM:Hujamaika
      JO:Huyolodani
      JP:Hujapani
      KE:Hukenya
      KG:Hukiligizistani
      KH:Hukambodia
      KI:Hukilibati
      KM:Hukomoro
      KN:Husantakitzi na Hunevis
      KP:Hukolea Kaskazini
      KR:Hukolea Kusini
      KW:Hukuwaiti
      KY:Ifisima fya Kayman
      KZ:Hukazakistani
      LA:Hulaosi
      LB:Hulebanoni
      LC:Husantalusia
      LI:Hulishenteni
      LK:Husirilanka
      LR:Hulibelia
      LS:Hulesoto
      LT:Hulitwania
      LU:Hulasembagi
      LV:Hulativia
      LY:Hulibiya
      MA:Humoloko
      MC:Humonako
      MD:Humoldova
      MG:Hubukini
      MH:Ifisima fya Marshal
      ML:Humali
      MM:Humyama
      MN:Humongolia
      MP:Ifisima fya Mariana fya Hukaskazini
      MQ:Humartiniki
      MR:Humolitania
      MS:Humontserrati
      MT:Humalta
      MU:Humolisi
      MV:Humodivu
      MW:Humalawi
      MX:Humeksiko
      MY:Humalesia
      MZ:Humusumbiji
      NA:Hunamibia
      NC:Hunyukaledonia
      NE:Hunijeli
      NF:Ihisima sha Norfok
      NG:Hunijelia
      NI:Hunikaragwa
      NL:Huuholanzi
      NO:Hunolwe
      NP:Hunepali
      NR:Hunauru
      NU:Huniue
      NZ:Hunyuzilandi
      OM:Huomani
      PA:Hupanama
      PE:Hupelu
      PF:Hupolinesia ya Huufaransa
      PG:Hupapua
      PH:Hufilipino
      PK:Hupakistani
      PL:Hupolandi
      PM:Husantapieri na Humikeloni
      PN:Hupitkaini
      PR:Hupwetoriko
      PS:Ulubali lwa Magharibi nu Gaza wa Hupalestina
      PT:Huuleno
      PW:Hupalau
      PY:Hupalagwai
      QA:Hukatali
      RE:Huliyunioni
      RO:Hulomania
      RU:Huulusi
      RW:Hulwanda
      SA:Husaudi
      SB:Ifisima fya Solomon
      SC:Hushelisheli
      SD:Husudani
      SE:Huuswidi
      SG:Husingapoo
      SH:Husantahelena
      SI:Huslovenia
      SK:Huslovakia
      SL:Husiela Lioni
      SM:Husamalino
      SN:Husenegali
      SO:Husomalia
      SR:Husurinamu
      ST:Husaotome na Huprinsipe
      SV:Huelsavado
      SY:Husilia
      SZ:Huuswazi
      TC:Ifisima fya Turki na Kaiko
      TD:Huchadi
      TG:Hutogo
      TH:Hutailandi
      TJ:Hutajikistani
      TK:Hutokelau
      TL:Hutimori ya Mashariki
      TM:Huuturukimenistani
      TN:Hutunisia
      TO:Hutonga
      TR:Huuturuki
      TT:Hutrinad na Hutobago
      TV:Hutuvalu
      TW:Hutaiwani
      TZ:Hutanzania
      UA:Huukraini
      UG:Huuganda
      US:Humalekani
      UY:Huulugwai
      UZ:Huuzibekistani
      VA:Huvatikani
      VC:Husantavisenti na Hugrenadini
      VE:Huvenezuela
      VG:Ifisima fya Virgin fya Huingereza
      VI:Ifisima fya Virgin fya Humelekani
      VN:Huvietinamu
      VU:Huvanuatu
      WF:Huwalis na Hufutuna
      WS:Husamoa
      YE:Huyemeni
      YT:Humayotte
      ZA:Huafrika iya Hukusini
      ZM:Huzambia
      ZW:Huzimbabwe
      """.trimIndent() }

  val bg: String by lazy { """
      001:свят
      002:Африка
      003:Северноамерикански континент
      005:Южна Америка
      009:Океания
      011:Западна Афирка
      013:Централна Америка
      014:Източна Африка
      015:Северна Африка
      017:Централна Африка
      018:Южноафрикански регион
      019:Америка
      021:Северна Америка
      029:Карибски регион
      030:Източна Азия
      034:Южна Азия
      035:Югоизточна Азия
      039:Южна Европа
      053:Австралазия
      054:Меланезия
      057:Микронезийски регион
      061:Полинезия
      142:Азия
      143:Централна Азия
      145:Западна Азия
      150:Европа
      151:Източна Европа
      154:Северна Европа
      155:Западна Европа
      202:Субсахарска Африка
      419:Латинска Америка
      AC:остров Възнесение
      AD:Андора
      AE:Обединени арабски емирства
      AF:Афганистан
      AG:Антигуа и Барбуда
      AI:Ангуила
      AL:Албания
      AM:Армения
      AO:Ангола
      AQ:Антарктика
      AR:Аржентина
      AS:Американска Самоа
      AT:Австрия
      AU:Австралия
      AW:Аруба
      AX:Оландски острови
      AZ:Азербайджан
      BA:Босна и Херцеговина
      BB:Барбадос
      BD:Бангладеш
      BE:Белгия
      BF:Буркина Фасо
      BG:България
      BH:Бахрейн
      BI:Бурунди
      BJ:Бенин
      BL:Сен Бартелеми
      BM:Бермудски острови
      BN:Бруней Даруссалам
      BO:Боливия
      BQ:Карибска Нидерландия
      BR:Бразилия
      BS:Бахамски острови
      BT:Бутан
      BV:остров Буве
      BW:Ботсвана
      BY:Беларус
      BZ:Белиз
      CA:Канада
      CC:Кокосови острови (острови Кийлинг)
      CD:Конго (Киншаса)
      CF:Централноафриканска република
      CG:Конго (Бразавил)
      CH:Швейцария
      CI:Кот д’Ивоар
      CK:острови Кук
      CL:Чили
      CM:Камерун
      CN:Китай
      CO:Колумбия
      CP:остров Клипертон
      CR:Коста Рика
      CU:Куба
      CV:Кабо Верде
      CW:Кюрасао
      CX:остров Рождество
      CY:Кипър
      CZ:Чехия
      DE:Германия
      DG:Диего Гарсия
      DJ:Джибути
      DK:Дания
      DM:Доминика
      DO:Доминиканска република
      DZ:Алжир
      EA:Сеута и Мелия
      EC:Еквадор
      EE:Естония
      EG:Египет
      EH:Западна Сахара
      ER:Еритрея
      ES:Испания
      ET:Етиопия
      EU:Европейски съюз
      EZ:еврозона
      FI:Финландия
      FJ:Фиджи
      FK:Фолкландски острови
      FM:Микронезия
      FO:Фарьорски острови
      FR:Франция
      GA:Габон
      GB:Обединеното кралство
      GD:Гренада
      GE:Грузия
      GF:Френска Гвиана
      GG:Гърнзи
      GH:Гана
      GI:Гибралтар
      GL:Гренландия
      GM:Гамбия
      GN:Гвинея
      GP:Гваделупа
      GQ:Екваториална Гвинея
      GR:Гърция
      GS:Южна Джорджия и Южни Сандвичеви острови
      GT:Гватемала
      GU:Гуам
      GW:Гвинея-Бисау
      GY:Гаяна
      HK:Хонконг, САР на Китай
      HM:острови Хърд и Макдоналд
      HN:Хондурас
      HR:Хърватия
      HT:Хаити
      HU:Унгария
      IC:Канарски острови
      ID:Индонезия
      IE:Ирландия
      IL:Израел
      IM:остров Ман
      IN:Индия
      IO:Британска територия в Индийския океан
      IQ:Ирак
      IR:Иран
      IS:Исландия
      IT:Италия
      JE:Джърси
      JM:Ямайка
      JO:Йордания
      JP:Япония
      KE:Кения
      KG:Киргизстан
      KH:Камбоджа
      KI:Кирибати
      KM:Коморски острови
      KN:Сейнт Китс и Невис
      KP:Северна Корея
      KR:Южна Корея
      KW:Кувейт
      KY:Кайманови острови
      KZ:Казахстан
      LA:Лаос
      LB:Ливан
      LC:Сейнт Лусия
      LI:Лихтенщайн
      LK:Шри Ланка
      LR:Либерия
      LS:Лесото
      LT:Литва
      LU:Люксембург
      LV:Латвия
      LY:Либия
      MA:Мароко
      MC:Монако
      MD:Молдова
      ME:Черна гора
      MF:Сен Мартен
      MG:Мадагаскар
      MH:Маршалови острови
      MK:Северна Македония
      ML:Мали
      MM:Мианмар (Бирма)
      MN:Монголия
      MO:Макао, САР на Китай
      MP:Северни Мариански острови
      MQ:Мартиника
      MR:Мавритания
      MS:Монтсерат
      MT:Малта
      MU:Мавриций
      MV:Малдиви
      MW:Малави
      MX:Мексико
      MY:Малайзия
      MZ:Мозамбик
      NA:Намибия
      NC:Нова Каледония
      NE:Нигер
      NF:остров Норфолк
      NG:Нигерия
      NI:Никарагуа
      NL:Нидерландия
      NO:Норвегия
      NP:Непал
      NR:Науру
      NU:Ниуе
      NZ:Нова Зеландия
      OM:Оман
      PA:Панама
      PE:Перу
      PF:Френска Полинезия
      PG:Папуа-Нова Гвинея
      PH:Филипини
      PK:Пакистан
      PL:Полша
      PM:Сен Пиер и Микелон
      PN:Острови Питкерн
      PR:Пуерто Рико
      PS:Палестински територии
      PT:Португалия
      PW:Палау
      PY:Парагвай
      QA:Катар
      QO:Отдалечени острови на Океания
      RE:Реюнион
      RO:Румъния
      RS:Сърбия
      RU:Русия
      RW:Руанда
      SA:Саудитска Арабия
      SB:Соломонови острови
      SC:Сейшели
      SD:Судан
      SE:Швеция
      SG:Сингапур
      SH:Света Елена
      SI:Словения
      SJ:Свалбард и Ян Майен
      SK:Словакия
      SL:Сиера Леоне
      SM:Сан Марино
      SN:Сенегал
      SO:Сомалия
      SR:Суринам
      SS:Южен Судан
      ST:Сао Томе и Принсипи
      SV:Салвадор
      SX:Синт Мартен
      SY:Сирия
      SZ:Есватини
      TA:Тристан да Куня
      TC:острови Търкс и Кайкос
      TD:Чад
      TF:Френски южни територии
      TG:Того
      TH:Тайланд
      TJ:Таджикистан
      TK:Токелау
      TL:Тимор Лесте
      TM:Туркменистан
      TN:Тунис
      TO:Тонга
      TR:Турция
      TT:Тринидад и Тобаго
      TV:Тувалу
      TW:Тайван
      TZ:Танзания
      UA:Украйна
      UG:Уганда
      UM:Отдалечени острови на САЩ
      UN:Организация на обединените нации
      US:Съединени щати
      UY:Уругвай
      UZ:Узбекистан
      VA:Ватикан
      VC:Сейнт Винсънт и Гренадини
      VE:Венецуела
      VG:Британски Вирджински острови
      VI:Американски Вирджински острови
      VN:Виетнам
      VU:Вануату
      WF:Уолис и Футуна
      WS:Самоа
      XA:Псевдоакценти
      XB:Псевдодвупосочни
      XK:Косово
      YE:Йемен
      YT:Майот
      ZA:Южна Африка
      ZM:Замбия
      ZW:Зимбабве
      ZZ:непознат регион
      """.trimIndent() }

  val bgc: String by lazy { """
      IN:भारत
      ZZ:अणजाण जगह
      """.trimIndent() }

  val bgn: String by lazy { """
      001:دونیا/جهان
      002:افریقا
      009:اوقیانوسیه
      019:امریکای براعظم
      053:استرالیا
      142:اسیا
      150:اورورپا
      AE:متحدین عربین امارات
      AI:انگویلا
      AO:انگولا
      AR:ارجنٹاین
      AU:اسٹرالیا
      AZ:آزربایجان
      BE:بیلجیم
      BG:بولغاریه
      BH:بحرین
      BI:بروندی
      BM:بیرمودا
      BN:برونی
      BO:بولیویه
      BR:برازیل
      BS:بهاماس
      BT:بوتان
      CA:کاناڈا
      CL:چیلی
      CM:کامیرون
      CN:چین
      CO:کولومبیا
      CU:کوبا
      CY:قبرس
      DE:جرمنی
      DJ:جیبوتی
      DZ:الجزایر
      EC:اکوادور
      EG:مصر
      EH:روچ‌کپتین سحرا
      ER:اریتره
      ES:هسپانیه
      ET:ایتوپیه
      EU:اورورپایی یکویی
      FJ:فیجی
      FR:فرانسه
      GA:گابون
      GE:گرجستان
      GH:گانا
      GL:گرینلاند
      GM:گامبیا
      GN:گوینیا
      GR:یونان
      GY:گویانا
      HK:هانگ کانگ
      HU:هنگری
      ID:ایندونیزیا
      IL:اسرائیل
      IQ:عراق
      IT:ایتالیه
      JO:اردن
      KE:کینیا
      KG:قیرغیزستان
      KH:کمبودیا
      KM:کومورس
      KW:کویٹ
      KZ:قزاقستان
      LA:لاوس
      LB:لیبنان
      LY:لیبیا
      MA:مراکو
      MD:مالداویا
      MG:ماداگاسکار
      ML:مالی
      MT:مالته
      MU:موریتانیا
      MX:مکسیکو
      MY:مالیزیا
      NE:نیجیر
      NG:نایجیریا
      NZ:نیوزلنڈ
      OM:ئومان
      PA:پانامه
      PE:پیرو
      PH:فلیپین
      PT:پورتگال
      PY:پاراگوی
      QA:قطر
      RO:رومانیه
      RS:سیربستان
      RW:روندا
      SC:سیشیل
      SD:سوڈان
      SG:سینگاپور
      SN:سینیگال
      SO:سومالیا
      SR:سورینامی
      SY:سوریه
      TD:چاد
      TH:ٹایلنڈ
      TJ:تاجیکستان
      TM:تورکمنستان
      TN:ٹونیس
      TZ:تانزانیا
      UG:اوگاندا
      US:متحدین ایالات
      UY:اوراگوی
      UZ:اوزبکیستان
      VE:وینزوویلا
      VN:ویتنام
      YE:یمن
      ZM:زامبیا
      ZW:زیمبابوی
      ZZ:نازانتین سیمسر
      """.trimIndent() }

  val bgn_AE: String? = null

  val bgn_AF: String? = null

  val bgn_IR: String? = null

  val bgn_OM: String? = null

  val bho: String by lazy { """
      IN:भारत
      ZZ:अनजान इलाका
      """.trimIndent() }

  val blo: String by lazy { """
      001:nɖulinya
      002:Garɩɖontǝna
      003:Gamalɩkatǝna gʊnyɩpɛnɛlaŋ
      005:Gamalɩkatǝna gʊnyɩsonolaŋ
      009:Oseyanii
      011:Garɩɖontǝna gɩteŋshilelaŋ
      013:Gamalɩkatǝna gɩcɩɩca
      014:Garɩɖontǝna gajakalaŋ
      015:Garɩɖontǝna gʊnyɩpɛnɛlaŋ
      017:Garɩɖontǝna gɩcɩɩca
      018:Garɩɖontǝna gʊnyɩsonolaŋ
      019:Gamalɩkatǝna
      021:Gamalɩkatǝna kagʊnyɩpɛnɛlaŋ
      029:Karayiib
      030:Gacǝlǝŋtǝna gajakalaŋ
      034:Gacǝlǝŋtǝna gʊnyɩsonolaŋ
      035:Gacǝlǝŋtǝna gʊsono na gajakayɛlaŋ kʊfɔɔ nɩ
      039:Garɩfɔntǝna gʊnyɩsonolaŋ
      053:Ɔstracǝlǝŋtǝna
      054:Melanesiya
      057:Mikronesiya kagʊsaʊ
      061:Polinesiya
      142:Gacǝlǝŋtǝna
      143:Gacǝlǝŋtǝna gɩcɩɩca
      145:Gacǝlǝŋtǝna gɩteŋshilelaŋ
      150:Garɩfɔntǝna
      151:Garɩfɔntǝna gajakalaŋ
      154:Garɩfɔntǝna gʊnyɩpɛnɛlaŋ
      155:Garɩfɔntǝna gɩteŋshilelaŋ
      202:Garɩɖontǝna Sahara katǝntǝn
      419:Latɛŋ kaAmalɩkatǝna
      AC:Asɛnsiyɔɔn kaAtukǝltǝna
      AD:Anɖɔraa
      AE:Emiir baGanɔ gaɖɔŋkɔnɔ kaAlaaributǝna
      AF:Afganistan
      AG:Antiguwaa na Barbuɖaa
      AI:Aŋguwilaa
      AL:Albanii
      AM:Armenii
      AO:Aŋgolaa
      AQ:Gatutaltǝna
      AR:Arjantin
      AS:Samowa Amalɩka kaja
      AT:Otrish
      AU:Ɔstraliya
      AW:Arubaa
      AX:Ɔɔlanɖ kaBʊtǝlǝltǝna
      AZ:Asɛrbaɩjaŋ
      BA:Bɔsniya na Hɛrsegɔfina
      BB:Barbaɖɔɔsɩ
      BD:Baŋglaɖɛɛshɩ
      BE:Bɛljiiki
      BF:Burkinaa
      BG:Bulgarii
      BH:Barɛɛn
      BI:Burunɖii
      BJ:Benɛɛ
      BL:Sɛŋ-Batolomayɔ
      BM:Bɛrmuɖaa
      BN:Brunɛɩ
      BO:Bolifiya
      BQ:Holanɖ kaKarayiib
      BR:Bresil
      BS:Bahamaasɩ
      BT:Butan
      BV:Bufee kaAtukǝltǝna
      BW:Bɔsʊwanaa
      BY:Belaruus
      BZ:Beliis
      CA:Kanaɖaa
      CC:Kokoos (Kiiliŋ) kaBʊtukǝltǝna
      CD:Koŋgoo Kinshasaa
      CF:Santrafrika
      CG:Koŋgoo Brasafil
      CH:Suwis
      CI:Koɖifʊaa
      CK:Kʊkʊ kaBʊtukǝltǝna
      CL:Shilii
      CM:Kamerun
      CN:Caɩna
      CO:Kolɔmbii
      CP:Klipɛɛtɔn kaAtukǝltǝna
      CQ:Sark
      CR:Kɔsta Rikaa
      CU:Kubaa
      CV:Kapfɛɛr
      CW:Kurasawuu
      CX:Nowɛl kaAtukǝltǝna
      CY:Ciprɔs
      CZ:Cɛk
      DE:Gajaamatǝna
      DG:Ɖiyego Garsiya
      DJ:Jibutii
      DK:Ɖanǝmark
      DM:Ɖominikaa
      DO:Ɖominikaa kaRepibliiki
      DZ:Aljerii
      EA:Seyuta na Meliliya
      EC:Ekuwaɖɔɔr
      EE:Ɛstoniya
      EG:Ejipti
      EH:Sarawii
      ER:Eritree
      ES:Ɛspanyǝ
      ET:Etiyopii
      EU:Ganɔ gaɖɔŋkɔnɔ kaBʊtǝna Garɩfɔntǝna nɩ
      EZ:Eroo kaBʊtǝna
      FI:Fɛnlanɖ
      FJ:Fiji
      FK:Fɔklanɖ kaBʊtukǝltǝna
      FM:Mikronesiya
      FO:Faroi kaBʊtukǝltǝna
      FR:Gafɔntǝna
      GA:Gabɔŋ
      GB:Gagɛɛshɩtǝna
      GD:Grenaɖaa
      GE:Jɔrjiya
      GF:Guyanaa Gafɔntǝna kaja
      GG:Gǝrǝnsɛɩ
      GH:Gana
      GI:Gibraltaa
      GL:Grinlanɖ
      GM:Gambii
      GN:Ginee
      GP:Guwaɖeluupu
      GQ:Ginee Malabo
      GR:Grɛs
      GS:Jɔrjiya gʊnyɩsonolaŋ kaja na Sanɖuush gʊnyɩsonolaŋ kaBʊtukǝltǝna
      GT:Guwatemalaa
      GU:Guwam
      GW:Ginee Bisoo
      GY:Guyanaa
      HK:Hɔŋ Kɔŋ Caɩna kaja
      HM:Hɛɛrɖ na Mɛkɖɔnalɖ kaBʊtukǝltǝna
      HN:Hɔnɖuraasɩ
      HR:Krowasii
      HT:Hayitii
      HU:Ɔŋgrii
      IC:Kanarii kaBʊtukǝltǝna
      ID:Ɛnɖonosii
      IE:Irlanɖ
      IL:Yishraɛl
      IM:Man kaAtukǝltǝna
      IN:Inɖiya
      IO:Gɛɛshɩ kaAtǝna Inɖiya kaTeŋku nɩ
      IQ:Ɩraakɩ
      IR:Iraŋ
      IS:Islanɖ
      IT:Italii
      JE:Jersei
      JM:Jamaɩka
      JO:Jɔrɖanii
      JP:Japaŋ
      KE:Keniya
      KG:Kirgistan
      KH:Kamboɖiya
      KI:Kiribatii
      KM:Komɔɔr
      KN:Sɛŋ Kits na Nefis
      KP:Koree gʊnyɩpɛnɛlaŋ
      KR:Koree gʊnyɩsonolaŋ
      KW:Koweeti
      KY:Kayimaan kaBʊtukǝltǝna
      KZ:Kasastan
      LA:Lawɔs
      LB:Liibaaŋ
      LC:Sɛŋ Lusiya
      LI:Liishtɛntaɩn
      LK:Siri Laŋkaa
      LR:Liberiya
      LS:Lesotoo
      LT:Lituwaniya
      LU:Lusɛmbuur
      LV:Lɛtfiya
      LY:Libii
      MA:Morooko
      MC:Monakoo
      MD:Mɔlɖafiya
      ME:Mɔntenegroo
      MF:Sɛŋ Martɛɛŋ
      MG:Maɖagaskaa
      MH:Marshal kaBʊtukǝltǝna
      MK:Maseɖoniya gʊnyɩpɛnɛlaŋ kaja
      ML:Malii
      MM:Miyanmaa (Birmanii)
      MN:Mɔŋgolii
      MO:Makawoo Caɩna kaja
      MP:Mariyan kaBʊtukǝltǝna gʊnyɩpɛnɛlaŋ
      MQ:Martiniiki
      MR:Moritanii
      MS:Mɔnsɛraatɩ
      MT:Malta
      MU:Imoris
      MV:Malɖiifu
      MW:Malawii
      MX:Mɛsik
      MY:Malɛsii
      MZ:Mosambii
      NA:Namibii
      NC:Kaleɖonii afɔlɩ
      NE:Nijɛr
      NF:Nɔrfook kaAtukǝltǝna
      NG:Nanjiiriya
      NI:Nikaraguwaa
      NL:Holanɖ
      NO:Nɔrfɛsh
      NP:Neepal
      NR:Nawuru
      NU:Niwuye
      NZ:Selanɖ afɔlɩ
      OM:Oman
      PA:Panamaa
      PE:Peruu
      PF:Polinesiya Gafɔntǝna kaja
      PG:Papuasii Ginee afɔlɩ
      PH:Filipiin
      PK:Pakistan
      PL:Polanɖ
      PM:Sɛŋ-Petrɔs na Mikelɔŋ
      PN:Pɩtkɛɛn kaBʊtukǝltǝna
      PR:Pɔrto Rikoo
      PS:Palɛstiin kAsàʊ
      PT:Pɔrtigal
      PW:Palawoo
      PY:Paraguwee
      QA:Kataa
      QO:Oseyanii kasaʊlǝŋka
      RE:Reeniyɔŋ
      RO:Romanii
      RS:Sɛrbii
      RU:Rɔɔshɩya
      RW:Rʊwanɖaa
      SA:Sauɖiya
      SB:Salomɔɔn kaBʊtukǝltǝna
      SC:Seshɛl
      SD:Suɖaŋ
      SE:Sʊwɛɖ
      SG:Siŋgapuur
      SH:Sɛŋ Elenaa (kaAtukǝltǝna)
      SI:Slofeniya
      SJ:Sǝfalbaaɖ na Yan Mayɛn
      SK:Slofakii
      SL:Seraleyɔn
      SM:Sɛŋ Marinoo
      SN:Senegal
      SO:Somalii
      SR:Surinam
      SS:Suɖaŋ gʊnyɩsonolaŋ
      ST:Saotomee
      SV:Ɛl Salfaɖɔɔr
      SX:Sɛŋ Martɛɛŋ (Holanɖ kaja)
      SY:Sirii
      SZ:Ɛsʊwatinii
      TA:Tristan ɖa Kuna
      TC:Turkisii na Kayɩkɔɔsɩ kaBʊtukǝltǝna
      TD:Caɖ
      TF:Gafɔntǝna kaBʊtǝna gʊnyɩsonolaŋ kabʊja
      TG:Togoo
      TH:Taɩlanɖ
      TJ:Tajikistan
      TK:Tokelaʊ
      TL:Timɔɔ gajakalaŋ
      TM:Turkmenistan
      TN:Tunisii
      TO:Tɔŋga
      TR:Turkii
      TT:Triniɖaaɖ na Tobagoo
      TV:Tufalu
      TW:Taɩwan
      TZ:Taŋsanii
      UA:Ikrɛɛn
      UG:Uganɖaa
      UM:Ganɔ gaɖɔŋkɔnɔ kaBʊtǝna Amalɩka nɩ kaBʊtukǝltǝna bʊlǝŋka
      UN:Ganɔ gaɖɔŋkɔnɔ kaBʊtǝna nɖulinya nɩ
      US:Ganɔ gaɖɔŋkɔnɔ kaBʊtǝna Amalɩka nɩ
      UY:Uruguwee
      UZ:Usbeekistan
      VA:Fatikaŋ kaMpá
      VC:Sɛŋ Fɩnsaŋ na Grenaɖiniisi
      VE:Fenesuwelaa
      VG:Fɩrjɩɩn kǝBʊtukǝltǝna Gɛɛshɩ kabʊja
      VI:Fɩrjɩɩn kaBʊtukǝltǝna Amalɩka kabʊja
      VN:Fɛtnam
      VU:Fanuwatu
      WF:Walis na Futuna
      WS:Samowa
      XA:sǝɖoo-aksaŋ
      XB:sǝɖoo-biɖi
      XK:Kɔsofoo
      YE:Yemɛn
      YT:Mayɔɔtɩ
      ZA:Sautafrika
      ZM:Sambii
      ZW:Simbabʊwee
      ZZ:gʊsaʊɩ kʊyɔʊ ʊ mana ma
      """.trimIndent() }

  val bm: String by lazy { """
      AD:Andɔr
      AE:Arabu mara kafoli
      AF:Afiganistaŋ
      AG:Antiga-ni-Barbuda
      AI:Angiya
      AL:Alibani
      AM:Arimeni
      AO:Angola
      AR:Arizantin
      AS:Samowa amerikani
      AT:Otirisi
      AU:Ositirali
      AW:Aruba
      AZ:Azɛrbayjaŋ
      BA:Bozni-Ɛrizigovini
      BB:Barbadi
      BD:Bɛngiladɛsi
      BE:Bɛliziki
      BF:Burukina Faso
      BG:Buligari
      BH:Bareyini
      BI:Burundi
      BJ:Benɛn
      BM:Bermudi
      BN:Burinɛyi
      BO:Bolivi
      BR:Berezili
      BS:Bahamasi
      BT:Butaŋ
      BW:Bɔtisiwana
      BY:Belarusi
      BZ:Belizi
      CA:Kanada
      CD:Kongo ka republiki demɔkratiki
      CF:Santarafiriki
      CG:Kongo
      CH:Suwisi
      CI:Kodiwari
      CK:Kuki Gun
      CL:Sili
      CM:Kameruni
      CN:Siniwajamana
      CO:Kolombi
      CR:Kɔsitarika
      CU:Kuba
      CV:Capivɛrdi
      CY:Cipri
      CZ:Ceki republiki
      DE:Alimaɲi
      DJ:Jibuti
      DK:Danemarki
      DM:Dɔminiki
      DO:Dɔmimiki republiki
      DZ:Alizeri
      EC:Ekwatɔr
      EE:Esetoni
      EG:Eziputi
      ER:Eritere
      ES:Esipaɲi
      ET:Etiopi
      FI:Finilandi
      FJ:Fiji
      FK:Maluwini Gun
      FM:Mikironesi
      FR:Faransi
      GA:Gabɔŋ
      GB:Angilɛtɛri
      GD:Granadi
      GE:Zeyɔrzi
      GF:Faransi ka gwiyani
      GH:Gana
      GI:Zibralitari
      GL:Gɔrɔhenelandi
      GM:Ganbi
      GN:Gine
      GP:Gwadelup
      GQ:Gine ekwatɔri
      GR:Gɛrɛsi
      GT:Gwatemala
      GU:Gwam
      GW:Gine Bisawo
      GY:Gwiyana
      HN:Hɔndirasi
      HR:Kroasi
      HT:Ayiti
      HU:Hɔngri
      ID:Ɛndonezi
      IE:Irilandi
      IL:Isirayeli
      IN:Ɛndujamana
      IQ:Iraki
      IR:Iraŋ
      IS:Isilandi
      IT:Itali
      JM:Zamayiki
      JO:Zɔrdani
      JP:Zapɔn
      KE:Keniya
      KG:Kirigizisitaŋ
      KH:Kamboji
      KI:Kiribati
      KM:Komɔri
      KN:Kristɔfo-Senu-ni-Ɲevɛs
      KP:Kɛɲɛka Kore
      KR:Worodugu Kore
      KW:Kowɛti
      KY:Bama Gun
      KZ:Kazakistaŋ
      LA:Layosi
      LB:Libaŋ
      LC:Lusi-Senu
      LI:Lisɛnsitayini
      LK:Sirilanka
      LR:Liberiya
      LS:Lesoto
      LT:Lituyani
      LU:Likisanburu
      LV:Letoni
      LY:Libi
      MA:Marɔku
      MC:Monako
      MD:Molidavi
      MG:Madagasikari
      MH:Marisali Gun
      ML:Mali
      MM:Myanimari
      MN:Moŋoli
      MP:Kɛɲɛka Mariyani Gun
      MQ:Maritiniki
      MR:Mɔritani
      MS:Moŋsera
      MT:Malti
      MU:Morisi
      MV:Maldivi
      MW:Malawi
      MX:Meksiki
      MY:Malɛzi
      MZ:Mozanbiki
      NA:Namibi
      NC:Kaledoni Koura
      NE:Nizɛri
      NF:Nɔrofoliki Gun
      NG:Nizeriya
      NI:Nikaragwa
      NL:Peyiba
      NO:Nɔriwɛzi
      NP:Nepali
      NR:Nawuru
      NU:Nyuwe
      NZ:Zelandi Koura
      OM:Omaŋ
      PA:Panama
      PE:Peru
      PF:Faransi ka polinezi
      PG:Papuwasi-Gine-Koura
      PH:Filipini
      PK:Pakisitaŋ
      PL:Poloɲi
      PM:Piyɛri-Senu-ni-Mikelɔŋ
      PN:Pitikarini
      PR:Pɔrotoriko
      PS:Palesitini
      PT:Pɔritigali
      PW:Palawu
      PY:Paraguwayi
      QA:Katari
      RE:Reyuɲɔŋ
      RO:Rumani
      RU:Irisi
      RW:Ruwanda
      SA:Arabiya Sawudiya
      SB:Salomo Gun
      SC:Sesɛli
      SD:Sudaŋ
      SE:Suwɛdi
      SG:Sɛngapuri
      SH:Ɛlɛni Senu
      SI:Sloveni
      SK:Slowaki
      SL:Siyera Lewɔni
      SM:Marini-Senu
      SN:Senegali
      SO:Somali
      SR:Surinami
      ST:Sawo Tome-ni-Prinicipe
      SV:Salivadɔr
      SY:Siri
      SZ:Swazilandi
      TC:Turiki Gun ni Kayiki
      TD:Cadi
      TG:Togo
      TH:Tayilandi
      TJ:Tajikisitani
      TK:Tokelo
      TL:Kɔrɔn Timɔr
      TM:Turikimenisitani
      TN:Tunizi
      TO:Tonga
      TR:Turiki
      TT:Trinite-ni-Tobago
      TV:Tuvalu
      TW:Tayiwani
      TZ:Tanzani
      UA:Ukɛrɛni
      UG:Uganda
      US:Ameriki
      UY:Urugwayi
      UZ:Uzebekisitani
      VA:Vatikaŋ
      VC:Vinisɛn-Senu-ni-Grenadini
      VE:Venezuwela
      VG:Angilɛ ka Sungurunnin Gun
      VI:Ameriki ka Sungurunnin Gun
      VN:Wiyɛtinamu
      VU:Vanuwatu
      WF:Walisi-ni-Futuna
      WS:Samowa
      YE:Yemɛni
      YT:Mayoti
      ZA:Worodugu Afriki
      ZM:Zanbi
      ZW:Zimbabuwe
      """.trimIndent() }

  val bn: String by lazy { """
      001:পৃথিবী
      002:আফ্রিকা
      003:উত্তর আমেরিকা
      005:দক্ষিণ আমেরিকা
      009:ওশিয়ানিয়া
      011:পশ্চিম আফ্রিকা
      013:মধ্য আমেরিকা
      014:পূর্ব আফ্রিকা
      015:উত্তর আফ্রিকা
      017:মধ্য আফ্রিকা
      018:দক্ষিন আফ্রিকা
      019:আমেরিকা
      021:উত্তরাঞ্চলীয় আমেরিকা
      029:ক্যারিবিয়ান
      030:পূর্ব এশিয়া
      034:দক্ষিণ এশিয়া
      035:দক্ষিণ পূর্ব এশিয়া
      039:দক্ষিণ ইউরোপ
      053:অস্ট্রেলেশিয়া
      054:মেলানেশিয়া
      057:মাইক্রোনেশিয়া অঞ্চল
      061:পলিনেশিয়া
      142:এশিয়া
      143:মধ্য এশিয়া
      145:পশ্চিম এশিয়া
      150:ইউরোপ
      151:পূর্ব ইউরোপ
      154:উত্তর ইউরোপ
      155:পশ্চিম ইউরোপ
      202:উপ সাহারান আফ্রিকা
      419:লাতিন আমেরিকা
      AC:অ্যাসেনশন দ্বীপপুঞ্জ
      AD:আন্ডোরা
      AE:সংযুক্ত আরব আমিরাত
      AF:আফগানিস্তান
      AG:অ্যান্টিগুয়া ও বারবুডা
      AI:অ্যাঙ্গুইলা
      AL:আলবেনিয়া
      AM:আর্মেনিয়া
      AO:অ্যাঙ্গোলা
      AQ:অ্যান্টার্কটিকা
      AR:আর্জেন্টিনা
      AS:আমেরিকান সামোয়া
      AT:অস্ট্রিয়া
      AU:অস্ট্রেলিয়া
      AW:আরুবা
      AX:অলান্ড দ্বীপপুঞ্জ
      AZ:আজারবাইজান
      BA:বসনিয়া ও হার্জেগোভিনা
      BB:বার্বাডোজ
      BD:বাংলাদেশ
      BE:বেলজিয়াম
      BF:বুরকিনা ফাসো
      BG:বুলগেরিয়া
      BH:বাহারিন
      BI:বুরুন্ডি
      BJ:বেনিন
      BL:সেন্ট বার্থেলেমি
      BM:বারমুডা
      BN:ব্রুনেই
      BO:বলিভিয়া
      BQ:ক্যারিবিয়ান নেদারল্যান্ডস
      BR:ব্রাজিল
      BS:বাহামা দ্বীপপুঞ্জ
      BT:ভুটান
      BV:বোভেট দ্বীপ
      BW:বতসোয়ানা
      BY:বেলারুশ
      BZ:বেলিজ
      CA:কানাডা
      CC:কোকোস (কিলিং) দ্বীপপুঞ্জ
      CD:কঙ্গো-কিনশাসা
      CF:মধ্য আফ্রিকার প্রজাতন্ত্র
      CG:কঙ্গো - ব্রাজাভিল
      CH:সুইজারল্যান্ড
      CI:কোট ডি‘আইভোর
      CK:কুক দ্বীপপুঞ্জ
      CL:চিলি
      CM:ক্যামেরুন
      CN:চীন
      CO:কলম্বিয়া
      CP:ক্লিপারটন দ্বীপপুঞ্জ
      CR:কোস্টারিকা
      CU:কিউবা
      CV:কেপ ভার্দে
      CW:কুরাসাও
      CX:ক্রিসমাস দ্বীপ
      CY:সাইপ্রাস
      CZ:চেকিয়া
      DE:জার্মানি
      DG:দিয়েগো গার্সিয়া
      DJ:জিবুতি
      DK:ডেনমার্ক
      DM:ডোমিনিকা
      DO:ডোমেনিকান প্রজাতন্ত্র
      DZ:আলজেরিয়া
      EA:কুউটা এবং মেলিলা
      EC:ইকুয়েডর
      EE:এস্তোনিয়া
      EG:মিশর
      EH:পশ্চিম সাহারা
      ER:ইরিত্রিয়া
      ES:স্পেন
      ET:ইথিওপিয়া
      EU:ইউরোপীয় ইউনিয়ন
      EZ:ইউরোজোন
      FI:ফিনল্যান্ড
      FJ:ফিজি
      FK:ফকল্যান্ড দ্বীপপুঞ্জ
      FM:মাইক্রোনেশিয়া
      FO:ফ্যারো দ্বীপপুঞ্জ
      FR:ফ্রান্স
      GA:গ্যাবন
      GB:যুক্তরাজ্য
      GD:গ্রেনাডা
      GE:জর্জিয়া
      GF:ফরাসী গায়ানা
      GG:গার্নসি
      GH:ঘানা
      GI:জিব্রাল্টার
      GL:গ্রীনল্যান্ড
      GM:গাম্বিয়া
      GN:গিনি
      GP:গুয়াদেলৌপ
      GQ:নিরক্ষীয় গিনি
      GR:গ্রীস
      GS:দক্ষিণ জর্জিয়া ও দক্ষিণ স্যান্ডউইচ দ্বীপপুঞ্জ
      GT:গুয়াতেমালা
      GU:গুয়াম
      GW:গিনি-বিসাউ
      GY:গিয়ানা
      HK:হংকং এসএআর চীনা
      HM:হার্ড এবং ম্যাকডোনাল্ড দ্বীপপুঞ্জ
      HN:হন্ডুরাস
      HR:ক্রোয়েশিয়া
      HT:হাইতি
      HU:হাঙ্গেরি
      IC:ক্যানারি দ্বীপপুঞ্জ
      ID:ইন্দোনেশিয়া
      IE:আয়ারল্যান্ড
      IL:ইজরায়েল
      IM:আইল অফ ম্যান
      IN:ভারত
      IO:ব্রিটিশ ভারত মহাসাগরীয় অঞ্চল
      IQ:ইরাক
      IR:ইরান
      IS:আইসল্যান্ড
      IT:ইতালি
      JE:জার্সি
      JM:জামাইকা
      JO:জর্ডন
      JP:জাপান
      KE:কেনিয়া
      KG:কিরগিজিস্তান
      KH:কম্বোডিয়া
      KI:কিরিবাতি
      KM:কমোরোস
      KN:সেন্ট কিটস ও নেভিস
      KP:উত্তর কোরিয়া
      KR:দক্ষিণ কোরিয়া
      KW:কুয়েত
      KY:কেম্যান দ্বীপপুঞ্জ
      KZ:কাজাখস্তান
      LA:লাওস
      LB:লেবানন
      LC:সেন্ট লুসিয়া
      LI:লিচেনস্টেইন
      LK:শ্রীলঙ্কা
      LR:লাইবেরিয়া
      LS:লেসোথো
      LT:লিথুয়ানিয়া
      LU:লাক্সেমবার্গ
      LV:লাটভিয়া
      LY:লিবিয়া
      MA:মোরক্কো
      MC:মোনাকো
      MD:মলডোভা
      ME:মন্টিনিগ্রো
      MF:সেন্ট মার্টিন
      MG:মাদাগাস্কার
      MH:মার্শাল দ্বীপপুঞ্জ
      MK:উত্তর ম্যাসেডোনিয়া
      ML:মালি
      MM:মায়ানমার (বার্মা)
      MN:মঙ্গোলিয়া
      MO:ম্যাকাও এসএআর চীন
      MP:উত্তরাঞ্চলীয় মারিয়ানা দ্বীপপুঞ্জ
      MQ:মার্টিনিক
      MR:মরিতানিয়া
      MS:মন্টসেরাট
      MT:মাল্টা
      MU:মরিশাস
      MV:মালদ্বীপ
      MW:মালাউই
      MX:মেক্সিকো
      MY:মালয়েশিয়া
      MZ:মোজাম্বিক
      NA:নামিবিয়া
      NC:নিউ ক্যালেডোনিয়া
      NE:নাইজার
      NF:নরফোক দ্বীপ
      NG:নাইজেরিয়া
      NI:নিকারাগুয়া
      NL:নেদারল্যান্ডস
      NO:নরওয়ে
      NP:নেপাল
      NR:নাউরু
      NU:নিউয়ে
      NZ:নিউজিল্যান্ড
      OM:ওমান
      PA:পানামা
      PE:পেরু
      PF:ফরাসী পলিনেশিয়া
      PG:পাপুয়া নিউ গিনি
      PH:ফিলিপাইন
      PK:পাকিস্তান
      PL:পোল্যান্ড
      PM:সেন্ট পিয়ের ও মিকুয়েলন
      PN:পিটকেয়ার্ন দ্বীপপুঞ্জ
      PR:পুয়ের্তো রিকো
      PS:প্যালেস্টাইন ভূখণ্ড
      PT:পর্তুগাল
      PW:পালাউ
      PY:প্যারাগুয়ে
      QA:কাতার
      QO:আউটলাইনিং ওসানিয়া
      RE:রিইউনিয়ন
      RO:রোমানিয়া
      RS:সার্বিয়া
      RU:রাশিয়া
      RW:রুয়ান্ডা
      SA:সৌদি আরব
      SB:সলোমন দ্বীপপুঞ্জ
      SC:সিসিলি
      SD:সুদান
      SE:সুইডেন
      SG:সিঙ্গাপুর
      SH:সেন্ট হেলেনা
      SI:স্লোভানিয়া
      SJ:স্বালবার্ড ও জান মেয়েন
      SK:স্লোভাকিয়া
      SL:সিয়েরা লিওন
      SM:সান মারিনো
      SN:সেনেগাল
      SO:সোমালিয়া
      SR:সুরিনাম
      SS:দক্ষিণ সুদান
      ST:সাওটোমা ও প্রিন্সিপি
      SV:এল সালভেদর
      SX:সিন্ট মার্টেন
      SY:সিরিয়া
      SZ:ইসওয়াতিনি
      TA:ট্রিস্টান ডা কুনহা
      TC:তুর্কস ও কাইকোস দ্বীপপুঞ্জ
      TD:চাদ
      TF:ফরাসী দক্ষিণাঞ্চল
      TG:টোগো
      TH:থাইল্যান্ড
      TJ:তাজিকিস্তান
      TK:টোকেলাউ
      TL:তিমুর-লেস্তে
      TM:তুর্কমেনিস্তান
      TN:তিউনিসিয়া
      TO:টোঙ্গা
      TR:তুরস্ক
      TT:ত্রিনিনাদ ও টোব্যাগো
      TV:টুভালু
      TW:তাইওয়ান
      TZ:তাঞ্জানিয়া
      UA:ইউক্রেন
      UG:উগান্ডা
      UM:যুক্তরাষ্ট্রের পার্শ্ববর্তী দ্বীপপুঞ্জ
      UN:জাতিসংঘ
      US:মার্কিন যুক্তরাষ্ট্র
      UY:উরুগুয়ে
      UZ:উজবেকিস্তান
      VA:ভ্যাটিকান সিটি
      VC:সেন্ট ভিনসেন্ট ও গ্রেনাডিনস
      VE:ভেনেজুয়েলা
      VG:ব্রিটিশ ভার্জিন দ্বীপপুঞ্জ
      VI:মার্কিন যুক্তরাষ্ট্রীয় ভার্জিন দ্বীপপুঞ্জ
      VN:ভিয়েতনাম
      VU:ভানুয়াটু
      WF:ওয়ালিস ও ফুটুনা
      WS:সামোয়া
      XA:সিউডো-অ্যাকসেন্ট
      XB:সিউডো-বিডি
      XK:কসোভো
      YE:ইয়েমেন
      YT:মায়োত্তে
      ZA:দক্ষিণ আফ্রিকা
      ZM:জাম্বিয়া
      ZW:জিম্বাবোয়ে
      ZZ:অজানা অঞ্চল
      """.trimIndent() }

  val bn_IN: String by lazy { """
      018:দক্ষিণাঞ্চলীয় আফ্রিকা
      202:সাহারা-নিম্ন আফ্রিকা
      QO:ওশিয়ানিয়ার দূরবর্তী অঞ্চল
      UM:মার্কিন যুক্তরাষ্ট্রের দূরবর্তী দ্বীপপুঞ্জ
      """.trimIndent() }

  val bo: String by lazy { """
      001:འཛམ་གླིང་།
      CN:རྒྱ་ནག
      DE:འཇར་མན་
      GB:དབྱིན་ཇི་
      IN:རྒྱ་གར་
      IT:ཨི་ཀྲར་ལི་
      JP:ཉི་ཧོང་
      KR:ལྷོ་ཀོ་རི་ཡ།
      NP:བལ་ཡུལ་
      RU:ཨུ་རུ་སུ་
      US:ཨ་མེ་རི་ཀ།
      ZZ:མིའི་ཤེས་རྟོགས་མ་བྱུང་བའི་ཁོར་ཡུག
      """.trimIndent() }

  val bo_IN: String by lazy { """
      009:ཨོཤི་ཡཱན་ན།
      """.trimIndent() }

  val br: String by lazy { """
      001:Bed
      002:Afrika
      003:Norzhamerika
      005:Suamerika
      009:Oseania
      011:Afrika ar Cʼhornôg
      013:Kreizamerika
      014:Afrika ar Reter
      015:Afrika an Norzh
      017:Afrika ar Cʼhreiz
      018:Afrika ar Su
      019:Amerikaoù
      021:Amerika an Norzh
      029:Karib
      030:Azia ar Reter
      034:Azia ar Su
      035:Azia ar Gevred
      039:Europa ar Su
      053:Aostralazia
      054:Melanezia
      057:Rannved Mikronezia
      061:Polinezia
      142:Azia
      143:Azia ar Cʼhreiz
      145:Azia ar Cʼhornôg
      150:Europa
      151:Europa ar Reter
      154:Europa an Norzh
      155:Europa ar Cʼhornôg
      202:Afrika issaharat
      419:Amerika Latin
      AC:Enez Ascension
      AD:Andorra
      AE:Emirelezhioù Arab Unanet
      AF:Afghanistan
      AG:Antigua ha Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarktika
      AR:Arcʼhantina
      AS:Samoa Amerikan
      AT:Aostria
      AU:Aostralia
      AW:Aruba
      AX:Inizi Åland
      AZ:Azerbaidjan
      BA:Bosnia ha Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgia
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Saint Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Karib Nederlandat
      BR:Brazil
      BS:Bahamas
      BT:Bhoutan
      BV:Enez Bouvet
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Kanada
      CC:Inizi Kokoz
      CD:Kongo - Kinshasa
      CF:Republik Kreizafrikan
      CG:Kongo - Brazzaville
      CH:Suis
      CI:Aod an Olifant
      CK:Inizi Cook
      CL:Chile
      CM:Kameroun
      CN:Sina
      CO:Kolombia
      CP:Enez Clipperton
      CR:Costa Rica
      CU:Kuba
      CV:Kab-Glas
      CW:Curaçao
      CX:Enez Christmas
      CY:Kiprenez
      CZ:Tchekia
      DE:Alamagn
      DG:Diego Garcia
      DJ:Djibouti
      DK:Danmark
      DM:Dominica
      DO:Republik Dominikan
      DZ:Aljeria
      EA:Ceuta ha Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egipt
      EH:Sahara ar Cʼhornôg
      ER:Eritrea
      ES:Spagn
      ET:Etiopia
      EU:Unaniezh Europa
      EZ:takad an euro
      FI:Finland
      FJ:Fidji
      FK:Inizi Falkland
      FM:Mikronezia
      FO:Inizi Faero
      FR:Frañs
      GA:Gabon
      GB:Rouantelezh-Unanet
      GD:Grenada
      GE:Jorjia
      GF:Gwiana cʼhall
      GG:Gwernenez
      GH:Ghana
      GI:Jibraltar
      GL:Greunland
      GM:Gambia
      GN:Ginea
      GP:Gwadeloup
      GQ:Ginea ar Cʼheheder
      GR:Gres
      GS:Inizi Georgia ar Su hag Inizi Sandwich ar Su
      GT:Guatemala
      GU:Guam
      GW:Ginea-Bissau
      GY:Guyana
      HK:Hong Kong RMD Sina
      HM:Inizi Heard ha McDonald
      HN:Honduras
      HR:Kroatia
      HT:Haiti
      HU:Hungaria
      IC:Inizi Kanariez
      ID:Indonezia
      IE:Iwerzhon
      IL:Israel
      IM:Enez Vanav
      IN:India
      IQ:Iraq
      IR:Iran
      IS:Island
      IT:Italia
      JE:Jerzenez
      JM:Jamaika
      JO:Jordania
      JP:Japan
      KE:Kenya
      KG:Kyrgyzstan
      KH:Kambodja
      KI:Kiribati
      KM:Komorez
      KN:Saint Kitts ha Nevis
      KP:Korea an Norzh
      KR:Korea ar Su
      KW:Koweit
      KY:Inizi Cayman
      KZ:Kazakstan
      LA:Laos
      LB:Liban
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lituania
      LU:Luksembourg
      LV:Latvia
      LY:Libia
      MA:Maroko
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:Saint Martin
      MG:Madagaskar
      MH:Inizi Marshall
      MK:Makedonia an Norzh
      ML:Mali
      MM:Myanmar (Birmania)
      MN:Mongolia
      MO:Macau RMD Sina
      MP:Inizi Mariana an Norzh
      MQ:Martinik
      MR:Maouritania
      MS:Montserrat
      MT:Malta
      MU:Moris
      MV:Maldivez
      MW:Malawi
      MX:Mecʼhiko
      MY:Malaysia
      MZ:Mozambik
      NA:Namibia
      NC:Kaledonia Nevez
      NE:Niger
      NF:Enez Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Izelvroioù
      NO:Norvegia
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Zeland-Nevez
      OM:Oman
      PA:Panamá
      PE:Perou
      PF:Polinezia Cʼhall
      PG:Papoua Ginea-Nevez
      PH:Filipinez
      PK:Pakistan
      PL:Polonia
      PM:Sant-Pêr-ha-Mikelon
      PN:Enez Pitcairn
      PR:Puerto Rico
      PS:Tiriadoù Palestina
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Oseania diabell
      RE:Ar Reünion
      RO:Roumania
      RS:Serbia
      RU:Rusia
      RW:Rwanda
      SA:Arabia Saoudat
      SB:Inizi Salomon
      SC:Sechelez
      SD:Soudan
      SE:Sveden
      SG:Singapour
      SH:Saint-Helena
      SI:Slovenia
      SJ:Svalbard
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Susoudan
      ST:São Tomé ha Príncipe
      SV:Salvador
      SX:Sint Maarten
      SY:Siria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Inizi Turks ha Caicos
      TD:Tchad
      TF:Douaroù aostral Frañs
      TG:Togo
      TH:Thailand
      TJ:Tadjikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunizia
      TO:Tonga
      TR:Turkia
      TT:Trinidad ha Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraina
      UG:Ouganda
      UM:Inizi diabell ar Stadoù-Unanet
      UN:Broadoù unanet
      US:Stadoù-Unanet
      UY:Uruguay
      UZ:Ouzbekistan
      VA:Vatikan
      VC:Sant Visant hag ar Grenadinez
      VE:Venezuela
      VG:Inizi Gwercʼh Breizh-Veur
      VI:Inizi Gwercʼh ar Stadoù-Unanet
      VN:Viêt Nam
      VU:Vanuatu
      WF:Wallis ha Futuna
      WS:Samoa
      XA:pouez-mouezh gaou
      XB:BiDi gaou
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:Suafrika
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Rannved dianav
      """.trimIndent() }

  val brx: String by lazy { """
      001:बुहुम
      002:आफ्रिका
      003:साहा आमेरिका
      005:खोला आमेरिका
      009:ओशेआनिया
      011:सोनाबारि आफ्रिका
      013:मिरु आमेरिका
      014:सानजायारि आफ्रिका
      015:साहायारि आफ्रिका
      017:गेजेरारि आफ्रिका
      018:खोलायारि आफ्रिका
      019:आमेरिकानि
      021:साहायारि आमेरिका
      029:केरिबियान
      030:सानजायारि एसिया
      034:खोलायारि एसिया
      035:खोला-सानजा एसिया
      039:खोलायारि यूरोप
      053:अस्ट्रेलएसिया
      054:मेलानेसिया
      057:माईक्र’नेसियायारि ओनसोल
      061:पलिनेसिया
      142:एसिया
      143:मिरु एसिया
      145:सोनाबारि एसिया
      150:यूरोप
      151:सानजायारि यूरोप
      154:साहायारि यूरोप
      155:सोनाबारि यूरोप
      202:साहारायारि लोब्बा गोनां आफ्रिका
      419:लेटीन आमेरिका
      AC:एसेनसिअन द्वीप
      AD:एन्डर्रा
      AE:जथाय आराब एमिरेत
      AF:आफगानिस्तान
      AG:एन्टिगुआ आरो बारबुडा
      AI:एंगुइल्ला
      AL:आल्बानिया
      AM:आर्मेनिया
      AO:आंगला
      AQ:एन्टार्कटिका
      AR:आर्जेन्टिना
      AS:आमेरिकान सामआ
      AT:अस्ट्रिया
      AU:अस्ट्रेलिया
      AW:आरूबा
      AX:आलाण्ड द्वीपफोर
      AZ:आजेरबाईजान
      BA:बसनिया आरो होर्जेगभिना
      BB:बारबाड’स
      BD:बांलादेश
      BE:बेलजियाम
      BF:बुर्किना फास’
      BG:बुल्गारिया
      BH:बाहरैन
      BI:बुरूण्डी
      BJ:बेनिन
      BL:सैन्ट बार्थेलेमी
      BM:बारमूडा
      BN:ब्रूने
      BO:बलिभिया
      BQ:केरिबियान नेदारलेण्डस
      BR:ब्राजील
      BS:बाहामास
      BT:भूटान
      BV:बूभेट द्वीप
      BW:बत्स्वाना
      BY:बेलारूस
      BZ:बेलिज
      CA:केनाडा
      CC:कक’स द्वीपफोर
      CD:कंग’-किनशासा
      CF:मिरु आफ्रिका सुबुंखुंथाय
      CG:कंग’- ब्राज्जाभील
      CH:सुईजारलेण्ड
      CI:कट दिभवेर
      CK:कुक द्वीप
      CL:चिले
      CM:केमेरून
      CN:चाइना
      CO:कलम्बिया
      CP:क्लिप्पार्टन द्वीप
      CR:कस्टा रिका
      CU:क्यूबा
      CV:केप भेर्दे
      CW:कुरासाव
      CX:ख्रिसमास द्वीपफोर
      CY:साइप्रास
      CZ:चेखिया
      DE:जार्मानी
      DG:दियेग’ गार्सिया
      DJ:जिबौति
      DK:डेनमार्क
      DM:दमिनिका
      DO:दमिनिकान सुबुंखुंथाय
      DZ:आल्जेरिया
      EA:किउता आरो मेलिल्ला
      EC:एक्वाड’र
      EE:एस्ट’निया
      EG:ईजिप्त
      EH:सोनाबारि साहारा
      ER:एरिट्रिया
      ES:स्पैन
      ET:इथिय’पिया
      EU:यूरोपनि जथाय
      EZ:यूरो ओनसोल
      FI:फिनलेण्ड
      FJ:फिजी
      FK:फकलेण्ड द्वीपफोर
      FM:माइक्रनेशिया
      FO:फेर’ द्वीपफोर
      FR:फ्रान्स
      GA:गाबन
      GB:जथाय ब्रिटिश हादोर
      GD:ग्रेनादा
      GE:जर्जिया
      GF:फ्रेन्च गिआना
      GG:गोर्नसि
      GH:घाना
      GI:जिब्राल्टार
      GL:ग्रीनलेण्ड
      GM:गाम्बिया
      GN:गिनीया
      GP:ग्वादेल्यूप
      GQ:बिसुबारि गिनीया
      GR:ग्रीस
      GS:खोला जर्जिया आरो खोला सेण्डवीच द्वीपफोर
      GT:गुवाटेमाला
      GU:गुआम
      GW:गिनीया- बिसाऊ
      GY:गुयाना
      HK:हंकं एस.ए.आर चाइना
      HM:होर्द आरो मेकद’नाल्ड द्वीपफोर
      HN:हण्डूरास
      HR:क्रवेशिया
      HT:हाइती
      HU:हांगारी
      IC:कानारि द्वीपफोर
      ID:इण्ड’नेशिया
      IE:आयारलेण्ड
      IL:इज्राईल
      IM:आयोल अफ मेन
      IN:भारत
      IO:ब्रिटिशनि भारतारि लैथो बाहागो
      IQ:ईराक
      IR:ईरान
      IS:आइसलेण्ड
      IT:इटाली
      JE:जोर्सि
      JM:जामाइका
      JO:जर्डान
      JP:जापान
      KE:केनिया
      KG:किर्गीस्तान
      KH:कम्ब’डिया
      KI:किरिबाती
      KM:कम’र’ज
      KN:सैन्ट कीत्स आरो नेभिस
      KP:साहा करिया
      KR:खोला करिया
      KW:कुवैत
      KY:कैमेन द्वीपफोर
      KZ:काजाखस्तान
      LA:लाओस
      LB:लेबान’न
      LC:सैन्ट लुसिया
      LI:लिक्तोनस्ताईन
      LK:श्रीलंका
      LR:लाइबेरिया
      LS:लेस’थ’
      LT:लिथुआनिया
      LU:लाक्जेमबुर्ग
      LV:लाटभीया
      LY:लीबिया
      MA:मरक्क’
      MC:मनाक’
      MD:मल्ड’भा
      ME:मन्टेनेग्र’
      MF:सैन्ट मार्तिन
      MG:मादागास्कार
      MH:मार्शेल द्वीप
      MK:साहा मेसेड’निया
      ML:माली
      MM:म्यानमार
      MN:मंगलिया
      MO:माकाउ एस.ए.आर चाइना
      MP:साहायारि मारियाना द्वीप
      MQ:मार्तिनिक
      MR:माउरिटानिया
      MS:मनत्सेरात
      MT:माल्टा
      MU:मरिसियास
      MV:मालदीव
      MW:मालावी
      MX:मेक्सिक’
      MY:मालेशिया
      MZ:मजाम्बिक
      NA:नामीबिया
      NC:निउ केलेडनिया
      NE:नाइजेर
      NF:नर्फ’क द्वीप
      NG:नाइजेरिया
      NI:निकारागुआ
      NL:नेदारलेण्ड
      NO:नरवै
      NP:नेपाल
      NR:नाउरू
      NU:नीयूए
      NZ:न्यूजीलेण्ड
      OM:ओमान
      PA:पानामा
      PE:पेरू
      PF:फ्रेन्च पलिनेशिया
      PG:पापुआ निउ गिनी
      PH:फिलीपिन्स
      PK:पाकिस्तान
      PL:पलेण्ड
      PM:सैन्ट. पिएर आरो मिकैलन
      PN:पिटकाईर्न द्वीप
      PR:पुवेर्ट’ रीक’
      PS:पेलेस्ताइननि ओनसोलफोर
      PT:पर्तुगाल
      PW:पालाऊ
      PY:पारागुए
      QA:कातार
      QO:बायजोआरि असियानिया
      RE:रेयूनियन
      RO:रमानिया
      RS:सार्बिया
      RU:रासिया
      RW:रूआण्डा
      SA:साउदि आराबिया
      SB:सल’मन द्वीप
      SC:सैशेल्लेस
      SD:सूदान
      SE:स्वीडेन
      SG:सिंंगाप’र
      SH:सैन्ट हेलेना
      SI:स्ल’भेनिया
      SJ:स्भालबार्ड आरो जान मायेन
      SK:स्लभाकिया
      SL:सियेरा लेओन
      SM:सान मेरिन’
      SN:सेनेगाल
      SO:समालिया
      SR:सुरिनाम
      SS:खोला सुदान
      ST:साऊ तमे आरो प्रिन्सिप
      SV:एल साल्भाड’र
      SX:सिन्त मार्तेन
      SY:सीरिया
      SZ:एस्वातिनि
      TA:त्रिस्तान दा कुन्हा
      TC:तुर्की आरो काईक’ज द्वीपफोर
      TD:चाड
      TF:फ्रान्सनि खोलायारि बाहागोफोर
      TG:टग’
      TH:थाइलेण्ड
      TJ:ताजिकिस्तान
      TK:टकेलाऊ
      TL:तिमर-लेस्ते
      TM:तुर्कमेनीस्तान
      TN:त्युनिशिया
      TO:टंगा
      TR:तुर्की
      TT:त्रिनिडाड आरो तबेग’
      TV:तुभालु
      TW:ताइवान
      TZ:तान्जानिया
      UA:यूक्रेन
      UG:उगाण्डा
      UM:इउ.एस नि बायजोआरि द्वीपफोर
      UN:जथाय हादोरफोर
      US:जथाय हादोर आमेरिका
      UY:ऊरुगुवे
      UZ:उजबेकिस्तान
      VA:भेटिकान नोगोर
      VC:सैन्ट भिन्सेन्ट आरो ग्रेनादीन्स
      VE:भेनेजुवेला
      VG:ब्रिटिश भार्जिन द्वीपफोर
      VI:इउ. एस भार्जिन द्वीपफोर
      VN:भियेतनाम
      VU:भानुआटु
      WF:वालिस आरो फ्युचुना
      WS:सामआ
      XA:नंखाइ-गारांबोलो
      XB:नंखाइ- बिदि
      XK:कस’भ’
      YE:येमेन
      YT:मायत्ते
      ZA:खोला आफ्रिका
      ZM:जाम्बिया
      ZW:जिम्बाब्वे
      ZZ:मिथियै ओनसोल
      """.trimIndent() }

  val bs: String by lazy { """
      001:Svijet
      002:Afrika
      003:Sjeverna Amerika
      005:Južna Amerika
      009:Okeanija
      011:Zapadna Afrika
      013:Srednja Amerika
      014:Istočna Afrika
      015:Sjeverna Afrika
      017:Srednja Afrika
      018:Južna Afrika
      019:Amerika
      021:Sjeverni dio Amerike
      029:Karibi
      030:Istočna Azija
      034:Južna Azija
      035:Jugoistočna Azija
      039:Južna Evropa
      053:Australazija
      054:Melanezija
      057:Mikronezijska regija
      061:Polinezija
      142:Azija
      143:Srednja Azija
      145:Zapadna Azija
      150:Evropa
      151:Istočna Evropa
      154:Sjeverna Evropa
      155:Zapadna Evropa
      202:Subsaharska Afrika
      419:Latinska Amerika
      AC:Ostrvo Ascension
      AD:Andora
      AE:Ujedinjeni Arapski Emirati
      AF:Afganistan
      AG:Antigva i Barbuda
      AI:Angvila
      AL:Albanija
      AM:Armenija
      AO:Angola
      AQ:Antarktika
      AR:Argentina
      AS:Američka Samoa
      AT:Austrija
      AU:Australija
      AW:Aruba
      AX:Olandska ostrva
      AZ:Azerbejdžan
      BA:Bosna i Hercegovina
      BB:Barbados
      BD:Bangladeš
      BE:Belgija
      BF:Burkina Faso
      BG:Bugarska
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Sveti Bartolomej
      BM:Bermuda
      BN:Brunej
      BO:Bolivija
      BQ:Karipska Holandija
      BR:Brazil
      BS:Bahami
      BT:Butan
      BV:Ostrvo Buve
      BW:Bocvana
      BY:Bjelorusija
      BZ:Belize
      CA:Kanada
      CC:Kokosova (Keelingova) ostrva
      CD:Demokratska Republika Kongo
      CF:Centralnoafrička Republika
      CG:Kongo
      CH:Švicarska
      CI:Obala Slonovače
      CK:Kukova ostrva
      CL:Čile
      CM:Kamerun
      CN:Kina
      CO:Kolumbija
      CP:Ostrvo Clipperton
      CR:Kostarika
      CU:Kuba
      CV:Zelenortska Ostrva
      CW:Kurasao
      CX:Božićno ostrvo
      CY:Kipar
      CZ:Češka
      DE:Njemačka
      DG:Dijego Garsija
      DJ:Džibuti
      DK:Danska
      DM:Dominika
      DO:Dominikanska Republika
      DZ:Alžir
      EA:Seuta i Melilja
      EC:Ekvador
      EE:Estonija
      EG:Egipat
      EH:Zapadna Sahara
      ER:Eritreja
      ES:Španija
      ET:Etiopija
      EU:Evropska unija
      EZ:Eurozona
      FI:Finska
      FJ:Fidži
      FK:Folklandska ostrva
      FM:Mikronezija
      FO:Farska ostrva
      FR:Francuska
      GA:Gabon
      GB:Ujedinjeno Kraljevstvo
      GD:Grenada
      GE:Gruzija
      GF:Francuska Gvajana
      GG:Guernsey
      GH:Gana
      GI:Gibraltar
      GL:Grenland
      GM:Gambija
      GN:Gvineja
      GP:Gvadalupe
      GQ:Ekvatorijalna Gvineja
      GR:Grčka
      GS:Južna Džordžija i Južna Sendvič ostrva
      GT:Gvatemala
      GU:Guam
      GW:Gvineja-Bisao
      GY:Gvajana
      HK:Hong Kong (SAR Kina)
      HM:Ostrvo Heard i arhipelag McDonald
      HN:Honduras
      HR:Hrvatska
      HT:Haiti
      HU:Mađarska
      IC:Kanarska ostrva
      ID:Indonezija
      IE:Irska
      IL:Izrael
      IM:Ostrvo Man
      IN:Indija
      IO:Britanska Teritorija u Indijskom Okeanu
      IQ:Irak
      IR:Iran
      IS:Island
      IT:Italija
      JE:Jersey
      JM:Jamajka
      JO:Jordan
      JP:Japan
      KE:Kenija
      KG:Kirgistan
      KH:Kambodža
      KI:Kiribati
      KM:Komori
      KN:Sveti Kits i Nevis
      KP:Sjeverna Koreja
      KR:Južna Koreja
      KW:Kuvajt
      KY:Kajmanska ostrva
      KZ:Kazahstan
      LA:Laos
      LB:Liban
      LC:Sveta Lucija
      LI:Lihtenštajn
      LK:Šri Lanka
      LR:Liberija
      LS:Lesoto
      LT:Litvanija
      LU:Luksemburg
      LV:Latvija
      LY:Libija
      MA:Maroko
      MC:Monako
      MD:Moldavija
      ME:Crna Gora
      MF:Sveti Martin
      MG:Madagaskar
      MH:Maršalova ostrva
      MK:Sjeverna Makedonija
      ML:Mali
      MM:Mijanmar
      MN:Mongolija
      MO:Makao (SAR Kina)
      MP:Sjeverna Marijanska ostrva
      MQ:Martinik
      MR:Mauritanija
      MS:Monserat
      MT:Malta
      MU:Mauricijus
      MV:Maldivi
      MW:Malavi
      MX:Meksiko
      MY:Malezija
      MZ:Mozambik
      NA:Namibija
      NC:Nova Kaledonija
      NE:Niger
      NF:Ostrvo Norfolk
      NG:Nigerija
      NI:Nikaragva
      NL:Nizozemska
      NO:Norveška
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Novi Zeland
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Francuska Polinezija
      PG:Papua Nova Gvineja
      PH:Filipini
      PK:Pakistan
      PL:Poljska
      PM:Sveti Petar i Mikelon
      PN:Pitkernska Ostrva
      PR:Porto Riko
      PS:Palestinska Teritorija
      PT:Portugal
      PW:Palau
      PY:Paragvaj
      QA:Katar
      QO:Vanjska Okeanija
      RE:Reunion
      RO:Rumunija
      RS:Srbija
      RU:Rusija
      RW:Ruanda
      SA:Saudijska Arabija
      SB:Solomonska Ostrva
      SC:Sejšeli
      SD:Sudan
      SE:Švedska
      SG:Singapur
      SH:Sveta Helena
      SI:Slovenija
      SJ:Svalbard i Jan Mayen
      SK:Slovačka
      SL:Sijera Leone
      SM:San Marino
      SN:Senegal
      SO:Somalija
      SR:Surinam
      SS:Južni Sudan
      ST:Sao Tome i Principe
      SV:Salvador
      SX:Sint Marten
      SY:Sirija
      SZ:Esvatini
      TA:Tristan da Cunha
      TC:Ostrva Turks i Kaikos
      TD:Čad
      TF:Francuske Južne Teritorije
      TG:Togo
      TH:Tajland
      TJ:Tadžikistan
      TK:Tokelau
      TL:Istočni Timor
      TM:Turkmenistan
      TN:Tunis
      TO:Tonga
      TR:Turska
      TT:Trinidad i Tobago
      TV:Tuvalu
      TW:Tajvan
      TZ:Tanzanija
      UA:Ukrajina
      UG:Uganda
      UM:Američka Vanjska Ostrva
      UN:Ujedinjene Nacije
      US:Sjedinjene Države
      UY:Urugvaj
      UZ:Uzbekistan
      VA:Vatikan
      VC:Sveti Vinsent i Grenadin
      VE:Venecuela
      VG:Britanska Djevičanska ostrva
      VI:Američka Djevičanska ostrva
      VN:Vijetnam
      VU:Vanuatu
      WF:Ostrva Valis i Futuna
      WS:Samoa
      XA:Pseudo naglasci
      XB:Pseudo bidi
      XK:Kosovo
      YE:Jemen
      YT:Majote
      ZA:Južnoafrička Republika
      ZM:Zambija
      ZW:Zimbabve
      ZZ:Nepoznata oblast
      """.trimIndent() }

  val bs_Cyrl: String by lazy { """
      001:Свијет
      002:Африка
      003:Сјеверноамерички континент
      005:Јужна Америка
      009:Океанија
      011:Западна Африка
      013:Централна Америка
      014:Источна Африка
      015:Сјеверна Африка
      017:Централна Африка
      018:Јужна Африка
      019:Сјеверна и Јужна Америка
      021:Сјеверна Америка
      029:Кариби
      030:Источна Азија
      034:Јужна Азија
      035:Југоисточна Азија
      039:Јужна Европа
      053:Аустралија и Нови Зеланд
      054:Меланезија
      057:Микронезијски регион
      061:Полинезија
      142:Азија
      143:Централна Азија
      145:Западна Азија
      150:Европа
      151:Источна Европа
      154:Сјеверна Европа
      155:Западна Европа
      202:Подсахарска Африка
      419:Латинска Америка
      AC:Острво Асенсион
      AD:Андора
      AE:Уједињени Арапски Емирати
      AF:Афганистан
      AG:Антигва и Барбуда
      AI:Ангвила
      AL:Албанија
      AM:Арменија
      AO:Ангола
      AQ:Антарктик
      AR:Аргентина
      AS:Америчка Самоа
      AT:Аустрија
      AU:Аустралија
      AW:Аруба
      AX:Оландска острва
      AZ:Азербејџан
      BA:Босна и Херцеговина
      BB:Барбадос
      BD:Бангладеш
      BE:Белгија
      BF:Буркина Фасо
      BG:Бугарска
      BH:Бахреин
      BI:Бурунди
      BJ:Бенин
      BL:Свети Бартоломеј
      BM:Бермуди
      BN:Брунеј
      BO:Боливија
      BQ:Карипска Холандија
      BR:Бразил
      BS:Бахами
      BT:Бутан
      BV:Острво Буве
      BW:Боцвана
      BY:Бјелорусија
      BZ:Белизе
      CA:Канада
      CC:Кокос (Келинг) Острва
      CD:Демократска Република Конго
      CF:Централноафричка Република
      CG:Конго
      CH:Швицарска
      CI:Обала Слоноваче (Кот д’Ивоар)
      CK:Кукова Острва
      CL:Чиле
      CM:Камерун
      CN:Кина
      CO:Колумбија
      CP:Острво Клипертон
      CR:Костарика
      CU:Куба
      CV:Зеленортска Острва
      CW:Курасао
      CX:Божићно острво
      CY:Кипар
      CZ:Чешка
      DE:Њемачка
      DG:Дијего Гарсија
      DJ:Џибути
      DK:Данска
      DM:Доминика
      DO:Доминиканска Република
      DZ:Алжир
      EA:Сеута и Мелиља
      EC:Еквадор
      EE:Естонија
      EG:Египат
      EH:Западна Сахара
      ER:Еритреја
      ES:Шпанија
      ET:Етиопија
      EU:Европска унија
      EZ:Еурозона
      FI:Финска
      FJ:Фиџи
      FK:Фокландска Острва
      FM:Микронезија
      FO:Фарска острва
      FR:Француска
      GA:Габон
      GB:Уједињено Краљевство
      GD:Гренада
      GE:Грузија
      GF:Француска Гвајана
      GG:Гернзи
      GH:Гана
      GI:Гибралтар
      GL:Гренланд
      GM:Гамбија
      GN:Гвинеја
      GP:Гваделупе
      GQ:Екваторијална Гвинеја
      GR:Грчка
      GS:Јужна Џорџија и Јужна Сендвичка Острва
      GT:Гватемала
      GU:Гуам
      GW:Гвинеја-Бисау
      GY:Гвајана
      HK:Хонг Конг С. А. Р.
      HM:Херд и Мекдоналд Острва
      HN:Хондурас
      HR:Хрватска
      HT:Хаити
      HU:Мађарска
      IC:Канарска острва
      ID:Индонезија
      IE:Ирска
      IL:Израел
      IM:Острво Мен
      IN:Индија
      IO:Британска територија у Индијском океану
      IQ:Ирак
      IR:Иран
      IS:Исланд
      IT:Италија
      JE:Џерзи
      JM:Јамајка
      JO:Јордан
      JP:Јапан
      KE:Кенија
      KG:Киргизстан
      KH:Камбоџа
      KI:Кирибати
      KM:Комори
      KN:Свети Китс и Невис
      KP:Сјеверна Кореја
      KR:Јужна Кореја
      KW:Кувајт
      KY:Кајманска острва
      KZ:Казахстан
      LA:Лаос
      LB:Либан
      LC:Света Луција
      LI:Лихтенштајн
      LK:Шри Ланка
      LR:Либерија
      LS:Лесото
      LT:Литванија
      LU:Луксембург
      LV:Латвија
      LY:Либија
      MA:Мароко
      MC:Монако
      MD:Молдавија
      ME:Црна Гора
      MF:Свети Мартин
      MG:Мадагаскар
      MH:Маршалска Острва
      MK:Сјеверна Македонија
      ML:Мали
      MM:Мјанмар
      MN:Монголија
      MO:Макао С. А. Р.
      MP:Сјеверна Маријанска Острва
      MQ:Мартиник
      MR:Мауританија
      MS:Монсерат
      MT:Малта
      MU:Маурицијус
      MV:Малдиви
      MW:Малави
      MX:Мексико
      MY:Малезија
      MZ:Мозамбик
      NA:Намибија
      NC:Нова Каледонија
      NE:Нигер
      NF:Острво Норфолк
      NG:Нигерија
      NI:Никарагва
      NL:Холандија
      NO:Норвешка
      NP:Непал
      NR:Науру
      NU:Ниуе
      NZ:Нови Зеланд
      OM:Оман
      PA:Панама
      PE:Перу
      PF:Француска Полинезија
      PG:Папуа Нова Гвинеја
      PH:Филипини
      PK:Пакистан
      PL:Пољска
      PM:Сен Пјер и Микелон
      PN:Питкерн
      PR:Порторико
      PS:Палестинске територије
      PT:Португал
      PW:Палау
      PY:Парагвај
      QA:Катар
      QO:Остала океанија
      RE:Реинион
      RO:Румунија
      RS:Србија
      RU:Русија
      RW:Руанда
      SA:Саудијска Арабија
      SB:Соломонска Острва
      SC:Сејшели
      SD:Судан
      SE:Шведска
      SG:Сингапур
      SH:Света Хелена
      SI:Словенија
      SJ:Свалбард и Јан Мајен
      SK:Словачка
      SL:Сијера Леоне
      SM:Сан Марино
      SN:Сенегал
      SO:Сомалија
      SR:Суринам
      SS:Јужни Судан
      ST:Сао Томе и Принципе
      SV:Салвадор
      SX:Свети Мартин (Холандија)
      SY:Сирија
      SZ:Есватини
      TA:Тристан да Куња
      TC:Туркс и Кајкос Острва
      TD:Чад
      TF:Француске Јужне Територије
      TG:Того
      TH:Тајланд
      TJ:Таџикистан
      TK:Токелау
      TL:Тимор-Лесте
      TM:Туркменистан
      TN:Тунис
      TO:Тонга
      TR:Турска
      TT:Тринидад и Тобаго
      TV:Тувалу
      TW:Тајван
      TZ:Танзанија
      UA:Украјина
      UG:Уганда
      UM:Мања удаљена острва САД
      UN:Уједињене нације
      US:Сједињене Америчке Државе
      UY:Уругвај
      UZ:Узбекистан
      VA:Ватикан
      VC:Свети Винсент и Гренадини
      VE:Венецуела
      VG:Британска Дјевичанска острва
      VI:Америчка Дјевичанска острва
      VN:Вијетнам
      VU:Вануату
      WF:Валис и Футуна
      WS:Самоа
      XA:псеудо акценти
      XB:псеудо двосмјерно
      XK:Косово
      YE:Јемен
      YT:Мајоте
      ZA:Јужноафричка Република
      ZM:Замбија
      ZW:Зимбабве
      ZZ:Непозната или неважећа област
      """.trimIndent() }

  val bs_Latn: String? = null

  val bss: String by lazy { """
      CM:Kamerûn
      """.trimIndent() }

  val ca: String by lazy { """
      001:Món
      002:Àfrica
      003:Amèrica del Nord
      005:Amèrica del Sud
      009:Oceania
      011:Àfrica occidental
      013:Amèrica Central
      014:Àfrica oriental
      015:Àfrica septentrional
      017:Àfrica central
      018:Àfrica meridional
      019:Amèrica
      021:Amèrica septentrional
      029:Carib
      030:Àsia oriental
      034:Àsia meridional
      035:Àsia sud-oriental
      039:Europa meridional
      053:Australàsia
      054:Melanèsia
      057:Regió de la Micronèsia
      061:Polinèsia
      142:Àsia
      143:Àsia central
      145:Àsia occidental
      150:Europa
      151:Europa oriental
      154:Europa septentrional
      155:Europa occidental
      202:Àfrica subsahariana
      419:Amèrica Llatina
      AC:Illa de l’Ascensió
      AD:Andorra
      AE:Emirats Àrabs Units
      AF:Afganistan
      AG:Antigua i Barbuda
      AI:Anguilla
      AL:Albània
      AM:Armènia
      AO:Angola
      AQ:Antàrtida
      AR:Argentina
      AS:Samoa Americana
      AT:Àustria
      AU:Austràlia
      AW:Aruba
      AX:Illes Åland
      AZ:Azerbaidjan
      BA:Bòsnia i Hercegovina
      BB:Barbados
      BD:Bangladesh
      BE:Bèlgica
      BF:Burkina Faso
      BG:Bulgària
      BH:Bahrain
      BI:Burundi
      BJ:Benín
      BL:Saint-Barthélemy
      BM:Bermudes
      BN:Brunei
      BO:Bolívia
      BQ:Carib Neerlandès
      BR:Brasil
      BS:Bahames
      BT:Bhutan
      BV:Illa Bouvet
      BW:Botswana
      BY:Belarús
      BZ:Belize
      CA:Canadà
      CC:Illes Cocos (Keeling)
      CD:Congo - Kinshasa
      CF:República Centreafricana
      CG:Congo - Brazzaville
      CH:Suïssa
      CI:Côte d’Ivoire
      CK:Illes Cook
      CL:Xile
      CM:Camerun
      CN:Xina
      CO:Colòmbia
      CP:Illa Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cap Verd
      CW:Curaçao
      CX:Illa Christmas
      CY:Xipre
      CZ:Txèquia
      DE:Alemanya
      DG:Diego Garcia
      DJ:Djibouti
      DK:Dinamarca
      DM:Dominica
      DO:República Dominicana
      DZ:Algèria
      EA:Ceuta i Melilla
      EC:Equador
      EE:Estònia
      EG:Egipte
      EH:Sàhara Occidental
      ER:Eritrea
      ES:Espanya
      ET:Etiòpia
      EU:Unió Europea
      EZ:zona euro
      FI:Finlàndia
      FJ:Fiji
      FK:Illes Falkland
      FM:Micronèsia
      FO:Illes Fèroe
      FR:França
      GA:Gabon
      GB:Regne Unit
      GD:Grenada
      GE:Geòrgia
      GF:Guaiana Francesa
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Groenlàndia
      GM:Gàmbia
      GN:Guinea
      GP:Guadalupe
      GQ:Guinea Equatorial
      GR:Grècia
      GS:Illes Geòrgia del Sud i Sandwich del Sud
      GT:Guatemala
      GU:Guam
      GW:Guinea Bissau
      GY:Guyana
      HK:Hong Kong (RAE Xina)
      HM:Illes Heard i McDonald
      HN:Hondures
      HR:Croàcia
      HT:Haití
      HU:Hongria
      IC:Illes Canàries
      ID:Indonèsia
      IE:Irlanda
      IL:Israel
      IM:Illa de Man
      IN:Índia
      IO:Territori Britànic de l’Oceà Índic
      IQ:Iraq
      IR:Iran
      IS:Islàndia
      IT:Itàlia
      JE:Jersey
      JM:Jamaica
      JO:Jordània
      JP:Japó
      KE:Kenya
      KG:Kirguizstan
      KH:Cambodja
      KI:Kiribati
      KM:Comores
      KN:Saint Kitts i Nevis
      KP:Corea del Nord
      KR:Corea del Sud
      KW:Kuwait
      KY:Illes Caiman
      KZ:Kazakhstan
      LA:Lao
      LB:Líban
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Libèria
      LS:Lesotho
      LT:Lituània
      LU:Luxemburg
      LV:Letònia
      LY:Líbia
      MA:Marroc
      MC:Mònaco
      MD:Moldàvia
      ME:Montenegro
      MF:Saint Martin
      MG:Madagascar
      MH:Illes Marshall
      MK:Macedònia del Nord
      ML:Mali
      MM:Myanmar (Birmània)
      MN:Mongòlia
      MO:Macau (RAE Xina)
      MP:Illes Marianes del Nord
      MQ:Martinica
      MR:Mauritània
      MS:Montserrat
      MT:Malta
      MU:Maurici
      MV:Maldives
      MW:Malawi
      MX:Mèxic
      MY:Malàisia
      MZ:Moçambic
      NA:Namíbia
      NC:Nova Caledònia
      NE:Níger
      NF:Illa Norfolk
      NG:Nigèria
      NI:Nicaragua
      NL:Països Baixos
      NO:Noruega
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nova Zelanda
      OM:Oman
      PA:Panamà
      PE:Perú
      PF:Polinèsia Francesa
      PG:Papua Nova Guinea
      PH:Filipines
      PK:Pakistan
      PL:Polònia
      PM:Saint-Pierre-et-Miquelon
      PN:Illes Pitcairn
      PR:Puerto Rico
      PS:Territoris palestins
      PT:Portugal
      PW:Palau
      PY:Paraguai
      QA:Qatar
      QO:Territoris allunyats d’Oceania
      RE:Illa de la Reunió
      RO:Romania
      RS:Sèrbia
      RU:Rússia
      RW:Ruanda
      SA:Aràbia Saudí
      SB:Illes Salomó
      SC:Seychelles
      SD:Sudan
      SE:Suècia
      SG:Singapur
      SH:Santa Helena
      SI:Eslovènia
      SJ:Svalbard i Jan Mayen
      SK:Eslovàquia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somàlia
      SR:Surinam
      SS:Sudan del Sud
      ST:São Tomé i Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Síria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Illes Turks i Caicos
      TD:Txad
      TF:Terres Australs Antàrtiques Franceses
      TG:Togo
      TH:Tailàndia
      TJ:Tadjikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunísia
      TO:Tonga
      TR:Turquia
      TT:Trinidad i Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzània
      UA:Ucraïna
      UG:Uganda
      UM:Illes Menors Allunyades dels Estats Units
      UN:Nacions Unides
      US:Estats Units
      UY:Uruguai
      UZ:Uzbekistan
      VA:Ciutat del Vaticà
      VC:Saint Vincent i les Grenadines
      VE:Veneçuela
      VG:Illes Verges Britàniques
      VI:Illes Verges dels Estats Units
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis i Futuna
      WS:Samoa
      XA:pseudoaccents
      XB:pseudobidi
      XK:Kosovo
      YE:Iemen
      YT:Mayotte
      ZA:Sud-àfrica
      ZM:Zàmbia
      ZW:Zimbàbue
      ZZ:regió desconeguda
      """.trimIndent() }

  val ca_AD: String? = null

  val ca_ES_valencia: String by lazy { """
      001:Món
      002:Àfrica
      003:Amèrica del Nord
      005:Amèrica del Sud
      009:Oceania
      011:Àfrica occidental
      013:Amèrica Central
      014:Àfrica oriental
      015:Àfrica septentrional
      017:Àfrica central
      018:Àfrica meridional
      019:Amèrica
      021:Amèrica septentrional
      029:Carib
      030:Àsia oriental
      034:Àsia meridional
      035:Àsia sud-oriental
      039:Europa meridional
      053:Australàsia
      054:Melanèsia
      057:Regió de la Micronèsia
      061:Polinèsia
      142:Àsia
      143:Àsia central
      145:Àsia occidental
      150:Europa
      151:Europa oriental
      154:Europa septentrional
      155:Europa occidental
      202:Àfrica subsahariana
      419:Amèrica Llatina
      AC:Illa de l’Ascensió
      AD:Andorra
      AE:Emirats Àrabs Units
      AF:Afganistan
      AG:Antigua i Barbuda
      AI:Anguilla
      AL:Albània
      AM:Armènia
      AO:Angola
      AQ:Antàrtida
      AR:Argentina
      AS:Samoa Americana
      AT:Àustria
      AU:Austràlia
      AW:Aruba
      AX:Illes Åland
      AZ:Azerbaidjan
      BA:Bòsnia i Hercegovina
      BB:Barbados
      BD:Bangladesh
      BE:Bèlgica
      BF:Burkina Faso
      BG:Bulgària
      BH:Bahrain
      BI:Burundi
      BJ:Benín
      BL:Saint-Barthélemy
      BM:Bermudes
      BN:Brunei
      BO:Bolívia
      BQ:Carib Neerlandès
      BR:Brasil
      BS:Bahames
      BT:Bhutan
      BV:Illa Bouvet
      BW:Botswana
      BY:Belarús
      BZ:Belize
      CA:Canadà
      CC:Illes Cocos (Keeling)
      CD:Congo - Kinshasa
      CF:República Centreafricana
      CG:Congo - Brazzaville
      CH:Suïssa
      CI:Côte d’Ivoire
      CK:Illes Cook
      CL:Xile
      CM:Camerun
      CN:Xina
      CO:Colòmbia
      CP:Illa Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cap Verd
      CW:Curaçao
      CX:Illa Christmas
      CY:Xipre
      CZ:Txèquia
      DE:Alemanya
      DG:Diego Garcia
      DJ:Djibouti
      DK:Dinamarca
      DM:Dominica
      DO:República Dominicana
      DZ:Algèria
      EA:Ceuta i Melilla
      EC:Equador
      EE:Estònia
      EG:Egipte
      EH:Sàhara Occidental
      ER:Eritrea
      ES:Espanya
      ET:Etiòpia
      EU:Unió Europea
      EZ:zona euro
      FI:Finlàndia
      FJ:Fiji
      FK:Illes Falkland
      FM:Micronèsia
      FO:Illes Fèroe
      FR:França
      GA:Gabon
      GB:Regne Unit
      GD:Grenada
      GE:Geòrgia
      GF:Guaiana Francesa
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Groenlàndia
      GM:Gàmbia
      GN:Guinea
      GP:Guadalupe
      GQ:Guinea Equatorial
      GR:Grècia
      GS:Illes Geòrgia del Sud i Sandwich del Sud
      GT:Guatemala
      GU:Guam
      GW:Guinea Bissau
      GY:Guyana
      HK:Hong Kong (RAE Xina)
      HM:Illes Heard i McDonald
      HN:Hondures
      HR:Croàcia
      HT:Haití
      HU:Hongria
      IC:Illes Canàries
      ID:Indonèsia
      IE:Irlanda
      IL:Israel
      IM:Illa de Man
      IN:Índia
      IO:Territori Britànic de l’Oceà Índic
      IQ:Iraq
      IR:Iran
      IS:Islàndia
      IT:Itàlia
      JE:Jersey
      JM:Jamaica
      JO:Jordània
      JP:Japó
      KE:Kenya
      KG:Kirguizstan
      KH:Cambodja
      KI:Kiribati
      KM:Comores
      KN:Saint Kitts i Nevis
      KP:Corea del Nord
      KR:Corea del Sud
      KW:Kuwait
      KY:Illes Caiman
      KZ:Kazakhstan
      LA:Lao
      LB:Líban
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Libèria
      LS:Lesotho
      LT:Lituània
      LU:Luxemburg
      LV:Letònia
      LY:Líbia
      MA:Marroc
      MC:Mònaco
      MD:Moldàvia
      ME:Montenegro
      MF:Saint Martin
      MG:Madagascar
      MH:Illes Marshall
      MK:Macedònia del Nord
      ML:Mali
      MM:Myanmar (Birmània)
      MN:Mongòlia
      MO:Macau (RAE Xina)
      MP:Illes Marianes del Nord
      MQ:Martinica
      MR:Mauritània
      MS:Montserrat
      MT:Malta
      MU:Maurici
      MV:Maldives
      MW:Malawi
      MX:Mèxic
      MY:Malàisia
      MZ:Moçambic
      NA:Namíbia
      NC:Nova Caledònia
      NE:Níger
      NF:Illa Norfolk
      NG:Nigèria
      NI:Nicaragua
      NL:Països Baixos
      NO:Noruega
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nova Zelanda
      OM:Oman
      PA:Panamà
      PE:Perú
      PF:Polinèsia Francesa
      PG:Papua Nova Guinea
      PH:Filipines
      PK:Pakistan
      PL:Polònia
      PM:Saint-Pierre-et-Miquelon
      PN:Illes Pitcairn
      PR:Puerto Rico
      PS:Territoris palestins
      PT:Portugal
      PW:Palau
      PY:Paraguai
      QA:Qatar
      QO:Territoris allunyats d’Oceania
      RE:Illa de la Reunió
      RO:Romania
      RS:Sèrbia
      RU:Rússia
      RW:Ruanda
      SA:Aràbia Saudí
      SB:Illes Salomó
      SC:Seychelles
      SD:Sudan
      SE:Suècia
      SG:Singapur
      SH:Santa Helena
      SI:Eslovènia
      SJ:Svalbard i Jan Mayen
      SK:Eslovàquia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somàlia
      SR:Surinam
      SS:Sudan del Sud
      ST:São Tomé i Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Síria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Illes Turks i Caicos
      TD:Txad
      TF:Terres Australs Antàrtiques Franceses
      TG:Togo
      TH:Tailàndia
      TJ:Tadjikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunísia
      TO:Tonga
      TR:Turquia
      TT:Trinidad i Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzània
      UA:Ucraïna
      UG:Uganda
      UM:Illes Menors Allunyades dels Estats Units
      UN:Nacions Unides
      US:Estats Units
      UY:Uruguai
      UZ:Uzbekistan
      VA:Ciutat del Vaticà
      VC:Saint Vincent i les Grenadines
      VE:Veneçuela
      VG:Illes Verges Britàniques
      VI:Illes Verges dels Estats Units
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis i Futuna
      WS:Samoa
      XA:pseudoaccents
      XB:pseudobidi
      XK:Kosovo
      YE:Iemen
      YT:Mayotte
      ZA:Sud-àfrica
      ZM:Zàmbia
      ZW:Zimbàbue
      ZZ:regió desconeguda
      """.trimIndent() }

  val ca_FR: String? = null

  val ca_IT: String? = null

  val ccp: String by lazy { """
      001:𑄛𑄨𑄖𑄴𑄗𑄨𑄟𑄨
      002:𑄃𑄜𑄳𑄢𑄨𑄇
      003:𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄃𑄟𑄬𑄢𑄨𑄇
      005:𑄘𑄨𑄉𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇
      009:𑄃𑄮𑄥𑄨𑄠𑄚𑄨𑄠
      011:𑄛𑄧𑄏𑄨𑄟𑄴 𑄃𑄜𑄳𑄢𑄨𑄇
      013:𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄜𑄳𑄢𑄨𑄇
      014:𑄛𑄪𑄇𑄴𑄘𑄩 𑄃𑄜𑄳𑄢𑄨𑄇
      015:𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄃𑄜𑄳𑄢𑄨𑄇
      017:𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄜𑄳𑄢𑄨𑄇
      019:𑄃𑄟𑄬𑄢𑄨𑄇𑄥𑄴
      021:𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄎𑄉𑄢𑄴 𑄃𑄟𑄬𑄢𑄨𑄇
      029:𑄇𑄳𑄠𑄢𑄝𑄨𑄠𑄚𑄴
      030:𑄛𑄪𑄉𑄬𑄘𑄩 𑄃𑄬𑄥𑄨𑄠
      034:𑄘𑄧𑄉𑄨𑄚𑄬 𑄃𑄬𑄥𑄨𑄠
      035:𑄘𑄧𑄉𑄨𑄚𑄴 𑄛𑄪𑄇𑄴 𑄃𑄬𑄥𑄨𑄠
      039:𑄘𑄧𑄉𑄨𑄚𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴
      053:𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄣𑄬𑄥𑄨𑄠
      054:𑄟𑄳𑄠𑄣𑄬𑄚𑄬𑄥𑄨𑄠
      057:𑄟𑄭𑄇𑄳𑄢𑄮𑄚𑄬𑄥𑄨𑄠 𑄎𑄉
      061:𑄛𑄧𑄣𑄨𑄚𑄬𑄥𑄨𑄠
      142:𑄃𑄬𑄥𑄨𑄠
      143:𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄬𑄥𑄨𑄠
      145:𑄛𑄧𑄎𑄨𑄟𑄴 𑄃𑄬𑄥𑄨𑄠
      150:𑄄𑄃𑄪𑄢𑄮𑄛𑄴
      151:𑄛𑄪𑄉𑄬𑄘𑄨 𑄄𑄃𑄪𑄢𑄮𑄛𑄴
      154:𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴
      155:𑄛𑄧𑄎𑄨𑄟𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴
      419:𑄣𑄳𑄠𑄑𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇
      AC:𑄃𑄳𑄠𑄥𑄴𑄥𑄬𑄚𑄴𑄥𑄧𑄚𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴
      AD:𑄃𑄚𑄴𑄓𑄮𑄢
      AE:𑄎𑄧𑄙 𑄃𑄢𑄧𑄝𑄴 𑄃𑄟𑄨𑄢𑄖𑄴
      AF:𑄃𑄛𑄴𑄉𑄚𑄨𑄌𑄴𑄖𑄚𑄴
      AG:𑄆𑄚𑄴𑄖𑄨𑄉𑄱 𑄃𑄮 𑄝𑄢𑄴𑄟𑄪𑄓
      AI:𑄄𑄳𑄠𑄋𑄴𑄉𑄪𑄃𑄨𑄣
      AL:𑄃𑄣𑄴𑄝𑄬𑄚𑄨𑄠
      AM:𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠
      AO:𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣
      AQ:𑄃𑄳𑄠𑄚𑄴𑄑𑄢𑄴𑄇𑄧𑄑𑄨𑄇
      AR:𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚
      AS:𑄃𑄟𑄬𑄢𑄨𑄇𑄚𑄴 𑄥𑄟𑄮𑄠
      AT:𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠
      AU:𑄃𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠
      AW:𑄃𑄢𑄪𑄝
      AX:𑄃𑄣𑄚𑄴𑄓𑄧 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      AZ:𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴
      BA:𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄮 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚
      BB:𑄝𑄢𑄴𑄝𑄘𑄮𑄌𑄴
      BD:𑄝𑄁𑄣𑄘𑄬𑄌𑄴
      BE:𑄝𑄬𑄣𑄴𑄎𑄨𑄠𑄟𑄴
      BF:𑄝𑄪𑄢𑄴𑄇𑄨𑄚 𑄜𑄥𑄮
      BG:𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄨𑄠
      BH:𑄝𑄦𑄧𑄢𑄭𑄚𑄴
      BI:𑄝𑄪𑄢𑄪𑄚𑄴𑄘𑄨
      BJ:𑄝𑄬𑄚𑄨𑄚𑄴
      BL:𑄥𑄬𑄚𑄴𑄑𑄴 𑄝𑄢𑄴𑄗𑄬𑄣𑄨𑄟𑄨
      BM:𑄝𑄢𑄴𑄟𑄪𑄓
      BN:𑄝𑄳𑄢𑄪𑄚𑄬𑄭
      BO:𑄝𑄧𑄣𑄨𑄞𑄨𑄠
      BQ:𑄇𑄳𑄠𑄢𑄨𑄝𑄨𑄠𑄚𑄴 𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄧𑄥𑄴
      BR:𑄝𑄳𑄢𑄎𑄨𑄣𑄴
      BS:𑄝𑄦𑄟 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      BT:𑄞𑄪𑄑𑄚𑄴
      BV:𑄝𑄮𑄞𑄬𑄑𑄴 𑄞𑄨𑄘𑄳𑄠
      BW:𑄝𑄧𑄖𑄴𑄥𑄮𑄠𑄚
      BY:𑄝𑄬𑄣𑄢𑄪𑄌𑄴
      BZ:𑄝𑄬𑄣𑄨𑄎𑄴
      CA:𑄇𑄚𑄓
      CC:𑄇𑄮𑄇𑄮𑄌𑄴 (𑄇𑄨𑄣𑄨𑄁) 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      CD:𑄇𑄧𑄋𑄴𑄉𑄮-𑄚𑄨𑄇𑄴𑄥𑄥
      CF:𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄜𑄳𑄢𑄨𑄇𑄢𑄴𑄛𑄳𑄢𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧
      CG:𑄇𑄧𑄋𑄴𑄉𑄮-𑄝𑄳𑄢𑄎𑄞𑄨𑄣𑄴
      CH:𑄥𑄭𑄪𑄎𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴
      CI:𑄃𑄭𑄞𑄧𑄢𑄨 𑄇𑄮𑄌𑄴𑄑𑄴
      CK:𑄇𑄪𑄇𑄪 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      CL:𑄌𑄨𑄣𑄨
      CM:𑄇𑄳𑄠𑄟𑄬𑄢𑄪𑄚𑄴
      CN:𑄌𑄩𑄚𑄴
      CO:𑄃𑄣𑄧𑄟𑄴𑄝𑄨𑄠
      CP:𑄇𑄳𑄣𑄨𑄛𑄢𑄴𑄑𑄧𑄚𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄳𑄓𑄴
      CR:𑄇𑄮𑄥𑄳𑄑𑄢𑄨𑄇
      CU:𑄇𑄨𑄃𑄪𑄝
      CV:𑄇𑄬𑄛𑄴𑄞𑄢𑄴𑄘𑄬
      CW:𑄇𑄨𑄃𑄪𑄢𑄥𑄃𑄮
      CX:𑄇𑄳𑄢𑄨𑄥𑄴𑄟𑄥𑄴 𑄞𑄨𑄘𑄳𑄠
      CY:𑄥𑄭𑄛𑄳𑄢𑄥𑄴
      CZ:𑄌𑄬𑄌𑄨𑄠
      DE:𑄎𑄢𑄴𑄟𑄚𑄨
      DG:𑄘𑄨𑄠𑄬𑄉𑄮 𑄉𑄢𑄴𑄥𑄨𑄠
      DJ:𑄎𑄨𑄝𑄪𑄖𑄨
      DK:𑄓𑄬𑄚𑄴𑄟𑄢𑄴𑄇𑄧
      DM:𑄓𑄮𑄟𑄨𑄚𑄨𑄇
      DO:𑄓𑄮𑄟𑄨𑄚𑄨𑄇𑄚𑄴 𑄛𑄳𑄢𑄧𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧
      DZ:𑄃𑄢𑄴𑄎𑄬𑄢𑄨𑄠
      EA:𑄇𑄪𑄃𑄪𑄑 𑄃𑄳𑄃 𑄟𑄬𑄣𑄨𑄣
      EC:𑄄𑄇𑄪𑄠𑄬𑄓𑄧𑄢𑄴
      EE:𑄆𑄌𑄴𑄖𑄮𑄚𑄨𑄠
      EG:𑄟𑄨𑄥𑄧𑄢𑄴
      EH:𑄛𑄧𑄎𑄨𑄟𑄴 𑄥𑄦𑄢
      ER:𑄄𑄢𑄨𑄖𑄳𑄢𑄨𑄠
      ES:𑄥𑄳𑄛𑄬𑄚𑄴
      ET:𑄃𑄨𑄜𑄨𑄃𑄮𑄛𑄨𑄠
      EU:𑄄𑄃𑄪𑄢𑄮𑄛𑄩𑄠𑄧 𑄄𑄃𑄪𑄚𑄨𑄠𑄧𑄚𑄴
      FI:𑄜𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴
      FJ:𑄜𑄨𑄎𑄨
      FK:𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      FM:𑄟𑄭𑄇𑄳𑄢𑄮𑄚𑄬𑄥𑄨𑄠
      FO:𑄜𑄳𑄠𑄢𑄧𑄃𑄮 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      FR:𑄜𑄳𑄢𑄚𑄴𑄥𑄴
      GA:𑄉𑄳𑄠𑄝𑄧𑄚𑄴
      GB:𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮
      GD:𑄉𑄳𑄢𑄬𑄚𑄓
      GE:𑄎𑄧𑄢𑄴𑄎𑄨𑄠
      GF:𑄜𑄧𑄢𑄥𑄩 𑄉𑄠𑄚
      GG:𑄉𑄳𑄢𑄚𑄴𑄏𑄨
      GH:𑄊𑄚
      GI:𑄎𑄨𑄝𑄳𑄢𑄣𑄴𑄑𑄢𑄴
      GL:𑄉𑄳𑄢𑄩𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴
      GM:𑄉𑄟𑄴𑄝𑄨𑄠
      GN:𑄉𑄨𑄚𑄨
      GP:𑄉𑄪𑄠𑄘𑄬𑄣𑄯𑄛𑄴
      GQ:𑄚𑄨𑄢𑄧𑄇𑄴𑄈𑄩𑄠𑄧 𑄉𑄨𑄚𑄨
      GR:𑄉𑄳𑄢𑄨𑄌𑄴
      GS:𑄘𑄧𑄉𑄨𑄚𑄴 𑄎𑄧𑄢𑄴𑄎𑄨𑄠 𑄃𑄮 𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄳𑄠𑄚𑄴𑄓𑄃𑄪𑄃𑄨𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      GT:𑄉𑄪𑄠𑄖𑄬𑄟𑄣
      GU:𑄉𑄪𑄠𑄟𑄴
      GW:𑄉𑄨𑄚𑄨-𑄝𑄨𑄥𑄃𑄪
      GY:𑄉𑄨𑄠𑄚
      HK:𑄦𑄧𑄁𑄇𑄧𑄁 𑄆𑄌𑄴𑄃𑄬𑄃𑄢𑄴 𑄌𑄩𑄚
      HM:𑄦𑄢𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠 𑄃𑄳𑄃 𑄟𑄳𑄠𑄇𑄴𑄓𑄮𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      HN:𑄦𑄪𑄚𑄴𑄓𑄪𑄢𑄥𑄴
      HR:𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠
      HT:𑄦𑄭𑄖𑄨
      HU:𑄦𑄧𑄋𑄴𑄉𑄬𑄢𑄨
      IC:𑄇𑄳𑄠𑄚𑄢𑄨 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      ID:𑄄𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠
      IE:𑄃𑄠𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴
      IL:𑄄𑄎𑄴𑄢𑄠𑄬𑄣𑄴
      IM:𑄃𑄭𑄣𑄴 𑄃𑄧𑄜𑄴 𑄟𑄳𑄠𑄚𑄴
      IN:𑄞𑄢𑄧𑄖𑄴
      IQ:𑄄𑄢𑄇𑄴
      IR:𑄄𑄢𑄚𑄴
      IS:𑄃𑄭𑄥𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴
      IT:𑄄𑄖𑄣𑄨
      JE:𑄎𑄢𑄴𑄥𑄨
      JM:𑄎𑄟𑄭𑄇
      JO:𑄎𑄧𑄢𑄴𑄓𑄧𑄚𑄴
      JP:𑄎𑄛𑄚𑄴
      KE:𑄇𑄬𑄚𑄨𑄠
      KG:𑄇𑄨𑄢𑄴𑄉𑄨𑄎𑄨𑄌𑄴𑄖𑄚𑄴
      KH:𑄇𑄧𑄟𑄴𑄝𑄮𑄓𑄨𑄠
      KI:𑄇𑄨𑄢𑄨𑄝𑄖𑄨
      KM:𑄇𑄧𑄟𑄮𑄢𑄮𑄌𑄴
      KN:𑄥𑄬𑄚𑄴𑄑𑄴 𑄇𑄨𑄑𑄴𑄥𑄴 𑄃𑄮 𑄚𑄬𑄞𑄨𑄌𑄴
      KP:𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄇𑄮𑄢𑄨𑄠
      KR:𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄮𑄢𑄨𑄠
      KW:𑄇𑄪𑄠𑄬𑄖𑄴
      KY:𑄇𑄬𑄟𑄳𑄠𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      KZ:𑄇𑄎𑄈𑄌𑄴𑄖𑄚𑄴
      LA:𑄣𑄃𑄮𑄌𑄴
      LB:𑄣𑄬𑄝𑄚𑄧𑄚𑄴
      LC:𑄥𑄬𑄚𑄴𑄑𑄴 𑄣𑄪𑄥𑄨𑄠
      LI:𑄣𑄨𑄌𑄬𑄚𑄴𑄥𑄳𑄑𑄬𑄃𑄨𑄚𑄴
      LK:𑄥𑄳𑄢𑄨𑄣𑄧𑄁𑄇
      LR:𑄃𑄭𑄝𑄬𑄢𑄨𑄠
      LS:𑄣𑄬𑄥𑄮𑄗𑄮
      LT:𑄣𑄨𑄗𑄪𑄠𑄚𑄨𑄠
      LU:𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄧
      LV:𑄣𑄖𑄴𑄞𑄨𑄠
      LY:𑄣𑄨𑄝𑄨𑄠
      MA:𑄟𑄮𑄢𑄧𑄇𑄴𑄇𑄮
      MC:𑄟𑄮𑄚𑄇𑄮
      MD:𑄟𑄮𑄣𑄴𑄘𑄞𑄨𑄠
      ME:𑄟𑄧𑄚𑄴𑄑𑄨𑄚𑄨𑄉𑄳𑄢𑄮
      MF:𑄥𑄬𑄚𑄴𑄑𑄴 𑄟𑄢𑄴𑄑𑄨𑄚𑄴
      MG:𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴
      MH:𑄟𑄢𑄴𑄥𑄣𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      MK:𑄟𑄳𑄠𑄥𑄓𑄮𑄚𑄨𑄠
      ML:𑄟𑄣𑄨
      MM:𑄟𑄠𑄚𑄴𑄟𑄢𑄴 (𑄝𑄢𑄴𑄟)
      MN:𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄠
      MO:𑄟𑄳𑄠𑄇𑄃𑄮 𑄆𑄌𑄴𑄃𑄬𑄃𑄢𑄴 𑄌𑄩𑄚
      MP:𑄅𑄪𑄖𑄴𑄖𑄮𑄉𑄎𑄢𑄴 𑄟𑄢𑄨𑄠𑄚 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      MQ:𑄟𑄢𑄴𑄑𑄨𑄚𑄨𑄇𑄴
      MR:𑄟𑄧𑄢𑄨𑄖𑄚𑄨𑄠
      MS:𑄟𑄧𑄚𑄴𑄑𑄴𑄥𑄬𑄢𑄑𑄴
      MT:𑄟𑄣𑄴𑄑
      MU:𑄟𑄧𑄢𑄨𑄥𑄥𑄴
      MV:𑄟𑄣𑄴𑄘𑄨𑄛𑄴
      MW:𑄟𑄣𑄃𑄪𑄃𑄨
      MX:𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄮
      MY:𑄟𑄣𑄴𑄠𑄬𑄥𑄨𑄠
      MZ:𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴
      NA:𑄚𑄟𑄨𑄝𑄨𑄠
      NC:𑄚𑄱 𑄇𑄳𑄠𑄣𑄬𑄓𑄮𑄚𑄨𑄠
      NE:𑄚𑄭𑄎𑄢𑄴
      NF:𑄚𑄨𑄢𑄴𑄜𑄮𑄇𑄴 𑄞𑄨𑄘𑄳𑄠
      NG:𑄚𑄭𑄎𑄬𑄢𑄨𑄠
      NI:𑄚𑄨𑄇𑄢𑄉𑄪𑄠
      NL:𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴𑄥𑄴
      NO:𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬
      NP:𑄚𑄬𑄛𑄣𑄴
      NR:𑄚𑄃𑄪𑄢𑄪
      NU:𑄚𑄨𑄃𑄪𑄠𑄬
      NZ:𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴
      OM:𑄃𑄮𑄟𑄚𑄴
      PA:𑄛𑄚𑄟
      PE:𑄛𑄬𑄢𑄪
      PF:𑄜𑄧𑄢𑄥𑄩 𑄛𑄧𑄣𑄨𑄚𑄬𑄥𑄨𑄠
      PG:𑄛𑄛𑄪𑄠 𑄚𑄨𑄃𑄪 𑄉𑄨𑄚𑄨
      PH:𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴
      PK:𑄛𑄇𑄨𑄌𑄴𑄖𑄚𑄴
      PL:𑄛𑄮𑄣𑄳𑄠𑄚𑄴𑄓𑄴
      PM:𑄥𑄬𑄚𑄴𑄑𑄴 𑄛𑄨𑄠𑄬𑄢𑄴 𑄃𑄮 𑄟𑄨𑄢𑄪𑄠𑄬𑄣𑄧𑄚𑄴
      PN:𑄛𑄨𑄇𑄴𑄇𑄬𑄠𑄢𑄴𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      PR:𑄛𑄪𑄠𑄬𑄢𑄴𑄖𑄮 𑄢𑄨𑄇𑄮
      PS:𑄜𑄨𑄣𑄨𑄌𑄴𑄖𑄨𑄚𑄴 𑄎𑄉𑄊𑄚𑄨
      PT:𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄣𑄴
      PW:𑄛𑄣𑄃𑄪
      PY:𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄬
      QA:𑄇𑄖𑄢𑄴
      QO:𑄃𑄅𑄪𑄑𑄣𑄭𑄚𑄨𑄁 𑄃𑄮𑄥𑄚𑄨𑄠
      RE:𑄢𑄨𑄃𑄨𑄃𑄪𑄚𑄨𑄠𑄧𑄚𑄴
      RO:𑄢𑄮𑄟𑄚𑄨𑄠
      RS:𑄥𑄢𑄴𑄝𑄨𑄠
      RU:𑄢𑄥𑄨𑄠
      RW:𑄢𑄪𑄠𑄚𑄴𑄓
      SA:𑄥𑄯𑄘𑄨 𑄃𑄢𑄧𑄝𑄴
      SB:𑄥𑄧𑄣𑄮𑄟𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      SC:𑄥𑄨𑄥𑄨𑄣𑄨
      SD:𑄥𑄪𑄘𑄚𑄴
      SE:𑄥𑄭𑄪𑄓𑄬𑄚𑄴
      SG:𑄥𑄨𑄋𑄴𑄉𑄛𑄪𑄢𑄴
      SH:𑄥𑄬𑄚𑄴𑄑𑄴 𑄦𑄬𑄣𑄬𑄚
      SI:𑄥𑄳𑄣𑄮𑄞𑄚𑄨𑄠
      SJ:𑄥𑄣𑄴𑄝𑄢𑄴𑄓𑄴 𑄃𑄮 𑄎𑄚𑄴 𑄟𑄬𑄠𑄬𑄚𑄴
      SK:𑄥𑄳𑄣𑄮𑄞𑄇𑄨𑄠
      SL:𑄥𑄨𑄠𑄬𑄢𑄣𑄨𑄃𑄮𑄚𑄴
      SM:𑄥𑄚𑄴 𑄟𑄢𑄨𑄚𑄮
      SN:𑄥𑄬𑄚𑄬𑄉𑄣𑄴
      SO:𑄥𑄮𑄟𑄣𑄨𑄠
      SR:𑄥𑄪𑄢𑄨𑄚𑄟𑄴
      SS:𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄪𑄘𑄚𑄴
      ST:𑄥𑄃𑄮𑄑𑄟 𑄃𑄮 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄨
      SV:𑄆𑄣𑄴 𑄥𑄣𑄴𑄞𑄬𑄘𑄧𑄢𑄴
      SX:𑄥𑄨𑄚𑄴𑄑𑄴 𑄟𑄢𑄴𑄑𑄬𑄚𑄴
      SY:𑄥𑄨𑄢𑄨𑄠
      SZ:𑄥𑄮𑄠𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴
      TA:𑄑𑄳𑄢𑄌𑄴𑄑𑄚𑄴 𑄓 𑄇𑄪𑄚𑄴𑄦
      TC:𑄖𑄪𑄢𑄴𑄇𑄧𑄌𑄴 𑄃𑄮 𑄇𑄭𑄇𑄮𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      TD:𑄌𑄘𑄴
      TF:𑄜𑄢𑄥𑄩 𑄘𑄧𑄉𑄨𑄚𑄧 𑄎𑄉
      TG:𑄑𑄮𑄉𑄮
      TH:𑄗𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴
      TJ:𑄖𑄎𑄨𑄇𑄴𑄥𑄳𑄗𑄚𑄴
      TK:𑄑𑄮𑄇𑄬𑄣𑄃𑄪
      TL:𑄖𑄨𑄟𑄪𑄢𑄴-𑄣𑄬𑄌𑄴𑄖𑄬
      TM:𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄴
      TN:𑄖𑄨𑄃𑄪𑄚𑄨𑄥𑄨𑄠
      TO:𑄑𑄮𑄋𑄴𑄉
      TR:𑄖𑄪𑄢𑄧𑄌𑄴𑄇𑄧
      TT:𑄖𑄳𑄢𑄨𑄚𑄨𑄚𑄘𑄴 𑄃𑄮 𑄑𑄮𑄝𑄳𑄠𑄉𑄮
      TV:𑄑𑄪𑄞𑄣𑄪
      TW:𑄖𑄭𑄤𑄚𑄴
      TZ:𑄖𑄚𑄴𑄎𑄚𑄨𑄠
      UA:𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄬𑄚𑄴
      UG:𑄅𑄉𑄚𑄴𑄓
      UM:𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄦𑄭𑄇𑄪𑄢𑄬 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      UN:𑄎𑄘𑄨𑄥𑄧𑄁𑄊𑄧
      US:𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮
      UY:𑄅𑄪𑄢𑄪𑄉𑄪𑄠𑄬
      UZ:𑄅𑄪𑄎𑄴𑄝𑄬𑄇𑄨𑄌𑄴𑄖𑄚𑄴
      VA:𑄞𑄳𑄠𑄑𑄨𑄇𑄚𑄴 𑄥𑄨𑄑𑄨
      VC:𑄥𑄬𑄚𑄴𑄑𑄴 𑄞𑄨𑄚𑄴𑄥𑄬𑄚𑄴𑄑𑄴 𑄃𑄮 𑄘𑄳𑄠 𑄉𑄳𑄢𑄬𑄚𑄓𑄨𑄚𑄴𑄥𑄴
      VE:𑄞𑄬𑄚𑄬𑄎𑄪𑄠𑄬𑄣
      VG:𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄞𑄢𑄴𑄎𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      VI:𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄞𑄢𑄴𑄎𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠
      VN:𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄴
      VU:𑄞𑄚𑄪𑄠𑄑𑄪
      WF:𑄤𑄣𑄨𑄌𑄴 𑄃𑄮 𑄜𑄪𑄑𑄪𑄚
      WS:𑄥𑄟𑄮𑄠
      XK:𑄇𑄧𑄥𑄮𑄞𑄮
      YE:𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄴
      YT:𑄟𑄠𑄮𑄖𑄴𑄖𑄬
      ZA:𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇
      ZM:𑄎𑄟𑄴𑄝𑄨𑄠
      ZW:𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬
      ZZ:𑄃𑄨𑄌𑄨𑄚𑄴 𑄎𑄉
      """.trimIndent() }

  val ccp_IN: String? = null

  val ce: String by lazy { """
      001:Дерригдуьненан
      002:Африка
      003:Къилбаседа Америка
      005:Къилба Америка
      009:Океани
      011:Малхбузен Африка
      013:Юккъера Америка
      014:Малхбален Африка
      015:Къилбаседа Африка
      017:Юккъера Африка
      018:Къилба Африка
      019:Къилбаседа а, къилба а Америка
      021:Къилбаседа Америка – АЦШ а, Канада а
      029:Карибаш
      030:Юккъера Ази
      034:Къилба Ази
      035:Къилба-малхбален Ази
      039:Къилба Европа
      053:Австралази
      054:Меланези
      057:Микронези
      061:Полинези
      142:Ази
      143:Юккъера Малхбале
      145:Юккъера а, Гергара а Малхбале
      150:Европа
      151:Малхбален Европа
      154:Къилбаседа Европа
      155:Малхбузен Европа
      419:Латинан Америка
      AC:Айъадаларан гӀайре
      AD:Андорра
      AE:Ӏарбийн Цхьанатоьхна Эмираташ
      AF:ОвхӀан мохк
      AG:Антигуа а, Барбуда а
      AI:Ангилья
      AL:Албани
      AM:Эрмалойчоь
      AO:Ангола
      AQ:Антарктида
      AR:Аргентина
      AS:Американ Самоа
      AT:Австри
      AU:Австрали
      AW:Аруба
      AX:Аландан гӀайренаш
      AZ:Азербайджан
      BA:Босни а, Герцеговина а
      BB:Барбадос
      BD:Бангладеш
      BE:Бельги
      BF:Буркина- Фасо
      BG:Болгари
      BH:Бахрейн
      BI:Бурунди
      BJ:Бенин
      BL:Сен-Бартельми
      BM:Бермудан гӀайренаш
      BN:Бруней-Даруссалам
      BO:Боливи
      BQ:Бонэйр, Синт-Эстатиус а, Саба а
      BR:Бразили
      BS:Багаман гӀайренаш
      BT:Бутан
      BV:Бувен гӀайре
      BW:Ботсвана
      BY:Белорусси
      BZ:Белиз
      CA:Канада
      CC:Кокосийн гӀайренаш
      CD:Демократин Республика Конго
      CF:Юккъерчу Африкин Республика
      CG:Конго - Браззавиль
      CH:Швейцари
      CI:Кот-Д’ивуар
      CK:Кукан гӀайренаш
      CL:Чили
      CM:Камерун
      CN:Цийчоь
      CO:Колумби
      CP:Клиппертон
      CR:Коста-Рика
      CU:Куба
      CV:Кабо-Верде
      CW:Кюрасао
      CX:ГӀайре ӏиса пайхӏамар вина де
      CY:Кипр
      CZ:Чехи
      DE:Германи
      DG:Диего-Гарси
      DJ:Джибути
      DK:Дани
      DM:Доминика
      DO:Доминикан Республика
      DZ:Алжир
      EA:Сеута а, Мелилья а
      EC:Эквадор
      EE:Эстони
      EG:Мисар
      EH:Малхбузен Саьхьара
      ER:Эритрей
      ES:Испани
      ET:Эфиопи
      EU:Евробарт
      EZ:еврозона
      FI:Финлянди
      FJ:Фиджи
      FK:Фолклендан гӀайренаш
      FM:Микронезин Федеративни штаташ
      FO:Фарерийн гӀайренаш
      FR:Франци
      GA:Габон
      GB:Йоккха Британи
      GD:Гренада
      GE:Гуьржийчоь
      GF:Французийн Гвиана
      GG:Гернси
      GH:Гана
      GI:Гибралтар
      GL:Гренланди
      GM:Гамби
      GN:Гвиней
      GP:Гваделупа
      GQ:Экваторан Гвиней
      GR:Греци
      GS:Къилба Джорджи а, Къилба Гавайн гӀайренаш а
      GT:Гватемала
      GU:Гуам
      GW:Гвиней-Бисау
      GY:Гайана
      HK:Гонконг (ша-къаьстина кӀошт)
      HM:Херд гӀайре а, Макдональд гӀайренаш а
      HN:Гондурас
      HR:Хорвати
      HT:Гаити
      HU:Венгри
      IC:Канаран гӀайренаш
      ID:Индонези
      IE:Ирланди
      IL:Израиль
      IM:Мэн гӀайре
      IN:ХӀинди
      IQ:Ӏиракъ
      IR:ГӀажарийчоь
      IS:Исланди
      IT:Итали
      JE:Джерси
      JM:Ямайка
      JO:Урдан
      JP:Япони
      KE:Кени
      KG:Киргизи
      KH:Камбоджа
      KI:Кирибати
      KM:Комораш
      KN:Сент-Китс а, Невис а
      KP:Къилбаседа Корей
      KR:Къилба Корей
      KW:Кувейт
      KY:Кайман гӀайренаш
      KZ:Кхазакхстан
      LA:Лаос
      LB:Ливан
      LC:Сент-Люси
      LI:Лихтенштейн
      LK:Шри-Ланка
      LR:Либери
      LS:Лесото
      LT:Литва
      LU:Люксембург
      LV:Латви
      LY:Ливи
      MA:Марокко
      MC:Монако
      MD:Молдави
      ME:Ӏаьржаламанчоь
      MF:Сен-Мартен
      MG:Мадагаскар
      MH:Маршаллан гӀайренаш
      ML:Мали
      MM:Мьянма (Бирма)
      MN:Монголи
      MO:Макао (ша-къаьстина кӀошт)
      MP:Къилбаседа Марианан гӀайренаш
      MQ:Мартиника
      MR:Мавритани
      MS:Монтсеррат
      MT:Мальта
      MU:Маврики
      MV:Мальдиваш
      MW:Малави
      MX:Мексика
      MY:Малайзи
      MZ:Мозамбик
      NA:Намиби
      NC:Керла Каледони
      NE:Нигер
      NF:Норфолк гӀайре
      NG:Нигери
      NI:Никарагуа
      NL:Нидерландаш
      NO:Норвеги
      NP:Непал
      NR:Науру
      NU:Ниуэ
      NZ:Керла Зеланди
      OM:Ӏоман
      PA:Панама
      PE:Перу
      PF:Французийн Полинези
      PG:Папуа — Керла Гвиней
      PH:Филиппинаш
      PK:Пакистан
      PL:Польша
      PM:Сен-Пьер а, Микелон а
      PN:Питкэрн гӀайренаш
      PR:Пуэрто-Рико
      PS:ПалестӀинан латтанаш
      PT:Португали
      PW:Палау
      PY:Парагвай
      QA:Катар
      QO:Арахьара Океани
      RE:Реюньон
      RO:Румыни
      RS:Серби
      RU:Росси
      RW:Руанда
      SA:СаӀудийн Ӏаьрбийчоь
      SB:Соломонан гӀайренаш
      SC:Сейшелан гӀайренаш
      SD:Судан
      SE:Швеци
      SG:Сингапур
      SH:Сийлахьчу Еленин гӀайре
      SI:Словени
      SJ:Шпицберген а, Ян-Майен а
      SK:Словаки
      SL:Сьерра- Леоне
      SM:Сан-Марино
      SN:Сенегал
      SO:Сомали
      SR:Суринам
      SS:Къилба Судан
      ST:Сан-Томе а, Принсипи а
      SV:Сальвадор
      SX:Синт-Мартен
      SY:Шема
      SZ:Свазиленд
      TA:Тристан-да- Кунья
      TC:Тёркс а, Кайкос а гӀайренаш
      TD:Чад
      TF:Французийн къилба латтанаш
      TG:Того
      TH:Таиланд
      TJ:Таджикистан
      TK:Токелау
      TL:Малхбален Тимор
      TM:Туркмени
      TN:Тунис
      TO:Тонга
      TR:Туркойчоь
      TT:Тринидад а, Тобаго а
      TV:Тувалу
      TW:Тайвань
      TZ:Танзани
      UA:Украина
      UG:Уганда
      UM:АЦШн арахьара кегийн гӀайренаш
      UN:Вовшахкхетта Къаьмнийн Организаци
      US:Цхьанатоьхна Штаташ
      UY:Уругвай
      UZ:Узбекистан
      VA:Ватикан
      VC:Сент-Винсент а, Гренадинаш а
      VE:Венесуэла
      VG:Виргинийн гӀайренаш (Британи)
      VI:Виргинийн гӀайренаш (АЦШ)
      VN:Вьетнам
      VU:Вануату
      WF:Уоллис а, Футуна а
      WS:Самоа
      XK:Косово
      YE:Йемен
      YT:Майотта
      ZA:Къилба-Африкин Республика
      ZM:Замби
      ZW:Зимбабве
      ZZ:Йоьвзуш йоцу регион
      """.trimIndent() }

  val ceb: String by lazy { """
      001:kalibutan
      002:Africa
      003:North America
      005:South America
      009:Oceania
      011:Western Africa
      013:Central America
      014:Eastern Africa
      015:Northern Africa
      017:Middle Africa
      018:Southern Africa
      019:Americas
      021:Northern America
      029:Caribbean
      030:Eastern Asia
      034:Southern Asia
      035:Southeast Asia
      039:Southern Europe
      053:Australasia
      054:Melanesia
      057:Micronesian Region
      061:Polynesia
      142:Asia
      143:Central Asia
      145:Western Asia
      150:Europe
      151:Eastern Europe
      154:Northern Europe
      155:Western Europe
      202:Sub-Saharan Africa
      419:Latin America
      AC:Ascension Island
      AD:Andorra
      AE:United Arab Emirates
      AF:Afghanistan
      AG:Antigua & Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarctica
      AR:Argentina
      AS:American Samoa
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Aland Islands
      AZ:Azerbaijan
      BA:Bosnia & Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgium
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:St. Barthelemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Caribbean Netherlands
      BR:Brazil
      BS:Bahamas
      BT:Bhutan
      BV:Bouvet Island
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Canada
      CC:Cocos (Keeling) Islands
      CD:Congo - Kinshasa
      CF:Central African Republic
      CG:Congo - Brazzaville
      CH:Switzerland
      CI:Cote d’Ivoire
      CK:Cook Islands
      CL:Chile
      CM:Cameroon
      CN:China
      CO:Colombia
      CP:Clipperton Island
      CR:Costa Rica
      CU:Cuba
      CV:Cape Verde
      CW:Curacao
      CX:Christmas Island
      CY:Cyprus
      CZ:Czechia
      DE:Germany
      DG:Diego Garcia
      DJ:Djibouti
      DK:Denmark
      DM:Dominica
      DO:Dominican Republic
      DZ:Algeria
      EA:Ceuta & Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egypt
      EH:Western Sahara
      ER:Eritrea
      ES:Espanya
      ET:Ethiopia
      EU:European Union
      EZ:Eurozone
      FI:Finland
      FJ:Fiji
      FK:Falkland Islands
      FM:Micronesia
      FO:Faroe Islands
      FR:France
      GA:Gabon
      GB:United Kingdom
      GD:Grenada
      GE:Georgia
      GF:French Guiana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Greenland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Equatorial Guinea
      GR:Greece
      GS:South Georgia & South Sandwich Islands
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hong Kong SAR China
      HM:Heard & McDonald Islands
      HN:Honduras
      HR:Croatia
      HT:Haiti
      HU:Hungary
      IC:Canary Islands
      ID:Indonesia
      IE:Ireland
      IL:Israel
      IM:Isle of Man
      IN:India
      IO:Teritoryo sa British Indian Ocean
      IQ:Iraq
      IR:Iran
      IS:Iceland
      IT:Italya
      JE:Jersey
      JM:Jamaica
      JO:Jordan
      JP:Japan
      KE:Kenya
      KG:Kyrgyzstan
      KH:Cambodia
      KI:Kiribati
      KM:Comoros
      KN:St. Kitts & Nevis
      KP:North Korea
      KR:South Korea
      KW:Kuwait
      KY:Cayman Islands
      KZ:Kazakhstan
      LA:Laos
      LB:Lebanon
      LC:St. Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lithuania
      LU:Luxembourg
      LV:Latvia
      LY:Libya
      MA:Morocco
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:St. Martin
      MG:Madagascar
      MH:Marshall Islands
      MK:North Macedonia
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Macao SAR China
      MP:Northern Mariana Islands
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldives
      MW:Malawi
      MX:Mexico
      MY:Malaysia
      MZ:Mozambique
      NA:Namibia
      NC:New Caledonia
      NE:Niger
      NF:Norfolk Island
      NG:Nigeria
      NI:Nicaragua
      NL:Netherlands
      NO:Norway
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:Oman
      PA:Panama
      PE:Peru
      PF:French Polynesia
      PG:Papua New Guinea
      PH:Pilipinas
      PK:Pakistan
      PL:Poland
      PM:St. Pierre & Miquelon
      PN:Pitcairn Islands
      PR:Puerto Rico
      PS:Palestinian Territories
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Outlying Oceania
      RE:Reunion
      RO:Romania
      RS:Serbia
      RU:Russia
      RW:Rwanda
      SA:Saudi Arabia
      SB:Solomon Islands
      SC:Seychelles
      SD:Sudan
      SE:Sweden
      SG:Singapore
      SH:St. Helena
      SI:Slovenia
      SJ:Svalbard & Jan Mayen
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:South Sudan
      ST:Sao Tome & Principe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks & Caicos Islands
      TD:Chad
      TF:French Southern Territories
      TG:Togo
      TH:Thailand
      TJ:Tajikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turkiye
      TT:Trinidad & Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraine
      UG:Uganda
      UM:U.S. Outlying Islands
      UN:Hiniusang Kanasoran
      US:Estados Unidos
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatican City
      VC:St. Vincent & Grenadines
      VE:Venezuela
      VG:British Virgin Islands
      VI:U.S. Virgin Islands
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis & Futuna
      WS:Samoa
      XA:Pseudo-Accents
      XB:Pseudo-Bidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:South Africa
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Wala Mailhing Rehiyon
      """.trimIndent() }

  val cgg: String by lazy { """
      AD:Andora
      AE:Amahanga ga Buharabu ageeteereine
      AF:Afuganistani
      AG:Angiguwa na Babuda
      AI:Angwira
      AL:Arubania
      AM:Arimeniya
      AO:Angora
      AR:Arigentina
      AS:Samowa ya Ameerika
      AT:Osituria
      AU:Ositureeriya
      AW:Aruba
      AZ:Azabagyani
      BA:Boziniya na Hezegovina
      BB:Babadosi
      BD:Bangaradeshi
      BE:Bubirigi
      BF:Bokina Faso
      BG:Burugariya
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Berimuda
      BN:Burunei
      BO:Boriiviya
      BR:Buraziiri
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Bararusi
      BZ:Berize
      CA:Kanada
      CD:Demokoratika Ripaaburika ya Kongo
      CF:Eihanga rya Rwagati ya Afirika
      CG:Kongo
      CH:Swisi
      CI:Aivore Kositi
      CK:Ebizinga bya Kuuku
      CL:Chile
      CM:Kameruuni
      CN:China
      CO:Korombiya
      CR:Kositarika
      CU:Cuba
      CV:Ebizinga bya Kepuvade
      CY:Saipurasi
      CZ:Ripaaburika ya Zeeki
      DE:Bugirimaani
      DJ:Gyibuti
      DK:Deenimaaka
      DM:Dominika
      DO:Ripaaburika ya Dominica
      DZ:Arigyeriya
      EC:Ikweda
      EE:Esitoniya
      EG:Misiri
      ER:Eriteriya
      ES:Sipeyini
      ET:Ethiyopiya
      FI:Bufini
      FJ:Figyi
      FK:Ebizinga bya Faakilanda
      FM:Mikironesiya
      FR:Bufaransa
      GA:Gabooni
      GB:Bungyereza
      GD:Gurenada
      GE:Gyogiya
      GF:Guyana ya Bufaransa
      GH:Gana
      GI:Giburaata
      GL:Guriinirandi
      GM:Gambiya
      GN:Gine
      GP:Gwaderupe
      GQ:Guni
      GR:Guriisi
      GT:Gwatemara
      GU:Gwamu
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasiya
      HT:Haiti
      HU:Hangare
      ID:Indoneeziya
      IE:Irerandi
      IL:Isirairi
      IN:Indiya
      IQ:Iraaka
      IR:Iraani
      IS:Aisilandi
      IT:Itare
      JM:Gyamaika
      JO:Yorudaani
      JP:Gyapaani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodiya
      KI:Kiribati
      KM:Koromo
      KN:Senti Kittis na Nevisi
      KP:Koreya Amatemba
      KR:Koreya Amashuuma
      KW:Kuweiti
      KY:Ebizinga bya Kayimani
      KZ:Kazakisitani
      LA:Layosi
      LB:Lebanoni
      LC:Senti Rusiya
      LI:Lishenteni
      LK:Siriranka
      LR:Liberiya
      LS:Lesotho
      LT:Lithuania
      LU:Lakizembaaga
      LV:Latviya
      LY:Libya
      MA:Morocco
      MC:Monaco
      MD:Moridova
      MG:Madagasika
      MH:Ebizinga bya Marshaa
      ML:Mari
      MM:Myanamar
      MN:Mongoria
      MP:Ebizinga by’amatemba ga Mariana
      MQ:Martinique
      MR:Mauriteeniya
      MS:Montserrati
      MT:Marita
      MU:Maurishiasi
      MV:Maridives
      MW:Marawi
      MX:Mexico
      MY:marayizia
      MZ:Mozambique
      NA:Namibiya
      NC:Niukaredonia
      NE:Naigya
      NF:Ekizinga Norifoko
      NG:Naigyeriya
      NI:Nikaragwa
      NL:Hoorandi
      NO:Noorwe
      NP:Nepo
      NR:Nauru
      NU:Niue
      NZ:Niuzirandi
      OM:Omaani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Bufaransa
      PG:Papua
      PH:Firipino
      PK:Pakisitaani
      PL:Poorandi
      PM:Senti Piyerre na Mikweron
      PN:Pitkaini
      PR:Pwetoriko
      PT:Pocugo
      PW:Palaawu
      PY:Paragwai
      QA:Kata
      RE:Riyuniyoni
      RO:Romaniya
      RU:Rrasha
      RW:Rwanda
      SA:Saudi Areebiya
      SB:Ebizinga bya Surimaani
      SC:Shesheresi
      SD:Sudani
      SE:Swideni
      SG:Singapo
      SH:Senti Herena
      SI:Sirovaaniya
      SK:Sirovaakiya
      SL:Sirra Riyooni
      SM:Samarino
      SN:Senego
      SO:Somaariya
      SR:Surinaamu
      ST:Sawo Tome na Purinsipo
      SV:Eri Salivado
      SY:Siriya
      SZ:Swazirandi
      TC:Ebizinga bya Buturuki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tairandi
      TJ:Tajikisitani
      TK:Tokerawu
      TL:Burugweizooba bwa Timori
      TM:Turukimenisitani
      TN:Tunizia
      TO:Tonga
      TR:Buturuki /Take
      TT:Turinidad na Tobago
      TV:Tuvaru
      TW:Tayiwaani
      TZ:Tanzania
      UA:Ukureini
      UG:Uganda
      US:Amerika
      UY:Urugwai
      UZ:Uzibekisitani
      VA:Vatikani
      VC:Senti Vinsent na Gurenadini
      VE:Venezuwera
      VG:Ebizinga bya Virigini ebya Bungyereza
      VI:Ebizinga bya Virigini ebya Amerika
      VN:Viyetinaamu
      VU:Vanuatu
      WF:Warris na Futuna
      WS:Samowa
      YE:Yemeni
      YT:Mayote
      ZA:Sausi Afirika
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val cho: String by lazy { """
      US:United States
      """.trimIndent() }

  val chr: String by lazy { """
      001:ᎡᎶᎯ
      002:ᎬᎿᎨᏍᏛ
      003:ᏧᏴᏢ ᎠᎹᏰᏟ
      005:ᏧᎦᏃᏮ ᎠᎺᎵᎦ
      009:ᎣᏏᏰᏂᎠ
      011:ᏭᏕᎵᎬ ᏗᏜ ᎬᎿᎨᏍᏛ
      013:ᎠᏰᏟ ᎠᎹᏰᏟ
      014:ᏗᎧᎸᎬ ᏗᏜ ᎬᎿᎨᏍᏛ
      015:ᏧᏴᏢ ᏗᏜ ᎬᎿᎨᏍᏛ
      017:ᎠᏰᏟ ᎬᎿᎨᏍᏛ
      018:ᏧᎦᎾᏮ ᏗᏜ ᎬᎿᎨᏍᏛ
      019:ᎠᎺᎵᎦᎢ
      021:ᏧᏴᏢ ᏗᏜ ᎠᎹᏰᏟ
      029:ᎨᏆᏙᏯ
      030:ᏗᎧᎸᎬ ᏗᏜ ᏓᎶᏂᎨᏍᏛ
      034:ᏧᎦᎾᏮ ᏗᏜ ᏓᎶᏂᎨᏍᏛ
      035:ᏧᎦᎾᏮ ᏗᎧᎸᎬ ᏓᎶᏂᎨᏍᏛ
      039:ᏧᎦᎾᏮ ᏗᏜ ᏳᎳᏛ
      053:ᎠᏍᏔᎴᏏᎠ
      054:ᎺᎳᏁᏏᎠ
      057:ᎠᏰᏟ ᏧᎾᎵᎪᎯ ᎾᎿ ᎹᎢᏉᏂᏏᏯ ᎢᎬᎾᏕᎾ
      061:ᏆᎵᏂᏏᎠ
      142:ᏓᎶᎾᎨᏍᏛ
      143:ᎠᏰᏟ ᏓᎶᏂᎨᏍᏛ
      145:ᏭᏕᎵᎬ ᏗᏜ ᏓᎶᏂᎨᏍᏛ
      150:ᏳᎳᏛ
      151:ᏗᎧᎸᎬ ᏗᏜ ᏳᎳᏛ
      154:ᏧᏴᏢ ᏗᏜ ᏳᎳᏛ
      155:ᏭᏕᎵᎬ ᏗᏜ ᏳᎳᏛ
      202:ᎭᏫᏂ-ᏌᎭᏩ ᎬᎿᎨᏍᏛ
      419:ᎳᏘᏂ ᎠᎹᏰᏟ
      AC:ᎤᎵᏌᎳᏓᏅ ᎤᎦᏚᏛᎢ
      AD:ᎠᏂᏙᎳ
      AE:ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎡᎳᏈ ᎢᎹᎵᏘᏏ
      AF:ᎠᏫᎨᏂᏍᏖᏂ
      AG:ᎤᏪᏘ & ᏆᏊᏓ
      AI:ᎠᏂᎩᎳ
      AL:ᎠᎵᏇᏂᏯ
      AM:ᎠᎵᎻᏂᎠ
      AO:ᎠᏂᎪᎳ
      AQ:ᏧᏁᏍᏓᎸ
      AR:ᎠᏥᏂᏘᏂᎠ
      AS:ᎠᎺᎵᎧ ᏌᎼᎠ
      AT:ᎠᏍᏟᏯ
      AU:ᎡᎳᏗᏜ
      AW:ᎠᎷᏆ
      AX:ᎣᎴᏅᏓ ᏚᎦᏚᏛᎢ
      AZ:ᎠᏎᏆᏣᏂ
      BA:ᏉᏏᏂᎠ & ᎲᏤᎪᏫᎾ
      BB:ᏆᏇᏙᏍ
      BD:ᏆᏂᎦᎵᏕᏍ
      BE:ᏇᎵᏥᎥᎻ
      BF:ᏋᎩᎾ ᏩᏐ
      BG:ᏊᎵᎨᎵᎠ
      BH:ᏆᎭᎴᎢᏂ
      BI:ᏋᎷᏂᏗ
      BJ:ᏆᏂᎢᏂ
      BL:ᎤᏓᏅᏘ ᏆᏕᎳᎻ
      BM:ᏆᏊᏓ
      BN:ᏊᎾᎢ
      BO:ᏉᎵᏫᎠ
      BQ:ᎧᎵᏈᎢᏂᎯ ᎾᏍᎩᏁᏛᎳᏂ
      BR:ᏆᏏᎵ
      BS:ᎾᏍᎩ ᏆᎭᎹᏍ
      BT:ᏊᏔᏂ
      BV:ᏊᏪ ᎤᎦᏚᏛᎢ
      BW:ᏆᏣᏩᎾ
      BY:ᏇᎳᎷᏍ
      BZ:ᏇᎵᏍ
      CA:ᎨᎾᏓ
      CC:ᎪᎪᏍ (ᎩᎵᏂ) ᏚᎦᏚᏛᎢ
      CD:ᎧᏂᎪ - ᎨᏂᏝᏌ
      CF:ᎬᎿᎨᏍᏛ ᎠᏰᏟ ᏍᎦᏚᎩ
      CG:ᎧᏂᎪ - ᏆᏌᏩᎵ
      CH:ᏍᏫᏍ
      CI:ᎢᏬᎵ ᎾᎿ ᎠᎹᏳᎶᏗ
      CK:ᎠᏓᏍᏓᏴᎲᏍᎩ ᏚᎦᏚᏛᎢ
      CL:ᏥᎵ
      CM:ᎧᎹᎷᏂ
      CN:ᏓᎶᏂᎨᏍᏛ
      CO:ᎪᎸᎻᏈᎢᎠ
      CP:ᎦᏂᏴᏔᏅᎣᏓᎸ ᎤᎦᏚᏛᎢ
      CR:ᎪᏍᏓ ᎵᎧ
      CU:ᎫᏆ
      CV:ᎢᎬᎾᏕᎾ ᎢᏤᏳᏍᏗ
      CW:ᎫᎳᎨᎣ
      CX:ᏓᏂᏍᏓᏲᎯᎲ ᎤᎦᏚᏛᎢ
      CY:ᏌᎢᏆᏍ
      CZ:ᏤᎩᎠ
      DE:ᎠᏂᏛᏥ
      DG:ᏗᏰᎪ ᎦᏏᏯ
      DJ:ᏥᏊᏗ
      DK:ᏗᏂᎹᎦ
      DM:ᏙᎻᏂᎧ
      DO:ᏙᎻᏂᎧᏂ ᏍᎦᏚᎩ
      DZ:ᎠᎵᏥᎵᏯ
      EA:ᏑᏔ ᎠᎴ ᎺᎵᏯ
      EC:ᎡᏆᏙᎵ
      EE:ᎡᏍᏙᏂᏯ
      EG:ᎢᏥᏈᎢ
      EH:ᏭᏕᎵᎬ ᏗᏜ ᏌᎮᎳ
      ER:ᎡᎵᏟᏯ
      ES:ᎠᏂᏍᏆᏂᏱ
      ET:ᎢᏗᎣᏈᎠ
      EU:ᏳᎳᏛ ᎠᏂᎤᎾᏓᏡᎬ
      EZ:ᏳᎶᎠᏍᏓᏅᏅ
      FI:ᏫᏂᎦᏙᎯ
      FJ:ᏫᏥ
      FK:ᏩᎩ ᏚᎦᏚᏛᎢ
      FM:ᎹᎢᏉᏂᏏᏯ
      FO:ᏪᎶ ᏚᎦᏚᏛᎢ
      FR:ᎦᎸᏥᏱ
      GA:ᎦᏉᏂ
      GB:ᎩᎵᏏᏲ
      GD:ᏋᎾᏓ
      GE:ᏣᎠᏥᎢ
      GF:ᎠᏂᎦᎸᏥ ᎩᎠ
      GG:ᎬᏂᏏ
      GH:ᎦᎠᎾ
      GI:ᏥᏆᎵᏓ
      GL:ᎢᏤᏍᏛᏱ
      GM:ᎦᎹᏈᎢᎠ
      GN:ᎩᎢᏂ
      GP:ᏩᏓᎷᏇ
      GQ:ᎡᏆᏙᎵᎠᎵ ᎩᎢᏂ
      GR:ᎪᎢᎯ
      GS:ᏧᎦᏃᏮ ᏣᎠᏥᎢ ᎠᎴ ᎾᏍᎩ ᏧᎦᏃᏮ ᎠᏍᏛᎭᏟ ᏚᎦᏚᏛᎢ
      GT:ᏩᏔᎹᎳ
      GU:ᏆᎻ
      GW:ᎩᎢᏂ-ᏈᏌᎤᏫ
      GY:ᎦᏯᎾ
      HK:ᎰᏂᎩ ᎪᏂᎩ ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ ᏓᎶᏂᎨᏍᏛ
      HM:ᎲᏗ ᎤᎦᏚᏛᎢ ᎠᎴ ᎺᎩᏓᎾᎵᏗ ᏚᎦᏚᏛᎢ
      HN:ᎭᏂᏚᎳᏍ
      HR:ᎧᎶᎡᏏᎠ
      HT:ᎮᎢᏘ
      HU:ᎲᏂᎦᎵ
      IC:ᏥᏍᏆ ᏚᎦᏚᏛᎢ
      ID:ᎢᏂᏙᏂᏍᏯ
      IE:ᎠᏲᎳᏂ
      IL:ᎢᏏᎵᏱ
      IM:ᎤᏍᏗ ᎤᎦᏚᏛᎢ ᎾᎿ ᎠᏍᎦᏯ
      IN:ᎢᏅᏗᎾ
      IO:ᏈᏗᏏ ᏴᏫᏯ ᎠᎺᏉ ᎢᎬᎾᏕᏅ
      IQ:ᎢᎳᎩ
      IR:ᎢᎴᏂ
      IS:ᏧᏁᏍᏓᎸᎯ
      IT:ᎢᏔᎵ
      JE:ᏨᎵᏏ
      JM:ᏣᎺᎢᎧ
      JO:ᏦᏓᏂ
      JP:ᏣᏩᏂᏏ
      KE:ᎨᏂᏯ
      KG:ᎩᎵᏣᎢᏍ
      KH:ᎧᎹᏉᏗᎠᏂ
      KI:ᎧᎵᏆᏘ
      KM:ᎪᎼᎳᏍ
      KN:ᎤᏓᏅᏘ ᎨᏘᏏ ᎠᎴ ᏁᏪᏏ
      KP:ᏧᏴᏢ ᎪᎵᎠ
      KR:ᏧᎦᏃᏮ ᎪᎵᎠ
      KW:ᎫᏪᎢᏘ
      KY:ᎨᎢᎹᏂ ᏚᎦᏚᏛᎢ
      KZ:ᎧᏎᎧᏍᏕᏂ
      LA:ᎴᎣᏍ
      LB:ᎴᏆᎾᏂ
      LC:ᎤᏓᏅᏘ ᎷᏏᏯ
      LI:ᎵᎦᏗᏂᏍᏓᏂ
      LK:ᏍᎵ ᎳᏂᎧ
      LR:ᎳᏈᎵᏯ
      LS:ᎴᏐᏙ
      LT:ᎵᏗᏪᏂᎠ
      LU:ᎸᎧᏎᏋᎩ
      LV:ᎳᏘᏫᎠ
      LY:ᎵᏈᏯ
      MA:ᎼᎶᎪ
      MC:ᎹᎾᎪ
      MD:ᎹᎵᏙᏫᎠ
      ME:ᎼᏂᏔᏁᎦᎶ
      MF:ᎤᏓᏅᏘ ᏡᏡ
      MG:ᎹᏓᎦᏍᎧᎵ
      MH:ᎹᏌᎵ ᏚᎦᏚᏛᎢ
      MK:ᏧᏴᏜ ᎹᏎᏙᏂᏯ
      ML:ᎹᎵ
      MM:ᎹᏯᎹᎵ (ᏇᎵᎹ)
      MN:ᎹᏂᎪᎵᎠ
      MO:ᎹᎧᎣ (ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ) ᏣᎢ
      MP:ᏧᏴᏢ ᏗᏜ ᎹᎵᎠᎾ ᏚᎦᏚᏛᎢ
      MQ:ᎹᏘᏂᎨ
      MR:ᎹᏘᎢᏯ
      MS:ᎹᏂᏘᏌᎳᏗ
      MT:ᎹᎵᏔ
      MU:ᎼᎵᏏᎥᏍ
      MV:ᎹᎵᏗᏫᏍ
      MW:ᎹᎳᏫ
      MX:ᎠᏂᏍᏆᏂ
      MY:ᎹᎴᏏᎢᎠ
      MZ:ᎼᏎᎻᏇᎩ
      NA:ᎾᎻᏈᎢᏯ
      NC:ᎢᏤ ᎧᎵᏙᏂᎠᏂ
      NE:ᎾᎢᏨ
      NF:ᏃᎵᏬᎵᎩ ᎤᎦᏚᏛᎢ
      NG:ᏂᏥᎵᏯ
      NI:ᏂᎧᎳᏆ
      NL:ᏁᏛᎳᏂ
      NO:ᏃᏪ
      NP:ᏁᏆᎵ
      NR:ᏃᎤᎷ
      NU:ᏂᏳ
      NZ:ᎢᏤ ᏏᎢᎴᏂᏗ
      OM:ᎣᎺᏂ
      PA:ᏆᎾᎹ
      PE:ᏇᎷ
      PF:ᎠᏂᎦᎸᏥ ᏆᎵᏂᏏᎠ
      PG:ᏆᏇ ᎢᏤ ᎩᎢᏂ
      PH:ᎠᏂᏈᎵᎩᏃ
      PK:ᏆᎩᏍᏖᏂ
      PL:ᏉᎳᏂ
      PM:ᎤᏓᏅᏘ ᏈᏰ ᎠᎴ ᎻᏇᎶᏂ
      PN:ᏈᎧᎵᏂ ᏚᎦᏚᏛᎢ
      PR:ᏇᎡᏙ ᎵᎢᎪ
      PS:ᏆᎴᏍᏗᏂᎠᏂ ᏄᎬᏫᏳᏌᏕᎩ
      PT:ᏉᏥᎦᎳ
      PW:ᏆᎴᎠᏫ
      PY:ᏆᎳᏇᎢᏯ
      QA:ᎧᏔᎵ
      QO:ᎠᏍᏛ ᎣᏏᏰᏂᎠ
      RE:ᎴᏳᏂᎠᏂ
      RO:ᎶᎹᏂᏯ
      RS:ᏒᏈᏯ
      RU:ᏲᏂᎢ
      RW:ᎶᏩᏂᏓ
      SA:ᏌᎤᏗ ᎡᎴᏈᎠ
      SB:ᏐᎶᎹᏂ ᏚᎦᏚᏛᎢ
      SC:ᏏᎡᏥᎵᏍ
      SD:ᏑᏕᏂ
      SE:ᏍᏫᏕᏂ
      SG:ᏏᏂᎦᏉᎵ
      SH:ᎤᏓᏅᏘ ᎮᎵᎾ
      SI:ᏍᎶᏫᏂᎠ
      SJ:ᏍᏩᎵᏆᎵᏗ ᎠᎴ ᏤᏂ ᎹᏰᏂ
      SK:ᏍᎶᏩᎩᎠ
      SL:ᏏᎡᎳ ᎴᎣᏂ
      SM:ᎤᏓᏅᏘ ᎹᎵᎢᏃ
      SN:ᏏᏂᎦᎵ
      SO:ᏐᎹᎵ
      SR:ᏒᎵᎾᎻ
      SS:ᏧᎦᎾᏮ ᏑᏕᏂ
      ST:ᏌᎣ ᏙᎺ ᎠᎴ ᏈᏂᏏᏇ
      SV:ᎡᎵᏌᎵᏆᏙᎵ
      SX:ᏏᏂᏘ ᎹᏘᏂ
      SY:ᏏᎵᎠ
      SZ:ᎡᏍᏩᏘᏂ
      TA:ᏟᏍᏛᏂ Ꮣ ᎫᎾᎭ
      TC:ᎠᏂᏛᎵᎩ ᎠᎴ ᎨᎢᎪ ᏚᎦᏚᏛᎢ
      TD:ᏣᏗ
      TF:ᎠᏂᎦᎸᏥ ᏧᎦᎾᏮ ᎦᏙᎯ ᎤᎵᏍᏛᎢ
      TG:ᏙᎪ
      TH:ᏔᏯᎴᏂ
      TJ:ᏔᏥᎩᏍᏕᏂ
      TK:ᏙᎨᎳᏭ
      TL:ᏘᎼᎵ-ᎴᏍᏖ
      TM:ᏛᎵᎩᎺᏂᏍᏔᏂ
      TN:ᏚᏂᏏᏍᎠ
      TO:ᏙᎾᎦ
      TR:ᎬᏃ
      TT:ᏟᏂᏕᏗ ᎠᎴ ᏙᏆᎪ
      TV:ᏚᏩᎷ
      TW:ᏔᎢᏩᏂ
      TZ:ᏖᏂᏏᏂᏯ
      UA:ᏳᎧᎴᏂ
      UG:ᏳᎦᏂᏓ
      UM:U.S. ᎠᏍᏛ ᏚᎦᏚᏛᎢ
      UN:ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎠᏰᎵ ᏚᎾᏙᏢᏒ
      US:ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ
      UY:ᏳᎷᏇ
      UZ:ᎤᏍᏇᎩᏍᏖᏂ
      VA:ᎠᏥᎳᏁᏠ ᎦᏚᎲ
      VC:ᎤᏓᏅᏘ ᏫᏂᏏᏂᏗ ᎠᎴ ᎾᏍᎩ ᏇᎾᏗᏁᏍ
      VE:ᏪᏁᏑᏪᎳ
      VG:ᏈᏗᏍ ᎠᏒᏂᎸ ᏂᎨᏒᎾ ᏚᎦᏚᏛᎢ
      VI:U.S. ᎠᏒᏂᎸ ᏂᎨᏒᎾ ᏚᎦᏚᏛᎢ
      VN:ᏫᎡᏘᎾᎻ
      VU:ᏩᏂᎤᏩᏚ
      WF:ᏩᎵᏍ ᎠᎴ ᏊᏚᎾ
      WS:ᏌᎼᎠ
      XA:ᏡᏙ-ᏄᏍᏛᎢᎥᎧᏁᎬᎢ
      XB:ᏡᏙ-ᏈᏗ
      XK:ᎪᏐᏉ
      YE:ᏰᎺᏂ
      YT:ᎺᏯᏖ
      ZA:ᏧᎦᎾᏮ ᎬᎿᎨᏍᏛ
      ZM:ᏌᎻᏈᏯ
      ZW:ᏏᎻᏆᏇ
      ZZ:ᏄᏬᎵᏍᏛᎾ ᎤᏔᏂᏗᎦᏙᎯ
      """.trimIndent() }

  val cic: String by lazy { """
      US:United States
      """.trimIndent() }

  val ckb: String by lazy { """
      001:جیهان
      002:ئەفریقا
      003:ئەمەریکای باکوور
      005:ئەمەریکای باشوور
      009:ئۆقیانووسیا
      011:ڕۆژاوای ئەفریقا
      013:ئەمریکای ناوەڕاست
      014:ڕۆژھەڵاتی ئەفریقا
      015:باکووری ئەفریقا
      017:ناوەڕاستی ئەفریقا
      018:باشووری ئەفریقا
      019:ئەمەریکای باکوور و باشوور
      021:ئەمریکای باکوور
      029:کاریبی
      030:ڕۆژهەڵاتی ئاسیا
      034:باشووری ئاسیا
      035:باشووری ڕۆژھەڵاتی ئاسیا
      039:باشووری ئەورووپا
      053:ئۆسترالیا
      054:میلانێزیا
      057:ناوچەی مایکرۆنیزیا
      061:پۆلینیزیا
      142:ئاسیا
      143:ناوەڕاستی ئاسیا
      145:ڕۆژاوای ئاسیا
      150:ئەورووپا
      151:ڕۆژهەڵاتی ئەورووپا
      154:باکووری ئەورووپا
      155:ڕۆژاوای ئەورووپا
      202:ئەفریقای ژێر سەحرا
      419:ئەمەریکای لاتین
      AC:دوورگەی ئاسینسیۆن
      AD:ئاندۆرا
      AE:میرنشینە یەکگرتووە عەرەبییەکان
      AF:ئەفغانستان
      AG:ئانتیگوا و باربودا
      AI:ئانگویلا
      AL:ئەڵبانیا
      AM:ئەرمەنستان
      AO:ئەنگۆلا
      AQ:ئانتارکتیکا
      AR:ئەرژەنتین
      AS:ساموای ئەمەریکایی
      AT:نەمسا
      AU:ئوسترالیا
      AW:ئارووبا
      AX:دوورگەکانی ئالاند
      AZ:ئازەربایجان
      BA:بۆسنیا و ھەرزەگۆڤینا
      BB:باربادۆس
      BD:بەنگلادیش
      BE:بەلژیک
      BF:بورکینافاسۆ
      BG:بولگاریا
      BH:بەحرەین
      BI:بوروندی
      BJ:بێنین
      BL:سەن بارتێلێمی
      BM:بێرموودا
      BN:بروونای
      BO:بۆلیڤیا
      BQ:دوورگە کاریبیەکانی هۆڵەندا
      BR:برازیل
      BS:بەھاما
      BT:بووتان
      BV:دوورگەی بووڤێ
      BW:بۆتسوانا
      BY:بیلاڕووس
      BZ:بەلیز
      CA:کەنەدا
      CC:دوورگەکانی کیلینگ
      CD:کۆنگۆ کینشاسا
      CF:کۆماری ئەفریقای ناوەڕاست
      CG:کۆنگۆ برازاڤیل
      CH:سویسڕا
      CI:کۆتدیڤوار
      CK:دوورگەکانی کوک
      CL:چیلی
      CM:کامیرۆن
      CN:چین
      CO:کۆلۆمبیا
      CP:دوورگەی کلیپێرتۆن
      CR:کۆستاریکا
      CU:کووبا
      CV:کەیپڤەرد
      CW:کوراچاو
      CX:دوورگەی کریسمس
      CY:قیبرس
      CZ:کۆماری چیک
      DE:ئەڵمانیا
      DG:دیەگۆ گارسیا
      DJ:جیبووتی
      DK:دانمارک
      DM:دۆمینیکا
      DO:کۆماری دۆمینیکا
      DZ:جەزایر
      EA:سێئووتا و مێلییا
      EC:ئیکوادۆر
      EE:ئیستۆنیا
      EG:میسر
      EH:سەحرای ڕۆژاوا
      ER:ئەریتریا
      ES:ئیسپانیا
      ET:ئەتیۆپیا
      EU:یەکێتیی ئەورووپا
      EZ:ناوچەی یۆرۆ
      FI:فینلاند
      FJ:فیجی
      FK:دوورگەکانی مالڤیناس (دوورگەکانی فاڵکلاند)
      FM:مایکرۆنیزیا
      FO:دوورگەکانی فارەو
      FR:فەڕەنسا
      GA:گابۆن
      GB:شانشینی یەکگرتوو
      GD:گرینادا
      GE:گورجستان
      GF:گیانای فەرەنسا
      GG:گێرنزی
      GH:غەنا
      GI:گیبرالتار
      GL:گرینلاند
      GM:گامبیا
      GN:گینێ
      GP:گوادێلۆپ
      GQ:گینێی ئیستوایی
      GR:یۆنان
      GS:دوورگەکانی جۆرجیا و ساندویچی باشوور
      GT:گواتیمالا
      GU:گوام
      GW:گینێ بیساو
      GY:گویانا
      HK:هۆنگ کۆنگ
      HM:دوورگەکانی هێرد و مەکدانڵد
      HN:ھۆندووراس
      HR:کرۆواتیا
      HT:ھایتی
      HU:هەنگاریا
      IC:دوورگەکانی کەناری
      ID:ئیندۆنیزیا
      IE:ئیرلەند
      IL:ئیسرائیل
      IM:دوورگەی مان
      IN:ھیندستان
      IQ:عێراق
      IR:ئێران
      IS:ئایسلەند
      IT:ئیتالیا
      JE:جێرسی
      JM:جامایکا
      JO:ئوردن
      JP:ژاپۆن
      KE:کینیا
      KG:کرگیزستان
      KH:کەمبۆدیا
      KI:کیریباس
      KM:دوورگەکانی کۆمۆر
      KN:سەن کیتس و نیڤیس
      KP:کۆریای باکوور
      KR:کۆریای باشوور
      KW:کوەیت
      KY:دوورگەکانی کایمان
      KZ:کازاخستان
      LA:لاوس
      LB:لوبنان
      LC:سەن لووسیا
      LI:لیختنشتاین
      LK:سریلانکا
      LR:لیبەریا
      LS:لەسۆتۆ
      LT:لیتوانایا
      LU:لوکسەمبورگ
      LV:لاتڤیا
      LY:لیبیا
      MA:مەغریب
      MC:مۆناکۆ
      MD:مۆلدۆڤا
      ME:مۆنتینیگرۆ
      MF:سەن مارتین
      MG:ماداگاسکار
      MH:دوورگەکانی مارشاڵ
      MK:مەکدۆنیای باکوور
      ML:مالی
      MM:میانمار
      MN:مەنگۆلیا
      MO:ماکائۆ
      MP:دوورگەکانی ماریانای باکوور
      MQ:مارتینیک
      MR:مۆریتانیا
      MS:مۆنتسێرات
      MT:ماڵتا
      MU:مووریتیووس
      MV:مالدیڤ
      MW:مالاوی
      MX:مەکسیک
      MY:مالیزیا
      MZ:مۆزامبیک
      NA:نامیبیا
      NC:نیووکالێدۆنیا
      NE:نیجەر
      NF:دوورگەی نۆرفۆڵک
      NG:نیجریا
      NI:نیکاراگوا
      NL:ھۆڵەندا
      NO:نۆرویژ
      NP:نیپال
      NR:نائوروو
      NU:نیووئی
      NZ:نیوزیلاند
      OM:عومان
      PA:پاناما
      PE:پێروو
      PF:پۆلینیسیای فەرەنسا
      PG:پاپوا گینێی نوێ
      PH:فلیپین
      PK:پاکستان
      PL:پۆڵەندا
      PM:سەن پیێر و میکێلۆن
      PN:دوورگەکانی پیتکەرن
      PR:پۆرتۆڕیکۆ
      PS:ناوچە فەلەستینیەکان
      PT:پورتوگال
      PW:پالاو
      PY:پاراگوای
      QA:قەتەر
      QO:دەرەوەی ئۆقیانووسیا
      RE:ڕییوونیەن
      RO:ڕۆمانیا
      RS:سربیا
      RU:ڕووسیا
      RW:ڕواندا
      SA:عەرەبستانی سەعوودی
      SB:دوورگەکانی سلێمان
      SC:سیشێل
      SD:سوودان
      SE:سوید
      SG:سینگاپور
      SH:سەن هێلێنا
      SI:سلۆڤێنیا
      SJ:سڤالبارد و یان مایەن
      SK:سلۆڤاکیا
      SL:سیەرالیۆن
      SM:سان مارینۆ
      SN:سێنێگاڵ
      SO:سۆمالیا
      SR:سورینام
      SS:سوودانی باشوور
      ST:ساوتۆمێ و پرینسیپی
      SV:ئێلسالڤادۆر
      SX:سینت مارتن
      SY:سووریا
      SZ:سوازیلاند
      TA:تریستێن دا کوونا
      TC:دوورگەکانی تورکس و کایکۆس
      TD:چاد
      TF:هەرێمە باشووریەکانی فەرەنسا
      TG:تۆگۆ
      TH:تایلەند
      TJ:تاجیکستان
      TK:تۆکێلاو
      TL:تیمۆری ڕۆژھەڵات
      TM:تورکمانستان
      TN:توونس
      TO:تۆنگا
      TR:تورکیا
      TT:ترینیداد و تۆباگو
      TV:تووڤالوو
      TW:تایوان
      TZ:تانزانیا
      UA:ئۆکرانیا
      UG:ئوگاندا
      UM:دوورگەکانی دەرەوەی ئەمریکا
      UN:نەتەوە یەکگرتووەکان
      US:ویلایەتە یەکگرتووەکان
      UY:ئوروگوای
      UZ:ئوزبەکستان
      VA:ڤاتیکان
      VC:سەینت ڤینسەنت و گرینادینز
      VE:ڤەنزوێلا
      VG:دوورگەکانی ڤیرجنی بەریتانیا
      VI:دوورگەکانی ڤیرجنی ئەمەریکا
      VN:ڤیەتنام
      VU:ڤانوواتوو
      WF:والیس و فوتونا
      WS:ساموا
      XK:کۆسۆڤۆ
      YE:یەمەن
      YT:مایۆت
      ZA:ئەفریقای باشوور
      ZM:زامبیا
      ZW:زیمبابوی
      ZZ:ناوچەی نەناسراو
      """.trimIndent() }

  val ckb_IR: String? = null

  val cs: String by lazy { """
      001:svět
      002:Afrika
      003:Severní Amerika
      005:Jižní Amerika
      009:Oceánie
      011:západní Afrika
      013:Střední Amerika
      014:východní Afrika
      015:severní Afrika
      017:střední Afrika
      018:jižní Afrika
      019:Amerika
      021:Severní Amerika (oblast)
      029:Karibik
      030:východní Asie
      034:jižní Asie
      035:jihovýchodní Asie
      039:jižní Evropa
      053:Australasie
      054:Melanésie
      057:Mikronésie (region)
      061:Polynésie
      142:Asie
      143:Střední Asie
      145:západní Asie
      150:Evropa
      151:východní Evropa
      154:severní Evropa
      155:západní Evropa
      202:subsaharská Afrika
      419:Latinská Amerika
      AC:Ascension
      AD:Andorra
      AE:Spojené arabské emiráty
      AF:Afghánistán
      AG:Antigua a Barbuda
      AI:Anguilla
      AL:Albánie
      AM:Arménie
      AO:Angola
      AQ:Antarktida
      AR:Argentina
      AS:Americká Samoa
      AT:Rakousko
      AU:Austrálie
      AW:Aruba
      AX:Ålandy
      AZ:Ázerbájdžán
      BA:Bosna a Hercegovina
      BB:Barbados
      BD:Bangladéš
      BE:Belgie
      BF:Burkina Faso
      BG:Bulharsko
      BH:Bahrajn
      BI:Burundi
      BJ:Benin
      BL:Svatý Bartoloměj
      BM:Bermudy
      BN:Brunej
      BO:Bolívie
      BQ:Karibské Nizozemsko
      BR:Brazílie
      BS:Bahamy
      BT:Bhútán
      BV:Bouvetův ostrov
      BW:Botswana
      BY:Bělorusko
      BZ:Belize
      CA:Kanada
      CC:Kokosové ostrovy
      CD:Kongo – Kinshasa
      CF:Středoafrická republika
      CG:Kongo – Brazzaville
      CH:Švýcarsko
      CI:Pobřeží slonoviny
      CK:Cookovy ostrovy
      CL:Chile
      CM:Kamerun
      CN:Čína
      CO:Kolumbie
      CP:Clippertonův ostrov
      CR:Kostarika
      CU:Kuba
      CV:Kapverdy
      CW:Curaçao
      CX:Vánoční ostrov
      CY:Kypr
      CZ:Česko
      DE:Německo
      DG:Diego García
      DJ:Džibutsko
      DK:Dánsko
      DM:Dominika
      DO:Dominikánská republika
      DZ:Alžírsko
      EA:Ceuta a Melilla
      EC:Ekvádor
      EE:Estonsko
      EG:Egypt
      EH:Západní Sahara
      ER:Eritrea
      ES:Španělsko
      ET:Etiopie
      EU:Evropská unie
      EZ:eurozóna
      FI:Finsko
      FJ:Fidži
      FK:Falklandské ostrovy
      FM:Mikronésie
      FO:Faerské ostrovy
      FR:Francie
      GA:Gabon
      GB:Spojené království
      GD:Grenada
      GE:Gruzie
      GF:Francouzská Guyana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grónsko
      GM:Gambie
      GN:Guinea
      GP:Guadeloupe
      GQ:Rovníková Guinea
      GR:Řecko
      GS:Jižní Georgie a Jižní Sandwichovy ostrovy
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hongkong – ZAO Číny
      HM:Heardův ostrov a McDonaldovy ostrovy
      HN:Honduras
      HR:Chorvatsko
      HT:Haiti
      HU:Maďarsko
      IC:Kanárské ostrovy
      ID:Indonésie
      IE:Irsko
      IL:Izrael
      IM:Ostrov Man
      IN:Indie
      IO:Britské indickooceánské území
      IQ:Irák
      IR:Írán
      IS:Island
      IT:Itálie
      JE:Jersey
      JM:Jamajka
      JO:Jordánsko
      JP:Japonsko
      KE:Keňa
      KG:Kyrgyzstán
      KH:Kambodža
      KI:Kiribati
      KM:Komory
      KN:Svatý Kryštof a Nevis
      KP:Severní Korea
      KR:Jižní Korea
      KW:Kuvajt
      KY:Kajmanské ostrovy
      KZ:Kazachstán
      LA:Laos
      LB:Libanon
      LC:Svatá Lucie
      LI:Lichtenštejnsko
      LK:Srí Lanka
      LR:Libérie
      LS:Lesotho
      LT:Litva
      LU:Lucembursko
      LV:Lotyšsko
      LY:Libye
      MA:Maroko
      MC:Monako
      MD:Moldavsko
      ME:Černá Hora
      MF:Svatý Martin (Francie)
      MG:Madagaskar
      MH:Marshallovy ostrovy
      MK:Severní Makedonie
      ML:Mali
      MM:Myanmar (Barma)
      MN:Mongolsko
      MO:Macao – ZAO Číny
      MP:Severní Mariany
      MQ:Martinik
      MR:Mauritánie
      MS:Montserrat
      MT:Malta
      MU:Mauricius
      MV:Maledivy
      MW:Malawi
      MX:Mexiko
      MY:Malajsie
      MZ:Mosambik
      NA:Namibie
      NC:Nová Kaledonie
      NE:Niger
      NF:Norfolk
      NG:Nigérie
      NI:Nikaragua
      NL:Nizozemsko
      NO:Norsko
      NP:Nepál
      NR:Nauru
      NU:Niue
      NZ:Nový Zéland
      OM:Omán
      PA:Panama
      PE:Peru
      PF:Francouzská Polynésie
      PG:Papua-Nová Guinea
      PH:Filipíny
      PK:Pákistán
      PL:Polsko
      PM:Saint-Pierre a Miquelon
      PN:Pitcairnovy ostrovy
      PR:Portoriko
      PS:Palestinská území
      PT:Portugalsko
      PW:Palau
      PY:Paraguay
      QA:Katar
      QO:vnější Oceánie
      RE:Réunion
      RO:Rumunsko
      RS:Srbsko
      RU:Rusko
      RW:Rwanda
      SA:Saúdská Arábie
      SB:Šalamounovy ostrovy
      SC:Seychely
      SD:Súdán
      SE:Švédsko
      SG:Singapur
      SH:Svatá Helena
      SI:Slovinsko
      SJ:Špicberky a Jan Mayen
      SK:Slovensko
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somálsko
      SR:Surinam
      SS:Jižní Súdán
      ST:Svatý Tomáš a Princův ostrov
      SV:Salvador
      SX:Svatý Martin (Nizozemsko)
      SY:Sýrie
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks a Caicos
      TD:Čad
      TF:Francouzská jižní území
      TG:Togo
      TH:Thajsko
      TJ:Tádžikistán
      TK:Tokelau
      TL:Východní Timor
      TM:Turkmenistán
      TN:Tunisko
      TO:Tonga
      TR:Turecko
      TT:Trinidad a Tobago
      TV:Tuvalu
      TW:Tchaj-wan
      TZ:Tanzanie
      UA:Ukrajina
      UG:Uganda
      UM:Menší odlehlé ostrovy USA
      UN:Organizace spojených národů
      US:Spojené státy
      UY:Uruguay
      UZ:Uzbekistán
      VA:Vatikán
      VC:Svatý Vincenc a Grenadiny
      VE:Venezuela
      VG:Britské Panenské ostrovy
      VI:Americké Panenské ostrovy
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis a Futuna
      WS:Samoa
      XA:simulovaná diakritika
      XB:simulovaný obousměrný zápis
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Jihoafrická republika
      ZM:Zambie
      ZW:Zimbabwe
      ZZ:neznámá oblast
      """.trimIndent() }

  val csw: String by lazy { """
      001:ᐊᐢᑭᕀ
      003:ᒥᐦᑭᓇᕽ ᒥᓂᐢᑎᐠ
      005:ᓵᐘᓄᕽ ᒥᐦᑭᓇᕽ ᒥᓂᐢᑎᐠ
      013:ᐋᐱᐦᑕᐤ ᒥᐦᑭᓇᕽ ᒥᓂᐢᑎᐠ
      021:ᑮᐍᑎᓄᕽ ᒥᐦᑭᓇᕽ ᒥᓂᐢᑎᐠ
      CA:ᑳᓇᑕ
      EU:ᐊᑳᒪᐢᑮᔭ
      EZ:ᐊᑳᒪᐢᑮᕽ
      UN:ᒫᒫᐏ ᐊᐢᑮᔭ
      US:ᑭᐦᒋ ᒨᑯᒫᓂᕽ
      """.trimIndent() }

  val cv: String by lazy { """
      001:тӗнче
      002:Африка
      003:Ҫурҫӗр Америка
      005:Кӑнтӑр Америка
      009:Океани
      011:Анӑҫ Африка
      013:Тӗп Америка
      014:Хӗвелтухӑҫ Африка
      015:Ҫурҫӗр Африка
      017:Тӗп Африка
      018:Кӑнтӑр Африка
      019:Америка
      021:Ҫурҫӗр Америка регион
      029:Карибсем
      030:Хӗвелтухӑҫ Ази
      034:Кӑнтӑр Ази
      035:Кӑнтӑр хӗвелтухӑҫ Ази
      039:Кӑнтӑр Европа
      053:Австралази
      054:Меланези
      057:Микронези регион
      061:Полинези
      142:Ази
      143:Тӗп Ази
      145:Анӑҫ Ази
      150:Европа
      151:Хӗвелтухӑҫ Европа
      154:Ҫурҫӗр Европа
      155:Анӑҫ Европа
      202:Тропик Африка
      419:Латинла Америка
      AC:Вознесени утравӗ
      AD:Андорра
      AE:Арапсен Пӗрлешӳллӗ Эмирачӗ
      AF:Афганистан
      AG:Антигуа тата Барбуда
      AI:Ангилья
      AL:Албани
      AM:Армени
      AO:Ангола
      AQ:Антарктида
      AR:Аргентина
      AS:Америка Самоа
      AT:Австри
      AU:Австрали
      AW:Аруба
      AX:Аланди утравӗсем
      AZ:Азербайджан
      BA:Боснипе Герцеговина
      BB:Барбадос
      BD:Бангладеш
      BE:Бельги
      BF:Буркина-Фасо
      BG:Болгари
      BH:Бахрейн
      BI:Бурунди
      BJ:Бенин
      BL:Сен-Бартелеми
      BM:Бермуд утравӗсем
      BN:Бруней-Даруссалам
      BO:Боливи
      BQ:Бонэйр, Синт-Эстатиус тата Саба
      BR:Бразили
      BS:Пахам утравӗсем
      BT:Бутан
      BV:Буве утравӗ
      BW:Ботсвана
      BY:Беларуҫ
      BZ:Белиз
      CA:Канада
      CC:Кокос утравӗсем
      CD:Конго - Киншаса
      CF:Тӗп Африка Республики
      CG:Конго - Браззавиль
      CH:Швейцари
      CI:Кот-д’Ивуар
      CK:Кук утравӗсем
      CL:Чили
      CM:Камерун
      CN:Китай
      CO:Колумби
      CP:Клиппертон утравӗ
      CR:Коста-Рика
      CU:Куба
      CV:Кабо-Верде
      CW:Кюрасао
      CX:Раштав утравӗ
      CY:Кипр
      CZ:Чехи
      DE:Германи
      DG:Диего-Гарсия
      DJ:Джибути
      DK:Дани
      DM:Доминика
      DO:Доминикан Республики
      DZ:Алжир
      EA:Сеута тата Мелилья
      EC:Эквадор
      EE:Эстони
      EG:Египет
      EH:Анӑҫ Сахара
      ER:Эритрей
      ES:Испани
      ET:Эфиопи
      EU:Европа пӗрлешӗвӗ
      EZ:Еврозон
      FI:Финлянди
      FJ:Фиджи
      FK:Фолкленд утравӗсем
      FM:Микронези
      FO:Фарер утравӗсем
      FR:Франци
      GA:Габон
      GB:Аслӑ Британи
      GD:Гренада
      GE:Грузи
      GF:Франци Гвиана
      GG:Гернси
      GH:Гана
      GI:Гибралтар
      GL:Гренланди
      GM:Гамби
      GN:Гвиней
      GP:Гваделупа
      GQ:Экваториаллӑ Гвиней
      GR:Греци
      GS:Кӑнтӑр Георги тата Сандвичев утравӗсем
      GT:Гватемала
      GU:Гуам
      GW:Гвиней-Бисау
      GY:Гайана
      HK:Гонконг (САР)
      HM:Херд тата Макдональд утравӗ
      HN:Гондурас
      HR:Хорвати
      HT:Гаити
      HU:Венгри
      IC:Канар утравӗсем
      ID:Индонези
      IE:Ирланди
      IL:Израиль
      IM:Мэн утравӗ
      IN:Инди
      IQ:Ирак
      IR:Иран
      IS:Исланди
      IT:Итали
      JE:Джерси
      JM:Ямайка
      JO:Иордани
      JP:Япони
      KE:Кени
      KG:Киргизи
      KH:Камбоджа
      KI:Кирибати
      KM:Комор утравӗсем
      KN:Сент-Китс тата Невис
      KP:КХДР
      KR:Корей Республики
      KW:Кувейт
      KY:Кайман утравӗсем
      KZ:Казахстан
      LA:Лаос
      LB:Ливан
      LC:Сент-Люсия
      LI:Лихтенштейн
      LK:Шри-Ланка
      LR:Либери
      LS:Лесото
      LT:Литва
      LU:Люксембург
      LV:Латви
      LY:Ливи
      MA:Марокко
      MC:Монако
      MD:Молдова
      ME:Черногори
      MF:Сен-Мартен
      MG:Мадагаскар
      MH:Маршаллов утравӗсем
      MK:Ҫурҫӗр Македони
      ML:Мали
      MM:Мьянма (Бирма)
      MN:Монголи
      MO:Макао (САР)
      MP:Ҫурҫӗр Мариан утравӗсем
      MQ:Мартиника
      MR:Мавритани
      MS:Монтсеррат
      MT:Мальта
      MU:Маврики
      MV:Мальдивсем
      MW:Малави
      MX:Мексика
      MY:Малайзи
      MZ:Мозамбик
      NA:Намиби
      NC:Ҫӗнӗ Каледони
      NE:Нигер
      NF:Норфолк утравӗ
      NG:Нигери
      NI:Никарагуа
      NL:Нидерланд
      NO:Норвеги
      NP:Непал
      NR:Науру
      NU:Ниуэ
      NZ:Ҫӗнӗ Зеланди
      OM:Оман
      PA:Панама
      PE:Перу
      PF:Франци Полинези
      PG:Папуа — Ҫӗнӗ Гвиней
      PH:Филиппинсем
      PK:Пакистан
      PL:Польша
      PM:Сен-Пьер & Микелон
      PN:Питкэрн утравӗсем
      PR:Пуэрто-Рико
      PS:Палестинӑн территорийӗсем
      PT:Португали
      PW:Палау
      PY:Парагвай
      QA:Катар
      QO:Тулаш Океани
      RE:Реюньон
      RO:Румыни
      RS:Серби
      RU:Раҫҫей
      RW:Руанда
      SA:Сауд Аравийӗ
      SB:Соломон утравӗсем
      SC:Сейшел утравӗсем
      SD:Судан
      SE:Швеци
      SG:Сингапур
      SH:Сӑваплӑ Елена утравӗ
      SI:Словени
      SJ:Шпицберген тата Ян-Майен
      SK:Словаки
      SL:Сьерра-Леоне
      SM:Сан-Марино
      SN:Сенегал
      SO:Сомали
      SR:Суринам
      SS:Кӑнтӑр Судан
      ST:Сан-Томе тата Принсипи
      SV:Сальвадор
      SX:Синт-Мартен
      SY:Сири
      SZ:Эсватини
      TA:Тристан-да-Кунья
      TC:Тёркс тата Кайкос утравӗсем
      TD:Чад
      TF:Франци Кӑнтӑр территорийӗсем
      TG:Того
      TH:Таиланд
      TJ:Таджикистан
      TK:Токелау
      TL:Хӗвелтухӑҫ Тимор
      TM:Туркменистан
      TN:Тунис
      TO:Тонга
      TR:Турци
      TT:Тринидад тата Тобаго
      TV:Тувалу
      TW:Тайвань
      TZ:Танзани
      UA:Украина
      UG:Уганда
      UM:Тулашӗнчи утравӗсем (АПШ)
      UN:Пӗрлешӳллӗ Нацисен Организацийӗ
      US:Пӗрлешӗннӗ Штатсем
      UY:Уругвай
      UZ:Узбекистан
      VA:Ватикан
      VC:Сент-Винсент тата Гренадины
      VE:Венесуэла
      VG:Британин Виргини утравӗсем
      VI:Виргини утравӗсем (АПШ)
      VN:Вьетнам
      VU:Вануату
      WF:Уоллис тата Футуна
      WS:Самоа
      XA:псевдакцентсем
      XB:псевд-Bidi
      XK:Косово
      YE:Йемен
      YT:Майотта
      ZA:Кӑнтӑр Африка Республики
      ZM:Замби
      ZW:Зимбабве
      ZZ:паллӑ мар регион
      """.trimIndent() }

  val cy: String by lazy { """
      001:Y Byd
      002:Affrica
      003:Gogledd America
      005:De America
      009:Oceania
      011:Gorllewin Affrica
      013:Canolbarth America
      014:Dwyrain Affrica
      015:Gogledd Affrica
      017:Canol Affrica
      018:Deheudir Affrica
      019:Yr Amerig
      021:America i’r Gogledd o Fecsico
      029:Y Caribî
      030:Dwyrain Asia
      034:De Asia
      035:De-Ddwyrain Asia
      039:De Ewrop
      053:Awstralasia
      054:Melanesia
      057:Rhanbarth Micronesia
      061:Polynesia
      142:Asia
      143:Canol Asia
      145:Gorllewin Asia
      150:Ewrop
      151:Dwyrain Ewrop
      154:Gogledd Ewrop
      155:Gorllewin Ewrop
      202:Affrica Is-Sahara
      419:America Ladin
      AC:Ynys Ascension
      AD:Andorra
      AE:Emiradau Arabaidd Unedig
      AF:Afghanistan
      AG:Antigua a Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarctica
      AR:Yr Ariannin
      AS:Samoa America
      AT:Awstria
      AU:Awstralia
      AW:Aruba
      AX:Ynysoedd Åland
      AZ:Aserbaijan
      BA:Bosnia a Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Gwlad Belg
      BF:Burkina Faso
      BG:Bwlgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Saint Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolifia
      BQ:Antilles yr Iseldiroedd
      BR:Brasil
      BS:Y Bahamas
      BT:Bhutan
      BV:Ynys Bouvet
      BW:Botswana
      BY:Belarws
      BZ:Belize
      CA:Canada
      CC:Ynysoedd Cocos (Keeling)
      CD:Y Congo - Kinshasa
      CF:Gweriniaeth Canolbarth Affrica
      CG:Y Congo - Brazzaville
      CH:Y Swistir
      CI:Côte d’Ivoire
      CK:Ynysoedd Cook
      CL:Chile
      CM:Camerŵn
      CN:Tsieina
      CO:Colombia
      CP:Ynys Clipperton
      CR:Costa Rica
      CU:Ciwba
      CV:Cabo Verde
      CW:Curaçao
      CX:Ynys y Nadolig
      CY:Cyprus
      CZ:Tsiecia
      DE:Yr Almaen
      DG:Diego Garcia
      DJ:Djibouti
      DK:Denmarc
      DM:Dominica
      DO:Gweriniaeth Dominica
      DZ:Algeria
      EA:Ceuta a Melilla
      EC:Ecuador
      EE:Estonia
      EG:Yr Aifft
      EH:Gorllewin Sahara
      ER:Eritrea
      ES:Sbaen
      ET:Ethiopia
      EU:Yr Undeb Ewropeaidd
      EZ:Ardal yr Ewro
      FI:Y Ffindir
      FJ:Fiji
      FK:Ynysoedd y Falkland/Malvinas
      FM:Micronesia
      FO:Ynysoedd Ffaro
      FR:Ffrainc
      GA:Gabon
      GB:Y Deyrnas Unedig
      GD:Grenada
      GE:Georgia
      GF:Guyane Ffrengig
      GG:Ynys y Garn
      GH:Ghana
      GI:Gibraltar
      GL:Yr Ynys Las
      GM:Gambia
      GN:Gini
      GP:Guadeloupe
      GQ:Gini Gyhydeddol
      GR:Gwlad Groeg
      GS:De Georgia ac Ynysoedd Sandwich y De
      GT:Guatemala
      GU:Guam
      GW:Guiné-Bissau
      GY:Guyana
      HK:Hong Kong SAR Tsieina
      HM:Ynys Heard ac Ynysoedd McDonald
      HN:Honduras
      HR:Croatia
      HT:Haiti
      HU:Hwngari
      IC:Yr Ynysoedd Dedwydd
      ID:Indonesia
      IE:Iwerddon
      IL:Israel
      IM:Ynys Manaw
      IN:India
      IO:Tiriogaeth Brydeinig Cefnfor India
      IQ:Irac
      IR:Iran
      IS:Gwlad yr Iâ
      IT:Yr Eidal
      JE:Jersey
      JM:Jamaica
      JO:Gwlad Iorddonen
      JP:Japan
      KE:Kenya
      KG:Kyrgyzstan
      KH:Cambodia
      KI:Kiribati
      KM:Comoros
      KN:Saint Kitts a Nevis
      KP:Gogledd Corea
      KR:De Corea
      KW:Kuwait
      KY:Ynysoedd Cayman
      KZ:Kazakhstan
      LA:Laos
      LB:Libanus
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lithwania
      LU:Lwcsembwrg
      LV:Latfia
      LY:Libya
      MA:Moroco
      MC:Monaco
      MD:Moldofa
      ME:Montenegro
      MF:Saint Martin
      MG:Madagascar
      MH:Ynysoedd Marshall
      MK:Gogledd Macedonia
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Macau SAR Tsieina
      MP:Ynysoedd Gogledd Mariana
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Y Maldives
      MW:Malawi
      MX:Mecsico
      MY:Malaysia
      MZ:Mozambique
      NA:Namibia
      NC:Caledonia Newydd
      NE:Niger
      NF:Ynys Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Yr Iseldiroedd
      NO:Norwy
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Seland Newydd
      OM:Oman
      PA:Panama
      PE:Periw
      PF:Polynesia Ffrengig
      PG:Papua Guinea Newydd
      PH:Y Philipinau
      PK:Pakistan
      PL:Gwlad Pwyl
      PM:Saint-Pierre-et-Miquelon
      PN:Ynysoedd Pitcairn
      PR:Puerto Rico
      PS:Tiriogaethau Palesteinaidd
      PT:Portiwgal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Oceania Bellennig
      RE:Réunion
      RO:Rwmania
      RS:Serbia
      RU:Rwsia
      RW:Rwanda
      SA:Saudi Arabia
      SB:Ynysoedd Solomon
      SC:Seychelles
      SD:Swdan
      SE:Sweden
      SG:Singapore
      SH:Saint Helena
      SI:Slofenia
      SJ:Svalbard a Jan Mayen
      SK:Slofacia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:De Swdan
      ST:São Tomé a Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Ynysoedd Turks a Caicos
      TD:Tsiad
      TF:Tiroedd Deheuol ac Antarctig Ffrainc
      TG:Togo
      TH:Gwlad Thai
      TJ:Tajicistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Tyrcmenistan
      TN:Tiwnisia
      TO:Tonga
      TR:Twrci
      TT:Trinidad a Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Wcráin
      UG:Uganda
      UM:Ynysoedd Pellennig UDA
      UN:Y Cenhedloedd Unedig
      US:Yr Unol Daleithiau
      UY:Uruguay
      UZ:Uzbekistan
      VA:Y Fatican
      VC:Saint Vincent a’r Grenadines
      VE:Venezuela
      VG:Ynysoedd Gwyryf Prydain
      VI:Ynysoedd Gwyryf yr Unol Daleithiau
      VN:Fietnam
      VU:Vanuatu
      WF:Wallis a Futuna
      WS:Samoa
      XA:Acenion Ffug
      XB:Bidi Ffug
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:De Affrica
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Rhanbarth Anhysbys
      """.trimIndent() }

  val da: String by lazy { """
      001:Verden
      002:Afrika
      003:Nordamerika
      005:Sydamerika
      009:Oceanien
      011:Vestafrika
      013:Mellemamerika
      014:Østafrika
      015:Nordafrika
      017:Centralafrika
      018:Det sydlige Afrika
      019:Nord-, Mellem- og Sydamerika
      021:Det nordlige Amerika
      029:Caribien
      030:Østasien
      034:Sydasien
      035:Sydøstasien
      039:Sydeuropa
      053:Australasien
      054:Melanesien
      057:Mikronesiske område
      061:Polynesien
      142:Asien
      143:Centralasien
      145:Vestasien
      150:Europa
      151:Østeuropa
      154:Nordeuropa
      155:Vesteuropa
      202:Subsaharisk Afrika
      419:Latinamerika
      AC:Ascensionøen
      AD:Andorra
      AE:De Forenede Arabiske Emirater
      AF:Afghanistan
      AG:Antigua og Barbuda
      AI:Anguilla
      AL:Albanien
      AM:Armenien
      AO:Angola
      AQ:Antarktis
      AR:Argentina
      AS:Amerikansk Samoa
      AT:Østrig
      AU:Australien
      AW:Aruba
      AX:Åland
      AZ:Aserbajdsjan
      BA:Bosnien-Hercegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgien
      BF:Burkina Faso
      BG:Bulgarien
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Saint Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:De tidligere Nederlandske Antiller
      BR:Brasilien
      BS:Bahamas
      BT:Bhutan
      BV:Bouvetøen
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Canada
      CC:Cocosøerne
      CD:Congo-Kinshasa
      CF:Den Centralafrikanske Republik
      CG:Congo-Brazzaville
      CH:Schweiz
      CI:Elfenbenskysten
      CK:Cookøerne
      CL:Chile
      CM:Cameroun
      CN:Kina
      CO:Colombia
      CP:Clippertonøen
      CR:Costa Rica
      CU:Cuba
      CV:Kap Verde
      CW:Curaçao
      CX:Juleøen
      CY:Cypern
      CZ:Tjekkiet
      DE:Tyskland
      DG:Diego Garcia
      DJ:Djibouti
      DK:Danmark
      DM:Dominica
      DO:Den Dominikanske Republik
      DZ:Algeriet
      EA:Ceuta og Melilla
      EC:Ecuador
      EE:Estland
      EG:Egypten
      EH:Vestsahara
      ER:Eritrea
      ES:Spanien
      ET:Etiopien
      EU:Den Europæiske Union
      EZ:eurozonen
      FI:Finland
      FJ:Fiji
      FK:Falklandsøerne
      FM:Mikronesien
      FO:Færøerne
      FR:Frankrig
      GA:Gabon
      GB:Storbritannien
      GD:Grenada
      GE:Georgien
      GF:Fransk Guyana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grønland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Ækvatorialguinea
      GR:Grækenland
      GS:South Georgia og De Sydlige Sandwichøer
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:SAR Hongkong
      HM:Heard Island og McDonald Islands
      HN:Honduras
      HR:Kroatien
      HT:Haiti
      HU:Ungarn
      IC:Kanariske øer
      ID:Indonesien
      IE:Irland
      IL:Israel
      IM:Isle of Man
      IN:Indien
      IO:Det Britiske Territorium i Det Indiske Ocean
      IQ:Irak
      IR:Iran
      IS:Island
      IT:Italien
      JE:Jersey
      JM:Jamaica
      JO:Jordan
      JP:Japan
      KE:Kenya
      KG:Kirgisistan
      KH:Cambodja
      KI:Kiribati
      KM:Comorerne
      KN:Saint Kitts og Nevis
      KP:Nordkorea
      KR:Sydkorea
      KW:Kuwait
      KY:Caymanøerne
      KZ:Kasakhstan
      LA:Laos
      LB:Libanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Litauen
      LU:Luxembourg
      LV:Letland
      LY:Libyen
      MA:Marokko
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:Saint Martin
      MG:Madagaskar
      MH:Marshalløerne
      MK:Nordmakedonien
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongoliet
      MO:SAR Macao
      MP:Nordmarianerne
      MQ:Martinique
      MR:Mauretanien
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldiverne
      MW:Malawi
      MX:Mexico
      MY:Malaysia
      MZ:Mozambique
      NA:Namibia
      NC:Ny Kaledonien
      NE:Niger
      NF:Norfolk Island
      NG:Nigeria
      NI:Nicaragua
      NL:Nederlandene
      NO:Norge
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Fransk Polynesien
      PG:Papua Ny Guinea
      PH:Filippinerne
      PK:Pakistan
      PL:Polen
      PM:Saint Pierre og Miquelon
      PN:Pitcairn
      PR:Puerto Rico
      PS:De palæstinensiske områder
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Ydre Oceanien
      RE:Réunion
      RO:Rumænien
      RS:Serbien
      RU:Rusland
      RW:Rwanda
      SA:Saudi-Arabien
      SB:Salomonøerne
      SC:Seychellerne
      SD:Sudan
      SE:Sverige
      SG:Singapore
      SH:St. Helena
      SI:Slovenien
      SJ:Svalbard og Jan Mayen
      SK:Slovakiet
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Sydsudan
      ST:São Tomé og Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syrien
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks- og Caicosøerne
      TD:Tchad
      TF:De Franske Besiddelser i Det Sydlige Indiske Ocean og Antarktis
      TG:Togo
      TH:Thailand
      TJ:Tadsjikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunesien
      TO:Tonga
      TR:Tyrkiet
      TT:Trinidad og Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraine
      UG:Uganda
      UM:Amerikanske oversøiske øer
      UN:De Forenede Nationer
      US:USA
      UY:Uruguay
      UZ:Usbekistan
      VA:Vatikanstaten
      VC:Saint Vincent og Grenadinerne
      VE:Venezuela
      VG:De Britiske Jomfruøer
      VI:De Amerikanske Jomfruøer
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis og Futuna
      WS:Samoa
      XA:pseudo-accenter
      XB:pseudo-bidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:Sydafrika
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Ukendt område
      """.trimIndent() }

  val da_GL: String? = null

  val dav: String by lazy { """
      AD:Andora
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Marekani
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misri
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Ufaransa
      GA:Gaboni
      GB:Uingereza
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Rwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukraini
      UG:Uganda
      US:Marekani
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val de: String by lazy { """
      001:Welt
      002:Afrika
      003:Nordamerika
      005:Südamerika
      009:Ozeanien
      011:Westafrika
      013:Mittelamerika
      014:Ostafrika
      015:Nordafrika
      017:Zentralafrika
      018:Südliches Afrika
      019:Amerika
      021:Nördliches Amerika
      029:Karibik
      030:Ostasien
      034:Südasien
      035:Südostasien
      039:Südeuropa
      053:Australasien
      054:Melanesien
      057:Mikronesisches Inselgebiet
      061:Polynesien
      142:Asien
      143:Zentralasien
      145:Westasien
      150:Europa
      151:Osteuropa
      154:Nordeuropa
      155:Westeuropa
      202:Subsahara-Afrika
      419:Lateinamerika
      AC:Ascension
      AD:Andorra
      AE:Vereinigte Arabische Emirate
      AF:Afghanistan
      AG:Antigua und Barbuda
      AI:Anguilla
      AL:Albanien
      AM:Armenien
      AO:Angola
      AQ:Antarktis
      AR:Argentinien
      AS:Amerikanisch-Samoa
      AT:Österreich
      AU:Australien
      AW:Aruba
      AX:Ålandinseln
      AZ:Aserbaidschan
      BA:Bosnien und Herzegowina
      BB:Barbados
      BD:Bangladesch
      BE:Belgien
      BF:Burkina Faso
      BG:Bulgarien
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:St. Barthélemy
      BM:Bermuda
      BN:Brunei Darussalam
      BO:Bolivien
      BQ:Karibische Niederlande
      BR:Brasilien
      BS:Bahamas
      BT:Bhutan
      BV:Bouvetinsel
      BW:Botsuana
      BY:Belarus
      BZ:Belize
      CA:Kanada
      CC:Kokosinseln
      CD:Kongo-Kinshasa
      CF:Zentralafrikanische Republik
      CG:Kongo-Brazzaville
      CH:Schweiz
      CI:Côte d’Ivoire
      CK:Cookinseln
      CL:Chile
      CM:Kamerun
      CN:China
      CO:Kolumbien
      CP:Clipperton-Insel
      CR:Costa Rica
      CU:Kuba
      CV:Cabo Verde
      CW:Curaçao
      CX:Weihnachtsinsel
      CY:Zypern
      CZ:Tschechien
      DE:Deutschland
      DG:Diego Garcia
      DJ:Dschibuti
      DK:Dänemark
      DM:Dominica
      DO:Dominikanische Republik
      DZ:Algerien
      EA:Ceuta und Melilla
      EC:Ecuador
      EE:Estland
      EG:Ägypten
      EH:Westsahara
      ER:Eritrea
      ES:Spanien
      ET:Äthiopien
      EU:Europäische Union
      EZ:Eurozone
      FI:Finnland
      FJ:Fidschi
      FK:Falklandinseln
      FM:Mikronesien
      FO:Färöer
      FR:Frankreich
      GA:Gabun
      GB:Vereinigtes Königreich
      GD:Grenada
      GE:Georgien
      GF:Französisch-Guayana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grönland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Äquatorialguinea
      GR:Griechenland
      GS:Südgeorgien und die Südlichen Sandwichinseln
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Sonderverwaltungsregion Hongkong
      HM:Heard und McDonaldinseln
      HN:Honduras
      HR:Kroatien
      HT:Haiti
      HU:Ungarn
      IC:Kanarische Inseln
      ID:Indonesien
      IE:Irland
      IL:Israel
      IM:Isle of Man
      IN:Indien
      IO:Britisches Territorium im Indischen Ozean
      IQ:Irak
      IR:Iran
      IS:Island
      IT:Italien
      JE:Jersey
      JM:Jamaika
      JO:Jordanien
      JP:Japan
      KE:Kenia
      KG:Kirgisistan
      KH:Kambodscha
      KI:Kiribati
      KM:Komoren
      KN:St. Kitts und Nevis
      KP:Nordkorea
      KR:Südkorea
      KW:Kuwait
      KY:Kaimaninseln
      KZ:Kasachstan
      LA:Laos
      LB:Libanon
      LC:St. Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Litauen
      LU:Luxemburg
      LV:Lettland
      LY:Libyen
      MA:Marokko
      MC:Monaco
      MD:Republik Moldau
      ME:Montenegro
      MF:St. Martin
      MG:Madagaskar
      MH:Marshallinseln
      MK:Nordmazedonien
      ML:Mali
      MM:Myanmar
      MN:Mongolei
      MO:Sonderverwaltungsregion Macau
      MP:Nördliche Marianen
      MQ:Martinique
      MR:Mauretanien
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Malediven
      MW:Malawi
      MX:Mexiko
      MY:Malaysia
      MZ:Mosambik
      NA:Namibia
      NC:Neukaledonien
      NE:Niger
      NF:Norfolkinsel
      NG:Nigeria
      NI:Nicaragua
      NL:Niederlande
      NO:Norwegen
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Neuseeland
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Französisch-Polynesien
      PG:Papua-Neuguinea
      PH:Philippinen
      PK:Pakistan
      PL:Polen
      PM:St. Pierre und Miquelon
      PN:Pitcairninseln
      PR:Puerto Rico
      PS:Palästinensische Autonomiegebiete
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Katar
      QO:Äußeres Ozeanien
      RE:Réunion
      RO:Rumänien
      RS:Serbien
      RU:Russland
      RW:Ruanda
      SA:Saudi-Arabien
      SB:Salomonen
      SC:Seychellen
      SD:Sudan
      SE:Schweden
      SG:Singapur
      SH:St. Helena
      SI:Slowenien
      SJ:Spitzbergen und Jan Mayen
      SK:Slowakei
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:Südsudan
      ST:São Tomé und Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syrien
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks- und Caicosinseln
      TD:Tschad
      TF:Französische Süd- und Antarktisgebiete
      TG:Togo
      TH:Thailand
      TJ:Tadschikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunesien
      TO:Tonga
      TR:Türkei
      TT:Trinidad und Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansania
      UA:Ukraine
      UG:Uganda
      UM:Amerikanische Überseeinseln
      UN:Vereinte Nationen
      US:Vereinigte Staaten
      UY:Uruguay
      UZ:Usbekistan
      VA:Vatikanstadt
      VC:St. Vincent und die Grenadinen
      VE:Venezuela
      VG:Britische Jungferninseln
      VI:Amerikanische Jungferninseln
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis und Futuna
      WS:Samoa
      XA:Pseudo-Akzente
      XB:Pseudo-Bidi
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Südafrika
      ZM:Sambia
      ZW:Simbabwe
      ZZ:Unbekannte Region
      """.trimIndent() }

  val de_AT: String by lazy { """
      SJ:Svalbard und Jan Mayen
      """.trimIndent() }

  val de_BE: String? = null

  val de_CH: String by lazy { """
      BN:Brunei
      BW:Botswana
      CV:Kapverden
      QO:Äusseres Ozeanien
      SB:Salomon-Inseln
      TL:Osttimor
      ZW:Zimbabwe
      """.trimIndent() }

  val de_IT: String? = null

  val de_LI: String? = null

  val de_LU: String? = null

  val dje: String by lazy { """
      AD:Andoora
      AE:Laaraw Imaarawey Margantey
      AF:Afgaanistan
      AG:Antigua nda Barbuuda
      AI:Angiiya
      AL:Albaani
      AM:Armeeni
      AO:Angoola
      AR:Argentine
      AS:Ameriki Samoa
      AT:Otriši
      AU:Ostraali
      AW:Aruuba
      AZ:Azerbaayijaŋ
      BA:Bosni nda Herzegovine
      BB:Barbaados
      BD:Bangladeši
      BE:Belgiiki
      BF:Burkina faso
      BG:Bulgaari
      BH:Bahareen
      BI:Burundi
      BJ:Beniŋ
      BM:Bermuda
      BN:Bruunee
      BO:Boolivi
      BR:Breezil
      BS:Bahamas
      BT:Buutaŋ
      BW:Botswaana
      BY:Biloriši
      BZ:Beliizi
      CA:Kanaada
      CD:Kongoo demookaratiki laboo
      CF:Centraafriki koyra
      CG:Kongoo
      CH:Swisu
      CI:Kudwar
      CK:Kuuk gungey
      CL:Šiili
      CM:Kameruun
      CN:Šiin
      CO:Kolombi
      CR:Kosta rika
      CU:Kuuba
      CV:Kapuver gungey
      CY:Šiipur
      CZ:Cek labo
      DE:Almaaɲe
      DJ:Jibuuti
      DK:Danemark
      DO:Doominiki laboo
      DZ:Alžeeri
      EC:Ekwateer
      EE:Estooni
      EG:Misra
      ER:Eritree
      ES:Espaaɲe
      ET:Ecioopi
      FI:Finlandu
      FJ:Fiji
      FK:Kalkan gungey
      FM:Mikronezi
      FR:Faransi
      GA:Gaabon
      GB:Albaasalaama Marganta
      GD:Grenaada
      GE:Gorgi
      GF:Faransi Guyaan
      GH:Gaana
      GI:Gibraltar
      GL:Grinland
      GM:Gambi
      GN:Gine
      GP:Gwadeluup
      GQ:Ginee Ekwatorial
      GR:Greece
      GT:Gwatemaala
      GU:Guam
      GW:Gine-Bisso
      GY:Guyaane
      HN:Honduras
      HR:Krwaasi
      HT:Haiti
      HU:Hungaari
      ID:Indoneezi
      IE:Irlandu
      IL:Israyel
      IN:Indu laboo
      IQ:Iraak
      IR:Iraan
      IS:Ayseland
      IT:Itaali
      JM:Jamaayik
      JO:Urdun
      JP:Jaapoŋ
      KE:Keeniya
      KG:Kyrgyzstan
      KH:kamboogi
      KI:Kiribaati
      KM:Komoor
      KN:Seŋ Kitts nda Nevis
      KP:Gurma Kooree
      KR:Hawsa Kooree
      KW:Kuweet
      KY:Kayman gungey
      KZ:Kaazakstan
      LA:Laawos
      LB:Lubnaan
      LC:Seŋ Lussia
      LI:Liechtenstein
      LK:Srilanka
      LR:Liberia
      LS:Leesoto
      LT:Lituaani
      LU:Luxembourg
      LV:Letooni
      LY:Liibi
      MA:Maarok
      MC:Monako
      MD:Moldovi
      MG:Madagascar
      MH:Maršal gungey
      ML:Maali
      MM:Maynamar
      MN:Mongooli
      MP:Mariana Gurma Gungey
      MQ:Martiniiki
      MR:Mooritaani
      MS:Montserrat
      MT:Malta
      MU:Mooris gungey
      MV:Maldiivu
      MW:Malaawi
      MX:Mexiki
      MY:Maleezi
      MZ:Mozambik
      NA:Naamibi
      NC:Kaaledooni Taagaa
      NE:Nižer
      NF:Norfolk Gungoo
      NG:Naajiriia
      NI:Nikaragwa
      NL:Hollandu
      NO:Norveej
      NP:Neepal
      NR:Nauru
      NU:Niue
      NZ:Zeelandu Taaga
      OM:Omaan
      PA:Panama
      PE:Peeru
      PF:Faransi Polineezi
      PG:Papua Ginee Taaga
      PH:Filipine
      PK:Paakistan
      PL:Poloɲe
      PM:Seŋ Piyer nda Mikelon
      PN:Pitikarin
      PR:Porto Riko
      PS:Palestine Dangay nda Gaaza
      PT:Portugaal
      PW:Palu
      PY:Paraguwey
      QA:Kataar
      RE:Reenioŋ
      RO:Rumaani
      RU:Iriši laboo
      RW:Rwanda
      SA:Saudiya
      SB:Solomon Gungey
      SC:Seešel
      SD:Suudaŋ
      SE:Sweede
      SG:Singapur
      SH:Seŋ Helena
      SI:Sloveeni
      SK:Slovaaki
      SL:Seera Leon
      SM:San Marino
      SN:Senegal
      SO:Somaali
      SR:Surinaam
      ST:Sao Tome nda Prinsipe
      SV:Salvador laboo
      SY:Suuria
      SZ:Swaziland
      TC:Turk nda Kayikos Gungey
      TD:Caadu
      TG:Togo
      TH:Taayiland
      TJ:Taažikistan
      TK:Tokelau
      TL:Timoor hawsa
      TM:Turkmenistaŋ
      TN:Tunizi
      TO:Tonga
      TR:Turki
      TT:Trinidad nda Tobaago
      TV:Tuvalu
      TW:Taayiwan
      TZ:Tanzaani
      UA:Ukreen
      UG:Uganda
      US:Ameriki Laabu Margantey
      UY:Uruguwey
      UZ:Uzbeekistan
      VA:Vaatikan Laama
      VC:Seŋvinsaŋ nda Grenadine
      VE:Veneezuyeela
      VG:Britiši Virgin gungey
      VI:Ameerik Virgin Gungey
      VN:Vietnaam
      VU:Vanautu
      WF:Wallis nda Futuna
      WS:Samoa
      YE:Yaman
      YT:Mayooti
      ZA:Hawsa Afriki Laboo
      ZM:Zambi
      ZW:Zimbabwe
      """.trimIndent() }

  val doi: String by lazy { """
      BR:ब्राजील
      CN:चीन
      DE:जर्मनी
      FR:फ्रांस
      GB:यूनाइटेड किंगडम
      IN:भारत
      IT:इटली
      JP:जापान
      RU:रूस
      US:यूएस
      ZZ:अनजांता खेत्तर
      """.trimIndent() }

  val dsb: String by lazy { """
      001:swět
      002:Afrika
      003:Pódpołnocna Amerika
      005:Pódpołdnjowa Amerika
      009:Oceaniska
      011:Pódwjacorna Afrika
      013:Srjejźna Amerika
      014:pódzajtšna Afrika
      015:pódpołnocna Afrika
      017:srjejźna Afrika
      018:pódpołdnjowa Afrika
      019:Amerika
      021:pódpołnocny ameriski kontinent
      029:Karibiska
      030:pódzajtšna Azija
      034:pódpołdnjowa Azija
      035:krotkozajtšna Azija
      039:pódpołdnjowa Europa
      053:Awstralazija
      054:Melaneziska
      057:Mikroneziska (kupowy region)
      061:Polyneziska
      142:Azija
      143:centralna Azija
      145:pódwjacorna Azija
      150:Europa
      151:pódzajtšna Europa
      154:pódpołnocna Europa
      155:pódwjacorna Europa
      202:subsaharojska Afrika
      419:Łatyńska Amerika
      AC:Ascension
      AD:Andorra
      AE:Zjadnośone arabiske emiraty
      AF:Afghanistan
      AG:Antigua a Barbuda
      AI:Anguilla
      AL:Albańska
      AM:Armeńska
      AO:Angola
      AQ:Antarktis
      AR:Argentinska
      AS:Ameriska Samoa
      AT:Awstriska
      AU:Awstralska
      AW:Aruba
      AX:Åland
      AZ:Azerbajdžan
      BA:Bosniska a Hercegowina
      BB:Barbados
      BD:Bangladeš
      BE:Belgiska
      BF:Burkina Faso
      BG:Bulgarska
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:St. Barthélemy
      BM:Bermudy
      BN:Brunei
      BO:Boliwiska
      BQ:Karibiska Nižozemska
      BR:Brazilska
      BS:Bahamy
      BT:Bhutan
      BV:Bouvetowa kupa
      BW:Botswana
      BY:Běłoruska
      BZ:Belize
      CA:Kanada
      CC:Kokosowe kupy
      CD:Kongo-Kinshasa
      CF:Centralnoafriska republika
      CG:Kongo-Brazzaville
      CH:Šwicarska
      CI:Côte d’Ivoire
      CK:Cookowe kupy
      CL:Chilska
      CM:Kamerun
      CN:China
      CO:Kolumbiska
      CP:Clippertonowa kupa
      CR:Kosta Rika
      CU:Kuba
      CV:Kap Verde
      CW:Curaçao
      CX:Gódowne kupy
      CY:Cypriska
      CZ:Česka republika
      DE:Nimska
      DG:Diego Garcia
      DJ:Džibuti
      DK:Dańska
      DM:Dominika
      DO:Dominikańska republika
      DZ:Algeriska
      EA:Ceuta a Melilla
      EC:Ekwador
      EE:Estniska
      EG:Egyptojska
      EH:Pódwjacorna Sahara
      ER:Eritreja
      ES:Špańska
      ET:Etiopiska
      EU:Europska unija
      EZ:europasmo
      FI:Finska
      FJ:Fidži
      FK:Falklandske kupy
      FM:Mikroneziska
      FO:Färöje
      FR:Francojska
      GA:Gabun
      GB:Zjadnośone kralejstwo
      GD:Grenada
      GE:Georgiska
      GF:Francojska Guyana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grönlandska
      GM:Gambija
      GN:Gineja
      GP:Guadeloupe
      GQ:Ekwatorialna Gineja
      GR:Grichiska
      GS:Pódpołdnjowa Georgiska a Pódpołdnjowe Sandwichowe kupy
      GT:Guatemala
      GU:Guam
      GW:Gineja-Bissau
      GY:Guyana
      HK:Wósebna zastojnstwowa cona Hongkong
      HM:Heardowa kupa a McDonaldowe kupy
      HN:Honduras
      HR:Chorwatska
      HT:Haiti
      HU:Hungorska
      IC:Kanariske kupy
      ID:Indoneziska
      IE:Irska
      IL:Israel
      IM:Man
      IN:Indiska
      IO:Britiski indiskooceaniski teritorium
      IQ:Irak
      IR:Iran
      IS:Islandska
      IT:Italska
      JE:Jersey
      JM:Jamaika
      JO:Jordaniska
      JP:Japańska
      KE:Kenia
      KG:Kirgizistan
      KH:Kambodža
      KI:Kiribati
      KM:Komory
      KN:St. Kitts a Nevis
      KP:Pódpołnocna Koreja
      KR:Pódpołdnjowa Koreja
      KW:Kuwait
      KY:Kajmaniske kupy
      KZ:Kazachstan
      LA:Laos
      LB:Libanon
      LC:St. Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberija
      LS:Lesotho
      LT:Litawska
      LU:Luxemburgska
      LV:Letiska
      LY:Libyska
      MA:Marokko
      MC:Monaco
      MD:Moldawska
      ME:Carna Góra
      MF:St. Martin
      MG:Madagaskar
      MH:Marshallowe kupy
      MK:Pódpołnocna Makedańska
      ML:Mali
      MM:Myanmar
      MN:Mongolska
      MO:Wósebna zastojnstwowa cona Macao
      MP:Pódpołnocne Mariany
      MQ:Martinique
      MR:Mawretańska
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Malediwy
      MW:Malawi
      MX:Mexiko
      MY:Malajzija
      MZ:Mosambik
      NA:Namibija
      NC:Nowa Kaledoniska
      NE:Niger
      NF:Norfolkowa kupa
      NG:Nigerija
      NI:Nikaragua
      NL:Nižozemska
      NO:Norwegska
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nowoseelandska
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Francojska Polyneziska
      PG:Papua-Neuguinea
      PH:Filipiny
      PK:Pakistan
      PL:Pólska
      PM:St. Pierre a Miquelon
      PN:Pitcairnowe kupy
      PR:Puerto Rico
      PS:Palestinski awtonomny teritorium
      PT:Portugalska
      PW:Palau
      PY:Paraguay
      QA:Katar
      QO:wenkowna Oceaniska
      RE:Réunion
      RO:Rumuńska
      RS:Serbiska
      RU:Ruska
      RW:Ruanda
      SA:Saudi-Arabiska
      SB:Salomony
      SC:Seychelle
      SD:Sudan
      SE:Šwedska
      SG:Singapur
      SH:St. Helena
      SI:Słowjeńska
      SJ:Svalbard a Jan Mayen
      SK:Słowakska
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalija
      SR:Surinamska
      SS:Pódpołdnjowy Sudan
      ST:São Tomé a Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syriska
      SZ:Swasiska
      TA:Tristan da Cunha
      TC:Turks a Caicos kupy
      TD:Čad
      TF:Francojski pódpołdnjowy a antarktiski teritorium
      TG:Togo
      TH:Thailandska
      TJ:Tadźikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmeniska
      TN:Tuneziska
      TO:Tonga
      TR:Turkojska
      TT:Trinidad a Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansanija
      UA:Ukraina
      UG:Uganda
      UM:Ameriska Oceaniska
      UN:Zjadnośone narody
      US:Zjadnośone staty Ameriki
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatikańske město
      VC:St. Vincent a Grenadiny
      VE:Venezuela
      VG:Britiske kněžniske kupy
      VI:Ameriske kněžniske kupy
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis a Futuna
      WS:Samoa
      XA:pseudo-akcenty
      XB:pseudo-bidi
      XK:Kosowo
      YE:Jemen
      YT:Mayotte
      ZA:Pódpołdnjowa Afrika (Republika)
      ZM:Sambija
      ZW:Simbabwe
      ZZ:njeznaty region
      """.trimIndent() }

  val dua: String by lazy { """
      CM:Cameroun
      """.trimIndent() }

  val dyo: String by lazy { """
      AD:Andorra
      AF:Afganistan
      AG:Antigua di Barbuda
      AI:Angiiya
      AL:Albani
      AM:Armeni
      AO:Angola
      AR:Arsantin
      AS:Samoa yati Amerik
      AT:Otris
      AU:Ostraalia
      AW:Aruba
      AZ:Aserbaysan
      BA:Bosni di Hersegovin
      BB:Barbad
      BD:Banglades
      BE:Belsik
      BF:Burukiina Faso
      BG:Bulgari
      BH:Bahrayn
      BI:Burundi
      BJ:Bene
      BM:Bermud
      BN:Buruney
      BO:Boliivi
      BR:Bresil
      BS:Bahama
      BT:Butan
      BW:Boswana
      BY:Belarus
      BZ:Beliis
      CA:Kanada
      CD:Mofam demokratik mati Kongo
      CG:Kongo
      CI:Koddiwar
      CL:Cili
      CM:Kamerun
      CN:Siin
      CO:Kolombi
      CR:Kosta Rika
      CU:Kuba
      CV:Kap Ver
      CY:Siipr
      CZ:Mofam mati Cek
      DE:Almaañ
      DJ:Jibuti
      DK:Danmark
      DM:Dominika
      DO:Mofam mati Dominik
      DZ:Alseri
      EC:Ekuador
      EE:Estoni
      EG:Esípt
      ER:Eritree
      ES:Espaañ
      ET:Ecoopi
      FI:Finland
      FJ:Fiji
      FR:Frans
      GA:Gabon
      GD:Grenada
      GE:Seorsi
      GH:Gaana
      GI:Sipraltaar
      GL:Greenland
      GM:Gambi
      GN:Giné
      GP:Guwadalup
      GR:Gres
      GT:Guatemala
      GU:Guam
      GW:Giné Bisaau
      GY:Giyan
      HN:Onduras
      HR:Kroasi
      HT:Ayti
      HU:Oŋri
      ID:Endonesi
      IE:Irland
      IL:Israel
      IN:End
      IQ:Irak
      IR:Iran
      IS:Iisland
      IT:Itali
      JM:Samaik
      JP:Sapoŋ
      KE:Keniya
      KH:Kamboj
      KM:Komor
      LC:Saŋ Lusia
      LK:Siri Lanka
      LR:Liberia
      MG:Madagaskaar
      ML:Mali
      NF:Ecinkey yati Noorfok
      SA:Abari Saudi
      SD:Sudan
      SG:Singapur
      SI:Sloveni
      SK:Slovaki
      SL:Serra Leon
      SN:Senegal
      SO:Somali
      SV:Salvadoor
      TD:Cad
      TG:Togo
      TH:Tailand
      """.trimIndent() }

  val dz: String by lazy { """
      001:འཛམ་གླིང༌
      002:ཨཕ་རི་ཀ
      003:བྱང་ཨ་མི་རི་ཀ
      005:ལྷོ་ཨ་མི་རི་ཀ
      009:ཨོཤི་ཡཱན་ན
      011:ནུབ་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ
      013:བར་ཕྱོགས་ཨ་མི་རི་ཀ
      014:ཤར་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ
      015:བྱང་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ
      017:སྦུག་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ
      018:ལྷོའི་ཨཕ་རི་ཀ
      019:ཨ་མི་རི་ཀ་ཚུ
      021:བྱང་ཕྱོགས་ཀྱི་ཨ་མི་རི་ཀ
      029:ཀེ་རི་བི་ཡེན
      030:ཤར་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ
      034:ལྷོའི་ཨེ་ཤི་ཡ
      035:ལྷོ་ཤར་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ
      039:ལྷོའི་ཡུ་རོབ
      053:ཨཱོས་ཊྲེལ་ཨེ་ཤི་ཡ
      054:མེ་ལ་ནི་ཤི་ཡ
      057:ལུང་ཕྱོགས་མའི་ཀྲོ་ནི་ཤི་ཡ
      061:པོ་ལི་ནི་ཤི་ཡ
      142:ཨེ་ཤི་ཡ
      143:སྦུག་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ
      145:ནུབ་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ
      150:ཡུ་རོབ
      151:ཤར་ཕྱོགས་ཀྱི་ཡུ་རོབ
      154:བྱང་ཕྱོགས་ཀྱི་ཡུ་རོབ
      155:ནུབ་ཕྱོགས་ཀྱི་ཡུ་རོབ
      419:ལེ་ཊིནཨ་མི་རི་ཀ
      AC:ཨེ་སེན་ཤུན་ཚོ་གླིང༌
      AD:ཨཱན་དོ་ར
      AE:ཡུ་ནཱའི་ཊེཌ་ ཨ་རབ་ ཨེ་མེ་རེཊས
      AF:ཨཕ་གྷ་ནི་སཏཱན
      AG:ཨན་ཊི་གུ་ཝ་ ཨེནཌ་ བྷར་བྷུ་ཌ
      AI:ཨང་གི་ལ
      AL:ཨཱལ་བེ་ནི་ཡ
      AM:ཨར་མི་ནི་ཡ
      AO:ཨང་གྷོ་ལ
      AQ:འཛམ་གླིང་ལྷོ་མཐའི་ཁྱགས་གླིང
      AR:ཨར་ཇེན་ཊི་ན
      AS:ས་མོ་ཨ་ཡུ་ཨེས་ཨེ་མངའ་ཁོངས
      AT:ཨཱོས་ཊྲི་ཡ
      AU:ཨཱོས་ཊྲེལ་ལི་ཡ
      AW:ཨ་རུ་བཱ
      AX:ཨ་ལནཌ་གླིང་ཚོམ
      AZ:ཨ་ཛར་བྷའི་ཇཱན
      BA:བྷོས་ནི་ཡ་ ཨེནཌ་ ཧར་ཛི་གྷོ་བི་ན
      BB:བྷར་བེ་ཌོས
      BD:བངྒ་ལ་དེཤ
      BE:བྷེལ་ཇམ
      BF:བྷར་ཀི་ན་ ཕེ་སོ
      BG:བུལ་ག་རི་ཡ
      BH:བྷ་རེན
      BI:བྷུ་རུན་ཌི
      BJ:བྷེ་ནིན
      BL:སེནཊ་ བར་ཐོ་ལོམ་མིའུ
      BM:བར་མུ་ཌ
      BN:བྷྲུ་ནའི
      BO:བྷེ་ལི་བི་ཡ
      BQ:ཀེ་རི་བི་ཡེན་ནེ་དར་ལནཌས྄
      BR:བྲ་ཛིལ
      BS:བྷ་ཧ་མས྄
      BT:འབྲུག
      BV:བོའུ་ཝེཊ་མཚོ་གླིང
      BW:བྷོཙ་ཝ་ན
      BY:བེལ་ཨ་རུ་སུ
      BZ:བྷེ་ལིཛ
      CA:ཀེ་ན་ཌ
      CC:ཀོ་ཀོས་གླིང་ཚོམ
      CD:ཀོང་གྷོ ཀིན་ཤ་ས
      CF:སེན་ཊལ་ ཨཕ་རི་ཀཱན་ རི་པབ་ལིཀ
      CG:ཀོང་གྷོ བྷྲ་ཛ་བིལ
      CH:སུ་ཝིཊ་ཛར་ལེནཌ
      CI:ཀོ་ཊེ་ ཌི་ཨི་ཝོ་རེ
      CK:ཀུག་གླིང་ཚོམ
      CL:ཅི་ལི
      CM:ཀེ་མ་རུན
      CN:རྒྱ་ནག
      CO:ཀོ་ལོམ་བྷི་ཡ
      CP:ཀི་ལི་པེར་ཊོན་མཚོ་གླིང་
      CR:ཀོས་ཊ་རི་ཀ
      CU:ཀིའུ་བྷ
      CV:ཀེཔ་བཱཌ
      CW:ཀྱཱུར་ར་ཀོ
      CX:ཁི་རིསྟ་མེས་མཚོ་གླིང
      CY:སཱའི་པྲས
      CZ:ཅེཀ་ རི་པབ་ལིཀ
      DE:ཇཱར་མ་ནི
      DG:ཌི་ཡེ་གོ་གར་སིའོ
      DJ:ཇི་བྷུ་ཊི
      DK:ཌེན་མཱཀ
      DM:ཌོ་མི་ནི་ཀ
      DO:ཌོ་མི་ནི་ཀཱན་ རི་པབ་ལིཀ
      DZ:ཨཱལ་ཇི་རི་ཡ
      EA:སེ་ཨུ་ཏ་ ཨེནཌ་ མེལ་ལི་ལ
      EC:ཨེ་ཁྭ་ཌོར
      EE:ཨེས་ཊོ་ནི་ཡ
      EG:ཨི་ཇིབཊ
      EH:ནུབ་ཕྱོགས་ ས་ཧཱ་ར
      ER:ཨེ་རི་ཊྲེ་ཡ
      ES:ཨིས་པེན
      ET:ཨི་ཐི་ཡོ་པི་ཡ
      EU:ཡུ་རོབ་གཅིག་བསྡོམས་ཚོགས་པ
      FI:ཕིན་ལེནཌ
      FJ:ཕི་ཇི
      FK:ཕལྐ་ལནྜ་གླིང་ཚོམ
      FM:མའི་ཀྲོ་ནི་ཤི་ཡ
      FO:ཕཱའེ་རོ་གླིང་ཚོམ
      FR:ཕྲཱནས
      GA:གྷ་བྷོན
      GB:ཡུ་ནཱའི་ཊེཌ་ ཀིང་ཌམ
      GD:གྲྀ་ན་ཌ
      GE:ཇཽར་ཇཱ
      GF:གུའི་ཡ་ན་ ཕྲནས྄་མངའ་ཁོངས
      GG:གུ་ཨེརྣ་སི
      GH:གྷ་ན
      GI:ཇིབ་རཱལ་ཊར
      GL:གིརཱིན་ལནཌ྄
      GM:གྷེམ་བི་ཡ
      GN:གྷི་ནི
      GP:གོ་ཌེ་ལུ་པེ
      GQ:ཨེ་ཀུ་ཊོ་རེལ་ གི་ནི
      GR:གིརིས྄
      GS:སཱའུཐ་ཇཽར་ཇཱ་ དང་ སཱའུཐ་སེནཌ྄་ཝིཅ་གླིང་ཚོམ
      GT:གྷོ་ཊ་མ་ལ
      GU:གུ་འམ་ མཚོ་གླིང
      GW:གྷི་ནི་ བྷི་སཱའུ
      GY:གྷ་ཡ་ན
      HK:ཧོང་ཀོང་ཅཱའི་ན
      HM:ཧཱརཌ་མཚོ་གླིང་ དང་ མེཀ་ཌོ་ནལཌ྄་གླིང་ཚོམ
      HN:ཧཱན་ཌུ་རཱས྄
      HR:ཀྲོ་ཨེ་ཤ
      HT:ཧེ་ཊི
      HU:ཧཱང་གྷ་རི
      IC:ཀ་ནེ་རི་གླིང་ཚོམ
      ID:ཨིན་ཌོ་ནེ་ཤི་ཡ
      IE:ཨཱ་ཡ་ལེནཌ
      IL:ཨིས་ར་ཡེལ
      IM:ཨ་ཡུལ་ ཨོཕ་ མཱན
      IN:རྒྱ་གར
      IQ:ཨི་རཱཀ
      IR:ཨི་རཱན
      IS:ཨཱའིས་ལེནཌ
      IT:ཨི་ཊ་ལི
      JE:ཇེར་སི
      JM:ཇཱ་མཻ་ཀ
      JO:ཇོར་ཌན
      JP:ཇ་པཱན
      KE:ཀེན་ཡ
      KG:ཀིར་གིས་སཏཱན
      KH:ཀམ་བྷོ་ཌི་ཡ
      KI:ཀི་རི་བ་ཏི་མཚོ་གླིང
      KM:ཀོ་མོ་རོས
      KN:སེནཊ་ ཀིཊས་ དང་ ནེ་བིས
      KP:བྱང་ ཀོ་རི་ཡ
      KR:ལྷོ་ ཀོ་རི་ཡ
      KW:ཀུ་ཝེཊ
      KY:ཁེ་མེན་གླིང་ཚོམ
      KZ:ཀ་ཛགས་སཏཱན
      LA:ལཱ་ཝོས
      LB:ལེ་བ་ནོན
      LC:སེནཊ་ ལུ་སི་ཡ
      LI:ལིཀ་ཏནས་ཏ་ཡིན
      LK:ཤྲཱི་ལང་ཀ
      LR:ལཱའི་བེ་རི་ཡ
      LS:ལཻ་སོ་ཐོ
      LT:ལི་ཐུ་ཝེ་ནི་ཡ
      LU:ལག་ཛམ་བོརྒ
      LV:ལཊ་བི་ཡ
      LY:ལི་བི་ཡ
      MA:མོ་རོ་ཀོ
      MC:མོ་ན་ཀོ
      MD:མོལ་དོ་བཱ
      ME:མོན་ཊི་ནེག་རོ
      MF:སེནཊ་ མཱར་ཊིན
      MG:མ་དཱ་གེས་ཀར
      MH:མར་ཤེལ་གླིང་ཚོམ
      ML:མཱ་ལི
      MM:མི་ཡཱན་མར་ (བྷར་མ)
      MN:སོག་པོ་ཡུལ
      MO:མཀ་ཨའུ་ཅཱའི་ན
      MP:བྱང་ཕྱོགས་ཀྱི་མ་ར་ཡ་ན་གླིང་ཚོམ
      MQ:མཱར་ཊི་ནིཀ
      MR:མོ་རི་ཊེ་ནི་ཡ
      MS:མོན་ས་རཊ
      MT:མཱལ་ཊ
      MU:མོ་རི་ཤཱས
      MV:མཱལ་དིབས
      MW:མ་ལ་ཝི
      MX:མེཀ་སི་ཀོ
      MY:མ་ལེ་ཤི་ཡ
      MZ:མོ་ཛམ་བྷིཀ
      NA:ན་མི་བི་ཡ
      NC:ནིའུ་ཀ་ལི་དོ་ནི་ཡ
      NE:ནཱའི་ཇཱ
      NF:ནོར་ཕོལཀ་མཚོ་གླིང༌
      NG:ནཱའི་ཇི་རི་ཡ
      NI:ནི་ཀྲ་ཝ་ག
      NL:ནེ་དར་ལནཌས྄
      NO:ནོར་ཝེ
      NP:བལ་ཡུལ
      NR:ནའུ་རུ་
      NU:ནི་ཨུ་ཨཻ
      NZ:ནིའུ་ཛི་ལེནཌ
      OM:ཨོ་མཱན
      PA:པ་ན་མ
      PE:པེ་རུ
      PF:ཕྲཱནས྄་ཀྱི་པོ་ལི་ནི་ཤི་ཡ
      PG:པ་པུ་ ནིའུ་གི་ནི
      PH:ཕི་ལི་པིནས
      PK:པ་ཀི་སཏཱན
      PL:པོ་ལེནཌ
      PM:སིནཊ་པི་ཡེར་ ཨེནཌ་ མིཀོ་ལེན
      PN:པིཊ་ཀེ་ཡེརན་གླིང་ཚོམ
      PR:པུ་འེར་ཊོ་རི་ཁོ
      PS:པེ་ལིསི་ཊི་ནི་ཡན་ཊེ་རི་ཐོ་རི
      PT:པོར་ཅུ་གཱལ
      PW:པ་ལའུ
      PY:པ་ར་གུ་ཝའི
      QA:ཀ་ཊར
      QO:ཨོཤི་ཡཱན་ན་གྱི་མཐའ་མཚམས
      RE:རེ་ཡུ་ནི་ཡོན
      RO:རོ་མེ་ནི་ཡ
      RS:སཱར་བྷི་ཡ
      RU:ཨུ་རུ་སུ
      RW:རུ་ཝན་ཌ
      SA:སཱཝ་དི་ ཨ་རེ་བྷི་ཡ
      SB:སོ་ལོ་མོན་ གླིང་ཚོམ
      SC:སེ་ཤཱལས
      SD:སུ་ཌཱན
      SE:སུའི་ཌེན
      SG:སིང་ག་པོར
      SH:སེནཊ་ ཧེ་ལི་ན
      SI:སུ་ལོ་བི་ནི་ཡ
      SJ:སྭཱལ་བྷརྡ་ ཨེནཌ་ ཇཱན་མ་ཡེན
      SK:སུ་ལོ་བཱ་ཀི་ཡ
      SL:སི་ར་ ལི་འོན
      SM:སཱན་མ་རི་ནོ
      SN:སེ་ནི་གྷལ
      SO:སོ་མ་ལི་ཡ
      SR:སུ་རི་ནཱམ
      SS:སཱའུཐ་ སུ་ཌཱན
      ST:སཝ་ ཊོ་མེ་ ཨེནཌ་ པྲྀན་སི་པེ
      SV:ཨེལ་སལ་བ་ཌོར
      SX:སིནཊ་ མཱར་ཊེན
      SY:སི་རི་ཡ
      SZ:སུ་ཝ་ཛི་ལེནཌ
      TA:ཏྲིས་ཏན་ད་ཀུན་ཧ
      TC:ཏུརྐས྄་ ཨེནཌ་ ཀ་ཀོས་གླིང་ཚོམ
      TD:ཅཱཌ
      TF:ཕྲནཅ་གི་ལྷོ་ཕྱོགས་མངའ་ཁོངས
      TG:ཊོ་གྷོ
      TH:ཐཱའི་ལེནཌ
      TJ:ཏ་ཇིག་གི་སཏཱན
      TK:ཏོ་ཀེ་ལའུ་ མཚོ་གླིང
      TL:ཏི་་མོར་ལེ་ཨེསཊ
      TM:ཊཱརཀ་མེནའི་སཏཱན
      TN:ཊུ་ནི་ཤི་ཡ
      TO:ཊོང་གྷ
      TR:ཊཱར་ཀི
      TT:ཊི་ནི་ཌཱཌ་ ཨེནཌ་ ཊོ་བྷེ་གྷོ
      TV:ཏུ་ཝ་ལུ
      TW:ཊཱའི་ཝཱན
      TZ:ཊཱན་ཛཱ་ནི་ཡ
      UA:ཡུ་ཀརེན
      UG:ཡུ་གྷན་ཌ
      UM:ཡུ་ཨེས་གྱི་མཐའ་མཚམས་མཚོ་གླིང་
      US:ཡུ་ཨེས་ཨེ
      UY:ཡུ་རུ་གུ་ཝའི
      UZ:ཨུས་བེག་གི་སཏཱན
      VA:བ་ཊི་ཀཱན་ སི་ཊི
      VC:སེནཊ་ཝིན་སེནཌ྄ ཨེནཌ་ གི་རེ་ན་དིནས྄
      VE:བེ་ནི་ཛུ་ཝེ་ལ
      VG:ཝརཇིན་གླིང་ཚོམ་ བྲཱི་ཊིཤ་མངའ་ཁོངས
      VI:ཝརཇིན་གླིང་ཚོམ་ ཡུ་ཨེས་ཨེ་མངའ་ཁོངས
      VN:བེཊ་ནཱམ
      VU:ཝ་ནུ་ཨ་ཏུ
      WF:ཝལ་ལིས྄་ ཨེནཌ་ ཕུ་ཏུ་ན་
      WS:ས་མོ་ཨ
      YE:ཡེ་མེན
      YT:མེ་ཡོཊ
      ZA:སཱའུཐ་ ཨཕ་རི་ཀ
      ZM:ཛམ་བྷི་ཡ
      ZW:ཛིམ་བྷབ་ཝེ
      ZZ:ངོ་མ་ཤེས་པའི་ལུང་ཕྱོགས
      """.trimIndent() }

  val ebu: String by lazy { """
      AD:Andora
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Marekani
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misri
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Ufaransa
      GA:Gaboni
      GB:Uingereza
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Rwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukraini
      UG:Uganda
      US:Marekani
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val ee: String by lazy { """
      001:xexeme
      002:Afrika nutome
      003:Dziehe Amerika nutome
      005:Anyiehe Amerika nutome
      009:Oceania nutome
      011:Ɣetoɖoƒelɔƒo Afrika nutome
      013:Titina Amerika nutome
      014:Ɣedzeƒe Afrika nutome
      015:Dziehe Afrika nutome
      017:Titina Afrika nutome
      018:Anyiehelɔƒo Afrika nutome
      019:Amerika nutome
      021:Dziehelɔƒo Amerika nutome
      029:Karibbea nutome
      030:Ɣedzeƒe Asia nutome
      034:Anyiehelɔƒo Asia nutome
      035:Anyiehe Ɣedzeƒe Afrika nutome
      039:Anyiehelɔƒo Europa nutome
      053:Australia kple New Zealand nutome
      054:Melanesia nutome
      057:Mikronesia
      061:Pɔlinesia nutome
      142:Asia nutome
      143:Titina Asia nutome
      145:Ɣetoɖoƒelɔƒo Asia nutome
      150:Europa nutome
      151:Ɣedzeƒe Europa nutome
      154:Dziehelɔƒo Europa nutome
      155:Ɣetoɖoƒelɔƒo Europa nutome
      419:Latin Amerika nutome
      AC:Ascension ƒudomekpo nutome
      AD:Andorra nutome
      AE:United Arab Emirates nutome
      AF:Afghanistan nutome
      AG:́Antigua kple Barbuda nutome
      AI:Anguilla nutome
      AL:Albania nutome
      AM:Armenia nutome
      AO:Angola nutome
      AQ:Antartica nutome
      AR:Argentina nutome
      AS:Amerika Samoa nutome
      AT:Austria nutome
      AU:Australia nutome
      AW:Aruba nutome
      AX:Åland ƒudomekpo nutome
      AZ:Azerbaijan nutome
      BA:Bosnia kple Herzergovina nutome
      BB:Barbados nutome
      BD:Bangladesh nutome
      BE:Belgium nutome
      BF:Burkina Faso nutome
      BG:Bulgaria nutome
      BH:Bahrain nutome
      BI:Burundi nutome
      BJ:Benin nutome
      BL:Saint Barthélemy nutome
      BM:Bermuda nutome
      BN:Brunei nutome
      BO:Bolivia nutome
      BR:Brazil nutome
      BS:Bahamas nutome
      BT:Bhutan nutome
      BV:Bouvet ƒudomekpo nutome
      BW:Botswana nutome
      BY:Belarus nutome
      BZ:Belize nutome
      CA:Canada nutome
      CC:Kokos (Kiling) fudomekpo nutome
      CD:Kongo Kinshasa nutome
      CF:Titina Afrika repɔblik nutome
      CG:Kongo Brazzaville nutome
      CH:Switzerland nutome
      CI:Kote d’Ivoire nutome
      CK:Kook ƒudomekpo nutome
      CL:Tsile nutome
      CM:Kamerun nutome
      CN:Tsaina nutome
      CO:Kolombia nutome
      CP:Klipaton ƒudomekpo nutome
      CR:Kosta Rika nutome
      CU:Kuba nutome
      CV:Kape Verde nutome
      CX:Kristmas ƒudomekpo nutome
      CY:Saiprus nutome
      CZ:Tsɛk repɔblik nutome
      DE:Germania nutome
      DG:Diego Garsia nutome
      DJ:Dzibuti nutome
      DK:Denmark nutome
      DM:Dominika nutome
      DO:Dominika repɔblik nutome
      DZ:Algeria nutome
      EA:Keuta and Melilla nutome
      EC:Ekuadɔ nutome
      EE:Estonia nutome
      EG:Egypte nutome
      EH:Ɣetoɖoƒe Sahara nutome
      ER:Eritrea nutome
      ES:Spain nutome
      ET:Etiopia nutome
      EU:Europa Wɔɖeka nutome
      FI:Finland nutome
      FJ:Fidzi nutome
      FK:Falkland ƒudomekpowo nutome
      FM:Mikronesia nutome
      FO:Faroe ƒudomekpowo nutome
      FR:France nutome
      GA:Gabɔn nutome
      GB:United Kingdom nutome
      GD:Grenada nutome
      GE:Georgia nutome
      GF:Frentsi Gayana nutome
      GG:Guernse nutome
      GH:Ghana nutome
      GI:Gibraltar nutome
      GL:Grinland nutome
      GM:Gambia nutome
      GN:Guini nutome
      GP:Guadelupe nutome
      GQ:Ekuatorial Guini nutome
      GR:Greece nutome
      GS:Anyiehe Georgia kple Anyiehe Sandwich ƒudomekpowo nutome
      GT:Guatemala nutome
      GU:Guam nutome
      GW:Gini-Bisao nutome
      GY:Guyanadu
      HK:Hɔng Kɔng SAR Tsaina nutome
      HM:Heard kple Mcdonald ƒudomekpowo nutome
      HN:Hondurasdu
      HR:Kroatsia nutome
      HT:Haiti nutome
      HU:Hungari nutome
      IC:Kanari ƒudomekpowo nutome
      ID:Indonesia nutome
      IE:Ireland nutome
      IL:Israel nutome
      IM:Aisle of Man nutome
      IN:India nutome
      IQ:iraqdukɔ
      IR:Iran nutome
      IS:Aiseland nutome
      IT:Italia nutome
      JE:Dzɛse nutome
      JM:Dzamaika nutome
      JO:Yordan nutome
      JP:Dzapan nutome
      KE:Kenya nutome
      KG:Kirgizstan nutome
      KH:Kambodia nutome
      KI:Kiribati nutome
      KM:Komoros nutome
      KN:Saint Kitis kple Nevis nutome
      KP:Dziehe Korea nutome
      KR:Anyiehe Korea nutome
      KW:Kuwait nutome
      KY:Kayman ƒudomekpowo nutome
      KZ:Kazakstan nutome
      LA:Laos nutome
      LB:Lebanɔn nutome
      LC:Saint Lusia nutome
      LI:Litsenstein nutome
      LK:Sri Lanka nutome
      LR:Liberia nutome
      LS:Lɛsoto nutome
      LT:Lituania nutome
      LU:Lazembɔg nutome
      LV:Latvia nutome
      LY:Libya nutome
      MA:Moroko nutome
      MC:Monako nutome
      MD:Moldova nutome
      ME:Montenegro nutome
      MF:Saint Martin nutome
      MG:Madagaska nutome
      MH:Marshal ƒudomekpowo nutome
      ML:Mali nutome
      MM:Myanmar (Burma) nutome
      MN:Mongolia nutome
      MO:Macau SAR Tsaina nutome
      MP:Dziehe Marina ƒudomekpowo nutome
      MQ:Martiniki nutome
      MR:Mauritania nutome
      MS:Montserrat nutome
      MT:Malta nutome
      MU:mauritiusdukɔ
      MV:maldivesdukɔ
      MW:Malawi nutome
      MX:Mexico nutome
      MY:Malaysia nutome
      MZ:Mozambiki nutome
      NA:Namibia nutome
      NC:New Kaledonia nutome
      NE:Niger nutome
      NF:Norfolk ƒudomekpo nutome
      NG:Nigeria nutome
      NI:Nicaraguadukɔ
      NL:Netherlands nutome
      NO:Norway nutome
      NP:Nepal nutome
      NR:Nauru nutome
      NU:Niue nutome
      NZ:New Zealand nutome
      OM:Oman nutome
      PA:Panama nutome
      PE:Peru nutome
      PF:Frentsi Pɔlinesia nutome
      PG:Papua New Gini nutome
      PH:Filipini nutome
      PK:Pakistan nutome
      PL:Poland nutome
      PM:Saint Pierre kple Mikelɔn nutome
      PN:Pitkairn ƒudomekpo nutome
      PR:Puerto Riko nutome
      PS:Palestinia nutome
      PT:Portugal nutome
      PW:Palau nutome
      PY:Paragua nutome
      QA:Katar nutome
      QO:Outlaying Oceania nutome
      RE:Réunion nutome
      RO:Romania nutome
      RU:Russia nutome
      RW:Rwanda nutome
      SA:Saudi Arabia nutome
      SB:Solomon ƒudomekpowo nutome
      SC:Seshɛls nutome
      SD:Sudan nutome
      SE:Sweden nutome
      SG:Singapɔr nutome
      SH:Saint Helena nutome
      SI:Slovenia nutome
      SJ:Svalbard kple Yan Mayen nutome
      SK:Slovakia nutome
      SL:Sierra Leone nutome
      SM:San Marino nutome
      SN:Senegal nutome
      SO:Somalia nutome
      SR:Suriname nutome
      ST:São Tomé kple Príncipe nutome
      SV:El Salvadɔ nutome
      SY:Siria nutome
      SZ:Swaziland nutome
      TA:Tristan da Kunha nutome
      TC:Tɛks kple Kaikos ƒudomekpowo nutome
      TD:Tsad nutome
      TF:Anyiehe Franseme nutome
      TG:Togo nutome
      TH:Thailand nutome
      TJ:Tajikistan nutome
      TK:Tokelau nutome
      TL:Timor-Leste nutome
      TM:Tɛkmenistan nutome
      TN:Tunisia nutome
      TO:Tonga nutome
      TR:Tɛki nutome
      TT:Trinidad kple Tobago nutome
      TV:Tuvalu nutome
      TW:Taiwan nutome
      TZ:Tanzania nutome
      UA:Ukraine nutome
      UG:Uganda nutome
      UM:U.S. Minor Outlaying ƒudomekpowo nutome
      US:USA nutome
      UY:uruguaydukɔ
      UZ:Uzbekistan nutome
      VA:Vatikandu nutome
      VC:Saint Vincent kple Grenadine nutome
      VE:Venezuela nutome
      VG:Britaintɔwo ƒe Virgin ƒudomekpowo nutome
      VI:U.S. Vɛrgin ƒudomekpowo nutome
      VN:Vietnam nutome
      VU:Vanuatu nutome
      WF:Wallis kple Futuna nutome
      WS:Samoa nutome
      YE:Yemen nutome
      YT:Mayotte nutome
      ZA:Anyiehe Africa nutome
      ZM:Zambia nutome
      ZW:Zimbabwe nutome
      ZZ:nutome manya
      """.trimIndent() }

  val ee_TG: String? = null

  val el: String by lazy { """
      001:Κόσμος
      002:Αφρική
      003:Βόρεια Αμερική
      005:Νότια Αμερική
      009:Ωκεανία
      011:Δυτική Αφρική
      013:Κεντρική Αμερική
      014:Ανατολική Αφρική
      015:Βόρεια Αφρική
      017:Μέση Αφρική
      018:Νότιος Αφρική
      019:Αμερική
      021:Βόρειος Αμερική
      029:Καραϊβική
      030:Ανατολική Ασία
      034:Νότια Ασία
      035:Νοτιοανατολική Ασία
      039:Νότια Ευρώπη
      053:Αυστραλασία
      054:Μελανησία
      057:Περιοχή Μικρονησίας
      061:Πολυνησία
      142:Ασία
      143:Κεντρική Ασία
      145:Δυτική Ασία
      150:Ευρώπη
      151:Ανατολική Ευρώπη
      154:Βόρεια Ευρώπη
      155:Δυτική Ευρώπη
      202:Υποσαχάρια Αφρική
      419:Λατινική Αμερική
      AC:Νήσος Ασενσιόν
      AD:Ανδόρα
      AE:Ηνωμένα Αραβικά Εμιράτα
      AF:Αφγανιστάν
      AG:Αντίγκουα και Μπαρμπούντα
      AI:Ανγκουίλα
      AL:Αλβανία
      AM:Αρμενία
      AO:Αγκόλα
      AQ:Ανταρκτική
      AR:Αργεντινή
      AS:Αμερικανική Σαμόα
      AT:Αυστρία
      AU:Αυστραλία
      AW:Αρούμπα
      AX:Νήσοι Όλαντ
      AZ:Αζερμπαϊτζάν
      BA:Βοσνία - Ερζεγοβίνη
      BB:Μπαρμπέιντος
      BD:Μπανγκλαντές
      BE:Βέλγιο
      BF:Μπουρκίνα Φάσο
      BG:Βουλγαρία
      BH:Μπαχρέιν
      BI:Μπουρούντι
      BJ:Μπενίν
      BL:Άγιος Βαρθολομαίος
      BM:Βερμούδες
      BN:Μπρουνέι
      BO:Βολιβία
      BQ:Ολλανδία Καραϊβικής
      BR:Βραζιλία
      BS:Μπαχάμες
      BT:Μπουτάν
      BV:Νήσος Μπουβέ
      BW:Μποτσουάνα
      BY:Λευκορωσία
      BZ:Μπελίζ
      CA:Καναδάς
      CC:Νήσοι Κόκος (Κίλινγκ)
      CD:Κονγκό - Κινσάσα
      CF:Κεντροαφρικανική Δημοκρατία
      CG:Κονγκό - Μπραζαβίλ
      CH:Ελβετία
      CI:Ακτή Ελεφαντοστού
      CK:Νήσοι Κουκ
      CL:Χιλή
      CM:Καμερούν
      CN:Κίνα
      CO:Κολομβία
      CP:Νήσος Κλίπερτον
      CR:Κόστα Ρίκα
      CU:Κούβα
      CV:Πράσινο Ακρωτήριο
      CW:Κουρασάο
      CX:Νήσος των Χριστουγέννων
      CY:Κύπρος
      CZ:Τσεχία
      DE:Γερμανία
      DG:Ντιέγκο Γκαρσία
      DJ:Τζιμπουτί
      DK:Δανία
      DM:Ντομίνικα
      DO:Δομινικανή Δημοκρατία
      DZ:Αλγερία
      EA:Θέουτα και Μελίγια
      EC:Ισημερινός
      EE:Εσθονία
      EG:Αίγυπτος
      EH:Δυτική Σαχάρα
      ER:Ερυθραία
      ES:Ισπανία
      ET:Αιθιοπία
      EU:Ευρωπαϊκή Ένωση
      EZ:Ευρωζώνη
      FI:Φινλανδία
      FJ:Φίτζι
      FK:Νήσοι Φόκλαντ
      FM:Μικρονησία
      FO:Νήσοι Φερόες
      FR:Γαλλία
      GA:Γκαμπόν
      GB:Ηνωμένο Βασίλειο
      GD:Γρενάδα
      GE:Γεωργία
      GF:Γαλλική Γουιάνα
      GG:Γκέρνζι
      GH:Γκάνα
      GI:Γιβραλτάρ
      GL:Γροιλανδία
      GM:Γκάμπια
      GN:Γουινέα
      GP:Γουαδελούπη
      GQ:Ισημερινή Γουινέα
      GR:Ελλάδα
      GS:Νήσοι Νότια Γεωργία και Νότιες Σάντουιτς
      GT:Γουατεμάλα
      GU:Γκουάμ
      GW:Γουινέα Μπισάου
      GY:Γουιάνα
      HK:Χονγκ Κονγκ ΕΔΠ Κίνας
      HM:Νήσοι Χερντ και Μακντόναλντ
      HN:Ονδούρα
      HR:Κροατία
      HT:Αϊτή
      HU:Ουγγαρία
      IC:Κανάριοι Νήσοι
      ID:Ινδονησία
      IE:Ιρλανδία
      IL:Ισραήλ
      IM:Νήσος του Μαν
      IN:Ινδία
      IO:Βρετανικά Εδάφη Ινδικού Ωκεανού
      IQ:Ιράκ
      IR:Ιράν
      IS:Ισλανδία
      IT:Ιταλία
      JE:Τζέρζι
      JM:Τζαμάικα
      JO:Ιορδανία
      JP:Ιαπωνία
      KE:Κένυα
      KG:Κιργιστάν
      KH:Καμπότζη
      KI:Κιριμπάτι
      KM:Κομόρες
      KN:Σεν Κιτς και Νέβις
      KP:Βόρεια Κορέα
      KR:Νότια Κορέα
      KW:Κουβέιτ
      KY:Νήσοι Κέιμαν
      KZ:Καζακστάν
      LA:Λάος
      LB:Λίβανος
      LC:Αγία Λουκία
      LI:Λιχτενστάιν
      LK:Σρι Λάνκα
      LR:Λιβερία
      LS:Λεσότο
      LT:Λιθουανία
      LU:Λουξεμβούργο
      LV:Λετονία
      LY:Λιβύη
      MA:Μαρόκο
      MC:Μονακό
      MD:Μολδαβία
      ME:Μαυροβούνιο
      MF:Άγιος Μαρτίνος (Γαλλικό τμήμα)
      MG:Μαδαγασκάρη
      MH:Νήσοι Μάρσαλ
      MK:Βόρεια Μακεδονία
      ML:Μάλι
      MM:Μιανμάρ (Βιρμανία)
      MN:Μογγολία
      MO:Μακάο ΕΔΠ Κίνας
      MP:Νήσοι Βόρειες Μαριάνες
      MQ:Μαρτινίκα
      MR:Μαυριτανία
      MS:Μονσεράτ
      MT:Μάλτα
      MU:Μαυρίκιος
      MV:Μαλδίβες
      MW:Μαλάουι
      MX:Μεξικό
      MY:Μαλαισία
      MZ:Μοζαμβίκη
      NA:Ναμίμπια
      NC:Νέα Καληδονία
      NE:Νίγηρας
      NF:Νήσος Νόρφολκ
      NG:Νιγηρία
      NI:Νικαράγουα
      NL:Κάτω Χώρες
      NO:Νορβηγία
      NP:Νεπάλ
      NR:Ναουρού
      NU:Νιούε
      NZ:Νέα Ζηλανδία
      OM:Ομάν
      PA:Παναμάς
      PE:Περού
      PF:Γαλλική Πολυνησία
      PG:Παπούα Νέα Γουινέα
      PH:Φιλιππίνες
      PK:Πακιστάν
      PL:Πολωνία
      PM:Σεν Πιερ και Μικελόν
      PN:Νήσοι Πίτκερν
      PR:Πουέρτο Ρίκο
      PS:Παλαιστινιακά Εδάφη
      PT:Πορτογαλία
      PW:Παλάου
      PY:Παραγουάη
      QA:Κατάρ
      QO:Περιφερειακή Ωκεανία
      RE:Ρεϊνιόν
      RO:Ρουμανία
      RS:Σερβία
      RU:Ρωσία
      RW:Ρουάντα
      SA:Σαουδική Αραβία
      SB:Νήσοι Σολομώντος
      SC:Σεϋχέλλες
      SD:Σουδάν
      SE:Σουηδία
      SG:Σιγκαπούρη
      SH:Αγία Ελένη
      SI:Σλοβενία
      SJ:Σβάλμπαρντ και Γιαν Μαγιέν
      SK:Σλοβακία
      SL:Σιέρα Λεόνε
      SM:Άγιος Μαρίνος
      SN:Σενεγάλη
      SO:Σομαλία
      SR:Σουρινάμ
      SS:Νότιο Σουδάν
      ST:Σάο Τομέ και Πρίνσιπε
      SV:Ελ Σαλβαδόρ
      SX:Άγιος Μαρτίνος (Ολλανδικό τμήμα)
      SY:Συρία
      SZ:Εσουατίνι
      TA:Τριστάν ντα Κούνια
      TC:Νήσοι Τερκς και Κάικος
      TD:Τσαντ
      TF:Γαλλικά Νότια Εδάφη
      TG:Τόγκο
      TH:Ταϊλάνδη
      TJ:Τατζικιστάν
      TK:Τοκελάου
      TL:Τιμόρ-Λέστε
      TM:Τουρκμενιστάν
      TN:Τυνησία
      TO:Τόνγκα
      TR:Τουρκία
      TT:Τρινιντάντ και Τομπάγκο
      TV:Τουβαλού
      TW:Ταϊβάν
      TZ:Τανζανία
      UA:Ουκρανία
      UG:Ουγκάντα
      UM:Απομακρυσμένες Νησίδες ΗΠΑ
      UN:Ηνωμένα Έθνη
      US:Ηνωμένες Πολιτείες
      UY:Ουρουγουάη
      UZ:Ουζμπεκιστάν
      VA:Βατικανό
      VC:Άγιος Βικέντιος και Γρεναδίνες
      VE:Βενεζουέλα
      VG:Βρετανικές Παρθένες Νήσοι
      VI:Αμερικανικές Παρθένες Νήσοι
      VN:Βιετνάμ
      VU:Βανουάτου
      WF:Γουάλις και Φουτούνα
      WS:Σαμόα
      XA:Ψευδο-προφορές
      XB:Ψευδο-αμφικατευθυντικό
      XK:Κοσσυφοπέδιο
      YE:Υεμένη
      YT:Μαγιότ
      ZA:Νότια Αφρική
      ZM:Ζάμπια
      ZW:Ζιμπάμπουε
      ZZ:Άγνωστη περιοχή
      """.trimIndent() }

  val el_CY: String? = null

  val el_polyton: String by lazy { """
      AD:Ἀνδόρα
      AE:Ἠνωμένα Ἀραβικὰ Ἐμιράτα
      AF:Ἀφγανιστάν
      AG:Ἀντίγκουα καὶ Μπαρμπούντα
      AI:Ἀνγκουίλα
      AL:Ἀλβανία
      AM:Ἀρμενία
      AO:Ἀνγκόλα
      AQ:Ἀνταρκτική
      AR:Ἀργεντινή
      AS:Ἀμερικανικὴ Σαμόα
      AT:Αὐστρία
      AU:Αὐστραλία
      AW:Ἀρούμπα
      AZ:Ἀζερμπαϊτζάν
      BA:Βοσνία - Ἐρζεγοβίνη
      BM:Βερμοῦδες
      BV:Νῆσος Μπουβέ
      CC:Νῆσοι Κόκος (Κήλινγκ)
      CD:Κονγκό, Λαϊκὴ Δημοκρατία τοῦ
      CF:Κεντροαφρικανικὴ Δημοκρατία
      CH:Ἑλβετία
      CK:Νῆσοι Κούκ
      CX:Νῆσος Χριστουγέννων
      DO:Δομινικανὴ Δημοκρατία
      DZ:Ἀλγερία
      EC:Ἰσημερινός
      EE:Ἐσθονία
      EG:Αἴγυπτος
      EH:Δυτικὴ Σαχάρα
      ER:Ἐρυθραία
      ES:Ἱσπανία
      ET:Αἰθιοπία
      FM:Μικρονησία, Ὁμόσπονδες Πολιτεῖες τῆς
      FO:Νῆσοι Φερόες
      GB:Ἡνωμένο Βασίλειο
      GF:Γαλλικὴ Γουιάνα
      GQ:Ἰσημερινὴ Γουινέα
      GR:Ἑλλάδα
      HK:Χὸνγκ Κόνγκ, Εἰδικὴ Διοικητικὴ Περιφέρεια τῆς Κίνας
      HM:Νῆσοι Χὲρντ καὶ Μακντόναλντ
      HN:Ὁνδούρα
      HT:Ἁϊτή
      HU:Οὑγγαρία
      ID:Ἰνδονησία
      IE:Ἰρλανδία
      IL:Ἰσραήλ
      IN:Ἰνδία
      IQ:Ἰράκ
      IR:Ἰράν, Ἰσλαμικὴ Δημοκρατία τοῦ
      IS:Ἰσλανδία
      IT:Ἰταλία
      JO:Ἰορδανία
      JP:Ἰαπωνία
      KN:Σαὶντ Κὶτς καὶ Νέβις
      KY:Νῆσοι Κέιμαν
      LA:Λατινικὴ Ἀμερική
      LC:Ἁγία Λουκία
      LK:Σρὶ Λάνκα
      LU:Λουξεμβοῦργο
      MD:Μολδαβία, Δημοκρατία τῆς
      MH:Νῆσοι Μάρσαλ
      ML:Μαλί
      MO:Μακάο, Εἰδικὴ Διοικητικὴ Περιφέρεια τῆς Κίνας
      MP:Νῆσοι Βόρειες Μαριάνες
      NF:Νῆσος Νόρφολκ
      NL:Ὁλλανδία
      OM:Ὀμάν
      PF:Γαλλικὴ Πολυνησία
      PM:Σαὶντ Πιὲρ καὶ Μικελόν
      PS:Παλαιστινιακὰ Ἐδάφη
      SA:Σαουδικὴ Ἀραβία
      SB:Νῆσοι Σολομῶντος
      SH:Ἁγία Ἑλένη
      SJ:Νῆσοι Σβάλμπαρ καὶ Γιὰν Μαγιέν
      SM:Ἅγιος Μαρίνος
      ST:Σάο Τομὲ καὶ Πρίνσιπε
      SV:Ἒλ Σαλβαδόρ
      SY:Συρία, Ἀραβικὴ Δημοκρατία τῆς
      TC:Νῆσοι Τὲρκς καὶ Κάικος
      TD:Τσάντ
      TF:Γαλλικὰ Νότια Ἐδάφη
      TL:Ἀνατολικὸ Τιμόρ
      TT:Τρινιδὰδ καὶ Τομπάγκο
      UA:Οὐκρανία
      UG:Οὐγκάντα
      UM:Ἀπομακρυσμένες Νησίδες τῶν Ἡνωμένων Πολιτειῶν
      US:Ἡνωμένες Πολιτεῖες
      UY:Οὐρουγουάη
      UZ:Οὐζμπεκιστάν
      VA:Ἁγία Ἕδρα (Βατικανό)
      VC:Ἅγιος Βικέντιος καὶ Γρεναδίνες
      VG:Βρετανικὲς Παρθένοι Νῆσοι
      VI:Ἀμερικανικὲς Παρθένοι Νῆσοι
      WF:Νῆσοι Οὐάλλις καὶ Φουτουνά
      YE:Ὑεμένη
      ZA:Νότια Ἀφρική
      """.trimIndent() }

  val en: String by lazy { """
      001:world
      002:Africa
      003:North America
      005:South America
      009:Oceania
      011:Western Africa
      013:Central America
      014:Eastern Africa
      015:Northern Africa
      017:Middle Africa
      018:Southern Africa
      019:Americas
      021:Northern America
      029:Caribbean
      030:Eastern Asia
      034:Southern Asia
      035:Southeast Asia
      039:Southern Europe
      053:Australasia
      054:Melanesia
      057:Micronesian Region
      061:Polynesia
      142:Asia
      143:Central Asia
      145:Western Asia
      150:Europe
      151:Eastern Europe
      154:Northern Europe
      155:Western Europe
      202:Sub-Saharan Africa
      419:Latin America
      AC:Ascension Island
      AD:Andorra
      AE:United Arab Emirates
      AF:Afghanistan
      AG:Antigua & Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarctica
      AR:Argentina
      AS:American Samoa
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Åland Islands
      AZ:Azerbaijan
      BA:Bosnia & Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgium
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:St. Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Caribbean Netherlands
      BR:Brazil
      BS:Bahamas
      BT:Bhutan
      BV:Bouvet Island
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Canada
      CC:Cocos (Keeling) Islands
      CD:Congo - Kinshasa
      CF:Central African Republic
      CG:Congo - Brazzaville
      CH:Switzerland
      CI:Côte d’Ivoire
      CK:Cook Islands
      CL:Chile
      CM:Cameroon
      CN:China
      CO:Colombia
      CP:Clipperton Island
      CQ:Sark
      CR:Costa Rica
      CU:Cuba
      CV:Cape Verde
      CW:Curaçao
      CX:Christmas Island
      CY:Cyprus
      CZ:Czechia
      DE:Germany
      DG:Diego Garcia
      DJ:Djibouti
      DK:Denmark
      DM:Dominica
      DO:Dominican Republic
      DZ:Algeria
      EA:Ceuta & Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egypt
      EH:Western Sahara
      ER:Eritrea
      ES:Spain
      ET:Ethiopia
      EU:European Union
      EZ:Eurozone
      FI:Finland
      FJ:Fiji
      FK:Falkland Islands
      FM:Micronesia
      FO:Faroe Islands
      FR:France
      GA:Gabon
      GB:United Kingdom
      GD:Grenada
      GE:Georgia
      GF:French Guiana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Greenland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Equatorial Guinea
      GR:Greece
      GS:South Georgia & South Sandwich Islands
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hong Kong SAR China
      HM:Heard & McDonald Islands
      HN:Honduras
      HR:Croatia
      HT:Haiti
      HU:Hungary
      IC:Canary Islands
      ID:Indonesia
      IE:Ireland
      IL:Israel
      IM:Isle of Man
      IN:India
      IO:British Indian Ocean Territory
      IQ:Iraq
      IR:Iran
      IS:Iceland
      IT:Italy
      JE:Jersey
      JM:Jamaica
      JO:Jordan
      JP:Japan
      KE:Kenya
      KG:Kyrgyzstan
      KH:Cambodia
      KI:Kiribati
      KM:Comoros
      KN:St. Kitts & Nevis
      KP:North Korea
      KR:South Korea
      KW:Kuwait
      KY:Cayman Islands
      KZ:Kazakhstan
      LA:Laos
      LB:Lebanon
      LC:St. Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lithuania
      LU:Luxembourg
      LV:Latvia
      LY:Libya
      MA:Morocco
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:St. Martin
      MG:Madagascar
      MH:Marshall Islands
      MK:North Macedonia
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Macao SAR China
      MP:Northern Mariana Islands
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldives
      MW:Malawi
      MX:Mexico
      MY:Malaysia
      MZ:Mozambique
      NA:Namibia
      NC:New Caledonia
      NE:Niger
      NF:Norfolk Island
      NG:Nigeria
      NI:Nicaragua
      NL:Netherlands
      NO:Norway
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:Oman
      PA:Panama
      PE:Peru
      PF:French Polynesia
      PG:Papua New Guinea
      PH:Philippines
      PK:Pakistan
      PL:Poland
      PM:St. Pierre & Miquelon
      PN:Pitcairn Islands
      PR:Puerto Rico
      PS:Palestinian Territories
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Outlying Oceania
      RE:Réunion
      RO:Romania
      RS:Serbia
      RU:Russia
      RW:Rwanda
      SA:Saudi Arabia
      SB:Solomon Islands
      SC:Seychelles
      SD:Sudan
      SE:Sweden
      SG:Singapore
      SH:St. Helena
      SI:Slovenia
      SJ:Svalbard & Jan Mayen
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:South Sudan
      ST:São Tomé & Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks & Caicos Islands
      TD:Chad
      TF:French Southern Territories
      TG:Togo
      TH:Thailand
      TJ:Tajikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Türkiye
      TT:Trinidad & Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraine
      UG:Uganda
      UM:U.S. Outlying Islands
      UN:United Nations
      US:United States
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatican City
      VC:St. Vincent & Grenadines
      VE:Venezuela
      VG:British Virgin Islands
      VI:U.S. Virgin Islands
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis & Futuna
      WS:Samoa
      XA:Pseudo-Accents
      XB:Pseudo-Bidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:South Africa
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Unknown Region
      """.trimIndent() }

  val en_001: String by lazy { """
      BL:St Barthélemy
      KN:St Kitts & Nevis
      LC:St Lucia
      MF:St Martin
      PM:St Pierre & Miquelon
      SH:St Helena
      UM:US Outlying Islands
      VC:St Vincent & the Grenadines
      VI:US Virgin Islands
      """.trimIndent() }

  val en_150: String? = null

  val en_AE: String? = null

  val en_AG: String? = null

  val en_AI: String? = null

  val en_AS: String? = null

  val en_AT: String? = null

  val en_AU: String by lazy { """
      001:World
      BL:St. Barthélemy
      KN:St. Kitts & Nevis
      LC:St. Lucia
      MF:St. Martin
      VC:St. Vincent & Grenadines
      """.trimIndent() }

  val en_BB: String? = null

  val en_BE: String? = null

  val en_BI: String? = null

  val en_BM: String? = null

  val en_BS: String? = null

  val en_BW: String? = null

  val en_BZ: String? = null

  val en_CA: String by lazy { """
      057:Micronesian region
      AG:Antigua and Barbuda
      BA:Bosnia and Herzegovina
      BL:Saint-Barthélemy
      EA:Ceuta and Melilla
      GS:South Georgia and South Sandwich Islands
      HM:Heard and McDonald Islands
      KN:Saint Kitts and Nevis
      LC:Saint Lucia
      MF:Saint Martin
      PM:Saint-Pierre-et-Miquelon
      PS:Palestinian territories
      SH:Saint Helena
      SJ:Svalbard and Jan Mayen
      ST:São Tomé and Príncipe
      TC:Turks and Caicos Islands
      TT:Trinidad and Tobago
      UM:US Outlying Islands
      VC:Saint Vincent and the Grenadines
      VI:US Virgin Islands
      WF:Wallis and Futuna
      """.trimIndent() }

  val en_CC: String? = null

  val en_CH: String? = null

  val en_CK: String? = null

  val en_CM: String? = null

  val en_CX: String? = null

  val en_CY: String? = null

  val en_DE: String? = null

  val en_DG: String? = null

  val en_DK: String? = null

  val en_DM: String? = null

  val en_Dsrt: String by lazy { """
      001:𐐎𐐲𐑉𐑊𐐼
      002:𐐈𐑁𐑉𐐲𐐿𐐲
      003:𐐤𐐱𐑉𐑃 𐐊𐑋𐐯𐑉𐐲𐐿𐐲
      005:𐐝𐐵𐑃 𐐊𐑋𐐯𐑉𐐲𐐿𐐲
      009:𐐄𐑇𐐨𐐰𐑌𐐨𐐲
      011:𐐎𐐯𐑅𐐻𐐲𐑉𐑌 𐐈𐑁𐑉𐐲𐐿𐐲
      013:𐐝𐐯𐑌𐐻𐑉𐐲𐑊 𐐊𐑋𐐯𐑉𐐲𐐿𐐲
      014:𐐀𐑅𐐻𐐲𐑉𐑌 𐐈𐑁𐑉𐐲𐐿𐐲
      015:𐐤𐐱𐑉𐑄𐐲𐑉𐑌 𐐈𐑁𐑉𐐲𐐿𐐲
      017:𐐣𐐮𐐼𐑊 𐐈𐑁𐑉𐐮𐐿𐐲
      018:𐐝𐐲𐑄𐐲𐑉𐑌 𐐈𐑁𐑉𐐲𐐿𐐲
      019:𐐊𐑋𐐯𐑉𐐲𐐿𐐲𐑆
      021:𐐤𐐱𐑉𐑄𐐲𐑉𐑌 𐐊𐑋𐐯𐑉𐐲𐐿𐐲
      029:𐐗𐐯𐑉𐐲𐐺𐐨𐐲𐑌
      030:𐐀𐑅𐐻𐐲𐑉𐑌 𐐁𐑈𐐲
      034:𐐝𐐲𐑄𐐲𐑉𐑌 𐐁𐑈𐐲
      035:𐐝𐐵𐑃-𐐀𐑅𐐻𐐲𐑉𐑌 𐐁𐑈𐐲
      039:𐐝𐐲𐑄𐐲𐑉𐑌 𐐏𐐲𐑉𐐲𐐹
      053:𐐉𐑅𐐻𐑉𐐩𐑊𐐨𐐲 𐐰𐑌𐐼 𐐤𐐭 𐐞𐐨𐑊𐐲𐑌𐐼
      054:𐐣𐐯𐑊𐐲𐑌𐐨𐑈𐐲
      057:𐐣𐐴𐐿𐑉𐐲𐑌𐐨𐑈𐐲𐑌 𐐡𐐨𐐾𐐲𐑌
      061:𐐑𐐪𐑊𐐲𐑌𐐨𐑈𐐲
      142:𐐁𐑈𐐲
      143:𐐝𐐯𐑌𐐻𐑉𐐲𐑊 𐐁𐑈𐐲
      145:𐐎𐐯𐑅𐐻𐐲𐑉𐑌 𐐁𐑈𐐲
      150:𐐏𐐲𐑉𐐲𐐹
      151:𐐀𐑅𐐻𐐲𐑉𐑌 𐐏𐐲𐑉𐐲𐐹
      154:𐐤𐐱𐑉𐑄𐐲𐑉𐑌 𐐏𐐲𐑉𐐲𐐹
      155:𐐎𐐯𐑅𐐻𐐲𐑉𐑌 𐐏𐐲𐑉𐐲𐐹
      419:𐐢𐐰𐐻𐑌 𐐊𐑋𐐯𐑉𐐲𐐿𐐲 𐐰𐑌𐐼 𐑄 𐐗𐐯𐑉𐐲𐐺𐐨𐐲𐑌
      AD:𐐈𐑌𐐼𐐱𐑉𐐲
      AE:𐐏𐐭𐑌𐐴𐐼𐐮𐐼 𐐇𐑉𐐲𐐺 𐐇𐑋𐐲𐑉𐐩𐐻𐑅
      AF:𐐈𐑁𐑀𐐰𐑌𐐲𐑅𐐻𐐰𐑌
      AG:𐐈𐑌𐐻𐐨𐑀𐐶𐐲 𐐰𐑌𐐼 𐐒𐐪𐑉𐐺𐐷𐐭𐐼𐐲
      AI:𐐈𐑍𐑀𐐶𐐮𐑊𐐲
      AL:𐐈𐑊𐐺𐐩𐑌𐐨𐐲
      AM:𐐂𐑉𐑋𐐨𐑌𐐨𐐲
      AO:𐐈𐑌𐑀𐐬𐑊𐐲
      AQ:𐐈𐑌𐐻𐐪𐑉𐐿𐐻𐐮𐐿𐐲
      AR:𐐂𐑉𐐾𐐲𐑌𐐻𐐨𐑌𐐲
      AS:𐐊𐑋𐐯𐑉𐐲𐐿𐐲𐑌 𐐝𐐲𐑋𐐬𐐲
      AT:𐐉𐑅𐐻𐑉𐐨𐐲
      AU:𐐉𐑅𐐻𐑉𐐩𐑊𐐨𐐲
      AW:𐐊𐑉𐐭𐐺𐐲
      AX:𐐈𐑊𐐰𐑌𐐼 𐐌𐑊𐐲𐑌𐐼𐑆
      AZ:𐐈𐑆𐐲𐑉𐐺𐐴𐑈𐐪𐑌
      BA:𐐒𐐱𐑆𐑌𐐨𐐲 𐐰𐑌𐐼 𐐐𐐲𐑉𐐻𐑅𐐲𐑀𐐬𐑂𐐨𐑌𐐲
      BB:𐐒𐐪𐑉𐐺𐐩𐐼𐐬𐑅
      BD:𐐒𐐪𐑍𐑀𐑊𐐲𐐼𐐯𐑇
      BE:𐐒𐐯𐑊𐐾𐐲𐑋
      BF:𐐒𐐲𐑉𐐿𐐩𐑌𐐲 𐐙𐐰𐑅𐐬
      BG:𐐒𐐲𐑊𐑀𐐯𐑉𐐨𐐲
      BH:𐐒𐐪𐑉𐐩𐑌
      BI:𐐒𐐲𐑉𐐳𐑌𐐼𐐨
      BJ:𐐒𐐲𐑌𐐨𐑌
      BL:𐐝𐐩𐑌𐐻 𐐒𐐪𐑉𐐻𐐩𐑊𐐲𐑋𐐨
      BM:𐐒𐐲𐑉𐑋𐐷𐐭𐐼𐐲
      BN:𐐒𐑉𐐭𐑌𐐴
      BO:𐐒𐐬𐑊𐐮𐑂𐐨𐐲
      BR:𐐒𐑉𐐲𐑆𐐮𐑊
      BS:𐐒𐐲𐐸𐐪𐑋𐐲𐑅
      BT:𐐒𐐭𐐻𐐪𐑌
      BV:𐐒𐐭𐑂𐐩 𐐌𐑊𐐲𐑌𐐼
      BW:𐐒𐐪𐐻𐑅𐐶𐐪𐑌𐐲
      BY:𐐒𐐯𐑊𐐲𐑉𐐭𐑅
      BZ:𐐒𐐲𐑊𐐨𐑆
      CA:𐐗𐐰𐑌𐐲𐐼𐐲
      CC:𐐗𐐬𐐿𐐬𐑆 𐐌𐑊𐐲𐑌𐐼𐑆
      CD:𐐗𐐪𐑍𐑀𐐬 - 𐐗𐐲𐑌𐑇𐐪𐑅𐐲
      CF:𐐝𐐯𐑌𐐻𐑉𐐲𐑊 𐐈𐑁𐑉𐐲𐐿𐐲𐑌 𐐡𐐨𐐹𐐲𐐺𐑊𐐮𐐿
      CG:𐐗𐐪𐑍𐑀𐐬 - 𐐒𐑉𐐪𐑆𐐲𐑂𐐮𐑊
      CH:𐐝𐐶𐐮𐐻𐑅𐐲𐑉𐑊𐐲𐑌𐐼
      CI:𐐌𐑂𐑉𐐨 𐐗𐐬𐑅𐐻
      CK:𐐗𐐳𐐿 𐐌𐑊𐐲𐑌𐐼𐑆
      CL:𐐕𐐨𐑊𐐩
      CM:𐐗𐐰𐑋𐐲𐑉𐐭𐑌
      CN:𐐕𐐴𐑌𐐲
      CO:𐐗𐐲𐑊𐐲𐑋𐐺𐐨𐐲
      CR:𐐗𐐱𐑅𐐻𐐲 𐐡𐐨𐐿𐐲
      CU:𐐗𐐷𐐭𐐺𐐲
      CV:𐐗𐐩𐐹 𐐚𐐯𐑉𐐼𐐨
      CX:𐐗𐑉𐐮𐑅𐑋𐐲𐑅 𐐌𐑊𐐲𐑌𐐼
      CY:𐐝𐐴𐐹𐑉𐐲𐑅
      CZ:𐐕𐐯𐐿 𐐡𐐨𐐹𐐲𐐺𐑊𐐮𐐿
      DE:𐐖𐐲𐑉𐑋𐐲𐑌𐐨
      DJ:𐐖𐐲𐐺𐐭𐐼𐐨
      DK:𐐔𐐯𐑌𐑋𐐪𐑉𐐿
      DM:𐐔𐐪𐑋𐐲𐑌𐐨𐐿𐐲
      DO:𐐔𐐲𐑋𐐮𐑌𐐲𐐿𐐲𐑌 𐐡𐐨𐐹𐐲𐐺𐑊𐐮𐐿
      DZ:𐐈𐑊𐐾𐐮𐑉𐐨𐐲
      EC:𐐇𐐿𐐶𐐲𐐼𐐱𐑉
      EE:𐐇𐑅𐐻𐐬𐑌𐐨𐐲
      EG:𐐀𐐾𐐲𐐹𐐻
      EH:𐐎𐐯𐑅𐐻𐐲𐑉𐑌 𐐝𐐲𐐸𐐱𐑉𐐲
      ER:𐐇𐑉𐐮𐐻𐑉𐐨𐐲
      ES:𐐝𐐹𐐩𐑌
      ET:𐐀𐑃𐐨𐐬𐐹𐐨𐐲
      EU:𐐏𐐲𐑉𐐲𐐹𐐨𐐲𐑌 𐐏𐐭𐑌𐐷𐐲𐑌
      FI:𐐙𐐮𐑌𐑊𐐲𐑌𐐼
      FJ:𐐙𐐨𐐾𐐨
      FK:𐐙𐐪𐑊𐐿𐑊𐐲𐑌𐐼 𐐌𐑊𐐲𐑌𐐼𐑆
      FM:𐐣𐐴𐐿𐑉𐐲𐑌𐐨𐑈𐐲
      FO:𐐙𐐯𐑉𐐬 𐐌𐑊𐐲𐑌𐐼𐑆
      FR:𐐙𐑉𐐰𐑌𐑅
      GA:𐐘𐐲𐐺𐐪𐑌
      GB:𐐏𐐭𐑌𐐴𐐻𐐲𐐼 𐐗𐐨𐑍𐐼𐐲𐑋
      GD:𐐘𐑉𐐲𐑌𐐩𐐼𐐲
      GE:𐐖𐐱𐑉𐐾𐐲
      GF:𐐙𐑉𐐯𐑌𐐽 𐐘𐐨𐐪𐑌𐐲
      GG:𐐘𐐲𐑉𐑌𐑆𐐨
      GH:𐐘𐐪𐑌𐐲
      GI:𐐖𐐲𐐺𐑉𐐱𐑊𐐻𐐲𐑉
      GL:𐐘𐑉𐐨𐑌𐑊𐐲𐑌𐐼
      GM:𐐘𐐰𐑋𐐺𐐨𐐲
      GN:𐐘𐐮𐑌𐐨
      GP:𐐘𐐶𐐪𐐼𐐲𐑊𐐭𐐹
      GQ:𐐇𐐿𐐶𐐲𐐻𐐱𐑉𐐨𐐲𐑊 𐐘𐐮𐑌𐐨
      GR:𐐘𐑉𐐨𐑅
      GS:𐐝𐐵𐑃 𐐖𐐱𐑉𐐾𐐲 𐐰𐑌𐐼 𐑄 𐐝𐐵𐑃 𐐝𐐰𐑌𐐼𐐶𐐮𐐽 𐐌𐑊𐐲𐑌𐐼𐑆
      GT:𐐘𐐶𐐪𐐼𐐲𐑋𐐪𐑊𐐲
      GU:𐐘𐐶𐐪𐑋
      GW:𐐘𐐮𐑌𐐨-𐐒𐐮𐑅𐐵
      GY:𐐘𐐴𐐰𐑌𐐲
      HK:𐐐𐐬𐑍 𐐗𐐬𐑍 𐐝𐐈𐐡 𐐕𐐴𐑌𐐲
      HM:𐐐𐐲𐑉𐐼 𐐌𐑊𐐲𐑌𐐼 𐐰𐑌𐐼 𐐣𐐿𐐔𐐱𐑌𐐲𐑊𐐼 𐐌𐑊𐐲𐑌𐐼𐑆
      HN:𐐐𐐪𐑌𐐼𐐭𐑉𐐲𐑅
      HR:𐐗𐑉𐐬𐐩𐑇𐐲
      HT:𐐐𐐩𐐻𐐨
      HU:𐐐𐐲𐑍𐑀𐐲𐑉𐐨
      ID:𐐆𐑌𐐼𐐲𐑌𐐨𐑈𐐲
      IE:𐐌𐑉𐑊𐐲𐑌𐐼
      IL:𐐆𐑆𐑉𐐨𐐲𐑊
      IM:𐐌𐐲𐑊 𐐲𐑁 𐐣𐐰𐑌
      IN:𐐆𐑌𐐼𐐨𐐲
      IQ:𐐆𐑉𐐰𐐿
      IR:𐐆𐑉𐐪𐑌
      IS:𐐌𐑅𐑊𐐲𐑌𐐼
      IT:𐐆𐐻𐐲𐑊𐐨
      JE:𐐖𐐲𐑉𐑆𐐨
      JM:𐐖𐐲𐑋𐐩𐐿𐐲
      JO:𐐖𐐱𐑉𐐼𐐲𐑌
      JP:𐐖𐐲𐐹𐐰𐑌
      KE:𐐗𐐯𐑌𐐷𐐲
      KG:𐐗𐐮𐑉𐑀𐐲𐑅𐐻𐐰𐑌
      KH:𐐗𐐰𐑋𐐺𐐬𐐼𐐨𐐲
      KI:𐐗𐐮𐑉𐐲𐐺𐐪𐐻𐐨
      KM:𐐗𐐪𐑋𐐲𐑉𐐬𐑆
      KN:𐐝𐐩𐑌𐐻 𐐗𐐮𐐻𐑅 𐐰𐑌𐐼 𐐤𐐨𐑂𐐮𐑅
      KP:𐐤𐐱𐑉𐑃 𐐗𐐲𐑉𐐨𐐲
      KR:𐐝𐐵𐑃 𐐗𐐲𐑉𐐨𐐲
      KW:𐐗𐐲𐐶𐐩𐐻
      KY:𐐗𐐩𐑋𐐲𐑌 𐐌𐑊𐐲𐑌𐐼𐑆
      KZ:𐐗𐐲𐑆𐐪𐐿𐑅𐐻𐐪𐑌
      LA:𐐢𐐪𐐬𐑅
      LB:𐐢𐐯𐐺𐐲𐑌𐐪𐑌
      LI:𐐢𐐮𐐿𐐻𐐲𐑌𐑅𐐻𐐴𐑌
      LK:𐐟𐑉𐐨 𐐢𐐰𐑍𐐿𐐲
      LR:𐐢𐐴𐐺𐐮𐑉𐐨𐐲
      LS:𐐢𐐲𐑅𐐬𐑃𐐬
      LT:𐐢𐐮𐑃𐐲𐐶𐐩𐑌𐐨𐐲
      LU:𐐢𐐲𐐿𐑅𐐲𐑋𐐺𐐲𐑉𐑀
      LV:𐐢𐐰𐐻𐑂𐐨𐐲
      LY:𐐢𐐮𐐺𐐨𐐲
      MA:𐐣𐐲𐑉𐐪𐐿𐐬
      MC:𐐣𐐪𐑌𐐲𐐿𐐬
      MD:𐐣𐐱𐑊𐐼𐐬𐑂𐐲
      ME:𐐣𐐪𐑌𐐲𐑌𐐨𐑀𐑉𐐬
      MF:𐐝𐐩𐑌𐐻 𐐣𐐪𐑉𐐻𐑌
      MG:𐐣𐐰𐐼𐐲𐑀𐐰𐑅𐐿𐐲𐑉
      MH:𐐣𐐪𐑉𐑇𐐲𐑊 𐐌𐑊𐐲𐑌𐐼𐑆
      MK:𐐣𐐰𐑅𐐲𐐼𐐬𐑌𐐨𐐲
      ML:𐐣𐐪𐑊𐐨
      MM:𐐣𐐨𐐲𐑌𐑋𐐪𐑉
      MN:𐐣𐐪𐑍𐑀𐐬𐑊𐐨𐐲
      MO:𐐣𐐲𐐿𐐵 𐐝𐐈𐐡 𐐕𐐴𐑌𐐲
      MP:𐐤𐐱𐑉𐑄𐐲𐑉𐑌 𐐣𐐰𐑉𐐨𐐱𐑌𐐲 𐐌𐑊𐐲𐑌𐐼𐑆
      MQ:𐐣𐐪𐑉𐐻𐑌𐐨𐐿
      MR:𐐣𐐱𐑉𐐲𐐻𐐩𐑌𐐨𐐲
      MS:𐐣𐐪𐑌𐐻𐑅𐐲𐑉𐐪𐐻
      MT:𐐣𐐱𐑊𐐻𐐲
      MU:𐐣𐐱𐑉𐐮𐑇𐐲𐑅
      MV:𐐣𐐪𐑊𐐼𐐨𐑂𐑆
      MW:𐐣𐐲𐑊𐐪𐐶𐐨
      MX:𐐣𐐯𐐿𐑅𐐲𐐿𐐬
      MY:𐐣𐐲𐑊𐐩𐑈𐐲
      MZ:𐐣𐐬𐑆𐐰𐑋𐐺𐐨𐐿
      NA:𐐤𐐲𐑋𐐮𐐺𐐨𐐲
      NC:𐐤𐐭 𐐗𐐰𐑊𐐲𐐼𐐬𐑌𐐷𐐲
      NE:𐐤𐐴𐐾𐐲𐑉
      NF:𐐤𐐱𐑉𐑁𐐲𐐿 𐐌𐑊𐐲𐑌𐐼
      NG:𐐤𐐴𐐾𐐮𐑉𐐨𐐲
      NI:𐐤𐐮𐐿𐐲𐑉𐐪𐑀𐐶𐐲
      NL:𐐤𐐯𐑄𐐲𐑉𐑊𐐲𐑌𐐼𐑆
      NO:𐐤𐐱𐑉𐐶𐐩
      NP:𐐤𐐩𐐹𐐪𐑊
      NR:𐐤𐐪𐐭𐑉𐐭
      NU:𐐤𐐷𐐭𐐩
      NZ:𐐤𐐭 𐐞𐐨𐑊𐐲𐑌𐐼
      OM:𐐄𐑋𐐲𐑌
      PA:𐐑𐐰𐑌𐐲𐑋𐐪
      PE:𐐑𐐲𐑉𐐭
      PF:𐐙𐑉𐐯𐑌𐐽 𐐑𐐪𐑊𐐲𐑌𐐨𐑈𐐲
      PG:𐐑𐐰𐐹𐐷𐐳𐐲 𐐤𐐭 𐐘𐐮𐑌𐐨
      PH:𐐙𐐮𐑊𐐲𐐹𐐨𐑌𐑆
      PK:𐐑𐐰𐐿𐐲𐑅𐐻𐐰𐑌
      PL:𐐑𐐬𐑊𐐲𐑌𐐼
      PM:𐐝𐐩𐑌𐐻 𐐑𐐨𐐯𐑉 𐐰𐑌𐐼 𐐣𐐨𐐿𐐲𐑊𐐪𐑌
      PN:𐐑𐐮𐐻𐐿𐐯𐑉𐑌
      PR:𐐑𐐶𐐯𐑉𐐻𐐬 𐐡𐐨𐐿𐐬
      PS:𐐑𐐰𐑊𐐲𐑅𐐻𐐮𐑌𐐨𐐲𐑌 𐐓𐐯𐑉𐐲𐐻𐐱𐑉𐐨
      PT:𐐑𐐱𐑉𐐽𐐲𐑀𐐲𐑊
      PW:𐐑𐐲𐑊𐐵
      PY:𐐑𐐯𐑉𐐲𐑀𐐶𐐴
      QA:𐐗𐐲𐐻𐐪𐑉
      QO:𐐍𐐻𐑊𐐴𐐮𐑍 𐐄𐑇𐐨𐐰𐑌𐐨𐐲
      RE:𐐡𐐨𐐷𐐭𐑌𐐷𐐲𐑌
      RO:𐐡𐐬𐑋𐐩𐑌𐐨𐐲
      RS:𐐝𐐲𐑉𐐺𐐨𐐲
      RU:𐐡𐐲𐑇𐐲
      RW:𐐡𐐲𐐶𐐪𐑌𐐼𐐲
      SA:𐐝𐐵𐐼𐐨 𐐊𐑉𐐩𐐺𐐨𐐲
      SB:𐐝𐐪𐑊𐐲𐑋𐐲𐑌 𐐌𐑊𐐲𐑌𐐼𐑆
      SC:𐐝𐐩𐑇𐐯𐑊𐑆
      SD:𐐝𐐭𐐼𐐰𐑌
      SE:𐐝𐐶𐐨𐐼𐑌
      SG:𐐝𐐮𐑍𐐲𐐹𐐱𐑉
      SH:𐐝𐐩𐑌𐐻 𐐐𐐯𐑊𐐲𐑌𐐲
      SI:𐐝𐑊𐐬𐑂𐐨𐑌𐐨𐐲
      SJ:𐐝𐑂𐐪𐑊𐐺𐐪𐑉𐐼 𐐰𐑌𐐼 𐐖𐐰𐑌 𐐣𐐴𐐲𐑌
      SK:𐐝𐑊𐐬𐑂𐐪𐐿𐐨𐐲
      SL:𐐝𐐨𐐯𐑉𐐲 𐐢𐐨𐐬𐑌
      SM:𐐝𐐪𐑌 𐐣𐐲𐑉𐐨𐑌𐐬
      SN:𐐝𐐯𐑌𐐲𐑀𐐱𐑊
      SO:𐐝𐐲𐑋𐐪𐑊𐐨𐐲
      SR:𐐝𐐭𐑉𐐲𐑌𐐪𐑋
      ST:𐐝𐐵 𐐓𐐬𐑋 𐐰𐑌𐐼 𐐑𐑉𐐮𐑌𐐽𐐮𐐹𐐩
      SV:𐐇𐑊 𐐝𐐰𐑊𐑂𐐲𐐼𐐱𐑉
      SY:𐐝𐐮𐑉𐐨𐐲
      SZ:𐐝𐐶𐐪𐑆𐐨𐑊𐐰𐑌𐐼
      TC:𐐓𐐲𐑉𐐿𐑅 𐐰𐑌𐐼 𐐗𐐴𐐿𐐬𐑆 𐐌𐑊𐐲𐑌𐐼𐑆
      TD:𐐕𐐰𐐼
      TF:𐐙𐑉𐐯𐑌𐐽 𐐝𐐲𐑄𐐲𐑉𐑌 𐐓𐐯𐑉𐐲𐐻𐐱𐑉𐐨𐑆
      TG:𐐓𐐬𐑀𐐬
      TH:𐐓𐐴𐑊𐐰𐑌𐐼
      TJ:𐐓𐐲𐐾𐐨𐐿𐐲𐑅𐐻𐐰𐑌
      TK:𐐓𐐬𐐿𐐯𐑊𐐵
      TL:𐐀𐑅𐐻 𐐓𐐨𐑋𐐱𐑉
      TM:𐐓𐐲𐑉𐐿𐑋𐐯𐑌𐐲𐑅𐐻𐐰𐑌
      TO:𐐓𐐪𐑍𐑀𐐲
      TR:𐐓𐐲𐑉𐐿𐐨
      TT:𐐓𐑉𐐮𐑌𐐮𐐼𐐰𐐼 𐐰𐑌𐐼 𐐓𐐲𐐺𐐩𐑀𐐬
      TV:𐐓𐐲𐑂𐐪𐑊𐐭
      TW:𐐓𐐴𐐶𐐪𐑌
      TZ:𐐓𐐰𐑌𐑆𐐲𐑌𐐨𐐲
      UG:𐐏𐐭𐑀𐐰𐑌𐐼𐐲
      UM:𐐏𐐭𐑌𐐰𐐮𐐻𐐲𐐼 𐐝𐐻𐐩𐐻𐑅 𐐣𐐴𐑌𐐬𐑉 𐐍𐐻𐑊𐐴𐐨𐑍 𐐌𐑊𐐲𐑌𐐼𐑆
      US:𐐏𐐭𐑌𐐴𐐻𐐲𐐼 𐐝𐐻𐐩𐐻𐑅
      UY:𐐏𐐳𐑉𐐲𐑀𐐶𐐴
      UZ:𐐅𐑆𐐺𐐯𐐿𐐲𐑅𐐻𐐰𐑌
      VA:𐐚𐐰𐐼𐐲𐐿𐐲𐑌
      VC:𐐝𐐩𐑌𐐻 𐐚𐐮𐑌𐑅𐐲𐑌𐐻 𐐰𐑌𐐼 𐑄 𐐘𐑉𐐯𐑌𐐲𐐼𐐨𐑌𐑆
      VG:𐐒𐑉𐐮𐐼𐐮𐑇 𐐚𐐲𐑉𐐾𐐲𐑌 𐐌𐑊𐐲𐑌𐐼𐑆
      VI:𐐏.𐐝. 𐐚𐐲𐑉𐐾𐐲𐑌 𐐌𐑊𐐲𐑌𐐼𐑆
      VN:𐐚𐐨𐐯𐐻𐑌𐐪𐑋
      VU:𐐚𐐪𐑌𐐳𐐪𐐼𐐭
      WF:𐐎𐐪𐑊𐐮𐑅 𐐰𐑌𐐼 𐐙𐐭𐐻𐐭𐑌𐐲
      WS:𐐝𐐲𐑋𐐬𐐲
      YE:𐐏𐐯𐑋𐐲𐑌
      YT:𐐣𐐪𐐷𐐱𐐻
      ZA:𐐝𐐵𐑃 𐐈𐑁𐑉𐐲𐐿𐐲
      ZM:𐐞𐐰𐑋𐐺𐐨𐐲
      ZW:𐐞𐐮𐑋𐐺𐐪𐐺𐐶𐐩
      ZZ:𐐊𐑌𐐬𐑌 𐐬𐑉 𐐆𐑌𐑂𐐰𐑊𐐮𐐼 𐐡𐐨𐐾𐐲𐑌
      """.trimIndent() }

  val en_ER: String? = null

  val en_FI: String? = null

  val en_FJ: String? = null

  val en_FK: String? = null

  val en_FM: String? = null

  val en_GB: String? = null

  val en_GD: String? = null

  val en_GG: String? = null

  val en_GH: String? = null

  val en_GI: String? = null

  val en_GM: String? = null

  val en_GU: String? = null

  val en_GY: String? = null

  val en_HK: String? = null

  val en_ID: String? = null

  val en_IE: String? = null

  val en_IL: String? = null

  val en_IM: String? = null

  val en_IN: String? = null

  val en_IO: String? = null

  val en_JE: String? = null

  val en_JM: String? = null

  val en_KE: String? = null

  val en_KI: String? = null

  val en_KN: String? = null

  val en_KY: String? = null

  val en_LC: String? = null

  val en_LR: String? = null

  val en_LS: String? = null

  val en_MG: String? = null

  val en_MH: String? = null

  val en_MO: String? = null

  val en_MP: String? = null

  val en_MS: String? = null

  val en_MT: String? = null

  val en_MU: String? = null

  val en_MV: String? = null

  val en_MW: String? = null

  val en_MY: String? = null

  val en_NA: String? = null

  val en_NF: String? = null

  val en_NG: String? = null

  val en_NL: String? = null

  val en_NR: String? = null

  val en_NU: String? = null

  val en_NZ: String? = null

  val en_PG: String? = null

  val en_PH: String? = null

  val en_PK: String? = null

  val en_PN: String? = null

  val en_PR: String? = null

  val en_PW: String? = null

  val en_RW: String? = null

  val en_SB: String? = null

  val en_SC: String? = null

  val en_SD: String? = null

  val en_SE: String? = null

  val en_SG: String? = null

  val en_SH: String? = null

  val en_SI: String? = null

  val en_SL: String? = null

  val en_SS: String? = null

  val en_SX: String? = null

  val en_SZ: String? = null

  val en_TC: String? = null

  val en_TK: String? = null

  val en_TO: String? = null

  val en_TT: String? = null

  val en_TV: String? = null

  val en_TZ: String? = null

  val en_UG: String? = null

  val en_UM: String? = null

  val en_VC: String? = null

  val en_VG: String? = null

  val en_VI: String? = null

  val en_VU: String? = null

  val en_WS: String? = null

  val en_ZA: String? = null

  val en_ZM: String? = null

  val en_ZW: String? = null

  val eo: String by lazy { """
      001:mondo
      AD:Andoro
      AE:Unuiĝintaj Arabaj Emirlandoj
      AF:Afganujo
      AG:Antigvo kaj Barbudo
      AI:Angvilo
      AL:Albanujo
      AM:Armenujo
      AO:Angolo
      AQ:Antarkto
      AR:Argentino
      AT:Aŭstrujo
      AU:Aŭstralio
      AW:Arubo
      AZ:Azerbajĝano
      BA:Bosnujo kaj Hercegovino
      BB:Barbado
      BD:Bangladeŝo
      BE:Belgujo
      BF:Burkino
      BG:Bulgarujo
      BH:Barejno
      BI:Burundo
      BJ:Benino
      BM:Bermudoj
      BN:Brunejo
      BO:Bolivio
      BR:Brazilo
      BS:Bahamoj
      BT:Butano
      BW:Bocvano
      BY:Belorusujo
      BZ:Belizo
      CA:Kanado
      CF:Centr-Afrika Respubliko
      CG:Kongo Brazavila
      CH:Svisujo
      CI:Ebur-Bordo
      CK:Kukinsuloj
      CL:Ĉilio
      CM:Kameruno
      CN:Ĉinujo
      CO:Kolombio
      CR:Kostariko
      CU:Kubo
      CV:Kaboverdo
      CY:Kipro
      CZ:Ĉeĥujo
      DE:Germanujo
      DJ:Ĝibutio
      DK:Danujo
      DM:Dominiko
      DO:Domingo
      DZ:Alĝerio
      EC:Ekvadoro
      EE:Estonujo
      EG:Egiptujo
      EH:Okcidenta Saharo
      ER:Eritreo
      ES:Hispanujo
      ET:Etiopujo
      FI:Finnlando
      FJ:Fiĝoj
      FM:Mikronezio
      FO:Ferooj
      FR:Francujo
      GA:Gabono
      GB:Unuiĝinta Reĝlando
      GD:Grenado
      GE:Kartvelujo
      GF:Franca Gviano
      GH:Ganao
      GI:Ĝibraltaro
      GL:Gronlando
      GM:Gambio
      GN:Gvineo
      GP:Gvadelupo
      GQ:Ekvatora Gvineo
      GR:Grekujo
      GS:Sud-Georgio kaj Sud-Sandviĉinsuloj
      GT:Gvatemalo
      GU:Gvamo
      GW:Gvineo-Bisaŭo
      GY:Gujano
      HM:Herda kaj Makdonaldaj Insuloj
      HN:Honduro
      HR:Kroatujo
      HT:Haitio
      HU:Hungarujo
      ID:Indonezio
      IE:Irlando
      IL:Israelo
      IN:Hindujo
      IQ:Irako
      IR:Irano
      IS:Islando
      IT:Italujo
      JM:Jamajko
      JO:Jordanio
      JP:Japanujo
      KE:Kenjo
      KG:Kirgizujo
      KH:Kamboĝo
      KI:Kiribato
      KM:Komoroj
      KN:Sankta Kristoforo kaj Neviso
      KP:Nord-Koreo
      KR:Sud-Koreo
      KW:Kuvajto
      KY:Kejmanoj
      KZ:Kazaĥujo
      LA:Laoso
      LB:Libano
      LC:Sankta Lucio
      LI:Liĥtenŝtejno
      LK:Srilanko
      LR:Liberio
      LS:Lesoto
      LT:Litovujo
      LU:Luksemburgo
      LV:Latvujo
      LY:Libio
      MA:Maroko
      MC:Monako
      MD:Moldavujo
      MG:Madagaskaro
      MH:Marŝaloj
      ML:Malio
      MM:Birmo
      MN:Mongolujo
      MP:Nord-Marianoj
      MQ:Martiniko
      MR:Maŭritanujo
      MT:Malto
      MU:Maŭricio
      MV:Maldivoj
      MW:Malavio
      MX:Meksiko
      MY:Malajzio
      MZ:Mozambiko
      NA:Namibio
      NC:Nov-Kaledonio
      NE:Niĝero
      NF:Norfolkinsulo
      NG:Niĝerio
      NI:Nikaragvo
      NL:Nederlando
      NO:Norvegujo
      NP:Nepalo
      NR:Nauro
      NU:Niuo
      NZ:Nov-Zelando
      OM:Omano
      PA:Panamo
      PE:Peruo
      PF:Franca Polinezio
      PG:Papuo-Nov-Gvineo
      PH:Filipinoj
      PK:Pakistano
      PL:Pollando
      PM:Sankta Piero kaj Mikelono
      PN:Pitkarna Insulo
      PR:Puertoriko
      PT:Portugalujo
      PW:Palaŭo
      PY:Paragvajo
      QA:Kataro
      RE:Reunio
      RO:Rumanujo
      RU:Rusujo
      RW:Ruando
      SA:Sauda Arabujo
      SB:Salomonoj
      SC:Sejŝeloj
      SD:Sudano
      SE:Svedujo
      SG:Singapuro
      SH:Sankta Heleno
      SI:Slovenujo
      SJ:Svalbardo kaj Janmajeno
      SK:Slovakujo
      SL:Sieraleono
      SM:Sanmarino
      SN:Senegalo
      SO:Somalujo
      SR:Surinamo
      ST:Santomeo kaj Principeo
      SV:Salvadoro
      SY:Sirio
      SZ:Svazilando
      TD:Ĉado
      TG:Togolando
      TH:Tajlando
      TJ:Taĝikujo
      TM:Turkmenujo
      TN:Tunizio
      TO:Tongo
      TR:Turkujo
      TT:Trinidado kaj Tobago
      TV:Tuvalo
      TW:Tajvano
      TZ:Tanzanio
      UA:Ukrainujo
      UG:Ugando
      UM:Usonaj malgrandaj insuloj
      US:Usono
      UY:Urugvajo
      UZ:Uzbekujo
      VA:Vatikano
      VC:Sankta Vincento kaj Grenadinoj
      VE:Venezuelo
      VG:Britaj Virgulininsuloj
      VI:Usonaj Virgulininsuloj
      VN:Vjetnamo
      VU:Vanuatuo
      WF:Valiso kaj Futuno
      WS:Samoo
      YE:Jemeno
      YT:Majoto
      ZA:Sud-Afriko
      ZM:Zambio
      ZW:Zimbabvo
      """.trimIndent() }

  val es: String by lazy { """
      001:Mundo
      002:África
      003:América del Norte
      005:Sudamérica
      009:Oceanía
      011:África occidental
      013:Centroamérica
      014:África oriental
      015:África septentrional
      017:África central
      018:África meridional
      019:América
      021:Norteamérica
      029:Caribe
      030:Asia oriental
      034:Asia meridional
      035:Sudeste asiático
      039:Europa meridional
      053:Australasia
      054:Melanesia
      057:Región de Micronesia
      061:Polinesia
      142:Asia
      143:Asia central
      145:Asia occidental
      150:Europa
      151:Europa oriental
      154:Europa septentrional
      155:Europa occidental
      202:África subsahariana
      419:Latinoamérica
      AC:Isla de la Ascensión
      AD:Andorra
      AE:Emiratos Árabes Unidos
      AF:Afganistán
      AG:Antigua y Barbuda
      AI:Anguila
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antártida
      AR:Argentina
      AS:Samoa Americana
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Islas Aland
      AZ:Azerbaiyán
      BA:Bosnia y Herzegovina
      BB:Barbados
      BD:Bangladés
      BE:Bélgica
      BF:Burkina Faso
      BG:Bulgaria
      BH:Baréin
      BI:Burundi
      BJ:Benín
      BL:San Bartolomé
      BM:Bermudas
      BN:Brunéi
      BO:Bolivia
      BQ:Caribe neerlandés
      BR:Brasil
      BS:Bahamas
      BT:Bután
      BV:Isla Bouvet
      BW:Botsuana
      BY:Bielorrusia
      BZ:Belice
      CA:Canadá
      CC:Islas Cocos
      CD:República Democrática del Congo
      CF:República Centroafricana
      CG:Congo
      CH:Suiza
      CI:Côte d’Ivoire
      CK:Islas Cook
      CL:Chile
      CM:Camerún
      CN:China
      CO:Colombia
      CP:Isla Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cabo Verde
      CW:Curazao
      CX:Isla de Navidad
      CY:Chipre
      CZ:Chequia
      DE:Alemania
      DG:Diego García
      DJ:Yibuti
      DK:Dinamarca
      DM:Dominica
      DO:República Dominicana
      DZ:Argelia
      EA:Ceuta y Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egipto
      EH:Sáhara Occidental
      ER:Eritrea
      ES:España
      ET:Etiopía
      EU:Unión Europea
      EZ:zona del euro
      FI:Finlandia
      FJ:Fiyi
      FK:Islas Malvinas
      FM:Micronesia
      FO:Islas Feroe
      FR:Francia
      GA:Gabón
      GB:Reino Unido
      GD:Granada
      GE:Georgia
      GF:Guayana Francesa
      GG:Guernesey
      GH:Ghana
      GI:Gibraltar
      GL:Groenlandia
      GM:Gambia
      GN:Guinea
      GP:Guadalupe
      GQ:Guinea Ecuatorial
      GR:Grecia
      GS:Islas Georgia del Sur y Sandwich del Sur
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bisáu
      GY:Guyana
      HK:RAE de Hong Kong (China)
      HM:Islas Heard y McDonald
      HN:Honduras
      HR:Croacia
      HT:Haití
      HU:Hungría
      IC:Canarias
      ID:Indonesia
      IE:Irlanda
      IL:Israel
      IM:Isla de Man
      IN:India
      IO:Territorio Británico del Océano Índico
      IQ:Irak
      IR:Irán
      IS:Islandia
      IT:Italia
      JE:Jersey
      JM:Jamaica
      JO:Jordania
      JP:Japón
      KE:Kenia
      KG:Kirguistán
      KH:Camboya
      KI:Kiribati
      KM:Comoras
      KN:San Cristóbal y Nieves
      KP:Corea del Norte
      KR:Corea del Sur
      KW:Kuwait
      KY:Islas Caimán
      KZ:Kazajistán
      LA:Laos
      LB:Líbano
      LC:Santa Lucía
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesoto
      LT:Lituania
      LU:Luxemburgo
      LV:Letonia
      LY:Libia
      MA:Marruecos
      MC:Mónaco
      MD:Moldavia
      ME:Montenegro
      MF:San Martín
      MG:Madagascar
      MH:Islas Marshall
      MK:Macedonia del Norte
      ML:Mali
      MM:Myanmar (Birmania)
      MN:Mongolia
      MO:RAE de Macao (China)
      MP:Islas Marianas del Norte
      MQ:Martinica
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauricio
      MV:Maldivas
      MW:Malaui
      MX:México
      MY:Malasia
      MZ:Mozambique
      NA:Namibia
      NC:Nueva Caledonia
      NE:Níger
      NF:Isla Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Países Bajos
      NO:Noruega
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nueva Zelanda
      OM:Omán
      PA:Panamá
      PE:Perú
      PF:Polinesia Francesa
      PG:Papúa Nueva Guinea
      PH:Filipinas
      PK:Pakistán
      PL:Polonia
      PM:San Pedro y Miquelón
      PN:Islas Pitcairn
      PR:Puerto Rico
      PS:Territorios Palestinos
      PT:Portugal
      PW:Palaos
      PY:Paraguay
      QA:Catar
      QO:Territorios alejados de Oceanía
      RE:Reunión
      RO:Rumanía
      RS:Serbia
      RU:Rusia
      RW:Ruanda
      SA:Arabia Saudí
      SB:Islas Salomón
      SC:Seychelles
      SD:Sudán
      SE:Suecia
      SG:Singapur
      SH:Santa Elena
      SI:Eslovenia
      SJ:Svalbard y Jan Mayen
      SK:Eslovaquia
      SL:Sierra Leona
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Sudán del Sur
      ST:Santo Tomé y Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Siria
      SZ:Esuatini
      TA:Tristán de Acuña
      TC:Islas Turcas y Caicos
      TD:Chad
      TF:Territorios Australes Franceses
      TG:Togo
      TH:Tailandia
      TJ:Tayikistán
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistán
      TN:Túnez
      TO:Tonga
      TR:Turquía
      TT:Trinidad y Tobago
      TV:Tuvalu
      TW:Taiwán
      TZ:Tanzania
      UA:Ucrania
      UG:Uganda
      UM:Islas menores alejadas de EE. UU.
      UN:Naciones Unidas
      US:Estados Unidos
      UY:Uruguay
      UZ:Uzbekistán
      VA:Ciudad del Vaticano
      VC:San Vicente y las Granadinas
      VE:Venezuela
      VG:Islas Vírgenes Británicas
      VI:Islas Vírgenes de EE. UU.
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis y Futuna
      WS:Samoa
      XA:Pseudoacentos
      XB:Pseudobidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:Sudáfrica
      ZM:Zambia
      ZW:Zimbabue
      ZZ:Región desconocida
      """.trimIndent() }

  val es_419: String by lazy { """
      001:mundo
      011:África del Oeste
      014:África del Este
      015:África del Norte
      018:África del Sur
      030:Asia del Este
      034:Asia del Sur
      035:Asia sudoriental
      039:Europa del Sur
      145:Asia del Oeste
      151:Europa del Este
      154:Europa del Norte
      155:Europa del Oeste
      AC:Isla Ascensión
      AX:Islas Åland
      BA:Bosnia-Herzegovina
      CG:República del Congo
      CI:Costa de Marfil
      EZ:Eurozona
      GS:Islas Georgia del Sur y Sándwich del Sur
      IC:Islas Canarias
      QO:Islas Ultramarinas
      RO:Rumania
      SA:Arabia Saudita
      TL:Timor Oriental
      UM:Islas Ultramarinas de EE.UU.
      """.trimIndent() }

  val es_AR: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_BO: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_BR: String? = null

  val es_BZ: String? = null

  val es_CL: String by lazy { """
      BA:Bosnia y Herzegovina
      EH:Sahara Occidental
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_CO: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_CR: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_CU: String? = null

  val es_DO: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_EA: String? = null

  val es_EC: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_GQ: String? = null

  val es_GT: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_HN: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_IC: String? = null

  val es_MX: String by lazy { """
      011:África Occidental
      014:África Oriental
      015:África septentrional
      018:África meridional
      030:Asia Oriental
      034:Asia meridional
      035:Sudeste Asiático
      039:Europa meridional
      145:Asia Occidental
      151:Europa Oriental
      154:Europa septentrional
      155:Europa Occidental
      BA:Bosnia y Herzegovina
      CI:Côte d’Ivoire
      GG:Guernsey
      SZ:Eswatini
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_NI: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_PA: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_PE: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_PH: String? = null

  val es_PR: String by lazy { """
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_PY: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_SV: String by lazy { """
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_US: String by lazy { """
      011:África occidental
      014:África oriental
      015:África septentrional
      018:África meridional
      030:Asia oriental
      034:Asia meridional
      035:Sudeste asiático
      039:Europa meridional
      145:Asia occidental
      151:Europa oriental
      154:Europa septentrional
      155:Europa occidental
      AC:Isla de la Ascensión
      BA:Bosnia y Herzegovina
      EH:Sahara Occidental
      GG:Guernsey
      QO:Territorios alejados de Oceanía
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val es_UY: String? = null

  val es_VE: String by lazy { """
      BA:Bosnia y Herzegovina
      TL:Timor-Leste
      UM:Islas menores alejadas de EE. UU.
      """.trimIndent() }

  val et: String by lazy { """
      001:maailm
      002:Aafrika
      003:Põhja-Ameerika
      005:Lõuna-Ameerika
      009:Okeaania
      011:Lääne-Aafrika
      013:Kesk-Ameerika
      014:Ida-Aafrika
      015:Põhja-Aafrika
      017:Kesk-Aafrika
      018:Lõuna-Aafrika
      019:Ameerika
      021:Ameerika põhjaosa
      029:Kariibi piirkond
      030:Ida-Aasia
      034:Lõuna-Aasia
      035:Kagu-Aasia
      039:Lõuna-Euroopa
      053:Australaasia
      054:Melaneesia
      057:Mikroneesia (piirkond)
      061:Polüneesia
      142:Aasia
      143:Kesk-Aasia
      145:Lääne-Aasia
      150:Euroopa
      151:Ida-Euroopa
      154:Põhja-Euroopa
      155:Lääne-Euroopa
      202:Sahara-tagune Aafrika
      419:Ladina-Ameerika
      AC:Ascensioni saar
      AD:Andorra
      AE:Araabia Ühendemiraadid
      AF:Afganistan
      AG:Antigua ja Barbuda
      AI:Anguilla
      AL:Albaania
      AM:Armeenia
      AO:Angola
      AQ:Antarktika
      AR:Argentina
      AS:Ameerika Samoa
      AT:Austria
      AU:Austraalia
      AW:Aruba
      AX:Ahvenamaa
      AZ:Aserbaidžaan
      BA:Bosnia ja Hertsegoviina
      BB:Barbados
      BD:Bangladesh
      BE:Belgia
      BF:Burkina Faso
      BG:Bulgaaria
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Saint-Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Boliivia
      BQ:Kariibi Madalmaad
      BR:Brasiilia
      BS:Bahama
      BT:Bhutan
      BV:Bouvet’ saar
      BW:Botswana
      BY:Valgevene
      BZ:Belize
      CA:Kanada
      CC:Kookossaared
      CD:Kongo DV
      CF:Kesk-Aafrika Vabariik
      CG:Kongo Vabariik
      CH:Šveits
      CI:Elevandiluurannik
      CK:Cooki saared
      CL:Tšiili
      CM:Kamerun
      CN:Hiina
      CO:Colombia
      CP:Clippertoni saar
      CQ:Sark
      CR:Costa Rica
      CU:Kuuba
      CV:Roheneemesaared
      CW:Curaçao
      CX:Jõulusaar
      CY:Küpros
      CZ:Tšehhi
      DE:Saksamaa
      DG:Diego Garcia
      DJ:Djibouti
      DK:Taani
      DM:Dominica
      DO:Dominikaani Vabariik
      DZ:Alžeeria
      EA:Ceuta ja Melilla
      EC:Ecuador
      EE:Eesti
      EG:Egiptus
      EH:Lääne-Sahara
      ER:Eritrea
      ES:Hispaania
      ET:Etioopia
      EU:Euroopa Liit
      EZ:euroala
      FI:Soome
      FJ:Fidži
      FK:Falklandi saared
      FM:Mikroneesia
      FO:Fääri saared
      FR:Prantsusmaa
      GA:Gabon
      GB:Ühendkuningriik
      GD:Grenada
      GE:Gruusia
      GF:Prantsuse Guajaana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Gröönimaa
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Ekvatoriaal-Guinea
      GR:Kreeka
      GS:Lõuna-Georgia ja Lõuna-Sandwichi saared
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hongkongi erihalduspiirkond
      HM:Heardi ja McDonaldi saared
      HN:Honduras
      HR:Horvaatia
      HT:Haiti
      HU:Ungari
      IC:Kanaari saared
      ID:Indoneesia
      IE:Iirimaa
      IL:Iisrael
      IM:Mani saar
      IN:India
      IO:Briti India ookeani ala
      IQ:Iraak
      IR:Iraan
      IS:Island
      IT:Itaalia
      JE:Jersey
      JM:Jamaica
      JO:Jordaania
      JP:Jaapan
      KE:Keenia
      KG:Kõrgõzstan
      KH:Kambodža
      KI:Kiribati
      KM:Komoorid
      KN:Saint Kitts ja Nevis
      KP:Põhja-Korea
      KR:Lõuna-Korea
      KW:Kuveit
      KY:Kaimanisaared
      KZ:Kasahstan
      LA:Laos
      LB:Liibanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Libeeria
      LS:Lesotho
      LT:Leedu
      LU:Luksemburg
      LV:Läti
      LY:Liibüa
      MA:Maroko
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:Saint-Martin
      MG:Madagaskar
      MH:Marshalli Saared
      MK:Põhja-Makedoonia
      ML:Mali
      MM:Myanmar (Birma)
      MN:Mongoolia
      MO:Macau erihalduspiirkond
      MP:Põhja-Mariaanid
      MQ:Martinique
      MR:Mauritaania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldiivid
      MW:Malawi
      MX:Mehhiko
      MY:Malaisia
      MZ:Mosambiik
      NA:Namiibia
      NC:Uus-Kaledoonia
      NE:Niger
      NF:Norfolk
      NG:Nigeeria
      NI:Nicaragua
      NL:Holland
      NO:Norra
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Uus-Meremaa
      OM:Omaan
      PA:Panama
      PE:Peruu
      PF:Prantsuse Polüneesia
      PG:Paapua Uus-Guinea
      PH:Filipiinid
      PK:Pakistan
      PL:Poola
      PM:Saint-Pierre ja Miquelon
      PN:Pitcairni saared
      PR:Puerto Rico
      PS:Palestiina alad
      PT:Portugal
      PW:Belau
      PY:Paraguay
      QA:Katar
      QO:Okeaania hajasaared
      RE:Réunion
      RO:Rumeenia
      RS:Serbia
      RU:Venemaa
      RW:Rwanda
      SA:Saudi Araabia
      SB:Saalomoni Saared
      SC:Seišellid
      SD:Sudaan
      SE:Rootsi
      SG:Singapur
      SH:Saint Helena
      SI:Sloveenia
      SJ:Svalbard ja Jan Mayen
      SK:Slovakkia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somaalia
      SR:Suriname
      SS:Lõuna-Sudaan
      ST:São Tomé ja Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Süüria
      SZ:Svaasimaa
      TA:Tristan da Cunha
      TC:Turks ja Caicos
      TD:Tšaad
      TF:Prantsuse Lõunaalad
      TG:Togo
      TH:Tai
      TJ:Tadžikistan
      TK:Tokelau
      TL:Ida-Timor
      TM:Türkmenistan
      TN:Tuneesia
      TO:Tonga
      TR:Türgi
      TT:Trinidad ja Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansaania
      UA:Ukraina
      UG:Uganda
      UM:Ühendriikide hajasaared
      UN:Ühinenud Rahvaste Organisatsioon
      US:Ameerika Ühendriigid
      UY:Uruguay
      UZ:Usbekistan
      VA:Vatikan
      VC:Saint Vincent ja Grenadiinid
      VE:Venezuela
      VG:Briti Neitsisaared
      VI:USA Neitsisaared
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis ja Futuna
      WS:Samoa
      XA:pseudo-aktsent
      XB:pseudo-Bidi
      XK:Kosovo
      YE:Jeemen
      YT:Mayotte
      ZA:Lõuna-Aafrika Vabariik
      ZM:Sambia
      ZW:Zimbabwe
      ZZ:tundmatu piirkond
      """.trimIndent() }

  val eu: String by lazy { """
      001:Mundua
      002:Afrika
      003:Ipar Amerika
      005:Hego Amerika
      009:Ozeania
      011:Mendebaldeko Afrika
      013:Erdialdeko Amerika
      014:Ekialdeko Afrika
      015:Ipar Afrika
      017:Erdialdeko Afrika
      018:Hegoaldeko Afrika
      019:Amerika
      021:Amerikako iparraldea
      029:Karibea
      030:Ekialdeko Asia
      034:Hego Asia
      035:Hego-ekialdeko Asia
      039:Hego Europa
      053:Australasia
      054:Melanesia
      057:Mikronesia eskualdea
      061:Polinesia
      142:Asia
      143:Erdialdeko Asia
      145:Mendebaldeko Asia
      150:Europa
      151:Ekialdeko Europa
      154:Ipar Europa
      155:Mendebaldeko Europa
      202:Saharaz hegoaldeko Afrika
      419:Latinoamerika
      AC:Ascension uhartea
      AD:Andorra
      AE:Arabiar Emirerri Batuak
      AF:Afganistan
      AG:Antigua eta Barbuda
      AI:Aingira
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antartika
      AR:Argentina
      AS:Samoa Estatubatuarra
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Åland
      AZ:Azerbaijan
      BA:Bosnia-Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgika
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Saint Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Karibeko Herbehereak
      BR:Brasil
      BS:Bahamak
      BT:Bhutan
      BV:Bouvet uhartea
      BW:Botswana
      BY:Bielorrusia
      BZ:Belize
      CA:Kanada
      CC:Cocos (Keeling) uharteak
      CD:Kongoko Errepublika Demokratikoa
      CF:Afrika Erdiko Errepublika
      CG:Kongo
      CH:Suitza
      CI:Boli Kosta
      CK:Cook uharteak
      CL:Txile
      CM:Kamerun
      CN:Txina
      CO:Kolonbia
      CP:Clipperton uhartea
      CR:Costa Rica
      CU:Kuba
      CV:Cabo Verde
      CW:Curaçao
      CX:Christmas uhartea
      CY:Zipre
      CZ:Txekia
      DE:Alemania
      DG:Diego García
      DJ:Djibuti
      DK:Danimarka
      DM:Dominika
      DO:Dominikar Errepublika
      DZ:Aljeria
      EA:Ceuta eta Melilla
      EC:Ekuador
      EE:Estonia
      EG:Egipto
      EH:Mendebaldeko Sahara
      ER:Eritrea
      ES:Espainia
      ET:Etiopia
      EU:Europar Batasuna
      EZ:Eurogunea
      FI:Finlandia
      FJ:Fiji
      FK:Falklandak
      FM:Mikronesia
      FO:Faroe uharteak
      FR:Frantzia
      GA:Gabon
      GB:Erresuma Batua
      GD:Grenada
      GE:Georgia
      GF:Guyana Frantsesa
      GG:Guernesey
      GH:Ghana
      GI:Gibraltar
      GL:Groenlandia
      GM:Gambia
      GN:Ginea
      GP:Guadalupe
      GQ:Ekuatore Ginea
      GR:Grezia
      GS:Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak
      GT:Guatemala
      GU:Guam
      GW:Ginea Bissau
      GY:Guyana
      HK:Hong Kong Txinako AEB
      HM:Heard eta McDonald uharteak
      HN:Honduras
      HR:Kroazia
      HT:Haiti
      HU:Hungaria
      IC:Kanariak
      ID:Indonesia
      IE:Irlanda
      IL:Israel
      IM:Man uhartea
      IN:India
      IO:Indiako Ozeanoko lurralde britainiarra
      IQ:Irak
      IR:Iran
      IS:Islandia
      IT:Italia
      JE:Jersey
      JM:Jamaika
      JO:Jordania
      JP:Japonia
      KE:Kenya
      KG:Kirgizistan
      KH:Kanbodia
      KI:Kiribati
      KM:Komoreak
      KN:Saint Kitts eta Nevis
      KP:Ipar Korea
      KR:Hego Korea
      KW:Kuwait
      KY:Kaiman uharteak
      KZ:Kazakhstan
      LA:Laos
      LB:Libano
      LC:Santa Luzia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lituania
      LU:Luxenburgo
      LV:Letonia
      LY:Libia
      MA:Maroko
      MC:Monako
      MD:Moldavia
      ME:Montenegro
      MF:San Martin
      MG:Madagaskar
      MH:Marshall Uharteak
      MK:Ipar Mazedonia
      ML:Mali
      MM:Myanmar (Birmania)
      MN:Mongolia
      MO:Macau Txinako AEB
      MP:Ipar Mariana uharteak
      MQ:Martinika
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Maurizio
      MV:Maldivak
      MW:Malawi
      MX:Mexiko
      MY:Malaysia
      MZ:Mozambike
      NA:Namibia
      NC:Kaledonia Berria
      NE:Niger
      NF:Norfolk uhartea
      NG:Nigeria
      NI:Nikaragua
      NL:Herbehereak
      NO:Norvegia
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Zeelanda Berria
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Polinesia Frantsesa
      PG:Papua Ginea Berria
      PH:Filipinak
      PK:Pakistan
      PL:Polonia
      PM:Saint-Pierre eta Mikelune
      PN:Pitcairn uharteak
      PR:Puerto Rico
      PS:Palestinar Lurralde Okupatuak
      PT:Portugal
      PW:Palau
      PY:Paraguai
      QA:Qatar
      QO:Mugaz kanpoko Ozeania
      RE:Reunion
      RO:Errumania
      RS:Serbia
      RU:Errusia
      RW:Ruanda
      SA:Saudi Arabia
      SB:Salomon Uharteak
      SC:Seychelleak
      SD:Sudan
      SE:Suedia
      SG:Singapur
      SH:Santa Helena
      SI:Eslovenia
      SJ:Svalbard eta Jan Mayen uharteak
      SK:Eslovakia
      SL:Sierra Leona
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Hego Sudan
      ST:Sao Tome eta Principe
      SV:El Salvador
      SX:Sint Maarten
      SY:Siria
      SZ:Swazilandia
      TA:Tristan da Cunha
      TC:Turk eta Caico uharteak
      TD:Txad
      TF:Hegoaldeko lurralde frantsesak
      TG:Togo
      TH:Thailandia
      TJ:Tajikistan
      TK:Tokelau
      TL:Ekialdeko Timor
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turkia
      TT:Trinidad eta Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraina
      UG:Uganda
      UM:Ameriketako Estatu Batuetako Kanpoaldeko Uharte Txikiak
      UN:Nazio Batuak
      US:Ameriketako Estatu Batuak
      UY:Uruguai
      UZ:Uzbekistan
      VA:Vatikano Hiria
      VC:Saint Vincent eta Grenadinak
      VE:Venezuela
      VG:Birjina uharte britainiarrak
      VI:Birjina uharte amerikarrak
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis eta Futuna
      WS:Samoa
      XA:Sasiazentuak
      XB:Pseudobidia
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:Hegoafrika
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Eskualde ezezaguna
      """.trimIndent() }

  val ewo: String by lazy { """
      AD:Andór
      AE:Bemirá yá Arábə uní
      AF:Afəganisətán
      AG:Antígwa ai Barəbúda
      AI:Angíyə
      AL:Aləbánia
      AM:Arəménia
      AO:Angolá
      AR:Arəhenətína
      AS:Bəsamóa yá Amə́rəka
      AT:Osətəlía
      AU:Osətəlalí
      AW:Arúba
      AZ:Azɛrəbaidzáŋ
      BA:Bosəní ai ɛrəzegovín
      BB:Barəbád
      BD:Bangaladɛ́s
      BE:Bɛləhíg
      BF:Buləkiná Fasó
      BG:Buləgarí
      BH:Bahərɛ́n
      BI:Burundí
      BJ:Bəníŋ
      BM:Bɛrəmúd
      BN:Buluné
      BO:Bolívia
      BR:Bəlazíl
      BS:Bahámas
      BT:Butáŋ
      BW:Botswaná
      BY:Bəlarús
      BZ:Bəlís
      CA:kanadá
      CD:ǹnam Kongó Demokəlatíg
      CF:ǹnam Zǎŋ Afiriká
      CG:Kongó
      CH:Suís
      CI:Kód Divɔ́r
      CK:Minlán Mí kúg
      CL:Tsilí
      CM:Kamərún
      CN:Tsáina
      CO:Kolɔmbí
      CR:Kosta Ríka
      CU:Kubá
      CV:Minlán Mí Káb Vɛr
      CY:Sipəlús
      CZ:Ǹnam Tsɛ́g
      DE:Ndzáman
      DJ:Dzibutí
      DK:Danəmárəg
      DM:Dómənika
      DO:République dominicaine
      DZ:Aləyéria
      EC:Ekwatór
      EE:Esetoní
      EG:Ehíbətɛn
      ER:Elitəlé
      ES:Kpənyá
      ET:Etiopí
      FI:Finəlán
      FJ:Fidzí
      FK:Minlán Mi Fóləkəlan
      FM:Mikoronésia
      FR:Fulɛnsí
      GA:Gabóŋ
      GB:Ǹnam Engəlis
      GD:Gələnádə
      GE:Horə́yia
      GF:Guyán yá Fulɛnsí
      GH:Ganá
      GI:Yiləbalatár
      GL:Goelán
      GM:Gambí
      GN:Giné
      GP:Guadəlúb
      GQ:Giné Ekwató
      GR:Gəlɛ́s
      GT:Guatemalá
      GU:Guám
      GW:Giné Bisaó
      GY:Guyán
      HN:Ondurás
      HR:Kəlowásia
      HT:Aití
      HU:Ongirí
      ID:ɛndonésia
      IE:Irəlándə
      IL:Isəraɛ́l
      IN:ɛ́ndə
      IQ:Irág
      IR:Irán
      IS:Isəlándə
      IT:Itáliɛn
      JM:Hamaíka
      JO:Horədaní
      JP:Hapɔ́n
      KE:Keniá
      KG:Kirigisətán
      KH:kambodía
      KI:Kiribatí
      KM:Komɔ́r
      KN:Ǹfúfúb-Kilisətóv-ai-Nevis
      KP:Koré yá Nór
      KR:Koré yá Súd
      KW:Kowɛ́d
      KY:Minlán Mí Kalimáŋ
      KZ:Kazakətáŋ
      LA:Laós
      LB:Libáŋ
      LC:Ǹfúfúb-Lúsia
      LI:Lísə́sə́táin
      LK:Səri Laŋká
      LR:Libéria
      LS:Ləsotó
      LT:Lituaní
      LU:Lukəzambúd
      LV:Lətoní
      LY:Libí
      MA:Marɔ́g
      MC:Mɔnakó
      MD:Molədaví
      MG:Madagasəkárə
      MH:Minlán Mí Maresál
      ML:Malí
      MM:Mianəmár
      MN:Mɔngɔ́lia
      MP:Minlán Mi Marián yá Nór
      MQ:Marətiníg
      MR:Moritaní
      MS:Mɔ́ntserád
      MT:Málətə
      MU:Morís
      MV:Malədívə
      MW:Malawí
      MX:Mɛkəsíg
      MY:Malɛ́zia
      MZ:Mozambíg
      NA:Namibí
      NC:Ǹkpámɛn Kaledónia
      NE:Nihɛ́r
      NF:Minlán Nɔrəfɔ́ləkə
      NG:Nihéria
      NI:Nikarágua
      NL:Pɛíbá
      NO:Nɔrəvɛ́s
      NP:Nepál
      NR:Naurú
      NU:Niué
      NZ:Ǹkpámɛn Zeláŋ
      OM:Omán
      PA:Panamá
      PE:Perú
      PF:Polinesí yá Fulɛnsí
      PG:Papwazi yá Ǹkpámɛ́n Giné
      PH:Filipín
      PK:Pakisətán
      PL:fólis
      PM:Ǹfúfúb-Píɛr-ai-Mikəlɔ́ŋ
      PN:Pítə́kɛ́rɛnə
      PR:Pwɛrəto Ríko
      PS:Ǹnam Palɛsətín
      PT:fɔrətugɛ́s
      PW:Palau
      PY:Paragué
      QA:Katár
      RE:Reuniɔ́ŋ
      RO:Rumaní
      RU:Rúsian
      RW:Ruwandá
      SA:Arabí Saudí
      SB:Minlán Mí Solomɔ́n
      SC:Sɛsɛ́l
      SD:Sudáŋ
      SE:Suwɛ́d
      SG:Singapúr
      SH:Ǹfúfúb-Ɛlɛ́na
      SI:Səlovénia
      SK:Səlovakí
      SL:Sierá-leónə
      SM:Ǹfúfúb Maríno
      SN:Senegál
      SO:Somália
      SR:Surinám
      ST:Saó Tomé ai Pəlinəsípe
      SV:Saləvadór
      SY:Sirí
      SZ:Swazilándə
      TC:Minlán Mí túrə́g-ai-Kaíg
      TD:Tsád
      TG:Togó
      TH:Tailán
      TJ:Tadzikisətáŋ
      TK:Tokeló
      TL:Timôr
      TM:Turəkəmənisətáŋ
      TN:Tunisí
      TO:Tɔngá
      TR:Turəkí
      TT:Təlinité-ai-Tobágo
      TV:Tuvalú
      TW:Taiwán
      TZ:Taŋəzaní
      UA:Ukərɛ́n
      UG:Ugandá
      US:Ǹnam Amɛrəkə
      UY:Urugué
      UZ:Uzubekisətán
      VA:Ǹnam Vatikán
      VC:Ǹfúfúb-Vɛngəsáŋ-ai-Bə Gələnadín
      VE:Venezuéla
      VG:ńnam Minlán ɛ́ngəlís
      VI:Minlán Mi Amɛrəkə
      VN:Viɛdənám
      VU:Vanuátu
      WF:Walís-ai-Futúna
      WS:Samoá
      YE:Yemɛ́n
      YT:Mayɔ́d
      ZA:Afiríka yá Súd
      ZM:Zambí
      ZW:Zimbabwé
      """.trimIndent() }

  val fa: String by lazy { """
      001:جهان
      002:افریقا
      003:امریکای شمالی
      005:امریکای جنوبی
      009:اقیانوسیه
      011:غرب افریقا
      013:امریکای مرکزی
      014:شرق افریقا
      015:شمال افریقا
      017:مرکز افریقا
      018:جنوب افریقا
      019:امریکا
      021:شمال امریکا
      029:کارائیب
      030:شرق آسیا
      034:جنوب آسیا
      035:جنوب شرق آسیا
      039:جنوب اروپا
      053:استرالزی
      054:ملانزی
      057:ناحیهٔ میکرونزی
      061:پلی‌نزی
      142:آسیا
      143:آسیای مرکزی
      145:غرب آسیا
      150:اروپا
      151:شرق اروپا
      154:شمال اروپا
      155:غرب اروپا
      202:افریقای جنوب صحرا
      419:امریکای لاتین
      AC:جزایر آسنسیون
      AD:آندورا
      AE:امارات متحدهٔ عربی
      AF:افغانستان
      AG:آنتیگوا و باربودا
      AI:آنگویلا
      AL:آلبانی
      AM:ارمنستان
      AO:آنگولا
      AQ:جنوبگان
      AR:آرژانتین
      AS:ساموآی امریکا
      AT:اتریش
      AU:استرالیا
      AW:آروبا
      AX:جزایر آلاند
      AZ:جمهوری آذربایجان
      BA:بوسنی و هرزگوین
      BB:باربادوس
      BD:بنگلادش
      BE:بلژیک
      BF:بورکینافاسو
      BG:بلغارستان
      BH:بحرین
      BI:بوروندی
      BJ:بنین
      BL:سن بارتلمی
      BM:برمودا
      BN:برونئی
      BO:بولیوی
      BQ:جزایر کارائیب هلند
      BR:برزیل
      BS:باهاما
      BT:بوتان
      BV:جزیرهٔ بووه
      BW:بوتسوانا
      BY:بلاروس
      BZ:بلیز
      CA:کانادا
      CC:جزایر کوکوس
      CD:کنگو - کینشاسا
      CF:جمهوری افریقای مرکزی
      CG:کنگو - برازویل
      CH:سوئیس
      CI:ساحل عاج
      CK:جزایر کوک
      CL:شیلی
      CM:کامرون
      CN:چین
      CO:کلمبیا
      CP:جزایر کلیپرتون
      CR:کاستاریکا
      CU:کوبا
      CV:کیپ‌ورد
      CW:کوراسائو
      CX:جزیرهٔ کریسمس
      CY:قبرس
      CZ:چک
      DE:آلمان
      DG:دیه‌گو گارسیا
      DJ:جیبوتی
      DK:دانمارک
      DM:دومینیکا
      DO:جمهوری دومینیکن
      DZ:الجزایر
      EA:سبته و ملیله
      EC:اکوادور
      EE:استونی
      EG:مصر
      EH:صحرای غربی
      ER:اریتره
      ES:اسپانیا
      ET:اتیوپی
      EU:اتحادیهٔ اروپا
      EZ:منطقهٔ یورو
      FI:فنلاند
      FJ:فیجی
      FK:جزایر فالکلند
      FM:میکرونزی
      FO:جزایر فارو
      FR:فرانسه
      GA:گابن
      GB:بریتانیا
      GD:گرنادا
      GE:گرجستان
      GF:گویان فرانسه
      GG:گرنزی
      GH:غنا
      GI:جبل‌الطارق
      GL:گرینلند
      GM:گامبیا
      GN:گینه
      GP:گوادلوپ
      GQ:گینهٔ استوایی
      GR:یونان
      GS:جورجیای جنوبی و جزایر ساندویچ جنوبی
      GT:گواتمالا
      GU:گوام
      GW:گینهٔ بیسائو
      GY:گویان
      HK:هنگ‌کنگ، منطقهٔ ویژهٔ اداری چین
      HM:هرد و جزایر مک‌دونالد
      HN:هندوراس
      HR:کرواسی
      HT:هائیتی
      HU:مجارستان
      IC:جزایر قناری
      ID:اندونزی
      IE:ایرلند
      IL:اسرائیل
      IM:جزیرهٔ من
      IN:هند
      IO:قلمرو بریتانیا در اقیانوس هند
      IQ:عراق
      IR:ایران
      IS:ایسلند
      IT:ایتالیا
      JE:جرزی
      JM:جامائیکا
      JO:اردن
      JP:ژاپن
      KE:کنیا
      KG:قرقیزستان
      KH:کامبوج
      KI:کیریباتی
      KM:کومور
      KN:سنت کیتس و نویس
      KP:کرهٔ شمالی
      KR:کرهٔ جنوبی
      KW:کویت
      KY:جزایر کِیمن
      KZ:قزاقستان
      LA:لائوس
      LB:لبنان
      LC:سنت لوسیا
      LI:لیختن‌اشتاین
      LK:سری‌لانکا
      LR:لیبریا
      LS:لسوتو
      LT:لیتوانی
      LU:لوکزامبورگ
      LV:لتونی
      LY:لیبی
      MA:مراکش
      MC:موناکو
      MD:مولداوی
      ME:مونته‌نگرو
      MF:سنت مارتین
      MG:ماداگاسکار
      MH:جزایر مارشال
      MK:مقدونیهٔ شمالی
      ML:مالی
      MM:میانمار (برمه)
      MN:مغولستان
      MO:ماکائو، منطقهٔ ویژهٔ اداری چین
      MP:جزایر ماریانای شمالی
      MQ:مارتینیک
      MR:موریتانی
      MS:مونت‌سرات
      MT:مالت
      MU:موریس
      MV:مالدیو
      MW:مالاوی
      MX:مکزیک
      MY:مالزی
      MZ:موزامبیک
      NA:نامیبیا
      NC:کالدونیای جدید
      NE:نیجر
      NF:جزیرهٔ نورفولک
      NG:نیجریه
      NI:نیکاراگوئه
      NL:هلند
      NO:نروژ
      NP:نپال
      NR:نائورو
      NU:نیوئه
      NZ:نیوزیلند
      OM:عمان
      PA:پاناما
      PE:پرو
      PF:پلی‌نزی فرانسه
      PG:پاپوا گینهٔ نو
      PH:فیلیپین
      PK:پاکستان
      PL:لهستان
      PM:سن پیر و میکلن
      PN:جزایر پیت‌کرن
      PR:پورتوریکو
      PS:سرزمین‌های فلسطینی
      PT:پرتغال
      PW:پالائو
      PY:پاراگوئه
      QA:قطر
      QO:بخش‌های دورافتادهٔ اقیانوسیه
      RE:رئونیون
      RO:رومانی
      RS:صربستان
      RU:روسیه
      RW:رواندا
      SA:عربستان سعودی
      SB:جزایر سلیمان
      SC:سیشل
      SD:سودان
      SE:سوئد
      SG:سنگاپور
      SH:سنت هلن
      SI:اسلوونی
      SJ:سوالبارد و یان ماین
      SK:اسلواکی
      SL:سیرالئون
      SM:سان‌مارینو
      SN:سنگال
      SO:سومالی
      SR:سورینام
      SS:سودان جنوبی
      ST:سائوتومه و پرینسیپ
      SV:السالوادور
      SX:سنت مارتن
      SY:سوریه
      SZ:اسواتینی
      TA:تریستان دا کونا
      TC:جزایر تورکس و کایکوس
      TD:چاد
      TF:سرزمین‌های جنوبی فرانسه
      TG:توگو
      TH:تایلند
      TJ:تاجیکستان
      TK:توکلائو
      TL:تیمور-لسته
      TM:ترکمنستان
      TN:تونس
      TO:تونگا
      TR:ترکیه
      TT:ترینیداد و توباگو
      TV:تووالو
      TW:تایوان
      TZ:تانزانیا
      UA:اوکراین
      UG:اوگاندا
      UM:جزایر دورافتادهٔ ایالات متحده
      UN:سازمان ملل متحد
      US:ایالات متحده
      UY:اروگوئه
      UZ:ازبکستان
      VA:واتیکان
      VC:سنت وینسنت و گرنادین
      VE:ونزوئلا
      VG:جزایر ویرجین بریتانیا
      VI:جزایر ویرجین ایالات متحده
      VN:ویتنام
      VU:وانواتو
      WF:والیس و فوتونا
      WS:ساموآ
      XA:انگلیسی با لهجه خارجی
      XB:مجازی - دوجهته
      XK:کوزوو
      YE:یمن
      YT:مایوت
      ZA:افریقای جنوبی
      ZM:زامبیا
      ZW:زیمبابوه
      ZZ:ناحیهٔ نامشخص
      """.trimIndent() }

  val fa_AF: String by lazy { """
      AD:اندورا
      AG:انتیگوا و باربودا
      AL:البانیا
      AO:انگولا
      AQ:انترکتیکا
      AR:ارجنتاین
      BA:بوسنیا و هرزه‌گوینا
      BD:بنگله‌دیش
      BE:بلجیم
      BG:بلغاریا
      BN:برونی
      BO:بولیویا
      BR:برازیل
      BS:بهاماس
      CD:کانگو - کینشاسا
      CG:کانگو - برازویل
      CH:سویس
      CL:چلی
      CO:کولمبیا
      CR:کاستریکا
      CU:کیوبا
      DK:دنمارک
      EA:سئوتا و ملیلا
      EE:استونیا
      ER:اریتریا
      ES:هسپانیه
      ET:ایتوپیا
      FI:فنلند
      FM:میکرونزیا
      GD:گرینادا
      GH:گانا
      GN:گینیا
      GQ:گینیا استوایی
      GT:گواتیمالا
      GW:گینیا بیسائو
      GY:گیانا
      HK:هانگ کانگ، ناحیهٔ ویژهٔ حکومتی چین
      HN:هاندوراس
      HR:کروشیا
      HT:هایتی
      ID:اندونیزیا
      IE:آیرلند
      IS:آیسلند
      JP:جاپان
      KE:کینیا
      KH:کمپوچیا
      KP:کوریای شمالی
      KR:کوریای جنوبی
      LK:سریلانکا
      LS:لیسوتو
      LT:لتوانیا
      LV:لاتویا
      LY:لیبیا
      MG:مادغاسکر
      MN:منگولیا
      MR:موریتانیا
      MT:مالتا
      MX:مکسیکو
      MY:مالیزیا
      MZ:موزمبیق
      NG:نیجریا
      NI:نیکاراگوا
      NL:هالند
      NO:ناروی
      NP:نیپال
      NZ:زیلاند جدید
      PA:پانامه
      PE:پیرو
      PG:پاپوا نیو گینیا
      PL:پولند
      PT:پرتگال
      PY:پاراگوای
      RO:رومانیا
      SE:سویدن
      SG:سینگاپور
      SI:سلونیا
      SJ:اسوالبارد و جان ماین
      SK:سلواکیا
      SL:سیرالیون
      SN:سینیگال
      SO:سومالیه
      SV:السلوادور
      TJ:تاجکستان
      UG:یوگاندا
      UY:یوروگوای
      VC:سنت وینسنت و گرنادین‌ها
      VE:ونزویلا
      XK:کوسوا
      ZW:زیمبابوی
      """.trimIndent() }

  val ff: String by lazy { """
      AD:Anndoora
      AE:Emiraat Araab Denntuɗe
      AF:Afganistaan
      AG:Antiguwaa e Barbudaa
      AI:Anngiyaa
      AL:Albanii
      AM:Armenii
      AO:Anngolaa
      AR:Arjantiin
      AS:Samowa Amerik
      AT:Otiriis
      AU:Ostaraalii
      AW:Aruuba
      AZ:Ajerbayjaan
      BA:Bosnii Hersegowiin
      BB:Barbadoos
      BD:Banglaadees
      BE:Beljik
      BF:Burkibaa Faaso
      BG:Bulgarii
      BH:Bahreyn
      BI:Burunndi
      BJ:Benee
      BM:Bermudaa
      BN:Burnaay
      BO:Boliwii
      BR:Beresiil
      BS:Bahamaas
      BT:Butaan
      BW:Botswaana
      BY:Belaruus
      BZ:Beliise
      CA:Kanadaa
      CD:Ndenndaandi Demokaraasiire Konngo
      CF:Ndenndaandi Santarafrik
      CG:Konngo
      CH:Suwiis
      CI:Kodduwaar
      CK:Duuɗe Kuuk
      CL:Cilii
      CM:Kameruun
      CN:Siin
      CO:Kolombiya
      CR:Kosta Rikaa
      CU:Kubaa
      CV:Duuɗe Kap Weer
      CY:Siipar
      CZ:Ndenndaandi Cek
      DE:Almaañ
      DJ:Jibutii
      DK:Danmark
      DM:Dominika
      DO:Ndenndanndi Dominika
      DZ:Alaseri
      EC:Ekuwatoor
      EE:Estoni
      EG:Ejipt
      ER:Eriteree
      ES:Espaañ
      ET:Ecoppi
      FI:Fenland
      FJ:Fijji
      FK:Duuɗe Falkland
      FM:Mikoronesii
      FR:Farayse
      GA:Gaboo
      GB:Laamateeri Rentundi
      GD:Garnaad
      GE:Jeorgii
      GF:Giyaan Farayse
      GH:Ganaa
      GI:Jibraltaar
      GL:Gorwendland
      GM:Gammbi
      GN:Gine
      GP:Gwaadalup
      GQ:Ginee Ekuwaatoriyaal
      GR:Gerees
      GT:Gwaatemalaa
      GU:Guwam
      GW:Gine-Bisaawo
      GY:Giyaan
      HN:Onnduraas
      HR:Korwasii
      HT:Haytii
      HU:Onngiri
      ID:Enndonesii
      IE:Irlannda
      IL:Israa’iila
      IN:Enndo
      IQ:Iraak
      IR:Iraan
      IS:Islannda
      IT:Itali
      JM:Jamayka
      JO:Jordani
      JP:Sapoo
      KE:Keñaa
      KG:Kirgistaan
      KH:Kambodso
      KI:Kiribari
      KM:Komoor
      KN:Sent Kits e Newis
      KP:Koree Rewo
      KR:Koree Worgo
      KW:Kuweyti
      KY:Duuɗe Kaymaa
      KZ:Kasakstaan
      LA:Lawoos
      LB:Libaa
      LC:Sent Lusiyaa
      LI:Lincenstayn
      LK:Siri Lanka
      LR:Liberiyaa
      LS:Lesoto
      LT:Lituaanii
      LU:Liksembuur
      LV:Letonii
      LY:Libi
      MA:Maruk
      MC:Monaakoo
      MD:Moldawii
      MG:Madagaskaar
      MH:Duuɗe Marsaal
      ML:Maali
      MM:Miyamaar
      MN:Monngolii
      MP:Duuɗe Mariyaana Rewo
      MQ:Martinik
      MR:Muritani
      MS:Monseraat
      MT:Malte
      MU:Moriis
      MV:Maldiiwe
      MW:Malaawi
      MX:Meksik
      MY:Malesii
      MZ:Mosammbik
      NA:Namibii
      NC:Nuwel Kaledonii
      NE:Nijeer
      NF:Duuɗe Norfolk
      NG:Nijeriyaa
      NI:Nikaraguwaa
      NL:Nederlannda
      NO:Norwees
      NP:Nepaal
      NR:Nawuru
      NU:Niuwe
      NZ:Nuwel Selannda
      OM:Omaan
      PA:Panamaa
      PE:Peru
      PF:Polinesii Farayse
      PG:Papuwaa Nuwel Gine
      PH:Filipiin
      PK:Pakistaan
      PL:Poloñ
      PM:See Piyeer e Mikeloo
      PN:Pitkern
      PR:Porto Rikoo
      PS:Palestiin Sisjordani e Gaasaa
      PT:Purtugaal
      PW:Palawu
      PY:Paraguwaay
      QA:Kataar
      RE:Rewiñoo
      RO:Rumanii
      RU:Riisii
      RW:Ruwanndaa
      SA:Arabii Sawdit
      SB:Duuɗe Solomon
      SC:Seysel
      SD:Sudaan
      SE:Suweed
      SG:Sinngapuur
      SH:Sent Helen
      SI:Slowenii
      SK:Slowakii
      SL:Seraa liyon
      SM:See Maree
      SN:Senegaal
      SO:Somalii
      SR:Surinaam
      ST:Sawo Tome e Perensipe
      SV:El Salwador
      SY:Sirii
      SZ:Swaasilannda
      TC:Duuɗe Turke e Keikoos
      TD:Caad
      TG:Togoo
      TH:Taylannda
      TJ:Tajikistaan
      TK:Tokelaaw
      TL:Timoor Fuɗnaange
      TM:Turkmenistaan
      TN:Tunisii
      TO:Tonngaa
      TR:Turkii
      TT:Tirnidaad e Tobaago
      TV:Tuwaluu
      TW:Taywaan
      TZ:Tansanii
      UA:Ukereen
      UG:Unganndaa
      US:Dowlaaji Dentuɗi Amerik
      UY:Uruguwaay
      UZ:Usbekistaan
      VA:Dowla Waticaan
      VC:See Weesaa e Garnadiin
      VE:Wenesuwelaa
      VG:duuɗe kecce britanii
      VI:Duuɗe Kecce Amerik
      VN:Wiyetnaam
      VU:Wanuwaatuu
      WF:Walis e Futuna
      WS:Samowaa
      YE:Yemen
      YT:Mayoot
      ZA:Afrik bŋ Worgo
      ZM:Sammbi
      ZW:Simbaabuwe
      """.trimIndent() }

  val ff_Adlm: String by lazy { """
      001:𞤀𞤣𞤵𞤲𞤢
      002:𞤀𞤬𞤪𞤭𞤳𞤢𞥄
      003:𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫 𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄
      005:𞤙𞤢𞤥𞤲𞤢𞥄𞤲𞤺𞤫 𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄
      009:𞤌𞤧𞤭𞤴𞤢𞤲𞤭𞥅
      011:𞤖𞤭𞥅𞤪𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞥄
      013:𞤚𞤵𞤥𞤦𞤮 𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄
      014:𞤊𞤵𞤯𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞥄
      015:𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞥄
      017:𞤚𞤵𞤥𞤦𞤮 𞤀𞤬𞤪𞤭𞤳𞤢𞥄
      018:𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞥄
      019:𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄
      021:𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄
      029:𞤑𞤢𞤪𞤦𞤭𞤴𞤢𞥄
      030:𞤊𞤵𞤯𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞥄𞤧𞤭𞤴𞤢
      034:𞤙𞤢𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞥄𞤧𞤭𞤴𞤢
      035:𞤙𞤢𞤥𞤬𞤭𞤯𞤲𞤢𞥄𞤲𞤺𞤫 𞤀𞥄𞤧𞤭𞤴𞤢
      039:𞤙𞤢𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤓𞤪𞤨𞤢
      053:𞤀𞤧𞤼𞤢𞤪𞤤𞤢𞥄𞤧𞤭𞤴𞤢𞥄
      054:𞤃𞤭𞤤𞤢𞤲𞤭𞥅𞤧𞤴𞤢
      057:𞤖𞤭𞤤𞥆𞤮 𞤃𞤭𞤳𞤪𞤮𞤲𞤭𞥅𞤧𞤸𞤮
      061:𞤆𞤮𞤤𞤭𞤲𞤭𞥅𞤧𞤴𞤢
      142:𞤀𞥄𞤧𞤭𞤴𞤢
      143:𞤚𞤵𞤥𞤦𞤮𞥅𞤪𞤭 𞤀𞥄𞤧𞤭𞤴𞤢
      145:𞤖𞤭𞥅𞤪𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞥄𞤧𞤭𞤴𞤢
      150:𞤓𞤪𞤨𞤢
      151:𞤊𞤵𞤯𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤓𞤪𞤨𞤢
      154:𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤓𞤪𞤨𞤢
      155:𞤖𞤭𞥅𞤪𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤓𞤪𞤨𞤢
      202:𞤀𞤬𞤪𞤭𞤳𞤢𞥄 𞤂𞤫𞤧-𞤅𞤢𞥄𞤸𞤢𞤪𞤢
      419:𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄 𞤂𞤢𞤼𞤭𞤲𞤳𞤮
      AC:𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤀𞤧𞤢𞤲𞤧𞤮𞥅𞤲
      AD:𞤀𞤲𞤣𞤮𞤪𞤢𞥄
      AE:𞤁𞤫𞤲𞤼𞤢𞤤 𞤋𞤥𞤪𞤢𞥄𞤼𞤭 𞤀𞥄𞤪𞤢𞤦𞤵
      AF:𞤀𞤬𞤺𞤢𞤲𞤭𞤧𞤼𞤢𞥄𞤲
      AG:𞤀𞤲𞤼𞤭𞤺𞤵𞤱𞤢 & 𞤄𞤢𞤪𞤦𞤵𞥅𞤣𞤢
      AI:𞤀𞤲𞤺𞤭𞤤𞤢𞥄
      AL:𞤀𞤤𞤦𞤢𞤲𞤭𞤴𞤢𞥄
      AM:𞤀𞤪𞤥𞤫𞤲𞤭𞤴𞤢𞥄
      AO:𞤀𞤲𞤺𞤮𞤤𞤢𞥄
      AQ:𞤀𞤲𞤼𞤢𞤪𞤼𞤭𞤳𞤢𞥄
      AR:𞤀𞤪𞤶𞤢𞤲𞤼𞤭𞤲𞤢𞥄
      AS:𞤅𞤢𞤥𞤵𞤱𞤢 𞤀𞤥𞤫𞤪𞤭𞤳𞤭𞤴𞤢𞤲𞤳𞤮
      AT:𞤌𞤼𞤭𞤪𞤧𞤢
      AU:𞤌𞤧𞤼𞤢𞤪𞤤𞤭𞤴𞤢𞥄
      AW:𞤀𞤪𞤵𞤦𞤢𞥄
      AX:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤀𞤤𞤢𞤲𞤣
      AZ:𞤀𞥁𞤫𞤪𞤦𞤢𞤭𞤶𞤢𞥄𞤲
      BA:𞤄𞤮𞤧𞤲𞤭𞤴𞤢 & 𞤖𞤫𞤪𞤧𞤫𞤳𞤮𞤾𞤭𞤲𞤢𞥄
      BB:𞤄𞤢𞤪𞤦𞤫𞥅𞤣𞤮𞥅𞤧
      BD:𞤄𞤢𞤲𞤺𞤭𞤤𞤢𞤣𞤫𞥅𞤧
      BE:𞤄𞤫𞤤𞤶𞤭𞤳𞤢𞥄
      BF:𞤄𞤵𞤪𞤳𞤭𞤲𞤢 𞤊𞤢𞤧𞤮𞥅
      BG:𞤄𞤵𞥅𞤤𞤺𞤢𞤪𞤭𞤴𞤢𞥄
      BH:𞤄𞤢𞤸𞤢𞤪𞤢𞤴𞤲
      BI:𞤄𞤵𞤪𞤵𞤲𞤣𞤭
      BJ:𞤄𞤫𞤲𞤫𞤲
      BL:𞤅𞤼. 𞤄𞤢𞤪𞤼𞤫𞤤𞤭𞤥𞤭
      BM:𞤄𞤭𞤪𞤥𞤵𞤣𞤢
      BN:𞤄𞤵𞤪𞤲𞤢𞥄𞤴
      BO:𞤄𞤮𞤤𞤭𞥅𞤾𞤭𞤴𞤢𞥄
      BQ:𞤑𞤢𞤪𞤦𞤭𞤴𞤢𞥄 𞤖𞤮𞤤𞤢𞤲𞤣𞤭𞤴𞤢𞥄
      BR:𞤄𞤪𞤢𞤧𞤭𞤤
      BS:𞤄𞤢𞤸𞤢𞤥𞤢𞥄𞤧
      BT:𞤄𞤵𞥅𞤼𞤢𞥄𞤲
      BV:𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤄𞤵𞥅𞤾𞤫𞥅
      BW:𞤄𞤮𞤼𞤧𞤵𞤱𞤢𞥄𞤲𞤢
      BY:𞤄𞤫𞤤𞤢𞤪𞤵𞥅𞤧
      BZ:𞤄𞤫𞤤𞤭𞥅𞥁
      CA:𞤑𞤢𞤲𞤢𞤣𞤢𞥄
      CC:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤑𞤮𞤳𞤮𞥅𞤧 (𞤑𞤭𞥅𞤤𞤭𞤲𞤺)
      CD:𞤑𞤮𞤲𞤺𞤮 - 𞤑𞤭𞤲𞤧𞤢𞤧𞤢
      CF:𞤐𞤣𞤫𞤲𞤣𞤭 𞤚𞤵𞤥𞤦𞤮𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞥄
      CG:𞤑𞤮𞤲𞤺𞤮 - 𞤄𞤪𞤢𞥁𞤢𞤾𞤭𞤤
      CH:𞤅𞤵𞤱𞤭𞤪𞤧𞤢𞥄
      CI:𞤑𞤮𞤼𞤣𞤭𞤾𞤢𞥄𞤪
      CK:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤑𞤵𞥅𞤳
      CL:𞤕𞤭𞤤𞤫𞥊𞥅
      CM:𞤑𞤢𞤥𞤢𞤪𞤵𞥅𞤲
      CN:𞤕𞤢𞤴𞤲𞤢
      CO:𞤑𞤮𞤤𞤮𞤥𞤦𞤭𞤴𞤢𞥄
      CP:𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤑𞤭𞤤𞤭𞤨𞤫𞤪𞤼𞤮𞤲
      CR:𞤑𞤮𞤧𞤼𞤢 𞤈𞤭𞤳𞤢𞥄
      CU:𞤑𞤵𞥅𞤦𞤢𞥄
      CV:𞤑𞤢𞥄𞤦𞤮 𞤜𞤫𞤪𞤣𞤫
      CW:𞤑𞤵𞥅𞤪𞤢𞤧𞤢𞤱𞤮
      CX:𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤑𞤭𞤪𞤧𞤭𞤥𞤢𞥄𞤧
      CY:𞤑𞤵𞤦𞤪𞤵𞥅𞤧
      CZ:𞤕𞤫𞥅𞤳𞤭𞤴𞤢𞥄
      DE:𞤔𞤫𞤪𞤥𞤢𞤲𞤭𞥅
      DG:𞤔𞤮𞤺𞤮 𞤘𞤢𞥄𞤪𞤧𞤭𞤴𞤢
      DJ:𞤔𞤭𞤦𞤵𞥅𞤼𞤭
      DK:𞤁𞤢𞤲𞤵𞤥𞤢𞤪𞤳
      DM:𞤁𞤮𞤥𞤭𞤲𞤭𞤳𞤢𞥄
      DO:𞤐𞤣𞤫𞤲𞤣𞤭 𞤁𞤮𞤥𞤭𞤲𞤭𞤳𞤢𞥄
      DZ:𞤀𞤤𞤶𞤢𞤪𞤭𞥅
      EA:𞤅𞤭𞤼𞥆𞤢 & 𞤃𞤫𞤤𞤭𞤤𞤢
      EC:𞤉𞤳𞤵𞤱𞤢𞤣𞤮𞥅𞤪
      EE:𞤉𞤧𞤼𞤮𞤲𞤭𞤴𞤢𞥄
      EG:𞤃𞤭𞤧𞤭𞤪𞤢
      EH:𞤅𞤢𞥄𞤸𞤢𞤪𞤢 𞤖𞤭𞥅𞤲𞤢𞥄𞤪𞤭
      ER:𞤉𞤪𞤭𞥅𞤼𞤫𞤪𞤫
      ES:𞤉𞤧𞤨𞤢𞤻𞤢𞥄
      ET:𞤀𞤦𞤢𞤧𞤭𞤲𞤭𞥅
      EU:𞤑𞤢𞤱𞤼𞤢𞤤 𞤓𞤪𞤨𞤢
      EZ:𞤊𞤭𞤪𞤤𞤢 𞤓𞤪𞤮𞥅
      FI:𞤊𞤭𞤲𞤤𞤢𞤲𞤣
      FJ:𞤊𞤭𞤶𞤭𞥅
      FK:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤊𞤢𞤤𞤳𞤵𞤤𞤢𞤲𞤣
      FM:𞤃𞤭𞤳𞤪𞤮𞤲𞤫𞥅𞤧𞤭𞤴𞤢
      FO:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤊𞤢𞤪𞤵𞥅𞤧
      FR:𞤊𞤢𞤪𞤢𞤲𞤧𞤭
      GA:𞤘𞤢𞤦𞤮𞤲
      GB:𞤁𞤫𞤲𞤼𞤢𞤤 𞤐𞤺𞤫𞤯𞤵𞥅𞤪𞤭
      GD:𞤘𞤢𞤪𞤲𞤢𞤣𞤢𞥄
      GE:𞤔𞤮𞤪𞤶𞤭𞤴𞤢𞥄
      GF:𞤘𞤵𞤴𞤢𞥄𞤲 𞤊𞤪𞤢𞤲𞤧𞤭𞤲𞤳𞤮
      GG:𞤘𞤢𞤪𞤲𞤫𞤧𞤭𞥅
      GH:𞤘𞤢𞤲𞤢
      GI:𞤔𞤭𞤦𞤪𞤢𞤤𞤼𞤢𞥄
      GL:𞤘𞤭𞤪𞤤𞤢𞤲𞤣𞤭
      GM:𞤘𞤢𞤥𞤦𞤭𞤴𞤢
      GN:𞤘𞤭𞤲𞤫
      GP:𞤘𞤵𞤱𞤢𞤣𞤢𞤤𞤵𞤨𞤫𞥅
      GQ:𞤘𞤭𞤲𞤫 𞤕𞤢𞤳𞤢𞤲𞤼𞤫𞥅𞤪𞤭
      GR:𞤀𞤤𞤴𞤵𞤲𞤢𞥄𞤲
      GS:𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫 𞤔𞤮𞤪𞤶𞤭𞤴𞤢 & 𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫 𞤅𞤢𞤲𞤣𞤵𞤱𞤭𞥅𞤷
      GT:𞤘𞤵𞤱𞤢𞤼𞤫𞤥𞤢𞤤𞤢𞥄
      GU:𞤘𞤵𞤱𞤢𞥄𞤥
      GW:𞤘𞤭𞤲𞤫-𞤄𞤭𞤧𞤢𞤱𞤮𞥅
      GY:𞤘𞤢𞤴𞤢𞤲𞤢𞥄
      HK:𞤖𞤂𞤀 𞤕𞤢𞤴𞤲𞤢 𞤫 𞤖𞤮𞤲𞤺 𞤑𞤮𞤲𞤺
      HM:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤖𞤭𞤪𞤣𞤭 & 𞤃𞤢𞤳𞤣𞤮𞤲𞤢𞤤
      HN:𞤖𞤮𞤲𞤣𞤭𞤪𞤢𞥄𞤧
      HR:𞤑𞤵𞤪𞤱𞤢𞥄𞤧𞤭𞤴𞤢
      HT:𞤖𞤢𞤴𞤼𞤭𞥅
      HU:𞤖𞤢𞤲𞤺𞤢𞤪𞤭𞤴𞤢𞥄
      IC:𞤅𞤵𞤪𞤭𞥅𞤪𞤫-𞤑𞤢𞤲𞤢𞤪𞤭𞥅
      ID:𞤋𞤲𞤣𞤮𞤲𞤭𞥅𞤧𞤴𞤢
      IE:𞤋𞤪𞤤𞤢𞤲𞤣
      IL:𞤋𞤧𞤪𞤢𞥄𞤴𞤭𞥅𞤤
      IM:𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤃𞤫𞥅𞤲
      IN:𞤋𞤲𞤣𞤭𞤴𞤢
      IQ:𞤋𞤪𞤢𞥄𞤳
      IR:𞤋𞤪𞤢𞥄𞤲
      IS:𞤀𞤴𞤧𞤵𞤤𞤢𞤲𞤣
      IT:𞤋𞤼𞤢𞤤𞤭𞥅
      JE:𞤔𞤫𞤪𞤧𞤭𞥅
      JM:𞤔𞤢𞤥𞤢𞤴𞤳𞤢𞥄
      JO:𞤔𞤮𞤪𞤣𞤢𞥄𞤲
      JP:𞤐𞤭𞤨𞥆𞤮𞤲
      KE:𞤑𞤫𞤲𞤭𞤴𞤢𞥄
      KG:𞤑𞤭𞤪𞤶𞤭𞤧𞤼𞤢𞥄𞤲
      KH:𞤑𞤢𞤥𞤦𞤮𞥅𞤣𞤭𞤴𞤢
      KI:𞤑𞤭𞤪𞤦𞤢𞤼𞤭𞥅
      KM:𞤑𞤮𞤥𞤮𞥅𞤪𞤮
      KN:𞤅𞤼. 𞤑𞤪𞤭𞤧𞤼𞤮𞤦𞤢𞤤 & 𞤐𞤫𞥅𞤾𞤭𞤧
      KP:𞤑𞤮𞥅𞤪𞤫𞤴𞤢𞥄 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫
      KR:𞤑𞤮𞥅𞤪𞤫𞤴𞤢𞥄 𞤙𞤢𞤥𞤲𞤢𞥄𞤲𞤺𞤫
      KW:𞤑𞤵𞤱𞤢𞤴𞤼𞤵
      KY:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤑𞤢𞤴𞤥𞤢𞥄𞤲
      KZ:𞤑𞤢𞥁𞤢𞤧𞤼𞤢𞥄𞤲
      LA:𞤂𞤢𞤱𞤮𞥅𞤧
      LB:𞤂𞤭𞤦𞤢𞤲𞤮𞥅𞤲
      LC:𞤅𞤼. 𞤂𞤵𞥅𞤧𞤭𞤴𞤢
      LI:𞤂𞤭𞤧𞤼𞤫𞤲𞤧𞤭𞤼𞤫𞥅𞤲
      LK:𞤅𞤭𞤪 𞤂𞤢𞤲𞤳𞤢𞥄
      LR:𞤂𞤢𞤦𞤭𞤪𞤭𞤴𞤢𞥄
      LS:𞤂𞤫𞤧𞤮𞤼𞤮𞥅
      LT:𞤂𞤭𞤼𞤵𞤾𞤢
      LU:𞤂𞤵𞤳𞤧𞤢𞤲𞤦𞤵𞥅𞤺
      LV:𞤂𞤢𞤼𞤾𞤭𞤴𞤢
      LY:𞤂𞤭𞤦𞤭𞤴𞤢𞥄
      MA:𞤃𞤢𞤪𞤮𞥅𞤳
      MC:𞤃𞤮𞤲𞤢𞤳𞤮𞥅
      MD:𞤃𞤮𞤤𞤣𞤮𞤾𞤢𞥄
      ME:𞤃𞤮𞤲𞤼𞤫𞤲𞤫𞥅𞤺𞤮𞤪𞤮
      MF:𞤅𞤼. 𞤃𞤢𞤪𞤼𞤫𞤲
      MG:𞤃𞤢𞤣𞤢𞤺𞤢𞤧𞤳𞤢𞥄𞤪
      MH:𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤃𞤢𞤪𞥃𞤢𞤤
      MK:𞤃𞤢𞤳𞤫𞤣𞤮𞤲𞤭𞤴𞤢𞥄 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫
      ML:𞤃𞤢𞥄𞤤𞤭
      MM:𞤃𞤭𞤴𞤢𞤥𞤢𞥄𞤪 (𞤄𞤵𞥅𞤪𞤥𞤢)
      MN:𞤃𞤮𞤲𞤺𞤮𞤤𞤭𞤴𞤢
      MO:𞤖𞤂𞤀 𞤕𞤢𞤴𞤲𞤢 𞤫 𞤃𞤢𞤳𞤢𞤱𞤮𞥅
      MP:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤃𞤢𞤪𞤭𞤴𞤢𞥄𞤲𞤢 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭
      MQ:𞤃𞤢𞤪𞤼𞤭𞤲𞤭𞤳𞤢𞥄
      MR:𞤃𞤮𞤪𞤼𞤢𞤲𞤭𞥅
      MS:𞤃𞤮𞤲𞤧𞤭𞤪𞤢𞥄𞤼
      MT:𞤃𞤢𞤤𞤼𞤢
      MU:𞤃𞤮𞤪𞤭𞥅𞤧𞤭
      MV:𞤃𞤢𞤤𞤣𞤭𞥅𞤬
      MW:𞤃𞤢𞤤𞤢𞤱𞤭𞥅
      MX:𞤃𞤫𞤳𞤧𞤭𞤳𞤮𞥅
      MY:𞤃𞤢𞤤𞤫𞥅𞤧𞤭𞤴𞤢
      MZ:𞤃𞤮𞤧𞤢𞤥𞤦𞤭𞥅𞤳
      NA:𞤐𞤢𞤥𞤭𞥅𞤦𞤭𞤴𞤢𞥄
      NC:𞤑𞤢𞤤𞤭𞤣𞤮𞤲𞤭𞤴𞤢𞥄 𞤖𞤫𞤧𞤮
      NE:𞤐𞤭𞥅𞤶𞤫𞤪
      NF:𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤐𞤮𞤪𞤬𞤮𞤤𞤳𞤵
      NG:𞤐𞤢𞤶𞤫𞤪𞤭𞤴𞤢𞥄
      NI:𞤐𞤭𞤳𞤢𞤪𞤢𞤺𞤵𞤱𞤢𞥄
      NL:𞤖𞤮𞤤𞤢𞤲𞤣𞤭𞤴𞤢𞥄
      NO:𞤐𞤮𞤪𞤺𞤫𞤴𞤢𞥄
      NP:𞤐𞤭𞤨𞤢𞥄𞤤
      NR:𞤐𞤢𞤱𞤪𞤵
      NU:𞤐𞤵𞥅𞤱𞤭
      NZ:𞤐𞤫𞤱 𞤟𞤫𞤤𞤢𞤲𞤣
      OM:𞤌𞥅𞤥𞤢𞥄𞤲
      PA:𞤆𞤢𞤲𞤢𞤥𞤢
      PE:𞤆𞤫𞤪𞤵𞥅
      PF:𞤆𞤮𞤤𞤭𞤲𞤫𞥅𞤧𞤭𞤴𞤢 𞤊𞤪𞤢𞤲𞤧𞤭𞤲𞤳𞤮
      PG:𞤆𞤢𞤨𞤵𞤱𞤢 𞤘𞤭𞤲𞤫 𞤖𞤫𞤧𞤮
      PH:𞤊𞤭𞤤𞤭𞤨𞤭𞥅𞤲
      PK:𞤆𞤢𞤳𞤭𞤧𞤼𞤢𞥄𞤲
      PL:𞤆𞤮𞤤𞤢𞤲𞤣
      PM:𞤅𞤼. 𞤆𞤭𞤴𞤫𞥅𞤪 & 𞤃𞤭𞤳𞤫𞤤𞤮𞤲
      PN:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤆𞤭𞤼𞤳𞤭𞥅𞤪𞤲𞤵
      PR:𞤆𞤮𞤪𞤼𞤮 𞤈𞤭𞤳𞤮𞥅
      PS:𞤂𞤫𞤧𞤣𞤭𞥅𞤶𞤭 𞤊𞤢𞤤𞤫𞤧𞤼𞤭𞥅𞤲
      PT:𞤆𞤮𞥅𞤪𞤼𞤵𞤺𞤢𞥄𞤤
      PW:𞤆𞤢𞤤𞤢𞤱
      PY:𞤆𞤢𞥄𞤪𞤢𞤺𞤵𞤱𞤢𞥄𞤴
      QA:𞤊𞤢𞤤𞤫𞤧𞤼𞤭𞥅𞤲
      QO:𞤚𞤢𞤼𞥆𞤫𞥅𞤪𞤭 𞤌𞤧𞤴𞤢𞤲𞤭𞤴𞤢
      RE:𞤈𞤫𞥅𞤲𞤭𞤴𞤮𞤲
      RO:𞤈𞤵𞤥𞤢𞥄𞤲𞤭𞤴𞤢
      RS:𞤅𞤫𞤪𞤦𞤭𞤴𞤢𞥄
      RU:𞤈𞤮𞥅𞤧𞤭𞤴𞤢
      RW:𞤈𞤵𞤱𞤢𞤲𞤣𞤢𞥄
      SA:𞤅𞤢𞤵𞥅𞤣 𞤀𞥄𞤪𞤢𞤦𞤭𞤴𞤢𞥄
      SB:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤅𞤵𞤤𞤢𞤴𞤥𞤢𞥄𞤲
      SC:𞤅𞤫𞤴𞤭𞤧𞤫𞤤
      SD:𞤅𞤵𞤣𞤢𞥄𞤲
      SE:𞤅𞤵𞤱𞤫𞤣𞤭𞤴𞤢𞥄
      SG:𞤅𞤭𞤲𞤺𞤢𞤨𞤵𞥅𞤪
      SH:𞤅𞤫𞤲-𞤖𞤫𞤤𞤫𞤲𞤢𞥄
      SI:𞤅𞤵𞤤𞤮𞤾𞤫𞤲𞤭𞤴𞤢𞥄
      SJ:𞤅𞤢𞤾𞤢𞤤𞤦𞤢𞤪𞤣 & 𞤔𞤢𞤲 𞤃𞤢𞤴𞤫𞤲
      SK:𞤅𞤵𞤤𞤮𞤾𞤢𞥄𞤳𞤭𞤴𞤢
      SL:𞤅𞤢𞤪𞤢𞤤𞤮𞤲
      SM:𞤅𞤢𞤲 𞤃𞤢𞤪𞤭𞤲𞤮𞥅
      SN:𞤅𞤫𞤲𞤫𞤺𞤢𞥄𞤤
      SO:𞤅𞤵𞥅𞤥𞤢𞥄𞤤𞤭
      SR:𞤅𞤵𞤪𞤭𞤲𞤢𞥄𞤥
      SS:𞤅𞤵𞤣𞤢𞥄𞤲 𞤂𞤫𞤧𞤤𞤫𞤴𞤪𞤭
      ST:𞤅𞤢𞤱𞤵 𞤚𞤵𞤥𞤫𞥅 & 𞤆𞤫𞤪𞤫𞤲𞤧𞤭𞤨𞤫
      SV:𞤉𞤤 𞤅𞤢𞤤𞤾𞤢𞤣𞤮𞥅𞤪
      SX:𞤅𞤫𞤲𞤼𞤵 𞤃𞤢𞥄𞤪𞤼𞤫𞤲
      SY:𞤅𞤵𞥅𞤪𞤭𞤴𞤢𞥄
      SZ:𞤉𞤧𞤱𞤢𞤼𞤭𞤲𞤭
      TA:𞤚𞤵𞤪𞤧𞤵𞤼𞤢𞤲 𞤁𞤢𞤳𞤵𞤲𞤸𞤢
      TC:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤚𞤵𞤪𞤳𞤵𞤧 & 𞤑𞤢𞤴𞤳𞤮𞥅𞤧
      TD:𞤕𞤢𞥄𞤣
      TF:𞤚𞤵𞤥𞤦𞤫 𞤂𞤫𞤧𞤤𞤫𞤴𞤶𞤫 𞤊𞤪𞤢𞤲𞤧𞤭
      TG:𞤚𞤮𞤺𞤮
      TH:𞤚𞤢𞥄𞤴𞤤𞤢𞤲𞤣
      TJ:𞤚𞤢𞤶𞤭𞤳𞤭𞤧𞤼𞤢𞥄𞤲
      TK:𞤚𞤮𞥅𞤳𞤮𞤤𞤢𞥄𞤱𞤵
      TL:𞤚𞤭𞤥𞤮𞥅𞤪 𞤂𞤫𞤧𞤼𞤫
      TM:𞤚𞤵𞤪𞤳𞤵𞤥𞤫𞤲𞤭𞤧𞤼𞤢𞥄𞤲
      TN:𞤚𞤵𞤲𞤭𞥅𞤧𞤢
      TO:𞤚𞤮𞤲𞤺𞤢
      TR:𞤚𞤵𞤪𞤳𞤭𞤴𞤢𞥄
      TT:𞤚𞤭𞤪𞤲𞤭𞤣𞤢𞥄𞤣 & 𞤚𞤮𞤦𞤢𞤺𞤮𞥅
      TV:𞤚𞤵𞥅𞤾𞤢𞤤𞤵
      TW:𞤚𞤢𞤴𞤱𞤢𞥄𞤲
      TZ:𞤚𞤢𞤲𞤧𞤢𞤲𞤭𞥅
      UA:𞤓𞤳𞤪𞤫𞥅𞤲𞤭𞤴𞤢
      UG:𞤓𞤺𞤢𞤲𞤣𞤢𞥄
      UM:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤁𞤢𞥄𞤴𞤭𞥅𞤯𞤫 𞤁𞤂𞤀
      UN:𞤑𞤢𞤱𞤼𞤢𞤤 𞤘𞤫𞤲𞤯𞤭
      US:𞤁𞤫𞤲𞤼𞤢𞤤 𞤂𞤢𞤪𞤫
      UY:𞤒𞤵𞤪𞤺𞤮𞤴
      UZ:𞤓𞥁𞤦𞤫𞤳𞤭𞤧𞤼𞤢𞥄𞤲
      VA:𞤜𞤢𞤼𞤭𞤳𞤢𞥄𞤲
      VC:𞤅𞤼. 𞤜𞤭𞤲𞤧𞤢𞤲 & 𞤘𞤭𞤪𞤲𞤢𞤣𞤭𞥅𞤲
      VE:𞤜𞤫𞥊𞤲𞤭𞥅𞥁𞤵𞤱𞤫𞤤𞤢𞥄
      VG:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤜𞤭𞤪𞤺𞤭𞥅𞤲 𞤄𞤪𞤭𞤼𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤶𞤫
      VI:𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤜𞤭𞤪𞤺𞤭𞥅𞤲 𞤁𞤂𞤀
      VN:𞤜𞤭𞤴𞤫𞤼𞤲𞤢𞥄𞤥
      VU:𞤜𞤢𞤲𞤵𞤱𞤢𞥄𞤼𞤵
      WF:𞤏𞤢𞤤𞥆𞤭𞥅𞤧 & 𞤊𞤵𞤼𞤵𞤲𞤢
      WS:𞤅𞤢𞤥𞤵𞤱𞤢
      XA:𞤌𞤻𞤵𞤲𞤣𞤫-𞤃𞤢𞤧𞤫
      XB:𞤌𞤻𞤵𞤲𞤣𞤫-𞤄𞤭𞤣𞤭
      XK:𞤑𞤮𞥅𞤧𞤮𞤾𞤮𞥅
      YE:𞤒𞤢𞤥𞤢𞤲
      YT:𞤃𞤢𞤴𞤮𞥅𞤼𞤵
      ZA:𞤀𞤬𞤪𞤭𞤳𞤢 𞤂𞤫𞤧𞤤𞤫𞤴𞤪𞤭
      ZM:𞤟𞤢𞤥𞤦𞤭𞤴𞤢
      ZW:𞤟𞤭𞤥𞤦𞤢𞥄𞤥𞤵𞤴𞤢
      ZZ:𞤖𞤭𞤤𞥆𞤮 𞤀𞤧-𞤢𞤲𞤣𞤢𞥄𞤲𞤺𞤮
      """.trimIndent() }

  val ff_Adlm_BF: String? = null

  val ff_Adlm_CM: String? = null

  val ff_Adlm_GH: String? = null

  val ff_Adlm_GM: String? = null

  val ff_Adlm_GW: String? = null

  val ff_Adlm_LR: String? = null

  val ff_Adlm_MR: String? = null

  val ff_Adlm_NE: String? = null

  val ff_Adlm_NG: String? = null

  val ff_Adlm_SL: String? = null

  val ff_Adlm_SN: String? = null

  val ff_Latn: String? = null

  val ff_Latn_BF: String? = null

  val ff_Latn_CM: String? = null

  val ff_Latn_GH: String? = null

  val ff_Latn_GM: String? = null

  val ff_Latn_GN: String? = null

  val ff_Latn_GW: String? = null

  val ff_Latn_LR: String? = null

  val ff_Latn_MR: String? = null

  val ff_Latn_NE: String? = null

  val ff_Latn_NG: String? = null

  val ff_Latn_SL: String? = null

  val fi: String by lazy { """
      001:maailma
      002:Afrikka
      003:Pohjois-Amerikka
      005:Etelä-Amerikka
      009:Oseania
      011:Länsi-Afrikka
      013:Väli-Amerikka
      014:Itä-Afrikka
      015:Pohjois-Afrikka
      017:Keski-Afrikka
      018:eteläinen Afrikka
      019:Amerikka
      021:pohjoinen Amerikka
      029:Karibia
      030:Itä-Aasia
      034:Etelä-Aasia
      035:Kaakkois-Aasia
      039:Etelä-Eurooppa
      053:Australaasia
      054:Melanesia
      057:Mikronesian alue
      061:Polynesia
      142:Aasia
      143:Keski-Aasia
      145:Länsi-Aasia
      150:Eurooppa
      151:Itä-Eurooppa
      154:Pohjois-Eurooppa
      155:Länsi-Eurooppa
      202:Saharan eteläpuolinen Afrikka
      419:Latinalainen Amerikka
      AC:Ascension-saari
      AD:Andorra
      AE:Arabiemiirikunnat
      AF:Afganistan
      AG:Antigua ja Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarktis
      AR:Argentiina
      AS:Amerikan Samoa
      AT:Itävalta
      AU:Australia
      AW:Aruba
      AX:Ahvenanmaa
      AZ:Azerbaidžan
      BA:Bosnia ja Hertsegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgia
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Saint-Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Karibian Alankomaat
      BR:Brasilia
      BS:Bahama
      BT:Bhutan
      BV:Bouvet’nsaari
      BW:Botswana
      BY:Valko-Venäjä
      BZ:Belize
      CA:Kanada
      CC:Kookossaaret (Keelingsaaret)
      CD:Kongon demokraattinen tasavalta
      CF:Keski-Afrikan tasavalta
      CG:Kongon tasavalta
      CH:Sveitsi
      CI:Norsunluurannikko
      CK:Cookinsaaret
      CL:Chile
      CM:Kamerun
      CN:Kiina
      CO:Kolumbia
      CP:Clippertoninsaari
      CQ:Sark
      CR:Costa Rica
      CU:Kuuba
      CV:Kap Verde
      CW:Curaçao
      CX:Joulusaari
      CY:Kypros
      CZ:Tšekki
      DE:Saksa
      DG:Diego Garcia
      DJ:Djibouti
      DK:Tanska
      DM:Dominica
      DO:Dominikaaninen tasavalta
      DZ:Algeria
      EA:Ceuta ja Melilla
      EC:Ecuador
      EE:Viro
      EG:Egypti
      EH:Länsi-Sahara
      ER:Eritrea
      ES:Espanja
      ET:Etiopia
      EU:Euroopan unioni
      EZ:euroalue
      FI:Suomi
      FJ:Fidži
      FK:Falklandinsaaret
      FM:Mikronesia
      FO:Färsaaret
      FR:Ranska
      GA:Gabon
      GB:Iso-Britannia
      GD:Grenada
      GE:Georgia
      GF:Ranskan Guayana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grönlanti
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Päiväntasaajan Guinea
      GR:Kreikka
      GS:Etelä-Georgia ja Eteläiset Sandwichinsaaret
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hongkong – Kiinan erityishallintoalue
      HM:Heard ja McDonaldinsaaret
      HN:Honduras
      HR:Kroatia
      HT:Haiti
      HU:Unkari
      IC:Kanariansaaret
      ID:Indonesia
      IE:Irlanti
      IL:Israel
      IM:Mansaari
      IN:Intia
      IO:Brittiläinen Intian valtameren alue
      IQ:Irak
      IR:Iran
      IS:Islanti
      IT:Italia
      JE:Jersey
      JM:Jamaika
      JO:Jordania
      JP:Japani
      KE:Kenia
      KG:Kirgisia
      KH:Kambodža
      KI:Kiribati
      KM:Komorit
      KN:Saint Kitts ja Nevis
      KP:Pohjois-Korea
      KR:Etelä-Korea
      KW:Kuwait
      KY:Caymansaaret
      KZ:Kazakstan
      LA:Laos
      LB:Libanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Liettua
      LU:Luxemburg
      LV:Latvia
      LY:Libya
      MA:Marokko
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:Saint-Martin
      MG:Madagaskar
      MH:Marshallinsaaret
      MK:Pohjois-Makedonia
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Macao – Kiinan erityishallintoalue
      MP:Pohjois-Mariaanit
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Malediivit
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Mosambik
      NA:Namibia
      NC:Uusi-Kaledonia
      NE:Niger
      NF:Norfolkinsaari
      NG:Nigeria
      NI:Nicaragua
      NL:Alankomaat
      NO:Norja
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Uusi-Seelanti
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Ranskan Polynesia
      PG:Papua-Uusi-Guinea
      PH:Filippiinit
      PK:Pakistan
      PL:Puola
      PM:Saint-Pierre ja Miquelon
      PN:Pitcairn
      PR:Puerto Rico
      PS:Palestiinalaisalue
      PT:Portugali
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Oseanian erillissaaret
      RE:Réunion
      RO:Romania
      RS:Serbia
      RU:Venäjä
      RW:Ruanda
      SA:Saudi-Arabia
      SB:Salomonsaaret
      SC:Seychellit
      SD:Sudan
      SE:Ruotsi
      SG:Singapore
      SH:Saint Helena
      SI:Slovenia
      SJ:Huippuvuoret ja Jan Mayen
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:Etelä-Sudan
      ST:São Tomé ja Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syyria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks- ja Caicossaaret
      TD:Tšad
      TF:Ranskan eteläiset ja antarktiset alueet
      TG:Togo
      TH:Thaimaa
      TJ:Tadžikistan
      TK:Tokelau
      TL:Itä-Timor
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turkki
      TT:Trinidad ja Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansania
      UA:Ukraina
      UG:Uganda
      UM:Yhdysvaltain erillissaaret
      UN:Yhdistyneet kansakunnat
      US:Yhdysvallat
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatikaani
      VC:Saint Vincent ja Grenadiinit
      VE:Venezuela
      VG:Brittiläiset Neitsytsaaret
      VI:Yhdysvaltain Neitsytsaaret
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis ja Futuna
      WS:Samoa
      XA:pseudoaksentit
      XB:kaksisuuntainen pseudo
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Etelä-Afrikka
      ZM:Sambia
      ZW:Zimbabwe
      ZZ:tuntematon alue
      """.trimIndent() }

  val fil: String by lazy { """
      001:Mundo
      002:Africa
      003:Hilagang Amerika
      005:Timog Amerika
      009:Oceania
      011:Kanlurang Africa
      013:Gitnang Amerika
      014:Silangang Africa
      015:Hilagang Africa
      017:Gitnang Africa
      018:Katimugang Africa
      019:Americas
      021:Northern America
      029:Carribbean
      030:Silangang Asya
      034:Katimugang Asya
      035:Timog-Silangang Asya
      039:Katimugang Europe
      053:Australasia
      054:Melanesia
      057:Rehiyon ng Micronesia
      061:Polynesia
      142:Asya
      143:Gitnang Asya
      145:Kanlurang Asya
      150:Europe
      151:Silangang Europe
      154:Hilagang Europe
      155:Kanlurang Europe
      202:Sub-Saharan Africa
      419:Latin America
      AC:Acsencion island
      AD:Andorra
      AE:United Arab Emirates
      AF:Afghanistan
      AG:Antigua & Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarctica
      AR:Argentina
      AS:American Samoa
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Åland Islands
      AZ:Azerbaijan
      BA:Bosnia and Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgium
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:St. Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Caribbean Netherlands
      BR:Brazil
      BS:Bahamas
      BT:Bhutan
      BV:Bouvet Island
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Canada
      CC:Cocos (Keeling) Islands
      CD:Congo - Kinshasa
      CF:Central African Republic
      CG:Congo - Brazzaville
      CH:Switzerland
      CI:Côte d’Ivoire
      CK:Cook Islands
      CL:Chile
      CM:Cameroon
      CN:China
      CO:Colombia
      CP:Clipperton Island
      CR:Costa Rica
      CU:Cuba
      CV:Cape Verde
      CW:Curaçao
      CX:Christmas Island
      CY:Cyprus
      CZ:Czechia
      DE:Germany
      DG:Diego Garcia
      DJ:Djibouti
      DK:Denmark
      DM:Dominica
      DO:Dominican Republic
      DZ:Algeria
      EA:Ceuta & Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egypt
      EH:Kanlurang Sahara
      ER:Eritrea
      ES:Spain
      ET:Ethiopia
      EU:European Union
      EZ:Eurozone
      FI:Finland
      FJ:Fiji
      FK:Falkland Islands
      FM:Micronesia
      FO:Faroe Islands
      FR:France
      GA:Gabon
      GB:United Kingdom
      GD:Grenada
      GE:Georgia
      GF:French Guiana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Greenland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Equatorial Guinea
      GR:Greece
      GS:South Georgia & South Sandwich Islands
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hong Kong SAR China
      HM:Heard & McDonald Islands
      HN:Honduras
      HR:Croatia
      HT:Haiti
      HU:Hungary
      IC:Canary Islands
      ID:Indonesia
      IE:Ireland
      IL:Israel
      IM:Isle of Man
      IN:India
      IO:British Indian Ocean Territory
      IQ:Iraq
      IR:Iran
      IS:Iceland
      IT:Italy
      JE:Jersey
      JM:Jamaica
      JO:Jordan
      JP:Japan
      KE:Kenya
      KG:Kyrgyzstan
      KH:Cambodia
      KI:Kiribati
      KM:Comoros
      KN:St. Kitts & Nevis
      KP:Hilagang Korea
      KR:Timog Korea
      KW:Kuwait
      KY:Cayman Islands
      KZ:Kazakhstan
      LA:Laos
      LB:Lebanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lithuania
      LU:Luxembourg
      LV:Latvia
      LY:Libya
      MA:Morocco
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:Saint Martin
      MG:Madagascar
      MH:Marshall Islands
      MK:North Macedonia
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Macau SAR China
      MP:Northern Mariana Islands
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldives
      MW:Malawi
      MX:Mexico
      MY:Malaysia
      MZ:Mozambique
      NA:Namibia
      NC:New Caledonia
      NE:Niger
      NF:Norfolk Island
      NG:Nigeria
      NI:Nicaragua
      NL:Netherlands
      NO:Norway
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:Oman
      PA:Panama
      PE:Peru
      PF:French Polynesia
      PG:Papua New Guinea
      PH:Pilipinas
      PK:Pakistan
      PL:Poland
      PM:St. Pierre & Miquelon
      PN:Pitcairn Islands
      PR:Puerto Rico
      PS:Palestinian Territories
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Outlying Oceania
      RE:Réunion
      RO:Romania
      RS:Serbia
      RU:Russia
      RW:Rwanda
      SA:Saudi Arabia
      SB:Solomon Islands
      SC:Seychelles
      SD:Sudan
      SE:Sweden
      SG:Singapore
      SH:St. Helena
      SI:Slovenia
      SJ:Svalbard & Jan Mayen
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:Timog Sudan
      ST:São Tomé & Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syria
      SZ:Swaziland
      TA:Tristan de Cunha
      TC:Turks & Caicos Islands
      TD:Chad
      TF:French Southern Territories
      TG:Togo
      TH:Thailand
      TJ:Tajikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Türkiye
      TT:Trinidad & Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraine
      UG:Uganda
      UM:U.S. Outlying Islands
      UN:United Nations
      US:Estados Unidos
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatican City
      VC:St. Vincent & Grenadines
      VE:Venezuela
      VG:British Virgin Islands
      VI:U.S. Virgin Islands
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis & Futuna
      WS:Samoa
      XA:Mga Pseudo-Accent
      XB:Pseudo-Bidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:South Africa
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Hindi Kilalang Rehiyon
      """.trimIndent() }

  val fo: String by lazy { """
      001:heimur
      002:Afrika
      003:Norðuramerika
      005:Suðuramerika
      009:Osiania
      011:Vesturafrika
      013:Miðamerika
      014:Eysturafrika
      015:Norðurafrika
      017:Miðafrika
      018:sunnari partur av Afrika
      019:Amerika
      021:Amerika norðanfyri Meksiko
      029:Karibia
      030:Eysturasia
      034:Suðurasia
      035:Útsynningsasia
      039:Suðurevropa
      053:Avstralasia
      054:Melanesia
      057:Mikronesi øki
      061:Polynesia
      142:Asia
      143:Miðasia
      145:Vesturasia
      150:Evropa
      151:Eysturevropa
      154:Norðurevropa
      155:Vesturevropa
      202:Afrika sunnanfyri Sahara
      419:Latínamerika
      AC:Ascension
      AD:Andorra
      AE:Sameindu Emirríkini
      AF:Afganistan
      AG:Antigua & Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarktis
      AR:Argentina
      AS:Amerikanska Samoa
      AT:Eysturríki
      AU:Avstralia
      AW:Aruba
      AX:Áland
      AZ:Aserbadjan
      BA:Bosnia-Hersegovina
      BB:Barbados
      BD:Bangladesj
      BE:Belgia
      BF:Burkina Faso
      BG:Bulgaria
      BH:Barein
      BI:Burundi
      BJ:Benin
      BL:St. Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Niðurlonds Karibia
      BR:Brasil
      BS:Bahamaoyggjar
      BT:Butan
      BV:Bouvetoyggj
      BW:Botsvana
      BY:Hvítarussland
      BZ:Belis
      CA:Kanada
      CC:Kokosoyggjar
      CD:Kongo, Dem. Lýðveldið
      CF:Miðafrikalýðveldið
      CG:Kongo
      CH:Sveis
      CI:Fílabeinsstrondin
      CK:Cooksoyggjar
      CL:Kili
      CM:Kamerun
      CN:Kina
      CO:Kolombia
      CP:Clipperton
      CQ:Sark
      CR:Kosta Rika
      CU:Kuba
      CV:Grønhøvdaoyggjar
      CW:Curaçao
      CX:Jólaoyggjin
      CY:Kýpros
      CZ:Kekkia
      DE:Týskland
      DG:Diego Garcia
      DJ:Djibuti
      DK:Danmark
      DM:Dominika
      DO:Dominikalýðveldið
      DZ:Algeria
      EA:Ceuta & Melilla
      EC:Ekvador
      EE:Estland
      EG:Egyptaland
      EH:Vestursahara
      ER:Eritrea
      ES:Spania
      ET:Etiopia
      EU:Evropasamveldið
      EZ:Evrasona
      FI:Finnland
      FJ:Fiji
      FK:Falklandsoyggjar
      FM:Mikronesiasamveldið
      FO:Føroyar
      FR:Frakland
      GA:Gabon
      GB:Stórabretland
      GD:Grenada
      GE:Georgia
      GF:Franska Gujana
      GG:Guernsey
      GH:Gana
      GI:Gibraltar
      GL:Grønland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Ekvatorguinea
      GR:Grikkaland
      GS:Suðurgeorgia og Suðursandwichoyggjar
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Gujana
      HK:Hong Kong SAR Kina
      HM:Heard og McDonaldoyggjar
      HN:Honduras
      HR:Kroatia
      HT:Haiti
      HU:Ungarn
      IC:Kanariuoyggjar
      ID:Indonesia
      IE:Írland
      IL:Ísrael
      IM:Isle of Man
      IN:India
      IO:Stóra Bretlands Indiahavoyggjar
      IQ:Irak
      IR:Iran
      IS:Ísland
      IT:Italia
      JE:Jersey
      JM:Jamaika
      JO:Jordan
      JP:Japan
      KE:Kenja
      KG:Kirgisia
      KH:Kambodja
      KI:Kiribati
      KM:Komoroyggjar
      KN:St. Kitts & Nevis
      KP:Norðurkorea
      KR:Suðurkorea
      KW:Kuvait
      KY:Caymanoyggjar
      KZ:Kasakstan
      LA:Laos
      LB:Libanon
      LC:St. Lusia
      LI:Liktinstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesoto
      LT:Litava
      LU:Luksemborg
      LV:Lettland
      LY:Libya
      MA:Marokko
      MC:Monako
      MD:Moldova
      ME:Montenegro
      MF:St-Martin
      MG:Madagaskar
      MH:Marshalloyggjar
      MK:Norður Makedónia
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Makao SAR Kina
      MP:Norðaru Mariuoyggjar
      MQ:Martinique
      MR:Móritania
      MS:Montserrat
      MT:Malta
      MU:Móritius
      MV:Maldivoyggjar
      MW:Malavi
      MX:Meksiko
      MY:Malaisia
      MZ:Mosambik
      NA:Namibia
      NC:Nýkaledónia
      NE:Niger
      NF:Norfolksoyggj
      NG:Nigeria
      NI:Nikaragua
      NL:Niðurlond
      NO:Noreg
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nýsæland
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Franska Polynesia
      PG:Papua Nýguinea
      PH:Filipsoyggjar
      PK:Pakistan
      PL:Pólland
      PM:Saint Pierre & Miquelon
      PN:Pitcairnoyggjar
      PR:Puerto Riko
      PS:Palestinskt landøki
      PT:Portugal
      PW:Palau
      PY:Paraguai
      QA:Katar
      QO:fjarskoti Osiania
      RE:Réunion
      RO:Rumenia
      RS:Serbia
      RU:Russland
      RW:Ruanda
      SA:Saudiarabia
      SB:Salomonoyggjar
      SC:Seyskelloyggjar
      SD:Sudan
      SE:Svøríki
      SG:Singapor
      SH:St. Helena
      SI:Slovenia
      SJ:Svalbard & Jan Mayen
      SK:Slovakia
      SL:Sierra Leona
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Suðursudan
      ST:Sao Tome & Prinsipi
      SV:El Salvador
      SX:Sint Maarten
      SY:Sýria
      SZ:Esvatini
      TA:Tristan da Cunha
      TC:Turks- og Caicosoyggjar
      TD:Kjad
      TF:Fronsku sunnaru landaøki
      TG:Togo
      TH:Tailand
      TJ:Tadsjikistan
      TK:Tokelau
      TL:Eysturtimor
      TM:Turkmenistan
      TN:Tunesia
      TO:Tonga
      TR:Turkaland
      TT:Trinidad & Tobago
      TV:Tuvalu
      TW:Taivan
      TZ:Tansania
      UA:Ukraina
      UG:Uganda
      UM:Sambandsríki Amerikas fjarskotnu oyggjar
      UN:Sameindu Tjóðir
      US:Sambandsríki Amerika
      UY:Uruguai
      UZ:Usbekistan
      VA:Vatikanbýur
      VC:St. Vinsent & Grenadinoyggjar
      VE:Venesuela
      VG:Stóra Bretlands Jomfrúoyggjar
      VI:Sambandsríki Amerikas Jomfrúoyggjar
      VN:Vjetnam
      VU:Vanuatu
      WF:Wallis- og Futunaoyggjar
      WS:Samoa
      XA:óekta tónalag
      XB:óektaður BIDI tekstur
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Suðurafrika
      ZM:Sambia
      ZW:Simbabvi
      ZZ:ókent øki
      """.trimIndent() }

  val fo_DK: String? = null

  val fr: String by lazy { """
      001:Monde
      002:Afrique
      003:Amérique du Nord
      005:Amérique du Sud
      009:Océanie
      011:Afrique occidentale
      013:Amérique centrale
      014:Afrique orientale
      015:Afrique septentrionale
      017:Afrique centrale
      018:Afrique australe
      019:Amériques
      021:Amérique septentrionale
      029:Caraïbes
      030:Asie de l’Est
      034:Asie du Sud
      035:Asie du Sud-Est
      039:Europe du Sud
      053:Australasie
      054:Mélanésie
      057:région micronésienne
      061:Polynésie
      142:Asie
      143:Asie centrale
      145:Asie de l’Ouest
      150:Europe
      151:Europe de l’Est
      154:Europe du Nord
      155:Europe de l’Ouest
      202:Afrique subsaharienne
      419:Amérique latine
      AC:Île de l’Ascension
      AD:Andorre
      AE:Émirats arabes unis
      AF:Afghanistan
      AG:Antigua-et-Barbuda
      AI:Anguilla
      AL:Albanie
      AM:Arménie
      AO:Angola
      AQ:Antarctique
      AR:Argentine
      AS:Samoa américaines
      AT:Autriche
      AU:Australie
      AW:Aruba
      AX:Îles Åland
      AZ:Azerbaïdjan
      BA:Bosnie-Herzégovine
      BB:Barbade
      BD:Bangladesh
      BE:Belgique
      BF:Burkina Faso
      BG:Bulgarie
      BH:Bahreïn
      BI:Burundi
      BJ:Bénin
      BL:Saint-Barthélemy
      BM:Bermudes
      BN:Brunei
      BO:Bolivie
      BQ:Pays-Bas caribéens
      BR:Brésil
      BS:Bahamas
      BT:Bhoutan
      BV:Île Bouvet
      BW:Botswana
      BY:Biélorussie
      BZ:Belize
      CA:Canada
      CC:Îles Cocos
      CD:Congo-Kinshasa
      CF:République centrafricaine
      CG:Congo-Brazzaville
      CH:Suisse
      CI:Côte d’Ivoire
      CK:Îles Cook
      CL:Chili
      CM:Cameroun
      CN:Chine
      CO:Colombie
      CP:Île Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cap-Vert
      CW:Curaçao
      CX:Île Christmas
      CY:Chypre
      CZ:Tchéquie
      DE:Allemagne
      DG:Diego Garcia
      DJ:Djibouti
      DK:Danemark
      DM:Dominique
      DO:République dominicaine
      DZ:Algérie
      EA:Ceuta et Melilla
      EC:Équateur
      EE:Estonie
      EG:Égypte
      EH:Sahara occidental
      ER:Érythrée
      ES:Espagne
      ET:Éthiopie
      EU:Union européenne
      EZ:zone euro
      FI:Finlande
      FJ:Fidji
      FK:Îles Malouines
      FM:Micronésie
      FO:Îles Féroé
      FR:France
      GA:Gabon
      GB:Royaume-Uni
      GD:Grenade
      GE:Géorgie
      GF:Guyane française
      GG:Guernesey
      GH:Ghana
      GI:Gibraltar
      GL:Groenland
      GM:Gambie
      GN:Guinée
      GP:Guadeloupe
      GQ:Guinée équatoriale
      GR:Grèce
      GS:Géorgie du Sud-et-les Îles Sandwich du Sud
      GT:Guatemala
      GU:Guam
      GW:Guinée-Bissau
      GY:Guyana
      HK:R.A.S. chinoise de Hong Kong
      HM:Îles Heard-et-MacDonald
      HN:Honduras
      HR:Croatie
      HT:Haïti
      HU:Hongrie
      IC:Îles Canaries
      ID:Indonésie
      IE:Irlande
      IL:Israël
      IM:Île de Man
      IN:Inde
      IO:Territoire britannique de l’océan Indien
      IQ:Irak
      IR:Iran
      IS:Islande
      IT:Italie
      JE:Jersey
      JM:Jamaïque
      JO:Jordanie
      JP:Japon
      KE:Kenya
      KG:Kirghizstan
      KH:Cambodge
      KI:Kiribati
      KM:Comores
      KN:Saint-Christophe-et-Niévès
      KP:Corée du Nord
      KR:Corée du Sud
      KW:Koweït
      KY:Îles Caïmans
      KZ:Kazakhstan
      LA:Laos
      LB:Liban
      LC:Sainte-Lucie
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lituanie
      LU:Luxembourg
      LV:Lettonie
      LY:Libye
      MA:Maroc
      MC:Monaco
      MD:Moldavie
      ME:Monténégro
      MF:Saint-Martin
      MG:Madagascar
      MH:Îles Marshall
      MK:Macédoine du Nord
      ML:Mali
      MM:Myanmar (Birmanie)
      MN:Mongolie
      MO:R.A.S. chinoise de Macao
      MP:Îles Mariannes du Nord
      MQ:Martinique
      MR:Mauritanie
      MS:Montserrat
      MT:Malte
      MU:Maurice
      MV:Maldives
      MW:Malawi
      MX:Mexique
      MY:Malaisie
      MZ:Mozambique
      NA:Namibie
      NC:Nouvelle-Calédonie
      NE:Niger
      NF:Île Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Pays-Bas
      NO:Norvège
      NP:Népal
      NR:Nauru
      NU:Niue
      NZ:Nouvelle-Zélande
      OM:Oman
      PA:Panama
      PE:Pérou
      PF:Polynésie française
      PG:Papouasie-Nouvelle-Guinée
      PH:Philippines
      PK:Pakistan
      PL:Pologne
      PM:Saint-Pierre-et-Miquelon
      PN:Îles Pitcairn
      PR:Porto Rico
      PS:Territoires palestiniens
      PT:Portugal
      PW:Palaos
      PY:Paraguay
      QA:Qatar
      QO:régions éloignées de l’Océanie
      RE:La Réunion
      RO:Roumanie
      RS:Serbie
      RU:Russie
      RW:Rwanda
      SA:Arabie saoudite
      SB:Îles Salomon
      SC:Seychelles
      SD:Soudan
      SE:Suède
      SG:Singapour
      SH:Sainte-Hélène
      SI:Slovénie
      SJ:Svalbard et Jan Mayen
      SK:Slovaquie
      SL:Sierra Leone
      SM:Saint-Marin
      SN:Sénégal
      SO:Somalie
      SR:Suriname
      SS:Soudan du Sud
      ST:Sao Tomé-et-Principe
      SV:Salvador
      SX:Saint-Martin (partie néerlandaise)
      SY:Syrie
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Îles Turques-et-Caïques
      TD:Tchad
      TF:Terres australes françaises
      TG:Togo
      TH:Thaïlande
      TJ:Tadjikistan
      TK:Tokelau
      TL:Timor oriental
      TM:Turkménistan
      TN:Tunisie
      TO:Tonga
      TR:Turquie
      TT:Trinité-et-Tobago
      TV:Tuvalu
      TW:Taïwan
      TZ:Tanzanie
      UA:Ukraine
      UG:Ouganda
      UM:Îles mineures éloignées des États-Unis
      UN:Nations Unies
      US:États-Unis
      UY:Uruguay
      UZ:Ouzbékistan
      VA:État de la Cité du Vatican
      VC:Saint-Vincent-et-les Grenadines
      VE:Venezuela
      VG:Îles Vierges britanniques
      VI:Îles Vierges des États-Unis
      VN:Viêt Nam
      VU:Vanuatu
      WF:Wallis-et-Futuna
      WS:Samoa
      XA:pseudo-accents
      XB:pseudo-bidi
      XK:Kosovo
      YE:Yémen
      YT:Mayotte
      ZA:Afrique du Sud
      ZM:Zambie
      ZW:Zimbabwe
      ZZ:région indéterminée
      """.trimIndent() }

  val fr_BE: String by lazy { """
      GS:Îles Géorgie du Sud et Sandwich du Sud
      """.trimIndent() }

  val fr_BF: String? = null

  val fr_BI: String? = null

  val fr_BJ: String? = null

  val fr_BL: String? = null

  val fr_CA: String by lazy { """
      030:Asie orientale
      039:Europe méridionale
      145:Asie occidentale
      151:Europe orientale
      154:Europe septentrionale
      155:Europe occidentale
      AC:île de l’Ascension
      AX:îles d’Åland
      BN:Brunéi
      BV:île Bouvet
      BY:Bélarus
      BZ:Bélize
      CC:îles Cocos (Keeling)
      CK:îles Cook
      CP:île Clipperton
      CX:île Christmas
      FK:îles Malouines
      FO:îles Féroé
      HM:îles Heard et McDonald
      IC:îles Canaries
      IM:île de Man
      KG:Kirghizistan
      KN:Saint‑Kitts‑et‑Nevis
      LR:Libéria
      MF:Saint-Martin (France)
      MM:Myanmar
      MP:Mariannes du Nord
      NF:île Norfolk
      NG:Nigéria
      PN:îles Pitcairn
      QO:Océanie lointaine
      RE:la Réunion
      SX:Saint-Martin (Pays-Bas)
      TL:Timor-Leste
      UM:îles mineures éloignées des États-Unis
      VA:Cité du Vatican
      VE:Vénézuéla
      VG:îles Vierges britanniques
      VI:îles Vierges américaines
      VN:Vietnam
      """.trimIndent() }

  val fr_CD: String? = null

  val fr_CF: String? = null

  val fr_CG: String? = null

  val fr_CH: String? = null

  val fr_CI: String? = null

  val fr_CM: String? = null

  val fr_DJ: String? = null

  val fr_DZ: String? = null

  val fr_GA: String? = null

  val fr_GF: String? = null

  val fr_GN: String? = null

  val fr_GP: String? = null

  val fr_GQ: String? = null

  val fr_HT: String? = null

  val fr_KM: String? = null

  val fr_LU: String? = null

  val fr_MA: String? = null

  val fr_MC: String? = null

  val fr_MF: String? = null

  val fr_MG: String? = null

  val fr_ML: String? = null

  val fr_MQ: String? = null

  val fr_MR: String? = null

  val fr_MU: String? = null

  val fr_NC: String? = null

  val fr_NE: String? = null

  val fr_PF: String? = null

  val fr_PM: String? = null

  val fr_RE: String? = null

  val fr_RW: String? = null

  val fr_SC: String? = null

  val fr_SN: String? = null

  val fr_SY: String? = null

  val fr_TD: String? = null

  val fr_TG: String? = null

  val fr_TN: String? = null

  val fr_VU: String? = null

  val fr_WF: String? = null

  val fr_YT: String? = null

  val fur: String by lazy { """
      001:Mont
      002:Afriche
      003:Americhe dal Nord
      005:Americhe meridionâl
      009:Oceanie
      011:Afriche ocidentâl
      013:Americhe centrâl
      014:Afriche orientâl
      015:Afriche setentrionâl
      017:Afriche di mieç
      018:Afriche meridionâl
      019:Americhis
      021:Americhe setentrionâl
      029:caraibic
      030:Asie orientâl
      034:Asie meridionâl
      035:Asie sud orientâl
      039:Europe meridionâl
      053:Australie e Gnove Zelande
      054:Melanesie
      057:Regjon de Micronesie
      061:Polinesie
      142:Asie
      143:Asie centrâl
      145:Asie ocidentâl
      150:Europe
      151:Europe orientâl
      154:Europe setentrionâl
      155:Europe ocidentâl
      419:Americhe latine
      AD:Andorra
      AE:Emirâts araps unîts
      AF:Afghanistan
      AG:Antigua e Barbuda
      AI:Anguilla
      AL:Albanie
      AM:Armenie
      AO:Angola
      AQ:Antartic
      AR:Argjentine
      AS:Samoa merecanis
      AT:Austrie
      AU:Australie
      AW:Aruba
      AX:Isulis Aland
      AZ:Azerbaigian
      BA:Bosnie e Ercegovine
      BB:Barbados
      BD:Bangladesh
      BE:Belgjiche
      BF:Burkina Faso
      BG:Bulgarie
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Sant Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivie
      BR:Brasîl
      BS:Bahamas
      BT:Bhutan
      BV:Isule Bouvet
      BW:Botswana
      BY:Bielorussie
      BZ:Belize
      CA:Canade
      CC:Isulis Cocos
      CD:Republiche Democratiche dal Congo
      CF:Republiche centri africane
      CG:Congo - Brazzaville
      CH:Svuizare
      CI:Cueste di Avoli
      CK:Isulis Cook
      CL:Cile
      CM:Camerun
      CN:Cine
      CO:Colombie
      CP:Isule Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cjâf vert
      CX:Isule Christmas
      CY:Cipri
      CZ:Republiche ceche
      DE:Gjermanie
      DG:Diego Garcia
      DJ:Gibuti
      DK:Danimarcje
      DM:Dominiche
      DO:Republiche dominicane
      DZ:Alzerie
      EA:Ceuta e Melilla
      EC:Ecuador
      EE:Estonie
      EG:Egjit
      EH:Sahara ocidentâl
      ER:Eritree
      ES:Spagne
      ET:Etiopie
      EU:Union europeane
      FI:Finlandie
      FJ:Fizi
      FK:Isulis Falkland
      FM:Micronesie
      FO:Isulis Faroe
      FR:France
      GA:Gabon
      GB:Ream unît
      GD:Grenada
      GE:Gjeorgjie
      GF:Guiana francês
      GG:Guernsey
      GH:Ghana
      GI:Gjibraltar
      GL:Groenlande
      GM:Gambia
      GN:Guinee
      GP:Guadalupe
      GQ:Guinee ecuatoriâl
      GR:Grecie
      GS:Georgia dal Sud e Isulis Sandwich dal Sud
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Regjon aministrative speciâl de Cine di Hong Kong
      HM:Isule Heard e Isulis McDonald
      HN:Honduras
      HR:Cravuazie
      HT:Haiti
      HU:Ongjarie
      IC:Isulis Canariis
      ID:Indonesie
      IE:Irlande
      IL:Israêl
      IM:Isule di Man
      IN:India
      IQ:Iraq
      IR:Iran
      IS:Islande
      IT:Italie
      JE:Jersey
      JM:Gjamaiche
      JO:Jordanie
      JP:Gjapon
      KE:Kenya
      KG:Kirghizstan
      KH:Camboze
      KI:Kiribati
      KM:Comoris
      KN:San Kitts e Nevis
      KP:Coree dal nord
      KR:Coree dal sud
      KW:Kuwait
      KY:Isulis Cayman
      KZ:Kazachistan
      LA:Laos
      LB:Liban
      LC:Sante Lusie
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberie
      LS:Lesotho
      LT:Lituanie
      LU:Lussemburc
      LV:Letonie
      LY:Libie
      MA:Maroc
      MC:Monaco
      MD:Moldavie
      ME:Montenegro
      MF:Sant Martin
      MG:Madagascar
      MH:Isulis Marshall
      ML:Mali
      MM:Birmanie
      MN:Mongolie
      MO:Regjon aministrative speciâl de Cine di Macao
      MP:Isulis Mariana dal Nord
      MQ:Martiniche
      MR:Mauritanie
      MS:Montserrat
      MT:Malta
      MU:Maurizi
      MV:Maldivis
      MW:Malawi
      MX:Messic
      MY:Malaysia
      MZ:Mozambic
      NA:Namibie
      NC:Gnove Caledonie
      NE:Niger
      NF:Isole Norfolk
      NG:Nigerie
      NI:Nicaragua
      NL:Paîs bas
      NO:Norvegje
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Gnove Zelande
      OM:Oman
      PA:Panamà
      PE:Perù
      PF:Polinesie francês
      PG:Papue Gnove Guinee
      PH:Filipinis
      PK:Pakistan
      PL:Polonie
      PM:San Pierre e Miquelon
      PN:Pitcairn
      PR:Porto Rico
      PS:Teritoris palestinês
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Oceanie periferiche
      RE:Reunion
      RO:Romanie
      RS:Serbie
      RU:Russie
      RW:Ruande
      SA:Arabie Saudide
      SB:Isulis Salomon
      SC:Seychelles
      SD:Sudan
      SE:Svezie
      SG:Singapore
      SH:Sante Eline
      SI:Slovenie
      SJ:Svalbard e Jan Mayen
      SK:Slovachie
      SL:Sierra Leone
      SM:San Marin
      SN:Senegal
      SO:Somalie
      SR:Suriname
      ST:Sao Tomè e Principe
      SV:El Salvador
      SY:Sirie
      SZ:Swaziland
      TA:Tristan da Cunha
      TC:Isulis Turks e Caicos
      TD:Çad
      TF:Teritoris meridionâi francês
      TG:Togo
      TH:Tailandie
      TJ:Tazikistan
      TK:Tokelau
      TL:Timor orientâl
      TM:Turkmenistan
      TN:Tunisie
      TO:Tonga
      TR:Turchie
      TT:Trinidad e Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzanie
      UA:Ucraine
      UG:Uganda
      UM:Isulis periferichis minôrs dai Stâts Unîts
      US:Stâts Unîts
      UY:Uruguay
      UZ:Uzbechistan
      VA:Vatican
      VC:San Vincent e lis Grenadinis
      VE:Venezuela
      VG:Isulis vergjinis britanichis
      VI:Isulis vergjinis americanis
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis e Futuna
      WS:Samoa
      YE:Yemen
      YT:Mayotte
      ZA:Sud Afriche
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Regjon no cognossude o no valide
      """.trimIndent() }

  val fy: String by lazy { """
      001:Wrâld
      002:Afrika
      003:Noard-Amerika
      005:Sûd-Amerika
      009:Oceanië
      011:West-Afrika
      013:Midden-Amerika
      014:East-Afrika
      015:Noard-Afrika
      017:Sintraal-Afrika
      018:Sûdelijk Afrika
      019:Amerika
      021:Noardlik Amerika
      029:Karibysk gebiet
      030:East-Azië
      034:Sûd-Azië
      035:Sûdoost-Azië
      039:Sûd-Europa
      053:Australazië
      054:Melanesië
      057:Micronesyske regio
      061:Polynesië
      142:Azië
      143:Sintraal-Azië
      145:West-Azië
      150:Europa
      151:East-Europa
      154:Noard-Europa
      155:West-Europa
      419:Latynsk-Amearika
      AC:Ascension
      AD:Andorra
      AE:Verenigde Arabyske Emiraten
      AF:Afghanistan
      AG:Antigua en Barbuda
      AI:Anguilla
      AL:Albanië
      AM:Armenië
      AO:Angola
      AQ:Antarctica
      AR:Argentinië
      AS:Amerikaansk Samoa
      AT:Eastenryk
      AU:Australië
      AW:Aruba
      AX:Ålân
      AZ:Azerbeidzjan
      BA:Bosnië en Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:België
      BF:Burkina Faso
      BG:Bulgarije
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Saint Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Karibysk Nederlân
      BR:Brazilië
      BS:Bahama’s
      BT:Bhutan
      BV:Bouveteilân
      BW:Botswana
      BY:Wit-Ruslân
      BZ:Belize
      CA:Canada
      CC:Kokosilanen
      CD:Congo-Kinshasa
      CF:Sintraal-Afrikaanske Republyk
      CG:Congo-Brazzaville
      CH:Switserlân
      CI:Ivoorkust
      CK:Cookeilannen
      CL:Chili
      CM:Kameroen
      CN:Sina
      CO:Kolombia
      CP:Clipperton
      CR:Costa Rica
      CU:Kuba
      CV:Kaapverdië
      CW:Curaçao
      CX:Krysteilan
      CY:Syprus
      CZ:Tsjechje
      DE:Dútslân
      DG:Diego Garcia
      DJ:Djibouti
      DK:Denemarken
      DM:Dominika
      DO:Dominikaanske Republyk
      DZ:Algerije
      EA:Ceuta en Melilla
      EC:Ecuador
      EE:Estlân
      EG:Egypte
      EH:Westelijke Sahara
      ER:Eritrea
      ES:Spanje
      ET:Ethiopië
      EU:Europeeske Unie
      FI:Finlân
      FJ:Fiji
      FK:Falklâneilannen
      FM:Micronesië
      FO:Faeröer
      FR:Frankrijk
      GA:Gabon
      GB:Verenigd Koninkrijk
      GD:Grenada
      GE:Georgië
      GF:Frans-Guyana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grienlân
      GM:Gambia
      GN:Guinee
      GP:Guadeloupe
      GQ:Equatoriaal-Guinea
      GR:Grikelân
      GS:Sûd-Georgia en Sûdlike Sandwicheilannen
      GT:Guatemala
      GU:Guam
      GW:Guinee-Bissau
      GY:Guyana
      HK:Hongkong SAR van Sina
      HM:Heard- en McDonaldeilannen
      HN:Honduras
      HR:Kroatië
      HT:Haïti
      HU:Hongarije
      IC:Kanaryske Eilânnen
      ID:Yndonesië
      IE:Ierlân
      IL:Israël
      IM:Isle of Man
      IN:India
      IQ:Irak
      IR:Iran
      IS:Yslân
      IT:Italië
      JE:Jersey
      JM:Jamaica
      JO:Jordanië
      JP:Japan
      KE:Kenia
      KG:Kirgizië
      KH:Cambodja
      KI:Kiribati
      KM:Comoren
      KN:Saint Kitts en Nevis
      KP:Noard-Korea
      KR:Sûd-Korea
      KW:Koeweit
      KY:Caymaneilannen
      KZ:Kazachstan
      LA:Laos
      LB:Libanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Litouwen
      LU:Luxemburg
      LV:Letlân
      LY:Libië
      MA:Marokko
      MC:Monaco
      MD:Moldavië
      ME:Montenegro
      MF:Saint-Martin
      MG:Madeiaskar
      MH:Marshalleilannen
      ML:Mali
      MM:Myanmar (Birma)
      MN:Mongolië
      MO:Macao SAR van Sina
      MP:Noardlike Marianeneilannen
      MQ:Martinique
      MR:Mauritanië
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldiven
      MW:Malawi
      MX:Mexico
      MY:Maleisië
      MZ:Mozambique
      NA:Namibië
      NC:Nij-Caledonië
      NE:Niger
      NF:Norfolkeilân
      NG:Nigeria
      NI:Nicaragua
      NL:Nederlân
      NO:Noarwegen
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nij-Seelân
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Frans-Polynesië
      PG:Papoea-Nij-Guinea
      PH:Filipijnen
      PK:Pakistan
      PL:Polen
      PM:Saint-Pierre en Miquelon
      PN:Pitcairneilannen
      PR:Puerto Rico
      PS:Palestynske gebieten
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Oerig Oceanië
      RE:Réunion
      RO:Roemenië
      RS:Servië
      RU:Ruslân
      RW:Rwanda
      SA:Saoedi-Arabië
      SB:Salomonseilannen
      SC:Seychellen
      SD:Soedan
      SE:Zweden
      SG:Singapore
      SH:Sint-Helena
      SI:Slovenië
      SJ:Spitsbergen en Jan Mayen
      SK:Slowakije
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalië
      SR:Suriname
      SS:Sûd-Soedan
      ST:Sao Tomé en Principe
      SV:El Salvador
      SX:Sint-Maarten
      SY:Syrië
      SZ:Swazilân
      TA:Tristan da Cunha
      TC:Turks- en Caicoseilannen
      TD:Tsjaad
      TF:Franse Gebieden in de zuidelijke Indyske Oseaan
      TG:Togo
      TH:Thailân
      TJ:Tadzjikistan
      TK:Tokelau
      TL:East-Timor
      TM:Turkmenistan
      TN:Tunesië
      TO:Tonga
      TR:Turkije
      TT:Trinidad en Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Oekraïne
      UG:Oeganda
      UM:Lyts ôflizzen eilannen fan de Ferienigde Staten
      US:Ferienigde Staten
      UY:Uruguay
      UZ:Oezbekistan
      VA:Vaticaanstêd
      VC:Saint Vincent en de Grenadines
      VE:Venezuela
      VG:Britse Maagdeneilannen
      VI:Amerikaanske Maagdeneilannen
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis en Futuna
      WS:Samoa
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Sûd-Afrika
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Unbekend gebiet
      """.trimIndent() }

  val ga: String by lazy { """
      001:an Domhan
      002:an Afraic
      003:Meiriceá Thuaidh
      005:Meiriceá Theas
      009:an Aigéine
      011:Iarthar na hAfraice
      013:Meiriceá Láir
      014:Oirthear na hAfraice
      015:Tuaisceart na hAfraice
      017:an Afraic Láir
      018:Deisceart na hAfraice
      019:Críocha Mheiriceá
      021:Tuaisceart Mheiriceá
      029:an Mhuir Chairib
      030:Oirthear na hÁise
      034:Deisceart na hÁise
      035:an Áise Thoir Theas
      039:Deisceart na hEorpa
      053:an Astraláise
      054:an Mheilinéis
      057:an Réigiún Micrinéiseach
      061:an Pholainéis
      142:an Áise
      143:an Áise Láir
      145:Iarthar na hÁise
      150:an Eoraip
      151:Oirthear na hEorpa
      154:Tuaisceart na hEorpa
      155:Iarthar na hEorpa
      202:an Afraic fho-Shahárach
      419:Meiriceá Laidineach
      AC:Oileán na Deascabhála
      AD:Andóra
      AE:Aontas na nÉimíríochtaí Arabacha
      AF:an Afganastáin
      AG:Antigua agus Barbúda
      AI:Angaíle
      AL:an Albáin
      AM:an Airméin
      AO:Angóla
      AQ:Antartaice
      AR:an Airgintín
      AS:Samó Mheiriceá
      AT:an Ostair
      AU:an Astráil
      AW:Arúba
      AX:Oileáin Åland
      AZ:an Asarbaiseáin
      BA:an Bhoisnia agus an Heirseagaivéin
      BB:Barbadós
      BD:an Bhanglaidéis
      BE:an Bheilg
      BF:Buircíne Fasó
      BG:an Bhulgáir
      BH:Bairéin
      BI:an Bhurúin
      BJ:Beinin
      BL:Saint Barthélemy
      BM:Beirmiúda
      BN:Brúiné
      BO:an Bholaiv
      BQ:an Ísiltír Chairibeach
      BR:an Bhrasaíl
      BS:na Bahámaí
      BT:an Bhútáin
      BV:Oileán Bouvet
      BW:an Bhotsuáin
      BY:an Bhealarúis
      BZ:an Bheilís
      CA:Ceanada
      CC:Oileáin Cocos (Keeling)
      CD:Poblacht Dhaonlathach an Chongó
      CF:Poblacht na hAfraice Láir
      CG:Congó-Brazzaville
      CH:an Eilvéis
      CI:An Cósta Eabhair
      CK:Oileáin Cook
      CL:an tSile
      CM:Camarún
      CN:an tSín
      CO:an Cholóim
      CP:Oileán Clipperton
      CR:Cósta Ríce
      CU:Cúba
      CV:Rinn Verde
      CW:Cúrasó
      CX:Oileán na Nollag
      CY:an Chipir
      CZ:an tSeicia
      DE:an Ghearmáin
      DG:Diego Garcia
      DJ:Djibouti
      DK:an Danmhairg
      DM:Doiminice
      DO:an Phoblacht Dhoiminiceach
      DZ:An Ailgéir
      EA:Ceuta agus Melilla
      EC:Eacuadór
      EE:an Eastóin
      EG:An Éigipt
      EH:An Sahára Thiar
      ER:an Eiritré
      ES:an Spáinn
      ET:an Aetóip
      EU:an tAontas Eorpach
      EZ:Limistéar an euro
      FI:an Fhionlainn
      FJ:Fidsí
      FK:Oileáin Fháclainne
      FM:an Mhicrinéis
      FO:Oileáin Fharó
      FR:an Fhrainc
      GA:an Ghabúin
      GB:an Ríocht Aontaithe
      GD:Greanáda
      GE:an tSeoirsia
      GF:Guáin na Fraince
      GG:Geansaí
      GH:Gána
      GI:Giobráltar
      GL:an Ghraonlainn
      GM:An Ghaimbia
      GN:An Ghuine
      GP:Guadalúip
      GQ:an Ghuine Mheánchiorclach
      GR:an Ghréig
      GS:An tSeoirsia Theas agus Oileáin Sandwich Theas
      GT:Guatamala
      GU:Guam
      GW:Guine Bissau
      GY:An Ghuáin
      HK:Sainréigiún Riaracháin Hong Cong, Daonphoblacht na Síne
      HM:Oileán Heard agus Oileáin McDonald
      HN:Hondúras
      HR:an Chróit
      HT:Háítí
      HU:an Ungáir
      IC:Na hOileáin Chanáracha
      ID:an Indinéis
      IE:Éire
      IL:Iosrael
      IM:Oileán Mhanann
      IN:an India
      IO:Críoch Aigéan Indiach na Breataine
      IQ:an Iaráic
      IR:an Iaráin
      IS:an Íoslainn
      IT:an Iodáil
      JE:Geirsí
      JM:Iamáice
      JO:an Iordáin
      JP:an tSeapáin
      KE:an Chéinia
      KG:an Chirgeastáin
      KH:an Chambóid
      KI:Ciribeas
      KM:Oileáin Chomóra
      KN:San Críostóir-Nimheas
      KP:an Chóiré Thuaidh
      KR:an Chóiré Theas
      KW:Cuáit
      KY:Oileáin Cayman
      KZ:an Chasacstáin
      LA:Laos
      LB:an Liobáin
      LC:Saint Lucia
      LI:Lichtinstéin
      LK:Srí Lanca
      LR:An Libéir
      LS:Leosóta
      LT:an Liotuáin
      LU:Lucsamburg
      LV:an Laitvia
      LY:An Libia
      MA:Maracó
      MC:Monacó
      MD:an Mholdóiv
      ME:Montainéagró
      MF:Saint-Martin
      MG:Madagascar
      MH:Oileáin Marshall
      MK:an Mhacadóin Thuaidh
      ML:Mailí
      MM:Maenmar (Burma)
      MN:an Mhongóil
      MO:Sainréigiún Riaracháin Macao, Daonphoblacht na Síne
      MP:Na hOileáin Mháirianacha Thuaidh
      MQ:Martinique
      MR:An Mháratái
      MS:Montsarat
      MT:Málta
      MU:Oileán Mhuirís
      MV:Oileáin Mhaildíve
      MW:an Mhaláiv
      MX:Meicsiceo
      MY:an Mhalaeisia
      MZ:Mósaimbíc
      NA:an Namaib
      NC:an Nua-Chaladóin
      NE:An Nígir
      NF:Oileán Norfolk
      NG:An Nigéir
      NI:Nicearagua
      NL:an Ísiltír
      NO:an Iorua
      NP:Neipeal
      NR:Nárú
      NU:Niue
      NZ:an Nua-Shéalainn
      OM:Óman
      PA:Panama
      PE:Peiriú
      PF:Polainéis na Fraince
      PG:Nua-Ghuine Phapua
      PH:Na hOileáin Fhilipíneacha
      PK:an Phacastáin
      PL:an Pholainn
      PM:San Pierre agus Miquelon
      PN:Oileáin Pitcairn
      PR:Pórtó Ríce
      PS:na Críocha Palaistíneacha
      PT:an Phortaingéil
      PW:Oileáin Palau
      PY:Paragua
      QA:Catar
      QO:an Aigéine Imeallach
      RE:La Réunion
      RO:an Rómáin
      RS:an tSeirbia
      RU:an Rúis
      RW:Ruanda
      SA:an Araib Shádach
      SB:Oileáin Sholaimh
      SC:na Séiséil
      SD:An tSúdáin
      SE:an tSualainn
      SG:Singeapór
      SH:San Héilin
      SI:an tSlóivéin
      SJ:Svalbard agus Jan Mayen
      SK:an tSlóvaic
      SL:Siarra Leon
      SM:San Mairíne
      SN:An tSeineagáil
      SO:an tSomáil
      SR:Suranam
      SS:an tSúdáin Theas
      ST:São Tomé agus Príncipe
      SV:An tSalvadóir
      SX:Sint Maarten
      SY:an tSiria
      SZ:eSuaitíní
      TA:Tristan da Cunha
      TC:Oileáin na dTurcach agus Caicos
      TD:Sead
      TF:Críocha Francacha Dheisceart an Domhain
      TG:Tóga
      TH:an Téalainn
      TJ:an Táidsíceastáin
      TK:Tócalá
      TL:Tíomór Thoir
      TM:an Tuircméanastáin
      TN:An Tuinéis
      TO:Tonga
      TR:an Tuirc
      TT:Oileán na Tríonóide agus Tobága
      TV:Túvalú
      TW:an Téaváin
      TZ:an Tansáin
      UA:an Úcráin
      UG:Uganda
      UM:Oileáin Imeallacha S.A.M.
      UN:na Náisiúin Aontaithe
      US:Stáit Aontaithe Mheiriceá
      UY:Uragua
      UZ:an Úisbéiceastáin
      VA:Cathair na Vatacáine
      VC:San Uinseann agus na Greanáidíní
      VE:Veiniséala
      VG:Oileáin Bhriotanacha na Maighdean
      VI:Oileáin Mheiriceánacha na Maighdean
      VN:Vítneam
      VU:Vanuatú
      WF:Vailís agus Futúna
      WS:Samó
      XA:Bréagaicinn
      XB:Bréag-Bidi
      XK:an Chosaiv
      YE:Éimin
      YT:Mayotte
      ZA:an Afraic Theas
      ZM:an tSaimbia
      ZW:an tSiombáib
      ZZ:Réigiún Anaithnid
      """.trimIndent() }

  val ga_GB: String? = null

  val gaa: String by lazy { """
      GH:Ghana
      """.trimIndent() }

  val gd: String by lazy { """
      001:An Saoghal
      002:Afraga
      003:Aimeireaga a Tuath
      005:Aimeireaga a Deas
      009:Roinn a’ Chuain Sèimh
      011:Afraga an Iar
      013:Meadhan Aimeireaga
      014:Afraga an Ear
      015:Afraga a Tuath
      017:Meadhan Afraga
      018:Ceann a Deas Afraga
      019:An Dà Aimeireaga
      021:Ceann a Tuath Aimeireaga
      029:Am Muir Caraibeach
      030:Àisia an Ear
      034:Àisia a Deas
      035:Àisia an Ear-dheas
      039:An Roinn-Eòrpa a Deas
      053:Astràilia is Sealainn Nuadh
      054:Na h-Eileanan Dubha
      057:Roinn nam Meanbh-Eileanan
      061:Poilinèis
      142:Àisia
      143:Meadhan Àisia
      145:Àisia an Iar
      150:An Roinn-Eòrpa
      151:An Roinn-Eòrpa an Ear
      154:An Roinn-Eòrpa a Tuath
      155:An Roinn-Eòrpa an Iar
      202:Afraga Deas air an t-Sathara
      419:Aimeireaga Laidinneach
      AC:Eilean na Deasgabhalach
      AD:Andorra
      AE:Na h-Iomaratan Arabach Aonaichte
      AF:Afghanastàn
      AG:Aintìoga is Barbuda
      AI:Anguillia
      AL:Albàinia
      AM:Airmeinea
      AO:Angòla
      AQ:An Antartaig
      AR:An Argantain
      AS:Samotha na h-Aimeireaga
      AT:An Ostair
      AU:Astràilia
      AW:Arùba
      AX:Na h-Eileanan Åland
      AZ:Asarbaideàn
      BA:Bosna is Hearsagobhana
      BB:Barbados
      BD:Bangladais
      BE:A’ Bheilg
      BF:Buirciona Faso
      BG:A’ Bhulgair
      BH:Bachrain
      BI:Burundaidh
      BJ:Beinin
      BL:Saint Barthélemy
      BM:Bearmùda
      BN:Brùnaigh
      BO:Boilibhia
      BQ:Na Tìrean Ìsle Caraibeach
      BR:Braisil
      BS:Na h-Eileanan Bhathama
      BT:Butàn
      BV:Eilean Bouvet
      BW:Botsuana
      BY:A’ Bhealaruis
      BZ:A’ Bheilìs
      CA:Canada
      CC:Na h-Eileanan Chocos (Keeling)
      CD:Congo - Kinshasa
      CF:Poblachd Meadhan Afraga
      CG:A’ Chongo - Brazzaville
      CH:An Eilbheis
      CI:Côte d’Ivoire
      CK:Eileanan Cook
      CL:An t-Sile
      CM:Camarun
      CN:An t-Sìn
      CO:Coloimbia
      CP:Eilean Clipperton
      CQ:Sarc
      CR:Costa Rìcea
      CU:Cùba
      CV:An Ceap Uaine
      CW:Curaçao
      CX:Eilean na Nollaig
      CY:Cìopras
      CZ:An t-Seic
      DE:A’ Ghearmailt
      DG:Diego Garcia
      DJ:Diobùtaidh
      DK:An Danmhairg
      DM:Doiminicea
      DO:A’ Phoblachd Dhoiminiceach
      DZ:Aildiria
      EA:Ceuta agus Melilla
      EC:Eacuador
      EE:An Eastoin
      EG:An Èipheit
      EH:Sathara an Iar
      ER:Eartra
      ES:An Spàinnt
      ET:An Itiop
      EU:An t-Aonadh Eòrpach
      EZ:Raon an Eòro
      FI:An Fhionnlann
      FJ:Fìdi
      FK:Na h-Eileanan Fàclannach
      FM:Na Meanbh-eileanan
      FO:Na h-Eileanan Fàro
      FR:An Fhraing
      GA:Gabon
      GB:An Rìoghachd Aonaichte
      GD:Greanàda
      GE:A’ Chairtbheil
      GF:Guidheàna na Frainge
      GG:Geàrnsaidh
      GH:Gàna
      GI:Diobraltar
      GL:A’ Ghraonlann
      GM:A’ Ghaimbia
      GN:Gini
      GP:Guadalup
      GQ:Gini Mheadhan-Chriosach
      GR:A’ Ghreug
      GS:Seòirsea a Deas is na h-Eileanan Sandwich a Deas
      GT:Guatamala
      GU:Guam
      GW:Gini-Bioso
      GY:Guidheàna
      HK:Hong Kong SAR na Sìne
      HM:Eilean Heard is Eileanan MhicDhòmhnaill
      HN:Hondùras
      HR:A’ Chròthais
      HT:Haidhti
      HU:An Ungair
      IC:Na h-Eileanan Canàrach
      ID:Na h-Innd-innse
      IE:Èirinn
      IL:Iosrael
      IM:Eilean Mhanainn
      IN:Na h-Innseachan
      IO:Ranntair Breatannach Cuan nan Innseachan
      IQ:Ioràc
      IR:Ioràn
      IS:Innis Tìle
      IT:An Eadailt
      JE:Deàrsaidh
      JM:Diameuga
      JO:Iòrdan
      JP:An t-Seapan
      KE:Ceinia
      KG:Cìorgastan
      KH:Cambuidea
      KI:Ciribeas
      KM:Comoros
      KN:Naomh Crìstean is Nibheis
      KP:Coirèa a Tuath
      KR:Coirèa
      KW:Cuibhèit
      KY:Na h-Eileanan Caimean
      KZ:Casachstàn
      LA:Làthos
      LB:Leabanon
      LC:Naomh Lùisea
      LI:Lichtenstein
      LK:Sri Lanca
      LR:Libèir
      LS:Leasoto
      LT:An Liotuain
      LU:Lugsamburg
      LV:An Laitbhe
      LY:Libia
      MA:Moroco
      MC:Monaco
      MD:A’ Mholdobha
      ME:Am Monadh Neagrach
      MF:Naomh Màrtainn
      MG:Madagasgar
      MH:Eileanan Mharshall
      MK:A’ Mhasadon a Tuath
      ML:Màili
      MM:Miànmar
      MN:Dùthaich nam Mongol
      MO:Macàthu SAR na Sìne
      MP:Na h-Eileanan Mairianach a Tuath
      MQ:Mairtinic
      MR:Moratàinea
      MS:Montsarat
      MT:Malta
      MU:Na h-Eileanan Mhoiriseas
      MV:Na h-Eileanan Mhaladaibh
      MW:Malabhaidh
      MX:Meagsago
      MY:Malaidhsea
      MZ:Mòsaimbic
      NA:An Namaib
      NC:Cailleann Nuadh
      NE:Nìgeir
      NF:Eilean Norfolk
      NG:Nigèiria
      NI:Niocaragua
      NL:Na Tìrean Ìsle
      NO:Nirribhidh
      NP:Neapàl
      NR:Nabhru
      NU:Niue
      NZ:Sealainn Nuadh
      OM:Omàn
      PA:Panama
      PE:Pearù
      PF:Poilinèis na Frainge
      PG:Gini Nuadh Phaputhach
      PH:Na h-Eileanan Filipineach
      PK:Pagastàn
      PL:A’ Phòlainn
      PM:Saint Pierre agus Miquelon
      PN:Eileanan Pheit a’ Chàirn
      PR:Porto Rìceo
      PS:Ùghdarras nam Palastaineach
      PT:A’ Phortagail
      PW:Palabh
      PY:Paraguaidh
      QA:Catar
      QO:Roinn Iomallach a’ Chuain Sèimh
      RE:Réunion
      RO:Romàinia
      RS:An t-Sèirb
      RU:An Ruis
      RW:Rubhanda
      SA:Aràibia nan Sabhd
      SB:Eileanan Sholaimh
      SC:Na h-Eileanan Sheiseall
      SD:Sudàn
      SE:An t-Suain
      SG:Singeapòr
      SH:Eilean Naomh Eilidh
      SI:An t-Slòbhain
      SJ:Svalbard is Jan Mayen
      SK:An t-Slòbhac
      SL:Siarra Leòmhann
      SM:San Marino
      SN:Seanagal
      SO:Somàilia
      SR:Suranam
      SS:Sudàn a Deas
      ST:São Tomé agus Príncipe
      SV:An Salbhador
      SX:Sint Maarten
      SY:Siridhea
      SZ:eSwatini
      TA:Tristan da Cunha
      TC:Na h-Eileanan Turcach is Caiceo
      TD:An t-Seàd
      TF:Ranntairean a Deas na Frainge
      TG:Togo
      TH:Dùthaich nan Tàidh
      TJ:Taidigeastàn
      TK:Tokelau
      TL:Timor-Leste
      TM:Turcmanastàn
      TN:Tuinisea
      TO:Tonga
      TR:An Tuirc
      TT:Trianaid agus Tobago
      TV:Tubhalu
      TW:Taidh-Bhàn
      TZ:An Tansan
      UA:An Ucràin
      UG:Uganda
      UM:Meanbh-Eileanan Iomallach nan SA
      UN:Na Dùthchannan Aonaichte
      US:Na Stàitean Aonaichte
      UY:Uruguaidh
      UZ:Usbagastàn
      VA:Cathair na Bhatacain
      VC:Naomh Bhionsant agus Eileanan Greanadach
      VE:A’ Bheiniseala
      VG:Eileanan Breatannach na Maighdinn
      VI:Eileanan na Maighdinn aig na SA
      VN:Bhiet-Nam
      VU:Vanuatu
      WF:Uallas agus Futuna
      WS:Samotha
      XA:Sràcan fuadain
      XB:Dà-chomhaireach fuadain
      XK:A’ Chosobho
      YE:An Eaman
      YT:Mayotte
      ZA:Afraga a Deas
      ZM:Sàimbia
      ZW:An t-Sìombab
      ZZ:Roinn-dùthcha neo-aithnichte
      """.trimIndent() }

  val gl: String by lazy { """
      001:Mundo
      002:África
      003:América do Norte
      005:América do Sur
      009:Oceanía
      011:África Occidental
      013:América Central
      014:África Oriental
      015:África Setentrional
      017:África Central
      018:África Meridional
      019:América
      021:América Setentrional
      029:Caribe
      030:Asia Oriental
      034:Asia Meridional
      035:Sueste Asiático
      039:Europa Meridional
      053:Australasia
      054:Melanesia
      057:Rexión de Micronesia
      061:Polinesia
      142:Asia
      143:Asia Central
      145:Asia Occidental
      150:Europa
      151:Europa do Leste
      154:Europa Setentrional
      155:Europa Occidental
      202:África subsahariana
      419:América Latina
      AC:Illa de Ascensión
      AD:Andorra
      AE:Emiratos Árabes Unidos
      AF:Afganistán
      AG:Antigua e Barbuda
      AI:Anguila
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antártida
      AR:Arxentina
      AS:Samoa Americana
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Illas Åland
      AZ:Acerbaixán
      BA:Bosnia e Hercegovina
      BB:Barbados
      BD:Bangladesh
      BE:Bélxica
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benín
      BL:Saint Barthélemy
      BM:Illas Bermudas
      BN:Brunei
      BO:Bolivia
      BQ:Caribe Neerlandés
      BR:Brasil
      BS:Bahamas
      BT:Bután
      BV:Illa Bouvet
      BW:Botswana
      BY:Belarús
      BZ:Belize
      CA:Canadá
      CC:Illas Cocos (Keeling)
      CD:República Democrática do Congo
      CF:República Centroafricana
      CG:República do Congo
      CH:Suíza
      CI:Côte d’Ivoire
      CK:Illas Cook
      CL:Chile
      CM:Camerún
      CN:China
      CO:Colombia
      CP:Illa Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cabo Verde
      CW:Curaçao
      CX:Illa Christmas
      CY:Chipre
      CZ:Chequia
      DE:Alemaña
      DG:Diego García
      DJ:Djibuti
      DK:Dinamarca
      DM:Dominica
      DO:República Dominicana
      DZ:Alxeria
      EA:Ceuta e Melilla
      EC:Ecuador
      EE:Estonia
      EG:Exipto
      EH:Sáhara Occidental
      ER:Eritrea
      ES:España
      ET:Etiopía
      EU:Unión Europea
      EZ:Eurozona
      FI:Finlandia
      FJ:Fixi
      FK:Illas Malvinas
      FM:Micronesia
      FO:Illas Feroe
      FR:Francia
      GA:Gabón
      GB:Reino Unido
      GD:Granada
      GE:Xeorxia
      GF:Güiana Francesa
      GG:Guernsey
      GH:Ghana
      GI:Xibraltar
      GL:Groenlandia
      GM:Gambia
      GN:Guinea
      GP:Guadalupe
      GQ:Guinea Ecuatorial
      GR:Grecia
      GS:Illas Xeorxia do Sur e Sandwich do Sur
      GT:Guatemala
      GU:Guam
      GW:Guinea Bissau
      GY:Güiana
      HK:Hong Kong RAE da China
      HM:Illa Heard e Illas McDonald
      HN:Honduras
      HR:Croacia
      HT:Haití
      HU:Hungría
      IC:Illas Canarias
      ID:Indonesia
      IE:Irlanda
      IL:Israel
      IM:Illa de Man
      IN:India
      IO:Territorio Británico do Océano Índico
      IQ:Iraq
      IR:Irán
      IS:Islandia
      IT:Italia
      JE:Jersey
      JM:Xamaica
      JO:Xordania
      JP:Xapón
      KE:Kenya
      KG:Kirguizistán
      KH:Camboxa
      KI:Kiribati
      KM:Comores
      KN:Saint Kitts e Nevis
      KP:Corea do Norte
      KR:Corea do Sur
      KW:Kuwait
      KY:Illas Caimán
      KZ:Kazakistán
      LA:Laos
      LB:Líbano
      LC:Santa Lucía
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lituania
      LU:Luxemburgo
      LV:Letonia
      LY:Libia
      MA:Marrocos
      MC:Mónaco
      MD:República Moldova
      ME:Montenegro
      MF:Saint Martin
      MG:Madagascar
      MH:Illas Marshall
      MK:Macedonia do Norte
      ML:Malí
      MM:Myanmar (Birmania)
      MN:Mongolia
      MO:Macau RAE da China
      MP:Illas Marianas do Norte
      MQ:Martinica
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauricio
      MV:Maldivas
      MW:Malawi
      MX:México
      MY:Malaisia
      MZ:Mozambique
      NA:Namibia
      NC:Nova Caledonia
      NE:Níxer
      NF:Illa Norfolk
      NG:Nixeria
      NI:Nicaragua
      NL:Países Baixos
      NO:Noruega
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nova Zelandia
      OM:Omán
      PA:Panamá
      PE:Perú
      PF:Polinesia Francesa
      PG:Papúa-Nova Guinea
      PH:Filipinas
      PK:Paquistán
      PL:Polonia
      PM:Saint Pierre et Miquelon
      PN:Illas Pitcairn
      PR:Porto Rico
      PS:Territorios Palestinos
      PT:Portugal
      PW:Palau
      PY:Paraguai
      QA:Qatar
      QO:Territorios afastados de Oceanía
      RE:Reunión
      RO:Romanía
      RS:Serbia
      RU:Rusia
      RW:Ruanda
      SA:Arabia Saudita
      SB:Illas Salomón
      SC:Seychelles
      SD:Sudán
      SE:Suecia
      SG:Singapur
      SH:Santa Helena
      SI:Eslovenia
      SJ:Svalbard e Jan Mayen
      SK:Eslovaquia
      SL:Serra Leoa
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:Sudán do Sur
      ST:San Tomé e Príncipe
      SV:O Salvador
      SX:Sint Maarten
      SY:Siria
      SZ:Eswatini
      TA:Tristán da Cunha
      TC:Illas Turks e Caicos
      TD:Chad
      TF:Territorios Austrais Franceses
      TG:Togo
      TH:Tailandia
      TJ:Taxiquistán
      TK:Tokelau
      TL:Timor Leste
      TM:Turkmenistán
      TN:Tunisia
      TO:Tonga
      TR:Turquía
      TT:Trinidad e Tobago
      TV:Tuvalu
      TW:Taiwán
      TZ:Tanzania
      UA:Ucraína
      UG:Uganda
      UM:Illas Menores Distantes dos Estados Unidos
      UN:Nacións Unidas
      US:Estados Unidos
      UY:Uruguai
      UZ:Uzbekistán
      VA:Cidade do Vaticano
      VC:San Vicente e as Granadinas
      VE:Venezuela
      VG:Illas Virxes Británicas
      VI:Illas Virxes Estadounidenses
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis e Futuna
      WS:Samoa
      XA:Pseudoacentos
      XB:Pseudobidireccional
      XK:Kosovo
      YE:Iemen
      YT:Mayotte
      ZA:Suráfrica
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Rexión descoñecida
      """.trimIndent() }

  val gsw: String by lazy { """
      001:Wält
      002:Afrika
      003:Nordameerika
      005:Süüdameerika
      009:Ozeaanie
      011:Weschtafrika
      013:Mittelameerika
      014:Oschtafrika
      015:Nordafrika
      017:Zentraalafrika
      018:Süüdlichs Afrika
      019:Nord-, Mittel- und Süüdameerika
      021:Nördlichs Ameerika
      029:Karibik
      030:Oschtaasie
      034:Süüdaasie
      035:Süüdoschtaasie
      039:Süüdeuropa
      053:Auschtraalie und Nöiseeland
      054:Melaneesie
      057:Mikroneesischs Inselgebiet
      061:Polineesie
      142:Aasie
      143:Zentraalaasie
      145:Weschtaasie
      150:Euroopa
      151:Oschteuroopa
      154:Nordeuroopa
      155:Weschteuroopa
      419:Latiinameerika
      AD:Andorra
      AE:Veräinigti Arabischi Emirate
      AF:Afganischtan
      AG:Antigua und Barbuda
      AI:Anguilla
      AL:Albaanie
      AM:Armeenie
      AO:Angoola
      AQ:Antarktis
      AR:Argentiinie
      AS:Amerikaanisch-Samoa
      AT:Ööschtriich
      AU:Auschtraalie
      AW:Aruba
      AX:Aaland-Insle
      AZ:Aserbäidschan
      BA:Bosnie und Herzegowina
      BB:Barbados
      BD:Bangladesch
      BE:Belgie
      BF:Burkina Faaso
      BG:Bulgaarie
      BH:Bachräin
      BI:Burundi
      BJ:Benin
      BL:St. Barthelemi
      BM:Bermuuda
      BN:Brunäi Tarussalam
      BO:Boliivie
      BR:Brasilie
      BS:Bahaamas
      BT:Bhutan
      BV:Bouvet-Insle
      BW:Botswana
      BY:Wiissrussland
      BZ:Belize
      CA:Kanada
      CC:Kokos-Insle
      CD:Temokraatischi Republik Kongo
      CF:Zentraalafrikaanischi Republik
      CG:Kongo
      CH:Schwiiz
      CI:Elfebäiküschte
      CK:Cook-Insle
      CL:Tschile
      CM:Kamerun
      CN:Chiina
      CO:Kolumbie
      CR:Coschta Rica
      CU:Kuba
      CV:Kap Verde
      CX:Wienachts-Insle
      CY:Zypere
      CZ:Tschechischi Republik
      DE:Tüütschland
      DJ:Tschibuuti
      DK:Tänemark
      DM:Tominica
      DO:Tominikaanischi Republik
      DZ:Algeerie
      EC:Ecuador
      EE:Eestland
      EG:Ägüpte
      EH:Weschtsahara
      ER:Äritreea
      ES:Schpanie
      ET:Äthiopie
      EU:Europääischi Unioon
      FI:Finnland
      FJ:Fitschi
      FK:Falkland-Insle
      FM:Mikroneesie
      FO:Färöer
      FR:Frankriich
      GA:Gabun
      GB:Veräinigts Chönigriich
      GD:Grenada
      GE:Geoorgie
      GF:Französisch-Guäjaana
      GG:Gäärnsi
      GH:Gaana
      GI:Gibraltar
      GL:Gröönland
      GM:Gambia
      GN:Gineea
      GP:Guadälup
      GQ:Äquatoriaalgineea
      GR:Griecheland
      GS:Süüdgeorgie und d’süüdlichi Sändwitsch-Insle
      GT:Guatemaala
      GU:Guam
      GW:Gineea-Bissau
      GY:Guäjaana
      HK:Sonderverwaltigszone Hongkong
      HM:Höörd- und MäcDonald-Insle
      HN:Honduras
      HR:Kroaazie
      HT:Haiti
      HU:Ungarn
      ID:Indoneesie
      IE:Irland
      IL:Israel
      IM:Insle vo Män
      IN:Indie
      IQ:Iraak
      IR:Iraan
      IS:Iisland
      IT:Itaalie
      JE:Dschörsi
      JM:Dschamäika
      JO:Jordaanie
      JP:Japan
      KE:Keenia
      KG:Kirgiisischtan
      KH:Kambodscha
      KI:Kiribaati
      KM:Komoore
      KN:St. Kitts und Niuwis
      KP:Demokraatischi Volksrepublik Koreea
      KR:Republik Koreea
      KW:Kuwäit
      KY:Käimän-Insle
      KZ:Kasachschtan
      LA:Laaos
      LB:Libanon
      LC:St. Lutschiia
      LI:Liächteschtäi
      LK:Schri Lanka
      LR:Libeeria
      LS:Lesooto
      LT:Littaue
      LU:Luxemburg
      LV:Lettland
      LY:Lüübie
      MA:Marokko
      MC:Monaco
      MD:Republik Moldau
      ME:Monteneegro
      MF:St. Martin
      MG:Madagaschkar
      MH:Marshallinsle
      ML:Maali
      MM:Myanmar (Burma)
      MN:Mongolei
      MO:Sonderverwaltigszone Macao
      MP:Nördlichi Mariaane
      MQ:Martinigg
      MR:Mauretaanie
      MS:Moosörrat
      MT:Malta
      MU:Mauriizius
      MV:Malediiwe
      MW:Malaawi
      MX:Mexiko
      MY:Maläisia
      MZ:Mosambik
      NA:Namiibia
      NC:Nöikaledoonie
      NE:Niger
      NF:Norfolk-Insle
      NG:Nigeeria
      NI:Nicaraagua
      NL:Holland
      NO:Norweege
      NP:Neepal
      NR:Nauru
      NU:Niue
      NZ:Nöiseeland
      OM:Omaan
      PA:Panama
      PE:Peru
      PF:Französisch-Polineesie
      PG:Papua-Neuguinea
      PH:Philippiine
      PK:Pakischtan
      PL:Poole
      PM:St. Pierr und Miggelo
      PN:Pitggäärn
      PR:Puerto Riggo
      PS:Paläschtinänsischi Gebiet
      PT:Portugal
      PW:Palau
      PY:Paraguai
      QA:Ggatar
      QO:Üssers Ozeaanie
      RE:Reünioon
      RO:Rumäänie
      RS:Särbie
      RU:Russland
      RW:Ruanda
      SA:Saudi-Araabie
      SB:Salomoone
      SC:Seischälle
      SD:Sudan
      SE:Schweede
      SG:Singapuur
      SH:St. Helena
      SI:Sloweenie
      SJ:Svalbard und Jaan Määie
      SK:Slowakäi
      SL:Sierra Leoone
      SM:San Mariino
      SN:Senegal
      SO:Somaalie
      SR:Surinam
      ST:Sao Tome und Prinssipe
      SV:El Salvador
      SY:Süürie
      SZ:Swasiland
      TC:Törks- und Gaiggos-Insle
      TD:Tschad
      TF:Französischi Süüd- und Antarktisgebiet
      TG:Toogo
      TH:Thailand
      TJ:Tadschikischtan
      TK:Tokelau
      TL:Oschttimor
      TM:Turkmeenischtan
      TN:Tuneesie
      TO:Tonga
      TR:Türggei
      TT:Trinidad und Tobaago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansaniia
      UA:Ukraiine
      UG:Uganda
      UM:Amerikanisch-Ozeaanie
      US:Veräinigti Schtaate
      UY:Uruguay
      UZ:Uschbeekischtan
      VA:Vatikanstadt
      VC:St. Vincent und d’Grönadiine
      VE:Venezueela
      VG:Britischi Jungfere-Insle
      VI:Amerikaanischi Jungfere-Insle
      VN:Wietnam
      VU:Wanuatu
      WF:Wallis und Futuuna
      WS:Samooa
      YE:Jeeme
      YT:Majott
      ZA:Süüdafrika
      ZM:Sambia
      ZW:Simbabwe
      ZZ:Unbekannti oder ungültigi Regioon
      """.trimIndent() }

  val gsw_FR: String? = null

  val gsw_LI: String? = null

  val gu: String by lazy { """
      001:વિશ્વ
      002:આફ્રિકા
      003:ઉત્તર અમેરિકા
      005:દક્ષિણ અમેરિકા
      009:ઓશનિયા
      011:પશ્ચિમી આફ્રિકા
      013:મધ્ય અમેરિકા
      014:પૂર્વીય આફ્રિકા
      015:ઉત્તરી આફ્રિકા
      017:મધ્ય આફ્રિકા
      018:સધર્ન આફ્રિકા
      019:અમેરિકા
      021:ઉત્તરી અમેરિકા
      029:કેરિબિયન
      030:પૂર્વીય એશિયા
      034:દક્ષિણ એશિયા
      035:દક્ષિણપૂર્વ એશિયા
      039:દક્ષિણ યુરોપ
      053:ઓસ્ટ્રેલેશિયા
      054:મેલાનેશિયા
      057:માઈક્રોનેશિયન ક્ષેત્ર
      061:પોલિનેશિયા
      142:એશિયા
      143:મધ્ય એશિયા
      145:પશ્ચિમી એશિયા
      150:યુરોપ
      151:પૂર્વીય યુરોપ
      154:ઉત્તરીય યુરોપ
      155:પશ્ચિમી યુરોપ
      202:સબ-સહારન આફ્રિકા
      419:લેટિન અમેરિકા
      AC:એસેન્શન આઇલેન્ડ
      AD:ઍંડોરા
      AE:યુનાઇટેડ આરબ અમીરાત
      AF:અફઘાનિસ્તાન
      AG:ઍન્ટિગુઆ અને બર્મુડા
      AI:ઍંગ્વિલા
      AL:અલ્બેનિયા
      AM:આર્મેનિયા
      AO:અંગોલા
      AQ:એન્ટાર્કટિકા
      AR:આર્જેન્ટીના
      AS:અમેરિકન સમોઆ
      AT:ઑસ્ટ્રિયા
      AU:ઑસ્ટ્રેલિયા
      AW:અરુબા
      AX:ઑલેન્ડ આઇલેન્ડ્સ
      AZ:અઝરબૈજાન
      BA:બોસ્નિયા અને હર્ઝેગોવિના
      BB:બારબાડોસ
      BD:બાંગ્લાદેશ
      BE:બેલ્જીયમ
      BF:બુર્કિના ફાસો
      BG:બલ્ગેરિયા
      BH:બેહરીન
      BI:બુરુંડી
      BJ:બેનિન
      BL:સેંટ બાર્થેલેમી
      BM:બર્મુડા
      BN:બ્રુનેઇ
      BO:બોલિવિયા
      BQ:કેરેબિયન નેધરલેન્ડ્ઝ
      BR:બ્રાઝિલ
      BS:બહામાસ
      BT:ભૂટાન
      BV:બૌવેત આઇલેન્ડ
      BW:બોત્સ્વાના
      BY:બેલારુસ
      BZ:બેલીઝ
      CA:કેનેડા
      CC:કોકોઝ (કીલીંગ) આઇલેન્ડ્સ
      CD:કોંગો - કિંશાસા
      CF:સેન્ટ્રલ આફ્રિકન રિપબ્લિક
      CG:કોંગો - બ્રાઝાવિલે
      CH:સ્વિટ્ઝર્લૅન્ડ
      CI:કોટ ડીઆઇવરી
      CK:કુક આઇલેન્ડ્સ
      CL:ચિલી
      CM:કૅમરૂન
      CN:ચીન
      CO:કોલમ્બિયા
      CP:ક્લિપરટન આઇલેન્ડ
      CR:કોસ્ટા રિકા
      CU:ક્યુબા
      CV:કૅપ વર્ડે
      CW:ક્યુરાસાઓ
      CX:ક્રિસમસ આઇલેન્ડ
      CY:સાયપ્રસ
      CZ:ચેકીયા
      DE:જર્મની
      DG:ડિએગો ગારસિઆ
      DJ:જીબૌટી
      DK:ડેનમાર્ક
      DM:ડોમિનિકા
      DO:ડોમિનિકન રિપબ્લિક
      DZ:અલ્જીરિયા
      EA:સ્યુટા અને મેલિલા
      EC:એક્વાડોર
      EE:એસ્ટોનિયા
      EG:ઇજિપ્ત
      EH:પશ્ચિમી સહારા
      ER:એરિટ્રિયા
      ES:સ્પેન
      ET:ઇથિઓપિયા
      EU:યુરોપિયન સંઘ
      EZ:યુરોઝોન
      FI:ફિનલેન્ડ
      FJ:ફીજી
      FK:ફૉકલેન્ડ આઇલેન્ડ્સ
      FM:માઇક્રોનેશિયા
      FO:ફેરો આઇલેન્ડ્સ
      FR:ફ્રાંસ
      GA:ગેબન
      GB:યુનાઇટેડ કિંગડમ
      GD:ગ્રેનેડા
      GE:જ્યોર્જિયા
      GF:ફ્રેંચ ગયાના
      GG:ગ્વેર્નસે
      GH:ઘાના
      GI:જીબ્રાલ્ટર
      GL:ગ્રીનલેન્ડ
      GM:ગેમ્બિયા
      GN:ગિની
      GP:ગ્વાડેલોપ
      GQ:ઇક્વેટોરિયલ ગિની
      GR:ગ્રીસ
      GS:દક્ષિણ જ્યોર્જિયા અને દક્ષિણ સેન્ડવિચ આઇલેન્ડ્સ
      GT:ગ્વાટેમાલા
      GU:ગ્વામ
      GW:ગિની-બિસાઉ
      GY:ગયાના
      HK:હોંગકોંગ SAR ચીન
      HM:હર્ડ અને મેકડોનાલ્ડ આઇલેન્ડ્સ
      HN:હોન્ડુરસ
      HR:ક્રોએશિયા
      HT:હૈતિ
      HU:હંગેરી
      IC:કૅનેરી આઇલેન્ડ્સ
      ID:ઇન્ડોનેશિયા
      IE:આયર્લેન્ડ
      IL:ઇઝરાઇલ
      IM:આઇલ ઑફ મેન
      IN:ભારત
      IO:બ્રિટિશ ઇન્ડિયન ઓશન ટેરિટરી
      IQ:ઇરાક
      IR:ઈરાન
      IS:આઇસલેન્ડ
      IT:ઇટાલી
      JE:જર્સી
      JM:જમૈકા
      JO:જોર્ડન
      JP:જાપાન
      KE:કેન્યા
      KG:કિર્ગિઝ્સ્તાન
      KH:કંબોડિયા
      KI:કિરિબાટી
      KM:કોમોરસ
      KN:સેંટ કિટ્સ અને નેવિસ
      KP:ઉત્તર કોરિયા
      KR:દક્ષિણ કોરિયા
      KW:કુવૈત
      KY:કેમેન આઇલેન્ડ્સ
      KZ:કઝાકિસ્તાન
      LA:લાઓસ
      LB:લેબનોન
      LC:સેંટ લુસિયા
      LI:લૈચટેંસ્ટેઇન
      LK:શ્રીલંકા
      LR:લાઇબેરિયા
      LS:લેસોથો
      LT:લિથુઆનિયા
      LU:લક્ઝમબર્ગ
      LV:લાત્વિયા
      LY:લિબિયા
      MA:મોરોક્કો
      MC:મોનાકો
      MD:મોલડોવા
      ME:મૉન્ટેનેગ્રો
      MF:સેંટ માર્ટિન
      MG:મેડાગાસ્કર
      MH:માર્શલ આઇલેન્ડ્સ
      MK:ઉત્તર મેસેડોનિયા
      ML:માલી
      MM:મ્યાંમાર (બર્મા)
      MN:મંગોલિયા
      MO:મકાઉ SAR ચીન
      MP:ઉત્તરી મારિયાના આઇલેન્ડ્સ
      MQ:માર્ટીનીક
      MR:મૌરિટાનિયા
      MS:મોંટસેરાત
      MT:માલ્ટા
      MU:મોરિશિયસ
      MV:માલદિવ્સ
      MW:માલાવી
      MX:મેક્સિકો
      MY:મલેશિયા
      MZ:મોઝામ્બિક
      NA:નામિબિયા
      NC:ન્યુ સેલેડોનિયા
      NE:નાઇજર
      NF:નોરફોક આઇલેન્ડ્સ
      NG:નાઇજેરિયા
      NI:નિકારાગુઆ
      NL:નેધરલેન્ડ્સ
      NO:નૉર્વે
      NP:નેપાળ
      NR:નૌરુ
      NU:નીયુ
      NZ:ન્યુઝીલેન્ડ
      OM:ઓમાન
      PA:પનામા
      PE:પેરુ
      PF:ફ્રેંચ પોલિનેશિયા
      PG:પાપુઆ ન્યૂ ગિની
      PH:ફિલિપિન્સ
      PK:પાકિસ્તાન
      PL:પોલેંડ
      PM:સેંટ પીએરી અને મિક્યુલોન
      PN:પીટકૈર્ન આઇલેન્ડ્સ
      PR:પ્યુઅર્ટો રિકો
      PS:પેલેસ્ટિનિયન ટેરિટરી
      PT:પોર્ટુગલ
      PW:પલાઉ
      PY:પેરાગ્વે
      QA:કતાર
      QO:આઉટલાઈન્ગ ઓશનિયા
      RE:રીયુનિયન
      RO:રોમાનિયા
      RS:સર્બિયા
      RU:રશિયા
      RW:રવાંડા
      SA:સાઉદી અરેબિયા
      SB:સોલોમન આઇલેન્ડ્સ
      SC:સેશેલ્સ
      SD:સુદાન
      SE:સ્વીડન
      SG:સિંગાપુર
      SH:સેંટ હેલેના
      SI:સ્લોવેનિયા
      SJ:સ્વાલબર્ડ અને જેન મેયન
      SK:સ્લોવેકિયા
      SL:સીએરા લેઓન
      SM:સૅન મેરિનો
      SN:સેનેગલ
      SO:સોમાલિયા
      SR:સુરીનામ
      SS:દક્ષિણ સુદાન
      ST:સાઓ ટૉમ અને પ્રિંસિપે
      SV:એલ સેલ્વાડોર
      SX:સિંટ માર્ટેન
      SY:સીરિયા
      SZ:એસ્વાટીની
      TA:ત્રિસ્તાન દા કુન્હા
      TC:તુર્ક્સ અને કેકોઝ આઇલેન્ડ્સ
      TD:ચાડ
      TF:ફ્રેંચ સધર્ન ટેરિટરીઝ
      TG:ટોગો
      TH:થાઇલેંડ
      TJ:તાજીકિસ્તાન
      TK:ટોકેલાઉ
      TL:તિમોર-લેસ્તે
      TM:તુર્કમેનિસ્તાન
      TN:ટ્યુનિશિયા
      TO:ટોંગા
      TR:તુર્કિયે
      TT:ટ્રિનીદાદ અને ટોબેગો
      TV:તુવાલુ
      TW:તાઇવાન
      TZ:તાંઝાનિયા
      UA:યુક્રેન
      UG:યુગાંડા
      UM:યુ.એસ. આઉટલાઇનિંગ આઇલેન્ડ્સ
      UN:સંયુક્ત રાષ્ટ્ર
      US:યુનાઇટેડ સ્ટેટ્સ
      UY:ઉરુગ્વે
      UZ:ઉઝ્બેકિસ્તાન
      VA:વેટિકન સિટી
      VC:સેંટ વિન્સેંટ અને ગ્રેનેડાઇંસ
      VE:વેનેઝુએલા
      VG:બ્રિટિશ વર્જિન આઇલેન્ડ્સ
      VI:યુએસ વર્જિન આઇલેન્ડ્સ
      VN:વિયેતનામ
      VU:વાનુઆતુ
      WF:વૉલિસ અને ફ્યુચુના
      WS:સમોઆ
      XA:સ્યુડો-ઍક્સન્ટ
      XB:સ્યુડો-દ્વિદિશ
      XK:કોસોવો
      YE:યમન
      YT:મેયોટ
      ZA:દક્ષિણ આફ્રિકા
      ZM:ઝામ્બિયા
      ZW:ઝિમ્બાબ્વે
      ZZ:અજ્ઞાત પ્રદેશ
      """.trimIndent() }

  val guz: String by lazy { """
      AD:Andora
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Marekani
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misri
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Ufaransa
      GA:Gaboni
      GB:Uingereza
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Rwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukraini
      UG:Uganda
      US:Marekani
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val gv: String by lazy { """
      GB:Rywvaneth Unys
      IM:Ellan Vannin
      """.trimIndent() }

  val ha: String by lazy { """
      001:Duniya
      002:Afirka
      003:Amurka ta Arewa
      005:Amurka ta Kudu
      009:Osheniya
      011:Afirka ta Yamma
      013:Amurka ta Tsakiya
      014:Afirka ta Gabas
      015:Arewacin Afirka
      017:Afirka ta Tsakiya
      018:Kudancin Afirka
      019:Nahiyoyin Amurka
      021:Arewacin Amurka
      029:Karebiyan
      030:Gabashin Asiya
      034:Kudancin Asiya
      035:Kudu Maso Gabashin Asiya
      039:Kudancin Turai
      053:Asturelasiya
      054:Melanesia
      057:Yankin Micronesiya
      061:Kasar Polynesia
      142:Asiya
      143:Asiya ta Tsakiya
      145:Yammacin Asiya
      150:Turai
      151:Gabashin Turai
      154:Arewacin Turai
      155:Yammacin Turai
      202:Afirka ta Kudancin Sahara
      419:Latin Amurka
      AC:Tsibirin Ascension
      AD:Andora
      AE:Haɗaɗɗiyar Daular Larabawa
      AF:Afaganistan
      AG:Antigua da Barbuda
      AI:Angila
      AL:Albaniya
      AM:Armeniya
      AO:Angola
      AQ:Antatika
      AR:Ajentina
      AS:Samowa Ta Amurka
      AT:Ostiriya
      AU:Ostareliya
      AW:Aruba
      AX:Tsibirai na Åland
      AZ:Azarbaijan
      BA:Bosniya da Harzagobina
      BB:Barbadas
      BD:Bangladesh
      BE:Belgiyom
      BF:Burkina Faso
      BG:Bulgariya
      BH:Baharen
      BI:Burundi
      BJ:Binin
      BL:San Barthélemy
      BM:Barmuda
      BN:Burune
      BO:Bolibiya
      BQ:Caribbean Netherlands
      BR:Birazil
      BS:Bahamas
      BT:Butan
      BV:Tsibirin Bouvet
      BW:Baswana
      BY:Belarus
      BZ:Beliz
      CA:Kanada
      CC:Tsibirai Cocos (Keeling)
      CD:Jamhuriyar Dimokuraɗiyyar Kongo
      CF:Jamhuriyar Afirka Ta Tsakiya
      CG:Kongo
      CH:Suwizalan
      CI:Aibari Kwas
      CK:Tsibiran Cook
      CL:Chile
      CM:Kamaru
      CN:Sin
      CO:Kolambiya
      CP:Tsibirin Clipperton
      CR:Kwasta Rika
      CU:Kyuba
      CV:Tsibiran Cape Verde
      CW:Ƙasar Curaçao
      CX:Tsibirin Kirsmati
      CY:Saifurus
      CZ:Czechia
      DE:Jamus
      DG:Tsibirn Diego Garcia
      DJ:Jibuti
      DK:Danmark
      DM:Dominika
      DO:Jamhuriyar Dominika
      DZ:Aljeriya
      EA:Ceuta da Melilla
      EC:Ekwador
      EE:Estoniya
      EG:Misira
      EH:Yammacin Sahara
      ER:Eritireya
      ES:Sipen
      ET:Habasha
      EU:Tarayyar Turai
      EZ:Sashin Turai
      FI:Finlan
      FJ:Fiji
      FK:Tsibiran Falkilan
      FM:Mikuronesiya
      FO:Tsibirai na Faroe
      FR:Faransa
      GA:Gabon
      GB:Biritaniya
      GD:Girnada
      GE:Jojiya
      GF:Gini Ta Faransa
      GG:Yankin Guernsey
      GH:Gana
      GI:Jibaraltar
      GL:Grinlan
      GM:Gambiya
      GN:Gini
      GP:Gwadaluf
      GQ:Ikwatoriyal Gini
      GR:Girka
      GS:Kudancin Geogia da Kudancin Tsibirin Sandiwic
      GT:Gwatamala
      GU:Guam
      GW:Gini Bisau
      GY:Guyana
      HK:Babban Yankin Mulkin Hong Kong na Ƙasar Sin
      HM:Tsibirin Heard da McDonald
      HN:Yankin Honduras
      HR:Kurowaishiya
      HT:Haiti
      HU:Hungari
      IC:Tsibiran Canary
      ID:Indunusiya
      IE:Ayalan
      IL:Israʼila
      IM:Isle of Man
      IN:Indiya
      IO:Yankin Birtaniya Na Tekun Indiya
      IQ:Iraƙi
      IR:Iran
      IS:Aisalan
      IT:Italiya
      JE:Kasar Jersey
      JM:Jamaika
      JO:Jordan
      JP:Japan
      KE:Kenya
      KG:Kirgizistan
      KH:Kambodiya
      KI:Kiribati
      KM:Kwamoras
      KN:San Kiti Da Nebis
      KP:Koriya Ta Arewa
      KR:Koriya Ta Kudu
      KW:Kuwet
      KY:Tsibiran Kaiman
      KZ:Kazakistan
      LA:Lawos
      LB:Labanan
      LC:San Lusiya
      LI:Licansitan
      LK:Siri Lanka
      LR:Laberiya
      LS:Lesoto
      LT:Lituweniya
      LU:Lukusambur
      LV:Litibiya
      LY:Libiya
      MA:Maroko
      MC:Monako
      MD:Maldoba
      ME:Manteneguro
      MF:San Martin
      MG:Madagaskar
      MH:Tsibiran Marshal
      MK:Macedonia ta Arewa
      ML:Mali
      MM:Burma, Miyamar
      MN:Mangoliya
      MO:Babban Yankin Mulkin Macao na Ƙasar Sin
      MP:Tsibiran Mariyana Na Arewa
      MQ:Martinik
      MR:Moritaniya
      MS:Manserati
      MT:Malta
      MU:Moritus
      MV:Maldibi
      MW:Malawi
      MX:Mesiko
      MY:Malesiya
      MZ:Mozambik
      NA:Namibiya
      NC:Kaledoniya Sabuwa
      NE:Nijar
      NF:Tsibirin Narfalk
      NG:Nijeriya
      NI:Nikaraguwa
      NL:Holan
      NO:Norwe
      NP:Nefal
      NR:Nauru
      NU:Niue
      NZ:Nuzilan
      OM:Oman
      PA:Panama
      PE:Feru
      PF:Folinesiya Ta Faransa
      PG:Papuwa Nugini
      PH:Filipin
      PK:Pakistan
      PL:Polan
      PM:San Piyar da Mikelan
      PN:Tsibiran Pitcairn
      PR:Porto Riko
      PS:Yankunan Palasɗinu
      PT:Portugal
      PW:Palau
      PY:Faragwai
      QA:Katar
      QO:Bakin Teku
      RE:Rawuniyan
      RO:Romaniya
      RS:Sabiya
      RU:Rasha
      RW:Ruwanda
      SA:Saudiyya
      SB:Tsibiran Salaman
      SC:Seychelles
      SD:Sudan
      SE:Suwedan
      SG:Singapur
      SH:San Helena
      SI:Sulobeniya
      SJ:Svalbard da Jan Mayen
      SK:Sulobakiya
      SL:Salewo
      SM:San Marino
      SN:Sanigal
      SO:Somaliya
      SR:Suriname
      SS:Sudan ta Kudu
      ST:Sawo Tome Da Paransip
      SV:El Salbador
      SX:San Maarten
      SY:Sham, Siriya
      SZ:Eswatini
      TA:Tritan da Kunha
      TC:Turkis Da Tsibiran Kaikwas
      TD:Cadi
      TF:Yankin Faransi ta Kudu
      TG:Togo
      TH:Tailan
      TJ:Tajikistan
      TK:Takelau
      TL:Timor-Leste
      TM:Turkumenistan
      TN:Tunisiya
      TO:Tonga
      TR:Turkiyya
      TT:Tirinidad Da Tobago
      TV:Tubalu
      TW:Taiwan
      TZ:Tanzaniya
      UA:Yukaran
      UG:Yuganda
      UM:Rukunin Tsibirin U.S
      UN:Majalisar Ɗinkin Duniya
      US:Amurka
      UY:Yurigwai
      UZ:Uzubekistan
      VA:Birnin Batikan
      VC:San Binsan Da Girnadin
      VE:Benezuwela
      VG:Tsibirin Birjin Na Birtaniya
      VI:Tsibiran Birjin Ta Amurka
      VN:Biyetinam
      VU:Banuwatu
      WF:Walis Da Futuna
      WS:Samoa
      XA:Gurɓataccen Karin harshe
      XB:Gurɓataccen Bidi
      XK:Kasar Kosovo
      YE:Yamen
      YT:Mayoti
      ZA:Afirka Ta Kudu
      ZM:Zambiya
      ZW:Zimbabuwe
      ZZ:Yanki da ba a sani ba
      """.trimIndent() }

  val ha_GH: String? = null

  val ha_NE: String? = null

  val haw: String by lazy { """
      AU:Nūhōlani
      CA:Kanakā
      CN:Kina
      DE:Kelemānia
      DK:Kenemaka
      ES:Kepania
      FR:Palani
      GB:Aupuni Mōʻī Hui Pū ʻIa
      GR:Helene
      IE:ʻIlelani
      IL:ʻIseraʻela
      IN:ʻĪnia
      IT:ʻĪkālia
      JP:Iāpana
      MX:Mekiko
      NL:Hōlani
      NZ:Aotearoa
      PH:ʻĀina Pilipino
      RU:Lūkia
      US:ʻAmelika Hui Pū ʻIa
      """.trimIndent() }

  val he: String by lazy { """
      001:העולם
      002:אפריקה
      003:צפון אמריקה
      005:דרום אמריקה
      009:אוקיאניה
      011:מערב אפריקה
      013:מרכז אמריקה
      014:מזרח אפריקה
      015:צפון אפריקה
      017:מרכז אפריקה
      018:דרום יבשת אפריקה
      019:אמריקה
      021:אמריקה הצפונית
      029:האיים הקריביים
      030:מזרח אסיה
      034:דרום אסיה
      035:דרום־מזרח אסיה
      039:דרום אירופה
      053:אוסטרלאסיה
      054:מלנזיה
      057:אזור מיקרונזיה
      061:פולינזיה
      142:אסיה
      143:מרכז אסיה
      145:מערב אסיה
      150:אירופה
      151:מזרח אירופה
      154:צפון אירופה
      155:מערב אירופה
      202:אפריקה שמדרום לסהרה
      419:אמריקה הלטינית
      AC:האי אסנשן
      AD:אנדורה
      AE:איחוד האמירויות הערביות
      AF:אפגניסטן
      AG:אנטיגואה וברבודה
      AI:אנגווילה
      AL:אלבניה
      AM:ארמניה
      AO:אנגולה
      AQ:אנטארקטיקה
      AR:ארגנטינה
      AS:סמואה האמריקנית
      AT:אוסטריה
      AU:אוסטרליה
      AW:ארובה
      AX:איי אולנד
      AZ:אזרבייג׳ן
      BA:בוסניה והרצגובינה
      BB:ברבדוס
      BD:בנגלדש
      BE:בלגיה
      BF:בורקינה פאסו
      BG:בולגריה
      BH:בחריין
      BI:בורונדי
      BJ:בנין
      BL:סנט ברתולומיאו
      BM:ברמודה
      BN:ברוניי
      BO:בוליביה
      BQ:האיים הקריביים ההולנדיים
      BR:ברזיל
      BS:איי בהאמה
      BT:בהוטן
      BV:האי בובה
      BW:בוטסואנה
      BY:בלארוס
      BZ:בליז
      CA:קנדה
      CC:איי קוקוס (קילינג)
      CD:קונגו - קינשאסה
      CF:הרפובליקה המרכז-אפריקאית
      CG:קונגו - ברזאויל
      CH:שווייץ
      CI:חוף השנהב
      CK:איי קוק
      CL:צ׳ילה
      CM:קמרון
      CN:סין
      CO:קולומביה
      CP:האי קליפרטון
      CR:קוסטה ריקה
      CU:קובה
      CV:כף ורדה
      CW:קוראסאו
      CX:אי חג המולד
      CY:קפריסין
      CZ:צ׳כיה
      DE:גרמניה
      DG:דייגו גרסיה
      DJ:ג׳יבוטי
      DK:דנמרק
      DM:דומיניקה
      DO:הרפובליקה הדומיניקנית
      DZ:אלג׳יריה
      EA:סאוטה ומלייה
      EC:אקוודור
      EE:אסטוניה
      EG:מצרים
      EH:סהרה המערבית
      ER:אריתריאה
      ES:ספרד
      ET:אתיופיה
      EU:האיחוד האירופי
      EZ:גוש האירו
      FI:פינלנד
      FJ:פיג׳י
      FK:איי פוקלנד
      FM:מיקרונזיה
      FO:איי פארו
      FR:צרפת
      GA:גבון
      GB:בריטניה
      GD:גרנדה
      GE:גאורגיה
      GF:גיאנה הצרפתית
      GG:גרנזי
      GH:גאנה
      GI:גיברלטר
      GL:גרינלנד
      GM:גמביה
      GN:גינאה
      GP:גוואדלופ
      GQ:גינאה המשוונית
      GR:יוון
      GS:ג׳ורג׳יה הדרומית ואיי סנדוויץ׳ הדרומיים
      GT:גואטמלה
      GU:גואם
      GW:גינאה-ביסאו
      GY:גיאנה
      HK:הונג קונג (אזור מנהלי מיוחד של סין)
      HM:איי הרד ומקדונלד
      HN:הונדורס
      HR:קרואטיה
      HT:האיטי
      HU:הונגריה
      IC:האיים הקנריים
      ID:אינדונזיה
      IE:אירלנד
      IL:ישראל
      IM:האי מאן
      IN:הודו
      IO:הטריטוריה הבריטית באוקיינוס ההודי
      IQ:עיראק
      IR:איראן
      IS:איסלנד
      IT:איטליה
      JE:ג׳רזי
      JM:ג׳מייקה
      JO:ירדן
      JP:יפן
      KE:קניה
      KG:קירגיזסטן
      KH:קמבודיה
      KI:קיריבאטי
      KM:קומורו
      KN:סנט קיטס ונוויס
      KP:קוריאה הצפונית
      KR:קוריאה הדרומית
      KW:כווית
      KY:איי קיימן
      KZ:קזחסטן
      LA:לאוס
      LB:לבנון
      LC:סנט לוסיה
      LI:ליכטנשטיין
      LK:סרי לנקה
      LR:ליבריה
      LS:לסוטו
      LT:ליטא
      LU:לוקסמבורג
      LV:לטביה
      LY:לוב
      MA:מרוקו
      MC:מונקו
      MD:מולדובה
      ME:מונטנגרו
      MF:סן מרטן
      MG:מדגסקר
      MH:איי מרשל
      MK:מקדוניה הצפונית
      ML:מאלי
      MM:מיאנמר (בורמה)
      MN:מונגוליה
      MO:מקאו (אזור מנהלי מיוחד של סין)
      MP:איי מריאנה הצפוניים
      MQ:מרטיניק
      MR:מאוריטניה
      MS:מונסראט
      MT:מלטה
      MU:מאוריציוס
      MV:האיים המלדיביים
      MW:מלאווי
      MX:מקסיקו
      MY:מלזיה
      MZ:מוזמביק
      NA:נמיביה
      NC:קלדוניה החדשה
      NE:ניז׳ר
      NF:האי נורפוק
      NG:ניגריה
      NI:ניקרגואה
      NL:הולנד
      NO:נורווגיה
      NP:נפאל
      NR:נאורו
      NU:ניווה
      NZ:ניו זילנד
      OM:עומאן
      PA:פנמה
      PE:פרו
      PF:פולינזיה הצרפתית
      PG:פפואה גינאה החדשה
      PH:הפיליפינים
      PK:פקיסטן
      PL:פולין
      PM:סנט פייר ומיקלון
      PN:איי פיטקרן
      PR:פוארטו ריקו
      PS:השטחים הפלסטיניים
      PT:פורטוגל
      PW:פלאו
      PY:פרגוואי
      QA:קטאר
      QO:טריטוריות באוקיאניה
      RE:ראוניון
      RO:רומניה
      RS:סרביה
      RU:רוסיה
      RW:רואנדה
      SA:ערב הסעודית
      SB:איי שלמה
      SC:איי סיישל
      SD:סודן
      SE:שוודיה
      SG:סינגפור
      SH:סנט הלנה
      SI:סלובניה
      SJ:סבאלברד ויאן מאיין
      SK:סלובקיה
      SL:סיירה לאון
      SM:סן מרינו
      SN:סנגל
      SO:סומליה
      SR:סורינאם
      SS:דרום סודן
      ST:סאו טומה ופרינסיפה
      SV:אל סלבדור
      SX:סנט מארטן
      SY:סוריה
      SZ:אסוואטיני
      TA:טריסטן דה קונה
      TC:איי טרקס וקייקוס
      TD:צ׳אד
      TF:הטריטוריות הדרומיות של צרפת
      TG:טוגו
      TH:תאילנד
      TJ:טג׳יקיסטן
      TK:טוקלאו
      TL:טימור-לסטה
      TM:טורקמניסטן
      TN:תוניסיה
      TO:טונגה
      TR:טורקיה
      TT:טרינידד וטובגו
      TV:טובאלו
      TW:טייוואן
      TZ:טנזניה
      UA:אוקראינה
      UG:אוגנדה
      UM:האיים המרוחקים הקטנים של ארה״ב
      UN:האומות המאוחדות
      US:ארצות הברית
      UY:אורוגוואי
      UZ:אוזבקיסטן
      VA:הוותיקן
      VC:סנט וינסנט והגרנדינים
      VE:ונצואלה
      VG:איי הבתולה הבריטיים
      VI:איי הבתולה של ארצות הברית
      VN:וייטנאם
      VU:ונואטו
      WF:איי ווליס ופוטונה
      WS:סמואה
      XA:מבטאים חלקיים
      XB:דו-כיווני חלקי
      XK:קוסובו
      YE:תימן
      YT:מאיוט
      ZA:דרום אפריקה
      ZM:זמביה
      ZW:זימבבואה
      ZZ:אזור לא ידוע
      """.trimIndent() }

  val hi: String by lazy { """
      001:विश्व
      002:अफ़्रीका
      003:उत्तर अमेरिका
      005:दक्षिण अमेरिका
      009:ओशिआनिया
      011:पश्चिमी अफ़्रीका
      013:मध्य अमेरिका
      014:पूर्वी अफ़्रीका
      015:उत्तरी अफ़्रीका
      017:मध्य अफ़्रीका
      018:दक्षिणी अफ़्रीका
      019:अमेरिकाज़
      021:उत्तरी अमेरिका
      029:कैरिबियन
      030:पूर्वी एशिया
      034:दक्षिणी एशिया
      035:दक्षिण-पूर्व एशिया
      039:दक्षिणी यूरोप
      053:ऑस्ट्रेलेशिया
      054:मेलानेशिया
      057:माइक्रोनेशियाई क्षेत्र
      061:पोलिनेशिया
      142:एशिया
      143:मध्य एशिया
      145:पश्चिमी एशिया
      150:यूरोप
      151:पूर्वी यूरोप
      154:उत्तरी यूरोप
      155:पश्चिमी यूरोप
      202:उप-सहारा अफ़्रीका
      419:लैटिन अमेरिका
      AC:असेंशन द्वीप
      AD:एंडोरा
      AE:संयुक्त अरब अमीरात
      AF:अफ़गानिस्तान
      AG:एंटिगुआ और बरबुडा
      AI:एंग्विला
      AL:अल्बानिया
      AM:आर्मेनिया
      AO:अंगोला
      AQ:अंटार्कटिका
      AR:अर्जेंटीना
      AS:अमेरिकी समोआ
      AT:ऑस्ट्रिया
      AU:ऑस्ट्रेलिया
      AW:अरूबा
      AX:एलैंड द्वीपसमूह
      AZ:अज़रबैजान
      BA:बोस्निया और हर्ज़ेगोविना
      BB:बारबाडोस
      BD:बांग्लादेश
      BE:बेल्जियम
      BF:बुर्किना फ़ासो
      BG:बुल्गारिया
      BH:बहरीन
      BI:बुरुंडी
      BJ:बेनिन
      BL:सेंट बार्थेलेमी
      BM:बरमूडा
      BN:ब्रूनेई
      BO:बोलीविया
      BQ:कैरिबियन नीदरलैंड
      BR:ब्राज़ील
      BS:बहामास
      BT:भूटान
      BV:बोवेत द्वीप
      BW:बोत्स्वाना
      BY:बेलारूस
      BZ:बेलीज़
      CA:कनाडा
      CC:कोकोस (कीलिंग) द्वीपसमूह
      CD:कांगो - किंशासा
      CF:मध्य अफ़्रीकी गणराज्य
      CG:कांगो – ब्राज़ाविल
      CH:स्विट्ज़रलैंड
      CI:कोत दिवुआर
      CK:कुक द्वीपसमूह
      CL:चिली
      CM:कैमरून
      CN:चीन
      CO:कोलंबिया
      CP:क्लिपर्टन द्वीप
      CR:कोस्टारिका
      CU:क्यूबा
      CV:केप वर्ड
      CW:कुरासाओ
      CX:क्रिसमस द्वीप
      CY:साइप्रस
      CZ:चेकिया
      DE:जर्मनी
      DG:डिएगो गार्सिया
      DJ:जिबूती
      DK:डेनमार्क
      DM:डोमिनिका
      DO:डोमिनिकन गणराज्य
      DZ:अल्जीरिया
      EA:सेउटा और मेलिला
      EC:इक्वाडोर
      EE:एस्टोनिया
      EG:मिस्र
      EH:पश्चिमी सहारा
      ER:इरिट्रिया
      ES:स्पेन
      ET:इथियोपिया
      EU:यूरोपीय संघ
      EZ:यूरोज़ोन
      FI:फ़िनलैंड
      FJ:फ़िजी
      FK:फ़ॉकलैंड द्वीपसमूह
      FM:माइक्रोनेशिया
      FO:फ़ेरो द्वीपसमूह
      FR:फ़्रांस
      GA:गैबॉन
      GB:यूनाइटेड किंगडम
      GD:ग्रेनाडा
      GE:जॉर्जिया
      GF:फ़्रेंच गुयाना
      GG:गर्नसी
      GH:घाना
      GI:जिब्राल्टर
      GL:ग्रीनलैंड
      GM:गाम्बिया
      GN:गिनी
      GP:ग्वाडेलूप
      GQ:इक्वेटोरियल गिनी
      GR:यूनान
      GS:दक्षिण जॉर्जिया और दक्षिण सैंडविच द्वीपसमूह
      GT:ग्वाटेमाला
      GU:गुआम
      GW:गिनी-बिसाउ
      GY:गुयाना
      HK:हाँग काँग (चीन विशेष प्रशासनिक क्षेत्र)
      HM:हर्ड द्वीप और मैकडोनॉल्ड द्वीपसमूह
      HN:होंडूरास
      HR:क्रोएशिया
      HT:हैती
      HU:हंगरी
      IC:कैनेरी द्वीपसमूह
      ID:इंडोनेशिया
      IE:आयरलैंड
      IL:इज़राइल
      IM:आइल ऑफ़ मैन
      IN:भारत
      IO:ब्रिटिश हिंद महासागरीय क्षेत्र
      IQ:इराक
      IR:ईरान
      IS:आइसलैंड
      IT:इटली
      JE:जर्सी
      JM:जमैका
      JO:जॉर्डन
      JP:जापान
      KE:केन्या
      KG:किर्गिज़स्तान
      KH:कंबोडिया
      KI:किरिबाती
      KM:कोमोरोस
      KN:सेंट किट्स और नेविस
      KP:उत्तर कोरिया
      KR:दक्षिण कोरिया
      KW:कुवैत
      KY:कैमेन द्वीपसमूह
      KZ:कज़ाखस्तान
      LA:लाओस
      LB:लेबनान
      LC:सेंट लूसिया
      LI:लिचेंस्टीन
      LK:श्रीलंका
      LR:लाइबेरिया
      LS:लेसोथो
      LT:लिथुआनिया
      LU:लग्ज़मबर्ग
      LV:लातविया
      LY:लीबिया
      MA:मोरक्को
      MC:मोनाको
      MD:मॉल्डोवा
      ME:मोंटेनेग्रो
      MF:सेंट मार्टिन
      MG:मेडागास्कर
      MH:मार्शल द्वीपसमूह
      MK:उत्तरी मकदूनिया
      ML:माली
      MM:म्यांमार (बर्मा)
      MN:मंगोलिया
      MO:मकाऊ (विशेष प्रशासनिक क्षेत्र चीन)
      MP:उत्तरी मारियाना द्वीपसमूह
      MQ:मार्टीनिक
      MR:मॉरिटानिया
      MS:मोंटसेरात
      MT:माल्टा
      MU:मॉरीशस
      MV:मालदीव
      MW:मलावी
      MX:मैक्सिको
      MY:मलेशिया
      MZ:मोज़ांबिक
      NA:नामीबिया
      NC:न्यू कैलेडोनिया
      NE:नाइजर
      NF:नॉरफ़ॉक द्वीप
      NG:नाइजीरिया
      NI:निकारागुआ
      NL:नीदरलैंड
      NO:नॉर्वे
      NP:नेपाल
      NR:नाउरु
      NU:नीयू
      NZ:न्यूज़ीलैंड
      OM:ओमान
      PA:पनामा
      PE:पेरू
      PF:फ़्रेंच पोलिनेशिया
      PG:पापुआ न्यू गिनी
      PH:फ़िलिपींस
      PK:पाकिस्तान
      PL:पोलैंड
      PM:सेंट पिएरे और मिक्वेलान
      PN:पिटकैर्न द्वीपसमूह
      PR:पोर्टो रिको
      PS:फ़िलिस्तीनी क्षेत्र
      PT:पुर्तगाल
      PW:पलाऊ
      PY:पराग्वे
      QA:क़तर
      QO:आउटलाइंग ओशिनिया
      RE:रियूनियन
      RO:रोमानिया
      RS:सर्बिया
      RU:रूस
      RW:रवांडा
      SA:सऊदी अरब
      SB:सोलोमन द्वीपसमूह
      SC:सेशेल्स
      SD:सूडान
      SE:स्वीडन
      SG:सिंगापुर
      SH:सेंट हेलेना
      SI:स्लोवेनिया
      SJ:स्वालबार्ड और जान मायेन
      SK:स्लोवाकिया
      SL:सिएरा लियोन
      SM:सैन मेरीनो
      SN:सेनेगल
      SO:सोमालिया
      SR:सूरीनाम
      SS:दक्षिण सूडान
      ST:साओ टोम और प्रिंसिपे
      SV:अल सल्वाडोर
      SX:सिंट मार्टिन
      SY:सीरिया
      SZ:एस्वाटिनी
      TA:ट्रिस्टन दा कुना
      TC:तुर्क और कैकोज़ द्वीपसमूह
      TD:चाड
      TF:फ़्रांसीसी दक्षिणी क्षेत्र
      TG:टोगो
      TH:थाईलैंड
      TJ:ताजिकिस्तान
      TK:तोकेलाउ
      TL:तिमोर-लेस्त
      TM:तुर्कमेनिस्तान
      TN:ट्यूनीशिया
      TO:टोंगा
      TR:तुर्किये
      TT:त्रिनिदाद और टोबैगो
      TV:तुवालू
      TW:ताइवान
      TZ:तंज़ानिया
      UA:यूक्रेन
      UG:युगांडा
      UM:यू॰एस॰ आउटलाइंग द्वीपसमूह
      UN:संयुक्त राष्ट्र
      US:संयुक्त राज्य
      UY:उरूग्वे
      UZ:उज़्बेकिस्तान
      VA:वेटिकन सिटी
      VC:सेंट विंसेंट और ग्रेनाडाइंस
      VE:वेनेज़ुएला
      VG:ब्रिटिश वर्जिन द्वीपसमूह
      VI:यू॰एस॰ वर्जिन द्वीपसमूह
      VN:वियतनाम
      VU:वनुआतू
      WF:वालिस और फ़्यूचूना
      WS:समोआ
      XA:सूडो-एक्सेंट
      XB:सूडो-बायडायरेक्शनल
      XK:कोसोवो
      YE:यमन
      YT:मायोते
      ZA:दक्षिण अफ़्रीका
      ZM:ज़ाम्बिया
      ZW:ज़िम्बाब्वे
      ZZ:अज्ञात क्षेत्र
      """.trimIndent() }

  val hi_Latn: String by lazy { """
      AX:Aland Islands
      BL:St. Barthelemy
      CI:Cote d’Ivoire
      CW:Curacao
      IN:Bharat
      KN:St. Kitts & Nevis
      LC:St. Lucia
      MF:St. Martin
      PM:St. Pierre & Miquelon
      RE:Reunion
      SH:St. Helena
      ST:Sao Tome & Principe
      TR:Turkiye
      UM:U.S. Outlying Islands
      VC:St. Vincent & Grenadines
      VI:U.S. Virgin Islands
      XB:Pseudo-Bidirectional
      """.trimIndent() }

  val hnj: String by lazy { """
      US:𞄒𞄫𞄱𞄔𞄩𞄴
      """.trimIndent() }

  val hnj_Hmnp: String? = null

  val hr: String by lazy { """
      001:Svijet
      002:Afrika
      003:Sjevernoamerički kontinent
      005:Južna Amerika
      009:Oceanija
      011:Zapadna Afrika
      013:Centralna Amerika
      014:Istočna Afrika
      015:Sjeverna Afrika
      017:Središnja Afrika
      018:Južna Afrika
      019:Amerike
      021:Sjeverna Amerika
      029:Karibi
      030:Istočna Azija
      034:Južna Azija
      035:Jugoistočna Azija
      039:Južna Europa
      053:Australazija
      054:Melanezija
      057:Mikronezijsko područje
      061:Polinezija
      142:Azija
      143:Srednja Azija
      145:Zapadna Azija
      150:Europa
      151:Istočna Europa
      154:Sjeverna Europa
      155:Zapadna Europa
      202:Subsaharska Afrika
      419:Latinska Amerika
      AC:Otok Uzašašća
      AD:Andora
      AE:Ujedinjeni Arapski Emirati
      AF:Afganistan
      AG:Antigva i Barbuda
      AI:Angvila
      AL:Albanija
      AM:Armenija
      AO:Angola
      AQ:Antarktika
      AR:Argentina
      AS:Američka Samoa
      AT:Austrija
      AU:Australija
      AW:Aruba
      AX:Ålandski otoci
      AZ:Azerbajdžan
      BA:Bosna i Hercegovina
      BB:Barbados
      BD:Bangladeš
      BE:Belgija
      BF:Burkina Faso
      BG:Bugarska
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Saint Barthélemy
      BM:Bermudi
      BN:Brunej
      BO:Bolivija
      BQ:Karipski otoci Nizozemske
      BR:Brazil
      BS:Bahami
      BT:Butan
      BV:Otok Bouvet
      BW:Bocvana
      BY:Bjelorusija
      BZ:Belize
      CA:Kanada
      CC:Kokosovi (Keelingovi) Otoci
      CD:Kongo - Kinshasa
      CF:Srednjoafrička Republika
      CG:Kongo - Brazzaville
      CH:Švicarska
      CI:Obala Bjelokosti
      CK:Cookovi Otoci
      CL:Čile
      CM:Kamerun
      CN:Kina
      CO:Kolumbija
      CP:Otok Clipperton
      CR:Kostarika
      CU:Kuba
      CV:Zelenortska Republika
      CW:Curaçao
      CX:Božićni Otok
      CY:Cipar
      CZ:Češka
      DE:Njemačka
      DG:Diego Garcia
      DJ:Džibuti
      DK:Danska
      DM:Dominika
      DO:Dominikanska Republika
      DZ:Alžir
      EA:Ceuta i Melilla
      EC:Ekvador
      EE:Estonija
      EG:Egipat
      EH:Zapadna Sahara
      ER:Eritreja
      ES:Španjolska
      ET:Etiopija
      EU:Europska unija
      EZ:eurozona
      FI:Finska
      FJ:Fidži
      FK:Falklandski Otoci
      FM:Mikronezija
      FO:Ovčji Otoci
      FR:Francuska
      GA:Gabon
      GB:Ujedinjeno Kraljevstvo
      GD:Grenada
      GE:Gruzija
      GF:Francuska Gijana
      GG:Guernsey
      GH:Gana
      GI:Gibraltar
      GL:Grenland
      GM:Gambija
      GN:Gvineja
      GP:Guadalupe
      GQ:Ekvatorska Gvineja
      GR:Grčka
      GS:Južna Georgia i Otoci Južni Sandwich
      GT:Gvatemala
      GU:Guam
      GW:Gvineja Bisau
      GY:Gvajana
      HK:PUP Hong Kong Kina
      HM:Otoci Heard i McDonald
      HN:Honduras
      HR:Hrvatska
      HT:Haiti
      HU:Mađarska
      IC:Kanari
      ID:Indonezija
      IE:Irska
      IL:Izrael
      IM:Otok Man
      IN:Indija
      IO:Britanski Indijskooceanski Teritorij
      IQ:Irak
      IR:Iran
      IS:Island
      IT:Italija
      JE:Jersey
      JM:Jamajka
      JO:Jordan
      JP:Japan
      KE:Kenija
      KG:Kirgistan
      KH:Kambodža
      KI:Kiribati
      KM:Komori
      KN:Sveti Kristofor i Nevis
      KP:Sjeverna Koreja
      KR:Južna Koreja
      KW:Kuvajt
      KY:Kajmanski Otoci
      KZ:Kazahstan
      LA:Laos
      LB:Libanon
      LC:Sveta Lucija
      LI:Lihtenštajn
      LK:Šri Lanka
      LR:Liberija
      LS:Lesoto
      LT:Litva
      LU:Luksemburg
      LV:Latvija
      LY:Libija
      MA:Maroko
      MC:Monako
      MD:Moldavija
      ME:Crna Gora
      MF:Saint Martin
      MG:Madagaskar
      MH:Maršalovi Otoci
      MK:Sjeverna Makedonija
      ML:Mali
      MM:Mjanmar (Burma)
      MN:Mongolija
      MO:PUP Makao Kina
      MP:Sjevernomarijanski Otoci
      MQ:Martinik
      MR:Mauretanija
      MS:Montserrat
      MT:Malta
      MU:Mauricijus
      MV:Maldivi
      MW:Malavi
      MX:Meksiko
      MY:Malezija
      MZ:Mozambik
      NA:Namibija
      NC:Nova Kaledonija
      NE:Niger
      NF:Otok Norfolk
      NG:Nigerija
      NI:Nikaragva
      NL:Nizozemska
      NO:Norveška
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Novi Zeland
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Francuska Polinezija
      PG:Papua Nova Gvineja
      PH:Filipini
      PK:Pakistan
      PL:Poljska
      PM:Sveti Petar i Mikelon
      PN:Pitcairnovi Otoci
      PR:Portoriko
      PS:Palestinsko područje
      PT:Portugal
      PW:Palau
      PY:Paragvaj
      QA:Katar
      QO:Vanjska područja Oceanije
      RE:Réunion
      RO:Rumunjska
      RS:Srbija
      RU:Rusija
      RW:Ruanda
      SA:Saudijska Arabija
      SB:Salomonovi Otoci
      SC:Sejšeli
      SD:Sudan
      SE:Švedska
      SG:Singapur
      SH:Sveta Helena
      SI:Slovenija
      SJ:Svalbard i Jan Mayen
      SK:Slovačka
      SL:Sijera Leone
      SM:San Marino
      SN:Senegal
      SO:Somalija
      SR:Surinam
      SS:Južni Sudan
      ST:Sveti Toma i Princip
      SV:Salvador
      SX:Sint Maarten
      SY:Sirija
      SZ:Esvatini
      TA:Tristan da Cunha
      TC:Otoci Turks i Caicos
      TD:Čad
      TF:Francuski Južni Teritoriji
      TG:Togo
      TH:Tajland
      TJ:Tadžikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunis
      TO:Tonga
      TR:Turska
      TT:Trinidad i Tobago
      TV:Tuvalu
      TW:Tajvan
      TZ:Tanzanija
      UA:Ukrajina
      UG:Uganda
      UM:Mali udaljeni otoci SAD-a
      UN:Ujedinjeni narodi
      US:Sjedinjene Američke Države
      UY:Urugvaj
      UZ:Uzbekistan
      VA:Vatikan
      VC:Sveti Vincent i Grenadini
      VE:Venezuela
      VG:Britanski Djevičanski Otoci
      VI:Američki Djevičanski Otoci
      VN:Vijetnam
      VU:Vanuatu
      WF:Wallis i Futuna
      WS:Samoa
      XA:pseudo naglasci
      XB:pseudo bidi
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Južnoafrička Republika
      ZM:Zambija
      ZW:Zimbabve
      ZZ:nepoznato područje
      """.trimIndent() }

  val hr_BA: String? = null

  val hsb: String by lazy { """
      001:swět
      002:Afrika
      003:Sewjerna Amerika
      005:Južna Amerika
      009:Oceaniska
      011:zapadna Afrika
      013:Srjedźna Amerika
      014:wuchodna Afrika
      015:sewjerna Afrika
      017:srjedźna Afrika
      018:južna Afrika
      019:Amerika
      021:sewjerny ameriski kontinent
      029:Karibika
      030:wuchodna Azija
      034:južna Azija
      035:juhowuchodna Azija
      039:južna Europa
      053:Awstralazija
      054:Melaneziska
      057:Mikroneziska (kupowy region)
      061:Polyneziska
      142:Azija
      143:centralna Azija
      145:zapadna Azija
      150:Europa
      151:wuchodna Europa
      154:sewjerna Europa
      155:zapadna Europa
      202:subsaharaska Afrika
      419:Łaćonska Amerika
      AC:Ascension
      AD:Andorra
      AE:Zjednoćene arabske emiraty
      AF:Afghanistan
      AG:Antigua a Barbuda
      AI:Anguilla
      AL:Albanska
      AM:Armenska
      AO:Angola
      AQ:Antarktika
      AR:Argentinska
      AS:Ameriska Samoa
      AT:Awstriska
      AU:Awstralska
      AW:Aruba
      AX:Åland
      AZ:Azerbajdźan
      BA:Bosniska a Hercegowina
      BB:Barbados
      BD:Bangladeš
      BE:Belgiska
      BF:Burkina Faso
      BG:Bołharska
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:St. Barthélemy
      BM:Bermudy
      BN:Brunei
      BO:Boliwiska
      BQ:Karibiska Nižozemska
      BR:Brazilska
      BS:Bahamy
      BT:Bhutan
      BV:Bouvetowa kupa
      BW:Botswana
      BY:Běłoruska
      BZ:Belize
      CA:Kanada
      CC:Kokosowe kupy
      CD:Kongo-Kinshasa
      CF:Centralnoafriska republika
      CG:Kongo-Brazzaville
      CH:Šwicarska
      CI:Côte d’Ivoire
      CK:Cookowe kupy
      CL:Chilska
      CM:Kamerun
      CN:China
      CO:Kolumbiska
      CP:Clippertonowa kupa
      CR:Kosta Rika
      CU:Kuba
      CV:Kap Verde
      CW:Curaçao
      CX:Hodowna kupa
      CY:Cypern
      CZ:Čěska republika
      DE:Němska
      DG:Diego Garcia
      DJ:Dźibuti
      DK:Danska
      DM:Dominika
      DO:Dominikanska republika
      DZ:Algeriska
      EA:Ceuta a Melilla
      EC:Ekwador
      EE:Estiska
      EG:Egyptowska
      EH:Zapadna Sahara
      ER:Eritreja
      ES:Španiska
      ET:Etiopiska
      EU:Europska unija
      EZ:europasmo
      FI:Finska
      FJ:Fidźi
      FK:Falklandske kupy
      FM:Mikroneziska
      FO:Färöske kupy
      FR:Francoska
      GA:Gabun
      GB:Zjednoćene kralestwo
      GD:Grenada
      GE:Georgiska
      GF:Francoska Guyana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grönlandska
      GM:Gambija
      GN:Gineja
      GP:Guadeloupe
      GQ:Ekwatorialna Gineja
      GR:Grjekska
      GS:Južna Georgiska a Južne Sandwichowe kupy
      GT:Guatemala
      GU:Guam
      GW:Gineja-Bissau
      GY:Guyana
      HK:Wosebita zarjadniska cona Hongkong
      HM:Heardowa kupa a McDonaldowe kupy
      HN:Honduras
      HR:Chorwatska
      HT:Haiti
      HU:Madźarska
      IC:Kanariske kupy
      ID:Indoneska
      IE:Irska
      IL:Israel
      IM:Man
      IN:Indiska
      IO:Britiski teritorij w Indiskim oceanje
      IQ:Irak
      IR:Iran
      IS:Islandska
      IT:Italska
      JE:Jersey
      JM:Jamaika
      JO:Jordaniska
      JP:Japanska
      KE:Kenija
      KG:Kirgizistan
      KH:Kambodźa
      KI:Kiribati
      KM:Komory
      KN:St. Kitts a Nevis
      KP:Sewjerna Koreja
      KR:Južna Koreja
      KW:Kuwait
      KY:Kajmanske kupy
      KZ:Kazachstan
      LA:Laos
      LB:Libanon
      LC:St. Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberija
      LS:Lesotho
      LT:Litawska
      LU:Luxemburgska
      LV:Letiska
      LY:Libyska
      MA:Marokko
      MC:Monaco
      MD:Moldawska
      ME:Montenegro
      MF:St. Martin
      MG:Madagaskar
      MH:Marshallowe kupy
      MK:Serwjerna Makedonska
      ML:Mali
      MM:Myanmar
      MN:Mongolska
      MO:Wosebita zarjadniska cona Macao
      MP:Sewjerne Mariany
      MQ:Martinique
      MR:Mawretanska
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Malediwy
      MW:Malawi
      MX:Mexiko
      MY:Malajzija
      MZ:Mosambik
      NA:Namibija
      NC:Nowa Kaledoniska
      NE:Niger
      NF:Norfolkowa kupa
      NG:Nigerija
      NI:Nikaragua
      NL:Nižozemska
      NO:Norwegska
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nowoseelandska
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Francoska Polyneziska
      PG:Papuwa-Nowa Gineja
      PH:Filipiny
      PK:Pakistan
      PL:Pólska
      PM:St. Pierre a Miquelon
      PN:Pitcairnowe kupy
      PR:Puerto Rico
      PS:Palestinski awtonomny teritorij
      PT:Portugalska
      PW:Palau
      PY:Paraguay
      QA:Katar
      QO:Wonkowna Oceaniska
      RE:Réunion
      RO:Rumunska
      RS:Serbiska
      RU:Ruska
      RW:Ruanda
      SA:Sawdi-Arabska
      SB:Salomony
      SC:Seychelle
      SD:Sudan
      SE:Šwedska
      SG:Singapur
      SH:St. Helena
      SI:Słowjenska
      SJ:Svalbard a Jan Mayen
      SK:Słowakska
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalija
      SR:Surinam
      SS:Južny Sudan
      ST:São Tomé a Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syriska
      SZ:Swaziska
      TA:Tristan da Cunha
      TC:kupy Turks a Caicos
      TD:Čad
      TF:Francoski južny a antarktiski teritorij
      TG:Togo
      TH:Thailandska
      TJ:Tadźikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmeniska
      TN:Tuneziska
      TO:Tonga
      TR:Turkowska
      TT:Trinidad a Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansanija
      UA:Ukraina
      UG:Uganda
      UM:Ameriska Oceaniska
      UN:Zjednoćene narody
      US:Zjednoćene staty Ameriki
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatikanske město
      VC:St. Vincent a Grenadiny
      VE:Venezuela
      VG:Britiske knježniske kupy
      VI:Ameriske knježniske kupy
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis a Futuna
      WS:Samoa
      XA:pseudo-akcenty
      XB:pseudo-bidi
      XK:Kosowo
      YE:Jemen
      YT:Mayotte
      ZA:Južna Afrika (Republika)
      ZM:Sambija
      ZW:Simbabwe
      ZZ:njeznaty region
      """.trimIndent() }

  val hu: String by lazy { """
      001:Világ
      002:Afrika
      003:Észak-Amerika
      005:Dél-Amerika
      009:Óceánia
      011:Nyugat-Afrika
      013:Közép-Amerika
      014:Kelet-Afrika
      015:Észak-Afrika
      017:Közép-Afrika
      018:Afrika déli része
      019:Amerika
      021:Amerika északi része
      029:Karib-térség
      030:Kelet-Ázsia
      034:Dél-Ázsia
      035:Délkelet-Ázsia
      039:Dél-Európa
      053:Ausztrálázsia
      054:Melanézia
      057:Mikronéziai régió
      061:Polinézia
      142:Ázsia
      143:Közép-Ázsia
      145:Nyugat-Ázsia
      150:Európa
      151:Kelet-Európa
      154:Észak-Európa
      155:Nyugat-Európa
      202:Szubszaharai Afrika
      419:Latin-Amerika
      AC:Ascension-sziget
      AD:Andorra
      AE:Egyesült Arab Emírségek
      AF:Afganisztán
      AG:Antigua és Barbuda
      AI:Anguilla
      AL:Albánia
      AM:Örményország
      AO:Angola
      AQ:Antarktisz
      AR:Argentína
      AS:Amerikai Szamoa
      AT:Ausztria
      AU:Ausztrália
      AW:Aruba
      AX:Åland-szigetek
      AZ:Azerbajdzsán
      BA:Bosznia-Hercegovina
      BB:Barbados
      BD:Banglades
      BE:Belgium
      BF:Burkina Faso
      BG:Bulgária
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Saint-Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolívia
      BQ:Holland Karib-térség
      BR:Brazília
      BS:Bahama-szigetek
      BT:Bhután
      BV:Bouvet-sziget
      BW:Botswana
      BY:Belarusz
      BZ:Belize
      CA:Kanada
      CC:Kókusz (Keeling)-szigetek
      CD:Kongó – Kinshasa
      CF:Közép-afrikai Köztársaság
      CG:Kongó – Brazzaville
      CH:Svájc
      CI:Elefántcsontpart
      CK:Cook-szigetek
      CL:Chile
      CM:Kamerun
      CN:Kína
      CO:Kolumbia
      CP:Clipperton-sziget
      CQ:Sark
      CR:Costa Rica
      CU:Kuba
      CV:Zöld-foki Köztársaság
      CW:Curaçao
      CX:Karácsony-sziget
      CY:Ciprus
      CZ:Csehország
      DE:Németország
      DG:Diego Garcia
      DJ:Dzsibuti
      DK:Dánia
      DM:Dominika
      DO:Dominikai Köztársaság
      DZ:Algéria
      EA:Ceuta és Melilla
      EC:Ecuador
      EE:Észtország
      EG:Egyiptom
      EH:Nyugat-Szahara
      ER:Eritrea
      ES:Spanyolország
      ET:Etiópia
      EU:Európai Unió
      EZ:Eurózóna
      FI:Finnország
      FJ:Fidzsi
      FK:Falkland-szigetek
      FM:Mikronézia
      FO:Feröer szigetek
      FR:Franciaország
      GA:Gabon
      GB:Egyesült Királyság
      GD:Grenada
      GE:Grúzia
      GF:Francia Guyana
      GG:Guernsey
      GH:Ghána
      GI:Gibraltár
      GL:Grönland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Egyenlítői-Guinea
      GR:Görögország
      GS:Déli-Georgia és Déli-Sandwich-szigetek
      GT:Guatemala
      GU:Guam
      GW:Bissau-Guinea
      GY:Guyana
      HK:Hongkong KKT
      HM:Heard-sziget és McDonald-szigetek
      HN:Honduras
      HR:Horvátország
      HT:Haiti
      HU:Magyarország
      IC:Kanári-szigetek
      ID:Indonézia
      IE:Írország
      IL:Izrael
      IM:Man-sziget
      IN:India
      IO:Brit Indiai-óceáni Terület
      IQ:Irak
      IR:Irán
      IS:Izland
      IT:Olaszország
      JE:Jersey
      JM:Jamaica
      JO:Jordánia
      JP:Japán
      KE:Kenya
      KG:Kirgizisztán
      KH:Kambodzsa
      KI:Kiribati
      KM:Comore-szigetek
      KN:Saint Kitts és Nevis
      KP:Észak-Korea
      KR:Dél-Korea
      KW:Kuvait
      KY:Kajmán-szigetek
      KZ:Kazahsztán
      LA:Laosz
      LB:Libanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Srí Lanka
      LR:Libéria
      LS:Lesotho
      LT:Litvánia
      LU:Luxemburg
      LV:Lettország
      LY:Líbia
      MA:Marokkó
      MC:Monaco
      MD:Moldova
      ME:Montenegró
      MF:Saint Martin
      MG:Madagaszkár
      MH:Marshall-szigetek
      MK:Észak-Macedónia
      ML:Mali
      MM:Mianmar
      MN:Mongólia
      MO:Makaó KKT
      MP:Északi Mariana-szigetek
      MQ:Martinique
      MR:Mauritánia
      MS:Montserrat
      MT:Málta
      MU:Mauritius
      MV:Maldív-szigetek
      MW:Malawi
      MX:Mexikó
      MY:Malajzia
      MZ:Mozambik
      NA:Namíbia
      NC:Új-Kaledónia
      NE:Niger
      NF:Norfolk-sziget
      NG:Nigéria
      NI:Nicaragua
      NL:Hollandia
      NO:Norvégia
      NP:Nepál
      NR:Nauru
      NU:Niue
      NZ:Új-Zéland
      OM:Omán
      PA:Panama
      PE:Peru
      PF:Francia Polinézia
      PG:Pápua Új-Guinea
      PH:Fülöp-szigetek
      PK:Pakisztán
      PL:Lengyelország
      PM:Saint-Pierre és Miquelon
      PN:Pitcairn-szigetek
      PR:Puerto Rico
      PS:Palesztin Autonómia
      PT:Portugália
      PW:Palau
      PY:Paraguay
      QA:Katar
      QO:Külső-Óceánia
      RE:Réunion
      RO:Románia
      RS:Szerbia
      RU:Oroszország
      RW:Ruanda
      SA:Szaúd-Arábia
      SB:Salamon-szigetek
      SC:Seychelle-szigetek
      SD:Szudán
      SE:Svédország
      SG:Szingapúr
      SH:Szent Ilona
      SI:Szlovénia
      SJ:Svalbard és Jan Mayen
      SK:Szlovákia
      SL:Sierra Leone
      SM:San Marino
      SN:Szenegál
      SO:Szomália
      SR:Suriname
      SS:Dél-Szudán
      ST:São Tomé és Príncipe
      SV:Salvador
      SX:Sint Maarten
      SY:Szíria
      SZ:Szváziföld
      TA:Tristan da Cunha
      TC:Turks- és Caicos-szigetek
      TD:Csád
      TF:Francia Déli Területek
      TG:Togo
      TH:Thaiföld
      TJ:Tádzsikisztán
      TK:Tokelau
      TL:Kelet-Timor
      TM:Türkmenisztán
      TN:Tunézia
      TO:Tonga
      TR:Törökország
      TT:Trinidad és Tobago
      TV:Tuvalu
      TW:Tajvan
      TZ:Tanzánia
      UA:Ukrajna
      UG:Uganda
      UM:Az USA lakatlan külbirtokai
      UN:Egyesült Nemzetek Szervezete
      US:Egyesült Államok
      UY:Uruguay
      UZ:Üzbegisztán
      VA:Vatikán
      VC:Saint Vincent és a Grenadine-szigetek
      VE:Venezuela
      VG:Brit Virgin-szigetek
      VI:Amerikai Virgin-szigetek
      VN:Vietnám
      VU:Vanuatu
      WF:Wallis és Futuna
      WS:Szamoa
      XA:Pszeudo-nyelvjárások
      XB:Pszeudo-kétirányú
      XK:Koszovó
      YE:Jemen
      YT:Mayotte
      ZA:Dél-afrikai Köztársaság
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Ismeretlen körzet
      """.trimIndent() }

  val hy: String by lazy { """
      001:Աշխարհ
      002:Աֆրիկա
      003:Հյուսիսային Ամերիկա
      005:Հարավային Ամերիկա
      009:Օվկիանիա
      011:Արևմտյան Աֆրիկա
      013:Կենտրոնական Ամերիկա
      014:Արևելյան Աֆրիկա
      015:Հյուսիսային Աֆրիկա
      017:Կենտրոնական Աֆրիկա
      018:Հարավային Աֆրիկա
      019:Ամերիկա
      021:Հյուսիսային Ամերիկա - ԱՄՆ և Կանադա
      029:Կարիբներ
      030:Արևելյան Ասիա
      034:Հարավային Ասիա
      035:Հարավարևելյան Ասիա
      039:Հարավային Եվրոպա
      053:Ավստրալասիա
      054:Մելանեզիա
      057:Միկրոնեզյան տարածաշրջան
      061:Պոլինեզիա
      142:Ասիա
      143:Կենտրոնական Ասիա
      145:Արևմտյան Ասիա
      150:Եվրոպա
      151:Արևելյան Եվրոպա
      154:Հյուսիսային Եվրոպա
      155:Արևմտյան Եվրոպա
      202:Արևադարձային Աֆրիկա
      419:Լատինական Ամերիկա
      AC:Համբարձման կղզի
      AD:Անդորրա
      AE:Արաբական Միացյալ Էմիրություններ
      AF:Աֆղանստան
      AG:Անտիգուա և Բարբուդա
      AI:Անգուիլա
      AL:Ալբանիա
      AM:Հայաստան
      AO:Անգոլա
      AQ:Անտարկտիդա
      AR:Արգենտինա
      AS:Ամերիկյան Սամոա
      AT:Ավստրիա
      AU:Ավստրալիա
      AW:Արուբա
      AX:Ալանդյան կղզիներ
      AZ:Ադրբեջան
      BA:Բոսնիա և Հերցեգովինա
      BB:Բարբադոս
      BD:Բանգլադեշ
      BE:Բելգիա
      BF:Բուրկինա Ֆասո
      BG:Բուլղարիա
      BH:Բահրեյն
      BI:Բուրունդի
      BJ:Բենին
      BL:Սուրբ Բարդուղիմեոս
      BM:Բերմուդներ
      BN:Բրունեյ
      BO:Բոլիվիա
      BQ:Կարիբյան Նիդեռլանդներ
      BR:Բրազիլիա
      BS:Բահամյան կղզիներ
      BT:Բութան
      BV:Բուվե կղզի
      BW:Բոտսվանա
      BY:Բելառուս
      BZ:Բելիզ
      CA:Կանադա
      CC:Կոկոսյան (Քիլինգ) կղզիներ
      CD:Կոնգո - Կինշասա
      CF:Կենտրոնական Աֆրիկյան Հանրապետություն
      CG:Կոնգո - Բրազավիլ
      CH:Շվեյցարիա
      CI:Կոտ դ՚Իվուար
      CK:Կուկի կղզիներ
      CL:Չիլի
      CM:Կամերուն
      CN:Չինաստան
      CO:Կոլումբիա
      CP:Քլիփերթոն կղզի
      CR:Կոստա Ռիկա
      CU:Կուբա
      CV:Կաբո Վերդե
      CW:Կյուրասաո
      CX:Սուրբ Ծննդյան կղզի
      CY:Կիպրոս
      CZ:Չեխիա
      DE:Գերմանիա
      DG:Դիեգո Գարսիա
      DJ:Ջիբութի
      DK:Դանիա
      DM:Դոմինիկա
      DO:Դոմինիկյան Հանրապետություն
      DZ:Ալժիր
      EA:Սեուտա և Մելիլյա
      EC:Էկվադոր
      EE:Էստոնիա
      EG:Եգիպտոս
      EH:Արևմտյան Սահարա
      ER:Էրիթրեա
      ES:Իսպանիա
      ET:Եթովպիա
      EU:Եվրոպական Միություն
      EZ:Եվրագոտի
      FI:Ֆինլանդիա
      FJ:Ֆիջի
      FK:Ֆոլքլենդյան կղզիներ
      FM:Միկրոնեզիա
      FO:Ֆարերյան կղզիներ
      FR:Ֆրանսիա
      GA:Գաբոն
      GB:Միացյալ Թագավորություն
      GD:Գրենադա
      GE:Վրաստան
      GF:Ֆրանսիական Գվիանա
      GG:Գերնսի
      GH:Գանա
      GI:Ջիբրալթար
      GL:Գրենլանդիա
      GM:Գամբիա
      GN:Գվինեա
      GP:Գվադելուպա
      GQ:Հասարակածային Գվինեա
      GR:Հունաստան
      GS:Հարավային Ջորջիա և Հարավային Սենդվիչյան կղզիներ
      GT:Գվատեմալա
      GU:Գուամ
      GW:Գվինեա-Բիսաու
      GY:Գայանա
      HK:Հոնկոնգի ՀՎՇ
      HM:Հերդ կղզի և ՄակԴոնալդի կղզիներ
      HN:Հոնդուրաս
      HR:Խորվաթիա
      HT:Հայիթի
      HU:Հունգարիա
      IC:Կանարյան կղզիներ
      ID:Ինդոնեզիա
      IE:Իռլանդիա
      IL:Իսրայել
      IM:Մեն կղզի
      IN:Հնդկաստան
      IO:Բրիտանական տարածք Հնդկական Օվկիանոսում
      IQ:Իրաք
      IR:Իրան
      IS:Իսլանդիա
      IT:Իտալիա
      JE:Ջերսի
      JM:Ճամայկա
      JO:Հորդանան
      JP:Ճապոնիա
      KE:Քենիա
      KG:Ղրղզստան
      KH:Կամբոջա
      KI:Կիրիբատի
      KM:Կոմորյան կղզիներ
      KN:Սենթ Քիտս և Նևիս
      KP:Հյուսիսային Կորեա
      KR:Հարավային Կորեա
      KW:Քուվեյթ
      KY:Կայմանյան կղզիներ
      KZ:Ղազախստան
      LA:Լաոս
      LB:Լիբանան
      LC:Սենթ Լյուսիա
      LI:Լիխտենշտեյն
      LK:Շրի Լանկա
      LR:Լիբերիա
      LS:Լեսոտո
      LT:Լիտվա
      LU:Լյուքսեմբուրգ
      LV:Լատվիա
      LY:Լիբիա
      MA:Մարոկկո
      MC:Մոնակո
      MD:Մոլդովա
      ME:Չեռնոգորիա
      MF:Սեն Մարտեն
      MG:Մադագասկար
      MH:Մարշալյան կղզիներ
      MK:Հյուսիսային Մակեդոնիա
      ML:Մալի
      MM:Մյանմա (Բիրմա)
      MN:Մոնղոլիա
      MO:Չինաստանի Մակաո ՀՎՇ
      MP:Հյուսիսային Մարիանյան կղզիներ
      MQ:Մարտինիկա
      MR:Մավրիտանիա
      MS:Մոնսեռատ
      MT:Մալթա
      MU:Մավրիկիոս
      MV:Մալդիվներ
      MW:Մալավի
      MX:Մեքսիկա
      MY:Մալայզիա
      MZ:Մոզամբիկ
      NA:Նամիբիա
      NC:Նոր Կալեդոնիա
      NE:Նիգեր
      NF:Նորֆոլկ կղզի
      NG:Նիգերիա
      NI:Նիկարագուա
      NL:Նիդեռլանդներ
      NO:Նորվեգիա
      NP:Նեպալ
      NR:Նաուրու
      NU:Նիուե
      NZ:Նոր Զելանդիա
      OM:Օման
      PA:Պանամա
      PE:Պերու
      PF:Ֆրանսիական Պոլինեզիա
      PG:Պապուա Նոր Գվինեա
      PH:Ֆիլիպիններ
      PK:Պակիստան
      PL:Լեհաստան
      PM:Սեն Պիեռ և Միքելոն
      PN:Պիտկեռն կղզիներ
      PR:Պուերտո Ռիկո
      PS:Պաղեստինյան տարածքներ
      PT:Պորտուգալիա
      PW:Պալաու
      PY:Պարագվայ
      QA:Կատար
      QO:Արտաքին Օվկիանիա
      RE:Ռեյունիոն
      RO:Ռումինիա
      RS:Սերբիա
      RU:Ռուսաստան
      RW:Ռուանդա
      SA:Սաուդյան Արաբիա
      SB:Սողոմոնյան կղզիներ
      SC:Սեյշելներ
      SD:Սուդան
      SE:Շվեդիա
      SG:Սինգապուր
      SH:Սուրբ Հեղինեի կղզի
      SI:Սլովենիա
      SJ:Սվալբարդ և Յան Մայեն
      SK:Սլովակիա
      SL:Սիեռա Լեոնե
      SM:Սան Մարինո
      SN:Սենեգալ
      SO:Սոմալի
      SR:Սուրինամ
      SS:Հարավային Սուդան
      ST:Սան Տոմե և Փրինսիպի
      SV:Սալվադոր
      SX:Սինտ Մարտեն
      SY:Սիրիա
      SZ:Էսվատինի
      TA:Տրիստան դա Կունյա
      TC:Թըրքս և Կայկոս կղզիներ
      TD:Չադ
      TF:Ֆրանսիական Հարավային Տարածքներ
      TG:Տոգո
      TH:Թաիլանդ
      TJ:Տաջիկստան
      TK:Տոկելաու
      TL:Թիմոր Լեշտի
      TM:Թուրքմենստան
      TN:Թունիս
      TO:Տոնգա
      TR:Թուրքիա
      TT:Տրինիդադ և Տոբագո
      TV:Տուվալու
      TW:Թայվան
      TZ:Տանզանիա
      UA:Ուկրաինա
      UG:Ուգանդա
      UM:Արտաքին կղզիներ (ԱՄՆ)
      UN:Միավորված ազգերի կազմակերպություն
      US:Միացյալ Նահանգներ
      UY:Ուրուգվայ
      UZ:Ուզբեկստան
      VA:Վատիկան
      VC:Սենթ Վինսենթ և Գրենադիններ
      VE:Վենեսուելա
      VG:Բրիտանական Վիրջինյան կղզիներ
      VI:ԱՄՆ Վիրջինյան կղզիներ
      VN:Վիետնամ
      VU:Վանուատու
      WF:Ուոլիս և Ֆուտունա
      WS:Սամոա
      XA:կեղծ տարբերիչներ
      XB:կեղծ երկուղղված
      XK:Կոսովո
      YE:Եմեն
      YT:Մայոտ
      ZA:Հարավաֆրիկյան Հանրապետություն
      ZM:Զամբիա
      ZW:Զիմբաբվե
      ZZ:Անհայտ տարածաշրջան
      """.trimIndent() }

  val ia: String by lazy { """
      001:mundo
      002:Africa
      003:America del Nord
      005:America del Sud
      009:Oceania
      011:Africa occidental
      013:America central
      014:Africa oriental
      015:Africa septentrional
      017:Africa central
      018:Africa meridional
      019:Americas
      021:America septentrional
      029:Caribes
      030:Asia oriental
      034:Asia meridional
      035:Asia del sud-est
      039:Europa meridional
      053:Australasia
      054:Melanesia
      057:Region micronesian
      061:Polynesia
      142:Asia
      143:Asia central
      145:Asia occidental
      150:Europa
      151:Europa oriental
      154:Europa septentrional
      155:Europa occidental
      202:Africa subsaharian
      419:America latin
      AC:Insula del Ascension
      AD:Andorra
      AE:Emiratos Arabe Unite
      AF:Afghanistan
      AG:Antigua e Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarctica
      AR:Argentina
      AS:Samoa american
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Insulas Åland
      AZ:Azerbaidzhan
      BA:Bosnia e Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgica
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Sancte Bartholomeo
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Paises Basse caribe
      BR:Brasil
      BS:Bahamas
      BT:Bhutan
      BV:Insula de Bouvet
      BW:Botswana
      BY:Bielorussia
      BZ:Belize
      CA:Canada
      CC:Insulas Cocos (Keeling)
      CD:Congo - Kinshasa
      CF:Republica African Central
      CG:Congo - Brazzaville
      CH:Suissa
      CI:Costa de Ebore
      CK:Insulas Cook
      CL:Chile
      CM:Camerun
      CN:China
      CO:Colombia
      CP:Insula Clipperton
      CQ:Sark
      CR:Costa Rica
      CU:Cuba
      CV:Capo Verde
      CW:Curaçao
      CX:Insula de Natal
      CY:Cypro
      CZ:Chechia
      DE:Germania
      DG:Diego Garcia
      DJ:Djibuti
      DK:Danmark
      DM:Dominica
      DO:Republica Dominican
      DZ:Algeria
      EA:Ceuta e Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egypto
      EH:Sahara occidental
      ER:Eritrea
      ES:Espania
      ET:Ethiopia
      EU:Union Europee
      EZ:Zona euro
      FI:Finlandia
      FJ:Fiji
      FK:Insulas Falkland
      FM:Micronesia
      FO:Insulas Feroe
      FR:Francia
      GA:Gabon
      GB:Regno Unite
      GD:Grenada
      GE:Georgia
      GF:Guyana francese
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Groenlandia
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Guinea equatorial
      GR:Grecia
      GS:Georgia del Sud e Insulas Sandwich Austral
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hongkong, R.A.S. de China
      HM:Insulas Heard e McDonald
      HN:Honduras
      HR:Croatia
      HT:Haiti
      HU:Hungaria
      IC:Insulas Canari
      ID:Indonesia
      IE:Irlanda
      IL:Israel
      IM:Insula de Man
      IN:India
      IO:Territorio oceanic britanno-indian
      IQ:Irak
      IR:Iran
      IS:Islanda
      IT:Italia
      JE:Jersey
      JM:Jamaica
      JO:Jordania
      JP:Japon
      KE:Kenya
      KG:Kirghizistan
      KH:Cambodgia
      KI:Kiribati
      KM:Comoros
      KN:Sancte Christophoro e Nevis
      KP:Corea del Nord
      KR:Corea del Sud
      KW:Kuwait
      KY:Insulas de Caiman
      KZ:Kazakhstan
      LA:Laos
      LB:Libano
      LC:Sancte Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lituania
      LU:Luxemburg
      LV:Lettonia
      LY:Libya
      MA:Marocco
      MC:Monaco
      MD:Moldavia
      ME:Montenegro
      MF:Sancte Martino francese
      MG:Madagascar
      MH:Insulas Marshall
      MK:Macedonia del Nord
      ML:Mali
      MM:Myanmar (Birmania)
      MN:Mongolia
      MO:Macao, R.A.S. de China
      MP:Insulas Marianna del Nord
      MQ:Martinica
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritio
      MV:Maldivas
      MW:Malawi
      MX:Mexico
      MY:Malaysia
      MZ:Mozambique
      NA:Namibia
      NC:Nove Caledonia
      NE:Niger
      NF:Insula Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Nederlandia
      NO:Norvegia
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nove Zelanda
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Polynesia francese
      PG:Papua Nove Guinea
      PH:Philippinas
      PK:Pakistan
      PL:Polonia
      PM:St. Pierre e Miquelon
      PN:Insulas Pitcairn
      PR:Porto Rico
      PS:Territorios palestin
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Oceania remote
      RE:Reunion
      RO:Romania
      RS:Serbia
      RU:Russia
      RW:Ruanda
      SA:Arabia Saudita
      SB:Insulas Solomon
      SC:Seychelles
      SD:Sudan
      SE:Svedia
      SG:Singapur
      SH:Sancte Helena
      SI:Slovenia
      SJ:Svalbard e Jan Mayen
      SK:Slovachia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:Sudan del Sud
      ST:São Tomé e Príncipe
      SV:El Salvador
      SX:Sancte Martino nederlandese
      SY:Syria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Insulas Turcos e Caicos
      TD:Tchad
      TF:Territorios meridional francese
      TG:Togo
      TH:Thailandia
      TJ:Tadzhikistan
      TK:Tokelau
      TL:Timor del Est
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turchia
      TT:Trinidad e Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraina
      UG:Uganda
      UM:Insulas peripheric del SUA
      UN:Nationes Unite
      US:Statos Unite
      UY:Uruguay
      UZ:Uzbekistan
      VA:Citate del Vaticano
      VC:Sancte Vincente e le Grenadinas
      VE:Venezuela
      VG:Insulas Virgine britannic
      VI:Insulas Virgine statounitese
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis e Futuna
      WS:Samoa
      XA:Pseudo-accentos
      XB:Pseudo-bidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:Africa del Sud
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Region incognite
      """.trimIndent() }

  val id: String by lazy { """
      001:Dunia
      002:Afrika
      003:Amerika Utara
      005:Amerika Selatan
      009:Oseania
      011:Afrika Bagian Barat
      013:Amerika Tengah
      014:Afrika Bagian Timur
      015:Afrika Bagian Utara
      017:Afrika Bagian Tengah
      018:Afrika Bagian Selatan
      019:Amerika
      021:Amerika Bagian Utara
      029:Kepulauan Karibia
      030:Asia Bagian Timur
      034:Asia Bagian Selatan
      035:Asia Tenggara
      039:Eropa Bagian Selatan
      053:Australasia
      054:Melanesia
      057:Wilayah Mikronesia
      061:Polinesia
      142:Asia
      143:Asia Tengah
      145:Asia Bagian Barat
      150:Eropa
      151:Eropa Bagian Timur
      154:Eropa Bagian Utara
      155:Eropa Bagian Barat
      202:Afrika Sub-Sahara
      419:Amerika Latin
      AC:Pulau Ascension
      AD:Andorra
      AE:Uni Emirat Arab
      AF:Afganistan
      AG:Antigua dan Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarktika
      AR:Argentina
      AS:Samoa Amerika
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Kepulauan Aland
      AZ:Azerbaijan
      BA:Bosnia dan Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgia
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Saint Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Belanda Karibia
      BR:Brasil
      BS:Bahama
      BT:Bhutan
      BV:Pulau Bouvet
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Kanada
      CC:Kepulauan Cocos (Keeling)
      CD:Kongo - Kinshasa
      CF:Republik Afrika Tengah
      CG:Kongo - Brazzaville
      CH:Swiss
      CI:Côte d’Ivoire
      CK:Kepulauan Cook
      CL:Cile
      CM:Kamerun
      CN:Tiongkok
      CO:Kolombia
      CP:Pulau Clipperton
      CR:Kosta Rika
      CU:Kuba
      CV:Tanjung Verde
      CW:Curaçao
      CX:Pulau Natal
      CY:Siprus
      CZ:Ceko
      DE:Jerman
      DG:Diego Garcia
      DJ:Jibuti
      DK:Denmark
      DM:Dominika
      DO:Republik Dominika
      DZ:Aljazair
      EA:Ceuta dan Melilla
      EC:Ekuador
      EE:Estonia
      EG:Mesir
      EH:Sahara Barat
      ER:Eritrea
      ES:Spanyol
      ET:Etiopia
      EU:Uni Eropa
      EZ:Zona Euro
      FI:Finlandia
      FJ:Fiji
      FK:Kepulauan Falkland
      FM:Mikronesia
      FO:Kepulauan Faroe
      FR:Prancis
      GA:Gabon
      GB:Inggris Raya
      GD:Grenada
      GE:Georgia
      GF:Guyana Prancis
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Greenland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Guinea Ekuatorial
      GR:Yunani
      GS:Georgia Selatan & Kep. Sandwich Selatan
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hong Kong DAK Tiongkok
      HM:Pulau Heard dan Kepulauan McDonald
      HN:Honduras
      HR:Kroasia
      HT:Haiti
      HU:Hungaria
      IC:Kepulauan Canaria
      ID:Indonesia
      IE:Irlandia
      IL:Israel
      IM:Pulau Man
      IN:India
      IO:Wilayah Inggris di Samudra Hindia
      IQ:Irak
      IR:Iran
      IS:Islandia
      IT:Italia
      JE:Jersey
      JM:Jamaika
      JO:Yordania
      JP:Jepang
      KE:Kenya
      KG:Kirgizstan
      KH:Kamboja
      KI:Kiribati
      KM:Komoro
      KN:Saint Kitts dan Nevis
      KP:Korea Utara
      KR:Korea Selatan
      KW:Kuwait
      KY:Kepulauan Cayman
      KZ:Kazakhstan
      LA:Laos
      LB:Lebanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lituania
      LU:Luksemburg
      LV:Latvia
      LY:Libya
      MA:Maroko
      MC:Monako
      MD:Moldova
      ME:Montenegro
      MF:Saint Martin
      MG:Madagaskar
      MH:Kepulauan Marshall
      MK:Makedonia Utara
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Makau DAK Tiongkok
      MP:Kepulauan Mariana Utara
      MQ:Martinik
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maladewa
      MW:Malawi
      MX:Meksiko
      MY:Malaysia
      MZ:Mozambik
      NA:Namibia
      NC:Kaledonia Baru
      NE:Niger
      NF:Kepulauan Norfolk
      NG:Nigeria
      NI:Nikaragua
      NL:Belanda
      NO:Norwegia
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Selandia Baru
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Polinesia Prancis
      PG:Papua Nugini
      PH:Filipina
      PK:Pakistan
      PL:Polandia
      PM:Saint Pierre dan Miquelon
      PN:Kepulauan Pitcairn
      PR:Puerto Riko
      PS:Wilayah Palestina
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Oseania Luar
      RE:Réunion
      RO:Rumania
      RS:Serbia
      RU:Rusia
      RW:Rwanda
      SA:Arab Saudi
      SB:Kepulauan Solomon
      SC:Seychelles
      SD:Sudan
      SE:Swedia
      SG:Singapura
      SH:Saint Helena
      SI:Slovenia
      SJ:Kepulauan Svalbard dan Jan Mayen
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:Sudan Selatan
      ST:Sao Tome dan Principe
      SV:El Salvador
      SX:Sint Maarten
      SY:Suriah
      SZ:eSwatini
      TA:Tristan da Cunha
      TC:Kepulauan Turks dan Caicos
      TD:Chad
      TF:Wilayah Selatan Prancis
      TG:Togo
      TH:Thailand
      TJ:Tajikistan
      TK:Tokelau
      TL:Timor Leste
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turki
      TT:Trinidad dan Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraina
      UG:Uganda
      UM:Kepulauan Terluar AS
      UN:Perserikatan Bangsa-Bangsa
      US:Amerika Serikat
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatikan
      VC:Saint Vincent dan Grenadine
      VE:Venezuela
      VG:Kepulauan Virgin Britania Raya
      VI:Kepulauan Virgin Amerika Serikat
      VN:Vietnam
      VU:Vanuatu
      WF:Kepulauan Wallis dan Futuna
      WS:Samoa
      XA:Aksen Asing
      XB:Pseudo-Bidi
      XK:Kosovo
      YE:Yaman
      YT:Mayotte
      ZA:Afrika Selatan
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Wilayah Tidak Dikenal
      """.trimIndent() }

  val ie: String by lazy { """
      001:munde
      002:Africa
      005:Sud-America
      009:Oceania
      013:central America
      019:Americas
      021:Nord-America
      142:Asia
      150:Europa
      419:latin America
      AL:Albania
      AQ:Antarctica
      AT:Austria
      BA:Bosnia e Herzegovina
      BE:Belgia
      BG:Bulgaria
      CH:Svissia
      CZ:Tchekia
      DE:Germania
      DK:Dania
      EE:Estonia
      ER:Eritrea
      ES:Hispania
      ET:Etiopia
      EU:Union Europan
      EZ:Zone de euro
      FI:Finland
      FJ:Fidji
      FR:Francia
      GB:Unit Reyia
      GR:Grecia
      GY:Guyana
      HR:Croatia
      HU:Hungaria
      ID:Indonesia
      IE:Irland
      IN:India
      IR:Iran
      IS:Island
      IT:Italia
      KH:Cambodja
      LK:Sri-Lanka
      LU:Luxemburg
      MC:Mónaco
      ME:Montenegro
      MK:Nord-Macedonia
      MQ:Martinica
      MT:Malta
      MU:Mauricio
      MV:Maldivas
      NF:Insul Norfolk
      NR:Nauru
      NZ:Nov-Zeland
      PE:Perú
      PH:Filipines
      PK:Pakistan
      PL:Polonia
      PR:Porto-Rico
      PT:Portugal
      PW:Palau
      RO:Rumania
      RS:Serbia
      RU:Russia
      SE:Svedia
      SI:Slovenia
      SK:Slovakia
      SM:San-Marino
      SX:Sint-Maarten
      TC:Turks e Caicos
      TD:Tchad
      TK:Tokelau
      TL:Ost-Timor
      TT:Trinidad e Tobago
      TV:Tuvalu
      UA:Ukraina
      UN:Unit Nationes
      VU:Vanuatu
      WS:Samoa
      XK:Kosovo
      ZZ:ínconosset region
      """.trimIndent() }

  val ig: String by lazy { """
      001:Uwa
      002:Afrika
      003:Mpaghara Ugwu Amerịka
      005:Mpaghara Mgbada Ugwu America
      009:Oceania
      011:Mpaghara Ọdịda Anyanwụ Afrịka
      013:Etiti America
      014:Mpaghara Ọwụwa Anyanwụ Afrịka
      015:Mpaghara Ugwu Afrịka
      017:Etiti Afrịka
      018:Mpaghara Mgbada Ugwu Afrịka
      019:Amerịka
      021:Mpaghara Ugwu America
      029:Caribbean
      030:Mpaghara Ọwụwa Anyanwụ Asia
      034:Mpaghara Mgbada Ugwu Asia
      035:Mpaghara Mgbada Ugwu Asia dị na Ọwụwa Anyanwụ
      039:Mpaghara Mgbada Ugwu Europe
      053:Australasia
      054:Melanesia
      057:Mpaghara Micronesian
      061:Polynesia
      142:Asia
      143:Etiti Asia
      145:Mpaghara Ọdịda Anyanwụ Asia
      150:Europe
      151:Mpaghara Ọwụwa Anyanwụ Europe
      154:Mpaghara Ugwu Europe
      155:Mpaghara Ọdịda Anyanwụ Europe
      202:Sub-Saharan Afrịka
      419:Latin America
      AC:Ascension Island
      AD:Andorra
      AE:United Arab Emirates
      AF:Afghanistan
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarctica
      AR:Argentina
      AS:American Samoa
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Åland Islands
      AZ:Azerbaijan
      BA:Bosnia & Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgium
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:St. Barthélemy
      BM:Bemuda
      BN:Brunei
      BO:Bolivia
      BQ:Caribbean Netherlands
      BR:Brazil
      BS:Bahamas
      BT:Bhutan
      BV:Bouvet Island
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Canada
      CC:Agwaetiti Cocos (Keeling)
      CD:Congo - Kinshasa
      CF:Central African Republik
      CG:Congo
      CH:Switzerland
      CI:Côte d’Ivoire
      CK:Agwaetiti Cook
      CL:Chile
      CM:Cameroon
      CN:China
      CO:Colombia
      CP:Agwaetiti Clipperton
      CQ:Sark
      CR:Kosta Rika
      CU:Cuba
      CV:Cape Verde
      CW:Kurakao
      CX:Agwaetiti Christmas
      CY:Cyprus
      CZ:Czechia
      DE:Germany
      DG:Diego Garcia
      DJ:Djibouti
      DK:Denmark
      DM:Dominica
      DO:Dominican Republik
      DZ:Algeria
      EA:Ceuta & Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egypt
      EH:Ọdịda Anyanwụ Sahara
      ER:Eritrea
      ES:Spain
      ET:Ethiopia
      EU:Otu nzukọ mba Europe
      EZ:Gburugburu Euro
      FI:Finland
      FJ:Fiji
      FK:Falkland Islands
      FM:Micronesia
      FO:Faroe Islands
      FR:France
      GA:Gabon
      GB:United Kingdom
      GD:Grenada
      GE:Georgia
      GF:French Guiana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Greenland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Equatorial Guinea
      GR:Greece
      GS:South Georgia & South Sandwich Islands
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hong Kong SAR China
      HM:Agwaetiti Heard na Agwaetiti McDonald
      HN:Honduras
      HR:Croatia
      HT:Haiti
      HU:Hungary
      IC:Canary Islands
      ID:Indonesia
      IE:Ireland
      IL:Israel
      IM:Isle of Man
      IN:India
      IO:British Indian Ocean Territory
      IQ:Iraq
      IR:Iran
      IS:Iceland
      IT:Italy
      JE:Jersey
      JM:Jamaika
      JO:Jordan
      JP:Japan
      KE:Kenya
      KG:Kyrgyzstan
      KH:Cambodia
      KI:Kiribati
      KM:Comoros
      KN:St. Kitts & Nevis
      KP:North Korea
      KR:South Korea
      KW:Kuwait
      KY:Cayman Islands
      KZ:Kazakhstan
      LA:Laos
      LB:Lebanon
      LC:St. Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lithuania
      LU:Luxembourg
      LV:Latvia
      LY:Libia
      MA:Morocco
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:St. Martin
      MG:Madagascar
      MH:Agwaetiti Marshall
      MK:North Macedonia
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Macao SAR China
      MP:Agwaetiti Northern Mariana
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldivesa
      MW:Malawi
      MX:Mexico
      MY:Malaysia
      MZ:Mozambique
      NA:Namibia
      NC:New Caledonia
      NE:Niger
      NF:Agwaetiti Norfolk
      NG:Naịjịrịa
      NI:Nicaragua
      NL:Netherlands
      NO:Norway
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:Oman
      PA:Panama
      PE:Peru
      PF:French Polynesia
      PG:Papua New Guinea
      PH:Philippines
      PK:Pakistan
      PL:Poland
      PM:St. Pierre & Miquelon
      PN:Agwaetiti Pitcairn
      PR:Puerto Rico
      PS:Mpaghara ndị Palestine
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Outlying Oceania
      RE:Réunion
      RO:Romania
      RS:Serbia
      RU:Russia
      RW:Rwanda
      SA:Saudi Arabia
      SB:Agwaetiti Solomon
      SC:Seychelles
      SD:Sudan
      SE:Sweden
      SG:Singapore
      SH:St. Helena
      SI:Slovenia
      SJ:Svalbard & Jan Mayen
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:South Sudan
      ST:São Tomé & Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks & Caicos Islands
      TD:Chad
      TF:Ụmụ ngalaba Frenchi Southern
      TG:Togo
      TH:Thailand
      TJ:Tajikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Türkiye
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraine
      UG:Uganda
      UM:Obere Agwaetiti Dị Na Mpụga U.S
      UN:Mba Ụwa Jikọrọ Ọnụ
      US:United States
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatican City
      VC:St. Vincent & Grenadines
      VE:Venezuela
      VG:British Virgin Islands
      VI:U.S. Virgin Islands
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis & Futuna
      WS:Samoa
      XA:Pseudo-Accents
      XB:Pseudo-Bidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:South Africa
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Mpaghara A na-amaghị
      """.trimIndent() }

  val ii: String by lazy { """
      001:ꋧꃅ
      002:ꃏꍏ
      003:ꀙꂰꍏ
      005:ꆆꂰꍏ
      009:ꄊꑸꍏ
      019:ꂰꍏ
      142:ꑸꍏ
      150:ꉩꍏ
      BE:ꀘꆹꏃ
      BR:ꀠꑭ
      CN:ꍏꇩ
      DE:ꄓꇩ
      FR:ꃔꇩ
      GB:ꑱꇩ
      IN:ꑴꄗ
      IT:ꑴꄊꆺ
      JP:ꏝꀪ
      MX:ꃀꑭꇬ
      RU:ꊉꇆꌦ
      US:ꂰꇩ
      ZZ:ꃅꄷꅉꀋꐚꌠ
      """.trimIndent() }

  val `is`: String by lazy { """
      001:Heimurinn
      002:Afríka
      003:Norður-Ameríka
      005:Suður-Ameríka
      009:Eyjaálfa
      011:Vestur-Afríka
      013:Mið-Ameríka
      014:Austur-Afríka
      015:Norður-Afríka
      017:Mið-Afríka
      018:Suðurhluti Afríku
      019:Ameríka
      021:Ameríka norðan Mexíkó
      029:Karíbahafið
      030:Austur-Asía
      034:Suður-Asía
      035:Suðaustur-Asía
      039:Suður-Evrópa
      053:Ástralasía
      054:Melanesía
      057:Míkrónesíusvæðið
      061:Pólýnesía
      142:Asía
      143:Mið-Asía
      145:Vestur-Asía
      150:Evrópa
      151:Austur-Evrópa
      154:Norður-Evrópa
      155:Vestur-Evrópa
      202:Afríka sunnan Sahara
      419:Rómanska Ameríka
      AC:Ascension-eyja
      AD:Andorra
      AE:Sameinuðu arabísku furstadæmin
      AF:Afganistan
      AG:Antígva og Barbúda
      AI:Angvilla
      AL:Albanía
      AM:Armenía
      AO:Angóla
      AQ:Suðurskautslandið
      AR:Argentína
      AS:Bandaríska Samóa
      AT:Austurríki
      AU:Ástralía
      AW:Arúba
      AX:Álandseyjar
      AZ:Aserbaídsjan
      BA:Bosnía og Hersegóvína
      BB:Barbados
      BD:Bangladess
      BE:Belgía
      BF:Búrkína Fasó
      BG:Búlgaría
      BH:Barein
      BI:Búrúndí
      BJ:Benín
      BL:Sankti Bartólómeusareyjar
      BM:Bermúdaeyjar
      BN:Brúnei
      BO:Bólivía
      BQ:Karíbahafshluti Hollands
      BR:Brasilía
      BS:Bahamaeyjar
      BT:Bútan
      BV:Bouveteyja
      BW:Botsvana
      BY:Hvíta-Rússland
      BZ:Belís
      CA:Kanada
      CC:Kókoseyjar (Keeling)
      CD:Kongó-Kinshasa
      CF:Mið-Afríkulýðveldið
      CG:Kongó-Brazzaville
      CH:Sviss
      CI:Fílabeinsströndin
      CK:Cooks-eyjar
      CL:Síle
      CM:Kamerún
      CN:Kína
      CO:Kólumbía
      CP:Clipperton-eyja
      CR:Kostaríka
      CU:Kúba
      CV:Grænhöfðaeyjar
      CW:Curacao
      CX:Jólaey
      CY:Kýpur
      CZ:Tékkland
      DE:Þýskaland
      DG:Diego Garcia
      DJ:Djíbútí
      DK:Danmörk
      DM:Dóminíka
      DO:Dóminíska lýðveldið
      DZ:Alsír
      EA:Ceuta og Melilla
      EC:Ekvador
      EE:Eistland
      EG:Egyptaland
      EH:Vestur-Sahara
      ER:Erítrea
      ES:Spánn
      ET:Eþíópía
      EU:Evrópusambandið
      EZ:Evrusvæðið
      FI:Finnland
      FJ:Fídjíeyjar
      FK:Falklandseyjar
      FM:Míkrónesía
      FO:Færeyjar
      FR:Frakkland
      GA:Gabon
      GB:Bretland
      GD:Grenada
      GE:Georgía
      GF:Franska Gvæjana
      GG:Guernsey
      GH:Gana
      GI:Gíbraltar
      GL:Grænland
      GM:Gambía
      GN:Gínea
      GP:Gvadelúpeyjar
      GQ:Miðbaugs-Gínea
      GR:Grikkland
      GS:Suður-Georgía og Suður-Sandvíkureyjar
      GT:Gvatemala
      GU:Gvam
      GW:Gínea-Bissá
      GY:Gvæjana
      HK:sérstjórnarsvæðið Hong Kong
      HM:Heard og McDonaldseyjar
      HN:Hondúras
      HR:Króatía
      HT:Haítí
      HU:Ungverjaland
      IC:Kanaríeyjar
      ID:Indónesía
      IE:Írland
      IL:Ísrael
      IM:Mön
      IN:Indland
      IO:Bresku Indlandshafseyjar
      IQ:Írak
      IR:Íran
      IS:Ísland
      IT:Ítalía
      JE:Jersey
      JM:Jamaíka
      JO:Jórdanía
      JP:Japan
      KE:Kenía
      KG:Kirgistan
      KH:Kambódía
      KI:Kíribatí
      KM:Kómoreyjar
      KN:Sankti Kitts og Nevis
      KP:Norður-Kórea
      KR:Suður-Kórea
      KW:Kúveit
      KY:Caymaneyjar
      KZ:Kasakstan
      LA:Laos
      LB:Líbanon
      LC:Sankti Lúsía
      LI:Liechtenstein
      LK:Srí Lanka
      LR:Líbería
      LS:Lesótó
      LT:Litháen
      LU:Lúxemborg
      LV:Lettland
      LY:Líbía
      MA:Marokkó
      MC:Mónakó
      MD:Moldóva
      ME:Svartfjallaland
      MF:Saint-Martin
      MG:Madagaskar
      MH:Marshalleyjar
      MK:Norður-Makedónía
      ML:Malí
      MM:Mjanmar (Búrma)
      MN:Mongólía
      MO:sérstjórnarsvæðið Makaó
      MP:Norður-Maríanaeyjar
      MQ:Martiník
      MR:Máritanía
      MS:Montserrat
      MT:Malta
      MU:Máritíus
      MV:Maldíveyjar
      MW:Malaví
      MX:Mexíkó
      MY:Malasía
      MZ:Mósambík
      NA:Namibía
      NC:Nýja-Kaledónía
      NE:Níger
      NF:Norfolkeyja
      NG:Nígería
      NI:Níkaragva
      NL:Holland
      NO:Noregur
      NP:Nepal
      NR:Nárú
      NU:Niue
      NZ:Nýja-Sjáland
      OM:Óman
      PA:Panama
      PE:Perú
      PF:Franska Pólýnesía
      PG:Papúa Nýja-Gínea
      PH:Filippseyjar
      PK:Pakistan
      PL:Pólland
      PM:Sankti Pierre og Miquelon
      PN:Pitcairn-eyjar
      PR:Púertó Ríkó
      PS:Heimastjórnarsvæði Palestínumanna
      PT:Portúgal
      PW:Palá
      PY:Paragvæ
      QA:Katar
      QO:Ytri Eyjaálfa
      RE:Réunion
      RO:Rúmenía
      RS:Serbía
      RU:Rússland
      RW:Rúanda
      SA:Sádi-Arabía
      SB:Salómonseyjar
      SC:Seychelles-eyjar
      SD:Súdan
      SE:Svíþjóð
      SG:Singapúr
      SH:Sankti Helena
      SI:Slóvenía
      SJ:Svalbarði og Jan Mayen
      SK:Slóvakía
      SL:Síerra Leóne
      SM:San Marínó
      SN:Senegal
      SO:Sómalía
      SR:Súrínam
      SS:Suður-Súdan
      ST:Saó Tóme og Prinsípe
      SV:El Salvador
      SX:Sint Maarten
      SY:Sýrland
      SZ:Esvatíní
      TA:Tristan da Cunha
      TC:Turks- og Caicoseyjar
      TD:Tsjad
      TF:Frönsku suðlægu landsvæðin
      TG:Tógó
      TH:Taíland
      TJ:Tadsíkistan
      TK:Tókelá
      TL:Tímor-Leste
      TM:Túrkmenistan
      TN:Túnis
      TO:Tonga
      TR:Tyrkland
      TT:Trínidad og Tóbagó
      TV:Túvalú
      TW:Taívan
      TZ:Tansanía
      UA:Úkraína
      UG:Úganda
      UM:Smáeyjar Bandaríkjanna
      UN:Sameinuðu þjóðirnar
      US:Bandaríkin
      UY:Úrúgvæ
      UZ:Úsbekistan
      VA:Vatíkanið
      VC:Sankti Vinsent og Grenadíneyjar
      VE:Venesúela
      VG:Bresku Jómfrúaeyjar
      VI:Bandarísku Jómfrúaeyjar
      VN:Víetnam
      VU:Vanúatú
      WF:Wallis- og Fútúnaeyjar
      WS:Samóa
      XA:gervihreimur
      XB:gervistaður
      XK:Kósóvó
      YE:Jemen
      YT:Mayotte
      ZA:Suður-Afríka
      ZM:Sambía
      ZW:Simbabve
      ZZ:Óþekkt svæði
      """.trimIndent() }

  val it: String by lazy { """
      001:Mondo
      002:Africa
      003:Nord America
      005:America del Sud
      009:Oceania
      011:Africa occidentale
      013:America Centrale
      014:Africa orientale
      015:Nordafrica
      017:Africa centrale
      018:Africa del Sud
      019:Americhe
      021:America del Nord
      029:Caraibi
      030:Asia orientale
      034:Asia del Sud
      035:Sud-est asiatico
      039:Europa meridionale
      053:Australasia
      054:Melanesia
      057:Regione micronesiana
      061:Polinesia
      142:Asia
      143:Asia centrale
      145:Asia occidentale
      150:Europa
      151:Europa orientale
      154:Europa settentrionale
      155:Europa occidentale
      202:Africa subsahariana
      419:America Latina
      AC:Isola Ascensione
      AD:Andorra
      AE:Emirati Arabi Uniti
      AF:Afghanistan
      AG:Antigua e Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antartide
      AR:Argentina
      AS:Samoa Americane
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Isole Åland
      AZ:Azerbaigian
      BA:Bosnia ed Erzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgio
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Saint-Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Caraibi Olandesi
      BR:Brasile
      BS:Bahamas
      BT:Bhutan
      BV:Isola Bouvet
      BW:Botswana
      BY:Bielorussia
      BZ:Belize
      CA:Canada
      CC:Isole Cocos (Keeling)
      CD:Congo - Kinshasa
      CF:Repubblica Centrafricana
      CG:Congo-Brazzaville
      CH:Svizzera
      CI:Costa d’Avorio
      CK:Isole Cook
      CL:Cile
      CM:Camerun
      CN:Cina
      CO:Colombia
      CP:Isola di Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Capo Verde
      CW:Curaçao
      CX:Isola Christmas
      CY:Cipro
      CZ:Cechia
      DE:Germania
      DG:Diego Garcia
      DJ:Gibuti
      DK:Danimarca
      DM:Dominica
      DO:Repubblica Dominicana
      DZ:Algeria
      EA:Ceuta e Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egitto
      EH:Sahara Occidentale
      ER:Eritrea
      ES:Spagna
      ET:Etiopia
      EU:Unione europea
      EZ:Eurozona
      FI:Finlandia
      FJ:Figi
      FK:Isole Falkland
      FM:Micronesia
      FO:Isole Fær Øer
      FR:Francia
      GA:Gabon
      GB:Regno Unito
      GD:Grenada
      GE:Georgia
      GF:Guyana Francese
      GG:Guernsey
      GH:Ghana
      GI:Gibilterra
      GL:Groenlandia
      GM:Gambia
      GN:Guinea
      GP:Guadalupa
      GQ:Guinea Equatoriale
      GR:Grecia
      GS:Georgia del Sud e Sandwich Australi
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:RAS di Hong Kong
      HM:Isole Heard e McDonald
      HN:Honduras
      HR:Croazia
      HT:Haiti
      HU:Ungheria
      IC:Isole Canarie
      ID:Indonesia
      IE:Irlanda
      IL:Israele
      IM:Isola di Man
      IN:India
      IO:Territorio Britannico dell’Oceano Indiano
      IQ:Iraq
      IR:Iran
      IS:Islanda
      IT:Italia
      JE:Jersey
      JM:Giamaica
      JO:Giordania
      JP:Giappone
      KE:Kenya
      KG:Kirghizistan
      KH:Cambogia
      KI:Kiribati
      KM:Comore
      KN:Saint Kitts e Nevis
      KP:Corea del Nord
      KR:Corea del Sud
      KW:Kuwait
      KY:Isole Cayman
      KZ:Kazakistan
      LA:Laos
      LB:Libano
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lituania
      LU:Lussemburgo
      LV:Lettonia
      LY:Libia
      MA:Marocco
      MC:Monaco
      MD:Moldavia
      ME:Montenegro
      MF:Saint Martin
      MG:Madagascar
      MH:Isole Marshall
      MK:Macedonia del Nord
      ML:Mali
      MM:Myanmar (Birmania)
      MN:Mongolia
      MO:RAS di Macao
      MP:Isole Marianne Settentrionali
      MQ:Martinica
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldive
      MW:Malawi
      MX:Messico
      MY:Malaysia
      MZ:Mozambico
      NA:Namibia
      NC:Nuova Caledonia
      NE:Niger
      NF:Isola Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Paesi Bassi
      NO:Norvegia
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nuova Zelanda
      OM:Oman
      PA:Panama
      PE:Perù
      PF:Polinesia Francese
      PG:Papua Nuova Guinea
      PH:Filippine
      PK:Pakistan
      PL:Polonia
      PM:Saint-Pierre e Miquelon
      PN:Isole Pitcairn
      PR:Portorico
      PS:Territori Palestinesi
      PT:Portogallo
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Oceania lontana
      RE:Riunione
      RO:Romania
      RS:Serbia
      RU:Russia
      RW:Ruanda
      SA:Arabia Saudita
      SB:Isole Salomone
      SC:Seychelles
      SD:Sudan
      SE:Svezia
      SG:Singapore
      SH:Sant’Elena
      SI:Slovenia
      SJ:Svalbard e Jan Mayen
      SK:Slovacchia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:Sud Sudan
      ST:São Tomé e Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Siria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Isole Turks e Caicos
      TD:Ciad
      TF:Terre Australi Francesi
      TG:Togo
      TH:Thailandia
      TJ:Tagikistan
      TK:Tokelau
      TL:Timor Est
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turchia
      TT:Trinidad e Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ucraina
      UG:Uganda
      UM:Isole Minori Esterne degli Stati Uniti
      UN:Nazioni Unite
      US:Stati Uniti
      UY:Uruguay
      UZ:Uzbekistan
      VA:Città del Vaticano
      VC:Saint Vincent e Grenadine
      VE:Venezuela
      VG:Isole Vergini Britanniche
      VI:Isole Vergini Americane
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis e Futuna
      WS:Samoa
      XA:Pseudo-accenti
      XB:Pseudo-bidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:Sudafrica
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Regione sconosciuta
      """.trimIndent() }

  val it_CH: String? = null

  val it_SM: String? = null

  val it_VA: String? = null

  val ja: String by lazy { """
      001:世界
      002:アフリカ
      003:北アメリカ大陸
      005:南アメリカ
      009:オセアニア
      011:西アフリカ
      013:中央アメリカ
      014:東アフリカ
      015:北アフリカ
      017:中部アフリカ
      018:南部アフリカ
      019:アメリカ大陸
      021:北アメリカ
      029:カリブ
      030:東アジア
      034:南アジア
      035:東南アジア
      039:南ヨーロッパ
      053:オーストララシア
      054:メラネシア
      057:ミクロネシア
      061:ポリネシア
      142:アジア
      143:中央アジア
      145:西アジア
      150:ヨーロッパ
      151:東ヨーロッパ
      154:北ヨーロッパ
      155:西ヨーロッパ
      202:サブサハラアフリカ
      419:ラテンアメリカ
      AC:アセンション島
      AD:アンドラ
      AE:アラブ首長国連邦
      AF:アフガニスタン
      AG:アンティグア・バーブーダ
      AI:アンギラ
      AL:アルバニア
      AM:アルメニア
      AO:アンゴラ
      AQ:南極
      AR:アルゼンチン
      AS:米領サモア
      AT:オーストリア
      AU:オーストラリア
      AW:アルバ
      AX:オーランド諸島
      AZ:アゼルバイジャン
      BA:ボスニア・ヘルツェゴビナ
      BB:バルバドス
      BD:バングラデシュ
      BE:ベルギー
      BF:ブルキナファソ
      BG:ブルガリア
      BH:バーレーン
      BI:ブルンジ
      BJ:ベナン
      BL:サン・バルテルミー
      BM:バミューダ
      BN:ブルネイ
      BO:ボリビア
      BQ:オランダ領カリブ
      BR:ブラジル
      BS:バハマ
      BT:ブータン
      BV:ブーベ島
      BW:ボツワナ
      BY:ベラルーシ
      BZ:ベリーズ
      CA:カナダ
      CC:ココス(キーリング)諸島
      CD:コンゴ民主共和国(キンシャサ)
      CF:中央アフリカ共和国
      CG:コンゴ共和国(ブラザビル)
      CH:スイス
      CI:コートジボワール
      CK:クック諸島
      CL:チリ
      CM:カメルーン
      CN:中国
      CO:コロンビア
      CP:クリッパートン島
      CR:コスタリカ
      CU:キューバ
      CV:カーボベルデ
      CW:キュラソー
      CX:クリスマス島
      CY:キプロス
      CZ:チェコ
      DE:ドイツ
      DG:ディエゴガルシア島
      DJ:ジブチ
      DK:デンマーク
      DM:ドミニカ国
      DO:ドミニカ共和国
      DZ:アルジェリア
      EA:セウタ・メリリャ
      EC:エクアドル
      EE:エストニア
      EG:エジプト
      EH:西サハラ
      ER:エリトリア
      ES:スペイン
      ET:エチオピア
      EU:欧州連合
      EZ:ユーロ圏
      FI:フィンランド
      FJ:フィジー
      FK:フォークランド諸島
      FM:ミクロネシア連邦
      FO:フェロー諸島
      FR:フランス
      GA:ガボン
      GB:イギリス
      GD:グレナダ
      GE:ジョージア
      GF:仏領ギアナ
      GG:ガーンジー
      GH:ガーナ
      GI:ジブラルタル
      GL:グリーンランド
      GM:ガンビア
      GN:ギニア
      GP:グアドループ
      GQ:赤道ギニア
      GR:ギリシャ
      GS:サウスジョージア・サウスサンドウィッチ諸島
      GT:グアテマラ
      GU:グアム
      GW:ギニアビサウ
      GY:ガイアナ
      HK:中華人民共和国香港特別行政区
      HM:ハード島・マクドナルド諸島
      HN:ホンジュラス
      HR:クロアチア
      HT:ハイチ
      HU:ハンガリー
      IC:カナリア諸島
      ID:インドネシア
      IE:アイルランド
      IL:イスラエル
      IM:マン島
      IN:インド
      IO:英領インド洋地域
      IQ:イラク
      IR:イラン
      IS:アイスランド
      IT:イタリア
      JE:ジャージー
      JM:ジャマイカ
      JO:ヨルダン
      JP:日本
      KE:ケニア
      KG:キルギス
      KH:カンボジア
      KI:キリバス
      KM:コモロ
      KN:セントクリストファー・ネーヴィス
      KP:北朝鮮
      KR:韓国
      KW:クウェート
      KY:ケイマン諸島
      KZ:カザフスタン
      LA:ラオス
      LB:レバノン
      LC:セントルシア
      LI:リヒテンシュタイン
      LK:スリランカ
      LR:リベリア
      LS:レソト
      LT:リトアニア
      LU:ルクセンブルク
      LV:ラトビア
      LY:リビア
      MA:モロッコ
      MC:モナコ
      MD:モルドバ
      ME:モンテネグロ
      MF:サン・マルタン
      MG:マダガスカル
      MH:マーシャル諸島
      MK:北マケドニア
      ML:マリ
      MM:ミャンマー (ビルマ)
      MN:モンゴル
      MO:中華人民共和国マカオ特別行政区
      MP:北マリアナ諸島
      MQ:マルティニーク
      MR:モーリタニア
      MS:モントセラト
      MT:マルタ
      MU:モーリシャス
      MV:モルディブ
      MW:マラウイ
      MX:メキシコ
      MY:マレーシア
      MZ:モザンビーク
      NA:ナミビア
      NC:ニューカレドニア
      NE:ニジェール
      NF:ノーフォーク島
      NG:ナイジェリア
      NI:ニカラグア
      NL:オランダ
      NO:ノルウェー
      NP:ネパール
      NR:ナウル
      NU:ニウエ
      NZ:ニュージーランド
      OM:オマーン
      PA:パナマ
      PE:ペルー
      PF:仏領ポリネシア
      PG:パプアニューギニア
      PH:フィリピン
      PK:パキスタン
      PL:ポーランド
      PM:サンピエール島・ミクロン島
      PN:ピトケアン諸島
      PR:プエルトリコ
      PS:パレスチナ自治区
      PT:ポルトガル
      PW:パラオ
      PY:パラグアイ
      QA:カタール
      QO:オセアニア周辺地域
      RE:レユニオン
      RO:ルーマニア
      RS:セルビア
      RU:ロシア
      RW:ルワンダ
      SA:サウジアラビア
      SB:ソロモン諸島
      SC:セーシェル
      SD:スーダン
      SE:スウェーデン
      SG:シンガポール
      SH:セントヘレナ
      SI:スロベニア
      SJ:スバールバル諸島・ヤンマイエン島
      SK:スロバキア
      SL:シエラレオネ
      SM:サンマリノ
      SN:セネガル
      SO:ソマリア
      SR:スリナム
      SS:南スーダン
      ST:サントメ・プリンシペ
      SV:エルサルバドル
      SX:シント・マールテン
      SY:シリア
      SZ:エスワティニ
      TA:トリスタン・ダ・クーニャ
      TC:タークス・カイコス諸島
      TD:チャド
      TF:仏領極南諸島
      TG:トーゴ
      TH:タイ
      TJ:タジキスタン
      TK:トケラウ
      TL:東ティモール
      TM:トルクメニスタン
      TN:チュニジア
      TO:トンガ
      TR:トルコ
      TT:トリニダード・トバゴ
      TV:ツバル
      TW:台湾
      TZ:タンザニア
      UA:ウクライナ
      UG:ウガンダ
      UM:合衆国領有小離島
      UN:国際連合
      US:アメリカ合衆国
      UY:ウルグアイ
      UZ:ウズベキスタン
      VA:バチカン市国
      VC:セントビンセント及びグレナディーン諸島
      VE:ベネズエラ
      VG:英領ヴァージン諸島
      VI:米領ヴァージン諸島
      VN:ベトナム
      VU:バヌアツ
      WF:ウォリス・フツナ
      WS:サモア
      XA:疑似アクセント
      XB:疑似 BIDI
      XK:コソボ
      YE:イエメン
      YT:マヨット
      ZA:南アフリカ
      ZM:ザンビア
      ZW:ジンバブエ
      ZZ:不明な地域
      """.trimIndent() }

  val jgo: String by lazy { """
      001:Mbí
      002:Afɛlîk
      019:Amɛlîk
      142:Azî
      150:Ʉlôp
      AO:Aŋgɔ́la
      AR:Ajɛntîn
      BF:Mbulukína Fásɔ
      BI:Mbulundí
      BJ:Mbɛnɛ̂ŋ
      BO:Mbɔlivî
      BR:Mbɛlazîl
      BW:Mbɔtswána
      CA:Kanadâ
      CD:Kɔ́ŋgɔ-Kinshása
      CG:Kɔ́ŋgɔ-Mbɛlazavîl
      CH:Sẅísɛ
      CI:Kɔ́t Ndivwâ
      CL:Cíllɛ
      CM:Kamɛlûn
      CN:Shîn
      CO:Kɔllɔmbî
      CU:Kúba
      DE:Njáman
      DJ:Njimbúti
      DZ:Aljɛlî
      EC:Ɛkwandɔ̂
      EG:Ɛjíptɛ
      ER:Ɛlitɛlɛ́ya
      ES:Ɛspániya
      ET:Ɛtiyɔpî
      FR:Fɛlánci
      GA:Ŋgabɔ̂ŋ
      GH:Ŋgána
      GM:Ŋgambî
      GN:Ŋginɛ̂
      GQ:Ŋginɛ̂ Ɛkwatɔliyâl
      GR:Ŋgɛlɛ̂k
      GW:Ŋginɛ̂ Mbisáwu
      IL:Islayɛ̂l
      IN:Ándɛ
      IQ:Ilâk
      IT:Italî
      JP:Japɔ̂n
      KE:Kɛ́nya
      KM:Kɔmɔ́lɔshi
      LR:Libɛrî
      LS:Lɛsɔ́tɔ
      LY:Libî
      MA:Mɔlɔ̂k
      MG:Mándaŋgasɛkâ
      ML:Malî
      MR:Mɔlitanî
      MW:Maláwi
      MX:Mɛksîk
      MZ:Mɔzambîk
      NA:Namimbî
      NE:Nijɛ̂
      NG:Ninjɛliyâ
      NO:Nɔlɛvɛ́jɛ
      PE:Pɛlû
      RE:Lɛ́uniyɔ̂n
      RS:Sɛlɛbî
      RU:Lusî
      RW:Luwánda
      SC:Pɛsɛ́shɛl
      SD:Sundân
      SL:Siyɛ́la Lɛɔ̂n
      SN:Sɛnɛgâl
      SO:Sɔmalî
      ST:Sáwɔŋ Tɔmɛ́ nɛ́ Pɛlínsipɛ
      SZ:Swazilân
      TD:Cât
      TG:Tɔ́ŋgɔ
      TN:Tunizî
      TZ:Tanzanî
      UG:Uŋgánda
      VE:Vɛnɛzwɛ́la
      YT:Mayɔ̂t
      ZM:Zambî
      ZW:Zimbámbwɛ
      ZZ:ŋgɔŋ yi pɛ́ ká kɛ́ jʉɔ
      """.trimIndent() }

  val jmc: String by lazy { """
      AD:Andora
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Marekani
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misri
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Ufaransa
      GA:Gaboni
      GB:Uingereza
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Rwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukraini
      UG:Uganda
      US:Marekani
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val jv: String by lazy { """
      001:Donya
      002:Afrika
      003:Amérika Lor
      005:Amérika Kidul
      009:Oséania
      011:Afrika Kulon
      013:Amérika Tengah
      014:Afrika Wétan
      015:Afrika Lor
      017:Afrika Sisih Tengah
      018:Afrika Sisih Kidul
      019:Amérika
      021:Amérika Sisih Lor
      029:Karibia
      030:Asia Wétan
      034:Asia Kidul
      035:Asia Kidul-wétan
      039:Éropah Kidul
      053:Australasia
      054:Melanesia
      057:Daerah Mikronesia
      061:Polinesia
      142:Asia
      143:Asia Tengah
      145:Asia Kulon
      150:Éropah
      151:Éropah Wétan
      154:Éropah Lor
      155:Éropah Kulon
      202:Afrika Kidule Sahara
      419:Amérika Latin
      AC:Pulo Ascension
      AD:Andora
      AE:Uni Émirat Arab
      AF:Afganistan
      AG:Antigua lan Barbuda
      AI:Anguilla
      AL:Albani
      AM:Arménia
      AO:Angola
      AQ:Antartika
      AR:Argèntina
      AS:Samoa Amerika
      AT:Ostenrik
      AU:Ostrali
      AW:Aruba
      AX:Kapuloan Alan
      AZ:Azerbaijan
      BA:Bosnia lan Hèrségovina
      BB:Barbadhos
      BD:Banggaladésa
      BE:Bèlgi
      BF:Burkina Faso
      BG:Bulgari
      BH:Bahrain
      BI:Burundi
      BJ:Bénin
      BL:Saint Barthélémi
      BM:Bermuda
      BN:Brunéi
      BO:Bolivia
      BQ:Karibia Walanda
      BR:Brasil
      BS:Bahama
      BT:Bhutan
      BV:Pulo Bovèt
      BW:Botswana
      BY:Bélarus
      BZ:Bélisé
      CA:Kanada
      CC:Kapuloan Cocos (Keeling)
      CD:Kongo - Kinshasa
      CF:Républik Afrika Tengah
      CG:Kongo - Brassaville
      CH:Switserlan
      CI:Pasisir Gadhing
      CK:Kapuloan Cook
      CL:Cilé
      CM:Kamerun
      CN:Tyongkok
      CO:Kolombia
      CP:Pulo Clipperton
      CR:Kosta Rika
      CU:Kuba
      CV:Pongol Verdé
      CW:Kurasao
      CX:Pulo Natal
      CY:Siprus
      CZ:Céko
      DE:Jérman
      DG:Diego Garcia
      DJ:Jibuti
      DK:Dhènemarken
      DM:Dominika
      DO:Républik Dominika
      DZ:Aljasair
      EA:Séuta lan Melila
      EC:Ékuadhor
      EE:Éstonia
      EG:Mesir
      EH:Sahara Kulon
      ER:Éritréa
      ES:Sepanyol
      ET:Étiopia
      EU:Uni Éropah
      EZ:Zona Éuro
      FI:Finlan
      FJ:Fiji
      FK:Kapuloan Falkland
      FM:Féderasi Mikronésia
      FO:Kapuloan Faro
      FR:Prancis
      GA:Gabon
      GB:Karajan Manunggal
      GD:Grénada
      GE:Géorgia
      GF:Guyana Prancis
      GG:Guernsei
      GH:Ghana
      GI:Gibraltar
      GL:Greenland
      GM:Gambia
      GN:Guinea
      GP:Guadélup
      GQ:Guinéa Katulistiwa
      GR:Grikenlan
      GS:Georgia Kidul lan Kapuloan Sandwich Kidul
      GT:Guatémala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Laladan Administratif Astamiwa Hong Kong
      HM:Kapuloan Heard lan McDonald
      HN:Honduras
      HR:Kroasia
      HT:Haiti
      HU:Honggari
      IC:Kapuloan Kanari
      ID:Indonésia
      IE:Républik Irlan
      IL:Israèl
      IM:Pulo Man
      IN:Indhia
      IO:Wilayah Inggris ing Segara Hindia
      IQ:Irak
      IR:Iran
      IS:Èslan
      IT:Itali
      JE:Jersey
      JM:Jamaika
      JO:Yordania
      JP:Jepang
      KE:Kénya
      KG:Kirgistan
      KH:Kamboja
      KI:Kiribati
      KM:Komoro
      KN:Saint Kits lan Nèvis
      KP:Korea Lor
      KR:Koréa Kidul
      KW:Kuwait
      KY:Kapuloan Kéman
      KZ:Kasakstan
      LA:Laos
      LB:Libanon
      LC:Santa Lusia
      LI:Liktenstén
      LK:Sri Lanka
      LR:Libèria
      LS:Lésotho
      LT:Litowen
      LU:Luksemburg
      LV:Latvia
      LY:Libya
      MA:Maroko
      MC:Monako
      MD:Moldova
      ME:Montenégro
      MF:Santa Martin
      MG:Madagaskar
      MH:Kapuloan Marshall
      MK:Républik Makédonia Lor
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Laladan Administratif Astamiwa Makau
      MP:Kapuloan Mariana Lor
      MQ:Martinik
      MR:Mauritania
      MS:Monsérat
      MT:Malta
      MU:Mauritius
      MV:Maladéwa
      MW:Malawi
      MX:Mèksiko
      MY:Malaysia
      MZ:Mosambik
      NA:Namibia
      NC:Kalédonia Anyar
      NE:Nigér
      NF:Pulo Norfolk
      NG:Nigéria
      NI:Nikaragua
      NL:Walanda
      NO:Nurwègen
      NP:Népal
      NR:Nauru
      NU:Niue
      NZ:Selandia Anyar
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Polinesia Prancis
      PG:Papua Nugini
      PH:Pilipina
      PK:Pakistan
      PL:Polen
      PM:Saint Pièr lan Mikuélon
      PN:Kapuloan Pitcairn
      PR:Puèrto Riko
      PS:Tlatah Palèstina
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Katar
      QO:Oseania Paling Njaba
      RE:Réunion
      RO:Ruméni
      RS:Sèrbi
      RU:Rusia
      RW:Rwanda
      SA:Arab Saudi
      SB:Kapuloan Suleman
      SC:Sésèl
      SD:Sudan
      SE:Swèdhen
      SG:Singapura
      SH:Saint Héléna
      SI:Slovénia
      SJ:Svalbard lan Jan Mayen
      SK:Slowak
      SL:Siéra Léoné
      SM:San Marino
      SN:Sénégal
      SO:Somalia
      SR:Suriname
      SS:Sudan Kidul
      ST:Sao Tomé lan Principé
      SV:Èl Salvador
      SX:Sint Martén
      SY:Suriah
      SZ:Swasiland
      TA:Tristan da Cunha
      TC:Turks lan Kapuloan Kaikos
      TD:Chad
      TF:Wilayah Prancis nang Kutub Kidul
      TG:Togo
      TH:Tanah Thai
      TJ:Tajikistan
      TK:Tokelau
      TL:Timor Leste
      TM:Turkménistan
      TN:Tunisia
      TO:Tonga
      TR:Turki
      TT:Trinidad lan Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansania
      UA:Ukrania
      UG:Uganda
      UM:Kapuloan AS Paling Njaba
      UN:Pasarékatan Bangsa-Bangsa
      US:Amérika Sarékat
      UY:Uruguay
      UZ:Usbèkistan
      VA:Kutha Vatikan
      VC:Saint Vinsen lan Grénadin
      VE:Vénésuéla
      VG:Kapuloan Virgin Britania
      VI:Kapuloan Virgin Amérika
      VN:Viètnam
      VU:Vanuatu
      WF:Wallis lan Futuna
      WS:Samoa
      XA:Logat Semu
      XB:Rong Arah Semu
      XK:Kosovo
      YE:Yaman
      YT:Mayotte
      ZA:Afrika Kidul
      ZM:Sambia
      ZW:Simbabwe
      ZZ:Daerah Ora Dikenali
      """.trimIndent() }

  val ka: String by lazy { """
      001:მსოფლიო
      002:აფრიკა
      003:ჩრდილოეთ ამერიკა
      005:სამხრეთ ამერიკა
      009:ოკეანეთი
      011:დასავლეთ აფრიკა
      013:ცენტრალური ამერიკა
      014:აღმოსავლეთ აფრიკა
      015:ჩრდილოეთ აფრიკა
      017:შუა აფრიკა
      018:სამხრეთ აფრიკა
      019:ამერიკები
      021:ამერიკის ჩრდილოეთი
      029:კარიბის ზღვა
      030:აღმოსავლეთ აზია
      034:სამხრეთ აზია
      035:სამხრეთ-აღმოსავლეთ აზია
      039:სამხრეთ ევროპა
      053:ავსტრალაზია
      054:მელანეზია
      057:მიკრონეზიის რეგიონი
      061:პოლინეზია
      142:აზია
      143:ცენტრალური აზია
      145:დასავლეთ აზია
      150:ევროპა
      151:აღმოსავლეთ ევროპა
      154:ჩრდილოეთ ევროპა
      155:დასავლეთ ევროპა
      202:სუბსაჰარული აფრიკა
      419:ლათინური ამერიკა
      AC:ამაღლების კუნძული
      AD:ანდორა
      AE:არაბთა გაერთიანებული საამიროები
      AF:ავღანეთი
      AG:ანტიგუა და ბარბუდა
      AI:ანგილია
      AL:ალბანეთი
      AM:სომხეთი
      AO:ანგოლა
      AQ:ანტარქტიკა
      AR:არგენტინა
      AS:ამერიკის სამოა
      AT:ავსტრია
      AU:ავსტრალია
      AW:არუბა
      AX:ალანდის კუნძულები
      AZ:აზერბაიჯანი
      BA:ბოსნია და ჰერცეგოვინა
      BB:ბარბადოსი
      BD:ბანგლადეში
      BE:ბელგია
      BF:ბურკინა-ფასო
      BG:ბულგარეთი
      BH:ბაჰრეინი
      BI:ბურუნდი
      BJ:ბენინი
      BL:სენ-ბართელმი
      BM:ბერმუდა
      BN:ბრუნეი
      BO:ბოლივია
      BQ:კარიბის ნიდერლანდები
      BR:ბრაზილია
      BS:ბაჰამის კუნძულები
      BT:ბუტანი
      BV:ბუვე
      BW:ბოტსვანა
      BY:ბელარუსი
      BZ:ბელიზი
      CA:კანადა
      CC:ქოქოსის (კილინგის) კუნძულები
      CD:კონგო - კინშასა
      CF:ცენტრალური აფრიკის რესპუბლიკა
      CG:კონგო - ბრაზავილი
      CH:შვეიცარია
      CI:კოტ-დივუარი
      CK:კუკის კუნძულები
      CL:ჩილე
      CM:კამერუნი
      CN:ჩინეთი
      CO:კოლუმბია
      CP:კლიპერტონის კუნძული
      CR:კოსტა-რიკა
      CU:კუბა
      CV:კაბო-ვერდე
      CW:კიურასაო
      CX:შობის კუნძული
      CY:კვიპროსი
      CZ:ჩეხეთი
      DE:გერმანია
      DG:დიეგო-გარსია
      DJ:ჯიბუტი
      DK:დანია
      DM:დომინიკა
      DO:დომინიკელთა რესპუბლიკა
      DZ:ალჟირი
      EA:სეუტა და მელილა
      EC:ეკვადორი
      EE:ესტონეთი
      EG:ეგვიპტე
      EH:დასავლეთ საჰარა
      ER:ერიტრეა
      ES:ესპანეთი
      ET:ეთიოპია
      EU:ევროკავშირი
      EZ:ევროზონა
      FI:ფინეთი
      FJ:ფიჯი
      FK:ფოლკლენდის კუნძულები
      FM:მიკრონეზია
      FO:ფარერის კუნძულები
      FR:საფრანგეთი
      GA:გაბონი
      GB:გაერთიანებული სამეფო
      GD:გრენადა
      GE:საქართველო
      GF:საფრანგეთის გვიანა
      GG:გერნსი
      GH:განა
      GI:გიბრალტარი
      GL:გრენლანდია
      GM:გამბია
      GN:გვინეა
      GP:გვადელუპა
      GQ:ეკვატორული გვინეა
      GR:საბერძნეთი
      GS:სამხრეთ ჯორჯია და სამხრეთ სენდვიჩის კუნძულები
      GT:გვატემალა
      GU:გუამი
      GW:გვინეა-ბისაუ
      GY:გაიანა
      HK:ჰონკონგის სპეციალური ადმინისტრაციული რეგიონი, ჩინეთი
      HM:ჰერდი და მაკდონალდის კუნძულები
      HN:ჰონდურასი
      HR:ხორვატია
      HT:ჰაიტი
      HU:უნგრეთი
      IC:კანარის კუნძულები
      ID:ინდონეზია
      IE:ირლანდია
      IL:ისრაელი
      IM:მენის კუნძული
      IN:ინდოეთი
      IO:ბრიტანეთის ტერიტორია ინდოეთის ოკეანეში
      IQ:ერაყი
      IR:ირანი
      IS:ისლანდია
      IT:იტალია
      JE:ჯერსი
      JM:იამაიკა
      JO:იორდანია
      JP:იაპონია
      KE:კენია
      KG:ყირგიზეთი
      KH:კამბოჯა
      KI:კირიბატი
      KM:კომორის კუნძულები
      KN:სენტ-კიტსი და ნევისი
      KP:ჩრდილოეთ კორეა
      KR:სამხრეთ კორეა
      KW:ქუვეითი
      KY:კაიმანის კუნძულები
      KZ:ყაზახეთი
      LA:ლაოსი
      LB:ლიბანი
      LC:სენტ-ლუსია
      LI:ლიხტენშტაინი
      LK:შრი-ლანკა
      LR:ლიბერია
      LS:ლესოთო
      LT:ლიეტუვა
      LU:ლუქსემბურგი
      LV:ლატვია
      LY:ლიბია
      MA:მაროკო
      MC:მონაკო
      MD:მოლდოვა
      ME:მონტენეგრო
      MF:სენ-მარტენი
      MG:მადაგასკარი
      MH:მარშალის კუნძულები
      MK:ჩრდილოეთ მაკედონია
      ML:მალი
      MM:მიანმარი (ბირმა)
      MN:მონღოლეთი
      MO:მაკაოს სპეციალური ადმინისტრაციული რეგიონი, ჩინეთი
      MP:ჩრდილოეთ მარიანას კუნძულები
      MQ:მარტინიკა
      MR:მავრიტანია
      MS:მონსერატი
      MT:მალტა
      MU:მავრიკი
      MV:მალდივები
      MW:მალავი
      MX:მექსიკა
      MY:მალაიზია
      MZ:მოზამბიკი
      NA:ნამიბია
      NC:ახალი კალედონია
      NE:ნიგერი
      NF:ნორფოლკის კუნძული
      NG:ნიგერია
      NI:ნიკარაგუა
      NL:ნიდერლანდები
      NO:ნორვეგია
      NP:ნეპალი
      NR:ნაურუ
      NU:ნიუე
      NZ:ახალი ზელანდია
      OM:ომანი
      PA:პანამა
      PE:პერუ
      PF:საფრანგეთის პოლინეზია
      PG:პაპუა-ახალი გვინეა
      PH:ფილიპინები
      PK:პაკისტანი
      PL:პოლონეთი
      PM:სენ-პიერი და მიკელონი
      PN:პიტკერნის კუნძულები
      PR:პუერტო-რიკო
      PS:პალესტინის ტერიტორიები
      PT:პორტუგალია
      PW:პალაუ
      PY:პარაგვაი
      QA:კატარი
      QO:შორეული ოკეანეთი
      RE:რეუნიონი
      RO:რუმინეთი
      RS:სერბეთი
      RU:რუსეთი
      RW:რუანდა
      SA:საუდის არაბეთი
      SB:სოლომონის კუნძულები
      SC:სეიშელის კუნძულები
      SD:სუდანი
      SE:შვედეთი
      SG:სინგაპური
      SH:წმინდა ელენეს კუნძული
      SI:სლოვენია
      SJ:შპიცბერგენი და იან-მაიენი
      SK:სლოვაკეთი
      SL:სიერა-ლეონე
      SM:სან-მარინო
      SN:სენეგალი
      SO:სომალი
      SR:სურინამი
      SS:სამხრეთ სუდანი
      ST:სან-ტომე და პრინსიპი
      SV:სალვადორი
      SX:სინტ-მარტენი
      SY:სირია
      SZ:სვაზილენდი
      TA:ტრისტან-და-კუნია
      TC:თერქს-ქაიქოსის კუნძულები
      TD:ჩადი
      TF:ფრანგული სამხრეთის ტერიტორიები
      TG:ტოგო
      TH:ტაილანდი
      TJ:ტაჯიკეთი
      TK:ტოკელაუ
      TL:ტიმორ-ლესტე
      TM:თურქმენეთი
      TN:ტუნისი
      TO:ტონგა
      TR:თურქეთი
      TT:ტრინიდადი და ტობაგო
      TV:ტუვალუ
      TW:ტაივანი
      TZ:ტანზანია
      UA:უკრაინა
      UG:უგანდა
      UM:აშშ-ის შორეული კუნძულები
      UN:გაერო
      US:ამერიკის შეერთებული შტატები
      UY:ურუგვაი
      UZ:უზბეკეთი
      VA:ქალაქი ვატიკანი
      VC:სენტ-ვინსენტი და გრენადინები
      VE:ვენესუელა
      VG:ბრიტანეთის ვირჯინის კუნძულები
      VI:აშშ-ის ვირჯინის კუნძულები
      VN:ვიეტნამი
      VU:ვანუატუ
      WF:უოლისი და ფუტუნა
      WS:სამოა
      XA:ფსევდო-აქცენტები
      XB:ფსევდო-ორმიმართულებიანი
      XK:კოსოვო
      YE:იემენი
      YT:მაიოტა
      ZA:სამხრეთ აფრიკის რესპუბლიკა
      ZM:ზამბია
      ZW:ზიმბაბვე
      ZZ:უცნობი რეგიონი
      """.trimIndent() }

  val kaa: String by lazy { """
      001:дүнья
      002:Африка
      003:Арқа Америка
      005:Қубла Америка
      009:Океания
      011:Батыс Африка
      013:Орайлық Америка
      014:Шығыс Африка
      015:Арқа Африка
      017:Орайлық Африка
      018:Қубла Африка
      019:Америка
      021:Арқа Америка – AҚШ ҳәм Канада
      029:Кариб бассейни
      030:Шығыс Азия
      034:Қубла Азия
      035:Қубла-шығыс Азия
      039:Қубла Европа
      053:Австралазия
      054:Меланезия
      057:Микронезия
      061:Полинезия
      142:Азия
      143:Орайлық Азия
      145:Батыс Азия
      150:Европа
      151:Шығыс Европа
      154:Арқа Европа
      155:Батыс Европа
      202:Тропикалық Африка
      419:Латын Америкасы
      AD:Андорра
      AE:Бирлескен Араб Әмирликлери
      AF:Аўғанстан
      AG:Антигуа ҳәм Барбуда
      AI:Ангилья
      AL:Албания
      AM:Армения
      AO:Ангола
      AR:Аргентина
      AT:Австрия
      AU:Австралия
      AW:Аруба
      AX:Аланд атаўлары
      AZ:Әзербайжан
      BA:Босния ҳәм Герцеговина
      BB:Барбадос
      BD:Бангладеш
      BE:Бельгия
      BF:Буркина-Фасо
      BG:Болгария
      BH:Бахрейн
      BI:Бурунди
      BJ:Бенин
      BL:Сен-Бартелеми
      BM:Бермуд атаўлары
      BN:Бруней
      BO:Боливия
      BQ:Бонэйр, Синт-Эстатиус ҳәм Саба
      BR:Бразилия
      BS:Багама атаўлары
      BT:Бутан
      BV:Буве атаўы
      BW:Ботсвана
      BY:Беларусь
      BZ:Белиз
      CA:Канада
      CC:Кокос атаўлары
      CD:Конго - Киншаса
      CF:Орайлық Африка Республикасы
      CG:Конго - Браззавиль
      CH:Швейцария
      CI:Кот-дИвуар
      CK:Кук атаўлары
      CL:Чили
      CM:Камерун
      CN:Қытай
      CO:Колумбия
      CR:Коста-Рика
      CU:Куба
      CV:Кабо-Верде
      CW:Кюрасао
      CY:Кипр
      CZ:Чехия
      DE:Германия
      DJ:Джибути
      DK:Дания
      DM:Доминика
      DO:Доминикана Республикасы
      DZ:Алжир
      EA:Сеута ҳәм Мелилья
      EC:Эквадор
      EE:Эстония
      EG:Мысыр
      EH:Батыс Сахара
      ER:Эритрея
      ES:Испания
      ET:Эфиопия
      EU:Европа Аўқамы
      EZ:Еврозона
      FI:Финляндия
      FJ:Фиджи
      FK:Фолкленд атаўлары
      FM:Микронезия Федеративлик Штатлары
      FO:Фарер атаўлары
      FR:Франция
      GA:Габон
      GB:Уллы Британия
      GD:Гренада
      GE:Грузия
      GF:Француз Гвианасы
      GG:Гернси
      GH:Гана
      GI:Гибралтар
      GL:Гренландия
      GM:Гамбия
      GN:Гвинея
      GP:Гваделупа
      GQ:Экваториальлық Гвинея
      GR:Греция
      GS:Қубла Георгия ҳәм Қубла Сэндвич атаўлары
      GT:Гватемала
      GU:Гуам
      GW:Гвинея-Бисау
      GY:Гайана
      HK:Гонконг ААР
      HN:Гондурас
      HR:Хорватия
      HT:Гаити
      HU:Венгрия
      IC:Канар атаўлары
      ID:Индонезия
      IE:Ирландия
      IL:Израиль
      IM:Мэн атаўы
      IN:Ҳиндстан
      IO:Британияныӊ Ҳинд океанындағы территориясы
      IQ:Ирак
      IR:Иран
      IS:Исландия
      IT:Италия
      JE:Джерси
      JM:Ямайка
      JO:Иордания
      JP:Япония
      KE:Кения
      KG:Қырғызстан
      KH:Камбоджа
      KI:Кирибати
      KM:Комор атаўлары
      KN:Сент-Китс ҳәм Невис
      KP:Арқа Корея
      KR:Қубла Корея
      KW:Кувейт
      KY:Кайман атаўлары
      KZ:Қазақстан
      LA:Лаос
      LB:Ливан
      LC:Сент-Люсия
      LI:Лихтенштейн
      LK:Шри-Ланка
      LR:Либерия
      LS:Лесото
      LT:Литва
      LU:Люксембург
      LV:Латвия
      LY:Ливия
      MA:Марокко
      MC:Монако
      MD:Молдова
      ME:Черногория
      MF:Сен-Мартен
      MG:Мадагаскар
      MH:Маршалл атаўлары
      MK:Арқа Македония
      ML:Мали
      MM:Мьянма (Бирма)
      MN:Монголия
      MO:Макао ААР
      MQ:Мартиника
      MR:Мавритания
      MS:Монтсеррат
      MT:Мальта
      MU:Маврикий
      MV:Мальдив
      MW:Малави
      MX:Мексика
      MY:Малайзия
      MZ:Мозамбик
      NA:Намибия
      NC:Жаӊа Каледония
      NE:Нигер
      NG:Нигерия
      NI:Никарагуа
      NL:Нидерландия
      NO:Норвегия
      NP:Непал
      NR:Науру
      NZ:Жаӊа Зеландия
      OM:Оман
      PA:Панама
      PE:Перу
      PG:Папуа — Жаӊа Гвинея
      PH:Филиппин
      PK:Пакистан
      PL:Польша
      PM:Сен-Пьер ҳәм Микелон
      PN:Питкэрн атаўлары
      PR:Пуэрто-Рико
      PS:Палестина территориялары
      PT:Португалия
      PW:Палау
      PY:Парагвай
      QA:Қатар
      QO:Сыртқы Океания
      RE:Реюньон
      RO:Румыния
      RS:Сербия
      RU:Россия
      RW:Руанда
      SA:Саудия Арабстаны
      SB:Соломон атаўлары
      SC:Сейшель атаўлары
      SD:Судан
      SE:Швеция
      SG:Сингапур
      SI:Словения
      SJ:Шпицберген ҳәм Ян-Майен
      SK:Словакия
      SL:Сьерра-Леоне
      SM:Сан-Марино
      SN:Сенегал
      SO:Сомали
      SR:Суринам
      SS:Қубла Судан
      ST:Сан-Томе ҳәм Принсипи
      SV:Сальвадор
      SX:Синт-Мартен
      SY:Сирия
      SZ:Эсватини
      TC:Тёркс ҳәм Кайкос атаўлары
      TD:Чад
      TF:Француз Қубла территориялары
      TG:Того
      TH:Таиланд
      TJ:Тәжикстан
      TK:Токелау
      TL:Шығыс Тимор
      TM:Түркменстан
      TN:Тунис
      TO:Тонга
      TR:Түркия
      TT:Тринидад ҳәм Тобаго
      TV:Тувалу
      TW:Тайвань
      TZ:Танзания
      UA:Украина
      UG:Уганда
      UN:Бирлескен Миллетлер Шөлкеми
      US:Америка Қурама Штатлары
      UY:Уругвай
      UZ:Өзбекстан
      VA:Ватикан
      VC:Сент-Винсент ҳәм Гренадин атаўлары
      VE:Венесуэла
      VG:Британия Виргин атаўлары
      VI:Америка Виргин атаўлары
      VN:Вьетнам
      VU:Вануату
      WS:Самоа
      XA:қалпеки пәт
      XB:қалпеки Bidi
      XK:Косово
      YE:Йемен
      YT:Майотта
      ZA:Қубла Африка Республикасы
      ZM:Замбия
      ZW:Зимбабве
      ZZ:белгисиз аймақ
      """.trimIndent() }

  val kaa_Cyrl: String? = null

  val kab: String by lazy { """
      AD:Undura
      AE:Tigeldunin Yedduklen Taɛrabin
      AF:Afɣanistan
      AG:Untiga d Barbuda
      AI:Ungiya
      AL:Lalbani
      AM:Arminya
      AO:Ungula
      AR:Arjuntin
      AS:Samwa Tamarikanit
      AT:Ustriya
      AU:Ustrali
      AW:Aruba
      AZ:Azrabijan
      BA:Busna d Hersek
      BB:Barbadus
      BD:Bangladac
      BE:Belǧik
      BF:Burkina Fasu
      BG:Bulgari
      BH:Baḥrin
      BI:Burandi
      BJ:Binin
      BM:Bermuda
      BN:Bruney
      BO:Bulivi
      BR:Brizil
      BS:Bahamas
      BT:Bhutan
      BW:Bustwana
      BY:Bilarus
      BZ:Biliz
      CA:Kanada
      CD:Tigduda Tagdudant n Kungu
      CF:Tigduda n Tefriqt Talemmast
      CG:Kungu
      CH:Swis
      CI:Kuṭ Divwar
      CK:Tigzirin n Kuk
      CL:Cili
      CM:Kamirun
      CN:Lacin
      CO:Kulumbi
      CR:Kusta Rika
      CU:Kuba
      CV:Tigzirin n yixef azegzaw
      CY:Cipr
      CZ:Čček
      DE:Lalman
      DJ:Ǧibuti
      DK:Denmark
      DM:Duminik
      DO:Tigduda Taduminikit
      DZ:Lezzayer
      EC:Ikwaṭur
      EE:Istunya
      EG:Maṣr
      ER:Iritiria
      ES:Spanya
      ET:Utyupi
      FI:Finlund
      FJ:Fiji
      FK:Tigzirin n Falkland
      FM:Mikrunizya
      FR:Fransa
      GA:Gabun
      GB:Tagelda Yedduklen
      GD:Grunad
      GE:Jiyurji
      GF:Ɣana tafransist
      GH:Ɣana
      GI:Jibraltar
      GL:Grunland
      GM:Gambya
      GN:Ɣinya
      GP:Gwadalupi
      GQ:Ɣinya Tasebgast
      GR:Lagris
      GT:Gwatimala
      GU:Gwam
      GW:Ɣinya-Bisaw
      GY:Guwana
      HN:Hunduras
      HR:Kerwasya
      HT:Hayti
      HU:Hungri
      ID:Indunizi
      IE:Lirlund
      IL:Izrayil
      IN:Lhend
      IQ:Lɛiraq
      IR:Iran
      IS:Island
      IT:Ṭelyan
      JM:Jamyika
      JO:Lajurdani
      JP:Jappu
      KE:Kinya
      KG:Kirigistan
      KH:Cambudya
      KI:Kiribati
      KM:Kumur
      KN:San Kits d Nivis
      KP:Kurya, Ufella
      KR:Kurya, Wadda
      KW:Kuwayt
      KY:Tigzirin n Kamyan
      KZ:Kazaxistan
      LA:Laws
      LB:Lubnan
      LC:San Lučya
      LI:Layctenstan
      LK:Sri Lanka
      LR:Libirya
      LS:Lizuṭu
      LT:Liṭwanya
      LU:Luksamburg
      LV:Latvia
      LY:Libya
      MA:Lmerruk
      MC:Munaku
      MD:Muldabi
      MG:Madaɣecqer
      MH:Tigzirin n Marcal
      ML:Mali
      MM:Myanmar
      MN:Mungulya
      MP:Tigzirin n Maryan Ufella
      MQ:Martinik
      MR:Muriṭanya
      MS:Munsirat
      MT:Malṭ
      MU:Muris
      MV:Maldib
      MW:Malawi
      MX:Meksik
      MY:Malizya
      MZ:Muzembiq
      NA:Namibya
      NC:Kalidunya Tamaynut
      NE:Nijer
      NF:Tigzirin Tinawfukin
      NG:Nijirya
      NI:Nikaragwa
      NL:Timura-Yessakesren
      NO:Nurvij
      NP:Nipal
      NR:Nuru
      NU:Niwi
      NZ:Ziland Tamaynut
      OM:Ɛuman
      PA:Panam
      PE:Piru
      PF:Pulunizi tafransist
      PG:Ɣinya Tamaynut Tapaput
      PH:Filipin
      PK:Pakistan
      PL:Pulund
      PM:San Pyar d Miklun
      PN:Pitkarin
      PR:Purtu Riku
      PS:Falisṭin d Ɣezza
      PT:Purtugal
      PW:Palu
      PY:Paragway
      QA:Qaṭar
      RE:Timlilit
      RO:Rumani
      RU:Rrus
      RW:Ruwanda
      SA:Suɛudiya Taɛrabt
      SB:Tigzirin n Sulumun
      SC:Seycel
      SD:Sudan
      SE:Swid
      SG:Singafur
      SH:Sant Ilina
      SI:Sluvinya
      SK:Sluvakya
      SL:Sira Lyun
      SM:San Marinu
      SN:Sinigal
      SO:Ṣumal
      SR:Surinam
      ST:Saw Tumi d Pransip
      SV:Salvadur
      SY:Surya
      SZ:Swazilund
      TC:Ṭurk d Tegzirin n Kaykus
      TD:Čad
      TG:Ṭugu
      TH:Ṭayland
      TJ:Tajikistan
      TK:Ṭuklu
      TL:Tumur Asamar
      TM:Ṭurkmanistan
      TN:Tunes
      TO:Ṭunga
      TR:Ṭurk
      TT:Ṭrindad d Ṭubagu
      TV:Ṭuvalu
      TW:Ṭaywan
      TZ:Ṭanzanya
      UA:Ukran
      UG:Uɣanda
      US:WDM
      UY:Urugway
      UZ:Uzbaxistan
      VA:Awanek n Vatikan
      VC:San Vansu d Grunadin
      VE:Venzwila
      VG:Tigzirin Tiverjiniyin Tigliziyin
      VI:W.D. Tigzirin n Virginya
      VN:Vyeṭnam
      VU:Vanwatu
      WF:Wallis d Futuna
      WS:Samwa
      YE:Lyamen
      YT:Mayuṭ
      ZA:Tafriqt Wadda
      ZM:Zambya
      ZW:Zimbabwi
      """.trimIndent() }

  val kam: String by lazy { """
      AD:Andora
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Marekani
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Mbulundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kananda
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Isiwa sya Cook
      CL:Chile
      CM:Kameluni
      CN:Kyaina
      CO:Kolombia
      CR:Kostarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misili
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Uvalanza
      GA:Gaboni
      GB:Uingereza
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Isiwa sya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Lwanda
      SA:Saudi
      SB:Isiwa sya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukraini
      UG:Ukanda
      US:Marekani
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Nzambia
      ZW:Nzimbambwe
      """.trimIndent() }

  val kde: String by lazy { """
      AD:Andola
      AE:Dimiliki dya Vakulungwa va Chalabu
      AF:Afuganistani
      AG:Antigua na Balbuda
      AI:Angwila
      AL:Albania
      AM:Almenia
      AO:Angola
      AR:Adyentina
      AS:Samoa ya Malekani
      AT:Austlia
      AU:Austlalia
      AW:Aluba
      AZ:Azabadyani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgidi
      BF:Buchinafaso
      BG:Bulgalia
      BH:Bahaleni
      BI:Bulundi
      BJ:Benini
      BM:Belmuda
      BN:Blunei
      BO:Bolivia
      BR:Blazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belalusi
      BZ:Belize
      CA:Kanada
      CD:Jamuhuli ya Chidemoklasia ya kuKongo
      CF:Jamuhuli ya Afilika ya Paching’ati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Chisiwa cha Cook
      CL:Chile
      CM:Kameluni
      CN:China
      CO:Kolombia
      CR:Kostalika
      CU:Kuba
      CV:Kepuvede
      CY:Kuplosi
      CZ:Jamuhuli ya Chechi
      DE:Udyerumani
      DJ:Dyibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamuhuli ya Dominika
      DZ:Aljelia
      EC:Ekwado
      EE:Estonia
      EG:Misli
      ER:Elitilea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Chisiwa cha Falkland
      FM:Mikilonesia
      FR:Ufalansa
      GA:Gaboni
      GB:Nngalesa
      GD:Glenada
      GE:Dyodya
      GF:Gwiyana ya Ufalansa
      GH:Ghana
      GI:Diblalta
      GL:Glinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugilichi
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondulasi
      HR:Kolasia
      HT:Haiti
      HU:Hungalia
      ID:Indonesia
      IE:Ayalandi
      IL:Islaeli
      IN:India
      IQ:Ilaki
      IR:Uadyemi
      IS:Aislandi
      IT:Italia
      JM:Dyamaika
      JO:Yordani
      JP:Dyapani
      KE:Kenya
      KG:Kiligizistani
      KH:Kambodia
      KI:Kilibati
      KM:Komolo
      KN:Santakitzi na Nevis
      KP:Kolea Kasikazini
      KR:Kolea Kusini
      KW:Kuwaiti
      KY:Chisiwa cha Kemen
      KZ:Kazachistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sililanka
      LR:Libelia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moloko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Chisiwa cha Malushal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Chisiwa cha Marian cha Kasikazini
      MQ:Malitiniki
      MR:Molitania
      MS:Monselati
      MT:Malta
      MU:Molisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nidyeli
      NF:Chisiwa cha Nolufok
      NG:Nidyelia
      NI:Nikalagwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Naulu
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Pelu
      PF:Polinesia ya Ufalansa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieli na Mikeloni
      PN:Pitikeluni
      PR:Pwetoliko
      PS:Nchingu wa Magalibi wa Mpanda wa kuGaza wa kuPales
      PT:Uleno
      PW:Palau
      PY:Palagwai
      QA:Katali
      RE:Liyunioni
      RO:Lomania
      RU:Ulusi
      RW:Lwanda
      SA:Saudia
      SB:Chisiwa cha Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siela Leoni
      SM:Samalino
      SN:Senegali
      SO:Somalia
      SR:Sulinamu
      ST:Saotome na Prinsipe
      SV:Elsavado
      SY:Silia
      SZ:Uswazi
      TC:Chisiwa cha Tuluchi na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tadikistani
      TK:Tokelau
      TL:Timoli ya Mashaliki
      TM:Tuluchimenistani
      TN:Tunisia
      TO:Tonga
      TR:Utuluchi
      TT:Tilinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Uklaini
      UG:Uganda
      US:Malekani
      UY:Ulugwai
      UZ:Uzibechistani
      VA:Vatikani
      VC:Santavisenti na Glenadini
      VE:Venezuela
      VG:Chisiwa Chivihi cha Wingalesa
      VI:Chisiwa Chivihi cha Malekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Maole
      ZA:Afilika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val kea: String by lazy { """
      001:Mundu
      002:Áfrika
      003:Merka di Norti
      005:Merka di Sul
      009:Oseania
      011:Áfrika Osidental
      013:Merka Sentral
      014:Áfrika Oriental
      015:Norti di Áfrika
      017:Áfrika Sentral
      018:Sul di Áfrika
      019:Merkas
      021:Norti di Merka
      029:Karaibas
      030:Ázia Oriental
      034:Sul di Ázia
      035:Sudesti Aziátiku
      039:Europa di Sul
      053:Australázia
      054:Melanézia
      057:Rejion di Mikronézia
      061:Polinézia
      142:Ázia
      143:Ázia Sentral
      145:Ázia Osidental
      150:Europa
      151:Europa Oriental
      154:Europa di Norti
      155:Europa Osidental
      202:Áfrika Subisariana
      419:Merka Latinu
      AC:Ilha di Asenson
      AD:Andora
      AE:Emiradus Árabi Unidu
      AF:Afeganistãu
      AG:Antigua i Barbuda
      AI:Angila
      AL:Albánia
      AM:Arménia
      AO:Angola
      AQ:Antártika
      AR:Arjentina
      AS:Samoa Merkanu
      AT:Áustria
      AU:Austrália
      AW:Aruba
      AX:Ilhas Åland
      AZ:Azerbaidjan
      BA:Bósnia i Erzegovina
      BB:Barbadus
      BD:Bangladexi
      BE:Béljika
      BF:Burkina Fasu
      BG:Bulgária
      BH:Barain
      BI:Burundi
      BJ:Benin
      BL:San Bartolomeu
      BM:Bermudas
      BN:Brunei
      BO:Bolívia
      BQ:Karaibas Olandezas
      BR:Brazil
      BS:Baamas
      BT:Butan
      BV:Ilha Buvê
      BW:Botsuana
      BY:Belarus
      BZ:Belizi
      CA:Kanadá
      CC:Ilhas Kokus (Keeling)
      CD:Kongu - Kinxasa
      CF:Republika Sentru-Afrikanu
      CG:Kongu - Brazavili
      CH:Suisa
      CI:Kosta di Marfin
      CK:Ilhas Kuk
      CL:Xili
      CM:Kamarons
      CN:Xina
      CO:Kolómbia
      CP:Ilha Kliperton
      CR:Kosta Rika
      CU:Kuba
      CV:Kabu Verdi
      CW:Kurasau
      CX:Ilha di Natal
      CY:Xipri
      CZ:Txékia
      DE:Alimanha
      DG:Diegu Garsia
      DJ:Djibuti
      DK:Dinamarka
      DM:Dominika
      DO:Repúblika Dominikana
      DZ:Arjélia
      EA:Seuta i Melilha
      EC:Ekuador
      EE:Stónia
      EG:Ejitu
      EH:Sara Osidental
      ER:Iritreia
      ES:Spanha
      ET:Etiópia
      EU:Union Europeia
      EZ:Eurozona
      FI:Finlándia
      FJ:Fidji
      FK:Ilhas Malvinas
      FM:Mikronézia
      FO:Ilhas Faroe
      FR:Fransa
      GA:Gabon
      GB:Reinu Unidu
      GD:Granada
      GE:Jiórjia
      GF:Giana Franseza
      GG:Gernzi
      GH:Gana
      GI:Jibraltar
      GL:Gronelándia
      GM:Gámbia
      GN:Gine
      GP:Guadalupi
      GQ:Gine Ekuatorial
      GR:Grésia
      GS:Ilhas Jeórjia di Sul i Sanduixi di Sul
      GT:Guatimala
      GU:Guam
      GW:Gine-Bisau
      GY:Giana
      HK:Hong Kong, Rejion Administrativu Spesial di Xina
      HM:Ilhas Heard i McDonald
      HN:Onduras
      HR:Kroásia
      HT:Aití
      HU:Ungria
      IC:Kanárias
      ID:Indonézia
      IE:Irlanda
      IL:Israel
      IM:Ilha di Man
      IN:Índia
      IQ:Iraki
      IR:Irãu
      IS:Islándia
      IT:Itália
      JE:Jersi
      JM:Jamaika
      JO:Jordánia
      JP:Japon
      KE:Kénia
      KG:Kirgistan
      KH:Kambodja
      KI:Kiribati
      KM:Kamoris
      KN:San Kristovan i Nevis
      KP:Koreia di Norti
      KR:Koreia di Sul
      KW:Kueiti
      KY:Ilhas Kaimon
      KZ:Kazakistan
      LA:Laus
      LB:Líbanu
      LC:Santa Lúsia
      LI:Lixenstain
      LK:Sri Lanka
      LR:Libéria
      LS:Lezotu
      LT:Lituánia
      LU:Luxemburgu
      LV:Letónia
      LY:Líbia
      MA:Marokus
      MC:Mónaku
      MD:Moldávia
      ME:Montenegru
      MF:San Martinhu (Fransa)
      MG:Madagaskar
      MH:Ilhas Marxal
      MK:Masidónia di Norti
      ML:Mali
      MM:Mianmar (Birmánia)
      MN:Mongólia
      MO:Makau, Rejion Administrativu Spesial di Xina
      MP:Ilhas Marianas di Norti
      MQ:Martinika
      MR:Mauritánia
      MS:Monserat
      MT:Malta
      MU:Maurísia
      MV:Maldivas
      MW:Malaui
      MX:Méxiku
      MY:Malázia
      MZ:Musambiki
      NA:Namíbia
      NC:Nova Kalidónia
      NE:Nijer
      NF:Ilhas Norfolk
      NG:Nijéria
      NI:Nikarágua
      NL:Olanda
      NO:Noruega
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nova Zilándia
      OM:Oman
      PA:Panamá
      PE:Peru
      PF:Polinézia Franseza
      PG:Papua-Nova Gine
      PH:Filipinas
      PK:Pakistan
      PL:Pulónia
      PM:San Piere i Mikelon
      PN:Ilhas Pitkairn
      PR:Portu Riku
      PS:Tiritóriu palistinianu
      PT:Purtugal
      PW:Palau
      PY:Paraguai
      QA:Katar
      QO:Ilhas di Oseania
      RE:Runion
      RO:Ruménia
      RS:Sérvia
      RU:Rúsia
      RW:Ruanda
      SA:Arábia Saudita
      SB:Ilhas Salumãu
      SC:Seixelis
      SD:Sudon
      SE:Suésia
      SG:Singapura
      SH:Santa Ilena
      SI:Slovénia
      SJ:Svalbard i Jan Maien
      SK:Slovákia
      SL:Sera Lioa
      SM:San Marinu
      SN:Senegal
      SO:Sumália
      SR:Surinami
      SS:Sudon di Sul
      ST:San Tume i Prínsipi
      SV:El Salvador
      SX:San Martinhu (Olanda)
      SY:Síria
      SZ:Eswatini
      TA:Tristan da Kunha
      TC:Ilhas Turkas i Kaikus
      TD:Txadi
      TF:Terras Franses di Sul
      TG:Togu
      TH:Tailándia
      TJ:Tadjikistan
      TK:Tokelau
      TL:Timor Lesti
      TM:Turkumenistan
      TN:Tunízia
      TO:Tonga
      TR:Turkia
      TT:Trinidad i Tobagu
      TV:Tuvalu
      TW:Taiuan
      TZ:Tanzánia
      UA:Ukránia
      UG:Uganda
      UM:Ilhas Minoris Distantis de Stadus Unidus
      UN:Nasons Unidas
      US:Stadus Unidos di Merka
      UY:Uruguai
      UZ:Uzbekistan
      VA:Vatikanu
      VC:San Bisenti i Granadinas
      VE:Vinizuela
      VG:Ilhas Virjens Británikas
      VI:Ilhas Virjens Merkanas
      VN:Vietnam
      VU:Vanuatu
      WF:Ualis i Futuna
      WS:Samoa
      XA:Pseudo-sotakis
      XB:Pseudo-bidiresional
      XK:Kozovu
      YE:Iémen
      YT:Maiote
      ZA:Áfrika di Sul
      ZM:Zámbia
      ZW:Zimbábui
      ZZ:Rejion Diskonxedu
      """.trimIndent() }

  val kgp: String by lazy { """
      001:Tã mĩ ke kar
      002:Afrika
      003:Nãrti-Amẽrika
      005:Sur-Amẽrika
      009:Oseanĩja
      011:Afrika Rãpur
      013:Amẽrika-Kuju
      014:Afrika Rãjur
      015:Nãrti-Afrika
      017:Afrika-Kuju
      018:Afrika Mẽrinhonỹr
      019:Amẽrika ag
      021:Amẽrika Setẽntrionỹr
      029:Karime
      030:Ajia Rãjur
      034:Ajia Mẽrinhonỹr
      035:Ajia Sur-Rãjur
      039:Orópa Mẽrinhonỹr
      053:Ausitrarajia
      054:Mẽranẽjia
      057:Mĩkronẽjia Pénĩn
      061:Porinẽjia
      142:Ajia
      143:Ajia-Kuju
      145:Ajia-Rãpur
      150:Orópa
      151:Orópa-Rãjur
      154:Orópa Setẽntrionỹr
      155:Orópa Rãpur
      202:Afrika Sahara-Jẽgu
      419:Amẽrika Ratinỹ
      AC:Asẽnsỹv Goj-vẽso
      AD:Ỹnora
      AE:Emĩrano Arame Unĩno
      AF:Afeganĩtã
      AG:Ỹntiguva kar Marmuna
      AI:Ỹngira
      AL:Armánĩja
      AM:Armẽnĩja
      AO:Ỹgóra
      AQ:Ỹntartina
      AR:Arjẽtinỹ
      AS:Samãva Amẽrikynỹ
      AT:Agtirija
      AU:Avotyraria
      AW:Aruma
      AX:Gojga Goj-vẽso
      AZ:Ajermajjáv
      BA:Mósinĩja
      BB:Juvã-mág
      BD:Mágranési
      BE:Mérjika
      BF:Murkinỹ Faso
      BG:Murgarjia
      BH:Marẽj
      BI:Murũni
      BJ:Menĩnh
      BL:Sỹ Martoromeu
      BM:Mermũna
      BN:Mrunẽj
      BO:Morivija
      BQ:Pajisi Rur Karimejã
      BR:Mrasir
      BS:Mahámỹ
      BT:Mutỹv
      BV:Muve Goj-vẽso
      BW:Monsuvỹnỹ
      BY:Miero-Husija
      BZ:Merije
      CA:Kanỹna
      CC:Kokonh Goj-vẽso (Killing)
      CD:Kãgo - Kĩsaja
      CF:Afrikanỹ-kuju Repumrika
      CG:Kãgo Repumrika
      CH:Suvisa
      CI:Jãn-mág-kupri Fyr
      CK:Kuki Goj-vẽso
      CL:Sire
      CM:Kamỹrãj
      CN:Sĩnỹ
      CO:Korãmija
      CP:Kripertãn Goj-vẽso
      CR:Konhta Rika
      CU:Kuma
      CV:Pu Tánh
      CW:Kurasavo
      CX:Krĩtimỹnh Goj-vẽso
      CY:Sipre
      CZ:Sékija
      DE:Aremỹija
      DG:Niego Garsija
      DJ:Nhimuti
      DK:Ninỹmỹrka
      DM:Nomĩnĩka
      DO:Repumrika Nomĩnĩkỹnỹ
      DZ:Arjérija
      EA:Sevuta kar Mẽrira
      EC:Ekuvanor
      EE:Enhtonĩja
      EG:Ejito
      EH:Sahara Rãpur
      ER:Erytiréja
      ES:Enhpỹnija
      ET:Etiópija
      EU:Unĩjáv Oropéja
      EZ:Evoro Ga
      FI:Fĩrỹnija
      FJ:Fiji
      FK:Mỹrvĩnỹ Goj-vẽso
      FM:Goj-vẽso-sĩ Kẽsir
      FO:Faróve Goj-vẽso
      FR:Frỹsa
      GA:Gabã
      GB:Rejnũ Unĩnu
      GD:Granỹna
      GE:Jiórja
      GF:Frỹsa Gijanỹ
      GG:Gérnesej
      GH:Ganỹ
      GI:Gimrar-tar
      GL:Groẽrỹnija
      GM:Gỹmija
      GN:Ginẽ
      GP:Guvanarupe
      GQ:Ginẽ Ekuvatoriar
      GR:Grésa
      GS:Jiórja-Sur kar Sỹnvisi-Sur Goj-vẽso Ag
      GT:Guvatimỹra
      GU:Guvỹm
      GW:Ginẽ-Misav
      GY:Gijỹnỹ
      HK:Hãg Kãg, Sinỹ ERA
      HM:Hárni kar Magtonarni Goj-vẽso Ag
      HN:Hãnura
      HR:Kroasa
      HT:Ajti
      HU:Ũgrija
      IC:Kanỹrija Goj-vẽso
      ID:Ĩnonẽja
      IE:Irỹna
      IL:Isihaé
      IM:Mỹn Goj-vẽso
      IN:Ĩnija
      IQ:Iraki
      IR:Irỹ
      IS:Inhrỹnija
      IT:Itarija
      JE:Jérsej
      JM:Jamỹjka
      JO:Jornánĩja
      JP:Japã
      KE:Kenĩja
      KG:Kirginhtỹv
      KH:Kỹmója
      KI:Kirimati
      KM:Komãre
      KN:Sỹ Krinhtóvỹv kar Nẽvinh
      KP:Nãrti-Koréja
      KR:Sur-Koréja
      KW:Kuvajti
      KY:Kajmỹm Goj-vẽso
      KZ:Kajakinhtỹv
      LA:Raosi
      LB:Rimanã
      LC:Sỹta Rusija
      LI:Rinhsiténh-tajin
      LK:Siri Rỹnka
      LR:Rimérija
      LS:Resotu
      LT:Rituỹnĩja
      LU:Rusẽmurgu
      LV:Retãnĩja
      LY:Rimija
      MA:Mỹhókonh
      MC:Mãnỹko
      MD:Mãrnova
      ME:Krĩsá
      MF:Sỹ Mỹrtĩjũ
      MG:Mỹnaganhtar
      MH:MỹrSar Goj-vẽso
      MK:Nãrti-Mỹsenonĩja
      ML:Mỹri
      MM:Mĩjỹmỹr
      MN:Mãngórija
      MO:Mỹkav, Sĩnỹ ERA
      MP:Nãrti-Mỹrijỹnỹ Goj-vẽso
      MQ:Mỹrtinĩka
      MR:Mãritỹnĩja
      MS:Mãtisehati
      MT:Mỹrta
      MU:Mãriso
      MV:Mỹrniva
      MW:Mỹravi
      MX:Mẽsiku
      MY:Mỹraja
      MZ:Mãsỹmiki
      NA:Nỹmĩmija
      NC:Karenonĩja Tãg
      NE:Nĩjer
      NF:Nãrforki Goj-vẽso
      NG:Nĩjérija
      NI:Nĩkaragva
      NL:Pajisi Rur
      NO:Nãrovéga
      NP:Nẽpar
      NR:Nỹuru
      NU:Nĩvue
      NZ:Jerỹnija Tãg
      OM:Omỹ
      PA:Panỹmỹ
      PE:Piru
      PF:Frỹsa Porinẽja
      PG:Papuva-Ginẽ Tãg
      PH:Firipinỹ
      PK:Pakinhtỹv
      PL:Porãnija
      PM:Sỹ Penru kar Mĩkerỹv
      PN:Pinkajir Goj-vẽso
      PR:Portu Hiku
      PS:Tehitórijo Parenhtinũ
      PT:Portugar
      PW:Paravu
      PY:Paraguvaj
      QA:Katar
      QO:Osiỹnĩja Kuvar-gy
      RE:Hujáv
      RO:Homẽnĩja
      RS:Sérvija
      RU:Husija
      RW:Huỹna
      SA:Aramija Savnita
      SB:Saromỹv Goj-vẽso
      SC:Sejserenh
      SD:Suná
      SE:Suésa
      SG:Sĩgapura
      SH:Sỹnta Erenỹ
      SI:Enhrovenĩja
      SJ:Inhvarmarni kar Jan Mỹjẽn
      SK:Enhrovakija
      SL:Krĩ Mĩgkusũg-fi
      SM:Sỹ Mỹrĩnũ
      SN:Senẽgar
      SO:Somỹrija
      SR:Surinỹmĩ
      SS:Sur-Sunáv
      ST:Sỹ Tomẽ kar Prĩsipi
      SV:Er Sarvanor
      SX:Sĩti Mỹ’artẽn
      SY:Sirija
      SZ:Esuatinĩ
      TA:Trinhtỹv Nakũja
      TC:Turka kar Kajko Goj-vẽso Ag
      TD:Sane
      TF:Sur Frỹsa Tehitórijo
      TG:Togo
      TH:Taj-Ga
      TJ:Tanijikinhtỹv
      TK:Tokeravu
      TL:Timãr-Rãjur
      TM:Turkomẽnĩnhtỹv
      TN:Tunĩja
      TO:Tãga
      TR:Turkija
      TT:Trĩnane kar Tomagu
      TV:Tuvaru
      TW:Tajuvỹ
      TZ:Tỹnjỹnĩja
      UA:Ukrỹnĩja
      UG:Ugỹna
      UM:EUA Goj-vẽso Kãsir
      UN:Nỹsãn Unĩna
      US:Enhtano Unĩno
      UY:Urugvaj
      UZ:Unhmekinhtỹv
      VA:Vatikỹnũ Emã-mág
      VC:Sỹ Visenti kar Granỹninỹ
      VE:Venẽjuvéra
      VG:Mritỹnĩja Goj-vẽso
      VI:Virjĩg Goj-vẽso tỹ Amẽrikỹnỹ
      VN:Vijétinỹ
      VU:Vanũvatu
      WF:Varinh kar Futunỹ
      WS:Samãva
      XA:Ón vĩ ag
      XB:Ón régre mĩ.
      XK:Kosovo
      YE:Jemẽn
      YT:Mỹjóte
      ZA:Sur-Afrika
      ZM:Jỹmija
      ZW:Jĩmamuje
      ZZ:Reji’ỹv Veja tũ
      """.trimIndent() }

  val khq: String by lazy { """
      AD:Andoora
      AE:Laaraw Imaarawey Margantey
      AF:Afgaanistan
      AG:Antigua nda Barbuuda
      AI:Angiiya
      AL:Albaani
      AM:Armeeni
      AO:Angoola
      AR:Argentine
      AS:Ameriki Samoa
      AT:Otriši
      AU:Ostraali
      AW:Aruuba
      AZ:Azerbaayijaŋ
      BA:Bosni nda Herzegovine
      BB:Barbaados
      BD:Bangladeši
      BE:Belgiiki
      BF:Burkina faso
      BG:Bulgaari
      BH:Bahareen
      BI:Burundi
      BJ:Beniŋ
      BM:Bermuda
      BN:Bruunee
      BO:Boolivi
      BR:Breezil
      BS:Bahamas
      BT:Buutaŋ
      BW:Botswaana
      BY:Biloriši
      BZ:Beliizi
      CA:Kanaada
      CD:Kongoo demookaratiki laboo
      CF:Centraafriki koyra
      CG:Kongoo
      CH:Swisu
      CI:Kudwar
      CK:Kuuk gungey
      CL:Šiili
      CM:Kameruun
      CN:Šiin
      CO:Kolombi
      CR:Kosta rika
      CU:Kuuba
      CV:Kapuver gungey
      CY:Šiipur
      CZ:Cek labo
      DE:Almaaɲe
      DJ:Jibuuti
      DK:Danemark
      DM:Doominiki
      DO:Doominiki laboo
      DZ:Alžeeri
      EC:Ekwateer
      EE:Estooni
      EG:Misra
      ER:Eritree
      ES:Espaaɲe
      ET:Ecioopi
      FI:Finlandu
      FJ:Fiji
      FK:Kalkan gungey
      FM:Mikronezi
      FR:Faransi
      GA:Gaabon
      GB:Albaasalaama Marganta
      GD:Grenaada
      GE:Gorgi
      GF:Faransi Guyaan
      GH:Gaana
      GI:Gibraltar
      GL:Grinland
      GM:Gambi
      GN:Gine
      GP:Gwadeluup
      GQ:Ginee Ekwatorial
      GR:Greece
      GT:Gwatemaala
      GU:Guam
      GW:Gine-Bisso
      GY:Guyaane
      HN:Honduras
      HR:Krwaasi
      HT:Haiti
      HU:Hungaari
      ID:Indoneezi
      IE:Irlandu
      IL:Israyel
      IN:Indu laboo
      IQ:Iraak
      IR:Iraan
      IS:Ayceland
      IT:Itaali
      JM:Jamaayik
      JO:Urdun
      JP:Jaapoŋ
      KE:Keeniya
      KG:Kyrgyzstan
      KH:Kamboogi
      KI:Kiribaati
      KM:Komoor
      KN:Seŋ Kitts nda Nevis
      KP:Kooree, Gurma
      KR:Kooree, Hawsa
      KW:Kuweet
      KY:Kayman gungey
      KZ:Kaazakstan
      LA:Laawos
      LB:Lubnaan
      LC:Seŋ Lussia
      LI:Liechtenstein
      LK:Srilanka
      LR:Liberia
      LS:Leesoto
      LT:Lituaani
      LU:Luxembourg
      LV:Letooni
      LY:Liibi
      MA:Maarok
      MC:Monako
      MD:Moldovi
      MG:Madagascar
      MH:Maršal gungey
      ML:Maali
      MM:Maynamar
      MN:Mongooli
      MP:Mariana Gurma Gungey
      MQ:Martiniiki
      MR:Mooritaani
      MS:Montserrat
      MT:Malta
      MU:Mooris gungey
      MV:Maldiivu
      MW:Malaawi
      MX:Mexiki
      MY:Maleezi
      MZ:Mozambik
      NA:Naamibi
      NC:Kaaledooni Taagaa
      NE:Nižer
      NF:Norfolk Gungoo
      NG:Naajiriia
      NI:Nikaragwa
      NL:Hollandu
      NO:Norveej
      NP:Neepal
      NR:Nauru
      NU:Niue
      NZ:Zeelandu Taaga
      OM:Omaan
      PA:Panama
      PE:Peeru
      PF:Faransi Polineezi
      PG:Papua Ginee Taaga
      PH:Filipine
      PK:Paakistan
      PL:Poloɲe
      PM:Seŋ Piyer nda Mikelon
      PN:Pitikarin
      PR:Porto Riko
      PS:Palestine Dangay nda Gaaza
      PT:Portugaal
      PW:Palu
      PY:Paraguwey
      QA:Kataar
      RE:Reenioŋ
      RO:Rumaani
      RU:Iriši laboo
      RW:Rwanda
      SA:Saudiya
      SB:Solomon Gungey
      SC:Seešel
      SD:Suudaŋ
      SE:Sweede
      SG:Singapur
      SH:Seŋ Helena
      SI:Sloveeni
      SK:Slovaaki
      SL:Seera Leon
      SM:San Marino
      SN:Senegal
      SO:Somaali
      SR:Surinaam
      ST:Sao Tome nda Prinsipe
      SV:Salvador laboo
      SY:Suuria
      SZ:Swaziland
      TC:Turk nda Kayikos Gungey
      TD:Caadu
      TG:Togo
      TH:Taayiland
      TJ:Taažikistan
      TK:Tokelau
      TL:Timoor hawsa
      TM:Turkmenistaŋ
      TN:Tunizi
      TO:Tonga
      TR:Turki
      TT:Trinidad nda Tobaago
      TV:Tuvalu
      TW:Taayiwan
      TZ:Tanzaani
      UA:Ukreen
      UG:Uganda
      US:Ameriki Laabu Margantey
      UY:Uruguwey
      UZ:Uzbeekistan
      VA:Vaatikan Laama
      VC:Seŋvinsaŋ nda Grenadine
      VE:Veneezuyeela
      VG:Britiši Virgin gungey
      VI:Ameerik Virgin Gungey
      VN:Vietnaam
      VU:Vanautu
      WF:Wallis nda Futuna
      WS:Samoa
      YE:Yaman
      YT:Mayooti
      ZA:Hawsa Afriki Laboo
      ZM:Zambi
      ZW:Zimbabwe
      """.trimIndent() }

  val ki: String by lazy { """
      AD:Andora
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Marekani
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Mburundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:Caina
      CO:Kolombia
      CR:Kostarika
      CU:Kiumba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Njeremani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misri
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Ubaranja
      GA:Gaboni
      GB:Ngeretha
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ngana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Njorondani
      JP:Njabani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namimbia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nainjeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Rwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somaria
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukraini
      UG:Uganda
      US:Amerika
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val kk: String by lazy { """
      001:әлем
      002:Африка
      003:Солтүстік Америка
      005:Оңтүстік Америка
      009:Океания
      011:Батыс Африка
      013:Орталық Америка
      014:Шығыс Африка
      015:Солтүстік Африка
      017:Орталық Африка
      018:Оңтүстік Африка аймағы
      019:Америка
      021:Солтүстік Америка (аймақ)
      029:Кариб
      030:Шығыс Азия
      034:Оңтүстік Азия
      035:Оңтүстік-Шығыс Азия
      039:Оңтүстік Еуропа
      053:Аустралазия
      054:Меланезия
      057:Микронезия аймағы
      061:Полинезия
      142:Азия
      143:Орталық Азия
      145:Батыс Азия
      150:Еуропа
      151:Шығыс Еуропа
      154:Солтүстік Еуропа
      155:Батыс Еуропа
      202:Субсахаралық Африка
      419:Латын Америкасы
      AC:Әскенжін аралы
      AD:Андорра
      AE:Біріккен Араб Әмірліктері
      AF:Ауғанстан
      AG:Антигуа және Барбуда
      AI:Ангилья
      AL:Албания
      AM:Армения
      AO:Ангола
      AQ:Антарктида
      AR:Аргентина
      AS:Америкалық Самоа
      AT:Аустрия
      AU:Аустралия
      AW:Аруба
      AX:Аланд аралдары
      AZ:Әзірбайжан
      BA:Босния және Герцеговина
      BB:Барбадос
      BD:Бангладеш
      BE:Бельгия
      BF:Буркина-Фасо
      BG:Болгария
      BH:Бахрейн
      BI:Бурунди
      BJ:Бенин
      BL:Сен-Бартелеми
      BM:Бермуд аралдары
      BN:Бруней
      BO:Боливия
      BQ:Бонэйр, Синт-Эстатиус және Саба
      BR:Бразилия
      BS:Багам аралдары
      BT:Бутан
      BV:Буве аралы
      BW:Ботсвана
      BY:Беларусь
      BZ:Белиз
      CA:Канада
      CC:Кокос (Килинг) аралдары
      CD:Конго
      CF:Орталық Африка Республикасы
      CG:Конго-Браззавиль Республикасы
      CH:Швейцария
      CI:Кот-д’Ивуар
      CK:Кук аралдары
      CL:Чили
      CM:Камерун
      CN:Қытай
      CO:Колумбия
      CP:Клиппертон аралы
      CR:Коста-Рика
      CU:Куба
      CV:Кабо-Верде
      CW:Кюрасао
      CX:Рождество аралы
      CY:Кипр
      CZ:Чехия
      DE:Германия
      DG:Диего-Гарсия
      DJ:Джибути
      DK:Дания
      DM:Доминика
      DO:Доминикан Республикасы
      DZ:Алжир
      EA:Сеута және Мелилья
      EC:Эквадор
      EE:Эстония
      EG:Мысыр
      EH:Батыс Сахара
      ER:Эритрея
      ES:Испания
      ET:Эфиопия
      EU:Еуропалық Одақ
      EZ:Еуроаймақ
      FI:Финляндия
      FJ:Фиджи
      FK:Фолкленд аралдары
      FM:Микронезия
      FO:Фарер аралдары
      FR:Франция
      GA:Габон
      GB:Ұлыбритания
      GD:Гренада
      GE:Грузия
      GF:Француз Гвианасы
      GG:Гернси
      GH:Гана
      GI:Гибралтар
      GL:Гренландия
      GM:Гамбия
      GN:Гвинея
      GP:Гваделупа
      GQ:Экваторлық Гвинея
      GR:Грекия
      GS:Оңтүстік Георгия және Оңтүстік Сандвич аралдары
      GT:Гватемала
      GU:Гуам
      GW:Гвинея-Бисау
      GY:Гайана
      HK:Сянган АӘА
      HM:Херд аралы және Макдональд аралдары
      HN:Гондурас
      HR:Хорватия
      HT:Гаити
      HU:Венгрия
      IC:Канар аралдары
      ID:Индонезия
      IE:Ирландия
      IL:Израиль
      IM:Мэн аралы
      IN:Үндістан
      IO:Үнді мұхитындағы Британ аймағы
      IQ:Ирак
      IR:Иран
      IS:Исландия
      IT:Италия
      JE:Джерси
      JM:Ямайка
      JO:Иордания
      JP:Жапония
      KE:Кения
      KG:Қырғызстан
      KH:Камбоджа
      KI:Кирибати
      KM:Комор аралдары
      KN:Сент-Китс және Невис
      KP:Солтүстік Корея
      KR:Оңтүстік Корея
      KW:Кувейт
      KY:Кайман аралдары
      KZ:Қазақстан
      LA:Лаос
      LB:Ливан
      LC:Сент-Люсия
      LI:Лихтенштейн
      LK:Шри-Ланка
      LR:Либерия
      LS:Лесото
      LT:Литва
      LU:Люксембург
      LV:Латвия
      LY:Ливия
      MA:Марокко
      MC:Монако
      MD:Молдова
      ME:Черногория
      MF:Сен-Мартен
      MG:Мадагаскар
      MH:Маршалл аралдары
      MK:Солтүстік Македония
      ML:Мали
      MM:Мьянма (Бирма)
      MN:Моңғолия
      MO:Макао АӘА
      MP:Солтүстік Мариана аралдары
      MQ:Мартиника
      MR:Мавритания
      MS:Монтсеррат
      MT:Мальта
      MU:Маврикий
      MV:Мальдив аралдары
      MW:Малави
      MX:Мексика
      MY:Малайзия
      MZ:Мозамбик
      NA:Намибия
      NC:Жаңа Каледония
      NE:Нигер
      NF:Норфолк аралы
      NG:Нигерия
      NI:Никарагуа
      NL:Нидерланд
      NO:Норвегия
      NP:Непал
      NR:Науру
      NU:Ниуэ
      NZ:Жаңа Зеландия
      OM:Оман
      PA:Панама
      PE:Перу
      PF:Француз Полинезиясы
      PG:Папуа — Жаңа Гвинея
      PH:Филиппин аралдары
      PK:Пәкістан
      PL:Польша
      PM:Сен-Пьер және Микелон
      PN:Питкэрн аралдары
      PR:Пуэрто-Рико
      PS:Палестина аймақтары
      PT:Португалия
      PW:Палау
      PY:Парагвай
      QA:Катар
      QO:Сыртқы Океания
      RE:Реюньон
      RO:Румыния
      RS:Сербия
      RU:Ресей
      RW:Руанда
      SA:Сауд Арабиясы
      SB:Соломон аралдары
      SC:Сейшель аралдары
      SD:Судан
      SE:Швеция
      SG:Сингапур
      SH:Әулие Елена аралы
      SI:Словения
      SJ:Шпицберген және Ян-Майен
      SK:Словакия
      SL:Сьерра-Леоне
      SM:Сан-Марино
      SN:Сенегал
      SO:Сомали
      SR:Суринам
      SS:Оңтүстік Судан
      ST:Сан-Томе және Принсипи
      SV:Сальвадор
      SX:Синт-Мартен
      SY:Сирия
      SZ:Эсватини
      TA:Тристан-да-Кунья
      TC:Теркс және Кайкос аралдары
      TD:Чад
      TF:Францияның оңтүстік аймақтары
      TG:Того
      TH:Таиланд
      TJ:Тәжікстан
      TK:Токелау
      TL:Тимор-Лесте
      TM:Түрікменстан
      TN:Тунис
      TO:Тонга
      TR:Түркия
      TT:Тринидад және Тобаго
      TV:Тувалу
      TW:Тайвань
      TZ:Танзания
      UA:Украина
      UG:Уганда
      UM:АҚШ-тың сыртқы кіші аралдары
      UN:Біріккен Ұлттар Ұйымы
      US:Америка Құрама Штаттары
      UY:Уругвай
      UZ:Өзбекстан
      VA:Ватикан
      VC:Сент-Винсент және Гренадин аралдары
      VE:Венесуэла
      VG:Британдық Виргин аралдары
      VI:АҚШ-тың Виргин аралдары
      VN:Вьетнам
      VU:Вануату
      WF:Уоллис және Футуна
      WS:Самоа
      XA:жалған акцент
      XB:жалған Bidi
      XK:Косово
      YE:Йемен
      YT:Майотта
      ZA:Оңтүстік Африка
      ZM:Замбия
      ZW:Зимбабве
      ZZ:Белгісіз аймақ
      """.trimIndent() }

  val kk_Cyrl: String? = null

  val kk_KZ: String? = null

  val kkj: String by lazy { """
      CM:Kamɛrun
      """.trimIndent() }

  val kl: String by lazy { """
      GL:Kalaallit Nunaat
      """.trimIndent() }

  val kln: String by lazy { """
      AD:Emetab Andorra
      AE:Emetab kibagenge nebo arabuk
      AF:Emetab Afghanistan
      AG:Emetab Antigua ak Barbuda
      AI:Emetab Anguilla
      AL:Emetab Albania
      AM:Emetab Armenia
      AO:Emetab Angola
      AR:Emetab Argentina
      AS:Emetab American Samoa
      AT:Emetab Austria
      AU:Emetab Australia
      AW:Emetab Aruba
      AZ:Emetab Azerbaijan
      BA:Emetab Bosnia ak Herzegovina
      BB:Emetab Barbados
      BD:Emetab Bangladesh
      BE:Emetab Belgium
      BF:Emetab Burkina Faso
      BG:Emetab Bulgaria
      BH:Emetab Bahrain
      BI:Emetab Burundi
      BJ:Emetab Benin
      BM:Emetab Bermuda
      BN:Emetab Brunei
      BO:Emetab Bolivia
      BR:Emetab Brazil
      BS:Emetab Bahamas
      BT:Emetab Bhutan
      BW:Emetab Botswana
      BY:Emetab Belarus
      BZ:Emetab Belize
      CA:Emetab Canada
      CD:Emetab Congo - Kinshasa
      CF:Emetab Afrika nebo Kwen
      CG:Emetab Congo - Brazzaville
      CH:Emetab Switzerland
      CI:Emetab Côte d’Ivoire
      CK:Ikwembeyotab Cook
      CL:Emetab Chile
      CM:Emetab Cameroon
      CN:Emetab China
      CO:Emetab Colombia
      CR:Emetab Costa Rica
      CU:Emetab Cuba
      CV:Ikwembeyotab Cape Verde
      CY:Emetab Cyprus
      CZ:Emetab Czech Republic
      DE:Emetab Geruman
      DJ:Emetab Djibouti
      DK:Emetab Denmark
      DM:Emetab Dominica
      DO:Emetab Dominican Republic
      DZ:Emetab Algeria
      EC:Emetab Ecuador
      EE:Emetab Estonia
      EG:Emetab Misiri
      ER:Emetab Eritrea
      ES:Emetab Spain
      ET:Emetab Ethiopia
      FI:Emetab Finland
      FJ:Emetab Fiji
      FK:Ikwembeyotab Falkland
      FM:Emetab Micronesia
      FR:Emetab France
      GA:Emetab Gabon
      GB:Emetab Kibagenge nebo Uingereza
      GD:Emetab Grenada
      GE:Emetab Georgia
      GF:Emetab Guiana nebo Ufaransa
      GH:Emetab Ghana
      GI:Emetab Gibraltar
      GL:Emetab Greenland
      GM:Emetab Gambia
      GN:Emetab Guinea
      GP:Emetab Guadeloupe
      GQ:Emetab Equatorial Guinea
      GR:Emetab Greece
      GT:Emetab Guatemala
      GU:Emetab Guam
      GW:Emetab Guinea-Bissau
      GY:Emetab Guyana
      HN:Emetab Honduras
      HR:Emetab Croatia
      HT:Emetab Haiti
      HU:Emetab Hungary
      ID:Emetab Indonesia
      IE:Emetab Ireland
      IL:Emetab Israel
      IN:Emetab India
      IQ:Emetab Iraq
      IR:Emetab Iran
      IS:Emetab Iceland
      IT:Emetab Italy
      JM:Emetab Jamaica
      JO:Emetab Jordan
      JP:Emetab Japan
      KE:Emetab Kenya
      KG:Emetab Kyrgyzstan
      KH:Emetab Cambodia
      KI:Emetab Kiribati
      KM:Emetab Comoros
      KN:Emetab Saint Kitts ak Nevis
      KP:Emetab Korea nebo murot katam
      KR:Emetab korea nebo murot tai
      KW:Emetab Kuwait
      KY:Ikwembeyotab Cayman
      KZ:Emetab Kazakhstan
      LA:Emetab Laos
      LB:Emetab Lebanon
      LC:Emetab Lucia Ne
      LI:Emetab Liechtenstein
      LK:Emetab Sri Lanka
      LR:Emetab Liberia
      LS:Emetab Lesotho
      LT:Emetab Lithuania
      LU:Emetab Luxembourg
      LV:Emetab Latvia
      LY:Emetab Libya
      MA:Emetab Morocco
      MC:Emetab Monaco
      MD:Emetab Moldova
      MG:Emetab Madagascar
      MH:Ikwembeiyotab Marshall
      ML:Emetab Mali
      MM:Emetab Myanmar
      MN:Emetab Mongolia
      MP:Ikwembeiyotab Mariana nebo murot katam
      MQ:Emetab Martinique
      MR:Emetab Mauritania
      MS:Emetab Montserrat
      MT:Emetab Malta
      MU:Emetab Mauritius
      MV:Emetab Maldives
      MW:Emetab Malawi
      MX:Emetab Mexico
      MY:Emetab Malaysia
      MZ:Emetab Mozambique
      NA:Emetab Namibia
      NC:Emetab New Caledonia
      NE:Emetab niger
      NF:Ikwembeiyotab Norfork
      NG:Emetab Nigeria
      NI:Emetab Nicaragua
      NL:Emetab Holand
      NO:Emetab Norway
      NP:Emetab Nepal
      NR:Emetab Nauru
      NU:Emetab Niue
      NZ:Emetab New Zealand
      OM:Emetab Oman
      PA:Emetab Panama
      PE:Emetab Peru
      PF:Emetab Polynesia nebo ufaransa
      PG:Emetab Papua New Guinea
      PH:Emetab Philippines
      PK:Emetab Pakistan
      PL:Emetab Poland
      PM:Emetab Peter Ne titil ak Miquelon
      PN:Emetab Pitcairn
      PR:Emetab Puerto Rico
      PS:Emetab Palestine
      PT:Emetab Portugal
      PW:Emetab Palau
      PY:Emetab Paraguay
      QA:Emetab Qatar
      RE:Emetab Réunion
      RO:Emetab Romania
      RU:Emetab Russia
      RW:Emetab Rwanda
      SA:Emetab Saudi Arabia
      SB:Ikwembeiyotab Solomon
      SC:Emetab Seychelles
      SD:Emetab Sudan
      SE:Emetab Sweden
      SG:Emetab Singapore
      SH:Emetab Helena Ne tilil
      SI:Emetab Slovenia
      SK:Emetab Slovakia
      SL:Emetab Sierra Leone
      SM:Emetab San Marino
      SN:Emetab Senegal
      SO:Emetab Somalia
      SR:Emetab Suriname
      ST:Emetab São Tomé and Príncipe
      SV:Emetab El Salvador
      SY:Emetab Syria
      SZ:Emetab Swaziland
      TC:Ikwembeiyotab Turks ak Caicos
      TD:Emetab Chad
      TG:Emetab Togo
      TH:Emetab Thailand
      TJ:Emetab Tajikistan
      TK:Emetab Tokelau
      TL:Emetab Timor nebo Murot tai
      TM:Emetab Turkmenistan
      TN:Emetab Tunisia
      TO:Emetab Tonga
      TR:Emetab Turkey
      TT:Emetab Trinidad ak Tobago
      TV:Emetab Tuvalu
      TW:Emetab Taiwan
      TZ:Emetab Tanzania
      UA:Emetab Ukrainie
      UG:Emetab Uganda
      US:Emetab amerika
      UY:Emetab Uruguay
      UZ:Emetab Uzibekistani
      VA:Emetab Vatican
      VC:Emetab Vincent netilil ak Grenadines
      VE:Emetab Venezuela
      VG:Ikwembeyotab British Virgin
      VI:Ikwemweiyotab Amerika
      VN:Emetab Vietnam
      VU:Emetab Vanuatu
      WF:Emetab Walis ak Futuna
      WS:Emetab Samoa
      YE:Emetab Yemen
      YT:Emetab Mayotte
      ZA:Emetab Afrika nebo Murot tai
      ZM:Emetab Zambia
      ZW:Emetab Zimbabwe
      """.trimIndent() }

  val km: String by lazy { """
      001:ពិភពលោក
      002:អាហ្វ្រិក
      003:អាមេរិក​ខាង​ជើង
      005:អាមេរិក​ខាង​ត្បូង
      009:អូសេអានី
      011:អាហ្វ្រិក​ខាង​លិច
      013:អាមេរិក​កណ្ដាល
      014:អាហ្វ្រិកខាងកើត
      015:អាហ្វ្រិក​ខាង​ជើង
      017:អាហ្វ្រិក​កណ្តាល
      018:អាហ្វ្រិកភាគខាងត្បូង
      019:អាមេរិក
      021:អាមេរិក​ភាគ​ខាង​ជើង
      029:ការ៉ាប៊ីន
      030:អាស៊ី​ខាង​កើត
      034:អាស៊ី​ខាង​ត្បូង
      035:អាស៊ីអាគ្នេយ៍
      039:អឺរ៉ុប​ខាង​ត្បូង
      053:អូស្ត្រាឡាស៊ី
      054:មេឡាណេស៊ី
      057:តំបន់​មីក្រូណេស៊ី
      061:ប៉ូលីណេស៊ី
      142:អាស៊ី
      143:អាស៊ី​កណ្ដាល
      145:អាស៊ី​ខាង​លិច
      150:អឺរ៉ុប
      151:អឺរ៉ុប​ខាង​កើត
      154:អឺរ៉ុប​ខាង​ជើង
      155:អឺរ៉ុប​ខាង​លិច
      202:អនុតំបន់សាហារ៉ាអាហ្វ្រិក
      419:អាមេរិក​ឡាទីន
      AC:កោះ​អាសេនសិន
      AD:អង់ដូរ៉ា
      AE:អេមីរ៉ាត​អារ៉ាប់​រួម
      AF:អាហ្វហ្កានីស្ថាន
      AG:អង់ទីហ្គា និង បាប៊ុយដា
      AI:អង់ហ្គីឡា
      AL:អាល់បានី
      AM:អាមេនី
      AO:អង់ហ្គោឡា
      AQ:អង់តាក់ទិក
      AR:អាហ្សង់ទីន
      AS:សាម័រ អាមេរិកាំង
      AT:អូទ្រីស
      AU:អូស្ត្រាលី
      AW:អារូបា
      AX:កោះ​អាឡង់
      AZ:អាស៊ែបៃហ្សង់
      BA:បូស្ន៊ី និងហឺហ្ស៊ីហ្គូវីណា
      BB:បាបាដុស
      BD:បង់ក្លាដែស
      BE:បែលហ្ស៊ិក
      BF:បួគីណាហ្វាសូ
      BG:ប៊ុលហ្ការី
      BH:បារ៉ែន
      BI:ប៊ូរុនឌី
      BJ:បេណាំង
      BL:សាំង​បាថេឡេមី
      BM:ប៊ឺមុយដា
      BN:ព្រុយណេ
      BO:បូលីវី
      BQ:ហូឡង់ ការ៉ាប៊ីន
      BR:ប្រេស៊ីល
      BS:បាហាម៉ា
      BT:ប៊ូតង់
      BV:កោះ​ប៊ូវ៉េត
      BW:បុតស្វាណា
      BY:បេឡារុស
      BZ:បេលី
      CA:កាណាដា
      CC:កោះ​កូកូស (គីលីង)
      CD:កុងហ្គោ- គីនស្ហាសា
      CF:សាធារណរដ្ឋអាហ្វ្រិកកណ្ដាល
      CG:កុងហ្គោ - ប្រាហ្សាវីល
      CH:ស្វ៊ីស
      CI:កូតឌីវ័រ
      CK:កោះ​ខូក
      CL:ស៊ីលី
      CM:កាមេរូន
      CN:ចិន
      CO:កូឡុំប៊ី
      CP:កោះ​ឃ្លីភឺតុន
      CR:កូស្តារីកា
      CU:គុយបា
      CV:កាប់វែរ
      CW:កូរ៉ាកៅ
      CX:កោះ​គ្រីស្មាស
      CY:ស៊ីប
      CZ:ឆែក
      DE:អាល្លឺម៉ង់
      DG:ឌៀហ្គោហ្គាស៊ី
      DJ:ជីប៊ូទី
      DK:ដាណឺម៉ាក
      DM:ដូមីនីក
      DO:សាធារណរដ្ឋ​ដូមីនីក
      DZ:អាល់ហ្សេរី
      EA:ជឺតា និង​ម៉េលីឡា
      EC:អេក្វាទ័រ
      EE:អេស្តូនី
      EG:អេហ្ស៊ីប
      EH:សាហារ៉ាខាងលិច
      ER:អេរីត្រេ
      ES:អេស្ប៉ាញ
      ET:អេត្យូពី
      EU:សហភាព​អឺរ៉ុប
      EZ:តំបន់ចាយលុយអឺរ៉ូ
      FI:ហ្វាំងឡង់
      FJ:ហ្វីជី
      FK:កោះ​ហ្វក់ឡែន
      FM:មីក្រូណេស៊ី
      FO:កោះ​ហ្វារ៉ូ
      FR:បារាំង
      GA:ហ្គាបុង
      GB:ចក្រភព​អង់គ្លេស
      GD:ហ្គ្រើណាដ
      GE:ហ្សកហ្ស៊ី
      GF:ហ្គីអាណា បារាំង
      GG:ហ្គេនស៊ី
      GH:ហ្គាណា
      GI:ហ្ស៊ីប្រាល់តា
      GL:ហ្គ្រោអង់ឡង់
      GM:ហ្គំប៊ី
      GN:ហ្គីណេ
      GP:ហ្គោដឺឡុប
      GQ:ហ្គីណេអេក្វាទ័រ
      GR:ក្រិក
      GS:កោះ​ហ្សកហ្ស៊ី​ខាងត្បូង និង សង់វិច​ខាងត្បូង
      GT:ក្វាតេម៉ាឡា
      GU:ហ្គាំ
      GW:ហ្គីណេប៊ីស្សូ
      GY:ហ្គីយ៉ាន
      HK:ហុងកុង តំបន់រដ្ឋបាលពិសេសចិន
      HM:កោះ​ហឺដនិង​ម៉ាក់ដូណាល់
      HN:ហុងឌូរ៉ាស
      HR:ក្រូអាស៊ី
      HT:ហៃទី
      HU:ហុងគ្រី
      IC:កោះ​កាណារី
      ID:ឥណ្ឌូណេស៊ី
      IE:អៀរឡង់
      IL:អ៊ីស្រាអែល
      IM:អែលអុហ្វមែន
      IN:ឥណ្ឌា
      IO:ដែនដី​អង់គ្លេស​នៅ​មហា​សមុទ្រ​ឥណ្ឌា
      IQ:អ៊ីរ៉ាក់
      IR:អ៊ីរ៉ង់
      IS:អ៊ីស្លង់
      IT:អ៊ីតាលី
      JE:ជើស៊ី
      JM:ហ្សាម៉ាអ៊ីក
      JO:ហ៊្សកដានី
      JP:ជប៉ុន
      KE:កេនយ៉ា
      KG:កៀហ្ស៊ីស៊ីស្ថាន
      KH:កម្ពុជា
      KI:គិរីបាទី
      KM:កូម័រ
      KN:សាំង​គីត និង ណេវីស
      KP:កូរ៉េ​ខាង​ជើង
      KR:កូរ៉េ​ខាង​ត្បូង
      KW:កូវ៉ែត
      KY:កោះ​កៃម៉ង់
      KZ:កាហ្សាក់ស្ថាន
      LA:ឡាវ
      LB:លីបង់
      LC:សាំងលូស៊ី
      LI:លិចតិនស្ដាញ
      LK:ស្រីលង្កា
      LR:លីបេរីយ៉ា
      LS:ឡេសូតូ
      LT:លីទុយអានី
      LU:លុចសំបួ
      LV:ឡេតូនី
      LY:លីប៊ី
      MA:ម៉ារ៉ុក
      MC:ម៉ូណាកូ
      MD:ម៉ុលដាវី
      ME:ម៉ុងតេណេហ្គ្រោ
      MF:សាំង​ម៉ាទីន
      MG:ម៉ាដាហ្គាស្កា
      MH:កោះ​ម៉ាស់សល
      MK:ម៉ាសេដ្វានខាងជើង
      ML:ម៉ាលី
      MM:មីយ៉ាន់ម៉ា (ភូមា)
      MN:ម៉ុងហ្គោលី
      MO:ម៉ាកាវ តំបន់រដ្ឋបាលពិសេសចិន
      MP:កោះ​ម៉ារីណា​ខាង​ជើង
      MQ:ម៉ាទីនីក
      MR:ម៉ូរីតានី
      MS:ម៉ុងស៊ែរ៉ា
      MT:ម៉ាល់ត៍
      MU:ម៉ូរីស
      MV:ម៉ាល់ឌីវ
      MW:ម៉ាឡាវី
      MX:ម៉ិកស៊ិក
      MY:ម៉ាឡេស៊ី
      MZ:ម៉ូសំប៊ិក
      NA:ណាមីប៊ី
      NC:នូវែល​កាឡេដូនី
      NE:នីហ្សេ
      NF:កោះ​ណ័រហ្វក់
      NG:នីហ្សេរីយ៉ា
      NI:នីការ៉ាហ្គា
      NL:ហូឡង់
      NO:ន័រវែស
      NP:នេប៉ាល់
      NR:ណូរូ
      NU:ណៀ
      NZ:នូវែល​សេឡង់
      OM:អូម៉ង់
      PA:ប៉ាណាម៉ា
      PE:ប៉េរូ
      PF:ប៉ូលី​ណេស៊ី​បារាំង
      PG:ប៉ាពូអាស៊ី​នូវែលហ្គីណេ
      PH:ហ្វ៊ីលីពីន
      PK:ប៉ាគីស្ថាន
      PL:ប៉ូឡូញ
      PM:សង់ព្យែរ និង​មីគីឡុង
      PN:កោះ​ភីតកាន
      PR:ព័រតូរីកូ
      PS:ដែនដីប៉ាឡេស្ទីន
      PT:ព័រទុយហ្កាល់
      PW:ផៅឡូ
      PY:ប៉ារ៉ាហ្គាយ
      QA:កាតា
      QO:តំបន់ជាយអូសេអានី
      RE:រេអុយញ៉ុង
      RO:រូម៉ានី
      RS:សែប៊ី
      RU:រុស្ស៊ី
      RW:រវ៉ាន់ដា
      SA:អារ៉ាប៊ីសាអូឌីត
      SB:កោះ​សូឡូម៉ុង
      SC:សីស្ហែល
      SD:ស៊ូដង់
      SE:ស៊ុយអែត
      SG:សិង្ហបុរី
      SH:សង់​ហេឡេណា
      SI:ស្លូវេនី
      SJ:ស្វាលបាដ និង ហ្សង់ម៉ាយេន
      SK:ស្លូវ៉ាគី
      SL:សៀរ៉ាឡេអូន
      SM:សាន​ម៉ារីណូ
      SN:សេណេហ្គាល់
      SO:សូម៉ាលី
      SR:សូរីណាម
      SS:ស៊ូដង់​ខាង​ត្បូង
      ST:សៅតូម៉េ និង ប្រាំងស៊ីប
      SV:អែលសាល់វ៉ាឌ័រ
      SX:សីង​ម៉ាធីន
      SY:ស៊ីរី
      SZ:ស្វាស៊ីឡង់
      TA:ទ្រីស្តង់​ដា​ចូនហា
      TC:កោះ​ទួគ និង កៃកូស
      TD:ឆាដ
      TF:ដែនដី​បារាំង​នៅ​ភាគខាងត្បូង
      TG:តូហ្គោ
      TH:ថៃ
      TJ:តាហ្ស៊ីគីស្ថាន
      TK:តូខេឡៅ
      TL:ទីម័រលេស្តេ
      TM:តួកម៉េនីស្ថាន
      TN:ទុយនីស៊ី
      TO:តុងហ្គា
      TR:តួកគី
      TT:ទ្រីនីដាត និង​តូបាហ្គោ
      TV:ទូវ៉ាលូ
      TW:តៃវ៉ាន់
      TZ:តង់សានី
      UA:អ៊ុយក្រែន
      UG:អ៊ូហ្គង់ដា
      UM:កោះ​អៅឡាយីង​អាមេរិក
      UN:អង្គការសហប្រជាជាតិ
      US:សហរដ្ឋអាមេរិក
      UY:អ៊ុយរូហ្គាយ
      UZ:អ៊ូសបេគីស្ថាន
      VA:បុរី​វ៉ាទីកង់
      VC:សាំង​វ៉ាំងសង់ និង ហ្គ្រេណាឌីន
      VE:វ៉េណេស៊ុយអេឡា
      VG:កោះ​វឺជិន​ចក្រភព​អង់គ្លេស
      VI:កោះ​វឺជីន​អាមេរិក
      VN:វៀតណាម
      VU:វ៉ានូទូ
      WF:វ៉ាលីស និង​ហ្វូទូណា
      WS:សាម័រ
      XA:Pseudo-Accents
      XB:Pseudo-Bidi
      XK:កូសូវ៉ូ
      YE:យេម៉ែន
      YT:ម៉ាយុត
      ZA:អាហ្វ្រិកខាងត្បូង
      ZM:សំប៊ី
      ZW:ស៊ីមបាវ៉េ
      ZZ:តំបន់មិនស្គាល់
      """.trimIndent() }

  val kn: String by lazy { """
      001:ಪ್ರಪಂಚ
      002:ಆಫ್ರಿಕಾ
      003:ಉತ್ತರ ಅಮೇರಿಕಾ
      005:ದಕ್ಷಿಣ ಅಮೇರಿಕಾ
      009:ಓಶಿಯೇನಿಯಾ
      011:ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾ
      013:ಮಧ್ಯ ಅಮೇರಿಕಾ
      014:ಪೂರ್ವ ಆಫ್ರಿಕಾ
      015:ಉತ್ತರ ಆಫ್ರಿಕಾ
      017:ಮಧ್ಯ ಆಫ್ರಿಕಾ
      018:ಆಫ್ರಿಕಾದ ದಕ್ಷಿಣ ಭಾಗ
      019:ಅಮೆರಿಕಾಸ್
      021:ಅಮೇರಿಕಾದ ಉತ್ತರ ಭಾಗ
      029:ಕೆರೀಬಿಯನ್
      030:ಪೂರ್ವ ಏಷ್ಯಾ
      034:ದಕ್ಷಿಣ ಏಷ್ಯಾ
      035:ಆಗ್ನೇಯ ಏಷ್ಯಾ
      039:ದಕ್ಷಿಣ ಯೂರೋಪ್
      053:ಆಸ್ಟ್ರೇಲೇಷ್ಯಾ
      054:ಮೆಲನೇಷಿಯಾ
      057:ಮೈಕ್ರೋನೇಶಿಯನ್ ಪ್ರದೇಶ
      061:ಪಾಲಿನೇಷ್ಯಾ
      142:ಏಷ್ಯಾ
      143:ಮಧ್ಯ ಏಷ್ಯಾ
      145:ಪಶ್ಚಿಮ ಏಷ್ಯಾ
      150:ಯೂರೋಪ್
      151:ಪೂರ್ವ ಯೂರೋಪ್
      154:ಉತ್ತರ ಯೂರೋಪ್
      155:ಪಶ್ಚಿಮ ಯೂರೋಪ್
      202:ಉಪ-ಸಹಾರನ್ ಆಫ್ರಿಕಾ
      419:ಲ್ಯಾಟಿನ್ ಅಮೇರಿಕಾ
      AC:ಅಸೆನ್ಶನ್ ದ್ವೀಪ
      AD:ಅಂಡೋರಾ
      AE:ಯುನೈಟೆಡ್ ಅರಬ್ ಎಮಿರೇಟ್ಸ್
      AF:ಅಫಘಾನಿಸ್ಥಾನ
      AG:ಆಂಟಿಗುವಾ ಮತ್ತು ಬರ್ಬುಡಾ
      AI:ಆಂಗ್ವಿಲ್ಲಾ
      AL:ಅಲ್ಬೇನಿಯಾ
      AM:ಆರ್ಮೇನಿಯ
      AO:ಅಂಗೋಲಾ
      AQ:ಅಂಟಾರ್ಟಿಕಾ
      AR:ಅರ್ಜೆಂಟಿನಾ
      AS:ಅಮೇರಿಕನ್ ಸಮೋವಾ
      AT:ಆಸ್ಟ್ರಿಯಾ
      AU:ಆಸ್ಟ್ರೇಲಿಯಾ
      AW:ಅರುಬಾ
      AX:ಆಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು
      AZ:ಅಜರ್ಬೈಜಾನ್
      BA:ಬೋಸ್ನಿಯಾ ಮತ್ತು ಹರ್ಜೆಗೋವಿನಾ
      BB:ಬಾರ್ಬಡೋಸ್
      BD:ಬಾಂಗ್ಲಾದೇಶ
      BE:ಬೆಲ್ಜಿಯಮ್
      BF:ಬುರ್ಕಿನಾ ಫಾಸೊ
      BG:ಬಲ್ಗೇರಿಯಾ
      BH:ಬಹ್ರೇನ್
      BI:ಬುರುಂಡಿ
      BJ:ಬೆನಿನ್
      BL:ಸೇಂಟ್ ಬಾರ್ಥೆಲೆಮಿ
      BM:ಬರ್ಮುಡಾ
      BN:ಬ್ರೂನಿ
      BO:ಬೊಲಿವಿಯಾ
      BQ:ಕೆರೀಬಿಯನ್ ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್
      BR:ಬ್ರೆಜಿಲ್
      BS:ಬಹಾಮಾಸ್
      BT:ಭೂತಾನ್
      BV:ಬೋವೆಟ್ ದ್ವೀಪ
      BW:ಬೋಟ್ಸ್‌ವಾನಾ
      BY:ಬೆಲಾರಸ್
      BZ:ಬೆಲಿಜ್
      CA:ಕೆನಡಾ
      CC:ಕೊಕೊಸ್ (ಕೀಲಿಂಗ್) ದ್ವೀಪಗಳು
      CD:ಕಾಂಗೋ - ಕಿನ್ಶಾಸಾ
      CF:ಮಧ್ಯ ಆಫ್ರಿಕಾ ಗಣರಾಜ್ಯ
      CG:ಕಾಂಗೋ - ಬ್ರಾಜಾವಿಲ್ಲೇ
      CH:ಸ್ವಿಟ್ಜರ್ಲ್ಯಾಂಡ್
      CI:ಕೋತ್ ದ್‘ಇವಾರ್
      CK:ಕುಕ್ ದ್ವೀಪಗಳು
      CL:ಚಿಲಿ
      CM:ಕ್ಯಾಮರೂನ್
      CN:ಚೀನಾ
      CO:ಕೊಲಂಬಿಯಾ
      CP:ಕ್ಲಿಪ್ಪರ್‌ಟಾನ್ ದ್ವೀಪ
      CR:ಕೊಸ್ಟಾ ರಿಕಾ
      CU:ಕ್ಯೂಬಾ
      CV:ಕೇಪ್ ವರ್ಡೆ
      CW:ಕುರಾಕಾವ್
      CX:ಕ್ರಿಸ್ಮಸ್ ದ್ವೀಪ
      CY:ಸೈಪ್ರಸ್
      CZ:ಝೆಕಿಯಾ
      DE:ಜರ್ಮನಿ
      DG:ಡೈಗೋ ಗಾರ್ಸಿಯ
      DJ:ಜಿಬೂಟಿ
      DK:ಡೆನ್ಮಾರ್ಕ್
      DM:ಡೊಮಿನಿಕಾ
      DO:ಡೊಮೆನಿಕನ್ ರಿಪಬ್ಲಿಕ್
      DZ:ಅಲ್ಜೀರಿಯ
      EA:ಸೆಯುಟಾ ಹಾಗೂ ಮೆಲಿಲ್ಲಾ
      EC:ಈಕ್ವೆಡಾರ್
      EE:ಎಸ್ಟೋನಿಯಾ
      EG:ಈಜಿಪ್ಟ್
      EH:ಪಶ್ಚಿಮ ಸಹಾರಾ
      ER:ಎರಿಟ್ರಿಯಾ
      ES:ಸ್ಪೇನ್
      ET:ಇಥಿಯೋಪಿಯಾ
      EU:ಯುರೋಪಿಯನ್ ಒಕ್ಕೂಟ
      EZ:ಯೂರೋಝೋನ್‌
      FI:ಫಿನ್‌ಲ್ಯಾಂಡ್
      FJ:ಫಿಜಿ
      FK:ಫಾಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು
      FM:ಮೈಕ್ರೋನೇಶಿಯಾ
      FO:ಫರೋ ದ್ವೀಪಗಳು
      FR:ಫ್ರಾನ್ಸ್
      GA:ಗೆಬೊನ್
      GB:ಯುನೈಟೆಡ್ ಕಿಂಗ್‌ಡಮ್
      GD:ಗ್ರೆನೆಡಾ
      GE:ಜಾರ್ಜಿಯಾ
      GF:ಫ್ರೆಂಚ್ ಗಯಾನಾ
      GG:ಗುರ್ನ್‌ಸೆ
      GH:ಘಾನಾ
      GI:ಗಿಬ್ರಾಲ್ಟರ್
      GL:ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್
      GM:ಗ್ಯಾಂಬಿಯಾ
      GN:ಗಿನಿ
      GP:ಗುಡೆಲೋಪ್
      GQ:ಈಕ್ವೆಟೋರಿಯಲ್ ಗಿನಿ
      GR:ಗ್ರೀಸ್
      GS:ದಕ್ಷಿಣ ಜಾರ್ಜಿಯಾ ಮತ್ತು ದಕ್ಷಿಣ ಸ್ಯಾಂಡ್‍ವಿಚ್ ದ್ವೀಪಗಳು
      GT:ಗ್ವಾಟೆಮಾಲಾ
      GU:ಗುವಾಮ್
      GW:ಗಿನಿ-ಬಿಸ್ಸಾವ್
      GY:ಗಯಾನಾ
      HK:ಹಾಂಗ್ ಕಾಂಗ್ ಎಸ್ಎಆರ್ ಚೈನಾ
      HM:ಹರ್ಡ್ ಮತ್ತು ಮ್ಯಾಕ್‌ಡೋನಾಲ್ಡ್ ದ್ವೀಪಗಳು
      HN:ಹೊಂಡುರಾಸ್
      HR:ಕ್ರೊಯೇಷಿಯಾ
      HT:ಹೈಟಿ
      HU:ಹಂಗೇರಿ
      IC:ಕ್ಯಾನರಿ ದ್ವೀಪಗಳು
      ID:ಇಂಡೋನೇಶಿಯಾ
      IE:ಐರ್ಲೆಂಡ್
      IL:ಇಸ್ರೇಲ್
      IM:ಐಲ್ ಆಫ್ ಮ್ಯಾನ್
      IN:ಭಾರತ
      IO:ಬ್ರಿಟೀಷ್ ಹಿಂದೂ ಮಹಾಸಾಗರದ ಪ್ರದೇಶ
      IQ:ಇರಾಕ್
      IR:ಇರಾನ್
      IS:ಐಸ್‌ಲ್ಯಾಂಡ್
      IT:ಇಟಲಿ
      JE:ಜೆರ್ಸಿ
      JM:ಜಮೈಕಾ
      JO:ಜೋರ್ಡಾನ್
      JP:ಜಪಾನ್
      KE:ಕೀನ್ಯಾ
      KG:ಕಿರ್ಗಿಸ್ಥಾನ್
      KH:ಕಾಂಬೋಡಿಯಾ
      KI:ಕಿರಿಬಾಟಿ
      KM:ಕೊಮೊರೊಸ್
      KN:ಸೇಂಟ್ ಕಿಟ್ಸ್ ಮತ್ತು ನೆವಿಸ್
      KP:ಉತ್ತರ ಕೊರಿಯಾ
      KR:ದಕ್ಷಿಣ ಕೊರಿಯಾ
      KW:ಕುವೈತ್
      KY:ಕೇಮನ್ ದ್ವೀಪಗಳು
      KZ:ಕಝಾಕಿಸ್ಥಾನ್
      LA:ಲಾವೋಸ್
      LB:ಲೆಬನಾನ್
      LC:ಸೇಂಟ್ ಲೂಸಿಯಾ
      LI:ಲಿಚೆನ್‌ಸ್ಟೈನ್
      LK:ಶ್ರೀಲಂಕಾ
      LR:ಲಿಬೇರಿಯಾ
      LS:ಲೆಸೊಥೊ
      LT:ಲಿಥುವೇನಿಯಾ
      LU:ಲಕ್ಸೆಂಬರ್ಗ್
      LV:ಲಾಟ್ವಿಯಾ
      LY:ಲಿಬಿಯಾ
      MA:ಮೊರಾಕ್ಕೊ
      MC:ಮೊನಾಕೊ
      MD:ಮೊಲ್ಡೋವಾ
      ME:ಮೊಂಟೆನೆಗ್ರೋ
      MF:ಸೇಂಟ್ ಮಾರ್ಟಿನ್
      MG:ಮಡಗಾಸ್ಕರ್
      MH:ಮಾರ್ಷಲ್ ದ್ವೀಪಗಳು
      MK:ಉತ್ತರ ಮ್ಯಾಸಿಡೋನಿಯಾ
      ML:ಮಾಲಿ
      MM:ಮಯನ್ಮಾರ್ (ಬರ್ಮಾ)
      MN:ಮಂಗೋಲಿಯಾ
      MO:ಮಕಾವು ಎಸ್ಎಆರ್ ಚೈನಾ
      MP:ಉತ್ತರ ಮರಿಯಾನಾ ದ್ವೀಪಗಳು
      MQ:ಮಾರ್ಟಿನಿಕ್
      MR:ಮಾರಿಟೇನಿಯಾ
      MS:ಮಾಂಟ್‌ಸೆರಟ್
      MT:ಮಾಲ್ಟಾ
      MU:ಮಾರಿಷಸ್
      MV:ಮಾಲ್ಡೀವ್ಸ್
      MW:ಮಲಾವಿ
      MX:ಮೆಕ್ಸಿಕೊ
      MY:ಮಲೇಶಿಯಾ
      MZ:ಮೊಜಾಂಬಿಕ್
      NA:ನಮೀಬಿಯಾ
      NC:ನ್ಯೂ ಕ್ಯಾಲಿಡೋನಿಯಾ
      NE:ನೈಜರ್
      NF:ನಾರ್ಫೋಕ್ ದ್ವೀಪ
      NG:ನೈಜೀರಿಯಾ
      NI:ನಿಕಾರಾಗುವಾ
      NL:ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್
      NO:ನಾರ್ವೆ
      NP:ನೇಪಾಳ
      NR:ನೌರು
      NU:ನಿಯು
      NZ:ನ್ಯೂಜಿಲೆಂಡ್
      OM:ಓಮನ್
      PA:ಪನಾಮಾ
      PE:ಪೆರು
      PF:ಫ್ರೆಂಚ್ ಪಾಲಿನೇಷ್ಯಾ
      PG:ಪಪುವಾ ನ್ಯೂಗಿನಿಯಾ
      PH:ಫಿಲಿಫೈನ್ಸ್
      PK:ಪಾಕಿಸ್ತಾನ
      PL:ಪೋಲ್ಯಾಂಡ್
      PM:ಸೇಂಟ್ ಪಿಯರ್ ಮತ್ತು ಮಿಕ್ವೆಲನ್
      PN:ಪಿಟ್‌ಕೈರ್ನ್ ದ್ವೀಪಗಳು
      PR:ಪ್ಯೂರ್ಟೋ ರಿಕೊ
      PS:ಪ್ಯಾಲೇಸ್ಟೇನಿಯನ್ ಪ್ರದೇಶಗಳು
      PT:ಪೋರ್ಚುಗಲ್
      PW:ಪಲಾವು
      PY:ಪರಾಗ್ವೇ
      QA:ಖತಾರ್
      QO:ಔಟ್ ಲೈಯಿಂಗ್ ಓಷಿಯಾನಿಯಾ
      RE:ರಿಯೂನಿಯನ್
      RO:ರೊಮೇನಿಯಾ
      RS:ಸೆರ್ಬಿಯಾ
      RU:ರಷ್ಯಾ
      RW:ರುವಾಂಡಾ
      SA:ಸೌದಿ ಅರೇಬಿಯಾ
      SB:ಸಾಲೊಮನ್ ದ್ವೀಪಗಳು
      SC:ಸೀಶೆಲ್ಲೆಸ್
      SD:ಸುಡಾನ್
      SE:ಸ್ವೀಡನ್
      SG:ಸಿಂಗಪುರ್
      SH:ಸೇಂಟ್ ಹೆಲೆನಾ
      SI:ಸ್ಲೋವೇನಿಯಾ
      SJ:ಸ್ವಾಲ್ಬಾರ್ಡ್ ಮತ್ತು ಜಾನ್ ಮೆಯನ್
      SK:ಸ್ಲೊವಾಕಿಯಾ
      SL:ಸಿಯೆರ್ರಾ ಲಿಯೋನ್
      SM:ಸ್ಯಾನ್ ಮೆರಿನೋ
      SN:ಸೆನೆಗಲ್
      SO:ಸೊಮಾಲಿಯಾ
      SR:ಸುರಿನಾಮ್
      SS:ದಕ್ಷಿಣ ಸುಡಾನ್
      ST:ಸಾವೋ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪಿ
      SV:ಎಲ್ ಸಾಲ್ವೇಡಾರ್
      SX:ಸಿಂಟ್ ಮಾರ್ಟೆನ್
      SY:ಸಿರಿಯಾ
      SZ:ಎಸ್ವಾಟಿನಿ
      TA:ಟ್ರಿಸ್ತನ್ ಡಾ ಕುನ್ಹಾ
      TC:ಟರ್ಕ್ಸ್ ಮತ್ತು ಕೈಕೋಸ್ ದ್ವೀಪಗಳು
      TD:ಚಾದ್
      TF:ಫ್ರೆಂಚ್ ದಕ್ಷಿಣ ಪ್ರದೇಶಗಳು
      TG:ಟೋಗೋ
      TH:ಥೈಲ್ಯಾಂಡ್
      TJ:ತಜಿಕಿಸ್ತಾನ್
      TK:ಟೊಕೆಲಾವ್
      TL:ಟಿಮೋರ್ ಲೆಸ್ಟೆ
      TM:ತುರ್ಕಮೆನಿಸ್ತಾನ್
      TN:ಟುನೀಶಿಯ
      TO:ಟೊಂಗಾ
      TR:ತುರ್ಕಿಯೆ
      TT:ಟ್ರಿನಿಡಾಡ್ ಮತ್ತು ಟೊಬಾಗೊ
      TV:ಟುವಾಲು
      TW:ತೈವಾನ್
      TZ:ತಾಂಜೇನಿಯಾ
      UA:ಉಕ್ರೈನ್
      UG:ಉಗಾಂಡಾ
      UM:ಯುಎಸ್‌ ಔಟ್‌ಲೇಯಿಂಗ್ ದ್ವೀಪಗಳು
      UN:ಸಂಯುಕ್ತ ಸಂಸ್ಥಾನಗಳು
      US:ಯುನೈಟೆಡ್ ಸ್ಟೇಟ್ಸ್
      UY:ಉರುಗ್ವೆ
      UZ:ಉಜ್ಬೇಕಿಸ್ಥಾನ್
      VA:ವ್ಯಾಟಿಕನ್ ಸಿಟಿ
      VC:ಸೇಂಟ್. ವಿನ್ಸೆಂಟ್ ಮತ್ತು ಗ್ರೆನೆಡೈನ್ಸ್
      VE:ವೆನೆಜುವೆಲಾ
      VG:ಬ್ರಿಟಿಷ್ ವರ್ಜಿನ್ ದ್ವೀಪಗಳು
      VI:ಯು.ಎಸ್. ವರ್ಜಿನ್ ದ್ವೀಪಗಳು
      VN:ವಿಯೆಟ್ನಾಮ್
      VU:ವನೌಟು
      WF:ವಾಲಿಸ್ ಮತ್ತು ಫುಟುನಾ
      WS:ಸಮೋವಾ
      XA:ಸ್ಯುಡೊ ಉಚ್ಛಾರಣೆಗಳು
      XB:ಸ್ಯುಡೊ-ಬಿಡಿ
      XK:ಕೊಸೊವೊ
      YE:ಯೆಮನ್
      YT:ಮಯೊಟ್ಟೆ
      ZA:ದಕ್ಷಿಣ ಆಫ್ರಿಕಾ
      ZM:ಜಾಂಬಿಯ
      ZW:ಜಿಂಬಾಬ್ವೆ
      ZZ:ಅಜ್ಞಾತ ಪ್ರದೇಶ
      """.trimIndent() }

  val ko: String by lazy { """
      001:세계
      002:아프리카
      003:북아메리카
      005:남아메리카
      009:오세아니아
      011:서부 아프리카
      013:중앙 아메리카
      014:동부 아프리카
      015:북부 아프리카
      017:중부 아프리카
      018:남부 아프리카
      019:아메리카 대륙
      021:북부 아메리카
      029:카리브 제도
      030:동아시아
      034:남아시아
      035:동남아시아
      039:남유럽
      053:오스트랄라시아
      054:멜라네시아
      057:미크로네시아 지역
      061:폴리네시아
      142:아시아
      143:중앙 아시아
      145:서아시아
      150:유럽
      151:동유럽
      154:북유럽
      155:서유럽
      202:사하라 사막 이남 아프리카
      419:라틴 아메리카
      AC:어센션섬
      AD:안도라
      AE:아랍에미리트
      AF:아프가니스탄
      AG:앤티가 바부다
      AI:앵귈라
      AL:알바니아
      AM:아르메니아
      AO:앙골라
      AQ:남극 대륙
      AR:아르헨티나
      AS:아메리칸 사모아
      AT:오스트리아
      AU:오스트레일리아
      AW:아루바
      AX:올란드 제도
      AZ:아제르바이잔
      BA:보스니아 헤르체고비나
      BB:바베이도스
      BD:방글라데시
      BE:벨기에
      BF:부르키나파소
      BG:불가리아
      BH:바레인
      BI:부룬디
      BJ:베냉
      BL:생바르텔레미
      BM:버뮤다
      BN:브루나이
      BO:볼리비아
      BQ:네덜란드령 카리브
      BR:브라질
      BS:바하마
      BT:부탄
      BV:부베섬
      BW:보츠와나
      BY:벨라루스
      BZ:벨리즈
      CA:캐나다
      CC:코코스 제도
      CD:콩고-킨샤사
      CF:중앙 아프리카 공화국
      CG:콩고-브라자빌
      CH:스위스
      CI:코트디부아르
      CK:쿡 제도
      CL:칠레
      CM:카메룬
      CN:중국
      CO:콜롬비아
      CP:클리퍼턴섬
      CR:코스타리카
      CU:쿠바
      CV:카보베르데
      CW:퀴라소
      CX:크리스마스섬
      CY:키프로스
      CZ:체코
      DE:독일
      DG:디에고 가르시아
      DJ:지부티
      DK:덴마크
      DM:도미니카
      DO:도미니카 공화국
      DZ:알제리
      EA:세우타 및 멜리야
      EC:에콰도르
      EE:에스토니아
      EG:이집트
      EH:서사하라
      ER:에리트리아
      ES:스페인
      ET:에티오피아
      EU:유럽 연합
      EZ:유로존
      FI:핀란드
      FJ:피지
      FK:포클랜드 제도
      FM:미크로네시아
      FO:페로 제도
      FR:프랑스
      GA:가봉
      GB:영국
      GD:그레나다
      GE:조지아
      GF:프랑스령 기아나
      GG:건지
      GH:가나
      GI:지브롤터
      GL:그린란드
      GM:감비아
      GN:기니
      GP:과들루프
      GQ:적도 기니
      GR:그리스
      GS:사우스조지아 사우스샌드위치 제도
      GT:과테말라
      GU:괌
      GW:기니비사우
      GY:가이아나
      HK:홍콩(중국 특별행정구)
      HM:허드 맥도널드 제도
      HN:온두라스
      HR:크로아티아
      HT:아이티
      HU:헝가리
      IC:카나리아 제도
      ID:인도네시아
      IE:아일랜드
      IL:이스라엘
      IM:맨섬
      IN:인도
      IO:영국령 인도양 지역
      IQ:이라크
      IR:이란
      IS:아이슬란드
      IT:이탈리아
      JE:저지
      JM:자메이카
      JO:요르단
      JP:일본
      KE:케냐
      KG:키르기스스탄
      KH:캄보디아
      KI:키리바시
      KM:코모로
      KN:세인트키츠 네비스
      KP:북한
      KR:대한민국
      KW:쿠웨이트
      KY:케이맨 제도
      KZ:카자흐스탄
      LA:라오스
      LB:레바논
      LC:세인트루시아
      LI:리히텐슈타인
      LK:스리랑카
      LR:라이베리아
      LS:레소토
      LT:리투아니아
      LU:룩셈부르크
      LV:라트비아
      LY:리비아
      MA:모로코
      MC:모나코
      MD:몰도바
      ME:몬테네그로
      MF:생마르탱
      MG:마다가스카르
      MH:마셜 제도
      MK:북마케도니아
      ML:말리
      MM:미얀마
      MN:몽골
      MO:마카오(중국 특별행정구)
      MP:북마리아나제도
      MQ:마르티니크
      MR:모리타니
      MS:몬트세라트
      MT:몰타
      MU:모리셔스
      MV:몰디브
      MW:말라위
      MX:멕시코
      MY:말레이시아
      MZ:모잠비크
      NA:나미비아
      NC:뉴칼레도니아
      NE:니제르
      NF:노퍽섬
      NG:나이지리아
      NI:니카라과
      NL:네덜란드
      NO:노르웨이
      NP:네팔
      NR:나우루
      NU:니우에
      NZ:뉴질랜드
      OM:오만
      PA:파나마
      PE:페루
      PF:프랑스령 폴리네시아
      PG:파푸아뉴기니
      PH:필리핀
      PK:파키스탄
      PL:폴란드
      PM:생피에르 미클롱
      PN:핏케언 제도
      PR:푸에르토리코
      PS:팔레스타인 지구
      PT:포르투갈
      PW:팔라우
      PY:파라과이
      QA:카타르
      QO:오세아니아 외곽
      RE:레위니옹
      RO:루마니아
      RS:세르비아
      RU:러시아
      RW:르완다
      SA:사우디아라비아
      SB:솔로몬 제도
      SC:세이셸
      SD:수단
      SE:스웨덴
      SG:싱가포르
      SH:세인트헬레나
      SI:슬로베니아
      SJ:스발바르제도-얀마웬섬
      SK:슬로바키아
      SL:시에라리온
      SM:산마리노
      SN:세네갈
      SO:소말리아
      SR:수리남
      SS:남수단
      ST:상투메 프린시페
      SV:엘살바도르
      SX:신트마르턴
      SY:시리아
      SZ:에스와티니
      TA:트리스탄다쿠나
      TC:터크스 케이커스 제도
      TD:차드
      TF:프랑스령 남방 지역
      TG:토고
      TH:태국
      TJ:타지키스탄
      TK:토켈라우
      TL:동티모르
      TM:투르크메니스탄
      TN:튀니지
      TO:통가
      TR:튀르키예
      TT:트리니다드 토바고
      TV:투발루
      TW:대만
      TZ:탄자니아
      UA:우크라이나
      UG:우간다
      UM:미국령 해외 제도
      UN:국제연합
      US:미국
      UY:우루과이
      UZ:우즈베키스탄
      VA:바티칸 시국
      VC:세인트빈센트그레나딘
      VE:베네수엘라
      VG:영국령 버진아일랜드
      VI:미국령 버진아일랜드
      VN:베트남
      VU:바누아투
      WF:왈리스-푸투나 제도
      WS:사모아
      XA:유사 억양
      XB:유사 양방향
      XK:코소보
      YE:예멘
      YT:마요트
      ZA:남아프리카
      ZM:잠비아
      ZW:짐바브웨
      ZZ:알려지지 않은 지역
      """.trimIndent() }

  val ko_CN: String? = null

  val ko_KP: String by lazy { """
      KP:조선민주주의인민공화국
      """.trimIndent() }

  val kok: String by lazy { """
      001:जग
      002:आफ्रिका
      003:उत्तर अमेरिका
      005:दक्षिण अमेरिका
      009:ओसेनिया
      011:अस्तंत आफ्रिका
      013:मध्य अमेरिका
      014:उदेंत आफ्रिका
      015:उत्तरीय आफ्रिका
      017:मध्य आफ्रिका
      018:दक्षिण आफ्रिका
      019:अमेरिकास
      021:उत्तरीय अमेरिका
      029:कॅरिबियन
      030:उदेंत आशिया
      034:दक्षिण आशिया
      035:आग्नेय आशिया
      039:दक्षिण युरोप
      053:ऑस्ट्रेलेसिया
      054:मेलानेसिया
      057:मायक्रोनेशियन प्रांत
      061:पोलिनेशिया
      142:आशिया
      143:मध्य आशिया
      145:अस्तंत आशिया
      150:युरोप
      151:उदेंत युरोप
      154:उत्तर युरोप
      155:अस्तंत युरोप
      202:उप-सहाराई आफ्रिका
      419:लॅटीन अमेरिका
      AC:असेंशन आयलँड
      AD:अंडोरा
      AE:युनाइटेड अरब इमीरात
      AF:अफगानिस्तान
      AG:एँटिगुआ आनी बारबुडा
      AI:अंगुला
      AL:अल्बानीया
      AM:आर्मीनीया
      AO:अंगोला
      AQ:अंटार्क्टिका
      AR:अर्जेंटिना
      AS:अमेरिकी सामोआ
      AT:ऑस्ट्रिया
      AU:ऑस्ट्रेलीया
      AW:अरुबा
      AX:अलांड जुवे
      AZ:अजरबैजान
      BA:बोस्निया आनी हेर्जेगोविना
      BB:बारबाडोस
      BD:बांगलादेश
      BE:बेल्जियम
      BF:बुर्किना फॅसो
      BG:बल्गेरीया
      BH:बेहरेन
      BI:बुरुंडी
      BJ:बेनीन
      BL:सॅंट बार्थेल्मी
      BM:बर्मुडा
      BN:ब्रूनेई
      BO:बोलिव्हिया
      BQ:कॅरिबियन निदरलँड
      BR:ब्राझील
      BS:बहामास
      BT:भूतान
      BV:बोवट आयलँड
      BW:बोत्सवाना
      BY:बेलारूस
      BZ:बेलिझ
      CA:कॅनडा
      CC:कोकोस (कीलिंग) आयलँड
      CD:कोंगो - किंशासा
      CF:मध्य अफ्रीकी लोकसत्तकराज्य
      CG:कोंगो - ब्राझाविला
      CH:स्विट्ज़रलैंड
      CI:कोत द’ईवोआर
      CK:कुक आयलँड्स
      CL:चिली
      CM:कॅमेरून
      CN:चीन
      CO:कोलंबिया
      CP:क्लिपरटॉन आयलँड
      CR:कोस्ता रिका
      CU:क्युबा
      CV:केप वर्दी
      CW:कुरसावो
      CX:क्रिसमस आयलँड
      CY:सायप्रस
      CZ:चेकिया
      DE:जर्मनी
      DG:दिगो गार्सिया
      DJ:जिबूती
      DK:डेनमार्क
      DM:डोमिनीका
      DO:डोमिनिकन प्रजासत्ताक
      DZ:अल्जेरिया
      EA:सिटा आनी मेलिल्ला
      EC:इक्वाडोर
      EE:एस्टोनिया
      EG:ईजिप्त
      EH:अस्तंत सहारा
      ER:इरिट्रिया
      ES:स्पेन
      ET:इथियोपिया
      EU:युरोपियन युनियन
      EZ:युरोझोन
      FI:फिनलँड
      FJ:फिजी
      FK:फ़ॉकलैंड आइलैंड्स
      FM:मायक्रोनेशिया
      FO:फैरो आयलँड्स
      FR:फ्रान्स
      GA:गॅबोन
      GB:युनायटेड किंगडम
      GD:ग्रेनॅडा
      GE:जॉर्जिया
      GF:फ्रेन्च गयाना
      GG:गर्नसी
      GH:घाना
      GI:जिब्राल्टर
      GL:ग्रीनलँड
      GM:गॅम्बिया
      GN:गुएनिया
      GP:ग्वाडेलोप
      GQ:इक्वेटोरियल गुएनिया
      GR:ग्रीस
      GS:दक्षिण जोर्जिया आनी दक्षिण सॅण्डविच आयलँड्स
      GT:ग्वाटेमाला
      GU:गुआम
      GW:गुअनिया-बिसाउ
      GY:गयाना
      HK:हाँग काँग एसएआर चीन
      HM:हर्ड ऍंड मॅक्डोनाल्ड आयलँड्स
      HN:हॉनडुरस
      HR:क्रोयेशीया
      HT:हैती
      HU:हंगेरी
      IC:कॅनरी आयलैंड्स
      ID:इंडोनेशीया
      IE:आयरलँड
      IL:इस्त्राइल
      IM:इसले ऑफ मॅन
      IN:भारत
      IO:ब्रिटिश हिंद महासागरीय क्षेत्र
      IQ:इराक
      IR:इरान
      IS:आइसलैंड
      IT:इटली
      JE:जर्सी
      JM:जमैका
      JO:जॉर्डन
      JP:जपान
      KE:केनया
      KG:किर्गिझस्तान
      KH:कंबोडिया
      KI:किरिबाती
      KM:कोमोरोस
      KN:सेंट किट्स आनी नेविस
      KP:उत्तर कोरिया
      KR:दक्षिण कोरिया
      KW:कुवेत
      KY:कैमेन आइलैंड्स
      KZ:कझाकस्तान
      LA:लाओस
      LB:लेबनान
      LC:सँट लुसिया
      LI:लिचेंस्टीन
      LK:श्री लंका
      LR:लायबेरीया
      LS:लिसोथो
      LT:लिथुआनिया
      LU:लक्सेमबर्ग
      LV:लॅटविया
      LY:लीबिया
      MA:मोरोक्को
      MC:मोनॅको
      MD:माल्डोवा
      ME:मॉन्टॅनग्रो
      MF:सॅंट मार्टिन
      MG:माडागास्कर
      MH:मार्शल आयलँड्स
      MK:उत्तर मॅसिडोनिया
      ML:माली
      MM:म्यानमार (बर्मा)
      MN:मंगोलिया
      MO:मकाव एसएआर चीन
      MP:उत्तरी मरिना आयसलैण्ड
      MQ:मार्टीनिक
      MR:मॉरिटानिया
      MS:मॉन्टसेराट
      MT:माल्टा
      MU:मॉरिशस
      MV:मालदीव
      MW:मलावी
      MX:मेक्सिको
      MY:मलेशिया
      MZ:मॉझांबीक
      NA:नामीबिया
      NC:न्यू कॅलिडोनिया
      NE:नायजर
      NF:नॉरफॉक आयलँड
      NG:नायजेरिया
      NI:निकारगुवा
      NL:नॅदरलँड
      NO:नॉर्वे
      NP:नेपाळ
      NR:नावरू
      NU:नीयू
      NZ:न्युझीलॅन्ड
      OM:ओमान
      PA:पनामा
      PE:पेरू
      PF:फ्रेन्च पोलिनेसिया
      PG:पापुआ न्यु गिनी
      PH:फिलीपिन्झ
      PK:पाकिस्तान
      PL:पोलंड
      PM:सँ. पायरे आनी मिकेलन
      PN:पिटकॅरन आयलँड्स
      PR:प्युएर्तो रिको
      PS:पेलेस्टीनियन प्रांत
      PT:पुर्तगाल
      PW:पलाऊ
      PY:पैराग्वे
      QA:कतार
      QO:आवटलायींग ओशेनिया
      RE:रीयूनियन
      RO:रोमानीया
      RS:सर्बिया
      RU:रूस
      RW:रवांडा
      SA:सऊदी अरेबिया
      SB:सोलोमन आइलँड्स
      SC:सेशेल्स
      SD:सूडान
      SE:स्वीडन
      SG:सिंगापूर
      SH:सेंट हेलिना
      SI:स्लोवेनिया
      SJ:स्वालबार्ड आनी जान मेयन
      SK:स्लोवाकिया
      SL:सिएरा लियॉन
      SM:सॅन मारीनो
      SN:सिनिगल
      SO:सोमालिया
      SR:सुरीनाम
      SS:दक्षिण सुडान
      ST:साओ टोम आनी प्रिन्सिप
      SV:एल साल्वाडोर
      SX:सिंट मार्टेन
      SY:सिरिया
      SZ:इस्वातिनी
      TA:त्रिस्तान दा कुन्हा
      TC:तुर्क्स आनी कॅकोज आयलँड्स
      TD:चाड
      TF:फ्रेंच दक्षिणी प्रांत
      TG:टोगो
      TH:थायलँड
      TJ:तजीकिस्तान
      TK:टोकलाऊ
      TL:तिमोर-लेस्ते
      TM:तुर्कमेनिस्तान
      TN:ट्यूनीशिया
      TO:टोंगा
      TR:तुर्की
      TT:ट्रिनीदाद आनी टोबॅगो
      TV:टुवालू
      TW:तायवान
      TZ:तांझानिया
      UA:युक्रेन
      UG:युगांडा
      UM:यु. एस. मायनर आवटलायींग आयलँड्‍स
      UN:युनायटेड नेशन्स
      US:युनायटेड स्टेट्स
      UY:उरूग्वे
      UZ:उझ्बेकिस्तान
      VA:वॅटिकन सिटी
      VC:सेंट विंसेंट ऐंड द ग्रेनेडाइंस
      VE:विनेझुएला
      VG:ब्रिटिश वर्जिन आयलँड्स
      VI:यु. एस. वर्जिन आयलँड्‍स
      VN:व्हिएतनाम
      VU:वनौतू
      WF:वालिस आनी फ्यूचूना
      WS:सामोआ
      XA:स्युडो-ऍक्सेंट
      XB:स्युडो-बिडी
      XK:कोसोवो
      YE:येमेन
      YT:मेयोट
      ZA:दक्षिण आफ्रीका
      ZM:झांबिया
      ZW:जिम्बाब्वे
      ZZ:अज्ञात प्रांत
      """.trimIndent() }

  val kok_Deva: String? = null

  val kok_Latn: String by lazy { """
      CN:Chin
      CY:Siprus
      DE:Jermon
      EG:Ejipt
      ES:Ispania
      FR:Frans
      GR:Gres
      IN:Bharot
      IT:Italia
      LY:Libia
      MK:Ut’tor Masedonia
      RU:Roxya
      """.trimIndent() }

  val ks: String by lazy { """
      001:دُنیا
      002:اَفریٖکا
      003:شُمٲلی اَمریٖکا
      005:جَنوٗنی اَمرٖیٖکا
      009:اوشَنیا
      011:مَغریٖبی اَفریٖکا
      013:مرکٔزی اَمریٖکا
      014:مَشرِقی اَفریٖکا
      015:شُمٲلی اَفریٖکا
      017:وسطی اَفریٖکا
      018:جنوٗبی اَفریٖکا
      019:اَمریٖکَس
      021:شُمٲلی اَمریٖکا خٕطہٕ
      029:کَرِببیٖن
      030:مَشرِقی ایشیا
      034:جنوٗبی ایشیا
      035:جنوٗبہِ مَشرِقی ایشیا
      039:جنوٗبی یوٗرَپ
      053:آسٹریلیشیا
      054:مؠلَنیٖشِیا
      057:مَیکرونَیشِیَن خٕطہٕ
      061:پالنیشِیا
      142:ایشیا
      143:مرکٔزی ایشیا
      145:مَغرِبی ایشیا
      150:یوٗرَپ
      151:مشرِقی یوٗرَپ
      154:شُمٲلی یوٗرَپ
      155:مغرِبی یوٗرَپ
      202:ذیلی سہارن افریقہ
      419:لاطیٖنی اَمریٖکا
      AC:ایسنشن جزیرٕ
      AD:اینڈورا
      AE:مُتحدہ عرَب امارات
      AF:اَفغانَستان
      AG:اؠنٹِگُوا تہٕ باربوڑا
      AI:انگوئیلا
      AL:البانیا
      AM:اَرمانِیا
      AO:انگولا
      AQ:اینٹارٹِکا
      AR:أرجَنٹینا
      AS:اَمریٖکَن سَموا
      AT:آسٹریا
      AU:آسٹریلِیا
      AW:اَروٗبا
      AX:ایلینڑ جٔزیٖرٕ
      AZ:آذربائیجان
      BA:بوسنِیا تہٕ ہَرزِگووِنا
      BB:باربیڈوس
      BD:بَنگلادیش
      BE:بیلجِیَم
      BF:بُرکِنا فیسو
      BG:بَلجیرِیا
      BH:بحریٖن
      BI:بورَنڈِ
      BJ:بِنِن
      BL:سینٹ بارتَھیلمی
      BM:برمودا
      BN:برونے
      BO:بولِوِیا
      BQ:کیریبین نیدرلینڈس
      BR:برازِل
      BS:بَہامَس
      BT:بوٗٹان
      BV:بووَٹ جٔزیٖرٕ
      BW:بوتَسوانا
      BY:بیلاروٗس
      BZ:بیلز
      CA:کینیڈا
      CC:کوکَس (کیٖلِنگ) جٔزیٖرٕ
      CD:کونگو کِنشاسا
      CF:مرکٔزی اَفریٖکی جموٗریَت
      CG:کونگو بٔرزاوِلی
      CH:سُوِزَرلینڑ
      CI:کوٹ ڈلوائر
      CK:کُک جٔزیٖرٕ
      CL:چِلی
      CM:کیمِروٗن
      CN:چیٖن
      CO:کولَمبِیا
      CP:کلیپرٹن جزیرٕ
      CR:کوسٹا ریکا
      CU:کیوٗبا
      CV:کیپ ؤرڑی
      CW:کیوراکو
      CX:کرِسمَس جٔزیٖرٕ
      CY:سائپرس
      CZ:چیکیا
      DE:جرمٔنی
      DG:ڈیگو گریشیا
      DJ:جِبوٗتی
      DK:ڈینمارٕک
      DM:ڈومِنِکا
      DO:ڈومِنِکَن جموٗرِیَت
      DZ:اؠلجیرِیا
      EA:سیوٹا تٕہ مٔلیلا
      EC:اِکواڑور
      EE:ایسٹونِیا
      EG:مصر
      EH:مشرِقی سَہارا
      ER:اِرٕٹِیا
      ES:سٕپین
      ET:اِتھوپِیا
      EU:یوٗرپی یونین
      EZ:یوٗرو زون
      FI:فِن لینڈ
      FJ:فِجی
      FK:فٕلاکلینڑ جٔزیٖرٕ
      FM:مائیکرونیشیا
      FO:فارو جزیرہ
      FR:فرانس
      GA:گیبان
      GB:متحدہ مملِکت
      GD:گرینیڈا
      GE:جارجِیا
      GF:فرانسِسی گِانا
      GG:گورنسے
      GH:گانا
      GI:جِبرالٹَر
      GL:گرین لینڈ
      GM:گَمبِیا
      GN:گِنی
      GP:گواڈلوپ
      GQ:اِکوِٹورِیَل گِنی
      GR:گریٖس
      GS:جنوٗبی جارجِیا تہٕ جنوٗبی سینڑوٕچ جٔزیٖرٕ
      GT:گواٹمالا
      GU:گُوام
      GW:گیٖنی بِساو
      GY:گُیانا
      HK:ہانگ کانگ ایس اے آر چیٖن
      HM:ہَرٕڑ تہٕ مؠکڈونالڑٕ جٔزیٖرٕ
      HN:ہونڈورس
      HR:کروشِیا
      HT:ہیتی
      HU:ہَنگری
      IC:کینری جزیرٕ
      ID:انڈونیشیا
      IE:اَیَرلینڑ
      IL:اسرا ییل
      IM:آیِل آف مین
      IN:ہِندوستان
      IQ:ایٖراق
      IR:ایٖران
      IS:اَیِسلینڑ
      IT:اِٹلی
      JE:جٔرسی
      JM:جَمایکا
      JO:جورڈن
      JP:جاپان
      KE:کِنیا
      KG:کرغزستان
      KH:کَمبوڑِیا
      KI:کِرٕباتی
      KM:کَمورَس
      KN:سینٹ کِٹَس تہٕ نیوِس
      KP:شُمٲلی کورِیا
      KR:جنوٗبی کورِیا
      KW:کُویت
      KY:کیمَن جٔزیٖرٕ
      KZ:قازقستان
      LA:لاس
      LB:لؠبنان
      LC:سینٹ لوٗسِیا
      LI:لِکٹیسٹیٖن
      LK:سری لنکا
      LR:لایبیرِیا
      LS:لیسوتھو
      LT:لِتھُوانِیا
      LU:لَکسَمبٔرٕگ
      LV:لیٹوِیا
      LY:لِبیا
      MA:موروکو
      MC:مونیکو
      MD:مولڈووا
      ME:موٹونیگِریو
      MF:سینٹ مارٹِن
      MG:میڈاگاسکار
      MH:مارشَل جٔزیٖرٕ
      MK:شُمالی میسڈونیا
      ML:مالی
      MM:میانمار (برما)
      MN:مَنگولِیا
      MO:مَکاوو ایس اے آر چیٖن
      MP:شُمٲلی مارِیانا جٔزیٖرٕ
      MQ:مارٹِنِک
      MR:مارٕٹانِیا
      MS:مانٹسیراٹ
      MT:مالٹا
      MU:مورِشَس
      MV:مالدیٖو
      MW:ملاوی
      MX:مؠکسِکو
      MY:مَلیشِیا
      MZ:موزَمبِک
      NA:نامِبِیا
      NC:نِو کیلِڑونِیا
      NE:نایجَر
      NF:نارفاک جٔزیٖرٕ
      NG:نایجیرِیا
      NI:ناکاراگُوا
      NL:نیٖدَرلینڑ
      NO:ناروے
      NP:نیپال
      NR:نارووٗ
      NU:نیوٗ
      NZ:نیوزی لینڈ
      OM:اومان
      PA:پَناما
      PE:پیٖروٗ
      PF:فرانسی پولِنیشِیا
      PG:پاپُوا نیوٗ گیٖنی
      PH:فلپائن
      PK:پاکِستان
      PL:پولینڈ
      PM:سینٹ پیٖری تہٕ موکیلِیَن
      PN:پِٹکیرٕنؠ جٔزیٖرٕ
      PR:پٔرٹو رِکو
      PS:فلسطینی علاقٕہ
      PT:پُرتِگال
      PW:پَلاو
      PY:پَراگُے
      QA:قَطِر
      QO:آوُٹلاینِگ اوشینِیا
      RE:رِیوٗنِیَن
      RO:رومانِیا
      RS:سَربِیا
      RU:روٗس
      RW:روٗوانڈا
      SA:سعودی عرب
      SB:سولامان جٔزیٖرٕ
      SC:سیشَلِس
      SD:سوٗڈان
      SE:سویڈن
      SG:سِنگاپوٗر
      SH:سینٹ ہؠلِنا
      SI:سَلووینِیا
      SJ:سَوالبریڑ تہٕ جان ماییڑ
      SK:سَلوواکِیا
      SL:سیرا لیون
      SM:سین میرِنو
      SN:سینیگَل
      SO:سومالِیا
      SR:سُرِنام
      SS:جنوبی سوڈان
      ST:ساو توم تہٕ پرنسِپی
      SV:ایل سلویڈر
      SX:سِنٹ مارٹِن
      SY:شام
      SZ:ایسواتنی
      TA:ٹریسٹن ڈا کنہا
      TC:تُرکس تٕہ کیکو جزیرٕ
      TD:چاڑ
      TF:فرانسِسی جَنوٗبی عَلاقہٕ
      TG:ٹوگو
      TH:تھائی لینڈ
      TJ:تاجکِستان
      TK:ٹوکلو
      TL:تیمور-لیسٹ
      TM:تُرکمنستان
      TN:ٹونیشِیا
      TO:ٹونگا
      TR:تُرکی
      TT:ٹرنِنداد تہٕ ٹوبیگو
      TV:توٗوالوٗ
      TW:تایوان
      TZ:تَنجانِیا
      UA:یوٗرِکین
      UG:یوٗگانڑا
      UM:یوٗنایٹِڑ سِٹیٹِس ماینَر آوُٹلییِنگ جٔزیٖرٕ
      UN:متحدہ مُمٲلک
      US:یوٗنایٹِڑ سِٹیٹِس
      UY:یوٗروگے
      UZ:اُزبِکِستان
      VA:ویٹِکَن سِٹی
      VC:سینٹ وینسؠٹ تہٕ گریناڑاینٕز
      VE:وینازوٗلا
      VG:بَرطانوی ؤرجِن جٔزیٖرٕ
      VI:یوٗ ایس ؤرجِن جٔزیٖرٕ
      VN:ویتنام
      VU:وانوٗتوٗ
      WF:والِس تہٕ فیوٗچوٗنا
      WS:سامو
      XA:سوڈو-ایسنٹس
      XB:سوڈو-بیڈی
      XK:کوسوو
      YE:یَمَن
      YT:مَییٹ
      ZA:جنوبی افریقہ
      ZM:زیمبیا
      ZW:زِمبابے
      ZZ:نامولوٗم علاقٕہ
      """.trimIndent() }

  val ks_Arab: String? = null

  val ks_Deva: String by lazy { """
      BR:ब्राज़ील
      CN:चीन
      DE:जर्मन
      FR:फ्रांस
      GB:मुतहीद बादशाहत
      IN:हिंदोस्तान
      IT:इटली
      JP:जापान
      RU:रूस
      US:मूतहीद रियासत
      ZZ:नामोलुम अलाक़
      """.trimIndent() }

  val ksb: String by lazy { """
      AD:Andola
      AE:Falme za Kialabu
      AF:Afuganistani
      AG:Antigua na Balbuda
      AI:Anguilla
      AL:Albania
      AM:Almenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Malekani
      AT:Austlia
      AU:Austlalia
      AW:Aluba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BF:Bukinafaso
      BG:Bulgalia
      BH:Bahaleni
      BI:Bulundi
      BJ:Benini
      BM:Belmuda
      BN:Blunei
      BO:Bolivia
      BR:Blazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belalusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuli ya Kidemoklasia ya Kongo
      CF:Jamhuli ya Afrika ya Gati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameluni
      CN:China
      CO:Kolombia
      CR:Kostalika
      CU:Kuba
      CV:Kepuvede
      CY:Kuplosi
      CZ:Jamhuli ya Cheki
      DE:Ujeumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuli ya Dominika
      DZ:Aljelia
      EC:Ekwado
      EE:Estonia
      EG:Misli
      ER:Elitlea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Miklonesia
      FR:Ufalansa
      GA:Gaboni
      GB:Uingeeza
      GD:Glenada
      GE:Jojia
      GF:Gwiyana ya Ufalansa
      GH:Ghana
      GI:Jiblalta
      GL:Glinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiiki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Honduasi
      HR:Kolasia
      HT:Haiti
      HU:Hungalia
      ID:Indonesia
      IE:Ayalandi
      IL:Islaeli
      IN:India
      IQ:Ilaki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yoldani
      JP:Japani
      KE:Kenya
      KG:Kiigizistani
      KH:Kambodia
      KI:Kiibati
      KM:Komolo
      KN:Santakitzi na Nevis
      KP:Kolea Kaskazini
      KR:Kolea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sililanka
      LR:Libelia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moloko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Mashal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Maliana vya Kaskazini
      MQ:Maltiniki
      MR:Maulitania
      MS:Montselati
      MT:Malta
      MU:Molisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Naija
      NF:Kisiwa cha Nolfok
      NG:Naijelia
      NI:Nikalagwa
      NL:Uholanzi
      NO:Nolwei
      NP:Nepali
      NR:Naulu
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Pelu
      PF:Polinesia ya Ufalansa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieli na Mikeloni
      PN:Pitkailni
      PR:Pwetoliko
      PS:Ukingo wa Maghalibi na Ukanda wa Gaza wa Palestina
      PT:Uleno
      PW:Palau
      PY:Palagwai
      QA:Katali
      RE:Liyunioni
      RO:Lomania
      RU:Ulusi
      RW:Lwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siela Leoni
      SM:Samalino
      SN:Senegali
      SO:Somalia
      SR:Sulinamu
      ST:Sao Tome na Plincipe
      SV:Elsavado
      SY:Silia
      SZ:Uswazi
      TC:Visiwa vya Tulki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timoli ya Mashaliki
      TM:Tulukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Utuluki
      TT:Tlinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Uklaini
      UG:Uganda
      US:Malekani
      UY:Ulugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Glenadini
      VE:Venezuela
      VG:Visiwa vya Vilgin vya Uingeeza
      VI:Visiwa vya Vilgin vya Malekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Aflika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val ksf: String by lazy { """
      AD:andɔrǝ
      AE:bǝlɔŋ bǝ kaksa bɛ táatáaŋzǝn
      AF:afganistáŋ
      AG:antiga ri barbúda
      AI:angiya
      AL:albaní
      AM:armɛní
      AO:angóla
      AR:arjǝntín
      AS:samɔa a amɛrika
      AT:otric
      AU:ɔstralí
      AW:aruba
      AZ:azabecán
      BA:bɔsnyɛ ri hɛrsǝgɔvín
      BB:baabaadǝ
      BD:baŋladɛ́c
      BE:bɛljík
      BF:bukína fǝ́ asɔ
      BG:bulgarí
      BH:barǝ́n
      BI:burundí
      BJ:bɛnǝ́n
      BM:bɛɛmúdǝ
      BN:brunǝ́
      BO:bɔɔlíví
      BR:brɛsíl
      BS:baamás
      BT:bután
      BW:botswana
      BY:bɛlaris
      BZ:bɛliz
      CA:kanada
      CD:kɔngó anyɔ́n
      CF:santrafrík
      CG:kɔngó
      CH:swís
      CI:kɔtiwuár
      CK:zɛ i kúk
      CL:cíli
      CM:kamɛrún
      CN:cín
      CO:kolɔmbí
      CR:kɔstaríka
      CU:kuba
      CV:kapvɛr
      CY:cíprɛ
      CZ:cɛ́k
      DE:djɛrman
      DJ:dyibutí
      DK:danmak
      DM:dɔminik
      DO:dɔminik rɛpublík
      DZ:aljɛrí
      EC:ɛkwatɛǝ́
      EE:ɛstoní
      EG:ɛjípt
      ER:ɛritrɛ́
      ES:kpanyá
      ET:ɛtyɔpí
      FI:fínlan
      FJ:fíji
      FK:zǝ maalwín
      FM:mikronɛ́si
      FR:pɛrɛsǝ́
      GA:gabɔŋ
      GB:kǝlɔŋ kǝ kǝtáatáaŋzǝn
      GD:grɛnadǝ
      GE:jɔrjí
      GF:guyán i pɛrɛsǝ́
      GH:gána
      GI:jibraltá
      GL:grínlan
      GM:gambí
      GN:ginɛ́
      GP:gwadɛlúp
      GQ:ginɛ́ ɛkwatɔrial
      GR:grɛ́k
      GT:gwátǝmala
      GU:gwám
      GW:ginɛ́ bisɔ́
      GY:guyán
      HN:ɔnduras
      HR:krwasí
      HT:ayiti
      HU:ɔngrí
      ID:indonɛsí
      IE:ilán
      IL:israɛ́l
      IN:indí
      IQ:irák
      IR:iráŋ
      IS:zǝ i glás
      IT:italí
      JM:jamaík
      JO:jɔrdán
      JP:japɔ́ŋ
      KE:kɛnya
      KG:kigistáŋ
      KH:kambodj
      KI:kiribáti
      KM:komɔr
      KN:sɛnkrǝstɔ́f ri nyɛ́vǝ
      KP:korɛanɔ́r
      KR:korɛasud
      KW:kuwɛit
      KY:zǝ i gan
      KZ:kazakstáŋ
      LA:laɔs
      LB:libáŋ
      LC:sɛntlísí
      LI:lictɛnstɛ́n
      LK:srílaŋka
      LR:libɛrya
      LS:lǝsóto
      LT:litwaní
      LU:luksɛmbúr
      LV:lɛtoní
      LY:libí
      MA:marɔk
      MC:monako
      MD:mɔldaví
      MG:madagaska
      MH:zǝ i marcál
      ML:mali
      MM:myanmár
      MN:mɔŋolí
      MP:zǝ maryánnɔ́r
      MQ:matiník
      MR:mwaritaní
      MS:mɔnsɛrat
      MT:maltǝ
      MU:mwarís
      MV:maldivǝ
      MW:malawi
      MX:mɛksík
      MY:malɛsí
      MZ:mosambík
      NA:namibí
      NC:kalɛdoní anyɔ́n
      NE:nijɛ́r
      NF:zɛ nɔ́fɔlk
      NG:nijɛ́rya
      NI:níkarágwa
      NL:kǝlɔŋ kǝ ázǝ
      NO:nɔrvɛjǝ
      NP:nɛpal
      NR:nwarú
      NU:niwɛ́
      NZ:zɛlan anyɔ́n
      OM:oman
      PA:panama
      PE:pɛrú
      PF:pɔlinɛsí a pɛrɛsǝ́
      PG:papwazí ginɛ́ anyɔ́n
      PH:filipǝ́n
      PK:pakistáŋ
      PL:polɔ́n
      PM:sɛnpyɛr ri mikɛlɔŋ
      PN:pitkɛ́n
      PR:pɔtoríko
      PS:zǝ palɛstínǝ
      PT:portugál
      PW:palwa
      PY:paragwɛ́
      QA:katá
      RE:rɛunyɔŋ
      RO:rɔmaní
      RU:risí
      RW:rwanda
      SA:arabí saodí
      SB:zǝ salomɔ́n
      SC:sɛcɛl
      SD:sudan
      SE:swɛdǝ
      SG:siŋapó
      SH:sɛntɛ́len
      SI:slovɛní
      SK:slovakí
      SL:syɛraleon
      SM:sɛnmarǝn
      SN:sɛnɛgal
      SO:somalí
      SR:surinam
      ST:saotomɛ́ ri priŋsib
      SV:salvadɔr
      SY:sirí
      SZ:swazilan
      TC:zǝ tirk ri kakɔs
      TD:caád
      TG:togo
      TH:tɛlan
      TJ:tadjikistaŋ
      TK:tokǝlao
      TL:timor anǝ á ɛst
      TM:tirkmɛnistaŋ
      TN:tunɛsí
      TO:tɔŋa
      TR:tirkí
      TT:tɛrinitɛ ri tobago
      TV:tuwalu
      TW:tɛwán
      TZ:tanzaní
      UA:ukrain
      UG:uganda
      US:amɛrika
      UY:urugwɛ́
      UZ:usbɛkistaŋ
      VA:watikáŋ
      VC:sɛnvǝnsǝŋ ri grɛnadín
      VE:wɛnǝzwɛla
      VG:zǝ bɛ gɔn inɛ a ingɛrís
      VI:zǝ bɛ gɔn inɛ á amɛrika
      VN:wyɛtnám
      VU:wanwatu
      WF:walis ri futuna
      WS:samɔa
      YE:yɛmɛn
      YT:mayɔ́t
      ZA:afrik anǝ a sud
      ZM:zambí
      ZW:zimbabwɛ́
      """.trimIndent() }

  val ksh: String by lazy { """
      001:de Ääd
      002:Affrika
      003:Nood-Amärrika
      005:Söhd-Amärrika
      009:Ozejahneje
      011:Wäß-Affrika
      013:Meddelammärrika
      014:Oß-Affrika
      015:Nood-Affrika
      017:Meddel-Affrika
      018:Söhd-Affrika
      019:Ammärrika
      021:der Norde vun Amärrika
      029:de Karribik
      030:Oß-Aasije
      034:Söhd-Aasije
      035:Söhd-Oß-Aasije
      039:Söhd-Europpa
      053:de Rejjohn öm Austrahlije
      054:Mellanehsije
      057:de Rejohn vun Mikronehseje
      061:Polinehsije
      142:Aasije
      143:Meddelaasije
      145:Wäß-Aasije
      150:Europpa
      151:Oß-Europpa
      154:Nood-Europpa
      155:Wäß-Europpa
      419:Lateinamärrika
      AC:Aßension
      AD:Andorra
      AE:Vereinschte Arrabesche Emmirate
      AF:Afjaanistahn
      AG:Antigwa un Barbuda
      AI:Anggwilla
      AL:Albaanije
      AM:Arrmeenije
      AO:Angjoola
      AQ:der Södpol
      AR:Ajjentiinije
      AS:Ammerikaanesch Sammoha
      AT:Öösterisch
      AU:Austraalije
      AW:Aruba
      AX:de Ohland-Enselle
      AZ:Asserbaidschahn
      BA:Boßnije un Herzegovina
      BB:de Ensel Barbados
      BD:Bangladesch
      BE:Bellje
      BF:Bukkinna-Faase
      BG:Bulljaarije
      BH:Bachrain
      BI:Burundi
      BJ:dä Benin
      BL:de Zint Battälmi-Enselle
      BM:de Bermudas
      BN:Brunei
      BO:Bolliivije
      BQ:de karribbesche Nederläng
      BR:Brasilije
      BS:de Bahamas
      BT:Buttaan
      BV:de Buvee-Ensel
      BW:Bozwaana
      BY:Wießrußland
      BZ:Belize
      CA:Kanada
      CC:de Kokkos-Enselle
      CD:dä Konggo (Kinschasa)
      CF:de Zäntraalaffrikaanesche Republik
      CG:dä Konggo (Brassavill)
      CH:de Schweiz
      CI:Älfebeijn-Köß
      CK:de Kuuk-Enselle
      CL:Schiile
      CM:Kammeruhn
      CN:Schiina
      CO:Kolumbije
      CP:de Klipperton-Ensel
      CR:Kostarika
      CU:Kuhba
      CV:de kapvärdesche Enselle
      CW:Curaçao
      CX:de Weihnaachs-Ensel
      CY:Züppere
      CZ:de Tschäschei
      DE:Doütschland
      DG:de Diego-Garcia-Ensel
      DJ:Dschibutti
      DK:Dänemark
      DM:Dominnika
      DO:de Dommenekaanesche Reppublik
      DZ:Alljeerije
      EA:Ze’uta un Meliija
      EC:Äkwador
      EE:Äßland
      EG:Äjüpte
      EH:Wäß-Sahara
      ER:Äritreja
      ES:Schpaanije
      ET:Ättijoopije
      EU:de Europähjesche Unijon
      FI:Finnland
      FJ:de Fidschi-Endelle
      FK:de Falkland-Enselle
      FM:Mikroneesije
      FO:de Färrör-Enselle
      FR:Frankrisch
      GA:Jabuhn
      GB:Jruußbrettannije
      GD:Jrenahda
      GE:Jeorrjije
      GF:Franzüüsesch Jujaana
      GG:Jöönsei
      GH:Jaana
      GI:Jibralltaa
      GL:Jröhnland
      GM:Jambija
      GN:Jinneha
      GP:Juadelupp
      GQ:Äquatorial Jineeja
      GR:Jriescheland
      GS:Söd-Jeorjie un de södlijje Botteramms-Enselle
      GT:Juwatemahla
      GU:Juham
      GW:Jinneha_Bißau
      GY:Jujaana
      HK:Hongkong
      HM:de Heart Ensel un de McDonald-Enselle
      HN:Honduras
      HR:Krowazije
      HT:Ha’itti
      HU:Unjann
      IC:de Kannaresche Enselle
      ID:Indoneesije
      IE:Irrland
      IL:Ißraäl
      IM:de Ensel Män
      IN:Indije
      IQ:Irak
      IR:Persije
      IS:Ißland
      IT:Itaalije
      JE:Jööseh
      JM:Jammaika
      JO:Jordaanije
      JP:Japan
      KE:Keenija
      KG:Kirrjiisije
      KH:Kambodscha
      KI:Kiribati
      KM:de Kommoore
      KN:Zint Kitts un Nevis
      KP:Nood-Koreja
      KR:Söd-Koreja
      KW:Kuweit
      KY:de Kaiman-Enselle
      KZ:Kassakstahn
      LA:La’os
      LB:Lebbannon
      LC:de Ensel Zint-Lutscha
      LI:Lischteschtein
      LK:Sri Lanka
      LR:Libeerija
      LS:Lesooto
      LT:Littaue
      LU:Luxembursch
      LV:Lätland
      LY:Libbije
      MA:Marokko
      MC:Monakko
      MD:Moldaavije
      ME:et Monteneejro
      MF:de Zint-Määtes-Ensel
      MG:Maddajaska
      MH:de Machschall-Enselle
      ML:Maali
      MM:Birma
      MN:Mongjolei
      MO:Makau
      MP:de nöödlijje Marijanne-Enselle
      MQ:Machtinik
      MR:Mautitaanije
      MS:Mongßerrat
      MT:Malta
      MU:Maurizijus
      MV:Mallediive
      MW:Malawi
      MX:Mäxiko
      MY:Malaisije
      MZ:Mosambik
      NA:Namiibije
      NC:Neuschottland
      NE:Nijer
      NF:de Noofok-Ensel
      NG:Nikaraagua
      NI:Nikarahguwa
      NL:de Nederläng
      NO:Norrweeje
      NP:Nepall
      NR:Nauru
      NU:Niue
      NZ:Neuseeland
      OM:Oman
      PA:Pannama
      PE:Perruh
      PF:Franzüüsesch Pollineesije
      PG:Papuwa Neujineeja
      PH:Fillipiine
      PK:Pakistahn
      PL:Pole
      PM:Zint Pjäär un Mikelong
      PN:de Pitkärn-Ensel
      PR:Pochtoriko
      PS:Palästina
      PT:Pochtojall
      PW:Pallau
      PY:Parraguwai
      QA:Kataa
      QO:Ozejahnije ußerhallef
      RE:Rehunjohn
      RO:Romäänije
      RS:Särbije
      RU:Rußland
      RW:Ruanda
      SA:Saudi Arraabije
      SB:de Solomone-Enselle
      SC:de Seischälle
      SD:Noodsudahn
      SE:Schweede
      SG:Singjapuur
      SH:de Ensel Zint Hellena
      SI:ẞloveenije
      SJ:de Enselle Svalbard un Jan Mayen
      SK:ẞlovakei
      SL:Sjärra Lejone
      SM:San-Marino
      SN:der Sennejall
      SO:Somaalije
      SR:Sürinamm
      SS:Södsudahn
      ST:Zint Tommeh un Printschipe
      SV:Äl Slavadohr
      SX:Zint Maarten
      SY:Sürije
      SZ:ẞwaasiland
      TA:Tristan da Cunja
      TC:de Enselle Turks un Kaikos
      TD:der Tschadd
      TF:Franzüüsesche Södsee-Enselle
      TG:Toojo
      TH:Tailand
      TJ:Tadschikistahn
      TK:Tokelau
      TL:Oß-Timor
      TM:Turkmenistahn
      TN:Tuneesije
      TO:Tongga
      TR:de Törkei
      TT:Trinidad un Tobähjo
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansanija
      UA:de Ukra’iine
      UG:Ujanda
      UM:de Vereineschte Schtaate vun Amärrika ier ußerhallef jelääje Enselsche
      US:de vereineschte Schtaate vun Ammärrika
      UY:Urrujwai
      UZ:Ußbeekistahn
      VA:der Vattikahn
      VC:Zint Vinzänz un de Jrenadines-Enselle
      VE:Venezuela
      VG:de brettesche Juffer-Enselle
      VI:de ammärrikahnesche Juffer-Enselle
      VN:Vijätnamm
      VU:Vanuatu
      WF:Wallis un Futuna
      WS:Sammoha
      XK:Kosovo
      YE:Jämme
      YT:Majott
      ZA:de Republik Södaffrika
      ZM:Sambija
      ZW:Simbabwe
      ZZ:- Jähjend onbikannt -
      """.trimIndent() }

  val ku: String by lazy { """
      001:dinya
      002:Afrîka
      003:Amerîkaya Bakur
      005:Amerîkaya Başûr
      009:Okyanûsya
      011:Rojavayê Afrîkayê
      013:Amerîkaya Navîn
      014:Rojhilatê Afrîkayê
      015:Bakurê Afrîkayê
      017:Afrîkaya Navîn
      018:Başûrê Afrîkayê
      019:Amerîka
      021:Bakurê Amerîkayê
      029:Karayîb
      030:Rojhilatê Asyayê
      034:Başûrê Asyayê
      035:Başûrrojhilatê Asyayê
      039:Başûrê Ewropayê
      053:Awistralasya
      054:Melanezya
      057:Herêma Mîkronezyayê
      061:Polînezya
      142:Asya
      143:Asyaya Navîn
      145:Rojavayê Asyayê
      150:Ewropa
      151:Rojhilatê Ewropayê
      154:Bakurê Ewropayê
      155:Rojavayê Ewropayê
      202:Afrîkaya Jêra Sahrayê
      419:Amerîkaya Latîn
      AC:Girava Ascensionê
      AD:Andorra
      AE:Mîrgehên Erebî yên Yekbûyî
      AF:Efxanistan
      AG:Antîgua û Berbûda
      AI:Anguîla
      AL:Albanya
      AM:Ermenistan
      AO:Angola
      AQ:Antarktîka
      AR:Arjantîn
      AS:Samoaya Amerîkanî
      AT:Awistirya
      AU:Awistralya
      AW:Arûba
      AX:Giravên Alandê
      AZ:Azerbeycan
      BA:Bosna û Hersek
      BB:Barbados
      BD:Bengladeş
      BE:Belçîka
      BF:Burkîna Faso
      BG:Bulgaristan
      BH:Behreyn
      BI:Bûrûndî
      BJ:Bênîn
      BL:Saint Barthelemy
      BM:Bermûda
      BN:Brûney
      BO:Bolîvya
      BQ:Holendaya Karayîbê
      BR:Brezîlya
      BS:Bahama
      BT:Bûtan
      BV:Girava Bouvetê
      BW:Botswana
      BY:Belarûs
      BZ:Belîze
      CA:Kanada
      CC:Giravên Kokosê (Keeling)
      CD:Kongo - Kînşasa
      CF:Komara Afrîkaya Navîn
      CG:Kongo - Brazzaville
      CH:Swîsre
      CI:Côte d’Ivoire
      CK:Giravên Cookê
      CL:Şîle
      CM:Kamerûn
      CN:Çîn
      CO:Kolombîya
      CP:Girava Clippertonê
      CQ:Sark
      CR:Kosta Rîka
      CU:Kuba
      CV:Kap Verde
      CW:Curaçao
      CX:Girava Christmasê
      CY:Qibris
      CZ:Çekya
      DE:Almanya
      DG:Diego Garcia
      DJ:Cîbûtî
      DK:Danîmarka
      DM:Domînîka
      DO:Komara Domînîkê
      DZ:Cezayîr
      EA:Ceuta û Melîla
      EC:Ekwador
      EE:Estonya
      EG:Misir
      EH:Sahraya Rojava
      ER:Erître
      ES:Spanya
      ET:Etîyopya
      EU:Yekîtîya Ewropayê
      EZ:Herêma Ewroyê
      FI:Fînlenda
      FJ:Fîjî
      FK:Giravên Falklandê
      FM:Mîkronezya
      FO:Giravên Faroeyê
      FR:Fransa
      GA:Gabon
      GB:Qiralîyeta Yekbûyî
      GD:Grenada
      GE:Gurcistan
      GF:Guyanaya Fransî
      GG:Guernsey
      GH:Gana
      GI:Cebelîtariq
      GL:Grînlanda
      GM:Gambîya
      GN:Gîne
      GP:Guadeloupe
      GQ:Gîneya Ekwadorê
      GR:Yûnanistan
      GS:Giravên Georgîyaya Başûr û Sandwicha Başûr
      GT:Guatemala
      GU:Guam
      GW:Gîne-Bissau
      GY:Guyana
      HK:Hong Konga HîT ya Çînê
      HM:Giravên Heard û MacDonaldê
      HN:Hondûras
      HR:Xirwatistan
      HT:Haîtî
      HU:Macaristan
      IC:Giravên Kanaryayê
      ID:Endonezya
      IE:Îrlanda
      IL:Îsraîl
      IM:Girava Manê
      IN:Hindistan
      IO:Herêma Okyanûsa Hindî ya Brîtanyayê
      IQ:Îraq
      IR:Îran
      IS:Îslanda
      IT:Îtalya
      JE:Jersey
      JM:Jamaîka
      JO:Urdun
      JP:Japonya
      KE:Kenya
      KG:Qirgizistan
      KH:Kamboçya
      KI:Kirîbatî
      KM:Komor
      KN:Saint Kitts û Nevîs
      KP:Koreya Bakur
      KR:Koreya Başûr
      KW:Kuweyt
      KY:Giravên Kaymanê
      KZ:Qazaxistan
      LA:Laos
      LB:Libnan
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Srî Lanka
      LR:Lîberya
      LS:Lesoto
      LT:Lîtvanya
      LU:Luksembûrg
      LV:Letonya
      LY:Lîbya
      MA:Fas
      MC:Monako
      MD:Moldova
      ME:Montenegro
      MF:Saint Martin
      MG:Madagaskar
      MH:Giravên Marşalê
      MK:Makendonyaya Bakur
      ML:Malî
      MM:Myanmar (Bûrma)
      MN:Moxolistan
      MO:Makaoya Hît ya Çînê
      MP:Giravên Bakurê Marianan
      MQ:Martînîk
      MR:Morîtanya
      MS:Montserat
      MT:Malta
      MU:Mauritius
      MV:Maldîva
      MW:Malawî
      MX:Meksîka
      MY:Malezya
      MZ:Mozambîk
      NA:Namîbya
      NC:Kaledonyaya Nû
      NE:Nîjer
      NF:Girava Norfolkê
      NG:Nîjerya
      NI:Nîkaragua
      NL:Holanda
      NO:Norwêc
      NP:Nepal
      NR:Naûrû
      NU:Niûe
      NZ:Zelandaya Nû
      OM:Oman
      PA:Panama
      PE:Perû
      PF:Polînezyaya Fransizî
      PG:Papua Gîneya Nû
      PH:Fîlîpîn
      PK:Pakistan
      PL:Polonya
      PM:Saint-Pierre û Miquelon
      PN:Giravên Pitcairnê
      PR:Porto Rîko
      PS:Herêmên Filîstînî
      PT:Portûgal
      PW:Palau
      PY:Paragûay
      QA:Qeter
      QO:Okyanûsyaya Dûr
      RE:Réunion
      RO:Romanya
      RS:Sirbistan
      RU:Rûsya
      RW:Rwanda
      SA:Erebistana Siûdî
      SB:Giravên Solomonê
      SC:Seyşel
      SD:Sûdan
      SE:Swêd
      SG:Sîngapûr
      SH:Saint Helena
      SI:Slovenya
      SJ:Svalbard û Jan Mayen
      SK:Slovakya
      SL:Sierra Leone
      SM:San Marîno
      SN:Senegal
      SO:Somalya
      SR:Surînam
      SS:Sûdana Başûr
      ST:Sao Tome û Prînsîpe
      SV:El Salvador
      SX:Sint Marteen
      SY:Sûrîye
      SZ:Eswatînî
      TA:Tristan da Cunha
      TC:Giravên Turks û Kaîkosê
      TD:Çad
      TF:Herêmên Başûr ên Fransayê
      TG:Togo
      TH:Tayland
      TJ:Tacîkistan
      TK:Tokelau
      TL:Tîmor-Leste
      TM:Tirkmenistan
      TN:Tûnis
      TO:Tonga
      TR:Tirkîye
      TT:Trînîdad û Tobago
      TV:Tûvalû
      TW:Taywan
      TZ:Tanzanya
      UA:Ûkrayna
      UG:Ûganda
      UM:Giravên Biçûk ên Derveyî DYAyê
      UN:Miletên Yekbûyî
      US:Dewletên Yekbûyî yên Amerîkayê
      UY:Ûrûguay
      UZ:Ozbekistan
      VA:Vatîkan
      VC:Saint Vincent û Giravên Grenadînê
      VE:Venezuela
      VG:Giravên Vîrjînê yên Brîtanyayê
      VI:Giravên Vîrjînê yên Amerîkayê
      VN:Vîetnam
      VU:Vanûatû
      WF:Wallis û Futuna
      WS:Samoa
      XA:Aksanên Psodoyê
      XB:Psodo Bidî
      XK:Kosova
      YE:Yemen
      YT:Mayotte
      ZA:Afrîkaya Başûr
      ZM:Zambîya
      ZW:Zîmbabwe
      ZZ:Herêma Nenas
      """.trimIndent() }

  val kw: String by lazy { """
      GB:Rywvaneth Unys
      """.trimIndent() }

  val kxv: String by lazy { """
      001:raji, purti
      419:laṭin amerika
      AD:ānḍorā
      AE:aanḍiti arab emireṭs
      AF:aapganistan
      AG:eṇṭigaa aḍe barbuḍaa
      AI:anguila
      AL:albania
      AM:aarmenia
      AO:angola
      AQ:ānṭarkṭikā
      AR:aarhenṭina
      AS:amerikati samva
      AT:austria
      AU:astrelia
      AW:aruba
      AX:eleṇḍ dīp
      AZ:ajerbaijan
      BA:bajnia aḍe hertsegovina
      BB:barbaḍos
      BD:banglades
      BE:beljiym
      BF:burkina paso
      BG:bulgaria
      BH:bāren
      BI:buruṇḍī
      BJ:benīn
      BL:se barṭelemi
      BM:bermuḍā
      BN:brunae
      BO:boliviā
      BQ:karibiyn nedrlends
      BR:brājil
      BS:bāhāmās
      BT:buṭān
      BW:boṭsvana
      BY:belarūs
      BZ:belīj
      CA:kanaḍa
      CC:kokos keling dīp
      CD:kongo - kinsasa
      CF:madini aaprika republik
      CG:kongo - brajavil
      CH:svitjerlaṇḍ
      CI:koṭ ḍi vaa
      CK:kuk dīp
      CL:cili
      CM:kemarun
      CN:caina
      CO:kolmbiaa
      CR:kosta rika
      CU:kyuba
      CV:kep vrḍi
      CW:kyurasao
      CX:kristmas dīp
      CY:saipras
      CZ:cekiya
      DE:jermanī
      DG:ḍiego garsia
      DJ:jibutī
      DK:ḍenmark
      DM:dominika
      DO:dominikan republik
      DZ:aljīriaa
      EA:seuṭa aḍe melila
      EC:ekvaḍor
      EE:esṭoniya
      EG:ījipṭ
      EH:vedakuṇpu sahara
      ER:īriṭriaa
      ES:spein
      ET:ītiyopiya
      FI:pinlaṇd
      FJ:piji
      FK:paklaṇd dīp
      FM:micronesiaa
      FO:pēro dīp
      FR:prans
      GA:gbon
      GB:uniṭeḍ kingḍom
      GD:graneida
      GE:jeorjiaa
      GF:prenc guiyana
      GG:grnse
      GH:gana
      GI:jbralṭr
      GL:grīnlanḍ
      GM:gambia
      GN:gini
      GP:gvadelup
      GQ:ikveṭorial gini
      GR:grīs
      GS:dakiṇ jārjiā aḍe dakiṇ sandwich dīp
      GT:gvaṭemala
      GU:guām
      GW:gini-bisau
      GY:guyana
      HK:hong kong (sar) caina
      HN:honḍuras
      HR:kroesia
      HT:haiti
      HU:hungarī
      IC:kanari dīp
      ID:inḍonesiya
      IE:aayarlanḍ
      IL:israel
      IM:aail āp man
      IN:inḍiā
      IO:briṭis inḍiāti samudra handi
      IQ:irak
      IR:iran
      IS:aislanḍ
      IT:iṭalī
      JE:jersī
      JM:jamaika
      JO:jorḍan
      JP:japan
      KE:kenya
      KG:kirgistan
      KH:kamboḍia
      KI:kiribaṭi
      KM:komoros
      KN:seint kiṭs āḍe nebis
      KP:uttar koriya
      KR:dkiṇ koriyaa
      KW:kuvet
      KY:keimen dīp
      KZ:kajakstan
      LA:laos
      LB:lebanon
      LC:seint lusiya
      LI:likṭensṭein
      LK:sri lanka
      LR:laiberīya
      LS:lesotho
      LT:liṭuaania
      LU:lksemborg
      LV:laṭviya
      LY:libya
      MA:morkko
      MC:monako
      MD:molḍovaa
      ME:monṭenegro
      MF:seint martin
      MG:madagascar
      MH:marsall dīp
      MK:uttar mesiḍoniya
      ML:mali
      MM:myanmar (brma)
      MN:mongolia
      MO:makao sar cina
      MP:uttar mariyana dīp
      MQ:marṭinik
      MR:mauriṭaniya
      MS:monṭserrarṭ
      MT:malṭaa
      MU:mauriss
      MV:māldīp
      MW:malavī
      MX:meksīko
      MY:maleseāā
      MZ:mojambik
      NA:namibia
      NC:nyu keleḍoniya
      NE:naījr
      NF:norpok dīp
      NG:naigeria
      NI:nikaraguaa
      NL:nederlanḍs
      NO:norvay
      NP:nepal
      NR:nauru
      NU:niyu
      NZ:nyu jīlanḍ
      OM:oman
      PA:panema
      PE:peru
      PF:prenc
      PG:papua nyu gini
      PH:pilippines
      PK:pakistan
      PL:polanḍ
      PM:seint pierri ande mikelon
      PN:piṭkarn dīp
      PR:puerto rico
      PS:palesṭiati handi
      PT:portugal
      PW:palau
      PY:pareguvai
      QA:katar
      RE:riyuniyn
      RO:romaniya
      RS:serbia
      RU:russia
      RW:rvanḍa
      SA:saūdi arabiya
      SB:soloman dīp
      SC:siselles
      SD:suḍan
      SE:sviḍen
      SG:singapor
      SH:seint helena
      SI:slovenia
      SJ:svalbard aḍe jan mayen
      SK:slovakia
      SL:sierra leyon
      SM:san marino
      SN:senegal
      SO:somaliya
      SR:surīname
      SS:dkiṇ sūdan
      ST:sao tom aḍe prinsipe
      SV:el salvador
      SX:sint mārṭen
      SY:sīriya
      SZ:esvaṭini
      TC:turks aḍe keikes dīp
      TD:cad
      TF:prēnch dakiṇ teritorī
      TG:ṭogo
      TH:tailanḍ
      TJ:tajākīstān
      TK:ṭokelau
      TL:ṭimor - leste
      TM:turkmenīstān
      TN:ṭunisiaa
      TO:ṭonga
      TR:turkī
      TT:ṭriniḍaḍ aḍe ṭobego
      TV:tuvala
      TW:taivan
      TZ:ṭanjaniya
      UA:yūkrain
      UG:yūganḍa
      UM:yu.es. aautlaing dīp
      US:yunaiṭeḍ stets
      UY:ūrugve
      UZ:ūjbekistaan
      VA:bāṭikān
      VC:seint vinseṇṭ aḍe grenaḍi
      VE:venejuela
      VG:briṭis vrjin dīp
      VI:yu.es. vrjin dīp
      VN:viyetnam
      VU:vanuaatu
      WF:vallis aḍe puṭuna
      WS:samoaa
      XK:kosovo
      YE:yemen
      YT:mayoṭṭ
      ZA:dkīṇ aaprika
      ZM:jambiya
      ZW:jimbabve
      """.trimIndent() }

  val kxv_Deva: String by lazy { """
      001:राजि, पृती
      419:लातिन आमेरिका ति
      AD:अंडोरा
      AE:आण्डी ति अरब एमिरेट्स
      AF:अप़गानिस्तान
      AG:एंटिगुआ ऑड़े बरबुडा
      AI:एंग्विला
      AL:अल्बानिया
      AM:आर्मेनिया
      AO:अंगोला
      AQ:अंटार्कटिका
      AR:अर्जेंटीना
      AS:आमेरिका-ति समोआ
      AT:ऑस्ट्रिया
      AU:ऑस्ट्रेलिया
      AW:अरूबा
      AX:एलेंड द्वीप
      AZ:अज़रबेजान
      BA:बोस्निया ऑड़े हर्ज़ेगोविना
      BB:बारबाडोस
      BD:बांग्लादेस
      BE:बेल्जियम
      BF:बुर्किना प़ासो
      BG:बुल्गारिया
      BH:बहरीन
      BI:बुरुंडी
      BJ:बेनिन
      BL:सेंट बार्तेलेमी
      BM:बरमूडा
      BN:ब्रूनेई
      BO:बोलीविया
      BQ:केरिबियन नीदरलेंड
      BR:ब्राज़ील
      BS:बहामास
      BT:बुटान
      BW:बोत्स्वाना
      BY:बेलारूस
      BZ:बेलीज़
      CA:कानाडा
      CC:कोकोस (कीलिंग) द्वीप
      CD:कांगो - किंसासा
      CF:मध्य अप़्रीकी गणराज्य
      CG:कांगो – ब्राज़ाविल
      CH:स्विट्ज़रलेंड
      CI:कोट डी वोआ
      CK:कुक द्वीप
      CL:चिली
      CM:केमरून
      CN:चीन
      CO:कोलंबिया
      CR:कोस्टारिका
      CU:क्यूबा
      CV:केप वर्ड
      CW:क्यूरासाओ
      CX:क्रिसमस द्वीप
      CY:साइप्रस
      CZ:चेकिया
      DE:जर्मनी
      DG:डिएगो गार्सिया
      DJ:जिबूती
      DK:डेनमार्क
      DM:डोमिनिका
      DO:डोमिनिकन गणराज्य
      DZ:अल्जीरिया
      EA:सेउटा ऑड़े मेलिला
      EC:इक्वाडोर
      EE:एस्टोनिया
      EG:मिस्र
      EH:वेड़ा कुण्पु सहारा
      ER:इरिट्रिया
      ES:स्पेन
      ET:इतियोपिया
      FI:प़िनलेंड
      FJ:प़िजी
      FK:प़ॉकलेंड द्वीप
      FM:माइक्रोनेसिया
      FO:पेरो दीप
      FR:प़्रांस
      GA:ग्याबॉन
      GB:यूनाइटेड किंगडम
      GD:ग्रेनाडा
      GE:जॉर्जिया
      GF:प़्रेंच गुयाना
      GG:गर्नसी
      GH:गाना
      GI:जिब्राल्टर
      GL:ग्रीनलेंड
      GM:गाम्बिया
      GN:गिनी
      GP:ग्वाडेलूप
      GQ:इक्वेटोरियल गिनी
      GR:यूनान
      GS:दकिण जॉर्जिया अड़े दकिण सैंडविच दीप
      GT:ग्वाटेमाला
      GU:गुआम
      GW:गिनी-बिसाउ
      GY:गुयाना
      HK:हाँग काँग (एस ए आर चीन)
      HN:होंडूरास
      HR:क्रोएसिया
      HT:हाइती
      HU:हंगरी
      IC:केनेरी द्वीप
      ID:इंडोनेसिया
      IE:आयरलेंड
      IL:इज़राइल
      IM:आइल ऑप़ मेन
      IN:बारत
      IO:ब्रिटिस हिंद सामुद्रि हांडि
      IQ:इराक
      IR:ईरान
      IS:आइसलेंड
      IT:इटली
      JE:जर्सी
      JM:जमेका
      JO:जॉर्डन
      JP:जापान
      KE:केन्या
      KG:किर्गिज़स्तान
      KH:कंबोडिया
      KI:किरिबाती
      KM:कोमोरोस
      KN:सेंट किट्स ऑड़े नेविस
      KP:उतर कोरिया
      KR:दॉकिण कोरिया
      KW:कुवेत
      KY:केमेन द्वीप
      KZ:कज़ाकस्तान
      LA:लाओस
      LB:लेबनान
      LC:सेंट लूसिया
      LI:लिक्टेन्स्टीन
      LK:स्रीलंका
      LR:लाइबेरिया
      LS:लेसोतो
      LT:लितुआनिया
      LU:लग्ज़मबर्ग
      LV:लातविया
      LY:लीबिया
      MA:मोरक्को
      MC:मोनाको
      MD:मॉल्डोवा
      ME:मोंटेनेग्रो
      MF:सेंट मार्टिन
      MG:मेडागास्कर
      MH:मार्सल द्वीप
      MK:उतॉरॉ मकदूनिया
      ML:माली
      MM:म्यांमार (बर्मा)
      MN:मंगोलिया
      MO:मकाऊ (एस ए आर चीन)
      MP:उतॉरॉ मारियाना द्वीप
      MQ:मार्टीनिक
      MR:मॉरिटानिया
      MS:मोंटसेरात
      MT:माल्टा
      MU:मॉरीसस
      MV:मालदीप
      MW:मलावी
      MX:मेक्सिको
      MY:मलेसिया
      MZ:मोज़ांबिक
      NA:नामीबिया
      NC:न्यू केलेडोनिया
      NE:नाइजर
      NF:नॉरप़ॉक द्वीप
      NG:नाइजीरिया
      NI:निकारागुआ
      NL:नीदरलेंड
      NO:नॉर्वे
      NP:नेपाल
      NR:नाउरु
      NU:नीयू
      NZ:न्यूज़ीलेंड
      OM:ओमान
      PA:पनामा
      PE:पेरू
      PF:प़्रेंच पोलिनेसिया
      PG:पापुआ न्यू गिनी
      PH:प़िलिपींस
      PK:पाकिस्तान
      PL:पोलेंड
      PM:सेंट पिएरे ऑड़े मिक्वेलान
      PN:पिटकेर्न द्वीप
      PR:पोर्टो रिको
      PS:प़िलिस्तीनी क्षेत्र
      PT:पुर्तगाल
      PW:पलाऊ
      PY:पराग्वे
      QA:क़तर
      RE:रियूनियन
      RO:रोमानिया
      RS:सर्बिया
      RU:रूस
      RW:र्-वांडा
      SA:सऊदी अरब
      SB:सोलोमन द्वीप
      SC:सेसेल्स
      SD:सूडान
      SE:स्वीडन
      SG:सिंगापुर
      SH:सेंट हेलेना
      SI:स्लोवेनिया
      SJ:स्वालबार्ड ऑड़े जान मायेन
      SK:स्लोवाकिया
      SL:सिएरा लियोन
      SM:सेन मेरीनो
      SN:सेनेगल
      SO:सोमालिया
      SR:सूरीनाम
      SS:दॉकिण सूडान
      ST:साओ टोम ऑड़े प्रिंसिपे
      SV:अल सल्वाडोर
      SX:सिंट माऽरतेन
      SY:सीरिया
      SZ:एस्वाटिनी
      TC:तुर्क ऑड़े केकोज़ द्वीप
      TD:चाड
      TF:प्रेंच दकिनी टेरिटोरी
      TG:टोगो
      TH:ताईलेंड
      TJ:तजाकिस्तान
      TK:तोकेलाउ
      TL:तिमोर-लेस्त
      TM:तुर्कमेनिस्तान
      TN:ट्यूनीसिया
      TO:टोंगा
      TR:तुर्की
      TT:त्रिनिदाद ऑड़े टोबेगो
      TV:तुवालू
      TW:ताइवान
      TZ:तंज़ानिया
      UA:यूक्रेन
      UG:युगांडा
      UM:यू॰एस॰ आउटलाइंग द्वीप
      US:आण्डि ति राज्यॉ
      UY:उरूग्वे
      UZ:उज़्बेकिस्तान
      VA:बाटिकान सिटी
      VC:सेंट विंसेंट ऑड़े ग्रेनाडाइंस
      VE:वेनेज़ुएला
      VG:ब्रिटिस वर्जिन द्वीप
      VI:यू॰एस॰ वर्जिन द्वीप
      VN:वियतनाम
      VU:वनुआतू
      WF:वालिस ऑड़े प़्यूचूना
      WS:समोआ
      XK:कोसोवो
      YE:यमन
      YT:मायोते
      ZA:दॉकिण आप़्रीका
      ZM:ज़ाम्बिया
      ZW:ज़िम्बाब्वे
      """.trimIndent() }

  val kxv_Latn: String? = null

  val kxv_Orya: String by lazy { """
      419:ଲାଟିନ୍‌ ଆମେରିକା
      AD:ଆଣ୍ଡୋରା
      AE:ଆଣ୍ଡିତି ଆରବ ଏମିରେଟସ୍
      AF:ଆପଗାନିସ୍ତାନ୍
      AG:ଏଣ୍ଟିଗୁଆ ଅଡ଼େ ବାରବୁଦା
      AI:ଏଙ୍ଗ୍ୱିଲା
      AL:ଆଲବାନିଆ
      AM:ଆର୍ମେନିଆ
      AO:ଅଙ୍ଗଲା
      AQ:ଆଣ୍ଟାର୍କଟିକା
      AR:ଅର୍ଜେଣ୍ଟିନା
      AS:ଅମେରିକା ତି ସମୱା
      AT:ଅଷ୍ଟ୍ରିଆ
      AU:ଅଷ୍ଟ୍ରେଲିଆ
      AW:ଅରୁବା
      AX:ଏଲେଣ୍ଡ
      AZ:ଅଜେର୍‍‍ବାଇଜାନ୍
      BA:ବସ୍ନିଆ ଅଡ଼େ ହର୍ଜଗୱିନା
      BB:ବାର୍‍ବଡସ
      BD:ବାଂଲାଦେଶ
      BE:ବେଲଜିୟମ୍
      BF:ବୁର୍କିନା ପାସ୍ୱ
      BG:ବୁଲ୍‍ଗାରିଆ
      BH:ବହରେନ୍
      BI:ବୁରୁନ୍ଦି
      BJ:ବେନିନ୍
      BL:ସେଣ୍ଟ ବାର୍ତେଲେମି
      BM:ବର୍‍ମୁଣ୍ଡା
      BN:ବ୍ରୂନେଇ
      BO:ବଲିୱିୟା
      BQ:କାରିବିୟନ ନେଦରଲ୍ୟାଣ୍ଡସ୍
      BR:ବ୍ରାଜିଲ୍
      BS:ବାହାମାସ୍
      BT:ବୁଟାନ
      BW:ବସ୍ଟୱାନା
      BY:ବେଲାରୂସ୍
      BZ:ବେଲିଜ୍
      CA:କାନାଡା
      CC:କକସ୍ (କିଲିଂ) ଦିପ
      CD:କଙ୍ଗ-କିଂସାସା
      CF:ମାଦିନି ଆପ୍ରିକା ରିପବ୍ଲିକ୍
      CG:କଂଙ୍ଗ- ବ୍ରାଜାୱିଲି
      CH:ସ୍ୱୀଜଅର୍‍ଲାଣ୍ଡ
      CI:କଟ ଡି ୱା
      CK:କୁକ ଦିପ
      CL:ଚିଲି
      CM:କାମେରନ୍
      CN:ଚିନ୍
      CO:କଲମ୍ବିଆ
      CR:କସ୍ଟା ରିକା
      CU:କ୍ୟୁବା
      CV:କେପ୍ ୱଡ଼
      CW:କ୍ୟୁରାସାଅ
      CX:କ୍ରିସ୍ଟମାସ୍ ଦିପ
      CY:ସାଇପ୍ରସ୍
      CZ:ଚେକିଆ
      DE:ଜର୍ମାନି
      DG:ଡିଏଗ ଗାର୍ସିଆ
      DJ:ଜିବୁତି
      DK:ଡେନମାର୍କ
      DM:ଡମିନିକା
      DO:ଡମିନିକା ତି ରିପବ୍ଲିକ୍
      DZ:ଅଲଜେରିଆ
      EA:ସେଅଟା ଅଡ଼େ ମେଲିଲା
      EC:ଇକ୍ୱାଡର
      EE:ଏସ୍ଟନିଆ
      EG:ଇଜିପ୍ଟ
      EH:ୱେଡ଼ାକୁଣ୍ପୁ ସାହାରା
      ER:ଇରିଟ୍ରିଆ
      ES:ସ୍ପେନ୍
      ET:ଇତିୟପିଆ
      FI:ପିନ୍‍ଲାଣ୍ଡ
      FJ:ପିଜି
      FK:ପାକ୍‍ଲାଣ୍ଡ ଦିପ
      FM:ମାକ୍ରନେସିଆ
      FO:ପେରୋ ଦୀପ
      FR:ପ୍ରାନ୍ସ
      GA:ଗାବନ
      GB:ଇଉନାଇଟେଡ୍ କିଂଡମ୍
      GD:ଗ୍ରେନାଡା
      GE:ଜର୍ଜିଆ
      GF:ପ୍ରେଞ୍ଚ୍ ଗୁୟାନା
      GG:ଗର୍ନସି
      GH:ଗାନା
      GI:ଜିବ୍ରାଲଟର
      GL:ଗ୍ରୀନ୍ ଲାଣ୍ଡ
      GM:ଗାମ୍ବିଆ
      GN:ଗିନି
      GP:ଗ୍ୱାଡେଲୁପ
      GQ:ଇକ୍ୟୁଏଟେରିୟଲ ଗିନି
      GR:ଗ୍ରିସ୍
      GS:ଦକିନ ଜର୍ଜିଆ ଅଡ଼େ ଦକିନ ସାଣ୍ଡୱିଚ୍ ଦୀପ
      GT:ଗ୍ୱାଟେମାଲା
      GU:ଗୁଆମ୍
      GW:ଗିନି ବିସାଉ
      GY:ଗୁୟାନା
      HK:ହଂଗ କଂଗ (ଏସଏଆର୍ ଚିନା)
      HN:ହଣ୍ଡୁରାସ
      HR:କ୍ରସିଆ
      HT:ହାଇତି
      HU:ହଙ୍ଗେରି
      IC:କେନାରି ଦିପ
      ID:ଇଣ୍ଡନେସିୟା
      IE:ଅଇରଲାଣ୍ଡ
      IL:ଇସରାଇଲ
      IM:ମାଣିସି ତା ଦିପ
      IN:ବାରତ
      IO:ବ୍ରିଟିସ୍ ହିନ୍ଦ ସାମୁଦ୍ରି ହାନ୍ଦି
      IQ:ଇରାକ
      IR:ଇରାନ
      IS:ଆଇସଲାଣ୍ଡ
      IT:ଇଟାଲି
      JE:ଜରସି
      JM:ଜାମାଇକା
      JO:ଜର୍ଡାନ
      JP:ଜାପାନ
      KE:କେନ୍ୟା
      KG:କିରଗିସ୍ତାନ
      KH:କମ୍ବଡିଆ
      KI:କିରିବାତି
      KM:କମରସ
      KN:ସେଣ୍ଟ. କିଟ୍ସ ଅଡ଼େ ନେବିସ
      KP:ଉତର କରିୟା
      KR:ଦକିଣ କରିୟା
      KW:କୁୱେତ୍
      KY:କାଇମାନ ଦିପ
      KZ:କାଜାକସ୍ତାନ
      LA:ଲାଅସ୍
      LB:ଲେବନାନ
      LC:ସେଣ୍ଟ. ଲୁସିଆ
      LI:ଲିକ୍‍ଟନ୍‍ସ୍ଟାଇନ୍
      LK:ସ୍ରି ଲଙ୍କା
      LR:ଲାଇବେରିଆ
      LS:ଲେସତ
      LT:ଲିତୁଆନିଆ
      LU:ଲଗ୍ଜମବର୍ଗ
      LV:ଲାତ୍‍ୱିୟା
      LY:ଲିବିୟା
      MA:ମରକ
      MC:ମନାକ
      MD:ମଲ୍‍ଡୱା
      ME:ମଣ୍ଟେନେଗ୍ର
      MF:ସେଣ୍ଟ ମାର୍ଟିନ
      MG:ମାଡ଼ାଗାସ୍କାର
      MH:ମାର୍ସାଲ ଦିପ
      MK:ଉତର ମାସାଡନିୟା
      ML:ମାଲି
      MM:ମିୟାଁମାର (ବର୍ମା)
      MN:ମଙ୍ଗଲିୟା
      MO:ମକାଉ ଏସଏଆର ଚିନା
      MP:ଉତର ମାରିୟାନ ଦିପ
      MQ:ମାର୍ଟିନିକ୍
      MR:ମଉରିଟାନିୟା
      MS:ମଣ୍ଟସେରେଟ
      MT:ମାଲ୍ଟା
      MU:ମରିସସ୍
      MV:ମାଲଦୀପି
      MW:ମଲାୱି
      MX:ମେକ୍ସିକ
      MY:ମାଲେସିଆ
      MZ:ମଜାମ୍ବିକ
      NA:ନାମିବିୟା
      NC:ନ୍ୟୁ କେଲେଡନିୟା
      NE:ନାଇଜର
      NF:ନର୍‍ପକ୍ ଦିପ
      NG:ନାଇଜେରିଆ
      NI:ନିକାରଗୁଆ
      NL:ନେଦରଲାଣ୍ଡ
      NO:ନରୱେ
      NP:ନେପାଲ
      NR:ନାଉରୁ
      NU:ନିୟୁ
      NZ:ନିୟୁଜିଲାଣ୍ଡ
      OM:ଅମାନ
      PA:ପନମା
      PE:ପେରୁ
      PF:ପ୍ରେଞ୍ଚ୍ ପଲିନେସିୟା
      PG:ପପୁଆ ନିୟୁ ଗିନି
      PH:ପିଲିପାଇନ୍ସ
      PK:ପାକିସ୍ତାନ
      PL:ପଲାଣ୍ଡ
      PM:ସେଣ୍ଟ ପିଏରେ ଅଡ଼େ ମିକ୍ୱେଲାନ
      PN:ପିଟ୍‍କଇର୍ନ୍ ଦିପ
      PR:ପର୍ଟ ରିକ
      PS:ପାଲେସ୍ଟିଆତି ହାନ୍ଦି
      PT:ପର୍ତୁଗାଲ
      PW:ପଲାଉ
      PY:ପରଗ୍ୱେ
      QA:କତର
      RE:ରିୟୁନିୟନ
      RO:ରମାନିଆ
      RS:ସର୍ବିୟା
      RU:ରୁସିଆ
      RW:ର୍‍ୱାଣ୍ଡା
      SA:ସାଉଦି ଆରବ
      SB:ସଲମନ ଦିପ
      SC:ସିସେଲ୍ସ
      SD:ସୁଡାନ
      SE:ସ୍ୱିଡେନ
      SG:ସିଙ୍ଗାପୁର
      SH:ସେଣ୍ଟ ହେଲେନ
      SI:ସ୍ଲବେନିଆ
      SJ:ସ୍ୱାଲବାର୍ଡ ଅଡ଼େ ଜାନ ମାୟେନ
      SK:ସ୍ଲବାକିୟା
      SL:ସିଏରା ଲିୟନ
      SM:ସନ ମାରିନ
      SN:ସେନେଗାଲ
      SO:ସମାଲିଆ
      SR:ସୁରିନାମ
      SS:ଦକିଣ ସୁଡାନ
      ST:ସାଅ ଟମ ଅଡ଼େ ପ୍ରିନ୍ସିପେ
      SV:ଅଲ ସଲବାଡର
      SX:ସିଣ୍ଟ ମାର୍ଟିନ
      SY:ସିରିୟା
      SZ:ଏସ୍ୱାଟିନି
      TC:ତୁର୍କ ଅଡ଼େ କାଇକସ ଦିପ
      TD:ଚାଡ
      TF:ପ୍ରେଞ୍ଚ ଦକିନୀୟ ଟେରିଟୋରୀ
      TG:ଟଗ
      TH:ତାଇଲାଣ୍ଡ
      TJ:ତାଜିକିସ୍ତାନ
      TK:ତକେଲାଉ
      TL:ତିମର-ଲେସ୍ତେ
      TM:ତୁର୍କମେନିସ୍ତାନ
      TN:ଟ୍ୟୁନିସିୟା
      TO:ଟଙ୍ଗ
      TR:ତୁର୍କି
      TT:ତ୍ରିନିଡାଡ ଅଡ଼େ ଟବାଗ
      TV:ତୁୱାଲୁ
      TW:ତାଇୱାନ
      TZ:ତାଞ୍ଜାନିୟା
      UA:ୟୁକ୍ରେନ୍
      UG:ଉଗାଣ୍ଡା
      UM:ୟୁ ଏସ୍ ଆଉଟଲାଇଙ୍କ ଦିପ
      US:ଆଣ୍ଡିତି ରାଜ୍ୟ
      UY:ଉରୁଗ୍ୱେ
      UZ:ଉଜବେକିସ୍ତାନ
      VA:ବାଟିକାନ୍ ସିଟି
      VC:ସେଣ୍ଟ ୱିନସେଣ୍ଟ ଅଡ଼େ ଗ୍ରିନାଡାଇନ୍ସ
      VE:ୱେନେଜୁଏଲ
      VG:ବ୍ରିଟିସ୍ ୱିରଜିନ ଦିପ
      VI:ୟୁ ଏସ ୱିରଜିନ ଦିପ
      VN:ୱିଏତନାମ
      VU:ୱାନୁଆତୁ
      WF:ୱାଲିସ ଅଡ଼େ ପୁଟୁନା
      WS:ସମୱା
      XK:କସୱ
      YE:ୟମନ
      YT:ମାୟତେ
      ZA:ଦକିଣ ଆପ୍ରିକା
      ZM:ଜାମ୍ବିୟା
      ZW:ଜିମ୍ବାୱେ
      """.trimIndent() }

  val kxv_Telu: String by lazy { """
      001:ప్రపంచం
      419:లాటిన్ ఆమెరిక
      AD:ఆండొర
      AE:యునైటెడ్ ఆరబ్ ఎమిరేబ్స్
      AF:ఆప్గనిస్తాన్
      AG:ఆంటిగ్వా మరియు బార్బుడా
      AI:ఆంగ్విల్లా
      AL:ఆల్లేనియా
      AM:ఆర్మేనియా
      AO:ఆంగోలా
      AQ:ఆంటార్కటికా
      AR:ఆర్జెంటినా
      AS:ఆమెరికన్ సమూవా
      AT:ఆస్ట్రీయా
      AU:ఆస్ట్రేలియా
      AW:ఆరుబా
      AX:ఆలాండ్ దీపులు
      AZ:ఆజర్బైజాన్
      BA:బోస్నియా మరియు బెర్జిగోవినా
      BB:బార్బడోస్
      BD:బంగ్లాదేస్
      BE:బెల్జియం
      BF:బుర్కినా పాసో
      BG:బుల్గేరియ
      BH:బహరిన్
      BI:బురుండి
      BJ:బెనిన్
      BL:సెంట్ బర్తెలిమి
      BM:బర్ముడా
      BN:బ్రునేఇ
      BO:బొలివియా
      BQ:కరీబియన్ నెదర్లాండ్స
      BR:బ్రాజిల్
      BS:బహామాస్
      BT:బుటాన్
      BW:బోట్స్వానా
      BY:బెలారస్
      BZ:బెలిజ్
      CA:కెనడా
      CC:కోకోస్ (కీలింగ్) దీవులు
      CD:కాంగో కిన్సాసా
      CF:సెంట్రల్ ఆప్రికన్ రిపబ్లిక్
      CG:కాంగో- బ్రాజావిల్లి
      CH:స్విజర్లాండ్
      CI:కోట్ డి ఐవోర్
      CK:కుక్ దీపులు
      CL:చిలి
      CM:కామెరూన్
      CN:చినా
      CO:కొలంబియా
      CR:కోస్టా రికా
      CU:క్యూబా
      CV:కేప్ వడ్
      CW:క్వురసో
      CX:క్రిస్ట మాస్ దీపుపు
      CY:సైప్రస్
      CZ:చెకియా
      DE:జర్మనీ
      DG:డియాగో గార్సియా
      DJ:జిబుతి
      DK:డెన్మార్క
      DM:డొమినికా
      DO:డొమినికాన్ రిపబ్లిక్
      DZ:ఆల్జిరియా
      EA:స్యూటా & మెలిల్లా
      EC:ఈక్వడార్
      EE:ఎస్టోనియా
      EG:ఈజిప్ట్
      EH:పడమటి సహారా
      ER:ఇరిట్రియా
      ES:స్పెన్
      ET:ఇతియోపియా
      FI:పిన్లాండ్
      FJ:పిజీ
      FK:ఫాక్‌ల్యాండ్ దీవులు
      FM:మైక్రోనేసియా
      FO:పెరొ దీప
      FR:ప్రాన్స్
      GA:గాబన్
      GB:యునైటెడ్ కింగ్‌డమ్
      GD:గ్రెనడా
      GE:జార్జియా
      GF:ప్రెంచ్ గుయానా
      GG:గర్నసీ
      GH:గనా
      GI:జిబ్రాల్టర్
      GL:గ్రీన్లండ్
      GM:గంబియా
      GN:గినియా
      GP:గ్వడెలుప్
      GQ:ఈక్వటోరియల్ గినియా
      GR:గ్రీస్
      GS:దకిన జర్జిఆ అదే దకిన సండవిచ్ దిప
      GT:గ్వటెమాలా
      GU:గ్వమ్
      GW:గినియా-బిస్సావ్
      GY:గుయానా
      HK:హాంకాంగ్ ఎస్ఎఆర్ చినా
      HN:హండురాస్
      HR:క్రొయేసియా
      HT:హైటి
      HU:హంగేరీ
      IC:కేనరీ దీపులు
      ID:ఇండోనేసియా
      IE:ఐర్లాండ్
      IL:ఇజ్రాయెల్
      IM:ఐల్ ఆప్ మాన్
      IN:బారతదెసాం
      IO:బ్రిటిస్ హీందూ మహాసముద్ర ప్రాంతం
      IQ:ఇరాక్
      IR:ఇరాన్
      IS:ఐస్లాండ్
      IT:ఇటలి
      JE:జెర్సీ
      JM:జమైకా
      JO:జోర్డాన్
      JP:జపాన్
      KE:కెన్యా
      KG:కిర్గజిస్తాన్
      KH:కంబోడియా
      KI:కీరిబాటి
      KM:కొమొరోస్
      KN:సెయింట్ కిట్స్ మరియు నెవిస్
      KP:ఉత్తర కొరియా
      KR:దకిణ కొరియా
      KW:కువైట్
      KY:కేమాన్ దీపులు
      KZ:కజకిస్తాన్
      LA:లావోస్
      LB:లెబనాన్
      LC:సెయింట్ లూసియా
      LI:లిక్టెన్‌స్టెయిన్
      LK:స్రీ లంక
      LR:లైబీరియా
      LS:లెసోతో
      LT:లీతువేనియ
      LU:లక్సెంబర్గ్
      LV:లాత్వియా
      LY:లిబియా
      MA:మొరాకో
      MC:మొనాకో
      MD:మోల్డొవా
      ME:మాంటెనెగ్రో
      MF:సెయింట్ మార్టిన్
      MG:మడగాస్కర్
      MH:మార్సాల్ దీపులు
      MK:ఉత్తర మాసిడోనియా
      ML:మాలి
      MM:మయన్మార్ (బర్మా)
      MN:మంగోలియా
      MO:మకావ్ ఎస్ఏఆర్ చైనా
      MP:ఉత్తర మరియానా దీవులు
      MQ:మార్ర్టనీక్
      MR:మౌరిటేనియా
      MS:మాంట్సెరాట్
      MT:మాల్డా
      MU:మారిసస్
      MV:మాలదిపి
      MW:మలావీ
      MX:మెక్సికో
      MY:మలేసియా
      MZ:మొజాంబిక్
      NA:నమీబియా
      NC:క్రొత్త కెలెడోనియా
      NE:నఇజర్
      NF:నార్పోక్ దీవ
      NG:నౌజీరియా
      NI:నికరాగువా
      NL:నెదర్లాండ్స్
      NO:నార్వే
      NP:నేపాల్
      NR:నౌరు
      NU:నియూ
      NZ:న్యూజిలాండ్
      OM:ఓమన్
      PA:పనామా
      PE:పెరూ
      PF:ప్రెంచ్ పోలినిసియా
      PG:పాపువా న్యూ గనియా
      PH:పిలిప్పైన్స్
      PK:పాకిస్తాన్
      PL:పోలాండ్
      PM:సెయింట్ పియెర్ మరియు మికెలాన్
      PN:పిట్‌కెయిర్న్ దీవులు
      PR:ప్యూర్టో రికో
      PS:పాలస్తీనియన్ ప్రాంతాలు
      PT:పోర్చుగల్
      PW:పాలావ్
      PY:పరాగ్వే
      QA:కతార
      RE:రీయూనియన్
      RO:రోమేనియా
      RS:సెర్బియా
      RU:రస్యా
      RW:రువాండా
      SA:సౌదీ అరేబియా
      SB:సోలమన్ దీవులు
      SC:సీషెల్స్
      SD:సూడాన్
      SE:స్వీడన్
      SG:సింగపూర్
      SH:సెయింట్ హెలెనా
      SI:స్లోవేనియా
      SJ:స్వాల్‌బార్డ్ మరియు జాన్ మాయెన్
      SK:స్లొవేకియా
      SL:సియెర్రా లియాన్
      SM:సస్ మారిసో
      SN:సెనెగల్
      SO:సోమలియా
      SR:సూరినామ్
      SS:దక్షిణ సూడాన్
      ST:సావో టోమ్ మరియు ప్రిన్సిపి
      SV:ఎల్ సాల్వడోర్
      SX:సింట్ మార్టెన్
      SY:సిరియా
      SZ:ఈస్వాటిని
      TC:టర్క్స్ మరియు కైకోస్ దీవులు
      TD:చాద్
      TF:ప్రెంచ్ దకినియ టెరిటొరి
      TG:టోగో
      TH:తయిలాండ్
      TJ:తాజాకిస్తాన
      TK:టోకెలావ్
      TL:టిమోర్-లెస్టె
      TM:తుర్క్‍మెనిస్తన్
      TN:ట్యునీషియా
      TO:టోంగా
      TR:టర్కీ
      TT:ట్రినిడాడ్ మరియు టొబాగో
      TV:టువాలు
      TW:తైవాన్
      TZ:టాంజానియా
      UA:ఉక్రెయిన్
      UG:ఉగాండా
      UM:సంయుక్త రాజ్య అమెరికా బయట ఉన్న దీవులు
      US:యునైటెడ్ స్టేట్స్
      UY:ఉరుగ్వే
      UZ:ఉజ్బెకిస్తాన్
      VA:బాటికాన్ సిటి
      VC:సెయింట్ విన్సెంట్ మరియు గ్రెనడీన్స్
      VE:వెనిజులా
      VG:బ్రిటిష్ వర్జిన్ దీవులు
      VI:యు.ఎస్. వర్జిన్ దీవులు
      VN:వియత్నాం
      VU:వనాటు
      WF:వాల్లిస్ మరియు ఫుటునా
      WS:సమోవా
      XK:కొసోవో
      YE:యెమెన్
      YT:మాయొట్
      ZA:దకిణ అప్రికా
      ZM:జంబియా
      ZW:జింబాబ్వే
      """.trimIndent() }

  val ky: String by lazy { """
      001:Дүйнө
      002:Африка
      003:Түндүк Америка
      005:Түштүк Америка
      009:Океания
      011:Батыш Африка
      013:Борбордук Америка
      014:Чыгыш Африка
      015:Түндүк Африка
      017:Борбордук Африка
      018:Түштүк Африка
      019:Америка
      021:Түндүк Америка (чөлкөм)
      029:Кариб аралдары
      030:Чыгыш Азия
      034:Түштүк Азия
      035:Түштүк-Чыгыш Азия
      039:Түштүк Европа
      053:Австралазия
      054:Меланезия
      057:Микронезия чөлкөмү
      061:Полинезия
      142:Азия
      143:Борбор Азия
      145:Батыш Азия
      150:Европа
      151:Чыгыш Европа
      154:Түндүк Европа
      155:Батыш Европа
      202:Африка өлкөлөрү
      419:Латын Америкасы
      AC:Вознесение аралы
      AD:Андорра
      AE:Бириккен Араб Эмираттары
      AF:Афганистан
      AG:Антигуа жана Барбуда
      AI:Ангилья
      AL:Албания
      AM:Армения
      AO:Ангола
      AQ:Антарктида
      AR:Аргентина
      AS:Америкалык Самоа
      AT:Австрия
      AU:Австралия
      AW:Аруба
      AX:Аланд аралдары
      AZ:Азербайжан
      BA:Босния жана Герцеговина
      BB:Барбадос
      BD:Бангладеш
      BE:Бельгия
      BF:Буркина-Фасо
      BG:Болгария
      BH:Бахрейн
      BI:Бурунди
      BJ:Бенин
      BL:Сент Бартелеми
      BM:Бермуд аралдары
      BN:Бруней
      BO:Боливия
      BQ:Кариб Нидерланддары
      BR:Бразилия
      BS:Багама аралдары
      BT:Бутан
      BV:Буве аралы
      BW:Ботсвана
      BY:Беларусь
      BZ:Белиз
      CA:Канада
      CC:Кокос (Килинг) аралдары
      CD:Конго-Киншаса
      CF:Борбордук Африка Республикасы
      CG:Конго-Браззавил
      CH:Швейцария
      CI:Кот-д’Ивуар
      CK:Кук аралдары
      CL:Чили
      CM:Камерун
      CN:Кытай
      CO:Колумбия
      CP:Клиппертон аралы
      CR:Коста-Рика
      CU:Куба
      CV:Кабо-Верде
      CW:Кюрасао
      CX:Рождество аралы
      CY:Кипр
      CZ:Чехия
      DE:Германия
      DG:Диего Гарсия
      DJ:Джибути
      DK:Дания
      DM:Доминика
      DO:Доминика Республикасы
      DZ:Алжир
      EA:Сеута жана Мелилла
      EC:Эквадор
      EE:Эстония
      EG:Египет
      EH:Батыш Сахара
      ER:Эритрея
      ES:Испания
      ET:Эфиопия
      EU:Европа Биримдиги
      EZ:Еврозона
      FI:Финляндия
      FJ:Фиджи
      FK:Фолкленд аралдары
      FM:Микронезия
      FO:Фарер аралдары
      FR:Франция
      GA:Габон
      GB:Улуу Британия
      GD:Гренада
      GE:Грузия
      GF:Франция Гвианасы
      GG:Гернси
      GH:Гана
      GI:Гибралтар
      GL:Гренландия
      GM:Гамбия
      GN:Гвинея
      GP:Гваделупа
      GQ:Экватордук Гвинея
      GR:Греция
      GS:Түштүк Жоржия жана Түштүк Сэндвич аралдары
      GT:Гватемала
      GU:Гуам
      GW:Гвинея-Бисау
      GY:Гайана
      HK:Гонконг Кытай ААА
      HM:Херд жана Макдональд аралдары
      HN:Гондурас
      HR:Хорватия
      HT:Гаити
      HU:Венгрия
      IC:Канар аралдары
      ID:Индонезия
      IE:Ирландия
      IL:Израиль
      IM:Мэн аралы
      IN:Индия
      IO:Инди океанындагы Британ территориясы
      IQ:Ирак
      IR:Иран
      IS:Исландия
      IT:Италия
      JE:Жерси
      JM:Ямайка
      JO:Иордания
      JP:Жапония
      KE:Кения
      KG:Кыргызстан
      KH:Камбоджа
      KI:Кирибати
      KM:Коморос
      KN:Сент-Китс жана Невис
      KP:Түндүк Корея
      KR:Түштүк Корея
      KW:Кувейт
      KY:Кайман аралдары
      KZ:Казакстан
      LA:Лаос
      LB:Ливан
      LC:Сент-Люсия
      LI:Лихтенштейн
      LK:Шри-Ланка
      LR:Либерия
      LS:Лесото
      LT:Литва
      LU:Люксембург
      LV:Латвия
      LY:Ливия
      MA:Марокко
      MC:Монако
      MD:Молдова
      ME:Черногория
      MF:Сент-Мартин
      MG:Мадагаскар
      MH:Маршалл аралдары
      MK:Түндүк Македония
      ML:Мали
      MM:Мьянма (Бирма)
      MN:Монголия
      MO:Макао Кытай ААА
      MP:Түндүк Мариана аралдары
      MQ:Мартиника
      MR:Мавритания
      MS:Монтсеррат
      MT:Мальта
      MU:Маврикий
      MV:Мальдив
      MW:Малави
      MX:Мексика
      MY:Малайзия
      MZ:Мозамбик
      NA:Намибия
      NC:Жаңы Каледония
      NE:Нигер
      NF:Норфолк аралы
      NG:Нигерия
      NI:Никарагуа
      NL:Нидерланд
      NO:Норвегия
      NP:Непал
      NR:Науру
      NU:Ниуэ
      NZ:Жаңы Зеландия
      OM:Оман
      PA:Панама
      PE:Перу
      PF:Полинезия (франциялык)
      PG:Папуа-Жаңы Гвинея
      PH:Филиппин
      PK:Пакистан
      PL:Польша
      PM:Сен-Пьер жана Микелон
      PN:Питкэрн аралдары
      PR:Пуэрто-Рико
      PS:Палестина аймактары
      PT:Португалия
      PW:Палау
      PY:Парагвай
      QA:Катар
      QO:Алыскы Океания
      RE:Реюньон
      RO:Румыния
      RS:Сербия
      RU:Россия
      RW:Руанда
      SA:Сауд Арабиясы
      SB:Соломон аралдары
      SC:Сейшел аралдары
      SD:Судан
      SE:Швеция
      SG:Сингапур
      SH:Ыйык Елена
      SI:Словения
      SJ:Шпицберген жана Ян-Майен
      SK:Словакия
      SL:Сьерра-Леоне
      SM:Сан Марино
      SN:Сенегал
      SO:Сомали
      SR:Суринам
      SS:Түштүк Судан
      ST:Сан-Томе жана Принсипи
      SV:Эль-Сальвадор
      SX:Синт-Мартен
      SY:Сирия
      SZ:Свазиленд
      TA:Тристан-да-Кунья
      TC:Түркс жана Кайкос аралдары
      TD:Чад
      TF:Франциянын Түштүктөгү аймактары
      TG:Того
      TH:Тайланд
      TJ:Тажикстан
      TK:Токелау
      TL:Тимор-Лесте
      TM:Түркмөнстан
      TN:Тунис
      TO:Тонга
      TR:Түркия
      TT:Тринидад жана Тобаго
      TV:Тувалу
      TW:Тайвань
      TZ:Танзания
      UA:Украина
      UG:Уганда
      UM:АКШнын сырткы аралдары
      UN:БУ
      US:Кошмо Штаттар
      UY:Уругвай
      UZ:Өзбекстан
      VA:Ватикан
      VC:Сент-Винсент жана Гренадиндер
      VE:Венесуэла
      VG:Виргин аралдары (Британия)
      VI:Виргин аралдары (АКШ)
      VN:Вьетнам
      VU:Вануату
      WF:Уоллис жана Футуна
      WS:Самоа
      XA:Жасалма- Акцент
      XB:Жасалма - эки тараптуу
      XK:Косово
      YE:Йемен
      YT:Майотта
      ZA:Түштүк-Африка Республикасы
      ZM:Замбия
      ZW:Зимбабве
      ZZ:Белгисиз чөлкөм
      """.trimIndent() }

  val lag: String by lazy { """
      AD:Andóra
      AE:Ʉtemi wa Kɨaráabu
      AF:Afuganisitáani
      AG:Antigúua na Baribúuda
      AI:Anguíila
      AL:Alubánia
      AM:Ariménia
      AO:Angóola
      AR:Ajentíina
      AS:Samóoa ya Amerɨ́ka
      AT:Áusitiria
      AU:Ausiteréelia
      AW:Arúuba
      AZ:Azabajáani
      BA:Bósinia
      BB:Babadóosi
      BD:Bangaladéeshi
      BE:Ʉbeligíiji
      BF:Bukinafáaso
      BG:Buligaría
      BH:Baharéeni
      BI:Burúundi
      BJ:Beníini
      BM:Berimúuda
      BN:Burunéei
      BO:Bolívia
      BR:Brasíili
      BS:Baháama
      BT:Butáani
      BW:Botiswáana
      BY:Belarúusi
      BZ:Belíise
      CA:Kánada
      CD:Jamuhúuri ya Kɨdemokurasía ya Kóongo
      CF:Juhúuri ya Afɨrɨka ya katɨ katɨ
      CG:Kóongo
      CH:Uswíisi
      CI:Ivori Kositi
      CK:Visíiwa vya Kúuku
      CL:Chíile
      CM:Kamerúuni
      CN:Chíina
      CO:Kolómbia
      CR:Kósita Rɨ́ɨka
      CU:Kyúuba
      CV:Kepuvéede
      CY:Kupuróosi
      CZ:Jamuhúuri ya Chéeki
      DE:Ʉjerumáani
      DJ:Jibúuti
      DK:Denimaki
      DM:Domínɨka
      DO:Jamuhúuri ya Dominɨka
      DZ:Alijéria
      EC:Íkwado
      EE:Estonía
      EG:Mísiri
      ER:Eriterea
      ES:Hisipánia
      ET:Ʉhabéeshi
      FI:Ufíini
      FJ:Fíiji
      FK:Visíiwa vya Fakulandi
      FM:Mikironésia
      FR:Ʉfaráansa
      GA:Gabóoni
      GB:Ʉɨngeréesa
      GD:Girenáada
      GE:Jójia
      GF:Gwiyáana yʉ Ʉfaráansa
      GH:Gáana
      GI:Jiburálita
      GL:Giriniláandi
      GM:Gámbia
      GN:Gíine
      GP:Gwadelúupe
      GQ:Gíine Ikwéeta
      GR:Ugiríki
      GT:Gwatemáala
      GU:Gwani
      GW:Gíine Bisáau
      GY:Guyáana
      HN:Honduráasi
      HR:Koréshia
      HT:Haíiti
      HU:Hungária
      ID:Indonésia
      IE:Ayaláandi
      IL:Isiraéeli
      IN:Índia
      IQ:Iráaki
      IR:Ʉajéemi
      IS:Aisiláandi
      IT:Itália
      JM:Jamáika
      JO:Jódani
      JP:Japáani
      KE:Kéenya
      KG:Kirigisitáani
      KH:Kambódia
      KI:Kiribáati
      KM:Komóoro
      KN:Mʉtakatíifu kitisi na Nevíisi
      KP:Koréa yʉ ʉtʉrʉko
      KR:Koréa ya Saame
      KW:Kʉwáiti
      KY:Visíiwa vya Kayimani
      KZ:Kazakasitáani
      LA:Laóosi
      LB:Lebanóoni
      LC:Mʉtakatíifu Lusíia
      LI:Lishentéeni
      LK:Siriláanka
      LR:Liibéria
      LS:Lesóoto
      LT:Lisuánia
      LU:Lasembáagi
      LV:Lativia
      LY:Líbia
      MA:Moróoko
      MC:Monáako
      MD:Molidóova
      MG:Bukíini
      MH:Visíiwa vya Marisháali
      ML:Máali
      MM:Miáama
      MN:Mongólia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Maritiníiki
      MR:Moritánia
      MS:Monteráati
      MT:Málita
      MU:Moríisi
      MV:Modíivu
      MW:Maláawi
      MX:Mekisiko
      MY:Maleísia
      MZ:Musumbíiji
      NA:Namíbia
      NC:Kaledónia Ifya
      NE:Níija
      NF:Kisíiwa cha Nofifóoki
      NG:Niijéria
      NI:Nikarágʉa
      NL:Ʉholáanzi
      NO:Norwe
      NP:Nepáali
      NR:Naúuru
      NU:Niúue
      NZ:Nyuzílandi
      OM:Ómani
      PA:Panáama
      PE:Péeru
      PF:Polinésia yʉ Ʉfaráansa
      PG:Papúua
      PH:Ufilipíino
      PK:Pakisitáani
      PL:Pólandi
      PM:Mʉtakatíifu Peéteri na Mɨkaéeli
      PN:Patikaírini
      PR:Pwetorɨ́ɨko
      PS:Mweemberera wa kʉmweeri wa Gáaza
      PT:Ʉréeno
      PW:Paláau
      PY:Paraguáai
      QA:Katáari
      RE:Reyunióoni
      RO:Romaníia
      RU:Urúusi
      RW:Rwáanda
      SA:Saudíia Arabíia
      SB:Visíiwa vya Solomóoni
      SC:Shelishéeli
      SD:Sudáani
      SE:Uswíidi
      SG:Singapoo
      SH:Mʉtakatíifu Heléena
      SI:Sulovénia
      SK:Sulováakia
      SL:Seraleóoni
      SM:Samaríino
      SN:Senegáali
      SO:Somália
      SR:Surináamu
      ST:Sao Tóome na Pirinsipe
      SV:Elisalivado
      SY:Síria
      SZ:Ʉswáazi
      TC:Visíiwa vya Turíiki na Kaíiko
      TD:Cháadi
      TG:Tóogo
      TH:Táilandi
      TJ:Tajikisitáani
      TK:Tokeláau
      TL:Timóori yi Itʉʉmba
      TM:Uturukimenisitáani
      TN:Tunísia
      TO:Tóonga
      TR:Uturúuki
      TT:Tiriníida ya Tobáago
      TV:Tuváalu
      TW:Taiwáani
      TZ:Taansanía
      UA:Ʉkɨréeni
      UG:Ʉgáanda
      US:Amerɨka
      UY:Uruguáai
      UZ:Usibekisitáani
      VA:Vatikáani
      VC:Mʉtakatíifu Viséenti na Gernadíini
      VE:Venezuéela
      VG:Visíiwa vya Vigíini vya Ʉɨngeréesa
      VI:Visíiwa vya Vigíini vya Amerɨ́ka
      VN:Vietináamu
      VU:Vanuáatu
      WF:Walíisi na Futúuna
      WS:Samóoa
      YE:Yémeni
      YT:Mayóote
      ZA:Afɨrɨka ya Saame
      ZM:Sámbia
      ZW:Simbáabwe
      """.trimIndent() }

  val lb: String by lazy { """
      001:Welt
      002:Afrika
      003:Nordamerika
      005:Südamerika
      009:Ozeanien
      011:Westafrika
      013:Mëttelamerika
      014:Ostafrika
      015:Nordafrika
      017:Zentralafrika
      018:Südlecht Afrika
      019:Amerika
      021:Nërdlecht Amerika
      029:Karibik
      030:Ostasien
      034:Südasien
      035:Südostasien
      039:Südeuropa
      053:Australien an Neiséiland
      054:Melanesien
      057:Mikronesescht Inselgebitt
      061:Polynesien
      142:Asien
      143:Zentralasien
      145:Westasien
      150:Europa
      151:Osteuropa
      154:Nordeuropa
      155:Westeuropa
      419:Latäinamerika
      AC:Ascension
      AD:Andorra
      AE:Vereenegt Arabesch Emirater
      AF:Afghanistan
      AG:Antigua a Barbuda
      AI:Anguilla
      AL:Albanien
      AM:Armenien
      AO:Angola
      AQ:Antarktis
      AR:Argentinien
      AS:Amerikanesch-Samoa
      AT:Éisträich
      AU:Australien
      AW:Aruba
      AX:Ålandinselen
      AZ:Aserbaidschan
      BA:Bosnien an Herzegowina
      BB:Barbados
      BD:Bangladesch
      BE:Belsch
      BF:Burkina Faso
      BG:Bulgarien
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Saint-Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivien
      BQ:Karibescht Holland
      BR:Brasilien
      BS:Bahamas
      BT:Bhutan
      BV:Bouvetinsel
      BW:Botsuana
      BY:Wäissrussland
      BZ:Belize
      CA:Kanada
      CC:Kokosinselen
      CD:Kongo-Kinshasa
      CF:Zentralafrikanesch Republik
      CG:Kongo-Brazzaville
      CH:Schwäiz
      CI:Côte d’Ivoire
      CK:Cookinselen
      CL:Chile
      CM:Kamerun
      CN:China
      CO:Kolumbien
      CP:Clipperton-Insel
      CR:Costa Rica
      CU:Kuba
      CV:Kap Verde
      CW:Curaçao
      CX:Chrëschtdagsinsel
      CY:Zypern
      CZ:Tschechien
      DE:Däitschland
      DG:Diego Garcia
      DJ:Dschibuti
      DK:Dänemark
      DM:Dominica
      DO:Dominikanesch Republik
      DZ:Algerien
      EA:Ceuta a Melilla
      EC:Ecuador
      EE:Estland
      EG:Egypten
      EH:Westsahara
      ER:Eritrea
      ES:Spanien
      ET:Ethiopien
      EU:Europäesch Unioun
      FI:Finnland
      FJ:Fidschi
      FK:Falklandinselen
      FM:Mikronesien
      FO:Färöer
      FR:Frankräich
      GA:Gabun
      GB:Groussbritannien
      GD:Grenada
      GE:Georgien
      GF:Guayane
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grönland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Equatorialguinea
      GR:Griicheland
      GS:Südgeorgien an déi Südlech Sandwichinselen
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Spezialverwaltungszon Hong Kong
      HM:Heard- a McDonald-Inselen
      HN:Honduras
      HR:Kroatien
      HT:Haiti
      HU:Ungarn
      IC:Kanaresch Inselen
      ID:Indonesien
      IE:Irland
      IL:Israel
      IM:Isle of Man
      IN:Indien
      IQ:Irak
      IR:Iran
      IS:Island
      IT:Italien
      JE:Jersey
      JM:Jamaika
      JO:Jordanien
      JP:Japan
      KE:Kenia
      KG:Kirgisistan
      KH:Kambodscha
      KI:Kiribati
      KM:Komoren
      KN:St. Kitts an Nevis
      KP:Nordkorea
      KR:Südkorea
      KW:Kuwait
      KY:Kaimaninselen
      KZ:Kasachstan
      LA:Laos
      LB:Libanon
      LC:St. Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Litauen
      LU:Lëtzebuerg
      LV:Lettland
      LY:Libyen
      MA:Marokko
      MC:Monaco
      MD:Moldawien
      ME:Montenegro
      MF:St. Martin
      MG:Madagaskar
      MH:Marshallinselen
      MK:Nordmazedonien
      ML:Mali
      MM:Myanmar
      MN:Mongolei
      MO:Spezialverwaltungszon Macau
      MP:Nërdlech Marianen
      MQ:Martinique
      MR:Mauretanien
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldiven
      MW:Malawi
      MX:Mexiko
      MY:Malaysia
      MZ:Mosambik
      NA:Namibia
      NC:Neikaledonien
      NE:Niger
      NF:Norfolkinsel
      NG:Nigeria
      NI:Nicaragua
      NL:Holland
      NO:Norwegen
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Neiséiland
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Franséisch-Polynesien
      PG:Papua-Neiguinea
      PH:Philippinnen
      PK:Pakistan
      PL:Polen
      PM:St. Pierre a Miquelon
      PN:Pitcairninselen
      PR:Puerto Rico
      PS:Palestinensesch Autonomiegebidder
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Katar
      QO:Baussecht Ozeanien
      RE:Réunion
      RO:Rumänien
      RS:Serbien
      RU:Russland
      RW:Ruanda
      SA:Saudi-Arabien
      SB:Salomonen
      SC:Seychellen
      SD:Sudan
      SE:Schweden
      SG:Singapur
      SH:St. Helena
      SI:Slowenien
      SJ:Svalbard a Jan Mayen
      SK:Slowakei
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:Südsudan
      ST:São Tomé a Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syrien
      SZ:Swasiland
      TA:Tristan da Cunha
      TC:Turks- a Caicosinselen
      TD:Tschad
      TF:Franséisch Süd- an Antarktisgebidder
      TG:Togo
      TH:Thailand
      TJ:Tadschikistan
      TK:Tokelau
      TL:Osttimor
      TM:Turkmenistan
      TN:Tunesien
      TO:Tonga
      TR:Tierkei
      TT:Trinidad an Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansania
      UA:Ukrain
      UG:Uganda
      UM:Amerikanesch-Ozeanien
      US:Vereenegt Staaten
      UY:Uruguay
      UZ:Usbekistan
      VA:Vatikanstad
      VC:St. Vincent an d’Grenadinnen
      VE:Venezuela
      VG:Britesch Joffereninselen
      VI:Amerikanesch Joffereninselen
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis a Futuna
      WS:Samoa
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Südafrika
      ZM:Sambia
      ZW:Simbabwe
      ZZ:Onbekannt Regioun
      """.trimIndent() }

  val lg: String by lazy { """
      AD:Andora
      AE:Emireeti
      AF:Afaganisitani
      AG:Antigwa ne Barabuda
      AI:Angwila
      AL:Alibaniya
      AM:Arameniya
      AO:Angola
      AR:Arigentina
      AS:Samowa omumerika
      AT:Awusituriya
      AU:Awusitureliya
      AW:Aruba
      AZ:Azerebayijaani
      BA:Boziniya Hezegovina
      BB:Barabadosi
      BD:Bangaladesi
      BE:Bubirigi
      BF:Burukina Faso
      BG:Bulugariya
      BH:Baareeni
      BI:Burundi
      BJ:Benini
      BM:Beremuda
      BN:Burunayi
      BO:Boliviya
      BR:Buraziiri
      BS:Bahamasi
      BT:Butaani
      BW:Botiswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Kongo - Zayire
      CF:Lipubulika eya Senturafiriki
      CG:Kongo
      CH:Switizirandi
      CI:Kote Divwa
      CK:Bizinga bya Kkuki
      CL:Cile
      CM:Kameruuni
      CN:Cayina
      CO:Kolombya
      CR:Kosita Rika
      CU:Cuba
      CV:Bizinga by’e Kepu Veredi
      CY:Sipuriya
      CZ:Lipubulika ya Ceeka
      DE:Budaaki
      DJ:Jjibuti
      DK:Denimaaka
      DM:Dominika
      DO:Lipubulika ya Dominika
      DZ:Aligerya
      EC:Ekwado
      EE:Esitoniya
      EG:Misiri
      ER:Eritureya
      ES:Sipeyini
      ET:Esyopya
      FI:Finilandi
      FJ:Fiji
      FK:Bizinga by’eFalikalandi
      FM:Mikuronezya
      FR:Bufalansa
      GA:Gaboni
      GB:Bungereza
      GD:Gurenada
      GE:Gyogya
      GF:Guyana enfalansa
      GH:Gana
      GI:Giburalita
      GL:Gurenelandi
      GM:Gambya
      GN:Gini
      GP:Gwadalupe
      GQ:Gayana ey’oku ekweta
      GR:Bugereeki/Buyonaani
      GT:Gwatemala
      GU:Gwamu
      GW:Gini-Bisawu
      GY:Gayana
      HN:Hundurasi
      HR:Kurowesya
      HT:Hayiti
      HU:Hangare
      ID:Yindonezya
      IE:Ayalandi
      IL:Yisirayeri
      IN:Buyindi
      IQ:Yiraaka
      IR:Yiraani
      IS:Ayisirandi
      IT:Yitale
      JM:Jamayika
      JO:Yorodani
      JP:Japani
      KE:Kenya
      KG:Kirigizisitaani
      KH:Kambodya
      KI:Kiribati
      KM:Bizinga by’eKomoro
      KN:Senti Kitisi ne Nevisi
      KP:Koreya ey’omumambuka
      KR:Koreya ey’omumaserengeta
      KW:Kuweti
      KY:Bizinga ebya Kayimaani
      KZ:Kazakisitaani
      LA:Lawosi
      LB:Lebanoni
      LC:Senti Luciya
      LI:Licitensitayini
      LK:Sirilanka
      LR:Liberya
      LS:Lesoso
      LT:Lisuwenya
      LU:Lukisembaaga
      LV:Lativya
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Molodova
      MG:Madagasika
      MH:Bizinga bya Mariso
      ML:Mali
      MM:Myanima
      MN:Mongoliya
      MP:Bizinga bya Mariyana eby’omumambuka
      MQ:Maritiniiki
      MR:Mawulitenya
      MS:Monteseraati
      MT:Malita
      MU:Mawulisyasi
      MV:Bizinga by’eMalidive
      MW:Malawi
      MX:Mekisiko
      MY:Malezya
      MZ:Mozambiiki
      NA:Namibiya
      NC:Kaledonya mupya
      NE:Nije
      NF:Kizinga ky’eNorofoko
      NG:Nayijerya
      NI:Nikaraguwa
      NL:Holandi
      NO:Nowe
      NP:Nepalo
      NR:Nawuru
      NU:Niyuwe
      NZ:Niyuziirandi
      OM:Omaani
      PA:Panama
      PE:Peru
      PF:Polinesiya enfalansa
      PG:Papwa Nyugini
      PH:Bizinga bya Firipino
      PK:Pakisitaani
      PL:Polandi
      PM:Senti Piyere ne Mikeloni
      PN:Pitikeeni
      PR:Potoriko
      PS:Palesitayini
      PT:Potugaali
      PW:Palawu
      PY:Paragwayi
      QA:Kataa
      RE:Leyunyoni
      RO:Lomaniya
      RU:Lasa
      RW:Rwanda
      SA:Sawudarebya - Buwarabu
      SB:Bizanga by’eSolomooni
      SC:Sesere
      SD:Sudaani
      SE:Swideni
      SG:Singapowa
      SH:Senti Herena
      SI:Sirovenya
      SK:Sirovakya
      SL:Siyeralewone
      SM:Sanimarino
      SN:Senegaalo
      SO:Somaliya
      SR:Surinaamu
      ST:Sanitome ne Purincipe
      SV:El salivado
      SY:Siriya
      SZ:Swazirandi
      TC:Bizinga by’eTaaka ne Kayikosi
      TD:Caadi
      TG:Togo
      TH:Tayirandi
      TJ:Tajikisitaani
      TK:Tokelawu
      TL:Timowa
      TM:Takimenesitaani
      TN:Tunisya
      TO:Tonga
      TR:Ttake
      TT:Turindaadi ne Tobago
      TV:Tuvalu
      TW:Tayiwani
      TZ:Tanzaniya
      UA:Yukurayine
      UG:Yuganda
      US:Amerika
      UY:Wurugwayi
      UZ:Wuzibekisitaani
      VA:Vatikaani
      VC:Senti Vinsenti ne Gurendadiini
      VE:Venzwera
      VG:Bizinga ebya Virigini ebitwalibwa Bungereza
      VI:Bizinga bya Virigini eby’Amerika
      VN:Vyetinaamu
      VU:Vanawuwatu
      WF:Walisi ne Futuna
      WS:Samowa
      YE:Yemeni
      YT:Mayotte
      ZA:Sawusafirika
      ZM:Zambya
      ZW:Zimbabwe
      """.trimIndent() }

  val lij: String by lazy { """
      FR:Fransa
      IT:Italia
      MC:Monego
      """.trimIndent() }

  val lkt: String by lazy { """
      001:Makȟásitomni
      002:Hásapa Makȟáwita
      019:Khéya Wíta
      142:Hazíla Makȟáwita
      150:Wašíču Makȟáwita
      CA:Uŋčíyapi Makȟóčhe
      CN:Pȟečhókaŋhaŋska Makȟóčhe
      DE:Iyášiča Makȟóčhe
      ES:Spayólaȟče Makȟóčhe
      JP:Kisúŋla Makȟóčhe
      MX:Spayóla Makȟóčhe
      US:Mílahaŋska Tȟamákȟočhe
      """.trimIndent() }

  val lld: String by lazy { """
      001:monn
      002:Africa
      005:America dl Süd
      009:Ozeania
      011:Africa ozidentala
      013:America Zentrala
      014:Africa orientala
      015:Africa dl Nord
      017:Africa zentrala
      018:Africa dl Süd
      019:Americhes
      021:America dl Nord
      029:Caraibi
      030:Asia orientala
      034:Asia dl Süd
      035:Asia dl Süd-Ost
      039:Europa dl Süd
      053:Australasia
      054:Melanesia
      057:Isoles dla Micronesia
      061:Polinesia
      142:Asia
      143:Asia zentrala
      145:Asia ozidentala
      150:Europa
      151:Europa orientala
      154:Europa dl Nord
      155:Europa ozidentala
      202:Africa sot-sahariana
      419:America latina
      AC:Isola dl’Ascensiun
      AD:Andorra
      AE:Emirac Arabics Unis
      AF:Afghanistan
      AG:Antigua y Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antartida
      AR:Argentina
      AS:Samoa americana
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Isoles Åland
      AZ:Azerbaijan
      BA:Bosnia y Herzegovina
      BB:Barbados
      BD:Bangladesc
      BE:Belgio
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:St. Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Caraibi olandesc
      BR:Brasil
      BS:Bahamas
      BT:Bhutan
      BV:Isola Bouvet
      BW:Botswana
      BY:Belaruscia
      BZ:Belize
      CA:Canada
      CC:Isoles Cocos (Keeling)
      CD:Congo - Kinshasa
      CF:Republica Zentrafricana
      CG:Congo - Brazzaville
      CH:Svizera
      CI:Costa d’Avore
      CK:Isoles Cook
      CL:Cile
      CM:Camerun
      CN:Cina
      CO:Colombia
      CP:Isola de Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Capo Verde
      CW:Curaçao
      CX:Isola dl Nadé
      CY:Ziper
      CZ:Cechia
      DE:Paisc Todësc
      DG:Diego Garcia
      DJ:Djibouti
      DK:Danimarca
      DM:Dominica
      DO:Republica Dominicana
      DZ:Algeria
      EA:Ceuta y Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egit
      EH:Sahara ozidentala
      ER:Eritrea
      ES:Spagna
      ET:Etiopia
      EU:Uniun Europeica
      EZ:Zona Euro
      FI:Finlandia
      FJ:Fiji
      FK:Isoles Falkland
      FM:Micronesia
      FO:Isoles Faroer
      FR:Francia
      GA:Gabun
      GB:Rëgn Uní
      GD:Grenada
      GE:Georgia
      GF:Guiana franzeja
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Groenlandia
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Guinea ecuatoriala
      GR:Grecia
      GS:Georgia dl Süd y Isoles Sandwich dl Süd
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Regiun aministrativa speziala de Hong Kong
      HM:Isoles Heard y McDonald
      HN:Honduras
      HR:Croazia
      HT:Haiti
      HU:Ungaria
      IC:Isoles Canaries
      ID:Indonesia
      IE:Irlanda
      IL:Israel
      IM:Isola de Man
      IN:India
      IO:Teritore britanich dl Ozean Indian
      IQ:Irak
      IR:Iran
      IS:Islanda
      IT:Talia
      JE:Jersey
      JM:Giamaica
      JO:Iordania
      JP:Iapan
      KE:Kenia
      KG:Kyrgystan
      KH:Cambogia
      KI:Kiribati
      KM:Comores
      KN:St. Kitts y Nevis
      KP:Corea dl Nord
      KR:Corea dl Süd
      KW:Kuwait
      KY:Isoles Cayman
      KZ:Kazakhstan
      LA:Laos
      LB:Libanon
      LC:St. Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lituania
      LU:Lussemburgh
      LV:Letonia
      LY:Libia
      MA:Maroco
      MC:Monaco
      MD:Moldavia
      ME:Montenegro
      MF:St. Martin
      MG:Madagascar
      MH:Isoles Marshall
      MK:Macedonia dl Nord
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Regiun aministrativa speziala de Macao
      MP:Isoles Marianes dl Nord
      MQ:Martinica
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldives
      MW:Malawi
      MX:Messich
      MY:Malesia
      MZ:Mozambich
      NA:Namibia
      NC:Nöia Caledonia
      NE:Niger
      NF:Isola Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Paisc Basc
      NO:Norvegia
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nöia Zelanda
      OM:Oman
      PA:Panama
      PE:Perú
      PF:Polinesia franzeja
      PG:Papua Nöia Guinea
      PH:Filipines
      PK:Pakistan
      PL:Polonia
      PM:St. Pierre y Miquelon
      PN:Isoles Pitcairn
      PR:Puerto Rico
      PS:Teritori palestinesc
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Ozeania dlafora
      RE:Réunion
      RO:Romania
      RS:Serbia
      RU:Ruscia
      RW:Ruanda
      SA:Arabia Saudita
      SB:Isoles Salomon
      SC:Seychelles
      SD:Sudan
      SE:Svezia
      SG:Singapur
      SH:St. Helena
      SI:Slovenia
      SJ:Svalbard y Jan Mayen
      SK:Slovachia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Sudan dl Süd
      ST:São Tomé y Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Siria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Isoles Turks y Caicos
      TD:Ciad
      TF:Teritori franzesc dl Süd y dl’Antartica
      TG:Togo
      TH:Thailandia
      TJ:Tajikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turchia
      TT:Trinidad y Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ucraina
      UG:Uganda
      UM:Isoles mëndres dlafora di Stac Unis
      UN:Naziuns Unides
      US:Stac Unis
      UY:Uruguay
      UZ:Uzbekistan
      VA:Cité dl Vatican
      VC:St. Vincent y Grenadines
      VE:Venezuela
      VG:Isoles Vergines britaniches
      VI:Isoles Vergines americanes
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis y Futuna
      WS:Samoa
      XA:Pseudo-azënc
      XB:Pseudo-bidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:Südafrica
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Raiun nia conesciü
      """.trimIndent() }

  val lmo: String by lazy { """
      IT:Italia
      """.trimIndent() }

  val ln: String by lazy { """
      AD:Andorɛ
      AE:Lɛmila alabo
      AF:Afiganisitá
      AG:Antiga mpé Barbuda
      AI:Angiyɛ
      AL:Alibani
      AM:Amɛni
      AO:Angóla
      AQ:Antarctique
      AR:Arizantinɛ
      AS:Samoa ya Ameriki
      AT:Otilisi
      AU:Ositáli
      AW:Aruba
      AZ:Azɛlɛbaizá
      BA:Bosini mpé Hezegovine
      BB:Barɛbadɛ
      BD:Bengalidɛsi
      BE:Beleziki
      BF:Bukina Faso
      BG:Biligari
      BH:Bahrɛnɛ
      BI:Burundi
      BJ:Benɛ
      BM:Bermuda
      BN:Brineyi
      BO:Bolivi
      BR:Brezílɛ
      BS:Bahamasɛ
      BT:Butáni
      BW:Botswana
      BY:Byelorisi
      BZ:Belizɛ
      CA:Kanada
      CD:Republíki ya Kongó Demokratíki
      CF:Repibiki ya Afríka ya Káti
      CG:Kongo
      CH:Swisɛ
      CI:Kotídivualɛ
      CK:Bisanga bya Kookɛ
      CL:Síli
      CM:Kamɛrune
      CN:Sinɛ
      CO:Kolombi
      CR:Kositarika
      CU:Kiba
      CV:Bisanga bya Kapevɛrɛ
      CY:Sípɛlɛ
      CZ:Shekia
      DE:Alemani
      DJ:Dzibuti
      DK:Danɛmarike
      DM:Domínike
      DO:Repibiki ya Domínikɛ
      DZ:Alizɛri
      EC:Ekwatɛ́lɛ
      EE:Esitoni
      EG:Ezípite
      ER:Elitelɛ
      ES:Esipanye
      ET:Etsíopi
      FI:Filandɛ
      FJ:Fidzi
      FK:Bisanga bya Maluni
      FM:Mikronezi
      FR:Falánsɛ
      GA:Gabɔ
      GB:Angɛlɛtɛ́lɛ
      GD:Gelenadɛ
      GE:Zorzi
      GF:Giyanɛ ya Falánsɛ
      GG:Guernesey
      GH:Gana
      GI:Zibatalɛ
      GL:Gowelande
      GM:Gambi
      GN:Ginɛ
      GP:Gwadɛlupɛ
      GQ:Ginɛ́kwatɛ́lɛ
      GR:Geleki
      GS:Îles de Géorgie du Sud et Sandwich du Sud
      GT:Gwatémala
      GU:Gwamɛ
      GW:Ginɛbisau
      GY:Giyane
      HM:Ile Heard et Iles McDonald
      HN:Ondurasɛ
      HR:Krowasi
      HT:Ayiti
      HU:Ongili
      ID:Indonezi
      IE:Irelandɛ
      IL:Isirayelɛ
      IN:Índɛ
      IQ:Iraki
      IR:Irâ
      IS:Isilandɛ
      IT:Itali
      JM:Zamaiki
      JO:Zɔdani
      JP:Zapɔ
      KE:Kenya
      KG:Kigizisitá
      KH:Kambodza
      KI:Kiribati
      KM:Komorɛ
      KN:Sántu krístofe mpé Nevɛ̀s
      KP:Korɛ ya nɔ́rdi
      KR:Korɛ ya súdi
      KW:Koweti
      KY:Bisanga bya Kayíma
      KZ:Kazakisitá
      LA:Lawosi
      LB:Libá
      LC:Sántu lisi
      LI:Lishɛteni
      LK:Sirilanka
      LR:Libériya
      LS:Lesoto
      LT:Litwani
      LU:Likisambulu
      LV:Letoni
      LY:Libí
      MA:Marokɛ
      MC:Monako
      MD:Molidavi
      ME:Monténégro
      MG:Madagasikari
      MH:Bisanga bya Marishalɛ
      ML:Malí
      MM:Birmanie
      MN:Mongolí
      MP:Bisanga bya Marianɛ ya nɔ́rdi
      MQ:Martiniki
      MR:Moritani
      MS:Mɔsera
      MT:Malitɛ
      MU:Morisɛ
      MV:Madívɛ
      MW:Malawi
      MX:Meksike
      MY:Malezi
      MZ:Mozambíki
      NA:Namibi
      NC:Kaledoni ya sika
      NE:Nizɛrɛ
      NF:Esanga Norfokɛ
      NG:Nizerya
      NI:Nikaragwa
      NL:Olandɛ
      NO:Norivezɛ
      NP:Nepálɛ
      NR:Nauru
      NU:Nyué
      NZ:Zelandɛ ya sika
      OM:Ománɛ
      PA:Panama
      PE:Péru
      PF:Polinezi ya Falánsɛ
      PG:Papwazi Ginɛ ya sika
      PH:Filipinɛ
      PK:Pakisitá
      PL:Poloni
      PM:Sántu pététo mpé Mikelɔ
      PN:Pikairni
      PR:Pɔtoriko
      PS:Palɛsine
      PT:Putúlugɛsi
      PW:Palau
      PY:Palagwei
      QA:Katari
      RE:Lenyo
      RO:Romani
      RS:Serbie
      RU:Risí
      RW:Rwanda
      SA:Alabi Sawuditɛ
      SB:Bisanga Solomɔ
      SC:Sɛshɛlɛ
      SD:Sudá
      SE:Swédɛ
      SG:Singapurɛ
      SH:Sántu eleni
      SI:Siloveni
      SK:Silovaki
      SL:Siera Leonɛ
      SM:Sántu Marinɛ
      SN:Senegalɛ
      SO:Somali
      SR:Surinamɛ
      ST:Sao Tomé mpé Presipɛ
      SV:Savadɔrɛ
      SY:Sirí
      SZ:Swazilandi
      TC:Bisanga bya Turki mpé Kaiko
      TD:Tsádi
      TF:Terres australes et antarctiques françaises
      TG:Togo
      TH:Tailandɛ
      TJ:Tazikisitá
      TK:Tokelau
      TL:Timorɛ ya Moniɛlɛ
      TM:Tikɛménisitá
      TN:Tinizi
      TO:Tonga
      TR:Tiliki
      TT:Tinidadɛ mpé Tobago
      TV:Tuvalu
      TW:Taiwanin
      TZ:Tanzani
      UA:Ikrɛni
      UG:Uganda
      US:Ameriki
      UY:Irigwei
      UZ:Uzibɛkisitá
      VA:Vatiká
      VC:Sántu vesá mpé Gelenadinɛ
      VE:Venézuela
      VG:Bisanga bya Vierzi ya Angɛlɛtɛ́lɛ
      VI:Bisanga bya Vierzi ya Ameriki
      VN:Viyetinamɛ
      VU:Vanuatu
      WF:Walisɛ mpé Futuna
      WS:Samoa
      YE:Yemɛnɛ
      YT:Mayotɛ
      ZA:Afríka ya Súdi
      ZM:Zambi
      ZW:Zimbabwe
      """.trimIndent() }

  val ln_AO: String? = null

  val ln_CF: String? = null

  val ln_CG: String? = null

  val lo: String by lazy { """
      001:ໂລກ
      002:ອາຟຣິກາ
      003:ອາເມລິກາເໜືອ
      005:ອາເມລິກາໃຕ້
      009:ໂອຊີອານີ
      011:ອາຟຣິກາຕາເວັນຕົກ
      013:ອາເມລິກາກາງ
      014:ອາຟຣິກາຕາເວັນອອກ
      015:ອາຟຣິກາເໜືອ
      017:ອາຟຣິກາກາງ
      018:ອາຟຣິກາຕອນໃຕ້
      019:ອາເມຣິກາ
      021:ພາກເໜືອອາເມລີກາ
      029:ຄາຣິບບຽນ
      030:ອາຊີຕາເວັນອອກ
      034:ອາຊີໃຕ້
      035:ອາຊີຕາເວັນອອກສຽງໃຕ້
      039:ຢູໂຣບໃຕ້
      053:ໂອດສະຕາລີ
      054:ເມລານີເຊຍ
      057:ເຂດໄມໂຄຣເນຊຽນ
      061:ໂພລີນີເຊຍ
      142:ອາຊີ
      143:ອາຊີກາງ
      145:ອາຊີຕາເວັນຕົກ
      150:ຢູໂຣບ
      151:ຢູໂຣບຕາເວັນອອກ
      154:ຢູໂຣບເໜືອ
      155:ຢູໂຣບຕາເວັນຕົກ
      202:ຊັບ ຊາຮາຣານ ອາຟຣິກາ
      419:ລາຕິນ ອາເມລິກາ
      AC:ເກາະອາເຊນຊັນ
      AD:ອັນດໍຣາ
      AE:ສະຫະລັດອາຣັບເອມິເຣດ
      AF:ອາຟການິດສະຖານ
      AG:ແອນທິກົວ ແລະ ບາບູດາ
      AI:ແອນກຸຍລາ
      AL:ແອວເບເນຍ
      AM:ອາເມເນຍ
      AO:ແອງໂກລາ
      AQ:ແອນຕາດຕິກາ
      AR:ອາເຈນທິນາ
      AS:ອາເມຣິກາ ຊາມົວ
      AT:ອອສເທຣຍ
      AU:ອອສເຕຣເລຍ
      AW:ອາຣູບາ
      AX:ຫມູ່ເກາະໂອລັນ
      AZ:ອາເຊີໄບຈານ
      BA:ບອດສະເນຍ ແລະ ແຮສໂກວີນາ
      BB:ບາບາໂດສ
      BD:ບັງກະລາເທດ
      BE:ເບວຢຽມ
      BF:ເບີກິນາ ຟາໂຊ
      BG:ບັງກາເຣຍ
      BH:ບາເຣນ
      BI:ບູຣຸນດິ
      BJ:ເບນິນ
      BL:ເຊນ ບາເທເລມີ
      BM:ເບີມິວດາ
      BN:ບຣູໄນ
      BO:ໂບລິເວຍ
      BQ:ຄາຣິບບຽນ ເນເທີແລນ
      BR:ບຣາຊິວ
      BS:ບາຮາມາສ
      BT:ພູຖານ
      BV:ເກາະບູເວດ
      BW:ບອດສະວານາ
      BY:ເບລາຣຸສ
      BZ:ເບລີຊ
      CA:ແຄນາດາ
      CC:ຫມູ່ເກາະໂກໂກສ
      CD:ຄອງໂກ - ຄິນຊາຊາ
      CF:ສາທາລະນະລັດອາຟຣິກາກາງ
      CG:ຄອງໂກ - ບຣາຊາວິວ
      CH:ສະວິດເຊີແລນ
      CI:ໂຄຕີ ວົວ
      CK:ໝູ່ເກາະຄຸກ
      CL:ຊິລີ
      CM:ຄາເມຣູນ
      CN:ຈີນ
      CO:ໂຄລົມເບຍ
      CP:ເກາະຄລິບເປີຕັນ
      CR:ໂຄສຕາ ຣິກາ
      CU:ຄິວບາ
      CV:ເຄບ ເວີດ
      CW:ຄູຣາຊາວ
      CX:ເກາະຄຣິສມາດ
      CY:ໄຊປຣັສ
      CZ:ເຊັກເຊຍ
      DE:ເຢຍລະມັນ
      DG:ດິເອໂກ ກາເຊຍ
      DJ:ຈິບູຕິ
      DK:ເດນມາກ
      DM:ໂດມີນິຄາ
      DO:ສາທາລະນະລັດ ໂດມິນິກັນ
      DZ:ອັລຈິເຣຍ
      EA:ເຊວຕາ & ເມລິນລາ
      EC:ເອກວາດໍ
      EE:ເອສໂຕເນຍ
      EG:ອີຢິບ
      EH:ຊາຮາຣາຕາເວັນຕົກ
      ER:ເອຣິເທຣຍ
      ES:ສະເປນ
      ET:ອີທິໂອເປຍ
      EU:ສະຫະພາບຢູໂຣບ
      EZ:ເຂດຢູໂຣບ
      FI:ຟິນແລນ
      FJ:ຟິຈິ
      FK:ຫມູ່ເກາະຟອກແລນ
      FM:ໄມໂຄຣນີເຊຍ
      FO:ຫມູ່ເກາະແຟໂຣ
      FR:ຝຣັ່ງ
      GA:ກາບອນ
      GB:ສະຫະລາດຊະອະນາຈັກ
      GD:ເກຣເນດາ
      GE:ຈໍເຈຍ
      GF:ເຟຣນຊ໌ ກຸຍອານາ
      GG:ເກີນຊີ
      GH:ການາ
      GI:ຈິບບຣອນທາ
      GL:ກຣີນແລນ
      GM:ສາທາລະນະລັດແກມເບຍ
      GN:ກິນີ
      GP:ກົວດາລູບ
      GQ:ເອຄົວໂທຣຽວ ກີນີ
      GR:ກຣີຊ
      GS:ໝູ່ເກາະ ຈໍເຈຍຕອນໃຕ້ ແລະ ແຊນວິດຕອນໃຕ້
      GT:ກົວເທມາລາ
      GU:ກວາມ
      GW:ກິນີ-ບິສເຊົາ
      GY:ກາຍຢານາ
      HK:ຮົງກົງ ເຂດປົກຄອງພິເສດ ຈີນ
      HM:ໝູ່ເກາະເຮີດ & ແມັກໂດນອລ
      HN:ຮອນດູຣັສ
      HR:ໂຄຣເອເທຍ
      HT:ໄຮຕິ
      HU:ຮັງກາຣີ
      IC:ໝູ່ເກາະຄານາຣີ
      ID:ອິນໂດເນເຊຍ
      IE:ໄອແລນ
      IL:ອິສຣາເອວ
      IM:ເອວ ອອບ ແມນ
      IN:ອິນເດຍ
      IO:ເຂດແດນອັງກິດໃນມະຫາສະໝຸດອິນເດຍ
      IQ:ອີຣັກ
      IR:ອີຣານ
      IS:ໄອສແລນ
      IT:ອິຕາລີ
      JE:ເຈີຊີ
      JM:ຈາໄມຄາ
      JO:ຈໍແດນ
      JP:ຍີ່ປຸ່ນ
      KE:ເຄນຢາ
      KG:ຄຽກກິດສະຖານ
      KH:ກຳປູເຈຍ
      KI:ຄິຣິບາທິ
      KM:ໂຄໂມໂຣສ
      KN:ເຊນ ຄິດ ແລະ ເນວິສ
      KP:ເກົາຫລີເໜືອ
      KR:ເກົາຫລີໃຕ້
      KW:ກູເວດ
      KY:ໝູ່ເກາະ ເຄແມນ
      KZ:ຄາຊັກສະຖານ
      LA:ລາວ
      LB:ເລບານອນ
      LC:ເຊນ ລູເຊຍ
      LI:ລິດເທນສະຕາຍ
      LK:ສີລັງກາ
      LR:ລິເບີເຣຍ
      LS:ເລໂຊໂທ
      LT:ລິທົວເນຍ
      LU:ລຸກແຊມເບີກ
      LV:ລັດເວຍ
      LY:ລິເບຍ
      MA:ໂມຣັອກໂຄ
      MC:ໂມນາໂຄ
      MD:ໂມນໂດວາ
      ME:ມອນເຕເນໂກຣ
      MF:ເຊນ ມາທິນ
      MG:ມາດາກາສະກາ
      MH:ຫມູ່ເກາະມາແຊວ
      MK:ແມຊິໂດເນຍເໜືອ
      ML:ມາລີ
      MM:ມຽນມາ (ເບີມາ)
      MN:ມອງໂກເລຍ
      MO:ມາກາວ ເຂດປົກຄອງພິເສດ ຈີນ
      MP:ໝູ່ເກາະມາເຣຍນາຕອນເໜືອ
      MQ:ມາຕິນີກ
      MR:ມົວຣິເທເນຍ
      MS:ມອນເຊີຣາດ
      MT:ມອນທາ
      MU:ມົວຣິຊຽສ
      MV:ມັນດິຟ
      MW:ມາລາວີ
      MX:ເມັກຊິໂກ
      MY:ມາເລເຊຍ
      MZ:ໂມແຊມບິກ
      NA:ນາມີເບຍ
      NC:ນິວ ຄາເລໂດເນຍ
      NE:ນິເຈີ
      NF:ເກາະນໍໂຟກ
      NG:ໄນຈີເຣຍ
      NI:ນິກຄາຣາກົວ
      NL:ເນເທີແລນ
      NO:ນໍເວ
      NP:ເນປານ
      NR:ນາອູຣູ
      NU:ນີອູເອ
      NZ:ນິວຊີແລນ
      OM:ໂອມານ
      PA:ພານາມາ
      PE:ເປຣູ
      PF:ເຟຣນຊ໌ ໂພລິນີເຊຍ
      PG:ປາປົວນິວກີນີ
      PH:ຟິລິບປິນ
      PK:ປາກິດສະຖານ
      PL:ໂປແລນ
      PM:ເຊນ ປີແອ ມິເກວລອນ
      PN:ໝູ່ເກາະພິດແຄນ
      PR:ເພືອໂຕ ຣິໂກ
      PS:ດິນແດນປາເລດສະຕິນ
      PT:ພອລທູໂກ
      PW:ປາລາວ
      PY:ພາຣາກວຍ
      QA:ກາຕາ
      QO:ເຂດຫ່າງໄກໂອຊີເນຍ
      RE:ເຣອູນິຍົງ
      RO:ໂຣແມເນຍ
      RS:ເຊີເບຍ
      RU:ຣັດເຊຍ
      RW:ຣວັນດາ
      SA:ຊາອຸດິ ອາຣາເບຍ
      SB:ຫມູ່ເກາະໂຊໂລມອນ
      SC:ເຊເຊວເລສ
      SD:ຊູດານ
      SE:ສະວີເດັນ
      SG:ສິງກະໂປ
      SH:ເຊນ ເຮເລນາ
      SI:ສະໂລເວເນຍ
      SJ:ສະວາບາ ແລະ ແຢນ ມາເຢນ
      SK:ສະໂລວາເກຍ
      SL:ເຊຍຣາ ລີໂອນ
      SM:ແຊນ ມາຣິໂນ
      SN:ເຊນີໂກລ
      SO:ໂຊມາເລຍ
      SR:ຊູຣິນາມ
      SS:ຊູດານໃຕ້
      ST:ເຊົາທູເມ ແລະ ພຣິນຊິບ
      SV:ເອວ ຊໍວາດໍ
      SX:ຊິນ ມາເທັນ
      SY:ຊີເຣຍ
      SZ:​ເອ​ສະ​ວາ​ຕິ​ນີ
      TA:ທຣິສຕັນ ດາ ກັນຮາ
      TC:ໝູ່ເກາະ ເທີກ ແລະ ໄຄໂຄສ
      TD:ຊາດ
      TF:ເຂດແດນທາງໃຕ້ຂອງຝຮັ່ງ
      TG:ໂຕໂກ
      TH:ໄທ
      TJ:ທາຈິກິດສະຖານ
      TK:ໂຕເກເລົາ
      TL:ທິມໍ-ເລສເຕ
      TM:ເທີກເມນິສະຖານ
      TN:ຕູນິເຊຍ
      TO:ທອງກາ
      TR:ເທີຄີ
      TT:ທຣິນິແດດ ແລະ ໂທແບໂກ
      TV:ຕູວາລູ
      TW:ໄຕ້ຫວັນ
      TZ:ທານຊາເນຍ
      UA:ຢູເຄຣນ
      UG:ອູການດາ
      UM:ໝູ່ເກາະຮອບນອກຂອງສະຫະລັດຯ
      UN:ສະຫະປະຊາຊາດ
      US:ສະຫະລັດ
      UY:ອູຣຸກວຍ
      UZ:ອຸສເບກິສະຖານ
      VA:ນະຄອນ ວາຕິກັນ
      VC:ເຊນ ວິນເຊນ ແລະ ເກຣເນດິນ
      VE:ເວເນຊູເອລາ
      VG:ໝູ່ເກາະ ເວີຈິນຂອງອັງກິດ
      VI:ໝູ່ເກາະ ເວີຈິນ ຂອງສະຫະລັດ
      VN:ຫວຽດນາມ
      VU:ວານົວຕູ
      WF:ວາລລິສ ແລະ ຟູຕູນາ
      WS:ຊາມົວ
      XA:ສຳນຽງຊູໂດ
      XB:ຊູໂດບີດີ
      XK:ໂຄໂຊໂວ
      YE:ເຢເມນ
      YT:ມາຢັອດ
      ZA:ອາຟຣິກາໃຕ້
      ZM:ແຊມເບຍ
      ZW:ຊິມບັບເວ
      ZZ:ຂົງເຂດທີ່ບໍ່ຮູ້ຈັກ
      """.trimIndent() }

  val lrc: String by lazy { """
      001:دونیا
      002:ئفریقا
      003:ئمریکا شومالی
      005:ئمریکا ھارگە
      009:ھوم پئڤأند جأھوٙن آڤ
      013:مینجا ئمریکا
      019:ئمریکا
      021:ئمریکا ڤارو
      029:کارائیب
      142:آسیا
      150:ئوروٙپا
      419:ئمریکا لاتین
      BR:بئرئزیل
      CN:چین
      DE:آلمان
      FR:فأرانسە
      GB:بیریتانیا گأپ
      IN:ھئن
      IT:ئیتالیا
      JP:جاپوٙن
      RU:روٙسیە
      US:ڤولاتیا یأکاگئرتە
      ZZ:راساگە نادیار
      """.trimIndent() }

  val lrc_IQ: String? = null

  val lt: String by lazy { """
      001:pasaulis
      002:Afrika
      003:Šiaurės Amerika
      005:Pietų Amerika
      009:Okeanija
      011:Vakarų Afrika
      013:Centrinė Amerika
      014:Rytų Afrika
      015:Šiaurės Afrika
      017:Vidurio Afrika
      018:Pietinė Afrika
      019:Amerika
      021:Šiaurinė Amerika
      029:Karibai
      030:Rytų Azija
      034:Pietų Azija
      035:Pietryčių Azija
      039:Pietų Europa
      053:Australazija
      054:Melanezija
      057:Mikronezijos regionas
      061:Polinezija
      142:Azija
      143:Centrinė Azija
      145:Vakarų Azija
      150:Europa
      151:Rytų Europa
      154:Šiaurės Europa
      155:Vakarų Europa
      202:Užsachario Afrika
      419:Lotynų Amerika
      AC:Dangun Žengimo sala
      AD:Andora
      AE:Jungtiniai Arabų Emyratai
      AF:Afganistanas
      AG:Antigva ir Barbuda
      AI:Angilija
      AL:Albanija
      AM:Armėnija
      AO:Angola
      AQ:Antarktida
      AR:Argentina
      AS:Amerikos Samoa
      AT:Austrija
      AU:Australija
      AW:Aruba
      AX:Alandų Salos
      AZ:Azerbaidžanas
      BA:Bosnija ir Hercegovina
      BB:Barbadosas
      BD:Bangladešas
      BE:Belgija
      BF:Burkina Fasas
      BG:Bulgarija
      BH:Bahreinas
      BI:Burundis
      BJ:Beninas
      BL:Sen Bartelemi
      BM:Bermuda
      BN:Brunėjus
      BO:Bolivija
      BQ:Karibų Nyderlandai
      BR:Brazilija
      BS:Bahamos
      BT:Butanas
      BV:Buvė Sala
      BW:Botsvana
      BY:Baltarusija
      BZ:Belizas
      CA:Kanada
      CC:Kokosų (Kilingo) Salos
      CD:Kongas-Kinšasa
      CF:Centrinės Afrikos Respublika
      CG:Kongas-Brazavilis
      CH:Šveicarija
      CI:Dramblio Kaulo Krantas
      CK:Kuko Salos
      CL:Čilė
      CM:Kamerūnas
      CN:Kinija
      CO:Kolumbija
      CP:Klipertono sala
      CR:Kosta Rika
      CU:Kuba
      CV:Žaliasis Kyšulys
      CW:Kiurasao
      CX:Kalėdų Sala
      CY:Kipras
      CZ:Čekija
      DE:Vokietija
      DG:Diego Garsija
      DJ:Džibutis
      DK:Danija
      DM:Dominika
      DO:Dominikos Respublika
      DZ:Alžyras
      EA:Seuta ir Melila
      EC:Ekvadoras
      EE:Estija
      EG:Egiptas
      EH:Vakarų Sachara
      ER:Eritrėja
      ES:Ispanija
      ET:Etiopija
      EU:Europos Sąjunga
      EZ:euro zona
      FI:Suomija
      FJ:Fidžis
      FK:Folklando Salos
      FM:Mikronezija
      FO:Farerų Salos
      FR:Prancūzija
      GA:Gabonas
      GB:Jungtinė Karalystė
      GD:Grenada
      GE:Gruzija
      GF:Prancūzijos Gviana
      GG:Gernsis
      GH:Gana
      GI:Gibraltaras
      GL:Grenlandija
      GM:Gambija
      GN:Gvinėja
      GP:Gvadelupa
      GQ:Pusiaujo Gvinėja
      GR:Graikija
      GS:Pietų Džordžija ir Pietų Sandvičo salos
      GT:Gvatemala
      GU:Guamas
      GW:Bisau Gvinėja
      GY:Gajana
      HK:Ypatingasis Administracinis Kinijos Regionas Honkongas
      HM:Herdo ir Makdonaldo Salos
      HN:Hondūras
      HR:Kroatija
      HT:Haitis
      HU:Vengrija
      IC:Kanarų salos
      ID:Indonezija
      IE:Airija
      IL:Izraelis
      IM:Meno Sala
      IN:Indija
      IO:Indijos Vandenyno Britų Sritis
      IQ:Irakas
      IR:Iranas
      IS:Islandija
      IT:Italija
      JE:Džersis
      JM:Jamaika
      JO:Jordanija
      JP:Japonija
      KE:Kenija
      KG:Kirgizija
      KH:Kambodža
      KI:Kiribatis
      KM:Komorai
      KN:Sent Kitsas ir Nevis
      KP:Šiaurės Korėja
      KR:Pietų Korėja
      KW:Kuveitas
      KY:Kaimanų Salos
      KZ:Kazachstanas
      LA:Laosas
      LB:Libanas
      LC:Sent Lusija
      LI:Lichtenšteinas
      LK:Šri Lanka
      LR:Liberija
      LS:Lesotas
      LT:Lietuva
      LU:Liuksemburgas
      LV:Latvija
      LY:Libija
      MA:Marokas
      MC:Monakas
      MD:Moldova
      ME:Juodkalnija
      MF:Sen Martenas
      MG:Madagaskaras
      MH:Maršalo Salos
      MK:Šiaurės Makedonija
      ML:Malis
      MM:Mianmaras (Birma)
      MN:Mongolija
      MO:Ypatingasis Administracinis Kinijos Regionas Makao
      MP:Marianos Šiaurinės Salos
      MQ:Martinika
      MR:Mauritanija
      MS:Montseratas
      MT:Malta
      MU:Mauricijus
      MV:Maldyvai
      MW:Malavis
      MX:Meksika
      MY:Malaizija
      MZ:Mozambikas
      NA:Namibija
      NC:Naujoji Kaledonija
      NE:Nigeris
      NF:Norfolko sala
      NG:Nigerija
      NI:Nikaragva
      NL:Nyderlandai
      NO:Norvegija
      NP:Nepalas
      NR:Nauru
      NU:Niujė
      NZ:Naujoji Zelandija
      OM:Omanas
      PA:Panama
      PE:Peru
      PF:Prancūzijos Polinezija
      PG:Papua Naujoji Gvinėja
      PH:Filipinai
      PK:Pakistanas
      PL:Lenkija
      PM:Sen Pjeras ir Mikelonas
      PN:Pitkerno salos
      PR:Puerto Rikas
      PS:Palestinos teritorija
      PT:Portugalija
      PW:Palau
      PY:Paragvajus
      QA:Kataras
      QO:Nuošali Okeanija
      RE:Reunjonas
      RO:Rumunija
      RS:Serbija
      RU:Rusija
      RW:Ruanda
      SA:Saudo Arabija
      SB:Saliamono Salos
      SC:Seišeliai
      SD:Sudanas
      SE:Švedija
      SG:Singapūras
      SH:Šv. Elenos Sala
      SI:Slovėnija
      SJ:Svalbardas ir Janas Majenas
      SK:Slovakija
      SL:Siera Leonė
      SM:San Marinas
      SN:Senegalas
      SO:Somalis
      SR:Surinamas
      SS:Pietų Sudanas
      ST:San Tomė ir Prinsipė
      SV:Salvadoras
      SX:Sint Martenas
      SY:Sirija
      SZ:Svazilandas
      TA:Tristano da Kunjos
      TC:Terkso ir Kaikoso Salos
      TD:Čadas
      TF:Prancūzijos Pietų sritys
      TG:Togas
      TH:Tailandas
      TJ:Tadžikija
      TK:Tokelau
      TL:Rytų Timoras
      TM:Turkmėnistanas
      TN:Tunisas
      TO:Tonga
      TR:Turkija
      TT:Trinidadas ir Tobagas
      TV:Tuvalu
      TW:Taivanas
      TZ:Tanzanija
      UA:Ukraina
      UG:Uganda
      UM:Jungtinių Valstijų Mažosios Tolimosios Salos
      UN:Jungtinės Tautos
      US:Jungtinės Valstijos
      UY:Urugvajus
      UZ:Uzbekistanas
      VA:Vatikano Miesto Valstybė
      VC:Šventasis Vincentas ir Grenadinai
      VE:Venesuela
      VG:Didžiosios Britanijos Mergelių Salos
      VI:Jungtinių Valstijų Mergelių Salos
      VN:Vietnamas
      VU:Vanuatu
      WF:Volisas ir Futūna
      WS:Samoa
      XA:pseudo A
      XB:pseudo B
      XK:Kosovas
      YE:Jemenas
      YT:Majotas
      ZA:Pietų Afrika
      ZM:Zambija
      ZW:Zimbabvė
      ZZ:nežinoma sritis
      """.trimIndent() }

  val lu: String by lazy { """
      AD:Andore
      AE:Lemila alabu
      AF:Afuganisita
      AG:Antiga ne Barbuda
      AI:Angiye
      AL:Alubani
      AM:Ameni
      AO:Angola
      AR:Alijantine
      AS:Samoa wa Ameriki
      AT:Otilisi
      AU:Ositali
      AW:Aruba
      AZ:Ajelbayidja
      BA:Mbosini ne Hezegovine
      BB:Barebade
      BD:Benguladeshi
      BE:Belejiki
      BF:Bukinafaso
      BG:Biligari
      BH:Bahrene
      BI:Burundi
      BJ:Bene
      BM:Bermuda
      BN:Brineyi
      BO:Mbolivi
      BR:Mnulezile
      BS:Bahamase
      BT:Butani
      BW:Mbotswana
      BY:Byelorisi
      BZ:Belize
      CA:Kanada
      CD:Ditunga wa Kongu
      CF:Ditunga dya Afrika wa munkatshi
      CG:Kongu
      CH:Swise
      CI:Kotedivuale
      CK:Lutanda lua Kookɛ
      CL:Shili
      CM:Kamerune
      CN:Shine
      CO:Kolombi
      CR:Kositarika
      CU:Kuba
      CV:Lutanda lua Kapevele
      CY:Shipele
      CZ:Ditunga dya Tsheka
      DE:Alemanu
      DJ:Djibuti
      DK:Danemalaku
      DM:Duminiku
      DO:Ditunga wa Duminiku
      DZ:Alijeri
      EC:Ekwatele
      EE:Esitoni
      EG:Mushidi
      ER:Elitele
      ES:Nsipani
      ET:Etshiopi
      FI:Filande
      FJ:Fuji
      FK:Lutanda lua Maluni
      FM:Mikronezi
      FR:Nfalanse
      GA:Ngabu
      GB:Angeletele
      GD:Ngelenade
      GE:Joriji
      GF:Giyane wa Nfalanse
      GH:Ngana
      GI:Jibeletale
      GL:Ngowelande
      GM:Gambi
      GN:Ngine
      GP:Ngwadelupe
      GQ:Gine Ekwatele
      GR:Ngeleka
      GT:Ngwatemala
      GU:Ngwame
      GW:Nginebisau
      GY:Ngiyane
      HN:Ondurase
      HR:Krowasi
      HT:Ayiti
      HU:Ongili
      ID:Indonezi
      IE:Irelande
      IL:Isirayele
      IN:Inde
      IQ:Iraki
      IR:Ira
      IS:Isilande
      IT:Itali
      JM:Jamaiki
      JO:Jodani
      JP:Japu
      KE:Kenya
      KG:Kigizisita
      KH:Kambodza
      KI:Kiribati
      KM:Komoru
      KN:Santu krístofe ne Neves
      KP:Kore wa muulu
      KR:Kore wa mwinshi
      KW:Koweti
      KY:Lutanda lua Kayima
      KZ:Kazakusita
      LA:Lawosi
      LB:Liba
      LC:Santu lisi
      LI:Lishuteni
      LK:Sirilanka
      LR:Liberiya
      LS:Lesoto
      LT:Litwani
      LU:Likisambulu
      LV:Letoni
      LY:Libi
      MA:Maroke
      MC:Monaku
      MD:Molidavi
      MG:Madagasikari
      MH:Lutanda lua Marishale
      ML:Mali
      MM:Myamare
      MN:Mongoli
      MP:Lutanda lua Mariane wa muulu
      MQ:Martiniki
      MR:Moritani
      MS:Musera
      MT:Malite
      MU:Morise
      MV:Madive
      MW:Malawi
      MX:Meksike
      MY:Malezi
      MZ:Mozambiki
      NA:Namibi
      NC:Kaledoni wa mumu
      NE:Nijere
      NF:Lutanda lua Norfok
      NG:Nijerya
      NI:Nikaragwa
      NL:Olandɛ
      NO:Noriveje
      NP:Nepálɛ
      NR:Nauru
      NU:Nyue
      NZ:Zelanda wa mumu
      OM:Omane
      PA:Panama
      PE:Peru
      PF:Polinezi wa Nfalanse
      PG:Papwazi wa Nginɛ wa mumu
      PH:Nfilipi
      PK:Pakisita
      PL:Mpoloni
      PM:Santu pététo ne Mikelu
      PN:Pikairni
      PR:Mpotoriku
      PS:Palesine
      PT:Mputulugeshi
      PW:Palau
      PY:Palagwei
      QA:Katari
      RE:Lenyo
      RO:Romani
      RU:Risi
      RW:Rwanda
      SA:Alabu Nsawudi
      SB:Lutanda lua Solomu
      SC:Seshele
      SD:Suda
      SE:Suwedi
      SG:Singapure
      SH:Santu eleni
      SI:Siloveni
      SK:Silovaki
      SL:Siera Leone
      SM:Santu Marine
      SN:Senegale
      SO:Somali
      SR:Suriname
      ST:Sao Tome ne Presipɛ
      SV:Savadore
      SY:Siri
      SZ:Swazilandi
      TC:Lutanda lua Tuluki ne Kaiko
      TD:Tshadi
      TG:Togu
      TH:Tayilanda
      TJ:Tazikisita
      TK:Tokelau
      TL:Timoru wa diboku
      TM:Tukemenisita
      TN:Tinizi
      TO:Tonga
      TR:Tuluki
      TT:Tinidade ne Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzani
      UA:Ukreni
      UG:Uganda
      US:Ameriki
      UY:Irigwei
      UZ:Uzibekisita
      VA:Nvatika
      VC:Santu vesa ne Ngelenadine
      VE:Venezuela
      VG:Lutanda lua Vierzi wa Angeletele
      VI:Lutanda lua Vierzi wa Ameriki
      VN:Viyetiname
      VU:Vanuatu
      WF:Walise ne Futuna
      WS:Samoa
      YE:Yemenu
      YT:Mayote
      ZA:Afrika ya Súdi
      ZM:Zambi
      ZW:Zimbabwe
      """.trimIndent() }

  val luo: String by lazy { """
      AD:Andorra
      AE:United Arab Emirates
      AF:Afghanistan
      AG:Antigua gi Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Argentina
      AS:American Samoa
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azerbaijan
      BA:Bosnia gi Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgium
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazil
      BS:Bahamas
      BT:Bhutan
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Canada
      CD:Democratic Reof the Congo
      CF:Central African Republic
      CG:Congo
      CH:Switzerland
      CI:Côte d
      CK:Cook Islands
      CL:Chile
      CM:Cameroon
      CN:China
      CO:Colombia
      CR:Costa Rica
      CU:Cuba
      CV:Cape Verde Islands
      CY:Cyprus
      CZ:Czech Republic
      DE:Germany
      DJ:Djibouti
      DK:Denmark
      DM:Dominica
      DO:Dominican Republic
      DZ:Algeria
      EC:Ecuador
      EE:Estonia
      EG:Egypt
      ER:Eritrea
      ES:Spain
      ET:Ethiopia
      FI:Finland
      FJ:Fiji
      FK:Chuia mar Falkland
      FM:Micronesia
      FR:France
      GA:Gabon
      GB:United Kingdom
      GD:Grenada
      GE:Georgia
      GF:French Guiana
      GH:Ghana
      GI:Gibraltar
      GL:Greenland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Equatorial Guinea
      GR:Greece
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HN:Honduras
      HR:Croatia
      HT:Haiti
      HU:Hungary
      ID:Indonesia
      IE:Ireland
      IL:Israel
      IN:India
      IQ:Iraq
      IR:Iran
      IS:Iceland
      IT:Italy
      JM:Jamaica
      JO:Jordan
      JP:Japan
      KE:Kenya
      KG:Kyrgyzstan
      KH:Cambodia
      KI:Kiribati
      KM:Comoros
      KN:Saint Kitts gi Nevis
      KP:Korea Masawa
      KR:Korea Milambo
      KW:Kuwait
      KY:Cayman Islands
      KZ:Kazakhstan
      LA:Laos
      LB:Lebanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lithuania
      LU:Luxembourg
      LV:Latvia
      LY:Libya
      MA:Morocco
      MC:Monaco
      MD:Moldova
      MG:Madagascar
      MH:Chuia mar Marshall
      ML:Mali
      MM:Myanmar
      MN:Mongolia
      MP:Northern Mariana Islands
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldives
      MW:Malawi
      MX:Mexico
      MY:Malaysia
      MZ:Mozambique
      NA:Namibia
      NC:New Caledonia
      NE:Niger
      NF:Chuia mar Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Netherlands
      NO:Norway
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:Oman
      PA:Panama
      PE:Peru
      PF:French Polynesia
      PG:Papua New Guinea
      PH:Philippines
      PK:Pakistan
      PL:Poland
      PM:Saint Pierre gi Miquelon
      PN:Pitcairn
      PR:Puerto Rico
      PS:Palestinian West Bank gi Gaza
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      RE:Réunion
      RO:Romania
      RU:Russia
      RW:Rwanda
      SA:Saudi Arabia
      SB:Solomon Islands
      SC:Seychelles
      SD:Sudan
      SE:Sweden
      SG:Singapore
      SH:Saint Helena
      SI:Slovenia
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      ST:São Tomé gi Príncipe
      SV:El Salvador
      SY:Syria
      SZ:Swaziland
      TC:Turks gi Caicos Islands
      TD:Chad
      TG:Togo
      TH:Thailand
      TJ:Tajikistan
      TK:Tokelau
      TL:East Timor
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turkey
      TT:Trinidad gi Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraine
      UG:Uganda
      US:USA
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatican State
      VC:Saint Vincent gi Grenadines
      VE:Venezuela
      VG:British Virgin Islands
      VI:U.S. Virgin Islands
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis gi Futuna
      WS:Samoa
      YE:Yemen
      YT:Mayotte
      ZA:South Africa
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val luy: String by lazy { """
      AD:Andora
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa lya Marekani
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misri
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Ufaransa
      GA:Gaboni
      GB:Uingereza
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Rwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukraini
      UG:Uganda
      US:Marekani
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val lv: String by lazy { """
      001:pasaule
      002:Āfrika
      003:Ziemeļamerika
      005:Dienvidamerika
      009:Okeānija
      011:Rietumāfrika
      013:Centrālamerika
      014:Austrumāfrika
      015:Ziemeļāfrika
      017:Vidusāfrika
      018:Dienvidāfrika
      019:Amerika
      021:Amerikas ziemeļu daļa
      029:Karību jūras reģions
      030:Austrumāzija
      034:Dienvidāzija
      035:Centrālaustrumāzija
      039:Dienvideiropa
      053:Austrālāzija
      054:Melanēzija
      057:Mikronēzijas reģions
      061:Polinēzija
      142:Āzija
      143:Centrālāzija
      145:Rietumāzija
      150:Eiropa
      151:Austrumeiropa
      154:Ziemeļeiropa
      155:Rietumeiropa
      202:Subsahāras Āfrika
      419:Latīņamerika
      AC:Debesbraukšanas sala
      AD:Andora
      AE:Apvienotie Arābu Emirāti
      AF:Afganistāna
      AG:Antigva un Barbuda
      AI:Angilja
      AL:Albānija
      AM:Armēnija
      AO:Angola
      AQ:Antarktika
      AR:Argentīna
      AS:ASV Samoa
      AT:Austrija
      AU:Austrālija
      AW:Aruba
      AX:Olandes salas
      AZ:Azerbaidžāna
      BA:Bosnija un Hercegovina
      BB:Barbadosa
      BD:Bangladeša
      BE:Beļģija
      BF:Burkinafaso
      BG:Bulgārija
      BH:Bahreina
      BI:Burundija
      BJ:Benina
      BL:Senbartelmī
      BM:Bermudu salas
      BN:Bruneja
      BO:Bolīvija
      BQ:Nīderlandes Karību salas
      BR:Brazīlija
      BS:Bahamu salas
      BT:Butāna
      BV:Buvē sala
      BW:Botsvāna
      BY:Baltkrievija
      BZ:Beliza
      CA:Kanāda
      CC:Kokosu (Kīlinga) salas
      CD:Kongo (Kinšasa)
      CF:Centrālāfrikas Republika
      CG:Kongo (Brazavila)
      CH:Šveice
      CI:Kotdivuāra
      CK:Kuka salas
      CL:Čīle
      CM:Kamerūna
      CN:Ķīna
      CO:Kolumbija
      CP:Klipertona sala
      CR:Kostarika
      CU:Kuba
      CV:Kaboverde
      CW:Kirasao
      CX:Ziemsvētku sala
      CY:Kipra
      CZ:Čehija
      DE:Vācija
      DG:Djego Garsijas atols
      DJ:Džibutija
      DK:Dānija
      DM:Dominika
      DO:Dominikāna
      DZ:Alžīrija
      EA:Seūta un Melilja
      EC:Ekvadora
      EE:Igaunija
      EG:Ēģipte
      EH:Rietumsahāra
      ER:Eritreja
      ES:Spānija
      ET:Etiopija
      EU:Eiropas Savienība
      EZ:Eirozona
      FI:Somija
      FJ:Fidži
      FK:Folklenda salas
      FM:Mikronēzija
      FO:Fēru salas
      FR:Francija
      GA:Gabona
      GB:Apvienotā Karaliste
      GD:Grenāda
      GE:Gruzija
      GF:Francijas Gviāna
      GG:Gērnsija
      GH:Gana
      GI:Gibraltārs
      GL:Grenlande
      GM:Gambija
      GN:Gvineja
      GP:Gvadelupa
      GQ:Ekvatoriālā Gvineja
      GR:Grieķija
      GS:Dienviddžordžija un Dienvidsendviču salas
      GT:Gvatemala
      GU:Guama
      GW:Gvineja-Bisava
      GY:Gajāna
      HK:Ķīnas īpašās pārvaldes apgabals Honkonga
      HM:Hērda sala un Makdonalda salas
      HN:Hondurasa
      HR:Horvātija
      HT:Haiti
      HU:Ungārija
      IC:Kanāriju salas
      ID:Indonēzija
      IE:Īrija
      IL:Izraēla
      IM:Menas sala
      IN:Indija
      IO:Indijas okeāna Britu teritorija
      IQ:Irāka
      IR:Irāna
      IS:Islande
      IT:Itālija
      JE:Džērsija
      JM:Jamaika
      JO:Jordānija
      JP:Japāna
      KE:Kenija
      KG:Kirgizstāna
      KH:Kambodža
      KI:Kiribati
      KM:Komoru salas
      KN:Sentkitsa un Nevisa
      KP:Ziemeļkoreja
      KR:Dienvidkoreja
      KW:Kuveita
      KY:Kaimanu salas
      KZ:Kazahstāna
      LA:Laosa
      LB:Libāna
      LC:Sentlūsija
      LI:Lihtenšteina
      LK:Šrilanka
      LR:Libērija
      LS:Lesoto
      LT:Lietuva
      LU:Luksemburga
      LV:Latvija
      LY:Lībija
      MA:Maroka
      MC:Monako
      MD:Moldova
      ME:Melnkalne
      MF:Senmartēna
      MG:Madagaskara
      MH:Māršala salas
      MK:Ziemeļmaķedonija
      ML:Mali
      MM:Mjanma (Birma)
      MN:Mongolija
      MO:ĶTR īpašais administratīvais reģions Makao
      MP:Ziemeļu Marianas salas
      MQ:Martinika
      MR:Mauritānija
      MS:Montserrata
      MT:Malta
      MU:Maurīcija
      MV:Maldīvija
      MW:Malāvija
      MX:Meksika
      MY:Malaizija
      MZ:Mozambika
      NA:Namībija
      NC:Jaunkaledonija
      NE:Nigēra
      NF:Norfolkas sala
      NG:Nigērija
      NI:Nikaragva
      NL:Nīderlande
      NO:Norvēģija
      NP:Nepāla
      NR:Nauru
      NU:Niue
      NZ:Jaunzēlande
      OM:Omāna
      PA:Panama
      PE:Peru
      PF:Francijas Polinēzija
      PG:Papua-Jaungvineja
      PH:Filipīnas
      PK:Pakistāna
      PL:Polija
      PM:Senpjēra un Mikelona
      PN:Pitkērnas salas
      PR:Puertoriko
      PS:Palestīnas teritorijas
      PT:Portugāle
      PW:Palau
      PY:Paragvaja
      QA:Katara
      QO:Okeānijas attālās salas
      RE:Reinjona
      RO:Rumānija
      RS:Serbija
      RU:Krievija
      RW:Ruanda
      SA:Saūda Arābija
      SB:Zālamana salas
      SC:Seišelu salas
      SD:Sudāna
      SE:Zviedrija
      SG:Singapūra
      SH:Sv.Helēnas sala
      SI:Slovēnija
      SJ:Svalbāra un Jana Majena sala
      SK:Slovākija
      SL:Sjerraleone
      SM:Sanmarīno
      SN:Senegāla
      SO:Somālija
      SR:Surinama
      SS:Dienvidsudāna
      ST:Santome un Prinsipi
      SV:Salvadora
      SX:Sintmārtena
      SY:Sīrija
      SZ:Svatini
      TA:Tristana da Kuņjas salu teritorijas
      TC:Tērksas un Kaikosas salas
      TD:Čada
      TF:Francijas Dienvidjūru teritorija
      TG:Togo
      TH:Taizeme
      TJ:Tadžikistāna
      TK:Tokelau
      TL:Austrumtimora
      TM:Turkmenistāna
      TN:Tunisija
      TO:Tonga
      TR:Turcija
      TT:Trinidāda un Tobāgo
      TV:Tuvalu
      TW:Taivāna
      TZ:Tanzānija
      UA:Ukraina
      UG:Uganda
      UM:ASV Mazās Aizjūras salas
      UN:Apvienoto Nāciju Organizācija
      US:Amerikas Savienotās Valstis
      UY:Urugvaja
      UZ:Uzbekistāna
      VA:Vatikāns
      VC:Sentvinsenta un Grenadīnas
      VE:Venecuēla
      VG:Britu Virdžīnas
      VI:ASV Virdžīnas
      VN:Vjetnama
      VU:Vanuatu
      WF:Volisa un Futunas salas
      WS:Samoa
      XA:pseidoakcenti
      XB:pseidodivvirzienu
      XK:Kosova
      YE:Jemena
      YT:Majota
      ZA:Dienvidāfrikas Republika
      ZM:Zambija
      ZW:Zimbabve
      ZZ:nezināms reģions
      """.trimIndent() }

  val mai: String by lazy { """
      001:विश्व
      002:अफ्रीका
      003:उत्तरी अमेरिका
      005:दक्षिण अमेरिका
      009:ओसेनिया
      011:पश्चिमी अफ्रीका
      013:मध्य अमेरिका
      014:पूरबी अफ्रीका
      015:उत्तरी अफ्रीका
      017:मध्य अफ्रीका
      018:दक्षिणी अफ्रीका
      019:अमेरिका
      021:उत्तर अमेरिका
      029:कैरिबियाई
      030:पूरबी एशिया
      034:दक्षिणी एशिया
      035:दक्षिण-पूरबी एशिया
      039:दक्षिणी यूरोप
      053:आस्ट्रेलेशिया
      054:मेलानेशिया
      057:माइक्रोनेशियाई क्षेत्र
      061:पोलिनेशिया
      142:एशिया
      143:मध्य एशिया
      145:पश्चिमी एशिया
      150:यूरोप
      151:पूरबी यूरोप
      154:उत्तरी यूरोप
      155:पश्चिमी यूरोप
      202:उप सहारा अफ्रीका
      419:लातिन अमेरिका
      AC:असेंशन द्वीप
      AD:एंडोरा
      AE:संयुक्त अरब अमीरात
      AF:अफगानिस्तान
      AG:एंटिगुआ आ बारबुडा
      AI:एंग्विला
      AL:अलबानिया
      AM:आरमेनिया
      AO:अंगोला
      AQ:अंटार्टिका
      AR:अर्जेंटिना
      AS:अमेरिकी समोआ
      AT:आस्ट्रिया
      AU:आस्ट्रेलिया
      AW:अरूबा
      AX:अलैंड द्वीपसमूह
      AZ:अजरबैजान
      BA:बोस्निया आ हर्जेगोबिना
      BB:बारबाडोस
      BD:बंगलादेश
      BE:बेल्जियम
      BF:बुरकिना फासो
      BG:बुल्गारिया
      BH:बहरीन
      BI:बुरूंडी
      BJ:बेनिन
      BL:सेंट बार्थेलेमी
      BM:बरमुडा
      BN:ब्रूनेई
      BO:बोलिबिया
      BQ:कैरिबियाई नीदरलैंड
      BR:ब्राज़ील
      BS:बहामास
      BT:भूटान
      BV:बोबेत द्वीप
      BW:बोत्सबाना
      BY:बेलारूस
      BZ:बेलीज
      CA:कनाडा
      CC:कोकेज (कीलिंग) द्वीपसमूह
      CD:कांगो-किंशासा
      CF:मध्य अफ्रीकी रिपब्लिक
      CG:कांगो-ब्राजाबिले
      CH:स्विट्जरलैंड
      CI:कोट डी आइवर
      CK:कुक द्वीपसमूह
      CL:चिली
      CM:कैमरून
      CN:चीन
      CO:कोलंबिया
      CP:क्लिपर्टन द्वीप
      CR:कोस्टारिका
      CU:क्यूबा
      CV:कैप बर्डे
      CW:कुरासाओ
      CX:क्रिसमस द्वीप
      CY:साइप्रस
      CZ:चेकिया
      DE:जर्मनी
      DG:डियागो गार्सिया
      DJ:जिबूति
      DK:डेनमार्क
      DM:डोमिनिका
      DO:डोमिनिकन रिपब्लिक
      DZ:अल्जीरिया
      EA:सेउटा आ मेलिला
      EC:इक्वाडोर
      EE:एस्टोनिया
      EG:मिस्र
      EH:पश्चिमी सहारा
      ER:एरिट्रिया
      ES:स्पेन
      ET:इथोपिया
      EU:यूरोपीय यूनियन
      EZ:यूरो जोन
      FI:फिनलैंड
      FJ:फिजी
      FK:फाकलैंड द्वीपसमूह
      FM:माइक्रोनेशिया
      FO:फेरो द्वीपसमूह
      FR:फ़्रांस
      GA:गैबन
      GB:यूनाइटेड किंगडम
      GD:ग्रेनाडा
      GE:जार्जिया
      GF:फ्रेंच गुयाना
      GG:गर्नसी
      GH:घाना
      GI:जिब्राल्टर
      GL:ग्रीनलैंड
      GM:गाम्बिया
      GN:गिनी
      GP:ग्वाडेलूप
      GQ:इक्वेटोरियल गिनी
      GR:यूनान
      GS:दक्षिण जार्जिया आ दक्षिण सैंडविच द्वीपसमूह
      GT:ग्वाटेमाला
      GU:गुआम
      GW:गिनी-बिसाऊ
      GY:गुयाना
      HK:हांग कांग (विशेष प्रशासनिक क्षेत्र चीन)
      HM:हर्ड आ मैकडोनल्ड द्वीपसमूह
      HN:होंडुरास
      HR:क्रोएशिया
      HT:हैती
      HU:हंगरी
      IC:कैनरी द्वीपसमूह
      ID:इंडोनेशिया
      IE:आयरलैंड
      IL:इजरायल
      IM:आइल ऑफ मैन
      IN:भारत
      IO:ब्रिटिश हिंद महासागरीय क्षेत्र
      IQ:इराक
      IR:ईरान
      IS:आइसलैंड
      IT:इटली
      JE:जरसी
      JM:जमैका
      JO:जार्डन
      JP:जापान
      KE:केन्या
      KG:किर्गिजस्तान
      KH:कंबोडिया
      KI:किरिबाती
      KM:कोमोरोस
      KN:सेंट किट्स आ नेविस
      KP:उत्तर कोरिया
      KR:दक्षिण कोरिया
      KW:कुवैत
      KY:कैमेन द्वीपसमूह
      KZ:कजाखस्तान
      LA:लाओस
      LB:लेबनान
      LC:सेंट लूसिया
      LI:लिख्तेंस्ताइन
      LK:श्रीलंका
      LR:लाइबेरिया
      LS:लेसोथो
      LT:लिथुआनिया
      LU:लग्जमबर्ग
      LV:लातविया
      LY:लीबिया
      MA:मोरोक्को
      MC:मोनाको
      MD:मोलडोवा
      ME:मोंटेनीग्रो
      MF:सेंट मार्टिन
      MG:मेडागास्कर
      MH:मार्शल द्वीपसमूह
      MK:उत्तरी मकदूनिया
      ML:माली
      MM:मयनमार (बर्मा)
      MN:मंगोलिया
      MO:मकाउ (विशेष प्रशासनिक क्षेत्र चीन)
      MP:उत्तर मरीना द्वीपसमूह
      MQ:मार्टिनिक
      MR:मारिटानिया
      MS:मोंटसेरात
      MT:माल्टा
      MU:मारीशस
      MV:मालदीब
      MW:मलाबी
      MX:मैक्सिको
      MY:मलेशिया
      MZ:मोजाम्बिक
      NA:नामीबिया
      NC:न्यू कैलेडोनिया
      NE:नाइजर
      NF:नौरफोक द्वीप
      NG:नाइजीरिया
      NI:निकारागुआ
      NL:नीदरलैंड
      NO:नार्वे
      NP:नेपाल
      NR:नौरू
      NU:नीयू
      NZ:न्यूजीलैंड
      OM:ओमान
      PA:पनामा
      PE:पेरू
      PF:फ्रेंच पोलिनेशिया
      PG:पापुआ न्यू गिनी
      PH:फिलिपींस
      PK:पाकिस्तान
      PL:पोलैंड
      PM:सेंट पियरे आ मिक्वेलान
      PN:पिटकेयर्न द्वीपसमूह
      PR:प्योर्टो रिको
      PS:फिलिस्तीनी क्षेत्र
      PT:पुर्तगाल
      PW:पलाऊ
      PY:पराग्वे
      QA:कतर
      QO:आउटलाइंग ओसेनिया
      RE:रियूनियन
      RO:रोमानिया
      RS:सर्बिया
      RU:रूस
      RW:रवांडा
      SA:सऊदी अरब
      SB:सोलोमन द्वीपसमूह
      SC:सेशेल्स
      SD:सूडान
      SE:स्वीडन
      SG:सिंगापुर
      SH:सेंट हेलेना
      SI:स्लोबेनिया
      SJ:स्वालबार्ड आ जान मायेन
      SK:स्लोवाकिया
      SL:सियरा लियोन
      SM:सेन मरीनो
      SN:सेनेगल
      SO:सोमालिया
      SR:सुरीनाम
      SS:दक्षिण सुडान
      ST:साओ टोम आ प्रिंसिप
      SV:अल सल्वाडोर
      SX:सिंट मार्टेन
      SY:सीरिया
      SZ:एस्वाटिनी
      TA:ट्रिस्टन दा कुना
      TC:तुर्क आ कैकोज द्वीपसमूह
      TD:चाड
      TF:फ्रांसीसी दक्षिणी क्षेत्र
      TG:टोगो
      TH:थाईलैंड
      TJ:ताजिकिस्तान
      TK:टोकेलाऊ
      TL:तिमोर-लेस्त
      TM:तुर्कमेनिस्तान
      TN:ट्यूनिशिया
      TO:टोंगा
      TR:तुर्की
      TT:ट्रिनिदाद आ टोबैगो
      TV:टुवालू
      TW:ताइबान
      TZ:तंजानिया
      UA:यूक्रेन
      UG:युगांडा
      UM:यू॰एस॰ आउटलाइंग द्वीपसमूह
      UN:संयुक्त राष्ट्र
      US:संयुक्त राज्य
      UY:उरुग्वे
      UZ:उजबेकिस्तान
      VA:वेटिकन सिटी
      VC:सेंट विंसेंट आ ग्रेनाडाइंस
      VE:बेनेजुएला
      VG:ब्रिटिश वर्जिन द्वीपसमूह
      VI:यू॰एस॰ वर्जिन द्वीपसमूह
      VN:बियतनाम
      VU:बनातू
      WF:बालिस आ फुटुना
      WS:समोआ
      XA:छद्म उच्चारण
      XB:छद्म बिडि
      XK:कोसोवो
      YE:यमन
      YT:मयोटे
      ZA:दक्षिण अफ्रीका
      ZM:जाम्बिया
      ZW:जिम्बाब्बे
      ZZ:अज्ञात क्षेत्र
      """.trimIndent() }

  val mas: String by lazy { """
      AD:Andora
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Marekani
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misri
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Ufaransa
      GA:Gaboni
      GB:Uingereza
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Rwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tansania
      UA:Ukraini
      UG:Uganda
      US:Marekani
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Sambia
      ZW:Simbabwe
      """.trimIndent() }

  val mas_TZ: String? = null

  val mer: String by lazy { """
      AD:Andora
      AE:Falme cia Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Alubania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Amerika
      AT:Austiria
      AU:Austrĩlia
      AW:Aruba
      AZ:Azebaijani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangiradeshi
      BE:Beronjiamu
      BF:Bukinafaso
      BG:Bulgaria
      BH:Baharini
      BI:Burundi
      BJ:Benini
      BM:Bamuda
      BN:Brunei
      BO:Bolivia
      BR:Brazilu
      BS:Bahamasi
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Nthĩ ya Kidemokrasĩ ya Kongo
      CF:Nthĩ ya Afrika gatĩgatĩ
      CG:Kongo
      CH:Swizilandi
      CI:Kodivaa
      CK:Aĩrandi cia Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Kiuba
      CV:Kepuvede
      CY:Caipurasi
      CZ:Nthĩ ya Cheki
      DE:Njamanĩ
      DJ:Jibuti
      DK:Denimaki
      DM:Dominika
      DO:Nthĩ ya Dominika
      DZ:Angiria
      EC:Ekwado
      EE:Estonia
      EG:Misiri
      ER:Eritrea
      ES:Spĩni
      ET:Ithiopia
      FI:Finilandi
      FJ:Fiji
      FK:Aĩrandi cia Falklandi
      FM:Mikronesia
      FR:Fransi
      GA:Gaboni
      GB:Ngeretha
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Fransi
      GH:Ghana
      GI:Ngĩbrata
      GL:Ngirinilandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Gine ya Iquita
      GR:Ngiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Koroashia
      HT:Haiti
      HU:Hangarĩ
      ID:Indonesia
      IE:Aelandi
      IL:Isiraeli
      IN:India
      IQ:Iraki
      IR:Irani
      IS:Aisilandi
      IT:Italĩ
      JM:Jamaika
      JO:Jorondani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Nothi
      KR:Korea Saũthi
      KW:Kuwĩ ti
      KY:Aĩrandi cia Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesotho
      LT:Lithuania
      LU:Luxembogu
      LV:Lativia
      LY:Lĩbia
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Madagasika
      MH:Aĩrandi cia Marshal
      ML:Mali
      MM:Myanima
      MN:Mongolia
      MP:Aĩrandi cia Mariana ya nothi
      MQ:Martiniki
      MR:Mauritania
      MS:Montserrati
      MT:Malta
      MU:Maurĩtiasi
      MV:Modivu
      MW:Malawi
      MX:Mexiko
      MY:Malĩsia
      MZ:Mozambiki
      NA:Namibia
      NC:Kalendoia Ĩnjeru
      NE:Nija
      NF:Aĩrandi cia Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Holandi
      NO:Norwi
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Niuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Fransi
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Rũtere rwa Westi banki na Gaza cia Palestina
      PT:Potogo
      PW:Palau
      PY:Paragwai
      QA:Kata
      RE:Riyunioni
      RO:Romania
      RU:Rashia
      RW:Rwanda
      SA:Saudi
      SB:Airandi Cia Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Swideni
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senego
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Swazilandi
      TC:Aĩrandi cia Takĩ na Kaiko
      TD:Chadi
      TG:Togo
      TH:Thaĩlandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Isti
      TM:Tukumenistani
      TN:Tunisia
      TO:Tonga
      TR:Takĩ
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukirĩni
      UG:Uganda
      US:Amerika
      UY:Urugwĩ
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Aĩrandi cia Virgin cia Ngeretha
      VI:Aĩrandi cia Virgin cia Amerika
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika ya Southi
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val mfe: String by lazy { """
      AD:Andor
      AE:Emira arab ini
      AF:Afganistan
      AG:Antigua-ek-Barbuda
      AI:Anguilla
      AL:Albani
      AM:Armeni
      AO:Angola
      AR:Larzantinn
      AS:Samoa amerikin
      AT:Lostris
      AU:Lostrali
      AW:Aruba
      AZ:Azerbaïdjan
      BA:Bosni-Herzegovinn
      BB:Barbad
      BD:Banglades
      BE:Belzik
      BF:Burkina Faso
      BG:Bilgari
      BH:Bahreïn
      BI:Burundi
      BJ:Benin
      BM:Bermid
      BN:Brunei
      BO:Bolivi
      BR:Brezil
      BS:Bahamas
      BT:Boutan
      BW:Botswana
      BY:Belaris
      BZ:Beliz
      CA:Kanada
      CD:Repiblik demokratik Kongo
      CF:Repiblik Lafrik Santral
      CG:Kongo
      CH:Laswis
      CI:Côte d’Ivoire
      CK:Zil Cook
      CL:Shili
      CM:Kamerounn
      CN:Lasinn
      CO:Kolonbi
      CR:Costa Rica
      CU:Cuba
      CV:Kap-Ver
      CY:Cyprus
      CZ:Repiblik Chek
      DE:Almagn
      DJ:Djibouti
      DK:Dannmark
      DM:Dominik
      DO:Repiblik dominikin
      DZ:Alzeri
      EC:Ekwater
      EE:Estoni
      EG:Lezipt
      ER:Erythre
      ES:Lespagn
      ET:Letiopi
      FI:Finland
      FJ:Fidji
      FK:Zil malwinn
      FM:Mikronezi
      FR:Lafrans
      GA:Gabon
      GB:United Kingdom
      GD:Grenad
      GE:Zeorzi
      GF:Gwiyann franse
      GH:Ghana
      GI:Zibraltar
      GL:Greenland
      GM:Gambi
      GN:Gine
      GP:Guadloup
      GQ:Gine ekwatoryal
      GR:Gres
      GT:Guatemala
      GU:Guam
      GW:Gine-Bisau
      GY:Guyana
      HN:Honduras
      HR:Kroasi
      HT:Ayti
      HU:Ongri
      ID:Indonezi
      IE:Irland
      IL:Izrael
      IN:Lenn
      IQ:Irak
      IR:Iran
      IS:Island
      IT:Itali
      JM:Zamaik
      JO:Zordani
      JP:Zapon
      KE:Kenya
      KG:Kirghizistan
      KH:Kambodj
      KI:Kiribati
      KM:Komor
      KN:Saint-Christophe-ek-Niévès
      KP:Lakore-dinor
      KR:Lakore-disid
      KW:Koweit
      KY:Zil Kayman
      KZ:Kazakstan
      LA:Laos
      LB:Liban
      LC:Sainte-Lucie
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lezoto
      LT:Lituani
      LU:Luxembourg
      LV:Letoni
      LY:Libi
      MA:Marok
      MC:Monako
      MD:Moldavi
      MG:Madagaskar
      MH:Zil Marshall
      ML:Mali
      MM:Myanmar
      MN:Mongoli
      MP:Zil Maryann dinor
      MQ:Martinik
      MR:Moritani
      MS:Montsera
      MT:Malt
      MU:Moris
      MV:Maldiv
      MW:Malawi
      MX:Mexik
      MY:Malezi
      MZ:Mozambik
      NA:Namibi
      NC:Nouvel-Kaledoni
      NE:Nizer
      NF:Lil Norfolk
      NG:Nizeria
      NI:Nicaragua
      NL:Oland
      NO:Norvez
      NP:Nepal
      NR:Nauru
      NU:Niowe
      NZ:Nouvel Zeland
      OM:Oman
      PA:Panama
      PE:Perou
      PF:Polinezi franse
      PG:Papouazi-Nouvel-Gine
      PH:Filipinn
      PK:Pakistan
      PL:Pologn
      PM:Saint-Pierre-ek-Miquelon
      PN:Pitcairn
      PR:Porto Rico
      PS:Teritwar Palestinn
      PT:Portigal
      PW:Palau
      PY:Paraguay
      QA:Katar
      RE:Larenion
      RO:Roumani
      RU:Larisi
      RW:Rwanda
      SA:Larabi Saoudit
      SB:Zil Salomon
      SC:Sesel
      SD:Soudan
      SE:Laswed
      SG:Singapour
      SH:Sainte-Hélène
      SI:Sloveni
      SK:Slovaki
      SL:Sierra Leone
      SM:Saint-Marin
      SN:Senegal
      SO:Somali
      SR:Surinam
      ST:São Tome-ek-Prínsip
      SV:Salvador
      SY:Lasiri
      SZ:Swaziland
      TC:Zil Tirk ek Caïcos
      TD:Tchad
      TG:Togo
      TH:Thayland
      TJ:Tadjikistan
      TK:Tokelau
      TL:Timor oriantal
      TM:Turkmenistan
      TN:Tinizi
      TO:Tonga
      TR:Tirki
      TT:Trinite-ek-Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzani
      UA:Ikrenn
      UG:Ouganda
      US:Lamerik
      UY:Uruguay
      UZ:Ouzbekistan
      VA:Lata Vatikan
      VC:Saint-Vincent-ek-Grenadines
      VE:Venezuela
      VG:Zil vierz britanik
      VI:Zil Vierz Lamerik
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis-ek-Futuna
      WS:Samoa
      YE:Yemenn
      YT:Mayot
      ZA:Sid-Afrik
      ZM:Zambi
      ZW:Zimbabwe
      """.trimIndent() }

  val mg: String by lazy { """
      AD:Andorra
      AE:Emirà Arabo mitambatra
      AF:Afghanistan
      AG:Antiga sy Barboda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Arzantina
      AS:Samoa amerikanina
      AT:Aotrisy
      AU:Aostralia
      AW:Arobà
      AZ:Azerbaidjan
      BA:Bosnia sy Herzegovina
      BB:Barbady
      BD:Bangladesy
      BE:Belzika
      BF:Borkina Faso
      BG:Biolgaria
      BH:Bahrain
      BI:Borondi
      BJ:Benin
      BM:Bermioda
      BN:Brunei
      BO:Bolivia
      BR:Brezila
      BS:Bahamas
      BT:Bhotana
      BW:Botsoana
      BY:Belarosy
      BZ:Belize
      CA:Kanada
      CD:Repoblikan’i Kongo
      CF:Repoblika Ivon’Afrika
      CG:Kôngô
      CH:Soisa
      CI:Côte d’Ivoire
      CK:Nosy Kook
      CL:Shili
      CM:Kamerona
      CN:Sina
      CO:Kôlômbia
      CR:Kosta Rikà
      CU:Kiobà
      CV:Nosy Cap-Vert
      CY:Sypra
      CZ:Repoblikan’i Tseky
      DE:Alemaina
      DJ:Djiboti
      DK:Danmarka
      DM:Dominika
      DO:Repoblika Dominikanina
      DZ:Alzeria
      EC:Ekoatera
      EE:Estonia
      EG:Ejypta
      ER:Eritrea
      ES:Espaina
      ET:Ethiopia
      FI:Finlandy
      FJ:Fidji
      FK:Nosy Falkand
      FM:Mikrônezia
      FR:Frantsa
      GA:Gabon
      GB:Angletera
      GD:Grenady
      GE:Zeorzia
      GF:Guyana frantsay
      GH:Ghana
      GI:Zibraltara
      GL:Groenland
      GM:Gambia
      GN:Ginea
      GP:Goadelopy
      GQ:Guinea Ekoatera
      GR:Gresy
      GT:Goatemalà
      GU:Guam
      GW:Giné-Bisao
      GY:Guyana
      HN:Hondiorasy
      HR:Kroasia
      HT:Haiti
      HU:Hongria
      ID:Indonezia
      IE:Irlandy
      IL:Israely
      IN:Indy
      IQ:Irak
      IR:Iran
      IS:Islandy
      IT:Italia
      JM:Jamaïka
      JO:Jordania
      JP:Japana
      KE:Kenya
      KG:Kiordistan
      KH:Kambôdja
      KI:Kiribati
      KM:Kômaoro
      KN:Saint-Christophe-et-Niévès
      KP:Korea Avaratra
      KR:Korea Atsimo
      KW:Kôeity
      KY:Nosy Kayman
      KZ:Kazakhstan
      LA:Laôs
      LB:Libana
      LC:Sainte-Lucie
      LI:Listenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Litoania
      LU:Lioksamboro
      LV:Letonia
      LY:Libya
      MA:Marôka
      MC:Mônakô
      MD:Môldavia
      MG:Madagasikara
      MH:Nosy Marshall
      ML:Mali
      MM:Myanmar
      MN:Môngôlia
      MP:Nosy Mariana Atsinanana
      MQ:Martinika
      MR:Maoritania
      MS:Montserrat
      MT:Malta
      MU:Maorisy
      MV:Maldiva
      MW:Malaoì
      MX:Meksika
      MY:Malaizia
      MZ:Mozambika
      NA:Namibia
      NC:Nouvelle-Calédonie
      NE:Niger
      NF:Nosy Norfolk
      NG:Nizeria
      NI:Nikaragoà
      NL:Holanda
      NO:Nôrvezy
      NP:Nepala
      NR:Naorò
      NU:Nioé
      NZ:Nouvelle-Zélande
      OM:Oman
      PA:Panama
      PE:Peroa
      PF:Polynezia frantsay
      PG:Papouasie-Nouvelle-Guinée
      PH:Filipina
      PK:Pakistan
      PL:Pôlôna
      PM:Saint-Pierre-et-Miquelon
      PN:Pitkairn
      PR:Pôrtô Rikô
      PS:Palestina
      PT:Pôrtiogala
      PW:Palao
      PY:Paragoay
      QA:Katar
      RE:Larenion
      RO:Romania
      RU:Rosia
      RW:Roanda
      SA:Arabia saodita
      SB:Nosy Salomona
      SC:Seyshela
      SD:Sodan
      SE:Soedy
      SG:Singaporo
      SH:Sainte-Hélène
      SI:Slovenia
      SK:Slovakia
      SL:Sierra Leone
      SM:Saint-Marin
      SN:Senegal
      SO:Somalia
      SR:Sorinam
      ST:São Tomé-et-Príncipe
      SV:El Salvador
      SY:Syria
      SZ:Soazilandy
      TC:Nosy Turks sy Caïques
      TD:Tsady
      TG:Togo
      TH:Thailandy
      TJ:Tajikistan
      TK:Tokelao
      TL:Timor Atsinanana
      TM:Torkmenistan
      TN:Tonizia
      TO:Tongà
      TR:Torkia
      TT:Trinidad sy Tobagô
      TV:Tovalò
      TW:Taioana
      TZ:Tanzania
      UA:Okraina
      UG:Oganda
      US:Etazonia
      UY:Orogoay
      UZ:Ozbekistan
      VA:Firenen’i Vatikana
      VC:Saint-Vincent-et-les Grenadines
      VE:Venezoelà
      VG:Nosy britanika virijiny
      VI:Nosy Virijiny Etazonia
      VN:Vietnam
      VU:Vanoatò
      WF:Wallis sy Futuna
      WS:Samoa
      YE:Yemen
      YT:Mayôty
      ZA:Afrika Atsimo
      ZM:Zambia
      ZW:Zimbaboe
      """.trimIndent() }

  val mgh: String by lazy { """
      AD:Uandora
      AF:Ufugustani
      AL:Ualbania
      AS:Usamoa ya Marekani
      AZ:Uazabajani
      BI:Urundi
      BJ:Ubelin
      CA:Ukanada
      CG:Ukongo
      CH:Uswisi
      CI:Ukodiva
      CL:Uchile
      CN:Uchina
      CO:Ukolombia
      CU:Ukuba
      CY:Ukuprosi
      CZ:Ucheki
      DJ:Ujibuti
      DK:Udenimaka
      DM:Udominika
      DZ:Alujeria
      EG:Umisiri
      ER:Uriterea
      ES:Uhispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Ufiji
      FR:Ufaransa
      GA:Ugaboni
      GD:Ugrenada
      GE:Ujojia
      GF:Ufaransa yo Gwaya
      GH:Ugana
      GI:Ujibralta
      GL:Ugrinlandi
      GM:Ugambia
      GN:Ugine
      GP:Ugwadelupe
      GT:Ugwatemala
      GU:Ugwam
      GW:Uginebisau
      GY:Uguyana
      HN:Uhondurasi
      HR:Ukorasia
      HT:Uhaiti
      HU:Uhungaria
      ID:Undonesia
      IE:Uayalandi
      IL:Uisraeli
      IN:Uhindini
      IQ:Wiraki
      IT:Italia
      JM:Ujamaika
      JO:Uyordani
      JP:Ujapani
      KE:Ukenya
      KH:Ukambodia
      KM:Ukomoro
      KN:Usantakitzi na Nevis
      KP:Ukorea Kaskazini
      KR:Ukorea Kusini
      KZ:Ukazakistani
      LB:Ulebanoni
      LC:Usantalusia
      LI:Ushenteni
      LK:Usirilanka
      LR:Uliberia
      LS:Ulesoto
      LT:Utwania
      LU:Usembaji
      LV:Ulativia
      LY:Ulibya
      ME:Umantegro
      MG:Ubukini
      MW:Umalawi
      MZ:Umozambiki
      NE:Unijeri
      NG:Unijeria
      NO:Unorwe
      OM:Uomani
      PA:Upanama
      PE:Uperuu
      PF:Ufaransa yo Potina
      PG:Upapua
      PH:Ufilipino
      PK:Upakistani
      PL:Upolandi
      PM:Usantapieri na Mikeloni
      PN:Upitkairni
      PR:Upwetoriko
      PY:Paragwai
      QA:Ukatari
      RE:Uriyunioni
      RO:Uromania
      RW:Urwanda
      SA:Usaudi
      SC:Ushelisheli
      SD:Usudani
      SE:Uswidi
      SG:Usingapoo
      SH:Usantahelena
      SI:Uslovenia
      SK:Uslovakia
      SM:Usamarino
      SN:Usenegali
      SO:Usomalia
      SR:Usurinamu
      ST:Usao Tome na Principe
      SV:Usalavado
      SY:Usiria
      SZ:Uswazi
      TD:Uchadi
      TG:Utogo
      TH:Utailandi
      TJ:Ujikistani
      TK:Utokelau
      TL:Utimo Mashariki
      TM:Uturukimenistani
      TN:Utunisia
      TO:Utonga
      TR:Utuki
      TT:Utrinidad na Tobago
      TV:Utuvalu
      TZ:Utanzania
      US:Umarekani
      VA:Uvatikani
      VC:Usantavisenti na Grenadini
      VE:Uvenezuela
      VN:Uvietinamu
      VU:Uvanuatu
      WF:Uwalis na Futuna
      WS:Usamoa
      YE:Uyemeni
      ZA:Afrika du Sulu
      ZM:Uzambia
      ZW:Uzimbabwe
      """.trimIndent() }

  val mgo: String by lazy { """
      CM:Kamalun
      ZZ:aba aben tisɔ̀
      """.trimIndent() }

  val mi: String by lazy { """
      001:te ao
      002:Āwherika
      003:Amerika ki te Raki
      005:Amerika ki te Tonga
      009:Ngā Moutere-a-Kiwa
      011:Āwherika ki te Uru
      013:Te Puku o Amerika
      014:Āwherika ki te Rāwhiti
      015:Āwherika ki te Raki
      017:Te Pokapū o Āwherika
      018:Āwherika Whakatetonga
      019:Ngā Amerika
      021:Te Raki o Amerika
      029:Karapīana
      030:Āhia ki te Rāwhiti
      034:Āhia ki te Tonga
      035:Āhia ki te Tonga-mā-rāwhiti
      039:Ūropi ki te Tonga
      053:Atareiria
      054:Meranīhia
      057:Te Rohe o Mekanēhia
      061:Te Moana-nui-a-Kiwa
      142:Āhia
      143:Te Puku o Āhia
      145:Āhia ki te Uru
      150:Ūropi
      151:Ūropi ki te Rāwhiti
      154:Ūropi ki te Raki
      155:Ūropi ki te Uru
      202:Āwherika ki te Tonga o Te Hahāra
      419:Amerika Rātini
      AC:Te Moutere Aupikinga
      AD:Anatōra
      AE:Kotahitanga o ngā Whenua o Ārapi
      AF:Awhekenetāna
      AG:Motu Nehe me Pāputa
      AI:Anguira
      AL:Arapeinia
      AM:Āmenia
      AO:Anakora
      AQ:Te Kōpakatanga ki te Tonga
      AR:Āketina
      AS:Hāmoa-Amerika
      AT:Ataria
      AU:Ahitereiria
      AW:Arūpa
      AX:Motu Ōrana
      AZ:Atepaihānia
      BA:Pōngia-Herekōwini
      BB:Papatohe
      BD:Pākaratēhi
      BE:Peretiama
      BF:Pākina Wharo
      BG:Purukāria
      BH:Pāreina
      BI:Puruniti
      BJ:Penīna
      BL:Hato Pāteremi
      BM:Pāmura
      BN:Poronai
      BO:Poriwia
      BQ:Karapīana Hōrana
      BR:Parīhi
      BS:Pahama
      BT:Pūtana
      BV:Motu Pūwei
      BW:Poriwana
      BY:Pērara
      BZ:Perīhi
      CA:Kānata
      CC:Ngā Moutere Kokoko (Kirini)
      CD:Kōngo - Kinihāha
      CF:Te Whenua Tūhake o Āwherika Waenga
      CG:Kōngo - Pārawhe
      CH:Huiterangi
      CI:Te Tai Rei
      CK:Kuki Airani
      CL:Hiri
      CM:Kamarūna
      CN:Haina
      CO:Koromōpia
      CP:Te Moutere Kiripetone
      CR:Koto Rīka
      CU:Kiupa
      CV:Te Kūrae Matomato
      CW:Kurahao
      CX:Te Moutere Kirihimete
      CY:Haipara
      CZ:Tiekia
      DE:Tiamana
      DG:Tieko Kāhia
      DJ:Tipūti
      DK:Tenemāka
      DM:Tominika
      DO:Te Whenua Tūhake o Tominika
      DZ:Aratiria
      EA:Hūta me Merera
      EC:Ekuatoa
      EE:Etōnia
      EG:Īhipa
      EH:Hahāra ki te Tonga
      ER:Eritēria
      ES:Peina
      ET:Etiopia
      EU:Te Uniana o Ūropi
      EZ:Te Rohe o Ūropi
      FI:Whinarana
      FJ:Whītī
      FK:Motu Whākarangi
      FM:Mekanēhia
      FO:Motu Wharau
      FR:Wīwī
      GA:Kāpona
      GB:Te Hononga o Piritene
      GD:Kerenāta
      GE:Hōria
      GF:Kiāna Wīwī
      GG:Kōnihi
      GH:Kāna
      GI:Kāmaka
      GL:Whenuakāriki
      GM:Kamopia
      GN:Kini
      GP:Kuatarupa
      GQ:Kini Ekuatoria
      GR:Kirihi
      GS:Hōria ki te Tonga me ngā Motu Hanawiti ki te Tonga
      GT:Kuatamāra
      GU:Kuama
      GW:Kini-Pihao
      GY:Kaiana
      HK:Hongipua Haina
      HM:Ngā Moutere Heriti me Makitānara
      HN:Honotura
      HR:Koroātia
      HT:Haiti
      HU:Hanekari
      IC:Motu Kanēre
      ID:Initonīhia
      IE:Airani
      IL:Iharaira
      IM:Te Moutere Mana
      IN:Inia
      IO:Te Rohe o te Moana Īniana Piritihi
      IQ:Irāka
      IR:Irāna
      IS:Tiorangi
      IT:Itāria
      JE:Tōrehe
      JM:Hemeika
      JO:Hōrano
      JP:Hapani
      KE:Kenia
      KG:Kikitānga
      KH:Kamapōtia
      KI:Kiripati
      KM:Komoro
      KN:Hato Kiti me Newhi
      KP:Kōrea ki te Raki
      KR:Kōrea ki te Tonga
      KW:Kūweiti
      KY:Ngā Motu Keimana
      KZ:Katatānga
      LA:Rāoho
      LB:Repanona
      LC:Hato Ruhia
      LI:Rīkenetaina
      LK:Hiri Rānaka
      LR:Raipiria
      LS:Teroto
      LT:Rituānia
      LU:Rakapuō
      LV:Rāwhia
      LY:Ripia
      MA:Moroko
      MC:Monāko
      MD:Morotawa
      ME:Maungakororiko
      MF:Hato Mātene
      MG:Matakāhika
      MH:Ngā Motu Māhara
      MK:Makerōnia ki te Raki
      ML:Māri
      MM:Pēma
      MN:Mongōria
      MO:Makau Haina
      MP:Ngā Motu Mariana ki te Raki
      MQ:Mātiniki
      MR:Mauritānia
      MS:Monoterā
      MT:Mārata
      MU:Marihi
      MV:Māratiri
      MW:Marāwi
      MX:Mēhiko
      MY:Mareia
      MZ:Mohapiki
      NA:Namipia
      NC:Whenua Kanaki
      NE:Ngāika
      NF:Te Moutere Nōpoke
      NG:Ngāitiria
      NI:Nikarāhua
      NL:Hōrana
      NO:Nōwei
      NP:Nepōra
      NR:Nauru
      NU:Niue
      NZ:Aotearoa
      OM:Ōmana
      PA:Panama
      PE:Peru
      PF:Poronēhia Wīwī
      PG:Papua Nūkini
      PH:Piripīni
      PK:Pakitāne
      PL:Pōrana
      PM:Hato Piere & Mikerona
      PN:Pitikeina
      PR:Peta Riko
      PS:Ngā Rohe o Parihitini
      PT:Potukara
      PW:Pārau
      PY:Parakai
      QA:Katā
      QO:Ngā Moutere-a-Kiwa o Waho atu
      RE:Reūnio
      RO:Romeinia
      RS:Hirupia
      RU:Rūhia
      RW:Rāwana
      SA:Hauri Arāpia
      SB:Ngā Motu Horomona
      SC:Heikere
      SD:Hūtāne
      SE:Huitene
      SG:Hingapoa
      SH:Hato Hērena
      SI:Horowinia
      SJ:Heopara me Iana Maiana
      SK:Horowākia
      SL:Te Araone
      SM:Hana Marino
      SN:Henekara
      SO:Hūmārie
      SR:Huriname
      SS:Hūtāne ki te Tonga
      ST:Hato Tomei me Pirinipei
      SV:Whakaora
      SX:Hiti Mātene
      SY:Hiria
      SZ:Ehiwatini
      TA:Tiritana da Kunia
      TC:Koru-Kākoa
      TD:Kāta
      TF:Ngā Rohe o Wīwī ki te Tonga
      TG:Toko
      TH:Tairanga
      TJ:Takiritānga
      TK:Tokerau
      TL:Tīmoa ki te Rāwhiti
      TM:Tukumanatānga
      TN:Tūnihia
      TO:Tonga
      TR:Tākei
      TT:Tirinaki Tōpako
      TV:Tūwaru
      TW:Taiwana
      TZ:Tānahia
      UA:Ukareinga
      UG:Ukānga
      UM:Ngā Moutere Amerika o Waho
      UN:Te Rūnanga Whakakotahi i ngā Iwi o te Ao
      US:Hononga o Amerika
      UY:Urukoi
      UZ:Uhipeketāne
      VA:Te Poho-o-Pita
      VC:Hato Wēneti me Keretīni
      VE:Penehūera
      VG:Ngā Moutere Puhi Piritene
      VI:Ngā Moutere Puhi Amerika
      VN:Whitināmu
      VU:Whenuatū
      WF:Warihi me Whutuna
      WS:Hāmoa
      XA:Mita kikoika
      XB:Piri Kikoika
      XK:Kōhoro
      YE:Īmene
      YT:Māiota
      ZA:Āwherika ki te Tonga
      ZM:Tāmipia
      ZW:Timuwawe
      ZZ:Rohe Tē Mōhiotia
      """.trimIndent() }

  val mk: String by lazy { """
      001:Свет
      002:Африка
      003:Северна Америка
      005:Јужна Америка
      009:Океанија
      011:Западна Африка
      013:Централна Америка
      014:Источна Африка
      015:Северна Африка
      017:Средна Африка
      018:Јужна Африка
      019:Америки
      021:Северна континентална Америка
      029:Кариби
      030:Источна Азија
      034:Јужна Азија
      035:Југоисточна Азија
      039:Јужна Европа
      053:Австралазија
      054:Меланезија
      057:Микронезиски регион
      061:Полинезија
      142:Азија
      143:Централна Азија
      145:Западна Азија
      150:Европа
      151:Источна Европа
      154:Северна Европа
      155:Западна Европа
      202:Супсахарска Африка
      419:Латинска Америка
      AC:Остров Асенсион
      AD:Андора
      AE:Обединети Арапски Емирати
      AF:Авганистан
      AG:Антига и Барбуда
      AI:Ангвила
      AL:Албанија
      AM:Ерменија
      AO:Ангола
      AQ:Антарктик
      AR:Аргентина
      AS:Американска Самоа
      AT:Австрија
      AU:Австралија
      AW:Аруба
      AX:Оландски Острови
      AZ:Азербејџан
      BA:Босна и Херцеговина
      BB:Барбадос
      BD:Бангладеш
      BE:Белгија
      BF:Буркина Фасо
      BG:Бугарија
      BH:Бахреин
      BI:Бурунди
      BJ:Бенин
      BL:Свети Вартоломеј
      BM:Бермуди
      BN:Брунеј
      BO:Боливија
      BQ:Карипска Холандија
      BR:Бразил
      BS:Бахами
      BT:Бутан
      BV:Остров Буве
      BW:Боцвана
      BY:Белорусија
      BZ:Белизе
      CA:Канада
      CC:Кокосови (Килиншки) Острови
      CD:Конго - Киншаса
      CF:Централноафриканска Република
      CG:Конго - Бразавил
      CH:Швајцарија
      CI:Брегот на Слоновата Коска
      CK:Кукови Острови
      CL:Чиле
      CM:Камерун
      CN:Кина
      CO:Колумбија
      CP:Остров Клипертон
      CR:Костарика
      CU:Куба
      CV:Кабо Верде
      CW:Курасао
      CX:Божиќен Остров
      CY:Кипар
      CZ:Чешка
      DE:Германија
      DG:Диего Гарсија
      DJ:Џибути
      DK:Данска
      DM:Доминика
      DO:Доминиканска Република
      DZ:Алжир
      EA:Сеута и Мелиља
      EC:Еквадор
      EE:Естонија
      EG:Египет
      EH:Западна Сахара
      ER:Еритреја
      ES:Шпанија
      ET:Етиопија
      EU:Европска унија
      EZ:Еврозона
      FI:Финска
      FJ:Фиџи
      FK:Фолкландски Острови
      FM:Микронезија
      FO:Фарски Острови
      FR:Франција
      GA:Габон
      GB:Обединето Кралство
      GD:Гренада
      GE:Грузија
      GF:Француска Гвајана
      GG:Гернзи
      GH:Гана
      GI:Гибралтар
      GL:Гренланд
      GM:Гамбија
      GN:Гвинеја
      GP:Гвадалупе
      GQ:Екваторска Гвинеја
      GR:Грција
      GS:Јужна Џорџија и Јужни Сендвички Острови
      GT:Гватемала
      GU:Гуам
      GW:Гвинеја Бисао
      GY:Гвајана
      HK:Хонгконг САР Кина
      HM:Остров Херд и Острови Мекдоналд
      HN:Хондурас
      HR:Хрватска
      HT:Хаити
      HU:Унгарија
      IC:Канарски Острови
      ID:Индонезија
      IE:Ирска
      IL:Израел
      IM:Остров Ман
      IN:Индија
      IO:Британска Индоокеанска Територија
      IQ:Ирак
      IR:Иран
      IS:Исланд
      IT:Италија
      JE:Џерси
      JM:Јамајка
      JO:Јордан
      JP:Јапонија
      KE:Кенија
      KG:Киргистан
      KH:Камбоџа
      KI:Кирибати
      KM:Коморски Острови
      KN:Свети Китс и Невис
      KP:Северна Кореја
      KR:Јужна Кореја
      KW:Кувајт
      KY:Кајмански Острови
      KZ:Казахстан
      LA:Лаос
      LB:Либан
      LC:Сент Лусија
      LI:Лихтенштајн
      LK:Шри Ланка
      LR:Либерија
      LS:Лесото
      LT:Литванија
      LU:Луксембург
      LV:Латвија
      LY:Либија
      MA:Мароко
      MC:Монако
      MD:Молдавија
      ME:Црна Гора
      MF:Сент Мартин
      MG:Мадагаскар
      MH:Маршалски Острови
      MK:Северна Македонија
      ML:Мали
      MM:Мјанмар (Бурма)
      MN:Монголија
      MO:Макао САР
      MP:Северни Маријански Острови
      MQ:Мартиник
      MR:Мавританија
      MS:Монсерат
      MT:Малта
      MU:Маврициус
      MV:Малдиви
      MW:Малави
      MX:Мексико
      MY:Малезија
      MZ:Мозамбик
      NA:Намибија
      NC:Нова Каледонија
      NE:Нигер
      NF:Норфолшки Остров
      NG:Нигерија
      NI:Никарагва
      NL:Холандија
      NO:Норвешка
      NP:Непал
      NR:Науру
      NU:Ниује
      NZ:Нов Зеланд
      OM:Оман
      PA:Панама
      PE:Перу
      PF:Француска Полинезија
      PG:Папуа Нова Гвинеја
      PH:Филипини
      PK:Пакистан
      PL:Полска
      PM:Сент Пјер и Микелан
      PN:Питкернски Острови
      PR:Порторико
      PS:Палестински Територии
      PT:Португалија
      PW:Палау
      PY:Парагвај
      QA:Катар
      QO:Зависни земји во Океанија
      RE:Рејунион
      RO:Романија
      RS:Србија
      RU:Русија
      RW:Руанда
      SA:Саудиска Арабија
      SB:Соломонски Острови
      SC:Сејшели
      SD:Судан
      SE:Шведска
      SG:Сингапур
      SH:Света Елена
      SI:Словенија
      SJ:Свалбард и Јан Мајен
      SK:Словачка
      SL:Сиера Леоне
      SM:Сан Марино
      SN:Сенегал
      SO:Сомалија
      SR:Суринам
      SS:Јужен Судан
      ST:Саун Томе и Принсип
      SV:Ел Салвадор
      SX:Свети Мартин
      SY:Сирија
      SZ:Свазиленд
      TA:Тристан да Куња
      TC:Острови Туркс и Каикос
      TD:Чад
      TF:Француски Јужни Територии
      TG:Того
      TH:Тајланд
      TJ:Таџикистан
      TK:Токелау
      TL:Тимор Лесте
      TM:Туркменистан
      TN:Тунис
      TO:Тонга
      TR:Турција
      TT:Тринидад и Тобаго
      TV:Тувалу
      TW:Тајван
      TZ:Танзанија
      UA:Украина
      UG:Уганда
      UM:Американски територии во Пацификот
      UN:Обединети нации
      US:Соединети Американски Држави
      UY:Уругвај
      UZ:Узбекистан
      VA:Ватикан
      VC:Сент Винсент и Гренадини
      VE:Венецуела
      VG:Британски Девствени Острови
      VI:Американски Девствени Острови
      VN:Виетнам
      VU:Вануату
      WF:Валис и Футуна
      WS:Самоа
      XA:псевдо-акценти
      XB:псевдо-биди
      XK:Косово
      YE:Јемен
      YT:Мајот
      ZA:Јужноафриканска Република
      ZM:Замбија
      ZW:Зимбабве
      ZZ:Непознат регион
      """.trimIndent() }

  val ml: String by lazy { """
      001:ലോകം
      002:ആഫ്രിക്ക
      003:വടക്കേ അമേരിക്ക
      005:തെക്കേ അമേരിക്ക
      009:ഓഷ്യാനിയ
      011:പശ്ചിമ ആഫ്രിക്ക
      013:മദ്ധ്യ അമേരിക്ക
      014:കിഴക്കൻ ആഫ്രിക്ക
      015:ഉത്തരാഫ്രിക്ക
      017:മദ്ധ്യ ആഫ്രിക്ക
      018:തെക്കേ ആഫ്രിക്ക
      019:അമേരിക്കകൾ
      021:വടക്കൻ അമേരിക്ക
      029:കരീബിയൻ
      030:കിഴക്കൻ ഏഷ്യ
      034:തെക്കേ ഏഷ്യ
      035:തെക്ക്-കിഴക്കൻ ഏഷ്യ
      039:തെക്കേ യൂറോപ്പ്
      053:ഓസ്‌ട്രേലിയയും ന്യൂസിലാൻഡും
      054:മെലനേഷ്യ
      057:മൈക്രോനേഷ്യൻ പ്രദേശം
      061:പോളിനേഷ്യ
      142:ഏഷ്യ
      143:മദ്ധ്യേഷ്യ
      145:പശ്ചിമേഷ്യ
      150:യൂറോപ്പ്
      151:കിഴക്കൻ യൂറോപ്പ്
      154:വടക്കേ യൂറോപ്പ്
      155:പശ്ചിമ യൂറോപ്പ്
      202:സബ്-സഹാറൻ ആഫ്രിക്ക
      419:ലാറ്റിനമേരിക്ക
      AC:അസൻഷൻ ദ്വീപ്
      AD:അൻഡോറ
      AE:യുണൈറ്റഡ് അറബ് എമിറൈറ്റ്‌സ്
      AF:അഫ്‌ഗാനിസ്ഥാൻ
      AG:ആൻറിഗ്വയും ബർബുഡയും
      AI:ആൻഗ്വില്ല
      AL:അൽബേനിയ
      AM:അർമേനിയ
      AO:അംഗോള
      AQ:അന്റാർട്ടിക്ക
      AR:അർജന്റീന
      AS:അമേരിക്കൻ സമോവ
      AT:ഓസ്ട്രിയ
      AU:ഓസ്‌ട്രേലിയ
      AW:അറൂബ
      AX:അലൻഡ് ദ്വീപുകൾ
      AZ:അസർബൈജാൻ
      BA:ബോസ്നിയയും ഹെർസഗോവിനയും
      BB:ബാർബഡോസ്
      BD:ബംഗ്ലാദേശ്
      BE:ബെൽജിയം
      BF:ബർക്കിന ഫാസോ
      BG:ബൾഗേറിയ
      BH:ബഹ്റിൻ
      BI:ബറുണ്ടി
      BJ:ബെനിൻ
      BL:സെന്റ് ബാർത്തലമി
      BM:ബർമുഡ
      BN:ബ്രൂണൈ
      BO:ബൊളീവിയ
      BQ:കരീബിയൻ നെതർലാൻഡ്സ്
      BR:ബ്രസീൽ
      BS:ബഹാമാസ്
      BT:ഭൂട്ടാൻ
      BV:ബൗവെട്ട് ദ്വീപ്
      BW:ബോട്സ്വാന
      BY:ബെലറൂസ്
      BZ:ബെലീസ്
      CA:കാനഡ
      CC:കോക്കസ് (കീലിംഗ്) ദ്വീപുകൾ
      CD:കോംഗോ - കിൻഷാസ
      CF:സെൻട്രൽ ആഫ്രിക്കൻ റിപ്പബ്ലിക്ക്
      CG:കോംഗോ - ബ്രാസവില്ലി
      CH:സ്വിറ്റ്സർലാൻഡ്
      CI:കോട്ട് ഡി വാർ
      CK:കുക്ക് ദ്വീപുകൾ
      CL:ചിലി
      CM:കാമറൂൺ
      CN:ചൈന
      CO:കൊളംബിയ
      CP:ക്ലിപ്പെർട്ടൻ ദ്വീപ്
      CR:കോസ്റ്ററിക്ക
      CU:ക്യൂബ
      CV:കേപ്പ് വേർഡ്
      CW:കുറാകാവോ
      CX:ക്രിസ്മസ് ദ്വീപ്
      CY:സൈപ്രസ്
      CZ:ചെക്കിയ
      DE:ജർമ്മനി
      DG:ഡീഗോ ഗ്രാഷ്യ
      DJ:ജിബൂത്തി
      DK:ഡെൻമാർക്ക്
      DM:ഡൊമിനിക്ക
      DO:ഡൊമിനിക്കൻ റിപ്പബ്ലിക്ക്
      DZ:അൾജീരിയ
      EA:സെയൂത്ത ആൻഡ് മെലിയ
      EC:ഇക്വഡോർ
      EE:എസ്റ്റോണിയ‍
      EG:ഈജിപ്ത്
      EH:പശ്ചിമ സഹാറ
      ER:എറിത്രിയ
      ES:സ്‌പെയിൻ
      ET:എത്യോപ്യ
      EU:യൂറോപ്യൻ യൂണിയൻ
      EZ:യൂറോസോൺ
      FI:ഫിൻലാൻഡ്
      FJ:ഫിജി
      FK:ഫാക്ക്‌ലാന്റ് ദ്വീപുകൾ
      FM:മൈക്രോനേഷ്യ
      FO:ഫറോ ദ്വീപുകൾ
      FR:ഫ്രാൻസ്
      GA:ഗാബൺ
      GB:യുണൈറ്റഡ് കിംഗ്ഡം
      GD:ഗ്രനേഡ
      GE:ജോർജ്ജിയ
      GF:ഫ്രഞ്ച് ഗയാന
      GG:ഗേൺസി
      GH:ഘാന
      GI:ജിബ്രാൾട്ടർ
      GL:ഗ്രീൻലൻഡ്
      GM:ഗാംബിയ
      GN:ഗിനിയ
      GP:ഗ്വാഡലൂപ്പ്
      GQ:ഇക്വറ്റോറിയൽ ഗിനിയ
      GR:ഗ്രീസ്
      GS:ദക്ഷിണ ജോർജ്ജിയയും ദക്ഷിണ സാൻഡ്‌വിച്ച് ദ്വീപുകളും
      GT:ഗ്വാട്ടിമാല
      GU:ഗ്വാം
      GW:ഗിനിയ-ബിസൗ
      GY:ഗയാന
      HK:ഹോങ്കോങ് (SAR) ചൈന
      HM:ഹേർഡ്, മക്ഡോണൾഡ് ദ്വീപുകൾ
      HN:ഹോണ്ടുറാസ്
      HR:ക്രൊയേഷ്യ
      HT:ഹെയ്തി
      HU:ഹംഗറി
      IC:കാനറി ദ്വീപുകൾ
      ID:ഇന്തോനേഷ്യ
      IE:അയർലൻഡ്
      IL:ഇസ്രായേൽ
      IM:ഐൽ ഓഫ് മാൻ
      IN:ഇന്ത്യ
      IO:ബ്രിട്ടീഷ് ഇന്ത്യൻ ഓഷ്യൻ ടെറിട്ടറി
      IQ:ഇറാഖ്
      IR:ഇറാൻ
      IS:ഐസ്‌ലാന്റ്
      IT:ഇറ്റലി
      JE:ജേഴ്സി
      JM:ജമൈക്ക
      JO:ജോർദ്ദാൻ
      JP:ജപ്പാൻ
      KE:കെനിയ
      KG:കിർഗിസ്ഥാൻ
      KH:കംബോഡിയ
      KI:കിരിബാട്ടി
      KM:കോമൊറോസ്
      KN:സെന്റ് കിറ്റ്‌സും നെവിസും
      KP:ഉത്തരകൊറിയ
      KR:ദക്ഷിണകൊറിയ
      KW:കുവൈറ്റ്
      KY:കേയ്മാൻ ദ്വീപുകൾ
      KZ:കസാഖിസ്ഥാൻ
      LA:ലാവോസ്
      LB:ലെബനൻ
      LC:സെന്റ് ലൂസിയ
      LI:ലിച്ചൺസ്റ്റൈൻ
      LK:ശ്രീലങ്ക
      LR:ലൈബീരിയ
      LS:ലെസോതോ
      LT:ലിത്വാനിയ
      LU:ലക്സംബർഗ്
      LV:ലാറ്റ്വിയ
      LY:ലിബിയ
      MA:മൊറോക്കൊ
      MC:മൊണാക്കോ
      MD:മൾഡോവ
      ME:മോണ്ടെനെഗ്രോ
      MF:സെന്റ് മാർട്ടിൻ
      MG:മഡഗാസ്കർ
      MH:മാർഷൽ ദ്വീപുകൾ
      MK:നോർത്ത് മാസിഡോണിയ
      ML:മാലി
      MM:മ്യാൻമാർ (ബർമ്മ)
      MN:മംഗോളിയ
      MO:മക്കാവു എസ്.എ.ആർ. ചൈന
      MP:ഉത്തര മറിയാനാ ദ്വീപുകൾ
      MQ:മാർട്ടിനിക്ക്
      MR:മൗറിറ്റാനിയ
      MS:മൊണ്ടെസരത്ത്
      MT:മാൾട്ട
      MU:മൗറീഷ്യസ്
      MV:മാലിദ്വീപ്
      MW:മലാവി
      MX:മെക്സിക്കോ
      MY:മലേഷ്യ
      MZ:മൊസാംബിക്ക്
      NA:നമീബിയ
      NC:ന്യൂ കാലിഡോണിയ
      NE:നൈജർ
      NF:നോർഫോക് ദ്വീപ്
      NG:നൈജീരിയ
      NI:നിക്കരാഗ്വ
      NL:നെതർലാൻഡ്‌സ്
      NO:നോർവെ
      NP:നേപ്പാൾ
      NR:നൗറു
      NU:ന്യൂയി
      NZ:ന്യൂസിലൻഡ്
      OM:ഒമാൻ
      PA:പനാമ
      PE:പെറു
      PF:ഫ്രഞ്ച് പോളിനേഷ്യ
      PG:പാപ്പുവ ന്യൂ ഗിനിയ
      PH:ഫിലിപ്പീൻസ്
      PK:പാക്കിസ്ഥാൻ
      PL:പോളണ്ട്
      PM:സെന്റ് പിയറി ആൻഡ് മിക്വലൻ
      PN:പിറ്റ്‌കെയ്‌ൻ ദ്വീപുകൾ
      PR:പോർട്ടോ റിക്കോ
      PS:പാലസ്‌തീൻ പ്രദേശങ്ങൾ
      PT:പോർച്ചുഗൽ
      PW:പലാവു
      PY:പരാഗ്വേ
      QA:ഖത്തർ
      QO:ദ്വീപസമൂഹം
      RE:റീയൂണിയൻ
      RO:റൊമാനിയ
      RS:സെർബിയ
      RU:റഷ്യ
      RW:റുവാണ്ട
      SA:സൗദി അറേബ്യ
      SB:സോളമൻ ദ്വീപുകൾ
      SC:സീഷെൽസ്
      SD:സുഡാൻ
      SE:സ്വീഡൻ
      SG:സിംഗപ്പൂർ
      SH:സെന്റ് ഹെലീന
      SI:സ്ലോവേനിയ
      SJ:സ്വാൽബാഡും ജാൻ മായേനും
      SK:സ്ലോവാക്യ
      SL:സിയെറ ലിയോൺ
      SM:സാൻ മറിനോ
      SN:സെനഗൽ
      SO:സോമാലിയ
      SR:സുരിനാം
      SS:ദക്ഷിണ സുഡാൻ
      ST:സാവോ ടോമും പ്രിൻസിപെയും
      SV:എൽ സാൽവദോർ
      SX:സിന്റ് മാർട്ടെൻ
      SY:സിറിയ
      SZ:സ്വാസിലൻഡ്
      TA:ട്രിസ്റ്റൻ ഡ കൂന
      TC:ടർക്ക്‌സും കെയ്‌ക്കോ ദ്വീപുകളും
      TD:ഛാഡ്
      TF:ഫ്രഞ്ച് ദക്ഷിണ ഭൂപ്രദേശം
      TG:ടോഗോ
      TH:തായ്‌ലാൻഡ്
      TJ:താജിക്കിസ്ഥാൻ
      TK:ടോക്കെലൂ
      TL:തിമോർ-ലെസ്റ്റെ
      TM:തുർക്ക്മെനിസ്ഥാൻ
      TN:ടുണീഷ്യ
      TO:ടോംഗ
      TR:തുർക്കിയെ
      TT:ട്രിനിഡാഡും ടുബാഗോയും
      TV:ടുവാലു
      TW:തായ്‌വാൻ
      TZ:ടാൻസാനിയ
      UA:ഉക്രെയ്‌ൻ
      UG:ഉഗാണ്ട
      UM:യു.എസ്. ദ്വീപസമൂഹങ്ങൾ
      UN:ഐക്യരാഷ്ട്രസഭ
      US:അമേരിക്കൻ ഐക്യനാടുകൾ
      UY:ഉറുഗ്വേ
      UZ:ഉസ്‌ബെക്കിസ്ഥാൻ
      VA:വത്തിക്കാൻ
      VC:സെന്റ് വിൻസെന്റും ഗ്രനെഡൈൻസും
      VE:വെനിസ്വേല
      VG:ബ്രിട്ടീഷ് വെർജിൻ ദ്വീപുകൾ
      VI:യു.എസ്. വെർജിൻ ദ്വീപുകൾ
      VN:വിയറ്റ്നാം
      VU:വന്വാതു
      WF:വാലിസ് ആന്റ് ഫ്യൂച്യുന
      WS:സമോവ
      XA:കൃത്രിമ ഉച്ചാരണം
      XB:സ്യൂഡോ-ബൈഡി
      XK:കൊസോവൊ
      YE:യെമൻ
      YT:മയോട്ടി
      ZA:ദക്ഷിണാഫ്രിക്ക
      ZM:സാംബിയ
      ZW:സിംബാബ്‌വേ
      ZZ:അജ്ഞാത പ്രദേശം
      """.trimIndent() }

  val mn: String by lazy { """
      001:Дэлхий
      002:Африк
      003:Хойд Америк
      005:Өмнөд Америк
      009:Номхон далайн орнууд
      011:Баруун Африк
      013:Төв Америк
      014:Зүүн Африк
      015:Хойд Африк
      017:Төв Африк
      018:Өмнөд Африк тив
      019:Америк
      021:Хойд Америк тив
      029:Карибын тэнгис
      030:Зүүн Ази
      034:Өмнөд Ази
      035:Зүүн өмнөд Ази
      039:Өмнөд Европ
      053:Австрали-Ази
      054:Меланези
      057:Микронезийн бүс
      061:Полинези
      142:Ази
      143:Төв Ази
      145:Баруун Ази
      150:Европ
      151:Зүүн Европ
      154:Хойд Европ
      155:Баруун Европ
      202:Сахарын цөлийн урд хэсгийн Африк
      419:Латин Америк
      AC:Асенсион арал
      AD:Андорра
      AE:Арабын Нэгдсэн Эмират Улс
      AF:Афганистан
      AG:Антигуа ба Барбуда
      AI:Ангилья
      AL:Албани
      AM:Армени
      AO:Ангол
      AQ:Антарктид
      AR:Аргентин
      AS:Америкийн Самоа
      AT:Австри
      AU:Австрали
      AW:Аруба
      AX:Аландын арлууд
      AZ:Азербайжан
      BA:Босни-Херцеговин
      BB:Барбадос
      BD:Бангладеш
      BE:Бельги
      BF:Буркина Фасо
      BG:Болгар
      BH:Бахрейн
      BI:Бурунди
      BJ:Бенин
      BL:Сент-Бартельми
      BM:Бермуда
      BN:Бруней
      BO:Боливи
      BQ:Карибын Нидерланд
      BR:Бразил
      BS:Багамын арлууд
      BT:Бутан
      BV:Буве арал
      BW:Ботсван
      BY:Беларусь
      BZ:Белизе
      CA:Канад
      CC:Кокос (Кийлинг) арлууд
      CD:Конго-Киншаса
      CF:Төв Африкийн Бүгд Найрамдах Улс
      CG:Конго-Браззавиль
      CH:Швейцар
      CI:Кот-д’Ивуар
      CK:Күүкийн арлууд
      CL:Чили
      CM:Камерун
      CN:Хятад
      CO:Колумби
      CP:Клиппертон арал
      CR:Коста-Рика
      CU:Куба
      CV:Кабо-Верде
      CW:Кюрасао
      CX:Зул сарын арал
      CY:Кипр
      CZ:Чех
      DE:Герман
      DG:Диего Гарсиа
      DJ:Джибути
      DK:Дани
      DM:Доминика
      DO:Бүгд Найрамдах Доминикан Улс
      DZ:Алжир
      EA:Сеута ба Мелилья
      EC:Эквадор
      EE:Эстони
      EG:Египет
      EH:Баруун Сахар
      ER:Эритрей
      ES:Испани
      ET:Этиоп
      EU:Европын Холбоо
      EZ:Евро бүс
      FI:Финланд
      FJ:Фижи
      FK:Фолклендийн арлууд
      FM:Микронези
      FO:Фарерын арлууд
      FR:Франц
      GA:Габон
      GB:Их Британи
      GD:Гренада
      GE:Гүрж
      GF:Францын Гвиана
      GG:Гернси
      GH:Гана
      GI:Гибралтар
      GL:Гренланд
      GM:Гамби
      GN:Гвиней
      GP:Гваделуп
      GQ:Экваторын Гвиней
      GR:Грек
      GS:Өмнөд Жоржиа ба Өмнөд Сэндвичийн арлууд
      GT:Гватемал
      GU:Гуам
      GW:Гвиней-Бисау
      GY:Гайана
      HK:БНХАУ-ын Тусгай захиргааны бүс Хонг-Конг
      HM:Херд ба Макдональдийн арлууд
      HN:Гондурас
      HR:Хорват
      HT:Гаити
      HU:Унгар
      IC:Канарын арлууд
      ID:Индонез
      IE:Ирланд
      IL:Израил
      IM:Мэн Арал
      IN:Энэтхэг
      IO:Британийн харьяа Энэтхэгийн далай дахь нутаг дэвсгэр
      IQ:Ирак
      IR:Иран
      IS:Исланд
      IT:Итали
      JE:Жерси
      JM:Ямайка
      JO:Йордан
      JP:Япон
      KE:Кени
      KG:Киргиз
      KH:Камбож
      KI:Кирибати
      KM:Коморын арлууд
      KN:Сент-Киттс ба Невис
      KP:Хойд Солонгос
      KR:Өмнөд Солонгос
      KW:Кувейт
      KY:Кайманы арлууд
      KZ:Казахстан
      LA:Лаос
      LB:Ливан
      LC:Сент Люсиа
      LI:Лихтенштайн
      LK:Шри-Ланка
      LR:Либери
      LS:Лесото
      LT:Литва
      LU:Люксембург
      LV:Латви
      LY:Ливи
      MA:Морокко
      MC:Монако
      MD:Молдова
      ME:Монтенегро
      MF:Сент-Мартин
      MG:Мадагаскар
      MH:Маршаллын арлууд
      MK:Хойд Македон
      ML:Мали
      MM:Мьянмар
      MN:Монгол
      MO:БНХАУ-ын Тусгай захиргааны бүс Макао
      MP:Хойд Марианы арлууд
      MQ:Мартиник
      MR:Мавритани
      MS:Монтсеррат
      MT:Мальта
      MU:Маврикий
      MV:Мальдив
      MW:Малави
      MX:Мексик
      MY:Малайз
      MZ:Мозамбик
      NA:Намиби
      NC:Шинэ Каледони
      NE:Нигер
      NF:Норфолк арал
      NG:Нигери
      NI:Никарагуа
      NL:Нидерланд
      NO:Норвег
      NP:Балба
      NR:Науру
      NU:Ниуэ
      NZ:Шинэ Зеланд
      OM:Оман
      PA:Панам
      PE:Перу
      PF:Францын Полинез
      PG:Папуа Шинэ Гвиней
      PH:Филиппин
      PK:Пакистан
      PL:Польш
      PM:Сент-Пьер ба Микело
      PN:Питкэрн арлууд
      PR:Пуэрто-Рико
      PS:Палестины нутаг дэвсгэр
      PT:Португал
      PW:Палау
      PY:Парагвай
      QA:Катар
      QO:Номхон далайг тойрсон улс орнууд
      RE:Реюнион
      RO:Румын
      RS:Серби
      RU:Орос
      RW:Руанда
      SA:Саудын Араб
      SB:Соломоны арлууд
      SC:Сейшелийн арлууд
      SD:Судан
      SE:Швед
      SG:Сингапур
      SH:Сент Хелена
      SI:Словени
      SJ:Свалбард ба Ян Майен
      SK:Словак
      SL:Сьерра-Леоне
      SM:Сан-Марино
      SN:Сенегал
      SO:Сомали
      SR:Суринам
      SS:Өмнөд Судан
      ST:Сан-Томе ба Принсипи
      SV:Эль Сальвадор
      SX:Синт Мартен
      SY:Сири
      SZ:Эсватини
      TA:Тристан да Кунъя
      TC:Турк ба Кайкосын Арлууд
      TD:Чад
      TF:Францын өмнөд газар нутаг
      TG:Того
      TH:Тайланд
      TJ:Тажикистан
      TK:Токелау
      TL:Тимор-Лесте
      TM:Туркменистан
      TN:Тунис
      TO:Тонга
      TR:Турк
      TT:Тринидад ба Тобаго
      TV:Тувалу
      TW:Тайвань
      TZ:Танзани
      UA:Украин
      UG:Уганда
      UM:Америкийн Нэгдсэн Улсын бага арлууд
      UN:Нэгдсэн Үндэстний Байгууллага
      US:Америкийн Нэгдсэн Улс
      UY:Уругвай
      UZ:Узбекистан
      VA:Ватикан хот улс
      VC:Сент-Винсент ба Гренадин
      VE:Венесуэл
      VG:Британийн Виржиний арлууд
      VI:АНУ-ын Виржиний арлууд
      VN:Вьетнам
      VU:Вануату
      WF:Уоллис ба Футуна
      WS:Самоа
      XA:хуурмаг аялга
      XB:хуурмаг хоёр чиглэлт
      XK:Косово
      YE:Йемен
      YT:Майотта
      ZA:Өмнөд Африк
      ZM:Замби
      ZW:Зимбабве
      ZZ:Тодорхойгүй бүс
      """.trimIndent() }

  val mn_Mong_MN: String by lazy { """
      BR:ᠪᠷᠠᠽᠢᠯ
      CN:ᠬᠢᠳᠠᠳ
      DE:ᠭᠧᠷᠮᠠᠨ
      FR:ᠫᠷᠠᠨ᠋᠋ᠼᠠ
      GB:ᠶᠡᠺᠡ ᠪᠷᠢᠲ᠋ᠠᠨᠢ
      IN:ᠡᠨᠡᠳᠬᠡᠭ᠌
      IT:ᠢᠲ᠋ᠠᠯᠢ
      JP:ᠶᠠᠫᠣᠨ
      MN:ᠮᠣᠩᠭᠣᠯ
      RU:ᠣᠷᠣᠰ
      US:ᠠᠮᠸᠷᠢᠻᠠ ᠎ᠢᠢᠨ ᠨᠢᠭᠡᠳᠥᠭᠰᠡᠠ ᠡᠣᠯᠣᠰ
      ZZ:ᠳᠣᠳᠣᠷᠬᠠᠢ ᠥᠭᠡᠢ ᠪᠥᠰᠠ
      """.trimIndent() }

  val mni: String by lazy { """
      001:মালেম
      002:অফ্রিকা
      019:অমেরিকাশিং
      150:য়ুরোপ
      BR:ব্রাজিল
      CN:চিনা
      DE:জর্মনি
      FR:ফ্রান্স
      GB:য়ুনাইটেদ কিংদম
      IN:ইন্দিয়া
      IT:ইটালি
      JP:জাপান
      RU:রুসিয়া
      US:য়ুনাইটেদ ষ্টেটস
      ZZ:মশকখংদবা লমদম
      """.trimIndent() }

  val mni_Beng: String? = null

  val mr: String by lazy { """
      001:जग
      002:आफ्रिका
      003:उत्तर अमेरिका
      005:दक्षिण अमेरिका
      009:ओशनिया
      011:पश्चिम आफ्रिका
      013:मध्य अमेरिका
      014:पूर्व आफ्रिका
      015:उत्तर आफ्रिका
      017:मध्य आफ्रिका
      018:दक्षिणी आफ्रिका
      019:अमेरिका
      021:उत्तरी अमेरिका
      029:कॅरीबियन
      030:पूर्व आशिया
      034:दक्षिण आशिया
      035:दक्षिण पूर्व आशिया
      039:दक्षिण युरोप
      053:ऑस्‍ट्रेलेशिया
      054:मेलानेशिया
      057:मायक्रोनेशियन प्रदेश
      061:पॉलिनेशिया
      142:आशिया
      143:मध्य आशिया
      145:पश्चिम आशिया
      150:युरोप
      151:पूर्व युरोप
      154:उत्तर युरोप
      155:पश्चिम युरोप
      202:उप-सहारा आफ्रिका
      419:लॅटिन अमेरिका
      AC:अ‍ॅसेन्शियन बेट
      AD:अँडोरा
      AE:संयुक्त अरब अमीरात
      AF:अफगाणिस्तान
      AG:अँटिग्वा आणि बर्बुडा
      AI:अँग्विला
      AL:अल्बानिया
      AM:अर्मेनिया
      AO:अंगोला
      AQ:अंटार्क्टिका
      AR:अर्जेंटिना
      AS:अमेरिकन सामोआ
      AT:ऑस्ट्रिया
      AU:ऑस्ट्रेलिया
      AW:अरुबा
      AX:अ‍ॅलँड बेटे
      AZ:अझरबैजान
      BA:बोस्निया अणि हर्जेगोविना
      BB:बार्बाडोस
      BD:बांगलादेश
      BE:बेल्जियम
      BF:बुर्किना फासो
      BG:बल्गेरिया
      BH:बहारीन
      BI:बुरुंडी
      BJ:बेनिन
      BL:सेंट बार्थेलेमी
      BM:बर्मुडा
      BN:ब्रुनेई
      BO:बोलिव्हिया
      BQ:कॅरिबियन नेदरलँड्स
      BR:ब्राझिल
      BS:बहामाज
      BT:भूतान
      BV:बोउवेट बेट
      BW:बोट्सवाना
      BY:बेलारूस
      BZ:बेलिझे
      CA:कॅनडा
      CC:कोकोस (कीलिंग) बेटे
      CD:काँगो - किंशासा
      CF:केंद्रीय अफ्रिकी प्रजासत्ताक
      CG:काँगो - ब्राझाविले
      CH:स्वित्झर्लंड
      CI:कोत द’ईवोआर
      CK:कुक बेटे
      CL:चिली
      CM:कॅमेरून
      CN:चीन
      CO:कोलम्बिया
      CP:क्लिपरटोन बेट
      CR:कोस्टा रिका
      CU:क्यूबा
      CV:केप व्हर्डे
      CW:क्युरासाओ
      CX:ख्रिसमस बेट
      CY:सायप्रस
      CZ:झेकिया
      DE:जर्मनी
      DG:दिएगो गार्सिया
      DJ:जिबौटी
      DK:डेन्मार्क
      DM:डोमिनिका
      DO:डोमिनिकन प्रजासत्ताक
      DZ:अल्जीरिया
      EA:स्यूटा आणि मेलिला
      EC:इक्वाडोर
      EE:एस्टोनिया
      EG:इजिप्त
      EH:पश्चिम सहारा
      ER:एरिट्रिया
      ES:स्पेन
      ET:इथिओपिया
      EU:युरोपीय संघ
      EZ:युरोझोन
      FI:फिनलंड
      FJ:फिजी
      FK:फॉकलंड बेटे
      FM:मायक्रोनेशिया
      FO:फेरो बेटे
      FR:फ्रान्स
      GA:गॅबॉन
      GB:युनायटेड किंगडम
      GD:ग्रेनेडा
      GE:जॉर्जिया
      GF:फ्रेंच गयाना
      GG:ग्वेर्नसे
      GH:घाना
      GI:जिब्राल्टर
      GL:ग्रीनलंड
      GM:गाम्बिया
      GN:गिनी
      GP:ग्वाडेलोउपे
      GQ:इक्वेटोरियल गिनी
      GR:ग्रीस
      GS:दक्षिण जॉर्जिया आणि दक्षिण सँडविच बेटे
      GT:ग्वाटेमाला
      GU:गुआम
      GW:गिनी-बिसाउ
      GY:गयाना
      HK:हाँगकाँग एसएआर चीन
      HM:हर्ड आणि मॅक्डोनाल्ड बेटे
      HN:होंडुरास
      HR:क्रोएशिया
      HT:हैती
      HU:हंगेरी
      IC:कॅनरी बेटे
      ID:इंडोनेशिया
      IE:आयर्लंड
      IL:इस्त्राइल
      IM:आयल ऑफ मॅन
      IN:भारत
      IO:ब्रिटिश हिंद महासागर प्रदेश
      IQ:इराक
      IR:इराण
      IS:आइसलँड
      IT:इटली
      JE:जर्सी
      JM:जमैका
      JO:जॉर्डन
      JP:जपान
      KE:केनिया
      KG:किरगिझस्तान
      KH:कंबोडिया
      KI:किरीबाटी
      KM:कोमोरोज
      KN:सेंट किट्स आणि नेव्हिस
      KP:उत्तर कोरिया
      KR:दक्षिण कोरिया
      KW:कुवेत
      KY:केमन बेटे
      KZ:कझाकस्तान
      LA:लाओस
      LB:लेबनॉन
      LC:सेंट ल्यूसिया
      LI:लिक्टेनस्टाइन
      LK:श्रीलंका
      LR:लायबेरिया
      LS:लेसोथो
      LT:लिथुआनिया
      LU:लक्झेंबर्ग
      LV:लाटव्हिया
      LY:लिबिया
      MA:मोरोक्को
      MC:मोनॅको
      MD:मोल्डोव्हा
      ME:मोंटेनेग्रो
      MF:सेंट मार्टिन
      MG:मादागास्कर
      MH:मार्शल बेटे
      MK:उत्तर मॅसेडोनिया
      ML:माली
      MM:म्यानमार (बर्मा)
      MN:मंगोलिया
      MO:मकाओ एसएआर चीन
      MP:उत्तरी मारियाना बेटे
      MQ:मार्टिनिक
      MR:मॉरिटानिया
      MS:मॉन्ट्सेराट
      MT:माल्टा
      MU:मॉरिशस
      MV:मालदीव
      MW:मलावी
      MX:मेक्सिको
      MY:मलेशिया
      MZ:मोझाम्बिक
      NA:नामिबिया
      NC:न्यू कॅलेडोनिया
      NE:नाइजर
      NF:नॉरफॉक बेट
      NG:नायजेरिया
      NI:निकाराग्वा
      NL:नेदरलँड
      NO:नॉर्वे
      NP:नेपाळ
      NR:नाउरू
      NU:नीयू
      NZ:न्यूझीलंड
      OM:ओमान
      PA:पनामा
      PE:पेरू
      PF:फ्रेंच पॉलिनेशिया
      PG:पापुआ न्यू गिनी
      PH:फिलिपिन्स
      PK:पाकिस्तान
      PL:पोलंड
      PM:सेंट पियरे आणि मिक्वेलोन
      PN:पिटकैर्न बेटे
      PR:प्युएर्तो रिको
      PS:पॅलेस्टिनियन प्रदेश
      PT:पोर्तुगाल
      PW:पलाऊ
      PY:पराग्वे
      QA:कतार
      QO:आउटलाईंग ओशनिया
      RE:रियुनियन
      RO:रोमानिया
      RS:सर्बिया
      RU:रशिया
      RW:रवांडा
      SA:सौदी अरब
      SB:सोलोमन बेटे
      SC:सेशेल्स
      SD:सुदान
      SE:स्वीडन
      SG:सिंगापूर
      SH:सेंट हेलेना
      SI:स्लोव्हेनिया
      SJ:स्वालबर्ड आणि जान मायेन
      SK:स्लोव्हाकिया
      SL:सिएरा लिओन
      SM:सॅन मरीनो
      SN:सेनेगल
      SO:सोमालिया
      SR:सुरिनाम
      SS:दक्षिण सुदान
      ST:साओ टोम आणि प्रिंसिपे
      SV:अल साल्वाडोर
      SX:सिंट मार्टेन
      SY:सीरिया
      SZ:इस्वातिनी
      TA:ट्रिस्टन दा कुन्हा
      TC:टर्क्स आणि कैकोस बेटे
      TD:चाड
      TF:फ्रेंच दाक्षिणात्य प्रदेश
      TG:टोगो
      TH:थायलंड
      TJ:ताजिकिस्तान
      TK:तोकेलाउ
      TL:तिमोर-लेस्ते
      TM:तुर्कमेनिस्तान
      TN:ट्यूनिशिया
      TO:टोंगा
      TR:तुर्किये
      TT:त्रिनिदाद आणि टोबॅगो
      TV:टुवालु
      TW:तैवान
      TZ:टांझानिया
      UA:युक्रेन
      UG:युगांडा
      UM:यू.एस. आउटलाइंग बेटे
      UN:संयुक्त राष्ट्र
      US:युनायटेड स्टेट्स
      UY:उरुग्वे
      UZ:उझबेकिस्तान
      VA:व्हॅटिकन सिटी
      VC:सेंट व्हिन्सेंट आणि ग्रेनडाइन्स
      VE:व्हेनेझुएला
      VG:ब्रिटिश व्हर्जिन बेटे
      VI:यू.एस. व्हर्जिन बेटे
      VN:व्हिएतनाम
      VU:वानुआतु
      WF:वालिस आणि फ्यूचूना
      WS:सामोआ
      XA:नकली-उच्चारणे
      XB:नकली-बीडी
      XK:कोसोव्हो
      YE:येमेन
      YT:मायोट्टे
      ZA:दक्षिण आफ्रिका
      ZM:झाम्बिया
      ZW:झिम्बाब्वे
      ZZ:अज्ञात प्रदेश
      """.trimIndent() }

  val ms: String by lazy { """
      001:Dunia
      002:Afrika
      003:Amerika Utara
      005:Amerika Selatan
      009:Oceania
      011:Afrika Barat
      013:Amerika Tengah
      014:Afrika Timur
      015:Afrika Utara
      017:Afrika Tengah
      018:Selatan Afrika
      019:Amerika
      021:Utara Amerika
      029:Caribbean
      030:Asia Timur
      034:Asia Selatan
      035:Asia Tenggara
      039:Eropah Selatan
      053:Australasia
      054:Melanesia
      057:Wilayah Mikronesia
      061:Polinesia
      142:Asia
      143:Asia Tengah
      145:Asia Barat
      150:Eropah
      151:Eropah Timur
      154:Eropah Utara
      155:Eropah Barat
      202:Afrika Sub-Sahara
      419:Amerika Latin
      AC:Pulau Ascension
      AD:Andorra
      AE:Emiriah Arab Bersatu
      AF:Afghanistan
      AG:Antigua dan Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antartika
      AR:Argentina
      AS:Samoa Amerika
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Kepulauan Aland
      AZ:Azerbaijan
      BA:Bosnia dan Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgium
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:St. Barthelemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Belanda Caribbean
      BR:Brazil
      BS:Bahamas
      BT:Bhutan
      BV:Pulau Bouvet
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Kanada
      CC:Kepulauan Cocos (Keeling)
      CD:Congo - Kinshasa
      CF:Republik Afrika Tengah
      CG:Congo - Brazzaville
      CH:Switzerland
      CI:Cote d’Ivoire
      CK:Kepulauan Cook
      CL:Chile
      CM:Cameroon
      CN:China
      CO:Colombia
      CP:Pulau Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cape Verde
      CW:Curacao
      CX:Pulau Krismas
      CY:Cyprus
      CZ:Czechia
      DE:Jerman
      DG:Diego Garcia
      DJ:Djibouti
      DK:Denmark
      DM:Dominica
      DO:Republik Dominica
      DZ:Algeria
      EA:Ceuta dan Melilla
      EC:Ecuador
      EE:Estonia
      EG:Mesir
      EH:Sahara Barat
      ER:Eritrea
      ES:Sepanyol
      ET:Ethiopia
      EU:Kesatuan Eropah
      EZ:Zon Euro
      FI:Finland
      FJ:Fiji
      FK:Kepulauan Falkland
      FM:Micronesia
      FO:Kepulauan Faroe
      FR:Perancis
      GA:Gabon
      GB:United Kingdom
      GD:Grenada
      GE:Georgia
      GF:Guiana Perancis
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Greenland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Guinea Khatulistiwa
      GR:Greece
      GS:Kepulauan Georgia Selatan & Sandwich Selatan
      GT:Guatemala
      GU:Guam
      GW:Guinea Bissau
      GY:Guyana
      HK:Hong Kong SAR China
      HM:Kepulauan Heard & McDonald
      HN:Honduras
      HR:Croatia
      HT:Haiti
      HU:Hungary
      IC:Kepulauan Canary
      ID:Indonesia
      IE:Ireland
      IL:Israel
      IM:Isle of Man
      IN:India
      IO:Wilayah Lautan Hindi British
      IQ:Iraq
      IR:Iran
      IS:Iceland
      IT:Itali
      JE:Jersey
      JM:Jamaica
      JO:Jordan
      JP:Jepun
      KE:Kenya
      KG:Kyrgyzstan
      KH:Kemboja
      KI:Kiribati
      KM:Comoros
      KN:Saint Kitts dan Nevis
      KP:Korea Utara
      KR:Korea Selatan
      KW:Kuwait
      KY:Kepulauan Cayman
      KZ:Kazakhstan
      LA:Laos
      LB:Lubnan
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lithuania
      LU:Luxembourg
      LV:Latvia
      LY:Libya
      MA:Maghribi
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:Saint Martin
      MG:Madagaskar
      MH:Kepulauan Marshall
      MK:Macedonia Utara
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Macau SAR China
      MP:Kepulauan Mariana Utara
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldives
      MW:Malawi
      MX:Mexico
      MY:Malaysia
      MZ:Mozambique
      NA:Namibia
      NC:New Caledonia
      NE:Niger
      NF:Pulau Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Belanda
      NO:Norway
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Polinesia Perancis
      PG:Papua New Guinea
      PH:Filipina
      PK:Pakistan
      PL:Poland
      PM:Saint Pierre dan Miquelon
      PN:Kepulauan Pitcairn
      PR:Puerto Rico
      PS:Wilayah Palestin
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Oceania Terpencil
      RE:Reunion
      RO:Romania
      RS:Serbia
      RU:Rusia
      RW:Rwanda
      SA:Arab Saudi
      SB:Kepulauan Solomon
      SC:Seychelles
      SD:Sudan
      SE:Sweden
      SG:Singapura
      SH:Saint Helena
      SI:Slovenia
      SJ:Svalbard dan Jan Mayen
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Sudan Selatan
      ST:Sao Tome dan Principe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Kepulauan Turks dan Caicos
      TD:Chad
      TF:Wilayah Selatan Perancis
      TG:Togo
      TH:Thailand
      TJ:Tajikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turkiye
      TT:Trinidad dan Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraine
      UG:Uganda
      UM:Kepulauan Terpencil A.S.
      UN:Bangsa-bangsa Bersatu
      US:Amerika Syarikat
      UY:Uruguay
      UZ:Uzbekistan
      VA:Kota Vatican
      VC:Saint Vincent dan Grenadines
      VE:Venezuela
      VG:Kepulauan Virgin British
      VI:Kepulauan Virgin A.S.
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis dan Futuna
      WS:Samoa
      XA:Aksen Pseudo
      XB:Bidi Pseudo
      XK:Kosovo
      YE:Yaman
      YT:Mayotte
      ZA:Afrika Selatan
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Wilayah Tidak Diketahui
      """.trimIndent() }

  val ms_BN: String? = null

  val ms_ID: String? = null

  val ms_SG: String? = null

  val mt: String by lazy { """
      001:Dinja
      002:Affrika
      005:Amerika t’Isfel
      009:Oċejanja
      011:Affrika tal-Punent
      013:Amerika Ċentrali
      014:Affrika tal-Lvant
      015:Affrika ta’ Fuq
      017:Affrika Nofsani
      018:Affrika t’Isfel
      019:Amerika
      029:Karibew
      030:Asja tal-Lvant
      034:Asja t’Isfel Ċentrali
      035:Asja tax-Xlokk
      039:Ewropa t’Isfel
      053:Awstralja u New Zealand
      054:Melanesja
      057:Reġjun ta’ Mikroneżja
      061:Polinesja
      142:Asja
      143:Asja Ċentrali
      145:Asja tal-Punent
      150:Ewropa
      151:Ewropa tal-Lvant
      154:Ewropa ta’ Fuq
      155:Ewropa tal-Punent
      419:Amerika Latina
      AC:Ascension Island
      AD:Andorra
      AE:l-Emirati Għarab Magħquda
      AF:l-Afganistan
      AG:Antigua u Barbuda
      AI:Anguilla
      AL:l-Albanija
      AM:l-Armenja
      AO:l-Angola
      AQ:l-Antartika
      AR:l-Arġentina
      AS:is-Samoa Amerikana
      AT:l-Awstrija
      AU:l-Awstralja
      AW:Aruba
      AX:il-Gżejjer Aland
      AZ:l-Ażerbajġan
      BA:il-Bożnija-Ħerzegovina
      BB:Barbados
      BD:il-Bangladesh
      BE:il-Belġju
      BF:il-Burkina Faso
      BG:il-Bulgarija
      BH:il-Bahrain
      BI:il-Burundi
      BJ:il-Benin
      BL:Saint Barthélemy
      BM:Bermuda
      BN:il-Brunei
      BO:il-Bolivja
      BQ:in-Netherlands tal-Karibew
      BR:Il-Brażil
      BS:il-Bahamas
      BT:il-Bhutan
      BV:Gżira Bouvet
      BW:il-Botswana
      BY:il-Belarussja
      BZ:il-Belize
      CA:il-Kanada
      CC:Gżejjer Cocos (Keeling)
      CD:ir-Repubblika Demokratika tal-Kongo
      CF:ir-Repubblika Ċentru-Afrikana
      CG:il-Kongo - Brazzaville
      CH:l-Iżvizzera
      CI:il-Kosta tal-Avorju
      CK:Gżejjer Cook
      CL:iċ-Ċili
      CM:il-Kamerun
      CN:iċ-Ċina
      CO:il-Kolombja
      CP:il-Gżira Clipperton
      CR:il-Costa Rica
      CU:Kuba
      CV:Cape Verde
      CW:Curaçao
      CX:il-Gżira Christmas
      CY:Ċipru
      CZ:ir-Repubblika Ċeka
      DE:il-Ġermanja
      DG:Diego Garcia
      DJ:il-Djibouti
      DK:id-Danimarka
      DM:Dominica
      DO:ir-Repubblika Dominicana
      DZ:l-Alġerija
      EA:Ceuta u Melilla
      EC:l-Ekwador
      EE:l-Estonja
      EG:l-Eġittu
      EH:is-Saħara tal-Punent
      ER:l-Eritrea
      ES:Spanja
      ET:l-Etjopja
      EU:Unjoni Ewropea
      FI:il-Finlandja
      FJ:Fiġi
      FK:il-Gżejjer Falkland
      FM:il-Mikroneżja
      FO:il-Gżejjer Faeroe
      FR:Franza
      GA:il-Gabon
      GB:ir-Renju Unit
      GD:Grenada
      GE:il-Georgia
      GF:il-Guyana Franċiża
      GG:Guernsey
      GH:il-Ghana
      GI:Ġibiltà
      GL:Greenland
      GM:il-Gambja
      GN:il-Guinea
      GP:Guadeloupe
      GQ:il-Guinea Ekwatorjali
      GR:il-Greċja
      GS:il-Georgia tan-Nofsinhar u l-Gżejjer Sandwich tan-Nofsinhar
      GT:il-Gwatemala
      GU:Guam
      GW:il-Guinea-Bissau
      GY:il-Guyana
      HK:ir-Reġjun Amministrattiv Speċjali ta’ Hong Kong tar-Repubblika tal-Poplu taċ-Ċina
      HM:il-Gżejjer Heard u l-Gżejjer McDonald
      HN:il-Honduras
      HR:il-Kroazja
      HT:il-Haiti
      HU:l-Ungerija
      IC:il-Gżejjer Canary
      ID:l-Indoneżja
      IE:l-Irlanda
      IL:Iżrael
      IM:Isle of Man
      IN:l-Indja
      IQ:l-Iraq
      IR:l-Iran
      IS:l-Iżlanda
      IT:l-Italja
      JE:Jersey
      JM:il-Ġamajka
      JO:il-Ġordan
      JP:il-Ġappun
      KE:il-Kenja
      KG:il-Kirgiżistan
      KH:il-Kambodja
      KI:Kiribati
      KM:Comoros
      KN:Saint Kitts u Nevis
      KP:il-Korea ta’ Fuq
      KR:il-Korea t’Isfel
      KW:il-Kuwajt
      KY:il-Gżejjer Cayman
      KZ:il-Każakistan
      LA:il-Laos
      LB:il-Libanu
      LC:Saint Lucia
      LI:il-Liechtenstein
      LK:is-Sri Lanka
      LR:il-Liberja
      LS:il-Lesoto
      LT:il-Litwanja
      LU:il-Lussemburgu
      LV:il-Latvja
      LY:il-Libja
      MA:il-Marokk
      MC:Monaco
      MD:il-Moldova
      ME:il-Montenegro
      MF:Saint Martin
      MG:Madagascar
      MH:Gżejjer Marshall
      MK:il-Maċedonja ta’ Fuq
      ML:il-Mali
      MM:il-Myanmar/Burma
      MN:il-Mongolja
      MO:ir-Reġjun Amministrattiv Speċjali tal-Macao tar-Repubblika tal-Poplu taċ-Ċina
      MP:Ġżejjer Mariana tat-Tramuntana
      MQ:Martinique
      MR:il-Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:il-Maldivi
      MW:il-Malawi
      MX:il-Messiku
      MY:il-Malasja
      MZ:il-Mozambique
      NA:in-Namibja
      NC:New Caledonia
      NE:in-Niġer
      NF:Gżira Norfolk
      NG:in-Niġerja
      NI:in-Nikaragwa
      NL:in-Netherlands
      NO:in-Norveġja
      NP:in-Nepal
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:l-Oman
      PA:il-Panama
      PE:il-Perù
      PF:Polineżja Franċiża
      PG:Papua New Guinea
      PH:il-Filippini
      PK:il-Pakistan
      PL:il-Polonja
      PM:Saint Pierre u Miquelon
      PN:Gżejjer Pitcairn
      PR:Puerto Rico
      PS:it-Territorji Palestinjani
      PT:il-Portugall
      PW:Palau
      PY:il-Paragwaj
      QA:il-Qatar
      RE:Réunion
      RO:ir-Rumanija
      RS:is-Serbja
      RU:ir-Russja
      RW:ir-Rwanda
      SA:l-Arabja Sawdija
      SB:il-Gżejjer Solomon
      SC:is-Seychelles
      SD:is-Sudan
      SE:l-Iżvezja
      SG:Singapore
      SH:Saint Helena
      SI:is-Slovenja
      SJ:Svalbard u Jan Mayen
      SK:is-Slovakkja
      SL:Sierra Leone
      SM:San Marino
      SN:is-Senegal
      SO:is-Somalja
      SR:is-Suriname
      SS:is-Sudan t’Isfel
      ST:São Tomé u Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:is-Sirja
      SZ:l-Eswatini
      TA:Tristan da Cunha
      TC:il-Gżejjer Turks u Caicos
      TD:iċ-Chad
      TF:It-Territorji Franċiżi tan-Nofsinhar
      TG:it-Togo
      TH:it-Tajlandja
      TJ:it-Taġikistan
      TK:it-Tokelau
      TL:Timor Leste
      TM:it-Turkmenistan
      TN:it-Tuneżija
      TO:Tonga
      TR:it-Turkija
      TT:Trinidad u Tobago
      TV:Tuvalu
      TW:it-Tajwan
      TZ:it-Tanzanija
      UA:l-Ukrajna
      UG:l-Uganda
      UM:Il-Gżejjer Minuri Mbiegħda tal-Istati Uniti
      US:l-Istati Uniti
      UY:l-Urugwaj
      UZ:l-Użbekistan
      VA:l-Istat tal-Belt tal-Vatikan
      VC:Saint Vincent u l-Grenadini
      VE:il-Venezwela
      VG:il-Gżejjer Verġni Brittaniċi
      VI:il-Gżejjer Verġni tal-Istati Uniti
      VN:il-Vjetnam
      VU:Vanuatu
      WF:Wallis u Futuna
      WS:Samoa
      XK:il-Kosovo
      YE:il-Jemen
      YT:Mayotte
      ZA:l-Afrika t’Isfel
      ZM:iż-Żambja
      ZW:iż-Żimbabwe
      ZZ:Reġjun Mhux Magħruf
      """.trimIndent() }

  val mua: String by lazy { """
      AD:andorra
      AE:Sǝr Arabiya ma taini
      AF:afghanistaŋ
      AG:antiguan ne Barbuda
      AI:anguiya
      AL:albaniya
      AM:armeniya
      AO:angola
      AR:argentiniya
      AS:samoa Amerika
      AT:austriya
      AU:australiya
      AW:aruba
      AZ:azerbaijaŋ
      BA:bosniya ne Herzegovina
      BB:barbadiya
      BD:bangladeshiya
      BE:belgika
      BF:burkina Faso
      BG:bulgariya
      BH:bahraiŋ
      BI:burundi
      BJ:beniŋ
      BM:bermudiya
      BN:bruniya
      BO:boliviya
      BR:brazilya
      BS:bahamas
      BT:butaŋ
      BW:botswana
      BY:belarussiya
      BZ:beliziya
      CA:kanada
      CD:Sǝr Kongo ma dii ne zair
      CF:centrafrika
      CG:kongo
      CH:Sǝr Swiss
      CI:ser Ivoiriya
      CK:kook ma laŋne
      CL:syili
      CM:kameruŋ
      CN:syiŋ
      CO:kolombiya
      CR:kosta Rika
      CU:Kuba
      CV:kap ma laŋne
      CY:Syipriya
      CZ:Sǝr Syek
      DE:Germaniya
      DJ:Djibouti
      DK:Daŋmark
      DM:Dominik
      DO:Sǝr Dominik ma lii
      DZ:algeriya
      EC:Ekwatǝr
      EE:Estoniya
      EG:Sǝr Egypt
      ER:Sǝr Eritre
      ES:Espaŋiya
      ET:Etiopia
      FI:Sǝr Finland
      FJ:Sǝr Fiji
      FK:Sǝr malouniya ma laŋne
      FM:Micronesiya
      FR:Franssǝ
      GA:Gaboŋ
      GB:Sǝr Anglofoŋ
      GD:Grenadǝ
      GE:Georgiya
      GF:Sǝr Guyana ma Franssǝ
      GH:Gana
      GI:Sǝr Gibraltar
      GL:Sǝr Groenland
      GM:Gambiya
      GN:Guine
      GP:Sǝr Gwadeloupǝ
      GQ:Sǝr Guine
      GR:Sǝr Grek
      GT:Gwatemala
      GU:Gwam
      GW:Guine ma Bissao
      GY:Guyana
      HN:Sǝr Honduras
      HR:kroatiya
      HT:Sǝr Haiti
      HU:Hungriya
      ID:Indonesiya
      IE:Sǝr Ireland
      IL:Sǝr Israel
      IN:Sǝr Indǝ
      IQ:Irak
      IR:Iraŋ
      IS:Sǝr Island
      IT:Italiya
      JM:Jamaika
      JO:Jordaniya
      JP:Japaŋ
      KE:Sǝr Kenya
      KG:Kirgizstaŋ
      KH:kambodiya
      KI:Sǝr Kiribati
      KM:komora
      KN:Sǝr Kristof ne Nievǝ
      KP:Sǝr Kore fah sǝŋ
      KR:Sǝr Kore nekǝsǝŋ
      KW:Sǝr Kowait
      KY:kayman ma laŋne
      KZ:Kazakstaŋ
      LA:Sǝr Laos
      LB:Libaŋ
      LC:Sǝr Lucia
      LI:Lichtǝnsteiŋ
      LK:Sǝr Lanka
      LR:Liberiya
      LS:Sǝr Lesotho
      LT:Lituaniya
      LU:Sǝr Luxemburg
      LV:Letoniya
      LY:Libiya
      MA:Marok
      MC:Monako
      MD:Moldoviya
      MG:Madagaskar
      MH:Sǝr Marshall ma laŋne
      ML:Sǝr Mali
      MM:Sǝr Myanmar
      MN:Mongoliya
      MP:Sǝr Maria ma laŋne
      MQ:Martinika
      MR:Mauritaniya
      MS:Sǝr Montserrat
      MT:Sǝr Malta
      MU:Sǝr Mauricǝ
      MV:Maldivǝ
      MW:Sǝr Malawi
      MX:Mexiko
      MY:Malaysiya
      MZ:Mozambika
      NA:Namibiya
      NC:Kaledoniya mafuu
      NE:Sǝr Niger
      NF:Norfolk ma laŋne
      NG:Nigeriya
      NI:Nikaragwa
      NL:Sǝr ma kasǝŋ
      NO:Norvegǝ
      NP:Sǝr Nepal
      NR:Sǝr Nauru
      NU:Niwe
      NZ:Zeland mafuu
      OM:Omaŋ
      PA:Sǝr Panama
      PE:Peru
      PF:Sǝr Polynesiya ma Franssǝ
      PG:Papuasiya Guine mafuu
      PH:Filipiŋ
      PK:Pakistaŋ
      PL:Pologŋ
      PM:Sǝr Pǝtar ne Mikǝlon
      PN:Pitkairn
      PR:Porto Riko
      PS:Sǝr Palestiniya
      PT:Sǝr Portugal
      PW:Sǝr Palau
      PY:Paragwai
      QA:Katar
      RE:Sǝr Reunion
      RO:Romaniya
      RU:Russiya
      RW:Rwanda
      SA:Sǝr Arabiya
      SB:Sǝr Salomon ma laŋne
      SC:Saichel
      SD:Sudaŋ
      SE:Sǝr Sued
      SG:Singapur
      SH:Sǝr Helena
      SI:Sloveniya
      SK:Slovakiya
      SL:Sierra Leonǝ
      SM:Sǝr Marino
      SN:Senegal
      SO:Somaliya
      SR:Sǝr Surinam
      ST:Sao Tome ne Principe
      SV:Sǝr Salvador
      SY:Syria
      SZ:Sǝr Swaziland
      TC:Turkiya ne kaicos ma laŋne
      TD:syad
      TG:Sǝr Togo
      TH:Tailand
      TJ:Tajikistaŋ
      TK:Sǝr Tokelau
      TL:Timoriya
      TM:Turkmenistaŋ
      TN:Tunisiya
      TO:Sǝr Tonga
      TR:Turkiya
      TT:Trinite ne Tobago
      TV:Sǝr Tuvalu
      TW:Taiwaŋ
      TZ:Tanzaniya
      UA:Ukraiŋ
      UG:Uganda
      US:Amerika
      UY:Urugwai
      UZ:Uzbekistaŋ
      VA:Vaticaŋ
      VC:Sǝr Vinceŋ ne Grenadiŋ
      VE:Sǝr Venezuela
      VG:ser Anglofon ma laŋne
      VI:Sǝr amerika ma laŋne
      VN:Sǝr Vietnam
      VU:Sǝr Vanuatu
      WF:Wallis ne Futuna
      WS:Sǝr Samoa
      YE:Yemeŋ
      YT:Mayot
      ZA:Afrika nekǝsǝŋ
      ZM:Zambiya
      ZW:Zimbabwe
      """.trimIndent() }

  val mus: String by lazy { """
      US:United States
      """.trimIndent() }

  val my: String by lazy { """
      001:ကမ္ဘာ
      002:အာဖရိက
      003:မြောက် အမေရိကတိုက်
      005:တောင် အမေရိက
      009:သမုဒ္ဒရာဒေသ
      011:အနောက် အာဖရိက
      013:ဗဟို အမေရိက
      014:အရှေ့ အာဖရိက
      015:မြောက် အာဖရိက
      017:အလယ် အာဖရိက
      018:အာဖရိက တောင်ပိုင်း
      019:အမေရိကန်
      021:မြောက် အမေရိက
      029:ကာရစ်ဘီယံ
      030:အရှေ့အာရှ
      034:တောင်အာရှ
      035:အရှေ့တောင်အာရှ
      039:တောင်ဥရောပ
      053:ဩစတြေးလျနှင့် နယူးဇီလန်
      054:မီလာနီးရှား
      057:မိုက်ခရိုနီးရှား ဒေသ
      061:ပိုလီနီရှား
      142:အာရှ
      143:အလယ်အာရှ
      145:အနောက်အာရှ
      150:ဥရောပ
      151:အရှေ့ ဥရောပ
      154:မြောက် ဥရောပ
      155:အနောက် ဥရောပ
      202:ဆာဟာရ-အောက်ပိုင်း အာဖရိက
      419:လက်တင်အမေရိက
      AC:အဆန်းရှင်းကျွန်း
      AD:အန်ဒိုရာ
      AE:ယူအေအီး
      AF:အာဖဂန်နစ္စတန်
      AG:အန်တီဂွါနှင့် ဘာဘူဒါ
      AI:အန်ဂီလာ
      AL:အယ်လ်ဘေးနီးယား
      AM:အာမေးနီးယား
      AO:အန်ဂိုလာ
      AQ:အန်တာတိက
      AR:အာဂျင်တီးနား
      AS:အမေရိကန် ဆမိုးအား
      AT:ဩစတြီးယား
      AU:ဩစတြေးလျ
      AW:အာရူးဗား
      AX:အာလန်ကျွန်း
      AZ:အဇာဘိုင်ဂျန်
      BA:ဘော့စနီးယားနှင့် ဟာဇီဂိုဗီနား
      BB:ဘာဘေးဒိုးစ်
      BD:ဘင်္ဂလားဒေ့ရှ်
      BE:ဘယ်လ်ဂျီယမ်
      BF:ဘာကီးနား ဖားဆို
      BG:ဘူလ်ဂေးရီးယား
      BH:ဘာရိန်း
      BI:ဘူရွန်ဒီ
      BJ:ဘီနင်
      BL:စိန့်ဘာသယ်လ်မီ
      BM:ဘာမြူဒါ
      BN:ဘရူနိုင်း
      BO:ဘိုလီးဗီးယား
      BQ:ကာရစ်ဘီယံ နယ်သာလန်
      BR:ဘရာဇီး
      BS:ဘဟားမား
      BT:ဘူတန်
      BV:ဘူဗက်ကျွန်း
      BW:ဘော့ဆွာနာ
      BY:ဘီလာရုစ်
      BZ:ဘလိဇ်
      CA:ကနေဒါ
      CC:ကိုကိုးကျွန်း
      CD:ကွန်ဂို
      CF:ဗဟို အာဖရိက ပြည်ထောင်စု
      CG:ကွန်ဂို-ဘရာဇာဗီးလ်
      CH:ဆွစ်ဇာလန်
      CI:ကို့တ် ဒီဗွာ
      CK:ကွတ် ကျွန်းစု
      CL:ချီလီ
      CM:ကင်မရွန်း
      CN:တရုတ်
      CO:ကိုလံဘီယာ
      CP:ကလစ်ပါတန်ကျွန်း
      CR:ကို့စ်တာရီကာ
      CU:ကျူးဘား
      CV:ကိတ်ဗာဒီ
      CW:ကျူရေးကိုးစ်
      CX:ခရစ်စမတ် ကျွန်း
      CY:ဆိုက်ပရပ်စ်
      CZ:ချက်ကီယား
      DE:ဂျာမနီ
      DG:ဒီအဲဂိုဂါစီရာ
      DJ:ဂျီဘူတီ
      DK:ဒိန်းမတ်
      DM:ဒိုမီနီကာ
      DO:ဒိုမီနီကန်
      DZ:အယ်လ်ဂျီးရီးယား
      EA:ဆယ်ဥတာနှင့်မယ်လီလ်လာ
      EC:အီကွေဒေါ
      EE:အက်စတိုးနီးယား
      EG:အီဂျစ်
      EH:အနောက် ဆာဟာရ
      ER:အီရီထရီးယား
      ES:စပိန်
      ET:အီသီယိုးပီးယား
      EU:ဥရောပသမဂ္ဂ
      EZ:ဥရောပဒေသ
      FI:ဖင်လန်
      FJ:ဖီဂျီ
      FK:ဖော့ကလန် ကျွန်းစု
      FM:မိုင်ခရိုနီရှား
      FO:ဖာရိုး ကျွန်းစုများ
      FR:ပြင်သစ်
      GA:ဂါဘွန်
      GB:ယူနိုက်တက်ကင်းဒမ်း
      GD:ဂရီနေဒါ
      GE:ဂျော်ဂျီယာ
      GF:ပြင်သစ် ဂီယာနာ
      GG:ဂွန်းဇီ
      GH:ဂါနာ
      GI:ဂျီဘရော်လ်တာ
      GL:ဂရင်းလန်း
      GM:ဂမ်ဘီရာ
      GN:ဂီနီ
      GP:ဂွါဒီလု
      GQ:အီကွေတာ ဂီနီ
      GR:ဂရိ
      GS:တောင် ဂျော်ဂျီယာ နှင့် တောင် ဆင်းဒဝစ်ဂျ် ကျွန်းစုများ
      GT:ဂွါတီမာလာ
      GU:ဂူအမ်
      GW:ဂီနီ-ဘီစော
      GY:ဂိုင်ယာနာ
      HK:ဟောင်ကောင် (တရုတ်ပြည်)
      HM:ဟတ်ကျွန်းနှင့်မက်ဒေါနယ်ကျွန်းစု
      HN:ဟွန်ဒူးရပ်စ်
      HR:ခရိုအေးရှား
      HT:ဟေတီ
      HU:ဟန်ဂေရီ
      IC:ကနေရီ ကျွန်းစု
      ID:အင်ဒိုနီးရှား
      IE:အိုင်ယာလန်
      IL:အစ္စရေး
      IM:မန်ကျွန်း
      IN:အိန္ဒိယ
      IO:ဗြိတိသျှပိုင် အိန္ဒိယသမုဒ္ဒရာကျွန်းများ
      IQ:အီရတ်
      IR:အီရန်
      IS:အိုက်စလန်
      IT:အီတလီ
      JE:ဂျာစီ
      JM:ဂျမေကာ
      JO:ဂျော်ဒန်
      JP:ဂျပန်
      KE:ကင်ညာ
      KG:ကာဂျစ္စတန်
      KH:ကမ္ဘောဒီးယား
      KI:ခီရီဘာတီ
      KM:ကိုမိုရိုစ်
      KN:စိန့်ကစ်နှင့်နီဗီစ်
      KP:မြောက်ကိုရီးယား
      KR:တောင်ကိုရီးယား
      KW:ကူဝိတ်
      KY:ကေမန် ကျွန်းစု
      KZ:ကာဇက်စတန်
      LA:လာအို
      LB:လက်ဘနွန်
      LC:စိန့်လူစီယာ
      LI:လစ်တန်စတိန်း
      LK:သီရိလင်္ကာ
      LR:လိုက်ဘေးရီးယား
      LS:လီဆိုသို
      LT:လစ်သူဝေးနီးယား
      LU:လူဇင်ဘတ်
      LV:လတ်ဗီးယား
      LY:လစ်ဗျား
      MA:မော်ရိုကို
      MC:မိုနာကို
      MD:မောလ်ဒိုဗာ
      ME:မွန်တီနိဂရိုး
      MF:စိန့်မာတင်
      MG:မဒါဂတ်စကား
      MH:မာရှယ် ကျွန်းစု
      MK:မြောက် မက်ဆီဒိုးနီးယား
      ML:မာလီ
      MM:မြန်မာ
      MN:မွန်ဂိုးလီးယား
      MO:မကာအို (တရုတ်ပြည်)
      MP:မြောက်ပိုင်းမာရီအာနာကျွန်းစု
      MQ:မာတီနိခ်
      MR:မော်ရီတေးနီးယား
      MS:မောင့်စဲရက်
      MT:မောလ်တာ
      MU:မောရစ်ရှ
      MV:မော်လ်ဒိုက်
      MW:မာလာဝီ
      MX:မက်ကဆီကို
      MY:မလေးရှား
      MZ:မိုဇမ်ဘစ်
      NA:နမီးဘီးယား
      NC:နယူး ကယ်လီဒိုနီးယား
      NE:နိုင်ဂျာ
      NF:နောဖုတ်ကျွန်း
      NG:နိုင်ဂျီးရီးယား
      NI:နီကာရာဂွါ
      NL:နယ်သာလန်
      NO:နော်ဝေ
      NP:နီပေါ
      NR:နော်ရူး
      NU:နီဥူအေ
      NZ:နယူးဇီလန်
      OM:အိုမန်
      PA:ပနားမား
      PE:ပီရူး
      PF:ပြင်သစ် ပေါ်လီနီးရှား
      PG:ပါပူအာ နယူးဂီနီ
      PH:ဖိလစ်ပိုင်
      PK:ပါကစ္စတန်
      PL:ပိုလန်
      PM:စိန့်ပီအဲရ်နှင့် မီကွီလွန်
      PN:ပစ်တ်ကိန်းကျွန်းစု
      PR:ပေါ်တိုရီကို
      PS:ပါလက်စတိုင်း ပိုင်နက်
      PT:ပေါ်တူဂီ
      PW:ပလာအို
      PY:ပါရာဂွေး
      QA:ကာတာ
      QO:သမုဒ္ဒရာ အပြင်ဘက်ရှိ ကျွန်းနိုင်ငံများ
      RE:ရီယူနီယန်
      RO:ရိုမေးနီးယား
      RS:ဆားဘီးယား
      RU:ရုရှား
      RW:ရဝန်ဒါ
      SA:ဆော်ဒီအာရေးဘီးယား
      SB:ဆော်လမွန်ကျွန်းစု
      SC:ဆေးရှဲ
      SD:ဆူဒန်
      SE:ဆွီဒင်
      SG:စင်္ကာပူ
      SH:စိန့်ဟယ်လယ်နာ
      SI:ဆလိုဗေးနီးယား
      SJ:စဗိုလ်ဘတ်နှင့်ဂျန်မေရန်
      SK:ဆလိုဗက်ကီးယား
      SL:ဆီယာရာ လီယွန်း
      SM:ဆန်မာရီနို
      SN:ဆီနီဂေါ
      SO:ဆိုမာလီယာ
      SR:ဆူရာနမ်
      SS:တောင် ဆူဒန်
      ST:ဆောင်တူမေးနှင့် ပရင်စီပီ
      SV:အယ်လ်ဆာဗေးဒိုး
      SX:စင့်မာတင်
      SY:ဆီးရီးယား
      SZ:ဆွာဇီလန်
      TA:ထရစ္စတန် ဒါ ကွန်ဟာ
      TC:တခ်စ်နှင့်ကာအီကိုစ်ကျွန်းစု
      TD:ချဒ်
      TF:ပြင်သစ် တောင်ပိုင်း ပိုင်နက်များ
      TG:တိုဂို
      TH:ထိုင်း
      TJ:တာဂျီကစ္စတန်
      TK:တိုကလောင်
      TL:အရှေ့တီမော
      TM:တာ့ခ်မင်နစ္စတန်
      TN:တူနီးရှား
      TO:တွန်ဂါ
      TR:တူရကီ
      TT:ထရီနီဒတ်နှင့် တိုဘက်ဂို
      TV:တူဗားလူ
      TW:ထိုင်ဝမ်
      TZ:တန်ဇန်းနီးယား
      UA:ယူကရိန်း
      UG:ယူဂန်းဒါး
      UM:ယူနိုက်တက်စတိတ် ကျွန်းနိုင်ငံများ
      UN:ကုလသမဂ္ဂ
      US:အမေရိကန် ပြည်ထောင်စု
      UY:ဥရုဂွေး
      UZ:ဥဇဘက်ကစ္စတန်
      VA:ဗာတီကန်စီးတီး
      VC:စိန့်ဗင်းဆင့်နှင့် ဂရိနေဒိုင်
      VE:ဗင်နီဇွဲလား
      VG:ဗြိတိသျှ ဗာဂျင်း ကျွန်းစု
      VI:ယူအက်စ် ဗာဂျင်း ကျွန်းစု
      VN:ဗီယက်နမ်
      VU:ဗနွားတူ
      WF:ဝေါလစ်နှင့် ဖူကျူးနား
      WS:ဆမိုးအား
      XA:နိုင်ငံခြားသံ
      XB:စာပြောင်းပြန်
      XK:ကိုဆိုဗို
      YE:ယီမင်
      YT:မေယော့
      ZA:တောင်အာဖရိက
      ZM:ဇမ်ဘီယာ
      ZW:ဇင်ဘာဘွေ
      ZZ:မသိ (သို့) မရှိသော ဒေသ
      """.trimIndent() }

  val mzn: String by lazy { """
      001:جهون
      002:آفریقا
      003:شمالی آمریکا
      005:جنوبی آمریکا
      009:اوقیانوسیه
      011:غربی آفریقا
      013:میونی آمریکا
      014:شرقی آفریقا
      015:شمالی ۀفریقا
      017:میونی آفریقا
      018:جنوبی آفریقا
      019:آمریکا
      021:شمالی امریکا
      029:کاراییب
      030:شرقی آسیا
      034:جنوبی آسیا
      035:آسیای ِجنوب‌شرقی‌وَر
      039:جنوبی اروپا
      053:اوسترالزی
      054:ملانزی
      057:میکرونزی منقطه
      061:پولی‌نزی
      142:آسیا
      143:میونی آسیا
      145:غربی آسیا
      150:اروپا
      151:شرقی اروپا
      154:شمالی اروپا
      155:غربی اروپا
      419:لاتین آمریکا
      AC:آسنسیون جزیره
      AD:آندورا
      AE:متحده عربی امارات
      AF:افغانستون
      AG:آنتیگوا و باربودا
      AI:آنگویلا
      AL:آلبانی
      AM:ارمنستون
      AO:آنگولا
      AQ:جنوبی یخ‌بزه قطب
      AR:آرژانتین
      AS:آمریکای ِساموآ
      AT:اتریش
      AU:استرالیا
      AW:آروبا
      AX:آلند جزیره
      AZ:آذربایجون
      BA:بوسنی و هرزگوین
      BB:باربادوس
      BD:بنگلادش
      BE:بلژیک
      BF:بورکینا فاسو
      BG:بلغارستون
      BH:بحرین
      BI:بوروندی
      BJ:بنین
      BL:سنت بارتلمی
      BM:برمودا
      BN:برونئی
      BO:بولیوی
      BQ:هلند ِکاراییبی جزایر
      BR:برزیل
      BS:باهاما
      BT:بوتان
      BV:بووت جزیره
      BW:بوتساوانا
      BY:بلاروس
      BZ:بلیز
      CA:کانادا
      CC:کوک (کیلینگ) جزایر
      CD:کنگو کینشاسا
      CF:مرکزی آفریقای جمهوری
      CG:کنگو برازاویل
      CH:سوییس
      CI:عاج ِساحل
      CK:کوک جزایر
      CL:شیلی
      CM:کامرون
      CN:چین
      CO:کلمبیا
      CP:کلیپرتون جزیره
      CR:کاستاریکا
      CU:کوبا
      CV:کیپ ورد
      CW:کوراسائو
      CX:کریسمس جزیره
      CY:قبرس
      CZ:چک جمهوری
      DE:آلمان
      DG:دیگو گارسیا
      DJ:جیبوتی
      DK:دانمارک
      DM:دومنیکا
      DO:دومنیکن جمهوری
      DZ:الجزیره
      EA:سوتا و ملیله
      EC:اکوادر
      EE:استونی
      EG:مصر
      EH:غربی صحرا
      ER:اریتره
      ES:ایسپانیا
      ET:اتیوپی
      EU:اروپا اتحادیه
      FI:فنلاند
      FJ:فیجی
      FK:فالکلند جزیره‌ئون
      FM:میکرونزی
      FO:فارو جزایر
      FR:فرانسه
      GA:گابون
      GB:بریتانیا
      GD:گرانادا
      GE:گرجستون
      GF:فرانسه‌ی ِگویان
      GG:گرنزی
      GH:غنا
      GI:جبل طارق
      GL:گرینلند
      GM:گامبیا
      GN:گینه
      GP:گوادلوپ
      GQ:استوایی گینه
      GR:یونان
      GS:جنوبی جورجیا و جنوبی ساندویچ جزایر
      GT:گواتمالا
      GU:گوئام
      GW:گینه بیسائو
      GY:گویان
      HK:هنگ کنگ
      HM:هارد و مک‌دونالد جزایر
      HN:هندوراس
      HR:کرواسی
      HT:هاییتی
      HU:مجارستون
      IC:قناری جزایر
      ID:اندونزی
      IE:ایرلند
      IL:ایسراییل
      IM:من ِجزیره
      IN:هند
      IQ:عراق
      IR:ایران
      IS:ایسلند
      IT:ایتالیا
      JE:جرسی
      JM:جاماییکا
      JO:اردن
      JP:جاپون
      KE:کنیا
      KG:قرقیزستون
      KH:کامبوج
      KI:کیریباتی
      KM:کومور
      KN:سنت کیتس و نویس
      KP:شمالی کُره
      KR:جنوبی کُره
      KW:کویت
      KY:کیمن جزیره‌ئون
      KZ:قزاقستون
      LA:لائوس
      LB:لبنان
      LC:سنت لوسیا
      LI:لیختن اشتاین
      LK:سریلانکا
      LR:لیبریا
      LS:لسوتو
      LT:لتونی
      LU:لوکزامبورگ
      LV:لاتویا
      LY:لیبی
      MA:مراکش
      MC:موناکو
      MD:مولداوی
      ME:مونته‌نگرو
      MF:سنت مارتین
      MG:ماداگاسکار
      MH:مارشال جزایر
      ML:مالی
      MM:میانمار
      MN:مغولستون
      MO:ماکائو (چین دله)
      MP:شمالی ماریانا جزایر
      MQ:مارتینیک جزیره‌ئون
      MR:موریتانی
      MS:مونتسرات
      MT:مالت
      MU:مورى تيوس
      MV:مالدیو
      MW:مالاوی
      MX:مکزیک
      MY:مالزی
      MZ:موزامبیک
      NA:نامبیا
      NC:نیو کالیدونیا
      NE:نیجر
      NF:نورفولک جزیره
      NG:نیجریه
      NI:نیکاراگوئه
      NL:هلند
      NO:نروژ
      NP:نپال
      NR:نائورو
      NU:نیئو
      NZ:نیوزلند
      OM:عمان
      PA:پاناما
      PE:پرو
      PF:فرانسه‌ی پولی‌نزی
      PG:پاپوا نو گینه
      PH:فیلیپین
      PK:پاکستون
      PL:لهستون
      PM:سن پییر و میکلن
      PN:پیتکارین جزایر
      PR:پورتوریکو
      PS:فلسطین ِسرزمین
      PT:پرتغال
      PW:پالائو
      PY:پاراگوئه
      QA:قطر
      QO:اوقیانوسیه‌ی ِپرت ِجائون
      RE:رئونیون
      RO:رومانی
      RS:صربستون
      RU:روسیه
      RW:روآندا
      SA:عربستون
      SB:سلیمون جزیره
      SC:سیشل
      SD:سودان
      SE:سوئد
      SG:سنگاپور
      SH:سنت هلنا
      SI:اسلوونی
      SJ:سوالبارد و يان ماين
      SK:اسلواکی
      SL:سیرالئون
      SM:سن مارینو
      SN:سنگال
      SO:سومالی
      SR:سورینام
      SS:جنوبی سودان
      ST:سائوتومه و پرینسیپ
      SV:السالوادور
      SX:سنت مارتن
      SY:سوریه
      SZ:سوازیلند
      TA:تریستان دا جونها
      TC:تورکس و کایکوس جزایر
      TD:چاد
      TF:فرانسه‌ی جنوبی مناطق
      TG:توگو
      TH:تایلند
      TJ:تاجیکستون
      TK:توکلائو
      TL:تیمور شرقی
      TM:ترکمونستون
      TN:تونس
      TO:تونگا
      TR:ترکیه
      TT:ترینیداد و توباگو
      TV:تووالو
      TW:تایوان
      TZ:تانزانیا
      UA:اوکراین
      UG:اوگاندا
      UM:آمریکای پَرتِ‌پِلا جزیره‌ئون
      US:متحده ایالات
      UY:اروگوئه
      UZ:ازبکستون
      VA:واتیکان
      VC:سنت وینسنت و گرنادین
      VE:ونزوئلا
      VG:بریتانیای ویرجین
      VI:آمریکای ویرجین
      VN:ویتنام
      VU:وانواتو
      WF:والیس و فوتونا
      WS:ساموآ
      XK:کوزوو
      YE:یمن
      YT:مایوت
      ZA:جنوبی افریقا
      ZM:زامبیا
      ZW:زیمبابوه
      ZZ:نامَیِّن منطقه
      """.trimIndent() }

  val naq: String by lazy { """
      AD:Andorrab
      AE:United Arab Emirates
      AF:Afghanistanni
      AG:Antiguab tsî Barbudab
      AI:Anguillab
      AL:Albaniab
      AM:Armeniab
      AO:Angolab
      AR:Argentinab
      AS:Americab Samoab
      AT:Austriab
      AU:Australieb
      AW:Arubab
      AZ:Azerbaijanni
      BA:Bosniab tsî Herzegovinab
      BB:Barbados
      BD:Banglades
      BE:Belgiummi
      BF:Burkina Fasob
      BG:Bulgariab
      BH:Bahrain
      BI:Burundib
      BJ:Benins
      BM:Bermudas
      BN:Brunei
      BO:Boliviab
      BR:Braziliab
      BS:Bahamas
      BT:Bhutans
      BW:Botswanab
      BY:Belarus
      BZ:Belize
      CA:Kanadab
      CD:Democratic Reof the Congo
      CF:Central African Republiki
      CG:Congob
      CH:Switzerlandi
      CI:Ivoorkusi
      CK:Cook Islands
      CL:Chilib
      CM:Cameroonni
      CN:Chinab
      CO:Colombiab
      CR:Costa Rica
      CU:Cubab
      CV:Cape Verde Islands
      CY:Cyprus
      CZ:Czech Republiki
      DE:Duitslandi
      DJ:Djibouti
      DK:Denmarki
      DM:Dominicab
      DO:Dominican Republic
      DZ:Algeriab
      EC:Ecuadori
      EE:Estoniab
      EG:Egipteb
      ER:Eritreab
      ES:Spanieb
      ET:Ethiopiab
      FI:Finlandi
      FJ:Fijib
      FK:Falkland Islands
      FM:Micronesia
      FR:Frankreiki
      GA:Gaboni
      GB:United Kingdom
      GD:Grenada
      GE:Georgiab
      GF:French Guiana
      GH:Ghanab
      GI:Gibraltar
      GL:Greenland
      GM:Gambiab
      GN:Guineab
      GP:Guadeloupe
      GQ:Equatorial Guineab
      GR:Xrikelandi
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HN:Honduras
      HR:Croatiab
      HT:Haiti
      HU:Hongareieb
      ID:Indonesiab
      IE:Irlandi
      IL:Israeli
      IN:Indiab
      IQ:Iraqi
      IR:Iranni
      IS:Iceland
      IT:Italiab
      JM:Jamaicab
      JO:Jordanni
      JP:Japanni
      KE:Kenyab
      KG:Kyrgyzstanni
      KH:Cambodiab
      KI:Kiribati
      KM:Comoros
      KN:Saint Kitts and Nevis
      KP:Koreab, Noord
      KR:Koreab, Suid
      KW:Kuwaiti
      KY:Cayman Islands
      KZ:Kazakhstanni
      LA:Laos
      LB:Lebanonni
      LC:Saint Lucia
      LI:Liechtensteinni
      LK:Sri Lankab
      LR:Liberiab
      LS:Lesothob
      LT:Lithuaniab
      LU:Luxembourgi
      LV:Latvia
      LY:Libyab
      MA:Morocco
      MC:Monaco
      MD:Moldova
      MG:Madagascari
      MH:Marshall Islands
      ML:Malib
      MM:Myanmar
      MN:Mongolia
      MP:Northern Mariana Islands
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldives
      MW:Malawib
      MX:Mexicob
      MY:Malaysiab
      MZ:Mozambiki
      NA:Namibiab
      NC:New Caledonia
      NE:Nigeri
      NF:Norfolk Island
      NG:Nigerieb
      NI:Nicaraguab
      NL:Netherlands
      NO:Noorweeb
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:New Zealandi
      OM:Oman
      PA:Panama
      PE:Perub
      PF:French Polynesia
      PG:Papua New Guineab
      PH:Philippinni
      PK:Pakistanni
      PL:Polandi
      PM:Saint Pierre and Miquelon
      PN:Pitcairn
      PR:Puerto Rico
      PS:Palestinian West Bank and Gaza
      PT:Portugali
      PW:Palau
      PY:Paraguaib
      QA:Qatar
      RE:Réunion
      RO:Romania
      RU:Rasiab
      RW:Rwandab
      SA:Saudi Arabiab
      SB:Solomon Islands
      SC:Seychelles
      SD:Sudanni
      SE:Swedeb
      SG:Singapore
      SH:Saint Helena
      SI:Slovenia
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegali
      SO:Somaliab
      SR:Suriname
      ST:São Tomé and Príncipe
      SV:El Salvadori
      SY:Syriab
      SZ:Swazilandi
      TC:Turks and Caicos Islands
      TD:Chadi
      TG:Togob
      TH:Thailandi
      TJ:Tajikistan
      TK:Tokelau
      TL:East Timor
      TM:Turkmenistan
      TN:Tunisiab
      TO:Tonga
      TR:Turkeieb
      TT:Trinidad and Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzaniab
      UA:Ukraine
      UG:Ugandab
      US:Amerikab
      UY:Uruguaib
      UZ:Uzbekistan
      VA:Vatican State
      VC:Saint Vincent and the Grenadines
      VE:Venezuelab
      VG:British Virgin Islands
      VI:U.S. Virgin Islands
      VN:Vietnammi
      VU:Vanuatu
      WF:Wallis and Futuna
      WS:Samoa
      YE:Yemen
      YT:Mayotte
      ZA:Suid Afrikab
      ZM:Zambiab
      ZW:Zimbabweb
      """.trimIndent() }

  val nb: String? = null

  val nb_SJ: String? = null

  val nd: String by lazy { """
      AD:Andora
      AE:United Arab Emirates
      AF:Afghanistan
      AG:Antigua le Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ye Amelika
      AT:Austria
      AU:Australia
      AW:Arubha
      AZ:Azerbaijan
      BA:Bhosnia le Herzegovina
      BB:Bhabhadosi
      BD:Bhangiladeshi
      BE:Bhelgium
      BF:Bhukina Faso
      BG:Bhulgariya
      BH:Bhahareni
      BI:Bhurundi
      BJ:Bhenini
      BM:Bhemuda
      BN:Brunei
      BO:Bholiviya
      BR:Brazili
      BS:Bhahamas
      BT:Bhutani
      BW:Botswana
      BY:Bhelarusi
      BZ:Bhelize
      CA:Khanada
      CD:Democratic Reof the Congo
      CF:Central African Republic
      CG:Khongo
      CH:Switzerland
      CI:Ivory Coast
      CK:Cook Islands
      CL:Chile
      CM:Khameruni
      CN:China
      CO:Kholombiya
      CR:Khosta Rikha
      CU:Cuba
      CV:Cape Verde Islands
      CY:Cyprus
      CZ:Czech Republic
      DE:Germany
      DJ:Djibouti
      DK:Denmakhi
      DM:Dominikha
      DO:Dominican Republic
      DZ:Aljeriya
      EC:Ecuador
      EE:Estonia
      EG:Egypt
      ER:Eritrea
      ES:Spain
      ET:Ethiopia
      FI:Finland
      FJ:Fiji
      FK:Falkland Islands
      FM:Micronesia
      FR:Furansi
      GA:Gabhoni
      GB:United Kingdom
      GD:Grenada
      GE:Georgia
      GF:Gwiyana ye Furansi
      GH:Ghana
      GI:Gibraltar
      GL:Greenland
      GM:Gambiya
      GN:Guinea
      GP:Guadeloupe
      GQ:Equatorial Guinea
      GR:Greece
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HN:Honduras
      HR:Croatia
      HT:Hayiti
      HU:Hungary
      ID:Indonesiya
      IE:Ireland
      IL:Isuraeli
      IN:Indiya
      IQ:Iraki
      IR:Iran
      IS:Iceland
      IT:Itali
      JM:Jamaica
      JO:Jodani
      JP:Japan
      KE:Khenya
      KG:Kyrgyzstan
      KH:Cambodia
      KI:Khiribati
      KM:Khomoro
      KN:Saint Kitts and Nevis
      KP:North Korea
      KR:South Korea
      KW:Khuweiti
      KY:Cayman Islands
      KZ:Kazakhstan
      LA:Laos
      LB:Lebhanoni
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Libheriya
      LS:Lesotho
      LT:Lithuania
      LU:Luxembourg
      LV:Latvia
      LY:Libhiya
      MA:Morokho
      MC:Monakho
      MD:Moldova
      MG:Madagaska
      MH:Marshall Islands
      ML:Mali
      MM:Myanmar
      MN:Mongolia
      MP:Northern Mariana Islands
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldives
      MW:Malawi
      MX:Meksikho
      MY:Malezhiya
      MZ:Mozambique
      NA:Namibhiya
      NC:New Caledonia
      NE:Niger
      NF:Norfolk Island
      NG:Nigeriya
      NI:Nicaragua
      NL:Netherlands
      NO:Noweyi
      NP:Nephali
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:Omani
      PA:Panama
      PE:Pheru
      PF:Pholinesiya ye Fulansi
      PG:Papua New Guinea
      PH:Philippines
      PK:Phakistani
      PL:Pholandi
      PM:Saint Pierre and Miquelon
      PN:Pitcairn
      PR:Puerto Rico
      PS:Palestinian West Bank and Gaza
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Kathari
      RE:Réunion
      RO:Romania
      RU:Rashiya
      RW:Ruwanda
      SA:Saudi Arabia
      SB:Solomon Islands
      SC:Seychelles
      SD:Sudani
      SE:Sweden
      SG:Singapore
      SH:Saint Helena
      SI:Slovenia
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegali
      SO:Somaliya
      SR:Suriname
      ST:São Tomé and Príncipe
      SV:El Salvador
      SY:Syria
      SZ:Swaziland
      TC:Turks and Caicos Islands
      TD:Chadi
      TG:Thogo
      TH:Thayilandi
      TJ:Tajikistan
      TK:Thokelawu
      TL:East Timor
      TM:Turkmenistan
      TN:Tunisiya
      TO:Thonga
      TR:Thekhi
      TT:Trinidad le Tobago
      TV:Thuvalu
      TW:Thayiwani
      TZ:Tanzaniya
      UA:Yukreini
      UG:Uganda
      US:Amelika
      UY:Yurugwai
      UZ:Uzbekistan
      VA:Vatican State
      VC:Saint Vincent and the Grenadines
      VE:Venezuela
      VG:British Virgin Islands
      VI:U.S. Virgin Islands
      VN:Vietnam
      VU:Vhanuatu
      WF:Wallis and Futuna
      WS:Samowa
      YE:Yemeni
      YT:Mayotte
      ZA:Mzansi ye Afrika
      ZM:Zambiya
      ZW:Zimbabwe
      """.trimIndent() }

  val nds: String by lazy { """
      DE:Düütschland
      NL:Nedderlannen
      """.trimIndent() }

  val nds_NL: String? = null

  val ne: String by lazy { """
      001:विश्व
      002:अफ्रिका
      003:उत्तर अमेरिका
      005:दक्षिण अमेरिका
      009:ओसनिया
      011:पश्चिमी अफ्रिका
      013:केन्द्रीय अमेरिका
      014:पूर्वी अफ्रिका
      015:उत्तरी अफ्रिका
      017:मध्य अफ्रिका
      018:दक्षिणी अफ्रिका
      019:अमेरिकास
      021:उत्तरी अमेरिका
      029:क्यारिबियन
      030:पूर्वी एशिया
      034:दक्षिणी एशिया
      035:दक्षिण पूर्वी एशिया
      039:दक्षिणी युरोप
      053:अष्ट्रालासिया
      054:मेलानेसिया
      057:माइक्रोनेसियाली क्षेत्र
      061:पोलिनेशिया
      142:एशिया
      143:केन्द्रीय एशिया
      145:पश्चिमी एशिया
      150:युरोप
      151:पूर्वी युरोप
      154:उत्तरी युरोप
      155:पश्चिमी युरोप
      202:उप-साहारा अफ्रिका
      419:ल्याटिन अमेरिका
      AC:असेन्सन टापु
      AD:अन्डोर्रा
      AE:संयुक्त अरब इमिराट्स
      AF:अफगानिस्तान
      AG:एन्टिगुआ र बारबुडा
      AI:आङ्गुइला
      AL:अल्बेनिया
      AM:आर्मेनिया
      AO:अङ्गोला
      AQ:अन्टारटिका
      AR:अर्जेन्टिना
      AS:अमेरिकी समोआ
      AT:अष्ट्रिया
      AU:अस्ट्रेलिया
      AW:अरुबा
      AX:अलान्ड टापुहरु
      AZ:अजरबैजान
      BA:बोस्निया एण्ड हर्जगोभिनिया
      BB:बार्बाडोस
      BD:बङ्गलादेश
      BE:बेल्जियम
      BF:बुर्किना फासो
      BG:बुल्गेरिया
      BH:बहराइन
      BI:बुरूण्डी
      BJ:बेनिन
      BL:सेन्ट बार्थेलेमी
      BM:बर्मुडा
      BN:ब्रुनाइ
      BO:बोलिभिया
      BQ:क्यारिवियन नेदरल्याण्ड्स
      BR:ब्राजिल
      BS:बहामास
      BT:भुटान
      BV:बुभेट टापु
      BW:बोट्स्वाना
      BY:बेलारूस
      BZ:बेलिज
      CA:क्यानाडा
      CC:कोकोस (किलिंग) टापुहरु
      CD:कङ्गो - किन्शासा
      CF:मध्य अफ्रिकी गणतन्त्र
      CG:कङ्गो ब्राजाभिल
      CH:स्विजरल्याण्ड
      CI:कोट दिभोर
      CK:कुक टापुहरु
      CL:चिली
      CM:क्यामरून
      CN:चीन
      CO:कोलोम्बिया
      CP:क्लिप्पेर्टन टापु
      CR:कोष्टारिका
      CU:क्युबा
      CV:केप भर्डे
      CW:कुराकाओ
      CX:क्रिष्टमस टापु
      CY:साइप्रस
      CZ:चेकिया
      DE:जर्मनी
      DG:डियगो गार्सिया
      DJ:डिजिबुटी
      DK:डेनमार्क
      DM:डोमिनिका
      DO:डोमिनिकन गणतन्त्र
      DZ:अल्जेरिया
      EA:सिउटा र मेलिला
      EC:इक्वेडोर
      EE:इस्टोनिया
      EG:इजिप्ट
      EH:पश्चिमी साहारा
      ER:एरिट्रीया
      ES:स्पेन
      ET:इथियोपिया
      EU:युरोपियन युनियन
      EZ:युरोजोन
      FI:फिनल्याण्ड
      FJ:फिजी
      FK:फकल्याण्ड टापुहरु
      FM:माइक्रोनेसिया
      FO:फारो टापुहरू
      FR:फ्रान्स
      GA:गावोन
      GB:संयुक्त अधिराज्य
      GD:ग्रेनाडा
      GE:जर्जिया
      GF:फ्रान्सेली गायना
      GG:ग्यूर्न्सी
      GH:घाना
      GI:जिब्राल्टार
      GL:ग्रिनल्याण्ड
      GM:गाम्विया
      GN:गिनी
      GP:ग्वाडेलुप
      GQ:भू-मध्यीय गिनी
      GR:ग्रीस
      GS:दक्षिण जर्जिया र दक्षिण स्यान्डवीच टापुहरू
      GT:ग्वाटेमाला
      GU:गुवाम
      GW:गिनी-बिसाउ
      GY:गुयाना
      HK:हङकङ चिनियाँ विशेष प्रशासनिक क्षेत्र
      HM:हर्ड टापु र म्याकडोनाल्ड टापुहरु
      HN:हन्डुरास
      HR:क्रोएशिया
      HT:हैटी
      HU:हङ्गेरी
      IC:क्यानारी टापुहरू
      ID:इन्डोनेशिया
      IE:आयरल्याण्ड
      IL:इजरायल
      IM:आइल अफ म्यान
      IN:भारत
      IO:बेलायती हिन्द महासागर क्षेत्र
      IQ:इराक
      IR:इरान
      IS:आइस्ल्याण्ड
      IT:इटली
      JE:जर्सी
      JM:जमैका
      JO:जोर्डन
      JP:जापान
      KE:केन्या
      KG:किर्गिस्तान
      KH:कम्बोडिया
      KI:किरिबाटी
      KM:कोमोरोस
      KN:सेन्ट किट्स र नेभिस
      KP:उत्तर कोरिया
      KR:दक्षिण कोरिया
      KW:कुवेत
      KY:केयमान टापु
      KZ:काजाकस्तान
      LA:लाओस
      LB:लेबनन
      LC:सेन्ट लुसिया
      LI:लिकटेन्सटाइन
      LK:श्रीलङ्का
      LR:लाइबेरिया
      LS:लेसोथो
      LT:लिथुएनिया
      LU:लक्जेमबर्ग
      LV:लाट्भिया
      LY:लिबिया
      MA:मोरोक्को
      MC:मोनाको
      MD:माल्डोभा
      ME:मोन्टेनिग्रो
      MF:सेन्ट मार्टिन
      MG:माडागास्कर
      MH:मार्शल टापुहरु
      MK:उत्तर म्यासेडोनिया
      ML:माली
      MM:म्यान्मार (बर्मा)
      MN:मङ्गोलिया
      MO:मकाउ चिनियाँ विशेष प्रशासनिक क्षेत्र
      MP:उत्तरी मारिआना टापु
      MQ:मार्टिनिक
      MR:माउरिटानिया
      MS:मोन्टसेर्राट
      MT:माल्टा
      MU:मौरिसियस
      MV:माल्दिभ्स
      MW:मालावी
      MX:मेक्सिको
      MY:मलेसिया
      MZ:मोजाम्बिक
      NA:नामिबिया
      NC:न्यु क्यालेडोनिया
      NE:नाइजर
      NF:नोरफोल्क टापु
      NG:नाइजेरिया
      NI:निकारागुवा
      NL:नेदरल्याण्ड
      NO:नर्वे
      NP:नेपाल
      NR:नाउरू
      NU:नियुइ
      NZ:न्युजिल्याण्ड
      OM:ओमन
      PA:प्यानामा
      PE:पेरू
      PF:फ्रान्सेली पोलिनेसिया
      PG:पपुआ न्यू गाइनिया
      PH:फिलिपिन्स
      PK:पाकिस्तान
      PL:पोल्याण्ड
      PM:सेन्ट पिर्रे र मिक्केलोन
      PN:पिटकाइर्न टापुहरु
      PR:पुएर्टो रिको
      PS:प्यालेस्टिनी भू-भागहरू
      PT:पोर्चुगल
      PW:पलाउ
      PY:प्याराग्वे
      QA:कतार
      QO:बाह्य ओसनिया
      RE:रियुनियन
      RO:रोमेनिया
      RS:सर्बिया
      RU:रूस
      RW:रवाण्डा
      SA:साउदी अरब
      SB:सोलोमन टापुहरू
      SC:सेचेलेस
      SD:सुडान
      SE:स्विडेन
      SG:सिङ्गापुर
      SH:सेन्ट हेलेना
      SI:स्लोभेनिया
      SJ:सभाल्बार्ड र जान मायेन
      SK:स्लोभाकिया
      SL:सिएर्रा लिओन
      SM:सान् मारिनो
      SN:सेनेगल
      SO:सोमालिया
      SR:सुरिनेम
      SS:दक्षिण सुडान
      ST:साओ टोमे र प्रिन्सिप
      SV:एल् साल्भाडोर
      SX:सिन्ट मार्टेन
      SY:सिरिया
      SZ:स्वाजिल्याण्ड
      TA:ट्रिस्टान डा कुन्हा
      TC:तुर्क र काइकोस टापु
      TD:चाड
      TF:फ्रेन्च दक्षिणी राज्यहरू
      TG:टोगो
      TH:थाइल्याण्ड
      TJ:ताजिकिस्तान
      TK:तोकेलाउ
      TL:टिमोर-लेस्टे
      TM:तुर्कमेनिस्तान
      TN:ट्युनिसिया
      TO:टोंगा
      TR:तुर्किये
      TT:त्रिनिडाड एण्ड टोबागो
      TV:तुभालु
      TW:ताइवान
      TZ:तान्जानिया
      UA:युक्रेन
      UG:युगाण्डा
      UM:संयुक्त राज्यका बाह्य टापुहरु
      UN:संयुक्त राष्ट्र संघ
      US:संयुक्त राज्य
      UY:उरूग्वे
      UZ:उज्बेकिस्तान
      VA:भेटिकन सिटी
      VC:सेन्ट भिन्सेन्ट र ग्रेनाडिन्स
      VE:भेनेजुएला
      VG:बेलायती भर्जिन टापुहरू
      VI:संयुक्त राज्य भर्जिन टापुहरु
      VN:भिएतनाम
      VU:भानुआतु
      WF:वालिस र फुटुना
      WS:सामोआ
      XA:सिउडो-एक्सेन्ट्स
      XB:सिउडो-बिडी
      XK:कोसोभो
      YE:येमेन
      YT:मायोट्ट
      ZA:दक्षिण अफ्रिका
      ZM:जाम्बिया
      ZW:जिम्बाबवे
      ZZ:अज्ञात क्षेत्र
      """.trimIndent() }

  val ne_IN: String? = null

  val nl: String by lazy { """
      001:wereld
      002:Afrika
      003:Noord-Amerika
      005:Zuid-Amerika
      009:Oceanië
      011:West-Afrika
      013:Midden-Amerika
      014:Oost-Afrika
      015:Noord-Afrika
      017:Centraal-Afrika
      018:Zuidelijk Afrika
      019:Amerika
      021:Noordelijk Amerika
      029:Caribisch gebied
      030:Oost-Azië
      034:Zuid-Azië
      035:Zuidoost-Azië
      039:Zuid-Europa
      053:Australazië
      054:Melanesië
      057:Micronesische regio
      061:Polynesië
      142:Azië
      143:Centraal-Azië
      145:West-Azië
      150:Europa
      151:Oost-Europa
      154:Noord-Europa
      155:West-Europa
      202:Sub-Saharaans Afrika
      419:Latijns-Amerika
      AC:Ascension
      AD:Andorra
      AE:Verenigde Arabische Emiraten
      AF:Afghanistan
      AG:Antigua en Barbuda
      AI:Anguilla
      AL:Albanië
      AM:Armenië
      AO:Angola
      AQ:Antarctica
      AR:Argentinië
      AS:Amerikaans-Samoa
      AT:Oostenrijk
      AU:Australië
      AW:Aruba
      AX:Åland
      AZ:Azerbeidzjan
      BA:Bosnië en Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:België
      BF:Burkina Faso
      BG:Bulgarije
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Saint-Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Caribisch Nederland
      BR:Brazilië
      BS:Bahama’s
      BT:Bhutan
      BV:Bouveteiland
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Canada
      CC:Cocoseilanden
      CD:Congo-Kinshasa
      CF:Centraal-Afrikaanse Republiek
      CG:Congo-Brazzaville
      CH:Zwitserland
      CI:Ivoorkust
      CK:Cookeilanden
      CL:Chili
      CM:Kameroen
      CN:China
      CO:Colombia
      CP:Clipperton
      CQ:Sark
      CR:Costa Rica
      CU:Cuba
      CV:Kaapverdië
      CW:Curaçao
      CX:Christmaseiland
      CY:Cyprus
      CZ:Tsjechië
      DE:Duitsland
      DG:Diego Garcia
      DJ:Djibouti
      DK:Denemarken
      DM:Dominica
      DO:Dominicaanse Republiek
      DZ:Algerije
      EA:Ceuta en Melilla
      EC:Ecuador
      EE:Estland
      EG:Egypte
      EH:Westelijke Sahara
      ER:Eritrea
      ES:Spanje
      ET:Ethiopië
      EU:Europese Unie
      EZ:eurozone
      FI:Finland
      FJ:Fiji
      FK:Falklandeilanden
      FM:Micronesia
      FO:Faeröer
      FR:Frankrijk
      GA:Gabon
      GB:Verenigd Koninkrijk
      GD:Grenada
      GE:Georgië
      GF:Frans-Guyana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Groenland
      GM:Gambia
      GN:Guinee
      GP:Guadeloupe
      GQ:Equatoriaal-Guinea
      GR:Griekenland
      GS:Zuid-Georgia en Zuidelijke Sandwicheilanden
      GT:Guatemala
      GU:Guam
      GW:Guinee-Bissau
      GY:Guyana
      HK:Hongkong SAR van China
      HM:Heard en McDonaldeilanden
      HN:Honduras
      HR:Kroatië
      HT:Haïti
      HU:Hongarije
      IC:Canarische Eilanden
      ID:Indonesië
      IE:Ierland
      IL:Israël
      IM:Isle of Man
      IN:India
      IO:Brits Indische Oceaanterritorium
      IQ:Irak
      IR:Iran
      IS:IJsland
      IT:Italië
      JE:Jersey
      JM:Jamaica
      JO:Jordanië
      JP:Japan
      KE:Kenia
      KG:Kirgizië
      KH:Cambodja
      KI:Kiribati
      KM:Comoren
      KN:Saint Kitts en Nevis
      KP:Noord-Korea
      KR:Zuid-Korea
      KW:Koeweit
      KY:Kaaimaneilanden
      KZ:Kazachstan
      LA:Laos
      LB:Libanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Litouwen
      LU:Luxemburg
      LV:Letland
      LY:Libië
      MA:Marokko
      MC:Monaco
      MD:Moldavië
      ME:Montenegro
      MF:Saint-Martin
      MG:Madagaskar
      MH:Marshalleilanden
      MK:Noord-Macedonië
      ML:Mali
      MM:Myanmar (Birma)
      MN:Mongolië
      MO:Macau SAR van China
      MP:Noordelijke Marianen
      MQ:Martinique
      MR:Mauritanië
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldiven
      MW:Malawi
      MX:Mexico
      MY:Maleisië
      MZ:Mozambique
      NA:Namibië
      NC:Nieuw-Caledonië
      NE:Niger
      NF:Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Nederland
      NO:Noorwegen
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nieuw-Zeeland
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Frans-Polynesië
      PG:Papoea-Nieuw-Guinea
      PH:Filipijnen
      PK:Pakistan
      PL:Polen
      PM:Saint-Pierre en Miquelon
      PN:Pitcairneilanden
      PR:Puerto Rico
      PS:Palestijnse gebieden
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:overig Oceanië
      RE:Réunion
      RO:Roemenië
      RS:Servië
      RU:Rusland
      RW:Rwanda
      SA:Saoedi-Arabië
      SB:Salomonseilanden
      SC:Seychellen
      SD:Soedan
      SE:Zweden
      SG:Singapore
      SH:Sint-Helena
      SI:Slovenië
      SJ:Spitsbergen en Jan Mayen
      SK:Slowakije
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalië
      SR:Suriname
      SS:Zuid-Soedan
      ST:Sao Tomé en Principe
      SV:El Salvador
      SX:Sint-Maarten
      SY:Syrië
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks- en Caicoseilanden
      TD:Tsjaad
      TF:Franse Gebieden in de zuidelijke Indische Oceaan
      TG:Togo
      TH:Thailand
      TJ:Tadzjikistan
      TK:Tokelau
      TL:Oost-Timor
      TM:Turkmenistan
      TN:Tunesië
      TO:Tonga
      TR:Turkije
      TT:Trinidad en Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Oekraïne
      UG:Oeganda
      UM:Kleine afgelegen eilanden van de Verenigde Staten
      UN:Verenigde Naties
      US:Verenigde Staten
      UY:Uruguay
      UZ:Oezbekistan
      VA:Vaticaanstad
      VC:Saint Vincent en de Grenadines
      VE:Venezuela
      VG:Britse Maagdeneilanden
      VI:Amerikaanse Maagdeneilanden
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis en Futuna
      WS:Samoa
      XA:Pseudo-Accenten
      XB:Pseudo-Bidi
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Zuid-Afrika
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:onbekend gebied
      """.trimIndent() }

  val nl_AW: String? = null

  val nl_BE: String? = null

  val nl_BQ: String? = null

  val nl_CW: String? = null

  val nl_SR: String? = null

  val nl_SX: String? = null

  val nmg: String by lazy { """
      AD:Andɔ́ra
      AE:Minlambɔ́ Nsaŋ́nsa mí Arabia
      AF:Afganistaŋ
      AG:Antíga bá Barbúda
      AI:Anguílla
      AL:Albania
      AM:Arménia
      AO:Angola
      AR:Argentína
      AS:Samoa m ́Amɛ́rka
      AT:Ötrish
      AU:Östraliá
      AW:Árúba
      AZ:Azerbaïjaŋ
      BA:Bosnia na Ɛrzegovina
      BB:Barbado
      BD:Bɛŋgladɛsh
      BE:Bɛlgik
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BM:Bɛrmuda
      BN:Brunɛi
      BO:Bolivia
      BR:Brésil
      BS:Bahamas
      BT:Butaŋ
      BW:Botswana
      BY:Belarus
      BZ:Bɛliz
      CA:Kanada
      CD:Kongó Zaïre
      CF:Sentrafríka
      CG:Kongo
      CH:Switzɛrland
      CI:Kote d´Ivoire
      CK:Maŋ́ má Kook
      CL:Tshili
      CM:Kamerun
      CN:Shine
      CO:Kɔlɔ́mbia
      CR:Kosta Ríka
      CU:Kuba
      CV:Maŋ́ má Kapvɛr
      CY:Sipria
      CZ:Nlambɔ́ bó tschɛk
      DE:Jaman
      DJ:Jibúti
      DK:Danemark
      DM:Dominíka
      DO:Nlambɔ́ Dominíka
      DZ:Algeria
      EC:Ekuateur
      EE:Ɛstonia
      EG:Ägyptɛn
      ER:Erytrea
      ES:Paŋá
      ET:Ethiopiá
      FI:Finlande
      FJ:Fijiá
      FK:Maŋ má Falkland
      FM:Mikronesia
      FR:Fala
      GA:Gabɔŋ
      GB:Nlambɔ́ Ngɛlɛn
      GD:Grenada
      GE:Jɔrgia
      GF:Guyane Fala
      GH:Gána
      GI:Gilbratar
      GL:Greenland
      GM:Gambia
      GN:Guine
      GP:Guadeloup
      GQ:Guine Ekuatorial
      GR:Grɛce
      GT:Guatemala
      GU:Guam
      GW:Guine Bisso
      GY:Guyana
      HN:Ɔndúras
      HR:Kroasia
      HT:Haïti
      HU:Ɔngría
      ID:Indonesia
      IE:Irland
      IL:Äsrɛl
      IN:India
      IQ:Irak
      IR:Iran
      IS:Island
      IT:Italia
      JM:Jamaika
      JO:Jɔrdania
      JP:Japɔn
      KE:Kɛnya
      KG:Kyrgystaŋ
      KH:Kambodia
      KI:Kiribati
      KM:Kɔmɔr
      KN:Saint Kitts na Nevis
      KP:Koré yí bvuɔ
      KR:Koré yí sí
      KW:Kowɛit
      KY:Maŋ́ má kumbi
      KZ:Kazakstaŋ
      LA:Laos
      LB:Libaŋ
      LC:Saint Lucia
      LI:Lishenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesoto
      LT:Lituaniá
      LU:Luxembourg
      LV:Latvia
      LY:Libya
      MA:Marɔk
      MC:Monako
      MD:Mɔldavia
      MG:Madagaskar
      MH:Maŋ́ má Marshall
      ML:Mali
      MM:Myanmar
      MN:Mɔngolia
      MP:Maŋ́ Mariá
      MQ:Martinika
      MR:Moritania
      MS:Mɔnserrat
      MT:Malta
      MU:Morisse
      MV:Maldivia
      MW:Malawi
      MX:Mɛxik
      MY:Malaysia
      MZ:Mozambik
      NA:Namibia
      NC:Kaledoni nwanah
      NE:Niger
      NF:Maŋ́ má Nɔrfɔrk
      NG:Nigeria
      NI:Nikaragua
      NL:Nedɛrland
      NO:Nɔrvɛg
      NP:Nepal
      NR:Noru
      NU:Niuɛ
      NZ:Zeland nwanah
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Polynesia Fala
      PG:Guine Papuasi
      PH:Filipin
      PK:Pakistan
      PL:Pɔlɔŋ
      PM:Saint Peter ba Mikelɔn
      PN:Pitkairn
      PR:Puɛrto Riko
      PS:Palɛstin
      PT:Pɔrtugal
      PW:Palo
      PY:Paraguay
      QA:Katar
      RE:Réuniɔn
      RO:Roumania
      RU:Russi
      RW:Rwanda
      SA:Saudi Arabia
      SB:Maŋ́ má Salomɔn
      SC:Seychɛlle
      SD:Sudaŋ
      SE:Suɛd
      SG:Singapur
      SH:Saint Lina
      SI:Slovenia
      SK:Slovakia
      SL:Sierra Leɔn
      SM:San Marino
      SN:Senegal
      SO:Somália
      SR:Surinam
      ST:Sao Tomé ba Prinship
      SV:Salvadɔr
      SY:Syria
      SZ:Swaziland
      TC:Maŋ́ má Turk na Kaiko
      TD:Tshad
      TG:Togo
      TH:Taïland
      TJ:Tajikistaŋ
      TK:Tokelo
      TL:Timɔr tsindikēh
      TM:Turkmɛnistaŋ
      TN:Tunisiá
      TO:Tɔnga
      TR:Turki
      TT:Trinidad ba Tobágó
      TV:Tuvalú
      TW:Taïwan
      TZ:Tanzánía
      UA:Ukrɛn
      UG:Uganda
      US:Amɛŕka
      UY:Uruguay
      UZ:Usbǝkistaŋ
      VA:Vatikaŋ
      VC:Saint Vincent ba Grenadines
      VE:Vǝnǝzuela
      VG:Minsilɛ́ mímaŋ mí ngɛ̄lɛ̄n
      VI:Minsilɛ mí maŋ́ m´Amɛrka
      VN:Viɛtnam
      VU:Vanuatu
      WF:Wallis ba Futuna
      WS:Samoa
      YE:Yǝmɛn
      YT:Mayɔt
      ZA:Afríka yí sí
      ZM:Zambia
      ZW:Zimbabwǝ
      """.trimIndent() }

  val nn: String by lazy { """
      001:verda
      013:Sentral-Amerika
      014:Aust-Afrika
      018:Sørlege Afrika
      021:Nordlege Amerika
      030:Aust-Asia
      035:Søraust-Asia
      151:Aust-Europa
      AE:Dei sameinte arabiske emirata
      AT:Austerrike
      CC:Kokosøyane
      CD:Kongo-Kinshasa
      CF:Den sentralafrikanske republikken
      CI:Elfenbeinskysten
      CK:Cookøyane
      DO:Den dominikanske republikken
      EU:Den europeiske unionen
      EZ:eurosona
      FK:Falklandsøyane
      FO:Færøyane
      GS:Sør-Georgia og Sør-Sandwichøyane
      HM:Heardøya og McDonaldøyane
      IC:Kanariøyane
      KM:Komorane
      KY:Caymanøyane
      LU:Luxembourg
      MH:Marshalløyane
      MP:Nord-Marianane
      MV:Maldivane
      NO:Noreg
      PH:Filippinane
      PN:Pitcairn
      SB:Salomonøyane
      SC:Seychellane
      SH:Saint Helena
      TC:Turks- og Caicosøyane
      TF:Dei franske sørterritoria
      TL:Aust-Timor
      UM:USAs ytre småøyar
      UN:Dei sameinte nasjonane
      VC:St. Vincent og Grenadinane
      VG:Dei britiske Jomfruøyane
      VI:Dei amerikanske Jomfruøyane
      XA:pseudospråk – aksentar
      XB:pseudospråk – RTL
      """.trimIndent() }

  val nnh: String by lazy { """
      CM:Kàmalûm
      """.trimIndent() }

  val no: String by lazy { """
      001:verden
      002:Afrika
      003:Nord-Amerika
      005:Sør-Amerika
      009:Oseania
      011:Vest-Afrika
      013:Mellom-Amerika
      014:Øst-Afrika
      015:Nord-Afrika
      017:Sentral-Afrika
      018:Sørlige Afrika
      019:Amerika
      021:Nordlige Amerika
      029:Karibia
      030:Øst-Asia
      034:Sør-Asia
      035:Sørøst-Asia
      039:Sør-Europa
      053:Australasia
      054:Melanesia
      057:Mikronesia
      061:Polynesia
      142:Asia
      143:Sentral-Asia
      145:Vest-Asia
      150:Europa
      151:Øst-Europa
      154:Nord-Europa
      155:Vest-Europa
      202:Afrika sør for Sahara
      419:Latin-Amerika
      AC:Ascension
      AD:Andorra
      AE:De forente arabiske emirater
      AF:Afghanistan
      AG:Antigua og Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarktis
      AR:Argentina
      AS:Amerikansk Samoa
      AT:Østerrike
      AU:Australia
      AW:Aruba
      AX:Åland
      AZ:Aserbajdsjan
      BA:Bosnia-Hercegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgia
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Saint-Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Karibisk Nederland
      BR:Brasil
      BS:Bahamas
      BT:Bhutan
      BV:Bouvetøya
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Canada
      CC:Kokosøyene
      CD:Kongo
      CF:Den sentralafrikanske republikk
      CG:Kongo-Brazzaville
      CH:Sveits
      CI:Elfenbenskysten
      CK:Cookøyene
      CL:Chile
      CM:Kamerun
      CN:Kina
      CO:Colombia
      CP:Clippertonøya
      CQ:Sark
      CR:Costa Rica
      CU:Cuba
      CV:Kapp Verde
      CW:Curaçao
      CX:Christmasøya
      CY:Kypros
      CZ:Tsjekkia
      DE:Tyskland
      DG:Diego Garcia
      DJ:Djibouti
      DK:Danmark
      DM:Dominica
      DO:Den dominikanske republikk
      DZ:Algerie
      EA:Ceuta og Melilla
      EC:Ecuador
      EE:Estland
      EG:Egypt
      EH:Vest-Sahara
      ER:Eritrea
      ES:Spania
      ET:Etiopia
      EU:Den europeiske union
      EZ:eurosonen
      FI:Finland
      FJ:Fiji
      FK:Falklandsøyene
      FM:Mikronesiaføderasjonen
      FO:Færøyene
      FR:Frankrike
      GA:Gabon
      GB:Storbritannia
      GD:Grenada
      GE:Georgia
      GF:Fransk Guyana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grønland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Ekvatorial-Guinea
      GR:Hellas
      GS:Sør-Georgia og Sør-Sandwichøyene
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hongkong SAR Kina
      HM:Heard- og McDonaldøyene
      HN:Honduras
      HR:Kroatia
      HT:Haiti
      HU:Ungarn
      IC:Kanariøyene
      ID:Indonesia
      IE:Irland
      IL:Israel
      IM:Man
      IN:India
      IO:Det britiske territoriet i Indiahavet
      IQ:Irak
      IR:Iran
      IS:Island
      IT:Italia
      JE:Jersey
      JM:Jamaica
      JO:Jordan
      JP:Japan
      KE:Kenya
      KG:Kirgisistan
      KH:Kambodsja
      KI:Kiribati
      KM:Komorene
      KN:Saint Kitts og Nevis
      KP:Nord-Korea
      KR:Sør-Korea
      KW:Kuwait
      KY:Caymanøyene
      KZ:Kasakhstan
      LA:Laos
      LB:Libanon
      LC:St. Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Litauen
      LU:Luxemburg
      LV:Latvia
      LY:Libya
      MA:Marokko
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:Saint-Martin
      MG:Madagaskar
      MH:Marshalløyene
      MK:Nord-Makedonia
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Macao SAR Kina
      MP:Nord-Marianene
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldivene
      MW:Malawi
      MX:Mexico
      MY:Malaysia
      MZ:Mosambik
      NA:Namibia
      NC:Ny-Caledonia
      NE:Niger
      NF:Norfolkøya
      NG:Nigeria
      NI:Nicaragua
      NL:Nederland
      NO:Norge
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Fransk Polynesia
      PG:Papua Ny-Guinea
      PH:Filippinene
      PK:Pakistan
      PL:Polen
      PM:Saint-Pierre-et-Miquelon
      PN:Pitcairnøyene
      PR:Puerto Rico
      PS:Det palestinske området
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Ytre Oseania
      RE:Réunion
      RO:Romania
      RS:Serbia
      RU:Russland
      RW:Rwanda
      SA:Saudi-Arabia
      SB:Salomonøyene
      SC:Seychellene
      SD:Sudan
      SE:Sverige
      SG:Singapore
      SH:St. Helena
      SI:Slovenia
      SJ:Svalbard og Jan Mayen
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Sør-Sudan
      ST:São Tomé og Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks- og Caicosøyene
      TD:Tsjad
      TF:De franske sørterritorier
      TG:Togo
      TH:Thailand
      TJ:Tadsjikistan
      TK:Tokelau
      TL:Øst-Timor
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Tyrkia
      TT:Trinidad og Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraina
      UG:Uganda
      UM:USAs ytre øyer
      UN:FN
      US:USA
      UY:Uruguay
      UZ:Usbekistan
      VA:Vatikanstaten
      VC:St. Vincent og Grenadinene
      VE:Venezuela
      VG:De britiske jomfruøyene
      VI:De amerikanske jomfruøyene
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis og Futuna
      WS:Samoa
      XA:pseudospråk – aksenter
      XB:pseudospråk – tekst begge veier
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Sør-Afrika
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:ukjent område
      """.trimIndent() }

  val nqo: String by lazy { """
      001:ߞߌߢߍ߲߫
      002:ߝߘߊ߬ߝߌ߲߬ߠߊ߫
      003:ߊߡߋߙߌߞߌ߬ ߞߐ߬ߘߎ߮
      005:ߊߡߋߙߌߞߌ߬ ߥߙߏ߬ߘߎ߮
      009:ߟߌ߲ߓߊ߲ߘߎ߯
      011:ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߟߋ߬ߓߋ
      013:ߊߡߋߙߌߞߌ߬ ߕߊ߲ߓߊ߲
      014:ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߟߋ߬ߓߐ
      015:ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߞߐ߬ߘߎ߮
      017:ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߊ߲ߓߊ߲
      018:ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߥߙߏ߬ߘߎ߮
      019:ߊߡߋߙߌߞߌ߬
      021:ߞߐ߰ߘߎ߮ ߊߡߋߙߌߞߌ߬
      029:ߞߙߊߦߌߓ
      030:ߊߖ߭ߌ߫ ߕߟߋ߬ߓߐ
      034:ߊߖ߭ߌ߫ ߥߙߏ߬ߘߎ߮
      035:ߊߖ߭ߌ߫ ߥߙߏ߬ߘߎ߮-ߕߟߋ߬ߓߐ
      039:ߋߙߐߔߎ߬ ߥߙߏ߬ߘߎ߮
      053:ߐߛߑߕߙߊߟߊߖ߭ߌ߫
      054:ߡߋߟߊߣߋߖ߭ߌ߫
      057:ߡߌߞߙߏߣߋߖ߭ߌ߫ ߕߌ߲߬ߞߎߘߎ߲
      061:ߔߏߟߣߋߖ߭ߌ߫
      142:ߊߖ߭ߌ߫
      143:ߊߖ߭ߌ߫ ߕߊ߲ߓߊ߲
      145:ߊߖ߭ߌ߫ ߕߟߋ߬ߓߋ
      150:ߋߙߐߔߎ߬
      151:ߋߙߐߔߎ߬ ߕߟߋ߬ߓߐ
      154:ߋߙߐߔߎ߬ ߞߐ߬ߘߎ߮
      155:ߋߙߐߔߎ߬ ߕߟߋ߬ߓߋ
      202:ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߞߌ߬ߢߍ߬ߞߏ߲ߞߏ߫ ߘߎ߰ߟߊ߬-ߖߡߊߣߊ
      419:ߊߡߋߙߞߌ߬ ߟߊ߬ߕߍ߬ߡߊ߬ ߦߙߐ
      AC:ߊߛߊ߲ߛߌߦߐ߲߫ ߕߌ߲
      AD:ߊ߲ߘߐߙ
      AE:ߋߡߌߙߊߕ ߊߙߊߓߎ߫ ߘߍ߬ߣߍ߲
      AF:ߊߝߎߜ߭ߊߣߌߛߑߕߊ߲߫
      AG:ߊ߲ߕߌߞߎߥߊ߫ ߣߌ߫ ߓߊߙߑߓߎߘߊ߫
      AI:ߊ߲ߞߎ߳ߟߊ߫
      AL:ߊߟߑߓߊߣߌ߫
      AM:ߊߙߑߡߋߣߌ߫
      AO:ߊ߲ߜߏߟߊ߫
      AQ:ߊ߲ߕߊߙߑߛߕߌߞ
      AR:ߊߙߑߖ߭ߊ߲ߕߌߣ
      AS:ߛߊߡߏߥߊ߫ ߊߡߋߙߞߌߞߊ
      AT:ߏߕߑߙߌߛ
      AU:ߐߛߑߕߙߊߟߌ߫
      AW:ߊߙߎߓߊ߫
      AX:ߊߟߊ߲ߘ ߕߌ߲
      AZ:ߊߖߊߙߑߓߊߦߌߖߊ߲
      BA:ߓߐߛߑߣߌ߫-ߍߙߑߖ߭ߋߜ߭ߏߝ߭ߌߣ
      BB:ߓߊߙߑߓߊߘ
      BD:ߓߊ߲ߜ߭ߑߟߊߘߍߛ
      BE:ߓߍߟߑߖ߭ߌߞ
      BF:ߓߙߎߞߌߣߊ߫ ߝߊ߬ߛߏ߫
      BG:ߓߌߟߑߜ߭ߊ߯ߙߌ߫
      BH:ߓߤߊ߬ߙߊߦߌ߬ߣ
      BI:ߓߎߙߎ߲ߘߌ߫
      BJ:ߓߋߣߍ߲߫
      BL:ߛߍ߲ߕ-ߓߌߙߑߕߟߋߡߌ߫
      BM:ߓߍߙߑߓߎߘ
      BN:ߓߙߎߣߋ߫
      BO:ߓߏߟߝ߭ߌ߫
      BQ:ߤߏߟߊ߲ߘ ߞߊߙߌߓߋ߫
      BR:ߓߙߋߖ߭ߌߟ
      BS:ߓߤߊߡߊߛ
      BT:ߓߎߕߊ߲߫
      BV:ߓߎߝ߭ߋ߫ ߕߌ߲
      BW:ߓߐߛߎߥߣߊ߫
      BY:ߓߌߟߏߙߌߛ
      BZ:ߓߋߟߌߖ߭
      CA:ߞߣߊߘߊ߫
      CC:ߞߏߞߏ߫ ߕߌ߲
      CD:ߞߏ߲߬ߜ߭ߏ߫-ߞߌ߲ߛߊߛߊ߫
      CF:ߕߊ߲ߓߊ߲-ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߞߊ߲ߓߍ߲
      CG:ߞߏ߲߬ߜ߭ߏ߫-ߓߙߊߖ߭ߊ߫
      CH:ߛߎߥߌߛ
      CI:ߜߋ߲-ߞߐ߰ߖߌ߬ߘߊ
      CK:ߞߎߞ ߕߌ߲
      CL:ߛ߭ߟߌ߫
      CM:ߞߊߡߋߙߎ߲
      CN:ߛߌߣ
      CO:ߞߏߟߐ߲ߓߌ߫
      CP:ߞߟߌߔߍߙߑߕߐ߲߫ ߕߌ߲
      CR:ߞߐߛߑߕߊ߫ ߙߌߞߊ߫
      CU:ߞߎ߳ߓߊ߫
      CV:ߜߙߋߞߎ߲߫-ߝߙߌߛߌ߫
      CW:ߞߎߙߛߊߏ߫
      CX:ߞߙߌߛߑߕߌߡߊ߫ ߕߌ߲
      CY:ߛߌߔߑߙߎ߫
      CZ:ߗߍߞ
      DE:ߊߟߑߡߊ߲ߘߎ߯
      DG:ߖߋߜ߭ߏ߫-ߜ߭ߊߙߑߛߌߦߊ߫
      DJ:ߖߌߓߎߕߌ߫
      DK:ߘߊߣߌߡߊߙߑߞ
      DM:ߘߏߡߣߌߞ
      DO:ߘߏߡߣߌߞ ߞߊ߲ߓߍ߲
      DZ:ߊߟߑߖ߭ߋߙߌ߫
      EA:ߛߋߎߕߊ߫ ߣߌ߫ ߡߋߟߌߣߊ߫
      EC:ߕߍߡߊߓߊ߲߮
      EE:ߋߛߑߕߏߣߌ߫
      EG:ߋߖ߭ߌߔߑߕ
      EH:ߞߌ߲߬ߢߍ߬ߞߏ߲ߞߏ߫ ߕߟߋ߬ߓߋ
      ER:ߋߙߕߌߙߋ߫
      ES:ߊߛߌߔߊ߲߫
      ET:ߋߗߏߔߌ߫
      EU:ߋߙߐߔߎ߬ ߘߍ߭
      EZ:ߋߙߐߔߎ߬ ߞߣߍ
      FI:ߝߍ߲ߟߊ߲ߘ
      FJ:ߝߖߌ߫
      FK:ߡߊߟߎ߲ߌ߲߫ ߕߌ߲
      FM:ߡߌߞߙߏߣߋߖ߭ߌ߫
      FO:ߝߋߙߏߦߋ߫ ߕߌ߲
      FR:ߝߊ߬ߙߊ߲߬ߛߌ߫
      GA:ߜ߭ߊߓߐ߲߫
      GB:ߡߊ߲߬ߛߊ߬ߟߊ߫ ߟߊߘߍ߬ߣߍ߲
      GD:ߜ߭ߙߋߣߊߘ
      GE:ߖ߭ߋߐߙߑߖ߭ߌ߫
      GF:ߝߊ߲߬ߙߊ߲߬ߛߌ߫ ߜ߭ߎ߳ߦߊߣ
      GG:ߜ߭ߋߙߑߣߋߖ߭ߌ߫
      GH:ߜ߭ߊ߯ߣߊ߫
      GI:ߜ߭ߌߓߙߊߟߑߕߊߙ
      GL:ߜ߭ߎߙߎ߲ߟߊ߲ߘ
      GM:ߜ߭ߊ߲ߓߌ߫
      GN:ߖߌ߬ߣߍ߫
      GP:ߜ߭ߎߥߊߘߋߟߎߔ
      GQ:ߕߍߡߊߓߊ߲߮-ߖߌ߬ߣߍ߫
      GR:ߜ߭ߙߍ߬ߞߌ߬
      GS:ߖ߭ߐߙߑߖ߭ߌ߫ ߥߙߏ߬ߘߎ߮ ߣߌ߫ ߛߊ߲ߘߎߥߌߛ ߕߌ߲
      GT:ߜ߭ߎߥߊߕߋߡߟߊ߫
      GU:ߜ߭ߎߥߊߡ
      GW:ߖߌ߬ߣߍ߫ ߓߌߛߊߥߏ߫
      GY:ߜ߭ߎߦߊߣ
      HK:ߛߌߣ ߕߌ߲߬ߞߎߘߎ߲߫ ߡߊߡߙߊ߬ߣߍ߲ ߤߐ߲ߞߐ߲߫
      HM:ߡߊߞߑߘߏߣߊߟߑߘ ߕߌ߲
      HN:ߤߎ߲ߘߎߙߊ߫
      HR:ߞߙߏߥߊߛߌ߫
      HT:ߤߊߦߕߌ߫
      HU:ߤߐ߲ߜ߭ߙߌ߫
      IC:ߞߣߊߙߌ߫ ߕߌ߲
      ID:ߍ߲ߘߣߏߖ߭ߌ߫
      IE:ߌߙߑߟߊ߲ߘ
      IL:ߌߛߑߙߊߍߟ
      IM:ߡߊ߲߯ ߕߌ߲
      IN:ߌߘߎ߬
      IO:ߓߙߌߕߊ߲ߓߊ߫ ߟߊ߫ ߌ߲ߘߎ߫ ߟߌ߲ߓߊ߲ ߞߣߍ
      IQ:ߌߙߊߞߌ߬
      IR:ߌߙߊ߲߫
      IS:ߌߛߑߟߊߘ
      IT:ߌߕߊߟߌ߫
      JE:ߖߋߙߑߖ߭ߌ߫
      JM:ߖ߭ߡߊߦߌߞ
      JO:ߖߐߙߑߘߊߣߌ߫
      JP:ߖ߭ߊߔߐ߲߫
      KE:ߞߋߣߌߦߊ߫
      KG:ߞߌߙߑߜ߭ߌߛߑߕߊ߲߫
      KH:ߞߊ߲ߓߐߘߑߖ
      KI:ߞߙߌߓߊߕߌ߫
      KM:ߞߡߐߙ
      KN:ߛߍ߲ߕ-ߞߙߌߛߑߕߐߝ ߣߌ߫ ߢߝ߭ߋ߫
      KP:ߞߐ߬ߘߎ߮ ߞߏ߯ߙߋ߫
      KR:ߕߟߋ߬ߓߋ ߞߏ߯ߙߋ߫
      KW:ߞߎ߬ߥߊ߬ߕ
      KY:ߓߊ߲߬ߓߊ߬-ߕߌ߲
      KZ:ߞߖ߭ߊߞߌߛߑߕߊ߲߫
      LA:ߟߊߐߛ
      LB:ߟߌߓߊ߲߫
      LC:ߛߍ߲ߕ-ߟߎ߳ߛߌ߫
      LI:ߟߎߛߑߕߊ߲ߛߑߕߍ߲߫
      LK:ߛߙߌߟߊ߲ߞߊ߫
      LR:ߟߌߓߋߙߌߦߊ߫
      LS:ߟߋߛߕߏ߫
      LT:ߟߎߕߎ߳ߦߊߣߌ߫
      LU:ߟߎߜ߭ߑߛߊ߲ߓߎ߯ߙ
      LV:ߟߋߕߏߣߌ߫
      LY:ߟߓߌ߫
      MA:ߡߊ߬ߙߐߞߎ߬
      MC:ߡߏߣߊߞߏ߫
      MD:ߡߐߟߑߘߊߝ߭ߌ߫
      ME:ߡߐ߲ߕߣߋߜ߭ߙߏ߫
      MF:ߛߍ߲ߕ-ߡߊߙߑߕߍ߲߫
      MG:ߡߘߊߜ߭ߛߑߞߊ߯ߙ
      MH:ߡߊߙߑߛߊߟ ߕߌ߲
      MK:ߞߐ߬ߘߎ߮ ߡߊߛߋߘߏߣߌ߫
      ML:ߡߊ߬ߟߌ߬
      MM:ߡߌߦߊߡߊ߯ߙ ( ߓߙߌߡߊߣߌ߫ )
      MN:ߡߐ߲ߜ߭ߐߟߌ߫
      MO:ߛߌߣ ߕߌ߲߬ߞߎߘߎ߲߫ ߡߊߡߙߊ߬ߣߍ߲ ߡߞߊߥߏ߫
      MP:ߡߊߙߌߦߊߣ ߞߐ߬ߘߎ߮ ߕߌ߲
      MQ:ߡߊߙߑߕߣߌߞ
      MR:ߡߏߙߌߕߊߣߌ߫
      MS:ߡߐ߲ߗߋߙߊ߫
      MT:ߡߊߟߑߕ
      MU:ߡߏߙߌߛ
      MV:ߡߊߟߑߘߌߝ߭
      MW:ߡߟߊߥߌ߫
      MX:ߡߍߞߑߛߌߞ
      MY:ߡߊߟߍߘߎ߯
      MZ:ߡߏߖ߭ߊ߲ߓߌߞ
      NA:ߣߊߡߌ߲ߓߌ߫
      NC:ߞߊߟߋߘߏߣߌ߫-ߞߎߘߊ߫
      NE:ߖߋ߬ߟߌ߬ߓߊߘߎ߯
      NF:ߣߐߙߑߝߐߟߑߞ
      NG:ߖߋ߬ߟߌ߬ߓߊ߬ߟߊ߫
      NI:ߣߌߞߙߊߜ߭ߎߥߊ߫
      NL:ߤߏߟߊ߲ߘ
      NO:ߣߐߙߑߝ߭ߍߖ
      NP:ߣߋߔߊߟ
      NR:ߣߏ߯ߙߎ߫
      NU:ߣߎ߳ߋ߫
      NZ:ߖ߭ߋߟߊ߲ߘߌ߫-ߞߎߘߊ߫
      OM:ߏߡߊ߲߫
      PA:ߔߣߊߡߊ߫
      PE:ߔߋߙߎ߫
      PF:ߝߊ߬ߙߊ߲߬ߛߌ߫ ߔߏߟߌߣߋߖ߭ߌ߫
      PG:ߡߊߡߎߥߊߖ߭ߌ߫ ߖߌ߬ߣߍ߬-ߞߎߘߊ߫
      PH:ߝߟߌߔߌ߲ߣ
      PK:ߔߊߞߌߛߑߕߊ߲߫
      PL:ߔߏߟߐߢ
      PM:ߛߍ߲ߕ-ߔߍ߯ߙ ߣߌ߫ ߡߌ߲ߞߋߟߐ߲߫
      PN:ߔߌߕߑߞߍ߲ ߕߌ߲
      PR:ߔߐߙߑߕߏ߫-ߙߌߞߏ߫
      PS:ߔߊߟߍߛߑߕߌߣ ߞߣߍ
      PT:ߔߐߙߑߕߎߜ߭ߊߟ
      PW:ߔߟߊߐߛ
      PY:ߔߙߊߜ߭ߏߦߋ߫
      QA:ߞߊߕߊ߯ߙ
      QO:ߟߌ߲ߓߊ߲ߘߎ߯ ߕߌ߲߬ߞߎߘߎ߲ ߦߙߐ߫ ߡߊߕߊ߯ߣߍ߲
      RE:ߟߊ߬ߘߍ
      RO:ߙߎߡߊߣߌ߫
      RS:ߛߍߙߑߓߌ߫
      RU:ߌߙߌ߬ߛߌ߫
      RW:ߙߎߥߊ߲ߘߊ߫
      SA:ߛߎ߰ߘߎ߬ߟߊ߫-ߡߊ߲߬ߛߊ߬ߟߊ
      SB:ߛߊߟߏߡߐ߲߫ ߕߌ߲
      SC:ߛߋߦߌߛߍߟ
      SD:ߛߎߘߊ߲߫
      SE:ߛߎߥߍߘ
      SG:ߛߌ߲ߜ߭ߊߔߎߙ
      SH:ߛߍ߲ߕ-ߋߟߍߣ
      SI:ߛߑߟߏߝ߭ߋߣߌ߫
      SJ:ߛߊߟߑߓߊߙ ߣߌ߫ ߖ߭ߊ߲ ߡߊߦߍ߲߫
      SK:ߛߑߟߏߝ߭ߊߞߌ߫
      SL:ߛߙߊ߬ߟߏ߲߫
      SM:ߛߍߕ-ߡߊߙߍ߲߫
      SN:ߛߣߍ߬ߜߊ߯ߟߌ߫
      SO:ߛߏߡߊߟߌ߫
      SR:ߛߎߙߑߣߊߡ
      SS:ߥߙߏ߬ߘߎ߮ ߛߎ߬ߘߊ߲߫
      ST:ߛߊߥߕߏߡߋ߫ ߣߌ߫ ߔߑߙߍ߲ߛߌߔ
      SV:ߛߊߟߑߝ߭ߊߘߐߙ
      SX:ߛߍ߲ߕ-ߡߊߙߑߕߍ߲߫ ( ߤߏߟߊ߲ߘ ߝߊ߲߭ߝߍ߬ )
      SY:ߛߙߌ߫
      SZ:ߒߛߎߥߊߕߣߌ߫
      TA:ߞߎ߲ߓߊ߫ ߕߑߙߌߛߑߕߊ߫
      TC:ߕߎߙߑߞߌ߫ ߣߌ߫ ߞߊߦߌߞ
      TD:ߗߊߘ
      TF:ߝߊ߬ߙߊ߲߬ߛߌ߫ ߘߎ߰ߞߟߏ ߓߊߙߌ ߘߐ߫
      TG:ߕߜ߭ߏ߫
      TH:ߕߊߦߌߘߎ߯
      TJ:ߕߊߖߞߌߛߑߕߊ߲߫
      TK:ߕߏߞߋߟߊߏ߫
      TL:ߕߌߡߐߙ ߕߟߋ߬ߓߐ߬ߝߊ߲
      TM:ߕߎߙߑߞߌߡߋߣߌߛߑߕߊ߲߫
      TN:ߕߎߣߖ߭ߌ߫
      TO:ߕߏ߲ߜ߭ߊ߫
      TR:ߕߎߙߑߞߌ߫
      TT:ߕߙߌߣߌߕߋ߫ ߣߌ߫ ߕߏߓߊߜ߭ߏ߫
      TV:ߕߎߝ߭ߊߟߎ߫
      TW:ߕߊߦߌߥߊ߲߫
      TZ:ߕߊ߲ߖ߭ߊߣߌ߫
      UA:ߎ߳ߞߑߙߍߣ
      UG:ߎߜ߭ߊ߲ߘߊ߫
      UM:ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲ ߘߌߣߍ߲߫ ߕߌ߲߫ ߡߊߕߊ߯ߣߍ߲
      UN:ߡߊ߲߬ߕߏ߲߫ ߠߊߘߍ߬ߣߍ߲ ߛߌ߬ߝߏ߲߬ߧߊ߬ߟߌ
      US:ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲
      UY:ߎ߳ߙߑߜ߭ߋߦߌ߫
      UZ:ߎߖ߭ߑߓߋߞߌߛߑߕߊ߲߫
      VA:ߝ߭ߊߕߌߞߊ߲߫ ߞߊ߬ߝߏ
      VC:ߛߍ߲ߕ-ߝ߭ߍߛߊ߲ ߜ߭ߙߋߣߊߘߌ߫
      VE:ߝ߭ߣߋߖ߭ߎߦߋߟߊ߫
      VG:ߓߙߌߕߊ߲ߓߊ߫ ߕߌ߲߫ ߞߊߓߊ߲
      VI:ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲ ߕߌ߲߫ ߞߊߓߊ߲߫
      VN:ߝ߭ߌߦߍߕߑߣߊߡ
      VU:ߝ߭ߊߣߎߦߊߕߎ߫
      WF:ߥߊߟߌߛߌ߫ ߣߌ߫ ߝߕߎߣߊ߫
      WS:ߛߊߡߏߥߊ߫
      XA:ߔߛߏߘߏ߫ ߊߞߑߛߊ߲
      XB:ߔߛߔߘߏ߫-ߓߘߌ߫
      XK:ߞߛߏߝ߭ߏ߫
      YE:ߦߡߊߣߌ߲߫
      YT:ߡߊߦߐߕ
      ZA:ߥߙߏ߬ߘߎ߮ ߝߘߊ߬ߝߌ߲߬ߠߊ߫
      ZM:ߖ߭ߊ߲ߓߌ߫
      ZW:ߖ߭ߌ߲ߓߊߓߏߦߋ߫
      ZZ:ߕߌ߲߬ߞߎߘߎ߲߫ ߕߊ߲߬ߠߊߕߍ߰ߓߊߟߌ
      """.trimIndent() }

  val nso: String by lazy { """
      ZA:Afrika Borwa
      """.trimIndent() }

  val nus: String by lazy { """
      AD:Andora
      AF:Abganithtan
      AG:Antiguaa kɛnɛ Barbuda
      AI:Aŋguɛla
      AL:Albänia
      AM:Aɛrmänia
      AO:Aŋgola
      AR:Aɛrgentin
      AS:Amerika thamow
      AT:Athtɛria
      AU:Athɔra̱lia
      AW:Aruba
      AZ:Adhe̱rbe̱ja̱n
      BA:Bothnia kɛnɛ ɣärgobinia
      BB:Bärbadoth
      BD:Bengeladiec
      BE:Be̱lgim
      BF:Burkinɛ pa̱thu
      BG:Bulga̱a̱ria
      BH:Ba̱reen
      BI:Burundi
      BJ:Be̱ni̱n
      BM:Be̱rmudaa
      BN:Burunɛy
      BO:Bulibia
      BR:Bäraadhiil
      BS:Bämuɔth
      BT:Buta̱n
      BW:Bothiwaana
      BY:Be̱lɛruth
      BZ:Bilidha
      CA:Känɛda
      CF:Cɛntrɔl aprika repuɔblic
      CG:Kɔŋgɔ
      CI:Kodibo̱o̱
      CK:Kuk ɣa̱ylɛn
      CL:Cili̱
      CM:Kɛmɛrun
      CN:Cayna
      CO:Kolombia
      CR:Kothtirika
      CV:Kɛp bedi ɣa̱ylɛn
      DZ:Algeria
      HR:Korwaatia
      KH:Kombodia
      KM:Komruth
      KY:Kaymɛn ɣa̱ylɛn
      SD:Sudan
      TD:Ca̱d
      VG:Burutic dhuɔ̱ɔ̱l be̱rgin
      """.trimIndent() }

  val nyn: String by lazy { """
      AD:Andora
      AE:Amahanga ga Buharabu ageeteereine
      AF:Afuganistani
      AG:Angiguwa na Babuda
      AI:Angwira
      AL:Arubania
      AM:Arimeniya
      AO:Angora
      AR:Arigentina
      AS:Samowa ya Ameerika
      AT:Osituria
      AU:Ositureeriya
      AW:Aruba
      AZ:Azabagyani
      BA:Boziniya na Hezegovina
      BB:Babadosi
      BD:Bangaradeshi
      BE:Bubirigi
      BF:Bokina Faso
      BG:Burugariya
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Berimuda
      BN:Burunei
      BO:Boriiviya
      BR:Buraziiri
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Bararusi
      BZ:Berize
      CA:Kanada
      CD:Demokoratika Ripaaburika ya Kongo
      CF:Eihanga rya Rwagati ya Afirika
      CG:Kongo
      CH:Swisi
      CI:Aivore Kositi
      CK:Ebizinga bya Kuuku
      CL:Chile
      CM:Kameruuni
      CN:China
      CO:Korombiya
      CR:Kositarika
      CU:Cuba
      CV:Ebizinga bya Kepuvade
      CY:Saipurasi
      CZ:Ripaaburika ya Zeeki
      DE:Bugirimaani
      DJ:Gyibuti
      DK:Deenimaaka
      DM:Dominika
      DO:Ripaaburika ya Dominica
      DZ:Arigyeriya
      EC:Ikweda
      EE:Esitoniya
      EG:Misiri
      ER:Eriteriya
      ES:Sipeyini
      ET:Ethiyopiya
      FI:Bufini
      FJ:Figyi
      FK:Ebizinga bya Faakilanda
      FM:Mikironesiya
      FR:Bufaransa
      GA:Gabooni
      GB:Bungyereza
      GD:Gurenada
      GE:Gyogiya
      GF:Guyana ya Bufaransa
      GH:Gana
      GI:Giburaata
      GL:Guriinirandi
      GM:Gambiya
      GN:Gine
      GP:Gwaderupe
      GQ:Guni
      GR:Guriisi
      GT:Gwatemara
      GU:Gwamu
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasiya
      HT:Haiti
      HU:Hangare
      ID:Indoneeziya
      IE:Irerandi
      IL:Isirairi
      IN:Indiya
      IQ:Iraaka
      IR:Iraani
      IS:Aisilandi
      IT:Itare
      JM:Gyamaika
      JO:Yorudaani
      JP:Gyapaani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodiya
      KI:Kiribati
      KM:Koromo
      KN:Senti Kittis na Nevisi
      KP:Koreya Amatemba
      KR:Koreya Amashuuma
      KW:Kuweiti
      KY:Ebizinga bya Kayimani
      KZ:Kazakisitani
      LA:Layosi
      LB:Lebanoni
      LC:Senti Rusiya
      LI:Lishenteni
      LK:Siriranka
      LR:Liberiya
      LS:Lesotho
      LT:Lithuania
      LU:Lakizembaaga
      LV:Latviya
      LY:Libya
      MA:Morocco
      MC:Monaco
      MD:Moridova
      MG:Madagasika
      MH:Ebizinga bya Marshaa
      ML:Mari
      MM:Myanamar
      MN:Mongoria
      MP:Ebizinga by’amatemba ga Mariana
      MQ:Martinique
      MR:Mauriteeniya
      MS:Montserrati
      MT:Marita
      MU:Maurishiasi
      MV:Maridives
      MW:Marawi
      MX:Mexico
      MY:marayizia
      MZ:Mozambique
      NA:Namibiya
      NC:Niukaredonia
      NE:Naigya
      NF:Ekizinga Norifoko
      NG:Naigyeriya
      NI:Nikaragwa
      NL:Hoorandi
      NO:Noorwe
      NP:Nepo
      NR:Nauru
      NU:Niue
      NZ:Niuzirandi
      OM:Omaani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Bufaransa
      PG:Papua
      PH:Firipino
      PK:Pakisitaani
      PL:Poorandi
      PM:Senti Piyerre na Mikweron
      PN:Pitkaini
      PR:Pwetoriko
      PS:Parestiina na Gaza
      PT:Pocugo
      PW:Palaawu
      PY:Paragwai
      QA:Kata
      RE:Riyuniyoni
      RO:Romaniya
      RU:Rrasha
      RW:Rwanda
      SA:Saudi Areebiya
      SB:Ebizinga bya Surimaani
      SC:Shesheresi
      SD:Sudani
      SE:Swideni
      SG:Singapo
      SH:Senti Herena
      SI:Sirovaaniya
      SK:Sirovaakiya
      SL:Sirra Riyooni
      SM:Samarino
      SN:Senego
      SO:Somaariya
      SR:Surinaamu
      ST:Sawo Tome na Purinsipo
      SV:Eri Salivado
      SY:Siriya
      SZ:Swazirandi
      TC:Ebizinga bya Buturuki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tairandi
      TJ:Tajikisitani
      TK:Tokerawu
      TL:Burugweizooba bwa Timori
      TM:Turukimenisitani
      TN:Tunizia
      TO:Tonga
      TR:Buturuki /Take
      TT:Turinidad na Tobago
      TV:Tuvaru
      TW:Tayiwaani
      TZ:Tanzania
      UA:Ukureini
      UG:Uganda
      US:Amerika
      UY:Urugwai
      UZ:Uzibekisitani
      VA:Vatikani
      VC:Senti Vinsent na Gurenadini
      VE:Venezuwera
      VG:Ebizinga bya Virigini ebya Bungyereza
      VI:Ebizinga bya Virigini ebya Amerika
      VN:Viyetinaamu
      VU:Vanuatu
      WF:Warris na Futuna
      WS:Samowa
      YE:Yemeni
      YT:Mayote
      ZA:Sausi Afirika
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val oc: String by lazy { """
      ES:Espanha
      FR:França
      HK:Hong Kong
      """.trimIndent() }

  val oc_ES: String? = null

  val om: String by lazy { """
      001:addunyaa
      002:Afrikaa
      003:Ameerikaa Kaabaa
      005:Ameerikaa Kibbaa
      009:Oshiiniyaa
      011:Afrikaa Dhihaa
      013:Ameerikaa Gidduugaleessaa
      014:Afrikaa Bahaa
      015:Afrikaa Kabaa
      017:Afrikaa Gidduugaleessaa
      018:Kibba Afrikaa
      019:Ameerikaa
      021:Ameerikaa Kaaba
      029:Kariibiyaan
      030:Eeshiyaa Bahaa
      034:Eeshiyaa Kibbaa
      035:Kibba baha Eeshiyaa
      039:Awurooppaa Kibbaa
      053:Awustiralashiyaa
      054:Melaaneeshiyaa
      057:Naannoo Maleeshiyaa
      061:Poolineeshiyaa
      142:Eeshiyaa
      143:Eeshiyaa Gidduugaleessaa
      145:Eeshiyaa Dhihaa
      150:Awurooppaa
      151:Awurooppaa Bahaa
      154:Awurooppaa Kaabaa
      155:Awurooppaa Dhihaa
      202:Afrikaa Sahaaraan Gadii
      419:Laatin Ameerikaa
      AC:Odola Asenshiin
      AD:Andooraa
      AE:Yuunaatid Arab Emereet
      AF:Afgaanistaan
      AG:Antiiguyaa fi Barbuudaa
      AI:Anguyilaa
      AL:Albaaniyaa
      AM:Armeeniyaa
      AO:Angoolaa
      AQ:Antaarkitikaa
      AR:Arjentiinaa
      AS:Saamowa Ameerikaa
      AT:Awustiriyaa
      AU:Awustiraaliyaa
      AW:Arubaa
      AX:Odoloota Alaand
      AZ:Azerbaajiyaan
      BA:Bosiiniyaa fi Herzoogovinaa
      BB:Barbaaros
      BD:Banglaadish
      BE:Beeljiyeem
      BF:Burkiinaa Faasoo
      BG:Bulgaariyaa
      BH:Baahireen
      BI:Burundii
      BJ:Beenii
      BL:St. Barzeleemii
      BM:Beermudaa
      BN:Biruniyee
      BO:Boliiviyaa
      BQ:Neezerlaandota Kariibaan
      BR:Biraazil
      BS:Bahaamas
      BT:Bihuutan
      BV:Odola Bowuvet
      BW:Botosowaanaa
      BY:Beelaarus
      BZ:Belize
      CA:Kanaadaa
      CC:Odoloota Kokos (Keeliing)
      CD:Koongoo - Kinshaasaa
      CF:Rippaablika Afrikaa Gidduugaleessaa
      CG:Koongoo - Biraazaavil
      CH:Siwizerlaand
      CI:Koti divoor
      CK:Odoloota Kuuk
      CL:Chiilii
      CM:Kaameruun
      CN:Chaayinaa
      CO:Kolombiyaa
      CP:Odola Kilippertoo
      CR:Kostaa Rikaa
      CU:Kuubaa
      CV:Keeppi Vaardee
      CW:Kurakowaa
      CX:Odola Kirismaas
      CY:Qoophiroos
      CZ:Cheechiya
      DE:Jarmanii
      DG:Diyeegoo Gaarshiyaa
      DJ:Jibuutii
      DK:Deenmaark
      DM:Dominiikaa
      DO:Dominikaa Rippaabilik
      DZ:Aljeeriyaa
      EA:Kewuta fi Mililaa
      EC:Ekuwaador
      EE:Istooniyaa
      EG:Missir
      EH:Sahaaraa Dhihaa
      ER:Eertiraa
      ES:Ispeen
      ET:Itoophiyaa
      EU:Gamtaa Awurooppaa
      EZ:Zooniiyuuroo
      FI:Fiinlaand
      FJ:Fiijii
      FK:Odoloota Faalklaand
      FM:Maayikirooneeshiyaa
      FO:Odoloota Fafo’ee
      FR:Faransaay
      GA:Gaaboon
      GB:United Kingdom
      GD:Girinaada
      GE:Joorjiyaa
      GF:Faransaay Guyiinaa
      GG:Guwernisey
      GH:Gaanaa
      GI:Gibraaltar
      GL:Giriinlaand
      GM:Gaambiyaa
      GN:Giinii
      GP:Gowadelowape
      GQ:Ikkuwaatooriyaal Giinii
      GR:Giriik
      GS:Joorjikaa Kibba fi Odoloota Saanduwiich Kibbaa
      GT:Guwaatimaalaa
      GU:Guwama
      GW:Giinii-Bisaawoo
      GY:Guyaanaa
      HK:Hoong Koong SAR Chaayinaa
      HM:Odoloota Herdii fi MaakDoonaald
      HN:Hondurus
      HR:Kirooshiyaa
      HT:Haayitii
      HU:Hangaarii
      IC:Odoloota Kanaarii
      ID:Indooneeshiyaa
      IE:Ayeerlaand
      IL:Israa’eel
      IM:Islee oof Maan
      IN:Hindii
      IO:Daangaa Galaana Hindii Biritish
      IQ:Iraaq
      IR:Iraan
      IS:Ayeslaand
      IT:Xaaliyaan
      JE:Jeersii
      JM:Jamaayikaa
      JO:Jirdaan
      JP:Jaappaan
      KE:Keeniyaa
      KG:Kiyirigiyizistan
      KH:Kamboodiyaa
      KI:Kiribaatii
      KM:Komoroos
      KN:St. Kiitis fi Neevis
      KP:Kooriyaa Kaaba
      KR:Kooriyaa Kibbaa
      KW:Kuweet
      KY:Odoloota Saaymaan
      KZ:Kazakistaan
      LA:Laa’oos
      LB:Libaanoon
      LC:St. Suusiyaa
      LI:Lichistensteyin
      LK:Siri Laankaa
      LR:Laayibeeriyaa
      LS:Leseettoo
      LT:Lutaaniyaa
      LU:Luksembarg
      LV:Lativiyaa
      LY:Liibiyaa
      MA:Morookoo
      MC:Moonaakoo
      MD:Moldoovaa
      ME:Montenegiroo
      MF:St. Martiin
      MG:Madagaaskaar
      MH:Odoloota Maarshaal
      MK:Maqdooniyaa Kaabaa
      ML:Maalii
      MM:Maayinaamar (Burma)
      MN:Mongoliyaa
      MO:Maka’oo SAR Chaayinaa
      MP:Odola Maariyaanaa Kaabaa
      MQ:Martinikuwee
      MR:Mawuritaaniyaa
      MS:Montiseerat
      MT:Maaltaa
      MU:Moorishiyees
      MV:Maaldiivs
      MW:Maalaawwii
      MX:Meeksiikoo
      MY:Maleeshiyaa
      MZ:Moozaambik
      NA:Namiibiyaa
      NC:Neewu Kaaleedoniyaa
      NE:Niijer
      NF:Odola Noorfoolk
      NG:Naayijeeriyaa
      NI:Nikaraguwaa
      NL:Neezerlaand
      NO:Noorwey
      NP:Neeppal
      NR:Naawuruu
      NU:Niwu’e
      NZ:Neewu Zilaand
      OM:Omaan
      PA:Paanamaa
      PE:Peeruu
      PF:Polineeshiyaa Faransaay
      PG:Papuwa Neawu Giinii
      PH:Filippiins
      PK:Paakistaan
      PL:Poolaand
      PM:Ql. Piyeeree fi Mikuyelon
      PN:Odoloota Pitikaayirin
      PR:Poortaar Riikoo
      PS:Daangaawwan Paalestaayin
      PT:Poorchugaal
      PW:Palaawu
      PY:Paaraguwaay
      QA:Kuwaatar
      QO:Ooshiiniyaa Alaa
      RE:Riyuuniyeen
      RO:Roomaaniyaa
      RS:Serbiyaa
      RU:Raashiyaa
      RW:Ruwwandaa
      SA:Saawud Arabiyaa
      SB:Odoloota Solomoon
      SC:Siisheels
      SD:Sudaan
      SE:Siwiidin
      SG:Singaapoor
      SH:St. Helenaa
      SI:Islooveeniyaa
      SJ:Isvaalbaard fi Jan Mayeen
      SK:Isloovaakiyaa
      SL:Seeraaliyoon
      SM:Saan Mariinoo
      SN:Senegaal
      SO:Somaaliyaa
      SR:Suriname
      SS:Sudaan Kibbaa
      ST:Sa’oo Toomee fi Prinsippee
      SV:El Salvaadoor
      SX:Siint Maarteen
      SY:Sooriyaa
      SZ:Iswaatinii
      TA:Tiristaan da Kanhaa
      TC:Turkis fi Odoloota Kaayikos
      TD:Chaad
      TF:Daangaawwan Kibbaa Faransaay
      TG:Toogoo
      TH:Taayilaand
      TJ:Tajikistaan
      TK:Tokelau
      TL:Tiimoor-Leestee
      TM:Turkimenistaan
      TN:Tuniiziyaa
      TO:Tonga
      TR:Tarkiye
      TT:Tirinidan fi Tobaagoo
      TV:Tuvalu
      TW:Taayiwwan
      TZ:Taanzaaniyaa
      UA:Yuukireen
      UG:Ugaandaa
      UM:U.S. Odoloota Alaa
      UN:Mootummoota Gamtooman
      US:Yiinaayitid Isteet
      UY:Yuraagaay
      UZ:Uzbeekistaan
      VA:Vaatikaan Siitii
      VC:St. Vinseet fi Gireenadines
      VE:Veenzuweelaa
      VG:Odoloota Varjiin Biritish
      VI:U.S. Odoloota Varjiin
      VN:Veetinaam
      VU:Vanuwaatu
      WF:Waalis fi Futtuuna
      WS:Saamowa
      XA:Loqoda Sobaa
      XB:Biidii Sobaa
      XK:Kosoovoo
      YE:Yemen
      YT:Maayootee
      ZA:Afrikaa Kibbaa
      ZM:Zaambiyaa
      ZW:Zimbaabuwee
      ZZ:Naannoo Hin Beekamne
      """.trimIndent() }

  val om_KE: String? = null

  val or: String by lazy { """
      001:ବିଶ୍ୱ
      002:ଆଫ୍ରିକା
      003:ଉତ୍ତର ଆମେରିକା
      005:ଦକ୍ଷିଣ ଆମେରିକା
      009:ଓସିନିଆ
      011:ପଶ୍ଚିମ ଆଫ୍ରିକା
      013:ମଧ୍ୟ ଆମେରିକା
      014:ପୂର୍ବ ଆଫ୍ରିକା
      015:ଉତ୍ତର ଆଫ୍ରିକା
      017:ମଧ୍ୟ ଆଫ୍ରିକା
      018:ଦକ୍ଷିଣସ୍ଥ ଆଫ୍ରିକା
      019:ଆମେରିକା
      021:ଉତ୍ତରସ୍ଥ ଆମେରିକା
      029:କାରିବିଆନ୍
      030:ପୂର୍ବ ଏସିଆ
      034:ଦକ୍ଷିଣ ଏସିଆ
      035:ଦକ୍ଷିଣପୂର୍ବ ଏସିଆ
      039:ଦକ୍ଷିଣ ୟୁରୋପ୍
      053:ଅଷ୍ଟ୍ରେଲେସିଆ
      054:ମେଲାନେସିଆ
      057:ମାଇକ୍ରୋନେସିଆନ୍ ଅଞ୍ଚଳ
      061:ପଲିନେସିଆ
      142:ଏସିଆ
      143:ମଧ୍ୟ ଏସିଆ
      145:ପଶ୍ଚିମ ଏସିଆ
      150:ୟୁରୋପ୍
      151:ପୂର୍ବ ୟୁରୋପ୍
      154:ଉତ୍ତର ୟୁରୋପ୍
      155:ପଶ୍ଚିମ ୟୁରୋପ୍
      202:ଉପ-ସାହାରା ଆଫ୍ରିକା
      419:ଲାଟିନ୍‌ ଆମେରିକା
      AC:ଆସେନସିଅନ୍‌ ଦ୍ୱୀପ
      AD:ଆଣ୍ଡୋରା
      AE:ସଂଯୁକ୍ତ ଆରବ ଏମିରେଟସ୍
      AF:ଆଫଗାନିସ୍ତାନ୍
      AG:ଆଣ୍ଟିଗୁଆ ଏବଂ ବାରବୁଦା
      AI:ଆଙ୍ଗୁଇଲ୍ଲା
      AL:ଆଲବାନିଆ
      AM:ଆର୍ମେନିଆ
      AO:ଆଙ୍ଗୋଲା
      AQ:ଆଣ୍ଟାର୍କାଟିକା
      AR:ଆର୍ଜେଣ୍ଟିନା
      AS:ଆମେରିକାନ୍ ସାମୋଆ
      AT:ଅଷ୍ଟ୍ରିଆ
      AU:ଅଷ୍ଟ୍ରେଲିଆ
      AW:ଆରୁବା
      AX:ଅଲାଣ୍ଡ ଦ୍ଵୀପପୁଞ୍ଜ
      AZ:ଆଜେରବାଇଜାନ୍
      BA:ବୋସନିଆ ଏବଂ ହର୍ଜଗୋଭିନା
      BB:ବାରବାଡୋସ୍
      BD:ବାଂଲାଦେଶ
      BE:ବେଲଜିୟମ୍
      BF:ବୁର୍କିନା ଫାସୋ
      BG:ବୁଲଗେରିଆ
      BH:ବାହାରିନ୍
      BI:ବୁରୁଣ୍ଡି
      BJ:ବେନିନ୍
      BL:ସେଣ୍ଟ ବାର୍ଥେଲେମି
      BM:ବର୍ମୁଡା
      BN:ବ୍ରୁନେଇ
      BO:ବୋଲିଭିଆ
      BQ:କାରବିୟନ୍‌ ନେଦରଲ୍ୟାଣ୍ଡ
      BR:ବ୍ରାଜିଲ୍
      BS:ବାହାମାସ୍
      BT:ଭୁଟାନ
      BV:ବୌଭେଟ୍‌ ଦ୍ୱୀପ
      BW:ବୋଟସ୍ୱାନା
      BY:ବେଲାରୁଷ୍
      BZ:ବେଲିଜ୍
      CA:କାନାଡା
      CC:କୋକୋସ୍ (କୀଲିଂ) ଦ୍ଵୀପପୁଞ୍ଜ
      CD:କଙ୍ଗୋ (ଡିଆରସି)
      CF:ମଧ୍ୟ ଆଫ୍ରିକୀୟ ସାଧାରଣତନ୍ତ୍ର
      CG:କଙ୍ଗୋ-ବ୍ରାଜିଭିଲ୍ଲେ
      CH:ସ୍ୱିଜରଲ୍ୟାଣ୍ଡ
      CI:କୋତ୍ ଡି ଭ୍ଵାର୍
      CK:କୁକ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ
      CL:ଚିଲି
      CM:କାମେରୁନ୍
      CN:ଚୀନ୍‌
      CO:କଲମ୍ବିଆ
      CP:କ୍ଲିପରଟନ୍‌ ଦ୍ୱୀପ
      CR:କୋଷ୍ଟା ରିକା
      CU:କ‍୍ୟୁବା
      CV:କେପ୍ ଭର୍ଦେ
      CW:କୁରାକାଓ
      CX:ଖ୍ରୀଷ୍ଟମାସ ଦ୍ୱୀପ
      CY:ସାଇପ୍ରସ୍
      CZ:ଚେଚିଆ
      DE:ଜର୍ମାନୀ
      DG:ଡିଏଗୋ ଗାର୍ସିଆ
      DJ:ଜିବୋଟି
      DK:ଡେନମାର୍କ
      DM:ଡୋମିନିକା
      DO:ଡୋମିନିକାନ୍‌ ସାଧାରଣତନ୍ତ୍ର
      DZ:ଆଲଜେରିଆ
      EA:ସିଉଟା ଏବଂ ମେଲିଲା
      EC:ଇକ୍ୱେଡର୍‌
      EE:ଏସ୍ତୋନିଆ
      EG:ଇଜିପ୍ଟ
      EH:ପଶ୍ଚିମ ସାହାରା
      ER:ଇରିଟ୍ରିୟା
      ES:ସ୍ପେନ୍
      ET:ଇଥିଓପିଆ
      EU:ୟୁରୋପୀୟ ସଂଘ
      EZ:ୟୁରୋକ୍ଷେତ୍ର
      FI:ଫିନଲ୍ୟାଣ୍ଡ
      FJ:ଫିଜି
      FK:ଫକ୍‌ଲ୍ୟାଣ୍ଡ ଦ୍ଵୀପପୁଞ୍ଜ
      FM:ମାଇକ୍ରୋନେସିଆ
      FO:ଫାରୋଇ ଦ୍ୱୀପପୁଞ୍ଜ
      FR:ଫ୍ରାନ୍ସ
      GA:ଗାବୋନ୍
      GB:ଯୁକ୍ତରାଜ୍ୟ
      GD:ଗ୍ରେନାଡା
      GE:ଜର୍ଜିଆ
      GF:ଫ୍ରେଞ୍ଚ ଗୁଇନା
      GG:ଗୁଏରନେସି
      GH:ଘାନା
      GI:ଜିବ୍ରାଲ୍ଟର୍
      GL:ଗ୍ରୀନଲ୍ୟାଣ୍ଡ
      GM:ଗାମ୍ବିଆ
      GN:ଗୁଇନିଆ
      GP:ଗୁଆଡେଲୋପ୍
      GQ:ଇକ୍ବାଟୋରିଆଲ୍ ଗୁଇନିଆ
      GR:ଗ୍ରୀସ୍
      GS:ଦକ୍ଷିଣ ଜର୍ଜିଆ ଏବଂ ଦକ୍ଷିଣ ସାଣ୍ଡୱିଚ୍ ଦ୍ୱୀପପୁଞ୍ଜ
      GT:ଗୁଏତମାଲା
      GU:ଗୁଆମ୍
      GW:ଗୁଇନିଆ-ବିସାଉ
      GY:ଗୁଇନା
      HK:ହଂ କଂ ଏସଏଆର୍‌ ଚାଇନା
      HM:ହାର୍ଡ୍‌ ଏବଂ ମ୍ୟାକଡୋନାଲ୍ଡ ଦ୍ୱୀପପୁଞ୍ଜ
      HN:ହୋଣ୍ଡୁରାସ୍‌
      HR:କ୍ରୋଏସିଆ
      HT:ହାଇତି
      HU:ହଙ୍ଗେରୀ
      IC:କେନେରୀ ଦ୍ୱୀପପୁଞ୍ଜ
      ID:ଇଣ୍ଡୋନେସିଆ
      IE:ଆୟରଲ୍ୟାଣ୍ଡ
      IL:ଇସ୍ରାଏଲ୍
      IM:ଆଇଲ୍‌ ଅଫ୍‌ ମ୍ୟାନ୍‌
      IN:ଭାରତ
      IO:ବ୍ରିଟିଶ୍‌ ଭାରତୀୟ ମହାସାଗର କ୍ଷେତ୍ର
      IQ:ଇରାକ୍
      IR:ଇରାନ
      IS:ଆଇସଲ୍ୟାଣ୍ଡ
      IT:ଇଟାଲୀ
      JE:ଜର୍ସି
      JM:ଜାମାଇକା
      JO:ଜୋର୍ଡାନ୍
      JP:ଜାପାନ
      KE:କେନିୟା
      KG:କିର୍ଗିଜିସ୍ତାନ
      KH:କାମ୍ବୋଡିଆ
      KI:କିରିବାଟି
      KM:କୋମୋରସ୍
      KN:ସେଣ୍ଟ କିଟସ୍‌ ଏବଂ ନେଭିସ୍‌
      KP:ଉତ୍ତର କୋରିଆ
      KR:ଦକ୍ଷିଣ କୋରିଆ
      KW:କୁଏତ୍
      KY:କେମ୍ୟାନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ
      KZ:କାଜାଖସ୍ତାନ୍‌
      LA:ଲାଓସ୍
      LB:ଲେବାନନ୍
      LC:ସେଣ୍ଟ ଲୁସିଆ
      LI:ଲିକ୍ଟନ୍‌ଷ୍ଟାଇନ୍‌
      LK:ଶ୍ରୀଲଙ୍କା
      LR:ଲାଇବେରିଆ
      LS:ଲେସୋଥୋ
      LT:ଲିଥୁଆନିଆ
      LU:ଲକ୍ସେମବର୍ଗ
      LV:ଲାଟଭିଆ
      LY:ଲିବ୍ୟା
      MA:ମୋରୋକ୍କୋ
      MC:ମୋନାକୋ
      MD:ମୋଲଡୋଭା
      ME:ମଣ୍ଟେନିଗ୍ରୋ
      MF:ସେଣ୍ଟ ମାର୍ଟିନ୍
      MG:ମାଡାଗାସ୍କର୍
      MH:ମାର୍ଶାଲ୍ ଦ୍ୱୀପପୁଞ୍ଜ
      MK:ଉତ୍ତର ମାସେଡୋନିଆ
      ML:ମାଲି
      MM:ମିଆଁମାର
      MN:ମଙ୍ଗୋଲିଆ
      MO:ମାକାଉ ଏସଏଆର୍‌ ଚାଇନା
      MP:ଉତ୍ତର ମାରିଆନା ଦ୍ୱୀପପୁଞ୍ଜ
      MQ:ମାର୍ଟିନିକ୍ୟୁ
      MR:ମୌରିଟାନିଆ
      MS:ମଣ୍ଟେସେରାଟ୍
      MT:ମାଲ୍ଟା
      MU:ମରିସସ
      MV:ମାଲଦିଭସ୍‌
      MW:ମାଲୱି
      MX:ମେକ୍ସିକୋ
      MY:ମାଲେସିଆ
      MZ:ମୋଜାମ୍ବିକ୍‌
      NA:ନାମିବିଆ
      NC:ନୂତନ କାଲେଡୋନିଆ
      NE:ନାଇଜର
      NF:ନର୍ଫକ୍ ଦ୍ଵୀପ
      NG:ନାଇଜେରିଆ
      NI:ନିକାରାଗୁଆ
      NL:ନେଦରଲ୍ୟାଣ୍ଡ
      NO:ନରୱେ
      NP:ନେପାଳ
      NR:ନାଉରୁ
      NU:ନିଉ
      NZ:ନ୍ୟୁଜିଲାଣ୍ଡ
      OM:ଓମାନ୍
      PA:ପାନାମା
      PE:ପେରୁ
      PF:ଫ୍ରେଞ୍ଚ ପଲିନେସିଆ
      PG:ପପୁଆ ନ୍ୟୁ ଗିନି
      PH:ଫିଲିପାଇନସ୍
      PK:ପାକିସ୍ତାନ
      PL:ପୋଲାଣ୍ଡ
      PM:ସେଣ୍ଟ ପିଏରେ ଏବଂ ମିକ୍ୱେଲନ୍‌
      PN:ପିଟକାଇରିନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ
      PR:ପୁଏର୍ତ୍ତୋ ରିକୋ
      PS:ପାଲେଷ୍ଟେନିୟ ଭୂଭାଗ
      PT:ପର୍ତ୍ତୁଗାଲ୍
      PW:ପାଲାଉ
      PY:ପାରାଗୁଏ
      QA:କତାର୍
      QO:ସୀମାନ୍ତବର୍ତ୍ତୀ ଓସିନିଆ
      RE:ରିୟୁନିଅନ୍
      RO:ରୋମାନିଆ
      RS:ସର୍ବିଆ
      RU:ରୁଷିଆ
      RW:ରାୱାଣ୍ଡା
      SA:ସାଉଦି ଆରବିଆ
      SB:ସୋଲୋମନ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ
      SC:ସେଚେଲସ୍
      SD:ସୁଦାନ
      SE:ସ୍ୱିଡେନ୍‌
      SG:ସିଙ୍ଗାପୁର୍
      SH:ସେଣ୍ଟ ହେଲେନା
      SI:ସ୍ଲୋଭେନିଆ
      SJ:ସାଲବାର୍ଡ ଏବଂ ଜାନ୍‌ ମାୟେନ୍‌
      SK:ସ୍ଲୋଭାକିଆ
      SL:ସିଏରା ଲିଓନ
      SM:ସାନ୍ ମାରିନୋ
      SN:ସେନେଗାଲ୍
      SO:ସୋମାଲିଆ
      SR:ସୁରିନାମ
      SS:ଦକ୍ଷିଣ ସୁଦାନ
      ST:ସାଓ ଟୋମେ ଏବଂ ପ୍ରିନସିପି
      SV:ଏଲ୍ ସାଲଭାଡୋର୍
      SX:ସିଣ୍ଟ ମାର୍ଟୀନ୍‌
      SY:ସିରିଆ
      SZ:ଇସ୍ୱାତିନୀ
      TA:ଟ୍ରାଇଷ୍ଟନ୍‌ ଦା କୁନ୍‌ଚା
      TC:ତୁର୍କସ୍‌ ଏବଂ କାଇକୋସ୍‌ ଦ୍ୱୀପପୁଞ୍ଜ
      TD:ଚାଦ୍
      TF:ଫରାସୀ ଦକ୍ଷିଣ କ୍ଷେତ୍ର
      TG:ଟୋଗୋ
      TH:ଥାଇଲ୍ୟାଣ୍ଡ
      TJ:ତାଜିକିସ୍ଥାନ୍
      TK:ଟୋକେଲାଉ
      TL:ତିମୋର୍-ଲେଷ୍ଟେ
      TM:ତୁର୍କମେନିସ୍ତାନ
      TN:ଟ୍ୟୁନିସିଆ
      TO:ଟୋଙ୍ଗା
      TR:ତୁର୍କୀ
      TT:ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ
      TV:ତୁଭାଲୁ
      TW:ତାଇୱାନ
      TZ:ତାଞ୍ଜାନିଆ
      UA:ୟୁକ୍ରେନ୍
      UG:ଉଗାଣ୍ଡା
      UM:ଯୁକ୍ତରାଷ୍ଟ୍ର ଆଉଟ୍‌ଲାଇଙ୍ଗ ଦ୍ଵୀପପୁଞ୍ଜ
      UN:ଜାତିସଂଘ
      US:ଯୁକ୍ତ ରାଷ୍ଟ୍ର
      UY:ଉରୁଗୁଏ
      UZ:ଉଜବେକିସ୍ତାନ
      VA:ଭାଟିକାନ୍ ସିଟି
      VC:ସେଣ୍ଟ ଭିନସେଣ୍ଟ ଏବଂ ଗ୍ରେନାଡାଇନ୍ସ
      VE:ଭେନେଜୁଏଲା
      VG:ବ୍ରିଟିଶ୍‌ ଭର୍ଜିନ୍ ଦ୍ୱୀପପୁଞ୍ଜ
      VI:ଯୁକ୍ତରାଷ୍ଟ୍ର ଭର୍ଜିନ୍ ଦ୍ଵୀପପୁଞ୍ଜ
      VN:ଭିଏତନାମ୍
      VU:ଭାନୁଆତୁ
      WF:ୱାଲିସ୍ ଏବଂ ଫୁତୁନା
      WS:ସାମୋଆ
      XA:ସିୟୁଡୋ-ଏସେଣ୍ଟ
      XB:ସିୟୁଡୋ-ବିଡି
      XK:କୋସୋଭୋ
      YE:ୟେମେନ୍
      YT:ମାୟୋଟେ
      ZA:ଦକ୍ଷିଣ ଆଫ୍ରିକା
      ZM:ଜାମ୍ବିଆ
      ZW:ଜିମ୍ବାୱେ
      ZZ:ଅଜଣା ଅଞ୍ଚଳ
      """.trimIndent() }

  val os: String by lazy { """
      001:Дуне
      002:Африкӕ
      009:Океани
      019:Америкӕ
      142:Ази
      150:Европӕ
      BR:Бразили
      CN:Китай
      DE:Герман
      FR:Франц
      GB:Стыр Британи
      GE:Гуырдзыстон
      IN:Инди
      IT:Итали
      JP:Япон
      RU:Уӕрӕсе
      US:АИШ
      ZZ:Нӕзонгӕ бӕстӕ
      """.trimIndent() }

  val os_RU: String? = null

  val osa: String by lazy { """
      US:United States
      """.trimIndent() }

  val pa: String by lazy { """
      001:ਸੰਸਾਰ
      002:ਅਫ਼ਰੀਕਾ
      003:ਉੱਤਰ ਅਮਰੀਕਾ
      005:ਦੱਖਣ ਅਮਰੀਕਾ
      009:ਓਸ਼ੇਨੀਆ
      011:ਪੱਛਮੀ ਅਫ਼ਰੀਕਾ
      013:ਕੇਂਦਰੀ ਅਮਰੀਕਾ
      014:ਪੂਰਬੀ ਅਫ਼ਰੀਕਾ
      015:ਉੱਤਰੀ ਅਫ਼ਰੀਕਾ
      017:ਮੱਧ ਅਫ਼ਰੀਕਾ
      018:ਦੱਖਣੀ ਅਫ਼ਰੀਕਾ
      019:ਅਮਰੀਕਾ
      021:ਉੱਤਰੀ ਅਮਰੀਕਾ
      029:ਕੈਰੇਬੀਆਈ
      030:ਪੂਰਬੀ ਏਸ਼ੀਆ
      034:ਦੱਖਣੀ ਏਸ਼ੀਆ
      035:ਦੱਖਣ-ਪੂਰਬੀ ਏਸ਼ੀਆ
      039:ਦੱਖਣੀ ਯੂਰਪ
      053:ਆਸਟਰੇਲੇਸ਼ੀਆ
      054:ਮੇਲਾਨੇਸ਼ੀਆ
      057:ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆਈ ਇਲਾਕਾ
      061:ਪੋਲੀਨੇਸ਼ੀਆ
      142:ਏਸ਼ੀਆ
      143:ਕੇਂਦਰੀ ਏਸ਼ੀਆ
      145:ਪੱਛਮੀ ਏਸ਼ੀਆ
      150:ਯੂਰਪ
      151:ਪੂਰਬੀ ਯੂਰਪ
      154:ਉੱਤਰੀ ਯੂਰਪ
      155:ਪੱਛਮੀ ਯੂਰਪ
      202:ਉਪ-ਸਹਾਰਾ ਅਫ਼ਰੀਕਾ
      419:ਲਾਤੀਨੀ ਅਮਰੀਕਾ
      AC:ਅਸੈਂਸ਼ਨ ਟਾਪੂ
      AD:ਅੰਡੋਰਾ
      AE:ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ
      AF:ਅਫ਼ਗਾਨਿਸਤਾਨ
      AG:ਐਂਟੀਗੁਆ ਅਤੇ ਬਾਰਬੁਡਾ
      AI:ਅੰਗੁਇਲਾ
      AL:ਅਲਬਾਨੀਆ
      AM:ਅਰਮੀਨੀਆ
      AO:ਅੰਗੋਲਾ
      AQ:ਅੰਟਾਰਕਟਿਕਾ
      AR:ਅਰਜਨਟੀਨਾ
      AS:ਅਮੈਰੀਕਨ ਸਮੋਆ
      AT:ਆਸਟਰੀਆ
      AU:ਆਸਟ੍ਰੇਲੀਆ
      AW:ਅਰੂਬਾ
      AX:ਅਲੈਂਡ ਟਾਪੂ
      AZ:ਅਜ਼ਰਬਾਈਜਾਨ
      BA:ਬੋਸਨੀਆ ਅਤੇ ਹਰਜ਼ੇਗੋਵੀਨਾ
      BB:ਬਾਰਬਾਡੋਸ
      BD:ਬੰਗਲਾਦੇਸ਼
      BE:ਬੈਲਜੀਅਮ
      BF:ਬੁਰਕੀਨਾ ਫ਼ਾਸੋ
      BG:ਬੁਲਗਾਰੀਆ
      BH:ਬਹਿਰੀਨ
      BI:ਬੁਰੁੰਡੀ
      BJ:ਬੇਨਿਨ
      BL:ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ
      BM:ਬਰਮੂਡਾ
      BN:ਬਰੂਨੇਈ
      BO:ਬੋਲੀਵੀਆ
      BQ:ਕੈਰੇਬੀਆਈ ਨੀਦਰਲੈਂਡ
      BR:ਬ੍ਰਾਜ਼ੀਲ
      BS:ਬਹਾਮਾਸ
      BT:ਭੂਟਾਨ
      BV:ਬੌਵੇਟ ਟਾਪੂ
      BW:ਬੋਤਸਵਾਨਾ
      BY:ਬੇਲਾਰੂਸ
      BZ:ਬੇਲੀਜ਼
      CA:ਕੈਨੇਡਾ
      CC:ਕੋਕੋਸ (ਕੀਲਿੰਗ) ਟਾਪੂ
      CD:ਕਾਂਗੋ - ਕਿੰਸ਼ਾਸਾ
      CF:ਕੇਂਦਰੀ ਅਫ਼ਰੀਕੀ ਗਣਰਾਜ
      CG:ਕਾਂਗੋ - ਬ੍ਰਾਜ਼ਾਵਿਲੇ
      CH:ਸਵਿਟਜ਼ਰਲੈਂਡ
      CI:ਕੋਟ ਡੀਵੋਆਰ
      CK:ਕੁੱਕ ਟਾਪੂ
      CL:ਚਿਲੀ
      CM:ਕੈਮਰੂਨ
      CN:ਚੀਨ
      CO:ਕੋਲੰਬੀਆ
      CP:ਕਲਿੱਪਰਟਨ ਟਾਪੂ
      CR:ਕੋਸਟਾ ਰੀਕਾ
      CU:ਕਿਊਬਾ
      CV:ਕੇਪ ਵਰਡੇ
      CW:ਕੁਰਾਕਾਓ
      CX:ਕ੍ਰਿਸਮਿਸ ਟਾਪੂ
      CY:ਸਾਇਪ੍ਰਸ
      CZ:ਚੈਕੀਆ
      DE:ਜਰਮਨੀ
      DG:ਡੀਇਗੋ ਗਾਰਸੀਆ
      DJ:ਜਿਬੂਤੀ
      DK:ਡੈਨਮਾਰਕ
      DM:ਡੋਮੀਨਿਕਾ
      DO:ਡੋਮੀਨਿਕਾਈ ਗਣਰਾਜ
      DZ:ਅਲਜੀਰੀਆ
      EA:ਸਿਓਟਾ ਅਤੇ ਮੇਲਿੱਲਾ
      EC:ਇਕਵੇਡੋਰ
      EE:ਇਸਟੋਨੀਆ
      EG:ਮਿਸਰ
      EH:ਪੱਛਮੀ ਸਹਾਰਾ
      ER:ਇਰੀਟ੍ਰਿਆ
      ES:ਸਪੇਨ
      ET:ਇਥੋਪੀਆ
      EU:ਯੂਰਪੀ ਸੰਘ
      EZ:ਯੂਰੋਜ਼ੋਨ
      FI:ਫਿਨਲੈਂਡ
      FJ:ਫ਼ਿਜੀ
      FK:ਫ਼ਾਕਲੈਂਡ ਟਾਪੂ
      FM:ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆ
      FO:ਫੈਰੋ ਟਾਪੂ
      FR:ਫ਼ਰਾਂਸ
      GA:ਗਬੋਨ
      GB:ਯੂਨਾਈਟਡ ਕਿੰਗਡਮ
      GD:ਗ੍ਰੇਨਾਡਾ
      GE:ਜਾਰਜੀਆ
      GF:ਫਰੈਂਚ ਗੁਇਆਨਾ
      GG:ਗਰਨਜੀ
      GH:ਘਾਨਾ
      GI:ਜਿਬਰਾਲਟਰ
      GL:ਗ੍ਰੀਨਲੈਂਡ
      GM:ਗੈਂਬੀਆ
      GN:ਗਿਨੀ
      GP:ਗੁਆਡੇਲੋਪ
      GQ:ਭੂ-ਖੰਡੀ ਗਿਨੀ
      GR:ਗ੍ਰੀਸ
      GS:ਦੱਖਣੀ ਜਾਰਜੀਆ ਅਤੇ ਦੱਖਣੀ ਸੈਂਡਵਿਚ ਟਾਪੂ
      GT:ਗੁਆਟੇਮਾਲਾ
      GU:ਗੁਆਮ
      GW:ਗਿਨੀ-ਬਿਸਾਉ
      GY:ਗੁਯਾਨਾ
      HK:ਹਾਂਗ ਕਾਂਗ ਐਸਏਆਰ ਚੀਨ
      HM:ਹਰਡ ਤੇ ਮੈਕਡੋਨਾਲਡ ਟਾਪੂ
      HN:ਹੋਂਡੁਰਸ
      HR:ਕਰੋਏਸ਼ੀਆ
      HT:ਹੈਤੀ
      HU:ਹੰਗਰੀ
      IC:ਕੇਨਾਰੀ ਟਾਪੂ
      ID:ਇੰਡੋਨੇਸ਼ੀਆ
      IE:ਆਇਰਲੈਂਡ
      IL:ਇਜ਼ਰਾਈਲ
      IM:ਆਇਲ ਆਫ ਮੈਨ
      IN:ਭਾਰਤ
      IO:ਬਰਤਾਨਵੀ ਹਿੰਦ ਮਹਾਂਸਾਗਰ ਖਿੱਤਾ
      IQ:ਇਰਾਕ
      IR:ਈਰਾਨ
      IS:ਆਈਸਲੈਂਡ
      IT:ਇਟਲੀ
      JE:ਜਰਸੀ
      JM:ਜਮਾਇਕਾ
      JO:ਜਾਰਡਨ
      JP:ਜਪਾਨ
      KE:ਕੀਨੀਆ
      KG:ਕਿਰਗਿਜ਼ਸਤਾਨ
      KH:ਕੰਬੋਡੀਆ
      KI:ਕਿਰਬਾਤੀ
      KM:ਕੋਮੋਰੋਸ
      KN:ਸੇਂਟ ਕਿਟਸ ਐਂਡ ਨੇਵਿਸ
      KP:ਉੱਤਰ ਕੋਰੀਆ
      KR:ਦੱਖਣ ਕੋਰੀਆ
      KW:ਕੁਵੈਤ
      KY:ਕੇਮੈਨ ਟਾਪੂ
      KZ:ਕਜ਼ਾਖਸਤਾਨ
      LA:ਲਾਓਸ
      LB:ਲੈਬਨਾਨ
      LC:ਸੇਂਟ ਲੂਸੀਆ
      LI:ਲਿਚੇਂਸਟਾਇਨ
      LK:ਸ੍ਰੀ ਲੰਕਾ
      LR:ਲਾਈਬੀਰੀਆ
      LS:ਲੇਸੋਥੋ
      LT:ਲਿਥੁਆਨੀਆ
      LU:ਲਕਜ਼ਮਬਰਗ
      LV:ਲਾਤਵੀਆ
      LY:ਲੀਬੀਆ
      MA:ਮੋਰੱਕੋ
      MC:ਮੋਨਾਕੋ
      MD:ਮੋਲਡੋਵਾ
      ME:ਮੋਂਟੇਨੇਗਰੋ
      MF:ਸੇਂਟ ਮਾਰਟਿਨ
      MG:ਮੈਡਾਗਾਸਕਰ
      MH:ਮਾਰਸ਼ਲ ਟਾਪੂ
      MK:ਉੱਤਰੀ ਮੈਕਡੋਨੀਆ
      ML:ਮਾਲੀ
      MM:ਮਿਆਂਮਾਰ (ਬਰਮਾ)
      MN:ਮੰਗੋਲੀਆ
      MO:ਮਕਾਉ ਐਸਏਆਰ ਚੀਨ
      MP:ਉੱਤਰੀ ਮਾਰੀਆਨਾ ਟਾਪੂ
      MQ:ਮਾਰਟੀਨਿਕ
      MR:ਮੋਰਿਟਾਨੀਆ
      MS:ਮੋਂਟਸੇਰਾਤ
      MT:ਮਾਲਟਾ
      MU:ਮੌਰੀਸ਼ਸ
      MV:ਮਾਲਦੀਵ
      MW:ਮਲਾਵੀ
      MX:ਮੈਕਸੀਕੋ
      MY:ਮਲੇਸ਼ੀਆ
      MZ:ਮੋਜ਼ਾਮਬੀਕ
      NA:ਨਾਮੀਬੀਆ
      NC:ਨਿਊ ਕੈਲੇਡੋਨੀਆ
      NE:ਨਾਈਜਰ
      NF:ਨੋਰਫੌਕ ਟਾਪੂ
      NG:ਨਾਈਜੀਰੀਆ
      NI:ਨਿਕਾਰਾਗੁਆ
      NL:ਨੀਦਰਲੈਂਡ
      NO:ਨਾਰਵੇ
      NP:ਨੇਪਾਲ
      NR:ਨਾਉਰੂ
      NU:ਨਿਯੂ
      NZ:ਨਿਊਜ਼ੀਲੈਂਡ
      OM:ਓਮਾਨ
      PA:ਪਨਾਮਾ
      PE:ਪੇਰੂ
      PF:ਫਰੈਂਚ ਪੋਲੀਨੇਸ਼ੀਆ
      PG:ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ
      PH:ਫਿਲੀਪੀਨਜ
      PK:ਪਾਕਿਸਤਾਨ
      PL:ਪੋਲੈਂਡ
      PM:ਸੇਂਟ ਪੀਅਰੇ ਐਂਡ ਮਿਕੇਲਨ
      PN:ਪਿਟਕੇਰਨ ਟਾਪੂ
      PR:ਪਿਊਰਟੋ ਰਿਕੋ
      PS:ਫਿਲੀਸਤੀਨੀ ਇਲਾਕਾ
      PT:ਪੁਰਤਗਾਲ
      PW:ਪਲਾਉ
      PY:ਪੈਰਾਗਵੇ
      QA:ਕਤਰ
      QO:ਆਊਟਲਾਇੰਗ ਓਸ਼ੀਨੀਆ
      RE:ਰਿਯੂਨੀਅਨ
      RO:ਰੋਮਾਨੀਆ
      RS:ਸਰਬੀਆ
      RU:ਰੂਸ
      RW:ਰਵਾਂਡਾ
      SA:ਸਾਊਦੀ ਅਰਬ
      SB:ਸੋਲੋਮਨ ਟਾਪੂ
      SC:ਸੇਸ਼ਲਸ
      SD:ਸੂਡਾਨ
      SE:ਸਵੀਡਨ
      SG:ਸਿੰਗਾਪੁਰ
      SH:ਸੇਂਟ ਹੇਲੇਨਾ
      SI:ਸਲੋਵੇਨੀਆ
      SJ:ਸਵਾਲਬਰਡ ਅਤੇ ਜਾਨ ਮਾਯੇਨ
      SK:ਸਲੋਵਾਕੀਆ
      SL:ਸਿਏਰਾ ਲਿਓਨ
      SM:ਸੈਨ ਮਰੀਨੋ
      SN:ਸੇਨੇਗਲ
      SO:ਸੋਮਾਲੀਆ
      SR:ਸੂਰੀਨਾਮ
      SS:ਦੱਖਣ ਸੁਡਾਨ
      ST:ਸਾਓ ਟੋਮ ਅਤੇ ਪ੍ਰਿੰਸੀਪੇ
      SV:ਅਲ ਸਲਵਾਡੋਰ
      SX:ਸਿੰਟ ਮਾਰਟੀਨ
      SY:ਸੀਰੀਆ
      SZ:ਇਸਵਾਤੀਨੀ
      TA:ਟ੍ਰਿਸਟਾਨ ਦਾ ਕੁੰਹਾ
      TC:ਟੁਰਕਸ ਅਤੇ ਕੈਕੋਸ ਟਾਪੂ
      TD:ਚਾਡ
      TF:ਫਰੈਂਚ ਦੱਖਣੀ ਪ੍ਰਦੇਸ਼
      TG:ਟੋਗੋ
      TH:ਥਾਈਲੈਂਡ
      TJ:ਤਾਜਿਕਿਸਤਾਨ
      TK:ਟੋਕੇਲਾਉ
      TL:ਤਿਮੋਰ-ਲੇਸਤੇ
      TM:ਤੁਰਕਮੇਨਿਸਤਾਨ
      TN:ਟਿਊਨੀਸ਼ੀਆ
      TO:ਟੌਂਗਾ
      TR:ਤੁਰਕੀ
      TT:ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ
      TV:ਟੁਵਾਲੂ
      TW:ਤਾਇਵਾਨ
      TZ:ਤਨਜ਼ਾਨੀਆ
      UA:ਯੂਕਰੇਨ
      UG:ਯੂਗਾਂਡਾ
      UM:ਯੂ.ਐੱਸ. ਦੂਰ-ਦੁਰਾਡੇ ਟਾਪੂ
      UN:ਸੰਯੁਕਤ ਰਾਸ਼ਟਰ
      US:ਸੰਯੁਕਤ ਰਾਜ
      UY:ਉਰੂਗਵੇ
      UZ:ਉਜ਼ਬੇਕਿਸਤਾਨ
      VA:ਵੈਟੀਕਨ ਸਿਟੀ
      VC:ਸੇਂਟ ਵਿਨਸੈਂਟ ਐਂਡ ਗ੍ਰੇਨਾਡੀਨਸ
      VE:ਵੇਨੇਜ਼ੂਏਲਾ
      VG:ਬ੍ਰਿਟਿਸ਼ ਵਰਜਿਨ ਟਾਪੂ
      VI:ਯੂ ਐੱਸ ਵਰਜਿਨ ਟਾਪੂ
      VN:ਵੀਅਤਨਾਮ
      VU:ਵਾਨੂਆਟੂ
      WF:ਵਾਲਿਸ ਅਤੇ ਫੂਟੂਨਾ
      WS:ਸਾਮੋਆ
      XA:ਗਲਤ-ਉਚਾਰਨ
      XB:ਲਿਖਤ ਦੀ ਗਲਤ ਦਿਸ਼ਾ
      XK:ਕੋਸੋਵੋ
      YE:ਯਮਨ
      YT:ਮਾਯੋਟੀ
      ZA:ਦੱਖਣੀ ਅਫਰੀਕਾ
      ZM:ਜ਼ਾਮਬੀਆ
      ZW:ਜ਼ਿੰਬਾਬਵੇ
      ZZ:ਅਣਪਛਾਤਾ ਇਲਾਕਾ
      """.trimIndent() }

  val pa_Arab: String by lazy { """
      PK:پاکستان
      """.trimIndent() }

  val pa_Guru: String? = null

  val pap: String by lazy { """
      CW:Kòrsou
      """.trimIndent() }

  val pap_AW: String? = null

  val pcm: String by lazy { """
      001:Wọld
      002:Áfríka
      003:Nọ́t Amẹ́ríka
      005:Saút Amẹ́ríka
      009:Oshẹnia
      011:Wẹ́stán Áfríka
      013:Mídúl Amẹ́ríka
      014:Ístán Áfríká
      015:Nọ́tán Áfríka
      017:Mídúl Áfríka
      018:Saútán Áfríka
      019:Amẹ́ríkas
      021:Nọ́tán Amẹ́ríka
      029:Karíbián
      030:Ístán Éshia
      034:Saútán Éshia
      035:Saútíst Éshiá
      039:Saútán Yúrop
      053:Ọstraléshia
      054:Mẹlanẹíshia
      057:Maikroníshia Ríjọn
      061:Poliníshiá
      142:Éshia
      143:Mídúl Éshia
      145:Wẹ́stán Éshia
      150:Yúrop
      151:Ístán Yúrop
      154:Nọ́tán Yúrop
      155:Wẹ́stán Yúrop
      202:Áfríka Éria Biló Sahára
      419:Látín Amẹ́ríka
      AC:Asẹ́nshọ́n Aíland
      AD:Andọ́ra
      AE:Yunaítẹ́d Áráb Ẹ́mírets
      AF:Afgánístan
      AG:Antígwua & Barbúda
      AI:Angwíla
      AL:Albénia
      AM:Armẹ́niá
      AO:Angóla
      AQ:Antáktíka
      AR:Ajẹntína
      AS:Amẹ́ríká Samoa
      AT:Ọ́stria
      AU:Ọstrélia
      AW:Arúba
      AX:Ọ́lánd Aílands
      AZ:Azẹrbaijan
      BA:Bọ́zniá & Hẹzẹgovína
      BB:Barbédọs
      BD:Bangladẹsh
      BE:Bẹ́ljọm
      BF:Burkína Fáso
      BG:Bọlgéria
      BH:Barein
      BI:Burúndi
      BJ:Binin
      BL:Sént Batẹlẹ́mi
      BM:Bẹmiúda
      BN:Brunẹi
      BO:Bolívia
      BQ:Karíbián Nẹ́dalands
      BR:Brázil
      BS:Bahámas
      BT:Butan
      BV:Buvẹ́ Aíland
      BW:Botswána
      BY:Bẹ́larus
      BZ:Bẹliz
      CA:Kánáda
      CC:Kókós Aílands
      CD:Kóngó – Kinshása
      CF:Sẹ́ntrál Áfríkán Ripọ́blik
      CG:Kóngo – Brázavil
      CH:Swítsaland
      CI:Aívri Kost
      CK:Kúk Aílands
      CL:Chílẹ
      CM:Kamẹrun
      CN:Chaína
      CO:Kolómbia
      CP:Klipatọ́n Aíland
      CR:Kósta Ríka
      CU:Kiúbá
      CV:Kép Vẹ́d
      CW:Kiurásao
      CX:Krísmás Aíland
      CY:Saíprọs
      CZ:Chẹ́kia
      DE:Jámáni
      DG:Diẹ́gó Garsia
      DJ:Jibúti
      DK:Dẹ́nmak
      DM:Dọmíníka
      DO:Dọmíníka Ripọ́blik
      DZ:Aljíria
      EA:Sẹúta & Mẹ́líla
      EC:Ẹ́kwuádọ
      EE:Ẹstónia
      EG:Íjipt
      EH:Wẹ́stán Sahára
      ER:Ẹritrẹ́a
      ES:Spen
      ET:Ẹtiópia
      EU:Yurópián Yúniọ́n
      EZ:Yúróéria
      FI:Fínland
      FJ:Fíji
      FK:Fọ́klánd Aílands
      FM:Maikroníshia
      FO:Fáro Aílands
      FR:Frans
      GA:Gabọn
      GB:Yunáítẹ́d Kíndọm
      GD:Grẹnéda
      GE:Jọ́jia
      GF:Frẹ́nch Giána
      GG:Guẹnzi
      GH:Gána
      GI:Jibrọ́lta
      GL:Grínland
      GM:Gámbia
      GN:Gíni
      GP:Guadalúpẹ
      GQ:Ikwétóriál Gíni
      GR:Gris
      GS:Saút Jọ́jia an Saút Sándwích Aílands
      GT:Guátẹmála
      GU:Guám
      GW:Gíní-Bisáu
      GY:Gayána
      HK:Họng Kọng SAR
      HM:Hiád & MakDónáld Aílands
      HN:Họndúras
      HR:Kroéshia
      HT:Haíti
      HU:Họ́ngári
      IC:Kenerí Aílands
      ID:Indoníshia
      IE:Ayaland
      IL:Ízrẹl
      IM:Aíl ọf Man
      IN:Índia
      IO:Brítísh Índián Óshen Tẹ́rẹ́tri
      IQ:Irak
      IR:Irán
      IS:Aísland
      IT:Ítáli
      JE:Jẹ́si
      JM:Jamaíka
      JO:Jọ́dan
      JP:Japán
      KE:Kẹ́nya
      KG:Kẹjístan
      KH:Kambódia
      KI:Kiribáti
      KM:Kọ́mọ́ros
      KN:Sent Kits & Nẹ́vis
      KP:Nọ́t Koria
      KR:Saút Koria
      KW:Kuwét
      KY:Kéman Aílands
      KZ:Kazakstan
      LA:Láos
      LB:Lẹ́bánọn
      LC:Sent Lúshia
      LI:Líktẹ́nstain
      LK:Sri Lánka
      LR:Laibẹ́ria
      LS:Lẹsóto
      LT:Lituénia
      LU:Lọ́ksẹ́mbọg
      LV:Látvia
      LY:Líbia
      MA:Morọko
      MC:Mọ́náko
      MD:Mọldóva
      ME:Mọntinígro
      MF:Sent Mátin
      MG:Madagáska
      MH:Máshál Aílands
      MK:Nọ́t Masidónia
      ML:Máli
      MM:Miánma (Bọ́ma)
      MN:Mọngólia
      MO:Makáo SAR Chaína
      MP:Nọ́tán Mariána Aílands
      MQ:Matínik
      MR:Mọriténia
      MS:Mọntsẹrat
      MT:Mọ́lta
      MU:Mọríshọs
      MV:Mọ́ldivs
      MW:Maláwi
      MX:Mẹ́ksíko
      MY:Maléshia
      MZ:Mozámbik
      NA:Namíbia
      NC:Niú Kalẹdónia
      NE:Nizhẹr
      NF:Nọ́fọlk Aíland
      NG:Naijíria
      NI:Nikarágwua
      NL:Nẹ́dalands
      NO:Nọ́we
      NP:Nẹ́pal
      NR:Náuru
      NU:Niúẹ
      NZ:Niú Zíland
      OM:Omán
      PA:Pánáma
      PE:Pẹ́ru
      PF:Frẹ́nch Poliníshia
      PG:Pápuá Niú Gíni
      PH:Fílípins
      PK:Pakístan
      PL:Póland
      PM:Sent Piẹr & Míkẹlọn
      PN:Pítkén Aílands
      PR:Puẹ́rto Ríkọ
      PS:Pálẹ́staín Éria-dẹm
      PT:Pọ́túgal
      PW:Paláu
      PY:Párágwue
      QA:Kata
      QO:Rimót Pát ọf Oshẹ́nia
      RE:Réyúniọn
      RO:Ruménia
      RS:Sẹ́bia
      RU:Rọ́shia
      RW:Ruwánda
      SA:Saúdí Arébia
      SB:Sólómọ́n Aílands
      SC:Sẹ́chẹls
      SD:Sudán
      SE:Swídẹn
      SG:Singapọ
      SH:Sent Hẹlẹ́na
      SI:Slovẹ́nia
      SJ:Sválbad & Jén Meyẹn
      SK:Slovékia
      SL:Siẹ́ra Líon
      SM:San Maríno
      SN:Sẹ́nẹ́gal
      SO:Sọmália
      SR:Súrínam
      SS:Saút Sudan
      ST:Sao Tómé & Prínsípẹ
      SV:El Sálvádọ
      SX:Sint Mátin
      SY:Síria
      SZ:Ẹswatíni
      TA:Trístán da Kúna
      TC:Tọks an Kaíkọ́s Aílands
      TD:Chád
      TF:Frẹ́nch Saútán Tẹ́rẹ́tris
      TG:Tógo
      TH:Taíland
      TJ:Tajíkstan
      TK:Tókẹ́lau
      TL:Íst Tímọ
      TM:Tọkmẹ́nístan
      TN:Tuníshia
      TO:Tónga
      TR:Tọ́ki
      TT:Trínídad & Tobágo
      TV:Tuválu
      TW:Taíwán
      TZ:Tanzánia
      UA:Yukrein
      UG:Yugánda
      UM:U.S. Faá Faá Aílands
      UN:Yunaítẹd Néshọns
      US:Yunaítẹ́d Stets
      UY:Yúrugwue
      UZ:Uzbẹ́kistan
      VA:Vátíkán Síti
      VC:Sent Vínsẹnt & Grẹ́nádians
      VE:Vẹnẹzuẹ́la
      VG:Brítísh Vájín Aílands
      VI:U.S. Vájín Aílands
      VN:Viẹ́tnam
      VU:Vanuátu
      WF:Wọ́lis & Fiutúna
      WS:Samóa
      XA:To yúz atifíshál vọis wẹ́n yu de tọk
      XB:Atífíshál Tú-Wé Dairẹ́kshọn
      XK:Kósóvo
      YE:Yẹ́mẹn
      YT:Meyọt
      ZA:Saút Áfríka
      ZM:Zámbia
      ZW:Zimbábwẹ
      ZZ:Ríjọn Wé Nóbọ́di Sabí
      """.trimIndent() }

  val pis: String by lazy { """
      SB:Solomon Aelan
      """.trimIndent() }

  val pl: String by lazy { """
      001:świat
      002:Afryka
      003:Ameryka Północna
      005:Ameryka Południowa
      009:Oceania
      011:Afryka Zachodnia
      013:Ameryka Środkowa
      014:Afryka Wschodnia
      015:Afryka Północna
      017:Afryka Środkowa
      018:Afryka Południowa
      019:Ameryka
      021:Ameryka Północna (USA, Kanada)
      029:Karaiby
      030:Azja Wschodnia
      034:Azja Południowa
      035:Azja Południowo-Wschodnia
      039:Europa Południowa
      053:Australazja
      054:Melanezja
      057:Region Mikronezji
      061:Polinezja
      142:Azja
      143:Azja Środkowa
      145:Azja Zachodnia
      150:Europa
      151:Europa Wschodnia
      154:Europa Północna
      155:Europa Zachodnia
      202:Afryka Subsaharyjska
      419:Ameryka Łacińska
      AC:Wyspa Wniebowstąpienia
      AD:Andora
      AE:Zjednoczone Emiraty Arabskie
      AF:Afganistan
      AG:Antigua i Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarktyda
      AR:Argentyna
      AS:Samoa Amerykańskie
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Wyspy Alandzkie
      AZ:Azerbejdżan
      BA:Bośnia i Hercegowina
      BB:Barbados
      BD:Bangladesz
      BE:Belgia
      BF:Burkina Faso
      BG:Bułgaria
      BH:Bahrajn
      BI:Burundi
      BJ:Benin
      BL:Saint-Barthélemy
      BM:Bermudy
      BN:Brunei
      BO:Boliwia
      BQ:Niderlandy Karaibskie
      BR:Brazylia
      BS:Bahamy
      BT:Bhutan
      BV:Wyspa Bouveta
      BW:Botswana
      BY:Białoruś
      BZ:Belize
      CA:Kanada
      CC:Wyspy Kokosowe
      CD:Demokratyczna Republika Konga
      CF:Republika Środkowoafrykańska
      CG:Kongo
      CH:Szwajcaria
      CI:Côte d’Ivoire
      CK:Wyspy Cooka
      CL:Chile
      CM:Kamerun
      CN:Chiny
      CO:Kolumbia
      CP:Wyspa Clippertona
      CR:Kostaryka
      CU:Kuba
      CV:Republika Zielonego Przylądka
      CW:Curaçao
      CX:Wyspa Bożego Narodzenia
      CY:Cypr
      CZ:Czechy
      DE:Niemcy
      DG:Diego Garcia
      DJ:Dżibuti
      DK:Dania
      DM:Dominika
      DO:Dominikana
      DZ:Algieria
      EA:Ceuta i Melilla
      EC:Ekwador
      EE:Estonia
      EG:Egipt
      EH:Sahara Zachodnia
      ER:Erytrea
      ES:Hiszpania
      ET:Etiopia
      EU:Unia Europejska
      EZ:strefa euro
      FI:Finlandia
      FJ:Fidżi
      FK:Falklandy
      FM:Mikronezja
      FO:Wyspy Owcze
      FR:Francja
      GA:Gabon
      GB:Wielka Brytania
      GD:Grenada
      GE:Gruzja
      GF:Gujana Francuska
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grenlandia
      GM:Gambia
      GN:Gwinea
      GP:Gwadelupa
      GQ:Gwinea Równikowa
      GR:Grecja
      GS:Georgia Południowa i Sandwich Południowy
      GT:Gwatemala
      GU:Guam
      GW:Gwinea Bissau
      GY:Gujana
      HK:SRA Hongkong (Chiny)
      HM:Wyspy Heard i McDonalda
      HN:Honduras
      HR:Chorwacja
      HT:Haiti
      HU:Węgry
      IC:Wyspy Kanaryjskie
      ID:Indonezja
      IE:Irlandia
      IL:Izrael
      IM:Wyspa Man
      IN:Indie
      IO:Brytyjskie Terytorium Oceanu Indyjskiego
      IQ:Irak
      IR:Iran
      IS:Islandia
      IT:Włochy
      JE:Jersey
      JM:Jamajka
      JO:Jordania
      JP:Japonia
      KE:Kenia
      KG:Kirgistan
      KH:Kambodża
      KI:Kiribati
      KM:Komory
      KN:Saint Kitts i Nevis
      KP:Korea Północna
      KR:Korea Południowa
      KW:Kuwejt
      KY:Kajmany
      KZ:Kazachstan
      LA:Laos
      LB:Liban
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Litwa
      LU:Luksemburg
      LV:Łotwa
      LY:Libia
      MA:Maroko
      MC:Monako
      MD:Mołdawia
      ME:Czarnogóra
      MF:Saint-Martin
      MG:Madagaskar
      MH:Wyspy Marshalla
      MK:Macedonia Północna
      ML:Mali
      MM:Mjanma (Birma)
      MN:Mongolia
      MO:SRA Makau (Chiny)
      MP:Mariany Północne
      MQ:Martynika
      MR:Mauretania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Malediwy
      MW:Malawi
      MX:Meksyk
      MY:Malezja
      MZ:Mozambik
      NA:Namibia
      NC:Nowa Kaledonia
      NE:Niger
      NF:Norfolk
      NG:Nigeria
      NI:Nikaragua
      NL:Holandia
      NO:Norwegia
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nowa Zelandia
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Polinezja Francuska
      PG:Papua-Nowa Gwinea
      PH:Filipiny
      PK:Pakistan
      PL:Polska
      PM:Saint-Pierre i Miquelon
      PN:Pitcairn
      PR:Portoryko
      PS:Terytoria Palestyńskie
      PT:Portugalia
      PW:Palau
      PY:Paragwaj
      QA:Katar
      QO:Oceania — wyspy dalekie
      RE:Reunion
      RO:Rumunia
      RS:Serbia
      RU:Rosja
      RW:Rwanda
      SA:Arabia Saudyjska
      SB:Wyspy Salomona
      SC:Seszele
      SD:Sudan
      SE:Szwecja
      SG:Singapur
      SH:Wyspa Świętej Heleny
      SI:Słowenia
      SJ:Svalbard i Jan Mayen
      SK:Słowacja
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Sudan Południowy
      ST:Wyspy Świętego Tomasza i Książęca
      SV:Salwador
      SX:Sint Maarten
      SY:Syria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks i Caicos
      TD:Czad
      TF:Francuskie Terytoria Południowe i Antarktyczne
      TG:Togo
      TH:Tajlandia
      TJ:Tadżykistan
      TK:Tokelau
      TL:Timor Wschodni
      TM:Turkmenistan
      TN:Tunezja
      TO:Tonga
      TR:Turcja
      TT:Trynidad i Tobago
      TV:Tuvalu
      TW:Tajwan
      TZ:Tanzania
      UA:Ukraina
      UG:Uganda
      UM:Dalekie Wyspy Mniejsze Stanów Zjednoczonych
      UN:Organizacja Narodów Zjednoczonych
      US:Stany Zjednoczone
      UY:Urugwaj
      UZ:Uzbekistan
      VA:Watykan
      VC:Saint Vincent i Grenadyny
      VE:Wenezuela
      VG:Brytyjskie Wyspy Dziewicze
      VI:Wyspy Dziewicze Stanów Zjednoczonych
      VN:Wietnam
      VU:Vanuatu
      WF:Wallis i Futuna
      WS:Samoa
      XA:Pseudoakcenty
      XB:Pseudodwukierunkowe
      XK:Kosowo
      YE:Jemen
      YT:Majotta
      ZA:Republika Południowej Afryki
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Nieznany region
      """.trimIndent() }

  val prg: String by lazy { """
      001:swītai
      PL:Pōli
      """.trimIndent() }

  val ps: String by lazy { """
      001:نړۍ
      002:افريقا
      003:شمالی امریکا
      005:سويلي امريکا
      009:اوقيانوسيه
      011:لویدیځ افریقا
      013:منخنۍ امريکا
      014:ختیځ افریقا
      015:شمالي افریقا
      017:منځنۍ افریقا
      018:سويلي افريقا
      019:امريکې
      021:شمالي امریکا
      029:کیریبین
      030:ختیځ آسیا
      034:سويلي آسيا
      035:سويلي ختيځ آسيا
      039:سويلي اروپا
      053:آسترالیا
      054:ملانشیا
      057:د مایکرونیسینین سیمه
      061:پولنيسيا
      142:آسيا
      143:منځنۍ آسيا
      145:لویدیځ آسیا
      150:اروپا
      151:ختيځ اروپا
      154:شمالي اروپا
      155:لوېديځ اروپا
      202:سب سهارن افريقا
      419:لاتیني امریکا
      AC:اسينشان ټاپو
      AD:اندورا
      AE:متحده عرب امارات
      AF:افغانستان
      AG:انټيګوا او باربودا
      AI:انګیلا
      AL:البانیه
      AM:ارمنستان
      AO:انګولا
      AQ:انتارکتیکا
      AR:ارجنټاين
      AS:امریکایی ساماوا
      AT:اتریش
      AU:آسټرالیا
      AW:آروبا
      AX:الاند ټاپوان
      AZ:اذربايجان
      BA:بوسنيا او هېرزګوينا
      BB:باربادوس
      BD:بنگله دېش
      BE:بیلجیم
      BF:بورکینا فاسو
      BG:بلغاریه
      BH:بحرين
      BI:بروندي
      BJ:بینن
      BL:سينټ بارتيلمي
      BM:برمودا
      BN:برونائي
      BO:بولیویا
      BQ:کیریبین هالینډ
      BR:برازیل
      BS:باهماس
      BT:بهوټان
      BV:بوویټ ټاپو
      BW:بوتسوانه
      BY:بیلاروس
      BZ:بلیز
      CA:کاناډا
      CC:کوکوز (کيلنګ) ټاپوګان
      CD:کانګو - کینشاسا
      CF:وسطي افريقا جمهور
      CG:کانګو - بروزوییل
      CH:سویس
      CI:د عاج ساحل
      CK:کوک ټاپوګان
      CL:چیلي
      CM:کامرون
      CN:چین
      CO:کولمبیا
      CP:د کلپرټون ټاپو
      CR:کوستاریکا
      CU:کیوبا
      CV:کیپ ورد
      CW:کوراکاو
      CX:د کريسمس ټاپو
      CY:قبرس
      CZ:چکیا
      DE:المان
      DG:ډایګو ګارسیا
      DJ:جبوتي
      DK:ډنمارک
      DM:دومینیکا
      DO:جمهوريه ډومينيکن
      DZ:الجزایر
      EA:سيوتا او ماليلا
      EC:اکوادور
      EE:استونیا
      EG:مصر
      EH:لويديځ صحارا
      ER:اریتره
      ES:هسپانیه
      ET:حبشه
      EU:اروپايي اتحاديه
      EZ:اروپايي سيمه
      FI:فنلینډ
      FJ:فجي
      FK:فاکلينډ ټاپوګان
      FM:میکرونیزیا
      FO:فارو ټاپو
      FR:فرانسه
      GA:ګابن
      GB:برتانیه
      GD:ګرنادا
      GE:گورجستان
      GF:فرانسوي ګانا
      GG:ګرنسي
      GH:ګانا
      GI:جبل الطارق
      GL:ګرینلینډ
      GM:ګامبیا
      GN:ګینه
      GP:ګوادلوپ
      GQ:استوایی ګیني
      GR:یونان
      GS:سويلي جارجيا او سويلي سېنډوچ ټاپوګان
      GT:ګواتیمالا
      GU:ګوام
      GW:ګینه بیسو
      GY:ګیانا
      HK:هانګ کانګ SAR چین
      HM:هارډ او ميکډانلډ ټاپوګان
      HN:هانډوراس
      HR:کرواشيا
      HT:هایټي
      HU:مجارستان
      IC:د کناري ټاپوګان
      ID:اندونیزیا
      IE:آيرلېنډ
      IL:اسراييل
      IM:د آئل آف مین
      IN:هند
      IO:د برتانوي هند سمندري سيمه
      IQ:عراق
      IR:ايران
      IS:آیسلینډ
      IT:ایټالیه
      JE:جرسی
      JM:جمیکا
      JO:اردن
      JP:جاپان
      KE:کینیا
      KG:قرغزستان
      KH:کمبودیا
      KI:کیري باتي
      KM:کوموروس
      KN:سینټ کټس او نیویس
      KP:شمالی کوریا
      KR:سویلي کوریا
      KW:کويت
      KY:کیمان ټاپوګان
      KZ:قزاقستان
      LA:لاوس
      LB:لبنان
      LC:سینټ لوسیا
      LI:لیختن اشتاین
      LK:سريلنکا
      LR:لايبيريا
      LS:لسوتو
      LT:لیتوانیا
      LU:لوګزامبورګ
      LV:ليتهويا
      LY:لیبیا
      MA:مراکش
      MC:موناکو
      MD:مولدوا
      ME:مونټینیګرو
      MF:سینټ مارټن
      MG:مدغاسکر
      MH:مارشل ټاپوګان
      MK:شمالي مقدونيه
      ML:مالي
      MM:ميانمار (برما)
      MN:منګوليا
      MO:مکاو SAR چین
      MP:شمالي ماريانا ټاپوګان
      MQ:مارټینیک
      MR:موریتانیا
      MS:مانټیسیرت
      MT:مالټا
      MU:موریشیس
      MV:مالديپ
      MW:مالاوي
      MX:میکسیکو
      MY:مالیزیا
      MZ:موزمبيق
      NA:نیمبیا
      NC:نوی کالیډونیا
      NE:نايجير
      NF:نارفولک ټاپوګان
      NG:نایجیریا
      NI:نکاراګوا
      NL:هالېنډ
      NO:ناروۍ
      NP:نیپال
      NR:نایرو
      NU:نیوو
      NZ:نیوزیلنډ
      OM:عمان
      PA:پاناما
      PE:پیرو
      PF:فرانسوي پولينيسيا
      PG:پاپوا نيو ګيني
      PH:فلپين
      PK:پاکستان
      PL:پولنډ
      PM:سینټ پییر او میکولون
      PN:پيټکيرن ټاپوګان
      PR:پورتو ریکو
      PS:فلسطیني سيمې
      PT:پورتګال
      PW:پلاؤ
      PY:پاراګوی
      QA:قطر
      QO:بهرنۍ اوسيانه
      RE:ریونین
      RO:رومانیا
      RS:سربيا
      RU:روسیه
      RW:روندا
      SA:سعودي عربستان
      SB:سليمان ټاپوګان
      SC:سیچیلیس
      SD:سوډان
      SE:سویډن
      SG:سينگاپور
      SH:سینټ هیلینا
      SI:سلوانیا
      SJ:سوالبارد او جان ميين
      SK:سلواکیا
      SL:سییرا لیون
      SM:سان مارینو
      SN:سينيګال
      SO:سومالیا
      SR:سورینام
      SS:سويلي سوډان
      ST:ساو ټیم او پرنسیپ
      SV:سالوېډور
      SX:سینټ مارټین
      SY:سوریه
      SZ:اسواټيني
      TA:تریستان دا کنها
      TC:د ترکیې او کیکاسو ټاپو
      TD:چاډ
      TF:د فرانسې جنوبي سیمې
      TG:ټوګو
      TH:تهايلنډ
      TJ:تاجکستان
      TK:توکیلو
      TL:تيمور-ليسټ
      TM:تورکمنستان
      TN:تونس
      TO:تونګا
      TR:ترکي
      TT:ټرينيډاډ او ټوباګو
      TV:توالیو
      TW:تائيوان
      TZ:تنزانیا
      UA:اوکراین
      UG:یوګانډا
      UM:د متحده ایالاتو ټاپوګان
      UN:ملگري ملتونه
      US:متحده آيالات
      UY:یوروګوی
      UZ:اوزبکستان
      VA:واتیکان ښار
      VC:سینټ ویسنټینټ او ګرینډینز
      VE:وینزویلا
      VG:بریتانوی ویګور ټاپوګان
      VI:د متحده آيالاتو ورجن ټاپوګان
      VN:وېتنام
      VU:واناتو
      WF:والیس او فوتونا
      WS:ساماوا
      XA:جعلي خج
      XB:سیډو بیډی
      XK:کوسوو
      YE:یمن
      YT:مايوټ
      ZA:سویلي افریقا
      ZM:زیمبیا
      ZW:زیمبابوی
      ZZ:نامعلومه سيمه
      """.trimIndent() }

  val ps_PK: String by lazy { """
      019:امريکے
      PS:فلسطين سيمے
      TC:د ترکیے او کیکاسو ټاپو
      TF:د فرانسے جنوبي سیمے
      """.trimIndent() }

  val pt: String by lazy { """
      001:Mundo
      002:África
      003:América do Norte
      005:América do Sul
      009:Oceania
      011:África Ocidental
      013:América Central
      014:África Oriental
      015:África Setentrional
      017:África Central
      018:África Meridional
      019:Américas
      021:América Setentrional
      029:Caribe
      030:Ásia Oriental
      034:Ásia Meridional
      035:Sudeste Asiático
      039:Europa Meridional
      053:Australásia
      054:Melanésia
      057:Região da Micronésia
      061:Polinésia
      142:Ásia
      143:Ásia Central
      145:Ásia Ocidental
      150:Europa
      151:Europa Oriental
      154:Europa Setentrional
      155:Europa Ocidental
      202:África Subsaariana
      419:América Latina
      AC:Ilha de Ascensão
      AD:Andorra
      AE:Emirados Árabes Unidos
      AF:Afeganistão
      AG:Antígua e Barbuda
      AI:Anguila
      AL:Albânia
      AM:Armênia
      AO:Angola
      AQ:Antártida
      AR:Argentina
      AS:Samoa Americana
      AT:Áustria
      AU:Austrália
      AW:Aruba
      AX:Ilhas Aland
      AZ:Azerbaijão
      BA:Bósnia e Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Bélgica
      BF:Burquina Faso
      BG:Bulgária
      BH:Barein
      BI:Burundi
      BJ:Benin
      BL:São Bartolomeu
      BM:Bermudas
      BN:Brunei
      BO:Bolívia
      BQ:Países Baixos Caribenhos
      BR:Brasil
      BS:Bahamas
      BT:Butão
      BV:Ilha Bouvet
      BW:Botsuana
      BY:Bielorrússia
      BZ:Belize
      CA:Canadá
      CC:Ilhas Cocos (Keeling)
      CD:Congo - Kinshasa
      CF:República Centro-Africana
      CG:República do Congo
      CH:Suíça
      CI:Costa do Marfim
      CK:Ilhas Cook
      CL:Chile
      CM:Camarões
      CN:China
      CO:Colômbia
      CP:Ilha de Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cabo Verde
      CW:Curaçao
      CX:Ilha Christmas
      CY:Chipre
      CZ:Tchéquia
      DE:Alemanha
      DG:Diego Garcia
      DJ:Djibuti
      DK:Dinamarca
      DM:Dominica
      DO:República Dominicana
      DZ:Argélia
      EA:Ceuta e Melilla
      EC:Equador
      EE:Estônia
      EG:Egito
      EH:Saara Ocidental
      ER:Eritreia
      ES:Espanha
      ET:Etiópia
      EU:União Europeia
      EZ:zona do euro
      FI:Finlândia
      FJ:Fiji
      FK:Ilhas Malvinas
      FM:Micronésia
      FO:Ilhas Faroé
      FR:França
      GA:Gabão
      GB:Reino Unido
      GD:Granada
      GE:Geórgia
      GF:Guiana Francesa
      GG:Guernsey
      GH:Gana
      GI:Gibraltar
      GL:Groenlândia
      GM:Gâmbia
      GN:Guiné
      GP:Guadalupe
      GQ:Guiné Equatorial
      GR:Grécia
      GS:Ilhas Geórgia do Sul e Sandwich do Sul
      GT:Guatemala
      GU:Guam
      GW:Guiné-Bissau
      GY:Guiana
      HK:Hong Kong, RAE da China
      HM:Ilhas Heard e McDonald
      HN:Honduras
      HR:Croácia
      HT:Haiti
      HU:Hungria
      IC:Ilhas Canárias
      ID:Indonésia
      IE:Irlanda
      IL:Israel
      IM:Ilha de Man
      IN:Índia
      IO:Território Britânico do Oceano Índico
      IQ:Iraque
      IR:Irã
      IS:Islândia
      IT:Itália
      JE:Jersey
      JM:Jamaica
      JO:Jordânia
      JP:Japão
      KE:Quênia
      KG:Quirguistão
      KH:Camboja
      KI:Quiribati
      KM:Comores
      KN:São Cristóvão e Névis
      KP:Coreia do Norte
      KR:Coreia do Sul
      KW:Kuwait
      KY:Ilhas Cayman
      KZ:Cazaquistão
      LA:Laos
      LB:Líbano
      LC:Santa Lúcia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Libéria
      LS:Lesoto
      LT:Lituânia
      LU:Luxemburgo
      LV:Letônia
      LY:Líbia
      MA:Marrocos
      MC:Mônaco
      MD:Moldávia
      ME:Montenegro
      MF:São Martinho
      MG:Madagascar
      MH:Ilhas Marshall
      MK:Macedônia do Norte
      ML:Mali
      MM:Mianmar (Birmânia)
      MN:Mongólia
      MO:Macau, RAE da China
      MP:Ilhas Marianas do Norte
      MQ:Martinica
      MR:Mauritânia
      MS:Montserrat
      MT:Malta
      MU:Maurício
      MV:Maldivas
      MW:Malaui
      MX:México
      MY:Malásia
      MZ:Moçambique
      NA:Namíbia
      NC:Nova Caledônia
      NE:Níger
      NF:Ilha Norfolk
      NG:Nigéria
      NI:Nicarágua
      NL:Países Baixos
      NO:Noruega
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nova Zelândia
      OM:Omã
      PA:Panamá
      PE:Peru
      PF:Polinésia Francesa
      PG:Papua-Nova Guiné
      PH:Filipinas
      PK:Paquistão
      PL:Polônia
      PM:São Pedro e Miquelão
      PN:Ilhas Pitcairn
      PR:Porto Rico
      PS:Territórios palestinos
      PT:Portugal
      PW:Palau
      PY:Paraguai
      QA:Catar
      QO:Oceania Remota
      RE:Reunião
      RO:Romênia
      RS:Sérvia
      RU:Rússia
      RW:Ruanda
      SA:Arábia Saudita
      SB:Ilhas Salomão
      SC:Seicheles
      SD:Sudão
      SE:Suécia
      SG:Singapura
      SH:Santa Helena
      SI:Eslovênia
      SJ:Svalbard e Jan Mayen
      SK:Eslováquia
      SL:Serra Leoa
      SM:San Marino
      SN:Senegal
      SO:Somália
      SR:Suriname
      SS:Sudão do Sul
      ST:São Tomé e Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Síria
      SZ:Essuatíni
      TA:Tristão da Cunha
      TC:Ilhas Turcas e Caicos
      TD:Chade
      TF:Territórios Franceses do Sul
      TG:Togo
      TH:Tailândia
      TJ:Tadjiquistão
      TK:Tokelau
      TL:Timor-Leste
      TM:Turcomenistão
      TN:Tunísia
      TO:Tonga
      TR:Turquia
      TT:Trinidad e Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzânia
      UA:Ucrânia
      UG:Uganda
      UM:Ilhas Menores Distantes dos EUA
      UN:Nações Unidas
      US:Estados Unidos
      UY:Uruguai
      UZ:Uzbequistão
      VA:Cidade do Vaticano
      VC:São Vicente e Granadinas
      VE:Venezuela
      VG:Ilhas Virgens Britânicas
      VI:Ilhas Virgens Americanas
      VN:Vietnã
      VU:Vanuatu
      WF:Wallis e Futuna
      WS:Samoa
      XA:Pseudossotaques
      XB:Pseudobidirecional
      XK:Kosovo
      YE:Iêmen
      YT:Mayotte
      ZA:África do Sul
      ZM:Zâmbia
      ZW:Zimbábue
      ZZ:Região desconhecida
      """.trimIndent() }

  val pt_AO: String? = null

  val pt_CH: String? = null

  val pt_CV: String? = null

  val pt_GQ: String? = null

  val pt_GW: String? = null

  val pt_LU: String? = null

  val pt_MO: String? = null

  val pt_MZ: String? = null

  val pt_PT: String by lazy { """
      009:Oceânia
      015:Norte de África
      018:África Austral
      029:Caraíbas
      034:Ásia do Sul
      039:Europa do Sul
      154:Europa do Norte
      202:África subsariana
      AM:Arménia
      AX:Alanda
      BD:Bangladeche
      BH:Barém
      BJ:Benim
      BS:Baamas
      CC:Ilhas dos Cocos (Keeling)
      CD:Congo-Kinshasa
      CG:Congo-Brazzaville
      CI:Côte d’Ivoire (Costa do Marfim)
      CW:Curaçau
      CX:Ilha do Natal
      CZ:Chéquia
      DJ:Jibuti
      DM:Domínica
      EA:Ceuta e Melilha
      EE:Estónia
      EH:Sara Ocidental
      EZ:Zona Euro
      FK:Ilhas Falkland
      GG:Guernesey
      GL:Gronelândia
      GU:Guame
      IR:Irão
      KE:Quénia
      KI:Quiribáti
      KN:São Cristóvão e Neves
      KW:Koweit
      KY:Ilhas Caimão
      LI:Listenstaine
      LK:Sri Lanca
      LV:Letónia
      MC:Mónaco
      MF:São Martinho (Saint-Martin)
      MG:Madagáscar
      MK:Macedónia do Norte
      MS:Monserrate
      MU:Maurícia
      MW:Maláui
      NC:Nova Caledónia
      NU:Niuê
      PL:Polónia
      PS:Territórios palestinianos
      QO:Oceânia Insular
      RO:Roménia
      SI:Eslovénia
      SM:São Marinho
      SV:Salvador
      SX:São Martinho (Sint Maarten)
      TF:Territórios Austrais Franceses
      TJ:Tajiquistão
      TK:Toquelau
      TM:Turquemenistão
      TT:Trindade e Tobago
      UM:Ilhas Menores Afastadas dos EUA
      UZ:Usbequistão
      VI:Ilhas Virgens dos EUA
      VN:Vietname
      XA:Pseudoacentos
      YE:Iémen
      YT:Maiote
      ZW:Zimbabué
      """.trimIndent() }

  val pt_ST: String? = null

  val pt_TL: String? = null

  val qu: String by lazy { """
      001:Pacha
      002:Africa
      003:Norte America
      005:Sud America
      009:Oceania
      011:Africa Occidental
      013:America Central
      014:Africa Oriental
      015:Africa del Norte
      017:Africa Media
      018:Sud Africa
      019:America
      021:America del Norte
      029:Caribe
      030:Asia Oriental
      034:Asia del Sur
      035:Sureste de Asia
      039:Europa del Sur
      053:Australasia
      054:Melanesia
      057:Región Micronesia
      061:Polinesia
      142:Asia
      143:Asia Central
      145:Asia Occidental
      150:Europa
      151:Europa Oriental
      154:Europa del Norte
      155:Europa Occidental
      202:Africa Sub-Sahariana
      419:AmericaLatina
      AC:Islas Ascensión
      AD:Andorra
      AE:Emiratos Árabes Unidos
      AF:Afganistán
      AG:Antigua y Barbuda
      AI:Anguila
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antártida
      AR:Argentina
      AS:Samoa Americana
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Islas Åland
      AZ:Azerbaiyán
      BA:Bosnia y Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Bélgica
      BF:Burkina Faso
      BG:Bulgaria
      BH:Baréin
      BI:Burundi
      BJ:Benín
      BL:San Bartolomé
      BM:Bermudas
      BN:Brunéi
      BO:Bolivia
      BQ:Bonaire
      BR:Brasil
      BS:Bahamas
      BT:Bután
      BV:Isla Bouvet
      BW:Botsuana
      BY:Belarús
      BZ:Belice
      CA:Canadá
      CC:Islas Cocos
      CD:Congo (RDC)
      CF:República Centroafricana
      CG:Congo
      CH:Suiza
      CI:Côte d’Ivoire
      CK:Islas Cook
      CL:Chile
      CM:Camerún
      CN:China
      CO:Colombia
      CP:Isla Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cabo Verde
      CW:Curazao
      CX:Isla Christmas
      CY:Chipre
      CZ:Chequia
      DE:Alemania
      DG:Diego García
      DJ:Yibuti
      DK:Dinamarca
      DM:Dominica
      DO:República Dominicana
      DZ:Argelia
      EA:Ceuta y Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egipto
      EH:Sahara Occidental
      ER:Eritrea
      ES:España
      ET:Etiopía
      EU:Union Europea
      EZ:Eurozona
      FI:Finlandia
      FJ:Fiyi
      FK:Islas Malvinas
      FM:Micronesia
      FO:Islas Feroe
      FR:Francia
      GA:Gabón
      GB:Reino Unido
      GD:Granada
      GE:Georgia
      GF:Guayana Francesa
      GG:Guernesey
      GH:Ghana
      GI:Gibraltar
      GL:Groenlandia
      GM:Gambia
      GN:Guinea
      GP:Guadalupe
      GQ:Guinea Ecuatorial
      GR:Grecia
      GS:Georgia del Sur e Islas Sandwich del Sur
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bisáu
      GY:Guyana
      HK:Hong Kong RAE China
      HM:Islas Heard y McDonald
      HN:Honduras
      HR:Croacia
      HT:Haití
      HU:Hungría
      IC:Islas Canarias
      ID:Indonesia
      IE:Irlanda
      IL:Israel
      IM:Isla de Man
      IN:India
      IO:Territorio Británico del Océano Índico
      IQ:Irak
      IR:Irán
      IS:Islandia
      IT:Italia
      JE:Jersey
      JM:Jamaica
      JO:Jordania
      JP:Japón
      KE:Kenia
      KG:Kirguistán
      KH:Camboya
      KI:Kiribati
      KM:Comoras
      KN:San Cristóbal y Nieves
      KP:Corea del Norte
      KR:Corea del Sur
      KW:Kuwait
      KY:Islas Caimán
      KZ:Kazajistán
      LA:Laos
      LB:Líbano
      LC:Santa Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesoto
      LT:Lituania
      LU:Luxemburgo
      LV:Letonia
      LY:Libia
      MA:Marruecos
      MC:Mónaco
      MD:Moldova
      ME:Montenegro
      MF:San Martín
      MG:Madagascar
      MH:Islas Marshall
      MK:Macedonia del Norte
      ML:Malí
      MM:Myanmar
      MN:Mongolia
      MO:Macao RAE China
      MP:Islas Marianas del Norte
      MQ:Martinica
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauricio
      MV:Maldivas
      MW:Malawi
      MX:México
      MY:Malasia
      MZ:Mozambique
      NA:Namibia
      NC:Nueva Caledonia
      NE:Níger
      NF:Isla Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Países Bajos
      NO:Noruega
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nueva Zelanda
      OM:Omán
      PA:Panamá
      PE:Perú
      PF:Polinesia Francesa
      PG:Papúa Nueva Guinea
      PH:Filipinas
      PK:Pakistán
      PL:Polonia
      PM:San Pedro y Miquelón
      PN:Islas Pitcairn
      PR:Puerto Rico
      PS:Palestina Kamachikuq
      PT:Portugal
      PW:Palaos
      PY:Paraguay
      QA:Qatar
      QO:Oceanía Periférica
      RE:Reunión
      RO:Rumania
      RS:Serbia
      RU:Rusia
      RW:Ruanda
      SA:Arabia Saudí
      SB:Islas Salomón
      SC:Seychelles
      SD:Sudán
      SE:Suecia
      SG:Singapur
      SH:Santa Elena
      SI:Eslovenia
      SJ:Svalbard y Jan Mayen
      SK:Eslovaquia
      SL:Sierra Leona
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Sudán del Sur
      ST:Santo Tomé y Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Siria
      SZ:Esuatini
      TA:Tristán de Acuña
      TC:Islas Turcas y Caicos
      TD:Chad
      TF:Territorios Australes Franceses
      TG:Togo
      TH:Tailandia
      TJ:Tayikistán
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistán
      TN:Túnez
      TO:Tonga
      TR:Turquía
      TT:Trinidad y Tobago
      TV:Tuvalu
      TW:Taiwán
      TZ:Tanzania
      UA:Ucrania
      UG:Uganda
      UM:Islas menores alejadas de los EE.UU.
      UN:Naciones Unidas
      US:Estados Unidos
      UY:Uruguay
      UZ:Uzbekistán
      VA:Santa Sede (Ciudad del Vaticano)
      VC:San Vicente y las Granadinas
      VE:Venezuela
      VG:Islas Vírgenes Británicas
      VI:EE.UU. Islas Vírgenes
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis y Futuna
      WS:Samoa
      XA:Seudo-Acentos
      XB:Seudo-Bidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:Sudáfrica
      ZM:Zambia
      ZW:Zimbabue
      ZZ:Mana yachasqa Suyu
      """.trimIndent() }

  val qu_BO: String? = null

  val qu_EC: String? = null

  val quc: String by lazy { """
      MK:Macedonia del Norte
      """.trimIndent() }

  val raj: String by lazy { """
      IN:भारत
      ZZ:अज्ञात
      """.trimIndent() }

  val rm: String by lazy { """
      001:mund
      002:Africa
      003:America dal Nord
      005:America dal Sid
      009:Oceania
      011:Africa dal Vest
      013:America Centrala
      014:Africa da l’Ost
      015:Africa dal Nord
      017:Africa Centrala
      018:Africa Meridiunala
      019:americas
      021:Amercia dal Nord
      029:Caribica
      030:Asia da l’Ost
      034:Asia dal Sid
      035:Asia dal Sidost
      039:Europa dal Sid
      053:Australia e Nova Zelanda
      054:Melanesia
      057:Regiun Micronesica
      061:Polinesia
      142:Asia
      143:Asia Centrala
      145:Asia dal Vest
      150:Europa
      151:Europa Orientala
      154:Europa dal Nord
      155:Europa dal Vest
      202:Africa Subsaharica
      419:America Latina
      AC:Insla d’Ascensiun
      AD:Andorra
      AE:Emirats Arabs Unids
      AF:Afghanistan
      AG:Antigua e Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarctica
      AR:Argentinia
      AS:Samoa Americana
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Inslas Aland
      AZ:Aserbaidschan
      BA:Bosnia ed Erzegovina
      BB:Barbados
      BD:Bangladesch
      BE:Belgia
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Son Barthélemy
      BM:Bermudas
      BN:Brunei
      BO:Bolivia
      BQ:Antillas Ollandaisas
      BR:Brasilia
      BS:Bahamas
      BT:Bhutan
      BV:Insla Bouvet
      BW:Botswana
      BY:Bielorussia
      BZ:Belize
      CA:Canada
      CC:Inslas Cocos
      CD:Congo - Kinshasa
      CF:Republica Centralafricana
      CG:Congo
      CH:Svizra
      CI:Costa d’Ivur
      CK:Inslas Cook
      CL:Chile
      CM:Camerun
      CN:China
      CO:Columbia
      CP:Insla da Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Cap Verd
      CW:Curaçao
      CX:Insla da Nadal
      CY:Cipra
      CZ:Tschechia
      DE:Germania
      DG:Diego Garcia
      DJ:Dschibuti
      DK:Danemarc
      DM:Dominica
      DO:Republica Dominicana
      DZ:Algeria
      EA:Ceuta e Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egipta
      EH:Sahara Occidentala
      ER:Eritrea
      ES:Spagna
      ET:Etiopia
      EU:Uniun Europeica
      EZ:zona da l’euro
      FI:Finlanda
      FJ:Fidschi
      FK:Inslas dal Falkland
      FM:Micronesia
      FO:Inslas Feroe
      FR:Frantscha
      GA:Gabun
      GB:Reginavel Unì
      GD:Grenada
      GE:Georgia
      GF:Guyana Franzosa
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grönlanda
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Guinea Equatoriala
      GR:Grezia
      GS:Georgia dal Sid e las Inslas Sandwich dal Sid
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Regiun d’administraziun speziala da Hongkong, China
      HM:Inslas da Heard e da McDonald
      HN:Honduras
      HR:Croazia
      HT:Haiti
      HU:Ungaria
      IC:Inslas Canarias
      ID:Indonesia
      IE:Irlanda
      IL:Israel
      IM:Insla da Man
      IN:India
      IQ:Irac
      IR:Iran
      IS:Islanda
      IT:Italia
      JE:Jersey
      JM:Giamaica
      JO:Jordania
      JP:Giapun
      KE:Kenia
      KG:Kirgisistan
      KH:Cambodscha
      KI:Kiribati
      KM:Comoras
      KN:Saint Kitts e Nevis
      KP:Corea dal Nord
      KR:Corea dal Sid
      KW:Kuwait
      KY:Inslas Cayman
      KZ:Kasachstan
      LA:Laos
      LB:Libanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lituania
      LU:Luxemburg
      LV:Lettonia
      LY:Libia
      MA:Maroc
      MC:Monaco
      MD:Moldavia
      ME:Montenegro
      MF:Saint Martin
      MG:Madagascar
      MH:Inslas da Marshall
      MK:Macedonia dal Nord
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Regiun d’administraziun speziala Macao, China
      MP:Inslas Mariannas dal Nord
      MQ:Martinique
      MR:Mauretania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldivas
      MW:Malawi
      MX:Mexico
      MY:Malaisia
      MZ:Mosambic
      NA:Namibia
      NC:Nova Caledonia
      NE:Niger
      NF:Insla Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Pajais Bass
      NO:Norvegia
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nova Zelanda
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Polinesia Franzosa
      PG:Papua Nova Guinea
      PH:Filippinas
      PK:Pakistan
      PL:Pologna
      PM:Saint Pierre e Miquelon
      PN:Pitcairn
      PR:Puerto Rico
      PS:Territori Palestinais
      PT:Portugal
      PW:Palau
      PY:Paraguai
      QA:Katar
      QO:Oceania Periferica
      RE:Réunion
      RO:Rumenia
      RS:Serbia
      RU:Russia
      RW:Ruanda
      SA:Arabia Saudita
      SB:Inslas Salomonas
      SC:Seychellas
      SD:Sudan
      SE:Svezia
      SG:Singapur
      SH:Sontg’Elena
      SI:Slovenia
      SJ:Svalbard e Jan Mayen
      SK:Slovachia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Sudan dal Sid
      ST:São Tomé & Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Siria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Inslas Turks e Caicos
      TD:Tschad
      TF:Territoris Franzos Meridiunals
      TG:Togo
      TH:Tailanda
      TJ:Tadschikistan
      TK:Tokelau
      TL:Timor da l’Ost
      TM:Turkmenistan
      TN:Tunesia
      TO:Tonga
      TR:Tirchia
      TT:Trinidad e Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansania
      UA:Ucraina
      UG:Uganda
      UM:Inslas Pitschnas Perifericas dals Stadis Unids da l’America
      UN:Naziuns Unidas
      US:Stadis Unids da l’America
      UY:Uruguay
      UZ:Usbekistan
      VA:Citad dal Vatican
      VC:Saint Vincent e las Grenadinas
      VE:Venezuela
      VG:Inslas Virginas Britannicas
      VI:Inslas Virginas Americanas
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis & Futuna
      WS:Samoa
      XA:accents pseudo
      XB:pseudo-bidirecziunal
      XK:Cosovo
      YE:Jemen
      YT:Mayotte
      ZA:Africa dal Sid
      ZM:Sambia
      ZW:Simbabwe
      ZZ:regiun nunenconuschenta
      """.trimIndent() }

  val rn: String by lazy { """
      AD:Andora
      AE:Leta Zunze Ubumwe z’Abarabu
      AF:Afuganisitani
      AG:Antigwa na Baribuda
      AI:Angwila
      AL:Alubaniya
      AM:Arumeniya
      AO:Angola
      AR:Arijantine
      AS:Samowa nyamerika
      AT:Otirishe
      AU:Ositaraliya
      AW:Aruba
      AZ:Azerubayijani
      BA:Bosiniya na Herigozevine
      BB:Barubadosi
      BD:Bangaladeshi
      BE:Ububiligi
      BF:Burukina Faso
      BG:Buligariya
      BH:Bahareyini
      BI:Uburundi
      BJ:Bene
      BM:Berimuda
      BN:Buruneyi
      BO:Boliviya
      BR:Burezili
      BS:Bahamasi
      BT:Butani
      BW:Botswana
      BY:Belausi
      BZ:Belize
      CA:Kanada
      CD:Repubulika Iharanira Demokarasi ya Kongo
      CF:Repubulika ya Santarafurika
      CG:Kongo
      CH:Ubusuwisi
      CI:Kotedivuware
      CK:Izinga rya Kuku
      CL:Shili
      CM:Kameruni
      CN:Ubushinwa
      CO:Kolombiya
      CR:Kositarika
      CU:Kiba
      CV:Ibirwa bya Kapuveri
      CY:Izinga rya Shipure
      CZ:Repubulika ya Ceke
      DE:Ubudage
      DJ:Jibuti
      DK:Danimariki
      DM:Dominika
      DO:Repubulika ya Dominika
      DZ:Alijeriya
      EC:Ekwateri
      EE:Esitoniya
      EG:Misiri
      ER:Elitereya
      ES:Hisipaniya
      ET:Etiyopiya
      FI:Finilandi
      FJ:Fiji
      FK:Izinga rya Filikilandi
      FM:Mikoroniziya
      FR:Ubufaransa
      GA:Gabo
      GB:Ubwongereza
      GD:Gerenada
      GE:Jeworujiya
      GF:Gwayana y’Abafaransa
      GH:Gana
      GI:Juburalitari
      GL:Gurunilandi
      GM:Gambiya
      GN:Guneya
      GP:Gwadelupe
      GQ:Gineya Ekwatoriyali
      GR:Ubugereki
      GT:Gwatemala
      GU:Gwamu
      GW:Gineya Bisawu
      GY:Guyane
      HN:Hondurasi
      HR:Korowasiya
      HT:Hayiti
      HU:Hungariya
      ID:Indoneziya
      IE:Irilandi
      IL:Isiraheli
      IN:Ubuhindi
      IQ:Iraki
      IR:Irani
      IS:Ayisilandi
      IT:Ubutaliyani
      JM:Jamayika
      JO:Yorudaniya
      JP:Ubuyapani
      KE:Kenya
      KG:Kirigisitani
      KH:Kamboje
      KI:Kiribati
      KM:Izinga rya Komore
      KN:Sekitsi na Nevisi
      KP:Koreya y’amajaruguru
      KR:Koreya y’amajepfo
      KW:Koweti
      KY:Ibirwa bya Keyimani
      KZ:Kazakisitani
      LA:Layosi
      LB:Libani
      LC:Selusiya
      LI:Lishyitenshitayini
      LK:Sirilanka
      LR:Liberiya
      LS:Lesoto
      LT:Lituwaniya
      LU:Lukusamburu
      LV:Lativa
      LY:Libiya
      MA:Maroke
      MC:Monako
      MD:Moludavi
      MG:Madagasikari
      MH:Izinga rya Marishari
      ML:Mali
      MM:Birimaniya
      MN:Mongoliya
      MP:Amazinga ya Mariyana ryo mu majaruguru
      MQ:Maritiniki
      MR:Moritaniya
      MS:Monteserati
      MT:Malita
      MU:Izinga rya Morise
      MV:Moludave
      MW:Malawi
      MX:Migizike
      MY:Maleziya
      MZ:Mozambiki
      NA:Namibiya
      NC:Niyukaledoniya
      NE:Nijeri
      NF:izinga rya Norufoluke
      NG:Nijeriya
      NI:Nikaragwa
      NL:Ubuholandi
      NO:Noruveji
      NP:Nepali
      NR:Nawuru
      NU:Niyuwe
      NZ:Nuvelizelandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polineziya y’Abafaransa
      PG:Papuwa Niyugineya
      PH:Amazinga ya Filipine
      PK:Pakisitani
      PL:Polonye
      PM:Sempiyeri na Mikeloni
      PN:Pitikeyirini
      PR:Puwetoriko
      PS:Palesitina Wesitibanka na Gaza
      PT:Porutugali
      PW:Palawu
      PY:Paragwe
      QA:Katari
      RE:Amazinga ya Reyiniyo
      RO:Rumaniya
      RU:Uburusiya
      RW:u Rwanda
      SA:Arabiya Sawudite
      SB:Amazinga ya Salumoni
      SC:Amazinga ya Seyisheli
      SD:Sudani
      SE:Suwedi
      SG:Singapuru
      SH:Sehelene
      SI:Siloveniya
      SK:Silovakiya
      SL:Siyeralewone
      SM:Sanimarino
      SN:Senegali
      SO:Somaliya
      SR:Suriname
      ST:Sawotome na Perensipe
      SV:Eli Saluvatori
      SY:Siriya
      SZ:Suwazilandi
      TC:Amazinga ya Turkisi na Cayikosi
      TD:Cadi
      TG:Togo
      TH:Tayilandi
      TJ:Tajikisitani
      TK:Tokelawu
      TL:Timoru y’iburasirazuba
      TM:Turukumenisitani
      TN:Tuniziya
      TO:Tonga
      TR:Turukiya
      TT:Tirinidadi na Tobago
      TV:Tuvalu
      TW:Tayiwani
      TZ:Tanzaniya
      UA:Ikerene
      UG:Ubugande
      US:Leta Zunze Ubumwe za Amerika
      UY:Irigwe
      UZ:Uzubekisitani
      VA:Umurwa wa Vatikani
      VC:Sevensa na Gerenadine
      VE:Venezuwela
      VG:Ibirwa by’isugi by’Abongereza
      VI:Amazinga y’Isugi y’Abanyamerika
      VN:Viyetinamu
      VU:Vanuwatu
      WF:Walisi na Futuna
      WS:Samowa
      YE:Yemeni
      YT:Mayote
      ZA:Afurika y’Epfo
      ZM:Zambiya
      ZW:Zimbabwe
      """.trimIndent() }

  val ro: String by lazy { """
      001:Lume
      002:Africa
      003:America de Nord
      005:America de Sud
      009:Oceania
      011:Africa Occidentală
      013:America Centrală
      014:Africa Orientală
      015:Africa Septentrională
      017:Africa Centrală
      018:Africa Meridională
      019:Americi
      021:America Septentrională
      029:Caraibe
      030:Asia Orientală
      034:Asia Meridională
      035:Asia de Sud-Est
      039:Europa Meridională
      053:Australasia
      054:Melanezia
      057:Regiunea Micronezia
      061:Polinezia
      142:Asia
      143:Asia Centrală
      145:Asia Occidentală
      150:Europa
      151:Europa Orientală
      154:Europa Septentrională
      155:Europa Occidentală
      202:Africa Subsahariană
      419:America Latină
      AC:Insula Ascension
      AD:Andorra
      AE:Emiratele Arabe Unite
      AF:Afganistan
      AG:Antigua și Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarctica
      AR:Argentina
      AS:Samoa Americană
      AT:Austria
      AU:Australia
      AW:Aruba
      AX:Insulele Åland
      AZ:Azerbaidjan
      BA:Bosnia și Herțegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgia
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Saint-Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BQ:Insulele Caraibe Olandeze
      BR:Brazilia
      BS:Bahamas
      BT:Bhutan
      BV:Insula Bouvet
      BW:Botswana
      BY:Belarus
      BZ:Belize
      CA:Canada
      CC:Insulele Cocos (Keeling)
      CD:Congo - Kinshasa
      CF:Republica Centrafricană
      CG:Congo - Brazzaville
      CH:Elveția
      CI:Côte d’Ivoire
      CK:Insulele Cook
      CL:Chile
      CM:Camerun
      CN:China
      CO:Columbia
      CP:Insula Clipperton
      CR:Costa Rica
      CU:Cuba
      CV:Capul Verde
      CW:Curaçao
      CX:Insula Christmas
      CY:Cipru
      CZ:Cehia
      DE:Germania
      DG:Diego Garcia
      DJ:Djibouti
      DK:Danemarca
      DM:Dominica
      DO:Republica Dominicană
      DZ:Algeria
      EA:Ceuta și Melilla
      EC:Ecuador
      EE:Estonia
      EG:Egipt
      EH:Sahara Occidentală
      ER:Eritreea
      ES:Spania
      ET:Etiopia
      EU:Uniunea Europeană
      EZ:Zona euro
      FI:Finlanda
      FJ:Fiji
      FK:Insulele Falkland
      FM:Micronezia
      FO:Insulele Feroe
      FR:Franța
      GA:Gabon
      GB:Regatul Unit
      GD:Grenada
      GE:Georgia
      GF:Guyana Franceză
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Groenlanda
      GM:Gambia
      GN:Guineea
      GP:Guadelupa
      GQ:Guineea Ecuatorială
      GR:Grecia
      GS:Georgia de Sud și Insulele Sandwich de Sud
      GT:Guatemala
      GU:Guam
      GW:Guineea-Bissau
      GY:Guyana
      HK:R.A.S. Hong Kong, China
      HM:Insula Heard și Insulele McDonald
      HN:Honduras
      HR:Croația
      HT:Haiti
      HU:Ungaria
      IC:Insulele Canare
      ID:Indonezia
      IE:Irlanda
      IL:Israel
      IM:Insula Man
      IN:India
      IO:Teritoriul Britanic din Oceanul Indian
      IQ:Irak
      IR:Iran
      IS:Islanda
      IT:Italia
      JE:Jersey
      JM:Jamaica
      JO:Iordania
      JP:Japonia
      KE:Kenya
      KG:Kârgâzstan
      KH:Cambodgia
      KI:Kiribati
      KM:Comore
      KN:Saint Kitts și Nevis
      KP:Coreea de Nord
      KR:Coreea de Sud
      KW:Kuweit
      KY:Insulele Cayman
      KZ:Kazahstan
      LA:Laos
      LB:Liban
      LC:Sfânta Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lituania
      LU:Luxemburg
      LV:Letonia
      LY:Libia
      MA:Maroc
      MC:Monaco
      MD:Republica Moldova
      ME:Muntenegru
      MF:Sfântul Martin
      MG:Madagascar
      MH:Insulele Marshall
      MK:Macedonia de Nord
      ML:Mali
      MM:Myanmar (Birmania)
      MN:Mongolia
      MO:R.A.S. Macao, China
      MP:Insulele Mariane de Nord
      MQ:Martinica
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldive
      MW:Malawi
      MX:Mexic
      MY:Malaysia
      MZ:Mozambic
      NA:Namibia
      NC:Noua Caledonie
      NE:Niger
      NF:Insula Norfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Țările de Jos
      NO:Norvegia
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Noua Zeelandă
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Polinezia Franceză
      PG:Papua-Noua Guinee
      PH:Filipine
      PK:Pakistan
      PL:Polonia
      PM:Saint-Pierre și Miquelon
      PN:Insulele Pitcairn
      PR:Puerto Rico
      PS:Teritoriile Palestiniene
      PT:Portugalia
      PW:Palau
      PY:Paraguay
      QA:Qatar
      QO:Oceania Periferică
      RE:Réunion
      RO:România
      RS:Serbia
      RU:Rusia
      RW:Rwanda
      SA:Arabia Saudită
      SB:Insulele Solomon
      SC:Seychelles
      SD:Sudan
      SE:Suedia
      SG:Singapore
      SH:Sfânta Elena
      SI:Slovenia
      SJ:Svalbard și Jan Mayen
      SK:Slovacia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      SS:Sudanul de Sud
      ST:São Tomé și Príncipe
      SV:El Salvador
      SX:Sint-Maarten
      SY:Siria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Insulele Turks și Caicos
      TD:Ciad
      TF:Teritoriile Australe și Antarctice Franceze
      TG:Togo
      TH:Thailanda
      TJ:Tadjikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turcia
      TT:Trinidad și Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ucraina
      UG:Uganda
      UM:Insulele Îndepărtate ale S.U.A.
      UN:Națiunile Unite
      US:Statele Unite ale Americii
      UY:Uruguay
      UZ:Uzbekistan
      VA:Statul Cetății Vaticanului
      VC:Saint Vincent și Grenadinele
      VE:Venezuela
      VG:Insulele Virgine Britanice
      VI:Insulele Virgine Americane
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis și Futuna
      WS:Samoa
      XA:Pseudo-accente
      XB:Pseudo-Bidi
      XK:Kosovo
      YE:Yemen
      YT:Mayotte
      ZA:Africa de Sud
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:Regiune necunoscută
      """.trimIndent() }

  val ro_MD: String by lazy { """
      MM:Myanmar
      """.trimIndent() }

  val rof: String by lazy { """
      AD:Andoro
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Babuda
      AI:Anguila
      AL:Albania
      AM:Amenia
      AO:Angolo
      AR:Ajentina
      AS:Samoa ya Marekani
      AT:Ostria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babado
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahamasi
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misri
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Ufaransa
      GA:Gaboni
      GB:Uingereza
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kaimai
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Rwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukraini
      UG:Uganda
      US:Marekani
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val ru: String by lazy { """
      001:весь мир
      002:Африка
      003:Северная Америка
      005:Южная Америка
      009:Океания
      011:Западная Африка
      013:Центральная Америка
      014:Восточная Африка
      015:Северная Африка
      017:Центральная Африка
      018:Южная Африка
      019:Америка
      021:Североамериканский регион
      029:Карибы
      030:Восточная Азия
      034:Южная Азия
      035:Юго-Восточная Азия
      039:Южная Европа
      053:Австралазия
      054:Меланезия
      057:Микронезия
      061:Полинезия
      142:Азия
      143:Центральная Азия
      145:Западная Азия
      150:Европа
      151:Восточная Европа
      154:Северная Европа
      155:Западная Европа
      202:Тропическая Африка
      419:Латинская Америка
      AC:о-в Вознесения
      AD:Андорра
      AE:ОАЭ
      AF:Афганистан
      AG:Антигуа и Барбуда
      AI:Ангилья
      AL:Албания
      AM:Армения
      AO:Ангола
      AQ:Антарктида
      AR:Аргентина
      AS:Американское Самоа
      AT:Австрия
      AU:Австралия
      AW:Аруба
      AX:Аландские о-ва
      AZ:Азербайджан
      BA:Босния и Герцеговина
      BB:Барбадос
      BD:Бангладеш
      BE:Бельгия
      BF:Буркина-Фасо
      BG:Болгария
      BH:Бахрейн
      BI:Бурунди
      BJ:Бенин
      BL:Сен-Бартелеми
      BM:Бермудские о-ва
      BN:Бруней
      BO:Боливия
      BQ:Бонэйр, Синт-Эстатиус и Саба
      BR:Бразилия
      BS:Багамы
      BT:Бутан
      BV:о-в Буве
      BW:Ботсвана
      BY:Беларусь
      BZ:Белиз
      CA:Канада
      CC:Кокосовые о-ва
      CD:Конго - Киншаса
      CF:Центрально-Африканская Республика
      CG:Конго - Браззавиль
      CH:Швейцария
      CI:Кот-д’Ивуар
      CK:о-ва Кука
      CL:Чили
      CM:Камерун
      CN:Китай
      CO:Колумбия
      CP:о-в Клиппертон
      CR:Коста-Рика
      CU:Куба
      CV:Кабо-Верде
      CW:Кюрасао
      CX:о-в Рождества
      CY:Кипр
      CZ:Чехия
      DE:Германия
      DG:Диего-Гарсия
      DJ:Джибути
      DK:Дания
      DM:Доминика
      DO:Доминиканская Республика
      DZ:Алжир
      EA:Сеута и Мелилья
      EC:Эквадор
      EE:Эстония
      EG:Египет
      EH:Западная Сахара
      ER:Эритрея
      ES:Испания
      ET:Эфиопия
      EU:Европейский союз
      EZ:еврозона
      FI:Финляндия
      FJ:Фиджи
      FK:Фолклендские о-ва
      FM:Федеративные Штаты Микронезии
      FO:Фарерские о-ва
      FR:Франция
      GA:Габон
      GB:Великобритания
      GD:Гренада
      GE:Грузия
      GF:Французская Гвиана
      GG:Гернси
      GH:Гана
      GI:Гибралтар
      GL:Гренландия
      GM:Гамбия
      GN:Гвинея
      GP:Гваделупа
      GQ:Экваториальная Гвинея
      GR:Греция
      GS:Южная Георгия и Южные Сандвичевы о-ва
      GT:Гватемала
      GU:Гуам
      GW:Гвинея-Бисау
      GY:Гайана
      HK:Гонконг (САР)
      HM:о-ва Херд и Макдональд
      HN:Гондурас
      HR:Хорватия
      HT:Гаити
      HU:Венгрия
      IC:Канарские о-ва
      ID:Индонезия
      IE:Ирландия
      IL:Израиль
      IM:о-в Мэн
      IN:Индия
      IO:Британская территория в Индийском океане
      IQ:Ирак
      IR:Иран
      IS:Исландия
      IT:Италия
      JE:Джерси
      JM:Ямайка
      JO:Иордания
      JP:Япония
      KE:Кения
      KG:Киргизия
      KH:Камбоджа
      KI:Кирибати
      KM:Коморы
      KN:Сент-Китс и Невис
      KP:КНДР
      KR:Республика Корея
      KW:Кувейт
      KY:о-ва Кайман
      KZ:Казахстан
      LA:Лаос
      LB:Ливан
      LC:Сент-Люсия
      LI:Лихтенштейн
      LK:Шри-Ланка
      LR:Либерия
      LS:Лесото
      LT:Литва
      LU:Люксембург
      LV:Латвия
      LY:Ливия
      MA:Марокко
      MC:Монако
      MD:Молдова
      ME:Черногория
      MF:Сен-Мартен
      MG:Мадагаскар
      MH:Маршалловы о-ва
      MK:Северная Македония
      ML:Мали
      MM:Мьянма (Бирма)
      MN:Монголия
      MO:Макао (САР)
      MP:Северные Марианские о-ва
      MQ:Мартиника
      MR:Мавритания
      MS:Монтсеррат
      MT:Мальта
      MU:Маврикий
      MV:Мальдивы
      MW:Малави
      MX:Мексика
      MY:Малайзия
      MZ:Мозамбик
      NA:Намибия
      NC:Новая Каледония
      NE:Нигер
      NF:о-в Норфолк
      NG:Нигерия
      NI:Никарагуа
      NL:Нидерланды
      NO:Норвегия
      NP:Непал
      NR:Науру
      NU:Ниуэ
      NZ:Новая Зеландия
      OM:Оман
      PA:Панама
      PE:Перу
      PF:Французская Полинезия
      PG:Папуа — Новая Гвинея
      PH:Филиппины
      PK:Пакистан
      PL:Польша
      PM:Сен-Пьер и Микелон
      PN:о-ва Питкэрн
      PR:Пуэрто-Рико
      PS:Палестинские территории
      PT:Португалия
      PW:Палау
      PY:Парагвай
      QA:Катар
      QO:Внешняя Океания
      RE:Реюньон
      RO:Румыния
      RS:Сербия
      RU:Россия
      RW:Руанда
      SA:Саудовская Аравия
      SB:Соломоновы о-ва
      SC:Сейшельские о-ва
      SD:Судан
      SE:Швеция
      SG:Сингапур
      SH:о-в Св. Елены
      SI:Словения
      SJ:Шпицберген и Ян-Майен
      SK:Словакия
      SL:Сьерра-Леоне
      SM:Сан-Марино
      SN:Сенегал
      SO:Сомали
      SR:Суринам
      SS:Южный Судан
      ST:Сан-Томе и Принсипи
      SV:Сальвадор
      SX:Синт-Мартен
      SY:Сирия
      SZ:Эсватини
      TA:Тристан-да-Кунья
      TC:Тёркс и Кайкос
      TD:Чад
      TF:Французские Южные территории
      TG:Того
      TH:Таиланд
      TJ:Таджикистан
      TK:Токелау
      TL:Восточный Тимор
      TM:Туркменистан
      TN:Тунис
      TO:Тонга
      TR:Турция
      TT:Тринидад и Тобаго
      TV:Тувалу
      TW:Тайвань
      TZ:Танзания
      UA:Украина
      UG:Уганда
      UM:Внешние малые о-ва (США)
      UN:Организация Объединенных Наций
      US:Соединенные Штаты
      UY:Уругвай
      UZ:Узбекистан
      VA:Ватикан
      VC:Сент-Винсент и Гренадины
      VE:Венесуэла
      VG:Виргинские о-ва (Великобритания)
      VI:Виргинские о-ва (США)
      VN:Вьетнам
      VU:Вануату
      WF:Уоллис и Футуна
      WS:Самоа
      XA:псевдоакценты
      XB:псевдо-Bidi
      XK:Косово
      YE:Йемен
      YT:Майотта
      ZA:Южно-Африканская Республика
      ZM:Замбия
      ZW:Зимбабве
      ZZ:неизвестный регион
      """.trimIndent() }

  val ru_BY: String? = null

  val ru_KG: String? = null

  val ru_KZ: String? = null

  val ru_MD: String? = null

  val ru_UA: String by lazy { """
      AC:О-в Вознесения
      AE:Объединенные Арабские Эмираты
      BV:О-в Буве
      CK:О-ва Кука
      CP:О-в Клиппертон
      CX:О-в Рождества
      HM:О-ва Херд и Макдональд
      NF:О-в Норфолк
      TL:Тимор-Лесте
      UM:Малые Тихоокеанские Отдаленные Острова США
      """.trimIndent() }

  val rw: String by lazy { """
      MK:Masedoniya y’Amajyaruguru
      RW:U Rwanda
      TO:Tonga
      """.trimIndent() }

  val rwk: String by lazy { """
      AD:Andora
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Marekani
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misri
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Ufaransa
      GA:Gaboni
      GB:Uingereza
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Rwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukraini
      UG:Uganda
      US:Marekani
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val sa: String by lazy { """
      BR:ब्राजील
      CN:"चीन:"
      DE:"जर्मनीदेश:"
      FR:"फ़्रांस:"
      GB:"संयुक्त राष्ट्र:"
      IN:भारतः
      IT:"इटली:"
      JP:"जापन:"
      RU:"रष्यदेश:"
      US:"संयुक्त राज्य:"
      ZZ:"अज्ञात क्षेत्र:"
      """.trimIndent() }

  val sah: String by lazy { """
      001:Аан дойду
      002:Аапырыка
      003:Хотугу Эмиэрикэ
      005:Соҕуруу Эмиэрикэ
      BR:Бразилия
      CA:Канаада
      CL:Чиили
      CN:Кытай
      CU:Кууба
      EE:Эстония
      FI:Финляндия
      GB:Улуу Британия
      IE:Ирландия
      IM:Мэн арыы
      IS:Исландия
      JM:Дьамаайка
      LT:Литва
      LV:Латвия
      LY:Лиибийэ
      MX:Миэксикэ
      NO:Норвегия
      RU:Арассыыйа
      SD:Судаан
      SE:Швеция
      US:Америка Холбоһуктаах Штааттара
      """.trimIndent() }

  val saq: String by lazy { """
      AD:Andora
      AE:Falme za Kiarabu
      AF:Afuganistani
      AG:Antigua na Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ya Marekani
      AT:Austria
      AU:Australia
      AW:Aruba
      AZ:Azabajani
      BA:Bosnia na Hezegovina
      BB:Babadosi
      BD:Bangladeshi
      BE:Ubelgiji
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brazili
      BS:Bahama
      BT:Butani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Jamhuri ya Kidemokrasia ya Kongo
      CF:Jamhuri ya Afrika ya Kati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaa
      CK:Visiwa vya Cook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Kuba
      CV:Kepuvede
      CY:Kuprosi
      CZ:Jamhuri ya Cheki
      DE:Ujerumani
      DJ:Jibuti
      DK:Denmaki
      DM:Dominika
      DO:Jamhuri ya Dominika
      DZ:Aljeria
      EC:Ekwado
      EE:Estonia
      EG:Misri
      ER:Eritrea
      ES:Hispania
      ET:Uhabeshi
      FI:Ufini
      FJ:Fiji
      FK:Visiwa vya Falkland
      FM:Mikronesia
      FR:Ufaransa
      GA:Gaboni
      GB:Uingereza
      GD:Grenada
      GE:Jojia
      GF:Gwiyana ya Ufaransa
      GH:Ghana
      GI:Jibralta
      GL:Grinlandi
      GM:Gambia
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Ugiriki
      GT:Gwatemala
      GU:Gwam
      GW:Ginebisau
      GY:Guyana
      HN:Hondurasi
      HR:Korasia
      HT:Haiti
      HU:Hungaria
      ID:Indonesia
      IE:Ayalandi
      IL:Israeli
      IN:India
      IQ:Iraki
      IR:Uajemi
      IS:Aislandi
      IT:Italia
      JM:Jamaika
      JO:Yordani
      JP:Japani
      KE:Kenya
      KG:Kirigizistani
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Santakitzi na Nevis
      KP:Korea Kaskazini
      KR:Korea Kusini
      KW:Kuwaiti
      KY:Visiwa vya Kayman
      KZ:Kazakistani
      LA:Laosi
      LB:Lebanoni
      LC:Santalusia
      LI:Lishenteni
      LK:Sirilanka
      LR:Liberia
      LS:Lesoto
      LT:Litwania
      LU:Lasembagi
      LV:Lativia
      LY:Libya
      MA:Moroko
      MC:Monako
      MD:Moldova
      MG:Bukini
      MH:Visiwa vya Marshal
      ML:Mali
      MM:Myama
      MN:Mongolia
      MP:Visiwa vya Mariana vya Kaskazini
      MQ:Martiniki
      MR:Moritania
      MS:Montserrati
      MT:Malta
      MU:Morisi
      MV:Modivu
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Msumbiji
      NA:Namibia
      NC:Nyukaledonia
      NE:Nijeri
      NF:Kisiwa cha Norfok
      NG:Nijeria
      NI:Nikaragwa
      NL:Uholanzi
      NO:Norwe
      NP:Nepali
      NR:Nauru
      NU:Niue
      NZ:Nyuzilandi
      OM:Omani
      PA:Panama
      PE:Peru
      PF:Polinesia ya Ufaransa
      PG:Papua
      PH:Filipino
      PK:Pakistani
      PL:Polandi
      PM:Santapieri na Mikeloni
      PN:Pitkairni
      PR:Pwetoriko
      PS:Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina
      PT:Ureno
      PW:Palau
      PY:Paragwai
      QA:Katari
      RE:Riyunioni
      RO:Romania
      RU:Urusi
      RW:Rwanda
      SA:Saudi
      SB:Visiwa vya Solomon
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Slovenia
      SK:Slovakia
      SL:Siera Leoni
      SM:Samarino
      SN:Senegali
      SO:Somalia
      SR:Surinamu
      ST:Sao Tome na Principe
      SV:Elsavado
      SY:Siria
      SZ:Uswazi
      TC:Visiwa vya Turki na Kaiko
      TD:Chadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikistani
      TK:Tokelau
      TL:Timori ya Mashariki
      TM:Turukimenistani
      TN:Tunisia
      TO:Tonga
      TR:Uturuki
      TT:Trinidad na Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tanzania
      UA:Ukraini
      UG:Uganda
      US:Marekani
      UY:Urugwai
      UZ:Uzibekistani
      VA:Vatikani
      VC:Santavisenti na Grenadini
      VE:Venezuela
      VG:Visiwa vya Virgin vya Uingereza
      VI:Visiwa vya Virgin vya Marekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walis na Futuna
      WS:Samoa
      YE:Yemeni
      YT:Mayotte
      ZA:Afrika Kusini
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val sat: String by lazy { """
      BR:ᱵᱨᱟᱡᱤᱞ
      CN:ᱪᱤᱱ
      DE:ᱡᱟᱨᱢᱟᱱᱤ
      FR:ᱯᱷᱨᱟᱱᱥ
      GB:ᱭᱩᱱᱤᱭᱴᱮᱰ ᱠᱤᱝᱰᱚᱢ
      IN:ᱤᱱᱰᱤᱭᱟ
      IT:ᱤᱴᱞᱤ
      JP:ᱡᱟᱯᱟᱱ
      RU:ᱨᱩᱥ
      US:ᱭᱩᱱᱟᱭᱴᱮᱰ ᱮᱥᱴᱮᱴ
      ZZ:ᱵᱟᱝᱩᱨᱩᱢ ᱴᱚᱴᱷᱟ
      """.trimIndent() }

  val sat_Olck: String? = null

  val sbp: String by lazy { """
      AD:Andola
      AE:Wutwa wa shiyalabu
      AF:Afuganisitani
      AG:Anitiguya ni Balubuda
      AI:Anguilla
      AL:Alubaniya
      AM:Alimeniya
      AO:Angola
      AR:Ajentina
      AS:Samoya ya Malekani
      AT:Awusitiliya
      AU:Awusitilaliya
      AW:Aluba
      AZ:Asabajani
      BA:Bosiniya ni Hesegovina
      BB:Babadosi
      BD:Bangiladeshi
      BE:Ubeligiji
      BF:Bukinafaso
      BG:Buligaliya
      BH:Bahaleni
      BI:Bulundi
      BJ:Benini
      BM:Belimuda
      BN:Buluneyi
      BO:Boliviya
      BR:Bulasili
      BS:Bahama
      BT:Butani
      BW:Botiswana
      BY:Belalusi
      BZ:Belise
      CA:Kanada
      CD:Jamuhuli ya Kidemokilasiya ya Kongo
      CF:Jamuhuli ya Afilika ya Pakhati
      CG:Kongo
      CH:Uswisi
      CI:Kodivaya
      CK:Figunguli fya Kooki
      CL:Shile
      CM:Kameruni
      CN:Shina
      CO:Kolombiya
      CR:Kositalika
      CU:Kuba
      CV:Kepuvede
      CY:Kupilosi
      CZ:Jamuhuli ya Sheki
      DE:Wujelumani
      DJ:Jibuti
      DK:Denimaki
      DM:Dominika
      DO:Jamuhuli ya Dominika
      DZ:Alijeliya
      EC:Ekwado
      EE:Esitoniya
      EG:Misili
      ER:Elitileya
      ES:Hisipaniya
      ET:Uhabeshi
      FI:Wufini
      FJ:Fiji
      FK:Figunguli fya Fokolendi
      FM:Mikilonesiya
      FR:Wufalansa
      GA:Gaboni
      GB:Uwingelesa
      GD:Gilenada
      GE:Jojiya
      GF:Gwiyana ya Wufalansa
      GH:Khana
      GI:Jibulalita
      GL:Gilinilandi
      GM:Gambiya
      GN:Gine
      GP:Gwadelupe
      GQ:Ginekweta
      GR:Wugiliki
      GT:Gwatemala
      GU:Gwamu
      GW:Ginebisawu
      GY:Guyana
      HN:Hondulasi
      HR:Kolasiya
      HT:Hayiti
      HU:Hungaliya
      ID:Indonesiya
      IE:Ayalandi
      IL:Isilaeli
      IN:Indiya
      IQ:Ilaki
      IR:Uwajemi
      IS:Ayisilendi
      IT:Italiya
      JM:Jamaika
      JO:Yolodani
      JP:Japani
      KE:Kenya
      KG:Kiligisisitani
      KH:Kambodiya
      KI:Kilibati
      KM:Komolo
      KN:Santakitisi ni Nevisi
      KP:Koleya ya luvala lwa Kunyamande
      KR:Koleya ya Kusini
      KW:Kuwaiti
      KY:Figunguli ifya Kayimayi
      KZ:Kasakisitani
      LA:Layosi
      LB:Lebanoni
      LC:Santalusiya
      LI:Lisheniteni
      LK:Sililanka
      LR:Libeliya
      LS:Lesoto
      LT:Litwaniya
      LU:Lasembagi
      LV:Lativiya
      LY:Libiya
      MA:Moloko
      MC:Monako
      MD:Molidova
      MG:Bukini
      MH:Figunguli ifya Malishali
      ML:Mali
      MM:Muyama
      MN:Mongoliya
      MP:Figunguli fya Maliyana ifya luvala lwa Kunyamande
      MQ:Malitiniki
      MR:Molitaniya
      MS:Monitiselati
      MT:Malita
      MU:Molisi
      MV:Modivu
      MW:Malawi
      MX:Mekisiko
      MY:Malesiya
      MZ:Musumbiji
      NA:Namibiya
      NC:Nyukaledoniya
      NE:Nijeli
      NF:Shigunguli sha Nolifoki
      NG:Nijeliya
      NI:Nikalagwa
      NL:Wuholansi
      NO:Nolwe
      NP:Nepali
      NR:Nawulu
      NU:Niwue
      NZ:Nyusilendi
      OM:Omani
      PA:Panama
      PE:Pelu
      PF:Polinesiya ya Wufalansa
      PG:Papuwa
      PH:Filipino
      PK:Pakisitani
      PL:Polandi
      PM:Santapieli ni Mikeloni
      PN:Pitikailini
      PR:Pwetoliko
      PS:Munjema gwa Kusikha nu Luvala lwa Gasa lwa Palesit
      PT:Wuleno
      PW:Palawu
      PY:Palagwayi
      QA:Katali
      RE:Liyunioni
      RO:Lomaniya
      RU:Wulusi
      RW:Lwanda
      SA:Sawudi
      SB:Figunguli fya Solomoni
      SC:Shelisheli
      SD:Sudani
      SE:Uswidi
      SG:Singapoo
      SH:Santahelena
      SI:Siloveniya
      SK:Silovakiya
      SL:Siela Liyoni
      SM:Samalino
      SN:Senegali
      SO:Somaliya
      SR:Sulinamu
      ST:Sayo Tome ni Pilinikipe
      SV:Elisavado
      SY:Siliya
      SZ:Uswasi
      TC:Figunguli fya Tuliki ni Kaiko
      TD:Shadi
      TG:Togo
      TH:Tailandi
      TJ:Tajikisitani
      TK:Tokelawu
      TL:Timoli ya kunena
      TM:Tulukimenisitani
      TN:Tunisiya
      TO:Tonga
      TR:Utuluki
      TT:Tilinidadi ni Tobago
      TV:Tuvalu
      TW:Taiwani
      TZ:Tansaniya
      UA:Yukileini
      UG:Uganda
      US:Malekani
      UY:Ulugwayi
      UZ:Usibekisitani
      VA:Vatikani
      VC:Santavisenti na Gilenadini
      VE:Venesuela
      VG:Figunguli ifya Viliginiya ifya Uwingelesa
      VI:Figunguli fya Viliginiya ifya Malekani
      VN:Vietinamu
      VU:Vanuatu
      WF:Walisi ni Futuna
      WS:Samoya
      YE:Yemeni
      YT:Mayote
      ZA:Afilika Kusini
      ZM:Sambiya
      ZW:Simbabwe
      """.trimIndent() }

  val sc: String by lazy { """
      001:Mundu
      002:Àfrica
      003:Amèrica de su Nord
      005:Amèrica de su Sud
      009:Otzeània
      011:Àfrica otzidentale
      013:Amèrica tzentrale
      014:Àfrica orientale
      015:Àfrica setentrionale
      017:Àfrica tzentrale
      018:Àfrica meridionale
      019:Amèricas
      021:Amèrica setentrionale
      029:Caràibes
      030:Àsia orientale
      034:Àsia meridionale
      035:Sud-est asiàticu
      039:Europa meridionale
      053:Australàsia
      054:Melanèsia
      057:Regione micronesiana
      061:Polinèsia
      142:Àsia
      143:Àsia tzentrale
      145:Àsia otzidentale
      150:Europa
      151:Europa orientale
      154:Europa setentrionale
      155:Europa otzidentale
      202:Àfrica sub-sahariana
      419:Amèrica latina
      AC:Ìsula de s’Ascensione
      AD:Andorra
      AE:Emirados Àrabos Unidos
      AF:Afghànistan
      AG:Antigua e Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armènia
      AO:Angola
      AQ:Antàrticu
      AR:Argentina
      AS:Samoa americanas
      AT:Àustria
      AU:Austràlia
      AW:Aruba
      AX:Ìsulas Åland
      AZ:Azerbaigiàn
      BA:Bòsnia e Erzegòvina
      BB:Barbados
      BD:Bangladèsh
      BE:Bèlgiu
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Santu Bartolomeu
      BM:Bermudas
      BN:Brunei
      BO:Bolìvia
      BQ:Caràibes olandesas
      BR:Brasile
      BS:Bahamas
      BT:Bhutàn
      BV:Ìsula Bouvet
      BW:Botswana
      BY:Bielorùssia
      BZ:Belize
      CA:Cànada
      CC:Ìsulas Cocos (Keeling)
      CD:Congo - Kinshasa
      CF:Repùblica Tzentrafricana
      CG:Congo - Bratzaville
      CH:Isvìtzera
      CI:Costa de Avòriu
      CK:Ìsulas Cook
      CL:Tzile
      CM:Camerùn
      CN:Tzina
      CO:Colòmbia
      CP:Ìsula de Clipperton
      CQ:Sark
      CR:Costa Rica
      CU:Cuba
      CV:Cabu birde
      CW:Curaçao
      CX:Ìsula de sa Natividade
      CY:Tzipru
      CZ:Tzèchia
      DE:Germània
      DG:Diego Garcia
      DJ:Gibuti
      DK:Danimarca
      DM:Dominica
      DO:Repùblica Dominicana
      DZ:Algeria
      EA:Ceuta e Melilla
      EC:Ècuador
      EE:Estònia
      EG:Egitu
      EH:Sahara otzidentale
      ER:Eritrea
      ES:Ispagna
      ET:Etiòpia
      EU:Unione Europea
      EZ:Eurozona
      FI:Finlàndia
      FJ:Fiji
      FK:Ìsulas Falkland
      FM:Micronèsia
      FO:Ìsulas Føroyar
      FR:Frantza
      GA:Gabòn
      GB:Regnu Unidu
      GD:Grenada
      GE:Geòrgia
      GF:Guiana frantzesa
      GG:Guernsey
      GH:Ghana
      GI:Gibilterra
      GL:Groenlàndia
      GM:Gàmbia
      GN:Guinea
      GP:Guadalupa
      GQ:Guinea Ecuadoriale
      GR:Grètzia
      GS:Geòrgia de su Sud e Ìsulas Sandwich Australes
      GT:Guatemala
      GU:Guàm
      GW:Guinea-Bissau
      GY:Guyana
      HK:RAS tzinesa de Hong Kong
      HM:Ìsulas Heard e McDonald
      HN:Honduras
      HR:Croàtzia
      HT:Haiti
      HU:Ungheria
      IC:Ìsulas Canàrias
      ID:Indonèsia
      IE:Irlanda
      IL:Israele
      IM:Ìsula de Man
      IN:Ìndia
      IO:Territòriu Britànnicu de s’Otzèanu Indianu
      IQ:Iraq
      IR:Iràn
      IS:Islanda
      IT:Itàlia
      JE:Jersey
      JM:Giamàica
      JO:Giordània
      JP:Giapone
      KE:Kènya
      KG:Kirghìzistan
      KH:Cambòdia
      KI:Kiribati
      KM:Comoras
      KN:Santu Cristolu e Nevis
      KP:Corea de su Nord
      KR:Corea de su Sud
      KW:Kuwait
      KY:Ìsulas Cayman
      KZ:Kazàkistan
      LA:Laos
      LB:Lèbanu
      LC:Santa Lughia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Libèria
      LS:Lesotho
      LT:Lituània
      LU:Lussemburgu
      LV:Letònia
      LY:Lìbia
      MA:Marocu
      MC:Mònacu
      MD:Moldàvia
      ME:Montenegro
      MF:Santu Martine
      MG:Madagascàr
      MH:Ìsulas Marshall
      MK:Matzedònia de su Nord
      ML:Mali
      MM:Myanmàr (Birmània)
      MN:Mongòlia
      MO:RAS tzinesa de Macao
      MP:Ìsulas Mariannas setentrionales
      MQ:Martinica
      MR:Mauritània
      MS:Montserrat
      MT:Malta
      MU:Maurìtzius
      MV:Maldivas
      MW:Malawi
      MX:Mèssicu
      MY:Malèsia
      MZ:Mozambicu
      NA:Namìbia
      NC:Caledònia Noa
      NE:Niger
      NF:Ìsula Norfolk
      NG:Nigèria
      NI:Nicaràgua
      NL:Paisos Bassos
      NO:Norvègia
      NP:Nèpal
      NR:Nauru
      NU:Niue
      NZ:Zelanda Noa
      OM:Omàn
      PA:Pànama
      PE:Perù
      PF:Polinèsia frantzesa
      PG:Pàpua Guinea Noa
      PH:Filipinas
      PK:Pàkistan
      PL:Polònia
      PM:Santu Predu e Miquelon
      PN:Ìsulas Pìtcairn
      PR:Puerto Rico
      PS:Territòrios palestinesos
      PT:Portogallu
      PW:Palau
      PY:Paraguày
      QA:Catar
      QO:Otzeània perifèrica
      RE:Riunione
      RO:Romania
      RS:Sèrbia
      RU:Rùssia
      RW:Ruanda
      SA:Aràbia Saudita
      SB:Ìsulas Salomone
      SC:Seychelles
      SD:Sudàn
      SE:Isvètzia
      SG:Singapore
      SH:Santa Elene
      SI:Islovènia
      SJ:Svalbard e Jan Mayen
      SK:Islovàchia
      SL:Sierra Leone
      SM:Santu Marinu
      SN:Senegal
      SO:Somàlia
      SR:Suriname
      SS:Sudan de su Sud
      ST:São Tomé e Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Sìria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Ìsulas Turks e Caicos
      TD:Chad
      TF:Terras australes frantzesas
      TG:Togo
      TH:Tailàndia
      TJ:Tagìkistan
      TK:Tokelau
      TL:Timor-Est
      TM:Turkmènistan
      TN:Tunisia
      TO:Tonga
      TR:Turchia
      TT:Trinidad e Tobago
      TV:Tuvalu
      TW:Taiwàn
      TZ:Tanzània
      UA:Ucraina
      UG:Uganda
      UM:Ìsulas perifèricas de sos Istados Unidos
      UN:Natziones Unidas
      US:Istados Unidos
      UY:Uruguày
      UZ:Uzbèkistan
      VA:Tzitade de su Vaticanu
      VC:Santu Vissente e sas Grenadinas
      VE:Venetzuela
      VG:Ìsulas Vèrgines Britànnicas
      VI:Ìsulas Vèrgines de sos Istados Unidos
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis e Futuna
      WS:Samoa
      XA:psèudo-atzentos
      XB:psèudo-bidi
      XK:Kòssovo
      YE:Yemen
      YT:Mayotte
      ZA:Sudàfrica
      ZM:Zàmbia
      ZW:Zimbabwe
      ZZ:regione disconnota
      """.trimIndent() }

  val sd: String by lazy { """
      001:دنيا
      002:آفريڪا
      003:اتر آمريڪا
      005:ڏکڻ آمريڪا
      009:اوشنيا
      011:اولهه آفريقا
      013:وچ آمريڪا
      014:اوڀر آفريڪا
      015:اتر آفريڪا
      017:وچ آفريڪا
      018:ڏاکڻي آمريڪا
      019:آمريڪا
      021:اترين آمريڪا
      029:ڪيريبين
      030:اوڀر ايشيا
      034:ڏکڻ ايشيا
      035:ڏکڻ اوڀر ايشيا
      039:ڏکڻ يورپ
      053:آسٽریلیشیا
      054:میلانیشیا
      057:مائڪرونيشائي خطو
      061:پولینیشیا
      142:ايشيا
      143:وچ ايشيا
      145:اولهه ايشيا
      150:يورپ
      151:اوڀر يورپ
      154:اترين يورپ
      155:اولهه يورپ
      202:سب-سهارا آفريڪا
      419:لاطيني آمريڪا
      AC:طلوع ٻيٽ
      AD:اندورا
      AE:متحده عرب امارات
      AF:افغانستان
      AG:انٽيگا ۽ باربد
      AI:انگويلا
      AL:البانيا
      AM:ارمینیا
      AO:انگولا
      AQ:انٽارڪٽيڪا
      AR:ارجنٽينا
      AS:آمريڪي ساموا
      AT:آسٽريا
      AU:آسٽريليا
      AW:عروبا
      AX:الند ٻيٽ
      AZ:آذربائيجان
      BA:بوسنيا ۽ هرزوگووينا
      BB:باربڊوس
      BD:بنگلاديش
      BE:بيلجيم
      BF:برڪينا فاسو
      BG:بلغاريا
      BH:بحرين
      BI:برونڊي
      BJ:بينن
      BL:سینٽ برٿلیمی
      BM:برمودا
      BN:برونائي
      BO:بوليويا
      BQ:ڪيريبين نيدرلينڊ
      BR:برازيل
      BS:باهاماس
      BT:ڀوٽان
      BV:بووٽ ٻيٽ
      BW:بوٽسوانا
      BY:بیلارس
      BZ:بيليز
      CA:ڪينيڊا
      CC:ڪوڪوس ٻيٽ
      CD:ڪانگو -ڪنشاسا
      CF:وچ آفريقي جمهوريه
      CG:ڪانگو - برازاویل
      CH:سوئزرلينڊ
      CI:ڪوٽي ويرا
      CK:ڪوڪ ٻيٽ
      CL:چلي
      CM:ڪيمرون
      CN:چين
      CO:ڪولمبيا
      CP:ڪلپرٽن ٻيٽ
      CR:ڪوسٽا ريڪا
      CU:ڪيوبا
      CV:ڪيپ وردي
      CW:ڪيوراسائو
      CX:ڪرسمس ٻيٽ
      CY:سائپرس
      CZ:چيڪيا
      DE:جرمني
      DG:ڊئيگو گارسيا
      DJ:ڊجبيوتي
      DK:ڊينمارڪ
      DM:ڊومينيڪا
      DO:ڊومينيڪن جمهوريه
      DZ:الجيريا
      EA:سیوٽا ۽ میلیلا
      EC:ايڪواڊور
      EE:ايسٽونيا
      EG:مصر
      EH:اولهه صحارا
      ER:ايريٽيريا
      ES:اسپين
      ET:ايٿوپيا
      EU:يورپين يونين
      EZ:يورو زون
      FI:فن لينڊ
      FJ:فجي
      FK:فاڪ لينڊ ٻيٽ
      FM:مائڪرونيشيا
      FO:فارو ٻيٽ
      FR:فرانس
      GA:گبون
      GB:برطانيہ
      GD:گريناڊا
      GE:جارجيا
      GF:فرانسيسي گيانا
      GG:گورنسي
      GH:گهانا
      GI:جبرالٽر
      GL:گرين لينڊ
      GM:گيمبيا
      GN:گني
      GP:گواڊیلوپ
      GQ:ايڪوٽوريل گائينا
      GR:يونان
      GS:ڏکڻ جارجيا ۽ ڏکڻ سينڊوچ ٻيٽ
      GT:گوئٽي مالا
      GU:گوام
      GW:گني بسائو
      GY:گيانا
      HK:هانگ ڪانگ SAR
      HM:هرڊ ۽ مڪڊونلڊ ٻيٽ
      HN:هنڊورس
      HR:ڪروئيشيا
      HT:هيٽي
      HU:هنگري
      IC:ڪينري ٻيٽ
      ID:انڊونيشيا
      IE:آئرلينڊ
      IL:اسرائيل
      IM:انسانن جو ٻيٽ
      IN:ڀارت
      IO:برطانوي هندي سمنڊ خطو
      IQ:عراق
      IR:ايران
      IS:آئس لينڊ
      IT:اٽلي
      JE:جرسي
      JM:جميڪا
      JO:اردن
      JP:جاپان
      KE:ڪينيا
      KG:ڪرغستان
      KH:ڪمبوڊيا
      KI:ڪرباتي
      KM:ڪوموروس
      KN:سينٽ ڪٽس و نيوس
      KP:اتر ڪوريا
      KR:ڏکڻ ڪوريا
      KW:ڪويت
      KY:ڪي مين ٻيٽ
      KZ:قازقستان
      LA:لائوس
      LB:لبنان
      LC:سينٽ لوسيا
      LI:لچي ٽينسٽين
      LK:سري لنڪا
      LR:لائبیریا
      LS:ليسوٿو
      LT:لٿونيا
      LU:لگزمبرگ
      LV:لاتويا
      LY:لبيا
      MA:مراڪش
      MC:موناڪو
      MD:مالدووا
      ME:مونٽي نيگرو
      MF:سينٽ مارٽن
      MG:مدگاسڪر
      MH:مارشل ٻيٽ
      MK:اتر مقدونيا
      ML:مالي
      MM:ميانمار (برما)
      MN:منگوليا
      MO:مڪائو SAR چين
      MP:اتريان ماريانا ٻيٽ
      MQ:مارتينڪ
      MR:موريتانيا
      MS:مونٽسراٽ
      MT:مالٽا
      MU:موريشس
      MV:مالديپ
      MW:مالاوي
      MX:ميڪسيڪو
      MY:ملائيشيا
      MZ:موزمبیق
      NA:نيميبيا
      NC:نیو ڪالیڊونیا
      NE:نائيجر
      NF:نورفوڪ ٻيٽ
      NG:نائيجيريا
      NI:نڪراگوا
      NL:نيدرلينڊ
      NO:ناروي
      NP:نيپال
      NR:نائورو
      NU:نووي
      NZ:نيو زيلينڊ
      OM:عمان
      PA:پناما
      PE:پيرو
      PF:فرانسيسي پولينيشيا
      PG:پاپوا نیو گني
      PH:فلپائن
      PK:پاڪستان
      PL:پولينڊ
      PM:سینٽ پیئر و میڪوئیلون
      PN:پٽڪئرن ٻيٽ
      PR:پيوئرٽو ريڪو
      PS:فلسطيني علائقا
      PT:پرتگال
      PW:پلائو
      PY:پيراگوءِ
      QA:قطر
      QO:بيروني سامونڊي
      RE:ري يونين
      RO:رومانيا
      RS:سربيا
      RU:روس
      RW:روانڊا
      SA:سعودي عرب
      SB:سولومون ٻيٽَ
      SC:شي شلز
      SD:سوڊان
      SE:سوئيڊن
      SG:سنگاپور
      SH:سينٽ ھيلينا
      SI:سلوینیا
      SJ:سوالبارڊ ۽ جان ماین
      SK:سلوواڪيا
      SL:سيرا ليون
      SM:سین مرینو
      SN:سينيگال
      SO:سوماليا
      SR:سورينام
      SS:ڏکڻ سوڊان
      ST:سائو ٽوم ۽ پرنسپیي
      SV:ال سلواڊور
      SX:سنٽ مارٽن
      SY:شام
      SZ:ايسواٽني
      TA:ٽرسٽن دا ڪوها
      TC:ترڪ ۽ ڪيڪوس ٻيٽ
      TD:چاڊ
      TF:فرانسيسي ڏاکڻي علائقا
      TG:ٽوگو
      TH:ٿائيليند
      TJ:تاجڪستان
      TK:ٽوڪلائو
      TL:تيمور ليستي
      TM:ترڪمانستان
      TN:تيونيسيا
      TO:ٽونگا
      TR:ترڪييي
      TT:ٽريني ڊيڊ ۽ ٽوباگو ٻيٽ
      TV:توالو
      TW:تائیوان
      TZ:تنزانيا
      UA:يوڪرين
      UG:يوگنڊا
      UM:آمريڪي خارجي ٻيٽ
      UN:گڏيل قومون
      US:آمريڪا جون گڏيل رياستون
      UY:يوروگوءِ
      UZ:ازبڪستان
      VA:ويٽڪين سٽي
      VC:سینٽ ونسنت ۽ گریناڊینز
      VE:وينزويلا
      VG:برطانوي ورجن ٻيٽ
      VI:آمريڪي ورجن ٻيٽ
      VN:ويتنام
      VU:وينيٽيو
      WF:والس ۽ فتونا
      WS:ساموا
      XA:سوڊو-لهجا
      XB:سوڊو-بي ڊي
      XK:ڪوسووو
      YE:يمن
      YT:مياتي
      ZA:ڏکڻ آفريقا
      ZM:زيمبيا
      ZW:زمبابوي
      ZZ:اڻڄاتل خطو
      """.trimIndent() }

  val sd_Arab: String? = null

  val sd_Deva: String by lazy { """
      BR:ब्राज़ील
      CN:चीन
      DE:जर्मनी
      FR:फ़्रांस
      GB:बरतानी
      IN:भारत
      IT:इटली
      JP:जापान
      PK:पाकिस्तान
      RU:रशिया
      US:अमेरिका
      ZZ:अणजातल इलाइको
      """.trimIndent() }

  val se: String by lazy { """
      001:máilbmi
      002:Afrihkká
      003:dávvi-Amerihkká ja gaska-Amerihkká
      005:mátta-Amerihkká
      009:Oseania
      011:oarji-Afrihkká
      013:gaska-Amerihkká
      014:nuorta-Afrihkká
      015:davvi-Afrihkká
      017:gaska-Afrihkká
      018:mátta-Afrihkká
      019:Amerihkká
      021:dávvi-Amerihkká
      029:Karibia
      030:nuorta-Ásia
      034:mátta-Ásia
      035:mátta-nuorta-Ásia
      039:mátta-Eurohpá
      053:Austrália ja Ođđa-Selánda
      054:Melanesia
      057:Mikronesia guovllus
      061:Polynesia
      142:Ásia
      143:gaska-Ásia
      145:oarji-Ásia
      150:Eurohpá
      151:nuorta-Eurohpá
      154:davvi-Eurohpá
      155:oarji-Eurohpá
      419:lulli-Amerihkká
      AC:Ascension
      AD:Andorra
      AE:Ovttastuvvan Arábaemiráhtat
      AF:Afghanistan
      AG:Antigua ja Barbuda
      AI:Anguilla
      AL:Albánia
      AM:Armenia
      AO:Angola
      AQ:Antárktis
      AR:Argentina
      AS:Amerihká Samoa
      AT:Nuortariika
      AU:Austrália
      AW:Aruba
      AX:Ålánda
      AZ:Aserbaižan
      BA:Bosnia-Hercegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgia
      BF:Burkina Faso
      BG:Bulgária
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:Saint Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brasil
      BS:Bahamas
      BT:Bhutan
      BV:Bouvet-sullot
      BW:Botswana
      BY:Vilges-Ruošša
      BZ:Belize
      CA:Kanáda
      CC:Cocos-sullot
      CD:Kongo-Kinshasa
      CF:Gaska-Afrihká dásseváldi
      CG:Kongo-Brazzaville
      CH:Šveica
      CI:Elfenbenariddu
      CK:Cook-sullot
      CL:Čiile
      CM:Kamerun
      CN:Kiinná
      CO:Kolombia
      CP:Clipperton-sullot
      CR:Costa Rica
      CU:Kuba
      CV:Kap Verde
      CW:Curaçao
      CX:Juovllat-sullot
      CY:Kypros
      CZ:Čeahkka
      DE:Duiska
      DG:Diego Garcia
      DJ:Djibouti
      DK:Dánmárku
      DM:Dominica
      DO:Dominikána dásseváldi
      DZ:Algeria
      EA:Ceuta ja Melilla
      EC:Ecuador
      EE:Estlánda
      EG:Egypta
      EH:Oarje-Sahára
      ER:Eritrea
      ES:Spánia
      ET:Etiopia
      EU:Eurohpa Uniovdna
      FI:Suopma
      FJ:Fijisullot
      FK:Falklandsullot
      FM:Mikronesia
      FO:Fearsullot
      FR:Frankriika
      GA:Gabon
      GB:Stuorra-Británnia
      GD:Grenada
      GE:Georgia
      GF:Frankriikka Guayana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Kalaallit Nunaat
      GM:Gámbia
      GN:Guinea
      GP:Guadeloupe
      GQ:Ekvatoriála Guinea
      GR:Greika
      GS:Lulli Georgia ja Lulli Sandwich-sullot
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hongkong
      HM:Heard- ja McDonald-sullot
      HN:Honduras
      HR:Kroátia
      HT:Haiti
      HU:Ungár
      IC:Kanáriasullot
      ID:Indonesia
      IE:Irlánda
      IL:Israel
      IM:Mann-sullot
      IN:India
      IQ:Irak
      IR:Iran
      IS:Islánda
      IT:Itália
      JE:Jersey
      JM:Jamaica
      JO:Jordánia
      JP:Japána
      KE:Kenia
      KG:Kirgisistan
      KH:Kambodža
      KI:Kiribati
      KM:Komoros
      KN:Saint Kitts ja Nevis
      KP:Davvi-Korea
      KR:Mátta-Korea
      KW:Kuwait
      KY:Cayman-sullot
      KZ:Kasakstan
      LA:Laos
      LB:Libanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lietuva
      LU:Luxembourg
      LV:Látvia
      LY:Libya
      MA:Marokko
      MC:Monaco
      MD:Moldávia
      ME:Montenegro
      MF:Frankriikka Saint Martin
      MG:Madagaskar
      MH:Marshallsullot
      ML:Mali
      MM:Burma
      MN:Mongolia
      MO:Makáo
      MP:Davvi-Mariánat
      MQ:Martinique
      MR:Mauretánia
      MS:Montserrat
      MT:Málta
      MU:Mauritius
      MV:Malediivvat
      MW:Malawi
      MX:Meksiko
      MY:Malesia
      MZ:Mosambik
      NA:Namibia
      NC:Ođđa-Kaledonia
      NE:Niger
      NF:Norfolksullot
      NG:Nigeria
      NI:Nicaragua
      NL:Vuolleeatnamat
      NO:Norga
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Ođđa-Selánda
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Frankriikka Polynesia
      PG:Papua-Ođđa-Guinea
      PH:Filippiinnat
      PK:Pakistan
      PL:Polen
      PM:Saint Pierre ja Miquelon
      PN:Pitcairn
      PR:Puerto Rico
      PS:Palestina
      PT:Portugála
      PW:Palau
      PY:Paraguay
      QA:Qatar
      RE:Réunion
      RO:Románia
      RS:Serbia
      RU:Ruošša
      RW:Rwanda
      SA:Saudi-Arábia
      SB:Salomon-sullot
      SC:Seychellsullot
      SD:Davvisudan
      SE:Ruoŧŧa
      SG:Singapore
      SH:Saint Helena
      SI:Slovenia
      SJ:Svalbárda ja Jan Mayen
      SK:Slovákia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somália
      SR:Surinam
      SS:Máttasudan
      ST:São Tomé ja Príncipe
      SV:El Salvador
      SX:Vuolleeatnamat Saint Martin
      SY:Syria
      SZ:Svazieana
      TA:Tristan da Cunha
      TC:Turks ja Caicos-sullot
      TD:Tčad
      TG:Togo
      TH:Thaieana
      TJ:Tažikistan
      TK:Tokelau
      TL:Nuorta-Timor
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Durka
      TT:Trinidad ja Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzánia
      UA:Ukraina
      UG:Uganda
      US:Amerihká ovttastuvvan stáhtat
      UY:Uruguay
      UZ:Usbekistan
      VA:Vatikána
      VC:Saint Vincent ja Grenadine
      VE:Venezuela
      VG:Brittania Virgin-sullot
      VI:AOS Virgin-sullot
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis ja Futuna
      WS:Samoa
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Mátta-Afrihká
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:dovdameahttun guovlu
      """.trimIndent() }

  val se_FI: String by lazy { """
      001:Máilbmi
      002:Afrihka
      003:Davvi-Amerihká ja Gaska-Amerihká
      005:Lulli-Amerihká
      011:Oarje-Afrihká
      013:Gaska-Amerihká
      014:Nuorta-Afrihká
      015:Davvi-Afrihká
      017:Gaska-Afrihká
      018:Lulli-Afrihká
      019:Amerihka
      021:Davvi-Amerihká
      057:Mikronesia guovlu
      419:Latiinnalaš Amerihká
      BA:Bosnia ja Hercegovina
      EZ:Euroavádat
      KH:Kamboža
      SD:Sudan
      TD:Chad
      UN:Ovttastuvvan Našuvnnat
      """.trimIndent() }

  val se_SE: String? = null

  val seh: String by lazy { """
      AD:Andorra
      AE:Emirados Árabes Unidos
      AF:Afeganistão
      AG:Antígua e Barbuda
      AI:Anguilla
      AL:Albânia
      AM:Armênia
      AO:Angola
      AR:Argentina
      AS:Samoa Americana
      AT:Áustria
      AU:Austrália
      AW:Aruba
      AZ:Azerbaijão
      BA:Bósnia-Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Bélgica
      BF:Burquina Faso
      BG:Bulgária
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BM:Bermudas
      BN:Brunei
      BO:Bolívia
      BR:Brasil
      BS:Bahamas
      BT:Butão
      BW:Botsuana
      BY:Belarus
      BZ:Belize
      CA:Canadá
      CD:Congo-Kinshasa
      CF:República Centro-Africana
      CG:Congo
      CH:Suíça
      CI:Costa do Marfim
      CK:Ilhas Cook
      CL:Chile
      CM:República dos Camarões
      CN:China
      CO:Colômbia
      CR:Costa Rica
      CU:Cuba
      CV:Cabo Verde
      CY:Chipre
      CZ:República Tcheca
      DE:Alemanha
      DJ:Djibuti
      DK:Dinamarca
      DM:Dominica
      DO:República Dominicana
      DZ:Argélia
      EC:Equador
      EE:Estônia
      EG:Egito
      ER:Eritréia
      ES:Espanha
      ET:Etiópia
      FI:Finlândia
      FJ:Fiji
      FK:Ilhas Malvinas
      FM:Micronésia
      FR:França
      GA:Gabão
      GB:Reino Unido
      GD:Granada
      GE:Geórgia
      GF:Guiana Francesa
      GH:Gana
      GI:Gibraltar
      GL:Groênlandia
      GM:Gâmbia
      GN:Guiné
      GP:Guadalupe
      GQ:Guiné Equatorial
      GR:Grécia
      GT:Guatemala
      GU:Guam
      GW:Guiné Bissau
      GY:Guiana
      HN:Honduras
      HR:Croácia
      HT:Haiti
      HU:Hungria
      ID:Indonésia
      IE:Irlanda
      IL:Israel
      IN:Índia
      IQ:Iraque
      IR:Irã
      IS:Islândia
      IT:Itália
      JM:Jamaica
      JO:Jordânia
      JP:Japão
      KE:Quênia
      KG:Quirguistão
      KH:Camboja
      KI:Quiribati
      KM:Comores
      KN:São Cristovão e Nevis
      KP:Coréia do Norte
      KR:Coréia do Sul
      KW:Kuwait
      KY:Ilhas Caiman
      KZ:Casaquistão
      LA:Laos
      LB:Líbano
      LC:Santa Lúcia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Libéria
      LS:Lesoto
      LT:Lituânia
      LU:Luxemburgo
      LV:Letônia
      LY:Líbia
      MA:Marrocos
      MC:Mônaco
      MD:Moldávia
      MG:Madagascar
      MH:Ilhas Marshall
      ML:Mali
      MM:Mianmar
      MN:Mongólia
      MP:Ilhas Marianas do Norte
      MQ:Martinica
      MR:Mauritânia
      MS:Montserrat
      MT:Malta
      MU:Maurício
      MV:Maldivas
      MW:Malawi
      MX:México
      MY:Malásia
      MZ:Moçambique
      NA:Namíbia
      NC:Nova Caledônia
      NE:Níger
      NF:Ilhas Norfolk
      NG:Nigéria
      NI:Nicarágua
      NL:Holanda
      NO:Noruega
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nova Zelândia
      OM:Omã
      PA:Panamá
      PE:Peru
      PF:Polinésia Francesa
      PG:Papua-Nova Guiné
      PH:Filipinas
      PK:Paquistão
      PL:Polônia
      PM:Saint Pierre e Miquelon
      PN:Pitcairn
      PR:Porto Rico
      PS:Território da Palestina
      PT:Portugal
      PW:Palau
      PY:Paraguai
      QA:Catar
      RE:Reunião
      RO:Romênia
      RU:Rússia
      RW:Ruanda
      SA:Arábia Saudita
      SB:Ilhas Salomão
      SC:Seychelles
      SD:Sudão
      SE:Suécia
      SG:Cingapura
      SH:Santa Helena
      SI:Eslovênia
      SK:Eslováquia
      SL:Serra Leoa
      SM:San Marino
      SN:Senegal
      SO:Somália
      SR:Suriname
      ST:São Tomé e Príncipe
      SV:El Salvador
      SY:Síria
      SZ:Suazilândia
      TC:Ilhas Turks e Caicos
      TD:Chade
      TG:Togo
      TH:Tailândia
      TJ:Tadjiquistão
      TK:Tokelau
      TL:Timor Leste
      TM:Turcomenistão
      TN:Tunísia
      TO:Tonga
      TR:Turquia
      TT:Trinidad e Tobago
      TV:Tuvalu
      TW:Taiwan
      UA:Ucrânia
      UG:Uganda
      US:Estados Unidos
      UY:Uruguai
      UZ:Uzbequistão
      VA:Vaticano
      VC:São Vicente e Granadinas
      VE:Venezuela
      VG:Ilhas Virgens Britânicas
      VI:Ilhas Virgens dos EUA
      VN:Vietnã
      VU:Vanuatu
      WF:Wallis e Futuna
      WS:Samoa
      YE:Iêmen
      YT:Mayotte
      ZA:África do Sul
      ZM:Zâmbia
      ZW:Zimbábue
      """.trimIndent() }

  val ses: String by lazy { """
      AD:Andoora
      AE:Laaraw Imaarawey Margantey
      AF:Afgaanistan
      AG:Antigua nda Barbuuda
      AI:Angiiya
      AL:Albaani
      AM:Armeeni
      AO:Angoola
      AR:Argentine
      AS:Ameriki Samoa
      AT:Otriši
      AU:Ostraali
      AW:Aruuba
      AZ:Azerbaayijaŋ
      BA:Bosni nda Herzegovine
      BB:Barbaados
      BD:Bangladeši
      BE:Belgiiki
      BF:Burkina faso
      BG:Bulgaari
      BH:Bahareen
      BI:Burundi
      BJ:Beniŋ
      BM:Bermuda
      BN:Bruunee
      BO:Boolivi
      BR:Breezil
      BS:Bahamas
      BT:Buutaŋ
      BW:Botswaana
      BY:Biloriši
      BZ:Beliizi
      CA:Kanaada
      CD:Kongoo demookaratiki laboo
      CF:Centraafriki koyra
      CG:Kongoo
      CH:Swisu
      CI:Kudwar
      CK:Kuuk gungey
      CL:Šiili
      CM:Kameruun
      CN:Šiin
      CO:Kolombi
      CR:Kosta rika
      CU:Kuuba
      CV:Kapuver gungey
      CY:Šiipur
      CZ:Cek labo
      DE:Almaaɲe
      DJ:Jibuuti
      DK:Danemark
      DM:Doominiki
      DO:Doominiki laboo
      DZ:Alžeeri
      EC:Ekwateer
      EE:Estooni
      EG:Misra
      ER:Eritree
      ES:Espaaɲe
      ET:Ecioopi
      FI:Finlandu
      FJ:Fiji
      FK:Kalkan gungey
      FM:Mikronezi
      FR:Faransi
      GA:Gaabon
      GB:Albaasalaama Marganta
      GD:Grenaada
      GE:Gorgi
      GF:Faransi Guyaan
      GH:Gaana
      GI:Gibraltar
      GL:Grinland
      GM:Gambi
      GN:Gine
      GP:Gwadeluup
      GQ:Ginee Ekwatorial
      GR:Greece
      GT:Gwatemaala
      GU:Guam
      GW:Gine-Bisso
      GY:Guyaane
      HN:Honduras
      HR:Krwaasi
      HT:Haiti
      HU:Hungaari
      ID:Indoneezi
      IE:Irlandu
      IL:Israyel
      IN:Indu laboo
      IQ:Iraak
      IR:Iraan
      IS:Ayceland
      IT:Itaali
      JM:Jamaayik
      JO:Urdun
      JP:Jaapoŋ
      KE:Keeniya
      KG:Kyrgyzstan
      KH:Kamboogi
      KI:Kiribaati
      KM:Komoor
      KN:Seŋ Kitts nda Nevis
      KP:Kooree, Gurma
      KR:Kooree, Hawsa
      KW:Kuweet
      KY:Kayman gungey
      KZ:Kaazakstan
      LA:Laawos
      LB:Lubnaan
      LC:Seŋ Lussia
      LI:Liechtenstein
      LK:Srilanka
      LR:Liberia
      LS:Leesoto
      LT:Lituaani
      LU:Luxembourg
      LV:Letooni
      LY:Liibi
      MA:Maarok
      MC:Monako
      MD:Moldovi
      MG:Madagascar
      MH:Maršal gungey
      ML:Maali
      MM:Maynamar
      MN:Mongooli
      MP:Mariana Gurma Gungey
      MQ:Martiniiki
      MR:Mooritaani
      MS:Montserrat
      MT:Malta
      MU:Mooris gungey
      MV:Maldiivu
      MW:Malaawi
      MX:Mexiki
      MY:Maleezi
      MZ:Mozambik
      NA:Naamibi
      NC:Kaaledooni Taagaa
      NE:Nižer
      NF:Norfolk Gungoo
      NG:Naajiriia
      NI:Nikaragwa
      NL:Hollandu
      NO:Norveej
      NP:Neepal
      NR:Nauru
      NU:Niue
      NZ:Zeelandu Taaga
      OM:Omaan
      PA:Panama
      PE:Peeru
      PF:Faransi Polineezi
      PG:Papua Ginee Taaga
      PH:Filipine
      PK:Paakistan
      PL:Poloɲe
      PM:Seŋ Piyer nda Mikelon
      PN:Pitikarin
      PR:Porto Riko
      PS:Palestine Dangay nda Gaaza
      PT:Portugaal
      PW:Palu
      PY:Paraguwey
      QA:Kataar
      RE:Reenioŋ
      RO:Rumaani
      RU:Iriši laboo
      RW:Rwanda
      SA:Saudiya
      SB:Solomon Gungey
      SC:Seešel
      SD:Suudaŋ
      SE:Sweede
      SG:Singapur
      SH:Seŋ Helena
      SI:Sloveeni
      SK:Slovaaki
      SL:Seera Leon
      SM:San Marino
      SN:Senegal
      SO:Somaali
      SR:Surinaam
      ST:Sao Tome nda Prinsipe
      SV:Salvador laboo
      SY:Suuria
      SZ:Swaziland
      TC:Turk nda Kayikos Gungey
      TD:Caadu
      TG:Togo
      TH:Taayiland
      TJ:Taažikistan
      TK:Tokelau
      TL:Timoor hawsa
      TM:Turkmenistaŋ
      TN:Tunizi
      TO:Tonga
      TR:Turki
      TT:Trinidad nda Tobaago
      TV:Tuvalu
      TW:Taayiwan
      TZ:Tanzaani
      UA:Ukreen
      UG:Uganda
      US:Ameriki Laabu Margantey
      UY:Uruguwey
      UZ:Uzbeekistan
      VA:Vaatikan Laama
      VC:Seŋvinsaŋ nda Grenadine
      VE:Veneezuyeela
      VG:Britiši Virgin gungey
      VI:Ameerik Virgin Gungey
      VN:Vietnaam
      VU:Vanautu
      WF:Wallis nda Futuna
      WS:Samoa
      YE:Yaman
      YT:Mayooti
      ZA:Hawsa Afriki Laboo
      ZM:Zambi
      ZW:Zimbabwe
      """.trimIndent() }

  val sg: String by lazy { """
      AD:Andôro
      AE:Arâbo Emirâti Ôko
      AF:Faganïta, Afganïstäan
      AG:Antîgua na Barbûda
      AI:Angûîla
      AL:Albanïi
      AM:Armenïi
      AO:Angoläa
      AR:Arzantîna
      AS:Samöa tî Amerîka
      AT:Otrîsi
      AU:Ostralïi, Sotralïi
      AW:Arûba
      AZ:Zerebaidyäan, Azerbaidyäan,
      BA:Bosnïi na Herzegovînni
      BB:Barabâda
      BD:Bengladêshi
      BE:Bêleze, Belezîki
      BF:Burkina Faso
      BG:Bulugarïi
      BH:Bahrâina
      BI:Burundïi
      BJ:Benëen
      BM:Beremûda
      BN:Brunêi
      BO:Bolivïi
      BR:Brezîli
      BS:Bahâmasa
      BT:Butäan
      BW:Botswana
      BY:Belarüsi
      BZ:Belîzi
      CA:Kanadäa
      CD:Ködörösêse tî Ngunuhalëzo tî kongö
      CF:Ködörösêse tî Bêafrîka
      CG:Kongö
      CH:Sûîsi
      CI:Kôdivüära
      CK:âzûâ Kûku
      CL:Shilïi
      CM:Kamerûne
      CN:Shîna
      CO:Kolombïi
      CR:Kôsta Rîka
      CU:Kubäa
      CV:Azûâ tî Kâpo-Vêre
      CY:Sîpri
      CZ:Ködörösêse tî Tyêki
      DE:Zâmani
      DJ:Dibutùii
      DK:Danemêrke
      DM:Dömïnîka
      DO:Ködörösêse tî Dominîka
      DZ:Alzerïi
      EC:Ekuatëre
      EE:Estonïi
      EG:Kâmitâ
      ER:Eritrëe
      ES:Espânye
      ET:Etiopïi
      FI:Fëlânde
      FJ:Fidyïi
      FK:Âzûâ tî Mälüîni
      FM:Mikronezïi
      FR:Farânzi
      GA:Gaböon
      GB:Ködörögbïä--Ôko
      GD:Grenâda
      GE:Zorzïi
      GF:Güyâni tî farânzi
      GH:Ganäa
      GI:Zibraltära, Zibaratära
      GL:Gorolânde
      GM:Gambïi
      GN:Ginëe
      GP:Guadelûpu
      GQ:Ginëe tî Ekuatëre
      GR:Gerêsi
      GT:Guatêmälä
      GU:Guâm
      GW:Gninëe-Bisau
      GY:Gayâna
      HN:Honduräsi
      HR:Kroasïi
      HT:Haitïi
      HU:Hongirùii
      ID:Ênndonezïi
      IE:Irlânde
      IL:Israëli
      IN:Ênnde
      IQ:Irâki
      IR:Iräan
      IS:Islânde
      IT:Italùii
      JM:Zamaîka
      JO:Zordanïi
      JP:Zapöon
      KE:Kenyäa
      KG:Kirigizitùaan
      KH:Kämbôzi
      KI:Kiribati
      KM:Kömôro
      KN:Sên-Krïstôfo-na-Nevîsi
      KP:Korëe tî Banga
      KR:Korëe tî Mbongo
      KW:Köwêti
      KY:Âzûâ Ngundë, Kaimäni
      KZ:Kazakisitäan
      LA:Lùaôsi
      LB:Libùaan
      LC:Sênt-Lisïi
      LI:Liechtenstein,
      LK:Sirî-Lanka
      LR:Liberïa
      LS:Lesôtho
      LT:Lituanïi
      LU:Lugzambûru
      LV:Letonùii
      LY:Libïi
      MA:Marôko
      MC:Monaköo
      MD:Moldavùii
      MG:Madagaskära
      MH:Âzûâ Märshâl
      ML:Malïi
      MM:Myämâra
      MN:Mongolïi
      MP:Âzûâ Märïâni tî Banga
      MQ:Märtïnîki
      MR:Moritanïi
      MS:Monserâte
      MT:Mâlta
      MU:Mörîsi
      MV:Maldîva
      MW:Malawïi
      MX:Mekisîki
      MY:Malezïi
      MZ:Mözämbîka
      NA:Namibùii
      NC:Finî Kaledonïi
      NE:Nizëre
      NF:Zûâ Nôrfôlko
      NG:Nizerïa
      NI:Nikaragua
      NL:Holände
      NO:Nörvêzi
      NP:Nëpâli
      NR:Nauru
      NU:Niue
      NZ:Finî Zelânde
      OM:Omâni
      PA:Panama
      PE:Perüu
      PF:Polinezïi tî farânzi
      PG:Papû Finî Ginëe, Papuazïi
      PH:Filipîni
      PK:Pakistäan
      PL:Pölôni
      PM:Sên-Pyêre na Mikelöon
      PN:Pitikêrni
      PR:Porto Rîko
      PS:Sêse tî Palestîni
      PT:Pörtugäle, Ködörö Pûra
      PW:Palau
      PY:Paraguëe
      QA:Katära
      RE:Reinïon
      RO:Rumanïi
      RU:Rusïi
      RW:Ruandäa
      SA:Saûdi Arabïi
      SB:Zûâ Salomöon
      SC:Sëyshêle
      SD:Sudäan
      SE:Suêde
      SG:Sïngäpûru
      SH:Sênt-Helêna
      SI:Solovenïi
      SK:Solovakïi
      SL:Sierä-Leône
      SM:Sên-Marëen
      SN:Senegäle
      SO:Somalïi
      SR:Surinäm
      ST:Sâô Tömê na Prinsîpe
      SV:Salvadöro
      SY:Sirïi
      SZ:Swäzïlânde
      TC:Âzûâ Turku na Kaîki
      TD:Tyâde
      TG:Togö
      TH:Tailânde
      TJ:Taazikiistäan
      TK:Tokelau
      TL:Timôro tî Tö
      TM:Turkumenistäan
      TN:Tunizïi
      TO:Tonga
      TR:Turukïi
      TT:Trinitùee na Tobagö
      TV:Tüvalü
      TW:Tâiwâni
      TZ:Tanzanïi
      UA:Ukrêni
      UG:Ugandäa
      US:ÂLeaa-Ôko tî Amerika
      UY:Uruguëe
      UZ:Uzbekistäan
      VA:Letëe tî Vatikäan
      VC:Sên-Vensäan na âGrenadîni
      VE:Venezueläa
      VG:Âzôâ Viîrîggo tî Anglëe
      VI:Âzûâ Virîgo tî Amerîka
      VN:Vietnäm
      VU:Vanuatü
      WF:Walîsi na Futuna
      WS:Samoäa
      YE:Yëmêni
      YT:Mäyôte
      ZA:Mbongo-Afrîka
      ZM:Zambïi
      ZW:Zimbäbwe
      """.trimIndent() }

  val shi: String by lazy { """
      AD:ⴰⵏⴷⵓⵔⴰ
      AE:ⵍⵉⵎⴰⵔⴰⵜ
      AF:ⴰⴼⵖⴰⵏⵉⵙⵜⴰⵏ
      AG:ⴰⵏⵜⵉⴳⴰ ⴷ ⴱⵔⴱⵓⴷⴰ
      AI:ⴰⵏⴳⵉⵍⴰ
      AL:ⴰⵍⴱⴰⵏⵢⴰ
      AM:ⴰⵔⵎⵉⵏⵢⴰ
      AO:ⴰⵏⴳⵓⵍⴰ
      AR:ⴰⵔⵊⴰⵏⵜⵉⵏ
      AS:ⵙⴰⵎⵡⴰ ⵜⴰⵎⵉⵔⵉⴽⴰⵏⵉⵜ
      AT:ⵏⵏⵎⵙⴰ
      AU:ⵓⵙⵜⵔⴰⵍⵢⴰ
      AW:ⴰⵔⵓⴱⴰ
      AZ:ⴰⴷⵔⴰⴱⵉⵊⴰⵏ
      BA:ⴱⵓⵙⵏⴰ ⴷ ⵀⵉⵔⵙⵉⴽ
      BB:ⴱⴰⵔⴱⴰⴷ
      BD:ⴱⴰⵏⴳⵍⴰⴷⵉⵛ
      BE:ⴱⵍⵊⵉⴽⴰ
      BF:ⴱⵓⵔⴽⵉⵏⴰ ⴼⴰⵙⵓ
      BG:ⴱⵍⵖⴰⵔⵢⴰ
      BH:ⴱⵃⵔⴰⵢⵏ
      BI:ⴱⵓⵔⵓⵏⴷⵉ
      BJ:ⴱⵉⵏⵉⵏ
      BM:ⴱⵔⵎⵓⴷⴰ
      BN:ⴱⵔⵓⵏⵉ
      BO:ⴱⵓⵍⵉⴼⵢⴰ
      BR:ⴱⵔⴰⵣⵉⵍ
      BS:ⴱⴰⵀⴰⵎⴰⵙ
      BT:ⴱⵀⵓⵜⴰⵏ
      BW:ⴱⵓⵜⵙⵡⴰⵏⴰ
      BY:ⴱⵉⵍⴰⵔⵓⵙⵢⴰ
      BZ:ⴱⵉⵍⵉⵣ
      CA:ⴽⴰⵏⴰⴷⴰ
      CD:ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⴷⵉⵎⵓⵇⵔⴰⵜⵉⵜ ⵏ ⴽⵓⵏⴳⵓ
      CF:ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⵏⴰⵎⵎⴰⵙⵜ ⵏ ⵉⴼⵔⵉⵇⵢⴰ
      CG:ⴽⵓⵏⴳⵓ
      CH:ⵙⵡⵉⵙⵔⴰ
      CI:ⴽⵓⵜ ⴷⵉⴼⵡⴰⵔ
      CK:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⴽⵓⴽ
      CL:ⵛⵛⵉⵍⵉ
      CM:ⴽⴰⵎⵉⵔⵓⵏ
      CN:ⵛⵛⵉⵏⵡⴰ
      CO:ⴽⵓⵍⵓⵎⴱⵢⴰ
      CR:ⴽⵓⵙⵜⴰ ⵔⵉⴽⴰ
      CU:ⴽⵓⴱⴰ
      CV:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⴽⴰⴱⴱⵉⵔⴷⵉ
      CY:ⵇⵓⴱⵔⵓⵙ
      CZ:ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⵜⵛⵉⴽⵉⵜ
      DE:ⴰⵍⵎⴰⵏⵢⴰ
      DJ:ⴷⵊⵉⴱⵓⵜⵉ
      DK:ⴷⴰⵏⵎⴰⵔⴽ
      DM:ⴷⵓⵎⵉⵏⵉⴽ
      DO:ⵜⴰⴳⴷⵓⴷⴰⵏⵜ ⵜⴰⴷⵓⵎⵉⵏⵉⴽⵜ
      DZ:ⴷⵣⴰⵢⵔ
      EC:ⵉⴽⵡⴰⴷⵓⵔ
      EE:ⵉⵙⵜⵓⵏⵢⴰ
      EG:ⵎⵉⵚⵕ
      ER:ⵉⵔⵉⵜⵉⵔⵢⴰ
      ES:ⵙⴱⴰⵏⵢⴰ
      ET:ⵉⵜⵢⵓⴱⵢⴰ
      FI:ⴼⵉⵍⵍⴰⵏⴷⴰ
      FJ:ⴼⵉⴷⵊⵉ
      FK:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵎⴰⵍⴰⵡⵉ
      FM:ⵎⵉⴽⵔⵓⵏⵉⵣⵢⴰ
      FR:ⴼⵔⴰⵏⵙⴰ
      GA:ⴳⴰⴱⵓⵏ
      GB:ⵜⴰⴳⵍⴷⵉⵜ ⵉⵎⵓⵏⵏ
      GD:ⵖⵔⵏⴰⵟⴰ
      GE:ⵊⵓⵔⵊⵢⴰ
      GF:ⴳⵡⵉⵢⴰⵏ ⵜⴰⴼⵔⴰⵏⵙⵉⵙⵜ
      GH:ⵖⴰⵏⴰ
      GI:ⴰⴷⵔⴰⵔ ⵏ ⵟⴰⵕⵉⵇ
      GL:ⴳⵔⵉⵍⴰⵏⴷ
      GM:ⴳⴰⵎⴱⵢⴰ
      GN:ⵖⵉⵏⵢⴰ
      GP:ⴳⵡⴰⴷⴰⵍⵓⴱ
      GQ:ⵖⵉⵏⵢⴰ ⵏ ⵉⴽⵡⴰⴷⵓⵔ
      GR:ⵍⵢⵓⵏⴰⵏ
      GT:ⴳⵡⴰⵜⵉⵎⴰⵍⴰ
      GU:ⴳⵡⴰⵎ
      GW:ⵖⵉⵏⵢⴰ ⴱⵉⵙⴰⵡ
      GY:ⴳⵡⵉⵢⴰⵏⴰ
      HN:ⵀⵓⵏⴷⵓⵔⴰⵙ
      HR:ⴽⵔⵡⴰⵜⵢⴰ
      HT:ⵀⴰⵢⵜⵉ
      HU:ⵀⵏⵖⴰⵔⵢⴰ
      ID:ⴰⵏⴷⵓⵏⵉⵙⵢⴰ
      IE:ⵉⵔⵍⴰⵏⴷⴰ
      IL:ⵉⵙⵔⴰⵢⵉⵍ
      IN:ⵍⵀⵉⵏⴷ
      IQ:ⵍⵄⵉⵔⴰⵇ
      IR:ⵉⵔⴰⵏ
      IS:ⵉⵙⵍⴰⵏⴷ
      IT:ⵉⵟⴰⵍⵢⴰ
      JM:ⵊⴰⵎⴰⵢⴽⴰ
      JO:ⵍⵓⵔⴷⵓⵏ
      JP:ⵍⵢⴰⴱⴰⵏ
      KE:ⴽⵉⵏⵢⴰ
      KG:ⴽⵉⵔⵖⵉⵣⵉⵙⵜⴰⵏ
      KH:ⴽⴰⵎⴱⵓⴷⵢⴰ
      KI:ⴽⵉⵔⵉⴱⴰⵜⵉ
      KM:ⵇⵓⵎⵓⵔ
      KN:ⵙⴰⵏⴽⵔⵉⵙ ⴷ ⵏⵉⴼⵉⵙ
      KP:ⴽⵓⵔⵢⴰ ⵏ ⵉⵥⵥⵍⵎⴹ
      KR:ⴽⵓⵔⵢⴰ ⵏ ⵉⴼⴼⵓⵙ
      KW:ⵍⴽⵡⵉⵜ
      KY:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⴽⴰⵢⵎⴰⵏ
      KZ:ⴽⴰⵣⴰⵅⵙⵜⴰⵏ
      LA:ⵍⴰⵡⵙ
      LB:ⵍⵓⴱⵏⴰⵏ
      LC:ⵙⴰⵏⵜⵍⵓⵙⵉ
      LI:ⵍⵉⴽⵉⵏⵛⵜⴰⵢⵏ
      LK:ⵙⵔⵉⵍⴰⵏⴽⴰ
      LR:ⵍⵉⴱⵉⵔⵢⴰ
      LS:ⵍⵉⵚⵓⵟⵓ
      LT:ⵍⵉⵜⵡⴰⵏⵢⴰ
      LU:ⵍⵓⴽⵙⴰⵏⴱⵓⵔⴳ
      LV:ⵍⴰⵜⴼⵢⴰ
      LY:ⵍⵉⴱⵢⴰ
      MA:ⵍⵎⵖⵔⵉⴱ
      MC:ⵎⵓⵏⴰⴽⵓ
      MD:ⵎⵓⵍⴷⵓⴼⵢⴰ
      MG:ⵎⴰⴷⴰⵖⴰⵛⵇⴰⵔ
      MH:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵎⴰⵔⵛⴰⵍ
      ML:ⵎⴰⵍⵉ
      MM:ⵎⵢⴰⵏⵎⴰⵔ
      MN:ⵎⵏⵖⵓⵍⵢⴰ
      MP:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵎⴰⵔⵢⴰⵏ ⵏ ⵉⵥⵥⵍⵎⴹ
      MQ:ⵎⴰⵔⵜⵉⵏⵉⴽ
      MR:ⵎⵓⵕⵉⵟⴰⵏⵢⴰ
      MS:ⵎⵓⵏⵙⵉⵔⴰⵜ
      MT:ⵎⴰⵍⵟⴰ
      MU:ⵎⵓⵔⵉⵙ
      MV:ⵎⴰⵍⴷⵉⴼ
      MW:ⵎⴰⵍⴰⵡⵉ
      MX:ⵎⵉⴽⵙⵉⴽ
      MY:ⵎⴰⵍⵉⵣⵢⴰ
      MZ:ⵎⵓⵣⵏⴱⵉⵇ
      NA:ⵏⴰⵎⵉⴱⵢⴰ
      NC:ⴽⴰⵍⵉⴷⵓⵏⵢⴰ ⵜⴰⵎⴰⵢⵏⵓⵜ
      NE:ⵏⵏⵉⵊⵉⵔ
      NF:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵏⵓⵔⴼⵓⵍⴽ
      NG:ⵏⵉⵊⵉⵔⵢⴰ
      NI:ⵏⵉⴽⴰⵔⴰⴳⵡⴰ
      NL:ⵀⵓⵍⴰⵏⴷⴰ
      NO:ⵏⵏⵔⵡⵉⵊ
      NP:ⵏⵉⴱⴰⵍ
      NR:ⵏⴰⵡⵔⵓ
      NU:ⵏⵉⵡⵉ
      NZ:ⵏⵢⵓⵣⵉⵍⴰⵏⴷⴰ
      OM:ⵄⵓⵎⴰⵏ
      PA:ⴱⴰⵏⴰⵎⴰ
      PE:ⴱⵉⵔⵓ
      PF:ⴱⵓⵍⵉⵏⵉⵣⵢⴰ ⵜⴰⴼⵔⴰⵏⵙⵉⵙⵜ
      PG:ⴱⴰⴱⵡⴰ ⵖⵉⵏⵢⴰ ⵜⴰⵎⴰⵢⵏⵓⵜ
      PH:ⴼⵉⵍⵉⴱⴱⵉⵏ
      PK:ⴱⴰⴽⵉⵙⵜⴰⵏ
      PL:ⴱⵓⵍⵓⵏⵢⴰ
      PM:ⵙⴰⵏⴱⵢⵉⵔ ⴷ ⵎⵉⴽⵍⵓⵏ
      PN:ⴱⵉⵜⴽⴰⵢⵔⵏ
      PR:ⴱⵓⵔⵜⵓ ⵔⵉⴽⵓ
      PS:ⴰⴳⵎⵎⴰⴹ ⵏ ⵜⴰⴳⵓⵜ ⴷ ⵖⵣⵣⴰ
      PT:ⴱⵕⵟⵇⵉⵣ
      PW:ⴱⴰⵍⴰⵡ
      PY:ⴱⴰⵔⴰⴳⵡⴰⵢ
      QA:ⵇⴰⵜⴰⵔ
      RE:ⵔⵉⵢⵓⵏⵢⵓⵏ
      RO:ⵔⵓⵎⴰⵏⵢⴰ
      RU:ⵔⵓⵙⵢⴰ
      RW:ⵔⵡⴰⵏⴷⴰ
      SA:ⵙⵙⴰⵄⵓⴷⵉⵢⴰ
      SB:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵙⴰⵍⵓⵎⴰⵏ
      SC:ⵙⵙⵉⵛⵉⵍ
      SD:ⵙⵙⵓⴷⴰⵏ
      SE:ⵙⵙⵡⵉⴷ
      SG:ⵙⵏⵖⴰⴼⵓⵔⴰ
      SH:ⵙⴰⵏⵜⵉⵍⵉⵏ
      SI:ⵙⵍⵓⴼⵉⵏⵢⴰ
      SK:ⵙⵍⵓⴼⴰⴽⵢⴰ
      SL:ⵙⵙⵉⵔⴰⵍⵢⵓⵏ
      SM:ⵙⴰⵏⵎⴰⵔⵉⵏⵓ
      SN:ⵙⵙⵉⵏⵉⴳⴰⵍ
      SO:ⵚⵚⵓⵎⴰⵍ
      SR:ⵙⵓⵔⵉⵏⴰⵎ
      ST:ⵙⴰⵡⵟⵓⵎⵉ ⴷ ⴱⵔⴰⵏⵙⵉⴱ
      SV:ⵙⴰⵍⴼⴰⴷⵓⵔ
      SY:ⵙⵓⵔⵢⴰ
      SZ:ⵙⵡⴰⵣⵉⵍⴰⵏⴷⴰ
      TC:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵏ ⵜⵓⵔⴽⵢⴰ ⴷ ⴽⴰⵢⴽ
      TD:ⵜⵛⴰⴷ
      TG:ⵟⵓⴳⵓ
      TH:ⵟⴰⵢⵍⴰⵏⴷ
      TJ:ⵜⴰⴷⵊⴰⴽⵉⵙⵜⴰⵏ
      TK:ⵟⵓⴽⵍⴰⵡ
      TL:ⵜⵉⵎⵓⵔ ⵏ ⵍⵇⴱⵍⵜ
      TM:ⵜⵓⵔⴽⵎⴰⵏⵙⵜⴰⵏ
      TN:ⵜⵓⵏⵙ
      TO:ⵟⵓⵏⴳⴰ
      TR:ⵜⵓⵔⴽⵢⴰ
      TT:ⵜⵔⵉⵏⵉⴷⴰⴷ ⴷ ⵟⵓⴱⴰⴳⵓ
      TV:ⵜⵓⴼⴰⵍⵓ
      TW:ⵟⴰⵢⵡⴰⵏ
      TZ:ⵟⴰⵏⵥⴰⵏⵢⴰ
      UA:ⵓⴽⵔⴰⵏⵢⴰ
      UG:ⵓⵖⴰⵏⴷⴰ
      US:ⵉⵡⵓⵏⴰⴽ ⵎⵓⵏⵏⵉⵏ ⵏ ⵎⵉⵔⵉⴽⴰⵏ
      UY:ⵓⵔⵓⴳⵡⴰⵢ
      UZ:ⵓⵣⴱⴰⴽⵉⵙⵜⴰⵏ
      VA:ⴰⵡⴰⵏⴽ ⵏ ⴼⴰⵜⵉⴽⴰⵏ
      VC:ⵙⴰⵏⴼⴰⵏⵙⴰⵏ ⴷ ⴳⵔⵉⵏⴰⴷⵉⵏ
      VE:ⴼⵉⵏⵣⵡⵉⵍⴰ
      VG:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵜⵉⵎⴳⴰⴷ ⵏ ⵏⵏⴳⵍⵉⵣ
      VI:ⵜⵉⴳⵣⵉⵔⵉⵏ ⵜⵉⵎⴳⴰⴷ ⵏ ⵉⵡⵓⵏⴰⴽ ⵎⵓⵏⵏⵉⵏ
      VN:ⴼⵉⵜⵏⴰⵎ
      VU:ⴼⴰⵏⵡⴰⵟⵓ
      WF:ⵡⴰⵍⵉⵙ ⴷ ⴼⵓⵜⵓⵏⴰ
      WS:ⵙⴰⵎⵡⴰ
      YE:ⵢⴰⵎⴰⵏ
      YT:ⵎⴰⵢⵓⵟ
      ZA:ⴰⴼⵔⵉⵇⵢⴰ ⵏ ⵉⴼⴼⵓⵙ
      ZM:ⵣⴰⵎⴱⵢⴰ
      ZW:ⵣⵉⵎⴱⴰⴱⵡⵉ
      """.trimIndent() }

  val shi_Latn: String by lazy { """
      AD:andura
      AE:limarat
      AF:afɣanistan
      AG:antiga d brbuda
      AI:angila
      AL:albanya
      AM:arminya
      AO:angula
      AR:arjantin
      AS:samwa tamirikanit
      AT:nnmsa
      AU:ustralya
      AW:aruba
      AZ:adrabijan
      BA:busna d hirsik
      BB:barbad
      BD:bangladic
      BE:bljika
      BF:burkina fasu
      BG:blɣara
      BH:bḥrayn
      BI:burundi
      BJ:binin
      BM:brmuda
      BN:bruni
      BO:bulibya
      BR:brazil
      BS:bahamas
      BT:bhutan
      BW:butswana
      BY:bilarusya
      BZ:biliz
      CA:kanada
      CD:tagdudant tadimukratit n Kongo
      CF:tagdudant tanammast n ifriqya
      CG:kungu
      CH:swisra
      CI:kut difwar
      CK:tigzirin n kuk
      CL:ccili
      CM:kamirun
      CN:ccinwa
      CO:culumbya
      CR:kusta rika
      CU:kuba
      CV:tigzirin n kabbirdi
      CY:qubrus
      CZ:tagdudant tatcikit
      DE:almanya
      DJ:djibuti
      DK:danmark
      DM:duminik
      DO:tagdudant taduminikt
      DZ:dzayr
      EC:ikwadur
      EE:istunya
      EG:miṣṛ
      ER:iritirya
      ES:sbanya
      ET:ityubya
      FI:fillanda
      FJ:fidji
      FK:tigzirin n malawi
      FM:mikrunizya
      FR:fransa
      GA:gabun
      GB:tagldit imunn
      GD:ɣrnaṭa
      GE:jurjya
      GF:gwiyan tafransist
      GH:ɣana
      GI:adrar n ṭaṛiq
      GL:griland
      GM:gambya
      GN:ɣinya
      GP:gwadalub
      GQ:ɣinya n ikwadur
      GR:lyunan
      GT:gwatimala
      GU:gwam
      GW:ɣinya bisaw
      GY:gwiyana
      HN:hunduras
      HR:krwatya
      HT:hayti
      HU:hnɣarya
      ID:andunisya
      IE:irlanda
      IL:israyil
      IN:lhind
      IQ:lɛiraq
      IR:iran
      IS:island
      IT:iṭalya
      JM:jamayka
      JO:lurdun
      JP:lyaban
      KE:kinya
      KG:kirɣizistan
      KH:kambudya
      KI:kiribati
      KM:cumur
      KN:sankris d nifis
      KP:kurya n iẓẓlmḍ
      KR:kurya n iffus
      KW:lkwit
      KY:tigzirin n kayman
      KZ:kazaxstan
      LA:laws
      LB:lubnan
      LC:santlusi
      LI:likinctayn
      LK:srilanka
      LR:libirya
      LS:liṣuṭu
      LT:litwanya
      LU:luksanburg
      LV:latfya
      LY:libya
      MA:lmɣrib
      MC:munaku
      MD:muldufya
      MG:madaɣacqar
      MH:tigzirin n marcal
      ML:mali
      MM:myanmar
      MN:mnɣulya
      MP:tigzirin n maryan n iẓẓlmḍ
      MQ:martinik
      MR:muṛiṭanya
      MS:munsirat
      MT:malṭa
      MU:muris
      MV:maldif
      MW:malawi
      MX:miksik
      MY:malizya
      MZ:muznbiq
      NA:namibya
      NC:kalidunya tamaynut
      NE:nnijir
      NF:tigzirin n nurfulk
      NG:nijirya
      NI:nikaragwa
      NL:hulanda
      NO:nnrwij
      NP:nibal
      NR:nawru
      NU:niwi
      NZ:nyuzilanda
      OM:ɛuman
      PA:banama
      PE:biru
      PF:bulinizya tafransist
      PG:babwa ɣinya tamaynut
      PH:filibbin
      PK:bakistan
      PL:bulunya
      PM:sanbyir d miklun
      PN:bitkayrn
      PR:burtu riku
      PS:agmmaḍ n tagut d ɣzza
      PT:bṛṭqiz
      PW:balaw
      PY:baragway
      QA:qatar
      RE:riyunyun
      RO:rumanya
      RU:rusya
      RW:rwanda
      SA:ssaɛudiya
      SB:tigzirin n saluman
      SC:ssicil
      SD:ssudan
      SE:sswid
      SG:snɣafura
      SH:santilin
      SI:slufinya
      SK:slufakya
      SL:ssiralyun
      SM:sanmarinu
      SN:ssinigal
      SO:ṣṣumal
      SR:surinam
      ST:sawṭumi d bransib
      SV:salfadur
      SY:surya
      SZ:swazilanda
      TC:tigzirin n turkya d kayk
      TD:tcad
      TG:ṭugu
      TH:ṭayland
      TJ:tadjakistan
      TK:ṭuklaw
      TL:timur n lqblt
      TM:turkmanstan
      TN:tuns
      TO:ṭunga
      TR:turkya
      TT:trinidad d ṭubagu
      TV:tufalu
      TW:ṭaywan
      TZ:ṭanẓanya
      UA:ukranya
      UG:uɣanda
      US:iwunak munnin n mirikan
      UY:urugway
      UZ:uzbakistan
      VA:awank n fatikan
      VC:sanfansan d grinadin
      VE:finzwila
      VG:tigzirin timgad n nngliz
      VI:tigzirin timgad n iwunak munnin
      VN:fitnam
      VU:fanwaṭu
      WF:walis d futuna
      WS:samwa
      YE:yaman
      YT:mayuṭ
      ZA:afriqya n iffus
      ZM:zambya
      ZW:zimbabwi
      """.trimIndent() }

  val shi_Tfng: String? = null

  val shn: String by lazy { """
      MM:မျၢၼ်ႇမႃႇ (မိူင်းမၢၼ်ႈ)
      TH:မိူင်းထႆး
      """.trimIndent() }

  val shn_TH: String? = null

  val si: String by lazy { """
      001:ලෝකය
      002:අප්‍රිකාව
      003:උතුරු ඇමෙරිකාව
      005:දකුණු ඇමෙරිකාව
      009:ඕෂනියාව
      011:බටහිරදිග අප්‍රිකාව
      013:මධ්‍යම ඇමෙරිකාව
      014:පෙරදිග අප්‍රිකාව
      015:උතුරුදිග අප්‍රිකාව
      017:මධ්‍යම අප්‍රිකාව
      018:දකුණුදිග අප්‍රිකාව
      019:ඇමරිකාව
      021:උතුරුදිග ඇමෙරිකාව
      029:කැරීබියන්
      030:නැගෙනහිර ආසියාව
      034:දකුණු ආසියාව
      035:අග්නිදිග ආසියාව
      039:දකුණුදිග යුරෝපය
      053:ඕස්ට්‍රලේෂියාව
      054:මෙලනීසියාව
      057:මයික්‍රෝනීසියානු කළාපය
      061:පොලිනීසියාව
      142:ආසියාව
      143:මධ්‍යම ආසියාව
      145:බටහිර ආසියාව
      150:යුරෝපය
      151:නැගෙනහිර යුරෝපය
      154:උතුරු යුරෝපය
      155:බටහිර යුරෝපය
      202:උප-සහරානු අප්‍රිකාව
      419:ලතින් ඇමෙරිකාව
      AC:ඇසෙන්ෂන් දිවයින
      AD:ඇන්ඩෝරාව
      AE:එක්සත් අරාබි එමිර් රාජ්‍යය
      AF:ඇෆ්ගනිස්ථානය
      AG:ඇන්ටිගුවා සහ බාබියුඩාව
      AI:ඇන්ගුයිලාව
      AL:ඇල්බේනියාව
      AM:ආර්මේනියාව
      AO:ඇන්ගෝලාව
      AQ:ඇන්ටාක්ටිකාව
      AR:ආර්ජෙන්ටිනාව
      AS:ඇමරිකානු සැමෝවා
      AT:ඔස්ට්‍රියාව
      AU:ඕස්ට්‍රේලියාව
      AW:අරූබා
      AX:ඕලන්ඩ් දූපත්
      AZ:අසර්බයිජානය
      BA:බොස්නියාව සහ හර්සගොවීනාව
      BB:බාබඩෝස්
      BD:බංග්ලාදේශය
      BE:බෙල්ජියම
      BF:බර්කිනා ෆාසෝ
      BG:බල්ගේරියාව
      BH:බහරේන්
      BI:බුරුන්දි
      BJ:බෙනින්
      BL:ශාන්ත බර්තලෙමි
      BM:බර්මියුඩා
      BN:බෲනායි
      BO:බොලීවියාව
      BQ:කැරිබියානු නෙදර්ලන්තය
      BR:බ්‍රසීලය
      BS:බහමාස්
      BT:භූතානය
      BV:බුවට් දුපත්
      BW:බොට්ස්වානා
      BY:බෙලරුස්
      BZ:බෙලීස්
      CA:කැනඩාව
      CC:කොකෝස් දූපත්
      CD:කොංගෝව (ඩීආර්සී)
      CF:මධ්‍යම අප්‍රිකානු ජනරජය
      CG:කොංගො - බ්‍රසාවිල්
      CH:ස්විස්ටර්ලන්තය
      CI:කෝට් දි අයිවරි
      CK:කුක් දූපත්
      CL:චිලී
      CM:කැමරූන්
      CN:චීනය
      CO:කොළොම්බියාව
      CP:ක්ලීපර්ටන් දූපත
      CR:කොස්ටරිකාව
      CU:කියුබාව
      CV:කේප් වර්ඩ්
      CW:කුරකාවෝ
      CX:ක්‍රිස්මස් දූපත
      CY:සයිප්‍රසය
      CZ:චෙචියාව
      DE:ජර්මනිය
      DG:දියාගෝ ගාර්සියා
      DJ:ජිබුටි
      DK:ඩෙන්මාර්කය
      DM:ඩොමිනිකාව
      DO:ඩොමිනිකා ජනරජය
      DZ:ඇල්ජීරියාව
      EA:සෙයුටා සහ මෙලිල්ලා
      EC:ඉක්වදෝරය
      EE:එස්තෝනියාව
      EG:ඊජිප්තුව
      EH:බටහිර සහරාව
      ER:එරිත්‍රියාව
      ES:ස්පාඤ්ඤය
      ET:ඉතියෝපියාව
      EU:යුරෝපා සංගමය
      EZ:යුරෝ කලාපය
      FI:ෆින්ලන්තය
      FJ:ෆීජී
      FK:ෆෝක්ලන්ත දූපත්
      FM:මයික්‍රොනීසියාව
      FO:ෆැරෝ දූපත්
      FR:ප්‍රංශය
      GA:ගැබොන්
      GB:එක්සත් රාජධානිය
      GD:ග්‍රැනඩාව
      GE:ජෝර්ජියාව
      GF:ප්‍රංශ ගයනාව
      GG:ගර්න්සිය
      GH:ඝානාව
      GI:ජිබ්‍රෝල්ටාව
      GL:ග්‍රීන්ලන්තය
      GM:ගැම්බියාව
      GN:ගිණියාව
      GP:ග්වෝඩලෝප්
      GQ:සමක ගිනියාව
      GR:ග්‍රීසිය
      GS:දකුණු ජෝර්ජියාව සහ දකුණු සැන්ඩ්විච් දූපත්
      GT:ගෝතමාලාව
      GU:ගුවාම්
      GW:ගිනි බිසව්
      GY:ගයනාව
      HK:හොංකොං විශේෂ පරිපාලන කලාපය චීනය
      HM:හර්ඩ් දූපත සහ මැක්ඩොනල්ඩ් දූපත්
      HN:හොන්ඩුරාස්
      HR:ක්‍රොඒෂියාව
      HT:හයිටි
      HU:හන්ගේරියාව
      IC:කැනරි සූපත්
      ID:ඉන්දුනීසියාව
      IE:අයර්ලන්තය
      IL:ඊශ්‍රායලය
      IM:අයිල් ඔෆ් මෑන්
      IN:ඉන්දියාව
      IO:බ්‍රිතාන්‍ය ඉන්දීය සාගර බල ප්‍රදේශය
      IQ:ඉරාකය
      IR:ඉරානය
      IS:අයිස්ලන්තය
      IT:ඉතාලිය
      JE:ජර්සි
      JM:ජැමෙයිකාව
      JO:ජෝර්දානය
      JP:ජපානය
      KE:කෙන්යාව
      KG:කිර්ගිස්තානය
      KH:කාම්බෝජය
      KI:කිරිබති
      KM:කොමොරෝස්
      KN:ශාන්ත කිට්ස් සහ නේවිස්
      KP:උතුරු කොරියාව
      KR:දකුණු කොරියාව
      KW:කුවේටය
      KY:කේමන් දූපත්
      KZ:කසකස්තානය
      LA:ලාඕසය
      LB:ලෙබනනය
      LC:ශාන්ත ලුසියා
      LI:ලික්ටන්ස්ටයින්
      LK:ශ්‍රී ලංකාව
      LR:ලයිබීරියාව
      LS:ලෙසතෝ
      LT:ලිතුවේනියාව
      LU:ලක්ශම්බර්ග්
      LV:ලැට්වියාව
      LY:ලිබියාව
      MA:මොරොක්කෝව
      MC:මොනාකෝව
      MD:මොල්ඩෝවාව
      ME:මොන්ටෙනීග්‍රෝ
      MF:ශාන්ත මාර්ටින්
      MG:මැඩගස්කරය
      MH:මාෂල් දූපත්
      MK:උතුරු මැසිඩෝනියාව
      ML:මාලි
      MM:මියන්මාරය (බුරුමය)
      MN:මොන්ගෝලියාව
      MO:මැකාවු විශේෂ පරිපාලන කලාපය චීනය
      MP:උතුරු මරියානා දූපත්
      MQ:මර්ටිනික්
      MR:මොරිටේනියාව
      MS:මොන්සෙරාට්
      MT:මෝල්ටාව
      MU:මුරුසිය
      MV:මාල දිවයින
      MW:මලාවි
      MX:මෙක්සිකෝව
      MY:මැලේසියාව
      MZ:මොසැම්බික්
      NA:නැමීබියාව
      NC:නව කැලිඩෝනියාව
      NE:නයිජර්
      NF:නෝෆෝක් දූපත
      NG:නයිජීරියාව
      NI:නිකරගුවාව
      NL:නෙදර්ලන්තය
      NO:නෝර්වේ
      NP:නේපාලය
      NR:නාවුරු
      NU:නියූ
      NZ:නවසීලන්තය
      OM:ඕමානය
      PA:පැනමාව
      PE:පේරු
      PF:ප්‍රංශ පොලිනීසියාව
      PG:පැපුවා නිව් ගිනියාව
      PH:පිලිපීනය
      PK:පාකිස්තානය
      PL:පෝලන්තය
      PM:ශාන්ත පියරේ සහ මැකෝලන්
      PN:පිට්කෙය්න් දූපත්
      PR:පුවර්ටෝ රිකෝ
      PS:පලස්තීන රාජ්‍යය
      PT:පෘතුගාලය
      PW:පලාවු
      PY:පැරගුවේ
      QA:කටාර්
      QO:ඈත ඕෂනියාව
      RE:රීයුනියන්
      RO:රුමේනියාව
      RS:සර්බියාව
      RU:රුසියාව
      RW:රුවන්ඩාව
      SA:සෞදි අරාබිය
      SB:සොලමන් දූපත්
      SC:සීශෙල්ස්
      SD:සූඩානය
      SE:ස්වීඩනය
      SG:සිංගප්පූරුව
      SH:ශාන්ත හෙලේනා
      SI:ස්ලෝවේනියාව
      SJ:ස්වෙල්බර්ඩ් සහ ජේන් මයේන්
      SK:ස්ලෝවැකියාව
      SL:සියරාලියෝන්
      SM:සැන් මැරිනෝ
      SN:සෙනගාලය
      SO:සෝමාලියාව
      SR:සුරිනාමය
      SS:දකුණු සුඩානය
      ST:සාඕ තෝම් සහ ප්‍රින්සිප්
      SV:එල් සැල්වදෝරය
      SX:ශාන්ත මාර්ටෙන්
      SY:සිරියාව
      SZ:එස්වාටිනි
      TA:ට්‍රිස්ටන් ද කුන්හා
      TC:ටර්ක්ස් සහ කයිකොස් දූපත්
      TD:චැච්
      TF:දකුණු ප්‍රංශ දූපත් සමූහය
      TG:ටොගෝ
      TH:තායිලන්තය
      TJ:ටජිකිස්තානය
      TK:ටොකලාවු
      TL:ටිමෝර් - ලෙස්ත්
      TM:ටර්ක්මෙනිස්ථානය
      TN:ටියුනීසියාව
      TO:ටොංගා
      TR:තුර්කිය
      TT:ට්‍රිනිඩෑඩ් සහ ටොබැගෝ
      TV:ටුවාලූ
      TW:තායිවානය
      TZ:ටැන්සානියාව
      UA:යුක්රේනය
      UG:උගන්ඩාව
      UM:එක්සත් ජනපද ඈත දූපත්
      UN:එක්සත් ජාතීන්
      US:එක්සත් ජනපදය
      UY:උරුගුවේ
      UZ:උස්බෙකිස්ථානය
      VA:වතිකානු නගරය
      VC:ශාන්ත වින්සන්ට් සහ ග්‍රෙනඩින්ස්
      VE:වෙනිසියුලාව
      VG:බ්‍රිතාන්‍ය වර්ජින් දූපත්
      VI:ඇමරිකානු වර්ජින් දූපත්
      VN:වියට්නාමය
      VU:වනුවාටු
      WF:වැලිස් සහ ෆුටුනා
      WS:සැමෝවා
      XA:ව්‍යාජ-උච්චාරණ
      XB:ව්‍යාජ-බිඩි
      XK:කොසෝවෝ
      YE:යේමනය
      YT:මයෝට්
      ZA:දකුණු අප්‍රිකාව
      ZM:සැම්බියාව
      ZW:සිම්බාබ්වේ
      ZZ:හඳුනා නොගත් කළාපය
      """.trimIndent() }

  val sk: String by lazy { """
      001:svet
      002:Afrika
      003:Severná Amerika
      005:Južná Amerika
      009:Oceánia
      011:západná Afrika
      013:Stredná Amerika
      014:východná Afrika
      015:severná Afrika
      017:stredná Afrika
      018:južné územia Afriky
      019:Amerika
      021:severné územia Ameriky
      029:Karibik
      030:východná Ázia
      034:južná Ázia
      035:juhovýchodná Ázia
      039:južná Európa
      053:Australázia
      054:Melanézia
      057:oblasť Mikronézie
      061:Polynézia
      142:Ázia
      143:stredná Ázia
      145:západná Ázia
      150:Európa
      151:východná Európa
      154:severná Európa
      155:západná Európa
      202:subsaharská Afrika
      419:Latinská Amerika
      AC:Ascension
      AD:Andorra
      AE:Spojené arabské emiráty
      AF:Afganistan
      AG:Antigua a Barbuda
      AI:Anguilla
      AL:Albánsko
      AM:Arménsko
      AO:Angola
      AQ:Antarktída
      AR:Argentína
      AS:Americká Samoa
      AT:Rakúsko
      AU:Austrália
      AW:Aruba
      AX:Alandy
      AZ:Azerbajdžan
      BA:Bosna a Hercegovina
      BB:Barbados
      BD:Bangladéš
      BE:Belgicko
      BF:Burkina Faso
      BG:Bulharsko
      BH:Bahrajn
      BI:Burundi
      BJ:Benin
      BL:Svätý Bartolomej
      BM:Bermudy
      BN:Brunej
      BO:Bolívia
      BQ:Karibské Holandsko
      BR:Brazília
      BS:Bahamy
      BT:Bhután
      BV:Bouvetov ostrov
      BW:Botswana
      BY:Bielorusko
      BZ:Belize
      CA:Kanada
      CC:Kokosové ostrovy
      CD:Konžská demokratická republika
      CF:Stredoafrická republika
      CG:Konžská republika
      CH:Švajčiarsko
      CI:Pobrežie Slonoviny
      CK:Cookove ostrovy
      CL:Čile
      CM:Kamerun
      CN:Čína
      CO:Kolumbia
      CP:Clipperton
      CR:Kostarika
      CU:Kuba
      CV:Kapverdy
      CW:Curaçao
      CX:Vianočný ostrov
      CY:Cyprus
      CZ:Česko
      DE:Nemecko
      DG:Diego Garcia
      DJ:Džibutsko
      DK:Dánsko
      DM:Dominika
      DO:Dominikánska republika
      DZ:Alžírsko
      EA:Ceuta a Melilla
      EC:Ekvádor
      EE:Estónsko
      EG:Egypt
      EH:Západná Sahara
      ER:Eritrea
      ES:Španielsko
      ET:Etiópia
      EU:Európska únia
      EZ:eurozóna
      FI:Fínsko
      FJ:Fidži
      FK:Falklandy
      FM:Mikronézia
      FO:Faerské ostrovy
      FR:Francúzsko
      GA:Gabon
      GB:Spojené kráľovstvo
      GD:Grenada
      GE:Gruzínsko
      GF:Francúzska Guyana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltár
      GL:Grónsko
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Rovníková Guinea
      GR:Grécko
      GS:Južná Georgia a Južné Sandwichove ostrovy
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hongkong – OAO Číny
      HM:Heardov ostrov a Macdonaldove ostrovy
      HN:Honduras
      HR:Chorvátsko
      HT:Haiti
      HU:Maďarsko
      IC:Kanárske ostrovy
      ID:Indonézia
      IE:Írsko
      IL:Izrael
      IM:Ostrov Man
      IN:India
      IO:Britské indickooceánske územie
      IQ:Irak
      IR:Irán
      IS:Island
      IT:Taliansko
      JE:Jersey
      JM:Jamajka
      JO:Jordánsko
      JP:Japonsko
      KE:Keňa
      KG:Kirgizsko
      KH:Kambodža
      KI:Kiribati
      KM:Komory
      KN:Svätý Krištof a Nevis
      KP:Severná Kórea
      KR:Južná Kórea
      KW:Kuvajt
      KY:Kajmanie ostrovy
      KZ:Kazachstan
      LA:Laos
      LB:Libanon
      LC:Svätá Lucia
      LI:Lichtenštajnsko
      LK:Srí Lanka
      LR:Libéria
      LS:Lesotho
      LT:Litva
      LU:Luxembursko
      LV:Lotyšsko
      LY:Líbya
      MA:Maroko
      MC:Monako
      MD:Moldavsko
      ME:Čierna Hora
      MF:Svätý Martin (fr.)
      MG:Madagaskar
      MH:Marshallove ostrovy
      MK:Severné Macedónsko
      ML:Mali
      MM:Mjanmarsko
      MN:Mongolsko
      MO:Macao – OAO Číny
      MP:Severné Mariány
      MQ:Martinik
      MR:Mauritánia
      MS:Montserrat
      MT:Malta
      MU:Maurícius
      MV:Maldivy
      MW:Malawi
      MX:Mexiko
      MY:Malajzia
      MZ:Mozambik
      NA:Namíbia
      NC:Nová Kaledónia
      NE:Niger
      NF:Norfolk
      NG:Nigéria
      NI:Nikaragua
      NL:Holandsko
      NO:Nórsko
      NP:Nepál
      NR:Nauru
      NU:Niue
      NZ:Nový Zéland
      OM:Omán
      PA:Panama
      PE:Peru
      PF:Francúzska Polynézia
      PG:Papua-Nová Guinea
      PH:Filipíny
      PK:Pakistan
      PL:Poľsko
      PM:Saint Pierre a Miquelon
      PN:Pitcairnove ostrovy
      PR:Portoriko
      PS:Palestínske územia
      PT:Portugalsko
      PW:Palau
      PY:Paraguaj
      QA:Katar
      QO:ostatné Tichomorie
      RE:Réunion
      RO:Rumunsko
      RS:Srbsko
      RU:Rusko
      RW:Rwanda
      SA:Saudská Arábia
      SB:Šalamúnove ostrovy
      SC:Seychely
      SD:Sudán
      SE:Švédsko
      SG:Singapur
      SH:Svätá Helena
      SI:Slovinsko
      SJ:Svalbard a Jan Mayen
      SK:Slovensko
      SL:Sierra Leone
      SM:San Maríno
      SN:Senegal
      SO:Somálsko
      SR:Surinam
      SS:Južný Sudán
      ST:Svätý Tomáš a Princov ostrov
      SV:Salvádor
      SX:Svätý Martin (hol.)
      SY:Sýria
      SZ:Eswatini
      TA:Tristan da Cunha
      TC:Turks a Caicos
      TD:Čad
      TF:Francúzske južné a antarktické územia
      TG:Togo
      TH:Thajsko
      TJ:Tadžikistan
      TK:Tokelau
      TL:Východný Timor
      TM:Turkménsko
      TN:Tunisko
      TO:Tonga
      TR:Turecko
      TT:Trinidad a Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzánia
      UA:Ukrajina
      UG:Uganda
      UM:Menšie odľahlé ostrovy USA
      UN:Organizácia Spojených národov
      US:Spojené štáty
      UY:Uruguaj
      UZ:Uzbekistan
      VA:Vatikán
      VC:Svätý Vincent a Grenadíny
      VE:Venezuela
      VG:Britské Panenské ostrovy
      VI:Americké Panenské ostrovy
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis a Futuna
      WS:Samoa
      XA:falošná diakritika
      XB:obrátenie sprava doľava
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Južná Afrika
      ZM:Zambia
      ZW:Zimbabwe
      ZZ:neznámy región
      """.trimIndent() }

  val sl: String by lazy { """
      001:svet
      002:Afrika
      003:Severna Amerika
      005:Južna Amerika
      009:Oceanija
      011:Zahodna Afrika
      013:Srednja Amerika
      014:Vzhodna Afrika
      015:Severna Afrika
      017:Srednja Afrika
      018:Južna Afrika
      019:Amerike
      021:severnoameriška celina
      029:Karibi
      030:Vzhodna Azija
      034:Južna Azija
      035:Jugovzhodna Azija
      039:Južna Evropa
      053:Avstralija in Nova Zelandija
      054:Melanezija
      057:mikronezijska regija
      061:Polinezija
      142:Azija
      143:Osrednja Azija
      145:Zahodna Azija
      150:Evropa
      151:Vzhodna Evropa
      154:Severna Evropa
      155:Zahodna Evropa
      202:podsaharska Afrika
      419:Latinska Amerika
      AC:Otok Ascension
      AD:Andora
      AE:Združeni arabski emirati
      AF:Afganistan
      AG:Antigva in Barbuda
      AI:Angvila
      AL:Albanija
      AM:Armenija
      AO:Angola
      AQ:Antarktika
      AR:Argentina
      AS:Ameriška Samoa
      AT:Avstrija
      AU:Avstralija
      AW:Aruba
      AX:Ålandski otoki
      AZ:Azerbajdžan
      BA:Bosna in Hercegovina
      BB:Barbados
      BD:Bangladeš
      BE:Belgija
      BF:Burkina Faso
      BG:Bolgarija
      BH:Bahrajn
      BI:Burundi
      BJ:Benin
      BL:Saint Barthélemy
      BM:Bermudi
      BN:Brunej
      BO:Bolivija
      BQ:Nizozemski Karibi
      BR:Brazilija
      BS:Bahami
      BT:Butan
      BV:Bouvetov otok
      BW:Bocvana
      BY:Belorusija
      BZ:Belize
      CA:Kanada
      CC:Kokosovi otoki
      CD:Demokratična republika Kongo
      CF:Srednjeafriška republika
      CG:Kongo - Brazzaville
      CH:Švica
      CI:Slonokoščena obala
      CK:Cookovi otoki
      CL:Čile
      CM:Kamerun
      CN:Kitajska
      CO:Kolumbija
      CP:Otok Clipperton
      CR:Kostarika
      CU:Kuba
      CV:Zelenortski otoki
      CW:Curaçao
      CX:Božični otok
      CY:Ciper
      CZ:Češka
      DE:Nemčija
      DG:Diego Garcia
      DJ:Džibuti
      DK:Danska
      DM:Dominika
      DO:Dominikanska republika
      DZ:Alžirija
      EA:Ceuta in Melilla
      EC:Ekvador
      EE:Estonija
      EG:Egipt
      EH:Zahodna Sahara
      ER:Eritreja
      ES:Španija
      ET:Etiopija
      EU:Evropska unija
      EZ:evroobmočje
      FI:Finska
      FJ:Fidži
      FK:Falklandski otoki
      FM:Mikronezija
      FO:Ferski otoki
      FR:Francija
      GA:Gabon
      GB:Združeno kraljestvo
      GD:Grenada
      GE:Gruzija
      GF:Francoska Gvajana
      GG:Guernsey
      GH:Gana
      GI:Gibraltar
      GL:Grenlandija
      GM:Gambija
      GN:Gvineja
      GP:Guadeloupe
      GQ:Ekvatorialna Gvineja
      GR:Grčija
      GS:Južna Georgia in Južni Sandwichevi otoki
      GT:Gvatemala
      GU:Guam
      GW:Gvineja Bissau
      GY:Gvajana
      HK:Posebno upravno območje Ljudske republike Kitajske Hongkong
      HM:Heardov otok in McDonaldovi otoki
      HN:Honduras
      HR:Hrvaška
      HT:Haiti
      HU:Madžarska
      IC:Kanarski otoki
      ID:Indonezija
      IE:Irska
      IL:Izrael
      IM:Otok Man
      IN:Indija
      IO:Britansko ozemlje v Indijskem oceanu
      IQ:Irak
      IR:Iran
      IS:Islandija
      IT:Italija
      JE:Jersey
      JM:Jamajka
      JO:Jordanija
      JP:Japonska
      KE:Kenija
      KG:Kirgizistan
      KH:Kambodža
      KI:Kiribati
      KM:Komori
      KN:Saint Kitts in Nevis
      KP:Severna Koreja
      KR:Južna Koreja
      KW:Kuvajt
      KY:Kajmanski otoki
      KZ:Kazahstan
      LA:Laos
      LB:Libanon
      LC:Saint Lucia
      LI:Lihtenštajn
      LK:Šrilanka
      LR:Liberija
      LS:Lesoto
      LT:Litva
      LU:Luksemburg
      LV:Latvija
      LY:Libija
      MA:Maroko
      MC:Monako
      MD:Moldavija
      ME:Črna gora
      MF:Saint Martin
      MG:Madagaskar
      MH:Marshallovi otoki
      MK:Severna Makedonija
      ML:Mali
      MM:Mjanmar (Burma)
      MN:Mongolija
      MO:Posebno upravno območje Ljudske republike Kitajske Macao
      MP:Severni Marianski otoki
      MQ:Martinik
      MR:Mavretanija
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldivi
      MW:Malavi
      MX:Mehika
      MY:Malezija
      MZ:Mozambik
      NA:Namibija
      NC:Nova Kaledonija
      NE:Niger
      NF:Norfolški otok
      NG:Nigerija
      NI:Nikaragva
      NL:Nizozemska
      NO:Norveška
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Nova Zelandija
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Francoska Polinezija
      PG:Papua Nova Gvineja
      PH:Filipini
      PK:Pakistan
      PL:Poljska
      PM:Saint Pierre in Miquelon
      PN:Pitcairn
      PR:Portoriko
      PS:Palestinsko ozemlje
      PT:Portugalska
      PW:Palau
      PY:Paragvaj
      QA:Katar
      QO:Ostala oceanija
      RE:Reunion
      RO:Romunija
      RS:Srbija
      RU:Rusija
      RW:Ruanda
      SA:Saudova Arabija
      SB:Salomonovi otoki
      SC:Sejšeli
      SD:Sudan
      SE:Švedska
      SG:Singapur
      SH:Sveta Helena
      SI:Slovenija
      SJ:Svalbard in Jan Mayen
      SK:Slovaška
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalija
      SR:Surinam
      SS:Južni Sudan
      ST:Sao Tome in Principe
      SV:Salvador
      SX:Sint Maarten
      SY:Sirija
      SZ:Esvatini
      TA:Tristan da Cunha
      TC:Otoki Turks in Caicos
      TD:Čad
      TF:Francosko južno ozemlje
      TG:Togo
      TH:Tajska
      TJ:Tadžikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunizija
      TO:Tonga
      TR:Turčija
      TT:Trinidad in Tobago
      TV:Tuvalu
      TW:Tajvan
      TZ:Tanzanija
      UA:Ukrajina
      UG:Uganda
      UM:Stranski zunanji otoki Združenih držav
      UN:Združeni narodi
      US:Združene države Amerike
      UY:Urugvaj
      UZ:Uzbekistan
      VA:Vatikan
      VC:Saint Vincent in Grenadine
      VE:Venezuela
      VG:Britanski Deviški otoki
      VI:Ameriški Deviški otoki
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis in Futuna
      WS:Samoa
      XA:psevdonaglasi
      XB:psevdobidi
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Južnoafriška republika
      ZM:Zambija
      ZW:Zimbabve
      ZZ:Neznano ali neveljavno območje
      """.trimIndent() }

  val smn: String by lazy { """
      AC:Ascension-suálui
      AD:Andorra
      AE:Arabiemirkodeh
      AF:Afganistan
      AG:Antigua já Barbuda
      AI:Anguilla
      AL:Albania
      AM:Armenia
      AO:Angola
      AQ:Antarktis
      AR:Argentina
      AS:Amerika Samoa
      AT:Nuorttâriijkâ
      AU:Australia
      AW:Aruba
      AX:Vuáskueennâm
      AZ:Azerbaidžan
      BA:Bosnia já Herzegovina
      BB:Barbados
      BD:Bangladesh
      BE:Belgia
      BF:Burkina Faso
      BG:Bulgaria
      BH:Bahrain
      BI:Burundi
      BJ:Benin
      BL:St. Barthélemy
      BM:Bermuda
      BN:Brunei
      BO:Bolivia
      BR:Brasilia
      BS:Bahama
      BT:Bhutan
      BV:Bouvetsuálui
      BW:Botswana
      BY:Vielgis-Ruoššâ
      BZ:Belize
      CA:Kanada
      CC:Kookossuolluuh (Keelingsuolluuh)
      CD:Kongo demokraattisâš täsiväldi
      CF:Koskâ-Afrika täsiväldi
      CG:Kongo täsiväldi
      CH:Sveitsi
      CI:Côte d’Ivoire
      CK:Cooksuolluuh
      CL:Chile
      CM:Kamerun
      CN:Kiina
      CO:Kolumbia
      CP:Clippertonsuálui
      CR:Costa Rica
      CU:Kuuba
      CV:Cape Verde
      CW:Curaçao
      CX:Juovlâsuálui
      CY:Kypros
      CZ:Tšekki
      DE:Saksa
      DG:Diego Garcia
      DJ:Djibouti
      DK:Tanska
      DM:Dominica
      DO:Dominikaanisâš täsiväldi
      DZ:Algeria
      EA:Ceuta já Melilla
      EC:Ecuador
      EE:Eestieennâm
      EG:Egypti
      ER:Eritrea
      ES:Espanja
      ET:Etiopia
      FI:Suomâ
      FJ:Fidži
      FK:Falklandsuolluuh
      FM:Mikronesia littoväldi
      FO:Färsuolluuh
      FR:Ranska
      GA:Gabon
      GB:Ovtâstum Kunâgâskodde
      GD:Grenada
      GE:Georgia
      GF:Ranska Guyana
      GG:Guernsey
      GH:Ghana
      GI:Gibraltar
      GL:Grönland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Peeivitäsideijee Guinea
      GR:Kreikka
      GS:Maadâ-Georgia já Máddááh Sandwichsuolluuh
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HK:Hongkong – Kiina e.h.k.
      HM:Heard já McDonaldsuolluuh
      HN:Honduras
      HR:Kroatia
      HT:Haiti
      HU:Uŋgar
      IC:Kanariasuolluuh
      ID:Indonesia
      IE:Irland
      IL:Israel
      IM:Mansuálui
      IN:India
      IQ:Irak
      IR:Iran
      IS:Island
      IT:Italia
      JE:Jersey
      JM:Jamaika
      JO:Jordan
      JP:Jaapaan
      KE:Kenia
      KG:Kirgisia
      KH:Kambodža
      KI:Kiribati
      KM:Komoreh
      KN:St. Kitts já Nevis
      KP:Tave-Korea
      KR:Maadâ-Korea
      KW:Kuwait
      KY:Caymansuolluuh
      KZ:Kazakstan
      LA:Laos
      LB:Libanon
      LC:St. Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Liettua
      LU:Luxemburg
      LV:Latvia
      LY:Libya
      MA:Marokko
      MC:Monaco
      MD:Moldova
      ME:Montenegro
      MF:St. Martin
      MG:Madagaskar
      MH:Marshallsuolluuh
      ML:Mali
      MM:Myanmar (Burma)
      MN:Mongolia
      MO:Macao - – Kiina e.h.k.
      MP:Tave-Marianeh
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Malediveh
      MW:Malawi
      MX:Meksiko
      MY:Malaysia
      MZ:Mosambik
      NA:Namibia
      NC:Uđđâ-Kaledonia
      NE:Niger
      NF:Norfolksuálui
      NG:Nigeria
      NI:Nicaragua
      NL:Vuáládâhenâmeh
      NO:Taažâ
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Uđđâ-Seeland
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Ranska Polynesia
      PG:Papua-Uđđâ-Guinea
      PH:Filipineh
      PK:Pakistan
      PL:Puola
      PM:St. Pierre já Miquelon
      PN:Pitcairn
      PR:Puerto Rico
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      RE:Réunion
      RO:Romania
      RS:Serbia
      RU:Ruoššâ
      RW:Ruanda
      SA:Saudi Arabia
      SB:Salomosuolluuh
      SC:Seychelleh
      SD:Sudan
      SE:Ruotâ
      SG:Singapore
      SH:Saint Helena
      SI:Slovenia
      SJ:Čokkeväärih já Jan Mayen
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Surinam
      SS:Maadâ-Sudan
      ST:São Tomé já Príncipe
      SV:El Salvador
      SX:Sint Maarten
      SY:Syria
      SZ:Swazieennâm
      TA:Tristan da Cunha
      TC:Turks- já Caicossuolluuh
      TD:Tšad
      TF:Ranska máddááh kuávluh
      TG:Togo
      TH:Thaieennâm
      TJ:Tadžikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turkki
      TT:Trinidad já Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tansania
      UA:Ukraina
      UG:Uganda
      UM:Ovtâstum Staatâi sierânâssuolluuh
      US:Ovtâstum Staatah
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatikan
      VC:St. Vincent já Grenadines
      VE:Venezuela
      VG:Brittiliih Nieidâsuolluuh
      VI:Ovtâstum Staatâi Nieidâsuolluuh
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis já Futuna
      WS:Samoa
      XK:Kosovo
      YE:Jemen
      YT:Mayotte
      ZA:Maadâ-Afrikka
      ZM:Sambia
      ZW:Zimbabwe
      """.trimIndent() }

  val sn: String by lazy { """
      AD:Andora
      AE:United Arab Emirates
      AF:Afuganistani
      AG:Antigua ne Barbuda
      AI:Anguila
      AL:Albania
      AM:Armenia
      AO:Angola
      AR:Ajentina
      AS:Samoa ye Amerika
      AT:Austria
      AU:Australia
      AW:Arubha
      AZ:Azabajani
      BA:Boznia ne Herzegovina
      BB:Barbados
      BD:Bangladeshi
      BE:Beljium
      BF:Bukinafaso
      BG:Bulgaria
      BH:Bahareni
      BI:Burundi
      BJ:Benini
      BM:Bermuda
      BN:Burunei
      BO:Bolivia
      BR:Brazil
      BS:Bahama
      BT:Bhutani
      BW:Botswana
      BY:Belarusi
      BZ:Belize
      CA:Kanada
      CD:Democratic Reof the Congo
      CF:Central African Republic
      CG:Kongo
      CH:Switzerland
      CI:Ivory Coast
      CK:Zvitsuwa zveCook
      CL:Chile
      CM:Kameruni
      CN:China
      CO:Kolombia
      CR:Kostarika
      CU:Cuba
      CV:Zvitsuwa zveCape Verde
      CY:Cyprus
      CZ:Czech Republic
      DE:Germany
      DJ:Djibouti
      DK:Denmark
      DM:Dominica
      DO:Dominican Republic
      DZ:Aljeria
      EC:Ecuador
      EE:Estonia
      EG:Egypt
      ER:Eritrea
      ES:Spain
      ET:Etiopia
      FI:Finland
      FJ:Fiji
      FK:Zvitsuwa zveFalklands
      FM:Micronesia
      FR:France
      GA:Gabon
      GB:United Kingdom
      GD:Grenada
      GE:Georgia
      GF:French Guiana
      GH:Ghana
      GI:Gibraltar
      GL:Greenland
      GM:Gambia
      GN:Guinea
      GP:Guadeloupe
      GQ:Equatorial Guinea
      GR:Greece
      GT:Guatemala
      GU:Guam
      GW:Guinea-Bissau
      GY:Guyana
      HN:Honduras
      HR:Korasia
      HT:Haiti
      HU:Hungary
      ID:Indonesia
      IE:Ireland
      IL:Izuraeri
      IN:India
      IQ:Iraq
      IR:Iran
      IS:Iceland
      IT:Italy
      JM:Jamaica
      JO:Jordan
      JP:Japan
      KE:Kenya
      KG:Kyrgyzstan
      KH:Kambodia
      KI:Kiribati
      KM:Komoro
      KN:Saint Kitts and Nevis
      KP:Korea, North
      KR:Korea, South
      KW:Kuwait
      KY:Zvitsuwa zveCayman
      KZ:Kazakhstan
      LA:Laos
      LB:Lebanon
      LC:Saint Lucia
      LI:Liechtenstein
      LK:Sri Lanka
      LR:Liberia
      LS:Lesotho
      LT:Lithuania
      LU:Luxembourg
      LV:Latvia
      LY:Libya
      MA:Morocco
      MC:Monaco
      MD:Moldova
      MG:Madagascar
      MH:Zvitsuwa zveMarshall
      ML:Mali
      MM:Myanmar
      MN:Mongolia
      MP:Zvitsuwa zvekumaodzanyemba eMariana
      MQ:Martinique
      MR:Mauritania
      MS:Montserrat
      MT:Malta
      MU:Mauritius
      MV:Maldives
      MW:Malawi
      MX:Mexico
      MY:Malaysia
      MZ:Mozambique
      NA:Namibia
      NC:New Caledonia
      NE:Niger
      NF:Chitsuwa cheNorfolk
      NG:Nigeria
      NI:Nicaragua
      NL:Netherlands
      NO:Norway
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:New Zealand
      OM:Oman
      PA:Panama
      PE:Peru
      PF:French Polynesia
      PG:Papua New Guinea
      PH:Philippines
      PK:Pakistan
      PL:Poland
      PM:Saint Pierre and Miquelon
      PN:Pitcairn
      PR:Puerto Rico
      PT:Portugal
      PW:Palau
      PY:Paraguay
      QA:Qatar
      RE:Réunion
      RO:Romania
      RU:Russia
      RW:Rwanda
      SA:Saudi Arabia
      SB:Zvitsuwa zvaSolomon
      SC:Seychelles
      SD:Sudan
      SE:Sweden
      SG:Singapore
      SH:Saint Helena
      SI:Slovenia
      SK:Slovakia
      SL:Sierra Leone
      SM:San Marino
      SN:Senegal
      SO:Somalia
      SR:Suriname
      ST:São Tomé and Príncipe
      SV:El Salvador
      SY:Syria
      SZ:Swaziland
      TC:Zvitsuwa zveTurk neCaico
      TD:Chadi
      TG:Togo
      TH:Thailand
      TJ:Tajikistan
      TK:Tokelau
      TL:East Timor
      TM:Turkmenistan
      TN:Tunisia
      TO:Tonga
      TR:Turkey
      TT:Trinidad and Tobago
      TV:Tuvalu
      TW:Taiwan
      TZ:Tanzania
      UA:Ukraine
      UG:Uganda
      US:Amerika
      UY:Uruguay
      UZ:Uzbekistan
      VA:Vatican State
      VC:Saint Vincent and the Grenadines
      VE:Venezuela
      VG:Zvitsuwa zveHingirandi
      VI:Zvitsuwa zveAmerika
      VN:Vietnam
      VU:Vanuatu
      WF:Wallis and Futuna
      WS:Samoa
      YE:Yemen
      YT:Mayotte
      ZA:South Africa
      ZM:Zambia
      ZW:Zimbabwe
      """.trimIndent() }

  val so: String by lazy { """
      001:dunida
      002:Afrika
      003:Waqooyi Ameerika
      005:Koonfur Ameerika
      009:Osheeniya
      011:Galbeeka Afrika
      013:Bartamaha Ameerika
      014:Afrikada Bari
      015:Waqooyiga Afrika
      017:Afrikada Dhexe
      018:Afrikada Koonfureed
      019:Ameerikaas
      021:Waqooyiga Ameerika
      029:Karibiyaan
      030:Aasiyada Bari
      034:Aasiyada Koonfureed
      035:Aasiyada Koonfur-galbeed
      039:Yurubta Koonfureed
      053:Austraalaasiya
      054:Melaneesiya
      057:Gobolka Aasiyada yar
      061:Booliyneesiya
      142:Aasiya
      143:Bartamaha Aasiya
      145:Aasiyada Galbeed
      150:Yurub
      151:Yurubta Bari
      154:Yurubta Waqooyi
      155:Yurubta Galbeed
      202:Afrikada ka hooseysa Saxaraha
      419:Laatiin Ameerika
      AC:Jasiiradda Asensiyoon
      AD:Andora
      AE:Midawga Imaaraatka Carabta
      AF:Afgaanistaan
      AG:Antigua & Barbuuda
      AI:Anguula
      AL:Albaaniya
      AM:Armeeniya
      AO:Angoola
      AQ:Antaarktika
      AR:Arjentiina
      AS:Samowa Ameerika
      AT:Awsteriya
      AU:Awstaraaliya
      AW:Aruba
      AX:Jasiiradda Aland
      AZ:Asarbajan
      BA:Boosniya & Harsegofina
      BB:Baarbadoos
      BD:Bangaladhesh
      BE:Biljam
      BF:Burkiina Faaso
      BG:Bulgaariya
      BH:Baxreyn
      BI:Burundi
      BJ:Biniin
      BL:St. Baathelemiy
      BM:Barmuuda
      BN:Buruneey
      BO:Boliifiya
      BQ:Karibiyaan Nadarlands
      BR:Baraasiil
      BS:Bahaamas
      BT:Buutan
      BV:Buufet Island
      BW:Botuswaana
      BY:Belarus
      BZ:Beliis
      CA:Kanada
      CC:Jasiiradda Kookoos
      CD:Jamhuuriyadda Dimuquraadiga Kongo
      CF:Jamhuuriyadda Afrikada Dhexe
      CG:Kongo
      CH:Swiiserlaand
      CI:Ayfori Koost
      CK:Jasiiradda Kook
      CL:Jili
      CM:Kaameruun
      CN:Shiinaha
      CO:Koloombiya
      CP:Jasiiradda Kilibarton
      CR:Costa Rica
      CU:Kuuba
      CV:Jasiiradda Kayb Faarde
      CW:Kurakaaw
      CX:Jasiiradda Kirismas
      CY:Qubrus
      CZ:Jekiya
      DE:Jarmal
      DG:Diyeego Karsiya
      DJ:Jabuuti
      DK:Denmark
      DM:Dominika
      DO:Jamhuuriyaddda Dominika
      DZ:Aljeeriya
      EA:Seyuta & Meliila
      EC:Ikuwadoor
      EE:Estooniya
      EG:Masar
      EH:Saxaraha Galbeed
      ER:Eritreeya
      ES:Isbeyn
      ET:Itoobiya
      EU:Midowga Yurub
      EZ:Yurusoon
      FI:Finland
      FJ:Fiji
      FK:Jaziiradaha Fooklaan
      FM:Mikroneesiya
      FO:Jasiiradda Faroo
      FR:Faransiis
      GA:Gaaboon
      GB:Boqortooyada Midowday
      GD:Giriinaada
      GE:Joorjiya
      GF:Faransiis Gini
      GG:Guurnsey
      GH:Gaana
      GI:Gibraltar
      GL:Greenland
      GM:Gambiya
      GN:Gini
      GP:Guadeluub
      GQ:Ekuwatooriyal Gini
      GR:Giriig
      GS:Jasiiradda Joorjiyada Koonfureed & Sandwij
      GT:Guwaatamaala
      GU:Guaam
      GW:Gini-Bisaaw
      GY:Guyana
      HK:Hong Kong
      HM:Jasiiradda Haad & MakDonald
      HN:Honduras
      HR:Korweeshiya
      HT:Haiti
      HU:Hangari
      IC:Jasiiradda Kanari
      ID:Indoneesiya
      IE:Ayrlaand
      IL:Israaʼiil
      IM:Jasiiradda Isle of Man
      IN:Hindiya
      IO:Dhul xadeedka Badweynta Hindiya ee Ingiriiska
      IQ:Ciraaq
      IR:Iiraan
      IS:Ayslaand
      IT:Talyaani
      JE:Jaarsey
      JM:Jamaaika
      JO:Urdun
      JP:Jabaan
      KE:Kenya
      KG:Kirgistaan
      KH:Kamboodiya
      KI:Kiribati
      KM:Komooros
      KN:St. Kitts iyo Nevis
      KP:Kuuriyada Waqooyi
      KR:Kuuriyada Koonfureed
      KW:Kuwayt
      KY:Cayman Islands
      KZ:Kasaakhistaan
      LA:Laos
      LB:Lubnaan
      LC:St. Lusia
      LI:Liyjtensteyn
      LK:Sirilaanka
      LR:Laybeeriya
      LS:Losooto
      LT:Lituweeniya
      LU:Luksemboorg
      LV:Latfiya
      LY:Liibya
      MA:Morooko
      MC:Moonako
      MD:Moldofa
      ME:Moontenegro
      MF:St. Maartin
      MG:Madagaskar
      MH:Jasiiradda Maarshal
      MK:Masedooniya Waqooyi
      ML:Maali
      MM:Mayanmar
      MN:Mongooliya
      MO:Makaaw
      MP:Jasiiradda Waqooyiga Mariaana
      MQ:Maartinik
      MR:Muritaaniya
      MS:Montserrat
      MT:Maalta
      MU:Mawrishiyaas
      MV:Maaldiifis
      MW:Malaawi
      MX:Meksiko
      MY:Malaysiya
      MZ:Musambiik
      NA:Namiibiya
      NC:Jasiiradda Niyuu Kaledooniya
      NE:Nayjer
      NF:Jasiiradda Noorfolk
      NG:Nayjeeriya
      NI:Nikaraaguwa
      NL:Nederlaands
      NO:Noorweey
      NP:Nebaal
      NR:Nauru
      NU:Niue
      NZ:Niyuusiilaand
      OM:Cumaan
      PA:Baanama
      PE:Beeru
      PF:Booliyneesiya Faransiiska
      PG:Babwa Niyuu Gini
      PH:Filibiin
      PK:Bakistaan
      PL:Booland
      PM:St. Pierre iyo Miquelon
      PN:Bitkairn
      PR:Bueerto Riiko
      PS:Dhulka Falastiiniyiinta daanta galbeed iyo marinka qasa
      PT:Bortugaal
      PW:Balaaw
      PY:Baraguaay
      QA:Qadar
      QO:Dhulxeebeedka Osheeniya
      RE:Riyuuniyon
      RO:Rumaaniya
      RS:Seerbiya
      RU:Ruush
      RW:Ruwanda
      SA:Sacuudi Carabiya
      SB:Jasiiradda Solomon
      SC:Sishelis
      SD:Suudaan
      SE:Iswidhan
      SG:Singaboor
      SH:Saynt Helena
      SI:Islofeeniya
      SJ:Jasiiradda Sfaldbaad & Jaan Mayen
      SK:Islofaakiya
      SL:Siraaliyoon
      SM:San Marino
      SN:Sinigaal
      SO:Soomaaliya
      SR:Surineym
      SS:Koonfur Suudaan
      ST:Sao Tome & Birincibal
      SV:El Salfadoor
      SX:Siint Maarteen
      SY:Suuriya
      SZ:Eswaatiini
      TA:Tiristan da Kunha
      TC:Turks & Kaikos Island
      TD:Jaad
      TF:Dhul xadeedka Koonfureed ee Faransiiska
      TG:Toogo
      TH:Taylaand
      TJ:Tajikistan
      TK:Tokelaaw
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tuniisiya
      TO:Tonga
      TR:Turki
      TT:Tirinidaad & Tobago
      TV:Tufaalu
      TW:Taywaan
      TZ:Tansaaniya
      UA:Yukrayn
      UG:Ugaanda
      UM:Jasiiradaha ka baxsan Maraykanka
      UN:Qaramada Midoobay
      US:Maraykanka
      UY:Uruguwaay
      UZ:Usbakistan
      VA:Magaalada Faatikaan
      VC:St. Finsent & Girenadiins
      VE:Fenisuweela
      VG:Biritish Farjin Island
      VI:U.S Fargin Island
      VN:Fiyetnaam
      VU:Fanuaatu
      WF:Walis & Futuna
      WS:Samoowa
      XA:Lahjadaha Pseudo
      XB:Pseudo-Bidi
      XK:Koosofo
      YE:Yaman
      YT:Mayotte
      ZA:Koonfur Afrika
      ZM:Saambiya
      ZW:Simbaabwe
      ZZ:Gobol aan la aqoonin
      """.trimIndent() }

  val so_DJ: String? = null

  val so_ET: String? = null

  val so_KE: String? = null

  val sq: String by lazy { """
      001:Bota
      002:Afrikë
      003:Amerika e Veriut
      005:Amerika e Jugut
      009:Oqeani
      011:Afrika Perëndimore
      013:Amerika Qendrore
      014:Afrika Lindore
      015:Afrika Veriore
      017:Afrika e Mesme
      018:Afrika Jugore
      019:Amerikë
      021:Amerika Veriore
      029:Karaibe
      030:Azia Lindore
      034:Azia Jugore
      035:Azia Juglindore
      039:Evropa Jugore
      053:Australazia
      054:Melanezia
      057:Rajoni Mikronezian
      061:Polinezia
      142:Azi
      143:Azia Qendrore
      145:Azia Perëndimore
      150:Evropë
      151:Evropa Lindore
      154:Evropa Veriore
      155:Evropa Perëndimore
      202:Afrika Subsahariane
      419:Amerika Latine
      AC:Ishulli Asenshion
      AD:Andorrë
      AE:Emiratet e Bashkuara Arabe
      AF:Afganistan
      AG:Antigua e Barbuda
      AI:Anguilë
      AL:Shqipëri
      AM:Armeni
      AO:Angolë
      AQ:Antarktikë
      AR:Argjentinë
      AS:Samoa Amerikane
      AT:Austri
      AU:Australi
      AW:Arubë
      AX:Ishujt Alandë
      AZ:Azerbajxhan
      BA:Bosnjë-Hercegovinë
      BB:Barbados
      BD:Bangladesh
      BE:Belgjikë
      BF:Burkina-Faso
      BG:Bullgari
      BH:Bahrejn
      BI:Burundi
      BJ:Benin
      BL:Sen-Bartelemi
      BM:Bermude
      BN:Brunei
      BO:Bolivi
      BQ:Karaibet holandeze
      BR:Brazil
      BS:Bahama
      BT:Butan
      BV:Ishulli Bove
      BW:Botsvanë
      BY:Bjellorusi
      BZ:Belizë
      CA:Kanada
      CC:Ishujt Kokos
      CD:Kongo-Kinshasa
      CF:Republika e Afrikës Qendrore
      CG:Kongo-Brazavilë
      CH:Zvicër
      CI:Côte d’Ivoire
      CK:Ishujt Kuk
      CL:Kili
      CM:Kamerun
      CN:Kinë
      CO:Kolumbi
      CP:Ishulli Klipërton
      CR:Kosta-Rikë
      CU:Kubë
      CV:Kepi i Gjelbër
      CW:Kurasao
      CX:Ishulli i Krishtlindjes
      CY:Qipro
      CZ:Çeki
      DE:Gjermani
      DG:Diego-Garsia
      DJ:Xhibuti
      DK:Danimarkë
      DM:Dominikë
      DO:Republika Dominikane
      DZ:Algjeri
      EA:Theuta e Melila
      EC:Ekuador
      EE:Estoni
      EG:Egjipt
      EH:Saharaja Perëndimore
      ER:Eritre
      ES:Spanjë
      ET:Etiopi
      EU:Bashkimi Evropian
      EZ:Zona euro
      FI:Finlandë
      FJ:Fixhi
      FK:Ishujt Falkland
      FM:Mikronezi
      FO:Ishujt Faroe
      FR:Francë
      GA:Gabon
      GB:Mbretëria e Bashkuar
      GD:Granadë
      GE:Gjeorgji
      GF:Guajana Franceze
      GG:Gernsej
      GH:Ganë
      GI:Gjibraltar
      GL:Grënlandë
      GM:Gambi
      GN:Guine
      GP:Guadelupë
      GQ:Guineja Ekuatoriale
      GR:Greqi
      GS:Xhorxha Jugore dhe Ishujt Senduiçë të Jugut
      GT:Guatemalë
      GU:Guam
      GW:Guine-Bisau
      GY:Guajanë
      HK:RPA i Hong-Kongut
      HM:Ishujt Hërd e Mekdonald
      HN:Honduras
      HR:Kroaci
      HT:Haiti
      HU:Hungari
      IC:Ishujt Kanarie
      ID:Indonezi
      IE:Irlandë
      IL:Izrael
      IM:Ishulli i Manit
      IN:Indi
      IO:Territori Britanik i Oqeanit Indian
      IQ:Irak
      IR:Iran
      IS:Islandë
      IT:Itali
      JE:Xhersej
      JM:Xhamajkë
      JO:Jordani
      JP:Japoni
      KE:Kenia
      KG:Kirgizi
      KH:Kamboxhia
      KI:Kiribati
      KM:Komore
      KN:Shën-Kits dhe Nevis
      KP:Kore e Veriut
      KR:Kore e Jugut
      KW:Kuvajt
      KY:Ishujt Kajman
      KZ:Kazakistan
      LA:Laos
      LB:Liban
      LC:Shën-Luçia
      LI:Lihtenshtajn
      LK:Sri-Lankë
      LR:Liberi
      LS:Lesoto
      LT:Lituani
      LU:Luksemburg
      LV:Letoni
      LY:Libi
      MA:Marok
      MC:Monako
      MD:Moldavi
      ME:Mal i Zi
      MF:Sen-Marten
      MG:Madagaskar
      MH:Ishujt Marshall
      MK:Maqedonia e Veriut
      ML:Mali
      MM:Mianmar (Burmë)
      MN:Mongoli
      MO:RPA i Makaos
      MP:Ishujt e Marianës Veriore
      MQ:Martinikë
      MR:Mauritani
      MS:Montserat
      MT:Maltë
      MU:Mauritius
      MV:Maldive
      MW:Malavi
      MX:Meksikë
      MY:Malajzi
      MZ:Mozambik
      NA:Namibi
      NC:Kaledoni e Re
      NE:Niger
      NF:Ishulli Norfolk
      NG:Nigeri
      NI:Nikaragua
      NL:Holandë
      NO:Norvegji
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Zelandë e Re
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Polinezia Franceze
      PG:Guineja e Re-Papua
      PH:Filipine
      PK:Pakistan
      PL:Poloni
      PM:Shën-Pier dhe Mikelon
      PN:Ishujt Pitkern
      PR:Porto-Riko
      PS:Territoret Palestineze
      PT:Portugali
      PW:Palau
      PY:Paraguai
      QA:Katar
      QO:Oqeania e Largët (Lindja e Largët)
      RE:Reunion
      RO:Rumani
      RS:Serbi
      RU:Rusi
      RW:Ruandë
      SA:Arabi Saudite
      SB:Ishujt Solomon
      SC:Sejshelle
      SD:Sudan
      SE:Suedi
      SG:Singapor
      SH:Shën-Elenë
      SI:Slloveni
      SJ:Svalbard e Jan-Majen
      SK:Sllovaki
      SL:Sierra-Leone
      SM:San-Marino
      SN:Senegal
      SO:Somali
      SR:Surinami
      SS:Sudani i Jugut
      ST:Sao-Tome e Principe
      SV:Salvador
      SX:Sint-Marten
      SY:Siri
      SZ:Esvatini
      TA:Tristan-da-Kuna
      TC:Ishujt Turks dhe Kaikos
      TD:Çad
      TF:Territoret Jugore Franceze
      TG:Togo
      TH:Tajlandë
      TJ:Taxhikistan
      TK:Tokelau
      TL:Timor-Leste
      TM:Turkmenistan
      TN:Tunizi
      TO:Tonga
      TR:Turqi
      TT:Trinidad e Tobago
      TV:Tuvalu
      TW:Tajvan
      TZ:Tanzani
      UA:Ukrainë
      UG:Ugandë
      UM:Ishujt Periferikë të SHBA-së
      UN:Organizata e Kombeve të Bashkuara
      US:SHBA
      UY:Uruguai
      UZ:Uzbekistan
      VA:Vatikan
      VC:Shën-Vincent dhe Grenadine
      VE:Venezuelë
      VG:Ishujt e Virgjër Britanikë
      VI:Ishujt e Virgjër të SHBA-së
      VN:Vietnam
      VU:Vanuatu
      WF:Uollis e Futuna
      WS:Samoa
      XA:Pseudo-thekse
      XB:Pseudo-bidi
      XK:Kosovë
      YE:Jemen
      YT:Majotë
      ZA:Afrika e Jugut
      ZM:Zambi
      ZW:Zimbabve
      ZZ:I panjohur
      """.trimIndent() }

  val sq_MK: String? = null

  val sq_XK: String? = null

  val sr: String by lazy { """
      001:свет
      002:Африка
      003:Северноамерички континент
      005:Јужна Америка
      009:Океанија
      011:Западна Африка
      013:Централна Америка
      014:Источна Африка
      015:Северна Африка
      017:Централна Африка
      018:Јужна Африка
      019:Северна и Јужна Америка
      021:Северна Америка
      029:Кариби
      030:Источна Азија
      034:Јужна Азија
      035:Југоисточна Азија
      039:Јужна Европа
      053:Аустралија и Нови Зеланд
      054:Меланезија
      057:Микронезијски регион
      061:Полинезија
      142:Азија
      143:Централна Азија
      145:Западна Азија
      150:Европа
      151:Источна Европа
      154:Северна Европа
      155:Западна Европа
      202:Подсахарска Африка
      419:Латинска Америка
      AC:Острво Асенсион
      AD:Андора
      AE:Уједињени Арапски Емирати
      AF:Авганистан
      AG:Антигва и Барбуда
      AI:Ангвила
      AL:Албанија
      AM:Јерменија
      AO:Ангола
      AQ:Антарктик
      AR:Аргентина
      AS:Америчка Самоа
      AT:Аустрија
      AU:Аустралија
      AW:Аруба
      AX:Оландска Острва
      AZ:Азербејџан
      BA:Босна и Херцеговина
      BB:Барбадос
      BD:Бангладеш
      BE:Белгија
      BF:Буркина Фасо
      BG:Бугарска
      BH:Бахреин
      BI:Бурунди
      BJ:Бенин
      BL:Свети Бартоломеј
      BM:Бермуди
      BN:Брунеј
      BO:Боливија
      BQ:Карипска Холандија
      BR:Бразил
      BS:Бахами
      BT:Бутан
      BV:Острво Буве
      BW:Боцвана
      BY:Белорусија
      BZ:Белизе
      CA:Канада
      CC:Кокосова (Килингова) Острва
      CD:Конго - Киншаса
      CF:Централноафричка Република
      CG:Конго - Бразавил
      CH:Швајцарска
      CI:Обала Слоноваче (Кот д’Ивоар)
      CK:Кукова Острва
      CL:Чиле
      CM:Камерун
      CN:Кина
      CO:Колумбија
      CP:Острво Клипертон
      CR:Костарика
      CU:Куба
      CV:Зеленортска Острва
      CW:Курасао
      CX:Божићно Острво
      CY:Кипар
      CZ:Чешка
      DE:Немачка
      DG:Дијего Гарсија
      DJ:Џибути
      DK:Данска
      DM:Доминика
      DO:Доминиканска Република
      DZ:Алжир
      EA:Сеута и Мелиља
      EC:Еквадор
      EE:Естонија
      EG:Египат
      EH:Западна Сахара
      ER:Еритреја
      ES:Шпанија
      ET:Етиопија
      EU:Европска унија
      EZ:Еврозона
      FI:Финска
      FJ:Фиџи
      FK:Фокландска Острва
      FM:Микронезија
      FO:Фарска Острва
      FR:Француска
      GA:Габон
      GB:Уједињено Краљевство
      GD:Гренада
      GE:Грузија
      GF:Француска Гвајана
      GG:Гернзи
      GH:Гана
      GI:Гибралтар
      GL:Гренланд
      GM:Гамбија
      GN:Гвинеја
      GP:Гваделуп
      GQ:Екваторијална Гвинеја
      GR:Грчка
      GS:Јужна Џорџија и Јужна Сендвичка Острва
      GT:Гватемала
      GU:Гуам
      GW:Гвинеја-Бисао
      GY:Гвајана
      HK:САР Хонгконг (Кина)
      HM:Острво Херд и Мекдоналдова острва
      HN:Хондурас
      HR:Хрватска
      HT:Хаити
      HU:Мађарска
      IC:Канарска Острва
      ID:Индонезија
      IE:Ирска
      IL:Израел
      IM:Острво Ман
      IN:Индија
      IO:Британска територија Индијског океана
      IQ:Ирак
      IR:Иран
      IS:Исланд
      IT:Италија
      JE:Џерзи
      JM:Јамајка
      JO:Јордан
      JP:Јапан
      KE:Кенија
      KG:Киргистан
      KH:Камбоџа
      KI:Кирибати
      KM:Коморска Острва
      KN:Сент Китс и Невис
      KP:Северна Кореја
      KR:Јужна Кореја
      KW:Кувајт
      KY:Кајманска Острва
      KZ:Казахстан
      LA:Лаос
      LB:Либан
      LC:Света Луција
      LI:Лихтенштајн
      LK:Шри Ланка
      LR:Либерија
      LS:Лесото
      LT:Литванија
      LU:Луксембург
      LV:Летонија
      LY:Либија
      MA:Мароко
      MC:Монако
      MD:Молдавија
      ME:Црна Гора
      MF:Свети Мартин (Француска)
      MG:Мадагаскар
      MH:Маршалска Острва
      MK:Северна Македонија
      ML:Мали
      MM:Мијанмар (Бурма)
      MN:Монголија
      MO:САР Макао (Кина)
      MP:Северна Маријанска Острва
      MQ:Мартиник
      MR:Мауританија
      MS:Монсерат
      MT:Малта
      MU:Маурицијус
      MV:Малдиви
      MW:Малави
      MX:Мексико
      MY:Малезија
      MZ:Мозамбик
      NA:Намибија
      NC:Нова Каледонија
      NE:Нигер
      NF:Острво Норфок
      NG:Нигерија
      NI:Никарагва
      NL:Холандија
      NO:Норвешка
      NP:Непал
      NR:Науру
      NU:Ниуе
      NZ:Нови Зеланд
      OM:Оман
      PA:Панама
      PE:Перу
      PF:Француска Полинезија
      PG:Папуа Нова Гвинеја
      PH:Филипини
      PK:Пакистан
      PL:Пољска
      PM:Сен Пјер и Микелон
      PN:Питкерн
      PR:Порторико
      PS:Палестинске територије
      PT:Португалија
      PW:Палау
      PY:Парагвај
      QA:Катар
      QO:удаљена острва Океаније
      RE:Реинион
      RO:Румунија
      RS:Србија
      RU:Русија
      RW:Руанда
      SA:Саудијска Арабија
      SB:Соломонска Острва
      SC:Сејшели
      SD:Судан
      SE:Шведска
      SG:Сингапур
      SH:Света Јелена
      SI:Словенија
      SJ:Свалбард и Јан Мајен
      SK:Словачка
      SL:Сијера Леоне
      SM:Сан Марино
      SN:Сенегал
      SO:Сомалија
      SR:Суринам
      SS:Јужни Судан
      ST:Сао Томе и Принципе
      SV:Салвадор
      SX:Свети Мартин (Холандија)
      SY:Сирија
      SZ:Свазиленд
      TA:Тристан да Куња
      TC:Острва Туркс и Каикос
      TD:Чад
      TF:Француске Јужне Територије
      TG:Того
      TH:Тајланд
      TJ:Таџикистан
      TK:Токелау
      TL:Тимор-Лесте (Источни Тимор)
      TM:Туркменистан
      TN:Тунис
      TO:Тонга
      TR:Турска
      TT:Тринидад и Тобаго
      TV:Тувалу
      TW:Тајван
      TZ:Танзанија
      UA:Украјина
      UG:Уганда
      UM:Удаљена острва САД
      UN:Уједињене нације
      US:Сједињене Државе
      UY:Уругвај
      UZ:Узбекистан
      VA:Ватикан
      VC:Сент Винсент и Гренадини
      VE:Венецуела
      VG:Британска Девичанска Острва
      VI:Америчка Девичанска Острва
      VN:Вијетнам
      VU:Вануату
      WF:Валис и Футуна
      WS:Самоа
      XA:симулиране дијакритике
      XB:Псеудобиди
      XK:Косово
      YE:Јемен
      YT:Мајот
      ZA:Јужноафричка Република
      ZM:Замбија
      ZW:Зимбабве
      ZZ:непознат регион
      """.trimIndent() }

  val sr_Cyrl: String? = null

  val sr_Cyrl_BA: String by lazy { """
      001:свијет
      003:Сјеверноамерички континент
      015:Сјеверна Африка
      019:Сјеверна и Јужна Америка
      021:Сјеверна Америка
      154:Сјеверна Европа
      AC:острво Асенсион
      AX:Оландска острва
      BL:Сен Бартелеми
      BN:Брунеји
      BV:острво Буве
      BY:Бјелорусија
      CC:Кокосова (Килинг) острва
      CP:острво Клипертон
      CZ:Чешка Република
      DE:Њемачка
      FK:Фокландска острва
      FO:Фарска острва
      GS:Јужна Џорџија и Јужна Сендвичка острва
      GU:Гвам
      GW:Гвинеја Бисао
      HK:Хонгконг (САО Кине)
      HM:острво Херд и острва Макдоналд
      KM:Комори
      KP:Сјеверна Кореја
      MK:Сјеверна Македонија
      MM:Мјанмар (Бурма)
      MP:Сјеверна Маријанска острва
      NF:острво Норфок
      NU:Нијуе
      PS:палестинске територије
      RE:Реунион
      TF:Француске јужне територије
      UM:Спољна острва САД
      VC:Свети Винсент и Гренадини
      VG:Британска Дјевичанска острва
      VI:Америчка Дјевичанска острва
      """.trimIndent() }

  val sr_Cyrl_ME: String by lazy { """
      BY:Бјелорусија
      CG:Конго
      CZ:Чешка Република
      DE:Њемачка
      KN:Свети Китс и Невис
      PM:Свети Пјер и Микелон
      RE:Реунион
      UM:Мања удаљена острва САД
      VC:Свети Винсент и Гренадини
      VG:Британска Дјевичанска Острва
      VI:Америчка Дјевичанска Острва
      """.trimIndent() }

  val sr_Cyrl_XK: String by lazy { """
      CG:Конго
      CV:Кабо Верде
      CZ:Чешка Република
      HK:САР Хонгконг
      KN:Свети Китс и Невис
      MO:САР Макао
      PM:Свети Пјер и Микелон
      RE:Реунион
      UM:Мања удаљена острва САД
      VC:Свети Винсент и Гренадини
      """.trimIndent() }

  val sr_Latn: String by lazy { """
      001:svet
      002:Afrika
      003:Severnoamerički kontinent
      005:Južna Amerika
      009:Okeanija
      011:Zapadna Afrika
      013:Centralna Amerika
      014:Istočna Afrika
      015:Severna Afrika
      017:Centralna Afrika
      018:Južna Afrika
      019:Severna i Južna Amerika
      021:Severna Amerika
      029:Karibi
      030:Istočna Azija
      034:Južna Azija
      035:Jugoistočna Azija
      039:Južna Evropa
      053:Australija i Novi Zeland
      054:Melanezija
      057:Mikronezijski region
      061:Polinezija
      142:Azija
      143:Centralna Azija
      145:Zapadna Azija
      150:Evropa
      151:Istočna Evropa
      154:Severna Evropa
      155:Zapadna Evropa
      202:Podsaharska Afrika
      419:Latinska Amerika
      AC:Ostrvo Asension
      AD:Andora
      AE:Ujedinjeni Arapski Emirati
      AF:Avganistan
      AG:Antigva i Barbuda
      AI:Angvila
      AL:Albanija
      AM:Jermenija
      AO:Angola
      AQ:Antarktik
      AR:Argentina
      AS:Američka Samoa
      AT:Austrija
      AU:Australija
      AW:Aruba
      AX:Olandska Ostrva
      AZ:Azerbejdžan
      BA:Bosna i Hercegovina
      BB:Barbados
      BD:Bangladeš
      BE:Belgija
      BF:Burkina Faso
      BG:Bugarska
      BH:Bahrein
      BI:Burundi
      BJ:Benin
      BL:Sveti Bartolomej
      BM:Bermudi
      BN:Brunej
      BO:Bolivija
      BQ:Karipska Holandija
      BR:Brazil
      BS:Bahami
      BT:Butan
      BV:Ostrvo Buve
      BW:Bocvana
      BY:Belorusija
      BZ:Belize
      CA:Kanada
      CC:Kokosova (Kilingova) Ostrva
      CD:Kongo - Kinšasa
      CF:Centralnoafrička Republika
      CG:Kongo - Brazavil
      CH:Švajcarska
      CI:Obala Slonovače (Kot d’Ivoar)
      CK:Kukova Ostrva
      CL:Čile
      CM:Kamerun
      CN:Kina
      CO:Kolumbija
      CP:Ostrvo Kliperton
      CR:Kostarika
      CU:Kuba
      CV:Zelenortska Ostrva
      CW:Kurasao
      CX:Božićno Ostrvo
      CY:Kipar
      CZ:Češka
      DE:Nemačka
      DG:Dijego Garsija
      DJ:Džibuti
      DK:Danska
      DM:Dominika
      DO:Dominikanska Republika
      DZ:Alžir
      EA:Seuta i Melilja
      EC:Ekvador
      EE:Estonija
      EG:Egipat
      EH:Zapadna Sahara
      ER:Eritreja
      ES:Španija
      ET:Etiopija
      EU:Evropska unija
      EZ:Evrozona
      FI:Finska
      FJ:Fidži
      FK:Foklandska Ostrva
      FM:Mikronezija
      FO:Farska Ostrva
      FR:Francuska
      GA:Gabon
      GB:Ujedinjeno Kraljevstvo
      GD:Grenada
      GE:Gruzija
      GF:Francuska Gvajana
      GG:Gernzi
      GH:Gana
      GI:Gibraltar
      GL:Grenland
      GM:Gambija
      GN:Gvineja
      GP:Gvadelup
      GQ:Ekvatorijalna Gvineja
      GR:Grčka
      GS:Južna Džordžija i Južna Sendvička Ostrva
      GT:Gvatemala
      GU:Guam
      GW:Gvineja-Bisao
      GY:Gvajana
      HK:SAR Hongkong (Kina)
      HM:Ostrvo Herd i Mekdonaldova ostrva
      HN:Honduras
      HR:Hrvatska
      HT:Haiti
      HU:Mađarska
      IC:Kanarska Ostrva
      ID:Indonezija
      IE:Irska
      IL:Izrael
      IM:Ostrvo Man
      IN:Indija
      IO:Britanska teritorija Indijskog okeana
      IQ:Irak
      IR:Iran
      IS:Island
      IT:Italija
      JE:Džerzi
      JM:Jamajka
      JO:Jordan
      JP:Japan
      KE:Kenija
      KG:Kirgistan
      KH:Kambodža
      KI:Kiribati
      KM:Komorska Ostrva
      KN:Sent Kits i Nevis
      KP:Severna Koreja
      KR:Južna Koreja
      KW:Kuvajt
      KY:Kajmanska Ostrva
      KZ:Kazahstan
      LA:Laos
      LB:Liban
      LC:Sveta Lucija
      LI:Lihtenštajn
      LK:Šri Lanka
      LR:Liberija
      LS:Lesoto
      LT:Litvanija
      LU:Luksemburg
      LV:Letonija
      LY:Libija
      MA:Maroko
      MC:Monako
      MD:Moldavija
      ME:Crna Gora
      MF:Sveti Martin (Francuska)
      MG:Madagaskar
      MH:Maršalska Ostrva
      MK:Severna Makedonija
      ML:Mali
      MM:Mijanmar (Burma)
      MN:Mongolija
      MO:SAR Makao (Kina)
      MP:Severna Marijanska Ostrva
      MQ:Martinik
      MR:Mauritanija
      MS:Monserat
      MT:Malta
      MU:Mauricijus
      MV:Maldivi
      MW:Malavi
      MX:Meksiko
      MY:Malezija
      MZ:Mozambik
      NA:Namibija
      NC:Nova Kaledonija
      NE:Niger
      NF:Ostrvo Norfok
      NG:Nigerija
      NI:Nikaragva
      NL:Holandija
      NO:Norveška
      NP:Nepal
      NR:Nauru
      NU:Niue
      NZ:Novi Zeland
      OM:Oman
      PA:Panama
      PE:Peru
      PF:Francuska Polinezija
      PG:Papua Nova Gvineja
      PH:Filipini
      PK:Pakistan
      PL:Poljska
      PM:Sen Pjer i Mikelon
      PN:Pitkern
      PR:Portoriko
      PS:Palestinske teritorije
      PT:Portugalija
      PW:Palau
      PY:Paragvaj
      QA:Katar
      QO:udaljena ostrva Okeanije
      RE:Reinion
      RO:Rumunija
      RS:Srbija
      RU:Rusija
      RW:Ruanda
      SA:Saudijska Arabija
      SB:Solomonska Ostrva
      SC:Sejšeli
      SD:Sudan
      SE:Švedska
      SG:Singapur
      SH:Sveta Jelena
      SI:Slovenija
      SJ:Svalbard i Jan Majen
      SK:Slovačka
      SL:Sijera Leone
      SM:San Marino
      SN:Senegal
      SO:Somalija
      SR:Surinam
      SS:Južni Sudan
      ST:Sao Tome i Principe
      SV:Salvador
      SX:Sveti Martin (Holandija)
      SY:Sirija
      SZ:Svazilend
      TA:Tristan da Kunja
      TC:Ostrva Turks i Kaikos
      TD:Čad
      TF:Francuske Južne Teritorije
      TG:Togo
      TH:Tajland
      TJ:Tadžikistan
      TK:Tokelau
      TL:Timor-Leste (Istočni Timor)
      TM:Turkmenistan
      TN:Tunis
      TO:Tonga
      TR:Turska
      TT:Trinidad i Tobago
      TV:Tuvalu
      TW:Tajvan
      TZ:Tanzanija
      UA:Ukrajina
      UG:Uganda
      UM:Udaljena ostrva SAD
      UN:Ujedinjene nacije
      US:Sjedinjene Države
      UY:Urugvaj
      UZ:Uzbekistan
      VA:Vatikan
      VC:Sent Vinsent i Grenadini
      VE:Venecuela
      VG:Britanska Devičanska Ostrva
      VI:Američka Devičanska Ostrva
      VN:Vijetnam
      VU:Vanuatu
      WF:Valis i Futuna
      WS:Samoa
      XA:simulirane dijakritike
      XB:Pseudobidi
      XK:Kosovo
      YE:Jemen
      YT:Majot
      ZA:Južnoafrička Republika
      ZM:Zambija
      ZW:Zimbabve
      ZZ:nepoznat region
      """.trimIndent() }

  val sr_Latn_BA: String by lazy { """
      001:svijet
      003:Sjevernoamerički kontinent
      015:Sjeverna Afrika
      019:Sjeverna i Južna Amerika
      021:Sjeverna Amerika
      154:Sjeverna Evropa
      AC:ostrvo Asension
      AX:Olandska ostrva
      BL:Sen Bartelemi
      BN:Bruneji
      BV:ostrvo Buve
      BY:Bjelorusija
      CC:Kokosova (Kiling) ostrva
      CP:ostrvo Kliperton
      CZ:Češka Republika
      DE:Njemačka
      FK:Foklandska ostrva
      FO:Farska ostrva
      GS:Južna Džordžija i Južna Sendvička ostrva
      GU:Gvam
      GW:Gvineja Bisao
      HK:Hongkong (SAO Kine)
      HM:ostrvo Herd i ostrva Makdonald
      KM:Komori
      KP:Sjeverna Koreja
      MK:Sjeverna Makedonija
      MM:Mjanmar (Burma)
      MP:Sjeverna Marijanska ostrva
      NF:ostrvo Norfok
      NU:Nijue
      PS:palestinske teritorije
      RE:Reunion
      TF:Francuske južne teritorije
      UM:Spoljna ostrva SAD
      VC:Sveti Vinsent i Grenadini
      VG:Britanska Djevičanska ostrva
      VI:Američka Djevičanska ostrva
      """.trimIndent() }

  val sr_Latn_ME: String by lazy { """
      BY:Bjelorusija
      CG:Kongo
      CZ:Češka Republika
      DE:Njemačka
      KN:Sveti Kits i Nevis
      PM:Sveti Pjer i Mikelon
      RE:Reunion
      UM:Manja udaljena ostrva SAD
      VC:Sveti Vinsent i Grenadini
      VG:Britanska Djevičanska Ostrva
      VI:Američka Djevičanska Ostrva
 