package net.codinux.i18n.unit

import kotlin.Pair
import kotlin.String

object AvailableUnitDisplayNames {
  private val aa_Units: String? = null

  private val aa_Prefixes: String? = null

  private val aa_DJ_Units: String? = null

  private val aa_DJ_Prefixes: String? = null

  private val aa_ER_Units: String? = null

  private val aa_ER_Prefixes: String? = null

  private val ab_Units: String? = null

  private val ab_Prefixes: String? = null

  private val af_Units: String by lazy {
    """g-force,swaartekrag,,{0}G,{0}G,swaartekrag,,,{0} G,swaartekrag,,{0} swaartekrag,{0} swaartekrag
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,,,,,meter per vierkante sekonde,,{0} meter per vierkante sekonde,{0} meter per vierkante sekonde
        arc-minute,boogmin.,,{0}′,{0}′,boogminute,,{0} boogmin.,{0} boogmin.,boogminute,,{0} boogminuut,{0} boogminute
        arc-second,boogsek.,,{0}″,{0}″,boogsekondes,,{0} boogsek.,{0} boogsek.,boogsekondes,,{0} boogsekonde,{0} boogsekondes
        degree,gr.,,{0}°,{0}°,grade,,{0} gr.,{0} gr.,grade,,{0} graad,{0} grade
        radian,rad.,,{0}rad.,{0}rad.,radiale,,{0} rad.,{0} rad.,radiale,,{0} radiaal,{0} radiale
        revolution,omw.,,{0}omw.,{0}omw.,omw.,,{0} omw.,{0} omw.,omwenteling,,{0} omwenteling,{0} omwentelings
        acre,acre,,{0}ac,{0}ac,acre,,{0} acre,{0} acre,acre,,{0} acre,{0} acre
        dunam,donum,,{0}donum,{0}donum,donum,,{0} donum,{0} donum,donum,,{0} donum,{0} donum
        hectare,hektaar,,{0}ha,{0}ha,hektaar,,,{0} ha,hektaar,,{0} hektaar,{0} hektaar
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,,,,,vierkante sentimeter,{0} per vierkante sentimeter,{0} vierkante sentimeter,{0} vierkante sentimeter
        square-foot,vt.²,,{0}vt.²,{0}vt.²,vt.²,,{0} vt.²,{0} vt.²,vierkante voet,,{0} vierkante voet,{0} vierkante voet
        square-inch,duim²,{0}/dm.²,{0}dm.²,{0}dm.²,duim²,{0}/dm.²,{0} dm.²,{0} dm.²,vierkante duim,{0} per vierkante duim,{0} vierkante duim,{0} vierkante duim
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,vierkante kilometer,{0} per vierkante kilometer,{0} vierkante kilometer,{0} vierkante kilometer
        square-meter,meters²,{0}/m²,{0}m²,{0}m²,,,,,vierkante meter,{0} per vierkante meter,{0} vierkante meter,{0} vierkante meter
        square-mile,myl²,{0}/myl²,{0}myl²,{0}myl²,myl²,{0}/myl²,{0} myl²,{0} myl²,vierkante myl,{0} per vierkante myl,{0} vierkante myl,{0} vierkante myl
        square-yard,jaart²,,{0}jt.²,{0}jt.²,jaart²,,{0} jt.²,{0} jt.²,vierkante jaart,,{0} vierkante jaart,{0} vierkante jaart
        item,item,,{0}item,{0}item,,,,,items,,{0} item,{0} items
        karat,karaat,,{0}kar.,{0}kar.,karaat,,{0} kar.,{0} kar.,karaat,,{0} karaat,{0} karaat
        milligram-ofglucose-per-deciliter,mg/dl,,{0}mg/dl,{0}mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligram per desiliter,,{0} milligram per desiliter,{0} milligram per desiliter
        millimole-per-liter,mmol/l,,{0}mmol/l,{0}mmol/l,millimol/liter,,{0} mmol/l,{0} mmol/l,millimol per liter,,{0} millimol per liter,{0} millimol per liter
        percent,,,,,percent,,,{0}%,persent,,{0} persent,{0} persent
        permille,,,,,per duisend,,,{0}‰,per duisend,,{0} per duisend,{0} per duisend
        permillion,d.p.m.,,{0}d.p.m.,{0} d.p.m.,dele/miljoen,,{0} d.p.m.,{0} d.p.m.,dele per miljoen,,{0} deel per miljoen,{0} dele per miljoen
        permyriad,,,,,per tienduisend,,,{0}‱,per tienduisend,,{0} per tienduisend,{0} per tienduisend
        portion-per-1e9,deeltjies/miljard,,{0}deeltjie/miljard,{0}deeltjies/miljard,deeltjies/miljard,,{0} deeltjie/miljard,{0} deeltjies/miljard,deeltjies per miljard,,{0} deeltjie per miljard,{0} deeltjies per miljard
        liter-per-100-kilometer,l/100 km,,{0}l/100 km,{0}l/100 km,l/100 km,,{0} l/100 km,{0} l/100 km,liter per 100 kilometer,,{0} liter per 100 kilometer,{0} liter per 100 kilometer
        liter-per-kilometer,l/km,,{0}l/km,{0}l/km,liter/km,,{0} l/km,{0} l/km,liter per kilometer,,{0} liter per kilometer,{0} liter per kilometer
        mile-per-gallon,m.p.VSA-g.,,{0}m.p.g.,{0}m.p.g.,myl/VSA-gell.,,{0} m.p.VSA-g.,{0} m.p.VSA-g.,myl per VSA-gelling,,{0} myl per VSA-gelling,{0} myl per VSA-gelling
        mile-per-gallon-imperial,m/Br.gell.,,{0}m/Br.g.,{0}m/Br.g.,myl/Br. gelling,,{0} myl/Br.g.,{0} myl/Br.g.,myl per Britse gelling,,{0} myl per Britse gelling,{0} myl per Britse gelling
        bit,bis,,{0}bis,{0}bis,bis,,{0} bis,{0} bis,bis,,{0} bis,{0} bis
        byte,greep,,{0}greep,{0}greep,greep,,{0} greep,{0} greep,greep,,{0} greep,{0} greep
        gigabit,Gb,,{0}Gb,{0}Gb,,,,,gigabis,,{0} gigabis,{0} gigabis
        gigabyte,GB,,{0}GB,{0}GB,,,,,gigagreep,,{0} gigagreep,{0} gigagreep
        kilobit,kb,,{0}kb,{0}kb,,,,,kilobis,,{0} kilobis,{0} kilobis
        kilobyte,kB,,{0}kB,{0}kB,,,,,kilogreep,,{0} kilogreep,{0} kilogreep
        megabit,Mb,,{0}Mb,{0}Mb,,,,,megabis,,{0} megabis,{0} megabis
        megabyte,MB,,{0}MB,{0}MB,,,,,megagreep,,{0} megagreep,{0} megagreep
        petabyte,PB,,{0}PB,{0}PB,,,,,petagreep,,{0} petagreep,{0} petagreep
        terabit,Tb,,{0}Tb,{0}Tb,,,,,terabis,,{0} terabis,{0} terabis
        terabyte,TB,,{0}TB,{0}TB,,,,,teragreep,,{0} teragreep,{0} teragreep
        century,e.,,{0}e.,{0}e.,e.,,{0} e.,{0} e.,eeue,,{0} eeu,{0} eeue
        day,dag,{0}/d.,{0} d.,{0} d.,dae,{0}/d.,{0} dag,{0} dae,dae,{0} per dag,{0} dag,{0} dae
        decade,dek.,,{0}dek.,{0}dek.,dek.,,{0} dek.,{0} dek.,dekades,,{0} dekade,{0} dekades
        hour,uur,{0}/h,{0} u.,{0} u.,uur,{0}/h,{0} u.,{0} u.,uur,{0} per uur,{0} uur,{0} uur
        microsecond,μs.,,{0}μs.,{0}μs.,μs.,,{0} μs.,{0} μs.,mikrosekondes,,{0} mikrosekonde,{0} mikrosekondes
        millisecond,ms.,,{0} ms.,{0} ms.,millisek.,,{0} ms.,{0} ms,millisekondes,,{0} millisekonde,{0} millisekondes
        minute,min.,{0}/min.,{0} min.,{0} min.,min.,{0}/min.,{0} min.,{0} min.,minute,{0} per minuut,{0} minuut,{0} minute
        month,maand,{0}/md.,{0} md.,{0} md.,maande,{0}/md.,{0} md.,{0} md.,maande,{0}/maand,{0} maand,{0} maande
        nanosecond,ns.,,{0}ns.,{0}ns.,ns.,,{0} ns.,{0} ns.,nanosekondes,,{0} nanosekonde,{0} nanosekondes
        night,nagte,{0}/nag,{0} nag,{0} nagte,nagte,{0}/nag,{0} nag,{0} nagte,nagte,{0} per nag,{0} nag,{0} nagte
        quarter,kw.,{0}/kw.,{0} kw.,{0} kwe.,kw.,{0}/kw.,{0} kw.,{0} kwe.,kwartale,{0}/kwartaal,{0} kwartaal,{0} kwartale
        second,s.,{0}/s.,{0} s.,{0} s.,s.,{0}/s.,{0} s.,{0} s.,sekondes,{0} per sekonde,{0} sekonde,{0} sekondes
        week,w.,{0}/w.,{0} w.,{0} w.,weke,{0}/w.,{0} w.,{0} w.,weke,{0} per week,{0} week,{0} weke
        year,j.,{0}/j.,{0} j.,{0} j.,jaar,{0}/j.,{0} j.,{0} j.,jaar,{0} per jaar,{0} jaar,{0} jaar
        ampere,A,,{0}A,{0}A,A,,,{0} A,ampère,,{0} ampère,{0} ampère
        milliampere,mA,,{0}mA,{0}mA,,,,,milliampère,,{0} milliampère,{0} milliampère
        ohm,ohm,,{0}Ω,{0}Ω,,,,,ohm,,{0} ohm,{0} ohm
        volt,volt,,{0}V,{0}V,,,,,volt,,{0} volt,{0} volt
        british-thermal-unit,BTE,,{0}BTE,{0}BTE,BTE,,{0} BTE,{0} BTE,Britse termiese eenhede,,{0} Britse termiese eenheid,{0} Britse termiese eenhede
        calorie,kal.,,{0}kal.,{0}kal.,kal.,,{0} kal.,{0} kal.,kalorieë,,{0} kalorie,{0} kalorieë
        electronvolt,eV,,{0}eV,{0}eV,elektronvolt,,,{0} eV,elektronvolt,,{0} elektronvolt,{0} elektronvolt
        foodcalorie,kal.,,{0}kal.,{0}kal.,kal.,,{0} kal.,{0} kal.,Kalorieë,,{0} kalorie,{0} kalorieë
        joule,joule,,{0}J,{0}J,,,,,joule,,{0} joule,{0} joule
        kilocalorie,kkal.,,{0}kkal.,{0}kkal.,kkal.,,{0} kkal.,{0} kkal.,kilokalorieë,,{0} kilokalorie,{0} kilokalorieë
        kilojoule,kJ,,{0}kJ,{0}kJ,,,,,kilojoule,,{0} kilojoule,{0} kilojoule
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,,,,,kilowatt-uur,,{0} kilowatt-uur,{0} kilowatt-uur
        therm-us,VSA- termiese eenheid,,{0}VSA-term.,{0}VSA-term.,VSA- termiese eenheid,,{0} VSA-term.,{0} VSA-term.,VSA- termiese eenhede,,{0} VSA- termiese eenheid,{0} VSA- termiese eenhede
        newton,N,,{0}N,{0}N,newton,,,{0} N,newton,,{0} newton,{0} newton
        pound-force,lb.-krag,,{0}lb.-krag,{0}lb.-krag,pondkrag,,{0} lb.-krag,{0} lb.-krag,pondkrag,,{0} pondkrag,{0} pondkrag
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,Hz,,{0}Hz,{0}Hz,,,,,hertz,,{0} hertz,{0} hertz
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,megahertz,,{0} megahertz,{0} megahertz
        dot,stippel,,{0}stippel,{0}stippel,stippels,,,,stippels,,{0} stippel,{0} stippels
        dot-per-centimeter,dpcm,,{0}dpcm,{0}dpcm,dpcm,,{0} dpcm,{0} dpcm,stippels per sentimeter,,{0} stippel per sentimeter,{0} stippels per sentimeter
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,stippels per duim,,{0} stippel per duim,{0} stippels per duim
        em,em,,{0}em,{0}em,,,,,tipografiese em,,,{0} em
        megapixel,megapieksels,,{0} MP,{0} MP,megapieksels,,{0} MP,{0} MP,megapieksels,,{0} megapieksel,{0} megapieksels
        pixel,px,,{0}px,{0}px,pieksels,,,{0} px,pieksels,,{0} pieksel,{0} pieksels
        pixel-per-centimeter,ppcm,,{0}ppcm,{0}ppcm,,,,,pieksels per sentimeter,,{0} pieksel per sentimeter,{0} pieksels per sentimeter
        pixel-per-inch,ppi,,{0}ppi,{0}ppi,,,,,pieksels per duim,,{0} pieksel per duim,{0} pieksels per duim
        astronomical-unit,AE,,{0}AE,{0}AE,AE,,{0} AE,{0} AE,astronomiese eenhede,,{0} astronomiese eenheid,{0} astronomiese eenhede
        centimeter,,,,,,,,,sentimeter,{0} per sentimeter,{0} sentimeter,{0} sentimeter
        decimeter,dm,,{0}dm,{0}dm,,,,,desimeter,,{0} desimeter,{0} desimeter
        earth-radius,R⊕,,{0}R⊕,{0}R⊕,,,,,aardstraal,,{0} aardstraal,{0} aardstraal
        fathom,vaam,,{0}vaam,{0}vaam,vaam,,{0} vaam,{0} vaam,vaam,,{0} vaam,{0} vaam
        foot,vt.,{0}/vt.,{0}vt.,{0}vt.,voet,{0}/vt.,{0} vt.,{0} vt.,voet,{0} per voet,{0} voet,{0} voet
        furlong,furlongs,,{0}fur,{0}fur,furlongs,,{0} fur.,{0} fur.,furlongs,,{0} furlong,{0} furlongs
        inch,duim,{0}/duim,{0}″,{0}″,duim,{0}/duim,{0} duim,{0} duim,duim,{0} per duim,{0} duim,{0} duim
        kilometer,,,,,,,,,kilometer,{0} per kilometer,{0} kilometer,{0} kilometer
        light-year,lj,,{0} lj,{0} lj,ligjare,,{0} lj.,{0} lj.,ligjare,,{0} ligjaar,{0} ligjare
        meter,m,{0}/m,,{0} m,,,,,meter,{0} per meter,{0} meter,{0} meter
        micrometer,μm,,{0}μm,{0}μm,,,,,mikrometer,,{0} mikrometer,{0} mikrometer
        mile,myl,,{0}myl,{0}myl,myl,,{0} myl,{0} myl,myl,,{0} myl,{0} myl
        mile-scandinavian,smi,,{0}smi,{0}smi,,,,,Skandinawiese myl,,{0} Skandinawiese myl,{0} Skandinawiese myl
        millimeter,,,,,,,,,millimeter,,{0} millimeter,{0} millimeter
        nanometer,nm,,{0}nm,{0}nm,,,,,nanometer,,{0} nanometer,{0} nanometer
        nautical-mile,sm.,,{0}sm.,{0}sm.,sm.,,{0} sm.,{0} sm.,seemyl,,{0} seemyl,{0} seemyl
        parsec,parsek,,{0}pc,{0}pc,parsek,,,{0} pc,parsek,,{0} parsek,{0} parsek
        picometer,pm,,{0}pm,{0}pm,,,,,pikometer,,{0} pikometer,{0} pikometer
        point,pte.,,{0}pt.,{0}pt.,punte,,{0} pt.,{0} pt.,punte,,{0} punt,{0} punte
        solar-radius,R☉,,{0}R☉,{0}R☉,sonradiusse,,,{0} R☉,sonradiusse,,{0} sonradius,{0} sonradiusse
        yard,jaart,,{0}jt.,{0}jt.,jaart,,{0} jt.,{0} jt.,jaart,,{0} jaart,{0} jaart
        candela,,,,,,,,,kandela,,{0} kandela,{0} kandela
        lumen,lm,,{0}lm,{0}lm,,,,,lumen,,{0} lumen,{0} lumen
        lux,lux,,{0}lx,{0}lx,lux,,,{0} lx,lux,,{0} lux,{0} lux
        solar-luminosity,L☉,,{0}L☉,{0}L☉,sonligsterkte,,,{0} L☉,sonligsterkte,,{0} sonligsterkte,{0} sonligsterkte
        carat,karaat,,{0}kar.,{0}kar.,karaat,,{0} kar.,{0} kar.,karaat,,{0} karaat,{0} karaat
        dalton,Da,,{0}Da,{0}Da,dalton,,,{0} Da,dalton,,{0} dalton,{0} dalton
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,aardemassas,,,{0} M⊕,aardemassas,,{0} aardemassa,{0} aardemassas
        grain,korrelgewig,,{0}korrelg.,{0}korrelg.,korrelgewig,,{0} korrelgewig,{0} korrelgewig,korrelgewig,,{0} korrelgewig,{0} korrelgewig
        gram,gram,{0}/g,{0}g,{0}g,,,,,gram,{0} per gram,{0} gram,{0} gram
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,kilogram,{0} per kilogram,{0} kilogram,{0} kilogram
        microgram,μg,,{0}μg,{0}μg,,,,,mikrogram,,{0} mikrogram,{0} mikrogram
        milligram,mg,,{0}ng,{0}mg,,,,,milligram,,{0} milligram,{0} milligram
        ounce,ons.,{0}/ons.,{0}ons.,{0}ons.,ons.,{0}/ons.,{0} ons.,{0} ons.,onse,{0} per ons,{0} ons,{0} onse
        ounce-troy,ons.t.,,{0}ons.t.,{0}ons.t.,troy-ons,,{0} ons.t.,{0} ons.t.,troy-onse,,{0} troy-ons,{0} troy-onse
        pound,lb,{0}/lb.,{0}#,{0}#,pond,{0}/lb.,{0} lb.,{0} lb.,pond,{0} per pond,{0} pond,{0} pond
        solar-mass,M☉,,{0}M☉,{0}M☉,sonmassas,,,{0} M☉,sonmassas,,{0} sonmassa,{0} sonmassas
        stone,stone,,{0}st,{0}st,stone,,,{0} st,stone,,{0} stone,{0} stone
        ton,VSA-ton,,{0}VSA-t.,{0}VSA-t.,VSA-ton,,{0} VSA-t.,{0} VSA-t.,VSA-ton,,{0} VSA-ton,{0} VSA-ton
        tonne,t,,{0}t,{0}t,,,,,metrieke ton,,{0} metrieke ton,{0} metrieke ton
        gigawatt,GW,,{0}GW,{0}GW,,,,,gigawatt,,{0} gigawatt,{0} gigawatt
        horsepower,pk.,,{0}pk.,{0}pk.,pk.,,{0} pk.,{0} pk.,perdekrag,,{0} perdekrag,{0} perdekrag
        kilowatt,kW,,{0}kW,{0}kW,,,,,kilowatt,,{0} kilowatt,{0} kilowatt
        megawatt,MW,,{0}MW,{0}MW,,,,,megawatt,,{0} megawatt,{0} megawatt
        milliwatt,mW,,{0}mW,{0}mW,,,,,milliwatt,,{0} milliwatt,{0} milliwatt
        watt,watt,,{0}W,{0}W,,,,,watt,,{0} watt,{0} watt
        atmosphere,atm.,,{0}atm.,{0}atm.,atm.,,{0} atm.,{0} atm.,atmosfere,,{0} atmosfeer,{0} atmosfere
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,hektopascal,,{0} hektopascal,{0} hektopascal
        inch-ofhg,″ Hg,,{0}″ Hg,{0}″ Hg,duim Hg,,{0} duim Hg,{0} duim Hg,duim kwik,,{0} duim kwik,{0} duim kwik
        kilopascal,kPa,,{0}kPa,{0}kPa,,,,,kilopascal,,{0} kilopascal,{0} kilopascal
        megapascal,MPa,,{0}MPa,{0}MPa,,,,,megapascal,,{0} megapascal,{0} megapascal
        millibar,mbar,,{0}mb,{0}mb,,,,,millibar,,{0} millibar,{0} millibar
        millimeter-ofhg,mmHg,,{0}mmHg,{0}mmHg,mmHg,,{0} mmHg,{0} mmHg,millimeter kwik,,{0} millimeter kwik,{0} millimeter kwik
        pascal,Pa,,{0}Pa,{0}Pa,,,,,pascals,,{0} pascal,{0} pascals
        pound-force-per-square-inch,lb./vk. duim,,{0}lb./vk.dm,{0}lb./vk.dm,lb./vk. duim,,{0} lb./vk.dm,{0} lb./vk.dm,pond per vierkante duim,,{0} pond per vierkante duim,{0} pond per vierkante duim
        beaufort,,,,,,,,,Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,,,,,km/uur,,,{0} km/h,kilometer per uur,,{0} kilometer per uur,{0} kilometer per uur
        knot,kn.,,{0}kn.,{0}kn.,kn.,,{0} kn.,{0} kn.,knoop,,{0} knoop,{0} knope
        light-speed,lig,,{0} lig,{0} lig,lig,,{0} lig,{0} lig,lig,,{0} lig,{0} lig
        meter-per-second,m/s.,,{0}m/s.,{0}m/s.,meter/s.,,{0} m/s.,{0} m/s.,meter per sekonde,,{0} meter per sekonde,{0} meter per sekonde
        mile-per-hour,myl/h,,{0}mph,{0}mph,myl per uur,,{0} myl/h,{0} myl/h,myl per uur,,{0} myl per uur,{0} myl per uur
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,grade Celsius,,{0} graad Celsius,{0} grade Celsius
        fahrenheit,°F,,{0}°,{0}°,°F,,{0} °F,{0} °F,grade Fahrenheit,,{0} graad Fahrenheit,{0} grade Fahrenheit
        generic,,,,,,,,,°,,{0} graad,{0} graad
        kelvin,K,,{0}K,{0}K,,,,,kelvin,,{0} kelvin,{0} kelvin
        newton-meter,Nm,,{0}Nm,{0}Nm,Nm,,{0} Nm,{0} Nm,newtonmeter,,{0} newtonmeter,{0} newtonmeter
        pound-force-foot,lb.vt.-krag,,{0}lb.vt.-kr,{0}lb.vt.-kr,lb.vt.-krag,,{0} lb.vt.-krag,{0} lb.vt.-krag,pondvoet,,{0} pondvoetkrag,{0} pondvoet
        acre-foot,acre-voet,,{0}ac.-vt.,{0}ac.-vt.,acre-voet,,{0} acre-vt.,{0} acre-vt.,acre-voet,,{0} acre-voet,{0} acre-voet
        barrel,vat,,{0}vat,{0}vate,vat,,{0} vat,{0} vate,vate,,{0} vat,{0} vate
        bushel,skepel,,{0}sk.,{0}sk.,skepel,,{0} skepel,{0} skepel,skepel,,{0} skepel,{0} skepel
        centiliter,cl,,{0}cl,{0}cl,cl,,{0} cl,{0} cl,sentiliter,,{0} sentiliter,{0} sentiliter
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,kubieke sentimeters,{0} per kubieke sentimeter,{0} kubieke sentimeter,{0} kubieke sentimeters
        cubic-foot,vt³,,{0}vt³,{0}vt³,voet³,,{0} vt³,{0} vt³,kubieke voet,,{0} kubieke voet,{0} kubieke voet
        cubic-inch,dm³,,{0}dm³,{0}dm³,duime³,,{0} dm³,{0} dm³,kubieke duime,,{0} kubieke duim,{0} kubieke duim
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,kubieke kilometers,,{0} kubieke kilometer,{0} kubieke kilometers
        cubic-meter,,,,,,,,,kubieke meters,{0} per kubieke meter,{0} kubieke meter,{0} kubieke meters
        cubic-mile,myl³,,{0}myl³,{0}myl³,myl³,,{0} myl³,{0} myl³,kubieke myle,,{0} kubieke myl,{0} kubieke myle
        cubic-yard,jaart³,,{0}jt.³,{0}jt.³,jaart³,,{0} jt.³,{0} jt.³,kubieke jaart,,{0} kubieke jaart,{0} kubieke jaart
        cup,koppie,,{0}kp,{0}kp.,koppie,,{0} kp.,{0} kp.,koppies,,{0} koppie,{0} koppies
        cup-metric,m. kop,,{0}m.kop,{0}m.kop,m. kop,,{0} m. kop,{0} m. kop,metrieke koppies,,{0} metrieke koppie,{0} metrieke koppies
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,desiliter,,{0} desiliter,{0} desiliter
        dessert-spoon,dstlpl.,,{0}dstlpl.,{0}dstlpl.,dstlpl.,,{0} dstlpl.,{0} dstlpl.,dessertlepel,,{0} dessertlepel,{0} dessertlepel
        dessert-spoon-imperial,dstlpl. Eng.,,{0}dlpl.Eng,{0}dlpl.Eng,dstlpl. Eng.,,{0} dstlpl. Eng.,{0} dstlpl. Eng.,Engelse dessertlepel,,{0} Engelse dessertlepel,{0} Engelse dessertlepel
        dram,dragme vloeistof,,{0}dr.vl.,{0}dr.vl.,dragme vloeistof,,{0} dr. vl.,{0} dr. vl.,dragme,,{0} dragme,{0} dragme
        drop,druppel,,{0}dr,{0}dr,druppel,,{0} druppel,{0} druppels,druppel,,{0} druppel,{0} druppels
        fluid-ounce,vl.oz.,,{0}vl.oz.,{0}vl.oz.,vl.oz.,,{0} vl.oz.,{0} vl.oz.,vloeistofons,,{0} vloeistofons,{0} vloeistofons
        fluid-ounce-imperial,Imp vl.oz.,,{0}Im.vl.oz.,{0}Im.vl.oz.,Imp. vl.oz.,,{0} Imp. vl.oz.,{0} Imp. vl.oz.,Imp. vloeistofonse,,{0} Imp. vloeistofons,{0} Imp. vloeistofonse
        gallon,gell.,{0}/gell.,{0}gell.,{0}gell.,gell.,{0}/gell.,{0} gell.,{0} gell.,gelling,{0} per gelling,{0} gelling,{0} gelling
        gallon-imperial,Br. gell.,{0}/Br.gell.,{0}Br.gell.,{0}Br.gell.,Br. gell.,{0}/Br. gell.,{0} Br. gell.,{0} Br. gell.,Britse gelling,{0}/Br. gell.,{0} Britse gelling,{0} Britse gelling
        hectoliter,hl,,{0}hl,{0}hl,hl,,{0} hl,{0} hl,hektoliters,,{0} hektoliter,{0} hektoliters
        jigger,sopie,,{0}sopie,{0}sopies,sopie,,{0} sopie,{0} sopies,sopie,,{0} sopie,{0} sopies
        liter,liter,{0}/l,{0}l,{0}l,liters,{0}/l,,{0} l,liters,{0} per liter,{0} liter,{0} liters
        megaliter,ML,,{0}ML,{0}ML,,,,,megaliters,,{0} megaliter,{0} megaliters
        milliliter,ml,,{0}ml,{0}ml,ml,,{0} ml,{0} ml,milliliter,,{0} milliliter,{0} milliliter
        pinch,kn.,,{0}kn.,{0}kn.,knypie,,{0} knypie,{0} knypie,knypie,,{0} knypie,{0} knypie
        pint,pt.,,{0}pt.,{0}pt.,pinte,,{0} pt.,{0} pt.,pinte,,{0} pint,{0} pinte
        pint-metric,pt.,,{0}mpt.,{0}mpt.,mpt.,,{0} mpt.,{0} mpt.,metrieke pinte,,{0} metrieke pint,{0} metrieke pinte
        quart,kw.gell.,,{0}kw.gell.,{0}kw.gell.,kw.gell.,,{0} kw.gell.,{0} kw.gell.,kwartgellings,,{0} kwartgelling,{0} kwartgellings
        quart-imperial,kwart Eng.,,{0}kw.Eng.,{0}kw.Eng,kwart Eng.,,{0} kwart Eng.,{0} kwart Eng.,kwartgelling,,{0} Engelse kwartgelling,{0} Engelse kwartgelling
        tablespoon,e.,,{0}e.,{0}e.,e.,,{0} e.,{0} e.,eetlepels,,{0} eetlepel,{0} eetlepels
        teaspoon,tl.,,{0}tl.,{0}tl.,tl.,,{0} tl.,{0} tl.,teelepels,,{0} teelepel,{0} teelepels
        mole,mol,,{0}mol,{0}mol,,,,,,,,
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0}kWh/100km,,,,,,,,
        bar,bar,,{0}bar,{0}bar,,,,,,,,
        """.trimIndent()
  }

  private val af_Prefixes: String by lazy {
    """square,,,vierkante {0}
        cubic,,,kubieke {0}
        times,,,{0}-{1}
        per,,,{0} per {1}
        1024p8,,,yobi{0}
        10p-1,,,desi{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,senti{0}
        10p-21,,,zepto{0}
        10p-24,,,yokto{0}
        10p-27,,,ronto{0}
        10p-3,,,milli{0}
        10p-30,,,quecto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,eksa{0}
        10p2,,,hekto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val af_NA_Units: String? = null

  private val af_NA_Prefixes: String? = null

  private val agq_Units: String? = null

  private val agq_Prefixes: String? = null

  private val ak_Units: String by lazy {
    """g-force,,,,,,,,,g-force,,{0} g-force,{0} g-force
        arc-minute,aakesima,,,{0}′,aakesima,,,{0}′,aakesima,,aakesima {0},aakesima {0}
        arc-second,aakesɛkɛnse,,{0} aakesɛkɛnse,{0} aakesɛkɛnse,aakesɛkɛnse,,{0} aakesɛkɛnse,{0} aakesɛkɛnse,aakesɛkɛnse,,{0} aakesɛkɛnse,{0} aakesɛkɛnse
        degree,digrii,,,{0}°,digrii,,,{0}°,digrii,,digrii {0},digrii {0}
        radian,radian,,,{0} rad,radian,,,{0} rad,radian,,{0} radian,{0} radian
        revolution,,,,,,,,,ntwaho,,ntwaho {0},ntwaho {0}
        acre,Eka,,,{0} ac,Eka,,,{0} ac,Eka,,{0} eka,{0} eka
        item,adeɛ,,adeɛ {0},adeɛ {0},adeɛ,,adeɛ {0},adeɛ {0},adeɛ,,adeɛ {0},adeɛ {0}
        karat,karat,,,{0} kt,karat,,,{0} kt,karat,,{0} karat,{0} karat
        milligram-ofglucose-per-deciliter,,,,,,,,,miligrame dɛsilita biara,,miligrame dɛsilita biara {0},miligrame dɛsilita biara {0}
        millimole-per-liter,milimol/lita,,,{0} mmol/L,milimol/lita,,,{0} mmol/L,milimole lita biara,,milimole lita biara {0},milimole lita biara {0}
        mole,mole,,,{0} mol,mole,,,{0} mol,mole,,{0} mole,{0} mole
        percent,ɔha nkyɛmu,,,{0}%,ɔha nkyɛmu,,,{0}%,ɔha nkyɛmu,,ɔha nkyɛmu {0},ɔha nkyɛmu {0}
        permille,pɛɛmile,,,{0}‰,pɛɛmile,,,{0}‰,pɛmile,,pɛɛmile {0},pɛɛmile {0}
        permillion,paat ɔpepem biara,,,{0} ppm,paat ɔpepem biara,,,{0} ppm,paat ɔpepem biara,,paat ɔpepem biara {0},paat ɔpepem biara {0}
        permyriad,pɛɛmiride,,,{0}‱,pɛɛmiride,,,{0}‱,pɛɛmiride,,pɛɛmiride {0},pɛɛmiride {0}
        portion-per-1e9,paat ɔpepepem biara,,,{0} ppb,paat ɔpepepem biara,,,{0} ppb,paat ɔpepepem biara,,paat ɔpepepem biara {0},paat ɔpepepem biara {0}
        liter-per-100-kilometer,,,,,,,,,lita kilomita 100 biara,,lita kilomita 100 biara {0},lita kilomita 100 biara {0}
        liter-per-kilometer,lita kilomita biara,,,{0} L/km,lita kilomita biara,,,{0} L/km,lita kilomita biara,,lita kilomita biara {0},lita kilomita biara {0}
        mile-per-gallon,mile galɔn biara,,,{0} mpg US,mile galɔn biara,,,{0} mpg US,mile galɔn biara,,mile galɔn biara {0},mile galɔn biara {0}
        mile-per-gallon-imperial,mpg UK,,,{0} mpg Imp.,mile Imp. galɔn biara,,,{0} mpg Imp.,mile Imp. galɔn biara,,mile Imp. galɔn biara {0},mile Imp. galɔn biara {0}
        gigabit,Gbit,,,{0} Gb,Gbit,,,{0} Gb,gigabit,,{0} Gb,{0} gigabit
        gigabyte,GByte,,,{0} GB,GByte,,,{0} GB,gigabyte,,{0} gigabyte,{0} gigabyte
        kilobit,kbit,,,{0} kb,kbit,,,{0} kb,kilobit,,{0} kilobit,{0} kilobits
        kilobyte,kByte,,,{0} kB,kByte,,,{0} kB,kilobyte,,{0} kilobyte,{0} kilobyte
        megabit,Mbit,,,{0} Mb,Mbit,,,{0} Mb,megabit,,{0} megabit,{0} megabit
        megabyte,MByte,,,{0} MB,MByte,,,{0} MB,megabyte,,{0} megabyte,{0} megabyte
        petabyte,PByte,,,{0} PB,PByte,,,{0} PB,petabytes,,{0} petabyte,{0} petabyte
        terabit,Tbit,,,{0} Tb,Tbit,,,{0} Tb,terabit,,{0} terabit,{0} terabit
        terabyte,TByte,,,{0} TB,TByte,,,{0} TB,terabyte,,{0} terabyte,{0} terabyte
        century,,,,,,,,,mfeha,,afeha{0},mfeha{0}
        day,da,{0}/d,da {0},nna {0},nna,{0}/d,da {0},nna {0},nna,{0}/d,da {0},nna {0}
        decade,,,,,,,,,mfenhyia du,,mfenhyia du {0},{0} dec
        hour,dɔnhwere,{0}/h,,{0} h,dɔnhwere,{0}/h,,{0} h,dɔnhwere,{0}/h,dɔnhwere {0},dɔnhwere {0}
        microsecond,μsec,,,{0} μs,μsecs,,,{0} μs,μsecs,,{0} mikrosɛkɛn,{0} mikrosɛkɛns
        millisecond,,,,,,,,,millisɛkɛns,,{0} millisɛkɛn,{0} millisɛkɛns
        minute,,,,,,,,,sima,{0}/min,sima {0},sima {0}
        month,bosome,{0}/m,,{0} m,bosome,{0}/m,,{0} m,bosome,bosome biara {0},Bosome {0},Bosome {0}
        nanosecond,nanosɛkɛns,,,{0} ns,nanosɛkɛns,,,{0} ns,nanosɛkɛns,,{0} nanosɛkɛn,{0} nanosɛkɛns
        night,anadwo,{0}/anadwo,anadwo{0},anadwo{0},anadwo,{0}/anadwo,anadwo{0},anadwo{0},anadwo,anadwo biara{0},{0} anadwo,anadwo{0}
        quarter,,,,,,,,,kɔta,{0}/q,kɔta {0},{0} q
        second,,,,,,,,,sima sini,sima sini biara {0},sima sini {0},sima sini {0}
        week,nnawɔtwe,{0}/w,,{0} w,nnawɔtwe,{0}/w,,{0} w,nnawɔtwe,nnawɔtwe biara {0},nnawɔtwe {0},nnawɔtwe {0}
        year,mfeɛ,{0}/y,,{0} y,mfeɛ,{0}/y,,{0} y,mfeɛ,mfeɛ biara {0},mfeɛ {0},mfeɛ {0}
        kilowatt-hour-per-100-kilometer,,,,,,,,,kilowat-nnɔnhwere 100 kilomita biara,,kilowat-nnɔnhwere 100 kilomita biara {0},kilowat-nnɔnhwere 100 kilomita biara {0}
        newton,newton,,,{0} N,newton,,,{0} N,newton,,{0} newton,{0} newton
        pound-force,fɔs mu pɔn,,,{0} lbf,fɔs mu pɔn,,,{0} lbf,fɔs mu pɔn,,fɔs mu pɔn {0},fɔs mu pɔn {0}
        em,,,,,,,,,taipografik ems,,,{0} em
        megapixel,,,,,,,,,MP,,{0} megapixel,{0} megapixels
        pixel,pixels,,,{0} px,pixels,,,{0} px,pixels,,{0} pixel,{0} pixels
        pixel-per-centimeter,,,,,,,,,pixels sɛntimita biara,,pixels sɛntimita biara {0},pixels sɛntimita biara{0}
        pixel-per-inch,,,,,,,,,pixels inkye biara,,pixels inkye biara{0},pixels inkye biara{0}
        astronomical-unit,,,,,,,,,astrɔnɔmikaa winit,,astrɔnɔmikaa winit {0},astrɔnɔmikaa winit {0}
        centimeter,,,,,,,,,sɛntimita,sɛntimita biara {0},sɛntimita {0},sɛntimita {0}
        decimeter,,,,,,,,,dɛsimita,,dɛsimita {0},dɛsimita {0}
        earth-radius,asaase radiɔs,,,{0} R⊕,asaase radiɔs,,,{0} R⊕,asaase radiɔs,,asaase radiɔs {0},asaase radiɔs{0}
        fathom,fatɔmse,,,{0} fth,fatɔmse,,,{0} fth,fatɔmse,,fatɔmse {0},fatɔmse {0}
        foot,ananmɔn,{0}/ft,{0}′,{0}′,ananmɔn,{0}/ft,,{0} ft,ananmɔn,ananmɔn biara {0},ananmɔn {0},{0} ft
        furlong,fɛɛlɔɔne,,,{0} fur,fɛɛlɔɔne,,,{0} fur,fɛɛlɔɔne,,fɛɛlɔɔne {0},fɛɛlɔɔne {0}
        inch,inkyisi,{0}/in,{0}″,{0}″,inkyisi,{0}/in,,{0} in,inkyisi,inkyisi biara {0},inkyisi {0},inkyisi {0}
        kilometer,,,,,,,,,kilomita,kilomita biara{0},kilomita {0},kilomita {0}
        light-year,kanea mfeɛ,,,{0} ly,kanea mfeɛ,,,{0} ly,kanea mfeɛ,,kanea mfeɛ {0},kanea mfeɛ {0}
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,mita,mita biara {0},mita {0},mita {0}
        micrometer,,,,,,,,,mikromita,,mikromita {0},mikromita {0}
        mile,kwansini,,,{0} mi,kwansini,,,{0} mi,kwansini,,kwansini {0},kwansini {0}
        mile-scandinavian,,,,,,,,,miaase-skandinavian,,miaase-skandinavian {0},miaase-skandinavian {0}
        millimeter,,,,,,,,,milimita,,milimita {0},milimita {0}
        nanometer,,,,,,,,,nanomita,,nanomita {0},nanomita {0}
        nautical-mile,,,,,,,,,nɔtikaa ananmɔn,,nɔtikaa ananmɔn {0},nɔtikaa ananmɔn {0}
        parsec,paasɛk,,,{0} pc,paasɛk,,,{0} pc,paasɛk,,paasɛk {0},paasɛk {0}
        picometer,,,,,,,,,pikomita,,pikomita {0},pikomita {0}
        point,pts,,,{0} pt,pɔnse,,,{0} pt,pɔnse,,pɔnse {0},pɔnse {0}
        solar-radius,sola radii,,,{0} R☉,sola radii,,,{0} R☉,sola radii,,sola radii {0},sola radii {0}
        yard,yaase,,,{0} yd,yaase,,,{0} yd,yaase,,yaase {0},yaase {0}
        candela,kandela,,,{0} cd,kandela,,,{0} cd,kandela,,{0} kandela,{0} kandela
        lumen,lumen,,,{0} lm,lumen,,,{0} lm,lumen,,,{0} lm
        lux,lux,,,{0} lx,lux,,,{0} lx,lux,,{0} lux,{0} lux
        solar-luminosity,sola luminɔsitise,,,{0} L☉,sola luminɔsitise,,,{0} L☉,sola luminɔsitise,,sola luminɔsitise {0},sola luminɔsitise {0}
        carat,karat,,,{0} CD,karat,,,{0} CD,karat,,karat {0},karat {0}
        dalton,daatin,,,{0} Da,daatin,,,{0} Da,daatin,,daatin {0},daatin {0}
        earth-mass,Asaase mass,,,{0} M⊕,Asaase mass,,,{0} M⊕,Asaase mass,,Asaase mass {0},Asaase mass {0}
        grain,gr,,{0}gr,{0}gr,grain,,{0} gr,{0} gr,grain,,{0} gr,{0} gr
        gram,grame,{0}/g,,{0} g,grame,{0}/g,,{0} g,grame,grame biara {0},grame {0},{0} g
        kilogram,,,,,,,,,kilograme,kilograme biara {0},kilograme {0},kilograme {0}
        microgram,,,,,,,,,mikrograme,,mikrograme {0},mikrograme {0}
        milligram,,,,,,,,,miligrame,,miligrame {0},miligrame {0}
        ounce,,,,,,,,,awnse,awnse biara {0},awnse {0},awnse {0}
        ounce-troy,oz troy,,,{0} oz t,oz troy,,,{0} oz t,troy awnse,,troy awnse {0},troy awnse {0}
        pound,pɔns,{0}/lb,,{0} lb,pɔns,{0}/lb,,{0} lb,pɔns,pɔns biara {0},pɔns {0},pɔns {0}
        solar-mass,sola mass,,,{0} M☉,sola mass,,,{0} M☉,sola mass,,sola mass {0},sola mass {0}
        ton,,,,,,,,,tn,,{0} ton,{0} tons
        tonne,,,,,,,,,mɛtreke tons,,mɛtreke tons {0},mɛtreke tons {0}
        knot,,,,,,,,,Pɔ,,Pɔ {0},Pɔ {0}
        light-speed,kanea,,kanea {0},kanea {0},kanea,,kanea {0},kanea {0},kanea,,kanea {0},kanea {0}
        mile-per-hour,mi/h,,{0} mph,{0} mph,mi/h,,{0} mph,{0} mph,mi/h,,{0} mph,{0} mph
        newton-meter,,,,,,,,,Newton-mita,,{0} newton-mita,{0} newton-mita
        pound-force-foot,,,,,,,,,pɔn-fɔs-ananmɔn,,pɔn-fɔs-ananmɔn {0},pɔn-fɔs-ananmɔn {0}
        barrel,bare,,,{0} bbl,bare,,,{0} bbl,bare,,bare {0},bare {0}
        cup,kuruwa,,,{0} c,kuruwa,,,{0} c,kuruwa,,kuruwa {0},kuruwa {0}
        dessert-spoon,dsp,,{0}dsp,{0}dsp,atere,,{0} dsp,{0} dsp,atere,,atere {0},atere {0}
        dram,fl.dr.,,drɔm fl {0},drɔm fl {0},drɔm,,drɔm {0},drɔm {0},drɔm,,drɔm fl {0},drɔm fl {0}
        drop,dr,,ko {0},ko {0},koko,,ko {0},ko {0},koko,,ko {0},koko {0}
        jigger,gyega,,gyega {0},gyega {0},gyega,,gyega {0},gyega {0},gyega,,gyega {0},gyega {0}
        liter,lita,{0}/l,,{0} l,lita,{0}/l,,{0} l,lita,{0}/l,{0} l,{0} lita
        pinch,pn,,{0} pn,{0} pn,pinch,,{0} pn,{0} pn,pinch,,{0} pn,{0} pn
        pint,pints,,,{0} pt,pints,,,{0} pt,pints,,,{0} pt
        tablespoon,,,,,,,,,Atere kɛseɛ,,Atere kɛseɛ {0},Atere kɛseɛ {0}
        teaspoon,,,,,,,,,atere fa,,atere fa {0},atere fa {0}
        byte,B,,{0}B,{0}B,,,,,,,,
        gallon,US gal,{0}/gal,,{0} gal US,,,,,,,,
        pint-metric,pt,,,{0} mpt,,,,,,,,
        """.trimIndent()
  }

  private val ak_Prefixes: String by lazy {
    """square,,,sokwɛɛ {0}
        cubic,,,kubik {0}
        times,,,{0}-{1}
        per,,,{0} wɔ {1} biara mu
        10p-1,,,dɛci{0}
        10p-12,,,piko{0}
        10p-15,,,fɛmtɔ{0}
        10p-18,,,atto{0}
        10p-2,,,sɛnti{0}
        10p-3,,,mili{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,dika{0}
        10p12,,,tɛra{0}
        10p15,,,pɛta{0}
        10p2,,,hɛkto{0}
        10p3,,,kilo{0}
        10p6,,,mɛga{0}
        """.trimIndent()
  }

  private val am_Units: String by lazy {
    """g-force,ጂ-ኃይል,,{0} ጂ,{0} ጂ,ጂ-ኃይል,,{0} ጂ,{0} ጂ,ጂ-ኃይል,,{0} ጂ-ኃይል,{0} ጂ-ኃይል
        meter-per-square-second,ሜ/ሰ²,,{0} ሜ/ሰ²,{0} ሜ/ሰ²,ሜ/ሰ²,,{0} ሜ/ሰ²,{0} ሜ/ሰ²,ሜ/ሰ²,,{0} ሜ/ሰ²,{0} ሜ/ሰ²
        arc-minute,ደቂቃ,,{0}′,{0}′,ደቂቃ,,{0} ደቂቃ,{0} ደቂቃ,ደቂቃ,,{0} ደቂቃ,{0} ደቂቃ
        arc-second,ሰከንድ,,{0}″,{0}″,ሰከንድ,,{0} ሰከንድ,{0} ሰከንድ,ሰከንድ,,{0} ሰከንድ,{0} ሰከንድ
        degree,ዲግሪ,,{0}°,{0}°,ዲግሪ,,{0}°ዲግሪ,{0}°ዲግሪ,ዲግሪ,,{0} ዲግሪ,{0} ዲግሪ
        radian,ራዲ,,{0}ራዲ,{0}ራዲ,ራዲ,,{0} ራዲ,{0} ራዲ,ራዲ,,{0} ራዲ,{0} ራዲ
        revolution,ኡደ,,{0} ኡደ,{0}ኡደ,ኡደት,,{0} ኡደት,{0} ኡደት,ኡደት,,{0} ኡደት,{0} ኡደት
        acre,ኤክር,,{0} ኤክር,{0} ኤክር,ኤክር,,{0} ኤክር,{0} ኤክር,ኤክር,,{0} ኤክር,{0} ኤክር
        dunam,ጋሻዎች,,{0} ጋሻ,{0} ጋሻ,ጋሻዎች,,{0} ጋሻ,{0} ጋሻ,ጋሻ,,{0} ጋሻ,{0} ጋሻ
        hectare,ሄክታር,,{0} ሄክታር,{0} ሄክታር,ሄክታር,,{0} ሄክታር,{0} ሄክታር,ሄክታር,,{0} ሄክታር,{0} ሄክታር
        square-centimeter,ሴሜ²,{0}/ሴሜ²,{0} ሴሜ²,{0} ሴሜ²,ሴሜ²,{0}/ሴሜ²,{0} ሴሜ²,{0} ሴሜ²,ሴሜ²,{0}/ሴሜ²,{0} ሴሜ²,{0} ሴሜ²
        square-foot,ካሬ ጫማ,,{0} ጫማ²,{0} ጫማ²,ካሬ ጫማ,,{0} ካሬ ጫማ,{0} ካሬ ጫማ,ካሬ ጫማ,,{0} ካሬ ጫማ,{0} ካሬ ጫማ
        square-inch,ኢንች²,{0}/ኢንች²,{0} ኢንች²,{0} ኢንች²,ኢንች²,{0}/ኢንች²,{0} ኢንች²,{0} ኢንች²,ኢንች²,{0}/ኢንች²,{0} ኢንች²,{0} ኢንች²
        square-kilometer,ካሬ ኪሎሜትር,{0}/ኪሜ²,{0} ኪሜ²,{0} ኪሜ²,ካሬ ኪሎሜትር,{0}/ኪሜ²,{0} ኪሜ²,{0} ኪሜ²,ካሬ ኪሎሜትር,{0}/ኪሜ²,{0} ካሬ ኪሎሜትር,{0} ካሬ ኪሎሜትር
        square-meter,ካሬ ሜትር,{0}/ሜ²,{0} ሜ²,{0} ሜ²,ካሬ ሜትር,{0}/ሜ²,{0} ሜ²,{0} ሜ²,ካሬ ሜትር,{0}/ሜ²,{0} ካሬ ሜትር,{0} ካሬ ሜትር
        square-mile,ካሬ ማይል,{0}/ማይል²,{0} ማይል²,{0} ማይል²,ካሬ ማይል,{0}/ማይል²,{0} ካሬ ማይል,{0} ካሬ ማይል,ካሬ ማይል,{0}/ማይል²,{0} ካሬ ማይል,{0} ካሬ ማይል
        square-yard,ስኴር ያርድ,,{0} ስኴር ያርድ,{0} ስኴር ያርድ,ስኴር ያርድ,,{0} ስኴር ያርድ,{0} ስኴር ያርድ,ስኴር ያርድ,,{0} ስኴር ያርድ,{0} ስኴር ያርድ
        item,ንጥል,,{0} ንጥል,{0} ንጥል,ንጥል,,{0} ንጥል,{0} ንጥል,ንጥሎች,,{0} ንጥል,{0} ንጥሎች
        karat,ካራት,,{0} ካራት,{0} ካራት,ካራት,,{0} ካራት,{0} ካራት,ካራት,,{0} ካራት,{0} ካራት
        milligram-ofglucose-per-deciliter,,,,,,,,,ሚሊ ግራም በ ዴሲ ሊትር,,,{0} mg/dL
        mole,,,,,,,,,mol,,{0} mol,{0} mol
        percent,,,,,ፐርሰንት,,,{0}%,ፐርሰንት,,{0} ፐርሰንት,{0} ፐርሰንት
        permille,በማይል,,,{0}‰,በማይል,,,{0}‰,በማይል,,{0} በማይል,{0}‰
        permillion,,,,,,,,,ppm,,{0} ppm,{0} ppm
        liter-per-100-kilometer,ሊትር በ100 ኪሎሜትሮች,,{0}ሊበ100ኪሜ,{0}ሊበ100ኪሜ,ሊትር በ100 ኪሎሜትሮች,,{0} ሊ/100ኪሜ,{0} ሊ/100ኪሜ,ሊትሮች በ100 ኪሎሜትሮች,,{0} ሊትር በ100 ኪሎሜትሮች,{0} ሊትሮች በ100 ኪሎሜትሮች
        liter-per-kilometer,ሊ/ኪሜ,,{0} ሊ/ኪሜ,{0} ሊ/ኪሜ,ሊ/ኪሜ,,{0} ሊ/ኪሜ,{0} ሊ/ኪሜ,ሊ/ኪሜ,,{0} ሊ/ኪሜ,{0} ሊ/ኪሜ
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg
        bit,ቢት,,{0} ቢት,{0} ቢት,ቢት,,{0} ቢት,{0} ቢት,ቢት,,{0} ቢት,{0} ቢት
        byte,ባይት,,{0} ባይት,{0} ባይት,ባይት,,{0} ባይት,{0} ባይት,ባይት,,{0} ባይት,{0} ባይት
        gigabit,ጊጋባይት,,{0} ጊጋባይት,{0} ጊጋባይት,ጊጋባይት,,{0} ጊጋባይት,{0} ጊጋባይት,ጊጋባይት,,{0} ጊጋባይት,{0} ጊጋባይት
        gigabyte,ጊባ,,{0} ጊባ,{0} ጊባ,ጊባ,,{0} ጊባ,{0} ጊባ,ጊባ,,{0} ጊባ,{0} ጊባ
        kilobit,ኪሎባይት,,{0} ኪሎባይት,{0} ኪሎባይት,ኪሎባይት,,{0} ኪሎባይት,{0} ኪሎባይት,ኪሎባይት,,{0} ኪሎባይት,{0} ኪሎባይት
        kilobyte,ኪባ,,{0} ኪባ,{0} ኪባ,ኪባ,,{0} ኪባ,{0} ኪባ,ኪባ,,{0} ኪባ,{0} ኪባ
        megabit,ሜባ,,{0} ሜባ,{0} ሜባ,ሜባ,,{0} ሜባ,{0} ሜባ,ሜባ,,{0} ሜባ,{0} ሜባ
        megabyte,ሜጋባይት,,{0} ሜጋባይት,{0} ሜጋባይት,ሜጋባይት,,{0} ሜጋባይት,{0} ሜጋባይት,ሜጋባይት,,{0} ሜጋባይት,{0} ሜጋባይት
        petabyte,ፔባ,,{0} ፔባ,{0} ፔባ,ፔ ባይት,,{0} ፔባ,{0} ፔባ,ፔታ ባይት,,{0} ፔታ ባይት,{0} ፔታ ባይቶች
        terabit,ቴባ,,{0} ቴባ,{0} ቴባ,ቴባ,,{0} ቴባ,{0} ቴባ,ቴራባይትስ,,{0} ቴባ,{0} ቴባ
        terabyte,ቴባይት,,{0} ቴራባይት,{0} ቴራባይት,ቴራባይት,,{0} ቴራባይት,{0} ቴራባይት,ቴራባይት,,{0} ቴራባይት,{0} ቴራባይት
        century,ምዕተ ዓመት,,{0}ም.ዓ,{0}ም.ዓ,ምዕተ ዓመት,,{0} ምዕተ ዓመት,{0} ምዕተ ዓመት,ምዕተ ዓመት,,{0} ምዕተ ዓመት,{0} ምዕተ ዓመት
        day,ቀናት,{0}/ቀ,{0} ቀ,{0} ቀ,ቀናት,{0}/ቀ,{0} ቀናት,{0} ቀናት,ቀናት,{0}/ቀ,{0} ቀናት,{0} ቀናት
        decade,ዓሠርተ-ዓመት,,{0} ዓሠ.ዓ,{0} ዓሠ.ዓ,ዓሠርተ-ዓመት,,{0} ዓሠ.ዓ,{0} ዓሠ.ዓ,ዓሠርተ-ዓመት,,{0} ዓሠርተ-ዓመት,{0} ዓሠርተ-ዓመታት
        hour,ሰዓቶች,{0}/ሰ,{0} ሰ,{0} ሰ,ሰዓቶች,{0}/ሰ,{0} ሰዓ,{0} ሰዓ,ሰዓቶች,{0}/ሰ,{0} ሰዓት,{0} ሰዓቶች
        microsecond,ማይክሮሰከንድ,,{0} ማሰ,{0} ማሰ,ማይክሮሰከንድ,,{0} ማሰ,{0} ማሰ,ማይክሮሰከንድ,,{0} ማይክሮሰከንድ,{0} ማይክሮሰከንድ
        millisecond,ሚሊሰከንድ,,{0} ሚሴ,{0} ሚሴ,ሚሊሰከንድ,,{0} ሚሴ,{0} ሚሴ,ሚሊሰከንድ,,{0} ሚሊሰከንድ,{0} ሚሊሰከንድ
        minute,ደቂቃዎች,{0}/ደ,{0} ደ,{0} ደ,ደቂቃዎች,{0}/ደ,{0} ደቂ,{0} ደቂቃ,ደቂቃዎች,{0}/ደ,{0} ደቂቃ,{0} ደቂቃዎች
        month,ወራት,{0}/ወ,{0} ወር,{0} ወር,ወራት,{0}/ወ,{0} ወራት,{0} ወራት,ወራት,{0}/ወ,{0} ወር,{0} ወራት
        nanosecond,ናኖሰከንድ,,{0} ናኖሰከንድ,{0} ናኖሰከንድ,ናኖሰከንድ,,{0} ናኖሰከንድ,{0} ናኖሰከንድ,ናኖሰከንድ,,{0} ናኖሰከንድ,{0} ናኖሰከንድ
        night,ለሊቶች,{0}/ለሊት,{0} ለሊት,{0} ለሊት,ለሊቶች,{0}/ለሊት,{0} ለሊት,{0} ለሊት,ለሊት,{0}/ለሊት,{0}/ለሊት,{0}/ለሊት
        quarter,ሩብ,{0}/ሩ,{0} ሩብ,{0} ሩ,ሩብ,{0}/ሩ,{0} ሩብ,{0} ሩብ,ሩቦች,{0}/ሩ,{0} ሩ,{0} ሩ
        second,ሰከንድ,{0}/ሰከ,{0} ሰ,{0} ሰ,ሰከንዶች,{0}/ሰከ,{0} ሰከ,{0} ሰከ,ሰከንዶች,{0}/ሰከ,{0} ሰከንድ,{0} ሰከንዶች
        week,ሳምንታት,{0}/ሳ,{0} ሳምንት,{0} ሳምንት,ሳምንታት,{0}/ሳ,{0} ሳምንት,{0} ሳምንታት,ሳምንታት,{0}/ሳ,{0} ሳምንት,{0} ሳምንታት
        year,ዓመታት,{0}/ዓ,{0} ዓመት,{0} ዓ,ዓመታት,{0}/ዓ,{0} ዓመት,{0} ዓመታት,ዓመታት,{0}/ዓ,{0} ዓመት,{0} ዓመታት
        ampere,አምፒር,,{0} አምፒር,{0} አምፒር,አምፒር,,{0} አምፒር,{0} አምፒር,አምፒር,,{0} አምፒር,{0} አምፒር
        ohm,,,,,,,,,ohm,,{0} Ω,{0} Ω
        volt,ቮልት,,{0} ቮልት,{0} ቮልት,ቮልት,,{0} ቮልት,{0} ቮልት,ቮልት,,{0} ቮልት,{0} ቮልት
        calorie,ካሎሪ,,{0} ካሎሪ,{0} ካሎሪ,ካሎሪ,,{0} ካሎሪ,{0} ካሎሪ,ካሎሪ,,{0} ካሎሪ,{0} ካሎሪ
        electronvolt,ኤቮ,,{0} ኤቮ,{0} ኤቮ,ኤቮ,,{0} ኤቮ,{0} ኤቮ,ኤቮ,,{0} ኤቮ,{0} ኤቮ
        foodcalorie,ካሎሪ,,{0} ካሎሪ,{0} ካሎሪ,ካሎሪ,,{0} ካሎሪ,{0} ካሎሪ,ካሎሪ,,{0} ካሎሪ,{0} ካሎሪ
        joule,ጁልስ,,{0} ጁልስ,{0} ጁልስ,ጁልስ,,{0} ጁልስ,{0} ጁልስ,ጁልስ,,{0} ጁልስ,{0} ጁልስ
        kilocalorie,ኪሎ ካሎሪ,,{0} ኪሎ ካሎሪ,{0} ኪሎ ካሎሪ,ኪሎ ካሎሪ,,{0} ኪሎ ካሎሪ,{0} ኪሎ ካሎሪ,ኪሎ ካሎሪ,,{0} ኪሎ ካሎሪ,{0} ኪሎ ካሎሪ
        kilojoule,ኪጁ,,{0} ኪጁ,{0} ኪጁ,ኪጁ,,{0} ኪጁ,{0} ኪጁ,ኪጁ,,{0} ኪጁ,{0} ኪጁ
        kilowatt-hour-per-100-kilometer,,,,,,,,,ኪሎዋት-ሰዓት በየ 100 ኪሎሜትሮች,,{0} ኪሎዋት-ሰዓት በየ 100 ኪሎሜትሮች,{0} ኪሎዋት-ሰዓታት በየ 100 ኪሎሜትሮች
        newton,ኒ,,{0} ኒ,{0} ኒ,ኒ,,{0} ኒ,{0} ኒ,ኒ,,{0} ኒ,{0} ኒ
        gigahertz,ጊጋኸርዝ,,{0} ጊጋኸርዝ,{0} ጊጋኸርዝ,ጊጋኸርዝ,,{0} ጊጋኸርዝ,{0} ጊጋኸርዝ,ጊጋኸርዝ,,{0} ጊጋኸርዝ,{0} ጊጋኸርዝ
        hertz,ኸርዝ,,{0} ኸርዝ,{0} ኸርዝ,ኸርዝ,,{0} ኸርዝ,{0} ኸርዝ,ኸርዝ,,{0} ኸርዝ,{0} ኸርዝ
        kilohertz,ኪሎኸርዝ,,{0} ኪሎኸርዝ,{0} ኪሎኸርዝ,ኪሎኸርዝ,,{0} ኪሎኸርዝ,{0} ኪሎኸርዝ,ኪሎኸርዝ,,{0} ኪሎኸርዝ,{0} ኪሎኸርዝ
        megahertz,ሜጋኸርዝ,,{0} ሜጋኸርዝ,{0} ሜጋኸርዝ,ሜጋኸርዝ,,{0} ሜጋኸርዝ,{0} ሜጋኸርዝ,ሜጋኸርዝ,,{0} ሜጋኸርዝ,{0} ሜጋኸርዝ
        dot,ነቁጥ,,{0} ነቁጥ,{0} ነቁጥ,ነቁጥ,,{0} ነቁጥ,{0} ነቁጥ,ነቁጥ,,{0} ነቁጥ,{0} ነቁጥ
        dot-per-centimeter,ነበሴሜ,,{0} ነበሴሜ,{0} ነበሴሜ,ነበሴሜ,,{0} ነበሴሜ,{0} ነበሴሜ,ነበሴሜ,,{0} ነበሴሜ,{0} ነበሴሜ
        dot-per-inch,ነበኢ,,{0} ነበኢ,{0} ነበኢ,ነበኢ,,{0} ነበኢ,{0} ነበኢ,ነበኢ,,{0} ነበኢ,{0} ነበኢ
        em,,,,,,,,,ታይፖግራፊክ em,,,{0} em
        megapixel,ሜጋ ፒክስል,,{0} ሜፒ,{0} ሜፒ,ሜጋ ፒክስል,,{0} ሜጋ ፒክስል,{0} ሜጋ ፒክስል,ሜጋ ፒክስል,,{0} ሜጋ ፒክስል,{0} ሜጋ ፒክስል
        pixel,ፒክስል,,{0} ፒክስል,{0} ፒክስል,ፒክስል,,{0} ፒክስል,{0} ፒክስል,ፒክስል,,{0} ፒክስል,{0} ፒክስል
        pixel-per-centimeter,ፒበሴሜ,,{0} ፒበሴሜ,{0} ፒበሴሜ,ፒበሴሜ,,{0} ፒበሴሜ,{0} ፒበሴሜ,ፒበሴሜ,,{0} ፒበሴሜ,{0} ፒበሴሜ
        pixel-per-inch,ፒበኢ,,{0} ፒበኢ,{0} ፒበኢ,ፒበኢ,,{0} ፒበኢ,{0} ፒበኢ,ፒበኢ,,{0} ፒበኢ,{0} ፒበኢ
        centimeter,ሴንቲሜትር,{0}/ሴሜ,{0} ሴሜ,{0} ሴሜ,ሴንቲሜትር,{0}/ሴሜ,{0} ሴሜ,{0} ሴሜ,ሴንቲሜትር,{0}/ሴሜ,{0} ሴንቲሜትር,{0} ሴንቲሜትር
        decimeter,ዴሜ,,{0} ዴሜ,{0} ዴሜ,ዴሜ,,{0} ዴሜ,{0} ዴሜ,ዴሲ ሜትር,,{0} ዴሲ ሜትር,{0} ዴሲ ሜትር
        fathom,ተዳክሞዎች,,{0} ተዳክሞ,{0} ተዳክሞ,ተዳክሞዎች,,{0} ተዳክሞ,{0} ተዳክሞ,ተዳክሞዎች,,{0} ተዳክሞ,{0} ተዳክሞዎች
        foot,ጫማ,{0}/ጫማ,{0} ጫማ,{0} ጫማ,ጫማ,{0}/ጫማ,{0} ጫማ,{0} ጫማ,ጫማ,{0}/ጫማ,{0} ጫማ,{0} ጫማ
        furlong,ፈሎን,,{0} ፈሎን,{0} ፈሎን,ፈሎን,,{0} ፈሎን,{0} ፈሎን,ፈሎን,,{0} ፈሎን,{0} ፈሎን
        inch,ኢንች,{0}/ኢንች,{0} ኢንች,{0} ኢንች,ኢንች,{0}/ኢንች,{0} ኢንች,{0} ኢንች,ኢንች,{0}/ኢንች,{0} ኢንች,{0} ኢንች
        kilometer,ኪሎሜትር,{0}/ኪሜ,{0} ኪሜ,{0} ኪሜ,ኪሎሜትር,{0}/ኪሜ,{0} ኪሜ,{0} ኪሜ,ኪሎሜትር,{0}/ኪሜ,{0} ኪሎሜትር,{0} ኪሎሜትር
        light-year,የብርሃን ዓመት,,{0} ብዓ,{0} ብዓ,የብርሃን ዓመት,,{0} ብዓ,{0} ብዓ,የብርሃን ዓመት,,{0} የብርሃን ዓመት,{0} የብርሃን ዓመት
        meter,ሜትር,{0}/ሜ,{0} ሜ,{0} ሜ,ሜትር,{0}/ሜ,{0} ሜ,{0} ሜ,ሜትር,{0}/ሜ,{0} ሜትር,{0} ሜትር
        micrometer,ማሜ,,{0} ማሜ,{0} ማሜ,ማሜ,,{0} ማሜ,{0} ማሜ,ማይክሮ ሜትር,,{0} ማይክሮ ሜትር,{0} ማይክሮ ሜትር
        mile,ማይል,,{0} ማይል,{0} ማይል,ማይል,,{0} ማይል,{0} ማይል,ማይል,,{0} ማይል,{0} ማይል
        mile-scandinavian,ስማይል,,{0} ስማይል,{0} ስማይል,ስማይል,,{0} ስማይል,{0} ስማይል,ስማይል,,{0} ስማይል,{0} ስማይል
        millimeter,ሚሊሜትር,,{0} ሚሜ,{0} ሚሜ,ሚሊሜትር,,{0} ሚሜ,{0} ሚሜ,ሚሊሜትር,,{0} ሚሊሜትር,{0} ሚሊሜትር
        nanometer,ናሜ,,{0} ናሜ,{0} ናሜ,ናሜ,,{0} ናሜ,{0} ናሜ,ናኖ ሜትር,,{0} ናኖ ሜትር,{0} ናኖ ሜትር
        picometer,ፒኮሜትር,,{0} ፒሜ,{0} ፒሜ,ፒኮሜትር,,{0} ፒሜ,{0} ፒሜ,ፒኮሜትር,,{0} ፒኮሜትር,{0} ፒኮሜትር
        point,ነጥብ,,{0} ነጥብ,{0} ነጥብ,ነጥብ,,{0} ነጥብ,{0} ነጥብ,ነጥብ,,{0} ነጥብ,{0} ነጥብ
        solar-radius,ሶላር ራዲ,,,{0} R☉,ሶላር ራዲ,,,{0} R☉,ሶላር ራዲ,,{0} ሶላር ዳዲየስ,{0} ሶላር ራዲ
        yard,ያርድ,,{0} ያርድ,{0} ያርድ,ያርድ,,{0} ያርድ,{0} ያርድ,ያርድ,,{0} ያርድ,{0} ያርድ
        candela,ካንዴላ,,{0} ካንዴላ,{0} ካንዴላ,ካንዴላ,,{0} ካንዴላ,{0} ካንዴላ,ካንዴላ,,{0} ካንዴላ,{0} ካንዴላ
        lumen,ቱቦ ቀዳዳ,,{0} ቱቦ ቀዳዳ,{0} ቱቦ ቀዳዳ,ቱቦ ቀዳዳ,,{0} ቱቦ ቀዳዳ,{0} ቱቦ ቀዳዳ,ቱቦ ቀዳዳ,,{0} ቱቦ ቀዳዳ,{0} ቱቦ ቀዳዳ
        lux,lux,,,{0} lx,,,,,lx,,{0} lx,{0} lx
        carat,ካራት,,,{0} CD,,,,,ካራቶች,,{0} ካራት,{0} CD
        dalton,ዳልተንስ,,{0} ዳልተንስ,{0} ዳልተንስ,ዳልተንስ,,{0} ዳልተንስ,{0} ዳልተንስ,ዳልተንስ,,{0} ዳልተንስ,{0} ዳልተንስ
        earth-mass,ኤርዝማስስ,,,{0} M⊕,ኤርዝማስስ,,,{0} M⊕,ኤርዝማስስ,,{0} ኤርዝማስስ,{0} ኤርዝማስስ
        grain,ጥራ ጥሬ,,{0} ጥራ ጥሬ,{0} ጥራ ጥሬ,ጥራ ጥሬ,,{0} ጥራ ጥሬ,{0} ጥራ ጥሬ,ጥራ ጥሬ,,{0} ጥራ ጥሬ,{0} ጥራ ጥሬ
        gram,ግራም,{0}/ግራም,{0} ግ,{0} ግ,ግራም,{0}/ግራም,{0} ግ,{0} ግ,ግራም,{0}/ግራም,{0} ግራም,{0} ግራም
        kilogram,ኪሎግራም,{0}/ኪሎግራም,{0} ኪግ,{0} ኪግ,ኪሎግራም,{0}/ኪሎግራም,{0} ኪግ,{0} ኪግ,ኪሎግራም,{0}/ኪሎግራም,{0} ኪሎግራም,{0} ኪሎግራም
        microgram,ማግ,,{0} ማግ,{0} ማግ,ማግ,,{0} ማግ,{0} ማግ,ማግ,,{0} ማግ,{0} ማግ
        milligram,ሚሊግራም,,{0} ሚሊግራም,{0} ሚሊግራም,ሚግ,,{0} ሚግ,{0} ሚግ,ሚግ,,{0} ሚግ,{0} ሚግ
        ounce,አውንስ,{0}/አውንስ,{0} አውንስ,{0} አውንስ,አውንስ,{0}/አውንስ,{0} አውንስ,{0} አውንስ,አውንስ,{0}/አውንስ,{0} አውንስ,{0} አውንስ
        pound,ፓውንድ,{0}/ፓውንድ,{0} ፓውንድ,{0} ፓውንድ,ፓውንድ,{0}/ፓውንድ,{0} ፓውንድ,{0} ፓውንድ,ፓውንድ,{0}/ፓውንድ,{0} ፓውንድ,{0} ፓውንድ
        solar-mass,ሶላር ማስስ,,,{0} M☉,ሶላር ማስስ,,,{0} M☉,ሶላር ማስስ,,{0} ሶላር ማስስ,{0} ሶላር ማስስ
        stone,ድንጋይ,,{0} ድንጋይ,{0} ድንጋይ,ድንጋይ,,{0} ድንጋይ,{0} ድንጋይ,ድንጋይ,,{0} ድንጋይ,{0} ድንጋይ
        ton,ቶን,,{0} ቶን,{0} ቶን,ቶን,,{0} ቶን,{0} ቶን,ቶን,,{0} ቶን,{0} ቶን
        tonne,ቶ,,{0} ቶ,{0} ቶ,ቶ,,{0} ቶ,{0} ቶ,ቶ,,{0} ሜትሪክ ቶን,{0} ሜትሪክ ቶኖች
        gigawatt,ጊዋ,,{0} ጊዋ,{0} ጊዋ,ጊጋ ዋት,,{0} ጊዋ,{0} ጊዋ,ጊጋ ዋት,,{0} ጊዋ,{0} ጊዋ
        horsepower,የፈረስ ጉልበት,,{0} የፈረስ ኃይል,{0} የፈረስ ኃይል,የፈረስ ጉልበት,,{0} የፈጉ,{0} የፈጉ,የፈረስ ጉልበት,,{0} የፈረስ ጉልበት,{0} የፈረስ ጉልበት
        kilowatt,ኪሎዋት,,{0} ኪዋ,{0} ኪዋ,ኪሎዋት,,{0} ኪዋ,{0} ኪዋ,ኪሎዋት,,{0} ኪሎዋት,{0} ኪሎዋት
        megawatt,ሜዋ,,{0} ሜዋ,{0} ሜዋ,ሜዋ,,{0} ሜዋ,{0} ሜዋ,ሜጋ ዋት,,{0} ሜዋ,{0} ሜዋ
        milliwatt,ሚዋ,,{0} ሚዋ,{0} ሚዋ,ሚዋ,,{0} ሚዋ,{0} ሚዋ,ሚሊ ዋት,,{0} ሚዋ,{0} ሚዋ
        watt,ዋት,,{0} ዋ,{0} ዋ,ዋት,,{0} ዋ,{0} ዋ,ዋት,,{0} ዋት,{0} ዋት
        atmosphere,ከባቢ አየር,,{0} ከአ,{0} ከአ,ከባቢ አየር,,{0} ከባቢ አየር,{0} ከባቢ አየር,ከባቢ አየር,,{0} ከባቢ አየር,{0} ከባቢ አየር
        bar,አሞሌ,,{0} አሞሌ,{0} አሞሌዎች,አሞሌ,,{0} አሞሌ,{0} አሞሌዎች,አሞሌ,,{0} አሞሌ,{0} አሞሌዎች
        hectopascal,ሄክቶፓስካል,,{0} hPa,{0} hPa,ሄክቶፓስካል,,{0} ሄክቶፓስካል,{0} ሄክቶፓስካል,ሄክቶፓስካል,,{0} ሄክቶፓስካል,{0} ሄክቶፓስካል
        inch-ofhg,ኢንች ሜርኩሪ,,{0} inHg,{0} inHg,ኢንች ሜርኩሪ,,{0} ኢሜ,{0} ኢንሜር,ኢንች ሜርኩሪ,,{0} ኢንች ሜርኩሪ,{0} ኢንች ሜርኩሪ
        kilopascal,ኪሎፓስካል,,{0} ኪፓ,{0} ኪፓ,ኪሎፓስካል,,{0} ኪሎፓስካል,{0} ኪሎፓስካል,ኪሎፓስካል,,{0} ኪሎፓስካል,{0} ኪሎፓስካል
        megapascal,ሜጋፓስካል,,{0} ሜፓ,{0} ሜፓ,ሜጋፓስካል,,{0} ሜጋፓስካል,{0} ሜጋፓስካል,ሜጋፓስካል,,{0} ሜጋፓስካል,{0} ሜጋፓስካሎች
        millibar,ሚሊባር,,{0} ሚባ,{0} ሚባ,ሚሊባር,,{0} ሚባ,{0} ሚባ,ሚሊባር,,{0} ሚሊባር,{0} ሚሊባር
        pascal,ፓስካል,,{0} ፓስካል,{0} ፓስካል,ፓስካል,,{0} ፓስካል,{0} ፓስካል,ፓስካል,,{0} ፓስካል,{0} ፓስካል
        kilometer-per-hour,ኪሎሜትር በሰዓት,,{0} ኪሜ/ሰ,{0} ኪሜ/ሰ,ኪሎሜትር በሰዓት,,{0} ኪሜ/ሰ,{0} ኪሜ/ሰ,ኪሎሜትር በሰዓት,,{0} ኪሎሜትር በሰዓት,{0} ኪሎሜትር በሰዓት
        light-speed,ብርሃን,,{0} ብርሃን,{0} ብርሃን,ብርሃን,,{0} ብርሃን,{0} ብርሃን,ብርሃን,,{0} ብርሃን,{0} ብርሃን
        meter-per-second,ሜትር በሰከንድ,,{0} ሜ/ሴ,{0} ሜ/ሴ,ሜትር በሰከንድ,,{0} ሜ/ሴ,{0} ሜ/ሴ,ሜትር በሰከንድ,,{0} ሜትር በሰከንድ,{0} ሜትር በሰከንድ
        mile-per-hour,ማይል በሰዓት,,{0} ማይል/ሰ,{0} ማይል/ሰ,ማይል በሰዓት,,{0} ማይል/ሰ,{0} ማይል/ሰ,ማይል በሰዓት,,{0} ማይል በሰዓት,{0} ማይል በሰዓት
        celsius,ዲግሪ ሴልሺየስ,,{0}°,{0}°,ዲግሪ ሴልሺየስ,,{0}°ሴ,{0}°ሴ,ዲግሪ ሴልሺየስ,,{0} ዲግሪ ሴልሺየስ,{0} ዲግሪ ሴልሺየስ
        fahrenheit,ዲግሪ ፋራንሃይት,,{0}°ፋ,{0}°ፋ,ዲግሪ ፋራንሃይት,,{0}°ፋ,{0}°ፋ,ዲግሪ ፋራንሃይት,,{0} ዲግሪ ፋራንሃይት,{0} ዲግሪ ፋራንሃይት
        kelvin,ኬ,,{0} ኬ,{0} ኬ,ኬ,,{0} ኬ,{0} ኬ,ኬ,,{0} ኬ,{0} ኬ
        newton-meter,ኒ.ሜ,,{0} ኒ.ሜ,{0} ኒ.ሜ,ኒ.ሜ,,{0} ኒ.ሜ,{0} ኒ.ሜ,ኒ.ሜ,,{0} ኒ.ሜ,{0} ኒ.ሜ
        acre-foot,ኤከር ጫማ,,{0} ኤጫ,{0} ኤጫ,ኤከር ጫማ,,{0} ኤከር ጫማ,{0} ኤከር ጫማ,ኤከር ጫማ,,{0} ኤከር ጫማ,{0} ኤከር ጫማ
        barrel,በርሜል,,{0} በርሜል,{0} በርሜል,በርሜል,,{0} በርሜል,{0} በርሜል,በርሜል,,{0} በርሜል,{0} በርሜሎች
        bushel,ዳውላ,,{0} ዳውላ,{0} ዳውላ,ዳውላ,,{0} ዳውላ,{0} ዳውላ,ዳውላ,,{0} ዳውላ,{0} ዳውላ
        centiliter,ሴሊ,,{0} ሴሊ,{0} ሴሊ,ሴሊ,,{0} ሴሊ,{0} ሴሊ,ሴንቲ ሊትር,,{0} ሴንቲ ሊትር,{0} ሴንቲ ሊትር
        cubic-centimeter,ሴሜ³,{0}/ሴሜ³,{0} ሴሜ³,{0} ሴሜ³,ሴሜ³,{0}/ሴሜ³,{0} ሴሜ³,{0} ሴሜ³,ሴሜ³,{0}/ሴሜ³,{0} ሴሜ³,{0} ሴሜ³
        cubic-foot,ጫማ³,,{0} ጫማ³,{0} ጫማ³,ጫማ³,,{0} ጫማ³,{0} ጫማ³,ጫማ³,,{0} ጫማ³,{0} ጫማ³
        cubic-inch,ኢንች³,,{0} ኢንች³,{0} ኢንች³,ኢንች³,,{0} ኢንች³,{0} ኢንች³,ኢንች³,,{0} ኢንች³,{0} ኢንች³
        cubic-kilometer,ኩቢክ ኪሎሜትር,,{0} ኪሜ³,{0} ኪሜ³,ኩቢክ ኪሎሜትር,,{0} ኪሜ³,{0} ኪሜ³,ኩቢክ ኪሎሜትር,,{0} ኩቢክ ኪሎሜትር,{0} ኩቢክ ኪሎሜትር
        cubic-meter,ሜ³,{0}/ሜ³,{0} ሜ³,{0} ሜ³,ሜ³,{0}/ሜ³,{0} ሜ³,{0} ሜ³,ሜ³,{0}/ሜ³,{0} ሜ³,{0} ሜ³
        cubic-mile,ኩቢክ ማይል,,{0} ማይል³,{0} ማይል³,ኩቢክ ማይል,,{0} ማይል³,{0} ማይል³,ኩቢክ ማይል,,{0} ኩቢክ ማይል,{0} ኩቢክ ማይል
        cubic-yard,ኪዩቢክ ያርድ,,{0} ኪዩቢክ ያርድ,{0} ኪዩቢክ ያርድ,ኪዩቢክ ያርድ,,{0} ኪዩቢክ ያርድ,{0} ኪዩቢክ ያርድ,ኪዩቢክ ያርድ,,{0} ኪዩቢክ ያርድ,{0} ኪዩቢክ ያርድ
        cup,ኩባያ,,{0} ኩባያ,{0} ኩባያ,ኩባያ,,{0} ኩባያ,{0} ኩባያ,ኩባያ,,{0} ኩባያ,{0} ኩባያ
        deciliter,ዴሊ,,{0} ዴሊ,{0} ዴሊ,ዴሊ,,{0} ዴሊ,{0} ዴሊ,ዴሲ ሊትር,,{0} ዴሲ ሊትር,{0} ዴሲ ሊትር
        dessert-spoon,የመምድረ በዳ ማንኪያ,,{0} የመምድረ በዳ ማንኪያ,{0} የመምድረ በዳ ማንኪያ,የመምድረ በዳ ማንኪያ,,{0} የመምድረ በዳ ማንኪያ,{0} የመምድረ በዳ ማንኪያ,የመምድረ በዳ ማንኪያ,,{0} የመምድረ በዳ ማንኪያ,{0} የመምድረ በዳ ማንኪያ
        dessert-spoon-imperial,የምድረ በዳ ማንኪያ,,{0} የምድረ በዳ ማንኪያ,{0} የምድረ በዳ ማንኪያ,የምድረ በዳ ማንኪያ,,{0} የምድረ በዳ ማንኪያ,{0} የምድረ በዳ ማንኪያ,የምድረ በዳ ማንኪያ,,{0} የምድረ በዳ ማንኪያ,{0} የምድረ በዳ ማንኪያ
        dram,የክብደት መለኪያ,,{0} ክመ,{0} ክመ,የክብደት መለኪያ,,{0} የክብደት መለኪያ,{0} የክብደት መለኪያ,የክብደት መለኪያ,,{0} የክብደት መለኪያ,{0} የክብደት መለኪያ
        drop,ጠብታ,,{0} ጠብታ,{0} ጠብታ,ጠብታ,,{0} ጠብታ,{0} ጠብታ,ጠብታ,,{0} ጠብታ,{0} ጠብታ
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz
        fluid-ounce-imperial,,,,,,,,,Imp. fluid ኦንስስ,,{0} Imp. fluid ኦንስስ,{0} Imp. fluid ኦንስስ
        gallon,ጋሎን,{0}/ጋሎን,{0} ጋሎን,{0} ጋሎን,ጋሎን,{0}/ጋሎን,{0}/ጋሎን,{0} ጋሎን,ጋሎን,{0}/ጋሎን,{0}/ጋሎን,{0}/ጋሎን
        hectoliter,ሄሊ,,{0} ሄሊ,{0} ሄሊ,ሄሊ,,{0} ሄሊ,{0} ሄሊ,ሄክቶሊትር,,{0} ሄሊ,{0} ሄሊ
        jigger,ሙጃሌ,,{0} ሙጃሌ,{0} ሙጃሌ,ሙጃሌ,,{0} ሙጃሌ,{0} ሙጃሌ,ሙጃሌ,,{0} ሙጃሌ,{0} ሙጃሌ
        liter,ሊትር,{0}/ሊትር,{0} ሊ,{0} ሊ,ሊትር,{0}/ሊትር,{0} ሊ,{0} ሊ,ሊትር,{0}/ሊትር,{0} ሊትር,{0} ሊትር
        megaliter,ሜጋሊትር,,{0} ሜጋሊትር,{0} ሜጋሊትር,ሜጋሊትር,,{0} ሜሊ,{0} ሜሊ,ሜጋሊትር,,{0} ሜሊ,{0} ሜሊ
        milliliter,ሚሊ ሊትር,,{0} ሚሊ,{0} ሚሊ,ሚሊ ሊትር,,{0} ሚሊ ሊትር,{0} ሚሊ ሊትር,ሚሊ ሊትር,,{0} ሚሊ ሊትር,{0} ሚሊ ሊትር
        pinch,ቁንጥ,,{0} ቁንጥ,{0} ቁንጥ,ቁንጥ,,{0} ቁንጥ,{0} ቁንጥ,ቁንጥ,,{0} ቁንጥ,{0} ቁንጥ
        pint-metric,,,,,,,,,mpt,,{0} mpt,{0} mpt
        quart,ኳርትስ,,{0} ኳርትስ,{0} ኳርትስ,ኳርትስ,,{0} ኳርትስ,{0} ኳርትስ,ኳርትስ,,{0} ኳርትስ,{0} ኳርትስ
        quart-imperial,የፈሳሽ መለኪያ,,{0} ፈመ,{0} ፈመ,የፈሳሽ መለኪያ,,{0} የፈሳሽ መለኪያ,{0} የፈሳሽ መለኪያ,የፈሳሽ መለኪያ,,{0} የፈሳሽ መለኪያ,{0} የፈሳሽ መለኪያ
        tablespoon,የሻይ ማንኪያ,,{0} የሻይ ማንኪያ,{0} የሻይ ማንኪያ,የሻይ ማንኪያ,,{0} የሻይ ማንኪያ,{0} የሻይ ማንኪያ,የሻይ ማንኪያ,,{0} የሻይ ማንኪያ,{0} የሻይ ማንኪያ
        teaspoon,የሻይ ማንኪያዎች,,{0} የሻይ ማንኪያዎች,{0} የሻይ ማንኪያዎች,የሻይ ማንኪያዎች,,{0} የሻይ ማንኪያዎች,{0} የሻይ ማንኪያዎች,የሻይ ማንኪያዎች,,{0} የሻይ ማንኪያዎች,{0} የሻይ ማንኪያዎች
        nautical-mile,ማይለባህር,,{0} ማይለባህር,{0} ማይለባህር,,,,,,,,
        """.trimIndent()
  }

  private val am_Prefixes: String by lazy {
    """square,,,ስኩየር {0}
        cubic,,,ኪዩቢክ {0}
        per,,,{0} በ{1}
        1024p1,{0} ኪቢ,{0} ኪቢ,{0} ኪቢ
        1024p2,{0} ሜቢ,{0} ሜቢ,{0} ሜቢ
        1024p3,{0} ጊቢ,{0} ጊቢ,{0} ጊቢ
        1024p4,{0} ቴቢ,{0} ቴቢ,{0} ቴቢ
        1024p5,{0} ፔቢ,{0} ፔቢ,{0} ፔቢ
        1024p7,{0} ዜቢ,{0} ዜቢ,{0} ዜቢ
        1024p8,ዮቢ {0},ዮቢ {0},ዮቢ {0}
        10p-1,ደ{0},ደ{0},ደሲ{0}
        10p-12,ፒ{0},ፒ{0},ፒኮ{0}
        10p-15,ፌ{0},ፌ{0},ፌምቶ{0}
        10p-18,አ{0},አ{0},አቶ{0}
        10p-2,ሴ{0},ሴ{0},ሴንቲ{0}
        10p-21,ዜ{0},ዜ{0},ዜብቶ{0}
        10p-24,ዮ{0},ዮ{0},ዮክቶ{0}
        10p-3,ሚ{0},ሚ{0},ሚሊ{0}
        10p-6,ማይክሮ{0},ማይክሮ{0},ማይክሮ{0}
        10p-9,ና{0},ና{0},ናኖ{0}
        10p1,ዴ{0},ዴ{0},ዴካ{0}
        10p12,ቴራ {0},ቴራ {0},ቴራ {0}
        10p15,ፔታ {0},ፔታ {0},ፔታ {0}
        10p18,,,ኤክሳ {0}
        10p2,ሄ{0},ሄ{0},ሄክቶ{0}
        10p21,ዜታ {0},ዜታ {0},ዜታ {0}
        10p24,ዮታ {0},ዮታ {0},ዮታ {0}
        10p27,ሮና {0},ሮና {0},ሮና {0}
        10p3,ኪ{0},ኪ{0},ኪሎ{0}
        10p6,ሜ{0},ሜ{0},ሜጋ{0}
        10p9,ጊ{0},ጊ{0},ጊጋ{0}
        """.trimIndent()
  }

  private val an_Units: String? = null

  private val an_Prefixes: String? = null

  private val ann_Units: String? = null

  private val ann_Prefixes: String? = null

  private val apc_Units: String? = null

  private val apc_Prefixes: String? = null

  private val ar_Units: String by lazy {
    """g-force,قوة تسارع,,{0} قوة تسارع,{0} قوة تسارع,قوة تسارع,,{0} قوة تسارع,{0} قوة تسارع,قوة تسارع,,{0} قوة تسارع,{0} قوة تسارع
        meter-per-square-second,م/ث²,,{0} م/ث²,{0} م/ث²,م/ث²,,{0} م/ث²,{0} م/ث²,متر في الثانية المربعة,,{0} متر في الثانية المربعة,{0} متر في الثانية المربعة
        arc-minute,د قوسية,,{0} د قوسية,{0} د قوسية,دقيقة قوسية,,دقيقة قوسية,{0} دقيقة قوسية,دقيقة قوسية,,دقيقة قوسية,{0} دقيقة قوسية
        arc-second,ث قوسية,,{0} ث قوسية,{0} ث قوسية,ثانية قوسية,,ثانية قوسية,{0} ثانية قوسية,ثانية قوسية,,ثانية قوسية,{0} ثانية قوسية
        degree,درجة,,{0} درجة,{0} درجة,درجة,,درجة,{0} درجة,درجة,,درجة,{0} درجة
        radian,راديان,,{0} راديان,{0} راديان,راديان,,{0} راديان,{0} راديان,راديان,,{0} راديان,{0} راديان
        revolution,دورة,,دورة,{0} دورة,دورة,,دورة,{0} دورة,دورة,,دورة,{0} دورة
        acre,فدان,,فدان,{0} فدان,فدان,,فدان,{0} فدان,فدان,,فدان,{0} فدان
        dunam,دونم,,{0} دونم,{0} دونم,دونم,,{0} دونم,{0} دونم,دونم,,{0} دونم,{0} دونم
        hectare,هكتار,,{0} هكتار,{0} هكتار,هكتار,,{0} هكتار,{0} هكتار,هكتار,,{0} هكتار,{0} هكتار
        square-centimeter,سم ²,{0}/سم²,{0} سم²,{0} سم²,سم ²,{0}/سم²,{0} سم²,{0} سم²,سنتيمتر مربع,{0}/سنتيمتر مربع,{0} سنتيمتر مربع,{0} سنتيمتر مربع
        square-foot,قدم²,,{0} قدم²,{0} قدم²,قدم²,,{0} قدم²,{0} قدم²,قدم مربعة,,قدم مربعة,{0} قدم مربعة
        square-inch,بوصة²,{0}/بوصة²,{0} بوصة²,{0} بوصة²,بوصة²,{0}/بوصة²,{0} بوصة²,{0} بوصة²,بوصة مربعة,{0} لكل بوصة مربعة,{0} بوصة مربعة,{0} بوصة مربعة
        square-kilometer,كم²,{0}/كم²,{0} كم²,{0} كم²,كم²,{0}/كم²,{0} كم²,{0} كم²,كيلومتر مربع,{0}/كيلومتر مربع,{0} كيلومتر مربع,{0} كيلومتر مربع
        square-meter,م²,{0}/م²,{0} م²,{0} م²,م²,{0}/م²,{0} م²,{0} م²,متر مربع,{0} لكل متر مربع,{0} متر مربع,{0} متر مربع
        square-mile,ميل²,{0}/ميل²,{0} ميل²,{0} ميل²,ميل²,{0}/ميل²,{0} ميل²,{0} ميل²,ميل مربع,{0} لكل ميل مربع,{0} ميل مربع,{0} ميل مربع
        square-yard,ياردة²,,{0} ياردة²,{0} ياردة²,ياردة²,,{0} ياردة²,{0} ياردة²,ياردة مربعة,,{0} ياردة مربعة,{0} ياردة مربعة
        item,عنصر,,عنصر,{0} عنصر,عنصر,,عنصر,{0} عنصر,عنصر,,عنصر واحد,{0} عنصر
        karat,قيراط,,قيراط,{0} قيراط,قيراط,,قيراط,{0} قيراط,قيراط,,قيراط,{0} قيراط
        milligram-ofglucose-per-deciliter,مغ/ديسيل,,{0} مغ/ديسيل,{0} مغ/ديسيل,مغم/ديسيل,,{0} مغم/ديسيل,{0} مغم/ديسيل,مغم/ديسيلتر,,مغم/ديسيلتر,{0} مغم/ديسيلتر
        millimole-per-liter,م.مول/ل,,{0} م.مول/ل,{0} م.مول/ل,م.مول/ل,,{0} م.مول/ل,{0} م.مول/ل,ملي مول/لتر,,{0} ملي مول/لتر,{0} ملي مول/لتر
        mole,مول,,{0} مول,{0} مول,مول,,{0} مول,{0} مول,مول,,{0} مول,{0} مول
        percent,٪,,{0}٪,{0}٪,بالمائة,,{0}٪,{0}٪,بالمائة,,{0} بالمائة,{0} بالمائة
        permille,؉,,{0}؉,{0}؉,في الألف,,{0}؉,{0}؉,في الألف,,{0} في الألف,{0} في الألف
        permillion,جزء/مليون,,{0} جزء/مليون,{0} جزء/مليون,جزء/مليون,,{0} جزء/مليون,{0} جزء/مليون,جزء في المليون,,{0} جزء في المليون,{0} جزء في المليون
        portion-per-1e9,جزء/مليار,,{0} جزء/مليار,{0} جزء/مليار,جزء/مليار,,{0} جزء/مليار,{0} جزء/مليار,جزء بالمليار,,{0} جزء بالمليار,{0} جزء بالمليار
        liter-per-100-kilometer,ل/١٠٠كم,,{0} ل/١٠٠كم,{0} ل/١٠٠كم,لتر/‏١٠٠ كم,,{0} لتر/١٠٠ كم,{0} لتر/١٠٠ كم,لتر لكل ١٠٠ كيلومتر,,{0} لتر لكل ١٠٠ كيلومتر,{0} لتر لكل ١٠٠ كيلومتر
        liter-per-kilometer,ل/كم,,{0} ل/كم,{0} ل/كم,لتر/كم,,{0} لتر/كم,{0} لتر/كم,لتر لكل كيلومتر,,{0} لتر لكل كيلومتر,{0} لتر لكل كيلومتر
        mile-per-gallon,ميل/غالون,,{0} ميل/غالون,{0} ميل/غالون,ميل/غالون,,{0} ميل/غالون,{0} ميل/غالون,ميل لكل غالون,,{0} ميل لكل غالون,{0} ميل لكل غالون
        mile-per-gallon-imperial,ميل/غ. إمبراطوري,,{0} ميل/غ. إمبراطوري,{0} ميل/غ. إمبراطوري,ميل/غ. إمبراطوري,,{0} ميل/غ. إمبراطوري,{0} ميل/غ. إمبراطوري,ميل لكل غالون إمبراطوري,,{0} ميل لكل غالون إمبراطوري,{0} ميل لكل غالون إمبراطوري
        bit,بت,,{0} بت,{0} بت,بت,,{0} بت,{0} بت,بت,,{0} بت,{0} بت
        byte,ب,,{0} ب,{0} ب,بايت,,{0} بايت,{0} بايت,بايت,,{0} بايت,{0} بايت
        gigabit,غ.بت,,{0} غ.بت,{0} غ.بت,غيغابت,,{0} غيغابت,{0} غيغابت,غيغابت,,{0} غيغابت,{0} غيغابت
        gigabyte,غ.ب,,{0} غ.ب,{0} غ.ب,غ.ب,,{0} غ.ب,{0} غ.ب,غيغابايت,,{0} غيغابايت,{0} غيغابايت
        kilobit,ك.بت,,{0} ك.بت,{0} ك.بت,كيلوبت,,{0} كيلوبت,{0} كيلوبت,كيلوبت,,{0} كيلوبت,{0} كيلوبت
        kilobyte,ك.ب,,{0} ك.ب,{0} ك.ب,كيلوبايت,,{0} كيلوبايت,{0} كيلوبايت,كيلوبايت,,{0} كيلوبايت,{0} كيلوبايت
        megabit,م.بت,,{0} م.بت,{0} م.بت,ميغابت,,{0} ميغابت,{0} ميغابت,ميغابت,,{0} ميغابت,{0} ميغابت
        megabyte,م.ب,,{0} م.ب,{0} م.ب,ميغابايت,,{0} م.ب,{0} م.ب,ميغابايت,,{0} ميغابايت,{0} ميغابايت
        petabyte,بيتابايت,,{0} بيتابايت,{0} بيتابايت,بيتابايت,,{0} بيتابايت,{0} بيتابايت,بيتابايت,,{0} بيتابايت,{0} بيتابايت
        terabit,ت.بت,,{0} ت.بت,{0} ت.بت,تيرابت,,{0} تيرابت,{0} تيرابت,تيرابت,,{0} تيرابت,{0} تيرابت
        terabyte,ت.ب,,{0} ت.ب,{0} ت.ب,تيرابايت,,{0} تيرابايت,{0} تيرابايت,تيرابايت,,{0} تيرابايت,{0} تيرابايت
        century,قرن,,قرن,{0} قرن,قرن,,قرن,{0} قرن,قرون,,قرن,{0} قرن
        day,يوم,{0}/ي,{0} ي,{0} ي,أيام,{0}/ي,يوم,{0} يوم,أيام,{0} في اليوم,يوم,{0} يوم
        decade,عقد,,عقد,{0} عقد,عقد,,عقد,{0} عقد,عقود,,عقد,{0} عقد
        hour,ساعة,{0}/س,{0} س,{0} س,ساعة,{0}/س,{0} س,{0} س,ساعات,{0} في الساعة,ساعة,{0} ساعة
        microsecond,م.ث.,,{0} م.ث.,{0} م.ث.,م.ث.,,{0} م.ث.,{0} م.ث.,ميكروثانية,,{0} ميكروثانية,{0} ميكروثانية
        millisecond,ملي ث.,,{0} ملي ث,{0} ملي ث,ملي ثانية,,{0} ملي ث,{0} ملي ث,ملي ثانية,,{0} ملي ثانية,{0} ملي ثانية
        minute,د,{0}/د,{0} د,{0} د,د,{0}/د,{0} د,{0} د,دقيقة,{0} كل دقيقة,دقيقة,{0} دقيقة
        month,شهر,{0}/ش,شهر,{0} شهر,شهور,{0}/ش,شهر,{0} شهر,شهور,{0} في الشهر,شهر,{0} شهر
        nanosecond,ن.ث.,,{0} ن.ث.,{0} ن.ث.,ن.ث.,,{0} ن.ث.,{0} ن.ث.,نانو ثانية,,{0} نانو ثانية,{0} نانو ثانية
        night,ليلة,{0}/ل,{0} ل,{0} ل,ليلة,{0}/ل,ليلة,{0} ليلة,ليالي,{0} في الليلة,ليلة,{0} ليلة
        quarter,ربع,{0}/ر,ربع,{0} ربع,ربع سنوي,{0}/ربع سنوي,ربع,{0} ربع,أرباع,{0} في الربع السنوي,ربع سنوي,{0} ربع سنوي
        second,ث,{0}/ث,{0} ث,{0} ث,ثانية,{0}/ث,{0} ث,{0} ث,ثانية,{0} في الثانية,ثانية,{0} ثانية
        week,أسبوع,{0}/أ,{0} أ,{0} أ,أسبوع,{0}/أ,أسبوع,{0} أسبوع,أسابيع,{0} في الأسبوع,أسبوع,{0} أسبوع
        year,سنة,{0}/سنة,{0} سنة,{0} سنة,سنة,{0}/سنة,سنة واحدة,{0} سنة,سنوات,{0} في السنة,سنة,{0} سنة
        ampere,أمبير,,{0} أمبير,{0} أمبير,أمبير,,{0} أمبير,{0} أمبير,أمبير,,{0} أمبير,{0} أمبير
        milliampere,م أمبير,,{0} م أمبير,{0} م أمبير,م أمبير,,{0} م أمبير,{0} م أمبير,ملي أمبير,,{0} ملي أمبير,{0} ملي أمبير
        ohm,أوم,,{0} أوم,{0} أوم,أوم,,{0} أوم,{0} أوم,أوم,,{0} أوم,{0} أوم
        volt,فولت,,{0} فولت,{0} فولت,فولت,,{0} فولت,{0} فولت,فولت,,{0} فولت,{0} فولت
        british-thermal-unit,وحدة حرارية بريطانية,,{0} وحدة حرارية بريطانية,{0} وحدة حرارية بريطانية,وحدة حرارية بريطانية,,{0} وحدة حرارية بريطانية,{0} وحدة حرارية بريطانية,وحدة حرارية بريطانية,,{0} وحدة حرارية بريطانية,{0} وحدة حرارية بريطانية
        calorie,سع,,{0} سع,{0} سع,سع,,{0} سع,{0} سع,سعرة,,{0} سعرة,{0} سعرة
        electronvolt,إلكترون فولت,,{0} إلكترون فولت,{0} إلكترون فولت,إلكترون فولت,,{0} إلكترون فولت,{0} إلكترون فولت,إلكترون فولت,,{0} إلكترون فولت,{0} إلكترون فولت
        foodcalorie,سع,,{0} سع,{0} سع,سع,,{0} سع,{0} سع,سعرة,,{0} سعرة,{0} سعرة
        joule,جول,,{0} جول,{0} جول,جول,,{0} جول,{0} جول,جول,,{0} جول,{0} جول
        kilocalorie,ك سع,,{0} ك سع,{0} ك سع,ك سعرة,,{0} ك سعرة,{0} ك سعرة,كيلو سعرة,,{0} كيلو سعرة,{0} كيلو سعرة
        kilojoule,ك جول,,{0} ك جول,{0} ك جول,ك جول,,{0} ك جول,{0} ك جول,كيلو جول,,{0} كيلو جول,{0} كيلو جول
        kilowatt-hour,ك.و.س,,{0} ك.و.س,{0} ك.و.س,ك.و.س,,{0} ك.و.س,{0} ك.و.س,كيلو واط/ساعة,,{0} كيلو واط/ساعة,{0} كيلو واط/ساعة
        therm-us,وحدة حرارية أمريكية,,{0} وحدة حرارية أمريكية,{0} وحدة حرارية أمريكية,وحدة حرارية أمريكية,,{0} وحدة حرارية أمريكية,{0} وحدة حرارية أمريكية,وحدة حرارية أمريكية,,{0} وحدة حرارية أمريكية,{0} وحدة حرارية أمريكية
        kilowatt-hour-per-100-kilometer,ك.و.س/100 كم,,{0} ك.و.س/100 كم,{0} ك.و.س/100 كم,ك.و.س لكل 100 كم,,{0} ك.و.س لكل 100 كم,{0} ك.و.س لكل 100 كم,كيلوواط ساعة لكل 100 كيلومتر,,{0} كيلوواط ساعة لكل 100 كيلومتر,{0} كيلوواط ساعة لكل 100 كيلومتر
        newton,نيوتن,,{0} نيوتن,{0} نيوتن,نيوتن,,{0} نيوتن,{0} نيوتن,نيوتن,,{0} نيوتن,{0} نيوتن
        pound-force,باوند قوة,,{0} باوند قوة,{0} باوند قوة,باوند قوة,,{0} باوند قوة,{0} باوند قوة,باوند قوة,,{0} باوند قوة,{0} باوند قوة
        gigahertz,غ هرتز,,{0} غ هرتز,{0} غ هرتز,غ هرتز,,{0} غ هرتز,{0} غ هرتز,غيغا هرتز,,{0} غيغا هرتز,{0} غيغا هرتز
        hertz,هرتز,,{0} هرتز,{0} هرتز,هرتز,,{0} هرتز,{0} هرتز,هرتز,,{0} هرتز,{0} هرتز
        kilohertz,ك هرتز,,{0} ك هرتز,{0} ك هرتز,ك هرتز,,{0} ك هرتز,{0} ك هرتز,كيلو هرتز,,{0} كيلو هرتز,{0} كيلو هرتز
        megahertz,م هرتز,,{0} م هرتز,{0} م هرتز,م هرتز,,{0} م هرتز,{0} م هرتز,ميغا هرتز,,{0} ميغا هرتز,{0} ميغا هرتز
        dot-per-centimeter,ن/سم,,{0} ن/سم,{0} ن/سم,نقطة/سم,,{0} نقطة/سم,{0} نقطة/سم,نقطة لكل سنتيمتر,,{0} نقطة لكل سنتيمتر,{0} نقطة لكل سنتيمتر
        dot-per-inch,ن/بوصة,,{0} ن/بوصة,{0} ن/بوصة,نقطة/بوصة,,{0} نقطة/بوصة,{0} نقطة/بوصة,نقطة/بوصة,,{0} نقطة لكل بوصة,{0} نقطة لكل بوصة
        em,إم,,{0} إم,{0} إم,إم,,{0} إم,{0} إم,إم مطبعي,,{0} إم,{0} إم
        megapixel,م.بكسل,,{0} م.بك,{0} م.بك,م.بكسل,,{0} م.بكسل,{0} م.بكسل,ميغابكسل,,{0} ميغابكسل,{0} ميغابكسل
        pixel,بكسل,,{0} بكسل,{0} بكسل,بكسل,,{0} بكسل,{0} بكسل,بكسل,,{0} بكسل,{0} بكسل
        pixel-per-centimeter,بكسل/سم,,{0} بك/سم,{0} بك/سم,بكسل لكل سنتيمتر,,{0} بكسل/سم,{0} بكسل/سم,بكسل لكل سنتيمتر,,{0} بكسل لكل سنتيمتر,{0} بكسل لكل سنتيمتر
        pixel-per-inch,بكسل/بوصة,,{0} بك/بوصة,{0} بك/بوصة,بكسل لكل بوصة,,{0} بكسل/بوصة,{0} بكسل/بوصة,بكسل لكل بوصة,,{0} بكسل لكل بوصة,{0} بكسل لكل بوصة
        astronomical-unit,و.ف.,,{0} و.ف.,{0} و.ف.,و.ف.,,{0} و.ف.,{0} و.ف.,وحدة فلكية,,وحدة فلكية,{0} وحدة فلكية
        centimeter,سم,{0}/سم,{0} سم,{0} سم,سم,{0}/سم,{0} سم,{0} سم,سنتيمتر,{0}/سنتيمتر,{0} سنتيمتر,{0} سنتيمتر
        decimeter,دسم,,{0} دسم,{0} دسم,دسم,,{0} دسم,{0} دسم,ديسيمتر,,{0} ديسيمتر,{0} ديسيمتر
        earth-radius,نق أرضي,,{0} نق أرضي,{0} نق أرضي,نق أرضي,,{0} نق أرضي,{0} نق أرضي,نصف قطر أرضي,,{0} نصف قطر أرضي,{0} نصف قطر أرضي
        fathom,قامة,,{0} قامة,{0} قامة,قامة,,{0} قامة,{0} قامة,قامة,,{0} قامة,{0} قامة
        foot,قدم,{0}/قدم,قدم,{0} قدم,قدم,{0}/قدم,قدم,{0} قدم,قدم,{0} لكل قدم,قدم,{0} قدم
        furlong,فرلنغ,,{0} فرلنغ,{0} فرلنغ,فرلنغ,,{0} فرلنغ,{0} فرلنغ,فرلنغ,,{0} فرلنغ,{0} فرلنغ
        inch,بوصة,{0}/بوصة,{0} بوصة,{0} بوصة,بوصة,{0}/بوصة,{0} بوصة,{0} بوصة,بوصة,{0}/بوصة,{0} بوصة,{0} بوصة
        kilometer,كم,{0}/كم,{0} كم,{0} كم,كم,{0}/كم,{0} كم,{0} كم,كيلومتر,{0}/كيلومتر,{0} كيلومتر,{0} كيلومتر
        light-year,سنة ضوئية,,{0} س ض,{0} س ض,سنة ضوئية,,سنة ضوئية,{0} سنة ضوئية,سنة ضوئية,,سنة ضوئية,{0} سنة ضوئية
        meter,م,{0}/م,{0} م,{0} م,م,{0}/م,متر,{0} متر,متر,{0} لكل متر,متر,{0} متر
        micrometer,ميكرومتر,,{0} ميكرومتر,{0} ميكرومتر,ميكرومتر,,{0} ميكرومتر,{0} ميكرومتر,ميكرومتر,,{0} ميكرومتر,{0} ميكرومتر
        mile,ميل,,{0} ميل,{0} ميل,ميل,,ميل,{0} ميل,ميل,,ميل,{0} ميل
        mile-scandinavian,ميل اسكندنافي,,{0} ميل اسكندنافي,{0} ميل اسكندنافي,ميل اسكندنافي,,{0} ميل اسكندنافي,{0} ميل اسكندنافي,ميل اسكندنافي,,{0} ميل اسكندنافي,{0} ميل اسكندنافي
        millimeter,مم,,{0} مم,{0} مم,مليمتر,,{0} مم,{0} مم,مليمتر,,{0} مليمتر,{0} مليمتر
        nanometer,نانو متر,,{0} نانو متر,{0} نانو متر,نانو متر,,{0} نانو متر,{0} نانو متر,نانو متر,,{0} نانو متر,{0} نانو متر
        nautical-mile,ميل بحري,,ميل بحري,{0} ميل بحري,ميل بحري,,ميل بحري,{0} ميل بحري,ميل بحري,,ميل بحري,{0} ميل بحري
        parsec,فرسخ فلكي,,فرسخ فلكي,{0} فرسخ فلكي,فرسخ فلكي,,فرسخ فلكي,{0} فرسخ فلكي,فرسخ فلكي,,فرسخ فلكي,{0} فرسخ فلكي
        picometer,بيكومتر,,{0} بيكومتر,{0} بيكومتر,بيكومتر,,{0} بيكومتر,{0} بيكومتر,بيكومتر,,{0} بيكومتر,{0} بيكومتر
        point,نقطة,,نقطة,{0} نقطة,نقطة,,نقطة,{0} نقطة,نقطة,,نقطة,{0} نقطة
        solar-radius,نق شمسي,,{0} نق شمسي,{0} نق شمسي,نق شمسي,,{0} نق شمسي,{0} نق شمسي,نصف قطر شمسي,,{0} نصف قطر شمسي,{0} نصف قطر شمسي
        yard,ياردة,,{0} ياردة,{0} ياردة,ياردة,,ياردة,{0} ياردة,ياردة,,ياردة,{0} ياردة
        candela,شمعة,,{0} شمعة,{0} شمعة,شمعة,,{0} شمعة,{0} شمعة,شمعة,,{0} شمعة,{0} شمعة
        lumen,لومن,,{0} لومن,{0} لومن,لومن,,{0} لومن,{0} لومن,لومن,,{0} لومن,{0} لومن
        lux,لكس,,{0} لكس,{0} لكس,لكس,,{0} لكس,{0} لكس,لكس,,{0} لكس,{0} لكس
        solar-luminosity,ضياء شمسي,,{0} ضياء شمسي,{0} ضياء شمسي,ضياء شمسي,,{0} ضياء شمسي,{0} ضياء شمسي,ضياء شمسي,,{0} ضياء شمسي,{0} ضياء شمسي
        carat,قيراط,,{0} قيراط,{0} قيراط,قيراط,,{0} قيراط,{0} قيراط,قيراط,,قيراط,{0} قيراط
        dalton,دالتون,,{0} دالتون,{0} دالتون,دالتون,,{0} دالتون,{0} دالتون,دالتون,,{0} دالتون,{0} دالتون
        earth-mass,كتلة أرضية,,{0} كتلة أرضية,{0} كتلة أرضية,كتلة أرضية,,{0} كتلة أرضية,{0} كتلة أرضية,كتلة أرضية,,{0} كتلة أرضية,{0} كتلة أرضية
        grain,قمحة,,{0} قمحة,{0} قمحة,قمحة,,{0} قمحة,{0} قمحة,قمحة,,{0} قمحة,{0} قمحة
        gram,غ,{0} غ,{0} غ,{0} غ,غرام,{0}/غرام,غرام,{0} غرام,غرام,{0}/غرام,غرام,{0} غرام
        kilogram,كغ,{0}/كغ,{0} كغ,{0} كغ,كغم,{0}/كغم,{0} كغم,{0} كغم,كيلوغرام,{0}/كيلوغرام,{0} كيلوغرام,{0} كيلوغرام
        microgram,مكغم,,{0} مكغم,{0} مكغم,مكغم,,{0} مكغم,{0} مكغم,ميكروغرام,,{0} ميكروغرام,{0} ميكروغرام
        milligram,مغم,,{0} مغم,{0} مغم,مغم,,{0} مغم,{0} مغم,مليغرام,,{0} مليغرام,{0} مليغرام
        ounce,أونصة,{0}/أونصة,أونصة,{0} أونصة,أونصة,{0}/أونصة,أونصة,{0} أونصة,أونصة,{0}/أونصة,{0} أونصة,{0} أونصة
        ounce-troy,أونصة ترويسية,,{0} أونصة ترويسية,{0} أونصة ترويسية,أونصة ترويسية,,{0} أونصة ترويسية,{0} أونصة ترويسية,أونصة ترويسية,,{0} أونصة ترويسية,{0} أونصة ترويسية
        pound,رطل,{0}/رطل,{0} رطل,{0} رطل,رطل,{0}/رطل,{0} رطل,{0} رطل,رطل,{0}/رطل,{0} رطل,{0} رطل
        solar-mass,كتلة شمسية,,{0} كتلة شمسية,{0} كتلة شمسية,كتلة شمسية,,{0} كتلة شمسية,{0} كتلة شمسية,كتلة شمسية,,{0} كتلة شمسية,{0} كتلة شمسية
        stone,ستون,,{0} ستون,{0} ستون,ستون,,{0} ستون,{0} ستون,ستون,,{0} ستون,{0} ستون
        ton,طن,,{0} طن,{0} طن,طن,,{0} طن,{0} طن,طن,,{0} طن,{0} طن
        tonne,ط.م,,{0} ط.م,{0} ط.م,ط.م,,{0} ط.م,{0} ط.م,طن متري,,{0} طن متري,{0} طن متري
        gigawatt,غ واط,,{0} غ واط,{0} غ واط,غ واط,,{0} غ واط,{0} غ واط,غيغا واط,,{0} غيغا واط,{0} غيغا واط
        horsepower,حصان,,{0} حصان,{0} حصان,حصان,,{0} حصان,{0} حصان,قوة حصان,,{0} قوة حصان,{0} قوة حصان
        kilowatt,ك واط,,{0} ك واط,{0} ك واط,ك واط,,{0} كيلوواط,{0} كيلوواط,كيلوواط,,{0} كيلوواط,{0} كيلوواط
        megawatt,م واط,,{0} م واط,{0} م واط,م واط,,{0} م واط,{0} م واط,ميغا واط,,{0} ميغا واط,{0} ميغا واط
        milliwatt,ملي واط,,{0} ملي واط,{0} ملي واط,ملي واط,,{0} ملي واط,{0} ملي واط,ملي واط,,{0} ملي واط,{0} ملي واط
        watt,واط,,{0} واط,{0} واط,واط,,{0} واط,{0} واط,واط,,{0} واط,{0} واط
        atmosphere,ض.ج,,{0} ض.ج,{0} ض.ج,ض.ج,,{0} ض.ج,{0} ض.ج,وحدة الضغط الجوي,,{0} ضغط جوي,{0} ضغط جوي
        bar,بار,,{0} بار,{0} بار,بار,,{0} بار,{0} بار,بار,,{0} بار,{0} بار
        hectopascal,هكتوباسكال,,{0} هكتوباسكال,{0} هكتوباسكال,هكتوباسكال,,{0} هكتوباسكال,{0} هكتوباسكال,هكتوباسكال,,{0} هكتوباسكال,{0} هكتوباسكال
        inch-ofhg,ب ز,,{0} ب ز,{0} ب ز,ب. زئبقية,,{0} ب. زئبقية,{0} ب. زئبقية,بوصة زئبقية,,{0} بوصة زئبقية,{0} بوصة زئبقية
        kilopascal,ك.باسكال,,{0} ك.باسكال,{0} ك.باسكال,ك.باسكال,,{0} ك.باسكال,{0} ك.باسكال,كيلوباسكال,,{0} كيلوباسكال,{0} كيلوباسكال
        megapascal,م.باسكال,,{0} م.باسكال,{0} م.باسكال,م.باسكال,,{0} م.باسكال,{0} م.باسكال,ميغاباسكال,,{0} ميغاباسكال,{0} ميغاباسكال
        millibar,م. بار,,{0} م. بار,{0} م. بار,م. بار,,{0} م. بار,{0} م. بار,ملي بار,,{0} ملي بار,{0} ملي بار
        millimeter-ofhg,ملم زئبقي,,{0} ملم زئبقي,{0} ملم زئبقي,ملم زئبقي,,{0} ملم زئبقي,{0} ملم زئبقي,مليمتر زئبقي,,{0} مليمتر زئبقي,{0} مليمتر زئبقي
        pascal,باسكال,,{0} باسكال,{0} باسكال,باسكال,,{0} باسكال,{0} باسكال,باسكال,,{0} باسكال,{0} باسكال
        pound-force-per-square-inch,رطل/بوصة²,,{0} رطل/بوصة²,{0} رطل/بوصة²,رطل/بوصة مربعة,,{0} رطل/بوصة²,{0} رطل/بوصة²,رطل لكل بوصة مربعة,,{0} رطل لكل بوصة مربعة,{0} رطل لكل بوصة مربعة
        beaufort,بوفورت,,بوفورت {0},بوفورت {0},بوفورت,,بوفورت {0},بوفورت {0},بوفورت,,بوفورت {0},بوفورت {0}
        kilometer-per-hour,كم/س,,{0} كم/س,{0} كم/س,كم/س,,{0} كم/س,{0} كم/س,كيلومتر في الساعة,,{0} كيلومتر في الساعة,{0} كيلومتر في الساعة
        knot,عقدة,,{0} عقدة,{0} عقدة,عقدة,,{0} عقدة,{0} عقدة,عقدة,,{0} عقدة,{0} عقدة
        meter-per-second,م/ث,,{0} م/ث,{0} م/ث,م/ث,,{0} م/ث,{0} م/ث,متر في الثانية,,{0} متر في الثانية,{0} متر في الثانية
        mile-per-hour,ميل/س,,{0} ميل/س,{0} ميل/س,ميل/س,,{0} ميل/س,{0} ميل/س,ميل في الساعة,,{0} ميل في الساعة,{0} ميل في الساعة
        celsius,°م,,{0}°م,{0}°م,درجة مئوية,,{0}°م,{0}°م,درجة مئوية,,{0} درجة مئوية,{0} درجة مئوية
        fahrenheit,°ف,,{0}°ف,{0}°ف,درجة فهرنهايت,,{0}°ف,{0}°ف,درجة فهرنهايت,,{0} درجة فهرنهايت,{0} درجة فهرنهايت
        kelvin,د كلفن,,{0} د كلفن,{0} د كلفن,د كلفن,,{0} د كلفن,{0} د كلفن,درجة كلفن,,{0} درجة كلفن,{0} درجة كلفن
        newton-meter,نيوتن م,,{0} نيوتن م,{0} نيوتن م,نيوتن متر,,{0} نيوتن متر,{0} نيوتن متر,نيوتن متر,,{0} نيوتن متر,{0} نيوتن متر
        pound-force-foot,باوند قدم,,{0} باوند قدم,{0} باوند قدم,باوند قدم,,{0} باوند قدم,{0} باوند قدم,باوند قدم,,{0} باوند قدم,{0} باوند قدم
        acre-foot,فدان قدم,,{0} فدان قدم,{0} فدان قدم,فدان قدم,,{0} فدان قدم,{0} فدان قدم,فدان قدم,,{0} فدان قدم,{0} فدان قدم
        barrel,برميل,,برميل,{0} برميل,برميل,,برميل,{0} برميل,برميل,,برميل,{0} برميل
        bushel,بوشل,,{0} بوشل,{0} بوشل,بوشل,,{0} بوشل,{0} بوشل,بوشل,,{0} بوشل,{0} بوشل
        centiliter,سنتيلتر,,{0} سنتيلتر,{0} سنتيلتر,سنتيلتر,,{0} سنتيلتر,{0} سنتيلتر,سنتيلتر,,{0} سنتيلتر,{0} سنتيلتر
        cubic-centimeter,سم³,{0}/سم³,{0} سم³,{0} سم³,سم³,{0}/سم³,{0} سم³,{0} سم³,سنتيمتر مكعب,{0}/سنتيمتر مكعب,{0} سنتيمتر مكعب,{0} سنتيمتر مكعب
        cubic-foot,قدم³,,{0} قدم³,{0} قدم³,قدم³,,{0} قدم³,{0} قدم³,قدم مكعبة,,قدم مكعبة,{0} قدم مكعبة
        cubic-inch,بوصة³,,{0} بوصة³,{0} بوصة³,بوصة مكعبة,,{0} بوصة مكعبة,{0} بوصة مكعبة,بوصة مكعبة,,{0} بوصة مكعبة,{0} بوصة مكعبة
        cubic-kilometer,كم³,,{0} كم³,{0} كم³,كم³,,{0} كم³,{0} كم³,كيلومتر مكعب,,{0} كيلومتر مكعب,{0} كيلومتر مكعب
        cubic-meter,م³,{0}/م³,{0} م³,{0} م³,م³,{0}/م³,{0} م³,{0} م³,متر مكعب,{0}/متر مكعب,{0} متر مكعب,{0} متر مكعب
        cubic-mile,ميل³,,{0} ميل³,{0} ميل³,ميل³,,{0} ميل³,{0} ميل³,ميل مكعب,,{0} ميل مكعب,{0} ميل مكعب
        cubic-yard,ياردة³,,{0} ياردة³,{0} ياردة³,ياردة³,,{0} ياردة³,{0} ياردة³,ياردة مكعبة,,{0} ياردة مكعبة,{0} ياردة مكعبة
        cup,كوب,,كوب,{0} كوب,كوب,,كوب,{0} كوب,كوب,,كوب,{0} كوب
        cup-metric,كوب متري,,{0} كوب متري,{0} كوب متري,كوب متري,,{0} كوب متري,{0} كوب متري,كوب متري,,{0} كوب متري,{0} كوب متري
        deciliter,ديسيلتر,,{0} ديسيلتر,{0} ديسيلتر,ديسيلتر,,{0} ديسيلتر,{0} ديسيلتر,ديسيلتر,,{0} ديسيلتر,{0} ديسيلتر
        dessert-spoon,ملعقة ح.,,{0} ملعقة ح.,{0} ملعقة ح.,ملعقة ح.,,{0} ملعقة ح.,{0} ملعقة ح.,ملعقة حلو,,{0} ملعقة حلو,{0} ملعقة حلو
        dessert-spoon-imperial,ملعقة حلو إمبراطوري,,{0} ملعقة ح. إمبراطوري,{0} ملعقة ح. إمبراطوري,ملعقة حلو إمبراطوري,,{0} ملعقة ح. إمبراطوري,{0} ملعقة ح. إمبراطوري,ملعقة حلو إمبراطوري,,{0} ملعقة حلو إمبراطوري,{0} ملعقة حلو إمبراطوري
        dram,درهم سائل,,{0} درهم سائل,{0} درهم سائل,درهم سائل,,{0} درهم سائل,{0} درهم سائل,درهم سائل,,{0} درهم,{0} درهم
        drop,قطرة,,{0} قطرة,{0} قطرة,قطرة,,{0} قطرة,{0} قطرة,قطرة,,{0} قطرة,{0} قطرة
        fluid-ounce,أونصة س,,أونصة س,{0} أونصة س,أونصة سائلة,,أونصة س,{0} أونصة سائلة,أونصة سائلة,,أونصة سائلة,{0} أونصة سائلة
        fluid-ounce-imperial,أونصة س إمبراطورية,,أونصة س إمبراطورية,{0} أونصة س إمبراطورية,أونصة سائلة إمبراطورية,,أونصة سائلة إمبراطورية,{0} أونصة سائلة إمبراطورية,أونصة سائلة إمبراطورية,,{0} أونصة سائلة إمبراطورية,{0} أونصة سائلة إمبراطورية
        gallon,غالون,{0}/غالون,غالون,{0} غالون,غالون,{0}/غالون,غالون,{0} غالون,غالون,{0} لكل غالون,غالون,{0} غالون
        gallon-imperial,غالون إمبراطوري,{0}/غالون إمبراطوري,{0} غالون إمبراطوري,{0} غالون إمبراطوري,غالون إمبراطوري,{0}/غالون إمبراطوري,{0} غالون إمبراطوري,{0} غالون إمبراطوري,غالون إمبراطوري,{0} لكل غالون إمبراطوري,غالون إمبراطوري,{0} غالون إمبراطوري
        hectoliter,هكتولتر,,{0} هكتولتر,{0} هكتولتر,هكتولتر,,{0} هكتولتر,{0} هكتولتر,هكتولتر,,{0} هكتولتر,{0} هكتولتر
        jigger,قدح,,قدح,{0} قدح,قدح,,{0} قدح,{0} قدح,قدح,,{0} قدح,{0} قدح
        liter,لتر,{0}/ل,{0} ل,{0} ل,لتر,{0}/ل,لتر,{0} لتر,لتر,{0} لكل لتر,لتر,{0} لتر
        megaliter,ميغالتر,,{0} ميغالتر,{0} ميغالتر,ميغالتر,,{0} ميغالتر,{0} ميغالتر,ميغالتر,,{0} ميغالتر,{0} ميغالتر
        milliliter,ملتر,,{0} ملتر,{0} ملتر,ملتر,,{0} ملتر,{0} ملتر,مليلتر,,{0} مليلتر,{0} مليلتر
        pinch,رشّة,,{0} رشّة,{0} رشّة,رشّة,,{0} رشّة,{0} رشّة,رشّة,,{0} رشّة,{0} رشّة
        pint,باينت,,{0} باينت,{0} باينت,باينت,,{0} باينت,{0} باينت,باينت,,{0} باينت,{0} باينت
        pint-metric,مكيال متري,,{0} مكيال متري,{0} مكيال متري,مكيال متري,,{0} مكيال متري,{0} مكيال متري,مكيال متري,,{0} مكيال متري,{0} مكيال متري
        quart,ربع غالون,,ربع غالون,{0} ربع غالون,ربع غالون,,ربع غالون,{0} ربع غالون,ربع غالون,,ربع غالون,{0} ربع غالون
        quart-imperial,ربع غالون إمبراطوري,,{0} ربع غالون إمبراطوري,{0} ربع غالون إمبراطوري,ربع غالون إمبراطوري,,{0} ربع غالون إمبراطوري,{0} ربع غالون إمبراطوري,ربع غالون إمبراطوري,,{0} ربع غالون إمبراطوري,{0} ربع غالون إمبراطوري
        tablespoon,ملعقة ك,,ملعقة ك,{0} ملعقة ك,ملعقة كبيرة,,ملعقة ك.,{0} ملعقة ك.,ملعقة كبيرة,,ملعقة كبيرة,{0} ملعقة كبيرة
        teaspoon,ملعقة ص,,ملعقة ص,{0} ملعقة ص,ملعقة ص,,ملعقة ص,{0} ملعقة ص,ملعقة صغيرة,,ملعقة صغيرة,{0} ملعقة صغيرة
        permyriad,؊,,{0} ؊,{0} ؊,,,,,,,,
        """.trimIndent()
  }

  private val ar_Prefixes: String by lazy {
    """square,,,{0} مربّع
        cubic,,,{0} مكعّب
        per,,,{0} لكل {1}
        1024p1,كيبي.{0},كيبي.{0},كيبي{0}
        1024p2,ميبي.{0},ميبي.{0},ميبي{0}
        1024p3,غيبي.{0},غيبي.{0},غيبي{0}
        1024p4,تيبي.{0},تيبي.{0},تيبي{0}
        1024p5,بيبي.{0},بيبي.{0},بيبي{0}
        1024p6,إكسبي.{0},إكسبي.{0},إكسبي{0}
        1024p7,زيبي.{0},زيبي.{0},زيبي{0}
        1024p8,يوبي.{0},يوبي.{0},يوبي{0}
        10p-1,د{0},د{0},ديسي{0}
        10p-12,ب{0},ب{0},بيكو{0}
        10p-15,ف{0},ف{0},فيمتو{0}
        10p-18,أ{0},أ{0},أتو{0}
        10p-2,س{0},س{0},سنتي{0}
        10p-21,زيب{0},زيب{0},زيبتو{0}
        10p-24,يك{0},يك{0},يوكتو{0}
        10p-27,ر{0},رونتو{0},رونتو{0}
        10p-3,م{0},م{0},ملّي{0}
        10p-30,كويكتو.{0},كويكتو{0},كويكتو{0}
        10p-6,مك{0},مك{0},ميكرو{0}
        10p-9,ن{0},ن{0},نانو{0}
        10p1,دا{0},دا{0},ديكا{0}
        10p12,ت{0},ت{0},تيرا{0}
        10p15,بتا{0},بتا{0},بيتا{0}
        10p18,إ.{0},إ.{0},إكسا{0}
        10p2,ه{0},ه{0},هكتو{0}
        10p21,زت{0},زت{0},زيتا{0}
        10p24,ي{0},ي{0},يوتا{0}
        10p27,رونا.{0},رونا{0},رونا{0}
        10p3,ك{0},كيلو{0},كيلو{0}
        10p30,كويتا.{0},كويتا.{0},كويتا{0}
        10p6,مغ{0},مغ{0},ميغا{0}
        10p9,غ{0},غ{0},غيغا{0}
        """.trimIndent()
  }

  private val ar_AE_Units: String? = null

  private val ar_AE_Prefixes: String? = null

  private val ar_BH_Units: String? = null

  private val ar_BH_Prefixes: String? = null

  private val ar_DJ_Units: String? = null

  private val ar_DJ_Prefixes: String? = null

  private val ar_DZ_Units: String? = null

  private val ar_DZ_Prefixes: String? = null

  private val ar_EG_Units: String? = null

  private val ar_EG_Prefixes: String? = null

  private val ar_EH_Units: String? = null

  private val ar_EH_Prefixes: String? = null

  private val ar_ER_Units: String? = null

  private val ar_ER_Prefixes: String? = null

  private val ar_IL_Units: String? = null

  private val ar_IL_Prefixes: String? = null

  private val ar_IQ_Units: String? = null

  private val ar_IQ_Prefixes: String? = null

  private val ar_JO_Units: String? = null

  private val ar_JO_Prefixes: String? = null

  private val ar_KM_Units: String? = null

  private val ar_KM_Prefixes: String? = null

  private val ar_KW_Units: String? = null

  private val ar_KW_Prefixes: String? = null

  private val ar_LB_Units: String? = null

  private val ar_LB_Prefixes: String? = null

  private val ar_LY_Units: String? = null

  private val ar_LY_Prefixes: String? = null

  private val ar_MA_Units: String? = null

  private val ar_MA_Prefixes: String? = null

  private val ar_MR_Units: String? = null

  private val ar_MR_Prefixes: String? = null

  private val ar_OM_Units: String? = null

  private val ar_OM_Prefixes: String? = null

  private val ar_PS_Units: String? = null

  private val ar_PS_Prefixes: String? = null

  private val ar_QA_Units: String? = null

  private val ar_QA_Prefixes: String? = null

  private val ar_SA_Units: String by lazy {
    """cubic-inch,,,,,بوصة مكعبة,,{0} بوصة³,{0} بوصة³,بوصة مكعبة,,{0} بوصة³,{0} بوصة³
        year,سنوات,{0}/سنة,سنة,{0} سنة,سنوات,{0}/سنة,سنة,{0} سنة,,,,
        kilopascal,كيلوباسكال,,{0} كيلوباسكال,{0} كيلوباسكال,كيلوباسكال,,{0} كيلوباسكال,{0} كيلوباسكال,,,,
        megapascal,ميغاباسكال,,{0} ميغاباسكال,{0} ميغاباسكال,ميغاباسكال,,{0} ميغاباسكال,{0} ميغاباسكال,,,,
        kelvin,درجة كلفن,,{0} درجة كلفن,{0} درجة كلفن,درجة كلفن,,{0} درجة كلفن,{0} درجة كلفن,,,,
        meter,متر,{0}/م,{0} م,{0} م,,,,,,,,
        gram,غم,{0} غ,{0} غم,{0} غم,,,,,,,,
        kilogram,كغم,{0}/كغ,{0} كغم,{0} كغم,,,,,,,,
        """.trimIndent()
  }

  private val ar_SA_Prefixes: String? = null

  private val ar_SD_Units: String? = null

  private val ar_SD_Prefixes: String? = null

  private val ar_SO_Units: String? = null

  private val ar_SO_Prefixes: String? = null

  private val ar_SS_Units: String? = null

  private val ar_SS_Prefixes: String? = null

  private val ar_SY_Units: String? = null

  private val ar_SY_Prefixes: String? = null

  private val ar_TD_Units: String? = null

  private val ar_TD_Prefixes: String? = null

  private val ar_TN_Units: String? = null

  private val ar_TN_Prefixes: String? = null

  private val ar_YE_Units: String? = null

  private val ar_YE_Prefixes: String? = null

  private val arn_Units: String? = null

  private val arn_Prefixes: String? = null

  private val as_Units: String by lazy {
    """g-force,জি-বল,,{0} জি,{0} জি,জি-বল,,{0} জি,{0} জি,জি-বল,,{0} জি-বল,{0} জি-বল
        meter-per-square-second,মিটাৰ/বৰ্গ ছেকেণ্ড,,,{0} m/s²,মিটাৰ/বৰ্গ ছেকেণ্ড,,,{0} m/s²,মিটাৰ প্ৰতি বৰ্গ ছেকেণ্ড,,{0} মিটাৰ প্ৰতি বৰ্গ ছেকেণ্ড,{0} মিটাৰ প্ৰতি বৰ্গ ছেকেণ্ড
        arc-minute,আঃ মিঃ,,{0}′,{0}′,আৰ্কমিনিট,,{0} আৰ্কমিনিট,{0} আৰ্কমিনিট,আৰ্কমিনিট,,{0} আৰ্কমিনিট,{0} আৰ্কমিনিট
        arc-second,আৰ্কছেকেণ্ড,,{0}″,{0}″,আৰ্কছেকেণ্ড,,{0} আৰ্কছেকেণ্ড,{0} আৰ্কছেকেণ্ড,আৰ্কছেকেণ্ড,,{0} আৰ্কছেকেণ্ড,{0} আৰ্কছেকেণ্ড
        degree,ডিগ্ৰী,,{0}°,{0}°,ডিগ্ৰী,,{0} ডিগ্ৰী,{0} ডিগ্ৰী,ডিগ্ৰী,,{0} ডিগ্ৰী,{0} ডিগ্ৰী
        radian,ৰেডিয়েন,,{0} ৰেডিয়েন,{0} ৰেডিয়েন,ৰেডিয়েন,,{0} ৰেডিয়েন,{0} ৰেডিয়েন,ৰেডিয়েন,,{0} ৰেডিয়েন,{0} ৰেডিয়েন
        revolution,ঘূৰ্ণন,,{0} ঘূৰ্ণন,{0} ঘূৰ্ণন,ঘূৰ্ণন,,{0} ঘূৰ্ণন,{0} ঘূৰ্ণন,ঘূৰ্ণন,,{0} ঘূৰ্ণন,{0} ঘূৰ্ণন
        acre,একৰ,,{0} একৰ,{0} একৰ,একৰ,,{0} একৰ,{0} একৰ,একৰ,,{0} একৰ,{0} একৰ
        dunam,ডুনাম,,{0} ডুনাম,{0} ডুনাম,ডুনাম,,{0} ডুনাম,{0} ডুনাম,ডুনাম,,{0} ডুনাম,{0} ডুনাম
        hectare,হেক্টৰ,,{0} হেক্টৰ,{0} হেক্টৰ,হেক্টৰ,,{0} হেক্টৰ,{0} হেক্টৰ,হেক্টৰ,,{0} হেক্টৰ,{0} হেক্টৰ
        square-centimeter,,,,,,,,,বৰ্গ ছেণ্টিমিটাৰ,{0} বৰ্গ ছেণ্টিমিটাৰ,{0} বৰ্গ ছেণ্টিমিটাৰ,{0} বৰ্গ ছেণ্টিমিটাৰ
        square-foot,বৰ্গ ফুট,,{0} বৰ্গ ফুট,{0} বৰ্গ ফুট,বৰ্গ ফুট,,{0} বৰ্গ ফুট,{0} বৰ্গ ফুট,বৰ্গ ফুট,,{0} বৰ্গ ফুট,{0} বৰ্গ ফুট
        square-inch,বৰ্গ ইঞ্চি,{0}/in²,,{0} in²,বৰ্গ ইঞ্চি,{0}/in²,,{0} in²,বৰ্গ ইঞ্চি,{0} প্ৰতি বৰ্গ ইঞ্চি,{0} বৰ্গ ইঞ্চি,{0} বৰ্গ ইঞ্চি
        square-kilometer,বৰ্গ কিলোমিটাৰ,{0}/km²,,{0} km²,বৰ্গ কিলোমিটাৰ,{0}/km²,,{0} km²,বৰ্গ কিলোমিটাৰ,{0} প্ৰতি বৰ্গ কিলোমিটাৰ,{0} বৰ্গ কিলোমিটাৰ,{0} বৰ্গ কিলোমিটাৰ
        square-meter,বৰ্গ মিটাৰ,{0}/m²,,{0} m²,বৰ্গ মিটাৰ,{0}/m²,,{0} m²,বৰ্গ মিটাৰ,{0} বৰ্গ মিটাৰ,{0} বৰ্গ মিটাৰ,{0} বৰ্গ মিটাৰ
        square-mile,বৰ্গ মাইল,{0}/mi²,{0} বৰ্গ মাইল,{0} বৰ্গ মাইল,বৰ্গ মাইল,{0}/mi²,{0} বৰ্গ মাইল,{0} বৰ্গ মাইল,বৰ্গ মাইল,{0} প্ৰতি বৰ্গ মাইল,{0} বৰ্গ মাইল,{0} বৰ্গ মাইল
        square-yard,বৰ্গ গজ,,,{0} yd²,বৰ্গ গজ,,,{0} yd²,বৰ্গ গজ,,{0} বৰ্গ গজ,{0} বৰ্গ গজ
        item,আইটেম,,{0} টা আইটেম,{0} টা আইটেম,আইটেম,,{0} টা আইটেম,{0} টা আইটেম,আইটেমসমূহ,,{0} টা আইটেম,{0} টা আইটেম
        karat,কেৰেট,,{0} কেৰেট,{0} কেৰেট,কেৰেট,,{0} কেৰেট,{0} কেৰেট,কেৰেট,,{0} কেৰেট,{0} কেৰেট
        milligram-ofglucose-per-deciliter,মিঃ গ্ৰাঃ/ডেঃ লিঃ,,{0} মিঃ গ্ৰাঃ/ডেঃ লিঃ,{0} মিঃ গ্ৰাঃ/ডেঃ লিঃ,মিঃ গ্ৰাঃ/ডেঃ লিঃ,,{0} মিঃ গ্ৰাঃ/ডেঃ লিঃ,{0} মিঃ গ্ৰাঃ/ডেঃ লিঃ,প্ৰতি ডেচিলিটাৰত মিলিগ্ৰাম,,প্ৰতি ডেচিলিটাৰত {0} মিলিগ্ৰাম,প্ৰতি ডেচিলিটাৰত {0} মিলিগ্ৰাম
        millimole-per-liter,মিলিমোল/লিটাৰ,,{0} মিলিমোল/লিটাৰ,{0} মিলিমোল/লিটাৰ,মিলিমোল/লিটাৰ,,{0} মিলিমোল/লিটাৰ,{0} মিলিমোল/লিটাৰ,প্ৰতি লিটাৰত মিলিমোল,,প্ৰতি লিটাৰত {0} মিলিমোল,প্ৰতি লিটাৰত {0} মিলিমোল
        mole,ম’ল,,{0} ম’ল,{0} ম’ল,ম’ল,,{0} ম’ল,{0} ম’ল,ম’ল,,{0} ম’ল,{0} ম’ল
        percent,,,,,শতাংশ,,,{0}%,%,,{0} শতাংশ,{0} শতাংশ
        permille,,,,,প্ৰতিমাইল,,,{0}‰,প্ৰতিমাইল,,{0} প্ৰতিমাইল,{0} প্ৰতিমাইল
        permillion,ppm,,{0}ppm,{0}ppm,ভাগ/মিলিয়ন,,,{0} ppm,প্ৰতি মিলিয়নত ভাগ,,প্ৰতি মিলিয়নত {0} ভাগ,প্ৰতি মিলিয়নত {0} ভাগ
        permyriad,,,,,পাৰমিৰেইড,,,{0}‱,পাৰমিৰেইড,,{0} পাৰমিৰেইড,{0} পাৰমিৰেইড
        portion-per-1e9,অংশ/বিলিয়ন,,{0}ppb,{0}ppb,অংশ/বিলিয়ন,,,{0} ppb,প্ৰতি বিলিয়নত অংশ,,{0} প্ৰতি বিলিয়নত অংশ,{0} প্ৰতি বিলিয়নত অংশ
        liter-per-100-kilometer,ল/১০০ ক.ম.,,{0} ল/১০০ ক.ম.,{0} ল/১০০ ক.ম.,লিঃ/১০০ কিঃ মিঃ,,{0} ল/১০০ ক.ম.,{0} ল/১০০ ক.ম.,প্ৰতি ১০০ কিলোমিটাৰত লিটাৰ,,প্ৰতি ১০০ কিলোমিটাৰত {0} লিটাৰ,প্ৰতি ১০০ কিলোমিটাৰত {0} লিটাৰ
        liter-per-kilometer,লিটাৰ/কিঃ মিঃ,,{0} লিঃ/কিঃ মিঃ,{0} লিঃ/কিঃ মিঃ,লিটাৰ/কিঃ মিঃ,,{0} লিঃ/কিঃ মিঃ,{0} লিঃ/কিঃ মিঃ,প্ৰতি কিলোমিটাৰত লিটাৰ,,প্ৰতি কিলোমিটাৰত {0} লিটাৰ,প্ৰতি কিলোমিটাৰত {0} লিটাৰ
        mile-per-gallon,মাইল/গেলন,,{0}mpg,{0}mpg,মাইল/গেলন,,{0} mpg,{0} mpg,প্ৰতি গেলনত মাইল,,প্ৰতি গেলনত {0} মাইল,প্ৰতি গেলনত {0} মাইল
        mile-per-gallon-imperial,mpg UK,,{0}m/gUK,{0}m/gUK,miles/gal Imp.,,,{0} mpg Imp.,প্ৰতি ইম্পেৰিয়াল গেলনত মাইল,,প্ৰতি ইম্পেৰিয়াল গেলনত {0} মাইল,প্ৰতি ইম্পেৰিয়াল গেলনত {0} মাইল
        bit,বিট,,{0} বিট,{0} বিট,বিট,,{0} বিট,{0} বিট,বিট,,{0} বিট,{0} বিট
        byte,বাঃ,,{0} বাঃ,{0} বাঃ,বাইট,,{0} বাইট,{0} বাইট,বাইট,,{0} বাইট,{0} বাইট
        gigabit,গিঃ বিঃ,,{0} গিঃ বিঃ,{0} গিঃ বিঃ,গিগাবিট,,{0} গিঃ বিঃ,{0} গিঃ বিঃ,গিগাবিট,,{0} গিগাবিট,{0} গিগাবিট
        gigabyte,গিঃ বাঃ,,{0} গিঃ বাঃ,{0} গিঃ বাঃ,গিগাবাইট,,{0} গিঃ বাঃ,{0} গিঃ বাঃ,গিগাবাইট,,{0} গিগাবাইট,{0} গিগাবাইট
        kilobit,কিঃ বিঃ,,{0} কিঃ বিঃ,{0} কিঃ বিঃ,কিলোবিট,,{0} কিঃ বিঃ,{0} কিঃ বিঃ,কিলোবিট,,{0} কিলোবিট,{0} কিলোবিট
        kilobyte,কিঃ বাঃ,,{0} কিঃ বাঃ,{0} কিঃ বাঃ,কিলোবাইট,,{0} কিঃ বাঃ,{0} কিঃ বাঃ,কিলোবাইট,,{0} কিলোবাইট,{0} কিলোবাইট
        megabit,মেঃ বিঃ,,{0} মেঃ বিঃ,{0} মেঃ বিঃ,মেগাবিট,,{0} মেঃ বিঃ,{0} মেঃ বিঃ,মেগাবিট,,{0} মেগাবিট,{0} মেগাবিট
        megabyte,মেঃ বাঃ,,{0} মেঃ বাঃ,{0} মেঃ বাঃ,মেগাবাইট,,{0} মেঃ বাঃ,{0} মেঃ বাঃ,মেগাবাইট,,{0} মেগাবাইট,{0} মেগাবাইট
        petabyte,PB,,{0}PB,{0}PB,PByte,,,{0} PB,পেটাবাইট,,{0} পেটাবাইট,{0} পেটাবাইট
        terabit,টেঃ বিঃ,,{0} টেঃ বিঃ,{0} টেঃ বিঃ,টেৰাবিট,,{0} টেঃ বিঃ,{0} টেঃ বিঃ,টেৰাবিট,,{0} টেৰাবিট,{0} টেৰাবিট
        terabyte,টেঃ বাঃ,,{0} টেঃ বাঃ,{0} টেঃ বাঃ,টেৰাবাইট,,{0} টেঃ বাঃ,{0} টেঃ বাঃ,টেৰাবাইট,,{0} টেৰাবাইট,{0} টেৰাবাইট
        century,শতিকা,,{0} শতিকা,{0} শতিকা,শতিকা,,{0} শতিকা,{0} শতিকা,শতাব্দী,,{0} শতাব্দী,{0} শতাব্দী
        day,দিন,{0}/দিন,{0} দিন,{0} দিন,দিন,{0}/দিন,{0} দিন,{0} দিন,দিন,{0} প্ৰতি দিন,{0} দিন,{0} দিন
        decade,দশ.,,{0} দশ.,{0} দশ.,দশ.,,{0} দশ.,{0} দশ.,দশক,,{0} দশক,{0} দশক
        hour,ঘণ্টা,{0}/ঘণ্টা,{0} ঘণ্টা,{0} ঘণ্টা,ঘণ্টা,{0}/ঘণ্টা,{0} ঘণ্টা,{0} ঘণ্টা,ঘণ্টা,প্ৰতি {0} ঘণ্টা,{0} ঘণ্টা,{0} ঘণ্টা
        microsecond,মাইক্ৰছেকেণ্ড,,{0} মাঃ ছেঃ,{0} মাঃ ছেঃ,মাইক্ৰছেকেণ্ড,,{0} মাঃ ছেঃ,{0} মাঃ ছেঃ,মাইক্ৰছেকেণ্ড,,{0} মাইক্ৰছেকেণ্ড,{0} মাইক্ৰছেকেণ্ড
        millisecond,মিলিছেকেণ্ড,,{0} মিঃ ছেঃ,{0} মিঃ ছেঃ,মিলিছেকেণ্ড,,{0} মিঃ ছেঃ,{0} মিঃ ছেঃ,মিলিছেকেণ্ড,,{0} মিলিছেকেণ্ড,{0} মিলিছেকেণ্ড
        minute,মিনিট,{0}/মিনিট,{0} মিনিট,{0} মিনিট,মিনিট,{0}/মিনিট,{0} মিনিট,{0} মিনিট,মিনিট,প্ৰতি {0} মিনিট,{0} মিনিট,{0} মিনিট
        month,মাহ,{0}/মাহ,{0} মাহ,{0} মাহ,মাহ,{0}/মাহ,{0} মাহ,{0} মাহ,মাহ,প্ৰতি {0} মাহ,{0} মাহ,{0} মাহ
        nanosecond,নেনোছেকেণ্ড,,{0} নেঃ ছেঃ,{0} নেঃ ছেঃ,নেনোছেকেণ্ড,,{0} নেঃ ছেঃ,{0} নেঃ ছেঃ,নেনোছেকেণ্ড,,{0} নেনোছেকেণ্ড,{0} নেনোছেকেণ্ড
        night,নিশা,{0}/নিশা,{0} নিশা,{0} নিশা,নিশা,{0}/নিশা,{0} নিশা,{0} নিশা,নিশা,{0}/নিশা,{0} নিশা,{0} নিশা
        quarter,কোৱাৰ্টাৰ,{0}/কো,{0}কো,{0}কো,কোৱাৰ্টাৰ,{0}/কো,{0} কোৱাৰ্টাৰ,{0} কোৱাৰ্টাৰ,কোৱাৰ্টাৰ্ছ,{0}/কো,{0} কোৱাৰ্টাৰ,{0} কোৱাৰ্টাৰ
        second,ছেকেণ্ড,{0}/ছেকেণ্ড,{0} ছেকেণ্ড,{0} ছেকেণ্ড,ছেকেণ্ড,{0}/ছেকেণ্ড,{0} ছেকেণ্ড,{0} ছেকেণ্ড,ছেকেণ্ড,প্ৰতি {0} ছেকেণ্ড,{0} ছেকেণ্ড,{0} ছেকেণ্ড
        week,সপ্তাহ,{0}/সপ্তাহ,{0} সপ্তাহ,{0} সপ্তাহ,সপ্তাহ,{0}/সপ্তাহ,{0} সপ্তাহ,{0} সপ্তাহ,সপ্তাহ,প্ৰতি {0} সপ্তাহ,{0} সপ্তাহ,{0} সপ্তাহ
        year,বছৰ,{0}/বছৰ,{0} বছৰ,{0} বছৰ,বছৰ,{0}/বছৰ,{0} বছৰ,{0} বছৰ,বছৰ,প্ৰতি {0} বছৰ,{0} বছৰ,{0} বছৰ
        ampere,এম্পিয়াৰ,,{0} এঃ,{0} এঃ,এম্পিয়াৰ,,{0} এঃ,{0} এঃ,এম্পিয়াৰ,,{0} এম্পিয়াৰ,{0} এম্পিয়াৰ
        milliampere,মিলিএম্পিয়াৰ,,{0} মিঃ এঃ,{0} মিঃ এঃ,মিলিএম্পিয়াৰ,,{0} মিঃ এঃ,{0} মিঃ এঃ,মিলিএম্পিয়াৰ,,{0} মিলিএম্পিয়াৰ,{0} মিলিএম্পিয়াৰ
        ohm,ওম,,,{0} Ω,ওম,,,{0} Ω,ওম,,{0} ওম,{0} ওম
        volt,ভল্ট,,{0} ভঃ,{0} ভঃ,ভল্ট,,{0} ভঃ,{0} ভঃ,ভল্ট,,{0} ভল্ট,{0} ভল্ট
        british-thermal-unit,BTU,,,{0} Btu,BTU,,,{0} Btu,ব্ৰিটিশ্ব থাৰ্মেল ইউনিট,,{0} ব্ৰিটিশ্ব থাৰ্মেল ইউনিট,{0} ব্ৰিটিশ্ব থাৰ্মেল ইউনিট
        calorie,কেলৰি,,{0} কেলৰি,{0} কেলৰি,কেলৰি,,{0} কেলৰি,{0} কেলৰি,কেলৰি,,{0} কেলৰি,{0} কেলৰি
        electronvolt,ইলেক্ট্ৰ’নভ’ল্ট,,,{0} eV,ইলেক্ট্ৰ’নভ’ল্ট,,,{0} eV,ইলেক্ট্ৰ’নভ’ল্ট,,{0} ইলেক্ট্ৰ’নভ’ল্ট,{0} ইলেক্ট্ৰ’নভ’ল্ট
        foodcalorie,কেলৰি,,{0}কেলৰি,{0}কেলৰি,কেলৰি,,{0} কেলৰি,{0} কেলৰি,কেলৰি,,{0} কেলৰি,{0} কেলৰি
        joule,জুল,,{0} জুল,{0} জুল,জুল,,{0} জুল,{0} জুল,জুল,,{0} জুল,{0} জুল
        kilocalorie,কিলোকেলৰি,,{0} কিঃ কেলঃ,{0} কিঃ কেলঃ,কিলোকেলৰি,,{0} কিঃ কেলঃ,{0} কিঃ কেলঃ,কিলোকেলৰি,,{0} কিলোকেলৰি,{0} কিলোকেলৰি
        kilojoule,কিলোজুল,,{0} কিঃ জুঃ,{0} কিঃ জুঃ,কিলোজুল,,{0} কিঃ জুঃ,{0} কিঃ জুঃ,কিলোজুল,,{0} কিলোজুল,{0} কিলোজুল
        kilowatt-hour,কিঃ ৱাঃ-ঘঃ,,{0} কিঃ ৱাঃ-ঘঃ,{0} কিঃ ৱাঃ-ঘঃ,কিঃ ৱাঃ-ঘঃ,,{0} কিঃ ৱাঃ-ঘঃ,{0} কিঃ ৱাঃ-ঘঃ,কিলোৱাট-ঘণ্টা,,{0} কিলোৱাট ঘণ্টা,{0} কিলোৱাট ঘণ্টা
        therm-us,ইউ এচ থাৰ্ণ,,{0} ইউ এচ থাৰ্ণ,{0} ইউ এচ থাৰ্ণ,ইউ এচ থাৰ্ণ,,{0} ইউ এচ থাৰ্ণ,{0} ইউ এচ থাৰ্ণ,ইউ এচ থাৰ্ণ,,{0} ইউ এচ থাৰ্ণ,{0} ইউ এচ থাৰ্ণ
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0} kWh/100km,,,,,প্ৰতি 100 কিলোমিটাৰত কিলোৱাট-ঘণ্টা,,প্ৰতি 100 কিলোমিটাৰত {0} কিলোৱাট-ঘণ্টা,প্ৰতি 100 কিলোমিটাৰত {0} কিলোৱাট-ঘণ্টা
        newton,,,,,নিউটন,,,{0} N,নিউটন,,{0} নিউটন,{0} নিউটন
        pound-force,পাউণ্ড-বল,,,{0} lbf,পাউণ্ড-বল,,,{0} lbf,পাউণ্ড-বল,,{0} পাউণ্ড-বল,{0} পাউণ্ড-বল
        gigahertz,গিগাহাৰ্টজ,,{0} গিগাহাৰ্টজ,{0} গিগাহাৰ্টজ,গিগাহাৰ্টজ,,{0} গিগাহাৰ্টজ,{0} গিগাহাৰ্টজ,গিগাহাৰ্টজ,,{0} গিগাহাৰ্টজ,{0} গিগাহাৰ্টজ
        hertz,হাৰ্টজ,,{0} হাৰ্টজ,{0} হাৰ্টজ,হাৰ্টজ,,{0} হাৰ্টজ,{0} হাৰ্টজ,হাৰ্টজ,,{0} হাৰ্টজ,{0} হাৰ্টজ
        kilohertz,কিলোহাৰ্টজ,,{0} কিঃ হাঃ,{0} কিঃ হাঃ,কিলোহাৰ্টজ,,{0} কিঃ হাঃ,{0} কিঃ হাঃ,কিলোহাৰ্টজ,,{0} কিলোহাৰ্টজ,{0} কিলোহাৰ্টজ
        megahertz,মেগাহাৰ্টজ,,{0} মেঃ হাঃ,{0} মেঃ হাঃ,মেগাহাৰ্টজ,,{0} মেঃ হাঃ,{0} মেঃ হাঃ,মেগাহাৰ্টজ,,{0} মেগাহাৰ্টজ,{0} মেগাহাৰ্টজ
        dot,বিন্দু,,{0}টা বিন্দু,{0}টা বিন্দু,বিন্দুবোৰ,,{0} টা বিন্দু,{0} টা বিন্দু,বিন্দুবোৰ,,{0} টা বিন্দু,{0} টা বিন্দু
        dot-per-centimeter,ডিপিচিএম,,{0}ডিপিচিএম,{0}ডিপিচিএম,ডিপিচিএম,,{0} ডিপিচিএম,{0} ডিপিচিএম,প্ৰতি চেণ্টিমিটাৰত বিন্দু,,প্ৰতি চেণ্টিমিটাৰত {0} টা বিন্দু,প্ৰতি চেণ্টিমিটাৰত {0} টা বিন্দু
        dot-per-inch,ডিপিআই,,{0}ডিপিআই,{0}ডিপিআই,ডিপিআই,,{0} ডিপিআই,{0} ডিপিআই,প্ৰতি ইঞ্চিত বিন্দু,,প্ৰতি ইঞ্চিত {0} টা বিন্দু,প্ৰতি ইঞ্চিত {0} টা বিন্দু
        em,ইএম,,{0} ইএম,{0} ইএম,ইএম,,{0} ইএম,{0} ইএম,টাইপোগ্ৰাফিক ইএম,,{0} ইএম,{0} ইএম
        megapixel,মে. পি.,,{0} মে. পি.,{0} মে. পি.,মেগাপিক্সেল,,{0} মে. পি.,{0} মে. পি.,মেগাপিক্সেল,,{0} মেগাপিক্সেল,{0} মেগাপিক্সেল
        pixel,পি.,,{0} পি,{0} পি,পিক্সেল,,{0} পি.,{0} পি.,পিক্সেল,,{0} পিক্সেল,{0} পিক্সেল
        pixel-per-centimeter,পিপিচিএম,,{0}পিপিচিএম,{0}পিপিচিএম,পিপিচিএম,,{0} পিপিচিএম,{0} পিপিচিএম,প্ৰতি চেণ্টিমিটাৰত পিক্সেল,,{0} পিপিচিএম,প্ৰতি চেণ্টিমিটাৰত {0} পিক্সেল
        pixel-per-inch,পিপিআই,,{0}পিপিআই,{0}পিপিআই,পিপিআই,,{0} পিপিআই,{0} পিপিআই,প্ৰতি ইঞ্চিত পিক্সেল,,প্ৰতি ইঞ্চিত {0} পিক্সেল,প্ৰতি ইঞ্চিত {0} পিক্সেল
        astronomical-unit,জ্যোঃ এঃ,,{0} জ্যোঃ এঃ,{0} জ্যোঃ এঃ,জ্যোঃ এঃ,,{0} জ্যোঃ এঃ,{0} জ্যোঃ এঃ,জ্যোতিৰ্বিজ্ঞান একক,,{0} জ্যোতিৰ্বিজ্ঞান একক,{0} জ্যোতিৰ্বিজ্ঞান একক
        centimeter,ছেঃ মিঃ,{0}/ছেঃ মিঃ,{0} ছেঃ মিঃ,{0} ছেঃ মিঃ,ছেঃ মিঃ,{0}/ছেঃ মিঃ,{0} ছেঃ মিঃ,{0} ছেঃ মিঃ,ছেণ্টিমিটাৰ,{0} প্ৰতি ছেণ্টিমিটাৰ,{0} ছেণ্টিমিটাৰ,{0} ছেণ্টিমিটাৰ
        decimeter,ডেঃ মিঃ,,{0} ডেঃ মিঃ,{0} ডেঃ মিঃ,ডেঃ মিঃ,,{0} ডেঃ মিঃ,{0} ডেঃ মিঃ,ডেচিমিটাৰ,,{0} ডেচিমিটাৰ,{0} ডেচিমিটাৰ
        earth-radius,,,,,,,,,পৃথিৱীৰ ব্যাসাৰ্ধ,,{0} পৃথিৱীৰ ব্যাসাৰ্ধ,{0} পৃথিৱীৰ ব্যাসাৰ্ধ
        fathom,ফাথম,,{0} ফাথম,{0} ফাথম,ফাথম,,{0} ফাথম,{0} ফাথম,ফাথম,,{0} ফাথম,{0} ফাথম
        foot,ফুট,{0}/ফুঃ,{0} ফুঃ,{0} ফুঃ,ফুট,{0}/ফুঃ,{0} ফুঃ,{0} ফুঃ,ফুট,প্ৰতি {0} ফুট,{0} ফুট,{0} ফুট
        furlong,ফাৰ্লং,,{0} ফাৰ্লং,{0} ফাৰ্লং,ফাৰ্লং,,{0} ফাৰ্লং,{0} ফাৰ্লং,ফাৰ্লং,,{0} ফাৰ্লং,{0} ফাৰ্লং
        inch,ইঞ্চি,{0}/ইঃ,{0} ইঃ,{0} ইঃ,ইঞ্চি,{0}/ইঃ,{0} ইঃ,{0} ইঃ,ইঞ্চি,{0} প্ৰতি ইঞ্চি,{0} ইঞ্চি,{0} ইঞ্চি
        kilometer,কিঃ মিঃ,{0}/কিঃ মিঃ,{0} কিঃ মিঃ,{0} কিঃ মিঃ,কিঃ মিঃ,{0}/কিঃ মিঃ,{0} কিঃ মিঃ,{0} কিঃ মিঃ,কিলোমিটাৰ,{0} প্ৰতি কিলোমিটাৰ,{0} কিলোমিটাৰ,{0} কিলোমিটাৰ
        light-year,আলোকবৰ্ষ,,{0} আঃ বঃ,{0} আঃ বঃ,আলোকবৰ্ষ,,{0} আঃ বঃ,{0} আঃ বঃ,আলোকবৰ্ষ,,{0} আলোকবৰ্ষ,{0} আলোকবৰ্ষ
        meter,মিঃ,{0}/মিঃ,{0} মিঃ,{0} মিঃ,মিটাৰ,{0}/মিঃ,{0} মিঃ,{0} মিঃ,মিটাৰ,{0} প্ৰতি মিটাৰ,{0} মিটাৰ,{0} মিটাৰ
        micrometer,মাইক্ৰ’মিটাৰ,,{0} মাঃ মিঃ,{0} মাঃ মিঃ,মাইক্ৰ’মিটাৰ,,{0} মাঃ মিঃ,{0} মাঃ মিঃ,মাইক্ৰ’মিটাৰ,,{0} মাইক্ৰ’মিটাৰ,{0} মাইক্ৰ’মিটাৰ
        mile,মাইল,,{0} মাঃ,{0} মাঃ,মাইল,,{0} মাঃ,{0} মাঃ,মাইল,,{0} মাইল,{0} মাইল
        mile-scandinavian,মাঃ-স্কেঃ,,{0} মাঃ-স্কেঃ,{0} মাঃ-স্কেঃ,মাঃ-স্কেঃ,,{0} মাঃ-স্কেঃ,{0} মাঃ-স্কেঃ,মাইল-স্কেণ্ডিনেভিয়ান,,{0} মাইল-স্কেণ্ডিনেভিয়ান,{0} মাইল-স্কেণ্ডিনেভিয়ান
        millimeter,মিঃ মিঃ,,{0} মিঃ মিঃ,{0} মিঃ মিঃ,মিঃ মিঃ,,{0} মিঃ মিঃ,{0} মিঃ মিঃ,মিলিমিটাৰ,,{0} মিলিমিটাৰ,{0} মিলিমিটাৰ
        nanometer,নেঃ মিঃ,,{0} নেঃ মিঃ,{0} নেঃ মিঃ,নেঃ মিঃ,,{0} নেঃ মিঃ,{0} নেঃ মিঃ,নেনোমিটাৰ,,{0} নেনোমিটাৰ,{0} নেনোমিটাৰ
        nautical-mile,ন’টিঃ মাঃ,,{0} ন’টিঃ মাঃ,{0} ন’টিঃ মাঃ,ন’টিঃ মাঃ,,{0} ন’টিঃ মাঃ,{0} ন’টিঃ মাঃ,ন’টিকেল মাইল,,{0} ন’টিকেল মাইল,{0} ন’টিকেল মাইল
        parsec,পাৰ্ছেক,,{0} পাৰ্ছেক,{0} পাৰ্ছেক,পাৰ্ছেক,,{0} পাৰ্ছেক,{0} পাৰ্ছেক,পাৰ্ছেক,,{0} পাৰ্ছেক,{0} পাৰ্ছেক
        picometer,পিঃ মিঃ,,{0} পিঃ মিঃ,{0} পিঃ মিঃ,পিঃ মিঃ,,{0} পিঃ মিঃ,{0} পিঃ মিঃ,পিকোমিটাৰ,,{0} পিকোমিটাৰ,{0} পিকোমিটাৰ
        point,পইণ্ট,,{0} পইণ্ট,{0} পইণ্ট,পইণ্ট,,{0} পইণ্ট,{0} পইণ্ট,পইণ্ট,,{0} পইণ্ট,{0} পইণ্ট
        solar-radius,সৌৰ ৰেডিয়াছ,,,{0} R☉,সৌৰ ৰেডিয়াছ,,,{0} R☉,সৌৰ ৰেডিয়াছ,,{0} সৌৰ ৰেডিয়াছ,{0} সৌৰ ৰেডিয়াছ
        yard,গজ,,{0} গজ,{0} গজ,গজ,,{0} গজ,{0} গজ,গজ,,{0} গজ,{0} গজ
        candela,কেঃ,,{0} কেঃ,{0} কেঃ,কেঃ,,{0} কেঃ,{0} কেঃ,কেণ্ডেলা,,{0} কেণ্ডেলা,{0} কেণ্ডেলা
        lumen,,,,,,,,,লুমেন,,{0} লুমেন,{0} লুমেন
        lux,লাক্স,,{0} লাক্স,{0} লাক্স,লাক্স,,{0} লাক্স,{0} লাক্স,লাক্স,,{0} লাক্স,{0} লাক্স
        solar-luminosity,,,,,ছ’লাৰ লুমিন’ছিটী,,,{0} L☉,ছ’লাৰ লুমিন’ছিটী,,{0} ছ’লাৰ লুমিন’ছিটী,{0} ছ’লাৰ লুমিন’ছিটী
        carat,কেৰেট,,{0} কেৰেট,{0} কেৰেট,কেৰেট,,{0} কেৰেট,{0} কেৰেট,কেৰেট,,{0} কেৰেট,{0} কেৰেট
        dalton,ডলট’ন,,{0} ডলট’ন,{0} ডলট’ন,ডলট’ন,,{0} ডলট’ন,{0} ডলট’ন,ডলট’ন,,{0} ডলট’ন,{0} ডলট’ন
        earth-mass,আৰ্থ মাছ,,,{0} M⊕,আৰ্থ মাছ,,,{0} M⊕,আৰ্থ মাছ,,{0} আৰ্থ মাছ,{0} আৰ্থ মাছ
        grain,গ্ৰেইন,,{0} গ্ৰেইন,{0} গ্ৰেইন,গ্ৰেইন,,{0} গ্ৰেইন,{0} গ্ৰেইন,গ্ৰেইন,,{0} গ্ৰেইন,{0} গ্ৰেইন
        gram,গ্ৰাম,{0}/গ্ৰাঃ,{0} গ্ৰাঃ,{0} গ্ৰাঃ,গ্ৰাম,{0}/গ্ৰাঃ,{0} গ্ৰাঃ,{0} গ্ৰাঃ,গ্ৰাম,{0} প্ৰতি গ্ৰাম,{0} গ্ৰাম,{0} গ্ৰাম
        kilogram,কিঃ গ্ৰাঃ,{0}/কিঃ গ্ৰাঃ,{0} কিঃ গ্ৰাঃ,{0} কিঃ গ্ৰাঃ,কিঃ গ্ৰাঃ,{0}/কিঃ গ্ৰাঃ,{0} কিঃ গ্ৰাঃ,{0} কিঃ গ্ৰাঃ,কিলোগ্রাম,{0} প্ৰতি কিলোগ্ৰাম,{0} কিলোগ্ৰাম,{0} কিলোগ্ৰাম
        microgram,মাঃ গ্ৰাঃ,,{0} মাঃ গ্ৰাঃ,{0} মাঃ গ্ৰাঃ,মাঃ গ্ৰাঃ,,{0} মাঃ গ্ৰাঃ,{0} মাঃ গ্ৰাঃ,মাইক্ৰোগ্ৰাম,,{0} মাইক্ৰোগ্ৰাম,{0} মাইক্ৰোগ্ৰাম
        milligram,মিঃ গ্ৰাঃ,,{0} মিঃ গ্ৰাঃ,{0} মিঃ গ্ৰাঃ,মিঃ গ্ৰাঃ,,{0} মিঃ গ্ৰাঃ,{0} মিঃ গ্ৰাঃ,মিলিগ্ৰাম,,{0} মিলিগ্ৰাম,{0} মিলিগ্ৰাম
        ounce,আউন্স,{0}/আউন্স,{0} আউন্স,{0} আউন্স,আউন্স,{0}/আউন্স,{0} আউন্স,{0} আউন্স,আউন্স,{0} প্ৰতি আউন্স,{0} আউন্স,{0} আউন্স
        ounce-troy,ট্ৰয় আউন্স,,{0} ট্ৰঃ আঃ,{0} ট্ৰঃ আঃ,ট্ৰয় আউন্স,,{0} ট্ৰঃ আঃ,{0} ট্ৰঃ আঃ,ট্ৰয় আউন্স,,{0} ট্ৰয় আউন্স,{0} ট্ৰয় আউন্স
        pound,পাউণ্ড,{0}/পাউণ্ড,{0} পাউণ্ড,{0} পাউণ্ড,পাউণ্ড,{0}/পাউণ্ড,{0} পাউণ্ড,{0} পাউণ্ড,পাউণ্ড,{0} প্ৰতি পাউণ্ড,{0} পাউণ্ড,{0} পাউণ্ড
        solar-mass,সৌৰ ভৰ,,,{0} M☉,সৌৰ ভৰ,,,{0} M☉,সৌৰ ভৰ,,{0} সৌৰ ভৰ,{0} সৌৰ ভৰ
        stone,ষ্ট’ন,,{0} ষ্ট'ন,{0} ষ্ট'ন,ষ্ট’ন,,{0} ষ্ট'ন,{0} ষ্ট'ন,ষ্ট’ন,,{0} ষ্ট'ন,{0} ষ্ট'ন
        ton,টন,,{0} টন,{0} টন,টন,,{0} টন,{0} টন,টন,,{0} টন,{0} টন
        tonne,ট,,{0} ট,{0} ট,ট,,{0} ট,{0} ট,মেট্রিক টন,,{0} মেট্রিক টন,{0} মেট্ৰিক টন
        gigawatt,গিঃ ৱাঃ,,{0} গিঃ ৱাঃ,{0} গিঃ ৱাঃ,গিঃ ৱাঃ,,{0} গিঃ ৱাঃ,{0} গিঃ ৱাঃ,গিগাৱাট,,{0} গিগাৱাট,{0} গিগাৱাট
        horsepower,অশ্বক্ষমতা,,{0} অশ্বক্ষমতা,{0} অশ্বক্ষমতা,অশ্বক্ষমতা,,{0} অশ্বক্ষমতা,{0} অশ্বক্ষমতা,অশ্বক্ষমতা,,{0} অশ্বক্ষমতা,{0} অশ্বক্ষমতা
        kilowatt,কিঃ ৱাঃ,,{0} কিঃ ৱাঃ,{0} কিঃ ৱাঃ,কিঃ ৱাঃ,,{0} কিঃ ৱাঃ,{0} কিঃ ৱাঃ,কিলোৱাট,,{0} কিলোৱাট,{0} কিলোৱাট
        megawatt,মেঃ ৱাঃ,,{0} মেঃ ৱাঃ,{0} মেঃ ৱাঃ,মেঃ ৱাঃ,,{0} মেঃ ৱাঃ,{0} মেঃ ৱাঃ,মেগাৱাট,,{0} মেগাৱাট,{0} মেগাৱাট
        milliwatt,মিঃ ৱাঃ,,{0} মিঃ ৱাঃ,{0} মিঃ ৱাঃ,মিঃ ৱাঃ,,{0} মিঃ ৱাঃ,{0} মিঃ ৱাঃ,মিলিৱাট,,{0} মিলিৱাট,{0} মিলিৱাট
        watt,ৱাট,,{0} ৱাট,{0} ৱাট,ৱাট,,{0} ৱাট,{0} ৱাট,ৱাট,,{0} ৱাট,{0} ৱাট
        atmosphere,,,,,,,,,বতৰ,,{0} বতৰ,{0} atm
        bar,বাৰ,,{0} বাৰ,{0} বাৰ,বাৰ,,{0} বাৰ,{0} বাৰ,বাৰ,,{0} বাৰ,{0} বাৰ
        hectopascal,,,,,,,,,হেক্টোপাস্কেল,,{0} হেক্টোপাস্কেল,{0} হেক্টোপাস্কেল
        inch-ofhg,″ Hg,,{0}″ Hg,{0}″ Hg,,,,,ইঞ্চি মাৰ্কিউৰী,,{0} ইঞ্চি মাৰ্কিউৰী,{0} ইঞ্চি মাৰ্কিউৰী
        kilopascal,কি. পা.,,{0} কি. পা.,{0} কি. পা.,কি. পা.,,{0} কি. পা.,{0} কি. পা.,কিল’পাস্কেল,,{0} কিল’পাস্কেল,{0} কি. পা.
        megapascal,মেগাপাস্কেল,,{0} মে. পা.,{0} মে. পা.,মেগাপাস্কেল,,{0} মে. পা.,{0} মে. পা.,মেগাপাস্কেল,,{0} মেগাপাস্কেল,{0} মেগাপাস্কেল
        millibar,mbar,,{0}mb,{0}mb,,,,,মিলিবাৰ,,{0} মিলিবাৰ,{0} মিলিবাৰ
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,mmHg,,{0} mmHg,{0} mmHg,মিলিমিটাৰ মাৰ্কিউৰী,,{0} মিলিমিটাৰ মাৰ্কিউৰী,{0} মিলিমিটাৰ মাৰ্কিউৰী
        pascal,,,,,,,,,পাস্কেল,,{0} পাস্কেল,{0} পাস্কেল
        pound-force-per-square-inch,,,,,,,,,প্ৰতি বৰ্গ ইঞ্চিত পাউণ্ড,,{0} প্ৰতি বৰ্গ ইঞ্চিত পাউণ্ড,{0} প্ৰতি বৰ্গ ইঞ্চিত পাউণ্ড
        beaufort,বিএফটি,,বি{0},বি{0},বিএফটি,,বি {0},বি {0},বিউফৰ্ট,,বিউফৰ্ট {0},বিউফৰ্ট {0}
        kilometer-per-hour,কিঃ মিঃ/ঘঃ,,{0} km/h,{0} km/h,কিঃ মিঃ/ঘঃ,,{0} কিঃ মিঃ/ঘঃ,{0} কিঃ মিঃ/ঘঃ,ঘণ্টা প্ৰতি কিলোমিটাৰ,,{0} ঘণ্টা প্ৰতি কিলোমিটাৰ,{0} ঘণ্টা প্ৰতি কিলোমিটাৰ
        knot,নট,,{0} নট,{0} নট,নট,,{0} নট,{0} নট,নট,,{0} নট,{0} নট
        light-speed,আলোক,,{0}আলোক,{0}আলোক,আলোক,,{0} আলোক,{0} আলোক,আলোক,,{0} আলোক,{0} আলোক
        meter-per-second,মিটাৰ/ছেকেণ্ড,,{0} মিঃ/ছেঃ,{0} মিঃ/ছেঃ,মিটাৰ/ছেকেণ্ড,,{0} মিঃ/ছেঃ,{0} মিঃ/ছেঃ,মিটাৰ প্ৰতি ছেকেণ্ড,,{0} মিটাৰ প্ৰতি ছেকেণ্ড,{0} মিটাৰ প্ৰতি ছেকেণ্ড
        mile-per-hour,মাইল/ঘণ্টা,,{0} মাঃ/ঘঃ,{0} মাঃ/ঘঃ,মাইল/ঘণ্টা,,{0} মাঃ/ঘঃ,{0} মাঃ/ঘঃ,মাইল প্ৰতি ঘণ্টা,,{0} মাইল প্ৰতি ঘণ্টা,{0} মাইল প্ৰতি ঘণ্টা
        celsius,°চেঃ,,{0}°চেঃ,{0}°চেঃ,ডিগ্ৰীঃ চেঃ,,{0}°চেঃ,{0}°চেঃ,ডিগ্ৰী চেলচিয়াছ,,{0} ডিগ্ৰী চেলচিয়াছ,{0} ডিগ্ৰী চেলচিয়াছ
        fahrenheit,° ফা.,,{0}°,{0}°,ডি. ফা.,,{0}°ফা.,{0}°ফা.,ডিগ্ৰী ফাৰেনহাইট,,{0} ডিগ্ৰী ফাৰেনহাইট,{0} ডিগ্ৰী ফাৰেনহাইট
        generic,,,,,,,,,ডিগ্ৰী তাপমাত্ৰা,,,{0}°
        kelvin,কেলভিন,,{0} কেলভিন,{0} কেলভিন,কেলভিন,,{0} কেলভিন,{0} কেলভিন,কেলভিন,,{0} কেলভিন,{0} কেলভিন
        newton-meter,নি. মি.,,{0} নি. মি.,{0} নি. মি.,নি. মি.,,{0} নি. মি.,{0} নি. মি.,নিউটন-মিটাৰ,,{0} নিউটন-মিটাৰ,{0} নিউটন-মিটাৰ
        pound-force-foot,,,,,,,,,পাউণ্ড-বল-ফুট,,{0} পাউণ্ড-ফুট,{0} পাউণ্ড-ফুট
        acre-foot,একৰ-ফুট,,{0} এঃ-ফুঃ,{0} এঃ-ফুঃ,একৰ-ফুট,,{0} এঃ-ফুঃ,{0} এঃ-ফুঃ,একৰ-ফুট,,{0} একৰ-ফুট,{0} একৰ-ফুট
        barrel,বেৰেল,,,{0} bbl,বেৰেল,,,{0} bbl,বেৰেল,,{0} বেৰেল,{0} বেৰেল
        bushel,বুশ্বেল,,,{0} bu,বুশ্বেল,,,{0} bu,বুশ্বেল,,{0} বুশ্লেল,{0} বুশ্বেল
        centiliter,ছেঃ লিঃ,,{0} ছেঃ লিঃ,{0} ছেঃ লিঃ,ছেঃ লিঃ,,{0} ছেঃ লিঃ,{0} ছেঃ লিঃ,ছেণ্টিলিটাৰ,,{0} ছেণ্টিলিটাৰ,{0} ছেণ্টিলিটাৰ
        cubic-centimeter,ঘন ছেণ্টিমিটাৰ,{0}/cm³,,{0} cm³,ঘন ছেণ্টিমিটাৰ,{0}/cm³,,{0} cm³,ঘন ছেণ্টিমিটাৰ,{0} প্ৰতি ঘন ছেণ্টিমিটাৰ,{0} ঘন ছেণ্টিমিটাৰ,{0} ঘন ছেণ্টিমিটাৰ
        cubic-foot,ঘন ফুট,,,{0} ft³,ঘন ফুট,,,{0} ft³,ঘন ফুট,,{0} ঘন ফুট,{0} ঘন ফুট
        cubic-inch,ঘন ইঞ্চি,,,{0} in³,ঘন ইঞ্চি,,,{0} in³,ঘন ইঞ্চি,,{0} ঘন ইঞ্চি,{0} ঘন ইঞ্চি
        cubic-kilometer,ঘন কিলোমিটাৰ,,,{0} km³,ঘন কিলোমিটাৰ,,,{0} km³,ঘন কিলোমিটাৰ,,{0} ঘন কিলোমিটাৰ,{0} ঘন কিলোমিটাৰ
        cubic-meter,ঘন মিটাৰ,{0}/m³,,{0} m³,ঘন মিটাৰ,{0}/m³,,{0} m³,ঘন মিটাৰ,{0} প্ৰতি ঘন মিটাৰ,{0} ঘন মিটাৰ,{0} ঘন মিটাৰ
        cubic-mile,ঘন মাইল,,,{0} mi³,ঘন মাইল,,,{0} mi³,ঘন মাইল,,{0} ঘন মাইল,{0} ঘন মাইল
        cubic-yard,ঘন গজ,,,{0} yd³,ঘন গজ,,,{0} yd³,ঘন গজ,,{0} ঘন গজ,{0} ঘন গজ
        cup,কাপ,,{0} কাপ,{0} কাপ,কাপ,,{0} কাপ,{0} কাপ,কাপ,,{0} কাপ,{0} কাপ
        cup-metric,মেঃ কাঃ,,{0} মেঃ কাঃ,{0} মেঃ কাঃ,মেঃ কাঃ,,{0} মেঃ কাঃ,{0} মেঃ কাঃ,মেট্ৰিক কাপ,,{0} মেট্ৰিক কাপ,{0} মেট্ৰিক কাপ
        deciliter,ডেঃ লিঃ,,{0} ডেঃ লিঃ,{0} ডেঃ লিঃ,ডেঃ লিঃ,,{0} ডেঃ লিঃ,{0} ডেঃ লিঃ,ডেচিলিটাৰ,,{0} ডেচিলিটাৰ,{0} ডেচিলিটাৰ
        dessert-spoon,dstspn,,{0}dsp,{0}dsp,,,,,ডেজাৰ্ট চামুচ,,{0} ডেজাৰ্ট চামুচ,{0} ডেজাৰ্ট চামুচ
        dessert-spoon-imperial,dsp Imp,,{0}dsp-Imp,{0}dsp-Imp,,,,,ইম্পেৰিয়েল ডেজাৰ্ট চামুচ,,{0} ইম্পেৰিয়েল ডেজাৰ্ট চামুচ,{0} ইম্পেৰিয়েল ডেজাৰ্ট চামুচ
        dram,ড্ৰাম তৰল পদাৰ্থ,,{0} ড্ৰাম তৰল পদাৰ্থ,{0} ড্ৰাম তৰল পদাৰ্থ,ড্ৰাম তৰল পদাৰ্থ,,{0} ড্ৰাম তৰল পদাৰ্থ,{0} ড্ৰাম তৰল পদাৰ্থ,ড্ৰাম,,{0} ড্ৰাম,{0} ড্ৰাম
        drop,ড্ৰপ,,{0} ড্ৰপ,{0} ড্ৰপ,ড্ৰপ,,{0} ড্ৰপ,{0} ড্ৰপ,ড্ৰপ,,{0} ড্ৰপ,{0} ড্ৰপ
        fluid-ounce,ফ্লুঃ আঃ,,{0} ফ্লুঃ আঃ,{0} ফ্লুঃ আঃ,ফ্লুঃ আঃ,,{0} ফ্লুঃ আঃ,{0} ফ্লুঃ আঃ,ফ্লুইড আউন্স,,{0} ফ্লুইড আউন্স,{0} ফ্লুইড আউন্স
        fluid-ounce-imperial,ইম্পে. ফ্লু. আ.,,{0} ইম্পে. ফ্লু. আ.,{0} ইম্পে. ফ্লু. আ.,ইম্পে. ফ্লু. আ.,,{0} ইম্পে. ফ্লু. আ.,{0} ইম্পে. ফ্লু. আ.,ইম্পেৰিয়েল ফ্লুইড আউন্স,,{0} ইম্পেৰিয়েল ফ্লুইড আউন্স,{0} ইম্পেৰিয়েল ফ্লুইড আউন্স
        gallon,গেলন,{0}/গেলন,{0} গেলন,{0} গেলন,গেলন,{0}/গেলন,{0} গেলন,{0} গেলন,গেলন,{0} প্ৰতি গেলন,{0} গেলন,{0} গেলন
        gallon-imperial,ইম্পেঃ গেঃ,{0}/ইম্পেঃ গেঃ,{0} ইম্পেঃ গেঃ,{0} ইম্পেঃ গেঃ,ইম্পেঃ গেঃ,{0}/ইম্পেঃ গেঃ,{0} ইম্পেঃ গেঃ,{0} ইম্পেঃ গেঃ,ইম্পেৰিয়াল গেলন,{0} প্ৰতি ইম্পেৰিয়াল গেলন,{0} ইম্পেৰিয়াল গেলন,{0} ইম্পেৰিয়াল গেলন
        hectoliter,হেঃ লিঃ,,{0} হেঃ লিঃ,{0} হেঃ লিঃ,হেঃ লিঃ,,{0} হেঃ লিঃ,{0} হেঃ লিঃ,হেক্টোলিটাৰ,,{0} হেক্টোলিটাৰ,{0} হেক্টোলিটাৰ
        jigger,জিগাৰ,,{0} জিগাৰ,{0} জিগাৰ,জিগাৰ,,{0} জিগাৰ,{0} জিগাৰ,জিগাৰ,,{0} জিগাৰ,{0} জিগাৰ
        liter,লিটাৰ,{0}/লিঃ,{0} লিঃ,{0} লিঃ,লিটাৰ,{0}/লিঃ,{0} লিঃ,{0} লিঃ,লিটাৰ,{0} প্ৰতি লিটাৰ,{0} লিটাৰ,{0} লিটাৰ
        megaliter,মেঃ লিঃ,,{0} মেঃ লিঃ,{0} মেঃ লিঃ,মেঃ লিঃ,,{0} মেঃ লিঃ,{0} মেঃ লিঃ,মেগালিটাৰ,,{0} মেগালিটাৰ,{0} মেগালিটাৰ
        milliliter,মিঃ লিঃ,,{0} মিঃ লিঃ,{0} মিঃ লিঃ,মিঃ লিঃ,,{0} মিঃ লিঃ,{0} মিঃ লিঃ,মিলিলিটাৰ,,{0} মিলিলিটাৰ,{0} মিলিলিটাৰ
        pinch,পিঞ্চ,,{0} পিঞ্চ,{0} পিঞ্চ,পিঞ্চ,,{0} পিঞ্চ,{0} পিঞ্চ,পিঞ্চ,,{0} পিঞ্চ,{0} পিঞ্চ
        pint,পিণ্ট,,{0} পিণ্ট,{0} পিণ্ট,পিণ্ট,,{0} পিণ্ট,{0} পিণ্ট,পিণ্ট,,{0} পিণ্ট,{0} পিণ্ট
        pint-metric,মেঃ পিঃ,,{0} মেঃ পিঃ,{0} মেঃ পিঃ,মেঃ পিঃ,,{0} মেঃ পিঃ,{0} মেঃ পিঃ,মেট্ৰিক পিণ্ট,,{0} মেট্ৰিক পিণ্ট,{0} মেট্ৰিক পিণ্ট
        quart,কোৱাৰ্ট,,{0} কোৱাৰ্ট,{0} কোৱাৰ্ট,কোৱাৰ্ট,,{0} কোৱাৰ্ট,{0} কোৱাৰ্ট,কোৱাৰ্ট,,{0} কোৱাৰ্ট,{0} কোৱাৰ্ট
        quart-imperial,,,,,,,,,ইম্পেৰিয়েল কুৱাৰ্ট,,{0} ইম্পেৰিয়েল কুৱাৰ্ট,{0} ইম্পেৰিয়েল কুৱাৰ্ট
        tablespoon,টেব’লস্পুন,,{0} টেব’লস্পুন,{0} টেব’লস্পুন,টেব’লস্পুন,,{0} টেব’লস্পুন,{0} টেব’লস্পুন,টেব’লস্পুন,,{0} টেব’লস্পুন,{0} টেব’লস্পুন
        teaspoon,টিস্পুন,,{0}টিস্পুন,{0}টিস্পুন,টিস্পুন,,{0} টিস্পুন,{0} টিস্পুন,টিস্পুন,,{0} টিস্পুন,{0} টিস্পুন
        """.trimIndent()
  }

  private val as_Prefixes: String by lazy {
    """square,,,বৰ্গ {0}
        cubic,,,ঘন {0}
        per,,,প্ৰতি {1}ত {0}
        1024p1,কি{0},কি{0},কিবি{0}
        1024p2,মি{0},মি{0},মেবি{0}
        1024p3,গি{0},গিঃ{0},গিবি{0}
        1024p4,টে{0},টেঃ{0},টেবি{0}
        1024p5,পে{0},পেঃ{0},পেবি{0}
        1024p6,এক্স{0},এক্স{0},এক্সবি{0}
        1024p7,জে{0},জেঃ{0},জেবি{0}
        1024p8,য়ো{0},য়োঃ{0},য়োবে{0}
        10p-1,ডেচি{0},ডেঃ{0},ডেচি{0}
        10p-12,পিকো{0},পি.{0},পিকো{0}
        10p-15,ফেমটো{0},ফেম.{0},ফেমটো{0}
        10p-18,অটো{0},অ.{0},অটো{0}
        10p-2,চেণ্টি{0},চেঃ{0},চেণ্টি{0}
        10p-21,জেপ্টো{0},জে.{0},জেপ্টো{0}
        10p-24,য়ক্টো{0},য়.{0},য়ক্টো{0}
        10p-27,ৰ{0},ৰ{0},ৰণ্টো{0}
        10p-3,মিলি{0},মিঃ{0},মিলি{0}
        10p-30,কু{0},কু{0},কুইকটো{0}
        10p-6,,,মাইক্ৰ’{0}
        10p-9,নেনো{0},নে.{0},নেনো{0}
        10p1,ডেকা{0},ডে.{0},ডেকা{0}
        10p12,টেৰা{0},টে.{0},টেৰা{0}
        10p15,পেটা{0},পে.{0},পেটা{0}
        10p18,এক্সা{0},এ.{0},এক্সা{0}
        10p2,হেক্টো{0},হে.{0},হেক্টো{0}
        10p21,জেতা{0},জ.{0},জেতা{0}
        10p24,য়োটা{0},য়ো.{0},য়োটা{0}
        10p27,ৰো{0},ৰো{0},ৰোনা{0}
        10p3,কিলো{0},কিঃ{0},কিলো{0}
        10p30,কুৱে{0},কুৱে{0},কুৱেটা{0}
        10p6,মেগা{0},মে.{0},মেগা{0}
        10p9,গিগা{0},গি.{0},গিগা{0}
        """.trimIndent()
  }

  private val asa_Units: String? = null

  private val asa_Prefixes: String? = null

  private val ast_Units: String by lazy {
    """g-force,fuercia g,,{0}G,{0}Gs,fuercia g,,{0} G,{0} Gs,fuercia g,,{0} fuercia g,{0} fuercies gues
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,,,,,metros per segundu al cuadráu,,{0} metru per segundu al cuadráu,{0} metros por segundu al cuadráu
        arc-minute,arcmin,,{0}′,{0}′,arcmins,,{0} arcmin,{0} arcmins,minutos d’arcu,,{0} minutu d'arcu,{0} minutos d'arcu
        arc-second,arcsecs,,,{0}″,arcsecs,,,{0}″,segundos d’arcu,,{0} segundu d'arcu,{0} segundos d'arcu
        degree,graos,,,{0}°,graos,,,{0}°,graos,,{0} grau,{0} graos
        radian,rad,,{0}rad,{0}rad,radianes,,,{0} rad,radianes,,{0} radián,{0} radianes
        revolution,rev,,{0}rev,{0}rev,,,,,revolución,,{0} revolución,{0} revoluciones
        acre,acre,,{0}ac,{0}ac,,,,,acres,,{0} acre,{0} acres
        hectare,hectárea,,{0}ha,{0}ha,hectárees,,,{0} ha,hectárees,,{0} hectárea,{0} hectárees
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,,,,,centímetros cuadraos,{0} per centímetru cuadráu,{0} centímetru cuadráu,{0} centímetros cuadraos
        square-foot,ft²,,{0}ft²,{0}ft²,,,,,pies cuadraos,,{0} pie cuadráu,{0} pies cuadraos
        square-inch,in²,{0}/in²,{0}in²,{0}in²,,,,,pulgaes cuadraes,{0} per pulgada cuadrada,{0} pulgada cuadrada,{0} pulgaes cuadraes
        square-kilometer,,,,,,,,,kilómetros cuadraos,{0} per quilómetru cuadráu,{0} kilómetru cuadráu,{0} kilómetros cuadraos
        square-meter,m²,{0} per m²,,{0} m²,,,,,metros cuadraos,{0} per metru cuadráu,{0} metru cuadráu,{0} metros cuadraos
        square-mile,mi²,{0}/mi²,{0}mi²,{0}mi²,,,,,milles cuadraes,{0} per milla cuadrada,{0} milla cuadrada,{0} milles cuadraes
        square-yard,yd²,,{0}yd²,{0}yd²,,,,,yardes cuadraes,,{0} yarda cuadrada,{0} yardes cuadraes
        karat,quilate,,{0}kt,{0}kt,quilates,,,{0} kt,quilates,,{0} quilate,{0} quilates
        milligram-ofglucose-per-deciliter,mg/dL,,{0}mg/dL,{0}mg/dL,,,,,miligramos per decillitru,,{0} miligramu per decillitru,{0} miligramos per decillitru
        millimole-per-liter,mmol/L,,{0}mmol/L,{0}mmol/L,milimol/llitru,,,{0} mmol/L,milimoles per llitru,,{0} milimol per llitru,{0} milimoles per llitru
        permillion,ppm,,{0}ppm,{0}ppm,,,,,partes per millón,,{0} parte per millón,{0} partes per millón
        liter-per-100-kilometer,L/100km,,{0}L/100km,{0}L/100km,L/100 km,,{0} L/100 km,{0} L/100 km,llitros per 100 quilómetros,,{0} llitru per 100 quilómetros,{0} llitros per 100 quilómetros
        liter-per-kilometer,L/km,,{0}L/km,{0}L/km,llitros/km,,,{0} L/km,llitros per quilómetru,,{0} llitru per quilómetru,{0} llitros per quilómetru
        mile-per-gallon,mpg,,{0}mpg,{0}mpg,milles/gal,,{0} mpg,{0} mpg,milles per galón,,{0} milla per galón,{0} milles per galón
        mile-per-gallon-imperial,mpg imp,,{0}mpg im,{0}mpg im,milles/gal imp.,,{0} mpg imp.,{0} mpg imp.,milles per galón imperial,,{0} milla per galón imperial,{0} milles per galón imperial
        bit,bit,,{0}bit,{0}bits,,,,,bits,,{0} bit,{0} bits
        byte,byte,,{0}byte,{0}byte,,,,,bytes,,{0} byte,{0} bytes
        gigabit,Gbit,,{0}Gb,{0}Gb,Gbit,,,{0} Gb,gigabits,,{0} gigabit,{0} gigabits
        gigabyte,GByte,,{0}GB,{0}GB,GByte,,,{0} GB,gigabytes,,{0} gigabyte,{0} gigabytes
        kilobit,kbit,,{0}kb,{0}kb,kbit,,,{0} kb,kilobits,,{0} kilobit,{0} kilobits
        kilobyte,kByte,,{0}kB,{0}kB,kByte,,,{0} kB,kilobytes,,{0} kilobyte,{0} kilobytes
        megabit,Mbit,,{0}Mb,{0}Mb,Mbit,,,{0} Mb,megabits,,{0} megabit,{0} megabits
        megabyte,MByte,,{0}MB,{0}MB,MByte,,,{0} MB,megabytes,,{0} megabyte,{0} megabytes
        terabit,Tbit,,{0}Tb,{0}Tb,Tbit,,,{0} Tb,terabits,,{0} terabit,{0} terabits
        terabyte,TByte,,{0}TB,{0}TB,TByte,,,{0} TB,terabytes,,{0} terabyte,{0} terabytes
        century,sgl,,{0} sgl,{0} sgls,sgl,,{0} sgl,{0} sgls,sieglos,,{0} sieglu,{0} sieglos
        day,día,{0}/día,{0}día,{0}díes,díes,{0}/día,{0} día,{0} díes,díes,{0} per día,{0} día,{0} díes
        hour,hora,{0}/hr,{0}hr,{0}hrs,hores,{0}/hr,{0} hr,{0} hrs,hores,{0} per hora,{0} hora,{0} hores
        microsecond,μseg,,{0}μs,{0}μs,μsegs,,,{0} μs,microsegundos,,{0} microsegundu,{0} microsegundos
        millisecond,mseg,,{0}ms,{0}ms,milisegs,,,{0} ms,milisegundos,,{0} milisegundu,{0} milisegundos
        minute,min,{0}/min,{0}min,{0}mins,mins,{0}/min,{0} min,{0} mins,minutos,{0} per minutu,{0} minutu,{0} minutos
        month,mes,{0}/mes,{0}mes,{0}meses,meses,{0}/mes,{0} mes,{0} meses,meses,{0} per mes,{0} mes,{0} meses
        nanosecond,ns,,{0}ns,{0}ns,nanosegs,,,{0} ns,nanosegundos,,{0} nanosegundu,{0} nanosegundos
        second,seg,{0}/seg,{0}seg,{0}segs,segs,{0}/seg,{0} seg,{0} segs,segundos,{0} per segundu,{0} segundu,{0} segundos
        week,sel,{0}/sel,{0}sel,{0}sels,selmanes,{0}/sel,{0} sel,{0} sels,selmanes,{0} per selmana,{0} selmana,{0} selmanes
        year,añ,{0}/añ,{0}añ,{0}añs,años,{0}/añ,{0} añ,{0} añs,años,{0} per añu,{0} añu,{0} años
        ampere,amp,,{0}A,{0}A,amps,,,{0} A,amperios,,{0} amperiu,{0} amperios
        milliampere,mA,,{0}mA,{0}mA,miliamps,,,{0} mA,miliamperios,,{0} milliamperiu,{0} milliamperios
        ohm,ohmnios,,{0}Ω,{0}Ω,ohmnios,,,{0} Ω,ohmnios,,{0} ohmiu,{0} ohmios
        volt,voltios,,{0}V,{0}V,voltios,,,{0} V,voltios,,{0} voltiu,{0} voltios
        calorie,cal,,{0}cal,{0}cal,,,,,caloríes,,{0} caloría,{0} caloríes
        joule,xulios,,{0}J,{0}J,xulios,,,{0} J,xulios,,{0} xuliu,{0} xulios
        kilocalorie,kcal,,{0}kcal,{0}kcal,,,,,quilocaloríes,,{0} quilocaloría,{0} quilocaloríes
        kilojoule,kJ,,{0}kJ,{0}kJ,quiloxuliu,,,{0} kJ,quiloxulios,,{0} quiloxuliu,{0} quiloxulios
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,kW-hora,,,{0} kWh,quilovatios hora,,{0} quilovatiu hora,{0} quilovatios hora
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,gigahercios,,{0} gigaherciu,{0} gigahercios
        hertz,Hz,,{0}Hz,{0}Hz,,,,,hercios,,{0} herciu,{0} hercios
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,quilohercios,,{0} quiloherciu,{0} kilohercios
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,megahercios,,{0} megaherciu,{0} megahercios
        astronomical-unit,ua,,{0}ua,{0}ua,ua,,{0} ua,{0} ua,unidaes astronómiques,,{0} unidá astronómica,{0} unidaes astronómiques
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,centímetros,{0} por centímetru,{0} centímetru,{0} centímetros
        decimeter,dm,,{0}dm,{0}dm,,,,,decímetros,,{0} decímetru,{0} decímetros
        fathom,fathom,,{0}fth,{0}fth,fathoms,,,{0} fth,fathoms,,{0} fathom,{0} fathoms
        foot,ft,{0}/ft,{0}′,{0}′,pies,{0}/ft,,{0} ft,pies,{0} per pie,{0} pie,{0} pies
        furlong,furlongs,,{0}fur,{0}fur,furlongs,,,{0} fur,furlongs,,{0} furlong,{0} furlongs
        inch,in,{0}/in,{0}″,{0}″,pulgaes,{0}/in,,{0} in,pulgaes,{0} per pulgada,{0} pulgada,{0} pulgaes
        kilometer,km,{0}/km,{0}km,{0}km,,,,,quilómetros,{0} per quilómetru,{0} quilómetru,{0} quilómetros
        light-year,añ. lluz,,{0}ly,{0}ly,añ. lluz,,,{0} ly,años lluz,,{0} añu lluz,{0} años lluz
        meter,m,{0}/m,{0}m,{0}m,metros,{0}/m,,{0} m,metros,{0} per metru,{0} metru,{0} metros
        micrometer,μm,,{0}μm,{0}μm,μmetros,,,{0} μm,micrómetros,,{0} micrómetru,{0} micrómetros
        mile,mi,,{0}mi,{0}mi,milles,,,{0} mi,milles,,{0} milla,{0} milles
        mile-scandinavian,smi,,{0}smi,{0}smi,,,,,milla escandinava,,{0} milla escandinava,{0} milles escandinaves
        millimeter,mm,,{0}mm,{0}mm,,,,,milímetros,,{0} milímetru,{0} milímetros
        nanometer,nm,,{0}nm,{0}nm,,,,,nanómetros,,{0} nanómetru,{0} nanómetros
        nautical-mile,nmi,,{0}nmi,{0}nmi,,,,,milles náutiques,,{0} milla náutica,{0} milles náutiques
        parsec,parsec,,{0}pc,{0}pc,,,,,parsecs,,{0} parsec,{0} parsecs
        picometer,pm,,{0}pm,{0}pm,,,,,picómetros,,{0} picómetru,{0} picómetros
        point,,,,,,,,,Puntos,,{0} puntu,{0} puntos
        yard,yd,,{0}yd,{0}yd,,,,,yardes,,{0} yarda,{0} yardes
        lux,lux,,{0}lx,{0}lx,lux,,,{0} lx,lux,,{0} lux,{0} lux
        carat,quilates,,{0}CD,{0}CD,quilates,,,{0} CD,quilates,,{0} quilate,{0} quilates
        gram,gramos,{0}/g,{0}g,{0}g,gramos,{0}/g,,{0} g,gramos,{0} per gramu,{0} gramu,{0} gramos
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,quilogramos,{0} per quilogramu,{0} quilogramu,{0} quilogramos
        microgram,μg,,{0}μg,{0}μg,,,,,microgramos,,{0} microgramu,{0} microgramos
        milligram,mg,,{0}mg,{0}mg,,,,,miligramos,,{0} miligramu,{0} miligramos
        ounce,oz,{0}/oz,{0}oz,{0}oz,,,,,onces,{0} per onza,{0} onza,{0} onces
        ounce-troy,oz t,,{0}oz t,{0}oz t,oz troy,,,{0} oz t,onces troy,,{0} onza troy,{0} onces troy
        pound,lb,{0}/lb,{0}#,{0}#,llibres,{0}/lb,{0} lb,{0} lbs,llibres,{0} per llibra,{0} llibra,{0} llibres
        stone,piedres,,{0}st,{0}st,piedres,,,{0} st,piedres,,{0} piedra,{0} piedres
        ton,ton,,{0}tn,{0}tn,tonelaes,,,{0} tn,tonelaes,,{0} tonelada,{0} tonelaes
        tonne,t,,{0}t,{0}t,,,,,tonelaes métriques,,{0} tonelada métrica,{0} tonelaes métriques
        gigawatt,GW,,{0}GW,{0}GW,,,,,gigavatios,,{0} gigavatiu,{0} gigavatios
        horsepower,hp,,{0}hp,{0}hp,,,,,caballos,,{0} caballu de fuerza,{0} caballos de fuerza
        kilowatt,kW,,{0}kW,{0}kW,,,,,quilovatios,,{0} quilovatiu,{0} quilovatios
        megawatt,MW,,{0}MW,{0}MW,,,,,megavatios,,{0} megavatiu,{0} megavatios
        milliwatt,mW,,{0}mW,{0}mW,,,,,millivatios,,{0} millivatiu,{0} millivatios
        watt,vatios,,{0}W,{0}W,vatios,,,{0} W,vatios,,{0} vatiu,{0} vatios
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,hectopascales,,{0} hectopascal,{0} hectopascales
        inch-ofhg,″ Hg,,{0}″ Hg,{0}″ Hg,in Hg,,,{0} inHg,pulgaes de mercuriu,,{0} pulgada de mercuriu,{0} pulgaes de mercuriu
        millibar,mbar,,{0}mb,{0}mb,,,,,milibares,,{0} milibar,{0} milibares
        millimeter-ofhg,mm Hg,,{0}mm Hg,{0}mm Hg,,,,,milímetros de mercuriu,,{0} milímetru de mercuriu,{0} milímetros de mercuriu
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,,,,,llibres per pulgada cuadrada,,{0} llibra per pulgada cuadrada,{0} llibres per pulgada cuadrada
        kilometer-per-hour,km/h,,{0}km/h,{0}km/h,,,,,quilómetros per hora,,{0} quilómetru per hora,{0} quilómetros per hora
        knot,kn,,{0}kn,{0}kn,,,,,nuedu,,{0} nuedu,{0} nuedos
        meter-per-second,m/s,,{0}m/s,{0}m/s,metros/seg,,,{0} m/s,metros per segundu,,{0} metru per segundu,{0} metros per segundu
        mile-per-hour,mi/h,,{0}mph,{0}mph,milles/hora,,,{0} mi/h,milles per hora,,{0} milla per hora,{0} milles per hora
        celsius,,,,,,,,,graos Celsius,,{0} grau Celsius,{0} graos Celsius
        fahrenheit,,,,,,,,,graos Fahrenheit,,{0} grau Fahrenheit,{0} graos Fahrenheit
        kelvin,K,,{0}K,{0}K,,,,,kelvins,,{0} kelvin,{0} kelvins
        acre-foot,acre ft,,{0}ac ft,{0}ac ft,,,,,acre-pies,,{0} acre-pie,{0} acre-pies
        bushel,bushel,,{0}bu,{0}bu,bushels,,,{0} bu,bushels,,{0} bushel,{0} bushels
        centiliter,cL,,{0}cL,{0}cL,,,,,centillitros,,{0} centillitru,{0} centillitros
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,centímetros cúbicos,{0} per centímetru cúbicu,{0} centímetru cúbicu,{0} centímetros cúbicos
        cubic-foot,ft³,,{0}ft³,{0}ft³,,,,,pies cúbicos,,{0} pie cúbicu,{0} pies cúbicos
        cubic-inch,in³,,{0}in³,{0}in³,pulgaes³,,,{0} in³,pulgaes cúbiques,,{0} pulgada cúbica,{0} pulgaes cúbiques
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,quilómetros cúbicos,,{0} quilómetru cúbicu,{0} quilómetros cúbicos
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,metros cúbicos,{0} per metru cúbicu,{0} metru cúbicu,{0} metros cúbicos
        cubic-mile,mi³,,{0}mi³,{0} mi³,,,,,milles cúbiques,,{0} milla cúbica,{0} milles cúbiques
        cubic-yard,yd³,,{0}yd³,{0}yd³,,,,,yardes cúbiques,,{0} yarda cúbica,{0} yardes cúbiques
        cup,taces,,{0}tz,{0}tz,taces,,{0} tz,{0} tz,taces,,{0} taza,{0} taces
        cup-metric,taces mét.,,{0}mc,{0}mc,taces mét.,,,{0} mc,taces métriques,,{0} taza métrica,{0} taces métriques
        deciliter,dL,,{0}dL,{0}dL,,,,,decillitros,,{0} decillitru,{0} decillitros
        fluid-ounce,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,onces de fluidos,,{0} onza de fluidos,{0} onces de fluidos
        gallon,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal,{0} gal,{0} gal,galones,{0} per galón,{0} galón,{0} galones
        gallon-imperial,gal. imp.,{0}/gal imp,{0} gal imp,{0} gal imp,gal. imp.,{0}/gal. imp.,{0} gal. imp.,{0} gal. imp.,galones imperiales,{0} per galón imperial,{0} galón imperial,{0} galones imperiales
        hectoliter,hL,,{0}hL,{0}hL,hectollitros,,,{0} hL,hectollitros,,{0} hectollitru,{0} hectollitros
        liter,llitru,{0}/l,{0}l,{0}l,llitros,{0}/l,,{0} l,llitros,{0} per llitru,{0} llitru,{0} llitros
        megaliter,ML,,{0}ML,{0}ML,ML,,{0} ML,{0} Ml,megallitros,,{0} megallitru,{0} megallitros
        milliliter,mL,,{0}mL,{0}mL,,,,,milillitros,,{0} milillitru,{0} milillitros
        pint,pt,,{0}pt,{0}pt,pintes,,,{0} pt,pintes,,{0} pinta,{0} pintes
        pint-metric,mpt,,{0}mpt,{0}mpt,,,,,pintes métriques,,{0} pinta métrica,{0} pintes métriques
        quart,qt,,{0}qt,{0}qt,cuartos,,,{0} qt,cuartos,,{0} cuartu,{0} cuartos
        tablespoon,tbsp,,{0}tbsp,{0}tbsp,cuyar,,{0} cuyar,{0} cuyar,cuyares,,{0} cuyar,{0} cuyares
        teaspoon,tsp,,{0}tsp,{0}tsp,cuyrn,,{0} cuyrn,{0} cuyrn,cuyarines,,{0} cuyarina,{0} cuyarines
        """.trimIndent()
  }

  private val ast_Prefixes: String by lazy {
    """per,,,{0} per {1}
        """.trimIndent()
  }

  private val az_Units: String by lazy {
    """g-force,g qüvvəsi,,,{0} G,g qüvvəsi,,,{0} G,g qüvvəsi,,{0} g qüvvəsi,{0} g qüvvəsi
        meter-per-square-second,,,,,metr/s²,,,{0} m/s²,metr kvadrat saniyə,,{0} metr kvadrat saniyə,{0} metr kvadrat saniyə
        arc-minute,dəqiqə,,{0}′,{0}dəq,dəqiqə,,{0}dəq,{0}dəq,dəqiqə,,{0} dəqiqə,{0} dəqiqə
        arc-second,saniyə,,{0}san,{0}san,saniyə,,{0}san,{0}san,saniyə,,{0} saniyə,{0} saniyə
        degree,dərəcə,,{0} dər,{0} dər,dərəcə,,{0} dər,{0} dər,dərəcə,,{0} dərəcə,{0} dərəcə
        radian,,,,,,,,,radian,,{0} radian,{0} radian
        revolution,döv,,{0} döv,{0} döv,döv,,{0} döv,{0} döv,dövrə,,{0} dövrə,{0} dövrə
        acre,akr,,{0} ak,{0} ak,akr,,{0} ak,{0} ak,akr,,{0} akr,{0} akr
        dunam,dönüm,,{0} dönüm,{0} dönüm,dönüm,,{0} dönüm,{0} dönüm,dönüm,,{0} dönüm,{0} dönüm
        hectare,hektar,,,{0} ha,hektar,,,{0} ha,hektar,,{0} hektar,{0} hektar
        square-centimeter,sm²,{0}/sm²,{0} sm²,{0} sm²,sm²,{0}/sm²,{0} sm²,{0} sm²,kvadrat santimetr,{0}/sm²,{0} kvadrat santimetr,{0} kvadrat santimetr
        square-foot,ft²,,{0} ft²,{0} ft²,kvadrat fut,,{0} kv ft,{0} kv ft,kvadrat fut,,{0} kvadrat fut,{0} kvadrat fut
        square-inch,,,,,,,,,kvadrat düym,{0}/in²,{0} kvadrat düym,{0} kvadrat düym
        square-kilometer,km²,{0}/km²,{0} km²,{0} km²,kvadrat kilometr,{0}/km²,{0} kv km,{0} kv km,kvadrat kilometr,{0}/km²,{0} kvadrat kilometr,{0} kvadrat kilometr
        square-meter,metr²,{0}/m²,{0} m²,{0} m²,kvadrat metr,{0}/m²,{0} kv m,{0} kv m,kvadrat metr,{0}/m²,{0} kvadrat metr,{0} kvadrat metr
        square-mile,mil²,{0}/mil²,{0} mil²,{0} mil²,kvadrat mil,{0}/mi²,{0} kv mil,{0} kv mil,kvadrat mil,{0}/mi²,{0} kvadrat mil,{0} kvadrat mil
        item,element,,{0} element,{0} element,element,,{0} element,{0} element,element,,{0} element,{0} element
        karat,,,,,,,,,karat,,{0} karat,{0} karat
        milligram-ofglucose-per-deciliter,,,,,,,,,milliqram/desilitr,,{0} milliqram/desilitr,{0} mg/dL
        millimole-per-liter,millimol/litr,,{0} mmol/l,{0} mmol/l,millimol/litr,,{0} mmol/l,{0} mmol/l,millimol/litr,,{0} millimol/litr,{0} millimol/litr
        percent,,,,,faiz,,,{0}%,faiz,,{0} faiz,{0} faiz
        permille,,,,,promil,,,{0}‰,promil,,{0} promil,{0} promil
        permillion,hissəcik/milyon,,{0} hs/mln,{0}ppm,hissəcik/milyon,,{0} hs/mln,{0} hs/mln,milyonda hissəcik,,{0} milyonda hissəcik,{0} milyonda hissəcik
        permyriad,,,,,permiriada,,,{0}‱,permiriada,,{0} permiriada,{0} permiriada
        portion-per-1e9,hissə/milyard,,,{0} ppb,hissə/milyard,,,{0} ppb,bir milyarda düşən hissə sayı,,bir milyarda düşən {0} hissə,bir milyarda düşən {0} hissə
        liter-per-100-kilometer,l/100km,,{0} l/100km,{0} l/100km,l/100km,,{0} l/100km,{0} l/100km,100 kilometrə litr,,100 kilometrə {0} litr,100 kilometrə {0} litr
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,litr/kilometr,,{0} litr/kilometr,{0} litr/kilometr
        mile-per-gallon,mil/qal,,{0} mil/qal,{0} mil/qal,mil/qal,,{0} mil/qal,{0} mil/qal,qallona mil,,qallona {0} mil,qallona {0} mil
        mile-per-gallon-imperial,mil/imp. qal,,{0} mil/imq,{0} mil/imq,mil/imp. qal,,{0} m/q imp,{0} m/q imp,imp. qallona mil,,imp. qallona {0} mil,imp. qallona {0} mil
        byte,bayt,,{0} bayt,{0} bayt,bayt,,{0} bayt,{0} bayt,bayt,,{0} bayt,{0} bayt
        gigabit,,,,,,,,,giqabit,,{0} giqabit,{0} giqabit
        gigabyte,,,,,,,,,giqabayt,,{0} giqabayt,{0} giqabayt
        kilobit,,,,,,,,,kilobit,,{0} kilobit,{0} kilobit
        kilobyte,,,,,,,,,kilobayt,,{0} kilobayt,{0} kilobayt
        megabit,,,,,,,,,meqabit,,{0} meqabit,{0} meqabit
        megabyte,,,,,,,,,meqabayt,,{0} meqabayt,{0} meqabayt
        petabyte,PBayt,,,{0} PB,PBayt,,,{0} PB,petabayt,,{0} petabayt,{0} petabayt
        terabit,,,,,,,,,terabit,,{0} terabit,{0} terabit
        terabyte,,,,,,,,,terabayt,,{0} terabayt,{0} terabayt
        century,əsr,,{0} əsr,{0} əsr,əsr,,{0} əsr,{0} əsr,əsr,,{0} əsr,{0} əsr
        day,gün,{0}/gün,{0} gün,{0} gün,gün,{0}/gün,{0} gün,{0} gün,gün,{0}/gün,{0} gün,{0} gün
        decade,dek,,{0} dek,{0} dek,dek,,{0} dek,{0} dek,dekada,,{0} dekada,{0} dek
        hour,saat,{0}/saat,{0} saat,{0} saat,saat,{0}/saat,{0} saat,{0} saat,saat,{0}/saat,{0} saat,{0} saat
        microsecond,μsan,,{0} μsan,{0} μsan,μsan,,{0} μsan,{0} μsan,mikrosaniyə,,{0} mikrosaniyə,{0} mikrosaniyə
        millisecond,msan,,{0} msan,{0} msan,millisaniyə,,{0} msan,{0} msan,millisaniyə,,{0} millisaniyə,{0} millisaniyə
        minute,dəq,{0}/dəq,{0} dəq,{0} dəq,dəqiqə,{0}/dəq,{0} dəq,{0} dəq,dəqiqə,{0}/dəqiqə,{0} dəqiqə,{0} dəqiqə
        month,ay,{0}/ay,{0} ay,{0} ay,ay,{0}/ay,{0} ay,{0} ay,ay,{0}/ay,{0} ay,{0} ay
        nanosecond,nsan,,{0} nsan,{0} nsan,nsan,,{0} nsan,{0} nsan,nanosaniyə,,{0} nanosaniyə,{0} nanosaniyə
        night,gecə,{0}/gecə,{0}gecə,{0}gecə,gecə,{0}/gecə,{0} gecə,{0} gecə,gecə,{0}/gecə,{0} gecə,{0} gecə
        quarter,rüb,{0}/r,{0} r,{0} r,rüb,{0}/r,{0} r,{0} r,rüb,{0}/r,{0} r,{0} r
        second,san,{0}/san,{0} san,{0} san,saniyə,{0}/san,{0} san,{0} san,saniyə,{0}/saniyə,{0} saniyə,{0} saniyə
        week,hft,{0}/hft,{0} hft,{0} hft,həftə,{0}/hft,{0} hft,{0} hft,həftə,{0}/həftə,{0} həftə,{0} həftə
        year,il,{0}/il,{0} il,{0} il,il,{0}/il,{0} il,{0} il,il,{0}/il,{0} il,{0} il
        ampere,,,,,,,,,amper,,{0} amper,{0} amper
        milliampere,,,,,,,,,milliamper,,{0} milliamper,{0} milliamper
        ohm,om,,,{0} Ω,om,,,{0} Ω,om,,{0} om,{0} om
        volt,,,,,,,,,volt,,{0} volt,{0} volt
        british-thermal-unit,BTV,,{0} Btv,{0} Btv,BTV,,{0} Btv,{0} Btv,Britaniya termal vahidi,,{0} Britaniya terman vahidi,{0} Britaniya terman vahidi
        calorie,kal,,{0} kal,{0} kal,kal,,{0} kal,{0} kal,kalori,,{0} kalori,{0} kalori
        electronvolt,,,,,elektronvolt,,,{0} eV,elektronvolt,,{0} elektronvolt,{0} elektronvolt
        foodcalorie,Kal,,{0} Kal,{0} Kal,Kal,,{0} Kal,{0} Kal,Kalori,,{0} Kalori,{0} Kalori
        joule,coul,,{0} c,{0} c,coul,,{0} c,{0} c,coul,,{0} coul,{0} coul
        kilocalorie,kkal,,{0} kkal,{0} kkal,kkal,,{0} kkal,{0} kkal,kilokalori,,{0} kilokalori,{0} kilokalori
        kilojoule,kc,,{0} kc,{0} kc,kc,,{0} kc,{0} kc,kilocoul,,{0} kilocoul,{0} kilocoul
        kilowatt-hour,kVt/saat,,{0} kVt/saat,{0} kVt/saat,,,,,kilovatt-saat,,{0} kilovatt-saat,{0} kilovatt-saat
        therm-us,ABŞ tv,,{0} ABŞ tv,{0} ABŞ tv,ABŞ tv,,{0} ABŞ tv,{0} ABŞ tv,ABŞ termal vahidi,,{0} ABŞ termal vahidi,{0} ABŞ termal vahidi
        kilowatt-hour-per-100-kilometer,kVtst/100km,,{0} kVts/100km,{0} kVts/100km,kVtst/100km,,{0} kWh/100km,{0} kVtst/100km,kVtst/100km,,{0} kVtst/100km,{0} kVtst/100km
        newton,,,,,nyuton,,,{0} N,nyuton,,{0} nyuton,{0} nyuton
        pound-force,güc funtu,,,{0} lbf,güc funtu,,,{0} lbf,güc funtu,,{0} güc funtu,{0} güc funtu
        gigahertz,,,,,,,,,giqahers,,{0} giqahers,{0} giqahers
        hertz,,,,,,,,,hers,,{0} hers,{0} hers
        kilohertz,,,,,,,,,kilohers,,{0} kilohers,{0} kilohers
        megahertz,,,,,,,,,meqahers,,{0} meqahers,{0} meqahers
        dot,nöqtə,,{0} nöqtə,{0} nöqtə,nöqtələr,,{0} nöqtə,{0} nöqtə,nöqtələr,,{0} nöqtə,{0} nöqtə
        dot-per-centimeter,nöq / sm,,{0} nöq/sm,{0} nöq/sm,nöq / sm,,{0} nöq/sm,{0} nöq/sm,nöqtə / santimetr,,{0} nöqtə / santimetr,{0} nöqtə / santimetr
        dot-per-inch,nöq/düym,,{0} nöq/düym,{0} nöq/düym,nöq/düym,,{0} nöq/düym,{0} nöq/düym,nöqtə / düym,,{0} nöqtə / düym,{0} nöqtə / düym
        em,,,,,,,,,tipoqraf emi,,,{0} em
        megapixel,meqapiksel,,,{0} MP,meqapiksel,,,{0} MP,meqapiksel,,{0} meqapiksel,{0} meqapiksel
        pixel,piksel,,,{0} px,piksel,,,{0} px,piksel,,{0} piksel,{0} piksel
        pixel-per-centimeter,p/sm,,{0} p/sm,{0} p/sm,,,,,piksel / santimetr,,{0} piksel / santimetr,{0} piksel / santimetr
        pixel-per-inch,p/i,,{0} p/i,{0} p/i,,,,,piksel / düym,,{0} piksel / düym,{0} piksel / düym
        astronomical-unit,av,,{0} av,{0} av,av,,{0} av,{0} av,astronomik vahid,,{0} astronomik vahid,{0} astronomik vahid
        centimeter,sm,{0}/sm,{0} sm,{0} sm,sm,{0}/sm,{0} sm,{0} sm,santimetr,{0}/sm,{0} santimetr,{0} santimetr
        earth-radius,,,,,yer radiusu,,,{0} R⊕,yer radiusu,,{0} yer radiusu,{0} yer radiusu
        fathom,fatom,,,{0} fth,fatom,,,{0} fth,fatom,,{0} fatom,{0} fatom
        foot,,,,,fut,{0}/ft,,{0} ft,fut,{0}/ft,{0} fut,{0} fut
        furlong,farlonq,,{0} far,{0} far,farlonq,,{0} farlonq,{0} farlonq,farlonq,,{0} farlonq,{0} farlonq
        inch,düym,{0}/in,,{0} in,düym,{0}/in,,{0} in,düym,{0}/in,{0} düym,{0} düym
        kilometer,kilometr,{0}/km,,{0} km,kilometr,{0}/km,,{0} km,kilometr,{0}/km,{0} kilometr,{0} kilometr
        light-year,ii,,{0} ii,{0} ii,işıq ili,,{0} ii,{0} ii,işıq ili,,{0} işıq ili,{0} işıq ili
        meter,metr,{0}/m,,{0} m,metr,{0}/m,,{0} m,metr,{0}/m,{0} metr,{0} metr
        mile,mil,,{0} mil,{0} mil,mil,,{0} mil,{0} mil,mil,,{0} mil,{0} mil
        millimeter,millimetr,,,{0} mm,millimetr,,,{0} mm,millimetr,,{0} millimetr,{0} millimetr
        picometer,,,,,pikometr,,,{0} pm,pikometr,,{0} pikometr,{0} pikometr
        point,xal,,{0} xal,{0} xal,xal,,{0} xal,{0} xal,xal,,{0} xal,{0} xal
        solar-radius,,,,,günəş radiusu,,,{0} R☉,Günəş radiusu,,{0} günəş radiusu,{0} günəş radiusu
        yard,,,,,yard,,,{0} yd,yard,,{0} yard,{0} yard
        candela,kd,,{0} kd,{0} kd,kd,,{0} kd,{0} kd,kandela,,{0} kandela,{0} kandela
        lumen,,,,,,,,,lümen,,{0} lümen,{0} lümen
        lux,,,,,,,,,lüks,,{0} lüks,{0} lüks
        solar-luminosity,gün işığı,,,{0} L☉,gün işığı,,,{0} L☉,gün işığı,,{0} gün işığı,{0} gün işığı
        carat,karat,,,{0} CD,,,,,karat,,{0} karat,{0} karat
        dalton,,,,,dalton,,,{0} Da,dalton,,{0} dalton,{0} dalton
        earth-mass,,,,,yer kütləsi,,,{0} M⊕,yer kütləsi,,{0} yer kütləsi,{0} yer kütləsi
        grain,qranul,,{0} qranul,{0} qranul,qranul,,{0} qranul,{0} qranul,qranul,,{0} qranul,{0} qranul
        gram,qram,{0}/q,{0} q,{0} q,qram,{0}/q,{0} q,{0} q,qram,{0}/q,{0} qram,{0} qram
        kilogram,kiloqram,{0}/kq,{0} kq,{0} kq,kiloqram,{0}/kq,{0} kq,{0} kq,kiloqram,{0}/kq,{0} kiloqram,{0} kiloqram
        microgram,μq,,{0} μq,{0} μq,μq,,{0} μq,{0} μq,mikroqram,,{0} mikroqram,{0} mikroqram
        milligram,mq,,{0} mq,{0} mq,mq,,{0} mq,{0} mq,milliqram,,{0} milliqram,{0} milliqram
        ounce,unsiya,{0}/oz,,{0} oz,unsiya,{0}/oz,,{0} oz,unsiya,{0}/oz,{0} unsiya,{0} unsiya
        ounce-troy,,,,,,,,,troy unsiyası,,{0} troy unsiyası,{0} troy unsiyası
        pound,funt,{0}/lb,,{0} lb,funt,{0}/lb,,{0} lb,funt,{0}/lb,{0} funt,{0} funt
        solar-mass,,,,,günəş kütləsi,,,{0} M☉,günəş kütləsi,,{0} günəş kütləsi,{0} günəş kütləsi
        stone,stoun,,{0} stoun,{0} stoun,stone,,{0} stone,{0} stone,stone,,{0} stone,{0} stone
        ton,,,,,,,,,ton,,{0} ton,{0} ton
        tonne,,,,,,,,,metrik ton,,{0} metrik ton,{0} metrik ton
        gigawatt,GVt,,{0} GVt,{0} GVt,,,,,giqavatt,,{0} giqavatt,{0} giqavatt
        horsepower,ag,,{0} ag,{0} ag,at gücü,,,{0} hp,at gücü,,{0} at gücü,{0} at gücü
        kilowatt,kVt,,{0} kVt,{0} kVt,kilovatt,,,{0} kW,kilovatt,,{0} kilovatt,{0} kilovatt
        megawatt,MVt,,{0} MVt,{0} MVt,,,,,meqavatt,,{0} meqavatt,{0} meqavatt
        milliwatt,mVt,,{0} mVt,{0} mVt,,,,,millivatt,,{0} millivatt,{0} millivatt
        watt,Vt,,{0} Vt,{0} Vt,vatt,,,{0} W,vatt,,{0} vatt,{0} vatt
        atmosphere,,,,,,,,,atmosfer,,{0} atmosfer,{0} atmosfer
        hectopascal,hektopaskal,,,{0} hPa,hektopaskal,,,{0} hPa,hektopaskal,,{0} hektopaskal,{0} hektopaskal
        inch-ofhg,civə düymü,,{0} inHg,{0} inHg,civə düymü,,{0} civə düymü,{0} civə düymü,civə düymü,,{0} civə düymü,{0} civə düymü
        kilopascal,,,,,,,,,kilopaskal,,{0} kilopaskal,{0} kilopaskal
        megapascal,,,,,,,,,meqapaskal,,{0} meqapaskal,{0} meqapaskal
        millibar,millibar,,{0} mb,{0} mb,millibar,,,{0} mbar,millibar,,{0} millibar,{0} millibar
        millimeter-ofhg,,,,,,,,,millimetr civə sütunu,,{0} millimetr civə sütunu,{0} millimetr civə sütunu
        pascal,,,,,,,,,paskal,,{0} paskal,{0} paskal
        pound-force-per-square-inch,,,,,,,,,funt/kvadrat düym,,{0} funt/kvadrat düym,{0} funt/kvadrat düym
        beaufort,Bofor,,,B {0},Bofor,,,B {0},Bofor,,Bofor {0},Bofor {0}
        kilometer-per-hour,kilometr/saat,,{0} km/saat,{0} km/saat,kilometr/saat,,{0} km/saat,{0} km/saat,kilometr/saat,,{0} kilometr/saat,{0} kilometr/saat
        light-speed,işıq,,{0}işıq,{0}işıq,işıq,,{0} işıq,{0} işıq,işıq,,{0} işıq,{0} işıq
        meter-per-second,,,,,metr/saniyə,,,{0} m/s,metr/saniyə,,{0} metr/saniyə,{0} metr/saniyə
        mile-per-hour,mil/saat,,{0} mil/saat,{0} mil/saat,mil/saat,,{0} mil/saat,{0} mil/saat,mil/saat,,{0} mil/saat,{0} mil/saat
        celsius,°C,,{0}°,{0}°,dərəcə Selsi,,,{0}°C,dərəcə Selsi,,{0} dərəcə Selsi,{0} dərəcə Selsi
        fahrenheit,,,,,dərəcə Farengeyt,,,{0}°F,dərəcə Farengeyt,,{0} dərəcə Farengeyt,{0} dərəcə Farengeyt
        kelvin,,,,,,,,,dərəcə Kelvin,,{0} dərəcə Kelvin,{0} dərəcə Kelvin
        newton-meter,,,,,,,,,nyuton-metr,,{0} nyuton-metr,{0} nyuton-metr
        pound-force-foot,,,,,,,,,funt-fut,,{0} funt-fut,{0} funt-fut
        acre-foot,ak-ft,,{0} ak-ft,{0} ak-ft,,,,,akr-fut,,{0} akr-fut,{0} akr-fut
        barrel,,,,,,,,,barrel,,,{0} bbl
        bushel,buşel,,{0} buşel,{0} buşel,buşel,,{0} buşel,{0} buşel,buşel,,{0} buşel,{0} buşel
        centiliter,sl,,{0} sl,{0} sl,sL,,{0} sL,{0} sL,santilitr,,{0} santilitr,{0} santilitr
        cubic-centimeter,sm³,{0}/sm³,{0} sm³,{0} sm³,sm³,{0}/sm³,{0} sm³,{0} sm³,kub santimetr,{0}/sm³,{0} kub santimetr,{0} kub santimetr
        cubic-foot,,,,,,,,,kub fut,,{0} kub fut,{0} kub fut
        cubic-inch,,,,,,,,,kub düym,,{0} kub düym,{0} kub düym
        cubic-kilometer,,,,,,,,,kub kilometr,,{0} kub kilometr,{0} kub kilometr
        cubic-meter,,,,,,,,,kub metr,{0}/m³,{0} kub metr,{0} kub metr
        cubic-mile,mil³,,{0} mil³,{0} mil³,kub mil,,{0} mil³,{0} mil³,kub mil,,{0} kub mil,{0} kub mil
        cubic-yard,,,,,,,,,kub yard,,{0} kub yard,{0} kub yard
        cup,st,,{0} st,{0} st,st,,{0} st,{0} st,stəkan,,{0} stəkan,{0} stəkan
        deciliter,dl,,{0} dl,{0} dl,,,,,desilitr,,{0} desilitr,{0} desilitr
        dessert-spoon,dsp,,{0} dsp,{0} dsp,des.qaş.,,{0} des.qaş.,{0} des.qaş.,dessert qaşığı,,{0} dessert qaşığı,{0} dessert qaşığı
        dessert-spoon-imperial,des.qaş. İmp.,,{0}dsp-Imp,{0}dsp-Imp,des.qaş. İmp.,,{0} des.qaş. İmp,{0} des.qaş. İmp.,İmp. dessert qaşığı,,{0} İmp. dessert qaşığı,{0} İmp. dessert qaşığı
        dram,dram,,{0} dram,{0} dram,dram,,{0} dram,{0} dram,dram,,{0} dram,{0} dram
        drop,dc,,{0} dc,{0} dc,damcı,,{0} damcı,{0} damcı,damcı,,{0} damcı,{0} damcı
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,maye unsiyası,,{0} maye unsiyası,{0} maye unsiyası
        fluid-ounce-imperial,İmp. fl oz,,{0}fl oz Im,{0}fl oz Im,İmp. fl oz,,{0} fl oz İmp.,{0} fl oz İmp.,İmp. maye unsiyası,,{0} fl oz İmp.,{0} fl oz İmp.
        gallon,qal,{0}/qal,{0} qal,{0} qal,qal,{0}/qal,{0} qal,{0} qal,qallon,{0}/qal,{0} qallon,{0} qallon
        gallon-imperial,İmp. qal,{0}/imp. qal,{0} imp.qal,{0} imp.qal,İmp. qal,{0}/imp. qal,{0} imp. qal,{0} imp. qal,İmp. qallon,{0}/imp. qallon,{0} imp. qallon,{0} imp. qallon
        hectoliter,hl,,{0} hl,{0} hl,,,,,hektolitr,,{0} hektolitr,{0} hektolitr
        liter,litr,{0}/l,,{0} l,litr,{0}/l,,{0} l,litr,{0}/l,{0} litr,{0} litr
        megaliter,Ml,,{0} Ml,{0} Ml,,,,,meqalitr,,{0} meqalitr,{0} meqalitr
        milliliter,ml,,{0} ml,{0} ml,,,,,millilitr,,{0} millilitr,{0} millilitr
        pinch,çimdik,,{0} çimdik,{0} çimdik,çimdik,,{0} çimdik,{0} çimdik,çimdik,,{0} çimdik,{0} çimdik
        pint,,,,,,,,,pint,,{0} pint,{0} pint
        quart,,,,,,,,,kvart,,{0} kvart,{0} kvart
        quart-imperial,kvarta İmp.,,{0}qt-Imp.,{0}qt-Imp.,kvarta İmp.,,{0} kvarta İmp.,{0} kvarta İmp.,İmp. kvarta,,{0} İmp. kvarta,{0} İmp. kvarta
        tablespoon,xrqş,,{0} xrqş,{0} xrqş,xrqş,,{0} xrqş,{0} xrqş,xörək qaşığı,,{0} xörək qaşığı,{0} xörək qaşığı
        teaspoon,çyqş,,{0} çyqş,{0} çyqş,çyqş,,{0} çyqş,{0} çyqş,çay qaşığı,,{0} çay qaşığı,{0} çay qaşığı
        parsec,ps,,{0} ps,{0} ps,,,,,,,,
        cup-metric,mfincan,,{0} mf,{0} mf,,,,,,,,
        pint-metric,pt,,,{0} mpt,,,,,,,,
        """.trimIndent()
  }

  private val az_Prefixes: String by lazy {
    """square,,,kvadrat {0}
        cubic,,,kub {0}
        1024p1,ki{0},ki{0},kibi{0}
        1024p2,mi{0},mi{0},mebi{0}
        1024p3,gi{0},gi{0},gibi{0}
        1024p4,ti{0},ti{0},tebi{0}
        1024p5,pi{0},pi{0},pebi{0}
        1024p6,ei{0},ei{0},eksbi{0}
        1024p7,zi{0},zi{0},zebi{0}
        1024p8,yi{0},yi{0},yobe{0}
        10p-1,,,desi{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,s{0},s{0},santi{0}
        10p-21,,,zepto{0}
        10p-24,,,yokto{0}
        10p-27,,,ronto {0}
        10p-3,,,milli{0}
        10p-30,k {0},k {0},kvekto {0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,eksa{0}
        10p2,,,hekto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna {0}
        10p3,,kq{0},kilo{0}
        10p30,K {0},K {0},kvetta {0}
        10p6,,,meqa{0}
        10p9,,,giqa{0}
        """.trimIndent()
  }

  private val az_Arab_Units: String? = null

  private val az_Arab_Prefixes: String? = null

  private val az_Arab_IQ_Units: String? = null

  private val az_Arab_IQ_Prefixes: String? = null

  private val az_Arab_TR_Units: String? = null

  private val az_Arab_TR_Prefixes: String? = null

  private val az_Cyrl_Units: String? = null

  private val az_Cyrl_Prefixes: String? = null

  private val az_Latn_Units: String? = null

  private val az_Latn_Prefixes: String? = null

  private val ba_Units: String? = null

  private val ba_Prefixes: String? = null

  private val bal_Units: String? = null

  private val bal_Prefixes: String? = null

  private val bal_Arab_Units: String? = null

  private val bal_Arab_Prefixes: String? = null

  private val bal_Latn_Units: String by lazy {
    """century,k,,{0} k,{0} k,k,,{0} k,{0} k,karn,,{0} karn,{0} karn
        day,róch,{0}/róché,{0} róch,{0} róch,róch,{0}/róché,{0} róch,{0} róch,róch,{0}/róché,{0} róch,{0} róch
        decade,Dah,,{0} Dah,{0} Dah,Dah,,{0} Dah,{0} Dah,Dahekk,,{0} Dahekk,{0} Dahekk
        hour,sáhat,{0}/sáhaté,{0} sáhat,{0} sáhat,st,{0}/sáhaté,{0} sáhat,{0} sáhat,sáhat,{0}/sáhaté,{0} sáhat,{0} sáhat
        microsecond,máikrósekendh,,{0} máikrósekendh,{0} máikrósekendh,μs,,{0} máikrósekendh,{0} máikrósekendh,máikrósekendh,,{0} máikrósekendh,{0} máikrósekendh
        millisecond,milisekendh,,{0} milisekendh,{0} milisekendh,ms,,{0} milisekendh,{0} milisekendh,milisekendh,,{0} milisekendh,{0} milisekendh
        minute,meletth,{0}/meletth,{0} meletth,{0} meletth,meletth,{0}/meletth,{0} meletth,{0} meletth,meletth,{0}/meletth,{0} meletth,{0} meletth
        month,máh,{0}/máhé,{0} máh,{0} máh,máh,{0}/máhé,{0} máh,{0} máh,máh,{0}/máhé,{0} máh,{0} máh
        nanosecond,nénósekendh,,{0} nénósekendh,{0} nénósekendh,nénósekendh,,{0} nénósekendh,{0} nénósekendh,nénósekendh,,{0} nénósekendh,{0} nénósekendh
        night,shap,{0}/shapé,{0} shap,{0} shap,shap,{0}/shapé,{0} shap,{0} shap,shap,{0}/shapé,{0} shap,{0} shap
        quarter,chárek,{0}/chárek,{0} chárek,{0} chárek,chárek,{0}/chárek,{0} chárek,{0} chárek,chárek,{0}/chárek,{0} chárek,{0} chárek
        second,sekendh,{0}/sekendhé,{0} sekendh,{0} sekendh,sekendh,{0}/sekendhé,{0} sekendh,{0} sekendh,sekendh,{0}/sekendhé,{0} sekendh,{0} sekendh
        week,haptag,{0}/haptagé,{0} haptag,{0} haptag,haptag,{0}/haptagé,{0} haptag,{0} haptag,haptag,{0}/haptagé,{0} haptag,{0} haptag
        year,sl,{0}/sál,{0} sál,{0} sál,sál,{0}/sál,{0} sál,{0} sál,sál,{0}/sálé,{0} sál,{0} sál
        pixel,pks,,{0} pks,{0} pks,pks,,{0} pks,{0} pks,pks,,{0} pks,{0} pks
        pixel-per-centimeter,ppsm,,{0} ppsm,{0} ppsm,ppsm,,{0} ppsm,{0} ppsm,ppsm,,{0} ppsm,{0} ppsm
        centimeter,santimitar,{0}/santimitar,{0} santimitar,{0} santimitar,sm,{0}/smé,{0} santimitar,{0} sm,santimitar,{0}/santimitaré,{0} santimitar,{0} santimitar
        decimeter,dm,,{0} désimitar,{0} désimitar,dm,,{0} désimitar,{0} désimitar,désimitar,,{0} désimitar,{0} désimitar
        kilometer,km,{0}/kmé,,{0} km,km,{0}/kmé,,{0} km,kilómitar,{0}/kilómitaré,,{0} km
        meter,mitar,{0}/mitaré,{0} mitar,{0} mitar,mitar,{0}/mitaré,{0} mitar,{0} mitar,mitar,{0}/mitaré,{0} mitar,{0} mitar
        micrometer,máikrómitar,,{0} máikrómitar,{0} máikrómitar,,,,,máikrómitar,,{0} máikrómitar,{0} máikrómitar
        mile-scandinavian,Skándi-mil,,{0} Skándi-mil,{0} Skándi-mil,smi,,{0} Skándi-mil,{0} Skándi-mil,Skándi-mil,,{0} Skándi-mil,{0} Skándi-mil
        millimeter,,,,,,,,,milimitar,,,{0} mm
        nanometer,nénómitar,,{0} nénómitar,{0} nénómitar,,,,,nénómitar,,{0} nénómitar,{0} nénómitar
        picometer,pikómitar,,{0} pikómitar,{0} pikómitar,pm,,{0} pikómitar,{0} pikómitar,pikómitar,,{0} pikómitar,{0} pikómitar
        point,noktah,,{0} noktah,{0} noktah,nk,,{0} nk,{0} noktah,noktah,,{0} noktah,{0} noktah
        """.trimIndent()
  }

  private val bal_Latn_Prefixes: String? = null

  private val bas_Units: String? = null

  private val bas_Prefixes: String? = null

  private val be_Units: String by lazy {
    """g-force,g,,{0} g,{0} g,g,,{0} g,{0} g,паскарэнне свабоднага падзення,,{0} g,{0} g
        meter-per-square-second,м/с²,,{0} м/с²,{0} м/с²,м/с²,,{0} м/с²,{0} м/с²,метры ў секунду ў квадраце,,{0} метр у секунду ў квадраце,{0} метра ў секунду ў квадраце
        arc-minute,′,,,{0}′,′,,,{0}′,вуглавыя мінуты,,{0} вуглавая мінута,{0} вуглавой мінуты
        arc-second,′′,,,{0}″,′′,,,{0}″,вуглавыя секунды,,{0} вуглавая секунда,{0} вуглавой секунды
        degree,°,,,{0}°,°,,,{0}°,градусы,,{0} градус,{0} градуса
        radian,рад,,{0} рад,{0} рад,рад,,{0} рад,{0} рад,радыяны,,{0} радыян,{0} радыяна
        revolution,аб,,{0} аб,{0} аб,аб,,{0} аб,{0} аб,абароты,,{0} абарот,{0} абарота
        acre,акры,,{0} акр,{0} акра,акры,,{0} акр,{0} акра,акры,,{0} акр,{0} акра
        dunam,дунамы,,{0} дунам,{0} дунама,дунамы,,{0} дунам,{0} дунама,дунамы,,{0} дунам,{0} дунама
        hectare,га,,{0} га,{0} га,га,,{0} га,{0} га,гектары,,{0} гектар,{0} гектара
        square-centimeter,см²,{0}/см²,{0} см²,{0} см²,см²,{0}/см²,{0} см²,{0} см²,квадратныя сантыметры,{0} на квадратны сантыметр,{0} квадратны сантыметр,{0} квадратнага сантыметра
        square-foot,кв. футы,,{0} кв. фут,{0} кв. фута,кв. футы,,{0} кв. фут,{0} кв. фута,квадратны фут,,{0} квадратны фут,{0} квадратнага фута
        square-inch,кв. цалі,{0}/кв. цалю,{0} кв. цаля,{0} кв. цалі,кв. цалі,{0}/кв. цалю,{0} кв. цаля,{0} кв. цалі,квадратныя цалі,{0} на квадратную цалю,{0} квадратная цаля,{0} квадратнай цалі
        square-kilometer,км²,{0}/км²,{0} км²,{0} км²,км²,{0}/км²,{0} км²,{0} км²,квадратныя кіламетры,{0} на квадратны кіламетр,{0} квадратны кіламетр,{0} квадратнага кіламетра
        square-meter,м²,{0}/м²,{0} м²,{0} м²,м²,{0}/м²,{0} м²,{0} м²,квадратныя метры,{0} на квадратны метр,{0} квадратны метр,{0} квадратнага метра
        square-mile,кв. мілі,{0}/кв. мілю,{0} кв. міля,{0} кв. мілі,кв. мілі,{0}/кв. мілю,{0} кв. міля,{0} кв. мілі,квадратныя мілі,{0} на квадратную мілю,{0} квадратная міля,{0} квадратнай мілі
        square-yard,кв. ярды,,{0} кв. ярд,{0} кв. ярда,кв. ярды,,{0} кв. ярд,{0} кв. ярда,квадратны ярд,,{0} квадратны ярд,{0} квадратнага ярда
        item,элем.,,{0} элем.,{0} элем.,элем.,,{0} элем.,{0} элем.,элемент,,{0} элемент,{0} элемента
        karat,кар,,{0} кар,{0} кар,кар,,{0} кар,{0} кар,караты,,{0} карат,{0} карата
        milligram-ofglucose-per-deciliter,мг/дл,,{0} мг/дл,{0} мг/дл,мг/дл,,{0} мг/дл,{0} мг/дл,міліграмы на дэцылітр,,{0} міліграм на дэцылітр,{0} міліграма на дэцылітр
        millimole-per-liter,ммоль/л,,{0} ммоль/л,{0} ммоль/л,ммоль/л,,{0} ммоль/л,{0} ммоль/л,мілімолі на літр,,{0} мілімоль на літр,{0} мілімоля на літр
        mole,моль,,{0} моль,{0} молі,моль,,{0} моль,{0} молі,молі,,{0} моль,{0} молі
        percent,%,,{0}%,{0}%,%,,{0} %,{0} %,працэнтаў,,{0} працэнт,{0} працэнта
        permille,‰,,{0} ‰,{0} ‰,‰,,{0} ‰,{0} ‰,праміле,,{0} праміле,{0} праміле
        permillion,,,,,,,,,часткі на мільён,,{0} частка на мільён,{0} часткі на мільён
        permyriad,‱,,{0} ‱,{0} ‱,‱,,{0} ‱,{0} ‱,базісныя пункты,,{0} базісны пункт,{0} базіснага пункта
        portion-per-1e9,ч/млрд,,{0} ч/млрд,{0} ч/млрд,частак/мільярд,,{0} ч/млрд,{0} ч/млрд,частак на мільярд,,{0} частка на мільярд,{0} часткі на мільярд
        liter-per-100-kilometer,л/100 км,,{0} л/100 км,{0} л/100 км,л/100 км,,{0} л/100 км,{0} л/100 км,літры на 100 кіламетраў,,{0} літр на 100 кіламетраў,{0} літра на 100 кіламетраў
        liter-per-kilometer,л/км,,{0} л/км,{0} л/км,л/км,,{0} л/км,{0} л/км,літры на кіламетр,,{0} літр на кіламетр,{0} літра на кіламетр
        mile-per-gallon,мілі/гал.,,{0} міля/гал.,{0} мілі/гал.,мілі/гал.,,{0} міля/гал.,{0} мілі/гал.,мілі на галон,,{0} міля на галон,{0} мілі на галон
        mile-per-gallon-imperial,міль/імп. гал.,,{0} міля/імп. гал.,{0} мілі/імп. гал.,міль/імп. гал.,,{0} міля/імп. гал.,{0} мілі/імп. гал.,міль на імп. галон,,{0} міля на імп. галон,{0} мілі на імп. галон
        bit,біт,,{0} біт,{0} біта,біт,,{0} біт,{0} біта,біты,,{0} біт,{0} біта
        byte,байт,,{0} байт,{0} байта,байт,,{0} байт,{0} байта,байты,,{0} байт,{0} байта
        gigabit,Гбіт,,{0} Гбіт,{0} Гбіт,Гбіт,,{0} Гбіт,{0} Гбіт,гігабіты,,{0} гігабіт,{0} гігабіта
        gigabyte,ГБ,,{0} ГБ,{0} ГБ,ГБ,,{0} ГБ,{0} ГБ,гігабайты,,{0} гігабайт,{0} гігабайта
        kilobit,кбіт,,{0} кбіт,{0} кбіт,кбіт,,{0} кбіт,{0} кбіт,кілабіты,,{0} кілабіт,{0} кілабіта
        kilobyte,КБ,,{0} КБ,{0} КБ,КБ,,{0} КБ,{0} КБ,кілабайты,,{0} кілабайт,{0} кілабайта
        megabit,Мбіт,,{0} Мбіт,{0} Мбіт,Мбіт,,{0} Мбіт,{0} Мбіт,мегабіты,,{0} мегабіт,{0} мегабіта
        megabyte,МБ,,{0} МБ,{0} МБ,МБ,,{0} МБ,{0} МБ,мегабайты,,{0} мегабайт,{0} мегабайта
        petabyte,ПБ,,{0} ПБ,{0} ПБ,ПБ,,{0} ПБ,{0} ПБ,петабайты,,{0} петабайт,{0} петабайта
        terabit,Тбіт,,{0} Тбіт,{0} Тбіт,Тбіт,,{0} Тбіт,{0} Тбіт,тэрабіты,,{0} тэрабіт,{0} тэрабіта
        terabyte,ТБ,,{0} ТБ,{0} ТБ,ТБ,,{0} ТБ,{0} ТБ,тэрабайты,,{0} тэрабайт,{0} тэрабайта
        century,ст.,,{0} ст.,{0} ст.,ст.,,{0} ст.,{0} ст.,стагоддзі,,{0} стагоддзе,{0} стагоддзя
        day,сут,{0}/сут,{0} сут,{0} сут,сут,{0}/сут,{0} сут,{0} сут,суткі,{0} у суткі,{0} суткі,{0} сутак
        decade,дзесяцігоддзе,,{0} дз.,{0} дз.,дзесяцігоддзе,,{0} дз.,{0} дз.,дзесяцігоддзі,,{0} дзесяцігоддзе,{0} дзесяцігоддзя
        hour,гадз,{0}/гадз,{0} гадз,{0} гадз,гадз,{0}/гадз,{0} гадз,{0} гадз,гадзіны,{0} у гадзіну,{0} гадзіна,{0} гадзіны
        microsecond,мкс,,{0} мкс,{0} мкс,мкс,,{0} мкс,{0} мкс,мікрасекунды,,{0} мікрасекунда,{0} мікрасекунды
        millisecond,мс,,{0} мс,{0} мс,мс,,{0} мс,{0} мс,мілісекунды,,{0} мілісекунда,{0} мілісекунды
        minute,хв,{0}/хв,{0} хв,{0} хв,хв,{0}/хв,{0} хв,{0} хв,хвіліны,{0} у хвіліну,{0} хвіліна,{0} хвіліны
        month,мес.,{0}/мес.,{0} мес.,{0} мес.,мес.,{0}/мес.,{0} мес.,{0} мес.,месяцы,{0} у месяц,{0} месяц,{0} месяца
        nanosecond,нс,,{0} нс,{0} нс,нс,,{0} нс,{0} нс,нанасекунды,,{0} нанасекунда,{0} нанасекунды
        night,ночы,{0}/ноч,{0} ноч,{0} ночы,ночы,{0}/ноч,{0} ноч,{0} ночы,ночы,{0} за ноч,{0} ноч,{0} ночы
        quarter,кв.,{0}/кв.,{0} кв.,{0} кв.,кв.,{0}/кв.,{0} кв.,{0} кв.,кварталы,{0} у квартал,{0} квартал,{0} квартала
        second,с,{0}/с,{0} с,{0} с,с,{0}/с,{0} с,{0} с,секунды,{0} у секунду,{0} секунда,{0} секунды
        week,тыдз,{0}/тыдз,{0} тыдз,{0} тыдз,тыдз,{0}/тыдз,{0} тыдз,{0} тыдз,тыдні,{0} у тыдзень,{0} тыдзень,{0} тыдня
        year,г.,{0}/г.,{0} г.,{0} г.,г.,{0}/г.,{0} г.,{0} г.,гады,{0} у год,{0} год,{0} года
        ampere,А,,,{0} A,А,,,{0} A,амперы,,{0} ампер,{0} ампера
        milliampere,мА,,{0} мА,{0} мА,мА,,{0} мА,{0} мА,міліамперы,,{0} міліампер,{0} міліампера
        ohm,Ом,,{0} Ом,{0} Ом,Ом,,{0} Ом,{0} Ом,омы,,{0} Ом,{0} Ом
        volt,В,,{0} В,{0} В,В,,{0} В,{0} В,вольты,,{0} вольт,{0} вольта
        british-thermal-unit,BTU,,{0} BTU,{0} BTU,BTU,,{0} BTU,{0} BTU,брытанскія цеплавыя адзінкі,,{0} брытанская цеплавая адзінка,{0} брытанскай цеплавой адзінкі
        calorie,кал,,{0} кал,{0} кал,кал,,{0} кал,{0} кал,калорыі,,{0} калорыя,{0} калорыі
        electronvolt,эВ,,{0} эВ,{0} эВ,эВ,,{0} эВ,{0} эВ,электрон-вольты,,{0} электрон-вольт,{0} электрон-вольта
        foodcalorie,кал,,{0} кал,{0} кал,кал,,{0} кал,{0} кал,калорыі,,{0} калорыя,{0} калорыі
        joule,Дж,,{0} Дж,{0} Дж,Дж,,{0} Дж,{0} Дж,джоўлі,,{0} джоўль,{0} джоўля
        kilocalorie,ккал,,{0} ккал,{0} ккал,ккал,,{0} ккал,{0} ккал,кілакалорыі,,{0} кілакалорыя,{0} кілакалорыі
        kilojoule,кДж,,{0} кДж,{0} кДж,кДж,,{0} кДж,{0} кДж,кіладжоўлі,,{0} кіладжоўль,{0} кіладжоўля
        kilowatt-hour,кВт г,,{0} кВт г,{0} кВт г,кВт г,,{0} кВт г,{0} кВт г,кілават-гадзіны,,{0} кілават-гадзіна,{0} кілават-гадзіны
        therm-us,амер. тэрмы,,{0} амер. тэрм,{0} амер. тэрма,амер. тэрмы,,{0} амер. тэрм,{0} амер. тэрмы,амерыканскія тэрмы,,{0} амерыканскі тэрм,{0} амерыканскага тэрма
        kilowatt-hour-per-100-kilometer,кВт г/100 км,,{0} кВт г/100 км,{0} кВт г/100 км,кВт г/100 км,,{0} кВт г/100 км,{0} кВт г/100 км,кілават-гадзіны на 100 кіламетраў,,{0} кілават-гадзіна на 100 кіламетраў,{0} кілават-гадзіны на 100 кіламетраў
        newton,Н,,{0} Н,{0} Н,Н,,{0} Н,{0} Н,ньютаны,,{0} ньютан,{0} ньютана
        pound-force,фунт-сілы,,{0} фунт-сіла,{0} фунт-сілы,фунт-сілы,,{0} фунт-сіла,{0} фунт-сіл,фунт-сілы,,{0} фунт-сіла,{0} фунт-сілы
        gigahertz,ГГц,,{0} ГГц,{0} ГГц,ГГц,,{0} ГГц,{0} ГГц,гігагерцы,,{0} гігагерц,{0} гігагерца
        hertz,Гц,,{0} Гц,{0} Гц,Гц,,{0} Гц,{0} Гц,герцы,,{0} герц,{0} герца
        kilohertz,кГц,,{0} кГц,{0} кГц,кГц,,{0} кГц,{0} кГц,кілагерцы,,{0} кілагерц,{0} кілагерца
        megahertz,МГц,,{0} МГц,{0} МГц,МГц,,{0} МГц,{0} МГц,мегагерцы,,{0} мегагерц,{0} мегагерца
        dot,кр,,{0} кр,{0} кр,кр,,{0} кр,{0} кр,кропкі,,{0} кропка,{0} кропкі
        dot-per-centimeter,кр/см,,{0} кр/см,{0} кр/см,кр/см,,{0} кр/см,{0} кр/см,кропкі на сантыметр,,{0} кропка на сантыметр,{0} кропкі на сантыметр
        dot-per-inch,кр/цал,,{0} кр/цал,{0} кр/цал,кр/цал,,{0} кр/цал,{0} кр/цал,кропкі на цалю,,{0} кропка на цалю,{0} кропкі на цалю
        em,эм,,{0} эм,{0} эм,эм,,{0} эм,{0} эм,эм,,{0} эм,{0} эм
        megapixel,Мпікс,,{0} Мпікс,{0} Мпікс,Мпікс,,{0} Мпікс,{0} Мпікс,мегапікселі,,{0} мегапіксель,{0} мегапікселя
        pixel,пікс,,{0} пікс,{0} пікс,пікс,,{0} пікс,{0} пікс,пікселі,,{0} піксель,{0} пікселя
        pixel-per-centimeter,пікс/см,,{0} пікс/см,{0} пікс/см,пікс/см,,{0} пікс/см,{0} пікс/см,пікселі на сантыметр,,{0} піксель на сантыметр,{0} пікселя на сантыметр
        pixel-per-inch,пікс/цал,,{0} пікс/цал,{0} пікс/цал,пікс/цал,,{0} пікс/цал,{0} пікс/цал,пікселі на цалю,,{0} піксель на цалю,{0} пікселя на цалю
        astronomical-unit,а. а.,,{0} а. а.,{0} а. а.,а. а.,,{0} а. а.,{0} а. а.,астранамічныя адзінкі,,{0} астранамічная адзінка,{0} астранамічнай адзінкі
        centimeter,см,{0}/см,{0} см,{0} см,см,{0}/см,{0} см,{0} см,сантыметры,{0} на сантыметр,{0} сантыметр,{0} сантыметра
        decimeter,дм,,{0} дм,{0} дм,дм,,{0} дм,{0} дм,дэцыметры,,{0} дэцыметр,{0} дэцыметра
        earth-radius,,,,,,,,,радыус Зямлі,,{0} радыус Зямлі,{0} радыуса Зямлі
        fathom,фат,,{0} фат,{0} фат,фат,,{0} фат,{0} фат,фатамы,,{0} фатам,{0} фатама
        foot,фт,{0}/фт,{0} фт,{0} фт,фт,{0}/фт,{0} фт,{0} фт,футы,{0} на фут,{0} фут,{0} фута
        furlong,фур,,{0} фур,{0} фур,фур,,{0} фур,{0} фур,фурлонгі,,{0} фурлонг,{0} фурлонга
        inch,цал,{0}/цал,{0} цал,{0} цал,цал,{0}/цал,{0} цал,{0} цал,цалі,{0} на цалю,{0} цаля,{0} цалі
        kilometer,км,{0}/км,{0} км,{0} км,км,{0}/км,{0} км,{0} км,кіламетры,{0} на кіламетр,{0} кіламетр,{0} кіламетра
        light-year,св. гады,,{0} св. год,{0} св. года,св. гады,,{0} св. год,{0} св. года,светлавыя гады,,{0} светлавы год,{0} светлавога года
        meter,м,{0}/м,{0} м,{0} м,м,{0}/м,{0} м,{0} м,метры,{0} на метр,{0} метр,{0} метра
        micrometer,мкм,,{0} мкм,{0} мкм,мкм,,{0} мкм,{0} мкм,мікраметры,,{0} мікраметр,{0} мікраметра
        mile,мілі,,{0} міля,{0} мілі,мілі,,{0} міля,{0} мілі,мілі,,{0} міля,{0} мілі
        mile-scandinavian,сканд. мілі,,{0} скан. мілі,{0} скан. мілі,сканд. мілі,,{0} скан. мілі,{0} скан. мілі,скандынаўскія мілі,,{0} скандынаўская міля,{0} скандынаўскай мілі
        millimeter,мм,,{0} мм,{0} мм,мм,,{0} мм,{0} мм,міліметры,,{0} міліметр,{0} міліметра
        nanometer,нм,,{0} нм,{0} нм,нм,,{0} нм,{0} нм,нанаметры,,{0} нанаметр,{0} нанаметра
        nautical-mile,мар. мілі,,{0} мар. міля,{0} мар. міль,мар. мілі,,{0} мар. міля,{0} мар. міль,марскія мілі,,{0} марская міля,{0} марской мілі
        parsec,пк,,{0} пк,{0} пк,пк,,{0} пк,{0} пк,парсекі,,{0} парсек,{0} парсека
        picometer,пм,,{0} пм,{0} пм,пм,,{0} пм,{0} пм,пікаметры,,{0} пікаметр,{0} пікаметра
        point,пт,,{0} пт,{0} пт,пт,,{0} пт,{0} пт,пункты,,{0} пункт,{0} пункта
        solar-radius,,,,,,,,,сонечныя радыусы,,{0} сонечны радыус,{0} сонечнага радыуса
        yard,ярды,,{0} ярд,{0} ярда,ярды,,{0} ярд,{0} ярда,ярды,,{0} ярд,{0} ярда
        candela,кд,,{0} кд,{0} кд,кд,,{0} кд,{0} кд,кандэла,,{0} кандэла,{0} кандэлы
        lumen,лм,,{0} лм,{0} лм,лм,,{0} лм,{0} лм,люмен,,{0} люмен,{0} люмена
        lux,лк,,{0} лк,{0} лк,лк,,{0} лк,{0} лк,люкс,,{0} люкс,{0} люкса
        solar-luminosity,,,,,,,,,сонечныя свяцільнасці,,{0} сонечная свяцільнасць,{0} сонечнай свяцільнасці
        carat,кар,,{0} кар,{0} кар,кар,,{0} кар,{0} кар,караты,,{0} карат,{0} карата
        dalton,Да,,{0} Да,{0} Да,Да,,{0} Да,{0} Да,дальтоны,,{0} дальтон,{0} дальтона
        earth-mass,,,,,,,,,масы Зямлі,,{0} маса Зямлі,{0} масы Зямлі
        grain,гран,,{0} гран,{0} грана,гран,,{0} гран,{0} грана,граны,,{0} гран,{0} грана
        gram,г,{0}/г,{0} г,{0} г,г,{0}/г,{0} г,{0} г,грамы,{0} за грам,{0} грам,{0} грама
        kilogram,кг,{0}/кг,{0} кг,{0} кг,кг,{0}/кг,{0} кг,{0} кг,кілаграмы,{0} за кілаграм,{0} кілаграм,{0} кілаграма
        microgram,мкг,,{0} мкг,{0} мкг,мкг,,{0} мкг,{0} мкг,мікраграмы,,{0} мікраграм,{0} мікраграма
        milligram,мг,,{0} мг,{0} мг,мг,,{0} мг,{0} мг,міліграмы,,{0} міліграм,{0} міліграма
        ounce,унц.,{0}/унц.,{0} унц.,{0} унц.,унц.,{0}/унц.,{0} унц.,{0} унц.,унцыі,{0} на унцыю,{0} унцыя,{0} унцыі
        ounce-troy,тр. унц.,,{0} тр. унц.,{0} тр. унц.,тр. унц.,,{0} тр. унц.,{0} тр. унц.,тройскія унцыі,,{0} тройская унцыя,{0} тройскай унцыі
        pound,фунты,{0}/фунт,{0} фунт,{0} фунта,фунты,{0}/фунт,{0} фунт,{0} фунта,фунты,{0} на фунт,{0} фунт,{0} фунта
        solar-mass,,,,,,,,,масы Сонца,,{0} маса Сонца,{0} масы Сонца
        stone,стоны,,{0} стон,{0} стона,стоны,,{0} стон,{0} стона,стоны,,{0} стон,{0} стона
        ton,амер. т,,{0} амер. т,{0} амер. т,амер. т,,{0} амер. т,{0} амер. т,амерыканскія тоны,,{0} амерыканская тона,{0} амерыканскай тоны
        tonne,т,,{0} т,{0} т,т,,{0} т,{0} т,тоны,,{0} тона,{0} тоны
        gigawatt,ГВт,,{0} ГВт,{0} ГВт,ГВт,,{0} ГВт,{0} ГВт,гігаваты,,{0} гігават,{0} гігавата
        horsepower,к. с.,,{0} к. с.,{0} к. с.,к. с.,,{0} к. с.,{0} к. с.,конская сіла,,{0} конская сіла,{0} конскай сілы
        kilowatt,кВт,,{0} кВт,{0} кВт,кВт,,{0} кВт,{0} кВт,кілаваты,,{0} кілават,{0} кілавата
        megawatt,МВт,,{0} МВт,{0} МВт,МВт,,{0} МВт,{0} МВт,мегаваты,,{0} мегават,{0} мегавата
        milliwatt,мВт,,{0} мВт,{0} мВт,мВт,,{0} мВт,{0} мВт,міліваты,,{0} міліват,{0} мілівата
        watt,Вт,,{0} Вт,{0} Вт,Вт,,{0} Вт,{0} Вт,ваты,,{0} ват,{0} вата
        atmosphere,атм,,{0} атм,{0} атм,атм,,{0} атм,{0} атм,атмасферы,,{0} атмасфера,{0} атмасферы
        bar,бар,,{0} бар,{0} бара,бар,,{0} бар,{0} бара,бары,,{0} бар,{0} бара
        hectopascal,гПа,,{0} гПа,{0} гПа,гПа,,{0} гПа,{0} гПа,гектапаскалі,,{0} гектапаскаль,{0} гектапаскаля
        inch-ofhg,цалі рт. сл.,,{0} цаля рт. сл.,{0} цалі рт. сл.,цалі рт. сл.,,{0} цаля рт. сл.,{0} цалі рт. сл.,цалі ртутнага слупа,,{0} цаля ртутнага слупа,{0} цалі ртутнага слупа
        kilopascal,кПа,,{0} кПа,{0} кПа,кПа,,{0} кПа,{0} кПа,кілапаскалі,,{0} кілапаскаль,{0} кілапаскаля
        megapascal,МПа,,{0} МПа,{0} МПа,МПа,,{0} МПа,{0} МПа,мегапаскалі,,{0} мегапаскаль,{0} мегапаскаля
        millibar,мбар,,{0} мбар,{0} мбар,мбар,,{0} мбар,{0} мбар,мілібары,,{0} мілібар,{0} мілібара
        millimeter-ofhg,мм рт. сл.,,{0} мм рт. сл.,{0} мм рт. сл.,мм рт. сл.,,{0} мм рт. сл.,{0} мм рт. сл.,міліметры ртутнага слупа,,{0} міліметр ртутнага слупа,{0} міліметра ртутнага слупа
        pascal,Па,,{0} Па,{0} Па,Па,,{0} Па,{0} Па,паскалі,,{0} паскаль,{0} паскаля
        pound-force-per-square-inch,фунты на кв. цалю,,{0} фунт на кв. цалю,{0} фунта на кв. цалю,фунты на кв. цалю,,{0} фунт на кв. цалю,{0} фунта на кв. цалю,фунты на квадратную цалю,,{0} фунт на квадратную цалю,{0} фунта на квадратную цалю
        beaufort,Бфт,,{0} Бфт,{0} Бфт,Бфт,,{0} Бфт,{0} Бфт,балы Бафорта,,{0} бал Бафорта,{0} бала Бафорта
        kilometer-per-hour,км/гадз,,{0} км/гадз,{0} км/гадз,км/гадз,,{0} км/гадз,{0} км/гадз,кіламетры за гадзіну,,{0} кіламетр за гадзіну,{0} кіламетра за гадзіну
        knot,вуз.,,{0} вуз.,{0} вуз.,вуз.,,{0} вуз.,{0} вуз.,вузел,,{0} вузел,{0} вузла
        meter-per-second,м/с,,{0} м/с,{0} м/с,м/с,,{0} м/с,{0} м/с,метры за секунду,,{0} метр за секунду,{0} метры за секунду
        mile-per-hour,мілі/гадз,,{0} міля/гадз,{0} мілі/гадз,мілі/гадз,,{0} міля/гадз,{0} мілі/гадз,мілі за гадзіну,,{0} міля за гадзіну,{0} мілі за гадзіну
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,градусы Цэльсія,,{0} градус Цэльсія,{0} градуса Цэльсія
        fahrenheit,°F,,{0} °F,{0} °F,°F,,{0} °F,{0} °F,градусы Фарэнгейта,,{0} градус Фарэнгейта,{0} градуса Фарэнгейта
        generic,°,,{0} °,{0} °,°,,{0} °,{0} °,°,,{0} °,{0} °
        kelvin,К,,{0} К,{0} К,К,,{0} К,{0} К,кельвіны,,{0} К,{0} кельвіна
        newton-meter,Н⋅м,,{0} Н⋅м,{0} Н⋅м,Н⋅м,,{0} Н⋅м,{0} Н⋅м,ньютан-метры,,{0} ньютан-метр,{0} ньютан-метра
        pound-force-foot,фунт-футы,,{0} фунт-фут,{0} фунт-фута,фунт-футы,,{0} фунт-фут,{0} фунт-фута,фунт-футы,,{0} фунт-фут,{0} фунт-фута
        acre-foot,акр-футы,,{0} акр-фут,{0} акр-фута,акр-футы,,{0} акр-фут,{0} акр-фута,акр-футы,,{0} акр-фут,{0} акр-фута
        barrel,барэль,,{0} барэль,{0} барэля,барэль,,{0} барэль,{0} барэля,барэлі,,{0} барэль,{0} барэля
        bushel,буш,,{0} буш,{0} буш,буш,,{0} буш,{0} буш,бушалі,,{0} бушаль,{0} бушаля
        centiliter,сл,,{0} сл,{0} сл,сл,,{0} сл,{0} сл,сантылітр,,{0} сантылітр,{0} сантылітра
        cubic-centimeter,см³,{0}/см³,{0} см³,{0} см³,см³,{0}/см³,{0} см³,{0} см³,кубічныя сантыметры,{0} на кубічны сантыметр,{0} кубічны сантыметр,{0} кубічнага сантыметра
        cubic-foot,куб. футы,,{0} куб. фут,{0} куб. фута,куб. футы,,{0} куб. фут,{0} куб. фута,кубічныя футы,,{0} кубічны фут,{0} кубічнага фута
        cubic-inch,куб. цалі,,{0} куб. цаля,{0} куб. цалі,куб. цалі,,{0} куб. цаля,{0} куб. цалі,кубічныя цалі,,{0} кубічная цаля,{0} кубічнай цалі
        cubic-kilometer,км³,,{0} км³,{0} км³,км³,,{0} км³,{0} км³,кубічныя кіламетры,,{0} кубічны кіламетр,{0} кубічнага кіламетра
        cubic-meter,м³,{0}/м³,{0} м³,{0} м³,м³,{0}/м³,{0} м³,{0} м³,кубічныя метры,{0} на кубічны метр,{0} кубічны метр,{0} кубічнага метра
        cubic-mile,куб. мілі,,{0} куб. міля,{0} куб. мілі,куб. мілі,,{0} куб. міля,{0} куб. мілі,кубічныя мілі,,{0} кубічная міля,{0} кубічнай мілі
        cubic-yard,куб. ярды,,{0} куб. ярд,{0} куб. ярда,куб. ярды,,{0} куб. ярд,{0} куб. ярда,кубічныя ярды,,{0} кубічны ярд,{0} кубічнага ярда
        cup,кубкі,,{0} кубак,{0} кубка,кубкі,,{0} кубак,{0} кубка,кубкі,,{0} кубак,{0} кубка
        cup-metric,мет. кубак,,{0} мет. кубак,{0} мет. кубка,мет. кубак,,{0} мет. кубак,{0} мет. кубка,метрычныя кубкі,,{0} метрычны кубак,{0} метрычнага кубка
        deciliter,дл,,{0} дл,{0} дл,дл,,{0} дл,{0} дл,дэцылітры,,{0} дэцылітр,{0} дэцылітра
        dessert-spoon,дэс. лыжка,,{0} дэс. лыжка,{0} дэс. лыжкі,дэс. лыжка,,{0} дэс. л.,{0} дэс. л.,дэсертныя лыжкі,,{0} дэсертная лыжка,{0} дэсертнай лыжкі
        dessert-spoon-imperial,брыт. дэс. лыжка,,{0} брыт. дэс. лыжка,{0} брыт. дэс. лыжкі,брыт. дэс. лыжка,,{0} брыт. дэс. лыжка,{0} брыт. дэс. лыжкі,брытанскія дэсертныя лыжкі,,{0} брытанская дэсертная лыжка,{0} брытанскай дэсертнай лыжкі
        dram,вад. драхма,,{0} вад. драхма,{0} вад. драхмы,вад. драхма,,{0} вад. драхма,{0} вад. драхмы,драхмы,,{0} драхма,{0} вад. драхмы
        drop,кропля,,{0} кропля,{0} кроплі,кропля,,{0} кропля,{0} кроплі,кроплі,,{0} кропля,{0} кроплі
        fluid-ounce,вадк. унц.,,{0} вадк. унц.,{0} вадк. унц.,вадк. унц.,,{0} вадк. унц.,{0} вадк. унц.,вадкія унцыі,,{0} вадкая унцыя,{0} вадкай унцыі
        fluid-ounce-imperial,імп. вадкая унцыя,,{0} імп. вадкая унцыя,{0} імп. вадкай унцыі,імп. вадкая унцыя,,{0} імп. вадкая унцыя,{0} імп. вадкай унцыі,імп. вадкія унцыі,,{0} імп. вадкая унцыя,{0} імп. вадкай унцыі
        gallon,гал,{0}/гал,{0} гал,{0} гал,гал,{0}/гал,{0} гал,{0} гал,галоны,{0} на галон,{0} галон,{0} галона
        gallon-imperial,імп. гал,{0}/імп. гал,{0} імп. гал,{0} імп. гал,імп. гал,{0}/імп. гал,{0} імп. гал,{0} імп. гал,імп. галоны,{0}/імп. галон,{0} імп. галон,{0} імп. галона
        hectoliter,гл,,{0} гл,{0} гл,гл,,{0} гл,{0} гл,гекталітры,,{0} гекталітр,{0} гекталітра
        jigger,джыгер,,{0} джыгер,{0} джыгера,джыгер,,{0} джыгер,{0} джыгера,джыгеры,,{0} джыгер,{0} джыгера
        liter,л,{0}/л,{0} л,{0} л,л,{0}/л,{0} л,{0} л,літры,{0} на літр,{0} літр,{0} літра
        megaliter,Мл,,{0} Мл,{0} Мл,Мл,,{0} Мл,{0} Мл,мегалітры,,{0} мегалітр,{0} мегалітра
        milliliter,мл,,{0} мл,{0} мл,мл,,{0} мл,{0} мл,мілілітры,,{0} мілілітр,{0} мілілітра
        pinch,дробка,,{0} дробка,{0} дробкі,дробка,,{0} дробка,{0} дробкі,дробкі,,{0} дробка,{0} дробкі
        pint,пінты,,{0} пінта,{0} пінты,пінты,,{0} пінта,{0} пінты,пінты,,{0} пінта,{0} пінты
        pint-metric,мет. пінты,,{0} мет. пінта,{0} мет. пінты,мет. пінты,,{0} мет. пінта,{0} мет. пінты,метрычныя пінты,,{0} метрычная пінта,{0} метрычнай пінты
        quart,кварты,,{0} кварта,{0} кварты,кварты,,{0} кварта,{0} кварты,кварты,,{0} кварта,{0} кварты
        quart-imperial,брыт. кварта,,{0} брыт. кварта,{0} брыт. кварты,брыт. кварта,,{0} брыт. кварта,{0} брыт. кварты,брыт. кварты,,{0} брыт. кварта,{0} брыт. кварты
        tablespoon,ст. лыжкі,,{0} ст. лыжка,{0} ст. лыжкі,ст. лыжкі,,{0} ст. лыжка,{0} ст. лыжкі,сталовыя лыжкі,,{0} сталовая лыжка,{0} сталовай лыжкі
        teaspoon,ч. лыжкі,,{0} ч. лыжка,{0} ч. лыжкі,ч. лыжкі,,{0} ч. лыжка,{0} ч. лыжкі,чайныя лыжкі,,{0} чайная лыжка,{0} чайнай лыжкі
        """.trimIndent()
  }

  private val be_Prefixes: String by lazy {
    """square,,,кв. {0}
        cubic,,,куб. {0}
        times,{0}{1},,{0}-{1}
        1024p1,Кі{0},Кі{0},кібі{0}
        1024p2,Мі{0},Мі{0},мебі{0}
        1024p3,Гі{0},Гі{0},гібі{0}
        1024p4,Ті{0},Ті{0},тэбі{0}
        1024p5,Пі{0},Пі{0},пебі{0}
        1024p6,Эі{0},Эі{0},эксбі{0}
        1024p7,Зі{0},Зі{0},зэбі{0}
        1024p8,Ёі{0},Ёі{0},ёбі{0}
        10p-1,д{0},д{0},дэцы{0}
        10p-12,п{0},п{0},піка{0}
        10p-15,ф{0},ф{0},фемта{0}
        10p-18,а{0},а{0},ата{0}
        10p-2,с{0},с{0},санты{0}
        10p-21,з{0},з{0},зэпта{0}
        10p-24,ё{0},ё{0},ёкта{0}
        10p-27,р{0},р{0},ронта{0}
        10p-3,м{0},м{0},мілі{0}
        10p-30,к{0},к{0},квекта{0}
        10p-6,мк{0},мк{0},мікра{0}
        10p-9,н{0},н{0},нана{0}
        10p1,да{0},да{0},дэка{0}
        10p12,Т{0},Т{0},тэра{0}
        10p15,П{0},П{0},пета{0}
        10p18,Э{0},Э{0},экса{0}
        10p2,г{0},г{0},гекта{0}
        10p21,З{0},З{0},зэта{0}
        10p24,Ё{0},Ё{0},ёта{0}
        10p27,Р{0},Р{0},рона{0}
        10p3,к{0},,кіла{0}
        10p30,кв{0},кв{0},квета{0}
        10p6,М{0},М{0},мега{0}
        10p9,Г{0},Г{0},гіга{0}
        """.trimIndent()
  }

  private val be_tarask_Units: String by lazy {
    """mile-per-gallon-imperial,міль/імп. гал.,,{0} міля/імп. гал.,{0} мілі/імп. галён,,,,,,,,
        day,сут,{0} сут.,{0} сут,{0} сут,,,,,,,,
        minute,хв,{0}/ хв.,{0} хв,{0} хв,,,,,,,,
        pixel,піксэлі,,{0} піксэль,{0} піксэля,,,,,,,,
        pixel-per-centimeter,піксэль/см,,{0} піксэль/см,{0} піксэля/см,,,,,,,,
        pixel-per-inch,піксэль/цалю,,{0} піксэль/цалю,{0} піксэля/цалю,,,,,,,,
        """.trimIndent()
  }

  private val be_tarask_Prefixes: String? = null

  private val bem_Units: String? = null

  private val bem_Prefixes: String? = null

  private val bew_Units: String? = null

  private val bew_Prefixes: String? = null

  private val bez_Units: String? = null

  private val bez_Prefixes: String? = null

  private val bg_Units: String by lazy {
    """g-force,G,,,{0} G,G,,,{0} G,G,,,{0} G
        meter-per-square-second,,,,,,,,,метри за секунда на квадрат,,{0} метър за секунда на квадрат,{0} метра за секунда на квадрат
        arc-minute,дъгови мин.,,,{0}′,дъгови мин.,,,{0}′,дъгови минути,,{0} дъгова минута,{0} дъгови минути
        arc-second,дъг. сек.,,,{0}″,дъгови сек.,,,{0}″,дъгови секунди,,{0} дъгова секунда,{0} дъгови секунди
        degree,°,,,{0}°,°,,,{0}°,градуси,,{0} градус,{0} градуса
        radian,,,,,,,,,радиани,,{0} радиан,{0} радиана
        revolution,об.,,{0} об.,{0} об.,об.,,{0} об.,{0} об.,оборот,,{0} оборот,{0} оборота
        acre,акри,,{0} акър,{0} акра,акри,,{0} акър,{0} акра,акри,,{0} акър,{0} акра
        dunam,дюнюми,,{0} дюнюм,{0} дюнюма,дюнюми,,{0} дюнюм,{0} дюнюма,дюнюми,,{0} дюнюм,{0} дюнюма
        hectare,ha,,,{0} ha,ha,,,{0} ha,хектари,,{0} хектар,{0} хектара
        square-centimeter,,,,,,,,,квадратни сантиметри,{0} на квадратен сантиметър,{0} квадратен сантиметър,{0} квадратни сантиметра
        square-foot,,,,,,,,,квадратни футове,,{0} квадратен фут,{0} квадратни фута
        square-inch,,,,,,,,,квадратни инчове,{0} на квадратен инч,{0} квадратен инч,{0} квадратни инча
        square-kilometer,,,,,,,,,квадратни километри,{0} на квадратен километър,{0} квадратен километър,{0} квадратни километра
        square-meter,,,,,,,,,квадратни метри,{0} на квадратен метър,{0} квадратен метър,{0} квадратни метра
        square-mile,mi²,{0}/mi²,{0} кв. миля,{0} кв. мили,,,,,квадратни мили,{0} на квадратна миля,{0} квадратна миля,{0} квадратни мили
        square-yard,,,,,,,,,квадратни ярдове,,{0} квадратен ярд,{0} квадратни ярда
        item,единица,,{0} ед.,{0} ед.,единица,,{0} ед.,{0} ед.,единици,,{0} единица,{0} единици
        karat,,,,,,,,,карати,,{0} карат,{0} карата
        milligram-ofglucose-per-deciliter,mg/dL,,{0} mg/dl,{0} mg/dl,mg/dL,,{0} mg/dl,{0} mg/dl,милиграми на децилитър,,{0} милиграм на децилитър,{0} милиграма на децилитър
        millimole-per-liter,,,,,,,,,милимоли на литър,,{0} милимол на литър,{0} милимола на литър
        mole,мол,,{0} мол,{0} мол,мол,,{0} мол,{0} мол,молове,,{0} мол,{0} мола
        percent,,,,,процент,,,{0}%,процент,,{0} процент,{0} процента
        permille,,,,,,,,,промил,,{0} промил,{0} промила
        permillion,,,,,,,,,части на милион,,{0} част на милион,{0} части на милион
        permyriad,,,,,базисен пункт,,,{0}‱,базисен пункт,,{0} базисен пункт,{0} базисни пункта
        portion-per-1e9,части/милиард,,,{0} ppb,части/милиард,,,{0} ppb,части на милиард,,{0} част на милиард,{0} части на милиард
        liter-per-100-kilometer,l/100 km,,{0} l/100 km,{0} l/100 km,l/100 km,,{0} l/100 km,{0} l/100 km,литри на 100 километра,,{0} литър на 100 километра,{0} литра на 100 километра
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,литри на километър,,{0} литър на километър,{0} литра на километър
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg,мили на галон,,{0} миля на галон,{0} мили на галон
        mile-per-gallon-imperial,мили/имп. гал.,,,{0} mpg Imp.,мили/имп. гал.,,,{0} mpg Imp.,мили на имперски галон,,{0} миля на имперски галон,{0} мили на имперски галон
        bit,b,,{0} b,{0} b,b,,{0} b,{0} b,битове,,{0} бит,{0} бита
        byte,B,,{0} B,{0} B,B,,{0} B,{0} B,байтове,,{0} байт,{0} байта
        gigabit,,,,,,,,,гигабити,,{0} гигабит,{0} гигабита
        gigabyte,,,,,,,,,гигабайти,,{0} гигабайт,{0} гигабайта
        kilobit,,,,,,,,,килобитове,,{0} килобит,{0} килобита
        kilobyte,,,,,,,,,килобайтове,,{0} килобайт,{0} килобайта
        megabit,,,,,,,,,мегабитове,,{0} мегабит,{0} мегабита
        megabyte,,,,,,,,,мегабайти,,{0} мегабайт,{0} мегабайта
        petabyte,,,,,PByte,,,{0} PB,петабайти,,{0} петабайт,{0} петабайта
        terabit,,,,,,,,,терабитове,,{0} терабит,{0} терабита
        terabyte,,,,,,,,,терабайтове,,{0} терабайт,{0} терабайта
        century,в.,,{0} в.,{0} в.,в.,,{0} в.,{0} в.,векове,,{0} век,{0} века
        day,д,{0}/д,{0} д,{0} д,дни,{0}/д,{0} д,{0} д,дни,{0} на ден,{0} ден,{0} дни
        decade,декада,,{0} декада,{0} декади,декада,,{0} декада,{0} декади,десетилетия,,{0} десетилетие,{0} десетилетия
        hour,ч,{0}/ч,{0} ч,{0} ч,часове,{0}/ч,{0} ч,{0} ч,часове,{0} за час,{0} час,{0} часа
        microsecond,,,,,,,,,микросекунди,,{0} микросекунда,{0} микросекунди
        millisecond,мсек,,{0} мсек,{0} мсек,милисекунди,,{0} мсек,{0} мсек,милисекунди,,{0} милисекунда,{0} милисекунди
        minute,мин,{0}/мин,{0} мин,{0} мин,мин,{0}/мин,{0} мин,{0} мин,минути,{0} на минута,{0} минута,{0} минути
        month,мес.,{0}/мес.,{0} мес.,{0} мес.,месеци,{0}/месец,{0} мес.,{0} мес.,месеци,{0} на месец,{0} месец,{0} месеца
        nanosecond,,,,,,,,,наносекунди,,{0} наносекунда,{0} наносекунди
        night,нощи,{0}/нощ,{0} нощ,{0} нощи,нощи,{0}/нощ,{0} нощ,{0} нощи,нощи,{0} на нощ,{0} нощ,{0} нощи
        quarter,тримес.,{0}/трим.,{0} трим.,{0} трим.,тримес.,{0}/тримес.,{0} тримес.,{0} тримес.,тримесечия,{0}/тримесечие,{0} тримесечие,{0} тримесечия
        second,сек,{0}/сек,{0} с,{0} с,секунди,{0}/сек,{0} сек,{0} сек,секунди,{0} за секунда,{0} секунда,{0} секунди
        week,седм.,{0}/седм.,{0} седм.,{0} седм.,седмици,{0}/седмица,{0} седм.,{0} седм.,седмици,{0} на седмица,{0} седмица,{0} седмици
        year,г.,{0}/год.,{0} г.,{0} г.,години,{0}/год.,{0} год.,{0} год.,години,{0} на година,{0} година,{0} години
        ampere,A,,,{0} A,A,,,{0} A,ампери,,{0} ампер,{0} ампера
        milliampere,,,,,,,,,милиампери,,{0} милиампер,{0} милиампера
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,омове,,{0} ом,{0} ома
        volt,V,,,{0} V,V,,,{0} V,волтове,,{0} волт,{0} волта
        british-thermal-unit,BTU,,{0} BTU,{0} BTU,BTU,,{0} BTU,{0} BTU,британски термални единици,,{0} британска термална единица,{0} британски термални единици
        calorie,,,,,,,,,калории,,{0} калория,{0} калории
        electronvolt,,,,,,,,,електронволтове,,{0} електронволт,{0} електронволта
        foodcalorie,cal,,{0} cal,{0} cal,cal,,{0} cal,{0} cal,калории,,{0} калория,{0} калории
        joule,J,,,{0} J,J,,,{0} J,джаули,,{0} джаул,{0} джаула
        kilocalorie,,,,,,,,,килокалории,,{0} килокалория,{0} килокалории
        kilojoule,,,,,,,,,килоджаули,,{0} килоджаул,{0} килоджаула
        kilowatt-hour,,,,,,,,,киловатчасове,,{0} киловатчас,{0} киловатчаса
        therm-us,амер. термални ед.,,{0} амер. терм. ед.,{0} амер. терм. ед.,амер. термални ед.,,{0} амер. терм. ед.,{0} амер. терм. ед.,американски термални единици,,{0} американска термална единица,{0} американски термални единици
        kilowatt-hour-per-100-kilometer,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,киловатчас на 100 километра,,{0} киловатчас на 100 километра,{0} киловатчаса на 100 километра
        newton,,,,,,,,,нютони,,{0} нютон,{0} нютона
        pound-force,,,,,,,,,фунтове сила,,{0} фунт сила,{0} фунта сила
        gigahertz,,,,,,,,,гигахерци,,{0} гигахерц,{0} гигахерца
        hertz,,,,,,,,,херцове,,{0} херц,{0} херца
        kilohertz,,,,,,,,,килохерци,,{0} килохерц,{0} килохерца
        megahertz,,,,,,,,,мегахерци,,{0} мегахерц,{0} мегахерца
        dot,точка,,{0} точка,{0} точки,точки,,{0} точка,{0} точки,точки,,{0} точка,{0} точки
        dot-per-centimeter,dpcm,,{0} dpcm,{0} dpcm,dpcm,,{0} dpcm,{0} dpcm,точки на сантиметър,,{0} точка на сантиметър,{0} точки на сантиметър
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,точки на инч,,{0} точка на инч,{0} точки на инч
        em,ем,,{0} ем,{0} ем,ем,,{0} ем,{0} ем,типографски ем,,{0} ем,{0} ем
        megapixel,,,,,,,,,мегапиксели,,{0} мегапиксел,{0} мегапиксела
        pixel,,,,,,,,,пиксели,,{0} пиксел,{0} пиксела
        pixel-per-centimeter,,,,,,,,,пиксели на сантиметър,,{0} пиксел на сантиметър,{0} пиксела на сантиметър
        pixel-per-inch,,,,,,,,,пиксели на инч,,{0} пиксел на инч,{0} пиксела на инч
        astronomical-unit,AU,,{0} AU,{0} AU,AU,,{0} AU,{0} AU,астрономически единици,,{0} астрономическа единица,{0} астрономически единици
        centimeter,,,,,,,,,сантиметри,{0} на сантиметър,{0} сантиметър,{0} сантиметра
        decimeter,,,,,,,,,дециметри,,{0} дециметър,{0} дециметра
        earth-radius,,,,,,,,,земен радиус,,{0} земен радиус,{0} земни радиуса
        fathom,fth,,,{0} fth,fth,,,{0} fth,фатоми,,{0} фатом,{0} фатома
        foot,,,,,,,,,футове,{0} на фут,{0} фут,{0} фута
        furlong,,,,,,,,,фърлонги,,{0} фърлонг,{0} фърлонга
        inch,in,{0}/in,{0}'',{0}'',,,,,инчове,{0} на инч,{0} инч,{0} инча
        kilometer,,,,,,,,,километри,{0} на километър,{0} километър,{0} километра
        light-year,св. г.,,{0} св.г.,{0} св.г.,св. г.,,{0} св.г.,{0} св.г.,светлинни години,,{0} светлинна година,{0} светлинни години
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,метри,{0} на метър,{0} метър,{0} метра
        micrometer,,,,,,,,,микрометри,,{0} микрометър,{0} микрометра
        mile,,,,,,,,,мили,,{0} миля,{0} мили
        mile-scandinavian,,,,,,,,,шведска миля,,{0} шведска миля,{0} шведски мили
        millimeter,,,,,,,,,милиметри,,{0} милиметър,{0} милиметра
        nanometer,,,,,,,,,нанометри,,{0} нанометър,{0} нанометра
        nautical-mile,,,,,,,,,морски мили,,{0} морска миля,{0} морски мили
        parsec,,,,,,,,,парсеци,,{0} парсек,{0} парсека
        picometer,,,,,,,,,пикометри,,{0} пикометър,{0} пикометра
        point,,,,,,,,,пунктове,,{0} пункт,{0} пункта
        solar-radius,,,,,,,,,слънчеви радиуси,,{0} слънчев радиус,{0} слънчеви радиуси
        yard,,,,,,,,,ярдове,,{0} ярд,{0} ярда
        candela,,,,,,,,,кандела,,{0} кандела,{0} кандели
        lumen,,,,,,,,,лумен,,{0} лумен,{0} лумена
        lux,,,,,,,,,луксове,,{0} лукс,{0} лукса
        solar-luminosity,,,,,,,,,слънчеви светимости,,{0} слънчева светимост,{0} слънчеви светимости
        carat,,,,,,,,,карати,,{0} карат,{0} карата
        dalton,,,,,далтони,,,{0} Da,далтони,,{0} далтон,{0} далтона
        earth-mass,,,,,,,,,маси на Земята,,{0} маса на Земята,{0} маси на Земята
        grain,гран,,{0} гран,{0} грана,гран,,{0} гран,{0} грана,гран,,{0} гран,{0} грана
        gram,g,{0}/g,,{0} g,g,{0}/g,,{0} g,грамове,{0} на грам,{0} грам,{0} грама
        kilogram,,,,,,,,,килограми,{0} на килограм,{0} килограм,{0} килограма
        microgram,,,,,,,,,микрограмове,,{0} микрограм,{0} микрограма
        milligram,,,,,,,,,милиграмове,,{0} милиграм,{0} милиграма
        ounce,,,,,,,,,унции,{0} на унция,{0} унция,{0} унции
        ounce-troy,тр. унц.,,{0} тр. унц.,{0} тр. унц.,тр. унц.,,{0} тр. унц.,{0} тр. унц.,тройунции,,{0} тройунция,{0} тройунции
        pound,,,,,,,,,фунтове,{0} на фунт,{0} фунт,{0} фунта
        solar-mass,,,,,,,,,слънчеви маси,,{0} слънчева маса,{0} слънчеви маси
        stone,стоун.,,,{0} st,стоун.,,,{0} st,стоунове,,{0} стоун,{0} стоуна
        ton,,,,,,,,,къси тонове,,{0} къс тон,{0} къси тона
        tonne,,,,,,,,,метрични тонове,,{0} метричен тон,{0} метрични тона
        gigawatt,,,,,,,,,гигавати,,{0} гигават,{0} гигавата
        horsepower,к. с.,,{0} к.с.,{0} к.с.,к. с.,,{0} к. с.,{0} к. с.,конски сили,,{0} конска сила,{0} конски сили
        kilowatt,,,,,,,,,киловати,,{0} киловат,{0} киловата
        megawatt,,,,,,,,,мегавати,,{0} мегават,{0} мегавата
        milliwatt,,,,,,,,,миливати,,{0} миливат,{0} миливата
        watt,W,,,{0} W,W,,,{0} W,ватове,,{0} ват,{0} вата
        atmosphere,,,,,,,,,атмосфери,,{0} атмосфера,{0} атмосфери
        bar,,,,,,,,,барове,,{0} бар,{0} бара
        hectopascal,,,,,,,,,хектопаскали,,{0} хектопаскал,{0} хектопаскала
        inch-ofhg,,,,,,,,,инчове живачен стълб,,{0} инч живачен стълб,{0} инча живачен стълб
        kilopascal,,,,,,,,,килопаскали,,{0} килопаскал,{0} килопаскала
        megapascal,,,,,,,,,мегапаскали,,{0} мегапаскал,{0} мегапаскала
        millibar,,,,,,,,,милибари,,{0} милибар,{0} милибара
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,mmHg,,{0} mmHg,{0} mmHg,милиметри живачен стълб,,{0} милиметър живачен стълб,{0} милиметра живачен стълб
        pascal,,,,,,,,,паскали,,{0} паскал,{0} паскала
        pound-force-per-square-inch,,,,,,,,,фунтове на квадратен инч,,{0} фунт на квадратен инч,{0} фунта на квадратен инч
        beaufort,Bft,,{0} по Б,{0} по Б,Bft,,{0} по Bft,{0} по Bft,Бофорт,,{0} по Бофорт,{0} по Бофорт
        kilometer-per-hour,,,,,,,,,километри в час,,{0} километър в час,{0} километра в час
        knot,,,,,,,,,възел,,{0} възел,{0} възла
        light-speed,светлина,,{0} светлина,{0} светлина,светлина,,{0} светлина,{0} светлина,светлина,,{0} светлина,{0} светлина
        meter-per-second,,,,,,,,,метри за секунда,,{0} метър за секунда,{0} метра за секунда
        mile-per-hour,mph,,{0} миля/ч,{0} мили/ч,mph,,{0} mph,{0} mph,мили в час,,{0} миля в час,{0} мили в час
        celsius,,,,,,,,,градуси Целзий,,{0} градус Целзий,{0} градуса Целзий
        fahrenheit,,,,,,,,,градуси по Фаренхайт,,{0} градус по Фаренхайт,{0} градуса по Фаренхайт
        kelvin,,,,,,,,,келвини,,{0} келвин,{0} келвина
        newton-meter,,,,,,,,,нютон-метър,,{0} нютон-метър,{0} нютон-метра
        pound-force-foot,,,,,,,,,паунд-футове сила,,{0} паунд-фут сила,{0} паунд-фута сила
        acre-foot,,,,,,,,,акър-футове,,{0} акър-фут,{0} акър-фута
        barrel,,,,,барел,,,{0} bbl,барели,,{0} барел,{0} барела
        bushel,бушели,,,{0} bu,бушели,,,{0} bu,бушели,,{0} бушел,{0} бушела
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,сентилитри,,{0} сентилитър,{0} сентилитра
        cubic-centimeter,,,,,,,,,кубически сантиметри,{0} на кубичен сантиметър,{0} кубически сантиметър,{0} кубически сантиметра
        cubic-foot,,,,,,,,,кубически футове,,{0} кубически фут,{0} кубически фута
        cubic-inch,,,,,,,,,кубически инчове,,{0} кубически инч,{0} кубически инча
        cubic-kilometer,,,,,,,,,кубически километри,,{0} кубически километър,{0} кубически километра
        cubic-meter,,,,,,,,,кубически метри,{0} на кубичен метър,{0} кубически метър,{0} кубически метра
        cubic-mile,,,,,,,,,кубически мили,,{0} кубическа миля,{0} кубически мили
        cubic-yard,,,,,,,,,кубически ярдове,,{0} кубически ярд,{0} кубически ярда
        cup,ч.,,{0} ч.,{0} ч.,ч.,,{0} ч.,{0} ч.,чаши,,{0} чаша,{0} чаши
        cup-metric,,,,,,,,,метрични чаши,,{0} метрична чаша,{0} метрични чаши
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,децилитри,,{0} децилитър,{0} децилитра
        dessert-spoon,дес. лъжица,,{0} дес. лъж.,{0} дес. лъж.,дес. лъжица,,{0} дес. лъжица,{0} дес. лъжици,десертна лъжица,,{0} десертна лъжица,{0} десертни лъжици
        dessert-spoon-imperial,брит. дес. лъжица,,{0} брит. дес. лъж.,{0} брит. дес. лъж.,брит. дес. лъжица,,{0} брит. дес. лъжица,{0} брит. дес. лъжици,брит. дес. лъжици,,{0} брит. дес. лъжица,{0} брит. дес. лъжици
        dram,течен драм,,{0} теч. драм,{0} теч. драма,течен драм,,{0} теч. драм,{0} теч. драма,драм,,{0} драм,{0} драма
        drop,капка,,{0} капка,{0} капки,капка,,{0} капка,{0} капки,капки,,{0} капка,{0} капки
        fluid-ounce,,,,,,,,,течни унции,,{0} течна унция,{0} течни унции
        fluid-ounce-imperial,,,,,,,,,имперски течни унции,,{0} имперска течна унция,{0} имперски течни унции
        gallon,,,,,,,,,галони,{0} на галон,{0} галон,{0} галона
        gallon-imperial,имп. галон,{0}/имп. галон,{0} имп. галон,{0} имп. галона,имп. галон,{0}/имп. галон,{0} имп. галон,{0} имп. галона,имперски галони,{0} на имперски галон,{0} имперски галон,{0} имперски галона
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,хектолитри,,{0} хектолитър,{0} хектолитра
        jigger,джигър,,{0} джигър,{0} джигъра,джигър,,{0} джигър,{0} джигъра,джигър,,{0} джигър,{0} джигъра
        liter,l,{0}/l,,{0} l,l,{0}/l,,{0} l,литри,{0} на литър,{0} литър,{0} литра
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,мегалитри,,{0} мегалитър,{0} мегалитра
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,милилитри,,{0} милилитър,{0} милилитра
        pinch,щипка,,{0} щипка,{0} щипки,щипка,,{0} щипка,{0} щипки,щипка,,{0} щипка,{0} щипки
        pint,,,,,,,,,пинти,,{0} пинта,{0} пинти
        pint-metric,pt,,,{0} mpt,,,,,метрични пинти,,{0} метрична пинта,{0} метрични пинти
        quart,,,,,,,,,кварти,,{0} кварта,{0} кварти
        quart-imperial,имп. кварта,,{0} имп. кварта,{0} имп. кварти,имп. кварта,,{0} имп. кварта,{0} имп. кварти,имперски кварти,,{0} имперска кварта,{0} имперски кварти
        tablespoon,с. л.,,{0} с. л.,{0} с. л.,с. л.,,{0} с. л.,{0} с. л.,супени лъжици,,{0} супена лъжица,{0} супени лъжици
        teaspoon,ч. л.,,{0} ч. л.,{0} ч. л.,ч. л.,,{0} ч. л.,{0} ч. л.,чаени лъжици,,{0} чаена лъжица,{0} чаени лъжици
        """.trimIndent()
  }

  private val bg_Prefixes: String by lazy {
    """square,,,квадратни {0}
        cubic,,,кубични {0}
        per,,,{0} на {1}
        1024p1,,,киби{0}
        1024p2,,,меби{0}
        1024p3,,,гиби{0}
        1024p4,,,теби{0}
        1024p5,,,пеби{0}
        1024p6,,,ексби{0}
        1024p7,,,зеби{0}
        1024p8,,,йоби{0}
        10p-1,,,деци{0}
        10p-12,,,пико{0}
        10p-15,,,фемто{0}
        10p-18,,,ато{0}
        10p-2,,,санти{0}
        10p-21,,,зепто{0}
        10p-24,,,йокто{0}
        10p-27,,,ронто{0}
        10p-3,,,мили{0}
        10p-30,,,куекто{0}
        10p-6,,,микро{0}
        10p-9,,,нано{0}
        10p1,,,дека{0}
        10p12,,,тера{0}
        10p15,,,пета{0}
        10p18,,,екса{0}
        10p2,,,хекто{0}
        10p21,,,зета{0}
        10p24,,,йота{0}
        10p27,,,рона{0}
        10p3,,,кило{0}
        10p30,,,куета{0}
        10p6,,,мега{0}
        10p9,,,гига{0}
        """.trimIndent()
  }

  private val bgc_Units: String? = null

  private val bgc_Prefixes: String? = null

  private val bgn_Units: String by lazy {
    """century,سده‌گ,,,{0} سده‌گ,سده‌گ,,,{0} سده‌گ,سده‌گ,,,{0} سده‌گ
        day,روچ,{0}/روچ,,{0}روچ,روچ,{0}/روچ,,{0} روچ,روچ,{0} روچئ تا,,{0} روچ
        hour,ساعت,{0}/ساعت,,{0}ساعت,ساعت,{0}/ساعت,,{0} ساعت,ساعت,{0} ساعتئ تا,,{0} ساعت
        microsecond,مایکروثانیه,,,{0} مایکروثانیه,مایکروثانیه,,,{0} مایکروثانیه,مایکروثانیه,,,{0} مایکروثانیه
        millisecond,میلی‌ثانیه,,,{0}میلی‌ثانیه,میلی‌ثانیه,,,{0} میلی‌ثانیه,میلی‌ثانیه,,,{0} میلی‌ثانیه
        minute,دقیقه,{0}/دقیقه,,{0}دقیقه,دقیقه,{0}/دقیقه,,{0} دقیقه,دقیقه,{0} دقیقه‌ای تا,,{0} دقیقه
        month,ماه,{0}/ماه,,{0}ماه,ماه,{0}/ماه,,{0} ماه,ماه,{0} به ماه‌ای تا,,{0} ماه
        nanosecond,نانوثانیه,,,{0} نانوثانیه,نانوثانیه,,,{0} نانوثانیه,نانوثانیه,,,{0} نانوثانیه
        second,ثانیه,{0}/ث,,{0}ث,ثانیه,{0}/ث,,{0} ثانیه,ثانیه,{0} ثانیه‌ای تا,,{0} ثانیه
        week,هفته‌گ,{0}/هفته‌گ,,{0}هفته‌گ,هفته‌گ,{0}/هفته‌گ,,{0} هفته‌گ,هفته‌گ,{0} هفته‌گئ تا,,{0} هفته‌گ
        year,سال,{0}/سال,,{0} سال,سال,{0}/سال,,{0} سال,سال,{0} سالئ تا,,{0} سال
        kilometer,کیلومیتر,{0}/کیلومیتر,,{0}کیلومیتر,کیلومیتر,{0}/کیلومیتر,,{0} کیلومیتر,کیلومیتر,{0} کیلومیترئ تا,,{0} کیلومیتر
        meter,میتر,{0}/میتر,,{0}میتر,میتر,{0}/میتر,,{0} میتر,میتر,{0} میترئ تا,,{0} میتر
        """.trimIndent()
  }

  private val bgn_Prefixes: String? = null

  private val bgn_AE_Units: String? = null

  private val bgn_AE_Prefixes: String? = null

  private val bgn_AF_Units: String? = null

  private val bgn_AF_Prefixes: String? = null

  private val bgn_IR_Units: String? = null

  private val bgn_IR_Prefixes: String? = null

  private val bgn_OM_Units: String? = null

  private val bgn_OM_Prefixes: String? = null

  private val bho_Units: String? = null

  private val bho_Prefixes: String? = null

  private val blo_Units: String by lazy {
    """g-force,g-force,,G{0},G{0},g-force,,G {0},G {0},gatǝna kɩkashɩ bʊkɔ laŋ,,gatǝna kɩkashɩ bʊkɔ laŋ {0},gatǝna kɩkashɩ bʊkɔ laŋ {0}
        meter-per-square-second,m/s²,,m/s²{0},m/s²{0},m/s²,,m/s² {0},m/s² {0},ɩmɛta gɩpi bʊyɛ bʊyɛ nɩ,,mɛta gɩpi bʊyɛ bʊyɛ nɩ {0},ɩmɛta gɩpi bʊyɛ bʊyɛ nɩ {0}
        arc-minute,arcmin,,′{0},′{0},arcmin,,′{0},′{0},gʊta-kɩminti,,gʊta-kaminti {0},gʊta-kɩminti {0}
        arc-second,arcsec,,″{0},″{0},arcsec,,″{0},″{0},gʊta-kɩsǝmpi,,gʊta-kagɩsǝmpi {0},gʊta-kɩsǝmpi {0}
        degree,deg,,°{0},°{0},deg,,°{0},°{0},ɩɖegre,,ɖegre {0},ɩɖegre {0}
        radian,rad,,rad{0},rad{0},rad,,rad {0},rad {0},rad,,rad {0},rad {0}
        revolution,rev,,rev{0},rev{0},rev,,rev {0},rev {0},ɩcǝpǝrʊ,,ʊcǝpǝrʊ {0},ɩcǝpǝrʊ {0}
        dunam,ɖunam,,ɖunam {0},ɩɖunam {0},ɩɖunam,,ɖunam {0},ɩɖunam {0},ɩɖunam,,ɖunam {0},ɩɖunam {0}
        hectare,ʊlɔ,,ha{0},ha{0},ɩlɔ,,ha {0},ha {0},ɩlɔ,,ʊlɔ {0},ɩlɔ {0}
        square-centimeter,cm²,{0}/cm²,cm²{0},cm²{0},cm²,{0}/cm²,cm² {0},cm² {0},ɩsɛntimɛta bʊyɛ bʊyɛ,{0} sɛntimɛta bʊyɛ bʊyɛ nɩ,sɛntimɛta bʊyɛ bʊyɛ {0},ɩsɛntimɛta bʊyɛ bʊyɛ {0}
        square-foot,ft²,,ft²{0},ft²{0},ft²,,ft² {0},ft² {0},anaŋcǝna bʊyɛ bʊyɛ,,gʊnaŋcǝna bʊyɛ bʊyɛ {0},anaŋcǝna bʊyɛ bʊyɛ {0}
        square-inch,in²,{0}/in²,in²{0},in²{0},in²,{0}/in²,in² {0},in² {0},asǝkǝmǝ bʊyɛ bʊyɛ,{0} nsǝkǝmǝ bʊyɛ bʊyɛ nɩ,nsǝkǝmǝ bʊyɛ bʊyɛ {0},asǝkǝmǝ bʊyɛ bʊyɛ {0}
        square-kilometer,km²,{0}/km²,km²{0},km²{0},km²,{0}/km²,km² {0},km² {0},ɩkiloomɛta bʊyɛ bʊyɛ,{0} kiloomɛta bʊyɛ bʊyɛ nɩ,kiloomɛta bʊyɛ bʊyɛ {0},ɩkiloomɛta bʊyɛ bʊyɛ {0}
        square-meter,ɩmɛta²,{0}/m²,m²{0},m²{0},ɩmɛta²,{0}/m²,m² {0},m² {0},ɩmɛta bʊyɛ bʊyɛ,{0} mɛta bʊyɛ bʊyɛ nɩ,mɛta bʊyɛ bʊyɛ {0},ɩmɛta bʊyɛ bʊyɛ {0}
        square-mile,mi²,{0}/mi²,mi²{0},mi²{0},mi²,{0}/mi²,mi² {0},mi² {0},ɩmayɩl bʊyɛ bʊyɛ,{0} mayɩl bʊyɛ bʊyɛ nɩ,mayɩl bʊyɛ bʊyɛ {0},ɩmayɩl bʊyɛ bʊyɛ {0}
        square-yard,yd²,,yd²{0},yd²{0},yd²,,yd² {0},yd² {0},yd²,,yd² {0},yd² {0}
        item,item,,item{0},item{0},item,,item {0},item {0},ayɔkɔ,,bʊkɔ {0},ayɔkɔ {0}
        karat,kt,,kt{0},kt{0},kt,,kt {0},kt {0},ɩkaraatɩ,,karaatɩ {0},ɩkaraatɩ {0}
        milligram-ofglucose-per-deciliter,mg/dL,,mg/dL{0},mg/dL{0},mg/dL,,mg/dL {0},mg/dL {0},ɩmiligram ɖesilitri nɩ,,miligram ɖesilitri nɩ {0},ɩmiligram ɖesilitri nɩ {0}
        millimole-per-liter,mmol/L,,mmol/L{0},mmol/L{0},mmol/L,,mmol/L {0},mmol/L {0},ɩmilimol litri nɩ,,milimol litri nɩ {0},ɩmilimol litri nɩ {0}
        mole,mol,,mol{0},mol{0},mol,,mol {0},mol {0},ɩmol,,mol {0},ɩmol {0}
        percent,%,,%{0},%{0},%,,%{0},%{0},ɩshɩnʊn nɩ,,ɩshɩnʊn nɩ {0},ɩshɩnʊn nɩ {0}
        permille,‰,,‰{0},‰{0},‰,,‰{0},‰{0},miili nɩ,,miili nɩ {0},miili nɩ {0}
        permillion,ppm,,ppm{0},ppm{0},ppm,,ppm {0},ppm {0},ppm,,ppm {0},ppm {0}
        permyriad,‱,,‱{0},‱{0},‱,,‱{0},‱{0},‱,,‱{0},‱{0}
        portion-per-1e9,ppb,,ppb{0},ppb{0},ppb,,ppb {0},ppb {0},ppb,,ppb {0},ppb {0}
        liter-per-100-kilometer,L/100km,,L/100km{0},L/100km{0},L/100km,,L/100km {0},L/100km {0},ɩlitri ɩkiloomɛta 100 nɩ,,litri ɩkiloomɛta 100 nɩ {0},ɩlitri ɩkiloomɛta 100 nɩ {0}
        liter-per-kilometer,L/km,,L/km{0},L/km{0},L/km,,L/km {0},L/km {0},ɩlitri kiloomɛta nɩ,,litri kiloomɛta nɩ {0},litri kiloomɛta nɩ {0}
        mile-per-gallon,mpg US,,mpg{0},mpg{0},mpg US,,mpg {0},mpg {0},ɩmayɩl gaalɔŋ nɩ,,mayɩl gaalɔŋ nɩ {0},ɩmayɩl gaalɔŋ nɩ {0}
        mile-per-gallon-imperial,mpg Imp.,,mpg Imp.{0},mpg Imp.{0},mpg Imp.,,mpg Imp. {0},mpg Imp. {0},ɩmayɩl gaalɔŋ Gɛɛshɩ kaja nɩ,,mayɩl gaalɔŋ Gɛɛshɩ kaja nɩ {0},ɩmayɩl gaalɔŋ Gɛɛshɩ kaja nɩ {0}
        century,,,,,,,,,bʊja-ɩshɩnʊn mána,,,{0} c
        day,,,,,,,,,ɩshilé,{0} ʊshilé nɩ,,{0} d
        decade,,,,,,,,,bʊja-tǝb mána,,,{0} dec
        hour,,,,,,,,,bʊkɔŋkɔŋɔ̀,{0} gakɔŋkɔŋɔ̀ nɩ,,{0} h
        microsecond,,,,,,,,,ɩmikroosǝmpi,,,{0} μs
        millisecond,,,,,,,,,ɩsǝmpi,,,{0} ms
        minute,,,,,,,,,anaŋa,{0} gʊnaŋa nɩ,,{0} min
        month,,,,,,,,,ɩŋɔrɔ,{0} aŋɔrɔ nɩ,,{0} m
        nanosecond,,,,,,,,,ɩnanoosǝmpi,,,{0} ns
        night,gɩjibɔŋɔ,{0}/night,,{0} night,gɩjibɔŋɔ,{0}/night,,{0} night,gɩjibɔŋɔ,{0} gɩjibɔŋɔ nɩ,,{0} night
        quarter,,,,,,,,,ɩŋɔrɩriu mána,{0} ɩŋɔrɩriu nɩ,,{0} q
        second,,,,,,,,,ɩpi,{0} gɩpi nɩ,,{0} s
        week,,,,,,,,,ɩbɔkɔɩ,{0} bɔkɔɩ nɩ,,{0} w
        year,,,,,,,,,bʊja,{0} gaja nɩ,,{0} y
        ampere,amp,,A{0},A{0},amp,,A {0},A {0},Ampɛɛr mána,,Ampɛɛr {0},Ampɛɛr mána {0}
        milliampere,mA,,mA{0},mA{0},mA,,mA {0},mA {0},mili-Ampɛɛr mána,,mili-Ampɛɛr {0},mili-Ampɛɛr {0} mána
        ohm,ohm,,Ω{0},Ω{0},ohm,,Ω {0},Ω {0},Om mána,,Om {0},Om mána {0}
        volt,volt,,V{0},V{0},volt,,V {0},V {0},ɩFɔltɩ,,Fɔltɩ {0},ɩFɔltɩ {0}
        british-thermal-unit,Btu,,Btu{0},Btu{0},Btu,,Btu {0},Btu {0},Btu,,Btu {0},Btu {0}
        calorie,cal,,cal{0},cal{0},cal,,cal {0},cal {0},ɩkalorii,,kalorii {0},ɩkalorii {0}
        electronvolt,eV,,eV{0},eV{0},eV,,eV {0},eV {0},elɛtrɔŋ-Fɔltɩ mána,,elɛtrɔŋ-Fɔltɩ {0},elɛtrɔŋ-Fɔltɩ mána {0}
        joule,jul,,J{0},J{0},ɩjul,,J {0},J {0},ɩjul,,jul {0},ɩjul {0}
        kilocalorie,kcal,,kcal{0},kcal{0},kcal,,kcal {0},kcal {0},ɩkilookalorii,,kilookalorii {0},ɩkilookalorii {0}
        kilojoule,kJ,,kJ{0},kJ{0},kJ,,kJ {0},kJ {0},ɩkiloojul,,kiloojul {0},ɩkiloojul {0}
        kilowatt-hour,kWh,,kWh{0},kWh{0},kWh,,kWh {0},kWh {0},kiloo-Waatɩ-bʊkɔŋkɔŋɔ̀,,kiloo-Waatɩ-gakɔŋkɔŋɔ̀ {0},kiloo-Waatɩ-bʊkɔŋkɔŋɔ̀ {0}
        therm-us,US therm,,US therm{0},US therm{0},US therm,,US therm {0},US therm {0},US therm,,US therm {0},US therm {0}
        kilowatt-hour-per-100-kilometer,kWh/100km,,kWh/100km{0},kWh/100km{0},kWh/100km,,kWh/100km {0},kWh/100km {0},kiloo-Waatɩ-bʊkɔŋkɔŋɔ̀ ɩkilomɛta 100 nɩ,,kiloo-Waatɩ-gakɔŋkɔŋɔ̀ ɩkilomɛta 100 nɩ {0},kiloo-Waatɩ-bʊkɔŋkɔŋɔ̀ ɩkilomɛta 100 nɩ {0}
        newton,N,,N{0},N{0},N,,N {0},N {0},ɩNiutɔn,,Niutɔn {0},ɩNiutɔn {0}
        gigahertz,GHz,,GHz{0},GHz{0},GHz,,GHz {0},GHz {0},ɩjigaa-Hɛrtɩ,,jigaa-Hɛrtɩ {0},ɩjigaa-Hɛrtɩ {0}
        hertz,Hz,,Hz{0},Hz{0},Hz,,Hz {0},Hz {0},ɩHɛrtɩ,,Hɛrtɩ {0},ɩHɛrtɩ {0}
        kilohertz,kHz,,kHz{0},kHz{0},kHz,,kHz {0},kHz {0},ɩkiloo-Hɛrtɩ,,kiloo-Hɛrtɩ {0},ɩkiloo-Hɛrtɩ {0}
        megahertz,MHz,,MHz{0},MHz{0},MHz,,MHz {0},MHz {0},ɩmegaa-Hɛrtɩ,,megaa-Hɛrtɩ {0},ɩmegaa-Hɛrtɩ {0}
        em,em,,em {0},em {0},em,,ʊfɔɔ ɛm {0},ɩfɔɔ ɛm {0},ɩfɔɔ ɛm,,ʊfɔɔ ɛm {0},ɩfɔɔ ɛm {0}
        megapixel,ɩmegapisɛl,,,{0} MP,ɩmegapisɛl,,,{0} MP,ɩmegapisɛl,,megapisɛl {0},ɩmegapisɛl {0}
        pixel,ɩpisɛl,,,{0} px,ɩpisɛl,,,{0} px,ɩpisɛl,,pisɛl {0},ɩpisɛl {0}
        pixel-per-centimeter,,,,,,,,,ɩpisɛl sɛntimɛta bʊye bʊye nɩ,,pisɛl {0} sɛntimɛta bʊye bʊye nɩ,ɩpisɛl {0} sɛntimɛta bʊye bʊye nɩ
        pixel-per-inch,,,,,,,,,ɩpisɛl nsǝkǝmǝ bʊye bʊye nɩ,,pisɛl {0} nsǝkǝmǝ bʊye bʊye nɩ,ɩpisɛl {0} nsǝkǝmǝ bʊye bʊye nɩ
        astronomical-unit,au,,au{0},au{0},au,,au {0},au {0},atǝn-n’ʊshilè mána,,atǝn-n’ʊshilè {0},atǝn-n’ʊshilè mána {0}
        centimeter,cm,{0}/cm,cm{0},cm{0},cm,{0}/cm,cm {0},cm {0},ɩsɛntimɛta,{0} sɛntimɛta nɩ,sɛntimɛta {0},ɩsɛntimɛta {0}
        decimeter,dm,,dm{0},dm{0},dm,,dm {0},dm {0},ɩɖesimɛta,,ɖesimɛta {0},ɩɖesimɛta {0}
        earth-radius,gatǝna gawalaka kʊfana,,R⊕{0},R⊕{0},gatǝna gawalaka kʊfana,,R⊕ {0},R⊕ {0},gatǝna gawalaka kʊfana,,gatǝna gawalaka kʊfana {0},gatǝna gawalaka kɩfana {0}
        fathom,fɛɛɖǝm,,fth{0},fth{0},ɩfɛɛɖǝm,,{0} fth,{0} fth,ɩfɛɛɖǝm,,fɛɛɖǝm {0},ɩfɛɛɖǝm {0}
        foot,anaŋcǝna,{0}/ft,′{0},′{0},anaŋcǝna,{0}/ft,ft {0},ft {0},anaŋcǝna,{0}/gʊnaŋcǝna nɩ,gʊnaŋcǝna {0},anaŋcǝna {0}
        furlong,fɛɛlɔŋ,,fur{0},fur{0},ɩfɛɛlɔŋ,,fur {0},fur {0},ɩfɛɛlɔŋ,,fɛɛlɔŋ {0},ɩfɛɛlɔŋ {0}
        inch,asǝkǝmǝ,{0}/in,′′{0},′′{0},asǝkǝmǝ,{0}/in,in {0},in {0},asǝkǝmǝ,{0} nsǝkǝmǝ nɩ,nsǝkǝmǝ {0},asǝkǝmǝ {0}
        kilometer,km,{0}/km,km{0},km{0},km,{0}/km,km {0},km {0},ɩkiloomɛta,{0} kiloomɛta nɩ,kiloomɛta {0},ɩkiloomɛta {0}
        light-year,ly,,ly{0},ly{0},ly,,ly {0},ly {0},pɔɩɩ-bʊja,,pɔɩɩ-gaja {0},pɔɩɩ-bʊja {0}
        meter,m,{0}/m,m{0},m{0},m,{0}/m,m {0},m {0},ɩmɛta,{0} mɛta nɩ,mɛta {0},ɩmɛta {0}
        micrometer,μm,,μm{0},μm{0},μm,,μm {0},μm {0},ɩmikroomɛta,,mikroomɛta {0},ɩmikroomɛta {0}
        mile,ɩmayɩl,,mi{0},mi{0},ɩmayɩl,,mi {0},mi {0},ɩmayɩl,,mayɩl {0},ɩmayɩl {0}
        mile-scandinavian,smi,,smi{0},smi{0},smi,,smi {0},smi {0},sǝkanɖɩnaf kɩmayɩl,,sǝkanɖɩnaf kamayɩl {0},sǝkanɖɩnaf kɩmayɩl {0}
        millimeter,mm,,mm{0},mm{0},mm,,mm {0},mm {0},ɩmilimɛta,,milimɛta {0},ɩmilimɛta {0}
        nanometer,nm,,nm{0},nm{0},nm,,nm {0},nm {0},ɩnanoomɛta,,nanoomɛta {0},ɩnanoomɛta {0}
        nautical-mile,nmi,,nmi{0},nmi{0},nmi,,nmi {0},nmi {0},teŋku kɩmayɩl,,teŋku kamayɩl {0},teŋku kɩmayɩl {0}
        parsec,parsɛɛkɩ,,pc{0},pc{0},ɩparsɛɛkɩ,,pc {0},pc {0},ɩparsɛɛkɩ,,parsɛɛkɩ {0},ɩparsɛɛkɩ {0}
        picometer,pm,,pm{0},pm{0},pm,,pm {0},pm {0},ɩpikoomɛta,,pikoomɛta {0},ɩpikoomɛta {0}
        point,ɩpipi,,pt{0},pt{0},ɩpipi,,pt {0},pt {0},ɩpipi,,gɩpipi {0},ɩpipi {0}
        solar-radius,ʊshilè kɩfana,,R☉{0},R☉{0},ʊshilè kɩfana,,R☉ {0},R☉ {0},ʊshilè kɩfana,,ʊshilè kʊfana {0},ʊshilè kɩfana {0}
        yard,yd,,yd{0},yd{0},yd,,yd {0},yd {0},yd,,yd {0},yd {0}
        candela,cd,,cd{0},cd{0},cd,,cd {0},cd {0},ɩkanɖalaa,,kanɖalaa {0},ɩkanɖalaa {0}
        lumen,lm,,lm{0},lm{0},lm,,lm {0},lm {0},ɩlumɛn,,lumɛn {0},ɩlumɛn {0}
        lux,lx,,lx{0},lx{0},lx,,lx {0},lx {0},ɩlus,,lus {0},ɩlus {0}
        carat,CD,,CD{0},CD{0},CD,,CD {0},CD {0},wʊra karaatɩ mána,,CD {0},CD {0}
        gram,ɩgram,{0}/g,g{0},g{0},ɩgram,{0}/g,g {0},g {0},ɩgram,{0} gram nɩ,gram {0},ɩgram {0}
        kilogram,kg,{0}/kg,kg{0},kg{0},kg,{0}/kg,kg {0},kg {0},ɩkiloogram,{0} kiloogram nɩ,kiloogram {0},ɩkiloogram {0}
        microgram,μg,,μg{0},μg{0},μg,,μg {0},μg {0},ɩmikroogram,,mikroogram {0},ɩmikroogram {0}
        milligram,mg,,mg{0},mg{0},mg,,mg {0},mg {0},ɩmiligram,,miligram {0},ɩmiligram {0}
        ounce,oz,{0}/oz,oz{0},oz{0},oz,{0}/oz,oz {0},oz {0},oz,{0}/oz,oz {0},oz {0}
        ounce-troy,oz t,,oz t{0},oz t{0},oz t,,oz t {0},oz t {0},oz t,,oz t {0},oz t {0}
        pound,lb,{0}/lb,lb{0},lb{0},lb,{0}/lb,lb {0},lb {0},ɩpɔŋ,{0} pɔŋ nɩ,pɔŋ {0},ɩpɔŋ {0}
        stone,st,,st{0},st{0},st,,st {0},st {0},atala,,ntala {0},atala {0}
        ton,tn,,tn{0},tn{0},tn,,tn {0},tn {0},ɩtɔn Gɛɛshɩ kɩja,,tɔn Gɛɛshɩ kaja {0},tɔn Gɛɛshɩ kɩja {0}
        tonne,t,,t{0},t{0},t,,t {0},t {0},ɩtɔn mɛta kʊfaŋʊ kɩja,,tɔn {0},ɩtɔn {0}
        gigawatt,GW,,GW{0},GW{0},GW,,GW {0},GW {0},ɩjigaa-Waatɩ,,jigaa-Waatɩ {0},ɩjigaa-Waatɩ {0}
        horsepower,hp,,hp{0},hp{0},hp,,hp {0},hp {0},asuko-‘ɩkaŋkɩrɩ,,asuko-‘ɩkaŋkɩrɩ {0},asuko-‘ɩkaŋkɩrɩ {0}
        kilowatt,kW,,kW{0},kW{0},kW,,kW {0},kW {0},kiloo-Waatɩ,,kiloo-Waatɩ {0},ɩkiloo-Waatɩ {0}
        megawatt,MW,,MW{0},MW{0},MW,,MW {0},MW {0},ɩmegaa-Waatɩ,,megaa-Waatɩ {0},ɩmegaa-Waatɩ {0}
        milliwatt,mW,,mW{0},mW{0},mW,,mW {0},mW {0},ɩmili-Waatɩ,,mili-Waatɩ {0},ɩmili-Waatɩ {0}
        watt,watt,,W{0},W{0},watt,,W {0},W {0},Waatɩ,,Waatɩ {0},ɩWaatɩ {0}
        atmosphere,atm,,atm{0},atm{0},atm,,atm {0},atm {0},atǝmɔsfɛɛr mána,,atǝmɔsfɛɛr {0},atǝmɔsfɛɛr mána {0}
        bar,bar,,bar{0},bar{0},bar,,bar {0},bar {0},ɩbaar,,baar {0},ɩbaar {0}
        hectopascal,hPa,,hPa{0},hPa{0},hPa,,hPa {0},hPa {0},ɩhɛktoo-Paskal,,hɛktoo-Paskal {0},ɩhɛktoo-Paskal {0}
        inch-ofhg,″ Hg,,inHg{0},inHg{0},inHg,,inHg {0},inHg {0},mɛrkiir kasǝkǝmǝ,,mɛrkiir kansǝkǝmǝ {0},mɛrkiir kasǝkǝmǝ {0}
        kilopascal,kPa,,kPa{0},kPa{0},kPa,,kPa {0},kPa {0},ɩkiloo-Paskal,,kiloo-Paskal {0},ɩkiloo-Paskal {0}
        megapascal,MPa,,MPa{0},MPa{0},MPa,,MPa {0},MPa {0},ɩmegaa-Paskal,,megaa-Paskal {0},ɩmegaa-Paskal {0}
        millibar,mbar,,mbar{0},mbar{0},mbar,,mbar {0},mbar {0},ɩmilibaar,,milibaar {0},ɩmilibaar {0}
        millimeter-ofhg,mm Hg,,mmHg{0},mmHg{0},mm Hg,,mmHg {0},mmHg {0},mɛrkiir kɩmilimɛta,,mɛrkiir kamilimɛta {0},mɛrkiir kɩmilimɛta {0}
        pascal,Pa,,Pa{0},Pa{0},Pa,,Pa {0},Pa {0},ɩPaskal,,Paskal {0},ɩPaskal {0}
        pound-force-per-square-inch,psi,,psi{0},psi{0},psi,,psi {0},psi {0},psi,,psi {0},psi {0}
        kilometer-per-hour,km/h,,km/h{0},km/h{0},km/h,,km/h {0},km/h {0},ɩkiloomɛta gakɔŋkɔŋɔ̀ nɩ,,kiloomɛta gakɔŋkɔŋɔ̀ nɩ {0},ɩkiloomɛta gakɔŋkɔŋɔ̀ nɩ {0}
        knot,kn,,kn{0},kn{0},kn,,kn {0},kn {0},akʊra,,ŋkʊra {0},akʊra {0}
        light-speed,pɔɩɩ,,light{0},light{0},pɔɩɩ,,light {0},light {0},pɔɩɩ,,pɔɩɩ {0},pɔɩɩ {0}
        meter-per-second,m/s,,m/s{0},m/s{0},m/s,,m/s {0},m/s {0},ɩmɛta gɩpi nɩ,,mɛta gɩpi nɩ {0},ɩmɛta gɩpi nɩ {0}
        mile-per-hour,mi/h,,mi/h{0},mi/h{0},mi/h,,mi/h {0},mi/h {0},ɩmayɩl gakɔŋkɔŋɔ̀ nɩ,,mayɩl gakɔŋkɔŋɔ̀ nɩ {0},ɩmayɩl gakɔŋkɔŋɔ̀ nɩ {0}
        celsius,°C,,°C{0},°C{0},°C,,°C{0},°C{0},ɩɖegre Sɛlsus,,ɖegre Sɛlsus {0},ɩɖegre Sɛlsus {0}
        fahrenheit,°F,,°F{0},°F{0},°F,,°F{0},°F{0},ɩɖegre Faranhaɩt,,ɖegre Faranhaɩt {0},ɩɖegre Faranhaɩt {0}
        generic,°,,°{0},°{0},°,,°{0},°{0},kpaʊ-na-sarasara kɩɖegre,,kpaʊ-na-sarasara kaɖegre {0},kpaʊ-na-sarasara kɩɖegre {0}
        kelvin,K,,K {0},K {0},K,,K {0},K {0},ɩKɛlwin,,Kɛlwin {0},ɩKɛlwin {0}
        newton-meter,N⋅m,,N⋅m{0},N⋅m{0},N⋅m,,N⋅m {0},N⋅m {0},ɩNiutɔn-mɛta,,Niutɔn-mɛta {0},ɩNiutɔn-mɛta {0}
        acre-foot,ac ft,,ac ft{0},ac ft{0},ac ft,,ac ft {0},ac ft {0},ac ft,,ac ft {0},ac ft {0}
        barrel,bbl,,bbl{0},bbl{0},bbl,,bbl {0},bbl {0},bbl,,bbl {0},bbl {0}
        bushel,bu,,bu{0},bu{0},bu,,bu {0},bu {0},bu,,bu {0},bu {0}
        centiliter,cL,,cL{0},cL{0},cL,,cL {0},cL {0},ɩsɛntilitri,,sɛntilitri {0},ɩsɛntilitri {0}
        cubic-centimeter,cm³,{0}/cm³,cm³{0},cm³{0},cm³,{0}/cm³,cm³ {0},cm³ {0},ɩsɛntimɛta bʊye bʊriu,{0} ɩsɛntimɛta bʊye bʊriu nɩ,sɛntimɛta bʊye bʊriu {0},ɩsɛntimɛta bʊye bʊriu {0}
        cubic-foot,ft³,,ft³{0},ft³{0},ft³,,ft³ {0},ft³ {0},anaŋcǝna bʊyɛ bʊriu,,gʊnaŋcǝna bʊyɛ bʊriu {0},anaŋcǝna bʊyɛ bʊriu {0}
        cubic-inch,in³,,in³{0},in³{0},in³,,in³ {0},in³ {0},asǝkǝmǝ bʊyɛ bʊriu,,nsǝkǝmǝ bʊyɛ bʊriu {0},asǝkǝmǝ bʊyɛ bʊriu {0}
        cubic-kilometer,km³,,km³{0},km³{0},km³,,km³ {0},km³ {0},ɩkiloomɛta bʊyɛ bʊriu,,kiloomɛta bʊye bʊriu {0},ɩkiloomɛta bʊye bʊriu {0}
        cubic-meter,m³,{0}/m³,m³{0},m³{0},m³,{0}/m³,m³ {0},m³ {0},ɩmɛta bʊyɛ bʊriu,{0} ɩmɛta bʊyɛ bʊriu nɩ,mɛta bʊyɛ bʊriu {0},ɩmɛta bʊyɛ bʊriu {0}
        cubic-mile,mi³,,mi³{0},mi³{0},mi³,,mi³ {0},mi³ {0},ɩmayɩl bʊyɛ bʊriu,,mayɩl bʊyɛ bʊriu {0},ɩmayɩl bʊyɛ bʊriu {0}
        cubic-yard,yd³,,yd³{0},yd³{0},yd³,,yd³ {0},yd³ {0},yd³,,yd³ {0},yd³ {0}
        cup,kɔɔpʊ,,c{0},c{0},ɩkɔɔpʊ,,c {0},c {0},ɩkɔɔpʊ,,kɔɔpʊ {0},ɩkɔɔpʊ {0}
        cup-metric,mcup,,mc{0},mc{0},mcup,,mc {0},mc {0},ɩkɔɔpʊ mɛta kʊfaŋʊ kɩja,,kɔɔpʊ mɛta kʊfaŋʊ kɩja {0},ɩkɔɔpʊ mɛta kʊfaŋʊ kɩja {0}
        deciliter,dL,,dL{0},dL{0},dL,,dL {0},dL {0},ɩɖesilitri,,ɖesilitri {0},ɩɖesilitri {0}
        dessert-spoon,dstspn,,dstspn{0},dstspn{0},dstspn,,dstspn {0},dstspn {0},dstspn,,dstspn {0},dstspn {0}
        dessert-spoon-imperial,dstspn Imp,,dstspn Imp{0},dstspn Imp{0},dstspn Imp,,dstspn Imp {0},dstspn Imp {0},dstspn Imp,,dstspn Imp {0},dstspn Imp {0}
        dram,fl.dr.,,fl.dr.{0},fl.dr.{0},ɩɖraam,,dram {0},dram {0},ɩɖraam,,ɖraam {0},ɩɖraam {0}
        drop,ɩsɔr,,dr{0},dr{0},ɩsɔr,,drop {0},drop {0},ɩsɔr,,ʊsɔr {0},ɩsɔr {0}
        fluid-ounce,US fl oz,,fl oz{0},fl oz{0},US fl oz,,fl oz US {0},fl oz US {0},US fl oz,,fl oz US {0},fl oz US {0}
        fluid-ounce-imperial,Imp. fl oz,,fl oz Imp.{0},fl oz Imp.{0},Imp. fl oz,,fl oz Imp. {0},fl oz Imp. {0},Imp. fl oz,,fl oz Imp. {0},fl oz Imp. {0}
        gallon,US gal,{0}/gal US,gal{0},gal{0},US gal,{0}/gal US,gal US {0},gal US {0},ɩgaalɔŋ Amalɩka kʊfaŋʊ kɩja,{0} gaalɔŋ nɩ,gaalɔŋ Amalɩka kʊfaŋʊ kaja {0},ɩgaalɔŋ Amalɩka kʊfaŋʊ kɩja {0}
        gallon-imperial,Imp. gal,{0}/gal Imp.,gal Imp.{0},gal Imp.{0},Imp. gal,{0}/gal Imp.,gal Imp. {0},gal Imp. {0},ɩgaalɔŋ gɛɛshɩ kɩja,{0} gaalɔŋ gɛɛshɩ kaja nɩ,gaalɔŋ gɛɛshɩ kaja {0},ɩgaalɔŋ gɛɛshɩ kɩja {0}
        hectoliter,hL,,hL{0},hL{0},hL,,hL {0},hL {0},ɩhɛktoolitri,,hɛktoolitri {0},ɩhɛktoolitri {0}
        jigger,jɩga,,jigger{0},jigger{0},ɩjɩga,,jigger {0},jigger {0},ɩjɩga,,jɩga {0},ɩjɩga {0}
        liter,litri,{0}/l,l{0},l{0},ɩlitri,{0}/l,l {0},l {0},ɩlitri,{0} ɩlitri nɩ,litri {0},ɩlitri {0}
        megaliter,ML,,ML{0},ML{0},ML,,ML {0},ML {0},ɩmegaalitri,,megaalitri {0},ɩmegaalitri {0}
        milliliter,mL,,mL{0},mL{0},mL,,mL {0},mL {0},ɩmililitri,,mililitri {0},ɩmililitri {0}
        pinch,ɩkɩtɩʊ,,pn{0},pn{0},ɩkɩtɩʊ,,pn {0},pn {0},ɩkɩtɩʊ,,ʊkɩtɩʊ {0},ɩkɩtɩʊ {0}
        pint-metric,pt,,mpt{0},mpt{0},mpt,,mpt {0},mpt {0},litri kasaʊ,,litri kansaʊ {0},litri kasaʊ {0}
        quart-imperial,qt Imp,,qt Imp.{0},qt Imp.{0},qt Imp,,qt Imp. {0},qt Imp. {0},qt Imp,,qt Imp. {0},qt Imp. {0}
        tablespoon,tbsp,,tbsp{0},tbsp{0},tbsp,,tbsp {0},tbsp {0},ɩtɩrɩɩ ʊnyɩʊ kɩja,,tɩrɩɩ ʊnyɩʊ kaja {0},ɩtɩrɩɩ ʊnyɩʊ kɩja {0}
        teaspoon,tsp,,tsp{0},tsp{0},tsp,,tsp {0},tsp {0},ɩtɩrɩɩ kafee kɩja,,tɩrɩɩ kafee kaja {0},ɩtɩrɩɩ kafee kɩja {0}
        """.trimIndent()
  }

  private val blo_Prefixes: String by lazy {
    """square,,,{0} bʊye bʊye
        cubic,,,{0} bʊye bʊriu
        per,,,{0} {1} nɩ
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,jibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,ɛsbi{0}
        1024p7,,,sebi{0}
        1024p8,,,yobi{0}
        10p-1,,,ɖesi{0}
        10p-12,,,pikoo{0}
        10p-15,,,fɛmtoo{0}
        10p-18,,,atoo{0}
        10p-2,,,sɛnti{0}
        10p-21,,,sɛptoo{0}
        10p-24,,,yɔktoo{0}
        10p-27,,,rɔntoo{0}
        10p-3,,,mili{0}
        10p-30,,,kwɛktoo{0}
        10p-6,,,mikroo{0}
        10p-9,,,nanoo{0}
        10p1,,,ɖeka{0}
        10p12,,,tɛraa{0}
        10p15,,,petaa{0}
        10p18,,,ɛsaa{0}
        10p2,,,hɛktoo{0}
        10p21,,,sɛtaa{0}
        10p24,,,yɔta{0}
        10p27,,,rɔnaa{0}
        10p3,,,kiloo{0}
        10p30,,,kwɛtaa{0}
        10p6,,,megaa{0}
        10p9,,,jigaa{0}
        """.trimIndent()
  }

  private val blt_Units: String? = null

  private val blt_Prefixes: String? = null

  private val bm_Units: String? = null

  private val bm_Prefixes: String? = null

  private val bm_Nkoo_Units: String? = null

  private val bm_Nkoo_Prefixes: String? = null

  private val bn_Units: String by lazy {
    """g-force,জি-বল,,{0} জি-বল,{0} জি-বল,জি-বল,,,{0} G,জি-বল,,{0} জি-বল,{0} জি-বল
        meter-per-square-second,,,,,,,,,মিটার প্রতি বর্গ সেকেন্ডে,,{0} মিটার প্রতি বর্গ সেকেন্ডে,{0} মিটার প্রতি বর্গ সেকেন্ডে
        arc-minute,আর্কমিন,,{0}মিনিট,{0}মিনিট,আর্কমিন,,{0} আর্কমিন,{0} আর্কমিন,আর্ক-মিনিট,,{0} আর্ক-মিনিট,{0} আর্ক-মিনিট
        arc-second,আর্কসেকেন্ড,,{0}সেকেন্ড,{0}সেকেন্ড,আর্কসেকেন্ড,,{0} আর্কসেক,{0} আর্কসেক,আর্কসেকেন্ড,,{0} আর্কসেকেন্ড,{0} আর্কসেকেন্ড
        degree,ডিগ্রী,,{0}ডিগ্রী,{0}ডিগ্রী,ডিগ্রী,,{0}ডিগ্রী,{0}ডিগ্রী,ডিগ্রী,,{0} ডিগ্রী,{0} ডিগ্রী
        radian,রেডিয়্যান্স,,,{0} rad,রেডিয়্যান্স,,,{0} rad,রেডিয়্যান,,{0} রেডিয়্যান,{0} রেডিয়্যান্স
        revolution,ঘুর্ণন,,{0} ঘুর্ণন,{0} ঘুর্ণন,ঘুর্ণন,,{0} ঘুর্ণন,{0} ঘুর্ণন,ঘূর্ণন,,{0} ঘুর্ণন,{0} ঘুর্ণন
        acre,একর,,{0} একর,{0} একর,একর,,{0} একর,{0} একর,একর,,{0} একর,{0} একর
        dunam,দুনাম,,{0} দুনাম,{0} দুনাম,দুনাম্স,,{0} দুনাম্স,{0} দুনাম,দুনাম্স,,{0} দুনাম্স,{0} দুনাম্স
        hectare,হেক্টর,,{0} হেক্টর,{0} হেক্টর,হেক্টর,,{0} হেক্টর,{0} হেক্টর,হেক্টর,,{0} হেক্টর,{0} হেক্টর
        square-centimeter,বর্গ সেমি,{0}/cm²,,{0} cm²,বর্গ সেমি,{0}/cm²,,{0} cm²,বর্গ সেন্টিমিটার,{0} প্রতি বর্গ সেন্টিমিটার,{0} বর্গ সেন্টিমিটার,{0} বর্গ সেন্টিমিটার
        square-foot,বর্গ ফুট,,{0} বর্গ ফুট,{0} বর্গ ফুট,বর্গ ফুট,,{0} বর্গ ফুট,{0} বর্গ ফুট,বর্গ ফুট,,{0} বর্গ ফুট,{0} বর্গ ফুট
        square-inch,,,,,,,,,বর্গ ইঞ্চি,প্রতি বর্গ ইঞ্চিতে {0},{0} বর্গ ইঞ্চি,{0} বর্গ ইঞ্চি
        square-kilometer,বর্গ কিমি,{0}/বর্গ কিমি,{0} বর্গ কিমি,{0} বর্গ কিমি,বর্গ কিমি,{0}/বর্গ কিমি,,{0} km²,বর্গ কিলোমিটার,{0} প্রতি বর্গ কিলোমিটার,{0} বর্গ কিলোমিটার,{0} বর্গ কিলোমিটার
        square-meter,বর্গ মিটার,{0}/m²,{0}m²,{0} m²,বর্গ মিটার,{0}/m²,{0} বর্গ মিটার,{0} m²,বর্গ মিটার,{0} প্রতি বর্গ মিটার,{0} বর্গ মিটার,{0} বর্গ মিটার
        square-mile,বর্গ মাইল,{0}/mi²,{0} বর্গ মাইল,{0} বর্গ মাইল,বর্গ মাইল,{0}/mi²,{0} বর্গ মাইল,{0} বর্গ মাইল,বর্গ মাইল,প্রতি বর্গ মাইলে {0},{0} বর্গ মাইল,{0} বর্গ মাইল
        square-yard,বর্গ গজ,,,{0} yd²,বর্গ গজ,,,{0} yd²,yd²,,{0} বর্গ গজ,{0} বর্গ গজ
        item,আইটেম,,{0} আইটেম,{0} আইটেম,আইটেম,,{0} আইটেম,{0} আইটেম,আইটেম,,{0} আইটেম,{0} আইটেম
        karat,ক্যারেট,,,{0} kt,ক্যারেট,,,{0} kt,ক্যারেট,,{0} ক্যারেট,{0} ক্যারেট
        milligram-ofglucose-per-deciliter,,,,,,,,,"মিলিগ্রাম, প্রতি ডেসিলিটারে",,"{0} মিলিগ্রাম, প্রতি ডেসিলিটারে","{0} মিলিগ্রাম, প্রতি ডেসিলিটারে"
        millimole-per-liter,,,,,,,,,"মিলিমোল, প্রতি লিটারে",,"{0} মিলিমোল, প্রতি লিটারে","{0} মিলিমোল, প্রতি লিটারে"
        mole,মোল,,{0} মোল,{0} মোল,মোল,,{0} মোল,{0} মোল,মোল্স,,{0} মোল,{0} মোল্স
        percent,শতাংশ,,,{0}%,শতাংশ,,,{0}%,শতাংশ,,{0}শতাংশ,{0}শতাংশ
        permille,,,,,প্রতিমাইল,,,{0}‰,প্রতিমাইল,,{0} প্রতিমাইল,{0}প্রতিমাইল
        permillion,,,,,,,,,"ভাগ, প্রতি মিলিয়নে",,"{0} ভাগ, প্রতি মিলিয়নে","{0} ভাগ, প্রতি মিলিয়নে"
        permyriad,পারমিরিয়াড,,,{0}‱,পারমিরিয়াড,,,{0}‱,পারমিরিয়াড,,{0} পারমিরিয়াড,{0} পারমিরিয়াড
        portion-per-1e9,পার্ট/ বিলিয়ন,,{0}ppb,{0} ppb,পার্ট/ বিলিয়ন,,,{0} ppb,পার্ট প্রতি বিলিয়ন,,{0} পার্ট প্রতি বিলিয়ন,{0} পার্ট প্রতি বিলিয়ন
        liter-per-100-kilometer,লি/100কিমি,,{0} লি/100কিমি,{0} লি/100কিমি,লি/100কিমি,,{0} লি/100কিমি,{0} লি/100কিমি,"লিটার, প্রতি ১০০ কিলোমিটারে",,"{0} লিটার, প্রতি ১০০ কিলোমিটারে","{0} লিটার, প্রতি ১০০ কিলোমিটারে"
        liter-per-kilometer,লিটার/কিমি,,,{0} L/km,লিটার/কিমি,,,{0} L/km,"লিটার, প্রতি কিলোমিটারে",,"{0} লিটার, প্রতি কিলোমিটারে","{0} লিটার, প্রতি কিলোমিটারে"
        mile-per-gallon,মাইল/গ্যালন,,{0} mpg,{0} mpg,মাইল/গ্যালন,,{0} mpg,{0} mpg,"মাইল, প্রতি গ্যালনে",,"{0} মাইল, প্রতি গ্যালনে","{0} মাইল, প্রতি গ্যালনে"
        mile-per-gallon-imperial,mpg UK,,{0}m/gUK,{0}m/gUK,miles/gal Imp,,,{0} mpg Imp.,"মাইল, প্রতি ইম্পেরিয়াল গ্যালনে",,"{0} মাইল, প্রতি ইম্পেরিয়াল গ্যালনে","{0} মাইল, প্রতি ইম্পেরিয়াল গ্যালনে"
        bit,বিট,,{0} বিট,{0} বিট,বিট,,{0} বিট,{0} বিট,বিট,,{0} বিট,{0} বিট
        byte,বাইট,,{0} বাইট,{0} বাইট,বাইট,,{0} বাইট,{0} বাইট,বাইট,,{0} বাইট,{0} বাইট
        gigabit,,,,,,,,,গিগাবিট,,{0} গিগাবিট,{0} গিগাবিট
        gigabyte,,,,,,,,,গিগাবাইট,,{0} গিগাবাইট,{0} গিগাবাইট
        kilobit,,,,,,,,,কিলোবিট,,{0} কিলোবিট,{0} কিলোবিট
        kilobyte,,,,,,,,,কিলোবাইট,,{0} কিলোবাইট,{0} কিলোবাইট
        megabit,,,,,,,,,মেগাবিট,,{0} মেগাবিট,{0} মেগাবিট
        megabyte,,,,,,,,,মেগাবাইট,,{0} মেগাবাইট,{0} মেগাবাইট
        petabyte,PByte,,,{0} PB,PByte,,,{0} PB,পেটাবাইটস,,{0} পেটাবাইটস,{0} পেটাবাইটস
        terabit,Tbit,,,{0} Tb,Tbit,,,{0} Tb,টেরাবিট,,{0} টেরাবিট,{0} টেরাবিট
        terabyte,TByte,,,{0} TB,TByte,,,{0} TB,টেরাবাইট,,{0} টেরাবাইট,{0} টেরাবাইট
        century,শতক,,{0} শতক,{0} শতক,শতক,,{0} শতক,{0} শতক,শতাব্দী,,{0} শতাব্দী,{0} শতাব্দী
        day,দিন,{0}/দিন,{0} দিন,{0} দিন,দিন,{0}/দিন,{0} দিন,{0} দিন,দিন,{0}/দিন,{0} দিন,{0} দিন
        decade,দশক,,{0} দশক,{0} দশক,দশক,,{0} দশক,{0} দশক,দশক,,{0} দশক,{0} দশক
        hour,ঘন্টা,{0}/ঘ:,{0} ঘঃ,{0} ঘঃ,ঘন্টা,{0} প্রতি ঘন্টা,{0} ঘন্টা,{0} ঘন্টা,ঘন্টা,{0} প্রতি ঘন্টা,{0} ঘন্টা,{0} ঘন্টা
        microsecond,μsecs,,{0}μs,{0}μs,μsecs,,,{0} μs,মাইক্রোসেকেন্ড,,{0} মাইক্রোসেকেন্ড,{0} মাইক্রোসেকেন্ড
        millisecond,মিলিসেকেন্ড,,,{0} ms,মিলিসেকেন্ড,,,{0} ms,মিলিসেকেন্ড,,{0} মিলিসেকেন্ড,{0} মিলিসেকেন্ড
        minute,মিনিট,{0}/মি:,{0} মিঃ,{0} মিঃ,মিনিট,{0} প্রতি মিনিট,{0} মিনিট,{0} মিনিট,মিনিট,{0} প্রতি মিনিট,{0} মিনিট,{0} মিনিট
        month,মাস,{0}/মাস,{0} মাস,{0} মাস,মাস,{0} প্রতি মাস,{0} মাস,{0} মাস,মাস,{0} প্রতি মাস,{0} মাস,{0} মাস
        nanosecond,ন্যানোসেকেন্ড,,{0}ns,{0}ns,ন্যানোসেকেন্ড,,,{0} ns,ন্যানোসেকেন্ড,,{0} ন্যানোসেকেন্ড,{0} ন্যানোসেকেন্ড
        night,রাত্রি,{0}/রাত্রি,{0}রাত্রি,{0}রাত্রি,রাত্রি,{0}/রাত্রি,{0} রাত্রি,{0} রাত্রি,রাত্রি,{0}/রাত্রি,{0} রাত্রি,{0} রাত্রি
        quarter,ত্রৈমাসিক,{0}/ত্রৈমাসিক,{0}ত্রৈমাসিক,{0}ত্রৈমাসিক,ত্রৈমাসিক,{0}/ত্রৈমাসিক,{0} ত্রৈমাসিক,{0} ত্রৈমাসিক,ত্রৈমাসিক,{0}/ত্রৈমাসিক,{0} ত্রৈমাসিক,{0} ত্রৈমাসিক
        second,সেকেন্ড,{0}/সেঃ,{0} সেঃ,{0} সেঃ,সেকেন্ড,{0} প্রতি সেকেন্ড,{0} সেকেন্ড,{0} সেকেন্ড,সেকেন্ড,{0} প্রতি সেকেন্ড,{0} সেকেন্ড,{0} সেকেন্ড
        week,সপ্তাহ,{0}/সপ্তাহ,{0} সপ্তাহ,{0} সপ্তাহ,সপ্তাহ,{0} প্রতি সপ্তাহ,{0} সপ্তাহ,{0} সপ্তাহ,সপ্তাহ,{0} প্রতি সপ্তাহ,{0} সপ্তাহ,{0} সপ্তাহ
        year,বছর,{0}/বছর,{0} বছর,{0} বছর,বছর,{0} প্রতি বছর,{0} বছর,{0} বছর,বছর,{0} প্রতি বছর,{0} বছর,{0} বছর
        ampere,,,,,,,,,অ্যাম্পিয়ার,,{0} অ্যাম্পিয়ার,{0} অ্যাম্পিয়ার
        milliampere,,,,,,,,,মিলি-অ্যাম্পিয়ার,,{0} মিলি-অ্যাম্পিয়ার,{0} মিলি-অ্যাম্পিয়ার
        ohm,ওহম,,,{0} Ω,ওহম,,,{0} Ω,ওহম,,{0} ওহম,{0} ওহম
        volt,ভোল্ট,,,{0} V,ভোল্ট,,,{0} V,ভোল্ট,,{0} ভোল্ট,{0} ভোল্ট
        british-thermal-unit,,,,,,,,,ব্রিটিশ থার্মাল ইউনিট,,{0} ব্রিটিশ থার্মাল ইউনিট,{0} ব্রিটিশ থার্মাল ইউনিট
        calorie,,,,,,,,,ক্যালোরি,,{0} ক্যালোরি,{0} ক্যালোরি
        electronvolt,ইলেকট্রন ভোল্ট,,,{0} eV,ইলেকট্রন ভোল্ট,,,{0} eV,ইলেকট্রন ভোল্ট,,{0} ইলেকট্রন ভোল্ট,{0} ইলেকট্রন ভোল্ট
        foodcalorie,Cal,,{0} Cal,{0} Cal,Cal,,{0} Cal,{0} Cal,ক্যালোরি,,{0} ক্যালোরি,{0} ক্যালোরি
        joule,জুল,,,{0} J,জুল,,,{0} J,জুল,,{0} জুল,{0} জুল
        kilocalorie,,,,,,,,,কিলোক্যালরি,,{0} কিলোক্যালরি,{0} কিলোক্যালরি
        kilojoule,,,,,,,,,কিলোজুল,,{0} কিলোজুল,{0} কিলোজুল
        kilowatt-hour,,,,,,,,,কিলোওয়াট ঘন্টা,,{0} কিলোওয়াট ঘন্টা,{0} কিলোওয়াট ঘন্টা
        therm-us,US থার্ম,,{0} US থার্ম,{0} US থার্ম,US থার্ম,,{0} US থার্ম,{0} US থার্ম,US থার্ম,,{0} US থার্ম,{0} US থার্ম
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0}kWh/100km,,,,,কিলোওয়াট-ঘণ্টা প্রতি 100 কিলোমিটার,,{0} কিলোওয়াট-ঘণ্টা প্রতি 100 কিলোমিটার,{0} কিলোওয়াট-ঘণ্টা প্রতি 100 কিলোমিটার
        newton,নিউটন,,,{0} N,নিউটন,,,{0} N,নিউটন্স,,{0} নিউটন,{0} নিউটন্স
        gigahertz,,,,,,,,,গিগাহার্জ,,{0} গিগাহার্জ,{0} গিগাহার্জ
        hertz,,,,,,,,,হার্জ,,{0} হার্জ,{0} হার্জ
        kilohertz,,,,,,,,,কিলোহার্জ,,{0} কিলোহার্জ,{0} কিলোহার্জ
        megahertz,,,,,,,,,মেগাহার্জ,,{0} মেগাহার্জ,{0} মেগাহার্জ
        dot,ডট,,{0}ডট,{0}ডট,ডট,,{0} ডট,{0} ডট,ডট,,{0} ডট,{0} ডট
        dot-per-centimeter,dpcm,,{0}dpcm,{0}dpcm,dpcm,,{0} dpcm,{0} dpcm,সেন্টিমিটার প্রতি বিন্দু,,সেন্টিমিটার প্রতি {0} বিন্দু,সেন্টিমিটার প্রতি {0} বিন্দু
        dot-per-inch,dpi,,{0}dpi,{0}dpi,dpi,,{0} dpi,{0} dpi,ইঞ্চি প্রতি বিন্দু,,ইঞ্চি প্রতি {0} বিন্দু,ইঞ্চি প্রতি {0} বিন্দু
        em,,,,,,,,,টাইপোগ্রাফিক em,,{0} em,{0} ems
        megapixel,মেগাপিক্সেল,,,{0} MP,মেগাপিক্সেল,,,{0} MP,মেগাপিক্সেল,,{0} মেগাপিক্সেল,{0} মেগাপিক্সেল
        pixel,পিক্সেল,,{0} পিক্সেল,{0} পিক্সেল,পিক্সেল,,,{0} px,পিক্সেল,,{0} পিক্সেল,{0} পিক্সেল
        pixel-per-centimeter,,,,,,,,,সেন্টিমিটার প্রতি পিক্সেল,,সেন্টিমিটার প্রতি {0} পিক্সেল,সেন্টিমিটার প্রতি {0} পিক্সেল
        pixel-per-inch,,,,,,,,,ইঞ্চি প্রতি পিক্সেল,,ইঞ্চি প্রতি {0} পিক্সেল,ইঞ্চি প্রতি {0} পিক্সেল
        astronomical-unit,,,,,,,,,জ্যোতির্বিজ্ঞান একক,,{0} জ্যোতির্বিজ্ঞান একক,{0} জ্যোতির্বিজ্ঞান একক
        centimeter,সেমি,{0}/সেমি,{0} সেমি,{0} সেমি,সেমি,{0} প্রতি সেমি,{0} সেমি,{0} সেমি,সেন্টিমিটার,{0} প্রতি সেন্টিমিটার,{0} সেন্টিমিটার,{0} সেন্টিমিটার
        decimeter,ডেমি,,{0} ডেমি,{0} ডেমি,ডেমি,,{0} ডেমি,{0} ডেমি,ডেসিমিটার,,{0} ডেসিমিটার,{0} ডেসিমিটার
        earth-radius,,,,,,,,,পৃথিবীর ব্যাসার্ধ,,{0} পৃথিবীর ব্যাসার্ধ,{0} পৃথিবীর ব্যাসার্ধ
        foot,ফুট,{0} প্রতি ফুট,{0} ফুট,{0} ফুট,ফুট,{0} প্রতি ফুট,{0} ফুট,{0} ফুট,ফুট,{0} প্রতি ফুট,{0} ফুট,{0} ফুট
        furlong,ফার্লং,,{0} ফার্লং,{0} ফার্লং,ফার্লং,,{0} ফার্লং,{0} ফার্লং,ফার্লং,,{0} ফার্লং,{0} ফার্লং
        inch,ইঞ্চি,{0}/ইঞ্চি,{0} ইঞ্চি,{0} ইঞ্চি,ইঞ্চি,{0} প্রতি ইঞ্চি,{0} ইঞ্চি,{0} ইঞ্চি,ইঞ্চি,{0} প্রতি ইঞ্চি,{0} ইঞ্চি,{0} ইঞ্চি
        kilometer,কিলোমিটার,{0}/কিমি,{0} কিমি,{0} কিমি,কিলোমিটার,{0} প্রতি কিমি,{0} কিমি,{0} কিমি,কিলোমিটার,{0} প্রতি কিলোমিটার,{0} কিলোমিটার,{0} কিলোমিটার
        light-year,আলোকবর্ষ,,{0} আলোকবর্ষ,{0} আলোকবর্ষ,আলোকবর্ষ,,{0} আলোকবর্ষ,{0} আলোকবর্ষ,আলোকবর্ষ,,{0} আলোকবর্ষ,{0} আলোকবর্ষ
        meter,মিটার,{0}/মি,{0} মি,{0} মি,মিটার,{0} প্রতি মি,{0} মি,{0} মি,মিটার,{0} প্রতি মিটার,{0} মিটার,{0} মিটার
        micrometer,,,,,μmeters,,,{0} μm,মাইক্রোমিটার,,{0} মাইক্রোমিটার,{0} মাইক্রোমিটার
        mile,মাইল,,{0} মাইল,{0} মাইল,মাইল,,{0} মাইল,{0} মাইল,মাইল,,{0} মাইল,{0} মাইল
        mile-scandinavian,,,,,,,,,মাইল-স্ক্যান্ডিনেভিয়ান,,{0} মাইল-স্ক্যান্ডিনেভিয়ান,{0} মাইল-স্ক্যান্ডিনেভিয়ান
        millimeter,মিমি,,{0} মিমি,{0} মিমি,মিমি,,{0} মিমি,{0} মিমি,মিলিমিটার,,{0} মিলিমিটার,{0} মিলিমিটার
        nanometer,,,,,,,,,ন্যানোমিটার,,{0} ন্যানোমিটার,{0} ন্যানোমিটার
        nautical-mile,,,,,,,,,নটিক্যাল মাইল,,{0} নটিক্যাল মাইল,{0} নটিক্যাল মাইল
        parsec,parsecs,,,{0} pc,parsecs,,,{0} pc,parsecs,,{0} parsec,{0} parsecs
        picometer,পিমি,,{0} পিমি,{0} পিমি,পিমি,,{0} পিমি,{0} পিমি,পিকোমিটার,,{0} পিকোমিটার,{0} পিকোমিটার
        solar-radius,,,,,সৌর রেডি,,,{0} R☉,সৌর রেডি,,{0} সৌর রেডিয়াস,{0} সৌর রেডি
        yard,গজ,,{0} গজ,{0} গজ,গজ,,{0} গজ,{0} গজ,গজ,,{0} গজ,{0} গজ
        candela,,,,,,,,,ক্যান্ডেলা,,{0} ক্যান্ডেলা,{0} ক্যান্ডেলা
        lumen,,,,,,,,,লুমেন,,{0} লুমেন,{0} লুমেন
        lux,,,,,,,,,লাক্স,,{0} লাক্স,{0} লাক্স
        solar-luminosity,সৌর ঔজ্জ্বল্য,,,{0} L☉,সৌর ঔজ্জ্বল্য,,,{0} L☉,সৌর ঔজ্জ্বল্য,,{0} সৌর ঔজ্জ্বল্য,{0} সৌর ঔজ্জ্বল্যতাগুলি
        carat,ক্যারেট,,,{0} CD,ক্যারেট,,,{0} CD,ক্যারেট,,{0} ক্যারেট,{0} ক্যারেট
        dalton,ড্যালটন্স,,,{0} Da,ড্যালটন্স,,,{0} Da,ড্যালটন্স,,{0} ড্যালটন্স,{0} ড্যালটন্স
        earth-mass,পৃথিবীর ভর,,,{0} M⊕,পৃথিবীর ভর,,,{0} M⊕,পৃথিবীর ভর,,{0} পৃথিবীর ভর,{0} পৃথিবীর ভর
        gram,গ্রাম,{0}/গ্রা:,{0} গ্রাম,{0} গ্রাম,গ্রাম,{0} প্রতি গ্রাম,{0}গ্রাম,{0} গ্রাম,গ্রাম,{0} প্রতি গ্রাম,{0} গ্রাম,{0} গ্রাম
        kilogram,কেজি,{0}/কেজি,{0} কেজি,{0} কেজি,কেজি,{0} প্রতি কেজি,{0} কেজি,{0} কেজি,কিলোগ্রাম,{0} প্রতি কিলোগ্রাম,{0} কিলোগ্রাম,{0} কিলোগ্রাম
        microgram,,,,,,,,,মাইক্রোগ্রাম,,{0} মাইক্রোগ্রাম,{0} মাইক্রোগ্রাম
        milligram,মিগ্রা:,,{0}/মিগ্রা:,{0}/মিগ্রা:,,,,,মিলিগ্রাম,,{0} মিলিগ্রাম,{0} মিলিগ্রাম
        ounce,আউন্স,{0}/আউন্স,{0} আউন্স,{0} আউন্স,আউন্স,{0} প্রতি আউন্স,{0} আউন্স,{0} আউন্স,আউন্স,{0} প্রতি আউন্স,{0} আউন্স,{0} আউন্স
        ounce-troy,,,,,,,,,ট্রয় আউন্স,,{0} ট্রয় আউন্স,{0} ট্রয় আউন্স
        pound,পাউন্ড,{0}/পাউন্ড,{0} পাউন্ড,{0} পাউন্ড,পাউন্ড,{0}/lb,{0} পাউন্ড,{0} lb,পাউন্ড,{0} প্রতি পাউন্ড,{0} পাউন্ড,{0} পাউন্ড
        solar-mass,সৌর ভর,,,{0} M☉,সৌর ভর,,,{0} M☉,সৌর ভর,,{0} সৌর ভর,{0} সৌর ভর
        ton,টন,,{0} টন,{0} টন,,,,,টন,,{0} টন,{0} টন
        tonne,টন,,{0} টন,{0} টন,,,,,মেট্রিক টন,,{0} মেট্রিক টন,{0} মেট্রিক টন
        gigawatt,,,,,,,,,গিগাওয়াট,,{0} গিগাওয়াট,{0} গিগাওয়াট
        horsepower,,,,,,,,,হর্সপাওয়ার,,{0} হর্সপাওয়ার,{0} হর্সপাওয়ার
        kilowatt,,,,,,,,,কিলোওয়াট,,{0} কিলোওয়াট,{0} কিলোওয়াট
        megawatt,,,,,,,,,মেগাওয়াট,,{0} মেগাওয়াট,{0} মেগাওয়াট
        milliwatt,,,,,,,,,মিলিওয়াট,,{0} মিলিওয়াট,{0} মিলিওয়াট
        watt,ওয়াট,,{0} ওয়াট,{0} ওয়াট,ওয়াট,,,{0} W,ওয়াট,,{0} ওয়াট,{0} ওয়াট
        bar,বার,,{0} বার,{0} বার,বার,,{0} বার,{0} বার,বার,,{0} বার,{0} বার
        hectopascal,,,,,,,,,হেক্টোপাসকল,,{0} হেক্টোপাসকল,{0} হেক্টোপাসকল
        inch-ofhg,,,,,,,,,ইঞ্চি পারদ,,{0} ইঞ্চি পারদ,{0} ইঞ্চি পারদ
        kilopascal,,,,,,,,,কিলোপ্যাসকেল,,{0} কিলোপ্যাসকেল,{0} কিলোপ্যাসকেল
        megapascal,,,,,,,,,মেগাপাস্কেল,,{0} মেগাপাস্কাল,{0} মেগাপাস্কাল
        millibar,mbar,,{0} mb,{0} mb,,,,,মিলিবার,,{0} মিলিবার,{0} মিলিবার
        millimeter-ofhg,,,,,,,,,মিলিমিটার পারদ,,{0} মিলিমিটার পারদ,{0} মিলিমিটার পারদ
        pascal,,,,,,,,,প্যাসকেল,,{0} প্যাসকেল,{0} প্যাসকেল
        pound-force-per-square-inch,,,,,,,,,বর্গইঞ্চি প্রতি পাউন্ড,,{0} বর্গইঞ্চি প্রতি পাউন্ড,{0} বর্গইঞ্চি প্রতি পাউন্ড
        beaufort,,,,,,,,,বিউফোর্ট,,বিউফোর্ট {0},বিউফোর্ট {0}
        kilometer-per-hour,km/hr,,{0}kph,{0}kph,km/h,,{0} kph,{0} km/h,ঘন্টা প্রতি কিলোমিটার,,{0} ঘন্টা প্রতি কিলোমিটার,{0} ঘন্টা প্রতি কিলোমিটার
        knot,,,,,,,,,নট,,{0} নট,{0} নট
        meter-per-second,মি/সেক,,{0}m/s,{0}m/s,মিটার প্রতি সেকেন্ড,,,{0} m/s,মিটার প্রতি সেকেন্ড,,{0} মিটার প্রতি সেকেন্ড,{0} মিটার প্রতি সেকেন্ড
        mile-per-hour,মাইল/ঘ:,,{0}mph,{0}mph,ঘন্টা প্রতি মাইল,,{0} mph,{0} mph,ঘন্টা প্রতি মাইল,,{0} ঘন্টা প্রতি মাইল,{0} ঘন্টা প্রতি মাইল
        celsius,,,,,deg. C,,,{0}°C,ডিগ্রী সেলসিয়াস,,{0} ডিগ্রী সেলসিয়াস,{0} ডিগ্রী সেলসিয়াস
        fahrenheit,,,,,,,,,ডিগ্রী ফারেনহাইট,,{0} ডিগ্রী ফারেনহাইট,{0} ডিগ্রী ফারেনহাইট
        kelvin,,,,,,,,,কেলভিন,,{0} কেলভিন,{0} কেলভিন
        newton-meter,,,,,,,,,নিউটন-একক,,{0} নিউটন-একক,{0} নিউটন-এককগুলি
        pound-force-foot,,,,,,,,,পাউন্ড-ফিট,,{0} পাউন্ড-ফোর্স-ফিট,{0} পাউন্ড-ফিট
        acre-foot,acre ft,,,{0} ac ft,,,,,একর-ফুট,,{0} একর-ফুট,{0} একর-ফুট
        barrel,,,,,ব্যারেল,,,{0} bbl,ব্যারেল,,{0} ব্য়ারেল,{0} ব্যারেল
        bushel,,,,,,,,,বুশেল,,{0} বুশেল,{0} বুশেল
        centiliter,,,,,,,,,সেন্টিলিটার,,{0} সেন্টিলিটার,{0} সেন্টিলিটার
        cubic-centimeter,,,,,,,,,কিউবিক সেন্টিমিটার,{0} প্রতি কিউবিক সেন্টিমিটার,{0} কিউবিক সেন্টিমিটার,{0} কিউবিক সেন্টিমিটার
        cubic-foot,,,,,,,,,ঘনক ফুট,,{0} কিউবিক ফুট,{0} কিউবিক ফুট
        cubic-inch,,,,,,,,,কিউবিক ইঞ্চি,,{0} কিউবিক ইঞ্চি,{0} কিউবিক ইঞ্চি
        cubic-kilometer,কিউবিক কিলোমিটার,,{0}km³,{0}km³,কিউবিক কিলোমিটার,,{0} কিউবিক কিলোমিটার,{0} কিউবিক কিলোমিটার,কিউবিক কিলোমিটার,,{0} কিউবিক কিলোমিটার,{0} কিউবিক কিলোমিটার
        cubic-meter,,,,,,,,,কিউবিক মিটার,{0} প্রতি কিউবিক মিটার,{0} কিউবিক মিটার,{0} কিউবিক মিটার
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,কিউবিক মাইল,,{0} কিউবিক মাইল,{0} কিউবিক মাইল
        cubic-yard,,,,,,,,,কিউবিক গজ,,{0} কিউবিক গজ,{0} yd³
        cup,,,,,,,,,কাপ,,{0} কাপ,{0} কাপ
        cup-metric,,,,,,,,,মেট্রিক কাপ,,{0} মেট্রিক কাপ,{0} মেট্রিক কাপ
        deciliter,,,,,,,,,ডেসিলিটার,,{0} ডেসিলিটার,{0} ডেসিলিটার
        dessert-spoon,dsp,,{0}dsp,{0}dsp,,,,,ডেসার্ট চামচ,,{0} ডেসার্ট চামচ,{0} ডেসার্ট চামচ
        dessert-spoon-imperial,dsp Imp,,{0}dsp-Imp,{0}dsp-Imp,,,,,ইম্পেরিয়েল ডেসার্ট চামচ,,{0} ইম্পেরিয়েল ডেসার্ট চামচ,{0} ইম্পেরিয়েল ডেসার্ট চামচ
        dram,fl.dr.,,{0}fl.dr.,{0}fl.dr.,ড্র্যাম ফ্লুইড,,,{0} dram fl,ড্র্যাম,,{0} ড্র্যাম,{0} ড্র্য়াম
        drop,dr,,{0}dr,{0}dr,ফোঁটা,,{0} ফোঁটা,{0} ফোঁটা,ফোঁটা,,{0} ফোঁটা,{0} ফোঁটা
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,ফ্লুইড আউন্স,,{0} ফ্লুইড আউন্স,{0} ফ্লুইড আউন্স
        fluid-ounce-imperial,Imp. fl oz,,{0}fl oz Im,{0}fl oz Im,,,,,Imp. fl oz,,{0} Imp. fl oz,{0} Imp. fluid ounces
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal US,{0} gal,{0} gal,গ্যালন,{0} প্রতি গ্যালন,{0} গ্যালন,{0} গ্যালন
        gallon-imperial,Imp. gal,{0}/galIm,{0}galIm,{0}galIm,,,,,ইম্পেরিয়াল গ্যালন,{0} প্রতি ইম্পেরিয়াল গ্যালন,{0} ইম্পেরিয়াল গ্যালন,{0} ইম্পেরিয়াল গ্যালন
        hectoliter,,,,,,,,,হেক্টোলিটার,,{0} হেক্টোলিটার,{0} হেক্টোলিটার
        jigger,জিগার,,{0} জিগার,{0} জিগার,জিগার,,{0} জিগার,{0} জিগার,জিগার,,{0} জিগার,{0} জিগার
        liter,লিটার,{0}/l,{0} লিটার,{0} লিটার,লিটার,{0}/l,{0} লিটার,{0} লিটার,লিটার,{0} প্রতি লিটার,{0} লিটার,{0} লিটার
        megaliter,,,,,,,,,মেগালিটার,,{0} মেগালিটার,{0} মেগালিটার
        milliliter,,,,,,,,,মিলিলিটার,,{0} মিলিলিটার,{0} মিলিলিটার
        pinch,চিমটে,,{0} চিমটে,{0} চিমটে,চিমটে,,{0} চিমটে,{0} চিমটে,চিমটে,,{0} চিমটে,{0} চিমটে
        pint,পিন্ট,,,{0} pt,পিন্ট,,,{0} pt,পিন্ট,,{0} পিন্ট,{0} পিন্ট
        pint-metric,pt,,,{0} mpt,,,,,মেট্রিক পিন্ট,,{0} মেট্রিক পিন্ট,{0} মেট্রিক পিন্ট
        quart,,,,,,,,,কোয়ার্ট,,{0} কোয়ার্ট,{0} কোয়ার্ট
        quart-imperial,,,,,,,,,Imp. quart,,{0} Imp. quart,{0} Imp. quart
        tablespoon,,,,,,,,,টেবিল-চামচ,,{0} টেবিল-চামচ,{0} টেবিল-চামচ
        teaspoon,,,,,,,,,চা-চামচ,,{0} চা-চামচ,{0} চা-চামচ
        point,pts,,,{0} pt,,,,,,,,
        """.trimIndent()
  }

  private val bn_Prefixes: String by lazy {
    """square,,,বর্গ{0}
        cubic,,,ঘন {0}
        per,,,{1} প্রতি {0}
        1024p1,{0}কি,{0}কি,{0}কিবি
        10p-1,ডে{0},ডে {0},ডেসি{0}
        10p-12,পি{0},পি {0},পিকো{0}
        10p-15,ফে{0},ফে {0},ফেমটো{0}
        10p-18,এ{0},এ {0},এট্টো{0}
        10p-2,সে{0},সে {0},সেন্টি{0}
        10p-21,জে{0},জে {0},জেপ্টো{0}
        10p-24,ইয়ো{0},ইয়ো {0},ইয়োক্টো{0}
        10p-27,র{0},রঃ{0},রন্টো{0}
        10p-3,মি{0},মি {0},মিলি{0}
        10p-30,কু{0},কুঃ{0},কুয়েক্টো{0}
        10p-6,,,মাইক্রো{0}
        10p-9,ন্যা{0},ন্যা {0},ন্যানো{0}
        10p1,ডে{0},ডা {0},ডেকা{0}
        10p12,টে{0},টে {0},টেরা{0}
        10p15,পে{0},পে {0},পেটা{0}
        10p18,এ{0},এঃ{0},এক্সা{0}
        10p2,হে {0},হে{0},হেক্টো{0}
        10p21,জে{0},জেঃ{0},জেট্টা{0}
        10p24,ই{0},ইঃ{0},ইয়োট্টা{0}
        10p27,রো{0},রোঃ{0},রোনা{0}
        10p3,কি{0},কি{0},কিলো{0}
        10p30,কো{0},কোঃ{0},কোয়েটা{0}
        10p6,মে {0},মে{0},মেগা{0}
        10p9,গি{0},গি {0},গিগা{0}
        """.trimIndent()
  }

  private val bn_IN_Units: String? = null

  private val bn_IN_Prefixes: String by lazy {
    """times,,,{0}-{1}
        """.trimIndent()
  }

  private val bo_Units: String? = null

  private val bo_Prefixes: String? = null

  private val bo_IN_Units: String? = null

  private val bo_IN_Prefixes: String? = null

  private val br_Units: String by lazy {
    """g-force,G,,{0}G,{0}G,G,,,{0} G,buanadur g,,{0} buanadur g,{0} buanadur g
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,,,,,metroù dre eilenn garrez,,{0} metr dre eilenn garrez,{0} metr dre eilenn garrez
        arc-minute,′,,,{0}′,′,,,{0}′,′,,,{0}′
        arc-second,″,,,{0}″,″,,,{0}″,″,,,{0}″
        degree,°,,{0}°,{0}°,deg,,{0} deg,{0} deg,derezioù,,{0} derez,{0} derez
        radian,rad,,{0}rad,{0}rad,,,,,radianoù,,{0} radian,{0} radian
        revolution,tr,,{0}tr,{0}tr,tr,,{0} tr,{0} tr,tro,,{0} dro,{0} tro
        acre,ac,,{0}ac,{0}ac,ac,,,{0} ac,akroù,,{0} akr,{0} akr
        dunam,dounam,,{0}dounam,{0}dounam,dounam,,{0} dounam,{0} dounam,dounamoù,,{0} dounam,{0} dounam
        hectare,ha,,{0}ha,{0}ha,ha,,,{0} ha,hektaroù,,{0} hektar,{0} hektar
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,,,,,santimetroù karrez,{0} dre santimetr karrez,{0} santimetr karrez,{0} santimetr karrez
        square-foot,ft²,,{0}ft²,{0}ft²,,,,,troatadoù karrez,,{0} troatad karrez,{0} troatad karrez
        square-inch,in²,{0}/in²,{0}in²,{0}in²,,,,,meutadoù karrez,{0} dre veutad karrez,{0} meutad karrez,{0} meutad karrez
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,kilometroù karrez,{0} dre gilometr karrez,{0} c'hilometr karrez,{0} kilometr karrez
        square-meter,m²,{0}/m²,{0}m²,{0}m²,,,,,metroù karrez,{0} dre vetr karrez,{0} metr karrez,{0} metr karrez
        square-mile,mi²,{0}/mi²,{0}mi²,{0}mi²,,,,,miltirioù karrez,{0} dre viltir karrez,{0} miltir karrez,{0} miltir karrez
        square-yard,yd²,,{0}yd²,{0}yd²,,,,,yardoù karrez,,{0} yard karrez,{0} yard karrez
        karat,kt,,{0}kt,{0}kt,,,,,karatoù,,{0} c'harat,{0} karat
        milligram-ofglucose-per-deciliter,mg/dl,,{0}mg/dl,{0}mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligramm dre zesilitr,,{0} milligramm dre zesilitr,{0} milligramm dre zesilitr
        millimole-per-liter,mmol/l,,{0}mmol/l,{0}mmol/l,millimol/litr,,{0} mmol/l,{0} mmol/l,millimoloù dre litr,,{0} millimol dre litr,{0} millimol dre litr
        mole,mol,,{0}mol,{0}mol,,,,,moloù,,{0} mol,{0} mol
        percent,%,,{0}%,{0}%,%,,{0} %,{0} %,dre gant,,{0} dre gant,{0} dre gant
        permille,‰,,{0}‰,{0}‰,‰,,{0} ‰,{0} ‰,dre vil,,{0} dre vil,{0} dre vil
        permyriad,‱,,{0}‱,{0}‱,‱,,{0} ‱,{0} ‱,dre zek mil,,{0} dre zek mil,{0} dre zek mil
        liter-per-100-kilometer,l/100km,,{0}l/100km,{0}l/100km,l/100km,,{0} l/100km,{0} l/100km,litroù dre 100 kilometr,,{0} litr dre 100 kilometr,{0} litr dre 100 kilometr
        liter-per-kilometer,l/km,,{0}l/km,{0}l/km,l/km,,{0} l/km,{0} l/km,litroù dre gilometr,,{0} litr dre gilometr,{0} litr dre gilometr
        mile-per-gallon,mi/gal,,{0}mi/gal,{0}mi/gal,mi/gal,,{0} mi/gal,{0} mi/gal,miltirioù dre cʼhallon,,{0} miltir dre c'hallon,{0} miltir dre c'hallon
        mile-per-gallon-imperial,mi/gIm,,{0}mi/gIm,{0}mi/gIm,mi/gal imp.,,{0} mi/gal imp.,{0} mi/gal imp.,miltirioù dre cʼhallon impalaerel,,{0} miltir dre cʼhallon impalaerel,{0} miltir dre cʼhallon impalaerel
        bit,bit,,{0}bit,{0}bit,,,,,bitoù,,{0} bit,{0} bit
        byte,o,,{0}o,{0} o,o,,{0} o,{0} o,oktedoù,,{0} okted,{0} okted
        gigabit,Gbit,,{0}Gbit,{0}Gbit,Gbit,,{0} Gbit,{0} Gbit,gigabitoù,,{0} gigabit,{0} gigabit
        gigabyte,Go,,{0}Go,{0}Go,Go,,{0} Go,{0} Go,gigaoktedoù,,{0} gigaokted,{0} gigaokted
        kilobit,kbit,,{0}kbit,{0}kbit,kbit,,{0} kbit,{0} kbit,kilobitoù,,{0} c'hilobit,{0} kilobit
        kilobyte,ko,,{0}ko,{0}ko,ko,,{0} ko,{0} ko,kilooktedoù,,{0} c'hilookted,{0} kilookted
        megabit,Mbit,,{0}Mbit,{0}Mbit,Mbit,,{0} Mbit,{0} Mbit,megabitoù,,{0} megabit,{0} megabit
        megabyte,Mo,,{0}Mo,{0}Mo,Mo,,{0} Mo,{0} Mo,megaoktedoù,,{0} megaokted,{0} megaokted
        petabyte,Po,,{0}Po,{0}Po,Po,,{0} Po,{0} Po,petaoktedoù,,{0} petaokted,{0} petaokted
        terabit,Tbit,,{0}Tbit,{0}Tbit,Tbit,,{0} Tbit,{0} Tbit,terabitoù,,{0} terabit,{0} terabit
        terabyte,To,,{0}To,{0}To,To,,{0} To,{0} To,teraoktedoù,,{0} teraokted,{0} teraokted
        century,kved,,{0}kved,{0}kved,kved,,{0} kved,{0} kved,kantvedoù,,{0} c'hantved,{0} kantved
        day,d,{0}/d,{0}d,{0}d,d,{0}/d,,{0} d,deizioù,{0} dre zeiz,{0} deiz,{0} deiz
        decade,dek,,{0}dek,{0}dek,dek,,{0} dek,{0} dek,dekvloavezhiadoù,,{0} dekvloavezhiad,{0} dekvloavezhiad
        hour,h,{0}/h,{0}h,{0}h,h,{0}/h,,{0} h,eurioù,{0} dre eur,{0} eur,{0} eur
        microsecond,μs,,{0}μs,{0}μs,,,,,mikroeilennoù,,{0} mikroeilenn,{0} mikroeilenn
        millisecond,ms,,{0}ms,{0}ms,,,,,milieilennoù,,{0} milieilenn,{0} milieilenn
        minute,min,{0}/min,{0}min,{0}min,,,,,munutoù,{0} dre vunut,{0} munut,{0} munut
        month,m,{0}/m,{0}m,{0}m,m.,{0}/m.,{0} m.,{0} m.,mizioù,{0} dre viz,{0} miz,{0} miz
        nanosecond,ns,,{0}ns,{0}ns,,,,,nanoeilennoù,,{0} nanoeilenn,{0} nanoeilenn
        quarter,t,{0}/t,{0}t,{0}t,trim.,{0}/trim.,{0} trim.,{0} trim.,trimiziadoù,{0} dre drimiziad,{0} trimiziad,{0} trimiziad
        second,s,{0}/s,{0}s,{0}s,s,{0}/s,,{0} s,eilennoù,{0} dre eilenn,{0} eilenn,{0} eilenn
        week,sizh.,{0}/sizh.,{0}sizh.,{0}sizh.,sizh.,{0}/sizh.,{0} sizh.,{0} sizh.,sizhunioù,{0} dre sizhun,{0} sizhun,{0} sizhun
        year,b,{0}/b,{0}b,{0}b,bl.,{0}/bl.,{0} bl.,{0} bl.,bloazioù,{0} dre vloaz,{0} bloaz,{0} vloaz
        ampere,A,,{0}A,{0}A,A,,,{0} A,amperoù,,{0} amper,{0} amper
        milliampere,mA,,{0}mA,{0}mA,,,,,miliamperoù,,{0} miliamper,{0} miliamper
        ohm,Ω,,{0}Ω,{0}Ω,Ω,,,{0} Ω,ohmoù,,{0} ohm,{0} ohm
        volt,V,,{0}V,{0}V,V,,,{0} V,voltoù,,{0} volt,{0} volt
        british-thermal-unit,Btu,,{0}Btu,{0}Btu,,,,,British thermal units,,{0} British thermal unit,{0} British thermal unit
        calorie,cal,,{0}cal,{0}cal,,,,,kaloriennoù,,{0} galorienn,{0} kalorienn
        electronvolt,eV,,{0}eV,{0}eV,,,,,elektronvoltoù,,{0} elektronvolt,{0} elektronvolt
        joule,J,,{0}J,{0}J,J,,,{0} J,jouloù,,{0} joul,{0} joul
        kilocalorie,kcal,,{0}kcal,{0}kcal,,,,,kilokaloriennoù,,{0} gilokalorienn,{0} kilokalorienn
        kilojoule,kJ,,{0}kJ,{0}kJ,,,,,kilojouloù,,{0} c'hilojoul,{0} kilojoul
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,,,,,kilowattoù-eurioù,,{0} c'hilowatt-eur,{0} kilowatt-eur
        therm-us,thm,,{0}thm,{0}thm,thm SU,,{0} thm SU,{0} thm SU,termiennoù SU,,{0} dermienn,{0} termienn
        newton,N,,{0}N,{0}N,,,,,newtonoù,,{0} newton,{0} newton
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,gigahertzoù,,{0} gigahertz,{0} gigahertz
        hertz,Hz,,{0}Hz,{0}Hz,,,,,hertzoù,,{0} hertz,{0} hertz
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,kilohertzoù,,{0} c'hilohertz,{0} kilohertz
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,megahertzoù,,{0} megahertz,{0} megahertz
        em,em,,{0}em,{0}em,,,,,esaouenn em,,{0} esaouenn em,{0} esaouenn em
        megapixel,Mpx,,{0}Mpx,{0}Mpx,Mpx,,{0} Mpx,{0} Mpx,megapikselioù,,{0} megapiksel,{0} megapiksel
        pixel,px,,{0}px,{0}px,,,,,pikselioù,,{0} piksel,{0} piksel
        pixel-per-centimeter,px/cm,,{0}px/cm,{0}px/cm,px/cm,,{0} px/cm,{0} px/cm,pikselioù dre santimetr,,{0} piksel dre santimetr,{0} piksel dre santimetr
        pixel-per-inch,px/in,,{0}px/in,{0}px/in,px/in,,{0} px/in,{0} px/in,pikselioù dre veutad,,{0} piksel dre veutad,{0} piksel dre veutad
        astronomical-unit,au,,{0}au,{0}au,,,,,unanennoù steredoniel,,{0} unanenn steredoniel,{0} unanenn steredoniel
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,santimetroù,{0} dre santimetr,{0} santimetr,{0} santimetr
        decimeter,dm,,{0}dm,{0}dm,,,,,desimetroù,,{0} desimetr,{0} desimetr
        earth-radius,R⊕,,{0}R⊕,{0}R⊕,,,,,skin douar,,{0} skin douar,{0} skin douar
        fathom,fth,,{0}fth,{0}fth,fth,,,{0} fth,gourhedadoù,,{0} gourhedad,{0} gourhedad
        foot,′,{0}/′,{0}′,{0}′,,,,,troatadoù,{0} dre droatad,{0} troatad,{0} troatad
        furlong,fur,,{0}fur,{0}fur,,,,,furlongoù,,{0} furlong,{0} furlong
        inch,″,{0}/″,{0}″,{0}″,,,,,meutadoù,{0} dre veutad,{0} meutad,{0} meutad
        kilometer,km,{0}/km,{0}km,{0}km,,,,,kilometroù,{0} dre gilometr,{0} c'hilometr,{0} kilometr
        light-year,b.g.,,{0}b.g.,{0}b.g.,b.g.,,{0} b.g.,{0} b.g.,bloavezhioù-gouloù,,{0} bloavezh-gouloù,{0} bloavezh-gouloù
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,,{0} m,metroù,{0} dre vetr,{0} metr,{0} metr
        micrometer,μm,,{0}μm,{0}μm,,,,,mikrometroù,,{0} mikrometr,{0} mikrometr
        mile,mi,,{0}mi,{0}mi,,,,,miltirioù,,{0} miltir,{0} miltir
        mile-scandinavian,smi,,{0}smi,{0}smi,,,,,miltirioù skandinaviat,,{0} miltir skandinaviat,{0} miltir skandinaviat
        millimeter,mm,,{0}mm,{0}mm,,,,,milimetroù,,{0} milimetr,{0} milimetr
        nanometer,nm,,{0}nm,{0}nm,,,,,nanometroù,,{0} nanometr,{0} nanometr
        nautical-mile,nmi,,{0}nmi,{0}nmi,,,,,milmorioù,,{0} milmor,{0} milmor
        parsec,pc,,{0}pc,{0}pc,,,,,parsekoù,,{0} parsek,{0} parsek
        picometer,pm,,{0}pm,{0}pm,,,,,pikometroù,,{0} pikometr,{0} pikometr
        point,pt,,{0}pt,{0}pt,,,,,poentoù,,{0} poent,{0} poent
        solar-radius,R☉,,{0}R☉,{0}R☉,,,,,skinoù heol,,{0} skin heol,{0} R☉
        yard,yd,,{0}yd,{0}yd,,,,,yardoù,,{0} yard,{0} yard
        candela,cd,,{0}cd,{0}cd,,,,,kandelaoù,,{0} c'handela,{0} kandela
        lumen,lm,,{0}lm,{0}lm,,,,,lumenoù,,{0} lumen,{0} lumen
        lux,lx,,{0}lx,{0}lx,,,,,luksoù,,{0} luks,{0} luks
        carat,CD,,{0}CD,{0}CD,,,,,karatoù,,{0} c'harat,{0} karat
        dalton,Da,,{0}Da,{0}Da,,,,,daltonoù,,{0} dalton,{0} dalton
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,,,,,tolzadoù douar,,{0} tolzad douar,{0} tolzad douar
        grain,gr,,{0}gr,{0}gr,gr,,{0} gr,{0} gr,gr,,{0} greunad,{0} greunad
        gram,g,{0}/g,{0}g,{0}g,g,{0}/g,,{0} g,grammoù,{0} dre cʼhramm,{0} gramm,{0} gramm
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,kilogrammoù,{0} dre gilogramm,{0} c'hilogramm,{0} kilogramm
        microgram,μg,,{0}μg,{0}μg,,,,,mikrogrammoù,,{0} mikrogramm,{0} mikrogramm
        milligram,mg,,{0}mg,{0}mg,,,,,miligrammoù,,{0} miligramm,{0} miligramm
        ounce,oz,{0}/oz,{0}oz,{0}oz,,,,,oñsoù,{0} dre oñs,{0} oñs,{0} oñs
        ounce-troy,ozt,,{0}ozt,{0}ozt,,,,,oñsoù troy,,{0} oñs troy,{0} oñs troy
        pound,lb,{0}/lb,{0}lb,{0}lb,,,,,lurioù,{0} dre lur,{0} lur,{0} lur
        solar-mass,M☉,,{0}M☉,{0}M☉,,,,,tolzadoù heol,,{0} tolzad heol,{0} tolzad heol
        stone,st,,{0}st,{0}st,,,,,stonoù,,{0} ston,{0} ston
        ton,tn,,{0}tn,{0}tn,,,,,tonennoù,,{0} donenn,{0} tonenn
        tonne,t,,{0}t,{0}t,,,,,tonennoù metrek,,{0} donenn vetrek,{0} tonenn vetrek
        gigawatt,GW,,{0}GW,{0}GW,,,,,gigawattoù,,{0} gigawatt,{0} gigawatt
        horsepower,hp,,{0}hp,{0}hp,,,,,marcʼhadoù nerzh,,{0} marc'had nerzh,{0} marc'had nerzh
        kilowatt,kW,,{0}kW,{0}kW,,,,,kilowattoù,,{0} c'hilowatt,{0} kilowatt
        megawatt,MW,,{0}MW,{0}MW,,,,,megawattoù,,{0} megawatt,{0} megawatt
        milliwatt,mW,,{0}mW,{0}mW,,,,,miliwattoù,,{0} miliwatt,{0} miliwatt
        watt,W,,{0}W,{0}W,W,,,{0} W,wattoù,,{0} watt,{0} watt
        atmosphere,atm,,{0}atm,{0}atm,,,,,atmosfer,,{0} atmosfer,{0} atmosfer
        bar,bar,,{0}bar,{0}bar,,,,,baroù,,{0} bar,{0} bar
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,hektopaskaloù,,{0} hektopaskal,{0} hektopaskal
        inch-ofhg,″Hg,,{0}″Hg,{0}″Hg,,,,,meutadoù merkur,,{0} meutad merkur,{0} meutad merkur
        kilopascal,kPa,,{0}kPa,{0}kPa,,,,,kilopaskaloù,,{0} c'hilopaskal,{0} kilopaskal
        megapascal,MPa,,{0}MPa,{0}MPa,,,,,megapaskaloù,,{0} megapaskal,{0} megapaskal
        millibar,mbar,,{0}mbar,{0}mbar,,,,,milibaroù,,{0} milibar,{0} milibar
        millimeter-ofhg,mmHg,,{0}mmHg,{0}mmHg,mmHg,,{0} mmHg,{0} mmHg,milimetradoù merkur,,{0} milimetrad merkur,{0} milimetrad merkur
        pascal,Pa,,{0}Pa,{0}Pa,,,,,paskaloù,,{0} paskal,{0} paskal
        pound-force-per-square-inch,lb/in²,,{0}lb/in²,{0}lb/in²,lb/in²,,{0} lb/in²,{0} lb/in²,lurioù dre veutad karrez,,{0} lur dre veutad karrez,{0} lur dre veutad karrez
        kilometer-per-hour,km/h,,{0}km/h,{0}km/h,,,,,kilometroù dre eur,,{0} c'hilometr dre eur,{0} kilometr dre eur
        knot,nd,,{0}nd,{0}nd,nd,,{0} nd,{0} nd,skoulmoù,,{0} skoulm,{0} skoulm
        meter-per-second,m/s,,{0}m/s,{0}m/s,,,,,metroù dre eilenn,,{0} metr dre eilenn,{0} metr dre eilenn
        mile-per-hour,mi/h,,{0}mi/h,{0}mi/h,,,,,miltirioù dre eur,,{0} miltir dre eur,{0} miltir dre eur
        celsius,,,,,,,,,derezioù Celsius,,{0} derez Celsius,{0} derez Celsius
        fahrenheit,,,,,,,,,derezioù Fahrenheit,,{0} derez Fahrenheit,{0} derez Fahrenheit
        generic,,,,,,,,,derezioù,,{0} derez,{0} derez
        kelvin,K,,{0}K,{0}K,,,,,kelvinoù,,{0} c'helvin,{0} kelvin
        newton-meter,N⋅m,,{0}N⋅m,{0}N⋅m,,,,,newton-metroù,,{0} newton-metr,{0} newton-metr
        acre-foot,acft,,{0}acft,{0}acft,,,,,akroù-troatadoù,,{0} akr-troatad,{0} akr-troatad
        barrel,bbl,,{0}bbl,{0}bbl,,,,,barilhoù,,{0} barilh,{0} barilh
        bushel,bu,,{0}bu,{0}bu,,,,,poezelladoù,,{0} poezellad,{0} poezellad
        centiliter,cl,,{0}cl,{0}cl,cl,,{0} cl,{0} cl,santilitroù,,{0} santilitr,{0} santilitr
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,santimetroù diñs,{0} dre santimetr diñs,{0} santimetr diñs,{0} santimetr diñs
        cubic-foot,ft³,,{0}ft³,{0}ft³,,,,,troatadoù diñs,,{0} troatad diñs,{0} troatad diñs
        cubic-inch,in³,,{0}in³,{0}in³,,,,,meutadoù diñs,,{0} meutad diñs,{0} meutad diñs
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,kilometroù diñs,,{0} c'hilometr diñs,{0} kilometr diñs
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,metroù diñs,{0} dre vetr diñs,{0} metr diñs,{0} metr diñs
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,miltirioù diñs,,{0} miltir diñs,{0} miltir diñs
        cubic-yard,yd³,,{0}yd³,{0}yd³,,,,,yardoù diñs,,{0} yard diñs,{0} yard diñs
        cup,tas.,,{0}tas.,{0}tas.,tas.,,{0} tas.,{0} tas.,tasadoù,,{0} tasad,{0} tasad
        cup-metric,tm,,{0}tm,{0}tm,tm,,{0} tm,{0} tm,tasadoù metrek,,{0} tasad metrek,{0} tasad metrek
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,desilitroù,,{0} desilitr,{0} desilitr
        dessert-spoon,l.d.-b.,,{0}l.d.-b.,{0}l.d.-b.,l.d.-b.,,{0} l.d.-b.,{0} l.d.-b.,loaiad dibenn-pred,,{0} loaiad dibenn-pred,{0} loaiad dibenn-pred
        dessert-spoon-imperial,ldb Imp,,{0}ldb Imp,{0}ldb Imp,l.d.-b. imp.,,{0} l.d.-b. imp.,{0} l.d.-b. imp.,loaiad dibenn-pred impalaerel,,{0} loaiad dibenn-pred impalaerel,{0} loaiad dibenn-pred impalaerel
        dram,fl dr,,{0}fl dr,{0}fl dr,fl dr,,{0} fl dr,{0} fl dr,drakm liñvel,,{0} drakm liñvel,{0} drakm liñvel
        drop,gt,,{0}gt,{0}gt,gt,,{0} gt,{0} gt,takenn,,{0} dakenn,{0} takenn
        fluid-ounce,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,oñsoù liñvel,,{0} oñs liñvel,{0} oñs liñvel
        fluid-ounce-imperial,fl oz Im,,{0}fl oz Im,{0}fl oz Im,fl oz imp.,,{0} fl oz imp.,{0} fl oz imp.,oñsoù liñvel impalaerel,,{0} oñs liñvel impalaerel,{0} oñs liñvel impalaerel
        gallon,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal,{0} gal,{0} gal,gallonoù,{0} dre cʼhallon,{0} gallon,{0} gallon
        gallon-imperial,galIm,{0}/galIm,{0}galIm,{0}galIm,gal imp.,{0}/gal imp.,{0} gal imp.,{0} gal imp.,gallonoù impalaerel,{0} dre cʼhallon impalaerel,{0} gallon impalaerel,{0} gallon impalaerel
        hectoliter,hl,,{0}hl,{0}hl,hl,,{0} hl,{0} hl,hektolitroù,,{0} hektolitr,{0} hektolitr
        jigger,shot,,{0}shot,{0}shot,shot,,{0} shot,{0} shot,shot,,{0} shot,{0} shot
        liter,l,{0}/l,{0}l,{0}l,l,{0}/l,,{0} l,litroù,{0} dre litr,{0} litr,{0} litr
        megaliter,Ml,,{0}Ml,{0}Ml,Ml,,{0} Ml,{0} Ml,megalitroù,,{0} megalitr,{0} megalitr
        milliliter,ml,,{0}ml,{0}ml,ml,,{0} ml,{0} ml,mililitroù,,{0} mililitr,{0} mililitr
        pinch,piñs,,{0}piñs,{0}piñs,piñs,,{0} piñs,{0} piñs,piñsad,,{0} piñsad,{0} piñsad
        pint,pt,,{0}pt,{0}pt,,,,,pintoù,,{0} pint,{0} pint
        pint-metric,mpt,,{0}mpt,{0}mpt,,,,,pintoù metrek,,{0} pint metrek,{0} pint metrek
        quart,qt,,{0}qt,{0}qt,,,,,kardoù,,{0} c'hard,{0} kard
        quart-imperial,qt Imp.,,{0}qt Imp.,{0}qt Imp.,qt Imp.,,,{0} qt Imp.,kardoù impalaerel,,{0} c'hard impalaerel,{0} kard impalaerel
        tablespoon,l.-v.,,{0}l.-v.,{0}l.-v.,l.-v.,,{0} l.-v.,{0} l.-v.,loaiadoù-boued,,{0} loaiad-voued,{0} loaiad-voued
        teaspoon,l.-g.,,{0}l.-g.,{0}l.-g.,l.-g.,,{0} l.-g.,{0} l.-g.,loaiadoù-kafe,,{0} loaiad-gafe,{0} loaiad-gafe
        permillion,ppm,,{0}ppm,{0}ppm,,,,,,,,
        pound-force,lbf,,{0}lbf,{0}lbf,,,,,,,,
        solar-luminosity,L☉,,{0}L☉,{0}L☉,,,,,,,,
        pound-force-foot,lbf⋅ft,,{0}lbf⋅ft,{0}lbf⋅ft,,,,,,,,
        """.trimIndent()
  }

  private val br_Prefixes: String by lazy {
    """square,,,{0} karrez
        cubic,,,{0} diñs
        times,,,{0}-{1}
        per,,,{0} dre {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,eksbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobe{0}
        10p-1,,,desi{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,ato{0}
        10p-2,,,santi{0}
        10p-21,,,zepto{0}
        10p-24,,,yokto{0}
        10p-3,,,mili{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,eksa{0}
        10p2,,,hekto{0}
        10p21,,,zeta{0}
        10p24,,,yota{0}
        10p3,,,kilo{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val brx_Units: String by lazy {
    """day,,,,,,,,,day,{0}/d,{0} सान,{0} सान
        hour,,,,,,,,,hr,{0}/h,{0} रिंगा,{0} घंटे
        minute,,,,,,,,,min,{0}/min,{0} मिन.,{0} मिन.
        month,,,,,,,,,mon,{0}/m,{0} महीना,{0} महीने
        second,,,,,,,,,sec,{0}/s,{0} सेकं.,{0} सेकं.
        week,,,,,,,,,wk,{0}/w,{0} सप्ताह,{0} सप्ताह
        year,,,,,,,,,yr,{0}/y,{0} साल,{0} साल
        """.trimIndent()
  }

  private val brx_Prefixes: String? = null

  private val bs_Units: String by lazy {
    """g-force,G,,,{0} G,G,,,{0} G,G,,,{0} G
        meter-per-square-second,,,,,,,,,metri u sekundi na kvadrat,,{0} metar u sekundi na kvadrat,{0} metara u sekundi na kvadrat
        arc-minute,ugaone minute,,,{0}′,ugaone minute,,,{0}′,ugaone minute,,{0} ugaona minuta,{0} ugaonih minuta
        arc-second,ugaone sekunde,,,{0}″,ugaone sekunde,,,{0}″,ugaone sekunde,,{0} ugaona sekunda,{0} ugaonih sekundi
        degree,stepeni,,,{0}°,stepeni,,,{0}°,stepeni,,{0} stepen,{0} stepeni
        radian,radijani,,,{0} rad,radijani,,,{0} rad,radijani,,{0} radijan,{0} radijana
        revolution,okret,,{0} okr.,{0} okr.,okret,,{0} okr.,{0} okr.,okret,,{0} okret,{0} okreta
        acre,aker,,{0} ac,{0} ac,katastarska jutra,,{0} ac,{0} ac,akeri,,{0} katastarsko jutro,{0} katastarskih jutara
        dunam,dunumi,,{0} dunum,{0} dunuma,dunumi,,{0} dunum,{0} dunuma,dunumi,,{0} dunum,{0} dunuma
        hectare,hektari,,,{0} ha,hektari,,,{0} ha,hektari,,{0} hektar,{0} hektara
        square-centimeter,,,,,,,,,kvadratni centimetri,{0} po kvadratnom centimetru,{0} kvadratni centimetar,{0} kvadratnih centimetara
        square-foot,,,,,,,,,kvadratne stope,,{0} kvadratna stopa,{0} kvadratnih stopa
        square-inch,,,,,,,,,kvadratni inči,{0} po kvadratnom inču,{0} kvadratni inč,{0} kvadratnih inča
        square-kilometer,,,,,,,,,kvadratni kilometri,{0} po kvadratnom kilometru,{0} kvadratni kilometar,{0} kvadratnih kilometara
        square-meter,,,,,,,,,kvadratni metri,{0} po kvadratnom metru,{0} kvadratni metar,{0} kvadratnih metara
        square-mile,,,,,,,,,kvadratne milje,{0} po kvadratnoj milji,{0} kvadratna milja,{0} kvadratnih milja
        square-yard,,,,,,,,,kvadratni jardi,,{0} kvadratni jard,{0} kvadratnih jarda
        item,stavka,,{0} stavka,{0} stavki,stavka,,{0} stavka,{0} stavki,stavka,,{0} stavka,{0} stavki
        karat,karati,,,{0} kt,karati,,,{0} kt,karati,,{0} karat,{0} karata
        milligram-ofglucose-per-deciliter,,,,,,,,,miligrami po decilitru,,{0} miligram po decilitru,{0} miligrama po decilitru
        millimole-per-liter,milimol/litar,,,{0} mmol/L,milimol/litar,,,{0} mmol/L,milimoli po litru,,{0} milimol po litru,{0} milimola po litru
        mole,,,,,,,,,moli,,{0} mol,{0} mola
        percent,,,,,,,,,procenat,,{0} procenat,{0} procenata
        permille,,,,,,,,,promil,,{0} promil,{0} promila
        permillion,,,,,dijelovi/milion,,,{0} ppm,dijelovi na milion,,{0} dio na milion,{0} dijelova na milion
        permyriad,,,,,,,,,permyriad,,{0} permyriad,{0} permyriada
        liter-per-100-kilometer,L/100 km,,{0} L/100 km,{0} L/100 km,L/100 km,,{0} L/100 km,{0} L/100 km,litri na 100 kilometara,,{0} litar na 100 kilometara,{0} litara na 100 kilometara
        liter-per-kilometer,,,,,,,,,litri po kilometru,,{0} litar po kilometru,{0} litara po kilometru
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg,milje po galonu,,{0} milja po galonu,{0} milja po galonu
        mile-per-gallon-imperial,milje/b. gal,,{0} mi/b. gal,{0} mi/b. gal,milje/b. gal,,{0} mi/b. gal,{0} mi/b. gal,milje po brit. galonu,,{0} milja po brit. galonu,{0} milja po brit. galonu
        bit,bit,,{0} bit,{0} bita,,,,,biti,,{0} bit,{0} bita
        byte,bajt,,{0} B,{0} B,bajt,,{0} bajt,{0} bajt,bajtovi,,{0} bajt,{0} bajtova
        gigabit,,,,,,,,,gigabiti,,{0} gigabit,{0} gigabita
        gigabyte,,,,,,,,,gigabajti,,{0} gigabajt,{0} gigabajta
        kilobit,,,,,,,,,kilobiti,,{0} kilobit,{0} kilobita
        kilobyte,,,,,,,,,kilobajti,,{0} kilobajt,{0} kilobajta
        megabit,,,,,,,,,megabiti,,{0} megabit,{0} megabita
        megabyte,,,,,,,,,megabajti,,{0} megabajt,{0} megabajta
        petabyte,,,,,,,,,petabajti,,{0} petabajt,{0} petabajta
        terabit,,,,,,,,,terabiti,,{0} terabit,{0} terabita
        terabyte,,,,,,,,,terabajti,,{0} terabajt,{0} terabajta
        century,st.,,{0} st.,{0} st.,st.,,{0} st.,{0} st.,stoljeća,,{0} stoljeće,{0} stoljeća
        day,dan,{0}/d.,{0} d.,{0} d.,dani,{0}/d.,{0} dan,{0} dana,dani,{0} dnevno,{0} dan,{0} dana
        decade,dec.,,{0} dec.,{0} dec.,dec.,,{0} dec.,{0} dec.,decenije,,{0} decenija,{0} decenija
        hour,sat,{0}/h,,{0} h,sati,{0}/h,,{0} h,sati,{0} na sat,{0} sat,{0} sati
        microsecond,mikrosekunda,,,{0} μs,mikrosekunde,,,{0} μs,mikrosekunde,,{0} mikrosekunda,{0} mikrosekundi
        millisecond,milisekunda,,,{0} ms,milisekunde,,,{0} ms,milisekunde,,{0} milisekunda,{0} milisekundi
        minute,minuta,{0}/min,{0} m,{0} m,minute,{0}/min.,{0} min.,{0} min.,minute,{0} po minuti,{0} minuta,{0} minuta
        month,mjesec,{0} mj.,{0} mj.,{0} mj.,mjeseci,{0} mj.,{0} mj.,{0} mj.,mjeseci,{0} mjesečno,{0} mjesec,{0} mjeseci
        nanosecond,,,,,nanosekunde,,,{0} ns,nanosekunde,,{0} nanosekunda,{0} nanosekundi
        night,noći,{0}/noć,{0} noć,{0} noći,noći,{0}/noć,{0} noć,{0} noći,noći,{0} po noći,{0} noć,{0} noći
        quarter,čet.,{0}/čet.,{0} čet.,{0} čet.,čet.,{0}/čet.,{0} čet.,{0} čet.,četvrtine,{0}/čet.,{0} četvrtina,{0} četvrtina
        second,sekunda,{0}/s,{0} s,{0} s,sekunde,{0}/s,{0} sek.,{0} sek.,sekunde,{0} po sekundi,{0} sekunda,{0} sekundi
        week,sedm.,{0}/sedm.,{0} sedm.,{0} sedm.,sedmice,{0}/sedm.,{0} sedm.,{0} sedm.,sedmice,{0} sedmično,{0} sedmica,{0} sedmica
        year,god.,{0}/god.,{0} god.,{0} god.,godine,{0}/god.,{0} god.,{0} god.,godine,{0} godišnje,{0} godina,{0} godina
        ampere,amperi,,,{0} A,amperi,,,{0} A,amperi,,{0} amper,{0} ampera
        milliampere,,,,,,,,,miliamperi,,{0} miliamper,{0} miliampera
        ohm,omi,,,{0} Ω,omi,,,{0} Ω,omi,,{0} om,{0} oma
        volt,volti,,,{0} V,volti,,,{0} V,volti,,{0} volt,{0} volti
        british-thermal-unit,BTU,,{0} BTU,{0} BTU,BTU,,{0} BTU,{0} BTU,britanske termalne jedinice,,{0} britanska termalna jedinica,{0} britanskih termalnih jedinica
        calorie,cal,,{0} kal.,{0} cal,kal.,,{0} kal.,{0} kal.,kalorije,,{0} kalorija,{0} kalorija
        electronvolt,,,,,,,,,elektron volti,,{0} elektron volt,{0} elektron volti
        foodcalorie,,,,,,,,,kalorije,,{0} kalorija,{0} kalorija
        joule,džuli,,,{0} J,džuli,,,{0} J,džuli,,{0} džul,{0} džula
        kilocalorie,,,,,,,,,kilokalorije,,{0} kilokalorija,{0} kilokalorija
        kilojoule,,,,,kilodžul,,,{0} kJ,kilodžuli,,{0} kilodžul,{0} kilodžula
        kilowatt-hour,kW-sat,,,{0} kWh,kW-sat,,,{0} kWh,kilovat-sat,,{0} kilovat-sat,{0} kilovat-sati
        kilowatt-hour-per-100-kilometer,kWh/100 km,,{0}kWh/100 km,{0}kWh/100 km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km
        newton,,,,,,,,,njutni,,{0} njutn,{0} njutna
        pound-force,,,,,,,,,funte sile,,{0} funta sile,{0} funti sile
        gigahertz,,,,,,,,,gigaherci,,{0} gigaherc,{0} gigaherca
        hertz,,,,,,,,,herci,,{0} herc,{0} herca
        kilohertz,,,,,,,,,kiloherci,,{0} kiloherc,{0} kiloherca
        megahertz,,,,,,,,,megaherci,,{0} megaherc,{0} megaherca
        dot,tačka,,{0} tačka,{0} tačaka,tačke,,{0} tačka,{0} tačaka,tačke,,{0} tačka,{0} tačaka
        dot-per-centimeter,dpcm,,{0}dpcm,{0} dpcm,dpcm,,{0} dpcm,{0} dpcm,tačaka po centimetru,,{0} tačka po centimetru,{0} tačaka po centimetru
        dot-per-inch,dpi,,{0}dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,tačaka po inču,,{0} tačka po inču,{0} tačaka po inču
        megapixel,,,,,,,,,megapikseli,,,{0} MP
        pixel,,,,,,,,,pikseli,,{0} piksel,{0} px
        pixel-per-centimeter,ppcm,,{0}ppcm,{0}ppcm,,,,,pikseli po centimetru,,{0} piksel po centimetru,{0} piksela po centimetru
        pixel-per-inch,ppi,,{0}ppi,{0}ppi,,,,,pikseli po inču,,{0} piksel po inču,{0} piksela po inču
        astronomical-unit,aj,,{0} aj,{0} aj,aj,,{0} aj,{0} aj,astronomske jedinice,,{0} astronomska jedinica,{0} astronomskih jedinica
        centimeter,,,,,,,,,centimetri,{0} po centimetru,{0} centimetar,{0} centimetara
        decimeter,,,,,,,,,decimetri,,{0} decimetar,{0} decimetara
        earth-radius,,,,,,,,,radijus Zemlje,,{0} radijus Zemlje,{0} radijusa Zemlje
        fathom,hvat,,{0} hvat,{0} hvata,hvat,,{0} hvat,{0} hvata,hvat,,{0} hvat,{0} hvata
        foot,,,,,stope,{0}/ft,,{0} ft,stope,{0} po stopi,{0} stopa,{0} stopa
        furlong,osmina milje,,{0} osmina milje,{0} osmina milje,osmina milje,,{0} osmina milje,{0} osmina milje,osmina milje,,{0} osmina milje,{0} osmina milje
        inch,,,,,inči,{0}/in,,{0} in,inči,{0} po inču,{0} inč,{0} inča
        kilometer,,,,,,,,,kilometri,{0} po kilometru,{0} kilometar,{0} kilometara
        light-year,sg,,{0} sg,{0} sg,svjetlosne godine,,{0} sg,{0} sg,svjetlosne godine,,{0} svjetlosna godina,{0} svjetlosnih godina
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,m,{0} po metru,{0} metar,{0} metara
        micrometer,,,,,,,,,mikrometri,,{0} mikrometar,{0} mikrometara
        mile,,,,,milje,,,{0} mi,milje,,{0} milja,{0} milja
        mile-scandinavian,,,,,,,,,skandinavske milje,,{0} skandinavska milja,{0} skandinavskih milja
        millimeter,,,,,,,,,milimetri,,{0} milimetar,{0} milimetara
        nanometer,,,,,,,,,nanometri,,{0} nanometar,{0} nanometara
        nautical-mile,,,,,,,,,nautičke milje,,{0} nautička milja,{0} nautičkih milja
        parsec,parseci,,,{0} pc,parseci,,,{0} pc,parseci,,{0} parsek,{0} parseka
        picometer,,,,,,,,,pikometri,,{0} pikometar,{0} pikometara
        point,DTP tč,,{0} DTP tč,{0} DTP tč,DTP tč,,{0} DTP tč,{0} DTP tč,DTP tačke,,{0} DTP tačka,{0} DTP tačaka
        solar-radius,,,,,,,,,Sunčevi radijusi,,{0} Sunčev radijus,{0} Sunčevih radijusa
        yard,,,,,jardi,,,{0} yd,jardi,,{0} jard,{0} jardi
        candela,,,,,,,,,kandela,,{0} kandela,{0} kandela
        lumen,,,,,,,,,lumen,,{0} lumen,{0} lumena
        lux,luks,,,{0} lx,luks,,,{0} lx,luksi,,{0} luks,{0} luksa
        solar-luminosity,,,,,,,,,Sunčeva zračenja,,{0} Sunčevo zračenje,{0} Sunčevih zračenja
        carat,karat,,{0} ct,{0} ct,karati,,{0} ct,{0} CD,karati,,{0} karat,{0} karata
        dalton,,,,,,,,,daltoni,,{0} dalton,{0} daltona
        earth-mass,,,,,,,,,Zemljine mase,,{0} Zemljina masa,{0} Zemljinih masa
        gram,,,,,grami,{0}/g,,{0} g,grami,{0} po gramu,{0} gram,{0} grama
        kilogram,,,,,,,,,kilogrami,{0} po kilogramu,{0} kilogram,{0} kilograma
        microgram,,,,,,,,,mikrogrami,,{0} mikrogram,{0} mikrograma
        milligram,,,,,,,,,miligrami,,{0} miligram,{0} miligrama
        ounce,,,,,,,,,unce,{0} po unci,{0} unca,{0} unci
        ounce-troy,,,,,,,,,fine unce,,{0} fina unca,{0} finih unci
        pound,lb,{0}/lb,{0} lb,{0} lb,lb,{0}/lb,{0} lb,{0} lbs,funte,{0} po funti,{0} funta,{0} funti
        solar-mass,,,,,,,,,Sunčeve mase,,{0} Sunčeva masa,{0} Sunčevih masa
        stone,,,,,,,,,stone,,{0} stone,{0} stone
        ton,tone,,,{0} tn,tone,,,{0} tn,tone,,{0} tona,{0} tona
        tonne,,,,,,,,,metričke tone,,{0} metrička tona,{0} metričkih tona
        gigawatt,,,,,,,,,gigavati,,{0} gigavat,{0} gigavata
        horsepower,ks,,{0} ks,{0} ks,ks,,{0} ks,{0} ks,konjske snage,,{0} konjska snaga,{0} konjskih snaga
        kilowatt,,,,,,,,,kilovati,,{0} kilovat,{0} kilovata
        megawatt,,,,,,,,,megavati,,{0} megavat,{0} megavata
        milliwatt,,,,,,,,,milivati,,{0} milivat,{0} milivata
        watt,vati,,,{0} W,vati,,,{0} W,vati,,{0} vat,{0} vati
        atmosphere,,,,,,,,,atmosfere,,{0} atmosfera,{0} atmosfera
        bar,,,,,,,,,bar,,{0} bar,{0} bara
        hectopascal,,,,,,,,,hektopaskali,,{0} hektopaskal,{0} hektopaskala
        inch-ofhg,,,,,,,,,inči živinog stuba,,{0} inč živinog stuba,{0} inča živinog stuba
        kilopascal,,,,,,,,,kilopaskali,,{0} kilopaskal,{0} kilopaskala
        megapascal,,,,,,,,,megapaskali,,{0} megapaskal,{0} megapaskala
        millibar,mbar,,{0} mb,{0} mb,,,,,milibari,,{0} milibar,{0} milibara
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,mmHg,,{0} mmHg,{0} mmHg,milimetri živinog stuba,,{0} milimetar živinog stuba,{0} milimetara živinog stuba
        pascal,,,,,,,,,paskali,,{0} paskal,{0} paskala
        pound-force-per-square-inch,,,,,,,,,funte po kvadratnom inču,,{0} funta po kvadratnom inču,{0} funti po kvadratnom inču
        beaufort,,,,,,,,,Beafort,,Beafort {0},Beafort {0}
        kilometer-per-hour,,,,,,,,,kilometri na sat,,{0} kilometar na sat,{0} kilometara na sat
        knot,čv,,{0} čv,{0} čv,čv,,{0} čv,{0} čv,čvorovi,,{0} čvor,{0} čvorova
        meter-per-second,,,,,,,,,metri u sekundi,,{0} metar u sekundi,{0} metara u sekundi
        mile-per-hour,,,,,,,,,milje na sat,,{0} milja na sat,{0} milja na sat
        celsius,°C,,{0}°,{0}°,°C,,{0} °C,{0} °C,stepeni Celzijusa,,{0} stepen Celzijusa,{0} stepeni Celzijusa
        fahrenheit,°F,,{0}°F,{0}°F,°F,,{0} °F,{0} °F,stepeni Farenhajta,,{0} stepen Farenhajta,{0} stepeni Farenhajta
        kelvin,,,,,,,,,kelvini,,{0} kelvin,{0} kelvina
        newton-meter,Nm,,{0} Nm,{0} Nm,Nm,,{0} Nm,{0} Nm,njutn-metri,,{0} njutn-metar,{0} njutn-metara
        pound-force-foot,,,,,,,,,funte sile po stopi,,{0} funta sile po stopi,{0} funti sile po stopi
        acre-foot,,,,,,,,,jutar-stope,,{0} jutar-stopa,{0} jutar-stopa
        barrel,,,,,,,,,bareli,,{0} barel,{0} barela
        bushel,,,,,,,,,bušeli,,{0} bušel,{0} bušela
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,centilitri,,{0} centilitar,{0} centilitara
        cubic-centimeter,,,,,,,,,kubni centimetri,{0} po kubnom centimetru,{0} kubni centimetar,{0} kubnih centimetara
        cubic-foot,,,,,,,,,kubne stope,,{0} kubna stopa,{0} kubnih stopa
        cubic-inch,,,,,,,,,kubni inči,,{0} kubni inč,{0} kubnih inča
        cubic-kilometer,,,,,,,,,kubni kilometri,,{0} kubni kilometar,{0} kubnih kilometara
        cubic-meter,,,,,,,,,kubni metri,{0} po kubnom metru,{0} kubni metar,{0} kubnih metara
        cubic-mile,,,,,,,,,kubne milje,,{0} kubna milja,{0} kubnih milja
        cubic-yard,,,,,,,,,kubni jardi,,{0} kubni jard,{0} kubnih jarda
        cup,šolje,,,{0} c,šolje,,,{0} c,šolje,,{0} šolja,{0} šolja
        cup-metric,,,,,,,,,metričke šolje,,{0} metrička šolja,{0} metričkih šolja
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,decilitri,,{0} decilitar,{0} decilitara
        dessert-spoon,kš. des.,,{0} kš. des.,{0} kš. des.,kš. des.,,{0} kš. des.,{0} kš. des.,kašika za desert,,{0} kašika za desert,{0} kašika za desert
        dessert-spoon-imperial,imp. kš. des.,,{0} imp. kš. des.,{0} imp. kš. des.,imp. kš. des.,,{0} imp. kš. des.,{0} imp. kš. des.,imperijalna kašika za desert,,{0} imperijalna kašika za desert,{0} imperijalnih kašika za desert
        dram,teč. dram,,{0} teč. dram,{0} teč. drama,teč. dram,,{0} teč. dram,{0} teč. drama,tečni dram,,{0} tečni dram,{0} tečnih drama
        drop,kap,,{0} kap,{0} kapi,kap,,{0} kap,{0} kapi,kap,,{0} kap,{0} kapi
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,tečne unce,,{0} tečna unca,{0} tečnih unci
        fluid-ounce-imperial,imp. fl oz,,{0} imp. fl oz,{0} imp. fl oz,imp. fl oz,,{0} imp. fl oz,{0} imp. fl oz,imp. tekuće unce,,{0} imp. tekuća unca,{0} imp. tekućih unci
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,galoni,{0} po galonu,{0} galon,{0} galona
        gallon-imperial,B. gal,{0}/b. gal,{0} b. gal,{0} b. gal,B. gal,{0}/b. gal,{0} b. gal,{0} b. gal,Brit. galoni,{0} po brit. galonu,{0} brit. galon,{0} brit. galona
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hektolitri,,{0} hektolitar,{0} hektolitara
        jigger,mala čašica,,{0} mala čašica,{0} malih čašica,mala čašica,,{0} mala čašica,{0} malih čašica,mala čašica,,{0} mala čašica,{0} malih čašica
        liter,litar,{0}/l,{0}l,{0}l,litri,{0}/l,,{0} l,litri,{0} po litru,{0} litar,{0} litara
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megalitri,,{0} megalitar,{0} megalitara
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,mililitri,,{0} mililitar,{0} mililitara
        pinch,prstohvat,,{0} prstohvat,{0} prstohvata,prstohvat,,{0} prstohvat,{0} prstohvata,prstohvat,,{0} prstohvat,{0} prstohvata
        pint,pinte,,,{0} pt,pinte,,,{0} pt,pinte,,{0} pinta,{0} pinti
        pint-metric,,,,,,,,,metričke pinte,,{0} metrička pinta,{0} metričkih pinti
        quart,,,,,,,,,četvrtine,,{0} četvrtina,{0} četvrtina
        quart-imperial,imp. kvart,,{0} imp. kvart,{0} imp. kvarata,imp. kvarc,,{0} imp. kvart,{0} imp. kvarata,imperijalni kvarc,,{0} imperijalni kvarc,{0} imperijalnih kvarca
        tablespoon,kšk.,,{0} kšk.,{0} kšk.,kašike,,{0} kšk.,{0} kšk.,kašike,,{0} kašika,{0} kašika
        teaspoon,kšč.,,{0} kšč.,{0} kšč.,kšč.,,{0} kšč.,{0} kšč.,kašičice,,{0} kašičica,{0} kašičica
        grain,gr,,{0} gr,{0} gr,,,,,,,,
        """.trimIndent()
  }

  private val bs_Prefixes: String by lazy {
    """square,,,kvadratnih {0}
        cubic,,,kubnih {0}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobe{0}
        10p-27,,,ronto{0}
        10p-30,,,kuekto{0}
        10p27,,,ronna{0}
        10p30,,,quetta{0}
        """.trimIndent()
  }

  private val bs_Cyrl_Units: String by lazy {
    """acre,акре,,,{0} ac,акре,,,{0} ac,акре,,{0} акра,{0} акри
        hectare,хектари,,,{0} ha,хектари,,,{0} ha,хектари,,{0} хектар,{0} хектара
        square-centimeter,,,,,,,,,квадратни центиметри,{0} по квадратном центиметру,{0} квадратни центиметар,{0} квадратних центиметара
        square-foot,,,,,,,,,квадратне стопе,,,{0} ft²
        square-inch,,,,,,,,,квадратни инчи,{0}/in²,,{0} in²
        square-kilometer,,,,,,,,,квадратни километри,{0} по квадратном километру,{0} квадратни километар,{0} квадратних километара
        square-meter,,,,,,,,,квадратни метри,{0} по квадратном метру,{0} квадратни метар,{0} квадратних метара
        square-mile,,,,,,,,,квадратне миље,{0} по квадратној миљи,{0} квадратна миља,{0} квадратних миља
        square-yard,,,,,,,,,квадратни јарди,,{0} квадратни јард,{0} квадратних јарди
        century,в.,,{0} в.,{0} в.,в.,,{0} в.,{0} в.,вијекови,,{0} вијек,{0} вијекова
        day,дани,{0} днев.,{0} дан,{0} дан,дани,{0} днев.,{0} дан,{0} дан,дани,{0} дневно,{0} дан,{0} дана
        decade,дец,,{0} дец.,{0} дец.,дец,,{0} дец.,{0} дец.,деценије,,{0} деценија,{0} деценија
        hour,сати,{0} по сату,{0} сат,{0} сати,сати,{0} по сату,{0} сат,{0} сати,сати,{0} по сату,{0} сат,{0} сати
        microsecond,,,,,,,,,микросекунде,,{0} микросекунда,{0} микросекунди
        millisecond,мс,,{0} мс,{0} мс,мс,,{0} мс,{0} мс,милисекунде,,{0} милисекунда,{0} милисекунди
        minute,минут,{0} у мин.,{0} мин.,{0} мин.,минут,{0} у мин.,{0} мин.,{0} мин.,минути,{0} у минуту,{0} минут,{0} минута
        month,мјесец,{0} мјесеч.,{0} мјес.,{0} мјес.,мјесеци,{0} мјесеч.,{0} мјес.,{0} мјес.,мјесец,{0} мјесечно,{0} мјесец,{0} мјесеци
        nanosecond,,,,,,,,,наносекунде,,{0} наносекунда,{0} наносекунди
        second,секунде,{0} у сек.,{0} сек.,{0} сек.,секунде,{0} у сек.,{0} сек.,{0} сек.,секунде,{0} у секунди,{0} секунда,{0} секунди
        week,седмица,{0} седм.,{0} сед.,{0} сед.,седмице,{0} седм.,{0} сед.,{0} сед.,седмице,{0} седмично,{0} седмица,{0} седмица
        year,година,{0} годиш.,{0} год,{0} год,година,{0} годиш.,{0} год,{0} год,година,{0} годишње,{0} година,{0} година
        dot-per-centimeter,,,,,,,,,тачке по центиметру,,,
        dot-per-inch,,,,,,,,,тачке по инчу,,,
        megapixel,,,,,,,,,мегапиксели,,,{0} MP
        pixel,,,,,,,,,пиксели,,,{0} px
        astronomical-unit,,,,,,,,,астрономске јединице,,{0} астрономска јединица,{0} астрономских јединица
        centimeter,,,,,,,,,центриметри,{0} по центиметру,{0} центиметар,{0} центиметара
        decimeter,,,,,,,,,дециметри,,{0} дециметар,{0} дециметара
        kilometer,,,,,,,,,километри,{0} по километру,{0} километар,{0} километара
        light-year,,,,,,,,,свјетлосне године,,{0} свјетлосна година,{0} свјетлосних година
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,метри,{0} по метру,{0} метар,{0} метара
        micrometer,,,,,,,,,микрометри,,{0} микрометар,{0} микрометара
        mile,,,,,,,,,миље,,{0} миља,{0} миља
        millimeter,,,,,,,,,милиметри,,{0} милиметар,{0} милиметара
        nanometer,,,,,,,,,нанометри,,{0} нанометар,{0} нанометара
        nautical-mile,,,,,,,,,наутичке миље,,{0} наутичка миља,{0} наутичких миља
        point,,,,,,,,,тачке,,{0} тачка,{0} тачака
        yard,,,,,,,,,јарди,,{0} јард,{0} јарди
        cubic-centimeter,,,,,,,,,кубни центиметри,{0}/cm³,,{0} cm³
        cubic-meter,,,,,,,,,кубни метри,{0}/m³,,{0} m³
        liter,,,,,,,,,литри,{0}/l,,{0} l
        """.trimIndent()
  }

  private val bs_Cyrl_Prefixes: String? = null

  private val bs_Latn_Units: String? = null

  private val bs_Latn_Prefixes: String? = null

  private val bss_Units: String? = null

  private val bss_Prefixes: String? = null

  private val byn_Units: String? = null

  private val byn_Prefixes: String? = null

  private val ca_Units: String by lazy {
    """g-force,G,,,{0} G,G,,,{0} G,força G,,{0} força G,{0} força G
        meter-per-square-second,,,,,,,,,metres per segon al quadrat,,{0} metre per segon al quadrat,{0} metres per segon al quadrat
        arc-minute,arcmin,,{0}′,{0}′,arcmin,,{0} arcmin,{0} arcmin,minuts d’arc,,{0} minut d’arc,{0} minuts d’arc
        arc-second,arcsec,,{0}″,{0}″,arcsec,,{0} arcsec,{0} arcsec,segons d’arc,,{0} segon d’arc,{0} segons d’arc
        degree,°,,,{0}°,graus,,,{0}°,graus,,{0} grau,{0} graus
        radian,,,,,radiants,,,{0} rad,radiants,,{0} radiant,{0} radiants
        revolution,r,,{0} r,{0} r,r,,{0} r,{0} r,revolució,,{0} revolució,{0} revolucions
        acre,,,,,acres,,,{0} ac,acres,,{0} acre,{0} acres
        dunam,dunam,,{0} dunam,{0} dunams,dunams,,{0} dunam,{0} dunams,dunams,,{0} dunam,{0} dunams
        hectare,hectàrea,,,{0} ha,hectàrees,,,{0} ha,hectàrees,,{0} hectàrea,{0} hectàrees
        square-centimeter,,,,,,,,,centímetres quadrats,{0} per centímetre quadrat,{0} centímetre quadrat,{0} centímetres quadrats
        square-foot,,,,,,,,,peus quadrats,,{0} peu quadrat,{0} peus quadrats
        square-inch,,,,,,,,,polzades quadrades,{0} per polzada quadrada,{0} polzada quadrada,{0} polzades quadrades
        square-kilometer,,,,,,,,,quilòmetres quadrats,{0} per quilòmetre quadrat,{0} quilòmetre quadrat,{0} quilòmetres quadrats
        square-meter,metres²,{0}/m²,,{0} m²,,,,,metres quadrats,{0} per metre quadrat,{0} metre quadrat,{0} metres quadrats
        square-mile,,,,,,,,,milles quadrades,{0} per milla quadrada,{0} milla quadrada,{0} milles quadrades
        square-yard,,,,,,,,,iardes quadrades,,{0} iarda quadrada,{0} iardes quadrades
        item,ítem,,{0} ítem,{0} ítems,ítem,,{0} ítem,{0} ítems,ítem,,{0} ítem,{0} ítems
        karat,quirat,,{0} ct,{0} ct,quirats,,{0} ct,{0} ct,quirats,,{0} quirat,{0} quirats
        milligram-ofglucose-per-deciliter,,,,,,,,,mil ligrams per decilitre,,{0} mil ligram per decilitre,{0} mil ligrams per decilitre
        millimole-per-liter,mM/l,,{0} mM/l,{0} mM/l,mil limols/litre,,{0} mM/l,{0} mM/l,mil limols per litre,,{0} mil limol per litre,{0} mil limols per litre
        mole,,,,,,,,,mols,,{0} mol,{0} mols
        percent,%,,{0} %,{0} %,per cent,,{0} %,{0} %,per cent,,{0} per cent,{0} per cent
        permille,‰,,{0} ‰,{0} ‰,per mil,,{0} ‰,{0} ‰,per mil,,{0} per mil,{0} per mil
        permillion,,,,,parts/milió,,,{0} ppm,parts per milió,,{0} part per milió,{0} parts per milió
        permyriad,‱,,{0} ‱,{0} ‱,per deu mil,,{0} ‱,{0} ‱,per deu mil,,{0} per deu mil,{0} per deu mil
        portion-per-1e9,part/mil milions,,,{0} ppb,part/mil milions,,,{0} ppb,part per mil milions,,{0} part per mil milions,{0} parts per mil milions
        liter-per-100-kilometer,l/100 km,,{0} l/100 km,{0} l/100 km,l/100 km,,{0} l/100 km,{0} l/100 km,litres per 100 quilòmetres,,{0} litre per 100 quilòmetres,{0} litres per 100 quilòmetres
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,litres per quilòmetre,,{0} litre per quilòmetre,{0} litres per quilòmetre
        mile-per-gallon,mi/gal,,{0} mi/gal,{0} mi/gal,mi/gal,,{0} mi/gal,{0} mi/gal,milles per galó,,{0} milla per galó,{0} milles per galó
        mile-per-gallon-imperial,mi/gal imp.,,{0} mi/gal imp.,{0} mi/gal imp.,mi/gal imp.,,{0} mi/gal imp.,{0} mi/gal imp.,milles per galó imperial,,{0} milla per galó imperial,{0} milles per galó imperial
        bit,bit,,{0} bit,{0} bits,bit,,{0} bit,{0} bits,bits,,{0} bit,{0} bits
        byte,B,,{0} B,{0} B,B,,{0} B,{0} B,bytes,,{0} byte,{0} bytes
        gigabit,,,,,,,,,gigabits,,{0} gigabit,{0} gigabits
        gigabyte,,,,,,,,,gigabytes,,{0} gigabyte,{0} gigabytes
        kilobit,,,,,,,,,kilobits,,{0} kilobit,{0} kilobits
        kilobyte,,,,,,,,,kilobytes,,{0} kilobyte,{0} kilobytes
        megabit,Mbit,,{0} Mbit,{0} Mbit,Mbit,,{0} Mbit,{0} Mbit,megabits,,{0} megabit,{0} megabits
        megabyte,,,,,,,,,megabytes,,{0} megabyte,{0} megabytes
        petabyte,,,,,,,,,petabytes,,{0} petabyte,{0} petabytes
        terabit,,,,,,,,,terabits,,{0} terabit,{0} terabits
        terabyte,,,,,,,,,terabytes,,{0} terabyte,{0} terabytes
        century,s.,,{0} s.,{0} s.,segles,,{0} segle,{0} segles,segles,,{0} segle,{0} segles
        day,dia,{0}/d,{0} d,{0} d,dies,{0}/d,{0} dia,{0} dies,dies,{0} per dia,{0} dia,{0} dies
        decade,dèc.,,{0} dèc.,{0} dèc.,dèc.,,{0} dèc.,{0} dèc.,dècades,,{0} dècada,{0} dècades
        hour,h,{0}/h,,{0} h,hores,{0}/h,,{0} h,hores,{0} per hora,{0} hora,{0} hores
        microsecond,,,,,,,,,microsegons,,{0} microsegon,{0} microsegons
        millisecond,,,,,mil lisegons,,,{0} ms,mil lisegons,,{0} mil lisegon,{0} mil lisegons
        minute,,,,,,,,,minuts,{0} per minut,{0} minut,{0} minuts
        month,mes,{0}/m,{0} m,{0} m,mesos,{0}/m,{0} mes,{0} m,mesos,{0} per mes,{0} mes,{0} mesos
        nanosecond,,,,,,,,,nanosegons,,{0} nanosegon,{0} nanosegons
        night,nit,{0}/nit,{0}/nit,{0}/nit,nits,{0}/nit,{0} nit,{0} nits,nits,{0} per nit,{0} nit,{0} nits
        quarter,trim.,{0}/trim.,{0} trim.,{0} trim.,trim.,{0}/trim.,{0} trim.,{0} trim.,trimestres,{0} per trimestre,{0} trimestre,{0} trimestres
        second,s,{0}/s,,{0} s,s,{0}/s,,{0} s,segons,{0} per segon,{0} segon,{0} segons
        week,setm.,{0}/setm.,{0} setm.,{0} setm.,setm.,{0}/setm.,{0} setm.,{0} setm.,setmanes,{0} per setmana,{0} setmana,{0} setmanes
        year,anys,{0}/any,{0} any,{0} anys,anys,{0}/a,{0} any,{0} anys,anys,{0} per any,{0} any,{0} anys
        ampere,A,,,{0} A,A,,,{0} A,amperes,,{0} ampere,{0} amperes
        milliampere,,,,,,,,,mil liamperes,,{0} mil liampere,{0} mil liamperes
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,ohms,,{0} ohm,{0} ohms
        volt,V,,,{0} V,V,,,{0} V,volts,,{0} volt,{0} volts
        british-thermal-unit,,,,,,,,,unitats tèrmiques britàniques,,{0} unitat tèrmica britànica,{0} unitats tèrmiques britàniques
        calorie,,,,,,,,,calories,,{0} caloria,{0} calories
        electronvolt,,,,,,,,,electrons-volt,,{0} electró-volt,{0} electrons-volt
        foodcalorie,cal,,{0} cal,{0} cal,cal,,{0} cal,{0} cal,calories,,{0} caloria,{0} calories
        joule,J,,,{0} J,J,,,{0} J,joules,,{0} joule,{0} joules
        kilocalorie,,,,,,,,,quilocalories,,{0} quilocaloria,{0} quilocalories
        kilojoule,,,,,,,,,quilojoules,,{0} quilojoule,{0} quilojoules
        kilowatt-hour,,,,,,,,,quilowatts hora,,{0} quilowatt hora,{0} quilowatts hora
        therm-us,thm,,{0} thm,{0} thm,unitat tèrmica americana,,{0} thm,{0} thm,unitats tèrmiques americanes,,{0} unitat tèrmica americana,{0} unitats tèrmiques americanes
        kilowatt-hour-per-100-kilometer,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kilowatt hora per 100 quilòmetres,,{0} kilowatt hora per 100 quilòmetres,{0} kilowatts hora per 100 quilòmetres
        newton,,,,,newton,,,{0} N,newtons,,{0} newton,{0} newtons
        pound-force,,,,,lliures-força,,,{0} lbf,lliures de força,,{0} lliura de força,{0} lliures de força
        gigahertz,,,,,,,,,gigahertz,,{0} gigahertz,{0} gigahertzs
        hertz,,,,,,,,,hertz,,{0} hertz,{0} hertzs
        kilohertz,,,,,,,,,quilohertz,,{0} quilohertz,{0} quilohertzs
        megahertz,,,,,,,,,megahertz,,{0} megahertz,{0} megahertzs
        dot-per-centimeter,ppcm,,{0} ppcm,{0} ppcm,ppcm,,{0} ppcm,{0} ppcm,píxels per centímetre,,{0} píxel per centímetre,{0} píxels per centímetre
        dot-per-inch,ppp,,{0} ppp,{0} ppp,ppp,,{0} ppp,{0} ppp,píxels per polzada,,{0} píxel per polzada,{0} píxels per polzada
        em,,,,,,,,,em tipogràfic,,,{0} em
        megapixel,Mpx,,{0} Mpx,{0} Mpx,megapíxels,,{0} Mpx,{0} Mpx,megapíxels,,{0} megapíxel,{0} megapíxels
        pixel,,,,,píxels,,,{0} px,píxels,,{0} píxel,{0} píxels
        pixel-per-centimeter,px/cm,,{0} px/cm,{0} px/cm,píxels per cm,,{0} píxel per cm,{0} píxels per cm,píxels per centímetre,,{0} píxel per centímetre,{0} píxels per centímetre
        pixel-per-inch,PPI,,{0} PPI,{0} PPI,PPI,,{0} PPI,{0} PPI,píxels per polzada,,{0} píxel per polzada,{0} píxels per polzada
        astronomical-unit,ua,,{0} ua,{0} ua,ua,,{0} ua,{0} ua,unitats astronòmiques,,{0} unitat astronòmica,{0} unitats astronòmiques
        centimeter,,,,,,,,,centímetres,{0} per centímetre,{0} centímetre,{0} centímetres
        decimeter,,,,,,,,,decímetres,,{0} decímetre,{0} decímetres
        earth-radius,,,,,,,,,radi terrestre,,{0} radi terrestre,{0} radis terrestres
        fathom,braça,,,{0} fth,fth,,,{0} fth,braces,,{0} braça,{0} braces
        foot,,,,,peus,{0}/ft,,{0} ft,peus,{0} per peu,{0} peu,{0} peus
        furlong,,,,,,,,,estadis,,{0} estadi,{0} estadis
        inch,,,,,polzades,{0}/in,,{0} in,polzades,{0} per polzada,{0} polzada,{0} polzades
        kilometer,,,,,,,,,quilòmetres,{0} per quilòmetre,{0} quilòmetre,{0} quilòmetres
        light-year,anys llum,,{0} a. ll.,{0} a. ll.,anys llum,,{0} any ll.,{0} anys ll.,anys llum,,{0} any llum,{0} anys llum
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,metres,{0} per metre,{0} metre,{0} metres
        micrometer,,,,,,,,,micròmetres,,{0} micròmetre,{0} micròmetres
        mile,,,,,milles,,,{0} mi,milles,,{0} milla,{0} milles
        mile-scandinavian,,,,,,,,,milles escandinaves,,{0} milla escandinava,{0} milles escandinaves
        millimeter,,,,,,,,,mil límetres,,{0} mil límetre,{0} mil límetres
        nanometer,,,,,,,,,nanòmetre,,{0} nanòmetre,{0} nanòmetres
        nautical-mile,NM,,{0} NM,{0} NM,NM,,{0} NM,{0} NM,milles nàutiques,,{0} milla nàutica,{0} milles nàutiques
        parsec,parsec,,,{0} pc,parsecs,,,{0} pc,parsecs,,{0} parsec,{0} parsecs
        picometer,,,,,,,,,picòmetres,,{0} picòmetre,{0} picòmetres
        point,,,,,punts,,,{0} pt,punts,,{0} punt tipogràfic,{0} punts tipogràfics
        solar-radius,,,,,,,,,radis solars,,{0} radi solar,{0} radis solars
        yard,,,,,iardes,,,{0} yd,iardes,,{0} iarda,{0} iardes
        candela,,,,,,,,,candela,,{0} candela,{0} candeles
        lumen,,,,,,,,,lumen,,{0} lumen,{0} lumens
        lux,lux,,,{0} lx,lux,,,{0} lx,lux,,{0} lux,{0} luxs
        solar-luminosity,,,,,lluminositats solars,,,{0} L☉,lluminositats solars,,{0} lluminositat solar,{0} lluminositats solars
        carat,quirat,,{0} ct,{0} ct,quirat,,{0} ct,{0} ct,quirats,,{0} quirat,{0} quirats
        dalton,,,,,,,,,daltons,,{0} dalton,{0} daltons
        earth-mass,,,,,,,,,masses de la Terra,,{0} massa de la Terra,{0} masses de la Terra
        grain,gra,,{0} gra,{0} grans,gra,,{0} gra,{0} grans,grans,,{0} gra,{0} grans
        gram,g,{0}/g,,{0} g,grams,{0}/g,,{0} g,grams,{0} per gram,{0} gram,{0} grams
        kilogram,,,,,,,,,quilograms,{0} per quilogram,{0} quilogram,{0} quilograms
        microgram,,,,,,,,,micrograms,,{0} microgram,{0} micrograms
        milligram,,,,,,,,,mil ligrams,,{0} mil ligram,{0} mil ligrams
        ounce,,,,,,,,,unces,{0} per unça,{0} unça,{0} unces
        ounce-troy,ozt,,{0} ozt,{0} ozt,ozt,,{0} ozt,{0} ozt,unces troy,,{0} unça troy,{0} unces troy
        pound,,,,,,,,,lliures,{0} per lliura,{0} lliura,{0} lliures
        solar-mass,,,,,,,,,masses solars,,{0} massa solar,{0} masses solars
        stone,,,,,,,,,pedres,,{0} pedra,{0} pedres
        ton,t,,{0} t,{0} t,t,,{0} t,{0} t,tones,,{0} tona,{0} tones
        tonne,t,,{0} t m,{0} t m,t mètr.,,{0} t m,{0} t mètr.,tones mètriques,,{0} tona mètrica,{0} tones mètriques
        gigawatt,,,,,,,,,gigawatts,,{0} gigawatt,{0} gigawatts
        horsepower,CV,,{0} CV,{0} CV,CV,,{0} CV,{0} CV,cavalls de vapor,,{0} cavall de vapor,{0} cavalls de vapor
        kilowatt,kW,,{0}kW,{0}kW,,,,,quilowatts,,{0} quilowatt,{0} quilowatts
        megawatt,,,,,,,,,megawatts,,{0} megawatt,{0} megawatts
        milliwatt,,,,,,,,,mil liwatts,,{0} mil liwatt,{0} mil liwatts
        watt,W,,,{0} W,W,,,{0} W,watts,,{0} watt,{0} watts
        atmosphere,,,,,,,,,atmosferes,,{0} atmosfera,{0} atmosferes
        bar,bar,,{0} bar,{0} bars,bar,,{0} bar,{0} bars,bars,,{0} bar,{0} bars
        hectopascal,,,,,,,,,hectopascals,,{0} hectopascal,{0} hectopascals
        inch-ofhg,,,,,,,,,polzades de mercuri,,{0} polzada de mercuri,{0} polzades de mercuri
        kilopascal,,,,,,,,,quilopascals,,{0} quilopascal,{0} quilopascals
        megapascal,,,,,,,,,megapascals,,{0} megapascal,{0} megapascals
        millibar,mbar,,{0} mb,{0} mb,,,,,mil libars,,{0} mil libar,{0} mil libars
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,mmHg,,{0} mmHg,{0} mmHg,mil límetres de mercuri,,{0} mil límetre de mercuri,{0} mil límetres de mercuri
        pascal,,,,,,,,,pascals,,{0} pascal,{0} pascals
        pound-force-per-square-inch,,,,,,,,,lliures per polzada quadrada,,{0} lliura per polzada quadrada,{0} lliures per polzada quadrada
        beaufort,,,,,,,,,Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,,,,,,,,,quilòmetres per hora,,{0} quilòmetre per hora,{0} quilòmetres per hora
        knot,,,,,,,,,nusos,,{0} nus,{0} nusos
        light-speed,llum,,{0} llum,{0} llum,llum,,{0} llum,{0} llum,llum,,{0} llum,{0} llum
        meter-per-second,,,,,,,,,metres per segon,,{0} metre per segon,{0} metres per segon
        mile-per-hour,,,,,,,,,milles per hora,,{0} milla per hora,{0} milles per hora
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,graus Celsius,,{0} grau Celsius,{0} graus Celsius
        fahrenheit,°F,,{0}°F,{0}°F,°F,,{0} °F,{0} °F,graus Fahrenheit,,{0} grau Fahrenheit,{0} graus Fahrenheit
        generic,,,,,,,,,grau,,{0} grau,{0} graus
        kelvin,,,,,,,,,Kelvin,,{0} Kelvin,{0} Kelvin
        newton-meter,,,,,,,,,newtons-metre,,{0} newton-metre,{0} newtons-metre
        pound-force-foot,,,,,,,,,lliures-peu,,{0} lliura-peu,{0} lliures-peu
        acre-foot,,,,,,,,,acre-peu,,{0} acre-peu,{0} acres-peus
        barrel,,,,,,,,,barrils,,{0} barril,{0} barrils
        bushel,,,,,bushels,,,{0} bu,bushels,,{0} bushel,{0} bushels
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,centilitres,,{0} centilitre,{0} centilitres
        cubic-centimeter,,,,,,,,,centímetres cúbics,{0} per centímetre cúbic,{0} centímetre cúbic,{0} centímetres cúbics
        cubic-foot,,,,,,,,,peus cúbics,,{0} peu cúbic,{0} peus cúbics
        cubic-inch,,,,,,,,,polzades cúbiques,,{0} polzada cúbica,{0} polzades cúbiques
        cubic-kilometer,,,,,,,,,quilòmetres cúbics,,{0} quilòmetre cúbic,{0} quilòmetres cúbics
        cubic-meter,,,,,,,,,metres cúbics,{0} per metre cúbic,{0} metre cúbic,{0} metres cúbics
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,milles cúbiques,,{0} milla cúbica,{0} milles cúbiques
        cubic-yard,,,,,,,,,iardes cúbiques,,{0} iarda cúbica,{0} iardes cúbiques
        cup,tassa,,{0} tassa,{0} tasses,tassa,,{0} tassa,{0} tasses,tasses,,{0} tassa,{0} tasses
        cup-metric,,,,,,,,,tasses mètriques,,{0} tassa mètrica,{0} tasses mètriques
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,decilitres,,{0} decilitre,{0} decilitres
        dessert-spoon,c. postres,,{0} c. postr.,{0} c. postr.,culleradeta postres,,{0} culleradeta postres,{0} culleradetes postres,culleradeta de postres,,{0} culleradeta de postres,{0} culleradetes de postres
        dessert-spoon-imperial,cull. postres imp.,,{0} cull. postres imp.,{0} cull. postres imp.,cull. postres imp.,,{0} cull. postres imp.,{0} cull. postres imp.,culleradeta de postres imperial,,{0} culleradeta de postres imperial,{0} culleradetes de postres imperials
        dram,dracma fluid,,{0} dracma fluid,{0} dracmes fluids,dracma fluid,,{0} dracma fluid,{0} dracmes fluids,dracma,,{0} dracma,{0} dracmes
        drop,gota,,{0} gota,{0} gotes,gota,,{0} gota,{0} gotes,gotes,,{0} gota,{0} gotes
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,unces líquides,,{0} unça líquida,{0} unces líquides
        fluid-ounce-imperial,fl oz imp.,,{0} fl oz imp.,{0} fl oz imp.,fl oz imp.,,{0} fl oz imp.,{0} fl oz imp.,unces líquides imperials,,{0} unça líquida imperial,{0} unces líquides imperials
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,galons,{0} per galó,{0} galó,{0} galons
        gallon-imperial,gal imp.,{0}/gal imp.,{0} gal imp.,{0} gal imp.,gal imp.,{0}/gal imp.,{0} gal imp.,{0} gal imp.,galons imperials,{0} per galó imperial,{0} galó imperial,{0} galons imperials
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hectolitres,,{0} hectolitre,{0} hectolitres
        jigger,mes.,,{0} mes.,{0} mes.,mesurador,,{0} mesurador,{0} mesuradors,mesuradors de cocteleria,,{0} mesurador de cocteleria,{0} mesuradors de cocteleria
        liter,l,{0}/l,,{0} l,l,{0}/l,,{0} l,litres,{0} per litre,{0} litre,{0} litres
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megalitres,,{0} megalitre,{0} megalitres
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,mil lilitres,,{0} mil lilitre,{0} mil lilitres
        pinch,pessic,,{0} pessic,{0} pessics,pessic,,{0} pessic,{0} pessics,pessics,,{0} pessic,{0} pessics
        pint,,,,,,,,,pintes,,{0} pinta,{0} pintes
        pint-metric,ptm,,{0} ptm,{0} ptm,ptm,,{0} ptm,{0} ptm,pintes mètriques,,{0} pinta mètrica,{0} pintes mètriques
        quart,,,,,,,,,quarts,,{0} quart,{0} quarts
        quart-imperial,qt imp,,{0} qt imp,{0} qt imp,quart imperial,,{0} quart imperial,{0} quarts imperials,quarts imperials,,{0} quart imperial,{0} quarts imperials
        tablespoon,cull.,,{0} cull.,{0} cull.,cull.,,{0} cull.,{0} cull.,cullerades,,{0} cullerada,{0} cullerades
        teaspoon,cdta.,,{0} cdta.,{0} cdta.,cdta.,,{0} cdta.,{0} cdta.,culleradetes,,{0} culleradeta,{0} culleradetes
        dot,píxel,,,,,,,,,,,
        """.trimIndent()
  }

  private val ca_Prefixes: String by lazy {
    """square,,,{0} quadrats
        cubic,,,{0} cúbics
        per,,,{0} per {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobi{0}
        10p-1,,,deci{0}
        10p-12,,,pico{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,mil li{0}
        10p-30,,,quecto{0}
        10p-6,,,micro{0}
        10p-9,,,nano{0}
        10p1,,,deca{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hecto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,quilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val ca_AD_Units: String? = null

  private val ca_AD_Prefixes: String? = null

  private val ca_ES_valencia_Units: String? = null

  private val ca_ES_valencia_Prefixes: String? = null

  private val ca_FR_Units: String? = null

  private val ca_FR_Prefixes: String? = null

  private val ca_IT_Units: String? = null

  private val ca_IT_Prefixes: String? = null

  private val cad_Units: String by lazy {
    """day,,,,,,,,,day,{0}/d,,{0} Kaˀisch’áyˀah
        month,,,,,,,,,mon,{0}/m,,Nish {0}
        week,,,,,,,,,wk,{0}/w,,Wísts’iˀ inikuˀ {0}
        """.trimIndent()
  }

  private val cad_Prefixes: String? = null

  private val cch_Units: String? = null

  private val cch_Prefixes: String? = null

  private val ccp_Units: String by lazy {
    """g-force,𑄎𑄨-𑄝𑄧𑄣𑄴,,{0} 𑄎𑄨-𑄝𑄧𑄣𑄴,{0} 𑄎𑄨-𑄝𑄧𑄣𑄴,𑄎𑄨-𑄝𑄧𑄣𑄴,,,{0} G,𑄎𑄨-𑄝𑄧𑄣𑄴,,{0} 𑄎𑄨-𑄝𑄧𑄣𑄴,{0} 𑄎𑄨-𑄝𑄧𑄣𑄴
        meter-per-square-second,,,,,,,,,𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,{0} 𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄇𑄬𑄚𑄴𑄓𑄬,{0} 𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄇𑄬𑄚𑄴𑄓𑄬
        arc-minute,𑄃𑄢𑄴𑄇𑄴𑄟𑄨𑄚𑄴,,{0}𑄟𑄨𑄚𑄨𑄖𑄴,{0}𑄟𑄨𑄚𑄨𑄖𑄴,𑄃𑄢𑄴𑄇𑄴𑄟𑄨𑄚𑄴,,,{0} 𑄃𑄢𑄴𑄇𑄴𑄟𑄨𑄚𑄴,𑄃𑄢𑄴𑄇𑄴-𑄟𑄨𑄚𑄨𑄖𑄴,,{0} 𑄃𑄢𑄴𑄇𑄴-𑄟𑄨𑄚𑄨𑄖𑄴,{0} 𑄃𑄢𑄴𑄇𑄴-𑄟𑄨𑄚𑄨𑄖𑄴
        arc-second,𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,{0}𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,{0}𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,,{0} 𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄴,𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,{0} 𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,{0} 𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴
        degree,𑄓𑄨𑄉𑄳𑄢𑄩,,,{0}𑄓𑄨𑄉𑄳𑄢𑄩,𑄓𑄨𑄉𑄳𑄢𑄩,,,{0}𑄓𑄨𑄉𑄳𑄢𑄩,𑄓𑄨𑄉𑄳𑄢𑄩,,{0} 𑄓𑄨𑄉𑄳𑄢𑄩,{0} 𑄓𑄨𑄉𑄳𑄢𑄩
        radian,𑄢𑄬𑄓𑄨𑄠𑄳𑄠𑄚𑄳𑄌𑄴,,,{0} rad,𑄢𑄬𑄓𑄨𑄠𑄳𑄠𑄚𑄳𑄌𑄴,,,{0} rad,𑄢𑄬𑄓𑄨𑄠𑄚𑄴,,{0} 𑄢𑄬𑄓𑄨𑄠𑄚𑄴,{0} 𑄢𑄬𑄓𑄨𑄠𑄳𑄠𑄚𑄴𑄥𑄴
        revolution,𑄊𑄪𑄢𑄰𑄱,,,{0} 𑄊𑄪𑄢𑄰𑄱,𑄊𑄪𑄢𑄰𑄱,,,{0} 𑄊𑄪𑄢𑄰𑄱,𑄊𑄪𑄢𑄮𑄚𑄴,,{0} 𑄢𑄨𑄞𑄮𑄣𑄨𑄅𑄪𑄥𑄧𑄚𑄴,{0} 𑄊𑄪𑄢𑄮𑄚𑄴
        acre,𑄃𑄬𑄉𑄧𑄢𑄴,,,{0} 𑄃𑄬𑄉𑄧𑄢𑄴,𑄃𑄬𑄉𑄧𑄢𑄴,,,{0} 𑄃𑄬𑄉𑄧𑄢𑄴,𑄃𑄬𑄇𑄧𑄢𑄴,,{0} 𑄃𑄬𑄇𑄧𑄢𑄴,{0} 𑄃𑄬𑄇𑄧𑄢𑄴
        hectare,𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴,,,{0} 𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴,𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴,,,{0} 𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴,𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴,,,{0} 𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴
        square-centimeter,,,,,,,,,𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴
        square-foot,𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴,,,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴,𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴,,,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴,𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴,,,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴
        square-inch,,,,,,,,,𑄝𑄧𑄢𑄴𑄉𑄧 𑄃𑄨𑄚𑄴𑄌𑄨,𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄃𑄨𑄚𑄴𑄌𑄨𑄖𑄴 {0},{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄃𑄨𑄚𑄴𑄌𑄨,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄃𑄨𑄚𑄴𑄌𑄨
        square-kilometer,km²,{0}/𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄟𑄨,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄟𑄨,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄟𑄨,km²,{0}/𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄟𑄨,,{0} km²,𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴𑄢𑄳𑄠 {0},{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴
        square-meter,𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴,{0}/m²,{0} m²,{0} m²,𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴,{0}/m²,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴,{0} m²,𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴,𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄬 {0},{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴
        square-mile,𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄴,{0}/mi²,,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄴,𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄴,{0}/mi²,,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄴,𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄭,𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄬{0},{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄭,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄭
        square-yard,𑄝𑄧𑄢𑄴𑄉𑄧 𑄉𑄧𑄌𑄴,,,{0} yd²,𑄝𑄧𑄢𑄴𑄉𑄧 𑄉𑄧𑄌𑄴,,,{0} yd²,yd²,,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄉𑄧𑄌𑄴,{0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄉𑄧𑄌𑄴
        karat,𑄇𑄳𑄠𑄢𑄬𑄖𑄴,,,{0} kt,𑄇𑄳𑄠𑄢𑄬𑄖𑄴,,,{0} kt,𑄇𑄳𑄠𑄢𑄬𑄖𑄴,,{0} 𑄇𑄳𑄠𑄢𑄬𑄖𑄴,{0} 𑄇𑄳𑄠𑄢𑄬𑄖𑄴
        milligram-ofglucose-per-deciliter,,,,,,,,,"𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄬",,"{0} 𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄬","{0} 𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄬"
        millimole-per-liter,,,,,,,,,"𑄟𑄨𑄣𑄨𑄟𑄮𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄣𑄨𑄑𑄢𑄬",,"{0} 𑄟𑄨𑄣𑄨𑄟𑄮𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄣𑄨𑄑𑄢𑄬","{0} 𑄟𑄨𑄣𑄨𑄟𑄮𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄣𑄨𑄑𑄢𑄬"
        permillion,,,,,,,,,"𑄞𑄇𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄘𑄧𑄌𑄴 𑄣𑄬𑄉",,"{0} 𑄞𑄧𑄇𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄘𑄧𑄌𑄴 𑄣𑄉𑄬","{0} 𑄞𑄧𑄇𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄘𑄧𑄌𑄴 𑄣𑄉𑄬"
        liter-per-100-kilometer,,,,,,,,,"𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄷𑄶𑄶 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬",,"{0} 𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄷𑄶𑄶 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬","{0} 𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄷𑄶𑄶 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬"
        liter-per-kilometer,𑄣𑄨𑄑𑄢𑄴/𑄇𑄨𑄟𑄨,,,{0} L/km,𑄣𑄨𑄑𑄢𑄴/𑄇𑄨𑄟𑄨,,,{0} L/km,"𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬",,"{0} 𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬","{0} 𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬"
        mile-per-gallon,𑄟𑄬𑄣𑄴/𑄉𑄳𑄠𑄣𑄧𑄚𑄴,,,{0} mpg,𑄟𑄬𑄣𑄴/𑄉𑄳𑄠𑄣𑄧𑄚𑄴,,,{0} mpg,"𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄠𑄣𑄧𑄚𑄬",,"{0} 𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄠𑄣𑄧𑄚𑄬","{0} 𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄠𑄣𑄧𑄚𑄬"
        mile-per-gallon-imperial,miles/gal Imp,,,{0} mpg Imp.,miles/gal Imp,,,{0} mpg Imp.,"𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄬",,"{0} 𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄬","{0} 𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄬"
        bit,𑄝𑄨𑄖𑄴,,,{0} 𑄝𑄨𑄖𑄴,𑄝𑄨𑄖𑄴,,,{0} 𑄝𑄨𑄖𑄴,𑄝𑄨𑄖𑄴,,,{0} 𑄝𑄨𑄖𑄴
        byte,𑄝𑄭𑄖𑄴,,,{0} 𑄝𑄭𑄖𑄴,𑄝𑄭𑄖𑄴,,,{0} 𑄝𑄭𑄖𑄴,𑄝𑄭𑄖𑄴,,,{0} 𑄝𑄭𑄖𑄴
        gigabit,,,,,,,,,𑄉𑄨𑄉𑄝𑄨𑄖𑄴,,{0} 𑄉𑄨𑄉𑄝𑄨𑄖𑄴,{0} 𑄉𑄨𑄉𑄝𑄨𑄖𑄴
        gigabyte,,,,,,,,,𑄉𑄨𑄉𑄝𑄭𑄖𑄴,,{0} 𑄉𑄨𑄉𑄝𑄭𑄖𑄴,{0} 𑄉𑄨𑄉𑄝𑄭𑄖𑄴
        kilobit,,,,,,,,,𑄇𑄨𑄣𑄮𑄝𑄨𑄖𑄴,,{0} 𑄇𑄨𑄣𑄮𑄝𑄨𑄖𑄴,{0} 𑄇𑄨𑄣𑄮𑄝𑄨𑄖𑄴
        kilobyte,,,,,,,,,𑄇𑄨𑄣𑄮𑄝𑄭𑄖𑄴,,{0} 𑄇𑄨𑄣𑄮𑄝𑄭𑄖𑄴,{0} 𑄇𑄨𑄣𑄮𑄝𑄭𑄖𑄴
        megabit,,,,,,,,,𑄟𑄬𑄉𑄝𑄨𑄖𑄴,,{0} 𑄟𑄬𑄉𑄝𑄨𑄖𑄴,{0} 𑄟𑄬𑄉𑄝𑄨𑄖𑄴
        megabyte,,,,,,,,,𑄟𑄬𑄉𑄝𑄭𑄖𑄴,,{0} 𑄟𑄬𑄉𑄝𑄭𑄖𑄴,{0} 𑄟𑄬𑄉𑄝𑄭𑄖𑄴
        terabit,Tbit,,,{0} Tb,Tbit,,,{0} Tb,𑄑𑄬𑄢𑄝𑄨𑄖𑄴,,{0} 𑄑𑄬𑄢𑄝𑄨𑄖𑄴,{0} 𑄑𑄬𑄢𑄝𑄨𑄖𑄴
        terabyte,TByte,,,{0} TB,TByte,,,{0} TB,𑄑𑄢𑄝𑄭𑄖𑄴,,{0} 𑄑𑄢𑄝𑄭𑄖𑄴,{0} 𑄑𑄢𑄝𑄭𑄖𑄴
        century,𑄥𑄧𑄖𑄧𑄇𑄴,,,{0} 𑄥𑄧𑄖𑄧𑄇𑄴,𑄥𑄧𑄖𑄧𑄇𑄴,,,{0} 𑄥𑄧𑄖𑄧𑄇𑄴,𑄃𑄬𑄇𑄴𑄥𑄧 𑄝𑄧𑄏𑄧𑄢𑄴,,{0} 𑄃𑄬𑄇𑄴𑄥𑄧 𑄝𑄧𑄏𑄧𑄢𑄴,{0} 𑄃𑄬𑄇𑄴𑄥𑄧 𑄝𑄧𑄏𑄧𑄢𑄴
        day,𑄘𑄨𑄚𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄘𑄨𑄚𑄴,,{0} 𑄘𑄨𑄚𑄴,𑄘𑄨𑄚𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄘𑄨𑄚𑄴,,{0} 𑄘𑄨𑄚𑄴,𑄘𑄨𑄚𑄴,{0} 𑄘𑄨𑄚𑄴 𑄟𑄉𑄬𑄚𑄬,,{0} 𑄘𑄨𑄚𑄴
        hour,𑄊𑄧𑄚𑄴𑄑,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄊𑄧𑄚𑄴𑄑,{0} 𑄊𑄂,{0} 𑄊𑄂,𑄊𑄧𑄚𑄴𑄑,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄊𑄧𑄚𑄴𑄑,,{0} 𑄊𑄧𑄚𑄴𑄑,𑄊𑄧𑄚𑄴𑄘,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄊𑄧𑄚𑄴𑄘,{0} 𑄊𑄧𑄚𑄴𑄘,{0} 𑄊𑄧𑄚𑄴𑄘
        microsecond,μsecs,,,{0} μs,μsecs,,,{0} μs,𑄟𑄭𑄇𑄳𑄢𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,{0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,{0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴
        millisecond,𑄟𑄨𑄣𑄨𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,,{0} ms,𑄟𑄨𑄣𑄨𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,,{0} ms,𑄟𑄨𑄣𑄨𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,{0}𑄟𑄨𑄣𑄨𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,{0} 𑄟𑄨𑄣𑄨𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴
        minute,𑄟𑄨𑄚𑄨𑄖𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄨𑄚𑄨𑄖𑄴,{0} 𑄟𑄨𑄂,{0} 𑄟𑄨𑄂,𑄟𑄨𑄚𑄨𑄖𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄨𑄚𑄨𑄖𑄴,,{0} 𑄟𑄨𑄚𑄨𑄖𑄴,𑄟𑄨𑄚𑄨𑄖𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄨𑄚𑄨𑄖𑄴,,{0} 𑄟𑄨𑄚𑄨𑄖𑄴
        month,𑄟𑄌𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄌𑄴,,{0} 𑄟𑄌𑄴,𑄟𑄌𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄌𑄴,,{0} 𑄟𑄌𑄴,𑄟𑄌𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄌𑄴,,{0} 𑄟𑄌𑄴
        nanosecond,𑄚𑄳𑄠𑄚𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,,{0} ns,𑄚𑄳𑄠𑄚𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,,{0} ns,𑄚𑄳𑄠𑄚𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,{0} 𑄚𑄳𑄠𑄚𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,{0} 𑄚𑄳𑄠𑄚𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴
        second,𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,{0} 𑄥𑄬𑄂,{0} 𑄥𑄬𑄂,𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,{0} 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,{0} 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴
        week,𑄥𑄛𑄴𑄖,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄛𑄴𑄖,,{0} 𑄥𑄛𑄴𑄖,𑄥𑄛𑄴𑄖,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄛𑄴𑄖,,{0} 𑄥𑄛𑄴𑄖,𑄥𑄛𑄴𑄖,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄛𑄴𑄖,,{0} 𑄥𑄛𑄴𑄖
        year,𑄝𑄧𑄏𑄧𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄏𑄧𑄢𑄴,,{0} 𑄝𑄧𑄏𑄧𑄢𑄴,𑄝𑄧𑄏𑄧𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄏𑄧𑄢𑄴,,{0} 𑄝𑄧𑄏𑄧𑄢𑄴,𑄝𑄧𑄏𑄧𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄏𑄧𑄢𑄴,,{0} 𑄝𑄧𑄏𑄧𑄢𑄴
        ampere,,,,,,,,,𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴,,{0} 𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴,{0} 𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴
        milliampere,,,,,,,,,𑄟𑄨𑄣𑄨-𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴,,{0} 𑄟𑄨𑄣𑄨-𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴,{0} 𑄟𑄨𑄣𑄨-𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴
        ohm,𑄃𑄮𑄦𑄧𑄟𑄴,,,{0} Ω,𑄃𑄮𑄦𑄧𑄟𑄴,,,{0} Ω,𑄃𑄮𑄦𑄧𑄟𑄴,,{0} 𑄃𑄮𑄦𑄧𑄟𑄴,{0} 𑄃𑄮𑄦𑄧𑄟𑄴
        volt,𑄞𑄮𑄣𑄴𑄑𑄴,,,{0} V,𑄞𑄮𑄣𑄴𑄑𑄴,,,{0} V,𑄣𑄮𑄣𑄳𑄑𑄴,,{0} 𑄞𑄮𑄣𑄳𑄑𑄴,{0} 𑄞𑄮𑄣𑄳𑄑𑄴
        calorie,,,,,,,,,𑄇𑄳𑄠𑄣𑄮𑄢𑄨,,{0} 𑄇𑄳𑄠𑄣𑄮𑄢𑄨,{0} 𑄇𑄳𑄠𑄣𑄮𑄢𑄨
        joule,𑄎𑄪𑄣𑄴,,,{0} J,𑄎𑄪𑄣𑄴,,,{0} J,𑄎𑄪𑄣𑄴,,{0} 𑄎𑄪𑄣𑄴,{0} 𑄎𑄪𑄣𑄴
        kilocalorie,,,,,,,,,𑄇𑄨𑄣𑄮𑄇𑄳𑄠𑄣𑄮𑄢𑄨,,{0} 𑄇𑄨𑄣𑄮𑄇𑄳𑄠𑄣𑄮𑄢𑄨,{0}𑄇𑄨𑄣𑄮𑄇𑄳𑄠𑄣𑄮𑄢𑄨
        kilojoule,,,,,,,,,𑄇𑄨𑄣𑄮𑄎𑄪𑄣𑄴,,{0} 𑄇𑄨𑄣𑄮𑄎𑄪𑄣𑄴,{0} 𑄇𑄨𑄣𑄮𑄎𑄪𑄣𑄴
        kilowatt-hour,,,,,,,,,𑄇𑄨𑄣𑄮𑄃𑄮𑄠𑄖𑄴 𑄊𑄧𑄚𑄳𑄑,,{0} 𑄇𑄨𑄣𑄮𑄃𑄮𑄠𑄖𑄴 𑄊𑄧𑄚𑄳𑄑,{0} 𑄇𑄨𑄣𑄮𑄃𑄮𑄠𑄖𑄴 𑄊𑄧𑄚𑄳𑄑
        gigahertz,,,,,,,,,𑄉𑄨𑄉𑄦𑄢𑄴𑄎𑄴,,{0} 𑄉𑄨𑄉𑄦𑄢𑄴𑄎𑄴,{0} 𑄉𑄨𑄉𑄦𑄢𑄴𑄎𑄴
        hertz,,,,,,,,,𑄦𑄢𑄴𑄎𑄴,,{0} 𑄦𑄢𑄴𑄎𑄴,{0} 𑄦𑄢𑄴𑄎𑄴
        kilohertz,,,,,,,,,𑄇𑄨𑄣𑄮𑄦𑄢𑄴𑄎𑄴,,{0} 𑄇𑄨𑄣𑄮𑄦𑄢𑄴𑄎𑄴,{0} 𑄇𑄨𑄣𑄮𑄦𑄢𑄴𑄎𑄴
        megahertz,,,,,,,,,𑄟𑄬𑄉𑄦𑄢𑄴𑄎𑄴,,{0} 𑄟𑄬𑄉𑄦𑄢𑄴𑄎𑄴,{0} 𑄟𑄬𑄉𑄦𑄢𑄴𑄎𑄴
        astronomical-unit,,,,,,,,,𑄎𑄳𑄠𑄬𑄖𑄨𑄢𑄴𑄝𑄨𑄇𑄴𑄉𑄳𑄠𑄚𑄴 𑄃𑄬𑄇𑄧𑄇𑄴,,{0} 𑄎𑄳𑄠𑄬𑄖𑄨𑄢𑄴𑄝𑄨𑄇𑄴𑄉𑄳𑄠𑄚𑄴 𑄃𑄬𑄇𑄧𑄇𑄴,{0} 𑄎𑄳𑄠𑄬𑄖𑄨𑄢𑄴𑄝𑄨𑄇𑄴𑄉𑄳𑄠𑄚𑄴 𑄃𑄬𑄇𑄧𑄇𑄴
        centimeter,𑄥𑄬𑄟𑄨,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄟𑄨,,{0} 𑄥𑄬𑄟𑄨,𑄥𑄬𑄟𑄨,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄟𑄨,,{0} 𑄥𑄬𑄟𑄨,𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴
        decimeter,𑄓𑄬𑄟𑄨,,,{0} 𑄓𑄬𑄟𑄨,𑄓𑄬𑄟𑄨,,,{0} 𑄓𑄬𑄟𑄨,𑄓𑄬𑄥𑄨𑄟𑄨𑄑𑄢𑄴,,{0} 𑄓𑄬𑄥𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄓𑄬𑄥𑄨𑄟𑄨𑄑𑄢𑄴
        foot,𑄜𑄪𑄖𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄜𑄪𑄖𑄴,,{0} 𑄜𑄪𑄖𑄴,𑄜𑄪𑄖𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄜𑄪𑄖𑄴,,{0} 𑄜𑄪𑄖𑄴,𑄜𑄪𑄖𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄜𑄪𑄖𑄴,,{0} 𑄜𑄪𑄖𑄴
        inch,𑄃𑄨𑄚𑄴𑄌𑄨,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄚𑄴𑄌𑄨,,{0} 𑄃𑄨𑄚𑄴𑄌𑄨,𑄃𑄨𑄚𑄴𑄌𑄨,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄚𑄴𑄌𑄨,,{0} 𑄃𑄨𑄚𑄴𑄌𑄨,𑄃𑄨𑄚𑄴𑄌𑄨,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄚𑄴𑄌𑄨,,{0} 𑄃𑄨𑄚𑄴𑄌𑄨
        kilometer,𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄟𑄨,,{0} 𑄇𑄨𑄟𑄨,𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄟𑄨,,{0} 𑄇𑄨𑄟𑄨,𑄇𑄨𑄣𑄮𑄟𑄨𑄢𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,{0} 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,{0} 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴
        light-year,𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴,,{0} 𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄢𑄴,{0} 𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄢𑄴,𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴,,,{0} 𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴,𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴,,,{0} 𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴
        meter,𑄟𑄨𑄑𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄨,,{0} 𑄟𑄨,𑄟𑄨𑄑𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄨,,{0} 𑄟𑄨,𑄟𑄨𑄑𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄨𑄑𑄢𑄴,{0} 𑄟𑄨𑄑𑄢𑄴,{0} 𑄟𑄨𑄑𑄢𑄴
        micrometer,μmeters,,,{0} μm,μmeters,,,{0} μm,𑄟𑄭𑄇𑄳𑄢𑄮𑄟𑄨𑄑𑄢𑄴,,{0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄟𑄨𑄑𑄢𑄴,{0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄟𑄨𑄑𑄢𑄴
        mile,𑄟𑄬𑄣𑄴,,,{0} 𑄟𑄬𑄣𑄴,𑄟𑄬𑄣𑄴,,,{0} 𑄟𑄬𑄣𑄴,𑄟𑄬𑄣𑄴,,,{0} 𑄟𑄬𑄣𑄴
        mile-scandinavian,,,,,,,,,𑄟𑄬𑄣𑄴-𑄥𑄳𑄇𑄳𑄠𑄚𑄴𑄓𑄨𑄚𑄬𑄞𑄨𑄠𑄚𑄴,,{0} 𑄟𑄬𑄣𑄴-𑄥𑄳𑄇𑄳𑄠𑄚𑄴𑄓𑄨𑄚𑄬𑄞𑄨𑄠𑄚𑄴,{0} 𑄟𑄬𑄣𑄴-𑄥𑄳𑄇𑄳𑄠𑄚𑄴𑄓𑄨𑄚𑄬𑄞𑄨𑄠𑄚𑄴
        millimeter,𑄟𑄨𑄟𑄨,,,{0} 𑄟𑄨𑄟𑄨,𑄟𑄨𑄟𑄨,,,{0} 𑄟𑄨𑄟𑄨,𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴,,{0} 𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴
        nanometer,,,,,,,,,𑄚𑄳𑄠𑄚𑄮𑄟𑄨𑄑𑄢𑄴,,{0} 𑄚𑄳𑄠𑄚𑄮𑄟𑄨𑄑𑄢𑄴,{0} 𑄚𑄳𑄠𑄚𑄮𑄟𑄨𑄑𑄢𑄴
        nautical-mile,,,,,,,,,𑄚𑄧𑄑𑄨𑄇𑄳𑄠𑄣𑄴 𑄟𑄬𑄣𑄴,,{0} 𑄚𑄧𑄑𑄨𑄇𑄳𑄠𑄣𑄴 𑄟𑄬𑄣𑄴,{0} 𑄚𑄧𑄑𑄨𑄇𑄳𑄠𑄣𑄴 𑄟𑄬𑄣𑄴
        parsec,parsecs,,,{0} pc,parsecs,,,{0} pc,parsecs,,{0} parsec,{0} parsecs
        picometer,𑄛𑄨𑄟𑄨,,{0}𑄛𑄨𑄟𑄨,{0} 𑄛𑄨𑄟𑄨,𑄛𑄨𑄟𑄨,,,{0} 𑄛𑄨𑄟𑄨,𑄛𑄨𑄇𑄮𑄟𑄨𑄑𑄢𑄴,,{0} 𑄛𑄨𑄇𑄮𑄟𑄨𑄑𑄢𑄴,{0} 𑄛𑄨𑄇𑄮𑄟𑄨𑄑𑄢𑄴
        yard,𑄉𑄧𑄌𑄴,,,{0} 𑄉𑄧𑄌𑄴,𑄉𑄧𑄌𑄴,,,{0} 𑄉𑄧𑄌𑄴,𑄉𑄧𑄌𑄴,,,{0} 𑄉𑄧𑄌𑄴
        lux,,,,,,,,,𑄣𑄇𑄳𑄥𑄴,,{0} 𑄣𑄇𑄳𑄥𑄴,{0} 𑄣𑄇𑄳𑄥𑄴
        carat,𑄇𑄳𑄠𑄢𑄬𑄖𑄴,,,{0} CD,𑄇𑄳𑄠𑄢𑄬𑄖𑄴,,,{0} CD,𑄇𑄳𑄠𑄢𑄬𑄖𑄴,,{0} 𑄇𑄳𑄠𑄢𑄬𑄖𑄴,{0} 𑄇𑄳𑄠𑄢𑄬𑄖𑄴
        gram,𑄉𑄳𑄢𑄟𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄢𑄟𑄴,{0} 𑄉𑄳𑄢𑄟𑄴,{0} 𑄉𑄳𑄢𑄟𑄴,𑄉𑄳𑄢𑄟𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄢𑄟𑄴,{0}𑄉𑄳𑄢𑄟𑄴,{0} 𑄉𑄳𑄢𑄟𑄴,𑄉𑄳𑄢𑄟𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄢𑄟𑄴,{0} 𑄉𑄳𑄢𑄟𑄴,{0} 𑄉𑄳𑄢𑄟𑄴
        kilogram,𑄇𑄬𑄎𑄨,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄬𑄎𑄨,,{0} 𑄇𑄬𑄎𑄨,𑄇𑄬𑄎𑄨,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄬𑄎𑄨,,{0} 𑄇𑄬𑄎𑄨,𑄇𑄨𑄣𑄮𑄉𑄳𑄢𑄟𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄉𑄳𑄢𑄟𑄴,{0} 𑄇𑄨𑄣𑄮𑄉𑄳𑄢𑄟𑄴,{0} 𑄇𑄨𑄣𑄮𑄉𑄳𑄢𑄟𑄴
        microgram,,,,,,,,,𑄟𑄭𑄇𑄳𑄢𑄮𑄉𑄳𑄢𑄟𑄴,,{0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄉𑄳𑄢𑄟𑄴,{0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄉𑄳𑄢𑄟𑄴
        milligram,,,,,,,,,𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴,,{0} 𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴,{0} 𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴
        ounce,𑄃𑄅𑄪𑄚𑄳𑄌𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄅𑄪𑄚𑄳𑄌𑄴,,{0} 𑄃𑄅𑄪𑄚𑄳𑄌𑄴,𑄃𑄅𑄪𑄚𑄳𑄌𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄅𑄪𑄚𑄳𑄌𑄴,,{0} 𑄃𑄅𑄪𑄚𑄳𑄌𑄴,𑄃𑄅𑄪𑄚𑄳𑄥𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄅𑄪𑄚𑄳𑄥𑄴,{0} 𑄃𑄅𑄪𑄚𑄳𑄥𑄴,{0} 𑄃𑄅𑄪𑄚𑄳𑄥𑄴
        ounce-troy,,,,,,,,,𑄛𑄳𑄢𑄧𑄠𑄴 𑄃𑄅𑄪𑄚𑄳𑄥𑄴,,{0} 𑄛𑄳𑄢𑄧𑄠𑄴 𑄃𑄅𑄪𑄚𑄳𑄥𑄴,{0} 𑄛𑄳𑄢𑄧𑄠𑄴 𑄃𑄅𑄪𑄚𑄳𑄥𑄴
        pound,𑄛𑄅𑄪𑄚𑄳𑄓𑄴,{0}/lb,{0} 𑄛𑄅𑄪𑄚𑄳𑄓𑄴,{0} 𑄛𑄅𑄪𑄚𑄳𑄓𑄴,𑄛𑄅𑄪𑄚𑄳𑄓𑄴,{0}/lb,{0} 𑄛𑄅𑄪𑄚𑄳𑄓𑄴,{0} lb,𑄛𑄅𑄪𑄚𑄳𑄓𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄛𑄅𑄪𑄚𑄳𑄓𑄴,{0} 𑄛𑄅𑄪𑄚𑄳𑄓𑄴,{0} 𑄛𑄅𑄪𑄚𑄳𑄓𑄴
        ton,,,,,,,,,𑄑𑄧𑄚𑄴,,{0} 𑄑𑄧𑄚𑄴,{0} 𑄑𑄧𑄚𑄴
        tonne,,,,,,,,,𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄑𑄧𑄚𑄴,,{0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄑𑄧𑄚𑄴,{0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄑𑄧𑄚𑄴
        gigawatt,,,,,,,,,𑄉𑄨𑄉𑄤𑄖𑄴,,{0} 𑄉𑄨𑄉𑄤𑄖𑄴,{0} 𑄉𑄨𑄉𑄤𑄖𑄴
        horsepower,,,,,,,,,𑄦𑄧𑄢𑄴𑄥𑄴𑄛𑄤𑄢𑄴,,{0} 𑄦𑄧𑄢𑄴𑄥𑄴𑄛𑄤𑄢𑄴,{0} 𑄦𑄧𑄢𑄴𑄥𑄴𑄛𑄤𑄢𑄴
        kilowatt,kW,,{0} 𑄇𑄨𑄣𑄮𑄤𑄖𑄴,{0} 𑄇𑄨𑄣𑄮𑄤𑄖𑄴,,,,,𑄇𑄨𑄣𑄮𑄤𑄖𑄴,,{0} 𑄇𑄨𑄣𑄮𑄤𑄖𑄴,{0} 𑄇𑄨𑄣𑄮𑄤𑄖𑄴
        megawatt,,,,,,,,,𑄟𑄬𑄉𑄤𑄖𑄴,,{0} 𑄟𑄬𑄉𑄤𑄖𑄴,{0} 𑄟𑄬𑄉𑄤𑄖𑄴
        milliwatt,,,,,,,,,𑄟𑄨𑄣𑄨𑄤𑄖𑄴,,{0} 𑄟𑄨𑄣𑄨𑄤𑄖𑄴,{0} 𑄟𑄨𑄣𑄨𑄤𑄖𑄴
        watt,𑄤𑄖𑄴,,{0} 𑄤𑄖𑄴,{0} 𑄤𑄖𑄴,𑄤𑄖𑄴,,,{0} W,𑄤𑄖𑄴,,{0} 𑄤𑄖𑄴,{0} 𑄤𑄖𑄴
        hectopascal,,,,,,,,,𑄦𑄬𑄇𑄴𑄑𑄮𑄛𑄥𑄴𑄇𑄧𑄣𑄴,,{0} 𑄦𑄬𑄇𑄴𑄑𑄮𑄛𑄥𑄴𑄇𑄧𑄣𑄴,{0} 𑄦𑄬𑄇𑄴𑄑𑄮𑄛𑄥𑄴𑄇𑄧𑄣𑄴
        inch-ofhg,,,,,,,,,𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄢𑄧𑄖𑄴,,{0} 𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄢𑄧𑄖𑄴,{0} 𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄢𑄧𑄖𑄴
        millibar,mbar,,{0} mb,{0} mb,,,,,𑄟𑄨𑄣𑄨𑄝𑄢𑄴,,{0} 𑄟𑄨𑄣𑄨𑄝𑄢𑄴,{0}𑄟𑄨𑄣𑄨𑄝𑄢𑄴
        millimeter-ofhg,,,,,,,,,𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴 𑄛𑄢𑄧𑄖𑄴,,{0} 𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴 𑄛𑄢𑄧𑄖𑄴,{0} 𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴 𑄛𑄢𑄧𑄖𑄴
        pound-force-per-square-inch,,,,,,,,,𑄝𑄧𑄢𑄴𑄉𑄧𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄳𑄢𑄧𑄖𑄨 𑄛𑄅𑄪𑄚𑄳𑄓𑄴,,{0} 𑄝𑄧𑄢𑄴𑄉𑄧𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄳𑄢𑄧𑄖𑄨 𑄛𑄅𑄪𑄚𑄳𑄓𑄴,{0} 𑄝𑄧𑄢𑄴𑄉𑄧𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄳𑄢𑄧𑄖𑄨 𑄛𑄅𑄪𑄚𑄳𑄓𑄴
        kilometer-per-hour,km/hr,,{0}kph,{0}kph,km/h,,{0} kph,{0} km/h,𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,,{0} 𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,{0} 𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴
        knot,,,,,,,,,𑄚𑄧𑄖𑄴,,{0} 𑄚𑄧𑄖𑄴,{0} 𑄚𑄧𑄖𑄴
        meter-per-second,𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,{0}m/s,{0}m/s,𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,,{0} m/s,𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,,{0} 𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴,{0} 𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴
        mile-per-hour,𑄊𑄧𑄚𑄴𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄬𑄣𑄴,,{0}mph,{0}mph,𑄊𑄧𑄚𑄴𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄬𑄣𑄴,,,{0} mph,𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄬𑄣𑄴,,{0} 𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄬𑄣𑄴,{0} 𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄬𑄣𑄴
        celsius,,,,,deg. C,,,{0}°C,𑄓𑄨𑄉𑄳𑄢𑄩 𑄥𑄬𑄣𑄴𑄥𑄨𑄠𑄌𑄴,,{0} 𑄓𑄨𑄉𑄳𑄢𑄩 𑄥𑄬𑄣𑄴𑄥𑄨𑄠𑄌𑄴,{0} 𑄓𑄨𑄉𑄳𑄢𑄩 𑄥𑄬𑄣𑄴𑄥𑄨𑄠𑄌𑄴
        fahrenheit,,,,,,,,,𑄓𑄨𑄉𑄳𑄢𑄩 𑄜𑄢𑄬𑄚𑄴𑄦𑄭𑄖𑄴,,{0} 𑄓𑄨𑄉𑄳𑄢𑄩 𑄜𑄢𑄬𑄚𑄴𑄦𑄭𑄖𑄴,{0} 𑄓𑄨𑄉𑄳𑄢𑄩 𑄜𑄢𑄬𑄚𑄴𑄦𑄭𑄖𑄴
        kelvin,,,,,,,,,𑄇𑄬𑄣𑄴𑄞𑄨𑄚𑄴,,{0} 𑄇𑄬𑄣𑄴𑄞𑄨𑄚𑄴,{0} 𑄇𑄬𑄣𑄴𑄞𑄨𑄚𑄴
        acre-foot,,,,,,,,,𑄃𑄬𑄇𑄧𑄢𑄴-𑄜𑄪𑄖𑄴,,{0} 𑄃𑄬𑄇𑄧𑄢𑄴-𑄜𑄪𑄖𑄴,{0} 𑄃𑄬𑄇𑄧𑄢𑄴-𑄜𑄪𑄖𑄴
        centiliter,,,,,,,,,𑄥𑄬𑄚𑄴𑄑𑄨𑄣𑄨𑄑𑄢𑄴,,{0} 𑄥𑄬𑄚𑄴𑄑𑄨𑄣𑄨𑄑𑄢𑄴,{0} 𑄥𑄬𑄚𑄴𑄑𑄨𑄣𑄨𑄑𑄢𑄴
        cubic-centimeter,,,,,,,,,𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴
        cubic-foot,,,,,,,,,𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄜𑄪𑄖𑄴,,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄜𑄪𑄖𑄴,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄜𑄪𑄖𑄴
        cubic-inch,,,,,,,,,𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄃𑄨𑄚𑄴𑄌𑄨,,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄃𑄨𑄚𑄴𑄌𑄨,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄃𑄨𑄚𑄴𑄌𑄨
        cubic-kilometer,𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,,{0}km³,{0}km³,𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,,,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴,,,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴
        cubic-meter,,,,,,,,,𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄨𑄑𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄨𑄑𑄢𑄴,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄨𑄑𑄢𑄴,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄨𑄑𑄢𑄴
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄬𑄣𑄴,,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄬𑄣𑄴,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄬𑄣𑄴
        cubic-yard,,,,,,,,,𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄉𑄧𑄌𑄴,,{0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄉𑄧𑄌𑄴,{0} yd³
        cup,,,,,,,,,𑄇𑄛𑄴,,{0} 𑄇𑄛𑄴,{0} 𑄇𑄛𑄴
        cup-metric,,,,,,,,,𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄇𑄛𑄴,,{0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄇𑄛𑄴,{0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄇𑄛𑄴
        deciliter,,,,,,,,,𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄴,,{0} 𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄴,{0} 𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄴
        fluid-ounce,fl oz,,,{0} fl oz,fl oz,,,{0} fl oz,𑄜𑄳𑄣𑄪𑄃𑄨𑄓𑄴 𑄃𑄅𑄪𑄚𑄳𑄌𑄴,,{0} 𑄜𑄳𑄣𑄪𑄃𑄨𑄓𑄴 𑄃𑄅𑄪𑄚𑄳𑄌𑄴,{0} 𑄜𑄳𑄣𑄪𑄃𑄨𑄓𑄴 𑄃𑄅𑄪𑄚𑄳𑄌𑄴
        gallon,gal,{0}/gal US,,{0} gal,gal,{0}/gal US,,{0} gal,𑄉𑄳𑄠𑄣𑄧𑄚𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄠𑄣𑄧𑄚𑄴,{0} 𑄉𑄳𑄠𑄣𑄧𑄚𑄴,{0} 𑄉𑄳𑄠𑄣𑄧𑄚𑄴
        gallon-imperial,,,,,,,,,𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄴,{0} 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄴,{0} 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄴
        hectoliter,,,,,,,,,𑄦𑄬𑄇𑄴𑄑𑄮𑄣𑄨𑄑𑄢𑄴,,{0} 𑄦𑄬𑄇𑄴𑄑𑄮𑄣𑄨𑄑𑄢𑄴,{0} 𑄦𑄬𑄇𑄴𑄑𑄮𑄣𑄨𑄑𑄢𑄴
        liter,𑄣𑄨𑄑𑄢𑄴,{0}/l,,{0} 𑄣𑄨𑄑𑄢𑄴,𑄣𑄨𑄑𑄢𑄴,{0}/l,,{0} 𑄣𑄨𑄑𑄢𑄴,𑄣𑄨𑄑𑄢𑄴,{0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄣𑄨𑄑𑄢𑄴,,{0} 𑄣𑄨𑄑𑄢𑄴
        megaliter,,,,,,,,,𑄟𑄬𑄉𑄣𑄨𑄑𑄢𑄴,,{0} 𑄟𑄬𑄉𑄣𑄨𑄑𑄢𑄴,{0} 𑄟𑄬𑄉𑄣𑄨𑄑𑄢𑄴
        milliliter,,,,,,,,,𑄟𑄨𑄣𑄨𑄣𑄨𑄑𑄢𑄴,,{0} 𑄟𑄨𑄣𑄨𑄣𑄨𑄑𑄢𑄴,{0} 𑄟𑄨𑄣𑄨𑄣𑄨𑄑𑄢𑄴
        pint,,,,,,,,,𑄛𑄨𑄚𑄳𑄑𑄴,,{0} 𑄛𑄨𑄚𑄳𑄑𑄴,{0} 𑄛𑄨𑄚𑄳𑄑𑄴
        pint-metric,,,,,,,,,𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄛𑄨𑄚𑄳𑄑𑄴,,{0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄛𑄨𑄚𑄳𑄑𑄴,{0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄛𑄨𑄚𑄳𑄑𑄴
        quart,,,,,,,,,𑄇𑄮𑄠𑄢𑄴𑄑𑄴,,{0} 𑄇𑄮𑄠𑄢𑄴𑄑𑄴,{0} 𑄇𑄮𑄠𑄢𑄴𑄑𑄴
        tablespoon,,,,,,,,,𑄑𑄬𑄝𑄨𑄣𑄴 𑄌𑄟𑄬𑄌𑄴,,{0} 𑄑𑄬𑄝𑄨𑄣𑄴 𑄌𑄟𑄬𑄌𑄴,{0} 𑄑𑄬𑄝𑄨𑄣𑄴 𑄌𑄟𑄬𑄌𑄴
        teaspoon,,,,,,,,,𑄌 𑄌𑄟𑄬𑄌𑄴,,{0} 𑄌 𑄌𑄟𑄬𑄌𑄴,{0} 𑄌 𑄌𑄟𑄬𑄌𑄴
        """.trimIndent()
  }

  private val ccp_Prefixes: String by lazy {
    """per,,,{1} 𑄛𑄳𑄢𑄧𑄖𑄨 {0}
        """.trimIndent()
  }

  private val ccp_IN_Units: String? = null

  private val ccp_IN_Prefixes: String? = null

  private val ce_Units: String by lazy {
    """day,д.,{0}/d,{0} д.,{0} д.,денош,{0}/d,д.,{0} д.,денош,{0} дийнахь,{0} де,{0} де
        hour,сахь,{0} сахь.,{0} сахь.,{0} сахь.,сахь,{0} сахь.,{0} сахь.,{0} сахь.,сахьташ,{0} сахьтехь,{0} сахьт,{0} сахьт
        microsecond,мкс,,{0} мкс,{0} мкс,мкс,,{0} мкс,{0} мкс,микросекундаш,,{0} микросекунд,{0} микросекунд
        millisecond,мс,,{0} мс,{0} мс,мс,,{0} мс,{0} мс,миллисекундаш,,{0} миллисекунд,{0} миллисекунд
        minute,мин,{0}/min,{0} мин,{0} мин,мин,{0}/min,{0} мин,{0} мин,миноташ,{0} минотехь,{0} минот,{0} минот
        month,бут,{0}/m,{0} б.,{0} б.,бут,{0}/m,{0} бут.,{0} бут.,беттанаш,{0} баттахь,{0} бутт,{0} бутт
        nanosecond,нс,,{0} нс,{0} нс,нс,,{0} нс,{0} нс,наносекундаш,,{0} наносекунд,{0} наносекунд
        second,с,{0}/s,{0} с,{0} с,сек,{0}/s,{0} сек,{0} сек,секундаш,{0} секундехь,{0} секунд,{0} секунд
        week,кӀир,{0}/w,{0} кӀ.,{0} кӀ.,кӀир,{0}/w,{0} кӀир.,{0} кӀир.,кӀиранаш,{0} кӀиранахь,{0} кӀира,{0} кӀира
        year,ш.,{0} ш.,{0} ш.,{0} ш.,ш.,{0} ш.,{0} ш.,{0} ш.,шераш,{0} шарахь,{0} шо,{0} шо
        astronomical-unit,а. д.,,{0} а. д.,{0} а. д.,а. д.,,{0} а. д.,{0} а. д.,астрономин дакъош,,{0} астрономин дакъа,{0} астрономин дакъа
        centimeter,см,{0}/cm,{0} см,{0} cm,см,{0}/cm,{0} см,{0} см,сантиметраш,{0} сантиметрехь,{0} сантиметр,{0} сантиметр
        decimeter,дм,,{0} дм,{0} дм,дм,,{0} дм,{0} дм,дециметраш,,{0} дециметр,{0} дециметр
        foot,футаш,{0}/ft,{0} фут,{0} фут,футаш,{0}/ft,{0} фут,{0} фут,футаш,{0}/ft,{0} фут,{0} фут
        inch,дюйм,{0}/in,{0} дюйм.,{0} дюйм.,дюйм,{0}/in,{0} дюйм.,{0} дюйм.,дюймаш,{0}/in,{0} дюйм,{0} дюйм
        kilometer,км,{0}/km,{0} км,{0} км,км,{0}/km,{0} км,{0} км,километраш,{0}/km,{0} километр,{0} километр
        """.trimIndent()
  }

  private val ce_Prefixes: String? = null

  private val ceb_Units: String by lazy {
    """g-force,,,,,,,,,g-force,,{0} g-force,{0} g-force
        meter-per-square-second,mga metro/sec²,,,{0} m/s²,mga metro/sec²,,,{0} m/s²,mga metro kada segundo kwadrado,,{0} ka metro kada segundo kwadrado,{0} ka mga metro kada segundo kwadrado
        arc-minute,mga arcmin,,{0} ka arcmin,{0} ka mga arcmin,mga arcmin,,{0} ka arcmin,{0} ka mga arcmin,mga arcminute,,{0} ka arcminute,{0} ka mga arcminute
        arc-second,mga arcsec,,{0} ka arcsec,{0} ka mga arcsec,mga arcsec,,{0} ka arcsec,{0} ka mga arcsec,mga arcsecond,,{0} ka arcsecond,{0} ka mga arcsecond
        degree,mga degree,,{0} deg,{0} deg,mga degree,,{0} deg,{0} deg,mga degree,,{0} ka degree,{0} ka mga degree
        radian,mga radian,,,{0} rad,mga radian,,,{0} rad,mga radian,,{0} ka radian,{0} ka mga radian
        revolution,,,,,,,,,rebolusyon,,{0} ka rebolusyon,{0} ka mga rebolusyon
        acre,mga acre,,,{0} ac,mga acre,,,{0} ac,mga acre,,{0} ka acre,{0} ka mga acre
        dunam,mga dunam,,{0} ka dunam,{0} ka dunam,mga dunam,,{0} ka dunam,{0} ka dunam,mga dunam,,{0} ka dunam,{0} ka mga dunam
        hectare,mga ektarya,,,{0} ha,mga ektarya,,,{0} ha,mga ektarya,,{0} ka ektarya,{0} ka mga ektarya
        square-centimeter,,,,,,,,,mga centimetro kwadrado,{0} kada sentimetro kwadrado,{0} ka sentimetro kwadrado,{0} ka mga sentimetro kwadrado
        square-foot,mga sq foot,,{0} sq ft,{0} sq ft,mga sq foot,,{0} sq ft,{0} sq ft,mga square foot,,{0} ka square foot,{0} ka mga square foot
        square-inch,mga inch²,{0}/in²,,{0} in²,mga inch²,{0}/in²,,{0} in²,mga square inch,{0} kada square inch,{0} ka mga square inch,{0} ka square inch
        square-kilometer,,,,,,,,,mga square kilometer,{0} kada kilometro kwadrado,{0} ka kilometro kwadrado,{0} ka mga kilometro kwadrado
        square-meter,mga metro²,{0}/m²,,{0} m²,mga metro²,{0}/m²,,{0} m²,mga metro kwadrado,{0} kada metro kwadrado,{0} ka metro kwadrado,{0} ka mga metro kwadrado
        square-mile,mga milya kwadrado,{0}/mi²,{0} sq mi,{0} sq mi,mga milya kwadrado,{0}/mi²,{0} sq mi,{0} sq mi,mga milya kwadrado,{0} kada milya kwadrado,{0} ka milya kwadrado,{0} ka mga milya kwadrado
        square-yard,mga yard²,,,{0} yd²,mga yard²,,,{0} yd²,mga square yard,,{0} ka square yard,{0} ka mga square yard
        karat,mga karat,,,{0} kt,mga karat,,,{0} kt,mga karat,,{0} ka karat,{0} ka mga karat
        milligram-ofglucose-per-deciliter,,,,,,,,,mga milligram kada deciliter,,{0} ka milligram kada deciliter,{0} ka mga milligram kada deciliter
        millimole-per-liter,millimol/litro,,,{0} mmol/L,millimol/litro,,,{0} mmol/L,mga millimole kada litro,,{0} ka millimole kada litro,{0} ka mga millimole kada litro
        mole,mole,,,{0} mol,mole,,,{0} mol,mga mole,,{0} ka mole,{0} ka mga mole
        percent,,,,,porsyento,,,{0}%,porsyento,,{0} ka porsyento,{0} ka porsyento
        permille,permille,,,{0}‰,permille,,,{0}‰,permille,,{0} ka permille,{0} ka permille
        permillion,mga part/million,,,{0} ppm,mga part/million,,,{0} ppm,mga part per million,,{0} ka part per million,{0} ka mga part per million
        permyriad,permyriad,,,{0}‱,permyriad,,,{0}‱,permyriad,,{0} ka permyriad,{0} ka permyriad
        liter-per-100-kilometer,L/100km,,{0}L/100km,{0}L/100km,L/100 km,,{0} L/100 km,{0} L/100 km,mga litro kada 100 kilometro,,{0} ka litro kada 100 kilometro,{0} ka litro kada 100 kilometro
        liter-per-kilometer,mga litro/km,,,{0} L/km,mga litro/km,,,{0} L/km,mga litro kada kilometro,,{0} litro kada kilometro,{0} ka mga litro kada kilometro
        mile-per-gallon,mga milya/gal,,{0} mpg,{0} mpg,mga milya/gal,,{0} mpg,{0} mpg,mga milya kada gallon,,{0} ka milya kada gallon,{0} ka mga milya kada gallon
        mile-per-gallon-imperial,mga milya/gal Imp.,,,{0} mpg Imp.,mga milya/gal Imp.,,,{0} mpg Imp.,mga milya kada Imp. gallon,,{0} ka milya kada Imp. gallon,{0} ka mga milya kada Imp. gallon
        bit,bit,,{0} ka bit,{0} ka bit,bit,,{0} ka bit,{0} ka bit,mga bit,,{0} ka bit,{0} ka mga bit
        byte,byte,,{0} ka byte,{0} ka byte,byte,,{0} ka byte,{0} ka byte,mga byte,,{0} ka byte,{0} ka mga byte
        gigabit,Gbit,,,{0} Gb,Gbit,,,{0} Gb,mga gigabit,,{0} ka gigabit,{0} ka mga gigabit
        gigabyte,GByte,,,{0} GB,GByte,,,{0} GB,mga gigabyte,,{0} ka gigabyte,{0} ka mga gigabyte
        kilobit,kbit,,,{0} kb,kbit,,,{0} kb,mga kilobit,,{0} ka kilobit,{0} ka mga kilobit
        kilobyte,kByte,,,{0} kB,kByte,,,{0} kB,mga kilobyte,,{0} ka kilobyte,{0} ka mga kilobyte
        megabit,Mbit,,,{0} Mb,Mbit,,,{0} Mb,mga megabit,,{0} ka megabit,{0} ka mga megabit
        megabyte,MByte,,,{0} MB,MByte,,,{0} MB,mga megabyte,,{0} ka megabyte,{0} ka mga megabyte
        petabyte,PByte,,,{0} PB,PByte,,,{0} PB,mga petabyte,,{0} ka petabyte,{0} ka mga petabyte
        terabit,Tbit,,,{0} Tb,Tbit,,,{0} Tb,mga terabit,,{0} ka terabit,{0} ka mga terabit
        terabyte,TByte,,,{0} TB,TByte,,,{0} TB,mga terabyte,,{0} ka terabyte,{0} ka mga terabyte
        century,,,,,,,,,mga siglo,,{0} ka siglo,{0} ka mga siglo
        day,adlaw,{0}/adlaw,{0} adlaw,{0} adlaw,mga adlaw,{0}/adlaw,{0} ka adlaw,{0} ka adlaw,mga adlaw,{0} kada adlaw,{0} ka adlaw,{0} ka mga adlaw
        decade,,,,,,,,,mga dekada,,{0} ka dekada,{0} ka mga dekada
        hour,oras,{0}/oras,{0} ka oras,{0} ka oras,mga oras,{0}/oras,{0} ka oras,{0} ka oras,mga oras,{0} kada oras,{0} ka oras,{0} ka mga oras
        microsecond,μsecs,,,{0} μs,μsecs,,,{0} μs,mga microsecond,,{0} ka microsecond,{0} ka mga microsecond
        millisecond,msec,,{0}ms,{0}ms,mga millisec,,,{0} ms,mga millisecond,,{0} ka millisecond,{0} ka mga millisecond
        minute,minuto,{0}/minuto,{0} minuto,{0} minuto,mga minuto,{0}/minuto,{0} ka minuto,{0} ka minuto,mga minuto,{0} kada minuto,{0} ka minuto,{0} ka mga minuto
        month,buwan,{0}/buwan,{0} buwan,{0} buwan,mga buwan,{0}/buwan,{0} ka buwan,{0} ka buwan,mga buwan,{0} kada buwan,{0} ka buwan,{0} ka mga buwan
        nanosecond,mga nanosec,,,{0} ns,mga nanosec,,,{0} ns,mga nanosecond,,{0} ka nanosecond,{0} ka mga nanosecond
        second,segundo,{0}/segundo,{0}segundo,{0}segundo,mga segundo,{0}/segundo,{0}segundo,{0}segundo,mga segundo,{0} kada segundo,{0} ka segundo,{0} ka mga segundo
        week,semana,{0}/semana,{0} semana,{0}w,mga semana,{0}/semana,{0} ka semana,{0} ka semana,mga semana,{0} kada semana,{0} ka semana,{0} ka mga semana
        year,tuig,{0}/tuig,{0} ka tuig,{0} ka tuig,mga tuig,{0}/tuig,{0} ka tuig,{0} ka tuig,mga tuig,{0} kada tuig,{0} ka tuig,{0} ka mga tuig
        ampere,mga amp,,,{0} A,mga amp,,,{0} A,mga ampere,,{0} ka ampere,{0} ka mga ampere
        milliampere,mga milliamp,,,{0} mA,mga milliamp,,,{0} mA,mga milliampere,,{0} milliampere,{0} ka mga milliampere
        ohm,mga ohm,,,{0} Ω,mga ohm,,,{0} Ω,mga ohm,,{0} ka ohm,{0} ka mga ohm
        volt,mga boltahe,,,{0} V,mga boltahe,,,{0} V,mga boltahe,,{0} ka boltahe,{0} ka mga boltahe
        british-thermal-unit,BTU,,,{0} Btu,BTU,,,{0} Btu,Mga British thermal unit,,{0} ka British thermal unit,{0} ka mga British thermal unit
        calorie,,,,,,,,,mga calorie,,{0} ka calorie,{0} ka mga calorie
        electronvolt,electronvolt,,,{0} eV,electronvolt,,,{0} eV,mga electronvolt,,{0} ka electronvolt,{0} ka mga electronvolt
        joule,mga joule,,,{0} J,mga joule,,,{0} J,mga joule,,{0} ka joule,{0} ka mga joule
        kilocalorie,,,,,,,,,mga kilocalorie,,{0} ka kilocalorie,{0} ka mga kilocalorie
        kilojoule,kilojoule,,,{0} kJ,kilojoule,,,{0} kJ,mga kilojoule,,{0} ka kilojoule,{0} ka mga kilojoule
        kilowatt-hour,kW-hour,,,{0} kWh,kW-hour,,,{0} kWh,mga kilowatt-hour,,{0} ka kilowatt hour,{0} ka mga kilowatt-hour
        therm-us,US therm,,{0} ka US therm,{0} ka mga US therm,US therm,,{0} ka US therm,{0} ka mga US therm,Mga US therm,,{0} ka US therm,{0} ka mga US therm
        newton,newton,,,{0} N,newton,,,{0} N,mga newton,,{0} ka newton,{0} ka mga newton
        pound-force,pound-force,,,{0} lbf,pound-force,,,{0} lbf,mga pound sa puwersa,,{0} ka pound sa puwersa,{0} ka mga pound sa puwersa
        gigahertz,,,,,,,,,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,,,,,,,,,hertz,,{0} hertz,{0} hertz
        kilohertz,,,,,,,,,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,,,,,,,,,megahertz,,{0} megahertz,{0} megahertz
        em,em,,{0} ka em,{0} ka em,em,,{0} ka em,{0} ka em,typographic em,,{0} ka em,{0} ka mga em
        megapixel,mga megapixel,,,{0} MP,mga megapixel,,,{0} MP,mga megapixel,,{0} ka megapixel,{0} ka mga megapixel
        pixel,mga pixel,,,{0} px,mga pixel,,,{0} px,mga pixel,,{0} ka pixel,{0} ka mga pixel
        pixel-per-centimeter,,,,,,,,,mga pixel kada sentimetro,,{0} ka pixel kada sentimetro,{0} ka mga pixel kada sentimetro
        pixel-per-inch,,,,,,,,,mga pixel kada pulgada,,{0} ka pixel kada pulgada,{0} ka mga pixel kada pulgada
        astronomical-unit,,,,,,,,,mga astronomical unit,,{0} ka astronomical unit,{0} ka mga astronomical unit
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,mga sentimetro,{0} kada sentimetro,{0} ka sentimetro,{0} ka mga sentimetro
        decimeter,,,,,,,,,mga decimeter,,{0} ka decimeter,{0} ka mga decimeter
        earth-radius,,,,,,,,,radyus sa yuta,,{0} ka radyus sa yuta,{0} ka radyus sa yuta
        foot,mga piye,{0}/ft,,{0} ft,mga piye,{0}/ft,,{0} ft,mga piye,{0} kada piye,{0} ka piye,{0} ka mga piye
        inch,mga pulgada,{0}/in,,{0} in,mga pulgada,{0}/in,,{0} in,mga pulgada,{0} kada pulgada,{0} ka pulgada,{0} ka pulgada
        kilometer,km,{0}/km,{0}km,{0}km,,,,,mga kilometro,{0} kada kilometro,{0} ka kilometro,{0} ka mga kilometro
        light-year,mga light yr,,,{0} ly,mga light yr,,,{0} ly,mga light year,,{0} ka light year,{0} ka mga light year
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,,{0} m,mga metro,{0} kada metro,{0} ka metro,{0} ka mga metro
        micrometer,mga μmeter,,,{0} μm,mga μmeter,,,{0} μm,mga micrometer,,{0} ka micrometer,{0} ka mga micrometer
        mile,mga milya,,,{0} mi,mga milya,,,{0} mi,mga milya,,{0} ka milya,{0} ka mga milya
        mile-scandinavian,,,,,,,,,mile-scandinavian,,{0} ka mile-scandinavian,{0} ka mile-scandinavian
        millimeter,mm,,{0}mm,{0}mm,,,,,mga millimetro,,{0} ka millimetro,{0} ka millimetro
        nanometer,,,,,,,,,mga nanometer,,{0} ka nanometer,{0} ka mga nanometer
        nautical-mile,,,,,,,,,mga nautical mile,,{0} ka nautical mile,{0} ka mga nautical mile
        parsec,mga parsec,,,{0} pc,mga parsec,,,{0} pc,mga parsec,,{0} ka parsec,{0} ka mga parsec
        picometer,,,,,,,,,mga picometer,,{0} ka picometer,{0} ka mga picometer
        point,mga point,,,{0} pt,mga point,,,{0} pt,mga point,,{0} ka point,{0} ka mga point
        solar-radius,mga solar radius,,,{0} R☉,mga solar radius,,,{0} R☉,mga solar radius,,{0} ka solar radius,{0} ka mga solar radius
        yard,mga yarda,,,{0} yd,mga yarda,,,{0} yd,mga yarda,,{0} ka yarda,{0} ka mga yarda
        candela,,,,,,,,,candela,,{0} ka candela,{0} ka candela
        lumen,,,,,,,,,lumen,,{0} ka lumen,{0} ka lumen
        lux,lux,,,{0} lx,lux,,,{0} lx,lux,,{0} lux,{0} lux
        solar-luminosity,mga solar luminosity,,,{0} L☉,mga solar luminosity,,,{0} L☉,mga solar luminosity,,{0} ka solar luminosity,{0}ka mga solar luminosity
        carat,mga carat,,,{0} CD,mga carat,,,{0} CD,mga carat,,{0} ka carat,{0} ka mga carat
        dalton,mga dalton,,,{0} Da,mga dalton,,,{0} Da,mga dalton,,{0} ka dalton,{0} ka mga dalton
        earth-mass,mga mass sa Earth,,,{0} M⊕,mga mass sa Earth,,,{0} M⊕,mga mass sa Earth,,{0} ka mass sa Earth,{0} ka mga mass sa Earth
        grain,,,,,,,,,grain,,{0} ka grain,{0} ka grain
        gram,gramo,{0}/g,,{0} g,mga gramo,{0}/g,,{0} g,mga gramo,{0} kada gramo,{0} ka gramo,{0} ka mga gramo
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,mga kilogramo,{0} kada kilogramo,{0} ka kilogramo,{0} ka mga kilogramo
        microgram,,,,,,,,,mga microgram,,{0} ka microgram,{0} ka mga microgram
        milligram,,,,,,,,,mga milligram,,{0} ka milligram,{0} ka mga milligram
        ounce,,,,,,,,,mga ounce,{0} kada ounce,{0} ka ounce,{0} ka mga ounce
        ounce-troy,oz troy,,,{0} oz t,oz troy,,,{0} oz t,mga troy ounce,,{0} ka troy ounce,{0} ka mga troy ounce
        pound,mga pound,{0}/lb,,{0} lb,mga pound,{0}/lb,,{0} lb,mga pound,{0} kada pound,{0} ka pound,{0} ka mga pound
        solar-mass,mga solar mass,,,{0} M☉,mga solar mass,,,{0} M☉,mga solar mass,,{0} ka solar mass,{0} ka mga solar mass
        ton,mga tonelada,,,{0} tn,mga tonelada,,,{0} tn,mga tonelada,,{0} ka tonelada,{0} ka mga tonelada
        tonne,,,,,,,,,mga metrikong tonelada,,{0} ka metrikong tonelada,{0} ka mga metrikong tonelada
        gigawatt,,,,,,,,,mga gigawatt,,{0} ka gigawatt,{0} ka mga gigawatt
        horsepower,,,,,,,,,horsepower,,{0} ka horsepower,{0} ka horsepower
        kilowatt,,,,,,,,,mga kilowatt,,{0} ka kilowatt,{0} ka mga kilowatt
        megawatt,,,,,,,,,mga megawatt,,{0} ka megawatt,{0} ka mga megawatt
        milliwatt,,,,,,,,,mga milliwatt,,{0} ka milliwatt,{0} ka mga milliwatt
        watt,mga watt,,,{0} W,mga watt,,,{0} W,mga watt,,{0} ka watt,{0} ka mga watt
        atmosphere,,,,,,,,,mga atmosphere,,{0} ka atmosphere,{0} ka mga atmosphere
        bar,bar,,{0} ka bar,{0} ka bar,bar,,{0} ka bar,{0} ka bar,mga bar,,{0} ka bar,{0} ka mga bar
        hectopascal,,,,,,,,,mga hectopascal,,{0} ka hectopascal,{0} ka mga hectopascal
        inch-ofhg,,,,,,,,,mga inch sa mercury,,{0} ka inch sa mercury,{0} ka mga pulgada sa mercury
        kilopascal,,,,,,,,,mga kilopascal,,{0} ka kilopascal,{0} ka mga kilopascal
        megapascal,,,,,,,,,mga megapascal,,{0} ka megapascal,{0} ka mga megapascal
        millibar,mbar,,{0} ka mbar,{0} ka mbar,mbar,,{0} ka mbar,{0} ka mbar,mga millibar,,{0} ka millibar,{0} ka mga millibar
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,mmHg,,{0} mmHg,{0} mmHg,mga millimetro sa mercury,,{0} ka millimetro sa mercury,{0} ka mga millimetro sa mercury
        pascal,,,,,,,,,mga pascal,,{0} ka pascal,{0} ka mga pascal
        pound-force-per-square-inch,,,,,,,,,mga pound kada kuwadradong pulgada,,{0} ka pound kada kuwadradong pulgada,{0} ka mga pound kada kuwadradong pulgada
        kilometer-per-hour,km/hr,,{0}km/h,{0}km/h,km/oras,,,{0} km/h,mga kilometro kada oras,,{0} ka kilometro kada oras,{0} ka mga kilometro kada oras
        knot,,,,,,,,,mga knot,,{0} ka knot,{0} ka mga knot
        meter-per-second,mga metro/seg,,,{0} m/s,mga metro/seg,,,{0} m/s,mga metro kada segundo,,{0} ka metro kada segundo,{0} ka mga metro kada segundo
        mile-per-hour,mga milya/oras,,{0} mph,{0} mph,mga milya/oras,,{0} mph,{0} mph,mga milya kada oras,,{0} ka milya kada oras,{0} ka mga milya kada oras
        celsius,,,,,deg. C,,,{0}°C,mga degree Celsius,,{0} ka degree Celsius,{0} degree Celsius
        fahrenheit,deg. F,,,{0}°F,deg. F,,,{0}°F,mga degree Fahrenheit,,{0} degree Fahrenheit,{0} degree Fahrenheit
        kelvin,,,,,,,,,mga kelvin,,{0} ka kelvin,{0} ka mga kelvin
        newton-meter,,,,,,,,,mga newton-meter,,{0} N⋅m,{0} ka mga newton-meter
        pound-force-foot,,,,,,,,,pound-feet,,{0} ka pound-force-foot,{0} ka mga pound-force-foot
        acre-foot,acre ft,,,{0} ac ft,acre ft,,,{0} ac ft,mga acre-foot,,{0} ka acre-foot,{0} ka mga acre-foot
        barrel,barrel,,,{0} bbl,barrel,,,{0} bbl,mga barrel,,{0} ka barrel,{0} ka mga barrel
        centiliter,,,,,,,,,mga centiliter,,{0} ka centiliter,{0} ka mga centiliter
        cubic-centimeter,,,,,,,,,mga cubic centimeter,{0} kada cubic centimeter,{0} ka cubic centimeter,{0} ka mga cubic centimeter
        cubic-foot,mga foot³,,,{0} ft³,mga foot³,,,{0} ft³,mga cubic foot,,{0} ka cubic foot,{0} ka mga cubic foot
        cubic-inch,mga inch³,,,{0} in³,mga inch³,,,{0} in³,mga cubic inch,,{0} ka cubic inch,{0} ka mga cubic inch
        cubic-kilometer,,,,,,,,,mga cubic kilometer,,{0} ka cubic kilometer,{0} ka mga cubic kilometer
        cubic-meter,,,,,,,,,mga cubic meter,{0} kada cubic meter,{0} ka cubic meter,{0} ka mga cubic meter
        cubic-mile,,,,,,,,,mga cubic mile,,{0} ka cubic mile,{0} ka mga cubic mile
        cubic-yard,mga yard³,,,{0} yd³,mga yard³,,,{0} yd³,mga cubic yard,,{0} ka cubic yard,{0} ka mga cubic yard
        cup,mga tasa,,,{0} c,mga tasa,,,{0} c,mga tasa,,{0} ka tasa,{0} ka mga tasa
        cup-metric,,,,,,,,,mga metric cup,,{0} ka metric cup,{0} ka metric cup
        deciliter,,,,,,,,,mga deciliter,,{0} ka deciliter,{0} ka mga deciliter
        dessert-spoon,,,,,,,,,kutsarang panghinam-is,,{0} ka kutsarang panghinam-is,{0} ka kutsarang panghinam-is
        dessert-spoon-imperial,,,,,,,,,Imp. nga kutsarang panghinam-is,,{0} ka Imp. nga kutsarang panghinam-is,{0} ka Imp. nga kutsarang panghinam-is
        dram,dram fluid,,{0} ka dram fl,{0} ka dram fl,dram fluid,,{0} ka dram fl,{0} ka dram fl,dram,,{0} ka dram,{0} ka dram
        drop,drop,,{0} ka drop,{0} ka drop,drop,,{0} ka drop,{0} ka drop,drop,,{0} ka drop,{0} ka drop
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,mga fluid ounce,,{0} ka fluid ounce,{0} ka mga fluid ounce
        fluid-ounce-imperial,,,,,,,,,mga Imp. fluid ounce,,{0} ka Imp. fluid ounce,{0} ka mga Imp. fluid ounce
        gallon,gal,{0}/gal US,{0} gal,{0} gal,gal,{0}/gal US,{0} gal,{0} gal,mga gallon,{0} kada gallon,{0} ka gallon,{0} ka mga gallon
        gallon-imperial,,,,,,,,,mga Imp. gallon,{0} kada Imp. gallon,{0} ka Imp. gallon,{0} ka mga Imp. gallon
        hectoliter,,,,,,,,,mga hectoliter,,{0} ka hectoliter,{0} ka mga hectoliter
        jigger,jigger,,{0} ka jigger,{0} ka jigger,jigger,,{0} ka jigger,{0} ka jigger,jigger,,{0} ka jigger,{0} ka jigger
        liter,litro,{0}/L,{0}L,{0}L,mga litro,{0}/L,{0} L,{0} L,mga litro,{0} kada litro,{0} ka litro,{0} ka mga litro
        megaliter,,,,,,,,,mga megaliter,,{0} ka megaliter,{0} ka mga megaliter
        milliliter,,,,,,,,,mga milliliter,,{0} ka milliliter,{0} ka mga milliliter
        pinch,pinch,,{0} ka pinch,{0} ka pinch,pinch,,{0} ka pinch,{0} ka pinch,pinch,,{0} ka pinch,{0} ka pinch
        pint,mga pint,,,{0} pt,mga pint,,,{0} pt,mga pint,,{0} ka pint,{0} ka mga pint
        pint-metric,,,,,,,,,mga metric pint,,{0} ka metric pint,{0} ka mga metric pint
        quart,qts,,,{0} qt,qts,,,{0} qt,mga quart,,{0} ka quart,{0} ka mga quart
        quart-imperial,,,,,,,,,Imp. quart,,{0} ka Imp. quart,{0} ka Imp. quart
        tablespoon,,,,,,,,,mga kutsara,,{0} ka kutsara,{0} ka kutsara
        teaspoon,kutsarita,,{0} ka kutsarita,{0} ka kutsarita,kutsarita,,{0} ka kutsarita,{0} ka kutsarita,mga kutsarita,,{0} ka kutsarita,{0} ka mga kutsarita
        """.trimIndent()
  }

  private val ceb_Prefixes: String by lazy {
    """square,,,square {0}
        cubic,,,cubic {0}
        per,,,{0} kada {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobe{0}
        10p-1,,,deci{0}
        10p-12,,,pico{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-3,,,milli{0}
        10p-6,,,micro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hecto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p3,,,kilo{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val cgg_Units: String? = null

  private val cgg_Prefixes: String? = null

  private val cho_Units: String? = null

  private val cho_Prefixes: String? = null

  private val chr_Units: String by lazy {
    """g-force,ᎠᏓᎾᏌᏁᏍᎩ-ᎦᏌᏙᏯᏍᏗ,,{0}G,{0}Gs,ᎠᏓᎾᏌᏁᏍᎩ-ᎦᏌᏙᏯᏍᏗ,,,{0} G,ᎠᏓᎾᏌᏁᏍᎩ-ᎦᏌᏙᏯᏍᏗ,,{0} ᎠᏓᎾᏌᏁᏍᎩ-ᎦᏌᏙᏯᏍᏗ,{0} ᎠᏓᎾᏌᏁᏍᎩ-ᎦᏌᏙᏯᏍᏗ
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,ᏗᏟᎶᏍᏗ/sec²,,,{0} m/s²,ᏗᏟᎶᏗ ᎠᏎᏢ ᎢᏳᏓᎵ ᏅᎩ ᏧᏅᏏᎩ,,{0} ᎠᏟᎶᏗ ᎠᏎᏢ ᎢᏳᏓᎵ ᏅᎩ ᏧᏅᏏᎩ,{0} ᏗᏟᎶᏗ ᎠᏎᏢ ᎢᏳᏓᎵ ᏅᎩ ᏧᏅᏏᎩ
        arc-minute,arcmin,,{0}′,{0}′,ᎠᏥ ᎢᏧᏔᏬᏍᏔᏅ,,{0} arcmin,{0} arcmins,ᎠᏥ ᎢᏧᏔᏬᏍᏔᏅ,,{0} ᎠᏥ ᎢᏯᎦᏔᏬᏍᏔᏅ,{0} ᎠᏥ ᎢᏧᏔᏬᏍᏔᏅ
        arc-second,arcsec,,{0}″,{0}″,ᎠᏥ ᏓᏓᎾᏬᏍᎬ,,{0} arcsec,{0} arcsecs,ᎠᏥ ᏓᏓᎾᏬᏍᎬ,,{0} ᎠᏥ ᎠᏓᎾᏬᏍᎬ,{0} ᎠᏥ ᏓᏓᎾᏬᏍᎬ
        degree,deg,,{0}°,{0}°,ᎢᎦᎢ ᎢᏗᎦᏘ,,{0} deg,{0} deg,ᎢᎦᎢ ᎢᏗᎦᏘ,,{0} ᎢᎦᎢ ᎢᎦ,{0} ᎢᎦᎢ ᎢᏗᎦᏘ
        radian,rad,,{0}rad,{0}rad,ᎠᏥ ᎠᏟᎶᏍᏙᏗ,,,{0} rad,ᎠᏥ ᏗᏟᎶᏍᏙᏗ,,{0} ᎠᏥ ᎠᏟᎶᏍᏙᏗ,{0} ᎠᏥ ᏗᏟᎶᏍᏙᏗ
        revolution,rev,,{0}rev,{0}rev,ᎠᏕᏲᎲ,,{0} ᎠᏕᏲᎲ,{0} ᎠᏕᏲᎲ,ᎠᏕᏲᎲ,,{0} ᎠᏕᏲᎲ,{0} ᏗᏕᏲᎯ
        acre,ᎢᏧᏟᎶᏓ,,{0}ac,{0}ac,ᎢᏧᏟᎶᏓ,,{0} ᏑᏟᎶ,{0} ᏑᏟᎶ,ᎢᏧᏟᎶᏓ,,{0} ᏑᏟᎶᏓᎢ,{0} ᎢᏧᏟᎶᏓ
        dunam,ᏚᎾᎹ,,{0}ᏚᎾᎹ,{0}ᏚᎾᎹ,ᏚᎾᎹᏍ,,{0} ᏚᎾᎹ,{0} ᏚᎾᎹ,ᏚᎾᎹᏍ,,{0} ᏚᎾᎹ,{0} ᏚᎾᎹᏍ
        hectare,ᎮᏔ ᎢᏳᏟᎶᏛ,,{0}ha,{0}ha,ᎮᏔ ᎢᏳᏟᎶᏛ,,,{0} ha,ᎮᏔ ᏑᏟᎶᏛ,,{0} ᎮᏔ ᏑᏟᎶᏛ,{0} ᎮᏔ ᎢᏳᏟᎶᏛ
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,,,,,ᏅᎩ ᏧᏍᏗ ᏗᏟᎶᏍᏗ,{0} ᏅᎩ ᎤᏍᏗ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ,{0} ᏅᎩ ᎤᏍᏗ ᎠᏟᎶᏍᏗ,{0} ᏅᎩ ᏧᏍᏗ ᏗᏟᎶᏍᏗ
        square-foot,ft²,,{0}ft²,{0}ft²,ᏅᎩ ᏧᏅᏏᏱ ᎢᏗᎳᏏᏗ,,{0} sq ft,{0} sq ft,ᏅᎩ ᏧᏅᏏᏱ ᎢᏗᎳᏏᏗ,,{0} ᏅᎩ ᏧᏅᏏᏱ ᎢᏗᎳᏏᏗ,{0} ᏅᎩ ᏧᏅᏏᏱ ᎢᏗᎳᏏᏗ
        square-inch,in²,{0}/in²,{0}in²,{0}in²,ᎢᏗᏏᏔᏗᏍᏗ²,{0}/in²,,{0} in²,ᏅᎩ ᏧᏅᏏᏱ ᎢᏗᏏᏔᏗᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏱ ᎢᏏᏔᏗᏍᏗ ᎢᏳᏓᎵ,{0} ᏅᎩ ᏧᏅᏏᏱ ᎢᏏᏔᏗᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏱ ᎢᏗᏏᏔᏗᏍᏗ
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,ᏅᎩ ᏧᏅᏏᏱ ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏱ ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ,{0} ᏅᎩ ᏧᏅᏏᏱ ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏱ ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ
        square-meter,ᏗᏟᎶᏍᏗ²,{0}/m²,{0}m²,{0}m²,ᏗᏟᎶᏍᏗ²,{0}/m²,,{0} m²,ᏅᎩ ᏧᏅᏏᏱ ᏗᏟᎶᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏱ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ,{0} ᏅᎩ ᏧᏅᏏᏱ ᎠᏟᎶᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏱ ᏗᏟᎶᏍᏗ
        square-mile,mi²,{0}/mi²,{0}mi²,{0}mi²,ᏅᎩ ᏧᏅᏏᏱ ᎢᏳᏟᎶᏓ,{0}/mi²,{0} ᏅᏧᎢ,{0} ᏅᏧᎢ,ᏅᎩ ᏧᏅᏏᏱ ᎢᏳᏟᎶᏓ,{0} ᏅᎩ ᏧᏅᏏᏱ ᏑᏟᎶᏓ ᎢᏳᏓᎵ,{0} ᏅᎩ ᏧᏅᏏᏱ ᏑᏟᎶᏓ,{0} ᏅᎩ ᏧᏅᏏᏱ ᎢᏳᏟᎶᏓ
        square-yard,yd²,,{0}yd²,{0}yd²,ᏗᏯᏯᏗ²,,,{0} yd²,ᏅᎩ ᏧᏅᏏᏱ ᏗᏯᏯᏗ,,{0} ᏅᎩ ᏧᏅᏏᏱ ᏯᏗ,{0} ᏅᎩ ᏧᏅᏏᏱ ᏗᏯᏯᏗ
        item,ᏑᏓᎴᎩ,,{0} ᏑᏓᎴᎩ,{0} ᎢᏳᏓᎴᎩ,ᏑᏓᎴᎩ,,{0} ᏑᏓᎴᎩ,{0} ᎢᏳᏓᎴᎩ,ᏑᏓᎴᎩ,,{0} ᏑᏓᎴᎩ,{0} ᎢᏳᏓᎴᎩ
        karat,ᎧᏇᏓ,,{0}kt,{0}kt,ᏗᎧᏇᏓ,,,{0} kt,ᏗᎧᏇᏓ,,{0} ᎧᏇᏓ,{0} ᏗᎧᏇᏓ
        milligram-ofglucose-per-deciliter,mg/dL,,{0}mg/dL,{0}mg/dL,,,,,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎤᏍᏗ ᏂᏚᏓᎨᏒ ᏌᏉ ᎢᏳᎾᏓᎢ ᏍᎪᎯ ᎵᏔᎢ ᎢᏳᏓᎵ,,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎤᏍᏗ ᎤᏓᎨᏒ ᏌᏉ ᎢᏳᎾᏓᎢ ᏍᎪᎯ ᎵᏔᎢ ᎢᏳᏓᎵ,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎤᏍᏗ ᏂᏚᏓᎨᏒ ᏌᏉ ᎢᏳᎾᏓᎢ ᏍᎪᎯ ᎵᏔᎢ ᎢᏳᏓᎵ
        millimole-per-liter,mmol/L,,{0}mmol/L,{0}mmol/L,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎼᎵ ᎵᏔᎢ ᎢᏳᏓᎵ,,,{0} mmol/L,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎠᏂᎼᎵ ᎵᏔᎢ ᎢᏳᏓᎵ,,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎼᎵ ᎵᏔᎢ ᎢᏳᏓᎵ,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎠᏂᎼᎵ ᎵᏔᎢ ᎢᏳᏓᎵ
        mole,mol,,{0}mol,{0}mol,ᎼᎴ,,,{0} mol,ᎼᎴᏍ,,{0} ᎼᎴ,{0} ᎼᎴᏍ
        percent,,,,,ᏓᎬᏩᎶᏛ,,,{0}%,ᏓᎬᏩᎶᏛ,,{0} ᏓᎬᏩᎶᏛ,{0} ᏓᎬᏩᎶᏛ
        permille,,,,,ᏈᎻᎴ,,,{0}‰,ᏈᎻᎴ,,{0} ᏈᎻᎴ,{0} ᏈᎻᎴ
        permillion,ppm,,{0}ppm,{0}ppm,ᏚᏙᏢᏒ/ᎢᏳᏆᏗᏅᏛ,,,{0} ppm,ᏚᏙᏢᏒ ᎢᏳᏆᏗᏅᏛ ᎢᏳᏓᎵ,,{0} ᎤᏙᏢᏒ ᎢᏳᏆᏗᏅᏛ ᎢᏳᏓᎵ,{0} ᏚᏙᏢᏒ ᎢᏳᏆᏗᏅᏛ ᎢᏳᏓᎵ
        permyriad,,,,,ᏋᎻᎵᎠᏗ,,,{0}‱,ᏋᎻᎵᎠᏗ,,{0} ᏋᎻᎵᎠᏗ,{0} ᏋᎻᎵᎠᏗ
        portion-per-1e9,ᏚᏙᏢᏒ/ᎢᏳᏔᎵᎳᏗᏅᏛ,,{0}ppb,{0}ppb,ᏚᏙᏢᏒ/ᎢᏳᏔᎵᎳᏗᏅᏛ,,,{0} ppb,ᏚᏙᏢᏒ ᎢᏳᏓᎵ ᎢᏳᏔᎵᎳᏗᏅᏛ,,{0} ᎤᏙᏢᏒ ᎢᏳᏓᎵ ᎢᏳᏔᎵᎳᏗᏅᏛ,{0} ᏚᏙᏢᏒ ᎢᏳᏓᎵ ᎢᏳᏔᎵᎳᏗᏅᏛ
        liter-per-100-kilometer,L/100km,,{0}L/100km,{0}L/100km,L/100 km,,{0} L/100 km,{0} L/100 km,ᏗᎵᏔᎢ 100 ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ ᎢᏳᏓᎵ,,{0} ᎵᏔᎢ 100 ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ ᎢᏳᏓᎵ,{0} ᏗᎵᏔᎢ 100 ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ ᎢᏳᏓᎵ
        liter-per-kilometer,L/km,,{0}L/km,{0}L/km,ᏗᎵᏔᎢ/ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ,,,{0} L/km,ᏗᎵᏔᎢ ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ,,{0} ᎵᏔᎢ ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ,{0} ᏗᎵᏔᎢ ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ
        mile-per-gallon,mpg,,{0}mpg,{0}mpg,ᎢᏧᏟᎶᏓ/ᎢᏳᎵᎶᏓ,,{0} mpg,{0} mpg,ᎢᏧᏟᎶᏓ ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ,,{0} ᏑᏟᎶᏓ ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ,{0} ᎢᏧᏟᎶᏓ ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ
        mile-per-gallon-imperial,mpg UK,,{0}m/gUK,{0}m/gUK,ᎢᏧᏟᎶᏓ/ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎢᏳᎵᎶᏓ,,,{0} mpg Imp.,ᎢᏧᏟᎶᏓ ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ,,{0} ᏑᏟᎶᏓ ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ,{0} ᎢᏧᏟᎶᏓ ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ
        bit,ᎤᏍᎦᎳ,,{0}ᎤᏍᎦᎳ,{0}ᎤᏍᎦᎳ,ᎤᏍᎦᎳ,,{0} ᎤᏍᎦᎳ,{0} ᎤᏍᎦᎳ,ᎤᏍᎦᎵᏨ,,{0} ᎤᏍᎦᎳ,{0} ᎤᏍᎦᎵᏨ
        byte,B,,{0}B,{0}B,ᎠᏍᎦᎳ,,{0} ᎠᏍᎦᎳ,{0} ᎠᏍᎦᎳ,ᏗᏓᏍᎦᎵᎩ,,{0} ᎠᏍᎦᎳ,{0} ᏗᏓᏍᎦᎵᎩ
        gigabit,Gb,,{0}Gb,{0}Gb,ᎩᎦᎤᏍᎦᎳ,,,{0} Gb,ᎩᎦᎤᏍᎦᎵᏨ,,{0} ᎩᎦᎤᏍᎦᎳ,{0} ᎩᎦᎤᏍᎦᎵᏨ
        gigabyte,GB,,{0}GB,{0}GB,ᎩᎦᎠᏍᎦᎳ,,,{0} GB,ᎩᎦᏗᏓᏍᎦᎵᎩ,,{0} ᎩᎦᎠᏍᎦᎳ,{0} ᎩᎦᏗᏓᏍᎦᎵᎩ
        kilobit,kb,,{0}kb,{0}kb,ᎠᎦᏴᎵ ᎤᏍᎦᎳ,,,{0} kb,ᎠᎦᏴᎵ ᎤᏍᎦᎵᏨ,,{0} ᎠᎦᏴᎵ ᎤᏍᎦᎳ,{0} ᎠᎦᏴᎵ ᎤᏍᎦᎵᏨ
        kilobyte,kB,,{0}kB,{0}kB,ᎠᎦᏴᎵ ᎠᏍᎦᎳ,,,{0} kB,ᎠᎦᏴᎵ ᏗᏓᏍᎦᎵᎩ,,{0} ᎠᎦᏴᎵ ᎠᏍᎦᎳ,{0} ᎠᎦᏴᎵ ᏗᏓᏍᎦᎵᎩ
        megabit,Mb,,{0}Mb,{0}Mb,ᎺᎦ ᎤᏍᎦᎳ,,,{0} Mb,ᎺᎦ ᎤᏍᎦᎵᏨ,,{0} ᎺᎦ ᎤᏍᎦᎳ,{0} ᎺᎦ ᎤᏍᎦᎵᏨ
        megabyte,MB,,{0}MB,{0}MB,ᎺᎦ ᏗᏓᏍᎦᎵᎩ,,,{0} MB,ᎺᎦ ᏗᏓᏍᎦᎵᎩ,,{0} ᎺᎦ ᎠᏍᎦᎳ,{0} ᎺᎦ ᏗᏓᏍᎦᎵᎩ
        petabyte,PB,,{0}PB,{0}PB,PByte,,,{0} PB,ᏇᏔ ᏗᏓᏍᎦᎵᎩ,,{0} ᏇᏔ ᏗᏓᏍᎦᎵᎩ,{0} ᏇᏔ ᏗᏓᏍᎦᎵᎩ
        terabit,Tb,,{0}Tb,{0}Tb,ᏕᎳ ᎤᏍᎦᎳ,,,{0} Tb,ᏕᎳ ᎤᏍᎦᎵᏨ,,ᏕᎳ ᎤᏍᎦᎳ,{0} ᏕᎳ ᎤᏍᎦᎵᏨ
        terabyte,TB,,{0}TB,{0}TB,ᏕᎳ ᎠᏍᎦᎳ,,,{0} TB,ᏕᎳ ᏗᏓᏍᎦᎵᎩ,,{0} ᏕᎳ ᎠᏍᎦᎳ,{0} ᏕᎳ ᏗᏓᏍᎦᎵᎩ
        century,ᏍᏧ,,{0}ᏍᏧ,{0}ᏍᏧ,ᏍᏧ,,{0} ᏍᏧ,{0} ᏍᏧ,ᏍᎪᎯᏧᏈ ᏧᏕᏘᏴᏓ,,{0} ᏍᎪᎯᏧᏈ ᏧᏕᏘᏴᏓ,{0} ᏍᎪᎯᏧᏈ ᏧᏕᏘᏴᏓ
        day,ᎢᎦ,{0}/Ꭲ,{0}Ꭲ,{0}Ꭲ,ᎯᎸᏍᎩ ᏧᏒᎯᏓ,{0}/Ꭲ,{0} ᎢᎦ,{0} ᏧᏒᎯᏓ,ᎯᎸᏍᎩ ᏧᏒᎯᏓ,{0} ᎢᎦ ᎢᏳᏓᎵ,{0} ᎢᎦ,{0} ᎯᎸᏍᎩ ᏧᏒᎯᏓ
        decade,ᏍᎪᎯ,,{0}ᏍᎪᎯ,{0}ᏍᎪᎯ,ᏍᎪᎯ,,{0} ᏍᎪᎯ,{0} ᏍᎪᎯ,ᏍᎪᎯ ᏧᏕᏘᏴᏓ,,{0} ᏍᎪᎯ ᏧᏕᏘᏴᏓ,{0} ᏍᎪᎯ ᏧᏕᏘᏴᏓ
        hour,ᏑᏟᎶᏓ,{0}/Ꮡ,{0}Ꮡ,{0}Ꮡ,ᎢᏳᏟᎶᏓ,{0}/Ꮡ,{0} ᏑᏟ,{0} ᏑᏟ,ᎢᏳᏟᎶᏓ,{0} ᏑᏟᎶᏓ ᎢᏳᏓᎵ,{0} ᏑᏟᎶᏓ,{0} ᎢᏳᏟᎶᏓ
        microsecond,μᏗᏎᏢ,,{0}μs,{0}μs,μᏗᏎᏢ,,,{0} μs,ᏌᏉ ᎢᏳᏆᏗᏅᏛ ᏗᏎᏢ,,{0} ᏌᏉ ᎢᏳᏆᏗᏅᏛ ᎠᏎᏢ,{0} ᏌᏉ ᎢᏳᏆᏗᏅᏛ ᏗᏎᏢ
        millisecond,ᏌᎠ,,{0}ᏌᎠ,{0}ᏌᎠ,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏎᏢ,,{0} ᏌᎠ,{0} ᏌᎠ,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏎᏢ,,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎠᏎᏢ,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏎᏢ
        minute,ᎢᏯᏔ,{0}/ᎢᏯᏔ,{0}Ꭲ,{0}Ꭲ,ᎢᏯᏔᏬᏍᏔᏅ,{0}/ᎢᏯᏔ,{0} ᎢᏯᏔ,{0} ᎢᏯᏔ,ᎢᏯᏔᏬᏍᏔᏅ,{0} ᎢᏯᏔᏬᏍᏔᏅ ᎢᏳᏓᎵ,{0} ᎢᏯᏔᏬᏍᏔᏅ,{0} ᎢᏯᏔᏬᏍᏔᏅ
        month,ᎧᎸᎢ,{0}/Ꭷ,{0}Ꭷ,{0}Ꭷ,ᏗᎧᎸᎢ,{0}/Ꭷ,{0} ᎧᎸᎢ,{0} ᏗᎧᎸᎢ,ᏗᎧᎸᎢ,{0} ᎧᎸᎢ ᎢᏳᏓᎵ,{0} ᎧᎸᎢ,{0} ᏗᎧᎸᎢ
        nanosecond,ᎾᏃᏗᏎᏢ,,{0}ᎾᏃ,{0}ᎾᏃ,ᎾᏃᏗᏎᏢ,,{0} ᎾᏃ,{0} ᎾᏃ,ᎾᏃᏗᏎᏢ,,{0} ᎾᏃᎠᏎᏢ,{0} ᎾᏃᏗᏎᏢ
        night,ᏚᎵᏏᏂᏒ,{0}/ᎤᏒ,{0}ᎤᏒ,{0}ᏚᎵᏏᏂᏒ,ᏚᎵᏏᏂᏒ,{0}/ᎤᏒ,{0} ᎤᏒ,{0} ᏚᎵᏏᏂᏒ,ᏚᎵᏏᏂᏒ,{0}/ᎤᏒ,{0} ᎤᏒ,{0} ᏚᎵᏏᏂᏒ
        quarter,ᎯᎸᏍᎩ,{0}/Ꭿ,{0}Ꭿ,{0}Ꭿ,ᎯᎸᏍᎩ,{0}/Ꭿ,{0} ᎯᎸᏍᎩ,{0} ᎯᎸᏍᎩ,ᎯᎸᏍᎩ ᎩᏄᏘᏗ,{0}/Ꭿ,{0} ᎩᏄᏘᏗ,{0} ᎯᎸᏍᎩ ᎩᏄᏘᏗ
        second,ᎠᏎᏢ,{0}/ᎠᏎ,{0}ᎠᏎ,{0}ᎠᏎ,ᏓᏓᎾ,{0}/ᎠᏎ,{0} ᎠᏎᏢ,{0} ᎠᏎᏢ,ᏗᏎᏢ,{0} ᎠᏎᏢ ᎢᏳᏓᎵ,{0} ᎠᏎᏢ,{0} ᏗᏎᏢ
        week,ᏒᎾ,{0}/Ꮢ,{0}Ꮢ,{0}Ꮢ,ᎢᏳᎾᏙᏓᏆᏍᏗ,{0}/Ꮢ,{0} ᏒᎾ,{0} ᎢᏳᎾ,ᎢᏳᎾᏙᏓᏆᏍᏗ,{0} ᏒᎾᏙᏓᏆᏍᏗ ᎢᏳᏓᎵ,{0} ᏒᎾᏙᏓᏆᏍᏗ,{0} ᎢᏳᎾᏙᏓᏆᏍᏗ
        year,ᎤᏕ,{0}/Ꭴ,{0}Ꭴ,{0}Ꭴ,ᏧᏕᏘᏴᏌᏗᏒᎢ,{0}/Ꭴ,{0} ᎤᏕ,{0} ᏧᏕ,ᏧᏕᏘᏴᏌᏗᏒᎢ,{0} ᎤᏕᏘᏴᏌᏗᏒᎢ ᎢᏳᏓᎵ,{0} ᎤᏕᏘᏴᏌᏗᏒᎢ,{0} ᏧᏕᏘᏴᏌᏗᏒᎢ
        ampere,amp,,{0}A,{0}A,amps,,,{0} A,ᏗᎾᎦᎵᏍᎩ ᎠᏟᎶᏍᏗ,,{0} ᎠᎾᎦᎵᏍᎩ ᎠᏟᎶᏍᏗ,{0} ᏗᎾᎦᎵᏍᎩ ᎠᏟᎶᏍᏗ
        milliampere,mA,,{0}mA,{0}mA,milliamps,,,{0} mA,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᎾᎦᎵᏍᎩ ᎠᏟᎶᏍᏗ,,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎠᎾᎦᎵᏍᎩ ᎠᏟᎶᏍᏗ,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᎾᎦᎵᏍᎩ ᎠᏟᎶᏍᏗ
        ohm,ᎣᎻ,,{0}Ω,{0}Ω,ᏗᎣᎻ,,,{0} Ω,ᏗᎣᎻ,,{0} ᎣᎻ,{0} ᏗᎣᎻ
        volt,ᎠᎾᎦᎵᏍᎩ ᎢᏳᏟᏂᏚᏓ,,{0}V,{0}V,ᎠᎾᎦᎵᏍᎩ ᎢᏧᏟᏂᏚᏓ,,,{0} V,ᎠᎾᎦᎵᏍᎩ ᎢᏧᏟᏂᏚᏓ,,{0} ᎠᎾᎦᎵᏍᎩ ᎢᏳᏟᏂᎩᏓ,{0} ᎠᎾᎦᎵᏍᎩ ᎢᏧᏟᏂᏚᏓ
        british-thermal-unit,BTU,,{0}Btu,{0}Btu,BTU,,,{0} Btu,ᏈᏗᏏ ᏗᎬᏍᎦᏢᏗ ᏂᎨᏒᎾ ᏓᎪᎵᏰᎥ ᏭᏍᏗᎬ ᎧᎵᎨᏒ,,{0} ᏈᏗᏏ ᏗᎬᏍᎦᏢᏗ ᏂᎨᏒᎾ ᏓᎪᎵᏰᎥ ᏭᏍᏗᎬ ᎧᎵᎨᏒ,{0} ᏈᏗᏏ ᏗᎬᏍᎦᏢᏗ ᏂᎨᏒᎾ ᏓᎪᎵᏰᎥ ᏭᏍᏗᎬ ᎧᎵᎨᏒ
        calorie,cal,,{0}cal,{0}cal,,,,,ᏗᏓᎵᏥᏍᏗᏍᎩ,,{0} ᎠᏓᎵᏥᏍᏗᏍᎩ,{0} ᏗᏓᎵᏥᏍᏗᏍᎩ
        electronvolt,eV,,{0}eV,{0}eV,ᎡᎴᏆᎾᏉᏔ,,,{0} eV,ᎡᎴᏆᎾᏉᏔᏍ,,{0} ᎡᎴᏆᎾᏉᏔ,{0} ᎡᎴᏆᎾᏉᏔᏍ
        foodcalorie,Cal,,{0}Cal,{0}Cal,Cal,,{0} Cal,{0} Cal,ᏗᏓᎵᏥᏍᏗᏍᎩ,,{0} ᎠᏓᎵᏥᏍᏗᏍᎩ,{0} ᏗᏓᎵᏥᏍᏗᏍᎩ
        joule,ᏦᎤᎵ,,{0}J,{0}J,ᏗᏦᎤᎵ,,,{0} J,ᏗᏦᎤᎵ,,{0} ᏦᎤᎵ,{0} ᏗᏦᎤᎵ
        kilocalorie,kcal,,{0}kcal,{0}kcal,,,,,ᎠᎦᏴᎵ ᏗᏓᎵᏥᏍᏗᏍᎩ,,{0} ᎠᎦᏴᎵ ᎠᏓᎵᏥᏍᏗᏍᎩ,{0} ᎠᎦᏴᎵ ᏗᏓᎵᏥᏍᏗᏍᎩ
        kilojoule,kJ,,{0}kJ,{0}kJ,ᎠᎦᏴᎵ ᏦᎤᎵ,,,{0} kJ,ᎠᎦᏴᎵ ᏗᏦᎤᎵ,,{0} ᎠᎦᏴᎵ ᏦᎤᎵ,{0} ᎠᎦᏴᎵ ᏗᏦᎤᎵ
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,kW-ᎠᏟᎶᏓ,,,{0} kWh,ᎠᎦᏴᎵ-ᎢᏧᏟᎶᏓ,,ᎠᎦᏴᎵ ᎠᏟᎶᏓ,{0} ᎠᎦᏴᎵ-ᎢᏧᏟᎶᏓ
        therm-us,US ᎤᏗᏞᎬᎢ,,{0}US ᎤᏗᏞᎬ,{0}US ᎤᏗᏞᎬ,US ᎤᏗᏞᎬᎢ,,{0} US ᎤᏗᏞᎬ,{0} US ᎤᏗᏞᎬ,US ᎤᏗᏞᎬᎢ,,{0} US ᎤᏗᏞᎬᎢ,{0} US ᎤᏗᏞᎬᎢ
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0}kWh/100km,,,,,ᎠᎦᏴᎵᏩᏘ-ᏑᏟᎶᏓ ᎾᎿ 100 ᎠᎦᏴᎵᎢᏳᏟᎶᏓ,,{0} ᎠᎦᏴᎵᏩᏘ-ᏑᏟᎶᏓ ᎾᎿ 100 ᎠᎦᏴᎵᎢᏳᏟᎶᏓ,{0} ᎠᎦᏴᎵᏩᏘ-ᏑᏟᎶᏓ ᎾᎿ 100 ᎠᎦᏴᎵᎢᏳᏟᎶᏓ
        newton,N,,{0}N,{0}N,ᏄᏛᏅ,,,{0} N,ᏄᏛᏅᏍ,,{0} ᏄᏛᏅ,{0} ᏄᏛᏅᏍ
        pound-force,lbf,,{0}lbf,{0}lbf,ᏑᏓᎨᏓ-ᎦᏌᏙᏯᏍᏗ,,,{0} lbf,ᏑᏓᎨᏓ ᎾᎿ ᎦᏌᏙᏯᏍᏗ,,{0} ᏑᏓᎨᏓ ᎾᎿ ᎦᏌᏙᏯᏍᏗ,{0} ᏑᏓᎨᏓ ᎾᎿ ᎦᏌᏙᏯᏍᏗ
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,ᎩᎦᎭᏥ,,{0} ᎩᎦᎭᏥ,{0} ᎩᎦᎭᏥ
        hertz,Hz,,{0}Hz,{0}Hz,,,,,ᎭᏥ,,{0} ᎭᏥ,{0} ᎭᏥ
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,ᎠᎦᏴᎵᎭᏥ,,{0} ᎠᎦᏴᎵᎭᏥ,{0} ᎠᎦᏴᎵᎭᏥ
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,ᎺᎦᎭᏥ,,{0} ᎺᎦᎭᏥ,{0} ᎺᎦᎭᏥ
        dot-per-centimeter,dpcm,,{0}dpcm,{0}dpcm,dpcm,,{0} dpcm,{0} dpcm,ᏧᏓᏓᎸ ᎤᏍᏗ ᎠᏟᎶᏗ ᎢᏳᏓᎵ,,{0} ᎤᏓᏓᎸ ᎤᏍᏗ ᎠᏟᎶᏗ ᎢᏳᏓᎵ,{0} ᏧᏓᏓᎸ ᎤᏍᏗ ᎠᏟᎶᏗ ᎢᏳᏓᎵ
        dot-per-inch,dpi,,{0}dpi,{0}dpi,dpi,,{0} dpi,{0} dpi,ᏧᏓᏓᎸ ᎢᏏᎳᏗᏍᏗ ᎢᏳᏓᎵ,,{0} ᎤᏓᏓᎸ ᎢᏏᎳᏗᏍᏗ ᎢᏳᏓᎵ,{0} ᏧᏓᏓᎸ ᎢᏏᎳᏗᏍᏗ ᎢᏳᏓᎵ
        em,,,,,,,,,ᎪᏪᎸ em,,,{0} em
        megapixel,MP,,{0}MP,{0}MP,ᏧᏔᎾ ᏗᏇᎦᏎᎵ,,,{0} MP,ᏧᏔᎾ ᏗᏇᎦᏎᎵ,,{0} ᎤᏔᎾ ᏇᎦᏎᎵ,{0} ᏧᏔᎾ ᏗᏇᎦᏎᎵ
        pixel,px,,{0}px,{0}px,ᏗᏇᎦᏎᎵ,,,{0} px,ᏗᏇᎦᏎᎵ,,{0} ᏇᎦᏎᎵ,{0} ᏗᏇᎦᏎᎵ
        pixel-per-centimeter,ppcm,,{0}ppcm,{0}ppcm,,,,,ᏗᏇᎦᏎᎵ ᎤᏍᏗ ᎠᏟᎶᏗ ᎢᏳᏓᎵ,,{0} ᏇᎦᏎᎵ ᎤᏍᏗ ᎠᏟᎶᏗ ᎢᏳᏓᎵ,{0} ᏗᏇᎦᏎᎵ ᎤᏍᏗ ᎠᏟᎶᏗ ᎢᏳᏓᎵ
        pixel-per-inch,ppi,,{0}ppi,{0}ppi,,,,,ᏗᏇᎦᏎᎵ ᎢᏏᎳᏗᏍᏗ ᎢᏳᏓᎵ,,{0} ᏇᎦᏎᎵ ᎢᏏᎳᏗᏍᏗ ᎢᏳᏓᎵ,{0} ᏗᏇᎦᏎᎵ ᎢᏏᎳᏗᏍᏗ ᎢᏳᏓᎵ
        astronomical-unit,au,,{0}au,{0}au,,,,,ᎡᎶᎯ ᎠᎴ ᎤᏓ ᏭᏍᏗᎬ ᎧᎵ ᎨᏒᎢ,,{0} ᎡᎶᎯ ᎠᎴ ᎤᏓ ᏭᏍᏗᎬ ᎧᎵ ᎨᏒᎢ,{0} ᎡᎶᎯ ᎠᎴ ᎤᏓ ᏭᏍᏗᎬ ᎧᎵ ᎨᏒᎢ
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,ᏧᏍᏗ ᏗᏟᎶᏗ,{0} ᎤᏍᏗ ᎠᏟᎶᏗ ᎢᏳᏓᎵ,{0} ᎤᏍᏗ ᎠᏟᎶᏗ,{0} ᏧᏍᏗ ᏗᏟᎶᏗ
        decimeter,ᏌᏟ,,{0}ᏌᏟ,{0}ᏌᏟ,ᏌᏟ,,{0} ᏌᏟ,{0} ᏌᏟ,ᏌᏉ ᎢᏳᎾᏓᎢ ᏍᎪᎯ ᏗᏟᎶᏍᏗ,,{0} ᏌᏉ ᎢᏳᎾᏓᎢ ᏍᎪᎯ ᎠᏟᎶᏍᏗ,{0} ᏌᏉ ᎢᏳᎾᏓᎢ ᏍᎪᎯ ᏗᏟᎶᏍᏗ
        earth-radius,R⊕,,{0}R⊕,{0}R⊕,,,,,ᎡᎶᎯ ᏯᏗ,,{0} ᎡᎶᎯ ᏯᏗ,{0} ᎡᎶᎯ ᏯᏗ
        fathom,ᏑᏓᎵ ᎢᏗᎳᏏᏗ ᎠᏯᏱ,,{0}fth,{0}fth,ᏑᏓᎵ ᎢᏗᎳᏏᏗ ᎠᏯᏱ,,,{0} fth,ᏑᏓᎵ ᎢᏗᎳᏏᏗ ᎠᏯᏱ,,{0} ᏑᏓᎵ ᎢᏗᎳᏏᏗ ᎠᏯᏱ,{0} ᏑᏓᎵ ᎢᏗᎳᏏᏗ ᎠᏯᏱ
        foot,ft,{0}/ft,{0}′,{0}′,ᎢᏗᎳᏏᏗ,{0}/ft,,{0} ft,ᎢᏗᎳᏏᏗ,{0} ᎢᎳᏏᏗ ᎢᏳᏓᎵ,{0} ᎢᎳᏏᏗ,{0} ᎢᏗᎳᏏᏗ
        furlong,ᎠᏰᏟ ᎩᏄᏘᏗ ᏑᏟᎶᏓ,,{0}fur,{0}fur,ᎠᏰᏟ ᎩᏄᏘᏗ ᎢᏳᏟᎶᏓ,,,{0} fur,ᎠᏰᏟ ᎩᏄᏘᏗ ᎢᏳᏟᎶᏓ,,{0} ᎠᏰᏟ ᎩᏄᏘᏗ ᏑᏟᎶᏓ,{0} ᎠᏰᏟ ᎩᏄᏘᏗ ᎢᏳᏟᎶᏓ
        inch,in,{0}/in,{0}″,{0}″,ᎢᏗᏏᏔᏗᏍᏗ,{0}/in,,{0} in,ᎢᏗᏏᏔᏗᏍᏗ,{0} ᎢᏏᏔᏗᏍᏗ ᎢᏳᏓᎵ,{0} ᎢᏏᏔᏗᏍᏗ,{0} ᎢᏗᏏᏔᏗᏍᏗ
        kilometer,ᎠᏗ,{0}/ᎠᏗ,{0}ᎠᏗ,{0}ᎠᏗ,ᎠᏗ,{0}/ᎠᏗ,{0} ᎠᏗ,{0} ᎠᏗ,ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ,{0} ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ,{0} ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ,{0} ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ
        light-year,ly,,{0}ly,{0}ly,ᏗᏨᏍᏗ ᏧᏕᏘ,,,{0} ly,ᏗᏨᏍᏗ ᏧᏕᏘᏴᏌᏗᏒᎢ,,{0} ᎠᏨᏍᏗ ᎤᏕᏘᏴᏌᏗᏒᎢ,{0} ᏗᏨᏍᏗ ᏧᏕᏘᏴᏌᏗᏒᎢ
        meter,ᎠᏟ,{0}/ᎠᏟ,{0}ᎠᏟ,{0}ᎠᏟ,ᎠᏟ,{0}/ᎠᏟ,{0} ᎠᏟ,{0} ᎠᏟ,ᏗᏟᎶᏍᏗ,{0} ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ,{0} ᎠᏟᎶᏍᏗ,{0} ᏗᏟᎶᏍᏗ
        micrometer,μm,,{0}μm,{0}μm,,,,,ᏌᏉ ᎢᏳᏆᏗᏅᏛ ᏗᏟᎶᏍᏗ,,{0} ᏌᏉ ᎢᏳᏆᏗᏅᏛ ᎠᏟᎶᏍᏗ,{0} ᏌᏉ ᎢᏳᏆᏗᏅᏛ ᏗᏟᎶᏍᏗ
        mile,mi,,{0}mi,{0}mi,ᎢᏳᏟᎶᏓ,,,{0} mi,ᎢᏳᏟᎶᏓ,,{0} ᏑᏟᎶᏓ,{0} ᎢᏳᏟᎶᏓ
        mile-scandinavian,smi,,{0}smi,{0}smi,,,,,ᏑᏟᎶᏓ-ᏍᎦᎾᏗᎾᏫᎠᏂ,,{0} ᏑᏟᎶᏓ-ᏍᎦᎾᏗᎾᏫᎠᏂ,{0} ᎢᏳᏟᎶᏓ-ᏍᎦᎾᏗᎾᏫᎠᏂ
        millimeter,ᏌᎢᎠ,,{0}ᏌᎢᎠ,{0}ᏌᎢᎠ,ᏌᎢᎠ,,{0} ᏌᎢᎠ,{0} ᏌᎢᎠ,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏟᎶᏍᏗ,,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎠᏟᎶᏍᏗ,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏟᎶᏍᏗ
        nanometer,nm,,{0}nm,{0}nm,,,,,ᎾᏃ ᏗᏟᎶᏍᏗ,,{0} ᎾᏃ ᎠᏟᎶᏍᏗ,{0} ᎾᏃ ᏗᏟᎶᏍᏗ
        nautical-mile,nmi,,{0}nmi,{0}nmi,,,,,ᎠᎺᏉᎯ ᎢᏳᏟᎶᏓ,,{0} ᎠᎺᏉᎯ ᏑᏟᎶᏓ,{0} ᎠᎺᏉᎯ ᎢᏳᏟᎶᏓ
        parsec,ᎢᏯᏆᏎᎦ,,{0}pc,{0}pc,ᎢᏯᏆᏎᎦ,,,{0} pc,ᎢᏯᏆᏎᎦ,,{0} ᎢᏯᏆᏎᎦ,{0} ᎢᏯᏆᏎᎦ
        picometer,pm,,{0}pm,{0}pm,,,,,ᏇᎪ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏟᎶᏍᏗ,,{0} ᏇᎪ ᎢᏯᎦᎨᎵᏁᎢ ᎠᏟᎶᏍᏗ,{0} ᏇᎪ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏟᎶᏍᏗ
        point,pts,,{0}pt,{0}pt,ᏧᏓᏓᏟ,,,{0} pt,ᏧᏓᏓᏟ,,{0} ᎤᏓᏓᏟ,{0} ᏧᏓᏓᏟ
        solar-radius,R☉,,{0}R☉,{0}R☉,ᏅᏓ ᏇᏗ,,,{0} R☉,ᏅᏓ ᏇᏗ,,{0} ᏅᏓ ᏇᏗ,{0} ᏅᏓ ᏇᏗ
        yard,yd,,{0}yd,{0}yd,ᎢᏯᏯᏗ,,,{0} yd,ᎢᏯᏯᏗ,,{0} ᏯᏗ,{0} ᎢᏯᏯᏗ
        candela,cd,,{0}cd,{0}cd,,,,,ᎧᏂᏕᎳ,,{0} ᎧᏂᏕᎳ,{0} ᎧᏂᏕᎳ
        lumen,lm,,{0}lm,{0}lm,,,,,ᎷᎺᏂ,,{0} ᎷᎺᏂ,{0} ᎷᎺᏂ
        lux,ᎸᏏ,,{0}lx,{0}lx,ᎸᏏ,,{0} ᎸᏏ,{0} ᎸᏏ,ᎸᏏ,,{0} ᎸᏏ,{0} ᎸᏏ
        solar-luminosity,L☉,,{0}L☉,{0}L☉,ᏅᏓ ᏗᏨᏍᏗ,,,{0} L☉,ᏅᏓ ᏗᏨᏍᏗ,,{0} ᏅᏓ ᎠᏨᏍᏗ,{0} ᏅᏓ ᏗᏨᏍᏗ
        carat,ᎨᏇᏓ,,{0}CD,{0}CD,ᏗᎨᏇᏓ,,,{0} CD,ᏗᎨᏇᏓ,,{0} ᎨᏇᏓ,{0} ᏗᎨᏇᏓ
        dalton,Da,,{0}Da,{0}Da,ᏓᏙᎾᏍ,,,{0} Da,ᏓᏙᎾᏍ,,{0} ᏓᏙᎾᏍ,{0} ᏓᏙᎾᏍ
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,ᎡᎶᎯ ᎹᏏ,,,{0} M⊕,ᎡᎶᎯ ᎹᏏ,,{0} ᎡᎶᎯ ᎹᏏ,{0} ᎡᎶᎯ ᎹᏏ
        grain,gr,,{0}gr,{0}gr,ᎤᏛᏒ ᎤᎦᏔ,,{0} ᎤᏛᏒ ᎤᎦᏔ,{0} ᎤᏛᏒ ᎤᎦᏔ,ᎤᏛᏒ ᎤᎦᏔ,,{0} ᎤᏛᏒ ᎤᎦᏔ,{0} ᎤᏛᏒ ᎤᎦᏔ
        gram,ᎤᏍᏗ ᎤᏓᎨᏒ,{0}/g,{0}g,{0}g,ᎤᏍᏗ ᏂᏚᏓᎨᏒ,{0}/g,,{0} g,ᎤᏍᏗ ᏂᏚᏓᎨᏒ,{0} ᎤᏍᏗ ᎤᏓᎨᏒ ᎢᏳᏓᎵ,{0} ᎤᏍᏗ ᎤᏓᎨᏒ,{0} ᎤᏍᏗ ᏂᏚᏓᎨᏒ
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,ᎠᎦᏴᎵ ᎤᏍᏗ ᏂᏚᏓᎨᏒ,{0} ᎠᎦᏴᎵ ᎤᏍᏗ ᎤᏓᎨᏒ ᎢᏳᏓᎵ,{0} ᎠᎦᏴᎵ ᎤᏍᏗ ᎤᏓᎨᏒ,{0} ᎠᎦᏴᎵ ᎤᏍᏗ ᏂᏚᏓᎨᏒ
        microgram,μg,,{0}μg,{0}μg,,,,,ᏌᏉ ᎢᏳᏆᏗᏅᏛ ᎤᏍᏗ ᏂᏚᏓᎨᏒ,,{0} ᏌᏉ ᎢᏳᏆᏗᏅᏛ ᎤᏍᏗ ᎤᏓᎨᏒ,{0} ᏌᏉ ᎢᏳᏆᏗᏅᏛ ᎤᏍᏗ ᏂᏚᏓᎨᏒ
        milligram,mg,,{0}mg,{0}mg,,,,,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎤᏍᏗ ᏂᏚᏓᎨᏒ,,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎤᏍᏗ ᎤᏓᎨᏒ,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎤᏍᏗ ᏂᏚᏓᎨᏒ
        ounce,oz,{0}/oz,{0}oz,{0}oz,,,,,ᎢᏯᎣᏂᏏ,{0} ᎣᏂᏏ ᎢᏳᏓᎵ,{0} ᎣᏂᏏ,{0} ᎢᏯᎣᏂᏏ
        ounce-troy,oz t,,{0}oz t,{0}oz t,oz ᏆᏯ,,,{0} oz t,ᏆᏯ ᎢᏯᎣᏂᏏ,,{0} ᏆᏯ ᎣᏂᏏ,{0} ᏆᏯ ᎢᏯᎣᏂᏏ
        pound,lb,{0}/lb,{0}#,{0}#,ᎢᏧᏓᎨᏓ,{0}/lb,,{0} lb,ᎢᏧᏓᎨᏓ,{0} ᎢᏧᏓᎨᏓ ᎢᏳᏓᎵ,{0} ᏑᏓᎨᏓ,{0} ᎢᏧᏓᎨᏓ
        solar-mass,M☉,,{0}M☉,{0}M☉,ᏅᏓ ᎹᏏ,,,{0} M☉,ᏅᏓ ᎹᏏ,,{0} ᏅᏓ ᎹᏏ,{0} ᏅᏓ ᎹᏏ
        stone,ᏅᏯ,,{0}st,{0}st,ᎠᏂᏅᏯ,,,{0} st,ᎠᏂᏅᏯ,,{0} ᏅᏯ,{0} ᎠᏂᏅᏯ
        ton,ᏗᏈᏂ,,{0}tn,{0}tn,ᏗᏈᏂ,,,{0} tn,ᏗᏈᏂ,,{0} ᏈᏂ,{0} ᏗᏈᏂ
        tonne,t,,{0}t,{0}t,,,,,ᎠᏂᎩᎸᏥ ᏂᏓᏳᏓᎴᏅᎯ ᏗᏎᏍᏗ ᏗᏈᏂ,,{0} ᎠᏂᎩᎸᏥ ᏂᏓᏳᏓᎴᏅᎯ ᏗᏎᏍᏗ ᏈᏂ,{0} ᎠᏂᎩᎸᏥ ᏂᏓᏳᏓᎴᏅᎯ ᏗᏎᏍᏗ ᏗᏈᏂ
        gigawatt,GW,,{0}GW,{0}GW,,,,,ᎩᎦᏩᏗ,,{0} ᎩᎦᏩᏗ,{0} ᎩᎦᏩᏗ
        horsepower,hp,,{0}hp,{0}hp,,,,,ᏐᏈᎵ ᎢᏳᎳᏂᎩᏛ,,{0} ᏐᏈᎵ ᎢᏳᎳᏂᎩᏛ,{0} ᏐᏈᎵ ᎢᏳᎳᏂᎩᏛ
        kilowatt,kW,,{0}kW,{0}kW,,,,,ᎠᎦᏴᎵ ᏗᏩᏗ,,{0} ᎠᎦᏴᎵ ᏩᏗ,{0} ᎠᎦᏴᎵ ᏗᏩᏗ
        megawatt,MW,,{0}MW,{0}MW,,,,,ᎺᎦ ᏗᏩᏗ,,{0} ᎺᎦ ᏩᏗ,{0} ᎺᎦ ᏗᏩᏗ
        milliwatt,mW,,{0}mW,{0}mW,,,,,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏩᏗ,,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏩᏗ,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏩᏗ
        watt,ᏩᏗ,,{0}W,{0}W,ᏗᏩᏗ,,,{0} W,ᏗᏩᏗ,,{0} ᏗᏩᏗ,{0} ᏗᏩᏗ
        atmosphere,atm,,{0}atm,{0}atm,,,,,ᏗᎦᏃᎴᏍᎬ,,{0} ᎦᏃᎴᏍᎬ,{0} ᏗᎦᏃᎴᏍᎬ
        bar,ᎦᎾᎸᎢ,,{0}ᎦᎾᎸᎢ,{0}ᎦᎾᎸᎢ,ᎦᎾᎸᎢ,,{0} ᎦᎾᎸᎢ,{0} ᎦᎾᎸᎢ,ᏕᎦᎾᎸᎢ,,{0} ᎦᎾᎸᎢ,{0} ᏕᎦᎾᎸᎢ
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,ᎮᏔ ᏗᏆᏌᎵ,,{0} ᎮᏔ ᏆᏌᎵ,{0} ᎮᏔ ᏗᏆᏌᎵ
        inch-ofhg,″ Hg,,{0}″ Hg,{0}″ Hg,,,,,ᎢᏏᏔᏗᏍᏗ ᎾᎿ ᎹᎫᎢ,,{0} ᎢᏗᎳᏏᏗ ᎾᎿ ᎹᎫᎢ,{0} ᎢᏏᏔᏗᏍᏗ ᎾᎿ ᎹᎫᎢ
        kilopascal,kPa,,{0}kPa,{0}kPa,,,,,ᎩᎶᏆᏍᎧᎵᏍ,,{0} ᎩᎶᏆᏍᎧᎵᏍ,{0} ᎩᎶᏆᏍᎧᎵᏍ
        megapascal,MPa,,{0}MPa,{0}MPa,,,,,ᎺᎦᏆᏍᎧᎵᏍ,,{0} ᎺᎦᏆᏍᎧᎵᏍ,{0} ᎺᎦᏆᏍᎧᎵᏍ
        millibar,mbar,,{0}mb,{0}mb,,,,,ᎢᏯᎦᏴᎵ ᏕᎦᎾᎸᎢ,,{0} ᎢᎦᎦᏴᎵ ᎦᎾᎸᎢ,{0} ᎢᏯᎦᏴᎵ ᏕᎦᎾᎸᎢ
        millimeter-ofhg,mmHg,,{0}mmHg,{0}mmHg,mmHg,,{0} mmHg,{0} mmHg,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏟᎶᏗ ᎾᎿ ᎹᎫᎢ,,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎠᏟᎶᏗ ᎾᎿ ᎹᎫᎢ,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᏟᎶᏗ ᎾᎿ ᎹᎫᎢ
        pascal,Pa,,{0}Pa,{0}Pa,,,,,ᏗᏆᏌᎵ,,{0} ᏆᏌᎵ,{0} ᏗᏆᏌᎵ
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,,,,,ᎢᏧᏓᎨᏓ ᏅᎩ ᏧᏅᏏᎩ ᎢᏏᏔᏗᏍᏗ ᎢᏳᏓᎵ,,{0} ᏑᏓᎨᏓ ᏅᎩ ᏧᏅᏏᎩ ᎢᏏᏔᏗᏍᏗ ᎢᏳᏓᎵ,{0} ᎢᏧᏓᎨᏓ ᏅᎩ ᏧᏅᏏᎩ ᎢᏏᏔᏗᏍᏗ ᎢᏳᏓᎵ
        beaufort,Bft,,B{0},B{0},,,,,ᏉᏙᎢ,,ᏉᏙᎢ {0},ᏉᏙᎢ {0}
        kilometer-per-hour,km/hr,,{0}km/h,{0}km/h,km/ᏑᏟᎶᏓ,,,{0} km/h,ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ ᏑᏟᎶᏓ ᎢᏳᏓᎵ,,{0} ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ ᏑᏟᎶᏓ ᎢᏳᏓᎵ,{0} ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ ᏑᏟᎶᏓ ᎢᏳᏓᎵ
        knot,kn,,{0}kn,{0}kn,,,,,ᏓᎧᏁᎲ,,{0} ᎠᎧᏁᎲ,{0} ᏓᎧᏁᎲ
        light-speed,ᎠᏨᏍᏗ,,{0}ᎠᏨᏍᏗ,{0}ᎠᏨᏍᏗ,ᎠᏨᏍᏗ,,{0} ᎠᏨᏍᏗ,{0} ᎠᏨᏍᏗ,ᎠᏨᏍᏗ,,{0} ᎠᏨᏍᏗ,{0} ᎠᏨᏍᏗ
        meter-per-second,m/s,,{0}m/s,{0}m/s,ᏗᏟᎶᏗ/ᎠᏎ,,,{0} m/s,ᏗᏟᎶᏗ ᎠᏎᏢ ᎢᏳᏓᎵ,,{0} ᎠᏟᎶᏗ ᎠᏎᏢ ᎢᏳᏓᎵ,{0} ᏗᏟᎶᏗ ᎠᏎᏢ ᎢᏳᏓᎵ
        mile-per-hour,mi/hr,,{0}mph,{0}mph,ᎢᏧᏟᎶᏓ/ᏑᏟᎶᏛ,,{0} mph,{0} mph,ᎢᏧᏟᎶᏓ ᏑᏟᎶᏛ ᎢᏳᏓᎵ,,{0} ᏑᏟᎶᏓ ᏑᏟᎶᏛ ᎢᏳᏓᎵ,{0} ᎢᏧᏟᎶᏓ ᏑᏟᎶᏛ ᎢᏳᏓᎵ
        celsius,,,,,deg. C,,,{0}°C,ᎢᎦᎢ ᎢᏗᎦᏘ ᎠᏤ ᎠᏟᎶᏍᏙᏗ,,{0} ᎢᎦᎢ ᎢᎦ ᎠᏤ ᎠᏟᎶᏍᏙᏗ,{0} ᎢᎦᎢ ᎢᏗᎦᏘ ᎠᏤ ᎠᏟᎶᏍᏙᏗ
        fahrenheit,°F,,{0}°,{0}°,deg. F,,,{0}°F,ᎢᎦᎢ ᎢᏗᎦᏘ ᏅᎦᏃᏋ ᎠᎴ ᏅᏴᏢ ᎠᏟᎶᏍᏙᏗ,,ᎢᎦᎢ ᎢᎦ ᏅᎦᏃᏋ ᎠᎴ ᏅᏴᏢ ᎠᏟᎶᏍᏙᏗ,{0} ᎢᎦᎢ ᎢᏗᎦᏘ ᏅᎦᏃᏋ ᎠᎴ ᏅᏴᏢ ᎠᏟᎶᏍᏙᏗ
        kelvin,K,,{0}K,{0}K,,,,,ᎢᏗᎨᎸᏂ,,{0} ᎨᎸᏂ,{0} ᎢᏗᎨᎸᏂ
        newton-meter,N⋅m,,{0}N⋅m,{0}N⋅m,,,,,ᏄᏛᏅ-ᎠᏟᎶᏍᏗ,,{0} ᏄᏛᏅ-ᎠᏟᎶᏍᏗ,{0} ᏄᏛᏅ-ᎠᏟᎶᏍᏗ
        pound-force-foot,lbf⋅ft,,{0}lbf⋅ft,{0}lbf⋅ft,,,,,ᏑᏓᎨᏓ-ᏧᎳᏏᏕᏂ,,{0} ᏑᏓᎨᏓ-ᎤᎳᏏᏕᏂ,{0} ᏑᏓᎨᏓ-ᏧᎳᏏᏕᏂ
        acre-foot,ᏑᏟᎶᏛ-ᎢᏗᎳᏏᏗ,,{0}ac ft,{0}ac ft,ᏑᏟᎶᏛ-ᎢᏗᎳᏏᏗ,,,{0} ac ft,ᏑᏟᎶᏛ-ᎢᏗᎳᏏᏗ,,{0} ᏑᏟᎶᏛ-ᎢᎳᏏᏗ,{0} ᏑᏟᎶᏛ-ᎢᏗᎳᏏᏗ
        barrel,bbl,,{0}bbl,{0}bbl,ᏒᏙᏂ,,,{0} bbl,ᏧᏒᏙᏂ,,{0} ᏒᏙᏂ,{0} ᏧᏒᏙᏂ
        bushel,ᎤᎧᏲᏗ ᏑᏟᎶᏓ,,{0}bu,{0}bu,ᎤᎧᏲᏗ ᏑᏟᎶᏓ,,,{0} bu,ᎤᎧᏲᏗ ᏑᏟᎶᏓ,,{0} ᎤᎧᏲᏗ ᏑᏟᎶᏓ,{0} ᎤᎧᏲᏗ ᏑᏟᎶᏓ
        centiliter,cL,,{0}cL,{0}cL,,,,,ᏧᎤᏍᏗ ᏗᎵᏔᎢ,,{0} ᎤᏍᏗ ᎵᏔᎢ,{0} ᏧᎤᏍᏗ ᏗᎵᏔᎢ
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,ᏅᎩ ᏧᏅᏏᏯ ᏧᏍᏗ ᏗᏟᎶᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏯ ᎤᏍᏗ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ,{0} ᏅᎩ ᏧᏅᏏᏯ ᎤᏍᏗ ᎠᏟᎶᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏯ ᏧᏍᏗ ᏗᏟᎶᏍᏗ
        cubic-foot,ft³,,{0}ft³,{0}ft³,ᎢᏗᎳᏏᏗ³,,,{0} ft³,ᏅᎩ ᏧᏅᏏᏯ ᎢᏗᎳᏏᏗ,,{0} ᏅᎩ ᏧᏅᏏᏯ ᎢᎳᏏᏗ,{0} ᏅᎩ ᏧᏅᏏᏯ ᎢᏗᎳᏏᏗ
        cubic-inch,in³,,{0}in³,{0}in³,ᎢᏗᏏᏔᏗᏍᏗ³,,,{0} in³,ᏅᎩ ᏧᏅᏏᏯ ᎢᏗᏏᏔᏗᏍᏗ,,{0} ᏅᎩ ᏧᏅᏏᏯ ᎢᏏᏔᏗᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏯ ᎢᏗᏏᏔᏗᏍᏗ
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,ᏅᎩ ᏧᏅᏏᏯ ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ,,{0} ᏅᎩ ᏧᏅᏏᏯ ᎠᎦᏴᎵ ᎠᏟᎶᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏯ ᎠᎦᏴᎵ ᏗᏟᎶᏍᏗ
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,ᏅᎩ ᏧᏅᏏᏯ ᏗᏟᎶᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏯ ᎠᏟᎶᏍᏗ ᎢᏳᏓᎵ,{0} ᏅᎩ ᏧᏅᏏᏯ ᎠᏟᎶᏍᏗ,{0} ᏅᎩ ᏧᏅᏏᏯ ᏗᏟᎶᏍᏗ
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,ᏅᎩ ᏧᏅᏏᏯ ᎢᏳᏟᎶᏓ,,{0} ᏅᎩ ᏧᏅᏏᏯ ᏑᏟᎶᏓ,{0} ᏅᎩ ᏧᏅᏏᏯ ᎤᏍᏗ ᎢᏳᏟᎶᏓ
        cubic-yard,yd³,,{0}yd³,{0}yd³,ᎢᏯᏯᏗ³,,,{0} yd³,ᏅᎩ ᏧᏅᏏᏯ ᎢᏯᏯᏗ,,{0} ᏅᎩ ᏧᏅᏏᏯ ᏯᏗ,{0} ᏅᎩ ᏧᏅᏏᏯ ᎢᏯᏯᏗ
        cup,ᏧᎵᏍᏈᏗ,,{0}c,{0}c,ᏧᎵᏍᏈᏗ,,,{0} c,ᏧᎵᏍᏈᏗ,,{0} ᎤᎵᏍᏈᏗ,{0} ᏧᎵᏍᏈᏗ
        cup-metric,mcup,,{0}mc,{0}mc,,,,,ᎠᏂᎩᎸᏥ ᏂᏓᏳᏓᎴᏅᎯ ᏗᏎᏍᏗ ᏧᎵᏍᏈᏗ,,{0} ᎠᏂᎩᎸᏥ ᏂᏓᏳᏓᎴᏅᎯ ᏗᏎᏍᏗ ᎤᎵᏍᏈᏗ,{0} ᎠᏂᎩᎸᏥ ᏂᏓᏳᏓᎴᏅᎯ ᏗᏎᏍᏗ ᏧᎵᏍᏈᏗ
        deciliter,dL,,{0}dL,{0}dL,,,,,ᏌᏉ ᎢᏳᎾᏓᎢ ᏍᎪᎯ ᎢᏧᏆᏗᏅᏛ,,{0} ᏌᏉ ᎢᏳᎾᏓᎢ ᏍᎪᎯ ᎢᏳᏆᏗᏅᏛ,{0} ᏌᏉ ᎢᏳᎾᏓᎢ ᏍᎪᎯ ᎢᏧᏆᏗᏅᏛ
        dessert-spoon,dsp,,{0}dsp,{0}dsp,,,,,ᎤᎦᎾᏍᏓ ᎠᏗᏙᏗ,,{0} ᎤᎦᎾᏍᏓ ᎠᏗᏙᏗ,{0} ᎤᎦᎾᏍᏓ ᎠᏗᏙᏗ
        dessert-spoon-imperial,dsp Imp,,{0}dsp-Imp,{0}dsp-Imp,,,,,ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎤᎦᎾᏍᏓ ᎠᏗᏙᏗ,,{0} ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎤᎦᎾᏍᏓ ᎠᏗᏙᏗ,{0} ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎤᎦᎾᏍᏓ ᎠᏗᏙᏗ
        dram,fl.dr.,,{0}fl.dr.,{0}fl.dr.,ᏜᎹ ᎠᎹ,,{0} ᏜᎹ ᎠᎹ,{0} ᏜᎹ ᎠᎹ,ᏜᎹ,,{0} ᏜᎹ,{0} ᏜᎹ
        drop,dr,,{0}dr,{0}dr,ᎪᎭᏍᎬ,,{0} ᎪᎭᏍᎬ,{0} ᎪᎭᏍᎬ,ᎪᎭᏍᎬ,,{0} ᎪᎭᏍᎬ,{0} ᎪᎭᏍᎬ
        fluid-ounce,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,ᎤᏓᏁᎯ ᎢᏯᎣᏂᏏ,,{0} ᎤᏓᏁᎯ ᎣᏂᏏ,{0} ᎤᏓᏁᎯ ᎢᏯᎣᏂᏏ
        fluid-ounce-imperial,Imp fl oz,,{0}fl oz Im,{0}fl oz Im,,,,,Imp. ᎤᏓᏁᎯ ᎢᏯᎣᏂᏏ,,{0} Imp. ᎤᏓᏁᎯ ᎣᏂᏏ,{0} Imp. ᎤᏓᏁᎯ ᎢᏯᎣᏂᏏ
        gallon,gal,{0}/gal,{0}gal,{0}gal,ᎢᏧᎵᎶᏓ,{0}/gal US,{0} gal,{0} gal,ᎢᏧᎵᎶᏓ,{0} ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ,{0} ᎢᏳᎵᎶᏓ,{0} ᎢᏧᎵᎶᏓ
        gallon-imperial,Imp gal,{0}/galIm,{0}galIm,{0}galIm,ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ,{0}/gal Imp.,,{0} gal Imp.,ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎢᏧᎵᎶᏓ,{0} ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎢᏳᎵᎶᏓ ᎢᏳᏓᎵ,{0} ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎢᏳᎵᎶᏓ,{0} ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎢᏧᎵᎶᏓ
        hectoliter,hL,,{0}hL,{0}hL,,,,,ᎮᏙ ᎢᏧᏆᏗᏅᏛ,,{0} ᎮᏙ ᎢᏳᏆᏗᏅᏛ,{0} ᎮᏙ ᎢᏧᏆᏗᏅᏛ
        jigger,ᏥᎩᎳ,,{0}ᏥᎩᎳ,{0}ᏥᎩᎳ,ᏥᎩᎳ,,{0} ᏥᎩᎳ,{0} ᏥᎩᎳ,ᏥᎩᎳ,,{0} ᏥᎩᎳ,{0} ᏥᎩᎳ
        liter,ᎢᏳᏆᏗᏅᏛ,{0}/L,{0}L,{0}L,ᎢᏧᏆᏗᏅᏛ,{0}/l,{0} L,{0} L,ᎢᏧᏆᏗᏅᏛ,{0} ᎢᏳᏆᏗᏅᏛ ᎢᏳᏓᎵ,{0} ᎢᏳᏆᏗᏅᏛ,{0} ᎢᏧᏆᏗᏅᏛ
        megaliter,ML,,{0}ML,{0}ML,,,,,ᎺᎦ ᎢᏧᏆᏗᏅᏛ,,{0} ᎺᎦ ᎢᏳᏆᏗᏅᏛ,{0} ᎺᎦ ᎢᏧᏆᏗᏅᏛ
        milliliter,mL,,{0}mL,{0}mL,,,,,ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᎵᏔᎵ,,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᎵᏔᎢ,{0} ᏌᏉ ᎢᏯᎦᎨᎵᏁᎢ ᏗᎵᏔᎵ
        pinch,pn,,{0}pn,{0}pn,ᏗᏓᏇᏄᎩᏍᏗ,,{0} ᏗᏓᏇᏄᎩᏍᏗ,{0} ᏗᏓᏇᏄᎩᏍᏗ,ᏗᏓᏇᏄᎩᏍᏗ,,{0} ᏗᏓᏇᏄᎩᏍᏗ,{0} ᏗᏓᏇᏄᎩᏍᏗ
        pint,pt,,{0}pt,{0}pt,ᏔᎵ ᏧᎵᏍᏈᏗ ᎠᎧᎵ,,,{0} pt,ᏔᎵ ᏧᎵᏍᏈᏗ ᎠᎧᎵ,,{0} ᏔᎵ ᎤᎵᏍᏈᏗ ᎠᎧᎵ,{0} ᏔᎵ ᏧᎵᏍᏈᏗ ᎠᎧᎵ
        pint-metric,mpt,,{0}mp,{0}mp,,,,,ᎠᏂᎩᎸᏥ ᏂᏓᏳᏓᎴᏅᎯ ᏗᏎᏍᏗ ᏔᎵ ᏧᎵᏍᏈᏗ ᎠᎧᎵ,,{0} ᎠᏂᎩᎸᏥ ᏂᏓᏳᏓᎴᏅᎯ ᏗᏎᏍᏗ ᏔᎵ ᎤᎵᏍᏈᏗ ᎠᎧᎵ,{0} ᎠᏂᎩᎸᏥ ᏂᏓᏳᏓᎴᏅᎯ ᏗᏎᏍᏗ ᏔᎵ ᏧᎵᏍᏈᏗ ᎠᎧᎵ
        quart,qt,,{0}qt,{0}qt,qts,,,{0} qt,ᏅᎩ ᎢᏗᎧᎵᎢ,,{0} ᏅᎩ ᎢᏯᎧᎵᎢ,{0} ᏅᎩ ᎢᏗᎧᎵᎢ
        quart-imperial,qt Imp,,{0}qt-Imp.,{0}qt-Imp.,,,,,ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᏅᎩ ᎢᏗᎧᎵᎢ,,{0} ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᏅᎩ ᎢᏗᎧᎵᎢ,{0} ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᏅᎩ ᎢᏗᎧᎵᎢ
        tablespoon,tbsp,,{0}tbsp,{0}tbsp,,,,,ᎤᏔᏂ ᏗᏗᏙᏗ,,{0} ᎤᏔᏂ ᎠᏗᏙᏗ,{0} ᎤᏔᏂ ᏗᏗᏙᏗ
        teaspoon,tsp,,{0}tsp,{0}tsp,,,,,ᎤᏍᏗ ᏗᏗᏙᏗ,,{0} ᎤᏍᏗ ᎠᏗᏙᏗ,{0} ᎤᏍᏗ ᏗᏗᏙᏗ
        """.trimIndent()
  }

  private val chr_Prefixes: String by lazy {
    """square,,,ᏅᎩ ᏧᏅᏏᏱ {0}
        cubic,,,ᏣᏁᎳ ᏧᏅᏏᏱ {0}
        times,,,{0}-{1}
        per,,,{0} ᎾᎿ {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobi{0}
        10p-1,,,deci{0}
        10p-12,,,pico{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,milli{0}
        10p-30,,,quecto{0}
        10p-6,,,micro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hecto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val cic_Units: String by lazy {
    """day,,,,,,,,,day,{0}/d,,{0} Nittak
        hour,,,,,,,,,hr,{0}/h,,Hashiʼ kanalli chaffaʼ {0}
        minute,,,,,,,,,min,{0}/min,,Hashiʼ kanallloshiʼ {0}
        month,,,,,,,,,mon,{0}/m,,Hashiʼ alhpisaʼ {0}
        week,,,,,,,,,wk,{0}/w,,Nittak hollo ittataklaʼ {0}
        year,,,,,,,,,yr,{0}/y,,Afammi {0}
        """.trimIndent()
  }

  private val cic_Prefixes: String? = null

  private val ckb_Units: String? = null

  private val ckb_Prefixes: String? = null

  private val ckb_IR_Units: String? = null

  private val ckb_IR_Prefixes: String? = null

  private val co_Units: String? = null

  private val co_Prefixes: String? = null

  private val cs_Units: String by lazy {
    """g-force,G,,,{0} G,G,,,{0} G,gravitační síla,,{0} gravitační síla,{0} gravitačních sil
        meter-per-square-second,,,,,,,,,metry za sekundu na druhou,,{0} metr za sekundu na druhou,{0} metrů za sekundu na druhou
        arc-minute,′,,,{0}′,′,,,{0}′,minuty,,{0} minuta,{0} minut
        arc-second,″,,,{0}″,″,,,{0}″,vteřiny,,{0} vteřina,{0} vteřin
        degree,°,,,{0}°,°,,,{0}°,stupně,,{0} stupeň,{0} stupňů
        radian,,,,,,,,,radiány,,{0} radián,{0} radiánů
        revolution,ot.,,{0} ot.,{0} ot.,ot.,,{0} ot.,{0} ot.,otáčky,,{0} otáčka,{0} otáček
        acre,ac,,,{0} ac,ac,,,{0} ac,akry,,{0} akr,{0} akrů
        dunam,dun.,,{0} dun.,{0} dun.,dun.,,{0} dun.,{0} dun.,dunamy,,{0} dunam,{0} dunamů
        hectare,ha,,,{0} ha,ha,,,{0} ha,hektary,,{0} hektar,{0} hektarů
        square-centimeter,,,,,,,,,centimetry čtvereční,{0} na centimetr čtvereční,{0} centimetr čtvereční,{0} centimetrů čtverečních
        square-foot,,,,,,,,,stopy čtvereční,,{0} stopa čtvereční,{0} stop čtverečních
        square-inch,,,,,,,,,palce čtvereční,{0} na palec čtvereční,{0} palec čtvereční,{0} palců čtverečních
        square-kilometer,,,,,,,,,kilometry čtvereční,{0} na kilometr čtvereční,{0} kilometr čtvereční,{0} kilometrů čtverečních
        square-meter,,,,,,,,,metry čtvereční,{0} na metr čtvereční,{0} metr čtvereční,{0} metrů čtverečních
        square-mile,,,,,,,,,míle čtvereční,{0} na míli čtvereční,{0} míle čtvereční,{0} mil čtverečních
        square-yard,,,,,,,,,yardy čtvereční,,{0} yard čtvereční,{0} yardů čtverečních
        item,pol.,,{0} pol.,{0} pol.,položky,,{0} položka,{0} položek,položky,,{0} položka,{0} položek
        karat,,,,,,,,,karáty,,{0} karát,{0} karátů
        milligram-ofglucose-per-deciliter,mg/dl,,{0} mg/dl,{0} mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,miligramy na decilitr,,{0} miligram na decilitr,{0} miligramů na decilitr
        millimole-per-liter,mmol/l,,{0} mmol/l,{0} mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,milimoly na litr,,{0} milimol na litr,{0} milimolů na litr
        mole,,,,,,,,,moly,,{0} mol,{0} molů
        percent,%,,{0} %,{0} %,%,,{0} %,{0} %,procenta,,{0} procento,{0} procent
        permille,‰,,{0} ‰,{0} ‰,‰,,{0} ‰,{0} ‰,promile,,{0} promile,{0} promile
        permillion,,,,,,,,,díly z milionu,,{0} díl z milionu,{0} dílů z milionu
        permyriad,‱,,{0} ‱,{0} ‱,‱,,{0} ‱,{0} ‱,desetiny promile,,{0} desetina promile,{0} desetin promile
        portion-per-1e9,částic/mld.,,{0} částice na mld,{0} částic na mld,částic/mld.,,{0} částice na mld,{0} částic na mld,částice na miliardu,,{0} částice na miliardu,{0} částic na miliardu
        liter-per-100-kilometer,l/100km,,{0} l/100km,{0} l/100km,l/100 km,,{0} l/100 km,{0} l/100 km,litry na sto kilometrů,,{0} litr na sto kilometrů,{0} litrů na sto kilometrů
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,litry na kilometr,,{0} litr na kilometr,{0} litrů na kilometr
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg,míle na galon,,{0} míle na galon,{0} mil na galon
        mile-per-gallon-imperial,mpgIm,,{0} mpgIm,{0} mpgIm,,,,,míle na britský galon,,{0} míle na britský galon,{0} mil na britský galon
        bit,b,,{0} b,{0} b,b,,{0} b,{0} b,bity,,{0} bit,{0} bitů
        byte,B,,{0} B,{0} B,B,,{0} B,{0} B,bajty,,{0} bajt,{0} bajtů
        gigabit,,,,,,,,,gigabity,,{0} gigabit,{0} gigabitů
        gigabyte,,,,,,,,,gigabajty,,{0} gigabajt,{0} gigabajtů
        kilobit,,,,,,,,,kilobity,,{0} kilobit,{0} kilobitů
        kilobyte,,,,,,,,,kilobajty,,{0} kilobajt,{0} kilobajtů
        megabit,,,,,,,,,megabity,,{0} megabit,{0} megabitů
        megabyte,,,,,,,,,megabajty,,{0} megabajt,{0} megabajtů
        petabyte,,,,,,,,,petabajty,,{0} petabajt,{0} petabajtů
        terabit,,,,,,,,,terabity,,{0} terabit,{0} terabitů
        terabyte,,,,,,,,,terabajty,,{0} terabajt,{0} terabajtů
        century,stol.,,{0} stol.,{0} stol.,stol.,,{0} stol.,{0} stol.,století,,{0} století,{0} století
        day,d.,{0}/d.,{0} d.,{0} d.,dny,{0}/den,{0} den,{0} dnů,dny,{0} za den,{0} den,{0} dnů
        decade,dek.,,{0} dek.,{0} dek.,desetil.,,{0} desetil.,{0} desetil.,desetiletí,,{0} desetiletí,{0} desetiletí
        hour,h,{0}/h,,{0} h,h,{0}/h,,{0} h,hodiny,{0} za hodinu,{0} hodina,{0} hodin
        microsecond,,,,,,,,,mikrosekundy,,{0} mikrosekunda,{0} mikrosekund
        millisecond,,,,,,,,,milisekundy,,{0} milisekunda,{0} milisekund
        minute,m,{0}/m,{0} m,{0} m,,,,,minuty,{0} za minutu,{0} minuta,{0} minut
        month,m.,{0}/m.,{0} m.,{0} m.,měs.,{0}/měs.,{0} měs.,{0} měs.,měsíce,{0} za měsíc,{0} měsíc,{0} měsíců
        nanosecond,,,,,,,,,nanosekundy,,{0} nanosekunda,{0} nanosekund
        night,noci,{0}/noc,{0} noc,{0} nocí,noci,{0}/noc,{0} noc,{0} nocí,noci,{0} za noc,{0} noc,{0} nocí
        quarter,kv.,{0}/kv.,{0} kv.,{0} kv.,čtvrtl.,{0}/čtvrtl.,{0} čtvrtl.,{0} čtvrtl.,čtvrtletí,{0} za čtvrtletí,{0} čtvrtletí,{0} čtvrtletí
        second,s,{0}/s,,{0} s,s,{0}/s,,{0} s,sekundy,{0} za sekundu,{0} sekunda,{0} sekund
        week,t.,{0}/t.,{0} t.,{0} t.,týd.,{0}/týd.,{0} týd.,{0} týd.,týdny,{0} za týden,{0} týden,{0} týdnů
        year,r.,{0}/r.,{0} r.,{0} l.,roky,{0}/rok,{0} rok,{0} let,roky,{0} za rok,{0} rok,{0} let
        ampere,A,,,{0} A,A,,,{0} A,ampéry,,{0} ampér,{0} ampérů
        milliampere,,,,,,,,,miliampéry,,{0} miliampér,{0} miliampérů
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,ohmy,,{0} ohm,{0} ohmů
        volt,V,,,{0} V,V,,,{0} V,volty,,{0} volt,{0} voltů
        british-thermal-unit,BTU,,{0} BTU,{0} BTU,BTU,,{0} BTU,{0} BTU,britské tepelné jednotky,,{0} britská tepelná jednotka,{0} britských tepelných jednotek
        calorie,,,,,,,,,kalorie,,{0} kalorie,{0} kalorií
        electronvolt,,,,,,,,,elektronvolty,,{0} elektronvolt,{0} elektronvoltů
        foodcalorie,,,,,,,,,kilokalorie,,{0} kilokalorie,{0} kilokalorií
        joule,J,,,{0} J,J,,,{0} J,jouly,,{0} joule,{0} joulů
        kilocalorie,,,,,,,,,kilokalorie,,{0} kilokalorie,{0} kilokalorií
        kilojoule,,,,,,,,,kilojouly,,{0} kilojoule,{0} kilojoulů
        kilowatt-hour,,,,,,,,,kilowatthodiny,,{0} kilowatthodina,{0} kilowatthodin
        therm-us,therm,,{0} therm,{0} therm,therm,,{0} therm,{0} therm,thermy,,{0} therm,{0} thermů
        kilowatt-hour-per-100-kilometer,,,,,,,,,kilowatthodiny na sto kilometrů,,{0} kilowatthodina na sto kilometrů,{0} kilowatthodin na sto kilometrů
        newton,,,,,,,,,newtony,,{0} newton,{0} newtonů
        pound-force,,,,,,,,,libry síly,,{0} libra síly,{0} liber síly
        gigahertz,,,,,,,,,gigahertzy,,{0} gigahertz,{0} gigahertzů
        hertz,,,,,,,,,hertzy,,{0} hertz,{0} hertzů
        kilohertz,,,,,,,,,kilohertzy,,{0} kilohertz,{0} kilohertzů
        megahertz,,,,,,,,,megahertzy,,{0} megahertz,{0} megahertzů
        dot,bod,,,,pixely,,,,obrazové body,,{0} obrazový bod,{0} obrazových bodů
        dot-per-centimeter,DPCM,,{0} DPCM,{0} DPCM,DPCM,,{0} DPCM,{0} DPCM,body na centimetr,,{0} bod na centimetr,{0} bodů na centimetr
        dot-per-inch,DPI,,{0} DPI,{0} DPI,DPI,,{0} DPI,{0} DPI,body na palec,,{0} bod na palec,{0} bodů na palec
        em,,,,,,,,,čtverčíky,,{0} čtverčík,{0} čtverčíků
        megapixel,Mpx,,{0} Mpx,{0} Mpx,Mpx,,{0} Mpx,{0} Mpx,megapixely,,{0} megapixel,{0} megapixelů
        pixel,,,,,,,,,pixely,,{0} pixel,{0} pixelů
        pixel-per-centimeter,PPCM,,{0} PPCM,{0} PPCM,PPCM,,{0} PPCM,{0} PPCM,pixely na centimetr,,{0} pixel na centimetr,{0} pixelů na centimetr
        pixel-per-inch,PPI,,{0} PPI,{0} PPI,PPI,,{0} PPI,{0} PPI,pixely na palec,,{0} pixel na palec,{0} pixelů na palec
        astronomical-unit,,,,,,,,,astronomické jednotky,,{0} astronomická jednotka,{0} astronomických jednotek
        centimeter,,,,,,,,,centimetry,{0} na centimetr,{0} centimetr,{0} centimetrů
        decimeter,,,,,,,,,decimetry,,{0} decimetr,{0} decimetrů
        earth-radius,,,,,,,,,poloměr Země,,{0} poloměr Země,{0} poloměrů Země
        fathom,,,,,,,,,sáhy,,{0} sáh,{0} sáhů
        foot,ft,{0}/ft,{0}′,{0}′,,,,,stopy,{0} na stopu,{0} stopa,{0} stop
        furlong,,,,,,,,,furlongy,,{0} furlong,{0} furlongů
        inch,in,{0}/in,{0}″,{0}″,,,,,palce,{0} na palec,{0} palec,{0} palců
        kilometer,,,,,,,,,kilometry,{0} na kilometr,{0} kilometr,{0} kilometrů
        light-year,,,,,,,,,světelné roky,,{0} světelný rok,{0} světelných let
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,metry,{0} na metr,{0} metr,{0} metrů
        micrometer,,,,,,,,,mikrometry,,{0} mikrometr,{0} mikrometrů
        mile,,,,,,,,,míle,,{0} míle,{0} mil
        mile-scandinavian,,,,,,,,,skandinávské míle,,{0} skandinávská míle,{0} skandinávských mil
        millimeter,,,,,,,,,milimetry,,{0} milimetr,{0} milimetrů
        nanometer,,,,,,,,,nanometry,,{0} nanometr,{0} nanometrů
        nautical-mile,,,,,,,,,námořní míle,,{0} námořní míle,{0} námořních mil
        parsec,,,,,,,,,parseky,,{0} parsek,{0} parseků
        picometer,,,,,,,,,pikometry,,{0} pikometr,{0} pikometrů
        point,b.,,,{0} pt,body,,,{0} pt,body,,{0} bod,{0} bodů
        solar-radius,,,,,,,,,poloměr Slunce,,{0} poloměr Slunce,{0} poloměrů Slunce
        yard,,,,,,,,,yardy,,{0} yard,{0} yardů
        candela,,,,,,,,,kandely,,{0} kandela,{0} kandel
        lumen,,,,,,,,,lumeny,,{0} lumen,{0} lumenů
        lux,,,,,,,,,luxy,,{0} lux,{0} luxů
        solar-luminosity,,,,,,,,,zářivé výkony Slunce,,{0} zářivý výkon Slunce,{0} zářivých výkonů Slunce
        carat,,,,,,,,,karáty,,{0} karát,{0} karátů
        dalton,,,,,,,,,daltony,,{0} dalton,{0} daltonů
        earth-mass,,,,,,,,,hmotnosti Země,,{0} hmotnost Země,{0} hmotností Země
        grain,gr,,{0} gr,{0} gr,gr,,{0} gr,{0} gr,grainy,,{0} grain,{0} grainů
        gram,g,{0}/g,,{0} g,g,{0}/g,,{0} g,gramy,{0} na gram,{0} gram,{0} gramů
        kilogram,,,,,,,,,kilogramy,{0} na kilogram,{0} kilogram,{0} kilogramů
        microgram,,,,,,,,,mikrogramy,,{0} mikrogram,{0} mikrogramů
        milligram,,,,,,,,,miligramy,,{0} miligram,{0} miligramů
        ounce,,,,,,,,,unce,{0} na unci,{0} unce,{0} uncí
        ounce-troy,,,,,,,,,trojské unce,,{0} trojská unce,{0} trojských uncí
        pound,,,,,,,,,libry,{0} na libru,{0} libra,{0} liber
        solar-mass,,,,,,,,,hmotnosti Slunce,,{0} hmotnost Slunce,{0} hmotností Slunce
        stone,,,,,,,,,kameny,,{0} kámen,{0} kamenů
        ton,sht,,{0} sht,{0} sht,sht,,{0} sht,{0} sht,americké tuny,,{0} americká tuna,{0} amerických tun
        tonne,,,,,,,,,tuny,,{0} tuna,{0} tun
        gigawatt,,,,,,,,,gigawatty,,{0} gigawatt,{0} gigawattů
        horsepower,,,,,,,,,koňská síla,,{0} koňská síla,{0} koňských sil
        kilowatt,,,,,,,,,kilowatty,,{0} kilowatt,{0} kilowattů
        megawatt,,,,,,,,,megawatty,,{0} megawatt,{0} megawattů
        milliwatt,,,,,,,,,miliwatty,,{0} miliwatt,{0} miliwattů
        watt,W,,,{0} W,W,,,{0} W,watty,,{0} watt,{0} wattů
        atmosphere,,,,,,,,,atmosféry,,{0} atmosféra,{0} atmosfér
        bar,,,,,,,,,bary,,{0} bar,{0} barů
        hectopascal,,,,,,,,,hektopascaly,,{0} hektopascal,{0} hektopascalů
        inch-ofhg,″ Hg,,{0}″ Hg,{0}″ Hg,,,,,palce rtuťového sloupce,,{0} palec rtuťového sloupce,{0} palců rtuťového sloupce
        kilopascal,,,,,,,,,kilopascaly,,{0} kilopascal,{0} kilopascalů
        megapascal,,,,,,,,,megapascaly,,{0} megapascal,{0} megapascalů
        millibar,mb,,{0} mb,{0} mb,mb,,{0} mb,{0} mb,milibary,,{0} milibar,{0} milibarů
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,,,,,milimetry rtuťového sloupce,,{0} milimetr rtuťového sloupce,{0} milimetrů rtuťového sloupce
        pascal,,,,,,,,,pascaly,,{0} pascal,{0} pascalů
        pound-force-per-square-inch,,,,,,,,,libry na čtvereční palec,,{0} libra na čtvereční palec,{0} liber na čtvereční palec
        beaufort,Bft,,{0} Bft,{0} Bft,Bft,,{0} Bft,{0} Bft,stupně Beaufortovy stupnice,,{0}. stupeň Beaufortovy stupnice,{0}. stupeň Beaufortovy stupnice
        kilometer-per-hour,,,,,,,,,kilometry za hodinu,,{0} kilometr za hodinu,{0} kilometrů za hodinu
        knot,,,,,,,,,uzly,,{0} uzel,{0} uzlů
        light-speed,světlo,,{0} sv.,{0} sv.,světlo,,{0} světlo,{0} světel,světlo,,{0} světlo,{0} světel
        meter-per-second,,,,,,,,,metry za sekundu,,{0} metr za sekundu,{0} metrů za sekundu
        mile-per-hour,,,,,,,,,míle za hodinu,,{0} míle za hodinu,{0} mil za hodinu
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,stupně Celsia,,{0} stupeň Celsia,{0} stupňů Celsia
        fahrenheit,°F,,{0} °F,{0} °F,°F,,{0} °F,{0} °F,stupně Fahrenheita,,{0} stupeň Fahrenheita,{0} stupňů Fahrenheita
        generic,,,,,,,,,stupně,,{0} stupeň,{0} stupňů
        kelvin,,,,,,,,,kelviny,,{0} kelvin,{0} kelvinů
        newton-meter,Nm,,{0} Nm,{0} Nm,Nm,,{0} Nm,{0} Nm,newtonmetry,,{0} newtonmetr,{0} newtonmetrů
        pound-force-foot,,,,,,,,,librostopy,,{0} librostopa,{0} librostop
        acre-foot,,,,,,,,,akro-stopy,,{0} akro-stopa,{0} akro-stop
        barrel,,,,,,,,,barely,,{0} barel,{0} barelů
        bushel,,,,,,,,,bušly,,{0} bušl,{0} bušlů
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,centilitry,,{0} centilitr,{0} centilitrů
        cubic-centimeter,,,,,,,,,centimetry krychlové,{0} na centimetr krychlový,{0} centimetr krychlový,{0} centimetrů krychlových
        cubic-foot,,,,,,,,,stopy krychlové,,{0} stopa krychlová,{0} stop krychlových
        cubic-inch,,,,,,,,,palce krychlové,,{0} palec krychlový,{0} palců krychlových
        cubic-kilometer,,,,,,,,,kilometry krychlové,,{0} kilometr krychlový,{0} kilometrů krychlových
        cubic-meter,,,,,,,,,metry krychlové,{0} na metr krychlový,{0} metr krychlový,{0} metrů krychlových
        cubic-mile,,,,,,,,,míle krychlové,,{0} míle krychlová,{0} mil krychlových
        cubic-yard,,,,,,,,,yardy krychlové,,{0} yard krychlový,{0} yardů krychlových
        cup,c,,,{0} c,c,,,{0} c,šálky,,{0} šálek,{0} šálků
        cup-metric,,,,,,,,,metrické šálky,,{0} metrický šálek,{0} metrických šálků
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,decilitry,,{0} decilitr,{0} decilitrů
        dessert-spoon,,,,,,,,,dezertní lžičky,,{0} dezertní lžička,{0} dezertních lžiček
        dessert-spoon-imperial,dspIm,,{0} dspIm,{0} dspIm,dstspn Imp.,,{0} dstspn Imp.,{0} dstspn Imp.,britské dezertní lžičky,,{0} britská dezertní lžička,{0} britských dezertních lžiček
        dram,fl dr,,{0} fl dr,{0} fl dr,fl dr,,{0} fl dr,{0} fl dr,duté dramy,,{0} dutý dram,{0} dutých dramů
        drop,kapky,,{0} kapka,{0} kapek,kapky,,{0} kapka,{0} kapek,kapky,,{0} kapka,{0} kapek
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,duté unce,,{0} dutá unce,{0} dutých uncí
        fluid-ounce-imperial,fl oz Im,,{0} fl oz Im,{0} fl oz Im,fl oz Imp.,,,{0} fl oz Imp.,britské duté unce,,{0} britská dutá unce,{0} britských dutých uncí
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,galony,{0} na galon,{0} galon,{0} galonů
        gallon-imperial,galIm,{0}/galIm,{0} galIm,{0} galIm,gal Imp.,{0}/gal Imp.,,{0} gal Imp.,britské galony,{0} na britský galon,{0} britský galon,{0} britských galonů
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hektolitry,,{0} hektolitr,{0} hektolitrů
        jigger,odm.,,{0} odm.,{0} odm.,odměrky,,{0} odměrka,{0} odměrek,barmanské odměrky,,{0} barmanská odměrka,{0} barmanských odměrek
        liter,l,{0}/l,,{0} l,l,{0}/l,,{0} l,litry,{0} na litr,{0} litr,{0} litrů
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megalitry,,{0} megalitr,{0} megalitrů
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,mililitry,,{0} mililitr,{0} mililitrů
        pinch,šp.,,{0} šp.,{0} šp.,špetky,,{0} špetka,{0} špetek,špetky,,{0} špetka,{0} špetek
        pint,,,,,,,,,pinty,,{0} pinta,{0} pint
        pint-metric,,,,,,,,,metrické pinty,,{0} metrická pinta,{0} metrických pint
        quart,,,,,,,,,kvarty,,{0} kvart,{0} kvartů
        quart-imperial,qt Imp.,,,{0} qt Imp.,qt Imp.,,,{0} qt Imp.,britské kvarty,,{0} britský kvart,{0} britských kvartů
        tablespoon,,,,,,,,,lžíce,,{0} lžíce,{0} lžic
        teaspoon,,,,,,,,,lžičky,,{0} lžička,{0} lžiček
        """.trimIndent()
  }

  private val cs_Prefixes: String by lazy {
    """square,,,{0} čtverečních
        cubic,,,{0} krychlových
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobi{0}
        10p-1,,,deci{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yokto{0}
        10p-27,,,ronto{0}
        10p-3,,,mili{0}
        10p-30,,,quecto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hekto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val csw_Units: String? = null

  private val csw_Prefixes: String? = null

  private val cu_Units: String? = null

  private val cu_Prefixes: String? = null

  private val cv_Units: String? = null

  private val cv_Prefixes: String? = null

  private val cy_Units: String by lazy {
    """g-force,grym disgyrchedd,,{0}G,{0}G,grym disgyrchedd,,,{0} G,grym disgyrchedd,,{0} grym disgyrchedd,{0} grym disgyrchedd
        meter-per-square-second,metrau/eil²,,{0} m/eil²,{0} m/eil²,metrau/eil²,,{0} m/eil²,{0} m/eil²,metrau yr eiliad sgwâr,,{0} metr yr eiliad sgwâr,{0} metr yr eiliad sgwâr
        arc-minute,archfunudau,,{0}′,{0}′,archfunudau,,{0} archfun,{0} archfun,archfunudau,,{0} archfunud,{0} archfunud
        arc-second,archeiliad,,{0}″,{0}″,archeiliadau,,{0} archeiliad,{0} archeiliad,archeiliadau,,{0} archeiliad,{0} archeiliad
        degree,gradd,,{0}°,{0}°,gradd,,,{0}°,graddau,,{0} radd,{0} gradd
        radian,rad,,{0}rad,{0}rad,radianau,,,{0} rad,radianau,,{0} radian,{0} radian
        revolution,rev,,{0}rev,{0}rev,cylchdro,,{0} cylchdro,{0} cylchdro,cylchdroeon,,{0} cylchdro,{0} cylchdro
        acre,erw,,{0}erw,{0}erw,erw,,{0} erw,{0} erw,erw,,{0} erw,{0} erw
        dunam,dunam,,{0} dunam,{0} dunam,dunamau,,{0} dunam,{0} dunam,dunamau,,{0} dunam,{0} dunam
        hectare,hectar,,{0}ha,{0}ha,hectarau,,,{0} ha,hectarau,,{0} hectar,{0} hectar
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,cm²,{0} y cm²,,{0} cm²,centimetrau sgwâr,{0} y centimetr sgwâr,{0} centimetr sgwâr,{0} centimetr sgwâr
        square-foot,troedfedd²,,{0}ft²,{0}ft²,troedfedd²,,{0} tr²,{0} tr²,troedfeddi sgwâr,,{0} droedfedd sgwâr,{0} troedfedd sgwâr
        square-inch,modfedd²,{0} y mod²,{0} mod²,{0} mod²,modfedd²,{0} y mod²,{0} mod²,{0} mod²,modfeddi sgwâr,{0} y modfedd sgwâr,{0} modfedd sgwâr,{0} modfedd sgwâr
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,cilometrau sgwâr,{0} y cilometr sgwâr,{0} km²,{0} cilometr sgwâr
        square-meter,metrau²,{0}/m²,{0}m²,{0}m²,m²,{0} y m²,,{0} m²,metrau sgwâr,{0} y metr sgwâr,{0} metr sgwâr,{0} metr sgwâr
        square-mile,mi²,{0}/mi²,{0}mi²,{0}mi²,,,,,milltiroedd sgwâr,{0}/mi²,{0} filltir sgwâr,{0} milltir sgwâr
        square-yard,llath²,,{0} llath²,{0} llath²,llath²,,{0} llath²,{0} llath²,llathenni sgwâr,,{0} llath sgwâr,{0} llath sgwâr
        item,eitem,,{0} eitem,{0} eitem,eitem,,{0} eitem,{0} eitem,eitem,,{0} eitem,{0} eitem
        karat,carat,,{0}kt,{0}kt,karatau,,,{0} kt,karatau,,{0} karat,{0} karat
        milligram-ofglucose-per-deciliter,,,,,,,,,miligramau y declilitr,,{0} miligram y decilitr,{0} miligram y decilitr
        millimole-per-liter,milimôl/litr,,,{0} mmol/L,milimôl/litr,,,{0} mmol/L,milimolau y litr,,{0} milimôl y litr,{0} milimôl y litr
        mole,môl,,{0} môl,{0} môl,môl,,{0} môl,{0} môl,molau,,{0} môl,{0} môl
        percent,,,,,y cant,,,{0}%,y cant,,{0} y cant,{0} y cant
        permille,permille,,,{0}‰,permille,,,{0}‰,permille,,{0} permille,{0} permille
        permillion,rhan/miliwn,,,{0} ppm,rhan/miliwn,,,{0} ppm,rhannau pob miliwn,,{0} rhan pob miliwn,{0} rhan pob miliwn
        permyriad,permyriad,,,{0}‱,permyriad,,,{0}‱,permyriad,,{0} permyriad,{0} permyriad
        portion-per-1e9,rhannau/biliwn,,{0}ppb,{0}ppb,rhannau/biliwn,,,{0} ppb,rhannau fesul biliwn,,{0} rhan fesul biliwn,{0} rhan fesul biliwn
        liter-per-100-kilometer,L/100km,,{0}L/100km,{0}L/100km,,,,,litrau y 100 cilometr,,{0} litr y 100 cilometr,{0} litr y 100 cilometr
        liter-per-kilometer,L/km,,{0}L/km,{0}L/km,litrau/km,,,{0} L/km,litrau y cilometr,,{0} litr y cilometr,{0} litr y cilometr
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg,milltiroedd y galwyn,,{0} filltir y galwyn,{0} milltir y galwyn
        mile-per-gallon-imperial,milltir/gal Imp.,,{0}m/gUK,{0}m/gUK,milltir/gal Imp.,,,{0} mpg Imp.,milltiroedd y galwyn Imp.,,{0} milltir y galwyn Imp.,{0} milltir y galwyn Imp.
        bit,did,,{0}did,{0}did,did,,{0} did,{0} did,didau,,{0} did,{0} did
        byte,B,,{0}B,{0}B,beit,,{0} beit,{0} beit,beitiau,,{0} beit,{0} beit
        gigabit,Gb,,{0}Gb,{0}Gb,Gbit,,,{0} Gb,gigadidau,,{0} gigadid,{0} gigadid
        gigabyte,GBeit,,{0}GB,{0}GB,GBeit,,,{0} GB,gigabeitiau,,{0} gigabeit,{0} gigabeit
        kilobit,kb,,{0}kb,{0}kb,kbit,,,{0} kb,cilodidau,,{0} cilodid,{0} cilodid
        kilobyte,kBeit,,{0}kB,{0}kB,kBeit,,,{0} kB,cilobeitiau,,{0} cilobeit,{0} cilobeit
        megabit,Mbit,,,{0} Mb,Mbit,,,{0} Mb,megadidau,,{0} megadid,{0} megadid
        megabyte,MB,,{0}MB,{0}MB,MBeit,,,{0} MB,megabeitiau,,{0} megabeit,{0} megabeit
        petabyte,PByte,,,{0} PB,PByte,,,{0} PB,petabyte,,{0} petabyte,{0} petabyte
        terabit,,,,,,,,,teradidau,,{0} teradid,{0} teradid
        terabyte,TBeit,,{0}TB,{0}TB,TBeit,,,{0} TB,terabeitiau,,{0} terabeit,{0} terabeit
        century,c,,{0}c,{0}c,,,,,canrifoedd,,{0} canrif,{0} canrif
        day,d,{0}/d,{0}d,{0}d,diwrnodau,{0}/d,{0} diwrnod,{0} diwrnod,diwrnodau,{0} y diwrnod,{0} diwrnod,{0} diwrnod
        decade,deg,,{0} deg,{0} deg,deg,,{0} deg,{0} deg,degawdau,,{0} degawd,{0} degawd
        hour,awr,{0}/a,{0} awr,{0} awr,oriau,{0}/a,{0} awr,{0} awr,oriau,{0} yr awr,{0} awr,{0} awr
        microsecond,,,,,,,,,microeiliadau,,{0} microeiliadau,{0} microeiliadau
        millisecond,milieiliad,,{0}ms,{0}ms,milieiliadau,,{0} ms,{0} ms,milieiliadau,,{0} milieiliad,{0} milieiliad
        minute,mun,{0}/mun,{0}mun,{0}mun,mun,{0}/mun,{0} mun,{0} mun,munudau,{0} y munud,{0} munud,{0} munud
        month,mis,{0}/m,{0}m,{0}m,misoedd,{0}/mis,{0} mis,{0} mis,misoedd,{0} y mis,{0} mis,{0} mis
        nanosecond,,,,,,,,,nanoeiliadau,,{0} nanoeiliadau,{0} nanoeiliadau
        night,nosau,{0}/noson,{0}noson,{0}noson,nosau,{0}/noson,{0} noson,{0} noson,nosau,{0}/noson,{0} noson,{0} noson
        quarter,chw,{0}/chw,{0}chw,{0} chw,chw,{0}/chw,{0} chw,{0} chw,chwarteri,{0}/chw,{0} chwateri,{0} chwater
        second,eil,{0}/e,{0} eil,{0} eil,eiliadau,{0}/eil,{0} eil,{0} eil,eiliadau,{0} yr eiliad,{0} eiliad,{0} eiliad
        week,ws,{0}/w,{0}w,{0}w,wythnosau,{0}/ws,{0} ws,{0} ws,wythnosau,{0} yr wythnos,{0} wythnos,{0} wythnos
        year,bl,{0}/bl,{0}bl,{0}bl,blynyddoedd,{0}/bl,{0} bl,{0} bl,blynyddoedd,{0} y flwyddyn,{0} flwyddyn,{0} mlynedd
        ampere,amp,,{0}A,{0}A,ampau,,,{0} A,amperau,,{0} amper,{0} amper
        milliampere,mA,,{0}mA,{0}mA,miliampau,,,{0} mA,miliamperau,,{0} miliamper,{0} miliamper
        ohm,ohm,,{0}Ω,{0}Ω,ohmau,,,{0} Ω,ohmau,,{0} ohm,{0} ohm
        volt,folt,,{0}V,{0}V,foltiau,,,{0} V,foltiau,,{0} folt,{0} folt
        british-thermal-unit,BTU,,,{0} Btu,BTU,,,{0} Btu,unedau thermol Prydain,,{0} uned thermol Prydain,{0} uned thermol Prydain
        calorie,cal,,{0}cal,{0}cal,,,,,calorïau,,{0} calori,{0} calori
        electronvolt,electronfolt,,,{0} eV,electronfolt,,,{0} eV,electronfoltiau,,{0} electronfolt,{0} electronfolt
        foodcalorie,Cal,,{0}Cal,{0}Cal,Cal,,{0} Cal,{0} Cal,Calorïau,,{0} Calori,{0} Calori
        joule,joule,,{0}J,{0}J,jouleau,,,{0} J,jouleau,,{0} joule,{0} joule
        kilocalorie,kcal,,{0}kcal,{0}kcal,,,,,cilocalorïau,,{0} cilocalori,{0} cilocalori
        kilojoule,kJ,,{0}kj,{0}kj,cilojouleau,,,{0} kJ,cilojouleau,,{0} cilojoule,{0} cilojoule
        kilowatt-hour,kW-awr,,{0} kW-awr,{0} kW-awr,kW-awr,,{0} kW-awr,{0} kW-awr,cilowat oriau,,{0} cilowat awr,{0} cilowat awr
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0}kWh/100km,,,,,cilowat-awr fesul 100 cilomedr,,{0} cilowat-awr fesul 100 cilomedr,{0} cilowat-awr fesul 100 cilomedr
        newton,,,,,newton,,,{0} N,newtonau,,{0} newton,{0} newton
        pound-force,lbf,,{0}lbf,{0}lbf,pwys-grym,,,{0} lbf,pwysau o rym,,{0} pwys o rym,{0} pwysau o rym
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,gigaherts,,{0} gigaherts,{0} gigaherts
        hertz,Hz,,{0}Hz,{0}Hz,,,,,herts,,{0} herts,{0} herts
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,ciloherts,,{0} ciloherts,{0} ciloherts
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,megaherts,,{0} megaherts,{0} megaherts
        dot,dot,,{0} dot,{0} dot,dotiau,,{0} dot,{0} dot,dotiau,,{0} dot,{0} dot
        dot-per-centimeter,dpcm,,{0} dpcm,{0} ppcm,dpcm,,{0} dpcm,{0} ppcm,dotiau mewn centimedr,,{0} dot mewn centimedr,{0} dot mewn centimedr
        dot-per-inch,dpi,,,,dpi,,,,dotiau mewn modfedd,,{0} dot mewn modfedd,{0} dot mewn modfedd
        em,,,,,,,,,em argraffyddol,,,{0} em
        megapixel,megapicseli,,,{0} MP,megapicseli,,,{0} MP,megapicseli,,{0} megapicsel,{0} megapicsel
        pixel,picseli,,,{0} px,picseli,,,{0} px,picseli,,{0} picsel,{0} picsel
        pixel-per-centimeter,,,,,,,,,picseli mewn centimedr,,{0} picsel mewn centimedr,{0} picsel mewn centimedr
        pixel-per-inch,,,,,,,,,picseli mewn modfedd,,{0} picsel mewn modfedd,{0} picsel mewn modfedd
        astronomical-unit,u.s.,,{0}u.s.,{0}u.s.,u.s.,,{0} u.s.,{0} u.s.,unedau seryddol,,{0} uned seryddol,{0} uned seryddol
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,centimetrau,{0} y centimetr,{0} centimetr,{0} centimetr
        decimeter,dm,,{0}dm,{0}dm,,,,,decimetrau,,{0} decimetr,{0} decimetr
        earth-radius,,,,,,,,,radiws y Ddaear,,{0} radiws y Ddaear,{0} radiws y Ddaear
        fathom,gwrhydau,,{0}fth,{0}fth,gwrhydau,,{0} gwryd,{0} gwryd,gwrhydau,,{0} gwryd,{0} gwryd
        foot,troedfedd,{0}/ft,{0}′,{0}′,troedfeddi,{0}/troedfedd,{0}′,{0}′,troedfeddi,{0} y droedfedd,{0} droedfedd,{0} troedfedd
        furlong,ystadenni,,{0} yst,{0} yst,ystadenni,,{0} yst,{0} yst,ystadenni,,{0} ystaden,{0} ystaden
        inch,modfedd,{0}/mod,{0}″,{0}″,modfeddi,{0}/fodfedd,{0} fodfedd,{0} modfedd,modfeddi,{0} y fodfedd,{0} fodfedd,{0} modfedd
        kilometer,km,{0}/km,{0}km,{0}km,,,,,cilometrau,{0} y cilometr,{0} cilometr,{0} cilometr
        light-year,ly,,{0}ly,{0}ly,bl golau,,{0} bg,{0} bg,blynyddoedd golau,,{0} flwyddyn golau,{0} blwyddyn golau
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,,{0} m,metrau,{0} y metr,{0} metr,{0} metr
        micrometer,μm,,{0}μm,{0}μm,μmetrau,,,{0} μm,micrometrau,,{0} micrometr,{0} micrometr
        mile,mi,,{0}mi,{0}mi,milltiroedd,,,{0} mi,milltiroedd,,{0} filltir,{0} milltir
        mile-scandinavian,smi,,{0}smi,{0}smi,mi Sgand.,,{0} mi Sgand.,{0} mi Sgand.,milltiroedd Sgandinafia,,{0} filltir Sgandinafia,{0} milltir Sgandinafia
        millimeter,mm,,{0}mm,{0}mm,,,,,milimetrau,,{0} milimetr,{0} milimetr
        nanometer,nm,,{0}nm,{0}nm,,,,,nanometrau,,{0} nanometr,{0} nanometr
        nautical-mile,nmi,,{0}nmi,{0}nmi,mi fôr,,{0} mi fôr,{0} mi fôr,milltiroedd môr,,{0} filltir fôr,{0} milltir fôr
        parsec,pc,,{0}pc,{0}pc,parsecau,,,{0} pc,parsecau,,{0} parsec,{0} parsec
        picometer,pm,,{0}pm,{0}pm,,,,,picometrau,,{0} picometr,{0} picometr
        point,pt,,{0}pt,{0}pt,,,,,pwyntiau,,{0} pwynt,{0} pwynt
        solar-radius,R☉,,{0}R☉,{0}R☉,radiysau solar,,,{0} R☉,radiysau solar,,{0} radiws solar,{0} radiws solar
        yard,llath,,{0}llath,{0}llath,llathenni,,{0} llath,{0} llath,llathenni,,{0} llath,{0} llath
        candela,cd,,{0}cd,{0}cd,,,,,candela,,,{0} cd
        lumen,lm,,{0}lm,{0}lm,,,,,lwmen,,,{0} lm
        lux,lwcs,,{0}lx,{0}lx,lycsau,,,{0} lx,lycsau,,{0} lwcs,{0} lwcs
        solar-luminosity,L☉,,{0}L☉,{0}L☉,goleueddau solar,,,{0} L☉,goleueddau solar,,{0} goleuedd solar,{0} goleueddau solar
        carat,carat,,{0}CD,{0}CD,caratau,,,{0} CD,caratau,,{0} carat,{0} carat
        dalton,daltonau,,,{0} Da,daltonau,,,{0} Da,daltonau,,{0} dalton,{0} dalton
        earth-mass,masau ddaear,,,{0} M⊕,masau ddaear,,,{0} M⊕,masau ddaear,,{0} más ddaear,{0} más ddaear
        grain,graen,,{0} graen,{0} graen,graen,,{0} graen,{0} graen,graen,,{0} graen,{0} graen
        gram,gram,{0}/g,{0}g,{0}g,gramau,{0}/g,,{0} g,gramau,{0} y gram,{0} gram,{0} gram
        kilogram,kg,{0}/kg,{0} kg,{0}kg,,,,,cilogramau,{0} y cilogram,{0} cilogram,{0} cilogram
        microgram,μg,,{0}μg,{0}μg,,,,,microgramau,,{0} microgram,{0} microgram
        milligram,mg,,{0}mg,{0}mg,,,,,miligramau,,{0} miligram,{0} miligram
        ounce,owns,{0}/owns,{0}owns,{0}owns,owns,{0}/owns,{0} owns,{0} owns,ownsys,{0} yr owns,{0} owns,{0} owns
        ounce-troy,,,,,,,,,ownsiau pwysau aur,,{0} owns pwysau aur,{0} owns pwysau aur
        pound,pwys,{0}/pwys,{0}pwys,{0}pwys,pwysi,{0}/pwys,{0} pwys,{0} pwys,pwysi,{0} y pwys,{0} pwys,{0} pwys
        solar-mass,masau solar,,,{0} M☉,masau solar,,,{0} M☉,masau solar,,{0} más solar,{0} más solar
        stone,stôn,,{0}st,{0}st,stonau,,,{0} st,stonau,,{0} stôn,{0} stôn
        ton,,,,,,,,,tunelli,,{0} dunnell,{0} tunnell
        tonne,t,,{0}t,{0}t,,,,,tunelli metrig,,{0} dunnell fetrig,{0} tunnell fetrig
        gigawatt,GW,,{0}GW,{0}GW,,,,,gigawatiau,,{0} gigawat,{0} gigawat
        horsepower,hp,,{0}hp,{0}hp,,,,,marchnerth,,{0} marchnerth,{0} marchnerth
        kilowatt,kW,,{0}kW,{0}kW,,,,,cilowatiau,,{0} cilowat,{0} cilowat
        megawatt,MW,,{0}MW,{0}MW,,,,,megawatiau,,{0} megawat,{0} megawat
        milliwatt,mW,,{0}mW,{0}mW,,,,,miliwatiau,,{0} miliwat,{0} miliwat
        watt,wat,,{0}W,{0}W,watiau,,,{0} W,watiau,,{0} wat,{0} wat
        atmosphere,atm,,{0}atm,{0}atm,,,,,atmosfferau,,{0} atmosffer,{0} atmosffer
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,hectopascalau,,{0} hectopascal,{0} hectopascal
        inch-ofhg,″ Hg,,{0}'' Hg,{0}'' Hg,,,,,modfeddi o fercwri,,{0} fodfedd o fercwri,{0} modfedd o fercwri
        kilopascal,,,,,,,,,cilopascalau,,{0} cilopascal,{0} cilopascalau
        megapascal,,,,,,,,,megapascalau,,{0} megapascal,{0} megapascalau
        millibar,mbar,,{0}mb,{0}mb,,,,,milibarau,,{0} milibar,{0} milibar
        millimeter-ofhg,mmHg,,{0}mmHg,{0}mmHg,mmHg,,{0} mmHg,{0} mmHg,milimetrau o fercwri,,{0} milimetr o fercwri,{0} milimetr o fercwri
        pascal,Pa,,{0}Pa,{0}Pa,,,,,pascalau,,{0} pascal,{0} pascal
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,,,,,pwysau y fodfedd sgwar,,{0} pwys y fodfedd sgwar,{0} pwys y fodfedd sgwar
        beaufort,Bft,,B{0},B{0},,,,,Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,km/h,,{0}km/h,{0}km/h,,,,,cilometrau yr awr,,{0} cilometr yr awr,{0} cilometr yr awr
        knot,not,,{0}not,{0}not,notiau,,{0} not,{0} not,notiau,,{0} not,{0} not
        light-speed,golau,,{0} golau,{0} golau,golau,,{0} golau,{0} golau,golau,,golau,{0} golau
        meter-per-second,m/s,,{0}m/s,{0}m/s,metrau/eil,,,{0} m/s,metrau yr eiliad,,{0} metr yr eiliad,{0} metr yr eiliad
        mile-per-hour,m.y.a.,,{0}m.y.a.,{0}m.y.a.,milltir/awr,,{0} m.y.a.,{0} m.y.a.,milltiroedd yr awr,,{0} filltir yr awr,{0} milltir yr awr
        celsius,°C,,{0}°C,{0}°C,gradd C,,,{0}°C,graddau Celsius,,{0} radd Celsius,{0} gradd Celsius
        fahrenheit,,,,,gradd F,,,{0}°F,gradd Fahrenheit,,{0} radd Fahrenheit,{0} gradd Fahrenheit
        kelvin,K,,{0}K,{0}K,,,,,celfinau,,{0} celfin,{0} celfin
        newton-meter,N⋅m,,{0}N⋅m,{0}N⋅m,,,,,newton-metrau,,{0} newton-metr,{0} newton-metrau
        pound-force-foot,lbf⋅ft,,{0}lbf⋅ft,{0}lbf⋅ft,,,,,pwys-troedfeddi,,{0} pwys o rym⋅droedfedd,{0} pwys-troedfeddi
        acre-foot,erw tr,,{0} erw tr,{0} erw tr,erw tr,,{0} erw tr,{0} erw tr,erw-droedfeddi,,{0} erw-droedfedd,{0} erw-droedfedd
        barrel,barel,,,{0} bbl,barel,,,{0} bbl,bareli,,{0} barel,{0} barel
        bushel,bwsielau,,{0} bw,{0} bw,bwsielau,,{0} bw,{0} bw,bwsielau,,{0} bwsiel,{0} bwsiel
        centiliter,cL,,{0}cL,{0}cL,,,,,centilitrau,,{0} centilitr,{0} centilitr
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,centimetrau ciwbig,{0} y centimetr ciwbig,{0} centimetr ciwbig,{0} chentimetr ciwbig
        cubic-foot,troedfedd³,,{0} tr³,{0} tr³,troedfedd³,,{0} tr³,{0} tr³,troedfeddi ciwbig,,{0} droedfedd giwbig,{0} troedfedd giwbig
        cubic-inch,in³,,{0}in³,{0}in³,modfeddi³,,,{0} in³,modfeddi ciwbig,,{0} fodfedd giwbig,{0} modfedd giwbig
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,cilometrau ciwbig,,{0} cilometr ciwbig,{0} cilometr ciwbig
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,metrau ciwbig,{0} y metr ciwbig,{0} metr ciwbig,{0} metr ciwbig
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,milltiroedd ciwbig,,{0} filltir giwbig,{0} milltir giwbig
        cubic-yard,llathenni³,,{0} llathen³,{0} llath³,llathenni³,,{0} llathen³,{0} llath³,llathenni ciwbig,,{0} llathen giwbig,{0} llath giwbig
        cup,cwpan,,{0}c,{0}c,cwpaneidiau,,,{0} c,cwpaneidiau,,{0} cwpanaid,{0} cwpanaid
        cup-metric,cwpanaid metrig,,,{0} mc,cwpanaid metrig,,,{0} mc,cwpaneidiau metrig,,{0} cwpanaid metrig,{0} cwpanaid metrig
        deciliter,dL,,{0}dL,{0}dL,,,,,decilitrau,,{0} decilitr,{0} decilitr
        dessert-spoon,,,,,,,,,llond llwy bwdin,,{0} llond llwy bwdin,{0} llond llwy bwdin
        dessert-spoon-imperial,dsp Imp,,{0}dsp-Imp,{0}dsp-Imp,,,,,llond llwy bwdin imp.,,{0} llond llwy bwdin imp.,{0} llond llwy bwdin imp.
        dram,fl.dr.,,{0}fl.dr.,{0}fl.dr.,dracmon hylifol,,{0} dracmon hy,{0} dracmon hy,dracmon hylifol,,{0} dracmon hy,{0} dracmon hy
        drop,dr,,{0}dr,{0}dr,diferyn,,{0} diferyn,{0} diferyn,diferyn,,{0} diferyn,{0} diferyn
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,ownsiau hylifol,,{0} owns hylifol,{0} owns hylifol
        fluid-ounce-imperial,Imp. fl oz,,{0}fl oz Im,{0}fl oz Im,,,,,Ownsiau hylifol Imp.,,{0} owns hylifol Imp.,{0} owns hylifol Imp.
        gallon,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal,{0} gal,{0} gal,galwyni,{0} y galwyn,{0} galwyn,{0} galwyn
        gallon-imperial,Imp gal,{0}/galIm,{0}galIm,{0}galIm,Gal Imp.,{0}/gal Imp.,,{0} gal Imp.,Galwyni Imp.,{0} y galwyn Imp.,{0} galwyn Imp.,{0} galwyn Imp.
        hectoliter,hL,,{0}hL,{0}hL,,,,,hectolitrau,,{0} hectolitr,{0} hectolitr
        jigger,joch,,{0}joch,{0}joch,joch,,{0} joch,{0} joch,joch,,{0} joch,{0} joch
        liter,litr,{0}/L,{0} L,{0} L,litrau,{0}/L,{0} L,{0} L,litrau,{0} y litr,{0} litr,{0} litr
        megaliter,ML,,{0}ML,{0}ML,,,,,megalitrau,,{0} megalitr,{0} megalitr
        milliliter,mL,,{0}mL,{0}mL,,,,,mililitrau,,{0} mililitr,{0} mililitr
        pinch,pinsiad,,{0}pn,{0}pn,pinsiad,,{0} pinsiad,{0} pinsiad,pinsiad,,{0} pinsiad,{0} pinsiad
        pint,pt,,{0}pt,{0}pt,peintiau,,,{0} pt,peintiau,,{0} peint,{0} peint
        pint-metric,,,,,,,,,peintiau metrig,,{0} peint metrig,{0} peint metrig
        quart,qt,,{0}qt,{0}qt,,,,,chwartiau,,{0} chwart,{0} chwart
        quart-imperial,qt Imp,,{0}qt-Imp.,{0}qt-Imp.,cht Imp.,,{0} cht Imp.,{0} cht Imp.,chwart Imp,,{0} cht Imp.,{0} cht Imp.
        tablespoon,tbsp,,{0}tbsp,{0}tbsp,,,,,llond llwy fwrdd,,{0} llond llwy fwrdd,{0} llond llwy fwrdd
        teaspoon,,,,,,,,,llond llwy de,,{0} llond llwy de,{0} llond llwy de
        """.trimIndent()
  }

  private val cy_Prefixes: String by lazy {
    """square,,,{0} sgwâr
        cubic,,,{0} ciwbig
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobe{0}
        10p-1,,,desi{0}
        10p-12,,,pico{0}
        10p-15,,,ffemto{0}
        10p-18,,,ato{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,mili{0}
        10p-30,,,quecto{0}
        10p-6,,,micro{0}
        10p-9,,,nano{0}
        10p1,,,deca{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hecto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,cilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val da_Units: String by lazy {
    """g-force,G-kraft,,{0}G,{0}G,G-kraft,,,{0} G,G-kraft,,{0} G-kraft,{0} G-kraft
        meter-per-square-second,,,,,,,,,meter pr. sekund²,,{0} meter pr. sekund²,{0} meter pr. sekund²
        arc-minute,buemin.,,,{0}′,buemin.,,,{0}′,bueminutter,,{0} bueminut,{0} bueminutter
        arc-second,buesek.,,,{0}″,buesek.,,,{0}″,buesekunder,,{0} buesekund,{0} buesekunder
        degree,gr.,,,{0}°,grader,,,{0}°,grader,,{0} grad,{0} grader
        radian,radian,,{0} radian,{0} radian,radianer,,{0} radian,{0} radian,radian,,{0} radian,{0} radianer
        revolution,omdr.,,{0} omdr.,{0} omdr.,omdr.,,{0} omdr.,{0} omdr.,omdrejninger,,{0} omdrejning,{0} omdrejninger
        acre,acre,,{0}ac,{0}ac,,,,,acre,,{0} acre,{0} acres
        hectare,hektar,,{0}ha,{0}ha,hektar,,,{0} ha,hektar,,{0} hektar,{0} hektar
        square-centimeter,,,,,,,,,kvadratcentimeter,{0}/cm²,{0} kvadratcentimeter,{0} kvadratcentimeter
        square-foot,fod²,,{0} fod²,{0} fod²,kvadratfod,,{0} kvadratfod,{0} kvadratfod,kvadratfod,,{0} kvadratfod,{0} kvadratfod
        square-inch,,,,,,,,,kvadrattommer,{0} pr. kvadrattomme,{0} kvadrattomme,{0} kvadrattommer
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,kvadratkilometer,{0} pr. kvadratkilometer,{0} kvadratkilometer,{0} kvadratkilometer
        square-meter,m²,{0}/m²,{0}m²,{0}m²,,,,,kvadratmeter,{0}/m²,{0} kvadratmeter,{0} kvadratmeter
        square-mile,,,,,,,,,kvadrat-engelske mil,{0} pr. kvadrat-engelske mil,{0} kvadrat-engelsk mil,{0} kvadrat-engelske mil
        square-yard,,,,,,,,,kvadrat-engelske yard,,{0} kvadrat-engelsk yard,{0} kvadrat-engelske yard
        item,enhed,,{0} enhed,{0} enheder,enhed,,{0} enhed,{0} enheder,enheder,,{0} enhed,{0} enheder
        karat,karat,,{0} kt.,{0} kt.,karat,,{0} kt.,{0} kt.,karat,,{0} karat,{0} karat
        milligram-ofglucose-per-deciliter,mg/dl,,{0} mg/dl,{0} mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligram pr. deciliter,,{0} milligram pr. deciliter,{0} milligram pr. deciliter
        millimole-per-liter,mmol/L,,{0} mmol/l,{0} mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,millimol pr. liter,,{0} millimol pr. liter,{0} millimol pr. liter
        mole,,,,,,,,,mol,,{0} mol,{0} mol
        percent,%,,{0} %,{0} %,pct.,,{0} pct.,{0} pct.,procent,,{0} procent,{0} procent
        permille,‰,,{0} ‰,{0} ‰,‰,,{0} ‰,{0} ‰,promille,,{0} promille,{0} promille
        permillion,,,,,,,,,parts per million,,{0} part per million,{0} parts per million
        permyriad,‱,,{0} ‱,{0} ‱,‱,,{0} ‱,{0} ‱,‱,,{0} ‱,{0} ‱
        portion-per-1e9,dele/milliard,,,{0} ppb,dele/milliard,,,{0} ppb,milliardtedele,,{0} milliardtedel,{0} milliardtedele
        liter-per-100-kilometer,l/100 km,,{0} l/100 km,{0} l/100 km,l/100 km,,{0} l/100 km,{0} l/100 km,liter pr. 100 kilometer,,{0} liter pr. 100 kilometer,{0} liter pr. 100 kilometer
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,liter pr. kilometer,,{0} liter pr. kilometer,{0} liter pr. kilometer
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg,mil pr. gallon,,mil pr. gallon,{0} mil pr. gallon
        mile-per-gallon-imperial,mil/eng. gal,,{0}mpgUK,{0}mpgUK,mil/eng. gal,,{0} eng. mpg,{0} eng. mpg,mil pr. engelsk gallon,,{0} mil pr. engelsk gallon,{0} mil pr. engelsk gallon
        bit,,,,,,,,,bit,,{0} bit,{0} bit
        byte,B,,{0} B,{0} B,B,,{0} B,{0} B,bytes,,{0} byte,{0} bytes
        gigabit,Gbit,,{0} Gbit,{0} Gbit,Gbit,,{0} Gbit,{0} Gbit,gigabit,,{0} gigabit,{0} gigabit
        gigabyte,,,,,,,,,gigabytes,,{0} gigabyte,{0} gigabytes
        kilobit,kb,,{0} kb,{0} kb,kbit,,{0} kbit,{0} kbit,kilobit,,{0} kilobit,{0} kilobit
        kilobyte,,,,,,,,,kilobytes,,{0} kilobyte,{0} kilobytes
        megabit,Mb,,{0} Mb,{0} Mb,Mbit,,{0} Mbit,{0} Mbit,megabit,,{0} megabit,{0} megabit
        megabyte,,,,,,,,,megabytes,,{0} megabyte,{0} megabytes
        petabyte,,,,,,,,,petabytes,,{0} petabyte,{0} petabytes
        terabit,Tb,,{0} Tb,{0} Tb,Tbit,,{0} Tbit,{0} Tbit,terabit,,{0} terabit,{0} terabit
        terabyte,,,,,,,,,terabytes,,{0} terabyte,{0} terabytes
        century,årh.,,{0} årh.,{0} årh.,årh.,,{0} årh.,{0} årh.,århundreder,,{0} århundrede,{0} århundreder
        day,dag,{0}/d,{0} d,{0} d,dage,{0}/dag,{0} dag,{0} dage,dage,{0} pr. dag,{0} dag,{0} dage
        decade,årti,,{0} årti,{0} årtier,årti,,{0} årti,{0} årtier,årtier,,{0} årti,{0} årtier
        hour,time,{0}/t,{0} t,{0} t,timer,{0}/t.,{0} t.,{0} t.,timer,{0} pr. time,{0} time,{0} timer
        microsecond,μs,,{0}μs,{0}μs,,,,,mikrosekunder,,{0} mikrosekund,{0} mikrosekunder
        millisecond,,,,,milisek.,,,{0} ms,millisekunder,,{0} millisekund,{0} millisekunder
        minute,min,{0}/m,{0} m,{0} m,minutter,{0}/min.,{0} min.,{0} min.,minutter,{0} pr. min.,{0} minut,{0} minutter
        month,måned,{0}/m,{0} m,{0} m,måneder,{0}/md.,{0} md.,{0} mdr.,måneder,{0} pr. måned,{0} måned,{0} måneder
        nanosecond,ns,,{0}ns,{0}ns,,,,,nanosekunder,,{0} nanosekund,{0} nanosekunder
        night,nætter,{0}/nat,{0}nat,{0}nætter,nætter,{0}/nat,{0} nat,{0} nætter,nætter,{0} pr. nat,{0} nat,{0} nætter
        quarter,kvartal,{0}/kvt.,{0} kvt.,{0} kvt.,kvartaler,{0} pr. kvt.,{0} kvt.,{0} kvt.,kvartaler,{0} pr. kvartal,{0} kvartal,{0} kvartaler
        second,sek,{0}/s,{0} s,{0} s,sekunder,{0}/sek.,{0} sek.,{0} sek.,sekunder,{0} pr. sekund,{0} sekund,{0} sekunder
        week,uge,{0}/u,{0} u,{0} u,uger,{0}/uge,{0} uge,{0} uger,uger,{0} pr. uge,{0} uge,{0} uger
        year,år,{0}/år,{0} år,{0} år,år,{0}/år,{0} år,{0} år,år,{0} om året,{0} år,{0} år
        ampere,A,,,{0} A,A,,,{0} A,ampere,,{0} ampere,{0} ampere
        milliampere,,,,,,,,,milliampere,,{0} milliampere,{0} milliampere
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,ohm,,{0} ohm,{0} ohm
        volt,V,,,{0} V,V,,,{0} V,volt,,{0} volt,{0} volt
        calorie,,,,,,,,,kalorier,,{0} kalorie,{0} kalorier
        electronvolt,,,,,elektronvolt,,,{0} eV,elektronvolt,,{0} elektronvolt,{0} elektronvolt
        foodcalorie,cal,,{0} cal,{0} cal,cal,,{0} cal,{0} cal,kalorier,,{0} kalorie,{0} kalorier
        joule,,,,,,,,,joule,,{0} joule,{0} joule
        kilocalorie,,,,,,,,,kilokalorier,,{0} kilokalorie,{0} kilokalorier
        kilojoule,,,,,,,,,kilojoule,,{0} kilojoule,{0} kilojoule
        kilowatt-hour,,,,,,,,,kilowatt-timer,,{0} kilowatt-time,{0} kilowatt-timer
        kilowatt-hour-per-100-kilometer,kWh/100 km,,{0}kWh/100km,{0} kWh/100 km,kWh/100km,,{0} kWh pr. 100 km,{0} kWh pr. 100 km,kilowatt-time per 100 kilometer,,{0} kilowatt-time per 100 kilometer,{0} kilowatt-timer per 100 kilometer
        newton,,,,,newton,,,{0} N,newton,,{0} newton,{0} newton
        gigahertz,,,,,,,,,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,,,,,,,,,hertz,,{0} hertz,{0} hertz
        kilohertz,,,,,,,,,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,,,,,,,,,megahertz,,{0} megahertz,{0} megahertz
        dot,prik,,{0} p,{0} p,prikker,,{0} p,{0} p,prikker,,{0} prik,{0} prikker
        dot-per-centimeter,,,,,,,,,prikker per centimeter,,{0} prik per centimeter,{0} prikker per centimeter
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,prikker per tomme,,{0} prik per tomme,{0} prikker per tomme
        em,,,,,,,,,geviert,,{0} geviert,{0} geviert
        megapixel,,,,,,,,,megapixels,,{0} megapixel,{0} megapixels
        pixel,,,,,,,,,pixels,,{0} pixel,{0} pixels
        pixel-per-centimeter,,,,,,,,,pixels per centimeter,,{0} pixel per centimeter,{0} pixels per centimeter
        pixel-per-inch,,,,,,,,,pixels per tomme,,{0} pixel per tomme,{0} pixels per tomme
        astronomical-unit,,,,,,,,,astronomiske enheder,,{0} astronomisk enhed,{0} astronomiske enheder
        centimeter,,,,,,,,,centimeter,{0} pr. centimeter,{0} centimeter,{0} centimeter
        decimeter,dm,,{0}dm,{0}dm,,,,,decimeter,,{0} decimeter,{0} decimeter
        earth-radius,,,,,,,,,jordradius,,{0} jordradius,{0} jordradier
        fathom,favn,,{0} favn,{0} favne,favne,,{0} favn,{0} favne,favne,,{0} favn,{0} favne
        foot,fod,{0}/ft,{0} fod,{0} fod,fod,{0}/ft,{0} fod,{0} fod,fod,{0} pr. fod,{0} fod,{0} fod
        furlong,,,,,,,,,furlongs,,{0} furlong,{0} furlongs
        inch,tommer,{0}/tomme,{0}'',{0}'',tommer,{0}/tomme,{0} tomme,{0} tommer,tommer,{0} pr. tomme,{0} tomme,{0} tommer
        kilometer,,,,,,,,,kilometer,{0} pr. kilometer,{0} kilometer,{0} kilometer
        light-year,ly,,{0} lysår,{0} lysår,lysår,,,{0} ly,lysår,,{0} lysår,{0} lysår
        meter,,,,,,,,,meter,{0} pr. meter,{0} meter,{0} meter
        micrometer,μm,,{0}μm,{0}μm,,,,,mikrometer,,{0} mikrometer,{0} mikrometer
        mile,mile,,,{0} mi,miles,,,{0} mi,miles,,{0} mile,{0} miles
        mile-scandinavian,sv. mil,,{0}sv. mil,{0}sv. mil,,,,,svenske mil,,{0} svensk mil,{0} svenske mil
        millimeter,,,,,,,,,millimeter,,{0} millimeter,{0} millimeter
        nanometer,nm,,{0}nm,{0}nm,,,,,nanometer,,{0} nanometer,{0} nanometer
        nautical-mile,sm,,{0} sømil,{0} sømil,sømil,,{0} sm,{0} sm,sømil,,{0} sømil,{0} sømil
        parsec,,,,,,,,,parsec,,{0} parsec,{0} parsec
        picometer,pm,,{0}pm,{0}pm,,,,,pikometer,,{0} pikometer,{0} pikometer
        point,pkt.,,{0} pkt.,{0} pkt.,pkt.,,{0} pkt.,{0} pkt.,punkt,,{0} punkt,{0} punkt
        solar-radius,,,,,solradier,,,{0} R☉,solradier,,{0} solradius,{0} solradier
        yard,engelske yard,,{0} yard,{0} yard,engelske yard,,{0} yard,{0} yard,engelske yard,,{0} engelsk yard,{0} engelske yard
        candela,,,,,,,,,candela,,{0} candela,{0} candela
        lumen,,,,,,,,,lumen,,{0} lumen,{0} lumen
        lux,,,,,,,,,lux,,{0} lux,{0} lux
        carat,kt.,,{0} kt.,{0} kt.,kt.,,{0} kt.,{0} kt.,karat,,{0} karat,{0} karat
        earth-mass,,,,,,,,,Jordmasser,,{0} jordmasse,{0} jordmasser
        grain,gran,,{0} gran,{0} gran,gran,,{0} gran,{0} gran,gran,,{0} gran,{0} gran
        gram,g,{0}/g,,{0} g,,,,,gram,{0} pr. gram,{0} gram,{0} gram
        kilogram,,,,,,,,,kilogram,{0} pr. kg,{0} kilogram,{0} kilogram
        microgram,,,,,,,,,mikrogram,,{0} mikrogram,{0} mikrogram
        milligram,,,,,,,,,milligram,,{0} milligram,{0} milligram
        ounce,,,,,,,,,ounces,{0} pr. ounce,{0} ounce,{0} ounces
        ounce-troy,,,,,,,,,troy ounces,,{0} troy ounce,{0} troy ounces
        pound,pund,{0}/lb,{0} pund,{0} pund,pund,{0}/lb,,{0} lb,pund,{0} pr. pund,{0} pund,{0} pund
        solar-mass,solmasser,,,{0} M☉,solmasser,,,{0} M☉,solmasser,,{0} solmasse,{0} solmasser
        stone,,,,,,,,,stone,,{0} stone,{0} stone
        ton,,,,,,,,,short ton,,{0} short ton,{0} short ton
        tonne,,,,,,,,,tons,,{0} ton,{0} tons
        gigawatt,,,,,,,,,gigawatt,,{0} gigawatt,{0} gigawatt
        horsepower,hk,,{0}hk,{0}hk,hk,,{0} hk,{0} hk,hestekræfter,,{0} hestekraft,{0} hestekræfter
        kilowatt,kW,,{0}kW,{0}kW,,,,,kilowatt,,{0} kilowatt,{0} kilowatt
        megawatt,,,,,,,,,megawatt,,{0} megawatt,{0} megawatt
        milliwatt,,,,,,,,,milliwatt,,{0} milliwatt,{0} milliwatt
        watt,watt,,{0}W,{0}W,W,,,{0} W,watt,,{0} watt,{0} watt
        atmosphere,,,,,,,,,atmosfære,,{0} atmosfære,{0} atmosfære
        bar,,,,,,,,,bar,,{0} bar,{0} bar
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,hektopascal,,{0} hektopascal,{0} hektopascal
        inch-ofhg,# Hg,,{0}″ Hg,{0}″ Hg,# Hg,,{0} # Hg,{0} # Hg,tommer kviksølv,,{0} tomme kviksølv,{0} tommer kviksølv
        kilopascal,,,,,,,,,kilopascal,,{0} kilopascal,{0} kilopascal
        megapascal,,,,,,,,,megapascal,,{0} megapascal,{0} megapascal
        millibar,mbar,,{0} mb,{0} mb,,,,,millibar,,{0} millibar,{0} millibar
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,mmHg,,{0} mmHg,{0} mmHg,millimeter kviksølv,,{0} millimeter kviksølv,{0} millimeter kviksølv
        pascal,,,,,,,,,pascal,,{0} pascal,{0} pascal
        pound-force-per-square-inch,,,,,,,,,pounds pr. kvadrattomme,,{0} pound pr. kvadrattomme,{0} pounds pr. kvadrattomme
        beaufort,bft,,bft {0},bft {0},bft,,bft {0},bft {0},beaufort,,beaufort {0},beaufort {0}
        kilometer-per-hour,km/t,,{0} km/t,{0} km/t,km/t,,{0} km/t.,{0} km/t.,kilometer i timen,,{0} kilometer i timen,{0} kilometer i timen
        knot,knob,,{0} knob,{0} knob,knob,,{0} knob,{0} knob,knob,,{0} knob,{0} knob
        meter-per-second,m/s,,{0}m/s,{0}m/s,,,,,meter pr. sekund,,{0} meter i sekundet,{0} meter i sekundet
        mile-per-hour,engelske mil/timen,,{0} mph,{0} mph,engelske mil/timen,,{0} mph,{0} mph,engelske mil i timen,,{0} engelsk mil i timen,{0} engelske mil i timen
        celsius,,,,,,,,,grader celsius,,{0} grad celsius,{0} grader celsius
        fahrenheit,,,,,,,,,grader fahrenheit,,{0} grad fahrenheit,{0} grader fahrenheit
        generic,,,,,,,,,°,,{0}°,{0}°
        kelvin,,,,,,,,,kelvin,,{0} kelvin,{0} kelvin
        newton-meter,Nm,,{0} Nm,{0} Nm,Nm,,{0} Nm,{0} Nm,newtonmeter,,{0} newtonmeter,{0} newtonmeter
        acre-foot,,,,,,,,,acre-fod,,{0} acre-fod,{0} acre-fod
        barrel,td.,,{0} td.,{0} tdr.,tønde,,{0} td.,{0} tdr.,tønder,,{0} tønde,{0} tønder
        bushel,skp.,,{0} skp.,{0} skp.,skp.,,{0} skp.,{0} skp.,skæpper,,{0} skæppe,{0} skæpper
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,centiliter,,{0} centiliter,{0} centiliter
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,kubikcentimeter,{0}/cm³,{0} kubikcentimeter,{0} kubikcentimeter
        cubic-foot,ft³,,{0} fod³,{0} fod³,,,,,kubikfod,,{0} kubikfod,{0} kubikfod
        cubic-inch,,,,,,,,,kubiktommer,,{0} kubiktomme,{0} kubiktommer
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,kubikkilometer,,{0} kubikkilometer,{0} kubikkilometer
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,kubikmeter,{0}/m³,{0} kubikmeter,{0} kubikmeter
        cubic-mile,,,,,,,,,kubik-engelske mil,,{0} kubik-engelsk mil,{0} kubik-engelske mil
        cubic-yard,,,,,,,,,kubik-engelske yard,,{0} kubik-engelske yard,{0} kubik-engelske yard
        cup,cups,,,{0} c,cups,,,{0} c,cups,,{0} cup,{0} cups
        cup-metric,,,,,,,,,metriske kopper,,{0} metrisk kop,{0} metriske kopper
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,deciliter,,{0} deciliter,{0} deciliter
        dessert-spoon,dsk.,,{0} dsk.,{0} dsk.,dsk.,,{0} dsk.,{0} dsk.,dessertske,,{0} dessertske,{0} dessertskeer
        dessert-spoon-imperial,brit. dsk.,,{0}brit.dsk.,{0}brit.dsk.,brit. dsk.,,{0} brit. dsk.,{0} brit. dsk.,britisk dessertske,,{0} britisk dessertske,{0} britiske dessertskeer
        dram,br. fl. dr.,,{0}br.fl.dr.,{0}br.fl.dr.,br. fl. dr.,,{0} br. fl. dr.,{0} br. fl. dr.,britisk flydende dram,,{0} britisk flydende dram,{0} britiske flydende dramme
        drop,dråbe,,{0} dråbe,{0} dråber,dråbe,,{0} dråbe,{0} dråber,dråbe,,{0} dråbe,{0} dråber
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,engelske fluid ounces,,{0} engelsk fluid ounce,{0} engelske fluid ounces
        fluid-ounce-imperial,Imp. fl oz,,{0}fl oz Im,{0}fl oz Im,,,,,Imp. fl oz,,{0} Imp. fluid ounce,{0} Imp. fluid ounces
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,gallons,{0}/gal,{0} gallon,{0} gallons
        gallon-imperial,eng. gal,{0} eng. gal,{0} eng. gal,{0} eng. gal,eng. gal,{0} eng. gal,{0} eng. gal,{0} eng. gal,engelske gallons,{0}/engelsk gallon,{0} engelsk gallon,{0} engelske gallons
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hektoliter,,{0} hektoliter,{0} hektoliter
        liter,,,,,,,,,liter,{0}/l,{0} liter,{0} liter
        megaliter,,,,,,,,,megaliter,,{0} megaliter,{0} megaliter
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,milliliter,,{0} milliliter,{0} milliliter
        pinch,knsp.,,{0} knsp.,{0} knsp.,knsp.,,{0} knsp.,{0} knsp.,knivspids,,{0} knivspids,{0} knivspidser
        pint,,,,,,,,,pints,,{0} pint,{0} pints
        pint-metric,mpt,,{0} mpt,{0} mpt,mpt,,mpt,{0} mpt,metriske pints,,{0} metrisk pint,{0} metriske pints
        quart,,,,,,,,,engelske quarts,,{0} engelsk quart,{0} engelske quarts
        quart-imperial,britisk qt,,{0} br. qt.,{0} br. qt.,britisk qt,,{0} britisk qt,{0} britiske qt,britisk quart,,{0} britisk quart,{0} britiske quarts
        tablespoon,spsk.,,{0} spsk.,{0} spsk.,spsk.,,{0} spsk.,{0} spsk.,spiseskeer,,{0} spiseske,{0} spiseskeer
        teaspoon,tsk.,,{0} tsk.,{0} tsk.,tsk.,,{0} tsk.,{0} tsk.,teskeer,,{0} teske,{0} teskeer
        """.trimIndent()
  }

  private val da_Prefixes: String by lazy {
    """square,,,kvadrat{0}
        cubic,,,kubik{0}
        per,,,{0} pr. {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobi{0}
        10p-1,,,deci{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,milli{0}
        10p-30,,,quecto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hekto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val da_GL_Units: String? = null

  private val da_GL_Prefixes: String? = null

  private val dav_Units: String? = null

  private val dav_Prefixes: String? = null

  private val de_Units: String by lazy {
    """g-force,G,,{0}G,{0}G,g-Kraft,,,{0} G,g-Kraft,,,{0} G
        meter-per-square-second,,,,,,,,,Meter pro Quadratsekunde,,{0} Meter pro Quadratsekunde,{0} Meter pro Quadratsekunde
        arc-minute,′,,,{0}′,Winkelminuten,,,{0}′,Winkelminuten,,{0} Winkelminute,{0} Winkelminuten
        arc-second,″,,,{0}″,Winkelsekunden,,,{0}″,Winkelsekunden,,{0} Winkelsekunde,{0} Winkelsekunden
        degree,°,,,{0}°,Grad,,,{0}°,Grad,,{0} Grad,{0} Grad
        radian,rad,,{0}rad,{0}rad,,,,,Radiant,,{0} Radiant,{0} Radiant
        revolution,U,,{0} U,{0} U,Umdr.,,{0} Umdr.,{0} Umdr.,Umdrehung,,{0} Umdrehung,{0} Umdrehungen
        acre,ac,,,{0} ac,ac,,,{0} ac,Acres,,{0} Acre,{0} Acres
        dunam,Dunam,,{0} Dunam,{0} Dunam,Dunams,,{0} Dunam,{0} Dunam,Dunams,,{0} Dunam,{0} Dunams
        hectare,ha,,,{0} ha,Hektar,,,{0} ha,Hektar,,{0} Hektar,{0} Hektar
        square-centimeter,,,,,,,,,Quadratzentimeter,{0} pro Quadratzentimeter,{0} Quadratzentimeter,{0} Quadratzentimeter
        square-foot,,,,,,,,,Quadratfuß,,{0} Quadratfuß,{0} Quadratfuß
        square-inch,,,,,,,,,Quadratzoll,{0} pro Quadratzoll,{0} Quadratzoll,{0} Quadratzoll
        square-kilometer,,,,,,,,,Quadratkilometer,{0} pro Quadratkilometer,{0} Quadratkilometer,{0} Quadratkilometer
        square-meter,,,,,,,,,Quadratmeter,{0} pro Quadratmeter,{0} Quadratmeter,{0} Quadratmeter
        square-mile,,,,,,,,,Quadratmeilen,{0} pro Quadratmeile,{0} Quadratmeile,{0} Quadratmeilen
        square-yard,,,,,,,,,Quadratyards,,{0} Quadratyard,{0} Quadratyards
        item,Elem.,,{0} Elem.,{0} Elem.,Element,,{0} Element,{0} Elemente,Elemente,,{0} Element,{0} Elemente
        karat,kt,,{0}kt,{0}kt,Karat,,,{0} kt,Karat,,{0} Karat,{0} Karat
        milligram-ofglucose-per-deciliter,mg/dl,,{0}mg/dl,{0}mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,Milligramm pro Deziliter,,{0} Milligramm pro Deziliter,{0} Milligramm pro Deziliter
        millimole-per-liter,mmol/l,,{0}mmol/l,{0}mmol/l,Millimol/Liter,,{0} mmol/l,{0} mmol/l,Millimol pro Liter,,{0} Millimol pro Liter,{0} Millimol pro Liter
        mole,mol,,{0}mol,{0}mol,,,,,Mole,,{0} Mol,{0} Mol
        percent,%,,{0} %,{0} %,%,,{0} %,{0} %,Prozent,,{0} Prozent,{0} Prozent
        permille,‰,,{0}‰,{0}‰,‰,,{0} ‰,{0} ‰,Promille,,{0} Promille,{0} Promille
        permillion,,,,,,,,,Millionstel,,{0} Millionstel,{0} Millionstel
        permyriad,‱,,{0} ‱,{0} ‱,‱,,{0} ‱,{0} ‱,Pro-Zehntausend,,{0} pro Zehntausend,{0} pro Zehntausend
        portion-per-1e9,Milliardstel,,{0} Milliardstel,{0} Milliardstel,Milliardstel,,{0} Milliardstel,{0} Milliardstel,Milliardstel,,{0} Milliardstel,{0} Milliardstel
        liter-per-100-kilometer,L/100km,,{0}L/100km,{0}L/100km,L/100 km,,{0} L/100 km,{0} L/100 km,Liter pro 100 Kilometer,,{0} Liter pro 100 Kilometer,{0} Liter pro 100 Kilometer
        liter-per-kilometer,l/km,,{0}l/km,{0}l/km,l/km,,{0} l/km,{0} l/km,Liter pro Kilometer,,{0} Liter pro Kilometer,{0} Liter pro Kilometer
        mile-per-gallon,mpg,,{0}mpg,{0}mpg,mpg,,{0} mpg,{0} mpg,Meilen pro Gallone,,{0} Meile pro Gallone,{0} Meilen pro Gallone
        mile-per-gallon-imperial,mpg UK,,{0} mpg UK,{0} mpg UK,Meilen/ Imp. Gal.,,,{0} mpg Imp.,Meilen pro Imp. Gallone,,{0} Meile pro Imp. Gallone,{0} Meilen pro Imp. Gallone
        bit,b,,{0} b,{0} b,Bit,,{0} Bit,{0} Bit,Bits,,{0} Bit,{0} Bit
        byte,B,,{0} B,{0} B,Byte,,{0} Byte,{0} Byte,Bytes,,{0} Byte,{0} Byte
        gigabit,Gb,,{0} Gb,{0} Gb,Gigabit,,{0} Gb,{0} Gb,Gigabits,,{0} Gigabit,{0} Gigabit
        gigabyte,GB,,{0} GB,{0} GB,Gigabyte,,{0} GB,{0} GB,Gigabytes,,{0} Gigabyte,{0} Gigabyte
        kilobit,,,,,kbit,,,{0} kb,Kilobits,,{0} Kilobit,{0} Kilobit
        kilobyte,,,,,kbyte,,,{0} kB,Kilobytes,,{0} Kilobyte,{0} Kilobyte
        megabit,,,,,Mbit,,,{0} Mb,Megabits,,{0} Megabit,{0} Megabit
        megabyte,,,,,Mbyte,,,{0} MB,Megabytes,,{0} Megabyte,{0} Megabyte
        petabyte,,,,,,,,,Petabytes,,{0} Petabyte,{0} Petabyte
        terabit,,,,,,,,,Terabits,,{0} Terabit,{0} Terabit
        terabyte,,,,,,,,,Terabytes,,{0} Terabyte,{0} Terabyte
        century,Jh.,,{0} Jh.,{0} Jh.,Jh.,,{0} Jh.,{0} Jh.,Jahrhunderte,,{0} Jahrhundert,{0} Jahrhunderte
        day,T,{0}/T,{0} T,{0} T,Tg.,{0}/T,{0} Tg.,{0} Tg.,Tage,{0} pro Tag,{0} Tag,{0} Tage
        decade,Jz.,,{0} Jz.,{0} Jz.,Jz.,,{0} Jz.,{0} Jz.,Jahrzehnte,,{0} Jahrzehnt,{0} Jahrzehnte
        hour,Std.,{0}/h,{0} Std.,{0} Std.,Std.,{0}/h,{0} Std.,{0} Std.,Stunden,{0} pro Stunde,{0} Stunde,{0} Stunden
        microsecond,,,,,,,,,Mikrosekunden,,{0} Mikrosekunde,{0} Mikrosekunden
        millisecond,,,,,,,,,Millisekunden,,{0} Millisekunde,{0} Millisekunden
        minute,min,{0}/min,{0} Min.,{0} Min.,min,{0}/min,{0} Min.,{0} Min.,Minuten,{0} pro Minute,{0} Minute,{0} Minuten
        month,M,{0}/M,{0} M,{0} M,Mon.,{0}/M,{0} Mon.,{0} Mon.,Monate,{0} pro Monat,{0} Monat,{0} Monate
        nanosecond,,,,,,,,,Nanosekunden,,{0} Nanosekunde,{0} Nanosekunden
        night,Nächte,{0}/Nacht,{0}Nacht,{0}Nächte,Nächte,{0}/Nacht,{0} Nacht,{0} Nächte,Übernachtungen,{0} pro Übernachtung,{0} Übernachtung,{0} Übernachtungen
        quarter,Q,{0}/Q,{0} Q,{0} Q,Quart.,{0}/Quart.,{0} Quart.,{0} Quart.,Quartale,{0}/Quartal,{0} Quartal,{0} Quartale
        second,Sek.,{0}/s,{0} Sek.,{0} Sek.,Sek.,{0}/s,{0} Sek.,{0} Sek.,Sekunden,{0} pro Sekunde,{0} Sekunde,{0} Sekunden
        week,W,{0}/W,{0} W,{0} W,Wo.,{0}/W,{0} Wo.,{0} Wo.,Wochen,{0} pro Woche,{0} Woche,{0} Wochen
        year,J,{0}/J,{0} J,{0} J,J,{0}/J,{0} J,{0} J,Jahre,{0} pro Jahr,{0} Jahr,{0} Jahre
        ampere,A,,{0}A,{0}A,Ampere,,,{0} A,Ampere,,{0} Ampere,{0} Ampere
        milliampere,mA,,{0}mA,{0}mA,,,,,Milliampere,,{0} Milliampere,{0} Milliampere
        ohm,Ω,,{0}Ω,{0}Ω,Ohm,,,{0} Ω,Ohm,,{0} Ohm,{0} Ohm
        volt,V,,{0}V,{0}V,Volt,,,{0} V,Volt,,{0} Volt,{0} Volt
        british-thermal-unit,,,,,,,,,British thermal units,,{0} British thermal unit,{0} British thermal units
        calorie,,,,,,,,,Kalorien,,{0} Kalorie,{0} Kalorien
        electronvolt,,,,,,,,,Elektronenvolt,,{0} Elektronenvolt,{0} Elektronenvolt
        foodcalorie,,,,,,,,,Kilokalorien,,{0} Kilokalorie,{0} Kilokalorien
        joule,J,,{0}J,{0}J,Joule,,{0} J,{0} J,Joule,,{0} Joule,{0} Joule
        kilocalorie,,,,,,,,,Kilokalorien,,{0} Kilokalorie,{0} Kilokalorien
        kilojoule,,,,,Kilojoule,,,{0} kJ,Kilojoule,,{0} Kilojoule,{0} Kilojoule
        kilowatt-hour,,,,,,,,,Kilowattstunden,,{0} Kilowattstunde,{0} Kilowattstunden
        therm-us,,,,,,,,,US thermal units,,{0} US thermal unit,{0} US thermal units
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0} kWh/100km,{0} kWh/100km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,Kilowattstunde pro 100 Kilometer,,{0} Kilowattstunde pro 100 Kilometer,{0} Kilowattstunden pro 100 Kilometer
        newton,N,,{0}N,{0}N,,,,,Newton,,{0} Newton,{0} Newton
        pound-force,lbf,,{0}lbf,{0}lbf,,,,,Pound-force,,{0} Pound-force,{0} Pound-force
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,Gigahertz,,{0} Gigahertz,{0} Gigahertz
        hertz,Hz,,{0}Hz,{0}Hz,,,,,Hertz,,{0} Hertz,{0} Hertz
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,Kilohertz,,{0} Kilohertz,{0} Kilohertz
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,Megahertz,,{0} Megahertz,{0} Megahertz
        dot,d,,{0} d,{0} d,Dots,,{0} d,{0} d,Dots,,{0} Dot,{0} Dots
        dot-per-centimeter,dpcm,,{0} dpcm,{0} dpcm,dpcm,,{0} dpcm,{0} dpcm,Dots pro Zentimeter,,{0} Dot pro Zentimeter,{0} Dots pro Zentimeter
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,Dots pro Inch,,{0} Dot pro Inch,{0} Dots pro Inch
        megapixel,,,,,,,,,Megapixel,,{0} Megapixel,{0} Megapixel
        pixel,,,,,,,,,Pixel,,{0} Pixel,{0} Pixel
        pixel-per-centimeter,,,,,,,,,Pixel pro Zentimeter,,{0} Pixel pro Zentimeter,{0} Pixel pro Zentimeter
        pixel-per-inch,,,,,,,,,Pixel pro Inch,,{0} Pixel pro Inch,{0} Pixel pro Inch
        astronomical-unit,AE,,{0}AE,{0}AE,AE,,{0} AE,{0} AE,Astronomische Einheiten,,{0} Astronomische Einheit,{0} Astronomische Einheiten
        centimeter,,,,,,,,,Zentimeter,{0} pro Zentimeter,{0} Zentimeter,{0} Zentimeter
        decimeter,,,,,,,,,Dezimeter,,{0} Dezimeter,{0} Dezimeter
        earth-radius,,,,,,,,,Erdradius,,{0} Erdradius,{0} Erdradien
        fathom,Faden,,{0}fm,{0}fm,Faden,,{0} fm,{0} fm,Nautischer Faden,,{0} Faden,{0} Faden
        foot,,,,,Fuß,{0}/ft,,{0} ft,Fuß,{0} pro Fuß,{0} Fuß,{0} Fuß
        furlong,Furlong,,{0}fur,{0}fur,Furlong,,,{0} fur,Furlongs,,{0} Furlong,{0} Furlong
        inch,in,{0}/in,{0} in,{0} in,in,{0}/in,{0} in,{0} in,Zoll,{0} pro Zoll,{0} Zoll,{0} Zoll
        kilometer,,,,,,,,,Kilometer,{0} pro Kilometer,{0} Kilometer,{0} Kilometer
        light-year,Lj,,{0}Lj,{0}Lj,Lj,,{0} Lj,{0} Lj,Lichtjahre,,{0} Lichtjahr,{0} Lichtjahre
        meter,Meter,{0}/m,,{0} m,Meter,{0}/m,,{0} m,Meter,{0} pro Meter,{0} Meter,{0} Meter
        micrometer,,,,,,,,,Mikrometer,,{0} Mikrometer,{0} Mikrometer
        mile,,,,,Meilen,,,{0} mi,Meilen,,{0} Meile,{0} Meilen
        mile-scandinavian,smi,,{0}smi,{0}smi,,,,,skandinavische Meilen,,{0} skandinavische Meile,{0} skandinavische Meilen
        millimeter,,,,,,,,,Millimeter,,{0} Millimeter,{0} Millimeter
        nanometer,,,,,,,,,Nanometer,,{0} Nanometer,{0} Nanometer
        nautical-mile,sm,,{0}sm,{0}sm,sm,,{0} sm,{0} sm,Seemeilen,,{0} Seemeile,{0} Seemeilen
        parsec,,,,,,,,,Parsec,,{0} Parsec,{0} Parsec
        picometer,,,,,Pikometer,,,{0} pm,Pikometer,,{0} Pikometer,{0} Pikometer
        point,p,,{0} p,{0} p,p,,{0} p,{0} p,DTP-Punkte,,{0} DTP-Punkt,{0} DTP-Punkte
        solar-radius,R☉,,{0}R☉,{0}R☉,,,,,Sonnenradien,,{0} Sonnenradius,{0} Sonnenradien
        yard,,,,,Yards,,,{0} yd,Yards,,{0} Yard,{0} Yards
        candela,cd,,{0}cd,{0}cd,,,,,Candela,,{0} Candela,{0} Candela
        lumen,lm,,{0}lm,{0}lm,,,,,Lumen,,{0} Lumen,{0} Lumen
        lux,lx,,{0}lx,{0}lx,Lux,,,{0} lx,Lux,,{0} Lux,{0} Lux
        solar-luminosity,L☉,,{0}L☉,{0}L☉,,,,,Sonnenleuchtkräfte,,{0} Sonnenleuchtkraft,{0} Sonnenleuchtkräfte
        carat,Karat,,{0} Kt,{0} Kt,Kt,,{0} Kt,{0} Kt,Karat,,{0} Karat,{0} Karat
        dalton,,,,,,,,,Dalton,,{0} Dalton,{0} Dalton
        earth-mass,,,,,,,,,Erdmassen,,{0} Erdmasse,{0} Erdmassen
        grain,gr,,{0} gr,{0} gr,Gran,,{0} gr,{0} gr,Gran,,{0} Gran,{0} Gran
        gram,Gramm,{0}/g,,{0} g,Gramm,{0}/g,,{0} g,Gramm,{0} pro Gramm,{0} Gramm,{0} Gramm
        kilogram,,,,,,,,,Kilogramm,{0} pro Kilogramm,{0} Kilogramm,{0} Kilogramm
        microgram,,,,,,,,,Mikrogramm,,{0} Mikrogramm,{0} Mikrogramm
        milligram,,,,,,,,,Milligramm,,{0} Milligramm,{0} Milligramm
        ounce,Unzen,{0}/oz,,{0} oz,,,,,Unzen,{0} pro Unze,{0} Unze,{0} Unzen
        ounce-troy,oz.tr.,,{0} oz.tr.,{0} oz.tr.,oz.tr.,,{0} oz.tr.,{0} oz.tr.,Feinunzen,,{0} Feinunze,{0} Feinunzen
        pound,Pfund,{0}/lb,,{0} lb,,,,,Pfund,{0} pro Pfund,{0} Pfund,{0} Pfund
        solar-mass,,,,,,,,,Sonnenmassen,,{0} Sonnenmasse,{0} Sonnenmassen
        stone,Stones,,,{0} st,Stones,,,{0} st,Stones,,{0} Stone,{0} Stones
        ton,Tons,,{0} tn,{0} tn,tn. sh.,,{0} tn. sh.,{0} tn. sh.,Short Tons,,{0} Short Ton,{0} Short Tons
        tonne,,,,,,,,,Tonnen,,{0} Tonne,{0} Tonnen
        gigawatt,,,,,,,,,Gigawatt,,{0} Gigawatt,{0} Gigawatt
        horsepower,PS,,{0} PS,{0} PS,PS,,{0} PS,{0} PS,Pferdestärke,,{0} Pferdestärke,{0} Pferdestärken
        kilowatt,,,,,,,,,Kilowatt,,{0} Kilowatt,{0} Kilowatt
        megawatt,,,,,,,,,Megawatt,,{0} Megawatt,{0} Megawatt
        milliwatt,,,,,,,,,Milliwatt,,{0} Milliwatt,{0} Milliwatt
        watt,W,,,{0} W,Watt,,,{0} W,Watt,,{0} Watt,{0} Watt
        atmosphere,,,,,,,,,Atmosphären,,{0} Atmosphäre,{0} Atmosphären
        bar,,,,,,,,,Bar,,{0} Bar,{0} Bar
        hectopascal,,,,,,,,,Hektopascal,,{0} Hektopascal,{0} Hektopascal
        inch-ofhg,,,,,,,,,Zoll Quecksilbersäule,,{0} Zoll Quecksilbersäule,{0} Zoll Quecksilbersäule
        kilopascal,,,,,,,,,Kilopascal,,{0} Kilopascal,{0} Kilopascal
        megapascal,,,,,,,,,Megapascal,,{0} Megapascal,{0} Megapascal
        millibar,Millibar,,,{0} mbar,Millibar,,,{0} mbar,Millibar,,{0} Millibar,{0} Millibar
        millimeter-ofhg,,,,,,,,,Millimeter Quecksilbersäule,,{0} Millimeter Quecksilbersäule,{0} Millimeter Quecksilbersäule
        pascal,,,,,,,,,Pascal,,{0} Pascal,{0} Pascal
        pound-force-per-square-inch,,,,,,,,,Pfund pro Quadratzoll,,{0} Pfund pro Quadratzoll,{0} Pfund pro Quadratzoll
        beaufort,,,,,,,,,Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,,,,,,,,,Kilometer pro Stunde,,{0} Kilometer pro Stunde,{0} Kilometer pro Stunde
        knot,,,,,,,,,Knoten,,{0} Knoten,{0} Knoten
        meter-per-second,,,,,,,,,Meter pro Sekunde,,{0} Meter pro Sekunde,{0} Meter pro Sekunde
        mile-per-hour,,,,,,,,,Meilen pro Stunde,,{0} Meile pro Stunde,{0} Meilen pro Stunde
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,Grad Celsius,,{0} Grad Celsius,{0} Grad Celsius
        fahrenheit,°F,,{0}°F,{0}°F,°F,,{0} °F,{0} °F,Grad Fahrenheit,,{0} Grad Fahrenheit,{0} Grad Fahrenheit
        generic,,,,,,,,,°,,{0} Grad,{0} Grad
        kelvin,,,,,,,,,Kelvin,,{0} Kelvin,{0} Kelvin
        newton-meter,N⋅m,,{0}N⋅m,{0}N⋅m,,,,,Newtonmeter,,{0} Newtonmeter,{0} Newtonmeter
        pound-force-foot,lbf⋅ft,,{0}lbf⋅ft,{0}lbf⋅ft,,,,,Foot-pound,,{0} Foot-pound,{0} Foot-pound
        acre-foot,,,,,Acre-Feet,,,{0} ac ft,Acre-Feet,,{0} Acre-Foot,{0} Acre-Feet
        barrel,bbl,,{0}bbl,{0}bbl,,,,,Barrel,,{0} Barrel,{0} Barrel
        bushel,Bushel,,,{0} bu,Bushel,,,{0} bu,Bushel,,{0} Bushel,{0} Bushel
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,Zentiliter,,{0} Zentiliter,{0} Zentiliter
        cubic-centimeter,,,,,,,,,Kubikzentimeter,{0} pro Kubikzentimeter,{0} Kubikzentimeter,{0} Kubikzentimeter
        cubic-foot,,,,,,,,,Kubikfuß,,{0} Kubikfuß,{0} Kubikfuß
        cubic-inch,,,,,,,,,Kubikzoll,,{0} Kubikzoll,{0} Kubikzoll
        cubic-kilometer,,,,,,,,,Kubikkilometer,,{0} Kubikkilometer,{0} Kubikkilometer
        cubic-meter,,,,,,,,,Kubikmeter,{0} pro Kubikmeter,{0} Kubikmeter,{0} Kubikmeter
        cubic-mile,,,,,,,,,Kubikmeilen,,{0} Kubikmeile,{0} Kubikmeilen
        cubic-yard,,,,,,,,,Kubikyards,,{0} Kubikyard,{0} Kubikyards
        cup,Cups,,{0} Cup,{0} Cups,Cups,,{0} Cup,{0} Cups,Tassen,,{0} Tasse,{0} Tassen
        cup-metric,Ta,,{0} Ta,{0} Ta,Ta,,{0} Ta,{0} Ta,metrische Tassen,,{0} metrische Tasse,{0} metrische Tassen
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,Deziliter,,{0} Deziliter,{0} Deziliter
        dessert-spoon,DL,,{0} DL,{0} DL,DL,,{0} DL,{0} DL,Dessertlöffel,,{0} Dessertlöffel,{0} Dessertlöffel
        dessert-spoon-imperial,Imp. DL,,{0} Imp.DL,{0} Imp.DL,Imp. DL,,{0} Imp. DL,{0} Imp. DL,Imp. Dessertlöffel,,{0} Imp. Dessertlöffel,{0} Imp. Dessertlöffel
        dram,fl.dr.,,{0} fl.dr.,{0} fl.dr.,Flüssigdram,,{0} Fl.-Dram,{0} Fl.-Dram,Dram,,{0} Dram,{0} Dram
        drop,Tr.,,{0} Tr.,{0} Tr.,Trpf.,,{0} Trpf.,{0} Trpf.,Tropfen,,{0} Tropfen,{0} Tropfen
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,Flüssigunzen,,{0} Flüssigunze,{0} Flüssigunzen
        fluid-ounce-imperial,Im.fl.oz,,{0} Im.fl.oz,{0} Im.fl.oz,Imp.fl.oz.,,{0} Imp.fl.oz.,{0} Imp.fl.oz.,Imp. Flüssigunzen,,{0} Imp. Flüssigunze,{0} Imp. Flüssigunzen
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,Gallone,{0} pro Gallone,{0} Gallone,{0} Gallonen
        gallon-imperial,Imp.gal,{0}/Imp.gal,{0} Imp.gal,{0} Imp.gal,Imp. gal,{0} pro Imp. gal,{0} Imp. gal,{0} Imp. gal,Imp. Gallonen,{0} pro Imp. Gallone,{0} Imp. Gallone,{0} Imp. Gallonen
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,Hektoliter,,{0} Hektoliter,{0} Hektoliter
        jigger,Jigger,,{0} Jigger,{0} Jigger,Jigger,,{0} Jigger,{0} Jigger,Jigger,,{0} Jigger,{0} Jigger
        liter,l,{0}/l,,{0} l,Liter,{0}/l,,{0} l,Liter,{0} pro Liter,{0} Liter,{0} Liter
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,Megaliter,,{0} Megaliter,{0} Megaliter
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,Milliliter,,{0} Milliliter,{0} Milliliter
        pinch,Pr.,,{0} Pr,{0} Pr,Prise,,{0} Pr.,{0} Pr.,Prise,,{0} Prise,{0} Prisen
        pint,,,,,,,,,Pints,,{0} Pint,{0} Pints
        pint-metric,,,,,,,,,metrische Pints,,{0} metrisches Pint,{0} metrische Pints
        quart,,,,,,,,,Quarts,,{0} Quart,{0} Quart
        quart-imperial,Imp.qt,,{0} Imp.qt,{0} Imp.qt,Imp.qt.,,{0} Imp.qt.,{0} Imp.qt.,Imp. Quart,,{0} Imp. Quart,{0} Imp. Quart
        tablespoon,EL,,{0} EL,{0} EL,EL,,{0} EL,{0} EL,Esslöffel,,{0} Esslöffel,{0} Esslöffel
        teaspoon,TL,,{0} TL,{0} TL,TL,,{0} TL,{0} TL,Teelöffel,,{0} Teelöffel,{0} Teelöffel
        """.trimIndent()
  }

  private val de_Prefixes: String by lazy {
    """square,,,Quadrat{0}
        cubic,,,Kubik{0}
        per,,,{0} pro {1}
        1024p1,,,Kibi{0}
        1024p2,,,Mebi{0}
        1024p3,,,Gibi{0}
        1024p4,,,Tebi{0}
        1024p5,,,Pebi{0}
        1024p6,,,Exbi{0}
        1024p7,,,Zebi{0}
        1024p8,,,Yobi{0}
        10p-1,,,Dezi{0}
        10p-12,,,Piko{0}
        10p-15,,,Femto{0}
        10p-18,,,Atto{0}
        10p-2,,,Zenti{0}
        10p-21,,,Zepto{0}
        10p-24,,,Yokto{0}
        10p-27,,,Ronto{0}
        10p-3,,,Milli{0}
        10p-30,,,Quekto{0}
        10p-6,,,Mikro{0}
        10p-9,,,Nano{0}
        10p1,,,Deka{0}
        10p12,,,Tera{0}
        10p15,,,Peta{0}
        10p18,,,Exa{0}
        10p2,,,Hekto{0}
        10p21,,,Zetta{0}
        10p24,,,Yotta{0}
        10p27,,,Ronna{0}
        10p3,,,Kilo{0}
        10p30,,,Quetta{0}
        10p6,,,Mega{0}
        10p9,,,Giga{0}
        """.trimIndent()
  }

  private val de_AT_Units: String? = null

  private val de_AT_Prefixes: String? = null

  private val de_BE_Units: String? = null

  private val de_BE_Prefixes: String? = null

  private val de_CH_Units: String by lazy {
    """square-foot,,,,,,,,,Quadratfuss,,{0} Quadratfuss,{0} Quadratfuss
        quarter,,,,,Quartal,{0}/Quart.,{0} Quart.,{0} Quart.,Quartal,{0}/Quartal,{0} Quartal,{0} Quartale
        foot,,,,,Fuss,{0}/ft,,{0} ft,Fuss,{0} pro Fuss,{0} Fuss,{0} Fuss
        beaufort,Bft,,{0} Bft,{0} Bft,Bft,,{0} Bft,{0} Bft,Beaufort,,{0} Beaufort,{0} Beaufort
        cubic-foot,,,,,,,,,Kubikfuss,,{0} Kubikfuss,{0} Kubikfuss
        jigger,Schuss,,{0} Schuss,{0} Schuss,Schuss,,{0} Schuss,{0} Schuss,Schuss,,{0} Jigger,{0} Jigger
        dram,,,,,Dram,,{0} dr.,{0} dr.,,,,
        pinch,,,,,Prise,,{0} Prise,{0} Prise,,,,
        """.trimIndent()
  }

  private val de_CH_Prefixes: String? = null

  private val de_IT_Units: String? = null

  private val de_IT_Prefixes: String? = null

  private val de_LI_Units: String? = null

  private val de_LI_Prefixes: String? = null

  private val de_LU_Units: String? = null

  private val de_LU_Prefixes: String? = null

  private val dje_Units: String? = null

  private val dje_Prefixes: String? = null

  private val doi_Units: String by lazy {
    """g-force,ग्रै-फोर्स,,,{0} G,ग्रै-फोर्स,,,{0} G,ग्रै-फोर्स,,,{0} G
        meter-per-square-second,मीटर/स²,,,{0} m/s²,मीटर/सकिं²,,,{0} m/s²,मीटर फी सकिंट²,,,{0} m/s²
        arc-minute,आर्क मिंट,,,{0}′,आर्क मिंट,,,{0}′,आर्क मिंट,,,{0}′
        arc-second,आर्कसकिं,,,{0}″,आर्क सकिं,,,{0}″,आर्क सकिंट,,,{0}″
        degree,डिग.,,,{0}°,डिग्रियां,,,{0}°,डिग्रियां,,,{0}°
        radian,रेडि,,,{0} rad,रेडियन,,,{0} rad,रेडियन,,,{0} rad
        revolution,घमघेरा,,,{0} rev,घमघेरे,,,{0} rev,घमघेरे,,,{0} rev
        acre,किल्ला,,,{0} ac,किल्ले,,,{0} ac,किल्ले,,,{0} ac
        dunam,डोनम,,,{0} dunam,डोनम,,,{0} dunam,डोनम,,,{0} dunam
        hectare,हैक्टर,,,{0} ha,हैक्टर,,,{0} ha,हैक्टर,,,{0} ha
        square-centimeter,व.सैंमी,{0}/cm²,,{0} cm²,व. सैं.मी.,{0}/cm²,,{0} cm²,वर्ग सैंटीमीटर,{0}/cm²,,{0} cm²
        square-foot,वफु,,,{0} ft²,व.फु.,,,{0} ft²,वर्ग फुट,,,{0} ft²
        square-inch,वइं,{0}/in²,,{0} in²,व.इं॰,{0}/in²,,{0} in²,वर्ग इंच,{0}/in²,,{0} in²
        square-kilometer,व. किमी,{0}/km²,,{0} km²,व. कि.मी.,{0}/km²,,{0} km²,वर्ग किलोमीटर,{0}/km²,,{0} km²
        square-meter,व. मीटर,{0}/m²,,{0} m²,व. मीटर,{0}/m²,,{0} m²,वर्ग मीटर,{0}/m²,,{0} m²
        square-mile,व.मील,{0}/mi²,,{0} mi²,व.मील,{0}/mi²,,{0} mi²,वर्ग मील,{0}/mi²,,{0} mi²
        square-yard,वग,,,{0} yd²,व.गज,,,{0} yd²,वर्ग गज,,,{0} yd²
        karat,कैरट,,,{0} kt,कैरट,,,{0} kt,कैरट,,,{0} kt
        milligram-ofglucose-per-deciliter,मि॰ग्रा॰/डैली,,,{0} mg/dL,मि॰ग्रा॰/डै.ली.,,,{0} mg/dL,मिलिग्राम फी डैसीलीटर,,,{0} mg/dL
        millimole-per-liter,मिलीमोल/ली,,,{0} mmol/L,मिलीमोल/लीटर,,,{0} mmol/L,मिलीमोल फी लीटर,,,{0} mmol/L
        mole,मोल,,,{0} mol,मोल,,,{0} mol,मोल,,,{0} mol
        percent,प्रतिशत/फीसदी,,,{0}%,प्रतिशत/फीसदी,,,{0}%,प्रतिशत/फीसदी,,,{0}%
        permille,फी ज्हार,,,{0}‰,फी ज्हार,,,{0}‰,फी ज्हार,,,{0}‰
        permillion,हिफीदल,,,{0} ppm,हिस्से/दस लक्ख,,,{0} ppm,हिस्से फी दस लक्ख,,,{0} ppm
        permyriad,,,,,,,,,फी दस ज्हार,,,{0}‱
        liter-per-100-kilometer,ली/100 किमी,,,{0} L/100km,ली./100 कि.मी.,,,{0} L/100km,लीटर प्रति 100 किलोमीटर,,,{0} L/100km
        liter-per-kilometer,लीटर/किमी,,,{0} L/km,लीटर/किमी,,,{0} L/km,लीटर प्रति किलोमीटर,,,{0} L/km
        mile-per-gallon,मील/गै,,,{0} mpg US,मील/गैल,,,{0} mpg US,मील प्रति गैलन,,,{0} mpg US
        mile-per-gallon-imperial,मी/गै यूके,,{0}m/gUK,{0}m/gUK,मील/गैल इंपी.,,,{0} mpg Imp.,मील प्रति इंपीरियल गैलन,,,{0} mpg Imp.
        bit,बिट,,,{0} bit,बिट,,,{0} bit,बिट,,,{0} bit
        byte,बा,,,{0} byte,बाइट,,,{0} byte,बाइट,,,{0} byte
        gigabit,गीबि,,,{0} Gb,गीबिट,,,{0} Gb,गीगाबिट,,,{0} Gb
        gigabyte,गीबा,,,{0} GB,गीबाइट,,,{0} GB,गीगाबाइट,,,{0} GB
        kilobit,किबी,,,{0} kb,किबिट,,,{0} kb,किलोबिट,,,{0} kb
        kilobyte,किबा,,,{0} kB,किबाइट,,,{0} kB,किलोबाइट,,,{0} kB
        megabit,मैबि,,,{0} Mb,मैबिट,,,{0} Mb,मैगाबिट,,,{0} Mb
        megabyte,मैबा,,,{0} MB,मैबाइट,,,{0} MB,मैगाबाइट,,,{0} MB
        petabyte,पेबा,,,{0} PB,पेबाइट,,,{0} PB,पेटाबाइट,,,{0} PB
        terabit,टैबा,,,{0} Tb,,,,,टैराबिट,,,{0} Tb
        terabyte,टैबा,,,{0} TB,टैबाइट,,,{0} TB,टैराबाइट,,,{0} TB
        century,स.,,,{0} c,स.,,,{0} c,सदियां,,,{0} c
        day,दिन,{0}/d,,{0} d,दिन,{0}/d,,{0} d,दिन,{0}/d,,{0} d
        decade,द्हा.,,,{0} dec,द्हा.,,,{0} dec,द्हाके,,,{0} dec
        hour,घैंटा,{0}/h,,{0} h,घैंटे,{0}/h,,{0} h,घैंटे,{0}/h,,{0} h
        microsecond,मासकिं,,,{0} μs,माइक्रोसकिं,,,{0} μs,माइक्रोसकिंट,,,{0} μs
        millisecond,मि.सकिं,,,{0} ms,मिलीसकिं.,,,{0} ms,मिलीसकिंट,,,{0} ms
        minute,मिं,{0}/min,,{0} min,मिं.,{0}/min,,{0} min,मिंट,{0}/min,,{0} min
        month,म्हीना,{0}/m,,{0} m,म्हीने,{0}/m,,{0} m,म्हीने,{0}/m,,{0} m
        nanosecond,नैसकिं,,,{0} ns,नैनो सकिं,,,{0} ns,नैनो सकिंट,,,{0} ns
        quarter,त्रमा.,{0}/q,,{0} q,त्रमा.,{0}/q,,{0} q,त्रमाहियां,{0}/q,,{0} q
        second,सकिं,{0}/s,,{0} s,सकिं.,{0}/s,,{0} s,सकिंट,{0}/s,,{0} s
        week,हफ्,{0}/w,,{0} w,हफ्ते,{0}/w,,{0} w,हफ्ते,{0}/w,,{0} w
        year,ब’रा/साल,{0}/y,,{0} y,ब’रे/साल,{0}/y,,{0} y,ब’रे/साल,{0}/y,,{0} y
        ampere,एंपी,,,{0} A,एंपी,,,{0} A,एंपीयर,,,{0} A
        milliampere,मिएं,,,{0} mA,मिलीएंप,,,{0} mA,मिलीएंपीयर,,,{0} mA
        ohm,ओम,,,{0} Ω,ओम,,,{0} Ω,ओम,,,{0} Ω
        volt,वोल्ट,,,{0} V,वोल्ट,,,{0} V,वोल्ट,,,{0} V
        british-thermal-unit,ब्रिथयू,,,{0} Btu,ब्रिथयू,,,{0} Btu,ब्रिटिश थर्मल यूनटां,,,{0} Btu
        calorie,कैल,,,{0} cal,कैल,,,{0} cal,कैलोरियां,,,{0} cal
        electronvolt,इवो,,,{0} eV,इलैक्ट्रॉनवोल्ट,,,{0} eV,इलैक्ट्रॉनवोल्ट,,,{0} eV
        joule,जूल,,,{0} J,जूल,,,{0} J,जूल,,,{0} J
        kilocalorie,किकैल,,,{0} kcal,किकैल,,,{0} kcal,किलो कैलोरी,,,{0} kcal
        kilojoule,किजू,,,{0} kJ,किलो जूल,,,{0} kJ,किलो जूल,,,{0} kJ
        kilowatt-hour,किवॉघैं,,,{0} kWh,किवॉघैं,,,{0} kWh,किलोवॉट-घैंटे,,,{0} kWh
        therm-us,यूऐस्स थर्म,,,{0} US therm,यूऐस्स थर्म,,,{0} US therm,यूऐस्स थर्म,,,{0} US therm
        kilowatt-hour-per-100-kilometer,किवॉघैं/100किमी,,{0}किल्लोवाट/100किमी,{0} किल्लोवाट/100किमी,,,,,किलोवॉट-घैंटे फी 100किलोमीटर,,,{0} kWh/100km
        newton,न्यू.,,,{0} N,न्यूटन,,,{0} N,न्यूटन,,,{0} N
        pound-force,,,,,,,,,पौंड-बल,,,{0} lbf
        gigahertz,,,,,,,,,गीगाहर्ट्ज़,,,{0} GHz
        hertz,,,,,,,,,हर्ट्ज़,,,{0} Hz
        kilohertz,,,,,,,,,किलोहर्ट्ज़,,,{0} kHz
        megahertz,,,,,,,,,मैगाहर्ट्ज़,,,{0} MHz
        em,,,,,,,,,टाइपोग्राफ़िक ऐम्म,,,{0} em
        megapixel,मैगापिक्सल,,,{0} MP,मैगापिक्सल,,,{0} MP,मैगापिक्सल,,,{0} MP
        pixel,पिक्सल,,,{0} px,पिक्सल,,,{0} px,पिक्सल,,,{0} px
        pixel-per-centimeter,,,,,,,,,पिक्सल फी सैंटीमीटर,,,{0} ppcm
        pixel-per-inch,,,,,,,,,पिक्सल फी इंच,,,{0} ppi
        astronomical-unit,खगोयू,,,{0} au,खगो.यू.,,,{0} au,खगोली यूनटां,,,{0} au
        centimeter,सैंमी,{0}/cm,,{0} cm,सैं.मी.,{0}/cm,,{0} cm,सैंटीमीटर,{0}/cm,,{0} cm
        decimeter,डैमी,,,{0} dm,डै.मी.,,,{0} dm,डैसीमीटर,,,{0} dm
        earth-radius,,,,,,,,,धरती दा घेरा,,,{0} R⊕
        fathom,मसातर,,,{0} fth,मसातरां,,,{0} fth,मसातरां,,,{0} fth
        foot,फु.,{0}/ft,,{0} ft,फुट,{0}/ft,,{0} ft,फुट,{0}/ft,,{0} ft
        furlong,फरलांग,,,{0} fur,फरलांग,,,{0} fur,फरलांग,,,{0} fur
        inch,इं.,{0}/in,,{0} in,इंच,{0}/in,,{0} in,इंच,{0}/in,,{0} in
        kilometer,किमी,{0}/km,,{0} km,कि.मी.,{0}/km,,{0} km,किलोमीटर,{0}/km,,{0} km
        light-year,रुब,,,{0} ly,रुशनाई ब’रे,,,{0} ly,रुशनाई ब’रे,,,{0} ly
        meter,मी,{0}/m,,{0} m,मी.,{0}/m,,{0} m,मीटर,{0}/m,,{0} m
        micrometer,मामी,,,{0} μm,मामी,,,{0} μm,माइक्रोमीटर,,,{0} μm
        mile,मील,,,{0} mi,मील,,,{0} mi,मील,,,{0} mi
        mile-scandinavian,,,,,,,,,मील-स्कैण्डिनेवियन,,,{0} smi
        millimeter,मिमी,,,{0} mm,मि.मी.,,,{0} mm,मिलीमीटर,,,{0} mm
        nanometer,नैमी,,,{0} nm,नैमी,,,{0} nm,नैनोमीटर,,,{0} nm
        nautical-mile,नॉमी,,,{0} nmi,नॉमी,,,{0} nmi,नॉटिकल मील,,,{0} nmi
        parsec,पारसेक,,,{0} pc,पारसेक,,,{0} pc,पारसेक,,,{0} pc
        picometer,पिमी,,,{0} pm,पिमी,,,{0} pm,पिकोमीटर,,,{0} pm
        solar-radius,,,,,,,,,सौर अद्धाव्यास,,,{0} R☉
        yard,ग.,,,{0} yd,गज,,,{0} yd,गज,,,{0} yd
        candela,,,,,,,,,कैंडेला,,,{0} cd
        lumen,,,,,,,,,लुमेन,,,{0} lm
        lux,लक्स,,,{0} lx,लक्स,,,{0} lx,लक्स,,,{0} lx
        solar-luminosity,,,,,,,,,सौर चानन,,,{0} L☉
        carat,कैरट,,,{0} CD,कैरट,,,{0} CD,कैरट,,,{0} CD
        dalton,डा,,,{0} Da,डाल्टन,,,{0} Da,डाल्टन,,,{0} Da
        earth-mass,,,,,,,,,धरती पिंड,,,{0} M⊕
        grain,डे. रत्ती,,,{0} grain,डेढ रत्ती,,,{0} grain,डेढ रत्ती,,,{0} grain
        gram,ग्राम,{0}/g,,{0} g,ग्राम,{0}/g,,{0} g,ग्राम,{0}/g,,{0} g
        kilogram,किग्रा,{0}/kg,,{0} kg,कि.ग्रा.,{0}/kg,,{0} kg,किलोग्राम,{0}/kg,,{0} kg
        microgram,माग्रा,,,{0} μg,मा.ग्रा.,,,{0} μg,माइक्रोग्राम,,,{0} μg
        milligram,मिग्रा,,,{0} mg,मि.ग्रा.,,,{0} mg,मिलीग्राम,,,{0} mg
        ounce,औं,{0}/oz,,{0} oz,औं.,{0}/oz,,{0} oz,औंस,{0}/oz,,{0} oz
        ounce-troy,औं.ट्रा,,,{0} oz t,औं. ट्राय,,,{0} oz t,ट्राय औंस,,,{0} oz t
        pound,पौंड,{0}/lb,,{0} lb,पौंड,{0}/lb,,{0} lb,पौंड,{0}/lb,,{0} lb
        solar-mass,,,,,,,,,सौर पिंड,,,{0} M☉
        stone,स्टोन,,,{0} st,स्टोन,,,{0} st,स्टोन,,,{0} st
        tonne,टन,,,{0} t,टन,,,{0} t,मीट्रिक टन,,,{0} t
        gigawatt,मैवॉ,,,{0} GW,मैवॉ,,,{0} GW,गीगावॉट,,,{0} GW
        horsepower,हापा,,,{0} hp,हापा,,,{0} hp,हार्सपावर,,,{0} hp
        kilowatt,किवॉ,,,{0} kW,किवॉ,,,{0} kW,किलोवॉट,,,{0} kW
        milliwatt,मिवॉ,,,{0} mW,मिवॉ,,,{0} mW,मिलीवॉट,,,{0} mW
        watt,वॉट,,,{0} W,वॉट,,,{0} W,वॉट,,,{0} W
        atmosphere,,,,,,,,,वायुमंडली दबाऽ,,,{0} atm
        bar,बार,,,{0} bar,बार,,,{0} bar,बार,,,{0} bar
        hectopascal,,,,,,,,,हैक्टोपास्कल,,,{0} hPa
        inch-ofhg,,,,,,,,,पाराई इंच,,,{0} inHg
        kilopascal,किपा,,,{0} kPa,किपा.,,,{0} kPa,किलोपास्कल,,,{0} kPa
        megapascal,मेपा,,,{0} MPa,मेपा.,,,{0} MPa,मैगापास्कल,,,{0} MPa
        millibar,,,,,,,,,मिलीबार,,,{0} mbar
        millimeter-ofhg,,,,,,,,,पाराई मिलीमीटर,,,{0} mm Hg
        pascal,पा,,,{0} Pa,पा.,,,{0} Pa,पास्कल,,,{0} Pa
        pound-force-per-square-inch,,,,,,,,,पौंड-फोर्स फी वर्ग इंच,,,{0} psi
        kilometer-per-hour,किमी/घैं,,,{0} km/h,कि.मी./घैंटा,,,{0} km/h,किलोमीटर फी घैंटा,,,{0} km/h
        knot,नॉट,,,{0} kn,नॉट,,,{0} kn,नॉट,,,{0} kn
        meter-per-second,मीटर/स,,,{0} m/s,मीटर/सकिं,,,{0} m/s,मीटर प्रति सकिंट,,,{0} m/s
        mile-per-hour,मील/घैं,,,{0} mi/h,मील/घैंटा,,,{0} mi/h,मील प्रति घैंटा,,,{0} mi/h
        celsius,°से॰,,,{0}°C,डिग्री सेल्सियस,,,{0}°C,डिग्री सेल्सियस,,,{0}°C
        fahrenheit,डिग्री फारेनहाइट,,,{0}°F,डिग्री फारेनहाइट,,,{0}°F,डिग्री फारेनहाइट,,,{0}°F
        kelvin,,,,,,,,,केल्विन,,,{0} K
        newton-meter,न्यू.मी.,,,{0} N⋅m,न्यू.मी.,,,{0} N⋅m,न्यूटन-मीटर,,,{0} N⋅m
        pound-force-foot,,,,,,,,,पौंड-फोर्स-फुट,,,{0} lbf⋅ft
        acre-foot,किल्ला फु,,,{0} ac ft,किल्ला फु.,,,{0} ac ft,किल्ला-फुट,,,{0} ac ft
        barrel,बैर.,,,{0} bbl,बैरल,,,{0} bbl,बैरल,,,{0} bbl
        bushel,बुशल,,,{0} bu,बुशल,,,{0} bu,बुशल,,,{0} bu
        centiliter,सैली,,,{0} cL,सैं.ली.,,,{0} cL,सैंटीलीटर,,,{0} cL
        cubic-centimeter,क्यू सैंमी,{0}/cm³,,{0} cm³,क्यू.सैं.मी.,{0}/cm³,,{0} cm³,क्यूबिक सेंटीमीटर,{0}/cm³,,{0} cm³
        cubic-foot,क्यूफु,,,{0} ft³,क्यू. फुट,,,{0} ft³,क्यूबिक फुट,,,{0} ft³
        cubic-inch,क्यूइं,,,{0} in³,क्यू. इंच,,,{0} in³,क्यूबिक इंच,,,{0} in³
        cubic-kilometer,क्यू.किमी,,,{0} km³,क्यू. कि.मी.,,,{0} km³,क्यूबिक किलोमीटर,,,{0} km³
        cubic-meter,क्यू मी,{0}/m³,,{0} m³,क्यू.मी.,{0}/m³,,{0} m³,क्यूबिक मीटर,{0}/m³,,{0} m³
        cubic-mile,क्यू मील,,,{0} mi³,क्यू. मील,,,{0} mi³,क्यूबिक मील,,,{0} mi³
        cubic-yard,क्यूग,,,{0} yd³,क्यू.ग.,,,{0} yd³,क्यूबिक गज,,,{0} yd³
        cup,कप,,,{0} c,कप,,,{0} c,कप,,,{0} c
        cup-metric,मीक,,,{0} mc,मी.क.,,,{0} mc,मीट्रिक कप,,,{0} mc
        deciliter,डैली,,,{0} dL,डै.ली.,,,{0} dL,डैसीलीटर,,,{0} dL
        dessert-spoon,डेस्पून,,,{0} dstspn,डेस्पून,,,{0} dstspn,डेज़र्ट स्पून,,,{0} dstspn
        dessert-spoon-imperial,इंपी डेस्पून,,{0}dsp-Imp,{0}dsp-Imp,इंपी डेस्पून,,,{0} dstspn Imp,इंपी. डेज़र्टस्पून,,,{0} dstspn Imp
        dram,ड्रै.फ्लू.,,,{0} dram fl,ड्रैम फ्लूइड,,,{0} dram fl,ड्रैम फ्लूइड,,,{0} dram fl
        drop,बूंद,,,{0} drop,बूंद,,,{0} drop,बूंद,,,{0} drop
        fluid-ounce,फ्लू. औं.,,,{0} fl oz US,फ्लू. औं.,,,{0} fl oz US,फ्लूइड औंस,,,{0} fl oz US
        gallon,गैल,{0}/gal US,,{0} gal US,गैल.,{0}/gal US,,{0} gal US,गैलनां,{0}/gal US,,{0} gal US
        gallon-imperial,इंपी गैल,{0}/gal Imp.,{0}galIm,{0}galIm,इंपी. गैल.,{0}/gal Imp.,,{0} gal Imp.,इंपीरियल गैलनां,{0}/gal Imp.,,{0} gal Imp.
        hectoliter,हैली,,,{0} hL,है.ली.,,,{0} hL,हैक्टोलीटर,,,{0} hL
        jigger,जिगर,,,{0} jigger,जिगर,,,{0} jigger,जिगर,,,{0} jigger
        liter,लीटर,{0}/l,,{0} l,लीटर,{0}/l,,{0} l,लीटर,{0}/l,,{0} l
        megaliter,मैली,,,{0} ML,मै.ली.,,,{0} ML,मैगालीटर,,,{0} ML
        milliliter,मिली,,,{0} mL,मि.ली.,,,{0} mL,मिलीलीटर,,,{0} mL
        pinch,चूं,,,{0} pinch,चूंडी,,,{0} pinch,चूंडियां,,,{0} pinch
        pint,पिं.,,,{0} pt,पिंट,,,{0} pt,पिंट,,,{0} pt
        pint-metric,मीपिं,,,{0} mpt,मी.पिं.,,,{0} mpt,मीट्रिक पिंट,,,{0} mpt
        quart,कुआर्ट,,,{0} qt,कुआर्ट,,,{0} qt,कुआर्ट,,,{0} qt
        quart-imperial,कु इंपी,,,{0} qt Imp.,कु इंपी,,,{0} qt Imp.,इंपी. कुआर्ट,,,{0} qt Imp.
        tablespoon,टेस्पून,,,{0} tbsp,टेस्पून,,,{0} tbsp,टेबलस्पून,,,{0} tbsp
        teaspoon,टीस्पून,,,{0} tsp,टीस्पून,,,{0} tsp,टी स्पून,,,{0} tsp
        fluid-ounce-imperial,Imp. fl oz,,{0}fl oz Im,{0}fl oz Im,,,,,,,,
        """.trimIndent()
  }

  private val doi_Prefixes: String? = null

  private val dsb_Units: String by lazy {
    """g-force,G,,,{0} G,G,,,{0} G,jadnotki zemskego póspěšenja,,{0} jadnotka zemskego póspěšenja,{0} jadnotkow zemskego póspěšenja
        meter-per-square-second,,,,,,,,,metry na kwadratnu sekundu,,{0} meter na kwadratnu sekundu,{0} metrow kwadratnu sekundu
        arc-minute,′,,{0}′,{0}′,′,,{0} ′,{0} ′,wobłukowe minuty,,{0} wobłukowa minuta,{0} wobłukowych minutow
        arc-second,″,,{0}″,{0}″,″,,{0} ″,{0} ″,wobłukowe sekundy,,{0} wobłukowa sekunda,{0} wobłukowych sekundow
        degree,°,,{0}°,{0}°,°,,{0} °,{0} °,wobłukowe stopnje,,{0} stopjeń,{0} stopnjow
        radian,,,,,,,,,radianty,,{0} radiant,{0} radiantow
        revolution,wobr.,,{0} wobr.,{0} wobr.,wobr.,,{0} wobr.,{0} wobr.,wobroty,,{0} wobrot,{0} wobrotow
        acre,ac,,,{0} ac,ac,,,{0} ac,akry,,{0} aker,{0} akrow
        dunam,dun.,,{0} dun.,{0} dun.,dun.,,{0} dun.,{0} dun.,dunamy,,{0} dunam,{0} dunamow
        hectare,ha,,,{0} ha,ha,,,{0} ha,hektary,,{0} hektar,{0} hektarow
        square-centimeter,,,,,,,,,kwadratne centimetry,{0} na kwadratny centimeter,{0} kwadratny centimeter,{0} kwadratnych centimetrow
        square-foot,,,,,,,,,kwadratne stopy,,{0} kwadratna stopa,{0} kwadratnych stopow
        square-inch,,,,,,,,,kwadratne cole,{0} na kwadratny col,{0} kwadratny col,{0} kwadratnych colow
        square-kilometer,,,,,,,,,kwadratne kilometry,{0} na kwadratny kilometer,{0} kwadratny kilometer,{0} kwadratnych kilometrow
        square-meter,,,,,,,,,kwadratne metry,{0} na kwadratny meter,{0} kwadratny meter,{0} kwadratnych metrow
        square-mile,,,,,,,,,kwadratne mile,{0} na kwadratnu milu,{0} kwadratna mila,{0} kwadratnych milow
        square-yard,,,,,,,,,kwadratne yardy,,{0} kwadratny yard,{0} kwadratnych yardow
        item,kus,,{0} kus,{0} kusow,kus,,{0} kus,{0} kusow,kuski,,{0} kusk,{0} kuskow
        karat,,,,,,,,,karaty,,{0} karat,{0} karatow
        milligram-ofglucose-per-deciliter,mg/dl,,{0} mg/dl,{0} mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,miligramy na deciliter,,{0} miligram na deciliter,{0} miligramow na deciliter
        millimole-per-liter,mmol/l,,{0} mmol/l,{0} mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,milimole na liter,,{0} milimol na liter,{0} milimolow na liter
        mole,,,,,,,,,mole,,{0} mol,{0} molow
        percent,%,,{0} %,{0} %,%,,{0} %,{0} %,procenty,,{0} procent,{0} procentow
        permille,‰,,{0} ‰,{0} ‰,‰,,{0} ‰,{0} ‰,promile,,{0} promil,{0} promilow
        permillion,,,,,,,,,milionśiny,,{0} milionśina,{0} milionśinow
        permyriad,‱,,{0} ‱,{0} ‱,‱,,{0} ‱,{0} ‱,źaseśiny promila,,{0} źaseśina promila,{0} źaseśinow promila
        portion-per-1e9,n,,{0} n,{0} n,nano,,{0} nano,{0} nano,miliardnina,,{0} miliardnina,{0} miliardninow
        liter-per-100-kilometer,l/100km,,{0} l/100km,{0} l/100km,l/100km,,{0} l/100km,{0} l/100km,litry na 100 kilometrow,,{0} liter na 100 kilometrow,{0} litrow na 100 kilometrow
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,litry na kilometer,,{0} liter na kilometer,{0} litrow na kilometer
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg,mile na gallonu,,{0} mila na gallonu,{0} milow na gallonu
        mile-per-gallon-imperial,mpg brit.,,{0} mpg brit.,{0} mpg brit.,mpg brit.,,{0} mpg brit.,{0} mpg brit.,mile na britisku galonu,,{0} mila na britisku galonu,{0} milow na britisku galonu
        bit,,,,,,,,,bit,,{0} bit,{0} bitow
        byte,,,,,,,,,byte,,{0} byte,{0} byteow
        gigabit,,,,,,,,,gigabit,,{0} gigabit,{0} gigabitow
        gigabyte,,,,,,,,,gigabyte,,{0} gigabyte,{0} gigabyteow
        kilobit,,,,,,,,,kilobit,,{0} kilobit,{0} kilobitow
        kilobyte,,,,,,,,,kilobyte,,{0} kilobyte,{0} kilobyteow
        megabit,,,,,,,,,megabit,,{0} megabit,{0} megabitow
        megabyte,,,,,,,,,megabyte,,{0} megabyte,{0} megabyteow
        petabyte,,,,,,,,,petabytey,,{0} petabyte,{0} petabyteow
        terabit,,,,,,,,,terabit,,{0} terabit,{0} terabitow
        terabyte,,,,,,,,,terabyte,,{0} terabyte,{0} terabyteow
        century,lětst.,,{0} lětst.,{0} lětst.,lětst.,,{0} lětst.,{0} lětst.,lětstotki,,{0} lětstotk,{0} lětstotkow
        day,d,{0}/ź.,{0} ź,{0} d,dny,{0}/ź.,{0} ź.,{0} dn.,dny,{0} wob źeń,{0} źeń,{0} dnjow
        decade,lětź.,,{0} lětź.,{0} lětź.,lětź.,,{0} lětź.,{0} lětź.,lětźasetki,,{0} lětźasetk,{0} lětźasetkow
        hour,g,{0}/h,{0} g,{0} g,góź.,{0}/h,{0} góź.,{0} góź.,góźiny,{0} na góźinu,{0} góźina,{0} góźinow
        microsecond,,,,,,,,,mikrosekundy,,{0} mikrosekunda,{0} mikrosekundow
        millisecond,,,,,,,,,milisekundy,,{0} milisekunda,{0} milisekundow
        minute,min,{0}/min.,{0} min,{0} min,min.,{0}/min.,{0} min.,{0} min.,minuty,{0} za minutu,{0} minuta,{0} minutow
        month,mjas.,{0} /mjas.,{0} mjas.,{0} mjas.,mjas.,{0} /mjas.,{0} mjas.,{0} mjas.,mjasecy,{0} wob mjasec,{0} mjasec,{0} mjasecow
        nanosecond,,,,,,,,,nanosekundy,,{0} nanosekunda,{0} nanosekundow
        night,nocy,{0} na noc,{0} noc,{0} nocow,nocy,{0} na noc,{0} noc,{0} nocow,pśenocowanja,{0} na pśenocowanje,{0} pśenocowanje,{0} pśenocowanjow
        quarter,kw.,{0}/kw.,{0} kw.,{0} kw.,kwart.,{0}/kwart.,{0} kwart.,{0} kwart.,kwartale,{0}/kwartal,{0} kwartal,{0} kwartalow
        second,s,{0}/s,{0} s,{0} s,sek.,{0}/s,{0} sek.,{0} sek.,sekundy,{0} na sekundu,{0} sekunda,{0} sekundow
        week,tyź.,{0} /tyź.,{0} tyź.,{0} tyź.,tyź.,{0} /tyź.,{0} tyź.,{0} tyź.,tyźenje,{0} wob tyźeń,{0} tyźeń,{0} tyźenjow
        year,l.,{0}/l.,{0} l.,{0} l.,l.,{0}/l.,{0} l.,{0} l.,lěta,{0} wob lěto,{0} lěto,{0} lět
        ampere,A,,,{0} A,A,,,{0} A,ampery,,{0} ampere,{0} amperow
        milliampere,,,,,,,,,milliampery,,{0} milliampere,{0} milliamperow
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,ohm,,{0} ohm,{0} ohmow
        volt,V,,,{0} V,V,,,{0} V,volty,,{0} volt,{0} voltow
        british-thermal-unit,,,,,,,,,britiske jadnotki śopłoty,,{0} britiska jadnotka śopłoty,{0} britiskich jadnotkow śopłoty
        calorie,,,,,,,,,kalorije,,{0} kalorija,{0} kalorijow
        electronvolt,,,,,,,,,elektronvolty,,{0} elektronvolt,{0} elektronvoltow
        foodcalorie,,,,,,,,,kilokalorije,,{0} kilokalorija,{0} kilokalorijow
        joule,J,,,{0} J,J,,,{0} J,joule,,{0} joule,{0} joule
        kilocalorie,,,,,,,,,kilokalorije,,{0} kilokalorija,{0} kilokalorijow
        kilojoule,,,,,,,,,kilojoule,,{0} kilojoule,{0} kilojoule
        kilowatt-hour,,,,,,,,,kilowattowe góźiny,,{0} kilowattowa góźina,{0} kilowattowych góźin
        therm-us,US therm,,{0} US therm,{0} US therms,US therm,,{0} US therm,{0} US therms,amerikańske jadnotki śopłoty,,{0} amerikańska jadnotka śopłoty,{0} amerikańskich jadnotkow śopłoty
        kilowatt-hour-per-100-kilometer,,,,,,,,,kilowattowe góźiny na 100 kilometrow,,{0} kilowattowa góźina na 100 kilometrow,{0} kilowattowych góźinow na 100 kilometrow
        newton,,,,,,,,,newtony,,{0} newton,{0} newtonow
        pound-force,,,,,,,,,punty mócy,,{0} punt mócy,{0} puntow mócy
        gigahertz,,,,,,,,,gigahertzy,,{0} gigahertz,{0} gigahertzow
        hertz,,,,,,,,,hertzy,,{0} hertz,{0} hertzow
        kilohertz,,,,,,,,,kilohertzy,,{0} kilohertz,{0} kilohertzow
        megahertz,,,,,,,,,megahertzy,,{0} megahertz,{0} megahertzow
        em,,,,,,,,,typografiski em,,{0} typografiski em,{0} typografiskich em
        megapixel,,,,,,,,,megapiksele,,{0} megapiksel,{0} megapikselow
        pixel,,,,,,,,,piksele,,{0} piksel,{0} pikselow
        pixel-per-centimeter,,,,,,,,,piksele na centimeter,,{0} piksel na centimeter,{0} pikselow na centimeter
        pixel-per-inch,,,,,,,,,piksele na col,,{0} piksel na col,{0} pikselow na col
        astronomical-unit,,,,,,,,,astronomiske jadnotki,,{0} astronomiska jadnotka,{0} astronomiskich jadnotkow
        centimeter,,,,,,,,,centimetry,{0} na centimeter,{0} centimeter,{0} centimetrow
        decimeter,,,,,,,,,decimetry,,{0} decimeter,{0} decimetrow
        earth-radius,,,,,,,,,radius zemje,,{0} radius zemje,{0} radiusow zemje
        fathom,fth,,,{0} fth,fth,,,{0} fth,sahi,,{0} saha,{0} sahow
        foot,,,,,,,,,stopy,{0} na stopu,{0} crjej,{0} crjej
        furlong,,,,,,,,,furlongi,,{0} furlong,{0} furlongow
        inch,in,{0}/col,,{0} in,in,{0}/col,,{0} in,cole,{0} na col,{0} col,{0} colow
        kilometer,,,,,,,,,kilometry,{0} na kilometer,{0} kilometer,{0} kilometrow
        light-year,,,,,,,,,swětłowe lěta,,{0} swětłowe lěto,{0} swětłowych lět
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,metry,{0} na meter,{0} meter,{0} metrow
        micrometer,,,,,,,,,mikrometry,,{0} mikrometer,{0} mikrometrow
        mile,,,,,,,,,mile,,{0} mila,{0} milow
        mile-scandinavian,,,,,,,,,skandinawiske mile,,{0} skandinawiska mila,{0} skandinawiskich milow
        millimeter,,,,,,,,,milimetry,,{0} milimeter,{0} milimetrow
        nanometer,,,,,,,,,nanometry,,{0} nanometer,{0} nanometrow
        nautical-mile,,,,,,,,,nawtiske mile,,{0} nawtiska mila,{0} nawtiskich milow
        parsec,,,,,,,,,parsec,,{0} parsec,{0} parsec
        picometer,,,,,,,,,pikometry,,{0} pikometer,{0} pikometrow
        point,,,,,,,,,dypki,,{0} dypk,{0} dypkow
        solar-radius,,,,,,,,,radiuse słyńca,,{0} radius słyńca,{0} radiusow słyńca
        yard,,,,,,,,,yardy,,{0} yard,{0} yardow
        candela,,,,,,,,,kandele,,{0} kandela,{0} kandelow
        lumen,,,,,,,,,lumeny,,{0} lumen,{0} lumenow
        lux,,,,,,,,,lux,,{0} lux,{0} lux
        solar-luminosity,,,,,,,,,swěśeńske mócy słyńca,,{0} swěśeńska móc słyńca,{0} swěśeńskich mócow słyńca
        carat,Kt,,{0} Kt,{0} Kt,Kt,,{0} Kt,{0} Kt,karaty,,{0} karat,{0} karatow
        dalton,,,,,,,,,daltony,,{0} dalton,{0} daltonow
        earth-mass,,,,,,,,,kopice zemje,,{0} kopica zemje,{0} kopicow zemje
        grain,grain,,{0} grain,{0} grainow,grain,,{0} grain,{0} grainow,grain,,{0} grain,{0} grainow
        gram,g,{0}/g,,{0} g,g,{0}/g,,{0} g,gramy,{0} na gram,{0} gram,{0} gramow
        kilogram,,,,,,,,,kilogramy,{0} na kilogram,{0} kilogram,{0} kilogramow
        microgram,,,,,,,,,mikrogramy,,{0} mikrogram,{0} mikrogramow
        milligram,,,,,,,,,miligramy,,{0} miligram,{0} miligramow
        ounce,,,,,,,,,unce,{0} na uncu,{0} unca,{0} uncow
        ounce-troy,oz. tr.,,{0} oz. tr.,{0} oz. tr.,oz. tr.,,{0} oz. tr.,{0} oz. tr.,troyske unce,,{0} troyska unca,{0} troyskich uncow
        pound,,,,,,,,,punty,{0} na punt,{0} punt,{0} puntow
        solar-mass,,,,,,,,,mase słyńca,,{0} masa słyńca,{0} masow słyńca
        stone,,,,,,,,,kamjenje,,{0} kamjeń,{0} kamjenjow
        ton,am.tony,,,{0} tn,am.tony,,,{0} tn,ameriske tony,,{0} ameriska tona,{0} ameriskich tonow
        tonne,,,,,,,,,tony,,{0} tona,{0} tonow
        gigawatt,,,,,,,,,gigawatty,,{0} gigawatt,{0} gigawattow
        horsepower,PS,,{0} PS,{0} PS,PS,,{0} PS,{0} PS,kónjece mócy,,{0} kónjeca móc,{0} kónjecych mócow
        kilowatt,,,,,,,,,kilowatty,,{0} kilowatt,{0} kilowattow
        megawatt,,,,,,,,,megawatty,,{0} megawatt,{0} megawattow
        milliwatt,,,,,,,,,miliwatty,,{0} miliwatt,{0} miliwattow
        watt,W,,,{0} W,W,,,{0} W,watty,,{0} watt,{0} wattow
        atmosphere,,,,,,,,,atmosfery,,{0} atmosfera,{0} atmosferow
        bar,,,,,,,,,bary,,{0} bar,{0} barow
        hectopascal,,,,,,,,,hektopascale,,{0} hektopascal,{0} hektopascalow
        inch-ofhg,,,,,,,,,cole žywoslobrowego słupika,,{0} col słupika žywego slobra,{0} colow słupika žywego slobra
        kilopascal,,,,,,,,,kilopascale,,{0} kilopascal,{0} kilopascalow
        megapascal,,,,,,,,,megapascale,,{0} megapascal,{0} megapascalow
        millibar,,,,,,,,,milibary,,{0} milibar,{0} milibarow
        millimeter-ofhg,,,,,,,,,milimetry słupika žywego slobra,,{0} milimeter słupika žywego slobra,{0} milimetrow słupika žywego slobra
        pascal,,,,,,,,,pascale,,{0} pascal,{0} pascalow
        pound-force-per-square-inch,,,,,,,,,punty na kwadratny col,,{0} punt na kwadratny col,{0} puntow na kwadratny col
        beaufort,Bft,,{0} Bft,{0} Bft,Bft,,{0} Bft,{0} Bft,beaufort,,{0} stopjeń beauforta,{0} stopnjow beauforta
        kilometer-per-hour,,,,,,,,,kilometry na góźinu,,{0} kilometer na góźinu,{0} kilometrow na góźinu
        knot,sk,,{0} sk,{0} sk,sk,,{0} sk,{0} sk,suki,,{0} suk,{0} sukow
        light-speed,c,,{0} c,{0} c,spěšnosć sw.,,{0} spěšnosć sw.,{0} spěšnosćow sw.,spěšnosć swětła,,{0} spěšnosć swětła,{0} spěšnosćow swětła
        meter-per-second,,,,,,,,,metry na sekundu,,{0} meter na sekundu,{0} metrow na sekundu
        mile-per-hour,mph,,{0} mph,{0} mph,mph,,{0} mph,{0} mph,mile na góźinu,,{0} mila na góźinu,{0} milow na góźinu
        celsius,,,,,,,,,stopnje celsiusa,,{0} stopjeń celsiusa,{0} stopnjow celsiusa
        fahrenheit,,,,,,,,,stopnje Fahrenheita,,{0} stopjeń Fahrenheita,{0} stopnjow Fahrenheita
        generic,,,,,,,,,°,,{0} stopjeń,{0} stopjenjow
        kelvin,,,,,,,,,stopnje Kelvina,,{0} stopjeń Kelvina,{0} stopnjow Kelvina
        newton-meter,Nm,,{0} Nm,{0} Nm,Nm,,{0} Nm,{0} Nm,newtonmetry,,{0} newtonmeter,{0} newtonmetrow
        pound-force-foot,,,,,,,,,librostopy,,{0} librostopa,{0} librostopow
        acre-foot,,,,,,,,,aker-crjeje,,{0} aker-crjej,{0} aker-crjej
        barrel,,,,,,,,,barele,,{0} barel,{0} barelow
        bushel,,,,,,,,,bušle,,{0} bušl,{0} bušlow
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,centilitry,,{0} centiliter,{0} centilitrow
        cubic-centimeter,,,,,,,,,kubikne centimetry,{0} na kubikny centimeter,{0} kubikny centimeter,{0} kubiknych centimetrow
        cubic-foot,,,,,,,,,kubikne crjeje,,{0} kubikny crjej,{0} kubiknych crjejow
        cubic-inch,,,,,,,,,kubikne cole,,{0} kubikny col,{0} kubiknych colow
        cubic-kilometer,,,,,,,,,kubikne kilometry,,{0} kubikny kilometer,{0} kubiknych kilometrow
        cubic-meter,,,,,,,,,kubikne metry,{0} na kubikny meter,{0} kubikny meter,{0} kubiknych metrow
        cubic-mile,,,,,,,,,kubikne mile,,{0} kubikna mila,{0} kubiknych milow
        cubic-yard,,,,,,,,,kubikne yardy,,{0} kubikny yard,{0} kubiknych yardow
        cup,c,,,{0} c,c,,,{0} c,taski,,{0} taska,{0} taskow
        cup-metric,mc,,,{0} mc,mc,,,{0} mc,metriske taski,,{0} metriska taska,{0} metriskich taskow
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,decilitry,,{0} deciliter,{0} decilitrow
        dessert-spoon,dess. łžk.,,{0} dess. łžk.,{0} dess. łžk.,dess. łžk.,,{0} dess. łžk.,{0} dess. łžk.,dessertowe łžycki,,{0} dessertowa łžycka,{0} dessertowych łžyckow
        dessert-spoon-imperial,imp. łžk.,,{0} imp. łžk.,{0} imp. łžk.,imp. łžk.,,{0} imp. łžk.,{0} imp. łžk.,britiske łžycki,,{0} britiska łžycka,{0} britiskich łžyckow
        dram,dr,,{0} dr,{0} dr,dr,,{0} dr,{0} dr,dramy,,{0} dram,{0} dramow
        drop,chpk.,,{0} chpk.,{0} chpk.,chpk.,,{0} chpk.,{0} chpk.,chrapki,,{0} chrapka,{0} chrapkow
        fluid-ounce,fl. oz.,,{0} fl. oz.,{0} fl. oz.,fl. oz.,,{0} fl. oz.,{0} fl. oz.,žydke unce,,{0} žydka unca,{0} žydkych uncow
        fluid-ounce-imperial,brit. fl oz,,{0} brit. fl oz,{0} brit. fl oz,brit. fl oz,,{0} brit. fl oz,{0} brit. fl oz,britiske běžne uncy,,{0} britiska běžeca unca,{0} britiskich běžecych uncow
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,gallony,{0} na galonu,{0} gallona,{0} gallonow
        gallon-imperial,brit. gal.,{0}/brit. gal.,{0} brit. gal.,{0} brit. gal.,brit. gal.,{0}/brit. gal.,{0} brit. gal.,{0} brit. gal.,britiske galony,{0} na britisku galonu,{0} britiska galona,{0} britiskich galonow
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hektolitry,,{0} hektoliter,{0} hektolitrow
        jigger,jiggery,,{0} jigger,{0} jiggerow,jiggery,,{0} jigger,{0} jiggerow,jiggery,,{0} jigger,{0} jiggerow
        liter,l,{0}/l,,{0} l,l,{0}/l,,{0} l,litry,{0} na liter,{0} liter,{0} litrow
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megalitry,,{0} megaliter,{0} megalitrow
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,mililitry,,{0} mililiter,{0} mililitrow
        pinch,šć,,{0} šć,{0} šć,šćipki,,{0} šćipka,{0} šćipkow,šćipki,,{0} šćipka,{0} šćipkow
        pint,,,,,,,,,pinty,,{0} pint,{0} pintow
        pint-metric,,,,,,,,,metriske pinty,,{0} metriski pint,{0} metriskich pintow
        quart,,,,,,,,,quarty,,{0} quart,{0} quartow
        quart-imperial,,,,,,,,,britiske běrtyle,,{0} britiski běrtyl,{0} britiskich běrtylow
        tablespoon,łž.,,{0} łž.,{0} łž.,łž.,,{0} łž.,{0} łž.,łžyce,,{0} łžyca,{0} łžycow
        teaspoon,łžk.,,{0} łžk.,{0} łžk.,łžk.,,{0} łžk.,{0} łžk.,łžycki,,{0} łžycka,{0} łžyckow
        """.trimIndent()
  }

  private val dsb_Prefixes: String by lazy {
    """square,,,kwadratnych {0}
        cubic,,,kubiknych {0}
        times,,,{0}-{1}
        per,,,{0} na {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobi{0}
        10p-1,,,deci{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yokto{0}
        10p-27,,,ronto{0}
        10p-3,,,mili{0}
        10p-30,,,quecto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,eksa{0}
        10p2,,,hekto{0}
        10p21,,,zeta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val dua_Units: String? = null

  private val dua_Prefixes: String? = null

  private val dv_Units: String? = null

  private val dv_Prefixes: String? = null

  private val dyo_Units: String? = null

  private val dyo_Prefixes: String? = null

  private val dz_Units: String by lazy {
    """day,,,,,,,,,day,{0}/d,,ཉིན་ཞག་ {0}
        hour,,,,,,,,,hr,{0}/h,,ཆུ་ཚོད་ {0}
        minute,,,,,,,,,min,{0}/min,,སྐར་མ་ {0}
        month,,,,,,,,,mon,{0}/m,,ཟླཝ་ {0}
        second,,,,,,,,,sec,{0}/s,,སྐར་ཆ་ {0}
        week,,,,,,,,,wk,{0}/w,,བངུན་ཕྲག་ {0}
        year,,,,,,,,,yr,{0}/y,,ལོ་འཁོར་ {0}
        """.trimIndent()
  }

  private val dz_Prefixes: String? = null

  private val ebu_Units: String? = null

  private val ebu_Prefixes: String? = null

  private val ee_Units: String by lazy {
    """day,ŋkeke,{0}/d,ŋkeke {0},ŋkeke {0},ŋkekewo,{0}/d,ŋkeke {0},ŋkeke {0},ŋkekewo,{0}/d,ŋkeke {0},ŋkeke {0}
        hour,gaƒoƒo,{0}/h,gaƒoƒo {0},gaƒoƒo {0},gaƒoƒowo,{0}/h,gaƒoƒo {0},gaƒoƒo {0},gaƒoƒowo,{0}/h,gaƒoƒo {0},gaƒoƒo {0}
        minute,aɖabaƒoƒo,{0}/min,a {0},a {0},aɖabaƒoƒowo,{0}/min,a {0},a {0},aɖabaƒoƒowo,{0}/min,aɖabaƒoƒo {0},aɖabaƒoƒo {0}
        month,ɣletiwo,{0}/m,ɣleti {0},ɣleti {0},ɣletiwo,{0}/m,ɣleti {0},ɣleti {0},ɣletiwo,{0}/m,ɣleti {0},ɣleti {0}
        second,sec,{0}/s,s {0},s {0},sec,{0}/s,sekend {0},sekend {0},sec,{0}/s,sekend {0} wo,sekend {0} wo
        week,kɔsiɖa,{0}/w,kɔsiɖa {0},kɔsiɖa {0},kɔsiɖawo,{0}/w,kɔsiɖa {0},kɔsiɖa {0},kɔsiɖawo,{0}/w,kɔsiɖa {0},kɔsiɖa {0}
        year,ƒe,{0}/y,ƒe {0},ƒe {0},ƒewo,{0}/y,ƒe {0},ƒe {0},ƒewo,{0}/y,ƒe {0},ƒe {0}
        """.trimIndent()
  }

  private val ee_Prefixes: String? = null

  private val ee_TG_Units: String? = null

  private val ee_TG_Prefixes: String? = null

  private val el_Units: String by lazy {
    """g-force,G,,{0} G,{0} G,δύν. επιτάχ.,,{0} δύν. επιτάχ.,{0} δυν. επιτάχ.,δύναμη επιτάχυνσης,,{0} δύναμη επιτάχυνσης,{0} δυνάμεις επιτάχυνσης
        meter-per-square-second,,,,,μέτρα/τετρ. δευτ.,,,{0} m/s²,μέτρα ανά τετραγωνικό δευτερόλεπτο,,{0} μέτρο ανά τετραγωνικό δευτερόλεπτο,{0} μέτρα ανά τετραγωνικό δευτερόλεπτο
        arc-minute,′,,{0}′,{0}′,λεπτά του τόξου,,{0} λεπ. τόξου,{0} λεπ. τόξου,λεπτά του τόξου,,{0} λεπτό του τόξου,{0} λεπτά του τόξου
        arc-second,″,,{0}″,{0}″,arcsec,,{0} arcsec,{0} arcsec,δευτερόλεπτα του τόξου,,{0} δευτερόλεπτο του τόξου,{0} δευτερόλεπτα του τόξου
        degree,°,,,{0}°,μοίρες,,,{0}°,μοίρες,,{0} μοίρα,{0} μοίρες
        radian,ακτν,,{0} ακτν,{0} ακτν,ακτν,,{0} ακτν,{0} ακτν,ακτίνια,,{0} ακτίνιο,{0} ακτίνια
        revolution,στρφ,,{0} στρφ,{0} στρφ,στρφ,,{0} στρφ,{0} στρφ,στροφή,,{0} στροφή,{0} στροφές
        acre,ακρ,,{0} ακρ,{0} ακρ,ακρ,,{0} ακρ,{0} ακρ,ακρ,,{0} ακρ,{0} ακρ
        dunam,ντούναμ,,{0} ντούναμ,{0} ντούναμ,ντούναμ,,{0} ντούναμ,{0} ντούναμ,ντούναμ,,{0} ντούναμ,{0} ντούναμ
        hectare,ha,,{0} ha,{0} ha,εκτ.,,{0} εκτ.,{0} εκτ.,εκτάρια,,{0} εκτάριο,{0} εκτάρια
        square-centimeter,τ.εκ.,{0}/τ.εκ.,{0} τ.εκ.,{0} τ.εκ.,τ.εκ.,{0}/τ.εκ.,{0} τ.εκ.,{0} τ.εκ.,τετραγωνικά εκατοστά,{0}/τετραγωνικό εκατοστό,{0} τετραγωνικό εκατοστό,{0} τετραγωνικά εκατοστά
        square-foot,τ.πδ,,{0} τ.πδ,{0} τ.πδ,τετρ. πόδια,,{0} τ.πδ,{0} τ.πδ,τετραγωνικά πόδια,,{0} τετραγωνικό πόδι,{0} τετραγωνικά πόδια
        square-inch,τ. ίντσες,{0}/τ. ίντσα,{0} τ. ίντσα,{0} τ. ίντσες,τετρ. ίντσες,{0}/τ. ίντσα,{0} τ. ίντσα,{0} τ. ίντσες,τετραγωνικές ίντσες,{0} ανά τετραγωνική ίντσα,{0} τετραγωνική ίντσα,{0} τετραγωνικές ίντσες
        square-kilometer,τ.χλμ.,{0}/τ.χλμ.,{0} km²,{0} km²,τ.χλμ.,{0}/τ.χλμ.,{0} τ.χλμ.,{0} τ.χλμ.,τετραγωνικά χιλιόμετρα,{0}/τετραγωνικό χιλιόμετρο,{0} τετραγωνικό χιλιόμετρο,{0} τετραγωνικά χιλιόμετρα
        square-meter,τ.μ.,{0}/τ.μ.,{0} τ.μ.,{0} τ.μ.,τ. μέτρα,{0}/τ.μ.,{0} τ.μ.,{0} τ.μ.,τετραγωνικά μέτρα,{0}/τετραγωνικό μέτρο,{0} τετραγωνικό μέτρο,{0} τετραγωνικά μέτρα
        square-mile,τ.μίλι,{0}/τ.μίλι,{0} τ.μίλι,{0} τ.μίλια,τετρ. μίλια,{0}/τ.μίλι,{0} τ.μίλι,{0} τ.μίλια,τετραγωνικά μίλια,{0}/τετραγωνικό μίλι,{0} τετραγωνικό μίλι,{0} τετραγωνικά μίλια
        square-yard,τ.γρδ,,{0} τ.γρδ,{0} τ.γρδ,τετρ. γιάρδες,,{0} τ.γρδ,{0} τ.γρδ,τετραγωνικές γιάρδες,,{0} τετραγωνική γιάρδα,{0} τετραγωνικές γιάρδες
        item,στοιχείο,,{0} στοιχείο,{0} στοιχεία,στοιχείο,,{0} στοιχείο,{0} στοιχεία,στοιχείο,,{0} στοιχείο,{0} στοιχεία
        karat,κρτ,,{0} κρτ,{0} κρτ,κρτ,,{0} κρτ,{0} κρτ,καράτια,,{0} καράτι,{0} καράτια
        milligram-ofglucose-per-deciliter,,,,,,,,,χιλιοστόγραμμα ανά δεκατόλιτρο,,{0} χιλιοστόγραμμο ανά δεκατόλιτρο,{0} χιλιοστόγραμμα ανά δεκατόλιτρο
        millimole-per-liter,,,,,,,,,χιλιοστογραμμομόρια ανά λίτρο,,{0} χιλιοστογραμμομόριο ανά λίτρο,{0} χιλιοστογραμμομόρια ανά λίτρο
        mole,μολ,,{0} μολ,{0} μολ,μολ,,{0} μολ,{0} μολ,μολ,,{0} μολ,{0} μολ
        percent,,,,,τοις εκατό,,,{0}%,τοις εκατό,,{0} τοις εκατό,{0} τοις εκατό
        permille,,,,,τοις χιλίοις,,,{0}‰,τοις χιλίοις,,{0} τοις χιλίοις,{0} τοις χιλίοις
        permillion,,,,,μέρη/εκατ.,,,{0} ppm,μέρη ανά εκατομμύριο,,{0} μέρος ανά εκατομμύριο,{0} μέρη ανά εκατομμύριο
        permyriad,,,,,τοις δεκάκις χιλίοις,,,{0}‱,τοις δεκάκις χιλίοις,,{0} τοις δεκάκις χιλίοις,{0} τοις δεκάκις χιλίοις
        portion-per-1e9,μέρη/δισεκατομμύριο,,,{0} ppb,μέρη/δισεκατομμύριο,,,{0} ppb,μέρη στο δισεκατομμύριο,,{0} μέρος στο δισεκατομμύριο,{0} μέρη στο δισεκατομμύριο
        liter-per-100-kilometer,λ/100 χλμ,,{0} λ/100 χλμ,{0} λ/100 χλμ,λ./100 χλμ.,,{0} λ./100 χλμ.,{0} λ./100 χλμ.,λίτρα ανά 100 χιλιόμετρα,,{0} λίτρο ανά 100 χιλιόμετρα,{0} λίτρα ανά 100 χιλιόμετρα
        liter-per-kilometer,λ/χλμ,,{0} λ/χλμ,{0} λ/χλμ,λίτρα/χλμ.,,{0} λίτρο/χλμ.,{0} λίτρα/χλμ.,λίτρα ανά χιλιόμετρο,,{0} λίτρο ανά χιλιόμετρο,{0} λίτρα ανά χιλιόμετρο
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,μίλια/γαλόνι,,{0} mpg,{0} mpg,μίλια ανά γαλόνι,,{0} μίλι ανά γαλόνι,{0} μίλια ανά γαλόνι
        mile-per-gallon-imperial,μίλια/αγγλ. γαλόνι,,{0} μίλι/αγγλ. γαλόνι,{0} μίλια/αγγλ. γαλόνι,μίλια/αγγλ. γαλόνι,,{0} μίλι/αγγλ. γαλόνι,{0} μίλια/αγγλ. γαλόνι,μίλια ανά αγγλοσαξονικό γαλόνι,,{0} μίλι ανά αγγλοσαξονικό γαλόνι,{0} μίλια ανά αγγλοσαξονικό γαλόνι
        gigabit,,,,,,,,,gigabit,,{0} gigabit,{0} gigabit
        gigabyte,,,,,,,,,gigabyte,,{0} gigabyte,{0} gigabyte
        kilobit,,,,,,,,,kilobit,,{0} kilobit,{0} kilobit
        kilobyte,,,,,,,,,kilobyte,,{0} kilobyte,{0} kilobyte
        megabit,,,,,,,,,megabit,,{0} megabit,{0} megabit
        megabyte,,,,,,,,,megabyte,,{0} megabyte,{0} megabyte
        petabyte,,,,,PByte,,,{0} PB,petabyte,,{0} petabyte,{0} petabyte
        terabit,,,,,,,,,terabit,,{0} terabit,{0} terabit
        terabyte,,,,,,,,,terabyte,,{0} terabyte,{0} terabyte
        century,αιών.,,{0} αιών.,{0} αιών.,αιών.,,{0} αιών.,{0} αιών.,αιώνες,,{0} αιώνας,{0} αιώνες
        day,ημέρα,{0}/η,{0} η,{0} η,ημέρες,{0}/ημ.,{0} ημέρα,{0} ημέρες,ημέρες,{0} ανά ημέρα,{0} ημέρα,{0} ημέρες
        decade,δεκ.,,{0} δεκ.,{0} δεκ.,δεκ.,,{0} δεκ.,{0} δεκ.,δεκαετίες,,{0} δεκαετία,{0} δεκαετίες
        hour,ώρα,{0}/ώ,{0} ώ,{0} ώ,ώρες,{0}/ώ.,{0} ώ.,{0} ώ.,ώρες,{0} ανά ώρα,{0} ώρα,{0} ώρες
        microsecond,,,,,μικροδεύτερα,,,{0} μs,μικροδευτερόλεπτα,,{0} μικροδευτερόλεπτο,{0} μικροδευτερόλεπτα
        millisecond,χιλ. δευτ.,,,{0} ms,χιλιοστά δευτ.,,,{0} ms,χιλιοστά του δευτερολέπτου,,{0} χιλιοστό του δευτερολέπτου,{0} χιλιοστά του δευτερολέπτου
        minute,λ.,{0}/λ,{0} λ,{0} λ,λεπ.,{0}/λ.,{0} λ.,{0} λ.,λεπτά,{0} ανά λεπτό,{0} λεπτό,{0} λεπτά
        month,μήνας,{0}/μ,{0} μ,{0} μ,μήνες,{0}/μ.,{0} μήν.,{0} μήν.,μήνες,{0} ανά μήνα,{0} μήνας,{0} μήνες
        nanosecond,,,,,νανοδεύτερα,,,{0} ns,νανοδευτερόλεπτα,,{0} νανοδευτερόλεπτο,{0} νανοδευτερόλεπτα
        night,νύχτ.,{0}/νύχτ.,{0} νύχτ.,{0} νύχτ.,νύχτ.,{0}/νύχτ.,{0} νύχτ.,{0} νύχτ.,νύχτες,{0}/νύχτα,{0} νύχτα,{0} νύχτες
        quarter,τετ.,{0}/τέτ.,{0} τέτ.,{0} τέτ.,τετ.,{0}/τέτ.,{0} τέτ.,{0} τέτ/α,τέταρτα,{0}/τέτ.,{0} τέταρτο,{0} τέταρτα
        second,δευτ.,{0}/δ,{0} δ,{0} δ,δευτ.,{0}/δευτ.,{0} δευτ.,{0} δευτ.,δευτερόλεπτα,{0} ανά δευτερόλεπτο,{0} δευτερόλεπτο,{0} δευτερόλεπτα
        week,εβδ.,{0}/ε,{0} ε,{0} ε,εβδομάδες,{0}/εβδ.,{0} εβδ.,{0} εβδ.,εβδομάδες,{0} ανά εβδομάδα,{0} εβδομάδα,{0} εβδομάδες
        year,έτ.,{0}/έ,{0} έ,{0} έ,έτη,{0}/έτ.,{0} έτ.,{0} έτ.,έτη,{0} ανά έτος,{0} έτος,{0} έτη
        ampere,A,,,{0} A,A,,,{0} A,αμπέρ,,{0} αμπέρ,{0} αμπέρ
        milliampere,,,,,,,,,μιλιαμπέρ,,{0} μιλιαμπέρ,{0} μιλιαμπέρ
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,ωμ,,{0} ωμ,{0} ωμ
        volt,V,,,{0} V,V,,,{0} V,βολτ,,{0} βολτ,{0} βολτ
        british-thermal-unit,BTU,,{0} BTU,{0} BTU,BTU,,{0} BTU,{0} BTU,βρετανικές μονάδες θερμότητας,,{0} βρετανική μονάδα θερμότητας,{0} βρετανικές μονάδες θερμότητας
        calorie,θερμ.,,{0} θερμ.,{0} θερμ.,θερμ.,,{0} θερμ.,{0} θερμ.,θερμίδες,,{0} θερμίδα,{0} θερμίδες
        electronvolt,,,,,ηλεκτρονιοβόλτ,,,{0} eV,ηλεκτρονιοβόλτ,,{0} ηλεκτρονιοβόλτ,{0} ηλεκτρονιοβόλτ
        foodcalorie,θερμ.,,{0} θερμ.,{0} θερμ.,θερμ.,,{0} θερμ.,{0} θερμ.,θερμίδες,,{0} θερμίδα,{0} θερμίδες
        joule,J,,,{0} J,τζάουλ,,,{0} J,τζάουλ,,{0} τζάουλ,{0} τζάουλ
        kilocalorie,,,,,,,,,χιλιοθερμίδες,,{0} χιλιοθερμίδα,{0} χιλιοθερμίδες
        kilojoule,,,,,κιλοτζάουλ,,,{0} kJ,κιλοτζάουλ,,{0} κιλοτζάουλ,{0} κιλοτζάουλ
        kilowatt-hour,kW/ώ.,,{0} kW/ώ.,{0} kW/ώ.,κιλοβάτ/ώρα,,{0} κιλοβάτ/ώρα,{0} κιλοβάτ/ώρα,κιλοβατώρες,,{0} κιλοβατώρα,{0} κιλοβατώρες
        therm-us,θερμ. μονάδες ΗΠΑ,,{0} θερμ. μονάδα ΗΠΑ,{0} θερμ. μονάδες ΗΠΑ,θερμ. μονάδες ΗΠΑ,,{0} θερμ. μονάδα ΗΠΑ,{0} θερμ. μονάδες ΗΠΑ,θερμικές μονάδες ΗΠΑ,,{0} θερμική μονάδα ΗΠΑ,{0} θερμικές μονάδες ΗΠΑ
        kilowatt-hour-per-100-kilometer,kWh/100 χλμ.,,{0} kWh/100 χλμ.,{0} kWh/100 χλμ.,kWh/100 χλμ.,,{0} kWh/100 χλμ.,{0} kWh/100 χλμ.,κιλοβατώρες ανά 100 χιλιόμετρα,,{0} κιλοβατώρα ανά 100 χιλιόμετρα,{0} κιλοβατώρες ανά 100 χιλιόμετρα
        newton,,,,,νιούτον,,,{0} N,νιούτον,,{0} νιούτον,{0} νιούτον
        pound-force,,,,,λίβρες δύναμης,,,{0} lbf,λίβρες δύναμης,,{0} λίβρα δύναμης,{0} λίβρες δύναμης
        gigahertz,,,,,,,,,γιγαχέρτζ,,{0} γιγαχέρτζ,{0} γιγαχέρτζ
        hertz,,,,,,,,,χερτζ,,{0} χερτζ,{0} χερτζ
        kilohertz,,,,,,,,,κιλοχέρτζ,,{0} κιλοχέρτζ,{0} κιλοχέρτζ
        megahertz,,,,,,,,,μεγαχέρτζ,,{0} μεγαχέρτζ,{0} μεγαχέρτζ
        dot,κουκ.,,{0} κουκ.,{0} κουκ.,κουκ.,,{0} κουκ.,{0} κουκ.,κουκκίδες,,{0} κουκκίδα,{0} κουκκίδες
        dot-per-centimeter,κουκ./εκ.,,{0} κουκ./εκ.,{0} κουκ./εκ.,κουκ./εκ.,,{0} κουκ./εκ.,{0} κουκ./εκ.,κουκκίδες ανά εκατοστό,,{0} κουκκίδα ανά εκατοστό,{0} κουκκίδες ανά εκατοστό
        dot-per-inch,κουκ./ίντσα,,{0} κουκ./ίντσα,{0} κουκ./ίντσα,κουκ./ίντσα,,{0} κουκ./ίντσα,{0} κουκ./ίντσα,κουκκίδες ανά ίντσα,,{0} κουκκίδα ανά ίντσα,{0} κουκκίδες ανά ίντσα
        em,,,,,,,,,τυπογραφικό em,,{0} τυπογραφικό em,{0} τυπογραφικά em
        megapixel,,,,,megapixel,,,{0} MP,megapixel,,{0} megapixel,{0} megapixel
        pixel,pixel,,,{0} px,pixel,,,{0} px,pixel,,{0} pixel,{0} pixel
        pixel-per-centimeter,,,,,,,,,pixel ανά εκατοστό,,{0} pixel ανά εκατοστό,{0} pixel ανά εκατοστό
        pixel-per-inch,,,,,,,,,pixel ανά ίντσα,,{0} pixel ανά ίντσα,{0} pixel ανά ίντσα
        astronomical-unit,α.μ.,,{0} α.μ.,{0} α.μ.,α.μ.,,{0} α.μ.,{0} α.μ.,αστρονομικές μονάδες,,{0} αστρονομική μονάδα,{0} αστρονομικές μονάδες
        centimeter,εκ.,{0}/εκ.,{0} εκ.,{0} εκ.,εκ.,{0}/εκ.,{0} εκ.,{0} εκ.,εκατοστά,{0} ανά εκατοστό,{0} εκατοστό,{0} εκατοστά
        decimeter,δεκ.,,{0} δεκ.,{0} δεκ.,δεκ.,,{0} δεκ.,{0} δεκ.,δεκατόμετρα,,{0} δεκατόμετρο,{0} δεκατόμετρα
        earth-radius,,,,,,,,,ακτίνα της Γης,,{0} ακτίνα της Γης,{0} ακτίνες της Γης
        fathom,οργ.,,{0} οργ.,{0} οργ.,οργιές,,{0} οργ.,{0} οργ.,οργιές,,{0} οργιά,{0} οργιές
        foot,πδ,{0}/πδ,{0} ft,{0} ft,πόδια,{0}/πδ,{0} πδ,{0} πδ,πόδια,{0} ανά πόδι,{0} πόδι,{0} πόδια
        furlong,φέρλ.,,{0} φέρλ.,{0} φέρλ.,φέρλ.,,{0} φέρλ.,{0} φέρλ.,φέρλονγκ,,{0} φέρλονγκ,{0} φέρλονγκ
        inch,ίν.,{0}/ίν.,{0} in,{0} in,ίντσες,{0}/ίν.,{0} ίν.,{0} ίν.,ίντσες,{0} ανά ίντσα,{0} ίντσα,{0} ίντσες
        kilometer,χλμ.,{0}/χλμ.,{0} χλμ.,{0} χλμ.,χλμ.,{0}/χλμ.,{0} χλμ.,{0} χλμ.,χιλιόμετρα,{0} ανά χιλιόμετρο,{0} χιλιόμετρο,{0} χιλιόμετρα
        light-year,έ.φ.,,{0} ly,{0} ly,έτη φωτός,,{0} έ.φ.,{0} έ.φ.,έτη φωτός,,{0} έτος φωτός,{0} έτη φωτός
        meter,μέτρο,{0}/μ.,{0} μ.,{0} μ.,μέτρα,{0}/μ.,{0} μ.,{0} μ.,μέτρα,{0} ανά μέτρο,{0} μέτρο,{0} μέτρα
        micrometer,,,,,μικρόμετρα,,,{0} μm,μικρόμετρα,,{0} μικρόμετρο,{0} μικρόμετρα
        mile,μίλ.,,{0} mi,{0} mi,μίλια,,{0} μίλ.,{0} μίλ.,μίλια,,{0} μίλι,{0} μίλια
        mile-scandinavian,σκανδ. μίλια,,{0}smi,{0}smi,σκανδ. μίλια,,{0} σκανδ. μίλι,{0} σκανδ. μίλια,σκανδιναβικά μίλια,,{0} σκανδιναβικό μίλι,{0} σκανδιναβικά μίλια
        millimeter,χλστ.,,{0} χλστ.,{0} χλστ.,χλστ.,,{0} χλστ.,{0} χλστ.,χιλιοστόμετρα,,{0} χιλιοστόμετρο,{0} χιλιοστόμετρα
        nanometer,,,,,,,,,νανόμετρα,,{0} νανόμετρο,{0} νανόμετρα
        nautical-mile,ν.μ.,,{0} ν.μ.,{0} ν.μ.,ν.μ.,,{0} ν.μ.,{0} ν.μ.,ναυτικά μίλια,,{0} ναυτικό μίλι,{0} ναυτικά μίλια
        parsec,,,,,παρσέκ,,,{0} pc,παρσέκ,,{0} παρσέκ,{0} παρσέκ
        picometer,,,,,,,,,πικόμετρα,,{0} πικόμετρο,{0} πικόμετρα
        point,στ.,,{0} στ.,{0} στ.,στιγμές,,{0} στ.,{0} στ.,στιγμές,,{0} στιγμή,{0} στιγμές
        solar-radius,,,,,ακτίνες Ήλιου,,,{0} R☉,ακτίνες του Ήλιου,,{0} ακτίνα του Ήλιου,{0} ακτίνες του Ήλιου
        yard,γρδ,,{0} yd,{0} yd,γιάρδες,,{0} γρδ,{0} γρδ,γιάρδες,,{0} γιάρδα,{0} γιάρδες
        candela,καντ.,,{0} καντ.,{0} καντ.,καντ.,,{0} καντ.,{0} καντ.,καντέλα,,{0} καντέλα,{0} καντέλα
        lumen,λμ.,,{0} λμ,{0} λμ,λμ.,,{0} λμ.,{0} λμ.,λούμεν,,{0} λούμεν,{0} λούμεν
        lux,λουξ,,{0} λουξ,{0} λουξ,λουξ,,{0} λουξ,{0} λουξ,λουξ,,{0} λουξ,{0} λουξ
        solar-luminosity,,,,,ηλιακές φωτεινότητες,,,{0} L☉,ηλιακές φωτεινότητες,,{0} ηλιακή φωτεινότητα,{0} ηλιακές φωτεινότητες
        carat,κρτ,,{0} κρτ,{0} κρτ,καράτια,,{0} κρτ,{0} κρτ,καράτια,,{0} καράτι,{0} καράτια
        dalton,,,,,Ντάλτον,,,{0} Da,Ντάλτον,,{0} Ντάλτον,{0} Ντάλτον
        earth-mass,,,,,μάζες Γης,,,{0} M⊕,μάζες της Γης,,{0} μάζα της Γης,{0} μάζες της Γης
        grain,κόκ.,,{0} κόκ.,{0} κόκ.,κόκ.,,{0} κόκ.,{0} κόκ.,κόκκος,,{0} κόκκος,{0} κόκκοι
        gram,γρ.,{0}/γρ.,{0} γρ.,{0} γρ.,γραμμ.,{0}/γρ.,{0} γρ.,{0} γρ.,γραμμάρια,{0} ανά γραμμάριο,{0} γραμμάριο,{0} γραμμάρια
        kilogram,kg,{0}/kg,{0} kg,{0} kg,κιλά,{0}/κιλό,{0} κιλό,{0} κιλά,χιλιόγραμμα,{0} ανά χιλιόγραμμο,{0} χιλιόγραμμο,{0} χιλιόγραμμα
        microgram,,,,,,,,,μικρογραμμάρια,,{0} μικρογραμμάριο,{0} μικρογραμμάρια
        milligram,,,,,,,,,χιλιοστόγραμμα,,{0} χιλιοστόγραμμο,{0} χιλιοστόγραμμα
        ounce,,,,,,,,,ουγγιές,{0} ανά ουγγιά,{0} ουγγιά,{0} ουγγιές
        ounce-troy,,,,,ευγενής ουγγιά,,,{0} oz t,ευγενείς ουγγιές,,{0} ευγενής ουγγιά,{0} ευγενείς ουγγιές
        pound,λβ,{0}/λβ,{0} λβ,{0} λβ,λίβρες,{0}/λβ,{0} λβ,{0} λβ,λίβρες,{0} ανά λίβρα,{0} λίβρα,{0} λίβρες
        solar-mass,,,,,μάζες Ήλιου,,,{0} M☉,μάζες του Ήλιου,,{0} μάζα του Ήλιου,{0} μάζες του Ήλιου
        stone,,,,,,,,,stone,,{0} stone,{0} stone
        ton,τ. ΗΠΑ,,{0} τ. ΗΠΑ,{0} τ. ΗΠΑ,τόνοι ΗΠΑ,,{0} τ. ΗΠΑ,{0} τ. ΗΠΑ,τόνοι ΗΠΑ,,{0} τόνος ΗΠΑ,{0} τόνοι ΗΠΑ
        tonne,τ.,,{0} τ.,{0} τ.,τ.,,{0} τ.,{0} τ.,τόνοι,,{0} τόνος,{0} τόνοι
        gigawatt,,,,,γιγαβάτ,,,{0} GW,γιγαβάτ,,{0} γιγαβάτ,{0} γιγαβάτ
        horsepower,hp,,{0} hp,{0} hp,ίπποι,,{0} ίπ.,{0} ίπ.,ίπποι,,{0} ίππος,{0} ίπποι
        kilowatt,,,,,κιλοβάτ,,,{0} kW,κιλοβάτ,,{0} κιλοβάτ,{0} κιλοβάτ
        megawatt,,,,,μεγαβάτ,,,{0} MW,μεγαβάτ,,{0} μεγαβάτ,{0} μεγαβάτ
        milliwatt,,,,,μιλιβάτ,,,{0} mW,μιλιβάτ,,{0} μιλιβάτ,{0} μιλιβάτ
        watt,W,,,{0} W,βατ,,,{0} W,βατ,,{0} βατ,{0} βατ
        atmosphere,,,,,,,,,ατμόσφαιρες,,{0} ατμόσφαιρα,{0} ατμόσφαιρες
        bar,μπαρ,,{0} μπαρ,{0} μπαρ,μπαρ,,{0} μπαρ,{0} μπαρ,μπαρ,,{0} μπαρ,{0} μπαρ
        hectopascal,,,,,,,,,εκτοπασκάλ,,{0} εκτοπασκάλ,{0} εκτοπασκάλ
        inch-ofhg,,,,,,,,,ίντσες στήλης υδραργύρου,,{0} ίντσα στήλης υδραργύρου,{0} ίντσες στήλης υδραργύρου
        kilopascal,,,,,,,,,κιλοπασκάλ,,{0} κιλοπασκάλ,{0} κιλοπασκάλ
        megapascal,,,,,,,,,μεγαπασκάλ,,{0} μεγαπασκάλ,{0} μεγαπασκάλ
        millibar,,,,,,,,,μιλιμπάρ,,{0} μιλιμπάρ,{0} μιλιμπάρ
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,mmHg,,{0} mmHg,{0} mmHg,χιλιοστόμετρα στήλης υδραργύρου,,{0} χιλιοστόμετρο στήλης υδραργύρου,{0} χιλιοστόμετρα στήλης υδραργύρου
        pascal,,,,,,,,,πασκάλ,,{0} πασκάλ,{0} πασκάλ
        pound-force-per-square-inch,,,,,,,,,λίβρες ανά τετραγωνική ίντσα,,{0} λίβρα ανά τετραγωνική ίντσα,{0} λίβρες ανά τετραγωνική ίντσα
        beaufort,Bf,,{0} Bf,{0} Bf,μποφ.,,{0} μποφ.,{0} μποφ.,μποφόρ,,{0} μποφόρ,{0} μποφόρ
        kilometer-per-hour,χλμ/ώ.,,{0} χλμ/ώ.,{0} χλμ/ώ.,χλμ./ώρα,,{0} χλμ./ώρα,{0} χλμ./ώρα,χιλιόμετρα ανά ώρα,,{0} χιλιόμετρο ανά ώρα,{0} χιλιόμετρα ανά ώρα
        knot,κμβ,,{0} κμβ,{0} κμβ,κμβ,,{0} κμβ,{0} κμβ,κόμβος,,{0} κόμβος,{0} κόμβοι
        light-speed,φώς,,{0} φως,{0} φως,φως,,{0} φως,{0} φως,φως,,{0} φως,{0} φως
        meter-per-second,μ./δ.,,{0} μ./δ.,{0} μ./δ.,μέτρα/δευτ.,,{0} μέτρο/δευτ.,{0} μέτρα/δευτ.,μέτρα ανά δευτερόλεπτο,,{0} μέτρο ανά δευτερόλεπτο,{0} μέτρα ανά δευτερόλεπτο
        mile-per-hour,μίλια/ώ.,,{0} μίλι/ώ.,{0} μίλια/ώ.,μίλια/ώρα,,{0} μίλι/ώρα,{0} μίλια/ώρα,μίλια ανά ώρα,,{0} μίλι ανά ώρα,{0} μίλια ανά ώρα
        celsius,,,,,βθμ C,,,{0}°C,βαθμοί Κελσίου,,{0} βαθμός Κελσίου,{0} βαθμοί Κελσίου
        fahrenheit,,,,,βθμ F,,,{0}°F,βαθμοί Φαρενάιτ,,{0} βαθμός Φαρενάιτ,{0} βαθμοί Φαρενάιτ
        generic,,,,,,,,,°,,{0} βαθμός,{0} βαθμοί
        kelvin,,,,,,,,,βαθμοί Κέλβιν,,{0} βαθμός Κέλβιν,{0} βαθμοί Κέλβιν
        newton-meter,,,,,,,,,νιουτόμετρα,,{0} νιουτόμετρο,{0} νιουτόμετρα
        pound-force-foot,λβρ⋅πδ,,{0} λβρ⋅πδ,{0} λβρ⋅πδ,λβρ⋅πδ,,{0} λβρ⋅πδ,{0} λβρ⋅πδ,λίβρες-πόδια,,{0} λίβρα-πόδι,{0} λίβρες-πόδια
        acre-foot,ακρ πδ,,{0} ακρ πδ,{0} ακρ πδ,ακρ πόδια,,{0} ακρ πδ,{0} ακρ πδ,ακρ-πόδια,,{0} ακρ-πόδι,{0} ακρ-πόδια
        barrel,βρλ,,{0} βρλ,{0} βρλ,βαρέλι,,{0} βρλ,{0} βρλ,βαρέλια,,{0} βαρέλι,{0} βαρέλια
        bushel,μπ.,,{0} μπ.,{0} μπ.,μπ.,,{0} μπ.,{0} μπ.,μπούσελ,,{0} μπούσελ,{0} μπούσελ
        centiliter,,,,,,,,,εκατοστόλιτρα,,{0} εκατοστόλιτρο,{0} εκατοστόλιτρα
        cubic-centimeter,,,,,,,,,κυβικά εκατοστά,{0} ανά κυβικό εκατοστό,{0} κυβικό εκατοστό,{0} κυβικά εκατοστά
        cubic-foot,,,,,,,,,κυβικά πόδια,,{0} κυβικό πόδι,{0} κυβικά πόδια
        cubic-inch,,,,,,,,,κυβικές ίντσες,,{0} κυβική ίντσα,{0} κυβικές ίντσες
        cubic-kilometer,,,,,,,,,κυβικά χιλιόμετρα,,{0} κυβικό χιλιόμετρο,{0} κυβικά χιλιόμετρα
        cubic-meter,,,,,,,,,κυβικά μέτρα,{0} ανά κυβικό μέτρο,{0} κυβικό μέτρο,{0} κυβικά μέτρα
        cubic-mile,,,,,,,,,κυβικά μίλια,,{0} κυβικό μίλι,{0} κυβικά μίλια
        cubic-yard,yd³,,{0} κυβ. γιάρδα,{0} κυβ. γιάρδες,κυβ. γιάρδες,,{0} κυβ. γιάρδα,{0} κυβ. γιάρδες,κυβικές γιάρδες,,{0} κυβική γιάρδα,{0} κυβικές γιάρδες
        cup,κύπ.,,{0} κύπ.,{0} κύπ.,κύπ.,,{0} κύπ.,{0} κύπ.,κύπελλα,,{0} κύπελλο,{0} κύπελλα
        cup-metric,μ. κύπ.,,{0} μ. κύπ.,{0} μ. κύπ.,μετρ. κύπελλο,,{0} μετρ. κύπελλο,{0} μετρ. κύπελλα,μετρικά κύπελλα,,{0} μετρικό κύπελλο,{0} μετρικά κύπελλα
        deciliter,,,,,,,,,δεκατόλιτρα,,{0} δεκατόλιτρο,{0} δεκατόλιτρα
        dessert-spoon,κ.φρ.,,{0} κ.φρ.,{0} κ.φρ.,κ.φρ.,,{0} κ.φρ.,{0} κ.φρ.,κουταλιά φρούτου,,{0} κουταλιά φρούτου,{0} κουταλιές φρούτου
        dessert-spoon-imperial,αγγλ. κ.φρ.,,{0} αγγλ. κ.φρ.,{0} αγγλ. κ.φρ.,αγγλ. κουτ. φρ.,,{0} αγγλ. κουτ. φρ.,{0} αγγλ. κουτ. φρ.,αγγλοσαξονική κουταλιά φρούτου,,{0} αγγλοσαξονική κουταλιά φρούτου,{0} αγγλοσαξονικές κουταλιές φρούτου
        dram,δρ. όγκου,,{0} δρ. όγκου,{0} δρ. όγκου,δράμι όγκου,,{0} δρ. όγκου,{0} δρ. όγκου,δράμι,,{0} δράμι,{0} δράμια
        drop,σταγ.,,{0} σταγ.,{0} σταγ.,σταγ.,,{0} σταγ.,{0} σταγ.,σταγόνα,,{0} σταγόνα,{0} σταγόνες
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,ουγγιές όγκου,,{0} ουγγιά όγκου,{0} ουγγιές όγκου
        fluid-ounce-imperial,αγγλ. ουγγιές όγκου,,{0} αγγλ. ουγγιά όγκου,{0} αγγλ. ουγγιές όγκου,αγγλ. ουγγιές όγκου,,{0} αγγλ. ουγγιά όγκου,{0} αγγλ. ουγγιές όγκου,αγγλοσαξονικές ουγγιές όγκου,,{0} αγγλοσαξονική ουγγιά όγκου,{0} αγγλοσαξονικές ουγγιές όγκου
        gallon,γαλ.,{0}/γαλ.,{0} γαλ.,{0} γαλ.,γαλ.,{0}/γαλ.,{0} γαλ.,{0} γαλ.,γαλόνια,{0} ανά γαλόνι,{0} γαλόνι,{0} γαλόνια
        gallon-imperial,αγγλοσαξ. γαλόνια,{0}/αγγλοσαξ. γαλόνι,{0} αγγλοσαξ. γαλόνι,{0} αγγλοσαξ. γαλόνια,αγγλοσαξ. γαλόνια,{0}/αγγλοσαξ. γαλόνι,{0} αγγλοσαξ. γαλόνι,{0} αγγλοσαξ. γαλόνια,αγγλοσαξονικά γαλόνια,{0} ανά αγγλοσαξονικό γαλόνι,{0} αγγλοσαξονικό γαλόνι,{0} αγγλοσαξονικά γαλόνια
        hectoliter,,,,,,,,,εκτόλιτρα,,{0} εκτόλιτρο,{0} εκτόλιτρα
        jigger,μεζ.,,{0} μεζ.,{0} μεζ.,μεζ.,,{0} μεζ.,{0} μεζ.,μεζούρα,,{0} μεζούρα,{0} μεζούρες
        liter,λίτρο,{0}/λ.,{0} λ.,{0} λ.,λίτρα,{0}/λ.,{0} λίτ.,{0} λίτ.,λίτρα,{0} ανά λίτρο,{0} λίτρο,{0} λίτρα
        megaliter,,,,,,,,,μεγαλίτρα,,{0} μεγαλίτρο,{0} μεγαλίτρα
        milliliter,,,,,,,,,χιλιοστόλιτρα,,{0} χιλιοστόλιτρο,{0} χιλιοστόλιτρα
        pinch,πρ.,,{0} πρ.,{0} πρ.,πρ.,,{0} πρ.,{0} πρ.,πρέζα,,{0} πρέζα,{0} πρέζες
        pint,πντ,,{0} πντ,{0} πντ,πίντες,,{0} πντ,{0} πντ,πίντες,,{0} πίντα,{0} πίντες
        pint-metric,μ. πίντες,,{0} μ. πίντα,{0} μ. πίντες,μετρικές πίντες,,{0} μετρ. πίντα,{0} μετρ. πίντες,μετρικές πίντες,,{0} μετρική πίντα,{0} μετρικές πίντες
        quart,τέτ. γαλ.,,{0} τέτ. γαλ.,{0} τέτ. γαλ.,τέταρτα γαλονιού,,{0} τέτ. γαλ.,{0} τέτ. γαλ.,τέταρτα του γαλονιού,,{0} τέταρτο του γαλονιού,{0} τέταρτα του γαλονιού
        quart-imperial,αγγλ. τέτ. γαλ.,,{0} αγγλ. τέτ. γαλ.,{0} αγγλ. τέτ. γαλ.,αγγλ. τέτ. γαλ.,,{0} αγγλ. τέτ. γαλ.,{0} αγγλ. τέτ. γαλ.,αγγλοσαξονικά τέταρτα του γαλονιού,,{0} αγγλοσαξονικό τέταρτο του γαλονιού,{0} αγγλοσαξονικά τέταρτα του γαλονιού
        tablespoon,κ.σ.,,{0} κ.σ.,{0} κ.σ.,κ.σ.,,{0} κ.σ.,{0} κ.σ.,κουταλιές της σούπας,,{0} κουταλιά της σούπας,{0} κουταλιές της σούπας
        teaspoon,κ.γ.,,{0} κ.γ.,{0} κ.γ.,κ.γ.,,{0} κ.γ.,{0} κ.γ.,κουταλιές του γλυκού,,{0} κουταλιά του γλυκού,{0} κουταλιές του γλυκού
        """.trimIndent()
  }

  private val el_Prefixes: String by lazy {
    """square,,,τετραγωνικά {0}
        cubic,,,κυβικά {0}
        per,,,{0} ανά {1}
        1024p1,κμπ-{0},κμπ-{0},κιμπι-{0}
        1024p2,μμπ-{0},μμπ-{0},μεμπι-{0}
        1024p3,γκμ-{0},γκμ-{0},γκιμπι-{0}
        1024p4,τμπ-{0},τμπ-{0},τεμπι-{0}
        1024p5,πμπ-{0},πμπ-{0},πεμπι-{0}
        1024p6,εξμ-{0},εξμ-{0},εξμπι-{0}
        1024p7,ζμπ-{0},ζμπ-{0},ζεμπι-{0}
        1024p8,γμπ-{0},γμπ-{0},γιομπι-{0}
        10p-1,δεκατ-{0},δκτ-{0},δεκατο-{0}
        10p-12,πικ-{0},πκ-{0},πικο-{0}
        10p-15,φεμτ-{0},φμτ-{0},φεμτο-{0}
        10p-18,αττ-{0},ατ-{0},αττο-{0}
        10p-2,εκατοστ-{0},εκστ-{0},εκατοστο-{0}
        10p-21,ζεπ-{0},ζπτ-{0},ζεπτο-{0}
        10p-24,γιοκ-{0},γκτ-{0},γιοκτο-{0}
        10p-27,ρντ-{0},ροντ-{0},ροντο-{0}
        10p-3,χιλιοστ-{0},χλστ-{0},χιλιοστο-{0}
        10p-30,κκτ-{0},κουεκ-{0},κουεκτο-{0}
        10p-6,μικρ-{0},μκρ-{0},μικρο-{0}
        10p-9,ναν-{0},νν-{0},νανο-{0}
        10p1,δεκ-{0},δκ-{0},δεκα-{0}
        10p12,τερ-{0},τρ-{0},τερα-{0}
        10p15,πετ-{0},πτ-{0},πετα-{0}
        10p18,εξ-{0},εξ-{0},εξα-{0}
        10p2,εκατ-{0},εκτ-{0},εκατο-{0}
        10p21,ζετ-{0},ζτ-{0},ζεττα-{0}
        10p24,γιοτ-{0},γττ-{0},γιοττα-{0}
        10p27,ρνν-{0},ρον-{0},ροννα-{0}
        10p3,χιλ-{0},χλ-{0},χιλιο-{0}
        10p30,κετ-{0},κττ-{0},κεττα-{0}
        10p6,μεγ-{0},μγ-{0},μεγα-{0}
        10p9,γιγ-{0},γγ-{0},γιγα-{0}
        """.trimIndent()
  }

  private val el_CY_Units: String? = null

  private val el_CY_Prefixes: String? = null

  private val el_polyton_Units: String? = null

  private val el_polyton_Prefixes: String? = null

  private val en_Units: String by lazy {
    """g-force,g-force,,{0}G,{0}Gs,g-force,,{0} G,{0} G,g-force,,{0} g-force,{0} g-force
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,meters/sec²,,{0} m/s²,{0} m/s²,meters per second squared,,{0} meter per second squared,{0} meters per second squared
        arc-minute,arcmin,,{0}′,{0}′,arcmins,,{0} arcmin,{0} arcmins,arcminutes,,{0} arcminute,{0} arcminutes
        arc-second,arcsec,,{0}″,{0}″,arcsecs,,{0} arcsec,{0} arcsecs,arcseconds,,{0} arcsecond,{0} arcseconds
        degree,deg,,{0}°,{0}°,degrees,,{0} deg,{0} deg,degrees,,{0} degree,{0} degrees
        radian,rad,,{0}rad,{0}rad,radians,,{0} rad,{0} rad,radians,,{0} radian,{0} radians
        revolution,rev,,{0}rev,{0}rev,rev,,{0} rev,{0} rev,revolutions,,{0} revolution,{0} revolutions
        acre,acre,,{0}ac,{0}ac,acres,,{0} ac,{0} ac,acres,,{0} acre,{0} acres
        dunam,dunam,,{0}dunam,{0}dunam,dunams,,{0} dunam,{0} dunam,dunams,,{0} dunam,{0} dunams
        hectare,hectare,,{0}ha,{0}ha,hectares,,{0} ha,{0} ha,hectares,,{0} hectare,{0} hectares
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,cm²,{0}/cm²,{0} cm²,{0} cm²,square centimeters,{0} per square centimeter,{0} square centimeter,{0} square centimeters
        square-foot,ft²,,{0}ft²,{0}ft²,sq feet,,{0} sq ft,{0} sq ft,square feet,,{0} square foot,{0} square feet
        square-inch,in²,{0}/in²,{0}in²,{0}in²,inches²,{0}/in²,{0} in²,{0} in²,square inches,{0} per square inch,{0} square inch,{0} square inches
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,km²,{0}/km²,{0} km²,{0} km²,square kilometers,{0} per square kilometer,{0} square kilometer,{0} square kilometers
        square-meter,meters²,{0}/m²,{0}m²,{0}m²,meters²,{0}/m²,{0} m²,{0} m²,square meters,{0} per square meter,{0} square meter,{0} square meters
        square-mile,mi²,{0}/mi²,{0}mi²,{0}mi²,sq miles,{0}/mi²,{0} sq mi,{0} sq mi,square miles,{0} per square mile,{0} square mile,{0} square miles
        square-yard,yd²,,{0}yd²,{0}yd²,yards²,,{0} yd²,{0} yd²,square yards,,{0} square yard,{0} square yards
        item,item,,{0}item,{0}items,item,,{0} item,{0} items,items,,{0} item,{0} items
        karat,karat,,{0}kt,{0}kt,karats,,{0} kt,{0} kt,karats,,{0} karat,{0} karats
        milligram-ofglucose-per-deciliter,mg/dL,,{0}mg/dL,{0}mg/dL,mg/dL,,{0} mg/dL,{0} mg/dL,milligrams per deciliter,,{0} milligram per deciliter,{0} milligrams per deciliter
        millimole-per-liter,mmol/L,,{0}mmol/L,{0}mmol/L,millimol/liter,,{0} mmol/L,{0} mmol/L,millimoles per liter,,{0} millimole per liter,{0} millimoles per liter
        mole,mol,,{0}mol,{0}mol,mole,,{0} mol,{0} mol,moles,,{0} mole,{0} moles
        percent,%,,{0}%,{0}%,percent,,{0}%,{0}%,percent,,{0} percent,{0} percent
        permille,‰,,{0}‰,{0}‰,permille,,{0}‰,{0}‰,permille,,{0} permille,{0} permille
        permillion,ppm,,{0}ppm,{0}ppm,parts/million,,{0} ppm,{0} ppm,parts per million,,{0} part per million,{0} parts per million
        permyriad,‱,,{0}‱,{0}‱,permyriad,,{0}‱,{0}‱,permyriad,,{0} permyriad,{0} permyriad
        portion-per-1e9,ppb,,{0}ppb,{0}ppb,parts/billion,,{0} ppb,{0} ppb,parts per billion,,{0} part per billion,{0} parts per billion
        liter-per-100-kilometer,L/100km,,{0}L/100km,{0}L/100km,L/100 km,,{0} L/100 km,{0} L/100 km,liters per 100 kilometers,,{0} liter per 100 kilometers,{0} liters per 100 kilometers
        liter-per-kilometer,L/km,,{0}L/km,{0}L/km,liters/km,,{0} L/km,{0} L/km,liters per kilometer,,{0} liter per kilometer,{0} liters per kilometer
        mile-per-gallon,mpg,,{0}mpg,{0}mpg,miles/gal,,{0} mpg,{0} mpg,miles per gallon,,{0} mile per gallon,{0} miles per gallon
        mile-per-gallon-imperial,mpg UK,,{0}m/gUK,{0}m/gUK,miles/gal Imp.,,{0} mpg Imp.,{0} mpg Imp.,miles per Imp. gallon,,{0} mile per Imp. gallon,{0} miles per Imp. gallon
        bit,bit,,{0}bit,{0}bit,bit,,{0} bit,{0} bit,bits,,{0} bit,{0} bits
        byte,B,,{0}B,{0}B,byte,,{0} byte,{0} byte,bytes,,{0} byte,{0} bytes
        gigabit,Gb,,{0}Gb,{0}Gb,Gbit,,{0} Gb,{0} Gb,gigabits,,{0} gigabit,{0} gigabits
        gigabyte,GB,,{0}GB,{0}GB,GByte,,{0} GB,{0} GB,gigabytes,,{0} gigabyte,{0} gigabytes
        kilobit,kb,,{0}kb,{0}kb,kbit,,{0} kb,{0} kb,kilobits,,{0} kilobit,{0} kilobits
        kilobyte,kB,,{0}kB,{0}kB,kByte,,{0} kB,{0} kB,kilobytes,,{0} kilobyte,{0} kilobytes
        megabit,Mb,,{0}Mb,{0}Mb,Mbit,,{0} Mb,{0} Mb,megabits,,{0} megabit,{0} megabits
        megabyte,MB,,{0}MB,{0}MB,MByte,,{0} MB,{0} MB,megabytes,,{0} megabyte,{0} megabytes
        petabyte,PB,,{0}PB,{0}PB,PByte,,{0} PB,{0} PB,petabytes,,{0} petabyte,{0} petabytes
        terabit,Tb,,{0}Tb,{0}Tb,Tbit,,{0} Tb,{0} Tb,terabits,,{0} terabit,{0} terabits
        terabyte,TB,,{0}TB,{0}TB,TByte,,{0} TB,{0} TB,terabytes,,{0} terabyte,{0} terabytes
        century,c,,{0}c,{0}c,c,,{0} c,{0} c,centuries,,{0} century,{0} centuries
        day,day,{0}/d,{0}d,{0}d,days,{0}/d,{0} day,{0} days,days,{0} per day,{0} day,{0} days
        decade,dec,,{0}dec,{0}dec,dec,,{0} dec,{0} dec,decades,,{0} decade,{0} decades
        hour,hour,{0}/h,{0}h,{0}h,hours,{0}/h,{0} hr,{0} hr,hours,{0} per hour,{0} hour,{0} hours
        microsecond,μsec,,{0}μs,{0}μs,μsecs,,{0} μs,{0} μs,microseconds,,{0} microsecond,{0} microseconds
        millisecond,msec,,{0}ms,{0}ms,millisecs,,{0} ms,{0} ms,milliseconds,,{0} millisecond,{0} milliseconds
        minute,min,{0}/min,{0}m,{0}m,mins,{0}/min,{0} min,{0} min,minutes,{0} per minute,{0} minute,{0} minutes
        month,month,{0}/m,{0}m,{0}m,months,{0}/m,{0} mth,{0} mths,months,{0} per month,{0} month,{0} months
        nanosecond,ns,,{0}ns,{0}ns,nanosecs,,{0} ns,{0} ns,nanoseconds,,{0} nanosecond,{0} nanoseconds
        night,nights,{0}/night,{0}night,{0}nights,nights,{0}/night,{0} night,{0} nights,nights,{0} per night,{0} night,{0} nights
        quarter,qtr,{0}/q,{0}q,{0}q,qtr,{0}/q,{0} qtr,{0} qtrs,quarters,{0}/q,{0} quarter,{0} quarters
        second,sec,{0}/s,{0}s,{0}s,secs,{0}/s,{0} sec,{0} sec,seconds,{0} per second,{0} second,{0} seconds
        week,wk,{0}/w,{0}w,{0}w,weeks,{0}/w,{0} wk,{0} wks,weeks,{0} per week,{0} week,{0} weeks
        year,yr,{0}/y,{0}y,{0}y,years,{0}/y,{0} yr,{0} yrs,years,{0} per year,{0} year,{0} years
        ampere,amp,,{0}A,{0}A,amps,,{0} A,{0} A,amperes,,{0} ampere,{0} amperes
        milliampere,mA,,{0}mA,{0}mA,milliamps,,{0} mA,{0} mA,milliamperes,,{0} milliampere,{0} milliamperes
        ohm,ohm,,{0}Ω,{0}Ω,ohms,,{0} Ω,{0} Ω,ohms,,{0} ohm,{0} ohms
        volt,volt,,{0}V,{0}V,volts,,{0} V,{0} V,volts,,{0} volt,{0} volts
        british-thermal-unit,BTU,,{0}Btu,{0}Btu,BTU,,{0} Btu,{0} Btu,British thermal units,,{0} British thermal unit,{0} British thermal units
        calorie,cal,,{0}cal,{0}cal,cal,,{0} cal,{0} cal,calories,,{0} calorie,{0} calories
        electronvolt,eV,,{0}eV,{0}eV,electronvolt,,{0} eV,{0} eV,electronvolts,,{0} electronvolt,{0} electronvolts
        foodcalorie,Cal,,{0}Cal,{0}Cal,Cal,,{0} Cal,{0} Cal,Calories,,{0} Calorie,{0} Calories
        joule,joule,,{0}J,{0}J,joules,,{0} J,{0} J,joules,,{0} joule,{0} joules
        kilocalorie,kcal,,{0}kcal,{0}kcal,kcal,,{0} kcal,{0} kcal,kilocalories,,{0} kilocalorie,{0} kilocalories
        kilojoule,kJ,,{0}kJ,{0}kJ,kilojoule,,{0} kJ,{0} kJ,kilojoules,,{0} kilojoule,{0} kilojoules
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,kW-hour,,{0} kWh,{0} kWh,kilowatt-hours,,{0} kilowatt hour,{0} kilowatt-hours
        therm-us,US therm,,{0}US therm,{0}US therms,US therm,,{0} US therm,{0} US therms,US therms,,{0} US therm,{0} US therms
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0}kWh/100km,kWh/100km,,{0} kWh/100km,{0} kWh/100km,kilowatt-hours per 100 kilometers,,{0} kilowatt-hour per 100 kilometers,{0} kilowatt-hours per 100 kilometers
        newton,N,,{0}N,{0}N,newton,,{0} N,{0} N,newtons,,{0} newton,{0} newtons
        pound-force,lbf,,{0}lbf,{0}lbf,pound-force,,{0} lbf,{0} lbf,pounds of force,,{0} pound of force,{0} pounds of force
        gigahertz,GHz,,{0}GHz,{0}GHz,GHz,,{0} GHz,{0} GHz,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,Hz,,{0}Hz,{0}Hz,Hz,,{0} Hz,{0} Hz,hertz,,{0} hertz,{0} hertz
        kilohertz,kHz,,{0}kHz,{0}kHz,kHz,,{0} kHz,{0} kHz,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,MHz,,{0}MHz,{0}MHz,MHz,,{0} MHz,{0} MHz,megahertz,,{0} megahertz,{0} megahertz
        dot,dot,,{0}dot,{0}dot,dots,,{0} dot,{0} dots,dots,,{0} dot,{0} dots
        dot-per-centimeter,dpcm,,{0}dpcm,{0}dpcm,dpcm,,{0} dpcm,{0} dpcm,dots per centimeter,,{0} dot per centimeter,{0} dots per centimeter
        dot-per-inch,dpi,,{0}dpi,{0}dpi,dpi,,{0} dpi,{0} dpi,dots per inch,,{0} dot per inch,{0} dots per inch
        em,em,,{0}em,{0}em,em,,{0} em,{0} em,typographic ems,,{0} em,{0} ems
        megapixel,MP,,{0}MP,{0}MP,megapixels,,{0} MP,{0} MP,megapixels,,{0} megapixel,{0} megapixels
        pixel,px,,{0}px,{0}px,pixels,,{0} px,{0} px,pixels,,{0} pixel,{0} pixels
        pixel-per-centimeter,ppcm,,{0}ppcm,{0}ppcm,ppcm,,{0} ppcm,{0} ppcm,pixels per centimeter,,{0} pixel per centimeter,{0} pixels per centimeter
        pixel-per-inch,ppi,,{0}ppi,{0}ppi,ppi,,{0} ppi,{0} ppi,pixels per inch,,{0} pixel per inch,{0} pixels per inch
        astronomical-unit,au,,{0}au,{0}au,au,,{0} au,{0} au,astronomical units,,{0} astronomical unit,{0} astronomical units
        centimeter,cm,{0}/cm,{0}cm,{0}cm,cm,{0}/cm,{0} cm,{0} cm,centimeters,{0} per centimeter,{0} centimeter,{0} centimeters
        decimeter,dm,,{0}dm,{0}dm,dm,,{0} dm,{0} dm,decimeters,,{0} decimeter,{0} decimeters
        earth-radius,R⊕,,{0}R⊕,{0}R⊕,earth radius,,{0} R⊕,{0} R⊕,earth radius,,{0} earth radius,{0} earth radius
        fathom,fathom,,{0}fth,{0}fth,fathoms,,{0} fth,{0} fth,fathoms,,{0} fathom,{0} fathoms
        foot,ft,{0}/ft,{0}′,{0}′,feet,{0}/ft,{0} ft,{0} ft,feet,{0} per foot,{0} foot,{0} feet
        furlong,furlong,,{0}fur,{0}fur,furlongs,,{0} fur,{0} fur,furlongs,,{0} furlong,{0} furlongs
        inch,in,{0}/in,{0}″,{0}″,inches,{0}/in,{0} in,{0} in,inches,{0} per inch,{0} inch,{0} inches
        kilometer,km,{0}/km,{0}km,{0}km,km,{0}/km,{0} km,{0} km,kilometers,{0} per kilometer,{0} kilometer,{0} kilometers
        light-year,ly,,{0}ly,{0}ly,light yrs,,{0} ly,{0} ly,light years,,{0} light year,{0} light years
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,{0} m,{0} m,meters,{0} per meter,{0} meter,{0} meters
        micrometer,μm,,{0}μm,{0}μm,μmeters,,{0} μm,{0} μm,micrometers,,{0} micrometer,{0} micrometers
        mile,mi,,{0}mi,{0}mi,miles,,{0} mi,{0} mi,miles,,{0} mile,{0} miles
        mile-scandinavian,smi,,{0}smi,{0}smi,smi,,{0} smi,{0} smi,miles-scandinavian,,{0} mile-scandinavian,{0} miles-scandinavian
        millimeter,mm,,{0}mm,{0}mm,mm,,{0} mm,{0} mm,millimeters,,{0} millimeter,{0} millimeters
        nanometer,nm,,{0}nm,{0}nm,nm,,{0} nm,{0} nm,nanometers,,{0} nanometer,{0} nanometers
        nautical-mile,nmi,,{0}nmi,{0}nmi,nmi,,{0} nmi,{0} nmi,nautical miles,,{0} nautical mile,{0} nautical miles
        parsec,parsec,,{0}pc,{0}pc,parsecs,,{0} pc,{0} pc,parsecs,,{0} parsec,{0} parsecs
        picometer,pm,,{0}pm,{0}pm,pm,,{0} pm,{0} pm,picometers,,{0} picometer,{0} picometers
        point,pts,,{0}pt,{0}pt,points,,{0} pt,{0} pt,points,,{0} point,{0} points
        solar-radius,R☉,,{0}R☉,{0}R☉,solar radii,,{0} R☉,{0} R☉,solar radii,,{0} solar radius,{0} solar radii
        yard,yd,,{0}yd,{0}yd,yards,,{0} yd,{0} yd,yards,,{0} yard,{0} yards
        candela,cd,,{0}cd,{0}cd,candela,,{0} cd,{0} cd,candela,,{0} candela,{0} candela
        lumen,lm,,{0}lm,{0}lm,lumen,,{0} lm,{0} lm,lumen,,{0} lumen,{0} lumen
        lux,lux,,{0}lx,{0}lx,lux,,{0} lx,{0} lx,lux,,{0} lux,{0} lux
        solar-luminosity,L☉,,{0}L☉,{0}L☉,solar luminosities,,{0} L☉,{0} L☉,solar luminosities,,{0} solar luminosity,{0} solar luminosities
        carat,carat,,{0}CD,{0}CD,carats,,{0} CD,{0} CD,carats,,{0} carat,{0} carats
        dalton,Da,,{0}Da,{0}Da,daltons,,{0} Da,{0} Da,daltons,,{0} dalton,{0} daltons
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,Earth masses,,{0} M⊕,{0} M⊕,Earth masses,,{0} Earth mass,{0} Earth masses
        grain,gr,,{0}gr,{0}gr,grains,,{0} gr,{0} gr,grains,,{0} grain,{0} grains
        gram,gram,{0}/g,{0}g,{0}g,grams,{0}/g,{0} g,{0} g,grams,{0} per gram,{0} gram,{0} grams
        kilogram,kg,{0}/kg,{0}kg,{0}kg,kg,{0}/kg,{0} kg,{0} kg,kilograms,{0} per kilogram,{0} kilogram,{0} kilograms
        microgram,μg,,{0}μg,{0}μg,μg,,{0} μg,{0} μg,micrograms,,{0} microgram,{0} micrograms
        milligram,mg,,{0}mg,{0}mg,mg,,{0} mg,{0} mg,milligrams,,{0} milligram,{0} milligrams
        ounce,oz,{0}/oz,{0}oz,{0}oz,oz,{0}/oz,{0} oz,{0} oz,ounces,{0} per ounce,{0} ounce,{0} ounces
        ounce-troy,oz t,,{0}oz t,{0}oz t,oz troy,,{0} oz t,{0} oz t,troy ounces,,{0} troy ounce,{0} troy ounces
        pound,lb,{0}/lb,{0}#,{0}#,pounds,{0}/lb,{0} lb,{0} lb,pounds,{0} per pound,{0} pound,{0} pounds
        solar-mass,M☉,,{0}M☉,{0}M☉,solar masses,,{0} M☉,{0} M☉,solar masses,,{0} solar mass,{0} solar masses
        stone,stone,,{0}st,{0}st,stones,,{0} st,{0} st,stones,,{0} stone,{0} stones
        ton,ton,,{0}tn,{0}tn,tons,,{0} tn,{0} tn,tons,,{0} ton,{0} tons
        tonne,t,,{0}t,{0}t,t,,{0} t,{0} t,metric tons,,{0} metric ton,{0} metric tons
        gigawatt,GW,,{0}GW,{0}GW,GW,,{0} GW,{0} GW,gigawatts,,{0} gigawatt,{0} gigawatts
        horsepower,hp,,{0}hp,{0}hp,hp,,{0} hp,{0} hp,horsepower,,{0} horsepower,{0} horsepower
        kilowatt,kW,,{0}kW,{0}kW,kW,,{0} kW,{0} kW,kilowatts,,{0} kilowatt,{0} kilowatts
        megawatt,MW,,{0}MW,{0}MW,MW,,{0} MW,{0} MW,megawatts,,{0} megawatt,{0} megawatts
        milliwatt,mW,,{0}mW,{0}mW,mW,,{0} mW,{0} mW,milliwatts,,{0} milliwatt,{0} milliwatts
        watt,watt,,{0}W,{0}W,watts,,{0} W,{0} W,watts,,{0} watt,{0} watts
        atmosphere,atm,,{0}atm,{0}atm,atm,,{0} atm,{0} atm,atmospheres,,{0} atmosphere,{0} atmospheres
        bar,bar,,{0}bar,{0}bar,bar,,{0} bar,{0} bar,bars,,{0} bar,{0} bars
        gasoline-energy-density,gas-equiv,,{0}gas-equiv,{0}gas-equiv,gas-equiv,,{0} gas-equiv,{0} gas-equiv,of gasoline equivalent,,{0} of gasoline equivalent,{0} of gasoline equivalent
        hectopascal,hPa,,{0}hPa,{0}hPa,hPa,,{0} hPa,{0} hPa,hectopascals,,{0} hectopascal,{0} hectopascals
        inch-ofhg,″ Hg,,{0}″ Hg,{0}″ Hg,inHg,,{0} inHg,{0} inHg,inches of mercury,,{0} inch of mercury,{0} inches of mercury
        kilopascal,kPa,,{0}kPa,{0}kPa,kPa,,{0} kPa,{0} kPa,kilopascals,,{0} kilopascal,{0} kilopascals
        megapascal,MPa,,{0}MPa,{0}MPa,MPa,,{0} MPa,{0} MPa,megapascals,,{0} megapascal,{0} megapascals
        millibar,mbar,,{0}mb,{0}mb,mbar,,{0} mbar,{0} mbar,millibars,,{0} millibar,{0} millibars
        millimeter-ofhg,mmHg,,{0}mmHg,{0}mmHg,mmHg,,{0} mmHg,{0} mmHg,millimeters of mercury,,{0} millimeter of mercury,{0} millimeters of mercury
        pascal,Pa,,{0}Pa,{0}Pa,Pa,,{0} Pa,{0} Pa,pascals,,{0} pascal,{0} pascals
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,psi,,{0} psi,{0} psi,pounds-force per square inch,,{0} pound-force per square inch,{0} pounds-force per square inch
        beaufort,Bft,,B{0},B{0},Bft,,B {0},B {0},Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,km/hr,,{0}km/h,{0}km/h,km/hour,,{0} km/h,{0} km/h,kilometers per hour,,{0} kilometer per hour,{0} kilometers per hour
        knot,kn,,{0}kn,{0}kn,kn,,{0} kn,{0} kn,knots,,{0} knot,{0} knots
        light-speed,light,,{0}light,{0}light,light,,{0} light,{0} light,light,,{0} light,{0} light
        meter-per-second,m/s,,{0}m/s,{0}m/s,meters/sec,,{0} m/s,{0} m/s,meters per second,,{0} meter per second,{0} meters per second
        mile-per-hour,mi/hr,,{0}mph,{0}mph,miles/hour,,{0} mph,{0} mph,miles per hour,,{0} mile per hour,{0} miles per hour
        celsius,°C,,{0}°C,{0}°C,deg. C,,{0}°C,{0}°C,degrees Celsius,,{0} degree Celsius,{0} degrees Celsius
        fahrenheit,°F,,{0}°,{0}°,deg. F,,{0}°F,{0}°F,degrees Fahrenheit,,{0} degree Fahrenheit,{0} degrees Fahrenheit
        generic,°,,{0}°,{0}°,deg. temp.,,{0}°,{0}°,degrees temperature,,{0} degree temperature,{0} degrees temperature
        kelvin,K,,{0}K,{0}K,K,,{0} K,{0} K,kelvins,,{0} kelvin,{0} kelvins
        newton-meter,N⋅m,,{0}N⋅m,{0}N⋅m,N⋅m,,{0} N⋅m,{0} N⋅m,newton-meters,,{0} newton-meter,{0} newton-meters
        pound-force-foot,lbf⋅ft,,{0}lbf⋅ft,{0}lbf⋅ft,lbf⋅ft,,{0} lbf⋅ft,{0} lbf⋅ft,pound-force-feet,,{0} pound-force-foot,{0} pound-force-feet
        acre-foot,acre ft,,{0}ac ft,{0}ac ft,acre ft,,{0} ac ft,{0} ac ft,acre-feet,,{0} acre-foot,{0} acre-feet
        barrel,bbl,,{0}bbl,{0}bbl,barrel,,{0} bbl,{0} bbl,barrels,,{0} barrel,{0} barrels
        bushel,bushel,,{0}bu,{0}bu,bushels,,{0} bu,{0} bu,bushels,,{0} bushel,{0} bushels
        centiliter,cL,,{0}cL,{0}cL,cL,,{0} cL,{0} cL,centiliters,,{0} centiliter,{0} centiliters
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,cm³,{0}/cm³,{0} cm³,{0} cm³,cubic centimeters,{0} per cubic centimeter,{0} cubic centimeter,{0} cubic centimeters
        cubic-foot,ft³,,{0}ft³,{0}ft³,feet³,,{0} ft³,{0} ft³,cubic feet,,{0} cubic foot,{0} cubic feet
        cubic-inch,in³,,{0}in³,{0}in³,inches³,,{0} in³,{0} in³,cubic inches,,{0} cubic inch,{0} cubic inches
        cubic-kilometer,km³,,{0}km³,{0}km³,km³,,{0} km³,{0} km³,cubic kilometers,,{0} cubic kilometer,{0} cubic kilometers
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,m³,{0}/m³,{0} m³,{0} m³,cubic meters,{0} per cubic meter,{0} cubic meter,{0} cubic meters
        cubic-mile,mi³,,{0}mi³,{0}mi³,mi³,,{0} mi³,{0} mi³,cubic miles,,{0} cubic mile,{0} cubic miles
        cubic-yard,yd³,,{0}yd³,{0}yd³,yards³,,{0} yd³,{0} yd³,cubic yards,,{0} cubic yard,{0} cubic yards
        cup,cup,,{0}c,{0}c,cups,,{0} c,{0} c,cups,,{0} cup,{0} cups
        cup-metric,mcup,,{0}mc,{0}mc,mcup,,{0} mc,{0} mc,metric cups,,{0} metric cup,{0} metric cups
        deciliter,dL,,{0}dL,{0}dL,dL,,{0} dL,{0} dL,deciliters,,{0} deciliter,{0} deciliters
        dessert-spoon,dsp,,{0}dsp,{0}dsp,dessert spoons,,{0} dsp,{0} dsp,dessert spoons,,{0} dessert spoon,{0} dessert spoons
        dessert-spoon-imperial,dsp Imp,,{0}dsp-Imp,{0}dsp-Imp,Imp. dessert spoons,,{0} dsp-Imp.,{0} dsp-Imp.,Imp. dessert spoons,,{0} Imp. dessert spoon,{0} Imp. dessert spoons
        dram,fl.dr.,,{0}fl.dr.,{0}fl.dr.,drams,,{0} dram,{0} drams,drams,,{0} dram,{0} drams
        drop,dr,,{0}dr,{0}dr,drops,,{0} dr,{0} drdrops,drops,,{0} drop,{0} drops
        fluid-ounce,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,fluid ounces,,{0} fluid ounce,{0} fluid ounces
        fluid-ounce-imperial,Imp fl oz,,{0}fl oz Im,{0}fl oz Im,Imp. fl oz,,{0} fl oz Imp.,{0} fl oz Imp.,Imp. fluid ounces,,{0} Imp. fluid ounce,{0} Imp. fluid ounces
        gallon,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal US,{0} gal,{0} gal,gallons,{0} per gallon,{0} gallon,{0} gallons
        gallon-imperial,Imp gal,{0}/galIm,{0}galIm,{0}galIm,Imp. gal,{0}/galImp,{0} gal Imp.,{0} gal Imp.,Imp. gallons,{0} per Imp. gallon,{0} Imp. gallon,{0} Imp. gallons
        hectoliter,hL,,{0}hL,{0}hL,hL,,{0} hL,{0} hL,hectoliters,,{0} hectoliter,{0} hectoliters
        jigger,jigger,,{0}jigger,{0}jigger,jiggers,,{0} jigger,{0} jiggers,jiggers,,{0} jigger,{0} jiggers
        liter,liter,{0}/L,{0}L,{0}L,liters,{0}/L,{0} L,{0} L,liters,{0} per liter,{0} liter,{0} liters
        megaliter,ML,,{0}ML,{0}ML,ML,,{0} ML,{0} ML,megaliters,,{0} megaliter,{0} megaliters
        milliliter,mL,,{0}mL,{0}mL,mL,,{0} mL,{0} mL,milliliters,,{0} milliliter,{0} milliliters
        pinch,pn,,{0}pn,{0}pn,pinches,,{0} pn,{0} pn,pinches,,{0} pinch,{0} pinches
        pint,pt,,{0}pt,{0}pt,pints,,{0} pt,{0} pt,pints,,{0} pint,{0} pints
        pint-metric,pt,,{0}mpt,{0}mpt,mpt,,{0} mpt,{0} mpt,metric pints,,{0} metric pint,{0} metric pints
        quart,qt,,{0}qt,{0}qt,qts,,{0} qt,{0} qt,quarts,,{0} quart,{0} quarts
        quart-imperial,qt Imp,,{0}qt-Imp.,{0}qt-Imp.,Imp. quarts,,{0} qt-Imp.,{0} qt-Imp.,Imp. quarts,,{0} Imp. quart,{0} Imp. quarts
        tablespoon,tbsp,,{0}tbsp,{0}tbsp,tbsp,,{0} tbsp,{0} tbsp,tablespoons,,{0} tablespoon,{0} tablespoons
        teaspoon,tsp,,{0}tsp,{0}tsp,tsp,,{0} tsp,{0} tsp,teaspoons,,{0} teaspoon,{0} teaspoons
        """.trimIndent()
  }

  private val en_Prefixes: String by lazy {
    """square,,,square {0}
        cubic,,,cubic {0}
        times,,,{0}-{1}
        per,,,{0} per {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobi{0}
        10p-1,,,deci{0}
        10p-12,,,pico{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,milli{0}
        10p-30,,,quecto{0}
        10p-6,,,micro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hecto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val en_001_Units: String by lazy {
    """meter-per-square-second,,,,,metres/sec²,,{0} m/s²,{0} m/s²,metres per second squared,,{0} metre per second squared,{0} metres per second squared
        square-centimeter,,,,,,,,,square centimetres,{0} per square centimetre,{0} square centimetre,{0} square centimetres
        square-kilometer,,,,,,,,,square kilometres,{0} per square kilometre,{0} square kilometre,{0} square kilometres
        square-meter,m²,{0}/m²,{0}m²,{0}m²,m²,{0}/m²,{0} m²,{0} m²,square metres,{0} per square metre,{0} square metre,{0} square metres
        karat,carat,,{0}ct,{0}ct,carats,,{0} ct,{0} ct,carats,,{0} carat,{0} carats
        milligram-ofglucose-per-deciliter,mg/dl,,{0}mg/dl,{0}mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligrams per decilitre,,{0} milligram per decilitre,{0} milligrams per decilitre
        millimole-per-liter,mmol/l,,{0}mmol/l,{0}mmol/l,millimole/litre,,{0} mmol/l,{0} mmol/l,millimoles per litre,,{0} millimole per litre,{0} millimoles per litre
        percent,,,,,per cent,,{0}%,{0}%,per cent,,{0} per cent,{0} per cent
        permille,,,,,per mille,,{0}‰,{0}‰,per mille,,{0} per mille,{0} per mille
        liter-per-100-kilometer,l/100km,,{0}l/100km,{0}l/100km,l/100 km,,{0} l/100 km,{0} l/100 km,litres per 100 kilometres,,{0} litre per 100 kilometres,{0} litres per 100 kilometres
        liter-per-kilometer,l/km,,{0}l/km,{0}l/km,litres/km,,{0} l/km,{0} l/km,litres per kilometre,,{0} litre per kilometre,{0} litres per kilometre
        mile-per-gallon,mpg US,,{0}mpgUS,{0}mpgUS,miles/US gal,,{0} mpg US,{0} mpg US,miles per US gallon,,{0} mile per US gallon,{0} miles per US gallon
        mile-per-gallon-imperial,mpg,,{0}mpg,{0}mpg,miles/gal,,{0} mpg,{0} mpg,miles per gallon,,{0} mile per gallon,{0} miles per gallon
        kilowatt-hour,,,,,,,,,kilowatt-hours,,{0} kilowatt-hour,{0} kilowatt-hours
        kilowatt-hour-per-100-kilometer,,,,,,,,,kilowatt-hours per 100 kilometres,,{0} kilowatt-hour per 100 kilometres,{0} kilowatt-hours per 100 kilometres
        pixel-per-centimeter,,,,,,,,,pixels per centimetre,,{0} pixel per centimetre,{0} pixels per centimetre
        centimeter,,,,,,,,,centimetres,{0} per centimetre,{0} centimetre,{0} centimetres
        decimeter,,,,,,,,,decimetres,,{0} decimetre,{0} decimetres
        earth-radius,,,,,,,,,earth radius,,{0} earth radius,{0} earth radii
        kilometer,,,,,,,,,kilometres,{0} per kilometre,{0} kilometre,{0} kilometres
        meter,,,,,,,,,metres,{0} per metre,{0} metre,{0} metres
        micrometer,,,,,μmetres,,{0} μm,{0} μm,micrometres,,{0} micrometre,{0} micrometres
        mile-scandinavian,,,,,,,,,Scandinavian mile,,{0} Scandinavian mile,{0} Scandinavian miles
        millimeter,,,,,,,,,millimetres,,{0} millimetre,{0} millimetres
        nanometer,,,,,,,,,nanometres,,{0} nanometre,{0} nanometres
        picometer,,,,,,,,,picometres,,{0} picometre,{0} picometres
        candela,,,,,,,,,candela,,{0} candela,{0} candelas
        lumen,,,,,,,,,lumen,,{0} lumen,{0} lumens
        stone,,,,,stone,,{0} st,{0} st,stone,,{0} stone,{0} stone
        tonne,,,,,,,,,tonnes,,{0} tonne,{0} tonnes
        millimeter-ofhg,,,,,,,,,millimetres of mercury,,{0} millimetre of mercury,{0} millimetres of mercury
        kilometer-per-hour,km/h,,{0}km/h,{0}km/h,,,,,kilometres per hour,,{0} kilometre per hour,{0} kilometres per hour
        meter-per-second,,,,,metres/sec,,{0} m/s,{0} m/s,metres per second,,{0} metre per second,{0} metres per second
        generic,,,,,,,,,degrees,,{0} degree temperature,{0} degrees temperature
        kelvin,,,,,,,,,kelvin,,{0} kelvin,{0} kelvin
        newton-meter,,,,,,,,,newton metres,,{0} newton metre,{0} newton metres
        centiliter,cl,,{0}cl,{0}cl,cl,,{0} cl,{0} cl,centilitres,,{0} centilitre,{0} centilitres
        cubic-centimeter,,,,,,,,,cubic centimetres,{0} per cubic centimetre,{0} cubic centimetre,{0} cubic centimetres
        cubic-kilometer,,,,,,,,,cubic kilometres,,{0} cubic kilometre,{0} cubic kilometres
        cubic-meter,,,,,,,,,cubic metres,{0} per cubic metre,{0} cubic metre,{0} cubic metres
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,decilitres,,{0} decilitre,{0} decilitres
        dessert-spoon,US dsp,,{0}US dsp,{0}US dsp,US dstspn,,{0} US dstspn,{0} US dstspn,US dessertspoons,,{0} US dessertspoon,{0} US dessertspoons
        dessert-spoon-imperial,dsp,,{0}dsp,{0}dsp,dstspn,,{0} dstspn,{0} dstspn,dessertspoons,,{0} dessertspoon,{0} dessertspoons
        fluid-ounce,US fl oz,,{0}US fl oz,{0}US fl oz,US fl oz,,{0} US fl oz,{0} US fl oz,US fluid ounces,,{0} US fluid ounce,{0} US fluid ounces
        fluid-ounce-imperial,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,fluid ounces,,{0} fluid ounce,{0} fluid ounces
        gallon,US gal,{0}/USgal,{0}USgal,{0}USgal,US gal,{0}/US gal,{0} US gal,{0} US gal,US gallons,{0} per US gallon,{0} US gallon,{0} US gallons
        gallon-imperial,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal,{0} gal,{0} gal,gallons,{0} per gallon,{0} gallon,{0} gallons
        hectoliter,hl,,{0}hl,{0}hl,hl,,{0} hl,{0} hl,hectolitres,,{0} hectolitre,{0} hectolitres
        liter,litre,{0}/l,{0}l,{0}l,litres,{0}/l,{0} l,{0} l,litres,{0} per litre,{0} litre,{0} litres
        megaliter,Ml,,{0}Ml,{0}Ml,Ml,,{0} Ml,{0} Ml,megalitres,,{0} megalitre,{0} megalitres
        milliliter,ml,,{0}ml,{0}ml,ml,,{0} ml,{0} ml,millilitres,,{0} millilitre,{0} millilitres
        quart,USqt,,{0}USqt,{0}USqt,US qts,,{0} US qt,{0} US qt,US quarts,,{0} US quart,{0} US quarts
        quart-imperial,qt,,{0}qt,{0}qt,qt,,{0} qt,{0} qt,quarts,,{0} quart,{0} quarts
        revolution,,,,,rev,,{0} rev,{0} revs,,,,
        hour,,,,,hours,{0}/h,{0} hr,{0} hrs,,,,
        minute,,,,,mins,{0}/min,{0} min,{0} mins,,,,
        second,,,,,secs,{0}/s,{0} sec,{0} secs,,,,
        carat,carat,,{0}ct,{0}ct,carats,,{0} ct,{0} ct,,,,
        dram,,,,,dram,,{0} dram,{0} drams,,,,
        drop,,,,,drops,,{0} drop,{0} drops,,,,
        pinch,,,,,pinches,,{0} pinch,{0} pinches,,,,
        g-force,g-force,,{0}G,{0}G,,,,,,,,
        pound,lb,{0}/lb,{0}lb,{0}lb,,,,,,,,
        mile-per-hour,mph,,{0}mph,{0}mph,,,,,,,,
        fahrenheit,°F,,{0}°F,{0}°F,,,,,,,,
        jigger,jigger,,{0}jigger,{0}jiggers,,,,,,,,
        """.trimIndent()
  }

  private val en_001_Prefixes: String by lazy {
    """10p1,,,deca{0}
        """.trimIndent()
  }

  private val en_150_Units: String? = null

  private val en_150_Prefixes: String? = null

  private val en_AE_Units: String? = null

  private val en_AE_Prefixes: String? = null

  private val en_AG_Units: String? = null

  private val en_AG_Prefixes: String? = null

  private val en_AI_Units: String? = null

  private val en_AI_Prefixes: String? = null

  private val en_AS_Units: String? = null

  private val en_AS_Prefixes: String? = null

  private val en_AT_Units: String? = null

  private val en_AT_Prefixes: String? = null

  private val en_AU_Units: String by lazy {
    """permille,,,,,per mill,,{0}‰,{0}‰,per mill,,{0} per mill,{0} per mill
        kilowatt-hour,,,,,kWh,,{0} kWh,{0} kWh,kilowatt hours,,{0} kilowatt hour,{0} kilowatt hours
        kilometer,,,,,,,,,kilometre,{0} per kilometre,{0} kilometre,{0} kilometres
        pound-force-per-square-inch,,,,,,,,,pounds per square inch,,{0} pound per square inch,{0} pounds per square inch
        generic,,,,,deg.,,{0}°,{0}°,degrees,,{0} degree,{0} degrees
        fluid-ounce-imperial,Imp fl oz,,{0}fl oz Im,{0}fl oz Im,Imp. fl oz,,{0} fl oz Imp.,{0} fl oz Imp.,Imp. fluid ounces,,{0} Imp. fluid ounce,{0} Imp. fluid ounces
        arc-minute,,,,,arcmin.,,{0} arcmin.,{0} arcmin.,,,,
        arc-second,,,,,arcsec.,,{0} arcsec.,{0} arcsec.,,,,
        milligram-ofglucose-per-deciliter,mg/dL,,{0}mg/dL,{0}mg/dL,mg/dL,,{0} mg/dL,{0} mg/dL,,,,
        millimole-per-liter,mmol/L,,{0}mmol/L,{0}mmol/L,millimole/litre,,{0} mmol/L,{0} mmol/L,,,,
        liter-per-100-kilometer,L/100km,,{0}L/100km,{0}L/100km,L/100 km,,{0} L/100 km,{0} L/100 km,,,,
        liter-per-kilometer,L/km,,{0}L/km,{0}L/km,litres/km,,{0} L/km,{0} L/km,,,,
        mile-per-gallon,,,,,miles/gal. US,,{0} m.p.g. US,{0} m.p.g. US,,,,
        mile-per-gallon-imperial,,,,,miles/gal.,,{0} m.p.g.,{0} m.p.g.,,,,
        century,C,,{0}C,{0}C,C,,{0} C,{0} C,,,,
        kilocalorie,,,,,Cal,,{0} Cal,{0} Cal,,,,
        astronomical-unit,,,,,AU,,{0} AU,{0} AU,,,,
        carat,,,,,carats,,{0} CM,{0} CM,,,,
        inch-ofhg,,,,,in Hg,,{0} inHg,{0} inHg,,,,
        millibar,,,,,mb,,{0} mb,{0} mb,,,,
        millimeter-ofhg,,,,,mm Hg,,{0} mm Hg,{0} mm Hg,,,,
        meter-per-second,,,,,metres/sec.,,{0} m/s.,{0} m/s.,,,,
        celsius,,,,,deg C,,{0}°C,{0}°C,,,,
        fahrenheit,,,,,deg F,,{0}°F,{0}°F,,,,
        bushel,bushel,,{0} bus.,{0} bus.,bushels,,{0} bus.,{0} bus.,,,,
        centiliter,cL,,{0}cL,{0}cL,cL,,{0} cL,{0} cL,,,,
        deciliter,dL,,{0}dL,{0}dL,dL,,{0} dL,{0} dL,,,,
        gallon,gal US,{0}/USgal,{0} gal US,{0} gal US,gal US,{0}/gal US,{0} gal US,{0} gal US,,,,
        gallon-imperial,gal.,{0}/gal.,{0}gal.,{0}gal.,gal.,{0}/gal.,{0} gal.,{0} gal.,,,,
        hectoliter,hL,,{0}hL,{0}hL,hL,,{0} hL,{0} hL,,,,
        liter,litre,{0}/L,{0}L,{0}L,litres,{0}/L,{0} L,{0} L,,,,
        megaliter,ML,,{0}ML,{0}ML,ML,,{0} ML,{0} ML,,,,
        milliliter,mL,,{0}mL,{0}mL,mL,,{0} mL,{0} mL,,,,
        kilometer-per-hour,km/h,,{0} km/h,{0} km/h,,,,,,,,
        dessert-spoon,dsp US,,{0}dsp US,{0}dsp US,,,,,,,,
        dessert-spoon-imperial,dsp Imp,,{0}dsp-Imp,{0}dsp-Imp,,,,,,,,
        quart,qt US,,{0}qt US,{0}qt US,,,,,,,,
        """.trimIndent()
  }

  private val en_AU_Prefixes: String? = null

  private val en_BB_Units: String? = null

  private val en_BB_Prefixes: String? = null

  private val en_BE_Units: String? = null

  private val en_BE_Prefixes: String? = null

  private val en_BI_Units: String? = null

  private val en_BI_Prefixes: String? = null

  private val en_BM_Units: String? = null

  private val en_BM_Prefixes: String? = null

  private val en_BS_Units: String by lazy {
    """fahrenheit,°F,,{0}°,{0}°,,,,,,,,
        """.trimIndent()
  }

  private val en_BS_Prefixes: String? = null

  private val en_BW_Units: String? = null

  private val en_BW_Prefixes: String? = null

  private val en_BZ_Units: String by lazy {
    """fahrenheit,°F,,{0}°,{0}°,,,,,,,,
        """.trimIndent()
  }

  private val en_BZ_Prefixes: String? = null

  private val en_CA_Units: String by lazy {
    """meter-per-square-second,,,,,metres/sec²,,{0} m/s²,{0} m/s²,metres per second squared,,{0} metre per second squared,{0} metres per second squared
        square-centimeter,,,,,,,,,square centimetres,{0} per square centimetre,{0} square centimetre,{0} square centimetres
        square-kilometer,,,,,,,,,square kilometres,{0} per square kilometre,{0} square kilometre,{0} square kilometres
        square-meter,metres²,{0}/m²,{0}m²,{0}m²,metres²,{0}/m²,{0} m²,{0} m²,square metres,{0} per square metre,{0} square metre,{0} square metres
        milligram-ofglucose-per-deciliter,,,,,milligrams/decilitre,,{0} mg/dL,{0} mg/dL,milligrams per decilitre,,{0} milligram per decilitre,{0} milligrams per decilitre
        millimole-per-liter,,,,,millimoles/litre,,{0} mmol/L,{0} mmol/L,millimoles per litre,,{0} millimole per litre,{0} millimoles per litre
        permille,,,,,per mille,,{0}‰,{0}‰,per mille,,{0} per mille,{0} per mille
        permyriad,,,,,per myriad,,{0}‱,{0}‱,per myriad,,{0} per myriad,{0} per myriad
        liter-per-100-kilometer,,,,,litres/100 km,,{0} L/100 km,{0} L/100 km,litres per 100 kilometres,,{0} litre per 100 kilometres,{0} litres per 100 kilometres
        liter-per-kilometer,,,,,litres/km,,{0} L/km,{0} L/km,litres per kilometre,,{0} litre per kilometre,{0} litres per kilometre
        mile-per-gallon,mpg US,,{0}mpgUS,{0}mpgUS,miles/US gal,,{0} mpg US,{0} mpg US,miles per US gallon,,{0} mile per US gallon,{0} miles per US gallon
        mile-per-gallon-imperial,mpg,,{0}mpg,{0}mpg,miles/gal,,{0} mpg,{0} mpg,miles per gallon,,{0} mile per gallon,{0} miles per gallon
        kilowatt-hour,,,,,,,,,kilowatt-hours,,{0} kilowatt-hour,{0} kilowatt-hours
        kilowatt-hour-per-100-kilometer,,,,,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kilowatt-hour per 100 kilometres,,{0} kilowatt-hour per 100 kilometres,{0} kilowatt-hours per 100 kilometres
        dot,,,,,,,,,dots,,{0} dot,{0} dots
        dot-per-centimeter,,,,,,,,,dots per centimetre,,{0} dot per centimetre,{0} dots per centimetre
        pixel-per-centimeter,,,,,,,,,pixels per centimetre,,{0} pixel per centimetre,{0} pixels per centimetre
        centimeter,,,,,,,,,centimetres,{0} per centimetre,{0} centimetre,{0} centimetres
        decimeter,,,,,,,,,decimetre,,{0} decimetre,{0} decimetres
        earth-radius,,,,,,,,,earth radius,,{0} earth radius,{0} earth radii
        kilometer,,,,,,,,,kilometres,{0} per kilometre,{0} kilometre,{0} kilometres
        meter,metre,{0}/m,{0}m,{0}m,metres,{0}/m,{0} m,{0} m,metres,{0} per metre,{0} metre,{0} metres
        micrometer,,,,,μmetres,,{0} μm,{0} μm,micrometre,,{0} micrometre,{0} micrometres
        mile-scandinavian,,,,,,,,,Scandinavian mile,,{0} Scandinavian mile,{0} Scandinavian miles
        millimeter,,,,,,,,,millimetres,,{0} millimetre,{0} millimetres
        nanometer,,,,,,,,,nanometres,,{0} nanometre,{0} nanometres
        picometer,,,,,,,,,picometres,,{0} picometre,{0} picometres
        candela,,,,,,,,,candelas,,{0} candela,{0} candelas
        lumen,,,,,,,,,lumens,,{0} lumen,{0} lumens
        stone,,,,,stone,,{0} st,{0} st,stone,,{0} stone,{0} stone
        tonne,,,,,,,,,tonnes,,{0} tonne,{0} tonnes
        millimeter-ofhg,,,,,mm Hg,,{0} mm Hg,{0} mm Hg,millimetres of mercury,,{0} millimetre of mercury,{0} millimetres of mercury
        kilometer-per-hour,km/h,,{0}km/h,{0}km/h,,,,,kilometres per hour,,{0} kilometre per hour,{0} kilometres per hour
        meter-per-second,,,,,metres/sec,,{0} m/s,{0} m/s,metres per second,,{0} metre per second,{0} metres per second
        generic,deg,,{0}°,{0}°,deg,,{0}°,{0}°,degree,,{0} degree temperature,{0} degrees temperature
        kelvin,,,,,,,,,kelvin,,{0} kelvin,{0} kelvin
        newton-meter,,,,,,,,,newton metres,,{0} newton metre,{0} newton metres
        centiliter,,,,,,,,,centilitres,,{0} centilitre,{0} centilitres
        cubic-centimeter,,,,,cu centimetres,{0}/cu cm,{0}/cu cm,{0}/cu cm,cubic centimetres,{0} per cubic centimetre,{0} cubic centimetre,{0} cubic centimetres
        cubic-kilometer,,,,,cu kilometres,,{0} cu km,{0} cu km,cubic kilometres,,{0} cubic kilometre,{0} cubic kilometres
        cubic-meter,,,,,cu metres,{0}/cu m,{0}/cu m,{0}/cu m,cubic metres,{0} per cubic metre,{0} cubic metre,{0} cubic metres
        deciliter,,,,,,,,,decilitres,,{0} decilitre,{0} decilitres
        dessert-spoon,,,,,,,,,dessert spoons,,{0} US dessertspoon,{0} US dessertspoons
        dessert-spoon-imperial,dsp,,{0}dsp,{0}dsp,dssp,,{0} dssp,{0} dssp,dessertspoon,,{0} dessertspoon,{0} dessertspoons
        dram,fl dr,,{0}fl dr,{0}fl dr,fl drams,,{0} fl dram,{0} fl drams,fluid drams,,{0} fluid dram,{0} fluid drams
        fluid-ounce,US fl oz,,{0}US fl oz,{0}US fl oz,US fl oz,,{0} US fl oz,{0} US fl oz,US fluid ounces,,{0} US fluid ounce,{0} US fluid ounces
        fluid-ounce-imperial,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,fluid ounces,,{0} fluid ounce,{0} fluid ounces
        gallon,US gal,{0}/USgal,{0}USgal,{0}USgal,US gal,{0}/US gal,{0} US gal,{0} US gal,US gallons,{0} per US gallon,{0} US gallon,{0} US gallons
        gallon-imperial,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal,{0} gal,{0} gal,gallons,{0} per gallon,{0} gallon,{0} gallons
        hectoliter,,,,,,,,,hectolitres,,{0} hectolitre,{0} hectolitres
        liter,litre,{0}/L,{0}L,{0}L,litres,{0}/L,{0} L,{0} L,litres,{0} per litre,{0} litre,{0} litres
        megaliter,,,,,,,,,megalitres,,{0} megalitre,{0} megalitres
        milliliter,,,,,,,,,millilitres,,{0} millilitre,{0} millilitres
        quart,US qt,,{0}USqt,{0}USqt,US qts,,{0} US qt,{0} US qt,US quarts,,{0} US quart,{0} US quarts
        quart-imperial,qt,,{0}qt,{0}qt,qt,,{0} qt,{0} qt,quart,,{0} quart,{0} quarts
        revolution,rev,,{0}rev,{0}revs,rev,,{0} rev,{0} revs,,,,
        square-inch,in²,{0}/sq in,{0}in²,{0}in²,sq inches,{0}/sq in,{0} sq in,{0} sq in,,,,
        square-mile,,,,,sq miles,{0}/sq mi,{0} sq mi,{0} sq mi,,,,
        square-yard,,,,,sq yards,,{0} sq yd,{0} sq yd,,,,
        mole,,,,,moles,,{0} mol,{0} mol,,,,
        bit,bit,,{0}bit,{0}bits,bit,,{0} bit,{0} bits,,,,
        byte,,,,,byte,,{0} byte,{0} bytes,,,,
        hour,hour,{0}/hr,{0}h,{0}h,hours,{0}/hr,{0} hr,{0} hrs,,,,
        microsecond,,,,,μsecs,,{0} μsec,{0} μsecs,,,,
        millisecond,,,,,millisecs,,{0} millisec,{0} millisecs,,,,
        minute,min,{0}/min,{0}min,{0}min,mins,{0}/min,{0} min,{0} mins,,,,
        month,month,{0}/mo,{0}m,{0}m,months,{0}/mo,{0} mo,{0} mos,,,,
        nanosecond,,,,,nanosecs,,{0} nanosec,{0} nanosecs,,,,
        second,sec,{0}/sec,{0}s,{0}s,secs,{0}/sec,{0} sec,{0} secs,,,,
        week,wk,{0}/wk,{0}w,{0}w,weeks,{0}/wk,{0} wk,{0} wks,,,,
        year,yr,{0}/yr,{0}y,{0}y,years,{0}/yr,{0} yr,{0} yrs,,,,
        carat,carat,,{0}ct,{0}ct,carats,,{0} ct,{0} ct,,,,
        grain,,,,,grains,,{0} grain,{0} grains,,,,
        bar,,,,,bars,,{0} bar,{0} bar,,,,
        celsius,°C,,{0}°,{0}°,deg C,,{0} °C,{0} °C,,,,
        fahrenheit,°F,,{0}°F,{0}°F,deg F,,{0} °F,{0} °F,,,,
        cubic-foot,,,,,cu feet,,{0} cu ft,{0} cu ft,,,,
        cubic-inch,,,,,cu inches,,{0} cu in,{0} cu in,,,,
        cubic-mile,,,,,cu miles,,{0} cu mi,{0} cu mi,,,,
        cubic-yard,,,,,cu yards,,{0} cu yd,{0} cu yd,,,,
        drop,,,,,drops,,{0} drops,{0} drops,,,,
        jigger,jiggers,,{0}jigger,{0}jiggers,jiggers,,{0} jiggers,{0} jiggers,,,,
        pinch,,,,,pinches,,{0} pinches,{0} pinches,,,,
        ampere,A,,{0}A,{0}A,,,,,,,,
        volt,V,,{0}V,{0}V,,,,,,,,
        lux,lx,,{0}lx,{0}lx,,,,,,,,
        pound,lb,{0}/lb,{0}lb,{0}lb,,,,,,,,
        watt,W,,{0}W,{0}W,,,,,,,,
        mile-per-hour,mph,,{0}mph,{0}mph,,,,,,,,
        cup,cups,,{0}c,{0}c,,,,,,,,
        pint-metric,mpt,,{0}mpt,{0}mpt,,,,,,,,
        """.trimIndent()
  }

  private val en_CA_Prefixes: String by lazy {
    """10p1,,,deca{0}
        """.trimIndent()
  }

  private val en_CC_Units: String? = null

  private val en_CC_Prefixes: String? = null

  private val en_CH_Units: String? = null

  private val en_CH_Prefixes: String? = null

  private val en_CK_Units: String? = null

  private val en_CK_Prefixes: String? = null

  private val en_CM_Units: String? = null

  private val en_CM_Prefixes: String? = null

  private val en_CX_Units: String? = null

  private val en_CX_Prefixes: String? = null

  private val en_CY_Units: String? = null

  private val en_CY_Prefixes: String? = null

  private val en_DE_Units: String? = null

  private val en_DE_Prefixes: String? = null

  private val en_DG_Units: String? = null

  private val en_DG_Prefixes: String? = null

  private val en_DK_Units: String? = null

  private val en_DK_Prefixes: String? = null

  private val en_DM_Units: String? = null

  private val en_DM_Prefixes: String? = null

  private val en_Dsrt_Units: String by lazy {
    """day,,,,,,,,,day,{0}/d,{0} 𐐼𐐩,{0} 𐐼𐐩𐑆
        hour,,,,,,,,,hr,{0}/h,{0} 𐐵𐑉,{0} 𐐵𐑉𐑆
        minute,,,,,,,,,min,{0}/min,{0} 𐑋𐐮𐑌𐐲𐐻,{0} 𐑋𐐮𐑌𐐲𐐻𐑅
        month,,,,,,,,,mon,{0}/m,{0} 𐑋𐐲𐑌𐑃𐑅,{0} 𐑋𐐲𐑌𐑃
        second,,,,,,,,,sec,{0}/s,{0} 𐑅𐐯𐐿𐐲𐑌𐐼,{0} 𐑅𐐯𐐿𐐲𐑌𐐼𐑆
        week,,,,,,,,,wk,{0}/w,{0} 𐐶𐐨𐐿,{0} 𐐶𐐨𐐿𐑅
        year,,,,,,,,,yr,{0}/y,{0} 𐐷𐐮𐑉,{0} 𐐷𐐮𐑉𐑆
        """.trimIndent()
  }

  private val en_Dsrt_Prefixes: String? = null

  private val en_ER_Units: String? = null

  private val en_ER_Prefixes: String? = null

  private val en_FI_Units: String? = null

  private val en_FI_Prefixes: String? = null

  private val en_FJ_Units: String? = null

  private val en_FJ_Prefixes: String? = null

  private val en_FK_Units: String? = null

  private val en_FK_Prefixes: String? = null

  private val en_FM_Units: String? = null

  private val en_FM_Prefixes: String? = null

  private val en_GB_Units: String? = null

  private val en_GB_Prefixes: String? = null

  private val en_GD_Units: String? = null

  private val en_GD_Prefixes: String? = null

  private val en_GG_Units: String? = null

  private val en_GG_Prefixes: String? = null

  private val en_GH_Units: String? = null

  private val en_GH_Prefixes: String? = null

  private val en_GI_Units: String? = null

  private val en_GI_Prefixes: String? = null

  private val en_GM_Units: String? = null

  private val en_GM_Prefixes: String? = null

  private val en_GU_Units: String? = null

  private val en_GU_Prefixes: String? = null

  private val en_GY_Units: String? = null

  private val en_GY_Prefixes: String? = null

  private val en_HK_Units: String? = null

  private val en_HK_Prefixes: String? = null

  private val en_ID_Units: String? = null

  private val en_ID_Prefixes: String? = null

  private val en_IE_Units: String? = null

  private val en_IE_Prefixes: String? = null

  private val en_IL_Units: String? = null

  private val en_IL_Prefixes: String? = null

  private val en_IM_Units: String? = null

  private val en_IM_Prefixes: String? = null

  private val en_IN_Units: String by lazy {
    """earth-radius,,,,,,,,,earth radius,,{0} earth radius,{0} earth radius
        tonne,,,,,,,,,metric tonnes,,{0} tonne,{0} tonnes
        generic,,,,,,,,,°,,{0}°,{0}°
        kilometer-per-hour,km/h,,{0}kph,{0}kph,km/hour,,{0} kph,{0} kph,,,,
        """.trimIndent()
  }

  private val en_IN_Prefixes: String? = null

  private val en_IO_Units: String? = null

  private val en_IO_Prefixes: String? = null

  private val en_JE_Units: String? = null

  private val en_JE_Prefixes: String? = null

  private val en_JM_Units: String? = null

  private val en_JM_Prefixes: String? = null

  private val en_KE_Units: String? = null

  private val en_KE_Prefixes: String? = null

  private val en_KI_Units: String? = null

  private val en_KI_Prefixes: String? = null

  private val en_KN_Units: String? = null

  private val en_KN_Prefixes: String? = null

  private val en_KY_Units: String by lazy {
    """fahrenheit,°F,,{0}°,{0}°,,,,,,,,
        """.trimIndent()
  }

  private val en_KY_Prefixes: String? = null

  private val en_LC_Units: String? = null

  private val en_LC_Prefixes: String? = null

  private val en_LR_Units: String? = null

  private val en_LR_Prefixes: String? = null

  private val en_LS_Units: String? = null

  private val en_LS_Prefixes: String? = null

  private val en_MG_Units: String? = null

  private val en_MG_Prefixes: String? = null

  private val en_MH_Units: String? = null

  private val en_MH_Prefixes: String? = null

  private val en_MO_Units: String? = null

  private val en_MO_Prefixes: String? = null

  private val en_MP_Units: String? = null

  private val en_MP_Prefixes: String? = null

  private val en_MS_Units: String? = null

  private val en_MS_Prefixes: String? = null

  private val en_MT_Units: String? = null

  private val en_MT_Prefixes: String? = null

  private val en_MU_Units: String? = null

  private val en_MU_Prefixes: String? = null

  private val en_MV_Units: String? = null

  private val en_MV_Prefixes: String? = null

  private val en_MW_Units: String? = null

  private val en_MW_Prefixes: String? = null

  private val en_MY_Units: String? = null

  private val en_MY_Prefixes: String? = null

  private val en_NA_Units: String? = null

  private val en_NA_Prefixes: String? = null

  private val en_NF_Units: String? = null

  private val en_NF_Prefixes: String? = null

  private val en_NG_Units: String? = null

  private val en_NG_Prefixes: String? = null

  private val en_NL_Units: String? = null

  private val en_NL_Prefixes: String? = null

  private val en_NR_Units: String? = null

  private val en_NR_Prefixes: String? = null

  private val en_NU_Units: String? = null

  private val en_NU_Prefixes: String? = null

  private val en_NZ_Units: String? = null

  private val en_NZ_Prefixes: String? = null

  private val en_PG_Units: String? = null

  private val en_PG_Prefixes: String? = null

  private val en_PH_Units: String? = null

  private val en_PH_Prefixes: String? = null

  private val en_PK_Units: String? = null

  private val en_PK_Prefixes: String? = null

  private val en_PN_Units: String? = null

  private val en_PN_Prefixes: String? = null

  private val en_PR_Units: String? = null

  private val en_PR_Prefixes: String? = null

  private val en_PW_Units: String by lazy {
    """fahrenheit,°F,,{0}°,{0}°,,,,,,,,
        """.trimIndent()
  }

  private val en_PW_Prefixes: String? = null

  private val en_RW_Units: String? = null

  private val en_RW_Prefixes: String? = null

  private val en_SB_Units: String? = null

  private val en_SB_Prefixes: String? = null

  private val en_SC_Units: String? = null

  private val en_SC_Prefixes: String? = null

  private val en_SD_Units: String? = null

  private val en_SD_Prefixes: String? = null

  private val en_SE_Units: String? = null

  private val en_SE_Prefixes: String? = null

  private val en_SG_Units: String? = null

  private val en_SG_Prefixes: String? = null

  private val en_SH_Units: String? = null

  private val en_SH_Prefixes: String? = null

  private val en_SI_Units: String? = null

  private val en_SI_Prefixes: String? = null

  private val en_SL_Units: String? = null

  private val en_SL_Prefixes: String? = null

  private val en_SS_Units: String? = null

  private val en_SS_Prefixes: String? = null

  private val en_SX_Units: String? = null

  private val en_SX_Prefixes: String? = null

  private val en_SZ_Units: String? = null

  private val en_SZ_Prefixes: String? = null

  private val en_Shaw_Units: String? = null

  private val en_Shaw_Prefixes: String? = null

  private val en_TC_Units: String? = null

  private val en_TC_Prefixes: String? = null

  private val en_TK_Units: String? = null

  private val en_TK_Prefixes: String? = null

  private val en_TO_Units: String? = null

  private val en_TO_Prefixes: String? = null

  private val en_TT_Units: String? = null

  private val en_TT_Prefixes: String? = null

  private val en_TV_Units: String? = null

  private val en_TV_Prefixes: String? = null

  private val en_TZ_Units: String? = null

  private val en_TZ_Prefixes: String? = null

  private val en_UG_Units: String? = null

  private val en_UG_Prefixes: String? = null

  private val en_UM_Units: String? = null

  private val en_UM_Prefixes: String? = null

  private val en_VC_Units: String? = null

  private val en_VC_Prefixes: String? = null

  private val en_VG_Units: String? = null

  private val en_VG_Prefixes: String? = null

  private val en_VI_Units: String? = null

  private val en_VI_Prefixes: String? = null

  private val en_VU_Units: String? = null

  private val en_VU_Prefixes: String? = null

  private val en_WS_Units: String? = null

  private val en_WS_Prefixes: String? = null

  private val en_ZA_Units: String? = null

  private val en_ZA_Prefixes: String? = null

  private val en_ZM_Units: String? = null

  private val en_ZM_Prefixes: String? = null

  private val en_ZW_Units: String? = null

  private val en_ZW_Prefixes: String? = null

  private val eo_Units: String by lazy {
    """month,mon,{0}/m,{0} mon.,{0} mon.,mon,{0}/m,{0} mon.,{0} mon.,mon,{0}/m,{0} mon.,{0} mon.
        """.trimIndent()
  }

  private val eo_Prefixes: String? = null

  private val es_Units: String by lazy {
    """g-force,Fg,,{0}Fg,{0}Fg,Fg,,{0} Fg,{0} Fg,unidades de fuerza g,,{0} unidad de fuerza g,{0} unidades de fuerza g
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,,,,,metros por segundo al cuadrado,,{0} metro por segundo al cuadrado,{0} metros por segundo al cuadrado
        arc-minute,arcmin,,{0}′,{0}′,arcmin,,{0} arcmin,{0} arcmin,minutos de arco,,{0} minuto de arco,{0} minutos de arco
        arc-second,arcsec,,{0}″,{0}″,arcsec,,{0} arcsec,{0} arcsec,segundos de arco,,{0} segundo de arco,{0} segundos de arco
        degree,grad,,,{0}°,grad.,,,{0}°,grados,,{0} grado,{0} grados
        radian,rad,,{0}rad,{0}rad,,,,,radianes,,{0} radián,{0} radianes
        revolution,rev,,{0}rev,{0}rev,,,,,revoluciones,,{0} revolución,{0} revoluciones
        acre,ac,,{0}ac,{0}ac,ac,,,{0} ac,acres,,{0} acre,{0} acres
        dunam,dunam,,{0}dunam,{0}dunam,dunams,,{0} dunam,{0} dunams,dunams,,{0} dunam,{0} dunams
        hectare,ha,,{0}ha,{0}ha,ha,,,{0} ha,hectáreas,,{0} hectárea,{0} hectáreas
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,,,,,centímetros cuadrados,{0} por centímetro cuadrado,{0} centímetro cuadrado,{0} centímetros cuadrados
        square-foot,ft²,,{0}ft²,{0}ft²,,,,,pies cuadrados,,{0} pie cuadrado,{0} pies cuadrados
        square-inch,in²,{0}/in²,{0}in²,{0}in²,,,,,pulgadas cuadradas,{0} por pulgada cuadrada,{0} pulgada cuadrada,{0} pulgadas cuadradas
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,kilómetros cuadrados,{0} por kilómetro cuadrado,{0} kilómetro cuadrado,{0} kilómetros cuadrados
        square-meter,m²,{0}/m²,{0}m²,{0}m²,,,,,metros cuadrados,{0} por metro cuadrado,{0} metro cuadrado,{0} metros cuadrados
        square-mile,mi²,{0}/mi²,{0}mi²,{0}mi²,,,,,millas cuadradas,{0} por milla cuadrada,{0} milla cuadrada,{0} millas cuadradas
        square-yard,yd²,,{0}yd²,{0}yd²,,,,,yardas cuadradas,,{0} yarda cuadrada,{0} yardas cuadradas
        item,ítem,,{0}ít,{0}ít,ítem,,{0} ítem,{0} ítems,ítem,,{0} ítem,{0} ítems
        karat,ct,,{0}ct,{0}ct,ct,,{0} ct,{0} ct,quilates,,{0} quilate,{0} quilates
        milligram-ofglucose-per-deciliter,mg/dL,,{0}mg/dL,{0}mg/dL,,,,,miligramos por decilitro,,{0} miligramo por decilitro,{0} miligramos por decilitro
        millimole-per-liter,mmol/L,,{0}mmol/L,{0}mmol/L,,,,,milimoles por litro,,{0} milimol por litro,{0} milimoles por litro
        mole,mol,,{0}mol,{0}mol,,,,,moles,,{0} mol,{0} moles
        percent,%,,{0}%,{0}%,por ciento,,{0} %,{0} %,por ciento,,{0} por ciento,{0} por ciento
        permille,por mil,,{0}‰,{0}‰,por mil,,{0} ‰,{0} ‰,por mil,,{0} por mil,{0} por mil
        permillion,ppm,,{0}ppm,{0}ppm,,,,,partes por millón,,{0} parte por millón,{0} partes por millón
        permyriad,por diez mil,,{0}‱,{0}‱,por diez mil,,{0} ‱,{0} ‱,por diez mil,,{0} por diez mil,{0} por diez mil
        portion-per-1e9,partes/millardo,,{0}ppb,{0}ppb,partes/millardo,,,{0} ppb,partes por millardo,,{0} parte por millardo,{0} partes por millardo
        liter-per-100-kilometer,l/100km,,{0}l/100km,{0}l/100km,l/100 km,,{0} l/100 km,{0} l/100 km,litros por 100 kilómetros,,{0} litro por 100 kilómetros,{0} litros por 100 kilómetros
        liter-per-kilometer,l/km,,{0}l/km,{0}l/km,l/km,,{0} l/km,{0} l/km,litros por kilómetro,,{0} litro por kilómetro,{0} litros por kilómetro
        mile-per-gallon,mi/gal,,{0}mi/gal,{0}mi/gal,mi/gal,,{0} mi/gal,{0} mi/gal,millas por galón,,{0} milla por galón,{0} millas por galón
        mile-per-gallon-imperial,mi/gal imp,,{0}m/g imp,{0}m/g imp,mi/gal imp.,,{0} mi/gal imp.,{0} mi/gal imp.,millas por galón imperial,,{0} milla por galón imperial,{0} millas por galón imperial
        bit,b,,{0}b,{0}b,b,,{0} b,{0} b,bits,,{0} bit,{0} bits
        byte,B,,{0}B,{0}B,B,,{0} B,{0} B,bytes,,{0} byte,{0} bytes
        gigabit,Gb,,{0}Gb,{0}Gb,,,,,gigabits,,{0} gigabit,{0} gigabits
        gigabyte,GB,,{0}GB,{0}GB,,,,,gigabytes,,{0} gigabyte,{0} gigabytes
        kilobit,kb,,{0}kb,{0}kb,,,,,kilobits,,{0} kilobit,{0} kilobits
        kilobyte,kB,,{0}kB,{0}kB,,,,,kilobytes,,{0} kilobyte,{0} kilobytes
        megabit,Mb,,{0}Mb,{0}Mb,,,,,megabits,,{0} megabit,{0} megabits
        megabyte,MB,,{0}MB,{0}MB,,,,,megabytes,,{0} megabyte,{0} megabytes
        petabyte,PB,,{0}PB,{0}PB,,,,,petabytes,,{0} petabyte,{0} petabytes
        terabit,Tb,,{0}Tb,{0}Tb,,,,,terabits,,{0} terabit,{0} terabits
        terabyte,TB,,{0}TB,{0}TB,,,,,terabytes,,{0} terabyte,{0} terabytes
        century,s,,{0}s,{0}s,s.,,{0} s.,{0} s.,siglos,,{0} siglo,{0} siglos
        day,d,{0}/d,{0}d,{0}d,d,{0}/d,,{0} d,días,{0} por día,{0} día,{0} días
        decade,déc,,{0}déc,{0}déc,déc.,,{0} déc.,{0} déc.,décadas,,{0} década,{0} décadas
        hour,h,{0}/h,{0}h,{0}h,horas,{0}/h,,{0} h,horas,{0} por hora,{0} hora,{0} horas
        microsecond,μs,,{0}μs,{0}μs,,,,,microsegundos,,{0} microsegundo,{0} microsegundos
        millisecond,ms,,{0}ms,{0}ms,,,,,milisegundos,,{0} milisegundo,{0} milisegundos
        minute,min,{0}/min,{0}min,{0}min,,,,,minutos,{0} por minuto,{0} minuto,{0} minutos
        month,m,{0}/m,{0}m,{0}m,m.,{0}/m.,{0} m.,{0} m.,meses,{0} por mes,{0} mes,{0} meses
        nanosecond,ns,,{0}ns,{0}ns,,,,,nanosegundos,,{0} nanosegundo,{0} nanosegundos
        night,noches,{0}/noche,{0}noche,{0}noches,noches,{0}/noche,{0} noche,{0} noches,noches,{0} por noche,{0} noche,{0} noches
        quarter,trim,{0}/trim,{0}trim,{0}trim,trim.,{0}/trim.,{0} trim.,{0} trim.,trimestres,{0} por trimestre,{0} trimestre,{0} trimestres
        second,s,{0}/s,{0}s,{0}s,s,{0}/s,,{0} s,segundos,{0} por segundo,{0} segundo,{0} segundos
        week,sem,{0}/sem,{0}sem,{0}sem,sem.,{0}/sem.,{0} sem.,{0} sem.,semanas,{0} por semana,{0} semana,{0} semanas
        year,a,{0}/a,{0}a,{0}a,a,{0}/a,{0} a,{0} a,años,{0} por año,{0} año,{0} años
        ampere,A,,{0}A,{0}A,A,,,{0} A,amperios,,{0} amperio,{0} amperios
        milliampere,mA,,{0}mA,{0}mA,,,,,miliamperios,,{0} miliamperio,{0} miliamperios
        ohm,Ω,,{0}Ω,{0}Ω,Ω,,,{0} Ω,ohmios,,{0} ohmio,{0} ohmios
        volt,V,,{0}V,{0}V,V,,,{0} V,voltios,,{0} voltio,{0} voltios
        british-thermal-unit,BTU,,{0}BTU,{0}BTU,BTU,,{0} BTU,{0} BTU,unidades térmicas británicas,,{0} unidad térmica británica,{0} unidades térmicas británicas
        calorie,cal,,{0}cal,{0}cal,,,,,calorías,,{0} caloría,{0} calorías
        electronvolt,eV,,{0}eV,{0}eV,,,,,electronvoltios,,{0} electronvoltio,{0} electronvoltios
        foodcalorie,,,,,,,,,kilocalorías,,{0} kilocaloría,{0} kilocalorías
        joule,J,,{0}J,{0}J,J,,,{0} J,julios,,{0} julio,{0} julios
        kilocalorie,kcal,,{0}kcal,{0}kcal,,,,,kilocalorías,,{0} kilocaloría,{0} kilocalorías
        kilojoule,kJ,,{0}kJ,{0}kJ,,,,,kilojulios,,{0} kilojulio,{0} kilojulios
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,,,,,kilovatios hora,,{0} kilovatio hora,{0} kilovatios hora
        therm-us,thm EE. UU.,,{0}thm EEUU,{0}thm EEUU,thm EE. UU.,,{0} thm EE. UU.,{0} thm EE. UU.,termias estadounidenses,,{0} termia estadounidense,{0} termias estadounidenses
        kilowatt-hour-per-100-kilometer,kWh/100 km,,{0}kWh/100km,{0}kWh/100km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kilovatios hora por 100 kilómetros,,{0} kilovatio hora por 100 kilómetros,{0} kilovatios hora por 100 kilómetros
        newton,N,,{0}N,{0}N,,,,,newtons,,{0} newton,{0} newtons
        pound-force,lbf,,{0}lbf,{0}lbf,,,,,libras de fuerza,,{0} libra de fuerza,{0} libras de fuerza
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,gigahercios,,{0} gigahercio,{0} gigahercios
        hertz,Hz,,{0}Hz,{0}Hz,,,,,hercios,,{0} hercio,{0} hercios
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,kilohercios,,{0} kilohercio,{0} kilohercios
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,megahercios,,{0} megahercio,{0} megahercios
        dot,pt,,{0}pt,{0}pt,pt,,{0} pt,{0} pt,puntos tipográficos,,{0} punto tipográfico,{0} puntos tipográficos
        dot-per-centimeter,ppcm,,{0}ppcm,{0}ppcm,ppcm,,{0} ppcm,{0} ppcm,puntos por centímetro,,{0} punto por centímetro,{0} puntos por centímetro
        dot-per-inch,ppp,,{0}ppp,{0}ppp,ppp,,{0} ppp,{0} ppp,puntos por pulgada,,{0} punto por pulgada,{0} puntos por pulgada
        em,em,,{0}em,{0}em,,,,,espacios eme,,{0} espacio eme,{0} espacios eme
        megapixel,Mpx,,{0}Mpx,{0}Mpx,Mpx,,{0} Mpx,{0} Mpx,megapíxeles,,{0} megapíxel,{0} megapíxeles
        pixel,px,,{0}px,{0}px,,,,,píxeles,,{0} píxel,{0} píxeles
        pixel-per-centimeter,px/cm,,{0}px/cm,{0}px/cm,px/cm,,{0} px/cm,{0} px/cm,píxeles por centímetro,,{0} píxel por centímetro,{0} píxeles por centímetro
        pixel-per-inch,px/in,,{0}px/in,{0}px/in,px/in,,{0} px/in,{0} px/in,píxeles por pulgada,,{0} píxel por pulgada,{0} píxeles por pulgada
        astronomical-unit,au,,{0}au,{0}au,,,,,unidades astronómicas,,{0} unidad astronómica,{0} unidades astronómicas
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,centímetros,{0} por centímetro,{0} centímetro,{0} centímetros
        decimeter,dm,,{0}dm,{0}dm,,,,,decímetros,,{0} decímetro,{0} decímetros
        earth-radius,R⊕,,{0}R⊕,{0}R⊕,,,,,radios terrestres,,{0} radio terrestre,{0} radios terrestres
        fathom,ftm,,{0}ftm,{0}ftm,ftm,,{0} ftm,{0} ftm,brazas,,{0} braza,{0} brazas
        foot,ft,{0}/ft,{0}ft,{0}ft,,,,,pies,{0} por pie,{0} pie,{0} pies
        furlong,fur,,{0}fur,{0}fur,,,,,furlongs,,{0} furlong,{0} furlongs
        inch,in,{0}/in,{0}in,{0}in,,,,,pulgadas,{0} por pulgada,{0} pulgada,{0} pulgadas
        kilometer,km,{0}/km,{0}km,{0}km,,,,,kilómetros,{0} por kilómetro,{0} kilómetro,{0} kilómetros
        light-year,al,,{0}al,{0}al,a. l.,,{0} a. l.,{0} a. l.,años luz,,{0} año luz,{0} años luz
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,,{0} m,metros,{0} por metro,{0} metro,{0} metros
        micrometer,μm,,{0}μm,{0}μm,,,,,micrómetros,,{0} micrómetro,{0} micrómetros
        mile,mi,,{0}mi,{0}mi,,,,,millas,,{0} milla,{0} millas
        mile-scandinavian,mi esc,,{0}mi esc,{0}mi esc,mi esc.,,{0} mi esc.,{0} mi esc.,millas escandinavas,,{0} milla escandinava,{0} millas escandinavas
        millimeter,mm,,{0}mm,{0}mm,,,,,milímetros,,{0} milímetro,{0} milímetros
        nanometer,nm,,{0}nm,{0}nm,,,,,nanómetros,,{0} nanómetro,{0} nanómetros
        nautical-mile,M,,{0}M,{0}M,M,,{0} M,{0} M,millas náuticas,,{0} milla náutica,{0} millas náuticas
        parsec,pc,,{0}pc,{0}pc,,,,,parsecs,,{0} parsec,{0} parsecs
        picometer,pm,,{0}pm,{0}pm,,,,,picómetros,,{0} picómetro,{0} picómetros
        point,ptos,,{0}pto,{0}pto,ptos.,,{0} pto.,{0} ptos.,puntos,,{0} punto,{0} puntos
        solar-radius,R☉,,{0}R☉,{0}R☉,,,,,radios solares,,{0} radio solar,{0} radios solares
        yard,yd,,{0}yd,{0}yd,,,,,yardas,,{0} yarda,{0} yardas
        candela,cd,,{0}cd,{0}cd,,,,,candelas,,{0} candela,{0} candelas
        lumen,lm,,{0}lm,{0}lm,,,,,lúmenes,,{0} lumen,{0} lúmenes
        lux,lx,,{0}lx,{0}lx,,,,,luxes,,{0} lux,{0} luxes
        solar-luminosity,L☉,,{0}L☉,{0}L☉,,,,,luminosidades solares,,{0} luminosidad solar,{0} luminosidades solares
        carat,ct,,{0}ct,{0}ct,ct,,{0} ct,{0} ct,quilates,,{0} quilate,{0} quilates
        dalton,Da,,{0}Da,{0}Da,,,,,daltones,,{0} dalton,{0} daltones
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,,,,,masas terrestres,,{0} masa terrestre,{0} masas terrestres
        grain,gr,,{0}gr,{0}gr,gr,,{0} gr,{0} gr,granos,,{0} grano,{0} granos
        gram,g,{0}/g,{0}g,{0}g,g,{0}/g,,{0} g,gramos,{0} por gramo,{0} gramo,{0} gramos
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,kilogramos,{0} por kilogramo,{0} kilogramo,{0} kilogramos
        microgram,μg,,{0}μg,{0}μg,,,,,microgramos,,{0} microgramo,{0} microgramos
        milligram,mg,,{0}mg,{0}mg,,,,,miligramos,,{0} miligramo,{0} miligramos
        ounce,oz,{0}/oz,{0}oz,{0}oz,,,,,onzas,{0} por onza,{0} onza,{0} onzas
        ounce-troy,oz t,,{0}oz t,{0}oz t,,,,,onzas troy,,{0} onza troy,{0} onzas troy
        pound,lb,{0}/lb,{0}lb,{0}lb,,,,,libras,{0} por libra,{0} libra,{0} libras
        solar-mass,M☉,,{0}M☉,{0}M☉,,,,,masas solares,,{0} masa solar,{0} masas solares
        stone,st,,{0}st,{0}st,,,,,stones,,{0} stone,{0} stones
        ton,tc,,{0}tc,{0}tc,tc,,{0} tc,{0} tc,toneladas cortas,,{0} tonelada corta,{0} toneladas cortas
        tonne,t,,{0}t,{0}t,,,,,toneladas,,{0} tonelada,{0} toneladas
        gigawatt,GW,,{0}GW,{0}GW,,,,,gigavatios,,{0} gigavatio,{0} gigavatios
        horsepower,CV,,{0}CV,{0}CV,CV,,{0} CV,{0} CV,caballos de vapor,,{0} caballo de vapor,{0} caballos de vapor
        kilowatt,kW,,{0}kW,{0}kW,,,,,kilovatios,,{0} kilovatio,{0} kilovatios
        megawatt,MW,,{0}MW,{0}MW,,,,,megavatios,,{0} megavatio,{0} megavatios
        milliwatt,mW,,{0}mW,{0}mW,,,,,milivatios,,{0} milivatio,{0} milivatios
        watt,W,,{0}W,{0}W,W,,,{0} W,vatios,,{0} vatio,{0} vatios
        atmosphere,atm,,{0}atm,{0}atm,,,,,atmósferas,,{0} atmósfera,{0} atmósferas
        bar,bar,,{0}bar,{0}bar,,,,,bares,,{0} bar,{0} bares
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,hectopascales,,{0} hectopascal,{0} hectopascales
        inch-ofhg,inHg,,{0}inHg,{0}inHg,,,,,pulgadas de mercurio,,{0} pulgada de mercurio,{0} pulgadas de mercurio
        kilopascal,kPa,,{0}kPa,{0}kPa,,,,,kilopascales,,{0} kilopascal,{0} kilopascales
        megapascal,MPa,,{0}MPa,{0}MPa,,,,,megapascales,,{0} megapascal,{0} megapascales
        millibar,mbar,,{0}mbar,{0}mbar,,,,,milibares,,{0} milibar,{0} milibares
        millimeter-ofhg,mmHg,,{0}mmHg,{0}mmHg,mmHg,,{0} mmHg,{0} mmHg,milímetros de mercurio,,{0} milímetro de mercurio,{0} milímetros de mercurio
        pascal,Pa,,{0}Pa,{0}Pa,,,,,pascales,,{0} pascal,{0} pascales
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,,,,,libras por pulgada cuadrada,,{0} libra por pulgada cuadrada,{0} libras por pulgada cuadrada
        beaufort,Bft,,B{0},B{0},,,,,Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,km/h,,{0}km/h,{0}km/h,,,,,kilómetros por hora,,{0} kilómetro por hora,{0} kilómetros por hora
        knot,kn,,{0}kn,{0}kn,,,,,nudos,,{0} nudo,{0} nudos
        light-speed,luz,,{0}luz,{0}luz,luz,,{0} luz,{0} luz,luz,,{0} luz,{0} luz
        meter-per-second,m/s,,{0}m/s,{0}m/s,,,,,metros por segundo,,{0} metro por segundo,{0} metros por segundo
        mile-per-hour,mi/h,,{0}mi/h,{0}mi/h,,,,,millas por hora,,{0} milla por hora,{0} millas por hora
        celsius,°C,,{0}°C,{0}°C,°C,,{0} °C,{0} °C,grados Celsius,,{0} grado Celsius,{0} grados Celsius
        fahrenheit,°F,,{0}°F,{0}°F,°F,,{0} °F,{0} °F,grados Fahrenheit,,{0} grado Fahrenheit,{0} grados Fahrenheit
        generic,,,,,,,,,grados,,{0} grado,{0} grados
        kelvin,K,,{0}K,{0}K,,,,,kelvin,,{0} kelvin,{0} kelvin
        newton-meter,Nm,,{0}Nm,{0}Nm,Nm,,{0} Nm,{0} Nm,newton metros,,{0} newton metro,{0} newton metros
        pound-force-foot,lbf ft,,{0}lbf ft,{0}lbf ft,lbf ft,,{0} lbf ft,{0} lbf ft,libras pies,,{0} libra pie,{0} libras pies
        acre-foot,ac ft,,{0}ac ft,{0}ac ft,,,,,acres-pies,,{0} acre-pie,{0} acres-pies
        barrel,,,,,,,,,barriles,,{0} barril,{0} barriles
        bushel,bu,,{0}bu,{0}bu,,,,,bushels,,{0} bushel,{0} bushels
        centiliter,cl,,{0}cl,{0}cl,cl,,{0} cl,{0} cl,centilitros,,{0} centilitro,{0} centilitros
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,centímetros cúbicos,{0} por centímetro cúbico,{0} centímetro cúbico,{0} centímetros cúbicos
        cubic-foot,ft³,,{0}ft³,{0}ft³,,,,,pies cúbicos,,{0} pie cúbico,{0} pies cúbicos
        cubic-inch,in³,,{0}in³,{0}in³,,,,,pulgadas cúbicas,,{0} pulgada cúbica,{0} pulgadas cúbicas
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,kilómetros cúbicos,,{0} kilómetro cúbico,{0} kilómetros cúbicos
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,metros cúbicos,{0} por metro cúbico,{0} metro cúbico,{0} metros cúbicos
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,millas cúbicas,,{0} milla cúbica,{0} millas cúbicas
        cubic-yard,yd³,,{0}yd³,{0}yd³,,,,,yardas cúbicas,,{0} yarda cúbica,{0} yardas cúbicas
        cup,tza,,{0}tza,{0}tza,tza,,{0} tza,{0} tza,tazas,,{0} taza,{0} tazas
        cup-metric,tza m,,{0}tza m,{0}tza m,tza m,,{0} tza m,{0} tza m,tazas métricas,,{0} taza métrica,{0} tazas métricas
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,decilitros,,{0} decilitro,{0} decilitros
        dessert-spoon,c/p,,{0}c/p,{0}c/p,c/p,,{0} c/p,{0} c/p,cucharadas de postre,,{0} cucharada de postre,{0} cucharadas de postre
        dessert-spoon-imperial,dsp imp,,{0}dsp imp,{0}dsp imp,dstspn imp.,,{0} dstspn imp.,{0} dstspn imp.,cucharadas de postre imperiales,,{0} cucharada de postre imperial,{0} cucharadas de postre imperiales
        dram,fl dr,,{0}fl dr,{0}fl dr,fl dr,,{0} fl dr,{0} fl dr,dracmas líquidas,,{0} dracma líquida,{0} dracmas líquidas
        drop,gt,,{0}gt,{0}gt,gota,,{0} gota,{0} gotas,gotas,,{0} gota,{0} gotas
        fluid-ounce,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,onzas líquidas,,{0} onza líquida,{0} onzas líquidas
        fluid-ounce-imperial,fl oz imp,,{0}fl oz im,{0}fl oz im,fl oz imp.,,{0} fl oz imp.,{0} fl oz imp.,onzas líquidas imperiales,,{0} onza líquida imperial,{0} onzas líquidas imperiales
        gallon,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal,{0} gal,{0} gal,galones,{0} por galón,{0} galón,{0} galones
        gallon-imperial,gal imp,{0}/gal imp,{0}gal imp,{0}gal imp,gal imp.,{0}/gal imp.,{0} gal imp.,{0} gal imp.,galones imperiales,{0} por galón imperial,{0} galón imperial,{0} galones imperiales
        hectoliter,hl,,{0}hl,{0}hl,hl,,{0} hl,{0} hl,hectolitros,,{0} hectolitro,{0} hectolitros
        jigger,med,,{0}med,{0}med,medidor,,{0} medidor,{0} medidores,vasos medidores,,{0} vaso medidor,{0} vasos medidores
        liter,l,{0}/l,{0}l,{0}l,l,{0}/l,,{0} l,litros,{0} por litro,{0} litro,{0} litros
        megaliter,Ml,,{0}Ml,{0}Ml,Ml,,{0} Ml,{0} Ml,megalitros,,{0} megalitro,{0} megalitros
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,mililitros,,{0} mililitro,{0} mililitros
        pinch,pzc,,{0}pzc,{0}pzc,pzc,,{0} pzc,{0} pzc,pizcas,,{0} pizca,{0} pizcas
        pint,p,,{0}p,{0}p,p,,{0} p,{0} p,pintas,,{0} pinta,{0} pintas
        pint-metric,mpt,,{0}mpt,{0}mpt,,,,,pintas métricas,,{0} pinta métrica,{0} pintas métricas
        quart,qt,,{0}qt,{0}qt,,,,,cuartos,,{0} cuarto,{0} cuartos
        quart-imperial,qt imp,,{0}qt imp,{0}qt imp,qt imp.,,{0} qt imp.,{0} qt imp.,cuartos imperiales,,{0} cuarto imperial,{0} cuartos imperiales
        tablespoon,cda,,{0}cda,{0}cda,cda,,{0} cda,{0} cda,cucharadas,,{0} cucharada,{0} cucharadas
        teaspoon,cdta,,{0}cdta,{0}cdta,cdta,,{0} cdta,{0} cdta,cucharaditas,,{0} cucharadita,{0} cucharaditas
        """.trimIndent()
  }

  private val es_Prefixes: String by lazy {
    """square,,,{0} cuadrados
        cubic,,,{0} cúbicos
        times,,,{0}-{1}
        per,,,{0} por {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobe{0}
        10p-1,,,deci{0}
        10p-12,,,pico{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,mili{0}
        10p-30,,,quecto{0}
        10p-6,,,micro{0}
        10p-9,,,nano{0}
        10p1,,,deca{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hecto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val es_419_Units: String by lazy {
    """g-force,G,,{0}Fg,{0}Fg,G,,{0} G,{0} G,fuerza G,,{0} unidad de fuerza gravitacional,{0} unidades de fuerza gravitacional
        portion-per-1e9,,,,,,,,,partes por mil millones,,{0} parte por mil millones,{0} partes por mil millones
        ampere,,,,,,,,,amperes,,{0} ampere,{0} amperes
        milliampere,,,,,,,,,miliamperes,,{0} miliampere,{0} miliamperes
        ohm,,,,,,,,,ohms,,{0} ohm,{0} ohms
        joule,,,,,,,,,joules,,{0} joule,{0} joules
        kilojoule,,,,,,,,,kilojoules,,{0} kilojule,{0} kilojules
        em,,,,,,,,,em tipográfico,,{0} espacio eme,{0} espacios eme
        mile-scandinavian,mi esc,,{0}mi esc.,{0}mi esc.,,,,,milla escandinava,,{0} milla escandinava,{0} millas escandinavas
        ton,ton,,{0}ton,{0}ton,ton,,{0} ton,{0} ton,toneladas,,{0} tonelada,{0} toneladas
        tonne,,,,,,,,,toneladas métricas,,{0} tonelada métrica,{0} toneladas métricas
        horsepower,hp,,{0}hp,{0}hp,hp,,{0} hp,{0} hp,caballos de fuerza,,caballo de fuerza,{0} caballos de fuerza
        generic,,,,,,,,,grados,,{0}°,{0}°
        kelvin,,,,,,,,,kelvins,,{0} kelvin,{0} kelvins
        acre-foot,ac ft,,{0} ac ft,{0}ac ft,,,,,acre-pies,,{0} acre pie,{0} acres pies
        fluid-ounce,,,,,,,,,onzas fluidas,,{0} onza fluida,{0} onzas fluidas
        degree,,,,,grados,,,{0}°,,,,
        mile-per-gallon-imperial,,,,,mi/gal imp.,,{0} mpg imp.,{0} mpg imp.,,,,
        byte,,,,,B,,{0} byte,{0} byte,,,,
        day,d.,{0}/d.,{0}d.,{0}dd.,dd.,{0}/d.,{0} d.,{0} dd.,,,,
        month,m.,{0}/m.,{0}m.,{0}mm.,mm.,{0}/m.,{0} m.,{0} mm.,,,,
        week,sem.,{0}/sem.,{0}sem.,{0}sems.,sems.,{0}/sem.,{0} sem.,{0} sems.,,,,
        year,a.,{0}/a.,{0}a.,{0}aa.,aa.,{0}/a.,{0} a.,{0} aa.,,,,
        dot,p,,{0}p,{0}p,p,,{0} p,{0} p,,,,
        astronomical-unit,ua,,{0}ua,{0}ua,ua,,{0} ua,{0} ua,,,,
        light-year,aa. l.,,{0}a. l.,{0}aa. l.,aa. l.,,{0} a. l.,{0} aa. l.,,,,
        nautical-mile,nmi,,{0}nmi,{0}nmi,nmi,,{0} nmi,{0} nmi,,,,
        parsec,parsec,,{0}pc,{0}pc,parsecs,,,{0} pc,,,,
        point,,,,,pto.,,{0} pto.,{0} ptos.,,,,
        yard,yardas,,{0}yd,{0}yd,yardas,,,{0} yd,,,,
        ounce-troy,ozt,,{0}ozt,{0}ozt,ozt,,{0} ozt,{0} ozt,,,,
        stone,stones,,{0}st,{0}st,stones,,,{0} st,,,,
        cup,,,,,tza,,{0} tza.,{0} tza.,,,,
        pint,pt,,{0}pt,{0}pt,pintas,,{0} pt,{0} pt,,,,
        tablespoon,cdas.,,{0}cda,{0}cda,cdas.,,{0} cda.,{0} cdas.,,,,
        teaspoon,cdtas.,,{0}cdta,{0}cdta,cdtas.,,{0} cdta.,{0} cdtas.,,,,
        square-meter,metros²,{0}/m²,{0}m²,{0}m²,,,,,,,,
        permille,‰,,{0}‰,{0}‰,,,,,,,,
        permyriad,‱,,{0}‱,{0}‱,,,,,,,,
        night,noches,{0}/noche,{0} noche,{0} noches,,,,,,,,
        therm-us,thm EE. UU.,,{0}thm EE.UU.,{0}thm EE.UU.,,,,,,,,
        kilowatt-hour-per-100-kilometer,kWh/100 km,,{0} kWh/100km,{0} kWh/100km,,,,,,,,
        beaufort,Bft,,B {0},B {0},,,,,,,,
        light-speed,luz,,{0} luz,{0} luz,,,,,,,,
        barrel,bbl,,{0}bbl,{0}bbl,,,,,,,,
        milliliter,ml,,{0}ml,{0}ml,,,,,,,,
        """.trimIndent()
  }

  private val es_419_Prefixes: String? = null

  private val es_AR_Units: String by lazy {
    """hour,,,,,hs.,{0}/h,,{0} h,hs.,{0} por hora,{0} hora,{0} horas
        year,a.,{0}/a,{0}a.,{0}a.,años,{0}/a,{0} año,{0} años,años,{0}/año,{0} año,{0} años
        ampere,,,,,,,,,amperios,,{0} amperio,{0} amperios
        milliampere,,,,,,,,,miliamperios,,{0} miliamperio,{0} miliamperios
        ohm,,,,,,,,,ohms,,{0} ohmio,{0} ohmios
        joule,,,,,,,,,julios,,{0} julio,{0} julios
        kilojoule,,,,,,,,,kilojulios,,{0} kilojulio,{0} kilojulios
        century,,,,,s,,{0} s,{0} s,,,,
        second,seg.,{0}/seg.,{0}seg.,{0}seg.,seg.,{0}/seg.,{0} seg.,{0} seg.,,,,
        volt,voltios,,{0}V,{0}V,voltios,,,{0} V,,,,
        watt,vatios,,{0}W,{0}W,vatios,,,{0} W,,,,
        """.trimIndent()
  }

  private val es_AR_Prefixes: String? = null

  private val es_BO_Units: String? = null

  private val es_BO_Prefixes: String? = null

  private val es_BR_Units: String? = null

  private val es_BR_Prefixes: String? = null

  private val es_BZ_Units: String? = null

  private val es_BZ_Prefixes: String? = null

  private val es_CL_Units: String by lazy {
    """ampere,,,,,,,,,amperios,,{0} amperio,{0} amperios
        milliampere,,,,,,,,,miliamperios,,{0} miliamperio,{0} miliamperios
        ohm,,,,,,,,,ohms,,{0} ohmio,{0} ohmios
        volt,voltios,,{0}V,{0}V,voltios,,,{0} V,,,,
        watt,vatios,,{0}W,{0}W,vatios,,,{0} W,,,,
        """.trimIndent()
  }

  private val es_CL_Prefixes: String? = null

  private val es_CO_Units: String by lazy {
    """month,mes,{0}/m.,{0} mes,{0} meses,mes,{0}/mes,{0} mes,{0} meses,meses,{0}/mes,{0} mes,{0} meses
        week,sem.,{0}/sem.,{0} sem.,{0} sems.,,,,,semanas,{0}/sem.,{0} semana,{0} semanas
        day,día,{0}/día,{0} día,{0} días,días,{0}/día,{0} día,{0} días,,,,
        year,a.,{0}/año,{0} a.,{0} a.,a.,{0}/año,{0} a.,{0} a.,,,,
        hour,h,{0}/h,{0} h,{0} h,,,,,,,,
        millisecond,ms,,{0} ms,{0} ms,,,,,,,,
        minute,min,{0}/min,{0} min,{0} min,,,,,,,,
        second,s,{0}/s,{0} s,{0} s,,,,,,,,
        """.trimIndent()
  }

  private val es_CO_Prefixes: String? = null

  private val es_CR_Units: String? = null

  private val es_CR_Prefixes: String? = null

  private val es_CU_Units: String? = null

  private val es_CU_Prefixes: String? = null

  private val es_DO_Units: String by lazy {
    """ampere,,,,,,,,,amperios,,{0} amperio,{0} amperios
        milliampere,,,,,,,,,miliamperios,,{0} miliamperio,{0} miliamperios
        ohm,,,,,,,,,ohms,,{0} ohmio,{0} ohmios
        day,d.,{0}/d.,{0}d.,{0}d.,d.,{0}/d.,{0} d.,{0} dd.,,,,
        second,seg.,{0}/s,{0}s,{0}s,seg.,{0}/s,{0} seg.,{0} seg.,,,,
        volt,voltios,,{0}V,{0}V,voltios,,,{0} V,,,,
        watt,vatios,,{0}W,{0}W,vatios,,,{0} W,,,,
        month,m.,{0}/m.,{0}m.,{0}m.,,,,,,,,
        """.trimIndent()
  }

  private val es_DO_Prefixes: String? = null

  private val es_EA_Units: String? = null

  private val es_EA_Prefixes: String? = null

  private val es_EC_Units: String? = null

  private val es_EC_Prefixes: String? = null

  private val es_GQ_Units: String? = null

  private val es_GQ_Prefixes: String? = null

  private val es_GT_Units: String by lazy {
    """day,,,,,,,,,días,{0} al día,{0} día,{0} días
        month,,,,,,,,,meses,{0} al mes,{0} mes,{0} meses
        year,,,,,,,,,años,{0} al año,{0} año,{0} años
        ampere,,,,,,,,,amperios,,{0} amperio,{0} amperios
        milliampere,,,,,,,,,miliamperios,,{0} miliamperio,{0} miliamperios
        ohm,,,,,,,,,ohms,,{0} ohmio,{0} ohmios
        joule,,,,,,,,,julios,,{0} julio,{0} julios
        kilojoule,,,,,,,,,kilojulios,,{0} kilojulio,{0} kilojulios
        horsepower,,,,,,,,,caballos de fuerza,,{0} caballos de fuerza,{0} caballos de fuerza
        cubic-centimeter,,,,,,,,,centímetros cúbicos,{0} por pie cúbico,{0} centímetro cúbico,{0} centímetros cúbicos
        volt,voltios,,{0}V,{0}V,voltios,,,{0} V,,,,
        foot,pie,{0}/ft,{0}ft,{0}ft,pie,{0}/ft,,{0} ft,,,,
        watt,vatios,,{0}W,{0}W,vatios,,,{0} W,,,,
        acre-foot,acre pie,,{0} ac ft,{0}ac ft,acre pie,,,{0} ac ft,,,,
        hour,hora,{0}/h,{0}h,{0}h,,,,,,,,
        """.trimIndent()
  }

  private val es_GT_Prefixes: String? = null

  private val es_HN_Units: String? = null

  private val es_HN_Prefixes: String? = null

  private val es_IC_Units: String? = null

  private val es_IC_Prefixes: String? = null

  private val es_MX_Units: String by lazy {
    """ohm,,,,,,,,,ohmios,,{0} ohmio,{0} ohmios
        kilowatt-hour,,,,,,,,,kilowatts-hora,,kilowatt-hora,{0} kilowatts-hora
        mile-scandinavian,,,,,,,,,millas escandinavas,,{0} milla escandinava,{0} millas escandinavas
        nautical-mile,M,,{0}nmi,{0}nmi,M,,{0} M,{0} M,millas naúticas,,{0} milla naútica,{0} millas naúticas
        parsec,,,,,pc,,,{0} pc,pársecs,,{0} pársec,{0} pársecs
        lux,,,,,,,,,lux,,{0} lux,{0} luxes
        horsepower,CV,,{0}hp,{0}hp,CV,,{0} CV,{0} CV,caballos de fuerza,,{0} caballo de fuerza,{0} caballos de fuerza
        beaufort,,,,,,,,,Bft,,B {0},B {0}
        kelvin,,,,,,,,,kelvines,,kelvin,{0} kelvines
        acre-foot,,,,,,,,,acre-pies,,{0} acre-pie,{0} acre-pies
        fluid-ounce,,,,,,,,,onzas líquidas,,{0} onza líquida,{0} onzas líquidas
        g-force,fuerza G,,{0}Fg,{0}Fg,fuerza G,,{0} G,{0} G,,,,
        degree,grad,,{0} grados,{0} grados,º,,{0} grados,{0} grados,,,,
        karat,kt,,{0}kt,{0}ct,kt,,{0} kt,{0} kt,,,,
        percent,,,,,%,,{0} %,{0} %,,,,
        permille,,,,,‰,,{0} ‰,{0} ‰,,,,
        mile-per-gallon-imperial,,,,,mi/gal imp.,,{0} mi/gal imp.,{0} mi/gal imp.,,,,
        byte,,,,,B,,{0} B,{0} byte,,,,
        day,días,{0}/d,{0}d,{0}d,días,{0}/d,{0} día,{0} días,,,,
        month,m,{0}/m.,{0}m,{0}m,meses,{0}/m.,{0} m.,{0} m,,,,
        week,sem,{0}/sem.,{0}sem,{0}sem,sem,{0}/sem.,{0} sem.,{0} sem,,,,
        year,a,{0}/a,{0}a,{0}a,a,{0}/a,{0} a,{0} a,,,,
        astronomical-unit,au,,{0}ua,{0}ua,au,,{0} au,{0} au,,,,
        light-year,,,,,a. l.,,{0} a. l.,{0} a. l.,,,,
        mile,millas,,{0}mi,{0}mi,millas,,,{0} mi,,,,
        point,,,,,pt,,{0} pt,{0} pt,,,,
        yard,yd,,{0}yd,{0}yd,yd,,,{0} yd,,,,
        carat,c,,{0}ct,{0}ct,c,,{0} c,{0} c,,,,
        kilometer-per-hour,km/hora,,{0}km/h,{0}km/h,km/hora,,,{0} km/h,,,,
        newton-meter,N⋅m,,{0}Nm,{0}Nm,N⋅m,,{0} N⋅m,{0} N⋅m,,,,
        cup,tza.,,{0}tza,{0}tza,tza.,,{0} tzas.,{0} tzas.,,,,
        pint,,,,,pt,,{0} pt,{0} pt,,,,
        gigabyte,GB,,{0} GB,{0}GB,,,,,,,,
        kilobit,kb,,{0} kb,{0}kb,,,,,,,,
        terabit,Tb,,{0} Tb,{0}Tb,,,,,,,,
        terabyte,TB,,{0} TB,{0}TB,,,,,,,,
        volt,V,,{0} V,{0}V,,,,,,,,
        gigahertz,GHz,,{0} GHz,{0}GHz,,,,,,,,
        hertz,Hz,,{0} Hz,{0}Hz,,,,,,,,
        kilohertz,kHz,,{0} kHz,{0}kHz,,,,,,,,
        megahertz,MHz,,{0} MHz,{0}MHz,,,,,,,,
        centimeter,cm,{0}/cm,{0} cm,{0}cm,,,,,,,,
        kilometer,km,{0}/km,{0} km,{0}km,,,,,,,,
        millimeter,mm,,{0} mm,{0}mm,,,,,,,,
        kilogram,kg,{0}/kg,{0} kg,{0}kg,,,,,,,,
        atmosphere,atm,,{0} atm,{0}atm,,,,,,,,
        """.trimIndent()
  }

  private val es_MX_Prefixes: String? = null

  private val es_NI_Units: String? = null

  private val es_NI_Prefixes: String? = null

  private val es_PA_Units: String? = null

  private val es_PA_Prefixes: String? = null

  private val es_PE_Units: String? = null

  private val es_PE_Prefixes: String? = null

  private val es_PH_Units: String? = null

  private val es_PH_Prefixes: String? = null

  private val es_PR_Units: String by lazy {
    """fahrenheit,°F,,{0}°,{0}°,,,,,,,,
        """.trimIndent()
  }

  private val es_PR_Prefixes: String? = null

  private val es_PY_Units: String by lazy {
    """year,año,{0}/año,{0}a.,{0}aa.,años,{0}/año,{0} año,{0} años,años,{0}/año,{0} año,{0} años
        ampere,,,,,,,,,amperios,,{0} amperio,{0} amperios
        milliampere,,,,,,,,,miliamperios,,{0} miliamperio,{0} miliamperios
        ohm,,,,,,,,,ohms,,{0} ohmio,{0} ohmios
        day,día,{0}/día,{0}d.,{0}dd.,días,{0}/día,{0} día,{0} días,,,,
        month,mes,{0}/m.,{0}m.,{0}mm.,meses,{0}/mes,{0} mes,{0} meses,,,,
        second,seg.,{0}/seg.,{0}s,{0}s,seg.,{0}/seg.,{0} seg.,{0} seg.,,,,
        volt,voltios,,{0}V,{0}V,voltios,,,{0} V,,,,
        watt,vatios,,{0}W,{0}W,vatios,,,{0} W,,,,
        """.trimIndent()
  }

  private val es_PY_Prefixes: String? = null

  private val es_SV_Units: String? = null

  private val es_SV_Prefixes: String? = null

  private val es_US_Units: String by lazy {
    """ampere,,,,,,,,,amperios,,{0} amperio,{0} amperios
        milliampere,,,,,,,,,miliamperio,,{0} miliamperio,{0} miliamperios
        ohm,,,,,,,,,ohmios,,{0} ohmio,{0} ohmios
        joule,,,,,,,,,julios,,{0} julio,{0} julios
        kilojoule,,,,,,,,,kilojulios,,{0} kilojulio,{0} kilojulio
        kilowatt-hour,,,,,,,,,kilovatios por hora,,{0} kilovatio por hora,{0} kilovatios por hora
        em,,,,,,,,,em tipográfica,,{0} em,{0} em
        megapixel,,,,,,,,,megapixeles,,{0} megapixel,{0} megapixeles
        pixel-per-centimeter,,,,,,,,,pixeles por centímetro,,{0} pixel por centímetro,{0} pixeles por centímetro
        pixel-per-inch,,,,,,,,,pixeles por pulgada,,{0} pixel por pulgada,{0} pixeles por pulgada
        nautical-mile,mn,,{0}mn,{0}mn,mn,,{0} mn,{0} mn,millas naúticas,,{0} milla naútica,{0} millas naúticas
        horsepower,,,,,,,,,caballos de fuerza,,{0} caballo de fuerza,{0} caballos de fuerza
        beaufort,B,,B {0},B {0},Beaufort,,Beaufort {0},Beaufort {0},Escala Beaufort,,Escala Beaufort {0},Escala Beaufort {0}
        light-speed,luz,,{0}luz,{0}luces,luz,,{0} luz,{0} de luces,luz,,{0} luz,{0} luces
        generic,,,,,,,,,grados,,{0} grado,{0} grados
        kelvin,,,,,,,,,kelvin,,kelvin,{0} kelvin
        pound-force-foot,lbf⋅ft,,{0}lbf ft,{0}lbf ft,lbf⋅ft,,{0} lbf⋅ft,{0} lbf⋅ft,libra fuerza-pies,,{0} libra fuerza-pie,{0} libra fuerza-pies
        acre-foot,,,,,,,,,acres-pies,,{0} acre-pie,{0} acres pies
        dram,fl dracma,,{0}fl dr,{0}fl dr,fl dracma,,{0} fl dracma,{0} fl dracmas,dracma fluida,,{0} dracma fluida,{0} dreacmas fluidas
        fluid-ounce-imperial,,,,,,,,,onzas fluidas imperiales,,onza fluida imperial,{0} onzas fluidas imperiales
        percent,,,,,%,,{0} %,{0} %,,,,
        permille,,,,,‰,,{0} ‰,{0} ‰,,,,
        portion-per-1e9,partes/mil millones,,{0}ppb,{0}ppb,partes/mil millones,,,{0} ppb,,,,
        bit,bit,,{0}b,{0}b,bit,,{0} b,{0} b,,,,
        byte,byte,,{0}B,{0}B,byte,,{0} byte,{0} byte,,,,
        day,día,{0}/d,{0}d,{0}d,días,{0}/d,{0} día,{0} días,,,,
        month,m,{0}/m.,{0}m,{0}m,mm.,{0}/m.,{0} m,{0} mm.,,,,
        year,a,{0}/a,{0}a,{0}a,aa.,{0}/a,{0} a,{0} aa.,,,,
        therm-us,th US,,{0}th US,{0}th US,th US,,{0} th US,{0} th US,,,,
        furlong,furlong,,{0}fur,{0}fur,furlongs,,,{0} fur,,,,
        light-year,,,,,aa. l.,,{0} a. l.,{0} a. l.,,,,
        mile-scandinavian,mil,,{0}mil,{0}mil,mil,,{0} mil,{0} mil,,,,
        yard,yd,,{0}yd,{0}yd,yd,,,{0} yd,,,,
        knot,,,,,kn,,{0} nudo,{0} nudos,,,,
        bushel,bsh,,{0}bsh,{0}bsh,bsh,,{0} bsh,{0} bsh,,,,
        cup,tza.,,{0}tza,{0}tza,tza.,,{0} tzas.,{0} tzas.,,,,
        dessert-spoon,cdapostre,,{0}c/p,{0}c/p,cdapostre,,{0} cdapostre,{0} cdapostre,,,,
        dessert-spoon-imperial,,,,,cdapostre imp.,,{0} cdapostre imp.,{0} cdaspostre imp.,,,,
        pint-metric,ptm,,{0}ptm,{0}ptm,ptm,,{0} ptm,{0} ptm,,,,
        arc-minute,arcmin,,{0} arcmin,{0}′,,,,,,,,
        arc-second,arcsec,,{0} arcsec,{0}″,,,,,,,,
        fathom,braza,,{0}ftm,{0}ftm,,,,,,,,
        kilometer,km,{0}/km,{0} km,{0}km,,,,,,,,
        millimeter,mm,,{0} mm,{0}mm,,,,,,,,
        fahrenheit,°F,,{0}°,{0}°,,,,,,,,
        """.trimIndent()
  }

  private val es_US_Prefixes: String by lazy {
    """10p-2,,,centí{0}
        10p-27,,,ronto {0}
        10p-30,,,quecto {0}
        """.trimIndent()
  }

  private val es_UY_Units: String? = null

  private val es_UY_Prefixes: String? = null

  private val es_VE_Units: String? = null

  private val es_VE_Prefixes: String? = null

  private val et_Units: String by lazy {
    """g-force,Maa raskuskiirendus,,,{0} G,Maa raskuskiirendus,,,{0} G,Maa raskuskiirendus,,{0} Maa raskuskiirendus,{0} Maa raskuskiirendust
        meter-per-square-second,,,,,,,,,meetrid sekundi ruudu kohta,,{0} meeter sekundi ruudu kohta,{0} meetrit sekundi ruudu kohta
        arc-minute,kaareminut,,,{0}′,kaareminut,,,{0}′,kaareminutid,,{0} kaareminut,{0} kaareminutit
        arc-second,″,,,{0}″,″,,,{0}″,kaaresekundid,,{0} kaaresekund,{0} kaaresekundit
        degree,kraadid,,,{0}°,kraadid,,,{0}°,kraadid,,{0} kraad,{0} kraadi
        radian,radiaanid,,,{0} rad,radiaanid,,,{0} rad,radiaanid,,{0} radiaan,{0} radiaani
        revolution,pööre,,{0} pööre,{0} pööret,pööre,,{0} pööre,{0} pööret,täispööre,,{0} täispööre,{0} täispööret
        acre,aakrid,,{0} aaker,{0} aakrit,aakrid,,,{0} ac,aakrid,,{0} aaker,{0} aakrit
        dunam,dunamid,,{0} dunam,{0} dunami,dunamid,,{0} dunam,{0} dunami,dunamid,,{0} dunam,{0} dunami
        hectare,hektarid,,,{0} ha,hektarid,,,{0} ha,hektarid,,{0} hektar,{0} hektarit
        square-centimeter,,,,,,,,,ruutsentimeetrid,{0} ruutsentimeetri kohta,{0} ruutsentimeeter,{0} ruutsentimeetrit
        square-foot,ruutjalad,,,{0} ft²,ruutjalad,,,{0} ft²,ruutjalad,,{0} ruutjalg,{0} ruutjalga
        square-inch,ruuttollid,{0}/in²,,{0} in²,ruuttollid,{0}/in²,,{0} in²,ruuttollid,{0} ruuttolli kohta,{0} ruuttoll,{0} ruuttolli
        square-kilometer,,,,,,,,,ruutkilomeetrid,{0} ruutkilomeetri kohta,{0} ruutkilomeeter,{0} ruutkilomeetrit
        square-meter,,,,,,,,,ruutmeetrid,{0} ruutmeetri kohta,{0} ruutmeeter,{0} ruutmeetrit
        square-mile,,,,,,,,,ruutmiilid,{0} ruutmiili kohta,{0} ruutmiil,{0} ruutmiili
        square-yard,ruutjardid,,,{0} yd²,ruutjardid,,,{0} yd²,ruutjardid,,{0} ruutjard,{0} ruutjardi
        item,üksus,,{0} üksus,{0} üksust,üksus,,{0} üksus,{0} üksust,üksus,,{0} üksus,{0} üksust
        karat,karaat,,{0} ct,{0} ct,karaat,,{0} ct,{0} ct,karaadid,,{0} karaat,{0} karaati
        milligram-ofglucose-per-deciliter,mg/dl,,{0} mg/dl,{0} mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligrammid detsiliitri kohta,,{0} milligramm detsiliitri kohta,{0} milligrammi detsiliitri kohta
        millimole-per-liter,mmol/l,,{0} mmol/l,{0} mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,millimoolid liitri kohta,,{0} millimool liitri kohta,{0} millimooli liitri kohta
        mole,,,,,mool,,,{0} mol,moolid,,{0} mool,{0} mooli
        percent,,,,,,,,,protsent,,{0} protsent,{0} protsenti
        permille,,,,,,,,,promill,,{0} promill,{0} promilli
        permillion,osa/miljon,,,{0} ppm,osa/miljon,,,{0} ppm,osa miljoni kohta,,{0} osa miljoni kohta,{0} osa miljoni kohta
        permyriad,promüriaad,,,{0}‱,promüriaad,,,{0}‱,promüriaad,,{0} promüriaad,{0} promüriaadi
        portion-per-1e9,osakesed/miljard,,{0} miljardikosa,{0} miljardikosa,osakesed/miljard,,{0} miljardikosa,{0} miljardikosa,miljardikosa,,{0} miljardikosa,{0} miljardikosa
        liter-per-100-kilometer,l/100 km,,{0} l/100km,{0} l/100km,l/100 km,,{0} l/100 km,{0} l/100 km,liitrid 100 kilomeetri kohta,,{0} liiter 100 kilomeetri kohta,{0} liitrit 100 kilomeetri kohta
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,liitrid kilomeetri kohta,,{0} liiter kilomeetri kohta,{0} liitrit kilomeetri kohta
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,miil/gallon,,{0} mpg,{0} mpg,miilid galloni kohta,,{0} miil galloni kohta,{0} miili galloni kohta
        mile-per-gallon-imperial,mpg UK,,{0} m/gUK,{0} m/gUK,miil / gal imp.,,{0} mpg imp.,{0} mpg imp.,miilid inglise galloni kohta,,{0} miil inglise galloni kohta,{0} miili inglise galloni kohta
        bit,bitt,,{0} b,{0} b,bitt,,{0} b,{0} b,bitid,,{0} bitt,{0} bitti
        byte,bait,,{0} B,{0} B,bait,,{0} bait,{0} baiti,baidid,,{0} bait,{0} baiti
        gigabit,,,,,,,,,gigabitid,,{0} gigabitt,{0} gigabitti
        gigabyte,,,,,,,,,gigabaidid,,{0} gigabait,{0} gigabaiti
        kilobit,,,,,,,,,kilobitid,,{0} kilobitt,{0} kilobitti
        kilobyte,,,,,,,,,kilobaidid,,{0} kilobait,{0} kilobaiti
        megabit,,,,,,,,,megabitid,,{0} megabitt,{0} megabitti
        megabyte,,,,,,,,,megabaidid,,{0} megabait,{0} megabaiti
        petabyte,,,,,,,,,petabaidid,,{0} petabait,{0} petabaiti
        terabit,,,,,,,,,terabitid,,{0} terabitt,{0} terabitti
        terabyte,,,,,,,,,terabaidid,,{0} terabait,{0} terabaiti
        century,saj,,{0} saj,{0} saj,saj,,{0} saj,{0} saj,sajandid,,{0} sajand,{0} sajandit
        day,päev,{0}/ööp,{0} p,{0} p,päevad,{0}/ööp,{0} päev,{0} päeva,ööpäevad,{0} ööpäevas,{0} ööpäev,{0} ööpäeva
        decade,dek,,{0} dek,{0} dek,dek,,{0} dek,{0} dek,dekaadid,,{0} dekaad,{0} dekaadi
        hour,t,{0}/t,{0} t,{0} t,t,{0}/t,{0} t,{0} t,tunnid,{0} tunnis,{0} tund,{0} tundi
        microsecond,,,,,,,,,mikrosekundid,,{0} mikrosekund,{0} mikrosekundit
        millisecond,,,,,,,,,millisekundid,,{0} millisekund,{0} millisekundit
        minute,,,,,,,,,minutid,{0} minutis,{0} minut,{0} minutit
        month,kuud,{0}/k,{0} k,{0} k,kuud,{0}/k,{0} kuu,{0} kuud,kuud,{0} kuus,{0} kuu,{0} kuud
        nanosecond,,,,,,,,,nanosekundid,,{0} nanosekund,{0} nanosekundit
        night,ööd,{0}/öö,{0} öö,{0} ööd,ööd,{0}/öö,{0} öö,{0} ööd,ööd,{0} öö kohta,{0} öö,{0} ööd
        quarter,kv,{0}/kv,{0} kv,{0} kv,kv,{0}/kv,{0} kv,{0} kv,kvartalid,{0}/kv,{0} kvartal,{0} kvartalit
        second,s,{0}/s,{0} s,{0} s,sek,{0}/sek,{0} sek,{0} sek,sekundid,{0} sekundis,{0} sekund,{0} sekundit
        week,n,{0}/näd,{0} n,{0} n,näd,{0}/näd,{0} näd,{0} näd,nädalad,{0} nädalas,{0} nädal,{0} nädalat
        year,a,{0}/a,{0} a,{0} a,aastad,{0}/a,{0} a,{0} a,aastad,{0} aastas,{0} aasta,{0} aastat
        ampere,amprid,,,{0} A,amprid,,,{0} A,amprid,,{0} amper,{0} amprit
        milliampere,milliamprid,,,{0} mA,milliamprid,,,{0} mA,milliamprid,,{0} milliamper,{0} milliamprit
        ohm,oomid,,,{0} Ω,oomid,,,{0} Ω,oomid,,{0} oom,{0} oomi
        volt,voldid,,,{0} V,voldid,,,{0} V,voldid,,{0} volt,{0} volti
        british-thermal-unit,Briti soojusühik,,,{0} Btu,Briti soojusühik,,,{0} Btu,Briti soojusühikud,,{0} Briti soojusühik,{0} Briti soojusühikut
        calorie,,,,,,,,,kalorid,,{0} kalor,{0} kalorit
        electronvolt,elektronvolt,,,{0} eV,elektronvolt,,,{0} eV,elektronvoldid,,{0} elektronvolt,{0} elektronvolti
        foodcalorie,cal,,{0} cal,{0} cal,cal,,{0} cal,{0} cal,kalorid,,{0} kalor,{0} kalorit
        joule,džaulid,,,{0} J,džaulid,,,{0} J,džaulid,,{0} džaul,{0} džauli
        kilocalorie,,,,,,,,,kilokalorid,,{0} kilokalor,{0} kilokalorit
        kilojoule,,,,,,,,,kilodžaulid,,{0} kilodžaul,{0} kilodžauli
        kilowatt-hour,kW-tund,,,{0} kWh,kW-tund,,,{0} kWh,kilovatt-tunnid,,{0} kilovatt-tund,{0} kilovatt-tundi
        therm-us,USA term,,{0} USA term,{0} USA termi,USA term,,{0} USA term,{0} USA termi,USA termid,,{0} USA term,{0} USA termi
        kilowatt-hour-per-100-kilometer,kWh / 100 km,,{0}kWh/100km,{0}kWh/100km,kWh / 100 km,,{0} kWh / 100 km,{0} kWh / 100 km,kilovatt-tunnid 100 kilomeetri kohta,,{0} kilovatt-tund 100 kilomeetri kohta,{0} kilovatt-tundi 100 kilomeetri kohta
        newton,,,,,njuuton,,,{0} N,njuutonid,,{0} njuuton,{0} njuutonit
        pound-force,jõunael,,,{0} lbf,jõunael,,,{0} lbf,jõunaelad,,{0} jõunael,{0} jõunaela
        gigahertz,,,,,,,,,gigahertsid,,{0} gigaherts,{0} gigahertsi
        hertz,,,,,,,,,hertsid,,{0} herts,{0} hertsi
        kilohertz,,,,,,,,,kilohertsid,,{0} kiloherts,{0} kilohertsi
        megahertz,,,,,,,,,megahertsid,,{0} megaherts,{0} megahertsi
        dot,p,,{0} p,{0} p,p,,{0} p,{0} p,punktid,,{0} punkt,{0} punkti
        dot-per-centimeter,,,,,,,,,punkte sentimeetri kohta,,{0} punkt sentimeetri kohta,{0} punkti sentimeetri kohta
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,punkte tolli kohta,,{0} punkt tolli kohta,{0} punkti tolli kohta
        em,emm,,{0} emm,{0} emmi,emm,,{0} emm,{0} emmi,tüpograafiline emm,,{0} emm,{0} emmi
        megapixel,megapikslid,,,{0} MP,megapikslid,,,{0} MP,megapikslid,,{0} megapiksel,{0} megapikslit
        pixel,pikslid,,,{0} px,pikslid,,,{0} px,pikslid,,{0} piksel,{0} pikslit
        pixel-per-centimeter,,,,,,,,,piksleid sentimeetri kohta,,{0} piksel sentimeetri kohta,{0} pikslit sentimeetri kohta
        pixel-per-inch,,,,,,,,,piksleid tolli kohta,,{0} piksel tolli kohta,{0} pikslit tolli kohta
        astronomical-unit,aü,,{0} aü,{0} aü,aü,,{0} aü,{0} aü,astronoomilised ühikud,,{0} astronoomiline ühik,{0} astronoomilist ühikut
        centimeter,,,,,,,,,sentimeetrid,{0} sentimeetri kohta,{0} sentimeeter,{0} sentimeetrit
        decimeter,,,,,,,,,detsimeetrid,,{0} detsimeeter,{0} detsimeetrit
        earth-radius,,,,,,,,,Maa raadius,,{0} Maa raadius,{0} Maa raadiust
        fathom,süllad,,,{0} fth,süllad,,,{0} fth,süllad,,{0} süld,{0} sülda
        foot,ft,{0}/ft,{0} jalg,{0} jalga,,,,,jalad,{0} jala kohta,{0} jalg,{0} jalga
        furlong,furlongid,,,{0} fur,furlongid,,,{0} fur,furlongid,,{0} furlong,{0} furlongi
        inch,tollid,{0}/in,{0} toll,{0} tolli,tollid,{0}/in,,{0} in,tollid,{0} tolli kohta,{0} toll,{0} tolli
        kilometer,,,,,,,,,kilomeetrid,{0} kilomeetri kohta,{0} kilomeeter,{0} kilomeetrit
        light-year,valgusaastad,,{0} valgusa.,{0} valgusa.,valgusaastad,,{0} valgusa.,{0} valgusa.,valgusaastad,,{0} valgusaasta,{0} valgusaastat
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,meetrid,{0} meetri kohta,{0} meeter,{0} meetrit
        micrometer,,,,,,,,,mikromeetrid,,{0} mikromeeter,{0} mikromeetrit
        mile,mi,,{0} miil,{0} miili,,,,,miilid,,{0} miil,{0} miili
        mile-scandinavian,,,,,,,,,Skandinaavia miilid,,{0} Skandinaavia miil,{0} Skandinaavia miili
        millimeter,,,,,,,,,millimeetrid,,{0} millimeeter,{0} millimeetrit
        nanometer,,,,,,,,,nanomeetrid,,{0} nanomeeter,{0} nanomeetrit
        nautical-mile,,,,,,,,,meremiilid,,{0} meremiil,{0} meremiili
        parsec,parsekid,,,{0} pc,parsekid,,,{0} pc,parsekid,,{0} parsek,{0} parsekit
        picometer,,,,,,,,,pikomeetrid,,{0} pikomeeter,{0} pikomeetrit
        point,punktid,,,{0} pt,tüpograafilised punktid,,,{0} pt,tüpograafilised punktid,,{0} tüpograafiline punkt,{0} tüpograafilist punkti
        solar-radius,Päikese raadiused,,,{0} R☉,Päikese raadiused,,,{0} R☉,Päikese raadiused,,{0} Päikese raadiust,{0} Päikese raadiust
        yard,jardid,,{0} jard,{0} jardi,jardid,,,{0} yd,jardid,,{0} jard,{0} jardi
        candela,,,,,,,,,kandela,,{0} kandela,{0} kandelat
        lumen,,,,,,,,,luumen,,{0} luumen,{0} luumenit
        lux,,,,,,,,,luks,,{0} luks,{0} luksi
        solar-luminosity,Päikese heledus,,,{0} L☉,Päikese heledus,,,{0} L☉,Päikese heledus,,{0} Päikese heledus,{0} Päikese heledust
        carat,ct,,{0} ct,{0} ct,ct,,{0} ct,{0} ct,karaadid,,{0} karaat,{0} karaati
        dalton,daltonid,,,{0} Da,daltonid,,,{0} Da,daltonid,,{0} dalton,{0} daltonit
        earth-mass,Maa massid,,,{0} M⊕,Maa massid,,,{0} M⊕,Maa massid,,{0} Maa massi,{0} Maa massi
        grain,graan,,{0} graan,{0} graani,graan,,{0} graan,{0} graani,graan,,{0} graan,{0} graani
        gram,gramm,{0}/g,,{0} g,grammid,{0}/g,,{0} g,grammid,{0} grammi kohta,{0} gramm,{0} grammi
        kilogram,,,,,,,,,kilogrammid,{0} kilogrammi kohta,{0} kilogramm,{0} kilogrammi
        microgram,,,,,,,,,mikrogrammid,,{0} mikrogramm,{0} mikrogrammi
        milligram,,,,,,,,,milligrammid,,{0} milligramm,{0} milligrammi
        ounce,,,,,,,,,untsid,{0} untsi kohta,{0} unts,{0} untsi
        ounce-troy,,,,,,,,,troiuntsid,,{0} troiunts,{0} troiuntsi
        pound,naelad,{0}/lb,,{0} lb,naelad,{0}/lb,,{0} lb,naelad,{0} naela kohta,{0} nael,{0} naela
        solar-mass,Päikese massid,,,{0} M☉,Päikese massid,,,{0} M☉,Päikese massid,,{0} Päikese massi,{0} Päikese massi
        stone,kivid,,,{0} st,kivid,,,{0} st,kivid,,{0} kivi,{0} kivi
        ton,lüh t,,{0} lüh t,{0} lüh t,lüh t,,{0} lüh t,{0} lüh t,lühikesed tonnid,,{0} lühike tonn,{0} lühikest tonni
        tonne,,,,,,,,,tonnid,,{0} tonn,{0} tonni
        gigawatt,,,,,,,,,gigavatid,,{0} gigavatt,{0} gigavatti
        horsepower,hj,,{0} hj,{0} hj,hj,,{0} hj,{0} hj,hobujõud,,{0} hobujõud,{0} hobujõudu
        kilowatt,,,,,,,,,kilovatid,,{0} kilovatt,{0} kilovatti
        megawatt,,,,,,,,,megavatid,,{0} megavatt,{0} megavatti
        milliwatt,,,,,,,,,millivatid,,{0} millivatt,{0} millivatti
        watt,vatid,,,{0} W,vatid,,,{0} W,vatid,,{0} vatt,{0} vatti
        atmosphere,,,,,,,,,atmosfäärid,,{0} atmosfäär,{0} atmosfääri
        bar,baar,,{0} baar,{0} baari,baar,,{0} baar,{0} baari,baarid,,{0} baar,{0} baari
        hectopascal,,,,,,,,,hektopaskalid,,{0} hektopaskal,{0} hektopaskalit
        inch-ofhg,″ Hg,,{0} toll Hg,{0} tolli Hg,in Hg,,{0} in Hg,{0} in Hg,tollid elavhõbedasammast,,{0} toll elavhõbedasammast,{0} tolli elavhõbedasammast
        kilopascal,,,,,,,,,kilopaskalid,,{0} kilopaskal,{0} kilopaskalit
        megapascal,,,,,,,,,megapaskalid,,{0} megapaskal,{0} megapaskalit
        millibar,,,,,,,,,millibaarid,,{0} millibaar,{0} millibaari
        millimeter-ofhg,,,,,,,,,millimeetrid elavhõbedasammast,,{0} millimeeter elavhõbedasammast,{0} millimeetrit elavhõbedasammast
        pascal,,,,,,,,,paskalid,,{0} paskal,{0} paskalit
        pound-force-per-square-inch,,,,,,,,,naelad ruuttolli kohta,,{0} nael ruuttolli kohta,{0} naela ruuttolli kohta
        beaufort,Bft,,B{0},B{0},,,,,Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,,,,,,,,,kilomeetrid tunnis,,{0} kilomeeter tunnis,{0} kilomeetrit tunnis
        knot,,,,,,,,,sõlm,,{0} sõlm,{0} sõlme
        meter-per-second,,,,,,,,,meetrid sekundis,,{0} meeter sekundis,{0} meetrit sekundis
        mile-per-hour,,,,,,,,,miilid tunnis,,{0} miil tunnis,{0} miili tunnis
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,Celsiuse kraadid,,{0} Celsiuse kraad,{0} Celsiuse kraadi
        fahrenheit,°F,,{0} °F,{0} °F,°F,,{0} °F,{0} °F,Fahrenheiti kraadid,,{0} Fahrenheiti kraad,{0} Fahrenheiti kraadi
        generic,,,,,,,,,°,,{0} kraad,{0} kraadi
        kelvin,,,,,,,,,kelvinid,,{0} kelvin,{0} kelvinit
        newton-meter,Nm,,{0} Nm,{0} Nm,Nm,,{0} Nm,{0} Nm,njuutonmeetrid,,{0} njuutonmeeter,{0} njuutonmeetrit
        pound-force-foot,,,,,,,,,naeljalad,,{0} naeljalg,{0} naeljalga
        acre-foot,aakerjalg,,,{0} ac ft,aakerjalg,,,{0} ac ft,aakerjalad,,{0} aakerjalg,{0} aakerjalga
        barrel,barrel,,,{0} bbl,barrel,,,{0} bbl,barrelid,,{0} barrel,{0} barrelit
        bushel,buššelid,,,{0} bu,buššelid,,,{0} bu,buššelid,,{0} buššel,{0} buššelit
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,sentiliitrid,,{0} sentiliiter,{0} sentiliitrit
        cubic-centimeter,,,,,,,,,kuupsentimeetrid,{0} kuupsentimeetri kohta,{0} kuupsentimeeter,{0} kuupsentimeetrit
        cubic-foot,,,,,,,,,kuupjalad,,{0} kuupjalg,{0} kuupjalga
        cubic-inch,kuuptollid,,,{0} in³,kuuptollid,,,{0} in³,kuuptollid,,{0} kuuptoll,{0} kuuptolli
        cubic-kilometer,,,,,,,,,kuupkilomeetrid,,{0} kuupkilomeeter,{0} kuupkilomeetrit
        cubic-meter,,,,,,,,,kuupmeetrid,{0} kuupmeetri kohta,{0} kuupmeeter,{0} kuupmeetrit
        cubic-mile,kuupmiilid,,,{0} mi³,kuupmiilid,,,{0} mi³,kuupmiilid,,{0} kuupmiil,{0} kuupmiili
        cubic-yard,kuupjardid,,,{0} yd³,kuupjardid,,,{0} yd³,kuupjardid,,{0} kuupjard,{0} kuupjardi
        cup,tass,,,{0} c,tass,,,{0} c,tassid,,{0} tass,{0} tassi
        cup-metric,,,,,,,,,meetrilised tassid,,{0} meetriline tass,{0} meetrilist tassi
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,detsiliitrid,,{0} detsiliiter,{0} detsiliitrit
        dessert-spoon,,,,,,,,,dessertlusikas,,{0} dessertlusikas,{0} dessertlusikat
        dessert-spoon-imperial,ingl dl,,{0} ingl dl,{0} ingl dl,ingl dl,,{0} ingl dl,{0} ingl dl,inglise dessertlusikas,,{0} inglise dessertlusikas,{0} inglise dessertlusikat
        dram,d. ved.,,{0} d. ved.,{0} d. ved.,drahm vedelikku,,{0} drahm vedelikku,{0} drahmi vedelikku,drahm,,{0} drahm,{0} drahmi
        drop,tilk,,{0} tilk,{0} tilka,tilk,,{0} tilk,{0} tilka,tilk,,{0} tilk,{0} tilka
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,vedelikuuntsid,,{0} vedelikuunts,{0} vedelikuuntsi
        fluid-ounce-imperial,Imp fl oz,,{0} fl oz Im,{0} fl oz Im,,,,,inglise vedelikuuntsid,,{0} inglise vedelikuuntsi,{0} inglise vedelikuuntsi
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,gallonid,{0} galloni kohta,{0} gallon,{0} gallonit
        gallon-imperial,Imp. gal,{0}/gal Imp.,{0} gal Im,{0} gal Im,,,,,inglise gallonid,{0} inglise galloni kohta,{0} inglise gallon,{0} inglise gallonit
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hektoliitrid,,{0} hektoliiter,{0} hektoliitrit
        jigger,pits,,{0} pits,{0} pitsi,pits,,{0} pits,{0} pitsi,pits,,{0} pits,{0} pitsi
        liter,liiter,{0}/l,,{0} l,liitrid,{0}/l,,{0} l,liitrid,{0} liitri kohta,{0} liiter,{0} liitrit
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megaliitrid,,{0} megaliiter,{0} megaliitrit
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,milliliitrid,,{0} milliliiter,{0} milliliitrit
        pinch,näp.,,{0} näp.,{0} näp.,näputäis,,{0} näputäis,{0} näputäit,näputäis,,{0} näputäis,{0} näputäit
        pint,pindid,,,{0} pt,pindid,,,{0} pt,pindid,,{0} pint,{0} pinti
        pint-metric,,,,,,,,,meetrilised pindid,,{0} meetriline pint,{0} meetrilist pinti
        quart,kvart,,,{0} qt,kvart,,,{0} qt,kvardid,,{0} kvart,{0} kvarti
        quart-imperial,qt Imp,,{0} qt Imp.,{0} qt Imp.,ingl kvart,,{0} ingl kvart,{0} ingl kvarti,inglise kvart,,{0} inglise kvart,{0} inglise kvarti
        tablespoon,spl,,{0} spl,{0} spl,spl,,{0} spl,{0} spl,supilusikad,,{0} supilusikas,{0} supilusikat
        teaspoon,tl,,{0} tl,{0} tl,tl,,{0} tl,{0} tl,teelusikad,,{0} teelusikas,{0} teelusikat
        """.trimIndent()
  }

  private val et_Prefixes: String by lazy {
    """square,,,ruut{0}
        cubic,,,kuup{0}
        per,,,{0} {1} kohta
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,eksbi{0}
        1024p7,,,zebi{0}
        1024p8,,,jobe{0}
        10p-1,,,detsi{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,ato{0}
        10p-2,,,senti{0}
        10p-21,,,zepto{0}
        10p-24,,,jokto{0}
        10p-27,,,ronto{0}
        10p-3,,,milli{0}
        10p-30,,,kvekto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,eksa{0}
        10p2,,,hekto{0}
        10p21,,,zeta{0}
        10p24,,,jota{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,kveta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val eu_Units: String by lazy {
    """g-force,G,,,{0} G,G,,,{0} G,grabitate-indar,,{0} grabitate-indar,{0} grabitate-indar
        meter-per-square-second,,,,,,,,,metroak segundo karratu bakoitzeko,,{0} metro segundo karratu bakoitzeko,{0} metro segundo karratu bakoitzeko
        arc-minute,arku-min,,{0}′,{0}′,arku-min,,{0} arku-min,{0} arku-min,arku-minutuak,,{0} arku-minutu,{0} arku-minutu
        arc-second,arku-seg.,,{0}″,{0}″,arku-seg.,,{0} arku-seg.,{0} arku-seg.,arku-segundoak,,{0} arku-segundo,{0} arku-segundo
        degree,gradu,,,{0}°,gradu,,,{0}°,graduak,,{0} gradu,{0} gradu
        radian,,,,,,,,,radianak,,{0} radian,{0} radian
        revolution,bira,,{0} bira,{0} bira,bira,,{0} bira,{0} bira,birak,,{0} bira,{0} bira
        acre,akre,,{0} ac,{0} ac,akre,,{0} akre,{0} akre,akre,,{0} akre,{0} akre
        hectare,hektarea,,,{0} ha,hektarea,,,{0} ha,hektarea,,{0} hektarea,{0} hektarea
        square-centimeter,,,,,,,,,cm²,{0} zentimetro karratu bakoitzeko,{0} zentimetro karratu,{0} zentimetro karratu
        square-foot,,,,,,,,,oin karratu,,{0} oin karratu,{0} oin karratu
        square-inch,,,,,,,,,hazbete karratu,{0}/in²,{0} hazbete karratu,{0} hazbete karratu
        square-kilometer,,,,,,,,,kilometro karratu,{0} kilometro karratu bakoitzeko,{0} kilometro karratu,{0} kilometro karratu
        square-meter,,,,,,,,,metro karratu,{0} metro karratu bakoitzeko,{0} metro karratu,{0} metro karratu
        square-mile,milia karratu,{0}/mi²,,{0} mi²,milia karratu,{0}/mi²,,{0} mi²,milia karratu,{0} milia karratu bakoitzeko,{0} milia karratu,{0} milia karratu
        square-yard,,,,,,,,,yarda karratu,,{0} yarda karratu,{0} yarda karratu
        item,elementua,,{0} elementu,{0} elementu,elementua,,{0} elementu,{0} elementu,elementuak,,{0} elementu,{0} elementu
        karat,,,,,,,,,kilateak,,{0} kilate,{0} kilate
        milligram-ofglucose-per-deciliter,mg/dl,,{0} mg/dl,{0} mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,miligramo dezilitro bakoitzeko,,{0} miligramo dezilitro bakoitzeko,{0} miligramo dezilitro bakoitzeko
        millimole-per-liter,mmol/l,,{0} mmol/l,{0} mmol/l,milimole/litro,,{0} mmol/l,{0} mmol/l,milimole litro bakoitzeko,,{0} milimole litro bakoitzeko,{0} milimole litro bakoitzeko
        mole,mola,,,{0} mol,mola,,,{0} mol,molak,,,{0} mol
        percent,%,,% {0},% {0},%,,% {0},% {0},ehuneko,,ehuneko {0},ehuneko {0}
        permille,‰,,‰ {0},‰ {0},‰,,‰ {0},‰ {0},milako,,milako {0},milako {0}
        permillion,zati/milioi,,,{0} ppm,zati/milioi,,,{0} ppm,zati milioi bakoitzeko,,{0} zati milioi bakoitzeko,{0} zati milioi bakoitzeko
        permyriad,‱,,‱ {0},‱ {0},‱,,‱ {0},‱ {0},‱,,‱ {0},‱ {0}
        portion-per-1e9,zati / m. m.,,{0} zati / m. m.,{0} zati / m. m.,zati / mila milioi,,{0} zati / m. m.,{0} zati / m. m.,zati mila milioiko,,{0} zati mila milioiko,{0} zati mila milioiko
        liter-per-100-kilometer,l/100 km,,{0} l/100 km,{0} l/100 km,l/100 km,,{0} l/100 km,{0} l/100 km,litro 100 kilometro bakoitzeko,,{0} litro 100 kilometro bakoitzeko,{0} litro 100 kilometro bakoitzeko
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,litro kilometro bakoitzeko,,{0} litro kilometro bakoitzeko,{0} litro kilometro bakoitzeko
        mile-per-gallon,mi/gal,,mi/gal,{0} mi/gal,mi/gal,,mi/gal,{0} mi/gal,milia galoi bakoitzeko,,{0} milia galoi bakoitzeko,{0} milia galoi bakoitzeko
        mile-per-gallon-imperial,milia/galoi britainiar,,{0} m/g brit.,{0} m/g brit.,milia/galoi britainiar,,{0} mi gal brit.,{0} mi gal brit.,milia galoi britainiar bakoitzeko,,{0} milia galoi britainiar bakoitzeko,{0} milia galoi britainiar bakoitzeko
        bit,,,,,,,,,bit-ak,,,{0} bit
        byte,,,,,,,,,byte-ak,,,{0} byte
        gigabit,,,,,,,,,gigabit-ak,,{0} gigabit,{0} gigabit
        gigabyte,,,,,,,,,gigabyte-ak,,{0} gigabyte,{0} gigabyte
        kilobit,,,,,,,,,kilobit-ak,,{0} kilobit,{0} kilobit
        kilobyte,,,,,,,,,kilobyte-ak,,{0} kilobyte,{0} kilobyte
        megabit,,,,,,,,,megabit-ak,,{0} megabit,{0} megabit
        megabyte,,,,,,,,,megabyte-ak,,{0} megabyte,{0} megabyte
        petabyte,,,,,,,,,petabyte,,{0} petabyte,{0} petabyte
        terabit,,,,,,,,,terabit-ak,,{0} terabit,{0} terabit
        terabyte,,,,,,,,,terabyte-ak,,{0} terabyte,{0} terabyte
        century,m.,,{0}m.,{0}m.,m.,,{0} m.,{0} m.,mendeak,,{0} mende,{0} mende
        day,egun,{0}/e.,{0} e.,{0} e.,egun,{0}/e.,{0} egun,{0} egun,egunak,{0} egun bakoitzeko,{0} egun,{0} egun
        decade,hamark.,,{0} hamark.,{0} hamark.,hamarkada,,{0} hamark.,{0} hamark.,hamarkadak,,{0} hamarkada,{0} hamarkada
        hour,ordu,{0}/h,,{0} h,ordu,{0}/h,,{0} h,orduak,{0} ordu bakoitzeko,{0} ordu,{0} ordu
        microsecond,,,,,,,,,mikrosegundoak,,{0} mikrosegundo,{0} mikrosegundo
        millisecond,,,,,milisegundo,,,{0} ms,milisegundoak,,{0} milisegundo,{0} milisegundo
        minute,,,,,,,,,minutuak,{0} minutu bakoitzeko,{0} minutu,{0} minutu
        month,hilabete,{0}/hil,{0} hil,{0} hil,hilabete,{0}/hil,{0} hilabete,{0} hilabete,hilabeteak,{0} hilabete bakoitzeko,{0} hilabete,{0} hilabete
        nanosecond,,,,,,,,,nanosegundoak,,{0} nanosegundo,{0} nanosegundo
        night,gau,{0}/gau,{0} g.,{0} g.,gau,{0}/gau,{0} gau,{0} gau,gauak,{0} gau bakoitzeko,{0} gau,{0} gau
        quarter,laurden,{0}/laurden,{0} laur.,{0} laur.,laurden,{0}/laurden,{0} laur.,{0} laur.,laurdenak,{0} laurden bakoitzeko,{0} laurden,{0} laurden
        second,s,{0}/s,,{0} s,segundo,{0}/s,,{0} s,segundoak,{0} segundo bakoitzeko,{0} segundo,{0} segundo
        week,aste,{0}/a.,{0} aste,{0} aste,aste,{0}/a.,{0} aste,{0} aste,asteak,{0} aste bakoitzeko,{0} aste,{0} aste
        year,urte,{0}/u.,{0} u.,{0} u.,urte,{0}/u.,{0} urte,{0} urte,urteak,{0} urte bakoitzeko,{0} urte,{0} urte
        ampere,A,,,{0} A,A,,,{0} A,ampereak,,{0} ampere,{0} ampere
        milliampere,,,,,,,,,miliampereak,,{0} miliampere,{0} miliampere
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,ohm-ak,,{0} ohm,{0} ohm
        volt,V,,,{0} V,V,,,{0} V,voltak,,{0} volt,{0} volt
        calorie,,,,,,,,,kaloriak,,{0} kaloria,{0} kaloria
        foodcalorie,,,,,,,,,kaloriak,,{0} kaloria,{0} kaloria
        joule,J,,,{0} J,J,,,{0} J,joule-ak,,{0} joule,{0} joule
        kilocalorie,,,,,,,,,kilokaloriak,,{0} kilokaloria,{0} kilokaloria
        kilojoule,,,,,,,,,kilojoule-ak,,{0} kilojoule,{0} kilojoule
        kilowatt-hour,,,,,,,,,kilowatt-ordu,,{0} kilowatt-ordu,{0} kilowatt-ordu
        therm-us,AEBko termia,,{0} US therm,{0} US therms,AEBko termia,,{0} AEBko termia,{0} AEBko termia,AEBko termiak,,{0} AEBko termia,{0} AEBko termia
        kilowatt-hour-per-100-kilometer,kWh / 100 km,,{0} kWh / 100 km,{0} kWh / 100 km,kWh / 100 km,,{0} kWh / 100 km,{0} kWh / 100 km,kilowatt-ordu 100 kilometroko,,{0} kilowatt-ordu 100 kilometroko,{0} kilowatt-ordu 100 kilometroko
        newton,newtona,,,{0} N,newtona,,,{0} N,newtonak,,{0} newton,{0} newton
        pound-force,libra indar,,,{0} lbf,libra indar,,,{0} lbf,libra indar,,{0} libra indar,{0} libra indar
        gigahertz,,,,,,,,,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,,,,,,,,,hertz,,{0} hertz,{0} hertz
        kilohertz,,,,,,,,,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,,,,,,,,,megahertz,,{0} megahertz,{0} megahertz
        dot,puntua,,{0} puntu,{0} puntu,puntuak,,{0} puntu,{0} puntu,puntuak,,{0} puntu,{0} puntu
        dot-per-centimeter,dpcm,,{0}dpcm,{0}dpcm,dpcm,,{0} dpcm,{0} dpcm,puntu zentimetroko,,{0} puntu zentimetroko,{0} puntu zentimetroko
        dot-per-inch,dpi,,{0}dpi,{0}dpi,dpi,,{0} dpi,{0} dpi,puntu hazbeteko,,{0} puntu hazbeteko,{0} puntu hazbeteko
        em,em,,{0}em,{0}em,,,,,em tipografikoa,,,{0} em
        megapixel,MP,,{0}MP,{0}MP,megapixel,,,{0} MP,megapixel,,{0} megapixel,{0} megapixel
        pixel,px,,{0}px,{0}px,pixel,,,{0} px,pixel,,{0} pixel,{0} pixel
        pixel-per-centimeter,px/cm,,{0} px/cm,{0} px/cm,px/cm,,{0} px/cm,{0} px/cm,pixel zentimetroko,,{0} pixel zentimetroko,{0} pixel zentimetroko
        pixel-per-inch,,,,,,,,,pixel hazbeteko,,{0} pixel hazbeteko,{0} pixel hazbeteko
        astronomical-unit,ua,,{0} ua,{0} ua,ua,,{0} ua,{0} ua,unitate astronomiko,,{0} unitate astronomiko,{0} unitate astronomiko
        centimeter,,,,,,,,,zentimetro,{0} zentimetro bakoitzeko,{0} zentimetro,{0} zentimetro
        decimeter,,,,,,,,,dezimetro,,{0} dezimetro,{0} dezimetro
        earth-radius,,,,,,,,,Lurraren erradio,,{0} Lurraren erradio,{0} Lurraren erradio
        fathom,fm,,{0} fm,{0} fm,fm,,{0} fm,{0} fm,besoa,,{0} beso,{0} beso
        foot,oin,{0}/ft,,{0} ft,oin,{0}/ft,,{0} ft,oin,{0} oin bakoitzeko,{0} oin,{0} oin
        furlong,furlong,,,{0} fur,furlong,,,{0} fur,fulong,,{0} furlong,{0} furlong
        inch,hazbete,{0}/in,,{0} in,hazbete,{0}/in,,{0} in,hazbete,{0} hazbete bakoitzeko,{0} hazbete,{0} hazbete
        kilometer,,,,,,,,,kilometro,{0} kilometro bakoitzeko,{0} kilometro,{0} kilometro
        light-year,argi-urte,,,{0} ly,argi-urte,,,{0} ly,argi-urte,,{0} argi-urte,{0} argi-urte
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,metro,{0} metro bakoitzeko,{0} metro,{0} metro
        micrometer,,,,,,,,,mikrometro,,{0} mikrometro,{0} mikrometro
        mile,milia,,,{0} mi,milia,,,{0} mi,milia,,{0} milia,{0} milia
        mile-scandinavian,milia eskandinaviar,,,{0} smi,milia eskandinaviar,,,{0} smi,milia eskandinaviarrak,,{0} milia eskandinaviar,{0} milia eskandinaviar
        millimeter,,,,,,,,,milimetro,,{0} milimetro,{0} milimetro
        nanometer,,,,,,,,,nanometro,,{0} nanometro,{0} nanometro
        nautical-mile,,,,,,,,,milia nautiko,,{0} milia nautiko,{0} milia nautiko
        parsec,,,,,,,,,parsec,,{0} parsec,{0} parsec
        picometer,,,,,,,,,pikometro,,{0} pikometro,{0} pikometro
        point,puntu,,,{0} pt,puntu,,,{0} pt,puntu,,{0} puntu tipografiko,{0} puntu tipografiko
        solar-radius,eguzki-erradio,,,{0} R☉,eguzki-erradio,,,{0} R☉,eguzki-erradio,,{0} eguzki-erradio,{0} eguzki-erradio
        yard,,,,,,,,,yarda,,{0} yarda,{0} yarda
        candela,,,,,,,,,kandela,,{0} kandela,{0} kandela
        lumen,,,,,,,,,lumena,,{0} lumen,{0} lumen
        lux,lux,,{0} lux,{0} lux,lux,,{0} lux,{0} lux,lux,,{0} lux,{0} lux
        solar-luminosity,,,,,eguzki-argitasun,,,{0} L☉,eguzki-argitasun,,{0} eguzki-argitasun,{0} eguzki-argitasun
        carat,kilate,,{0} kilate,{0} kilate,kilate,,{0} kilate,{0} kilate,kilateak,,{0} kilate,{0} kilate
        dalton,dalton,,,{0} Da,dalton,,,{0} Da,dalton,,{0} dalton,{0} dalton
        earth-mass,lur-masa,,{0} M⊕,{0} M⊕,lur-masa,,{0} lur-masa,{0} lur-masa,lur-masa,,{0} lur-masa,{0} lur-masa
        grain,alea,,{0} ale,{0} ale,alea,,{0} ale,{0} ale,alea,,{0} ale,{0} ale
        gram,gramo,{0}/g,,{0} g,g,{0}/g,,{0} g,gramoak,{0} gramo bakoitzeko,{0} gramo,{0} gramo
        kilogram,,,,,,,,,kilogramoak,{0} kilogramo bakoitzeko,{0} kilogramo,{0} kilogramo
        microgram,,,,,,,,,mikrogramoak,,{0} mikrogramo,{0} mikrogramo
        milligram,,,,,,,,,miligramoak,,{0} miligramo,{0} miligramo
        ounce,ontza,{0}/ontza,{0} oz,{0} oz,ontza,{0}/ontza,{0} ontza,{0} ontza,ontzak,{0} ontza bakoitzeko,{0} ontza,{0} ontza
        ounce-troy,troy ontza,,{0} oz t,{0} oz t,troy ontza,,{0} troy ontza,{0} troy ontza,troy ontzak,,{0} troy ontza,{0} troy ontza
        pound,,,,,,,,,librak,{0} libra bakoitzeko,{0} libra,{0} libra
        solar-mass,eguzki-masa,,{0} M☉,{0} M☉,eguzki-masa,,{0} eguzki-masa,{0} eguzki-masa,eguzki-masa,,{0} eguzki-masa,{0} eguzki-masa
        stone,,,,,,,,,stone-a,,{0} stone,{0} stone
        ton,AEBko tona,,{0}tn,{0}tn,AEBko tona,,{0} AEBko tona,{0} AEBko tona,AEBko tonak,,{0} AEBko tona,{0} AEBko tona
        tonne,,,,,,,,,tona metrikoak,,{0} tona metriko,{0} tona metriko
        gigawatt,,,,,,,,,gigawatt-ak,,{0} gigawatt,{0} gigawatt
        horsepower,,,,,,,,,zaldi-potentzia,,{0} zaldi-potentzia,{0} zaldi-potentzia
        kilowatt,,,,,,,,,kilowatt-ak,,{0} kilowatt,{0} kilowatt
        megawatt,,,,,,,,,megawatt-ak,,{0} megawatt,{0} megawatt
        milliwatt,,,,,,,,,miliwatt-ak,,{0} miliwatt,{0} miliwatt
        watt,W,,,{0} W,W,,,{0} W,watt-ak,,{0} watt,{0} watt
        atmosphere,atmosfera,,{0} atm,{0} atm,atmosfera,,{0} atmosfera,{0} atmosfera,atmosfera,,{0} atmosfera,{0} atmosfera
        hectopascal,,,,,,,,,hektopascalak,,{0} hektopascal,{0} hektopascal
        inch-ofhg,,,,,,,,,merkurio-hazbeteak,,{0} merkurio-hazbete,{0} merkurio-hazbete
        kilopascal,,,,,,,,,kilopascal,,{0} kilopascal,{0} kilopascal
        megapascal,,,,,,,,,megapascal,,{0} megapascal,{0} megapascal
        millibar,mb,,{0} mb,{0} mb,mb,,{0} mb,{0} mb,milibarrak,,{0} milibar,{0} milibar
        millimeter-ofhg,,,,,,,,,merkurio-milimetroak,,{0} merkurio-milimetro,{0} merkurio-milimetro
        pascal,,,,,,,,,pascal,,{0} pascal,{0} pascal
        pound-force-per-square-inch,,,,,,,,,libra hazbete karratuko,,{0} libra hazbete karratuko,{0} libra hazbete karratuko
        beaufort,BFT,,B{0},B{0},BFT,,,B {0},Beaufort,,,B {0}
        kilometer-per-hour,,,,,,,,,kilometro orduko,,{0} kilometro orduko,{0} kilometro orduko
        knot,korapilo,,{0}kn,{0}kn,korapilo,,{0} korapilo,{0} korapilo,korapilo,,{0} korapilo,{0} korapilo
        light-speed,argia,,{0} a.,{0} a.,argia,,{0} argi,{0} argi,argia,,{0} argi,{0} argi
        meter-per-second,metro segundoko,,,{0} m/s,metro segundoko,,,{0} m/s,metro segundoko,,{0} metro segundoko,{0} metro segundoko
        mile-per-hour,mi/h,,{0} mph,{0} mph,mi/h,,{0} mph,{0} mph,milia orduko,,{0} milia orduko,{0} milia orduko
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,Celsius graduak,,{0} Celsius gradu,{0} Celsius gradu
        fahrenheit,°F,,{0}°F,{0}°F,°F,,{0} °F,{0} °F,Fahrenheit graduak,,{0} Fahrenheit gradu,{0} Fahrenheit gradu
        generic,°,,{0} °,{0} °,°,,{0} °,{0} °,°,,{0} °,{0} °
        kelvin,,,,,,,,,kelvin graduak,,{0} kelvin gradu,{0} kelvin gradu
        newton-meter,N m,,{0} N m,{0} N m,N⋅m,,{0} N m,{0} N m,newton-metro,,{0} newton-metro,{0} newton-metro
        pound-force-foot,oin-libra,,{0} lbf⋅ft,{0} lbf⋅ft,oin-libra,,{0} oin-libra,{0} oin-libra,oin-librak,,{0} oin-libra,{0} oin-libra
        acre-foot,akre-oin,,{0}ac ft,{0}ac ft,akre-oin,,{0} akre-oin,{0} akre-oin,akre-oin,,{0} akre-oin,{0} akre-oin
        barrel,upel,,{0} upel,{0} upel,upel,,{0} upel,{0} upel,upel,,{0} upel,{0} upel
        bushel,bushelak,,,{0} bu,bushelak,,,{0} bu,bushelak,,{0} bushel,{0} bushel
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,zentilitro,,{0} zentilitro,{0} zentilitro
        cubic-centimeter,,,,,,,,,zentimetro kubiko,{0} zentimetro kubiko bakoitzeko,{0} zentimetro kubiko,{0} zentimetro kubiko
        cubic-foot,,,,,,,,,oin kubiko,,{0} oin kubiko,{0} oin kubiko
        cubic-inch,,,,,,,,,hazbete kubiko,,{0} hazbete kubiko,{0} hazbete kubiko
        cubic-kilometer,,,,,,,,,kilometro kubiko,,{0} kilometro kubiko,{0} kilometro kubiko
        cubic-meter,,,,,,,,,metro kubiko,{0} metro kubiko bakoitzeko,{0} metro kubiko,{0} metro kubiko
        cubic-mile,,,,,,,,,milia kubiko,,{0} milia kubiko,{0} milia kubiko
        cubic-yard,,,,,,,,,yarda kubiko,,{0} yarda kubiko,{0} yarda kubiko
        cup,katilukada,,{0}c,{0}c,katilukada,,{0} katilukada,{0} katilukada,katilukada,,{0} katilukada,{0} katilukada
        cup-metric,katilukada metriko,,{0}mc,{0}mc,katilukada metriko,,{0} katilukada metriko,{0} katilukada metriko,katilu metrikoak,,{0} katilukada metriko,{0} katilukada metriko
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,dezilitro,,{0} dezilitro,{0} dezilitro
        dessert-spoon,postre-koilar.,,{0}dsp,{0}dsp,postre-koilar.,,{0} postre-koilar.,{0} postre-koilar.,postre-koilarakadak,,{0} postre-koilarakada,{0} postre-koilarakada
        dessert-spoon-imperial,postre-koilar. inp.,,{0}dsp-Imp,{0}dsp-Imp,postre-koilar. inp.,,{0} postre-koilar. inp.,{0} postre-koilar. inp.,Postre-koilarakada inperialak,,{0} postre-koilarakada inperial,{0} postre-koilarakada inperial
        dram,dram fluidoa,,,{0} dram fl,dram fluidoa,,,{0} dram fl,dram fluidoak,,{0} dram fluido,{0} dram fluido
        drop,tanta,,{0} tanta,{0} tanta,tanta,,{0} tanta,{0} tanta,tantak,,{0} tanta,{0} tanta
        fluid-ounce,likido-ontza,,{0}fl oz,{0}fl oz,likido-ontza,,{0} likido-ontza,{0} likido-ontza,ontza likido,,{0} likido-ontza,{0} likido-ontza
        fluid-ounce-imperial,likido-ontza inperial,,{0}fl oz Im,{0}fl oz Im,likido-ontza inperial,,{0} likido-ontza inperial,{0} likido-ontza inperial,likido-ontza inperial,,{0} likido-ontza inperial,{0} likido-ontza inperial
        gallon,galoi,{0}/galoi estatubatuar,{0} galoi,{0} galoi,galoi,{0}/galoi estatubatuar,{0} galoi,{0} galoi,galoi,{0} galoi bakoitzeko,{0} galoi,{0} galoi
        gallon-imperial,gal brit.,{0}/gal brit.,{0} gal brit.,{0} gal brit.,gal brit.,{0}/gal brit.,{0} gal brit.,{0} gal brit.,galoi brit.,{0} galoi brit. bakoitzeko,{0} galoi brit.,{0} galoi brit.
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hektolitro,,{0} hektolitro,{0} hektolitro
        jigger,txupitoa,,{0} txupito,{0} txupito,txupitoa,,{0} txupito,{0} txupito,txupitoak,,{0} txupito,{0} txupito
        liter,litro,{0}/l,,{0} l,l,{0}/l,,{0} l,litro,{0} litro bakoitzeko,{0} litro,{0} litro
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megalitro,,{0} megalitro,{0} megalitro
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,mililitro,,{0} mililitro,{0} mililitro
        pinch,pinch-a,,,{0} pinch,pinch-a,,,{0} pinch,pinch-ak,,,{0} pinch
        pint,pinta,,{0} pinta,{0} pinta,pinta,,{0} pinta,{0} pinta,pinta,,{0} pinta,{0} pinta
        pint-metric,pinta metriko,,{0}mpt,{0}mpt,pinta metriko,,{0} pinta metriko,{0} pinta metriko,pinta metrikoak,,{0} pinta metriko,{0} pinta metriko
        quart,galoi-laurden,,{0}qt,{0}qt,galoi-laurden,,{0} galoi-laurden,{0} galoi-laurden,galoi-laurden,,{0} galoi-laurden,{0} galoi-laurden
        quart-imperial,,,,,,,,,laurden inperialak,,{0} laurden inperial,{0} laurden inperial
        tablespoon,koilarakada,,{0}tbsp,{0}tbsp,koilarakada,,{0} koilarakada,{0} koilarakada,koilarakada,,{0} koilarakada,{0} koilarakada
        teaspoon,koilaratxokada,,{0}tsp,{0}tsp,koilaratxokada,,{0} koilaratxokada,{0} koilaratxokada,koilaratxokada,,{0} koilaratxokada,{0} koilaratxokada
        """.trimIndent()
  }

  private val eu_Prefixes: String by lazy {
    """square,,,{0} karratu
        cubic,,,{0} kubiko
        times,{0}-{1},{0}-{1},{0}-{1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobe{0}
        10p-1,,,dezi{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,zenti{0}
        10p-21,,,zepto{0}
        10p-24,,,jokto{0}
        10p-27,,,ronto{0}
        10p-3,,,mili{0}
        10p-30,,,kekto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hekto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val ewo_Units: String? = null

  private val ewo_Prefixes: String? = null

  private val fa_Units: String by lazy {
    """g-force,گرانش,,{0}G,{0}Gs,گرانش,,,{0} G,گرانش,,{0} جی,{0} جی
        meter-per-square-second,m/s²,,{0}‎ m/s²,{0}‎ m/s²,متر/مجذور ثانیه,,{0}‎ m/s²,{0}‎ m/s²,متر بر مجذور ثانیه,,{0} متر بر مجذور ثانیه,{0} متر بر مجذور ثانیه
        arc-minute,دقیقهٔ قوسی,,{0}′,{0}′,دقیقهٔ قوسی,,{0} د.قوسی,{0} د.قوسی,دقیقهٔ قوسی,,{0} دقیقهٔ قوسی,{0} دقیقهٔ قوسی
        arc-second,ثانیهٔ قوسی,,{0}″,{0}″,ثانیهٔ قوسی,,{0} ث.قوسی,{0} ث.قوسی,ثانیهٔ قوسی,,{0} ثانیهٔ قوسی,{0} ثانیهٔ قوسی
        degree,درجه,,{0}°,{0}°,درجه,,{0} درجه,{0} درجه,درجه,,{0} درجه,{0} درجه
        radian,رادیان,,{0} رادیان,{0} رادیان,رادیان,,{0} رادیان,{0} رادیان,رادیان,,{0} رادیان,{0} رادیان
        revolution,دور,,{0} دور,{0} دور,دور,,{0} دور,{0} دور,دور,,{0} دور,{0} دور
        acre,جریب,,{0}ac,{0}ac,جریب,,{0} جریب,{0} جریب,جریب,,{0} جریب,{0} جریب
        dunam,دونوم,,{0}دونوم,{0}دونوم,دونوم,,{0} دونوم,{0} دونوم,دونوم,,{0} دونوم,{0} دونوم
        hectare,هکتار,,{0}ha,{0}ha,هکتار,,{0} هکتار,{0} هکتار,هکتار,,{0} هکتار,{0} هکتار
        square-centimeter,cm²,{0}‎/cm²,{0}‎ cm²,{0}‎ cm²,cm²,{0}‎/cm²,{0}‎ cm²,{0}‎ cm²,سانتی‌متر مربع,{0} در سانتی‌متر مربع,{0} سانتی‌متر مربع,{0} سانتی‌متر مربع
        square-foot,ft²,,{0}ft²,{0}ft²,فوت مربع,,{0} فوت مربع,{0} فوت مربع,فوت مربع,,{0} فوت مربع,{0} فوت مربع
        square-inch,in²,{0}/in²,{0}in²,{0}in²,اینچ مربع,{0}/اینچ مربع,{0} اینچ مربع,{0} اینچ مربع,اینچ مربع,{0} در اینچ مربع,{0} اینچ مربع,{0} اینچ مربع
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,کیلومتر مربع,{0}/km²,{0}‎ km²,{0}‎ km²,کیلومتر مربع,{0} در کیلومتر مربع,{0} کیلومتر مربع,{0} کیلومتر مربع
        square-meter,متر مربع,{0}‎/m²,{0}m²,{0}m²,متر مربع,{0}‎/m²,,{0} m²,متر مربع,{0} در متر مربع,{0} متر مربع,{0} متر مربع
        square-mile,mi²,{0}‎/mi²,{0} mi²,{0} mi²,مایل مربع,{0}‎/mi²,{0} مایل مربع,{0} مایل مربع,مایل مربع,{0} در مایل مربع,{0} مایل مربع,{0} مایل مربع
        square-yard,yd²,,{0}yd²,{0}yd²,یارد مربع,,{0} یارد مربع,{0} یارد مربع,یارد مربع,,{0} یارد مربع,{0} یارد مربع
        item,مورد,,{0}مورد,{0}مورد,مورد,,{0} مورد,{0} مورد,مورد,,{0} مورد,{0} مورد
        karat,عیار,,{0} عیار,{0} عیار,عیار,,{0} عیار,{0} عیار,عیار,,{0} عیار,{0} عیار
        milligram-ofglucose-per-deciliter,میلی‌گرم در دسی‌لیتر,,,{0} mg/dL,میلی‌گرم در دسی‌لیتر,,,{0} mg/dL,میلی‌گرم در دسی‌لیتر,,{0} میلی‌گرم در دسی‌لیتر,{0} میلی‌گرم در دسی‌لیتر
        millimole-per-liter,میلی‌مول/لیتر,,,{0} mmol/L,میلی‌مول/لیتر,,,{0} mmol/L,میلی‌مول در لیتر,,{0} میلی‌مول در لیتر,{0} میلی‌مول در لیتر
        mole,مول,,{0} مول,{0} مول,مول,,{0} مول,{0} مول,مول,,{0} مول,{0} مول
        percent,٪,,{0}٪,{0}٪,درصد,,{0}٪,{0}٪,درصد,,{0} درصد,{0} درصد
        permille,هزارم,,,{0}‰,هزارم,,,{0}‰,هزارم,,{0} هزارم,{0} هزارم
        permillion,بخش/میلیون,,{0}ppm,{0}ppm,بخش/میلیون,,,{0} ppm,بخش در میلیون,,{0} بخش در میلیون,{0} بخش در میلیون
        permyriad,ده‌هزارم,,,{0}‱,ده‌هزارم,,,{0}‱,ده‌هزارم,,{0} ده‌هزارم,{0} ده‌هزارم
        portion-per-1e9,بخش در بیلیون,,,{0} ppb,بخش در بیلیون,,,{0} ppb,بخش در بیلیون,,{0} بخش در بیلیون,{0} بخش در بیلیون
        liter-per-100-kilometer,لیتر/۱۰۰ کیلومتر,,{0} ل./۱۰۰ ک.م.,{0} ل./۱۰۰ ک.م.,لیتر/۱۰۰ کیلومتر,,{0} ل./۱۰۰ ک.م.,{0} ل./۱۰۰ ک.م.,لیتر در ۱۰۰ کیلومتر,,{0} لیتر در ۱۰۰ کیلومتر,{0} لیتر در ۱۰۰ کیلومتر
        liter-per-kilometer,لیتر/کیلومتر,,{0} ل./ک.م.,{0} ل./ک.م.,لیتر/کیلومتر,,{0} ل./ک.م.,{0} ل./ک.م.,لیتر در کیلومتر,,{0} لیتر در کیلومتر,{0} لیتر در کیلومتر
        mile-per-gallon,مایل/گالن,,{0} مایل در گالن,{0} مایل در گالن,مایل/گالن,,{0} مایل در گالن,{0} مایل در گالن,مایل در گالن,,{0} مایل در گالن,{0} مایل در گالن
        mile-per-gallon-imperial,مایل/امپریال گالن,,{0}m/gUK,{0}m/gUK,مایل/امپریال گالن,,,{0} mpg Imp.,مایل در امپریال گالن,,{0} مایل در امپریال گالن,{0} مایل در امپریال گالن
        bit,بیت,,{0} بیت,{0} بیت,بیت,,{0} بیت,{0} بیت,بیت,,{0} بیت,{0} بیت
        byte,بایت,,{0} بایت,{0} بایت,بایت,,{0} بایت,{0} بایت,بایت,,{0} بایت,{0} بایت
        gigabit,گیگابیت,,{0}Gb,{0}Gb,گیگابیت,,,{0} Gb,گیگابیت,,{0} گیگابیت,{0} گیگابیت
        gigabyte,GB,,{0}GB,{0}GB,,,,,گیگابایت,,{0} گیگابایت,{0} گیگابایت
        kilobit,کیلوبیت,,{0}kb,{0}kb,کیلوبیت,,,{0} kb,کیلوبیت,,{0} کیلوبیت,{0} کیلوبیت
        kilobyte,کیلوبایت,,{0}kB,{0}kB,کیلوبایت,,,{0} kB,کیلوبایت,,{0} کیلوبایت,{0} کیلوبایت
        megabit,مگابیت,,{0}Mb,{0}Mb,مگابیت,,,{0} Mb,مگابیت,,{0} مگابیت,{0} مگابیت
        megabyte,MB,,{0}MB,{0}MB,,,,,مگابایت,,{0} مگابایت,{0} مگابایت
        petabyte,پتابایت,,{0}PB,{0}PB,پتابایت,,,{0} PB,پتابایت,,{0} پتابایت,{0} پتابایت
        terabit,ترابیت,,{0}Tb,{0}Tb,ترابیت,,,{0} Tb,ترابیت,,{0} ترابیت,{0} ترابیت
        terabyte,ترابایت,,{0}TB,{0}TB,ترابایت,,,{0} TB,ترابایت,,{0} ترابایت,{0} ترابایت
        century,سده,,{0} سده,{0} سده,سده,,{0} سده,{0} سده,سده,,{0} سده,{0} سده
        day,روز,{0}/روز,{0} روز,{0} روز,روز,{0}/روز,{0} روز,{0} روز,روز,{0} در روز,{0} روز,{0} روز
        decade,دهه,,{0} دهه,{0} دهه,دهه,,{0} دهه,{0} دهه,دهه,,{0} دهه,{0} دهه
        hour,ساعت,{0}/ساعت,{0}h,{0}h,ساعت,{0} در ساعت,{0} ساعت,{0} ساعت,ساعت,{0} در ساعت,{0} ساعت,{0} ساعت
        microsecond,میکروثانیه,,{0}μs,{0}μs,میکروثانیه,,{0}μs,{0}μs,میکروثانیه,,{0} میکروثانیه,{0} میکروثانیه
        millisecond,میلی‌ثانیه,,{0}ms,{0}ms,میلی‌ثانیه,,{0} میلی‌ثانیه,{0} میلی‌ثانیه,میلی‌ثانیه,,{0} میلی‌ثانیه,{0} میلی‌ثانیه
        minute,دقیقه,{0}/دقیقه,{0}m,{0}m,دقیقه,{0} در دقیقه,{0} دقیقه,{0} دقیقه,دقیقه,{0} در دقیقه,{0} دقیقه,{0} دقیقه
        month,ماه,{0}/ماه,{0} ماه,{0} ماه,ماه,{0}/ماه,{0} ماه,{0} ماه,ماه,{0} در ماه,{0} ماه,{0} ماه
        nanosecond,نانوثانیه,,{0}ns,{0}ns,نانوثانیه,,{0} نانوثانیه,{0} نانوثانیه,نانوثانیه,,{0} نانوثانیه,{0} نانوثانیه
        night,شب,{0}/شب,{0} شب,{0} شب,شب,{0}/شب,{0} شب,{0} شب,شب,{0} در شب,{0} شب,{0} شب
        quarter,سه‌ماه,{0}/سه‌ماه,{0}سه‌ماه,{0}سه‌ماه,سه‌ماه,{0}/سه‌ماه,{0} سه‌ماه,{0}سه‌ماه,سه‌ماه,{0} در سه‌ماه,{0} سه‌ماهه,{0} سه‌ماهه
        second,ثانیه,{0}/ثانیه,{0}s,{0}s,ثانیه,{0} در ثانیه,{0} ثانیه,{0} ثانیه,ثانیه,{0} در ثانیه,{0} ثانیه,{0} ثانیه
        week,هفته,{0}/هفته,{0} هفته,{0} هفته,هفته,{0}/هفته,{0} هفته,{0} هفته,هفته,{0} در هفته,{0} هفته,{0} هفته
        year,سال,{0}/سال,{0} سال,{0} سال,سال,{0}/سال,{0} سال,{0} سال,سال,{0} در سال,{0} سال,{0} سال
        ampere,amp,,{0}A,{0}A,آمپر,,{0} آمپر,{0} آمپر,آمپر,,{0} آمپر,{0} آمپر
        milliampere,mA,,{0}mA,{0}mA,میلی‌آمپر,,{0} میلی‌آمپر,{0} میلی‌آمپر,میلی‌آمپر,,{0} میلی‌آمپر,{0} میلی‌آمپر
        ohm,اهم,,{0}Ω,{0}Ω,اهم,,{0} اهم,{0} اهم,اهم,,{0} اهم,{0} اهم
        volt,ولت,,{0}V,{0}V,ولت,,{0} ولت,{0} ولت,ولت,,{0} ولت,{0} ولت
        british-thermal-unit,BTU,,{0}Btu,{0}Btu,بی‌تی‌یو,,{0} بی‌تی‌یو,{0} بی‌تی‌یو,بی‌تی‌یو,,{0} بی‌تی‌یو,{0} بی‌تی‌یو
        calorie,cal,,{0}cal,{0}cal,کالری,,{0} کالری,{0} کالری,کالری,,{0} کالری,{0} کالری
        electronvolt,eV,,{0}eV,{0}eV,الکترون‌ولت,,,{0} eV,الکترون ولت,,{0} الکترون‌ولت,{0} الکترون‌ولت
        foodcalorie,Cal,,{0}Cal,{0}Cal,کالری,,{0} کالری,{0} کالری,کالری,,{0} کالری,{0} کالری
        joule,ژول,,{0}J,{0}J,ژول,,{0} ژول,{0} ژول,ژول,,{0} ژول,{0} ژول
        kilocalorie,ک.کالری,,{0} ک.کالری,{0} ک.کالری,ک.کالری,,{0} ک.کالری,{0} ک.کالری,کیلوکالری,,{0} کیلوکالری,{0} کیلوکالری
        kilojoule,kJ,,{0}kJ,{0}kJ,ک.ژول,,{0} ک.ژول,{0} ک.ژول,کیلوژول,,{0} کیلوژول,{0} کیلوژول
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,ک.وات‌ساعت,,{0} ک.و.ساعت,{0} ک.و.ساعت,کیلووات‌ساعت,,{0} کیلووات‌ساعت,{0} کیلووات‌ساعت
        therm-us,ترم آمریکایی,,{0} ترم آمریکایی,{0} ترم آمریکایی,ترم آمریکایی,,{0} ترم آمریکایی,{0} ترم آمریکایی,ترم آمریکایی,,{0} ترم آمریکایی,{0} ترم آمریکایی
        kilowatt-hour-per-100-kilometer,ک.وا.س/۱۰۰ ک.م,,{0}ک.وا.س/۱۰۰ ک.م,{0} ک.وا.س/۱۰۰ ک.م,ک.وا.س/۱۰۰ ک.م,,{0} ک.وا.س/۱۰۰ ک.م,{0} ک.وا.س/۱۰۰ ک.م,کیلووات-ساعت در ۱۰۰ کیلومتر,,{0} کیلووات-ساعت در ۱۰۰ کیلومتر,{0} کیلووات-ساعت در ۱۰۰ کیلومتر
        newton,نیوتن,,{0} نیوتن,{0} نیوتن,نیوتن,,{0} نیوتن,{0} نیوتن,نیوتن,,{0} نیوتن,{0} نیوتن
        pound-force,پوند-نیرو,,{0} پوند-نیرو,{0} پوند-نیرو,پوند-نیرو,,{0} پوند-نیرو,{0} پوند-نیرو,پوند-نیرو,,{0} پوند-نیرو,{0} پوند-نیرو
        gigahertz,GHz,,{0}GHz,{0}GHz,گیگاهرتز,,{0} گیگاهرتز,{0} گیگاهرتز,گیگاهرتز,,{0} گیگاهرتز,{0} گیگاهرتز
        hertz,Hz,,{0}Hz,{0}Hz,هرتز,,{0} هرتز,{0} هرتز,هرتز,,{0} هرتز,{0} هرتز
        kilohertz,kHz,,{0}kHz,{0}kHz,ک.هرتز,,{0} ک.هرتز,{0} ک.هرتز,کیلوهرتز,,{0} کیلوهرتز,{0} کیلوهرتز
        megahertz,MHz,,{0}MHz,{0}MHz,مگاهرتز,,{0} مگاهرتز,{0} مگاهرتز,مگاهرتز,,{0} مگاهرتز,{0} مگاهرتز
        dot,نقطه,,{0}dot,{0}dot,نقطه,,{0} نقطه,{0} نقطه,نقطه,,{0}نقطه,{0}نقطه
        dot-per-centimeter,dpcm,,{0} dpcm,{0} dpcm,dpcm,,{0} dpcm,{0} dpcm,نقطه در سانتی‌متر,,{0} نقطه در سانتی‌متر,{0} نقطه در سانتی‌متر
        dot-per-inch,dpi,,{0}dpi,{0}dpi,dpi,,{0} dpi,{0} dpi,نقطه در اینچ,,{0} نقطه در اینچ,{0} نقطه در اینچ
        em,,,,,,,,,em تایپوگرافی,,,{0} em
        megapixel,مگاپیکسل,,{0}MP,{0}MP,مگاپیکسل,,,{0} MP,مگاپیکسل,,{0} مگاپیکسل,{0} مگاپیکسل
        pixel,پیکسل,,{0}px,{0}px,پیکسل,,,{0} px,پیکسل,,{0} پیکسل,{0} پیکسل
        pixel-per-centimeter,ppcm,,{0}ppcm,{0}ppcm,,,,,پیکسل در سانتی‌متر,,{0} پیکسل در سانتی‌متر,{0} پیکسل در سانتی‌متر
        pixel-per-inch,,,,,,,,,پیکسل در اینچ,,{0} پیکسل در اینچ,{0} پیکسل در اینچ
        astronomical-unit,au,,{0}au,{0}au,au,,{0} واحد نجومی,{0} واحد نجومی,واحد نجومی,,{0} واحد نجومی,{0} واحد نجومی
        centimeter,cm,{0}/cm,{0}cm,{0}cm,سانتی‌متر,{0}/سانتی‌متر,{0} سانتی‌متر,{0} سانتی‌متر,سانتی‌متر,{0} در سانتی‌متر,{0} سانتی‌متر,{0} سانتی‌متر
        decimeter,dm,,{0}dm,{0}dm,دسی‌متر,,{0} دسی‌متر,{0} دسی‌متر,دسی‌متر,,{0} دسی‌متر,{0} دسی‌متر
        earth-radius,,,,,,,,,شعاع زمین,,{0} شعاع زمین,{0} شعاع زمین
        fathom,فاتوم,,{0}fth,{0}fth,فاتوم,,{0} فاتوم,{0} فاتوم,فاتوم,,{0} فاتوم,{0} فاتوم
        foot,ft,{0}/ft,{0}ft,{0}ft,فوت,{0}/فوت,{0} فوت,{0} فوت,فوت,{0} در فوت,{0} فوت,{0} فوت
        furlong,فرلانگ,,{0}fur,{0}fur,فرلانگ,,{0} فرلانگ,{0} فرلانگ,فرلانگ,,{0} فرلانگ,{0} فرلانگ
        inch,in,{0}/اینچ,{0}in,{0}in,اینچ,{0}/اینچ,{0} اینچ,{0} اینچ,اینچ,{0} در اینچ,{0} اینچ,{0} اینچ
        kilometer,km,{0}‎/km,{0}km,{0}km,کیلومتر,{0}/کیلومتر,{0} کیلومتر,{0} کیلومتر,کیلومتر,{0} در کیلومتر,{0} کیلومتر,{0} کیلومتر
        light-year,ly,,{0}ly,{0}ly,سال نوری,,{0} سال نوری,{0} سال نوری,سال نوری,,{0} سال نوری,{0} سال نوری
        meter,m,{0}‎/m,{0}m,{0}m,متر,{0}/متر,{0}متر,{0}متر,متر,{0} در متر,{0} متر,{0} متر
        micrometer,μm,,{0}μm,{0}μm,میکرومتر,,{0} میکرومتر,{0} میکرومتر,میکرومتر,,{0} میکرومتر,{0} میکرومتر
        mile,mi,,{0}mi,{0}mi,مایل,,{0} مایل,{0} مایل,مایل,,{0} مایل,{0} مایل
        mile-scandinavian,smi,,{0}‎ smi,{0}‎ smi,مایل اسکاندیناوی,,{0}‎ smi,{0}‎ smi,مایل اسکاندیناوی,,{0} مایل اسکاندیناوی,{0} مایل اسکاندیناوی
        millimeter,mm,,{0}mm,{0}mm,میلی‌متر,,{0} میلی‌متر,{0} میلی‌متر,میلی‌متر,,{0} میلی‌متر,{0} میلی‌متر
        nanometer,nm,,{0}nm,{0}nm,نانومتر,,{0} نانومتر,{0} نانومتر,نانومتر,,{0} نانومتر,{0} نانومتر
        nautical-mile,nmi,,{0}nmi,{0}nmi,مایل دریایی,,{0} مایل دریایی,{0} مایل دریایی,مایل دریایی,,{0} مایل دریایی,{0} مایل دریایی
        parsec,پارسک,,{0}pc,{0}pc,پارسک,,{0} پارسک,{0} پارسک,پارسک,,{0} پارسک,{0} پارسک
        picometer,pm,,{0}pm,{0}pm,پیکومتر,,{0} پیکومتر,{0} پیکومتر,پیکومتر,,{0} پیکومتر,{0} پیکومتر
        point,pts,,{0}pt,{0}pt,پوینت,,{0} پوینت,{0} پوینت,پوینت,,{0} پوینت,{0} پوینت
        solar-radius,R☉,,{0}R☉,{0}R☉,شعاع خورشید,,{0} شعاع خورشید,{0} شعاع خورشید,شعاع خورشید,,{0} شعاع خورشید,{0} شعاع خورشید
        yard,yd,,{0}yd,{0}yd,یارد,,{0} یارد,{0} یارد,یارد,,{0} یارد,{0} یارد
        candela,,,,,,,,,شمع,,{0} شمع,{0} شمع
        lumen,,,,,,,,,لومن,,{0} لومن,{0} لومن
        lux,لوکس,,{0} لوکس,{0} لوکس,لوکس,,{0} لوکس,{0} لوکس,لوکس,,{0} لوکس,{0} لوکس
        solar-luminosity,تابندگی خورشید,,{0} ☉L,{0} ☉L,تابندگی خورشید,,{0} ☉L,{0} ☉L,تابندگی خورشید,,{0} تابندگی خورشید,{0} تابندگی خورشید
        carat,قیراط,,{0}CD,{0}CD,قیراط,,{0} قیراط,{0} قیراط,قیراط,,{0} قیراط,{0} قیراط
        dalton,Da,,{0}Da,{0}Da,دالتون,,{0} دالتون,{0} دالتون,دالتون,,{0} دالتون,{0} دالتون
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,جرم زمین,,{0} M⊕,{0} ⊕M,جرم زمین,,{0} جرم زمین,{0} جرم زمین
        grain,gr,,{0}gr,{0}gr,دانه,,{0} دانه,{0} دانه,دانه,,{0} دانه,{0} دانه
        gram,گرم,{0}/g,{0}g,{0}g,گرم,{0}/g,{0} گرم,{0} گرم,گرم,{0}/g,{0} گرم,{0} گرم
        kilogram,kg,{0}‎/kg,{0}kg,{0}kg,کیلوگرم,{0}‎/kg,{0} کیلوگرم,{0} کیلوگرم,کیلوگرم,{0} در کیلوگرم,{0} کیلوگرم,{0} کیلوگرم
        microgram,میکروگرم,,{0}μg,{0}μg,میکروگرم,,{0} میکروگرم,{0} میکروگرم,میکروگرم,,{0} میکروگرم,{0} میکروگرم
        milligram,mg,,{0}mg,{0}mg,mg,,{0} میلی‌گرم,{0} میلی‌گرم,میلی‌گرم,,{0} میلی‌گرم,{0} میلی‌گرم
        ounce,oz,{0}/oz,{0}oz,{0}oz,اونس,{0} در اونس,{0} اونس,{0} اونس,اونس,{0} در اونس,{0} اونس,{0} اونس
        ounce-troy,oz t,,{0}oz t,{0}oz t,اونس تروا,,{0} اونس تروا,{0} اونس تروا,اونس تروا,,{0} اونس تروا,{0} اونس تروا
        pound,lb,{0} در پوند,{0}lb,{0}lb,lb,{0} در پوند,{0} پوند,{0} پوند,lb,{0} در پوند,{0} پوند,{0} پوند
        solar-mass,M☉,,{0}M☉,{0}M☉,جرم خورشید,,{0} ☉M,{0} ☉M,جرم خورشید,,{0} جرم خورشید,{0} جرم خورشید
        stone,سنگ,,{0}st,{0}st,سنگ,,{0} سنگ,{0} سنگ,سنگ,,{0} سنگ,{0} سنگ
        ton,تن,,{0}tn,{0}tn,تن,,{0} تن,{0} تن,تن,,{0} تن,{0} تن
        tonne,تُن,,{0}t,{0}t,تُن,,{0} تُن,{0} تُن,تن متریک,,{0} تن متریک,{0} تن متریک
        gigawatt,GW,,{0}GW,{0}GW,گیگاوات,,{0} گیگاوات,{0} گیگاوات,گیگاوات,,{0} گیگاوات,{0} گیگاوات
        horsepower,hp,,{0}hp,{0}hp,اسب بخار,,{0} اسب بخار,{0} اسب بخار,اسب بخار,,{0} اسب بخار,{0} اسب بخار
        kilowatt,ک.وات,,{0}kW,{0}kW,ک.وات,,{0} ک.وات,{0} ک.وات,کیلووات,,{0} کیلووات,{0} کیلووات
        megawatt,مگاوات,,{0} مگاوات,{0} مگاوات,مگاوات,,{0} مگاوات,{0} مگاوات,مگاوات,,{0} مگاوات,{0} مگاوات
        milliwatt,mW,,{0}mW,{0}mW,میلی‌وات,,{0} میلی‌وات,{0} میلی‌وات,میلی‌وات,,{0} میلی‌وات,{0} میلی‌وات
        watt,وات,,{0}W,{0}W,وات,,{0} وات,{0} وات,وات,,{0} وات,{0} وات
        atmosphere,اتمسفر,,{0}اتمسفر,{0}اتمسفر,اتمسفر,,{0} اتمسفر,{0} اتمسفر,اتمسفر,,{0} اتمسفر,{0} اتمسفر
        bar,بار,,{0} بار,{0} بار,بار,,{0} بار,{0} بار,بار,,{0} بار,{0} بار
        hectopascal,هکتوپاسکال,,{0}hPa,{0}hPa,هکتوپاسکال,,{0} هکتوپاسکال,{0} هکتوپاسکال,هکتوپاسکال,,{0} هکتوپاسکال,{0} هکتوپاسکال
        inch-ofhg,اینچ جیوه,,{0}inHg,{0}inHg,اینچ جیوه,,{0} اینچ جیوه,{0} اینچ جیوه,اینچ جیوه,,{0} اینچ جیوه,{0} اینچ جیوه
        kilopascal,ک.پاسکال,,{0} ک.پاسکال,{0} ک.پاسکال,ک.پاسکال,,{0} ک.پاسکال,{0} ک.پاسکال,کیلوپاسکال,,{0} کیلوپاسکال,{0} کیلوپاسکال
        megapascal,مگاپاسکال,,{0} مگاپاسکال,{0} مگاپاسکال,مگاپاسکال,,{0} مگاپاسکال,{0} مگاپاسکال,مگاپاسکال,,{0} مگاپاسکال,{0} مگاپاسکال
        millibar,میلی‌بار,,{0}mbar,{0}mbar,میلی‌بار,,{0} میلی‌بار,{0} میلی‌بار,میلی‌بار,,{0} میلی‌بار,{0} میلی‌بار
        millimeter-ofhg,میلی‌متر جیوه,,{0} م‌م جیوه,{0} م‌م جیوه,میلی‌متر جیوه,,{0} م‌م جیوه,{0} م‌م جیوه,میلی‌متر جیوه,,{0} میلی‌متر جیوه,{0} میلی‌متر جیوه
        pascal,پاسکال,,{0}Pa,{0}Pa,پاسکال,,{0} پاسکال,{0} پاسکال,پاسکال,,{0} پاسکال,{0} پاسکال
        pound-force-per-square-inch,پوند در اینچ مربع,,{0}‎ psi,{0}‎ psi,پوند در اینچ مربع,,{0}‎ psi,{0}‎ psi,پوند در اینچ مربع,,{0} پوند در اینچ مربع,{0} پوند در اینچ مربع
        beaufort,بوفورت,,B{0},{0}بوفورت,بوفورت,,{0} بوفورت,{0} بوفورت,بوفورت,,{0} بوفورت,{0} بوفورت
        kilometer-per-hour,km/hr,,{0}‎ km/h,{0}‎ km/h,کیلومتر در ساعت,,{0}‎ km/h,{0}‎ km/h,کیلومتر در ساعت,,{0} کیلومتر در ساعت,{0} کیلومتر در ساعت
        knot,kn,,{0}kn,{0}kn,گره,,{0} گره,{0} گره,گره,,{0} گره,{0} گره
        meter-per-second,m/s,,{0}m/s,{0}m/s,متر در ثانیه,,,{0} m/s,متر در ثانیه,,{0} متر در ثانیه,{0} متر در ثانیه
        mile-per-hour,mi/h,,{0}mph,{0}mph,مایل در ساعت,,{0}‎ mph,{0}‎ mph,مایل در ساعت,,{0} مایل در ساعت,{0} مایل در ساعت
        celsius,‎°C,,,{0}°C,درجهٔ سلسیوس,,,{0}°C,درجهٔ سلسیوس,,{0} درجهٔ سلسیوس,{0} درجهٔ سلسیوس
        fahrenheit,‎°F,,,{0}°F,درجهٔ فارنهایت,,,{0}°F,درجهٔ فارنهایت,,{0} درجهٔ فارنهایت,{0} درجهٔ فارنهایت
        kelvin,درجهٔ کلوین,,{0}K,{0}K,درجهٔ کلوین,,‎{0} K,‎{0} K,درجهٔ کلوین,,{0} درجهٔ کلوین,{0} درجهٔ کلوین
        newton-meter,نیوتن‌متر,,{0} نیوتن‌متر,{0} نیوتن‌متر,نیوتن‌متر,,{0} نیوتن‌متر,{0} نیوتن‌متر,نیوتن‌متر,,{0} نیوتن‌متر,{0} نیوتن‌متر
        pound-force-foot,پوند-فوت,,{0} پوند-فوت,{0} پوند-فوت,پوند-فوت,,{0} پوند-فوت,{0} پوند-فوت,پوند-فوت,,{0} پوند-فوت,{0} پوند-فوت
        acre-foot,جریب فوت,,{0}ac ft,{0}ac ft,جریب فوت,,{0} جریب فوت,{0} جریب فوت,جریب فوت,,{0} جریب فوت,{0} جریب فوت
        barrel,bbl,,{0}bbl,{0}bbl,بشکه,,{0} بشکه,{0} بشکه,بشکه,,{0} بشکه,{0} بشکه
        bushel,بوشل,,{0}bu,{0}bu,بوشل,,{0} بوشل,{0} بوشل,بوشل,,{0} بوشل,{0} بوشل
        centiliter,cL,,{0}cL,{0}cL,cL,,{0}cL,{0}cL,سانتی‌لیتر,,{0} سانتی‌لیتر,{0} سانتی‌لیتر
        cubic-centimeter,cm³,{0}‎ /cm³,{0}‎ cm³,{0}‎ cm³,cm³,{0}‎ /cm³,{0}‎ cm³,{0}‎ cm³,سانتی‌متر مکعب,{0} در سانتی‌متر مکعب,{0} سانتی‌متر مکعب,{0} سانتی‌متر مکعب
        cubic-foot,ft³,,{0}ft³,{0}ft³,فوت مکعب,,{0}ft³,{0}ft³,فوت مکعب,,{0} فوت مکعب,{0} فوت مکعب
        cubic-inch,in³,,{0}in³,{0}in³,اینچ مکعب,,{0}in³,{0}in³,اینچ مکعب,,{0} اینچ مکعب,{0} اینچ مکعب
        cubic-kilometer,کیلومتر مکعب,,{0}km³,{0}km³,کیلومتر مکعب,,{0}‎ km³,{0}‎ km³,کیلومتر مکعب,,{0} کیلومتر مکعب,{0} کیلومتر مکعب
        cubic-meter,m³,{0}‎/m³,{0}m³,{0}m³,متر مکعب,{0}‎/m³,{0}m³,{0}m³,متر مکعب,{0} در متر مکعب,{0} متر مکعب,{0} متر مکعب
        cubic-mile,mi³,,{0}mi³,{0}mi³,mi³,,{0}mi³,{0}mi³,مایل مکعب,,{0} مایل مکعب,{0} مایل مکعب
        cubic-yard,yd³,,{0}yd³,{0}yd³,یارد مکعب,,{0}yd³,{0}yd³,یارد مکعب,,{0} یارد مکعب,{0} یارد مکعب
        cup,پیمانه,,{0}c,{0}c,پیمانه,,{0} پیمانه,{0} پیمانه,پیمانه,,{0} پیمانه,{0} پیمانه
        cup-metric,پیمانهٔ متریک,,{0}mc,{0}mc,پیمانهٔ متریک,,{0} پیمانهٔ متریک,{0} پیمانهٔ متریک,پیمانهٔ متریک,,{0} پیمانهٔ متریک,{0} پیمانهٔ متریک
        deciliter,dL,,{0}dL,{0}dL,dL,,{0}dL,{0}dL,دسی‌لیتر,,{0} دسی‌لیتر,{0} دسی‌لیتر
        dessert-spoon,ق.دس.خ,,{0} ق.دس.خ.,{0} ق.دس.خ.,قاشق دسرخوری,,{0} ق.دس.خ.,{0} ق.دس.خ.,قاشق دسرخوری,,{0} قاشق دسرخوری,{0} قاشق دسرخوری
        dessert-spoon-imperial,قاشق دسرخوری انگلیسی,,{0} ق.دس. انگلیسی,{0} ق.دس. انگلیسی,قاشق دسرخوری انگلیسی,,{0} ق.دس. انگلیسی,{0} ق.دس. انگلیسی,قاشق دسرخوری انگلیسی,,{0} قاشق دسرخوری انگلیسی,{0} قاشق دسرخوری انگلیسی
        dram,fl.dr.,,{0}fl.dr.,{0}fl.dr.,درم سیال,,{0} درم سیال,{0} درم سیال,درم,,{0} درم,{0} درم
        drop,قطره,,{0} قطره,{0} قطره,قطره,,{0} قطره,{0} قطره,قطره,,{0} قطره,{0} قطره
        fluid-ounce,اونس سیال,,{0}fl oz,{0}fl oz,اونس سیال,,{0}‎ fl oz,{0}‎ fl oz,اونس سیال,,{0} اونس سیال,{0} اونس سیال
        fluid-ounce-imperial,Imp fl oz,,{0}fl oz Im,{0}fl oz Im,اونس سیال انگلیسی,,{0} fl oz Imp,{0} fl oz Imp,اونس سیال انگلیسی,,{0} اونس سیال انگلیسی,{0} اونس سیال انگلیسی
        gallon,گالن,{0} در گالن,{0} گالن,{0} گالن,گالن,{0} در گالن,{0} گالن,{0} گالن,گالن,{0} در گالن,{0} گالن,{0} گالن
        gallon-imperial,گالن امپریال,{0}/galIm,{0}galIm,{0}galIm,گالن امپریال,{0}/گالن امپریال,{0} گالن امپریال,{0} گالن امپریال,گالن امپریال,{0} در گالن امپریال,{0} گالن امپریال,{0} گالن امپریال
        hectoliter,hL,,{0}hL,{0}hL,hL,,{0}hL,{0}hL,هکتولیتر,,{0} هکتولیتر,{0} هکتولیتر
        jigger,گیلاس,,{0} گیلاس,{0} گیلاس,گیلاس,,{0} گیلاس,{0} گیلاس,گیلاس,,{0} گیلاس,{0} گیلاس
        liter,لیتر,{0}‎/L,{0}L,{0}L,لیتر,{0}‎/L,{0}L,{0}L,لیتر,{0} در لیتر,{0} لیتر,{0} لیتر
        megaliter,ML,,{0}ML,{0}ML,مگالیتر,,{0}ML,{0}ML,مگالیتر,,{0} مگالیتر,{0} مگالیتر
        milliliter,mL,,{0}mL,{0}mL,میلی‌لیتر,,{0} میلی‌لیتر,{0} میلی‌لیتر,میلی‌لیتر,,{0} میلی‌لیتر,{0} میلی‌لیتر
        pinch,سرانگشت,,{0} سرانگشت,{0} سرانگشت,سرانگشت,,{0} سرانگشت,{0} سرانگشت,سرانگشت,,{0} سرانگشت,{0} سرانگشت
        pint,pt,,{0}pt,{0}pt,پاینت,,{0} پاینت,{0} پاینت,پاینت,,{0} پاینت,{0} پاینت
        pint-metric,پاینت متریک,,{0}mpt,{0}mpt,پاینت متریک,,{0} پاینت متریک,{0} پاینت متریک,پاینت متریک,,{0} پاینت متریک,{0} پاینت متریک
        quart,qt,,{0}qt,{0}qt,کوارت,,{0} کوارت,{0} کوارت,کوارت,,{0} کوارت,{0} کوارت
        quart-imperial,qt Imp,,{0}qt-Imp.,{0}qt-Imp.,کوارت انگلیسی,,{0} کوارت انگلیسی,{0} کوارت انگلیسی,کوارت انگلیسی,,{0} کوارت انگلیسی,{0} کوارت انگلیسی
        tablespoon,قاشق غ.,,{0} ق.غ.خ,{0} ق.غ.خ,قاشق غ.,,{0} ق.غ.خ,{0} ق.غ.خ,قاشق غذاخوری,,{0} قاشق غذاخوری,{0} قاشق غذاخوری
        teaspoon,ق.چ.خ,,{0}ق.چ.,{0}ق.چ.,ق.چای‌خوری,,{0} ق.چ.,{0} ق.چ.,قاشق چای‌خوری,,{0} قاشق چای‌خوری,{0} قاشق چای‌خوری
        """.trimIndent()
  }

  private val fa_Prefixes: String by lazy {
    """square,,{0}مربع,{0}مربع
        cubic,,{0}مکعب,{0} مکعب
        times,,,{0}‌{1}
        per,,,{0} در {1}
        1024p1,,کیبی‌{0},کیبی‌{0}
        1024p2,,مبی‌{0},مبی‌{0}
        1024p3,,گیبی‌{0},گیبی‌{0}
        1024p4,,تبی‌{0},تبی‌{0}
        1024p5,,پبی‌{0},پبی‌{0}
        1024p6,,اگزبی‌{0},اگزبی‌{0}
        1024p7,,زبی‌{0},زبی‌{0}
        1024p8,,یوبی‌{0},یوبی‌{0}
        10p-1,,دسی‌{0},دسی‌{0}
        10p-12,,پیکو{0},پیکو{0}
        10p-15,,فمتو{0},فمتو{0}
        10p-18,,آتو{0},آتو{0}
        10p-2,,سانتی{0},سانتی‌{0}
        10p-21,,زپتو{0},زپتو{0}
        10p-24,,یوکتو{0},یوکتو{0}
        10p-27,,رونتو{0},رونتو{0}
        10p-3,,میلی{0},میلی‌{0}
        10p-30,,کوکتو{0},کوکتو{0}
        10p-6,,میکرو{0},میکرو{0}
        10p-9,,نانو{0},نانو{0}
        10p1,,دکا{0},دکا{0}
        10p12,,ترا{0},ترا{0}
        10p15,,پتا{0},پتا{0}
        10p18,,اگزا{0},اگزا{0}
        10p2,,هکتو{0},هکتو{0}
        10p21,,زتا{0},زتا{0}
        10p24,,یوتا{0},یوتا{0}
        10p27,,رونا{0},رونا{0}
        10p3,,کیلو{0},کیلو{0}
        10p30,,کتا{0},کتا{0}
        10p6,,مگا{0},مگا{0}
        10p9,,گیگا{0},گیگا{0}
        """.trimIndent()
  }

  private val fa_AF_Units: String? = null

  private val fa_AF_Prefixes: String? = null

  private val ff_Units: String? = null

  private val ff_Prefixes: String? = null

  private val ff_Adlm_Units: String by lazy {
    """g-force,𞤻-𞤷𞤫𞤥𞤦𞤫,,{0}𞤙,{0}𞤙,𞤻-𞤷𞤫𞤥𞤦𞤫,,{0} 𞤙,{0} 𞤙,𞤵𞥅𞤴𞤲𞤣𞤭 𞤻𞤭𞥅𞤧𞤵𞤳𞤭 𞤤𞤫𞤴𞤣𞤭 𞤲𞤣𞤭𞤲,,{0} 𞤲𞤣𞤫 𞤵𞥅𞤴𞤲𞤣𞤭 𞤻𞤭𞥅𞤧𞤵𞤳𞤭 𞤤𞤫𞤴𞤣𞤭 𞤲𞤣𞤭𞤲,{0} 𞤲𞤣𞤫 𞤵𞥅𞤴𞤲𞤣𞤭 𞤻𞤭𞥅𞤧𞤵𞤳𞤭 𞤤𞤫𞤴𞤣𞤭 𞤲𞤣𞤭𞤲
        meter-per-square-second,𞤥/𞤳𞥒,,{0}𞤥/𞤳𞥒,{0}𞤥/𞤳𞥒,𞤥𞤫𞥅𞤼𞤭/𞤳𞤭𞤲𞥒,,{0} 𞤥/𞤳𞥒,{0} 𞤥/𞤳𞥒,𞤥𞤫𞥅𞤼𞤭 𞤲𞤣𞤫𞤪 𞤳𞤭𞤲𞤰𞤫𞤪𞤫 𞤣𞤭𞤲𞤺𞤢𞥄𞤲𞤣𞤫,,{0} 𞤥𞤫𞥅𞤼𞤮𞤤 𞤲𞤣𞤫𞤪 𞤳𞤭𞤲𞤰𞤫𞤪𞤫 𞤣𞤭𞤲𞤺𞤢𞥄𞤲𞤣𞤫,{0} 𞤥𞤫𞥅𞤼𞤭 𞤲𞤣𞤫𞤪 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫 𞤣𞤭𞤲𞤺𞤢𞥄𞤲𞤣𞤫
        arc-minute,𞤸𞤮𞤶𞤤𞤢𞥄𞤻𞤢𞤤,,{0}𞥋,{0}𞥋,𞤸𞤮𞤶𞤤𞤢𞥄𞤻𞤫,,{0} 𞤸𞤮𞤶𞤤𞤢𞥄𞤻𞤢𞤤,{0} 𞤸𞤮𞤶𞤤𞤢𞥄𞤻𞤢𞤤,𞤸𞤮𞤶𞤮𞤥𞤢𞤤𞤢𞥄𞤻𞤫,,{0} 𞤸𞤮𞤶𞤮𞤥𞤢𞤤𞤢𞥄𞤻𞤢𞤤,{0} 𞤸𞤮𞤶𞤮𞤥𞤢𞤤𞤢𞥄𞤻𞤫
        arc-second,𞤳𞤭𞤲𞤤𞤢𞥄𞤻𞤢𞤤,,{0}'',{0}'',𞤳𞤭𞤲𞤤𞤢𞥄𞤻𞤫,,{0} 𞤳𞤭𞤲𞤤𞤢𞥄𞤻𞤢𞤤,{0} 𞤳𞤭𞤲𞤤𞤢𞥄𞤻𞤫,𞤳𞤭𞤲𞤰𞤮𞤤𞤢𞥄𞤻𞤫,,{0} 𞤳𞤭𞤲𞤰𞤮𞤤𞤢𞥄𞤻𞤢𞤤,{0} 𞤳𞤭𞤲𞤰𞤮𞤤𞤢𞥄𞤻𞤫
        degree,𞤶𞤫𞤩,,{0}𞤶𞤫𞤩,{0}𞤶𞤫𞤩,𞤶𞤫𞤩𞤫,,{0} 𞤶𞤫𞤩,{0} 𞤶𞤫𞤩,𞤶𞤫𞤩𞤫,,{0} 𞤶𞤫𞤩𞤫𞤪𞤫,{0} 𞤶𞤫𞤩𞤫
        radian,𞤪𞤢𞤣,,{0}𞤪𞤢𞤣,{0}𞤪𞤢𞤣,𞤪𞤢𞤣𞤭𞤴𞤢𞤲𞤶𞤭,,{0} 𞤪𞤢𞤣,{0} 𞤪𞤢𞤣,𞤪𞤢𞤣𞤭𞤴𞤢𞤲𞤶𞤭,,{0} 𞤪𞤢𞤣𞤭𞤴𞤢𞤲𞤪𞤵,{0} 𞤪𞤢𞤣𞤭𞤴𞤢𞤲𞤶𞤭
        revolution,𞤱𞤭𞤣,,{0}𞤱𞤭𞤣,{0}𞤱𞤭𞤣,𞤱𞤭𞤣,,{0} 𞤱𞤭𞤣,{0} 𞤱𞤭𞤣,𞤱𞤭𞤣𞥆𞤢𞤲𞤣𞤫,,{0} 𞤱𞤭𞤣𞥆𞤢𞤲𞤣𞤫,{0} 𞤱𞤭𞤣𞥆𞤢𞤲𞤯𞤫
        acre,𞤺𞤢𞤪𞤳𞤵,,{0}𞤺𞤢,{0}𞤺𞤢,𞤺𞤢𞤪𞤳𞤭,,{0} 𞤺𞤢,{0} 𞤺𞤢,𞤺𞤢𞤪𞤳𞤭,,{0} 𞤺𞤢𞤪𞤳𞤵,{0} 𞤺𞤢𞤪𞤳𞤭
        dunam,𞤣𞤵𞥅𞤲𞤢𞤥𞤵,,{0}𞤣𞤵𞥅𞤲𞤢𞤥𞤵,{0}𞤣𞤵𞥅𞤲𞤢𞤥𞤵,𞤣𞤵𞥅𞤲𞤢𞤥𞤭,,{0} 𞤣𞤵𞥅𞤲𞤢𞤥𞤵,{0} 𞤣𞤵𞥅𞤲𞤢𞤥𞤭,𞤣𞤵𞥅𞤲𞤢𞤥𞤭,,{0} 𞤣𞤵𞥅𞤲𞤢𞤥𞤵,{0} 𞤣𞤵𞥅𞤲𞤢𞤥𞤭
        hectare,𞤸𞤫𞤳𞤼𞤢𞤪𞤣𞤫,,{0}𞤸𞤳,{0}𞤸𞤳,𞤸𞤫𞤳𞤼𞤢𞤪𞤯𞤫,,{0} 𞤸𞤳,{0} 𞤸𞤳,𞤸𞤫𞤳𞤼𞤢𞤪𞤯𞤫,,{0} 𞤸𞤫𞤳𞤼𞤢𞤪𞤣𞤫,{0} 𞤸𞤫𞤳𞤼𞤢𞤪𞤯𞤫
        square-centimeter,𞤧𞤥𞥒,{0}/𞤧𞤥𞥒,{0}𞤧𞤥𞥒,{0}𞤧𞤥𞥒,𞤧𞤥𞥒,{0}/𞤧𞤥𞥒,{0} 𞤧𞤥𞥒,{0} 𞤧𞤥𞥒,𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤭,{0} 𞤲𞤣𞤫𞤪 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤭,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤭
        square-foot,𞤼𞤨𞥒,,{0}𞤼𞤨𞥒,{0}𞤼𞤨𞥒,𞤣𞤺 𞤼𞤫𞤨𞥆𞤭,,{0} 𞤣𞤺 𞤼𞤨,{0} 𞤣𞤺 𞤼𞤨,𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤼𞤫𞤨𞥆𞤭,,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤼𞤫𞤨𞥆𞤵,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤼𞤫𞤨𞥆𞤭
        square-inch,𞤺𞤮𞥒,{0}/𞤺𞤮𞥒,{0}𞤺𞤮𞥒,{0}𞤺𞤮𞥒,𞤲𞤺𞤮𞤪𞤰𞤭𞥒,{0}/𞤺𞤮𞥒,{0} 𞤺𞤮𞥒,{0} 𞤺𞤮𞥒,𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤲𞤺𞤮𞤪𞤰𞤭,{0} 𞤲𞤣𞤫𞤪 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤲𞤺𞤮𞤪𞤰𞤵,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤲𞤺𞤮𞤪𞤰𞤵,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤲𞤺𞤮𞤪𞤰𞤭
        square-kilometer,𞤳𞤥𞥒,{0}/𞤳𞤥𞥒,{0}𞤳𞤥𞥒,{0}𞤳𞤥𞥒,𞤳𞤥𞥒,{0}/𞤳𞤥𞥒,{0} 𞤳𞤥𞥒,{0} 𞤳𞤥𞥒,𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭,{0} 𞤲𞤣𞤫𞤪 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭
        square-meter,𞤥𞤫𞥅𞤼𞤭𞥒,{0}/𞤥𞥒,{0}𞤥𞥒,{0}𞤥𞥒,𞤥𞤫𞥅𞤼𞤭𞥒,{0}/𞤥𞥒,{0} 𞤥𞥒,{0} 𞤥𞥒,𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤥𞤫𞥅𞤼𞤭,{0} 𞤲𞤣𞤫𞤪 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤥𞤫𞥅𞤼𞤭
        square-mile,𞤥𞤢𞥒,{0}/𞤥𞤢𞥒,{0}𞤥𞤢𞥒,{0}𞤥𞤢𞥒,𞤣𞤺 𞤥𞤢𞤴𞤤𞤭,{0}/𞤥𞤢𞥒,{0} 𞤥𞤢 𞤣𞤺,{0} 𞤥𞤢 𞤣𞤺,𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤥𞤢𞤴𞤤𞤭,{0} 𞤲𞤣𞤫𞤪 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤥𞤢𞤴𞤤𞤵,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤥𞤢𞤴𞤤𞤵,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤥𞤢𞤴𞤤𞤭
        square-yard,𞤧𞤺𞥒,,{0}𞤧𞤺𞥒,{0}𞤧𞤺𞥒,𞤧𞤮𞤺𞤮𞤲𞤫𞥒,,{0} 𞤧𞤺𞥒,{0} 𞤧𞤺𞥒,𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤧𞤮𞤺𞤮𞤲𞤫,,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤧𞤮𞤺𞤮𞤲𞤢𞤤,{0} 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤧𞤮𞤺𞤮𞤲𞤫
        item,𞤨𞤭𞤪𞤰𞤵,,{0}𞤨𞤭𞤪,{0}𞤨𞤭𞤪,𞤨𞤭𞤪𞤰𞤵,,{0} 𞤨𞤭𞤪,{0} 𞤨𞤭𞤪,𞤨𞤭𞤪𞤰𞤭,,{0} 𞤨𞤭𞤪𞤰𞤵,{0} 𞤨𞤭𞤪𞤰𞤭
        karat,𞤳𞤢𞤪𞤼𞤵,,{0}𞤳𞤼,{0}𞤳𞤼,𞤳𞤢𞤪𞤼𞤭,,,{0} kt,𞤳𞤢𞤪𞤼𞤭,,{0} 𞤳𞤢𞤪𞤼𞤵,{0} 𞤳𞤢𞤪𞤼𞤭
        milligram-ofglucose-per-deciliter,𞤥𞤺/𞤣𞤤,,{0}𞤥𞤺/𞤣𞤤,{0}𞤥𞤺/𞤣𞤤,𞤥𞤺/𞤣𞤤,,{0} 𞤥𞤺/𞤣𞤤,{0} 𞤥𞤺/𞤣𞤤,𞤥𞤭𞤤𞤭𞤺𞤢𞤪𞤬𞤭 𞤳𞤢𞤤𞤢 𞤣𞤫𞥅𞤧𞤭𞤤𞤭𞥅𞤼𞤵,,{0} 𞤥𞤭𞤤𞤭𞤺𞤢𞤪𞤬𞤵 𞤳𞤢𞤤𞤢 𞤤𞤭𞥅𞤼𞤵,{0} 𞤥𞤭𞤤𞤭𞤺𞤢𞤪𞤬𞤭 𞤳𞤢𞤤𞤢 𞤤𞤭𞥅𞤼𞤵
        millimole-per-liter,𞤥𞤥𞤮𞤤𞤰/𞤤,,{0}𞤥𞤥𞤮𞤤/𞤤,{0}𞤥𞤥𞤮𞤤/𞤤,𞤥𞤭𞤤𞤭𞤥𞤮𞤤/𞤤𞤭𞥅𞤼𞤵,,{0} 𞤥𞤥𞤮𞤤/𞤤,{0} 𞤥𞤥𞤮𞤤/𞤤,𞤥𞤭𞤤𞤭𞤥𞤮𞤤𞤰𞤵 𞤳𞤢𞤤𞤢 𞤤𞤭𞥅𞤼𞤵,,{0} 𞤥𞤭𞤤𞤭𞤥𞤮𞤤𞤰𞤵 𞤳𞤢𞤤𞤢 𞤤𞤭𞥅𞤼𞤵,{0} 𞤥𞤭𞤤𞤭𞤥𞤮𞤤𞤰𞤭 𞤳𞤢𞤤𞤢 𞤤𞤭𞥅𞤼𞤵
        mole,𞤥𞤮𞤤,,{0}𞤥𞤮𞤤,{0}𞤥𞤮𞤤,𞤥𞤮𞤤𞤰𞤵,,{0} 𞤥𞤮𞤤,{0} 𞤥𞤮𞤤,𞤥𞤮𞤤𞤰𞤭,,{0} 𞤥𞤮𞤤𞤰𞤵,{0} 𞤥𞤮𞤤𞤰𞤭
        percent,,,,,𞤳𞤢𞤤𞤼𞤫𞥅𞤥𞤵,,,{0}%,𞤳𞤢𞤤𞤼𞤫𞥅𞤥𞤵,,{0} 𞤳𞤢𞤤𞤼𞤫𞥅𞤥𞤵,{0} 𞤳𞤢𞤤𞤼𞤫𞥅𞤥𞤵
        permille,,,,,𞤳𞤢𞤤𞤺𞤵𞤤𞤶𞤵,,,{0}‰,𞤳𞤢𞤤𞤺𞤵𞤤𞤶𞤵,,{0} 𞤳𞤢𞤤𞤺𞤵𞤤𞤶𞤵,{0} 𞤳𞤢𞤤𞤺𞤵𞤤𞤶𞤵
        permillion,𞤺𞤳𞤣,,{0}𞤺𞤳𞤣,{0}𞤺𞤳𞤣,𞤺𞤫𞤩𞤫/𞤣𞤵𞤦𞤵𞥅𞤪𞤫,,{0} 𞤺𞤳𞤣,{0} 𞤺𞤳𞤣,𞤺𞤫𞤩𞤫 𞤳𞤢𞤤𞤢 𞤣𞤵𞤦𞤵𞥅𞤪𞤫,,{0} 𞤺𞤫𞤩𞤢𞤤 𞤳𞤢𞤤𞤢 𞤣𞤵𞤦𞤵𞥅𞤪𞤫,{0} 𞤺𞤫𞤩𞤫 𞤳𞤢𞤤𞤢 𞤣𞤵𞤦𞤵𞥅𞤪𞤫
        permyriad,,,,,𞤳𞤢𞤤𞤲𞤺𞤵𞤤𞤧𞤢𞤨𞥆𞤮,,,{0}‱,𞤳𞤢𞤤𞤺𞤵𞤤𞤧𞤢𞤨𞥆𞤮,,{0} 𞤳𞤢𞤤𞤲𞤺𞤵𞤤𞤧𞤢𞤨𞥆𞤮,{0} 𞤳𞤢𞤤𞤲𞤺𞤵𞤤𞤧𞤢𞤨𞥆𞤮
        liter-per-100-kilometer,𞤤/𞥑𞥐𞥐 𞤳𞤥,,{0}𞤤/𞥑𞥐𞥐 𞤳𞤥,{0}𞤤/𞥑𞥐𞥐 𞤳𞤥,𞤤/𞥑𞥐𞥐 𞤳𞤥,,{0} 𞤤/𞥑𞥐𞥐 𞤳𞤥,{0} 𞤤/𞥑𞥐𞥐 𞤳𞤥,𞤤𞤭𞥅𞤼𞤭 𞤳𞤢𞤤𞤢 𞥑𞥐𞥐 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭,,{0} 𞤤𞤭𞥅𞤼𞤵 𞤳𞤢𞤤𞤢 𞥑𞥐𞥐 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭,{0} 𞤤𞤭𞥅𞤼𞤭 𞤳𞤢𞤤𞤢 𞥑𞥐𞥐 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭
        liter-per-kilometer,𞤤/𞤳𞤥,,{0}𞤤/𞤳𞤥,{0}𞤤/𞤳𞤥,𞤤𞤭𞥅𞤼𞤭/𞤳𞤥,,{0} 𞤤/𞤳𞤥,{0} 𞤤/𞤳𞤥,𞤤𞤭𞥅𞤼𞤭 𞤳𞤢𞤤𞤢 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤮𞤤,,{0} 𞤤𞤭𞥅𞤼𞤵 𞤳𞤢𞤤𞤢 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤤𞤭𞥅𞤼𞤵 𞤳𞤢𞤤𞤢 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭
        mile-per-gallon,𞤥𞤳𞤺,,{0}𞤥𞤳𞤺,{0}𞤥𞤳𞤺,𞤥𞤢𞤴𞤤𞤭/𞤺𞤢𞤤,,{0} 𞤥𞤳𞤺,{0} 𞤥𞤳𞤺,𞤥𞤢𞤴𞤤𞤭 𞤳𞤢𞤤𞤢 𞤺𞤢𞤤𞤮𞤲𞤪𞤵,,{0} 𞤥𞤢𞤴𞤤𞤵 𞤳𞤢𞤤𞤢 𞤺𞤢𞤤𞤮𞤲𞤪𞤵,{0} 𞤥𞤢𞤴𞤤𞤭 𞤳𞤢𞤤𞤢 𞤺𞤢𞤤𞤮𞤲𞤪𞤵
        mile-per-gallon-imperial,𞤥𞤢/𞤺𞤢𞤤 𞤼𞤭𞤤.,,{0}𞤥𞤳𞤺 𞤼𞤭𞤤.,{0}𞤥𞤳𞤺 𞤼𞤭𞤤.,𞤥𞤢𞤴𞤤𞤭/𞤺𞤢𞤤 𞤼𞤭𞤤.,,{0} 𞤥𞤳𞤺 𞤼𞤭𞤤.,{0} 𞤥𞤳𞤺 𞤼𞤭𞤤.,𞤥𞤢𞤴𞤤𞤭 𞤳𞤢𞤤𞤢 𞤺𞤮𞤲𞤤𞤮𞤲𞤶𞤭 𞤼𞤭𞤤𞤧𞤵,,{0} 𞤥𞤢𞤴𞤤𞤵 𞤳𞤢𞤤𞤢 𞤺𞤢𞤤𞤮𞤲𞤶𞤭 𞤼𞤭𞤤𞤧𞤵,{0} 𞤥𞤢𞤴𞤤𞤭 𞤳𞤢𞤤𞤢 𞤺𞤢𞤤𞤮𞤲𞤶𞤭 𞤼𞤭𞤤𞤧𞤵
        bit,𞤦,,{0}𞤦,{0}𞤦,𞤦𞤭𞥅𞤼𞥆𞤵,,{0} 𞤦,{0} 𞤦,𞤦𞤭𞥅𞤼𞥆𞤭,,{0} 𞤦𞤭𞥅𞤼𞥆𞤵,{0} 𞤦𞤭𞥅𞤼𞥆𞤭
        byte,𞤔,,{0}𞤔,{0}𞤔,𞤶𞤫𞥅𞤼𞥆𞤵,,{0} 𞤔,{0} 𞤔,𞤶𞤫𞥅𞤼𞥆𞤭,,{0} 𞤶𞤫𞥅𞤼𞥆𞤵,{0} 𞤶𞤫𞥅𞤼𞥆𞤭
        gigabit,𞤘𞤦,,{0}𞤘𞤦,{0}𞤘𞤦,𞤘𞤦𞤭𞥅𞤼𞥆𞤵,,{0} 𞤘𞤦,{0} 𞤘𞤦,𞤺𞤭𞤺𞤢𞤦𞤭𞥅𞤼𞥆𞤭,,{0} 𞤺𞤭𞤺𞤢𞤦𞤭𞥅𞤼𞥆𞤵,{0} 𞤺𞤭𞤺𞤢𞤦𞤭𞥅𞤼𞥆𞤭
        gigabyte,𞤘𞤔,,{0}𞤘𞤔,{0}𞤘𞤔,𞤘𞤔𞤫𞥅𞤼𞥆𞤵,,{0} 𞤘𞤔,{0} 𞤘𞤔,𞤺𞤭𞤺𞤢𞤶𞤫𞥅𞤼𞥆𞤭,,{0} 𞤺𞤭𞤺𞤢𞤶𞤫𞥅𞤼𞥆𞤵,{0} 𞤺𞤭𞤺𞤢𞤶𞤫𞥅𞤼𞥆𞤭
        kilobit,𞤳𞤦,,{0}𞤳𞤦,{0}𞤳𞤦,𞤳𞤦𞤭𞥅𞤼𞥆𞤵,,{0} 𞤳𞤦,{0} 𞤳𞤦,𞤳𞤭𞤤𞤮𞤦𞤭𞥅𞤼𞥆𞤭,,{0} 𞤳𞤭𞤤𞤮𞤦𞤭𞥅𞤼𞥆𞤵,{0} 𞤳𞤭𞤤𞤮𞤦𞤭𞥅𞤼𞥆𞤭
        kilobyte,𞤳𞤔,,{0}𞤳𞤔,{0}𞤳𞤔,𞤳𞤔𞤫𞥅𞤼𞥆𞤵,,{0} 𞤳𞤔,{0} 𞤳𞤔,𞤳𞤭𞤤𞤮𞤶𞤫𞥅𞤼𞥆𞤭,,{0} 𞤳𞤭𞤤𞤮𞤶𞤫𞥅𞤼𞥆𞤵,{0} 𞤳𞤭𞤤𞤮𞤶𞤫𞥅𞤼𞥆𞤭
        megabit,𞤃𞤦,,{0}𞤃𞤦,{0}𞤃𞤦,𞤃𞤦𞤭𞥅𞤼𞥆𞤵,,{0} 𞤃𞤦,{0} 𞤃𞤦,𞤥𞤫𞤺𞤢𞤦𞤭𞥅𞤼𞥆𞤭,,{0} 𞤥𞤫𞤺𞤢𞤦𞤭𞥅𞤼𞥆𞤵,{0} 𞤥𞤫𞤺𞤢𞤦𞤭𞥅𞤼𞥆𞤭
        megabyte,𞤃𞤔,,{0}𞤃𞤔,{0}𞤃𞤔,𞤃𞤔𞤫𞥅𞤼𞥆𞤵,,{0} 𞤃𞤔,{0} 𞤃𞤔,𞤥𞤫𞤺𞤢𞤶𞤫𞥅𞤼𞥆𞤭,,{0} 𞤥𞤫𞤺𞤢𞤶𞤫𞥅𞤼𞥆𞤵,{0} 𞤥𞤫𞤺𞤢𞤶𞤫𞥅𞤼𞥆𞤭
        petabyte,𞤆𞤔,,{0}𞤆𞤔,{0}𞤆𞤔,𞤆𞤔𞤫𞥅𞤼𞥆𞤵,,{0} 𞤆𞤔,{0} 𞤆𞤔,𞤨𞤫𞤼𞤢𞤶𞤫𞥅𞤼𞥆𞤭,,{0} 𞤨𞤫𞤼𞤢𞤶𞤫𞥅𞤼𞥆𞤵,{0} 𞤨𞤫𞤼𞤢𞤶𞤫𞥅𞤼𞥆𞤭
        terabit,𞤚𞤦,,{0}𞤚𞤦,{0}𞤚𞤦,𞤚𞤦𞤭𞥅𞤼𞥆𞤭,,{0} 𞤚𞤦,{0} 𞤚𞤦,𞤼𞤫𞤪𞤢𞤦𞤭𞥅𞤼𞥆𞤭,,{0} 𞤼𞤫𞤪𞤢𞤦𞤭𞥅𞤼𞥆𞤵,{0} 𞤼𞤫𞤪𞤢𞤦𞤭𞥅𞤼𞥆𞤭
        terabyte,𞤆𞤔,,{0}𞤚𞤔,{0}𞤚𞤔,𞤚𞤔𞤫𞥅𞤼𞥆𞤵,,{0} 𞤚𞤔,{0} 𞤚𞤔,𞤼𞤫𞤪𞤢𞤶𞤫𞥅𞤼𞥆𞤭,,{0} 𞤼𞤫𞤪𞤢𞤶𞤫𞥅𞤼𞥆𞤵,{0} 𞤼𞤫𞤪𞤢𞤶𞤫𞥅𞤼𞥆𞤭
        century,𞤼,,{0}𞤼,{0}𞤼,𞤼,,{0} 𞤼,{0} 𞤼,𞤼𞤫𞥅𞤥𞤭𞤲𞤢𞤲𞤯𞤫,,{0} 𞤼𞤫𞥅𞤥𞤭𞤲𞤢𞤲𞤣𞤫,{0} 𞤼𞤫𞥅𞤥𞤭𞤲𞤢𞤲𞤯𞤫
        day,𞤻𞤢𞤤.,{0}/𞤻,{0}𞤻,{0}𞤻,𞤻𞤢𞤤.,{0}/𞤻𞤢𞤤.,{0} 𞤻𞤢𞤤.,{0} 𞤻𞤢𞤤.,𞤻𞤢𞤤𞥆𞤢𞤤,{0} 𞤲𞤣𞤫𞤪 𞤻𞤢𞤤𞥆𞤢𞤤,{0} 𞤻𞤢𞤤𞥆𞤢𞤤,{0} 𞤻𞤢𞤤𞥆𞤫
        decade,𞤼𞤭𞤶,,{0}𞤼𞤭𞤶,{0}𞤼𞤭𞤶,𞤼𞤭𞤶,,{0} 𞤼𞤭𞤶,{0} 𞤼𞤭𞤶,𞤼𞤭𞤶𞤢𞤲𞤯𞤫,,{0} 𞤼𞤭𞤶𞤢𞤲𞤣𞤫,{0} 𞤼𞤭𞤶𞤢𞤲𞤯𞤫
        hour,𞤲𞤶𞤢𞤥𞤲𞤣𞤭,{0}/𞤶,{0}𞤶,{0}𞤶,𞤲𞤶𞤢𞤥𞤤𞤭,{0}/𞤶,{0} 𞤶𞤢,{0} 𞤶𞤢,𞤲𞤶𞤢𞤥𞤤𞤭,{0} 𞤲𞤣𞤫𞤪 𞤲𞤶𞤢𞤥𞤲𞤣𞤭,{0} 𞤲𞤶𞤢𞤥𞤲𞤣𞤭,{0} 𞤲𞤶𞤢𞤥𞤤𞤭
        microsecond,𞤻𞤳𞤭𞤲,,{0}𞤻𞤳𞤭𞤲,{0}𞤻𞤳𞤭𞤲,𞤻𞤳𞤭𞤲,,{0} 𞤻𞤳𞤭𞤲,{0} 𞤻𞤳𞤭𞤲,𞤻𞤭𞤤𞤢𞤳𞤭𞤲𞤰𞤫,,{0} 𞤻𞤭𞤤𞤢𞤳𞤭𞤲𞤰𞤫𞤪𞤫,{0} 𞤻𞤭𞤤𞤢𞤳𞤭𞤲𞤰𞤫
        millisecond,𞤥𞤳𞤭𞤲,,{0}𞤥𞤳𞤭𞤲,{0}𞤥𞤳𞤭𞤲,𞤥𞤭𞤤𞤭𞤳𞤭𞤲,,{0} 𞤥𞤳𞤭𞤲,{0} 𞤥𞤳𞤭𞤲,𞤥𞤭𞤤𞤭𞤳𞤭𞤲𞤰𞤫,,{0} 𞤥𞤭𞤤𞤭𞤳𞤭𞤲𞤰𞤫𞤪𞤫,{0} 𞤥𞤭𞤤𞤭𞤳𞤭𞤲𞤰𞤫
        minute,𞤸𞤮𞤶,{0}/𞤸𞤮𞤶,{0}𞤸𞤮𞤶,{0}𞤸𞤮𞤶,𞤸𞤮𞤶,{0}/𞤸𞤮𞤶,{0} 𞤸𞤮𞤶,{0} 𞤸𞤮𞤶,𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫,{0} 𞤲𞤣𞤫𞤪 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫,{0} 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤪𞤫,{0} 𞤸𞤮𞤶𞤮𞤥𞤢𞥄𞤶𞤫
        month,𞤤𞤫𞤦𞥆𞤭,{0}/𞤤,{0} 𞤤,{0} 𞤤,𞤤𞤫𞤦𞥆𞤭,{0}/𞤤,{0}/𞤤𞤫𞤱,{0} 𞤤𞤫𞤦,𞤤𞤫𞤦𞥆𞤭,{0} 𞤲𞤣𞤫𞤪 𞤤𞤫𞤱𞤪𞤵,{0} 𞤤𞤫𞤱𞤪𞤵,{0} 𞤤𞤫𞤦𞥆𞤭
        nanosecond,𞤲𞤳𞤭𞤲,,{0}𞤲𞤳𞤭𞤲,{0}𞤲𞤳𞤭𞤲,𞤲𞤢𞤲𞤮𞥅𞤳𞤭𞤲,,{0} 𞤲𞤳𞤭𞤲,{0} 𞤲𞤳𞤭𞤲,𞤲𞤢𞤲𞤮𞥅𞤳𞤭𞤲𞤰𞤫,,{0} 𞤲𞤢𞤲𞤮𞥅𞤳𞤭𞤲𞤰𞤫𞤪𞤫,{0} 𞤲𞤢𞤲𞤮𞥅𞤳𞤭𞤲𞤰𞤫
        quarter,𞤲𞤤𞤦,{0}/𞤲,{0} 𞤲,{0} 𞤲,𞤲𞤤𞤦,{0}/𞤲,{0} 𞤲,{0} 𞤲,𞤲𞤢𞤤𞤫𞤦𞥆𞤭,{0}/𞤲,{0} 𞤲,{0} 𞤲
        second,𞤳𞤭𞤲,{0}/𞤳𞤭𞤲,{0}𞤳𞤭𞤲,{0}𞤳𞤭𞤲,𞤳𞤭𞤲,{0}/𞤳𞤭𞤲,{0} 𞤳𞤭𞤲,{0} 𞤳𞤭𞤲,𞤳𞤭𞤲𞤰𞤫,{0} 𞤲𞤣𞤫𞤪 𞤳𞤭𞤲𞤰𞤫,{0} 𞤳𞤭𞤲𞤰𞤮,{0} 𞤳𞤭𞤲𞤰𞤫
        week,𞤶𞤼,{0}/𞤴𞤼,{0} 𞤴𞤼,{0} 𞤶𞤼,𞤶𞤼,{0}/𞤴𞤼,{0} 𞤴𞤼,{0} 𞤶𞤼,𞤶𞤮𞤲𞤼𞤫,{0} 𞤲𞤣𞤫𞤪 𞤴𞤮𞤲𞤼𞤫𞤪𞤫,{0} 𞤴𞤮𞤲𞤼𞤫𞤪𞤫,{0} 𞤶𞤮𞤲𞤼𞤫
        year,𞤸𞤭𞤼,{0}/𞤸,{0} 𞤳𞤭𞤼,{0}/𞤳𞤭𞤼,𞤳𞤭𞤼𞤢𞥄𞤯𞤫,{0}/𞤸,{0} 𞤸𞤭𞤼,{0} 𞤳𞤭𞤼,𞤳𞤭𞤼𞤢𞥄𞤯𞤫,{0} 𞤲𞤣𞤫𞤪 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫,{0} 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫,{0} 𞤳𞤭𞤼𞤢𞥄𞤯𞤫
        ampere,𞤢𞤥𞤨,,{0}𞤀,{0}𞤀,𞤢𞤥𞤨𞤫𞤪𞤶𞤭,,{0} 𞤀,{0} 𞤀,𞤢𞤥𞤨𞤫𞤪𞤶𞤭,,{0} 𞤢𞤥𞤨𞤫𞤪𞤱𞤵,{0} 𞤢𞤥𞤨𞤫𞤪𞤶𞤭
        milliampere,𞤥𞤀,,{0}𞤥𞤀,{0}𞤥𞤀,𞤥𞤭𞤤𞤭𞤢𞤥𞤨,,{0} 𞤥𞤀,{0} 𞤥𞤀,𞤥𞤭𞤤𞤭𞤢𞤥𞤨𞤫𞤪𞤶𞤭,,{0} 𞤥𞤭𞤤𞤭𞤢𞤥𞤨𞤫𞤪𞤱𞤵,{0} 𞤥𞤭𞤤𞤭𞤢𞤥𞤨𞤫𞤪𞤶𞤭
        ohm,𞤮𞤸𞤥𞤵,,{0}Ω,{0}Ω,𞤮𞤸𞤥𞤵𞥅𞤶𞤭,,,{0} Ω,𞤮𞤸𞤥𞤵𞥅𞤶𞤭,,{0} 𞤮𞤸𞤥𞤵,{0} 𞤮𞤸𞤥𞤵𞥅𞤶𞤭
        volt,𞤾𞤮𞤤𞤼𞤵,,{0}𞤜,{0}𞤜,𞤾𞤮𞤤𞤼𞤵𞥅𞤶𞤭,,{0} 𞤜,{0} 𞤜,𞤾𞤮𞤤𞤼𞤵𞥅𞤶𞤭,,{0} 𞤾𞤮𞤤𞤼𞤵,{0} 𞤾𞤮𞤤𞤼𞤵𞥅𞤶𞤭
        british-thermal-unit,𞤑𞤘𞤄,,{0}𞤑𞤺𞤦,{0}𞤑𞤺𞤦,𞤑𞤘𞤄,,{0} 𞤑𞤺𞤦,{0} 𞤑𞤺𞤦,𞤑𞤵𞥅𞤰𞤫 𞤲𞤺𞤵𞤤𞤲𞤣𞤭𞤲𞤳𞤮 𞤄𞤭𞤪𞤼𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮,,{0} 𞤑𞤵𞥅𞤰𞤮 𞤲𞤺𞤵𞤤𞤣𞤭𞤲𞤳𞤮 𞤄𞤭𞤪𞤼𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮,{0} 𞤑𞤵𞥅𞤰𞤫 𞤲𞤺𞤵𞤤𞤣𞤭𞤲𞤳𞤮 𞤄𞤭𞤪𞤼𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮
        calorie,𞤺𞤵𞤤,,{0}𞤺𞤵𞤤,{0}𞤺𞤵𞤤,𞤺𞤵𞤤,,{0} 𞤺𞤵𞤤,{0} 𞤺𞤵𞤤,𞤲𞤺𞤵𞤤𞤭,,{0} 𞤲𞤺𞤵𞤤𞤵,{0} 𞤲𞤺𞤵𞤤𞤭
        electronvolt,𞤫𞤜,,{0}𞤫𞤜,{0}𞤫𞤜,𞤫𞤤𞤫𞤳𞤼𞤮𞤾𞤮𞤤𞤼𞤵,,{0} 𞤫𞤜,{0} 𞤫𞤜,𞤫𞤤𞤫𞤳𞤼𞤮𞤾𞤮𞤤𞤼𞤭,,{0} 𞤫𞤤𞤫𞤳𞤼𞤮𞤾𞤮𞤤𞤼𞤵,{0} 𞤫𞤤𞤫𞤳𞤼𞤮𞤾𞤮𞤤𞤼𞤭
        joule,𞥁𞤵𞥅𞤤𞤱𞤵,,{0}𞤟,{0}𞤟,𞥁𞤵𞥅𞤤𞤶𞤭,,{0} 𞤟,{0} 𞤟,𞥁𞤵𞥅𞤤𞤶𞤭,,{0} 𞥁𞤵𞥅𞤤𞤱𞤵,{0} 𞥁𞤵𞥅𞤤𞤶𞤭
        kilocalorie,𞤳𞤺𞤵𞤤,,{0}𞤳𞤺𞤵𞤤,{0}𞤳𞤺𞤵𞤤,𞤳𞤺𞤵𞤤,,{0} 𞤳𞤺𞤵𞤤,{0} 𞤳𞤺𞤵𞤤,𞤳𞤭𞤤𞤮𞤲𞥋𞤺𞤵𞤤𞤭,,{0} 𞤳𞤭𞤤𞤮𞤲𞥋𞤺𞤵𞤤𞤵,{0} 𞤳𞤭𞤤𞤮𞤲𞥋𞤺𞤵𞤤𞤭
        kilojoule,𞤳𞤟,,{0}𞤳𞤟,{0}𞤳𞤟,𞤳𞤭𞤤𞤮𞥁𞤵𞥅𞤤𞤱𞤵,,{0} 𞤳𞤟,{0} 𞤳𞤟,𞤳𞤭𞤤𞤮𞥁𞤵𞥅𞤤𞤶𞤭,,{0} 𞤳𞤭𞤤𞤮𞥁𞤵𞥅𞤤𞤱𞤵,{0} 𞤳𞤭𞤤𞤮𞥁𞤵𞥅𞤤𞤶𞤭
        kilowatt-hour,𞤳𞤏𞤶,,{0}𞤳𞤏𞤶,{0}𞤳𞤏𞤶,𞤳𞤏-𞤲𞤶𞤢𞤥𞤲𞤣𞤭,,{0} 𞤳𞤏𞤶,{0} 𞤳𞤏𞤶,𞤳𞤭𞤤𞤮𞤱𞤢𞥄𞤼𞤵-𞤲𞤶𞤢𞤥𞤤𞤭,,{0} 𞤳𞤭𞤤𞤮𞤱𞤢𞥄𞤼𞤵-𞤲𞤶𞤢𞤥𞤲𞤣𞤭,{0} 𞤳𞤭𞤤𞤮𞤱𞤢𞥄𞤼𞤵-𞤲𞤶𞤢𞤥𞤤𞤭
        therm-us,𞤲𞤺𞤣𞤳𞤮 𞤁𞤀,,{0}𞤲𞤺𞤣𞤳𞤮 𞤁𞤀,{0}𞤲𞤺𞤣𞤳𞤮 𞤁𞤀,𞤲𞤺𞤵𞤤𞤣𞤭𞤲𞤳𞤮 𞤁𞤀,,{0} 𞤲𞤺𞤣𞤳𞤮 𞤁𞤀,{0} 𞤲𞤺𞤣𞤳𞤮 𞤁𞤀,𞤲𞤺𞤵𞤤𞤣𞤭𞤲𞤳𞤫 𞤁𞤀,,{0} 𞤲𞤺𞤵𞤤𞤣𞤭𞤲𞤳𞤮 𞤁𞤀,{0} 𞤲𞤺𞤵𞤤𞤣𞤭𞤲𞤳𞤫 𞤁𞤀
        kilowatt-hour-per-100-kilometer,𞤳𞤏𞤶/𞥑𞥐𞥐𞤳𞤥,,{0}𞤳𞤏𞤶/𞥑𞥐𞥐𞤳𞤥,{0}𞤳𞤏𞤶/𞥑𞥐𞥐𞤳𞤥,𞤳𞤏𞤶/𞥑𞥐𞥐𞤳𞤥,,{0} 𞤳𞤏𞤶/𞥑𞥐𞥐𞤳𞤥,{0} 𞤳𞤏𞤶/𞥑𞥐𞥐𞤳𞤥,𞤳𞤭𞤤𞤮𞤱𞤢𞥄𞤼𞤵-𞤲𞤶𞤢𞤥𞤤𞤭 𞤳𞤢𞤤𞤢 𞥑𞥐𞥐 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭,,{0} 𞤳𞤭𞤤𞤮𞤱𞤢𞥄𞤼𞤵-𞤲𞤶𞤢𞤥𞤲𞤣𞤭 𞤳𞤢𞤤𞤢 𞥑𞥐𞥐 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭,{0} 𞤳𞤭𞤤𞤮𞤱𞤢𞥄𞤼𞤵-𞤲𞤶𞤢𞤥𞤤𞤭 𞤳𞤢𞤤𞤢 𞥑𞥐𞥐 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭
        newton,𞤐,,{0}𞤐,{0}𞤐,𞤲𞤫𞤱𞤼𞤮𞤲,,{0} 𞤐,{0} 𞤐,𞤲𞤫𞤱𞤼𞤮𞤲𞤶𞤭,,{0} 𞤲𞤫𞤱𞤼𞤮𞤲,{0} 𞤲𞤫𞤱𞤼𞤮𞤲𞤶𞤭
        pound-force,𞤺𞤤𞤷,,{0}𞤺𞤤𞤷,{0}𞤺𞤤𞤷,𞤺𞤢𞤪𞤤𞤭-𞤷𞤫𞤥𞤦𞤫,,{0} 𞤺𞤤𞤷,{0} 𞤺𞤤𞤷,𞤺𞤢𞤪𞤤𞤭-𞤷𞤫𞤥𞤦𞤫,,{0} 𞤺𞤢𞤪𞤤𞤵-𞤷𞤫𞤥𞤦𞤫,{0} 𞤺𞤢𞤪𞤤𞤭-𞤷𞤫𞤥𞤦𞤫
        gigahertz,𞤘𞤖𞤪,,{0}𞤘𞤖𞤪,{0}𞤘𞤖𞤪,𞤘𞤖𞤪,,{0} 𞤘𞤖𞤪,{0} 𞤘𞤖𞤪,𞤺𞤭𞤺𞤢𞤸𞤫𞤪𞤼𞤵,,{0} 𞤺𞤭𞤺𞤢𞤸𞤫𞤪𞤼𞤵,{0} 𞤺𞤭𞤺𞤢𞤸𞤫𞤪𞤼𞤭
        hertz,𞤖𞤪,,{0}𞤖𞤪,{0}𞤖𞤪,𞤖𞤪,,{0} 𞤖𞤪,{0} 𞤖𞤪,𞤸𞤫𞤪𞤼𞤵,,{0} 𞤸𞤫𞤪𞤼𞤵,{0} 𞤸𞤫𞤪𞤼𞤭
        kilohertz,𞤳𞤖𞤪,,{0}𞤳𞤖𞤪,{0}𞤳𞤖𞤪,𞤳𞤖𞤪,,{0} 𞤳𞤖𞤪,{0} 𞤳𞤖𞤪,𞤳𞤭𞤤𞤮𞤸𞤫𞤪𞤼𞤵,,{0} 𞤳𞤭𞤤𞤮𞤸𞤫𞤪𞤼𞤵,{0} 𞤳𞤭𞤤𞤮𞤸𞤫𞤪𞤼𞤭
        megahertz,𞤃𞤖𞤪,,{0}𞤃𞤖𞤪,{0}𞤃𞤖𞤪,𞤃𞤖𞤪,,{0} 𞤃𞤖𞤪,{0} 𞤃𞤖𞤪,𞤥𞤫𞤺𞤢𞤸𞤫𞤪𞤼𞤵,,{0} 𞤥𞤫𞤺𞤢𞤸𞤫𞤪𞤼𞤵,{0} 𞤥𞤫𞤺𞤢𞤸𞤫𞤪𞤼𞤭
        em,𞤭𞤥𞤵,,{0}𞤭𞤥𞤵,{0}𞤭𞤥𞤵,𞤭𞤥𞤵,,{0} 𞤭𞤥𞤵,{0} 𞤭𞤥𞤵,𞤭𞤥𞤵 𞤬𞤭𞥅 𞤴𞤢𞥄𞤴𞤮,,{0} 𞤭𞤥𞤵,{0} 𞤭𞤥𞤭
        megapixel,𞤃𞤆,,{0}𞤃𞤆,{0}𞤃𞤆,𞤥𞤫𞤺𞤢𞤨𞤭𞤳𞤷𞤭,,{0} 𞤃𞤆,{0} 𞤃𞤆,𞤥𞤫𞤺𞤢𞤨𞤭𞤳𞤷𞤮𞤤,,{0} 𞤥𞤫𞤺𞤢𞤨𞤭𞤳𞤷𞤮𞤤,{0} 𞤥𞤫𞤺𞤢𞤨𞤭𞤳𞤷𞤭
        pixel,𞤨𞤳,,{0}𞤨𞤳,{0}𞤨𞤳,𞤨𞤭𞤳𞤷𞤭,,{0} 𞤨𞤳,{0} 𞤨𞤳,𞤨𞤭𞤳𞤷𞤭,,{0} 𞤨𞤭𞤳𞤷𞤮𞤤,{0} 𞤨𞤭𞤳𞤷𞤭
        pixel-per-centimeter,𞤨𞤳𞤣𞤧𞤥,,{0}𞤨𞤳𞤣𞤧𞤥,{0}𞤨𞤳𞤣𞤧𞤥,𞤨𞤳𞤣𞤧𞤥,,{0} 𞤨𞤳𞤣𞤧𞤥,{0} 𞤨𞤳𞤣𞤧𞤥,𞤨𞤭𞤳𞤷𞤭 𞤲𞤣𞤫𞤪 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤮𞤤,,{0} 𞤨𞤭𞤳𞤷𞤮𞤤 𞤲𞤣𞤫𞤪 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤨𞤭𞤳𞤷𞤭 𞤲𞤣𞤫𞤪 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤮𞤤
        pixel-per-inch,𞤨𞤳𞤣𞤺𞤰,,{0}𞤨𞤳𞤣𞤺𞤰,{0}𞤨𞤳𞤣𞤺𞤰,𞤨𞤳𞤣𞤺𞤰,,{0} 𞤨𞤳𞤣𞤺𞤰,{0} 𞤨𞤳𞤣𞤺𞤰,𞤨𞤭𞤳𞤷𞤭 𞤲𞤣𞤫𞤪 𞤲𞤺𞤮𞤪𞤰𞤵,,{0} 𞤨𞤭𞤳𞤷𞤮𞤤 𞤲𞤣𞤫𞤪 𞤲𞤺𞤮𞤪𞤰𞤵,{0} 𞤨𞤭𞤳𞤷𞤭 𞤲𞤣𞤫𞤪 𞤲𞤺𞤮𞤪𞤰𞤵
        astronomical-unit,𞤳𞤵,,{0}𞤳𞤵,{0}𞤳𞤵,𞤳𞤵,,{0} 𞤳𞤵,{0} 𞤳𞤵,𞤳𞤵𞥅𞤰𞤫 𞤦𞤵𞤪𞤶𞤵𞤲𞤳𞤫,,{0} 𞤳𞤵𞥅𞤰𞤵 𞤦𞤵𞤪𞤶𞤵𞤲𞤳𞤮,{0} 𞤳𞤵𞥅𞤰𞤫 𞤦𞤵𞤪𞤶𞤵𞤲𞤳𞤫
        centimeter,𞤧𞤥,{0}/𞤧𞤥,{0}𞤧𞤥,{0}𞤧𞤥,𞤧𞤥,{0}/𞤧𞤥,{0} 𞤧𞤥,{0} 𞤧𞤥,𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤭,{0} 𞤲𞤣𞤫𞤪 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤧𞤫𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤭
        decimeter,𞤣𞤥,,{0}𞤣𞤥,{0}𞤣𞤥,𞤣𞤥,,{0} 𞤣𞤥,{0} 𞤣𞤥,𞤣𞤫𞥅𞤧𞤭𞤥𞤫𞥅𞤼𞤭,,{0} 𞤣𞤫𞥅𞤧𞤭𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤣𞤫𞥅𞤧𞤭𞤥𞤫𞥅𞤼𞤭
        earth-radius,𞤂⊕,,{0}𞤂⊕,{0}𞤂⊕,𞤂⊕,,{0} 𞤂⊕,{0} 𞤂⊕,𞤤𞤢𞥄𞤧𞤮𞤤 𞤤𞤫𞤴𞤣𞤭 𞤲𞤣𞤭𞤲,,{0} 𞤤𞤢𞥄𞤧𞤮𞤤 𞤤𞤫𞤴𞤣𞤭 𞤲𞤣𞤭𞤲,{0} 𞤤𞤢𞥄𞤧𞤮𞤤 𞤤𞤫𞤴𞤣𞤭 𞤲𞤣𞤭𞤲
        fathom,𞤶𞤮𞤤𞥆𞤢𞤲𞤣𞤫,,{0}𞤶𞤮𞤤,{0}𞤶𞤮𞤤,𞤶𞤮𞤤𞥆𞤢𞤲𞤯𞤫,,{0} 𞤶𞤮𞤤,{0} 𞤶𞤮𞤤,𞤶𞤮𞤤𞥆𞤢𞤲𞤯𞤫,,{0} 𞤶𞤮𞤤𞥆𞤢𞤲𞤣𞤫,{0} 𞤶𞤮𞤤𞥆𞤢𞤲𞤯𞤫
        foot,𞤼𞤨,{0}/𞤼𞤨,{0}𞤼𞤨,{0}𞤼𞤨,𞤼𞤫𞤨𞥆𞤭,{0}/𞤼𞤨,{0} 𞤼𞤨,{0} 𞤼𞤨,𞤼𞤫𞤨𞥆𞤭,{0} 𞤲𞤣𞤫𞤪 𞤼𞤫𞤨𞥆𞤵,{0} 𞤼𞤫𞤨𞥆𞤵,{0} 𞤼𞤫𞤨𞥆𞤭
        furlong,𞤬𞤵𞤪𞤤𞤮𞤲𞤺𞤵,,{0}𞤬𞤵𞤪,{0}𞤬𞤵𞤪,𞤬𞤵𞤪𞤤𞤮𞤲𞤺𞤭,,{0} 𞤬𞤵𞤪,{0} 𞤬𞤵𞤪,𞤬𞤵𞤪𞤤𞤮𞤲𞤺𞤭,,{0} 𞤬𞤵𞤪𞤤𞤮𞤲𞤺𞤵,{0} 𞤬𞤵𞤪𞤤𞤮𞤲𞤺𞤭
        inch,𞤺𞤮,{0}/𞤺𞤮,{0}𞤺𞤮,{0}𞤺𞤮,𞤲𞤺𞤮𞤪𞤰𞤭,{0}/𞤺𞤮,{0} 𞤺𞤮,{0} 𞤺𞤮,𞤲𞤺𞤮𞤪𞤰𞤭,{0} 𞤲𞤣𞤫𞤪 𞤲𞤺𞤮𞤪𞤰𞤵,{0} 𞤲𞤺𞤮𞤪𞤰𞤵,{0} 𞤲𞤺𞤮𞤪𞤰𞤭
        kilometer,𞤳𞤥,{0}/𞤳𞤥,{0}𞤳𞤥,{0}𞤳𞤥,𞤳𞤥,{0}/𞤳𞤥,{0} 𞤳𞤥,{0} 𞤳𞤥,𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭,{0} 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭
        light-year,𞤳𞤣,,{0}𞤸𞤣,{0}𞤳𞤣,𞤳𞤭𞤼 𞤲𞤣𞤢𞤴𞤲𞤺𞤵,,{0} 𞤸𞤣,{0} 𞤳𞤣,𞤳𞤭𞤼𞤢𞥄𞤤𞤫-𞤲𞤣𞤢𞤴𞤲𞤺𞤵,,{0} 𞤸𞤭𞤼𞤢𞥄𞤲𞤣𞤫-𞤲𞤣𞤢𞤴𞤲𞤺𞤵,{0} 𞤳𞤭𞤼𞤢𞥄𞤤𞤫-𞤲𞤣𞤢𞤴𞤲𞤺𞤵
        meter,𞤥,{0}/𞤥,{0}𞤥,{0}𞤥,𞤥,{0}/𞤥,{0} 𞤥,{0} 𞤥,𞤥𞤫𞥅𞤼𞤭,{0} 𞤲𞤣𞤫𞤪 𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤥𞤫𞥅𞤼𞤭
        micrometer,𞤻𞤥,,{0}𞤻𞤥,{0}𞤻𞤥,𞤻𞤥𞤫𞥅𞤼𞤭,,{0} 𞤻𞤥,{0} 𞤻𞤥,𞤻𞤭𞤤𞤢𞤥𞤫𞥅𞤼𞤭,,{0} 𞤻𞤭𞤤𞤢𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤻𞤭𞤤𞤢𞤥𞤫𞥅𞤼𞤭
        mile,𞤥𞤢,,{0}𞤥𞤢,{0}𞤥𞤢,𞤥𞤢,,{0} 𞤥𞤢,{0} 𞤥𞤢,𞤥𞤢𞤴𞤤𞤭,,{0} 𞤥𞤢𞤴𞤤𞤵,{0} 𞤥𞤢𞤴𞤤𞤭
        mile-scandinavian,𞤥𞤢𞤧,,{0}𞤥𞤢𞤧,{0}𞤥𞤢𞤧,𞤥𞤢𞤧,,{0} 𞤥𞤢𞤧,{0} 𞤥𞤢𞤧,𞤃𞤢𞤴𞤤𞤵 𞤧𞤭𞤳𞤢𞥄𞤣𞤭𞤲𞤢𞥄𞤾𞤭𞤲𞤳𞤮,,{0} 𞤃𞤢𞤴𞤤𞤵 𞤧𞤭𞤳𞤢𞥄𞤣𞤭𞤲𞤢𞥄𞤾𞤭𞤲𞤳𞤮,{0} 𞤃𞤢𞤴𞤤𞤭 𞤧𞤭𞤳𞤢𞥄𞤣𞤭𞤲𞤢𞥄𞤾𞤭𞤲𞤳𞤮
        millimeter,𞤥𞤥,,{0}𞤥𞤥,{0}𞤥𞤥,𞤥𞤥,,{0} 𞤥𞤥,{0} 𞤥𞤥,𞤥𞤭𞤤𞤭𞤥𞤫𞥅𞤼𞤭,,{0} 𞤥𞤭𞤤𞤭𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤥𞤭𞤤𞤭𞤥𞤫𞥅𞤼𞤭
        nanometer,𞤲𞤥,,{0}𞤲𞤥,{0}𞤲𞤥,𞤲𞤥,,{0} 𞤲𞤥,{0} 𞤲𞤥,𞤲𞤢𞤲𞤮𞥊𞤥𞤫𞥅𞤼𞤭,,{0} 𞤲𞤢𞤲𞤮𞥊𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤲𞤢𞤲𞤮𞥊𞤥𞤫𞥅𞤼𞤭
        nautical-mile,𞤥𞤢𞤥,,{0}𞤥𞤢𞤥,{0}𞤥𞤢𞤥,𞤥𞤢𞤥,,{0} 𞤥𞤢𞤥,{0} 𞤥𞤢𞤥,𞤥𞤢𞤴𞤤𞤭 𞤥𞤢𞥄𞤶𞤫𞤴𞤢𞤲𞤳𞤫,,{0} 𞤥𞤢𞤴𞤤𞤵 𞤥𞤢𞥄𞤶𞤫𞤴𞤢𞤲𞤳𞤮,{0} 𞤥𞤢𞤴𞤤𞤭 𞤥𞤢𞥄𞤶𞤫𞤴𞤢𞤲𞤳𞤮𞥅𞤶𞤭 3.5 𞤥𞤢𞤴𞤤𞤭 𞤥𞤢𞥄𞤶𞤫𞤴𞤢𞤲𞤳𞤫
        parsec,𞤨𞤧,,{0}𞤨𞤧,{0}𞤨𞤧,𞤨𞤧,,{0} 𞤨𞤧,{0} 𞤨𞤧,𞤨𞤢𞤪𞤧𞤫𞤳𞤭,,{0} 𞤨𞤢𞤪𞤧𞤫𞤳𞤵,{0} 𞤨𞤢𞤪𞤧𞤫𞤳𞤭
        picometer,𞤨𞤥,,{0}𞤨𞤥,{0}𞤨𞤥,𞤨𞤥,,{0} 𞤨𞤥,{0} 𞤨𞤥,𞤨𞤭𞤳𞤮𞤥𞤫𞥅𞤼𞤭,,{0} 𞤨𞤭𞤳𞤮𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤨𞤭𞤳𞤮𞤥𞤫𞥅𞤼𞤭
        point,𞤶𞤣𞤭,,{0}𞤶𞤣,{0}𞤶𞤣,𞤶𞤣,,{0} 𞤶𞤣,{0} 𞤶𞤣,𞤲𞤶𞤮𞤣𞥆𞤵𞥅𞤶𞤭,,{0} 𞤲𞤶𞤮𞤣𞥆𞤵,{0} 𞤲𞤶𞤮𞤣𞥆𞤵𞥅𞤶𞤭
        solar-radius,𞤂☉,,{0}𞤂☉,{0}𞤂☉,𞤤𞤢𞥄𞤧𞤮𞤤 𞤲𞤢𞥄𞤲𞤺𞤫𞤴𞤢𞤲𞤳𞤮,,{0} 𞤂☉,{0} 𞤂☉,𞤤𞤢𞥄𞤧𞤮𞤤 𞤲𞤢𞥄𞤲𞤺𞤫𞤴𞤢𞤲𞤳𞤮,,{0} 𞤤𞤢𞥄𞤧𞤭 𞤲𞤢𞥄𞤲𞤺𞤫𞤴𞤢𞤲𞤳𞤮,{0} 𞤤𞤢𞥄𞤧𞤮𞤤 𞤲𞤢𞥄𞤲𞤺𞤫𞤴𞤢𞤲𞤳𞤮
        yard,𞤧𞤺,,{0}𞤧𞤺,{0}𞤧𞤺,𞤧𞤮𞤺𞤮𞤲𞤫,,{0} 𞤧𞤺,{0} 𞤧𞤺,𞤧𞤮𞤺𞤮𞤲𞤫,,{0} 𞤧𞤮𞤺𞤮𞤲𞤢𞤤,{0} 𞤧𞤮𞤺𞤮𞤲𞤫
        candela,𞤶𞤤,,{0}𞤶𞤤,{0}𞤶𞤤,𞤶𞤤,,{0} 𞤶𞤤,{0} 𞤶𞤤,𞤶𞤢𞤤𞤦𞤵𞤤𞤮,,{0} 𞤶𞤢𞤤𞤦𞤮𞤤𞤮,{0} 𞤶𞤢𞤤𞤦𞤮𞤤𞤫
        lumen,𞤲𞤪,,{0}𞤲𞤪,{0}𞤲𞤪,𞤲𞤪,,{0} 𞤲𞤪,{0} 𞤲𞤪,𞤲𞤮𞤪𞤰𞤵,,{0} 𞤲𞤮𞤪𞤰𞤵,{0} 𞤲𞤮𞤪𞤰𞤭
        lux,𞤤𞤵𞤳𞤧𞤭,,{0}𞤤𞤳,{0}𞤤𞤳,𞤤𞤵𞤳𞤧𞤵,,{0} 𞤤𞤳,{0} 𞤤𞤳,𞤤𞤵𞤳𞤧𞤵,,{0} 𞤤𞤵𞤳𞤧𞤵,{0} 𞤤𞤵𞤳𞤧𞤭
        solar-luminosity,𞤂☉,,{0}𞤂☉,{0}𞤂☉,𞤲𞤣𞤢𞤴𞤲𞤺𞤵𞥅𞤶𞤭 𞤲𞤢𞥄𞤺𞤫𞤴𞤢𞤲𞤳𞤮,,,{0} L☉,𞤲𞤣𞤢𞤴𞤲𞤺𞤵𞥅𞤶𞤭 𞤲𞤢𞥄𞤲𞤺𞤫𞤴𞤢𞤲𞤳𞤮,,{0} 𞤲𞤣𞤢𞤴𞤲𞤺𞤵 𞤲𞤢𞥄𞤲𞤺𞤫𞤴𞤢𞤲𞤳𞤮,{0} 𞤲𞤣𞤢𞤴𞤲𞤺𞤵𞥅𞤶𞤭 𞤲𞤢𞥄𞤲𞤺𞤫𞤴𞤢𞤲𞤳𞤮
        carat,𞤳𞤭𞤪𞤭𞤪𞤼𞤵,,{0}𞤑𞤈,{0}𞤑𞤈,𞤳𞤭𞤪𞤭𞤪𞤼𞤭,,{0} 𞤑𞤈,{0} 𞤑𞤈,𞤳𞤭𞤪𞤢𞤪𞤼𞤵,,{0} 𞤳𞤢𞤪𞤢𞤪𞤼𞤵,{0} 𞤳𞤢𞤪𞤢𞤪𞤼𞤭
        dalton,𞤁𞤢,,{0}𞤁𞤢,{0}𞤁𞤢,𞤣𞤢𞤤𞤼𞤮𞥅𞤲𞤭,,{0} 𞤁𞤢,{0} 𞤁𞤢,𞤣𞤢𞤤𞤼𞤮𞥅𞤲𞤭,,{0} 𞤣𞤢𞤤𞤼𞤮𞥅𞤲𞤵,{0} 𞤣𞤢𞤤𞤼𞤮𞥅𞤲𞤭
        earth-mass,𞤐⊕,,{0}𞤐⊕,{0}𞤐⊕,𞤲𞤭𞥅𞤧𞤵𞥅𞤶𞤭 𞤤𞤫𞤴𞤣𞤭 𞤲𞤣𞤭𞤲,,{0} 𞤐⊕,{0} 𞤐⊕,𞤲𞤭𞥅𞤧𞤵𞥅𞤶𞤭 𞤤𞤫𞤴𞤣𞤭 𞤲𞤣𞤭𞤲,,{0} 𞤲𞤭𞥅𞤧𞤵 𞤤𞤫𞤴𞤣𞤭 𞤲𞤣𞤭𞤲,{0} 𞤲𞤭𞥅𞤧𞤵𞥅𞤶𞤭 𞤤𞤫𞤴𞤣𞤭 𞤲𞤣𞤭𞤲
        grain,𞤺𞤰,,{0}𞤺𞤰,{0}𞤺𞤰,𞤺𞤢𞤰𞥆𞤫,,{0} 𞤺𞤰,{0} 𞤺𞤰,𞤺𞤢𞤰𞥆𞤫𞤪𞤫,,{0} 𞤺𞤢𞤰𞥆𞤫𞤪𞤫,{0} 𞤺𞤢𞤰𞥆𞤫
        gram,𞤺𞤢𞤪𞤬𞤵,{0}/𞤺,{0}𞤺,{0}𞤺,𞤺𞤢𞤪𞤬𞤭,{0}/𞤺,{0} 𞤺,{0} 𞤺,𞤺𞤢𞤪𞤬𞤭,{0} 𞤲𞤣𞤫𞤪 𞤺𞤢𞤪𞤬𞤵,{0} 𞤺𞤢𞤪𞤬𞤵,{0} 𞤺𞤢𞤪𞤬𞤭
        kilogram,𞤳𞤺,{0}/𞤳𞤺,{0}𞤳𞤺,{0}𞤳𞤺,𞤳𞤺,{0}/𞤳𞤺,{0} 𞤳𞤺,{0} 𞤳𞤺,𞤳𞤭𞤤𞤮𞤺𞤢𞤪𞤬𞤭,{0} 𞤲𞤣𞤫𞤪 𞤳𞤭𞤤𞤮𞤺𞤢𞤪𞤬𞤵,{0} 𞤳𞤭𞤤𞤮𞤺𞤢𞤪𞤬𞤵,{0} 𞤳𞤭𞤤𞤮𞤺𞤢𞤪𞤬𞤭
        microgram,𞤻𞤺,,{0}𞤻𞤺,{0}𞤻𞤺,𞤻𞤺,,{0} 𞤻𞤺,{0} 𞤻𞤺,𞤻𞤭𞤤𞤢𞤺𞤢𞤪𞤬𞤭,,{0} 𞤻𞤭𞤤𞤢𞤺𞤢𞤪𞤬𞤵,{0} 𞤻𞤭𞤤𞤢𞤺𞤢𞤪𞤬𞤭
        milligram,𞤥𞤺,,{0}𞤥𞤺,{0}𞤥𞤺,𞤥𞤺,,{0} 𞤥𞤺,{0} 𞤥𞤺,𞤥𞤭𞤤𞤭𞤺𞤢𞤪𞤬𞤭,,{0} 𞤥𞤭𞤤𞤭𞤺𞤢𞤪𞤬𞤵,{0} 𞤥𞤭𞤤𞤭𞤺𞤢𞤪𞤬𞤭
        ounce,𞤱𞤺,{0}/𞤱𞤺,{0}𞤱𞤺,{0}𞤱𞤺,𞤱𞤺,{0}/𞤱𞤺,{0} 𞤱𞤺,{0} 𞤱𞤺,𞤱𞤢𞤺𞤭𞤴𞤢𞥄𞤶𞤭,{0} 𞤲𞤣𞤫𞤪 𞤱𞤢𞤺𞤭𞤴𞤢,{0} 𞤱𞤢𞤺𞤭𞤴𞤢,{0} 𞤱𞤢𞤺𞤭𞤴𞤢𞥄𞤶𞤭
        ounce-troy,𞤱𞤺 𞤥𞤳,,{0}𞤱𞤺 𞤥𞤳,{0}𞤱𞤺 𞤥𞤳,𞤱𞤺 𞤥𞤫𞤲𞤳𞤫𞤤𞤣𞤫,,{0} 𞤱𞤺 𞤥𞤳,{0} 𞤱𞤺 𞤥𞤳,𞤱𞤢𞤺𞤭𞤴𞤢𞥄𞤶𞤭 𞤥𞤫𞤲𞤳𞤫𞤤𞤣𞤭,,{0} 𞤱𞤢𞤺𞤭𞤴𞤢 𞤥𞤫𞤲𞤳𞤫𞤤𞤣𞤫,{0} 𞤱𞤢𞤺𞤭𞤴𞤢𞥄𞤶𞤭 𞤥𞤫𞤲𞤳𞤫𞤤𞤣𞤫
        pound,𞤺𞤢𞤪𞤤𞤭,{0}/𞤺𞤤,{0}𞤺𞤤,{0}𞤺𞤤,𞤺𞤢𞤪𞤤𞤭,{0}/𞤺𞤤,{0} 𞤺𞤤,{0} 𞤺𞤤,𞤺𞤢𞤪𞤤𞤭,{0} 𞤲𞤣𞤫𞤪 𞤺𞤢𞤪𞤤𞤵,{0} 𞤺𞤢𞤪𞤤𞤵,{0} 𞤺𞤢𞤪𞤤𞤭
        solar-mass,𞤐☉,,{0}𞤐☉,{0}𞤐☉,𞤲𞤭𞥅𞤧𞤵𞥅𞤶𞤭 𞤲𞤢𞥄𞤲𞤺𞤫,,{0} 𞤐☉,{0} 𞤐☉,𞤲𞤭𞥅𞤧𞤵𞥅𞤶𞤭 𞤲𞤢𞥄𞤲𞤺𞤫,,{0} 𞤲𞤭𞥅𞤧𞤵 𞤲𞤢𞥄𞤲𞤺𞤫 𞤲𞤺𞤫𞤲,{0} 𞤲𞤭𞥅𞤧𞤵𞥅𞤶𞤭 𞤲𞤢𞥄𞤲𞤺𞤫 𞤲𞤺𞤫𞤲
        stone,𞤧𞤭𞤼𞤮𞤲𞤪𞤫,,{0}𞤧𞤼,{0}𞤧𞤼,𞤧𞤭𞤼𞤮𞤲𞤶𞤫,,{0} 𞤧𞤼,{0} 𞤧𞤼,𞤧𞤭𞤼𞤮𞤲𞤪𞤫,,{0} 𞤧𞤭𞤼𞤮𞤲𞤪𞤫,{0} 𞤧𞤭𞤼𞤮𞤲𞤶𞤫
        ton,𞤼𞤮𞥅𞤲𞤵,,{0}𞤼𞤲,{0}𞤼𞤲,𞤼𞤮𞥅𞤲𞤭,,{0} 𞤼𞤲,{0} 𞤼𞤲,𞤼𞤮𞥅𞤲𞤭,,{0} 𞤼𞤮𞥅𞤲𞤵,{0} 𞤼𞤮𞥅𞤲𞤭
        tonne,𞤼,,{0}𞤼,{0}𞤼,𞤼,,{0} 𞤼,{0} 𞤼,𞤼𞤮𞥅𞤲𞤭 𞤥𞤫𞤼𞤭𞤪𞤳𞤵,,{0} 𞤼𞤮𞥅𞤲𞤵 𞤥𞤫𞤼𞤭𞤪𞤳𞤵,{0} 𞤼𞤮𞥅𞤲𞤭 𞤥𞤫𞤼𞤭𞤪𞤳𞤵
        gigawatt,𞤘𞤏,,{0}𞤘𞤏,{0}𞤘𞤏,𞤘𞤏,,{0} 𞤘𞤏,{0} 𞤘𞤏,𞤺𞤭𞤺𞤢𞤱𞤢𞥄𞤼𞤭,,{0} 𞤺𞤭𞤺𞤢𞤱𞤢𞥄𞤼𞤵,{0} 𞤺𞤭𞤺𞤢𞤱𞤢𞥄𞤼𞤭
        horsepower,𞤷𞤨,,{0}𞤷𞤨,{0}𞤷𞤨,𞤷𞤨,,{0} 𞤷𞤨,{0} 𞤷𞤨,𞤷𞤫𞤥𞤦𞤫-𞤨𞤵𞤷𞥆𞤭,,{0} 𞤷𞤫𞤥𞤦𞤫-𞤨𞤵𞤨𞥆𞤵,{0} 𞤷𞤫𞤥𞤦𞤫-𞤨𞤵𞤷𞥆𞤭
        kilowatt,𞤳𞤏,,{0}𞤳𞤏,{0}𞤳𞤏,𞤳𞤏,,{0} 𞤳𞤏,{0} 𞤳𞤏,𞤳𞤭𞤤𞤮𞤱𞤢𞥄𞤼𞤭,,{0} 𞤳𞤭𞤤𞤮𞤱𞤢𞥄𞤼𞤵,{0} 𞤳𞤭𞤤𞤮𞤱𞤢𞥄𞤼𞤭
        megawatt,𞤃𞤏,,{0}𞤃𞤏,{0}𞤃𞤏,𞤃𞤏,,{0} 𞤃𞤏,{0} 𞤃𞤏,𞤥𞤫𞤺𞤢𞤱𞤢𞥄𞤼𞤭,,{0} 𞤥𞤫𞤺𞤢𞤱𞤢𞥄𞤼𞤵,{0} 𞤥𞤫𞤺𞤢𞤱𞤢𞥄𞤼𞤭
        milliwatt,𞤥𞤏,,{0}𞤥𞤏,{0}𞤥𞤏,𞤥𞤏,,{0} 𞤥𞤏,{0} 𞤥𞤏,𞤥𞤭𞤤𞤭𞤱𞤢𞥄𞤼𞤭,,{0} 𞤥𞤭𞤤𞤭𞤱𞤢𞥄𞤼𞤵,{0} 𞤥𞤭𞤤𞤭𞤱𞤢𞥄𞤼𞤭
        watt,𞤱𞤢𞥄𞤼𞤵,,{0}𞤏,{0}𞤏,𞤱𞤢𞥄𞤼𞤭,,{0} 𞤏,{0} 𞤏,𞤱𞤢𞥄𞤼𞤭,,{0} 𞤱𞤢𞥄𞤼𞤵,{0} 𞤱𞤢𞥄𞤼𞤭
        atmosphere,𞤦𞤫𞤧,,{0}𞤦𞤫𞤧,{0}𞤦𞤫𞤧,𞤦𞤫𞤧,,{0} 𞤦𞤫𞤧,{0} 𞤦𞤫𞤧,𞤦𞤫𞤧𞤤𞤮𞥅𞤶𞤭,,{0} 𞤦𞤫𞤧𞤤𞤮𞥅𞤪𞤭,{0} 𞤦𞤫𞤧𞤤𞤮𞥅𞤶𞤭
        bar,𞤦𞤢𞤪,,{0}𞤦𞤢𞤪,{0}𞤦𞤢𞤪,𞤦𞤢𞤪𞤤𞤵,,{0} 𞤦𞤢𞤪,{0} 𞤦𞤢𞤪,𞤦𞤢𞤪𞤤𞤭,,{0} 𞤦𞤢𞤪𞤤𞤵,{0} 𞤦𞤢𞤪𞤤𞤭
        hectopascal,𞤸𞤆𞤢,,{0}𞤸𞤆𞤢,{0}𞤸𞤆𞤢,𞤸𞤆𞤢,,{0} 𞤸𞤆𞤢,{0} 𞤸𞤆𞤢,𞤸𞤫𞤳𞤼𞤮𞤨𞤢𞤧𞤳𞤢𞤤𞤶𞤭,,{0} 𞤸𞤫𞤳𞤼𞤮𞤨𞤢𞤧𞤳𞤢𞤤,{0} 𞤸𞤫𞤳𞤼𞤮𞤨𞤢𞤧𞤳𞤢𞤤𞤶𞤭
        inch-ofhg,𞤺𞤮𞤖𞤺,,{0}𞤺𞤮𞤖𞤺,{0}𞤺𞤮𞤖𞤺,𞤺𞤮𞤖𞤺,,{0} 𞤺𞤮𞤖𞤺,{0} 𞤺𞤮𞤖𞤺,𞤲𞤺𞤮𞤪𞤰𞤭 𞤯𞤫𞤤𞤳𞤮𞥅𞤪𞤭,,{0} 𞤲𞤺𞤮𞤪𞤰𞤵 𞤯𞤫𞤤𞤳𞤮𞥅𞤪𞤭,{0} 𞤲𞤺𞤮𞤪𞤰𞤭 𞤯𞤫𞤤𞤳𞤮𞥅𞤪𞤭
        kilopascal,𞤳𞤆𞤢,,{0}𞤳𞤆𞤢,{0}𞤳𞤆𞤢,𞤳𞤆𞤢,,{0} 𞤳𞤆𞤢,{0} 𞤳𞤆𞤢,𞤳𞤭𞤤𞤮𞤨𞤢𞤧𞤳𞤢𞤤𞤶𞤭,,{0} 𞤳𞤭𞤤𞤮𞤨𞤢𞤧𞤳𞤢𞤤,{0} 𞤳𞤭𞤤𞤮𞤨𞤢𞤧𞤳𞤢𞤤𞤶𞤭
        megapascal,𞤃𞤆𞤢,,{0}𞤃𞤆𞤢,{0}𞤃𞤆𞤢,𞤃𞤆𞤢,,{0} 𞤃𞤆𞤢,{0} 𞤃𞤆𞤢,𞤥𞤫𞤺𞤢𞤨𞤢𞤧𞤳𞤢𞤤𞤶𞤭,,{0} 𞤥𞤫𞤺𞤢𞤨𞤢𞤧𞤳𞤢𞤤,{0} 𞤥𞤫𞤺𞤢𞤨𞤢𞤧𞤳𞤢𞤤𞤶𞤭
        millibar,𞤥𞤦𞤢𞤪,,{0}𞤥𞤦𞤢𞤪,{0}𞤥𞤦𞤢𞤪,𞤥𞤦𞤢𞤪,,{0} 𞤥𞤦𞤢𞤪,{0} 𞤥𞤦𞤢𞤪,𞤥𞤭𞤤𞤭𞤦𞤢𞤪𞤤𞤭,,{0} 𞤥𞤭𞤤𞤭𞤦𞤢𞤪𞤤𞤵,{0} 𞤥𞤭𞤤𞤭𞤦𞤢𞤪𞤤𞤭
        millimeter-ofhg,𞤥𞤥𞤖𞤺,,{0}𞤥𞤥𞤖𞤺,{0}𞤥𞤥𞤖𞤺,𞤥𞤥𞤖𞤺,,{0} 𞤥𞤥𞤖𞤺,{0} 𞤥𞤥𞤖𞤺,𞤥𞤭𞤤𞤭𞤥𞤫𞥅𞤼𞤭 𞤯𞤫𞤤𞤳𞤮𞥅𞤪𞤭,,{0} 𞤥𞤭𞤤𞤭𞤥𞤫𞥅𞤼𞤮𞤤 𞤯𞤫𞤤𞤳𞤮𞥅𞤪𞤭,{0} 𞤥𞤭𞤤𞤭𞤥𞤫𞥅𞤼𞤭 𞤯𞤫𞤤𞤳𞤮𞥅𞤪𞤭
        pascal,𞤆𞤢,,{0}𞤆𞤢,{0}𞤆𞤢,𞤆𞤢,,{0} 𞤆𞤢,{0} 𞤆𞤢,𞤨𞤢𞤧𞤳𞤢𞤤𞤶𞤭,,{0} 𞤨𞤢𞤧𞤷𞤢𞤤,{0} 𞤨𞤢𞤧𞤷𞤢𞤤𞤶𞤭
        pound-force-per-square-inch,𞤺𞤣𞤺𞤮,,{0}𞤺𞤣𞤺𞤮,{0}𞤺𞤣𞤺𞤮,𞤺𞤣𞤺𞤮,,{0} 𞤺𞤣𞤺𞤮,{0} 𞤺𞤣𞤺𞤮,𞤺𞤢𞤪𞤤𞤭 𞤲𞤣𞤫𞤪 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤲𞤺𞤮𞤪𞤰𞤵,,{0} 𞤺𞤢𞤪𞤤𞤵 𞤲𞤣𞤫𞤪 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤲𞤺𞤮𞤪𞤰𞤵,{0} 𞤺𞤢𞤪𞤤𞤭 𞤲𞤣𞤫𞤪 𞤣𞤭𞤲𞤺𞤫𞤪𞤫 𞤲𞤺𞤮𞤪𞤰𞤵
        kilometer-per-hour,𞤳𞤥/𞤶𞤢,,{0}𞤳𞤥/𞤶,{0}𞤳𞤥/𞤶,𞤳𞤥/𞤲𞤶𞤢𞤥𞤣𞤭,,{0} 𞤳𞤥/𞤶,{0} 𞤳𞤥/𞤶,𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭 𞤲𞤣𞤫𞤪 𞤲𞤶𞤢𞤥𞤣𞤭,,{0} 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤮𞤤 𞤲𞤣𞤫𞤪 𞤲𞤶𞤢𞤥𞤣𞤭,{0} 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭 𞤲𞤣𞤫𞤪 𞤲𞤶𞤢𞤥𞤣𞤭
        knot,𞤨𞤩,,{0}𞤨𞤩,{0}𞤨𞤩,𞤨𞤩,,{0} 𞤨𞤩,{0} 𞤨𞤩,𞤨𞤭𞤩𞤭,,{0} 𞤨𞤭𞤩𞤵,{0} 𞤨𞤭𞤩𞤭
        meter-per-second,𞤥/𞤳,,{0}𞤥/𞤳,{0}𞤥/𞤳,𞤥𞤫𞥅𞤼𞤭/𞤳𞤭𞤲,,{0} 𞤥/𞤳,{0} 𞤥/𞤳,𞤥𞤫𞥅𞤼𞤭 𞤲𞤣𞤫𞤪 𞤳𞤭𞤲𞤰𞤫𞤪𞤫,,{0} 𞤥𞤫𞥅𞤼𞤮𞤤 𞤲𞤣𞤫𞤪 𞤳𞤭𞤲𞤰𞤫𞤪𞤫,{0} 𞤥𞤫𞥅𞤼𞤭 𞤲𞤣𞤫𞤪 𞤳𞤭𞤲𞤰𞤫𞤪𞤫
        mile-per-hour,𞤥𞤢/𞤶𞤢,,{0}𞤥𞤢𞥋𞤣𞤶,{0}𞤥𞤢𞥋𞤣𞤶,𞤥𞤢𞤴𞤤𞤭/𞤲𞤶𞤢𞤥𞤲𞤣𞤭,,{0} 𞤥𞤢𞥋𞤣𞤶,{0} 𞤥𞤢𞥋𞤣𞤶,𞤥𞤢𞤴𞤤𞤭 𞤲𞤣𞤫𞤪 𞤲𞤶𞤢𞤥𞤲𞤣𞤭,,{0} 𞤥𞤢𞤴𞤤𞤵 𞤲𞤣𞤫𞤪 𞤲𞤶𞤢𞤥𞤲𞤣𞤭,{0} 𞤥𞤢𞤴𞤤𞤭 𞤲𞤣𞤫𞤪 𞤲𞤶𞤢𞤥𞤲𞤣𞤭
        celsius,°𞤅,,{0}°𞤅,{0}°𞤅,𞤶𞤫𞤩. 𞤅,,{0}°𞤅,{0}°𞤅,𞤶𞤫𞤩𞤫 𞤅𞤫𞤤𞤧𞤭𞥅𞤧𞤵,,{0} 𞤶𞤫𞤩𞤫𞤪𞤫 𞤅𞤫𞤤𞤧𞤭𞥅𞤧𞤵,{0} 𞤶𞤫𞤩𞤫𞤪𞤫 𞤅𞤫𞤤𞤧𞤭𞥅𞤧𞤭
        fahrenheit,𞤶𞤫𞤩. 𞤊,,{0}°𞤊,{0}°𞤊,𞤶𞤫𞤩. 𞤊,,{0}°𞤊,{0}°𞤊,𞤶𞤫𞤩𞤫 𞤊𞤢𞤸𞤪𞤢𞤲𞤫𞤴𞤼𞤵,,{0} 𞤶𞤫𞤩𞤫𞤪𞤫 𞤊𞤢𞤸𞤪𞤢𞤲𞤫𞤴𞤼𞤵,{0} 𞤶𞤫𞤩𞤫 𞤊𞤢𞤸𞤪𞤢𞤲𞤫𞤴𞤼𞤭
        generic,,,,,,,,,𞤶𞤫𞤩𞤫𞤪𞤫,,{0} 𞤶𞤫𞤩𞤫𞤪𞤫,{0} 𞤶𞤫𞤩𞤫
        kelvin,𞤑,,{0}𞤑,{0}𞤑,𞤑,,{0} 𞤑,{0} 𞤑,𞤶𞤫𞤩𞤫 𞤳𞤫𞤤𞤾𞤭𞥅𞤲𞤶𞤭,,{0} 𞤶𞤫𞤩𞤫𞤪𞤫 𞤳𞤫𞤤𞤾𞤭𞥅𞤲,{0} 𞤶𞤫𞤩𞤫 𞤳𞤫𞤤𞤾𞤭𞥅𞤲𞤶𞤭
        newton-meter,𞤐.𞤥,,{0}𞤐.𞤥,{0}𞤐.𞤥,𞤐.𞤥,,{0} 𞤐.𞤥,{0} 𞤐.𞤥,𞤲𞤫𞤱𞤼𞤮𞤲-𞤥𞤫𞥅𞤼𞤭,,{0} 𞤲𞤫𞤱𞤼𞤮𞤲-𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤲𞤫𞤱𞤼𞤮𞤲-𞤥𞤫𞥅𞤼𞤭
        pound-force-foot,𞤺𞤤𞤷.𞤼𞤨,,{0}𞤺𞤤𞤷.𞤼𞤨,{0}𞤺𞤤𞤷.𞤼𞤨,𞤺𞤤𞤷.𞤼𞤨,,{0} 𞤺𞤤𞤷.𞤼𞤨,{0} 𞤺𞤤𞤷.𞤼𞤨,𞤺𞤢𞤪𞤤𞤵-𞤷𞤫𞤥𞤦𞤫-𞤼𞤫𞤨𞥆𞤵,,{0} 𞤺𞤢𞤪𞤤𞤵-𞤷𞤫𞤥𞤦𞤫-𞤼𞤫𞤨𞥆𞤵,{0} 𞤺𞤢𞤪𞤤𞤵-𞤷𞤫𞤥𞤦𞤫-𞤼𞤫𞤨𞥆𞤭
        acre-foot,𞤺𞤢𞤪𞤳𞤵 𞤼𞤨,,{0}𞤺𞤢 𞤼𞤨,{0}𞤺𞤢 𞤼𞤨,𞤺𞤢𞤪𞤳𞤵 𞤼𞤨,,{0} 𞤺𞤢 𞤼𞤨,{0} 𞤺𞤢 𞤼𞤨,𞤺𞤢𞤪𞤳𞤵 𞤼𞤫𞤨𞥆𞤭,,{0} 𞤺𞤢𞤪𞤳𞤵 𞤼𞤫𞤨𞥆𞤵,{0} 𞤺𞤢𞤪𞤳𞤵 𞤼𞤫𞤨𞥆𞤭
        barrel,𞤺𞤮𞤺,,{0}𞤺𞤮𞤺,{0}𞤺𞤮𞤺,𞤺𞤮𞤲𞤺𞤮𞥅𞤪𞤵,,{0} 𞤺𞤮𞤺,{0} 𞤺𞤮𞤺,𞤺𞤮𞤲𞤺𞤮𞥅𞤶𞤭,,{0} 𞤺𞤮𞤲𞤺𞤮𞥅𞤪𞤵,{0} 𞤺𞤮𞤲𞤺𞤮𞥅𞤶𞤭
        bushel,𞤥𞤢𞤤𞤼𞤭,,{0}𞤥𞤼,{0}𞤥𞤼,𞤥𞤢𞤤𞤼𞤭,,{0} 𞤥𞤼,{0} 𞤥𞤼,𞤥𞤢𞤤𞤼𞤭,,{0} 𞤥𞤢𞤤𞤼𞤵,{0} 𞤥𞤢𞤤𞤼𞤭
        centiliter,𞤧𞤤,,{0}𞤧𞤤,{0}𞤧𞤤,𞤧𞤤,,{0} 𞤧𞤤,{0} 𞤧𞤤,𞤧𞤢𞤲𞤼𞤭𞤤𞤭𞥅𞤼𞤭,,{0} 𞤧𞤢𞤲𞤼𞤭𞤤𞤭𞥅𞤼𞤵,{0} 𞤧𞤢𞤲𞤼𞤭𞤤𞤭𞥅𞤼𞤭
        cubic-centimeter,𞤧𞤥𞥓,{0}/𞤧𞤥𞥓,{0}𞤧𞤥𞥓,{0}𞤧𞤥𞥓,𞤧𞤥𞥓,{0}/𞤧𞤥𞥓,{0} 𞤧𞤥𞥓,{0} 𞤧𞤥𞥓,𞤤𞤢𞤥𞤦𞤵 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤭,{0} 𞤲𞤣𞤫𞤪 𞤤𞤢𞤥𞤦𞤵 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤭,{0} 𞤤𞤢𞤥𞤦𞤵 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤤𞤢𞤥𞤦𞤵 𞤧𞤢𞤲𞤼𞤭𞤥𞤫𞥅𞤼𞤭
        cubic-foot,𞤼𞤨𞥓,,{0}𞤼𞤨𞥓,{0}𞤼𞤨𞥓,𞤼𞤫𞤨𞥆𞤭𞥓,,{0} 𞤼𞤨𞥓,{0} 𞤼𞤨𞥓,𞤤𞤢𞤥𞤦𞤵 𞤼𞤫𞤨𞥆𞤭,,{0} 𞤤𞤢𞤥𞤦𞤵 𞤼𞤫𞤨𞥆𞤵,{0} 𞤤𞤢𞤥𞤦𞤵 𞤼𞤫𞤨𞥆𞤭
        cubic-inch,𞤺𞥓,,{0}𞤺𞤮𞥓,{0}𞤺𞤮𞥓,𞤲𞤺𞤮𞤪𞤰𞤭𞥓,,{0} 𞤺𞤮𞥓,{0} 𞤺𞤮𞥓,𞤤𞤢𞤥𞤦𞤵 𞤲𞤺𞤮𞤪𞤰𞤵,,{0} 𞤤𞤢𞤥𞤦𞤵 𞤲𞤺𞤮𞤪𞤰𞤵,{0} 𞤤𞤢𞤥𞤦𞤵 𞤲𞤺𞤮𞤪𞤰𞤭
        cubic-kilometer,𞤳𞤥𞥓,,{0}𞤳𞤥𞥓,{0}𞤳𞤥𞥓,𞤳𞤥𞥓,,{0} 𞤳𞤥𞥓,{0} 𞤳𞤥𞥓,𞤤𞤢𞤥𞤦𞤵 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭,,{0} 𞤤𞤢𞤥𞤦𞤵 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤤𞤢𞤥𞤦𞤵 𞤳𞤭𞤤𞤮𞤥𞤫𞥅𞤼𞤭
        cubic-meter,𞤥𞥓,{0}/𞤥𞥓,{0}𞤥𞥓,{0}𞤥𞥓,𞤥𞥓,{0}/𞤥𞥓,{0} 𞤥𞥓,{0} 𞤥𞥓,𞤤𞤢𞤥𞤦𞤵 𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤲𞤣𞤫𞤪 𞤤𞤢𞤥𞤦𞤵 𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤤𞤢𞤥𞤦𞤵 𞤥𞤫𞥅𞤼𞤮𞤤,{0} 𞤤𞤢𞤥𞤦𞤵 𞤥𞤫𞥅𞤼𞤭
        cubic-mile,𞤥𞤢𞥓,,{0}𞤥𞤢𞥓,{0}𞤥𞤢𞥓,𞤥𞤢𞥓,,{0} 𞤥𞤢𞥓,{0} 𞤥𞤢𞥓,𞤤𞤢𞤥𞤦𞤵 𞤥𞤢𞤴𞤤𞤭,,{0} 𞤤𞤢𞤥𞤦𞤵 𞤥𞤢𞤴𞤤𞤵,{0} 𞤤𞤢𞤥𞤦𞤵 𞤥𞤢𞤴𞤤𞤭
        cubic-yard,𞤧𞤺𞥓,,{0}𞤧𞤺𞥓,{0}𞤧𞤺𞥓,𞤧𞤮𞤺𞤮𞤲𞤫𞥓,,{0} 𞤧𞤺𞥓,{0} 𞤧𞤺𞥓,𞤤𞤢𞤥𞤦𞤵 𞤧𞤮𞤺𞤮𞤲𞤫,,{0} 𞤤𞤢𞤥𞤦𞤵 𞤧𞤮𞤺𞤮𞤲𞤢𞤤,{0} 𞤤𞤢𞤥𞤦𞤵 𞤧𞤮𞤺𞤮𞤲𞤫
        cup,𞤳𞤮𞤪𞤲𞤣𞤮𞥅𞤤𞤮,,{0}𞤳𞤮𞤪,{0}𞤳𞤮𞤪,𞤳𞤮𞤪𞤲𞤣𞤮𞥅𞤤𞤫,,{0} 𞤳𞤮𞤪,{0} 𞤳𞤮𞤪,𞤳𞤮𞤪𞤲𞤣𞤮𞥅𞤤𞤫,,{0} 𞤳𞤮𞤪𞤲𞤣𞤮𞥅𞤤𞤮,{0} 𞤳𞤮𞤪𞤲𞤣𞤮𞥅𞤤𞤫
        cup-metric,𞤳𞤮𞤪𞤥,,{0}𞤳𞤮𞤪𞤥,{0}𞤳𞤮𞤪𞤥,𞤳𞤮𞤪𞤥,,{0} 𞤳𞤮𞤪𞤥,{0} 𞤳𞤮𞤪𞤥,𞤳𞤮𞤪𞤲𞤣𞤮𞥅𞤤𞤫 𞤥𞤫𞤼𞤭𞤪𞤳𞤵,,{0} 𞤳𞤮𞤪𞤲𞤣𞤮𞥅𞤤𞤮 𞤥𞤫𞤼𞤭𞤪𞤳𞤵,{0} 𞤳𞤮𞤪𞤲𞤣𞤮𞥅𞤤𞤫 𞤥𞤫𞤼𞤭𞤪𞤳𞤵
        deciliter,𞤣𞤤,,{0}𞤣𞤤,{0}𞤣𞤤,𞤣𞤤,,{0} 𞤣𞤤,{0} 𞤣𞤤,𞤣𞤫𞥅𞤧𞤭𞤤𞤭𞥅𞤼𞤭,,{0} 𞤣𞤫𞥅𞤧𞤭𞤤𞤭𞥅𞤼𞤵,{0} 𞤣𞤫𞥅𞤧𞤭𞤤𞤭𞥅𞤼𞤭
        dessert-spoon,𞤳𞤤𞤤,,{0}𞤳𞤤𞤤,{0}𞤳𞤤𞤤,𞤳𞤤𞤤,,{0} 𞤳𞤤𞤤,{0} 𞤳𞤤𞤤,𞤳𞤮𞤤𞤬𞤮 𞤤𞤫𞤥𞤰𞤢𞥄𞤪𞤭,,{0} 𞤳𞤮𞤤𞤬𞤮 𞤤𞤫𞤥𞤰𞤢𞥄𞤪𞤭,{0} 𞤳𞤮𞤤𞤬𞤮 𞤤𞤫𞤥𞤰𞤢𞥄𞤪𞤭
        dessert-spoon-imperial,𞤳𞤤𞤤 𞤚𞤭𞤤.,,{0}𞤳𞤤𞤤 𞤚𞤭𞤤.,{0}𞤳𞤤𞤤 𞤚𞤭𞤤.,𞤳𞤤𞤤 𞤚𞤭𞤤.,,{0} 𞤳𞤤𞤤 𞤚𞤭𞤤.,{0} 𞤳𞤤𞤤 𞤚𞤭𞤤.,𞤳𞤮𞤤𞤬𞤮 𞤤𞤫𞤥𞤰𞤢𞥄𞤪𞤭 𞤚𞤭𞤤.,,{0} 𞤳𞤮𞤤𞤬𞤫 𞤤𞤫𞤥𞤰𞤢𞥄𞤪𞤭 𞤚𞤭𞤤.,{0} 𞤳𞤮𞤤𞤬𞤮 𞤤𞤫𞤥𞤰𞤢𞥄𞤪𞤭 𞤚𞤭𞤤.
        dram,𞤣𞤪 𞤧𞤫𞤤,,{0}𞤣𞤪 𞤧𞤫𞤤,{0}𞤣𞤪 𞤧𞤫𞤤,𞤣𞤭𞤪𞤸𞤢𞤥𞤵 𞤧𞤫𞤤𞤦𞤢𞤲,,{0} 𞤣𞤪 𞤧𞤫𞤤,{0} 𞤣𞤪 𞤧𞤫𞤤,𞤣𞤭𞤪𞤸𞤢𞤥𞤵,,{0} 𞤣𞤭𞤪𞤸𞤢𞤥𞤵,{0} 𞤣𞤭𞤪𞤸𞤢𞤥𞤵
        drop,𞤧𞤭𞤲,,{0}𞤧𞤭𞤲,{0}𞤷𞤭𞤲,𞤧𞤭𞤲𞤼𞤫𞤪𞤫,,{0} 𞤧𞤭𞤲,{0} 𞤷𞤭𞤲,𞤧𞤭𞤲𞤼𞤫𞤪𞤫,,{0} 𞤧𞤭𞤲𞤼𞤫𞤪𞤫,{0} 𞤷𞤭𞤲𞤼𞤫
        fluid-ounce,𞤱𞤺 𞤧𞤫𞤤,,{0}𞤱𞤺 𞤧𞤫𞤤,{0}𞤱𞤺 𞤧𞤫𞤤,𞤱𞤺 𞤧𞤫𞤤,,{0} 𞤱𞤺 𞤧𞤫𞤤,{0} 𞤱𞤺 𞤧𞤫𞤤,𞤱𞤢𞤺𞤭𞤴𞤢𞤲𞤯𞤫 𞤧𞤫𞤤𞤦𞤢𞤲,,{0} 𞤱𞤢𞤺𞤭𞤴𞤢𞤲𞤣𞤫 𞤧𞤫𞤤𞤦𞤢𞤲,{0} 𞤱𞤢𞤺𞤭𞤴𞤢𞤲𞤯𞤫 𞤧𞤫𞤤𞤦𞤢𞤲
        fluid-ounce-imperial,𞤱𞤺 𞤧𞤫𞤤 𞤚𞤭𞤤.,,{0}𞤱𞤺 𞤧𞤫𞤤 𞤚𞤭𞤤.,{0}𞤱𞤺 𞤧𞤫𞤤 𞤚𞤭𞤤.,𞤱𞤺 𞤧𞤫𞤤 𞤚𞤭𞤤.,,{0} 𞤱𞤺 𞤧𞤫𞤤 𞤚𞤭𞤤.,{0} 𞤱𞤺 𞤧𞤫𞤤 𞤚𞤭𞤤.,𞤱𞤢𞤺𞤭𞤴𞤢𞤲𞤣𞤫 𞤧𞤫𞤤𞤦𞤢𞤲 𞤚𞤭𞤤𞤧𞤵,,{0} 𞤱𞤢𞤺𞤭𞤴𞤢𞤲𞤣𞤫 𞤧𞤫𞤤𞤦𞤢𞤲 𞤚𞤭𞤤𞤧𞤵,{0} 𞤱𞤢𞤺𞤭𞤴𞤢𞤲𞤯𞤫 𞤧𞤫𞤤𞤦𞤢𞤲 𞤚𞤭𞤤𞤧𞤵
        gallon,𞤺𞤢𞤤,{0}/𞤺𞤢𞤤,{0}𞤺𞤢𞤤,{0}𞤺𞤢𞤤,𞤺𞤢𞤤,{0}/𞤺𞤢𞤤,{0} 𞤺𞤢𞤤,{0} 𞤺𞤢𞤤,𞤺𞤢𞤤𞤮𞤲𞤶𞤭,{0} 𞤲𞤣𞤫𞤪 𞤺𞤢𞤤𞤮𞤲𞤪𞤵,{0} 𞤺𞤢𞤤𞤮𞤲𞤪𞤵,{0} 𞤺𞤢𞤤𞤮𞤲𞤶𞤭
        gallon-imperial,𞤺𞤢𞤤 𞤚𞤭𞤤.,{0}/𞤺𞤢𞤤 𞤚𞤭𞤤.,{0}𞤺𞤢𞤤 𞤚𞤭𞤤.,{0}𞤺𞤢𞤤 𞤚𞤭𞤤.,𞤺𞤢𞤤 𞤚𞤭𞤤.,{0}/𞤺𞤢𞤤 𞤚𞤭𞤤.,{0} 𞤺𞤢𞤤 𞤚𞤭𞤤.,{0} 𞤺𞤢𞤤 𞤚𞤭𞤤.,𞤺𞤢𞤤𞤮𞤲𞤶𞤭 𞤚𞤭𞤤𞤧𞤵,{0} 𞤲𞤣𞤫𞤪 𞤺𞤢𞤤𞤮𞤲𞤪𞤵 𞤚𞤭𞤤𞤧𞤵,{0} 𞤺𞤢𞤤𞤮𞤲𞤪𞤵 𞤚𞤭𞤤𞤧𞤵,{0} 𞤺𞤢𞤤𞤮𞤲𞤶𞤭 𞤚𞤭𞤤𞤧𞤵
        hectoliter,𞤸𞤤,,{0}𞤸𞤤,{0}𞤸𞤤,𞤸𞤤,,{0} 𞤸𞤤,{0} 𞤸𞤤,𞤸𞤫𞤳𞤼𞤮𞤤𞤭𞥅𞤼𞤭,,{0} 𞤸𞤫𞤳𞤼𞤮𞤤𞤭𞥅𞤼𞤵,{0} 𞤸𞤫𞤳𞤼𞤮𞤤𞤭𞥅𞤼𞤭
        jigger,𞤶𞤭𞤺𞥆𞤮,,{0}𞤶𞤭𞤺𞥆𞤮,{0}𞤶𞤭𞤺𞥆𞤫,𞤶𞤭𞤺𞥆𞤮,,{0} 𞤶𞤭𞤺𞥆𞤮,{0} 𞤶𞤭𞤺𞥆𞤮,𞤶𞤭𞤺𞥆𞤫,,{0} 𞤶𞤭𞤺𞥆𞤮,{0} 𞤶𞤭𞤺𞥆𞤫
        liter,𞤤𞤭𞥅𞤼𞤵,{0}/𞤤,{0}𞤤,{0}𞤤,𞤤𞤭𞥅𞤼𞤭,{0}/𞤤,{0} 𞤤,{0} 𞤤,𞤤𞤭𞥅𞤼𞤭,{0} 𞤲𞤣𞤫𞤪 𞤤𞤭𞥅𞤼𞤵,{0} 𞤤𞤭𞥅𞤼𞤵,{0} 𞤤𞤭𞥅𞤼𞤭
        megaliter,𞤃𞤤,,{0}𞤃𞤤,{0}𞤃𞤤,𞤃𞤤,,{0} 𞤃𞤤,{0} 𞤃𞤤,𞤥𞤫𞤺𞤢𞤤𞤭𞥅𞤼𞤵,,{0} 𞤥𞤫𞤺𞤢𞤤𞤭𞥅𞤼𞤵,{0} 𞤥𞤫𞤺𞤢𞤤𞤭𞥅𞤼𞤭
        milliliter,𞤥𞤤,,{0}𞤥𞤤,{0}𞤥𞤤,𞤥𞤤,,{0} 𞤥𞤤,{0} 𞤥𞤤,𞤥𞤭𞤤𞤭𞤤𞤭𞥅𞤼𞤭,,{0} 𞤥𞤭𞤤𞤭𞤤𞤭𞥅𞤼𞤵,{0} 𞤥𞤭𞤤𞤭𞤤𞤭𞥅𞤼𞤭
        pinch,𞤩𞤵𞤷,,{0}𞤩𞤵𞤷,{0}𞤩𞤵𞤷,𞤩𞤵𞤷𞥆𞤢𞤲𞤣𞤫,,{0} 𞤩𞤵𞤷,{0} 𞤩𞤵𞤷,𞤩𞤵𞤷𞥆𞤢𞤲𞤣𞤫,,{0} 𞤩𞤵𞤷𞥆𞤢𞤲𞤣𞤫,{0} 𞤩𞤵𞤷𞥆𞤢𞤲𞤯𞤫
        pint,𞤨𞤼,,{0}𞤨𞤼,{0}𞤨𞤼,𞤨𞤭𞤲𞤼𞤭,,{0} 𞤨𞤼,{0} 𞤨𞤼,𞤨𞤭𞤲𞤼𞤭,,{0} 𞤨𞤭𞤲𞤼𞤵,{0} 𞤨𞤭𞤲𞤼𞤭
        pint-metric,𞤨𞤼𞤥,,{0}𞤨𞤼𞤥,{0}𞤨𞤼𞤥,𞤨𞤼𞤥,,{0} 𞤨𞤼𞤥,{0} 𞤨𞤼𞤥,𞤨𞤭𞤲𞤼𞤭 𞤥𞤫𞤼𞤭𞤪𞤳𞤵,,{0} 𞤨𞤭𞤲𞤼𞤵 𞤥𞤫𞤼𞤭𞤪𞤳𞤵,{0} 𞤨𞤭𞤲𞤼𞤭 𞤥𞤫𞤼𞤭𞤪𞤳𞤵
        quart,𞤳𞤼,,{0}𞤳𞤼,{0}𞤳𞤼,𞤳𞤼𞤭,,{0} 𞤳𞤼,{0} 𞤳𞤼,𞤳𞤮𞤪𞤼𞤭,,{0} 𞤳𞤮𞤪𞤼𞤵,{0} 𞤳𞤮𞤪𞤼𞤭
        quart-imperial,𞤳𞤼 𞤚𞤭𞤤,,{0}𞤳𞤼 𞤚𞤭𞤤.,{0}𞤳𞤼 𞤚𞤭𞤤.,𞤳𞤼 𞤚𞤭𞤤,,{0} 𞤳𞤼 𞤚𞤭𞤤.,{0} 𞤳𞤼 𞤚𞤭𞤤.,𞤳𞤮𞤪𞤼𞤵 𞤚𞤭𞤤𞤧𞤵,,{0} 𞤳𞤮𞤪𞤼𞤵 𞤚𞤭𞤤𞤧𞤵,{0} 𞤳𞤮𞤪𞤼𞤭 𞤚𞤭𞤤𞤧𞤵
        tablespoon,𞤳𞤤𞤻,,{0}𞤳𞤤𞤻,{0}𞤳𞤤𞤻,𞤳𞤤𞤻,,{0} 𞤳𞤤𞤻,{0} 𞤳𞤤𞤻,𞤳𞤮𞤤𞤬𞤫-𞤻𞤢𞥄𞤥𞤣𞤵,,{0} 𞤳𞤮𞤤𞤬𞤮-𞤻𞤢𞥄𞤥𞤣𞤵,{0} 𞤳𞤮𞤤𞤬𞤫-𞤻𞤢𞥄𞤥𞤣𞤵
        teaspoon,𞤳𞤤𞤦,,{0}𞤳𞤤𞤦,{0}𞤳𞤤𞤦,𞤳𞤤𞤦,,{0} 𞤳𞤤𞤦,{0} 𞤳𞤤𞤦,𞤳𞤮𞤤𞤬𞤫-𞤲𞤦𞤢𞤪𞤩𞤵,,{0} 𞤳𞤮𞤤𞤬𞤮-𞤲𞤦𞤢𞤪𞤩𞤵,{0} 𞤳𞤮𞤤𞤬𞤫-𞤲𞤦𞤢𞤪𞤩𞤭
        """.trimIndent()
  }

  private val ff_Adlm_Prefixes: String by lazy {
    """square,{0}𞥒,{0}𞥒,𞤣𞤭𞤲𞤺𞤫𞤪𞤫 {0}
        cubic,{0}𞥓,{0}𞥓,𞤤𞤢𞤥𞤦𞤵 {0}
        times,{0}-{1},{0}-{1},{0}-{1}
        per,,,{0} 𞤲𞤣𞤫𞤪 {1}
        1024p1,𞤑𞤭{0},𞤑𞤭{0},𞤳𞤭𞤦𞤭{0}
        1024p2,𞤃𞤭{0},𞤃𞤭{0},𞤥𞤫𞤦𞤭{0}
        1024p3,𞤘𞤭{0},𞤘𞤭{0},𞤺𞤭𞤦𞤭{0}
        1024p4,𞤚𞤭{0},𞤚𞤭{0},𞤼𞤫𞤦𞤭{0}
        1024p5,𞤆𞤭{0},𞤆𞤭{0},𞤨𞤫𞤦𞤭{0}
        1024p6,𞤉𞤭{0},𞤉𞤭{0},𞤫𞥁𞤦𞤭{0}
        1024p7,𞤟𞤭{0},𞤟𞤭{0},𞥁𞤫𞤦𞤭{0}
        1024p8,𞤒𞤭{0},𞤒𞤭{0},𞤴𞤮𞤦𞤭{0}
        10p-1,𞤣{0},𞤣{0},𞤣𞤫𞥅𞤧𞤭{0}
        10p-12,𞤨{0},𞤨{0},𞤨𞤭𞤳𞤮{0}
        10p-15,𞤬{0},𞤬{0},𞤬𞤫𞤥𞤼𞤮{0}
        10p-18,𞤢{0},𞤢{0},𞤢𞤼𞥆𞤮{0}
        10p-2,𞤧{0},𞤧{0},𞤧𞤢𞤲𞤼𞤭{0}
        10p-21,𞥁{0},𞥁{0},𞥁𞤫𞤨𞤼𞤮{0}
        10p-24,𞤴{0},𞤴{0},𞤴𞤮𞤳𞤼𞤮{0}
        10p-3,𞤥{0},𞤥{0},𞤥𞤭𞤤𞤭{0}
        10p-6,𞤻{0},𞤻𞤭𞤤𞤢{0},𞤻𞤭𞤤𞤢{0}
        10p-9,𞤲{0},𞤲{0},𞤲𞤢𞤲𞤮{0}
        10p1,𞤣𞤢{0},𞤣𞤢{0},𞤣𞤫𞤳𞤢{0}
        10p12,𞤚{0},𞤚{0},𞤼𞤫𞤪𞤢{0}
        10p15,𞤆{0},𞤆{0},𞤨𞤫𞤼𞤢{0}
        10p18,𞤉{0},𞤉{0},𞤫𞥁𞤢{0}
        10p2,𞤸{0},𞤸{0},𞤸𞤫𞤳𞤼𞤮{0}
        10p21,𞤟{0},𞤟{0},𞥁𞤫𞤼𞥆𞤢{0}
        10p24,𞤒{0},𞤒{0},𞤴𞤮𞤼𞥆𞤢{0}
        10p3,𞤳{0},𞤳{0},𞤳𞤭𞤤𞤮{0}
        10p6,𞤃{0},𞤃{0},𞤥𞤫𞤺𞤢{0}
        10p9,𞤘{0},𞤘{0},𞤺𞤭𞤺𞤢{0}
        """.trimIndent()
  }

  private val ff_Adlm_BF_Units: String? = null

  private val ff_Adlm_BF_Prefixes: String? = null

  private val ff_Adlm_CM_Units: String? = null

  private val ff_Adlm_CM_Prefixes: String? = null

  private val ff_Adlm_GH_Units: String? = null

  private val ff_Adlm_GH_Prefixes: String? = null

  private val ff_Adlm_GM_Units: String? = null

  private val ff_Adlm_GM_Prefixes: String? = null

  private val ff_Adlm_GW_Units: String? = null

  private val ff_Adlm_GW_Prefixes: String? = null

  private val ff_Adlm_LR_Units: String? = null

  private val ff_Adlm_LR_Prefixes: String? = null

  private val ff_Adlm_MR_Units: String? = null

  private val ff_Adlm_MR_Prefixes: String? = null

  private val ff_Adlm_NE_Units: String? = null

  private val ff_Adlm_NE_Prefixes: String? = null

  private val ff_Adlm_NG_Units: String? = null

  private val ff_Adlm_NG_Prefixes: String? = null

  private val ff_Adlm_SL_Units: String? = null

  private val ff_Adlm_SL_Prefixes: String? = null

  private val ff_Adlm_SN_Units: String? = null

  private val ff_Adlm_SN_Prefixes: String? = null

  private val ff_Latn_Units: String? = null

  private val ff_Latn_Prefixes: String? = null

  private val ff_Latn_BF_Units: String? = null

  private val ff_Latn_BF_Prefixes: String? = null

  private val ff_Latn_CM_Units: String? = null

  private val ff_Latn_CM_Prefixes: String? = null

  private val ff_Latn_GH_Units: String? = null

  private val ff_Latn_GH_Prefixes: String? = null

  private val ff_Latn_GM_Units: String? = null

  private val ff_Latn_GM_Prefixes: String? = null

  private val ff_Latn_GN_Units: String? = null

  private val ff_Latn_GN_Prefixes: String? = null

  private val ff_Latn_GW_Units: String? = null

  private val ff_Latn_GW_Prefixes: String? = null

  private val ff_Latn_LR_Units: String? = null

  private val ff_Latn_LR_Prefixes: String? = null

  private val ff_Latn_MR_Units: String? = null

  private val ff_Latn_MR_Prefixes: String? = null

  private val ff_Latn_NE_Units: String? = null

  private val ff_Latn_NE_Prefixes: String? = null

  private val ff_Latn_NG_Units: String? = null

  private val ff_Latn_NG_Prefixes: String? = null

  private val ff_Latn_SL_Units: String? = null

  private val ff_Latn_SL_Prefixes: String? = null

  private val fi_Units: String by lazy {
    """g-force,G,,{0}G,{0}G,G,,,{0} G,G-voimat,,{0} G-voima,{0} G-voimaa
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,,,,,metrit per sekunti toiseen,,{0} metri per sekunti toiseen,{0} metriä per sekunti toiseen
        arc-minute,′,,,{0}′,′,,,{0}′,kulmaminuutit,,{0} kulmaminuutti,{0} kulmaminuuttia
        arc-second,″,,,{0}″,″,,,{0}″,kulmasekunnit,,{0} kulmasekunti,{0} kulmasekuntia
        degree,°,,,{0}°,°,,,{0}°,asteet,,{0} aste,{0} astetta
        radian,rad,,{0}rad,{0}rad,,,,,radiaanit,,{0} radiaani,{0} radiaania
        revolution,rev,,{0}rev,{0}rev,,,,,kierros,,{0} kierros,{0} kierrosta
        acre,ac,,{0}ac,{0}ac,ac,,,{0} ac,eekkerit,,{0} eekkeri,{0} eekkeriä
        dunam,dunamit,,{0}dunam,{0}dunam,dunamit,,{0} dunam,{0} dunamia,dunamit,,{0} dunam,{0} dunamia
        hectare,ha,,{0}ha,{0}ha,ha,,,{0} ha,hehtaarit,,{0} hehtaari,{0} hehtaaria
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,,,,,neliösenttimetrit,{0} / neliösenttimetri,{0} neliösenttimetri,{0} neliösenttimetriä
        square-foot,ft²,,{0}ft²,{0}ft²,,,,,neliöjalat,,{0} neliöjalka,{0} neliöjalkaa
        square-inch,in²,{0}/in²,{0}in²,{0}in²,,,,,neliötuumat,{0} / neliötuuma,{0} neliötuuma,{0} neliötuumaa
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,neliökilometrit,{0} / neliökilometri,{0} neliökilometri,{0} neliökilometriä
        square-meter,m²,{0}/m²,{0}m²,{0}m²,,,,,neliömetrit,{0} / neliömetri,{0} neliömetri,{0} neliömetriä
        square-mile,mi²,{0}/mi²,{0}mi²,{0}mi²,,,,,neliömailit,{0} / neliömaili,{0} neliömaili,{0} neliömailia
        square-yard,yd²,,{0}yd²,{0}yd²,,,,,neliöjaardit,,{0} neliöjaardi,{0} neliöjaardia
        item,kohde,,{0} kohde,{0} kohdetta,kohde,,{0} kohde,{0} kohde,kohteet,,{0} kohde,{0} kohdetta
        karat,ka,,{0}ka,{0}ka,ka,,{0} ka,{0} ka,karaatit,,{0} karaatti,{0} karaattia
        milligram-ofglucose-per-deciliter,mg/dl,,{0}mg/dl,{0}mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligrammat desilitrassa,,{0} milligramma desilitrassa,{0} milligrammaa desilitrassa
        millimole-per-liter,mmol/l,,{0}mmol/l,{0}mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,millimoolit litrassa,,{0} millimooli litrassa,{0} millimoolia litrassa
        mole,mol,,{0}mol,{0}mol,mooli,,,{0} mol,moolit,,{0} mooli,{0} moolia
        percent,%,,{0} %,{0} %,%,,{0} %,{0} %,prosentit,,{0} prosentti,{0} prosenttia
        permille,‰,,{0}‰,{0}‰,‰,,{0} ‰,{0} ‰,promillet,,{0} promille,{0} promillea
        permillion,ppm,,{0}ppm,{0}ppm,,,,,miljoonasosat,,{0} miljoonasosa,{0} miljoonasosaa
        permyriad,‱,,{0}‱,{0}‱,peruspiste,,{0} ‱,{0} ‱,peruspiste,,{0} peruspiste,{0} peruspistettä
        portion-per-1e9,,,,,,,,,miljardisosat,,{0} miljardisosa,{0} miljardisosaa
        liter-per-100-kilometer,l/100km,,{0}l/100km,{0}l/100km,l/100 km,,{0} l/100 km,{0} l/100 km,litrat / 100 kilometriä,,{0} litra / 100 km,{0} litraa / 100 km
        liter-per-kilometer,l/km,,{0}l/km,{0}l/km,l/km,,{0} l/km,{0} l/km,litrat / kilometri,,{0} litra / kilometri,{0} litraa / kilometri
        mile-per-gallon,mpg-am,,{0}mpg-am,{0}mpg-am,mpg-am,,{0} mpg-am,{0} mpg-am,mailit / am. gallona,,{0} maili / am. gallona,{0} mailia / am. gallona
        mile-per-gallon-imperial,mpg-br,,{0}mpg-br,{0}mpg-br,mpg-br,,{0} mpg-br,{0} mpg-br,mailit / br. gallona,,{0} maili / br. gallona,{0} mailia / br. gallona
        bit,b,,{0}b,{0}b,b,,{0} b,{0} b,bitit,,{0} bitti,{0} bittiä
        byte,t,,{0}t,{0}t,t,,{0} t,{0} t,tavut,,{0} tavu,{0} tavua
        gigabit,Gb,,{0}Gb,{0}Gb,,,,,gigabitit,,{0} gigabitti,{0} gigabittiä
        gigabyte,Gt,,{0}Gt,{0}Gt,Gt,,{0} Gt,{0} Gt,gigatavut,,{0} gigatavu,{0} gigatavua
        kilobit,kb,,{0}kb,{0}kb,,,,,kilobitit,,{0} kilobitti,{0} kilobittiä
        kilobyte,kt,,{0}kt,{0}kt,kt,,{0} kt,{0} kt,kilotavut,,{0} kilotavu,{0} kilotavua
        megabit,Mb,,{0}Mb,{0}Mb,,,,,megabitit,,{0} megabitti,{0} megabittiä
        megabyte,Mt,,{0}Mt,{0}Mt,Mt,,{0} Mt,{0} Mt,megatavut,,{0} megatavu,{0} megatavua
        petabyte,Pt,,{0}Pt,{0}Pt,Pt,,{0} Pt,{0} Pt,petatavut,,{0} petatavu,{0} petatavua
        terabit,Tb,,{0}Tb,{0}Tb,,,,,terabitit,,{0} terabitti,{0} terabittiä
        terabyte,Tt,,{0}Tt,{0}Tt,Tt,,{0} Tt,{0} Tt,teratavut,,{0} teratavu,{0} teratavua
        century,vs,,{0} vs,{0} vs,vs,,{0} vs,{0} vs,vuosisadat,,{0} vuosisata,{0} vuosisataa
        day,pv,{0}/pv,{0}pv,{0}pv,pv,{0}/pv,{0} pv,{0} pv,päivät,{0} / päivä,{0} päivä,{0} päivää
        decade,,,,,,,,,vuosikymmenet,,{0} vuosikymmen,{0} vuosikymmentä
        hour,t,{0}/t,{0}t,{0}t,t,{0}/t,{0} t,{0} t,tunnit,{0} / tunti,{0} tunti,{0} tuntia
        microsecond,μs,,{0}μs,{0}μs,,,,,mikrosekunnit,,{0} mikrosekunti,{0} mikrosekuntia
        millisecond,ms,,{0}ms,{0}ms,,,,,millisekunnit,,{0} millisekunti,{0} millisekuntia
        minute,min,{0}/min,{0}min,{0}min,,,,,minuutit,{0} / minuutti,{0} minuutti,{0} minuuttia
        month,kk,{0}/kk,{0}kk,{0}kk,kk,{0}/kk,{0} kk,{0} kk,kuukaudet,{0} / kuukausi,{0} kuukausi,{0} kuukautta
        nanosecond,ns,,{0}ns,{0}ns,,,,,nanosekunnit,,{0} nanosekunti,{0} nanosekuntia
        night,yöt,{0}/yö,{0}yö,{0}yöt,yöt,{0}/yö,{0} yö,{0} yö,yöt,{0} / yö,{0} yö,{0} yötä
        quarter,q,{0}/q,,{0} q,q,{0}/q,,{0} q,neljännekset,{0}/neljännes,{0} neljännes,{0} neljännestä
        second,s,{0}/s,{0}s,{0}s,sek,{0}/s,,{0} s,sekunnit,{0} / sekunti,{0} sekunti,{0} sekuntia
        week,vk,{0}/vk,{0}vk,{0}vk,vk,{0}/vk,{0} vk,{0} vk,viikot,{0} / viikko,{0} viikko,{0} viikkoa
        year,v,{0}/v,{0}v,{0}v,v,{0}/v,{0} v,{0} v,vuodet,{0} / vuosi,{0} vuosi,{0} vuotta
        ampere,A,,{0}A,{0}A,A,,,{0} A,ampeerit,,{0} ampeeri,{0} ampeeria
        milliampere,mA,,{0}mA,{0}mA,,,,,milliampeerit,,{0} milliampeeri,{0} milliampeeria
        ohm,Ω,,{0}Ω,{0}Ω,Ω,,,{0} Ω,ohmit,,{0} ohmi,{0} ohmia
        volt,V,,{0}V,{0}V,V,,,{0} V,voltit,,{0} voltti,{0} volttia
        british-thermal-unit,BTU,,{0}Btu,{0}Btu,BTU,,,{0} Btu,brittiläiset termiset yksiköt,,{0} brittiläinen terminen yksikkö,{0} brittiläistä termistä yksikköä
        calorie,cal,,{0}cal,{0}cal,,,,,kalorit,,{0} kalori,{0} kaloria
        electronvolt,eV,,{0}eV,{0}eV,elektronivoltti,,,{0} eV,elektronivoltit,,{0} elektronivoltti,{0} elektronivolttia
        foodcalorie,,,,,,,,,kilokalorit,,{0} kilokalori,{0} kilokaloria
        joule,J,,{0}J,{0}J,J,,,{0} J,joulet,,{0} joule,{0} joulea
        kilocalorie,kcal,,{0}kcal,{0}kcal,,,,,kilokalorit,,{0} kilokalori,{0} kilokaloria
        kilojoule,kJ,,{0}kJ,{0}kJ,,,,,kilojoulet,,{0} kilojoule,{0} kilojoulea
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,,,,,kilowattitunnit,,{0} kilowattitunti,{0} kilowattituntia
        kilowatt-hour-per-100-kilometer,kWh/100 km,,{0}kWh/100 km,{0}kWh/100 km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kilowattitunnit / 100 kilometriä,,{0} kilowattitunti 100 kilometrillä,{0} kilowattituntia 100 kilometrillä
        newton,N,,{0}N,{0}N,newton,,,{0} N,newtonit,,{0} newton,{0} newtonia
        pound-force,lbf,,{0}lbf,{0}lbf,pauna-voima,,,{0} lbf,pauna-voimat,,{0} pauna-voima,{0} pauna-voimaa
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,gigahertsit,,{0} gigahertsi,{0} gigahertsiä
        hertz,Hz,,{0}Hz,{0}Hz,,,,,hertsit,,{0} hertsi,{0} hertsiä
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,kilohertsit,,{0} kilohertsi,{0} kilohertsiä
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,megahertsit,,{0} megahertsi,{0} megahertsiä
        dot,piste,,{0}piste,{0}pistettä,pisteet,,{0} piste,{0} pistettä,pisteet,,{0} piste,{0} pistettä
        dot-per-centimeter,,,,,,,,,pisteet senttimetrillä,,{0} piste senttimetrillä,{0} pistettä senttimetrillä
        dot-per-inch,dpi,,{0}dpi,{0}dpi,dpi,,{0} dpi,{0} dpi,pisteet tuumalla,,{0} piste tuumalla,{0} pistettä tuumalla
        em,em,,{0}em,{0}em,,,,,em-väli,,{0} em-väli,{0} em-väliä
        megapixel,MP,,{0}MP,{0}MP,,,,,megapikselit,,{0} megapikseliä,{0} megapikseliä
        pixel,px,,{0}px,{0}px,,,,,pikselit,,{0} pikseli,{0} pikseliä
        pixel-per-centimeter,ppcm,,{0}ppcm,{0}ppcm,,,,,pikselit/senttimetri,,{0} pikseli / senttimetri,{0} pikseliä / senttimetri
        pixel-per-inch,ppi,,{0}ppi,{0}ppi,,,,,pikselit tuumalla,,{0} pikseli tuumalla,{0} pikseliä tuumalla
        astronomical-unit,au,,{0}au,{0}au,,,,,astronomiset yksiköt,,{0} astronominen yksikkö,{0} astronomista yksikköä
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,senttimetrit,{0} / senttimetri,{0} senttimetri,{0} senttimetriä
        decimeter,dm,,{0}dm,{0}dm,,,,,desimetrit,,{0} desimetri,{0} desimetriä
        earth-radius,R⊕,,{0}R⊕,{0}R⊕,,,,,Maan säteet,,{0} Maan säde,{0} Maan sädettä
        fathom,fm,,{0}fth,{0}fth,fm,,{0} fm,{0} fth,sylet,,{0} syli,{0} syltä
        foot,ft,{0}/′,{0}′,{0}′,,,,,jalat,{0} / jalka,{0} jalka,{0} jalkaa
        furlong,fur,,{0}fur,{0}fur,,,,,furlongit,,{0} furlong,{0} furlongia
        inch,in,{0}/″,{0}″,{0}″,,,,,tuumat,{0} / tuuma,{0} tuuma,{0} tuumaa
        kilometer,km,{0}/km,{0}km,{0}km,,,,,kilometrit,{0} / kilometri,{0} kilometri,{0} kilometriä
        light-year,vv,,{0}vv,{0}vv,vv,,{0} vv,{0} vv,valovuodet,,{0} valovuosi,{0} valovuotta
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,,{0} m,metrit,{0} / metri,{0} metri,{0} metriä
        micrometer,μm,,{0}μm,{0}μm,,,,,mikrometrit,,{0} mikrometri,{0} mikrometriä
        mile,mi,,{0}mi,{0}mi,,,,,mailit,,{0} maili,{0} mailia
        mile-scandinavian,pnk,,{0}pnk,{0}pnk,pnk,,{0} pnk,{0} pnk,peninkulmat,,{0} peninkulma,{0} peninkulmaa
        millimeter,mm,,{0}mm,{0}mm,,,,,millimetrit,,{0} millimetri,{0} millimetriä
        nanometer,nm,,{0}nm,{0}nm,,,,,nanometrit,,{0} nanometri,{0} nanometriä
        nautical-mile,mpk,,{0}mpk,{0}mpk,mpk,,{0} mpk,{0} mpk,meripeninkulmat,,{0} meripeninkulma,{0} meripeninkulmaa
        parsec,pc,,{0}pc,{0}pc,,,,,parsekit,,{0} parsek,{0} parsekia
        picometer,pm,,{0}pm,{0}pm,,,,,pikometrit,,{0} pikometri,{0} pikometriä
        solar-radius,R☉,,{0}R☉,{0}R☉,auringon säteet,,,{0} R☉,auringon säteet,,{0} auringon säde,{0} auringon sädettä
        yard,yd,,{0}yd,{0}yd,,,,,jaardit,,{0} jaardi,{0} jaardia
        candela,cd,,{0}cd,{0}cd,,,,,kandelat,,{0} kandela,{0} kandelaa
        lumen,lm,,{0}lm,{0}lm,,,,,luumenit,,{0} luumen,{0} luumenia
        lux,lx,,{0}lx,{0}lx,,,,,luksit,,{0} luksi,{0} luksia
        solar-luminosity,L☉,,{0}L☉,{0}L☉,Auringon luminositeetit,,,{0} L☉,Auringon luminositeetit,,{0} Auringon luminositeetti,{0} Auringon luminositeettia
        carat,ka,,{0}ka,{0}ka,ka,,{0} ka,{0} ka,karaatit,,{0} karaatti,{0} karaattia
        dalton,Da,,{0}Da,{0}Da,atomimassayksiköt,,,{0} Da,atomimassayksiköt,,{0} atomimassayksikkö,{0} atomimassayksikköä
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,Maan massat,,,{0} M⊕,Maan massat,,{0} Maan massa,{0} Maan massaa
        grain,graanit,,{0}graani,{0}graania,graanit,,{0} graani,{0} graania,graanit,,{0} graani,{0} graania
        gram,g,{0}/g,{0}g,{0}g,g,{0}/g,,{0} g,grammat,{0} / gramma,{0} gramma,{0} grammaa
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,kilogrammat,{0} / kilogramma,{0} kilogramma,{0} kilogrammaa
        microgram,μg,,{0}μg,{0}μg,,,,,mikrogrammat,,{0} mikrogramma,{0} mikrogrammaa
        milligram,mg,,{0}mg,{0}mg,,,,,milligrammat,,{0} milligramma,{0} milligrammaa
        ounce,oz,{0}/oz,{0}oz,{0}oz,,,,,unssit,{0} / unssi,{0} unssi,{0} unssia
        ounce-troy,oz t,,{0}oz t,{0}oz t,,,,,troy-unssit,,{0} troy-unssi,{0} troy-unssia
        pound,lb,{0}/lb,{0}lb,{0}lb,,,,,paunat,{0} / pauna,{0} pauna,{0} paunaa
        solar-mass,M☉,,{0}M☉,{0}M☉,auringon massat,,,{0} M☉,auringon massat,,{0} auringon massa,{0} auringon massaa
        stone,st,,{0}st,{0}st,,,,,stonet,,{0} stone,{0} stonea
        ton,am.tn,,{0}am.tn,{0}am.tn,am. tn,,{0} am. tn,{0} am. tn,am. tonnit,,{0} am. tonni,{0} am. tonnia
        tonne,t,,{0}t,{0}t,,,,,tonnit,,{0} tonni,{0} tonnia
        gigawatt,GW,,{0}GW,{0}GW,,,,,gigawatit,,{0} gigawatti,{0} gigawattia
        horsepower,hv,,{0}hv,{0}hv,hv,,{0} hv,{0} hv,hevosvoimat,,{0} hevosvoima,{0} hevosvoimaa
        kilowatt,kW,,{0}kW,{0}kW,,,,,kilowatit,,{0} kilowatti,{0} kilowattia
        megawatt,MW,,{0}MW,{0}MW,,,,,megawatit,,{0} megawatti,{0} megawattia
        milliwatt,mW,,{0}mW,{0}mW,,,,,milliwatit,,{0} milliwatti,{0} milliwattia
        watt,W,,{0}W,{0}W,W,,,{0} W,watit,,{0} watti,{0} wattia
        atmosphere,atm,,{0}atm,{0}atm,,,,,normaali-ilmakehät,,{0} normaali-ilmakehä,{0} normaali-ilmakehää
        bar,bar,,{0}bar,{0}bar,,,,,baarit,,{0} baari,{0} baaria
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,hehtopascalit,,{0} hehtopascal,{0} hehtopascalia
        inch-ofhg,inHg,,{0}″ Hg,{0}″ Hg,,,,,elohopeatuumat,,{0} elohopeatuuma,{0} elohopeatuumaa
        kilopascal,kPa,,{0}kPa,{0}kPa,,,,,kilopascalit,,{0} kilopascal,{0} kilopascalia
        megapascal,MPa,,{0}MPa,{0}MPa,,,,,megapascalit,,{0} megapascal,{0} megapascalia
        millibar,mbar,,{0}mbar,{0}mbar,,,,,millibaarit,,{0} millibaari,{0} millibaaria
        millimeter-ofhg,mmHg,,{0}mmHg,{0}mmHg,mmHg,,{0} mmHg,{0} mmHg,elohopeamillimetrit,,{0} elohopeamillimetri,{0} elohopeamillimetriä
        pascal,Pa,,{0}Pa,{0}Pa,,,,,pascalit,,{0} pascal,{0} pascalia
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,,,,,paunat / neliötuuma,,{0} pauna / neliötuuma,{0} paunaa / neliötuuma
        beaufort,,,,,,,,,bofori,,{0} bofori,{0} boforia
        kilometer-per-hour,km/h,,{0}km/h,{0}km/h,,,,,kilometrit tunnissa,,{0} kilometri tunnissa,{0} kilometriä tunnissa
        knot,kn,,{0}kn,{0}kn,,,,,solmut,,{0} solmu,{0} solmua
        meter-per-second,m/s,,{0}m/s,{0}m/s,,,,,metrit sekunnissa,,{0} metri sekunnissa,{0} metriä sekunnissa
        mile-per-hour,mi/h,,{0}mi/h,{0}mi/h,,,,,mailit tunnissa,,{0} maili tunnissa,{0} mailia tunnissa
        celsius,°C,,{0}°,{0}°,°C,,{0} °C,{0} °C,celsiusasteet,,{0} celsiusaste,{0} celsiusastetta
        fahrenheit,°F,,{0}°F,{0}°F,°F,,{0} °F,{0} °F,fahrenheitasteet,,{0} fahrenheitaste,{0} fahrenheitastetta
        generic,,,,,,,,,asteet,,{0} aste,{0} astetta
        kelvin,K,,{0}K,{0}K,,,,,kelvinit,,{0} kelvin,{0} kelviniä
        newton-meter,Nm,,{0}Nm,{0}Nm,Nm,,{0} Nm,{0} Nm,newtonmetrit,,{0} newtonmetri,{0} newtonmetriä
        pound-force-foot,lbf⋅ft,,{0}lbf⋅ft,{0}lbf⋅ft,,,,,pauna-jalat,,{0} pauna-jalka,{0} pauna-jalkaa
        acre-foot,ac ft,,{0}ac ft,{0}ac ft,,,,,eekkerijalat,,{0} eekkerijalka,{0} eekkerijalkaa
        barrel,bbl,,{0}bbl,{0}bbl,barrelit,,,{0} bbl,barrelit,,{0} barreli,{0} barrelia
        bushel,bu,,{0}bu,{0}bu,,,,,bushelit,,{0} busheli,{0} bushelia
        centiliter,cl,,{0}cl,{0}cl,cl,,{0} cl,{0} cl,senttilitrat,,{0} senttilitra,{0} senttilitraa
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,kuutiosenttimetrit,{0} / kuutiosenttimetri,{0} kuutiosenttimetri,{0} kuutiosenttimetriä
        cubic-foot,ft³,,{0}ft³,{0}ft³,,,,,kuutiojalat,,{0} kuutiojalka,{0} kuutiojalkaa
        cubic-inch,in³,,{0}in³,{0}in³,,,,,kuutiotuumat,,{0} kuutiotuuma,{0} kuutiotuumaa
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,kuutiokilometrit,,{0} kuutiokilometri,{0} kuutiokilometriä
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,kuutiometrit,{0} / kuutiometri,{0} kuutiometri,{0} kuutiometriä
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,kuutiomailit,,{0} kuutiomaili,{0} kuutiomailia
        cubic-yard,yd³,,{0}yd³,{0}yd³,,,,,kuutiojaardit,,{0} kuutiojaardi,{0} kuutiojaardia
        cup,kp,,{0}kp,{0}kp,kp,,{0} kp,{0} kp,kupit,,{0} kuppi,{0} kuppia
        cup-metric,tkp,,{0}tkp,{0}tkp,tkp,,{0} tkp,{0} tkp,teekupit,,{0} teekuppi,{0} teekuppia
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,desilitrat,,{0} desilitra,{0} desilitraa
        dessert-spoon,jrkl,,{0}jrkl,{0}jrkl,jrkl,,{0} jrkl,{0} jrkl,jälkiruokalusikat,,{0} jälkiruokalusikka,{0} jälkiruokalusikkaa
        dessert-spoon-imperial,br. jrkl,,{0} br. jrkl,{0} br. jrkl,br. jrkl,,{0} br. jrkl,{0} br. jrkl,br. jälkiruokalusikat,,{0} br. jälkiruokalusikka,{0} br. jälkiruokalusikkaa
        dram,dramit,,{0}dram,{0}dramia,dramit,,{0} dram,{0} dramia,dramit,,{0} dram,{0} dramia
        drop,gtt,,{0}gtt,{0}gtt,tipat,,{0} tippa,{0} tippaa,tipat,,{0} tippa,{0} tippaa
        fluid-ounce,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,nesteunssit,,{0} nesteunssi,{0} nesteunssia
        fluid-ounce-imperial,br. nesteunssi,,{0}fl oz br.,{0}fl oz br.,br. nesteunssi,,{0} fl oz br.,{0} fl oz br.,br. nesteunssit,,{0} br. nesteunssi,{0} br. nesteunssia
        gallon,am.gal,{0}/am.gal,{0}am.gal,{0}am.gal,am. gal,{0}/am. gal,{0} am. gal,{0} am. gal,am. gallonat,{0} / am. gallona,{0} am. gallona,{0} am. gallonaa
        gallon-imperial,br.gal,{0}/br.gal,{0}br.gal,{0}br.gal,br. gal,{0}/br. gal,{0} br. gal,{0} br. gal,br. gallonat,{0} / br. gallona,{0} br. gallona,{0} br. gallonaa
        hectoliter,hl,,{0}hl,{0}hl,hl,,{0} hl,{0} hl,hehtolitrat,,{0} hehtolitra,{0} hehtolitraa
        jigger,jiggerit,,{0}jigger,{0}jiggeriä,jiggerit,,{0} jigger,{0} jiggeriä,jiggerit,,{0} jigger,{0} jiggeriä
        liter,l,{0}/l,{0}l,{0}l,l,{0}/l,,{0} l,litrat,{0} / litra,{0} litra,{0} litraa
        megaliter,Ml,,{0}Ml,{0}Ml,Ml,,{0} Ml,{0} Ml,megalitrat,,{0} megalitra,{0} megalitraa
        milliliter,ml,,{0}ml,{0}ml,ml,,{0} ml,{0} ml,millilitrat,,{0} millilitra,{0} millilitraa
        pinch,ripaus,,{0}ripaus,{0}ripausta,ripaus,,{0} ripaus,{0} ripausta,ripaus,,{0} ripaus,{0} ripausta
        pint,pt,,{0}pt,{0}pt,,,,,pintit,,{0} pint,{0} pinttiä
        pint-metric,tp,,{0}tp,{0}tp,tp,,{0} tp,{0} tp,tuopit,,{0} tuoppi,{0} tuoppia
        quart,qt,,{0}qt,{0}qt,,,,,neljännesgallonat,,{0} neljännesgallona,{0} neljännesgallonaa
        quart-imperial,qt br,,{0}qt br.,{0}qt br.,qt br,,{0} qt br.,{0} qt br.,br. neljännesgallonat,,{0} br. neljännesgallona,{0} br. neljännesgallonaa
        tablespoon,rkl,,{0}rkl,{0}rkl,rkl,,{0} rkl,{0} rkl,ruokalusikat,,{0} ruokalusikka,{0} ruokalusikkaa
        teaspoon,tl,,{0}tl,{0}tl,tl,,{0} tl,{0} tl,teelusikat,,{0} teelusikka,{0} teelusikkaa
        therm-us,US therm,,{0}US therm,{0}US therm,,,,,,,,
        point,pt,,{0}pt,{0}pt,,,,,,,,
        """.trimIndent()
  }

  private val fi_Prefixes: String by lazy {
    """square,,,neliö{0}
        cubic,,,kuutio{0}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,eksbi{0}
        1024p7,,,tsebi{0}
        1024p8,,,jobi{0}
        10p-1,,,desi{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,sentti{0}
        10p-21,,,tsepto{0}
        10p-24,,,jokto{0}
        10p-27,,,ronto{0}
        10p-3,,,milli{0}
        10p-30,,,kvekto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,eksa{0}
        10p2,,,hehto{0}
        10p21,,,tsetta{0}
        10p24,,,jotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,kvetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val fil_Units: String by lazy {
    """g-force,g-force,,{0}G,{0}G,,,,,g-force,,{0} g-force,{0} g-force
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,metro/segundo²,,,{0} m/s²,metro kada segundo kwadrado,,{0} metro kada segundo kwadrado,{0} na metro kada segundo kwadrado
        arc-minute,arcmins,,{0}′,{0}′,arcmins,,{0} arcmin,{0} na arcmin,arcminutes,,{0} arcminute,{0} na arcminute
        arc-second,arcsecs,,{0}″,{0}″,arcsecs,,{0} arcsec,{0} na arcsec,arcseconds,,{0} arcsecond,{0} na arcsecond
        degree,deg,,{0} deg,{0} na deg,degrees,,{0} deg,{0} na deg,degrees,,{0} degree,{0} na degree
        radian,radians,,{0}rad,{0}rad,radians,,,{0} rad,radians,,{0} radian,{0} na radian
        revolution,rev,,{0} rev,{0} na rev,rev,,{0} rev,{0} na rev,pag-ikot,,{0} pag-ikot,{0} na pag-ikot
        acre,ektarya,,{0}ac,{0}ac,acres,,,{0} ac,acres,,{0} acre,{0} acres
        hectare,hektarya,,{0}ha,{0}ha,hektarya,,,{0} ha,ektarya,,{0} hektarya,{0} na hektarya
        square-centimeter,,,,,cm²,{0} kada cm²,,{0} cm²,sentimetro kwadrado,{0} kada sentimetro kwadrado,{0} sentimetro kwadrado,{0} na sentimetro kwadrado
        square-foot,ft²,,{0}ft²,{0}ft²,sq feet,,{0} sq ft,{0} sq ft,talampakan parisukat,,{0} talampakan parisukat,{0} na talampakan parisukat
        square-inch,,,,,pulgada²,{0} kada in²,,{0} in²,pulgada kwadrado,{0} kada pulgada kwadrado,{0} pulgada kwadrado,{0} na pulgada kwadrado
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,kilometro kwadrado,{0}/km²,{0} kilometro kwadrado,{0} na kilometro kwadrado
        square-meter,metro²,{0} kada m²,,{0} m²,metro²,{0} kada m²,,{0} m²,metro kwadrado,{0} kada metro kwadrado,{0} metro kwadrado,{0} na metro kwadrado
        square-mile,mi²,{0}/mi²,{0}mi²,{0}mi²,sq mile,{0}/mi²,{0} sq mi,{0} sq mi,milya kwadrado,{0}/mi²,{0} milya kwadrado,{0} na milya kwadrado
        square-yard,,,,,yarda²,,,{0} yd²,yardang parisukat,,{0} yardang parisukat,{0} na yardang parisukat
        item,item,,{0} item,{0}item,,,,,mga item,,{0} item,{0} na item
        karat,karat,,,{0} kt,karat,,,{0} kt,karat,,{0} karat,{0} na karat
        milligram-ofglucose-per-deciliter,,,,,,,,,mg/dL,,{0} milligram per deciliter,{0} milligrams per deciliter
        millimole-per-liter,,,,,,,,,mmol/L,,{0} millimole per liter,{0} millimoles per liter
        mole,,,,,mole,,,{0} mol,mole,,{0} mole,{0} mole
        percent,,,,,,,,,porsyento,,{0} porsyento,{0} na porsyento
        permille,,,,,,,,,permille,,{0} permille,{0} na permille
        permillion,,,,,parts/million,,,{0} ppm,parts per million,,{0} part per million,{0} parts per million
        permyriad,,,,,permyriad,,,{0}‱,permyriad,,{0} permyriad,{0} permyriad
        portion-per-1e9,parts/billion,,{0}ppb,{0}ppb,parts/billion,,,{0} ppb,parts per billion,,{0} part per billion,{0} parts per billion
        liter-per-100-kilometer,L/100km,,{0}L/100km,{0}L/100km,L/100km,,{0} na L/100km,{0} na L/100km,litro kada 100 kilometro,,{0} litro kada 100 kilometro,{0} na litro kada 100 kilometer
        liter-per-kilometer,,,,,litro/km,,,{0} L/km,litro kada kilometro,,{0} litro kada kilometro,{0} litro kada kilometro
        mile-per-gallon,mpg,,{0} mpg,{0}mpg,milya/gal,,{0} mpg,{0} na mpg,milya kada galon,,{0} milya kada galon,{0} na milya kada galon
        mile-per-gallon-imperial,mpg UK,,{0}mpg,{0}mpg,milya/gal Imp.,,,{0} mpg Imp.,milya kada Imp.gallon,,{0} milya kada Imp.galon,{0} milya kada Imp. galon
        bit,,,,,,,,,bits,,{0} bit,{0} na bit
        byte,B,,{0} B,{0} B,,,,,bytes,,{0} byte,{0} na byte
        gigabit,,,,,Gbit,,,{0} Gb,gigabits,,{0} gigabit,{0} na gigabit
        gigabyte,,,,,GByte,,,{0} GB,gigabytes,,{0} gigabyte,{0} na gigabyte
        kilobit,,,,,kbit,,,{0} kb,kilobits,,{0} kilobit,{0} na kilobit
        kilobyte,,,,,kByte,,,{0} kB,kilobytes,,{0} kilobyte,{0} na kilobyte
        megabit,Mbit,,,{0} Mb,Mbit,,,{0} Mb,megabits,,{0} megabit,{0} na megabit
        megabyte,MByte,,,{0} MB,MByte,,,{0} MB,megabytes,,{0} megabyte,{0} na megabyte
        petabyte,PByte,,,{0} PB,PByte,,,{0} PB,petabytes,,{0} petabyte,{0} petabytes
        terabit,Tbit,,,{0} Tb,Tbit,,,{0} Tb,terabits,,{0} terabit,{0} na terabit
        terabyte,TByte,,,{0} TB,TByte,,,{0} TB,terabytes,,{0} terabyte,{0} na terabyte
        century,siglo,,{0} siglo,{0} siglo,siglo,,{0} siglo,{0} siglo,mga siglo,,{0} siglo,{0} siglo
        day,araw,{0}/araw,{0} araw,{0} na araw,araw,{0}/araw,{0} araw,{0} araw,araw,{0} kada araw,{0} araw,{0} na araw
        decade,,,,,,,,,dekada,,{0} dekada,{0} dekada
        hour,oras,{0}/oras,{0} oras,{0} oras,oras,{0} kada oras,{0} oras,{0} na oras,mga oras,{0} kada oras,{0} oras,{0} na oras
        microsecond,μseg,,,{0} μs,μseg,,,{0} μs,mikrosegundo,,{0} mikrosegundo,{0} mikrosegundo
        millisecond,mseg,,{0}ms,{0}ms,miliseg,,,{0} ms,milisegundo,,{0} milisegundo,{0} milisegundo
        minute,min.,{0}/min,{0}m,{0}m,min.,{0}/min,{0} min.,{0} min.,mga minuto,{0} kada minuto,{0} minuto,{0} na minuto
        month,buwan,{0}/buwan,{0}buwan,{0} buwan,buwan,{0}/buwan,{0} buwan,{0} buwan,mga buwan,{0} kada buwan,{0} buwan,{0} buwan
        nanosecond,nanoseg,,,{0} ns,nanoseg,,,{0} ns,nanosegundo,,{0} nanosegundo,{0} nanosegundo
        night,mga gabi,{0}/gabi,{0}gabi,{0}gabi,mga gabi,{0}/gabi,{0} gabi,{0} gabi,mga gabi,{0} kada gabi,{0} gabi,{0} gabi
        quarter,qtr,{0}/q,{0} qtr,{0} qtrs,qtr,{0}/q,{0} qtr,{0} qtrs,mga quarter,{0}/q,{0} qtr,{0} quarter
        second,seg.,{0}/s,{0}s,{0}s,seg.,{0}/s,{0} seg.,{0} seg.,mga segundo,{0} kada segundo,{0} segundo,{0} na segundo
        week,linggo,{0}/linggo,{0}linggo,{0}linggo,linggo,{0}/linggo,{0} linggo,{0} na linggo,mga linggo,{0} kada linggo,{0} linggo,{0} na linggo
        year,taon,{0}/taon,{0}taon,{0}taon,taon,{0}/taon,{0} taon,{0} taon,mga taon,{0} kada taon,{0} taon,{0} na taon
        ampere,,,,,,,,,amperes,,{0} ampere,{0} na ampere
        milliampere,,,,,milliamps,,,{0} mA,milliamperes,,{0} milliampere,{0} na milliampere
        ohm,ohms,,,{0} Ω,ohms,,,{0} Ω,ohms,,{0} ohm,{0} na ohm
        volt,volts,,,{0} V,volts,,,{0} V,volts,,{0} volt,{0} na volt
        british-thermal-unit,BTU,,,{0} Btu,BTU,,,{0} Btu,British thermal unit,,{0} British thermal unit,{0} British thermal unit
        calorie,,,,,,,,,calories,,{0} calorie,{0} na calories
        electronvolt,,,,,electronvolt,,,{0} eV,electronvolt,,{0} electronvolt,{0} electronvolt
        foodcalorie,Cal,,{0} Cal,{0} Cal,Cal,,{0} Cal,{0} Cal,Mga calorie,,{0} Calorie,{0} Calorie
        joule,joules,,,{0} J,joules,,,{0} J,joules,,{0} joule,{0} na joules
        kilocalorie,,,,,,,,,kilocalories,,{0} kilocalorie,{0} na kilocalorie
        kilojoule,kilojoule,,,{0} kJ,kilojoule,,,{0} kJ,kilojoules,,{0} kilojoule,{0} na kilojoule
        kilowatt-hour,,,,,kW-hour,,,{0} kWh,kilowatt-hours,,{0} kilowatt hour,{0} na kilowatt-hour
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0}kWh/100km,,,,,kilowatt-hour bawat 100 kilometro,,{0} kilowatt-hour bawat 100 kilometro,{0} kilowatt-hours bawat 100 kilometro
        newton,,,,,newton,,,{0} N,newton,,{0} newton,{0} newton
        pound-force,,,,,pound-force,,,{0} lbf,pound of force,,{0} pound of force,{0} pound of force
        gigahertz,,,,,,,,,gigahertz,,{0} gigahertz,{0} na gigahertz
        hertz,,,,,,,,,hertz,,{0} hertz,{0} na hertz
        kilohertz,,,,,,,,,kilohertz,,{0} kilohertz,{0} na kilohertz
        megahertz,,,,,,,,,megahertz,,{0} na megahertz,{0} megahertz
        dot,tuldok,,{0} tuldok,{0} tuldok,mga tuldok,,{0} tuldok,{0} tuldok,mga tuldok,,{0} tuldok,{0} tuldok
        dot-per-centimeter,dpcm,,{0} dpcm,{0} dpcm,dpcm,,{0} dpcm,{0} dpcm,tuldok bawat sentimetro,,{0} tuldok bawat sentimetro,{0} tuldok bawat sentimetro
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,tuldok bawat pulgada,,{0} tuldok bawat pulgada,{0} tuldok bawat pulgada
        em,,,,,,,,,tipograpikang em,,,{0} em
        megapixel,megapixel,,,{0} MP,megapixel,,,{0} MP,megapixels,,{0} megapixel,{0} megapixels
        pixel,,,,,mga pixel,,,{0} px,mga pixel,,{0} pixel,{0} pixel
        pixel-per-centimeter,,,,,,,,,mga pixel bawat sentimetro,,{0} pixel bawat sentimetro,{0} pixel bawat sentimetro
        pixel-per-inch,,,,,,,,,mga pixel bawat pulgada,,{0} pixel bawat pulgada,{0} pixel bawat pulgada
        astronomical-unit,au,,{0}au,{0}au,,,,,astronomical units,,{0} astronomical unit,{0} na astronomical units
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,sentimetro,{0} kada sentimetro,{0} sentimetro,{0} sentimetro
        decimeter,,,,,,,,,decimetro,,{0} decimetro,{0} na decimetro
        earth-radius,R⊕,,{0} na R⊕,{0} na R⊕,R⊕,,{0} na R⊕,{0} na R⊕,earth radius,,{0} earth radius,{0} na earth radius
        fathom,fathom,,{0}fth,{0}fth,fathoms,,,{0} fth,fathoms,,{0} fathom,{0} na fathom
        foot,talampakan,{0}/ft,{0}′,{0}′,talampakan,{0}/ft,,{0} ft,talampakan,{0} kada talampakan,{0} talampakan,{0} na talampakan
        furlong,furlong,,{0}fur,{0}fur,furlongs,,,{0} fur,furlongs,,{0} furlong,{0} na furlong
        inch,in,{0}/in,{0}″,{0}″,pulgada,{0}/in,,{0} in,pulgada,{0} kada pulgada,{0} pulgada,{0} na pulgada
        kilometer,km,{0}/km,{0}km,{0}km,,,,,kilometro,{0} kada kilometro,{0} kilometro,{0} na kilometro
        light-year,ly,,{0}ly,{0}ly,light yrs,,{0} ly,{0} na ly,light year,,{0} light year,{0} na light year
        meter,metro,{0}/m,{0}m,{0}m,metro,{0}/m,,{0} m,metro,{0} kada metro,{0} metro,{0} na metro
        micrometer,μmetro,,,{0} μm,μmetro,,,{0} μm,micrometro,,{0} micrometro,{0} micrometro
        mile,mi,,{0}mi,{0}mi,milya,,,{0} mi,milya,,{0} milya,{0} na milya
        mile-scandinavian,smi,,{0}smi,{0}smi,,,,,milya-scandinavian,,{0} milya-scandinavian,{0} na milya-scandinavian
        millimeter,mm,,{0}mm,{0}mm,,,,,milimetro,,{0} milimetro,{0} na milimetro
        nanometer,,,,,,,,,nanometro,,{0} nanometro,{0} nanometro
        nautical-mile,nmi,,{0}nmi,{0}nmi,nmi,,{0} nmi,{0} na nmi,nautical miles,,{0} nautical mile,{0} nautical miles
        parsec,parsecs,,{0}pc,{0}pc,parsecs,,{0} pc,{0} na pc,parsecs,,{0} parsec,{0} parsecs
        picometer,pm,,{0}pm,{0}pm,pm,,{0} pm,{0} na pm,picometer,,{0} picometer,{0} picometer
        point,pts,,{0}pt,{0}pt,puntos,,,{0} pt,puntos,,{0} puntos,{0} puntos
        solar-radius,,,,,solar radii,,,{0} R☉,solar radii,,{0} solar radius,{0} solar radii
        yard,yd,,{0}yd,{0}yd,yarda,,{0} yd,{0} na yd,yarda,,{0} yarda,{0} na yarda
        candela,,,,,,,,,candela,,{0} candela,{0} candela
        lumen,,,,,,,,,lumen,,{0} lumen,{0} lumen
        lux,lux,,,{0} lx,lux,,,{0} lx,lux,,{0} lux,{0} na lux
        solar-luminosity,solar luminosity,,,{0} L☉,solar luminosity,,,{0} L☉,solar luminosity,,{0} solar luminosity,{0} solar luminosity
        carat,karat,,{0}CD,{0}CD,karat,,{0} KD,{0} KD,karat,,{0} karat,{0} karat
        dalton,,,,,dalton,,,{0} Da,dalton,,{0} dalton,{0} dalton
        earth-mass,,,,,Earth mass,,,{0} M⊕,Earth mass,,{0} Earth mass,{0} Earth mass
        grain,butil,,{0} butil,{0} butil,butil,,{0} butil,{0} butil,butil,,{0} butil,{0} butil
        gram,gramo,{0}/g,{0}g,{0}g,gramo,{0}/g,,{0} g,gramo,{0} kada gramo,{0} gramo,{0} na gramo
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,kilo,{0} kada kilo,{0} kilo,{0} kilo
        microgram,μg,,{0}μg,{0}μg,,,,,micrograms,,{0} microgram,{0} micrograms
        milligram,mg,,{0}mg,{0}mg,,,,,milligrams,,{0} milligram,{0} milligrams
        ounce,oz,{0}/oz,{0}oz,{0}oz,,,,,onsa,{0} kada onsa,{0} onsa,{0} na onsa
        ounce-troy,oz troy,,{0}oz t,{0}oz t,oz troy,,,{0} oz t,troy na onsa,,{0} troy na onsa,{0} na troy na onsa
        pound,libra,{0}/lb,{0}#,{0}#,libra,{0}/lb,{0} lb,{0} lbs,libra,{0} kada libra,{0} libra,{0} na libra
        solar-mass,,,,,solar mass,,,{0} M☉,solar mass,,{0} solar mass,{0} solar mass
        stone,stone,,{0}st,{0}st,stones,,,{0} st,stones,,{0} stone,{0} stones
        ton,ton,,{0}tn,{0}tn,tonelada,,,{0} tn,tonelada,,{0} tonelada,{0} tonelada
        tonne,t,,{0}t,{0}t,,,,,mga metriko tonelada,,{0} metriko tonelada,{0} metriko tonelada
        gigawatt,,,,,,,,,gigawatts,,{0} gigawatt,{0} na gigawatt
        horsepower,hp,,{0}hp,{0}hp,,,,,horsepower,,{0} horsepower,{0} horsepower
        kilowatt,kW,,{0}kW,{0}kW,,,,,kilowatts,,{0} kilowatt,{0} kilowatts
        megawatt,,,,,,,,,megawatts,,{0} megawatt,{0} na megawatt
        milliwatt,,,,,,,,,milliwatts,,{0} milliwatt,{0} na milliwatt
        watt,watt,,{0}W,{0}W,watts,,,{0} W,watts,,{0} watt,{0} na watt
        atmosphere,,,,,,,,,atmospheres,,{0} atmosphere,{0} atmospheres
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,hectopascals,,{0} hectopascal,{0} na hectopascal
        inch-ofhg,″ Hg,,{0}'' Hg,{0}'' Hg,in Hg,,,{0} inHg,pulgada ng asoge,,{0} pulgada ng asoge,{0} na pulgada ng asoge
        kilopascal,,,,,,,,,kilopascal,,{0} kilopascal,{0} kilopascal
        megapascal,,,,,,,,,megapascal,,{0} megapascal,{0} megapascal
        millibar,mbar,,{0}mb,{0}mb,mbar,,{0} mb,{0} mb,millibar,,{0} millibar,{0} na millibar
        millimeter-ofhg,mmHg,,{0}mmHg,{0}mmHg,,,,,milimetro ng asoge,,{0} milimetro ng asoge,{0} na milimetro ng asoge
        pascal,,,,,,,,,pascal,,{0} pascal,{0} pascals
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,,,,,libra kada pulgadang parisukat,,{0} libra kada pulgadang parisukat,{0} na libra kada pulgadang parisukat
        beaufort,,,,,,,,,Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,km/hr,,{0}kph,{0}kph,km/hr,,{0} kph,{0} kph,kilometro kada oras,,{0} kilometro kada oras,{0} na kilometro kada oras
        knot,kn,,{0}kn,{0}kn,,,,,knot,,{0} knot,{0} na knot
        meter-per-second,metro/seg,,{0}m/s,{0}m/s,metro/seg,,,{0} m/s,metro kada segundo,,{0} metro kada segundo,{0} metro kada segundo
        mile-per-hour,mi/hr,,{0}mph,{0}mph,milya/oras,,{0} mph,{0} mph,milya kada oras,,{0} milya kada oras,{0} milya kada oras
        celsius,⁰C,,,{0}°C,deg. C,,,{0}°C,degrees Celsius,,{0} degree Celsius,{0} degrees Celsius
        fahrenheit,,,,,deg. F,,,{0}°F,degrees Fahrenheit,,{0} degree Fahrenheit,{0} degrees Fahrenheit
        kelvin,K,,{0}K,{0}K,deg. K,,{0}°K,{0}°K,degrees kelvin,,{0} degree kelvin,{0} degrees kelvin
        newton-meter,,,,,,,,,newton-meter,,{0} newton-meter,{0} newton-meter
        pound-force-foot,,,,,,,,,pound-force-feet,,{0} pound-force-foot,{0} pound-feet
        acre-foot,acre ft,,,{0} ac ft,acre ft,,,{0} ac ft,acre-feet,,{0} acre-foot,{0} acre-feet
        barrel,,,,,bariles,,,{0} bbl,bariles,,{0} bariles,{0} bariles
        bushel,bushel,,,{0} bu,mga bushel,,,{0} bu,mga bushel,,{0} bushel,{0} mga bushel
        centiliter,,,,,,,,,sentilitro,,{0} sentilitro,{0} sentilitro
        cubic-centimeter,,,,,,,,,kubiko sentimetro,{0} kada sentimetro kubiko,{0} kubiko sentimetro,{0} na sentimetro kubiko
        cubic-foot,,,,,talampakan³,,,{0} ft³,kubiko talampakan,,{0} kubiko talampakan,{0} kubiko talampakan
        cubic-inch,,,,,pulgada³,,,{0} in³,kubiko pulgada,,{0} kubiko pulgada,{0} kubiko pulgada
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,kubiko kilometro,,{0} kubiko kilometro,{0} kubiko kilometro
        cubic-meter,,,,,,,,,kubiko metro,{0} kada metro kubiko,{0} kubiko metro,{0} na metro kubiko
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,kubiko milya,,{0} kubiko milya,{0} kubiko milya
        cubic-yard,,,,,yarda³,,,{0} yd³,kubiko yarda,,{0} kubiko yarda,{0} kubiko yarda
        cup,tasa,,,{0} c,tasa,,,{0} c,tasa,,{0} tasa,{0} na tasa
        cup-metric,mcup,,{0} mc,{0} na mc,mcup,,{0} mc,{0} na mc,metric cups,,{0} metric cup,{0} na metric cup
        deciliter,,,,,,,,,decilitro,,{0} decilitro,{0} na decilitro
        dessert-spoon,kutsaritang panghimagas,,{0} dsp,{0} dsp,,,,,kutsarang panghimagas,,{0} kutsarang panghimagas,{0} kutsarang panghimagas
        dessert-spoon-imperial,dsp lmp,,{0}dsp-Imp,{0}dsp-Imp,,,,,Imp. na kutsarang panghimagas,,{0} Imp. na kutsarang panghimagas,{0} Imp. na kutsarang panghimagas
        dram,fl.dr.,,{0}fl.dr.,{0}fl.dr.,,,,,dram,,{0} dram,{0} dram
        drop,patak,,{0} patak,{0} patak,patak,,{0} patak,{0} patak,patak,,{0} patak,{0} patak
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,fluid ounces,,{0} fluid ounce,{0} na fluid ounce
        fluid-ounce-imperial,Imp fl oz,,{0}fl oz Im,{0}fl oz Im,,,,,Imp. fluid ounce,,{0} Imp. fluid ounce,{0} Imp. fluid ounce
        gallon,gal,{0}/gal,{0} gal,{0} na gal,gal,{0}/gal,{0} gal,{0} na gal,galon,{0} kada galon,{0} galon,{0} na galon
        gallon-imperial,,,,,,,,,Imp. gal,{0} kada Imp. galon,,{0} gal Imp.
        hectoliter,,,,,,,,,hektolitro,,{0} hektolitro,{0} hektolitro
        liter,litro,{0}/L,{0}L,{0}L,litro,{0}/l,{0} L,{0} L,litro,{0} kada litro,{0} litro,{0} na litro
        megaliter,,,,,,,,,megalitro,,{0} megalitro,{0} megalitro
        milliliter,,,,,,,,,mililitro,,{0} mililitro,{0} mililitro
        pinch,kurot,,{0} kurot,{0} kurot,karampot,,{0} kurot,{0} kurot,karampot,,{0} kurot,{0} kurot
        pint,pints,,,{0} pt,pints,,,{0} pt,pints,,{0} pint,{0} pints
        pint-metric,pt,,{0} mpt,{0} mpt,mpt,,{0} na mpt,{0} na mpt,metric pints,,{0} metric pint,{0} na metric pint
        quart,qts,,,{0} qt,qts,,,{0} qt,quarts,,{0} quart,{0} na quarts
        quart-imperial,qt Imp,,{0} qt Imp.,{0}qt-Imp.,Imp na kuwart,,,{0} qt Imp.,Imp. na kuwart,,{0} Imp. na kuwart,{0} Imp. na kuwart
        tablespoon,kutsara,,{0} kutsara,{0} kutsara,,,,,kutsara,,{0} kutsara,{0} kutsara
        teaspoon,kutsarita,,{0} kutsarita,{0} kutsarita,,,,,kutsarita,,{0} kutsarita,{0} kutsarita
        jigger,jigger,,{0} jigger,{0}jigger,,,,,,,,
        """.trimIndent()
  }

  private val fil_Prefixes: String by lazy {
    """square,,,{0} kuwadrado
        cubic,,,cubic {0}
        per,,,{0} kada {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobi{0}
        10p-1,,,deci{0}
        10p-12,,,pico{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,milli{0}
        10p-30,,,quecto{0}
        10p-6,,,micro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hecto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val fo_Units: String by lazy {
    """g-force,G-kreftir,,{0}G,{0}G,G-kreftir,,,{0} G,G-kreftir,,{0} G-kraft,{0} G-kreftir
        meter-per-square-second,m/sek²,,{0}m/s²,{0}m/s²,m/sek²,,,{0} m/s²,metrar um sekundi²,,{0} metur um sekundi²,{0} metrar um sekundi²
        arc-minute,bogamin.,,{0}′,{0}′,bogamin.,,{0} bogamin.,{0} bogamin.,bogaminuttir,,{0} bogaminuttur,{0} bogaminuttir
        arc-second,bogasek.,,{0}″,{0}″,bogasek.,,{0} bogasek.,{0} bogasek.,bogasekundir,,{0} bogasekund,{0} bogasekundir
        degree,stig,,{0}°,{0}°,stig,,{0} stig,{0} stig,stig,,{0} stig,{0} stig
        radian,radian,,{0}rad,{0}rad,radian,,,{0} rad,radian,,{0} radian,{0} radianir
        revolution,snú.,,{0}snú.,{0}snú.,snúningar,,{0} snú.,{0} snú.,snúningar,,{0} snúningur,{0} snúningar
        acre,ekrur,,{0}ekra,{0}ekrur,ekrur,,{0} ekra,{0} ekrur,ekrur,,{0} ekra,{0} ekrur
        hectare,ha,,{0}ha,{0}ha,ha,,,{0} ha,hektarar,,{0} hektari,{0} hektarar
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,,,,,fersentimetrar,{0} fyri hvønn fersentimetur,{0} fersentimetur,{0} fersentimetrar
        square-foot,ft²,,{0}ft²,{0}ft²,føtur²,,{0} ft²,{0} ft²,ferføtur,,{0} ferfót,{0} ferføtur
        square-inch,tum.²,{0}/tum.²,{0}tum.²,{0}tum.²,tum.²,{0}/tum.²,{0} tum.²,{0} tum.²,fertummar,{0} fyri hvønn fertumma,{0} fertummi,{0} fertummar
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,ferkilometrar,{0} fyri hvønn ferkilometur,{0} ferkilometur,{0} ferkilometrar
        square-meter,m²,{0}/m²,{0}m²,{0}m²,,,,,fermetrar,{0} fyri hvønn fermetur,{0} fermetur,{0} fermetrar
        square-mile,míl²,{0}/míl²,{0}míl²,{0}míl²,míl²,{0}/míl²,{0} míl²,{0} míl²,fermíl,{0} fyri hvørt fermíl,{0} fermíl,{0} fermíl
        square-yard,yd²,,{0}yd²,{0}yd²,jard²,,{0} yd²,{0} yd²,ferjard,,{0} ferjardur,{0} ferjard
        item,lutur,,{0}lutur,{0} lutir,lutur,,{0} lutur,{0} lutir,lutir,,{0} lutur,{0} lutir
        karat,karat,,{0}Karat,{0}Karat,karat,,{0} Karat,{0} Karat,karat,,{0}Karat,{0} Karat
        milligram-ofglucose-per-deciliter,mg/dl,,{0}mg/dl,{0}mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligramm fyri hvønn desilitur,,{0} milligramm fyri hvønn desilitur,{0} milligramm fyri hvønn desilitur
        millimole-per-liter,mmol/l,,{0}mmol/l,{0}mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,millimol fyri hvønn litur,,{0} millimol fyri hvønn litur,{0} millimol fyri hvønn litur
        percent,%,,{0} %,{0} %,prosent,,{0} %,{0} %,prosent,,{0} prosent,{0} prosent
        permille,‰,,{0}‰,{0}‰,promillur,,{0} ‰,{0} ‰,promillur,,{0} promilla,{0} promillur
        permillion,pt./mill.,,{0}pt./mill,{0}pt./mill,partar/millión,,{0} pt./mill.,{0} pt./mill.,partar fyri hvørja millión,,{0} partur fyri hvørja millión,{0} partar fyri hvørja millión
        permyriad,‱,,{0}‱,{0}‱,promyriad,,{0} ‱,{0} ‱,promyriad,,{0} promyriad,{0} promyriad
        portion-per-1e9,partar/mia.,,{0}part/mia.,{0}partar/mia.,partar/milliard,,{0} part/mia.,{0} partar/mia.,partar fyri hvørja milliard,,{0} part fyri hvørja milliard,{0} partar fyri hvørja milliard
        liter-per-100-kilometer,l/100km,,{0}l/100km,{0}l/100km,l/100 km,,{0} l/100 km,{0} l/100 km,litrar fyri hvørjar 100 kilometrar,,{0} litur fyri hvørjar 100 kilometrar,{0} litrar fyri hvørjar 100 kilometrar
        liter-per-kilometer,l/km,,{0}l/km,{0}l/km,l/km,,{0} l/km,{0} l/km,litrar fyri hvønn kilometrar,,{0} litur fyri hvønn kilometrar,{0} litrar fyri hvønn kilometrar
        mile-per-gallon,míl/gallon,,{0}míl/gallon,{0}míl/gallon,míl/gallon,,{0} míl/gallon,{0} míl/gallon,míl fyri hvønn gallon,,{0} míl fyri hvønn gallon,{0} míl fyri hvønn gallon
        mile-per-gallon-imperial,míl/UK gallon,,{0}míl/UK gallon,{0}míl/UK gallon,míl/UK gallon,,{0} míl/UK gallon,{0} míl/UK gallon,míl fyri hvønn bretska gallon,,{0} míl fyri hvønn bretska gallon,{0} míl fyri hvønn bretska gallon
        byte,B,,{0}B,{0}B,být,,{0} být,{0} být,být,,{0} být,{0} být
        gigabit,gigabit,,{0}Gb,{0}Gb,gigabit,,,{0} Gb,gigabit,,{0} gigabit,{0} gigabit
        gigabyte,gigabýt,,{0}GB,{0}GB,gigabýt,,,{0} GB,gigabýt,,{0} gigabýt,{0} gigabýt
        kilobit,kilobit,,{0}kb,{0}kb,kilobit,,,{0} kb,kilobit,,{0} kilobit,{0} kilobit
        kilobyte,kilobýt,,{0}kB,{0}kB,kilobýt,,,{0} kB,kilobýt,,{0} kilobýt,{0} kilobýt
        megabit,megabit,,{0}Mb,{0}Mb,megabit,,,{0} Mb,megabit,,{0} megabit,{0} megabit
        megabyte,megabýt,,{0}MB,{0}MB,megabýt,,,{0} MB,megabýt,,{0} megabýt,{0} megabýt
        petabyte,PB,,{0}PB,{0}PB,,,,,petabýt,,{0} petabýt,{0} petabýt
        terabit,terabit,,{0}Tb,{0}Tb,terabit,,,{0} Tb,terabit,,{0} terabit,{0} terabit
        terabyte,terabýt,,{0}TB,{0}TB,terabýt,,,{0} TB,terabýt,,{0} terabýt,{0} terabýt
        century,ø.,,{0} ø.,{0} ø.,ø.,,{0} ø.,{0} ø.,øldir,,{0} øld,{0} øldir
        day,d.,{0}/d,{0}d.,{0}d.,dagar,{0}/d.,{0} d.,{0} d.,dagar,{0} um dagin,{0} dagur,{0} dagar
        decade,áratí.,,{0} áratí.,{0} áratí.,áratí.,,{0} áratí.,{0} áratí.,áratíggju,,{0} áratíggju,{0} áratíggju
        hour,t.,{0}/t,{0}t.,{0}t.,tímar,{0}/t.,{0} t.,{0} t.,tímar,{0} um tíman,{0} tími,{0} tímar
        microsecond,mikrosek.,,{0} μs,{0} μs,mikrosek.,,{0} μs.,{0} μs.,mikrosekundir,,{0} mikrosekund,{0} mikrosekundir
        millisecond,ms.,,{0}ms.,{0}ms.,millisek.,,{0} ms.,{0} ms.,millisekundir,,{0} millisekund,{0} millisekundir
        minute,m.,{0}/min,{0}m.,{0}m.,min.,{0}/min.,{0} min.,{0} min.,minuttir,{0} um minuttin,{0} minuttur,{0} minuttir
        month,m.,{0}/m.,{0}m.,{0}m.,mnð.,{0}/m.,{0} mnð.,{0} mnð.,mánaðir,{0} um mánan,{0} mánaður,{0} mánaðir
        nanosecond,,,,,,,,,nanosekundir,,{0} nanosekund,{0} nanosekundir
        night,nætur,{0}/nátt,{0}nátt,{0}nætur,nætur,{0}/nátt,{0} nátt,{0} nætur,nætur,{0}/nátt,{0} nátt,{0} nætur
        quarter,kort.,{0}/kort.,{0}kort.,{0}kort.,korter,{0}/korter,{0} korter,{0} korter,korter,{0}/korter,{0} korter,{0} korter
        second,s.,{0}/s,{0}s.,{0}s.,sek.,{0}/sek.,{0} sek.,{0} sek.,sekundir,{0} um sekundi,{0} sekund,{0} sekundir
        week,v.,{0}/vi.,{0}v.,{0}v.,vikur,{0}/vi.,{0} vi.,{0} vi.,vikur,{0} um vikuna,{0} vika,{0} vikur
        year,ár,{0}/ár,{0}ár,{0}ár,ár,{0}/ár,{0} ár,{0} ár,ár,{0} um ári,{0} ár,{0} ár
        ampere,amp,,{0}A,{0}A,amperur,,,{0} A,amperur,,{0} ampera,{0} amperur
        milliampere,mA,,{0}mA,{0}mA,milliamperur,,,{0} mA,milliamperur,,{0} milliampera,{0} milliamperur
        ohm,ohm,,{0}Ω,{0}Ω,,,,,ohm,,{0} ohm,{0} ohm
        volt,volt,,{0}V,{0}V,,,,,volt,,{0} volt,{0} volt
        british-thermal-unit,BTU,,{0}Btu,{0}Btu,BTU,,,{0} Btu,BTU,,{0} bretsk hitaeind,{0} bretskar hitaeindir
        calorie,kal.,,{0}kal.,{0}kal.,kal.,,{0} kal.,{0} kal.,kaloriur,,{0} kaloria,{0} kaloriur
        electronvolt,eV,,{0}eV,{0}eV,elektronvolt,,,{0} eV,elektronvolt,,{0} elektronvolt,{0} elektronvolt
        foodcalorie,kostkaloriur,,{0}kostkaloria,{0}kostkaloriur,kostkaloriur,,{0} kostkaloria,{0} kostkaloriur,kostkaloriur,,{0} kostkaloria,{0} kostkaloriur
        joule,joule,,{0}J,{0}J,,,,,joule,,{0} joule,{0} joule
        kilocalorie,kcal,,{0}kcal,{0}kcal,,,,,kilokaloriur,,{0} kilokaloria,{0} kilokaloriur
        kilojoule,kJ,,{0}kJ,{0}kJ,kilojoule,,,{0} kJ,kilojoule,,{0} kilojoule,{0} kilojoule
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,,,,,kilowatttímar,,{0} kilowatttími,{0} kilowatttímar
        therm-us,hitaeindir,,{0}thm,{0}thm,hitaeindir,,{0} thm,{0} thm,hitaeindir,,{0} hitaeind,{0} hitaeindir
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0}kWh/100km,,,,,kilowatttímar fyri hvørjar 100 kilometrar,,{0} kilowatttíma fyri hvørjar 100 kilometrar,{0} kilowatttímar fyri hvørjar 100 kilometrar
        newton,N,,{0}N,{0}N,newton,,,{0} N,newton,,{0} newton,{0} newton
        pound-force,lbf,,{0}lbf,{0}lbf,,,,,pund av kraft,,{0} pund av kraft,{0} pund av kraft
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,Hz,,{0}Hz,{0}Hz,,,,,hertz,,{0} hertz,{0} hertz
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,megahertz,,{0} megahertz,{0} megahertz
        dot,punkt,,{0} punkt,{0} punkt,punkt,,{0} punkt,{0} punkt,punkt,,{0} punkt,{0} punkt
        dot-per-centimeter,,,,,,,,,punkt fyri hvønn sentimetur,,{0} punkt fyri hvønn sentimetur,{0} punkt fyri hvønn sentimetur
        dot-per-inch,,,,,,,,,punkt fyri hvønn tumma,,{0} punkt fyri hvønn tumma,{0} punkt fyri hvønn tumma
        em,,,,,,,,,prent em,,,{0} em
        megapixel,megaskíggjadeplar,,,{0} MP,megaskíggjadeplar,,,{0} MP,megaskíggjadeplar,,{0} megaskíggjadepil,{0} megaskíggjadeplar
        pixel,skíggjadeplar,,,{0} px,skíggjadeplar,,,{0} px,skíggjadeplar,,{0} skíggjadeplar,{0} skíggjadeplar
        pixel-per-centimeter,,,,,,,,,skíggjadeplar fyri hvønn sentimetur,,{0} skíggjadeplar fyri hvønn sentimetur,{0} skíggjadeplar fyri hvønn sentimetur
        pixel-per-inch,,,,,,,,,skíggjadeplar fyri hvønn tunna,,{0} skíggjadepil fyri hvønn tunna,{0} skíggjadeplar fyri hvønn tunna
        astronomical-unit,,,,,,,,,stjørnufrøðilig eindir,,{0} stjørnufrøðilig eind,{0} stjørnufrøðiligar eindir
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,sentimetrar,{0} fyri hvønn sentimetur,{0} sentimetur,{0} sentimetrar
        decimeter,,,,,,,,,desimetrar,,{0} desimetur,{0} desimetrar
        earth-radius,radius á jørðuni,,,{0} R⊕,radius á jørðuni,,,{0} R⊕,radius á jørðuni,,{0} radius á jørðuni,{0} radius á jørðuni
        fathom,favnar,,{0} favnur,{0} favnar,favnar,,{0} favnur,{0} favnar,favnar,,{0} favnur,{0} favnar
        foot,føtur,{0}/fót,{0} fótur,{0} føtur,føtur,{0}/fót,{0} fótur,{0} føtur,føtur,{0}/fót,{0} fótur,{0} føtur
        furlong,furlongrar,,{0} furlongur,{0} furlongrar,furlongrar,,{0} furlongur,{0} furlongrar,furlongrar,,{0} furlongur,{0} furlongrar
        inch,tum.,{0}/tum.,{0} tum.,{0} tum.,tum.,{0}/tum.,{0} tum.,{0} tum.,tummar,{0} fyri hvønn tumma,{0} tummi,{0} tummar
        kilometer,km,{0}/km,{0}km,{0}km,,,,,kilometrar,{0} fyri hvønn kilometur,{0} kilometur,{0} kilometrar
        light-year,ljósár,,{0} ljósár,{0} ljósár,ljósár,,{0} ljósár,{0} ljósár,ljósár,,{0} ljósár,{0} ljósár
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,,{0} m,metrar,{0} fyri hvønn metur,{0} metur,{0} metrar
        micrometer,,,,,,,,,mikrometrar,,{0} mikrometur,{0} mikrometrar
        mile,míl,,{0} míl,{0} míl,míl,,{0} míl,{0} míl,míl,,{0} míl,{0} míl
        mile-scandinavian,sk. míl,,{0} sk. míl,{0} sk. míl,sk. míl,,{0} sk. míl,{0} sk. míl,skandinaviskt míl,,{0} skandinaviskt míl,{0} skandinaviskt míl
        millimeter,mm,,{0}mm,{0}mm,,,,,millimetrar,,{0} millimetur,{0} millimetrar
        nanometer,,,,,,,,,nanometrar,,{0} nanometur,{0} nanometrar
        nautical-mile,sm,,{0} sm,{0} sm,sm,,{0} sm,{0} sm,sjómíl,,{0} sjómíl,{0} sjómíl
        parsec,,,,,,,,,parsecs,,{0} parsec,{0} parsecs
        picometer,pm,,{0}pm,{0}pm,,,,,picometrar,,{0} picometur,{0} picometrar
        point,prikkar,,{0} prikkur,{0} prikkar,prikkar,,{0} prikkur,{0} prikkar,prikkar,,{0} prikkur,{0} prikkar
        solar-radius,,,,,sólarradii,,,{0} R☉,sólarradii,,{0} sólarradius,{0} sólarradii
        yard,,,,,,,,,yards,,{0} yard,{0} yards
        candela,cd,,{0}cd,{0}cd,,,,,candela,,{0} candela,{0} candela
        lumen,lumen,,{0}lm,{0}lm,lumen,,,{0} lm,lumen,,{0} lumen,{0} lumen
        lux,luks,,{0}lx,{0}lx,luks,,,{0} lx,luks,,{0} luks,{0} luks
        solar-luminosity,L☉,,{0}L☉,{0}L☉,sólarljósmegi,,,{0} L☉,sólarljósmegi,,{0} sólarljósmegi,{0} sólarljósmegi
        carat,karat,,{0}CD,{0}CD,karat,,,{0} CD,karat,,{0} karat,{0} karat
        dalton,Da,,{0}Da,{0}Da,dalton,,,{0} Da,dalton,,{0} dalton,{0} dalton
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,jarðmassi,,,{0} M⊕,jarðmassi,,{0} jarðmassi,{0} jarðmassar
        grain,gran,,{0}gran,{0}gran,gran,,{0} gran,{0} gran,gran,,{0} gran,{0} gran
        gram,g,{0}/g,{0}g,{0}g,gramm,{0}/g,,{0} g,gramm,{0} fyri hvørt gramm,{0} gramm,{0} gramm
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,kilogramm,{0} fyri hvørt kilogramm,{0} kilogramm,{0} kilogramm
        microgram,μg,,{0}μg,{0}μg,,,,,mikrogramm,,{0} mikrogramm,{0} mikrogramm
        milligram,mg,,{0}mg,{0}mg,,,,,milligramm,,{0} milligramm,{0} milligramm
        ounce,unsur,{0}/unsu,{0}unsa,{0}unsur,unsur,{0}/unsu,{0} unsa,{0} unsur,unsur,{0} fyri hvørja unsu,{0} unsa,{0} unsur
        ounce-troy,troy unsur,,{0}troy unsa,{0} troy unsur,troy unsur,,{0} troy unsa,{0} troy unsur,troy unsur,,{0} troy unsa,{0} troy unsur
        pound,pund,{0}/pund,{0}#,{0}#,pund,{0}/pund,{0} pund,{0} pund,pund,{0} fyri hvørt pund,{0} pund,{0} pund
        solar-mass,M☉,,{0}M☉,{0}M☉,sólarmassi,,,{0} M☉,sólarmassi,,{0} sólarmassi,{0} sólarmassar
        stone,stones,,{0}st,{0}st,stones,,{0} st,{0} st,stones,,{0} st,{0} st
        ton,stutt t,,{0}stutt t,{0}stutt t,stutt t,,{0} stutt t,{0} stutt t,stutt tons,,{0} stutt tons,{0} stutt tons
        tonne,t,,{0}t,{0}t,,,,,tons,,{0} tons,{0} tons
        gigawatt,GW,,{0}GW,{0}GW,,,,,GW,,{0} gigawatt,{0} gigawatt
        horsepower,hk,,{0}hk,{0}hk,hk,,{0} hk,{0} hk,hk,,{0} hestakraft,{0} hestakreftur
        kilowatt,kW,,{0}kW,{0}kW,,,,,kilowatt,,{0} kilowatt,{0} kilowatt
        megawatt,MW,,{0}MW,{0}MW,,,,,megawatt,,{0} megawatt,{0} megawatt
        milliwatt,mW,,{0}mW,{0}mW,,,,,milliwatt,,{0} milliwatt,{0} milliwatt
        watt,watt,,{0}W,{0}W,,,,,watt,,{0} watt,{0} watt
        atmosphere,lufttrýst,,{0}lufttrýst,{0}lufttrýst,lufttrýst,,{0} lufttrýst,{0} lufttrýst,lufttrýst,,{0} lufttrýst,{0} lufttrýst
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,hektopascal,,{0} hektopascal,{0} hektopascal
        inch-ofhg,″ Hg,,{0}″ Hg,{0}″ Hg,tum. Hg,,{0} tum. Hg,{0} tum. Hg,tummar av kviksilvur,,{0} tummi av kviksilvur,{0} tummar av kviksilvur
        kilopascal,kPa,,{0}kPa,{0}kPa,,,,,kilopascal,,{0} kilopascal,{0} kilopascal
        megapascal,MPa,,{0}MPa,{0}MPa,,,,,megapascal,,{0} megapascal,{0} megapascal
        millibar,mbar,,{0}mb,{0}mb,mbar,,{0} mbar,{0} mbar,millibar,,{0} millibar,{0} millibar
        millimeter-ofhg,mmHg,,{0}mmHg,{0}mmHg,mmHg,,{0} mmHg,{0} mmHg,millimetrar av kviksilvur,,{0} millimetur av kviksilvur,{0} millimetrar av kviksilvur
        pascal,Pa,,{0}Pa,{0}Pa,,,,,pascal,,{0} pascal,{0} pascal
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,,,,,pund fyri hvønn kvadrattumma,,pund fyri hvønn kvadrattumma,{0} pund fyri hvønn kvadrattumma
        kilometer-per-hour,km/t,,{0}km/t,{0}km/t,km/t,,{0} km/t,{0} km/t,kilometrar um tíman,,{0} kilometur um tíman,{0} kilometrar um tíman
        knot,smíl/t,,{0}smíl/t,{0}smíl/t,smíl/t,,{0} smíl/t,{0} smíl/t,sjómíl um tíman,,{0} sjómíl um tíman,{0} sjómíl um tíman
        light-speed,ljós,,{0}ljós,{0}ljós,ljós,,{0} ljós,{0} ljós,ljós,,{0} ljós,{0} ljós
        meter-per-second,m/sek,,{0}m/s,{0}m/s,m/sek,,,{0} m/s,metrar um sekundi,,{0} metur um sekundi,{0} metrar um sekundi
        mile-per-hour,míl/tíman,,{0}míl/t,{0}míl/t,míl/tíman,,{0} míl/t,{0} míl/t,míl um tíman,,{0} míl/t,{0} míl/t
        celsius,,,,,,,,,celsiusstig,,{0} celsiusstig,{0} celsiusstig
        fahrenheit,,,,,,,,,fahrenheitstig,,{0} fahrenheitstig,{0} fahrenheitstig
        generic,stig,,,{0}°,stig,,,{0}°,stig,,{0} stig,{0} stig
        kelvin,K,,{0}K,{0}K,,,,,kelvin,,{0} kelvin,{0} kelvin
        newton-meter,N⋅m,,{0}N⋅m,{0}N⋅m,,,,,newtonmetur,,{0} newtonmetur,{0} newtonmetrar
        pound-force-foot,lbf⋅ft,,{0}lbf⋅ft,{0}lbf⋅ft,,,,,pund føtur,,{0} pund fótur,{0} pund føtur
        acre-foot,ekraføtur,,{0} ekrafótur,{0} ekraføtur,ekraføtur,,{0} ekrafótur,{0} ekraføtur,ekraføtur,,{0} ekrafótur,{0} ekraføtur
        barrel,tunna,,{0} tunna,{0} tunnur,tunna,,{0} tunna,{0} tunnur,tunnur,,{0} tunna,{0} tunnur
        bushel,skeppur,,{0} skeppa,{0} skeppur,skeppur,,{0} skeppa,{0} skeppur,skeppur,,{0} skeppa,{0} skeppur
        centiliter,cl,,{0}cl,{0}cl,cl,,{0} cl,{0} cl,sentilitrar,,{0} sentilitur,{0} sentilitrar
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,kubikksentimetrar,{0} fyri hvønn kubikksentimetur,{0} kubikksentimetur,{0} kubikksentimetrar
        cubic-foot,føtur³,,{0} fótur³,{0} føtur³,føtur³,,{0} fótur³,{0} føtur³,kubikkføtur,,{0} kubikkfótur,{0} kubikkføtur
        cubic-inch,tum.³,,{0} tum.³,{0} tum.³,tum.³,,{0} tum.³,{0} tum.³,kubikktummar,,{0} kubikktummi,{0} kubikktummar
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,kubikkkilometrar,,{0} kubikkkilometur,{0} kubikkkilometrar
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,kubikkmetrar,{0} fyri hvønn kubikkmetur,{0} kubikkmetur,{0} kubikkmetrar
        cubic-mile,míl³,,{0} míl³,{0} míl³,míl³,,{0} míl³,{0} míl³,kubikkmíl,,{0} kubikkmíl,{0} kubikkmíl
        cubic-yard,yards³,,{0} yard³,{0} yards³,yards³,,{0} yard³,{0} yards³,kubikkyards,,{0} kubikkyard,{0} kubikkyards
        cup,koppar,,{0} koppur,{0} koppar,koppar,,{0} koppur,{0} koppar,koppar,,{0} koppur,{0} koppar
        cup-metric,metralag koppar,,{0}metralag koppur,{0}metralag koppur,metralag koppar,,{0} metralag koppur,{0} metralag koppar,metralag koppar,,{0} metralag koppur,{0} metralag koppar
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,desilitrar,,{0} desilitur,{0} desilitrar
        dessert-spoon,dessertsk.,,{0} dessertsk.,{0} dessertsk.,dessertsk.,,{0} dessertsk.,{0} dessertsk.,dessertskeið,,{0} dessertskeið,{0} dessertskeiðir
        dessert-spoon-imperial,bretsk dessertsk.,,{0} bretsk dessertsk.,{0} bretskar dessertsk.,bretsk dessertsk.,,{0} bretsk dessertsk.,{0} bretskar dessertsk.,bretsk dessertskeið,,{0} bretsk dessertskeið,{0} bretskar dessertskeiðir
        dram,drammur,,{0} drammur,{0} drammar,drammur,,{0} drammur,{0} drammar,drammur,,{0} drammur,{0} drammar
        drop,dropi,,{0} dropi,{0} dropar,dropi,,{0} dropi,{0} dropar,dropi,,{0} dropi,{0} dropar
        fluid-ounce,flótandi unsur,,{0} flótandi unsa,{0} flótandi unsur,flótandi unsur,,{0} flótandi unsa,{0} flótandi unsur,flótandi unsur,,{0} flótandi unsa,{0} flótandi unsur
        fluid-ounce-imperial,bretskar flótandi unsur,,{0} bretsk flótandi unsa,{0} bretskar flót. unsur,bretskar flótandi unsur,,{0} bretsk flótandi unsa,{0} bretskar flót. unsur,bretskar flótandi unsur,,{0} bretsk flótandi unsa,{0} bretskar flótandi unsur
        gallon,gallons,{0}/gallon,{0} gallon,{0} gallons,gallons,{0}/gallon,{0} gallon,{0} gallons,gallons,{0} fyri hvønn gallon,{0} gallon,{0} gallons
        gallon-imperial,UK gallons,{0}/UK gallon,{0} UK gallon,{0} UK gallons,UK gallons,{0}/UK gallon,{0} UK gallon,{0} UK gallons,bretskar gallons,{0} fyri hvønn bretska gallon,{0} bretskur gallon,{0} bretskar gallons
        hectoliter,hl,,{0}hl,{0}hl,hl,,{0} hl,{0} hl,hektolitrar,,{0} hektolitur,{0} hektolitrar
        jigger,snapsur,,{0} snapsur,{0} snapsar,snapsur,,{0} snapsur,{0} snapsar,snapsur,,{0} snapsur,{0} snapsar
        liter,l,{0}/l,{0}l,{0}l,l,{0}/l,,{0} l,litrar,{0} fyri hvønn litur,{0} litur,{0} litrar
        megaliter,Ml,,{0}Ml,{0}Ml,Ml,,{0} Ml,{0} Ml,megalitrar,,{0} megalitur,{0} megalitrar
        milliliter,ml,,{0}ml,{0}ml,ml,,{0} ml,{0} ml,millilitrar,,{0} millilitur,{0} millilitrar
        pinch,vet,,{0} vet,{0} vet,vet,,{0} vet,{0} vet,vet,,{0} vet,{0} vet
        pint,pints,,{0} pint,{0} pints,pints,,{0} pint,{0} pints,pints,,{0} pint,{0} pints
        pint-metric,metralag pintar,,{0}metralag pintur,{0}metralag pintar,metralag pintar,,{0} metralag pintur,{0} metralag pintar,metralag pintar,,{0} metralag pintur,{0} metralag pintar
        quart,quarts,,{0} quart,{0} quarts,quarts,,{0} quart,{0} quarts,quarts,,{0} quart,{0} quarts
        quart-imperial,bretskur quart,,{0} bretskur quart,{0} bretskir quartar,bretskur quart,,{0} bretskur quart,{0} bretskir quartar,bretskur quart,,{0} bretskur quart,{0} bretskir quartar
        tablespoon,súpisk.,,{0} súpisk.,{0} súpisk.,súpisk.,,{0} súpisk.,{0} súpisk.,súpiskeiðir,,{0} súpiskeið,{0} súpiskeiðir
        teaspoon,tesk.,,{0} tesk.,{0} tesk.,tesk.,,{0} tesk.,{0} tesk.,teskeiðir,,{0} teskeið,{0} teskeiðir
        dunam,dunam,,{0}dunam,{0}dunam,,,,,,,,
        mole,mol,,{0}mol,{0}mol,,,,,,,,
        bit,bit,,{0}bit,{0}bit,,,,,,,,
        bar,bar,,{0}bar,{0}bar,,,,,,,,
        """.trimIndent()
  }

  private val fo_Prefixes: String by lazy {
    """square,,,fer{0}
        cubic,,,kubikk{0}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobe{0}
        10p-1,,,desi{0}
        10p-12,,,pico{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,senti{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,milli{0}
        10p-30,,,quecto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,dam{0},dam{0},deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hekto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val fo_DK_Units: String? = null

  private val fo_DK_Prefixes: String? = null

  private val fr_Units: String by lazy {
    """g-force,G,,{0} force g,{0} force g,force g,,{0} force g,{0} force g,accélération de pesanteur terrestre,,{0} fois l’accélération de pesanteur terrestre,{0} fois l’accélération de pesanteur terrestre
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,m/s²,,{0} m/s²,{0} m/s²,mètres par seconde carrée,,{0} mètre par seconde carrée,{0} mètres par seconde carrée
        arc-minute,′,,,{0}′,′,,,{0}′,minutes d’arc,,{0} minute d’arc,{0} minutes d’arc
        arc-second,″,,,{0}″,″,,,{0}″,secondes d’arc,,{0} seconde d’arc,{0} secondes d’arc
        degree,°,,,{0}°,°,,,{0}°,degrés,,{0} degré,{0} degrés
        radian,rad,,{0} rad,{0} rad,rad,,{0} rad,{0} rad,radians,,{0} radian,{0} radians
        revolution,tr,,{0}tr,{0}tr,tr,,{0} tr,{0} tr,tours,,{0} tour,{0} tours
        acre,ac,,{0}ac,{0}ac,ac,,{0} ac,{0} ac,acres anglo-saxonnes,,{0} acre anglo-saxonne,{0} acres anglo-saxonnes
        dunam,dounam,,{0}dounam,{0}dounams,dounam,,{0} dounam,{0} dounam,dounams,,{0} dounam,{0} dounams
        hectare,ha,,{0}ha,{0}ha,ha,,{0} ha,{0} ha,hectares,,{0} hectare,{0} hectares
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,cm²,{0}/cm²,{0} cm²,{0} cm²,centimètres carrés,{0} par centimètre carré,{0} centimètre carré,{0} centimètres carrés
        square-foot,pi²,,{0}pi²,{0}pi²,pi²,,{0} pi²,{0} pi²,pieds carrés,,{0} pied carré,{0} pieds carrés
        square-inch,po²,{0}/po²,{0}po²,{0}po²,po²,{0}/po²,{0} po²,{0} po²,pouces carrés,{0} par pouce carré,{0} pouce carré,{0} pouces carrés
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,km²,{0}/km²,{0} km²,{0} km²,kilomètres carrés,{0} par kilomètre carré,{0} kilomètre carré,{0} kilomètres carrés
        square-meter,m²,{0}/m²,{0}m²,{0}m²,m²,{0}/m²,{0} m²,{0} m²,mètres carrés,{0} par mètre carré,{0} mètre carré,{0} mètres carrés
        square-mile,mi²,{0}/mi²,{0}mi²,{0}mi²,mi²,{0}/mi²,{0} mi²,{0} mi²,milles carrés,{0} par mille carré,{0} mille carré,{0} milles carrés
        square-yard,yd²,,{0}yd²,{0}yd²,yd²,,{0} yd²,{0} yd²,yards carrés,,{0} yard carré,{0} yards carrés
        item,item,,{0}item,{0}items,item,,{0} items,{0} items,items,,{0} item,{0} items
        karat,ct,,{0}ct,{0}ct,ct,,{0} ct,{0} ct,carats,,{0} carat,{0} carats
        milligram-ofglucose-per-deciliter,mg/dl,,{0}mg/dl,{0}mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligrammes par décilitre,,{0} milligramme par décilitre,{0} milligrammes par décilitre
        millimole-per-liter,mmol/l,,{0}mmol/l,{0}mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,millimoles par litre,,{0} millimole par litre,{0} millimoles par litre
        mole,mol,,{0}mol,{0}mol,mol,,{0} mol,{0} mol,moles,,{0} mole,{0} moles
        percent,%,,{0} %,{0} %,%,,{0} %,{0} %,pour cent,,{0} pour cent,{0} pour cent
        permille,‰,,{0}‰,{0}‰,‰,,{0} ‰,{0} ‰,pour mille,,{0} pour mille,{0} pour mille
        permillion,ppm,,{0}ppm,{0}ppm,ppm,,{0} ppm,{0} ppm,parts par million,,{0} part par million,{0} parts par million
        permyriad,‱,,{0}‱,{0}‱,‱,,{0} ‱,{0} ‱,pour dix mille,,{0} pour dix mille,{0} pour dix mille
        portion-per-1e9,ppb,,{0}ppb,{0}ppb,,,,,parts par milliard,,{0} part par milliard,{0} parts par milliard
        liter-per-100-kilometer,l/100km,,{0}l/100km,{0}l/100km,l/100 km,,{0} l/100 km,{0} l/100 km,litres aux 100 km,,{0} litre aux 100 km,{0} litres aux 100 km
        liter-per-kilometer,l/km,,{0}l/km,{0}l/km,l/km,,{0} l/km,{0} l/km,litres au kilomètre,,{0} litre au kilomètre,{0} litres au kilomètre
        mile-per-gallon,mi/gal,,{0}mi/gal,{0}mi/gal,mi/gal,,{0} mi/gal,{0} mi/gal,miles par gallon,,{0} mile par gallon,{0} miles par gallon
        mile-per-gallon-imperial,mi/gal imp.,,{0}mi/gal imp.,{0}mi/gal imp.,mi/gal imp.,,{0} mi/gal imp.,{0} mi/gal imp.,miles par gallon impérial,,{0} mile par gallon impérial,{0} miles par gallon impérial
        bit,bit,,{0}bit,{0}bit,bit,,{0} bit,{0} bit,bits,,{0} bit,{0} bits
        byte,o,,{0}o,{0}o,octet,,{0} o,{0} o,octets,,{0} octet,{0} octets
        gigabit,Gbit,,{0}Gbit,{0}Gbit,Gbit,,{0} Gbit,{0} Gbit,gigabits,,{0} gigabit,{0} gigabits
        gigabyte,Go,,{0}Go,{0}Go,Go,,{0} Go,{0} Go,gigaoctets,,{0} gigaoctet,{0} gigaoctets
        kilobit,kbit,,{0}kbit,{0}kbit,kbit,,{0} kbit,{0} kbit,kilobits,,{0} kilobit,{0} kilobits
        kilobyte,ko,,{0}ko,{0}ko,ko,,{0} ko,{0} ko,kilooctets,,{0} kilooctet,{0} kilooctets
        megabit,Mbit,,{0}Mbit,{0}Mbit,Mbit,,{0} Mbit,{0} Mbit,mégabits,,{0} mégabit,{0} mégabits
        megabyte,Mo,,{0}Mo,{0}Mo,Mo,,{0} Mo,{0} Mo,mégaoctets,,{0} mégaoctet,{0} mégaoctets
        petabyte,Po,,{0}Po,{0}Po,Po,,{0} Po,{0} Po,pétaoctets,,{0} pétaoctet,{0} pétaoctets
        terabit,Tbit,,{0}Tbit,{0}Tbit,Tbit,,{0} Tbit,{0} Tbit,térabits,,{0} térabit,{0} térabits
        terabyte,To,,{0}To,{0}To,To,,{0} To,{0} To,téraoctets,,{0} téraoctet,{0} téraoctets
        century,s.,,{0}s.,{0}s.,s.,,{0} s.,{0} s.,siècles,,{0} siècle,{0} siècles
        day,j,{0}/j,{0}j,{0}j,j,{0}/j,{0} j,{0} j,jours,{0} par jour,{0} jour,{0} jours
        decade,déc.,,{0}déc.,{0}déc.,décennies,,{0} déc.,{0} déc.,décennies,,{0} décennie,{0} décennies
        hour,h,{0}/h,{0}h,{0}h,h,{0}/h,{0} h,{0} h,heures,{0} par heure,{0} heure,{0} heures
        microsecond,μs,,{0}μs,{0}μs,μs,,{0} μs,{0} μs,microsecondes,,{0} microseconde,{0} microsecondes
        millisecond,ms,,{0}ms,{0}ms,ms,,{0} ms,{0} ms,millisecondes,,{0} milliseconde,{0} millisecondes
        minute,min,{0}/min,{0}min,{0}min,min,{0}/min,{0} min,{0} min,minutes,{0} par minute,{0} minute,{0} minutes
        month,m.,{0}/m.,{0}m.,{0}m.,m.,{0}/m.,{0} m.,{0} m.,mois,{0} par mois,{0} mois,{0} mois
        nanosecond,ns,,{0}ns,{0}ns,ns,,{0} ns,{0} ns,nanosecondes,,{0} nanoseconde,{0} nanosecondes
        night,nuits,{0}/nuit,{0}nuit,{0}nuits,nuits,{0}/nuit,{0} nuit,{0} nuits,nuits,{0} par nuit,{0} nuit,{0} nuits
        quarter,T,{0}/T,{0} T,{0} T,trim.,{0}/trim.,{0} trim.,{0} trim.,trimestres,{0}/trimestre,{0} trimestre,{0} trimestres
        second,s,{0}/s,{0}s,{0}s,s,{0}/s,{0} s,{0} s,secondes,{0} par seconde,{0} seconde,{0} secondes
        week,sem.,{0}/sem.,{0}sem.,{0}sem.,sem.,{0}/sem.,{0} sem.,{0} sem.,semaines,{0} par semaine,{0} semaine,{0} semaines
        year,a,{0}/a,{0}a,{0}a,ans,{0}/an,{0} an,{0} ans,ans,{0} par an,{0} an,{0} ans
        ampere,A,,{0}A,{0}A,A,,{0} A,{0} A,ampères,,{0} ampère,{0} ampères
        milliampere,mA,,{0}mA,{0}mA,mA,,{0} mA,{0} mA,milliampères,,{0} milliampère,{0} milliampères
        ohm,Ω,,{0}Ω,{0}Ω,Ω,,{0} Ω,{0} Ω,ohms,,{0} ohm,{0} ohms
        volt,V,,{0}V,{0}V,V,,{0} V,{0} V,volts,,{0} volt,{0} volts
        british-thermal-unit,BTU,,{0}Btu,{0}Btu,BTU,,{0} Btu,{0} Btu,British Thermal Units,,{0} British Thermal Unit,{0} British Thermal Units
        calorie,cal,,{0}cal,{0}cal,cal,,{0} cal,{0} cal,calories,,{0} calorie,{0} calories
        electronvolt,eV,,{0}eV,{0}eV,eV,,{0} eV,{0} eV,électronvolts,,{0} électronvolt,{0} électronvolts
        foodcalorie,,,,,,,,,kilocalories,,{0} kilocalorie,{0} kilocalories
        joule,J,,{0}J,{0}J,J,,{0} J,{0} J,joules,,{0} joule,{0} joules
        kilocalorie,kcal,,{0}kcal,{0}kcal,kcal,,{0} kcal,{0} kcal,kilocalories,,{0} kilocalorie,{0} kilocalories
        kilojoule,kJ,,{0}kJ,{0}kJ,kJ,,{0} kJ,{0} kJ,kilojoules,,{0} kilojoule,{0} kilojoules
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,kWh,,{0} kWh,{0} kWh,kilowatt-heures,,{0} kilowatt-heure,{0} kilowatt-heures
        therm-us,thm US,,{0}thm US,{0}thm US,therm US,,{0} therm US,{0} therms US,therms US,,{0} therm US,{0} therms US
        kilowatt-hour-per-100-kilometer,kWh/100 km,,{0}kWh/100km,{0}kWh/100km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kilowatt-heures pour 100 kilomètres,,{0} kilowatt-heure pour 100 kilomètres,{0} kilowatt-heures pour 100 kilomètres
        newton,N,,{0}N,{0}N,N,,{0} N,{0} N,newtons,,{0} newton,{0} newtons
        pound-force,lbf,,{0}lbf,{0}lbf,lbf,,{0} lbf,{0} lbf,livres-force,,{0} livre-force,{0} livres-force
        gigahertz,GHz,,{0}GHz,{0}GHz,GHz,,{0} GHz,{0} GHz,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,Hz,,{0}Hz,{0}Hz,Hz,,{0} Hz,{0} Hz,hertz,,{0} hertz,{0} hertz
        kilohertz,kHz,,{0}kHz,{0}kHz,kHz,,{0} kHz,{0} kHz,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,MHz,,{0}MHz,{0}MHz,MHz,,{0} MHz,{0} MHz,mégahertz,,{0} mégahertz,{0} mégahertz
        dot,pt,,{0}pt,{0}pt,pt,,{0} pt,{0} pt,points,,{0} point,{0} points
        dot-per-centimeter,pt/cm,,{0}pt/cm,{0}pt/cm,pt/cm,,{0} pt/cm,{0} pt/cm,points par centimètre,,{0} point par centimètre,{0} points par centimètre
        dot-per-inch,pt/po,,{0}pt/po,{0}pt/po,pt/po,,{0} pt/po,{0} pt/po,points par pouce,,{0} point par pouce,{0} points par pouce
        em,em,,{0}em,{0}em,em,,{0} em,{0} em,cadratin,,{0} cadratin,{0} cadratins
        megapixel,Mpx,,{0}Mpx,{0}Mpx,Mpx,,{0} Mpx,{0} Mpx,mégapixels,,{0} mégapixel,{0} mégapixels
        pixel,px,,{0}px,{0}px,px,,{0} px,{0} px,pixels,,{0} pixel,{0} pixels
        pixel-per-centimeter,px/cm,,{0}px/cm,{0}px/cm,px/cm,,{0} px/cm,{0} px/cm,pixels par centimètre,,{0} pixel par centimètre,{0} pixels par centimètre
        pixel-per-inch,px/po,,{0}px/po,{0}px/po,px/po,,{0} px/po,{0} px/po,pixels par pouce,,{0} pixel par pouce,{0} pixels par pouce
        astronomical-unit,ua,,{0}ua,{0}ua,ua,,{0} ua,{0} ua,unités astronomiques,,{0} unité astronomique,{0} unités astronomiques
        centimeter,cm,{0}/cm,{0}cm,{0}cm,cm,{0}/cm,{0} cm,{0} cm,centimètres,{0} par centimètre,{0} centimètre,{0} centimètres
        decimeter,dm,,{0} dm,{0} dm,dm,,{0} dm,{0} dm,décimètres,,{0} décimètre,{0} décimètres
        earth-radius,,,,,,,,,rayon terrestre,,{0} rayon terrestre,{0} rayons terrestres
        fathom,fm,,{0} fm,{0} fm,fm,,{0} fm,{0} fm,brasses,,{0} brasse,{0} brasses
        foot,pi,{0}/pi,{0}′,{0}′,pi,{0}/pi,{0} pi,{0} pi,pieds,{0} par pied,{0} pied,{0} pieds
        furlong,,,,,,,,,furlongs,,{0} furlong,{0} furlongs
        inch,po,{0}/po,{0}″,{0}″,po,{0}/po,{0} po,{0} po,pouces,{0} par pouce,{0} pouce,{0} pouces
        kilometer,km,{0}/km,{0}km,{0}km,km,{0}/km,{0} km,{0} km,kilomètres,{0} par kilomètre,{0} kilomètre,{0} kilomètres
        light-year,al,,{0} al,{0} al,al,,{0} al,{0} al,années-lumière,,{0} année-lumière,{0} années-lumière
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,{0} m,{0} m,mètres,{0} par mètre,{0} mètre,{0} mètres
        micrometer,μm,,{0} μm,{0} μm,μm,,{0} μm,{0} μm,micromètres,,{0} micromètre,{0} micromètres
        mile,mi,,{0}mi,{0}mi,mi,,{0} mi,{0} mi,miles,,{0} mile,{0} miles
        mile-scandinavian,smi,,{0} smi,{0} smi,smi,,{0} smi,{0} smi,milles scandinaves,,{0} mille scandinave,{0} milles scandinaves
        millimeter,mm,,{0}mm,{0}mm,mm,,{0} mm,{0} mm,millimètres,,{0} millimètre,{0} millimètres
        nanometer,nm,,{0} nm,{0} nm,nm,,{0} nm,{0} nm,nanomètres,,{0} nanomètre,{0} nanomètres
        nautical-mile,nmi,,{0} nmi,{0} nmi,nmi,,{0} nmi,{0} nmi,milles marins,,{0} mille marin,{0} milles marins
        parsec,pc,,{0} pc,{0} pc,pc,,{0} pc,{0} pc,parsecs,,{0} parsec,{0} parsecs
        picometer,pm,,{0}pm,{0}pm,pm,,{0} pm,{0} pm,picomètres,,{0} picomètre,{0} picomètres
        point,pt typog.,,{0} pt typog.,{0} pts typog.,pt typog.,,{0} pt typog.,{0} pts typog.,pt typog.,,{0} point typographique,{0} points typographiques
        solar-radius,R☉,,{0}R☉,{0}R☉,R☉,,{0} R☉,{0} R☉,rayons solaires,,{0} rayon solaire,{0} rayons solaires
        yard,yd,,{0}yd,{0}yd,yd,,{0} yd,{0} yd,yards,,{0} yard,{0} yards
        candela,cd,,{0}cd,{0}cd,,,,,candela,,{0} candela,{0} candelas
        lumen,lm,,{0}lm,{0}lm,,,,,lumen,,{0} lumen,{0} lumens
        lux,lx,,{0}lx,{0}lx,lx,,{0} lx,{0} lx,lux,,{0} lux,{0} lux
        solar-luminosity,L☉,,{0}L☉,{0}L☉,L☉,,{0} L☉,{0} L☉,luminosités solaires,,{0} luminosité solaire,{0} luminosités solaires
        carat,ct,,{0}ct,{0}ct,ct,,{0} ct,{0} ct,carats,,{0} carat,{0} carats
        dalton,Da,,{0}Da,{0}Da,Da,,{0} Da,{0} Da,daltons,,{0} dalton,{0} daltons
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,M⊕,,{0} M⊕,{0} M⊕,masses terrestres,,{0} masse terrestre,{0} masses terrestres
        grain,grain,,{0} grain,{0} grains,grain,,{0} grains,{0} grains,grains,,{0} grain,{0} grains
        gram,g,{0}/g,{0}g,{0}g,g,{0}/g,{0} g,{0} g,grammes,{0} par gramme,{0} gramme,{0} grammes
        kilogram,kg,{0}/kg,{0}kg,{0}kg,kg,{0}/kg,{0} kg,{0} kg,kilogrammes,{0} par kilogramme,{0} kilogramme,{0} kilogrammes
        microgram,μg,,{0}μg,{0}μg,μg,,{0} μg,{0} μg,microgrammes,,{0} microgramme,{0} microgrammes
        milligram,mg,,{0}mg,{0}mg,mg,,{0} mg,{0} mg,milligrammes,,{0} milligramme,{0} milligrammes
        ounce,oz,{0}/oz,{0}oz,{0}oz,oz,{0}/oz,{0} oz,{0} oz,onces,{0} par once,{0} once,{0} onces
        ounce-troy,oz t,,{0}oz t,{0}oz t,oz t,,{0} oz t,{0} oz t,onces troy,,{0} once troy,{0} onces troy
        pound,lb,{0}/lb,{0}lb,{0}lb,lb,{0}/lb,{0} lb,{0} lb,livres,{0} par livre,{0} livre,{0} livres
        solar-mass,M☉,,{0}M☉,{0}M☉,M☉,,{0} M☉,{0} M☉,masses solaires,,{0} masse solaire,{0} masses solaires
        stone,,,,,,,,,stones,,{0} stone,{0} stones
        ton,sh tn,,{0} sh tn,{0} sh tn,sh tn,,{0} sh tn,{0} sh tn,tonnes courtes,,{0} tonne courte,{0} tonnes courtes
        tonne,t,,{0}t,{0}t,t,,{0} t,{0} t,tonnes,,{0} tonne,{0} tonnes
        gigawatt,GW,,{0}GW,{0}GW,GW,,{0} GW,{0} GW,gigawatts,,{0} gigawatt,{0} gigawatts
        horsepower,ch,,{0}ch,{0}ch,ch,,{0} ch,{0} ch,chevaux-vapeur,,{0} cheval-vapeur,{0} chevaux-vapeur
        kilowatt,kW,,{0}kW,{0}kW,kW,,{0} kW,{0} kW,kilowatts,,{0} kilowatt,{0} kilowatts
        megawatt,MW,,{0}MW,{0}MW,MW,,{0} MW,{0} MW,mégawatts,,{0} mégawatt,{0} mégawatts
        milliwatt,mW,,{0}mW,{0}mW,mW,,{0} mW,{0} mW,milliwatts,,{0} milliwatt,{0} milliwatts
        watt,W,,{0}W,{0}W,W,,{0} W,{0} W,watts,,{0} watt,{0} watts
        atmosphere,atm,,{0}atm,{0}atm,atm,,{0} atm,{0} atm,atmosphères,,{0} atmosphère,{0} atmosphères
        bar,bar,,{0}bar,{0}bar,bar,,{0} bar,{0} bars,bars,,{0} bar,{0} bars
        hectopascal,hPa,,{0}hPa,{0}hPa,hPa,,{0} hPa,{0} hPa,hectopascals,,{0} hectopascal,{0} hectopascals
        inch-ofhg,inHg,,{0} inHg,{0} inHg,inHg,,{0} inHg,{0} inHg,pouces de mercure,,{0} pouce de mercure,{0} pouces de mercure
        kilopascal,kPa,,{0}kPa,{0}kPa,kPa,,{0} kPa,{0} kPa,kilopascals,,{0} kilopascal,{0} kilopascals
        megapascal,MPa,,{0}MPa,{0}MPa,MPa,,{0} MPa,{0} MPa,mégapascals,,{0} mégapascal,{0} mégapascals
        millibar,mbar,,{0}mbar,{0}mbar,mbar,,{0} mbar,{0} mbar,millibars,,{0} millibar,{0} millibars
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,mmHg,,{0} mmHg,{0} mmHg,millimètres de mercure,,{0} millimètre de mercure,{0} millimètres de mercure
        pascal,Pa,,{0}Pa,{0}Pa,Pa,,{0} Pa,{0} Pa,pascals,,{0} pascal,{0} pascals
        pound-force-per-square-inch,lb/po²,,{0} lb/po²,{0} lb/po²,lb/po²,,{0} lb/po²,{0} lb/po²,livres-force par pouce carré,,{0} livre-force par pouce carré,{0} livres-force par pouce carré
        beaufort,Bft,,{0}Bft,{0}Bft,Bft,,{0} Bft,{0} Bft,Beaufort,,{0} degré Beaufort,{0} degrés Beaufort
        kilometer-per-hour,km/h,,{0}km/h,{0}km/h,km/h,,{0} km/h,{0} km/h,kilomètres par heure,,{0} kilomètre par heure,{0} kilomètres par heure
        knot,nd,,{0} nd,{0} nd,nd,,{0} nd,{0} nd,nœuds,,{0} nœud,{0} nœuds
        light-speed,lumière,,{0} lumière,{0} lumière,lumière,,{0} lumière,{0} lumière,lumière,,{0} lumière,{0} lumière
        meter-per-second,m/s,,{0} m/s,{0}m/s,m/s,,{0} m/s,{0} m/s,mètres par seconde,,{0} mètre par seconde,{0} mètres par seconde
        mile-per-hour,mi/h,,{0} mi/h,{0} mi/h,mi/h,,{0} mi/h,{0} mi/h,miles par heure,,{0} mile par heure,{0} miles par heure
        celsius,°C,,{0}°C,{0}°C,°C,,{0} °C,{0} °C,degrés Celsius,,{0} degré Celsius,{0} degrés Celsius
        fahrenheit,°F,,{0}°F,{0}°F,°F,,{0} °F,{0} °F,degrés Fahrenheit,,{0} degré Fahrenheit,{0} degrés Fahrenheit
        generic,,,,,,,,,degrés,,{0} degré,{0} degrés
        kelvin,K,,{0}K,{0}K,K,,{0} K,{0} K,kelvins,,{0} kelvin,{0} kelvins
        newton-meter,N⋅m,,{0}N⋅m,{0}N⋅m,N⋅m,,{0} N⋅m,{0} N⋅m,newtons-mètres,,{0} newton-mètre,{0} newtons-mètres
        pound-force-foot,lbf⋅ft,,{0}lbf⋅ft,{0}lbf⋅ft,lbf⋅ft,,{0} lbf⋅ft,{0} lbf⋅ft,livres-force-pieds,,{0} livre-force-pied,{0} livres-force-pieds
        acre-foot,acpi,,{0}acpi,{0}acpi,ac pi,,{0} ac pi,{0} ac pi,acres-pieds,,{0} acre-pied,{0} acres-pieds
        barrel,bbl,,{0}bbl,{0}bbl,bbl,,{0} bbl,{0} bbl,barils,,{0} baril,{0} barils
        bushel,bu,,{0}bu,{0}bu,bu,,{0} bu,{0} bu,boisseaux,,{0} boisseau,{0} boisseaux
        centiliter,cl,,{0}cl,{0}cl,cl,,{0} cl,{0} cl,centilitres,,{0} centilitre,{0} centilitres
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,cm³,{0}/cm³,{0} cm³,{0} cm³,centimètres cubes,{0} par centimètre cube,{0} centimètre cube,{0} centimètres cubes
        cubic-foot,pi³,,{0}pi³,{0}pi³,pi³,,{0} pi³,{0} pi³,pieds cubes,,{0} pied cube,{0} pieds cubes
        cubic-inch,po³,,{0}po³,{0}po³,po³,,{0} po³,{0} po³,pouces cubes,,{0} pouce cube,{0} pouces cubes
        cubic-kilometer,km³,,{0}km³,{0}km³,km³,,{0} km³,{0} km³,kilomètres cubes,,{0} kilomètre cube,{0} kilomètres cubes
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,m³,{0}/m³,{0} m³,{0} m³,mètres cubes,{0} par mètre cube,{0} mètre cube,{0} mètres cubes
        cubic-mile,mi³,,{0}mi³,{0}mi³,mi³,,{0} mi³,{0} mi³,milles cubes,,{0} mille cube,{0} milles cubes
        cubic-yard,yd³,,{0}yd³,{0}yd³,yd³,,{0} yd³,{0} yd³,yards cubes,,{0} yard cube,{0} yards cubes
        cup,ta,,{0}ta,{0}ta,tasses,,{0} tasse,{0} tasses,tasses,,{0} tasse,{0} tasses
        cup-metric,tm,,{0}tm,{0}tm,tm,,{0} tm,{0} tm,tasses métriques,,{0} tasse métrique,{0} tasses métriques
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,décilitres,,{0} décilitre,{0} décilitres
        dessert-spoon,CàD,,{0}CàD,{0}CàD,c. à d.,,{0} c. à d.,{0} c. à d.,cuillères à dessert,,{0} cuillère à dessert,{0} cuillères à dessert
        dessert-spoon-imperial,CàD imp.,,{0}CàD imp.,{0}CàD imp.,c. à d. imp.,,{0} c. à d. imp.,{0} c. à d. imp.,cuillères à dessert impériales,,{0} cuillère à dessert impériale,{0} cuillères à dessert impériales
        dram,fl dr,,{0}fl dr,{0}fl dr,drachme fluide,,{0} fl dr,{0} fl dr,drachmes,,{0} drachme,{0} drachmes
        drop,gte,,{0}gte,{0}gte,gte,,{0} gte,{0} gte,gouttes,,{0} goutte,{0} gouttes
        fluid-ounce,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,onces liquides,,{0} once liquide,{0} onces liquides
        fluid-ounce-imperial,fl oz imp.,,{0}fl oz imp,{0}fl oz imp,fl oz imp.,,{0} fl oz imp.,{0} fl oz imp.,onces liquides impériales,,{0} once liquide impériale,{0} onces liquides impériales
        gallon,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal,{0} gal,{0} gal,gallons,{0} par gallon,{0} gallon,{0} gallons
        gallon-imperial,gal imp.,{0}/gal imp.,{0}gal imp.,{0}gal imp.,gal imp.,{0} gal imp.,{0} gal imp.,{0} gal imp.,gallons impériaux,{0} par gallon impérial,{0} gallon impérial,{0} gallons impériaux
        hectoliter,hl,,{0}hl,{0}hl,hl,,{0} hl,{0} hl,hectolitres,,{0} hectolitre,{0} hectolitres
        jigger,jigger,,{0} jigger,{0} jiggers,jigger,,{0} jigger,{0} jiggers,jiggers,,{0} jigger,{0} jiggers
        liter,l,{0}/l,{0}l,{0}l,l,{0}/l,{0} l,{0} l,litres,{0} par litre,{0} litre,{0} litres
        megaliter,Ml,,{0}Ml,{0}Ml,Ml,,{0} Ml,{0} Ml,mégalitres,,{0} mégalitre,{0} mégalitres
        milliliter,ml,,{0}ml,{0}ml,ml,,{0} ml,{0} ml,millilitres,,{0} millilitre,{0} millilitres
        pinch,pincée,,{0} pincée,{0} pincées,pincée,,{0} pincée,{0} pincées,pincées,,{0} pincée,{0} pincées
        pint,pte,,{0}pte,{0}pte,pte,,{0} pte,{0} pte,pintes,,{0} pinte,{0} pintes
        pint-metric,mpt,,{0}mpt,{0}mpt,,,,,pintes métriques,,{0} pinte métrique,{0} pintes métriques
        quart,qt,,{0}qt,{0}qt,,,,,quarts,,{0} quart,{0} quarts
        quart-imperial,qt imp.,,{0}qt imp.,{0}qt imp.,qt imp.,,{0} qt imp.,{0} qt imp.,quarts impériaux,,{0} quart impérial,{0} quarts impériaux
        tablespoon,CàS,,{0}CàS,{0}CàS,c. à s.,,{0} c. à s.,{0} c. à s.,cuillères à soupe,,{0} cuillère à soupe,{0} cuillères à soupe
        teaspoon,CàC,,{0}CàC,{0}CàC,c. à c.,,{0} c. à c.,{0} c. à c.,cuillères à café,,{0} cuillère à café,{0} cuillères à café
        """.trimIndent()
  }

  private val fr_Prefixes: String by lazy {
    """square,,,{0} carrés
        cubic,,,{0} cubes
        times,{0}-{1},{0}-{1},{0}-{1}
        per,,,{0} par {1}
        1024p1,,,kibi{0}
        1024p2,,,mébi{0}
        1024p3,,,gibi{0}
        1024p4,,,tébi{0}
        1024p5,,,pébi{0}
        1024p6,,,exbi{0}
        1024p7,,,zébi{0}
        1024p8,,,yobi{0}
        10p-1,,,déci{0}
        10p-12,,,pico{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,milli{0}
        10p-30,,,quecto{0}
        10p-6,,,micro{0}
        10p-9,,,nano{0}
        10p1,,,déca{0}
        10p12,,,téra{0}
        10p15,,,péta{0}
        10p18,,,exa{0}
        10p2,,,hecto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,méga{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val fr_BE_Units: String? = null

  private val fr_BE_Prefixes: String? = null

  private val fr_BF_Units: String? = null

  private val fr_BF_Prefixes: String? = null

  private val fr_BI_Units: String? = null

  private val fr_BI_Prefixes: String? = null

  private val fr_BJ_Units: String? = null

  private val fr_BJ_Prefixes: String? = null

  private val fr_BL_Units: String? = null

  private val fr_BL_Prefixes: String? = null

  private val fr_CA_Units: String by lazy {
    """g-force,G,,{0} G,{0} G,G,,{0} G,{0} G,force g,,{0} fois l’accélération de pesanteur terrestre,{0} fois l’accélération de pesanteur terrestre
        meter-per-square-second,,,,,m/s²,,{0} m/s²,{0} m/s²,mètres par seconde carrée,,{0} mètre par seconde carrée,{0} mètres par seconde carrée
        degree,,,,,,,,,degrés,,{0} degré,{0} degrés
        radian,rad,,{0}rad,{0}rad,rad,,{0} rad,{0} rad,radians,,{0} radian,{0} radians
        acre,,,,,ac,,{0} ac,{0} ac,acres,,{0} acre,{0} acres
        hectare,,,,,ha,,{0} ha,{0} ha,hectares,,{0} hectare,{0} hectares
        square-centimeter,,,,,cm²,{0}/cm²,{0} cm²,{0} cm²,centimètres carrés,{0} par centimètre carré,{0} centimètre carré,{0} centimètres carrés
        square-foot,,,,,pi²,,{0} pi²,{0} pi²,pieds carrés,,{0} pied carré,{0} pieds carrés
        square-inch,,,,,po²,{0}/po²,{0} po²,{0} po²,pouces carrés,{0} par pouce carré,{0} pouce carré,{0} pouces carrés
        square-kilometer,,,,,km²,{0}/km²,{0} km²,{0} km²,kilomètres carrés,{0} par kilomètre carré,{0} kilomètre carré,{0} kilomètres carrés
        square-meter,,,,,m²,{0}/m²,{0} m²,{0} m²,mètres carrés,{0} par mètre carré,{0} mètre carré,{0} mètres carrés
        square-mile,,,,,mi²,{0}/mi²,{0} mi²,{0} mi²,milles carrés,{0} par mille carré,{0} mille carré,{0} milles carrés
        square-yard,vg²,,{0}vg²,{0}vg²,vg²,,{0} vg²,{0} vg²,verges carrées,,{0} verge carrée,{0} verges carrées
        permille,,,,,‰,,{0} ‰,{0} ‰,pour mille,,{0} pour mille,{0} pour mille
        permillion,,,,,,,,,parties par million,,{0} partie par million,{0} parties par million
        portion-per-1e9,p.p. 10⁹,,{0}pp10⁹,{0}pp10⁹,p.p. 10⁹,,{0} p.p. 10⁹,{0} p.p. 10⁹,parties par milliard,,{0} partie par milliard,{0} parties par milliard
        liter-per-100-kilometer,,,,,,,,,litres aux 100 kilomètres,,{0} litre aux 100 kilomètres,{0} litres aux 100 kilomètres
        mile-per-gallon,,,,,mi/gal,,{0} mi/gal,{0} mi/gal,milles au gallon,,{0} mille au gallon,{0} milles au gallon
        mile-per-gallon-imperial,,,,,,,,,milles au gallon impérial,,{0} mille au gallon impérial,{0} milles au gallon impérial
        bit,,,,,bit,,{0} bit,{0} bit,bits,,{0} bit,{0} bits
        byte,,,,,octet,,{0} octet,{0} octet,octets,,{0} octet,{0} octets
        gigabit,Gb,,{0}Gb,{0}Gb,Gb,,{0} Gb,{0} Gb,gigabits,,{0} gigabit,{0} gigabits
        gigabyte,,,,,Go,,{0} Go,{0} Go,gigaoctets,,{0} gigaoctet,{0} gigaoctets
        kilobit,kb,,{0}kb,{0}kb,kb,,{0} kb,{0} kb,kilobits,,{0} kilobit,{0} kilobits
        kilobyte,,,,,ko,,{0} ko,{0} ko,kilooctets,,{0} kilooctet,{0} kilooctets
        megabit,Mb,,{0}Mb,{0}Mb,Mb,,{0} Mb,{0} Mb,mégabits,,{0} mégabit,{0} mégabits
        megabyte,,,,,Mo,,{0} Mo,{0} Mo,mégaoctets,,{0} mégaoctet,{0} mégaoctets
        terabit,Tb,,{0}Tb,{0}Tb,Tb,,{0} Tb,{0} Tb,térabits,,{0} térabit,{0} térabits
        terabyte,,,,,To,,{0} To,{0} To,téraoctets,,{0} téraoctet,{0} téraoctets
        day,,,,,j,{0}/j,{0} j,{0} j,jours,{0} par jour,{0} jour,{0} jours
        hour,,,,,h,{0}/h,{0} h,{0} h,heures,{0} par heure,{0} heure,{0} heures
        microsecond,,,,,μs,,{0} μs,{0} μs,microsecondes,,{0} microseconde,{0} microsecondes
        millisecond,,,,,ms,,{0} ms,{0} ms,millisecondes,,{0} milliseconde,{0} millisecondes
        month,m.,{0}/m.,{0}m,{0}m,m.,{0}/m.,{0} m.,{0} m.,mois,{0} par mois,{0} mois,{0} mois
        nanosecond,,,,,ns,,{0} ns,{0} ns,nanosecondes,,{0} nanoseconde,{0} nanosecondes
        second,,,,,s,{0}/s,{0} s,{0} s,secondes,{0} à la seconde,{0} seconde,{0} secondes
        week,sem,{0}/sem,{0}sem,{0}sem,sem.,{0}/sem.,{0} sem.,{0} sem.,semaines,{0} par semaine,{0} semaine,{0} semaines
        ampere,,,,,A,,{0} A,{0} A,ampères,,{0} ampère,{0} ampères
        milliampere,,,,,mA,,{0} mA,{0} mA,milliampères,,{0} milliampère,{0} milliampères
        ohm,,,,,Ω,,{0} Ω,{0} Ω,ohms,,{0} ohm,{0} ohms
        volt,,,,,V,,{0} V,{0} V,volts,,{0} volt,{0} volts
        british-thermal-unit,BTU,,{0}BTU,{0}BTU,BTU,,{0} BTU,{0} BTU,unités thermiques britanniques,,{0} unité thermique britannique,{0} unités thermiques britanniques
        calorie,,,,,cal,,{0} cal,{0} cal,calories,,{0} calorie,{0} calories
        foodcalorie,,,,,,,,,kilocalories,,{0} kilocalorie,{0} kilocalories
        joule,,,,,J,,{0} J,{0} J,joules,,{0} joule,{0} joules
        kilocalorie,,,,,kcal,,{0} kcal,{0} kcal,kilocalories,,{0} kilocalorie,{0} kilocalories
        kilojoule,,,,,kJ,,{0} kJ,{0} kJ,kilojoules,,{0} kilojoule,{0} kilojoules
        kilowatt-hour,,,,,kWh,,{0} kWh,{0} kWh,kilowattheures,,{0} kilowattheure,{0} kilowattheures
        therm-us,thm US,,{0}therm US,{0}therm US,,,,,therms américains,,{0} therm américain,{0} therms américains
        gigahertz,,,,,GHz,,{0} GHz,{0} GHz,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,,,,,Hz,,{0} Hz,{0} Hz,hertz,,{0} hertz,{0} hertz
        kilohertz,,,,,kHz,,{0} kHz,{0} kHz,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,,,,,MHz,,{0} MHz,{0} MHz,mégahertz,,{0} mégahertz,{0} mégahertz
        dot,,,,,,,,,point,,{0} point,{0} points
        astronomical-unit,,,,,ua,,{0} ua,{0} ua,unités astronomiques,,{0} unité astronomique,{0} unités astronomiques
        centimeter,,,,,cm,{0}/cm,{0} cm,{0} cm,centimètres,{0} par centimètre,{0} centimètre,{0} centimètres
        decimeter,dm,,{0}dm,{0}dm,dm,,{0} dm,{0} dm,décimètres,,{0} décimètre,{0} décimètres
        foot,pi,{0}/pi,{0}pi,{0}pi,pi,{0}/pi,{0} pi,{0} pi,pieds,{0} par pied,{0} pied,{0} pieds
        inch,po,{0}/po,{0}po,{0}po,po,{0}/po,{0} po,{0} po,pouces,{0} par pouce,{0} pouce,{0} pouces
        kilometer,,,,,km,{0}/km,{0} km,{0} km,kilomètres,{0} par kilomètre,{0} kilomètre,{0} kilomètres
        light-year,al,,{0}al,{0}al,al,,{0} al,{0} al,années-lumière,,{0} année-lumière,{0} années-lumière
        meter,,,,,m,{0}/m,{0} m,{0} m,mètres,{0} par mètre,{0} mètre,{0} mètres
        micrometer,μm,,{0}μm,{0}μm,μm,,{0} μm,{0} μm,micromètres,,{0} micromètre,{0} micromètres
        mile,,,,,mi,,{0} mi,{0} mi,mille,,{0} mille,{0} milles
        millimeter,,,,,mm,,{0} mm,{0} mm,millimètres,,{0} millimètre,{0} millimètres
        nanometer,nm,,{0}nm,{0}nm,nm,,{0} nm,{0} nm,nanomètres,,{0} nanomètre,{0} nanomètres
        nautical-mile,NM,,{0}NM,{0}NM,NM,,{0} NM,{0} NM,milles marins,,{0} mille marin,{0} milles marins
        parsec,pc,,{0}pc,{0}pc,pc,,{0} pc,{0} pc,parsecs,,{0} parsec,{0} parsecs
        picometer,,,,,pm,,{0} pm,{0} pm,picomètres,,{0} picomètre,{0} picomètres
        yard,vg,,{0}vg,{0}vg,vg,,{0} vg,{0} vg,verges,,{0} verge,{0} verges
        lux,,,,,lx,,{0} lx,{0} lx,lux,,{0} lux,{0} lux
        carat,,,,,ct,,{0} ct,{0} ct,carats,,{0} carat,{0} carats
        grain,,,,,grain,,{0} grain,{0} grains,grain,,{0} grain,{0} grains
        gram,,,,,g,{0}/g,{0} g,{0} g,grammes,{0} par gramme,{0} gramme,{0} grammes
        kilogram,,,,,kg,{0}/kg,{0} kg,{0} kg,kilogrammes,{0} par kilogramme,{0} kilogramme,{0} kilogrammes
        milligram,,,,,mg,,{0} mg,{0} mg,milligrammes,,{0} milligramme,{0} milligrammes
        ounce,,,,,oz,{0}/oz,{0} oz,{0} oz,onces,{0} par once,{0} once,{0} onces
        ounce-troy,,,,,oz t,,{0} oz t,{0} oz t,onces troy,,{0} once troy,{0} onces troy
        pound,,,,,lb,{0}/lb,{0} lb,{0} lb,livres,{0} par livre,{0} livre,{0} livres
        stone,st,,{0}st,{0}st,,,,,stones,,{0} stone,{0} stone
        ton,tc,,{0}tc,{0}tc,tc,,{0} tc,{0} tc,tonnes courtes,,{0} tonne courte,{0} tonnes courtes
        gigawatt,,,,,GW,,{0} GW,{0} GW,gigawatts,,{0} gigawatt,{0} gigawatts
        horsepower,,,,,ch,,{0} ch,{0} ch,chevaux-vapeur,,{0} cheval-vapeur,{0} chevaux-vapeur
        kilowatt,,,,,kW,,{0} kW,{0} kW,kilowatts,,{0} kilowatt,{0} kilowatts
        megawatt,,,,,MW,,{0} MW,{0} MW,mégawatts,,{0} mégawatt,{0} mégawatts
        milliwatt,,,,,mW,,{0} mW,{0} mW,milliwatts,,{0} milliwatt,{0} milliwatts
        watt,,,,,W,,{0} W,{0} W,watts,,{0} watt,{0} watts
        atmosphere,,,,,,,,,atmosphères,,{0} atmosphère,{0} atmosphères
        hectopascal,,,,,hPa,,{0} hPa,{0} hPa,hectopascals,,{0} hectopascal,{0} hectopascals
        inch-ofhg,poHg,,{0}poHg,{0}poHg,po Hg,,{0} po Hg,{0} po Hg,pouces de mercure,,{0} pouce de mercure,{0} pouces de mercure
        millibar,,,,,mbar,,{0} mbar,{0} mbar,millibars,,{0} millibar,{0} millibars
        kilometer-per-hour,,,,,km/h,,{0} km/h,{0} km/h,kilomètres à l’heure,,{0} kilomètre par heure,{0} kilomètres par heure
        meter-per-second,,,,,m/s,,{0} m/s,{0} m/s,mètres par seconde,,{0} mètre par seconde,{0} mètres par seconde
        mile-per-hour,mi/h,,{0} mi/h,{0} mi/h,mi/h,,{0} mi/h,{0} mi/h,milles à l’heure,,{0} mille à l’heure,{0} milles à l’heure
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,degrés Celsius,,{0} degré Celsius,{0} degrés Celsius
        fahrenheit,,,,,°F,,{0} °F,{0} °F,degrés Fahrenheit,,{0} degré Fahrenheit,{0} degrés Fahrenheit
        generic,,,,,,,,,°,,{0}°,{0}°
        cubic-centimeter,,,,,cm³,{0}/cm³,{0} cm³,{0} cm³,centimètres cubes,{0} par centimètre cube,{0} centimètre cube,{0} centimètres cubes
        cubic-foot,,,,,pi³,,{0} pi³,{0} pi³,pieds cubes,,{0} pied cube,{0} pieds cubes
        cubic-inch,,,,,po³,,{0} po³,{0} po³,pouces cubes,,{0} pouce cube,{0} pouces cubes
        cubic-kilometer,,,,,km³,,{0} km³,{0} km³,kilomètres cubes,,{0} kilomètre cube,{0} kilomètres cubes
        cubic-meter,,,,,m³,{0}/m³,{0} m³,{0} m³,mètres cubes,{0} par mètre cube,{0} mètre cube,{0} mètres cubes
        cubic-mile,,,,,mi³,,{0} mi³,{0} mi³,milles cubes,,{0} mille cube,{0} milles cubes
        cubic-yard,vg³,,{0}vg³,{0}vg³,vg³,,{0} vg³,{0} vg³,verges cubes,,{0} verge cube,{0} verges cubes
        dessert-spoon,c. à d.,,{0}c. à d.,{0}c. à d.,cuill. à d.,,{0} cuill. à d.,{0} cuill. à d.,cuillère à dessert,,{0} cuillère à dessert,{0} cuillères à dessert
        drop,gtt.,,{0}gtt.,{0}gtt.,goutte,,{0} goutte,{0} gouttes,goutte,,{0} goutte,{0} gouttes
        gallon-imperial,gal imp,{0}/gal imp,{0}/gal imp,{0}/gal imp,gal Imp,{0}/gal Imp,{0} gal Imp,{0} gal Imp,gallon impérial,{0} par gallon impérial,{0} gallon impérial,{0} gallons impériaux
        hectoliter,,,,,,,,,hectolitres,,{0} hectolitre,{0} hectolitres
        jigger,gob. doseur,,{0}gob. doseur,{0}gob. doseurs,gobelet doseur,,{0} gobelet doseur,{0} gobelets doseurs,gobelet doseur,,{0} gobelet doseur,{0} gobelets doseurs
        liter,,,,,,,,,litres,{0} par litre,{0} litre,{0} litres
        megaliter,,,,,,,,,mégalitres,,{0} mégalitre,{0} mégalitres
        pinch,pincée,,{0}pincée,{0}pincées,,,,,pincée,,{0} pincée,{0} pincées
        pint,chop,,{0}chop,{0}chop,chop,,{0} chop,{0} chop,chopine,,{0} chopine,{0} chopines
        quart,pte,,{0}pte,{0}pte,pte,,{0} pte,{0} pte,pintes,,{0} pinte,{0} pintes
        quart-imperial,pte imp,,{0}pte imp,{0}pte imp,pte imp,,{0} pte imp,{0} pte imp,pinte impériale,,{0} pinte impériale,{0} pintes impériales
        teaspoon,c. à t.,,{0}c. à t.,{0}c. à t.,c. à t.,,{0} c. à t.,{0} c. à t.,cuillères à thé,,{0} cuillère à thé,{0} cuillères à thé
        item,,,,,item,,{0} item,{0} items,,,,
        karat,carats,,{0}ct,{0}ct,carats,,{0} ct,{0} ct,,,,
        percent,%,,{0} %,{0} %,%,,{0} %,{0} %,,,,
        minute,min,{0}/m,{0}m,{0}m,min,{0}/min,{0} min,{0} min,,,,
        year,,,,,ans,{0}/an,{0} an,{0} ans,,,,
        dot-per-centimeter,,,,,pt/cm,,{0} pt/cm,{0} pt/cm,,,,
        microgram,,,,,μg,,{0} μg,{0} μg,,,,
        tonne,,,,,t,,{0} t,{0} t,,,,
        millimeter-ofhg,mm Hg,,{0}mmHg,{0}mmHg,mm Hg,,{0} mm Hg,{0} mm Hg,,,,
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,psi,,{0} psi,{0} psi,,,,
        beaufort,Bf,,{0} Bf,{0} Bf,Bft,,{0} Bf,{0} Bf,,,,
        kelvin,,,,,K,,{0} K,{0} K,,,,
        pound-force-foot,lb-pi,,{0}lb-pi,{0}lb-pi,lb-pi,,{0} lb-pi,{0} lb-pi,,,,
        dessert-spoon-imperial,c. à. d. imp.,,{0}c. à. d. imp.,{0} c. à. d. imp.,cuill. à d. imp.,,{0} cuill. à d. imp.,{0} cuill. à d. imp.,,,,
        dram,dr. liq,,{0}dr. liq,{0}dr. liq,dram liquide,,{0} dram liq,{0} dram liq,,,,
        fluid-ounce,oz liq.,,{0}oz liq.,{0}oz liq.,oz liq.,,{0} oz liq.,{0} oz liq.,,,,
        fluid-ounce-imperial,oz liq imp.,,{0}oz liq imp.,{0}oz liq imp.,oz liq imp.,,{0} oz liq imp.,{0} oz liq imp.,,,,
        decade,déc,,{0}déc,{0}déc,,,,,,,,
        earth-radius,R⊕,,{0}R⊕,{0}R⊕,,,,,,,,
        fathom,fm,,{0}fm,{0}fm,,,,,,,,
        furlong,fur,,{0}fur,{0}fur,,,,,,,,
        mile-scandinavian,smi,,{0}smi,{0}smi,,,,,,,,
        point,pt typog.,,{0}pt,{0}pt,,,,,,,,
        knot,nd,,{0}nd,{0}nd,,,,,,,,
        acre-foot,ac pi,,{0}ac pi,{0}ac pi,,,,,,,,
        tablespoon,c. à s.,,{0}c. à s.,{0}c. à s.,,,,,,,,
        """.trimIndent()
  }

  private val fr_CA_Prefixes: String? = null

  private val fr_CD_Units: String? = null

  private val fr_CD_Prefixes: String? = null

  private val fr_CF_Units: String? = null

  private val fr_CF_Prefixes: String? = null

  private val fr_CG_Units: String? = null

  private val fr_CG_Prefixes: String? = null

  private val fr_CH_Units: String? = null

  private val fr_CH_Prefixes: String? = null

  private val fr_CI_Units: String? = null

  private val fr_CI_Prefixes: String? = null

  private val fr_CM_Units: String? = null

  private val fr_CM_Prefixes: String? = null

  private val fr_DJ_Units: String? = null

  private val fr_DJ_Prefixes: String? = null

  private val fr_DZ_Units: String? = null

  private val fr_DZ_Prefixes: String? = null

  private val fr_GA_Units: String? = null

  private val fr_GA_Prefixes: String? = null

  private val fr_GF_Units: String? = null

  private val fr_GF_Prefixes: String? = null

  private val fr_GN_Units: String? = null

  private val fr_GN_Prefixes: String? = null

  private val fr_GP_Units: String? = null

  private val fr_GP_Prefixes: String? = null

  private val fr_GQ_Units: String? = null

  private val fr_GQ_Prefixes: String? = null

  private val fr_HT_Units: String by lazy {
    """hectare,,,,,,,,,carreau,,{0}carreau,{0}carreaux
        cubic-centimeter,,,,,,,,,centimètres cubes,{0} pour chaque centimetre cube,{0} centimètre cube,{0} centimètres cubes
        cubic-meter,,,,,,,,,mètres cubes,{0} pour chaque metre cube,{0} mètre cube,{0} mètres cubes
        century,sec,,{0}s.,{0}s.,sec,,{0} s.,{0} s.,,,,
        carat,kr,,{0}ct,{0}ct,kr,,{0}kr,{0}kr,,,,
        gram,gr.,{0}/g,{0}g,{0}g,g,{0}/g,{0}gr,{0}gr,,,,
        """.trimIndent()
  }

  private val fr_HT_Prefixes: String? = null

  private val fr_KM_Units: String? = null

  private val fr_KM_Prefixes: String? = null

  private val fr_LU_Units: String? = null

  private val fr_LU_Prefixes: String? = null

  private val fr_MA_Units: String? = null

  private val fr_MA_Prefixes: String? = null

  private val fr_MC_Units: String? = null

  private val fr_MC_Prefixes: String? = null

  private val fr_MF_Units: String? = null

  private val fr_MF_Prefixes: String? = null

  private val fr_MG_Units: String? = null

  private val fr_MG_Prefixes: String? = null

  private val fr_ML_Units: String? = null

  private val fr_ML_Prefixes: String? = null

  private val fr_MQ_Units: String? = null

  private val fr_MQ_Prefixes: String? = null

  private val fr_MR_Units: String? = null

  private val fr_MR_Prefixes: String? = null

  private val fr_MU_Units: String? = null

  private val fr_MU_Prefixes: String? = null

  private val fr_NC_Units: String? = null

  private val fr_NC_Prefixes: String? = null

  private val fr_NE_Units: String? = null

  private val fr_NE_Prefixes: String? = null

  private val fr_PF_Units: String? = null

  private val fr_PF_Prefixes: String? = null

  private val fr_PM_Units: String? = null

  private val fr_PM_Prefixes: String? = null

  private val fr_RE_Units: String? = null

  private val fr_RE_Prefixes: String? = null

  private val fr_RW_Units: String? = null

  private val fr_RW_Prefixes: String? = null

  private val fr_SC_Units: String? = null

  private val fr_SC_Prefixes: String? = null

  private val fr_SN_Units: String? = null

  private val fr_SN_Prefixes: String? = null

  private val fr_SY_Units: String? = null

  private val fr_SY_Prefixes: String? = null

  private val fr_TD_Units: String? = null

  private val fr_TD_Prefixes: String? = null

  private val fr_TG_Units: String? = null

  private val fr_TG_Prefixes: String? = null

  private val fr_TN_Units: String? = null

  private val fr_TN_Prefixes: String? = null

  private val fr_VU_Units: String? = null

  private val fr_VU_Prefixes: String? = null

  private val fr_WF_Units: String? = null

  private val fr_WF_Prefixes: String? = null

  private val fr_YT_Units: String? = null

  private val fr_YT_Prefixes: String? = null

  private val frr_Units: String? = null

  private val frr_Prefixes: String? = null

  private val fur_Units: String by lazy {
    """day,zornadis,{0}/d,,{0} d,zornadis,{0}/d,,{0} d,zornadis,{0}/d,{0} zornade,{0} zornadis
        hour,oris,{0}/h,,{0} h,oris,{0}/h,,{0} h,oris,{0}/h,{0} ore,{0} oris
        minute,minûts,{0}/min,,{0} min,minûts,{0}/min,,{0} min,minûts,{0}/min,{0} minût,{0} minûts
        month,mês,{0}/m,,{0} m,mês,{0}/m,,{0} m,mês,{0}/m,{0} mês,{0} mês
        second,seconts,{0}/s,,{0} s,seconts,{0}/s,,{0} s,seconts,{0}/s,{0} secont,{0} seconts
        week,setemanis,{0}/w,,{0} w,setemanis,{0}/w,,{0} w,setemanis,{0}/w,{0} setemane,{0} setemanis
        year,agns,{0}/y,,{0} y,agns,{0}/y,,{0} y,agns,{0}/y,{0} an,{0} agns
        """.trimIndent()
  }

  private val fur_Prefixes: String? = null

  private val fy_Units: String by lazy {
    """g-force,G-krachten,,,{0} G,G-krachten,,,{0} G,G-krachten,,{0} G-kracht,{0} G-krachten
        arc-minute,boogminuten,,,{0}′,boogminuten,,,{0}′,boogminuten,,{0} boogminút,{0} boogminuten
        arc-second,boogsekonden,,,{0}″,boogsekonden,,,{0}″,boogsekonden,,{0} boogsekonde,{0} boogsekonden
        degree,booggraden,,,{0}°,booggraden,,,{0}°,booggraden,,{0} booggraad,{0} booggraden
        acre,ares,,{0} acre,{0} acres,ares,,{0} are,{0} ares,ares,,{0} are,{0} ares
        hectare,hektare,,,{0} ha,hektare,,,{0} ha,hektare,,{0} hektare,{0} hektare
        square-foot,fjouwerkante foet,,,{0} ft²,fjouwerkante foet,,,{0} ft²,fjouwerkante foet,,{0} fjouwerkante foet,{0} fjouwerkante foet
        square-kilometer,fjouwerkante kilometer,{0}/km²,,{0} km²,fjouwerkante kilometer,{0}/km²,,{0} km²,fjouwerkante kilometer,{0}/km²,{0} fjouwerkante kilometer,{0} fjouwerkante kilometer
        square-meter,fjouwerkante meter,{0}/m²,,{0} m²,fjouwerkante meter,{0}/m²,,{0} m²,fjouwerkante meter,{0}/m²,{0} fjouwerkante meter,{0} fjouwerkante meter
        square-mile,fjouwerkante myl,{0}/mi²,,{0} mi²,fjouwerkante myl,{0}/mi²,,{0} mi²,fjouwerkante myl,{0}/mi²,{0} fjouwerkante myl,{0} fjouwerkante myl
        day,deien,{0}/d,{0} d,{0} d,deien,{0}/d,{0} dei,{0} deien,deien,{0}/d,{0} dei,{0} deien
        hour,oere,{0}/h,{0} u,{0} u,oere,{0}/h,{0} oere,{0} oere,oere,{0}/h,{0} oere,{0} oere
        millisecond,millisekonden,,,{0} ms,millisekonden,,,{0} ms,millisekonden,,{0} millisekonde,{0} millisekonden
        minute,minuten,{0}/min,{0} m,{0} m,minuten,{0}/min,,{0} min,minuten,{0}/min,{0} minút,{0} minuten
        month,moanneen,{0}/m,{0} m,{0} m,moanneen,{0}/m,{0} mn,{0} mn,moanneen,{0}/m,{0} moanne,{0} moanneen
        second,sekonden,{0}/s,{0} s,{0} s,sekonden,{0}/s,{0} sek.,{0} sek.,sekonden,{0}/s,{0} sekonde,{0} sekonden
        week,wiken,{0}/w,{0} w,{0} w,wiken,{0}/w,{0} wk,{0} wkn,wiken,{0}/w,{0} wike,{0} wiken
        year,jier,{0}/y,{0} jr,{0} jr,jier,{0}/y,{0} jr,{0} jr,jier,{0}/y,{0} jier,{0} jier
        centimeter,sentimeter,{0}/cm,{0} cm,{0} cm,sentimeter,{0}/cm,{0} sm,{0} sm,sentimeter,{0}/cm,{0} sentimeter,{0} sentimeter
        foot,foet,{0}/ft,,{0} ft,foet,{0}/ft,,{0} ft,foet,{0}/ft,{0} foet,{0} foet
        inch,tommen,{0}/in,{0}'',{0}'',tommen,{0}/in,{0} tm,{0} tm,tommen,{0}/in,{0} tomme,{0} tommen
        kilometer,kilometer,{0}/km,,{0} km,kilometer,{0}/km,,{0} km,kilometer,{0}/km,{0} kilometer,{0} kilometer
        light-year,ljochtjier,,{0} lj,{0} lj,ljochtjier,,{0} lj,{0} lj,ljochtjier,,{0} ljochtjier,{0} ljochtjier
        meter,,,,,,,,,meter,{0}/m,{0} meter,{0} meter
        mile,myl,,,{0} mi,myl,,,{0} mi,myl,,{0} myl,{0} myl
        millimeter,millimeter,,,{0} mm,millimeter,,,{0} mm,millimeter,,{0} millimeter,{0} millimeter
        picometer,pikometer,,,{0} pm,pikometer,,,{0} pm,pikometer,,{0} pikometer,{0} pikometer
        yard,yards,,,{0} yd,yards,,,{0} yd,yards,,{0} yard,{0} yards
        gram,,,,,,,,,gram,{0}/g,{0} gram,{0} gram
        kilogram,kilogram,{0}/kg,,{0} kg,kilogram,{0}/kg,,{0} kg,kilogram,{0}/kg,{0} kilogram,{0} kilogram
        horsepower,hynstekrêften,,{0} pk,{0} pk,hynstekrêften,,{0} pk,{0} pk,hynstekrêften,,{0} hynstekrêft,{0} hynstekrêften
        kilowatt,kilowatt,,,{0} kW,kilowatt,,,{0} kW,kilowatt,,{0} kilowatt,{0} kilowatt
        watt,,,,,,,,,watt,,{0} watt,{0} watt
        hectopascal,hektopaskal,,,{0} hPa,hektopaskal,,,{0} hPa,hektopaskal,,{0} hektopaskal,{0} hektopaskal
        millibar,millibar,,,{0} mbar,millibar,,,{0} mbar,millibar,,{0} millibar,{0} millibar
        kilometer-per-hour,kilometer de oere,,,{0} km/h,kilometer de oere,,,{0} km/h,kilometer de oere,,{0} kilometer de oere,{0} kilometer de oere
        meter-per-second,meter de sekonde,,,{0} m/s,meter de sekonde,,,{0} m/s,meter de sekonde,,{0} meter de sekonde,{0} meter de sekonde
        mile-per-hour,myl de oere,,,{0} mi/h,myl de oere,,,{0} mi/h,myl de oere,,{0} myl de oere,{0} myl de oere
        celsius,graden Celsius,,{0}°,{0}°,graden Celsius,,,{0}°C,graden Celsius,,{0} graad Celsius,{0} graden Celsius
        fahrenheit,graden Fahrenheit,,,{0}°F,graden Fahrenheit,,,{0}°F,graden Fahrenheit,,{0} graad Fahrenheit,{0} graden Fahrenheit
        cubic-kilometer,kubike kilometer,,,{0} km³,kubike kilometer,,,{0} km³,kubike kilometer,,{0} kubike kilometer,{0} kubike kilometer
        cubic-mile,kubike myl,,,{0} mi³,kubike myl,,,{0} mi³,kubike myl,,{0} kubike myl,{0} kubike myl
        liter,,,,,,,,,liter,{0}/l,{0} liter,{0} liter
        """.trimIndent()
  }

  private val fy_Prefixes: String by lazy {
    """per,,,{0} per {1}
        """.trimIndent()
  }

  private val ga_Units: String by lazy {
    """g-force,g-fhórsa,,{0}G,{0}G,g-fhórsa,,,{0} G,g-fhórsa,,{0} g-fhórsa,{0} g-fhórsa
        meter-per-square-second,,,,,,,,,méadair sa soicind cearnaithe,,,{0} m/s²
        arc-minute,nóim. stua,,,{0}′,nóiméid stua,,,{0}′,nóiméid stua,,{0} nóiméad stua,{0} nóiméad stua
        arc-second,soic. stua,,,{0}″,soic. stua,,,{0}″,soicindí stua,,{0} soicind stua,{0} soicind stua
        degree,céim,,,{0}°,céimeanna,,,{0}°,céimeanna,,{0} chéim,{0} céim
        radian,raid,,{0}raid,{0}raid,raidiain,,{0} raid,{0} raid,raidiain,,{0} raidian,{0} raidian
        revolution,imr,,{0} imr,{0} imr,imr,,{0} imr,{0} imr,imrothlú,,{0} imrothlú,{0} imrothlú
        acre,acraí,,,{0} ac,acraí,,,{0} ac,acraí,,{0} acra,{0} acra
        dunam,dunaim,,{0} dunam,{0} dunam,dunaim,,{0} dunam,{0} dunam,dúnaim,,{0} dunam,{0} dunam
        hectare,heicteáir,,,{0} ha,heicteáir,,,{0} ha,heicteáir,,{0} heicteár,{0} heicteár
        square-centimeter,,,,,,,,,ceintiméadair chearnacha,{0} sa cheintiméadar cearnach,{0} cheintiméadar cearnach,{0} ceintiméadar cearnach
        square-foot,tr²,,{0} tr²,{0} tr²,tr²,,{0} tr²,{0} tr²,troithe cearnacha,,{0} troigh chearnach,{0} troigh chearnach
        square-inch,or²,{0}/or²,{0} or²,{0} or²,or²,{0}/or²,{0} or²,{0} or²,orlaí cearnacha,{0} san orlach cearnach,{0} orlach cearnach,{0} orlach cearnach
        square-kilometer,,,,,,,,,ciliméadair chearnacha,{0} sa chiliméadar cearnach,{0} chiliméadar cearnach,{0} ciliméadar cearnach
        square-meter,,,,,,,,,méadair chearnacha,{0} sa mhéadar cearnach,{0} mhéadar cearnach,{0} méadar cearnach
        square-mile,mílte²,{0}/mi²,{0} mhíle²,{0} míle²,mílte²,{0}/mi²,{0} mhíle²,{0} míle²,mílte cearnacha,{0} sa mhíle cearnach,{0} mhíle cearnach,{0} míle cearnach
        square-yard,slata²,,{0} sl²,{0} sl²,slata²,,{0} sl²,{0} sl²,slata cearnacha,,{0} slat chearnach,{0} slat chearnach
        karat,kt,,{0}kt,{0}kt,,,,,carait,,{0} charat óir,{0} carat óir
        milligram-ofglucose-per-deciliter,,,,,,,,,milleagraim sa deicilítear,,{0} mhilleagram sa deicilítear,{0} milleagram sa deicilítear
        millimole-per-liter,milleamól/lítear,,,{0} mmol/L,milleamól/lítear,,,{0} mmol/L,milleamóil sa lítear,,{0} mhilleamól sa lítear,{0} milleamól sa lítear
        mole,mól,,{0} mhól,{0} mól,mól,,{0} mhól,{0} mól,móil,,{0} mhól,{0} mól
        percent,,,,,faoin gcéad,,,{0}%,faoin gcéad,,{0} faoin gcéad,{0} faoin gcéad
        permille,faoin míle,,,{0}‰,faoin míle,,,{0}‰,faoin míle,,{0} faoin míle,{0} faoin míle
        permillion,codanna/milliún,,{0}/milliún,{0}/milliún,codanna/milliún,,{0}/milliún,{0}/milliún,codanna sa mhilliún,,{0} chuid sa mhilliún,{0} cuid sa mhilliún
        permyriad,permeiriad,,,{0}‱,permeiriad,,,{0}‱,faoin deich míle,,{0} faoin deich míle,{0}‱
        liter-per-100-kilometer,l/100km,,{0}l/100km,{0}l/100km,l/100km,,{0} l/100km,{0} l/100km,lítir sa 100 ciliméadar,,{0} lítear sa 100 ciliméadar,{0} lítear sa 100 ciliméadar
        liter-per-kilometer,l/km,,{0}l/km,{0}l/km,lítir/km,,{0} l/km,{0} l/km,lítir sa chiliméadar,,{0} lítear sa chiliméadar,{0} lítear sa chiliméadar
        mile-per-gallon,mílte/gal,,{0}míle/g,{0}míle/g,mílte/gal,,{0} mhíle/gal,{0} míle/gal,mílte an galún,,{0} mhíle an galún,{0} míle an galún
        mile-per-gallon-imperial,mílte/gal. imp.,,{0}m/gRA,{0}m/gRA,mílte/gal. imp.,,{0} msg imp,{0} msg imp,mílte sa ghalún impiriúil,,{0} mhíle sa ghalún impiriúil,{0} míle sa ghalún impiriúil
        bit,giotán,,{0} ghiot.,{0} giot.,giotán,,{0} ghiotán,{0} giotán,giotáin,,{0} ghiotán,{0} giotán
        byte,bearta,,{0}B,{0}B,bearta,,{0} bheart,{0} beart,bearta,,{0} bheart,{0} beart
        gigabit,Gb,,{0}Gb,{0}Gb,,,,,gigighiotáin,,{0} ghigighiotán,{0} gigighiotán
        gigabyte,GB,,{0}GB,{0}GB,,,,,gigibhearta,,{0} ghigibheart,{0} gigibheart
        kilobit,kb,,{0}kb,{0}kb,,,,,cilighiotáin,,{0} chilighiotán,{0} cilighiotán
        kilobyte,kB,,{0}kB,{0}kB,,,,,cilibhearta,,{0} chilibheart,{0} cilibheart
        megabit,Mb,,{0}Mb,{0}Mb,,,,,meigighiotáin,,{0} mheigighiotán,{0} meigighiotán
        megabyte,MB,,{0}MB,{0}MB,,,,,meigibhearta,,{0} mheigibheart,{0} meigibheart
        petabyte,PBheart,,,{0} PB,PBheart,,,{0} PB,peitibhearta,,{0} peitibheart,{0} petabytes
        terabit,Tb,,{0}Tb,{0}Tb,,,,,teirighiotáin,,{0} teirighiotán,{0} teirighiotán
        terabyte,TB,,{0}TB,{0}TB,,,,,teiribhearta,,{0} teiribheart,{0} teiribheart
        century,céadta bl,,,{0} c,céadta bl,,,{0} c,na céadta bliain,,céad bliain,{0} céad bliain
        day,lá,{0}/lá,{0} lá,{0} lá,lá,{0}/lá,{0} lá,{0} lá,lá,{0} sa lá,{0} lá,{0} lá
        decade,,,,,,,,,deicheanna blianta,,{0} deich mbliana,{0} deich mbliana
        hour,uair,{0}/u,{0} u,{0} u,uair,{0}/u,{0} u,{0} u,uair,{0}/u,{0} u,{0} u
        millisecond,,,,,,,,,msoic,,,{0} ms
        minute,nóim,{0}/nóim,{0} nóim,{0} nóim,nóim,{0}/nóim,{0} nóim,{0} nóim,nóim,{0}/nóim,{0} nóim,{0} nóim
        month,míonna,{0}/mí,{0}m,{0} m,míonna,{0}/mí,{0} mí,{0} m,míonna,{0}/mí,{0} mhí,{0} mí
        nanosecond,ns,,{0}ns,{0}ns,,,,,nanashoicindí,,{0} nanashoicind,{0} nanashoicind
        night,oí,{0}/oíche,{0}oí,{0}oí,oícheanta,{0}/oíche,{0} oíche,{0} oíche,oícheanta,{0} san oíche,{0} oíche amháin,{0} oíche
        quarter,ctú,{0}/c,{0} ctú,{0} ctú,ctú,{0}/c,{0} ctú,{0} cna,ceathrúna,{0}/c,{0} ceathrú,{0} ceathrúna
        second,soic,{0}/s,{0} soic,{0} soic,soic,{0}/s,{0} soic,{0} soic,soic,{0}/s,{0} soic,{0} soic
        week,scht,{0}/scht,{0} scht,{0} scht,scht,{0}/scht,{0} scht,{0} scht,scht,{0}/scht,{0} scht,{0} scht
        year,blianta,{0}/bl,{0} bl,{0} bl,blianta,{0}/y,{0} bl,{0} bl,blianta,{0} sa bhliain,{0} bhliain,{0} bl
        ampere,aimpéir,,{0}A,{0}A,aimpéir,,,{0} A,aimpéir,,{0} aimpéar,{0} aimpéar
        milliampere,mA,,{0}mA,{0}mA,miollaimp,,,{0} mA,miollaimpéir,,{0} mhiollaimpéar,{0} miollaimpéar
        ohm,Ω,,{0}Ω,{0}Ω,óim,,,{0} Ω,óim,,{0} óm,{0} óm
        volt,volta,,{0}V,{0}V,voltanna,,,{0} V,voltanna,,{0} volta,{0} volta
        british-thermal-unit,BTU,,,{0} Btu,BTU,,,{0} Btu,teas-aonaid Bhriotanacha,,{0} theas-aonad Briotanach,{0} aonad teirmeach Briotanach
        calorie,cal,,{0}cal,{0}cal,,,,,calraí,,{0} chalra,{0} calra
        electronvolt,leictravolta,,,{0} eV,leictravolta,,,{0} eV,leictreonvoltanna,,{0} leictreavolta,{0} leictreonvolta
        foodcalorie,Cal,,{0}Cal,{0}Cal,Cal,,{0} Cal,{0} Cal,Calraí,,{0} Chalra,{0} Calra
        joule,giúil,,{0}J,{0}J,giúil,,,{0} J,giúil,,{0} ghiúl,{0} giúl
        kilocalorie,kcal,,{0}kcal,{0}kcal,,,,,cileacalraí,,{0} chileacalra,{0} cileacalra
        kilojoule,kJ,,{0}kJ,{0}kJ,ciligiúl,,,{0} kJ,ciligiúil,,{0} chiligiúl,{0} ciligiúl
        kilowatt-hour,kW-uair,,{0}kWh,{0}kWh,kW-uair,,,{0} kWh,cileavatuaireanta,,{0} chileavatuair,{0} cileavatuair
        therm-us,teirmeacha SAM,,{0} teirm SAM,{0} teirm SAM,teirmeacha SAM,,{0} teirm SAM,{0} teirm SAM,teirmeacha SAM,,{0} teirm SAM,{0} teirm SAM
        kilowatt-hour-per-100-kilometer,,,,,,,,,cileavatuair in aghaidh 100 ciliméadar,,cileavatuair in aghaidh 100 ciliméadar,{0} cileavatuair in aghaidh 100 ciliméadar
        newton,niútan,,,{0} N,niútan,,,{0} N,niútain,,{0} niútan,{0} niútan
        pound-force,punt-fhórsa,,,{0} lbf,punt-fhórsa,,,{0} lbf,puint fórsa,,{0} punt fórsa,{0} lbf
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,gigiheirts,,{0} ghigiheirts,{0} gigiheirts
        hertz,Hz,,{0}Hz,{0}Hz,,,,,heirts,,{0} heirts,{0} heirts
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,ciliheirts,,{0} chiliheirts,{0} ciliheirts
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,meigiheirts,,{0} mheigiheirts,{0} meigiheirts
        dot,ponc,,{0} phonc,{0} ponc,ponc,,{0} phonc,{0} ponc,ponc,,{0} phonc,{0} ponc
        em,eim,,{0} eim,{0} eim,eim,,{0} eim,{0} em,eim,,{0} eim,{0} eim
        megapixel,meigiphicteilíní,,,{0} MP,meigiphicteilíní,,,{0} MP,meigiphicteilíní,,{0} mheigiphicteilín,{0} meigiphicteilín
        pixel,picteilíní,,,{0} px,picteilíní,,,{0} px,picteilíní,,,{0} px
        pixel-per-inch,,,,,,,,,picteilíní san orlach,,,{0} ppi
        astronomical-unit,AR,,{0} AR,{0} AR,AR,,{0} AR,{0} AR,aonaid réalteolaíocha,,{0} aonad réalteolaíoch,{0} AR
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,ceintiméadair,{0} sa cheintiméadar,{0} cheintiméadar,{0} ceintiméadar
        decimeter,dm,,{0}dm,{0}dm,,,,,deiciméadair,,{0} deiciméadar,{0} deiciméadar
        earth-radius,,,,,,,,,ga an domhain,,{0} gha an domhain,{0} ga an domhain
        fathom,feánna,,,{0} fth,feánna,,,{0} fth,feánna,,,{0} fth
        foot,tr,{0}/tr.,{0} tr.,{0} tr.,troithe,{0}/tr.,{0} tr.,{0} tr.,troithe,{0} sa troigh,{0} troigh,{0} tr.
        furlong,staideanna,,{0} st,{0} st,staideanna,,{0} st,{0} st,staideanna,,{0} st,{0} st
        inch,orlaí,{0}/or.,{0} or.,{0} or.,orlaí,{0}/or.,{0} or.,{0} or.,orlaí,{0}/or.,{0} orlach,{0} orlach
        kilometer,km,{0}/km,{0}km,{0}km,,,,,ciliméadair,{0} sa chiliméadar,{0} chiliméadar,{0} ciliméadar
        light-year,solasbhl.,,{0}sbh,{0} sbh,solasbhl.,,{0} sbh,{0} sbh,solasbhl.,,{0} solasbhliain,{0} sbh
        meter,méadar,{0}/m,{0}m,{0}m,méadair,{0}/m,,{0} m,méadair,{0} sa mhéadar,{0} mhéadar,{0} méadar
        micrometer,μm,,{0}μm,{0}μm,μméadair,,,{0} μm,micriméadair,,{0} mhicriméadar,{0} micriméadar
        mile,mílte,,{0} mhíle,{0} míle,mílte,,{0} mhíle,{0} mi,mílte,,{0} mhíle,{0} míle
        mile-scandinavian,míle Lochl.,,{0} m lch,{0} m lch,míle Lochl.,,{0} míle Lch,{0} míle Lch,míle Lochlannach,,{0} mhíle Lochlannach,{0} míle Lochlannach
        millimeter,mm,,{0}mm,{0}mm,,,,,milliméadair,,{0} mhilliméadar,{0} milliméadar
        nanometer,nm,,{0}nm,{0}nm,,,,,nanaiméadair,,{0} nanaiméadar,{0} nanaiméadar
        nautical-mile,muirmh.,,{0} mhuirmh.,{0} muirmh.,muirmh.,,{0} muirmh.,{0} muirmh.,muirmh.,,{0} mhuirmhíle,{0} muirmh.
        parsec,,,,,,,,,parsoiceanna,,{0} pharsoic,{0} parsoic
        picometer,pm,,{0}pm,{0}pm,,,,,piciméadair,,{0} phiciméadar,{0} piciméadar
        point,pointí,,,{0} pt,pointí,,,{0} pt,pointí,,,{0} pt
        solar-radius,raonta gréine,,,{0} R☉,raonta gréine,,,{0} R☉,raonta gréine,,{0} ghriangha,{0} griangha
        yard,sl,,{0}sl,{0}sl,slata,,{0} sl.,{0} sl.,slata,,{0} slat,{0} slat
        candela,,,,,,,,,caindéile,,{0} chaindéile,{0} caindéile
        lumen,,,,,,,,,lúman,,{0} lúman,{0} lúman
        lux,lucsa,,{0}lx,{0}lx,lucsa,,,{0} lx,lucsa,,{0} lucsa,{0} lucsa
        solar-luminosity,lonrachtaí gréine,,,{0} L☉,lonrachtaí gréine,,,{0} L☉,grianlonrachas,,{0} ghrianlonrachas,{0} grianlonrachas
        carat,carat,,{0}CD,{0}CD,carait,,,{0} CD,carait,,{0} charat,{0} carat
        dalton,daltúin,,,{0} Da,daltúin,,,{0} Da,daltúin,,{0} daltún,{0} daltún
        earth-mass,maiseanna an Domhain,,,{0} M⊕,maiseanna an Domhain,,,{0} M⊕,maiseanna an Domhain,,mais an Domhain,{0} mais an Domhain
        grain,gráinne,,{0} ghráinne,{0} gráinne,gráinne,,{0} gráinne,{0} gráinne,gráinne,,{0} ghráinne,{0} gráinne
        gram,gram,{0}/g,{0}g,{0}g,graim,{0}/g,,{0} g,graim,{0} sa ghram,{0} ghram,{0} gram
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,cileagraim,{0} sa chileagram,{0} chileagram,{0} cileagram
        microgram,μg,,{0}μg,{0}μg,,,,,micreagraim,,{0} mhicreagram,{0} micreagram
        milligram,mg,,{0}mg,{0}mg,,,,,milleagraim,,{0} mhilleagram,{0} milleagram
        ounce,unsa,{0}/unsa,{0} unsa,{0} unsa,unsa,{0}/unsa,{0} unsa,{0} unsa,unsaí,{0} san unsa,{0} unsa,{0} unsa
        ounce-troy,unsa t,,{0} unsa t,{0} unsa t,unsa t,,{0} unsa t,{0} unsa t,unsaí troí,,{0} unsa troí,{0} unsa troí
        pound,puint,{0}/punt,{0} phunt,{0} punt,puint,{0}/punt,{0} phunt,{0} punt,puint,{0} sa phunt,{0} phunt,{0} punt
        solar-mass,maiseanna gréine,,,{0} M☉,maiseanna gréine,,,{0} M☉,maiseanna gréine,,{0} mhais ghréine,{0} mais ghréine
        stone,cloch,,{0} chl.,{0} cl.,clocha,,{0} chl.,{0} cl.,clocha,,{0} chloch,{0} cloch
        ton,tonnaí gearra,,{0} t.g.,{0} t.g.,tonnaí gearra,,{0} t.g.,{0} t.g.,tonnaí gearra,,{0} tonna gearr,{0} tonna gearr
        tonne,t,,{0}t,{0}t,,,,,tonnaí méadracha,,{0} tonna méadrach,{0} tonna méadrach
        gigawatt,GW,,{0}GW,{0}GW,,,,,gigeavatanna,,{0} ghigeavata,{0} gigeavata
        horsepower,ec,,{0}ec,{0}ec,ec,,{0} ec,{0} ec,each-chumhacht,,{0} each-chumhacht,{0} each-chumhacht
        kilowatt,kW,,{0}kW,{0}kW,,,,,cileavatanna,,{0} chileavata,{0} cileavata
        megawatt,MW,,{0}MW,{0}MW,,,,,meigeavatanna,,{0} mheigeavata,{0} meigeavata
        milliwatt,mW,,{0}mW,{0}mW,,,,,milleavatanna,,{0} mhilleavata,{0} milleavata
        watt,vataí,,{0}W,{0}W,vataí,,,{0} W,vatanna,,{0} vata,{0} vata
        atmosphere,,,,,,,,,atmaisféir,,{0} atmaisféar,{0} atmaisféar
        bar,barra,,{0} bharra,{0} barra,barra,,{0} bharra,{0} barra,bair,,{0} bharra,{0} barra
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,heicteapascail,,{0} heicteapascal,{0} heicteapascal
        inch-ofhg,orlaí Hg,,{0}″ Hg,{0}″ Hg,orlaí Hg,,{0} or. Hg,{0} or. Hg,orlaí mearcair,,{0} orlach mearcair,{0} orlach mearcair
        kilopascal,,,,,,,,,cileapascail,,{0} chileapascal,{0} kPa
        megapascal,,,,,,,,,meigeapascail,,{0} mheigeapascal,{0} meigeapascal
        millibar,mbar,,{0}mb,{0}mb,,,,,milleabair,,{0} mhilleabar,{0} milleabar
        millimeter-ofhg,mm Hg,,{0}mmHg,{0}mmHg,,,,,milliméadair mearcair,,{0} mhilliméadar mearcair,{0} milliméadar mearcair
        pascal,,,,,,,,,Pascail,,{0} phascal,{0} pascal
        pound-force-per-square-inch,psoc,,{0}psoc,{0}psoc,psoc,,{0} psoc,{0} psoc,puint san orlach cearnach,,{0} phunt san orlach cearnach,{0} punt san orlach cearnach
        kilometer-per-hour,km/uair,,{0} km/u,{0} km/u,km/uair,,{0} km/u,{0} km/u,km/uair,,{0} km/u,{0} km/u
        knot,mrml/u,,{0} mrml/u,{0} mrml/u,mrml/u,,{0} mrml/u,{0} mrml/u,mrml/u,,{0} mhuirmh/u,{0} mrml/u
        mile-per-hour,mílte/uair,,{0} msu,{0} msu,mílte/uair,,{0} msu,{0} msu,mílte/uair,,{0} msu,{0} msu
        celsius,,,,,,,,,céimeanna Celsius,,{0} chéim Celsius,{0} céim Celsius
        fahrenheit,,,,,,,,,céimeanna Fahrenheit,,{0} chéim Fahrenheit,{0} céim Fahrenheit
        kelvin,K,,{0}K,{0}K,,,,,céimeanna ceilvin,,{0} chéim cheilvin,{0} céim cheilvin
        newton-meter,,,,,,,,,méadar niútain,,{0} mhéadar niútain,{0} méadar niútain
        pound-force-foot,,,,,,,,,punt-troigh,,{0} punt-troigh,{0} punt-troigh
        acre-foot,acra-tr,,{0} ac tr,{0} ac tr,acra-tr,,{0} ac tr,{0} ac tr,acra-troithe,,{0} acra-troigh,{0} acra-troigh
        barrel,bairille,,,{0} bbl,bairille,,,{0} bbl,bairillí,,{0} bairille,{0} bbl
        bushel,buiséil,,,{0} bu,buiséil,,,{0} bu,buiséil,,{0} bhuiséal,{0} buiséal
        centiliter,cl,,,{0} cL,,,,,ceintilítir,,{0} cheintilítear,{0} ceintilítear
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,ceintiméadair chiúbacha,{0} sa cheintiméadar ciúbach,{0} cheintiméadar ciúbach,{0} ceintiméadar ciúbach
        cubic-foot,tr³,,{0}tr³,{0}tr³,tr³,,{0} tr³,{0} tr³,troithe ciúbacha,,{0} troigh chiúbach,{0} troigh chiúbach
        cubic-inch,or³,,{0}or³,{0}or³,orlach³,,{0} or³,{0} or³,orlaí ciúbacha,,{0} orlach ciúbach,{0} orlach ciúbach
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,ciliméadair chiúbacha,,{0} chiliméadar ciúbach,{0} ciliméadar ciúbach
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,méadair chiúbacha,{0} sa mhéadar ciúbach,{0} mhéadar ciúbach,{0} méadar ciúbach
        cubic-mile,míle³,,{0} mhíle³,{0} míle³,míle³,,{0} mhíle³,{0} míle³,mílte ciúbacha,,{0} mhíle ciúbach,{0} míle ciúbach
        cubic-yard,sl³,,{0}sl³,{0}sl³,slata³,,{0} sl³,{0} sl³,slata ciúbacha,,{0} slat chiúbach,{0} slat chiúbach
        cup,cupán,,,{0} c,cupáin,,,{0} c,cupáin,,{0} chupán,{0} cupán
        cup-metric,cupán méadr.,,,{0} mc,cupán méadr.,,,{0} mc,cupáin mhéadracha,,{0} chupán méadrach,{0} cupán méadrach
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,deicilítir,,{0} deicilítear,{0} deicilítear
        dessert-spoon,spmhil,,{0} spmhil,{0} spmhil,spmhil,,{0} spmhil,{0} spmhil,spúnóga milseoige,,{0} spúnóg mhilseoige,{0} spúnóg mhilseoige
        dessert-spoon-imperial,spmhil imp,,{0} spmhil imp,{0} spmhil imp,spmhil imp,,{0} spmhil imp,{0} spmhil imp,spúnóga milseoige impiriúla,,{0} spúnóg mhilseoige impiriúil,{0} spúnóg mhilseoige impiriúol
        dram,dr l.,,{0} dr l.,{0} dr l.,dr l.,,{0} dr l.,{0} dr l.,dram leachtach,,{0} dram leachtach,{0} dram leachtach
        drop,braon,,{0} bhraon,{0} braon,braon,,{0} bhraon,{0} braon,braon,,{0} bhraon,{0} braon
        fluid-ounce,unsaí leacht.,,{0} unsa l.,{0} unsa l.,unsaí leacht.,,{0} unsa l.,{0} unsa l.,unsaí leachtacha,,{0} unsa leachtach,{0} unsa leachtach
        fluid-ounce-imperial,Unsa leachtach impiriúil,,,{0} fl oz Imp.,Unsa leachtach impiriúil,,,{0} fl oz Imp.,Unsaí leachtacha impiriúla,,{0} unsa leachtach impiriúil,{0} fl oz Imp.
        gallon,galúin,{0}/gal.,{0} ghal.,{0} gal.,galúin,{0}/gal.,{0} ghal.,{0} gal.,galúin,{0} sa ghalún,{0} ghalún,{0} galún
        gallon-imperial,gal. imp.,{0}/gal. imp.,{0}ghalIm,{0}galIm,gal. imp.,{0}/gal. imp.,{0} ghal. imp.,{0} gal. imp.,galúin impiriúla,{0} sa ghalún impiriúil,{0} ghalún impiriúil,{0} galún impiriúil
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,heictilítir,,{0} heictilítear,{0} heictilítear
        jigger,miosúr,,{0} mhiosúr,{0} miosúr,miosúr,,{0} mhiosúr,{0} miosúr,miosúr,,{0} mhiosúr,{0} miosúr
        liter,lítir,{0}/l,{0}l,{0}l,lítir,{0}/l,,{0} l,lítir,{0} sa lítear,{0} lítear,{0} lítear
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,meigilítir,,{0} mheigilítear,{0} meigilítear
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,millilítir,,{0} mhillilítear,{0} millilítear
        pinch,pinse,,{0} phinse,{0} pinse,pinse,,{0} phinse,{0} pinse,pinse,,{0} phinse,{0} pinse
        pint,piontaí,,,{0} pt,piontaí,,,{0} pt,piontaí,,{0} phionta,{0} pionta
        pint-metric,,,,,,,,,piontaí méadracha,,{0} phionta méadrach,{0} pionta méadrach
        quart,cáirt,,{0} chárt,{0} cárt,cáirt,,{0} chárt,{0} cárt,cáirt,,{0} chárt,{0} cárt
        quart-imperial,cárt impiriúil,,{0} chárt impiriúil,{0} cárt impiriúil,cárt impiriúil,,{0} chárt impiriúil,{0} cárt impiriúil,cárt impiriúil,,{0} chárt impiriúil,{0} cárt impiriúil
        tablespoon,spbh,,{0} spbh,{0} spbh,spbh,,{0} spbh,{0} spbh,spúnóga boird,,{0} spbh,{0} spbh
        teaspoon,,,,,,,,,taespúnóga,,{0} taespúnóg,{0} taespúnóg
        microsecond,μs,,{0}μs,{0}μs,,,,,,,,
        """.trimIndent()
  }

  private val ga_Prefixes: String by lazy {
    """square,,,{0} chearnaithe
        cubic,,,{0} ciúbach
        per,,,{0} sa {1}
        1024p1,,,cibi-{0}
        1024p2,,,mebi{0}
        1024p4,,,tebi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobe{0}
        10p-1,,,deici{0}
        10p-12,,,pici{0}
        10p-15,,,feimti{0}
        10p-18,,,atai{0}
        10p-2,,,ceinti{0}
        10p-21,,,zeipti{0}
        10p-24,,,yoctai{0}
        10p-3,,,milli{0}
        10p-6,,,micri{0}
        10p-9,,,nanai{0}
        10p1,,,deacai{0}
        10p12,,,teiri{0}
        10p15,,,peiti{0}
        10p18,,,eicsi{0}
        10p2,,,heicti{0}
        10p21,,,zeiti{0}
        10p24,,,yotai{0}
        10p3,,,cili{0}
        10p6,,,meigi{0}
        10p9,,,gigi{0}
        """.trimIndent()
  }

  private val ga_GB_Units: String? = null

  private val ga_GB_Prefixes: String? = null

  private val gaa_Units: String? = null

  private val gaa_Prefixes: String? = null

  private val gd_Units: String by lazy {
    """g-force,forsa-g,,{0}G,{0}G,forsa-g,,,{0} G,forsa-g,,{0} fhorsa-g,{0} forsa-g
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,meatair/diog²,,,{0} m/s²,meatair san diog cheàrnagach,,{0} mheatair san diog cheàrnagach,{0} meatair san diog cheàrnagach
        arc-minute,àrc-m,,,{0}′,àrc-mhion.,,,{0}′,àrc-mhionaid,,{0} àrc-mhionaid,{0} àrc-mhionaid
        arc-second,àrc-d,,,{0}″,àrc-dhiog,,,{0}″,àrc-dhiog,,{0} àrc-dhiog,{0} àrc-dhiog
        degree,ceum,,,{0}°,ceum,,,{0}°,ceum,,{0} cheum,{0} ceum
        radian,rad,,{0}rad,{0}rad,rèidean,,,{0} rad,rèidean,,{0} rèidean,{0} rèidean
        revolution,cuairt,,{0}cuairt,{0}cuairt,cuairt,,{0} chuairt,{0} cuairt,cuairt,,{0} chuairt,{0} cuairt
        acre,acair,,{0}ac,{0}ac,acair,,,{0} ac,acair,,{0} acair,{0} acair
        dunam,dönüm,,{0}dönüm,{0}dönüm,dönüm,,{0} dönüm,{0} dönüm,dönüm,,{0} dönüm,{0} dönüm
        hectare,heactair,,{0}ha,{0}ha,heactair,,,{0} ha,heactair,,{0} heactair,{0} heactair
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,,,,,ceudameatair ceàrnagach,{0} sa cheudameatair cheàrnagach,{0} cheudameatair ceàrnagach,{0} ceudameatair ceàrnagach
        square-foot,ft²,,{0}ft²,{0}ft²,troigh²,,{0} troigh²,{0} troigh²,troigh cheàrnagach,,{0} troigh cheàrnagach,{0} troigh cheàrnagach
        square-inch,in²,{0}/in²,{0}in²,{0}in²,òirl²,{0}/òirl²,{0} òirl²,{0} òirl²,òirleach cheàrnagach,{0} san òirleach cheàrnagach,{0} òirleach cheàrnagach,{0} òirleach cheàrnagach
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,cilemeatair ceàrnagach,{0} sa chilemeatair cheàrnagach,{0} chilemeatair ceàrnagach,{0} cilemeatair ceàrnagach
        square-meter,meatair²,{0}/m²,{0}m²,{0}m²,meatair²,{0}/m²,,{0} m²,meatair ceàrnagach,{0} sa mheatair cheàrnagach,{0} mheatair ceàrnagach,{0} meatair ceàrnagach
        square-mile,mì²,{0}/mì²,{0}mì²,{0}mì²,mìle²,{0}/mì²,{0} mì²,{0} mì²,mìle cheàrnagach,{0} sa mhìle cheàrnagach,{0} mhìle cheàrnagach,{0} mìle cheàrnagach
        square-yard,slat²,,{0}yd²,{0}yd²,slat²,,{0} shlat²,{0} slat²,slat cheàrnagach,,{0} shlat cheàrnagach,{0} slat cheàrnagach
        item,nì,,{0}nì,{0}nì,nì,,{0} nì,{0} nì,nì,,{0} nì,{0} nì
        karat,karat,,{0}kt,{0}kt,karat,,,{0} kt,karat,,{0} karat,{0} karat
        milligram-ofglucose-per-deciliter,mg/dL,,{0}mg/dL,{0}mg/dL,,,,,miligram san deicheamh-liotair,,{0} mhiligram san deicheamh-liotair,{0} miligram san deicheamh-liotair
        millimole-per-liter,mmòl/L,,{0}mmòl/L,{0}mmòl/L,mmòl/L,,{0} mmòl/L,{0} mmòl/L,milimòl san liotair,,{0} mhilimòl san liotair,{0} milimòl san liotair
        mole,mòl,,{0}mòl,{0}mòl,mòl,,{0} mòl,{0} mòl,mòl,,{0} mhòl,{0} mòl
        percent,,,,,sa cheud,,,{0}%,sa cheud,,{0} sa cheud,{0} sa cheud
        permille,,,,,sa mhìle,,,{0}‰,sa mhìle,,{0} sa mhìle,{0} sa mhìle
        permillion,ppm,,{0}ppm,{0}ppm,,,,,pàirt sa mhillean,,{0} phàirt sa mhillean,{0} pàirt sa mhillean
        permyriad,,,,,sna deich mìltean,,,{0}‱,sna deich mìltean,,{0} sna deich mìltean,{0} sna deich mìltean
        portion-per-1e9,pàirt/billean,,{0}ppb,{0}ppb,pàirt/billean,,,{0} ppb,pàirt sa bhillean,,{0} phàirt sa bhillean,{0} pàirt sa bhillean
        liter-per-100-kilometer,L/100km,,{0}L/100km,{0}L/100km,,,,,liotair sa 100 chilemeatair,,{0} liotair sa 100 chilemeatair,{0} liotair sa 100 chilemeatair
        liter-per-kilometer,L/km,,{0}L/km,{0}L/km,liotair/km,,,{0} L/km,liotair sa chilemeatair,,{0} liotair sa chilemeatair,{0} liotair sa chilemeatair
        mile-per-gallon,mì/g,,{0}mì/g,{0}mì/g,mìle/gal,,{0} mì/g,{0} mì/g,mìle sa ghalan,,{0} mhìle sa ghalan,{0} mìle sa ghalan
        mile-per-gallon-imperial,mìle/gal RA,,{0}m/gRA,{0}m/gRA,mìle/gal ìmp.,,{0} mhì/gal ìmp.,{0} mì/gal ìmp.,mìle sa ghalan ìmpireil,,{0} mhìle sa ghalan ìmpireil,{0} mìle sa ghalan ìmpireil
        bit,biod,,{0}b,{0}b,biod,,{0} b,{0} b,biod,,{0} bhiod,{0} biod
        byte,baidht,,{0}B,{0}B,baidht,,{0} B,{0} B,baidht,,{0} bhaidht,{0} baidht
        gigabit,Gb,,{0}Gb,{0}Gb,,,,,giga-biod,,{0} ghiga-biod,{0} giga-biod
        gigabyte,GB,,{0}GB,{0}GB,,,,,giga-baidht,,{0} ghiga-baidht,{0} giga-baidht
        kilobit,kb,,{0}kb,{0}kb,,,,,cilebiod,,{0} chilebiod,{0} cilebiod
        kilobyte,kB,,{0}kB,{0}kB,,,,,cileabaidht,,{0} chileabaidht,{0} cileabaidht
        megabit,Mb,,{0}Mb,{0}Mb,,,,,meaga-biod,,{0} mheaga-biod,{0} meaga-biod
        megabyte,MB,,{0}MB,{0}MB,,,,,meaga-baidht,,{0} mheaga-baidht,{0} meaga-baidht
        petabyte,PB,,{0}PB,{0}PB,,,,,peta-baidht,,{0} pheta-baidht,{0} peta-baidht
        terabit,Tb,,{0}Tb,{0}Tb,,,,,tera-biod,,{0} tera-biod,{0} tera-biod
        terabyte,TB,,{0}TB,{0}TB,,,,,tera-baidht,,{0} tera-baidht,{0} tera-baidht
        century,li,,{0}li,{0}li,li,,{0} li,{0} li,linn,,{0} linn,{0} linn
        day,là,{0}/là,{0}là,{0}là,latha,{0}/là,{0} là,{0} là,latha,{0} san latha,{0} latha,{0} latha
        decade,deich,,{0}deich,{0}deich,deich,,{0} deich,{0} deich,deichead,,{0} deichead,{0} deichead
        hour,uair,{0}/u,{0}u,{0}u,uair,{0}/uair,{0} uair,{0} uair,uair a thìde,{0} san uair,{0} uair a thìde,{0} uair a thìde
        microsecond,μs,,{0}μs,{0}μs,μ-diog,,,{0} μs,micreo-diog,,{0} mhicreo-diog,{0} micreo-diog
        millisecond,ms,,{0}ms,{0}ms,mili-diog,,,{0} ms,mili-diog,,{0} mhili-diog,{0} mili-diog
        minute,mion,{0}/mion,{0}m,{0}m,mion,{0}/mion,{0} mhion,{0} mion,mionaid,{0} sa mhionaid,{0} mhionaid,{0} mionaid
        month,mìos,{0}/m,{0}m,{0}m,mìos,{0}/m,{0} mhìos,{0} mìos,mìos,{0} sa mhìos,{0} mhìos,{0} mìos
        nanosecond,ns,,{0}ns,{0}ns,nano-diog,,,{0} ns,nano-diog,,{0} nano-diog,{0} nano-diog
        night,oidhche,{0}/oidh.,{0}oidh.,{0}oidh.,oidhche,{0}/oidhche,{0} oidhche,{0} oidhche,oidhche,{0}/oidhche,{0} oidhche,{0} oidhche
        quarter,c,{0}/c,{0}c,{0}c,cairt.,{0}/c,{0} chairt.,{0} cairt.,cairteal,{0}/c,{0} chairteal,{0} cairteal
        second,diog,{0}/d,{0}d,{0}d,diog,{0}/d,{0} diog,{0} diog,diog,{0} san diog,{0} diog,{0} diog
        week,s,{0}/s,{0}s,{0}s,seachd,{0}/sn,{0} shn,{0} sn,seachdain,{0} san t-seachdain,{0} seachdain,{0} seachdain
        year,blia,{0}/bl,{0}bl,{0}bl,bliadhna,{0}/bl,{0} bhlia,{0} blia,bliadhna,{0} sa bhliadhna,{0} bhliadhna,{0} bliadhna
        ampere,amp,,{0}A,{0}A,,,,,ampère,,{0} ampère,{0} ampère
        milliampere,mA,,{0}mA,{0}mA,mille-amp,,,{0} mA,mille-ampère,,{0} mhille-ampère,{0} mille-ampère
        ohm,ohm,,{0}Ω,{0}Ω,,,,,ohm,,{0} ohm,{0} ohm
        volt,volt,,{0}V,{0}V,,,,,volt,,{0} volt,{0} volt
        british-thermal-unit,Btu,,{0}Btu,{0}Btu,aonad-teasa Breatannach,,,{0} Btu,aonad-teasa Breatannach,,{0} aonad-teasa Breatannach,{0} aonad-teasa Breatannach
        calorie,cal,,{0}cal,{0}cal,,,,,calaraidh,,{0} chalaraidh,{0} calaraidh
        electronvolt,eV,,{0}eV,{0}eV,volt-eleactroin,,,{0} eV,volt-eleactroin,,{0} volt-eleactroin,{0} volt-eleactroin
        foodcalorie,Cal,,{0}Cal,{0}Cal,Cal,,{0} Cal,{0} Cal,calaraidh bidhe,,{0} chalaraidh bidhe,{0} calaraidh bidhe
        joule,joule,,{0}J,{0}J,,,,,joule,,{0} joule,{0} joule
        kilocalorie,kcal,,{0}kcal,{0}kcal,,,,,cileacalaraidh,,{0} chileacalaraidh,{0} cileacalaraidh
        kilojoule,kJ,,{0}kJ,{0}kJ,cilea-joule,,,{0} kJ,cilea-joule,,{0} chilea-joule,{0} cilea-joule
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,kW-uair,,,{0} kWh,cilea-watt-uair,,{0} chilea-watt-uair,{0} cilea-watt-uair
        therm-us,US therm,,{0}US therm,{0}US therm,aonad-teasa nan SA,,,{0} US therm,aonad-teasa nan SA,,{0} aonad-teasa nan SA,{0} aonad-teasa nan SA
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0}kWh/100km,,,,,cilea-watt-uair sa cheud chilemeatair,,{0} chilea-watt-uair sa cheud chilemeatair,{0} cilea-watt-uair sa cheud chilemeatair
        newton,N,,{0}N,{0}N,newton,,,{0} N,newton,,{0} newton,{0} newton
        pound-force,lbf,,{0}lbf,{0}lbf,punnd-fhorsa,,,{0} lbf,punnd de dh’fhorsa,,{0} phunnd de dh’fhorsa,{0} punnd de dh’fhorsa
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,giga-hertz,,{0} ghiga-hertz,{0} giga-hertz
        hertz,Hz,,{0}Hz,{0}Hz,,,,,hertz,,{0} hertz,{0} hertz
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,cile-hertz,,{0} chile-hertz,{0} cile-hertz
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,meaga-hertz,,{0} mheaga-hertz,{0} meaga-hertz
        dot,dot,,{0}dot,{0}dot,dotag,,{0} dot,{0} dot,dotag,,{0} dotag,{0} dotag
        dot-per-centimeter,dpcm,,{0}dpcm,{0}dpcm,dpcm,,{0} dpcm,{0} dpcm,dotag sa cheudameatair,,{0} dotag sa cheudameatair,{0} dotag sa cheudameatair
        dot-per-inch,dpi,,{0}dpi,{0}dpi,dpi,,{0} dpi,{0} dpi,dotag san òirleach,,{0} dotag san òirleach,{0} dotag san òirleach
        em,em,,{0}em,{0}em,,,,,em chlò-ghrafach,,,{0} em
        megapixel,MP,,{0}MP,{0}MP,meaga-piogsail,,,{0} MP,meaga-piogsail,,{0} mheaga-piogsail,{0} meaga-piogsail
        pixel,px,,{0}px,{0}px,piogsail,,,{0} px,piogsail,,{0} phiogsail,{0} piogsail
        pixel-per-centimeter,ppcm,,{0}ppcm,{0}ppcm,,,,,piogsail sa cheudameatair,,{0} phiogsail sa cheudameatair,{0} piogsail sa cheudameatair
        pixel-per-inch,ppi,,{0}ppi,{0}ppi,,,,,piogsail san òirleach,,{0} phiogsail san òirleach,{0} piogsail san òirleach
        astronomical-unit,au,,{0}au,{0}au,,,,,aonad reul-eòlach,,{0} aonad reul-eòlach,{0} aonad reul-eòlach
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,ceudameatair,{0} sa cheudameatair,{0} cheudameatair,{0} ceudameatair
        decimeter,dm,,{0}dm,{0}dm,,,,,deicheamh-meatair,,{0} deicheamh-meatair,{0} deicheamh-meatair
        earth-radius,R⊕,,{0}R⊕,{0}R⊕,,,,,rèideas-talmhainn,,{0} rèideas-talmhainn,{0} rèideas-talmhainn
        fathom,aitheamh,,{0}aith,{0}aith,aitheamh,,{0} aith,{0} aith,aitheamh,,{0} aitheamh,{0} aitheamh
        foot,troigh,{0}/troigh,{0}′,{0}′,troigh,{0}/troigh,{0} troigh,{0} troigh,troigh,{0} san troigh,{0} troigh,{0} troigh
        furlong,stàid,,{0}stàid,{0}stàid,stàid,,{0} stàid,{0} stàid,stàid Shasannach,,{0} stàid Shasannach,{0} stàid Shasannach
        inch,òirl,{0}/òirl,{0}″,{0}″,òirleach,{0}/òirl,{0} òirl,{0} òirl,òirleach,{0} san òirleach,{0} òirleach,{0} òirleach
        kilometer,km,{0}/km,{0}km,{0}km,,,,,cilemeatair,{0} sa chilemeatair,{0} chilemeatair,{0} cilemeatair
        light-year,ly,,{0}ly,{0}ly,,,,,bliadhna solais,,{0} bhliadhna solais,{0} bliadhna solais
        meter,meatair,{0}/m,{0}m,{0}m,meatair,{0}/m,,{0} m,meatair,{0} sa mheatair,{0} mheatair,{0} meatair
        micrometer,μm,,{0}μm,{0}μm,μ-meatair,,,{0} μm,micreo-meatair,,{0} mhicreo-meatair,{0} micreo-meatair
        mile,mì,,{0}mì,{0}mì,mìle,,{0} mì,{0} mì,mìle,,{0} mhìle,{0} mìle
        mile-scandinavian,smi,,{0}smi,{0}smi,,,,,mìle Lochlannach,,{0} mhìle Lochlannach,{0} mìle Lochlannach
        millimeter,mm,,{0}mm,{0}mm,,,,,mili-meatair,,{0} mhili-meatair,{0} mili-meatair
        nanometer,nm,,{0}nm,{0}nm,,,,,nano-meatair,,{0} nano-meatair,{0} nano-meatair
        nautical-mile,nmi,,{0}nmi,{0}nmi,,,,,mìle mara,,{0} mhìle mara,{0} mìle mara
        parsec,parsec,,{0}pc,{0}pc,parsec,,,{0} pc,parsec,,{0} pharsec,{0} parsec
        picometer,pm,,{0}pm,{0}pm,,,,,piceo-meatair,,{0} phiceo-meatair,{0} piceo-meatair
        point,pt,,{0}pt,{0}pt,puing,,,{0} pt,puing,,{0} phuing,{0} puing
        solar-radius,R☉,,{0}R☉,{0}R☉,rèideas-grèine,,,{0} R☉,rèideas-grèine,,{0} rèideas-grèine,{0} rèideas-grèine
        yard,slat,,{0}yd,{0}yd,slat,,{0} slat,{0} slat,slat,,{0} slat,{0} slat
        candela,cd,,{0}cd,{0}cd,candela,,,{0} cd,candela,,{0} chandela,{0} candela
        lumen,lm,,{0}lm,{0}lm,lumen,,,{0} lm,lumen,,{0} lumen,{0} lumen
        lux,lux,,{0}lx,{0}lx,lux,,,{0} lx,lux,,{0} lux,{0} lux
        solar-luminosity,L☉,,{0}L☉,{0}L☉,boillsgeachd-ghrèine,,,{0} L☉,boillsgeachd-ghrèine,,{0} bhoillsgeachd-ghrèine,{0} boillsgeachd-ghrèine
        carat,carat,,{0}CD,{0}CD,carat,,,{0} CD,carat,,{0} charat,{0} carat
        dalton,Da,,{0}Da,{0}Da,dalton,,,{0} Da,dalton,,{0} dalton,{0} dalton
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,tomad-talmhainn,,,{0} M⊕,tomad-talmhainn,,{0} tomad-talmhainn,{0} tomad-talmhainn
        grain,gràinne,,{0}ghr,{0}gr,gràinne,,{0} ghràinne,{0} gràinne,gràinne,,{0} ghràinne,{0} gràinne
        gram,gram,{0}/g,{0}g,{0}g,,,,,gram,{0} sa ghram,{0} ghram,{0} gram
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,cileagram,{0} sa chileagram,{0} chileagram,{0} cileagram
        microgram,μg,,{0}μg,{0}μg,,,,,micreo-gram,,{0} mhicreo-gram,{0} micreo-gram
        milligram,mg,,{0}mg,{0}mg,,,,,miligram,,{0} mhiligram,{0} miligram
        ounce,oz,{0}/oz,{0}oz,{0}oz,unnsa,{0}/oz,{0} unnsa,{0} unnsa,unnsa,{0} san unnsa,{0} unnsa,{0} unnsa
        ounce-troy,oz t,,{0}oz t,{0}oz t,unnsa tròidh,,,{0} oz t,unnsa tròidh,,{0} unnsa tròidh,{0} unnsa tròidh
        pound,lb,{0}/lb,{0}lb,{0}lb,punnd,{0}/lb,,{0} lb,punnd,{0} sa phunnd,{0} phunnd,{0} punnd
        solar-mass,M☉,,{0}M☉,{0}M☉,tomad-grèine,,,{0} M☉,tomad-grèine,,{0} tomad-grèine,{0} tomad-grèine
        stone,clach,,{0}clach,{0}clach,clach,,{0} chlach,{0} clach,clach,,{0} chlach,{0} clach
        ton,tn,,{0}tn,{0}tn,tunna,,,{0} tn,tunna,,{0} tunna,{0} tunna
        tonne,t,,{0}t,{0}t,,,,,tunna meatrach,,{0} tunna meatrach,{0} tunna meatrach
        gigawatt,GW,,{0}GW,{0}GW,,,,,giga-watt,,{0} ghiga-watt,{0} giga-watt
        horsepower,hp,,{0}hp,{0}hp,,,,,cumhachd-eich,,{0} chumhachd-eich,{0} cumhachd-eich
        kilowatt,kW,,{0}kW,{0}kW,,,,,cilea-watt,,{0} chilea-watt,{0} cilea-watt
        megawatt,MW,,{0}MW,{0}MW,,,,,meaga-watt,,{0} mheaga-watt,{0} meaga-watt
        milliwatt,mW,,{0}mW,{0}mW,,,,,mili-watt,,{0} mhili-watt,{0} mili-watt
        watt,watt,,{0}W,{0}W,,,,,watt,,{0} watt,{0} watt
        atmosphere,atm,,{0}atm,{0}atm,àile,,{0} àile,{0} àile,brùthadh-àile,,{0} bhrùthadh-àile,{0} brùthadh-àile
        bar,bàr,,{0}bhàr,{0}bàr,bàr,,{0} bhàr,{0} bàr,bàr,,{0} bhar,{0} bàr
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,heacta-pascal,,{0} heacta-pascal,{0} heacta-pascal
        inch-ofhg,″ Hg,,{0}″ Hg,{0}″ Hg,in Hg,,,{0} inHg,òirleach de dh’airgead-beò,,{0} òirleach de dh’airgead-beò,{0} òirleach de dh’airgead-beò
        kilopascal,kPa,,{0}kPa,{0}kPa,,,,,cileapascal,,{0} chileapascal,{0} cileapascal
        megapascal,MPa,,{0}MPa,{0}MPa,,,,,meaga-pascal,,{0} mheaga-pascal,{0} meaga-pascal
        millibar,mbàr,,{0}mb,{0}mb,mbàr,,{0} mbàr,{0} mbàr,milibàr,,{0} mhilibàr,{0} milibàr
        millimeter-ofhg,mm Hg,,{0}mm Hg,{0}mm Hg,,,,,milimeatair de dh’airgead-beò,,{0} mhilimeatair de dh’airgead-beò,{0} milimeatair de dh’airgead-beò
        pascal,Pa,,{0}Pa,{0}Pa,,,,,pascal,,{0} phascal,{0} pascal
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,,,,,punnd san òirleach cheàrnagach,,{0} phunnd san òirleach cheàrnagach,{0} punnd san òirleach cheàrnagach
        beaufort,Bft,,B{0},B{0},,,,,Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,km/h,,{0}km/h,{0}km/h,km/uair,,,{0} km/h,cilemeatair san uair,,{0} chilemeatair san uair,{0} cilemeatair san uair
        knot,kn,,{0}kn,{0}kn,,,,,mìle mara san uair,,{0} mhìle mara san uair,{0} mìle mara san uair
        light-speed,solas,,{0}sholas,{0}solas,solas,,{0} sholas,{0} solas,solas,,{0} sholas,{0} solas
        meter-per-second,m/s,,{0}m/s,{0}m/s,meatair/diog,,,{0} m/s,meatair san diog,,{0} mheatair san diog,{0} meatair san diog
        mile-per-hour,mì/h,,{0}mì/h,{0}mì/h,mìle/uair,,{0} mì/h,{0} mì/h,mìle san uair,,{0} mhìle san uair,{0} mìle san uair
        celsius,,,,,ceum C,,,{0}°C,ceum Celsius,,{0} cheum Celsius,{0} ceum Celsius
        fahrenheit,,,,,ceum F,,,{0}°F,ceum Fahrenheit,,{0} cheum Fahrenheit,{0} ceum Fahrenheit
        kelvin,K,,{0}K,{0}K,,,,,ceum Kelvin,,{0} cheum Kelvin,{0} ceum Kelvin
        newton-meter,N⋅m,,{0}N⋅m,{0}N⋅m,,,,,newton-mheatair,,{0} newton-mheatair,{0} newton-mheatair
        pound-force-foot,lbf⋅ft,,{0}lbf⋅ft,{0}lbf⋅ft,,,,,troigh-phuinnd,,{0} troigh-phuinnd,{0} troigh-phuinnd
        acre-foot,ac ft,,{0}ac ft,{0}ac ft,acair-throigh,,,{0} ac ft,acair-throigh,,{0} acair-throigh,{0} acair-throigh
        barrel,bbl,,{0}bbl,{0}bbl,baraill,,,{0} bbl,baraill,,{0} bharaill,{0} baraill
        bushel,buiseal,,{0}bu,{0}bu,buiseal,,,{0} bu,buiseal,,{0} bhuiseal,{0} buiseal
        centiliter,cL,,{0}cL,{0}cL,c-liotair,,,{0} cL,ceudailiotair,,{0} cheudailiotair,{0} ceudailiotair
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,ceudameatair ciùbach,{0} sa cheudameatair chiùbach,{0} cheudameatair ciùbach,{0} ceudameatair ciùbach
        cubic-foot,ft³,,{0}ft³,{0}ft³,troigh³,,{0} troigh³,{0} troigh³,troigh chiùbach,,{0} troigh chiùbach,{0} troigh chiùbach
        cubic-inch,in³,,{0}in³,{0}in³,òirl³,,{0} òirl³,{0} òirl³,òirleach chiùbach,,{0} òirleach chiùbach,{0} òirleach chiùbach
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,cilemeatair ciùbach,,{0} chilemeatair ciùbach,{0} cilemeatair ciùbach
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,meatair ciùbach,{0} sa mheatair chiùbach,{0} mheatair ciùbach,{0} meatair ciùbach
        cubic-mile,mì³,,{0}mì³,{0}mì³,mì³,,{0} mì³,{0} mì³,mìle chiùbach,,{0} mhìle chiùbach,{0} mìle chiùbach
        cubic-yard,yd³,,{0}yd³,{0}yd³,slat³,,{0} slat³,{0} slat³,slat chiùbach,,{0} slat chiùbach,{0} slat chiùbach
        cup,cupa,,{0}c,{0}c,cupa,,,{0} c,cupa,,{0} chupa,{0} cupa
        cup-metric,mcup,,{0}mc,{0}mc,,,,,cupa meatrach,,{0} chupa meatrach,{0} cupa meatrach
        deciliter,dL,,{0}dL,{0}dL,,,,,deicheamh-liotair,,{0} deicheamh-liotair,{0} deicheamh-liotair
        dessert-spoon,sp-mhìl,,{0}sp-mhìl,{0}sp-mhìl,spàin-mhìl,,{0} spàin-mhìl,{0} spàin-mhìl,spàin-mhìlsein,,{0} spàin-mhìlsein,{0} spàin-mhìlsein
        dessert-spoon-imperial,sp-mhìl ìmp.,,{0}sp-mìl ì.,{0}sp-mìl ì.,spàin-mhìl ìmp.,,{0} spàin-mhìl ìmp.,{0} spàin-mhìl ìmp.,spàin-mhìlsein ìmpireil,,{0} spàin-mhìlsein ìmpireil,{0} spàin-mhìlsein ìmpireil
        dram,drama,,{0}drama,{0}drama,drama,,{0} drama,{0} drama,drama,,{0} drama,{0} drama
        drop,boinne,,{0}bhoinne,{0}boinne,boinne,,{0} bhoinne,{0} boinne,boinne,,{0} bhoinne,{0} boinne
        fluid-ounce,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,unnsa-dighe,,{0} unnsa-dighe,{0} unnsa-dighe
        fluid-ounce-imperial,fl oz ìmp.,,{0}fl oz ì.,{0}fl oz ì.,fl oz ìmp.,,{0} fl oz ìmp.,{0} fl oz ìmp.,unnsa-dighe ìmpireil,,{0} unnsa-dighe ìmpireil,{0} unnsa-dighe ìmpireil
        gallon,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal,{0} gal,{0} gal,galan,{0} sa ghalan,{0} ghalan,{0} galan
        gallon-imperial,gal ìmp.,{0}/gal ì.,{0} ghal ì.,{0} gal ì.,gal ìmp.,{0}/gal ìmp.,{0} ghal ìmp.,{0} gal ìmp.,galan ìmpireil,{0} sa ghalan ìmpireil,{0} ghalan ìmpireil,{0} galan ìmpireil
        hectoliter,hL,,{0}hL,{0}hL,,,,,heacta-liotair,,{0} heacta-liotair,{0} heacta-liotair
        jigger,sigire,,{0}sigire,{0}sigire,sigire,,{0} sigire,{0} sigire,sigire,,{0} sigire,{0} sigire
        liter,liotair,{0}/L,{0}L,{0}L,liotair,{0}/L,{0} L,{0} L,liotair,{0} san liotair,{0} liotair,{0} liotair
        megaliter,ML,,{0}ML,{0}ML,,,,,meaga-liotair,,{0} mheaga-liotair,{0} meaga-liotair
        milliliter,mL,,{0}mL,{0}mL,,,,,mililiotair,,{0} mhililiotair,{0} mililiotair
        pinch,crudhag,,{0}chrg.,{0}crg.,crudhagan,,{0} chrudhag,{0} crudhag,crudhagan,,{0} chrudhagan,{0} crudhagan
        pint,pt,,{0}pt,{0}pt,pinnt,,,{0} pt,pinnt,,{0} phinnt,{0} pinnt
        pint-metric,pt,,{0}mpt,{0}mpt,,,,,pinnt meatrach,,{0} phinnt meatrach,{0} pinnt meatrach
        quart,càrt,,{0}càrt,{0}càrt,càrt,,{0} chàrt,{0} càrt,càrt,,{0} chàrt,{0} càrt
        quart-imperial,càrt ìmp.,,{0}chàrt ì.,{0}càrt ì.,càrt ìmp.,,{0} chàrt ìmp.,{0} càrt ìmp.,càrt ìmpireil,,{0} chàrt ìmpireil,{0} càrt ìmpireil
        tablespoon,sp,,{0}sp,{0}sp,spàin,,{0} spàin,{0} spàin,spàin-bhùird,,{0} spàin-bhùird,{0} spàin-bhùird
        teaspoon,sp-t,,{0}sp-t,{0}sp-t,spàin-t,,{0} sp-t,{0} sp-t,spàin-teatha,,{0} spàin-teatha,{0} spàin-teatha
        """.trimIndent()
  }

  private val gd_Prefixes: String by lazy {
    """square,,,{0} ceàrnagach
        cubic,,,{0} ciùbach
        per,,,{0} / {1}
        1024p1,,,kibi-{0}
        1024p2,,,mebi-{0}
        1024p3,,,gibi-{0}
        1024p4,,,tebi-{0}
        1024p5,,,pebi-{0}
        1024p6,,,exbi-{0}
        1024p7,,,zebi-{0}
        1024p8,,,yobe-{0}
        10p-1,,,deicheamh-{0}
        10p-12,,,piceo-{0}
        10p-15,,,femto-{0}
        10p-18,,,atto-{0}
        10p-2,,,ceuda{0}
        10p-21,,,zepto-{0}
        10p-24,,,yocto-{0}
        10p-27,,,ronto{0}
        10p-3,,,mili{0}
        10p-30,,,quecto{0}
        10p-6,,,micreo-{0}
        10p-9,,,nano-{0}
        10p1,,,deaca-{0}
        10p12,,,tera-{0}
        10p15,,,peta-{0}
        10p18,,,exa-{0}
        10p2,,,heacta-{0}
        10p21,,,zetta-{0}
        10p24,,,yotta-{0}
        10p27,,,ronna{0}
        10p3,,,cile{0}
        10p30,,,quetta{0}
        10p6,,,meaga-{0}
        10p9,,,giga-{0}
        """.trimIndent()
  }

  private val gez_Units: String? = null

  private val gez_Prefixes: String? = null

  private val gez_ER_Units: String? = null

  private val gez_ER_Prefixes: String? = null

  private val gl_Units: String by lazy {
    """g-force,G,,,{0} G,forzas G,,,{0} G,forzas G,,{0} forza G,{0} forzas G
        meter-per-square-second,,,,,,,,,metros por segundo cadrado,,{0} metro por segundo cadrado,{0} metros por segundo cadrado
        arc-minute,min,,,{0}′,minutos,,,{0}′,minutos de arco,,{0} minuto de arco,{0} minutos de arco
        arc-second,s,,{0}′′,{0}′′,segundos,,{0}′′,{0}′′,segundos de arco,,{0} segundo de arco,{0} segundos de arco
        degree,graos,,,{0}°,graos,,,{0}°,graos,,{0} grao,{0} graos
        radian,,,,,radiáns,,,{0} rad,radiáns,,{0} radián,{0} radiáns
        revolution,,,,,,,,,revolucións,,{0} revolución,{0} revolucións
        acre,ac,,{0} acre,{0} acres,acres,,{0} acre,{0} acres,acres,,{0} acre,{0} acres
        dunam,dunam,,{0} dunam,{0} dunams,dunams,,{0} dunam,{0} dunams,dunams,,{0} dunam,{0} dunams
        hectare,ha,,,{0} ha,hectáreas,,,{0} ha,hectáreas,,{0} hectárea,{0} hectáreas
        square-centimeter,,,,,,,,,centímetros cadrados,{0} por centímetro cadrado,{0} centímetro cadrado,{0} centímetros cadrados
        square-foot,,,,,,,,,pés cadrados,,{0} pé cadrado,{0} pés cadrados
        square-inch,,,,,,,,,polgadas cadradas,{0} por polgada cadrada,{0} polgada cadrada,{0} polgadas cadradas
        square-kilometer,,,,,,,,,quilómetros cadrados,{0} por quilómetro cadrado,{0} quilómetro cadrado,{0} quilómetros cadrados
        square-meter,,,,,,,,,metros cadrados,{0} por metro cadrado,{0} metro cadrado,{0} metros cadrados
        square-mile,,,,,,,,,millas cadradas,{0} por milla cadrada,{0} milla cadrada,{0} millas cadradas
        square-yard,,,,,,,,,iardas cadradas,,{0} iarda cadrada,{0} iardas cadradas
        item,ude.,,{0} ude.,{0} udes.,ude.,,{0} ude.,{0} udes.,unidades,,{0} unidade,{0} unidades
        karat,,,,,quilates,,,{0} kt,quilates,,{0} quilate,{0} quilates
        milligram-ofglucose-per-deciliter,mg/dl,,{0} mg/dl,{0} mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,miligramos por decilitro,,{0} miligramo por decilitro,{0} miligramos por decilitro
        millimole-per-liter,mmol/l,,{0} mmol/l,{0} mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,milimoles por litro,,{0} milimol por litro,{0} milimoles por litro
        mole,,,,,,,,,moles,,{0} mol,{0} moles
        percent,%,,{0} %,{0} %,%,,{0} %,{0} %,tanto por cento,,{0} %,{0} %
        permille,‰,,{0} ‰,{0} ‰,‰,,{0} ‰,{0} ‰,tanto por mil,,{0} ‰,{0} ‰
        permillion,,,,,,,,,partes por millón,,{0} parte por millón,{0} partes por millón
        permyriad,‱,,{0} ‱,{0} ‱,‱,,{0} ‱,{0} ‱,tanto por dez mil,,{0} ‱,{0} ‱
        portion-per-1e9,ppmm,,{0} ppmm,{0} ppmm,partes/mil millóns,,{0} ppmm,{0} ppmm,partes por mil millóns,,{0} parte por mil millóns,{0} partes por mil millóns
        liter-per-100-kilometer,l/100 km,,{0} l/100 km,{0} l/100 km,litros/100 km,,{0} l/100 km,{0} l/100 km,litros por 100 quilómetros,,{0} litro por 100 quilómetros,{0} litros por 100 quilómetros
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,litros/km,,{0} l/km,{0} l/km,litros por quilómetro,,{0} litro por quilómetro,{0} litros por quilómetro
        mile-per-gallon,mpg EUA,,{0} mpg EUA,{0} mpg EUA,millas/galón EUA,,{0} mpg EUA,{0} mpg EUA,millas por galón estadounidense,,{0} milla por galón estadounidense,{0} millas por galón estadounidense
        mile-per-gallon-imperial,mpg imp.,,{0} mpg imp.,{0} mpg imp.,millas/gal imp.,,{0} mpg imp.,{0} mpg imp.,millas por galón imperial,,{0} milla por galón imperial,{0} millas por galón imperial
        bit,b,,{0} b,{0} b,b,,{0} b,{0} b,bits,,{0} bit,{0} bits
        byte,B,,{0} B,{0} B,B,,{0} B,{0} B,bytes,,{0} byte,{0} bytes
        gigabit,,,,,,,,,xigabits,,{0} xigabit,{0} xigabits
        gigabyte,,,,,,,,,xigabytes,,{0} xigabyte,{0} xigabytes
        kilobit,,,,,,,,,kilobits,,{0} kilobit,{0} kilobits
        kilobyte,,,,,,,,,kilobytes,,{0} kilobyte,{0} kilobytes
        megabit,,,,,,,,,megabits,,{0} megabit,{0} megabits
        megabyte,,,,,,,,,megabytes,,{0} megabyte,{0} megabytes
        petabyte,,,,,,,,,petabytes,,{0} petabyte,{0} petabytes
        terabit,,,,,,,,,terabits,,{0} terabit,{0} terabits
        terabyte,,,,,,,,,terabytes,,{0} terabyte,{0} terabytes
        century,séc.,,{0} séc.,{0} séc.,séc.,,{0} séc.,{0} séc.,séculos,,{0} século,{0} séculos
        day,día,{0}/d,{0} d,{0} d,días,{0}/día,{0} día,{0} días,días,{0} por día,{0} día,{0} días
        decade,déc.,,{0} déc.,{0} déc.,déc.,,{0} déc.,{0} déc.,décadas,,{0} década,{0} décadas
        hour,h,{0}/h,,{0} h,h,{0}/h,,{0} h,horas,{0} por hora,{0} hora,{0} horas
        microsecond,,,,,,,,,microsegundos,,{0} microsegundo,{0} microsegundos
        millisecond,,,,,,,,,milisegundos,,{0} milisegundo,{0} milisegundos
        minute,,,,,,,,,minutos,{0} por minuto,{0} minuto,{0} minutos
        month,mes,{0}/m.,{0} m.,{0} m.,meses,{0}/mes,{0} mes,{0} meses,meses,{0} por mes,{0} mes,{0} meses
        nanosecond,,,,,,,,,nanosegundos,,{0} nanosegundo,{0} nanosegundos
        night,noites,{0}/noite,{0} noite,{0} noites,noites,{0}/noite,{0} noite,{0} noites,noites,{0} por noite,{0} noite,{0} noites
        quarter,trim.,{0}/tr.,{0} tr.,{0} tr.,trim.,{0}/trim.,{0} trim.,{0} trim.,trimestres,{0}/trimestre,{0} trimestre,{0} trimestres
        second,s,{0}/s,,{0} s,s,{0}/s,,{0} s,segundos,{0} por segundo,{0} segundo,{0} segundos
        week,sem.,{0}/sem.,{0} sem.,{0} sem.,sem.,{0}/sem.,{0} sem.,{0} sem.,semanas,{0} por semana,{0} semana,{0} semanas
        year,a.,{0}/a.,{0} a.,{0} a.,anos,{0}/ano,{0} ano,{0} anos,anos,{0} por ano,{0} ano,{0} anos
        ampere,A,,,{0} A,A,,,{0} A,amperes,,{0} ampere,{0} amperes
        milliampere,,,,,,,,,miliamperes,,{0} miliampere,{0} miliamperes
        ohm,Ω,,,{0} Ω,ohms,,,{0} Ω,ohms,,{0} ohm,{0} ohms
        volt,V,,,{0} V,volts,,,{0} V,volts,,{0} volt,{0} volts
        british-thermal-unit,BTU,,{0} BTU,{0} BTU,BTU,,{0} BTU,{0} BTU,unidades térmicas británicas,,{0} unidade térmica británica,{0} unidades térmicas británicas
        calorie,,,,,,,,,calorías,,{0} caloría,{0} calorías
        electronvolt,,,,,,,,,electronvolts,,{0} electronvolt,{0} electronvolts
        foodcalorie,,,,,,,,,quilocalorías,,{0} quilocaloría,{0} quilocalorías
        joule,J,,,{0} J,joules,,,{0} J,joules,,{0} joule,{0} joules
        kilocalorie,,,,,,,,,quilocalorías,,{0} quilocaloría,{0} quilocalorías
        kilojoule,,,,,quilojoule,,,{0} kJ,quilojoules,,{0} quilojoule,{0} quilojoules
        kilowatt-hour,,,,,,,,,quilowatts hora,,{0} quilowatt hora,{0} quilowatts hora
        therm-us,thm U.S.,,{0} thm U.S.,{0} thm U.S.,thm U.S.,,{0} thm U.S.,{0} thm U.S.,therms estadounidenses,,{0} therm estadounidense,{0} therms estadounidenses
        kilowatt-hour-per-100-kilometer,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,quilowatts/hora por cen quilómetros,,{0} quilowatt/hora por cen quilómetros,{0} quilowatts/hora por cen quilómetros
        newton,,,,,newton,,,{0} N,newtons,,{0} newton,{0} newtons
        pound-force,,,,,libra forza,,,{0} lbf,libras de forza,,{0} libra de forza,{0} libras de forza
        gigahertz,,,,,,,,,xigahertzs,,{0} xigahertz,{0} xigahertzs
        hertz,,,,,,,,,hertzs,,{0} hertz,{0} hertzs
        kilohertz,,,,,,,,,quilohertzs,,{0} quilohertz,{0} quilohertzs
        megahertz,,,,,,,,,megahertzs,,{0} megahertz,{0} megahertzs
        dot,pto.,,{0} pto.,{0} ptos.,ptos.,,{0} pto.,{0} ptos.,puntos,,{0} punto,{0} puntos
        dot-per-centimeter,ppcm,,{0} ppcm,{0} ppcm,ppcm,,{0} ppcm,{0} ppcm,puntos por centímetro,,{0} punto por centímetro,{0} puntos por centímetro
        dot-per-inch,ppp,,{0} ppp,{0} ppp,ppp,,{0} ppp,{0} ppp,puntos por polgada,,{0} punto por polgada,{0} puntos por polgada
        em,,,,,,,,,cuadratíns,,{0} cuadratín,{0} cuadratíns
        megapixel,Mpx,,{0} Mpx,{0} Mpx,Mpx,,{0} Mpx,{0} Mpx,megapíxeles,,{0} megapíxel,{0} megapíxeles
        pixel,,,,,,,,,píxeles,,{0} píxel,{0} píxeles
        pixel-per-centimeter,px/cm,,{0} px/cm,{0} px/cm,px/cm,,{0} px/cm,{0} px/cm,píxeles por centímetro,,{0} píxel por centímetro,{0} píxeles por centímetro
        pixel-per-inch,px/in,,{0} px/in,{0} px/in,px/in,,{0} px/in,{0} px/in,píxeles por polgada,,{0} píxel por polgada,{0} píxeles por polgada
        astronomical-unit,ua,,{0} ua,{0} ua,ua,,{0} ua,{0} ua,unidades astronómicas,,{0} unidade astronómica,{0} unidades astronómicas
        centimeter,,,,,,,,,centímetros,{0} por centímetro,{0} centímetro,{0} centímetros
        decimeter,,,,,,,,,decímetros,,{0} decímetro,{0} decímetros
        earth-radius,,,,,,,,,raio terrestre,,{0} raio terrestre,{0} raios terrestres
        fathom,fth,,,{0} fth,brazas inglesas,,,{0} fth,brazas inglesas,,{0} braza inglesa,{0} brazas inglesas
        foot,,,,,pés,{0}/ft,,{0} ft,pés,{0} por pé,{0} pé,{0} pés
        furlong,,,,,furlongs,,,{0} fur,furlongs,,{0} furlong,{0} furlongs
        inch,,,,,polg.,{0}/in,,{0} in,polgadas,{0} por polgada,{0} polgada,{0} polgadas
        kilometer,,,,,,,,,quilómetros,{0} por quilómetro,{0} quilómetro,{0} quilómetros
        light-year,a.l.,,{0} a.l.,{0} a.l.,anos luz,,{0} a.l.,{0} a.l.,anos luz,,{0} ano luz,{0} anos luz
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,metros,{0} por metro,{0} metro,{0} metros
        micrometer,,,,,,,,,micrómetros,,{0} micrómetro,{0} micrómetros
        mile,,,,,millas,,,{0} mi,millas,,{0} milla,{0} millas
        mile-scandinavian,mi esc.,,{0} mi esc.,{0} mi esc.,mi esc.,,{0} mi esc.,{0} mi esc.,milla escandinava,,{0} milla escandinava,{0} millas escandinavas
        millimeter,,,,,,,,,milímetros,,{0} milímetro,{0} milímetros
        nanometer,,,,,,,,,nanómetros,,{0} nanómetro,{0} nanómetros
        nautical-mile,M,,{0} M,{0} M,M,,{0} M,{0} M,millas náuticas,,{0} milla náutica,{0} millas náuticas
        parsec,,,,,parsecs,,,{0} pc,parsecs,,{0} parsec,{0} parsecs
        picometer,,,,,,,,,picómetros,,{0} picómetro,{0} picómetros
        point,,,,,,,,,puntos tipográficos,,{0} punto tipográfico,{0} puntos tipográficos
        solar-radius,,,,,raios solares,,,{0} R☉,raios solares,,{0} raio solar,{0} raios solares
        yard,,,,,iardas,,,{0} yd,iardas,,{0} iarda,{0} iardas
        candela,,,,,,,,,candela,,{0} candela,{0} candelas
        lumen,,,,,,,,,lumen,,{0} lumen,{0} lumens
        lux,lux,,,{0} lx,lux,,,{0} lx,lux,,{0} lux,{0} lux
        solar-luminosity,,,,,luminosidades solares,,,{0} L☉,luminosidades solares,,{0} luminosidade solar,{0} luminosidades solares
        carat,ct,,{0} ct,{0} ct,quilates,,{0} ct,{0} ct,quilates,,{0} quilate,{0} quilates
        dalton,,,,,daltons,,,{0} Da,daltons,,{0} dalton,{0} daltons
        earth-mass,,,,,masas da Terra,,,{0} M⊕,masas da Terra,,{0} masa da Terra,{0} masas da Terra
        grain,gran,,{0} gran,{0} grans,gran,,{0} gran,{0} grans,gran,,{0} gran,{0} grans
        gram,g,{0}/g,,{0} g,gramos,{0}/g,,{0} g,gramos,{0} por gramo,{0} gramo,{0} gramos
        kilogram,,,,,,,,,quilogramos,{0} por quilogramo,{0} quilogramo,{0} quilogramos
        microgram,,,,,,,,,microgramos,,{0} microgramo,{0} microgramos
        milligram,,,,,,,,,miligramos,,{0} miligramo,{0} miligramos
        ounce,,,,,,,,,onzas,{0} por onza,{0} onza,{0} onzas
        ounce-troy,,,,,,,,,onzas troy,,{0} onza troy,{0} onzas troy
        pound,,,,,libras,{0}/lb,,{0} lb,libras,{0} por libra,{0} libra,{0} libras
        solar-mass,,,,,masas solares,,,{0} M☉,masas solares,,{0} masa solar,{0} masas solares
        stone,,,,,,,,,stones,,{0} stone,{0} stones
        ton,tn EUA,,{0} tn EUA,{0} tn EUA,tn EUA,,{0} tn EUA,{0} tn EUA,toneladas estadounidenses,,{0} tonelada estadounidense,{0} toneladas estadounidenses
        tonne,,,,,,,,,toneladas métricas,,{0} tonelada métrica,{0} toneladas métricas
        gigawatt,,,,,,,,,xigawatts,,{0} xigawatt,{0} xigawatts
        horsepower,,,,,,,,,cabalo de potencia,,{0} cabalo de potencia,{0} cabalos de potencia
        kilowatt,,,,,,,,,quilowatts,,{0} quilowatt,{0} quilowatts
        megawatt,,,,,,,,,megawatts,,{0} megawatt,{0} megawatts
        milliwatt,,,,,,,,,miliwatts,,{0} miliwatt,{0} miliwatts
        watt,W,,,{0} W,watts,,,{0} W,watts,,{0} watt,{0} watts
        atmosphere,,,,,,,,,atmosferas,,{0} atmosfera,{0} atmosferas
        bar,,,,,,,,,bares,,{0} bar,{0} bares
        hectopascal,,,,,,,,,hectopascais,,{0} hectopascal,{0} hectopascais
        inch-ofhg,,,,,,,,,polgadas de mercurio,,{0} polgada de mercurio,{0} polgadas de mercurio
        kilopascal,,,,,,,,,quilopascais,,{0} quilopascal,{0} quilopascais
        megapascal,,,,,,,,,megapascais,,{0} megapascal,{0} megapascais
        millibar,,,,,,,,,milibares,,{0} milibar,{0} milibares
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,mmHg,,{0} mmHg,{0} mmHg,milímetros de mercurio,,{0} milímetro de mercurio,{0} milímetros de mercurio
        pascal,,,,,,,,,pascais,,{0} pascal,{0} pascais
        pound-force-per-square-inch,,,,,,,,,libras por polgada cadrada,,{0} libra por polgada cadrada,{0} libras por polgada cadrada
        beaufort,B,,B {0},B {0},Bft,,Bft {0},Bft {0},Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,,,,,,,,,quilómetros por hora,,{0} quilómetro por hora,{0} quilómetros por hora
        knot,nós,,{0} nó,{0} nós,nós,,{0} nós,{0} nós,nós,,{0} nó,{0} nós
        light-speed,luz,,{0} luz,{0} luz,luz,,{0} luz,{0} luz,luz,,{0} luz,{0} luz
        meter-per-second,,,,,,,,,metros por segundo,,{0} metro por segundo,{0} metros por segundo
        mile-per-hour,,,,,millas/hora,,,{0} mi/h,millas por hora,,{0} milla por hora,{0} millas por hora
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,graos Celsius,,{0} grao Celsius,{0} graos Celsius
        fahrenheit,°F,,{0}°F,{0}°F,°F,,{0} °F,{0} °F,graos Fahrenheit,,{0} grao Fahrenheit,{0} graos Fahrenheit
        generic,,,,,graos,,,{0}°,graos,,{0} grao,{0} graos
        kelvin,,,,,,,,,kelvins,,{0} kelvin,{0} kelvins
        newton-meter,,,,,,,,,newtons metro,,{0} newton metro,{0} newtons metro
        pound-force-foot,lbf ft,,{0} lbf ft,{0} lbf ft,lbf ft,,{0} lbf ft,{0} lbf ft,libras pés,,{0} libra pé,{0} libras pés
        acre-foot,,,,,acre-pés,,,{0} ac ft,acre-pés,,{0} acre-pé,{0} acre-pés
        barrel,,,,,barril,,,{0} bbl,barrís,,{0} barril,{0} barrís
        bushel,,,,,,,,,bushels,,{0} bushel,{0} bushels
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,centilitros,,{0} centilitro,{0} centilitros
        cubic-centimeter,,,,,,,,,centímetros cúbicos,{0} por centímetro cúbico,{0} centímetro cúbico,{0} centímetros cúbicos
        cubic-foot,,,,,,,,,pés cúbicos,,{0} pé cúbico,{0} pés cúbicos
        cubic-inch,,,,,,,,,polgadas cúbicas,,{0} polgada cúbica,{0} polgadas cúbicas
        cubic-kilometer,,,,,,,,,quilómetros cúbicos,,{0} quilómetro cúbico,{0} quilómetros cúbicos
        cubic-meter,,,,,,,,,metros cúbicos,{0} por metro cúbico,{0} metro cúbico,{0} metros cúbicos
        cubic-mile,,,,,,,,,millas cúbicas,,{0} milla cúbica,{0} millas cúbicas
        cubic-yard,,,,,,,,,iardas cúbicas,,{0} iarda cúbica,{0} iardas cúbicas
        cup,c,,,{0} c,cuncas,,,{0} c,cuncas,,{0} cunca,{0} cuncas
        cup-metric,mc,,,{0} mc,mc,,,{0} mc,cuncas métricas,,{0} cunca métrica,{0} cuncas métricas
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,decilitros,,{0} decilitro,{0} decilitros
        dessert-spoon,cull. sobr.,,{0} cull. sobr.,{0} cull. sobr.,cull. sobr.,,{0} cull. sobr.,{0} cull. sobr.,culleradas de sobremesa,,{0} cullerada de sobremesa,{0} culleradas de sobremesa
        dessert-spoon-imperial,cull. sobr. imp.,,{0} cull. sobr. imp.,{0} cull. sobr. imp.,cull. sobr. imp.,,{0} cull. sobr. imp.,{0} cull. sobr. imp.,culleradas de sobremesa imperial,,{0} cullerada de sobremesa imperial,{0} culleradas de sobremesa imperiais
        dram,dracma,,{0} dracma,{0} dracmas,dracma,,{0} dracma,{0} dracmas,dracmas líquidas,,{0} dracma líquida,{0} dracmas líquidas
        drop,gota,,{0} gota,{0} gotas,gota,,{0} gota,{0} gotas,gotas,,{0} gota,{0} gotas
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,onzas líquidas,,{0} onza líquida,{0} onzas líquidas
        fluid-ounce-imperial,fl oz imp.,,{0} fl oz imp.,{0} fl oz imp.,fl oz imp.,,{0} fl oz imp.,{0} fl oz imp.,onzas líquidas imperiais,,{0} onza líquida imperial,{0} onzas líquidas imperiais
        gallon,gal EUA,{0}/gal EUA,{0} gal EUA,{0} gal EUA,gal EUA,{0}/gal EUA,{0} gal EUA,{0} gal EUA,galóns estadounidenses,{0} por galón estadounidense,{0} galón estadounidense,{0} galóns estadounidenses
        gallon-imperial,gal imp.,{0}/gal imp.,{0} gal imp.,{0} gal imp.,gal imp.,{0}/gal imp.,{0} gal imp.,{0} gal imp.,galóns imperiais,{0} por galón imperial,{0} galón imperial,{0} galóns imperiais
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hectolitros,,{0} hectolitro,{0} hectolitros
        jigger,medidor,,{0} medidor,{0} medidores,medidor,,{0} medidor,{0} medidores,medidores de cóctel,,{0} medidor de cóctel,{0} medidores de cóctel
        liter,l,{0}/l,,{0} l,litros,{0}/l,,{0} l,litros,{0} por litro,{0} litro,{0} litros
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megalitros,,{0} megalitro,{0} megalitros
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,mililitros,,{0} mililitro,{0} mililitros
        pinch,chisco,,{0} chisco,{0} chiscos,chisco,,{0} chisco,{0} chiscos,chiscos,,{0} chisco,{0} chiscos
        pint,,,,,pintas,,,{0} pt,pintas,,{0} pinta,{0} pintas
        pint-metric,ptm,,{0} ptm,{0} ptm,ptm,,{0} ptm,{0} ptm,pintas métricas,,{0} pinta métrica,{0} pintas métricas
        quart,,,,,cuartos,,,{0} qt,cuartos,,{0} cuarto,{0} cuartos
        quart-imperial,cto. imp.,,{0} cto. imp.,{0} ctos. imp.,cuarto imperial,,{0} cto. imp.,{0} ctos. imp.,cuartos imperiais,,{0} cuarto imperial,{0} cuartos imperiais
        tablespoon,cull.,,{0} cull.,{0} cull.,cull.,,{0} cull.,{0} cull.,culleradas,,{0} cullerada,{0} culleradas
        teaspoon,cullñs.,,{0} cullña.,{0} cullñs.,cullñs.,,{0} cullña.,{0} cullñs.,culleradiñas,,{0} culleradiña,{0} culleradiñas
        """.trimIndent()
  }

  private val gl_Prefixes: String by lazy {
    """square,,,{0} cadrados
        cubic,,,{0} cúbicos
        per,,,{0} por {1}
        1024p1,,,quibi{0}
        1024p2,,,mebi{0}
        1024p3,,,xibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobi{0}
        10p-1,,,deci{0}
        10p-12,,,pico{0}
        10p-15,,,fento{0}
        10p-18,,,ato{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,iocto{0}
        10p-27,,,ronto{0}
        10p-3,,,mili{0}
        10p-30,,,quecto{0}
        10p-6,,,micro{0}
        10p-9,,,nano{0}
        10p1,,,deca{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hecto{0}
        10p21,,,zeta{0}
        10p24,,,iota{0}
        10p27,,,ronna{0}
        10p3,,,quilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,xiga{0}
        """.trimIndent()
  }

  private val gn_Units: String? = null

  private val gn_Prefixes: String? = null

  private val gsw_Units: String by lazy {
    """day,,,,,,,,,day,{0}/d,{0} Taag,{0} Tääg
        hour,,,,,,,,,hr,{0}/h,{0} Schtund,{0} Schtunde
        minute,,,,,,,,,min,{0}/min,{0} Minuute,{0} Minuute
        month,,,,,,,,,mon,{0}/m,{0} Monet,{0} Mönet
        second,,,,,,,,,sec,{0}/s,{0} Sekunde,{0} Sekunde
        week,,,,,,,,,wk,{0}/w,{0} Wuche,{0} Wuche
        year,,,,,,,,,yr,{0}/y,{0} Jahr,{0} Jahr
        """.trimIndent()
  }

  private val gsw_Prefixes: String? = null

  private val gsw_FR_Units: String? = null

  private val gsw_FR_Prefixes: String? = null

  private val gsw_LI_Units: String? = null

  private val gsw_LI_Prefixes: String? = null

  private val gu_Units: String by lazy {
    """g-force,ગુ-બળ,,{0} G,{0} G,ગુ-બળ,,{0} ગુ,{0} ગુ,ગુ-બળ,,{0} ગુ-બળ,{0} ગુ-બળ
        meter-per-square-second,મી/સે²,,{0} મી/સે²,{0} મી/સે²,મીટર/સેકન્ડ²,,{0} મી/સે²,{0} મી/સે²,મીટર પ્રતિ સેકન્ડ²,,{0} મીટર પ્રતિ સેકન્ડ²,{0} મીટર પ્રતિ સેકન્ડ²
        arc-minute,ચાપમિનિટ,,{0}′,{0}′,ચાપમિનિટ,,{0} ચાપમિનિટ,{0} ચાપ મિનિટ,ચાપમિનિટ,,{0} ચાપમિનિટ,{0} ચાપમિનિટ
        arc-second,ચાપસેકન્ડ,,{0}″,{0}″,ચાપસેકન્ડ,,{0} ચાપસેકન્ડ,{0} ચાપસેકન્ડ,ચાપસેકન્ડ,,{0} ચાપસેકન્ડ,{0} ચાપસેકન્ડ
        degree,અંશ,,{0} અંશ,{0} અંશ,અંશ,,{0} અંશ,{0} અંશ,અંશ,,{0} અંશ,{0} અંશ
        radian,સમત્રિજ્યાકોણ,,{0} સમત્રિ.,{0} સમત્રિ.,સમત્રિજ્યાકોણ,,{0} સમત્રિ.,{0} સમત્રિ.,સમત્રિજ્યાકોણ,,{0} સમત્રિજ્યાકોણ,{0} સમત્રિજ્યાકોણ
        revolution,પરિભ્રમણ,,{0} પરિભ્રમણ,{0} પરિભ્રમણ,પરિભ્રમણ,,{0} પરિભ્રમણ,{0} પરિભ્રમણ,પરિભ્રમણ,,{0} પરિભ્રમણ,{0} પરિભ્રમણ
        acre,એકર,,{0} એકર,{0} એકર,એકર,,{0} એકર,{0} એકર,એકર,,{0} એકર,{0} એકર
        dunam,ડનમ,,{0} ડનમ,{0} ડનમ,ડનમ,,{0} ડનમ,{0} ડનમ,ડનમ,,{0} ડનમ,{0} ડનમ
        hectare,હેક્ટર,,{0} હેક્ટર,{0} હેક્ટર,હેક્ટર,,{0} હેક્ટર,{0} હેક્ટર,હેક્ટર,,{0} હેક્ટર,{0} હેક્ટર
        square-centimeter,ચોરસ સેમી,{0} પ્રતિ ચો. સેમી,{0}ચો.સેમી,{0}ચો.સેમી,ચોરસ સેમી,{0} પ્રતિ ચો. સેમી,{0} ચોરસ સેમી,{0} ચોરસ સેમી,ચોરસ સેન્ટીમીટર,{0} પ્રતિ ચોરસ સેન્ટિમીટર,{0} ચોરસ સેન્ટીમીટર,{0} ચોરસ સેન્ટીમીટર
        square-foot,ચોરસ ફૂટ,,{0} ચોરસ ફૂટ,{0} ચોરસ ફૂટ,ચોરસ ફૂટ,,{0} ચોરસ ફૂટ,{0} ચોરસ ફૂટ,ચોરસ ફૂટ,,{0} ચોરસ ફૂટ,{0} ચોરસ ફૂટ
        square-inch,ચોરસ ઇંચ,{0} પ્રતિ ચો. ઈંચ,{0} ચોરસ ઇંચ,{0} ચોરસ ઇંચ,ચોરસ ઇંચ,{0} પ્રતિ ચો. ઈંચ,{0} ચોરસ ઇંચ,{0} ચોરસ ઇંચ,ચોરસ ઇંચ,{0} પ્રતિ ચોરસ ઈંચ,{0} ચોરસ ઇંચ,{0} ચોરસ ઇંચ
        square-kilometer,ચોરસ કિમી,{0} /ચોરસ કિમી,{0}ચો.કિમી,{0}ચો.કિમી,ચોરસ કિમી,{0} /ચોરસ કિમી,{0} ચોરસ કિમી,{0} ચોરસ કિમી,ચોરસ કિલોમીટર,{0} પ્રતિ ચોરસ કિમી,{0} ચોરસ કિલોમીટર,{0} ચોરસ કિલોમીટર
        square-meter,ચોરસ મીટર,{0} પ્રતિ ચો. મીટર,{0}ચો.મીટર,{0}ચો.મીટર,ચોરસ મીટર,{0} પ્રતિ ચો. મીટર,{0} ચોરસ મીટર,{0} ચોરસ મીટર,ચોરસ મીટર,{0} પ્રતિ ચોરસ મીટર,{0} ચોરસ મીટર,{0} ચોરસ મીટર
        square-mile,ચોરસ માઇલ,{0} / ચોરસ માઇલ,{0} ચોરસ માઇલ,{0} ચોરસ માઇલ,ચોરસ માઇલ,{0} / ચોરસ માઇલ,{0} ચોરસ માઇલ,{0} ચોરસ માઇલ,ચોરસ માઇલ,{0} પ્રતિ ચોરસ માઈલ,{0} ચોરસ માઇલ,{0} ચોરસ માઇલ
        square-yard,ચોરસ વાર,,{0} ચોરસ વાર,{0} ચોરસ વાર,ચોરસ વાર,,{0} ચોરસ વાર,{0} ચોરસ વાર,ચોરસ વાર,,{0} ચોરસ વાર,{0} ચોરસ વાર
        item,વસ્તુ,,{0} વસ્તુ,{0} વસ્તુ,વસ્તુ,,{0} વસ્તુ,{0} વસ્તુ,વસ્તુ,,{0} વસ્તુ,{0} વસ્તુ
        karat,કૅરેટ,,{0} કૅરેટ,{0} કૅરેટ,કૅરેટ,,{0} કૅરેટ,{0} કૅરેટ,કૅરેટ,,{0} કૅરેટ,{0} કૅરેટ
        milligram-ofglucose-per-deciliter,,,,,,,,,મિલિગ્રામ પ્રતિ ડેસિલિટર,,{0} મિલિગ્રામ પ્રતિ ડેસિલિટર,{0} મિલિગ્રામ પ્રતિ ડેસિલિટર
        millimole-per-liter,,,,,મિલિમોલ/લિટર,,,{0} mmol/L,મિલિમોલ પ્રતિ લિટર,,{0} મિલિમોલ પ્રતિ લિટર,{0} મિલિમોલ પ્રતિ લિટર
        mole,મોલ,,{0} મોલ,{0} મોલ,મોલ,,{0} મોલ,{0} મોલ,મોલ,,{0} મોલ,{0} મોલ
        percent,,,,,ટકા,,,{0}%,ટકા,,{0} ટકા,{0} ટકા
        permille,,,,,પ્રતિમાઈલ,,,{0}‰,પ્રતિમાઈલ,,{0} પ્રતિમાઈલ,{0} પ્રતિમાઈલ
        permillion,,,,,કણ/મિલિયન,,,{0} ppm,કણ પ્રતિ મિલિયન,,{0} કણ પ્રતિ મિલિયન,{0} કણ પ્રતિ મિલિયન
        permyriad,,,,,પરમિરિયડ,,,{0}‱,પરમિરિયડ,,{0} પરમિરિયડ,{0} પરમિરિયડ
        portion-per-1e9,ભાગ/અબજ,,{0} પ્રતિ અબજ ભાગ,{0} પ્રતિ અબજ ભાગ,ભાગ/અબજ,,{0} પ્રતિ અબજ ભાગ,{0} પ્રતિ અબજ ભાગ,પ્રતિ અબજ ભાગ,,{0} પ્રતિ અબજ ભાગ,{0} પ્રતિ અબજ ભાગ
        liter-per-100-kilometer,લિ/100 કિમી,,{0}લિ/100કિમી,{0}લિ/100કિમી,લિ/100 કિમી,,{0} લિ/100 કિમી,{0} લિ/100 કિમી,લિટર પ્રતિ 100 કિલોમીટર,,{0} લિટર પ્રતિ 100 કિલોમીટર,{0} લિટર પ્રતિ 100 કિલોમીટર
        liter-per-kilometer,લીટર/કિમી,,{0} લીટર/કિમી,{0} લીટર/કિમી,લીટર/કિમી,,{0} લીટર/કિમી,{0} લીટર/કિમી,લીટર પ્રતિ કિલોમીટર,,{0} લીટર પ્રતિ કિલોમીટર,{0} લીટર પ્રતિ કિલોમીટર
        mile-per-gallon,માઇલ/ગૅલન,,{0} માઇલ/ગૅલન,{0} માઇલ/ગૅલન,માઇલ/ગૅલન,,{0} માઇલ/ગૅલન,{0} માઇલ/ગૅલન,માઇલ પ્રતિ ગૅલન,,{0} માઇલ પ્રતિ ગૅલન,{0} માઇલ પ્રતિ ગૅલન
        mile-per-gallon-imperial,માઈલ/ઈમ્પે. ગેલન,,{0} માઈલ/ઈમ્પે. ગેલન,{0} માઈલ/ઈમ્પે. ગેલન,માઈલ/ઈમ્પે. ગેલન,,,{0} mpg Imp.,માઈલ પ્રતિ ઈમ્પે. ગેલન,,{0} માઈલ પ્રતિ ઈમ્પે. ગેલન,{0} માઈલ પ્રતિ ઈમ્પે. ગેલન
        bit,બિટ,,{0} બિટ,{0} બિટ,બિટ,,{0} બિટ,{0} બિટ,બિટ,,{0} બિટ,{0} બિટ
        byte,બાઇટ,,{0} બાઇટ,{0} બાઇટ,બાઇટ,,{0} બાઇટ,{0} બાઇટ,બાઇટ,,{0} બાઇટ,{0} બાઇટ
        gigabit,,,,,ગીગાબિટ,,,{0} Gb,ગીગાબિટ,,{0} ગીગાબિટ,{0} ગીગાબિટ
        gigabyte,,,,,,,,,ગીગાબાઇટ,,{0} ગીગાબાઇટ,{0} ગીગાબાઇટ
        kilobit,,,,,,,,,કિલોબિટ,,{0} કિલોબિટ,{0} કિલોબિટ
        kilobyte,,,,,,,,,કિલોબાઇટ,,{0} કિલોબાઇટ,{0} કિલોબાઇટ
        megabit,,,,,,,,,મેગાબિટ,,{0} મેગાબિટ,{0} મેગાબિટ
        megabyte,,,,,,,,,મેગાબાઇટ,,{0} મેગાબાઇટ,{0} મેગાબાઇટ
        petabyte,,,,,PByte,,,{0} PB,પેટાબાઈટ્સ,,{0} પેટાબાઈટ,{0} પેટાબાઈટ્સ
        terabit,,,,,,,,,ટેરાબિટ,,{0} ટેરાબિટ,{0} ટેરાબિટ
        terabyte,,,,,,,,,ટેરાબાઇટ,,{0} ટેરાબાઇટ,{0} ટેરાબાઇટ
        century,સદી,,{0} સદી,{0} સદી,સદી,,{0} સદી,{0} સદી,સદીઓ,,{0} સદી,{0} સદીઓ
        day,દિવસ,{0}/ દિ,{0} દિ,{0} દિ,દિવસ,{0}/ દિવસ,{0} દિવસ,{0} દિવસ,દિવસ,{0} પ્રતિ દિવસ,{0} દિવસ,{0} દિવસ
        decade,દાયકા,,{0} દા,{0} દા,દાયકા,,{0} દા,{0} દા,દાયકા,,{0} દાયકો,{0} દાયકા
        hour,કલાક,{0}/ક,{0} ક,{0} ક,કલાક,{0} પ્રતિ કલાક,{0} કલાક,{0} કલાક,કલાક,{0} પ્રતિ કલાક,{0} કલાક,{0} કલાક
        microsecond,,,,,,,,,માઇક્રોસેકંડ,,{0} માઇક્રોસેકંડ,{0} માઇક્રોસેકંડ
        millisecond,મિલિસેકન્ડ,,{0} મિસે,{0} મિસે,મિલિસેકન્ડ,,{0} મિસે,{0} મિસે,મિલિસેકન્ડ,,{0} મિલિસેકન્ડ,{0} મિલિસેકન્ડ
        minute,મિનિટ,{0}/મિ,{0} મિ,{0} મિ,મિનિટ,{0}/મિ.,{0} મિનિટ,{0} મિનિટ,મિનિટ,{0} પ્રતિ મિનિટ,{0} મિનિટ,{0} મિનિટ
        month,મહિના,{0}/માસ,{0} મ,{0} મ,મહિના,{0}/માસ,{0} મહિનો,{0} મહિના,મહિના,{0} પ્રતિ મહિનો,{0} મહિનો,{0} મહિના
        nanosecond,,,,,નેનોસેકંડ,,,{0} ns,નેનોસેકંડ,,{0} નેનોસેકંડ,{0} નેનોસેકંડ
        night,રાત,{0}/રાત,{0} રાત,{0} રાત,રાત,{0}/રાત,{0} રાત,{0} રાત,રાત,{0}/રાત,{0} રાત,{0} રાત
        quarter,ત્રિમાસ,{0}/ત્રિ,{0}ત્રિ,{0}ત્રિ,ત્રિમાસ,{0}/ત્રિ,{0}ત્રિ,{0}ત્રિ,ત્રિમાસિક,{0}/ત્રિ,{0} ત્રિમાસિક,{0} ત્રિમાસિક
        second,સેકંડ,{0}/સે,{0} સે,{0} સે,સેકંડ,{0} પ્રતિ સેકંડ,{0} સેકંડ,{0} સેકંડ,સેકંડ,{0} પ્રતિ સેકંડ,{0} સેકંડ,{0} સેકંડ
        week,અઠવાડિયા,{0} / અઠ.,{0} અઠ.,{0} અઠ.,અઠવાડિયા,{0} / અઠ.,{0} અઠ.,{0} અઠ.,અઠવાડિયા,{0} પ્રતિ અઠવાડિયું,{0} અઠવાડિયું,{0} અઠવાડિયા
        year,વર્ષ,{0}/વર્ષ,{0} વ,{0} વ,વર્ષ,{0}/વર્ષ,{0} વર્ષ,{0} વર્ષ,વર્ષ,{0} પ્રતિ વર્ષ,{0} વર્ષ,{0} વર્ષ
        ampere,,,,,,,,,એમ્પીયર,,{0} એમ્પીયર,{0} એમ્પીયર
        milliampere,,,,,,,,,મિલિએમ્પીયર,,{0} મિલિએમ્પીયર,{0} મિલિએમ્પીયર
        ohm,ઓહ્મ,,,{0} Ω,ઓહ્મ,,,{0} Ω,ઓહ્મ,,{0} ઓહ્મ,{0} ઓહ્મ
        volt,વૉલ્ટ,,,{0} V,વૉલ્ટ,,,{0} V,વૉલ્ટ,,{0} વૉલ્ટ,{0} વૉલ્ટ્
        british-thermal-unit,BTU,,,{0} Btu,BTU,,,{0} Btu,બ્રિટીશ થર્મલ યુનિટ,,{0} બ્રિટીશ થર્મલ યુનિટ,{0} બ્રિટીશ થર્મલ યુનિટ
        calorie,cal,,{0} Cal,{0} cal,cal,,{0} Cal,{0} cal,કેલરી,,{0} કેલરી,{0} કેલરી
        electronvolt,,,,,ઇલેક્ટ્રોનવૉલ્ટ,,,{0} eV,ઇલેક્ટ્રોનવૉલ્ટ,,{0} ઇલેક્ટ્રોનવૉલ્ટ,{0} ઇલેક્ટ્રોનવૉલ્ટ
        foodcalorie,કેલરી,,{0} કેલરી,{0} કેલરી,કેલરી,,{0} કેલરી,{0} કેલરી,કેલરી,,{0} કેલરી,{0} કેલરી
        joule,જૂલ,,,{0} J,જૂલ,,,{0} J,જૂલ,,{0} જૂલ,{0} જૂલ
        kilocalorie,,,,,,,,,કિલોકેલરી,,{0} કિલોકેલરી,{0} કિલોકેલરી
        kilojoule,,,,,,,,,કિલોજૂલ,,{0} કિલોજૂલ,{0} કિલોજૂલ
        kilowatt-hour,,,,,,,,,કિલોવૉટ-કલાક,,{0} કિલોવૉટ કલાક,{0} કિલોવૉટ-કલાક
        therm-us,યુએસ થર્મ,,{0} યુએસ થર્મ,{0} યુએસ થર્મ,યુએસ થર્મ,,{0} યુએસ થર્મ,{0} યુએસ થર્મ,યુએસ થર્મ,,{0} યુએસ થર્મ,{0} યુએસ થર્મ
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0}kWh/100km,,,,,કિલોવૉટ કલાક પ્રતિ 100 કિલોમીટર,,{0} કિલોવૉટ કલાક પ્રતિ 100 કિલોમીટર,{0} કિલોવૉટ કલાક પ્રતિ 100 કિલોમીટર
        newton,,,,,ન્યૂટન,,,{0} N,ન્યૂટન,,{0} ન્યૂટન,{0} ન્યૂટન
        pound-force,,,,,પાઉન્ડ બળ,,,{0} lbf,પાઉન્ડ બળ,,{0} પાઉન્ડ બળ,{0} પાઉન્ડ બળ
        gigahertz,,,,,,,,,ગીગાહર્ટ્ઝ,,{0} ગીગાહર્ટ્ઝ,{0} ગીગાહર્ટ્ઝ
        hertz,હર્ટ્ઝ,,,{0} Hz,હર્ટ્ઝ,,,{0} Hz,હર્ટ્ઝ,,{0} હર્ટ્ઝ,{0} હર્ટ્ઝ
        kilohertz,,,,,,,,,કિલોહર્ટ્ઝ,,{0} કિલોહર્ટ્ઝ,{0} કિલોહર્ટ્ઝ
        megahertz,,,,,,,,,મેગાહર્ટ્ઝ,,{0} મેગાહર્ટ્ઝ,{0} મેગાહર્ટ્ઝ
        dot,ડૉટ,,{0} ડૉટ,{0} ડૉટ,ડૉટ,,{0} ડૉટ,{0} ડૉટ,ડૉટ,,{0} ડૉટ,{0} ડૉટ
        dot-per-centimeter,dpcm,,{0} dpcm,{0} dpcm,dpcm,,{0} dpcm,{0} dpcm,ડૉટ પ્રતિ સેન્ટિમીટર,,{0} ડૉટ પ્રતિ સેન્ટિમીટર,{0} ડૉટ પ્રતિ સેન્ટિમીટર
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,ડૉટ પ્રતિ ઇંચ,,{0} ડૉટ પ્રતિ ઇંચ,{0} ડૉટ પ્રતિ ઇંચ
        em,,,,,,,,,ટાઇપોગ્રાફિક એમ,,{0} em,{0} ems
        megapixel,,,,,મેગાપિક્સેલ,,,{0} MP,મેગાપિક્સેલ,,{0} મેગાપિક્સેલ,{0} મેગાપિક્સેલ
        pixel,,,,,પિક્સેલ,,,{0} px,પિક્સેલ,,{0} પિક્સેલ,{0} પિક્સેલ
        pixel-per-centimeter,,,,,,,,,પિક્સેલ પ્રતિ સેન્ટિમીટર,,{0} પિક્સેલ પ્રતિ સેન્ટિમીટર,{0} પિક્સેલ પ્રતિ સેન્ટિમીટર
        pixel-per-inch,,,,,,,,,પિક્સેલ પ્રતિ ઇંચ,,{0} પિક્સેલ પ્રતિ ઇંચ,{0} પિક્સેલ પ્રતિ ઇંચ
        astronomical-unit,ખગોળીય યુનિટ,,,{0} au,ખગોળીય યુનિટ,,,{0} au,ખગોળીય યુનિટ,,{0} ખગોળીય યુનિટ,{0} ખગોળીય યુનિટ
        centimeter,સેમી,{0}/સેમી,{0} સેમી,{0} સેમી,સેમી,{0}/સેમી,{0} સેમી,{0} સેમી,સેન્ટિમીટર,{0} પ્રતિ સેન્ટિમીટર,{0} સેન્ટિમીટર,{0} સેન્ટિમીટર
        decimeter,ડેમી,,{0} ડેમી,{0} ડેમી,ડેમી,,{0} ડેમી,{0} ડેમી,ડેસિમીટર,,{0} ડેસિમીટર,{0} ડેસિમીટર
        fathom,ફૅધમ,,,{0} fth,ફૅધમ,,,{0} fth,ફૅધમ,,{0} ફૅધમ,{0} ફૅધમ
        foot,ફૂટ,{0}/ફૂટ,{0} ',{0} ',ફૂટ,{0}/ફૂટ,{0} ફૂટ,{0} ફૂટ,ફૂટ,{0} પ્રતિ ફૂટ,{0} ફૂટ,{0} ફૂટ
        furlong,ફર્લાંગ,,,{0} fur,ફર્લાંગ,,,{0} fur,ફર્લાંગ,,{0} ફર્લાંગ,{0} ફર્લાંગ
        inch,ઇંચ,{0}/ઈંચ,{0} '',{0} '',ઇંચ,{0}/ઈંચ,{0} ઇંચ,{0} ઇંચ,ઇંચ,{0} પ્રતિ ઈંચ,{0} ઇંચ,{0} ઇંચ
        kilometer,કિમી,{0}/કિમી,{0} કિમી,{0} કિમી,કિમી,{0}/કિમી,{0} કિમી,{0} કિમી,કિલોમીટર,{0} પ્રતિ કિલોમીટર,{0} કિલોમીટર,{0} કિલોમીટર
        light-year,પ્રકાશ વર્ષ,,{0}પ્રકાશવર્ષ,{0}પ્રકાશવર્ષ,પ્રકાશ વર્ષ,,{0} પ્રકાશ વર્ષ,{0} પ્રકાશ વર્ષ,પ્રકાશ વર્ષ,,{0} પ્રકાશ વર્ષ,{0} પ્રકાશ વર્ષ
        meter,મી,{0}/મી,{0} મી,{0} મી,મીટર,{0}/મી,{0} મી,{0} મી,મીટર,{0} પ્રતિ મીટર,{0} મીટર,{0} મીટર
        micrometer,માઇક્રોમીટર,,{0} μમી,{0} μમી,માઇક્રોમીટર,,{0} μમી,{0} μમી,માઇક્રોમીટર,,{0} માઇક્રોમીટર,{0} માઇક્રોમીટર
        mile,માઇલ,,{0} માઇલ,{0} માઇલ,માઇલ,,{0} માઇલ,{0} માઇલ,માઇલ,,{0} માઇલ,{0} માઇલ
        mile-scandinavian,smi,,{0}smi,{0}smi,,,,,માઈલ સ્કૅન્ડિનેવિઅન,,{0} માઈલ-સ્કૅન્ડિનેવિઅન,{0} માઈલ-સ્કૅન્ડિનેવિઅન
        millimeter,મિમી,,{0} મિમી,{0} મિમી,મિમી,,{0} મિમી,{0} મિમી,મિલિમીટર,,{0} મિલિમીટર,{0} મિલિમીટર
        nanometer,નેનોમીટર,,{0} નેનોમીટર,{0} નેનોમીટર,નેનોમીટર,,{0} નેનોમીટર,{0} નેનોમીટર,નેનોમીટર,,{0} નેનોમીટર,{0} નેનોમીટર
        nautical-mile,નૉટિકલ માઇલ,,,{0} nmi,નૉટિકલ માઇલ,,,{0} nmi,નૉટિકલ માઇલ,,{0} નૉટિકલ માઇલ,{0} નૉટિકલ માઇલ
        parsec,પરસેક,,{0} પરસેક,{0} પરસેક,પરસેક,,{0} પરસેક,{0} પરસેક,પરસેક,,{0} પરસેક,{0} પરસેક
        picometer,પિસૉમીટર,,{0}પિસૉ.મી,{0}પિસૉ.મી,પિસૉમીટર,,{0} પિસૉમીટર,{0} પિસૉમીટર,પિસૉમીટર,,{0} પિસૉમીટર,{0} પિસૉમીટર
        point,પોઈન્ટ,,{0} પોઈન્ટ,{0} પોઈન્ટ,પોઈન્ટ,,{0} પોઈન્ટ,{0} પોઈન્ટ,પોઈન્ટ્સ,,{0} પોઈન્ટ,{0} પોઈન્ટ્સ
        solar-radius,,,,,સૌર ત્રિજ્યા,,,{0} R☉,સૌર ત્રિજ્યા,,{0} સૌર ત્રિજ્યા,{0} સૌર ત્રિજ્યા
        yard,વાર,,{0} વાર,{0} વાર,વાર,,{0} વાર,{0} વાર,વાર,,{0} વાર,{0} વાર
        candela,,,,,,,,,કેન્ડેલા,,{0} કેન્ડેલા,{0} કેન્ડેલા
        lumen,,,,,,,,,લૂમેન,,{0} લૂમેન,{0} લૂમેન
        lux,લક્સ,,{0} લક્સ,{0} લક્સ,લક્સ,,{0} લક્સ,{0} લક્સ,લક્સ,,{0} લક્સ,{0} લક્સ
        solar-luminosity,,,,,સૌર તેજસ્વિતા,,,{0} L☉,સૌર તેજસ્વિતા,,{0} સૌર તેજસ્વિતા,{0} સૌર તેજસ્વિતા
        carat,કેરેટ,,{0} કેરેટ,{0} કેરેટ,કેરેટ,,{0} કેરેટ,{0} કેરેટ,કેરેટ,,{0} કેરેટ,{0} કેરેટ
        dalton,,,,,ડાલ્ટન,,,{0} Da,ડાલ્ટન,,{0} ડાલ્ટન,{0} ડાલ્ટન
        earth-mass,,,,,પૃથ્વી ઘનતા,,,{0} M⊕,પૃથ્વી ઘનતા,,{0} પૃથ્વી ઘનતા,{0} પૃથ્વી ઘનતા
        grain,ગ્રેન,,{0} ગ્રેન,{0} ગ્રેન,ગ્રેન,,{0} ગ્રેન,{0} ગ્રેન,ગ્રેન,,{0} ગ્રેન,{0} ગ્રેન
        gram,ગ્રામ,{0}/ગ્રામ,{0} ગ્રા,{0} ગ્રા,ગ્રામ,{0}/ગ્રામ,{0} ગ્રા,{0} ગ્રા,ગ્રામ,{0} પ્રતિ ગ્રામ,{0} ગ્રામ,{0} ગ્રામ
        kilogram,કિગ્રા,{0}/કિગ્રા,{0} કિગ્રા,{0} કિગ્રા,કિગ્રા,{0}/કિગ્રા,{0} કિગ્રા,{0} કિગ્રા,કિલોગ્રામ,{0} પ્રતિ કિલોગ્રામ,{0} કિલોગ્રામ,{0} કિલોગ્રામ
        microgram,μગ્રામ,,{0} μગ્રામ,{0} μગ્રામ,μગ્રામ,,{0} μગ્રામ,{0} μગ્રામ,માઇક્રોગ્રામ,,{0} માઇક્રોગ્રામ,{0} માઇક્રોગ્રામ
        milligram,મિગ્રા,,{0} મિગ્રા,{0} મિગ્રા,મિગ્રા,,{0} મિગ્રા,{0} મિગ્રા,મિલિગ્રામ,,{0} મિલિગ્રામ,{0} મિલિગ્રામ
        ounce,ઔંસ,{0}/ઔંસ,{0} ઔંસ,{0} ઔંસ,ઔંસ,{0}/ઔંસ,{0} ઔંસ,{0} ઔંસ,ઔંસ,{0} પ્રતિ ઔંસ,{0} ઔંસ,{0} ઔંસ
        ounce-troy,ટ્રોય ઔંસ,,{0} ટ્રોય ઔંસ,{0} ટ્રોય ઔંસ,ટ્રોય ઔંસ,,{0} ટ્રોય ઔંસ,{0} ટ્રોય ઔંસ,ટ્રોય ઔંસ,,{0} ટ્રોય ઔંસ,{0} ટ્રોય ઔંસ
        pound,પાઉન્ડ,{0}/પાઉન્ડ,{0} પાઉન્ડ,{0} પાઉન્ડ,પાઉન્ડ,{0}/પાઉન્ડ,{0} પાઉન્ડ,{0} પાઉન્ડ,પાઉન્ડ,{0} પ્રતિ પાઉન્ડ,{0} પાઉન્ડ,{0} પાઉન્ડ
        solar-mass,,,,,સૌર ઘનતા,,,{0} M☉,સૌર ઘનતા,,{0} સૌર ઘનતા,{0} સૌર ઘનતા
        stone,સ્ટોન,,{0}સ્ટોન,{0}સ્ટોન,સ્ટોન્સ,,{0} સ્ટોન,{0} સ્ટોન,સ્ટોન્સ,,{0} સ્ટોન,{0} સ્ટોન
        ton,ટન,,{0} ટન,{0} ટન,ટન,,{0} ટન,{0} ટન,ટન,,{0} ટન,{0} ટન
        tonne,,,,,,,,,મેટ્રિક ટન,,{0} મેટ્રિક ટન,{0} મેટ્રિક ટન
        gigawatt,,,,,,,,,ગીગાવૉટ,,{0} ગીગાવૉટ,{0} ગીગાવૉટ
        horsepower,,,,,,,,,હોર્સપાવર,,{0} હોર્સપાવર,{0} હોર્સપાવર
        kilowatt,,,,,,,,,કિલોવૉટ,,{0} કિલોવૉટ,{0} કિલોવૉટ
        megawatt,,,,,,,,,મેગાવૉટ,,{0} મેગાવૉટ,{0} મેગાવૉટ
        milliwatt,,,,,,,,,મિલિવૉટ,,{0} મિલિવૉટ,{0} મિલિવૉટ
        watt,વૉટ,,,{0} W,વૉટ,,,{0} W,વૉટ,,{0} વૉટ,{0} વૉટ
        atmosphere,,,,,,,,,વાતાવરણ,,{0} વાતાવરણ,{0} વાતાવરણ
        bar,બાર,,{0} બાર,{0} બાર,બાર,,{0} બાર,{0} બાર,બાર,,{0} બાર,{0} બાર
        hectopascal,,,,,,,,,હેક્ટૉપાસ્કલ,,{0} હેક્ટૉપાસ્કલ,{0} હેક્ટૉપાસ્કલ
        inch-ofhg,,,,,,,,,પારાના ઇંચ,,{0} પારાના ઇંચ,{0} પારાના ઇંચ
        kilopascal,,,,,,,,,કિલોપાસ્કલ,,{0} કિલોપાસ્કલ,{0} કિલોપાસ્કલ
        megapascal,,,,,,,,,મેગાપાસ્કલ,,{0} મેગાપાસ્કલ,{0} મેગાપાસ્કલ
        millibar,mbar,,{0} મિલિબાર,{0}મિલીબાર,,,,,મિલિબાર,,{0} મિલિબાર,{0} મિલિબાર
        millimeter-ofhg,mmHg,,{0} mmHg,{0} mmHg,mmHg,,{0} mmHg,{0} mmHg,પારાનું મિલિમીટર,,{0} પારાનું મિલિમીટર,{0} પારાનું મિલિમીટર
        pascal,,,,,,,,,પાસ્કલ,,{0} પાસ્કલ,{0} પાસ્કલ
        pound-force-per-square-inch,,,,,,,,,પાઉન્ડ પ્રતિ વર્ગ ઇંચ,,{0} પાઉન્ડ પ્રતિ વર્ગ ઇંચ,{0} પાઉન્ડ પ્રતિ વર્ગ ઇંચ
        beaufort,,,,,,,,,બોફર્ટ,,બોફર્ટ {0},બોફર્ટ {0}
        kilometer-per-hour,કિમી/કલાક,,{0} કિપ્રક,{0} કિપ્રક,કિમી/કલાક,,{0} કિમી/કલાક,{0} કિમી/કલાક,કિલોમીટર પ્રતિ કલાક,,{0} કિલોમીટર પ્રતિ કલાક,{0} કિલોમીટર પ્રતિ કલાક
        knot,નોટ,,{0} નોટ,{0} નોટ,નોટ,,{0} નોટ,{0} નોટ,નોટ,,{0} નોટ,{0} નોટ
        light-speed,લાઇટ,,{0} લાઇટ,{0} લાઇટ,લાઇટ,,{0} લાઇટ,{0} લાઇટ,લાઇટ,,{0} લાઇટ,{0} લાઇટ
        meter-per-second,મીટર/સેકન્ડ,,{0} મીટર/સેકન્ડ,{0} મીટર/સેકન્ડ,મીટર/સેકન્ડ,,{0} મીટર/સેકન્ડ,{0} મીટર/સેકન્ડ,મીટર પ્રતિ સેકન્ડ,,{0} મીટર પ્રતિ સેકન્ડ,{0} મીટર પ્રતિ સેકન્ડ
        mile-per-hour,માઇલ/કલાક,,{0} માઇલ/કલાક,{0} માઇલ/કલાક,માઇલ/કલાક,,{0} માઇલ/કલાક,{0} માઇલ/કલાક,માઇલ પ્રતિ કલાક,,{0} માઇલ પ્રતિ કલાક,{0} માઇલ પ્રતિ કલાક
        celsius,,,,,ડિગ્રી સેલ્સિયસ,,,{0}°C,ડિગ્રી સેલ્સિયસ,,{0} ડિગ્રી સેલ્સિયસ,{0} ડિગ્રી સેલ્સિયસ
        fahrenheit,ડિગ્રી ફેરનહીટ,,,{0}°F,ડિગ્રી ફેરનહીટ,,,{0}°F,ડિગ્રી ફેરનહીટ,,{0} ડિગ્રી ફેરનહીટ,{0} ડિગ્રી ફેરનહીટ
        kelvin,કેલ્વિન,,,{0} K,કેલ્વિન,,,{0} K,કેલ્વિન,,{0} કેલ્વિન,{0} કેલ્વિન
        newton-meter,,,,,,,,,ન્યૂટન-મીટર,,{0} ન્યૂટન-મીટર,{0} ન્યૂટન-મીટર
        pound-force-foot,,,,,,,,,પાઉન્ડ ફૂટ,,{0} પાઉન્ડ ફૂટ,{0} પાઉન્ડ ફૂટ
        acre-foot,એકર-ફૂટ,,{0} એકર-ફૂટ,{0} એકર-ફૂટ,એકર-ફૂટ,,{0} એકર-ફૂટ,{0} એકર-ફૂટ,એકર-ફૂટ,,{0} એકર-ફૂટ,{0} એકર-ફૂટ
        barrel,બેરલ,,,{0} bbl,બેરલ,,,{0} bbl,બેરલ,,{0} બેરલ,{0} બેરલ
        bushel,બુશલ,,,{0} bu,બુશલ,,,{0} bu,બુશલ,,{0} બુશલ,{0} બુશલ
        centiliter,સેન્ટિલીટર,,{0} સેન્ટિલીટર,{0} સેન્ટિલીટર,સેન્ટિલીટર,,{0} સેન્ટિલીટર,{0} સેન્ટિલીટર,સેન્ટિલીટર,,{0} સેન્ટિલીટર,{0} સેન્ટિલીટર
        cubic-centimeter,ઘન સેમી,{0}/ ઘન સેમી,{0} ઘન સેમી,{0} ઘન સેમી,ઘન સેમી,{0}/ ઘન સેમી,{0} ઘન સેમી,{0} ઘન સેમી,ઘન સેન્ટિમીટર,{0} પ્રતિ ઘન સેન્ટિમીટર,{0} ઘન સેન્ટિમીટર,{0} ઘન સેન્ટિમીટર
        cubic-foot,ઘન ફૂટ,,{0} ઘન ફૂટ,{0} ઘન ફૂટ,ઘન ફૂટ,,{0} ઘન ફૂટ,{0} ઘન ફૂટ,ઘન ફૂટ,,{0} ઘન ફૂટ,{0} ઘન ફૂટ
        cubic-inch,ઘન ઇંચ,,{0} ઘન ઇંચ,{0} ઘન ઇંચ,ઘન ઇંચ,,{0} ઘન ઇંચ,{0} ઘન ઇંચ,ઘન ઇંચ,,{0} ઘન ઇંચ,{0} ઘન ઇંચ
        cubic-kilometer,ઘન કિમી,,{0} ઘન કિમી,{0} ઘન કિમી,ઘન કિમી,,{0} ઘન કિમી,{0} ઘન કિમી,ઘન કિલોમીટર,,{0} ઘન કિલોમીટર,{0} ઘન કિલોમીટર
        cubic-meter,ઘન મીટર,{0}/ઘન મી.,{0} ઘન મીટર,{0} ઘન મીટર,ઘન મીટર,{0}/ઘન મી.,{0} ઘન મીટર,{0} ઘન મીટર,ઘન મીટર,{0} પ્રતિ ઘન મીટર,{0} ઘન મીટર,{0} ઘન મીટર
        cubic-mile,ઘન માઇલ,,{0} ઘન માઇલ,{0} ઘન માઇલ,ઘન માઇલ,,{0} ઘન માઇલ,{0} ઘન માઇલ,ઘન માઇલ,,{0} ઘન માઇલ,{0} ઘન માઇલ
        cubic-yard,ઘન વાર,,{0} ઘન વાર,{0} ઘન વાર,ઘન વાર,,{0} ઘન વાર,{0} ઘન વાર,ઘન વાર,,{0} ઘન વાર,{0} ઘન વાર
        cup,કપ,,{0} કપ,{0} કપ,કપ,,{0} કપ,{0} કપ,કપ,,{0} કપ,{0} કપ
        cup-metric,મે. કપ,,{0} મે. કપ,{0} મે. કપ,મે. કપ,,{0} મે. કપ,{0} મે. કપ,મેટ્રિક કપ,,{0} મેટ્રિક કપ,{0} મેટ્રિક કપ
        deciliter,ડેસિલીટર,,{0} ડેસિલીટર,{0} ડેસિલીટર,ડેસિલીટર,,{0} ડેસિલીટર,{0} ડેસિલીટર,ડેસિલીટર,,{0} ડેસિલીટર,{0} ડેસિલીટર
        dessert-spoon,,,,,,,,,ડેઝર્ટ સ્પૂન,,{0} ડેઝર્ટ સ્પૂન,{0} ડેઝર્ટ સ્પૂન
        dessert-spoon-imperial,dstspn Imp,,{0} dstspn-Imp,{0} dstspn-Imp,,,,,ઇમ્પીરિયલ ડેઝર્ટ સ્પૂન,,{0} ઇમ્પીરિયલ ડેઝર્ટ સ્પૂન,{0} ઇમ્પીરિયલ ડેઝર્ટ સ્પૂન
        dram,ડ્રામ ફ્લૂઇડ,,,{0} dram fl,ડ્રામ ફ્લૂઇડ,,,{0} dram fl,ડ્રામ,,{0} ડ્રામ,{0} ડ્રામ
        drop,ડ્રોપ,,{0} ડ્રોપ,{0} ડ્રોપ,ડ્રોપ,,{0} ડ્રોપ,{0} ડ્રોપ,ડ્રોપ,,{0} ડ્રોપ,{0} ડ્રોપ
        fluid-ounce,પ્રવાહી ઔંસ,,{0} પ્ર. ઔંસ,{0} પ્ર. ઔંસ,પ્રવાહી ઔંસ,,{0} પ્રવાહી ઔંસ,{0} પ્રવાહી ઔંસ,પ્રવાહી ઔંસ,,{0} પ્રવાહી ઔંસ,{0} પ્રવાહી ઔંસ
        fluid-ounce-imperial,ઇમ્પીરિયલ પ્રવાહી ઔંસ,,{0} પ્રવાહી ઔંસ ઈમ્પી.,{0} પ્રવાહી ઔંસ ઈમ્પી.,ઇમ્પીરિયલ પ્રવાહી ઔંસ,,{0} પ્રવાહી ઔંસ ઇમ્પીરિયલ,{0} પ્રવાહી ઔંસ ઇમ્પીરિયલ,ઇમ્પીરિયલ પ્રવાહી ઔંસ,,{0} ઇમ્પીરિયલ પ્રવાહી ઔંસ,{0} ઇમ્પીરિયલ પ્રવાહી ઔંસ
        gallon,ગૅલન,{0}/ગૅલન,{0} ગૅલન,{0} ગૅલન,ગૅલન,{0}/ગૅલન,{0} ગૅલન,{0} ગૅલન,ગૅલન,{0} પ્રતિ ગૅલન,{0} ગૅલન,{0} ગૅલન
        gallon-imperial,ઈમ્પિ. ગૅલન,{0} /ગૅલન ઈમ્પિ.,{0} ગૅ. ઈમ્પિ.,{0} ગૅ. ઈમ્પિ.,ઈમ્પિ. ગૅલન,{0} /ગૅલન ઈમ્પિ.,{0} ગૅલન ઈમ્પિ.,{0} ગૅલન ઈમ્પિ.,ઈમ્પિ. ગૅલન,{0} પ્રતિ ઈમ્પિ. ગૅલન,{0} ઈમ્પિ. ગૅલન,{0} ઈમ્પિ. ગૅલન
        hectoliter,હેક્ટોલીટર,,{0} હેક્ટોલીટર,{0} હેક્ટોલીટર,હેક્ટોલીટર,,{0} હેક્ટોલીટર,{0} હેક્ટોલીટર,હેક્ટોલીટર,,{0} હેક્ટોલીટર,{0} હેક્ટોલીટર
        jigger,જિગર,,{0} જિગર,{0} જિગર,જિગર,,{0} જિગર,{0} જિગર,જિગર,,{0} જિગર,{0} જિગર
        liter,લિટર,{0}/લિ,{0} લિ,{0} લિ,લિટર,{0}/લિ,{0} લિ,{0} લિ,લિટર,{0} પ્રતિ લિટર,{0} લિટર,{0} લિટર
        megaliter,મેગાલીટર,,{0} મેગાલીટર,{0} મેગાલીટર,મેગાલીટર,,{0} મેગાલીટર,{0} મેગાલીટર,મેગાલીટર,,{0} મેગાલીટર,{0} મેગાલીટર
        milliliter,મિલિલીટર,,{0} મિલિલીટર,{0} મિલિલીટર,મિલિલીટર,,{0} મિલિલીટર,{0} મિલિલીટર,મિલિલીટર,,{0} મિલિલીટર,{0} મિલિલીટર
        pinch,ચપટી,,{0} ચપટી,{0} ચપટી,ચપટી,,{0} ચપટી,{0} ચપટી,ચપટી,,{0} ચપટી,{0} ચપટી
        pint,પિન્ટ,,{0} પિન્ટ,{0} પિન્ટ,પિન્ટ,,{0} પિન્ટ,{0} પિન્ટ,પિન્ટ,,{0} પિન્ટ,{0} પિન્ટ
        pint-metric,મે.પિન્ટ,,{0} મે.પિન્ટ,{0} મે.પિન્ટ,મે.પિન્ટ,,{0} મે.પિન્ટ,{0} મે.પિન્ટ,મેટ્રિક પિન્ટ,,{0} મેટ્રિક પિન્ટ,{0} મેટ્રિક પિન્ટ
        quart,ક્વાર્ટ,,{0} ક્વાર્ટ,{0} ક્વાર્ટ,ક્વાર્ટ,,{0} ક્વાર્ટ,{0} ક્વાર્ટ,ક્વાર્ટ,,{0} ક્વાર્ટ,{0} ક્વાર્ટ
        quart-imperial,,,,,,,,,ઇમ્પીરિયલ ક્વૉર્ટ,,{0} ઇમ્પીરિયલ ક્વૉર્ટ,{0} ઇમ્પીરિયલ ક્વૉર્ટ
        tablespoon,ટેબલસ્પૂન,,{0} ટેબલસ્પૂન,{0} ટેબલસ્પૂન,ટેબલસ્પૂન,,{0} ટેબલસ્પૂન,{0} ટેબલસ્પૂન,ટેબલસ્પૂન,,{0} ટેબલસ્પૂન,{0} ટેબલસ્પૂન
        teaspoon,ટીસ્પૂન,,{0} ટીસ્પૂન,{0} ટીસ્પૂન,ટીસ્પૂન,,{0} ટીસ્પૂન,{0} ટીસ્પૂન,ટીસ્પૂન,,{0} ટીસ્પૂન,{0} ટીસ્પૂન
        """.trimIndent()
  }

  private val gu_Prefixes: String by lazy {
    """square,,,ચોરસ {0}
        cubic,,,ઘન {0}
        times,,,{0}-{1}
        per,,,{0} પ્રતિ {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobe{0}
        10p-1,ડેસી{0},ડે.{0},ડેસી{0}
        10p-12,પીકો{0},પી.{0},પીકો{0}
        10p-15,ફેમ્ટો{0},ફે.{0},ફેમ્ટો{0}
        10p-18,એટો{0},એ.{0},એટો{0}
        10p-2,સેન્ટી{0},સે.{0},સેન્ટી{0}
        10p-21,ઝેપ્ટો{0},ઝેપ.{0},ઝેપ્ટો{0}
        10p-24,યોક્ટો{0},યોક.{0},યોક્ટો{0}
        10p-27,રો.{0},રો.{0},રોન્ટો{0}
        10p-3,મિલી{0},મિ.{0},મિલી{0}
        10p-30,ક્વેક્ટો{0},ક્વે.{0},ક્વેક્ટો{0}
        10p-6,,,માઇક્રો{0}
        10p-9,નેનો{0},ને.{0},નેનો{0}
        10p1,ડેકા{0},ડા.{0},ડેકા{0}
        10p12,ટેરા{0},ટે.{0},ટેરા{0}
        10p15,પિટા{0},પિ.{0},પિટા{0}
        10p18,એગ્ઝા{0},એગ.{0},એગ્ઝા{0}
        10p2,હેક્ટો{0},હે.{0},હેક્ટો{0}
        10p21,ઝેટા{0},ઝે.{0},ઝેટા{0}
        10p24,યોટા{0},યો.{0},યોટા{0}
        10p27,રો.{0},,રોના{0}
        10p3,કિલો{0},કિ.{0},કિલો{0}
        10p30,ક્વે.{0},,ક્વેટા{0}
        10p6,મેગા{0},મે.{0},મેગા{0}
        10p9,ગિગા{0},ગિ.{0},ગિગા{0}
        """.trimIndent()
  }

  private val guz_Units: String? = null

  private val guz_Prefixes: String? = null

  private val gv_Units: String? = null

  private val gv_Prefixes: String? = null

  private val ha_Units: String by lazy {
    """g-force,g-force,,G{0},Gs{0},g-force,,G {0},G {0},g-force,,g-force {0},g-force {0}
        meter-per-square-second,m/s²,,m/s²{0},m/s²{0},meters/sec²,,m/s² {0},m/s² {0},meters per second squared,,meter per second squared {0},meters per second squared {0}
        arc-minute,arcmin,,arcmin{0},arcmin{0},arcmins,,arcmin {0},arcmin {0},arcminutes,,arcminute {0},arcminutes {0}
        arc-second,arcsec,,arcsecs{0},arcsecs{0},arcsecs,,arcsec {0},arcsec {0},arcseconds,,arcsecond {0},arcseconds {0}
        degree,deg,,deg{0},deg{0},degrees,,deg {0},deg {0},degrees,,degree {0},degrees {0}
        radian,rad,,rad{0},rad{0},radian,,rad {0},rad {0},radians,,radian {0},radians {0}
        revolution,rev,,rev{0},rev{0},rev,,rev {0},rev {0},revolutions,,revolution {0},revolutions {0}
        acre,eka,,ek{0},ek{0},ekoki,,ek {0},ek {0},eka,,eka {0},ekoki {0}
        dunam,dunam,,dunam{0},dunam{0},dunams,,dunam {0},dunam {0},dunams,,dunam {0},dunams {0}
        hectare,hekta,,ha{0},hk{0},hektoci,,ha {0},ha {0},hektoci,,hekta {0},hektoci {0}
        square-centimeter,cm²,{0}/cm²,cm²{0},cm²{0},cm²,{0}/cm²,cm² {0},cm² {0},sikwaya sentimitoci,{0} a sikwaya sentimita,sikwaya sentimita {0},sikwaya sentimitoci {0}
        square-foot,sk ƙafa,,sk ƙf {0},sk ƙf{0},sk ƙafa,,sk ƙf {0},sk ƙf {0},sikwaya ƙafafu,,sikwaya ƙafa {0},sikwaya ƙafafu {0}
        square-inch,incina²,{0}/in²,in²{0},in²{0},incina²,{0}/in²,in² {0},in² {0},sikwaya incis,{0} a sikwaya inci,sikwaya inci {0},sikwaya incina {0}
        square-kilometer,km²,{0}/km²,km²{0},km²{0},km²,{0}/km²,km² {0},km² {0},sikwaya kilomitoci,{0} a sikwaya kilomita,sikwaya kilomita {0},sikwaya kilomitoci {0}
        square-meter,mitoci²,{0}/m²,m²{0},m²{0},mitoci²,{0}/m²,m² {0},m² {0},sikwaya mitoci,{0} a sikwaya mita,sikwaya mita {0},sikwaya mitoci {0}
        square-mile,sk mil-mil,{0}/mi²,sq mi{0},sq mi{0},sk mil-mil,{0}/mi²,sq mi {0},sq mi {0},sikwaya mil-mil,{0} a sikwaya mil,sikwaya mil {0},sikwaya mil-mil {0}
        square-yard,yd²,,yd²{0},yd²{0},yaduna²,,yd² {0},yd² {0},sikwaya yadina,,sikwaya yadi {0},sikwaya yaduna {0}
        item,abu,,abu{0},Abw{0},abu,,abu {0},Abw. {0},abubuwa,,abu {0},abubuwa {0}
        karat,karat,,kt{0},kt{0},karats,,kt {0},kt {0},karats,,karat {0},karats {0}
        milligram-ofglucose-per-deciliter,mg/dL,,mg/dL{0},mg/dL{0},mg/dL,,mg/dL {0},mg/dL {0},milligrams per deciliter,,milligram per deciliter {0},milligrams per deciliter {0}
        millimole-per-liter,mmol/L,,mmol/L{0},mmol/L{0},millimol/liter,,mmol/L {0},mmol/L {0},millimoles per liter,,millimole per liter {0},millimoles per liter {0}
        mole,mol,,mol{0},mol{0},mole,,mol {0},mol {0},moles,,mole {0},moles {0}
        percent,kaso,,%{0},%{0},kaso,,,{0}%,kaso,,kaso {0},Kaso {0}
        permille,‰,,‰{0},‰{0},permille,,‰{0},‰{0},permille,,permille {0},permille {0}
        permillion,ppm,,ppm{0},ppm{0},parts/million,,ppm {0},ppm {0},parts per million,,part per million {0},parts per million {0}
        permyriad,‱,,‱{0},‱{0},permyriad,,‱{0},‱{0},permyriad,,permyriad {0},permyriad {0}
        portion-per-1e9,sashi/biliyan,,sashi {0} a cikin biliyan,sashi {0} a cikin biliyan,sashi/biliyan,,sashi {0} a cikin biliyan,sashi {0} a cikin biliyan,sashi a cikin biliyan,,sashi {0} a cikin biliyan,sashi {0} a cikin biliyan
        liter-per-100-kilometer,L/100km,,L/100km{0},L/100km{0},L/100km,,L/100km {0},L/100km {0},litoci a kilomitoci 100,,lita a kilomitoci 100 {0},litoci a kilomitoci 100 {0}
        liter-per-kilometer,L/km,,L/km{0},L/km{0},litoci/km,,L/km {0},L/km {0},litoci a kilomita,,lita a kilomita {0},litoci a kilomita {0}
        mile-per-gallon,mil-mil/gal,,mag{0},mag{0},mil-mil/gal,,mag {0},mag {0},mil-mil a galan,,mil a galan {0},mil-mil a galan {0}
        mile-per-gallon-imperial,mag UK,,m/gUK{0},m/gUK{0},mil-mil/gal Imp.,,mag Imp. {0},mag Imp. {0},mil-mil a Imp. gallon,,mil a Imp. gallon {0},mil-mil a Imp. gallon {0}
        bit,bit,,bit{0},bit{0},bit,,bit {0},bit {0},bits,,bit {0},bits {0}
        byte,B,,B{0},B{0},byte,,byte {0},byte {0},bytes,,byte {0},bytes {0}
        gigabit,Gb,,Gb{0},Gb{0},Gbit,,Gb {0},Gb {0},gigabits,,gigabit {0},gigabits {0}
        gigabyte,GB,,GB{0},GB {0},GByte,,GB {0},GB {0},gigabytes,,gigabyte {0},gigabytes {0}
        kilobit,kb,,kb{0},kb{0},kbit,,kb {0},kb {0},kilobits,,kilobit {0},kilobits {0}
        kilobyte,kB,,kB{0},kB{0},KByte,,kB {0},kB {0},kilobytes,,kilobyte {0},kilobytes {0}
        megabit,Mb,,Mb{0},Mb{0},Mbit,,Mb {0},Mb {0},megabits,,megabit {0},megabits {0}
        megabyte,MB,,MB{0},MB{0},MByte,,MB {0},MB {0},megabytes,,megabyte {0},megabytes {0}
        petabyte,PB,,PB{0},PB{0},PByte,,PB {0},PB {0},petabytes,,petabyte {0},petabytes {0}
        terabit,Tb,,Tb{0},Tb{0},Tbit,,Tb {0},Tb {0},terabits,,terabit {0},terabits {0}
        terabyte,TB,,TB{0},TB{0},TByte,,TB {0},TB {0},terabytes,,terabyte {0},terabytes {0}
        century,ƙ,,ƙ{0},ƙ{0},ƙ,,ƙ {0},ƙ {0},ƙarnoni,,ƙarni {0},ƙarnoni {0}
        day,rana,{0}/r,r{0},r{0},ranaku,{0}/r,rana {0},Rnk. {0},ranaku,{0} a rana,rana {0},ranaku {0}
        decade,shkr gm,,sk gm{0},sk gm{0},shkr gm,,sk gm {0},sk gm {0},shekaru goma-goma,,sk gm {0},shk gm-gm {0}
        hour,saʼa,{0}/saʼa,s{0},s{0},saʼoʼi,{0}/saʼa,s {0},s {0},saʼoʼi,{0} a saʼa,sa′a {0},sa′o′i {0}
        microsecond,μsecs,,μs{0},μs{0},μsecs,,μs {0},μs {0},makirosekan,,makirosekan {0},makirosekans {0}
        millisecond,msek,,ms {0},ms {0},milseks,,ms {0},ms {0},millisakan,,millisakan {0},millisakans {0}
        minute,mnt,{0}/mnt,minti{0},minti {0},mintc,{0}/mnt,mnt {0},mnt {0},mintoci,{0} a minti,minti {0},mintoci {0}
        month,wata,{0}/w,w{0},w{0},watanni,{0}/w,wat {0},wtnn {0},wat,{0} a wata,wata {0},watanni {0}
        nanosecond,nanoseks,,ns{0},ns{0},nanoseks,,ns {0},ns {0},nanosekan,,nanosekan {0},nanosekans {0}
        night,darare,dare {0},dare {0},darare {0},darare,dare {0},dare {0},darare {0},darare,dare {0},dare {0},darare {0}
        quarter,kwt,k/{0},kwt{0},kwt{0},kwt,k/{0},kwt {0},kwtc {0},kwatoci,k/{0},kwata {0},kwatoci {0}
        second,daƙ,{0}/d,d {0},d {0},daƙ,{0}/d,d {0},d {0},daƙiƙoƙi,{0} a daƙiƙa,daƙiƙa {0},daƙiƙoƙi {0}
        week,mk,{0}/m,m{0},m{0},makonni,{0}/m,mk {0},mkn {0},makonni,{0} a mako,mako {0},makonni {0}
        year,shkr,{0}/s,shkr {0},s{0},shekaru,{0}/s,shkr {0},shkru {0},shekaru,{0} a shekara,shekara {0},shekaru {0}
        ampere,amp,,A{0},A{0},amp,,A {0},A {0},amperes,,ampere {0},amperes {0}
        milliampere,mA,,mA{0},mA{0},milliamps,,mA {0},mA {0},milliamperes,,milliamperes {0},milliamperes {0}
        ohm,ohm,,Ω{0},Ω{0},ohm,,Ω {0},Ω {0},ohms,,ohm {0},ohms {0}
        volt,volt,,V{0},V{0},volts,,V {0},V {0},volts,,volt {0},volts {0}
        british-thermal-unit,BTU,,Btu{0},Btu{0},BTU,,Btu {0},Btu {0},British thermal units,,British thermal unit {0},British thermal units {0}
        calorie,kal,,kal{0},kal{0},kal,,kal {0},kal {0},kaloris,,kalori {0},kaloris {0}
        electronvolt,eV,,eV{0},eV{0},electronvolt,,eV {0},eV {0},electronvolts,,electronvolt {0},electronvolts {0}
        foodcalorie,Kal,,Kal{0},Kal{0},Kal,,Kal {0},Kal {0},Kaloris,,Kalori {0},Kaloris {0}
        joule,joule,,J{0},J{0},joules,,J {0},J {0},joules,,joule {0},joules {0}
        kilocalorie,kcal,,kcal{0},kcal{0},kcal,,kcal {0},kcal {0},kilokaloris,,kilokalori {0},kilokaloris {0}
        kilojoule,kj,,kj{0},kj{0},kilojoule,,kj {0},kj {0},kilojoules,,kilojoule {0},kilojoules {0}
        kilowatt-hour,kWh,,kWh{0},kWh{0},kW-hour,,kWh {0},kWh {0},kilowatt-hours,,kilowatt hour {0},kilowatt-hours {0}
        therm-us,US therm,,US therm{0},US therm{0},US therm,,US therm {0},US therm {0},US therm,,US therm {0},US therms {0}
        kilowatt-hour-per-100-kilometer,kWh/100km,,kWh/100km{0},kWh/100km{0},kWh/100km,,kWh/100km {0},kWh/100km {0},kilowatt-hour per 100 kilometers,,kilowatt-hour per 100 kilometers {0},kilowatt-hours per 100 kilometers {0}
        newton,N,,N{0},N{0},newton,,N {0},N {0},newtons,,newton {0},newtons {0}
        pound-force,lbf,,lbf{0},lbf{0},pounds-force,,lbf {0},lbf {0},pounds of force,,pound of force {0},pounds of force {0}
        gigahertz,GHz,,GHz{0},GHz{0},GHz,,GHz {0},GHz {0},gigahertz,,gigahertz {0},gigahertz {0}
        hertz,Hz,,Hz{0},Hz{0},Hz,,Hz {0},Hz {0},hertz,,hertz {0},hertz {0}
        kilohertz,kHz,,kHz{0},kHz{0},kHz,,kHz {0},kHz {0},kilohertz,,kilohertz {0},kilohertz {0}
        megahertz,MHz,,MHz{0},MHz{0},MHz,,MHz {0},MHz {0},megahertz,,megahertz {0},megahertz {0}
        dot,aya,,aya{0},ayoyi{0},aya,,,,aya,,aya {0},aya {0}
        dot-per-centimeter,,,,,,,,,ayoyi a sentimita,,{0} aya a sentimita,{0} ayoyi a sentimita
        dot-per-inch,,,,,,,,,ayoyi a inci,,{0} aya a inci,{0} ayoyi a inci
        em,em,,em{0},em{0},em,,em {0},em {0},typographic ems,,em {0},{0} ems
        megapixel,megafikzels,,MP{0},MP{0},megafikzels,,MP {0},MP {0},megafikzels,,megafikzel {0},megafikzels {0}
        pixel,fikzels,,px{0},px{0},fikzels,,px {0},px {0},fikzel,,fikzel {0},fikzels {0}
        pixel-per-centimeter,ppcm,,ppcm{0},ppcm{0},,,,,fikzels a sentimita,,{0} fikzel a sentimita,{0} fikzels a sentimita
        pixel-per-inch,ppi,,ppi{0},ppi{0},ppi,,ppi {0},ppi {0},fikzel a inci,,{0} fikzel a inci,{0} fikzels a inci
        astronomical-unit,au,,au{0},au{0},au,,au {0},au {0},astronomical units,,astronomical unit {0},astronomical units {0}
        centimeter,cm,{0}/cm,cm{0},cm{0},cm,{0}/cm,cm {0},cm {0},sentimitoci,{0} a sentimita,sentimita {0},sentimitoci {0}
        decimeter,dm,,dm{0},dm{0},dm,,dm {0},dm {0},disimitoci,,disimita {0},disimitoci {0}
        earth-radius,R⊕,,R⊕{0},R⊕{0},R⊕,,R⊕ {0},R⊕ {0},earth radius,,earth radius {0},earth radius {0}
        fathom,fathom,,fth{0},fth{0},fathom,,fth {0},fth {0},fathoms,,fathom {0},fathoms {0}
        foot,ƙafafu,{0}/ƙf,ƙf{0},ƙff{0},ƙafafu,{0}/ƙf,ƙf {0},ƙff {0},ƙafafu,{0} a ƙafa,ƙafa {0},ƙafafu {0}
        furlong,furlong,,fur{0},fur{0},furlongs,,fur {0},fur {0},furlongs,,furlong {0},furlongs {0}
        inch,incina,{0}/in,{0}″,{0}″,incina,{0}/in,in {0},in {0},incina,{0} a inci,inci {0},incina {0}
        kilometer,km,{0}/km,km{0},km{0},km,{0}/km,km {0},{0} km,kilomitoci,{0} a kilomita,kilomita {0},kilomitoci {0}
        light-year,sh,,sh{0},sh{0},shkr haske,,sh {0},sh {0},shekarun haske,,shekarar haske {0},shekarun haske {0}
        meter,m,{0}/m,m{0},m{0},m,{0}/m,m {0},m {0},mitoci,{0} a mita,mita {0},mitoci {0}
        micrometer,μmeters,,μm{0},μm{0},μmeters,,μm {0},μm {0},makiromitoci,,makiromita {0},makiromitoci {0}
        mile,mil-mil,,mi{0},mil-mil{0},mil-mil,,mi {0},mi {0},mil-mil,,mil {0},mil-mil {0}
        mile-scandinavian,smi,,smi{0},smi{0},smi,,smi {0},smi {0},miles-scandinavian,,mile-scandinavian {0},miles-scandinavian {0}
        millimeter,mm,,mm{0},mm{0},mm,,mm {0},mm {0},milimitoci,,milimita {0},milimitoci {0}
        nanometer,nm,,nm{0},nm{0},nm,,nm {0},nm {0},nanomitoci,,nanomita {0},nanomitoci {0}
        nautical-mile,nmi,,nmi{0},nmi{0},nmi,,nmi {0},nmi {0},nautical miles,,nautical mile {0},nautical miles {0}
        parsec,fasek,,fasek{0},fasekoki{0},fasekoki,,pc {0},pc {0},fasekoki,,fasek {0},fasekoki {0}
        picometer,pm,,pm{0},pm{0},pm,,pm {0},pm {0},fikomitoci,,fikomita {0},fikomitoci {0}
        point,makuna,,mk{0},mk{0},makuna,,mk {0},mk {0},makuna,,maki {0},makuna {0}
        solar-radius,R☉,,R☉{0},R☉{0},solar radii,,R☉ {0},R☉ {0},solar radii,,solar radius {0},solar radii {0}
        yard,yaduka,,yd{0},ydk{0},yaduka,,yd {0},yd {0},yaduka,,yadi {0},yaduka {0}
        candela,cd,,cd{0},cd{0},cd,,cd {0},cd {0},candela,,candela {0},candela {0}
        lumen,lm,,lm{0},lm{0},,,,,lumen,,lumen {0},lumen {0}
        lux,lux,,lx{0},lx{0},lux,,lx {0},lx {0},lux,,lux {0},lux {0}
        solar-luminosity,L☉,,L☉{0},L☉{0},solar luminosities,,L☉ {0},L☉ {0},solar luminosities,,solar luminosity {0},solar luminosities {0}
        carat,carat,,CD{0},CD{0},carats,,CD {0},CD {0},carats,,carat {0},carats {0}
        dalton,Da,,Da{0},Da{0},daltons,,Da {0},daltons {0},daltons,,dalton {0},daltons {0}
        earth-mass,M⊕,,M⊕{0},M⊕{0},Earth masses,,M⊕ {0},M⊕ {0},Earth masses,,Earth mas {0},Earth masses {0}
        grain,ƙwaya,,ƙwaya{0},ƙwaya{0},ƙwaya,,ƙwaya {0},ƙwaya {0},ƙwaya,,ƙwaya {0},ƙwaya {0}
        gram,giram,{0}/g,g{0},g{0},giram,{0}/g,g {0},g {0},giram-giram,{0} a giram,giram {0},giram-giram {0}
        kilogram,kg,{0}/kg,kg{0},kg{0},kg,{0}/kg,kg {0},kg {0},kilogiramgiram,{0} a kilogiram,kilogiram {0},kilogiramgiram {0}
        microgram,μg,,μg{0},μg{0},μg,,μg {0},μg {0},makirogiramgiram,,Makirogiram {0},makirogiramgiram {0}
        milligram,mg,,mg{0},mg{0},mg,,mg {0},mg {0},milligiramgiram,,milligiram {0},milligiramgiram {0}
        ounce,oz,{0}/oz,oz{0},oz{0},oz,{0}/oz,oz {0},oz {0},oza-oza,{0} a oza,oza {0},oza-oza {0}
        ounce-troy,oz t,,oz t{0},oz t{0},ozar troy,,oz t {0},oz t {0},oza-ozar troy,,oza troy {0},oza-ozar troy {0}
        pound,laba,{0}/lb,{0}#,{0}#,laba-laba,{0}/lb,lb {0},lb {0},laba-laba,{0}/lb,Laba {0},laba-laba {0}
        solar-mass,M☉,,M☉{0},M☉{0},solar masses,,M☉ {0},M☉ {0},solar masses,,solar mas {0},solar masses {0}
        stone,stone,,st{0},st{0},stones,,st {0},st {0},stones,,stone {0},stones {0}
        ton,tan,,tn{0},tn{0},tan-tan,,tn {0},tn {0},tan-tan,,tan {0},tan-tan {0}
        tonne,t,,t{0},t{0},t,,t {0},t {0},metric tons,,metric ton {0},metric tons {0}
        gigawatt,GW,,GW{0},GW{0},GW,,GW {0},GW {0},gigawatwat,,gigawat {0},gigawatwat {0}
        horsepower,ƙi,,ƙi{0},ƙi{0},ƙi,,ƙi {0},ƙi {0},ƙarfin inji,,ƙarfin inji {0},ƙarfin inji {0}
        kilowatt,kW,,kW{0},kW{0},kW,,kW {0},kW {0},kilowatwat,,kilowat {0},kilowatwat {0}
        megawatt,MW,,MW{0},MW{0},MW,,MW {0},MW {0},megawatwat,,megawat {0},megawatwat {0}
        milliwatt,mW,,mW{0},mW{0},mW,,mW {0},mW {0},milliwatwat,,milliwat {0},milliwatwat {0}
        watt,wat,,W{0},W{0},wat-wat,,W {0},W {0},wat-wat,,wat {0},wat-wat {0}
        atmosphere,yny,,yny{0},yny{0},yny,,yny {0},yny {0},yanaye-yanaye,,Yanayi {0},yanaye-yanaye {0}
        bar,sanda,,sanda{0},sanda{0},sanda,,sanda {0},sanda {0},sanduna,,sanda {0},anduna {0}
        hectopascal,hPa,,hPa{0},hPa{0},hPa,,hPa {0},hPa {0},hectopascals,,hectopascal {0},hectopascals {0}
        inch-ofhg,″ Hg,,″ Hg{0},″ Hg{0},inHg,,inHg {0},inHg {0},incinan zaiba,,incin zaiba {0},incinan zaiba {0}
        kilopascal,kPa,,kPa{0},kPa{0},kPa,,kPa {0},kPa {0},kilopascals,,kilopascal {0},kilopascals {0}
        megapascal,MPa,,MPa{0},MPa{0},MPa,,MPa {0},MPa {0},megapascals,,megapascal {0},megapascals {0}
        millibar,mbar,,mbar{0},mbar{0},mbar,,mbar {0},mbar {0},millibars,,millibar {0},millibars {0}
        millimeter-ofhg,mmHg,,mmHg{0},mmHg{0},mm Hg,,mmHg {0},mmHg {0},millimitocin zaiba,,millimitar zaiba {0},millimitocin zaiba {0}
        pascal,Pa,,Pa{0},Pa{0},Pa,,Pa {0},Pa {0},pascals,,pascal {0},pascals {0}
        pound-force-per-square-inch,psi,,psi{0},psi{0},psi,,psi {0},psi {0},laba-laba a sikwaya inci,,laba a sikwaya inci {0},laba-laba a sikwaya inci {0}
        kilometer-per-hour,km/saʼa,,km/s{0},km/s{0},km/saʼa,,km/s {0},km/s {0},kilomitoci a saʼa,,kilomita {0} a sa′a,kilomitoci {0} a sa′a
        knot,kn,,kn{0},kn{0},kn,,kn {0},kn {0},knots,,knot {0},knots {0}
        light-speed,hsk,,hsk {0},hsk {0},hsk,,hsk {0},hsk {0},haske,,haske {0},haske {0}
        meter-per-second,m/d,,m/d{0},m/d{0},mitoci/daƙ,,m/s {0},m/s {0},mitoci a daƙiƙa,,mita a daƙiƙa {0},mitoci a daƙiƙa {0}
        mile-per-hour,mil-mil/saʼa,,mas{0},mas{0},mil-mil/saʼa,,mas {0},mas {0},mil-mil a saʼa,,mil {0} a sa′a,mil-mil {0} a sa′a
        celsius,°S,,S°{0},S°{0},dig. S,,°S{0},°S{0},digiri-digiri Selsiyas,,Digiri Selsiyas {0},digiri-digiri Selsiyas {0}
        fahrenheit,°F,,°{0},°{0},dig. F,,F°{0},F°{0},digiri-digiri faranhit,,Digiri Faranhit {0},digiri-digiri faranhit {0}
        generic,°,,°{0},°{0},°,,°{0},°{0},°,,Digirin yanayi {0},digiri-digirin yanayi {0}
        kelvin,K,,K{0},K{0},K,,K {0},K {0},kelvins,,kelvin {0},kelvins {0}
        newton-meter,N⋅m,,N⋅m{0},N⋅m{0},N⋅m,,N⋅m {0},N⋅m {0},newton-meters,,newton-meter {0},newton-meters {0}
        pound-force-foot,lbf⋅ft,,lbf⋅ft{0},lbf⋅ft{0},lbf⋅ft,,lbf⋅ft {0},lbf⋅ft {0},pound-force-feet,,Pound-force-foot {0},pound-feet {0}
        acre-foot,eka ƙf,,ek ƙf{0},ek ƙf{0},eka ƙf,,ek ƙf {0},ek ƙf {0},eka-ƙafafu,,eka-ƙafa {0},eka-ƙafafu {0}
        barrel,bbl,,gang{0},gang{0},bbl,,gang {0},gang {0},ganguna,,ganga {0},ganguna {0}
        bushel,bu,,bu {0},bu {0},bushels,,bu {0},bu {0},bushels,,bushel {0},bushels {0}
        centiliter,cL,,sL{0},sL {0},cL,,sL {0},sL {0},sentilitoci,,sentilita {0},sentilitoci {0}
        cubic-centimeter,cm³,{0}/cm³,cm³{0},cm³{0},cm³,{0}/cm³,cm³ {0},cm³ {0},kubik sentimitoci,{0} a kubik sentimita,kubik sentimita {0},kubik sentimitoci {0}
        cubic-foot,ƙafafu³,,ƙf³{0},ƙf³{0},ƙafafu³,,ƙf³ {0},ƙf³ {0},kubik ƙafafu,,kubik ƙafa {0},kubik ƙafafu {0}
        cubic-inch,incina³,,in³{0},in³{0},incina³,,in³ {0},in³ {0},kubic incina,,kubik inci {0},kubik incina {0}
        cubic-kilometer,km³,,km³{0},km³{0},km³,,km³ {0},km³ {0},kubik kilomitoci,,kubik kilomita {0},kubik kilomitoci {0}
        cubic-meter,m³,{0}/m³,m³{0},m³{0},m³,{0}/m³,m³ {0},m³ {0},kubic mitoci,{0} a kubic mita,kubic mita {0},kubic mitoci {0}
        cubic-mile,mi³,,mi³{0},mi³{0},mi³,,mi³ {0},mi³ {0},kubik mil-mil,,kubik mil {0},kubik mil-mil {0}
        cubic-yard,yaduka³,,yd³{0},yd³{0},yaduka³,,yd³ {0},yd³ {0},kubik yaduka,,kubik yadi {0},kubik yaduka {0}
        cup,kofi,,k{0},kfn{0},kofuna,,k {0},k {0},kofuna,,kofi {0},kofuna {0}
        cup-metric,mcup,,mc{0},mc{0},mcup,,mc {0},mc {0},metric cups,,metric cup {0},metric cups {0}
        deciliter,dL,,dL{0},dL{0},dL,,dL {0},dL {0},desilitoci,,desilita {0},desilitoci {0}
        dessert-spoon,dsp,,dsp{0},dsp{0},dstspn,,dstspn {0},dstspn {0},dessert spoons,,dessert spoon {0},dessert spoons {0}
        dessert-spoon-imperial,dsp lmp,,dsp-lmp{0},dsp-lmp{0},dstspn Imp,,dstspn Imp {0},dstspn Imp {0},Imp. dessert spoons,,Imp. dessert spoon {0},Imp. dessert spoons {0}
        dram,fl.dr.,,fl.dr.{0},fl.dr.{0},dram fluid,,dram fl {0},dram fl {0},drams,,dram {0},drams {0}
        drop,ɗigo,,ɗigo{0},ɗigo{0},ɗigo,,ɗigo {0},ɗigo {0},ɗigo,,ɗigo {0},ɗigo {0}
        fluid-ounce,fl oz,,fl oz{0},fl oz{0},fl oz,,fl oz {0},fl oz {0},fluid ounces,,fluid ounce {0},fluid ounces {0}
        fluid-ounce-imperial,Imp fl oz,,fl oz Im{0},fl oz Im{0},Imp. fl oz,,fl oz Imp. {0},fl oz Imp. {0},Imp. fluid ounces,,Imp. fluid ounce {0},Imp. fluid ounces {0}
        gallon,gal,{0}/gal,gal{0},gal{0},gal,{0}/gal US,gal {0},gal {0},galan-galan,{0} a galan,galan {0},galan-galan {0}
        gallon-imperial,Imp gal,{0}/galIm,galIm{0},galIm{0},Imp. gal,{0}/gal Imp.,gal Imp. {0},gal Imp.{0},Imp. gallons,{0} a Imp. gallons,Imp. gallon {0},Imp. gallons {0}
        hectoliter,hL,,hL{0},hL{0},hL,,hL {0},hL {0},hektolitoci,,hektolita {0},hektolitoci {0}
        jigger,jigger,,jigger{0},jigger{0},jigger,,jigger {0},jigger {0},jigger,,jigger {0},jigger {0}
        liter,lita,{0}/L,L{0},L{0},litoci,{0}/L,L {0},L {0},litoci,{0} a lita,lita {0},litoci {0}
        megaliter,ML,,ML{0},ML{0},ML,,ML {0},ML {0},megalitoci,,megalita {0},megalitoci {0}
        milliliter,mL,,mL{0},mL{0},mL,,mL {0},mL {0},millimitoci,,millimita {0},millimitoci {0}
        pinch,pn,,pn{0},pn{0},pinch,,pinch {0},pinch {0},pinch,,pinch {0},pinch {0}
        pint,pt,,pt{0},pt{0},pints,,pt {0},pt {0},pints,,pint {0},pints {0}
        pint-metric,mpt,,mpt{0},mpt{0},mpt,,mpt {0},mpt {0},metric pints,,metric pint {0},metric pints {0}
        quart,qt,,qt{0},qt{0},qts,,qt {0},qt {0},quarts,,quart {0},quarts {0}
        quart-imperial,qt Imp,,qt-Imp.{0},qt-Imp.{0},qt Imp,,qt Imp. {0},qt Imp. {0},Imp. quarts,,Imp. quart {0},Imp. quarts {0}
        tablespoon,bckl,,bckl{0},bckl{0},bckl,,bckl {0},bckl {0},manyan cokula,,babban cokali {0},manyan cokula {0}
        teaspoon,ƙmc,,ƙmc{0},ƙmc{0},ƙmc,,ƙmc {0},{0} tsp,ƙananan cokula,,ƙaramin cokali {0},ƙananan cokula {0}
        """.trimIndent()
  }

  private val ha_Prefixes: String by lazy {
    """square,,,sikwaya {0}
        cubic,,,kubic {0}
        per,,,{0} a {1}
        10p-1,,,deci{0}
        10p-12,,,pico{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,senti{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-3,,,milli{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hekto{0}
        10p3,,,kilo{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val ha_Arab_Units: String? = null

  private val ha_Arab_Prefixes: String? = null

  private val ha_Arab_SD_Units: String? = null

  private val ha_Arab_SD_Prefixes: String? = null

  private val ha_GH_Units: String? = null

  private val ha_GH_Prefixes: String? = null

  private val ha_NE_Units: String? = null

  private val ha_NE_Prefixes: String? = null

  private val haw_Units: String by lazy {
    """day,,,,,,,,,day,{0}/d,{0} lā,{0} lā
        hour,,,,,,,,,hr,{0}/h,{0} hola,{0} hola
        minute,,,,,,,,,min,{0}/min,{0} minuke,{0} minuke
        month,,,,,,,,,mon,{0}/m,{0} mahina,{0} mahina
        second,,,,,,,,,sec,{0}/s,{0} kekona,{0} kekona
        week,,,,,,,,,wk,{0}/w,{0} pule,{0} pule
        year,,,,,,,,,yr,{0}/y,{0} makahiki,{0} makahiki
        fahrenheit,°F,,{0}°,{0}°,,,,,,,,
        """.trimIndent()
  }

  private val haw_Prefixes: String? = null

  private val he_Units: String by lazy {
    """g-force,כוח ג׳י,,,{0} G,כוח ג׳י,,,{0} G,כוח ג׳י,,כוח ג׳י אחד,{0} כוחות ג׳י
        meter-per-square-second,,,,,,,,,מטר לשנייה בריבוע,,{0} מטר לשנייה בריבוע,{0} מטר לשנייה בריבוע
        arc-minute,דק׳ קשת,,{0} דקה,{0} דקות,דק׳ קשת,,{0} ד׳ קשת,{0} דק׳ קשת,דקות קשת,,{0} דקת קשת,{0} דקות קשת
        arc-second,שנ׳ קשת,,{0} שנ׳,{0} שנ׳,שנ׳ קשת,,{0} שנ׳ קשת,{0} שנ׳ קשת,שניות קשת,,{0} שניית קשת,{0} שניות קשת
        degree,מעלות,,,{0}°,מעלות,,,{0}°,מעלות,,מעלה אחת,{0} מעלות
        radian,רדיאנים,,{0} π,{0} π,רדיאנים,,{0} π,{0} π,רדיאנים,,רדיאן אחד,{0} רדיאנים
        revolution,ס׳,,{0} ס׳,{0} ס׳,ס׳,,{0} ס׳,{0} ס׳,סיבוב,,סיבוב {0},{0} סיבובים
        acre,אקר,,{0} אקר,{0} אקר,אקר,,{0} אקר,{0} אקר,אקר,,{0} אקר,{0} אקר
        dunam,דונם,,{0} דונם,{0} דונם,דונם,,{0} דונם,{0} דונם,דונם,,{0} דונם,{0} דונם
        hectare,הקטאר,,{0} ha,{0} ha,הקטאר,,{0} ha,{0} ha,הקטאר,,{0} הקטאר,{0} הקטאר
        square-centimeter,סמ״ר,{0}/סמ״ר,{0} סמ״ר,{0} סמ״ר,סמ״ר,{0}/סמ״ר,{0} סמ״ר,{0} סמ״ר,סנטימטר רבוע,{0} לסנטימטר רבוע,{0} סנטימטר רבוע,{0} סנטימטר רבוע
        square-foot,ft²,,{0} sq ft,{0} sq ft,ft²,,{0} sq ft,{0} sq ft,רגל רבועה,,{0} רגל רבועה,{0} רגל רבועה
        square-inch,in²,{0}/in²,{0} in²,{0} in²,in²,{0}/in²,{0} in²,{0} in²,אינץ׳ רבוע,{0} לאינץ׳ רבוע,{0} אינץ׳ רבוע,{0} אינץ׳ רבוע
        square-kilometer,קמ״ר,{0}/קמ״ר,{0} קמ״ר,{0} קמ״ר,קמ״ר,{0}/קמ״ר,{0} קמ״ר,{0} קמ״ר,קילומטר רבוע,{0} לקילומטר רבוע,{0} קילומטר רבוע,{0} קילומטר רבוע
        square-meter,מ״ר,{0}/מ״ר,{0} מ״ר,{0} מ״ר,מ״ר,{0}/מ״ר,{0} מ״ר,{0} מ״ר,מטר רבוע,{0} למטר רבוע,{0} מטר רבוע,{0} מטר רבוע
        square-mile,מייל רבוע,{0}/mi²,{0} sq mi,{0} sq mi,מייל רבוע,{0}/mi²,{0} sq mi,{0} sq mi,מייל רבוע,{0} למייל רבוע,{0} מייל רבוע,{0} מייל רבוע
        square-yard,yards²,,{0} yd²,{0} yd²,yards²,,{0} yd²,{0} yd²,יארד רבוע,,{0} יארד רבוע,{0} יארד רבוע
        item,פריט,,{0} פריט,{0} פר',פריט,,{0} פריט,{0} פריטים,פריטים,,{0} פריט,{0} פריטים
        karat,kt,,{0} kt,{0} kt,kt,,{0} kt,{0} kt,קראט,,{0} קראט,{0} קראט
        milligram-ofglucose-per-deciliter,mg/dL,,{0} mg/dL,{0} mg/dL,mg/dL,,{0} mg/dL,{0} mg/dL,מיליגרם/דציליטר,,{0} מיליגרם/דציליטר,{0} מיליגרם/דציליטר
        millimole-per-liter,,,,,,,,,מילימול/ליטר,,{0} מילימול/ליטר,{0} מילימול/ליטר
        mole,,,,,,,,,מול,,{0} מול,{0} מול
        percent,,,,,,,,,אחוז,,{0} אחוז,{0} אחוז
        permille,,,,,,,,,פרומיל,,{0} פרומיל,{0} פרומיל
        permillion,,,,,,,,,חלקים למיליון,,{0} חלקים למיליון,{0} חלקים למיליון
        permyriad,,,,,,,,,רבבית,,{0} רבבית,{0} רבביות
        portion-per-1e9,,,,,,,,,חלקים למיליארד,,{0} חלקים למיליארד,{0} חלקים למיליארד
        liter-per-100-kilometer,ל׳/100ק״מ,,{0}ל׳/100ק״מ,{0}ל׳/100ק״מ,ל׳/100 ק״מ,,{0} ל׳/100 ק״מ,{0} ל׳/100 ק״מ,ליטר/100 ק״מ,,ליטר/100 ק״מ,{0} ליטר/100 ק״מ
        liter-per-kilometer,ליטרים/ק״מ,,{0} ל׳/ק״מ,{0} ל׳/ק״מ,ליטרים/ק״מ,,{0} ל׳/ק״מ,{0} ל׳/ק״מ,ליטרים/קילומטר,,{0} ליטר/קילומטר,{0} ליטרים/קילומטר
        mile-per-gallon,מייל/גלון,,{0} mpg,{0} mpg,מייל/גלון,,{0} mpg,{0} mpg,מייל/גלון,,{0} מייל/גלון,{0} מייל/גלון
        mile-per-gallon-imperial,miles/gal Imp.,,,{0} mpg Imp.,miles/gal Imp.,,,{0} mpg Imp.,מייל/גלון אימפריאלי,,{0} מייל/גלון אימפריאלי,{0} מייל/גלון אימפריאלי
        bit,ביט,,{0} ביט,{0} ביט,ביט,,{0} ביט,{0} ביט,ביט,,{0} ביט,{0} ביט
        byte,בייט,,{0} בייט,{0} בייט,בייט,,{0} בייט,{0} בייט,בייט,,{0} בייט,{0} בייט
        gigabit,Gbit,,,{0} Gb,Gbit,,,{0} Gb,ג׳יגה-ביט,,{0} ג׳יגה-ביט,{0} ג׳יגה-ביט
        gigabyte,,,,,,,,,ג׳יגה-בייט,,{0} ג׳יגה-בייט,{0} ג׳יגה-בייט
        kilobit,,,,,,,,,קילוביט,,{0} קילוביט,{0} קילוביט
        kilobyte,,,,,,,,,קילו-בייט,,{0} קילו-בייט,{0} קילו-בייט
        megabit,Mbit,,,{0} Mb,Mbit,,,{0} Mb,מגה-ביט,,{0} מגה-ביט,{0} מגה-ביט
        megabyte,,,,,,,,,מגה-בייט,,{0} מגה-בייט,{0} מגה-בייט
        petabyte,,,,,,,,,פטה-בייט,,{0} פטה-בייט,{0} פטה-בייט
        terabit,,,,,,,,,טרה-ביט,,{0} טרה-ביט,{0} טרה-ביט
        terabyte,,,,,,,,,טרה-בייט,,{0} טרה-בייט,{0} טרה-בייט
        century,מאות,,{0} מאה,{0} מאות,מאות,,{0} מאה,{0} מאות,מאות,,{0} מאה,{0} מאות
        day,יום,{0}/יום,{0} י׳,{0} י׳,ימים,{0}/יום,{0} יום,{0} ימ׳,ימים,{0}/יום,{0} יום,{0} ימים
        decade,עשור,,{0} עשור,{0} עשורים,עשור,,{0} עשור,{0} עשורים,עשורים,,{0} עשור,{0} עשורים
        hour,שע׳,{0}/שע׳,{0} שע׳,{0} שע׳,שע׳,{0}/שעה,{0} שעה,{0} שע׳,שעות,{0} לשעה,{0} שעה,{0} שעות
        microsecond,μsecs,,,{0} μs,μsecs,,,{0} μs,מיליוניות שנייה,,{0} מיליונית שנייה,{0} מיליוניות שנייה
        millisecond,,,,,,,,,אלפיות השניה,,{0} אלפית שנייה,{0} אלפיות שנייה
        minute,דק׳,{0}/ד׳,{0} דק׳,{0} דק׳,דק׳,{0}/ד׳,{0} דק׳,{0} דק׳,דקות,{0}/דקה,{0} דקה,{0} דקות
        month,ח׳,{0}/חודש,{0} ח׳,{0} ח׳,חודשים,{0}/חודש,{0} ח׳,{0} ח׳,חודשים,{0} לחודש,{0} חודש,{0} חודשים
        nanosecond,,,,,ננו שניות,,,{0} ns,ננו שניות,,{0} ננו שנייה,{0} ננו שניות
        night,לילות,{0}/לילה,{0} לילה,{0} לילות,לילות,{0}/לילה,{0} לילה,{0} לילות,לילות,{0}/לילה,{0} לילה,{0} לילות
        quarter,רבעונים,{0}/q,,{0} q,רבעונים,{0}/q,,{0} q,רבעונים,{0}/q,{0} רבעון,{0} רבעונים
        second,שנ׳,{0}/שנ׳,{0} שנ׳,{0} שנ׳,שנ׳,{0}/שנ׳,{0} שנ׳,{0} שנ׳,שניות,{0} לשניה,{0} שניה,{0} שניות
        week,שבוע,{0}/שב׳,{0} ש′,{0} ש′,שבועות,{0}/שבוע,{0} שבוע,{0} שבועות,שבועות,{0}/שבוע,{0} שבוע,{0} שבועות
        year,ש׳,{0}/שנה,{0} ש′,{0} ש′,שנים,{0}/שנה,{0} שנה,{0} שנים,שנים,{0} לשנה,{0} שנה,{0} שנים
        ampere,amps,,,{0} A,amps,,,{0} A,אמפר,,{0} אמפר,{0} אמפר
        milliampere,,,,,,,,,מיליאמפר,,{0} מיליאמפר,{0} מיליאמפר
        ohm,ohms,,,{0} Ω,ohms,,,{0} Ω,ohms,,{0} ohm,{0} ohms
        volt,וולט,,,{0} V,וולט,,,{0} V,וולט,,{0} וולט,{0} וולט
        british-thermal-unit,BTU,,,{0} Btu,BTU,,,{0} Btu,יחידות תרמיות בריטיות,,{0} יחידה תרמית בריטית,{0} יחידות תרמיות בריטיות
        calorie,,,,,,,,,קלוריות,,{0} קלוריה,{0} קלוריות
        electronvolt,,,,,,,,,אלקטרון וולט,,{0} אלקטרון וולט,{0} אלקטרון וולט
        foodcalorie,קל׳,,{0} קלו׳,{0} קלו׳,קלו׳,,{0} קלו׳,{0} קלו׳,קלוריות,,{0} קלוריה,{0} קלוריות
        joule,ג׳אול,,,{0} J,ג׳אול,,,{0} J,ג׳אול,,{0} ג׳אול,{0} ג׳אול
        kilocalorie,,,,,,,,,קילו קלוריות,,{0} קילו קלוריה,{0} קילו קלוריות
        kilojoule,קילו ג׳אול,,,{0} kJ,קילו ג׳אול,,,{0} kJ,קילו ג׳אול,,{0} קילו ג׳אול,{0} קילו ג׳אול
        kilowatt-hour,קוט״ש,,{0} קוט״ש,{0} קוט״ש,קוט״ש,,{0} קוט״ש,{0} קוט״ש,קילוואט־שעה,,{0} קילוואט־שעה,{0} קילוואט-שעה
        therm-us,,,,,,,,,יחידה תרמית בארה״ב,,,{0} US therm
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0} kWh/100km,{0} kWh,קוט״ש/100 ק״מ,,{0} קוט״ש/100 ק״מ,{0} קוט״ש/100 ק״מ,קילוואט/שעה ל-100 קילומטר,,{0} קילוואט/שעה ל-100 קילומטר,{0} קילוואט/שעה ל-100 קילומטר
        newton,,,,,,,,,ניוטון,,{0} ניוטון,{0} ניוטון
        pound-force,,,,,,,,,ליברת-כוח,,{0} ליברת-כוח,{0} ליברות-כוח
        gigahertz,,,,,,,,,ג׳יגה-הרץ,,{0} ג׳יגה-הרץ,{0} ג׳יגה-הרץ
        hertz,,,,,,,,,הרץ,,{0} הרץ,{0} הרץ
        kilohertz,,,,,,,,,קילו-הרץ,,{0} קילו-הרץ,{0} קילו-הרץ
        megahertz,,,,,,,,,מגה-הרץ,,{0} מגה-הרץ,{0} מגה-הרץ
        dot,נקודה,,,,נקודה קטנה,,,,נקודות קטנות,,,
        dot-per-centimeter,,,,,,,,,נקודות לסנטימטר,,,
        dot-per-inch,dpi,,{0} ppi,{0} dpi,dpi,,{0} ppi,{0} dpi,dpi,,{0} ppi,{0} dpi
        em,em,,{0} em,{0} em,em,,{0} em,{0} em,קו מפריד מסוג em,,{0} em,{0} ems
        megapixel,MP,,{0} MP,{0} MP,MP,,{0} MP,{0} MP,מגה-פיקסל,,{0} MP,{0} MP
        pixel,px,,{0} px,{0} px,px,,{0} px,{0} px,פיקסלים,,{0} px,{0} px
        pixel-per-centimeter,ppcm,,{0} ppcm,{0} ppcm,ppcm,,{0} ppcm,{0} ppcm,פיקסלים לסנטימטר,,{0} ppcm,{0} ppcm
        pixel-per-inch,ppi,,{0} ppi,{0} ppi,ppi,,{0} ppi,{0} ppi,פיקסלים לאינץ׳,,{0} פיקסל לאינץ',{0} פיקסלים לאינץ'
        astronomical-unit,au,,{0} au,{0} au,au,,{0} au,{0} au,יחידות אסטרונומיות,,{0} יחידה אסטרונומית,{0} יחידות אסטרונומיות
        centimeter,ס״מ,{0}/ס״מ,{0} ס״מ,{0} ס״מ,ס״מ,{0}/ס״מ,{0} ס״מ,{0} ס״מ,סנטימטרים,{0} לסנטימטר,{0} סנטימטר,{0} סנטימטרים
        decimeter,ד״מ,,{0} ד״מ,{0} ד״מ,ד״מ,,{0} ד״מ,{0} ד״מ,דצימטר,,{0} דצימטר,{0} דצימטרים
        earth-radius,,,,,,,,,רדיוס כדור-הארץ,,{0} רדיוס כדור-הארץ,{0} רדיוס כדור-הארץ
        fathom,,,,,,,,,פתום,,{0} פתום,{0} פתום
        foot,רגל,{0} ‎/ft,{0} ft,{0} ft,רגל,{0} ‎/ft,{0} ft,{0} ft,רגל,{0} לרגל,{0} רגל,{0} רגל
        furlong,,,,,,,,,פורלונג,,{0} פורלונג,{0} פורלונג
        inch,in,{0} ‎/in,{0} in,{0} in,אינץ׳,{0} ‎/in,{0} in,{0} in,אינץ׳,{0} לאינץ׳,{0} אינץ׳,{0} אינץ׳
        kilometer,ק״מ,{0}/ק״מ,{0} ק״מ,{0} ק״מ,ק״מ,{0}/ק״מ,{0} ק״מ,{0} ק״מ,קילומטרים,{0} לקילומטר,{0} קילומטר,{0} קילומטרים
        light-year,שנות אור,,{0} שנת אור,{0} שנות אור,שנות אור,,{0} שנת אור,{0} שנות אור,שנות אור,,{0} שנת אור,{0} שנות אור
        meter,מטר,{0}/מ׳,{0} מ׳,{0} מ׳,מטרים,{0}/מ׳,{0} מ׳,{0} מ׳,מטרים,{0} למטר,{0} מטר,{0} מטרים
        micrometer,μm,,{0} μm,{0} μm,μm,,{0} μm,{0} μm,מיקרומטרים,,{0} מיקרומטר,{0} מיקרומטרים
        mile,מייל,,{0} מייל,{0} מייל,מייל,,{0} מייל,{0} מייל,מייל,,{0} מייל,{0} מייל
        mile-scandinavian,,,,,,,,,מייל-סקנדינביה,,{0} מייל-סקנדינביה,{0} מייל-סקנדינביה
        millimeter,מ״מ,,{0} מ″מ,{0} מ״מ,מ״מ,,{0} מ″מ,{0} מ״מ,מילימטרים,,{0} מילימטר,{0} מילימטרים
        nanometer,nm,,{0} nm,{0} nm,nm,,{0} nm,{0} nm,ננומטרים,,{0} ננומטר,{0} ננומטרים
        nautical-mile,מ״י,,מ״י אחד,{0} מ״י,מ״י,,מ״י אחד,{0} מ״י,מייל ימי,,{0} מייל ימי,{0} מייל ימי
        parsec,pc,,{0} pc,{0} pc,pc,,{0} pc,{0} pc,פארסק,,{0} פארסק,{0} פארסק
        picometer,פ״מ,,{0} פ“מ,{0} פ''מ,פ״מ,,{0} פ“מ,{0} פ''מ,פיקומטרים,,{0} פיקומטר,{0} פיקומטרים
        point,נק׳,,{0} נק׳,{0} נק',נקודות,,{0} נק׳,{0} נק',נקודות,,{0} נקודה,{0} נקודות
        solar-radius,R☉,,{0} R☉‎,{0} R☉‎,R☉,,{0} R☉‎,{0} R☉‎,רדיוס סולרי,,{0} רדיוס סולרי,{0} רדיוס סולרי
        yard,יארד,,{0} יארד,{0} יארד,יארד,,{0} יארד,{0} יארד,יארד,,{0} יארד,{0} יארד
        candela,,,,,,,,,קנדלה,,{0} קנדלה,{0} קנדלה
        lumen,,,,,,,,,לומן,,{0} לומן,{0} לומן
        lux,lux,,,{0} lx,lux,,,{0} lx,לוקס,,{0} לוקס,{0} לוקס
        solar-luminosity,,,,,,,,,אנרגיה סולארית ביחידת זמן,,,{0} L☉
        carat,קרט,,,{0} CD,קרט,,,{0} CD,קרט,,{0} קרט,{0} קרט
        dalton,,,,,,,,,דלטון,,{0} דלטון,{0} דלטון
        earth-mass,,,,,,,,,מסת כדור הארץ,,{0} מסת כדור הארץ,{0} מסות כדור הארץ
        grain,גרעין,,{0} גרעין,{0} גרעינים,גרעין,,{0} גרעין,{0} גרעינים,גרעין,,{0} גרעין,{0} גרעינים
        gram,גרם,{0}/גר׳,{0}g,{0}g,גרם,{0}/גר׳,{0} גר׳,{0} גר׳,גרם,{0}/גרם,{0} גרם,{0} גרם
        kilogram,ק״ג,{0}/ק״ג,{0}kg,{0}kg,ק״ג,{0}/ק״ג,{0} ק״ג,{0} ק״ג,קילוגרם,{0}/קילוגרם,{0} קילוגרם,{0} קילוגרם
        microgram,מק״ג,,{0} מק״ג,{0} מק״ג,מק״ג,,{0} מק״ג,{0} מק״ג,מיקרוגרם,,{0} מיקרוגרם,{0} מיקרוגרם
        milligram,מ״ג,,{0} מ״ג,{0} מ״ג,מ״ג,,{0} מ״ג,{0} מ״ג,מיליגרם,,{0} מיליגרם,{0} מיליגרם
        ounce,,,,,,,,,אונקיות,{0}/אונקיה,{0} אונקיה,{0} אונקיות
        ounce-troy,,,,,,,,,אונקיות טרוי,,{0} אונקיית טרוי,{0} אונקיות טרוי
        pound,lb,{0}/lb,{0} lb,{0} lbs,פאונד,{0}/lb,{0} lb,{0} lbs,פאונד,{0}/פאונד,{0} פאונד,{0} פאונד
        solar-mass,,,,,,,,,מסת השמש,,{0} מסת השמש,{0} מסות שמש
        stone,סטון,,{0} סטון,{0} סטון,סטון,,{0} סטון,{0} סטון,סטון,,{0} סטון,{0} סטון
        ton,טונה,,{0} ט׳,{0} ט׳,טונה,,{0} ט׳,{0} ט׳,טונות,,{0} טונה,{0} טונות
        tonne,טון מ׳,,{0} t,{0} t,טון מ׳,,{0} טון מ׳,{0} טון מ׳,טון מטרי,,{0} טון מטרי,{0} טון מטרי
        gigawatt,,,,,,,,,ג׳יגה ואט,,{0} ג׳יגה ואט,{0} ג׳יגה ואט
        horsepower,כ״ס,,{0} כ״ס,{0} כ״ס,כ״ס,,{0} כ״ס,{0} כ״ס,כוח סוס,,{0} כוח סוס,{0} כוח סוס
        kilowatt,,,,,,,,,קילוואט,,{0} קילוואט,{0} קילוואט
        megawatt,,,,,,,,,מגה ואט,,{0} מגה ואט,{0} מגה ואט
        milliwatt,,,,,,,,,מיליוואט,,{0} מיליוואט,{0} מיליוואט
        watt,ואט,,,{0} W,ואט,,,{0} W,ואט,,{0} ואט,{0} ואט
        atmosphere,,,,,,,,,אטמוספרות,,{0} אטמוספרה,{0} אטמוספרות
        bar,בר,,{0} בר,{0} בר,בר,,{0} בר,{0} בר,בר,,{0} בר,{0} בר
        hectopascal,,,,,,,,,הקטופסקל,,{0} הקטופסקל,{0} הקטופסקל
        inch-ofhg,in Hg,,,{0} inHg,in Hg,,,{0} inHg,אינץ׳ כספית,,{0} אינץ׳ כספית,{0} אינץ׳ כספית
        kilopascal,,,,,,,,,קילו-פסקל,,{0} קילו-פסקל,{0} קילו-פסקל
        megapascal,,,,,,,,,מגה-פסקל,,{0} מגה-פסקל,{0} מגה-פסקל
        millibar,מ״ב,,{0} מ″ב,{0} מ″ב,,,,,מיליבר,,{0} מיליבר,{0} מיליבר
        millimeter-ofhg,,,,,,,,,מילימטר כספית,,{0} מילימטר כספית,{0} מילימטר כספית
        pascal,,,,,,,,,פסקל,,{0} פסקל,{0} פסקל
        pound-force-per-square-inch,,,,,,,,,פאונד לאינץ׳ רבוע,,פאונד {0} לאינץ׳ רבוע,{0} פאונד לאינץ׳ רבוע
        beaufort,Bft,,{0} B,{0} B,,,,,בופורט,,{0} בופורט,{0} בופורט
        kilometer-per-hour,קמ״ש,,{0} קמ״ש,{0} קמ״ש,קמ״ש,,{0} קמ״ש,{0} קמ״ש,קילומטר לשעה,,{0} קילומטר לשעה,{0} קילומטר לשעה
        knot,,,,,,,,,קשר,,{0} קשר,{0} קשר
        light-speed,אור,,{0} אור,{0} אור,אור,,{0} אור,{0} אור,אור,,{0} אור,{0} אור
        meter-per-second,מ׳/שנ׳,,{0} מ׳/שנ׳,{0} מ׳/שנ׳,מ׳/שנ׳,,{0} מ׳/שנ׳,{0} מ׳/שנ׳,מטר לשנייה,,{0} מטר לשנייה,{0} מטר לשנייה
        mile-per-hour,mph,,{0} mph,{0} mph,mph,,{0} mph,{0} mph,מייל לשעה,,{0} מייל לשעה,{0} מייל לשעה
        celsius,,,,,,,,,מעלות צלזיוס,,{0} מעלת צלזיוס,{0} מעלות צלזיוס
        fahrenheit,,,,,,,,,מעלות פרנהייט,,{0} מעלת פרנהייט,{0} מעלות פרנהייט
        generic,,,,,,,,,מעלת טמפרטורה,,,{0}°
        kelvin,,,,,,,,,מעלות קלווין,,{0} קלווין,{0} קלווין
        newton-meter,,,,,,,,,ניוטון-מטר,,{0} ניוטון-מטר,{0} ניוטון-מטר
        pound-force-foot,,,,,,,,,רגל-פאונד,,{0} רגל-פאונד,{0} רגל-פאונד
        acre-foot,ac ft,,{0} ac ft,{0} ac ft,ac ft,,{0} ac ft,{0} ac ft,אקר-רגל,,{0} אקר-רגל,{0} אקר-רגל
        barrel,bbl,,{0} bbl,{0} bbl,bbl,,{0} bbl,{0} bbl,חביות,,{0} חבית,{0} חביות
        bushel,,,,,,,,,בושל,,{0} בושל,{0} בושל
        centiliter,cL,,{0} cL,{0} cL,cL,,{0} cL,{0} cL,סנטיליטר,,{0} סנטיליטר,{0} סנטיליטר
        cubic-centimeter,סמ״ק,{0}/סמ״ק,{0} סמ״ק,{0} סמ״ק,סמ״ק,{0}/סמ״ק,{0} סמ״ק,{0} סמ״ק,סנטימטר מעוקב,{0}/סנטימטר מעוקב,{0} סנטימטר מעוקב,{0} סנטימטר מעוקב
        cubic-foot,feet³,,{0} ft³,{0} ft³,feet³,,{0} ft³,{0} ft³,רגל מעוקב,,{0} רגל מעוקב,{0} רגל מעוקב
        cubic-inch,in³,,{0} in³,{0} in³,in³,,{0} in³,{0} in³,אינץ׳ מעוקב,,{0} אינץ׳ מעוקב,{0} אינץ׳ מעוקב
        cubic-kilometer,קמ״ק,,{0} קמ״ק,{0} קמ״ק,קמ״ק,,{0} קמ״ק,{0} קמ״ק,קילומטר מעוקב,,{0} קילומטר מעוקב,{0} קילומטר מעוקב
        cubic-meter,m³,{0}/m³,{0} m³,{0} m³,m³,{0}/m³,{0} m³,{0} m³,מטר מעוקב,{0}/מטר מעוקב,{0} מטר מעוקב,{0} מטר מעוקב
        cubic-mile,mi³,,{0} mi³,{0} mi³,mi³,,{0} mi³,{0} mi³,מייל מעוקב,,{0} מייל מעוקב,{0} מייל מעוקב
        cubic-yard,yd³,,{0} yd³,{0} yd³,yd³,,{0} yd³,{0} yd³,יארד מעוקב,,{0} יארד מעוקב,{0} יארד מעוקב
        cup,כוסות,,{0} כ׳,{0} כ׳,כוסות,,{0} כ׳,{0} כ׳,כוסות,,{0} כוס,{0} כוסות
        cup-metric,mcup,,{0} mc,{0} mc,mcup,,{0} mc,{0} mc,כוס מידה מטרית,,{0} כוס מידה מטרית,{0} כ׳ מידה מטרית
        deciliter,דצ״ל,,{0} דצ״ל,{0} דצ״ל,דצ״ל,,{0} דצ״ל,{0} דצ״ל,דציליטר,,{0} דציליטר,{0} דציליטר
        dessert-spoon,,,,,,,,,כפית קינוחים,,{0} כפית קינוחים,{0} כפיות קינוחים
        dessert-spoon-imperial,dstspn Imp,,{0}dsp-Imp,{0}dsp-Imp,,,,,כפית קינוחים בארה״ב,,{0} כפית קינוחים בארה״ב,{0} כפיות קינוחים בארה''ב
        dram,,,,,,,,,דראם אלכוהול,,{0} דראם אלכוהול,{0} דראם אלכוהול
        drop,טיפה,,טיפה,{0} טיפות,טיפה,,טיפה,{0} טיפות,טיפות,,טיפה,{0} טיפות
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,אונקיות נוזלים,,{0} אונקיית נוזלים,{0} אונקיות נוזלים
        fluid-ounce-imperial,Imp. fl oz,,{0} fl oz Imp.,{0} fl oz Imp.,Imp. fl oz,,{0} fl oz Imp.,{0} fl oz Imp.,אונקיית נוזלים אימפריאלית,,{0} אונקיית נוזלים אימפריאלית,{0} אונקיית נוזלים אימפריאלית
        gallon,גלון,{0}/גל׳,{0} גל׳,{0} גל׳,גלון,{0}/גל׳,{0} גל׳,{0} גל׳,גלון,{0}/גלון,{0} גלון,{0} גלונים
        gallon-imperial,גלון בריטי,{0}/galIm,{0}/galIm,{0}/galIm,גלון בריטי,{0}/גלון בריטי,{0} גלון בריטי,{0} גלון בריטי,גלון אימפריאלי,{0}/גלון אימפריאלי,{0} גלון אימפריאלי,{0} גלון אימפריאלי
        hectoliter,hL,,{0} hL,{0} hL,hL,,{0} hL,{0} hL,הקטוליטר,,{0} הקטוליטר,{0} הקטוליטר
        jigger,,,,,,,,,ג׳יגר,,{0} ג׳יגר,{0} ג'יגר
        liter,ליטר,{0}/ל׳,{0} ל׳,{0} ל׳,ליטר,{0}/ל׳,{0} ל׳,{0} ל׳,ליטר,{0}/ליטר,{0} ליטר,{0} ליטר
        megaliter,ML,,{0} ML,{0} ML,ML,,{0} ML,{0} ML,מגה ליטר,,{0} מגה ליטר,{0} מגה ליטר
        milliliter,מ״ל,,{0} מ״ל,{0} מ״ל,מ״ל,,{0} מ״ל,{0} מ״ל,מיליליטר,,{0} מיליליטר,{0} מיליליטר
        pinch,פינץ׳,,{0} פינץ',{0} פינץ',פינץ׳,,{0} פינץ',{0} פינץ',פינץ׳,,{0} פינץ׳,{0} פינץ'
        pint,פינט,,{0} pt,{0} pt,פינט,,{0} pt,{0} pt,פינט,,{0} פינט,{0} פינט
        pint-metric,mpt,,{0} mpt,{0} mpt,mpt,,{0} mpt,{0} mpt,פינט מטרי,,{0} פינט מטרי,{0} פינט מטרי
        quart,qts,,{0} qt,{0} qt,qts,,{0} qt,{0} qt,קווארטות,,{0} קווארטה,{0} קווארטות
        quart-imperial,,,,,,,,,קווארט אימפריאלי,,{0} קווארט אימפריאלי,{0} קווארטות אימפריאליות
        tablespoon,כפות,,{0} כפ׳,{0} כפ׳,כפות,,{0} כפ׳,{0} כפ׳,כפות,,{0} כפ׳,{0} כפות
        teaspoon,כפית,,{0} כפי׳,{0} כפי׳,כפית,,{0} כפי׳,{0} כפי׳,כפיות,,{0} כפית,{0} כפיות
        """.trimIndent()
  }

  private val he_Prefixes: String by lazy {
    """square,,,{0} בריבוע
        cubic,,,{0} מעוקב
        per,,,{0} ל{1}
        1024p1,,,קיבי{0}
        1024p2,,,מבי{0}
        1024p3,,,ג׳יבי{0}
        1024p4,,,טבי{0}
        1024p5,,,פבי{0}
        1024p6,,,אקסבי{0}
        1024p7,,,זבי{0}
        1024p8,,,יובא{0}
        10p-1,דצי{0},דצי{0},דצי{0}
        10p-12,פיקו{0},פיקו{0},פיקו{0}
        10p-15,פמטו{0},פמטו{0},פמטו{0}
        10p-18,אטו{0},אטו{0},אטו{0}
        10p-2,סנטי{0},סנטי{0},סנטי{0}
        10p-21,זפטו{0},זפטו{0},זפטו{0}
        10p-24,יוקטו{0},יוקטו{0},יוקטו{0}
        10p-27,רונטו{0},רונטו{0},רונטו{0}
        10p-3,מילי{0},מילי{0},מילי{0}
        10p-30,קווקטו{0},קווקטו{0},קווקטו{0}
        10p-6,,,מיקרו{0}
        10p-9,ננו{0},ננו{0},ננו{0}
        10p1,דקא{0},דקא{0},דקא{0}
        10p12,טרה{0},טרה{0},טרה{0}
        10p15,פטא{0},פטא{0},פטא{0}
        10p18,אקס{0},אקס{0},אקסה{0}
        10p2,הקטו{0},הקטו{0},הקטו{0}
        10p21,זטא{0},זטא{0},זטא{0}
        10p24,יוטא{0},יוטא{0},יוטא{0}
        10p27,רונא{0},,רונא{0}
        10p3,קילו{0},קילו{0},קילו{0}
        10p30,קווטא{0},,קווטא{0}
        10p6,מגה{0},מגה{0},מגה{0}
        10p9,גיגה{0},גיגה{0},גיגה{0}
        """.trimIndent()
  }

  private val hi_Units: String by lazy {
    """g-force,गु–बल,,{0} गु,{0} गु,गुरुत्व बल,,{0} गु॰,{0} गु॰,गुरुत्व बल,,{0} गुरुत्व–बल,{0} गुरुत्व–बल
        meter-per-square-second,मीटर/से²,,{0} मी॰/व॰से॰,{0} मी॰/व॰से॰,मीटर/से²,,{0} मी॰/व॰से॰,{0} मी॰/व॰से॰,मीटर/से²,,{0} मीटर प्रति सेकंड वर्ग,{0} मीटर प्रति सेकंड वर्ग
        arc-minute,आर्क मिनट,,{0}′,{0}′,आर्क मिनट,,{0} आर्क मिनट,{0} आर्क मिनट,आर्क मिनट,,{0} आर्क मिनट,{0} आर्क मिनट
        arc-second,आर्क सेकंड,,{0}″,{0}″,आर्क सेकंड,,{0} आर्क से॰,{0} आर्क से॰,आर्क सेकंड,,{0} आर्क सेकंड,{0} आर्क सेकंड
        degree,अंश,,{0}°,{0}°,अंश,,{0} अंश,{0} अंश,अंश,,{0} अंश,{0} अंश
        radian,rad,,{0}rad,{0}rad,रेडियन,,{0} रेडियन,{0} रेडियन,रेडियन,,{0} रेडियन,{0} रेडियन
        revolution,r,,{0}r,{0}r,घूर्णन,,{0} घूर्णन,{0} घूर्णन,घूर्णन,,{0} घूर्णन,{0} घूर्णन
        acre,एकड़,,{0} एकड़,{0} एकड़,एकड़,,{0} एकड़,{0} एकड़,एकड़,,{0} एकड़,{0} एकड़
        dunam,डोनम,,{0} डोनम,{0} डोनम,डोनम,,{0} डोनम,{0} डोनम,डोनम,,{0} डोनम,{0} डोनम
        hectare,हे,,{0} हे॰,{0} हे॰,हेक्टेयर,,{0} हे॰,{0} हे॰,हेक्टेयर,,{0} हेक्टेयर,{0} हेक्टेयर
        square-centimeter,वर्ग सेंमी,{0}/वर्ग सेंमी,{0} वर्ग सेंमी,{0} वर्ग सेंमी,वर्ग सें॰,{0}/वर्ग सें॰ मी॰,{0} व॰ सें॰,{0} व॰ सें॰,वर्ग सेंटीमीटर,{0}/वर्ग सेंटीमीटर,{0} वर्ग सेंटीमीटर,{0} वर्ग सेंटीमीटर
        square-foot,वर्ग फ़ीट,,{0} व फ़ी,{0} व फ़ी,व॰फ़ी॰,,{0} व॰फ़ी॰,{0} व॰फ़ी॰,वर्गफ़ीट,,{0} वर्गफ़ुट,{0} वर्गफ़ीट
        square-inch,वर्ग इंच,{0}/वर्ग इंच,{0} व इं,{0} व इं,व॰ इं॰,{0}/वर्ग इंच,{0} व॰ इं॰,{0} व॰ इं॰,वर्ग इंच,{0}/वर्ग इंच,{0} वर्ग इंच,{0} वर्ग इंच
        square-kilometer,वर्ग किमी,{0}/वर्ग किमी,{0} वर्ग कि॰मी॰,{0} वर्ग कि॰मी॰,वर्ग कि॰मी॰,{0}/वर्ग कि॰मी॰,{0} वर्ग कि॰मी॰,{0} वर्ग कि॰मी॰,वर्ग किलोमीटर,{0} प्रति वर्ग किलोमीटर,{0} वर्ग किलोमीटर,{0} वर्ग किलोमीटर
        square-meter,वर्ग मी,{0}/वर्ग मी,{0} वर्ग मी॰,{0} वर्ग मी॰,वर्ग मीटर,{0}/वर्ग मीटर,{0} वर्ग मी॰,{0} वर्ग मी॰,वर्ग मीटर,{0}/वर्ग मीटर,{0} वर्ग मीटर,{0} वर्ग मीटर
        square-mile,वर्ग मील,{0}/वर्ग मील,{0} वर्ग मील,{0} व मी,वर्ग मील,{0}/मील²,{0} वर्ग मील,{0} वर्ग मील,वर्ग मील,{0}/वर्ग मील,{0} वर्ग मील,{0} वर्ग मील
        square-yard,वर्ग गज़,,{0} वर्ग गज़,{0} व ग,व॰ ग॰,,{0} व॰ ग॰,{0} व॰ ग॰,वर्ग गज,,{0} वर्ग गज,{0} वर्ग गज
        item,आइटम,,{0} आइटम,{0} आइटम,आइटम,,{0} आइटम,{0} आइटम,आइटम,,{0} आइटम,{0} आइटम
        karat,कैरट,,,{0} kt,कैरट,,,{0} kt,कैरट,,{0} कैरट,{0} कैरट
        milligram-ofglucose-per-deciliter,मि॰ग्रा॰/डे॰ली॰,,{0} मि॰ग्रा॰/डे॰ली॰,{0} मि॰ग्रा॰/डे॰ली॰,मि॰ग्रा॰/डे॰ली॰,,{0} मि॰ग्रा॰/डे॰ली॰,{0} मि॰ग्रा॰/डे॰ली॰,मिलिग्राम प्रति डेसीलीटर,,{0} मिलिग्राम प्रति डेसीलीटर,{0} मिलिग्राम प्रति डेसीलीटर
        millimole-per-liter,मिलीमोल/लीटर,,{0} मिलीमोल/ली॰,{0} मिलीमोल/ली॰,मिलीमोल/लीटर,,{0} मिलीमोल/ली॰,{0} मिलीमोल/ली॰,मिलीमोल प्रति लीटर,,{0} मिलीमोल प्रति लीटर,{0} मिलीमोल प्रति लीटर
        mole,मोल,,{0} मोल,{0} मोल,मोल,,{0} मोल,{0} मोल,मोल,,{0} मोल,{0} मोल
        percent,,,,,प्रतिशत,,,{0}%,प्रतिशत,,{0} प्रतिशत,{0} प्रतिशत
        permille,प्रति हज़ार,,,{0}‰,प्रति हज़ार,,,{0}‰,प्रति हज़ार,,{0} प्रति हज़ार,{0} प्रति हज़ार
        permillion,,,,,हिस्सा प्रति दस लाख,,,{0} ppm,हिस्सा प्रति दस लाख,,{0} हिस्सा प्रति दस लाख,{0} हिस्सा प्रति दस लाख
        permyriad,,,,,,,,,प्रति दस हज़ार,,{0} प्रति दस हज़ार,{0} प्रति दस हज़ार
        portion-per-1e9,पार्ट्स/बिलियन,,,{0} ppb,पार्ट्स/बिलियन,,,{0} ppb,पार्ट्स प्रति बिलियन,,{0} पार्ट प्रति बिलियन,{0} पार्ट्स प्रति बिलियन
        liter-per-100-kilometer,ली॰/100 कि॰मी॰,,{0} ली/100 किमी,{0} ली/100 किमी,ली॰/100 कि॰मी॰,,{0} ली॰/100 कि॰मी॰,{0} ली॰/100 कि॰मी॰,लीटर प्रति 100 किलोमीटर,,{0} लीटर प्रति 100 किलोमीटर,{0} लीटर प्रति 100 किलोमीटर
        liter-per-kilometer,लीटर/किमी,,{0} ली/किमी,{0} ली/किमी,लीटर/किमी,,{0} ली/किमी,{0} ली/किमी,लीटर प्रति किलोमीटर,,{0} लीटर प्रति किलोमीटर,{0} लीटर प्रति किलोमीटर
        mile-per-gallon,मील/गैलन,,{0} mpg,{0} mpg,मील/गैलन,,{0} mpg,{0} mpg,मील प्रति गैलन,,{0} मील प्रति गैलन,{0} मील प्रति गैलन
        mile-per-gallon-imperial,mpg इंपीरियल,,{0} mpg इंपीरियल,{0} mpg इंपीरियल,mpg इंपीरियल,,{0} mpg इंपीरियल,{0} mpg इंपीरियल,मील प्रति इंपीरियल गैलन,,{0} मील प्रति इंपीरियल गैलन,{0} मील प्रति इंपीरियल गैलन
        bit,बिट,,{0} बिट,{0} बिट,बिट,,{0} बिट,{0} बिट,बिट,,{0} बिट,{0} बिट
        byte,बाइट,,{0} बाइट,{0} बाइट,बाइट,,{0} बाइट,{0} बाइट,बाइट,,{0} बाइट,{0} बाइट
        gigabit,,,,,,,,,गीगाबिट,,{0} गीगाबिट,{0} गीगाबिट
        gigabyte,,,,,,,,,गीगाबाइट,,{0} गीगाबाइट,{0} गीगाबाइट
        kilobit,,,,,,,,,किलोबिट,,{0} किलोबिट,{0} किलोबिट
        kilobyte,,,,,,,,,किलोबाइट,,{0} किलोबाइट,{0} किलोबाइट
        megabit,,,,,,,,,मेगाबिट,,{0} मेगाबिट,{0} मेगाबिट
        megabyte,,,,,,,,,मेगाबाइट,,{0} मेगाबाइट,{0} मेगाबाइट
        petabyte,,,,,पेटाबाइट,,,{0} PB,पेटाबाइट,,{0} पेटाबाइट,{0} पेटाबाइट
        terabit,,,,,,,,,टेराबिट,,{0} टेराबिट,{0} टेराबिट
        terabyte,,,,,,,,,टेराबाइट,,{0} टेराबाइट,{0} टेराबाइट
        century,श,,{0} श,{0} श,शता,,{0} शता,{0} शता,शताब्दियाँ,,{0} शताब्दी,{0} शताब्दियाँ
        day,दिन,{0}/दि,{0} दि,{0} दि,दिन,{0}/दिन,{0} दिन,{0} दिन,दिन,{0} प्रति दिन,{0} दिन,{0} दिन
        decade,दश.,,{0} दश.,{0} दश.,दश.,,{0} दश.,{0} दश.,दशकों,,{0} दशक,{0} दशकों
        hour,घंटा,{0}/घं,{0} घं,{0} घं,घंटे,{0}/घं॰,{0} घं॰,{0} घं॰,घंटे,{0} प्रति घंटा,{0} घंटा,{0} घंटे
        microsecond,,,,,माइक्रोसेकंड,,,{0} μs,माइक्रोसेकंड,,{0} माइक्रोसेकंड,{0} माइक्रोसेकंड
        millisecond,मि॰से॰,,{0} मि॰से॰,{0} मि॰से॰,मिलीसेकंड,,{0} मि॰से॰,{0} मि॰से॰,मिलीसेकंड,,{0} मिलीसेकंड,{0} मिलीसेकंड
        minute,मिनट,{0}/मि,{0} मि,{0} मि,मिनट,{0}/मिनट,{0} मि॰,{0} मि॰,मिनट,{0} प्रति मिनट,{0} मिनट,{0} मिनट
        month,माह,{0}/माह,{0} माह,{0} माह,माह,{0}/माह,{0} माह,{0} माह,महीना,{0} प्रति महीना,{0} महीना,{0} महीने
        nanosecond,ns,,{0} नैनो से,{0} नैनो से,नैनो से॰,,{0} नैनो से॰,{0} नैनो से॰,नैनो सेकंड,,{0} नैनो सेकंड,{0} नैनो सेकंड
        night,रातें,{0}/रात,{0}रात,{0}रातें,रातें,{0}/रात,{0} रात,{0} रातें,रातें,{0} प्रति रात,{0} रात,{0} रातें
        quarter,तिमा,{0}/ति,{0} तिमा,{0} तिमा,तिमा,{0}/ति,{0} तिमा,{0} तिमा,तिमाही,{0}/ति,{0} तिमाही,{0} तिमाहियां
        second,सेकंड,{0}/से,{0} से,{0} से,सेकंड,{0}/से॰,{0} से॰,{0} से॰,सेकंड,{0} प्रति सेकंड,{0} सेकंड,{0} सेकंड
        week,सप्ताह,{0}/स,{0} सप्ताह,{0} सप्ताह,सप्ताह,{0}/सप्ताह,{0} सप्ताह,{0} सप्ताह,सप्ताह,{0} प्रति सप्ताह,{0} सप्ताह,{0} सप्ताह
        year,वर्ष,{0}/व,{0} व,{0} व,वर्ष,{0}/वर्ष,{0} वर्ष,{0} वर्ष,वर्ष,{0} प्रति वर्ष,{0} वर्ष,{0} वर्ष
        ampere,एम्पी॰,,{0} ए॰,{0} ए॰,एम्पी॰,,{0} ए॰,{0} ए॰,एम्पीयर,,{0} एम्पीयर,{0} एम्पीयर
        milliampere,मि॰ ए॰,,{0} मि॰ ए॰,{0} मि॰ ए॰,मि॰ ए॰,,{0} मि॰ ए॰,{0} मि॰ ए॰,मिली एम्‍पीयर,,{0} मिली एम्‍पीयर,{0} मिली एम्‍पीयर
        ohm,ओम,,,{0} Ω,ओम,,,{0} Ω,ओम,,{0} ओम,{0} ओम
        volt,वोल्ट,,,{0} V,वोल्ट,,,{0} V,वोल्ट,,{0} वोल्ट,{0} वोल्ट
        british-thermal-unit,,,,,,,,,ब्रिटिश थर्मल यूनिट,,{0} ब्रिटिश थर्मल यूनिट,{0} ब्रिटिश थर्मल यूनिट
        calorie,cal,,{0} कै,{0} कै,,,,,कैलोरी,,{0} कैलोरी,{0} कैलोरी
        electronvolt,,,,,,,,,इलेक्ट्रॉनवोल्ट,,{0} इलेक्ट्रॉनवोल्ट,{0} इलेक्ट्रॉनवोल्ट
        foodcalorie,कैलोरी,,{0} कै,{0} कै,कैलोरी,,{0} कैलोरी,{0} कैलोरी,कैलोरी,,{0} कैलोरी,{0} कैलोरी
        joule,जूल,,{0} जू,{0} जू,जूल,,{0} जू॰,{0} जू॰,जूल,,{0} जूल,{0} जूल
        kilocalorie,,,,,,,,,किलो कैलोरी,,{0} किलो कैलोरी,{0} किलो कैलोरी
        kilojoule,किलो जूल,,{0} किजू,{0} किजू,किलो जूल,,{0} कि॰जू॰,{0} कि॰जू॰,किलो जूल,,{0} किलो जूल,{0} किलो जूल
        kilowatt-hour,,,,,,,,,किलोवॉट घंटे,,{0} किलोवॉट घंटा,{0} किलोवॉट घंटे
        therm-us,यूएस थेर्म,,{0} यूएस थेर्म,{0} यूएस थेर्म,यूएस थेर्म,,{0} यूएस थेर्म,{0} यूएस थेर्म,यूएस थेर्म,,{0} यूएस थेर्म,{0} यूएस थेर्म
        newton,न्यू॰,,{0} न्यू॰,{0} न्यू॰,न्यू॰,,{0} न्यू॰,{0} न्यू॰,न्यूटन,,{0} न्यूटन,{0} न्यूटन
        pound-force,,,,,,,,,पाउंड-बल,,{0} पाउंड-बल,{0} पाउंड-बल
        gigahertz,,,,,,,,,गीगाहर्ट्ज़,,{0} गीगाहर्ट्ज़,{0} गीगाहर्ट्ज़
        hertz,,,,,,,,,हर्ट्ज़,,{0} हर्ट्ज़,{0} हर्ट्ज़
        kilohertz,,,,,,,,,किलोहर्ट्ज़,,{0} किलोहर्ट्ज़,{0} किलोहर्ट्ज़
        megahertz,,,,,,,,,मेगाहर्ट्ज़,,{0} मेगाहर्ट्ज़,{0} मेगाहर्ट्ज़
        dot,बिंदु,,{0} बिंदु,{0} बिंदु,बिंदु,,{0} बिंदु,{0} बिंदु,बिंदु,,{0} बिंदु,{0} बिंदु
        dot-per-centimeter,dpcm,,{0} dpcm,{0} dpcm,बिं॰/सें॰मी॰,,{0} dpcm,{0} dpcm,बिंदु प्रति सेंटीमीटर,,{0} बिंदु प्रति सेंटीमीटर,{0} बिंदु प्रति सेंटीमीटर
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,बिंदु प्रति इंच,,{0} बिंदु प्रति इंच,{0} बिंदु प्रति इंच
        em,,,,,,,,,टाइपोग्राफ़िक एम,,,{0} em
        megapixel,,,,,मेगापिक्सेल,,,{0} MP,मेगापिक्सेल,,{0} मेगापिक्सेल,{0} मेगापिक्सेल
        pixel,,,,,पिक्सेल,,,{0} px,पिक्सेल,,{0} पिक्सेल,{0} पिक्सेल
        pixel-per-centimeter,,,,,,,,,पिक्सेल प्रति सेंटीमीटर,,{0} पिक्सेल प्रति सेंटीमीटर,{0} पिक्सेल प्रति सेंटीमीटर
        pixel-per-inch,,,,,,,,,पिक्सेल प्रति इंच,,{0} पिक्सेल प्रति इंच,{0} पिक्सेल प्रति इंच
        astronomical-unit,au,,{0} au,{0} au,खगो॰ इका॰,,{0} खगो॰ इका॰,{0} खगो॰ इका॰,खगोलीय इकाइयाँ,,{0} खगोलीय इकाई,{0} खगोलीय इकाईयां
        centimeter,सें॰मी॰,{0}/सेंमी,{0} सें॰मी॰,{0} सें॰मी॰,सें॰मी॰,{0}/सें॰मी॰,{0} सें॰मी॰,{0} सें॰मी॰,सेंटीमीटर,{0}/सेंटीमीटर,{0} सेंटीमीटर,{0} सेंटीमीटर
        decimeter,डेमी,,{0} डेमी,{0} डेमी,डे॰मी॰,,{0} डे॰मी॰,{0} डे॰मी॰,डेसीमीटर,,{0} डेसीमीटर,{0} डेसीमीटर
        earth-radius,,,,,,,,,पृथ्वी की त्रिज्या,,{0} पृथ्वी की त्रिज्या,{0} पृथ्वी की त्रिज्या
        fathom,फ़ैदम,,{0} फ़ै,{0} फ़ै,फ़ैदम,,{0} फ़ैदम,{0} फ़ैदम,फ़ैदम,,{0} फ़ैदम,{0} फ़ैदम
        foot,फ़ीट,{0}/फ़ीट,{0}′,{0}′,फ़ीट,{0}/फ़ीट,{0} फ़ीट,{0} फ़ीट,फ़ीट,{0}/फ़ुट,{0} फ़ुट,{0} फ़ीट
        furlong,फ़र्लांग,,{0} फ़र्लांग,{0} फ़र्लांग,फ़र्लांग,,{0} फ़र्लांग,{0} फ़र्लांग,फ़र्लांग,,{0} फ़र्लांग,{0} फ़र्लांग
        inch,इंच,{0}/इंच,{0}″,{0}″,इंच,{0}/इंच,{0} इंच,{0} इंच,इंच,{0}/इंच,{0} इंच,{0} इंच
        kilometer,किमी,{0}/किमी,{0} किमी,{0} किमी,कि॰मी॰,{0}/कि॰मी॰,{0} कि॰मी॰,{0} कि॰मी॰,किलोमीटर,{0}/किलोमीटर,{0} किलोमीटर,{0} किलोमीटर
        light-year,प्रव,,{0} प्रव,{0} प्रव,प्रकाश वर्ष,,{0} प्र॰व॰,{0} प्र॰व॰,प्रकाश वर्ष,,{0} प्रकाश वर्ष,{0} प्रकाश वर्ष
        meter,मीटर,{0}/मी,{0} मी,{0} मी,मीटर,{0}/मी,{0} मी,{0} मी,मीटर,{0}/मीटर,{0} मीटर,{0} मीटर
        micrometer,μm,,{0} μm,{0} μm,μ मा॰मी॰,,{0} μ मा॰मी॰,{0} μ मा॰मी॰,माइक्रोमीटर,,{0} माइक्रोमीटर,{0} माइक्रोमीटर
        mile,मील,,{0} मील,{0} मील,मील,,{0} मील,{0} मील,मील,,{0} मील,{0} मील
        mile-scandinavian,,,,,,,,,मील-स्कैण्डिनेवियन,,{0} मील-स्कैण्डिनेवियन,{0} मील-स्कैण्डिनेवियन
        millimeter,मि॰मी॰,,{0} मिमी,{0} मिमी,मि॰मी॰,,{0} मि॰मी॰,{0} मि॰मी॰,मिलीमीटर,,{0} मिलीमीटर,{0} मिलीमीटर
        nanometer,nm,,{0} नैमी,{0} नैमी,नै॰मी॰,,{0} नै॰मी॰,{0} नै॰मी॰,नैनोमीटर,,{0} नैनोमीटर,{0} नैनोमीटर
        nautical-mile,nmi,,{0} nmi,{0} nmi,नॉ॰ मी॰,,{0} नॉ॰ मी॰,{0} नॉ॰ मी॰,नॉटिकल मील,,{0} नॉटिकल मील,{0} नॉटिकल मील
        parsec,पार्सेक,,{0} pc,{0} pc,पार्सेक,,{0} पार्सेक,{0} पार्सेक,पार्सेक,,{0} पार्सेक,{0} पार्सेक
        picometer,pm,,{0}पि॰मी॰,{0}पि॰मी॰,पि॰मी॰,,{0} पि॰मी॰,{0} पि॰मी॰,पिकोमीटर,,{0} पिकोमीटर,{0} पिकोमीटर
        solar-radius,,,,,,,,,सौर अर्धव्यास,,{0} सौर अर्धव्यास,{0} सौर अर्धव्यास
        yard,गज़,,{0} यार्ड,{0} यार्ड,गज़,,{0} यार्ड,{0} यार्ड,यार्ड,,{0} यार्ड,{0} गज़
        candela,,,,,,,,,कैन्डेला,,{0} कैन्डेला,{0} कैन्डेला
        lumen,,,,,,,,,लुमेन,,{0} लुमेन,{0} लुमेन
        lux,लक्स,,,{0} lx,लक्स,,,{0} lx,लक्स,,{0} लक्स,{0} लक्स
        solar-luminosity,,,,,,,,,सौर ज्योति,,{0} सौर ज्योति,{0} सौर ज्योति
        carat,कै॰,,{0} कै॰,{0} कै॰,कै॰,,{0} कै॰,{0} कै॰,कैरेट,,{0} कैरेट,{0} कैरेट
        dalton,डाल्टन,,{0} डाल्टन,{0} डाल्टन,डाल्टन,,{0} डाल्टन,{0} डाल्टन,डाल्टन,,{0} डाल्टन,{0} डाल्टन
        earth-mass,,,,,,,,,पृथ्वी द्रव्यमान,,{0} पृथ्वी द्रव्यमान,{0} पृथ्वी द्रव्यमान
        grain,डे. रत्ती,,{0} डे. रत्ती,{0} डेढ़ रत्ती,डे. रत्ती,,{0} डे. रत्ती,{0} डेढ़ रत्ती,डेढ़ रत्ती,,{0} डेढ़ रत्ती,{0} डेढ़ रत्ती
        gram,ग्राम,{0}/ग्रा,{0} ग्रा,{0} ग्रा,ग्राम,{0}/ग्रा॰,{0} ग्रा॰,{0} ग्रा॰,ग्राम,{0}/ग्राम,{0} ग्राम,{0} ग्राम
        kilogram,कि॰ग्रा॰,{0}/किग्रा,{0} किग्रा,{0} किग्रा,कि॰ग्रा॰,{0}/कि॰ग्रा॰,{0} कि॰ग्रा॰,{0} कि॰ग्रा॰,किलोग्राम,{0} प्रति किलोग्राम,{0} किलोग्राम,{0} किलोग्राम
        microgram,मा॰ग्रा॰,,{0} मा॰ग्रा॰,{0} मा॰ग्रा॰,मा॰ग्रा॰,,{0} मा॰ग्रा॰,{0} मा॰ग्रा॰,माइक्रोग्राम,,{0} माइक्रोग्राम,{0} माइक्रोग्राम
        milligram,मिग्रा,,{0} मिग्रा,{0} मिग्रा,मि॰ग्रा॰,,{0} मि॰ग्रा॰,{0} मि॰ग्रा॰,मिलीग्राम,,{0} मिलीग्राम,{0} मिलीग्राम
        ounce,औंस,{0}/औंस,{0} औं॰,{0} औं॰,औंस,{0}/औंस,{0} औंस,{0} औंस,औंस,{0}/औंस,{0} औंस,{0} औंस
        ounce-troy,ट्राई औंस,,{0} ट्राई औंस,{0} ट्राई औंस,ट्राई औंस,,{0} ट्राई औंस,{0} ट्राई औंस,ट्राई औंस,,{0} ट्राई औंस,{0} ट्राई औंस
        pound,पौंड,{0}/पौंड,{0}#,{0}#,पौंड,{0}/पौंड,{0} पौंड,{0} पौंड,पौंड,{0}/पौंड,{0} पौंड,{0} पौंड
        solar-mass,,,,,,,,,सौर द्रव्यमान,,{0} सौर द्रव्यमान,{0} सौर द्रव्यमान
        stone,14 पौ. का बट्टा,,{0} ला,{0}st,14 पौ. का बट्टा,,,{0} st,14 पौंड का बट्टा,,{0} 14 पौंड का बट्टा,{0} 14 पौंड का बट्टा
        ton,टन,,{0} टन,{0} टन,टन,,{0} टन,{0} टन,टन,,{0} टन,{0} टन
        tonne,मीट्रिक टन,,{0} ट,{0} ट,मीट्रिक टन,,{0} मीट्रिक टन,{0} मी टन,मीट्रिक टन,,{0} मीट्रिक टन,{0} मीट्रिक टन
        gigawatt,,,,,,,,,गिगावॉट,,{0} गिगावॉट,{0} गिगावॉट
        horsepower,hp,,{0} एचपी,{0} एचपी,,,,,अश्वशक्ति,,{0} अश्वशक्ति,{0} अश्वशक्ति
        kilowatt,kW,,{0} किवॉ,{0} किवॉ,,,,,किलोवॉट,,{0} किलोवॉट,{0} किलोवॉट
        megawatt,,,,,,,,,मेगावॉट,,{0} मेगावॉट,{0} मेगावॉट
        milliwatt,mW,,{0} मिवॉ,{0} मिवॉ,,,,,मिलीवॉट,,{0} मिलीवॉट,{0} मिलीवॉट
        watt,वॉट,,{0} वॉ,{0} वॉ,वॉट,,,{0} W,वॉट,,{0} वॉट,{0} वॉट
        atmosphere,,,,,,,,,वायुमण्डलीय दबाव,,{0} वायुमंडलीय दबाव,{0} वायुमंडलीय दबाव
        bar,बार,,{0} बार,{0} बार,बार,,{0} बार,{0} बार,बार,,{0} बार,{0} बार
        hectopascal,hPa,,{0}hPa,{0} hPa,,,,,हेक्टोपास्कल,,{0} हेक्टोपास्कल,{0} हेक्टोपास्कल
        inch-ofhg,inHg,,{0}'' Hg,{0}'' Hg,,,,,मर्करी इंच,,{0} मर्करी इंच,{0} मर्करी इंच
        kilopascal,किपा॰,,{0} किपा॰,{0} किपा॰,किपा॰,,{0} किपा॰,{0} किपा॰,किलोपास्कल,,{0} किलोपास्कल,{0} किलोपास्कल
        megapascal,मेपा॰,,{0} मेपा॰,{0} मेपा॰,मेपा॰,,{0} मेपा॰,{0} मेपा॰,मेगापास्कल,,{0} मेगापास्कल,{0} मेगापास्कल
        millibar,mbar,,{0}mb,{0}mb,,,,,मिलीबार,,{0} मिलीबार,{0} मिलीबार
        millimeter-ofhg,,,,,,,,,मर्क्यूरी मिलीमीटर,,{0} मर्क्यूरी मिलीमीटर,{0} मर्क्यूरी मिलीमीटर
        pascal,पा॰,,{0} पा॰,{0} पा॰,पा॰,,{0} पा॰,{0} पा॰,पास्कल,,{0} पास्कल,{0} पास्कल
        pound-force-per-square-inch,,,,,,,,,पाउंड प्रति वर्ग इंच,,{0} पाउंड प्रति वर्ग इंच,{0} पाउंड प्रति वर्ग इंच
        beaufort,ब्यूफ़ोर्ट,,ब्यूफ़ोर्ट{0},ब्यूफ़ोर्ट{0},ब्यूफ़ोर्ट,,ब्यूफ़ोर्ट {0},ब्यूफ़ोर्ट {0},ब्यूफ़ोर्ट,,ब्यूफ़ोर्ट {0},ब्यूफ़ोर्ट {0}
        kilometer-per-hour,कि॰मी॰/घं॰,,{0} किमी/घं,{0} किमी/घं,कि॰मी॰/घं॰,,{0} कि॰मी॰/घं॰,{0} कि॰मी॰/घं॰,किलोमीटर प्रति घंटा,,{0} किलोमीटर प्रति घंटा,{0} किलोमीटर प्रति घंटा
        knot,नॉट,,{0} नॉट,{0} नॉट,नॉट,,{0} नॉट,{0} नॉट,नॉट,,{0} नॉट,{0} नॉट
        light-speed,लाइट,,{0} लाइट,{0} लाइट,लाइट,,{0} लाइट,{0} लाइट,लाइट,,{0} लाइट,{0} लाइट
        meter-per-second,मीटर/से॰,,{0} मी/से,{0}मी॰/से॰,मीटर/से॰,,{0} मी॰/से॰,{0} मी॰/से॰,मीटर प्रति सेकंड,,{0} मीटर प्रति सेकंड,{0} मीटर प्रति सेकंड
        mile-per-hour,मील/घंटा,,{0} मीप्रघं,{0} मीप्रघं,मील/घंटा,,{0} मी॰प्र॰घं॰,{0} मी॰प्र॰घं॰,मील प्रति घंटा,,{0} मील प्रति घंटा,{0} मील प्रति घंटा
        celsius,°से॰,,{0}°से॰,{0}°से॰,डिग्री सेल्सियस,,{0}°से॰,{0}°से॰,डिग्री सेल्सियस,,{0} डिग्री सेल्सियस,{0} डिग्री सेल्सियस
        fahrenheit,डिग्री फ़ेरनहाइट,,{0}°F,{0}°F,डिग्री फ़ेरनहाइट,,{0}°फ़ेरन,{0}°फ़ेरन,डिग्री फ़ेरनहाइट,,{0} डिग्री फ़ेरनहाइट,{0} डिग्री फ़ेरनहाइट
        generic,,,,,,,,,°,,{0}°,{0}°
        kelvin,,,,,,,,,केल्विन,,{0} केल्विन,{0} केल्विन
        newton-meter,न्यू॰मी॰,,{0} न्यू॰मी॰,{0} न्यू॰मी॰,न्यू॰मी॰,,{0} न्यू॰मी॰,{0} न्यू॰मी॰,न्यूटन-मीटर,,{0} न्यूटन-मीटर,{0} न्यूटन-मीटर
        pound-force-foot,,,,,,,,,पाउंड-फ़ुट,,{0} पाउंड-फ़ुट,{0} पाउंड-फ़ुट
        acre-foot,एकड़ फ़ीट,,{0} एकड़ फ़ीट,{0} एकड़ फ़ीट,एकड़ फ़ीट,,{0} ए॰फ़ी॰,{0} ए॰फ़ी॰,एकड़ फ़ीट,,{0} एकड़ फ़ूट,{0} एकड़ फ़ीट
        barrel,बैरल,,{0} बैरल,{0} बैरल,बैरल,,{0} बैरल,{0} बैरल,बैरल,,{0} बैरल,{0} बैरल
        bushel,बु,,{0} बु,{0} बु,बुशल,,{0} बुश॰,{0} बुश॰,बुशल,,{0} बुशल,{0} बुशल
        centiliter,सेंली,,{0} सेंली,{0} सेंली,सें॰ली॰,,{0} सें॰ली॰,{0} सें॰ली॰,सेंटीलीटर,,{0} सेंटीलीटर,{0} सेंटीलीटर
        cubic-centimeter,घन सेंमी,{0}/घन सेंमी,{0} घन सेंमी,{0} घन सेंमी,घन सें॰ मी॰,{0}/घन सें॰ मी॰,{0} घन सें॰ मी॰,{0} घन सें॰ मी॰,घन सेंटीमीटर,{0}/घन सेंटीमीटर,{0} घन सेंटीमीटर,{0} घन सेंटीमीटर
        cubic-foot,घन फ़ीट,,{0} घ॰ फ़ी॰,{0} घ॰ फ़ी॰,घ॰ फ़ी॰,,{0} घ॰ फ़ी॰,{0} घ॰ फ़ी॰,घन फ़ीट,,{0} घन फ़ीट,{0} घन फ़ीट
        cubic-inch,घन इंच,,{0} घन इंच,{0} घन इंच,घन इंच,,{0} घन इंच,{0} घन इंच,घन इंच,,{0} घन इंच,{0} घन इंच
        cubic-kilometer,घन कि॰मी॰,,{0} घन किमी,{0} घन किमी,घन कि॰मी॰,,{0} घन कि॰मी॰,{0} घन कि॰मी॰,घन किलोमीटर,,{0} घन किलोमीटर,{0} घन किलोमीटर
        cubic-meter,घन मी,{0}/घन मी,{0} घन मी,{0} घन मी,घन मी॰,{0}/घन मी॰,{0} घन मी॰,{0} घन मी॰,घन मीटर,{0}/घन मीटर,{0} घन मीटर,{0} घन मीटर
        cubic-mile,घन मील,,{0} घन मील,{0} घन मील,घन मील,,{0} घन मील,{0} घन मील,घन मील,,{0} घन मील,{0} घन मील
        cubic-yard,घन या॰,,{0} घन या॰,{0} घन या॰,घन या॰,,{0} घन या॰,{0} घन या॰,घन यार्ड,,{0} घन यार्ड,{0} घन यार्ड
        cup,कप,,{0} कप,{0} कप,कप,,{0} कप,{0} कप,कप,,{0} कप,{0} कप
        cup-metric,मीट्रिक कप,,{0} मीट्रिक कप,{0} मीट्रिक कप,मीट्रिक कप,,{0} मीट्रिक कप,{0} मीट्रिक कप,मीट्रिक कप,,{0} मीट्रिक कप,{0} मीट्रिक कप
        deciliter,डेली,,{0} डेली,{0} डेली,डे॰ली॰,,{0} डे॰ली॰,{0} डे॰ली॰,डेसीलीटर,,{0} डेसीलीटर,{0} डेसीलीटर
        dessert-spoon,dsp,,{0} dsp,{0} dsp,डे. स्पून,,{0} डे. स्पून,{0} डे. स्पून,डेज़र्ट स्पून,,{0} डेज़र्ट स्पून,{0} डेज़र्ट स्पून
        dessert-spoon-imperial,dsp Imp,,{0} dsp-Imp,{0} dsp-Imp,इम्पी. डेज़र्टस्पून,,{0} इम्पी. डेज़र्टस्पून,{0} इम्पी. डेज़र्टस्पून,इम्पीरियल डेज़र्टस्पून,,{0} इम्पीरियल डेज़र्टस्पून,{0} इम्पीरियल डेज़र्टस्पून
        dram,fl.dr.,,{0} fl.dr.,{0} fl.dr.,ड्रम फ्लूइड,,{0} ड्रम फ्लू.,{0} ड्रम फ्लू.,ड्रम फ्लूइड,,{0} ड्रम,{0} ड्रम
        drop,बूंद,,{0} बूंद,{0} बूंद,बूंद,,{0} बूंद,{0} बूंद,बूंद,,{0} बूंद,{0} बूंद
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,फ़्लूइड आउंस,,{0} फ़्लूइड आउंस,{0} फ़्लूइड आउंस,फ़्लूइड आउंस,,{0} फ़्लूइड आउंस,{0} फ़्लूइड आउंस
        fluid-ounce-imperial,Imp fl oz,,{0} fl oz Im,{0} fl oz Im,,,,,इम्पी॰ फ़्लुइड आउंस,,{0} इम्पी॰ फ़्लुइड आउंस,{0} इम्पी॰ फ़्लुइड आउंस
        gallon,गै,{0}/गै,{0} गै,{0} गै,गैलन,{0}/गैलन,{0} गैलन,{0} गैलन,गैलन,{0}/गैलन,{0} गैलन,{0} गैलन
        gallon-imperial,इम्पी गैलन,{0}/इम्पी गैलन,{0} इम्पी गैलन,{0} इम्पी गैलन,इम्पी॰ गैलन,{0}/इम्पी॰ गैलन,{0} इम्पी॰ गैलन,{0} इम्पी॰ गैलन,इम्पीरियल गैलन,{0}/इम्पीरियल गैलन,{0} इम्पीरियल गैलन,{0} इम्पीरियल गैलन
        hectoliter,है॰ली॰,,{0} हेली,{0} हेली,है॰ली॰,,{0} हे॰ली॰,{0} हे॰ली॰,हेक्टोलीटर,,{0} हेक्टोलीटर,{0} हेक्टोलीटर
        jigger,जिगर,,{0} जिगर,{0} जिगर,जिगर,,{0} जिगर,{0} जिगर,जिगर,,{0} जिगर,{0} जिगर
        liter,लीटर,{0}/ली,{0} ली,{0} ली,लीटर,{0}/ली॰,{0} ली॰,{0} ली॰,लीटर,{0}/लीटर,{0} लीटर,{0} लीटर
        megaliter,मेली,,{0} मेली,{0} मेली,मे॰ ली॰,,{0} मे॰ ली॰,{0} मे॰ ली॰,मेगालीटर,,{0} मेगालीटर,{0} मेगालीटर
        milliliter,मिली,,{0} मिली,{0} मिली,मि॰ ली॰,,{0} मि॰ ली॰,{0} मि॰ ली॰,मिलीलीटर,,{0} मिलीलीटर,{0} मिलीलीटर
        pinch,चुटकी,,{0} चुटकी,{0} चुटकी,चुटकी,,{0} चुटकी,{0} चुटकी,चुटकी,,{0} चुटकी,{0} चुटकी
        pint,पा,,{0} पा,{0} पा,पाइंट,,{0} पाइंट,{0} पाइंट,पाइंट,,{0} पाइंट,{0} पाइंट
        pint-metric,मीट्रिक पिंट,,{0} मीट्रिक पिंट,{0} मीट्रिक पिंट,मीट्रिक पिंट,,{0} मीट्रिक पिंट,{0} मीट्रिक पिंट,मीट्रिक पिंट,,{0} मीट्रिक पिंट,{0} मीट्रिक पिंट
        quart,क्वार्ट,,{0} क्वार्ट,{0} क्वार्ट,क्वार्ट,,{0} क्वार्ट,{0} क्वार्ट,क्वार्ट,,{0} क्वार्ट,{0} क्वार्ट
        quart-imperial,qt Imp,,{0} qt-Imp.,{0} qt-Imp.,क्वार्ट इम्पी.,,{0} क. इम्पी.,{0} क. इम्पी.,क्वार्ट इम्पीरियल,,{0} क्वार्ट इम्पीरियल,{0} क्वार्ट इम्पीरियल
        tablespoon,tbsp,,{0} tbsp,{0} tbsp,टे॰ स्पून,,{0} टे॰ स्पून,{0} टे॰ स्पून,टेबलस्पून,,{0} टेबलस्पून,{0} टेबलस्पून
        teaspoon,tsp,,{0} tsp,{0} tsp,टी स्पून,,{0} टी स्पून,{0} टी स्पून,टी स्पून,,{0} टी स्पून,{0} टी स्पून
        """.trimIndent()
  }

  private val hi_Prefixes: String by lazy {
    """square,,,वर्ग {0}
        cubic,,,घन {0}
        per,,,{0} प्रति {1}
        1024p1,किबी.{0},कि.बी.{0},किबी{0}
        1024p2,मेबी.{0},मे.बी.{0},मेबी{0}
        1024p3,जीबी.{0},जी.बी.{0},जीबी{0}
        1024p4,टेबी.{0},टे.बी.{0},टेबी{0}
        1024p5,पेबी.{0},पे.बी.{0},पेबी{0}
        1024p6,एक्ज़बी.{0},एक्ज़.बी.{0},एक्ज़बी{0}
        1024p7,ज़ेबी.{0},ज़े.बी.{0},ज़ेबी{0}
        1024p8,योबी.{0},यो.बी.{0},योबी{0}
        10p-1,डे {0},डे.{0},डेसी{0}
        10p-12,पि {0},पि.{0},पिको{0}
        10p-15,फ़े {0},फ़े.{0},फ़ेम्टो{0}
        10p-18,अ {0},अ.{0},अटो{0}
        10p-2,से {0},से.{0},सेंटी{0}
        10p-21,ज़े {0},ज़ेे.{0},ज़ेप्टो{0}
        10p-24,यो {0},यो.{0},योक्टो{0}
        10p-27,रो{0},रो{0},रोंटो{0}
        10p-3,मि {0},मि.{0},मिली{0}
        10p-30,क्वे{0},क्वे{0},क्वेक्टो{0}
        10p-6,,,माइक्रो{0}
        10p-9,नै {0},नै.{0},नैनो{0}
        10p1,डे {0},डेका {0},डेका{0}
        10p12,टे {0},टे.{0},टेरा{0}
        10p15,पे {0},पे.{0},पेटा{0}
        10p18,ए {0},ए.{0},एक्ज़ा{0}
        10p2,हे {0},हे.{0},हेक्टो{0}
        10p21,ज़े {0},ज़े.{0},ज़ेटा{0}
        10p24,यो {0},योटा {0},योटा{0}
        10p27,रोन{0},रोन{0},रोन्ना{0}
        10p3,कि {0},कि.{0},किलो{0}
        10p30,क्वे{0},क्वेटा{0},क्वेटा{0}
        10p6,मे {0},मे.{0},मेगा{0}
        10p9,गी {0},गी.{0},गीगा{0}
        """.trimIndent()
  }

  private val hi_Latn_Units: String by lazy {
    """percent,,,,,,,,,percent,,{0} percent,{0} percent
        mile-per-gallon-imperial,mpg,,{0}m/gUK,{0}m/gUK,miles/gal,,{0} mpg Imp.,{0} mpg Imp.,miles per Imp. gallon,,{0} mile per Imp. gallon,{0} miles per Imp. gallon
        day,,,,,days,{0}/d,{0} din,{0} din,days,{0} har din,{0} din,{0} din
        hour,,,,,,,,,hours,{0} har ghante,{0} ghanta,{0} ghante
        minute,,,,,,,,,minutes,{0} har minute,{0} minute,{0} minutes
        month,,,,,,,,,months,{0} har month,{0} month,{0} months
        second,,,,,,,,,seconds,{0} har second,{0} second,{0} seconds
        week,,,,,,,,,weeks,{0} har week,{0} week,{0} weeks
        year,,,,,,,,,years,{0} har saal,{0} saal,{0} saal
        mile-scandinavian,,,,,,,,,Scandinavian miles,,{0} Scandinavian mile,{0} Scandinavian miles
        stone,,,,,stones,,{0} st,{0} st,stones,,{0} stone,{0} stones
        ton,,,,,,,,,tons,,{0} tonne,{0} tons
        tonne,,,,,,,,,metric tonnes,,{0} metric ton,{0} tonnes
        gasoline-energy-density,,,,,,,,,gasoline equivalent,,{0} of gasoline equivalent,{0} of gasoline equivalent
        inch-ofhg,,,,,,,,,inches of mercury,,{0} inch mercury,{0} inches mercury
        millimeter-ofhg,,,,,,,,,millimetres mercury,,{0} millimetre mercury,{0} millimetres mercury
        generic,,,,,,,,,degrees temperature,,{0} degree temperature,{0} degrees temperature
        kelvin,,,,,,,,,kelvins,,{0} kelvin,{0} kelvins
        dessert-spoon,dsp,,{0}dsp,{0}dsp,dstspn,,{0} dstspn,{0} dstspn,dessert spoons,,{0} dessert spoon,{0} dessert spoons
        dessert-spoon-imperial,Imp dsp,,{0}dsp-Imp,{0}dsp-Imp,Imp dstspn,,{0} Imp dstspn,{0} Imp dstspn,Imp. dessert spoons,,{0} Imp. dessert spoon,{0} Imp. dessert spoons
        gallon-imperial,gal,{0}/gal,{0}galIm,{0}galIm,gal,{0}/gal,{0} gal,{0} gal Imp.,Imp. gallons,{0} per Imp. gallon,{0} Imp. gallon,{0} Imp. gallons
        quart-imperial,Imp qt,,{0}qt-Imp.,{0}qt-Imp.,Imp. qt,,{0} Imp. qt,{0} Imp. qt,Imp. quarts,,{0} Imp. quart,{0} Imp. quarts
        revolution,,,,,rev,,{0} rev,{0} rev,,,,
        karat,karat,,{0}kt,{0}kt,karats,,{0} ct,{0} ct,,,,
        millimole-per-liter,,,,,millimol/litre,,{0} mmol/l,{0} mmol/l,,,,
        mile-per-gallon,,,,,miles/gal US,,{0} mpg US,{0} mpg US,,,,
        dot,,,,,dots,,{0} px,{0} px,,,,
        carat,,,,,carats,,{0} CD,{0} CD,,,,
        bar,bar,,{0}bar,{0}bars,bar,,{0} bar,{0} bars,,,,
        dram,,,,,dram fluid,,{0} dram fl,{0} dram fl,,,,
        drop,,,,,drops,,{0} drop,{0} drop,,,,
        fluid-ounce-imperial,Imp fl oz,,{0}fl oz Im,{0}fl oz Im,Imp. fl oz,,{0} fl oz Imp.,{0} fl oz Imp.,,,,
        gallon,,,,,US gal,{0}/US gal,{0} gal US,{0} gal US,,,,
        pinch,,,,,pinches,,{0} pinch,{0} pinch,,,,
        byte,byte,,{0}B,{0}B,,,,,,,,
        gigabit,Gbit,,{0}Gb,{0}Gb,,,,,,,,
        gigabyte,GByte,,{0}GB,{0}GB,,,,,,,,
        kilobit,kbit,,{0}kb,{0}kb,,,,,,,,
        megabit,Mbit,,{0}Mb,{0}Mb,,,,,,,,
        megabyte,MByte,,{0}MB,{0}MB,,,,,,,,
        petabyte,PByte,,{0}PB,{0}PB,,,,,,,,
        terabit,Tbit,,{0}Tb,{0}Tb,,,,,,,,
        pound,lb,{0}/lb,{0}#,{0}#,,,,,,,,
        mile-per-hour,mi/hr,,{0}mph,{0}mph,,,,,,,,
        fluid-ounce,fl oz,,{0}fl oz,{0}fl oz,,,,,,,,
        """.trimIndent()
  }

  private val hi_Latn_Prefixes: String by lazy {
    """10p-6,μ {0},,
        """.trimIndent()
  }

  private val hnj_Units: String? = null

  private val hnj_Prefixes: String? = null

  private val hnj_Hmnp_Units: String? = null

  private val hnj_Hmnp_Prefixes: String? = null

  private val hr_Units: String by lazy {
    """g-force,G,,,{0} G,G,,,{0} G,G,,,{0} G
        meter-per-square-second,,,,,,,,,metri u sekundi na kvadrat,,{0} metar u sekundi na kvadrat,{0} metara u sekundi na kvadrat
        arc-minute,kutna minuta,,{0}′,{0}′,min,,{0} min,{0} min,kutne minute,,{0} kutna minuta,{0} kutnih minuta
        arc-second,s,,{0} s,{0} s,s,,{0} s,{0} s,kutne sekunde,,{0} kutna sekunda,{0} kutnih sekundi
        degree,°,,,{0}°,°,,,{0}°,stupnjevi,,{0} stupanj,{0} stupnjeva
        radian,,,,,,,,,radijani,,{0} radijan,{0} radijana
        revolution,okr.,,{0} okr.,{0} okr.,okr.,,{0} okr.,{0} okr.,okretaj,,{0} okretaj,{0} okretaja
        acre,kj,,{0} kj,{0} kj,kj,,{0} kj,{0} kj,katastarska jutra,,{0} katastarsko jutro,{0} katastarskih jutara
        dunam,dunam,,{0} dunam,{0} dunama,dunami,,{0} dunam,{0} dunama,dunami,,{0} dunam,{0} dunama
        hectare,ha,,,{0} ha,ha,,,{0} ha,hektari,,{0} hektar,{0} hektara
        square-centimeter,,,,,,,,,kvadratni centimetri,{0}/cm²,{0} kvadratni centimetar,{0} kvadratnih centimetara
        square-foot,,,,,,,,,kvadratne stope,,{0} kvadratna stopa,{0} kvadratnih stopa
        square-inch,,,,,,,,,kvadratni inči,{0}/in²,{0} kvadratni inč,{0} kvadratnih inča
        square-kilometer,,,,,,,,,kvadratni kilometri,{0} po kvadratnom kilometru,{0} kvadratni kilometar,{0} kvadratnih kilometara
        square-meter,,,,,,,,,kvadratni metri,{0}/m²,{0} kvadratni metar,{0} kvadratnih metara
        square-mile,,,,,,,,,kvadratne milje,{0} po kvadratnoj milji,{0} kvadratna milja,{0} kvadratnih milja
        square-yard,,,,,,,,,kvadratni jardi,,{0} kvadratni jard,{0} kvadratnih jardi
        item,stavka,,{0} stavka,{0} stavki,stavka,,{0} stavka,{0} stavki,stavke,,{0} stavka,{0} stavki
        karat,,,,,,,,,karati,,{0} karat,{0} karata
        milligram-ofglucose-per-deciliter,mg/dl,,{0} mg/dl,{0} mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,miligrami po decilitru,,{0} miligram po decilitru,{0} miligrama po decilitru
        millimole-per-liter,mmol/l,,{0} mmol/l,{0} mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,milimoli po litri,,{0} milimol po litri,{0} milimola po litri
        mole,mol,,{0} mol,{0} mola,mol,,{0} mola,{0} mola,moli,,{0} mola,{0} mola
        percent,%,,{0} %,{0} %,%,,{0} %,{0} %,postotak,,{0} posto,{0} posto
        permille,‰,,{0} ‰,{0} ‰,‰,,{0} ‰,{0} ‰,promil,,{0} promil,{0} promila
        permillion,,,,,,,,,dijelovi na milijun,,{0} dio na milijun,{0} dijelova na milijun
        permyriad,‱,,{0} ‱,{0} ‱,‱,,{0} ‱,{0} ‱,permyriad,,{0} permyriad,{0} permyriada
        portion-per-1e9,dijelovi/milijarda,,,{0} ppb,dijelovi/milijarda,,,{0} ppb,dijelovi na milijardu,,{0} dio na milijardu,{0} dijelova na milijardu
        liter-per-100-kilometer,l/100 km,,{0}l/100km,{0}l/100km,l/100 km,,{0} l/100 km,{0} l/100 km,litre na 100 kilometara,,{0} litra na 100 kilometara,{0} litara na 100 kilometara
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,litre po kilometru,,{0} litra po kilometru,{0} litara po kilometru
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg,milje po galonu,,{0} milja po galonu,{0} milja po galonu
        mile-per-gallon-imperial,milje/imp. gal.,,{0} mpg imp.,{0} mpg imp.,milje/imp. gal.,,{0} mpg imp.,{0} mpg imp.,milje po imp. galonu,,{0} milja po imp. galonu,{0} milja po imp. galonu
        bit,bit,,{0} bit,{0} bitova,bit,,{0} bit,{0} bitova,bitovi,,{0} bit,{0} bitova
        byte,bajt,,{0} bajt,{0} bajtova,bajt,,{0} bajt,{0} bajtova,bajtovi,,{0} bajt,{0} bajtova
        gigabit,,,,,,,,,gigabiti,,{0} gigabit,{0} gigabita
        gigabyte,,,,,,,,,gigabajti,,{0} gigabajt,{0} gigabajta
        kilobit,,,,,,,,,kilobiti,,{0} kilobit,{0} kilobita
        kilobyte,,,,,,,,,kilobajti,,{0} kilobajt,{0} kilobajta
        megabit,,,,,,,,,megabiti,,{0} megabit,{0} megabita
        megabyte,,,,,,,,,megabajti,,{0} megabajt,{0} megabajta
        petabyte,,,,,,,,,petabajti,,{0} petabajt,{0} petabajta
        terabit,,,,,,,,,terabiti,,{0} terabit,{0} terabita
        terabyte,,,,,,,,,terabajti,,{0} terabajt,{0} terabajta
        century,st.,,{0} st.,{0} st.,st.,,{0} st.,{0} st.,stoljeća,,{0} stoljeće,{0} stoljeća
        day,d.,{0}/d.,{0} d.,{0} d.,dani,{0}/d.,{0} dan,{0} dana,dani,{0} dnevno,{0} dan,{0} dana
        decade,des.,,{0} des.,{0} des.,des.,,{0} des.,{0} des.,desetljeća,,{0} desetljeće,{0} desetljeća
        hour,h,{0}/h,,{0} h,h,{0}/h,,{0} h,sati,{0}/h,{0} sat,{0} sati
        microsecond,,,,,,,,,mikrosekunde,,{0} mikrosekunda,{0} mikrosekundi
        millisecond,,,,,,,,,milisekunde,,{0} milisekunda,{0} milisekundi
        minute,min,{0}/min,{0} m,{0} m,,,,,minute,{0}/min,{0} minuta,{0} minuta
        month,mj.,{0}/mj.,{0} mj.,{0} mj.,mj.,{0}/mj.,{0} mj.,{0} mj.,mjeseci,{0} mjesečno,{0} mjesec,{0} mjeseci
        nanosecond,,,,,,,,,nanosekunde,,{0} nanosekunda,{0} nanosekundi
        night,noć,{0}/noć,{0} noć,{0} noći,noć,{0}/noć,{0} noć,{0} noći,noći,{0}/noć,{0} noć,{0} noći
        quarter,čet.,{0}/čet.,{0} čet.,{0} čet.,čet.,{0}/čet.,{0} čet.,{0} čet.,četvrtine,{0}/čet.,{0} četvrtina,{0} četvrtina
        second,s,{0}/s,,{0} s,s,{0}/s,,{0} s,sekunde,{0}/s,{0} sekunda,{0} sekundi
        week,tj.,{0}/tj.,{0} tj.,{0} tj.,tj.,{0}/tj.,{0} tj.,{0} tj.,tjedni,{0} tjedno,{0} tjedan,{0} tjedana
        year,g.,{0}/g.,{0} g.,{0} g.,g.,{0}/g.,{0} g.,{0} g.,godine,{0} godišnje,{0} godina,{0} godina
        ampere,A,,,{0} A,A,,,{0} A,amperi,,{0} amper,{0} ampera
        milliampere,,,,,,,,,miliamperi,,{0} miliamper,{0} miliampera
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,omi,,{0} om,{0} oma
        volt,V,,,{0} V,V,,,{0} V,volti,,{0} volt,{0} volti
        british-thermal-unit,BTU,,{0} BTU,{0} BTU,BTU,,{0} BTU,{0} BTU,britanske termalne jedinice,,{0} britanska termalna jedinica,{0} britanskih termalnih jedinica
        calorie,,,,,,,,,kalorije,,{0} kalorija,{0} kalorija
        electronvolt,,,,,,,,,elektronvolti,,{0} elektronvolt,{0} elektronvolta
        foodcalorie,,,,,,,,,kilokalorije,,{0} kilokalorija,{0} kilokalorija
        joule,J,,,{0} J,J,,,{0} J,džuli,,{0} džul,{0} džula
        kilocalorie,,,,,,,,,kilokalorije,,{0} kilokalorija,{0} kilokalorija
        kilojoule,,,,,,,,,kilodžuli,,{0} kilodžul,{0} kilodžula
        kilowatt-hour,,,,,,,,,kilovatsati,,{0} kilovatsat,{0} kilovatsati
        therm-us,SAD therm,,{0} SAD therm,{0} SAD therma,SAD therm,,{0} SAD therm,{0} SAD therma,SAD therm,,{0} SAD therm,{0} SAD therma
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0} kWh/100 km,{0} kWh/100 km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kilovatsat na 100 kilometara,,{0} kilovatsat na 100 kilometara,{0} kilovatsati na 100 kilometara
        newton,,,,,,,,,njutni,,{0} njutn,{0} njutna
        pound-force,,,,,,,,,funte sile,,{0} funta sile,{0} funti sile
        gigahertz,,,,,,,,,gigaherci,,{0} gigaherc,{0} gigaherca
        hertz,,,,,,,,,herci,,{0} herc,{0} herca
        kilohertz,,,,,,,,,kiloherci,,{0} kiloherc,{0} kiloherca
        megahertz,,,,,,,,,megaherci,,{0} megaherc,{0} megaherca
        dot,piksel,,{0} p,{0} p,pikseli,,{0} p,{0} p,točke,,{0} točka,{0} točaka
        dot-per-centimeter,dpcm,,{0} dpcm,{0} dpcm,dpcm,,{0} dpcm,{0} dpcm,točke po centimetru,,{0} točka po centimetru,{0} točaka po centimetru
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,točke po inču,,{0} točka po inču,{0} točaka po inču
        em,em,,{0} em,{0} emova,em,,{0} em,{0} emova,tipografski em,,{0} tipografski em,{0} tipografskih ema
        megapixel,,,,,,,,,megapikseli,,{0} megapiksel,{0} megapiksela
        pixel,,,,,,,,,pikseli,,{0} piksel,{0} piksela
        pixel-per-centimeter,,,,,,,,,pikseli po centimetru,,{0} piksel po centimetru,{0} piksela po centimetru
        pixel-per-inch,,,,,,,,,pikseli po inču,,{0} piksel po inču,{0} piksela po inču
        astronomical-unit,,,,,,,,,astronomske jedinice,,{0} astronomska jedinica,{0} astronomskih jedinica
        centimeter,,,,,,,,,centimetri,{0}/cm,{0} centimetar,{0} centimetara
        decimeter,,,,,,,,,decimetri,,{0} decimetar,{0} decimetara
        earth-radius,,,,,,,,,srednji polumjer Zemlje,,{0} srednji polumjer Zemlje,{0} srednjih polumjera Zemlje
        fathom,hv,,{0} hv,{0} hv,hv,,{0} hv,{0} hv,hvati,,{0} hvat,{0} hvati
        foot,ft,{0}/ft,{0}′,{0}′,stope,{0}/ft,,{0} ft,stope,{0}/ft,{0} stopa,{0} stopa
        furlong,,,,,furlonzi,,,{0} fur,furlonzi,,{0} furlong,{0} furlonga
        inch,in,{0}/in,{0}″,{0}″,inči,{0}/in,,{0} in,inči,{0}/in,{0} inč,{0} inča
        kilometer,,,,,,,,,kilometri,{0}/km,{0} kilometar,{0} kilometara
        light-year,,,,,svjetlosne g.,,,{0} ly,svjetlosne godine,,{0} svjetlosna godina,{0} svjetlosnih godina
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,metri,{0}/m,{0} metar,{0} metara
        micrometer,,,,,,,,,mikrometri,,{0} mikrometar,{0} mikrometara
        mile,,,,,,,,,milje,,{0} milja,{0} milja
        mile-scandinavian,,,,,,,,,skandinavska milja,,{0} skandinavska milja,{0} skandinavskih milja
        millimeter,,,,,,,,,milimetri,,{0} milimetar,{0} milimetara
        nanometer,,,,,,,,,nanometri,,{0} nanometar,{0} nanometara
        nautical-mile,,,,,,,,,nautičke milje,,{0} nautička milja,{0} nautičkih milja
        parsec,,,,,,,,,parseci,,{0} parsek,{0} parseka
        picometer,,,,,,,,,pikometri,,{0} pikometar,{0} pikometara
        point,,,,,tipografske točke,,,{0} pt,tipografske točke,,{0} tipografska točka,{0} tipografskih točaka
        solar-radius,,,,,,,,,Sunčevi polumjeri,,{0} Sunčev polumjer,{0} Sunčevih polumjera
        yard,,,,,jardi,,,{0} yd,jardi,,{0} jard,{0} jardi
        candela,,,,,,,,,kandela,,{0} kandela,{0} kandela
        lumen,,,,,,,,,lumen,,{0} lumen,{0} lumena
        lux,,,,,,,,,luksi,,{0} luks,{0} luksa
        solar-luminosity,,,,,,,,,sjaj Sunca,,{0} sjaj Sunca,{0} sjaja Sunca
        carat,ct,,{0} ct,{0} ct,ct,,{0} ct,{0} ct,karati,,{0} karat,{0} karata
        dalton,,,,,daltoni,,,{0} Da,daltoni,,{0} dalton,{0} daltona
        earth-mass,,,,,,,,,Zemljine mase,,{0} Zemljina masa,{0} Zemljinih masa
        grain,gr,,{0} gr,{0} gr,gr,,{0} gr,{0} gr,grainovi,,{0} grain,{0} graina
        gram,g,{0}/g,,{0} g,g,{0}/g,,{0} g,grami,{0}/g,{0} gram,{0} grama
        kilogram,,,,,,,,,kilogrami,{0}/kg,{0} kilogram,{0} kilograma
        microgram,,,,,,,,,mikrogrami,,{0} mikrogram,{0} mikrograma
        milligram,,,,,,,,,miligrami,,{0} miligram,{0} miligrama
        ounce,,,,,,,,,unce,{0}/oz,{0} unca,{0} unci
        ounce-troy,,,,,,,,,troy unce,,{0} troy unca,{0} troy unci
        pound,,,,,,,,,funte,{0}/lb,{0} funta,{0} funti
        solar-mass,,,,,,,,,Sunčeve mase,,{0} Sunčeva masa,{0} Sunčevih masa
        stone,,,,,,,,,kameni,,{0} kamen,{0} kamena
        ton,,,,,,,,,kratke tone,,{0} kratka tona,{0} kratkih tona
        tonne,,,,,,,,,tone,,{0} tona,{0} tona
        gigawatt,,,,,,,,,gigavati,,{0} gigavat,{0} gigavata
        horsepower,KS,,{0} KS,{0} KS,KS,,{0} KS,{0} KS,konjske snage,,{0} konjska snaga,{0} konjskih snaga
        kilowatt,,,,,,,,,kilovati,,{0} kilovat,{0} kilovata
        megawatt,,,,,,,,,megavati,,{0} megavat,{0} megavata
        milliwatt,,,,,,,,,milivati,,{0} milivat,{0} milivata
        watt,W,,,{0} W,W,,,{0} W,vati,,{0} vat,{0} vati
        atmosphere,,,,,,,,,atmosfere,,{0} atmosfera,{0} atmosfera
        bar,bar,,{0} bar,{0} bara,bar,,{0} bar,{0} bara,bari,,{0} bar,{0} bara
        hectopascal,,,,,,,,,hektopaskali,,{0} hektopaskal,{0} hektopaskala
        inch-ofhg,,,,,,,,,inči žive,,{0} inč žive,{0} inča žive
        kilopascal,,,,,,,,,kilopaskali,,{0} kilopaskal,{0} kilopaskala
        megapascal,,,,,,,,,megapaskali,,{0} megapaskal,{0} megapaskala
        millibar,mbar,,{0} mb,{0} mb,,,,,milibari,,{0} milibar,{0} milibara
        millimeter-ofhg,,,,,,,,,milimetri živina stupca,,{0} milimetar živina stupca,{0} milimetara živina stupca
        pascal,,,,,,,,,paskali,,{0} paskal,{0} paskala
        pound-force-per-square-inch,,,,,,,,,funte po kvadratnom inču,,{0} funta po kvadratnom inču,{0} funti po kvadratnom inču
        beaufort,,,,,,,,,Beaufortova ljestvica,,,B {0}
        kilometer-per-hour,,,,,,,,,kilometri na sat,,{0} kilometar na sat,{0} kilometara na sat
        knot,čv,,{0} čv,{0} čv,čv,,{0} čv,{0} čv,čvor,,{0} čvor,{0} čvorova
        light-speed,svjetlo,,{0} svjetlo,{0} svjetala,svjetlo,,{0} svjetlo,{0} svjetala,svjetlo,,{0} svjetlo,{0} svjetala
        meter-per-second,,,,,,,,,metri u sekundi,,{0} metar u sekundi,{0} metara u sekundi
        mile-per-hour,,,,,,,,,milje na sat,,{0} milja na sat,{0} milja na sat
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,Celzijevi stupnjevi,,{0} Celzijev stupanj,{0} Celzijevih stupnjeva
        fahrenheit,°F,,{0} °F,{0} °F,°F,,{0} °F,{0} °F,Fahrenheitovi stupnjevi,,{0} Fahrenheitov stupanj,{0} Fahrenheitovih stupnjeva
        generic,,,,,,,,,stupnjevi,,,{0}°
        kelvin,,,,,,,,,kelvini,,{0} kelvin,{0} kelvina
        newton-meter,Nm,,{0} Nm,{0} Nm,Nm,,{0} Nm,{0} Nm,njutnmetri,,{0} njutnmetar,{0} njutnmetara
        pound-force-foot,,,,,,,,,funte sile po stopi,,{0} funta sile po stopi,{0} funti sile po stopi
        acre-foot,,,,,,,,,aker-stope,,{0} aker-stopa,{0} aker-stopi
        barrel,,,,,,,,,bareli,,{0} barel,{0} barela
        bushel,,,,,,,,,bušeli,,{0} bušel,{0} bušela
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,centilitri,,{0} centilitar,{0} centilitara
        cubic-centimeter,,,,,,,,,kubni centimetri,{0}/cm³,{0} kubni centimetar,{0} kubnih centimetara
        cubic-foot,,,,,,,,,kubne stope,,{0} kubna stopa,{0} kubnih stopa
        cubic-inch,,,,,,,,,kubni inči,,{0} kubni inč,{0} kubnih inča
        cubic-kilometer,,,,,,,,,kubni kilometri,,{0} kubni kilometar,{0} kubnih kilometara
        cubic-meter,,,,,,,,,kubni metri,{0}/m³,{0} kubni metar,{0} kubnih metara
        cubic-mile,,,,,,,,,kubne milje,,{0} kubna milja,{0} kubnih milja
        cubic-yard,,,,,,,,,kubni jardi,,{0} kubni jard,{0} kubnih jardi
        cup,šalica,,,{0} c,šalice,,,{0} c,šalice,,{0} šalica,{0} šalica
        cup-metric,m. šalica,,,{0} mc,m. šalica,,,{0} mc,metričke šalice,,{0} metrička šalica,{0} metričkih šalica
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,decilitri,,{0} decilitar,{0} decilitara
        dessert-spoon,žličica,,{0} žličica,{0} žličica,des. žličica,,{0} des. žličica,{0} des. žličica,desertna žličica,,{0} desertna žličica,{0} desertnih žličica
        dessert-spoon-imperial,imp. žličica,,{0} i. žličica,{0} i. žličica,imp. žličica,,{0} imp. žličica,{0} imp. žličica,imperijalna desertna žličica,,{0} imperijalna desertna žličica,{0} imperijalnih desertnih žličica
        dram,fl dr,,{0} fl dr,{0} fl dr,fl dr,,{0} fl dr,{0} fl dr,dram tekućine,,{0} dram tekućine,{0} drama tekućine
        drop,kap,,{0} kap,{0} kapi,kap,,{0} kap,{0} kapi,kap,,{0} kap,{0} kapi
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,tekuće unce,,{0} tekuća unca,{0} tekućih unci
        fluid-ounce-imperial,imp. fl oz,,{0} i. fl oz,{0} i. fl oz,imp. fl oz,,{0} imp. fl oz,{0} imp. fl oz,imp. tekuće unce,,{0} imp. tekuća unca,{0} imp. tekućih unci
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,galoni,{0}/gal,{0} galon,{0} galona
        gallon-imperial,imp. gal.,{0}/imp. gal.,{0} i. gal.,{0} i. gal.,imp. gal.,{0}/imp. gal.,{0} imp. gal.,{0} imp. gal.,imp. galoni,{0} po imp. galonu,{0} imp. galon,{0} imp. galona
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hektolitri,,{0} hektolitar,{0} hektolitara
        jigger,jigger,,{0} jigger,{0} jiggera,jigger,,{0} jiggera,{0} jiggera,jiggeri,,{0} jiggera,{0} jiggera
        liter,l,{0}/l,,{0} l,l,{0}/l,,{0} l,litre,{0}/l,{0} litra,{0} litara
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megalitri,,{0} megalitar,{0} megalitara
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,mililitri,,{0} mililitar,{0} mililitara
        pinch,prstohvat,,{0} prstohvat,{0} prstohvata,prstohvat,,{0} prstohvat,{0} prstohvata,prstohvat,,{0} prstohvat,{0} prstohvata
        pint,,,,,,,,,pinte,,{0} pinta,{0} pinti
        pint-metric,,,,,,,,,metričke pinte,,{0} metrička pinta,{0} metričkih pinti
        quart,,,,,,,,,četvrtine,,{0} četvrtina,{0} četvrtina
        quart-imperial,,,,,,,,,imperijalna četvrtina,,{0} imperijalna četvrtina,{0} imperijalne četvrtine
        tablespoon,,,,,,,,,žlice,,{0} žlica,{0} žlica
        teaspoon,,,,,,,,,žličice,,{0} žličica,{0} žličica
        """.trimIndent()
  }

  private val hr_Prefixes: String by lazy {
    """square,,,četvornih {0}
        cubic,,,kubnih {0}
        times,,,{0}-{1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,eksbi{0}
        1024p7,,,zebi{0}
        1024p8,,,jobi{0}
        10p-1,,,deci{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,ato{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,jokto{0}
        10p-27,,,ronto{0}
        10p-3,,,mili{0}
        10p-30,,,kvekto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,eksa{0}
        10p2,,,hekto{0}
        10p21,,,zeta{0}
        10p24,,,jota{0}
        10p27,,,rona{0}
        10p3,,,kilo{0}
        10p30,,,kveta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val hr_BA_Units: String? = null

  private val hr_BA_Prefixes: String? = null

  private val hsb_Units: String by lazy {
    """g-force,G,,,{0} G,G,,,{0} G,jednotki zemskeho pospěšenja,,{0} jednotka zemskeho pospěšenja,{0} jednotkow zemskeho pospěšenja
        meter-per-square-second,,,,,,,,,metry na kwadratnu sekundu,,{0} meter na kwadratnu sekundu,{0} metrow na kwadratnu sekundu
        arc-minute,′,,{0}′,{0}′,′,,{0} ′,{0} ′,minuty,,{0} minuta,{0} minutow
        arc-second,″,,{0}″,{0}″,″,,{0} ″,{0} ″,sekundy,,{0} sekunda,{0} sekundow
        degree,°,,{0}°,{0}°,°,,{0} °,{0} °,stopnje,,{0} stopjeń,{0} stopnjow
        radian,,,,,,,,,radianty,,{0} radiant,{0} radiantow
        revolution,wobr.,,{0} wobr.,{0} wobr.,wobr.,,{0} wobr.,{0} wobr.,wobroty,,{0} wobrot,{0} wobrotow
        acre,ac,,,{0} ac,ac,,,{0} ac,acry,,{0} acre,{0} acrow
        dunam,dun.,,{0} dun.,{0} dun.,dun.,,{0} dun.,{0} dun.,dunamy,,{0} dunam,{0} dunamow
        hectare,ha,,,{0} ha,ha,,,{0} ha,hektary,,{0} hektar,{0} hektarow
        square-centimeter,,,,,,,,,kwadratne centimetry,{0} na kwadratny centimeter,{0} kwadratny centimeter,{0} kwadratnych centimetrow
        square-foot,,,,,,,,,kwadratne stopy,,{0} kwadratna stopa,{0} kwadratnych stopow
        square-inch,,,,,,,,,kwadratne cóle,{0} na kwadratny cól,{0} kwadratny cól,{0} kwadratnych cólow
        square-kilometer,,,,,,,,,kwadratne kilometry,{0} na kwadratny kilometer,{0} kwadratny kilometer,{0} kwadratnych kilometrow
        square-meter,,,,,,,,,kwadratne metry,{0} na kwadratny meter,{0} kwadratny meter,{0} kwadratnych metrow
        square-mile,,,,,,,,,kwadratne mile,{0} na kwadratnu milu,{0} kwadratna mila,{0} kwadratnych milow
        square-yard,,,,,,,,,kwadratne yardy,,{0} kwadratny yard,{0} kwadratnych yardow
        item,kus,,{0} kus,{0} kusow,kus,,{0} kus,{0} kusow,kuski,,{0} kusk,{0} kuskow
        karat,,,,,,,,,karaty,,{0} karat,{0} karatow
        milligram-ofglucose-per-deciliter,mg/dl,,{0} mg/dl,{0} mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,miligramy na deciliter,,{0} miligram na deciliter,{0} miligramow na deciliter
        millimole-per-liter,mmol/l,,{0} mmol/l,{0} mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,milimole na liter,,{0} milimol na liter,{0} milimolow na liter
        mole,,,,,,,,,mole,,{0} mol,{0} molow
        percent,%,,{0} %,{0} %,%,,{0} %,{0} %,procenty,,{0} procent,{0} procentow
        permille,‰,,{0} ‰,{0} ‰,‰,,{0} ‰,{0} ‰,promile,,{0} promil,{0} promilow
        permillion,,,,,,,,,milionćiny,,{0} milionćina,{0} milionćinow
        permyriad,‱,,{0} ‱,{0} ‱,‱,,{0} ‱,{0} ‱,dźesaćiny promila,,{0} dźesaćina promila,{0} dźesaćinow promila
        portion-per-1e9,n,,{0} n,{0} n,nano,,{0} nano,{0} nano,miliardćina,,{0} miliardćina,{0} miliardćinow
        liter-per-100-kilometer,l/100km,,{0} l/100km,{0} l/100km,l/100km,,{0} l/100km,{0} l/100km,litry na 100 kilometrow,,{0} liter na 100 kilometrow,{0} litrow na 100 kilometrow
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,litry na kilometer,,{0} liter na kilometer,{0} litrow na kilometer
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg,mile na galonu,,{0} mila na galonu,{0} milow na galonu
        mile-per-gallon-imperial,mpg br.,,{0} mpg br.,{0} mpg br.,mpg brit.,,{0} mpg brit.,{0} mpg brit.,mile na britisku galonu,,{0} mila na britisku galonu,{0} milow na britisku galonu
        bit,,,,,,,,,bity,,{0} bit,{0} bitow
        byte,,,,,,,,,bytey,,{0} byte,{0} byteow
        gigabit,,,,,,,,,gigabity,,{0} gigabit,{0} gigabitow
        gigabyte,,,,,,,,,gigabytey,,{0} gigabyte,{0} gigabyteow
        kilobit,,,,,,,,,kilobity,,{0} kilobit,{0} kilobitow
        kilobyte,,,,,,,,,kilobytey,,{0} kilobyte,{0} kilobyteow
        megabit,,,,,,,,,megabity,,{0} megabit,{0} megabitow
        megabyte,,,,,,,,,megabytey,,{0} megabyte,{0} megabyteow
        petabyte,,,,,,,,,petabytey,,{0} petabyte,{0} petabyteow
        terabit,,,,,,,,,terabity,,{0} terabit,{0} terabitow
        terabyte,,,,,,,,,terabytey,,{0} terabyte,{0} terabyteow
        century,lětst.,,{0} lětst.,{0} lětst.,lětst.,,{0} lětst.,{0} lětst.,lětstotki,,{0} lětstotk,{0} lětstotkow
        day,d,{0}/dź.,{0} d,{0} d,dny,{0}/dź.,{0} dź.,{0} dn.,dny,{0} wob dźeń,{0} dźeń,{0} dnjow
        decade,lětdź.,,{0} lětdź.,{0} lětdź.,lětdź.,,{0} lětdź.,{0} lětdź.,lětdźesatki,,{0} lětdźesatk,{0} lětdźesatkow
        hour,h,{0}/h,{0} h,{0} h,hodź.,{0}/h,{0} hodź.,{0} hodź.,hodźiny,{0} na hodźinu,{0} hodźina,{0} hodźinow
        microsecond,,,,,,,,,mikrosekundy,,{0} mikrosekunda,{0} mikrosekundow
        millisecond,,,,,,,,,milisekundy,,{0} milisekunda,{0} milisekundow
        minute,min,{0}/min.,{0} min,{0} min,min.,{0}/min.,{0} min.,{0} min.,minuty,{0} za minutu,{0} minuta,{0} minutow
        month,měs.,{0}/měs.,{0} měs.,{0} měs.,měs.,{0}/měs.,{0} měs.,{0} měs.,měsacy,{0} wob měsac,{0} měsac,{0} měsacow
        nanosecond,,,,,,,,,nanosekundy,,{0} nanosekunda,{0} nanosekundow
        night,nocy,{0} na nóc,{0} nóc,{0} nocow,nocy,{0} na nóc,{0} nóc,{0} nocow,přenocowanja,{0} na přenocowanje,{0} přenocowanje,{0} přenocowanjow
        quarter,kw.,{0}/kw.,{0} kw.,{0} kw.,kwart.,{0}/kwart.,{0} kwart.,{0} kwart.,kwartale,{0}/kwartal,{0} kwartal,{0} kwartalow
        second,s,{0}/s,{0} s,{0} s,sek.,{0}/s,{0} sek.,{0} sek.,sekundy,{0} na sekundu,{0} sekunda,{0} sekundow
        week,t.,{0}/tydź.,{0} t.,{0} t.,tydź.,{0}/tydź.,{0} tydź.,{0} tydź.,tydźenje,{0} wob tydźeń,{0} tydźeń,{0} tydźenjow
        year,l.,{0}/l.,{0} l.,{0} l.,l.,{0}/l.,{0} l.,{0} l.,lěta,{0} wob lěto,{0} lěto,{0} lět
        ampere,A,,,{0} A,A,,,{0} A,ampery,,{0} ampere,{0} amperow
        milliampere,,,,,,,,,milliampery,,{0} milliampere,{0} milliamperow
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,ohmy,,{0} ohm,{0} ohmow
        volt,V,,,{0} V,V,,,{0} V,volty,,{0} volt,{0} voltow
        british-thermal-unit,,,,,,,,,britiske jednotki ćopłoty,,{0} britiska jednotka ćopłoty,{0} britiskich jednotkow ćopłoty
        calorie,,,,,,,,,kalorije,,{0} kalorija,{0} kalorijow
        electronvolt,,,,,,,,,elektronvolty,,{0} elektronvolt,{0} elektronvoltow
        foodcalorie,,,,,,,,,kilokalorije,,{0} kilokalorija,{0} kilokalorijow
        joule,J,,,{0} J,J,,,{0} J,joule,,{0} joule,{0} jouleow
        kilocalorie,,,,,,,,,kilokalorije,,{0} kilokalorija,{0} kilokalorijow
        kilojoule,,,,,,,,,kilojoule,,{0} kilojoule,{0} kilojouleow
        kilowatt-hour,,,,,,,,,kilowattowe hodźiny,,{0} kilowattowa hodźina,{0} kilowattowych hodźin
        therm-us,US therm,,{0} US therm,{0} US therms,US therm,,{0} US therm,{0} US therms,ameriske jednotki ćopłoty,,{0} ameriska jednotka ćopłoty,{0} ameriskich jednotkow ćopłoty
        kilowatt-hour-per-100-kilometer,,,,,,,,,kilowattowe hodźiny na 100 kilometrow,,{0} kilowattowa hodźina na 100 kilometrow,{0} kilowattowych hodźinow na 100 kilometrow
        newton,,,,,,,,,newtony,,{0} newton,{0} newtonow
        pound-force,,,,,,,,,punty mocy,,{0} punt mocy,{0} puntow mocy
        gigahertz,,,,,,,,,gigahertzy,,{0} gigahertz,{0} gigahertzow
        hertz,,,,,,,,,hertzy,,{0} hertz,{0} hertzow
        kilohertz,,,,,,,,,kilohertzy,,{0} kilohertz,{0} kilohertzow
        megahertz,,,,,,,,,megahertzy,,{0} megahertz,{0} megahertzow
        em,,,,,,,,,typografiski em,,{0} typografiski em,{0} typografiskich em
        megapixel,,,,,,,,,megapiksele,,{0} megapiksel,{0} megapikselow
        pixel,,,,,,,,,piksele,,{0} piksel,{0} pikselow
        pixel-per-centimeter,,,,,,,,,piksele na centimeter,,{0} piksel na centimeter,{0} pikselow na centimeter
        pixel-per-inch,,,,,,,,,piksele na cól,,{0} piksel na cól,{0} pikselow na cól
        astronomical-unit,,,,,,,,,astronomiske jednotki,,{0} astronomiska jednotka,{0} astronomiskich jednotkow
        centimeter,,,,,,,,,centimetry,{0} na centimeter,{0} centimeter,{0} centimetrow
        decimeter,,,,,,,,,decimetry,,{0} decimeter,{0} decimetrow
        earth-radius,,,,,,,,,radius zemje,,{0} radius zemje,{0} radiusow zemje
        fathom,fth,,,{0} fth,fth,,,{0} fth,sahi,,{0} saha,{0} sahow
        foot,,,,,,,,,stopy,{0} na stopu,{0} stopa,{0} stopow
        furlong,,,,,,,,,furlongi,,{0} furlong,{0} furlongow
        inch,in,{0}/cól,,{0} in,in,{0}/cól,,{0} in,cóle,{0} na cól,{0} cól,{0} cólow
        kilometer,,,,,,,,,kilometry,{0} na kilometer,{0} kilometer,{0} kilometrow
        light-year,,,,,,,,,swětłolěta,,{0} swětłolěto,{0} swětłolět
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,metry,{0} na meter,{0} meter,{0} metrow
        micrometer,,,,,,,,,mikrometry,,{0} mikrometer,{0} mikrometrow
        mile,,,,,,,,,mile,,{0} mila,{0} milow
        mile-scandinavian,,,,,,,,,skandinawiske mile,,{0} skandinawiska mila,{0} skandinawiskich milow
        millimeter,,,,,,,,,milimetry,,{0} milimeter,{0} milimetrow
        nanometer,,,,,,,,,nanometry,,{0} nanometer,{0} nanometrow
        nautical-mile,,,,,,,,,nawtiske mile,,{0} nawtiska mila,{0} nawtiskich milow
        parsec,,,,,,,,,parsec,,{0} parsec,{0} parsec
        picometer,,,,,,,,,pikometry,,{0} pikometer,{0} pikometrow
        point,,,,,,,,,dypki,,{0} dypk,{0} dypkow
        solar-radius,,,,,,,,,radiusy słónca,,{0} radius słónca,{0} radiusow słónca
        yard,,,,,,,,,yardy,,{0} yard,{0} yardow
        candela,,,,,,,,,kandele,,{0} kandela,{0} kandelow
        lumen,,,,,,,,,lumeny,,{0} lumen,{0} lumenow
        lux,,,,,,,,,lux,,{0} lux,{0} lux
        solar-luminosity,,,,,,,,,swěćenske mocy słónca,,{0} swěćenska móc słónca,{0} swěćenskich mocow słónca
        carat,Kt,,{0} Kt,{0} Kt,Kt,,{0} Kt,{0} Kt,karaty,,{0} karat,{0} karatow
        dalton,,,,,,,,,daltony,,{0} dalton,{0} daltonow
        earth-mass,,,,,,,,,masy zemje,,{0} masa zemje,{0} masow zemje
        grain,grain,,{0} grain,{0} grainow,grain,,{0} grain,{0} grainow,grain,,{0} grain,{0} grainow
        gram,g,{0}/g,,{0} g,g,{0}/g,,{0} g,gramy,{0} na gram,{0} gram,{0} gramow
        kilogram,,,,,,,,,kilogramy,{0} na kilogram,{0} kilogram,{0} kilogramow
        microgram,,,,,,,,,mikrogramy,,{0} mikrogram,{0} mikrogramow
        milligram,,,,,,,,,miligramy,,{0} miligram,{0} miligramow
        ounce,,,,,,,,,uncy,{0} na uncu,{0} unca,{0} uncow
        ounce-troy,oz. tr.,,{0} oz. tr.,{0} oz. tr.,oz. tr.,,{0} oz. tr.,{0} oz. tr.,troyske uncy,,{0} troyska unca,{0} troyskich uncow
        pound,,,,,,,,,punty,{0} na punt,{0} punt,{0} puntow
        solar-mass,,,,,,,,,masy słónca,,{0} masa słónca,{0} masow słónca
        stone,,,,,,,,,kamjenje,,{0} kamjeń,{0} kamjenjow
        ton,am.tony,,,{0} tn,am.tony,,,{0} tn,ameriske tony,,{0} ameriska tona,{0} ameriskich tonow
        tonne,,,,,,,,,tony,,{0} tona,{0} tonow
        gigawatt,,,,,,,,,gigawatty,,{0} gigawatt,{0} gigawattow
        horsepower,PS,,{0} PS,{0} PS,PS,,{0} PS,{0} PS,konjace mocy,,{0} konjaca móc,{0} konjacych mocow
        kilowatt,,,,,,,,,kilowatty,,{0} kilowatt,{0} kilowattow
        megawatt,,,,,,,,,megawatty,,{0} megawatt,{0} megawattow
        milliwatt,,,,,,,,,miliwatty,,{0} miliwatt,{0} miliwattow
        watt,W,,,{0} W,W,,,{0} W,watty,,{0} watt,{0} wattow
        atmosphere,,,,,,,,,atmosfery,,{0} atmosfera,{0} atmosferow
        bar,,,,,,,,,bary,,{0} bar,{0} barow
        hectopascal,,,,,,,,,hektopascale,,{0} hektopascal,{0} hektopascalow
        inch-ofhg,,,,,,,,,cóle žiwoslěbroweho stołpika,,{0} cól žiwoslěbroweho stołpika,{0} cólow žiwoslěbroweho stołpika
        kilopascal,,,,,,,,,kilopascale,,{0} kilopascal,{0} kilopascalow
        megapascal,,,,,,,,,megapascale,,{0} megapascal,{0} megapascalow
        millibar,,,,,,,,,milibary,,{0} milibar,{0} milibarow
        millimeter-ofhg,,,,,,,,,milimetry žiwoslěbroweho stołpika,,{0} milimeter žiwoslěbroweho stołpika,{0} milimetrow žiwoslěbroweho stołpika
        pascal,,,,,,,,,pascale,,{0} pascal,{0} pascalow
        pound-force-per-square-inch,,,,,,,,,punty na kwadratny cól,,{0} punt na kwadratny cól,{0} puntow na kwadratny cól
        beaufort,Bft,,{0} Bft,{0} Bft,Bft,,{0} Bft,{0} Bft,beaufort,,{0} stopjeń beauforta,{0} stopnjow beauforta
        kilometer-per-hour,,,,,,,,,kilometry na hodźinu,,{0} kilometer na hodźinu,{0} kilometrow na hodźinu
        knot,sk,,{0} sk,{0} sk,sk,,{0} sk,{0} sk,suki,,{0} suk,{0} sukow
        light-speed,c,,{0} c,{0} c,sw. spěšnosć,,{0} sw. spěšnosć,{0} sw. spěšnosćow,swětłowa spěšnosć,,{0} swětłowa spěšnosć,{0} swětłowych spěšnosćow
        meter-per-second,,,,,,,,,metry na sekundu,,{0} meter na sekundu,{0} metrow na sekundu
        mile-per-hour,mph,,{0} mph,{0} mph,mph,,{0} mph,{0} mph,mile na hodźinu,,{0} mila na hodźinu,{0} milow na hodźinu
        celsius,,,,,,,,,stopnje Celsiusa,,{0} stopjeń Celsiusa,{0} stopnjow Celsiusa
        fahrenheit,,,,,,,,,stopnje Fahrenheita,,{0} stopjeń Fahrenheita,{0} stopnjow Fahrenheita
        generic,,,,,,,,,°,,{0} stopjeń,{0} stopjenjow
        kelvin,,,,,,,,,stopnje Kelvina,,{0} stopjeń Kelvina,{0} stopnjow Kelvina
        newton-meter,Nm,,{0} Nm,{0} Nm,Nm,,{0} Nm,{0} Nm,newtonmetry,,{0} newtonmeter,{0} newtonmetrow
        pound-force-foot,,,,,,,,,librostopy,,{0} librostopa,{0} librostopow
        acre-foot,,,,,,,,,acre-stopy,,{0} acre-stopa,{0} acre-stopow
        barrel,,,,,,,,,barele,,{0} barel,{0} barelow
        bushel,,,,,,,,,bušle,,{0} bušl,{0} bušlow
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,centilitry,,{0} centiliter,{0} centilitrow
        cubic-centimeter,,,,,,,,,kubikne centimetry,{0} na kubikny centimeter,{0} kubikny centimeter,{0} kubiknych centimetrow
        cubic-foot,,,,,,,,,kubikne stopy,,{0} kubikna stopa,{0} kubiknych stopow
        cubic-inch,,,,,,,,,kubikne cóle,,{0} kubikny cól,{0} kubiknych cólow
        cubic-kilometer,,,,,,,,,kubikne kilometry,,{0} kubikny kilometer,{0} kubiknych kilometrow
        cubic-meter,,,,,,,,,kubikne metry,{0} na kubikny meter,{0} kubikny meter,{0} kubiknych metrow
        cubic-mile,,,,,,,,,kubikne mile,,{0} kubikna mila,{0} kubiknych milow
        cubic-yard,,,,,,,,,kubikne yardy,,{0} kubikny yard,{0} kubiknych yardow
        cup,š.,,{0} š.,{0} š.,š.,,{0} š.,{0} š.,šalki,,{0} šalka,{0} šalkow
        cup-metric,mc,,,{0} mc,mc,,,{0} mc,metriske šalki,,{0} metriska šalka,{0} metriskich šalkow
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,decilitry,,{0} deciliter,{0} decilitrow
        dessert-spoon,dess. łžk.,,{0} dess. łžk.,{0} dess. łžk.,dess. łžk.,,{0} dess. łžk.,{0} dess. łžk.,dessertowe łžički,,{0} dessertowa łžička,{0} dessertowych łžičkow
        dessert-spoon-imperial,im. łk.,,{0} im. łk.,{0} im. łk.,imp. łžk.,,{0} imp. łžk.,{0} imp. łžk.,britiske łžički,,{0} britiska łžička,{0} britiskich łžičkow
        dram,dr,,{0} dr,{0} dr,dr,,{0} dr,{0} dr,dramy,,{0} dram,{0} dramow
        drop,kpk.,,{0} kpk.,{0} kpk.,kpk.,,{0} kpk.,{0} kpk.,kapki,,{0} kapka,{0} kapkow
        fluid-ounce,fl. oz.,,{0} fl. oz.,{0} fl. oz.,fl. oz.,,{0} fl. oz.,{0} fl. oz.,běžite uncy,,{0} běžita unca,{0} běžitych uncow
        fluid-ounce-imperial,br. fl oz,,{0} br. fl oz,{0} br. fl oz,brit. fl oz,,{0} brit. fl oz,{0} brit. fl oz,britiske běžite uncy,,{0} britiska běžita unca,{0} britiskich běžitych uncow
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,galony,{0} na galonu,{0} galona,{0} galonow
        gallon-imperial,br. gal.,{0}/br. gal.,{0} br. gal.,{0} br. gal.,brit. gal.,{0}/brit. gal.,{0} brit. gal.,{0} brit. gal.,britiske galony,{0} na britisku galonu,{0} britiska galona,{0} britiskich galonow
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hektolitry,,{0} hektoliter,{0} hektolitrow
        jigger,jigg.,,{0} jigg.,{0} jigg.,jiggery,,{0} jigger,{0} jiggerow,jiggery,,{0} jigger,{0} jiggerow
        liter,l,{0}/l,,{0} l,l,{0}/l,,{0} l,litry,{0} na liter,{0} liter,{0} litrow
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megalitry,,{0} megaliter,{0} megalitrow
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,mililitry,,{0} mililiter,{0} mililitrow
        pinch,šć,,{0} šć,{0} šć,šćipki,,{0} šćipka,{0} šćipkow,šćipki,,{0} šćipka,{0} šćipkow
        pint,,,,,,,,,pinty,,{0} pint,{0} pintow
        pint-metric,,,,,,,,,metriske pinty,,{0} metriski pint,{0} metriskich pintow
        quart,,,,,,,,,quarty,,{0} quart,{0} quartow
        quart-imperial,,,,,,,,,britiske běrtle,,{0} britiski běrtl,{0} britiskich běrtlow
        tablespoon,łž.,,{0} łž.,{0} łž.,łž.,,{0} łž.,{0} łž.,łžicy,,{0} łžica,{0} łžicow
        teaspoon,łžk.,,{0} łžk.,{0} łžk.,łžk.,,{0} łžk.,{0} łžk.,łžički,,{0} łžička,{0} łžičkow
        """.trimIndent()
  }

  private val hsb_Prefixes: String by lazy {
    """square,,,kwadratnych {0}
        cubic,,,kubiknych {0}
        times,,,{0}-{1}
        per,,,{0} na {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobi{0}
        10p-1,,,deci{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yokto{0}
        10p-27,,,ronto{0}
        10p-3,,,mili{0}
        10p-30,,,quecto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,eksa{0}
        10p2,,,hekto{0}
        10p21,,,zeta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val hu_Units: String by lazy {
    """g-force,g gyorsulás,,,{0} G,g gyorsulás,,,{0} G,g gyorsulás,,{0} g gyorsulás,{0} g gyorsulás
        meter-per-square-second,,,,,,,,,méter per másodpercnégyzet,,{0} méter per másodpercnégyzet,{0} méter per másodpercnégyzet
        arc-minute,ívperc,,,{0}′,ívperc,,,{0}′,ívperc,,{0} ívperc,{0} ívperc
        arc-second,ívmásodperc,,,{0}″,ívmásodperc,,,{0}″,ívmásodperc,,{0} ívmásodperc,{0} ívmásodperc
        degree,fok,,{0}°,{0}°,fok,,{0} fok,{0} fok,fok,,{0} fok,{0} fok
        radian,,,,,,,,,radián,,{0} radián,{0} radián
        revolution,ford.,,{0} ford.,{0} ford.,ford.,,{0} ford.,{0} ford.,fordulat,,{0} fordulat,{0} fordulat
        acre,kh,,{0} ac,{0} ac,kh,,{0} kh,{0} kh,hold,,{0} hold,{0} hold
        hectare,ha,,,{0} ha,ha,,,{0} ha,hektár,,{0} hektár,{0} hektár
        square-centimeter,,,,,,,,,négyzetcentiméter,{0}/négyzetcentiméter,{0} négyzetcentiméter,{0} négyzetcentiméter
        square-foot,,,,,,,,,négyzetláb,,{0} négyzetláb,{0} négyzetláb
        square-inch,,,,,,,,,négyzethüvelyk,{0}/négyzethüvelyk,{0} négyzethüvelyk,{0} négyzethüvelyk
        square-kilometer,,,,,,,,,négyzetkilométer,{0}/km²,{0} négyzetkilométer,{0} négyzetkilométer
        square-meter,,,,,,,,,négyzetméter,{0}/négyzetméter,{0} négyzetméter,{0} négyzetméter
        square-mile,,,,,,,,,négyzetmérföld,{0}/négyzetmérföld,{0} négyzetmérföld,{0} négyzetmérföld
        square-yard,,,,,,,,,négyzetyard,,{0} négyzetyard,{0} négyzetyard
        item,,,,,,,,,item,,{0} item,{0} item
        karat,,,,,,,,,karát,,{0} karát,{0} karát
        milligram-ofglucose-per-deciliter,mg/dl,,{0} mg/dl,{0} mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligramm/deciliter,,{0} milligramm/deciliter,{0} milligramm/deciliter
        millimole-per-liter,mmol/l,,{0} mmol/l,{0} mmol/l,millimól/liter,,{0} mmol/l,{0} mmol/l,millimól/liter,,{0} millimól/liter,{0} millimól/liter
        mole,,,,,,,,,mól,,{0} mól,{0} mól
        percent,,,,,százalék,,,{0}%,százalék,,{0} százalék,{0} százalék
        permille,,,,,ezrelék,,,{0}‰,ezrelék,,{0} ezrelék,{0} ezrelék
        permillion,,,,,részecske/millió,,,{0} ppm,részecske/millió,,{0} részecske/millió,{0} részecske/millió
        permyriad,,,,,,,,,tízezrelék,,{0} tízezrelék,{0} tízezrelék
        liter-per-100-kilometer,l/100 km,,{0} l/100 km,{0} l/100 km,l/100 km,,{0} l/100 km,{0} l/100km,liter/100 km,,{0} liter/100 km,{0} liter/100 km
        liter-per-kilometer,l/km,,{0} l/km,{0} l/km,l/km,,{0} l/km,{0} l/km,liter per kilométer,,{0} liter per kilométer,{0} liter per kilométer
        mile-per-gallon,mpg,,{0} mpg,{0} mpg,mpg,,{0} mpg,{0} mpg,mérföld per gallon,,{0} mérföld per gallon,{0} mérföld per gallon
        mile-per-gallon-imperial,mérföld/bir. gallon,,{0} mpg bir.,{0} mpg bir.,mérföld/bir. gallon,,{0} mpg bir.,{0} mpg bir.,mérföld/birodalmi gallon,,{0} mérföld/birodalmi gallon,{0} mérföld/birodalmi gallon
        bit,,,,,,,,,bit,,{0} bit,{0} bit
        byte,B,,{0} B,{0} B,bájt,,{0} bájt,{0} bájt,bájt,,{0} bájt,{0} bájt
        gigabit,,,,,,,,,gigabit,,{0} gigabit,{0} gigabit
        gigabyte,,,,,,,,,gigabájt,,{0} gigabájt,{0} gigabájt
        kilobit,,,,,,,,,kilobit,,{0} kilobit,{0} kilobit
        kilobyte,,,,,,,,,kilobájt,,{0} kilobájt,{0} kilobájt
        megabit,,,,,,,,,megabit,,{0} megabit,{0} megabit
        megabyte,,,,,,,,,megabájt,,{0} megabájt,{0} megabájt
        petabyte,,,,,,,,,petabájt,,{0} petabájt,{0} petabájt
        terabit,,,,,,,,,terabit,,{0} terabit,{0} terabit
        terabyte,,,,,,,,,terabájt,,{0} terabájt,{0} terabájt
        century,sz.,,{0} sz.,{0} sz.,sz.,,{0} sz.,{0} sz.,évszázad,,{0} évszázad,{0} évszázad
        day,nap,{0}/nap,{0} nap,{0} nap,nap,{0}/nap,{0} nap,{0} nap,nap,{0}/nap,{0} nap,{0} nap
        decade,dek,,{0} dek,{0} dek,dek,,{0} dek,{0} dek,évtized,,{0} évtized,{0} évtized
        hour,ó,{0}/ó,{0} ó,{0} ó,ó,{0}/ó,{0} ó,{0} ó,óra,{0}/óra,{0} óra,{0} óra
        microsecond,,,,,,,,,mikroszekundum,,{0} mikroszekundum,{0} mikroszekundum
        millisecond,,,,,,,,,ezredmásodperc,,{0} ezredmásodperc,{0} ezredmásodperc
        minute,p,{0}/p,{0} p,{0} p,p,{0}/p,{0} p,{0} p,perc,{0}/perc,{0} perc,{0} perc
        month,hónap,{0}/hó,{0} h.,{0} h.,hónap,{0}/hó,{0} hónap,{0} hónap,hónap,{0}/hónap,{0} hónap,{0} hónap
        nanosecond,,,,,,,,,nanoszekundum,,{0} nanoszekundum,{0} nanoszekundum
        night,éjszakák,{0}/éjszaka,{0} éjszaka,{0} éjszaka,éjszakák,{0}/éjszaka,{0} éjszaka,{0} éjszaka,éjszakák,{0}/éjszaka,{0} éjszaka,{0} éjszaka
        quarter,n.év,{0}/n.év,{0} n.év,{0} n.év,n.év,{0}/n.év,{0} n.év,{0} n.év,negyedév,{0}/n.év,{0} negyedév,{0} negyedév
        second,mp,{0}/mp,{0} mp,{0} mp,mp,{0}/mp,{0} mp,{0} mp,másodperc,{0}/másodperc,{0} másodperc,{0} másodperc
        week,hét,{0}/hét,{0} hét,{0} hét,hét,{0}/hét,{0} hét,{0} hét,hét,{0}/hét,{0} hét,{0} hét
        year,év,{0}/év,{0} év,{0} év,év,{0}/év,{0} év,{0} év,év,{0}/év,{0} év,{0} év
        ampere,A,,,{0} A,A,,,{0} A,amper,,{0} amper,{0} amper
        milliampere,,,,,,,,,milliamper,,{0} milliamper,{0} milliamper
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,ohm,,{0} ohm,{0} ohm
        volt,V,,,{0} V,V,,,{0} V,volt,,{0} volt,{0} volt
        british-thermal-unit,,,,,,,,,brit hőegység,,{0} brit hőegység,{0} brit hőegység
        calorie,,,,,,,,,kalória,,{0} kalória,{0} kalória
        electronvolt,,,,,,,,,elektronvolt,,{0} elektronvolt,{0} elektronvolt
        foodcalorie,cal,,{0} cal,{0} cal,cal,,{0} cal,{0} cal,kalória,,{0} kalória,{0} kalória
        joule,J,,,{0} J,J,,,{0} J,joule,,{0} joule,{0} joule
        kilocalorie,,,,,,,,,kilokalória,,{0} kilokalória,{0} kilokalória
        kilojoule,,,,,,,,,kilojoule,,{0} kilojoule,{0} kilojoule
        kilowatt-hour,,,,,,,,,kilowattóra,,{0} kilowattóra,{0} kilowattóra
        therm-us,USA therm,,{0} USA therm,{0} USA therm,USA therm,,{0} USA therm,{0} USA therm,amerikai therm,,{0} amerikai therm,{0} amerikai therm
        kilowatt-hour-per-100-kilometer,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km,kWh/100 km,,{0} kWh/100 km,{0} kWh/100 km
        newton,,,,,,,,,newton,,{0} newton,{0} newton
        pound-force,,,,,,,,,fonterő,,{0} fonterő,{0} fonterő
        gigahertz,,,,,,,,,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,,,,,,,,,hertz,,{0} hertz,{0} hertz
        kilohertz,,,,,,,,,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,,,,,,,,,megahertz,,{0} megahertz,{0} megahertz
        dot-per-centimeter,dpcm,,{0} dpcm,{0} dpcm,dpcm,,{0} dpcm,{0} dpcm,pont per centiméter,,{0} pont per centiméter,{0} pont per centiméter
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,pont per hüvelyk,,{0} pont per hüvelyk,{0} pont per hüvelyk
        em,,,,,,,,,nyomdai em,,{0} kvirt,{0} kvirt
        megapixel,,,,,megapixel,,,{0} MP,millió képpont,,{0} millió képpont,{0} millió képpont
        pixel,,,,,képpont,,,{0} px,képpont,,{0} képpont,{0} képpont
        pixel-per-centimeter,,,,,,,,,képpont per centiméter,,{0} képpont per centiméter,{0} képpont per centiméter
        pixel-per-inch,,,,,,,,,képpont per hüvelyk,,{0} képpont per hüvelyk,{0} képpont per hüvelyk
        astronomical-unit,CsE,,{0} CsE,{0} CsE,CsE,,{0} CsE,{0} CsE,csillagászati egység,,{0} csillagászati egység,{0} csillagászati egység
        centimeter,,,,,,,,,centiméter,{0}/centimeter,{0} centiméter,{0} centiméter
        decimeter,,,,,,,,,deciméter,,{0} deciméter,{0} deciméter
        earth-radius,,,,,,,,,földsugár,,{0} földsugár,{0} földsugár
        fathom,öl,,{0} öl,{0} öl,öl,,{0} öl,{0} öl,öl,,{0} öl,{0} öl
        foot,láb,{0}/láb,{0} láb,{0} láb,láb,{0}/láb,{0} láb,{0} láb,láb,{0}/láb,{0} láb,{0} láb
        furlong,furlong,,,{0} fur,furlong,,,{0} fur,furlong,,{0} furlong,{0} furlong
        inch,hüvelyk,{0}/in,{0} hüvelyk,{0} hüvelyk,hüvelyk,{0}/in,{0} hüvelyk,{0} hüvelyk,hüvelyk,{0}/hüvelyk,{0} hüvelyk,{0} hüvelyk
        kilometer,,,,,,,,,kilométer,{0}/kilométer,{0} kilométer,{0} kilométer
        light-year,fényév,,{0} fényév,{0} fényév,fényév,,{0} fényév,{0} fényév,fényév,,{0} fényév,{0} fényév
        meter,m,{0}/m,,{0} m,m,{0}/m,,{0} m,méter,{0}/méter,{0} méter,{0} méter
        micrometer,,,,,,,,,mikrométer,,{0} mikrométer,{0} mikrométer
        mile,mf,,{0} mf,{0} mf,mf,,{0} mf,{0} mf,mérföld,,{0} mérföld,{0} mérföld
        mile-scandinavian,mil,,{0} mil,{0} mil,mil,,{0} mil,{0} mil,svéd mérföld,,{0} svéd mérföld,{0} svéd mérföld
        millimeter,,,,,,,,,milliméter,,{0} milliméter,{0} milliméter
        nanometer,,,,,,,,,nanométer,,{0} nanométer,{0} nanométer
        nautical-mile,,,,,,,,,tengeri mérföld,,{0} tengeri mérföld,{0} tengeri mérföld
        parsec,,,,,,,,,parszek,,{0} parszek,{0} parszek
        picometer,,,,,,,,,pikométer,,{0} pikométer,{0} pikométer
        point,,,,,pont,,,{0} pt,pont,,{0} pont,{0} pont
        solar-radius,,,,,Nap-sugár,,,{0} R☉,Nap-sugár,,{0} Nap-sugár,{0} Nap-sugár
        yard,,,,,,,,,yard,,{0} yard,{0} yard
        candela,,,,,,,,,kandela,,{0} kandela,{0} kandela
        lumen,,,,,,,,,lumen,,{0} lumen,{0} lumen
        lux,,,,,,,,,lux,,{0} lux,{0} lux
        solar-luminosity,,,,,,,,,Nap-fényerő,,{0} Nap-fényerő,{0} Nap-fényerő
        carat,Kt,,{0} Kt,{0} Kt,Kt,,{0} Kt,{0} Kt,karát,,{0} karát,{0} karát
        dalton,,,,,,,,,dalton,,{0} dalton,{0} dalton
        earth-mass,,,,,,,,,Föld-tömeg,,{0} Föld-tömeg,{0} Föld-tömeg
        gram,g,{0}/g,,{0} g,,,,,gramm,{0}/gramm,{0} gramm,{0} gramm
        kilogram,,,,,,,,,kilogramm,{0}/kilogramm,{0} kilogramm,{0} kilogramm
        microgram,,,,,,,,,mikrogramm,,{0} mikrogramm,{0} mikrogramm
        milligram,,,,,,,,,milligramm,,{0} milligramm,{0} milligramm
        ounce,oz,{0}/oz,{0} oz,{0} uncia,,,,,uncia,{0}/uncia,{0} uncia,{0} uncia
        ounce-troy,,,,,,,,,troy uncia,,{0} troy uncia,{0} troy uncia
        pound,lb,{0}/lb,{0} lb,{0} font,,,,,font,{0}/font,{0} font,{0} font
        solar-mass,,,,,,,,,Nap-tömeg,,{0} Nap-tömeg,{0} Nap-tömeg
        stone,,,,,,,,,stone,,{0} stone,{0} stone
        ton,,,,,,,,,amerikai tonna,,{0} amerikai tonna,{0} amerikai tonna
        tonne,,,,,,,,,metrikus tonna,,{0} metrikus tonna,{0} metrikus tonna
        gigawatt,,,,,,,,,gigawatt,,{0} gigawatt,{0} gigawatt
        horsepower,LE,,{0} LE,{0} LE,LE,,{0} LE,{0} LE,lóerő,,{0} lóerő,{0} lóerő
        kilowatt,,,,,,,,,kilowatt,,{0} kilowatt,{0} kilowatt
        megawatt,,,,,,,,,megawatt,,{0} megawatt,{0} megawatt
        milliwatt,,,,,,,,,milliwatt,,{0} milliwatt,{0} milliwatt
        watt,W,,,{0} W,W,,,{0} W,watt,,{0} watt,{0} watt
        atmosphere,,,,,,,,,atmoszféra,,{0} atmoszféra,{0} atmoszféra
        bar,,,,,,,,,bar,,{0} bar,{0} bar
        hectopascal,,,,,,,,,hektopascal,,{0} hektopascal,{0} hektopascal
        inch-ofhg,Hgin,,,{0} inHg,,,,,higanyhüvelyk,,{0} higanyhüvelyk,{0} higanyhüvelyk
        kilopascal,,,,,,,,,kilopascal,,{0} kilopascal,{0} kilopascal
        megapascal,,,,,,,,,megapascal,,{0} megapascal,{0} megapascal
        millibar,mbar,,{0} mb,{0} mb,mbar,,{0} mb,{0} mb,millibar,,{0} millibar,{0} millibar
        millimeter-ofhg,Hgmm,,{0} Hgmm,{0} Hgmm,Hgmm,,{0} Hgmm,{0} Hgmm,higanymilliméter,,{0} higanymilliméter,{0} higanymilliméter
        pascal,,,,,,,,,pascal,,{0} pascal,{0} pascal
        pound-force-per-square-inch,,,,,,,,,font per négyzethüvelyk,,{0} font per négyzethüvelyk,{0} font per négyzethüvelyk
        beaufort,Bft,,B{0},B{0},,,,,Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,,,,,,,,,kilométer per óra,,{0} kilométer per óra,{0} kilométer per óra
        knot,,,,,,,,,csomó,,{0} csomó,{0} csomó
        meter-per-second,,,,,,,,,méter per másodperc,,{0} méter per másodperc,{0} méter per másodperc
        mile-per-hour,mph,,{0} mph,{0} mph,mph,,{0} mph,{0} mph,mérföld per óra,,{0} mérföld per óra,{0} mérföld per óra
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,Celsius-fok,,{0} Celsius-fok,{0} Celsius-fok
        fahrenheit,°F,,{0} °F,{0} °F,°F,,{0} °F,{0} °F,Fahrenheit-fok,,{0} Fahrenheit-fok,{0} Fahrenheit-fok
        generic,,,,,,,,,°,,{0} fok,{0} fok
        kelvin,,,,,,,,,kelvin,,{0} kelvin,{0} kelvin
        newton-meter,Nm,,{0} Nm,{0} Nm,Nm,,{0} Nm,{0} Nm,newtonméter,,{0} newtonméter,{0} newtonméter
        pound-force-foot,,,,,,,,,fontláb,,{0} fontláb,{0} fontláb
        acre-foot,,,,,,,,,hold-láb,,{0} hold-láb,{0} hold-láb
        barrel,hordó,,{0} hordó,{0} hordó,hordó,,{0} hordó,{0} hordó,hordó,,{0} hordó,{0} hordó
        bushel,véka,,{0} véka,{0} véka,véka,,{0} véka,{0} véka,véka,,{0} véka,{0} véka
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,centiliter,,{0} centiliter,{0} centiliter
        cubic-centimeter,,,,,,,,,köbcentiméter,{0}/köbcentiméter,{0} köbcentiméter,{0} köbcentiméter
        cubic-foot,,,,,,,,,köbláb,,{0} köbláb,{0} köbláb
        cubic-inch,,,,,,,,,köbhüvelyk,,{0} köbhüvelyk,{0} köbhüvelyk
        cubic-kilometer,,,,,,,,,köbkilométer,,{0} köbkilométer,{0} köbkilométer
        cubic-meter,,,,,,,,,köbméter,{0}/köbméter,{0} köbméter,{0} köbméter
        cubic-mile,,,,,,,,,köbmérföld,,{0} köbmérföld,{0} köbmérföld
        cubic-yard,,,,,,,,,köbyard,,{0} köbyard,{0} köbyard
        cup,cs.,,{0} cs.,{0} cs.,cs.,,{0} cs.,{0} cs.,csésze,,{0} csésze,{0} csésze
        cup-metric,bg,,{0} bg,{0} bg,bg,,{0} bg,{0} bg,bögre,,{0} bögre,{0} bögre
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,deciliter,,{0} deciliter,{0} deciliter
        dessert-spoon,desszertkanál,,{0} desszertkanál,{0} desszertkanál,desszertkanál,,{0} desszertkanál,{0} desszertkanál,desszertkanál,,{0} desszertkanál,{0} desszertkanál
        dessert-spoon-imperial,bir. desszertkanál,,{0} bir. desszertkanál,{0} bir. desszertkanál,bir. desszertkanál,,{0} bir. desszertkanál,{0} bir. desszertkanál,bir. desszertkanál,,{0} bir. desszertkanál,{0} bir. desszertkanál
        dram,fl.dr.,,{0} fl.dr.,{0} fl.dr.,fluid dram,,{0} fl dram,{0} fl dram,dram,,{0} dram,{0} dram
        drop,csepp,,{0} csepp,{0} csepp,csepp,,{0} csepp,{0} csepp,csepp,,{0} csepp,{0} csepp
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,folyadékuncia,,{0} folyadékuncia,{0} folyadékuncia
        fluid-ounce-imperial,bir. f. uncia,,{0} bir. f. uncia,{0} bir. f. uncia,bir. f. uncia,,{0} bir. f. uncia,{0} bir. f. uncia,bir. folyadék uncia,,{0} bir. folyadék uncia,{0} bir. folyadék uncia
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,gallon,{0}/gallon,{0} gallon,{0} gallon
        gallon-imperial,bir. gal,{0}/bir. gal,{0} bir. gal,{0} bir. gal,bir. gal,{0}/bir. gal,{0} bir. gal,{0} bir. gal,birodalmi gallon,{0}/birodalmi gallon,{0} birodalmi gallon,{0} birodalmi gallon
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hektoliter,,{0} hektoliter,{0} hektoliter
        jigger,adagolópohár,,{0} adagolópohár,{0} adagolópohár,adagolópohár,,{0} adagolópohár,{0} adagolópohár,adagolópohár,,{0} adagolópohár,{0} adagolópohár
        liter,l,{0}/l,,{0} l,l,{0}/l,,{0} l,liter,{0}/liter,{0} liter,{0} liter
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megaliter,,{0} megaliter,{0} megaliter
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,milliliter,,{0} milliliter,{0} milliliter
        pinch,csi,,{0} csi,{0} csi,csipet,,{0} csipet,{0} csipet,csipet,,{0} csipet,{0} csipet
        pint,,,,,,,,,pint,,{0} pint,{0} pint
        pint-metric,,,,,,,,,metrikus pint,,{0} metrikus pint,{0} metrikus pint
        quart,,,,,,,,,quart,,{0} quart,{0} quart
        quart-imperial,bir. qt,,{0} bir. qt,{0} bir. qt,bir. qt,,{0} bir. qt,{0} bir. qt,birodalmi kvart,,{0} birodalmi kvart,{0} birodalmi kvart
        tablespoon,ek.,,{0} ek.,{0} ek.,ek.,,{0} ek.,{0} ek.,evőkanál,,{0} evőkanál,{0} evőkanál
        teaspoon,kk.,,{0} kk.,{0} kk.,kk.,,{0} kk.,{0} kk.,kávéskanál,,{0} kávéskanál,{0} kávéskanál
        """.trimIndent()
  }

  private val hu_Prefixes: String by lazy {
    """square,,,négyzet{0}
        cubic,,,köb{0}
        per,,,{0} per {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,exbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobe{0}
        10p-1,,,deci{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,centi{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,milli{0}
        10p-30,,,quecto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hekto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val hy_Units: String by lazy {
    """g-force,g-ուժ,,{0}G,{0}G,g-ուժ,,{0} g,{0} g,ազատ անկման արագացում,,{0} g-ուժ,{0} g-ուժ
        meter-per-square-second,մ/վ²,,{0} մ/վ²,{0} մ/վ²,մ/վ²,,{0} մ/վ²,{0} մ/վ²,մետր քառակուսի վայրկյանի վրա,,{0} մետր/վայրկյան քառակուսի,{0} մետր/վայրկյան քառակուսի
        arc-minute,րոպե,,,{0}′,րոպե,,,{0}′,րոպե,,{0} րոպե,{0} րոպե
        arc-second,վայրկյան,,,{0}″,վայրկյան,,,{0}″,վայրկյան,,{0} վայրկյան,{0} վայրկյան
        degree,աստ,,,{0}°,աստիճան,,,{0}°,աստիճան,,{0} աստիճան,{0} աստիճան
        radian,ռադ,,{0}ռադ,{0}ռադ,ռադ,,{0} ռադ,{0} ռադ,ռադիան,,{0} ռադիան,{0} ռադիան
        revolution,պտ,,{0}պտ,{0}պտ,պտ,,{0} պտ,{0} պտ,պտույտ,,{0} պտույտ,{0} պտույտ
        acre,ակր,,{0}ակր,{0}ակր,ակր,,{0} ակր,{0} ակր,ակր,,{0} ակր,{0} ակր
        dunam,դունամ,,{0}դունամ,{0}դունամ,դունամ,,{0} դունամ,{0} դունամ,դունամ,,{0} դունամ,{0} դունամ
        hectare,հա,,{0}հա,{0}հա,հա,,{0} հա,{0} հա,հեկտար,,{0} հեկտար,{0} հեկտար
        square-centimeter,սմ²,{0}/սմ²,{0}սմ²,{0}սմ²,սմ²,{0}/սմ²,{0} սմ²,{0} սմ²,քառակուսի սանտիմետր,{0} քառակուսի սանտիմետրի վրա,{0} քառակուսի սանտիմետր,{0} քառակուսի սանտիմետր
        square-foot,ֆտ²,,{0}ֆտ²,{0}ֆտ²,ֆտ²,,{0} ֆտ²,{0} ֆտ²,քառակուսի ֆուտ,,{0} քառակուսի ֆուտ,{0} քառակուսի ֆուտ
        square-inch,մատ²,{0}/մատ²,{0} մատ²,{0} մատ²,մատ²,{0}/մատ²,{0} մատ²,{0} մատ²,քառակուսի մատնաչափ,{0} քառակուսի մատնաչափի վրա,{0} քառակուսի մատնաչափ,{0} քառակուսի մատնաչափ
        square-kilometer,կմ²,{0}/կմ²,{0}կմ²,{0}կմ²,կմ²,{0}/կմ²,{0} կմ²,{0} կմ²,քառակուսի կիլոմետր,{0} քառակուսի կիլոմետրի վրա,{0} քառակուսի կիլոմետր,{0} քառակուսի կիլոմետր
        square-meter,մ²,{0}/մ²,{0}մ²,{0}մ²,մ²,{0}/մ²,{0} մ²,{0} մ²,քառակուսի մետր,{0} քառակուսի մետրի վրա,{0} քառակուսի մետր,{0} քառակուսի մետր
        square-mile,մղ²,{0}/մղ²,{0}մղ²,{0}մղ²,մղ²,{0}/մղ²,{0} մղ²,{0} մղ²,քառակուսի մղոն,{0} քառակուսի մղոնի վրա,{0} քառակուսի մղոն,{0} քառակուսի մղոն
        square-yard,յդ²,,{0}յդ²,{0}յդ²,յդ²,,{0} յդ²,{0} յդ²,քառակուսի յարդ,,{0} քառակուսի յարդ,{0} քառակուսի յարդ
        item,միույթ,,{0}միույթ,{0}միույթ,միույթ,,{0} միույթ,{0} միույթ,միույթ,,{0} միույթ,{0} միույթ
        karat,կար,,{0}կար,{0}կար,կար,,{0} կար,{0} կար,կարատ,,{0} կարատ,{0} կարատ
        milligram-ofglucose-per-deciliter,մգ/դլ,,{0} մգ/դլ,{0} մգ/դլ,մգ/դլ,,{0} մգ/դլ,{0} մգ/դլ,միլիգրամ դեցիլիտրի վրա,,{0} միլիգրամ դեցիլիտրի վրա,{0} միլիգրամ դեցիլիտրի վրա
        millimole-per-liter,մմոլ/լ,,{0}մմոլ/լ,{0}մմոլ/լ,մմոլ/լ,,{0} մմոլ/լ,{0} մմոլ/լ,միլիմոլ լիտրի վրա,,{0} միլիմոլ լիտրի վրա,{0} միլիմոլ լիտրի վրա
        mole,մոլ,,{0}մոլ,{0}մոլ,մոլ,,{0} մոլ,{0} մոլ,մոլ,,{0} մոլ,{0} մոլ
        percent,,,,,տոկոս,,,{0}%,տոկոս,,{0} տոկոս,{0} տոկոս
        permille,,,,,պրոմիլ,,,{0}‰,պրոմիլ,,{0} պրոմիլ,{0} պրոմիլ
        permillion,մմվ,,{0}մմվ,{0}մմվ,մաս/միլիոն,,{0} մմվ,{0} մմվ,մաս միլիոնի վրա,,{0} մաս միլիոնի վրա,{0} մաս միլիոնի վրա
        permyriad,,,,,,,,,պերմիրիադ,,{0} պերմիրիադ,{0} պերմիրիադ
        portion-per-1e9,մմլրդվ,,{0}մմլրդվ,{0}մմլրդվ,մաս/միլիարդ,,{0} մմլրդվ,{0} մմլրդվ,մաս միլիարդի վրա,,{0} մաս միլիարդի վրա,{0} մաս միլիարդի վրա
        liter-per-100-kilometer,Լ/100 կմ,,{0} Լ/100 կմ,{0} Լ/100 կմ,Լ/100 կմ,,{0} Լ/100 կմ,{0} Լ/100 կմ,լիտր 100 կիլոմետրի վրա,,{0} լիտր 100 կիլոմետրի վրա,{0} լիտր 100 կիլոմետրի վրա
        liter-per-kilometer,լ/կմ,,{0}լ/կմ,{0}լ/կմ,լ/կմ,,{0} լ/կմ,{0} լ/կմ,լիտր կիլոմետրի վրա,,{0} լիտր կիլոմետրի վրա,{0} լիտր կիլոմետրի վրա
        mile-per-gallon,մղ/գալ,,{0} մղ/գալ,{0} մղ/գալ,մղ/գալ,,{0} մղ/գալ,{0} մղ/գալ,մղոն գալոնի վրա,,{0} մղոն գալոնի վրա,{0} մղոն գալոնի վրա
        mile-per-gallon-imperial,մղ/անգլ․ գալ,,{0} մղ/անգլ․ գալ,{0} մղ/անգլ․ գալ,մղ/անգլ․ գալ,,{0} մղ/անգլ․ գալ,{0} մղ/անգլ․ գալ,մղոն անգլիական գալոնի վրա,,{0} մղոն անգլիական գալոնի վրա,{0} մղոն անգլիական գալոնի վրա
        bit,բիթ,,{0}բիթ,{0}բիթ,բիթ,,{0} բիթ,{0} բիթ,բիթ,,{0} բիթ,{0} բիթ
        byte,Բ,,{0}Բ,{0}Բ,Բ,,{0} բայթ,{0} Բ,բայթ,,{0} բայթ,{0} բայթ
        gigabit,Գբիթ,,{0}Գբիթ,{0}Գբիթ,Գբիթ,,{0} Գբիթ,{0} Գբիթ,գիգաբիթ,,{0} գիգաբիթ,{0} գիգաբիթ
        gigabyte,ԳԲ,,{0}ԳԲ,{0}ԳԲ,ԳԲայթ,,{0} ԳԲ,{0} ԳԲ,գիգաբայթ,,{0} գիգաբայթ,{0} գիգաբայթ
        kilobit,կբիթ,,{0}կբիթ,{0}կբիթ,կբիթ,,{0} կբիթ,{0} կբիթ,կիլոբիթ,,{0} կիլոբիթ,{0} կիլոբիթ
        kilobyte,կԲ,,{0}կԲ,{0}կԲ,կԲայթ,,{0} կԲ,{0} կԲ,կիլոբայթ,,{0} կիլոբայթ,{0} կիլոբայթ
        megabit,Մբիթ,,{0}Մբիթ,{0}Մբիթ,Մբիթ,,{0} Մբիթ,{0} Մբիթ,մեգաբիթ,,{0} մեգաբիթ,{0} մեգաբիթ
        megabyte,ՄԲ,,{0}ՄԲ,{0}ՄԲ,ՄԲայթ,,{0} ՄԲ,{0} ՄԲ,մեգաբայթ,,{0} մեգաբայթ,{0} մեգաբայթ
        petabyte,ՊԲայթ,,{0}ՊԲ,{0}ՊԲ,ՊԲայթ,,{0} ՊԲ,{0} ՊԲ,պետաբայթ,,{0} պետաբայթ,{0} պետաբայթ
        terabit,Տբիթ,,{0}Տբիթ,{0}Տբիթ,Տբիթ,,{0} Տբիթ,{0} Տբիթ,տերաբիթ,,{0} տերաբիթ,{0} տերաբիթ
        terabyte,ՏԲայթ,,{0}ՏԲ,{0}ՏԲ,ՏԲայթ,,{0} ՏԲ,{0} ՏԲ,տերաբայթ,,{0} տերաբայթ,{0} տերաբայթ
        century,դ․,,{0} դ․,{0} դ․,դ․,,{0} դ․,{0} դ․,դար,,{0} դար,{0} դար
        day,օ,{0}/օ,{0} օ,{0} օ,օր,{0}/օր,{0} օր,{0} օր,օր,օրական {0},{0} օր,{0} օր
        decade,10-ամյակ,,{0} 10-ամյակ,{0} 10-ամյակ,10-ամյակ,,{0} 10-ամյակ,{0} 10-ամյակ,տասնամյակ,,{0} տասնամյակ,{0} տասնամյակ
        hour,ժամ,{0}/ժ,{0}ժ,{0}ժ,ժամ,{0}/ժ,{0} ժ,{0} ժ,ժամ,{0} ժամում,{0} ժամ,{0} ժամ
        microsecond,մկվ,,{0} մկվ,{0} մկվ,մկվ,,{0} մկվ,{0} մկվ,միկրովայրկյան,,{0} միկրովայրկյան,{0} միկրովայրկյան
        millisecond,մվ,,{0} մվ,{0} մվ,մվ,,{0} մվ,{0} մվ,միլիվայրկյան,,{0} միլիվայրկյան,{0} միլիվայրկյան
        minute,ր,{0}/ր,{0}ր,{0}ր,ր,{0}/ր,{0} ր,{0} ր,րոպե,{0} րոպեում,{0} րոպե,{0} րոպե
        month,ա,{0}/ա,{0}ա,{0}ա,ամս,{0}/ամս,{0} ամս,{0} ամս,ամիս,ամսական {0},{0} ամիս,{0} ամիս
        nanosecond,նվ,,{0} նվ,{0} նվ,նվ,,{0} նվ,{0} նվ,նանովայրկյան,,{0} նանովայրկյան,{0} նանովայրկյան
        night,գիշեր,{0}/գ․,{0}/գ․,{0}/գ․,գիշեր,{0}/գիշեր,{0} գիշեր,{0} գիշեր,գիշեր,գիշերը {0},{0} գիշեր,{0} գիշեր
        quarter,եռմս,{0}/եռմս,{0} եռմս,{0} եռմս,եռմս,{0}/եռմս,{0} եռմս,{0} եռմս,եռամսյակ,{0}/եռմս,{0} եռամսյակ,{0} եռամսյակ
        second,վ,{0}/վ,{0} վ,{0} վ,վրկ,{0}/վրկ,{0} վրկ,{0} վրկ,վայրկյան,{0} վայրկյանում,{0} վայրկյան,{0} վայրկյան
        week,շ,{0}/շ,{0} շ,{0} շ,շաբ,{0}/շաբ,{0} շաբ,{0} շաբ,շաբաթ,շաբաթական {0},{0} շաբաթ,{0} շաբաթ
        year,տարի,{0}/տ,{0} տ,{0} տ,տարի,{0}/տ,{0} տ,{0} տ,տարի,տարեկան {0},{0} տարի,{0} տարի
        ampere,Ա,,{0}Ա,{0}Ա,Ա,,{0} Ա,{0} Ա,ամպեր,,{0} ամպեր,{0} ամպեր
        milliampere,մԱ,,{0}մԱ,{0}մԱ,մԱ,,{0} մԱ,{0} մԱ,միլիամպեր,,{0} միլիամպեր,{0} միլիամպեր
        ohm,օհմ,,{0} Ω,{0}Ω,օհմ,,{0} Ω,{0} Ω,օհմ,,{0} օհմ,{0} օհմ
        volt,Վ,,{0}Վ,{0}Վ,Վ,,{0} Վ,{0} Վ,վոլտ,,{0} վոլտ,{0} վոլտ
        british-thermal-unit,ԲՋՄ,,{0}Բջմ,{0}Բջմ,ԲՋՄ,,{0} Բջմ,{0} Բջմ,բրիտանական ջերմային միավոր,,{0} բրիտանական ջերմային միավոր,{0} բրիտանական ջերմային միավոր
        calorie,կալ,,{0} կալ,{0} կալ,կալ,,{0} կալ,{0} կալ,կալորիա,,{0} կալորիա,{0} կալորիա
        electronvolt,էՎ,,{0}էՎ,{0}էՎ,էՎ,,{0} էՎ,{0} էՎ,էլեկտրոն-վոլտ,,{0} էլեկտրոն-վոլտ,{0} էլեկտրոն-վոլտ
        foodcalorie,կալ,,{0} կալ,{0}կալ,կալ,,{0} կալ,{0} կալ,կալորիա,,{0} կալորիա,{0} կալորիա
        joule,Ջ,,{0} Ջ,{0} Ջ,Ջ,,{0} Ջ,{0} Ջ,ջոուլ,,{0} ջոուլ,{0} ջոուլ
        kilocalorie,կկալ,,{0}կկալ,{0}կկալ,կկալ,,{0} կկալ,{0} կկալ,կիլոկալորիա,,{0} կիլոկալորիա,{0} կիլոկալորիա
        kilojoule,կՋ,,{0}կՋ,{0}կՋ,կՋ,,{0} կՋ,{0} կՋ,կիլոջոուլ,,{0} կիլոջոուլ,{0} կիլոջոուլ
        kilowatt-hour,կՎտ ժ,,{0} կՎտ ժ,{0} կՎտ ժ,կՎտ ժ,,{0} կՎտ ժ,{0} կՎտ ժ,կիլովատտ-ժամ,,{0} կիլովատտ-ժամ,{0} կիլովատտ-ժամ
        therm-us,ԱՄՆ ջերմ,,{0} ԱՄՆ ջերմ,{0} ԱՄՆ ջերմ,ԱՄՆ ջերմ,,{0} ԱՄՆ ջերմ,{0} ԱՄՆ ջերմ,ԱՄՆ ջերմ,,{0} ԱՄՆ ջերմ,{0} ԱՄՆ ջերմ
        kilowatt-hour-per-100-kilometer,կՎտ⋅ժ/100 կմ,,{0} կՎտժ/100 կմ,{0} կՎտժ/100 կմ,կՎտ⋅ժ/100 կմ,,{0} կՎտ⋅ժ/100 կմ,{0} կՎտ⋅ժ/100 կմ,կիլովատտ-ժամ 100 կիլոմետրի վրա,,{0} կիլովատտ-ժամ 100 կիլոմետրի վրա,{0} կիլովատտ-ժամ 100 կիլոմետրի վրա
        newton,Ն,,{0} Ն,{0} Ն,Ն,,{0} Ն,{0} Ն,նյուտոն,,{0} նյուտոն,{0} նյուտոն
        pound-force,ֆնտ․ ու․,,{0} ֆնտ․ ու․,{0} ֆնտ․ ու․,ֆնտ․ ու․,,{0} ֆնտ․ ու․,{0} ֆնտ․ ու․,ֆունտ-ուժ,,{0} ֆունտ-ուժ,{0} ֆունտ-ուժ
        gigahertz,ԳՀց,,{0}ԳՀց,{0}ԳՀց,ԳՀց,,{0} ԳՀց,{0} ԳՀց,գիգահերց,,{0} գիգահերց,{0} գիգահերց
        hertz,Հց,,{0}Հց,{0}Հց,Հց,,{0} Հց,{0} Հց,հերց,,{0} հերց,{0} հերց
        kilohertz,կՀց,,{0}կՀց,{0}կՀց,կՀց,,{0} կՀց,{0} կՀց,կիլոհերց,,{0} կիլոհերց,{0} կիլոհերց
        megahertz,ՄՀց,,{0}ՄՀց,{0}ՄՀց,ՄՀց,,{0} ՄՀց,{0} ՄՀց,մեգահերց,,{0} մեգահերց,{0} մեգահերց
        dot,կետ,,{0} կետ,{0} կետ,կետ,,{0} կետ,{0} կետ,կետ,,{0} կետ,{0} կետ
        dot-per-centimeter,կսմ,,{0} կսմ,{0} կսմ,կսմ,,{0} կսմ,{0} կսմ,կետ սանտիմետրի վրա,,{0} կետ սանտիմետրի վրա,{0} կետ սանտիմետրի վրա
        dot-per-inch,կմչ,,{0} կմչ,{0} կմչ,կմչ,,{0} կմչ,{0} կմչ,կետ մատնաչափի վրա,,{0} կետ մատնաչափի վրա,{0} կետ մատնաչափի վրա
        em,em,,{0}em,{0}em,,,,,տպագրական em,,{0} em,{0} em
        megapixel,մեգափիքսելներ,,{0} ՄՓ,{0} ՄՓ,մեգափիքսելներ,,{0} ՄՓ,{0} ՄՓ,մեգափիքսել,,{0} մեգափիքսել,{0} մեգափիքսել
        pixel,կտ,,{0} փքս,{0} փքս,փիքսել,,{0} փքս,{0} փքս,փիքսել,,{0} փիքսել,{0} փիքսել
        pixel-per-centimeter,կսմվ,,{0}կսմվ,{0}կսմվ,փսմ,,{0} փսմ,{0} փսմ,փիքսել սանտիմետրի վրա,,{0} փիքսել սանտիմետրի վրա,{0} փիքսել սանտիմետրի վրա
        pixel-per-inch,փմչ,,{0} փմչ,{0} փմչ,փմչ,,{0} փմչ,{0} փմչ,փիքսել մատնաչափի վրա,,{0} փիքսել մատնաչափի վրա,{0} փիքսել մատնաչափի վրա
        astronomical-unit,ա.մ.,,{0} ա.մ.,{0} ա.մ.,ա.մ.,,{0} ա.մ.,{0} ա.մ.,աստղագիտական միավոր,,{0} աստղագիտական միավոր,{0} աստղագիտական միավոր
        centimeter,սմ,{0}/սմ,{0} սմ,{0} սմ,սմ,{0}/սմ,{0} սմ,{0} սմ,սանտիմետր,{0} սանտիմետրի վրա,{0} սանտիմետր,{0} սանտիմետր
        decimeter,դմ,,{0} դմ,{0} դմ,դմ,,{0} դմ,{0} դմ,դեցիմետր,,{0} դեցիմետր,{0} դեցիմետր
        earth-radius,,,,,,,,,երկրի շառավիղ,,{0} երկրի շառավիղ,{0} երկրի շառավիղ
        fathom,ֆատոմ,,{0} ֆատոմ,{0} ֆատոմ,ծովային սաժեն,,{0} ֆատոմ,{0} ֆատոմ,ծովային սաժեն,,{0} ծովային սաժեն,{0} ծովային սաժեն
        foot,ֆտ,{0}/ֆտ,{0}′,{0}′,ֆտ,{0}/ֆտ,{0} ֆտ,{0} ֆտ,ֆուտ,{0} ֆուտի վրա,{0} ֆուտ,{0} ֆուտ
        furlong,ֆուրլ․,,{0} ֆուրլ․,{0} ֆուրլ․,ֆուրլոնգ,,{0} ֆուրլ․,{0} ֆուրլ․,ֆուրլոնգ,,{0} ֆուրլոնգ,{0} ֆուրլոնգ
        inch,մատ,{0}/մատ,{0}″,{0}″,մատ,{0}/մատ,{0} մատ,{0} մատ,մատնաչափ,{0} մատնաչափի վրա,{0} մատնաչափ,{0} մատնաչափ
        kilometer,կմ,{0}/կմ,{0} կմ,{0} կմ,կմ,{0}/կմ,{0} կմ,{0} կմ,կիլոմետր,{0} կիլոմետրի վրա,{0} կիլոմետր,{0} կիլոմետր
        light-year,լ․տ․,,{0} լ. տ.,{0} լ. տ.,լ․տ․,,{0} լ.տ.,{0} լ.տ.,լուսատարի,,{0} լուսատարի,{0} լուսատարի
        meter,մ,{0}/մ,{0} մ,{0} մ,մ,{0}/մ,{0} մ,{0} մ,մետր,{0} մետրի վրա,{0} մետր,{0} մետր
        micrometer,մկմ,,{0} մկմ,{0} մկմ,մկմ,,{0} մկմ,{0} մկմ,միկրոմետր,,{0} միկրոմետր,{0} միկրոմետր
        mile,մղ,,{0} մղ,{0} մղ,մղ,,{0} մղ,{0} մղ,մղոն,,{0} մղոն,{0} մղոն
        mile-scandinavian,սկանդ․ մղ,,{0} սկանդ․ մղ,{0} սկանդ․ մղ,սկանդ․ մղ,,{0} սկանդ․ մղ,{0} սկանդ․ մղ,սկանդինավյան մղոն,,{0} սկանդինավյան մղոն,{0} սկանդինավյան մղոն
        millimeter,մմ,,{0} մմ,{0} մմ,մմ,,{0} մմ,{0} մմ,միլիմետր,,{0} միլիմետր,{0} միլիմետր
        nanometer,նմ,,{0} նմ,{0} նմ,նմ,,{0} նմ,{0} նմ,նանոմետր,,{0} նանոմետր,{0} նանոմետր
        nautical-mile,ծով․ մղ,,{0} ծով․ մղ,{0} ծով․ մղ,ծով․ մղ,,{0} ծով․ մղ,{0} ծով․ մղ,ծովային մղոն,,{0} ծովային մղոն,{0} ծովային մղոն
        parsec,պկ,,{0} պկ,{0} պկ,պկ,,{0} պկ,{0} պկ,պարսեկ,,{0} պարսեկ,{0} պարսեկ
        picometer,պմ,,{0} պմ,{0} պմ,պմ,,{0} պմ,{0} պմ,պիկոմետր,,{0} պիկոմետր,{0} պիկոմետր
        point,կտ,,,{0} pt,կտ,,,{0} pt,կտ,,{0} կտ,{0} կտ
        solar-radius,,,,,,,,,արեգակնային շառավիղ,,{0} արեգակնային շառավիղ,{0} արեգակնային շառավիղ
        yard,յդ,,{0}յդ,{0}յդ,յարդ,,{0} յդ,{0} յդ,յարդ,,{0} յարդ,{0} յարդ
        candela,կդ,,{0} կդ,{0} կդ,կդ,,{0} կդ,{0} կդ,կանդելա,,{0} կանդելա,{0} կանդելա
        lumen,լմ,,{0} լմ,{0} լմ,լմ,,{0} լմ,{0} լմ,լյումեն,,{0} լյումեն,{0} լյումեն
        lux,լք,,{0}լք,{0}լք,լք,,{0} լք,{0} լք,լյուքս,,{0} լյուքս,{0} լյուքս
        solar-luminosity,,,,,,,,,արեգակնային լուսատվություն,,{0} արեգակնային լուսատվություն,{0} արեգակնային լուսատվություն
        carat,կար,,{0}կար,{0}կար,կար,,{0} կար,{0} կար,կարատ,,{0} կարատ,{0} կարատ
        dalton,դա,,{0} դա,{0} դա,դա,,{0} դա,{0} դա,դալտոն,,{0} դալտոն,{0} դալտոն
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,,,,,երկրային զանգված,,{0} երկրային զանգված,{0} արևային զանգված
        grain,գրան,,{0} գրան,{0} գրան,գրան,,{0} գրան,{0} գրան,գրան,,{0} գրան,{0} գրան
        gram,գ,{0}/գ,{0} գ,{0} գ,գ,{0}/գ,{0} գ,{0} գ,գրամ,{0} գրամի վրա,{0} գրամ,{0} գրամ
        kilogram,կգ,{0}/կգ,{0} կգ,{0} կգ,կգ,{0}/կգ,{0} կգ,{0} կգ,կիլոգրամ,{0} կիլոգրամի վրա,{0} կիլոգրամ,{0} կիլոգրամ
        microgram,մկգ,,{0}մկգ,{0}մկգ,մկգ,,{0} մկգ,{0} մկգ,միկրոգրամ,,{0} միկրոգրամ,{0} միկրոգրամ
        milligram,մգ,,{0}մգ,{0}մգ,մգ,,{0} մգ,{0} մգ,միլիգրամ,,{0} միլիգրամ,{0} միլիգրամ
        ounce,ու,{0}/ու,{0}ու,{0}ու,ու,{0}/ու,{0} ու,{0} ու,ունկի,{0} ունկիի վրա,{0} ունկի,{0} ունկի
        ounce-troy,տ․ ու,,{0}տ․ու,{0}տ․ու,տրոյ․ ու,,{0} տ․ ու,{0} տ․ ու,տրոյական ունկի,,{0} տրոյական ունկի,{0} տրոյական ունկի
        pound,ֆունտ,{0}/ֆունտ,{0}#,{0}#,ֆունտ,{0}/ֆունտ,{0} ֆունտ,{0} ֆունտ,ֆունտ,{0} ֆունտի վրա,{0} ֆունտ,{0} ֆունտ
        solar-mass,M☉,,{0}M☉,{0}M☉,,,,,արեգակնային զանգված,,{0} արեգակնային զանգված,{0} արեգակնային զանգված
        stone,սթոուն,,{0}սթ,{0}սթ,սթոուն,,{0} սթ,{0} սթ,սթոուն,,{0} սթ,{0} սթ
        ton,ամեր․ տ,,{0} ամեր․ տ,{0} ամեր․ տ,ամեր․ տ,,{0} ամեր․ տ,{0} ամեր․ տ,ամերիկյան տոննա,,{0} ամերիկյան տոննա,{0} ամերիկյան տոննա
        tonne,տ,,{0}տ,{0}տ,տ,,{0} տ,{0} տ,տոննա,,{0} տոննա,{0} տոննա
        gigawatt,ԳՎտ,,{0} ԳՎտ,{0} ԳՎտ,ԳՎտ,,{0} ԳՎտ,{0} ԳՎտ,գիգավատտ,,{0} գիգավատտ,{0} գիգավատտ
        horsepower,ձ․ու․,,{0}ձ/ու,{0}ձ/ու,ձ․ու․,,{0} ձ․ու․,{0} ձ․ու․,ձիաուժ,,{0} ձիաուժ,{0} ձիաուժ
        kilowatt,կՎտ,,{0}կՎ,{0}կՎ,կՎտ,,{0} կՎտ,{0} կՎտ,կիլովատտ,,{0} կիլովատտ,{0} կիլովատտ
        megawatt,ՄՎտ,,{0} ՄՎտ,{0} ՄՎտ,ՄՎտ,,{0} ՄՎտ,{0} ՄՎտ,մեգավատտ,,{0} մեգավատտ,{0} մեգավատտ
        milliwatt,մՎտ,,{0}մՎտ,{0}մՎտ,մՎտ,,{0} մՎտ,{0} մՎտ,միլիվատտ,,{0} միլիվատտ,{0} միլիվատտ
        watt,Վտ,,{0}Վ,{0}Վ,Վտ,,{0} Վտ,{0} Վտ,վատտ,,{0} վատտ,{0} վատտ
        atmosphere,մթն,,{0}մթն,{0}մթն,մթն,,{0} մթն,{0} մթն,մթնոլորտ,,{0} մթնոլորտ,{0} մթնոլորտ
        bar,բար,,{0}բար,{0}բար,բար,,{0} բար,{0} բար,բար,,{0} բար,{0} բար
        hectopascal,հՊա,,{0}հՊա,{0}հՊա,հՊա,,{0} հՊա,{0} հՊա,հեկտոպասկալ,,{0} հեկտոպասկալ,{0} հեկտոպասկալ
        inch-ofhg,մատ. ս.ս.,,{0}'' ս.ս.,{0}'' ս. ս.,մատ. ս.ս.,,{0} մատ. ս.ս.,{0} մատ. ս.ս.,մատնաչափ՝ սնդիկի սյան,,{0} մատնաչափ՝ սնդիկի սյան,{0} մատնաչափ՝ սնդիկի սյան
        kilopascal,կՊա,,{0}կՊա,{0}կՊա,կՊա,,{0} կՊա,{0} կՊա,կիլոպասկալ,,{0} կիլոպասկալ,{0} կիլոպասկալ
        megapascal,ՄՊա,,{0}ՄՊա,{0}ՄՊա,ՄՊա,,{0} ՄՊա,{0} ՄՊա,մեգապասկալ,,{0} մեգապասկալ,{0} մեգապասկալ
        millibar,մբար,,{0}մբ,{0}մբ,մբար,,{0} մբար,{0} մբար,միլիբար,,{0} միլիբար,{0} միլիբար
        millimeter-ofhg,մմ ս.ս.,,{0} մմ ս.ս.,{0} մմ ս.ս.,մմ ս.ս.,,{0} մմ ս.ս.,{0} մմ ս.ս.,միլիմետր՝ սնդիկի սյան,,{0} միլիմետր՝ սնդիկի սյան,{0} միլիմետր՝ սնդիկի սյան
        pascal,Պա,,{0}Պա,{0}Պա,Պա,,{0} Պա,{0} Պա,պասկալ,,{0} պասկալ,{0} պասկալ
        pound-force-per-square-inch,ֆ․/քառ․ դյմ,,{0} ֆ./քառ․ դյմ,{0} ֆ./քառ․ դյմ,ֆ․/քառ․ դյմ,,{0} ֆ./քառ․ դյմ,{0} ֆ./քառ․ դյմ,ֆունտ քառակուսի դյույմի վրա,,{0} ֆունտ քառակուսի դյույմի վրա,{0} ֆունտ քառակուսի դյույմի վրա
        beaufort,Բֆտ,,Բ{0},Բ{0},Բֆտ,,Բ {0},Բ {0},Բոֆորտ,,Բոֆորտ {0},Բոֆորտ {0}
        kilometer-per-hour,կմ/ժ,,{0} կմ/ժ,{0} կմ/ժ,կմ/ժ,,{0} կմ/ժ,{0} կմ/ժ,կիլոմետր ժամում,,{0} կիլոմետր ժամում,{0} կիլոմետր ժամում
        knot,հնգ,,{0} հնգ,{0} հնգ,հնգ,,{0} հնգ,{0} հնգ,հանգույց,,{0} հանգույց,{0} հանգույց
        meter-per-second,մ/վ,,{0}մ/վ,{0}մ/վ,մ/վ,,{0} մ/վ,{0} մ/վ,մետր վայրկյանում,,{0} մետր վայրկյանում,{0} մետր վայրկյանում
        mile-per-hour,մղ/ժ,,{0}մղ/ժ,{0}մղ/ժ,մղ/ժ,,{0} մղ/ժ,{0} մղ/ժ,մղոն ժամում,,{0} մղոն ժամում,{0} մղոն ժամում
        celsius,°C,,{0} °C,{0} °C,°C,,{0} °C,{0} °C,աստիճան ըստ Ցելսիուսի,,{0} աստիճան ըստ Ցելսիուսի,{0} աստիճան ըստ Ցելսիուսի
        fahrenheit,,,,,,,,,աստիճան ըստ Ֆարենհայթի,,{0} աստիճան ըստ Ֆարենհայթի,{0} աստիճան ըստ Ֆարենհայթի
        generic,,,,,,,,,ջերմաստիճան,,{0}°,{0}°
        kelvin,Կ,,{0}Կ,{0}Կ,Կ,,{0} Կ,{0} Կ,կելվին,,{0} կելվին,{0} կելվին
        newton-meter,Ն մ,,{0} Ն մ,{0} Ն մ,Ն մ,,{0} Ն մ,{0} Ն մ,նյուտոն-մետր,,{0} նյուտոն-մետր,{0} նյուտոն-մետր
        pound-force-foot,ֆնտ-ֆտ,,{0} ֆնտ-ֆտ,{0} ֆնտ-ֆտ,ֆնտ-ֆտ,,{0} ֆնտ-ֆտ,{0} ֆնտ-ֆտ,ֆունտ-ֆուտ,,{0} ֆունտ-ֆուտ,{0} ֆունտ-ֆուտ
        acre-foot,ակր ֆտ,,{0} ակր ֆտ,{0} ակր ֆտ,ակր ֆտ,,{0} ակր ֆտ,{0} ակր ֆտ,ակրոֆուտ,,{0} ակրոֆուտ,{0} ակրոֆուտ
        barrel,տակառ,,{0}տկռ,{0}տկռ,տակառ,,{0} տկռ,{0} տկռ,տակառ,,{0} տակառ,{0} տակառ
        bushel,բուշել,,{0}բու,{0}բու,բուշել,,{0} բու,{0} բու,բուշել,,{0} բուշել,{0} բուշել
        centiliter,սլ,,{0}սլ,{0}սլ,սլ,,{0} սլ,{0} սլ,սանտիլիտր,,{0} սանտիլիտր,{0} սանտիլիտր
        cubic-centimeter,սմ³,{0}/սմ³,{0} սմ³,{0} սմ³,սմ³,{0}/սմ³,{0} սմ³,{0} սմ³,խորանարդ սանտիմետր,{0} խորանարդ սանտիմետրի վրա,{0} խորանարդ սանտիմետր,{0} խորանարդ սանտիմետր
        cubic-foot,ֆտ³,,{0}ֆտ³,{0}ֆտ³,ֆտ³,,{0} ֆտ³,{0} ֆտ³,խորանարդ ֆուտ,,{0} խորանարդ ֆուտ,{0} խորանարդ ֆուտ
        cubic-inch,մատ³,,{0}մատ³,{0}մատ³,մատ³,,{0} մատ³,{0} մատ³,խորանարդ մատնաչափ,,{0} խորանարդ մատնաչափ,{0} խորանարդ մատնաչափ
        cubic-kilometer,կմ³,,{0}կմ³,{0}կմ³,կմ³,,{0} կմ³,{0} կմ³,խորանարդ կիլոմետր,,{0} խորանարդ կիլոմետր,{0} խորանարդ կիլոմետր
        cubic-meter,մ³,{0}/մ³,{0} մ³,{0} մ³,մ³,{0}/մ³,{0} մ³,{0} մ³,խորանարդ մետր,{0} խորանարդ մետրի վրա,{0} խորանարդ մետր,{0} խորանարդ մետր
        cubic-mile,մղ³,,{0}մղ³,{0}մղ³,մղ³,,{0} մղ³,{0} մղ³,խորանարդ մղոն,,{0} խորանարդ մղոն,{0} խորանարդ մղոն
        cubic-yard,յրդ³,,{0}յրդ³,{0}յրդ³,յրդ³,,{0} յրդ³,{0} յրդ³,խորանարդ յարդ,,{0} խորանարդ յարդ,{0} խորանարդ յարդ
        cup,բաժ․,,{0}բաժ․,{0}բաժ․,բաժակ,,{0} բաժ․,{0} բաժ․,բաժակ,,{0} բաժակ,{0} բաժակ
        cup-metric,մ․ բաժ․,,{0} մ․ բաժ․,{0} մ․ բաժ․,մ․ բաժ․,,{0} մ․ բաժ․,{0} մ․ բաժ․,մետրիկ բաժակ,,{0} մետրիկ բաժակ,{0} մետրիկ բաժակ
        deciliter,դլ,,{0}դլ,{0}դլ,դլ,,{0} դլ,{0} դլ,դեցիլիտր,,{0} դեցիլիտր,{0} դեցիլիտր
        dessert-spoon,ագ․,,{0}ագ․,{0}ագ․,ագ․,,{0} ագ․,{0} ագ․,աղանդերի գդալ,,{0} աղանդերի գդալ,{0} աղանդերի գդալ
        dessert-spoon-imperial,անգլ․ ագ․,,{0} անգլ․ ագ․,{0} անգլ․ ագ․,անգլ․ ագ․,,{0} անգլ․ ագ․,{0} անգլ․ ագ․,անգլիական աղանդերի գդալ,,{0} անգլիական աղանդերի գդալ,{0} անգլիական աղանդերի գդալ
        dram,դրամ,,{0}հեղ. դր.,{0}հեղ. դր.,դրամ,,{0} հեղուկ դրամ,{0} հեղուկ դրամ,դրամ,,{0} դրամ,{0} դրամ
        drop,կաթիլ,,{0}կթլ,{0}կթլ,կաթիլ,,{0} կաթիլ,{0} կաթիլ,կաթիլ,,{0} կաթիլ,{0} կաթիլ
        fluid-ounce,հղ․ ու,,{0}հղ.ու,{0}հղ.ու,հղ․ ու,,{0} հղ. ու,{0} հղ. ու,հեղուկ ունկի,,{0} հեղուկ ունկի,{0} հեղուկ ունկի
        fluid-ounce-imperial,ա․ հ․ ու․,,{0} ա․ հ․ ու․,{0} ա․ հ․ ու․,ա․ հ․ ու․,,{0} ա․ հ․ ու․,{0} ա․ հ․ ու․,անգլիական հեղուկ ունկի,,{0} անգլիական հեղուկ ունկի,{0} անգլիական հեղուկ ունկի
        gallon,գալ,{0}/գալ,{0}գալ,{0}գալ,գալ,{0}/գալ,{0} գալ,{0} գալ,գալոն,{0} գալոնի վրա,{0} գալոն,{0} գալոն
        gallon-imperial,անգլ․ գալ,{0}/անգլ․ գալ,{0} անգլ․ գալ,{0} անգլ․ գալ,անգլ․ գալ,{0}/անգլ․ գալ,{0} անգլ․ գալ,{0} անգլ․ գալ,անգլիական գալոն,{0} անգլիական գալոնի վրա,{0} անգլիական գալոն,{0} անգլիական գալոն
        hectoliter,հլ,,{0}հլ,{0}հլ,հլ,,{0} հլ,{0} հլ,հեկտոլիտր,,{0} հեկտոլիտր,{0} հեկտոլիտր
        jigger,ջիգեր,,{0}ջիգեր,{0}ջիգեր,ջիգեր,,{0} ջիգեր,{0} ջիգեր,ջիգեր,,{0} ջիգեր,{0} ջիգեր
        liter,լ,{0}/լ,{0} լ,{0} լ,լ,{0}/լ,{0} լ,{0} լ,լիտր,{0} լիտրի վրա,{0} լիտր,{0} լիտր
        megaliter,Մլ,,{0}Մլ,{0}Մլ,Մլ,,{0} Մլ,{0} Մլ,մեգալիտր,,{0} մեգալիտր,{0} մեգալիտր
        milliliter,մլ,,{0} մլ,{0} մլ,մլ,,{0} մլ,{0} մլ,միլիլիտր,,{0} միլիլիտր,{0} միլիլիտր
        pinch,պտղունց,,{0}պտղունց,{0}պտղունց,պտղունց,,{0} պտղունց,{0} պտղունց,պտղունց,,{0} պտղունց,{0} պտղունց
        pint,փինթ,,{0}փինթ,{0}փինթ,փինթ,,{0} փինթ,{0} փինթ,փինթ,,{0} փինթ,{0} փինթ
        pint-metric,մետր․ փինթեր,,{0} մետր․ փինթ,{0} մետր․ փինթ,մետր․ փինթ,,{0} մետր․ փինթ,{0} մետր․ փինթ,մետրիկ փինթ,,{0} մետրիկ փինթ,{0} մետրիկ փինթ
        quart,քվարտ,,{0}քվարտ,{0}քվարտ,քվարտ,,{0} քվարտ,{0} քվարտ,քվարտ,,{0} քվարտ,{0} քվարտ
        quart-imperial,անգլիական քվարտ,,{0} անգլիական քվարտ,{0} անգլիական քվարտ,անգլիական քվարտ,,{0} անգլիական քվարտ,{0} անգլիական քվարտ,անգլիական քվարտ,,{0} անգլիական քվարտ,{0} անգլիական քվարտ
        tablespoon,ճգ.,,{0}ճգ.,{0}ճգ.,ճգ.,,{0} ճգ.,{0} ճգ.,ճաշի գդալ,,{0} ճաշի գդալ,{0} ճաշի գդալ
        teaspoon,թգ.,,{0} թգ.,{0} թգ.,թգ.,,{0} թգ.,{0} թգ.,թեյի գդալ,,{0} թեյի գդալ,{0} թեյի գդալ
        """.trimIndent()
  }

  private val hy_Prefixes: String by lazy {
    """square,,,քառակուսի {0}
        cubic,,,խորանարդ {0}
        1024p1,Կի{0},Կի{0},կիբի{0}
        1024p2,Մի{0},Մի{0},մեբի{0}
        1024p3,Գի{0},Գի{0},գիբի{0}
        1024p4,Տի{0},Տի{0},տեբի{0}
        1024p5,Փի{0},Փի{0},փեբի{0}
        1024p6,Էի{0},Էի{0},Էքսբի{0}
        1024p7,Զի{0},Զի{0},զեբի{0}
        1024p8,Յի{0},Յի{0},Յոբի{0}
        10p-1,դ{0},դ{0},դեցի{0}
        10p-12,պ{0},պ{0},պիկո{0}
        10p-15,ֆ{0},ֆ{0},ֆեմտո{0}
        10p-18,ա{0},ա{0},ատտո{0}
        10p-2,ս{0},ս{0},սանտի{0}
        10p-21,զ{0},զ{0},զեպտո{0}
        10p-24,յ{0},յ{0},յոկտո{0}
        10p-27,ռ{0},ռ{0},ռոնտո{0}
        10p-3,մ{0},մ{0},միլի{0}
        10p-30,ք{0},ք{0},քուեկտո{0}
        10p-6,մկ{0},մկ{0},միկրո{0}
        10p-9,ն{0},ն{0},նանո{0}
        10p1,դա{0},դա{0},դեկա{0}
        10p12,Տ{0},Տ{0},տերա{0}
        10p15,Պ{0},Պ{0},պետա{0}
        10p18,Է{0},Է{0},էքսա{0}
        10p2,հ{0},հ{0},հեկտո{0}
        10p21,Զ{0},Զ{0},զետտա{0}
        10p24,Յ{0},Յ{0},յոտտա{0}
        10p27,Ռ{0},Ռ{0},ռոննա{0}
        10p3,կ{0},կ{0},կիլո{0}
        10p30,Ք{0},Ք{0},քուետտա{0}
        10p6,Մ{0},Մ{0},մեգա{0}
        10p9,Գ{0},Գ{0},գիգա{0}
        """.trimIndent()
  }

  private val ia_Units: String by lazy {
    """g-force,fortia g,,,{0} G,fortia g,,,{0} G,fortia g,,{0} fortia g,{0} fortia g
        meter-per-square-second,,,,,,,,,metros per secunda quadrate,,{0} metro per secunda quadrate,{0} metros per secunda quadrate
        arc-minute,′,,,{0}′,′,,,{0}′,minutas de arco,,{0} minuta de arco,{0} minutas de arco
        arc-second,″,,,{0}″,″,,,{0}″,secundas de arco,,{0} secunda de arco,{0} secundas de arco
        degree,°,,,{0}°,°,,,{0}°,grados,,{0} grado,{0} grados
        radian,,,,,,,,,radianos,,{0} radiano,{0} radianos
        revolution,,,,,,,,,revolutiones,,{0} revolution,{0} revolutiones
        acre,ac,,,{0} ac,ac,,,{0} ac,acres,,{0} acre,{0} acres
        dunam,dunames,,{0} dunams,{0} dunams,dunames,,{0} dunams,{0} dunams,dunames,,{0} dunams,{0} dunams
        hectare,ha,,,{0} ha,ha,,,{0} ha,hectares,,{0} hectare,{0} hectares
        square-centimeter,,,,,,,,,centimetros quadrate,{0} per centimetro quadrate,{0} centimetro quadrate,{0} centimetros quadrate
        square-foot,,,,,,,,,pedes quadrate,,{0} pede quadrate,{0} pedes quadrate
        square-inch,,,,,,,,,pollices quadrate,{0} per pollice quadrate,{0} pollice quadrate,{0} pollices quadrate
        square-kilometer,,,,,,,,,kilometros quadrate,{0} per kilometro quadrate,{0} kilometro quadrate,{0} kilometros quadrate
        square-meter,,,,,,,,,metros quadrate,{0} per metro quadrate,{0} metro quadrate,{0} metros quadrate
        square-mile,,,,,,,,,millias quadrate,{0} per millia quadrate,{0} millia quadrate,{0} millias quadrate
        square-yard,,,,,,,,,yards quadrate,,{0} yard quadrate,{0} yards quadrate
        karat,,,,,,,,,carates,,{0} carat,{0} carates
        milligram-ofglucose-per-deciliter,,,,,,,,,milligrammas per decilitro,,{0} milligramma per decilitro,{0} milligrammas per decilitro
        millimole-per-liter,,,,,,,,,millimoles per litro,,{0} millimol per litro,{0} millimoles per litro
        percent,,,,,,,,,per cento,,{0} per cento,{0} per cento
        permille,,,,,,,,,per mille,,{0} per mille,{0} per mille
        permillion,,,,,,,,,partes per million,,{0} parte per million,{0} partes per million
        liter-per-100-kilometer,,,,,,,,,litros per 100 kilometros,,{0} litro per 100 kilometros,{0} litros per 100 kilometros
        liter-per-kilometer,,,,,,,,,litros per kilometro,,{0} litro per kilometro,{0} litros per kilometro
        mile-per-gallon,mi/gal,,{0} mi/gal,{0} mi/gal,mi/gal,,{0} mi/gal,{0} mi/gal,millias per gallon,,{0} millia per gallon,{0} millias per gallon
        mile-per-gallon-imperial,mi/gal imp.,,{0} mi/gal imp.,{0} mi/gal imp.,mi/gal imp.,,{0} mi/gal imp.,{0} mi/gal imp.,millias per gallon imperial,,{0} millia per gallon imperial,{0} millias per gallon imperial
        bit,b,,{0} b,{0} b,b,,{0} b,{0} b,bits,,{0} bit,{0} bits
        byte,B,,,{0} byte,B,,,{0} byte,bytes,,{0} byte,{0} bytes
        gigabit,,,,,,,,,gigabits,,{0} gigabit,{0} gigabits
        gigabyte,,,,,,,,,gigabytes,,{0} gigabyte,{0} gigabytes
        kilobit,,,,,,,,,kilobits,,{0} kilobit,{0} kilobits
        kilobyte,,,,,,,,,kilobytes,,{0} kilobyte,{0} kilobytes
        megabit,,,,,,,,,megabits,,{0} megabit,{0} megabits
        megabyte,,,,,,,,,megabytes,,{0} megabyte,{0} megabytes
        petabyte,,,,,,,,,petabytes,,{0} petabyte,{0} petabytes
        terabit,,,,,,,,,terabits,,{0} terabit,{0} terabits
        terabyte,,,,,,,,,terabytes,,{0} terabyte,{0} terabytes
        century,scl,,{0} scl,{0} scl,scl,,{0} scl,{0} scl,seculos,,{0} seculo,{0} seculos
        day,die,{0}/d,{0}d,{0}d,dies,{0}/d,{0} die,{0} dies,dies,{0} per die,{0} die,{0} dies
        hour,hora,{0}/h,{0}h,{0}h,horas,{0}/h,{0} hr,{0} hr,horas,{0} per hora,{0} hora,{0} horas
        microsecond,μs,,{0} μs,{0}μs,,,,,microsecundas,,{0} microsecunda,{0} microsecundas
        millisecond,millisec,,{0}ms,{0}ms,millisec,,,{0} ms,millisecundas,,{0} millisecunda,{0} millisecundas
        minute,min,{0}/min,{0}m,{0}m,,,,,minutas,{0} per minuta,{0} minuta,{0} minutas
        month,mense,{0}/m,{0}m,{0}m,menses,{0}/m,{0} mense,{0} menses,menses,{0} per mense,{0} mense,{0} menses
        nanosecond,,,,,,,,,nanosecundas,,{0} nanosecunda,{0} nanosecundas
        second,s,{0}/s,{0}s,{0}s,sec,{0}/s,{0} sec,{0} sec,secundas,{0} per secunda,{0} secunda,{0} secundas
        week,sept.,{0}/sept,{0}sept,{0}sept,septimanas,{0}/sept,{0} sept,{0} sept,septimanas,{0} per septimana,{0} septimana,{0} septimanas
        year,an,{0}/an,{0}an,{0}an,annos,{0}/an,{0} an,{0} an,annos,{0} per anno,{0} anno,{0} annos
        ampere,A,,,{0} A,A,,,{0} A,amperes,,{0} ampere,{0} amperes
        milliampere,,,,,,,,,milliamperes,,{0} milliampere,{0} milliamperes
        ohm,Ω,,,{0} Ω,Ω,,,{0} Ω,ohms,,{0} ohm,{0} ohms
        volt,V,,,{0} V,V,,,{0} V,volts,,{0} volt,{0} volts
        calorie,,,,,,,,,calorias,,{0} caloria,{0} calorias
        foodcalorie,,,,,,,,,kilocalorias,,{0} kilocaloria,{0} kilocalorias
        joule,J,,,{0} J,J,,,{0} J,joules,,{0} joule,{0} joules
        kilocalorie,,,,,,,,,kilocalorias,,{0} kilocaloria,{0} kilocalorias
        kilojoule,,,,,,,,,kilojoules,,{0} kilojoule,{0} kilojoules
        kilowatt-hour,,,,,,,,,kilowatthoras,,{0} kilowatthora,{0} kilowatthoras
        gigahertz,,,,,,,,,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,,,,,,,,,hertz,,{0} hertz,{0} hertz
        kilohertz,,,,,,,,,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,,,,,,,,,megahertz,,{0} megahertz,{0} megahertz
        astronomical-unit,ua,,{0} ua,{0} ua,ua,,{0} ua,{0} ua,unitates astronomic,,{0} unitate astronomic,{0} unitates astronomic
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,centimetros,{0} per centimetro,{0} centimetro,{0} centimetros
        decimeter,,,,,,,,,decimetros,,{0} decimetro,{0} decimetros
        foot,,,,,,,,,pedes,{0} per pede,{0} pede,{0} pedes
        inch,,,,,,,,,pollices,{0} per pollice,{0} pollice,{0} pollices
        kilometer,km,{0}/km,{0}km,{0}km,,,,,kilometros,{0} per kilometro,{0} kilometro,{0} kilometros
        light-year,al,,{0} al,{0} al,al,,{0} al,{0} al,annos lumine,,{0} anno lumine,{0} annos lumine
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,,{0} m,metros,{0} per metro,{0} metro,{0} metros
        micrometer,,,,,,,,,micrometros,,{0} micrometro,{0} micrometros
        mile,,,,,,,,,millias,,{0} millia,{0} millias
        mile-scandinavian,,,,,,,,,millias scandinave,,{0} millia scandinave,{0} millias scandinave
        millimeter,mm,,{0}mm,{0}mm,,,,,millimetros,,{0} millimetro,{0} millimetros
        nanometer,,,,,,,,,nanometros,,{0} nanometro,{0} nanometros
        nautical-mile,,,,,,,,,millias nautic,,{0} millia nautic,{0} millias nautic
        parsec,,,,,,,,,parsecs,,{0} parsec,{0} parsecs
        picometer,,,,,,,,,picometros,,{0} picometro,{0} picometros
        point,,,,,,,,,punctos,,{0} puncto,{0} punctos
        yard,,,,,,,,,yards,,{0} yard,{0} yards
        lux,,,,,,,,,lux,,{0} lux,{0} lux
        carat,ct,,{0} ct,{0} ct,ct,,{0} ct,{0} ct,carates,,{0} carat,{0} carates
        gram,g,{0}/g,,{0} g,g,{0}/g,,{0} g,grammas,{0} per gramma,{0} gramma,{0} grammas
        kilogram,,,,,,,,,kilogrammas,{0} per kilogramma,{0} kilogramma,{0} kilogrammas
        microgram,,,,,,,,,microgrammas,,{0} microgramma,{0} microgrammas
        milligram,,,,,,,,,milligrammas,,{0} milligramma,{0} milligrammas
        ounce,,,,,,,,,uncias,{0} per uncia,{0} uncia,{0} uncias
        ounce-troy,,,,,,,,,uncias troy,,{0} uncia troy,{0} uncias troy
        pound,,,,,,,,,libras,{0} per libra,{0} libra,{0} libras
        ton,,,,,,,,,tonnas curte,,{0} tonna curte,{0} tonnas curte
        tonne,,,,,,,,,tonnas,,{0} tonna,{0} tonnas
        gigawatt,,,,,,,,,gigawatts,,{0} gigawatt,{0} gigawatts
        horsepower,cv,,{0} cv,{0} cv,cv,,{0} cv,{0} cv,cavallos-vapor,,{0} cavallo-vapor,{0} cavallos-vapor
        kilowatt,,,,,,,,,kilowatts,,{0} kilowatt,{0} kilowatts
        megawatt,,,,,,,,,megawatts,,{0} megawatt,{0} megawatts
        milliwatt,,,,,,,,,milliwatts,,{0} milliwatt,{0} milliwatts
        watt,W,,,{0} W,W,,,{0} W,watts,,{0} watt,{0} watts
        atmosphere,,,,,,,,,atmospheras,,{0} atmosphera,{0} atmospheras
        hectopascal,,,,,,,,,hectopascales,,{0} hectopascal,{0} hectopascales
        inch-ofhg,,,,,,,,,pollices de mercurio,,{0} pollice de mercurio,{0} pollices de mercurio
        millibar,,,,,,,,,millibares,,{0} millibar,{0} millibares
        millimeter-ofhg,,,,,,,,,milimetros de mercurio,,{0} millimetro de mercurio,{0} millimetros de mercurio
        pound-force-per-square-inch,,,,,,,,,libras-fortia per pollice quadrate,,{0} libra-fortia per pollice quadrate,{0} libras-fortia per pollice quadrate
        kilometer-per-hour,,,,,,,,,kilometros per hora,,{0} kilometro per hora,{0} kilometros per hora
        knot,,,,,,,,,nodos,,{0} nodo,{0} nodos
        meter-per-second,,,,,,,,,metros per secunda,,{0} metro per secunda,{0} metros per secunda
        mile-per-hour,,,,,,,,,millias per hora,,{0} millia per hora,{0} millias per hora
        celsius,,,,,,,,,grados Celcius,,{0} grado Celcius,{0} grados Celcius
        fahrenheit,,,,,,,,,grados Fahrenheit,,{0} grado Fahrenheit,{0} grados Fahrenheit
        generic,,,,,,,,,grados,,{0} grado,{0} grados
        kelvin,,,,,,,,,kelvin,,{0} kelvin,{0} kelvin
        acre-foot,acre pd,,{0}acpd,{0}acpd,acre pd,,{0} ac pd,{0} ac pd,acre-pedes,,{0} acre-pede,{0} acre-pedes
        barrel,bbl,,{0}bbl,{0}bbl,barril,,,{0} bbl,barriles,,{0} barriles,{0} barriles
        bushel,bushel,,{0}bu,{0}bu,bushels,,,{0} bu,bushels,,{0} bushel,{0} bushels
        centiliter,cl,,{0}cl,{0}cl,cl,,{0} cl,{0} cl,centilitros,,{0} centilitro,{0} centilitros
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,centimetros cubic,{0} per centimetro cubic,{0} centimetro cubic,{0} centimetros cubic
        cubic-foot,pd³,,{0}pd³,{0}pd³,pd³,,{0} pd³,{0} pd³,pedes cubic,,{0} pede cubic,{0} pedes cubic
        cubic-inch,in³,,{0}in³,{0}in³,,,,,inches cubic,,{0} inch cubic,{0} inches cubic
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,kilometros cubic,,{0} kilometro cubic,{0} kilometros cubic
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,metros cubic,{0} per metro cubic,{0} metro cubic,{0} metros cubic
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,millias cubic,,{0} millia cubic,{0} millias cubic
        cubic-yard,yd³,,{0}yd³,{0}yd³,,,,,yards cubic,,{0} yard cubic,{0} yards cubic
        cup,tas,,{0}t,{0}t,tas,,{0} tas,{0} tas,tassas,,{0} tassa,{0} tassas
        cup-metric,tasm,,{0}tm,{0}tm,tasm,,{0} tasm,{0} tasm,tassas metric,,{0} tassa metric,{0} tassas metric
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,decilitros,,{0} decilitro,{0} decilitros
        dessert-spoon,c. a dessert,,{0}CaD,{0}CaD,cocl. a dessert,,{0} cocl. a dessert,{0} cocl. a dessert,coclearatas a dessert,,{0} coclearata a dessert,{0} coclearatas a dessert
        dessert-spoon-imperial,c. a dsrt imp.,,{0}CaDi,{0}CaDi,cocl. a dessert imp.,,{0} cocl. a dessert imp.,{0} cocl. a dessert imp.,coclearatas a dessert imperial,,{0} coclearata a dessert imperial,{0} coclearatas a dessert imperial
        dram,dr.liq.,,{0}drliq,{0}drliq,drachma liq.,,{0} dr liq,{0} dr liq,drachmas liquide,,{0} drachma liquide,{0} drachmas liquide
        drop,gutta,,{0}gt,{0}gt,guttas,,{0} gutta,{0} guttas,guttas,,{0} gutta,{0} guttas
        fluid-ounce,oz liq,,{0}ozliq,{0}ozliq,oz liq,,{0} oz liq,{0} oz liq,uncias liquide,,{0} uncia liquide,{0} uncias liquide
        fluid-ounce-imperial,oz liq imp,,{0}ozli,{0}ozli,oz liq imp.,,{0} oz liq imp.,{0} oz liq imp.,uncias liquide imperial,,{0} uncia liquide imperial,{0} uncias liquide imperial
        gallon,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal,{0} gal,{0} gal,gallones,{0} per gallon,{0} gallon,{0} gallones
        gallon-imperial,gal imp,{0}/galim,{0}galim,{0}galim,gal imp,{0}/gal imp,{0} gal imp,{0} gal imp,gallones imp.,{0} per gallon imp.,{0} gallon imp.,{0} gallones imp.
        hectoliter,hl,,{0}hl,{0}hl,hl,,{0} hl,{0} hl,hectolitros,,{0} hectolitro,{0} hectolitros
        liter,litros,{0}/l,,{0} l,litros,{0}/l,,{0} l,litros,{0} per litro,{0} litro,{0} litros
        megaliter,Ml,,{0}Ml,{0}Ml,Ml,,{0} Ml,{0} Ml,megalitros,,{0} megalitro,{0} megalitros
        milliliter,ml,,{0}ml,{0}ml,ml,,{0} ml,{0} ml,millilitros,,{0} millilitro,{0} millilitros
        pinch,pn,,{0}pn,{0}pn,pinciata,,{0} pn,{0} pn,pinciatas,,{0} pinciata,{0} pinciatas
        pint,pintas,,{0}pt,{0}pt,pintas,,,{0} pt,pintas,,{0} pinta,{0} pintas
        pint-metric,pt,,{0}pt,{0}pt,ptm,,{0} ptm,{0} ptm,pintas metric,,{0} pinta metric,{0} pintas metric
        quart,qt,,{0}qt,{0}qt,,,,,quartos,,{0} quarto,{0} quartos
        quart-imperial,qt imp,,{0}qt imp,{0}qt imp,Quarto imp.,,{0} quarto imp,{0} quartos imp,Quartos imperial,,{0} quarto imperial,{0} quartos imperial
        tablespoon,c. a suppa,,{0}CaS,{0}CaS,cocl. a suppa,,{0} c. a suppa,{0} c. a suppa,coclearatas a suppa,,{0} coclearata a suppa,{0} coclearatas a suppa
        teaspoon,c. a the,,{0}CaT,{0}CaT,cocl. a the,,{0} cocl. a the,{0} cocl. a the,coclearatas a the,,{0} coclearata a the,{0} coclearatas a the
        jigger,jigger,,{0}jigger,{0}jigger,,,,,,,,
        """.trimIndent()
  }

  private val ia_Prefixes: String by lazy {
    """square,,,{0} quadrate
        cubic,,,{0} cubic
        per,,,{0} per {1}
        10p-1,,,deci{0}
        10p-12,,,pico{0}
        10p-2,,,centi{0}
        10p-3,,,milli{0}
        10p-6,,,micro{0}
        10p-9,,,nano{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p2,,,hecto{0}
        10p3,,,kilo{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val id_Units: String by lazy {
    """g-force,,,,,,,,,g-force,,,{0} g-force
        meter-per-square-second,m/d²,,,{0} m/d²,meter/dtk²,,,{0} m/dtk²,meter per detik persegi,,,{0} meter per detik persegi
        arc-minute,mnt busur,,,{0}′,mnt busur,,,{0} mnt busur,menit busur,,,{0} menit busur
        arc-second,dtk busur,,,{0}″,dtk busur,,,{0} dtk busur,detik busur,,,{0} detik busur
        degree,derajat,,,{0}°,derajat,,,{0}°,derajat,,,{0} derajat
        radian,,,,,radian,,,{0} rad,radian,,,{0} radian
        revolution,,,,,,,,,revolusi,,,{0} revolusi
        acre,ekar,,,{0} ac,ekar,,,{0} ac,ekar,,,{0} ekar
        hectare,hektare,,,{0} ha,hektare,,,{0} ha,hektare,,,{0} hektare
        square-centimeter,,,,,,,,,sentimeter persegi,{0} per sentimeter persegi,,{0} sentimeter persegi
        square-foot,,,,,kaki persegi,,,{0} ft²,kaki persegi,,,{0} kaki persegi
        square-inch,,,,,inci²,{0}/in²,,{0} in²,inci persegi,{0} per inci persegi,,{0} inci persegi
        square-kilometer,,,,,,,,,kilometer persegi,{0} per kilometer persegi,,{0} kilometer persegi
        square-meter,meter²,{0}/m²,,{0} m²,meter²,{0}/m²,,{0} m²,meter persegi,{0} per meter persegi,,{0} meter persegi
        square-mile,,,,,mil persegi,{0}/mi²,,{0} mi²,mil persegi,{0} per mil persegi,,{0} mil persegi
        square-yard,,,,,yard²,,,{0} yd²,yard persegi,,,{0} yard persegi
        karat,karat,,,{0} kt,karat,,,{0} kt,karat,,,{0} karat
        milligram-ofglucose-per-deciliter,,,,,,,,,milligram per desiliter,,,{0} milligram per desiliter
        millimole-per-liter,,,,,millimol/liter,,,{0} mmol/L,millimol per liter,,,{0} millimol per liter
        percent,,,,,persen,,,{0}%,persen,,,{0} persen
        permille,,,,,permil,,,{0}‰,permil,,,{0} permil
        permillion,,,,,bagian/juta,,,{0} ppm,bagian per juta,,,{0} bagian per juta
        permyriad,,,,,permyriad,,,{0}‱,permyriad,,,{0} permyriad
        portion-per-1e9,bagian/miliar,,,{0} ppb,bagian/miliar,,,{0} ppb,bagian per miliar,,,{0} bagian per miliar
        liter-per-100-kilometer,L/100 km,,,{0} L/100 km,L/100 km,,,{0} L/100 km,liter per 100 kilometer,,,{0} liter per 100 kilometer
        liter-per-kilometer,,,,,liter/km,,,{0} L/km,liter per kilometer,,,{0} liter per kilometer
        mile-per-gallon,mpg,,,{0} mpg,mil/gal,,,{0} mpg,mil per galon,,,{0} mil per galon
        mile-per-gallon-imperial,mpg UK,,,{0} m/gUK,mil/gal Imp.,,,{0} mpg Imp.,mil per galon Imp.,,,{0} mil per galon Imp.
        gigabit,,,,,Gbit,,,{0} Gb,gigabit,,,{0} gigabit
        gigabyte,,,,,GByte,,,{0} GB,gigabyte,,,{0} gigabyte
        kilobit,,,,,kbit,,,{0} kb,kilobit,,,{0} kilobit
        kilobyte,,,,,kByte,,,{0} kB,kilobyte,,,{0} kilobyte
        megabit,,,,,Mbit,,,{0} Mb,megabit,,,{0} megabit
        megabyte,,,,,MByte,,,{0} MB,megabyte,,,{0} megabyte
        petabyte,,,,,PByte,,,{0} PB,petabyte,,,{0} petabyte
        terabit,,,,,Tbit,,,{0} Tb,terabit,,,{0} terabit
        terabyte,,,,,TByte,,,{0} TB,terabyte,,,{0} terabyte
        century,abad,,,{0} abad,abad,,,{0} abad,abad,,,{0} abad
        day,hari,{0}/hr,,{0} hr,hari,{0}/hr,,{0} hr,hari,{0} per hari,,{0} hari
        decade,dek,,,{0} dek,dek,,,{0} dek,dekade,,,{0} dekade
        hour,jam,{0}/j,,{0} j,jam,{0}/j,,{0} j,jam,{0} per jam,,{0} jam
        microsecond,μdtk,,,{0} μd,μdtk,,,{0} μd,mikrodetik,,,{0} mikrodetik
        millisecond,milidtk,,,{0} md,milidtk,,,{0} md,milidetik,,,{0} milidetik
        minute,mnt,{0}/mnt,,{0} mnt,mnt,{0}/mnt,,{0} mnt,menit,{0} per menit,,{0} menit
        month,bulan,{0}/bln,,{0} bln,bulan,{0}/bln,,{0} bln,bulan,{0} per bulan,,{0} bulan
        nanosecond,nanodtk,,,{0} ndtk,nanodtk,,,{0} ndtk,nanodetik,,,{0} nanodetik
        night,malam,{0}/malam,,{0} malam,malam,{0}/malam,,{0} malam,malam,{0} per malam,,{0} malam
        quarter,krt,{0}/k,,{0}k,krt,{0}/k,,{0} krt,kuartal,{0}/k,,{0} kuartal
        second,dtk,{0}/dtk,,{0} dtk,dtk,{0}/dtk,,{0} dtk,detik,{0} per detik,,{0} detik
        week,mgg,{0}/mgg,,{0} mgg,minggu,{0}/mgg,,{0} mgg,minggu,{0} per minggu,,{0} minggu
        year,thn,{0}/thn,,{0} thn,tahun,{0}/thn,,{0} thn,tahun,{0} per tahun,,{0} tahun
        ampere,,,,,,,,,ampere,,,{0} ampere
        milliampere,,,,,miliamp,,,{0} mA,miliampere,,,{0} miliampere
        ohm,,,,,,,,,ohm,,,{0} ohm
        volt,,,,,,,,,volt,,,{0} volt
        british-thermal-unit,BTU,,,{0} Btu,BTU,,,{0} Btu,satuan panas Britania,,,{0} satuan panas Britania
        calorie,kal,,,{0} kal,kal,,,{0} kal,kalori,,,{0} kalori
        electronvolt,,,,,elektronvolt,,,{0} eV,elektronvolt,,,{0} elektronvolt
        foodcalorie,Kal,,,{0} Kal,Kal,,,{0} Kal,Kalori,,,{0} Kalori
        joule,,,,,,,,,joule,,,{0} joule
        kilocalorie,kkal,,,{0} kkal,kkal,,,{0} kkal,kilokalori,,,{0} kilokalori
        kilojoule,,,,,kilojoule,,,{0} kJ,kilojoule,,,{0} kilojoule
        kilowatt-hour,,,,,kW-jam,,,{0} kWh,kilowatt-jam,,,{0} kilowatt-jam
        therm-us,therm AS,,,{0} therm AS,therm AS,,,{0} therm AS,therm AS,,,{0} therm AS
        kilowatt-hour-per-100-kilometer,,,,,,,,,kilowatt-jam per 100 kilometer,,,{0} kilowatt-jam per 100 kilometer
        newton,,,,,newton,,,{0} N,newton,,,{0} newton
        pound-force,,,,,pound gaya,,,{0} lbf,pound gaya,,,{0} pound gaya
        gigahertz,,,,,,,,,gigahertz,,,{0} gigahertz
        hertz,,,,,,,,,hertz,,,{0} hertz
        kilohertz,,,,,,,,,kilohertz,,,{0} kilohertz
        megahertz,,,,,,,,,megahertz,,,{0} megahertz
        dot,dot,,,{0} dot,dot,,,{0} dot,dot,,,{0} dot
        dot-per-centimeter,dpcm,,,{0} dpcm,dpcm,,,{0} dpcm,dot per sentimeter,,,{0} dot per sentimeter
        dot-per-inch,dpi,,,{0} dpi,dpi,,,{0} dpi,dot per inci,,,{0} dot per inci
        em,,,,,,,,,em tipografis,,,{0} em
        megapixel,,,,,megapiksel,,,{0} MP,megapiksel,,,{0} megapiksel
        pixel,,,,,piksel,,,{0} px,piksel,,,{0} piksel
        pixel-per-centimeter,,,,,,,,,piksel per sentimeter,,,{0} piksel per sentimeter
        pixel-per-inch,,,,,,,,,piksel per inci,,,{0} piksel per inci
        astronomical-unit,sa,,,{0} sa,sa,,,{0} sa,satuan astronomi,,,{0} satuan astronomi
        centimeter,,,,,,,,,sentimeter,{0} per sentimeter,,{0} sentimeter
        decimeter,,,,,,,,,desimeter,,,{0} desimeter
        earth-radius,,,,,,,,,jari-jari Bumi,,,{0} jari-jari Bumi
        fathom,depa,,,{0} dp,dp,,,{0} dp,depa,,,{0} depa
        foot,ft,{0}/ft,,{0}′,kaki,{0}/ft,,{0} ft,kaki,{0} per kaki,,{0} kaki
        furlong,furlong,,,{0} fur,furlong,,,{0} fur,furlong,,,{0} furlong
        inch,in,{0}/in,,{0}″,inci,{0}/in,,{0} in,inci,{0} per inci,,{0} inci
        kilometer,,,,,,,,,kilometer,{0} per kilometer,,{0} kilometer
        light-year,tc,,,{0} tc,thn cahaya,,,{0} tc,tahun cahaya,,,{0} tahun cahaya
        meter,,,,,,,,,meter,{0} per meter,,{0} meter
        micrometer,μmeter,,,{0} μm,μmeter,,,{0} μm,mikrometer,,,{0} mikrometer
        mile,,,,,mil,,,{0} mi,mil,,,{0} mil
        mile-scandinavian,,,,,,,,,mil skandinavia,,,{0} mil skandinavia
        millimeter,,,,,,,,,milimeter,,,{0} milimeter
        nanometer,,,,,,,,,nanometer,,,{0} nanometer
        nautical-mile,,,,,,,,,mil laut,,,{0} mil laut
        parsec,parsec,,,{0} pc,parsec,,,{0} pc,parsec,,,{0} parsec
        picometer,,,,,,,,,pikometer,,,{0} pikometer
        point,p,,,{0} p,poin,,,{0} p,poin,,,{0} poin
        solar-radius,,,,,radius Matahari,,,{0} R☉,radius Matahari,,,{0} radius Matahari
        yard,,,,,yard,,,{0} yd,yard,,,{0} yard
        candela,,,,,,,,,candela,,,{0} candela
        lumen,,,,,,,,,lumen,,,{0} lumen
        lux,lux,,,{0} lx,lux,,,{0} lx,lux,,,{0} lux
        solar-luminosity,,,,,luminositas matahari,,,{0} L☉,luminositas matahari,,,{0} luminositas matahari
        carat,karat,,,{0} CD,karat,,,{0} CD,karat,,,{0} karat
        dalton,,,,,dalton,,,{0} Da,dalton,,,{0} dalton
        earth-mass,,,,,massa Bumi,,,{0} M⊕,massa Bumi,,,{0} massa Bumi
        gram,,,,,,,,,gram,{0} per gram,,{0} gram
        kilogram,,,,,,,,,kilogram,{0} per kilogram,,{0} kilogram
        microgram,,,,,,,,,mikrogram,,,{0} mikrogram
        milligram,,,,,,,,,miligram,,,{0} miligram
        ounce,,,,,,,,,ounce,{0} per ounce,,{0} ounce
        ounce-troy,,,,,oz troy,,,{0} oz t,troy ons,,,{0} troy ons
        pound,lb,{0}/lb,,{0}#,pound,{0}/lb,,{0} lb,pound,{0} per pound,,{0} pound
        solar-mass,,,,,massa Matahari,,,{0} M☉,massa Matahari,,,{0} massa Matahari
        stone,stone,,,{0} st,stone,,,{0} st,stone,,,{0} stone
        ton,ton,,,{0} tn AS,ton AS,,,{0} tn AS,ton Amerika Serikat,,,{0} ton Amerika Serikat
        tonne,,,,,,,,,metrik ton,,,{0} metrik ton
        gigawatt,,,,,,,,,gigawatt,,,{0} gigawatt
        horsepower,,,,,,,,,daya kuda,,,{0} daya kuda
        kilowatt,,,,,,,,,kilowatt,,,{0} kilowatt
        megawatt,,,,,,,,,megawatt,,,{0} megawatt
        milliwatt,,,,,,,,,miliwatt,,,{0} miliwatt
        watt,,,,,,,,,watt,,,{0} watt
        atmosphere,,,,,,,,,atmosfer,,,{0} atmosfer
        hectopascal,,,,,,,,,hektopascal,,,{0} hektopascal
        inch-ofhg,″ Hg,,,{0}″ Hg,in Hg,,,{0} inHg,inci raksa,,,{0} inci raksa
        kilopascal,,,,,,,,,kilopascal,,,{0} kilopascal
        megapascal,,,,,,,,,megapascal,,,{0} megapascal
        millibar,mbar,,,{0} mb,,,,,milibar,,,{0} milibar
        millimeter-ofhg,mmHg,,,{0} mmHg,mmHg,,,{0} mmHg,milimeter raksa,,,{0} milimeter raksa
        pascal,,,,,,,,,pascal,,,{0} pascal
        pound-force-per-square-inch,,,,,,,,,pound per inci persegi,,,{0} pound per inci persegi
        beaufort,,,,,,,,,Beaufort,,,Beaufort {0}
        kilometer-per-hour,km/jam,,,{0}km/j,km/jam,,,{0} km/j,kilometer per jam,,,{0} kilometer per jam
        knot,,,,,,,,,knot,,,{0} knot
        light-speed,cahaya,,,{0} cahaya,cahaya,,,{0} cahaya,cahaya,,,{0} cahaya
        meter-per-second,m/dtk,,,{0} m/dtk,meter/dtk,,,{0} m/dtk,meter per detik,,,{0} meter per detik
        mile-per-hour,mi/j,,,{0} mpj,mi/h,,,{0} mpj,mil per jam,,,{0} mil per jam
        celsius,,,,,,,,,derajat Celsius,,,{0} derajat Celsius
        fahrenheit,°F,,,{0}°,,,,,derajat Fahrenheit,,,{0} derajat Fahrenheit
        kelvin,,,,,,,,,kelvin,,,{0} kelvin
        newton-meter,,,,,,,,,newton meter,,,{0} newton meter
        pound-force-foot,,,,,,,,,pound kaki,,,{0} pound kaki
        acre-foot,,,,,,,,,ekar kaki,,,{0} ekar kaki
        barrel,,,,,barrel,,,{0} bbl,barrel,,,{0} barrel
        bushel,gantang,,,{0} bu,gantang,,,{0} bu,gantang,,,{0} gantang
        centiliter,,,,,,,,,sentiliter,,,{0} sentiliter
        cubic-centimeter,,,,,,,,,sentimeter kubik,{0} per sentimeter kubik,,{0} sentimeter kubik
        cubic-foot,,,,,,,,,kaki kubik,,,{0} kaki kubik
        cubic-inch,,,,,inci³,,,{0} in³,inci kubik,,,{0} inci kubik
        cubic-kilometer,,,,,,,,,kilometer kubik,,,{0} kilometer kubik
        cubic-meter,,,,,,,,,meter kubik,{0} per meter kubik,,{0} meter kubik
        cubic-mile,,,,,,,,,mil kubik,,,{0} mil kubik
        cubic-yard,,,,,yard³,,,{0} yd³,yard kubik,,,{0} yard kubik
        cup,,,,,,,,,cup,,,{0} cup
        cup-metric,,,,,,,,,metric cup,,,{0} metric cup
        deciliter,,,,,,,,,desiliter,,,{0} desiliter
        dessert-spoon,dsp,,,{0} dsp,,,,,sendok dessert,,,{0} sendok dessert
        dessert-spoon-imperial,dsp Imp,,,{0} dsp-Imp,,,,,sendok dessert Imp.,,,{0} sendok dessert Imp.
        dram,fl.dr.,,,{0} fl.dr.,dram cairan,,,{0} dram fl,dram,,,{0} dram
        drop,tetes,,,{0} tetes,tetes,,,{0} tetes,tetes,,,{0} tetes
        fluid-ounce,fl oz,,,{0} fl oz,fl oz,,,{0} fl oz,fluid ounce,,,{0} fluid ounce
        fluid-ounce-imperial,,,,,,,,,Imp. fluid ounce,,,{0} Imp. fluid ounce
        gallon,gal,{0}/gal,,{0} gal,gal,{0}/gal,,{0} gal,galon,{0} per galon,,{0} galon
        gallon-imperial,gal Imp.,{0}/galIm,,{0} galIm,gal Imp.,{0}/gal Imp.,,{0} gal Imp.,galon Imp.,{0} per galon Imp.,,{0} galon Imp.
        hectoliter,,,,,,,,,hektoliter,,,{0} hektoliter
        jigger,sloki,,,{0} sloki,sloki,,,{0} sloki,jigger,,,{0} sloki
        liter,liter,{0}/L,,{0} L,liter,{0}/L,,{0} L,liter,{0} per liter,,{0} liter
        megaliter,,,,,,,,,megaliter,,,{0} megaliter
        milliliter,,,,,,,,,mililiter,,,{0} mililiter
        pinch,jumput,,,{0} jumput,jumput,,,{0} jumput,jumput,,,{0} jumput
        pint,,,,,pint,,,{0} pt,pint,,,{0} pint
        pint-metric,pt,,,{0} mpt,,,,,metric pint,,,{0} metric pint
        quart,,,,,,,,,quart,,,{0} quart
        quart-imperial,,,,,qt Imp.,,,{0} qt Imp.,quart Imp.,,,{0} quart Imp.
        tablespoon,sdm,,,{0} sdm,sdm,,,{0} sdm,sendok makan,,,{0} sendok makan
        teaspoon,sdt,,,{0} sdt,sdt,,,{0} sdt,sendok teh,,,{0} sendok teh
        byte,B,,,{0} B,,,,,,,,
        grain,gr,,,{0} gr,,,,,,,,
        """.trimIndent()
  }

  private val id_Prefixes: String by lazy {
    """square,,,{0} persegi
        cubic,,,{0} kubik
        per,,,{0} per {1}
        1024p1,,,kibi{0}
        1024p2,,,mebi{0}
        1024p3,,,gibi{0}
        1024p4,,,tebi{0}
        1024p5,,,pebi{0}
        1024p6,,,eksbi{0}
        1024p7,,,zebi{0}
        1024p8,,,yobi{0}
        10p-1,,,desi{0}
        10p-12,,,piko{0}
        10p-15,,,femto{0}
        10p-18,,,atto{0}
        10p-2,,,senti{0}
        10p-21,,,zepto{0}
        10p-24,,,yocto{0}
        10p-27,,,ronto{0}
        10p-3,,,mili{0}
        10p-30,,,quecto{0}
        10p-6,,,mikro{0}
        10p-9,,,nano{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,eksa{0}
        10p2,,,hekto{0}
        10p21,,,zetta{0}
        10p24,,,yotta{0}
        10p27,,,ronna{0}
        10p3,,,kilo{0}
        10p30,,,quetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val ie_Units: String? = null

  private val ie_Prefixes: String? = null

  private val ig_Units: String by lazy {
    """item,ihe,,,{0}ihe,ihe,,,{0} ihe,ihe,,,{0} ihe
        portion-per-1e9,akụkụ/ijeri,,,{0} ppb,akụkụ/ijeri,,,{0} ppb,akụkụ kwa ijeri,,,{0} akụkụ kwa ijeri
        century,,,,,,,,,Ọtụtụ nari afọ,,,{0} Ọtụtụ nari afọ
        day,Ubochi,{0}/d,,{0} Ọtụtụ Ubochi,Ọtụtụ Ubochi,{0}/d,,{0} Ọtụtụ Ubochi,Ọtụtụ Ubochi,{0}/d,,{0} Ọtụtụ Ubochi
        decade,,,,,,,,,Ọtụtụ afọ iri,,,{0} Ọtụtụ afọ iri
        hour,awa,{0}/h,,{0} awa,Ọtụtụ awa,{0}/h,,{0} awa,Ọtụtụ awa,{0}/h,,{0} Ọtụtụ awa
        minute,,,,,,,,,nkeji,{0} kwa nkeji,,{0} nkeji
        month,mon,{0}/m,,{0} mths,mon,{0}/m,,{0} mths,Ọtụtụ Ọnwa,{0} kwa Ọnwa,,{0} Ọnwa
        night,Ọtụtụ abali,{0}/abali,,{0}Ọtụtụ abali,Ọtụtụ abali,{0}/abali,,{0} Ọtụtụ abali,Ọtụtụ abali,{0} kwa abali,,{0} Ọtụtụ abali
        quarter,qtr,{0}/q,,{0}q,qtr,{0}/q,,{0} qtrs,Nkeji Nkeano,{0}/q,,{0}/q
        second,,,,,,,,,sekọnd,{0} kwa sekọnd,,{0} sekọnd
        week,wk,{0}/w,,{0} wks,wk,{0}/w,,{0} wks,Ọtụtụ Izu,{0} kwa Izu,,{0} Ọtụtụ Izu
        year,,,,,,,,,Ọtụtụ Afọ,{0}/y,,{0} Ọtụtụ Afọ
        foodcalorie,Kal,,,{0}Kal,Kal,,,{0} Kal,Kalori,,,{0} Kalori
        dot,ntụpọ,,,{0}ntụpọ,ntụpọ,,,{0} ntụpọ,ntụpọ,,,{0} ntụpọ
        dot-per-centimeter,dpcm,,,{0}dpcm,dpcm,,,{0} dpcm,ntụpọ kwa sentimita,,,{0} ntụpọ kwa sentimita
        dot-per-inch,dpi,,,{0}dpi,dpi,,,{0} nki,ntụpọ kwa inch,,,{0} ntụpọ kwa inch
        megapixel,MP,,,{0}MP,,,,,megapixels,,,{0} MP
        pixel,px,,,{0}px,,,,,px,,,{0} pixels
        pixel-per-centimeter,,,,,,,,,pixels per centimeter,,,{0} pixels per centimeter
        pixel-per-inch,,,,,,,,,pixels per inch,,,{0} pixels per inch
        earth-radius,,,,,,,,,radius uwa,,,{0} R⊕
        beaufort,Bft,,,B{0},,,,,Beaufort,,,Beaufort {0}
        light-speed,ìhè,,,{0}ìhè,ìhè,,,{0} ìhè,ìhè,,,{0} ìhè
        dessert-spoon,ngaji mégharia onu,,,{0} dstspn,ngaji mégharia onu,,,{0} dstspn,ngaji mégharia onu,,,{0} dstspn
        dram,,,,,,,,,mmiri dram,,,{0} dram fl
        drop,dobé,,,{0} drop,dobé,,,{0} drop,dobé,,,{0} drop
        millimole-per-liter,mmol/L,,,{0}mmol/L,,,,,,,,
        permillion,ppm,,,{0}ppm,,,,,,,,
        microsecond,μsec,,,{0}μs,,,,,,,,
        nanosecond,ns,,,{0}ns,,,,,,,,
        calorie,kal,,,{0}kal,,,,,,,,
        newton,N,,,{0}N,,,,,,,,
        em,em,,,{0}em,,,,,,,,
        """.trimIndent()
  }

  private val ig_Prefixes: String by lazy {
    """square,,,{0} sukwia
        cubic,,,{0} kubik
        per,,,{0} per {1}
        10p-1,,,deci{0}
        10p-27,,,ronto{0}
        10p-30,,,kwekto{0}
        10p-6,,,obere{0}
        10p12,,,tera{0}
        10p27,,,ronna{0}
        10p30,,,kwetta{0}
        10p6,,,mega{0}
        10p9,,,giga{0}
        """.trimIndent()
  }

  private val ii_Units: String? = null

  private val ii_Prefixes: String? = null

  private val io_Units: String? = null

  private val io_Prefixes: String? = null

  private val is_Units: String by lazy {
    """g-force,g-hröðun,,{0}G,{0}G,g-hröðun,,,{0} G,þyngdarhröðun,,{0} þyngdarhröðun,{0} þyngdarhraðanir
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,metrar/sek²,,,{0} m/s²,"metrar á sekúndu, á sekúndu",,"{0} metri á sekúndu, á sekúndu","{0} metrar á sekúndu, á sekúndu"
        arc-minute,bogamín.,,{0}′,{0}′,bogamín.,,{0} bogamín.,{0} bogamín.,bogamínútur,,{0} bogamínúta,{0} bogamínútur
        arc-second,bogasek.,,{0}″,{0}″,bogasek.,,{0} bogasek.,{0} bogasek.,bogasekúndur,,{0} bogasekúnda,{0} bogasekúndur
        degree,gráður,,,{0}°,gráður,,,{0}°,gráður,,{0} gráða,{0} gráður
        radian,,,,,,,,,radíanar,,{0} radían,{0} radíanar
        revolution,sn.,,{0} sn.,{0} sn.,sn.,,{0} sn.,{0} sn.,snúningur,,{0} snúningur,{0} snúningar
        acre,ekra,,{0} ek.,{0} ek.,ekrur,,{0} ek.,{0} ek.,ekrur,,{0} ekra,{0} ekrur
        dunam,dúnam,,{0} dúnam,{0} dúnam,dúnöm,,{0} dúnam,{0} dúnam,dúnöm,,{0} dúnam,{0} dúnöm
        hectare,hektari,,,{0} ha,hektarar,,,{0} ha,hektarar,,{0} hektari,{0} hektarar
        square-centimeter,,,,,,,,,fersentimetrar,{0} á fersentimetra,{0} fersentimetri,{0} fersentimetrar
        square-foot,ft²,,{0}ft²,{0}ft²,ferfet,,{0} ferfet,{0} ferfet,ferfet,,{0} ferfet,{0} ferfet
        square-inch,tommur²,{0}/t²,{0} t²,{0} t²,tommur²,{0}/t²,{0} t²,{0} t²,fertommur,{0} á fertommu,{0} fertomma,{0} fertommur
        square-kilometer,,,,,,,,,ferkílómetrar,{0}/km²,{0} ferkílómetri,{0} ferkílómetrar
        square-meter,fermetrar,{0}/m²,,{0} m²,fermetrar,{0}/m²,,{0} m²,fermetrar,{0} á fermetra,{0} fermetri,{0} fermetrar
        square-mile,fermílur,{0}/mi²,{0}mí²,{0}mí²,fermílur,{0}/mi²,{0} fermíla,{0} fermílur,fermílur,{0}/mi²,{0} fermíla,{0} fermílur
        square-yard,,,,,yardar²,,,{0} yd²,feryardar,,{0} feryard,{0} feryardar
        item,atriði,,{0} atriði,{0} atriði,atriði,,{0} atriði,{0} atriði,atriði,,{0} atriði,{0} atriði
        karat,,,,,,,,,karöt,,{0} karat,{0} karöt
        milligram-ofglucose-per-deciliter,mg/dl,,{0}mg/dl,{0}mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligrömm á desílítra,,{0} milligramm á desílítra,{0} milligrömm á desílítra
        millimole-per-liter,mmól/l,,{0}mmól/l,{0}mmól/l,millimól/lítri,,{0} mmól/l,{0} mmól/l,millimól á lítra,,{0} millimól á lítra,{0} millimól á lítra
        mole,mól,,{0} mól,{0} mól,mól,,{0} mól,{0} mól,mól,,{0} mól,{0} mól
        percent,%,,{0}%,{0}%,prósent,,{0}%,{0} %,prósent,,{0} prósent,{0} prósent
        permille,prómill,,,{0}‰,prómill,,,{0}‰,prómill,,{0} prómill,{0} prómill
        permillion,ppm,,{0}ppm,{0}ppm,milljónarhlutar,,,{0} ppm,milljónarhlutar,,{0} milljónarhluti,{0} milljónarhlutar
        permyriad,,,,,permyriad,,,{0}‱,permyriad,,{0} permyriad,{0} permyriad
        portion-per-1e9,,,,,,,,,hlutar á milljarð,,{0} hluti á milljarð,{0} hlutar á milljarð
        liter-per-100-kilometer,l/100km,,{0}l/100km,{0}l/100km,l/100 km,,{0} l/100 km,{0} l/100 km,lítrar á 100 kílómetra,,{0} lítri á 100 kílómetra,{0} lítrar á 100 kílómetra
        liter-per-kilometer,lítrar/km,,{0} l/km,{0} l/km,lítrar/km,,{0} l/km,{0} l/km,lítrar á kílómetra,,{0} lítri á kílómetra,{0} lítrar á kílómetra
        mile-per-gallon,mílur/gallon,,{0} mí./gal.,{0} mí./gal.,mílur/gallon,,{0} mí./gal.,{0} mí./gal.,mílur á gallon,,{0} míla á gallon,{0} mílur á gallon
        mile-per-gallon-imperial,mílur/breskt gal.,,{0} mí./br.g.,{0} mí./br.g.,mílur/breskt gal.,,{0} mí./br.g.,{0} mí./br.g.,mílur á breskt gallon,,{0} míla á breskt gallon,{0} mílur á breskt gallon
        bit,biti,,{0} biti,{0} bitar,biti,,{0} biti,{0} bitar,bitar,,{0} biti,{0} bitar
        byte,bæti,,{0} bæti,{0} bæti,bæti,,{0} bæti,{0} bæti,bæti,,{0} bæti,{0} bæti
        gigabit,,,,,,,,,gígabitar,,{0} gígabiti,{0} gígabitar
        gigabyte,,,,,,,,,gígabæti,,{0} gígabæti,{0} gígabæti
        kilobit,,,,,,,,,kílóbitar,,{0} kílóbiti,{0} kílóbitar
        kilobyte,,,,,,,,,kílóbæti,,{0} kílóbæti,{0} kílóbæti
        megabit,,,,,,,,,megabitar,,{0} megabiti,{0} megabitar
        megabyte,,,,,,,,,megabæti,,{0} megabæti,{0} megabæti
        petabyte,PB,,{0}PB,{0}PB,Pbæt,,,{0} PB,petabæti,,{0} petabæti,{0} petabæti
        terabit,,,,,,,,,terabitar,,{0} terabiti,{0} terabitar
        terabyte,,,,,,,,,terabæti,,{0} terabæti,{0} terabæti
        century,árh,,{0}árh,{0}árh,árh,,{0} árh,{0} árh,aldir,,{0} öld,{0} aldir
        day,dagur,{0}/d.,{0} d.,{0} d.,dagar,{0}/d.,{0} dagur,{0} dagar,dagar,{0} á dag,{0} dagur,{0} dagar
        decade,árat.,,{0} árat.,{0} árat.,árat.,,{0} árat.,{0} árat.,áratugir,,{0} áratugur,{0} áratugir
        hour,klukkustund,{0}/klst.,{0} klst.,{0} klst.,klukkustundir,{0}/klst.,{0} klst.,{0} klst.,klukkustundir,{0} á klst.,{0} klukkustund,{0} klukkustundir
        microsecond,μsek.,,,{0} μs,μsek.,,,{0} μs,míkrósekúndur,,{0} míkrósekúnda,{0} míkrósekúndur
        millisecond,millisek.,,{0}ms,{0}ms,millisek.,,,{0} ms,millisekúndur,,{0} millisekúnda,{0} millisekúndur
        minute,mín.,{0}/mín.,{0} mín.,{0} mín.,mín.,{0}/mín.,{0} mín.,{0} mín.,mínútur,{0} á mínútu,{0} mínúta,{0} mínútur
        month,mánuður,{0}/m,{0} mán.,{0} mán.,mánuðir,{0}/m,{0} mán.,{0} mán.,mánuðir,{0} á mánuði,{0} mánuður,{0} mánuðir
        nanosecond,nanósek.,,,{0} ns,nanósek.,,,{0} ns,nanósekúndur,,{0} nanósekúnda,{0} nanósekúndur
        night,n.,{0}/n.,{0} n.,{0} n.,næt.,{0}/nótt,{0} nótt,{0} næt.,nætur,{0}/nótt,{0} nótt,{0} nætur
        quarter,ársfj.,{0}/ársfj.,{0} ársfj.,{0} ársfj.,ársfj.,{0}/ársfj.,{0} ársfj.,{0} ársfj.,ársfjórðungar,{0}/ársfjórðung,{0} ársfjórðungur,{0} ársfjórðungar
        second,sek.,{0}/sek.,{0} sek.,{0} sek.,sek.,{0}/sek.,{0} sek.,{0} sek.,sekúndur,{0} á sekúndu,{0} sekúnda,{0} sekúndur
        week,vika,{0}/v,{0} v.,{0} v.,vikur,{0}/v,{0} vika,{0} vikur,vikur,{0} á viku,{0} vika,{0} vikur
        year,ár,{0}/ár,{0}á,{0}á,ár,{0}/ári,{0} ár,{0} ár,ár,{0} á ári,{0} ár,{0} ár
        ampere,A,,,{0} A,A,,,{0} A,amper,,{0} amper,{0} amper
        milliampere,,,,,,,,,milliamper,,{0} milliamper,{0} milliamper
        ohm,óm,,,{0} Ω,óm,,,{0} Ω,óm,,{0} óm,{0} óm
        volt,,,,,,,,,volt,,{0} volt,{0} volt
        british-thermal-unit,BTU,,,{0} Btu,BTU,,,{0} Btu,Breskar varmaeiningar,,{0} Bresk varmaeining,{0} Breskar varmaeiningar
        calorie,,,,,,,,,kaloríur,,{0} kaloría,{0} kaloríur
        electronvolt,,,,,rafeindarvolt,,,{0} eV,rafeindarvolt,,{0} rafeindarvolt,{0} rafeindarvolt
        foodcalorie,kal,,{0} kal,{0} kal,kal,,{0} kal,{0} kal,hitaeiningar,,{0} hitaeining,{0} hitaeiningar
        joule,júl,,,{0} J,júl,,,{0} J,júl,,{0} júl,{0} júl
        kilocalorie,,,,,,,,,kílókaloríur,,{0} kílókaloría,{0} kílókaloríur
        kilojoule,,,,,kílójúl,,,{0} kJ,kílójúl,,{0} kílójúl,{0} kílójúl
        kilowatt-hour,,,,,,,,,kílóvattstundir,,{0} kílóvattstund,{0} kílóvattstundir
        therm-us,bandarísk varmaeining,,{0} bna varmaeining,{0} bna varmaeiningar,bandarísk varmaeining,,{0} bna varmaeining,{0} bna varmaeiningar,bandarískar varmaeiningar,,{0} bandarísk varmaeining,{0} bandarískar varmaeiningar
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0} kWh/100km,{0}kWh/100km,,,,,kWh/100km,,{0} kílóvatt á 100 kílómetra,{0} kílóvött á 100 kílómetra
        newton,njúton,,,{0} N,njúton,,,{0} N,njúton,,{0} njúton,{0} njúton
        pound-force,kraftur punds,,,{0} lbf,kraftur punds,,,{0} lbf,kraftar punds,,{0} kraftur punds,{0} kraftar punds
        gigahertz,,,,,,,,,gígahertz,,{0} gígahertz,{0} gígahertz
        hertz,,,,,,,,,hertz,,{0} hertz,{0} hertz
        kilohertz,,,,,,,,,kílóhertz,,{0} kílóhertz,{0} kílóhertz
        megahertz,,,,,,,,,megahertz,,{0} megahertz,{0} megahertz
        dot,punktur,,{0}px,{0}px,punktar,,,,punktar,,{0} pixill,{0} pixlar
        dot-per-centimeter,dpcm,,{0} dpcm,{0} dpcm,dpcm,,{0} dpcm,{0} dpcm,pixlar á sentimetra,,{0} pixill á sentimetra,{0} pixlar á sentimetra
        dot-per-inch,dpi,,{0} dpi,{0} dpi,dpi,,{0} dpi,{0} dpi,pixlar á tommu,,{0} pixill á tommu,{0} pixlar á tommu
        megapixel,megapixlar,,,{0} MP,megapixlar,,,{0} MP,megapixlar,,{0} megapixill,{0} megapixlar
        pixel,,,,,pixlar,,,{0} px,pixlar,,{0} pixill,{0} pixlar
        pixel-per-centimeter,,,,,,,,,pixlar á sentimetra,,{0} pixill á sentimetra,{0} pixlar á sentimetra
        pixel-per-inch,,,,,,,,,pixlar á tommu,,{0} pixill á tommu,{0} pixlar á tommu
        astronomical-unit,se,,{0} se,{0} se,se,,{0} se,{0} se,stjarnfræðieiningar,,{0} stjarnfræðieining,{0} stjarnfræðieiningar
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,sentimetrar,{0} á sentimetra,{0} sentimetri,{0} sentimetrar
        decimeter,,,,,,,,,desimetrar,,{0} desimetri,{0} desimetrar
        earth-radius,,,,,,,,,geisli jarðar,,{0} geisli jarðar,{0} geisli jarðar
        fathom,faðmur,,{0}fth,{0}fth,faðmar,,,{0} fth,faðmar,,{0} faðmur,{0} faðmar
        foot,fet,{0}/fet,{0} fet,{0} fet,fet,{0}/fet,{0} fet,{0} fet,fet,{0} á fet,{0} fet,{0} fet
        furlong,furlong,,{0}fur,{0}fur,furlong,,,{0} fur,furlong,,{0} furlong,{0} furlong
        inch,tommur,{0}/tom,{0}″,{0}″,tommur,{0}/t.,{0} t.,{0} t.,tommur,{0} á tommu,{0} tomma,{0} tommur
        kilometer,,,,,,,,,kílómetrar,{0} á kílómetra,{0} kílómetri,{0} kílómetrar
        light-year,ljósár,,{0} lj.,{0} lj.,ljósár,,{0} ljósár,{0} ljósár,ljósár,,{0} ljósár,{0} ljósár
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,,{0} m,metrar,{0} á metra,{0} metri,{0} metrar
        micrometer,μmetrar,,,{0} μm,μmetrar,,,{0} μm,míkrómetrar,,{0} míkrómetri,{0} míkrómetrar
        mile,mílur,,{0} mí,{0} mí,mílur,,{0} mí,{0} mí,mílur,,{0} míla,{0} mílur
        mile-scandinavian,sæ. míl.,,{0} sæ. míl,{0} sæ. míl,sæ. míl.,,{0} sæ. míl.,{0} sæ. míl.,sænsk míla,,{0} sænsk míla,{0} sænskar mílur
        millimeter,mm,,{0}mm,{0}mm,,,,,millimetrar,,{0} millimetri,{0} millimetrar
        nanometer,,,,,,,,,nanómetrar,,{0} nanómetri,{0} nanómetrar
        nautical-mile,sml,,{0} sml,{0} sml,sml,,{0} sml,{0} sml,sjómílur,,{0} sjómíla,{0} sjómílur
        parsec,parsek,,,{0} pc,parsek,,,{0} pc,parsek,,{0} parsek,{0} parsek
        picometer,,,,,,,,,píkómetrar,,{0} píkómetri,{0} píkómetrar
        point,stig,,{0} stig,{0} stig,stig,,{0} stig,{0} stig,stig,,{0} stig,{0} stig
        solar-radius,sólarradíusar,,{0} Rsól,{0} Rsól,sólarradíusar,,{0} Rsól,{0} Rsól,sólarradíusar,,{0} sólarradíus,{0} sólarradíusar
        yard,yardar,,,{0} yd,yardar,,,{0} yd,yardar,,{0} yard,{0} yardar
        candela,kerti,,{0} kerti,{0} kerti,kerti,,{0} kerti,{0} kerti,kerti,,{0} kerti,{0} kerti
        lumen,,,,,,,,,lúmen,,{0} lúmen,{0} lúmen
        lux,lúx,,,{0} lx,lúx,,,{0} lx,lúx,,{0} lúx,{0} lúx
        solar-luminosity,ljósafl sólar,,{0} Lsól,{0} Lsól,ljósafl sólar,,{0} Lsól,{0} Lsól,ljósafl sólar,,{0} ljósafl sólar,{0} ljósafl sólar
        carat,karöt,,{0} kt.,{0} kt.,karöt,,{0} kt.,{0} kt.,karöt,,{0} karat,{0} karöt
        dalton,dalton,,,{0} Da,dalton,,,{0} Da,dalton,,{0} dalton,{0} dalton
        earth-mass,jarðmassar,,,{0} M⊕,jarðmassar,,,{0} M⊕,jarðmassar,,{0} jarðmassi,{0} jarðmassar
        grain,ögn,,{0} ögn,{0} agnir,ögn,,{0} ögn,{0} agnir,ögn,,{0} ögn,{0} agnir
        gram,g,{0}/g,,{0} g,grömm,{0}/g,,{0} g,grömm,{0} á gramm,{0} gramm,{0} grömm
        kilogram,,,,,,,,,kílógrömm,{0} á kílógramm,{0} kílógramm,{0} kílógrömm
        microgram,,,,,,,,,míkrógrömm,,{0} míkrógramm,{0} míkrógrömm
        milligram,,,,,,,,,milligrömm,,{0} milligramm,{0} milligrömm
        ounce,únsur,{0}/oz,{0} únsa,{0} únsur,,,,,únsur,{0} á únsu,{0} únsa,{0} únsur
        ounce-troy,,,,,troyesoz,,,{0} oz t,troyesúnsur,,{0} troyesúnsa,{0} troyesúnsur
        pound,pund,{0}/lb,{0} p.,{0} p.,pund,{0}/lb,,{0} lb,pund,{0} á pund,{0} pund,{0} pund
        solar-mass,sólmassar,,{0} Msól,{0} Msól,sólmassar,,{0} Msól,{0} Msól,sólmassar,,{0} sólmassi,{0} sólmassar
        stone,stone,,{0}st,{0}st,stones,,,{0} st,stones,,{0} stone,{0} stones
        ton,BNA tonn,,{0}tn,{0}tn,BNA tonn,,{0} BNA tn,{0} BNA tn,bandarísk tonn,,{0} bandarískt tonn,{0} bandarísk tonn
        tonne,t,,{0} t,{0} t,tn,,{0} tn,{0} tn,tonn,,{0} tonn,{0} tonn
        gigawatt,,,,,,,,,gígavött,,{0} gígavatt,{0} gígavött
        horsepower,hö,,{0} hö,{0} hö,hö,,{0} hö,{0} hö,hestöfl,,{0} hestafl,{0} hestöfl
        kilowatt,,,,,,,,,kílóvött,,{0} kílóvatt,{0} kílóvött
        megawatt,,,,,,,,,megavött,,{0} megavatt,{0} megavött
        milliwatt,,,,,,,,,millivött,,{0} millivatt,{0} millivött
        watt,vött,,,{0} W,vött,,,{0} W,vött,,{0} vatt,{0} vött
        atmosphere,,,,,,,,,loftþyngdir,,{0} loftþyngd,{0} loftþyngdir
        bar,bar,,{0} bar,{0} bör,bar,,{0} bar,{0} bör,bör,,{0} bar,{0} bör
        hectopascal,,,,,,,,,hektópasköl,,{0} hektópaskal,{0} hektópasköl
        inch-ofhg,inHg,,{0}'' Hg,{0}'' Hg,to Hg,,{0} to Hg,{0} to Hg,tommur af kvikasilfri,,{0} tomma af kvikasilfri,{0} tommur af kvikasilfri
        kilopascal,,,,,,,,,kílópasköl,,{0} kílópaskal,{0} kílópasköl
        megapascal,,,,,,,,,megapasköl,,{0} megapaskal,{0} megapasköl
        millibar,mbar,,{0} mbar,{0} mbör,mbar,,{0} mbar,{0} mbör,millibör,,{0} millibar,{0} millibör
        millimeter-ofhg,,,,,,,,,millimetrar af kvikasilfri,,{0} millimetri af kvikasilfri,{0} millimetrar af kvikasilfri
        pascal,,,,,,,,,pasköl,,{0} paskal,{0} pasköl
        pound-force-per-square-inch,,,,,,,,,pund á fertommu,,{0} pund á fertommu,{0} pund á fertommu
        beaufort,Bft,,{0}B,{0}B,Bft,,{0} B,{0} B,Beaufort,,{0} Beaufort,{0} Beaufort
        kilometer-per-hour,km/klst.,,{0} km/klst.,{0} km/klst.,kílómetrar á klukkustund,,{0} km/klst.,{0} km/klst.,kílómetrar á klukkustund,,{0} kílómetri á klukkustund,{0} kílómetrar á klukkustund
        knot,,,,,,,,,hnútar,,{0} hnútur,{0} hnútar
        meter-per-second,m/sek.,,,{0} m/s,metrar/sek.,,,{0} m/s,metrar á sekúndu,,{0} metri á sekúndu,{0} metrar á sekúndu
        mile-per-hour,mílur/klst.,,{0} míla/klst.,{0} míl./klst.,mílur/klst.,,{0} míla/klst.,{0} mílur/klst.,mílur á klukkustund,,{0} míla á klukkustund,{0} mílur á klukkustund
        celsius,,,,,gráður á Celsíus,,,{0}°C,gráður á Celsíus,,{0} gráða á Celsíus,{0} gráður á Celsíus
        fahrenheit,,,,,,,,,gráður á Fahrenheit,,{0} gráða á Fahrenheit,{0} gráður á Fahrenheit
        generic,,,,,,,,,°,,{0} gráða,{0} gráður
        kelvin,,,,,,,,,kelvin,,{0} kelvin,{0} kelvin
        newton-meter,,,,,,,,,njútonmetrar,,{0} njútonmetri,{0} njútonmetrar
        pound-force-foot,lbf⋅ft,,{0}lbf⋅ft,{0}lbf⋅ft,,,,,pundfet,,{0} pundfet,{0} pundfet
        acre-foot,ekrufet,,{0} ekrufet,{0} ekrufet,ekrufet,,{0} ekrufet,{0} ekrufet,ekrufet,,{0} ekrufet,{0} ekrufet
        barrel,tunna,,{0} tunna,{0} tunnur,tunna,,{0} tunna,{0} tunnur,tunnur,,{0} tunna,{0} tunnur
        bushel,skeppa,,{0} skeppa,{0} skeppur,skeppur,,{0} skeppa,{0} skeppur,skeppur,,{0} skeppa,{0} skeppur
        centiliter,cl,,{0} cl,{0} cl,cl,,{0} cl,{0} cl,sentilítrar,,{0} sentilítri,{0} sentilítrar
        cubic-centimeter,,,,,,,,,rúmsentimetrar,{0} á rúmsentimetra,{0} rúmsentimetri,{0} rúmsentimetrar
        cubic-foot,fet³,,{0} fet³,{0} fet³,fet³,,{0} fet³,{0} fet³,rúmfet,,{0} rúmfet,{0} rúmfet
        cubic-inch,tommur³,,{0} t³,{0} t³,tommur³,,{0} t³,{0} t³,rúmtommur,,{0} rúmtomma,{0} rúmtommur
        cubic-kilometer,,,,,,,,,rúmkílómetrar,,{0} rúmkílómetri,{0} rúmkílómetrar
        cubic-meter,,,,,,,,,rúmmetrar,{0} á rúmmetra,{0} rúmmetri,{0} rúmmetrar
        cubic-mile,mí³,,{0}mi³,{0}mi³,mí³,,{0} mí³,{0} mí³,rúmmílur,,{0} rúmmíla,{0} rúmmílur
        cubic-yard,yardar³,,,{0} yd³,yardar³,,,{0} yd³,rúmyardar,,{0} rúmyard,{0} rúmyardar
        cup,bolli,,{0} bolli,{0} bollar,bollar,,{0} bolli,{0} bollar,bollar,,{0} bolli,{0} bollar
        cup-metric,ástr. bolli,,{0} ástr. bolli,{0} ástr. bollar,ástr. bolli,,{0} ástr. bolli,{0} ástr. bollar,ástralskir bollar,,{0} ástralskur bolli,{0} ástralskir bollar
        deciliter,dl,,{0} dl,{0} dl,dl,,{0} dl,{0} dl,desilítrar,,{0} desilítri,{0} desilítrar
        dessert-spoon,áb.skeið,,{0} áb.skeið,{0} áb.skeið,ábætissk.,,{0} ábætissk.,{0} ábætissk.,ábætisskeið,,{0} ábætisskeið,{0} ábætisskeið
        dessert-spoon-imperial,br. áb.skeið,,{0} br áb.sk,{0} br áb.sk,bresk ábætissk.,,{0} bresk ábætissk.,{0} bresk ábætissk.,bresk ábætisskeið,,{0} bresk ábætisskeið,{0} bresk ábætisskeið
        dram,dramm,,{0} dramm,{0} drömm,dramm,,{0} dramm,{0} drömm,drömm,,{0} dramm,{0} drömm
        drop,dropi,,{0} dropi,{0} dropar,dropi,,{0} dropi,{0} dropar,dropar,,{0} dropi,{0} dropar
        fluid-ounce,fl oz,,{0} fl oz,{0} fl oz,fl oz,,{0} fl oz,{0} fl oz,vökvaúnsur,,{0} vökvaúnsa,{0} vökvaúnsur
        fluid-ounce-imperial,breskar fl oz,,{0} bresk fl oz,{0} breskar fl oz,breskar fl oz,,{0} bresk fl oz,{0} breskar fl oz,breskar vökvaúnsur,,{0} bresk vökvaúnsa,{0} breskar vökvaúnsur
        gallon,gal,{0}/gal,{0} gal,{0} gal,gal,{0}/gal,{0} gal,{0} gal,gallon,{0} á gallon,{0} gallon,{0} gallon
        gallon-imperial,breskt gal.,{0} breskt gal.,{0} breskt gal.,{0} breskt gal.,breskt gal.,{0} breskt gal.,{0} breskt gal.,{0} breskt gal.,Breskt gallon,{0}/ á breskt gallon,{0} breskt gallon,{0} breskt gallon
        hectoliter,hl,,{0} hl,{0} hl,hl,,{0} hl,{0} hl,hektólítrar,,{0} hektólítri,{0} hektólítrar
        jigger,sjúss,,{0} sjúss,{0} sjússar,sjúss,,{0} sjúss,{0} sjússar,sjússar,,{0} sjúss,{0} sjússar
        liter,lítri,{0}/l,,{0} l,lítrar,{0}/l,,{0} l,lítrar,{0} á lítra,{0} lítri,{0} lítrar
        megaliter,Ml,,{0} Ml,{0} Ml,Ml,,{0} Ml,{0} Ml,megalítrar,,{0} megalítri,{0} megalítrar
        milliliter,ml,,{0} ml,{0} ml,ml,,{0} ml,{0} ml,millilítrar,,{0} millilítri,{0} millilítrar
        pinch,klípa,,{0} klípa,{0} klípur,klípa,,{0} klípa,{0} klípur,klípur,,{0} klípa,{0} klípur
        pint,hálfp.,,{0} hálfp.,{0} hálfp.,hálfp.,,{0} hálfp.,{0} hálfp.,hálfpottar,,{0} hálfpottur,{0} hálfpottar
        quart,,,,,qts,,,{0} qt,kvartar,,{0} kvart,{0} kvartar
        quart-imperial,lagarmál,,{0} l.mál,{0} l.mál,lagarmál,,{0} lagarmál,{0} lagarmál,lagarmál,,{0} lagarmál,{0} lagarmál
        tablespoon,msk,,{0} msk,{0} msk,msk,,{0} msk,{0} msk,matskeiðar,,{0} matskeið,{0} matskeiðar
        teaspoon,tsk,,{0} tsk,{0} tsk,tsk,,{0} tsk,{0} tsk,teskeiðar,,{0} teskeið,{0} teskeiðar
        """.trimIndent()
  }

  private val is_Prefixes: String by lazy {
    """square,,,fer{0}
        cubic,,,rúm{0}
        per,,,{0} á {1}
        1024p1,,,kíbí{0}
        1024p2,,,mebí{0}
        1024p3,,,gíbí{0}
        1024p4,,,tebí{0}
        1024p5,,,pebí{0}
        1024p6,,,exbí{0}
        1024p7,,,sebí{0}
        1024p8,,,jóbe{0}
        10p-1,,,desi{0}
        10p-12,,,píkó{0}
        10p-15,,,femtó{0}
        10p-18,,,attó{0}
        10p-2,,,senti{0}
        10p-21,,,septó{0}
        10p-24,,,jóktó{0}
        10p-27,,rontó{0},rontó{0}
        10p-3,,,milli{0}
        10p-30,k{0},k{0},kvektó{0}
        10p-6,,,míkró{0}
        10p-9,,,nanó{0}
        10p1,,,deka{0}
        10p12,,,tera{0}
        10p15,,,peta{0}
        10p18,,,exa{0}
        10p2,,,hektó{0}
        10p21,,,setta{0}
        10p24,,,jótta{0}
        10p27,,r{0},ronna{0}
        10p3,,kíló{0},kíló{0}
        10p30,k{0},kv{0},kvetta{0}
        10p6,,,mega{0}
        10p9,,,gíga{0}
        """.trimIndent()
  }

  private val it_Units: String by lazy {
    """g-force,G,,{0}G,{0}G,forza g,,,{0} G,forza g,,{0} forza g,{0} forza g
        meter-per-square-second,m/s²,,{0}m/s²,{0}m/s²,,,,,metri al secondo quadrato,,{0} metro al secondo quadrato,{0} metri al secondo quadrato
        arc-minute,′,,,{0}′,′,,,{0}′,primi d’arco,,{0} primo d’arco,{0} primi d’arco
        arc-second,″,,,{0}″,″,,,{0}″,secondi d’arco,,{0} secondo d’arco,{0} secondi d’arco
        degree,°,,,{0}°,°,,,{0}°,gradi,,{0} grado,{0} gradi
        radian,rad,,{0}rad,{0}rad,,,,,radianti,,{0} radiante,{0} radianti
        revolution,riv,,{0}riv,{0}riv,riv,,{0} riv,{0} riv,rivoluzioni,,{0} rivoluzione,{0} rivoluzioni
        acre,ac,,{0}ac,{0}ac,acri,,,{0} ac,acri,,{0} acro,{0} acri
        dunam,dunum,,{0}dunum,{0}dunum,dunum,,{0} dunum,{0} dunum,dunum,,{0} dunum,{0} dunum
        hectare,ha,,{0}ha,{0}ha,ettari,,,{0} ha,ettari,,{0} ettaro,{0} ettari
        square-centimeter,cm²,{0}/cm²,{0}cm²,{0}cm²,,,,,centimetri quadrati,{0} per centimetro quadrato,{0} centimetro quadrato,{0} centimetri quadrati
        square-foot,ft²,,{0}ft²,{0}ft²,piedi quadrati,,,{0} ft²,piedi quadrati,,{0} piede quadrato,{0} piedi quadrati
        square-inch,in²,{0}/in²,{0}in²,{0}in²,,,,,pollici quadrati,{0} per pollice quadrato,{0} pollice quadrato,{0} pollici quadrati
        square-kilometer,km²,{0}/km²,{0}km²,{0}km²,,,,,chilometri quadrati,{0} per chilometro quadrato,{0} chilometro quadrato,{0} chilometri quadrati
        square-meter,m²,{0}/m²,{0}m²,{0}m²,,,,,metri quadrati,{0} per metro quadrato,{0} metro quadrato,{0} metri quadrati
        square-mile,mi²,{0}/mi²,{0}mi²,{0}mi²,,,,,miglia quadrate,{0} per miglio quadrato,{0} miglio quadrato,{0} miglia quadrate
        square-yard,yd²,,{0}yd²,{0}yd²,,,,,iarde quadrate,,{0} iarda quadrata,{0} iarde quadrate
        item,elem.,,{0}elem.,{0}elem.,elem.,,{0} elem.,{0} elem.,elementi,,{0} elemento,{0} elementi
        karat,kt,,{0}kt,{0}kt,,,,,carati,,{0} carato,{0} carati
        milligram-ofglucose-per-deciliter,mg/dl,,{0}mg/dl,{0}mg/dl,mg/dl,,{0} mg/dl,{0} mg/dl,milligrammi per decilitro,,{0} milligrammo per decilitro,{0} milligrammi per decilitro
        millimole-per-liter,mmol/l,,{0}mmol/l,{0}mmol/l,mmol/l,,{0} mmol/l,{0} mmol/l,millimoli per litro,,{0} millimole per litro,{0} millimoli per litro
        mole,mol,,{0}mol,{0}mol,,,,,moli,,{0} mole,{0} moli
        percent,,,,,percento,,,{0}%,percentuale,,{0} percento,{0} percento
        permille,,,,,,,,,per mille,,{0} per mille,{0} per mille
        permillion,ppm,,{0}ppm,{0}ppm,,,,,parti per milione,,{0} parte per milione,{0} parti per milione
        permyriad,,,,,,,,,punto base,,{0} punto base,{0} punti base
        portion-per-1e9,ppb,,{0}ppb,{0}ppb,,,,,parti per miliardo,,{0} parte per miliardo,{0} parti per miliardo
        liter-per-100-kilometer,,,,,,,,,litri per 100 chilometri,,{0} litro per 100 chilometri,{0} litri per 100 chilometri
        liter-per-kilometer,L/km,,{0}L/km,{0}L/km,,,,,litri per chilometro,,{0} litro per chilometro,{0} litri per chilometro
        mile-per-gallon,mpg,,{0}mpg,{0}mpg,mpg,,{0} mpg,{0} mpg,miglia per gallone,,{0} miglio per gallone,{0} miglia per gallone
        mile-per-gallon-imperial,mi/Imp gal,,{0}mi/Imp gal,{0}mi/Imp gal,mi/Imp gal,,{0} mi/Imp gal,{0} mi/Imp gal,miglia per gallone imperiale,,{0} miglio per gallone imperiale,{0} miglia per gallone imperiale
        gigabit,Gb,,{0}Gb,{0}Gb,Gbit,,,{0} Gb,gigabit,,{0} gigabit,{0} gigabit
        gigabyte,GB,,{0}GB,{0}GB,Gbyte,,,{0} GB,gigabyte,,{0} gigabyte,{0} gigabyte
        kilobit,kb,,{0}kb,{0}kb,kbit,,,{0} kb,kilobit,,{0} kilobit,{0} kilobit
        kilobyte,kB,,{0}kB,{0}kB,kbyte,,,{0} kB,kilobyte,,{0} kilobyte,{0} kilobyte
        megabit,Mb,,{0}Mb,{0}Mb,Mbit,,,{0} Mb,megabit,,{0} megabit,{0} megabit
        megabyte,MB,,{0}MB,{0}MB,Mbyte,,,{0} MB,megabyte,,{0} megabyte,{0} megabyte
        petabyte,PB,,{0}PB,{0}PB,Pbyte,,,{0} PB,petabyte,,{0} petabyte,{0} petabyte
        terabit,Tb,,{0}Tb,{0}Tb,Tbit,,,{0} Tb,terabit,,{0} terabit,{0} terabit
        terabyte,TB,,{0}TB,{0}TB,Tbyte,,,{0} TB,terabyte,,{0} terabyte,{0} terabyte
        century,sec.,,{0}sec.,{0}secc.,sec.,,{0} sec.,{0} secc.,secoli,,{0} secolo,{0} secoli
        day,giorno,{0}/g,{0}g,{0}gg,giorni,{0}/giorno,{0} giorno,{0} giorni,giorni,{0} al giorno,{0} giorno,{0} giorni
        decade,dec.,,{0}dec.,{0}dec.,dec.,,{0} dec.,{0} dec.,decadi,,{0} decade,{0} decadi
        hour,ora,{0}/h,{0}h,{0}h,h,{0}/h,,{0} h,ore,{0} all’ora,{0} ora,{0} ore
        microsecond,μs,,{0}μs,{0}μs,,,,,microsecondi,,{0} microsecondo,{0} microsecondi
        millisecond,ms,,{0}ms,{0}ms,,,,,millisecondi,,{0} millisecondo,{0} millisecondi
        minute,min,{0}/min,{0}min,{0}min,,,,,minuti,{0} al minuto,{0} minuto,{0} minuti
        month,mese,{0}/mese,{0} mese,{0} mesi,mesi,{0}/mese,{0} mese,{0} mesi,mesi,{0} al mese,{0} mese,{0} mesi
        nanosecond,ns,,{0}ns,{0}ns,,,,,nanosecondi,,{0} nanosecondo,{0} nanosecondi
        night,notti,{0}/notte,{0} notte,{0} notti,notti,{0}/notte,{0} notte,{0} notti,notti,{0} a notte,{0} notte,{0} notti
        quarter,trim.,{0}/trim.,{0} trim.,{0} trim.,trim.,{0}/trimestre,{0} trim.,{0} trim.,trimestri,{0} al trimestre,{0} trimestre,{0} trimestri
        second,s,{0}/s,{0}s,{0}s,s,{0}/s,,{0} s,secondi,{0} al secondo,{0} secondo,{0} secondi
        week,sett.,{0}/sett.,{0}sett.,{0}sett.,settimane,{0}/settimana,{0} sett.,{0} sett.,settimane,{0} alla settimana,{0} settimana,{0} settimane
        year,anno,{0}/anno,{0}anno,{0}anni,anni,{0}/anno,{0} anno,{0} anni,anni,{0} all’anno,{0} anno,{0} anni
        ampere,A,,{0}A,{0}A,A,,,{0} A,ampere,,{0} ampere,{0} ampere
        milliampere,mA,,{0}mA,{0}mA,,,,,milliampere,,{0} milliampere,{0} milliampere
        ohm,Ω,,{0}Ω,{0}Ω,Ω,,,{0} Ω,ohm,,{0} ohm,{0} ohm
        volt,V,,{0}V,{0}V,V,,,{0} V,volt,,{0} volt,{0} volt
        british-thermal-unit,BTU,,{0}BTU,{0}BTU,BTU,,{0} BTU,{0} BTU,unità termiche britanniche,,{0} unità termica britannica,{0} unità termiche britanniche
        calorie,cal,,{0}cal,{0}cal,,,,,calorie,,{0} caloria,{0} calorie
        electronvolt,eV,,{0}eV,{0}eV,,,,,elettronvolt,,{0} elettronvolt,{0} elettronvolt
        foodcalorie,Cal,,{0}Cal,{0}Cal,Cal,,{0} Cal,{0} Cal,Calorie,,{0} Caloria,{0} Calorie
        joule,J,,{0}J,{0}J,J,,,{0} J,joule,,{0} joule,{0} joule
        kilocalorie,kcal,,{0}kcal,{0}kcal,,,,,chilocalorie,,{0} chilocaloria,{0} chilocalorie
        kilojoule,kJ,,{0}kJ,{0}kJ,,,,,kilojoule,,{0} kilojoule,{0} kilojoule
        kilowatt-hour,kWh,,{0}kWh,{0}kWh,,,,,chilowattora,,{0} chilowattora,{0} chilowattora
        therm-us,therm US,,{0}therm US,{0}therm US,therm US,,{0} therm US,{0} therm US,therm US,,{0} therm US,{0} therm US
        kilowatt-hour-per-100-kilometer,kWh/100km,,{0}kWh/100km,{0}kWh/100km,,,,,chilowattora per 100 chilometri,,{0} chilowattora per 100 chilometri,{0} chilowattora per 100 chilometri
        newton,N,,{0}N,{0}N,,,,,newton,,{0} newton,{0} newton
        pound-force,lbf,,{0}lbf,{0}lbf,,,,,libbre-forza,,{0} libbra-forza,{0} libbre-forza
        gigahertz,GHz,,{0}GHz,{0}GHz,,,,,gigahertz,,{0} gigahertz,{0} gigahertz
        hertz,Hz,,{0}Hz,{0}Hz,,,,,hertz,,{0} hertz,{0} hertz
        kilohertz,kHz,,{0}kHz,{0}kHz,,,,,kilohertz,,{0} kilohertz,{0} kilohertz
        megahertz,MHz,,{0}MHz,{0}MHz,,,,,megahertz,,{0} megahertz,{0} megahertz
        dot,punto,,{0}p,{0}p,punti,,{0} p,{0} p,punti,,{0} punto,{0} punti
        dot-per-centimeter,dpcm,,{0}dpcm,{0}dpcm,dpcm,,{0} dpcm,{0} dpcm,punti per centimetro,,{0} punto per centimetro,{0} punti per centimetro
        dot-per-inch,dpi,,{0}dpi,{0}dpi,dpi,,{0} dpi,{0} dpi,punti per pollice,,{0} punto per pollice,{0} punti per pollice
        em,em,,{0}em,{0}em,,,,,em tipografica,,,{0} em
        megapixel,MP,,{0}MP,{0}MP,,,,,megapixel,,{0} megapixel,{0} megapixel
        pixel,px,,{0}px,{0}px,,,,,pixel,,{0} pixel,{0} pixel
        pixel-per-centimeter,ppcm,,{0}ppcm,{0}ppcm,,,,,pixel per centimetro,,{0} pixel per centimetro,{0} pixel per centimetro
        pixel-per-inch,ppi,,{0}ppi,{0}ppi,,,,,pixel per pollice,,{0} pixel per pollice,{0} pixel per pollice
        astronomical-unit,au,,{0}au,{0}au,,,,,unità astronomiche,,{0} unità astronomica,{0} unità astronomiche
        centimeter,cm,{0}/cm,{0}cm,{0}cm,,,,,centimetri,{0} per centimetro,{0} centimetro,{0} centimetri
        decimeter,dm,,{0}dm,{0}dm,,,,,decimetri,,{0} decimetro,{0} decimetri
        earth-radius,R⊕,,{0}R⊕,{0}R⊕,,,,,raggi terrestri,,{0} raggio terrestre,{0} raggi terrestri
        fathom,fm,,{0}fm,{0}fm,fm,,{0} fm,{0} fm,braccia,,{0} braccio,{0} braccia
        foot,ft,{0}/ft,{0}ft,{0}ft,,,,,piedi,{0} per piede,{0} piede,{0} piedi
        furlong,fur,,{0}fur,{0}fur,,,,,furlong,,{0} furlong,{0} furlong
        inch,in,{0}/in,{0}″,{0}″,,,,,pollici,{0} per pollice,{0} pollice,{0} pollici
        kilometer,km,{0}/km,{0}km,{0}km,,,,,chilometri,{0} per chilometro,{0} chilometro,{0} chilometri
        light-year,al,,{0}al,{0}al,al,,{0} al,{0} al,anni luce,,{0} anno luce,{0} anni luce
        meter,m,{0}/m,{0}m,{0}m,m,{0}/m,,{0} m,metri,{0} per metro,{0} metro,{0} metri
        micrometer,μm,,{0}μm,{0}μm,,,,,micrometri,,{0} micrometro,{0} micrometri
        mile,mi,,{0}mi,{0}mi,miglia,,,{0} mi,miglia,,{0} miglio,{0} miglia
        mile-scandinavian,smi,,{0}smi,{0}smi,,,,,miglia scandinave,,{0} miglio scandinavo,{0} miglia scandinave
        millimeter,mm,,{0}mm,{0}mm,,,,,millimetri,,{0} millimetro,{0} millimetri
        nanometer,nm,,{0}nm,{0}nm,,,,,nanometri,,{0} nanometro,{0} nanometri
        nautical-mile,nmi,,{0}nmi,{0}nmi,,,,,miglia nautiche,,{0} miglio nautico,{0} miglia nautiche
        parsec,pc,,{0}pc,{0}pc,,,,,parsec,,{0} parsec,{0} parsec
        picometer,pm,,{0}pm,{0}pm,,,,,picometri,,{0} picometro,{0} picometri
        point,pt,,{0}pt,{0}pt,,,,,punti tipografici,,{0} punto tipografico,{0} punti tipografici
        solar-radius,R☉,,{0}R☉,{0}R☉,,,,,raggi solari,,{0} raggio solare,{0} raggi solari
        yard,yd,,{0}yd,{0}yd,iarde,,,{0} yd,iarde,,{0} iarda,{0} iarde
        candela,cd,,{0}cd,{0}cd,,,,,candele,,{0} candela,{0} candele
        lumen,lm,,{0}lm,{0}lm,,,,,lumen,,{0} lumen,{0} lumen
        lux,lx,,{0}lx,{0}lx,,,,,lux,,{0} lux,{0} lux
        solar-luminosity,L☉,,{0}L☉,{0}L☉,,,,,luminosità solari,,{0} luminosità solare,{0} luminosità solari
        carat,kt,,{0}kt,{0}kt,carati,,{0} kt,{0} kt,carati,,{0} carato,{0} carati
        dalton,Da,,{0}Da,{0}Da,,,,,dalton,,{0} dalton,{0} dalton
        earth-mass,M⊕,,{0}M⊕,{0}M⊕,,,,,masse terrestri,,{0} massa terrestre,{0} masse terrestri
        grain,grano,,{0}grano,{0}grani,grano,,{0} grano,{0} grani,grani,,{0} grano,{0} grani
        gram,g,{0}/g,{0}g,{0}g,grammi,{0}/g,,{0} g,grammi,{0} per grammo,{0} grammo,{0} grammi
        kilogram,kg,{0}/kg,{0}kg,{0}kg,,,,,chilogrammi,{0} per chilogrammo,{0} chilogrammo,{0} chilogrammi
        microgram,μg,,{0}μg,{0}μg,,,,,microgrammi,,{0} microgrammo,{0} microgrammi
        milligram,mg,,{0}mg,{0}mg,,,,,milligrammi,,{0} milligrammo,{0} milligrammi
        ounce,oz,{0}/oz,{0}oz,{0}oz,,,,,once,{0} per oncia,{0} oncia,{0} once
        ounce-troy,ozt,,{0}ozt,{0}ozt,ozt,,{0} ozt,{0} ozt,once troy,,{0} oncia troy,{0} once troy
        pound,lb,{0}/lb,{0}lb,{0}lb,,,,,libbre,{0} per libbra,{0} libbra,{0} libbre
        solar-mass,M☉,,{0}M☉,{0}M☉,,,,,masse solari,,{0} massa solare,{0} masse solari
        stone,st,,{0}st,{0}st,,,,,stone,,{0} stone,{0} stone
        ton,tn,,{0}tn,{0}tn,,,,,tonnellate,,{0} tonnellata,{0} tonnellate
        tonne,t,,{0}t,{0}t,,,,,tonnellate metriche,,{0} tonnellata metrica,{0} tonnellate metriche
        gigawatt,GW,,{0}GW,{0}GW,,,,,gigawatt,,{0} gigawatt,{0} gigawatt
        horsepower,hp,,{0}hp,{0}hp,,,,,cavalli vapore,,{0} cavallo vapore,{0} cavalli vapore
        kilowatt,kW,,{0}kW,{0}kW,,,,,kilowatt,,{0} kilowatt,{0} kilowatt
        megawatt,MW,,{0}MW,{0}MW,,,,,megawatt,,{0} megawatt,{0} megawatt
        milliwatt,mW,,{0}mW,{0}mW,,,,,milliwatt,,{0} milliwatt,{0} milliwatt
        watt,W,,{0}W,{0}W,W,,,{0} W,watt,,{0} watt,{0} watt
        atmosphere,atm,,{0}atm,{0}atm,,,,,atmosfere,,{0} atmosfera,{0} atmosfere
        hectopascal,hPa,,{0}hPa,{0}hPa,,,,,ettopascal,,{0} ettopascal,{0} ettopascal
        inch-ofhg,inHg,,{0}inHg,{0}inHg,,,,,pollici di mercurio,,{0} pollice di mercurio,{0} pollici di mercurio
        kilopascal,kPa,,{0}kPa,{0}kPa,,,,,chilopascal,,{0} chilopascal,{0} chilopascal
        megapascal,MPa,,{0}MPa,{0}MPa,,,,,megapascal,,{0} megapascal,{0} megapascal
        millibar,mbar,,{0}mbar,{0}mbar,,,,,millibar,,{0} millibar,{0} millibar
        millimeter-ofhg,mm Hg,,{0}mm Hg,{0}mm Hg,,,,,millimetri di mercurio,,{0} millimetro di mercurio,{0} millimetri di mercurio
        pascal,Pa,,{0}Pa,{0}Pa,,,,,pascal,,{0} pascal,{0} pascal
        pound-force-per-square-inch,psi,,{0}psi,{0}psi,,,,,libbre per pollice quadrato,,{0} libbra per pollice quadrato,{0} libbre per pollice quadrato
        beaufort,Bft,,Bft{0},Bft{0},Bft,,Bft {0},Bft {0},Beaufort,,Beaufort {0},Beaufort {0}
        kilometer-per-hour,km/h,,{0}km/h,{0}km/h,,,,,chilometri orari,,{0} chilometro orario,{0} chilometri orari
        knot,kn,,{0}kn,{0}kn,,,,,nodi,,{0} nodo,{0} nodi
        light-speed,light,,{0}l,{0}l,light,,{0} luce,{0} luce,light,,{0} alla velocità della luce,{0} alla velocità della luce
        meter-per-second,m/s,,{0}m/s,{0}m/s,,,,,metri al secondo,,{0} metro al secondo,{0} metri al secondo
        mile-per-hour,mi/h,,{0}mi/h,{0}mi/h,,,,,miglia all’ora,,{0} miglio all’ora,{0} miglia all’ora
        celsius,°C,,{0}°C,{0}°C,°C,,{0} °C,{0} °C,gradi Celsius,,{0} grado Celsius,{0} gradi Celsius
        fahrenheit,°F,,{0}°F,{0}°F,°F,,{0} °F,{0} °F,gradi Fahrenheit,,{0} grado Fahrenheit,{0} gradi Fahrenheit
        generic,,,,,,,,,gradi,,{0} grado,{0} gradi
        kelvin,K,,{0}K,{0}K,,,,,Kelvin,,{0} Kelvin,{0} Kelvin
        newton-meter,Nm,,{0}Nm,{0}Nm,Nm,,{0} Nm,{0} Nm,newton metri,,{0} newton metro,{0} newton metri
        pound-force-foot,lb-ft,,{0}lb-ft,{0}lb-ft,lb-ft,,{0} lb-ft,{0} lb-ft,libbre-forza piede,,{0} libbra-forza piede,{0} libbre-forza piede
        acre-foot,ac ft,,{0}ac ft,{0}ac ft,,,,,piedi acro,,{0} piede acro,{0} piedi acro
        barrel,bbl,,{0}bbl,{0}bbl,barile,,,{0} bbl,barili,,{0} barile,{0} barili
        bushel,bu,,{0}bu,{0}bu,staia,,,{0} bu,staia,,{0} staio,{0} staia
        centiliter,cl,,{0}cl,{0}cl,cl,,{0} cl,{0} cl,centilitri,,{0} centilitro,{0} centilitri
        cubic-centimeter,cm³,{0}/cm³,{0}cm³,{0}cm³,,,,,centimetri cubi,{0} per centimetro cubo,{0} centimetro cubo,{0} centimetri cubi
        cubic-foot,ft³,,{0}ft³,{0}ft³,,,,,piedi cubi,,{0} piede cubo,{0} piedi cubi
        cubic-inch,in³,,{0}in³,{0}in³,,,,,pollici cubi,,{0} pollice cubo,{0} pollici cubi
        cubic-kilometer,km³,,{0}km³,{0}km³,,,,,chilometri cubi,,{0} chilometro cubo,{0} chilometri cubi
        cubic-meter,m³,{0}/m³,{0}m³,{0}m³,,,,,metri cubi,{0} per metro cubo,{0} metro cubo,{0} metri cubi
        cubic-mile,mi³,,{0}mi³,{0}mi³,,,,,miglia cubiche,,{0} miglio cubo,{0} miglia cubiche
        cubic-yard,yd³,,{0}yd³,{0}yd³,,,,,iarde cubiche,,{0} iarda cubica,{0} iarde cubiche
        cup,c,,{0}c,{0}c,c,,,{0} c,tazze,,{0} tazza,{0} tazze
        cup-metric,mc,,{0}mc,{0}mc,,,,,tazze metriche,,{0} tazza metrica,{0} tazze metriche
        deciliter,dl,,{0}dl,{0}dl,dl,,{0} dl,{0} dl,decilitri,,{0} decilitro,{0} decilitri
        dessert-spoon,dstspn,,{0}dstspn,{0}dstspn,,,,,cucchiaini da dessert,,{0} cucchiaino da dessert,{0} cucchiaini da dessert
        dessert-spoon-imperial,dstspn im,,{0}dstspn im,{0}dstspn im,,,,,cucchiaini da dessert imperiali,,{0} cucchiaino da dessert imperiale,{0} cucchiaini da dessert imperiali
        dram,dr liq,,{0}dr liq,{0}dr liq,dramma liquida,,{0} dr liq,{0} dr liq,dramme,,{0} dramma,{0} dramme
        drop,goccia,,{0}goccia,{0}gocce,goccia,,{0} goccia,{0} gocce,gocce,,{0} goccia,{0} gocce
        fluid-ounce,fl oz,,{0}fl oz,{0}fl oz,fl oz,,{0} fl oz,{0} fl oz,once liquide,,{0} oncia liquida,{0} once liquide
        fluid-ounce-imperial,fl oz im,,{0}fl oz im,{0}fl oz im,fl oz imp.,,{0} fl oz imp.,{0} fl oz imp.,once liquide imperiali,,{0} oncia liquida imperiale,{0} once liquide imperiali
        gallon,gal,{0}/gal,{0}gal,{0}gal,gal,{0}/gal,{0} gal,{0} gal,galloni,{0} per gallone,{0} gallone,{0} galloni
        gallon-imperial,gal im,{0}/gal im,{0}gal im,{0}gal im,gal imp.,{0}/gal imp.,{0} gal imp.,{0} gal imp.,galloni imperiali,{0} per gallone imperiale,{0} gallone imperiale,{0} galloni imperiali
        hectoliter,hl,,{0}hl,{0}hl,hl,,{0} hl,{0} hl,ettolitri,,{0} ettolitro,{0} ettolitri
        liter,l,{0}/l,{0}l,{0}l,l,{0}/l,,{0} l,litri,{0} per litro,{0} litro,{0} litri
        megaliter,Ml,,{0}Ml,{0}Ml,Ml,,{0} Ml,{0} Ml,megalitri,,{0} megalitro,{0} megalitri
        milliliter,ml,,{0}ml,{0}ml,ml,,{0} ml,{0} ml,millilitri,,{0} millilitro,{0} millilitri
        pinch,pizzico,,{0}pizzico,{0}pizzichi,pizzico,,{0} pizzico,{0} pizzichi,pizzichi,,{0} pizzico,{0} pizzichi
        pint,pt,,{0}pt,{0}pt,,,,,pinte,,{0} pinta,{0} pinte
        pint-metric,mpt,,{0}mpt,{0}mpt,,,,,pinte metriche,,{0} pinta metrica,{0} pinte metriche
        quart,qt,,{0}qt,{0}qt,,,,,quarti,,{0} quarto,{0} quarti
        quart-imperial,imp qt,,{0}imp qt,{0}i