package net.codinux.i18n

import kotlin.String

/**
 * Had to switch from Map<String, String> to CSV as compiler complained about too many parameters in function, wasmJs didn't even start in release build
 */
object LanguageDisplayNames {
  val ab: String by lazy { """
      ab:Аԥсшәа
      """.trimIndent() }

  val af: String by lazy { """
      aa:Afar
      ab:Abkasies
      ace:Atsjenees
      ach:Akoli
      ada:Adangme
      ady:Adyghe
      af:Afrikaans
      agq:Aghem
      ain:Ainu
      ak:Akan
      ale:Aleut
      alt:Suid-Altai
      am:Amharies
      an:Aragonees
      ann:Obolo
      anp:Angika
      ar:Arabies
      ar-001:Moderne Standaardarabies
      arc:Aramees
      arn:Mapuche
      arp:Arapaho
      ars:Najdi-Arabies
      as:Assamees
      asa:Asu
      ast:Asturies
      atj:Atikamekw
      av:Avaries
      awa:Awadhi
      ay:Aymara
      az:Azerbeidjans
      az-alt-short:Azeri
      ba:Baskir
      ban:Balinees
      bas:Basaa
      be:Belarussies
      bem:Bemba
      bez:Bena
      bg:Bulgaars
      bgc:Haryanvi
      bgn:Wes-Balochi
      bho:Bhojpuri
      bi:Bislama
      bin:Bini
      bla:Siksika
      blo:Anii
      bm:Bambara
      bn:Bengaals
      bo:Tibettaans
      br:Bretons
      brx:Bodo
      bs:Bosnies
      bug:Buginees
      byn:Blin
      ca:Katalaans
      cay:Cayuga
      ccp:Tsjaakma
      ce:Tsjetsjeens
      ceb:Cebuano
      cgg:Kiga
      ch:Chamorro
      chk:Chuukees
      chm:Mari
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokees
      chy:Cheyennees
      ckb:Sorani
      ckb-alt-menu:Sorani
      ckb-alt-variant:Koerdies Sorani
      clc:Tzilkotin
      co:Korsikaans
      cop:Kopties
      crg:Michif
      crj:Suidoos-Cree
      crk:Laagvlakte-Cree
      crl:Noordoos-Cree
      crm:Moose Cree
      crr:Carolina-Algonkin
      crs:Seselwa Franskreools
      cs:Tsjeggies
      csw:Swampy Cree
      cu:Kerkslawies
      cv:Chuvash
      cy:Wallies
      da:Deens
      dak:Dakotaans
      dar:Dakota
      dav:Taita
      de:Duits
      dgr:Dogrib
      dje:Zarma
      doi:Dogri
      dsb:Nedersorbies
      dua:Duala
      dv:Divehi
      dyo:Jola-Fonyi
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      egy:Antieke Egipties
      eka:Ekajuk
      el:Grieks
      en:Engels
      en-GB:Engels (VK)
      en-GB-alt-short:Engels (VK)
      en-US:Engels (VSA)
      en-US-alt-short:Engels (VSA)
      eo:Esperanto
      es:Spaans
      et:Estnies
      eu:Baskies
      ewo:Ewondo
      fa:Persies
      fa-AF:Dari
      ff:Fulah
      fi:Fins
      fil:Filippyns
      fj:Fidjiaans
      fo:Faroëes
      fon:Fon
      fr:Frans
      frc:Cajun
      frr:Noord-Fries
      fur:Friuliaans
      fy:Fries
      ga:Iers
      gaa:Gaa
      gag:Gagauz
      gan:Gan-Sjinees
      gd:Skotse Gallies
      gez:Geez
      gil:Gilbertees
      gl:Galisies
      gn:Guarani
      gor:Gorontalo
      got:Goties
      grc:Antieke Grieks
      gsw:Switserse Duits
      gu:Goedjarati
      guz:Gusii
      gv:Manx
      gwi:Gwichʼin
      ha:Hausa
      hai:Haida
      hak:Hakka-Sjinees
      haw:Hawais
      hax:Suid-Haida
      he:Hebreeus
      hi:Hindi
      hi-Latn-alt-variant:Hingels
      hil:Hiligaynon
      hit:Hetities
      hmn:Hmong
      hr:Kroaties
      hsb:Oppersorbies
      hsn:Xiang-Sjinees
      ht:Haïtiaans
      hu:Hongaars
      hup:Hupa
      hur:Halkomelem
      hy:Armeens
      hz:Herero
      ia:Interlingua
      iba:Ibanees
      ibb:Ibibio
      id:Indonesies
      ie:Interlingue
      ig:Igbo
      ii:Sichuan Yi
      ikt:Wes-Kanadese Inoektitoet
      ilo:Iloko
      inh:Ingush
      io:Ido
      is:Yslands
      it:Italiaans
      iu:Inoektitoet
      ja:Japannees
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jv:Javaans
      ka:Georgies
      kab:Kabyle
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kbd:Kabardiaans
      kcg:Tyap
      kde:Makonde
      kea:Kabuverdianu
      kfo:Koro
      kg:Kongolees
      kgp:Kaingang
      kha:Khasi
      khq:Koyra Chiini
      ki:Kikuyu
      kj:Kuanyama
      kk:Kazaks
      kkj:Kako
      kl:Kalaallisut
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Koreaans
      koi:Komi-Permyaks
      kok:Konkani
      kpe:Kpellees
      kr:Kanuri
      krc:Karachay-Balkar
      krl:Karelies
      kru:Kurukh
      ks:Kasjmiri
      ksb:Shambala
      ksf:Bafia
      ksh:Keuls
      ku:Koerdies
      kum:Kumyk
      kv:Komi
      kw:Kornies
      kwk:Kwak’wala
      kxv:Kuvi
      ky:Kirgisies
      la:Latyn
      lad:Ladino
      lag:Langi
      lb:Luxemburgs
      lez:Lezghies
      lg:Ganda
      li:Limburgs
      lij:Liguries
      lil:Lillooet
      lkt:Lakota
      lmo:Lombardies
      ln:Lingaals
      lo:Lao
      lou:Louisiana Kreool
      loz:Lozi
      lrc:Noord-Luri
      lsm:Saamia
      lt:Litaus
      lu:Luba-Katanga
      lua:Luba-Lulua
      lun:Lunda
      luo:Luo
      lus:Mizo
      luy:Luyia
      lv:Letties
      mad:Madurees
      mag:Magahi
      mai:Maithili
      mak:Makasar
      mas:Masai
      mdf:Moksha
      men:Mende
      mer:Meru
      mfe:Morisjen
      mg:Malgassies
      mgh:Makhuwa-Meetto
      mgo:Meta’
      mh:Marshallees
      mi:Maori
      mic:Micmac
      min:Minangkabaus
      mk:Masedonies
      ml:Malabaars
      mn:Mongools
      mni:Manipuri
      moe:Innu-aimun
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      ms:Maleis
      mt:Maltees
      mua:Mundang
      mul:Verskeie tale
      mus:Kreek
      mwl:Mirandees
      my:Birmaans
      myv:Erzya
      mzn:Masanderani
      na:Nauru
      nan:Min Nan-Sjinees
      nap:Neapolitaans
      naq:Nama
      nb:Boeknoors
      nd:Noord-Ndebele
      nds:Nederduits
      nds-NL:Nedersaksies
      ne:Nepalees
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niueaans
      nl:Nederlands
      nl-BE:Vlaams
      nmg:Kwasio
      nn:Nuwe Noors
      nnh:Ngiemboon
      no:Noors
      nog:Nogai
      nqo:N’Ko
      nr:Suid-Ndebele
      nso:Noord-Sotho
      nus:Nuer
      nv:Navajo
      ny:Nyanja
      nyn:Nyankole
      oc:Oksitaans
      ojb:Noordwes-Ojibwa
      ojc:Sentraal-Ojibwa
      ojs:Oji-Cree
      ojw:Wes-Ojibwa
      oka:Okanagan
      om:Oromo
      or:Oriya
      os:Osseties
      pa:Pandjabi
      pag:Pangasinan
      pam:Pampanga
      pap:Papiamento
      pau:Palauaans
      pcm:Nigeriese Pidgin
      phn:Fenisies
      pis:Pijin
      pl:Pools
      pqm:Maliseet-Passamaquoddy
      prg:Pruisies
      ps:Pasjtoe
      pt:Portugees
      qu:Quechua
      quc:K’iche’
      raj:Rajasthani
      rap:Rapanui
      rar:Rarotongaans
      rhg:Rohingya
      rm:Reto-Romaans
      rn:Rundi
      ro:Roemeens
      rof:Rombo
      ru:Russies
      rup:Aromanies
      rw:Rwandees
      rwk:Rwa
      sa:Sanskrit
      sad:Sandawees
      sah:Jakoeties
      saq:Samburu
      sat:Santalies
      sba:Ngambay
      sbp:Sangu
      sc:Sardinies
      scn:Sisiliaans
      sco:Skots
      sd:Sindhi
      sdh:Suid-Koerdies
      se:Noord-Sami
      seh:Sena
      ses:Koyraboro Senni
      sg:Sango
      sh:Serwo-Kroaties
      shi:Tachelhit
      shn:Shan
      si:Sinhala
      sk:Slowaaks
      sl:Sloweens
      slh:Suid-Lushootseed
      sm:Samoaans
      sma:Suid-Sami
      smj:Lule Sami
      smn:Inari Sami
      sms:Skolt Sami
      sn:Shona
      snk:Soninke
      so:Somalies
      sq:Albanees
      sr:Serwies
      srn:Sranan Tongo
      ss:Swazi
      ssy:Saho
      st:Suid-Sotho
      str:Straits Salish
      su:Sundanees
      suk:Sukuma
      sv:Sweeds
      sw:Swahili
      swb:Comoraans
      syr:Siries
      szl:Silesies
      ta:Tamil
      tce:Suid-Tutchone
      te:Teloegoe
      tem:Timne
      teo:Teso
      tet:Tetoem
      tg:Tadjiks
      tgx:Tagish
      th:Thai
      tht:Tahltan
      ti:Tigrinja
      tig:Tigre
      tk:Turkmeens
      tlh:Klingon
      tli:Tlingit
      tn:Tswana
      to:Tongaans
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Turks
      trv:Taroko
      ts:Tsonga
      tt:Tataars
      ttm:Noord-Tutchone
      tum:Toemboeka
      tvl:Tuvalu
      tw:Twi
      twq:Tasawaq
      ty:Tahities
      tyv:Tuvinees
      tzm:Sentraal-Atlas-Tamazight
      udm:Udmurt
      ug:Uighur
      uk:Oekraïens
      umb:Umbundu
      und:Onbekende taal
      ur:Oerdoe
      uz:Oesbekies
      vai:Vai
      ve:Venda
      vec:Venesiaans
      vi:Viëtnamees
      vmw:Makhuwa
      vo:Volapük
      vun:Vunjo
      wa:Walloon
      wae:Walser
      wal:Wolaytta
      war:Waray
      wbp:Warlpiri
      wo:Wolof
      wuu:Wu-Sjinees
      xal:Kalmyk
      xh:Xhosa
      xnr:Kangri
      xog:Soga
      yav:Yangben
      ybb:Yemba
      yi:Jiddisj
      yo:Joroeba
      yrl:Nheengatu
      yue:Kantonees
      yue-alt-menu:Kantonese Chinees
      za:Zhuang
      zgh:Standaard Marokkaanse Tamazight
      zh:Chinees
      zh-alt-menu:Mandarynse Chinees
      zh-Hans-alt-long:Mandarynse Chinees (Vereenvoudig)
      zh-Hant-alt-long:Mandarynse Chinees (Tradisioneel)
      zu:Zoeloe
      zun:Zuni
      zxx:Geen taalinhoud nie
      zza:Zaza
      """.trimIndent() }

  val af_NA: String? = null

  val agq: String by lazy { """
      agq:Aghem
      ak:Akan
      am:Àmalì
      ar:Àlabì
      be:Bɛ̀làlusàn
      bg:Bùugɨlìa
      bn:Bɨ̀ŋgalì
      cs:Chɛ̂
      de:Dzamɛ̀
      el:Gɨ̀lêʔ
      en:Kɨŋgele
      es:Sɨ̀kpanìs
      fa:Kpɛɛshìa
      fr:Kɨ̀fàlàŋsi
      ha:Kɨtsɔŋkaŋ
      hi:Endì
      hu:Hɔŋgalìa
      id:Èndònɛshìa
      ig:Egbò
      it:Ètalìa
      ja:Dzàkpànê
      jv:Dzàbvànê
      km:Kɨmɛ̀
      ko:kùulîa
      ms:Màlae
      my:Bùumɛsɛ̀
      ne:Nɛ̀kpalì
      nl:Dɔ̂s
      pa:Kpuwndzabì
      pl:Kpɔlìs
      pt:Kpotùwgîi
      ro:Lùmanyìa
      ru:Lushìa
      rw:Lùwandà
      so:Sòmalì
      sv:Suedìs
      ta:Tamì
      th:Tàe
      tr:Tʉʉkìs
      uk:Ùkɛlɛnìa
      ur:Uudùw
      vi:Vìyɛtnàmê
      yo:Yulùba
      zh:Chàenê
      zh-alt-menu:Chàenê
      zu:Zulù
      """.trimIndent() }

  val ak: String by lazy { """
      af:Afrikaans
      ak:Akan
      am:Amarik
      ar:Arabeke
      ar-001:Arabeke Kasa Nhyehyɛeɛ Foforɔ
      as:Asamese
      ast:Asturiani
      az:Asabegyanni
      az-alt-short:Asabegyanni
      be:Belarus kasa
      bg:Bɔlgeria kasa
      bgc:Harianvi
      bho:Bopuri
      blo:Anii
      bn:Bengali kasa
      br:Britenni
      brx:Bodo
      bs:Bosniani
      ca:Katalan
      ceb:Kebuano
      chr:Kiroki
      cs:Kyɛk kasa
      csw:Tadeɛm Kreefoɔ Kasa
      cv:Kyuvahyi
      cy:Wɛɛhye Kasa
      da:Dane kasa
      de:Gyaaman
      de-AT:Ɔstria Gyaaman
      de-CH:Swisalande Gyaaman
      doi:Dɔgri
      dsb:Sɔɔbia a ɛwɔ fam
      el:Greek kasa
      en:Borɔfo
      en-GB:Ngresi Borɔfo
      en-GB-alt-short:Ngresi Borɔfo
      en-US:Amɛrika Borɔfo
      en-US-alt-short:Amɛrika Borɔfo
      eo:Esperanto
      es:Spain kasa
      es-419:Spain kasa (Laaten Amɛrika)
      et:Estonia kasa
      eu:Baske
      fa:Pɛɛhyia kasa
      ff:Fula kasa
      fi:Finlande kasa
      fil:Filipin kasa
      fo:Farosi
      fr:Frɛnkye
      fr-CA:Kanada Frɛnkye
      fr-CH:Swisalande Frɛnkye
      fy:Atɔeɛ Fam Frihyia Kasa
      ga:Aerelande kasa
      gd:Skotlandfoɔ Galek Kasa
      gl:Galisia kasa
      gu:Gugyarata
      ha:Hausa
      he:Hibri kasa
      hi:Hindi
      hi-Latn:Laatenfoɔ Hindi
      hi-Latn-alt-variant:Hindibrɔfo
      hr:Kurowehyia kasa
      hsb:Atifi fam Sɔɔbia Kasa
      hu:Hangri kasa
      hy:Aameniani
      ia:Kasa ntam
      id:Indonihyia kasa
      ie:Kasa afrafra
      ig:Igbo kasa
      is:Aeslande kasa
      it:Italy kasa
      ja:Gyapan kasa
      jv:Gyabanis kasa
      ka:Gyɔɔgyia kasa
      kea:Kabuvadianu
      kgp:Kaingang
      kk:kasaki kasa
      km:Kambodia kasa
      kn:Kanada
      ko:Korea kasa
      kok:Konkani kasa
      ks:Kahyimiɛ
      ku:Kɛɛde kasa
      kxv:Kuvi kasa
      ky:Kɛgyese kasa
      lb:Lɔsimbɔge kasa
      lij:Liguria kasa
      lmo:Lombad kasa
      lo:Lawo kasa
      lt:Lituania kasa
      lv:Latvia kasa
      mai:Maetili
      mi:Mawori
      mk:Mɛsidonia kasa
      ml:Malayalam kasa
      mn:Mongoliafoɔ kasa
      mni:Manipuri
      mr:Marati
      ms:Malay kasa
      mt:Malta kasa
      mul:Kasa ahodoɔ
      my:Bɛɛmis kasa
      nds:Gyaaman kasa a ɛwɔ fam
      ne:Nɛpal kasa
      nl:Dɛɛkye
      nl-BE:Dɛɛkye (Bɛɛgyiɔm
      nn:Nɔwefoɔ Ninɔso
      no:Nɔwefoɔ kasa
      nqo:Nko
      oc:Osita kasa
      or:Odia
      pa:Pungyabi kasa
      pcm:Nigeriafoɔ Pigyin
      pl:Pɔland kasa
      prg:Prusia kasa
      ps:Pahyito
      pt:Pɔɔtugal kasa
      qu:Kwɛkya
      raj:Ragyasitan kasa
      rm:Romanhye kasa
      ro:Romenia kasa
      ru:Rahyia kasa
      rw:Rewanda kasa
      sa:Sanskrit kasa
      sah:Yakut Kasa
      sat:Santal kasa
      sc:Saadinia kasa
      sd:Sindi
      si:Sinhala
      sk:Slovak Kasa
      sl:Slovɛniafoɔ Kasa
      so:Somalia kasa
      sq:Aabeniani
      sr:Sɛbia Kasa
      su:Sunda Kasa
      sv:Sweden kasa
      sw:Swahili
      syr:Siiria Kasa
      szl:Silesiafoɔ Kasa
      ta:Tamil kasa
      te:Telugu
      tg:Tɛgyeke kasa
      th:Taeland kasa
      ti:Tigrinya kasa
      tk:Tɛkmɛnistan Kasa
      to:Tonga kasa
      tr:Tɛɛki kasa
      tt:Tata kasa
      ug:Yugaa Kasa
      uk:Ukren kasa
      und:kasa a yɛnnim
      ur:Urdu kasa
      uz:Usbɛkistan Kasa
      vec:Vɛnihyia Kasa
      vi:Viɛtnam kasa
      vmw:Makuwa
      wo:Wolɔfo Kasa
      xh:Hosa Kasa
      xnr:Kangri
      yo:Yoruba
      yrl:Ningatu
      yue:Kantonese
      yue-alt-menu:Kyaena Kantonese
      za:Zuang
      zh:Kyaena kasa
      zh-alt-menu:Madarin, Kyaena kasa
      zh-Hans:Kyaena kasa a emu yɛ mmrɛ
      zh-Hans-alt-long:Mandarin Kyaena kasa a emu yɛ mmrɛ
      zh-Hant:Tete Kyaena kasa
      zh-Hant-alt-long:Tete Mandarin Kyaena kasa
      zu:Zulu
      zxx:Lengwestese biara nnim
      """.trimIndent() }

  val am: String by lazy { """
      aa:አፋርኛ
      ab:አብሐዚኛ
      ace:አቻይንኛ
      ach:አኮሊኛ
      ada:አዳንግሜ
      ady:አድይግሄ
      ae:አቬስታን
      af:አፍሪካንኛ
      afh:አፍሪሂሊ
      agq:አገም
      ain:አይኑ
      ak:አካንኛ
      akk:አካዲያን
      akz:አላባማ
      ale:አልዩት
      alt:ደቡባዊ አልታይ
      am:አማርኛ
      an:አራጎንስ
      ann:ኦቦሎ
      anp:አንጊካ
      ar:ዓረብኛ
      ar-001:ዘመናዊ መደበኛ ዓረብኛ
      arc:አራማይክ
      arn:ማፑቼ
      aro:አራኦና
      arp:አራፓሆ
      arq:የአልጄሪያ ዓረብኛ
      ars:ናጅዲ አረብኛ
      arw:አራዋክ
      as:አሳሜዝ
      asa:አሱ
      ase:የአሜሪካ የምልክት ቋንቋ
      ast:አስቱሪያንኛ
      atj:አቲካምከው
      av:አቫሪክ
      awa:አዋድሂ
      ay:አያማርኛ
      az:አዘርባጃንኛ
      az-alt-short:አዜሪ
      ba:ባስኪርኛ
      bal:ባሉቺ
      ban:ባሊኔስ
      bar:ባቫሪያን
      bas:ባሳ
      bax:ባሙን
      bbc:ባታካ ቶባ
      be:ቤላራሻኛ
      bej:ቤጃ
      bem:ቤምባ
      bew:ቤታዊ
      bez:ቤና
      bfd:ባፉት
      bfq:ባዳጋ
      bg:ቡልጋሪኛ
      bgc:ሃርያንቪኛ
      bgn:የምዕራብ ባሎቺ
      bho:ቦጅፑሪ
      bi:ቢስላምኛ
      bik:ቢኮል
      bin:ቢኒ
      bjn:ባንጃር
      bla:ሲክሲካ
      blo:አኒኛ
      bm:ባምባርኛ
      bn:ቤንጋሊኛ
      bo:ቲቤታንኛ
      bpy:ቢሹንፑሪያ
      bqi:ባክህቲያሪ
      br:ብሬቶንኛ
      bra:ብራጅ
      brh:ብራሁዪ
      brx:ቦዶ
      bs:ቦስኒያንኛ
      bss:አኮስ
      bua:ቡሪያት
      bug:ቡጊኔዝ
      bum:ቡሉ
      byn:ብሊን
      ca:ካታላንኛ
      cad:ካዶ
      car:ካሪብ
      cay:ካዩጋ
      cch:አትሳም
      ccp:ቻክማ
      ce:ችችን
      ceb:ሴብዋኖ
      cgg:ቺጋኛ
      ch:ቻሞሮ
      chb:ቺብቻ
      chg:ቻጋታይ
      chk:ቹክስ
      chm:ማሪ
      chn:ቺኑክ ጃርጎን
      cho:ቾክታዋ
      chp:ቺፔውያን
      chr:ቼሮኬኛ
      chy:ችዬኔ
      ckb:የሶራኒ ኩርድኛ
      ckb-alt-menu:የሶራኒ ኩርድኛ
      ckb-alt-variant:የሶራኒ ኩርድኛ
      clc:ቺልኮቲን
      co:ኮርሲካኛ
      cop:ኮፕቲክ
      cps:ካፒዝኖን
      cr:ክሪ
      crg:ሚቺፍ
      crh:ክሪሚያን ተርኪሽ
      crj:ደቡብ ምዕራባዊ ክሪ
      crk:ፕላይንስ ክሪ
      crl:ሰሜን ምስራቃዊ ክሪ
      crm:ሙዝ ክሪ
      crr:ካሮሊና አልጎንክዊያን
      crs:ሰሰላዊ ክሬኦሊ ፈረንሳይኛ
      cs:ቼክኛ
      csw:ስዋምፒ ክሪ
      cu:ቸርች ስላቪክ
      cv:ቹቫሽኛ
      cy:ዌልሽ
      da:ዴኒሽ
      dak:ዳኮታ
      dar:ዳርግዋ
      dav:ታይታ
      de:ጀርመንኛ
      de-AT:የኦስትሪያ ጀርመንኛ
      de-CH:የስዊዝ ከፍተኛ ጀርመንኛ
      del:ዳላዌር
      dgr:ዶግሪብ
      din:ዲንካ
      dje:ዛርማኛ
      doi:ዶግሪ
      dsb:የታችኛው ሶርቢያኛ
      dtp:ሴንተራል ዱሰን
      dua:ዱዋላኛ
      dv:ዲቬሂ
      dyo:ጆላ-ፎንዪ
      dyu:ድዩላ
      dz:ድዞንግኻኛ
      dzg:ዳዛጋ
      ebu:ኢምቡ
      ee:ኢዊ
      efi:ኤፊክ
      egy:የጥንታዊ ግብጽኛ
      eka:ኤካጁክ
      el:ግሪክኛ
      en:እንግሊዝኛ
      en-AU:የአውስትራሊያ እንግሊዝኛ
      en-CA:የካናዳ እንግሊዝኛ
      en-GB:የብሪቲሽ እንግሊዝኛ
      en-GB-alt-short:የዩናይትድ ኪንግደም እንግሊዝኛ
      en-US:የአሜሪካ እንግሊዝኛ
      en-US-alt-short:የዩ ኤስ እንግሊዝኛ
      eo:ኤስፐራንቶ
      es:ስፓኒሽ
      es-419:የላቲን አሜሪካ ስፓኒሽ
      es-ES:የአውሮፓ ስፓኒሽ
      es-MX:የሜክሲኮ ስፓኒሽ
      esu:ሴንተራል ዩፒክ
      et:ኢስቶኒያንኛ
      eu:ባስክኛ
      ewo:ኤዎንዶ
      fa:ፐርሺያኛ
      fa-AF:ዳሪ
      ff:ፉላኒኛ
      fi:ፊንላንድኛ
      fil:ፊሊፒንኛ
      fj:ፊጂኛ
      fo:ፋሮኛ
      fon:ፎን
      fr:ፈረንሳይኛ
      fr-CA:የካናዳ ፈረንሳይኛ
      fr-CH:የስዊዝ ፈረንሳይኛ
      frc:ካጁን ፍሬንች
      frp:አርፒታን
      frr:ሰሜናዊ ፍሪስያን
      fur:ፍሩሊያን
      fy:ምዕራባዊ ፍሪሲኛ
      ga:አየርላንድኛ
      gaa:ጋ
      gag:ጋጉዝኛ
      gan:ጋን ቻይንኛ
      gd:የስኮትላንድ ጌይሊክ
      gez:ግዕዝኛ
      gil:ጅልበርትስ
      gl:ጋሊሺያንኛ
      gn:ጓራኒኛ
      gor:ጎሮንታሎ
      grc:የጥንታዊ ግሪክ
      gsw:ስዊዝ ጀርመንኛ
      gu:ጉጃርቲኛ
      guz:ጉስሊኛ
      gv:ማንክስ
      gwi:ግዊቺን
      ha:ሃውሳኛ
      hai:ሃይዳ
      hak:ሃካ ቻይንኛ
      haw:ሃዊያኛ
      hax:ደቡባዊ ሃይዳ
      he:ዕብራይስጥ
      hi:ሕንድኛ
      hi-Latn:ሕንድኛ (ላቲን)
      hi-Latn-alt-variant:ሕንድኛ (ላቲን)
      hil:ሂሊጋይኖን
      hmn:ህሞንግ
      hr:ክሮሽያንኛ
      hsb:የላይኛው ሶርቢያንኛ
      hsn:ዢያንግ ቻይንኛ
      ht:ሃይትኛ ክሮሌ
      hu:ሀንጋሪኛ
      hup:ሁፓ
      hur:ሃልኮመልም
      hy:አርሜንኛ
      hz:ሄሬሮ
      ia:ኢንቴርሊንጓ
      iba:ኢባን
      ibb:ኢቢብዮ
      id:ኢንዶኔዥያኛ
      ie:እንተርሊንግወ
      ig:ኢግቦኛ
      ii:ሲቹዋን ዪ
      ik:እኑፒያቅኛ
      ikt:የምዕራባዊ ካናዳ ኢኑክቲቱት
      ilo:ኢሎኮ
      inh:ኢንጉሽ
      io:ኢዶ
      is:አይስላንድኛ
      it:ጣሊያንኛ
      iu:እኑክቲቱትኛ
      ja:ጃፓንኛ
      jbo:ሎጅባን
      jgo:ንጎምባ
      jmc:ማቻሜኛ
      jv:ጃቫኛ
      ka:ጆርጂያንኛ
      kab:ካብይል
      kac:ካቺን
      kaj:ጅጁ
      kam:ካምባ
      kbd:ካባርዲያን
      kcg:ታያፕ
      kde:ማኮንዴ
      kea:ካቡቨርዲያኑ
      kfo:ኮሮ
      kg:ኮንጎኛ
      kgp:ካይንጋንግ
      kha:ካሲ
      khq:ኮይራ ቺኒ
      ki:ኪኩዩ
      kj:ኩዋንያማ
      kk:ካዛክኛ
      kkj:ካኮ
      kl:ካላሊሱት
      kln:ካለንጂን
      km:ክመር
      kmb:ኪምቡንዱ
      kn:ካናዳ
      ko:ኮሪያኛ
      koi:ኮሚ ፔርምያክ
      kok:ኮንካኒ
      kpe:ክፔሌ
      kr:ካኑሪ
      krc:ካራቻይ-ባልካር
      krl:ካረሊያን
      kru:ኩሩክ
      ks:ካሽሚርኛ
      ksb:ሻምባላ
      ksf:ባፊያ
      ksh:ኮሎኝኛ
      ku:ኩርድሽ
      kum:ኩማይክ
      kv:ኮሚ
      kw:ኮርኒሽ
      kwk:ክዋክዋላ
      kxv:ኩቪኛ
      ky:ክይርግይዝ
      la:ላቲንኛ
      lad:ላዲኖ
      lag:ላንጊ
      lb:ሉክሰምበርግኛ
      lez:ሌዝጊያን
      lg:ጋንዳኛ
      li:ሊምቡርጊሽ
      lij:ሊጓሪያኛ
      lil:ሊሎኤት
      lkt:ላኮታ
      lmo:ሎምባርድኛ
      ln:ሊንጋላ
      lo:ላኦኛ
      lou:ሉዊዚያና ክሬኦል
      loz:ሎዚ
      lrc:ሰሜናዊ ሉሪ
      lsm:ሳሚያ
      lt:ሊቱዌንያኛ
      lu:ሉባ-ካታንጋ
      lua:ሉባ-ሉሏ
      lun:ሉንዳ
      luo:ሉኦ
      lus:ሚዞ
      luy:ሉያ
      lv:ላትቪያኛ
      mad:ማዱረስ
      mag:ማጋሂ
      mai:ማይቲሊ
      mak:ማካሳር
      mas:ማሳይ
      mdf:ሞክሻ
      men:ሜንዴ
      mer:ሜሩ
      mfe:ሞሪስየን
      mg:ማላጋስይ
      mgh:ማኩዋ-ሜቶ
      mgo:ሜታ
      mh:ማርሻሊዝ
      mi:ማኦሪ
      mic:ሚክማው
      min:ሚናንግካባኡ
      mk:ሜቄዶንኛ
      ml:ማላያላም
      mn:ሞንጎሊያኛ
      mni:ማኒፑሪ
      moe:ኢኑ-አይመን
      moh:ሞሃውክ
      mos:ሞሲ
      mr:ማራቲ
      ms:ማላይ
      mt:ማልቲዝኛ
      mua:ሙንዳንግ
      mul:ባለብዙ ቋንቋዎች
      mus:ሙስኮኪ
      mwl:ሚራንዴዝ
      my:ቡርማኛ
      myv:ኤርዝያ
      mzn:ማዛንደራኒ
      na:ናኡሩ
      nan:ሚን ኛን ቻይንኛ
      nap:ኒአፖሊታን
      naq:ናማ
      nb:የኖርዌይ ቦክማል
      nd:ሰሜን ንዴብሌ
      nds:የታችኛው ጀርመንኛ
      nds-NL:የታችኛው ሳክሰን
      ne:ኔፓሊኛ
      new:ኒዋሪ(ኔፓል)
      ng:ንዶንጋ
      nia:ኒአስ
      niu:ኒዩአንኛ
      njo:ኦ ናጋ
      nl:ደች
      nl-BE:ፍሌሚሽ
      nmg:ክዋሲዮ
      nn:የኖርዌይ ናይኖርስክ
      nnh:ኒጊምቡን
      no:ኖርዌይኛ
      nog:ኖጋይ
      nqo:ንኮ
      nr:ደቡብ ንደቤሌ
      nso:ሰሜናዊ ሶቶ
      nus:ኑዌር
      nv:ናቫጆ
      nwc:ክላሲክ ኔዋሪ
      ny:ንያንጃ
      nyn:ኒያንኮል
      oc:ኦሲታን
      ojb:ሰሜን ምዕራባዊ ኦጂብዋ
      ojc:ማዕከላዊ ኦጂብዋ
      ojs:ኦጂ-ክሪ
      ojw:ምዕራባዊ ኦጂቡዋ
      oka:ኦካናጋን
      om:ኦሮሚኛ
      or:ኦዲያ
      os:ኦሴቲክ
      pa:ፑንጃብኛ
      pag:ፓንጋሲናን
      pam:ፓምፓንጋ
      pap:ፓፒያሜንቶ
      pau:ፓሉዋን
      pcm:የናይጄሪያ ፒጂን
      pis:ፒጂን
      pl:ፖሊሽ
      pqm:ማሊሴት-ፓሳማኩዎድይ
      prg:ፐሩሳንኛ
      ps:ፓሽቶ
      ps-alt-variant:ፑሽቶ
      pt:ፖርቹጋልኛ
      pt-BR:የብራዚል ፖርቹጋልኛ
      pt-PT:የአውሮፓ ፖርቹጋልኛ
      qu:ኩዌቹዋ
      quc:ኪቼ
      qug:ቺምቦራዞ ሃይላንድ ኩቹዋ
      raj:ራጃስታኒ
      rap:ራፓኑኢ
      rar:ራሮቶንጋን
      rhg:ሮሂንግያ
      rm:ሮማንሽ
      rn:ሩንዲ
      ro:ሮማኒያኛ
      ro-MD:ሞልዳቪያንኛ
      rof:ሮምቦ
      ru:ራሽያኛ
      rup:አሮማንያን
      rw:ኪንያርዋንዳ
      rwk:ርዋ
      sa:ሳንስክሪት
      sad:ሳንዳዌ
      sah:ያኩት
      saq:ሳምቡሩ
      sat:ሳንታሊ
      sba:ንጋምባይ
      sbp:ሳንጉ
      sc:ሳርዲንያን
      scn:ሲሲሊያንኛ
      sco:ስኮትስ
      sd:ሲንዲ
      sdh:ደቡባዊ ኩርዲሽ
      se:ሰሜናዊ ሳሚ
      seh:ሴና
      ses:ኮይራቦሮ ሴኒ
      sg:ሳንጎ
      sh:ሰርቦ-ክሮኤሽያኛ
      shi:ታቼልሂት
      shn:ሻን
      shu:ቻዲያን ዓረብኛ
      si:ሲንሃላ
      sid:ሲዳምኛ
      sk:ስሎቫክኛ
      sl:ስሎቬንኛ
      slh:ደቡባዊ ሉሹትሲድ
      sm:ሳሞኣን
      sma:ደቡባዊ ሳሚ
      smj:ሉሌ ሳሚ
      smn:ኢናሪ ሳሚ
      sms:ስኮልት ሳሚ
      sn:ሾና
      snk:ሶኒንኬ
      so:ሱማልኛ
      sq:አልባንያንኛ
      sr:ሰርብያኛ
      srn:ስራናን ቶንጎ
      ss:ስዋቲ
      ssy:ሳሆኛ
      st:ደቡባዊ ሶቶ
      str:ስትሬይትስ ስታሊሽ
      su:ሱዳንኛ
      suk:ሱኩማ
      sv:ስዊድንኛ
      sw:ስዋሂሊኛ
      sw-CD:ኮንጎ ስዋሂሊ
      swb:ኮሞሪያን
      syc:ክላሲክ ኔይራ
      syr:ሲሪያክ
      szl:ሲሌሲያኛ
      ta:ታሚል
      tce:ደቡባዊ ቱትቾን
      te:ተሉጉ
      tem:ቲምኔ
      teo:ቴሶ
      tet:ቴተም
      tg:ታጂክ
      tgx:ታጊሽ
      th:ታይ
      tht:ታህልታን
      ti:ትግርኛ
      tig:ትግረ
      tk:ቱርክሜን
      tl:ታጋሎገኛ
      tlh:ክሊንጎን
      tli:ትሊንጊት
      tn:ጽዋና
      to:ቶንጋን
      tok:ቶኪ ፖና
      tpi:ቶክ ፒሲን
      tr:ቱርክኛ
      trv:ታሮኮ
      ts:ጾንጋ
      tt:ታታር
      ttm:ሰሜናዊ ቱትቾን
      tum:ቱምቡካ
      tvl:ቱቫሉ
      tw:ትዊኛ
      twq:ታሳዋክ
      ty:ታሂታንኛ
      tyv:ቱቪንያንኛ
      tzm:መካከለኛው አትላስ ታማዚኛ
      udm:ኡድሙርት
      ug:ኡይግሁር
      uk:ዩክሬንኛ
      umb:ኡምቡንዱ
      und:ያልታወቀ ቋንቋ
      ur:ኡርዱኛ
      uz:ኡዝቤክኛ
      vai:ቫይ
      ve:ቬንዳ
      vec:ቬነቲያንኛ
      vi:ቪየትናምኛ
      vmw:ማክሁዋኛ
      vo:ቮላፑክኛ
      vun:ቩንጆ
      wa:ዋሎን
      wae:ዋልሰር
      wal:ወላይትኛ
      war:ዋራይ
      wbp:ዋርልፒሪ
      wo:ዎሎፍኛ
      wuu:ዉ ቻይንኛ
      xal:ካልማይክ
      xh:ዞሳኛ
      xnr:ካንጋሪ
      xog:ሶጋ
      yav:ያንግቤንኛ
      ybb:የምባ
      yi:ይዲሽኛ
      yo:ዮሩባዊኛ
      yrl:ንሄንጋቱ
      yue:ካንቶኒዝ
      yue-alt-menu:ካንቶኒዝ ቻይንኛ
      za:ዡዋንግኛ
      zbl:ብሊስይምቦልስ
      zgh:መደበኛ የሞሮኮ ታማዚግት
      zh:ቻይንኛ
      zh-alt-menu:ማንድሪን ቻይንኛ
      zh-Hans:ቀለል ያለ ቻይንኛ
      zh-Hans-alt-long:ቀለል ያለ ማንድሪን ቻይንኛ
      zh-Hant:ባህላዊ ቻይንኛ
      zh-Hant-alt-long:ባህላዊ ማንድሪን ቻይንኛ
      zu:ዙሉኛ
      zun:ዙኒ
      zxx:ቋንቋዊ ይዘት የለውም
      zza:ዛዛ
      """.trimIndent() }

  val an: String by lazy { """
      an:aragonés
      """.trimIndent() }

  val ann: String by lazy { """
      ann:Obolo
      """.trimIndent() }

  val apc: String by lazy { """
      apc:العامية
      """.trimIndent() }

  val ar: String by lazy { """
      aa:الأفارية
      ab:الأبخازية
      ace:الأتشينيزية
      ach:الأكولية
      ada:الأدانجمية
      ady:الأديغة
      ae:الأفستية
      af:الأفريقانية
      afh:الأفريهيلية
      agq:الأغم
      ain:الآينوية
      ak:الأكانية
      akk:الأكادية
      ale:الأليوتية
      alt:الألطائية الجنوبية
      am:الأمهرية
      an:الأراغونية
      ang:الإنجليزية القديمة
      ann:أوبلو
      anp:الأنجيكا
      ar:العربية
      ar-001:العربية الفصحى الحديثة
      arc:الآرامية
      arn:المابودونغونية
      arp:الأراباهو
      ars:اللهجة النجدية
      ars-alt-menu:العربية، النجدية
      arw:الأراواكية
      as:الأسامية
      asa:الآسو
      ast:الأسترية
      atj:الأتيكاميكو
      av:الأوارية
      awa:الأوادية
      ay:الأيمارا
      az:الأذربيجانية
      az-alt-short:الأذرية
      ba:الباشكيرية
      bal:البلوشية
      ban:البالينية
      bas:الباسا
      bax:بامن
      bbj:لغة الغومالا
      be:البيلاروسية
      bej:البيجا
      bem:البيمبا
      bez:بينا
      bfd:لغة البافوت
      bg:البلغارية
      bgc:الهارينفية
      bgn:البلوشية الغربية
      bho:البهوجبورية
      bi:البيسلامية
      bik:البيكولية
      bin:البينية
      bkm:لغة الكوم
      bla:السيكسيكية
      blo:الآنية
      bm:البامبارا
      bn:البنغالية
      bo:التبتية
      br:البريتونية
      bra:البراجية
      brx:البودو
      bs:البوسنية
      bss:أكوس
      bua:البرياتية
      bug:البجينيزية
      bum:لغة البولو
      byn:البلينية
      byv:لغة الميدومبا
      ca:الكتالانية
      cad:الكادو
      car:الكاريبية
      cay:الكايوجية
      cch:الأتسام
      ccp:تشاكما
      ce:الشيشانية
      ceb:السيبيوانية
      cgg:تشيغا
      ch:التشامورو
      chb:التشيبشا
      chg:التشاجاتاي
      chk:التشكيزية
      chm:الماري
      chn:الشينوك جارجون
      cho:الشوكتو
      chp:الشيباوايان
      chr:الشيروكي
      chy:الشايان
      ckb:السورانية الكردية
      ckb-alt-menu:الكردية، السورانية
      ckb-alt-variant:السورانية الكردية
      clc:تسيلكوتين
      co:الكورسيكية
      cop:القبطية
      cr:الكرى
      crg:الميتشيف
      crh:لغة تتار القرم
      crj:الكري الجنوب شرقية
      crk:البلينز-كري
      crl:الكري شمال الشرقية
      crm:الموس-كري
      crr:الألغونكوية كارولينا
      crs:الفرنسية الكريولية السيشيلية
      cs:التشيكية
      csb:الكاشبايان
      csw:السوامبي-كري
      cu:سلافية كنسية
      cv:التشوفاشي
      cy:الويلزية
      da:الدانمركية
      dak:الداكوتا
      dar:الدارجوا
      dav:تيتا
      de:الألمانية
      de-AT:الألمانية النمساوية
      del:الديلوير
      den:السلافية
      dgr:الدوجريب
      din:الدنكا
      dje:الزارمية
      doi:الدوجرية
      dsb:صوربيا السفلى
      dua:الديولا
      dum:الهولندية الوسطى
      dv:المالديفية
      dyo:جولا فونيا
      dyu:الدايلا
      dz:دزونكا
      dzg:القرعانية
      ebu:إمبو
      ee:الإيوي
      efi:الإفيك
      egy:المصرية القديمة
      eka:الإكاجك
      el:اليونانية
      elx:الإمايت
      en:الإنجليزية
      en-GB-alt-short:الإنجليزية المملكة المتحدة
      en-US-alt-short:الإنجليزية الولايات المتحدة
      enm:الإنجليزية الوسطى
      eo:الإسبرانتو
      es:الإسبانية
      es-419:الإسبانية أمريكا اللاتينية
      es-ES:الإسبانية الأوروبية
      es-MX:الإسبانية المكسيكية
      et:الإستونية
      eu:الباسكية
      ewo:الإيوندو
      fa:الفارسية
      fa-AF:الدارية
      fan:الفانج
      fat:الفانتي
      ff:الفولانية
      fi:الفنلندية
      fil:الفلبينية
      fj:الفيجية
      fo:الفاروية
      fon:الفون
      fr:الفرنسية
      frc:الفرنسية الكاجونية
      frm:الفرنسية الوسطى
      fro:الفرنسية القديمة
      frr:الفريزينية الشمالية
      frs:الفريزينية الشرقية
      fur:الفريلايان
      fy:الفريزيان
      ga:الأيرلندية
      gaa:الجا
      gag:الغاغوز
      gan:الغان الصينية
      gay:الجايو
      gba:الجبيا
      gd:الغيلية الأسكتلندية
      gez:الجعزية
      gil:لغة أهل جبل طارق
      gl:الجاليكية
      gmh:الألمانية العليا الوسطى
      gn:الغوارانية
      goh:الألمانية العليا القديمة
      gon:الجندي
      gor:الجورونتالو
      got:القوطية
      grb:الجريبو
      grc:اليونانية القديمة
      gsw:الألمانية السويسرية
      gu:الغوجاراتية
      guz:الغيزية
      gv:المنكية
      gwi:غوتشن
      ha:الهوسا
      hai:الهيدا
      hak:الهاكا الصينية
      haw:لغة هاواي
      hax:هايدا الجنوبية
      he:العبرية
      hi:الهندية
      hi-Latn-alt-variant:الهنجليزية
      hil:الهيليجينون
      hit:الحثية
      hmn:الهمونجية
      ho:الهيري موتو
      hr:الكرواتية
      hsb:الصوربية العليا
      hsn:شيانغ الصينية
      ht:الكريولية الهايتية
      hu:الهنغارية
      hup:الهبا
      hur:الهالكوميليم
      hy:الأرمنية
      hz:الهيريرو
      ia:اللّغة الوسيطة
      iba:الإيبان
      ibb:الإيبيبيو
      id:الإندونيسية
      ie:الإنترلينج
      ig:الإيجبو
      ii:السيتشيون يي
      ik:الإينبياك
      ikt:الإنكتيتوتية الكندية الغربية
      ilo:الإيلوكو
      inh:الإنجوشية
      io:الإيدو
      is:الأيسلندية
      it:الإيطالية
      iu:الإينكتيتت
      ja:اليابانية
      jbo:اللوجبان
      jgo:نغومبا
      jmc:الماتشامية
      jpr:الفارسية اليهودية
      jrb:العربية اليهودية
      jv:الجاوية
      ka:الجورجية
      kaa:الكارا-كالباك
      kab:القبيلية
      kac:الكاتشين
      kaj:الجو
      kam:الكامبا
      kaw:الكوي
      kbd:الكاباردايان
      kbl:كانمبو
      kcg:التايابية
      kde:ماكونده
      kea:كابوفيرديانو
      kfo:الكورو
      kg:الكونغو
      kgp:الكاينغانغ
      kha:الكازية
      kho:الخوتانيز
      khq:كويرا تشيني
      ki:الكيكيو
      kj:كوانياما
      kk:الكازاخستانية
      kkj:لغة الكاكو
      kl:الكالاليست
      kln:كالينجين
      km:الخميرية
      kmb:الكيمبندو
      kn:الكانادا
      ko:الكورية
      koi:كومي-بيرماياك
      kok:الكونكانية
      kos:الكوسراين
      kpe:الكبيل
      kr:الكانوري
      krc:الكاراتشاي-بالكار
      krl:الكاريلية
      kru:الكوروخ
      ks:الكشميرية
      ksb:شامبالا
      ksf:لغة البافيا
      ksh:لغة الكولونيان
      ku:الكردية
      kum:القموقية
      kut:الكتيناي
      kv:الكومي
      kw:الكورنية
      kwk:الكواكوالا
      kxv:الكوفية
      ky:القيرغيزية
      la:اللاتينية
      lad:اللادينو
      lag:لانجي
      lah:اللاهندا
      lam:اللامبا
      lb:اللكسمبورغية
      lez:الليزجية
      lg:الغاندا
      li:الليمبورغية
      lij:الليغورية
      lil:الليلويتية
      lkt:لاكوتا
      lmo:اللومبردية
      ln:اللينجالا
      lo:اللاوية
      lol:منغولى
      lou:الكريولية اللويزيانية
      loz:اللوزي
      lrc:اللرية الشمالية
      lsm:الساميا
      lt:الليتوانية
      lu:اللوبا كاتانغا
      lua:اللبا-لؤلؤ
      lui:اللوسينو
      lun:اللوندا
      luo:اللو
      lus:الميزو
      luy:لغة اللويا
      lv:اللاتفية
      mad:المادريز
      mag:الماجا
      mai:المايثيلي
      mak:الماكاسار
      man:الماندينغ
      mas:الماساي
      mde:مابا
      mdf:الموكشا
      mdr:الماندار
      men:الميند
      mer:الميرو
      mfe:المورسيانية
      mg:الملغاشي
      mga:الأيرلندية الوسطى
      mgh:ماخاوا-ميتو
      mgo:ميتا
      mh:المارشالية
      mi:الماورية
      mic:الميكماكيونية
      min:المينانجكاباو
      mk:المقدونية
      ml:المالايالامية
      mn:المنغولية
      mnc:المانشو
      mni:المانيبورية
      moe:إينو-ايمون
      moh:الموهوك
      mos:الموسي
      mr:الماراثية
      ms:الماليزية
      mt:المالطية
      mua:مندنج
      mul:لغات متعددة
      mus:الكريك
      mwl:الميرانديز
      mwr:الماروارية
      my:البورمية
      myv:الأرزية
      mzn:المازندرانية
      na:النورو
      nan:مين-نان الصينية
      nap:النابولية
      naq:لغة الناما
      nb:النرويجية بوكمال
      nd:النديبيل الشمالية
      nds:الألمانية السفلى
      nds-NL:السكسونية السفلى
      ne:النيبالية
      new:النوارية
      ng:الندونجا
      nia:النياس
      niu:النيوي
      nl:الهولندية
      nmg:كواسيو
      nn:النرويجية نينورسك
      nnh:لغة النجيمبون
      no:النرويجية
      nog:النوجاي
      non:النورس القديم
      nqo:أنكو
      nr:النديبيل الجنوبي
      nso:السوتو الشمالية
      nus:النوير
      nv:النافاجو
      nwc:النوارية التقليدية
      ny:النيانجا
      nym:النيامويزي
      nyn:النيانكول
      nyo:النيورو
      nzi:النزيما
      oc:الأوكسيتانية
      oj:الأوجيبوا
      ojb:أوجيبوا الشمالية الغربية
      ojc:أوجيبوا الوسطى
      ojs:الأوجي-كري
      ojw:الأوجيبوا الغربية
      oka:الأوكاناغانية
      om:الأورومية
      or:الأورية
      os:الأوسيتيك
      osa:الأوساج
      ota:التركية العثمانية
      pa:البنجابية
      pag:البانجاسينان
      pal:البهلوية
      pam:البامبانجا
      pap:البابيامينتو
      pau:البالوان
      pcm:البدجنية النيجيرية
      peo:الفارسية القديمة
      phn:الفينيقية
      pi:البالية
      pis:بيجين
      pl:البولندية
      pon:البوهنبيايان
      pqm:الماليزيت-باساماكودي
      prg:البروسياوية
      pro:البروفانسية القديمة
      ps:البشتو
      ps-alt-variant:بشتو
      pt:البرتغالية
      pt-BR:البرتغالية البرازيلية
      pt-PT:البرتغالية الأوروبية
      qu:كيشوا
      quc:الكيشية
      raj:الراجاسثانية
      rap:الراباني
      rar:الراروتونجاني
      rhg:الروهينغية
      rm:الرومانشية
      rn:الرندي
      ro:الرومانية
      ro-MD:المولدوفية
      rof:الرومبو
      rom:الغجرية
      ru:الروسية
      rup:الأرومانيان
      rw:الكينيارواندا
      rwk:الروا
      sa:السنسكريتية
      sad:السانداوي
      sah:الساخيّة
      sam:الآرامية السامرية
      saq:سامبورو
      sas:الساساك
      sat:السانتالية
      sba:نامبي
      sbp:سانغو
      sc:السردينية
      scn:الصقلية
      sco:الأسكتلندية
      sd:السندية
      sdh:الكردية الجنوبية
      se:سامي الشمالية
      see:السنيكا
      seh:سينا
      sel:السيلكب
      ses:كويرابورو سيني
      sg:السانجو
      sga:الأيرلندية القديمة
      sh:صربية-كرواتية
      shi:تشلحيت
      shn:الشان
      shu:العربية التشادية
      si:السنهالية
      sid:السيدامو
      sk:السلوفاكية
      sl:السلوفانية
      slh:لوشوتسيد الجنوبية
      sm:الساموائية
      sma:السامي الجنوبي
      smj:اللول سامي
      smn:الإيناري سامي
      sms:السكولت سامي
      sn:الشونا
      snk:السونينك
      so:الصومالية
      sog:السوجدين
      sq:الألبانية
      sr:الصربية
      srn:السرانان تونجو
      srr:السرر
      ss:السواتي
      ssy:لغة الساهو
      st:السوتو الجنوبية
      str:سترايتس ساليش
      su:السوندانية
      suk:السوكوما
      sus:السوسو
      sux:السومارية
      sv:السويدية
      sw:السواحلية
      sw-CD:الكونغو السواحلية
      swb:القمرية
      syc:سريانية تقليدية
      syr:السريانية
      szl:السيليزية
      ta:التاميلية
      tce:التوتشون الجنوبية
      te:التيلوغوية
      tem:التيمن
      teo:تيسو
      ter:التيرينو
      tet:التيتم
      tg:الطاجيكية
      tgx:التاغيش
      th:التايلاندية
      tht:التالتان
      ti:التغرينية
      tig:التيغرية
      tiv:التيف
      tk:التركمانية
      tkl:التوكيلاو
      tl:التاغالوغية
      tlh:الكلينجون
      tli:التلينغيتية
      tmh:التاماشيك
      tn:التسوانية
      to:التونغية
      tog:تونجا - نياسا
      tok:التوكي-بونا
      tpi:التوك بيسين
      tr:التركية
      trv:لغة التاروكو
      ts:السونجا
      tsi:التسيمشيان
      tt:التترية
      ttm:التوتشون الشمالية
      tum:التامبوكا
      tvl:التوفالو
      tw:التوي
      twq:تاساواق
      ty:التاهيتية
      tyv:التوفية
      tzm:الأمازيغية وسط الأطلس
      udm:الأدمرت
      ug:الأويغورية
      ug-alt-variant:الأيغورية
      uga:اليجاريتيك
      uk:الأوكرانية
      umb:الأمبندو
      und:لغة غير معروفة
      ur:الأوردية
      uz:الأوزبكية
      vai:الفاي
      ve:الفيندا
      vec:البندقية
      vi:الفيتنامية
      vmw:الماكوا
      vo:لغة الفولابوك
      vot:الفوتيك
      vun:الفونجو
      wa:الولونية
      wae:الوالسر
      wal:الولاياتا
      war:الواراي
      was:الواشو
      wbp:وارلبيري
      wo:الولوفية
      wuu:الوو الصينية
      xal:الكالميك
      xh:الخوسا
      xnr:كانغري
      xog:السوغا
      yao:الياو
      yap:اليابيز
      yav:يانجبن
      ybb:يمبا
      yi:اليديشية
      yo:اليوروبا
      yrl:النيينجاتو
      yue:الكَنْتُونية
      yue-alt-menu:الكَنْتُونية
      za:الزهيونج
      zap:الزابوتيك
      zbl:رموز المعايير الأساسية
      zen:الزيناجا
      zgh:التمازيغية المغربية القياسية
      zh:الصينية
      zh-alt-menu:الصينية
      zh-Hans:الصينية المبسطة
      zh-Hans-alt-long:الصينية المبسطة
      zh-Hant:الصينية التقليدية
      zh-Hant-alt-long:الصينية التقليدية
      zu:الزولو
      zun:الزونية
      zxx:بدون محتوى لغوي
      zza:زازا
      """.trimIndent() }

  val ar_AE: String? = null

  val ar_BH: String? = null

  val ar_DJ: String? = null

  val ar_DZ: String? = null

  val ar_EG: String by lazy { """
      da:الدنماركية
      """.trimIndent() }

  val ar_EH: String? = null

  val ar_ER: String? = null

  val ar_IL: String? = null

  val ar_IQ: String? = null

  val ar_JO: String? = null

  val ar_KM: String? = null

  val ar_KW: String? = null

  val ar_LB: String? = null

  val ar_LY: String by lazy { """
      arn:المابودونجونية
      gn:الغورانية
      hsb:صوربيا العليا
      lo:اللاوو
      sh:الكرواتية الصربية
      sma:سامي الجنوبية
      sw:السواحيلية
      sw-CD:السواحيلية الكونغولية
      ti:التيغرينية
      """.trimIndent() }

  val ar_MA: String? = null

  val ar_MR: String? = null

  val ar_OM: String? = null

  val ar_PS: String? = null

  val ar_QA: String? = null

  val ar_SA: String by lazy { """
      ar-001:العربية الرسمية الحديثة
      arn:المابودونجونية
      gn:الغورانية
      hsb:صوربيا العليا
      lo:اللاوو
      sh:الكرواتية الصربية
      sma:سامي الجنوبية
      sw:السواحيلية
      sw-CD:السواحيلية الكونغولية
      te:التيلوجو
      ti:التيغرينية
      """.trimIndent() }

  val ar_SD: String? = null

  val ar_SO: String? = null

  val ar_SS: String? = null

  val ar_SY: String? = null

  val ar_TD: String? = null

  val ar_TN: String? = null

  val ar_YE: String? = null

  val arn: String by lazy { """
      arn:Mapudungun
      """.trimIndent() }

  val `as`: String by lazy { """
      aa:আফাৰ
      ab:আবখাজিয়ান
      ace:আচিনিজ
      ada:আদাংমে
      ady:আদিগে
      af:আফ্ৰিকানছ্
      agq:আঘেম
      ain:আইনু
      ak:আকান
      ale:আলেউট
      alt:দাক্ষিণাত্য আল্টাই
      am:আমহাৰিক
      an:আৰ্গোনিজ
      ann:অ’ব’ল’
      anp:আঙ্গিকা
      ar:আৰবী
      ar-001:আধুনিক মানক আৰবী
      arn:মাপুচে
      arp:আৰাপাহো
      ars:নাজডি আৰবী
      as:অসমীয়া
      asa:আছু
      ast:এষ্টুৰীয়
      atj:আতিকামেক
      av:আভেৰিক
      awa:অৱধী
      ay:আয়মাৰা
      az:আজেৰবাইজানী
      az-alt-short:আজেৰি
      ba:বাছখিৰ
      ban:বালিনীজ
      bas:বাছা
      be:বেলাৰুছীয়
      bem:বেম্বা
      bez:বেনা
      bg:বুলগেৰীয়
      bgc:হাৰয়ানভি
      bho:ভোজপুৰী
      bi:বিছলামা
      bin:বিনি
      bla:ছিক্সিকা
      blo:আনি
      bm:বামবাৰা
      bn:বাংলা
      bo:তিব্বতী
      br:ব্ৰেটন
      brx:বড়ো
      bs:বছনীয়
      bug:বগিনীজ
      byn:ব্লিন
      ca:কাতালান
      cay:কায়ুগা
      ccp:চাক্‌মা
      ce:চেচেন
      ceb:চিবুৱানো
      cgg:চিগা
      ch:চামোৰো
      chk:চুকিজ
      chm:মাৰি
      cho:চোক্টাউ
      chp:চিপেউয়ান
      chr:চেৰোকি
      chy:চাইয়েন
      ckb:চেণ্ট্ৰেল কুৰ্ডিচ
      ckb-alt-menu:চেণ্ট্ৰেল কুৰ্ডিচ
      ckb-alt-variant:চেণ্ট্ৰেল কুৰ্ডিচ
      clc:চিলক’টিন
      co:কোৰ্ছিকান
      crg:মিচিফ
      crj:দাক্ষিণাত্য ইষ্ট ক্ৰী
      crk:প্লেইনছ ক্ৰী
      crl:নৰ্দাৰ্ন ইষ্ট ক্ৰী
      crm:মুজ ক্ৰী
      crr:কেৰ’লিনা আলগংকিয়ান
      crs:ছেছেলৱা ক্ৰিওল ফ্ৰেন্স
      cs:চেক
      csw:স্বাম্পী ক্ৰী
      cu:চাৰ্চ শ্লেভিক
      cv:চুভাচ
      cy:ৱেলচ
      da:ডেনিচ
      dak:ডাকোটা
      dar:দাৰ্গৱা
      dav:তেইতা
      de:জাৰ্মান
      de-AT:অষ্ট্ৰেলিয়ান জাৰ্মান
      de-CH:ছুইচ হাই জাৰ্মান
      dgr:ডোগ্ৰিব
      dje:ঝাৰ্মা
      doi:ডোগ্ৰী
      dsb:ল’ৱাৰ ছোৰ্বিয়ান
      dua:ডুৱালা
      dv:দিবেহি
      dyo:জোলা-ফ’নি
      dz:জোংখা
      dzg:দাজাগা
      ebu:এম্বু
      ee:ইৱে
      efi:এফিক
      eka:একাজুক
      el:গ্ৰীক
      en:ইংৰাজী
      en-AU:অষ্ট্ৰেলিয়ান ইংৰাজী
      en-CA:কানাডিয়ান ইংৰাজী
      en-GB:ব্ৰিটিছ ইংৰাজী
      en-GB-alt-short:ইউ. কে. ইংৰাজী
      en-US:আমেৰিকান ইংৰাজী
      en-US-alt-short:ইউ. এছ. ইংৰাজী
      eo:এস্পেৰান্তো
      es:স্পেনিচ
      es-419:লেটিন আমেৰিকান স্পেনিচ
      es-ES:ইউৰোপীয়ান স্পেনিচ
      es-MX:মেক্সিকান স্পেনিচ
      et:এষ্টোনিয়
      eu:বাস্ক
      ewo:ইওন্দো
      fa:ফাৰ্ছী
      fa-AF:দাৰি
      ff:ফুলাহ
      fi:ফিনিচ
      fil:ফিলিপিনো
      fj:ফিজিয়ান
      fo:ফাৰোইজ
      fon:ফ’ন
      fr:ফ্ৰেন্স
      fr-CA:কানাডিয়ান ফ্ৰেন্স
      fr-CH:ছুইচ ফ্ৰেন্স
      frc:কেজ’ন ফৰাছী
      frr:নৰ্দাৰ্ন ফ্ৰিছিয়ান
      fur:ফ্ৰিউলিয়ান
      fy:ৱেষ্টাৰ্ণ ফ্ৰিছিয়ান
      ga:আইৰিচ
      gaa:গা
      gd:স্কটিচ গেইলিক
      gez:গীজ
      gil:গিলবাৰ্টিছ
      gl:গেলিচিয়ান
      gn:গুৱাৰাণী
      gor:গোৰোন্তালো
      gsw:ছুইচ জাৰ্মান
      gu:গুজৰাটী
      guz:গুছি
      gv:মেংক্স
      gwi:জিউইচিন
      ha:হাউছা
      hai:হেইডা
      haw:হাৱাই
      hax:দাক্ষিণাত্যৰ হাইডা
      he:হিব্ৰু
      hi:হিন্দী
      hi-Latn-alt-variant:হিংলিছ
      hil:হিলিগায়নোন
      hmn:হমং
      hr:ক্ৰোৱেচিয়ান
      hsb:আপাৰ ছোৰ্বিয়ান
      ht:হেইটিয়ান ক্ৰিয়ল
      hu:হাঙ্গেৰিয়ান
      hup:হুপা
      hur:হেলকোমেলেম
      hy:আৰ্মেনীয়
      hz:হেৰেৰো
      ia:ইণ্টাৰলিংগুৱা
      iba:ইবান
      ibb:ইবিবিও
      id:ইণ্ডোনেচিয়
      ie:ইণ্টাৰলিংগুৱে
      ig:ইগ্বো
      ii:ছিচুৱান ই
      ikt:ৱেষ্টাৰ্ণ কানাডিয়ান ইনক্টিটুট
      ilo:ইলোকো
      inh:ইংগুচ
      io:ইডো
      is:আইচলেণ্ডিক
      it:ইটালিয়ান
      iu:ইনুক্টিটুট
      ja:জাপানী
      jbo:লোজ্বান
      jgo:নগোম্বা
      jmc:মেকহেম
      jv:জাভানী
      ka:জৰ্জিয়ান
      kab:কাবাইল
      kac:কাচিন
      kaj:জজু
      kam:কাম্বা
      kbd:কাবাৰ্ডিয়ান
      kcg:ত্যাপ
      kde:মাকোণ্ড
      kea:কাবুভেৰ্ডিয়ানু
      kfo:কোৰো
      kgp:কেইংগাং
      kha:খাচি
      khq:কোয়াৰ চিনি
      ki:কিকুয়ু
      kj:কুয়ানিয়ামা
      kk:কাজাখ
      kkj:কাকো
      kl:কালালিছুট
      kln:কালেনজিন
      km:খমেৰ
      kmb:কিম্বুন্দু
      kn:কানাড়া
      ko:কোৰিয়ান
      kok:কোংকণী
      kpe:কেপেল
      kr:কানুৰি
      krc:কাৰাচে-বাল্কাৰ
      krl:কেৰেলিয়ান
      kru:কুৰুখ
      ks:কাশ্মিৰী
      ksb:চাম্বালা
      ksf:বাফিয়া
      ksh:কোলোগনিয়ান
      ku:কুৰ্ডিচ
      kum:কুমিক
      kv:কোমি
      kw:কোৰ্নিচ
      kwk:ক্বাকৱালা
      kxv:কুভি
      ky:কিৰ্গিজ
      la:লেটিন
      lad:লাডিনো
      lag:লাংগি
      lb:লাক্সেমবাৰ্গিচ
      lez:লেজঘিয়ান
      lg:গান্দা
      li:লিম্বুৰ্গিচ
      lij:লিংগুৰিয়ান
      lil:লিল্লোৱেট
      lkt:লাকোটা
      lmo:ল’ম্বাৰ্ড
      ln:লিংগালা
      lo:লাও
      lou:লুইজিয়ানা কেৰ’ল
      loz:লোজি
      lrc:উদীচ্য লুৰি
      lsm:চামিয়া
      lt:লিথুৱানিয়ান
      lu:লুবা-কাটাংগা
      lua:লুবা-লুলুৱা
      lun:লুণ্ডা
      luo:লুও
      lus:মিজো
      luy:লুইয়া
      lv:লাটভিয়ান
      mad:মাদুৰেছে
      mag:মাগাহি
      mai:মৈথিলী
      mak:মাকাছাৰ
      mas:মাছাই
      mdf:মোক্সা
      men:মেণ্ডে
      mer:মেৰু
      mfe:মৰিছিয়ান
      mg:মালাগাছী
      mgh:মাখুৱা-মিট্টো
      mgo:মেটা
      mh:মাৰ্চলিজ
      mi:মাওৰি
      mic:মিকমেক
      min:মিনাংকাবাউ
      mk:মেচিডোনীয়
      ml:মালায়ালম
      mn:মংগোলীয়
      mni:মণিপুৰী
      moe:ইন্নু-আইমুন
      moh:মোহোক
      mos:মোছি
      mr:মাৰাঠী
      ms:মালয়
      mt:মাল্টিজ
      mua:মুণ্ডাং
      mul:একাধিক ভাষা
      mus:ক্ৰীক
      mwl:মিৰাণ্ডিজ
      my:বাৰ্মীজ
      myv:এৰজিয়া
      mzn:মাজেন্দাৰানি
      na:নাউৰু
      nap:নিয়াপোলিটেন
      naq:নামা
      nb:নৰৱেজিয়ান বোকমাল
      nd:উত্তৰ নিবেবেলে
      nds:ল’ জাৰ্মান
      ne:নেপালী
      new:নেৱাৰি
      ng:এন্দোঙ্গা
      nia:নিয়াছ
      niu:নিয়ুৱান
      nl:ডাচ
      nl-BE:ফ্লেমিচ
      nmg:কোৱাছিঅ’
      nn:নৰৱেজিয়ান নায়নোৰ্স্ক
      nnh:নিয়েম্বোন
      no:নৰৱেজিয়ান
      nog:নোগাই
      nqo:এন্কো
      nr:দক্ষিণ দেবেল
      nso:উদীচ্য ছোথো
      nus:নুয়েৰ
      nv:নাভাজো
      ny:ন্যাঞ্জা
      nyn:ন্যানকোল
      oc:অ’চিটান
      ojb:নৰ্থ-ৱেষ্টাৰ্ণ অজিবৱা
      ojc:চেন্ট্ৰেক অজিবৱা
      ojs:অ’জি-ক্ৰী
      ojw:ৱেষ্টাৰ্ণ অজিবৱা
      oka:অ’কানাগান
      om:ওৰোমো
      or:ওড়িয়া
      os:ওছেটিক
      pa:পাঞ্জাবী
      pag:পংগাছিনান
      pam:পাম্পান্গা
      pap:পাপিয়ামেণ্টো
      pau:পালাউৱান
      pcm:নাইজেৰিয়ান পিজিন
      pis:পিজিন
      pl:প’লিচ
      pqm:মালিছীট-পাছামাকু’ডী
      prg:প্ৰুছিয়ান
      ps:পুস্ত
      pt:পৰ্তুগীজ
      pt-BR:ব্ৰাজিলিয়ান পৰ্তুগীজ
      pt-PT:ইউৰোপীয়ান পৰ্তুগীজ
      qu:কুৱেচুৱা
      quc:কিচিয়ে
      raj:ৰাজস্থানী
      rap:ৰাপানুই
      rar:ৰাৰোতোঙ্গন
      rhg:ৰোহিঙ্গিয়া
      rm:ৰোমানচ
      rn:ৰুন্দি
      ro:ৰোমানীয়
      ro-MD:মোল্ডাভিয়ান
      rof:ৰোম্বো
      ru:ৰাছিয়ান
      rup:আৰোমানীয়
      rw:কিনয়াৰোৱাণ্ডা
      rwk:ৰৱা
      sa:সংস্কৃত
      sad:ছান্দাৱে
      sah:ছাখা
      saq:ছাম্বুৰু
      sat:চাওতালি
      sba:নাংম্বে
      sbp:ছাঙ্গু
      sc:ছাৰ্ডিনিয়ান
      scn:ছিচিলিয়ান
      sco:স্কটছ
      sd:সিন্ধী
      se:উদীচ্য ছামি
      seh:ছেনা
      ses:কোইৰাবোৰো চেন্নি
      sg:ছাঙ্গো
      shi:তাচেলহিট
      shn:চান
      si:সিংহলা
      sk:শ্লোভাক
      sl:শ্লোভেনিয়ান
      slh:দাক্ষিণাত্যৰ লুছুটচীড
      sm:ছামোন
      sma:দাক্ষিণাত্য ছামি
      smj:লুলে ছামি
      smn:ইনাৰি ছামি
      sms:স্কোল্ট ছামি
      sn:চোনা
      snk:ছোনিনকে
      so:ছোমালি
      sq:আলবেনীয়
      sr:ছাৰ্বিয়ান
      srn:স্ৰানান টোঙ্গো
      ss:স্বাতি
      ssy:ছাহো
      st:দাক্ষিণাত্য ছোথো
      str:ষ্ট্ৰেইটছ ছেলিশ্ব
      su:ছুণ্ডানীজ
      suk:ছুকুমা
      sv:ছুইডিচ
      sw:স্বাহিলি
      sw-CD:কঙ্গো স্বাহিলি
      swb:কোমোৰিয়ান
      syr:চিৰিয়াক
      szl:ছাইলেছিয়ান
      ta:তামিল
      tce:দাক্ষিণাত্যৰ টুটচ’ন
      te:তেলুগু
      tem:টিম্নে
      teo:তেছো
      tet:তেতুম
      tg:তাজিক
      tgx:টেগিশ্ব
      th:থাই
      tht:টাহলটান
      ti:টিগৰিনিয়া
      tig:তাইগ্ৰে
      tk:তুৰ্কমেন
      tlh:ক্লিংগন
      tli:লিংগিট
      tn:ছোৱানা
      to:টোঙ্গান
      tok:ট’কি প’না
      tpi:টোক পিছিন
      tr:তুৰ্কী
      trv:তাৰোকো
      ts:ছোঙ্গা
      tt:তাতাৰ
      ttm:নৰ্দাৰ্ন টুটচ’ন
      tum:তুম্বুকা
      tvl:টুভালু
      twq:টাছাৱাক
      ty:তাহিতিয়ান
      tyv:তুভিনিয়ান
      tzm:চেণ্ট্ৰেল এটলাছ টামাজাইট
      udm:উদমুৰ্ত
      ug:উইঘুৰ
      uk:ইউক্ৰেইনীয়
      umb:উম্বুন্দু
      und:অজ্ঞাত ভাষা
      ur:উৰ্দু
      uz:উজবেক
      vai:ভাই
      ve:ভেণ্ডা
      vec:ভেনেছিয়ান
      vi:ভিয়েটনামী
      vmw:মাখুৱা
      vo:ভোলাপুক
      vun:ভুঞ্জু
      wa:ৱালুন
      wae:ৱালছেৰ
      wal:ওলেইটা
      war:ৱাৰে
      wo:ৱোলাফ
      wuu:ৱু চাইনিজ
      xal:কাল্মিক
      xh:হোছা
      xnr:কাংগৰি
      xog:ছোগা
      yav:য়াংবেন
      ybb:য়েম্বা
      yi:ইদ্দিছ
      yo:ইউৰুবা
      yrl:হিংগাটো
      yue:কেণ্টোনীজ
      yue-alt-menu:চাইনিজ, কেণ্টোনীজ
      za:ঝুৱাং
      zgh:ষ্টেণ্ডাৰ্ড মোৰোক্কান তামাজাইট
      zh:চীনা
      zh-alt-menu:চীনা, মেণ্ডাৰিন
      zh-Hans:সৰলীকৃত চীনা
      zh-Hans-alt-long:সৰলীকৃত মেণ্ডাৰিন চীনা
      zh-Hant:পৰম্পৰাগত চীনা
      zh-Hant-alt-long:পৰম্পৰাগত মেণ্ডাৰিন চীনা
      zu:ঝুলু
      zun:ঝুনি
      zxx:কোনো ভাষা সমল নাই
      zza:ঝাঝা
      """.trimIndent() }

  val asa: String by lazy { """
      ak:Kiakan
      am:Kiamhari
      ar:Kiarabu
      asa:Kipare
      be:Kibelarusi
      bg:Kibulgaria
      bn:Kibangla
      cs:Kicheki
      de:Kijerumani
      el:Kigiriki
      en:Kiingeredha
      es:Kihithpania
      fa:Kiajemi
      fr:Kifarantha
      ha:Kihautha
      hi:Kihindi
      hu:Kihungari
      id:Kiindonethia
      ig:Kiigbo
      it:Kiitaliaano
      ja:Kijapani
      jv:Kijava
      km:Kikambodia
      ko:Kikorea
      ms:Kimalesia
      my:Kiburma
      ne:Kinepali
      nl:Kiholandhi
      pa:Kipunjabi
      pl:Kipolandi
      pt:Kireno
      ro:Kiromania
      ru:Kiruthi
      rw:Kinyarandwa
      so:Kithomali
      sv:Kithwidi
      ta:Kitamil
      th:Kitailandi
      tr:Kituruki
      uk:Kiukrania
      ur:Kiurdu
      vi:Kivietinamu
      yo:Kiyoruba
      zh:Kichina
      zh-alt-menu:Kichina
      zu:Kidhulu
      """.trimIndent() }

  val ast: String by lazy { """
      aa:afar
      ab:abkhazianu
      ace:achinés
      ach:acoli
      ada:adangme
      ady:adyghe
      ae:avestanín
      aeb:árabe de Túnez
      af:afrikaans
      afh:afrihili
      agq:aghem
      ain:ainu
      ak:akan
      akk:acadianu
      akz:alabama
      ale:aleut
      aln:gheg d’Albania
      alt:altai del sur
      am:amháricu
      an:aragonés
      ang:inglés antiguu
      anp:angika
      ar:árabe
      ar-001:árabe estándar modernu
      arc:araméu
      arn:mapuche
      aro:araona
      arp:arapaho
      arq:árabe d’Arxelia
      arw:arawak
      ary:árabe de Marruecos
      arz:árabe d’Exiptu
      as:asamés
      asa:asu
      ase:llingua de signos americana
      ast:asturianu
      av:aváricu
      avk:kotava
      awa:awadhi
      ay:aymara
      az:azerbaixanu
      az-alt-short:azerí
      ba:bashkir
      bal:baluchi
      ban:balinés
      bar:bávaru
      bas:basaa
      bax:bamun
      bbc:batak toba
      bbj:ghomala
      be:bielorrusu
      bej:beja
      bem:bemba
      bew:betawi
      bez:bena
      bfd:bafut
      bfq:badaga
      bg:búlgaru
      bgn:balochi occidental
      bho:bhojpuri
      bi:bislama
      bik:bikol
      bin:bini
      bjn:banjar
      bkm:kom
      bla:siksika
      bm:bambara
      bn:bengalín
      bo:tibetanu
      bpy:bishnupriya
      bqi:bakhtiari
      br:bretón
      bra:braj
      brh:brahui
      brx:bodo
      bs:bosniu
      bss:akoose
      bua:buriat
      bug:buginés
      bum:bulu
      byn:blin
      byv:medumba
      ca:catalán
      cad:caddo
      car:caribe
      cay:cayuga
      cch:atsam
      ce:chechenu
      ceb:cebuanu
      cgg:chiga
      ch:chamorro
      chb:chibcha
      chg:chagatai
      chk:chuukés
      chm:mari
      chn:xíriga chinook
      cho:choctaw
      chp:chipewyanu
      chr:cheroqui
      chy:cheyenne
      ckb:kurdu central
      ckb-alt-menu:kurdu central
      ckb-alt-variant:kurdu central
      co:corsu
      cop:cópticu
      cps:capiznon
      cr:cree
      crh:turcu de Crimea
      crs:francés criollu seselwa
      cs:checu
      csb:kashubianu
      cu:eslávicu eclesiásticu
      cv:chuvash
      cy:galés
      da:danés
      dak:dakota
      dar:dargwa
      dav:taita
      de:alemán
      de-AT:alemán d’Austria
      de-CH:altualemán de Suiza
      del:delaware
      den:slave
      dgr:dogrib
      din:dinka
      dje:zarma
      doi:dogri
      dsb:baxu sorbiu
      dtp:dusun central
      dua:duala
      dum:neerlandés mediu
      dv:divehi
      dyo:jola-fonyi
      dyu:dyula
      dz:dzongkha
      dzg:dazaga
      ebu:embú
      ee:ewe
      efi:efik
      egl:emilianu
      egy:exipciu antiguu
      eka:ekajuk
      el:griegu
      elx:elamita
      en:inglés
      en-AU:inglés d’Australia
      en-CA:inglés de Canadá
      en-GB:inglés de Gran Bretaña
      en-GB-alt-short:inglés del R.X.
      en-US:inglés d’Estaos Xuníos
      en-US-alt-short:inglés d’EE.XX.
      enm:inglés mediu
      eo:esperanto
      es:español
      es-419:español d’América Llatina
      es-ES:español européu
      es-MX:español de Méxicu
      esu:yupik central
      et:estoniu
      eu:vascu
      ewo:ewondo
      ext:estremeñu
      fa:persa
      fan:fang
      fat:fanti
      ff:fulah
      fi:finlandés
      fil:filipín
      fit:finlandés de Tornedalen
      fj:fixanu
      fo:feroés
      fon:fon
      fr:francés
      fr-CA:francés de Canadá
      fr-CH:francés de Suiza
      frc:francés cajun
      frm:francés mediu
      fro:francés antiguu
      frp:arpitanu
      frr:frisón del norte
      frs:frisón oriental
      fur:friulianu
      fy:frisón occidental
      ga:irlandés
      gaa:ga
      gag:gagauz
      gan:chinu gan
      gay:gayo
      gba:gbaya
      gbz:dari zoroastrianu
      gd:gaélicu escocés
      gez:geez
      gil:gilbertés
      gl:gallegu
      glk:gilaki
      gmh:altualemán mediu
      gn:guaraní
      goh:altualemán antiguu
      gon:gondi
      gor:gorontalo
      got:góticu
      grb:grebo
      grc:griegu antiguu
      gsw:alemán de Suiza
      gu:guyaratí
      guc:wayuu
      gur:frafra
      guz:gusii
      gv:manés
      gwi:gwichʼin
      ha:ḥausa
      hai:haida
      hak:chinu hakka
      haw:hawaianu
      he:hebréu
      hi:hindi
      hif:hindi de Fiji
      hil:hiligaynon
      hit:hitita
      hmn:hmong
      ho:hiri motu
      hr:croata
      hsb:altu sorbiu
      hsn:chinu xiang
      ht:haitianu
      hu:húngaru
      hup:hupa
      hy:armeniu
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonesiu
      ie:interlingue
      ig:igbo
      ii:yi de Sichuán
      ik:inupiaq
      ilo:iloko
      inh:ingush
      io:ido
      is:islandés
      it:italianu
      iu:inuktitut
      izh:ingrianu
      ja:xaponés
      jam:inglés criollu xamaicanu
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jpr:xudeo-persa
      jrb:xudeo-árabe
      jut:jutlandés
      jv:xavanés
      ka:xeorxanu
      kaa:kara-kalpak
      kab:kabileñu
      kac:kachin
      kaj:jju
      kam:kamba
      kaw:kawi
      kbd:kabardianu
      kbl:kanembu
      kcg:tyap
      kde:makonde
      kea:cabuverdianu
      ken:kenyang
      kfo:koro
      kg:kongo
      kgp:kaingang
      kha:khasi
      kho:khotanés
      khq:koyra chiini
      khw:khowar
      ki:kikuyu
      kiu:kirmanjki
      kj:kuanyama
      kk:kazaquistanín
      kkj:kako
      kl:kalaallisut
      kln:kalenjin
      km:ḥemer
      kmb:kimbundu
      kn:canarés
      ko:coreanu
      koi:komi-permyak
      kok:konkani
      kos:kosraeanu
      kpe:kpelle
      kr:kanuri
      krc:karachay-balkar
      kri:krio
      krj:kinaray-a
      krl:karelianu
      kru:kurukh
      ks:cachemirés
      ksb:shambala
      ksf:bafia
      ksh:colonianu
      ku:curdu
      kum:kumyk
      kut:kutenai
      kv:komi
      kw:córnicu
      ky:kirguistanín
      la:llatín
      lad:ladino
      lag:langi
      lah:lahnda
      lam:lamba
      lb:luxemburgués
      lez:lezghianu
      lfn:lingua franca nova
      lg:ganda
      li:limburgués
      lij:ligurianu
      liv:livonianu
      lkt:lakota
      lmo:lombardu
      ln:lingala
      lo:laosianu
      lol:mongo
      loz:lozi
      lrc:luri del norte
      lt:lituanu
      ltg:latgalianu
      lu:luba-katanga
      lua:luba-lulua
      lui:luiseno
      lun:lunda
      luo:luo
      lus:mizo
      luy:luyia
      lv:letón
      lzh:chinu lliterariu
      lzz:laz
      mad:madurés
      maf:mafa
      mag:magahi
      mai:maithili
      mak:makasar
      man:mandingo
      mas:masái
      mde:maba
      mdf:moksha
      mdr:mandar
      men:mende
      mer:meru
      mfe:morisyen
      mg:malgaxe
      mga:írlandés mediu
      mgh:makhuwa-meetto
      mgo:meta’
      mh:marshallés
      mi:maorí
      mic:micmac
      min:minangkabau
      mk:macedoniu
      ml:malayalam
      mn:mongol
      mnc:manchú
      mni:manipuri
      moh:mohawk
      mos:mossi
      mr:marathi
      mrj:mari occidental
      ms:malayu
      mt:maltés
      mua:mundang
      mul:múltiples llingües
      mus:creek
      mwl:mirandés
      mwr:marwari
      mwv:mentawai
      my:birmanu
      mye:myene
      myv:erzya
      mzn:mazanderani
      na:nauru
      nan:chinu min nan
      nap:napolitanu
      naq:nama
      nb:noruegu Bokmål
      nd:ndebele del norte
      nds:baxu alemán
      nds-NL:baxu saxón
      ne:nepalés
      new:newari
      ng:ndonga
      nia:nias
      niu:niueanu
      njo:ao naga
      nl:neerlandés
      nl-BE:flamencu
      nmg:kwasio
      nn:noruegu Nynorsk
      nnh:ngiemboon
      no:noruegu
      nog:nogai
      non:noruegu antiguu
      nov:novial
      nqo:n’ko
      nr:ndebele del sur
      nso:sotho del norte
      nus:nuer
      nv:navajo
      nwc:newari clásicu
      ny:nyanja
      nym:nyamwezi
      nyn:nyankole
      nyo:nyoro
      nzi:nzima
      oc:occitanu
      oj:ojibwa
      om:oromo
      or:oriya
      os:oséticu
      osa:osage
      ota:turcu otomanu
      pa:punyabí
      pag:pangasinan
      pal:pahlavi
      pam:pampanga
      pap:papiamento
      pau:palauanu
      pcd:pícaru
      pcm:nixerianu simplificáu
      pdc:alemán de Pennsylvania
      pdt:plautdietsch
      peo:persa antiguu
      pfl:alemán palatinu
      phn:feniciu
      pi:pali
      pl:polacu
      pms:piamontés
      pnt:pónticu
      pon:pohnpeianu
      prg:prusianu
      pro:provenzal antiguu
      ps:pashtu
      pt:portugués
      pt-BR:portugués del Brasil
      pt-PT:portugués européu
      qu:quechua
      quc:kʼicheʼ
      qug:quichua del altiplanu de Chimborazo
      raj:rajasthanín
      rap:rapanui
      rar:rarotonganu
      rgn:romañol
      rif:rifianu
      rm:romanche
      rn:rundi
      ro:rumanu
      ro-MD:moldavu
      rof:rombo
      rom:romaní
      rtm:rotumanu
      ru:rusu
      rue:rusyn
      rug:roviana
      rup:aromanianu
      rw:kinyarwanda
      rwk:rwa
      sa:sánscritu
      sad:sandavés
      sah:sakha
      sam:araméu samaritanu
      saq:samburu
      sas:sasak
      sat:santali
      saz:saurashtra
      sba:ngambay
      sbp:sangu
      sc:sardu
      scn:sicilianu
      sco:scots
      sd:sindhi
      sdc:sardu sassarés
      sdh:kurdu del sur
      se:sami del norte
      see:séneca
      seh:sena
      sei:seri
      sel:selkup
      ses:koyraboro senni
      sg:sango
      sga:irlandés antiguu
      sgs:samogitianu
      sh:serbo-croata
      shi:tachelhit
      shn:shan
      shu:árabe chadianu
      si:cingalés
      sid:sidamo
      sk:eslovacu
      sl:eslovenu
      sli:baxu silesianu
      sly:selayarés
      sm:samoanu
      sma:sami del sur
      smj:lule sami
      smn:inari sami
      sms:skolt sami
      sn:shona
      snk:soninke
      so:somalín
      sog:sogdianu
      sq:albanu
      sr:serbiu
      srn:sranan tongo
      srr:serer
      ss:swati
      ssy:saho
      st:sotho del sur
      stq:frisón de Saterland
      su:sondanés
      suk:sukuma
      sus:susu
      sux:sumeriu
      sv:suecu
      sw:suaḥili
      sw-CD:suaḥili del Congu
      swb:comorianu
      syc:siriacu clásicu
      syr:siriacu
      szl:silesianu
      ta:tamil
      tcy:tulu
      te:telugu
      tem:timne
      teo:teso
      ter:terena
      tet:tetum
      tg:taxiquistanín
      th:tailandés
      ti:tigrinya
      tig:tigre
      tiv:tiv
      tk:turcomanu
      tkl:tokelau
      tkr:tsakhur
      tl:tagalog
      tlh:klingon
      tli:tlingit
      tly:talixín
      tmh:tamashek
      tn:tswana
      to:tonganu
      tog:tonga nyasa
      tpi:tok pisin
      tr:turcu
      tru:turoyo
      trv:taroko
      ts:tsonga
      tsd:tsakoniu
      tsi:tsimshian
      tt:tártaru
      ttt:tati musulmán
      tum:tumbuka
      tvl:tuvalu
      tw:twi
      twq:tasawaq
      ty:tahitianu
      tyv:tuvinianu
      tzm:tamazight del Atles central
      udm:udmurt
      ug:uigur
      uga:ugaríticu
      uk:ucraín
      umb:umbundu
      und:llingua desconocida
      ur:urdu
      uz:uzbequistanín
      vai:vai
      ve:venda
      vec:venecianu
      vep:vepsiu
      vi:vietnamín
      vls:flamencu occidental
      vmf:franconianu del Main
      vo:volapük
      vot:vóticu
      vro:voro
      vun:vunjo
      wa:valón
      wae:walser
      wal:wolaytta
      war:waray
      was:washo
      wbp:warlpiri
      wo:wolof
      wuu:chinu wu
      xal:calmuco
      xh:xhosa
      xmf:mingrelianu
      xog:soga
      yao:yao
      yap:yapés
      yav:yangben
      ybb:yemba
      yi:yiddish
      yo:yoruba
      yrl:nheengatu
      yue:cantonés
      yue-alt-menu:cantonés
      za:zhuang
      zap:zapoteca
      zbl:simbólicu Bliss
      zea:zeelandés
      zen:zenaga
      zgh:tamazight estándar de Marruecos
      zh:chinu
      zh-alt-menu:chinu
      zh-Hans:chinu simplificáu
      zh-Hans-alt-long:chinu simplificáu
      zh-Hant:chinu tradicional
      zh-Hant-alt-long:chinu tradicional
      zu:zulú
      zun:zuni
      zxx:ensin conteníu llingüísticu
      zza:zaza
      """.trimIndent() }

  val az: String by lazy { """
      aa:afar
      ab:abxaz
      ace:akin
      ach:akoli
      ada:adanqme
      ady:adıgey
      ae:avestan
      af:afrikaans
      afh:afrihili
      agq:aqhem
      ain:aynu
      ak:akan
      akk:akkad
      ale:aleut
      alt:cənubi altay
      am:amhar
      an:araqon
      ang:qədim ingilis
      ann:obolo
      anp:angika
      ar:ərəb
      ar-001:müasir standart ərəb
      arc:aramik
      arn:mapuçe
      arp:arapaho
      ars:Nəcd ərəbcəsi
      arw:aravak
      as:assam
      asa:asu
      ast:asturiya
      atj:Atikamek
      av:avar
      awa:avadhi
      ay:aymara
      az:azərbaycan
      az-alt-short:azəri
      az-Arab:cənubi azərbaycan
      ba:başqırd
      bal:baluc
      ban:bali
      bas:basa
      be:belarus
      bej:beja
      bem:bemba
      bez:bena
      bg:bolqar
      bgc:Haryanvi
      bgn:qərbi bəluc
      bho:bxoçpuri
      bi:bislama
      bik:bikol
      bin:bini
      bla:siksikə
      blo:anii
      bm:bambara
      bn:benqal
      bo:tibet
      br:breton
      bra:braj
      brx:bodo
      bs:bosniya
      bua:buryat
      bug:bugin
      byn:blin
      ca:katalan
      cad:keddo
      car:karib
      cay:Kayuqa
      cch:atsam
      ccp:Çakma
      ce:çeçen
      ceb:sebuan
      cgg:çiqa
      ch:çamoro
      chb:çibça
      chg:çağatay
      chk:çukiz
      chm:mari
      chn:çinuk ləhçəsi
      cho:çoktau
      chp:çipevyan
      chr:çeroki
      chy:çeyen
      ckb:Mərkəzi kürdcə
      ckb-alt-menu:Kürdcə, mərkəzi
      ckb-alt-variant:Kürdcə, sorani
      clc:Çilotin
      co:korsika
      cop:kopt
      cr:kri
      crg:miçif
      crh:krım türkcəsi
      crj:cənub-şərqi kri
      crk:ova kricəsi
      crl:şimal-şəqri kri
      crm:muz kri
      crr:Karolina alonkincəsi
      crs:Seyşel kreol fransızcası
      cs:çex
      csb:kaşubyan
      csw:bataqlıq kricəsi
      cu:slavyan
      cv:çuvaş
      cy:uels
      da:danimarka
      dak:dakota
      dar:darqva
      dav:taita
      de:alman
      de-AT:Avstriya almancası
      de-CH:İsveçrə yüksək almancası
      del:delaver
      den:slavey
      dgr:doqrib
      din:dinka
      dje:zarma
      doi:doqri
      dsb:aşağı sorb
      dua:duala
      dum:orta holland
      dv:maldiv
      dyo:diola
      dyu:dyula
      dz:dzonqxa
      dzg:dazaqa
      ebu:embu
      ee:eve
      efi:efik
      egy:qədim misir
      eka:ekacuk
      el:yunan
      elx:elamit
      en:ingilis
      en-AU:Avstraliya ingiliscəsi
      en-CA:Kanada ingiliscəsi
      en-GB:Britaniya ingiliscəsi
      en-GB-alt-short:ingilis (BK)
      en-US:Amerika ingiliscəsi
      en-US-alt-short:ingilis (ABŞ)
      enm:orta ingilis
      eo:esperanto
      es:ispan
      es-419:Latın Amerikası ispancası
      es-ES:Kastiliya ispancası
      es-MX:Meksika ispancası
      et:eston
      eu:bask
      ewo:evondo
      fa:fars
      fa-AF:dari
      fan:fang
      fat:fanti
      ff:fula
      fi:fin
      fil:filippin
      fj:fici
      fo:farer
      fon:fon
      fr:fransız
      fr-CA:Kanada fransızcası
      fr-CH:İsveçrə fransızcası
      frc:Kacun fransızcası
      frm:orta fransız
      fro:qədim fransız
      frr:şimali fris
      fur:friul
      fy:qərbi friz
      ga:irland
      gaa:qa
      gag:qaqauz
      gan:qan
      gay:qayo
      gba:qabaya
      gd:Şotlandiya keltcəsi
      gez:qez
      gil:qilbert
      gl:qalisiya
      gmh:orta yüksək alman
      gn:quarani
      goh:qədim alman
      gon:qondi
      gor:qorontalo
      got:qotika
      grb:qrebo
      grc:qədim yunan
      gsw:İsveçrə almancası
      gu:qucarat
      guz:qusi
      gv:manks
      gwi:qviçin
      ha:hausa
      hai:hayda
      hak:hakka
      haw:havay
      hax:cənubi haida
      he:ivrit
      hi:hind
      hi-Latn:Hindi (latın)
      hi-Latn-alt-variant:Hindi (latın)
      hil:hiliqaynon
      hit:hittit
      hmn:monq
      ho:hiri motu
      hr:xorvat
      hsb:yuxarı sorb
      hsn:syan
      ht:haiti kreol
      hu:macar
      hup:hupa
      hur:Halkomelem
      hy:erməni
      hz:herero
      ia:interlinqua
      iba:iban
      ibb:ibibio
      id:indoneziya
      ie:interlinqve
      ig:iqbo
      ii:siçuan yi
      ik:inupiaq
      ikt:qərbi Kanada inuktitutu
      ilo:iloko
      inh:inquş
      io:ido
      is:island
      it:italyan
      iu:inuktitut
      ja:yapon
      jbo:loğban
      jgo:nqomba
      jmc:maçam
      jpr:ivrit-fars
      jrb:ivrit-ərəb
      jv:yava
      ka:gürcü
      kaa:qaraqalpaq
      kab:kabile
      kac:kaçin
      kaj:ju
      kam:kamba
      kaw:kavi
      kbd:kabarda-çərkəz
      kcg:tiyap
      kde:makond
      kea:kabuverdian
      kfo:koro
      kg:konqo
      kgp:kaiqanq
      kha:xazi
      kho:xotan
      khq:koyra çiini
      ki:kikuyu
      kj:kuanyama
      kk:qazax
      kkj:kako
      kl:kalaallisut
      kln:kalencin
      km:kxmer
      kmb:kimbundu
      kn:kannada
      ko:koreya
      koi:komi-permyak
      kok:konkani
      kos:kosreyan
      kpe:kpelle
      kr:kanuri
      krc:qaraçay-balkar
      krl:karel
      kru:kurux
      ks:kəşmir
      ksb:şambala
      ksf:bafia
      ksh:köln
      ku:kürd
      kum:kumık
      kut:kutenay
      kv:komi
      kw:korn
      kwk:Kvakvala
      kxv:kuvi
      ky:qırğız
      la:latın
      lad:sefard
      lag:langi
      lah:qərbi pəncab
      lam:lamba
      lb:lüksemburq
      lez:ləzgi
      lg:qanda
      li:limburq
      lij:liquriya dili
      lil:Liluet
      lkt:lakota
      lmo:lombard dili
      ln:linqala
      lo:laos
      lol:monqo
      lou:Luiziana kreolu
      loz:lozi
      lrc:şimali luri
      lsm:saamia
      lt:litva
      lu:luba-katanqa
      lua:luba-lulua
      lui:luyseno
      lun:lunda
      lus:mizo
      luy:luyia
      lv:latış
      mad:maduriz
      mag:maqahi
      mai:maitili
      mak:makasar
      man:məndinqo
      mas:masay
      mdf:mokşa
      mdr:mandar
      men:mende
      mer:meru
      mfe:morisien
      mg:malaqas
      mga:orta irland
      mgh:maxuva-meetto
      mgo:meta’
      mh:marşal
      mi:māori
      mic:mikmak
      min:minanqkaban
      mk:makedon
      ml:malayalam
      mn:monqol
      mnc:mançu
      mni:manipüri
      moe:İnnu-aimun
      moh:mohavk
      mos:mosi
      mr:marathi
      ms:malay
      mt:malta
      mua:mundanq
      mul:çoxsaylı dillər
      mus:krik
      mwl:mirand
      mwr:maruari
      my:birman
      myv:erzya
      mzn:mazandaran
      na:nauru
      nan:Min Nan
      nap:neapolitan
      naq:nama
      nb:bokmal norveç
      nd:şimali ndebele
      nds:aşağı alman
      nds-NL:aşağı sakson
      ne:nepal
      new:nevari
      ng:ndonqa
      nia:nias
      niu:niyuan
      nl:holland
      nl-BE:flamand
      nmg:kvasio
      nn:nünorsk norveç
      nnh:ngiemboon
      no:norveç
      nog:noqay
      non:qədim nors
      nqo:nko
      nr:cənubi ndebele
      nso:şimal soto
      nus:nuer
      nv:navayo
      ny:nyanca
      nym:nyamvezi
      nyn:nyankol
      nyo:nyoro
      nzi:nzima
      oc:oksitan
      oj:ocibva
      ojb:şimal-qərbi ocibva
      ojc:Mərkəzi ocibva
      ojs:ocikri
      ojw:qərbi ocibva
      oka:okanaqan
      om:oromo
      or:odiya
      os:osetin
      osa:osage
      ota:osman
      pa:pəncab
      pag:panqasinan
      pal:pəhləvi
      pam:pampanqa
      pap:papyamento
      pau:palayan
      pcm:niger kreol
      peo:qədim fars
      phn:foyenik
      pi:pali
      pis:picin
      pl:polyak
      pon:ponpey
      pqm:malesit-passamakvodi
      prg:pruss
      pro:qədim provansal
      ps:puştu
      pt:portuqal
      pt-BR:Braziliya portuqalcası
      pt-PT:Portuqaliya portuqalcası
      qu:keçua
      quc:kiçe
      raj:racastani
      rap:rapanui
      rar:rarotonqan
      rhg:Rohinca
      rm:romanş
      rn:rundi
      ro:rumın
      ro-MD:moldav
      rof:rombo
      rom:roman
      ru:rus
      rup:aroman
      rw:kinyarvanda
      rwk:rua
      sa:sanskrit
      sad:sandave
      sah:saxa
      sam:samaritan
      saq:samburu
      sas:sasak
      sat:santal
      sba:nqambay
      sbp:sanqu
      sc:sardin
      scn:siciliya
      sco:skots
      sd:sindhi
      sdh:cənubi kürd
      se:şimali sami
      seh:sena
      sel:selkup
      ses:koyraboro senni
      sg:sanqo
      sga:qədim irland
      sh:serb-xorvat
      shi:taçelit
      shn:şan
      si:sinhala
      sid:sidamo
      sk:slovak
      sl:sloven
      slh:cənubi luşusid
      sm:samoa
      sma:cənubi sami
      smj:lule sami
      smn:inari sami
      sms:skolt sami
      sn:şona
      snk:soninke
      so:somali
      sog:soqdiyen
      sq:alban
      sr:serb
      srn:sranan tonqo
      srr:serer
      ss:svati
      ssy:saho
      st:sesoto
      str:streyts saliş
      su:sundan
      suk:sukuma
      sus:susu
      sux:sumeryan
      sv:isveç
      sw:suahili
      sw-CD:Konqo suahilicəsi
      swb:komor
      syr:suriya
      szl:silez dili
      ta:tamil
      tce:cənubi tuçon
      te:teluqu
      tem:timne
      teo:teso
      ter:tereno
      tet:tetum
      tg:tacik
      tgx:taq
      th:tay
      tht:taltan
      ti:tiqrin
      tig:tiqre
      tiv:tiv
      tk:türkmən
      tkl:tokelay
      tl:taqaloq
      tlh:klinqon
      tli:tlinqit
      tmh:tamaşek
      tn:svana
      to:tonqa
      tog:nyasa tonqa
      tok:tokipona
      tpi:tok pisin
      tr:türk
      trv:taroko
      ts:sonqa
      tsi:simşyan
      tt:tatar
      ttm:şimali tuçon
      tum:tumbuka
      tvl:tuvalu
      tw:tvi
      twq:tasavaq
      ty:taxiti
      tyv:tuvinyan
      tzm:Mərkəzi Atlas tamazicəsi
      udm:udmurt
      ug:uyğur
      uga:uqarit
      uk:ukrayna
      umb:umbundu
      und:naməlum dil
      ur:urdu
      uz:özbək
      ve:venda
      vec:venet dili
      vi:vyetnam
      vmw:makua dili
      vo:volapük
      vot:votik
      vun:vunyo
      wa:valun
      wae:valles
      wal:valamo
      war:varay
      was:vaşo
      wbp:valpiri
      wo:volof
      wuu:vu
      xal:kalmık
      xh:xosa
      xnr:kanqri
      xog:soqa
      yao:yao
      yap:yapiz
      yav:yanqben
      ybb:yemba
      yi:idiş
      yo:yoruba
      yrl:nyenqatu
      yue:kanton
      yue-alt-menu:Çin, kanton
      za:çjuan
      zap:zapotek
      zbl:blisimbols
      zen:zenaqa
      zgh:tamazi
      zh:çin
      zh-alt-menu:Çin, mandarin
      zh-Hans:sadələşmiş çin
      zh-Hans-alt-long:sadələşmiş mandarin çincəsi
      zh-Hant:ənənəvi çin
      zh-Hant-alt-long:ənənəvi mandarin çincəsi
      zu:zulu
      zun:zuni
      zxx:dil məzmunu yoxdur
      zza:zaza
      """.trimIndent() }

  val az_Arab: String by lazy { """
      ab:آبخازجا
      af:آفریکانس
      agq:آقمجه
      ak:آکانجا
      am:آمهارجا
      ar:عربجه
      ar-001:استاندارد عربجه
      as:آسامجا
      asa:آسوجا
      az:آذربایجان تۆرکجه‌سی
      az-alt-short:آذریجه
      az-Arab:تۆرکجه
      ba:باشقیرجا
      be:بئلاروسجا
      bem:بئمباجا
      bez:بئناجا
      bg:بۇلقارجا
      bgn:دوْغو بلوچجا
      bm:بامباراجا
      bn:بنگالجا
      br:برئتونجا
      brx:بوْدوجا
      bs:بوْسنیاجا
      ca:کاتالانجا
      ce:چئچئنجه
      cgg:چیقاجا
      chr:چئروکیجه
      ckb:اوْرتا کۆردجه
      ckb-alt-menu:اوْرتا کۆردجه
      ckb-alt-variant:اوْرتا کۆردجه
      co:کوْرسیکاجا
      cs:چئکجه
      cv:چۇواشجا
      da:دانجا
      de:آلمانجا
      dua:دۇالاجا
      dz:دزونگخا
      ebu:ائمبوجا
      ee:اِوه‌جه
      el:یونانجا
      en:اینگیلیزجه
      eo:اِسپرانتو
      es:اسپانیاجا
      es-419:لاتین آمریکا اسپانیاجاسی
      es-ES:اۇروپا اسپانیاجاسی
      es-MX:مکزیک اسپانیاجاسی
      et:اِستونجا
      eu:باسکجا
      fa:فارسجا
      fi:فینجه
      fil:فیلیپینجه
      fj:فیجیجه
      fo:فاروئه‌جه
      fr:فرانساجا
      gag:قاقائوزجا
      gl:قالیسیاجا
      gsw:سویس آلمانجاسی
      he:عبریجه
      hi:هیندجه
      hr:کروواسجا
      hy:ائرمنیجه
      it:ایتالیاجا
      ja:ژاپونجا
      ka:گۆرجوجه
      kk:قازاقجا
      km:خمئرجه
      ko:کوْره‌جه
      ks:کشمیرجه
      ksf:بافیاجا
      ku:کۆردجه
      kw:کوْرنجا
      ky:قیرقیزجا
      la:لاتینجه
      lg:قانداجا
      lrc:قۇزئی لوْرجه
      mk:مقدونیجه
      mn:موْغولجا
      my:بۇرماجا
      mzn:مازنیجه
      nl:هوْلندجه
      pa:پنجابجا
      ps:پشتوجه
      pt:پوْرتغالجه
      ro:رومانیاجا
      ru:روسجا
      sd:سیندیجه
      sdh:گۆنئی کۆردجه
      sk:اسلواکجا
      sq:آلبانیاجا
      sr:صربجه
      sv:سوئدجه
      sw:سواحیلیجه
      sw-CD:کوْنقو سواحیلیسی
      ta:تامیلجه
      tg:تاجیکجه
      tk:تۆرکمنجه
      tr:آنادولو تۆرکجه‌سی
      tt:تاتارجا
      ug:اۇیغورجا
      uk:اۇکراینجا
      und:تانینمایان دیل
      ur:اوْردوجا
      uz:اؤزبکجه
      vi:ویتنامجا
      zh:چینجه
      zh-alt-menu:چینجه
      zh-Hans:ساده‌لنمیش چینجه
      zh-Hans-alt-long:ساده‌لنمیش چینجه
      zh-Hant:سنتی چینجه
      zh-Hant-alt-long:سنتی چینجه
      zu:زۇلوجا
      """.trimIndent() }

  val az_Arab_IQ: String? = null

  val az_Arab_TR: String? = null

  val az_Cyrl: String by lazy { """
      aa:афар
      ab:абхаз
      ace:акин
      ada:адангме
      ady:адуҝе
      af:африкаанс
      agq:агһем
      ain:ајну
      ak:акан
      ale:алеут
      alt:ҹәнуби алтај
      am:амһар
      an:арагон
      anp:анҝика
      ar:әрәб
      ar-001:мүасир стандарт әрәб
      arn:арауканҹа
      arp:арапаһо
      as:ассам
      asa:асу
      ast:астурија
      av:авар
      awa:авадһи
      ay:ајмара
      az:азәрбајҹан
      az-alt-short:азәрбајҹан
      ba:башгырд
      ban:балли
      bas:баса
      be:беларус
      bem:бемба
      bez:бена
      bg:булгар
      bho:бхочпури
      bi:бислама
      bin:бини
      bla:сиксикә
      bm:бамбара
      bn:бенгал
      bo:тибет
      br:бретон
      brx:бодо
      bs:босниак
      bug:буҝин
      byn:блин
      ca:каталан
      ce:чечен
      ceb:себуан
      cgg:чига
      ch:чаморо
      chk:чукиз
      chm:мари
      cho:чоктау
      chr:чероки
      chy:чејен
      ckb:соран
      ckb-alt-menu:соран
      ckb-alt-variant:соран
      co:корсика
      crs:сејшел креолу
      cs:чех
      cu:славјан
      cv:чуваш
      cy:уелс
      da:данимарка
      dak:дакота
      dar:даргва
      dav:таита
      de:алман
      de-AT:Австрија алманҹасы
      de-CH:Исвечрә јүксәк алманҹасы
      dgr:догриб
      dje:зарма
      dsb:ашағы сорб
      dua:дуала
      dv:малдив
      dyo:диола
      dz:дзонга
      dzg:дазага
      ebu:ембу
      ee:еве
      efi:ефик
      eka:екаҹук
      el:јунан
      en:инҝилис
      en-AU:Австралија инҝилисҹәси
      en-CA:Канада инҝилисҹәси
      en-GB:Британија инҝилисҹәси
      en-GB-alt-short:инҝилис (Б.К.)
      en-US:Америка инҝилисҹәси
      en-US-alt-short:инҝилис (АБШ)
      eo:есперанто
      es:испан
      es-419:Латын Америкасы испанҹасы
      es-ES:Кастилија испанҹасы
      es-MX:Мексика испанҹасы
      et:естон
      eu:баск
      ewo:евондо
      fa:фарс
      ff:фула
      fi:фин
      fil:филиппин
      fj:фиҹи
      fo:фарер
      fon:фон
      fr:франсыз
      fr-CA:Канада франсызҹасы
      fr-CH:Исвечрә франсызҹасы
      fur:фриул
      fy:гәрби фриз
      ga:ирланд
      gaa:га
      gd:шотланд келт
      gez:гез
      gil:гилберт
      gl:галисија
      gn:гуарани
      gor:горонтало
      gsw:Исвечрә алманҹасы
      gu:гуҹарат
      guz:гуси
      gv:манкс
      gwi:гвичин
      ha:һауса
      haw:һавај
      he:иврит
      hi:һинд
      hil:һилигајнон
      hmn:монг
      hr:хорват
      hsb:јухары сорб
      ht:һаити креол
      hu:маҹар
      hup:һупа
      hy:ермәни
      hz:һереро
      ia:интерлингве
      iba:ибан
      ibb:ибибио
      id:индонезија
      ig:игбо
      ilo:илоко
      inh:ингуш
      io:идо
      is:исланд
      it:италјан
      iu:инуктитут
      ja:јапон
      jbo:лоғбан
      jgo:нгомба
      jmc:мачам
      jv:јава
      ka:ҝүрҹү
      kab:кабиле
      kac:качин
      kaj:жу
      kam:камба
      kbd:кабарда-чәркәз
      kcg:тви
      kde:маконде
      kea:кабувердиан
      kfo:коро
      kha:хази
      khq:којра чиини
      ki:кикују
      kj:куанјама
      kk:газах
      kkj:како
      kl:калааллисут
      kln:каленҹин
      km:кхмер
      kmb:кимбунду
      kn:каннада
      ko:кореја
      kok:конкани
      kpe:кпелле
      kr:канури
      krc:гарачај-балкар
      krl:карел
      kru:курух
      ks:кәшмир
      ksb:шамбала
      ksf:бафиа
      ksh:көлн
      ku:күрд
      kum:кумык
      kv:коми
      kw:корн
      ky:гырғыз
      la:латын
      lad:сефард
      lag:ланҝи
      lb:лүксембург
      lez:ләзҝи
      lg:ганда
      li:лимбург
      lkt:лакота
      ln:лингала
      lo:лаос
      loz:лози
      lrc:шимали лури
      lt:литва
      lu:луба-катанга
      lua:луба-лулуа
      lun:лунда
      luo:луо
      lus:мизо
      luy:лујиа
      lv:латыш
      mad:мадуриз
      mag:магаһи
      mai:маитили
      mak:макасар
      mas:масај
      mdf:мокша
      men:менде
      mer:меру
      mfe:морисиен
      mg:малагас
      mgh:махува-меетто
      mgo:метаʼ
      mh:маршал
      mi:маори
      mic:микмак
      min:минангкабан
      mk:македон
      ml:малајалам
      mn:монгол
      mni:манипүри
      moh:моһавк
      mos:моси
      mr:маратһи
      ms:малај
      mt:малта
      mua:мунданг
      mul:чохсајлы дилләр
      mus:крик
      mwl:миранд
      my:бирман
      myv:ерзја
      mzn:мазандаран
      na:науру
      nap:неаполитан
      naq:нама
      nb:бокмал норвеч
      nd:шимали ндебеле
      nds-NL:ашағы саксон
      ne:непал
      new:невари
      ng:ндонга
      nia:ниас
      niu:нијуан
      nl:һолланд
      nl-BE:фламанд
      nmg:квасио
      nn:нүнорск норвеч
      nnh:нҝиембоон
      nog:ногај
      nqo:нго
      nr:ҹәнуби ндебеле
      nso:шимали сото
      nus:нуер
      nv:навајо
      ny:нјанҹа
      nyn:нјанкол
      oc:окситан
      om:оромо
      or:одија
      os:осетин
      pa:пәнҹаб
      pag:пангасинан
      pam:пампанга
      pap:папјаменто
      pau:палајан
      pcm:ниҝер креол
      pl:полјак
      prg:прусс
      ps:пушту
      pt:португал
      pt-BR:Бразилија португалҹасы
      pt-PT:Португалија португалҹасы
      qu:кечуа
      quc:киче
      rap:рапануи
      rar:раротонган
      rm:романш
      rn:рунди
      ro:румын
      rof:ромбо
      ru:рус
      rup:ароман
      rw:кинјарванда
      rwk:руа
      sa:санскрит
      sad:сандаве
      sah:саха
      saq:самбуру
      sat:сантал
      sba:нгамбај
      sbp:сангу
      sc:сардин
      scn:сиҹилија
      sco:скотс
      sd:синдһи
      se:шимали сами
      seh:сена
      ses:којраборо сенни
      sg:санго
      shi:тачелит
      shn:шан
      si:синһала
      sk:словак
      sl:словен
      sm:самоа
      sma:ҹәнуби сами
      smj:луле сами
      smn:инари сами
      sms:сколт сами
      sn:шона
      snk:сонинке
      so:сомали
      sq:албан
      sr:серб
      srn:сранан тонго
      ss:свати
      ssy:саһо
      st:сесото
      su:сундан
      suk:сукума
      sv:исвеч
      sw:суаһили
      sw-CD:Конго суаһилиҹәси
      swb:комор
      syr:сурија
      ta:тамил
      te:телугу
      tem:тимне
      teo:тесо
      tet:тетум
      tg:таҹик
      th:тај
      ti:тигрин
      tig:тигре
      tk:түркмән
      tlh:клингон
      tn:свана
      to:тонган
      tpi:ток писин
      tr:түрк
      trv:тароко
      ts:сонга
      tt:татар
      tum:тумбука
      tvl:тувалу
      twq:тасаваг
      ty:тахити
      tyv:тувинјан
      tzm:Мәркәзи Атлас тамазиҹәси
      udm:удмурт
      ug:ујғур
      uk:украјна
      umb:умбунду
      und:намәлум дил
      ur:урду
      uz:өзбәк
      vai:ваи
      ve:венда
      vi:вјетнам
      vo:волапүк
      vun:вунјо
      wa:валун
      wae:валлес
      wal:валамо
      war:варај
      wo:волоф
      xal:калмык
      xh:хоса
      xog:сога
      yav:јангбен
      ybb:јемба
      yi:идиш
      yo:јоруба
      yue:кантон
      yue-alt-menu:кантон
      zgh:тамази
      zh:чин
      zh-alt-menu:чин
      zh-Hans:садәләшмиш чин
      zh-Hans-alt-long:садәләшмиш чин
      zh-Hant:әнәнәви чин
      zh-Hant-alt-long:әнәнәви чин
      zu:зулу
      zun:зуни
      zxx:дил мәзмуну јохдур
      zza:заза
      """.trimIndent() }

  val az_Latn: String? = null

  val ba: String by lazy { """
      ba:башҡорт теле
      """.trimIndent() }

  val bal: String by lazy { """
      bal:بلۆچی
      zh:چینی
      zh-alt-menu:چینی
      zh-Hans:ساده کرتگێن چینی
      zh-Hans-alt-long:ساده کرتگێن چینی
      """.trimIndent() }

  val bal_Arab: String? = null

  val bal_Latn: String by lazy { """
      aa:Apar
      ab:Abkházi
      af:Aprikái
      agq:Agem
      ak:Akan
      am:Amhari
      an:Aragóni
      ann:Obóló
      apc:Latwiái Arabi
      ar:Arabi
      ar-001:Arabi (Donyá)
      arn:Mapuche
      as:Asámi
      asa:Asu
      ast:Asturiái
      az:Ázerbáijáni
      az-alt-short:Ázerbáijáni
      ba:Bashkar
      bal:Balóchi
      bal-Latn:Balóchi (Látin)
      bas:Basá
      be:Bélárusi
      bem:Bembá
      bew:Betawi
      bez:Bená
      bg:Bolgáriái
      bgc:Haryánui
      bgn:Balóchi (Róbarkati)
      bho:Bójpuri
      blo:Ani
      blt:Tái Dam
      bm:Bambará
      bn:Bangáli
      bo:Tebbati
      br:Brétón
      brx:Bodó
      bs:Busniái
      bss:Akuse
      byn:Blin
      ca:Katálan
      cad:Kaddó-kad
      cch:Atsam
      ccp:Chakmá
      ce:Chechen
      ceb:Chebuánó
      cgg:Chigá
      cho:Choktaw
      chr:Cheruki
      cic:Chekkásaw
      ckb:Myáni Kordi
      ckb-alt-menu:Myáni Kordi- ckb
      ckb-alt-variant:Myáni Kordi-men
      co:Korsiki
      cs:Chek
      csw:Swampi Kri
      cu:Charch Sláwi
      cv:Chuwash
      cy:Wéli
      da:Denmárki
      dav:Táitá
      de:Jarman
      dje:Zarmah
      doi:Dogri
      dsb:Láwar Sorbi
      dua:Duálá
      dv:Diwéhi
      dyo:Jólá-Póni
      dz:Dzongká
      ebu:Embó
      ee:Ewe
      el:Yunáni
      en:Engrézi
      en-CA:Engrézi (Kaynadhá)
      eo:Esperántu
      es:Espini
      es-419:Espini (Látini Amriká)
      es-MX:Espini (Meksikó)
      et:Estóniái
      eu:Bask
      ewo:Ewondó
      fa:Pársi
      fa-AF:Pársi (AF)
      ff:Pulá
      fi:Fenlándi
      fil:Pelpini
      fo:Paróese
      fr:Paránsi
      fr-CA:Paránsi (Kaynadhá)
      frc:Kájon Pránsi
      frr:Shemáli Prési
      fur:Priuli
      fy:Ferisi (Róbarkati)
      ga:Áeri
      gaa:Gaa
      gd:Eskáti Géli
      gez:Géz
      gl:Galéki
      gn:Guárián
      gsw:Swiz Jarman
      gu:Gojráti
      guz:Gusi
      gv:Manks
      ha:Hausá
      haw:Hawái
      he:Ebráni
      hi:Hendi
      hi-Latn:"Hendi (Látin Engrézi (Látin) Engrézi (Látin, Amrikáay Tepákén Están) syáhag: Látini)"
      hi-Latn-alt-variant:"Hendi (Látin Engrézi (Látin) Engrézi (Látin, Amrikáay Tepákén Están) syáhag: Látini)"
      hnj:Hmang Njuá
      hr:Króshiái
      hsb:Borzi Sorbiái
      hu:Hangári
      hy:Arminiái
      ia:Myánzobáni
      id:Endónési
      ie:Myánzobán
      ig:Igbó
      ii:Sichuái Yi
      io:Idó
      is:Islándi
      it:Itáliái
      iu:Inuktitut
      ja:Jápáni
      jbo:Lojban
      jgo:Ngombá
      jmc:Makami
      jv:Jáwáni
      ka:Járjiái
      kaa:Kara-Kalpak
      kab:Kabáile
      kaj:Jju
      kam:Kambá
      kcg:Tyáp
      kde:Makonde
      kea:Kubuwerdiánó
      ken:Kinyang
      kgp:Káingáng
      khq:Koirá Chini
      ki:Kikuyu
      kk:Kázák
      kkj:Kákó
      kl:Kalállisut
      kln:Kalenjin
      km:Khmér
      kn:Kannadá
      ko:Kuriái
      kok:Konkani
      kpe:Kpelle
      ks:Kashmiri
      ksb:Shambalá
      ksf:Bapiá
      ksh:Kologni
      ku:Kordi
      kw:Kornesh
      kxv:Kuwi
      ky:Kirgez
      la:Látini
      lag:Langi
      lb:Logzemborgi
      lg:Gandá
      lij:Liguri
      lkt:Lakótá
      lld:Ladin
      lmo:Lombard
      ln:Lingálá
      lo:Láó
      lou:Luisiáná Krióle
      lrc:Shemáli Lori
      lt:Litwániái
      ltg:Latgali
      lu:Lubá-Katangá
      luo:Luó
      luy:Luiá
      lv:Latwiái
      mai:Maitéli
      mas:Masai
      mdf:Moksha
      mer:Méru
      mfe:Murisén
      mg:Malagase
      mgh:Makuá-Mitó
      mgo:Métá
      mhn:Móchénó
      mi:Muri
      mic:Mikmaw
      mk:Makduni
      ml:Malyálam
      mn:Mangóli
      mni:Manipuri
      moh:Mohawk
      mr:Maráthi
      ms:Malai
      mt:Maltiz
      mua:Mundang
      mul:Báz zobán
      mus:Muskógi
      my:Barmái
      myv:Erziá
      mzn:Mázendaráni
      naq:Nama
      nb:Nárwiji Bokmál
      nd:Shemáli Nedébéle
      nds:Láw Jarman
      nds-NL:Láw Jarman (NL)
      ne:Népáli
      nl:Dacch
      nl-BE:Dacch (Béljiam)
      nmg:Kwásiu
      nn:Nárwiji Nókén
      nnh:Ngembun
      no:Nárwiji
      nqo:Nko
      nr:Zerbári Nedebéli
      nso:Shemáli Sotó
      nus:Nuér
      nv:Nawájó
      ny:Nyanjá
      nyn:Nyankóle
      oc:Ositi
      om:Oromó
      or:Odi
      os:Oséti
      osa:Oságá
      pa:Panjábi
      pap:Pápiámentó
      pcm:Náijiri Pidgin
      pis:Pijen
      pl:Pólayndi
      prg:Prushiái
      ps:Pashtó
      pt:Portagáli
      qu:Kwichu
      quc:Kichi
      raj:Rájestáni
      rhg:Róhengiá
      rif:Ripi
      rm:Rumansh
      rn:Róndi
      ro:Rumániái
      ro-MD:Rumániái (MD)
      rof:Rombó
      ru:Rusi
      rw:Kenyarwandá
      rwk:Rwa
      sa:Sanskeret
      sah:Yakut
      saq:Samboró
      sat:Santali
      sbp:Sangu
      sc:Sardéniái
      scn:Sesiliái
      sd:Sendi
      sdh:Zerbári Kordi
      se:Shemáli Sámi
      seh:Sená
      ses:Koryáburó Senni
      sg:Sangó
      shi:Tachelhit
      shn:Shan
      si:Senhálá
      sid:Sidámó
      sk:Solwák
      skr:Saráeki
      sl:Solwiniái
      sma:Zerbári Sámi
      smj:Lule Sámi
      smn:Inári Sámi
      sms:Eskált Sámi
      sn:Shoná
      so:Sómáli
      sq:Albániái
      sr:Sarbiái
      ss:Swáti
      ssy:Sahó
      st:Zerbári Sutó
      su:Sudáni
      sv:Swidi
      sw:Swáhéli
      sw-CD:Swáhéli (CD)
      syr:Siriek
      szl:Selisi
      ta:Támel
      te:Telgó
      teo:Tésó
      tg:Tájek
      th:Tái
      ti:Tigriniá
      tig:Tigré
      tk:Trkm
      tn:Tuswáná
      to:Tongan
      tok:Tóki Póná
      tpi:Tok Pisin
      tr:Tork
      trv:Torokó
      trw:Torwáli
      ts:Tesungá
      tt:Tátar
      twq:Tasawak
      tyv:Tuwini
      tzm:Tzm
      ug:Yughor
      uk:Yukrini
      und:Nagisshetagén zobán
      ur:Urdu
      uz:Ozbek
      vai:Wái
      ve:Wendá
      vec:Weneti
      vi:Wietnámi
      vmw:Makuwá
      vo:Wolápuk
      vun:Wunjó
      wa:Wallun
      wae:Welser
      wal:Wolettá
      wbp:Warlpiri
      wo:Wolop
      xh:Khushá
      xnr:Kangri
      xog:Sugá
      yav:Yangben
      yi:Yeddi
      yo:Yorobá
      yrl:Ningátu
      yue:Kantóni
      yue-alt-menu:Kantóni-yue
      za:Zhuáng
      zgh:Gisshetqagén Moróki Tamázi
      zh:Chini
      zh-alt-menu:Chini
      zu:Zulu
      zxx:Hecch zobán
      """.trimIndent() }

  val bas: String by lazy { """
      ak:Hɔp u akan
      am:Hɔp u amhārìk
      ar:Hɔp u arâb
      bas:Ɓàsàa
      be:Hɔp u bièlòrûs
      bg:Hɔp u bûlgâr
      bn:Hɔp u bɛŋgàli
      cs:Hɔp u cɛ̂k
      de:Hɔp u jamân
      el:Hɔp u gri ᷇kyà
      en:Hɔp u ŋgisì
      es:Hɔp u panyā
      fa:Hɔp u pɛrsìà
      fr:Hɔp u pulàsi
      ha:Hɔp u ɓausa
      hi:Hɔp u hindì
      hu:Hɔp u hɔŋgrìi
      id:Hɔp u indònesìà
      ig:Hɔp u iɓò
      it:Hɔp u italìà
      ja:Hɔp u yapàn
      jv:Hɔp u yavà
      km:Hɔp u kmɛ̂r
      ko:Hɔp u kɔrēà
      ms:Hɔp u makɛ᷆
      my:Hɔp u birmàn
      ne:Hɔp u nepa᷆l
      nl:Hɔp u nlɛ̀ndi
      pa:Hɔp u pɛnjàbi
      pl:Hɔp u pɔlɔ̄nà
      pt:Hɔp u pɔtɔ̄kì
      ro:Hɔp u rùmanìà
      ru:Hɔp u ruslànd
      rw:Hɔp u ruāndà
      so:Hɔp u somàlî
      sv:Hɔp u suɛ᷆d
      ta:Hɔp u tamu᷆l
      th:Hɔp u tây
      tr:Hɔp u tûrk
      uk:Hɔp u ukrǎnìà
      ur:Hɔp u urdù
      vi:Hɔp u vyɛ̄dnàm
      yo:Hɔp u yorūbà
      zh:Hɔp u kinà
      zh-alt-menu:Hɔp u kinà
      zu:Hɔp u zulù
      """.trimIndent() }

  val be: String by lazy { """
      aa:афарская
      ab:абхазская
      ace:ачэх
      ada:адангмэ
      ady:адыгейская
      af:афрыкаанс
      agq:агем
      ain:айнская
      ak:акан
      akk:акадская
      ale:алеуцкая
      alt:паўднёваалтайская
      am:амхарская
      an:арагонская
      ang:стараанглійская
      ann:абола
      anp:ангіка
      ar:арабская
      ar-001:сучасная стандартная арабская
      arc:арамейская
      arn:мапудунгун
      arp:арапаха
      ars:недждыйская арабская
      as:асамская
      asa:асу
      ast:астурыйская
      atj:атыкамек
      av:аварская
      awa:авадхі
      ay:аймара
      az:азербайджанская
      az-alt-short:азербайджанская
      ba:башкірская
      ban:балійская
      bas:басаа
      be:беларуская
      bem:бемба
      bez:бена
      bg:балгарская
      bgc:харыанві
      bgn:заходняя белуджская
      bho:бхаджпуры
      bi:біслама
      bin:эда
      bla:блэкфут
      blo:аніі
      bm:бамбара
      bn:бенгальская
      bo:тыбецкая
      br:брэтонская
      brx:бода
      bs:баснійская
      bua:бурацкая
      bug:бугіс
      byn:білен
      ca:каталанская
      cay:каюга
      ccp:чакма
      ce:чачэнская
      ceb:себуана
      cgg:чыга
      ch:чамора
      chb:чыбча
      chk:чуук
      chm:мары
      cho:чокта
      chp:чыпеваян
      chr:чэрокі
      chy:шэйен
      ckb:цэнтральнакурдская
      ckb-alt-menu:курдская, сарані
      ckb-alt-variant:сарані
      clc:чылькатын
      co:карсіканская
      cop:копцкая
      crg:мічыф
      crj:паўднёва-ўсходняя кры
      crk:раўнінны кры
      crl:паўночна-ўсходняя кры
      crm:муская кры
      crr:каралінская алганкійская
      crs:сэсэльва
      cs:чэшская
      csw:балотная кры
      cu:царкоўнаславянская
      cv:чувашская
      cy:валійская
      da:дацкая
      dak:дакота
      dar:даргінская
      dav:таіта
      de:нямецкая
      de-AT:аўстрыйская нямецкая
      de-CH:швейцарская літаратурная нямецкая
      dgr:догрыб
      dje:зарма
      doi:догры
      dsb:ніжнялужыцкая
      dua:дуала
      dv:мальдыўская
      dyo:джола-фоньі
      dz:дзонг-кэ
      dzg:дазага
      ebu:эмбу
      ee:эве
      efi:эфік
      egy:старажытнаегіпецкая
      eka:экаджук
      el:грэчаская
      en:англійская
      en-AU:аўстралійская англійская
      en-CA:канадская англійская
      en-GB:брытанская англійская
      en-GB-alt-short:вялікабрытанская англійская
      en-US:амерыканская англійская
      en-US-alt-short:англійская (ЗША)
      eo:эсперанта
      es:іспанская
      es-419:лацінаамерыканская іспанская
      es-ES:еўрапейская іспанская
      es-MX:мексіканская іспанская
      et:эстонская
      eu:баскская
      ewo:эвонда
      fa:фарсі
      fa-AF:дары
      ff:фула
      fi:фінская
      fil:філіпінская
      fj:фіджыйская
      fo:фарэрская
      fon:фон
      fr:французская
      fr-CA:канадская французская
      fr-CH:швейцарская французская
      frc:каджунская французская
      fro:старафранцузская
      frr:паўночнафрызская
      fur:фрыульская
      fy:заходняя фрызская
      ga:ірландская
      gaa:га
      gag:гагаузская
      gd:шатландская гэльская
      gez:геэз
      gil:кірыбаці
      gl:галісійская
      gn:гуарані
      gor:гарантала
      grc:старажытнагрэчаская
      gsw:швейцарская нямецкая
      gu:гуджараці
      guz:гусіі
      gv:мэнская
      gwi:гуіч’ін
      ha:хауса
      hai:хайда
      haw:гавайская
      hax:паўднёвая хайда
      he:іўрыт
      hi:хіндзі
      hi-Latn-alt-variant:хінгліш
      hil:хілігайнон
      hmn:хмонг
      hr:харвацкая
      hsb:верхнялужыцкая
      ht:гаіцянская крэольская
      hu:венгерская
      hup:хупа
      hur:халкамелем
      hy:армянская
      hz:герэра
      ia:інтэрлінгва
      iba:ібан
      ibb:ібібія
      id:інданезійская
      ie:інтэрлінгвэ
      ig:ігба
      ii:сычуаньская йі
      ikt:заходнеканадская інуктытут
      ilo:ілакана
      inh:інгушская
      io:іда
      is:ісландская
      it:італьянская
      iu:інуктытут
      ja:японская
      jbo:ложбан
      jgo:нгомба
      jmc:мачамбэ
      jv:яванская
      ka:грузінская
      kab:кабільская
      kac:качынская
      kaj:дджу
      kam:камба
      kbd:кабардзінская
      kcg:т’яп
      kde:макондэ
      kea:кабувердыяну
      kfo:кора
      kgp:каінганг
      kha:кхасі
      khq:койра чыіні
      ki:кікуйю
      kj:куаньяма
      kk:казахская
      kkj:како
      kl:грэнландская
      kln:календжын
      km:кхмерская
      kmb:кімбунду
      kn:канада
      ko:карэйская
      koi:комі-пярмяцкая
      kok:канкані
      kpe:кпеле
      kr:кануры
      krc:карачай-балкарская
      krl:карэльская
      kru:курух
      ks:кашмірская
      ksb:шамбала
      ksf:бафія
      ksh:кёльнская
      ku:курдская
      kum:кумыцкая
      kv:комі
      kw:корнская
      kwk:квакіутль
      kxv:куві
      ky:кіргізская
      la:лацінская
      lad:ладына
      lag:лангі
      lb:люксембургская
      lez:лезгінская
      lg:ганда
      li:лімбургская
      lij:лігурская
      lil:лілуэт
      lkt:лакота
      lmo:ламбардская
      ln:лінгала
      lo:лаоская
      lol:монга
      lou:луізіянская крэольская
      loz:лозі
      lrc:паўночная луры
      lsm:саамія
      lt:літоўская
      lu:луба-катанга
      lua:луба-касаі
      lun:лунда
      luo:луо
      lus:мізо
      luy:луйя
      lv:латышская
      mad:мадурская
      mag:магахі
      mai:майтхілі
      mak:макасар
      man:мандынг
      mas:маасай
      mdf:макшанская
      men:мендэ
      mer:меру
      mfe:марысьен
      mg:малагасійская
      mgh:макуўа-меета
      mgo:мета
      mh:маршальская
      mi:маары
      mic:мікмак
      min:мінангкабау
      mk:македонская
      ml:малаялам
      mn:мангольская
      mni:мейтэй
      moe:іну-аймун
      moh:мохак
      mos:мосі
      mr:маратхі
      ms:малайская
      mt:мальтыйская
      mua:мунданг
      mul:некалькі моў
      mus:мускогі
      mwl:мірандыйская
      my:бірманская
      myv:эрзянская
      mzn:мазандэранская
      na:науру
      nap:неапалітанская
      naq:нама
      nb:нарвежская (букмол)
      nd:паўночная ндэбеле
      nds:ніжненямецкая
      nds-NL:ніжнесаксонская
      ne:непальская
      new:неўары
      ng:ндонга
      nia:ніас
      niu:ніўэ
      nl:нідэрландская
      nl-BE:фламандская
      nmg:нгумба
      nn:нарвежская (нюношк)
      nnh:нг’ембон
      no:нарвежская
      nog:нагайская
      non:старанарвежская
      nqo:нко
      nr:паўднёвая ндэбеле
      nso:паўночная сота
      nus:нуэр
      nv:наваха
      ny:ньянджа
      nyn:ньянколе
      oc:аксітанская
      oj:аджыбвэ
      ojb:паўночна-заходняя аджыбвэ
      ojc:цэнтральная аджыбвэ
      ojs:оджы-кры
      ojw:заходняя аджыбвэ
      oka:аканаган
      om:арома
      or:орыя
      os:асецінская
      pa:панджабі
      pag:пангасінан
      pam:пампанга
      pap:пап’яменту
      pau:палау
      pcm:нігерыйскі піджын
      peo:стараперсідская
      phn:фінікійская
      pis:саламонскі піджын
      pl:польская
      pqm:малесіт-пасамакуоды
      prg:пруская
      pro:стараправансальская
      ps:пушту
      pt:партугальская
      pt-BR:бразільская партугальская
      pt-PT:еўрапейская партугальская
      qu:кечуа
      quc:кічэ
      raj:раджастханская
      rap:рапануі
      rar:раратонг
      rhg:рахінджа
      rm:рэтараманская
      rn:рундзі
      ro:румынская
      ro-MD:малдаўская
      rof:ромба
      ru:руская
      rup:арумунская
      rw:руанда
      rwk:руа
      sa:санскрыт
      sad:сандаўэ
      sah:якуцкая
      saq:самбуру
      sat:санталі
      sba:нгамбай
      sbp:сангу
      sc:сардзінская
      scn:сіцылійская
      sco:шатландская
      sd:сіндхі
      sdh:паўднёвакурдская
      se:паўночнасаамская
      seh:сена
      ses:кайрабора сэні
      sg:санга
      sga:стараірландская
      sh:сербскахарвацкая
      shi:ташэльхіт
      shn:шан
      si:сінгальская
      sk:славацкая
      sl:славенская
      slh:паўднёвая лушуцыд
      sm:самоа
      sma:паўднёвасаамская
      smj:луле-саамская
      smn:інары-саамская
      sms:колта-саамская
      sn:шона
      snk:санінке
      so:самалі
      sq:албанская
      sr:сербская
      srn:сранан-тонга
      ss:суаці
      ssy:саха
      st:сесута
      str:стрэйтс саліш
      su:сунда
      suk:сукума
      sux:шумерская
      sv:шведская
      sw:суахілі
      sw-CD:кангалезская суахілі
      swb:каморская
      syr:сірыйская
      szl:сілезская
      ta:тамільская
      tce:паўднёвая тутчонэ
      te:тэлугу
      tem:тэмнэ
      teo:тэсо
      tet:тэтум
      tg:таджыкская
      tgx:тагіш
      th:тайская
      tht:тальтан
      ti:тыгрынья
      tig:тыгрэ
      tk:туркменская
      tlh:клінган
      tli:тлінгіт
      tn:тсвана
      to:танганская
      tok:такіпона
      tpi:ток-пісін
      tr:турэцкая
      trv:тарока
      ts:тсонга
      tt:татарская
      ttm:паўночная тутчонэ
      tum:тумбука
      tvl:тувалу
      twq:тасаўак
      ty:таіці
      tyv:тувінская
      tzm:сярэднеатлаская тамазігхт
      udm:удмурцкая
      ug:уйгурская
      uk:украінская
      umb:умбунду
      und:невядомая мова
      ur:урду
      uz:узбекская
      vai:ваі
      ve:венда
      vec:венецыянская
      vi:в’етнамская
      vmw:макуа
      vo:валапюк
      vun:вунджо
      wa:валонская
      wae:вальшская
      wal:волайта
      war:варай
      wbp:варлпіры
      wo:валоф
      wuu:ву
      xal:калмыцкая
      xh:коса
      xnr:кангры
      xog:сога
      yav:янгбэн
      ybb:йемба
      yi:ідыш
      yo:ёруба
      yrl:ньенгату
      yue:кантонскі дыялект кітайскай
      yue-alt-menu:кітайская, кантонскі дыялект
      za:чжуанская
      zap:сапатэк
      zgh:стандартная мараканская тамазіхт
      zh:кітайская
      zh-alt-menu:кітайская, паўночныя дыялекты
      zh-Hans:кітайская (спрошчаныя іерогліфы)
      zh-Hans-alt-long:паўночнакітайская (спрошчаныя іерогліфы)
      zh-Hant:кітайская (традыцыйныя іерогліфы)
      zh-Hant-alt-long:паўночнакітайская (традыцыйныя іерогліфы)
      zu:зулу
      zun:зуні
      zxx:няма моўнага матэрыялу
      zza:зазакі
      """.trimIndent() }

  val be_tarask: String? = null

  val bem: String by lazy { """
      ak:Ichi Akan
      am:Ichi Amhari
      ar:Ichi Arab
      be:Ichi Belarus
      bem:Ichibemba
      bg:Ichi Bulgariani
      bn:Ichi Bengali
      cs:Ichi Cheki
      de:Ichi Jemani
      el:Ichi Griki
      en:Ichi Sungu
      es:Ichi Spanishi
      fa:Ichi Pesia
      fr:Ichi Frenchi
      ha:Ichi Hausa
      hi:Ichi Hindu
      hu:Ichi Hangarian
      id:Ichi Indonesiani
      ig:Ichi Ibo
      it:Ichi Italiani
      ja:Ichi Japanisi
      jv:Ichi Javanisi
      km:Ichi Khmer
      ko:Ichi Koriani
      ms:Ichi Maleshani
      my:Ichi Burma
      ne:Ichi Nepali
      nl:Ichi Dachi
      pa:Ichi Punjabi
      pl:Ichi Polishi
      pt:Ichi Potogisi
      ro:Ichi Romaniani
      ru:Ichi Rusiani
      rw:Ichi Rwanda
      so:Ichi Somalia
      sv:Ichi Swideni
      ta:Ichi Tamil
      th:Ichi Thai
      tr:Ichi Takishi
      uk:Ichi Ukraniani
      ur:Ichi Urudu
      vi:Ichi Vietinamu
      yo:Ichi Yoruba
      zh:Ichi Chainisi
      zh-alt-menu:Ichi Chainisi
      zu:Ichi Zulu
      """.trimIndent() }

  val bez: String by lazy { """
      ak:Hiakan
      am:Hiamhari
      ar:Hiharabu
      be:Hibelarusi
      bez:Hibena
      bg:Hibulgaria
      bn:Hibangla
      cs:Hicheki
      de:Hijerumani
      el:Higiriki
      en:Hiingereza
      es:Hihispania
      fa:Hiajemi
      fr:Hifaransa
      ha:Hihausa
      hi:Hihindi
      hu:Hihungari
      id:Hiindonesia
      ig:Hiibo
      it:Hiitaliano
      ja:Hijapani
      jv:Hijava
      km:Hikambodia
      ko:Hikorea
      ms:Himalesia
      my:Hiburma
      ne:Hinepali
      nl:Hiholanzi
      pa:Hipunjabi
      pl:Hipolandi
      pt:Hileno
      ro:Hilomania
      ru:Hilusi
      rw:Hinyarwanda
      so:Hisomali
      sv:Hiswidi
      ta:Hitamil
      th:Hitailand
      tr:Hituluki
      uk:Hiukrania
      ur:Hiurdu
      vi:Hivietinamu
      yo:Hiyoruba
      zh:Hichina
      zh-alt-menu:Hichina
      zu:Hizulu
      """.trimIndent() }

  val bg: String by lazy { """
      aa:афарски
      ab:абхазки
      ace:ачешки
      ach:аколи
      ada:адангме
      ady:адигейски
      ae:авестски
      af:африканс
      afh:африхили
      agq:агем
      ain:айну
      ak:акан
      akk:акадски
      ale:алеутски
      alt:южноалтайски
      am:амхарски
      an:арагонски
      ang:староанглийски
      ann:оболо
      anp:ангика
      ar:арабски
      ar-001:съвременен стандартен арабски
      arc:арамейски
      arn:мапуче
      arp:арапахо
      ars:найди арабски
      arw:аравак
      as:асамски
      asa:асу
      ast:астурски
      atj:атикамеку
      av:аварски
      awa:авади
      ay:аймара
      az:азербайджански
      az-alt-short:азерски
      ba:башкирски
      bal:балучи
      ban:балийски
      bas:баса
      be:беларуски
      bej:бея
      bem:бемба
      bez:бена
      bg:български
      bgc:харианви
      bgn:западен балочи
      bho:боджпури
      bi:бислама
      bik:биколски
      bin:бини
      bla:сиксика
      blo:ании
      bm:бамбара
      bn:бенгалски
      bo:тибетски
      br:бретонски
      bra:брадж
      brx:бодо
      bs:босненски
      bua:бурятски
      bug:бугински
      byn:биленски
      ca:каталонски
      cad:каддо
      car:карибски
      cay:каюга
      cch:атсам
      ccp:чакма
      ce:чеченски
      ceb:себуански
      cgg:чига
      ch:чаморо
      chb:чибча
      chg:чагатай
      chk:чуук
      chm:марийски
      chn:жаргон чинуук
      cho:чокто
      chp:чипеуански
      chr:черокски
      chy:шайенски
      ckb:кюрдски (централен)
      ckb-alt-menu:кюрдски (централен)
      ckb-alt-variant:кюрдски (Сорани)
      clc:чилкотин
      co:корсикански
      cop:коптски
      cr:крии
      crg:мичиф
      crh:кримскотатарски
      crj:югоизточен крий
      crk:плейнс крий
      crl:североизточен крий
      crm:муус крее
      crr:каролински алгонкин
      crs:сеселва, креолски френски
      cs:чешки
      csb:кашубски
      csw:суампи крий
      cu:църковнославянски
      cv:чувашки
      cy:уелски
      da:датски
      dak:дакотски
      dar:даргински
      dav:таита
      de:немски
      del:делауер
      den:слейви
      dgr:догриб
      din:динка
      dje:зарма
      doi:догри
      dsb:долнолужишки
      dua:дуала
      dum:средновековен холандски
      dv:дивехи
      dyo:диола-фони
      dyu:диула
      dz:дзонгкха
      dzg:дазага
      ebu:ембу
      ee:еве
      efi:ефик
      egy:древноегипетски
      eka:екажук
      el:гръцки
      elx:еламитски
      en:английски
      en-AU:австралийски английски
      en-CA:канадски английски
      en-GB:британски английски
      en-GB-alt-short:английски (UK)
      en-US:американски английски
      en-US-alt-short:английски (US)
      enm:средновековен английски
      eo:есперанто
      es:испански
      et:естонски
      eu:баски
      ewo:евондо
      fa:персийски
      fa-AF:дари
      fan:фанг
      fat:фанти
      ff:фула
      fi:фински
      fil:филипински
      fj:фиджийски
      fo:фарьорски
      fon:фон
      fr:френски
      frc:каджунски френски
      frm:средновековен френски
      fro:старофренски
      frr:северен фризийски
      frs:източнофризийски
      fur:фриулски
      fy:западнофризийски
      ga:ирландски
      gaa:га
      gag:гагаузки
      gay:гайо
      gba:гбая
      gd:шотландски келтски
      gez:гииз
      gil:гилбертски
      gl:галисийски
      gmh:средновисоконемски
      gn:гуарани
      goh:старовисоконемски
      gon:гонди
      gor:горонтало
      got:готически
      grb:гребо
      grc:древногръцки
      gsw:швейцарски немски
      gu:гуджарати
      guz:гусии
      gv:манкски
      gwi:гвичин
      ha:хауса
      hai:хайда
      haw:хавайски
      hax:южен хайда
      he:иврит
      hi:хинди
      hi-Latn-alt-variant:хинглиш
      hil:хилигайнон
      hit:хитски
      hmn:хмонг
      ho:хири моту
      hr:хърватски
      hsb:горнолужишки
      ht:хаитянски креолски
      hu:унгарски
      hup:хупа
      hur:халкомелем
      hy:арменски
      hz:хереро
      ia:интерлингва
      iba:ибан
      ibb:ибибио
      id:индонезийски
      ie:интерлингве
      ig:игбо
      ii:съчуански йи
      ik:инупиак
      ikt:западноканадски инуктитут
      ilo:илоко
      inh:ингушетски
      io:идо
      is:исландски
      it:италиански
      iu:инуктитут
      ja:японски
      jbo:ложбан
      jgo:нгомба
      jmc:мачаме
      jpr:юдео-персийски
      jrb:юдео-арабски
      jv:явански
      ka:грузински
      kaa:каракалпашки
      kab:кабилски
      kac:качински
      kaj:жжу
      kam:камба
      kaw:кави
      kbd:кабардски
      kcg:туап
      kde:маконде
      kea:кабовердиански
      kfo:коро
      kg:конгоански
      kgp:кайнганг
      kha:кхаси
      kho:котски
      khq:койра чиини
      ki:кикую
      kj:кваняма
      kk:казахски
      kkj:како
      kl:гренландски
      kln:календжин
      km:кхмерски
      kmb:кимбунду
      kn:каннада
      ko:корейски
      koi:коми-пермякски
      kok:конкани
      kos:косраен
      kpe:кпеле
      kr:канури
      krc:карачай-балкарски
      krl:карелски
      kru:курук
      ks:кашмирски
      ksb:шамбала
      ksf:бафия
      ksh:кьолнски
      ku:кюрдски
      kum:кумикски
      kut:кутенай
      kv:коми
      kw:корнуолски
      kwk:куак’уала
      kxv:кови
      ky:киргизки
      la:латински
      lad:ладино
      lag:ланги
      lah:лахнда
      lam:ламба
      lb:люксембургски
      lez:лезгински
      lg:ганда
      li:лимбургски
      lij:лигурски
      lil:лилоует
      lkt:лакота
      lmo:ломбардски
      ln:лингала
      lo:лаоски
      lol:монго
      lou:луизиански креолски
      loz:лози
      lrc:северен лури
      lsm:саамски
      lt:литовски
      lu:луба-катанга
      lua:луба-лулуа
      lui:луисеньо
      lun:лунда
      luo:луо
      lus:мизо
      luy:лухя
      lv:латвийски
      mad:мадурски
      mag:магахи
      mai:майтхили
      mak:макасар
      man:мандинго
      mas:масайски
      mdf:мокша
      mdr:мандар
      men:менде
      mer:меру
      mfe:морисиен
      mg:малгашки
      mga:средновековен ирландски
      mgh:макуа мето
      mgo:мета
      mh:маршалезе
      mi:маорски
      mic:микмак
      min:минангкабау
      mk:македонски
      ml:малаялам
      mn:монголски
      mnc:манджурски
      mni:манипурски
      moe:инну-аймун
      moh:мохоук
      mos:моси
      mr:марати
      ms:малайски
      mt:малтийски
      mua:мунданг
      mul:многоезични
      mus:мускогски
      mwl:мирандийски
      mwr:марвари
      my:бирмански
      myv:ерзиа
      mzn:мазандерански
      na:науру
      nap:неаполитански
      naq:нама
      nb:норвежки (букмол)
      nd:северен ндебеле
      nds:долнонемски
      nds-NL:долносаксонски
      ne:непалски
      new:неварски
      ng:ндонга
      nia:ниас
      niu:ниуеан
      nl:нидерландски
      nl-BE:фламандски
      nmg:квасио
      nn:норвежки (нюношк)
      nnh:нгиембун
      no:норвежки
      nog:ногаи
      non:старонорвежки
      nqo:нко
      nr:южен ндебеле
      nso:северен сото
      nus:нуер
      nv:навахо
      nwc:класически невари
      ny:нянджа
      nym:ниамвези
      nyn:нянколе
      nyo:нуоро
      nzi:нзима
      oc:окситански
      oj:оджибва
      ojb:северозападен оджибве
      ojc:централен оджибва
      ojs:оджи крий
      ojw:западен оджибва
      oka:оканаган
      om:оромо
      or:ория
      os:осетински
      osa:осейджи
      ota:отомански турски
      pa:пенджабски
      pag:пангасинан
      pal:пахлави
      pam:пампанга
      pap:папиаменто
      pau:палауан
      pcm:нигерийски пиджин
      peo:староперсийски
      phn:финикийски
      pi:пали
      pis:пиджин
      pl:полски
      pon:понапеан
      pqm:малисеет-пасамакуоди
      prg:пруски
      pro:старопровансалски
      ps:пущу
      ps-alt-variant:пущунски
      pt:португалски
      qu:кечуа
      quc:киче
      raj:раджастански
      rap:рапа нуи
      rar:раротонга
      rhg:рохинга
      rm:реторомански
      rn:рунди
      ro:румънски
      ro-MD:молдовски
      rof:ромбо
      rom:ромски
      ru:руски
      rup:арумънски
      rw:киняруанда
      rwk:рва
      sa:санскрит
      sad:сандаве
      sah:саха
      sam:самаритански арамейски
      saq:самбуру
      sas:сасак
      sat:сантали
      sba:нгамбай
      sbp:сангу
      sc:сардински
      scn:сицилиански
      sco:шотландски
      sd:синдхи
      sdh:южнокюрдски
      se:северносаамски
      seh:сена
      sel:селкуп
      ses:койраборо сени
      sg:санго
      sga:староирландски
      sh:сърбохърватски
      shi:ташелхит
      shn:шан
      si:синхалски
      sid:сидамо
      sk:словашки
      sl:словенски
      slh:южен лашутсийд
      sm:самоански
      sma:южносаамски
      smj:луле-саамски
      smn:инари-саамски
      sms:сколт-саамски
      sn:шона
      snk:сонинке
      so:сомалийски
      sog:согдийски
      sq:албански
      sr:сръбски
      srn:сранан тонго
      srr:серер
      ss:свати
      ssy:сахо
      st:сото
      str:стрейтс салиш
      su:сундански
      suk:сукума
      sus:сусу
      sux:шумерски
      sv:шведски
      sw:суахили
      sw-CD:конгоански суахили
      swb:коморски
      syc:класически сирийски
      syr:сирийски
      szl:силезийски
      ta:тамилски
      tce:южен тучоне
      te:телугу
      tem:темне
      teo:тесо
      ter:терено
      tet:тетум
      tg:таджикски
      tgx:тагиш
      th:тайски
      tht:талтан
      ti:тигриня
      tig:тигре
      tiv:тив
      tk:туркменски
      tkl:токелайски
      tl:тагалог
      tlh:клингонски
      tli:тлингит
      tmh:тамашек
      tn:тсвана
      to:тонгански
      tog:нианса тонга
      tok:токи пона
      tpi:ток писин
      tr:турски
      trv:тароко
      ts:цонга
      tsi:цимшиански
      tt:татарски
      ttm:северен тучоне
      tum:тумбука
      tvl:тувалуански
      tw:туи
      twq:тасавак
      ty:таитянски
      tyv:тувински
      tzm:централноатласки тамазигт
      udm:удмуртски
      ug:уйгурски
      uga:угаритски
      uk:украински
      umb:умбунду
      und:непознат език
      ur:урду
      uz:узбекски
      vai:ваи
      ve:венда
      vec:венециански
      vi:виетнамски
      vmw:макува
      vo:волапюк
      vot:вотик
      vun:вунджо
      wa:валонски
      wae:валзерски немски
      wal:валамо
      war:варай
      was:уашо
      wbp:валпири
      wo:волоф
      wuu:ву китайски
      xal:калмик
      xh:кхоса
      xnr:кангри
      xog:сога
      yao:яо
      yap:япезе
      yav:янгбен
      ybb:йемба
      yi:идиш
      yo:йоруба
      yrl:ненгату
      yue:кантонски
      yue-alt-menu:китайски, кантонски
      za:зуанг
      zap:запотек
      zbl:блис символи
      zen:зенага
      zgh:стандартен марокански тамазигт
      zh:китайски
      zh-alt-menu:китайски, мандарин
      zh-Hans:китайски (опростен)
      zh-Hans-alt-long:китайски, мандарин (опростен)
      zh-Hant:китайски (традиционен)
      zh-Hant-alt-long:китайски, мандарин (традиционен)
      zu:зулуски
      zun:зуни
      zxx:без лингвистично съдържание
      zza:заза
      """.trimIndent() }

  val bgc: String by lazy { """
      bgc:हरियाणवी
      en:अंग्रेजी
      """.trimIndent() }

  val bgn: String by lazy { """
      aa:افار
      ab:آبخازی
      ace:آچه‌ای
      ada:ادانگمی
      ady:ادیغی
      af:افریکانس
      agq:اغیمی
      ain:آینو
      ak:اکانی
      ale:الیوتی
      alt:جهلسرین آلتایی
      am:امهاری
      an:آراگونی
      anp:انگیکای
      ar:عربی
      ar-001:پیشرفته‌این عربی
      arn:ماپوچه‌ای
      arp:اراپاهو
      as:آسامی
      asa:آسو
      ast:آستوری
      av:آواری
      awa:آوادی
      ay:ایمارای
      az:آذربایجانی
      az-alt-short:آذری
      ba:باشقیری
      ban:بالینسی
      bas:باسا
      be:بیلاروسی
      bem:بیمبا
      bez:بینای
      bg:بلغاری
      bgn:بلوچی (رخشانی)
      bho:بهوجپوری
      bi:بیسلامه
      bin:بینی
      bla:سیکسیکا
      bm:بمبارای
      bn:بنگالی
      bo:تبتی
      br:بریتون
      brx:بۆدو
      bs:بوسنی
      bug:بوگینسی
      byn:بلین
      ca:کاتالانی
      ce:چیچینی
      ceb:سینوگبانونی
      cgg:شیگی
      ch:چه‌مروری
      chk:تروسکی
      chm:ماری
      cho:چاکتاوی
      chr:چیروکی
      chy:شاینی زبان
      ckb:مرکزین کوردی
      ckb-alt-menu:مرکزین کوردی
      ckb-alt-variant:مرکزین کوردی
      co:کرسی
      crs:سیشلی کریولین فرانسوی
      cs:چیکی
      cu:سلاواکی کلیسایی
      cv:چواشی
      cy:ولزی
      da:ڈینمارکی
      dak:داکوتی
      dar:دارگوایی
      dav:تایتایی
      de:جرمنی
      de-AT:استرالیاین جرمنی
      de-CH:سویسین جرمنی
      dgr:داگریبی
      dje:زرمی
      dsb:صُربی سفلی
      dua:دوالی
      dv:دیوهی
      dyo:جولا فونی
      dz:دزونگخا
      dzg:دزازا
      ebu:ایمبو
      ee:اوه‌ای
      efi:ایفیکی
      eka:ایکاجوکی
      el:یونانی
      en:انگریزی
      en-AU:استرالیاین انگریزی
      en-CA:کاناڈاین انگریزی
      en-GB:بریتانیاین انگریزی
      en-GB-alt-short:بریتن انگریزی
      en-US:امریکاین انگریزی
      en-US-alt-short:یو اس انگریزی
      eo:اسپرانتوی
      es:هسپانوی
      es-419:لاتین امریکایی هسپانوی
      es-ES:اوروپایین هسپانوی
      es-MX:مکسیکوین هسپانوی
      et:استونیایی
      eu:باسکی
      ewo:اواندویی
      fa:پارسی
      ff:فولایی
      fi:فنلاندی
      fil:فلیپینی
      fj:فیجی
      fo:فاروئی
      fon:فون
      fr:فرانسوی
      fr-CA:کاناڈاین فرانسوی
      fr-CH:اشاره‌این فرانسوی
      fur:فریولی
      fy:روچ‌کپتین فریزی
      ga:ایرلندی
      gaa:گا
      gd:اسکاتلندی گیلی
      gez:گعزی
      gil:گیلبیرتی
      gl:گالیسی
      gn:گوارانی
      gor:گورونتالو
      gsw:جرمنین سوئیسی
      gu:گوجراتی
      guz:گوسی
      gv:مانی
      gwi:گویچنی
      ha:هوسه‌ای
      haw:هاوایی
      he:عبرانی
      hi:هندی
      hil:هیلیگایونی
      hmn:همونگی
      hr:کراوتی
      hsb:علیای سیربی
      ht:کریول آییسینی
      hu:مجارستانی
      hup:هوپی
      hy:ارمنی
      hz:هرویی
      ia:اینترلینگوایی
      iba:ایبانگه
      ibb:ایبیبیو
      id:ایندونیزیایی
      ig:ایگبویی
      ii:یی سیچوان
      ilo:ایلوکانوی
      inh:اینگوشی
      io:ایدوی
      is:ایسلندی
      it:ایتالیایی
      iu:اینوکتیتوتی
      ja:جاپانی
      jbo:لوجبانی
      jgo:نگومبی
      jmc:ماچامه‌ای
      jv:جاوه‌ای
      ka:گرجی
      kab:قبایلی
      kac:کاچینی
      kaj:جیجو
      kam:کامبایی
      kbd:کاباردینی
      kcg:تیاپی
      kde:ماکوندی
      kea:کابووردیانو
      kfo:کورو
      kha:خاسی
      khq:کوجراچینی
      ki:کیکویویی
      kj:کوانیامایی
      kk:قزاقی
      kkj:کاکویی
      kl:گرینلندی
      kln:کالنجین
      km:خمری
      kmb:کیمبوندویی
      kn:کانارا
      ko:کوریایی
      kok:کونکانی
      kpe:کپله‌ای
      kr:کانوری
      krc:قره‌چایی‐بالکاری
      krl:کاریلینی
      kru:کوروخی
      ks:کشمیری
      ksb:شامبالای
      ksf:بافیا
      ksh:کولوگنی
      ku:کوردی
      kum:کومیکی
      kv:کومی
      kw:کورنی
      ky:قیرغیزی
      la:لاتین
      lad:لادینو
      lag:لانگی
      lb:لوگزامبورگی
      lez:لزگی
      lg:گاندایی
      li:لیمبورگی
      lkt:لاکوتا
      ln:لینگالایی
      lo:لائوسی
      loz:لوزی
      lrc:بُرزسرین لوری
      lt:لیتوانی
      lu:لوبایی‐کاتانگا
      lua:لوبایی‐لولوا
      lun:لوندایی
      luo:لوئویی
      lus:لوشه‌ای
      luy:لویایی
      lv:لاتوینی
      mad:مادورایی
      mag:ماگاهی
      mai:مایدیلی
      mak:ماکاساری
      mas:ماسایی
      mdf:موکشی
      men:منده‌ای
      mer:مرویی
      mfe:موریسینی
      mg:مالاگاسی
      mgh:ماکوا متوی
      mgo:میٹایی
      mh:مارشالی
      mi:مائوری
      mic:میکماکی
      min:مینانگ‌کابویی
      mk:مقدونی
      ml:مالایالامی
      mn:منگولی
      mni:مانیپوری
      moh:موهاکی
      mos:موسیی
      mr:مراٹی
      ms:مالایی
      mt:مالته‌ای
      mua:ماندانگی
      mul:چینکه زبان
      mus:کریکی
      mwl:میراندیسی
      my:بورمي
      myv:ارزیای
      mzn:مازندرانی
      na:نائورویی
      nap:ناپلی
      naq:نامایی
      nb:نارویی بوک‌مولی
      nd:بُرزسرین انده‌بله‌ای
      nds-NL:ساکسونی سفلی
      ne:نیپالی
      new:نیواری
      ng:اندونگی
      nia:نیاسی
      niu:نیویی
      nl:هالنڈی
      nl-BE:فلامانی
      nmg:کوازیو
      nn:نارویی نی‌نوشکی
      nnh:انگی‌ایمبونی
      nog:نغایی
      nqo:نکوی
      nr:جهلسرین انده‌بله‌ای
      nso:بُرزسرین سوتویی
      nus:نویری
      nv:ناواهویی
      ny:نیانجی
      nyn:نیانکوله‌ای
      oc:اوکیتایی
      om:اورومویی
      or:اودیه‌ای
      os:آسیتینی
      pa:پنجاپی
      pag:پانگاسینانی
      pam:پامپانگی
      pap:پاپیامنتوی
      pau:پالائویی
      pcm:نایجیریای پیڈگین
      pl:پولنڈی
      prg:پروسی
      ps:پشتو
      pt:پورتگالی
      pt-BR:برازیلین پورتگالی
      pt-PT:اوروپایین پورتگالی
      qu:کچوایی
      quc:کیچه‌
      rap:راپانویی
      rar:راروتونگی
      rm:رومانش
      rn:رونڈی
      ro:رومانی
      ro-MD:مالداوی
      rof:رومبویی
      ru:اوروسی
      rup:آرومانی
      rw:کینیارواندی
      rwk:روایی
      sa:سانسکریٹ
      sad:سانڈاوه‌ای
      sah:یاقوتی
      saq:سامبوروی
      sat:سانٹالی
      sba:انگامبی
      sbp:سانگویی
      sc:ساردینی
      scn:سیسیلی
      sco:اسکاتلندی
      sd:سیندی
      se:بُرزسرین سامی
      seh:سینایی
      ses:کویرابورا سنی
      sg:سانگۆیی
      shi:تاچل‌هیتی
      shn:شانی
      si:سینهالی
      sk:اسلواکی
      sl:اسلوانی
      sm:ساموآیی
      sma:جهلسرین سامی
      smj:لوله سامی
      smn:اناری سمی
      sms:اسکولت سامی
      sn:شونی
      snk:سونینکه‌ای
      so:سومالی
      sq:البانی
      sr:سیربی
      srn:تاکی‌تاکی
      ss:سواتی
      ssy:ساهویی
      st:جهلسرین سوتویی
      su:سونڈی
      suk:سوکومایی
      sv:سویڈنی
      sw:سواحلی
      sw-CD:کانگویی سواحلی
      swb:قمرین
      syr:سریانی
      ta:تامیلی
      te:تلوگویی
      tem:تیمنه‌ای
      teo:تیسویی
      tet:ٹیٹومی
      tg:تاجیکی
      th:تایلندی
      ti:ٹیگرینیایی
      tig:ٹایگری
      tk:تورکمنی
      tlh:کلینگونی
      tn:تسوانی
      to:تونگی
      tpi:توک‌پیسینی
      tr:تورکی
      trv:تاروکویی
      ts:تسونگی
      tt:تاتاری
      tum:تومبوکی
      tvl:ٹووالی
      twq:تسواکی
      ty:تاهیتی
      tyv:ٹووینی
      tzm:مرکزین اتلسین تامازیگتی
      udm:اوڈمورتی
      ug:اویغوری
      uk:اوکراینی
      umb:امبونڈویی
      und:نازانتین زبان
      ur:اوردو
      uz:اوزبکی
      vai:وایی
      ve:وینڈایی
      vi:ویتنامی
      vo:ولاپوکی
      vun:ونجو
      wa:والونی
      wae:والسیری
      wal:وولایٹی
      war:واری
      wo:ولوفی
      xal:کالمیکی
      xh:خوسی
      xog:سوگایی
      yav:یانگبینی
      ybb:یمبی
      yi:یدی
      yo:یوروبایی
      yue:کانتونیونی
      yue-alt-menu:کانتونیونی
      zgh:آمازیغی مراکشی معیار
      zh:چینایی
      zh-alt-menu:چینایی
      zh-Hans:ساده‌گین چینایی
      zh-Hans-alt-long:ساده‌گین چینایی
      zh-Hant:غدیمین چینایی
      zh-Hant-alt-long:غدیمین چینایی
      zu:زولویی
      zun:زونی
      zxx:بغیر شه زبانین لڑا
      zza:زازایی
      """.trimIndent() }

  val bgn_AE: String? = null

  val bgn_AF: String? = null

  val bgn_IR: String? = null

  val bgn_OM: String? = null

  val bho: String by lazy { """
      bho:भोजपुरी
      en:अंगरेजी
      """.trimIndent() }

  val blo: String by lazy { """
      ar:gɩlaaribuja
      ar-001:gɩlaaribuja ŋgɩɖee kǝ ba na fʊba na
      blo:anii kagɩja
      bn:baŋglaa kagɩja
      de:gɩjaamaja
      en:gɛɛshɩ
      en-US:gɛɛshɩ (Ganɔ gaɖɔŋkɔnɔ kabʊtǝna Amalɩka nɩ)
      en-US-alt-short:gɛɛshɩ (GKA)
      es:gɩspaŋja
      es-419:gɩspaŋja (latɛŋ kaAmalɩkatǝna)
      fr:gɩfɔnɔ
      hi-Latn:hinɖii kagɩja (latɛŋ kʊja)
      hi-Latn-alt-variant:hiŋgliishɩ kagɩja
      id:Ɛnɖonosii kagɩja
      it:gɩtaliija
      ja:gɩjapaŋja
      ko:Koree kagɩja
      nl:Holanɖ kagɩja
      pl:Polanɖ kagɩja
      pt:gɩpɔrtigalja
      ru:gɩrɔɔshɩyaja
      th:taɩ kagɩja
      tr:gɩturkiija
      und:gɩkrǝ ŋgɩɖee kʊyɔʊ ʊ mana ma
      zh:gɩcaɩnaja manɖarɛŋ
      zh-alt-menu:gɩcaɩnaja, manɖarɛŋ
      zh-Hans:gɩcaɩnaja gɩburoka
      zh-Hans-alt-long:gɩcaɩnaja manɖarɛŋ gɩburoka
      zh-Hant:gɩcaɩnaja tututu
      zh-Hant-alt-long:gɩcaɩnaja manɖarɛŋ tututu
      """.trimIndent() }

  val blt: String by lazy { """
      blt:ꪼꪕꪒꪾ
      """.trimIndent() }

  val bm: String by lazy { """
      ak:akankan
      am:amarikikan
      ar:larabukan
      be:biyelorisikan
      bg:buligarikan
      bm:bamanakan
      bn:bɛngalikan
      cs:cɛkikan
      de:alimaɲikan
      el:gɛrɛsikan
      en:angilɛkan
      es:esipaɲolkan
      fa:perisanikan
      fr:tubabukan
      ha:awusakan
      hi:inidikan
      hu:oŋirikan
      id:Ɛndonezikan
      ig:igibokan
      it:italikan
      ja:zapɔnekan
      jv:javanekan
      km:kambojikan
      ko:korekan
      ms:malɛzikan
      my:birimanikan
      ne:nepalekan
      nl:olandekan
      pa:pɛnijabikan
      pl:polonekan
      pt:pɔritigalikan
      ro:rumanikan
      ru:irisikan
      rw:ruwandakan
      so:somalikan
      sv:suwɛdikan
      ta:tamulikan
      th:tayikan
      tr:turikikan
      uk:ukɛrɛnikan
      ur:urudukan
      vi:wiyɛtinamukan
      yo:yorubakan
      zh:siniwakan
      zh-alt-menu:siniwakan
      zu:zulukan
      """.trimIndent() }

  val bn: String by lazy { """
      aa:আফার
      ab:আবখাজিয়ান
      ace:অ্যাচাইনিজ
      ach:আকোলি
      ada:অদাগ্মে
      ady:আদেগে
      ae:আবেস্তীয়
      af:আফ্রিকান
      afh:আফ্রিহিলি
      agq:এঘেম
      ain:আইনু
      ak:আকান
      akk:আক্কাদিয়ান
      ale:আলেউত
      alt:দক্ষিন আলতাই
      am:আমহারিক
      an:আর্গোনিজ
      ang:প্রাচীন ইংরেজী
      ann:ওবোলো
      anp:আঙ্গিকা
      ar:আরবি
      ar-001:আধুনিক আদর্শ আরবি
      arc:আরামাইক
      arn:মাপুচে
      arp:আরাপাহো
      ars:নজদি আরবি
      arw:আরাওয়াক
      as:অসমীয়া
      asa:আসু
      ast:আস্তুরিয়
      atj:আটিকামেকিউ
      av:আভেরিক
      awa:আওয়াধি
      ay:আয়মারা
      az:আজারবাইজানী
      az-alt-short:আজেরি
      ba:বাশকির
      bal:বেলুচী
      ban:বালিনীয়
      bas:বাসা
      be:বেলারুশিয়
      bej:বেজা
      bem:বেম্বা
      bez:বেনা
      bg:বুলগেরিয়
      bgc:হরিয়ানভি
      bgn:পশ্চিম বালোচি
      bho:ভোজপুরি
      bi:বিসলামা
      bik:বিকোল
      bin:বিনি
      bla:সিকসিকা
      blo:অ্যানি
      bm:বামবারা
      bn:বাংলা
      bo:তিব্বতি
      br:ব্রেটন
      bra:ব্রাজ
      brx:বোড়ো
      bs:বসনীয়
      bua:বুরিয়াত
      bug:বুগিনিজ
      byn:ব্লিন
      ca:কাতালান
      cad:ক্যাডো
      car:ক্যারিব
      cay:কায়ুগা
      cch:আত্সাম
      ccp:চাকমা
      ce:চেচেন
      ceb:চেবুয়ানো
      cgg:চিগা
      ch:চামোরো
      chb:চিবচা
      chg:চাগাতাই
      chk:চুকিজ
      chm:মারি
      chn:চিনুক জার্গন
      cho:চকটাও
      chp:চিপেওয়ান
      chr:চেরোকী
      chy:চেইয়েন
      ckb:মধ্য কুর্দিশ
      ckb-alt-menu:কুর্দিশ, মধ্য
      ckb-alt-variant:কুর্দিশ, সোরানি
      clc:চিলকোটিন
      co:কর্সিকান
      cop:কপটিক
      cr:ক্রি
      crg:মিচিফ
      crh:ক্রিমিয়ান তুর্কি
      crj:দক্ষিণ পূর্ব ক্রী
      crk:প্লেনস ক্রী
      crl:উত্তর পূর্ব ক্রী
      crm:মুস ক্রী
      crr:ক্যারোলিনা অ্যাল্গঙ্কুইয়ান
      crs:সেসেলওয়া ক্রেওল ফ্রেঞ্চ
      cs:চেক
      csb:কাশুবিয়ান
      csw:সোয়াম্পি ক্রী
      cu:চার্চ স্লাভিক
      cv:চুবাস
      cy:ওয়েলশ
      da:ডেনিশ
      dak:ডাকোটা
      dar:দার্গওয়া
      dav:তাইতা
      de:জার্মান
      del:ডেলাওয়ের
      den:স্ল্যাভ
      dgr:দোগ্রীব
      din:ডিংকা
      dje:জার্মা
      doi:ডোগরি
      dsb:নিম্নতর সোর্বিয়ান
      dua:দুয়ালা
      dum:মধ্য ডাচ
      dv:দিবেহি
      dyo:জোলা-ফনী
      dyu:ডিউলা
      dz:জোংখা
      dzg:দাজাগা
      ebu:এম্বু
      ee:ইউয়ি
      efi:এফিক
      egy:প্রাচীন মিশরীয়
      eka:ইকাজুক
      el:গ্রিক
      elx:এলামাইট
      en:ইংরেজি
      en-GB-alt-short:ইংরেজি (যুক্তরাজ্য)
      en-US:ইংরেজি (আমেরিকা)
      en-US-alt-short:ইংরেজি (যুক্তরাষ্ট্র)
      enm:মধ্য ইংরেজি
      eo:এস্পেরান্তো
      es:স্প্যানিশ
      es-ES:স্প্যানিশ (ইউরোপ)
      et:এস্তোনীয়
      eu:বাস্ক
      ewo:ইওন্ডো
      fa:ফার্সি
      fa-AF:দারি
      fan:ফ্যাঙ্গ
      fat:ফান্তি
      ff:ফুলাহ্
      fi:ফিনিশ
      fil:ফিলিপিনো
      fj:ফিজিয়ান
      fo:ফেরোইস
      fon:ফন
      fr:ফরাসি
      frc:কাজুন ফরাসি
      frm:মধ্য ফরাসি
      fro:প্রাচীন ফরাসি
      frr:উত্তরাঞ্চলীয় ফ্রিসিয়ান
      frs:পূর্ব ফ্রিসিয়
      fur:ফ্রিউলিও
      fy:পশ্চিম ফ্রিসিয়ান
      ga:আইরিশ
      gaa:গা
      gag:গাগাউজ
      gan:gan
      gay:গায়ো
      gba:বায়া
      gd:স্কটিশ-গ্যেলিক
      gez:গীজ
      gil:গিলবার্টিজ
      gl:গ্যালিশিয়
      gmh:মধ্য-উচ্চ জার্মানি
      gn:গুয়ারানি
      goh:প্রাচীন উচ্চ জার্মানি
      gon:গোন্ডি
      gor:গোরোন্তালো
      got:গথিক
      grb:গ্রেবো
      grc:প্রাচীন গ্রীক
      gsw:সুইস জার্মান
      gu:গুজরাটি
      guz:গুসী
      gv:ম্যাঙ্কস
      gwi:গওইচ্’ইন
      ha:হাউসা
      hai:হাইডা
      haw:হাওয়াইয়ান
      hax:দক্ষিণী হায়দা
      he:হিব্রু
      hi:হিন্দি
      hi-Latn-alt-variant:হিংলিশ
      hil:হিলিগ্যায়নোন
      hit:হিট্টিট
      hmn:হ্‌মোঙ
      ho:হিরি মোতু
      hr:ক্রোয়েশীয়
      hsb:উচ্চ সোর্বিয়ান
      hsn:Xiang চীনা
      ht:হাইতিয়ান ক্রেওল
      hu:হাঙ্গেরীয়
      hup:হুপা
      hur:হাল্কোমেলেম
      hy:আর্মেনিয়
      hz:হেরেরো
      ia:ইন্টারলিঙ্গুয়া
      iba:ইবান
      ibb:ইবিবিও
      id:ইন্দোনেশীয়
      ie:ইন্টারলিঙ্গ
      ig:ইগ্‌বো
      ii:সিচুয়ান য়ি
      ik:ইনুপিয়াক
      ikt:পশ্চিম কানাডিয় ইনুক্টিটুট
      ilo:ইলোকো
      inh:ইঙ্গুশ
      io:ইডো
      is:আইসল্যান্ডীয়
      it:ইতালিয়
      iu:ইনুক্টিটুট
      ja:জাপানি
      jbo:লোজবান
      jgo:গোম্বা
      jmc:মাকামে
      jpr:জুদেও ফার্সি
      jrb:জুদেও আরবি
      jv:জাভানিজ
      ka:জর্জিয়ান
      kaa:কারা-কাল্পাক
      kab:কাবাইলে
      kac:কাচিন
      kaj:জজু
      kam:কাম্বা
      kaw:কাউই
      kbd:কাবার্ডিয়ান
      kcg:টিয়াপ
      kde:মাকোন্দে
      kea:কাবুভারদিয়ানু
      kfo:কোরো
      kg:কঙ্গো
      kgp:কেইনগ্যাং
      kha:খাশি
      kho:খোটানিজ
      khq:কোয়রা চীনি
      ki:কিকুয়ু
      kj:কোয়ানিয়ামা
      kk:কাজাখ
      kkj:কাকো
      kl:কালাল্লিসুট
      kln:কালেনজিন
      km:খমের
      kmb:কিম্বুন্দু
      kn:কন্নড়
      ko:কোরিয়ান
      koi:কমি-পারমিআক
      kok:কোঙ্কানি
      kos:কোস্রাইন
      kpe:ক্‌পেল্লে
      kr:কানুরি
      krc:কারচে-বাল্কার
      krl:কারেলিয়ান
      kru:কুরুখ
      ks:কাশ্মীরি
      ksb:শাম্বালা
      ksf:বাফিয়া
      ksh:কলোগনিয়ান
      ku:কুর্দিশ
      kum:কুমিয়াক
      kut:কুটেনাই
      kv:কোমি
      kw:কর্ণিশ
      kwk:কোয়াক’ওয়ালা
      kxv:কুভি
      ky:কির্গিজ
      la:লাতিন
      lad:লাদিনো
      lag:লাঙ্গি
      lah:লান্ডা
      lam:লাম্বা
      lb:লুক্সেমবার্গীয়
      lez:লেজঘিয়ান
      lg:গান্ডা
      li:লিম্বুর্গিশ
      lij:লিগুরিয়ান
      lil:লিল্লুয়েট
      lkt:লাকোটা
      lmo:লম্বার্ড
      ln:লিঙ্গালা
      lo:লাও
      lol:মোঙ্গো
      lou:লুইসিয়ানা ক্রেওল
      loz:লোজি
      lrc:উত্তরাঞ্চলীয় লুরি
      lsm:সামিয়া
      lt:লিথুয়েনীয়
      lu:লুবা-কাটাঙ্গা
      lua:লুবা-লুলুয়া
      lui:লুইসেনো
      lun:লুন্ডা
      luo:লুয়ো
      lus:মিজো
      luy:লুইয়া
      lv:লাত্‌ভীয়
      mad:মাদুরেজ
      mag:মাগাহি
      mai:মৈথিলি
      mak:ম্যাকাসার
      man:ম্যান্ডিঙ্গো
      mas:মাসাই
      mdf:মোকশা
      mdr:ম্যাণ্ডার
      men:মেন্ডে
      mer:মেরু
      mfe:মরিসিয়েন
      mg:মালাগাসি
      mga:মধ্য আইরিশ
      mgh:মাখুয়া-মেত্তো
      mgo:মেটা
      mh:মার্শালিজ
      mi:মাওরি
      mic:মিকম্যাক
      min:মিনাংকাবাউ
      mk:ম্যাসিডোনীয়
      ml:মালায়ালাম
      mn:মঙ্গোলিয়
      mnc:মাঞ্চু
      mni:মণিপুরী
      moe:ইন্নু-এমুন
      moh:মোহাওক
      mos:মসি
      mr:মারাঠি
      ms:মালয়
      mt:মল্টিয়
      mua:মুদাঙ্গ
      mul:একাধিক ভাষা
      mus:মুস্কোগী
      mwl:মিরান্ডিজ
      mwr:মারোয়ারি
      my:বর্মি
      myv:এরজিয়া
      mzn:মাজানদেরানি
      na:নাউরু
      nap:নেয়াপোলিটান
      naq:নামা
      nb:নরওয়েজিয়ান বোকমাল
      nd:উত্তর এন্দেবেলে
      nds:নিম্ন জার্মানি
      nds-NL:লো স্যাক্সন
      ne:নেপালী
      new:নেওয়ারি
      ng:এন্দোঙ্গা
      nia:নিয়াস
      niu:নিউয়ান
      nl:ওলন্দাজ
      nl-BE:ফ্লেমিশ
      nmg:কোয়াসিও
      nn:নরওয়েজিয়ান নিনর্স্ক
      nnh:নগিয়েম্বুন
      no:নরওয়েজীয়
      nog:নোগাই
      non:প্রাচীন নর্স
      nqo:এন’কো
      nr:দক্ষিণ এনডেবেলে
      nso:উত্তরাঞ্চলীয় সোথো
      nus:নুয়ার
      nv:নাভাজো
      nwc:প্রাচীন নেওয়ারী
      ny:নায়াঞ্জা
      nym:ন্যায়ামওয়েজি
      nyn:ন্যায়াঙ্কোলে
      nyo:ন্যোরো
      nzi:এনজিমা
      oc:অক্সিটান
      oj:ওজিবওয়া
      ojb:উত্তর পশ্চিম ওজিবোয়া
      ojc:মধ্য ওজিবুয়া
      ojs:ওজি-ক্রী
      ojw:পশ্চিম ওজিবোয়া
      oka:ওকানাগান
      om:অরোমো
      or:ওড়িয়া
      os:ওসেটিক
      osa:ওসেজ
      ota:অটোমান তুর্কি
      pa:পাঞ্জাবী
      pag:পাঙ্গাসিনান
      pal:পাহ্লাভি
      pam:পাম্পাঙ্গা
      pap:পাপিয়ামেন্টো
      pau:পালায়ুয়ান
      pcm:নাইজেরিয় পিজিন
      peo:প্রাচীন ফার্সি
      phn:ফোনিশীয়ান
      pi:পালি
      pis:পিজিন
      pl:পোলিশ
      pon:পোহ্নপেইয়ান
      pqm:মালিসেট-পাসামাকুয়োড্ডি
      prg:প্রুশিয়ান
      pro:প্রাচীন প্রোভেনসাল
      ps:পাশতু
      ps-alt-variant:পুশতো
      pt:পর্তুগীজ
      pt-PT:পর্তুগীজ (ইউরোপ)
      qu:কেচুয়া
      quc:কি‘চে
      raj:রাজস্থানী
      rap:রাপানুই
      rar:রারোটোংগান
      rhg:রোহিঙ্গা
      rm:রোমান্স
      rn:রুন্দি
      ro:রোমানীয়
      ro-MD:মলদাভিয়
      rof:রম্বো
      rom:রোমানি
      ru:রুশ
      rup:আরোমেনিয়
      rw:কিনয়ারোয়ান্ডা
      rwk:রাওয়া
      sa:সংস্কৃত
      sad:সান্দাওয়ে
      sah:শাখা
      sam:সামারিটান আরামিক
      saq:সামবুরু
      sas:সাসাক
      sat:সাঁওতালি
      sba:গাম্বে
      sbp:সাঙ্গু
      sc:সার্ডিনিয়ান
      scn:সিসিলিয়ান
      sco:স্কটস
      sd:সিন্ধি
      sdh:দক্ষিণ কুর্দিশ
      se:উত্তরাঞ্চলীয় সামি
      seh:সেনা
      sel:সেল্কুপ
      ses:কোয়রাবোরো সেন্নি
      sg:সাঙ্গো
      sga:প্রাচীন আইরিশ
      sh:সার্বো-ক্রোয়েশিয়
      shi:তাচেলহিত
      shn:শান
      si:সিংহলী
      sid:সিডামো
      sk:স্লোভাক
      sl:স্লোভেনীয়
      slh:দক্ষিণী লুশুটসীড
      sm:সামোয়ান
      sma:দক্ষিণাঞ্চলীয় সামি
      smj:লুলে সামি
      smn:ইনারি সামি
      sms:স্কোল্ট সামি
      sn:শোনা
      snk:সোনিঙ্কে
      so:সোমালি
      sog:সোগডিয়ান
      sq:আলবেনীয়
      sr:সার্বীয়
      srn:স্রানান টোঙ্গো
      srr:সেরের
      ss:সোয়াতি
      ssy:সাহো
      st:দক্ষিন সোথো
      str:স্ট্রেটস সালিস
      su:সুদানী
      suk:সুকুমা
      sus:সুসু
      sux:সুমেরীয়
      sv:সুইডিশ
      sw:সোয়াহিলি
      sw-CD:কঙ্গো সোয়াহিলি
      swb:কমোরিয়ান
      syc:প্রাচীন সিরিও
      syr:সিরিয়াক
      szl:সিলেশিয়ান
      ta:তামিল
      tce:দক্ষিণী টুচোন
      te:তেলুগু
      tem:টাইম্নে
      teo:তেসো
      ter:তেরেনো
      tet:তেতুম
      tg:তাজিক
      tgx:তাগিশ
      th:থাই
      tht:তাহ্লতান
      ti:তিগরিনিয়া
      tig:টাইগ্রে
      tiv:টিভ
      tk:তুর্কমেনী
      tkl:টোকেলাউ
      tl:তাগালগ
      tlh:ক্লিঙ্গন
      tli:ত্লিঙ্গিট
      tmh:তামাশেক
      tn:সোয়ানা
      to:টোঙ্গান
      tog:নায়াসা টোঙ্গা
      tok:টোকি পোনা
      tpi:টোক পিসিন
      tr:তুর্কী
      trv:তারোকো
      ts:সঙ্গা
      tsi:সিমশিয়ান
      tt:তাতার
      ttm:উত্তরাঞ্চলীয় টুচোন
      tum:তুম্বুকা
      tvl:টুভালু
      tw:টোয়াই
      twq:তাসাওয়াক
      ty:তাহিতিয়ান
      tyv:টুভিনিয়ান
      tzm:সেন্ট্রাল আটলাস তামাজিগাত
      udm:উডমুর্ট
      ug:উইঘুর
      uga:উগারিটিক
      uk:ইউক্রেনীয়
      umb:উম্বুন্দু
      und:অজানা ভাষা
      ur:উর্দু
      uz:উজবেক
      vai:ভাই
      ve:ভেন্ডা
      vec:ভেনেশিয়ান
      vi:ভিয়েতনামী
      vmw:মাখুওয়া
      vo:ভোলাপুক
      vot:ভোটিক
      vun:ভুঞ্জো
      wa:ওয়ালুন
      wae:ওয়ালসার
      wal:ওলায়ট্টা
      war:ওয়ারে
      was:ওয়াশো
      wbp:ওয়ার্লপিরি
      wo:ওলোফ
      wuu:উ চীনা
      xal:কাল্মাইক
      xh:জোসা
      xnr:কাংরি
      xog:সোগা
      yao:ইয়াও
      yap:ইয়াপেসে
      yav:ইয়াঙ্গবেন
      ybb:ইয়েম্বা
      yi:ইদ্দিশ
      yo:ইওরুবা
      yrl:নহিংগাটু
      yue:ক্যান্টোনিজ
      yue-alt-menu:চীনা, ক্যানটোনীজ
      za:ঝু্য়াঙ
      zap:জাপোটেক
      zbl:চিত্র ভাষা
      zen:জেনাগা
      zgh:আদর্শ মরক্কোন তামাজিগাত
      zh:চীনা
      zh-alt-menu:চীনা, ম্যান্ডারিন
      zh-Hans-alt-long:চীনা ম্যান্ডারিন সরলীকৃত
      zh-Hant-alt-long:ম্যান্ডারিন চীনা (ঐতিহ্যবাহী)
      zu:জুলু
      zun:জুনি
      zxx:ভাষাভিত্তিক বিষয়বস্তু নেই
      zza:জাজা
      """.trimIndent() }

  val bn_IN: String by lazy { """
      ksh:কোলোনিয়ান
      """.trimIndent() }

  val bo: String by lazy { """
      bo:བོད་སྐད་
      dz:རྫོང་ཁ
      en:དབྱིན་ཇིའི་སྐད།
      en-CA:དབྱིན་ཇིའི་སྐད། (ཁེ་ན་ཌ་)
      en-GB:དབྱིན་ཇིའི་སྐད། (དབྱིན་ལན་)
      en-GB-alt-short:དབྱིན་ཇིའི་སྐད། (དབྱིན་ལན་)
      en-US:དབྱིན་ཇིའི་སྐད། (ཨ་རི་)
      en-US-alt-short:དབྱིན་ཇིའི་སྐད། (ཨ་རི་)
      hi:ཧིན་དི
      ja:ཉི་ཧོང་སྐད་
      ne:ནེ་པ་ལི
      ru:ཨུ་རུ་སུ་སྐད་
      zh:རྒྱ་སྐད་
      zh-alt-menu:རྒྱ་སྐད་
      zza:ཟ་ཟའ་སྐད།
      """.trimIndent() }

  val bo_IN: String? = null

  val br: String by lazy { """
      aa:afar
      ab:abkhazeg
      ace:achineg
      ach:acoli
      ada:adangme
      ady:adygeieg
      ae:avesteg
      aeb:arabeg Tunizia
      af:afrikaans
      afh:afrihili
      agq:aghem
      ain:ainoueg
      ak:akan
      akk:akadeg
      akz:alabamaeg
      ale:aleouteg
      aln:gegeg
      alt:altaieg ar Su
      am:amhareg
      an:aragoneg
      ang:hensaozneg
      ann:obolo
      anp:angika
      ar:arabeg
      ar-001:arabeg modern
      arc:arameeg
      arn:araoukaneg
      aro:araona
      arp:arapaho
      arq:arabeg Aljeria
      ars:arabeg nadjiek
      arw:arawakeg
      ary:arabeg Maroko
      arz:arabeg Egipt
      as:asameg
      asa:asu
      ase:yezh sinoù Amerika
      ast:asturianeg
      atj:atikamekweg
      av:avar
      awa:awadhi
      ay:aymara
      az:azerbaidjaneg
      az-alt-short:azeri
      ba:bachkir
      bal:baloutchi
      ban:balineg
      bar:bavarieg
      bas:basaa
      be:belaruseg
      bej:bedawieg
      bem:bemba
      bez:bena
      bg:bulgareg
      bgn:baloutchi ar Cʼhornôg
      bho:bhojpuri
      bi:bislama
      bik:bikol
      bin:bini
      bla:siksika
      bm:bambara
      bn:bengali
      bo:tibetaneg
      br:brezhoneg
      bra:braj
      brh:brahweg
      brx:bodo
      bs:bosneg
      bss:akoose
      bua:bouriat
      bug:bugi
      byn:blin
      ca:katalaneg
      cad:caddo
      car:karibeg
      cay:kayougeg
      cch:atsam
      ccp:chakmaeg
      ce:tchetcheneg
      ceb:cebuano
      cgg:chigaeg
      ch:chamorru
      chb:chibcha
      chk:chuuk
      chm:marieg
      cho:choktaw
      chp:chipewyan
      chr:cherokee
      chy:cheyenne
      ckb:kurdeg sorani
      ckb-alt-menu:kurdeg kreiz
      ckb-alt-variant:kurdeg sorani
      clc:chilkotineg
      co:korseg
      cop:kopteg
      cr:kri
      crg:michifeg
      crh:turkeg Krimea
      crj:krieg ar Gevred
      crk:krieg ar cʼhompezennoù
      crl:krieg ar Biz
      crm:krieg ar cʼhornôg
      crr:algonkeg Carolina
      crs:kreoleg Sechelez
      cs:tchekeg
      csb:kachoubeg
      csw:krieg ar gwernioù
      cu:slavoneg iliz
      cv:tchouvatch
      cy:kembraeg
      da:daneg
      dak:dakota
      dar:dargwa
      dav:taita
      de:alamaneg
      de-AT:alamaneg Aostria
      de-CH:alamaneg uhel Suis
      del:delaware
      dgr:dogrib
      din:dinka
      dje:zarma
      doi:dogri
      dsb:izelsorabeg
      dua:douala
      dum:nederlandeg krenn
      dv:divehi
      dyo:diola
      dyu:dyula
      dz:dzongkha
      dzg:dazagaeg
      ebu:embu
      ee:ewe
      efi:efik
      egy:henegipteg
      eka:ekajuk
      el:gresianeg
      elx:elameg
      en:saozneg
      en-AU:saozneg Aostralia
      en-CA:saozneg Kanada
      en-GB:saozneg Breizh-Veur
      en-GB-alt-short:saozneg RU
      en-US:saozneg Amerika
      en-US-alt-short:saozneg SU
      enm:krennsaozneg
      eo:esperanteg
      es:spagnoleg
      es-419:spagnoleg Amerika latin
      es-ES:spagnoleg Europa
      es-MX:spagnoleg Mecʼhiko
      et:estoneg
      eu:euskareg
      ewo:ewondo
      fa:perseg
      fa-AF:dareg
      fan:fang
      fat:fanti
      ff:fula
      fi:finneg
      fil:filipineg
      fit:finneg traoñienn an Torne
      fj:fidjieg
      fo:faeroeg
      fon:fon
      fr:galleg
      fr-CA:galleg Kanada
      fr-CH:galleg Suis
      frc:galleg cajun
      frm:krenncʼhalleg
      fro:hencʼhalleg
      frp:arpitaneg
      frr:frizeg an Norzh
      frs:frizeg ar Reter
      fur:frioulaneg
      fy:frizeg ar Cʼhornôg
      ga:iwerzhoneg
      gaa:ga
      gag:gagaouzeg
      gan:sinaeg Gan
      gay:gayo
      gba:gbaya
      gd:skoseg
      gez:gezeg
      gil:gilberteg
      gl:galizeg
      gmh:krennalamaneg uhel
      gn:guarani
      goh:henalamaneg uhel
      gor:gorontalo
      got:goteg
      grb:grebo
      grc:hencʼhresianeg
      gsw:alamaneg Suis
      gu:gujarati
      guz:gusiieg
      gv:manaveg
      gwi:gwich’in
      ha:haousa
      hai:haideg
      hak:sinaeg Hakka
      haw:hawaieg
      hax:haideg ar Su
      he:hebraeg
      hi:hindi
      hil:hiligaynon
      hmn:hmong
      ho:hiri motu
      hr:kroateg
      hsb:uhelsorabeg
      hsn:sinaeg Xian
      ht:haitieg
      hu:hungareg
      hup:hupa
      hur:halkomelemeg
      hy:armenianeg
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonezeg
      ie:interlingue
      ig:igbo
      ii:yieg Sichuan
      ik:inupiaq
      ikt:inuktitut Kanada ar Cʼhornôg
      ilo:ilokanoeg
      inh:ingoucheg
      io:ido
      is:islandeg
      it:italianeg
      iu:inuktitut
      ja:japaneg
      jam:kreoleg Jamaika
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jpr:yuzev-perseg
      jrb:yuzev-arabeg
      jv:javaneg
      ka:jorjianeg
      kaa:karakalpak
      kab:kabileg
      kac:kachin
      kaj:jju
      kam:kamba
      kbd:kabardeg
      kcg:tyap
      kde:makonde
      kea:kabuverdianu
      kfo:koroeg
      kg:kongo
      kgp:kaingangeg
      kha:khasi
      kho:khotaneg
      khq:koyra chiini
      ki:kikuyu
      kj:kwanyama
      kk:kazak
      kkj:kakoeg
      kl:greunlandeg
      kln:kalendjineg
      km:khmer
      kmb:kimbundu
      kn:kanareg
      ko:koreaneg
      kok:konkani
      kos:kosrae
      kpe:kpelle
      kr:kanouri
      krc:karatchay-balkar
      kri:krio
      krl:karelieg
      kru:kurukh
      ks:kashmiri
      ksb:shambala
      ksf:bafiaeg
      ksh:koluneg
      ku:kurdeg
      kum:koumikeg
      kut:kutenai
      kv:komieg
      kw:kerneveureg
      kwk:kwakwaleg
      ky:kirgiz
      la:latin
      lad:ladino
      lag:langi
      lah:lahnda
      lam:lamba
      lb:luksembourgeg
      lez:lezgi
      lfn:lingua franca nova
      lg:ganda
      li:limbourgeg
      lij:ligurieg
      lil:lillooet
      lkt:lakota
      ln:lingala
      lo:laoseg
      lol:mongo
      lou:kreoleg Louiziana
      loz:lozi
      lrc:loureg an Norzh
      lt:lituaneg
      lu:luba-katanga
      lua:luba-lulua
      lui:luiseno
      lun:lunda
      luo:luo
      lus:lushai
      luy:luyia
      lv:latvieg
      lzh:sinaeg lennegel
      mad:madoureg
      mag:magahi
      mai:maithili
      mak:makasar
      mas:masai
      mdf:moksha
      mdr:mandar
      men:mende
      mer:meru
      mfe:moriseg
      mg:malgacheg
      mga:krenniwerzhoneg
      mgh:makhuwa-meetto
      mgo:metaʼ
      mh:marshall
      mi:maori
      mic:mikmakeg
      min:minangkabau
      mk:makedoneg
      ml:malayalam
      mn:mongoleg
      mnc:manchou
      mni:manipuri
      moe:montagneg
      moh:mohawk
      mos:more
      mr:marathi
      mrj:marieg ar Cʼhornôg
      ms:malayseg
      mt:malteg
      mua:moundangeg
      mul:yezhoù lies
      mus:muskogi
      mwl:mirandeg
      my:birmaneg
      myv:erza
      mzn:mazanderaneg
      na:naurueg
      nan:sinaeg Min Nan
      nap:napolitaneg
      naq:nama
      nb:norvegeg bokmål
      nd:ndebele an Norzh
      nds:alamaneg izel
      nds-NL:saksoneg izel
      ne:nepaleg
      new:newari
      ng:ndonga
      nia:nias
      niu:niue
      njo:aoeg
      nl:nederlandeg
      nl-BE:flandrezeg
      nmg:ngoumbeg
      nn:norvegeg nynorsk
      nnh:ngiemboon
      no:norvegeg
      nog:nogay
      non:hennorseg
      nov:novial
      nqo:nkoeg
      nr:ndebele ar Su
      nso:sotho an Norzh
      nus:nouereg
      nv:navacʼho
      nwc:newari klasel
      ny:nyanja
      nym:nyamwezi
      nyn:nyankole
      nyo:nyoro
      oc:okitaneg
      oj:ojibweg
      ojb:ojibweg ar Gwalarn
      ojc:ojibweg ar cʼhreiz
      ojs:ojibweg Severn
      ojw:ojibweg ar Cʼhornôg
      oka:okanaganeg
      om:oromoeg
      or:oriya
      os:oseteg
      osa:osage
      ota:turkeg otoman
      pa:punjabi
      pag:pangasinan
      pal:pahlavi
      pam:pampanga
      pap:papiamento
      pau:palau
      pcd:pikardeg
      pcm:pidjin Nigeria
      pdc:alamaneg Pennsylvania
      peo:henberseg
      phn:fenikianeg
      pi:pali
      pis:pidjin
      pl:poloneg
      pms:piemonteg
      pnt:ponteg
      pon:pohnpei
      pqm:malisiteg-pasamawkodieg
      prg:henbruseg
      pro:henbrovañseg
      ps:pachto
      pt:portugaleg
      pt-BR:portugaleg Brazil
      pt-PT:portugaleg Europa
      qu:kechuaeg
      quc:kʼicheʼ
      qug:kichuaeg Chimborazo
      raj:rajasthani
      rap:rapanui
      rar:rarotonga
      rgn:romagnoleg
      rhg:rohingya
      rm:romañcheg
      rn:rundi
      ro:roumaneg
      ro-MD:moldoveg
      rof:rombo
      rom:romanieg
      ru:rusianeg
      rup:aroumaneg
      rw:kinyarwanda
      rwk:rwa
      sa:sanskriteg
      sad:sandawe
      sah:yakouteg
      sam:arameeg ar Samaritaned
      saq:samburu
      sas:sasak
      sat:santali
      sba:ngambayeg
      sbp:sangu
      sc:sardeg
      scn:sikilieg
      sco:skoteg
      sd:sindhi
      sdc:sasareseg
      se:sámi an Norzh
      seh:sena
      ses:koyraboro senni
      sg:sango
      sga:heniwerzhoneg
      sh:serb-kroateg
      shi:tacheliteg
      shn:shan
      shu:arabeg Tchad
      si:singhaleg
      sid:sidamo
      sk:slovakeg
      sl:sloveneg
      slh:luchoutsideg ar Su
      sm:samoan
      sma:sámi ar Su
      smj:sámi Luleå
      smn:sámi Inari
      sms:sámi Skolt
      sn:shona
      snk:soninke
      so:somali
      sog:sogdieg
      sq:albaneg
      sr:serbeg
      srn:sranan tongo
      srr:serer
      ss:swati
      ssy:sahoeg
      st:sotho ar Su
      su:sundaneg
      suk:sukuma
      sux:sumereg
      sv:svedeg
      sw:swahili
      sw-CD:swahili Kongo
      swb:komoreg
      syc:sirieg klasel
      syr:sirieg
      szl:silezieg
      ta:tamileg
      tce:tutchoneg ar Su
      tcy:touloueg
      te:telougou
      tem:temne
      teo:tesoeg
      ter:tereno
      tet:tetum
      tg:tadjik
      th:thai
      ti:tigrigna
      tig:tigreaneg
      tiv:tiv
      tk:turkmeneg
      tkl:tokelau
      tl:tagalog
      tlh:klingon
      tli:tinglit
      tmh:tamacheg
      tn:tswana
      to:tonga
      tog:nyasa tonga
      tok:toki pona
      tpi:tok pisin
      tr:turkeg
      tru:turoyoeg
      trv:taroko
      ts:tsonga
      tsi:tsimshian
      tt:tatar
      ttm:tutchoneg an Norzh
      tum:tumbuka
      tvl:tuvalu
      tw:twi
      twq:tasawakeg
      ty:tahitianeg
      tyv:touva
      tzm:tamazigteg Kreizatlas
      udm:oudmourteg
      ug:ouigoureg
      uga:ougariteg
      uk:ukraineg
      umb:umbundu
      und:yezh dianav
      ur:ourdou
      uz:ouzbekeg
      vai:vai
      ve:venda
      vec:venezieg
      vep:vepseg
      vi:vietnameg
      vls:flandrezeg ar c’hornôg
      vo:volapük
      vot:votyakeg
      vro:voroeg
      vun:vunjo
      wa:walloneg
      wae:walser
      wal:walamo
      war:waray
      was:washo
      wo:wolof
      wuu:sinaeg Wu
      xal:kalmouk
      xh:xhosa
      xmf:megreleg
      xog:sogaeg
      yao:yao
      yap:yapeg
      yav:yangben
      ybb:yemba
      yi:yiddish
      yo:yorouba
      yrl:nengatoueg
      yue:kantoneg
      yue-alt-menu:sinaeg, kantoneg
      za:zhuang
      zap:zapoteg
      zbl:arouezioù Bliss
      zea:zelandeg
      zen:zenaga
      zgh:tamacheg Maroko standart
      zh:sinaeg
      zh-alt-menu:sinaeg, mandarineg
      zh-Hans:sinaeg eeunaet
      zh-Hans-alt-long:sinaeg mandarinek eeunaet
      zh-Hant:sinaeg hengounel
      zh-Hant-alt-long:sinaeg mandarinek hengounel
      zu:zouloueg
      zun:zuni
      zxx:diyezh
      zza:zazakeg
      """.trimIndent() }

  val brx: String by lazy { """
      ab:आब्खाजियान
      ace:एचेनिज
      ach:अकोली
      ada:एडांगमे
      ady:अदिघे
      ae:अवस्तन्
      af:आफ्रिकान्स
      afh:अफ्रीहीली
      agq:आघेम
      ain:ऐनू
      ak:आकान
      akk:अकाडिनी
      ale:आलेउट
      alt:खोलायारि आल्टाई
      am:आम्हारिक
      an:आरागनिस
      ang:पुरानी अंग्रेज़ी
      ann:अबल’
      anp:आङिका
      ar:आराबिक
      ar-001:गोदान मानथाखोआरि आराबिक
      arc:अरामाईक
      arn:मापुचे
      arp:आरापाह’
      ars:नाजडी आराबिक
      arw:अरावाक
      as:असमिया
      asa:आसु
      ast:आस्तुरियान
      atj:आतिकामेको
      av:आभारिक
      awa:अवधी
      ay:आयमारा
      az:आजारबायजानि
      az-alt-short:आजेरि
      ba:बाशकिर
      bal:बलूची
      ban:बालिनिस
      bas:बासा
      be:बेलारुसियान
      bej:बेजा
      bem:बेम्बा
      bez:बेना
      bg:बुल्गारियान
      bho:भजपुरी
      bi:बिस्लामा
      bik:बिकोल्
      bin:बिनी
      bla:सीकसीका
      bm:बाम्बारा
      bn:बांला
      bo:तिब्बती
      br:ब्रेट’न
      bra:ब्रज
      brx:बर’
      bs:बस्नियान
      bua:बुरियात
      bug:बुगिनीज
      byn:ब्लीन
      ca:कातालान
      cad:काद्दौ
      car:कारीब्
      cay:कायुगा
      cch:आत्सम
      ccp:चाकमा
      ce:चेचेन
      ceb:चेबुआनो
      cgg:चीगा
      ch:चामोर्रो
      chb:चीबचा
      chg:चगताई
      chk:चुकेसे
      chm:मारि
      chn:चीनूक् जार्गन्
      cho:चक्टाऊ
      chp:चिपेव्यान
      chr:चेरकी
      chy:चेयेण
      ckb:मिरु कुर्दिस
      ckb-alt-menu:कुर्दिस, मिरु
      ckb-alt-variant:कुर्दिस, सरानि
      clc:चिल्कटिन
      co:कर्सिकान
      cop:कॉप्टीक्
      cr:क्री
      crg:मिचिफ
      crh:तुर्की क्रिमिया
      crj:खोलायारि सानजा क्री
      crk:हायेनारि क्री
      crl:साहायारि सानजा क्री
      crm:मूज क्री
      crr:केर’लिना एल्गंक्यान
      cs:चैक
      csb:काशुबियान्
      csw:स्वाम्पी क्री
      cu:चर्च स्लाविक्
      cv:चुभास
      cy:वैल्श
      da:डानिश
      dak:डाक’टा
      dar:दर्गवा
      dav:टाइटा
      de:जार्मान
      de-AT:अस्ट्रेयाआरि जार्मान
      de-CH:सुइस गोजौ जार्मान
      del:दलावार्
      den:स्लेव्
      dgr:डोगरीब
      din:डींगका
      dje:जार्मा
      doi:डोगरी
      dsb:गाहायसिन सर्बियान
      dua:डुआला
      dum:मध्य डच
      dv:दीवेही
      dyo:जला- फन्यी
      dyu:द्युआला
      dz:झंखा
      dzg:डाजागा
      ebu:इम्बु
      ee:एवे
      efi:एफिक
      egy:प्राचीन मिस्री
      eka:एकाजुक
      el:ग्रीक
      elx:एलामी
      en:इंराजी
      en-AU:अस्ट्रेलियानि इंराजी
      en-CA:कानाडानि इंराजी
      en-GB:ब्रिटिश इंराजी
      en-GB-alt-short:इउ.के इंराजी
      en-US:आमेरिकानि इंराजी
      en-US-alt-short:इउ.एस इंराजी
      enm:मध्य अंग्रेज़ी
      eo:एस्पेरान्त’
      es:स्पेनिश
      es-419:लेटीन आमेरिकानि स्पेनिश
      es-ES:युरोपनि स्पेनिश
      es-MX:मेक्सिक’नि स्पेनिश
      et:एस्ट’नियान
      eu:बास्क
      ewo:एव’न्द’
      fa:फार्सी
      fa-AF:डारी
      fan:फाँग्
      fat:फाँटी
      ff:फुलाह
      fi:फिन्निस
      fil:फिलिपिन’
      fj:फिजियान
      fo:फेर’वीज
      fon:फ’न
      fr:फ्रेन्च
      fr-CA:कानाडानि फ्रेन्च
      fr-CH:सुइस फ्रेन्च
      frc:काजुन फ्रेन्च
      frm:मध्य फ्रांसीसी
      fro:पुरानी फ्रांसीसी
      frr:उत्तरी फ्रीज़ियन्
      frs:पूर्वी फ्रीज़ियन्
      fur:फ्रिउलियान
      fy:सोनाबारि फ्रिजियान
      ga:आईरिश
      gaa:गा
      gay:गायो
      gba:ग्बाया
      gd:स्कटिस गैलिक
      gez:गीज
      gil:गील्बर्टिस
      gl:गेलिसियान
      gmh:मध्य उच्चस्तरी जर्मन
      gn:गुआरानी
      goh:पुरानी उच्चस्तरी जर्मन
      gon:गाँडी
      gor:गर’न्टाल’
      got:गॉथिक
      grb:ग्रेबो
      grc:प्राचीन यूनानी
      gsw:स्वीस जार्मान
      gu:गुजराती
      guz:गुशि
      gv:मेनक्स
      gwi:ग्वीचलीन
      ha:हाउसा
      hai:हाईडा
      haw:हावाईयान
      hax:खोलायारि हाईडा
      he:हिब्रिउ
      hi:हिन्दी
      hil:हिलीगैन’न
      hit:हीत्ती
      hmn:ह्मंग
      ho:हीरी मोटु
      hr:क्रवेशियान
      hsb:गोजौआरि सर्बियान
      ht:हाईटियान क्रिअल
      hu:हांगारियान
      hup:हूपा
      hur:हाल्क’मेलेम
      hy:आर्मेनियान
      hz:हेरेर’
      ia:ईन्टरलिंग्वा
      iba:ईबान
      ibb:ईबिबिय’
      id:ईण्डनेसियान
      ie:ईन्टरलिंग्वे
      ig:ईग्ब’
      ii:शीचुआन यी
      ik:इनुपियाक़्
      ikt:सोनाबारि कानाडियान इनुक्तितुत
      ilo:इल’क’
      inh:ईंगुष
      io:ईड’
      is:आइस्लेन्डिक
      it:इटालियान
      iu:इनुक्टीटुत
      ja:जापानीज
      jbo:ल’जबान
      jgo:न्गम्बा
      jmc:मेचामे
      jpr:यहुदी फ़ारसी
      jrb:यहुदी अरबी
      jv:जाभानीस
      ka:जर्जियान
      kaa:कारा कलपक
      kab:काबील
      kac:काचीन
      kaj:झु
      kam:काम्बा
      kaw:कावी
      kbd:काबार्डीयानि
      kcg:त्याप
      kde:माक’ण्डे
      kea:काबुभेर्डीयानु
      kfo:कर’
      kg:कॉंगो
      kgp:काईङां
      kha:खासि
      kho:ख़ोतानी
      khq:कईरा चीनि
      ki:किकुयु
      kj:कुआनयामा
      kk:काजाख
      kkj:काक’
      kl:कलालीसुत
      kln:कालेनजिन
      km:ख्मेर
      kmb:किम्बुन्डु
      kn:कन्नड
      ko:करियान
      kok:कोंकणी
      kos:कोस्राईयन्
      kpe:क्पेले
      kr:कनुरी
      krc:कराचय-बलकार
      krl:करेलियान
      kru:कुरुख
      ks:काश्मिरी
      ksb:शामबाला
      ksf:बाफिया
      ksh:कलगन्यान
      ku:कुर्दीश
      kum:कुमीक
      kut:कुतेनाई
      kv:क’मी
      kw:कर्निस
      kwk:क्वाकवाला
      ky:किरगीज
      la:लेटीन
      lad:लाडीन’
      lag:लाङि
      lah:लाह्डां
      lam:लांबा
      lb:लाक्जेमबुर्गीश
      lez:लेजघीयान
      lg:गान्डा
      li:लीम्बुर्गिस
      lil:लिल्लुवेत
      lkt:लाक’ता
      ln:लिंगाला
      lo:लाऊ
      lol:मोंगो
      lou:लुईसियाना क्रेवल
      loz:ल’जी
      lrc:साहायारि लुरी
      lsm:सामीया
      lt:लिथुवानियान
      lu:लुबा-काटाङा
      lua:लुबा लुलुआ
      lui:लुईसेनो
      lun:लुण्डा
      luo:लुअ’
      lus:लुशाई
      luy:लुईया
      lv:लाटभियान
      mad:मादुरीज
      mag:मगाही
      mai:मैथीली
      mak:माकासार
      man:मांडींगो
      mas:मासाई
      mdf:मोक्षा
      mdr:मंदार
      men:मेन्दे
      mer:मेरु
      mfe:मरिछ्येन
      mg:मालागासी
      mga:मध्य आईरीश भाषा
      mgh:माखुवा- मीट्ट’
      mgo:मेता
      mh:मार्शेलिस
      mi:माऔरि
      mic:मिईकमाक
      min:मिनांकाबाऊ
      mk:मेसेड’नियान
      ml:मालायालम
      mn:मंगलियान
      mnc:मांचु
      mni:मनिपुरी
      moe:इन्नु-आइमुन
      moh:महाउक
      mos:मस्सी
      mr:माराथी
      ms:मलै
      mt:माल्टीज
      mua:मुन्दां
      mul:गोबां रावफोर
      mus:मुस्क’गी
      mwl:मिराण्डीज
      mwr:मारवाड़ी
      my:बार्मिस
      myv:एर्जीया
      mzn:माजान्देरानि
      na:नाऊरू
      nap:नियापलिटान
      naq:नामा
      nb:नरवैजियान बकमाल
      nd:साहा न्देबेले
      nds:गाहाय जार्मान
      ne:नेपाली
      new:नेवारी
      ng:न्डोंगा
      nia:नियास
      niu:नियुइआन
      nl:डात्च
      nl-BE:फ्लेमिस
      nmg:क्वासिअ’
      nn:नरवैजियान निनर्स्क
      nnh:न्गीएम्बून
      no:नरवैजियान
      nog:न’गाई
      non:पुरानी नॉर्स्
      nqo:नंक’
      nr:खोला न्देबेले
      nso:साहायारि सथ’
      nus:नूवेर
      nv:नावाहो
      nwc:पुरानी नेवारी
      ny:न्यान्जा
      nym:न्यामवेज़ी
      nyn:न्यानकोले
      nyo:न्यौरो
      nzi:न्ज़ीमा
      oc:अक्सितान
      oj:ओहीबवा
      ojb:साहा-सोनाबारि अजिब्वा
      ojc:मिरु अजिब्वा
      ojs:अजि क्री
      ojw:सोनाबारि अजिब्वा
      oka:अकानागान
      om:अरम’
      or:उरीया
      os:अस्सेटीक
      osa:ओसेज
      ota:तुर्की ओटोमान
      pa:पान्जाबी
      pag:पाङासिनान
      pal:पहलवी
      pam:पाम्पाङा
      pap:पापीआमेन्तो
      pau:पालाऊवान
      pcm:नाइजेरियान पिदजीन
      peo:पुरानी फ़ारसी
      phn:फीनीसी
      pi:पाली
      pis:पिजिन
      pl:पलिश
      pon:पोहनपी
      pqm:मालिसीत- पास्सामक्वद्दी
      pro:पुरानी प्रोवाँसाल
      ps:पाश्त’
      pt:पर्टुगिज
      pt-BR:ब्राजिलनि पर्टुगिज
      pt-PT:युरोपनि पर्टुगिज
      qu:क्वेचुआ
      raj:राजस्थानी
      rap:रापानुई
      rar:रार’टंगान
      rhg:रहिंगीया
      rm:रमान्श
      rn:रुन्दी
      ro:रमानीयान
      ro-MD:मोल्डेवियन्
      rof:रम्ब’
      rom:रुमानी
      ru:रासियान
      rup:आरोमानियान
      rw:किन्यार्वान्दा
      rwk:र्वा
      sa:संस्कृत
      sad:साण्डावे
      sah:साखा
      sam:समारीती आरामाईक़
      saq:साम्बुरू
      sas:सासक
      sat:सान्थाली
      sba:न्गाम्बै
      sbp:साङु
      sc:सार्दीनीयान
      scn:सिसिलियान
      sco:स्क’टस
      sd:सिन्धी
      se:साहायारि सामी
      seh:सेना
      sel:सेलकुप
      ses:कईराबर’ सेन्नि
      sg:साङ’
      sga:पुरानी आईरीश
      sh:सर्बो-क्रोएशन्
      shi:ताचेल्हीट
      shn:शान
      si:सींहाला
      sid:सीदामो
      sk:स्ल’भाक
      sl:स्लोभेनियान
      slh:खोलायारि लाशुतसीद
      sm:साम’वान
      sma:पश्चीमी सामी
      smj:लुले सामी
      smn:ईनारी सामी
      sms:स्कल्ट सामी
      sn:शना
      snk:स’निन्के
      so:स’माली
      sog:सोगडीयन
      sq:आल्बानियान
      sr:सार्बियान
      srn:स्रानान टंग’
      srr:सेरेर
      ss:स्वाटि
      st:खोलायारि सथ’
      str:स्ट्रैत्स सालिश
      su:सुन्दानी
      suk:सुकुमा
      sus:सुसु
      sux:सुमेरिअन
      sv:स्वीडिश
      sw:स्वाहिली
      swb:कमरियान
      syc:पारंपरीक सिरिआक
      syr:सिरिआक
      ta:तामिल
      tce:खोलायारि तात्चने
      te:तेलुगु
      tem:तीमने
      teo:तेस’
      ter:तेरेनो
      tet:तेतुम
      tg:ताजिक
      tgx:तागीश
      th:थाई
      tht:टाहल्टान
      ti:तिग्रीन्या
      tig:टीग्रे
      tiv:टीव्
      tk:तुर्कमेन
      tkl:टोकेलौ
      tl:तागालोग
      tlh:क्लिङ’न
      tli:त्लिङीत
      tmh:तमाशेक
      tn:त्स्वाना
      to:टंगान
      tog:न्यासा टॉंगा
      tok:टकि पना
      tpi:ट’क पिसीन
      tr:तुर्कीस
      trv:तार’क’
      ts:त्संगा
      tsi:त्सीमशीआन्
      tt:टाटार
      ttm:साहायारि तात्च’ने
      tum:तुम्बुका
      tvl:टुभालु
      tw:ट्वी
      twq:तेसावाक
      ty:टाहीटियान
      tyv:तुभिनियान
      tzm:सेन्ट्रेल आटलास तामाजाईट
      udm:उडमुर्त
      ug:उईघुर
      uga:उगारिती
      uk:युक्रेनियान
      umb:उम्बुन्डु
      und:मिथियै राव
      ur:ऊर्दु
      uz:उजबेक
      vai:भाई
      ve:भेन्डा
      vi:भियेतनामिस
      vo:वोलापोक
      vot:वोटीक
      vun:भुन्ज’
      wa:वाल्लुन
      wae:वाल्सार
      wal:वलाईत्ता
      war:वारै
      was:वाशो
      wo:वल’फ
      wuu:वु चाइनीज
      xal:कालमीक
      xh:ख’सा
      xog:स’गा
      yao:याओ
      yap:यापीज़
      yav:यांबेन
      ybb:येम्बा
      yi:यीद्दीश
      yo:यरूबा
      yrl:न्हीगातू
      yue:केन्टनिज
      yue-alt-menu:चाईनिज, केन्टनिज
      za:ज़ुआंग
      zap:ज़ापोतेक
      zbl:ब्लीस चिन्ह
      zen:ज़ेनागा
      zgh:स्टेन्दार्द मरक्कान तामाजाईट
      zh:चाइनीज
      zh-alt-menu:चाइनीज, मेण्डारिन
      zh-Hans:गोरलै खालामनाय चाइनीज
      zh-Hans-alt-long:गोरलै खालामनाय मेण्डारिन चाइनीज
      zh-Hant:आसार-खान्थियारि चाइनीज
      zh-Hant-alt-long:आसार-खान्थियारि चाइनीज
      zu:जुलू
      zun:जुनी
      zxx:रावआरि आयदाफोर जेबो गैया
      zza:जाजा
      """.trimIndent() }

  val bs: String by lazy { """
      aa:afarski
      ab:abhaski
      ace:ačinski
      ach:akoli
      ada:adangmejski
      ady:adigejski
      ae:avestanski
      af:afrikans
      afh:afrihili
      agq:aghem
      ain:ainu
      ak:akan
      akk:akadijski
      ale:aleutski
      alt:južni altai
      am:amharski
      an:aragonski
      ang:staroengleski
      ann:obolo
      anp:angika
      ar:arapski
      ar-001:moderni standardni arapski
      arc:aramejski
      arn:mapuški
      arp:arapaho
      ars:najdski arapski
      arw:aravak
      as:asamski
      asa:asu
      ast:asturijski
      atj:atikamekw
      av:avarski
      awa:avadhi
      ay:ajmara
      az:azerbejdžanski
      az-alt-short:azerski
      ba:baškirski
      bal:baluči
      ban:balinezijski
      bas:basa
      bax:bamunski
      bbj:gomala
      be:bjeloruski
      bej:beja
      bem:bemba
      bez:bena
      bfd:bafut
      bg:bugarski
      bgc:harianvi
      bgn:zapadni belučki
      bho:bojpuri
      bi:bislama
      bik:bikol
      bin:bini
      bkm:kom
      bla:siksika
      blo:anii
      bm:bambara
      bn:bengalski
      bo:tibetanski
      br:bretonski
      bra:braj
      brx:bodo
      bs:bosanski
      bss:akoski
      bua:buriat
      bug:bugiški
      bum:bulu
      byn:blin
      byv:medumba
      ca:katalonski
      cad:kado
      car:karipski
      cay:kajuga
      cch:atsam
      ccp:čakma
      ce:čečenski
      ceb:cebuano
      cgg:čiga
      ch:čamoro
      chb:čibča
      chg:čagatai
      chk:čukeski
      chm:mari
      chn:činukski žargon
      cho:čoktav
      chp:čipvijanski
      chr:čeroki
      chy:čejenski
      ckb:centralnokurdski
      ckb-alt-menu:centralnokurdski
      ckb-alt-variant:centralnokurdski
      clc:chilcotin
      co:korzikanski
      cop:koptski
      cr:kri
      crg:mičif
      crh:krimski turski
      crj:jugoistočni kri
      crk:ravničarski kri
      crl:sjeveroistočni kri
      crm:mus kri
      crr:sjevernokarolinški algonkvijski
      crs:seselva kreolski francuski
      cs:češki
      csb:kašubijanski
      csw:močvarni kri
      cu:staroslavenski
      cv:čuvaški
      cy:velški
      da:danski
      dak:dakota
      dar:dargva
      dav:taita
      de:njemački
      de-CH:visoki njemački (Švicarska)
      del:delaver
      den:slave
      dgr:dogrib
      din:dinka
      dje:zarma
      doi:dogri
      dsb:donjolužičkosrpski
      dua:duala
      dum:srednjovjekovni holandski
      dv:divehi
      dyo:jola-foni
      dyu:diula
      dz:džonga
      dzg:dazaga
      ebu:embu
      ee:eve
      efi:efik
      egy:staroegipatski
      eka:ekajuk
      el:grčki
      elx:elamitski
      en:engleski
      enm:srednjovjekovni engleski
      eo:esperanto
      es:španski
      et:estonski
      eu:baskijski
      ewo:evondo
      fa:perzijski
      fa-AF:dari
      fan:fang
      fat:fanti
      ff:fulah
      fi:finski
      fil:filipino
      fj:fidžijski
      fo:farski
      fon:fon
      fr:francuski
      frc:kajunski francuski
      frm:srednjovjekovni francuski
      fro:starofrancuski
      frr:sjeverni frizijski
      frs:istočnofrizijski
      fur:friulijski
      fy:zapadni frizijski
      ga:irski
      gaa:ga
      gag:gagauški
      gay:gajo
      gba:gbaja
      gd:škotski galski
      gez:staroetiopski
      gil:gilbertski
      gl:galicijski
      gmh:srednjovjekovni gornjonjemački
      gn:gvarani
      goh:staronjemački
      gon:gondi
      gor:gorontalo
      got:gotski
      grb:grebo
      grc:starogrčki
      gsw:njemački (Švicarska)
      gu:gudžarati
      guz:gusi
      gv:manks
      gwi:gvičin
      ha:hausa
      hai:haida
      haw:havajski
      hax:južni haida
      he:hebrejski
      hi:hindi
      hi-Latn-alt-variant:hingleski
      hil:hiligajnon
      hit:hitite
      hmn:hmong
      ho:hiri motu
      hr:hrvatski
      hsb:gornjolužičkosrpski
      ht:haićanski kreolski
      hu:mađarski
      hup:hupa
      hur:halkomelem
      hy:armenski
      hz:herero
      ia:interlingva
      iba:iban
      ibb:ibibio
      id:indonezijski
      ie:interlingve
      ig:igbo
      ii:sičuan ji
      ik:inupiak
      ikt:zapadnokanadski inuktitut
      ilo:iloko
      inh:ingušetski
      io:ido
      is:islandski
      it:italijanski
      iu:inuktitut
      ja:japanski
      jbo:lojban
      jgo:ngomba
      jmc:makame
      jpr:judeo-perzijski
      jrb:judeo-arapski
      jv:javanski
      ka:gruzijski
      kaa:kara-kalpak
      kab:kabile
      kac:kačin
      kaj:kaju
      kam:kamba
      kaw:kavi
      kbd:kabardijski
      kbl:kanembu
      kcg:tjap
      kde:makonde
      kea:zelenortski
      kfo:koro
      kg:kongo
      kgp:kaingang
      kha:kasi
      kho:kotanizijski
      khq:kojra čini
      ki:kikuju
      kj:kuanjama
      kk:kazaški
      kkj:kako
      kl:kalalisutski
      kln:kalenjin
      km:kmerski
      kmb:kimbundu
      kn:kanada
      ko:korejski
      koi:komi-permski
      kok:konkani
      kos:kosrejski
      kpe:kpele
      kr:kanuri
      krc:karačaj-balkar
      kri:krio
      krl:karelijski
      kru:kuruški
      ks:kašmirski
      ksb:šambala
      ksf:bafia
      ksh:kelnski
      ku:kurdski
      kum:kumik
      kut:kutenai
      kv:komi
      kw:kornski
      kwk:kvakvala
      kxv:kuvi
      ky:kirgiški
      la:latinski
      lad:ladino
      lag:langi
      lah:landa
      lam:lamba
      lb:luksemburški
      lez:lezgijski
      lg:ganda
      li:limburški
      lij:ligurski
      lil:liluet
      lkt:lakota
      lmo:lombardski
      ln:lingala
      lo:laoski
      lol:mongo
      lou:luizijanski kreolski
      loz:lozi
      lrc:sjeverni luri
      lsm:samia
      lt:litvanski
      lu:luba-katanga
      lua:luba-lulua
      lui:luiseno
      lun:lunda
      lus:mizo
      luy:luhija
      lv:latvijski
      mad:madureški
      maf:mafa
      mag:magahi
      mai:maitili
      mak:makasar
      man:mandingo
      mas:masai
      mde:maba
      mdf:mokša
      mdr:mandar
      men:mende
      mer:meru
      mfe:mauricijski kreolski
      mg:malgaški
      mga:srednjovjekovni irski
      mgh:makuva-meto
      mgo:meta
      mh:maršalski
      mi:maorski
      mic:mikmak
      min:minangkabau
      mk:makedonski
      ml:malajalam
      mn:mongolski
      mnc:manču
      mni:manipuri
      moe:innu-aimun
      moh:mohavk
      mos:mosi
      mr:marati
      ms:malajski
      mt:malteški
      mua:mundang
      mul:više jezika
      mus:kriški
      mwl:mirandeški
      mwr:marvari
      my:burmanski
      mye:mjene
      myv:erzija
      mzn:mazanderanski
      na:nauru
      nap:napolitanski
      naq:nama
      nb:norveški (Bokmal)
      nd:sjeverni ndebele
      nds:donjonjemački
      nds-NL:donjosaksonski
      ne:nepalski
      new:nevari
      ng:ndonga
      nia:nias
      niu:niue
      nl:nizozemski
      nl-BE:flamanski
      nmg:kvasio
      nn:norveški (Nynorsk)
      nnh:ngiembon
      no:norveški
      nog:nogai
      non:staronordijski
      nqo:nko
      nr:južni ndebele
      nso:sjeverni soto
      nus:nuer
      nv:navaho
      nwc:klasični nevari
      ny:njanja
      nym:njamvezi
      nyn:njankole
      nyo:njoro
      nzi:nzima
      oc:oksitanski
      oj:ojibva
      ojb:sjeverozapadni ojibva
      ojc:centralni ojibva
      ojs:odži kri
      ojw:zapadni ojibva
      oka:okanagan
      om:oromo
      or:odija
      os:osetski
      osa:osage
      ota:osmanski turski
      pa:pandžapski
      pag:pangasinski
      pal:pahlavi
      pam:pampanga
      pap:papiamento
      pau:palauanski
      pcm:nigerijski pidžin
      peo:staroperzijski
      phn:feničanski
      pi:pali
      pis:pidžin
      pl:poljski
      pon:ponpejski
      pqm:malisit-pasamakvodi
      prg:pruski
      pro:staroprovansalski
      ps:paštu
      ps-alt-variant:pušto
      pt:portugalski
      qu:kečua
      quc:kiče
      raj:rajastani
      rap:rapanui
      rar:rarotongan
      rhg:rohindža
      rm:retoromanski
      rn:rundi
      ro:rumunski
      ro-MD:moldavski
      rof:rombo
      rom:romani
      ru:ruski
      rup:arumunski
      rw:kinjaruanda
      rwk:rua
      sa:sanskrit
      sad:sandave
      sah:jakutski
      sam:samaritanski aramejski
      saq:samburu
      sas:sasak
      sat:santali
      sba:ngambaj
      sbp:sangu
      sc:sardinijski
      scn:sicilijanski
      sco:škotski
      sd:sindi
      sdh:južni kurdski
      se:sjeverni sami
      see:seneka
      seh:sena
      sel:selkup
      ses:kojraboro seni
      sg:sango
      sga:staroirski
      sh:srpskohrvatski
      shi:tahelhit
      shn:šan
      shu:čadski arapski
      si:sinhaleški
      sid:sidamo
      sk:slovački
      sl:slovenski
      slh:južni lašutsid
      sm:samoanski
      sma:južni sami
      smj:lule sami
      smn:inari sami
      sms:skolt sami
      sn:šona
      snk:soninke
      so:somalski
      sog:sogdien
      sq:albanski
      sr:srpski
      srn:srananski tongo
      srr:serer
      ss:svati
      ssy:saho
      st:južni soto
      str:ravničarski sališki
      su:sundanski
      suk:sukuma
      sus:susu
      sux:sumerski
      sv:švedski
      sw:svahili
      swb:komorski
      syc:klasični sirijski
      syr:sirijski
      szl:šleski
      ta:tamilski
      tce:južni tučoni
      te:telugu
      tem:timne
      teo:teso
      ter:tereno
      tet:tetum
      tg:tadžički
      tgx:tagiš
      th:tajlandski
      tht:tahltanski
      ti:tigrinja
      tig:tigre
      tiv:tiv
      tk:turkmenski
      tkl:tokelau
      tl:tagalog
      tlh:klingonski
      tli:tlingit
      tmh:tamašek
      tn:tsvana
      to:tonganski
      tog:njasa tonga
      tok:toki pona
      tpi:tok pisin
      tr:turski
      trv:taroko
      ts:tsonga
      tsi:tsimšian
      tt:tatarski
      ttm:sjeverni tučoni
      tum:tumbuka
      tvl:tuvalu
      tw:tvi
      twq:tasavak
      ty:tahićanski
      tyv:tuvinijski
      tzm:centralnoatlaski tamazigt
      udm:udmurt
      ug:ujgurski
      uga:ugaritski
      uk:ukrajinski
      umb:umbundu
      und:nepoznati jezik
      ur:urdu
      uz:uzbečki
      ve:venda
      vec:venecijanski
      vi:vijetnamski
      vmw:makua
      vo:volapuk
      vot:votski
      vun:vunjo
      wa:valun
      wae:valser
      wal:valamo
      war:varej
      was:vašo
      wbp:varlpiri
      wo:volof
      wuu:Wu kineski
      xal:kalmik
      xh:hosa
      xnr:kangri
      xog:soga
      yao:jao
      yap:japeški
      yav:jangben
      ybb:jemba
      yi:jidiš
      yo:jorubanski
      yrl:ningatu
      yue:kantonski
      yue-alt-menu:kineski, kantonski
      za:zuang
      zap:zapotečki
      zbl:blis simboli
      zen:zenaga
      zgh:standardni marokanski tamazigt
      zh:kineski
      zh-alt-menu:kineski (standardni)
      zh-Hans:kineski (pojednostavljeni)
      zh-Hans-alt-long:kineski (pojednostavljeni standardni)
      zh-Hant:kineski (tradicionalni)
      zh-Hant-alt-long:kineski (tradicionalni standardni)
      zu:zulu
      zun:zuni
      zxx:bez lingvističkog sadržaja
      zza:zaza
      """.trimIndent() }

  val bs_Cyrl: String by lazy { """
      aa:афарски
      ab:абказијски
      ace:ачинески
      ach:аколи
      ada:адангмејски
      ady:адигејски
      ae:авестански
      af:африканс
      afh:африхили
      agq:ахемски
      ain:аину
      ak:акан
      akk:акадијски
      ale:аљут
      alt:јужни алтаи
      am:амхарски
      an:арагонежански
      ang:староенглески
      ann:оболо
      anp:ангика
      ar:арапски
      ar-001:арапски (стандардни)
      arc:армајски
      arn:ароканијски
      arp:арапахо
      ars:најди арапски
      arw:аравак
      as:асемијски
      asa:асу
      ast:астуријски
      atj:атикамекв
      av:аварски
      awa:авадхи
      ay:ајмара
      az:азербејџански
      az-alt-short:азерски
      ba:башкир
      bal:балучи
      ban:балинезијски
      bas:баса
      be:бјелоруски
      bej:беја
      bem:бемба
      bez:бена
      bg:бугарски
      bho:бојпури
      bi:бислама
      bik:бикол
      bin:бини
      bla:сисика
      bm:бамбара
      bn:бенгалски
      bo:тибетански
      br:бретонски
      bra:брај
      brx:бодо
      bs:босански
      bua:буриат
      bug:бугинежански
      byn:блин
      ca:каталонски
      cad:кадо
      car:карипски
      cay:Кајуга
      cch:атсамски
      ccp:чакма
      ce:чеченски
      ceb:цебуано
      cgg:чига
      ch:чаморо
      chb:чибча
      chg:чагатаи
      chk:чукески
      chm:мари
      chn:чинукски
      cho:чоктавски
      chp:чипвијански
      chr:чероки
      chy:чејенски
      ckb:централнокурдски
      ckb-alt-menu:централнокурдски
      ckb-alt-variant:централнокурдски
      clc:Чилкотин
      co:корзикански
      cop:коптски
      cr:кри
      crg:мичиф
      crh:кримеански турски
      crj:јужноисточни кре
      crk:равничарски кре
      crl:сјеверно источни кре
      crm:мосе кре
      crr:алгонкуански за Каролину
      cs:чешки
      csb:кашубијански
      csw:свампи кре
      cu:старославенски
      cv:чувашки
      cy:велшки
      da:дански
      dak:дакота
      dar:даргва
      dav:таита
      de:њемачки
      de-CH:високи њемачки (Швицарска)
      del:делавер
      den:славски
      dgr:догриб
      din:динка
      dje:зарма
      doi:догри
      dsb:доњолужичкосрпски
      dua:дуала
      dum:средњи холандски
      dv:дивехијски
      dyo:јола-фоњи
      dyu:ђула
      dz:џонга
      dzg:дазага
      ebu:ембу
      ee:еве
      efi:ефикски
      egy:староегипатски
      eka:екајук
      el:грчки
      elx:еламитски
      en:енглески
      enm:средњи енглески
      eo:есперанто
      es:шпански
      et:естонски
      eu:баскијски
      ewo:евондо
      fa:персијски
      fan:фанг
      fat:фанти
      ff:фулах
      fi:фински
      fil:филипински
      fj:фиджијски
      fo:фарски
      fon:фон
      fr:француски
      frc:кајунски француски
      frm:средњи француски
      fro:старофранцуски
      frr:северно-фризијски
      frs:источни фризијски
      fur:фриулијски
      fy:западни фризијски
      ga:ирски
      gaa:га
      gay:гајо
      gba:гбаја
      gd:шкотски галски
      gez:џиз
      gil:гилбертшки
      gl:галски
      gmh:средњи високи немачки
      gn:гварани
      goh:старонемачки
      gon:гонди
      gor:горонтало
      got:готски
      grb:гребо
      grc:старогрчки
      gsw:њемачки (Швицарска)
      gu:гуџарати
      guz:гуси
      gv:манкс
      gwi:гвич’ин
      ha:хауса
      hai:хаида
      haw:хавајски
      hax:јужни хаида
      he:хебрејски
      hi:хинди
      hil:хилигајнон
      hit:хитите
      hmn:хмонг
      ho:хири моту
      hr:хрватски
      hsb:горњолужичкосрпски
      ht:хаићански креолски
      hu:мађарски
      hup:хупа
      hur:халкомелем
      hy:јерменски
      hz:хереро
      ia:интерлингва
      iba:ибан
      ibb:ибибио
      id:индонежански
      ie:међујезички
      ig:игбо
      ii:сечуан ји
      ik:унупиак
      ikt:западно канадски инуктитут
      ilo:илоко
      inh:ингвишки
      io:идо
      is:исландски
      it:италијански
      iu:инуктитут
      ja:јапански
      jbo:лојбан
      jgo:нгомба
      jmc:мачаме
      jpr:јудео-персијски
      jrb:јудео-арапски
      jv:јавански
      ka:грузијски
      kaa:кара-калпашки
      kab:кабиле
      kac:качин
      kaj:ђу
      kam:камба
      kaw:кави
      kbd:кабардијски
      kcg:тјап
      kde:маконде
      kea:кабовердијански креолски
      kfo:коро
      kg:конго
      kgp:каинганг
      kha:каси
      kho:котанешки
      khq:којра чини
      ki:кикују
      kj:куањама
      kk:казашки
      kkj:како
      kl:калалисут
      kln:калењин
      km:кмерски
      kmb:кимбунду
      kn:канада
      ko:корејски
      kok:конкани
      kos:косреански
      kpe:кпеле
      kr:канури
      krc:карачај-балкар
      krl:карелијски
      kru:курукх
      ks:кашмирски
      ksb:шамбала
      ksf:бафија
      ksh:келнски
      ku:курдски
      kum:кумик
      kut:кутенаи
      kv:коми
      kw:корнишки
      kwk:кваквала
      ky:киргиски
      la:латински
      lad:ладино
      lag:ланги
      lah:ланда
      lam:ламба
      lb:луксембуршки
      lez:лезгиан
      lg:ганда
      li:лимбургиш
      lij:линуриан
      lil:лилоет
      lkt:лакота
      ln:лингала
      lo:лаоски
      lol:монго
      lou:луизиански креолски
      loz:лози
      lrc:сјеверни лури
      lsm:самиа
      lt:литвански
      lu:луба-катанга
      lua:луба-лулуа
      lui:луисено
      lun:лунда
      luo:луо
      lus:лушаи
      luy:луја
      lv:латвијски
      mad:мадурешки
      mag:магахи
      mai:маитили
      mak:макасар
      man:мандинго
      mas:масаи
      mdf:мокша
      mdr:мандар
      men:менде
      mer:меру
      mfe:мауритански
      mg:малагасијски
      mga:средњи ирски
      mgh:макуа-мето
      mgo:мета
      mh:маршалски
      mi:маорски
      mic:микмак
      min:минангкабау
      mk:македонски
      ml:малајалам
      mn:монголски
      mnc:манчу
      mni:манипури
      moe:иму-аимун
      moh:махавски
      mos:моси
      mr:марати
      ms:малајски
      mt:малтешки
      mua:мунданг
      mul:више језика
      mus:кришки
      mwl:мирандешки
      mwr:марвари
      my:бурмански
      myv:ерзија
      mzn:мазандерани
      na:науру
      nap:неаполитански
      naq:нама
      nb:норвешки бокмал
      nd:сјеверни ндебеле
      nds:ниски њемачки
      ne:непалски
      new:невари
      ng:ндонга
      nia:ниас
      niu:ниуеан
      nl:холандски
      nl-BE:фламански
      nmg:квасио
      nn:норвешки нинорск
      nnh:нгиембун
      no:норвешки
      nog:ногаи
      non:стари норски
      nqo:н’ко
      nr:јужни ндебеле
      nso:сјеверни сото
      nus:нуер
      nv:навахо
      nwc:класични невари
      ny:њања
      nym:њамвези
      nyn:њанколе
      nyo:њоро
      nzi:нзима
      oc:провансалски
      oj:ојибва
      ojb:сјеверозападни ојибва
      ojc:Централни обијва
      ojs:оји-кре
      ojw:западни ојибва
      oka:оканаган
      om:оромо
      or:одија
      os:осетски
      osa:осаге
      ota:отомански турски
      pa:пенџапски
      pag:пангасински
      pal:пахлави
      pam:пампанга
      pap:папиаменто
      pau:палауански
      pcm:нигеријски пидгин
      peo:староперсијски
      phn:феничански
      pi:пали
      pis:пијин
      pl:пољски
      pon:понпејски
      pqm:малисет-шасамкуоди
      prg:пруски
      pro:старопровансалски
      ps:паштунски
      ps-alt-variant:пашто
      pt:португалски
      qu:квенча
      raj:рађастани
      rap:рапануи
      rar:раротонган
      rhg:рохимгја
      rm:рето-романски
      rn:рунди
      ro:румунски
      ro-MD:молдавски
      rof:ромбо
      rom:романи
      ru:руски
      rup:ароманијски
      rw:кинјаруанда
      rwk:рва
      sa:санскрит
      sad:сандаве
      sah:јакутски
      sam:самаритански арамејски
      saq:самбуру
      sas:сасак
      sat:сантали
      sba:нгамбеј
      sbp:сангу
      sc:сардињаски
      scn:сицилијански
      sco:шкотски
      sd:синди
      se:сјеверни сами
      seh:сена
      sel:селкап
      ses:којраборо сени
      sg:санго
      sga:староирски
      sh:српскохрватски
      shi:ташелхит
      shn:шан
      si:синхалски
      sid:сидамо
      sk:словачки
      sl:словенски
      slh:јужни лушотсед
      sm:самоански
      sma:јужни сами
      smj:луле сами
      smn:инари сами
      sms:сколтски језик
      sn:шона
      snk:сонинке
      so:сомалски
      sog:соџијенски
      sq:албански
      sr:српски
      srn:сранански тонго
      srr:серер
      ss:свати
      st:сесото
      str:страитс салиш
      su:сундански
      suk:сукума
      sus:сусу
      sux:сумерски
      sv:шведски
      sw:свахили
      swb:коморски
      syc:класични сиријски
      syr:сиријски
      ta:тамилски
      tce:јужни тутчоне
      te:телугу
      tem:тимне
      teo:тесо
      ter:терено
      tet:тетум
      tg:таџички
      tgx:тагиш
      th:тајландски
      tht:талтан
      ti:тигриња
      tig:тигре
      tiv:тив
      tk:туркменски
      tkl:токелау
      tl:тагалски
      tlh:клингонски
      tli:тлингит
      tmh:тамашек
      tn:тсвана
      to:тонга
      tog:њаса тонга
      tok:токи пона
      tpi:ток писин
      tr:турски
      trv:тароко
      ts:тсонга
      tsi:тсимшиан
      tt:татарски
      ttm:сјеверни тутчоне
      tum:тумбука
      tvl:тувалу
      tw:тви
      twq:тасавак
      ty:тахићански
      tyv:тувинијски
      tzm:централноатласки тамазихт
      udm:удмурт
      ug:ујгурски
      uga:угаритски
      uk:украјински
      umb:умбунду
      und:непознати језик
      ur:урду
      uz:узбечки
      vai:ваи
      ve:венда
      vec:венецијански
      vi:вијетнамски
      vo:волапук
      vot:вотски
      vun:вунјо
      wa:валун
      wae:валсерски
      wal:валамо
      war:варај
      was:вашо
      wo:волоф
      wuu:ву кинески
      xal:калмик
      xh:коса
      xog:сога
      yao:јао
      yap:јапешки
      yav:јангбен
      ybb:јемба
      yi:јидиш
      yo:јоруба
      yrl:ненгату
      yue:кантонски
      yue-alt-menu:кинески (кантонски)
      za:жуанг
      zap:запотечки
      zbl:блисимболи
      zen:зенага
      zgh:стандардни марокански тамазихт
      zh:кинески
      zh-alt-menu:кинески (мандарински)
      zh-Hans:кинески (поједностављен)
      zh-Hans-alt-long:кинески мандариснки поједностављен
      zh-Hant-alt-long:кинески мандарински (традиционални)
      zu:зулу
      zun:зуни
      zxx:без лингвистичког садржаја
      zza:заза
      """.trimIndent() }

  val bs_Latn: String? = null

  val bss: String by lazy { """
      bss:Akoose
      en:Akáálé
      fr:Frɛnsé
      """.trimIndent() }

  val byn: String by lazy { """
      ro-MD:ሞልዳቫዊና
      """.trimIndent() }

  val ca: String by lazy { """
      aa:àfar
      ab:abkhaz
      ace:atjeh
      ach:acoli
      ada:adangme
      ady:adigué
      ae:avèstic
      af:afrikaans
      afh:afrihili
      agq:aghem
      ain:ainu
      ak:àkan
      akk:accadi
      akz:alabama
      ale:aleuta
      aln:albanès geg
      alt:altaic meridional
      am:amhàric
      an:aragonès
      ang:anglès antic
      ann:obolo
      anp:angika
      ar:àrab
      ar-001:àrab estàndard modern
      arc:arameu
      arn:mapudungu
      aro:araona
      arp:arapaho
      ars:àrab najdi
      arw:arauac
      arz:àrab egipci
      as:assamès
      asa:pare
      ase:llengua de signes americana
      ast:asturià
      atj:atacama
      av:àvar
      awa:awadhi
      ay:aimara
      az:azerbaidjanès
      az-alt-short:àzeri
      ba:baixkir
      bal:balutxi
      ban:balinès
      bar:bavarès
      bas:basa
      bax:bamum
      bbj:ghomala
      be:belarús
      bej:beja
      bem:bemba
      bez:bena
      bfd:bafut
      bfq:badaga
      bg:búlgar
      bgc:haryanvi
      bgn:balutxi occidental
      bho:bhojpuri
      bi:bislama
      bik:bicol
      bin:edo
      bkm:kom
      bla:blackfoot
      blo:anii
      bm:bambara
      bn:bengalí
      bo:tibetà
      br:bretó
      bra:braj
      brh:brahui
      brx:bodo
      bs:bosnià
      bss:akoose
      bua:buriat
      bug:bugui
      bum:bulu
      byn:bilin
      byv:medumba
      ca:català
      cad:caddo
      car:carib
      cay:cayuga
      cch:atsam
      ccp:chakma
      ce:txetxè
      ceb:cebuà
      cgg:chiga
      ch:chamorro
      chb:txibtxa
      chg:txagatai
      chk:chuuk
      chm:mari
      chn:pidgin chinook
      cho:choctaw
      chp:chipewyan
      chr:cherokee
      chy:xeiene
      ckb:kurd central
      ckb-alt-menu:sorani
      ckb-alt-variant:kurd sorani
      clc:chilcotin
      co:cors
      cop:copte
      cr:cree
      crg:michif
      crh:tàtar de Crimea
      crj:cree sud-oriental
      crk:cree de la plana
      crl:cree nord-oriental
      crm:moose cree
      crr:algonquí de Carolina
      crs:francès crioll de les Seychelles
      cs:txec
      csb:caixubi
      csw:swampy cree
      cu:eslau eclesiàstic
      cv:txuvaix
      cy:gal lès
      da:danès
      dak:dakota
      dar:darguà
      dav:taita
      de:alemany
      de-AT:alemany austríac
      de-CH:alemany estàndard suís
      del:delaware
      den:slavi
      dgr:dogrib
      din:dinka
      dje:zarma
      doi:dogri
      dsb:baix sòrab
      dua:douala
      dum:neerlandès mitjà
      dv:divehi
      dyo:diola
      dyu:jula
      dz:dzongka
      dzg:dazaga
      ebu:embu
      ee:ewe
      efi:efik
      egl:emilià
      egy:egipci antic
      eka:ekajuk
      el:grec
      elx:elamita
      en:anglès
      en-AU:anglès australià
      en-CA:anglès canadenc
      en-GB:anglès britànic
      en-GB-alt-short:anglès (GB)
      en-US:anglès americà
      en-US-alt-short:anglès (EUA)
      enm:anglès mitjà
      eo:esperanto
      es:espanyol
      es-419:espanyol llatinoamericà
      es-ES:espanyol europeu
      es-MX:espanyol de Mèxic
      et:estonià
      eu:basc
      ewo:ewondo
      ext:extremeny
      fa:persa
      fa-AF:dari
      fan:fang
      fat:fanti
      ff:ful
      fi:finès
      fil:filipí
      fj:fijià
      fo:feroès
      fon:fon
      fr:francès
      fr-CA:francès canadenc
      fr-CH:francès suís
      frc:francès cajun
      frm:francès mitjà
      fro:francès antic
      frr:frisó septentrional
      frs:frisó oriental
      fur:friülà
      fy:frisó occidental
      ga:irlandès
      gaa:ga
      gag:gagaús
      gan:xinès gan
      gay:gayo
      gba:gbaya
      gd:gaèlic escocès
      gez:gueez
      gil:gilbertès
      gl:gallec
      glk:gilaki
      gmh:alt alemany mitjà
      gn:guaraní
      goh:alt alemany antic
      gon:gondi
      gor:gorontalo
      got:gòtic
      grb:grebo
      grc:grec antic
      gsw:alemany suís
      gu:gujarati
      guc:wayú
      guz:gusí
      gv:manx
      gwi:gwich’in
      ha:haussa
      hai:haida
      hak:xinès hakka
      haw:hawaià
      hax:haida meridional
      he:hebreu
      hi:hindi
      hi-Latn-alt-variant:hinglish
      hif:hindi de Fiji
      hil:híligaynon
      hit:hitita
      hmn:hmong
      ho:hiri motu
      hr:croat
      hsb:alt sòrab
      hsn:xinès xiang
      ht:crioll d’Haití
      hu:hongarès
      hup:hupa
      hur:halkomelem
      hy:armeni
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonesi
      ie:interlingue
      ig:igbo
      ii:yi sichuan
      ik:inupiak
      ikt:inuktitut occidental canadenc
      ilo:ilocano
      inh:ingúix
      io:ido
      is:islandès
      it:italià
      iu:inuktitut
      ja:japonès
      jam:crioll anglès de Jamaica
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jpr:judeopersa
      jrb:judeoàrab
      jv:javanès
      ka:georgià
      kaa:karakalpak
      kab:cabilenc
      kac:katxin
      kaj:jju
      kam:kamba
      kaw:kawi
      kbd:kabardí
      kbl:kanembu
      kcg:tyap
      kde:makonde
      kea:crioll capverdià
      ken:kenyang
      kfo:koro
      kg:kongo
      kgp:kaingà
      kha:khasi
      kho:khotanès
      khq:koyra chiini
      ki:kikuiu
      kj:kuanyama
      kk:kazakh
      kkj:kako
      kl:groenlandès
      kln:kalenjin
      km:khmer
      kmb:kimbundu
      kn:kannada
      ko:coreà
      koi:komi-permiac
      kok:concani
      kos:kosraeà
      kpe:kpelle
      kr:kanuri
      krc:karatxai-balkar
      kri:krio
      krl:carelià
      kru:kurukh
      ks:caixmiri
      ksb:shambala
      ksf:bafia
      ksh:kölsch
      ku:kurd
      kum:kúmik
      kut:kutenai
      kv:komi
      kw:còrnic
      kwk:kwak’wala
      kxv:kuvi
      ky:kirguís
      la:llatí
      lad:judeocastellà
      lag:langi
      lah:panjabi occidental
      lam:lamba
      lb:luxemburguès
      lez:lesguià
      lg:ganda
      li:limburguès
      lij:lígur
      lil:lillooet
      lkt:lakota
      lmo:llombard
      ln:lingala
      lo:laosià
      lol:mongo
      lou:crioll francès de Louisiana
      loz:lozi
      lrc:luri septentrional
      lsm:saamia
      lt:lituà
      lu:luba katanga
      lua:luba-lulua
      lui:luisenyo
      lun:lunda
      lus:mizo
      luy:luyia
      lv:letó
      lzh:xinès clàssic
      lzz:laz
      mad:madurès
      maf:mafa
      mag:magahi
      mai:maithili
      mak:makassar
      man:mandinga
      mas:massai
      mde:maba
      mdf:mordovià moksa
      mdr:mandar
      men:mende
      mer:meru
      mfe:mauricià
      mg:malgaix
      mga:gaèlic irlandès mitjà
      mgh:makhuwa-metto
      mgo:meta’
      mh:marshallès
      mi:maori
      mic:micmac
      min:minangkabau
      mk:macedoni
      ml:malaiàlam
      mn:mongol
      mnc:manxú
      mni:manipurí
      moe:innu-aimun
      moh:mohawk
      mos:moore
      mr:marathi
      mrj:mari occidental
      ms:malai
      mt:maltès
      mua:mundang
      mul:llengües vàries
      mus:creek
      mwl:mirandès
      mwr:marwari
      my:birmà
      mye:myene
      myv:mordovià erza
      mzn:mazanderani
      na:nauruà
      nan:xinès min del sud
      nap:napolità
      naq:nama
      nb:noruec bokmål
      nd:ndebele septentrional
      nds:baix alemany
      nds-NL:baix saxó
      ne:nepalès
      new:newari
      ng:ndonga
      nia:nias
      niu:niueà
      nl:neerlandès
      nl-BE:flamenc
      nmg:bissio
      nn:noruec nynorsk
      nnh:ngiemboon
      no:noruec
      nog:nogai
      non:nòrdic antic
      nov:novial
      nqo:n’Ko
      nr:ndebele meridional
      nso:sotho septentrional
      nus:nuer
      nv:navaho
      nwc:newari clàssic
      ny:nyanja
      nym:nyamwesi
      nyn:nyankole
      nyo:nyoro
      nzi:nzema
      oc:occità
      oj:ojibwa
      ojb:ojibwa septentrional
      ojc:ojibwa central
      ojs:oji-cree
      ojw:ojibwa occidental
      oka:okanagà
      om:oromo
      or:oriya
      os:osseta
      osa:osage
      ota:turc otomà
      pa:panjabi
      pag:pangasinan
      pal:pahlavi
      pam:pampanga
      pap:papiament
      pau:palauà
      pcd:picard
      pcm:pidgin de Nigèria
      pdc:alemany pennsilvanià
      peo:persa antic
      pfl:alemany palatí
      phn:fenici
      pi:pali
      pis:pidgin
      pl:polonès
      pms:piemontès
      pnt:pòntic
      pon:ponapeà
      pqm:maliseet-passamaquoddy
      prg:prussià
      pro:provençal antic
      ps:paixtu
      ps-alt-variant:pushtu
      pt:portuguès
      pt-BR:portuguès del Brasil
      pt-PT:portuguès de Portugal
      qu:quítxua
      quc:k’iche’
      raj:rajasthani
      rap:rapanui
      rar:rarotongà
      rgn:romanyès
      rhg:rohingya
      rm:retoromànic
      rn:rundi
      ro:romanès
      ro-MD:moldau
      rof:rombo
      rom:romaní
      ru:rus
      rup:aromanès
      rw:ruandès
      rwk:rwo
      sa:sànscrit
      sad:sandawe
      sah:iacut
      sam:arameu samarità
      saq:samburu
      sas:sasak
      sat:santali
      sba:ngambay
      sbp:sangu
      sc:sard
      scn:sicilià
      sco:escocès
      sd:sindi
      sdc:sasserès
      sdh:kurd meridional
      se:sami septentrional
      see:seneca
      seh:sena
      sel:selkup
      ses:songhai oriental
      sg:sango
      sga:irlandès antic
      sh:serbocroat
      shi:taixelhit
      shn:xan
      shu:àrab txadià
      si:singalès
      sid:sidamo
      sk:eslovac
      sl:eslovè
      slh:lushootseed meridional
      sm:samoà
      sma:sami meridional
      smj:sami lule
      smn:sami d’Inari
      sms:sami skolt
      sn:shona
      snk:soninke
      so:somali
      sog:sogdià
      sq:albanès
      sr:serbi
      srn:sranan
      srr:serer
      ss:swazi
      ssy:saho
      st:sotho meridional
      str:straits salish
      su:sondanès
      suk:sukuma
      sus:susú
      sux:sumeri
      sv:suec
      sw:suahili
      sw-CD:suahili del Congo
      swb:comorià
      syc:siríac clàssic
      syr:siríac
      szl:silesià
      ta:tàmil
      tce:tutxone meridional
      te:telugu
      tem:temne
      teo:teso
      ter:terena
      tet:tètum
      tg:tadjik
      tgx:tagish
      th:tai
      tht:tahltà
      ti:tigrinya
      tig:tigre
      tiv:tiv
      tk:turcman
      tkl:tokelauès
      tkr:tsakhur
      tl:tagal
      tlh:klingonià
      tli:tlingit
      tly:talix
      tmh:amazic
      tn:setswana
      to:tongalès
      tog:tonga
      tok:toki pona
      tpi:tok pisin
      tr:turc
      trv:taroko
      ts:tsonga
      tsi:tsimshià
      tt:tàtar
      ttm:tutxone septentrional
      ttt:tat meridional
      tum:tumbuka
      tvl:tuvaluà
      tw:twi
      twq:tasawaq
      ty:tahitià
      tyv:tuvinià
      tzm:amazic del Marroc central
      udm:udmurt
      ug:uigur
      uga:ugarític
      uk:ucraïnès
      umb:umbundu
      und:idioma desconegut
      ur:urdú
      uz:uzbek
      ve:venda
      vec:vènet
      vep:vepse
      vi:vietnamita
      vls:flamenc occidental
      vmw:makua
      vo:volapük
      vot:vòtic
      vun:vunjo
      wa:való
      wae:walser
      wal:wolaita
      war:waray
      was:washo
      wbp:warlpiri
      wo:wòlof
      wuu:xinès wu
      xal:calmuc
      xh:xosa
      xmf:mingrelià
      xnr:kangri
      xog:soga
      yao:yao
      yap:yapeà
      yav:yangben
      ybb:yemba
      yi:ídix
      yo:ioruba
      yrl:nheengatú
      yue:cantonès
      yue-alt-menu:xinès, cantonès
      za:zhuang
      zap:zapoteca
      zbl:símbols Bliss
      zea:zelandès
      zen:zenaga
      zgh:amazic estàndard marroquí
      zh:xinès
      zh-alt-menu:xinès, mandarí
      zh-Hans:xinès simplificat
      zh-Hans-alt-long:xinès mandarí (simplificat)
      zh-Hant:xinès tradicional
      zh-Hant-alt-long:xinès mandarí (tradicional)
      zu:zulu
      zun:zuni
      zxx:sense contingut lingüístic
      zza:zaza
      """.trimIndent() }

  val ca_AD: String? = null

  val ca_ES_valencia: String by lazy { """
      aa:àfar
      ab:abkhaz
      ace:atjeh
      ach:acoli
      ada:adangme
      ady:adigué
      ae:avèstic
      af:afrikaans
      afh:afrihili
      agq:aghem
      ain:ainu
      ak:àkan
      akk:accadi
      akz:alabama
      ale:aleuta
      aln:albanès geg
      alt:altaic meridional
      am:amhàric
      an:aragonès
      ang:anglès antic
      ann:obolo
      anp:angika
      ar:àrab
      ar-001:àrab estàndard modern
      arc:arameu
      arn:mapudungu
      aro:araona
      arp:arapaho
      ars:àrab najdi
      arw:arauac
      arz:àrab egipci
      as:assamès
      asa:pare
      ase:llengua de signes americana
      ast:asturià
      atj:atacama
      av:àvar
      awa:awadhi
      ay:aimara
      az:azerbaidjanès
      az-alt-short:àzeri
      ba:baixkir
      bal:balutxi
      ban:balinès
      bar:bavarès
      bas:basa
      bax:bamum
      bbj:ghomala
      be:belarús
      bej:beja
      bem:bemba
      bez:bena
      bfd:bafut
      bfq:badaga
      bg:búlgar
      bgc:haryanvi
      bgn:balutxi occidental
      bho:bhojpuri
      bi:bislama
      bik:bicol
      bin:edo
      bkm:kom
      bla:blackfoot
      blo:anii
      bm:bambara
      bn:bengalí
      bo:tibetà
      br:bretó
      bra:braj
      brh:brahui
      brx:bodo
      bs:bosnià
      bss:akoose
      bua:buriat
      bug:bugui
      bum:bulu
      byn:bilin
      byv:medumba
      ca:català
      cad:caddo
      car:carib
      cay:cayuga
      cch:atsam
      ccp:chakma
      ce:txetxè
      ceb:cebuà
      cgg:chiga
      ch:chamorro
      chb:txibtxa
      chg:txagatai
      chk:chuuk
      chm:mari
      chn:pidgin chinook
      cho:choctaw
      chp:chipewyan
      chr:cherokee
      chy:xeiene
      ckb:kurd central
      ckb-alt-menu:sorani
      ckb-alt-variant:kurd sorani
      clc:chilcotin
      co:cors
      cop:copte
      cr:cree
      crg:michif
      crh:tàtar de Crimea
      crj:cree sud-oriental
      crk:cree de la plana
      crl:cree nord-oriental
      crm:moose cree
      crr:algonquí de Carolina
      crs:francès crioll de les Seychelles
      cs:txec
      csb:caixubi
      csw:swampy cree
      cu:eslau eclesiàstic
      cv:txuvaix
      cy:gal lès
      da:danès
      dak:dakota
      dar:darguà
      dav:taita
      de:alemany
      de-AT:alemany austríac
      de-CH:alemany estàndard suís
      del:delaware
      den:slavi
      dgr:dogrib
      din:dinka
      dje:zarma
      doi:dogri
      dsb:baix sòrab
      dua:douala
      dum:neerlandès mitjà
      dv:divehi
      dyo:diola
      dyu:jula
      dz:dzongka
      dzg:dazaga
      ebu:embu
      ee:ewe
      efi:efik
      egl:emilià
      egy:egipci antic
      eka:ekajuk
      el:grec
      elx:elamita
      en:anglès
      en-AU:anglès australià
      en-CA:anglès canadenc
      en-GB:anglès britànic
      en-GB-alt-short:anglès (GB)
      en-US:anglès americà
      en-US-alt-short:anglès (EUA)
      enm:anglès mitjà
      eo:esperanto
      es:espanyol
      es-419:espanyol llatinoamericà
      es-ES:espanyol europeu
      es-MX:espanyol de Mèxic
      et:estonià
      eu:basc
      ewo:ewondo
      ext:extremeny
      fa:persa
      fa-AF:dari
      fan:fang
      fat:fanti
      ff:ful
      fi:finès
      fil:filipí
      fj:fijià
      fo:feroès
      fon:fon
      fr:francès
      fr-CA:francès canadenc
      fr-CH:francès suís
      frc:francès cajun
      frm:francès mitjà
      fro:francès antic
      frr:frisó septentrional
      frs:frisó oriental
      fur:friülà
      fy:frisó occidental
      ga:irlandès
      gaa:ga
      gag:gagaús
      gan:xinès gan
      gay:gayo
      gba:gbaya
      gd:gaèlic escocès
      gez:gueez
      gil:gilbertès
      gl:gallec
      glk:gilaki
      gmh:alt alemany mitjà
      gn:guaraní
      goh:alt alemany antic
      gon:gondi
      gor:gorontalo
      got:gòtic
      grb:grebo
      grc:grec antic
      gsw:alemany suís
      gu:gujarati
      guc:wayú
      guz:gusí
      gv:manx
      gwi:gwich’in
      ha:haussa
      hai:haida
      hak:xinès hakka
      haw:hawaià
      hax:haida meridional
      he:hebreu
      hi:hindi
      hi-Latn-alt-variant:hinglish
      hif:hindi de Fiji
      hil:híligaynon
      hit:hitita
      hmn:hmong
      ho:hiri motu
      hr:croat
      hsb:alt sòrab
      hsn:xinès xiang
      ht:crioll d’Haití
      hu:hongarès
      hup:hupa
      hur:halkomelem
      hy:armeni
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonesi
      ie:interlingue
      ig:igbo
      ii:yi sichuan
      ik:inupiak
      ikt:inuktitut occidental canadenc
      ilo:ilocano
      inh:ingúix
      io:ido
      is:islandès
      it:italià
      iu:inuktitut
      ja:japonès
      jam:crioll anglès de Jamaica
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jpr:judeopersa
      jrb:judeoàrab
      jv:javanès
      ka:georgià
      kaa:karakalpak
      kab:cabilenc
      kac:katxin
      kaj:jju
      kam:kamba
      kaw:kawi
      kbd:kabardí
      kbl:kanembu
      kcg:tyap
      kde:makonde
      kea:crioll capverdià
      ken:kenyang
      kfo:koro
      kg:kongo
      kgp:kaingà
      kha:khasi
      kho:khotanès
      khq:koyra chiini
      ki:kikuiu
      kj:kuanyama
      kk:kazakh
      kkj:kako
      kl:groenlandès
      kln:kalenjin
      km:khmer
      kmb:kimbundu
      kn:kannada
      ko:coreà
      koi:komi-permiac
      kok:concani
      kos:kosraeà
      kpe:kpelle
      kr:kanuri
      krc:karatxai-balkar
      kri:krio
      krl:carelià
      kru:kurukh
      ks:caixmiri
      ksb:shambala
      ksf:bafia
      ksh:kölsch
      ku:kurd
      kum:kúmik
      kut:kutenai
      kv:komi
      kw:còrnic
      kwk:kwak’wala
      kxv:kuvi
      ky:kirguís
      la:llatí
      lad:judeocastellà
      lag:langi
      lah:panjabi occidental
      lam:lamba
      lb:luxemburguès
      lez:lesguià
      lg:ganda
      li:limburguès
      lij:lígur
      lil:lillooet
      lkt:lakota
      lmo:llombard
      ln:lingala
      lo:laosià
      lol:mongo
      lou:crioll francès de Louisiana
      loz:lozi
      lrc:luri septentrional
      lsm:saamia
      lt:lituà
      lu:luba katanga
      lua:luba-lulua
      lui:luisenyo
      lun:lunda
      lus:mizo
      luy:luyia
      lv:letó
      lzh:xinès clàssic
      lzz:laz
      mad:madurès
      maf:mafa
      mag:magahi
      mai:maithili
      mak:makassar
      man:mandinga
      mas:massai
      mde:maba
      mdf:mordovià moksa
      mdr:mandar
      men:mende
      mer:meru
      mfe:mauricià
      mg:malgaix
      mga:gaèlic irlandès mitjà
      mgh:makhuwa-metto
      mgo:meta’
      mh:marshallès
      mi:maori
      mic:micmac
      min:minangkabau
      mk:macedoni
      ml:malaiàlam
      mn:mongol
      mnc:manxú
      mni:manipurí
      moe:innu-aimun
      moh:mohawk
      mos:moore
      mr:marathi
      mrj:mari occidental
      ms:malai
      mt:maltès
      mua:mundang
      mul:llengües vàries
      mus:creek
      mwl:mirandès
      mwr:marwari
      my:birmà
      mye:myene
      myv:mordovià erza
      mzn:mazanderani
      na:nauruà
      nan:xinès min del sud
      nap:napolità
      naq:nama
      nb:noruec bokmål
      nd:ndebele septentrional
      nds:baix alemany
      nds-NL:baix saxó
      ne:nepalès
      new:newari
      ng:ndonga
      nia:nias
      niu:niueà
      nl:neerlandès
      nl-BE:flamenc
      nmg:bissio
      nn:noruec nynorsk
      nnh:ngiemboon
      no:noruec
      nog:nogai
      non:nòrdic antic
      nov:novial
      nqo:n’Ko
      nr:ndebele meridional
      nso:sotho septentrional
      nus:nuer
      nv:navaho
      nwc:newari clàssic
      ny:nyanja
      nym:nyamwesi
      nyn:nyankole
      nyo:nyoro
      nzi:nzema
      oc:occità
      oj:ojibwa
      ojb:ojibwa septentrional
      ojc:ojibwa central
      ojs:oji-cree
      ojw:ojibwa occidental
      oka:okanagà
      om:oromo
      or:oriya
      os:osseta
      osa:osage
      ota:turc otomà
      pa:panjabi
      pag:pangasinan
      pal:pahlavi
      pam:pampanga
      pap:papiament
      pau:palauà
      pcd:picard
      pcm:pidgin de Nigèria
      pdc:alemany pennsilvanià
      peo:persa antic
      pfl:alemany palatí
      phn:fenici
      pi:pali
      pis:pidgin
      pl:polonès
      pms:piemontès
      pnt:pòntic
      pon:ponapeà
      pqm:maliseet-passamaquoddy
      prg:prussià
      pro:provençal antic
      ps:paixtu
      ps-alt-variant:pushtu
      pt:portuguès
      pt-BR:portuguès del Brasil
      pt-PT:portuguès de Portugal
      qu:quítxua
      quc:k’iche’
      raj:rajasthani
      rap:rapanui
      rar:rarotongà
      rgn:romanyès
      rhg:rohingya
      rm:retoromànic
      rn:rundi
      ro:romanès
      ro-MD:moldau
      rof:rombo
      rom:romaní
      ru:rus
      rup:aromanès
      rw:ruandès
      rwk:rwo
      sa:sànscrit
      sad:sandawe
      sah:iacut
      sam:arameu samarità
      saq:samburu
      sas:sasak
      sat:santali
      sba:ngambay
      sbp:sangu
      sc:sard
      scn:sicilià
      sco:escocès
      sd:sindi
      sdc:sasserès
      sdh:kurd meridional
      se:sami septentrional
      see:seneca
      seh:sena
      sel:selkup
      ses:songhai oriental
      sg:sango
      sga:irlandès antic
      sh:serbocroat
      shi:taixelhit
      shn:xan
      shu:àrab txadià
      si:singalès
      sid:sidamo
      sk:eslovac
      sl:eslovè
      slh:lushootseed meridional
      sm:samoà
      sma:sami meridional
      smj:sami lule
      smn:sami d’Inari
      sms:sami skolt
      sn:shona
      snk:soninke
      so:somali
      sog:sogdià
      sq:albanès
      sr:serbi
      srn:sranan
      srr:serer
      ss:swazi
      ssy:saho
      st:sotho meridional
      str:straits salish
      su:sondanès
      suk:sukuma
      sus:susú
      sux:sumeri
      sv:suec
      sw:suahili
      sw-CD:suahili del Congo
      swb:comorià
      syc:siríac clàssic
      syr:siríac
      szl:silesià
      ta:tàmil
      tce:tutxone meridional
      te:telugu
      tem:temne
      teo:teso
      ter:terena
      tet:tètum
      tg:tadjik
      tgx:tagish
      th:tai
      tht:tahltà
      ti:tigrinya
      tig:tigre
      tiv:tiv
      tk:turcman
      tkl:tokelauès
      tkr:tsakhur
      tl:tagal
      tlh:klingonià
      tli:tlingit
      tly:talix
      tmh:amazic
      tn:setswana
      to:tongalès
      tog:tonga
      tok:toki pona
      tpi:tok pisin
      tr:turc
      trv:taroko
      ts:tsonga
      tsi:tsimshià
      tt:tàtar
      ttm:tutxone septentrional
      ttt:tat meridional
      tum:tumbuka
      tvl:tuvaluà
      tw:twi
      twq:tasawaq
      ty:tahitià
      tyv:tuvinià
      tzm:amazic del Marroc central
      udm:udmurt
      ug:uigur
      uga:ugarític
      uk:ucraïnès
      umb:umbundu
      und:idioma desconegut
      ur:urdú
      uz:uzbek
      ve:venda
      vec:vènet
      vep:vepse
      vi:vietnamita
      vls:flamenc occidental
      vmw:makua
      vo:volapük
      vot:vòtic
      vun:vunjo
      wa:való
      wae:walser
      wal:wolaita
      war:waray
      was:washo
      wbp:warlpiri
      wo:wòlof
      wuu:xinès wu
      xal:calmuc
      xh:xosa
      xmf:mingrelià
      xnr:kangri
      xog:soga
      yao:yao
      yap:yapeà
      yav:yangben
      ybb:yemba
      yi:ídix
      yo:ioruba
      yrl:nheengatú
      yue:cantonès
      yue-alt-menu:xinès, cantonès
      za:zhuang
      zap:zapoteca
      zbl:símbols Bliss
      zea:zelandès
      zen:zenaga
      zgh:amazic estàndard marroquí
      zh:xinès
      zh-alt-menu:xinès, mandarí
      zh-Hans:xinès simplificat
      zh-Hans-alt-long:xinès mandarí (simplificat)
      zh-Hant:xinès tradicional
      zh-Hant-alt-long:xinès mandarí (tradicional)
      zu:zulu
      zun:zuni
      zxx:sense contingut lingüístic
      zza:zaza
      """.trimIndent() }

  val ca_FR: String? = null

  val ca_IT: String? = null

  val cch: String by lazy { """
      cch:Atsam
      """.trimIndent() }

  val ccp: String by lazy { """
      aa:𑄃𑄜𑄢𑄴
      ab:𑄃𑄝𑄴𑄈𑄎𑄨𑄠𑄚𑄴
      ace:𑄃𑄳𑄃𑄌𑄳𑄆𑄚𑄨𑄎𑄴
      ach:𑄃𑄇𑄮𑄣𑄨
      ada:𑄃𑄧𑄘𑄟𑄳𑄉𑄬
      ady:𑄃𑄘𑄬𑄉𑄬
      ae:𑄃𑄝𑄬𑄌𑄴𑄖𑄩𑄠𑄧
      af:𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴
      afh:𑄃𑄜𑄳𑄢𑄨𑄦𑄨𑄣𑄨
      agq:𑄃𑄬𑄊𑄟𑄴
      ain:𑄃𑄳𑄆𑄚𑄪
      ak:𑄃𑄇𑄚𑄴
      akk:𑄃𑄇𑄳𑄦𑄴𑄘𑄨𑄠𑄚𑄴
      ale:𑄃𑄣𑄬𑄅𑄖𑄴
      alt:𑄓𑄧𑄉𑄨𑄚𑄴 𑄃𑄣𑄴𑄖𑄭
      am:𑄃𑄟𑄴𑄦𑄢𑄨𑄇𑄴
      an:𑄃𑄢𑄴𑄉𑄮𑄚𑄨𑄎𑄴
      ang:𑄛𑄪𑄢𑄧𑄚𑄨 𑄃𑄟𑄧𑄣𑄧𑄢𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄩
      anp:𑄃𑄋𑄳𑄉𑄨𑄇
      ar:𑄃𑄢𑄧𑄝𑄩
      ar-001:𑄚𑄱 𑄉𑄧𑄟𑄴 𑄃𑄢𑄧𑄝𑄩
      arc:𑄃𑄢𑄟𑄳𑄆𑄇𑄴
      arn:𑄟𑄛𑄪𑄌𑄨
      arp:𑄃𑄢𑄛𑄦𑄮
      arw:𑄃𑄢𑄤𑄇𑄴
      as:𑄃𑄥𑄟𑄨
      asa:𑄃𑄥𑄪
      ast:𑄃𑄌𑄴𑄖𑄪𑄢𑄨𑄠𑄧
      av:𑄃𑄞𑄬𑄢𑄨𑄇𑄴
      awa:𑄃𑄤𑄙𑄨
      ay:𑄃𑄠𑄧𑄟𑄢
      az:𑄃𑄎𑄢𑄴𑄝𑄳𑄆𑄎𑄚𑄩
      az-alt-short:𑄃𑄎𑄬𑄢𑄨
      ba:𑄝𑄌𑄴𑄇𑄨𑄢𑄴
      bal:𑄝𑄬𑄣𑄪𑄌𑄩
      ban:𑄝𑄣𑄨𑄚𑄩𑄠𑄧
      bas:𑄝𑄥
      be:𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄧
      bej:𑄝𑄬𑄎
      bem:𑄝𑄬𑄟𑄴𑄝
      bez:𑄝𑄬𑄚
      bg:𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄨𑄠𑄧
      bgn:𑄛𑄧𑄏𑄨𑄟𑄴 𑄝𑄣𑄮𑄌𑄨
      bho:𑄞𑄮𑄎𑄴𑄛𑄪𑄢𑄨
      bi:𑄝𑄨𑄥𑄴𑄣𑄟
      bik:𑄝𑄨𑄇𑄮𑄣𑄴
      bin:𑄝𑄨𑄚𑄨
      bla:𑄥𑄨𑄇𑄴𑄥𑄨𑄇
      bm:𑄝𑄟𑄴𑄝𑄢
      bn:𑄝𑄁𑄣
      bo:𑄖𑄨𑄛𑄴𑄝𑄧𑄖𑄨
      br:𑄝𑄳𑄢𑄬𑄑𑄧𑄚𑄴
      bra:𑄝𑄳𑄢𑄎𑄴
      brx:𑄝𑄮𑄢𑄮
      bs:𑄝𑄧𑄥𑄴𑄚𑄩𑄠𑄚𑄴
      bua:𑄝𑄪𑄢𑄨𑄠𑄖𑄴
      bug:𑄝𑄪𑄉𑄨𑄚𑄨
      byn:𑄝𑄳𑄣𑄨𑄚𑄴
      ca:𑄇𑄖𑄣𑄚𑄴
      cad:𑄇𑄳𑄠𑄓𑄮
      car:𑄝𑄳𑄠𑄢𑄨𑄛𑄴
      cch:𑄃𑄖𑄴𑄥𑄟𑄴
      ccp:𑄌𑄋𑄴𑄟𑄳𑄦
      ce:𑄌𑄬𑄌𑄬𑄚𑄴
      ceb:𑄌𑄬𑄝𑄪𑄠𑄚𑄮
      cgg:𑄌𑄨𑄉
      ch:𑄌𑄟𑄮𑄢𑄮
      chb:𑄌𑄨𑄛𑄴𑄌
      chg:𑄌𑄉𑄖𑄳𑄆
      chk:𑄌𑄪𑄇𑄨
      chm:𑄟𑄢𑄨
      chn:𑄌𑄨𑄚𑄪𑄇𑄴 𑄎𑄢𑄴𑄉𑄧𑄚𑄴
      cho:𑄌𑄧𑄇𑄴𑄑𑄳𑄅𑄧𑄠𑄧
      chp:𑄌𑄨𑄛𑄮𑄤𑄚𑄴
      chr:𑄌𑄬𑄢𑄮𑄇𑄩
      chy:𑄥𑄳𑄆𑄠𑄬𑄚𑄴
      ckb:𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴
      ckb-alt-menu:𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴
      ckb-alt-variant:𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴
      co:𑄇𑄧𑄢𑄴𑄥𑄨𑄇𑄚𑄴
      cop:𑄇𑄧𑄛𑄴𑄑𑄨𑄇𑄴
      cr:𑄇𑄳𑄢𑄨
      crh:𑄇𑄳𑄢𑄨𑄟𑄨𑄠𑄚𑄴 𑄖𑄪𑄢𑄴𑄇𑄨
      crs:𑄥𑄬𑄥𑄬𑄣𑄧𑄤 𑄇𑄳𑄢𑄬𑄃𑄮𑄣𑄴 𑄜𑄳𑄢𑄬𑄐𑄴𑄌𑄧
      cs:𑄌𑄬𑄇𑄴
      csb:𑄇𑄥𑄪𑄝𑄨𑄠𑄚𑄴
      cu:𑄌𑄢𑄴𑄌𑄴 𑄥𑄳𑄣𑄞𑄨𑄇𑄴
      cv:𑄌𑄪𑄝𑄥𑄴
      cy:𑄃𑄮𑄠𑄬𑄣𑄧𑄌𑄴
      da:𑄓𑄬𑄚𑄨𑄌𑄴
      dak:𑄓𑄇𑄮𑄑
      dar:𑄘𑄢𑄴𑄉𑄧𑄤
      dav:𑄖𑄳𑄆𑄖
      de:𑄎𑄢𑄴𑄟𑄚𑄴
      de-AT:𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠𑄚𑄴 𑄎𑄢𑄴𑄟𑄚𑄴
      de-CH:𑄥𑄪𑄃𑄨𑄌𑄴 𑄦𑄭 𑄎𑄢𑄴𑄟𑄚𑄴
      del:𑄓𑄬𑄣𑄤𑄬𑄢𑄴
      den:𑄥𑄳𑄣𑄳𑄠𑄞𑄴
      dgr:𑄘𑄮𑄉𑄳𑄢𑄨𑄝𑄴
      din:𑄓𑄨𑄁𑄇
      dje:𑄎𑄢𑄴𑄟
      doi:𑄓𑄮𑄉𑄧𑄢𑄨
      dsb:𑄙𑄮𑄣𑄴𑄚𑄬𑄭𑄙𑄳𑄠𑄬 𑄥𑄮𑄢𑄴𑄝𑄨𑄠𑄚𑄴
      dua:𑄘𑄱𑄣
      dum:𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄓𑄌𑄴
      dv:𑄘𑄨𑄝𑄬𑄦𑄨
      dyo:𑄎𑄧𑄣-𑄜𑄧𑄚𑄩
      dyu:𑄓𑄨𑄃𑄪𑄣
      dz:𑄎𑄮𑄋𑄴𑄉
      dzg:𑄘𑄉𑄎
      ebu:𑄃𑄬𑄟𑄳𑄝𑄪𑄪
      ee:𑄃𑄨𑄅𑄠𑄨
      efi:𑄆𑄜𑄨𑄇𑄴
      egy:𑄛𑄪𑄢𑄨𑄚𑄩 𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄧
      eka:𑄃𑄨𑄇𑄎𑄪𑄇𑄴
      el:𑄉𑄳𑄢𑄨𑄇𑄴
      elx:𑄆𑄣𑄟𑄭𑄖𑄴
      en:𑄃𑄨𑄁𑄢𑄨𑄎𑄨
      en-AU:𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨
      en-CA:𑄇𑄚𑄓𑄩𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨
      en-GB:𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄨
      en-GB-alt-short:𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄨
      en-US:𑄃𑄟𑄬𑄢𑄨𑄇𑄢𑄴 𑄃𑄨𑄁𑄢𑄎𑄨
      en-US-alt-short:𑄃𑄨𑄅𑄪𑄃𑄬𑄌𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄨
      enm:𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨
      eo:𑄆𑄥𑄴𑄛𑄬𑄢𑄚𑄴𑄖𑄮
      es:𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴
      es-419:𑄣𑄳𑄠𑄑𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇𑄚𑄴 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴
      es-ES:𑄄𑄅𑄢𑄮𑄛𑄩𑄠𑄧 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴
      es-MX:𑄟𑄳𑄠𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴
      et:𑄆𑄌𑄴𑄖𑄨𑄚𑄩𑄠𑄧
      eu:𑄝𑄌𑄴𑄇𑄧
      ewo:𑄄𑄃𑄮𑄚𑄴𑄓𑄮
      fa:𑄜𑄢𑄴𑄥𑄨
      fan:𑄜𑄳𑄠𑄋𑄴𑄉𑄧
      fat:𑄜𑄚𑄴𑄖𑄨
      ff:𑄜𑄪𑄣𑄳𑄦
      fi:𑄜𑄨𑄚𑄨𑄌𑄴
      fil:𑄜𑄨𑄣𑄨𑄛𑄨𑄚𑄮
      fj:𑄜𑄨𑄎𑄨𑄠𑄚𑄴
      fo:𑄜𑄢𑄮𑄌𑄴
      fon:𑄜𑄧𑄚𑄴
      fr:𑄜𑄧𑄢𑄥𑄨
      fr-CA:𑄇𑄚𑄓𑄩𑄠𑄧 𑄜𑄧𑄢𑄥𑄨
      fr-CH:𑄥𑄪𑄃𑄨𑄌𑄴 𑄜𑄧𑄢𑄥𑄨
      frm:𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄜𑄧𑄢𑄥𑄨
      fro:𑄛𑄪𑄢𑄮𑄚𑄨 𑄜𑄧𑄢𑄥𑄨
      frr:𑄅𑄖𑄴𑄗𑄧𑄢𑄴 𑄎𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄚𑄴
      frs:𑄛𑄪𑄉𑄮 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄧
      fur:𑄜𑄳𑄢𑄨𑄃𑄪𑄣𑄨𑄠𑄚𑄴
      fy:𑄛𑄧𑄎𑄨𑄟𑄴 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄚𑄴
      ga:𑄃𑄭𑄢𑄨𑄌𑄴
      gaa:𑄉𑄳𑄃
      gag:𑄉𑄉𑄃𑄪𑄌𑄴
      gan:𑄉𑄧𑄚𑄴
      gay:𑄉𑄧𑄠𑄮
      gba:𑄝𑄠
      gd:𑄃𑄨𑄌𑄴𑄇𑄧𑄖𑄴𑄥𑄧-𑄉𑄳𑄠𑄬𑄣𑄨𑄇𑄴
      gez:𑄉𑄩𑄎𑄴
      gil:𑄉𑄨𑄣𑄴𑄝𑄢𑄴𑄑𑄨𑄎𑄴
      gl:𑄉𑄳𑄠𑄣𑄨𑄥𑄨𑄠𑄧
      gmh:𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧-𑄅𑄪𑄉𑄪𑄢𑄬 𑄎𑄢𑄴𑄟𑄚𑄩
      gn:𑄉𑄪𑄠𑄢𑄚𑄨
      goh:𑄛𑄪𑄢𑄮𑄚𑄴 𑄅𑄪𑄉𑄪𑄢𑄬 𑄎𑄢𑄴𑄟𑄚𑄩
      gon:𑄉𑄮𑄚𑄴𑄓𑄨
      gor:𑄉𑄢𑄮𑄚𑄴𑄖𑄣𑄮
      got:𑄉𑄧𑄗𑄨𑄇𑄴
      grb:𑄉𑄳𑄢𑄬𑄝𑄮
      grc:𑄛𑄪𑄢𑄮𑄚𑄴 𑄉𑄳𑄢𑄩𑄇𑄴
      gsw:𑄥𑄪𑄃𑄨𑄌𑄴 𑄥𑄢𑄴𑄟𑄚𑄴
      gu:𑄉𑄪𑄎𑄴𑄢𑄖𑄨
      guz:𑄉𑄪𑄥𑄩
      gv:𑄟𑄳𑄠𑄇𑄴𑄥𑄧
      gwi:𑄉𑄧𑄃𑄮𑄃𑄨𑄌𑄴𑄃𑄨𑄚𑄴
      ha:𑄦𑄃𑄪𑄥
      hai:𑄦𑄭𑄓
      hak:𑄦𑄧𑄇𑄴
      haw:𑄦𑄤𑄃𑄨𑄠𑄚𑄴
      he:𑄦𑄨𑄛𑄴𑄝𑄳𑄢𑄪
      hi:𑄦𑄨𑄚𑄴𑄓𑄨
      hil:𑄦𑄨𑄣𑄨𑄉𑄳𑄠𑄠𑄧𑄚𑄮𑄚𑄴
      hit:𑄦𑄨𑄖𑄨𑄨𑄖𑄴
      hmn:𑄦𑄳𑄦𑄟𑄮𑄋𑄴
      ho:𑄦𑄪𑄢𑄨 𑄟𑄮𑄖𑄪
      hr:𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄩𑄠𑄧
      hsb:𑄅𑄪𑄉𑄪𑄢𑄬 𑄥𑄮𑄢𑄴𑄥𑄨𑄠𑄚𑄴
      hsn:Xiang 𑄌𑄨𑄚
      ht:𑄦𑄭𑄖𑄨𑄠𑄚𑄴
      hu:𑄦𑄁𑄉𑄬𑄢𑄩𑄠𑄧
      hup:𑄦𑄪𑄛
      hy:𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄧
      hz:𑄦𑄬𑄢𑄬𑄢𑄮
      ia:𑄃𑄨𑄚𑄴𑄑𑄢𑄴𑄣𑄨𑄁𑄉𑄪𑄠
      iba:𑄃𑄨𑄝𑄚𑄴
      ibb:𑄃𑄨𑄝𑄨𑄝𑄨𑄠𑄧
      id:𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠𑄧
      ie:𑄃𑄨𑄚𑄴𑄑𑄢𑄴𑄣𑄨𑄁𑄉𑄧
      ig:𑄃𑄨𑄉𑄴𑄝𑄮
      ii:𑄥𑄨𑄥𑄪𑄠𑄚𑄴𑄠𑄨
      ik:𑄃𑄨𑄚𑄪𑄛𑄨𑄠𑄇𑄴
      ilo:𑄃𑄨𑄣𑄮𑄇𑄮
      inh:𑄃𑄨𑄁𑄉𑄪𑄌𑄴
      io:𑄃𑄨𑄓𑄮
      is:𑄃𑄭𑄌𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄨𑄠𑄧
      it:𑄃𑄨𑄖𑄣𑄩𑄠𑄧
      iu:𑄃𑄨𑄚𑄪𑄇𑄴𑄑𑄨𑄑𑄪𑄖𑄴
      ja:𑄎𑄛𑄚𑄨
      jbo:𑄣𑄮𑄌𑄴𑄝𑄚𑄴
      jgo:𑄉𑄮𑄟𑄴𑄝
      jmc:𑄟𑄇𑄟𑄬
      jpr:𑄎𑄪𑄘𑄬𑄃𑄮 𑄜𑄢𑄴𑄥𑄨
      jrb:𑄎𑄪𑄘𑄬𑄃𑄮 𑄃𑄢𑄧𑄝𑄨
      jv:𑄎𑄞𑄚𑄨𑄎𑄴
      ka:𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴
      kaa:𑄇𑄢-𑄇𑄣𑄴𑄛𑄇𑄴
      kab:𑄇𑄝𑄭𑄣𑄬
      kac:𑄇𑄌𑄨𑄚𑄴
      kaj:𑄃𑄧𑄌𑄴𑄎𑄪
      kam:𑄇𑄟𑄴𑄝
      kaw:𑄇𑄃𑄪𑄃𑄨
      kbd:𑄇𑄝𑄢𑄴𑄓𑄨𑄠𑄚𑄴
      kcg:𑄑𑄃𑄨𑄠𑄛𑄴
      kde:𑄟𑄇𑄮𑄚𑄴𑄘𑄬
      kea:𑄇𑄝𑄪𑄞𑄢𑄴𑄘𑄨𑄠𑄚𑄪
      kfo:𑄇𑄮𑄢𑄮
      kg:𑄇𑄧𑄁𑄉𑄮
      kha:𑄈𑄥𑄨
      kho:𑄈𑄮𑄑𑄚𑄨𑄎𑄴
      khq:𑄇𑄮𑄠𑄧𑄢 𑄌𑄩𑄚𑄨
      ki:𑄇𑄨𑄇𑄪𑄠𑄪
      kj:𑄇𑄮𑄠𑄚𑄨𑄠𑄟
      kk:𑄇𑄎𑄇𑄴
      kkj:𑄇𑄇𑄮
      kl:𑄇𑄳𑄠𑄣𑄣𑄴𑄣𑄨𑄥𑄪𑄖𑄴
      kln:𑄇𑄣𑄬𑄚𑄴𑄎𑄨𑄚𑄴
      km:𑄈𑄧𑄟𑄬𑄢𑄴
      kmb:𑄇𑄨𑄟𑄴𑄝𑄪𑄚𑄴𑄘𑄪
      kn:𑄇𑄧𑄚𑄴𑄚𑄧𑄢𑄴
      ko:𑄇𑄮𑄢𑄨𑄠𑄚𑄴
      koi:𑄇𑄧𑄟𑄨-𑄛𑄢𑄧𑄟𑄨𑄃𑄇𑄴
      kok:𑄇𑄮𑄋𑄴𑄇𑄚𑄨
      kos:𑄇𑄮𑄥𑄳𑄢𑄭𑄚𑄴
      kpe:𑄇𑄴𑄛𑄬𑄣𑄳𑄣𑄬
      kr:𑄇𑄚𑄪𑄢𑄨
      krc:𑄇𑄢𑄴𑄌𑄮-𑄝𑄣𑄴𑄇𑄢𑄴
      krl:𑄇𑄢𑄬𑄣𑄨𑄠𑄚𑄴
      kru:𑄇𑄪𑄢𑄪𑄇𑄴
      ks:𑄇𑄌𑄴𑄟𑄨𑄢𑄨
      ksb:𑄥𑄟𑄴𑄝𑄣
      ksf:𑄝𑄜𑄨𑄠
      ksh:𑄇𑄣𑄴𑄥𑄧
      ku:𑄇𑄪𑄢𑄴𑄘𑄨𑄥𑄴
      kum:𑄇𑄪𑄟𑄨𑄇𑄴
      kut:𑄇𑄪𑄑𑄬𑄚𑄭
      kv:𑄇𑄮𑄟𑄨
      kw:𑄇𑄧𑄢𑄴𑄚𑄨𑄌𑄴
      ky:𑄇𑄨𑄢𑄴𑄉𑄨𑄌𑄴
      la:𑄣𑄑𑄨𑄚𑄴
      lad:𑄣𑄓𑄨𑄚𑄮
      lag:𑄣𑄋𑄴𑄉𑄨
      lah:𑄣𑄚𑄴𑄓
      lam:𑄣𑄟𑄴𑄝
      lb:𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄩𑄠𑄧
      lez:𑄣𑄬𑄎𑄴𑄊𑄨𑄠𑄚𑄴
      lg:𑄉𑄚𑄴𑄓
      li:𑄣𑄨𑄟𑄴𑄝𑄪𑄢𑄴𑄉𑄨𑄌𑄴
      lkt:𑄣𑄇𑄮𑄑
      ln:𑄣𑄨𑄋𑄴𑄉𑄣
      lo:𑄣𑄃𑄮
      lol:𑄟𑄮𑄋𑄴𑄉𑄮
      loz:𑄣𑄮𑄎𑄨
      lrc:𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄣𑄪𑄢𑄨
      lt:𑄣𑄨𑄗𑄪𑄠𑄬𑄚𑄩𑄠𑄧
      lu:𑄣𑄪𑄝-𑄇𑄑𑄋𑄴𑄉
      lua:𑄣𑄪𑄝-𑄣𑄪𑄣𑄪𑄠
      lui:𑄣𑄭𑄪𑄥𑄬𑄚𑄮
      lun:𑄣𑄪𑄚𑄴𑄓
      luo:𑄣𑄪𑄠𑄮
      lus:𑄟𑄨𑄎𑄮
      luy:𑄣𑄭𑄪𑄠
      lv:𑄣𑄖𑄴𑄞𑄩𑄠𑄧
      mad:𑄟𑄘𑄪𑄢𑄬𑄥𑄬
      mag:𑄟𑄉𑄦𑄨
      mai:𑄟𑄳𑄆𑄧𑄗𑄨𑄣𑄨
      mak:𑄟𑄳𑄠𑄇𑄥𑄢𑄴
      man:𑄟𑄳𑄠𑄚𑄴𑄓𑄨𑄁𑄉𑄮
      mas:𑄟𑄥𑄭
      mdf:𑄟𑄮𑄇𑄴𑄥
      mdr:𑄟𑄳𑄠𑄚𑄴𑄓𑄢𑄴
      men:𑄟𑄬𑄚𑄴𑄓𑄬
      mer:𑄟𑄬𑄢𑄪
      mfe:𑄟𑄢𑄨𑄥𑄨𑄠𑄚𑄴
      mg:𑄟𑄣𑄉𑄥𑄨
      mga:𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄭𑄢𑄨𑄌𑄴
      mgh:𑄟𑄈𑄪𑄠-𑄟𑄬𑄖𑄴𑄖𑄮
      mgo:𑄟𑄬𑄑
      mh:𑄟𑄢𑄴𑄥𑄣𑄨𑄎𑄴
      mi:𑄟𑄃𑄮𑄢𑄨
      mic:𑄟𑄨𑄇𑄟𑄳𑄠𑄇𑄴
      min:𑄟𑄨𑄚𑄋𑄴𑄇𑄝𑄃𑄪
      mk:𑄟𑄳𑄠𑄥𑄨𑄓𑄮𑄚𑄩𑄠𑄧
      ml:𑄟𑄣𑄠𑄣𑄟𑄴
      mn:𑄟𑄧𑄁𑄉𑄮𑄣𑄨𑄠𑄧
      mnc:𑄟𑄚𑄴𑄌𑄪
      mni:𑄟𑄚𑄨𑄛𑄪𑄢𑄩
      moh:𑄟𑄮𑄦𑄃𑄮𑄇𑄴
      mos:𑄟𑄧𑄥𑄨
      mr:𑄟𑄢𑄒𑄨
      ms:𑄟𑄣𑄧𑄠𑄴
      mt:𑄟𑄧𑄣𑄴𑄑𑄨𑄠𑄧
      mua:𑄟𑄪𑄘𑄋𑄴𑄉𑄧
      mul:𑄝𑄣𑄧𑄇𑄴𑄇𑄚𑄨 𑄞𑄌𑄴
      mus:𑄇𑄳𑄢𑄨𑄇𑄴
      mwl:𑄟𑄨𑄢𑄚𑄴𑄓𑄨𑄎𑄴
      mwr:𑄟𑄢𑄮𑄠𑄢𑄨
      my:𑄝𑄧𑄢𑄴𑄟𑄨
      myv:𑄆𑄢𑄧𑄎𑄨𑄠
      mzn:𑄟𑄎𑄚𑄴𑄘𑄬𑄢𑄚𑄨
      na:𑄚𑄃𑄪𑄢𑄪
      nan:𑄚𑄚𑄴
      nap:𑄚𑄬𑄠𑄛𑄮𑄣𑄨𑄑𑄚𑄴
      naq:𑄚𑄟
      nb:𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄨𑄠𑄚𑄴 𑄝𑄮𑄇𑄴𑄟𑄣𑄴
      nd:𑄅𑄖𑄴𑄖𑄧𑄢𑄴 𑄆𑄚𑄴𑄘𑄬𑄝𑄨𑄣𑄨
      nds:𑄖𑄧𑄣𑄬 𑄎𑄢𑄴𑄟𑄚𑄨
      nds-NL:𑄣𑄮𑄥𑄳𑄠𑄇𑄴𑄥𑄧𑄚𑄴
      ne:𑄚𑄬𑄛𑄣𑄨
      new:𑄚𑄬𑄃𑄮𑄠𑄢𑄨
      ng:𑄆𑄚𑄴𑄘𑄮𑄋𑄴𑄉
      nia:𑄚𑄨𑄠𑄌𑄴
      niu:𑄚𑄨𑄃𑄪𑄠𑄚𑄴
      nl:𑄓𑄌𑄴
      nl-BE:𑄜𑄳𑄣𑄬𑄟𑄨𑄌𑄴
      nmg:𑄇𑄱𑄥𑄨𑄃𑄮
      nn:𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄩𑄠𑄚𑄴 𑄚𑄨𑄚𑄧𑄢𑄴𑄥𑄳𑄇𑄴
      nnh:𑄚𑄨𑄋𑄴𑄉𑄬𑄟𑄴𑄝𑄪𑄚𑄴
      no:𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄩𑄠𑄧
      nog:𑄚𑄮𑄉𑄭
      non:𑄛𑄪𑄢𑄮𑄚𑄴 𑄚𑄧𑄢𑄴𑄥𑄧
      nqo:𑄆𑄚𑄴𑄇𑄮
      nr:𑄓𑄧𑄉𑄨𑄚𑄴 𑄆𑄚𑄴𑄓𑄬𑄝𑄬𑄣𑄬
      nso:𑄃𑄪𑄖𑄴𑄗𑄧𑄢𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄮𑄗𑄮
      nus:𑄚𑄪𑄠𑄢𑄴
      nv:𑄚𑄞𑄎𑄮
      nwc:𑄛𑄪𑄢𑄮𑄚𑄴 𑄚𑄬𑄃𑄮𑄠𑄢𑄩
      ny:𑄚𑄠𑄚𑄴𑄎
      nym:𑄚𑄳𑄠𑄠𑄟𑄴𑄃𑄮𑄠𑄬𑄎𑄨
      nyn:𑄚𑄳𑄠𑄠𑄋𑄴𑄇𑄮𑄣𑄬
      nyo:𑄚𑄧𑄱𑄢𑄮
      nzi:𑄆𑄚𑄴𑄎𑄨𑄟
      oc:𑄃𑄧𑄇𑄴𑄥𑄨𑄑𑄚𑄴
      oj:𑄃𑄮𑄎𑄨𑄝𑄧𑄤
      om:𑄃𑄧𑄢𑄮𑄟𑄮
      or:𑄃𑄮𑄢𑄨𑄠
      os:𑄃𑄮𑄥𑄬𑄑𑄨𑄇𑄴
      osa:𑄃𑄮𑄥𑄬𑄌𑄴
      ota:𑄃𑄧𑄑𑄮𑄟𑄚𑄴 𑄖𑄪𑄢𑄴𑄇𑄨
      pa:𑄛𑄚𑄴𑄎𑄝𑄩
      pag:𑄛𑄁𑄉𑄥𑄨𑄚𑄚𑄴
      pal:𑄛𑄦𑄳𑄣𑄞𑄨
      pam:𑄛𑄟𑄴𑄛𑄋𑄴𑄉
      pap:𑄛𑄛𑄨𑄠𑄟𑄬𑄚𑄴𑄖𑄮
      pau:𑄛𑄣𑄠𑄪𑄠𑄚𑄴
      pcm:𑄚𑄎𑄬𑄢𑄨𑄠𑄧 𑄛𑄨𑄎𑄨𑄚𑄴
      peo:𑄛𑄪𑄢𑄮𑄚𑄴 𑄜𑄢𑄴𑄥𑄨
      phn:𑄜𑄮𑄚𑄨𑄥𑄨𑄠𑄚𑄴
      pi:𑄛𑄣𑄨
      pl:𑄛𑄮𑄣𑄨𑄌𑄴
      pon:𑄛𑄮𑄚𑄴𑄦𑄧𑄛𑄳𑄆𑄬𑄠𑄚𑄴
      prg:𑄛𑄴𑄢𑄪𑄥𑄨𑄠𑄚𑄴
      pro:𑄛𑄪𑄢𑄮𑄚𑄴 𑄛𑄳𑄢𑄮𑄞𑄬𑄚𑄴𑄥𑄣𑄴
      ps:𑄛𑄌𑄴𑄑𑄪
      ps-alt-variant:𑄛𑄪𑄌𑄴𑄖𑄮
      pt:𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴
      pt-BR:𑄝𑄳𑄢𑄎𑄨𑄣𑄬𑄢𑄴 𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴
      pt-PT:𑄃𑄨𑄃𑄪𑄢𑄮𑄛𑄬𑄢𑄴 𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴
      qu:𑄇𑄬𑄌𑄪𑄠
      quc:𑄇𑄳𑄦𑄨𑄌𑄬
      raj:𑄢𑄎𑄴𑄥𑄳𑄦𑄚𑄨
      rap:𑄢𑄛𑄚𑄳𑄆𑄪
      rar:𑄢𑄢𑄮𑄑𑄮𑄁𑄉𑄚𑄴
      rm:𑄢𑄮𑄟𑄚𑄴𑄥𑄴
      rn:𑄢𑄪𑄚𑄴𑄘𑄨
      ro:𑄢𑄮𑄟𑄚𑄩𑄠𑄧
      ro-MD:𑄟𑄧𑄣𑄴𑄘𑄞𑄨𑄠𑄧
      rof:𑄢𑄧𑄟𑄴𑄝𑄮
      rom:𑄢𑄮𑄟𑄚𑄨
      ru:𑄢𑄪𑄌𑄴
      rup:𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄚𑄴
      rw:𑄇𑄨𑄚𑄴𑄠𑄢𑄮𑄠𑄚𑄴𑄓
      rwk:𑄢𑄤
      sa:𑄥𑄧𑄁𑄥𑄴𑄇𑄳𑄢𑄨𑄖𑄴
      sad:𑄥𑄳𑄠𑄚𑄴𑄓𑄃𑄮𑄠𑄬
      sah:𑄥𑄈
      sam:𑄥𑄟𑄢𑄨𑄑𑄚𑄴 𑄃𑄢𑄟𑄨𑄇𑄴
      saq:𑄥𑄟𑄴𑄝𑄪𑄢𑄪
      sas:𑄥𑄥𑄇𑄴
      sat:𑄥𑄀𑄃𑄮𑄖𑄣𑄨
      sba:𑄚𑄳𑄠𑄉𑄟𑄴𑄝𑄬
      sbp:𑄥𑄁𑄚𑄴𑄉𑄪
      sc:𑄥𑄢𑄴𑄓𑄨𑄚𑄨𑄠𑄚𑄴
      scn:𑄥𑄨𑄥𑄨𑄣𑄨𑄠𑄚𑄴
      sco:𑄆𑄌𑄴𑄇𑄧𑄖𑄴𑄥𑄴
      sd:𑄥𑄨𑄚𑄴𑄙𑄨
      sdh:𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴
      se:𑄅𑄖𑄴𑄖𑄧𑄢𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄟𑄨
      seh:𑄥𑄬𑄚
      sel:𑄥𑄬𑄣𑄴𑄇𑄪𑄛𑄴
      ses:𑄇𑄱𑄢𑄝𑄬𑄚𑄮 𑄥𑄬𑄚𑄳𑄚𑄨
      sg:𑄥𑄋𑄴𑄉𑄮
      sga:𑄛𑄪𑄢𑄮𑄚𑄴 𑄃𑄭𑄢𑄨𑄌𑄴
      sh:𑄥𑄢𑄴𑄝𑄮-𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠𑄧
      shi:𑄖𑄌𑄬𑄣𑄴𑄦𑄨𑄖𑄴
      shn:𑄥𑄚𑄴
      si:𑄥𑄨𑄁𑄦𑄧𑄣𑄩
      sid:𑄥𑄨𑄓𑄟𑄮
      sk:𑄥𑄳𑄣𑄮𑄞𑄇𑄴
      sl:𑄥𑄳𑄣𑄮𑄞𑄬𑄚𑄩𑄠𑄧
      sm:𑄥𑄟𑄮𑄠𑄚𑄴
      sma:𑄘𑄧𑄉𑄨𑄚𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄟𑄨
      smj:𑄣𑄪𑄣𑄬 𑄥𑄟𑄨
      smn:𑄃𑄨𑄚𑄢𑄨 𑄥𑄟𑄨
      sms:𑄥𑄳𑄇𑄧𑄣𑄳𑄑𑄧 𑄥𑄟𑄨
      sn:𑄥𑄮𑄚
      snk:𑄥𑄮𑄚𑄨𑄋𑄴𑄇𑄬
      so:𑄥𑄮𑄟𑄣𑄨
      sog:𑄥𑄮𑄇𑄴𑄓𑄠𑄚𑄴
      sq:𑄃𑄣𑄴𑄝𑄬𑄚𑄩𑄠𑄧
      sr:𑄥𑄢𑄴𑄝𑄩𑄠𑄧
      srn:𑄥𑄳𑄢𑄚𑄚𑄴 𑄑𑄮𑄋𑄴𑄉𑄮
      srr:𑄥𑄬𑄢𑄬𑄢𑄴
      ss:𑄥𑄮𑄠𑄖𑄨
      ssy:𑄥𑄦𑄮
      st:𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄮𑄗𑄮
      su:𑄥𑄪𑄘𑄚𑄩
      suk:𑄥𑄪𑄇𑄪𑄟
      sus:𑄥𑄪𑄥𑄪
      sux:𑄥𑄪𑄟𑄬𑄢𑄩𑄠𑄧
      sv:𑄥𑄭𑄪𑄓𑄨𑄥𑄴
      sw:𑄥𑄱𑄦𑄨𑄣𑄨
      sw-CD:𑄇𑄧𑄋𑄴𑄉𑄮 𑄥𑄱𑄦𑄨𑄣𑄨
      swb:𑄇𑄧𑄟𑄮𑄢𑄨𑄠𑄚𑄴
      syc:𑄛𑄪𑄢𑄮𑄚𑄴 𑄥𑄨𑄢𑄨𑄃𑄮
      syr:𑄥𑄨𑄢𑄨𑄠𑄇𑄴
      ta:𑄖𑄟𑄨𑄣𑄴
      te:𑄖𑄬𑄣𑄬𑄉𑄪
      tem:𑄑𑄭𑄟𑄴𑄚𑄬
      teo:𑄖𑄬𑄥𑄮
      ter:𑄖𑄬𑄢𑄬𑄚𑄮
      tet:𑄖𑄬𑄖𑄪𑄟𑄴
      tg:𑄖𑄎𑄨𑄇𑄴
      th:𑄗𑄭
      ti:𑄖𑄨𑄉𑄧𑄢𑄨𑄚𑄨𑄠
      tig:𑄑𑄭𑄉𑄳𑄢𑄬
      tiv:𑄑𑄨𑄞𑄴
      tk:𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨
      tkl:𑄑𑄮𑄇𑄬𑄣𑄃𑄪
      tl:𑄖𑄉𑄣𑄧𑄇𑄴
      tlh:𑄇𑄳𑄣𑄨𑄋𑄴𑄉𑄧𑄚𑄴
      tli:𑄖𑄴𑄣𑄨𑄋𑄴𑄉𑄨𑄖𑄴
      tmh:𑄖𑄟𑄥𑄬𑄇𑄴
      tn:𑄥𑄱𑄚
      to:𑄑𑄮𑄋𑄴𑄉𑄚𑄴
      tog:𑄚𑄠𑄥𑄑𑄮𑄋𑄴𑄉
      tpi:𑄑𑄮𑄇𑄴 𑄛𑄨𑄥𑄨𑄚𑄴
      tr:𑄖𑄪𑄢𑄴𑄇𑄩
      trv:𑄖𑄢𑄮𑄇𑄮
      ts:𑄥𑄧𑄋𑄴𑄉
      tsi:𑄥𑄨𑄟𑄴𑄥𑄨𑄠𑄚𑄴
      tt:𑄖𑄖𑄢𑄴
      tum:𑄖𑄪𑄟𑄴𑄝𑄪𑄇
      tvl:𑄑𑄪𑄞𑄣𑄪
      tw:𑄑𑄮𑄠𑄭
      twq:𑄖𑄥𑄤𑄇𑄴
      ty:𑄖𑄦𑄨𑄖𑄨𑄠𑄚𑄴
      tyv:𑄑𑄪𑄞𑄨𑄚𑄨𑄠𑄚𑄴
      tzm:𑄥𑄬𑄚𑄴𑄑𑄳𑄢𑄣𑄴 𑄃𑄣𑄴𑄖𑄌𑄴 𑄖𑄟𑄎𑄨𑄉𑄖𑄴
      udm:𑄃𑄪𑄓𑄴𑄟𑄪𑄢𑄴𑄑𑄧
      ug:𑄃𑄪𑄃𑄨𑄊𑄪𑄢𑄴
      uga:𑄃𑄪𑄉𑄢𑄨𑄑𑄨𑄇𑄴
      uk:𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄬𑄚𑄩𑄠𑄧
      umb:𑄃𑄪𑄟𑄴𑄝𑄪𑄚𑄴𑄘𑄪
      und:𑄦𑄧𑄝𑄧𑄢𑄴 𑄚𑄧𑄛𑄬𑄠𑄬 𑄞𑄌𑄴
      ur:𑄃𑄪𑄢𑄴𑄘𑄪
      uz:𑄃𑄪𑄎𑄴𑄝𑄬𑄇𑄩𑄠𑄧
      vai:𑄞𑄭
      ve:𑄞𑄬𑄚𑄴𑄓
      vi:𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄩
      vo:𑄞𑄮𑄣𑄛𑄪𑄇𑄴
      vot:𑄞𑄮𑄑𑄨𑄇𑄴
      vun:𑄞𑄪𑄚𑄴𑄏𑄮
      wa:𑄤𑄣𑄪𑄚𑄴
      wae:𑄤𑄣𑄧𑄥𑄬𑄢𑄴
      wal:𑄤𑄣𑄟𑄮
      war:𑄤𑄢𑄬
      was:𑄤𑄥𑄮
      wbp:𑄤𑄢𑄴𑄣𑄴𑄛𑄨𑄢𑄨
      wo:𑄤𑄃𑄮𑄣𑄮𑄜𑄴
      wuu:𑄤𑄌𑄨𑄚
      xal:𑄇𑄣𑄴𑄟𑄳𑄆𑄧𑄇𑄴
      xh:𑄎𑄮𑄥
      xog:𑄥𑄮𑄉
      yao:𑄃𑄨𑄠𑄃𑄮
      yap:𑄃𑄨𑄠𑄛𑄬𑄥𑄬
      yav:𑄠𑄋𑄴𑄉𑄧𑄝𑄬𑄚𑄴
      ybb:𑄠𑄮𑄟𑄴𑄝
      yi:𑄠𑄨𑄖𑄴𑄘𑄨𑄥𑄴
      yo:𑄃𑄨𑄃𑄮𑄢𑄪𑄝
      yue:𑄇𑄳𑄠𑄚𑄴𑄑𑄮𑄚𑄩𑄎𑄴
      yue-alt-menu:𑄇𑄳𑄠𑄚𑄴𑄑𑄮𑄚𑄩𑄎𑄴
      za:𑄏𑄪𑄠𑄋𑄴
      zap:𑄎𑄛𑄮𑄑𑄬𑄇𑄴
      zbl:𑄃𑄉𑄬𑄠 𑄞𑄌𑄴
      zen:𑄎𑄬𑄚𑄉
      zgh:𑄉𑄧𑄟𑄴𑄘𑄮𑄣𑄴 𑄟𑄧𑄢𑄧𑄇𑄧𑄧𑄱𑄚𑄴𑄖𑄟𑄎𑄨𑄉𑄖𑄴
      zh:𑄌𑄩𑄚
      zh-alt-menu:𑄌𑄩𑄚
      zh-Hans:𑄅𑄪𑄎𑄪𑄅𑄪𑄏𑄫 𑄌𑄩𑄚
      zh-Hans-alt-long:𑄅𑄪𑄎𑄪𑄅𑄪𑄏𑄫 𑄌𑄩𑄚
      zh-Hant:𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄌𑄩𑄚
      zh-Hant-alt-long:𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄌𑄩𑄚
      zu:𑄎𑄪𑄣𑄪
      zun:𑄎𑄪𑄚𑄨
      zxx:𑄞𑄏𑄧𑄢𑄴𑄘𑄮𑄇𑄳𑄠𑄬 𑄝𑄨𑄥𑄧𑄠𑄴 𑄚𑄳𑄄𑄬
      zza:𑄎𑄎
      """.trimIndent() }

  val ccp_IN: String? = null

  val ce: String by lazy { """
      aa:афарийн
      ab:абхазхойн
      ace:ачехийн
      ada:адангме
      ady:адигейн
      af:африкаанс
      agq:агхӀем
      ain:айнийн
      ak:акан
      ale:алеутийн
      alt:къилба алтайн
      am:амхаройн
      an:арагонойн
      anp:ангика
      ar:Ӏаьрбийн
      ar-001:ХӀинца болу стандартан Ӏаьрбийн
      arn:арауканхойн
      arp:арапахо
      as:ассамийн
      asa:асу
      ast:астурийн
      av:суьйлийн
      awa:авадхи
      ay:аймара
      az:азербайджанийн
      az-alt-short:азербайджанийн
      ba:башкирийн
      ban:балийн
      bas:баса
      be:белорусийн
      bem:бемба
      bez:бена
      bg:болгарийн
      bgn:малхбузен-белуджийн
      bho:бходжпури
      bi:бислама
      bin:бини
      bla:сиксика
      bm:бамбара
      bn:бенгалийн
      bo:тибетхойн
      br:бретонийн
      brx:бодо
      bs:боснийн
      bug:бугийн
      byn:билийн
      ca:каталонийн
      ce:нохчийн
      ceb:себуано
      cgg:чига
      ch:чаморро
      chk:чукчийн
      chm:марийн
      cho:чоктавийн
      chr:чероки
      chy:шайенийн
      ckb:юккъерчу курдийн
      ckb-alt-menu:юккъерчу курдийн
      ckb-alt-variant:юккъерчу курдийн
      co:корсиканийн
      crs:сейшелийн креолийн
      cs:чехийн
      cu:килсславянийн
      cv:чувашийн
      cy:валлийн
      da:датхойн
      dak:дакота
      dar:даьргӀойн
      dav:таита
      de:немцойн
      de-AT:австрин немцойн
      de-CH:швейцарин литературин немцойн
      dgr:догриб
      dje:зарма
      dsb:сорбийн
      dua:дуала
      dv:мальдивийн
      dyo:дьола-фоньи
      dz:дзонг-кэ
      dzg:даза
      ebu:эмбу
      ee:эве
      efi:эфик
      eka:экаджук
      el:грекийн
      en:ингалсан
      en-AU:Австралин ингалсан
      en-CA:канадан ингалсан
      en-GB:британин ингалсан
      en-GB-alt-short:ингалсан (Британи)
      en-US:американ ингалсан
      en-US-alt-short:ингалсан (АЦШ)
      eo:эсперанто
      es:испанхойн
      es-419:латинан американ испанхойн
      es-ES:европан испанхойн
      es-MX:мексикан испанхойн
      et:эстонийн
      eu:баскийн
      ewo:эвондо
      fa:гӀажарийн
      ff:фулах
      fi:финнийн
      fil:филиппинийн
      fj:фиджи
      fo:фарерийн
      fon:фон
      fr:французийн
      fr-CA:канадан французийн
      fr-CH:швейцарин французийн
      fur:фриулийн
      fy:малхбузен-фризийн
      ga:ирландхойн
      gaa:га
      gag:гагаузийн
      gd:гэлийн
      gez:геэз
      gil:гильбертийн
      gl:галисийн
      gn:гуарани
      gor:горонтало
      gsw:швейцарин немцойн
      gu:гуджарати
      guz:гусии
      gv:мэнийн
      gwi:гвичин
      ha:хауса
      haw:гавайн
      he:жугтийн
      hi:хӀинди
      hil:хилигайнон
      hmn:хмонг
      hr:хорватийн
      hsb:лакхара сербийн
      ht:гаитийн
      hu:венгрийн
      hup:хупа
      hy:эрмалойн
      hz:гереро
      ia:интерлингва
      iba:ибанийн
      ibb:ибибио
      id:индонезихойн
      ig:игбо
      ii:сычуань
      ilo:илоко
      inh:гӀалгӀайн
      io:идо
      is:исландхойн
      it:итальянийн
      iu:инуктитут
      ja:японийн
      jbo:ложбан
      jgo:нгомба
      jmc:мачаме
      jv:яванийн
      ka:гуьржийн
      kab:кабилийн
      kac:качинийн
      kaj:каджи
      kam:камба
      kbd:гӀебартойн
      kcg:тьяп
      kde:маконде
      kea:кабувердьяну
      kfo:коро
      kha:кхаси
      khq:койра чиини
      ki:кикуйю
      kj:кунама
      kk:кхазакхийн
      kkj:како
      kl:гренландхойн
      kln:календжин
      km:кхмерийн
      kmb:кимбунду
      kn:каннада
      ko:корейн
      koi:коми-пермякийн
      kok:конкани
      kpe:кпелле
      kr:канури
      krc:кхарачойн-балкхаройн
      krl:карелийн
      kru:курух
      ks:кашмири
      ksb:шамбала
      ksf:бафиа
      ksh:коьлнийн
      ku:курдийн
      kum:гӀумкийн
      kv:комийн
      kw:корнуоллийн
      ky:гӀиргӀизойн
      la:латинан
      lad:ладино
      lag:ланги
      lb:люксембургхойн
      lez:лаьзгийн
      lg:ганда
      li:лимбургийн
      lkt:лакота
      ln:лингала
      lo:лаоссийн
      loz:лози
      lrc:къилбаседа лури
      lt:литвахойн
      lu:луба-катанга
      lua:луба-лулуа
      lun:лунда
      luo:луо (Кени а, Танзани а)
      lus:лушей
      luy:лухья
      lv:латышийн
      mad:мадурийн
      mag:магахи
      mai:майтхили
      mak:макасарийн
      mas:масаи
      mdf:мокшанойн
      men:менде
      mer:меру
      mfe:маврикин креолийн
      mg:малагасийн
      mgh:макуа-меетто
      mgo:мета
      mh:маршаллийн
      mi:маори
      mic:микмак
      min:минангкабау
      mk:македонхойн
      ml:малаялам
      mn:монголийн
      mni:манипурийн
      moh:мохаук
      mos:моси
      mr:маратхи
      ms:малайн
      mt:мальтойн
      mua:мунданг
      mul:тайп-тайпа доьзалан меттанаш
      mus:крик
      mwl:мирандойн
      my:бирманийн
      myv:эрзянийн
      mzn:мазандеранхойн
      na:науру
      nap:неаполитанойн
      naq:нама
      nb:норвегийн букмол
      nd:къилбаседа ндебели
      nds:лахара германхойн
      nds-NL:лахара саксонийн
      ne:непалхойн
      new:неваройн
      ng:ндонга
      nia:ниас
      niu:ниуэ
      nl:голландхойн
      nl-BE:фламандийн
      nmg:квасио
      nn:норвегийн нюнорск
      nnh:нгиембунд
      nog:ногӀийн
      nqo:нко
      nr:къилба ндебеле
      nso:къилбаседа сото
      nus:нуэр
      nv:навахо
      ny:ньянджа
      nyn:ньянколе
      oc:окситанойн
      om:оромо
      or:ори
      os:хӀирийн
      pa:панджаби
      pag:пангасинан
      pam:пампанга
      pap:папьяменто
      pau:палау
      pcm:нигерийн-креолийн
      pl:полякийн
      prg:пруссийн
      ps:пушту
      pt:португалихойн
      pt-BR:бразилин португалихойн
      pt-PT:европан португалихойн
      qu:кечуа
      quc:киче
      rap:рапануйн
      rar:раротонга
      rm:романшийн
      rn:рунди
      ro:румынийн
      ro-MD:молдавийн
      rof:ромбо
      ru:оьрсийн
      rup:аруминийн
      rw:киньяруанда
      rwk:руанда
      sa:санскрит
      sad:сандаве
      sah:якутийн
      saq:самбуру
      sat:сантали
      sba:нгамбайн
      sbp:сангу
      sc:сардинийн
      scn:сицилийн
      sco:шотландхойн
      sd:синдхи
      se:къилбаседа саамийн
      seh:сена
      ses:койраборо сенни
      sg:санго
      shi:тахелхит
      shn:шанойн
      si:сингалхойн
      sk:словакийн
      sl:словенийн
      sm:самоанойн
      sma:саамийн (къилба)
      smj:луле-саамийн
      smn:инари-саамийн
      sms:скольт-саамийн
      sn:шона
      snk:сонинке
      so:сомали
      sq:албанойн
      sr:сербийн
      srn:сранан-тонго
      ss:свази
      ssy:сахо
      st:къилба сото
      su:сунданхойн
      suk:сукума
      sv:шведийн
      sw:суахили
      sw-CD:суахили (Конго)
      swb:коморийн
      syr:шемахойн
      ta:тамилхойн
      te:телугу
      tem:темне
      teo:тесо
      tet:тетум
      tg:таджикийн
      th:тайн
      ti:тигринья
      tig:тигре
      tk:туркменийн
      tlh:клингонин
      tn:тсвана
      to:тонганийн
      tpi:ток-писин
      tr:туркойн
      trv:седекойн
      ts:тсонга
      tt:гӀезалойн
      tum:тумбука
      tvl:тувалу
      twq:тасавак
      ty:таитянойн
      tyv:тувинийн
      tzm:тамазигхтийн
      udm:удмуртийн
      ug:уйгурийн
      uk:украинийн
      umb:умбунду
      und:боьвзуш боцу мотт
      ur:урду
      uz:узбекийн
      vai:ваи
      ve:венда
      vi:вьетнамхойн
      vo:волапюк
      vun:вунджо
      wa:валлонойн
      wae:валлисийн
      wal:воламо
      war:варай
      wbp:варлпири
      wo:волоф
      xal:гӀалмакхойн
      xh:коса
      xog:сога
      yav:янгбен
      ybb:йемба
      yi:идиш
      yo:йоруба
      yue:кантонийн
      yue-alt-menu:кантонийн
      zgh:мороккон стандартан тамазигхтийн
      zh:цийн
      zh-alt-menu:цийн
      zh-Hans:атта цийн
      zh-Hans-alt-long:атта цийн
      zh-Hant:ламастан цийн
      zh-Hant-alt-long:ламастан цийн
      zu:зулу
      zun:зуньи
      zxx:меттан чулацам боцуш
      zza:заза
      """.trimIndent() }

  val ceb: String by lazy { """
      ar:Arabic
      ar-001:Modernong Standard nga Arabic
      bn:Bangla
      ceb:Cebuano
      de:German
      de-CH:Swiss High German
      en:English
      en-GB:Britanikong English
      en-GB-alt-short:English (UK)
      en-US:English (America)
      en-US-alt-short:English (US)
      es:Espanyol
      es-ES:Espanyol (Europa)
      fr:Pranses
      hi:Hindi
      hi-Latn-alt-variant:Hinglish
      id:Indonesian
      it:Italyano
      ja:Hinapon
      ko:Korean
      nl:Dutch
      nl-BE:Flemish
      pl:Polish
      pt:Portuguese
      ru:Russian
      th:Thai
      tr:Turkish
      und:Wala Mailhing Pinulongan
      zh:Inintsik
      zh-alt-menu:Chinese, Mandarin
      zh-Hans:Pinasimple nga Chinese
      zh-Hans-alt-long:Pinasimple nga Mandarin Chinese
      zh-Hant:Tradisyonal nga Chinese
      zh-Hant-alt-long:Tradisyonal nga Mandarin Chinese
      """.trimIndent() }

  val cgg: String by lazy { """
      ak:Orukani
      am:Orumariki
      ar:Oruharabu
      be:Oruberarusi
      bg:Oruburugariya
      bn:Orubengari
      cgg:Rukiga
      cs:Oruceeki
      de:Orugirimaani
      el:Oruguriiki
      en:Orungyereza
      es:Orusupaani
      fa:Orupaasiya
      fr:Orufaransa
      ha:Oruhausa
      hi:Oruhindi
      hu:Oruhangare
      id:Oruindonezia
      ig:Oruibo
      it:Oruyitare
      ja:Orujapaani
      jv:Orujava
      km:Orukambodiya
      ko:Orukoreya
      ms:Orumalesiya
      my:Oruburuma
      ne:Orunepali
      nl:Orudaaki
      pa:Orupungyabi
      pl:Orupoori
      pt:Orupocugo
      ro:Oruromania
      ru:Orurrasha
      rw:Orunyarwanda
      so:Orusomaari
      sv:Oruswidi
      ta:Orutamiri
      th:Orutailandi
      tr:Orukuruki
      uk:Orukuraini
      ur:Oru-Urudu
      vi:Oruviyetinaamu
      yo:Oruyoruba
      zh:Oruchaina
      zh-alt-menu:Oruchaina
      zu:Oruzuru
      """.trimIndent() }

  val cho: String by lazy { """
      cho:Chahta
      en:English
      """.trimIndent() }

  val chr: String by lazy { """
      aa:ᎠᏩᎳ
      ab:ᎠᏆᏏᎠᏂ
      ace:ᎠᏥᏂᏏ
      ada:ᎠᏓᎾᎦᎺ
      ady:ᎠᏗᎨ
      af:ᎠᎬᎿᎨᏍᏛ
      agq:ᎠᎨᎹ
      ain:ᎠᏱᏄ
      ak:ᎠᎧᎾ
      ale:ᎠᎵᎤᏘ
      alt:ᏧᎦᎾᏮ ᏗᏜ ᎠᎵᏔᎢ
      am:ᎠᎹᎭᎵᎩ
      an:ᎠᏩᎪᏂᏏ
      ann:ᎣᏉᎶ
      anp:ᎠᎾᎩᎧ
      ar:ᎡᎳᏈ
      ar-001:ᎪᎯᏊ ᎢᎬᏥᎩ ᎠᏟᎶᏍᏗ ᎡᎳᏈ
      arn:ᎹᏊᏤ
      arp:ᎠᏩᏈᎰ
      ars:ᎾᏣᏗ ᎠᎳᏈ
      as:ᎠᏌᎻᏏ
      asa:ᎠᏑ
      ast:ᎠᏍᏚᎵᎠᏂ
      atj:ᎠᏂᏘᎧᎺᏆ
      av:ᎠᏩᎵᎧ
      awa:ᎠᏩᏗ
      ay:ᎠᏱᎹᎳ
      az:ᎠᏎᏆᏣᏂ
      az-alt-short:ᎠᏎᎵ
      ba:ᏆᏍᎯᎩᎠ
      ban:ᏆᎵᏁᏏ
      bas:ᏆᏌᎠ
      be:ᏇᎳᎷᏏ
      bem:ᏇᎹᏆ
      bez:ᏇᎾ
      bg:ᏊᎵᎨᎵᎠᏂ
      bgc:ᎭᏯᏅᎢ
      bho:ᏉᏣᏊᎵ
      bi:ᏈᏍᎳᎹ
      bin:ᏈᏂ
      bla:ᏏᎩᏏᎧ
      blo:ᎠᏂᎵ
      bm:ᏆᎻᏆᎳ
      bn:ᏇᏂᎦᎳ
      bo:ᏘᏇᏔᏂ
      br:ᏇᏙᏂ
      brx:ᏉᏙ
      bs:ᏆᏍᏂᎠᏂ
      bug:ᏈᎥᎩᏂᏍ
      byn:ᏟᏂ
      ca:ᎨᏔᎳᏂ
      cay:ᎧᏳᎦ
      ccp:ᏣᎧᎹ
      ce:ᏤᏤᏂ
      ceb:ᏎᏆᏃ
      cgg:ᏥᎦ
      ch:ᏣᎼᎶ
      chk:ᏧᎨᏎ
      chm:ᎹᎵ
      cho:ᎠᏣᏓ
      chp:ᎠᏥᏇᏯᏂ
      chr:ᏣᎳᎩ
      chy:ᏣᏰᏂ
      ckb:ᎠᏰᏟ ᎫᏗᏏ
      ckb-alt-menu:ᎠᏰᏟ ᎫᏗᏏ
      ckb-alt-variant:ᎠᏰᏟ ᎫᏗᏏ
      clc:ᏥᎸᎪᏘᎾ
      co:ᎪᎵᏍᎢᎧᏂ
      crg:ᎻᏥᏩ
      crj:ᏧᎦᏃᏮ ᏗᎧᎸᎬ Ꮯ
      crk:ᏠᎨᏏ Ꮯ
      crl:ᏧᏴᏢ ᏗᎧᎸᎬ Ꮯ
      crm:ᎠᏫ ᎡᏆ Ꮯ
      crr:ᎠᎵᎦᏂᏈᎠᎾ
      crs:ᏎᏎᎵᏩ ᏟᏲᎵ ᎠᏂᎦᎸ
      cs:ᏤᎩ
      csw:ᏌᎷᏱ Ꮯ
      cu:ᏧᏂᎳᏫᏍᏗ ᏍᎳᏫᎪ
      cv:ᏧᏩᏏ
      cy:ᏪᎵᏏ
      da:ᏕᏂᏍ
      dak:ᏓᎪᏔ
      dar:ᏓᎳᏆ
      dav:ᏔᎢᏔ
      de:ᏙᎢᏥ
      de-AT:ᎠᏟᏯᏂ ᎠᏂᏓᏥ
      de-CH:ᏍᏫᏏ ᎦᎸᎳᏗ ᎠᏂᏓᏥ
      dgr:ᎩᏟ ᎤᏄᎳᏥ
      dje:ᏌᎹ
      doi:ᏙᎦᎵ
      dsb:ᎡᎳᏗ ᏐᏈᎠᏂ
      dua:ᏚᎠᎳ
      dv:ᏗᏪᎯ
      dyo:ᏦᎳ-ᏬᏱ
      dz:ᏓᏐᏅᎧ
      dzg:ᏓᏌᎦ
      ebu:ᎡᎻᏊ
      ee:ᎡᏪ
      efi:ᎡᏫᎩ
      eka:ᎨᎧᏧᎧ
      el:ᎠᏂᎪᎢ
      en:ᎩᎵᏏ
      en-AU:ᎡᎳᏗᏜ ᎩᎵᏏ
      en-CA:ᎨᎾᏓ ᎩᎵᏏ
      en-GB:ᎩᎵᏏᏲ ᎩᎵᏏ
      en-GB-alt-short:UK ᎩᎵᏏ
      en-US:ᎠᎹᏰᏟ ᎩᎵᏏ
      en-US-alt-short:US ᎩᎵᏏ
      eo:ᎡᏍᏇᎳᏂᏙ
      es:ᏍᏆᏂ
      es-419:ᏔᏘᏂ ᎠᎹᏰᏟ ᏍᏆᏂ
      es-ES:ᎠᏂᏍᏆᏂᏱ ᏍᏆᏂ
      es-MX:ᏍᏆᏂᏱ ᏍᏆᏂ
      et:ᎡᏍᏙᏂᎠᏂ
      eu:ᏆᏍᎨ
      ewo:ᎡᏬᏂᏙ
      fa:ᏇᏏᎠᏂ
      fa-AF:ᏓᎵ
      ff:ᏊᎳᏂ
      fi:ᏈᏂᏍ
      fil:ᎠᏈᎵᎩ
      fj:ᏫᏥᎠᏂ
      fo:ᏇᎶᎡᏍ
      fon:ᏠᏂ
      fr:ᎦᎸᏥ
      fr-CA:ᎨᎾᏓ ᎦᎸᏥ
      fr-CH:ᏍᏫᏏ ᎦᎸᏥ
      frc:ᎨᏨᏂ ᎦᎸᏥ
      frr:ᏧᏴᏢ ᎷᏈ
      fur:ᏞᎤᎵᎠᏂ
      fy:ᏭᏕᎵᎬ ᏗᏜ ᏟᏏᎠᏂ
      ga:ᎨᎵᎩ
      gaa:Ꭶ
      gd:ᏍᎦᏗ ᎨᎵᎩ
      gez:ᎩᏏ
      gil:ᎩᏇᏘᏏ
      gl:ᎦᎵᏏᎠᏂ
      gn:ᏆᎳᏂ
      gor:ᎪᎶᏂᏔᏃ
      gsw:ᏍᏫᏏ ᎠᏂᏓᏥ
      gu:ᎫᏣᎳᏘ
      guz:ᎫᏏ
      gv:ᎹᎾᎧᏏ
      gwi:ᏈᏥᏂ
      ha:ᎭᎤᏌ
      hai:ᎭᏱᏓ
      haw:ᎭᏩᎼ
      hax:ᏧᎦᏃᏮ ᏗᏜ ᎭᏱᏓ
      he:ᎠᏂᏈᎷ
      hi:ᎯᏂᏗ
      hi-Latn-alt-variant:ᎯᏂᏲᏁᎦ
      hil:ᎯᎵᎨᎾᏂ
      hmn:ᎭᎼᏂᎩ
      hr:ᎧᎶᎡᏏᏂ
      hsb:ᎦᎸᎳᏗᎨ ᏐᏈᎠᏂ
      ht:ᎮᏏᎠᏂ ᏟᏲᎵ
      hu:ᎲᏂᎦᎵᎠᏂ
      hup:ᎠᏂᎱᏆ
      hur:ᎭᎵᎪᎺᎴᎻ
      hy:ᎠᎳᎻᎠᏂ
      hz:ᎮᎴᎶ
      ia:ᎠᏰᏟ ᎦᏬᏂᎯᏍᏗ
      iba:ᎢᏆᏂ
      ibb:ᎢᏈᏈᎣ
      id:ᎢᏂᏙᏂᏏᎠ
      ie:ᏈᏖᎵᏆ
      ig:ᎢᎦᎪ
      ii:ᏏᏧᏩᏂ Ᏹ
      ikt:ᏭᏕᎵᎬ ᎨᎾᏓ ᎢᏄᎩᏘᏚᏘ
      ilo:ᎢᎶᎪ
      inh:ᎢᏂᎫᏏ
      io:ᎢᏙ
      is:ᏧᏁᏍᏓᎸᎯᎢᎩ
      it:ᎬᏩᎵᏲᏥᎢ
      iu:ᎢᏄᎦᏘᏚ
      ja:ᏣᏩᏂᏏ
      jbo:ᎶᏣᏆᏂ
      jgo:ᎾᎪᏆ
      jmc:ᎹᏣᎺ
      jv:ᏆᏌ ᏣᏩ
      ka:ᏦᏥᎠᏂ
      kab:ᎧᏈᎴ
      kac:ᎧᏥᏂ
      kaj:ᏥᏧ
      kam:ᎧᎻᏆ
      kbd:ᎧᏆᏗᎠᏂ
      kcg:ᏔᏯᏆ
      kde:ᎹᎪᏕ
      kea:ᎧᏊᏪᏗᎠᏄ
      kfo:ᎪᎶ
      kgp:ᎨᏂᎨᏂ
      kha:ᎧᏏ
      khq:ᎪᏱᎳ ᏥᏂ
      ki:ᎩᎫᏳ
      kj:ᎫᏩᏂᎠᎹ
      kk:ᎧᏌᎧ
      kkj:ᎧᎪ
      kl:ᎧᎳᎵᏑᏘ
      kln:ᎧᎴᏂᏥᏂ
      km:ᎩᎻᎷ
      kmb:ᎩᎻᏊᏚ
      kn:ᎧᎾᏓ
      ko:ᎪᎵᎠᏂ
      kok:ᎧᏂᎧᏂ
      kpe:ᏇᎴ
      kr:ᎧᏄᎵ
      krc:ᎧᎳᏣᏱ-ᏆᎵᎧᎵ
      krl:ᎧᎴᎵᎠᏂ
      kru:ᎫᎷᎩ
      ks:ᎧᏏᎻᎵ
      ksb:ᏝᎻᏆᎸ
      ksf:ᏆᏫᎠ
      ksh:ᎪᎶᏂᎠᏂ
      ku:ᎫᏗᏏ
      kum:ᎫᎻᎧ
      kv:ᎪᎻ
      kw:ᏎᎷᎭ
      kwk:ᏆᏆᎳ
      kxv:ᎫᏈ
      ky:ᎩᎵᏣᎢᏍ
      la:ᎳᏘᏂ
      lad:ᎳᏗᏃ
      lag:ᎳᏂᎩ
      lb:ᎸᎦᏏᎻᏋᎢᏍ
      lez:ᎴᏏᎦᏂ
      lg:ᎦᏂᏓ
      li:ᎴᎹᏊᎵᏏ
      lij:ᎵᏇᎢᎠ
      lil:ᎵᎶᎡᏘ
      lkt:ᎳᎪᏓ
      lmo:ᎶᏆᏗ
      ln:ᎵᏂᎦᎳ
      lo:ᎳᎣ
      lou:ᎷᏫᏏᎡᎾ ᎦᏬᏂᎯᏍᏗ
      loz:ᎶᏏ
      lrc:ᏧᏴᏢ ᏗᏜ ᎷᎵ
      lsm:ᏌᎠᎻᎠ
      lt:ᎵᏚᏩᏂᎠᏂ
      lu:ᎷᏆ-ᎧᏔᎦ
      lua:ᎷᏆ-ᎷᎷᎠ
      lun:ᎷᎾᏓ
      luo:ᎷᎣ
      lus:ᎻᏐ
      luy:ᎷᏱᎠ
      lv:ᎳᏘᏫᎠᏂ
      mad:ᎹᏚᎴᏏ
      mag:ᎹᎦᎯ
      mai:ᎹᏟᎵ
      mak:ᎹᎧᏌ
      mas:ᎹᏌᏱ
      mdf:ᎼᎧᏌ
      men:ᎺᎾᏕ
      mer:ᎺᎷ
      mfe:ᎼᎵᏏᎡᏂ
      mg:ᎹᎳᎦᏏ
      mgh:ᎹᎫᏩ-ᎻᏙ
      mgo:ᎺᎳ’
      mh:ᎹᏌᎵᏏ
      mi:ᎹᏫ
      mic:ᎻᎧᎹᎩ
      min:ᎻᎾᎧᏆᎤ
      mk:ᎹᏎᏙᏂᎠᏂ
      ml:ᎹᎳᏯᎳᎻ
      mn:ᎹᏂᎪᎵᎠᏂ
      mni:ᎺᏂᏉᎵ
      moe:ᎢᏄ-ᎠᏱᏵᏂ
      moh:ᎼᎭᎩ
      mos:ᎼᏍᏏ
      mr:ᎹᎳᏘ
      ms:ᎹᎴ
      mt:ᎹᎵᏘᏍ
      mua:ᎽᏂᏓᎩ
      mul:ᏧᏈᏍᏗ ᏗᎦᏬᏂᎯᏍᏗ
      mus:ᎠᎫᏌ
      mwl:ᎻᎳᏕᏏ
      my:ᏋᎻᏍ
      myv:ᎡᏏᏯ
      mzn:ᎹᏌᏕᎳᏂ
      na:ᏃᎤᎷ
      nap:ᏂᏯᏆᎵᏔᏂ
      naq:ᎾᎹ
      nb:ᏃᎵᏪᏥᏂ ᏉᎧᎹᎵ
      nd:ᏧᏴᏢ ᏂᏕᏇᎴ
      nds:ᎡᎳᏗ ᎠᏂᏓᏥ
      nds-NL:ᎡᎳᏗ ᏁᏛᎳᏂ
      ne:ᏁᏆᎵ
      new:ᏁᏩᎵ
      ng:ᎾᏙᎦ
      nia:ᏂᎠᏏ
      niu:ᏂᏳᏫᏯᏂ
      nl:ᏛᏥ
      nl-BE:ᏊᎵᏥᎥᎻ ᏛᏥ
      nmg:ᏆᏏᏲ
      nn:ᏃᎵᏪᏥᏂ ᎾᎵᏍᎩ
      nnh:ᎾᏥᏰᎹᏊᏂ
      no:ᏃᎵᏪᏥᏂ
      nog:ᏃᎦᏱ
      nqo:ᎾᎪ
      nr:ᏧᎦᎾᏮ ᏂᏕᏇᎴ
      nso:ᏧᏴᏢ ᏗᏜ ᏐᏠ
      nus:ᏄᏪᎵ
      nv:ᎾᏩᎰ
      ny:ᏂᏯᏂᏣ
      nyn:ᏂᏯᎾᎪᎴ
      oc:ᎠᏏᏔᏂ
      ojb:ᏧᏴᏢ ᏭᏕᎵᎬ ᎣᏥᏆ
      ojc:ᎠᏰᏟ ᎣᏥᏆ
      ojs:ᎣᏥ-Ꮯ
      ojw:ᏭᏕᎵᎬ ᏗᏜ ᎣᏥᏆ
      oka:ᎣᎧᎾᎦᏂ
      om:ᎣᎶᎼ
      or:ᎣᏗᎠ
      os:ᎣᏎᏘᎧ
      pa:ᏡᏂᏣᏈ
      pag:ᏇᎦᏏᎠᏂ
      pam:ᏆᎹᏆᎾᎦ
      pap:ᏆᏈᏯᎺᎾᏙ
      pau:ᏆᎳᎤᏩᏂ
      pcm:ᎾᎩᎵᎠᏂ ᏈᏥᏂ
      pis:ᏈᏥᎾ
      pl:ᏉᎵᏍ
      pqm:ᎹᎵᏏᏘ-ᏇᏌᎹᏉᏗ
      prg:ᏡᏏᎠᏂ
      ps:ᏆᏍᏙ
      pt:ᏉᏧᎩᏍ
      pt-BR:ᏆᏏᎵᎢ ᏉᏧᎩᏍ
      pt-PT:ᏳᎳᏈ ᏉᏧᎩᏍ
      qu:ᎨᏧᏩ
      quc:ᎩᏤ
      raj:ᎳᏣᏍᎭᏂ
      rap:ᎳᏆᏄᏫ
      rar:ᎳᎶᏙᎾᎦᏂ
      rhg:ᎶᎯᏂᏯ
      rm:ᎠᏂᎶᎺᏂ
      rn:ᎷᏂᏗ
      ro:ᎶᎹᏂᎠᏂ
      ro-MD:ᎹᎵᏙᏫᎠ ᏣᎹᏂᎠᏂ
      rof:ᎶᎹᏉ
      ru:ᏲᏅᎯ
      rup:ᎠᏬᎹᏂᎠᏂ
      rw:ᎩᏂᏯᏩᏂᏓ
      rwk:Ꮖ
      sa:ᏍᏂᏍᎩᏗ
      sad:ᏌᏅᏓᏫ
      sah:ᏌᎧᎾ
      saq:ᏌᎹᏊᎷ
      sat:ᏌᏂᏔᎵ
      sba:ᎾᎦᎹᏇ
      sbp:ᏌᏁᎫ
      sc:ᏌᏗᏂᎠᏂ
      scn:ᏏᏏᎵᎠᏂ
      sco:ᏍᎦᏗ
      sd:ᏏᏂᏗ
      se:ᏧᏴᏢ ᏗᏜ ᏌᎻ
      see:ᏏᏂᎦ
      seh:ᏎᎾ
      ses:ᎪᏱᎳᏈᎶ ᏎᏂ
      sg:ᏌᏂᎪ
      shi:ᏔᏤᎵᎯᏘ
      shn:ᏝᏂ
      si:ᏏᎾᎭᎳ
      sk:ᏍᎶᏩᎩ
      sl:ᏍᎶᏫᏂᎠᏂ
      slh:ᏧᎦᏃᏮ ᏗᏜ ᎷᏑᏘᏏᏗ
      sm:ᏌᎼᏯᏂ
      sma:ᏧᎦᎾᏮ ᏗᏜ ᏌᎻ
      smj:ᎷᎴ ᏌᎻ
      smn:ᎢᎾᎵ ᏌᎻ
      sms:ᏍᎪᎵᏘ ᏌᎻ
      sn:ᏠᎾ
      snk:ᏐᏂᏂᎨ
      so:ᏐᎹᎵ
      sq:ᎠᎵᏇᏂ
      sr:ᏒᏈᎠᏂ
      srn:ᏏᎳᎾᏂ ᏙᏃᎪ
      ss:ᏍᏩᏘ
      ssy:ᏌᎰ
      st:ᏧᎦᎾᏮ ᏗᏜ ᏐᏠ
      str:ᏌᎵᏏ
      su:ᏑᏂᏓᏂᏏ
      suk:ᏑᎫᎹ
      sv:ᏍᏫᏗᏏ
      sw:ᏍᏩᎯᎵ
      sw-CD:ᎧᏂᎪ ᏍᏩᎯᎵ
      swb:ᎪᎼᎵᎠᏂ
      syr:ᏏᎵᎠᎩ
      szl:ᏏᎴᏏᏂ
      ta:ᏔᎻᎵ
      tce:ᏧᎦᏃᏮ ᏚᏦᏁ
      te:ᏖᎷᎦ
      tem:ᏘᎹᏁ
      teo:ᏖᏐ
      tet:ᏖᏚᎼ
      tg:ᏔᏥᎩ
      tgx:ᏔᎩᏏ
      th:ᏔᏱ
      tht:ᏔᏝᎾ
      ti:ᏘᎩᎵᏂᎠ
      tig:ᏢᏓᏥ
      tk:ᎠᏂᎬᎾ
      tlh:ᏟᎦᎾ
      tli:ᏟᎩᏘ
      tn:ᏧᏩᎾ
      to:ᏙᎾᎦᏂ
      tok:ᏙᎩ ᏉᎾ
      tpi:ᏙᎩ ᏈᏏᏂ
      tr:ᎠᎬᎾ
      trv:ᏔᎶᎪ
      ts:ᏦᎾᎦ
      tt:ᏔᏔ
      ttm:ᏧᏴᏢ ᏗᏜ ᏚᏦᏁ
      tum:ᏛᎹᏊᎧ
      tvl:ᏚᏩᎷ
      twq:ᏔᏌᏩᎩ
      ty:ᏔᎯᏘᎠᏂ
      tyv:ᏚᏫᏂᎠᏂ
      tzm:ᎠᏰᏟ ᎡᎶᎯ ᏓᏟᎶᏍᏗᏓᏅᎢ ᏔᎹᏏᏘ
      udm:ᎤᏚᎷᏘ
      ug:ᏫᎦ
      uk:ᏳᎧᎴᏂᎠᏂ
      umb:ᎤᎹᏊᏅᏚ
      und:ᏄᏬᎵᏍᏛᎾ ᎦᏬᏂᎯᏍᏗ
      ur:ᎤᎵᏚ
      uz:ᎤᏍᏇᎩ
      vai:ᏩᏱ
      ve:ᏫᏂᏓ
      vec:ᏈᏂᏒᏂ
      vi:ᏫᎡᏘᎾᎻᏍ
      vmw:ᎹᎱᏩ
      vo:ᏬᎳᏊᎩ
      vun:ᏭᎾᏦ
      wa:ᏩᎷᎾ
      wae:ᏩᎵᏎᎵ
      wal:ᏬᎳᏱᏔ
      war:ᏩᎴ
      wo:ᏬᎶᏫ
      wuu:Ꮽ ᏓᎶᏂᎨᏍᏛ
      xal:ᎧᎳᎻᎧ
      xh:ᏠᏌ
      xnr:ᎧᏈᎢ
      xog:ᏐᎦ
      yav:ᏰᎾᎦᏇᏂ
      ybb:ᏰᎹᏋ
      yi:ᏱᏗᏍ
      yo:ᏲᏄᏆ
      yrl:ᏂᎾᎦᏚ
      yue:ᎨᎾᏙᏂᏏ
      yue-alt-menu:ᏓᎶᏂᎨ, ᎨᎾᏙᏂᏏ
      za:ᎱᎠᏂ
      zgh:ᎠᏟᎶᏍᏗ ᎼᎶᎪ ᏔᎹᏏᏘ
      zh:ᏓᎶᏂᎨ
      zh-alt-menu:ᏓᎶᏂᎨ, ᎹᏓᏈᏂ
      zh-Hans:ᎠᎯᏗᎨ ᏓᎶᏂᎨ
      zh-Hans-alt-long:ᎠᎯᏗᎨ ᎹᏓᏈᏂ ᏓᎶᏂᎨ
      zh-Hant:ᎤᏦᏍᏗ ᏓᎶᏂᎨ
      zh-Hant-alt-long:ᎤᏦᏍᏗ ᎹᏓᏈᏂ ᏓᎶᏂᎨ
      zu:ᏑᎷ
      zun:ᏑᏂ
      zxx:Ꮭ ᎦᏬᏂᎯᏍᏗ ᎦᎸᏛᎢ ᏱᎩ
      zza:ᏌᏌ
      """.trimIndent() }

  val cic: String by lazy { """
      cic:Chikashshanompaʼ
      """.trimIndent() }

  val ckb: String by lazy { """
      aa:ئەفار
      ab:ئەبخازی
      ace:ئاچەیی
      ada:دانگمێ
      ady:ئادیگی
      af:ئەفریکانس
      agq:ئاگێم
      ain:ئاینوو
      ak:ئاکان
      ale:ئالیوت
      alt:ئاڵتایی باشوور
      am:ئەمھەری
      an:ئاراگۆنی
      anp:ئەنگیکا
      ar:عەرەبی
      ar-001:عەرەبیی ستاندارد
      arn:ماپووچە
      arp:ئاراپاهۆ
      as:ئاسامی
      asa:ئاسوو
      ast:ئاستۆری
      av:ئەڤاری
      awa:ئاوادهی
      ay:ئایمارا
      az:ئازەربایجانی
      az-alt-short:ئازەربایجانی
      az-Arab:ئازەربایجانی باشووری
      ba:باشکیەر
      ban:بالی
      bas:باسا
      be:بیلاڕووسی
      bem:بێمبا
      bez:بێنا
      bg:بۆلگاری
      bho:بوجپووری
      bi:بیسلاما
      bin:بینی
      bla:سیکسیکا
      bm:بامبارا
      bn:بەنگلادێشی
      bo:تەبەتی
      br:برێتونی
      brx:بۆدۆ
      bs:بۆسنی
      bug:بووگی
      byn:بلین
      ca:كاتالۆنی
      ce:چیچانی
      ceb:سێبوانۆ
      cgg:کیگا
      ch:چامۆرۆ
      chk:چووکی
      chm:ماری
      cho:چۆکتاو
      chr:چێرۆکی
      chy:شایان
      ckb:کوردیی ناوەندی
      ckb-alt-menu:کوردیی ناوەندی
      ckb-alt-variant:کوردیی ناوەندی
      co:کۆرسیکی
      crs:فەرەنسیی سیشێلی
      cs:چێکی
      cu:سلاویی کلیسەیی
      cv:چووڤاشی
      cy:وێلزی
      da:دانماركی
      dak:داکۆتایی
      dar:دارگینی
      dav:تایتا
      de:ئەڵمانی
      dgr:دۆگریب
      dje:زارما
      dsb:سربیی خوارین
      dua:دووالا
      dv:دیڤێهی
      dyo:جۆلافۆنی
      dz:دزوونگخا
      dzg:دازا
      ebu:ئێمبوو
      ee:ئێوێیی
      efi:ئێفیک
      eka:ئێکاجووک
      el:یۆنانی
      en:ئینگلیزی
      en-AU:ئینگلیزیی ئۆسترالیایی
      en-CA:ئینگلیزیی کەنەدایی
      en-GB:ئینگلیزیی بریتانیایی
      en-GB-alt-short:ئینگلیزی (GB)
      en-US:ئینگلیزیی ئەمەریکایی
      en-US-alt-short:ئینگلیزیی ئەمەریکایی
      eo:ئێسپیرانتۆ
      es:ئیسپانی
      et:ئیستۆنی
      eu:باسکی
      ewo:ئێوۆندۆ
      fa:فارسی
      ff:فوولایی
      fi:فینلەندی
      fil:فیلیپینی
      fj:فیجی
      fo:فەرۆیی
      fon:فۆنی
      fr:فەرەنسی
      fur:فریئوولی
      fy:فریسیی ڕۆژاوا
      ga:ئیرلەندی
      gaa:گایی
      gd:گه‌لیكی سكۆتله‌ندی
      gez:گیزی
      gil:گیلبێرتی
      gl:گالیسی
      gn:گووارانی
      gor:گۆرۆنتالی
      gsw:ئەڵمانیی سویسڕا
      gu:گوجاراتی
      guz:گووسی
      gv:مانکی
      gwi:گویچین
      ha:هائووسا
      haw:هاوایی
      he:عیبری
      hi:هیندی
      hil:هیلیگاینۆن
      hmn:همۆنگ
      hr:كرواتی
      hsb:سربیی سەروو
      ht:کریولی هائیتی
      hu:هەنگاری
      hup:هووپا
      hy:ئەرمەنی
      hz:هێرێرۆ
      ia:ئینترلینگووا
      iba:ئیبان
      ibb:ئیبیبۆ
      id:ئیندۆنیزی
      ig:ئیگبۆ
      ii:سیچوان یی
      ilo:ئیلۆکۆ
      inh:ئینگووش
      io:ئیدۆ
      is:ئیسلەندی
      it:ئیتالی
      iu:ئینوکتیتوت
      ja:ژاپۆنی
      jbo:لۆژبان
      jgo:نگۆمبا
      jmc:ماچامێ
      jv:جاڤایی
      ka:گۆرجستانی
      kab:کبائیلی
      kac:کاچین
      kaj:کیجوو
      kam:کامبا
      kbd:کاباردی
      kcg:تیاپ
      kde:ماکۆندە
      kea:کابووڤێردیانۆ
      kfo:کۆرۆ
      kha:کهاسی
      khq:کۆیرا چینی
      ki:کیکوویوو
      kj:کوانیاما
      kk:کازاخی
      kkj:کاکۆ
      kl:کالالیسووت
      kln:کالێنجین
      km:خمێر
      kmb:کیمبووندوو
      kn:کاننادا
      ko:كۆری
      kok:کۆنکانی
      kpe:کپێلێ
      kr:کانووری
      krc:کاراچای بالکار
      krl:کارێلی
      kru:کوورووخ
      ks:کەشمیری
      ksb:شامابالا
      ksf:بافیا
      ksh:کۆلۆنی
      ku:کوردی
      kum:کوومیک
      kv:کۆمی
      kw:کۆڕنی
      ky:كرگیزی
      la:لاتینی
      lad:لادینۆ
      lag:لانگی
      lb:لوکسەمبورگی
      lez:لەزگی
      lg:گاندا
      li:لیمبورگی
      lkt:لاکۆتا
      ln:لينگالا
      lo:لائۆیی
      loz:لۆزی
      lrc:لوڕیی باکوور
      lt:لیتوانی
      lu:لووبا کاتانگا
      lua:لووبا لوولووا
      lun:لووندا
      luo:لووئۆ
      lus:میزۆ
      luy:لوویا
      lv:لێتۆنی
      mad:مادووری
      mag:ماگاهی
      mai:مائیتیلی
      mak:ماکاسار
      mas:ماسایی
      mdf:مۆکشا
      men:مێندێ
      mer:مێروو
      mfe:مۆریسی
      mg:مالاگاسی
      mgh:ماخوامیتۆ
      mgo:مێتە
      mh:مارشاڵی
      mi:مائۆری
      mic:میکماک
      min:مینانکاباو
      mk:ماكێدۆنی
      ml:مالایالام
      mn:مەنگۆلی
      mni:مانیپووری
      moh:مۆهاوک
      mos:مۆسی
      mr:ماراتی
      ms:مالیزی
      mt:ماڵتی
      mua:موندانگ
      mul:چەند زمان
      mus:کریک
      mwl:میراندی
      my:میانماری
      myv:ئێرزیا
      mzn:مازەندەرانی
      na:نائوروو
      nap:ناپۆلی
      naq:ناما
      nb:نەرویژیی بۆکمال
      nd:ئندێبێلێی باکوور
      ne:نیپالی
      new:نێواری
      ng:ندۆنگا
      nia:نیاس
      niu:نیئوویی
      nl:هۆڵەندی
      nl-BE:فلێمی
      nmg:کواسیۆ
      nn:نەرویژیی نینۆرسک
      nnh:نگیمبوون
      no:نۆروێژی
      nog:نۆگای
      nqo:نکۆ
      nr:ئندێبێلێی باشوور
      nso:سۆتۆی باکوور
      nus:نوێر
      nv:ناڤاجۆ
      ny:نیانجا
      nyn:نیانکۆلێ
      oc:ئۆکسیتانی
      om:ئۆرۆمۆ
      or:ئۆدیا
      os:ئۆسێتی
      pa:پەنجابی
      pag:پانگاسینان
      pam:پامپانگا
      pap:پاپیامێنتۆ
      pau:پالائوویی
      pcm:پیجینی نیجریا
      pl:پۆڵەندی
      prg:پڕووسی
      ps:پەشتوو
      pt:پورتوگالی
      qu:کێچوا
      quc:کیچەیی
      rap:ڕاپانوویی
      rar:ڕاڕۆتۆنگان
      rm:ڕۆمانش
      rn:ڕووندی
      ro:ڕۆمانی
      ro-MD:مۆڵداڤی
      rof:ڕۆمبۆ
      ru:ڕووسی
      rup:ئارمۆمانی
      rw:کینیارواندا
      rwk:ڕوا
      sa:سانسکريت
      sad:سانداوێ
      sah:ساخا
      saq:سامبووروو
      sat:سانتالی
      sba:نگامبای
      sbp:سانگوو
      sc:ساردینی
      scn:سیسیلی
      sco:سکۆتس
      sd:سيندی
      sdh:کوردیی باشووری
      se:سامیی باکوور
      seh:سێنا
      ses:کۆیرابۆرۆ سێنی
      sg:سانگۆ
      shi:شیلها
      shn:شان
      si:سینهالی
      sk:سلۆڤاكی
      sl:سلۆڤێنی
      sm:سامۆیی
      sma:سامیی باشوور
      smj:لوولێ سامی
      smn:ئیناری سامی
      sms:سامیی سکۆڵت
      sn:شۆنا
      snk:سۆنینکێ
      so:سۆمالی
      sq:ئەڵبانی
      sr:سربی
      srn:سرانان تۆنگۆ
      ss:سواتی
      ssy:ساهۆ
      st:سۆتۆی باشوور
      su:سوندانی
      suk:سووکووما
      sv:سویدی
      sw:سواهیلی
      sw-CD:سواهیلیی کۆنگۆ
      swb:کۆمۆری
      syr:سریانی
      ta:تامیلی
      te:تێلووگوو
      tem:تیمنێ
      teo:تێسوو
      tet:تێتووم
      tg:تاجیکی
      th:تایلەندی
      ti:تیگرینیا
      tig:تیگرێ
      tk:تورکمانی
      tlh:كلینگۆن
      tn:تسوانا
      to:تۆنگان
      tpi:تۆکپیسین
      tr:تورکی
      trv:تارۆکۆ
      ts:تسۆنگا
      tt:تاتاری
      tum:تومبووکا
      tvl:تووڤالوو
      twq:تاساواک
      ty:تاهیتی
      tyv:تووڤینی
      tzm:ئەمازیغی ناوەڕاست
      udm:ئوودموورت
      ug:ئۆیخۆری
      uk:ئۆكراینی
      umb:ئومبووندوو
      und:زمانی نەناسراو
      ur:ئۆردوو
      uz:ئوزبەکی
      vai:ڤایی
      ve:ڤێندا
      vi:ڤیەتنامی
      vo:ڤۆلاپووک
      vun:ڤوونجوو
      wa:والوون
      wae:والسێر
      wal:وۆلایتا
      war:وارای
      wo:وۆلۆف
      xal:کالمیک
      xh:سسوسا
      xog:سۆگا
      yav:یانگبێن
      ybb:یێمبا
      yi:ییدیش
      yo:یۆرووبا
      yue:کانتۆنی
      yue-alt-menu:کانتۆنی
      zgh:ئەمازیغیی مەغریب
      zh:چینی
      zh-alt-menu:چینی
      zh-Hans:چینی (چینیی ئاسانکراو)
      zh-Hans-alt-long:چینی (چینیی ئاسانکراو)
      zh-Hant:چینی (چینیی دێرین)
      zh-Hant-alt-long:چینی (چینیی دێرین)
      zu:زوولوو
      zun:زوونی
      zxx:هیچ ناوەرۆکی زمانی نیە
      zza:زازا
      """.trimIndent() }

  val ckb_IR: String? = null

  val co: String by lazy { """
      co:corsu
      """.trimIndent() }

  val cs: String by lazy { """
      aa:afarština
      ab:abcházština
      ace:acehština
      ach:akolština
      ada:adangme
      ady:adygejština
      ae:avestánština
      aeb:arabština (tuniská)
      af:afrikánština
      afh:afrihili
      agq:aghem
      ain:ainština
      ak:akanština
      akk:akkadština
      akz:alabamština
      ale:aleutština
      aln:albánština (Gheg)
      alt:altajština (jižní)
      am:amharština
      an:aragonština
      ang:staroangličtina
      ann:obolo
      anp:angika
      ar:arabština
      ar-001:arabština (moderní standardní)
      arc:aramejština
      arn:mapudungun
      aro:araonština
      arp:arapažština
      arq:arabština (alžírská)
      ars:arabština (Nadžd)
      arw:arawacké jazyky
      ary:arabština (marocká)
      arz:arabština (egyptská)
      as:ásámština
      asa:asu
      ase:znaková řeč (americká)
      ast:asturština
      atj:atikamekština
      av:avarština
      avk:kotava
      awa:awadhština
      ay:ajmarština
      az:ázerbájdžánština
      az-alt-short:azerština
      ba:baškirština
      bal:balúčština
      ban:balijština
      bar:bavorština
      bas:basa
      bax:bamun
      bbc:batak toba
      bbj:ghomala
      be:běloruština
      bej:bedža
      bem:bembština
      bew:batavština
      bez:bena
      bfd:bafut
      bfq:badagština
      bg:bulharština
      bgc:harijánština
      bgn:balúčština (západní)
      bho:bhódžpurština
      bi:bislamština
      bik:bikolština
      bin:bini
      bjn:bandžarština
      bkm:kom
      bla:siksika
      blo:aniiština
      bm:bambarština
      bn:bengálština
      bo:tibetština
      bpy:bišnuprijskomanipurština
      bqi:bachtijárština
      br:bretonština
      bra:bradžština
      brh:brahujština
      brx:bodoština
      bs:bosenština
      bss:akoose
      bua:burjatština
      bug:bugiština
      bum:bulu
      byn:blinština
      byv:medumba
      ca:katalánština
      cad:caddo
      car:karibština
      cay:kajugština
      cch:atsam
      ccp:čakma
      ce:čečenština
      ceb:cebuánština
      cgg:kiga
      ch:čamoro
      chb:čibča
      chg:čagatajština
      chk:čukština
      chm:marijština
      chn:činuk pidžin
      cho:čoktština
      chp:čipevajština
      chr:čerokézština
      chy:čejenština
      ckb:kurdština (sorání)
      ckb-alt-menu:kurdština (centrální)
      ckb-alt-variant:kurdština (sorání)
      clc:čilkotinština
      co:korsičtina
      cop:koptština
      cps:kapiznonština
      cr:kríjština
      crg:mičif
      crh:tatarština (krymská)
      crj:kríjština (jihovýchodní)
      crk:kríjština (z plání)
      crl:kríjština (severovýchodní)
      crm:kríjština (Moose)
      crr:algonkinština (Karolína)
      crs:kreolština (seychelská)
      cs:čeština
      csb:kašubština
      csw:kríjština (z bažin)
      cu:staroslověnština
      cv:čuvaština
      cy:velština
      da:dánština
      dak:dakotština
      dar:dargština
      dav:taita
      de:němčina
      de-CH:němčina standardní (Švýcarsko)
      del:delawarština
      den:slejvština (athabaský jazyk)
      dgr:dogrib
      din:dinkština
      dje:zarmština
      doi:dogarština
      dsb:dolnolužická srbština
      dtp:kadazandusunština
      dua:dualština
      dum:holandština (středověká)
      dv:maledivština
      dyo:jola-fonyi
      dyu:djula
      dz:dzongkä
      dzg:dazaga
      ebu:embu
      ee:eweština
      efi:efikština
      egl:emilijština
      egy:egyptština stará
      eka:ekajuk
      el:řečtina
      elx:elamitština
      en:angličtina
      en-GB:angličtina (Velká Británie)
      en-GB-alt-short:angličtina (VB)
      en-US:angličtina (USA)
      en-US-alt-short:angličtina (USA)
      enm:angličtina (středověká)
      eo:esperanto
      es:španělština
      es-ES:španělština (Evropa)
      esu:jupikština (středoaljašská)
      et:estonština
      eu:baskičtina
      ewo:ewondo
      ext:extremadurština
      fa:perština
      fa-AF:darí
      fan:fang
      fat:fantština
      ff:fulbština
      fi:finština
      fil:filipínština
      fit:finština (tornedalská)
      fj:fidžijština
      fo:faerština
      fon:fonština
      fr:francouzština
      frc:francouzština (cajunská)
      frm:francouzština (středověká)
      fro:francouzština (stará)
      frp:franko-provensálština
      frr:fríština (severní)
      frs:fríština (východní)
      fur:furlanština
      fy:fríština (západní)
      ga:irština
      gaa:gaština
      gag:gagauzština
      gan:čínština (dialekty Gan)
      gay:gayo
      gba:gbaja
      gbz:daríjština (zoroastrijská)
      gd:skotská gaelština
      gez:geez
      gil:kiribatština
      gl:galicijština
      glk:gilačtina
      gmh:hornoněmčina (středověká)
      gn:guaranština
      goh:hornoněmčina (stará)
      gon:góndština
      gor:gorontalo
      got:gótština
      grb:grebo
      grc:starořečtina
      gsw:němčina (Švýcarsko)
      gu:gudžarátština
      guc:wayúuština
      gur:frafra
      guz:gusii
      gv:manština
      gwi:gwichʼin
      ha:hauština
      hai:haidština
      hak:čínština (dialekty Hakka)
      haw:havajština
      hax:haidština (jižní)
      he:hebrejština
      hi:hindština
      hi-Latn-alt-variant:hingliš
      hif:hindština (Fidži)
      hil:hiligajnonština
      hit:chetitština
      hmn:hmongština
      ho:hiri motu
      hr:chorvatština
      hsb:hornolužická srbština
      hsn:čínština (dialekty Xiang)
      ht:haitština
      hu:maďarština
      hup:hupa
      hur:halkomelem
      hy:arménština
      hz:hererština
      ia:interlingua
      iba:ibanština
      ibb:ibibio
      id:indonéština
      ie:interlingue
      ig:igboština
      ii:iština (sečuánská)
      ik:inupiakština
      ikt:inuktitutština (západokanadská)
      ilo:ilokánština
      inh:inguština
      io:ido
      is:islandština
      it:italština
      iu:inuktitutština
      izh:ingrijština
      ja:japonština
      jam:jamajská kreolština
      jbo:lojban
      jgo:ngomba
      jmc:mašame
      jpr:judeoperština
      jrb:judeoarabština
      jut:jutština
      jv:javánština
      ka:gruzínština
      kaa:karakalpačtina
      kab:kabylština
      kac:kačijština
      kaj:jju
      kam:kambština
      kaw:kawi
      kbd:kabardinština
      kbl:kanembu
      kcg:tyap
      kde:makonde
      kea:kapverdština
      ken:kenyang
      kfo:koro
      kg:konžština
      kgp:kaingang
      kha:khásí
      kho:chotánština
      khq:koyra chiini
      khw:chovarština
      ki:kikujština
      kiu:zazakština
      kj:kuaňamština
      kk:kazaština
      kkj:kako
      kl:grónština
      kln:kalendžin
      km:khmérština
      kmb:kimbundština
      kn:kannadština
      ko:korejština
      koi:komi-permjačtina
      kok:konkánština
      kos:kosrajština
      kpe:kpelle
      kr:kanuri
      krc:karačajevo-balkarština
      kri:krio
      krj:kinaraj-a
      krl:karelština
      kru:kuruchština
      ks:kašmírština
      ksb:šambala
      ksf:bafia
      ksh:kolínština
      ku:kurdština
      kum:kumyčtina
      kut:kutenajština
      kv:komijština
      kw:kornština
      kwk:kvakiutština
      kxv:kúvi
      ky:kyrgyzština
      la:latina
      lad:ladinština
      lag:langi
      lah:lahndština
      lam:lambština
      lb:lucemburština
      lez:lezginština
      lfn:lingua franca nova
      lg:gandština
      li:limburština
      lij:ligurština
      lil:lillooetština
      liv:livonština
      lkt:lakotština
      lmo:lombardština
      ln:lingalština
      lo:laoština
      lol:mongština
      lou:kreolština (Louisiana)
      loz:lozština
      lrc:lúrština (severní)
      lsm:samia
      lt:litevština
      ltg:latgalština
      lu:lubu-katanžština
      lua:luba-luluaština
      lui:luiseňo
      lun:lundština
      luo:luoština
      lus:mizoština
      luy:luhja
      lv:lotyština
      lzh:čínština (klasická)
      lzz:lazština
      mad:madurština
      maf:mafa
      mag:magahijština
      mai:maithiliština
      mak:makasarština
      man:mandingština
      mas:masajština
      mde:maba
      mdf:mokšanština
      mdr:mandar
      men:mende
      mer:meru
      mfe:mauricijská kreolština
      mg:malgaština
      mga:irština (středověká)
      mgh:makhuwa-meetto
      mgo:meta’
      mh:maršálština
      mi:maorština
      mic:micmac
      min:minangkabau
      mk:makedonština
      ml:malajálamština
      mn:mongolština
      mnc:mandžuština
      mni:manipurština
      moe:innu-aimun
      moh:mohawkština
      mos:mosi
      mr:maráthština
      mrj:marijština (západní)
      ms:malajština
      mt:maltština
      mua:mundang
      mul:více jazyků
      mus:kríkština
      mwl:mirandština
      mwr:márvárština
      mwv:mentavajština
      my:barmština
      mye:myene
      myv:erzjanština
      mzn:mázandaránština
      na:naurština
      nan:čínština (dialekty Minnan)
      nap:neapolština
      naq:namaština
      nb:norština (bokmål)
      nd:ndebele (Zimbabwe)
      nds:dolnoněmčina
      nds-NL:dolnosaština
      ne:nepálština
      new:névárština
      ng:ndondština
      nia:nias
      niu:niueština
      njo:ao (jazyky Nágálandu)
      nl:nizozemština
      nl-BE:vlámština
      nmg:kwasio
      nn:norština (nynorsk)
      nnh:ngiemboon
      no:norština
      nog:nogajština
      non:norština historická
      nov:novial
      nqo:n’ko
      nr:ndebele (Jižní Afrika)
      nso:sotština (severní)
      nus:nuerština
      nv:navažština
      nwc:newarština (klasická)
      ny:ňandžština
      nym:ňamwežština
      nyn:ňankolština
      nyo:ňorština
      nzi:nzima
      oc:okcitánština
      oj:odžibvejština
      ojb:odžibvejština (severozápadní)
      ojc:odžibvejština (střední)
      ojs:odžibvejština (severní)
      ojw:odžibvejština (západní)
      oka:okanaganština
      om:oromština
      or:urijština
      os:osetština
      osa:osage
      ota:turečtina (osmanská)
      pa:paňdžábština
      pag:pangasinanština
      pal:pahlavština
      pam:papangau
      pap:papiamento
      pau:palauština
      pcd:picardština
      pcm:nigerijský pidžin
      pdc:němčina (pensylvánská)
      pdt:němčina (plautdietsch)
      peo:staroperština
      pfl:falčtina
      phn:féničtina
      pi:pálí
      pis:pidžin (Šalomounovy ostrovy)
      pl:polština
      pms:piemonština
      pnt:pontština
      pon:pohnpeiština
      pqm:malesitština-passamaquoddština
      prg:pruština
      pro:provensálština
      ps:paštština
      pt:portugalština
      pt-PT:portugalština (Evropa)
      qu:kečuánština
      quc:kičé
      qug:kečuánština (chimborazo)
      raj:rádžastánština
      rap:rapanujština
      rar:rarotongánština
      rgn:romaňolština
      rhg:rohingština
      rif:rífština
      rm:rétorománština
      rn:kirundština
      ro:rumunština
      ro-MD:moldavština
      rof:rombo
      rom:romština
      rtm:rotumanština
      ru:ruština
      rue:rusínština
      rug:rovianština
      rup:arumunština
      rw:kiňarwandština
      rwk:rwa
      sa:sanskrt
      sad:sandawština
      sah:jakutština
      sam:samarština
      saq:samburu
      sas:sasakština
      sat:santálština
      saz:saurášterština
      sba:ngambay
      sbp:sangoština
      sc:sardština
      scn:sicilština
      sco:skotština
      sd:sindhština
      sdc:sassarština
      sdh:kurdština (jižní)
      se:sámština (severní)
      see:seneca
      seh:sena
      sei:seriština
      sel:selkupština
      ses:koyraboro senni
      sg:sangština
      sga:irština (stará)
      sgs:žemaitština
      sh:srbochorvatština
      shi:tašelhit
      shn:šanština
      shu:arabština (čadská)
      si:sinhálština
      sid:sidamo
      sk:slovenština
      sl:slovinština
      slh:lushootseed (jižní)
      sli:němčina (slezská)
      sly:selajarština
      sm:samojština
      sma:sámština (jižní)
      smj:sámština (lulejská)
      smn:sámština (inarijská)
      sms:sámština (skoltská)
      sn:šonština
      snk:sonikština
      so:somálština
      sog:sogdština
      sq:albánština
      sr:srbština
      srn:sranan tongo
      srr:sererština
      ss:siswatština
      ssy:saho
      st:sotština (jižní)
      stq:fríština (saterlandská)
      str:saliština (z úžin)
      su:sundština
      suk:sukuma
      sus:susu
      sux:sumerština
      sv:švédština
      sw:svahilština
      sw-CD:svahilština (Kongo)
      swb:komorština
      syc:syrština (klasická)
      syr:syrština
      szl:slezština
      ta:tamilština
      tce:tutčonština (jižní)
      tcy:tuluština
      te:telugština
      tem:temne
      teo:teso
      ter:tereno
      tet:tetumština
      tg:tádžičtina
      tgx:tagiš
      th:thajština
      tht:tahltan
      ti:tigrinijština
      tig:tigrejština
      tiv:tivština
      tk:turkmenština
      tkl:tokelauština
      tkr:cachurština
      tl:tagalog
      tlh:klingonština
      tli:tlingit
      tly:talyština
      tmh:tamašek
      tn:setswanština
      to:tongánština
      tog:tonžština (nyasa)
      tok:toki pona
      tpi:tok pisin
      tr:turečtina
      tru:turojština
      trv:taroko
      ts:tsonga
      tsd:tsakonština
      tsi:tsimšijské jazyky
      tt:tatarština
      ttm:tutčonština (severní)
      ttt:tatština
      tum:tumbukština
      tvl:tuvalština
      tw:twi
      twq:tasawaq
      ty:tahitština
      tyv:tuvinština
      tzm:tamazight (střední Maroko)
      udm:udmurtština
      ug:ujgurština
      uga:ugaritština
      uk:ukrajinština
      umb:umbundu
      und:neznámý jazyk
      ur:urdština
      uz:uzbečtina
      ve:venda
      vec:benátština
      vep:vepština
      vi:vietnamština
      vls:vlámština (západní)
      vmf:němčina (mohansko-franské dialekty)
      vmw:makhuwština
      vo:volapük
      vot:votština
      vro:võruština
      vun:vunjo
      wa:valonština
      wae:němčina (walser)
      wal:wolajtština
      war:warajština
      was:waština
      wbp:warlpiri
      wo:wolofština
      wuu:čínština (dialekty Wu)
      xal:kalmyčtina
      xh:xhoština
      xmf:mingrelština
      xnr:kángrí
      xog:sogština
      yao:jaoština
      yap:japština
      yav:jangbenština
      ybb:yemba
      yi:jidiš
      yo:jorubština
      yrl:nheengatu
      yue:kantonština
      yue-alt-menu:čínština (kantonština)
      za:čuangština
      zap:zapotéčtina
      zbl:bliss systém
      zea:zélandština
      zen:zenaga
      zgh:tamazight (standardní marocký)
      zh:čínština
      zh-alt-menu:standardní čínština
      zh-Hans:čínština (zjednodušená)
      zh-Hans-alt-long:standardní čínština (zjednodušená)
      zh-Hant-alt-long:standardní čínština (tradiční)
      zu:zuluština
      zun:zunijština
      zxx:žádný jazykový obsah
      zza:zaza
      """.trimIndent() }

  val csw: String by lazy { """
      chr:ᒉᕑᐅᑫᕀ
      csw:ᓀᐦᐃᓇᐍᐏᐣ
      en:ᐊᑲᓈᓰᒧᐏᐣ
      en-AU:ᐊᑲᓈᓰᒧᐏᐣ (AU)
      en-CA:ᐊᑲᓈᓰᒧᐏᐣ (ᑳᓇᑕ)
      en-GB:ᐊᑲᓈᓰᒧᐏᐣ (GB)
      en-GB-alt-short:ᐊᑲᓈᓰᒧᐏᐣ (GB)
      en-US:ᐊᑲᓈᓰᒧᐏᐣ (US)
      en-US-alt-short:ᐊᑲᓈᓰᒧᐏᐣ (US)
      fr:ᐹᕽᐘᔦᓰᒧᐏᐣ
      fr-CA:ᐹᕽᐘᔦᓰᒧᐏᐣ (ᑳᓇᑕ)
      fr-CH:ᐹᕽᐘᔦᓰᒧᐏᐣ (CH)
      he:ᐦᐄᑊᕑᐅᐤ
      mul:ᒥᐦᒉᐟ ᐊᔭᒧᐏᓇ
      und:ᓇᒨᓇ ᐃᐦᑕᐟᐘᐣ ᐊᔭᒧᐏᐣ
      """.trimIndent() }

  val cv: String by lazy { """
      ar:арап
      ar-001:арап литератури
      bn:бенгал
      cv:чӑваш
      de:нимӗҫ
      de-AT:австрин нимӗҫ
      de-CH:швейцарин нимӗҫ
      en:акӑлчан
      en-AU:австралин акӑлчан
      en-CA:канадӑн акӑлчан
      en-GB:британин акӑлчан
      en-GB-alt-short:британин акӑлчан
      en-US:америкӑн акӑлчан
      en-US-alt-short:америкӑн акӑлчан
      es:испани
      es-419:латинла америкӑн испани
      es-ES:европӑн испани
      es-MX:мексикӑн испани
      fr:франци
      fr-CA:канадӑн франци
      fr-CH:швейцарӗн франци
      hi:хинди
      id:индонези
      it:итали
      ja:япони
      ko:корей
      nl:голланди
      nl-BE:фламанди
      pl:поляк
      pt:португали
      pt-BR:бразилин португали
      pt-PT:европӑн португали
      ru:вырӑс
      th:тай
      tr:турккӑ
      und:паллӑ мар чӗлхе
      zh:китай
      zh-alt-menu:ҫурҫӗр китай
      zh-Hans:китай, ҫӑмӑллатнӑ ҫыру
      zh-Hans-alt-long:ҫурҫӗр китай, ҫӑмӑллатнӑ ҫыру
      zh-Hant:китай, традициллӗ ҫыру
      zh-Hant-alt-long:ҫурҫӗр китай, традициллӗ ҫыру
      """.trimIndent() }

  val cy: String by lazy { """
      aa:Affareg
      ab:Abchaseg
      ace:Acehneg
      ach:Acoli
      ada:Adangmeg
      ady:Circaseg Gorllewinol
      ae:Afestaneg
      aeb:Arabeg Tunisia
      af:Affricaneg
      afh:Affrihili
      agq:Aghemeg
      ain:Ainŵeg
      ak:Acaneg
      akk:Acadeg
      akz:Alabamäeg
      ale:Alewteg
      aln:Ghegeg Albania
      alt:Altäeg Deheuol
      am:Amhareg
      an:Aragoneg
      ang:Hen Saesneg
      ann:Obolo
      anp:Angika
      ar:Arabeg
      ar-001:Arabeg Modern Safonol
      arc:Aramaeg
      arn:Arawcaneg
      aro:Araonaeg
      arp:Arapaho
      arq:Arabeg Algeria
      ars:Arabeg Najdi
      arw:Arawaceg
      ary:Arabeg Moroco
      arz:Arabeg yr Aifft
      as:Asameg
      asa:Asw
      ase:Iaith Arwyddion America
      ast:Astwrianeg
      atj:Atikamekw
      av:Afareg
      awa:Awadhi
      ay:Aymareg
      az:Aserbaijaneg
      az-alt-short:Aserbaijaneg
      az-Arab:Aserbaijaneg Deheuol
      ba:Bashcorteg
      bal:Balwtsi
      ban:Balïeg
      bas:Basâeg
      bax:Bamwmeg
      be:Belarwseg
      bej:Bejäeg
      bem:Bembeg
      bez:Bena
      bfd:Baffwteg
      bfq:Badaga
      bg:Bwlgareg
      bgc:Haryanvi
      bgn:Balochi Gorllewinol
      bho:Bhojpuri
      bi:Bislama
      bin:Bini
      bkm:Comeg
      bla:Siksika
      blo:Anii
      bm:Bambareg
      bn:Bengaleg
      bo:Tibeteg
      br:Llydaweg
      brh:Brahui
      brx:Bodo
      bs:Bosnieg
      bss:Acwseg
      bua:Bwriateg
      bug:Bwginaeg
      bum:Bwlw
      byn:Blin
      ca:Catalaneg
      cad:Cado
      car:Caribeg
      cay:Cayuga
      cch:Atsameg
      ccp:Tsiacma
      ce:Tsietsieneg
      ceb:Cebuano
      cgg:Tsiga
      ch:Tsiamorro
      chk:Chuukaeg
      chm:Marieg
      cho:Siocto
      chp:Chipewyan
      chr:Tsierocî
      chy:Cheyenne
      ckb:Cwrdeg Sorani
      ckb-alt-menu:Cwrdeg Sorani
      ckb-alt-variant:Cwrdeg Sorani
      clc:Chilcotin
      co:Corseg
      cop:Copteg
      cr:Cri
      crg:Michif
      crh:Tyrceg y Crimea
      crj:Cree De Ddwyrain
      crk:Plains Cree
      crl:Gogledd Dwyrain Cree
      crm:Moose Cree
      crr:Carolina Algonquian
      crs:Ffrangeg Seselwa Creole
      cs:Tsieceg
      csw:Swampy Cree
      cu:Hen Slafoneg
      cv:Tshwfasheg
      cy:Cymraeg
      da:Daneg
      dak:Dacotaeg
      dar:Dargwa
      dav:Taita
      de:Almaeneg
      de-AT:Almaeneg Awstria
      de-CH:Almaeneg Safonol y Swistir
      dgr:Dogrib
      din:Dinca
      dje:Sarmaeg
      doi:Dogri
      dsb:Sorbeg Isaf
      dua:Diwaleg
      dum:Iseldireg Canol
      dv:Difehi
      dyo:Jola-Fonyi
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embw
      ee:Ewe
      efi:Efik
      egy:Hen Eiffteg
      eka:Ekajuk
      el:Groeg
      elx:Elameg
      en:Saesneg
      en-AU:Saesneg Awstralia
      en-CA:Saesneg Canada
      en-GB:Saesneg Prydain
      en-GB-alt-short:Saesneg (DU)
      en-US:Saesneg America
      en-US-alt-short:Saesneg (UDA)
      enm:Saesneg Canol
      eo:Esperanto
      es:Sbaeneg
      es-419:Sbaeneg America Ladin
      es-ES:Sbaeneg Ewrop
      es-MX:Sbaeneg Mecsico
      et:Estoneg
      eu:Basgeg
      ewo:Ewondo
      ext:Extremadureg
      fa:Perseg
      fa-AF:Dari
      fat:Ffanti
      ff:Ffwla
      fi:Ffinneg
      fil:Ffilipineg
      fit:Ffinneg Tornedal
      fj:Ffijïeg
      fo:Ffaröeg
      fon:Fon
      fr:Ffrangeg
      fr-CA:Ffrangeg Canada
      fr-CH:Ffrangeg y Swistir
      frc:Ffrangeg Cajwn
      frm:Ffrangeg Canol
      fro:Hen Ffrangeg
      frp:Arpitaneg
      frr:Ffriseg Gogleddol
      frs:Ffriseg y Dwyrain
      fur:Ffriwleg
      fy:Ffriseg y Gorllewin
      ga:Gwyddeleg
      gaa:Ga
      gag:Gagauz
      gay:Gaio
      gba:Gbaia
      gbz:Dareg y Zoroastriaid
      gd:Gaeleg yr Alban
      gez:Geez
      gil:Gilberteg
      gl:Galisieg
      gmh:Almaeneg Uchel Canol
      gn:Guaraní
      goh:Hen Almaeneg Uchel
      gor:Gorontalo
      got:Gotheg
      grc:Hen Roeg
      gsw:Almaeneg y Swistir
      gu:Gwjarati
      guz:Gusii
      gv:Manaweg
      gwi:Gwichʼin
      ha:Hawsa
      hai:Haida
      haw:Hawäieg
      hax:Haida Deheuol
      he:Hebraeg
      hi:Hindi
      hi-Latn-alt-variant:Hinglish
      hil:Hiligaynon
      hit:Hetheg
      hmn:Hmongeg
      hr:Croateg
      hsb:Sorbeg Uchaf
      ht:Creol Haiti
      hu:Hwngareg
      hup:Hupa
      hur:Halkomelem
      hy:Armeneg
      hz:Herero
      ia:Interlingua
      iba:Ibaneg
      ibb:Ibibio
      id:Indoneseg
      ie:Interlingue
      ig:Igbo
      ii:Nwosw
      ik:Inwpiaceg
      ikt:Inuktitut Canadaidd Gorllewinol
      ilo:Ilocaneg
      inh:Ingwsieg
      io:Ido
      is:Islandeg
      it:Eidaleg
      iu:Inwctitwt
      ja:Japaneeg
      jbo:Lojban
      jgo:Ngomba
      jmc:Matsiame
      jpr:Iddew-Bersieg
      jrb:Iddew-Arabeg
      jv:Jafanaeg
      ka:Georgeg
      kaa:Cara-Calpaceg
      kab:Cabileg
      kac:Kachin
      kaj:Jju
      kam:Camba
      kbd:Cabardieg
      kcg:Tyapeg
      kde:Macondeg
      kea:Caboferdianeg
      kfo:Koro
      kg:Congo
      kgp:Kaingang
      kha:Càseg
      khq:Koyra Chiini
      khw:Chowareg
      ki:Kikuyu
      kj:Kuanyama
      kk:Casacheg
      kkj:Kako
      kl:Kalaallisut
      kln:Kalenjin
      km:Chmereg
      kmb:Kimbundu
      kn:Kannada
      ko:Coreeg
      koi:Komi-Permyak
      kok:Concani
      kpe:Kpelle
      kr:Canwri
      krc:Karachay-Balkar
      krl:Careleg
      kru:Kurukh
      ks:Cashmireg
      ksb:Shambala
      ksf:Baffia
      ksh:Cwleneg
      ku:Cwrdeg
      kum:Cwmiceg
      kv:Comi
      kw:Cernyweg
      kwk:Kwakʼwala
      kxv:Kuvi
      ky:Cirgiseg
      la:Lladin
      lad:Iddew-Sbaeneg
      lag:Langi
      lah:Lahnda
      lam:Lamba
      lb:Lwcsembwrgeg
      lez:Lezgheg
      lg:Ganda
      li:Limbwrgeg
      lij:Ligwreg
      lil:Lillooet
      lkt:Lakota
      lmo:Lombardeg
      ln:Lingala
      lo:Laoeg
      lol:Mongo
      lou:Louisiana Creole
      loz:Lozi
      lrc:Luri Gogleddol
      lsm:Saamia
      lt:Lithwaneg
      ltg:Latgaleg
      lu:Luba-Katanga
      lua:Luba-Lulua
      lun:Lwnda
      luo:Lŵo
      lus:Lwshaieg
      luy:Lwyia
      lv:Latfieg
      mad:Madwreg
      mag:Magahi
      mai:Maithili
      mak:Macasareg
      man:Mandingo
      mas:Masai
      mdf:Mocsia
      mdr:Mandareg
      men:Mendeg
      mer:Mêrw
      mfe:Morisyen
      mg:Malagaseg
      mga:Gwyddeleg Canol
      mgh:Makhuwa-Meetto
      mgo:Meta
      mh:Marsialeg
      mi:Māori
      mic:Micmaceg
      min:Minangkabau
      mk:Macedoneg
      ml:Malayalam
      mn:Mongoleg
      mnc:Manshw
      mni:Manipwri
      moe:Innu-aimun
      moh:Mohoceg
      mos:Mosi
      mr:Marathi
      mrj:Mari Gorllewinol
      ms:Maleieg
      mt:Malteg
      mua:Mundang
      mul:Mwy nag un iaith
      mus:Creek
      mwl:Mirandeg
      mwr:Marwari
      my:Byrmaneg
      myv:Erzya
      mzn:Masanderani
      na:Nawrŵeg
      nap:Naplieg
      naq:Nama
      nb:Norwyeg Bokmål
      nd:Ndebele Gogleddol
      nds:Almaeneg Isel
      nds-NL:Sacsoneg Isel
      ne:Nepaleg
      new:Newaeg
      ng:Ndonga
      nia:Nias
      niu:Niuean
      njo:Ao Naga
      nl:Iseldireg
      nl-BE:Fflemeg
      nmg:Kwasio
      nn:Norwyeg Nynorsk
      nnh:Ngiemboon
      no:Norwyeg
      nog:Nogai
      non:Hen Norseg
      nqo:N’Ko
      nr:Ndebele Deheuol
      nso:Sotho Gogleddol
      nus:Nŵereg
      nv:Nafaho
      nwc:Hen Newari
      ny:Nianja
      nym:Niamwezi
      nyn:Niancole
      nyo:Nioro
      nzi:Nzimeg
      oc:Ocsitaneg
      oj:Ojibwa
      ojb:Ojibwa gogledd-orllewin
      ojc:Ojibwa Canolog
      ojs:Oji-Cree
      ojw:Ojibwa Gorllewinol
      oka:Okanagan
      om:Oromo
      or:Odia
      os:Oseteg
      osa:Osageg
      ota:Tyrceg Otoman
      pa:Pwnjabeg
      pag:Pangasineg
      pal:Pahlafi
      pam:Pampanga
      pap:Papiamento
      pau:Palawan
      pcd:Picardeg
      pcm:Pidgin Nigeria
      pdc:Almaeneg Pensylfania
      peo:Hen Bersieg
      pfl:Almaeneg Palatin
      phn:Phoeniceg
      pi:Pali
      pis:Pijin
      pl:Pwyleg
      pms:Piedmonteg
      pnt:Ponteg
      pon:Pohnpeianeg
      pqm:Maliseet-Passamaquoddy
      prg:Prwseg
      pro:Hen Brofensaleg
      ps:Pashto
      pt:Portiwgaleg
      pt-BR:Portiwgaleg Brasil
      pt-PT:Portiwgaleg Ewrop
      qu:Quechua
      quc:K’iche’
      raj:Rajasthaneg
      rap:Rapanŵi
      rar:Raratongeg
      rhg:Rohingya
      rm:Románsh
      rn:Rwndi
      ro:Rwmaneg
      ro-MD:Moldofeg
      rof:Rombo
      rom:Romani
      rtm:Rotumaneg
      ru:Rwseg
      rup:Aromaneg
      rw:Ciniarŵandeg
      rwk:Rwa
      sa:Sansgrit
      sad:Sandäweg
      sah:Sakha
      sam:Aramaeg Samaria
      saq:Sambŵrw
      sas:Sasaceg
      sat:Santali
      sba:Ngambeieg
      sbp:Sangw
      sc:Sardeg
      scn:Sisileg
      sco:Sgoteg
      sd:Sindhi
      sdc:Sasareseg Sardinia
      sdh:Cwrdeg Deheuol
      se:Sami Gogleddol
      see:Seneca
      seh:Sena
      sei:Seri
      sel:Selcypeg
      ses:Koyraboro Senni
      sg:Sango
      sga:Hen Wyddeleg
      sgs:Samogiteg
      sh:Serbo-Croateg
      shi:Tachelhit
      shn:Shan
      shu:Arabeg Chad
      si:Sinhaleg
      sid:Sidamo
      sk:Slofaceg
      sl:Slofeneg
      slh:Lushootseed Deheuol
      sli:Is-silesieg
      sm:Samöeg
      sma:Sami Deheuol
      smj:Sami Lwle
      smn:Inari Sami
      sms:Sami Scolt
      sn:Shona
      snk:Soninceg
      so:Somaleg
      sog:Sogdeg
      sq:Albaneg
      sr:Serbeg
      srn:Sranan Tongo
      srr:Serereg
      ss:Swati
      ssy:Saho
      st:Sesotheg Deheuol
      stq:Ffriseg Saterland
      str:Straits Salish
      su:Swndaneg
      suk:Swcwma
      sus:Swsŵeg
      sux:Swmereg
      sv:Swedeg
      sw:Swahili
      sw-CD:Swahili’r Congo
      swb:Comoreg
      syc:Hen Syrieg
      syr:Syrieg
      szl:Silesieg
      ta:Tamileg
      tce:Tutchone Deheuol
      tcy:Tulu
      te:Telugu
      tem:Timneg
      teo:Teso
      ter:Terena
      tet:Tetumeg
      tg:Tajiceg
      tgx:Tagish
      th:Thai
      tht:Tahltan
      ti:Tigrinya
      tig:Tigreg
      tiv:Tifeg
      tk:Tyrcmeneg
      tkl:Tocelaweg
      tkr:Tsakhureg
      tl:Tagalog
      tlh:Klingon
      tli:Tlingit
      tly:Talysheg
      tmh:Tamasheceg
      tn:Tswana
      to:Tongeg
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Tyrceg
      trv:Taroko
      ts:Tsongaeg
      tsd:Tsaconeg
      tt:Tatareg
      ttm:Tutchone gogleddol
      tum:Twmbwca
      tvl:Twfalweg
      tw:Twi
      twq:Tasawaq
      ty:Tahitïeg
      tyv:Twfwnieg
      tzm:Tamazight Canol yr Atlas
      udm:Fotiaceg
      ug:Uighur
      uga:Wgariteg
      uk:Wcreineg
      umb:Umbundu
      und:Iaith anhysbys
      ur:Wrdw
      uz:Wsbeceg
      vai:Faieg
      ve:Fendeg
      vec:Feniseg
      vep:Feps
      vi:Fietnameg
      vls:Fflemeg Gorllewinol
      vmw:Macua
      vo:Folapük
      vot:Foteg
      vun:Funjo
      wa:Walwneg
      wae:Walsereg
      wal:Walamo
      war:Winarayeg
      was:Washo
      wbp:Warlpiri
      wo:Woloff
      wuu:Wu Tsieineaidd
      xal:Calmyceg
      xh:Xhosa
      xnr:Kangri
      xog:Soga
      yav:Iangben
      ybb:Iembaeg
      yi:Iddew-Almaeneg
      yo:Iorwba
      yrl:Nheengatu
      yue:Cantoneeg
      yue-alt-menu:Tsieinëeg, Cantoneg
      za:Zhuang
      zap:Zapoteceg
      zbl:Blisssymbols
      zea:Zêlandeg
      zgh:Tamaseit Moroco Safonol
      zh:Tsieinëeg
      zh-alt-menu:Tsieinëeg, Mandarin
      zh-Hans:Tsieinëeg Symledig
      zh-Hans-alt-long:Tsieinëeg Mandarin Symledig
      zh-Hant:Tsieinëeg Traddodiadol
      zh-Hant-alt-long:Tsieinëeg Mandarin Traddodiadol
      zu:Swlw
      zun:Swni
      zxx:Dim cynnwys ieithyddol
      zza:Sasäeg
      """.trimIndent() }

  val da: String by lazy { """
      aa:afar
      ab:abkhasisk
      ace:achinesisk
      ach:acoli
      ada:adangme
      ady:adyghe
      ae:avestan
      af:afrikaans
      afh:afrihili
      agq:aghem
      ain:ainu
      ak:akan
      akk:akkadisk
      ale:aleutisk
      alt:sydaltaisk
      am:amharisk
      an:aragonsk
      ang:oldengelsk
      ann:obolo
      anp:angika
      ar:arabisk
      ar-001:moderne standardarabisk
      arc:aramæisk
      arn:mapudungun
      arp:arapaho
      ars:Najd-arabisk
      ars-alt-menu:arabisk, najdi
      arw:arawak
      as:assamesisk
      asa:asu
      ast:asturisk
      atj:atikamekw
      av:avarisk
      awa:awadhi
      ay:aymara
      az:aserbajdsjansk
      az-alt-short:azeri
      ba:bashkir
      bal:baluchi
      ban:balinesisk
      bas:basaa
      bax:bamun
      bbj:ghomala
      be:belarusisk
      bej:beja
      bem:bemba
      bez:bena
      bfd:bafut
      bg:bulgarsk
      bgc:harianvi
      bgn:vestbaluchi
      bho:bhojpuri
      bi:bislama
      bik:bikol
      bin:bini
      bkm:kom
      bla:siksika
      blo:anii
      bm:bambara
      bn:bengali
      bo:tibetansk
      br:bretonsk
      bra:braj
      brx:bodo
      bs:bosnisk
      bss:bakossi
      bua:buriatisk
      bug:buginesisk
      bum:bulu
      byn:blin
      byv:medumba
      ca:catalansk
      cad:caddo
      car:caribisk
      cay:cayuga
      cch:atsam
      ccp:chakma
      ce:tjetjensk
      ceb:cebuano
      cgg:chiga
      ch:chamorro
      chb:chibcha
      chg:chagatai
      chk:chuukese
      chm:mari
      chn:chinook
      cho:choctaw
      chp:chipewyan
      chr:cherokee
      chy:cheyenne
      ckb:sorani
      ckb-alt-menu:kurdisk, sorani
      ckb-alt-variant:centralkurdisk
      clc:chilcotin
      co:korsikansk
      cop:koptisk
      cr:cree
      crg:michif
      crh:krimtatarisk
      crj:sydøstcree
      crk:plains cree
      crl:nordøstcree
      crm:Moose-cree
      crr:carolina algonquisk
      crs:seselwa (kreol-fransk)
      cs:tjekkisk
      csb:kasjubisk
      csw:swampy cree
      cu:kirkeslavisk
      cv:tjuvasjisk
      cy:walisisk
      da:dansk
      dak:dakota
      dar:dargwa
      dav:taita
      de:tysk
      de-AT:østrigsk tysk
      de-CH:schweizerhøjtysk
      del:delaware
      den:athapaskisk
      dgr:dogrib
      din:dinka
      dje:zarma
      doi:dogri
      dsb:nedersorbisk
      dua:duala
      dum:middelhollandsk
      dv:divehi
      dyo:jola-fonyi
      dyu:dyula
      dz:dzongkha
      dzg:dazaga
      ebu:kiembu
      ee:ewe
      efi:efik
      egy:oldegyptisk
      eka:ekajuk
      el:græsk
      elx:elamitisk
      en:engelsk
      en-AU:australsk engelsk
      en-CA:canadisk engelsk
      en-GB:britisk engelsk
      en-GB-alt-short:britisk engelsk
      en-US:amerikansk engelsk
      en-US-alt-short:amerikansk engelsk
      enm:middelengelsk
      eo:esperanto
      es:spansk
      es-419:latinamerikansk spansk
      es-ES:europæisk spansk
      es-MX:mexicansk spansk
      et:estisk
      eu:baskisk
      ewo:ewondo
      fa:persisk
      fa-AF:dari
      fan:fang
      fat:fanti
      ff:fulah
      fi:finsk
      fil:filippinsk
      fj:fijiansk
      fo:færøsk
      fon:fon
      fr:fransk
      fr-CA:canadisk fransk
      fr-CH:schweizisk fransk
      frc:cajunfransk
      frm:middelfransk
      fro:oldfransk
      frr:nordfrisisk
      frs:østfrisisk
      fur:friulisk
      fy:vestfrisisk
      ga:irsk
      gaa:ga
      gag:gagauzisk
      gan:gan-kinesisk
      gay:gayo
      gba:gbaya
      gd:skotsk gælisk
      gez:geez
      gil:gilbertesisk
      gl:galicisk
      gmh:middelhøjtysk
      gn:guarani
      goh:oldhøjtysk
      gon:gondi
      gor:gorontalo
      got:gotisk
      grb:grebo
      grc:oldgræsk
      gsw:schweizertysk
      gu:gujarati
      guz:gusii
      gv:manx
      gwi:gwichin
      ha:hausa
      hai:haida
      hak:hakka-kinesisk
      haw:hawaiiansk
      hax:sydhaida
      he:hebraisk
      hi:hindi
      hi-Latn-alt-variant:hinglish
      hil:hiligaynon
      hit:hittitisk
      hmn:hmong
      ho:hirimotu
      hr:kroatisk
      hsb:øvresorbisk
      hsn:xiang-kinesisk
      ht:haitisk
      hu:ungarsk
      hup:hupa
      hur:halkomelem
      hy:armensk
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonesisk
      ie:interlingue
      ig:igbo
      ii:sichuan yi
      ik:inupiaq
      ikt:vestcanadisk inuktitut
      ilo:iloko
      inh:ingush
      io:ido
      is:islandsk
      it:italiensk
      iu:inuktitut
      ja:japansk
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jpr:jødisk-persisk
      jrb:jødisk-arabisk
      jv:javanesisk
      ka:georgisk
      kaa:karakalpakisk
      kab:kabylsk
      kac:kachin
      kaj:jju
      kam:kamba
      kaw:kawi
      kbd:kabardian
      kbl:kanembu
      kcg:tyap
      kde:makonde
      kea:kapverdisk
      kfo:koro
      kg:kongo
      kgp:kaingang
      kha:khasi
      kho:khotanesisk
      khq:koyra-chiini
      ki:kikuyu
      kj:kuanyama
      kk:kasakhisk
      kkj:kako
      kl:grønlandsk
      kln:kalenjin
      km:khmer
      kmb:kimbundu
      kn:kannada
      ko:koreansk
      koi:komi-permjakisk
      kok:konkani
      kos:kosraean
      kpe:kpelle
      kr:kanuri
      krc:karatjai-balkar
      krl:karelsk
      kru:kurukh
      ks:kashmiri
      ksb:shambala
      ksf:bafia
      ksh:kölsch
      ku:kurdisk
      kum:kymyk
      kut:kutenaj
      kv:komi
      kw:cornisk
      kwk:kwakʼwala
      kxv:kuvi
      ky:kirgisisk
      la:latin
      lad:ladino
      lag:langi
      lah:lahnda
      lam:lamba
      lb:luxembourgsk
      lez:lezghian
      lg:ganda
      li:limburgsk
      lij:ligurisk
      lil:lillooet
      lkt:lakota
      lmo:lombardisk
      ln:lingala
      lo:lao
      lol:mongo
      lou:Louisiana-kreolsk
      loz:lozi
      lrc:nordluri
      lsm:saamia
      lt:litauisk
      lu:luba-Katanga
      lua:luba-Lulua
      lui:luiseno
      lun:lunda
      lus:lushai
      luy:luyana
      lv:lettisk
      mad:madurese
      maf:mafa
      mag:magahi
      mai:maithili
      mak:makasar
      man:mandingo
      mas:masai
      mde:maba
      mdf:moksha
      mdr:mandar
      men:mende
      mer:meru
      mfe:morisyen
      mg:malagassisk
      mga:middelirsk
      mgh:makhuwa-meetto
      mgo:meta
      mh:marshallese
      mi:maori
      mic:micmac
      min:minangkabau
      mk:makedonsk
      ml:malayalam
      mn:mongolsk
      mnc:manchu
      mni:manipuri
      moe:innu-aimun
      moh:mohawk
      mos:mossi
      mr:marathi
      ms:malajisk
      mt:maltesisk
      mua:mundang
      mul:flere sprog
      mus:creek
      mwl:mirandesisk
      mwr:marwari
      my:burmesisk
      mye:myene
      myv:erzya
      mzn:mazenisk
      na:nauru
      nan:min-kinesisk
      nap:napolitansk
      naq:nama
      nb:bokmål
      nd:nordndebele
      nds:nedertysk
      ne:nepalesisk
      new:newari
      ng:ndonga
      nia:nias
      niu:niueansk
      nl:nederlandsk
      nl-BE:flamsk
      nmg:kwasio
      nn:nynorsk
      nnh:ngiemboon
      no:norsk
      nog:nogai
      non:oldislandsk
      nqo:n’ko
      nr:sydndebele
      nso:nordsotho
      nus:nuer
      nv:navajo
      nwc:klassisk newarisk
      ny:nyanja
      nym:nyamwezi
      nyn:nyankole
      nyo:nyoro-sprog
      nzi:nzima
      oc:occitansk
      oj:ojibwa
      ojb:nordvestojibwa
      ojc:centralojibwa
      ojs:oji-cree
      ojw:vestojibwa
      oka:okanagan
      om:oromo
      or:oriya
      os:ossetisk
      osa:osage
      ota:osmannisk tyrkisk
      pa:punjabi
      pag:pangasinan
      pal:pahlavi
      pam:pampanga
      pap:papiamento
      pau:palauansk
      pcm:nigeriansk pidgin
      peo:oldpersisk
      phn:fønikisk
      pi:pali
      pis:pijin
      pl:polsk
      pon:ponape
      pqm:maliseet-passamaquoddy
      prg:preussisk
      pro:oldprovencalsk
      ps:pashto
      ps-alt-variant:pushto
      pt:portugisisk
      pt-BR:brasiliansk portugisisk
      pt-PT:europæisk portugisisk
      qu:quechua
      quc:quiché
      raj:rajasthani
      rap:rapanui
      rar:rarotonga
      rhg:rohingya
      rm:rætoromansk
      rn:rundi
      ro:rumænsk
      ro-MD:moldovisk
      rof:rombo
      rom:romani
      ru:russisk
      rup:arumænsk
      rw:kinyarwanda
      rwk:rwa
      sa:sanskrit
      sad:sandawe
      sah:jakutisk
      sam:samaritansk aramæisk
      saq:samburu
      sas:sasak
      sat:santali
      sba:ngambay
      sbp:sangu
      sc:sardinsk
      scn:siciliansk
      sco:skotsk
      sd:sindhi
      sdh:sydkurdisk
      se:nordsamisk
      see:seneca
      seh:sena
      sel:selkupisk
      ses:koyraboro senni
      sg:sango
      sga:oldirsk
      sh:serbokroatisk
      shi:tachelhit
      shn:shan
      shu:tchadisk arabisk
      si:singalesisk
      sid:sidamo
      sk:slovakisk
      sl:slovensk
      slh:sydlushootseed
      sm:samoansk
      sma:sydsamisk
      smj:lulesamisk
      smn:enaresamisk
      sms:skoltesamisk
      sn:shona
      snk:soninke
      so:somali
      sog:sogdiansk
      sq:albansk
      sr:serbisk
      srn:sranan tongo
      srr:serer
      ss:swati
      ssy:saho
      st:sydsotho
      str:straits salish
      su:sundanesisk
      suk:sukuma
      sus:susu
      sux:sumerisk
      sv:svensk
      sw:swahili
      sw-CD:congolesisk swahili
      swb:comorisk
      syc:klassisk syrisk
      syr:syrisk
      szl:schlesisk
      ta:tamil
      tce:sydtutchone
      te:telugu
      tem:temne
      teo:teso
      ter:tereno
      tet:tetum
      tg:tadsjikisk
      tgx:tagish
      th:thai
      tht:tahltan
      ti:tigrinya
      tig:tigre
      tiv:tivi
      tk:turkmensk
      tkl:tokelau
      tl:tagalog
      tlh:klingon
      tli:tlingit
      tmh:tamashek
      tn:tswana
      to:tongansk
      tog:nyasa tongansk
      tok:toki pona
      tpi:tok pisin
      tr:tyrkisk
      trv:taroko
      ts:tsonga
      tsi:tsimshisk
      tt:tatarisk
      ttm:nordtutchone
      tum:tumbuka
      tvl:tuvaluansk
      tw:twi
      twq:tasawaq
      ty:tahitiansk
      tyv:tuvinian
      tzm:centralmarokkansk tamazight
      udm:udmurt
      ug:uygurisk
      ug-alt-variant:uighurisk
      uga:ugaristisk
      uk:ukrainsk
      umb:umbundu
      und:ukendt sprog
      ur:urdu
      uz:usbekisk
      ve:venda
      vec:venetiansk
      vi:vietnamesisk
      vmw:makhuwa
      vo:volapyk
      vot:votisk
      vun:vunjo
      wa:vallonsk
      wae:walsertysk
      wal:walamo
      war:waray
      was:washo
      wbp:walbiri
      wo:wolof
      wuu:wu-kinesisk
      xal:kalmyk
      xh:xhosa
      xnr:kangri
      xog:soga
      yao:yao
      yap:yapese
      yav:yangben
      ybb:yemba
      yi:jiddisch
      yo:yoruba
      yrl:nheengatu
      yue:kantonesisk
      yue-alt-menu:kantonesisk (Kina)
      za:zhuang
      zap:zapotec
      zbl:blissymboler
      zen:zenaga
      zgh:tamazight
      zh:kinesisk
      zh-alt-menu:mandarin (Kina)
      zh-Hans:forenklet kinesisk
      zh-Hans-alt-long:forenklet kinesisk
      zh-Hant:traditionelt kinesisk
      zh-Hant-alt-long:traditionelt kinesisk
      zu:zulu
      zun:zuni
      zxx:intet sprogligt indhold
      zza:zaza
      """.trimIndent() }

  val da_GL: String? = null

  val dav: String by lazy { """
      ak:Kiakan
      am:Kiamhari
      ar:Kiarabu
      be:Kibelarusi
      bg:Kibulgaria
      bn:Kibangla
      cs:Kichecki
      dav:Kitaita
      de:Kijerumani
      el:Kigiriki
      en:Kingereza
      es:Kihispania
      fa:Kiajemi
      fr:Kifaransa
      ha:Kihausa
      hi:Kihindi
      hu:Kihungari
      id:Kiindonesia
      ig:Kiigbo
      it:Kiitaliano
      ja:Kijapani
      jv:Kijava
      km:Kikambodia
      ko:Kikorea
      ms:Kimalesia
      my:Kiburma
      ne:Kinepali
      nl:Kiholanzi
      pa:Kipunjabi
      pl:Kipolandi
      pt:Kireno
      ro:Kiromania
      ru:Kirusi
      rw:Kinyarwanda
      so:Kisomali
      sv:Kiswidi
      ta:Kitamil
      th:Kitailandi
      tr:Kituruki
      uk:Kiukrania
      ur:Kiurdu
      vi:Kivietinamu
      yo:Kiyoruba
      zh:Kichina
      zh-alt-menu:Kichina
      zu:Kizulu
      """.trimIndent() }

  val de: String by lazy { """
      aa:Afar
      ab:Abchasisch
      ace:Aceh
      ach:Acholi
      ada:Adangme
      ady:Adygeisch
      ae:Avestisch
      aeb:Tunesisches Arabisch
      af:Afrikaans
      afh:Afrihili
      agq:Aghem
      ain:Ainu
      ak:Akan
      akk:Akkadisch
      akz:Alabama
      ale:Aleutisch
      aln:Gegisch
      alt:Süd-Altaisch
      am:Amharisch
      an:Aragonesisch
      ang:Altenglisch
      ann:Obolo
      anp:Angika
      ar:Arabisch
      ar-001:Modernes Hocharabisch
      arc:Aramäisch
      arn:Mapudungun
      aro:Araona
      arp:Arapaho
      arq:Algerisches Arabisch
      ars:Arabisch (Nadschd)
      arw:Arawak
      ary:Marokkanisches Arabisch
      arz:Ägyptisches Arabisch
      as:Assamesisch
      asa:Asu
      ase:Amerikanische Gebärdensprache
      ast:Asturisch
      atj:Atikamekw
      av:Awarisch
      avk:Kotava
      awa:Awadhi
      ay:Aymara
      az:Aserbaidschanisch
      az-alt-short:Aserbaidschanisch
      ba:Baschkirisch
      bal:Belutschisch
      ban:Balinesisch
      bar:Bairisch
      bas:Bassa
      bax:Bamun
      bbc:Batak Toba
      bbj:Ghomala
      be:Belarussisch
      bej:Bedauye
      bem:Bemba
      bew:Betawi
      bez:Bena
      bfd:Bafut
      bfq:Badaga
      bg:Bulgarisch
      bgc:Haryanvi
      bgn:Westliches Belutschi
      bho:Bhodschpuri
      bi:Bislama
      bik:Bikol
      bin:Bini
      bjn:Banjaresisch
      bkm:Kom
      bla:Blackfoot
      blo:Anii
      bm:Bambara
      bn:Bengalisch
      bo:Tibetisch
      bpy:Bishnupriya
      bqi:Bachtiarisch
      br:Bretonisch
      bra:Braj-Bhakha
      brh:Brahui
      brx:Bodo
      bs:Bosnisch
      bss:Akoose
      bua:Burjatisch
      bug:Buginesisch
      bum:Bulu
      byn:Blin
      byv:Medumba
      ca:Katalanisch
      cad:Caddo
      car:Karibisch
      cay:Cayuga
      cch:Atsam
      ccp:Chakma
      ce:Tschetschenisch
      ceb:Cebuano
      cgg:Rukiga
      ch:Chamorro
      chb:Chibcha
      chg:Tschagataisch
      chk:Chuukesisch
      chm:Mari
      chn:Chinook
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      ckb:Zentralkurdisch
      ckb-alt-menu:Kurdisch (Sorani)
      ckb-alt-variant:Zentralkurdisch
      clc:Chilcotin
      co:Korsisch
      cop:Koptisch
      cps:Capiznon
      cr:Cree
      crg:Michif
      crh:Krimtatarisch
      crj:Südost-Cree
      crk:Plains-Cree
      crl:Northern East Cree
      crm:Moose Cree
      crr:Carolina-Algonkin
      crs:Seychellenkreol
      cs:Tschechisch
      csb:Kaschubisch
      csw:Swampy Cree
      cu:Kirchenslawisch
      cv:Tschuwaschisch
      cy:Walisisch
      da:Dänisch
      dak:Dakota
      dar:Darginisch
      dav:Taita
      de:Deutsch
      de-AT:Österreichisches Deutsch
      de-CH:Schweizer Hochdeutsch
      del:Delaware
      den:Slave
      dgr:Dogrib
      din:Dinka
      dje:Zarma
      doi:Dogri
      dsb:Niedersorbisch
      dtp:Zentral-Dusun
      dua:Duala
      dum:Mittelniederländisch
      dv:Dhivehi
      dyo:Diola
      dyu:Dyula
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      egl:Emilianisch
      egy:Ägyptisch
      eka:Ekajuk
      el:Griechisch
      elx:Elamisch
      en:Englisch
      en-GB-alt-short:Englisch (GB)
      enm:Mittelenglisch
      eo:Esperanto
      es:Spanisch
      esu:Zentral-Alaska-Yupik
      et:Estnisch
      eu:Baskisch
      ewo:Ewondo
      ext:Extremadurisch
      fa:Persisch
      fa-AF:Dari
      fan:Pangwe
      fat:Fanti
      ff:Ful
      fi:Finnisch
      fil:Filipino
      fit:Meänkieli
      fj:Fidschi
      fo:Färöisch
      fon:Fon
      fr:Französisch
      frc:Cajun
      frm:Mittelfranzösisch
      fro:Altfranzösisch
      frp:Frankoprovenzalisch
      frr:Nordfriesisch
      frs:Ostfriesisch
      fur:Friaulisch
      fy:Westfriesisch
      ga:Irisch
      gaa:Ga
      gag:Gagausisch
      gan:Gan
      gay:Gayo
      gba:Gbaya
      gbz:Gabri
      gd:Gälisch (Schottland)
      gez:Geez
      gil:Kiribatisch
      gl:Galicisch
      glk:Gilaki
      gmh:Mittelhochdeutsch
      gn:Guaraní
      goh:Althochdeutsch
      gon:Gondi
      gor:Mongondou
      got:Gotisch
      grb:Grebo
      grc:Altgriechisch
      gsw:Schweizerdeutsch
      gu:Gujarati
      guc:Wayúu
      gur:Farefare
      guz:Gusii
      gv:Manx
      gwi:Kutchin
      ha:Haussa
      hai:Haida
      hak:Hakka
      haw:Hawaiisch
      hax:Süd-Haida
      he:Hebräisch
      hi:Hindi
      hi-Latn:Hindi (lateinisch)
      hi-Latn-alt-variant:Hinglish
      hif:Fidschi-Hindi
      hil:Hiligaynon
      hit:Hethitisch
      hmn:Miao
      ho:Hiri-Motu
      hr:Kroatisch
      hsb:Obersorbisch
      hsn:Xiang
      ht:Haiti-Kreolisch
      hu:Ungarisch
      hup:Hupa
      hur:Halkomelem
      hy:Armenisch
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Indonesisch
      ie:Interlingue
      ig:Igbo
      ii:Yi
      ik:Inupiak
      ikt:Westkanadisches Inuktitut
      ilo:Ilokano
      inh:Inguschisch
      io:Ido
      is:Isländisch
      it:Italienisch
      iu:Inuktitut
      izh:Ischorisch
      ja:Japanisch
      jam:Jamaikanisch-Kreolisch
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jpr:Jüdisch-Persisch
      jrb:Jüdisch-Arabisch
      jut:Jütisch
      jv:Javanisch
      ka:Georgisch
      kaa:Karakalpakisch
      kab:Kabylisch
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kaw:Kawi
      kbd:Kabardinisch
      kbl:Kanembu
      kcg:Tyap
      kde:Makonde
      kea:Kabuverdianu
      ken:Kenyang
      kfo:Koro
      kg:Kongolesisch
      kgp:Kaingang
      kha:Khasi
      kho:Sakisch
      khq:Koyra Chiini
      khw:Khowar
      ki:Kikuyu
      kiu:Kirmanjki
      kj:Kwanyama
      kk:Kasachisch
      kkj:Kako
      kl:Grönländisch
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Koreanisch
      koi:Komi-Permjakisch
      kok:Konkani
      kos:Kosraeanisch
      kpe:Kpelle
      kr:Kanuri
      krc:Karatschaiisch-Balkarisch
      kri:Krio
      krj:Kinaray-a
      krl:Karelisch
      kru:Oraon
      ks:Kaschmiri
      ksb:Shambala
      ksf:Bafia
      ksh:Kölsch
      ku:Kurdisch
      kum:Kumükisch
      kut:Kutenai
      kv:Komi
      kw:Kornisch
      kwk:Kwakʼwala
      kxv:Kuvi
      ky:Kirgisisch
      la:Latein
      lad:Ladino
      lag:Langi
      lah:Lahnda
      lam:Lamba
      lb:Luxemburgisch
      lez:Lesgisch
      lfn:Lingua Franca Nova
      lg:Ganda
      li:Limburgisch
      lij:Ligurisch
      lil:Lillooet
      liv:Livisch
      lkt:Lakota
      lmo:Lombardisch
      ln:Lingala
      lo:Laotisch
      lol:Mongo
      lou:Kreol (Louisiana)
      loz:Lozi
      lrc:Nördliches Luri
      lsm:Saamia
      lt:Litauisch
      ltg:Lettgallisch
      lu:Luba-Katanga
      lua:Luba-Lulua
      lui:Luiseno
      lun:Lunda
      luo:Luo
      lus:Lushai
      luy:Luhya
      lv:Lettisch
      lzh:Klassisches Chinesisch
      lzz:Lasisch
      mad:Maduresisch
      maf:Mafa
      mag:Khotta
      mai:Maithili
      mak:Makassarisch
      man:Malinke
      mas:Massai
      mde:Maba
      mdf:Mokschanisch
      mdr:Mandaresisch
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagasy
      mga:Mittelirisch
      mgh:Makhuwa-Meetto
      mgo:Meta’
      mh:Marschallesisch
      mi:Māori
      mic:Micmac
      min:Minangkabau
      mk:Mazedonisch
      ml:Malayalam
      mn:Mongolisch
      mnc:Mandschurisch
      mni:Meithei
      moe:Innu-Aimun
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      mrj:Bergmari
      ms:Malaiisch
      mt:Maltesisch
      mua:Mundang
      mul:Mehrsprachig
      mus:Muskogee
      mwl:Mirandesisch
      mwr:Marwari
      mwv:Mentawai
      my:Birmanisch
      mye:Myene
      myv:Ersja-Mordwinisch
      mzn:Masanderanisch
      na:Nauruisch
      nan:Min Nan
      nap:Neapolitanisch
      naq:Nama
      nb:Norwegisch (Bokmål)
      nd:Nord-Ndebele
      nds:Niederdeutsch
      nds-NL:Niedersächsisch
      ne:Nepalesisch
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niue
      njo:Ao-Naga
      nl:Niederländisch
      nl-BE:Flämisch
      nmg:Kwasio
      nn:Norwegisch (Nynorsk)
      nnh:Ngiemboon
      no:Norwegisch
      nog:Nogai
      non:Altnordisch
      nov:Novial
      nqo:N’Ko
      nr:Süd-Ndebele
      nso:Nord-Sotho
      nus:Nuer
      nv:Navajo
      nwc:Alt-Newari
      ny:Nyanja
      nym:Nyamwezi
      nyn:Nyankole
      nyo:Nyoro
      nzi:Nzima
      oc:Okzitanisch
      oj:Ojibwa
      ojb:Nordwest-Ojibwe
      ojc:Zentral-Ojibwe
      ojs:Oji-Cree
      ojw:West-Ojibwe
      oka:Okanagan
      om:Oromo
      or:Oriya
      os:Ossetisch
      osa:Osage
      ota:Osmanisch
      pa:Punjabi
      pag:Pangasinan
      pal:Mittelpersisch
      pam:Pampanggan
      pap:Papiamento
      pau:Palau
      pcd:Picardisch
      pcm:Nigerianisches Pidgin
      pdc:Pennsylvaniadeutsch
      pdt:Plautdietsch
      peo:Altpersisch
      pfl:Pfälzisch
      phn:Phönizisch
      pi:Pali
      pis:Pijin
      pl:Polnisch
      pms:Piemontesisch
      pnt:Pontisch
      pon:Ponapeanisch
      pqm:Maliseet-Passamaquoddy
      prg:Altpreußisch
      pro:Altprovenzalisch
      ps:Paschtu
      pt:Portugiesisch
      qu:Quechua
      quc:K’iche’
      qug:Chimborazo Hochland-Quechua
      raj:Rajasthani
      rap:Rapanui
      rar:Rarotonganisch
      rgn:Romagnol
      rhg:Rohingyalisch
      rif:Tarifit
      rm:Rätoromanisch
      rn:Rundi
      ro:Rumänisch
      ro-MD:Moldauisch
      rof:Rombo
      rom:Romani
      rtm:Rotumanisch
      ru:Russisch
      rue:Russinisch
      rug:Roviana
      rup:Aromunisch
      rw:Kinyarwanda
      rwk:Rwa
      sa:Sanskrit
      sad:Sandawe
      sah:Jakutisch
      sam:Samaritanisch
      saq:Samburu
      sas:Sasak
      sat:Santali
      saz:Saurashtra
      sba:Ngambay
      sbp:Sangu
      sc:Sardisch
      scn:Sizilianisch
      sco:Schottisch
      sd:Sindhi
      sdc:Sassarisch
      sdh:Südkurdisch
      se:Nordsamisch
      see:Seneca
      seh:Sena
      sei:Seri
      sel:Selkupisch
      ses:Koyra Senni
      sg:Sango
      sga:Altirisch
      sgs:Samogitisch
      sh:Serbo-Kroatisch
      shi:Taschelhit
      shn:Schan
      shu:Tschadisch-Arabisch
      si:Singhalesisch
      sid:Sidamo
      sk:Slowakisch
      sl:Slowenisch
      slh:Süd-Lushootseed
      sli:Schlesisch (Niederschlesisch)
      sly:Selayar
      sm:Samoanisch
      sma:Südsamisch
      smj:Lule-Samisch
      smn:Inari-Samisch
      sms:Skolt-Samisch
      sn:Shona
      snk:Soninke
      so:Somali
      sog:Sogdisch
      sq:Albanisch
      sr:Serbisch
      srn:Srananisch
      srr:Serer
      ss:Swazi
      ssy:Saho
      st:Süd-Sotho
      stq:Saterfriesisch
      str:Straits Salish
      su:Sundanesisch
      suk:Sukuma
      sus:Susu
      sux:Sumerisch
      sv:Schwedisch
      sw:Suaheli
      sw-CD:Kongo-Swahili
      swb:Komorisch
      syc:Altsyrisch
      syr:Syrisch
      szl:Schlesisch (Wasserpolnisch)
      ta:Tamil
      tce:Südliches Tutchone
      tcy:Tulu
      te:Telugu
      tem:Temne
      teo:Teso
      ter:Tereno
      tet:Tetum
      tg:Tadschikisch
      tgx:Tagish
      th:Thailändisch
      tht:Tahltan
      ti:Tigrinya
      tig:Tigre
      tiv:Tiv
      tk:Turkmenisch
      tkl:Tokelauanisch
      tkr:Tsachurisch
      tl:Tagalog
      tlh:Klingonisch
      tli:Tlingit
      tly:Talisch
      tmh:Tamaseq
      tn:Tswana
      to:Tongaisch
      tog:Nyasa Tonga
      tok:Toki Pona
      tpi:Neumelanesisch
      tr:Türkisch
      tru:Turoyo
      trv:Taroko
      ts:Tsonga
      tsd:Tsakonisch
      tsi:Tsimshian
      tt:Tatarisch
      ttm:Nördliches Tutchone
      ttt:Tatisch
      tum:Tumbuka
      tvl:Tuvaluisch
      tw:Twi
      twq:Tasawaq
      ty:Tahitisch
      tyv:Tuwinisch
      tzm:Zentralatlas-Tamazight
      udm:Udmurtisch
      ug:Uigurisch
      uga:Ugaritisch
      uk:Ukrainisch
      umb:Umbundu
      und:Unbekannte Sprache
      ur:Urdu
      uz:Usbekisch
      vai:Vai
      ve:Venda
      vec:Venetisch
      vep:Wepsisch
      vi:Vietnamesisch
      vls:Westflämisch
      vmf:Mainfränkisch
      vmw:Makua
      vo:Volapük
      vot:Wotisch
      vro:Võro
      vun:Vunjo
      wa:Wallonisch
      wae:Walliserdeutsch
      wal:Walamo
      war:Waray
      was:Washo
      wbp:Warlpiri
      wo:Wolof
      wuu:Wu
      xal:Kalmückisch
      xh:Xhosa
      xmf:Mingrelisch
      xnr:Kangri
      xog:Soga
      yao:Yao
      yap:Yapesisch
      yav:Yangben
      ybb:Yemba
      yi:Jiddisch
      yo:Yoruba
      yrl:Nheengatu
      yue:Kantonesisch
      yue-alt-menu:Chinesisch (Kantonesisch)
      za:Zhuang
      zap:Zapotekisch
      zbl:Bliss-Symbole
      zea:Seeländisch
      zen:Zenaga
      zgh:Tamazight
      zh:Chinesisch
      zh-alt-menu:Chinesisch (Mandarin)
      zh-Hans:Chinesisch (vereinfacht)
      zh-Hans-alt-long:Mandarin (Vereinfacht)
      zh-Hant:Chinesisch (traditionell)
      zh-Hant-alt-long:Mandarin (traditionell)
      zu:Zulu
      zun:Zuni
      zxx:Keine Sprachinhalte
      zza:Zaza
      """.trimIndent() }

  val de_AT: String by lazy { """
      ar-001:modernes Hocharabisch
      car:karibische Sprache
      chb:Chibcha-Sprache
      del:Delawarisch
      fur:Friulanisch
      ha:Hausa
      haw:Hawaiianisch
      hmn:Miao-Sprache
      mus:Muskogee-Sprache
      niu:Niueanisch
      pag:Pangasinensisch
      sh:Serbokroatisch
      szl:Schlesisch
      """.trimIndent() }

  val de_BE: String? = null

  val de_CH: String by lazy { """
      ach:Acholi-Sprache
      bik:Bikol-Sprache
      chb:Chibcha-Sprache
      din:Dinka-Sprache
      fan:Pangwe-Sprache
      gba:Gbaya-Sprache
      prg:Altpreussisch
      rhg:Rohingya
      tgx:Tagisch
      zh-Hans-alt-long:Hochchinesisch (vereinfacht)
      zh-Hant-alt-long:Hochchinesisch (traditionell)
      """.trimIndent() }

  val de_IT: String? = null

  val de_LI: String? = null

  val de_LU: String? = null

  val dje: String by lazy { """
      ak:Akan senni
      am:Amhaarik senni
      ar:Laaraw senni
      be:Belaruus senni
      bg:Bulagaari senni
      bn:Bengali senni
      cs:Cek senni
      de:Almaŋ senni
      dje:Zarmaciine
      el:Grek senni
      en:Inglisi senni
      es:Espaaɲe senni
      fa:Farsi senni
      fr:Fransee senni
      ha:Hawsance senni
      hi:Induu senni
      hu:Hungaari senni
      id:Indoneesi senni
      ig:Iboo senni
      it:Itaali senni
      ja:Japonee senni
      jv:Javanee senni
      km:Kmeer senni
      ko:Koree senni
      ms:Maleezi senni
      my:Burme senni
      ne:Neepal senni
      nl:Holandee senni
      pa:Punjaabi sennii
      pl:Polonee senni
      pt:Portugee senni
      ro:Rumaani senni
      ru:Ruusi senni
      rw:Rwanda senni
      so:Somaali senni
      sv:Suweede senni
      ta:Tamil senni
      th:Taailandu senni
      tr:Turku senni
      uk:Ukreen senni
      ur:Urdu senni
      vi:Vietnaam senni
      yo:Yorbance senni
      zh:Sinuwa senni
      zh-alt-menu:Sinuwa senni
      zu:Zulu senni
      """.trimIndent() }

  val doi: String by lazy { """
      de:जर्मन
      de-AT:आस्ट्रियाई जर्मन
      de-CH:स्विस हाई जर्मन
      doi:डोगरी
      en:अंगरेजी
      en-CA:कैनेडियन अंगरेजी
      en-GB:ब्रिटिश अंगरेजी
      en-GB-alt-short:यूके अंगरेजी
      en-US:अमरीकी अंगरेजी
      en-US-alt-short:यूएस अंगरेजी
      es:स्पैनिश
      es-419:लैटिन अमरीकी स्पैनिश
      es-ES:यूरोपी स्पैनिश
      es-MX:मैक्सिन स्पैनिश
      fr:फ्रेंच
      fr-CA:कैनेडियन फ्रेंच
      fr-CH:स्विस फ्रेंच
      it:इटालियन
      ja:जापानी
      pt:पुर्तगाली
      pt-BR:ब्राजीली पुर्तगाली
      pt-PT:यूरोपी पुर्तगाली
      ru:रूसी
      und:अनजांती भाशा
      zh:चीनी
      zh-alt-menu:चीनी, मंदारिन
      zh-Hans:सरलीकृत चीनी
      zh-Hans-alt-long:सरलीकृत मंदारिन चीनी
      zh-Hant:रवायती चीनी
      zh-Hant-alt-long:रवायती मंदारिन चीनी
      """.trimIndent() }

  val dsb: String by lazy { """
      aa:afaršćina
      ab:abchazšćina
      ace:achinezišćina
      ada:adangmešćina
      ady:adyghešćina
      af:afrikans
      agq:aghem
      ain:ainušćina
      ak:akanšćina
      ale:aleutišćina
      alt:pódpołdnjowa altaišćina
      am:amharšćina
      an:aragonšćina
      ang:anglosaksojšćina
      ann:obološćina
      anp:angikašćina
      ar:arabšćina
      ar-001:moderna wusokoarabšćina
      arn:arawkašćina
      arp:arapahošćina
      ars:najdi arabšćina
      as:asamšćina
      asa:pare
      ast:asturšćina
      atj:atikamekwišćina
      av:awaršćina
      awa:awandhišćina
      ay:aymaršćina
      az:azerbajdžanšćina
      az-alt-short:azerbajdžanšćina
      ba:baškiršćina
      ban:balinezišćina
      bas:basaa
      be:běłorušćina
      bem:bemba
      bez:bena
      bg:bulgaršćina
      bgc:haryanvišćina
      bho:bhojpurišćina
      bi:bislamšćina
      bin:binišćina
      bla:siksikášćina
      blo:aniišćina
      bm:bambara
      bn:bengalšćina
      bo:tibetšćina
      br:bretonšćina
      brx:bodo
      bs:bosnišćina
      bug:bugišćina
      byn:blinšćina
      ca:katanlanšćina
      cay:cayugašćina
      ccp:čakma
      ce:čečenšćina
      ceb:cebuanšćina
      cgg:chiga
      ch:čamoršćina
      chk:chuukezišćina
      chm:marišćina
      cho:choctawšćina
      chp:chipewyanšćina
      chr:cherokee
      chy:cheyennešćina
      ckb:sorani
      ckb-alt-menu:sorani
      ckb-alt-variant:centralna kurdišćina
      clc:chilcotinšćina
      co:korsišćina
      cr:kri
      crg:michifšćina
      crj:krotkozajtšna creešćina
      crk:plains creešćina
      crl:dłujkozajtšna creešćina
      crm:moode creešćina
      crr:carolina algonquianšćina
      cs:češćina
      csw:swampy creešćina
      cu:cerkwinosłowjańšćina
      cv:chuvashišćina
      cy:walizišćina
      da:danšćina
      dak:dakotašćina
      dar:dargwašćina
      dav:taita
      de:nimšćina
      de-AT:awstriska nimšćina
      de-CH:šwicarska wusokonimšćina
      dgr:dogribšćina
      dje:zarma
      doi:dogrišćina
      dsb:dolnoserbšćina
      dua:duala
      dv:divehi
      dyo:jola-fonyi
      dz:dzongkha
      dzg:dazagašćina
      ebu:embu
      ee:ewe
      efi:efikšćina
      eka:ekajukšćina
      el:grichišćina
      en:engelšćina
      en-AU:awstralska engelšćina
      en-CA:kanadiska engelšćina
      en-GB:britiska engelšćina
      en-GB-alt-short:UK-engelšćina
      en-US:ameriska engelšćina
      en-US-alt-short:US-engelšćina
      eo:esperanto
      es:špańšćina
      es-419:łatyńskoamerikańska špańšćina
      es-ES:europejska špańšćina
      es-MX:mexikańska špańšćina
      et:estišćina
      eu:baskišćina
      ewo:ewondo
      fa:persišćina
      fa-AF:dari
      ff:fulbšćina
      fi:finšćina
      fil:filipinšćina
      fj:fidžišćina
      fo:ferejšćina
      fon:fonšćina
      fr:francojšćina
      fr-CA:kanadiska francojšćina
      fr-CH:šwicarska francojšćina
      frc:cajun francojšćina
      frr:pódpołnocna frizišćina
      fur:friulšćina
      fy:frizišćina
      ga:iršćina
      gaa:gašćina
      gag:gagauzšćina
      gd:šotišćina
      gez:geezišćina
      gil:gilbertezišćina
      gl:galicišćina
      gn:guarani
      gor:gorontalošćina
      got:gotišćina
      gsw:šwicarska nimšćina
      gu:gudžaratšćina
      guz:gusii
      gv:manšćina
      gwi:gwichʼinšćina
      ha:hausa
      hai:haidašćina
      haw:hawaiišćina
      hax:pódpołdnjowa haidašćina
      he:hebrejšćina
      hi:hindišćina
      hil:hiligaynonšćina
      hmn:hmongšćina
      hr:chorwatšćina
      hsb:górnoserbšćina
      ht:haitišćina
      hu:hungoršćina
      hup:hupašćina
      hur:halkomelemšćina
      hy:armeńšćina
      hz:hererošćina
      ia:interlingua
      iba:ibanšćina
      ibb:ibibiošćina
      id:indonešćina
      ie:interlinguešćina
      ig:igbo
      ii:sichuan yi
      ik:inupiak
      ikt:pódwjacornokanadiska inuktitutšćina
      ilo:ilokošćina
      inh:ingushišćina
      io:ido
      is:islandšćina
      it:italšćina
      iu:inuitšćina
      ja:japańšćina
      jbo:lojbanšćina
      jgo:ngomba
      jmc:machame
      jv:javašćina
      ka:georgišćina
      kab:kabylšćina
      kac:kachinšćina
      kaj:jjušćina
      kam:kamba
      kbd:kabardianšćina
      kcg:tyapšćina
      kde:makonde
      kea:kapverdšćina
      kfo:korošćina
      kgp:kaingangšćina
      kha:khasišćina
      khq:koyra chiini
      ki:kikuyu
      kj:kuanyamašćina
      kk:kazachšćina
      kkj:kako
      kl:grönlandšćina
      kln:kalenjin
      km:kambodžanšćina
      kmb:kimbundušćina
      kn:kannadšćina
      ko:korejańšćina
      koi:komi-permyak
      kok:konkani
      kpe:kpellešćina
      kr:kanurišćina
      krc:karachay-balkaršćina
      krl:karelianšćina
      kru:kurukhšćina
      ks:kašmiršćina
      ksb:šambala
      ksf:bafia
      ksh:kelnšćina
      ku:kurdišćina
      kum:kumykšćina
      kv:komišćina
      kw:kornišćina
      kwk:kwakʼwalašćina
      kxv:kuvišćina
      ky:kirgišćina
      la:łatyńšćina
      lad:ladinšćina
      lag:langi
      lb:luxemburgšćina
      lez:lezgianšćina
      lg:gandšćina
      li:limburšćina
      lij:liguriańšćina
      lil:lillooetšćina
      lkt:lakotšćina
      lmo:lombardišćina
      ln:lingala
      lo:laošćina
      lou:Louisiana kreolšćina
      loz:lozišćina
      lrc:pódpołnocna lurišćina
      lsm:saamiašćina
      lt:litawšćina
      lu:luba-katanga
      lua:luba-luluašćina
      lun:lundašćina
      lus:mizošćina
      luy:luhya
      lv:letišćina
      mad:madurezišćina
      mag:magahišćina
      mai:maithilšćina
      mak:makasaršćina
      mas:masaišćina
      mdf:mokshašćina
      men:mendišćina
      mer:meru
      mfe:mauriciska kreolšćina
      mg:malgašćina
      mgh:makhuwa-meetto
      mgo:meta’
      mh:marshallezišćina
      mi:maorišćina
      mic:mi'kmaqšćina
      min:minangkabaušćina
      mk:makedońšćina
      ml:malajamšćina
      mn:mongolšćina
      mni:manipuršćina
      moe:innu-aimunšćina
      moh:mohawkšćina
      mos:mossišćina
      mr:maratišćina
      ms:malajšćina
      mt:maltašćina
      mua:mundang
      mul:wěcejrěcne
      mus:krik
      mwl:mirandezišćina
      my:burmašćina
      myv:erzyašćina
      mzn:mazanderanšćina
      na:naurušćina
      nap:neapolitanšćina
      naq:nama
      nb:norwegske bokmål
      nd:pódpołnocne ndebele
      nds:dolnonimšćina
      ne:nepalšćina
      new:newarišćina
      ng:ndongašćina
      nia:niazišćina
      niu:niueanšćina
      nl:nižozemšćina
      nl-BE:flamšćina
      nmg:kwasio
      nn:norwegske nynorsk
      nnh:ngiemboon
      no:norwegšćina
      nog:nogaišćina
      nqo:n’ko
      nr:pódpołdnjowa ndebelšćina
      nso:połnocna sothošćina
      nus:nuer
      nv:navaho
      ny:nyanja
      nyn:nyankole
      oc:okcitanšćina
      ojb:dłujkowjacorna ojibwašćina
      ojc:centralna ojibwašćina
      ojs:oji-creešćina
      ojw:pódwjacorna ojibwašćina
      oka:okanaganšćina
      om:oromo
      or:orojišćina
      os:osetšćina
      pa:pandžabšćina
      pag:pangasinanšćina
      pam:pampangašćina
      pap:papiamentošćina
      pau:palauanšćina
      pcm:nigerijanski pidgin
      pis:pijinšćina
      pl:pólšćina
      pqm:maliseet-passamaquoddyšćina
      prg:prusčina
      ps:paštunšćina
      pt:portugalšćina
      pt-BR:brazilska portugalšćina
      pt-PT:europejska portugalšćina
      qu:kečua
      quc:kʼicheʼ
      raj:rajasthanišćina
      rap:rapanuišćina
      rar:rarotonganšćina
      rhg:rohingyašćina
      rm:retoromańšćina
      rn:kirundišćina
      ro:rumunšćina
      ro-MD:moldawišćina
      rof:rombo
      ru:rušćina
      rup:armanianšćina
      rw:kinjarwanda
      rwk:rwa
      sa:sanskrit
      sad:sandawešćina
      sah:jakutšćina
      saq:samburu
      sat:santalšćina
      sba:ngambayšćina
      sbp:sangu
      sc:sardinšćina
      scn:sicilianišćina
      sco:scotšćina
      sd:sindšćina
      se:lapšćina
      seh:sena
      ses:koyra senni
      sg:sango
      sh:serbochorwatšćina
      shi:tašelhit
      shn:shanšćina
      si:singalšćina
      sk:słowakšćina
      sl:słowjeńšćina
      slh:pódpołdnjowa lushootseedšćina
      sm:samošćina
      sma:pódpołdnjowa samišćina
      smj:lule-samišćina
      smn:inari-samišćina
      sms:skolt-samišćina
      sn:šonšćina
      snk:soninkešćina
      so:somališćina
      sq:albanšćina
      sr:serbišćina
      srn:sranan tongošćina
      ss:siswati
      st:pódpołdnjowa sotšćina (Sesotho)
      stq:saterfrizišćina
      str:straits salishšćina
      su:sundanšćina
      suk:sukumašćina
      sv:šwedšćina
      sw:swahilišćina
      sw-CD:kongojska swahilišćina
      swb:comorianšćina
      syr:syriacšćina
      szl:šlazyńšćina
      ta:tamilšćina
      tce:pódpołdnjowa tutchonšćina
      te:telugšćina
      tem:timnešćina
      teo:teso
      tet:tetumšćina
      tg:tadžikišćina
      tgx:tagishšćina
      th:thailandšćina
      tht:tahltanšćina
      ti:tigrinja
      tig:tigrešćina
      tk:turkmeńšćina
      tl:tagalog
      tlh:klingonšćina
      tli:tlingitšćina
      tn:tswana
      to:tonganšćina
      tok:toki ponašćina
      tpi:tok pisinšćina
      tr:turkojšćina
      trv:tarokošćina
      ts:tsonga
      tt:tataršćina
      ttm:połnocna tutchonšćina
      tum:tumbukašćina
      tvl:tuvalušćina
      tw:twi
      twq:tasawaq
      ty:tahitišćina
      tyv:tuvinianšćina
      tzm:centralnoatlaski tamazight
      udm:udmurtšćina
      ug:ujguršćina
      uk:ukrainšćina
      umb:umbundušćina
      und:njeznata rěc
      ur:urdušćina
      uz:usbekšćina
      ve:vendašćina
      vec:venetišćina
      vi:vietnamšćina
      vmw:makhuwašćina
      vo:volapük
      vun:vunjo
      wa:walonšćina
      wae:walzeršćina
      wal:wolayttašćina
      war:warayšćina
      wo:wolof
      wuu:wu chinšćina
      xal:kalmykšćina
      xh:xhosa
      xnr:kangrišćina
      xog:soga
      yav:yangben
      ybb:yembašćina
      yi:jidišćina
      yo:jorubšćina
      yrl:nheengatušćina
      yue:kantonšćina
      yue-alt-menu:chinšćina (kantonšćina)
      za:zhuang
      zgh:standardny marokkański tamazight
      zh:chinšćina
      zh-alt-menu:chinšćina (mandarin)
      zh-Hans:chinšćina (zjadnorjona)
      zh-Hans-alt-long:chinšćina (zjadnorjona)
      zh-Hant:chinšćina (tradicionalna)
      zh-Hant-alt-long:chinšćina (tradicionalna)
      zu:zulu
      zun:zunišćina
      zxx:žedno rěcne wopśimjeśe
      zza:zazašćina
      """.trimIndent() }

  val dua: String by lazy { """
      dua:duálá
      """.trimIndent() }

  val dyo: String by lazy { """
      ak:akan
      am:amharik
      ar:arab
      be:belarus
      bg:bulgaari
      bn:bengali
      cs:sek
      de:alman
      dyo:joola
      el:greek
      en:angle
      es:español
      fa:persan
      fr:franse
      ha:hausa
      hi:endu
      hu:ongrua
      id:indoneesi
      ig:igbo
      it:italien
      ja:saponee
      jv:savanee
      km:kmeer
      ko:koree
      ms:maleesi
      my:birmani
      ne:nepalees
      nl:neerlande
      pa:penjabi
      pl:polonees
      pt:portugees
      ro:rumeen
      ru:rus
      rw:ruanda
      so:somali
      sv:suedi
      ta:tamil
      th:tay
      tr:turki
      uk:ukrain
      ur:urdu
      vi:vietnam
      yo:yoruba
      zh:sinua
      zh-alt-menu:sinua
      zu:sulu
      """.trimIndent() }

  val dz: String by lazy { """
      aa:ཨ་ཕར་ཁ
      ab:ཨཱབ་ཁ་ཟི་ཡ་ཁ
      af:ཨཕ་རི་ཀཱནས་ཁ
      am:ཨམ་ཧ་རིཀ་ཁ
      ar:ཨེ་ར་བིཀ་ཁ
      as:ཨ་ས་མིས་ཁ
      az:ཨ་ཛར་བྷའི་ཇཱན་ཁ
      az-alt-short:ཨ་ཛར་བྷའི་ཇཱན་ཁ
      be:བེལ་ཨ་རུས་ཁ
      bg:བཱལ་གེ་རི་ཡཱན་ཁ
      bn:བངྒ་ལ་ཁ
      bo:བོད་ཁ
      bs:བྷོས་ནི་ཡཱན་ཁ
      ca:ཀེ་ཊ་ལཱན་ཁ
      cs:ཅེཀ་ཁ
      cy:ཝེལཤ་ཁ
      da:ཌེ་ནིཤ་ཁ
      dak:ད་ཀོ་ཏ་ཁ
      de:ཇཱར་མཱན་ཁ
      de-AT:ཨཱོས་ཊྲི་ཡཱན་ཇཱར་མཱན་ཁ
      de-CH:སུ་ཡིས་གི་མཐོ་སའི་ཇཱར་མཱན་ཁ
      dv:དི་བེ་ཧི་ཁ
      dz:རྫོང་ཁ
      el:གྲིཀ་ཁ
      en:ཨིང་ལིཤ་ཁ
      en-AU:ཨཱོས་ཊྲེ་ལི་ཡཱན་ཨིང་ལིཤ་ཁ
      en-CA:ཀེ་ན་ཌི་ཡཱན་ཨིང་ལིཤ་ཁ
      en-GB:བྲི་ཊིཤ་ཨིང་ལིཤ་ཁ
      en-GB-alt-short:བྲི་ཊིཤ་ཨིང་ལིཤ་ཁ
      en-US:ཡུ་ཨེས་ཨིང་ལིཤ་ཁ
      en-US-alt-short:ཡུ་ཨེས་ཨིང་ལིཤ་ཁ
      eo:ཨེས་པ་རཱན་ཏོ་ཁ
      es:ཨིས་པེ་ནིཤ་ཁ
      es-419:ལེ་ཊིན་ཨ་མེ་རི་ཀཱན་གི་ཨིས་པེ་ནིཤ་ཁ
      es-ES:ཡུ་རོབ་ཀྱི་ཨིས་པེ་ནིཤ་ཁ
      et:ཨེས་ཊོ་ནི་ཡཱན་ཁ
      eu:བཱསཀ་ཁ
      fa:པར་ཤི་ཡཱན་ཁ
      fi:ཕི་ནིཤ་ཁ
      fil:ཕི་ལི་པི་ནོ་ཁ
      fj:ཕི་ཇི་ཡཱན་ཁ
      fo:ཕཱ་རོ་ཨིས་ཁ
      fr:ཕྲནཅ་ཁ
      fr-CA:ཀེ་ན་ཌི་ཡཱན་ཕྲནཅ་ཁ
      fr-CH:སུ་ཡིས་ཕྲནཅ་ཁ
      fy:ནུབ་ཕྼི་སི་ཡན་ཁ
      ga:ཨཱའི་རིཤ་ཁ
      gl:གལ་ཨིས་ཨི་ཡན་ཁ
      gn:གུ་ཝ་ར་ནི་ཁ
      gsw:སུ་ཡིས་ཇཱར་མཱན་ཁ
      gu:གུ་ཇ་ར་ཏི་ཁ
      ha:ཧཝ་ས་ཁ
      haw:ཧ་ཝ་ཡིའི་ཁ
      he:ཧེ་བྲུ་ཁ
      hi:ཧིན་དི་ཁ
      hr:ཀྲོ་ཨེ་ཤི་ཡཱན་ཁ
      ht:ཧེ་ཏི་ཡཱན་ཁ
      hu:ཧཱང་གྷ་རི་ཡཱན་ཁ
      hy:ཨར་མི་ནི་ཡཱན་ཁ
      id:ཨིན་ཌོ་ནེ་ཤི་ཡཱན་ཁ
      ig:ཨིག་བོ་ཁ
      is:ཨ་ཡིས་ལེན་ཌིཀ་ཁ
      it:ཨི་ཊ་ལི་ཡཱན་ཁ
      ja:ཇཱ་པཱ་ནིས་ཁ
      jv:ཇཱ་བ་ནིས་ཁ
      ka:ཇཽ་ཇི་ཡཱན་ཁ
      kac:ཀ་ཆིན་ཁ
      kfo:ཀོ་རོ་ཁ
      kk:ཀ་ཛགས་ཁ
      km:ཁེ་མེར་ཁ
      kn:ཀ་ན་ཌ་ཁ
      ko:ཀོ་རི་ཡཱན་ཁ
      ks:ཀཱཤ་མི་རི་ཁ
      ku:ཀར་ཌིཤ་ཁ
      ky:ཀིར་གིས་ཁ
      la:ལེ་ཊིན་ཁ
      lb:ལག་ཛམ་བོརྒ་ཁ
      lo:ལཱ་ཝོས་ཁ
      lt:ལི་ཐུ་ཝེ་ནི་ཡཱན་ཁ
      lv:ལཊ་བི་ཡཱན་ཁ
      mg:མ་ལ་ག་སི་ཁ
      mi:མ་ཨོ་རི་ཁ
      mk:མ་སེ་ཌོ་ནི་ཡཱན་ཁ
      ml:མ་ལ་ཡ་ལམ་ཁ
      mnc:མན་ཇུ་ཁ
      mr:མ་ར་ཐི་ཁ
      ms:མ་ལེ་ཁ
      mt:མཱལ་ཊ་ཁ
      my:བར་མིས་ཁ
      nb:ནོར་ཝེ་ཇི་ཡཱན་བོཀ་མཱལ་ཁ
      ne:ནེ་པཱལི་ཁ
      nl:ཌཆ་ཁ
      nl-BE:ཕྷེལེ་མིཤ་ཁ
      nn:ནོར་ཝེ་ཇི་ཡཱན་ནོརསཀ་ཁ
      no:ནོར་ཝི་ཇི་ཡན་ཁ
      or:ཨོ་རི་ཡ་ཁ
      pa:པཱན་ཇ་བི་ཁ
      pl:པོ་ལིཤ་ཁ
      ps:པཱཤ་ཏོ་ཁ
      pt:པོར་ཅུ་གིས་ཁ
      pt-BR:བྲ་ཛི་ལི་ཡཱན་པོར་ཅུ་གིས་ཁ
      pt-PT:ཨི་བེ་རི་ཡཱན་པོར་ཅུ་གིས་ཁ
      qu:ཀྭེ་ཆུ་ཨ་ཁ
      rm:རོ་མེ་ནིཤ་ཁ
      ro:རོ་མེ་ནི་ཡཱན་ཁ
      ru:ཨུ་རུ་སུའི་ཁ
      sa:སཾསྐྲྀཏ་ཁ
      sd:སིན་དཱི་ཁ
      shn:ཤཱན་ཁ
      si:སིང་ཧ་ལ་ཁ
      sk:སུ་ལོ་བཱཀ་ཁ
      sl:སུ་ལོ་བི་ནི་ཡཱན་ཁ
      so:སོ་མ་ལི་ཁ
      sq:ཨཱལ་བེ་ནི་ཡཱན་ཁ
      sr:སཱར་བྷི་ཡཱན་ཁ
      su:སཱུན་ད་ནིས་ཁ
      sv:སུའི་ཌིཤ་ཁ
      sw:སྭཱ་ཧི་ལི་ཁ
      ta:ཏ་མིལ་ཁ
      te:ཏེ་ལུ་གུ་ཁ
      tg:ཏ་ཇིཀ་ཁ
      th:ཐཱའི་ཁ
      ti:ཏིག་རི་ཉ་ཁ
      tk:ཊཱརཀ་མེན་ཁ
      to:ཊོང་གྷན་ཁ
      tr:ཊཱར་ཀིཤ་ཁ
      tt:ཊ་ཊར་ཁ
      ug:ཝི་གུར་ཁ
      uk:ཡུ་ཀེ་རེ་ནི་ཡཱན་ཁ
      und:ཁ་ངོ་མ་ཤེསཔ
      ur:ཨུར་དུ་ཁ
      uz:ཨུས་བེཀ་ཁ
      vi:བེཊ་ནཱ་མིས་ཁ
      wo:ཝོ་ལོཕ་ཁ
      xh:ཞོ་ས་ཁ
      yo:ཡོ་རུ་བ་ཁ
      zh:རྒྱ་མི་ཁ
      zh-alt-menu:རྒྱ་མི་ཁ
      zh-Hans:རྒྱ་མི་ཁ་འཇམ་སངམ
      zh-Hans-alt-long:རྒྱ་མི་ཁ་འཇམ་སངམ
      zh-Hant:སྔ་དུས་ཀྱི་རྒྱ་མི་ཁ
      zh-Hant-alt-long:སྔ་དུས་ཀྱི་རྒྱ་མི་ཁ
      zu:ཟུ་ལུ་ཁ
      zxx:སྐད་རིག་ནང་དོན་མེདཔ
      """.trimIndent() }

  val ebu: String by lazy { """
      ak:Kĩakan
      am:Kĩamhari
      ar:Kĩarabu
      be:Kĩmbelarusi
      bg:Kĩbulgaria
      bn:Kĩbangla
      cs:Kĩcheki
      de:Kĩnjeremani
      ebu:Kĩembu
      el:Kĩngriki
      en:Kĩthungu
      es:Kĩhispania
      fa:Kĩanjemi
      fr:Kĩfaransa
      ha:Kĩhausa
      hi:Kĩhindĩ
      hu:Kĩhungari
      id:Kĩindonesia
      ig:Kĩigbo
      it:Kĩitaliano
      ja:Kĩnjapani
      jv:Kĩjava
      km:Kĩkambodia
      ko:Kĩkorea
      ms:Kĩmalesia
      my:Kĩburma
      ne:Kĩnepali
      nl:Kĩholanzi
      pa:Kĩpunjabi
      pl:Kĩpolandi
      pt:Kĩreno
      ro:Kĩromania
      ru:Kĩrusi
      rw:Kĩnyarwanda
      so:Kĩsomali
      sv:Kĩswidi
      ta:Kĩtamil
      th:Kĩtailandi
      tr:Kĩturuki
      uk:Kĩukrania
      ur:Kĩurdu
      vi:Kĩvietinamu
      yo:Kĩyoruba
      zh:Kĩchina
      zh-alt-menu:Kĩchina
      zu:Kĩzulu
      """.trimIndent() }

  val ee: String by lazy { """
      ab:abkhaziagbe
      af:afrikaangbe
      agq:aghemgbe
      ak:blugbe
      am:amhariagbe
      ar:Arabiagbe
      as:assamegbe
      asa:asagbe
      ay:aymargbe
      az:azerbaijangbe
      az-alt-short:azerbaijangbe
      be:belarusiagbe
      bem:bembagbe
      bez:benagbe
      bg:bulgariagbe
      bm:bambaragbe
      bn:Bengaligbe
      bo:tibetagbe
      br:bretongbe
      brx:bodogbe
      bs:bosniagbe
      ca:katalagbe
      cs:tsɛkgbe
      cy:walesgbe
      da:denmarkgbe
      de:Germaniagbe
      de-AT:Germaniagbe (Austria)
      de-CH:Germaniagbe (Switzerland)
      dv:divehgbe
      dz:dzongkhagbe
      ebu:embugbe
      ee:eʋegbe
      efi:efigbe
      el:grisigbe
      en:iŋlisigbe
      en-AU:Yevugbe (Australia)
      en-CA:Yevugbe (Canada)
      en-GB:Yevugbe (Britain)
      en-GB-alt-short:Yevugbe (GB)
      en-US:Yevugbe (America)
      en-US-alt-short:Yevugbe (US)
      eo:esperantogbe
      es:Spanishgbe
      es-419:Spanishgbe (Latin America)
      es-ES:Spanishgbe (Europe)
      es-MX:Spanishgbe (Mexico)
      et:estoniagbe
      eu:basqugbe
      fa:persiagbe
      fi:finlanɖgbe
      fil:filipingbe
      fj:fidzigbe
      fr:Fransegbe
      fr-CA:Fransegbe (Canada)
      fr-CH:Fransegbe (Switzerland)
      ga:irelanɖgbe
      gl:galatagbe
      gn:guarangbe
      gsw:swizerlanɖtɔwo ƒe germaniagbe
      gu:gujarati
      ha:hausagbe
      haw:hawaigbe
      he:hebrigbe
      hi:Hindigbe
      hr:kroatiagbe
      ht:haitigbe
      hu:hungarigbe
      hy:armeniagbe
      id:Indonesiagbe
      ig:igbogbe
      is:icelanɖgbe
      it:Italiagbe
      ja:Japangbe
      jv:dzavangbe
      ka:gɔgiagbe
      kea:cape verdegbe
      kk:kazakhstangbe
      km:khmergbe
      kn:kannadagbe
      ko:Koreagbe
      ks:kashmirgbe
      ku:kurdiagbe
      ky:kirghistangbe
      la:latin
      lah:lahndagbe
      lb:laksembɔggbe
      ln:lingala
      lo:laogbe
      lt:lithuaniagbe
      luy:luyiagbe
      lv:latviagbe
      mg:malagasegbe
      mi:maorgbe
      mk:makedoniagbe
      ml:malayagbe
      mn:mongoliagbe
      mr:marathiagbe
      ms:malaygbe
      mt:maltagbe
      mul:gbegbɔgblɔ sɔgbɔwo
      my:burmagbe
      nb:nɔweigbe bokmål
      nd:dziehe ndebelegbe
      ne:nepalgbe
      nl:Hollandgbe
      nl-BE:Flemishgbe
      nn:nɔweigbe ninɔsk
      no:nɔweigbe
      nso:dziehe sothogbe
      ny:nyanjagbe
      or:oriyagbe
      os:ossetiagbe
      pa:pundzabgbe
      pl:Polishgbe
      ps:pashtogbe
      pt:Portuguesegbe
      pt-BR:Portuguesegbe (Brazil)
      pt-PT:Portuguesegbe (Europe)
      qu:kwetsuagbe
      rm:romanshgbe
      rn:rundigbe
      ro:romaniagbe
      rof:rombogbe
      ru:Russiagbe
      rw:ruwandagbe
      rwk:rwagbe
      sa:sanskrigbe
      sah:sakagbe
      sd:sindhgbe
      se:dziehe samigbe
      sg:sangogbe
      sh:serbo-croatiagbe
      si:sinhalgbe
      sk:slovakiagbe
      sl:sloveniagbe
      sm:samoagbe
      sn:shonagbe
      so:somaliagbe
      sq:albaniagbe
      sr:serbiagbe
      ss:swatgbe
      st:anyiehe sothogbe
      sv:swedengbe
      sw:swahili
      swb:komorogbe
      ta:tamilgbe
      te:telegugbe
      tet:tetumgbe
      tg:tadzikistangbe
      th:Thailandgbe
      ti:tigrinyagbe
      tk:tɛkmengbe
      tl:tagalogbe
      tn:tswanagbe
      to:tongagbe
      tpi:tok pisigbe
      tr:Turkishgbe
      ts:tsongagbe
      ty:tahitigbe
      ug:uighurgbe
      uk:ukraingbe
      und:gbegbɔgblɔ manya
      ur:urdugbe
      uz:uzbekistangbe
      ve:vendagbe
      vi:vietnamgbe
      wae:walsegbe
      wo:wolofgbe
      xh:xhosagbe
      yo:yorubagbe
      yue:cantongbe
      yue-alt-menu:cantongbe
      zh:Chinagbe
      zh-alt-menu:Chinagbe
      zh-Hans:tsainagbe
      zh-Hans-alt-long:tsainagbe
      zh-Hant:blema tsainagbe
      zh-Hant-alt-long:blema tsainagbe
      zu:zulugbe
      zxx:gbegbɔgblɔ manɔmee
      """.trimIndent() }

  val ee_TG: String? = null

  val el: String by lazy { """
      aa:Αφάρ
      ab:Αμπχαζικά
      ace:Ατσινιζικά
      ach:Ακολί
      ada:Αντάνγκμε
      ady:Αντιγκέα
      ae:Αβεστάν
      af:Αφρικάανς
      afh:Αφριχίλι
      agq:Αγκέμ
      ain:Αϊνού
      ak:Ακάν
      akk:Ακάντιαν
      ale:Αλεούτ
      alt:Νότια Αλτάι
      am:Αμχαρικά
      an:Αραγονικά
      ang:Παλαιά Αγγλικά
      ann:Ομπόλο
      anp:Ανγκικά
      ar:Αραβικά
      ar-001:Σύγχρονα Τυπικά Αραβικά
      arc:Αραμαϊκά
      arn:Αραουκανικά
      arp:Αραπάχο
      ars:Αραβικά Νάτζντι
      arw:Αραγουάκ
      as:Ασαμικά
      asa:Άσου
      ast:Αστουριανά
      atj:Ατικαμέκ
      av:Αβαρικά
      awa:Αγουαντί
      ay:Αϊμάρα
      az:Αζερμπαϊτζανικά
      az-alt-short:Αζερικά
      ba:Μπασκίρ
      bal:Μπαλούτσι
      ban:Μπαλινίζ
      bas:Μπάσα
      bax:Μπαμούν
      bbj:Γκομάλα
      be:Λευκορωσικά
      bej:Μπέζα
      bem:Μπέμπα
      bez:Μπένα
      bfd:Μπαφούτ
      bg:Βουλγαρικά
      bgc:Χαργιάνβι
      bgn:Δυτικά Μπαλοχικά
      bho:Μπότζπουρι
      bi:Μπισλάμα
      bik:Μπικόλ
      bin:Μπίνι
      bkm:Κομ
      bla:Σικσίκα
      blo:Ανίι
      bm:Μπαμπάρα
      bn:Βεγγαλικά
      bo:Θιβετιανά
      br:Βρετονικά
      bra:Μπρατζ
      brx:Μπόντο
      bs:Βοσνιακά
      bss:Ακόσι
      bua:Μπουριάτ
      bug:Μπουγκίζ
      bum:Μπουλού
      byn:Μπλιν
      byv:Μεντούμπα
      ca:Καταλανικά
      cad:Κάντο
      car:Καρίμπ
      cay:Καγιούγκα
      cch:Ατσάμ
      ccp:Τσάκμα
      ce:Τσετσενικά
      ceb:Σεμπουάνο
      cgg:Τσίγκα
      ch:Τσαμόρο
      chb:Τσίμπτσα
      chg:Τσαγκατάι
      chk:Τσουκίζι
      chm:Μάρι
      chn:Ιδιωματικά Σινούκ
      cho:Τσόκτο
      chp:Τσίπιουαν
      chr:Τσερόκι
      chy:Τσεγιέν
      ckb:Κεντρικά Κουρδικά
      ckb-alt-menu:Κουρδικά, Κεντρικά
      ckb-alt-variant:Κουρδικά, Σοράνι
      clc:Τσιλκότιν
      co:Κορσικανικά
      cop:Κοπτικά
      cr:Κρι
      crg:Μίτσιφ
      crh:Τουρκικά Κριμαίας
      crj:Νοτιοανατολικά Κρι
      crk:Κρι πεδιάδας
      crl:Βορειοανατολικά Κρι
      crm:Μους Κρι
      crr:Καρολίνα Αλγκονκιάν
      crs:Κρεολικά Γαλλικά Σεϋχελλών
      cs:Τσεχικά
      csb:Κασούμπιαν
      csw:Κρι Βάλτου
      cu:Εκκλησιαστικά Σλαβικά
      cv:Τσουβασικά
      cy:Ουαλικά
      da:Δανικά
      dak:Ντακότα
      dar:Ντάργκουα
      dav:Τάιτα
      de:Γερμανικά
      de-AT:Γερμανικά Αυστρίας
      de-CH:Υψηλά Γερμανικά Ελβετίας
      del:Ντέλαγουερ
      den:Σλαβικά
      dgr:Ντόγκριμπ
      din:Ντίνκα
      dje:Ζάρμα
      doi:Ντόγκρι
      dsb:Κάτω Σορβικά
      dua:Ντουάλα
      dum:Μέσα Ολλανδικά
      dv:Ντιβέχι
      dyo:Τζόλα-Φόνι
      dyu:Ντογιούλα
      dz:Ντζόνγκχα
      dzg:Νταζάγκα
      ebu:Έμπου
      ee:Έουε
      efi:Εφίκ
      egy:Αρχαία Αιγυπτιακά
      eka:Εκατζούκ
      el:Ελληνικά
      elx:Ελαμάιτ
      en:Αγγλικά
      en-AU:Αγγλικά Αυστραλίας
      en-CA:Αγγλικά Καναδά
      en-GB:Αγγλικά Βρετανίας
      en-GB-alt-short:Αγγλικά ΗΒ
      en-US:Αγγλικά Αμερικής
      en-US-alt-short:Αγγλικά ΗΠΑ
      enm:Μέσα Αγγλικά
      eo:Εσπεράντο
      es:Ισπανικά
      es-419:Ισπανικά Λατινικής Αμερικής
      es-ES:Ισπανικά Ευρώπης
      es-MX:Ισπανικά Μεξικού
      et:Εσθονικά
      eu:Βασκικά
      ewo:Εγουόντο
      fa:Περσικά
      fa-AF:Νταρί
      fan:Φανγκ
      fat:Φάντι
      ff:Φουλά
      fi:Φινλανδικά
      fil:Φιλιππινικά
      fj:Φίτζι
      fo:Φεροϊκά
      fon:Φον
      fr:Γαλλικά
      fr-CA:Γαλλικά Καναδά
      fr-CH:Γαλλικά Ελβετίας
      frc:Γαλλικά (Λουιζιάνα)
      frm:Μέσα Γαλλικά
      fro:Παλαιά Γαλλικά
      frr:Βόρεια Φριζιανά
      frs:Ανατολικά Φριζιανά
      fur:Φριουλανικά
      fy:Δυτικά Φριζικά
      ga:Ιρλανδικά
      gaa:Γκα
      gag:Γκαγκάουζ
      gay:Γκάγιο
      gba:Γκμπάγια
      gd:Σκωτικά Κελτικά
      gez:Γκιζ
      gil:Γκιλμπερτίζ
      gl:Γαλικιανά
      gmh:Μέσα Άνω Γερμανικά
      gn:Γκουαρανί
      goh:Παλαιά Άνω Γερμανικά
      gon:Γκόντι
      gor:Γκοροντάλο
      got:Γοτθικά
      grb:Γκρίμπο
      grc:Αρχαία Ελληνικά
      gsw:Γερμανικά Ελβετίας
      gu:Γκουτζαρατικά
      guz:Γκούσι
      gv:Μανξ
      gwi:Γκουίτσιν
      ha:Χάουσα
      hai:Χάιντα
      haw:Χαβαϊκά
      hax:Βόρεια Χάιντα
      he:Εβραϊκά
      hi:Χίντι
      hi-Latn-alt-variant:Hinglish
      hil:Χιλιγκαϊνόν
      hit:Χιτίτε
      hmn:Χμονγκ
      ho:Χίρι Μότου
      hr:Κροατικά
      hsb:Άνω Σορβικά
      ht:Αϊτιανά
      hu:Ουγγρικά
      hup:Χούπα
      hur:Χαλκομελέμ
      hy:Αρμενικά
      hz:Χερέρο
      ia:Ιντερλίνγκουα
      iba:Ιμπάν
      ibb:Ιμπίμπιο
      id:Ινδονησιακά
      ie:Ιντερλίνγκουε
      ig:Ίγκμπο
      ii:Σίτσουαν Γι
      ik:Ινουπιάκ
      ikt:Ινουκτιτούτ Δυτικού Καναδά
      ilo:Ιλόκο
      inh:Ινγκούς
      io:Ίντο
      is:Ισλανδικά
      it:Ιταλικά
      iu:Ινούκτιτουτ
      ja:Ιαπωνικά
      jbo:Λόζμπαν
      jgo:Νγκόμπα
      jmc:Ματσάμε
      jpr:Ιουδαϊκά-Περσικά
      jrb:Ιουδαϊκά-Αραβικά
      jv:Ιαβανικά
      ka:Γεωργιανά
      kaa:Κάρα-Καλπάκ
      kab:Καμπίλε
      kac:Κατσίν
      kaj:Τζου
      kam:Κάμπα
      kaw:Κάουι
      kbd:Καμπαρντιανά
      kbl:Κανέμπου
      kcg:Τιάπ
      kde:Μακόντε
      kea:Γλώσσα του Πράσινου Ακρωτηρίου
      kfo:Κόρο
      kg:Κονγκό
      kgp:Κάινγκανγκ
      kha:Κάσι
      kho:Κοτανικά
      khq:Κόιρα Τσίνι
      ki:Κικούγιου
      kj:Κουανιάμα
      kk:Καζακικά
      kkj:Κάκο
      kl:Καλαάλισουτ
      kln:Καλεντζίν
      km:Χμερ
      kmb:Κιμπούντου
      kn:Κανάντα
      ko:Κορεατικά
      koi:Κόμι-Περμιάκ
      kok:Κονκανικά
      kos:Κοσραενικά
      kpe:Κπέλε
      kr:Κανούρι
      krc:Καρατσάι-Μπαλκάρ
      krl:Καρελικά
      kru:Κουρούχ
      ks:Κασμιρικά
      ksb:Σαμπάλα
      ksf:Μπάφια
      ksh:Κολωνικά
      ku:Κουρδικά
      kum:Κουμγιούκ
      kut:Κουτενάι
      kv:Κόμι
      kw:Κορνουαλικά
      kwk:Κουακουάλα
      kxv:Κούβι
      ky:Κιργιζικά
      la:Λατινικά
      lad:Λαδίνο
      lag:Λάνγκι
      lah:Λάχδα
      lam:Λάμπα
      lb:Λουξεμβουργιανά
      lez:Λεζγκικά
      lg:Γκάντα
      li:Λιμβουργιανά
      lij:Λιγουριανά
      lil:Λιλουέτ
      lkt:Λακότα
      lmo:Λομβαρδικά
      ln:Λινγκάλα
      lo:Λαοτινά
      lol:Μόνγκο
      lou:Κρεολικά (Λουιζιάνα)
      loz:Λόζι
      lrc:Βόρεια Λούρι
      lsm:Σαάμια
      lt:Λιθουανικά
      lu:Λούμπα-Κατάνγκα
      lua:Λούμπα-Λουλούα
      lui:Λουισένο
      lun:Λούντα
      luo:Λούο
      lus:Μίζο
      luy:Λούχια
      lv:Λετονικά
      mad:Μαντουρίζ
      maf:Μάφα
      mag:Μαγκάχι
      mai:Μαϊτχίλι
      mak:Μακασάρ
      man:Μαντίνγκο
      mas:Μασάι
      mde:Μάμπα
      mdf:Μόκσα
      mdr:Μανδάρ
      men:Μέντε
      mer:Μέρου
      mfe:Μορισιέν
      mg:Μαλγασικά
      mga:Μέσα Ιρλανδικά
      mgh:Μακούβα-Μέτο
      mgo:Μέτα
      mh:Μαρσαλέζικα
      mi:Μαορί
      mic:Μικμάκ
      min:Μινανγκαμπάου
      mk:Σλαβομακεδονικά
      ml:Μαλαγιαλαμικά
      mn:Μογγολικά
      mnc:Μαντσού
      mni:Μανιπούρι
      moe:Ινου-αϊμούν
      moh:Μοχόκ
      mos:Μόσι
      mr:Μαραθικά
      ms:Μαλαισιανά
      mt:Μαλτεζικά
      mua:Μουντάνγκ
      mul:Πολλαπλές γλώσσες
      mus:Κρικ
      mwl:Μιραντεζικά
      mwr:Μαργουάρι
      my:Βιρμανικά
      mye:Μιένε
      myv:Έρζια
      mzn:Μαζαντεράνι
      na:Ναούρου
      nap:Ναπολιτανικά
      naq:Νάμα
      nb:Νορβηγικά Μποκμάλ
      nd:Βόρεια Ντεμπέλε
      nds:Κάτω Γερμανικά
      nds-NL:Κάτω Γερμανικά Ολλανδίας
      ne:Νεπαλικά
      new:Νεγουάρι
      ng:Ντόνγκα
      nia:Νίας
      niu:Νιούε
      nl:Ολλανδικά
      nl-BE:Φλαμανδικά
      nmg:Κβάσιο
      nn:Νορβηγικά Νινόρσκ
      nnh:Νγκιεμπούν
      no:Νορβηγικά
      nog:Νογκάι
      non:Παλαιά Νορβηγικά
      nqo:Ν’Κο
      nr:Νότια Ντεμπέλε
      nso:Βόρεια Σόθο
      nus:Νούερ
      nv:Νάβαχο
      nwc:Κλασικά Νεουάρι
      ny:Νιάντζα
      nym:Νιαμγουέζι
      nyn:Νιανκόλε
      nyo:Νιόρο
      nzi:Νζίμα
      oc:Οξιτανικά
      oj:Οζιβίγουα
      ojb:Βορειοδυτικά Οζιβίγουα
      ojc:Κεντρικά Οτζίμπουα
      ojs:Ότζι-Κρι
      ojw:Δυτικά Οζιβίγουα
      oka:Οκανάγκαν
      om:Ορόμο
      or:Όντια
      os:Οσετικά
      osa:Οσάζ
      ota:Οθωμανικά Τουρκικά
      pa:Παντζαπικά
      pag:Πανγκασινάν
      pal:Παχλάβι
      pam:Παμπάνγκα
      pap:Παπιαμέντο
      pau:Παλάουαν
      pcm:Πίτζιν Νιγηρίας
      peo:Αρχαία Περσικά
      phn:Φοινικικά
      pi:Πάλι
      pis:Πιτζίν
      pl:Πολωνικά
      pon:Πομπηικά
      pqm:Μαλισιτ-Πασσαμακουόντ
      prg:Πρωσικά
      pro:Παλαιά Προβανσάλ
      ps:Πάστο
      pt:Πορτογαλικά
      pt-BR:Πορτογαλικά Βραζιλίας
      pt-PT:Πορτογαλικά Ευρώπης
      qu:Κέτσουα
      quc:Κιτσέ
      raj:Ραζασθάνι
      rap:Ραπανούι
      rar:Ραροτονγκάν
      rhg:Ροχίνγκια
      rm:Ρομανικά
      rn:Ρούντι
      ro:Ρουμανικά
      ro-MD:Μολδαβικά
      rof:Ρόμπο
      rom:Ρομανί
      ru:Ρωσικά
      rup:Αρομανικά
      rw:Κινιαρουάντα
      rwk:Ρουά
      sa:Σανσκριτικά
      sad:Σαντάγουε
      sah:Σαχά
      sam:Σαμαρίτικα Αραμαϊκά
      saq:Σαμπούρου
      sas:Σασάκ
      sat:Σαντάλι
      sba:Νγκαμπέι
      sbp:Σάνγκου
      sc:Σαρδηνιακά
      scn:Σικελικά
      sco:Σκωτικά
      sd:Σίντι
      sdh:Νότια Κουρδικά
      se:Βόρεια Σάμι
      see:Σένεκα
      seh:Σένα
      sel:Σελκούπ
      ses:Κοϊραμπόρο Σένι
      sg:Σάνγκο
      sga:Παλαιά Ιρλανδικά
      sh:Σερβοκροατικά
      shi:Τασελχίτ
      shn:Σαν
      shu:Αραβικά του Τσαντ
      si:Σινχαλεζικά
      sid:Σιντάμο
      sk:Σλοβακικά
      sl:Σλοβενικά
      slh:Νότια Λάσουτσιντ
      sm:Σαμοανά
      sma:Νότια Σάμι
      smj:Λούλε Σάμι
      smn:Ινάρι Σάμι
      sms:Σκολτ Σάμι
      sn:Σόνα
      snk:Σονίνκε
      so:Σομαλικά
      sog:Σογκντιέν
      sq:Αλβανικά
      sr:Σερβικά
      srn:Σρανάν Τόνγκο
      srr:Σερέρ
      ss:Σουάτι
      ssy:Σάχο
      st:Νότια Σόθο
      str:Στρέιτς Σαλίς
      su:Σουνδανικά
      suk:Σουκούμα
      sus:Σούσου
      sux:Σουμερικά
      sv:Σουηδικά
      sw:Σουαχίλι
      sw-CD:Κονγκό Σουαχίλι
      swb:Κομοριανά
      syc:Κλασικά Συριακά
      syr:Συριακά
      szl:Σιλεσικά
      ta:Ταμιλικά
      tce:Νότια Τουτσόνε
      te:Τελούγκου
      tem:Τίμνε
      teo:Τέσο
      ter:Τερένο
      tet:Τέτουμ
      tg:Τατζικικά
      tgx:Τατζίς
      th:Ταϊλανδικά
      tht:Ταλτάν
      ti:Τιγκρινικά
      tig:Τίγκρε
      tiv:Τιβ
      tk:Τουρκμενικά
      tkl:Τοκελάου
      tl:Τάγκαλογκ
      tlh:Κλίνγκον
      tli:Τλίνγκιτ
      tmh:Ταμασέκ
      tn:Τσουάνα
      to:Τονγκανικά
      tog:Νιάσα Τόνγκα
      tok:Τόκι Πόνα
      tpi:Τοκ Πισίν
      tr:Τουρκικά
      trv:Ταρόκο
      ts:Τσόνγκα
      tsi:Τσίμσιαν
      tt:Ταταρικά
      ttm:Βόρεια Τουτσόνε
      tum:Τουμπούκα
      tvl:Τουβαλού
      tw:Τούι
      twq:Τασαβάκ
      ty:Ταϊτιανά
      tyv:Τουβινικά
      tzm:Ταμαζίτ Κεντρικού Μαρόκο
      udm:Ουντμούρτ
      ug:Ουιγουρικά
      ug-alt-variant:Ουιγούρ
      uga:Ουγκαριτικά
      uk:Ουκρανικά
      umb:Ουμπούντου
      und:Άγνωστη γλώσσα
      ur:Ούρντου
      uz:Ουζμπεκικά
      vai:Βάι
      ve:Βέντα
      vec:Βενετικά
      vi:Βιετναμικά
      vmw:Μακούα
      vo:Βολαπιούκ
      vot:Βότικ
      vun:Βούντζο
      wa:Βαλλωνικά
      wae:Βάλσερ
      wal:Γουολάιτα
      war:Γουάραϊ
      was:Γουασό
      wbp:Γουαρλπίρι
      wo:Γουόλοφ
      wuu:Κινεζικά Γου
      xal:Καλμίκ
      xh:Κόσα
      xnr:Κάνγκρι
      xog:Σόγκα
      yao:Γιάο
      yap:Γιαπίζ
      yav:Γιανγκμπέν
      ybb:Γιέμπα
      yi:Γίντις
      yo:Γιορούμπα
      yrl:Νινγκατού
      yue:Καντονέζικα
      yue-alt-menu:Κινεζικά, Καντονέζικα
      za:Ζουάνγκ
      zap:Ζάποτεκ
      zbl:Σύμβολα Bliss
      zen:Ζενάγκα
      zgh:Τυπικά Ταμαζίτ Μαρόκου
      zh:Κινεζικά
      zh-alt-menu:Κινεζικά, Μανδαρινικά
      zh-Hans:Απλοποιημένα Κινεζικά
      zh-Hans-alt-long:Απλοποιημένα Μανδαρινικά Κινεζικά
      zh-Hant:Παραδοσιακά Κινεζικά
      zh-Hant-alt-long:Παραδοσιακά Μανδαρινικά Κινεζικά
      zu:Ζουλού
      zun:Ζούνι
      zxx:Χωρίς γλωσσολογικό περιεχόμενο
      zza:Ζάζα
      """.trimIndent() }

  val el_CY: String? = null

  val el_polyton: String by lazy { """
      ar:Ἀραβικά
      arc:Ἀραμαϊκά
      cy:Οὐαλικά
      egy:Αἰγυπτιακὰ (ἀρχαῖα)
      el:Ἑλληνικά
      en:Ἀγγλικά
      es:Ἱσπανικά
      et:Ἐσθονικά
      ga:Ἰρλανδικά
      gd:Σκωτικὰ κελτικά
      grc:Ἀρχαῖα Ἑλληνικά
      he:Ἑβραϊκά
      hu:Οὑγγρικά
      hy:Ἀρμενικά
      id:Ἰνδονησιακά
      is:Ἰσλανδικά
      it:Ἰταλικά
      ja:Ἰαπωνικά
      mul:Πολλαπλές γλῶσσες
      nl:Ὁλλανδικά
      ota:Τουρκικά, ὀθωμανικὰ
      peo:Ἀρχαῖα περσικὰ
      sq:Ἀλβανικά
      uk:Οὐκρανικά
      yi:Ἰουδαϊκά
      """.trimIndent() }

  val en: String by lazy { """
      aa:Afar
      ab:Abkhazian
      ace:Acehnese
      ach:Acoli
      ada:Adangme
      ady:Adyghe
      ae:Avestan
      aeb:Tunisian Arabic
      af:Afrikaans
      afh:Afrihili
      agq:Aghem
      ain:Ainu
      ak:Akan
      akk:Akkadian
      akz:Alabama
      ale:Aleut
      aln:Gheg Albanian
      alt:Southern Altai
      am:Amharic
      an:Aragonese
      ang:Old English
      ann:Obolo
      anp:Angika
      ar:Arabic
      ar-001:Modern Standard Arabic
      arc:Aramaic
      arn:Mapuche
      aro:Araona
      arp:Arapaho
      arq:Algerian Arabic
      ars:Najdi Arabic
      ars-alt-menu:Arabic, Najdi
      arw:Arawak
      ary:Moroccan Arabic
      arz:Egyptian Arabic
      as:Assamese
      asa:Asu
      ase:American Sign Language
      ast:Asturian
      atj:Atikamekw
      av:Avaric
      avk:Kotava
      awa:Awadhi
      ay:Aymara
      az:Azerbaijani
      az-alt-short:Azeri
      ba:Bashkir
      bal:Baluchi
      ban:Balinese
      bar:Bavarian
      bas:Basaa
      bax:Bamun
      bbc:Batak Toba
      bbj:Ghomala
      be:Belarusian
      bej:Beja
      bem:Bemba
      bew:Betawi
      bez:Bena
      bfd:Bafut
      bfq:Badaga
      bg:Bulgarian
      bgc:Haryanvi
      bgn:Western Balochi
      bho:Bhojpuri
      bi:Bislama
      bik:Bikol
      bin:Bini
      bjn:Banjar
      bkm:Kom
      bla:Siksiká
      blo:Anii
      blt:Tai Dam
      bm:Bambara
      bn:Bangla
      bo:Tibetan
      bpy:Bishnupriya
      bqi:Bakhtiari
      br:Breton
      bra:Braj
      brh:Brahui
      brx:Bodo
      bs:Bosnian
      bss:Akoose
      bua:Buriat
      bug:Buginese
      bum:Bulu
      byn:Blin
      byv:Medumba
      ca:Catalan
      cad:Caddo
      car:Carib
      cay:Cayuga
      cch:Atsam
      ccp:Chakma
      ce:Chechen
      ceb:Cebuano
      cgg:Chiga
      ch:Chamorro
      chb:Chibcha
      chg:Chagatai
      chk:Chuukese
      chm:Mari
      chn:Chinook Jargon
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      cic:Chickasaw
      ckb:Central Kurdish
      ckb-alt-menu:Kurdish, Central
      ckb-alt-variant:Kurdish, Sorani
      clc:Chilcotin
      co:Corsican
      cop:Coptic
      cps:Capiznon
      cr:Cree
      crg:Michif
      crh:Crimean Tatar
      crj:Southern East Cree
      crk:Plains Cree
      crl:Northern East Cree
      crm:Moose Cree
      crr:Carolina Algonquian
      crs:Seselwa Creole French
      cs:Czech
      csb:Kashubian
      csw:Swampy Cree
      cu:Church Slavic
      cv:Chuvash
      cwd:Woods Cree
      cy:Welsh
      da:Danish
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:German
      de-AT:Austrian German
      de-CH:Swiss High German
      del:Delaware
      den:Slave
      dgr:Dogrib
      din:Dinka
      dje:Zarma
      doi:Dogri
      dsb:Lower Sorbian
      dtp:Central Dusun
      dua:Duala
      dum:Middle Dutch
      dv:Divehi
      dyo:Jola-Fonyi
      dyu:Dyula
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      egl:Emilian
      egy:Ancient Egyptian
      eka:Ekajuk
      el:Greek
      elx:Elamite
      en:English
      en-AU:Australian English
      en-CA:Canadian English
      en-GB:British English
      en-GB-alt-short:UK English
      en-US:American English
      en-US-alt-short:US English
      enm:Middle English
      eo:Esperanto
      es:Spanish
      es-419:Latin American Spanish
      es-ES:European Spanish
      es-MX:Mexican Spanish
      esu:Central Yupik
      et:Estonian
      eu:Basque
      ewo:Ewondo
      ext:Extremaduran
      fa:Persian
      fa-AF:Dari
      fan:Fang
      fat:Fanti
      ff:Fula
      fi:Finnish
      fil:Filipino
      fit:Tornedalen Finnish
      fj:Fijian
      fo:Faroese
      fon:Fon
      fr:French
      fr-CA:Canadian French
      fr-CH:Swiss French
      frc:Cajun French
      frm:Middle French
      fro:Old French
      frp:Arpitan
      frr:Northern Frisian
      frs:Eastern Frisian
      fur:Friulian
      fy:Western Frisian
      ga:Irish
      gaa:Ga
      gag:Gagauz
      gan:Gan Chinese
      gay:Gayo
      gba:Gbaya
      gbz:Zoroastrian Dari
      gd:Scottish Gaelic
      gez:Geez
      gil:Gilbertese
      gl:Galician
      glk:Gilaki
      gmh:Middle High German
      gn:Guarani
      goh:Old High German
      gon:Gondi
      gor:Gorontalo
      got:Gothic
      grb:Grebo
      grc:Ancient Greek
      gsw:Swiss German
      gu:Gujarati
      guc:Wayuu
      gur:Frafra
      guz:Gusii
      gv:Manx
      gwi:Gwichʼin
      ha:Hausa
      hai:Haida
      hak:Hakka Chinese
      haw:Hawaiian
      hax:Southern Haida
      hdn:Northern Haida
      he:Hebrew
      hi:Hindi
      hi-Latn:Hindi (Latin)
      hi-Latn-alt-variant:Hinglish
      hif:Fiji Hindi
      hil:Hiligaynon
      hit:Hittite
      hmn:Hmong
      hnj:Hmong Njua
      ho:Hiri Motu
      hr:Croatian
      hsb:Upper Sorbian
      hsn:Xiang Chinese
      ht:Haitian Creole
      hu:Hungarian
      hup:Hupa
      hur:Halkomelem
      hy:Armenian
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Indonesian
      ie:Interlingue
      ig:Igbo
      ii:Sichuan Yi
      ik:Inupiaq
      ike:Eastern Canadian Inuktitut
      ikt:Western Canadian Inuktitut
      ilo:Iloko
      inh:Ingush
      io:Ido
      is:Icelandic
      it:Italian
      iu:Inuktitut
      izh:Ingrian
      ja:Japanese
      jam:Jamaican Creole English
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jpr:Judeo-Persian
      jrb:Judeo-Arabic
      jut:Jutish
      jv:Javanese
      ka:Georgian
      kaa:Kara-Kalpak
      kab:Kabyle
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kaw:Kawi
      kbd:Kabardian
      kbl:Kanembu
      kcg:Tyap
      kde:Makonde
      kea:Kabuverdianu
      ken:Kenyang
      kfo:Koro
      kg:Kongo
      kgp:Kaingang
      kha:Khasi
      kho:Khotanese
      khq:Koyra Chiini
      khw:Khowar
      ki:Kikuyu
      kiu:Kirmanjki
      kj:Kuanyama
      kk:Kazakh
      kkj:Kako
      kl:Kalaallisut
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Korean
      koi:Komi-Permyak
      kok:Konkani
      kos:Kosraean
      kpe:Kpelle
      kr:Kanuri
      krc:Karachay-Balkar
      kri:Krio
      krj:Kinaray-a
      krl:Karelian
      kru:Kurukh
      ks:Kashmiri
      ksb:Shambala
      ksf:Bafia
      ksh:Colognian
      ku:Kurdish
      kum:Kumyk
      kut:Kutenai
      kv:Komi
      kw:Cornish
      kwk:Kwakʼwala
      kxv:Kuvi
      ky:Kyrgyz
      ky-alt-variant:Kirghiz
      la:Latin
      lad:Ladino
      lag:Langi
      lah:Western Panjabi
      lam:Lamba
      lb:Luxembourgish
      lez:Lezghian
      lfn:Lingua Franca Nova
      lg:Ganda
      li:Limburgish
      lij:Ligurian
      lil:Lillooet
      liv:Livonian
      lkt:Lakota
      lmo:Lombard
      ln:Lingala
      lo:Lao
      lol:Mongo
      lou:Louisiana Creole
      loz:Lozi
      lrc:Northern Luri
      lsm:Saamia
      lt:Lithuanian
      ltg:Latgalian
      lu:Luba-Katanga
      lua:Luba-Lulua
      lui:Luiseno
      lun:Lunda
      luo:Luo
      lus:Mizo
      luy:Luyia
      lv:Latvian
      lzh:Literary Chinese
      lzz:Laz
      mad:Madurese
      maf:Mafa
      mag:Magahi
      mai:Maithili
      mak:Makasar
      man:Mandingo
      mas:Masai
      mde:Maba
      mdf:Moksha
      mdr:Mandar
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagasy
      mga:Middle Irish
      mgh:Makhuwa-Meetto
      mgo:Metaʼ
      mh:Marshallese
      mi:Māori
      mic:Mi'kmaw
      min:Minangkabau
      mk:Macedonian
      ml:Malayalam
      mn:Mongolian
      mnc:Manchu
      mni:Manipuri
      moe:Innu-aimun
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      mrj:Western Mari
      ms:Malay
      mt:Maltese
      mua:Mundang
      mul:Multiple languages
      mus:Muscogee
      mus-alt-official:Mvskoke
      mwl:Mirandese
      mwr:Marwari
      mwv:Mentawai
      my:Burmese
      my-alt-variant:Myanmar Language
      mye:Myene
      myv:Erzya
      mzn:Mazanderani
      na:Nauru
      nan:Min Nan Chinese
      nap:Neapolitan
      naq:Nama
      nb:Norwegian Bokmål
      nd:North Ndebele
      nds:Low German
      nds-NL:Low Saxon
      ne:Nepali
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niuean
      njo:Ao Naga
      nl:Dutch
      nl-BE:Flemish
      nmg:Kwasio
      nn:Norwegian Nynorsk
      nnh:Ngiemboon
      no:Norwegian
      nog:Nogai
      non:Old Norse
      nov:Novial
      nqo:N’Ko
      nr:South Ndebele
      nso:Northern Sotho
      nus:Nuer
      nv:Navajo
      nwc:Classical Newari
      ny:Nyanja
      nym:Nyamwezi
      nyn:Nyankole
      nyo:Nyoro
      nzi:Nzima
      oc:Occitan
      oj:Ojibwa
      ojb:Northwestern Ojibwa
      ojc:Central Ojibwa
      ojg:Eastern Ojibwa
      ojs:Oji-Cree
      ojw:Western Ojibwa
      oka:Okanagan
      om:Oromo
      or:Odia
      os:Ossetic
      osa:Osage
      ota:Ottoman Turkish
      pa:Punjabi
      pag:Pangasinan
      pal:Pahlavi
      pam:Pampanga
      pap:Papiamento
      pau:Palauan
      pcd:Picard
      pcm:Nigerian Pidgin
      pdc:Pennsylvania German
      pdt:Plautdietsch
      peo:Old Persian
      pfl:Palatine German
      phn:Phoenician
      pi:Pali
      pis:Pijin
      pl:Polish
      pms:Piedmontese
      pnt:Pontic
      pon:Pohnpeian
      pqm:Maliseet-Passamaquoddy
      prg:Prussian
      pro:Old Provençal
      ps:Pashto
      ps-alt-variant:Pushto
      pt:Portuguese
      pt-BR:Brazilian Portuguese
      pt-PT:European Portuguese
      qu:Quechua
      quc:Kʼicheʼ
      qug:Chimborazo Highland Quichua
      raj:Rajasthani
      rap:Rapanui
      rar:Rarotongan
      rgn:Romagnol
      rhg:Rohingya
      rif:Riffian
      rm:Romansh
      rn:Rundi
      ro:Romanian
      ro-MD:Moldavian
      rof:Rombo
      rom:Romany
      rtm:Rotuman
      ru:Russian
      rue:Rusyn
      rug:Roviana
      rup:Aromanian
      rw:Kinyarwanda
      rwk:Rwa
      sa:Sanskrit
      sad:Sandawe
      sah:Yakut
      sam:Samaritan Aramaic
      saq:Samburu
      sas:Sasak
      sat:Santali
      saz:Saurashtra
      sba:Ngambay
      sbp:Sangu
      sc:Sardinian
      scn:Sicilian
      sco:Scots
      sd:Sindhi
      sdc:Sassarese Sardinian
      sdh:Southern Kurdish
      se:Northern Sami
      se-alt-menu:Sami, Northern
      see:Seneca
      seh:Sena
      sei:Seri
      sel:Selkup
      ses:Koyraboro Senni
      sg:Sango
      sga:Old Irish
      sgs:Samogitian
      sh:Serbo-Croatian
      shi:Tachelhit
      shn:Shan
      shu:Chadian Arabic
      si:Sinhala
      sid:Sidamo
      sk:Slovak
      sl:Slovenian
      slh:Southern Lushootseed
      sli:Lower Silesian
      sly:Selayar
      sm:Samoan
      sma:Southern Sami
      sma-alt-menu:Sami, Southern
      smj:Lule Sami
      smj-alt-menu:Sami, Lule
      smn:Inari Sami
      smn-alt-menu:Sami, Inari
      sms:Skolt Sami
      sms-alt-menu:Sami, Skolt
      sn:Shona
      snk:Soninke
      so:Somali
      sog:Sogdien
      sq:Albanian
      sr:Serbian
      sr-ME:Montenegrin
      srn:Sranan Tongo
      srr:Serer
      ss:Swati
      ssy:Saho
      st:Southern Sotho
      stq:Saterland Frisian
      str:Straits Salish
      su:Sundanese
      suk:Sukuma
      sus:Susu
      sux:Sumerian
      sv:Swedish
      sw:Swahili
      sw-CD:Congo Swahili
      swb:Comorian
      syc:Classical Syriac
      syr:Syriac
      szl:Silesian
      ta:Tamil
      tce:Southern Tutchone
      tcy:Tulu
      te:Telugu
      tem:Timne
      teo:Teso
      ter:Tereno
      tet:Tetum
      tg:Tajik
      tgx:Tagish
      th:Thai
      tht:Tahltan
      ti:Tigrinya
      tig:Tigre
      tiv:Tiv
      tk:Turkmen
      tkl:Tokelau
      tkr:Tsakhur
      tl:Tagalog
      tlh:Klingon
      tli:Tlingit
      tly:Talysh
      tmh:Tamashek
      tn:Tswana
      to:Tongan
      tog:Nyasa Tonga
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Turkish
      tru:Turoyo
      trv:Taroko
      trw:Torwali
      ts:Tsonga
      tsd:Tsakonian
      tsi:Tsimshian
      tt:Tatar
      ttm:Northern Tutchone
      ttt:Muslim Tat
      tum:Tumbuka
      tvl:Tuvalu
      tw:Twi
      twq:Tasawaq
      ty:Tahitian
      tyv:Tuvinian
      tzm:Central Atlas Tamazight
      udm:Udmurt
      ug:Uyghur
      ug-alt-variant:Uighur
      uga:Ugaritic
      uk:Ukrainian
      umb:Umbundu
      und:Unknown language
      ur:Urdu
      uz:Uzbek
      vai:Vai
      ve:Venda
      vec:Venetian
      vep:Veps
      vi:Vietnamese
      vls:West Flemish
      vmf:Main-Franconian
      vmw:Makhuwa
      vo:Volapük
      vot:Votic
      vro:Võro
      vun:Vunjo
      wa:Walloon
      wae:Walser
      wal:Wolaytta
      war:Waray
      was:Washo
      wbp:Warlpiri
      wo:Wolof
      wuu:Wu Chinese
      xal:Kalmyk
      xh:Xhosa
      xmf:Mingrelian
      xnr:Kangri
      xog:Soga
      yao:Yao
      yap:Yapese
      yav:Yangben
      ybb:Yemba
      yi:Yiddish
      yo:Yoruba
      yrl:Nheengatu
      yue:Cantonese
      yue-alt-menu:Chinese, Cantonese
      za:Zhuang
      zap:Zapotec
      zbl:Blissymbols
      zea:Zeelandic
      zen:Zenaga
      zgh:Standard Moroccan Tamazight
      zh:Chinese
      zh-alt-long:Mandarin Chinese
      zh-alt-menu:Chinese, Mandarin
      zh-Hans:Simplified Chinese
      zh-Hans-alt-long:Simplified Mandarin Chinese
      zh-Hant:Traditional Chinese
      zh-Hant-alt-long:Traditional Mandarin Chinese
      zu:Zulu
      zun:Zuni
      zxx:No linguistic content
      zza:Zaza
      """.trimIndent() }

  val en_001: String by lazy { """
      bla:Siksika
      mus:Creek
      nds-NL:West Low German
      """.trimIndent() }

  val en_150: String? = null

  val en_AE: String? = null

  val en_AG: String? = null

  val en_AI: String? = null

  val en_AS: String? = null

  val en_AT: String? = null

  val en_AU: String by lazy { """
      bn:Bengali
      ckb-alt-menu:Kurdish (Central)
      ckb-alt-variant:Kurdish (Sorani)
      en-US:United States English
      ro-MD:Moldovan
      """.trimIndent() }

  val en_BB: String? = null

  val en_BE: String? = null

  val en_BI: String? = null

  val en_BM: String? = null

  val en_BS: String? = null

  val en_BW: String? = null

  val en_BZ: String? = null

  val en_CA: String by lazy { """
      ar-001:Arabic (Modern Standard)
      bn:Bengali
      mfe:Mauritian Creole
      my-alt-variant:Myanmar language
      nds-NL:West Low German
      ro-MD:Moldovan
      """.trimIndent() }

  val en_CC: String? = null

  val en_CH: String? = null

  val en_CK: String? = null

  val en_CM: String? = null

  val en_CX: String? = null

  val en_CY: String? = null

  val en_DE: String? = null

  val en_DG: String? = null

  val en_DK: String? = null

  val en_DM: String? = null

  val en_Dsrt: String by lazy { """
      an:𐐈𐑉𐐲𐑀𐐱𐑌𐐨𐑆
      ar:𐐇𐑉𐐲𐐺𐐮𐐿
      br:𐐒𐑉𐐯𐐻𐐲𐑌
      byn:𐐒𐑊𐐮𐑌
      ca:𐐗𐐪𐐻𐐲𐑊𐐪𐑌
      chr:𐐕𐐯𐑉𐐬𐐿𐐨
      chy:𐐟𐐴𐐰𐑌
      co:𐐗𐐬𐑉𐑅𐐮𐐿𐐲𐑌
      cop:𐐗𐐬𐐹𐐻𐐮𐐿
      cr:𐐗𐑉𐐨
      cs:𐐕𐐯𐐿
      cy:𐐎𐐯𐑊𐑇
      da:𐐔𐐩𐑌𐐮𐑇
      dak:𐐔𐐲𐐿𐐬𐐻𐐲
      de:𐐖𐐲𐑉𐑋𐑌𐐲
      dsb:𐐢𐐬𐐲𐑉 𐐝𐐬𐑉𐐺𐐨𐐲𐑌
      dum:𐐣𐐮𐐼𐐲𐑊 𐐔𐐲𐐽
      egy:𐐁𐑌𐐽𐐲𐑌𐐻 𐐀𐐾𐐮𐐹𐐽𐐲𐑌
      el:𐐘𐑉𐐨𐐿
      en:𐐀𐑍𐑊𐐮𐑇
      enm:𐐣𐐮𐐼𐐲𐑊 𐐀𐑍𐑊𐐮𐑇
      eo:𐐇𐑅𐐹𐐯𐑉𐐪𐑌𐐻𐐬
      es:𐐝𐐹𐐰𐑌𐐮𐑇
      et:𐐀𐑅𐐻𐐬𐑌𐐨𐐲𐑌
      eu:𐐒𐐰𐑅𐐿
      fr:𐐙𐑉𐐯𐑌𐐽
      frm:𐐣𐐮𐐼𐐲𐑊 𐐙𐑉𐐯𐑌𐐽
      ga:𐐌𐑉𐐮𐑇
      gil:𐐘𐐮𐑊𐐺𐐯𐑉𐐻𐐨𐑆
      gmh:𐐣𐐮𐐼𐐲𐑊 𐐐𐐴 𐐖𐐲𐑉𐑋𐐲𐑌
      got:𐐘𐐱𐑃𐐮𐐿
      grc:𐐁𐑌𐐽𐐲𐑌𐐻 𐐘𐑉𐐨𐐿
      gv:𐐣𐐰𐑌𐐿𐑅
      haw:𐐐𐐲𐐶𐐴𐐲𐑌
      hi:𐐐𐐮𐑌𐐼𐐨
      hit:𐐐𐐮𐐻𐐴𐐻
      hr:𐐗𐑉𐐬𐐩𐑇𐐲𐑌
      ht:𐐐𐐩𐑇𐐲𐑌
      hy:𐐂𐑉𐑋𐐨𐑌𐐨𐐲𐑌
      ia:𐐆𐑌𐐻𐐲𐑉𐑊𐐮𐑍𐐶𐐲
      id:𐐆𐑌𐐼𐐬𐑌𐐨𐑈𐐲𐑌
      is:𐐌𐑅𐑊𐐰𐑌𐐼𐐮𐐿
      it:𐐆𐐻𐐰𐑊𐐷𐐲𐑌
      ja:𐐖𐐰𐐹𐐲𐑌𐐨𐑆
      jpr:𐐖𐐭𐐼𐐨𐐬-𐐑𐐯𐑉𐑈𐐲𐑌
      jrb:𐐖𐐭𐐼𐐨𐐬-𐐈𐑉𐐲𐐺𐐮𐐿
      jv:𐐖𐐪𐑂𐐲𐑌𐐨𐑆
      ka:𐐖𐐬𐑉𐐾𐐲𐑌
      km:𐐗𐐲𐑋𐐯𐑉
      ko:𐐗𐐬𐑉𐐨𐐲𐑌
      ku:𐐗𐐲𐑉𐐼𐐮𐑇
      kut:𐐢𐐰𐐼𐐨𐑌𐐬
      kw:𐐗𐐬𐑉𐑌𐐮𐑇
      la:𐐢𐐰𐐻𐐮𐑌
      lb:𐐢𐐲𐐿𐑅𐐯𐑋𐐺𐐲𐑉𐑀𐐮𐑇
      lo:𐐢𐐵
      lv:𐐢𐐰𐐻𐑂𐐨𐐲𐑌
      mga:𐐣𐐮𐐼𐐲𐑊 𐐌𐑉𐐮𐑇
      mi:𐐣𐐵𐑉𐐨
      mk:𐐣𐐰𐑅𐐯𐐼𐐬𐑌𐐨𐐲𐑌
      mn:𐐣𐐱𐑍𐐬𐑊𐐨𐐲𐑌
      mnc:𐐣𐐰𐑌𐐽𐐭
      moh:𐐐𐐬𐐸𐐪𐐿
      mul:𐐣𐐲𐑊𐐻𐐮𐐹𐐲𐑊 𐐢𐐩𐑍𐐶𐐮𐐾𐐲𐑆
      mus:𐐗𐑉𐐨𐐿
      my:𐐒𐐲𐑉𐑋𐐨𐑆
      nap:𐐤𐐨𐐲𐐹𐐱𐑊𐐮𐐻𐐲𐑌
      nds:𐐢𐐬 𐐖𐐯𐑉𐑋𐐲𐑌
      nl:𐐔𐐲𐐽
      nv:𐐤𐐪𐑂𐐲𐐸𐐬
      ro-MD:𐐣𐐬𐑊𐐼𐐩𐑂𐐨𐐲𐑌
      tlh:𐐗𐑊𐐮𐑍𐐱𐑌
      zbl:𐐒𐑊𐐮𐑅-𐑅𐐮𐑋𐐺𐐲𐑊𐑆
      zh:𐐕𐐴𐑌𐐨𐑆
      zh-alt-menu:𐐕𐐴𐑌𐐨𐑆
      zxx:𐐤𐐬 𐑊𐐨𐑍𐐶𐐮𐑅𐐻𐐮𐐿 𐐿𐐱𐑌𐐻𐐯𐑌𐐻
      """.trimIndent() }

  val en_ER: String? = null

  val en_FI: String? = null

  val en_FJ: String? = null

  val en_FK: String? = null

  val en_FM: String? = null

  val en_GB: String by lazy { """
      ff:Fulah
      """.trimIndent() }

  val en_GD: String? = null

  val en_GG: String? = null

  val en_GH: String? = null

  val en_GI: String? = null

  val en_GM: String? = null

  val en_GU: String? = null

  val en_GY: String? = null

  val en_HK: String? = null

  val en_ID: String? = null

  val en_IE: String? = null

  val en_IL: String? = null

  val en_IM: String? = null

  val en_IN: String by lazy { """
      bn:Bengali
      """.trimIndent() }

  val en_IO: String? = null

  val en_JE: String? = null

  val en_JM: String? = null

  val en_KE: String? = null

  val en_KI: String? = null

  val en_KN: String? = null

  val en_KY: String? = null

  val en_LC: String? = null

  val en_LR: String? = null

  val en_LS: String? = null

  val en_MG: String? = null

  val en_MH: String? = null

  val en_MO: String? = null

  val en_MP: String? = null

  val en_MS: String? = null

  val en_MT: String? = null

  val en_MU: String? = null

  val en_MV: String? = null

  val en_MW: String? = null

  val en_MY: String? = null

  val en_NA: String? = null

  val en_NF: String? = null

  val en_NG: String? = null

  val en_NL: String? = null

  val en_NR: String? = null

  val en_NU: String? = null

  val en_NZ: String? = null

  val en_PG: String? = null

  val en_PH: String? = null

  val en_PK: String? = null

  val en_PN: String? = null

  val en_PR: String? = null

  val en_PW: String? = null

  val en_RW: String? = null

  val en_SB: String? = null

  val en_SC: String? = null

  val en_SD: String? = null

  val en_SE: String? = null

  val en_SG: String? = null

  val en_SH: String? = null

  val en_SI: String? = null

  val en_SL: String? = null

  val en_SS: String? = null

  val en_SX: String? = null

  val en_SZ: String? = null

  val en_TC: String? = null

  val en_TK: String? = null

  val en_TO: String? = null

  val en_TT: String? = null

  val en_TV: String? = null

  val en_TZ: String? = null

  val en_UG: String? = null

  val en_UM: String? = null

  val en_VC: String? = null

  val en_VG: String? = null

  val en_VI: String? = null

  val en_VU: String? = null

  val en_WS: String? = null

  val en_ZA: String? = null

  val en_ZM: String? = null

  val en_ZW: String? = null

  val eo: String by lazy { """
      aa:afara
      ab:abĥaza
      af:afrikansa
      am:amhara
      ar:araba
      as:asama
      ay:ajmara
      az:azerbajĝana
      az-alt-short:azerbajĝana
      ba:baŝkira
      be:belorusa
      bg:bulgara
      bi:bislamo
      bn:bengala
      bo:tibeta
      br:bretona
      bs:bosna
      ca:kataluna
      co:korsika
      cs:ĉeĥa
      cy:kimra
      da:dana
      de:germana
      dv:maldiva
      dz:dzonko
      efi:ibibioefika
      el:greka
      en:angla
      eo:Esperanto
      es:hispana
      et:estona
      eu:eŭska
      fa:persa
      fi:finna
      fil:filipina
      fj:fiĝia
      fo:feroa
      fr:franca
      fy:okcident-frisa
      ga:irlanda
      gaa:gaa
      gd:skot-gaela
      gl:galega
      gn:gvarania
      gu:guĝarata
      ha:haŭsa
      haw:havaja
      he:hebrea
      hi:hinda
      hr:kroata
      ht:haitia kreola
      hu:hungara
      hy:armena
      ia:Interlingvao
      id:indonezia
      ie:Interlingveo
      ik:eskima
      is:islanda
      it:itala
      iu:inuita
      ja:japana
      jv:java
      ka:kartvela
      kk:kazaĥa
      kl:gronlanda
      km:kmera
      kn:kanara
      ko:korea
      ks:kaŝmira
      ku:kurda
      ky:kirgiza
      la:latino
      lb:luksemburga
      ln:lingala
      lo:laŭa
      lt:litova
      lv:latva
      mg:malagasa
      mi:maoria
      mk:makedona
      ml:malajalama
      mn:mongola
      mr:marata
      ms:malaja
      mt:malta
      my:birma
      na:naura
      nb:dannorvega
      ne:nepala
      nl:nederlanda
      nn:novnorvega
      no:norvega
      oc:okcitana
      om:oroma
      or:orijo
      pa:panĝaba
      pl:pola
      ps:paŝtua
      pt:portugala
      pt-BR:portugala brazila
      pt-PT:portugala eŭropa
      qu:keĉua
      rm:romanĉa
      rn:burunda
      ro:rumana
      ru:rusa
      rw:ruanda
      sa:sanskrito
      sd:sinda
      sg:sangoa
      sh:serbo-Kroata
      si:sinhala
      sk:slovaka
      sl:slovena
      sm:samoa
      sn:ŝona
      so:somala
      sq:albana
      sr:serba
      ss:svazia
      st:sota
      su:sunda
      sv:sveda
      sw:svahila
      ta:tamila
      te:telugua
      tg:taĝika
      th:taja
      ti:tigraja
      tk:turkmena
      tl:tagaloga
      tlh:klingona
      tn:cvana
      to:tongana
      tr:turka
      ts:conga
      tt:tatara
      ug:ujgura
      uk:ukraina
      und:nekonata lingvo
      ur:urduo
      uz:uzbeka
      vi:vjetnama
      vo:Volapuko
      wo:volofa
      xh:ksosa
      yi:jida
      yo:joruba
      za:ĝuanga
      zh:ĉina
      zh-alt-menu:ĉina
      zh-Hans:ĉina simpligita
      zh-Hans-alt-long:ĉina simpligita
      zh-Hant:ĉina tradicia
      zh-Hant-alt-long:ĉina tradicia
      zu:zulua
      zxx:nelingvaĵo
      """.trimIndent() }

  val es: String by lazy { """
      aa:afar
      ab:abjasio
      ace:achenés
      ach:acoli
      ada:adangme
      ady:adigué
      ae:avéstico
      af:afrikáans
      afh:afrihili
      agq:aghem
      ain:ainu
      ak:akan
      akk:acadio
      ale:aleutiano
      alt:altái meridional
      am:amárico
      an:aragonés
      ang:inglés antiguo
      ann:obolo
      anp:angika
      ar:árabe
      ar-001:árabe estándar moderno
      arc:arameo
      arn:mapuche
      arp:arapaho
      ars:árabe najdí
      arw:arahuaco
      as:asamés
      asa:asu
      ast:asturiano
      atj:atikamekw
      av:avar
      awa:avadhi
      ay:aimara
      az:azerbaiyano
      az-alt-short:azerí
      ba:baskir
      bal:baluchi
      ban:balinés
      bas:basaa
      bax:bamún
      bbj:ghomala
      be:bielorruso
      bej:beja
      bem:bemba
      bez:bena
      bfd:bafut
      bg:búlgaro
      bgc:haryanvi
      bgn:baluchi occidental
      bho:bhoyapurí
      bi:bislama
      bik:bicol
      bin:bini
      bkm:kom
      bla:siksika
      blo:anii
      bm:bambara
      bn:bengalí
      bo:tibetano
      br:bretón
      bra:braj
      brx:bodo
      bs:bosnio
      bss:akoose
      bua:buriato
      bug:buginés
      bum:bulu
      byn:blin
      byv:medumba
      ca:catalán
      cad:caddo
      car:caribe
      cay:cayuga
      cch:atsam
      ccp:chakma
      ce:checheno
      ceb:cebuano
      cgg:chiga
      ch:chamorro
      chb:chibcha
      chg:chagatái
      chk:trukés
      chm:marí
      chn:jerga chinuk
      cho:choctaw
      chp:chipewyan
      chr:cheroqui
      chy:cheyene
      ckb:kurdo sorani
      ckb-alt-menu:kurdo sorani
      ckb-alt-variant:kurdo central
      clc:chilcotin
      co:corso
      cop:copto
      cr:cree
      crg:michif
      crh:tártaro de Crimea
      crj:cree suroriental
      crk:cree de las llanuras
      crl:cree nororiental
      crm:cree moose
      crr:algonquino de Carolina
      crs:criollo seychelense
      cs:checo
      csb:casubio
      csw:cree de los pantanos
      cu:eslavo eclesiástico
      cv:chuvasio
      cy:galés
      da:danés
      dak:dakota
      dar:dargva
      dav:taita
      de:alemán
      de-AT:alemán austríaco
      de-CH:alto alemán suizo
      del:delaware
      den:slave
      dgr:dogrib
      din:dinka
      dje:zarma
      doi:dogri
      dsb:bajo sorbio
      dua:duala
      dum:neerlandés medio
      dv:divehi
      dyo:jola-fonyi
      dyu:diula
      dz:dzongkha
      dzg:dazaga
      ebu:embu
      ee:ewé
      efi:efik
      egy:egipcio antiguo
      eka:ekajuk
      el:griego
      elx:elamita
      en:inglés
      en-AU:inglés australiano
      en-CA:inglés canadiense
      en-GB:inglés británico
      en-GB-alt-short:inglés (RU)
      en-US:inglés estadounidense
      en-US-alt-short:inglés (EE. UU.)
      enm:inglés medio
      eo:esperanto
      es:español
      es-419:español latinoamericano
      es-ES:español de España
      es-MX:español de México
      et:estonio
      eu:euskera
      ewo:ewondo
      fa:persa
      fa-AF:darí
      fan:fang
      fat:fanti
      ff:fula
      fi:finés
      fil:filipino
      fj:fiyiano
      fo:feroés
      fon:fon
      fr:francés
      fr-CA:francés canadiense
      fr-CH:francés suizo
      frc:francés cajún
      frm:francés medio
      fro:francés antiguo
      frr:frisón septentrional
      frs:frisón oriental
      fur:friulano
      fy:frisón occidental
      ga:irlandés
      gaa:ga
      gag:gagauzo
      gan:chino gan
      gay:gayo
      gba:gbaya
      gd:gaélico escocés
      gez:geez
      gil:gilbertés
      gl:gallego
      gmh:alto alemán medio
      gn:guaraní
      goh:alto alemán antiguo
      gon:gondi
      gor:gorontalo
      got:gótico
      grb:grebo
      grc:griego antiguo
      gsw:alemán suizo
      gu:guyaratí
      guz:gusii
      gv:manés
      gwi:kutchin
      ha:hausa
      hai:haida
      hak:chino hakka
      haw:hawaiano
      hax:haida meridional
      he:hebreo
      hi:hindi
      hi-Latn-alt-variant:hinglish
      hil:hiligaynon
      hit:hitita
      hmn:hmong
      ho:hiri motu
      hr:croata
      hsb:alto sorbio
      hsn:chino xiang
      ht:criollo haitiano
      hu:húngaro
      hup:hupa
      hur:halkomelem
      hy:armenio
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonesio
      ie:interlingue
      ig:igbo
      ii:yi de Sichuán
      ik:inupiaq
      ikt:inuit del oeste de Canadá
      ilo:ilocano
      inh:ingush
      io:ido
      is:islandés
      it:italiano
      iu:inuktitut
      ja:japonés
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jpr:judeo-persa
      jrb:judeo-árabe
      jv:javanés
      ka:georgiano
      kaa:karakalpako
      kab:cabileño
      kac:kachin
      kaj:jju
      kam:kamba
      kaw:kawi
      kbd:kabardiano
      kbl:kanembu
      kcg:tyap
      kde:makonde
      kea:criollo caboverdiano
      kfo:koro
      kg:kongo
      kgp:káingang
      kha:khasi
      kho:kotanés
      khq:koyra chiini
      ki:kikuyu
      kj:kuanyama
      kk:kazajo
      kkj:kako
      kl:groenlandés
      kln:kalenjin
      km:jemer
      kmb:kimbundu
      kn:canarés
      ko:coreano
      koi:komi permio
      kok:konkaní
      kos:kosraeano
      kpe:kpelle
      kr:kanuri
      krc:karachay-balkar
      krl:carelio
      kru:kurukh
      ks:cachemir
      ksb:shambala
      ksf:bafia
      ksh:kölsch
      ku:kurdo
      kum:kumyk
      kut:kutenai
      kv:komi
      kw:córnico
      kwk:kwakʼwala
      kxv:kuvi
      ky:kirguís
      la:latín
      lad:ladino
      lag:langi
      lah:lahnda
      lam:lamba
      lb:luxemburgués
      lez:lezgiano
      lg:ganda
      li:limburgués
      lij:ligur
      lil:lillooet
      lkt:lakota
      lmo:lombardo
      ln:lingala
      lo:lao
      lol:mongo
      lou:criollo de Luisiana
      loz:lozi
      lrc:lorí septentrional
      lsm:samia
      lt:lituano
      lu:luba-katanga
      lua:luba-lulua
      lui:luiseño
      lun:lunda
      lus:mizo
      luy:luyia
      lv:letón
      mad:madurés
      maf:mafa
      mag:magahi
      mai:maithili
      mak:macasar
      man:mandingo
      mas:masái
      mde:maba
      mdf:moksha
      mdr:mandar
      men:mende
      mer:meru
      mfe:criollo mauriciano
      mg:malgache
      mga:irlandés medio
      mgh:makhuwa-meetto
      mgo:meta’
      mh:marshalés
      mi:maorí
      mic:micmac
      min:minangkabau
      mk:macedonio
      ml:malayálam
      mn:mongol
      mnc:manchú
      mni:manipurí
      moe:innu-aimun
      moh:mohawk
      mos:mossi
      mr:maratí
      ms:malayo
      mt:maltés
      mua:mundang
      mul:varios idiomas
      mus:creek
      mwl:mirandés
      mwr:marwari
      my:birmano
      mye:myene
      myv:erzya
      mzn:mazandaraní
      na:nauruano
      nan:chino min nan
      nap:napolitano
      naq:nama
      nb:noruego bokmal
      nd:ndebele septentrional
      nds:bajo alemán
      nds-NL:bajo sajón
      ne:nepalí
      new:nevarí
      ng:ndonga
      nia:nias
      niu:niueano
      nl:neerlandés
      nl-BE:flamenco
      nmg:kwasio
      nn:noruego nynorsk
      nnh:ngiemboon
      no:noruego
      nog:nogai
      non:nórdico antiguo
      nqo:n’ko
      nr:ndebele meridional
      nso:sotho septentrional
      nus:nuer
      nv:navajo
      nwc:newari clásico
      ny:nyanja
      nym:nyamwezi
      nyn:nyankole
      nyo:nyoro
      nzi:nzima
      oc:occitano
      oj:ojibwa
      ojb:ojibwa noroccidental
      ojc:ojibwa central
      ojs:oji-cree
      ojw:ojibwa occidental
      oka:okanagan
      om:oromo
      or:oriya
      os:osético
      osa:osage
      ota:turco otomano
      pa:punyabí
      pag:pangasinán
      pal:pahlavi
      pam:pampanga
      pap:papiamento
      pau:palauano
      pcm:pidgin de Nigeria
      peo:persa antiguo
      phn:fenicio
      pi:pali
      pis:pidgin salomonense
      pl:polaco
      pon:pohnpeiano
      pqm:maliseet-passamaquoddy
      prg:prusiano
      pro:provenzal antiguo
      ps:pastún
      ps-alt-variant:pastú
      pt:portugués
      pt-BR:portugués de Brasil
      pt-PT:portugués de Portugal
      qu:quechua
      quc:quiché
      raj:rajasthani
      rap:rapanui
      rar:rarotongano
      rhg:rohinyá
      rm:romanche
      rn:kirundi
      ro:rumano
      ro-MD:moldavo
      rof:rombo
      rom:romaní
      ru:ruso
      rup:arrumano
      rw:kinyarwanda
      rwk:rwa
      sa:sánscrito
      sad:sandawe
      sah:sakha
      sam:arameo samaritano
      saq:samburu
      sas:sasak
      sat:santali
      sba:ngambay
      sbp:sangu
      sc:sardo
      scn:siciliano
      sco:escocés
      sd:sindi
      sdh:kurdo meridional
      se:sami septentrional
      see:seneca
      seh:sena
      sel:selkup
      ses:koyraboro senni
      sg:sango
      sga:irlandés antiguo
      sh:serbocroata
      shi:tashelhit
      shn:shan
      shu:árabe chadiano
      si:cingalés
      sid:sidamo
      sk:eslovaco
      sl:esloveno
      slh:lushootseed meridional
      sm:samoano
      sma:sami meridional
      smj:sami lule
      smn:sami inari
      sms:sami skolt
      sn:shona
      snk:soninké
      so:somalí
      sog:sogdiano
      sq:albanés
      sr:serbio
      srn:sranan tongo
      srr:serer
      ss:suazi
      ssy:saho
      st:sotho meridional
      str:salish de los estrechos
      su:sundanés
      suk:sukuma
      sus:susu
      sux:sumerio
      sv:sueco
      sw:suajili
      sw-CD:suajili del Congo
      swb:comorense
      syc:siríaco clásico
      syr:siriaco
      szl:silesio
      ta:tamil
      tce:tutchone meridional
      te:telugu
      tem:temne
      teo:teso
      ter:tereno
      tet:tetún
      tg:tayiko
      tgx:tagish
      th:tailandés
      tht:tahltan
      ti:tigriña
      tig:tigré
      tiv:tiv
      tk:turcomano
      tkl:tokelauano
      tl:tagalo
      tlh:klingon
      tli:tlingit
      tmh:tamashek
      tn:setsuana
      to:tongano
      tog:tonga del Nyasa
      tok:toki pona
      tpi:tok pisin
      tr:turco
      trv:taroko
      ts:tsonga
      tsi:tsimshiano
      tt:tártaro
      ttm:tutchone septentrional
      tum:tumbuka
      tvl:tuvaluano
      tw:twi
      twq:tasawaq
      ty:tahitiano
      tyv:tuviniano
      tzm:tamazight del Atlas Central
      udm:udmurt
      ug:uigur
      ug-alt-variant:uygur
      uga:ugarítico
      uk:ucraniano
      umb:umbundu
      und:lengua desconocida
      ur:urdu
      uz:uzbeko
      ve:venda
      vec:veneciano
      vi:vietnamita
      vmw:makua
      vo:volapük
      vot:vótico
      vun:vunjo
      wa:valón
      wae:walser
      wal:wolayta
      war:waray
      was:washo
      wbp:warlpiri
      wo:wólof
      wuu:chino wu
      xal:kalmyk
      xh:xhosa
      xnr:kangri
      xog:soga
      yao:yao
      yap:yapés
      yav:yangben
      ybb:yemba
      yi:yidis
      yo:yoruba
      yrl:ñe’engatú
      yue:cantonés
      yue-alt-menu:chino cantonés
      za:zhuang
      zap:zapoteco
      zbl:símbolos Bliss
      zen:zenaga
      zgh:tamazight estándar marroquí
      zh:chino
      zh-alt-menu:chino mandarín
      zh-Hans:chino simplificado
      zh-Hans-alt-long:chino mandarín simplificado
      zh-Hant:chino tradicional
      zh-Hant-alt-long:chino mandarín tradicional
      zu:zulú
      zun:zuñi
      zxx:sin contenido lingüístico
      zza:zazaki
      """.trimIndent() }

  val es_419: String by lazy { """
      ady:adigeo
      alt:altái del sur
      arp:arapajó
      ars:árabe de Néyed
      bla:siksiká
      eu:vasco
      goh:alemán de la alta edad antigua
      grc:griego clásico
      gu:gujarati
      ht:haitiano
      kbd:cabardiano
      krc:karachái-bálkaro
      ks:cachemiro
      lij:genovés
      ml:malabar
      mni:manipuri
      nr:ndebele del sur
      nso:sesotho del norte
      pa:panyabí
      prg:prusiano antiguo
      ps-alt-variant:pashtún
      rm:retorrománico
      sd:sindhi
      shu:árabe (Chad)
      sma:sami del sur
      st:sesotho del sur
      sw:swahili
      sw-CD:swahili (Congo)
      syr:siríaco
      tet:tetun
      tyv:tuvano
      ug-alt-variant:uighur
      vec:véneto
      wal:walamo
      wuu:wu
      xal:calmuco
      zun:zuni
      """.trimIndent() }

  val es_AR: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_BO: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_BR: String? = null

  val es_BZ: String? = null

  val es_CL: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_CO: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_CR: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_CU: String? = null

  val es_DO: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_EA: String? = null

  val es_EC: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_GQ: String? = null

  val es_GT: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_HN: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_IC: String? = null

  val es_MX: String by lazy { """
      ace:acehnés
      ady:adigué
      arp:arapaho
      ars:árabe neyedí
      bas:basa
      bax:bamun
      bho:bhoshpuri
      bla:siksika
      bua:buriat
      ckb-alt-menu:kurdo del centro
      crj:cree del sureste
      crl:cree del noreste
      crr:carolina algonquian
      dar:darguin
      dum:neerlandés medieval
      en-GB-alt-short:inglés (R. U.)
      enm:inglés medieval
      eu:euskera
      frm:francés medieval
      gan:gan (China)
      gmh:alemán de la alta edad media
      grc:griego antiguo
      hak:kejia (China)
      hax:haida del sur
      hil:hiligainón
      hsn:xiang (China)
      ikt:inuktitut del oeste de Canadá
      inh:ingusetio
      kbd:kabardiano
      kgp:kaingang
      krc:karachái bálkaro
      kum:cumuco
      mga:irlandés medieval
      nan:min nan (Chino)
      nr:ndebele meridional
      nso:sotho septentrional
      ojb:ojibwa del noroeste
      ojw:ojibwa del oeste
      pa:punyabí
      shu:árabe chadiano
      slh:lushootseed del sur
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      syr:siriaco
      tce:tutchone del sur
      ug-alt-variant:uyghur
      wuu:chino wu
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_NI: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_PA: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_PE: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_PH: String? = null

  val es_PR: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      grc:griego antiguo
      nso:sotho septentrional
      ss:siswati
      wo:wolof
      """.trimIndent() }

  val es_PY: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val es_SV: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      grc:griego antiguo
      nso:sotho septentrional
      ss:siswati
      wo:wolof
      """.trimIndent() }

  val es_US: String by lazy { """
      ace:acehnés
      alt:altái meridional
      arp:arapaho
      ars:árabe najdi
      bax:bamun
      bgc:hariana
      bho:bhojpuri
      bla:siksika
      blo:ani
      bua:buriat
      clc:chilcotín
      crj:cree del sureste
      crl:cree del noreste
      crm:moose cree
      crr:algonquian
      dum:neerlandés medieval
      enm:inglés medieval
      eu:euskera
      frm:francés medieval
      gan:gan (China)
      gmh:alemán de la alta edad media
      grc:griego antiguo
      gu:gurayatí
      hax:haida del sur
      hil:hiligainón
      hsn:xiang (China)
      ht:criollo haitiano
      ikt:inuktitut del oeste de Canadá
      inh:ingusetio
      kab:cabilio
      krc:karachay-balkar
      lij:ligur
      lou:creole de Luisiana
      lrc:lorí del norte
      lsm:saamia
      mga:irlandés medieval
      nd:ndebele del norte
      nr:ndebele meridional
      ojb:ojibwa del noroeste
      ojw:ojibwa del oeste
      pis:pijín
      rm:romanche
      se:sami del norte
      shu:árabe chadiano
      slh:lushootseed del sur
      sma:sami meridional
      smn:sami de Inari
      ss:siswati
      str:straits salish
      sw-CD:swahili del Congo
      syr:siriaco
      tce:tutchone del sur
      tet:tetún
      ttm:tutchone del norte
      tyv:tuviniano
      ug-alt-variant:uigur variante
      wal:wolayta
      xnr:dogrí
      """.trimIndent() }

  val es_UY: String? = null

  val es_VE: String by lazy { """
      ace:acehnés
      arp:arapaho
      bho:bhojpuri
      eu:euskera
      grc:griego antiguo
      nso:sotho septentrional
      pa:punyabí
      ss:siswati
      sw:suajili
      sw-CD:suajili del Congo
      tn:setswana
      wo:wolof
      zgh:tamazight marroquí estándar
      """.trimIndent() }

  val et: String by lazy { """
      aa:afari
      ab:abhaasi
      ace:atšehi
      ach:atšoli
      ada:adangme
      ady:adõgee
      ae:avesta
      aeb:Tuneesia araabia
      af:afrikaani
      afh:afrihili
      agq:aghemi
      ain:ainu
      ak:akani
      akk:akadi
      akz:alabama
      ale:aleuudi
      aln:geegi
      alt:altai
      am:amhara
      an:aragoni
      ang:vanainglise
      ann:obolo
      anp:angika
      apc:Levandi araabia
      ar:araabia
      ar-001:tänapäeva araabia kirjakeel
      arc:aramea
      arn:mapudunguni
      aro:araona
      arp:arapaho
      arq:Alžeeria araabia
      ars:Najdi araabia
      arw:aravaki
      ary:Maroko araabia
      arz:Egiptuse araabia
      as:assami
      asa:asu
      ase:Ameerika viipekeel
      ast:astuuria
      atj:atikameki
      av:avaari
      awa:avadhi
      ay:aimara
      az:aserbaidžaani
      az-alt-short:aseri
      ba:baškiiri
      bal:belutši
      ban:bali
      bar:baieri
      bas:basaa
      bax:bamuni
      bbc:bataki
      bbj:ghomala
      be:valgevene
      bej:bedža
      bem:bemba
      bew:betavi
      bez:bena
      bfd:bafuti
      bfq:badaga
      bg:bulgaaria
      bgc:harjaanvi
      bgn:läänebelutši
      bho:bhodžpuri
      bi:bislama
      bik:bikoli
      bin:edo
      bjn:bandžari
      bkm:komi (Aafrika)
      bla:mustjalaindiaani
      blo:anii
      blt:tai-dami
      bm:bambara
      bn:bengali
      bo:tiibeti
      bpy:bišnuprija
      bqi:bahtiari
      br:bretooni
      bra:bradži
      brh:brahui
      brx:bodo
      bs:bosnia
      bss:akoose
      bua:burjaadi
      bug:bugi
      bum:bulu
      byn:bilini
      byv:medumba
      ca:katalaani
      cad:kado
      car:kariibi
      cay:kajuka
      cch:aitšami
      ccp:tšaakma
      ce:tšetšeeni
      ceb:sebu
      cgg:tšiga
      ch:tšamorro
      chb:tšibtša
      chg:tšagatai
      chk:tšuugi
      chm:mari
      chn:tšinuki žargoon
      cho:tšokto
      chp:tšipevai
      chr:tšerokii
      chy:šaieeni
      cic:tšikasoo
      ckb:sorani
      ckb-alt-menu:kurdi (keskkurdi)
      ckb-alt-variant:keskkurdi
      clc:tšilkotini
      co:korsika
      cop:kopti
      cps:kapisnoni
      cr:krii
      crg:michifi
      crh:krimmitatari
      crj:lõuna-idakrii
      crk:tasandikukrii
      crl:põhja-idakrii
      crm:põdrakrii
      crr:Carolina algonkini
      crs:seišelli
      cs:tšehhi
      csb:kašuubi
      csw:sookrii
      cu:kirikuslaavi
      cv:tšuvaši
      cy:kõmri
      da:taani
      dak:siuu
      dar:dargi
      dav:davida
      de:saksa
      de-AT:Austria saksa
      de-CH:Šveitsi ülemsaksa
      del:delavari
      den:sleivi
      dgr:dogribi
      din:dinka
      dje:zarma
      doi:dogri
      dsb:alamsorbi
      dtp:keskdusuni
      dua:duala
      dum:keskhollandi
      dv:maldiivi
      dyo:fonji
      dyu:djula
      dz:dzongkha
      dzg:daza
      ebu:embu
      ee:eve
      efi:efiki
      egl:emiilia
      egy:egiptuse
      eka:ekadžuki
      el:kreeka
      elx:eelami
      en:inglise
      en-AU:Austraalia inglise
      en-CA:Kanada inglise
      en-GB:Briti inglise
      en-GB-alt-short:Briti inglise
      en-US:Ameerika inglise
      en-US-alt-short:USA inglise
      enm:keskinglise
      eo:esperanto
      es:hispaania
      es-419:Ladina-Ameerika hispaania
      es-ES:Euroopa hispaania
      es-MX:Mehhiko hispaania
      esu:keskjupiki
      et:eesti
      eu:baski
      ewo:evondo
      ext:estremenju
      fa:pärsia
      fa-AF:dari
      fan:fangi
      fat:fanti
      ff:fula
      fi:soome
      fil:filipiini
      fit:meä
      fj:fidži
      fo:fääri
      fon:foni
      fr:prantsuse
      fr-CA:Kanada prantsuse
      fr-CH:Šveitsi prantsuse
      frc:cajun’i
      frm:keskprantsuse
      fro:vanaprantsuse
      frp:frankoprovansi
      frr:põhjafriisi
      frs:idafriisi
      fur:friuuli
      fy:läänefriisi
      ga:iiri
      gag:gagauusi
      gan:kani
      gay:gajo
      gba:gbaja
      gd:gaeli
      gez:etioopia
      gil:kiribati
      gl:galeegi
      glk:gilaki
      gmh:keskülemsaksa
      gn:guaranii
      goh:vanaülemsaksa
      gon:gondi
      gor:gorontalo
      got:gooti
      grb:grebo
      grc:vanakreeka
      gsw:šveitsisaksa
      gu:gudžarati
      guc:vajuu
      gur:farefare
      guz:gusii
      gv:mänksi
      gwi:gvitšini
      ha:hausa
      hai:haida
      hak:hakka
      haw:havai
      hax:lõunahaida
      he:heebrea
      hi:hindi
      hi-Latn-alt-variant:hinglishi
      hif:Fidži hindi
      hil:hiligainoni
      hit:heti
      hmn:hmongi
      ho:hirimotu
      hr:horvaadi
      hsb:ülemsorbi
      hsn:sjangi
      ht:haiti
      hu:ungari
      hup:hupa
      hur:halkomelemi
      hy:armeenia
      hz:herero
      ia:interlingua
      iba:ibani
      ibb:ibibio
      id:indoneesia
      ie:interlingue
      ig:ibo
      ii:nuosu
      ik:injupiaki
      ikt:Lääne-Kanada inuktituti
      ilo:iloko
      inh:inguši
      io:ido
      is:islandi
      it:itaalia
      iu:inuktituti
      izh:isuri
      ja:jaapani
      jam:Jamaica kreoolkeel
      jbo:ložban
      jgo:ngomba
      jmc:matšame
      jpr:juudipärsia
      jrb:juudiaraabia
      jut:jüüti
      jv:jaava
      ka:gruusia
      kaa:karakalpaki
      kab:kabiili
      kac:katšini
      kaj:jju
      kam:kamba
      kaw:kaavi
      kbd:kabardi-tšerkessi
      kbl:kanembu
      kcg:tjapi
      kde:makonde
      kea:kabuverdianu
      kfo:koro
      kg:kongo
      kgp:kaingangi
      kha:khasi
      kho:saka
      khq:koyra chiini
      khw:khovari
      ki:kikuju
      kiu:kõrmandžki
      kj:kvanjama
      kk:kasahhi
      kkj:kako
      kl:grööni
      kln:kalendžini
      km:khmeeri
      kmb:mbundu
      kn:kannada
      ko:korea
      koi:permikomi
      kok:konkani
      kos:kosrae
      kpe:kpelle
      kr:kanuri
      krc:karatšai-balkaari
      kri:krio
      krj:kinaraia
      krl:karjala
      kru:kuruhhi
      ks:kašmiiri
      ksb:šambala
      ksf:bafia
      ksh:kölni
      ku:kurdi
      kum:kumõki
      kut:kutenai
      kv:komi
      kw:korni
      kwk:kvakvala
      kxv:kuvi
      ky:kirgiisi
      la:ladina
      lad:ladiino
      lag:langi
      lah:lahnda
      lam:lamba
      lb:letseburgi
      lez:lesgi
      lg:ganda
      li:limburgi
      lij:liguuri
      lil:lillueti
      liv:liivi
      lkt:lakota
      lld:ladiini
      lmo:lombardi
      ln:lingala
      lo:lao
      lol:mongo
      lou:Louisiana kreoolkeel
      loz:lozi
      lrc:põhjaluri
      lsm:samia
      lt:leedu
      ltg:latgali
      lu:Katanga luba
      lua:lulua
      lui:luisenjo
      lun:lunda
      lus:lušei
      luy:luhja
      lv:läti
      lzh:klassikaline hiina
      lzz:lazi
      mad:madura
      maf:mafa
      mag:magahi
      mai:maithili
      mak:makassari
      man:malinke
      mas:masai
      mde:maba
      mdf:mokša
      mdr:mandari
      men:mende
      mer:meru
      mfe:Mauritiuse kreoolkeel
      mg:malagassi
      mga:keskiiri
      mgh:makhuwa-meetto
      mgo:meta
      mh:maršalli
      mhn:mohheni
      mi:maoori
      mic:mikmaki
      min:minangkabau
      mk:makedoonia
      ml:malajalami
      mn:mongoli
      mnc:mandžu
      mni:manipuri
      moe:innu
      moh:mohoogi
      mos:more
      mr:marathi
      mrj:mäemari
      ms:malai
      mt:malta
      mua:mundangi
      mul:mitu keelt
      mus:maskogi
      mwl:miranda
      mwr:marvari
      mwv:mentavei
      my:birma
      mye:mjene
      myv:ersa
      mzn:mazandaraani
      na:nauru
      nan:lõunamini
      nap:napoli
      naq:nama
      nb:norra bokmål
      nd:põhjandebele
      nds:alamsaksa
      nds-NL:Hollandi alamsaksa
      ne:nepali
      new:nevari
      ng:ndonga
      nia:niasi
      niu:niue
      njo:ao
      nl:hollandi
      nl-BE:flaami
      nmg:kwasio
      nn:uusnorra
      nnh:ngiembooni
      no:norra
      nog:nogai
      non:vanapõhja
      nov:noviaal
      nqo:nkoo
      nr:lõunandebele
      nso:põhjasotho
      nus:nueri
      nv:navaho
      nwc:vananevari
      ny:njandža
      nym:njamvesi
      nyn:njankole
      nyo:njoro
      nzi:nzima
      oc:oksitaani
      oj:odžibvei
      ojb:loodeodžibvei
      ojc:keskodžibvei
      ojs:Severni odžibvei
      ojw:lääneodžibvei
      oka:okanagani
      om:oromo
      or:oria
      os:osseedi
      osa:oseidži
      ota:osmanitürgi
      pa:pandžabi
      pag:pangasinani
      pal:pahlavi
      pam:pampanga
      pap:papiamento
      pau:belau
      pcd:pikardi
      pcm:Nigeeria pidžinkeel
      pdc:Pennsylvania saksa
      pdt:mennoniidisaksa
      peo:vanapärsia
      pfl:Pfalzi
      phn:foiniikia
      pi:paali
      pis:pijini
      pl:poola
      pms:piemonte
      pnt:pontose
      pon:poonpei
      pqm:passamakodi
      prg:preisi
      pro:vanaprovansi
      ps:puštu
      pt:portugali
      pt-BR:Brasiilia portugali
      pt-PT:Euroopa portugali
      qu:ketšua
      quc:kitše
      raj:radžastani
      rap:rapanui
      rar:rarotonga
      rgn:romanja
      rhg:rohingja
      rif:riifi
      rm:romanši
      rn:rundi
      ro:rumeenia
      ro-MD:moldova
      rof:rombo
      rom:mustlaskeel
      rtm:rotuma
      ru:vene
      rue:russiini
      rug:roviana
      rup:aromuuni
      rw:ruanda
      rwk:rvaa
      sa:sanskriti
      sad:sandave
      sah:jakuudi
      sam:Samaaria aramea
      saq:samburu
      sas:sasaki
      sat:santali
      saz:sauraštra
      sba:ngambai
      sbp:sangu
      sc:sardi
      scn:sitsiilia
      sco:šoti
      sd:sindhi
      sdh:lõunakurdi
      se:põhjasaami
      see:seneka
      seh:sena
      sei:seri
      sel:sölkupi
      ses:koyraboro senni
      sg:sango
      sga:vanaiiri
      sgs:žemaidi
      sh:serbia-horvaadi
      shi:šilha
      shn:šani
      shu:Tšaadi araabia
      si:singali
      sid:sidamo
      sk:slovaki
      skr:seraiki
      sl:sloveeni
      slh:Lõuna-Puget-Soundi sališi
      sli:alamsileesia
      sly:selajari
      sm:samoa
      sma:lõunasaami
      smj:Lule saami
      smn:Inari saami
      sms:koltasaami
      sn:šona
      snk:soninke
      so:somaali
      sog:sogdi
      sq:albaania
      sr:serbia
      srn:sranani
      srr:sereri
      ss:svaasi
      ssy:saho
      st:lõunasotho
      stq:saterfriisi
      str:väinasališi
      su:sunda
      suk:sukuma
      sus:susu
      sux:sumeri
      sv:rootsi
      sw:suahiili
      sw-CD:Kongo suahiili
      swb:komoori
      syc:vanasüüria
      syr:süüria
      szl:sileesia
      ta:tamili
      tce:lõunatutšoni
      tcy:tulu
      te:telugu
      tem:temne
      teo:teso
      ter:tereno
      tet:tetumi
      tg:tadžiki
      tgx:tagishi
      th:tai
      tht:tahltani
      ti:tigrinja
      tig:tigree
      tiv:tivi
      tk:türkmeeni
      tkl:tokelau
      tkr:tsahhi
      tl:tagalogi
      tlh:klingoni
      tli:tlingiti
      tly:talõši
      tmh:tamašeki
      tn:tsvana
      to:tonga
      tog:tšitonga
      tok:toki pona
      tpi:uusmelaneesia
      tr:türgi
      tru:turojo
      trv:taroko
      trw:torvali
      ts:tsonga
      tsd:tsakoonia
      tsi:tsimši
      tt:tatari
      ttm:põhjatutšoni
      ttt:lõunataadi
      tum:tumbuka
      tvl:tuvalu
      tw:tvii
      twq:taswaqi
      ty:tahiti
      tyv:tõva
      tzm:tamasikti
      udm:udmurdi
      ug:uiguuri
      uga:ugariti
      uk:ukraina
      umb:umbundu
      und:määramata keel
      ur:urdu
      uz:usbeki
      ve:venda
      vec:veneti
      vep:vepsa
      vi:vietnami
      vls:lääneflaami
      vmf:Maini frangi
      vmw:makua
      vo:volapüki
      vot:vadja
      vro:võru
      vun:vundžo
      wa:vallooni
      wae:valsi
      wal:volaita
      war:varai
      was:vašo
      wbp:varlpiri
      wo:volofi
      wuu:uu
      xal:kalmõki
      xh:koosa
      xmf:megreli
      xnr:kangri
      xog:soga
      yao:jao
      yap:japi
      yav:yangbeni
      ybb:jemba
      yi:jidiši
      yo:joruba
      yrl:njengatu
      yue:kantoni
      yue-alt-menu:hiina (kantoni)
      za:tšuangi
      zap:sapoteegi
      zbl:Blissi sümbolid
      zea:zeelandi
      zen:zenaga
      zgh:tamasikti (Maroko)
      zh:hiina
      zh-alt-menu:hiina (mandariinihiina)
      zh-Hans:lihtsustatud hiina
      zh-Hans-alt-long:lihtsustatud mandariinihiina
      zh-Hant:traditsiooniline hiina
      zh-Hant-alt-long:traditsiooniline mandariinihiina
      zu:suulu
      zun:sunji
      zxx:mittekeeleline
      zza:zaza
      """.trimIndent() }

  val eu: String by lazy { """
      aa:afarera
      ab:abkhaziera
      ace:acehnera
      ach:acholiera
      ada:adangmera
      ady:adigera
      af:afrikaansa
      agq:aghemera
      ain:ainuera
      ak:akanera
      ale:aleutera
      alt:hegoaldeko altaiera
      am:amharera
      an:aragoiera
      ann:oboloera
      anp:angikera
      ar:arabiera
      ar-001:arabiera moderno estandarra
      arn:mapudunguna
      arp:arapahoera
      ars:Najdeko arabiera
      as:assamera
      asa:asua
      ast:asturiera
      atj:atikamekwera
      av:avarera
      awa:awadhiera
      ay:aimara
      az:azerbaijanera
      az-alt-short:azerbaijanera
      ba:baxkirera
      ban:baliera
      bas:basaa
      be:bielorrusiera
      bem:bembera
      bez:benera
      bg:bulgariera
      bgc:haryanera
      bho:bhojpurera
      bi:bislama
      bin:edoera
      bla:siksikera
      blo:aniiera
      bm:bambarera
      bn:bengalera
      bo:tibetera
      br:bretoiera
      brx:bodoera
      bs:bosniera
      bug:buginera
      byn:bilenera
      ca:katalana
      cay:cayugera
      ccp:chakmera
      ce:txetxenera
      ceb:cebuanoera
      cgg:chiga
      ch:txamorroera
      chk:chuukera
      chm:mariera
      cho:txoktawera
      chp:chipewyera
      chr:txerokiera
      chy:txeieneera
      ckb:erdialdeko kurduera
      ckb-alt-menu:erdialdeko kurduera
      ckb-alt-variant:erdialdeko kurduera
      clc:chilcotinera
      co:korsikera
      crg:metisera
      crj:hego-ekialdeko creera
      crk:lautadetako creera
      crl:ipar-ekialdeko creera
      crm:Mooseko creera
      crr:Carolinako algonkinera
      crs:Seychelleetako kreolera
      cs:txekiera
      csw:zingiretako creera
      cu:elizako eslaviera
      cv:txuvaxera
      cy:galesa
      da:daniera
      dak:dakotera
      dar:darginera
      dav:taitera
      de:alemana
      de-AT:Austriako alemana
      de-CH:Suitzako aleman garaia
      dgr:dogribera
      dje:zarma
      doi:dogria
      dsb:behe-sorabiera
      dua:dualera
      dv:dhivehia
      dyo:fonyi jolera
      dz:dzongkha
      dzg:dazaera
      ebu:embuera
      ee:eweera
      efi:efikera
      eka:ekajuka
      el:greziera
      en:ingelesa
      en-AU:Australiako ingelesa
      en-CA:Kanadako ingelesa
      en-GB:Britainia Handiko ingelesa
      en-GB-alt-short:Erresuma Batuko ingelesa
      en-US:ingeles amerikarra
      en-US-alt-short:AEBko ingelesa
      eo:esperantoa
      es:gaztelania
      es-419:Latinoamerikako gaztelania
      es-ES:Europako gaztelania
      es-MX:Mexikoko gaztelania
      et:estoniera
      eu:euskara
      ewo:ewondoa
      fa:persiera
      fa-AF:daria
      ff:fula
      fi:finlandiera
      fil:filipinera
      fj:fijiera
      fo:faroera
      fon:fonera
      fr:frantsesa
      fr-CA:Kanadako frantsesa
      fr-CH:Suitzako frantsesa
      frc:cajun frantsesa
      frr:iparraldeko frisiera
      fur:friulera
      fy:mendebaldeko frisiera
      ga:irlandera
      gaa:gaera
      gag:gagauzera
      gd:Eskoziako gaelikoa
      gez:ge’eza
      gil:kiribatiera
      gl:galiziera
      gn:guaraniera
      gor:gorontaloera
      gsw:Suitzako alemana
      gu:gujaratera
      guz:gusiiera
      gv:manxera
      gwi:gwich’inera
      ha:hausa
      hai:haidera
      haw:hawaiiera
      hax:hegoaldeko haidera
      he:hebreera
      hi:hindia
      hi-Latn:hindia (latindarra)
      hi-Latn-alt-variant:hinglisha
      hil:hiligaynonera
      hmn:hmonga
      hr:kroaziera
      hsb:goi-sorabiera
      ht:Haitiko kreolera
      hu:hungariera
      hup:hupera
      hur:halkomelema
      hy:armeniera
      hz:hereroera
      ia:interlingua
      iba:ibanera
      ibb:ibibioera
      id:indonesiera
      ie:interlinguea
      ig:igboera
      ii:Sichuango yiera
      ikt:Kanada mendebaldeko inuitera
      ilo:ilocanoera
      inh:ingushera
      io:idoa
      is:islandiera
      it:italiera
      iu:inuitera
      ja:japoniera
      jbo:lojbana
      jgo:ngomba
      jmc:machamea
      jv:javera
      ka:georgiera
      kab:kabiliera
      kac:jingphoera
      kaj:jjua
      kam:kambera
      kbd:kabardiera
      kcg:tyapa
      kde:makondeera
      kea:Cabo Verdeko kreolera
      kfo:koroa
      kg:kikongoa
      kgp:kaingangera
      kha:khasiera
      khq:koyra chiinia
      ki:kikuyuera
      kj:kuanyama
      kk:kazakhera
      kkj:kakoa
      kl:groenlandiera
      kln:kalenjinera
      km:khemerera
      kmb:kimbundua
      kn:kannada
      ko:koreera
      koi:komi-permyakera
      kok:konkanera
      kpe:kpelleera
      kr:kanuriera
      krc:karachayera-balkarera
      krl:kareliera
      kru:kurukhera
      ks:kaxmirera
      ksb:shambalera
      ksf:bafiera
      ksh:koloniera
      ku:kurduera
      kum:kumykera
      kv:komiera
      kw:kornubiera
      kwk:kwakwala
      kxv:kuvia
      ky:kirgizera
      la:latina
      lad:ladinoa
      lag:langiera
      lb:luxenburgera
      lez:lezginera
      lg:luganda
      li:limburgera
      lij:liguriera
      lil:lillooetera
      lkt:lakotera
      lmo:lombardiera
      ln:lingala
      lo:laosera
      lou:Louisianako kreolera
      loz:loziera
      lrc:iparraldeko lurera
      lsm:saamia
      lt:lituaniera
      lu:Katangako lubera
      lua:Kasai mendebaldeko lubera
      lun:lundera
      luo:luoera
      lus:mizoera
      luy:luhyera
      lv:letoniera
      mad:madurera
      mag:magadhera
      mai:maithilia
      mak:makassarera
      mas:masaiera
      mdf:mokxera
      men:mendeera
      mer:meruera
      mfe:Mauritaniako kreolera
      mg:malgaxea
      mgh:makhuwa-meettoera
      mgo:metaʼera
      mh:marshallera
      mi:maoriera
      mic:mikmakera
      min:minangkabauera
      mk:mazedoniera
      ml:malabarera
      mn:mongoliera
      mni:manipurera
      moe:innuera
      moh:mohawkera
      mos:mossiera
      mr:marathera
      ms:malaysiera
      mt:maltera
      mua:mudangera
      mul:zenbait hizkuntza
      mus:muscogeera
      mwl:mirandesa
      my:birmaniera
      myv:erziera
      mzn:mazandarandera
      na:nauruera
      nap:napoliera
      naq:namera
      nb:bokmål (norvegiera)
      nd:iparraldeko ndebeleera
      nds:behe-alemana
      nds-NL:behe-saxoiera
      ne:nepalera
      new:newarera
      ng:ndonga
      nia:niasera
      niu:niueera
      nl:nederlandera
      nl-BE:flandriera
      nmg:kwasiera
      nn:nynorsk (norvegiera)
      nnh:ngiemboonera
      no:norvegiera
      nog:nogaiera
      nqo:n’koera
      nr:hegoaldeko ndebeleera
      nso:pediera
      nus:nuerera
      nv:navajoera
      ny:chewera
      nyn:nkoreera
      oc:okzitaniera
      ojb:ipar-mendebaldeko ojibwa
      ojc:erdialdeko ojibwa
      ojs:oji-creera
      ojw:mendebaldeko ojibwa
      oka:okanaganera
      om:oromoera
      or:oriya
      os:osetiera
      pa:punjabera
      pag:pangasinanera
      pam:pampangera
      pap:papiamentoa
      pau:palauera
      pcm:Nigeriako pidgina
      pis:pijina
      pl:poloniera
      pqm:maliseet-passamaquoddyera
      prg:prusiera
      ps:paxtunera
      pt:portugesa
      pt-BR:Brasilgo portugesa
      pt-PT:Europako portugesa
      qu:kitxua
      quc:quicheera
      raj:rajastanera
      rap:rapanuia
      rar:rarotongera
      rhg:rohingyera
      rm:erretorromaniera
      rn:rundiera
      ro:errumaniera
      ro-MD:moldaviera
      rof:romboa
      ru:errusiera
      rup:aromaniera
      rw:kinyaruanda
      rwk:rwera
      sa:sanskritoa
      sad:sandaweera
      sah:sakhera
      saq:samburuera
      sat:santalera
      sba:ngambayera
      sbp:sanguera
      sc:sardiniera
      scn:siziliera
      sco:eskoziera
      sd:sindhia
      se:iparraldeko samiera
      seh:senera
      ses:koyraboro sennia
      sg:sangoa
      sh:serbokroaziera
      shi:tachelhita
      shn:shanera
      si:sinhala
      sk:eslovakiera
      sl:esloveniera
      slh:lushootseeda
      sm:samoera
      sma:hegoaldeko samiera
      smj:Luleko samiera
      smn:Inariko samiera
      sms:skolten samiera
      sn:shonera
      snk:soninkeera
      so:somaliera
      sq:albaniera
      sr:serbiera
      srn:sranan tongoa
      ss:swatiera
      ssy:sahoa
      st:hegoaldeko sothoera
      str:itsasarteetako salishera
      su:sundanera
      suk:sukumera
      sv:suediera
      sw:swahilia
      sw-CD:Kongoko swahilia
      swb:komoreera
      syr:asiriera
      szl:silesiera
      ta:tamilera
      tce:hegoaldeko tutchoneera
      te:telugua
      tem:temneera
      teo:tesoera
      tet:tetuma
      tg:tajikera
      tgx:tagishera
      th:thailandiera
      tht:tahltanera
      ti:tigrinyera
      tig:tigreera
      tk:turkmenera
      tl:tagaloa
      tlh:klingonera
      tli:tlingitera
      tn:tswanera
      to:tongera
      tok:toki pona
      tpi:tok pisin
      tr:turkiera
      trv:tarokoera
      ts:tsongera
      tt:tatarera
      ttm:iparraldeko tutchoneera
      tum:tumbukera
      tvl:tuvaluera
      tw:twia
      twq:tasawaqa
      ty:tahitiera
      tyv:tuvera
      tzm:Erdialdeko Atlaseko amazigera
      udm:udmurtera
      ug:uigurrera
      uk:ukrainera
      umb:umbundua
      und:hizkuntza ezezaguna
      ur:urdua
      uz:uzbekera
      vai:vaiera
      ve:vendera
      vec:veneziera
      vi:vietnamera
      vmw:makhuwera
      vo:volapük
      vun:vunjoa
      wa:valoniera
      wae:walserera
      wal:wolayttera
      war:warayera
      wo:wolofera
      wuu:wu txinera
      xal:kalmykera
      xh:xhosera
      xnr:kangrera
      xog:sogera
      yav:yangbenera
      ybb:yemba
      yi:yiddisha
      yo:jorubera
      yrl:nheengatua
      yue:kantonera
      yue-alt-menu:Kantongo txinera
      za:zhuangera
      zgh:amazigera estandarra
      zh:txinera
      zh-alt-menu:mandarina
      zh-Hans:txinera sinplifikatua
      zh-Hans-alt-long:mandarin sinplifikatua
      zh-Hant:txinera tradizionala
      zh-Hant-alt-long:mandarin tradizionala
      zu:zuluera
      zun:zuñiera
      zxx:ez dago eduki linguistikorik
      zza:zazera
      """.trimIndent() }

  val ewo: String by lazy { """
      ak:Ǹkɔ́bɔ akán
      am:Ǹkɔ́bɔ amária
      ar:Ǹkɔ́bɔ arábia
      be:Ǹkɔ́bɔ belarúsian
      bg:Ǹkɔ́bɔ buləgárian
      bn:Ǹkɔ́bɔ bɛngalí
      cs:Ǹkɔ́bɔ tsɛ́g
      de:Ǹkɔ́bɔ ndzáman
      el:Ǹkɔ́bɔ gəlɛ́g
      en:Ǹkɔ́bɔ éngəlís
      es:ǹkɔ́bɔ kpənyá
      ewo:ewondo
      fa:ǹkɔ́bɔ fɛ́rəsian
      fr:Ǹkɔ́bɔ fulɛnsí
      ha:Ǹkɔ́bɔ aúsá
      hi:Ǹkɔ́bɔ hindí
      hu:Ǹkɔ́bɔ ungárían
      id:Ǹkɔ́bɔ ɛndonésian
      ig:Ǹkɔ́bɔ ibó
      it:Ǹkɔ́bɔ etáliɛn
      ja:Ǹkɔ́bɔ hapɔ́n
      jv:Ǹkɔ́bɔ havanís
      km:Ǹkɔ́bɔ kəmɛ́r
      ko:Ǹkɔ́bɔ koréan
      ms:Ǹkɔ́bɔ malɛ́sian
      my:Ǹkɔ́bɔ birəmán
      ne:ǹkɔ́bɔ nefálian
      nl:Ǹkɔ́bɔ nɛrəlándía
      pa:ǹkɔ́bɔ funəhábia
      pl:ǹkɔ́bɔ fólis
      pt:ǹkɔ́bɔ fɔtugɛ́s
      ro:ńkɔ́bɔ románía
      ru:ǹkɔ́bɔ rúsian
      rw:ǹkɔ́bɔ ruwandá
      so:ǹkɔ́bɔ somália
      sv:ǹkɔ́bɔ suwɛ́d
      ta:ǹkɔ́bɔ tamíl
      th:ǹkɔ́bɔ táilan
      tr:ǹkɔ́bɔ túrəki
      uk:ǹkɔ́bɔ ukelénia
      ur:ǹkɔ́bɔ urudú
      vi:ǹkɔ́bɔ hiɛdənám
      yo:ǹkɔ́bɔ yorúba
      zh:Ǹkɔ́bɔ tsainís
      zh-alt-menu:Ǹkɔ́bɔ tsainís
      zu:ǹkɔ́bɔ zulú
      """.trimIndent() }

  val fa: String by lazy { """
      aa:آفاری
      ab:آبخازی
      ace:آچئی
      ach:آچولیایی
      ada:آدانگمه‌ای
      ady:آدیجیایی
      ae:اوستایی
      aeb:عربی تونسی
      af:آفریکانس
      afh:آفریهیلی
      agq:آگیم
      ain:آینویی
      ak:آکان
      akk:اکدی
      akz:آلابامایی
      ale:آلئوتی
      alt:آلتایی جنوبی
      am:امهری
      an:آراگونی
      ang:انگلیسی باستان
      ann:اوبولو
      anp:آنگیکا
      ar:عربی
      ar-001:عربی رسمی
      arc:آرامی
      arn:ماپوچه‌ای
      arp:آراپاهویی
      arq:عربی الجزایری
      ars:عربی نجدی
      arw:آراواکی
      ary:عربی مراکشی
      arz:عربی مصری
      as:آسامی
      asa:آسو
      ast:آستوری
      atj:آتیکامکو
      av:آواری
      awa:اودهی
      ay:آیمارایی
      az:ترکی آذربایجانی
      az-alt-short:آذری
      az-alt-variant:آذربایجانی
      az-Arab:ترکی آذری جنوبی
      ba:باشقیری
      bal:بلوچی
      ban:بالیایی
      bar:باواریایی
      bas:باسایی
      bax:بمونی
      be:بلاروسی
      bej:بجایی
      bem:بمبایی
      bez:بنایی
      bg:بلغاری
      bgc:هارایاناوی
      bgn:بلوچی غربی
      bho:بوجپوری
      bi:بیسلاما
      bik:بیکولی
      bin:بینی
      bla:سیکسیکا
      blo:باسیلا
      bm:بامبارایی
      bn:بنگالی
      bo:تبتی
      bqi:لری بختیاری
      br:برتون
      bra:براج
      brh:براهویی
      brx:بودویی
      bs:بوسنیایی
      bua:بوریاتی
      bug:بوگینس
      byn:بلین
      ca:کاتالان
      cad:کادویی
      car:کاریبی
      cay:کایوگا
      ccp:چاکما
      ce:چچنی
      ceb:سبویی
      cgg:چیگا
      ch:چامورویی
      chb:چیبچا
      chg:جغتایی
      chk:چوکی
      chm:ماریایی
      cho:چوکتویی
      chp:چیپه‌ویه‌ای
      chr:چروکی
      chy:شایانی
      ckb:کردی مرکزی
      ckb-alt-menu:کردی، مرکزی
      ckb-alt-variant:کردی سورانی
      clc:چیلکوتن
      co:کورسی
      cop:قبطی
      cr:کریایی
      crg:میچیف
      crh:ترکی کریمه
      crj:کری جنوب شرقی
      crk:کری صحرایی
      crl:کری شمال شرقی
      crm:موس کری
      crr:آلگانکوین کارولینا
      crs:سیشل آمیختهٔ فرانسوی
      cs:چکی
      csb:کاشوبی
      csw:کری سوامپی
      cu:اسلاوی کلیسایی
      cv:چوواشی
      cy:ولزی
      da:دانمارکی
      dak:داکوتایی
      dar:دارگوا
      dav:تایتا
      de:آلمانی
      de-AT:آلمانی اتریش
      de-CH:آلمانی معیار سوئیس
      del:دلاواری
      dgr:دوگریب
      din:دینکایی
      dje:زرما
      doi:دوگری
      dsb:صُربی سفلی
      dua:دوآلایی
      dum:هلندی میانه
      dv:دیوهی
      dyo:دیولا فونی
      dyu:دایولایی
      dz:دزونگخا
      dzg:دازاگا
      ebu:امبو
      ee:اوه‌ای
      efi:افیکی
      egy:مصری کهن
      eka:اکاجوک
      el:یونانی
      elx:عیلامی
      en:انگلیسی
      en-AU:انگلیسی استرالیا
      en-CA:انگلیسی کانادا
      en-GB:انگلیسی بریتانیا
      en-GB-alt-short:انگلیسی بریتانیا
      en-US:انگلیسی آمریکا
      en-US-alt-short:انگلیسی آمریکا
      enm:انگلیسی میانه
      eo:اسپرانتو
      es:اسپانیایی
      es-419:اسپانیایی امریکای لاتین
      es-ES:اسپانیایی اروپا
      es-MX:اسپانیایی مکزیک
      et:استونیایی
      eu:باسکی
      ewo:اواندو
      fa:فارسی
      fa-AF:دری
      fan:فانگی
      fat:فانتیایی
      ff:فولانی
      fi:فنلاندی
      fil:فیلیپینی
      fj:فیجیایی
      fo:فارویی
      fon:فونی
      fr:فرانسوی
      fr-CA:فرانسوی کانادا
      fr-CH:فرانسوی سوئیس
      frc:فرانسوی کاجون
      frm:فرانسوی میانه
      fro:فرانسوی باستان
      frr:فریزی شمالی
      frs:فریزی شرقی
      fur:فریولیایی
      fy:فریسی غربی
      ga:ایرلندی
      gaa:گایی
      gag:گاگائوزیایی
      gay:گایویی
      gba:گبایایی
      gbz:دری زرتشتی
      gd:گیلی اسکاتلندی
      gez:گی‌ئزی
      gil:گیلبرتی
      gl:گالیسیایی
      glk:گیلکی
      gmh:آلمانی معیار میانه
      gn:گوارانی
      goh:آلمانی علیای باستان
      gon:گوندی
      gor:گورونتالو
      got:گوتی
      grb:گریبویی
      grc:یونانی کهن
      gsw:آلمانی سوئیسی
      gu:گجراتی
      guz:گوسی
      gv:مانی
      gwi:گویچ این
      ha:هوسایی
      hai:هایدایی
      haw:هاوایی
      hax:هایدا جنوبی
      he:عبری
      hi:هندی
      hi-Latn-alt-variant:هندی (انگلیسی)
      hif:هندی فیجیایی
      hil:هیلی‌گاینونی
      hit:هیتی
      hmn:همونگ
      ho:موتویی هیری
      hr:کروات
      hsb:صُربی علیا
      ht:هائیتیایی
      hu:مجاری
      hup:هوپا
      hur:هالکوملم
      hy:ارمنی
      hz:هریرویی
      ia:اینترلینگوا
      iba:ایبانی
      ibb:ایبیبیو
      id:اندونزیایی
      ie:اکسیدنتال
      ig:ایگبویی
      ii:یی سیچوان
      ik:اینوپیک
      ikt:اینوکتیتوت غرب کانادا
      ilo:ایلوکویی
      inh:اینگوشی
      io:ایدو
      is:ایسلندی
      it:ایتالیایی
      iu:اینوکتیتوت
      ja:ژاپنی
      jbo:لوجبان
      jgo:نگومبا
      jmc:ماچامه‌ای
      jpr:فارسی یهودی
      jrb:عربی یهودی
      jv:جاوه‌ای
      ka:گرجی
      kaa:قره‌قالپاقی
      kab:قبایلی
      kac:کاچینی
      kaj:جو
      kam:کامبایی
      kaw:کاویایی
      kbd:کاباردینی
      kcg:تیاپی
      kde:ماکونده
      kea:کابووردیانو
      kfo:کورو
      kg:کنگویی
      kgp:کاین گنگ
      kha:خاسیایی
      kho:ختنی
      khq:کوجراچینی
      khw:کهوار
      ki:کیکویویی
      kiu:کرمانجی
      kj:کوانیاما
      kk:قزاقی
      kkj:کاکایی
      kl:گرینلندی
      kln:کالنجین
      km:خمری
      kmb:کیمبوندویی
      kn:کانارا
      ko:کره‌ای
      koi:کومی پرمیاک
      kok:کنکانی
      kpe:کپله‌ای
      kr:کانوریایی
      krc:قره‌چایی‐بالکاری
      krl:کاریلیانی
      kru:کوروخی
      ks:کشمیری
      ksb:شامبالا
      ksf:بافیایی
      ksh:کولش
      ku:کردی
      kum:کومیکی
      kut:کوتنی
      kv:کومیایی
      kw:کورنی
      kwk:کواک والا
      kxv:کووی
      ky:قرقیزی
      la:لاتین
      lad:لادینو
      lag:لانگی
      lah:لاهندا
      lam:لامبا
      lb:لوگزامبورگی
      lez:لزگی
      lg:گاندایی
      li:لیمبورگی
      lij:لیگوری
      lil:لیلوئت
      lkt:لاکوتا
      lmo:لومبارد
      ln:لینگالا
      lo:لائوسی
      lol:مونگویی
      lou:کرئول لوئیزیانا
      loz:لوزیایی
      lrc:لری شمالی
      lsm:سامیا
      lt:لیتوانیایی
      lu:لوبایی‐کاتانگا
      lua:لوبایی‐لولوا
      lui:لویسنو
      lun:لوندایی
      luo:لوئویی
      lus:میزو
      luy:لویا
      lv:لتونیایی
      lzh:چینی ادبی
      mad:مادورایی
      mag:ماگاهیایی
      mai:مایدیلی
      mak:ماکاسار
      man:ماندینگویی
      mas:ماسایی
      mdf:مکشایی
      mdr:ماندار
      men:منده‌ای
      mer:مرویی
      mfe:موریسین
      mg:مالاگاسی
      mga:ایرلندی میانه
      mgh:ماکوا متو
      mgo:متایی
      mh:مارشالی
      mi:مائوری
      mic:میکماکی
      min:مینانگ‌کابویی
      mk:مقدونی
      ml:مالایالامی
      mn:مغولی
      mnc:مانچویی
      mni:مانیپوری
      moe:اینوآیموم
      moh:موهاکی
      mos:ماسیایی
      mr:مراتی
      ms:مالایی
      mt:مالتی
      mua:ماندانگی
      mul:چندین زبان
      mus:کریکی
      mwl:میراندی
      mwr:مارواری
      my:برمه‌ای
      myv:ارزیایی
      mzn:مازندرانی
      na:نائورویی
      nap:ناپلی
      naq:نامایی
      nb:نروژی بوک‌مُل
      nd:انده‌بله‌ای شمالی
      nds:آلمانی سفلی
      nds-NL:ساکسونی سفلی
      ne:نپالی
      new:نواریایی
      ng:اندونگایی
      nia:نیاسی
      niu:نیویی
      nl:هلندی
      nl-BE:فلمنگی
      nmg:کوازیو
      nn:نروژی نی‌نُشک
      nnh:نیامبون
      no:نروژی
      nog:نغایی
      non:نرس باستان
      nqo:نکو
      nr:انده‌بله‌ای جنوبی
      nso:سوتویی شمالی
      nus:نویر
      nv:ناواهویی
      nwc:نواریایی کلاسیک
      ny:نیانجایی
      nym:نیام‌وزیایی
      nyn:نیانکوله‌ای
      nyo:نیورویی
      nzi:نزیمایی
      oc:اکسیتان
      oj:اوجیبوایی
      ojb:اوجیبوای شمالی
      ojc:اوجیبوای مرکزی
      ojs:اوجی-کری
      ojw:اوجیبوای غربی
      oka:اوکاناگان
      om:اورومویی
      or:اوریه‌ای
      os:آسی
      osa:اوسیجی
      ota:ترکی عثمانی
      pa:پنجابی
      pag:پانگاسینانی
      pal:پهلوی
      pam:پامپانگایی
      pap:پاپیامنتو
      pau:پالائویی
      pcm:نیم‌زبان نیجریه‌ای
      pdc:آلمانی پنسیلوانیایی
      peo:فارسی باستان
      phn:فنیقی
      pi:پالی
      pis:پی‌جین
      pl:لهستانی
      pon:پانپیی
      pqm:ملیسیت - پاسماکودی
      prg:پروسی
      pro:پرووانسی باستان
      ps:پشتو
      ps-alt-variant:پختو
      pt:پرتغالی
      pt-BR:پرتغالی برزیل
      pt-PT:پرتغالی اروپا
      qu:کچوایی
      quc:کیچه‌
      raj:راجستانی
      rap:راپانویی
      rar:راروتونگایی
      rhg:روهینگیا
      rm:رومانش
      rn:روندیایی
      ro:رومانیایی
      ro-MD:مولداویایی
      rof:رومبویی
      rom:رومانویی
      ru:روسی
      rup:آرومانی
      rw:کینیارواندایی
      rwk:روایی
      sa:سانسکریت
      sad:سانداوه‌ای
      sah:یاقوتی
      sam:آرامی سامری
      saq:سامبورو
      sas:ساساکی
      sat:سانتالی
      sba:انگامبایی
      sbp:سانگویی
      sc:ساردینیایی
      scn:سیسیلی
      sco:اسکاتلندی
      sd:سندی
      sdh:کردی جنوبی
      se:سامی شمالی
      seh:سنا
      sel:سلکوپی
      ses:کویرابورا سنی
      sg:سانگو
      sga:ایرلندی باستان
      sh:صرب و کرواتی
      shi:تاچل‌هیت
      shn:شانی
      shu:عربی چادی
      si:سینهالی
      sid:سیدامویی
      sk:اسلواکی
      sl:اسلوونیایی
      slh:لاشوتسید جنوبی
      sli:سیلزیایی سفلی
      sm:ساموآیی
      sma:سامی جنوبی
      smj:لوله سامی
      smn:ایناری سامی
      sms:اسکولت سامی
      sn:شونایی
      snk:سونینکه‌ای
      so:سومالیایی
      sog:سغدی
      sq:آلبانیایی
      sr:صربی
      srn:زبان اسرانان
      srr:سریری
      ss:سوازیایی
      ssy:ساهو
      st:سوتوی جنوبی
      str:سالیش استریتز
      su:سوندایی
      suk:سوکومایی
      sus:سوسویی
      sux:سومری
      sv:سوئدی
      sw:سواحیلی
      sw-CD:سواحیلی کنگو
      swb:کوموری
      syc:سریانی کلاسیک
      syr:سریانی
      szl:سیلزیایی
      ta:تامیلی
      tce:توچون جنوبی
      te:تلوگویی
      tem:تمنه‌ای
      teo:تسویی
      ter:ترنو
      tet:تتومی
      tg:تاجیکی
      tgx:تاگیش
      th:تایلندی
      tht:تالتان
      ti:تیگرینیایی
      tig:تیگره‌ای
      tiv:تیوی
      tk:ترکمنی
      tl:تاگالوگی
      tlh:کلینگون
      tli:تلین‌گیتی
      tmh:تاماشقی
      tn:تسوانایی
      to:تونگایی
      tog:تونگایی نیاسا
      tok:توکی پونا
      tpi:توک‌پیسینی
      tr:ترکی استانبولی
      tr-alt-secondary:ترکی
      trv:تاروکویی
      ts:تسونگایی
      tsi:تسیم‌شیانی
      tt:تاتاری
      ttm:تاچونی شمالی
      tum:تومبوکایی
      tvl:تووالویی
      tw:توی‌یایی
      twq:تسواکی
      ty:تاهیتیایی
      tyv:تووایی
      tzm:آمازیغی اطلس مرکزی
      udm:اودمورتی
      ug:اویغوری
      uga:اوگاریتی
      uk:اوکراینی
      umb:امبوندویی
      und:زبان نامشخص
      ur:اردو
      uz:ازبکی
      vai:ویایی
      ve:وندایی
      vec:ونیزی
      vi:ویتنامی
      vmw:ماکوا
      vo:ولاپوک
      vot:وتی
      vun:ونجو
      wa:والونی
      wae:والسر
      wal:والامو
      war:وارایی
      was:واشویی
      wbp:وارلپیری
      wo:ولوفی
      wuu:وو چینی
      xal:قلموقی
      xh:خوسایی
      xnr:کانگری
      xog:سوگایی
      yao:یائویی
      yap:یاپی
      yav:یانگبنی
      ybb:یمبایی
      yi:یدی
      yo:یوروبایی
      yrl:نهین گاتو
      yue:کانتونی
      yue-alt-menu:چینی کانتونی
      za:ژوانگی
      zap:زاپوتکی
      zen:زناگا
      zgh:آمازیغی معیار مراکش
      zh:چینی
      zh-alt-menu:چینی، ماندارین
      zh-Hans:چینی ساده‌شده
      zh-Hans-alt-long:چینی ماندارین ساده‌شده
      zh-Hant:چینی سنتی
      zh-Hant-alt-long:چینی ماندارین سنتی
      zu:زولویی
      zun:زونیایی
      zxx:بدون محتوای زبانی
      zza:زازایی
      """.trimIndent() }

  val fa_AF: String by lazy { """
      ab:افریکانس
      ar-001:عربی فصیح
      as:اسامی
      ast:اتریشی
      az:آذربایجانی
      ckb:کردی سورانی
      dv:مالدیوی
      es:هسپانوی
      fi:فنلندی
      ga:آیرلندی
      hr:کروشیایی
      id:اندونیزیایی
      is:آیسلندی
      it:ایتالوی
      ja:جاپانی
      ko:کوریایی
      ksh:کلنی
      ky:قرغزی
      lus:میزویی
      mai:مایتیلی
      mn:مغلی
      nb:نروژی کتابی
      ne:نیپالی
      nl:هالندی
      nl-BE:فلمیش
      nn:نروژی نو
      no:نارویژی
      pl:پولندی
      ps-alt-variant:پشتو
      pt:پرتگالی
      sq:البانیایی
      srn:زبان سرانان
      sv:سویدنی
      sw:سواحلی
      tg:تاجکی
      zh-Hans:چینی ساده شده
      zza:زازاکی
      """.trimIndent() }

  val ff: String by lazy { """
      ak:Akaan
      am:Amarik
      ar:Aarabeere
      be:Belaruuse
      bg:Bulgariire
      bn:Bengali
      cs:Cekkere
      de:Docceere
      el:Gerke
      en:Engeleere
      es:Español
      fa:Perseere
      ff:Pulaar
      fr:Farayseere
      ha:Hawsaŋkoore
      hi:Hinndi
      hu:Hongariire
      id:Endonesiire
      ig:Igiboore
      it:Italiyeere
      ja:Saponeere
      jv:Sawaneere
      km:Kemeere
      ko:Koreere
      ms:Malayeere
      my:Burmeese
      ne:Nepaaleere
      nl:Dacceere
      pa:Punjabeere
      pl:Poloneere
      pt:Purtugeere
      ro:Romaneere
      ru:Riis
      rw:Ruwaanndeere
      so:Somalii
      sv:Sweedeere
      ta:Tamil
      th:Taay
      tr:Turkeere
      uk:Ukereneere
      ur:Urdu
      vi:Wiyetnameere
      yo:Yorrubaa
      zh:Sinuwaare
      zh-alt-menu:Sinuwaare
      zu:Suluŋkoore
      """.trimIndent() }

  val ff_Adlm: String by lazy { """
      aa:𞤀𞤬𞤢𞥄𞤪𞤫
      ab:𞤀𞤦𞤳𞤢𞥄𞤧𞤭𞤴𞤢𞤲𞤪𞤫
      ace:𞤀𞥄𞤧𞤭𞤴𞤢𞤲𞤪𞤫
      ada:𞤀𞤣𞤢𞤲𞤺𞤥𞤫𞥅𞤪𞤫
      ady:𞤀𞤣𞤭𞤿𞤭𞥅𞤪𞤫
      af:𞤀𞤬𞤪𞤭𞤳𞤢𞤲𞤪𞤫
      agq:𞤀𞤺𞤸𞤫𞤥𞤪𞤫
      ain:𞤀𞤴𞤲𞤵𞥅𞤪𞤫
      ak:𞤀𞤳𞤢𞤲𞤪𞤫
      ale:𞤀𞤤𞤫𞤵𞤼𞤵𞥅𞤪𞤫
      alt:𞤀𞤤𞤼𞤢𞤴𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞤲𞤳𞤮𞥅𞤪𞤫
      am:𞤀𞤥𞤸𞤢𞤪𞤭𞥅𞤪𞤫
      an:𞤀𞤪𞤢𞤺𞤮𞤲𞤪𞤫
      ann:𞤌𞤦𞤮𞤤𞤮𞥅𞤪𞤫
      anp:𞤀𞤲𞤺𞤭𞤳𞤢𞥄𞤪𞤫
      ar:𞤀𞥄𞤪𞤢𞤦𞤫𞥅𞤪𞤫
      ar-001:𞤀𞥄𞤪𞤢𞤦𞤫𞥅𞤪𞤫 𞤊𞤵𞤧𞤸𞤢 𞤒𞤫𞤲𞤯𞤵𞤳𞤢
      arn:𞤃𞤢𞤨𞤵𞤷𞤭𞥅𞤪𞤫
      arp:𞤀𞤪𞤢𞤨𞤢𞤸𞤮𞥅𞤪𞤫
      ars:𞤀𞥄𞤪𞤢𞤦𞤫𞥅𞤪𞤫 𞤐𞤢𞤶𞤣𞤭
      as:𞤀𞤧𞤢𞤥𞤫𞥅𞤪𞤫
      asa:𞤀𞤧𞤵𞥅𞤪𞤫
      ast:𞤀𞤧𞤼𞤵𞤪𞤭𞥅𞤪𞤫
      atj:𞤀𞤼𞤭𞤥𞤫𞤳𞤵𞤱𞤪𞤫
      av:𞤀𞤬𞤱𞤢𞤪𞤭𞥅𞤪𞤫
      awa:𞤀𞤱𞤢𞤣𞤭𞥅𞤪𞤫
      ay:𞤀𞤴𞤥𞤢𞤪𞤢𞥄𞤪𞤫
      az:𞤀𞤶𞤢𞤪𞤦𞤢𞤴𞤭𞤶𞤢𞤲𞤭𞥅𞤪𞤫
      az-alt-short:𞤀𞤶𞤢𞤪𞤭𞥅𞤪𞤫
      ba:𞤄𞤢𞤧𞤳𞤭𞥅𞤪𞤫
      ban:𞤄𞤢𞥄𞤤𞤭𞥅𞤪𞤫
      bas:𞤄𞤢𞤧𞤢𞥄𞤪𞤫
      be:𞤄𞤫𞤤𞤢𞤪𞤭𞥅𞤧𞤭𞥅𞤪𞤫
      bem:𞤄𞤫𞤥𞤦𞤢𞥄𞤪𞤫
      bez:𞤄𞤫𞤲𞤢𞥄𞤪𞤫
      bg:𞤄𞤭𞤤𞤺𞤢𞥄𞤪𞤫
      bgc:𞤖𞤢𞤪𞤴𞤢𞤲𞤾𞤭𞥅𞤪𞤫
      bho:𞤄𞤮𞤧𞤨𞤵𞤪𞤭𞥅𞤪𞤫
      bi:𞤄𞤭𞤧𞤤𞤢𞤥𞤢𞥄𞤪𞤫
      bin:𞤄𞤭𞤲𞤭𞥅𞤪𞤫
      bla:𞤅𞤭𞤳𞤧𞤭𞤳𞤢𞥄𞤪𞤫
      bm:𞤄𞤢𞤥𞤦𞤢𞤪𞤢𞥄𞤪𞤫
      bn:𞤄𞤫𞤲𞤺𞤢𞤤𞤭𞥅𞤪𞤫
      bo:𞤚𞤭𞤦𞤫𞤼𞤫𞤲𞤪𞤫
      br:𞤄𞤫𞤪𞤫𞤼𞤮𞤲𞤪𞤫
      brx:𞤄𞤮𞤣𞤮𞥅𞤪𞤫
      bs:𞤄𞤮𞤧𞤲𞤭𞤴𞤢𞥄𞤪𞤫
      bug:𞤄𞤵𞤺𞤭𞤧𞤢𞥄𞤪𞤫
      byn:𞤄𞤭𞤤𞤭𞤲𞤪𞤫
      ca:𞤑𞤢𞤼𞤢𞤤𞤢𞤲𞤪𞤫
      cay:𞤑𞤢𞤴𞤺𞤢𞥄𞤪𞤫
      ccp:𞤅𞤢𞤳𞤥𞤢𞥄𞤪𞤫
      ce:𞤕𞤫𞤷𞤫𞤲𞤪𞤫
      ceb:𞤅𞤫𞤦𞤱𞤢𞤲𞤮𞥅𞤪𞤫
      cgg:𞤕𞤭𞤺𞤢𞥄𞤪𞤫
      ch:𞤕𞤢𞤥𞤮𞤪𞤮𞥅𞤪𞤫
      chk:𞤕𞤵𞥅𞤳𞤵𞥅𞤪𞤫
      chm:𞤃𞤢𞤪𞤭𞥅𞤪𞤫
      cho:𞤕𞤢𞤸𞤼𞤢𞥄𞤪𞤫
      chp:𞤕𞤭𞤨𞤴𞤢𞤲𞤪𞤫
      chr:𞤕𞤫𞥅𞤪𞤮𞤳𞤭𞥅𞤪𞤫
      chy:𞤅𞤢𞥄𞤴𞤢𞤲𞤪𞤫
      ckb:𞤑𞤵𞤪𞤣𞤵𞥅𞤪𞤫
      ckb-alt-menu:𞤑𞤵𞤪𞤣𞤵𞥅𞤪𞤫
      ckb-alt-variant:𞤑𞤵𞤪𞤣𞤵𞥅𞤪𞤫 𞤅𞤮𞤪𞤢𞤲𞤭
      clc:𞤕𞤭𞤤𞤳𞤮𞤼𞤭𞤲𞤪𞤫
      co:𞤑𞤮𞤪𞤧𞤭𞤳𞤢𞥄𞤪𞤫
      crg:𞤃𞤭𞤷𞤭𞤬𞤪𞤫
      crj:𞤑𞤪𞤭𞥅𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞤲𞤳𞤮
      crk:𞤆𞤤𞤫𞤭𞤲𞤧 𞤑𞤪𞤭𞥅𞤪𞤫
      crl:Vote 𞤑𞤪𞤭𞥅𞤪𞤫 𞤐𞤢𞤲𞤬𞤵𞤯𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫
      crm:𞤃𞤮𞥅𞤧𞤫 𞤑𞤪𞤭𞥅𞤪𞤫
      crr:𞤀𞤤𞤺𞤮𞤲𞤳𞤭𞤲𞤪𞤫 𞤑𞤢𞥄𞤪𞤤𞤭𞤲𞤢
      cs:𞤕𞤫𞤳𞤧𞤭𞤲𞤢𞥄𞤪𞤫
      csw:𞤑𞤪𞤭𞥅𞤪𞤫 𞤅𞤢𞤱𞤨𞤭𞥅
      cu:𞤅𞤭𞤤𞤾𞤭𞤳𞤪𞤫 𞤕𞤮𞥅𞤷𞤭
      cv:𞤕𞤵𞥅𞤾𞤢𞤧𞤪𞤫
      cy:𞤘𞤢𞤤𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      da:𞤁𞤢𞥄𞤲𞤭𞤧𞤳𞤮𞥅𞤪𞤫
      dak:𞤁𞤢𞤳𞤮𞤼𞤢𞥄𞤪𞤫
      dar:𞤁𞤢𞤪𞤺𞤭𞤲𞤢𞥄𞤪𞤫
      dav:𞤚𞤢𞤭𞤼𞤢𞥄𞤪𞤫
      de:𞤔𞤫𞤪𞤥𞤢𞤲𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      de-AT:𞤔𞤫𞤪𞤥𞤢𞤲𞤭𞤲𞤳𞤮𞥅𞤪𞤫 𞤌𞤼𞤭𞤪𞤧𞤢
      de-CH:𞤔𞤫𞤪𞤥𞤢𞤲𞤭𞤲𞤳𞤮𞥅𞤪𞤫 𞤅𞤵𞤱𞤭𞥅𞤧
      dgr:𞤁𞤮𞤺𞤪𞤭𞤦𞤪𞤫
      dje:𞤔𞤢𞤪𞤥𞤢𞥄𞤪𞤫
      doi:𞤁𞤮𞤺𞤪𞤭𞥅𞤪𞤫
      dsb:𞤂𞤫𞤧 𞤅𞤮𞤪𞤦𞤭𞤴𞤢𞤲𞤪𞤫
      dua:𞤁𞤵𞤱𞤢𞤤𞤢𞥄𞤪𞤫
      dv:𞤁𞤭𞥅𞤬𞤫𞤸𞤭𞥅𞤪𞤫
      dyo:𞤔𞤮𞥅𞤤𞤢𞥄𞤪𞤫
      dz:𞤄𞤵𞥅𞤼𞤢𞤲𞤪𞤫
      dzg:𞤁𞤢𞤶𞤢𞤺𞤢𞥄𞤪𞤫
      ebu:𞤉𞤥𞤦𞤵𞥅𞤪𞤫
      ee:𞤉𞤱𞤫𞥅𞤪𞤫
      efi:𞤉𞤬𞤭𞤳𞤪𞤫
      eka:𞤉𞤳𞤢𞤶𞤵𞤳𞤪𞤫
      el:𞤘𞤭𞥅𞤪𞤧𞤢𞥄𞤪𞤫
      en:𞤉𞤲𞤺𞤭𞤤𞤫𞥅𞤪𞤫
      en-GB-alt-short:𞤉𞤲𞤺𞤭𞤤𞤫𞥅𞤪𞤫 𞤁𞤘
      en-US:𞤉𞤲𞤺𞤭𞤤𞤫𞥅𞤪𞤫 𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞤲𞤳𞤮𞤪𞤫
      en-US-alt-short:𞤉𞤲𞤺𞤭𞤤𞤫𞥅𞤪𞤫 𞤁𞤂𞤀
      eo:𞤉𞤧𞤨𞤫𞤪𞤢𞤲𞤼𞤮𞥅𞤪𞤫
      es:𞤅𞤭𞤨𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫
      es-419:𞤅𞤭𞤨𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤀𞤥𞤭𞤪𞤭𞤳 𞤂𞤢𞤼𞤭𞤲𞤭𞤴𞤢
      es-ES:𞤅𞤭𞤨𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤀𞤪𞤮𞤦𞤢
      es-MX:𞤅𞤭𞤨𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤃𞤫𞤳𞤧𞤭𞤳
      et:𞤉𞤧𞤼𞤮𞤲𞤭𞤴𞤢𞤲𞤪𞤫
      eu:𞤄𞤢𞤧𞤳𞤢𞤪𞤢𞥄𞤪𞤫
      ewo:𞤉𞤱𞤮𞤲𞤣𞤮𞥅𞤪𞤫
      fa:𞤊𞤢𞥄𞤪𞤧𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫
      fa-AF:𞤁𞤢𞤪𞤭𞥅𞤪𞤫
      ff:𞤆𞤵𞤤𞤢𞤪
      fi:𞤊𞤫𞤲𞤭𞤧𞤪𞤫
      fil:𞤊𞤭𞤤𞤭𞤨𞤭𞤲𞤮𞥅𞤪𞤫
      fj:𞤊𞤭𞥅𞤶𞤭𞤴𞤢𞤲𞤪𞤫
      fo:𞤊𞤫𞤪𞤮𞤱𞤫𞤧𞤪𞤫
      fon:𞤊𞤮𞤲𞤪𞤫
      fr:𞤊𞤢𞤪𞤢𞤲𞤧𞤭𞥅𞤪𞤫
      fr-CA:𞤊𞤢𞤪𞤢𞤲𞤧𞤭𞥅𞤪𞤫 𞤑𞤢𞤲𞤢𞤣𞤢𞤲𞤳𞤮𞥅𞤪𞤫
      fr-CH:𞤊𞤢𞤪𞤢𞤲𞤧𞤭𞥅𞤪𞤫 𞤅𞤵𞤱𞤭𞥅𞤧
      frc:𞤊𞤢𞤪𞤢𞤲𞤧𞤭𞥅𞤪𞤫 𞤑𞤢𞤣𞤭𞤴𞤫𞤲𞤪𞤫
      frr:𞤊𞤭𞤪𞤧𞤭𞤴𞤢𞤲𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫
      fur:𞤊𞤭𞤪𞥇𞤵𞤤𞤭𞤴𞤢𞤲𞤪𞤫
      fy:𞤊𞤭𞤪𞤭𞥅𞤧𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤖𞤭𞤪𞤲𞤢
      ga:𞤋𞤪𞤤𞤢𞤲𞤣𞤫𞥅𞤪𞤫
      gaa:𞤘𞤢𞥄𞤪𞤫
      gd:𞤅𞤭𞤳𞤮𞤼𞤭𞤧𞤪𞤫 𞤘𞤢𞤫𞤭𞤳
      gez:𞤘𞤫𞥅𞤶𞤪𞤫
      gil:𞤘𞤭𞤤𞤦𞤫𞤪𞤼𞤫𞥅𞤧𞤪𞤫
      gl:𞤘𞤢𞤤𞤭𞥅𞤧𞤭𞤴𞤢𞤲𞤪𞤫
      gn:𞤘𞤵𞤢𞤪𞤢𞤲𞤭𞥅𞤪𞤫
      gor:𞤘𞤮𞤪𞤮𞤲𞤼𞤢𞤤𞤮𞥅𞤪𞤫
      gsw:𞤔𞤫𞤪𞤥𞤢𞤲𞤪𞤫 𞤅𞤵𞤱𞤭𞤧
      gu:𞤘𞤵𞤶𞤢𞤪𞤢𞤼𞤭𞥅𞤪𞤫
      guz:𞤘𞤵𞤧𞤭𞥅𞤪𞤫
      gv:𞤃𞤢𞤲𞤳𞤭𞤧𞤪𞤫
      gwi:𞤘𞤭𞤱𞤧𞤭𞤲𞤪𞤫
      ha:𞤖𞤢𞤱𞤧𞤢𞥄𞤪𞤫
      hai:𞤖𞤢𞤴𞤣𞤢𞥄𞤪𞤫
      haw:𞤖𞤢𞤱𞤢𞥄𞤭𞤴𞤫𞤲𞤪𞤫
      hax:𞤖𞤢𞤭𞤣𞤢𞥄𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞤲𞤳𞤮
      he:𞤖𞤭𞤦𞤵𞤪𞤵𞥅𞤪𞤫
      hi:𞤖𞤭𞤲𞤣𞤭𞥅𞤪𞤫
      hi-Latn-alt-variant:𞤖𞤭𞤲𞤺𞤭𞤤𞤭𞤧𞤭𞥅𞤪𞤫
      hil:𞤖𞤭𞤤𞤭𞤺𞤢𞤴𞤲𞤮𞤲𞤪𞤫
      hmn:𞤖𞤵𞤥𞤺𞤵𞤲𞤪𞤫
      hr:𞤑𞤮𞤪𞤮𞤱𞤢𞤧𞤭𞥅𞤪𞤫
      hsb:𞤅𞤮𞤪𞤦𞤭𞤴𞤢𞤲𞤪𞤫 𞤁𞤮𞤱𞤪𞤭
      ht:𞤀𞤳𞤵𞥅𞤪𞤫 𞤖𞤢𞤴𞤼𞤭𞥅
      hu:𞤖𞤵𞤲𞤺𞤢𞤪𞤭𞤴𞤢𞤲𞤪𞤫
      hup:𞤖𞤵𞤨𞤢𞥄𞤪𞤫
      hur:𞤖𞤢𞤤𞤳𞤮𞤥𞤫𞤤𞤫𞤥𞤪𞤫
      hy:𞤀𞤪𞤥𞤫𞤲𞤭𞥅𞤪𞤫
      hz:𞤖𞤫𞤪𞤫𞤪𞤮𞥅𞤪𞤫
      ia:𞤉𞤲𞤼𞤫𞤪𞤤𞤭𞤺𞤢𞥄𞤪𞤫
      iba:𞤋𞤦𞤢𞤲𞤪𞤫
      ibb:𞤋𞤦𞤭𞥅𞤦𞤭𞤴𞤮𞥅𞤪𞤫
      id:𞤋𞤲𞤣𞤮𞤲𞤭𞥅𞤧𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫
      ig:𞤋𞤦𞤮𞥅𞤪𞤫
      ii:𞤅𞤭𞤧𞤵𞤢𞤲𞤪𞤫 𞤒𞤭𞥅
      ikt:𞤋𞤲𞤵𞤳𞤼𞤵𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫 𞤑𞤢𞤲𞤢𞤣𞤢𞥄
      ilo:𞤋𞤤𞤮𞤳𞤮𞥅𞤪𞤫
      inh:𞤋𞤲𞤺𞤮𞤧𞤫𞥅𞤪𞤫
      io:𞤋𞤣𞤮𞥅𞤪𞤫
      is:𞤀𞤴𞤧𞤭𞤤𞤢𞤲𞤣𞤫𞥅𞤪𞤫
      it:𞤋𞤼𞤢𞤤𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      iu:𞤋𞤲𞤵𞤳𞤼𞤫𞥅𞤪𞤫
      ja:𞤐𞤭𞤨𞤮𞤲𞤪𞤫
      jbo:𞤂𞤮𞤶𞤦𞤢𞤲𞤪𞤫
      jgo:𞤐𞤺𞤮𞤥𞤦𞤢𞥄𞤪𞤫
      jmc:𞤃𞤢𞤳𞤢𞤥𞤫𞥅𞤪𞤫
      jv:𞤔𞤢𞥄𞤱𞤢𞤫𞥅𞤪𞤫
      ka:𞤔𞤮𞥅𞤪𞥁𞤭𞤴𞤢𞤲𞤪𞤫
      kab:𞤑𞤢𞤦𞤭𞤤𞤭𞥅𞤪𞤫
      kac:𞤑𞤢𞤧𞤭𞤲𞤪𞤫
      kaj:𞤑𞤢𞤶𞤫𞥅𞤪𞤫
      kam:𞤑𞤢𞤥𞤦𞤢𞥄𞤪𞤫
      kbd:𞤑𞤢𞤦𞤢𞤪𞤣𞤭𞤴𞤢𞤲𞤪𞤫
      kcg:𞤚𞤵𞤴𞤢𞤨𞤵𞥅𞤪𞤫
      kde:𞤃𞤢𞤳𞤮𞤲𞤣𞤫𞥅𞤪𞤫
      kea:𞤑𞤢𞤦𞤵𞤾𞤫𞤪𞤣𞤭𞤴𞤢𞤲𞤪𞤫
      kfo:𞤑𞤮𞤪𞤮𞥅𞤪𞤫
      kgp:𞤑𞤢𞤭𞤲𞤺𞤢𞤲𞤺𞤪𞤫
      kha:𞤝𞤢𞤧𞤭𞥅𞤪𞤫
      khq:𞤑𞤮𞤴𞤪𞤢𞤷𞤭𞤲𞤪𞤫
      ki:𞤑𞤭𞤳𞤵𞤴𞤵𞥅𞤪𞤫
      kj:𞤑𞤵𞤢𞤻𞤢𞤥𞤢𞥄𞤪𞤫
      kk:𞤑𞤢𞥁𞤢𞤳𞤪𞤫
      kkj:𞤑𞤢𞤳𞤮𞥅𞤪𞤫
      kl:𞤑𞤢𞤤𞤢𞥄𞤤𞤧𞤵𞤼𞤪𞤫
      kln:𞤑𞤢𞤤𞤫𞤲𞤶𞤭𞤲𞤪𞤫
      km:𞤑𞤵𞤥𞤢𞤴𞤪𞤫
      kmb:𞤑𞤭𞤥𞤦𞤵𞤲𞤣𞤵𞥅𞤪𞤫
      kn:𞤑𞤢𞤲𞥆𞤢𞤣𞤢𞥄𞤪𞤫
      ko:𞤑𞤮𞥅𞤪𞤫𞤴𞤢𞤲𞤪𞤫
      kok:𞤑𞤮𞤲𞤳𞤢𞤲𞤭𞥅𞤪𞤫
      kpe:𞤘𞤫𞤪𞤧𞤫𞥅𞤪𞤫
      kr:𞤑𞤮𞥅𞤤𞤫𞥅𞤪𞤫
      krc:𞤑𞤢𞤪𞤢𞤧𞤢𞤴-𞤄𞤢𞤤𞤳𞤢𞥄𞤪𞤫
      krl:𞤑𞤢𞤪𞤫𞤤𞤭𞤢𞤲𞤪𞤫
      kru:𞤑𞤵𞤪𞤵𞤿𞤵𞥅𞤪𞤫
      ks:𞤑𞤢𞥃𞤥𞤭𞥅𞤪𞤫
      ksb:𞤅𞤢𞤥𞤦𞤢𞤤𞤢𞥄𞤪𞤫
      ksf:𞤄𞤢𞤬𞤭𞤴𞤢𞥄𞤪𞤫
      ksh:𞤑𞤮𞤤𞤮𞤺𞤲𞤭𞤴𞤢𞤲𞤪𞤫
      ku:𞤑𞤵𞤪𞤣𞤭𞤧𞤭𞥅𞤪𞤫
      kum:𞤑𞤵𞤥𞤴𞤢𞤳𞤪𞤫
      kv:𞤑𞤮𞤥𞤭𞥅𞤪𞤫
      kw:𞤑𞤮𞤪𞤲𞤭𞥅𞤪𞤫
      kwk:𞤑𞤢𞤱𞤳𞥇𞤱𞤢𞤤𞤢𞥄𞤪𞤫
      ky:𞤑𞤭𞤪𞤺𞤵𞥅𞤪𞤫
      la:𞤂𞤢𞤼𞤫𞤲𞤪𞤫
      lad:𞤂𞤢𞤣𞤭𞤲𞤮𞥅𞤪𞤫
      lag:𞤂𞤢𞤲𞤺𞤭𞥅𞤪𞤫
      lb:𞤂𞤵𞥁𞤫𞤲𞤦𞤵𞥅𞤪𞤺𞤭𞤧𞤪𞤫
      lez:𞤂𞤫𞥁𞤺𞤭𞤴𞤢𞤲𞤪𞤫
      lg:𞤘𞤢𞤲𞤣𞤢𞥄𞤪𞤫
      li:𞤂𞤭𞤥𞤦𞤵𞤪𞤺𞤵𞤧𞤪𞤫
      lij:𞤂𞤳𞤭𞤺𞤵𞥅𞤪𞤫
      lil:𞤂𞤭𞤤𞥆𞤮𞥅𞤫𞤼𞤪𞤫
      lkt:𞤂𞤢𞤳𞤮𞤼𞤢𞥄𞤪𞤫
      lmo:𞤂𞤮𞤥𞤦𞤢𞤪𞤣𞤫
      ln:𞤂𞤭𞤲𞤺𞤢𞤤𞤢𞥄𞤪𞤫
      lo:𞤂𞤢𞤮𞥅𞤪𞤫
      lou:𞤀𞤳𞤵𞥅𞤪𞤫 𞤂𞤵𞥅𞥁𞤭𞤴𞤢𞥄𞤲𞤢
      loz:𞤂𞤮𞥁𞤭𞥅𞤪𞤫
      lrc:𞤂𞤵𞤪𞤭𞥅𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫
      lsm:𞤅𞤢𞥄𞤥𞤭𞤢𞥄𞤪𞤫
      lt:𞤂𞤭𞤼𞤮𞤲𞤭𞤴𞤢𞤲𞤪𞤫
      lu:𞤂𞤵𞤦𞤢-𞤑𞤢𞤼𞤢𞤲𞤺𞤢𞥄𞤪𞤫
      lua:𞤂𞤵𞤦𞤢 𞤑𞤢𞤧𞤢𞤭𞤪𞤫
      lun:𞤂𞤵𞤲𞤣𞤢𞥄𞤪𞤫
      luo:𞤂𞤵𞤮𞥅𞤪𞤫
      lus:𞤃𞤭𞤧𞤮𞥅𞤪𞤫
      luy:𞤂𞤵𞤴𞤭𞤢𞥄𞤪𞤫
      lv:𞤂𞤢𞤼𞤾𞤭𞤴𞤢𞤲𞤪𞤫
      mad:𞤃𞤢𞤣𞤵𞤪𞤫𞥅𞤪𞤫
      mag:𞤃𞤢𞤺𞤢𞤸𞤭𞥅𞤪𞤫
      mai:𞤃𞤢𞤴𞤭𞤼𞤭𞤤𞤭𞥅𞤪𞤫
      mak:𞤃𞤢𞤳𞤢𞤧𞤢𞤪𞤢𞥄𞤪𞤫
      mas:𞤃𞤢𞤧𞤢𞤴𞤭𞥅𞤪𞤫
      mdf:𞤃𞤮𞤳𞤧𞤢𞤲𞤳𞤮𞥅𞤪𞤫
      men:𞤃𞤫𞤲𞤣𞤫𞥅𞤪𞤫
      mer:𞤃𞤫𞤪𞤵𞥅𞤪𞤫
      mfe:𞤃𞤮𞤪𞤭𞥅𞤧𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      mg:𞤃𞤢𞤤𞤢𞤺𞤢𞤧𞤭𞥅𞤪𞤫
      mgh:𞤃𞤢𞤳𞤵𞤱𞤢𞥄𞤪𞤫
      mgo:𞤃𞤫𞤼𞤢𞥄𞤪𞤫
      mh:𞤃𞤢𞤪𞤧𞤢𞤤𞤫𞥅𞤪𞤫
      mi:𞤃𞤢𞥄𞤮𞤪𞤭𞥅𞤪𞤫
      mic:𞤃𞤭𞤳𞤥𞤢𞤹𞤵𞥅𞤪𞤫
      min:𞤃𞤭𞤲𞤢𞤲𞤺𞤳𞤢𞤦𞤢𞤵𞥅𞤪𞤫
      mk:𞤃𞤢𞤧𞤫𞤣𞤮𞤲𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      ml:𞤃𞤢𞤤𞤢𞤴𞤢𞤤𞤢𞤥𞤪𞤫
      mn:𞤃𞤮𞤲𞤺𞤮𞤤𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      mni:𞤃𞤢𞤲𞤭𞤨𞤵𞥅𞤪𞤫
      moe:𞤋𞤲𞥆𞤵-𞤢𞤴𞤥𞤵𞤲𞤪𞤫
      moh:𞤃𞤮𞥅𞤸𞤢𞤲𞤳𞤮𞥅𞤪𞤫
      mos:𞤃𞤮𞥅𞤧𞤭𞥅𞤪𞤫
      mr:𞤃𞤢𞤪𞤢𞤼𞤭𞥅𞤪𞤫
      ms:𞤃𞤢𞤤𞤫𞥅𞤪𞤫
      mt:𞤃𞤢𞤤𞤼𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      mua:𞤃𞤵𞤲𞤣𞤢𞤲𞤪𞤫
      mul:𞤍𞤫𞤲𞤯𞤫 𞤅𞤫𞤪𞤼𞤵𞤯𞤫
      mus:𞤃𞤵𞤧𞤳𞤮𞤳𞤭𞥅𞤪𞤫
      mwl:𞤃𞤭𞤪𞤢𞤲𞤣𞤫𞥅𞤪𞤫
      my:𞤄𞤵𞤪𞤥𞤢𞥄𞤪𞤫
      myv:𞤉𞤪𞤶𞤭𞤴𞤢𞤲𞤪𞤫
      mzn:𞤃𞤢𞥁𞤢𞤲𞤣𞤫𞤪𞤢𞤲𞤭𞥅𞤪𞤫
      na:𞤐𞤢𞤱𞤵𞤪𞤵𞤲𞤳𞤮𞥅𞤪𞤫
      nap:𞤐𞤢𞥄𞤨𞤮𞤤𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      naq:𞤐𞤢𞤥𞤢𞥄𞤪𞤫
      nb:𞤐𞤮𞤪𞤱𞤫𞤶𞤭𞤴𞤢𞤲𞤪𞤫 𞤄𞤮𞤳𞤥𞤢𞤤
      nd:𞤐𞤣𞤫𞤦𞤫𞤤𞤫𞥅𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤺𞤫
      nds:𞤂𞤫𞤧-𞤀𞤤𞤵𞤥𞤢𞤲𞤪𞤫
      nds-NL:𞤂𞤫𞤧 𞤅𞤢𞤳𞤧𞤮𞤲𞤪𞤫
      ne:𞤐𞤫𞤨𞤢𞤤𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      new:𞤐𞤫𞤱𞤢𞤪𞤭𞥅𞤪𞤫
      ng:𞤐𞤣𞤮𞤲𞤺𞤢𞥄𞤪𞤫
      nia:𞤙𞤢𞤧𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      niu:𞤐𞤭𞤵𞤫𞤴𞤢𞤲𞤪𞤫
      nl:𞤁𞤮𞥅𞤷𞤵𞤪𞤫
      nl-BE:𞤊𞤭𞤤𞤢𞤥𞤢𞤲𞤪𞤫
      nmg:𞤐𞤺𞤵𞤥𞤦𞤢𞥄𞤪𞤫
      nn:𞤐𞤮𞤪𞤱𞤫𞤶𞤭𞤴𞤢𞤲𞤪𞤫 𞤙𞤮𞤪𞤧𞤳
      nnh:𞤐𞤶𞤢𞤥𞤦𞤵𞥅𞤪𞤫
      no:𞤐𞤮𞤪𞤱𞤫𞤶𞤭𞤴𞤢𞤲𞤪𞤫
      nog:𞤐𞤮𞤺𞤢𞤭𞥅𞤪𞤫
      nqo:𞤐𞤳𞤮𞥅𞤪𞤫
      nr:𞤐𞤣𞤫𞤦𞤫𞤤𞤫𞥅𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫
      nso:𞤅𞤮𞤼𞤮𞥅𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫
      nus:𞤐𞤵𞤫𞤪𞤭𞥅𞤪𞤫
      nv:𞤐𞤢𞤬𞤱𞤢𞤸𞤮𞥅𞤪𞤫
      ny:𞤙𞤢𞤲𞤶𞤢𞥄𞤪𞤫
      nyn:𞤙𞤢𞤲𞤳𞤮𞤤𞤫𞥅𞤪𞤫
      oc:𞤌𞤷𞥆𞤭𞤼𞤢𞤲𞤪𞤫
      ojb:𞤌𞤶𞤭𞤦𞤵𞤱𞤢𞥄𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫
      ojc:𞤌𞤶𞤭𞤦𞤵𞤱𞤪𞤫 𞤕𞤢𞤳𞤢
      ojs:𞤌𞤶𞤭-𞤑𞤪𞤭𞥅𞤪𞤫
      ojw:𞤌𞤶𞤭𞤦𞤱𞤢𞥄𞤪𞤫 𞤖𞤭𞥅𞤪𞤲𞤢𞥄𞤲𞤺𞤫
      oka:𞤌𞤳𞤢𞤲𞤢𞤺𞤢𞤲𞤪𞤫
      om:𞤌𞤪𞤮𞤥𞤮𞥅𞤪𞤫
      or:𞤌𞤣𞤭𞤢𞥄𞤪𞤫
      os:𞤌𞤧𞥆𞤫𞤼𞤭𞤳𞤪𞤫
      pa:𞤆𞤵𞤲𞤶𞤢𞥄𞤦𞤭𞥅𞤪𞤫
      pag:𞤆𞤢𞤲𞤺𞤢𞤧𞤭𞤲𞤢𞤲𞤪𞤫
      pam:𞤆𞤢𞤥𞤨𞤢𞤲𞤺𞤢𞥄𞤪𞤫
      pap:𞤆𞤢𞤨𞤭𞤢𞤥𞤫𞤲𞤼𞤮𞥅𞤪𞤫
      pau:𞤆𞤢𞤤𞤢𞤵𞤴𞤢𞤲𞤪𞤫
      pcm:𞤆𞤭𞤶𞤫𞤲𞤪𞤫 𞤐𞤢𞤶𞤭𞤪𞤭𞤴𞤢𞥄
      pis:𞤆𞤭𞤶𞤭𞤲𞤪𞤫
      pl:𞤆𞤮𞤤𞤢𞤲𞤣𞤭𞥅𞤪𞤫
      pqm:𞤃𞤢𞤤𞤭𞤧𞤫𞥅𞤼-𞤆𞤢𞤧𞤢𞤥𞤢𞤹𞤵𞤮𞤣𞥆𞤭
      prg:𞤆𞤵𞤪𞤧𞤭𞤴𞤢𞤲𞤪𞤫
      ps:𞤆𞤢𞤧𞤼𞤵𞤲𞤪𞤫
      pt:𞤆𞤮𞤪𞤼𞤮𞤳𞤫𞥅𞤧𞤭𞥅𞤪𞤫
      pt-BR:𞤆𞤮𞤪𞤼𞤮𞤳𞤫𞥅𞤧𞤭𞥅𞤪𞤫 𞤄𞤪𞤫𞥁𞤭𞤤
      pt-PT:𞤆𞤮𞤪𞤼𞤮𞤳𞤫𞥅𞤧𞤭𞥅𞤪𞤫 𞤆𞤮𞤪𞤼𞤭𞤺𞤢𞥄𞤤
      qu:𞤗𞤵𞤷𞤵𞤢𞤲𞤪𞤫
      raj:𞤈𞤢𞤶𞤢𞤧𞤼𞤢𞤲𞤭𞥅𞤪𞤫
      rap:𞤈𞤢𞤨𞤢𞤲𞤵𞤭𞥅𞤪𞤫
      rar:𞤈𞤢𞤪𞤮𞤼𞤮𞤲𞤺𞤢𞤲𞤪𞤫
      rhg:𞤈𞤮𞤸𞤭𞤲𞤺𞤢𞥄𞤪𞤫
      rif:𞤈𞤭𞤬𞤭𞤴𞤢𞤲𞤪𞤫
      rm:𞤈𞤮𞤥𞤢𞤲𞤧𞤪𞤫
      rn:𞤈𞤵𞤲𞤣𞤭𞥅𞤪𞤫
      ro:𞤈𞤮𞤥𞤢𞤲𞤭𞤴𞤢𞤲𞤪𞤫
      ro-MD:𞤃𞤮𞤤𞤣𞤢𞤾𞤭𞤴𞤢𞤲𞤪𞤫
      rof:𞤈𞤮𞤥𞤦𞤮𞥅𞤪𞤫
      ru:𞤈𞤮𞥅𞤧𞤭𞤴𞤢𞤲𞤪𞤫
      rup:𞤀𞤪𞤮𞤥𞤢𞤲𞤭𞥅𞤪𞤫
      rw:𞤑𞤭𞤻𞤭𞤪𞤵𞤱𞤢𞤲𞤣𞤫𞥅𞤪𞤫
      rwk:𞤈𞤵𞤱𞤢𞥄𞤪𞤫
      sa:𞤅𞤢𞤲𞤧𞤳𞤪𞤭𞤼𞤪𞤫
      sad:𞤅𞤢𞤲𞤣𞤢𞤱𞤫𞥅𞤪𞤫
      sah:𞤅𞤢𞤿𞤢𞥄𞤪𞤫
      saq:𞤅𞤢𞤥𞤦𞤵𞤪𞤵𞥅𞤪𞤫
      sat:𞤅𞤢𞤲𞤼𞤢𞤤𞤭𞥅𞤪𞤫
      sba:𞤐𞤺𞤢𞤥𞤦𞤢𞤴𞤪𞤫
      sbp:𞤅𞤢𞤲𞤺𞤵𞥅𞤪𞤫
      sc:𞤅𞤢𞤪𞤣𞤭𞤲𞤭𞤴𞤢𞤲𞤪𞤫
      scn:𞤅𞤭𞤧𞤭𞤤𞤭𞤴𞤢𞤲𞤪𞤫
      sco:𞤅𞤭𞤳𞤮𞤼𞤧𞤪𞤫
      sd:𞤅𞤭𞤲𞤣𞤢𞥄𞤪𞤫
      se:𞤅𞤢𞤥𞤭𞥅𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫
      seh:𞤅𞤫𞤲𞤢𞥄𞤪𞤫
      ses:𞤑𞤮𞤪𞤮𞤦𞤮𞤪𞤮𞥅𞤪𞤫 𞤅𞤫𞤲𞥆𞤭
      sg:𞤅𞤢𞤲𞤺𞤮𞥅𞤪𞤫
      shi:𞤚𞤢𞤧𞤭𞤤𞤸𞤭𞤼𞤪𞤫
      shn:𞤅𞤢𞤲𞤪𞤫
      si:𞤅𞤭𞤲𞤸𞤢𞤤𞤢𞥄𞤪𞤫
      sk:𞤅𞤤𞤮𞤾𞤢𞥄𞤳𞤪𞤫
      sl:𞤅𞤤𞤮𞤾𞤫𞤲𞤭𞤴𞤢𞤲𞤪𞤫
      slh:𞤂𞤵𞥃𞤵𞤼𞤧𞤭𞤣𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞤲𞤳𞤮
      sm:𞤅𞤢𞤥𞤮𞤢𞤲𞤪𞤫
      smn:𞤋𞤲𞤢𞤪𞤭𞤧𞤳𞤢𞤤𞤭𞥅𞤪𞤫
      sms:𞤅𞤭𞤳𞤮𞤤𞤼 𞤅𞤢𞤥𞤭𞥅𞤪𞤫
      sn:𞤅𞤮𞤲𞤢𞥄𞤪𞤫
      snk:𞤅𞤢𞤪𞤢𞤲𞤳𞤵𞤤𞥆𞤪𞤫
      so:𞤅𞤮𞤥𞤢𞤤𞤭𞥅𞤪𞤫
      sq:𞤀𞤤𞤦𞤢𞤲𞤭𞥅𞤪𞤫
      sr:𞤅𞤫𞤪𞤦𞤭𞤴𞤢𞤲𞤪𞤫
      srn:𞤅𞤢𞤪𞤲𞤢𞤲-𞤚𞤮𞤲𞤺𞤮𞥅𞤪𞤫
      ss:𞤅𞤵𞤱𞤢𞤼𞤭𞥅𞤪𞤫
      st:𞤅𞤮𞤼𞤮𞥅𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞤲𞤳𞤮
      str:𞤅𞤭𞤼𞤪𞤭𞤼 𞤅𞤢𞤤𞤭𞤧𞤪𞤫
      su:𞤅𞤵𞤲𞤣𞤢𞤲𞤭𞥅𞤪𞤫
      suk:𞤅𞤵𞤳𞤵𞤥𞤢𞥄𞤪𞤫
      sv:𞤅𞤱𞤫𞤣𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      sw:𞤅𞤵𞤱𞤢𞤸𞤭𞤤𞤭𞥅𞤪𞤫
      sw-CD:𞤅𞤵𞤱𞤢𞤸𞤭𞤤𞤭𞥅𞤪𞤫 𞤑𞤮𞤲𞤺𞤮 𞤑𞤭𞤲𞤧𞤢𞤧𞤢
      swb:𞤑𞤮𞤥𞤮𞤪𞤭𞥅𞤪𞤫
      syr:𞤅𞤭𞥅𞤪𞤭𞤴𞤢𞤳𞤪𞤫
      ta:𞤚𞤢𞤥𞤵𞤤𞤪𞤫
      tce:𞤚𞤵𞤼𞤳𞤮𞤲𞤭𞥅𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫
      te:𞤚𞤫𞤤𞤫𞤺𞤵𞥅𞤪𞤫
      tem:𞤚𞤫𞤥𞤫𞤲𞤫𞥅𞤪𞤫
      teo:𞤚𞤫𞤧𞤮𞥅𞤪𞤫
      tet:𞤚𞤫𞤼𞤵𞤥𞤪𞤫
      tg:𞤚𞤢𞤶𞤭𞤳𞤪𞤫
      tgx:𞤚𞤢𞤺𞤭𞥃𞤪𞤫
      th:𞤚𞤢𞤴𞤤𞤢𞤲𞤣𞤫𞥅𞤪𞤫
      tht:𞤚𞤢𞤸𞤢𞤤𞤼𞤢𞤲𞤪𞤫
      ti:𞤚𞤭𞤺𞤭𞤪𞤻𞤢𞥄𞤪𞤫
      tig:𞤚𞤭𞤺𞤭𞤪𞤴𞤢𞤲𞤪𞤫
      tk:𞤼𞤵𞤪𞤳𞤥𞤢𞤲𞤪𞤫
      tlh:𞤑𞤭𞤤𞤭𞤲𞤺𞤮𞤲𞤪𞤫
      tli:𞤚𞤤𞤭𞤲𞤺𞤭𞤼𞤪𞤫
      tn:𞤚𞤭𞤧𞤱𞤢𞤲𞤢𞥄𞤪𞤫
      to:𞤚𞤮𞤲𞤺𞤢𞤲𞤪𞤫
      tok:𞤚𞤮𞤳𞤭 𞤆𞤮𞤲𞤢𞥄𞤪𞤫
      tpi:𞤚𞤮𞤳 𞤆𞤭𞤧𞤭𞤲𞤪𞤫
      tr:𞤚𞤵𞥅𞤪𞤢𞤲𞤳𞤮𞥅𞤪𞤫
      trv:𞤚𞤢𞤪𞤮𞤳𞤮𞥅𞤪𞤫
      ts:𞤚𞤭𞤧𞤮𞤲𞤺𞤢𞥄𞤪𞤫
      tt:𞤚𞤢𞤼𞤢𞤪𞥇𞤪𞤫
      ttm:𞤚𞤵𞤼𞤷𞤮𞤲𞤫𞤲𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫
      tum:𞤚𞤵𞤥𞤦𞤵𞤳𞤢𞥄𞤪𞤫
      tvl:𞤚𞤵𞤾𞤢𞤤𞤵𞥅𞤪𞤫
      twq:𞤚𞤢𞤧𞤢𞥄𞤹𞤪𞤫
      ty:𞤚𞤢𞤸𞤭𞤼𞤭𞤴𞤢𞤲𞤪𞤫
      tyv:𞤚𞤵𞤾𞤭𞤲𞤭𞤴𞤢𞤲𞤪𞤫
      tzm:𞤚𞤢𞤥𞤢𞤶𞤭𞤼𞤪𞤫 𞤅𞤢𞤲𞤼𞤪𞤢𞤤 𞤀𞤼𞤤𞤢𞤧
      udm:𞤓𞤣𞤥𞤵𞤪𞤼𞤪𞤫
      ug:𞤓𞥅𞤴𞤺𞤵𞥅𞤪𞤫
      uk:𞤒𞤵𞤳𞤪𞤫𞤲𞤭𞤴𞤢𞤲𞤪𞤫
      umb:𞤓𞤥𞤦𞤵𞤲𞤣𞤵𞥅𞤪𞤫
      und:𞤍𞤫𞤲𞤺𞤢𞤤 𞤢𞤧-𞤢𞤲𞤣𞤢𞥄𞤲𞤺𞤢𞤤
      ur:𞤓𞤪𞤣𞤵𞥅𞤪𞤫
      uz:𞤓𞥅𞤧𞤦𞤫𞤳𞤪𞤫
      vai:𞤾𞤢𞥄𞤴𞤪𞤫
      ve:𞤏𞤫𞤲𞤣𞤢𞥄𞤪𞤫
      vec:𞤏𞤫𞤲𞤭𞥅𞤧𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫
      vi:𞤏𞤭𞤴𞤫𞤼𞤲𞤢𞤥𞤭𞤲𞤳𞤮𞥅𞤪𞤫
      vo:𞤏𞤮𞤤𞤢𞤨𞤵𞤳𞤪𞤫
      vun:𞤏𞤵𞤲𞤶𞤮𞥅𞤪𞤫
      wa:𞤏𞤢𞥄𞤤𞤮𞤲𞤳𞤮𞥅𞤪𞤫
      wae:𞤏𞤢𞤤𞤧𞤫𞥅𞤪𞤫
      wal:𞤏𞤮𞥅𞤤𞤢𞤴𞤼𞤢𞥄𞤪𞤫
      war:𞤏𞤢𞤪𞤢𞤴𞤫𞥅𞤪𞤫
      wo:𞤏𞤮𞤤𞤮𞤬𞤪𞤫
      wuu:𞤏𞤵𞥅𞤪𞤫 𞤅𞤭𞥅𞤲
      xal:𞤑𞤢𞤤𞤥𞤵𞤳𞤪𞤫
      xh:𞤑𞤮𞥅𞤧𞤢𞥄𞤪𞤫
      xog:𞤅𞤮𞤺𞤢𞥄𞤪𞤫
      yav:𞤒𞤢𞤲𞤺𞤦𞤫𞥅𞤪𞤫
      ybb:𞤒𞤫𞤥𞤦𞤢𞥄𞤪𞤫
      yi:𞤒𞤭𞤣𞤭𞤧𞤢𞤲𞤳𞤮𞥅𞤪𞤫
      yo:𞤒𞤮𞥅𞤪𞤵𞤦𞤢𞥄𞤪𞤫
      yrl:𞤛𞤫𞥅𞤲𞤺𞤢𞤼𞤵𞥅𞤪𞤫
      yue:𞤑𞤢𞤲𞤼𞤮𞤲𞤫𞥅𞤪𞤫
      yue-alt-menu:𞤑𞤢𞤲𞤼𞤮𞤲𞤫𞥅𞤪𞤫 𞤅𞤭𞥅𞤲
      zgh:𞤚𞤢𞤥𞤢𞥁𞤭𞤼𞤪𞤫 𞤖𞤢𞤲𞤼𞤵𞤲𞥋𞤣𞤫 𞤃𞤢𞤪𞤮𞥅𞤳
      zh:𞤕𞤢𞤴𞤲𞤢𞤲𞤳𞤮𞥅𞤪𞤫
      zh-alt-menu:𞤕𞤢𞤴𞤲𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤃𞤢𞤲𞤣𞤢𞤪𞤫𞤲𞤪𞤫
      zh-Hans:𞤕𞤢𞤴𞤲𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤖𞤮𞤴𞤬𞤭𞤲𞤢𞥄𞤲𞤣𞤫
      zh-Hans-alt-long:𞤃𞤢𞤲𞤣𞤢𞤪𞤫𞤲𞤪𞤫 𞤖𞤮𞤴𞤬𞤭𞤲𞤢𞥄𞤲𞤣𞤫
      zh-Hant:𞤕𞤢𞤴𞤲𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤒𞤫𞤷𞥆𞤵𞤲𞥋𞤣𞤫
      zh-Hant-alt-long:𞤃𞤢𞤲𞤣𞤢𞤪𞤫𞤲𞤪𞤫 𞤀𞤪𞤣𞤭𞥅𞤲𞤣𞤫
      zu:𞥁𞤵𞤤𞤵𞥅𞤪𞤫
      zun:𞤟𞤵𞤲𞤭𞥅𞤪𞤫
      zxx:𞤀𞤤𞤢𞥄 𞤦𞤢𞤯𞤮𞤪𞤢𞤤 𞤯𞤫𞤲𞤯𞤢𞤲𞤳𞤮
      zza:𞤟𞤢𞥁𞤢𞥄𞤪𞤫
      """.trimIndent() }

  val ff_Adlm_BF: String? = null

  val ff_Adlm_CM: String? = null

  val ff_Adlm_GH: String? = null

  val ff_Adlm_GM: String? = null

  val ff_Adlm_GW: String? = null

  val ff_Adlm_LR: String? = null

  val ff_Adlm_MR: String? = null

  val ff_Adlm_NE: String? = null

  val ff_Adlm_NG: String? = null

  val ff_Adlm_SL: String? = null

  val ff_Adlm_SN: String? = null

  val ff_Latn: String? = null

  val ff_Latn_BF: String? = null

  val ff_Latn_CM: String? = null

  val ff_Latn_GH: String? = null

  val ff_Latn_GM: String? = null

  val ff_Latn_GN: String? = null

  val ff_Latn_GW: String? = null

  val ff_Latn_LR: String? = null

  val ff_Latn_MR: String? = null

  val ff_Latn_NE: String? = null

  val ff_Latn_NG: String? = null

  val ff_Latn_SL: String? = null

  val fi: String by lazy { """
      aa:afar
      ab:abhaasi
      ace:atšeh
      ach:atšoli
      ada:adangme
      ady:adyge
      ae:avesta
      aeb:tunisianarabia
      af:afrikaans
      afh:afrihili
      agq:aghem
      ain:ainu
      ajp:urduni
      ak:akan
      akk:akkadi
      akz:alabama
      ale:aleutti
      aln:gegi
      alt:altai
      am:amhara
      an:aragonia
      ang:muinaisenglanti
      ann:obolo
      anp:angika
      ar:arabia
      ar-001:yleisarabia
      arc:valtakunnanaramea
      arn:mapudungun
      aro:araona
      arp:arapaho
      arq:algerianarabia
      ars:arabia – najd
      arw:arawak
      ary:marokonarabia
      arz:egyptinarabia
      as:assami
      asa:asu
      ase:amerikkalainen viittomakieli
      ast:asturia
      atj:atikamekw
      av:avaari
      avk:kotava
      awa:awadhi
      ay:aimara
      az:azeri
      az-alt-short:azeri
      ba:baškiiri
      bal:belutši
      ban:bali
      bar:baijeri
      bas:basaa
      bax:bamum
      bbc:batak-toba
      bbj:ghomala
      be:valkovenäjä
      bej:bedža
      bem:bemba
      bew:betawi
      bez:bena
      bfd:fut
      bfq:badaga
      bg:bulgaria
      bgc:haryanvi
      bgn:länsibelutši
      bho:bhodžpuri
      bi:bislama
      bik:bikol
      bin:bini
      bjn:banjar
      bkm:kom
      bla:siksika
      blo:anii
      blt:tai dam
      bm:bambara
      bn:bengali
      bo:tiibet
      bpy:bišnupria
      bqi:bahtiari
      br:bretoni
      bra:bradž
      brh:brahui
      brx:bodo
      bs:bosnia
      bss:koose
      bua:burjaatti
      bug:bugi
      bum:bulu
      byn:bilin
      byv:medumba
      ca:katalaani
      cad:caddo
      car:karibi
      cay:cayuga
      cch:atsam
      ccp:chakma
      ce:tšetšeeni
      ceb:cebuano
      cgg:kiga
      ch:tšamorro
      chb:tšibtša
      chg:tšagatai
      chk:chuuk
      chm:mari
      chn:chinook-jargon
      cho:choctaw
      chp:chipewyan
      chr:cherokee
      chy:cheyenne
      cic:chickasaw
      ckb:soranî
      ckb-alt-menu:kurdi – soranî
      ckb-alt-variant:soranî
      clc:chilcotin
      co:korsika
      cop:kopti
      cps:capiznon
      cr:cree
      crg:michif
      crh:krimintataari
      crh-alt-secondary:kriminturkki
      crj:east cree (eteläinen)
      crk:plains cree
      crl:east cree (pohjoinen)
      crm:moose cree
      crr:pamlico
      crs:seychellienkreoli
      cs:tšekki
      csb:kašubi
      csw:swampy cree
      cu:kirkkoslaavi
      cv:tšuvassi
      cy:kymri
      da:tanska
      dak:dakota
      dar:dargi
      dav:taita
      de:saksa
      de-AT:itävallansaksa
      de-CH:sveitsinyläsaksa
      del:delaware
      den:slevi
      dgr:dogrib
      din:dinka
      dje:djerma
      doi:dogri
      dsb:alasorbi
      dtp:dusun
      dua:duala
      dum:keskihollanti
      dv:divehi
      dyo:jola-fonyi
      dyu:djula
      dz:dzongkha
      dzg:dazaga
      ebu:embu
      ee:ewe
      efi:efik
      egl:emilia
      egy:muinaisegypti
      eka:ekajuk
      el:kreikka
      elx:elami
      en:englanti
      en-AU:australianenglanti
      en-CA:kanadanenglanti
      en-GB:britannianenglanti
      en-GB-alt-short:englanti (Britannia)
      en-US:amerikanenglanti
      en-US-alt-short:englanti (USA)
      enm:keskienglanti
      eo:esperanto
      es:espanja
      es-419:amerikanespanja
      es-ES:euroopanespanja
      es-MX:meksikonespanja
      esu:alaskanjupik
      et:viro
      eu:baski
      ewo:ewondo
      ext:extremadura
      fa:persia
      fa-AF:dari
      fan:fang
      fat:fanti
      ff:fulani
      fi:suomi
      fil:filipino
      fit:meänkieli
      fj:fidži
      fo:fääri
      fon:fon
      fr:ranska
      fr-CA:kanadanranska
      fr-CH:sveitsinranska
      frc:cajunranska
      frm:keskiranska
      fro:muinaisranska
      frp:arpitaani
      frr:pohjoisfriisi
      frs:itäfriisi
      fur:friuli
      fy:länsifriisi
      ga:iiri
      gaa:ga
      gag:gagauzi
      gan:gan-kiina
      gay:gajo
      gba:gbaja
      gbz:zoroastrialaisdari
      gd:gaeli
      gez:ge’ez
      gil:kiribati
      gl:galicia
      glk:gilaki
      gmh:keskiyläsaksa
      gn:guarani
      goh:muinaisyläsaksa
      gon:gondi
      gor:gorontalo
      got:gootti
      grb:grebo
      grc:muinaiskreikka
      gsw:sveitsinsaksa
      gu:gudžarati
      guc:wayuu
      gur:frafra
      guz:gusii
      gv:manksi
      gwi:gwitšin
      ha:hausa
      hai:haida
      hak:hakka-kiina
      haw:havaiji
      hax:haida (eteläinen)
      he:heprea
      hi:hindi
      hi-Latn-alt-variant:hinglish
      hif:fidžinhindi
      hil:hiligaino
      hit:heetti
      hmn:hmong
      hnj:hmong njua
      ho:hiri-motu
      hr:kroatia
      hsb:yläsorbi
      hsn:xiang-kiina
      ht:haiti
      hu:unkari
      hup:hupa
      hur:halkomelem
      hy:armenia
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonesia
      ie:interlingue
      ig:igbo
      ii:sichuanin-yi
      ik:inupiaq
      ikt:Länsi-Kanadan inuktitut
      ilo:iloko
      inh:inguuši
      io:ido
      is:islanti
      it:italia
      iu:inuktitut
      izh:inkeroinen
      ja:japani
      jam:jamaikankreolienglanti
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jpr:juutalaispersia
      jrb:juutalaisarabia
      jut:juutti
      jv:jaava
      ka:georgia
      kaa:karakalpakki
      kab:kabyyli
      kac:katšin
      kaj:jju
      kam:kamba
      kaw:kavi
      kbd:kabardi
      kbl:kanembu
      kcg:tyap
      kde:makonde
      kea:kapverdenkreoli
      ken:kenyang
      kfo:norsunluurannikonkoro
      kg:kongo
      kgp:kaingang
      kha:khasi
      kho:khotani
      khq:koyra chiini
      khw:khowar
      ki:kikuju
      kiu:kirmanjki
      kj:kuanjama
      kk:kazakki
      kkj:kako
      kl:kalaallisut
      kl-alt-secondary:grönlanti
      kln:kalenjin
      km:khmer
      kmb:kimbundu
      kn:kannada
      ko:korea
      koi:komipermjakki
      kok:konkani
      kos:kosrae
      kpe:kpelle
      kr:kanuri
      krc:karatšai-balkaari
      kri:krio
      krj:kinaray-a
      krl:karjala
      kru:kurukh
      ks:kašmiri
      ksb:shambala
      ksf:bafia
      ksh:kölsch
      ku:kurdi
      kum:kumykki
      kut:kutenai
      kv:komi
      kw:korni
      kwk:kwakʼwala
      kxv:kuvi
      ky:kirgiisi
      la:latina
      lad:ladino
      lad-alt-secondary:juutalaisespanja
      lag:lango
      lah:lahnda
      lam:lamba
      lb:luxemburg
      lez:lezgi
      lfn:lingua franca nova
      lg:ganda
      li:limburg
      lij:liguuri
      lil:lillooet
      liv:liivi
      lkt:lakota
      lld:ladin
      lmo:lombardi
      ln:lingala
      lo:lao
      lol:mongo
      lou:louisianankreoli
      loz:lozi
      lrc:pohjoisluri
      lsm:samia
      lt:liettua
      ltg:latgalli
      lu:katanganluba
      lua:luluanluba
      lui:luiseño
      lun:lunda
      lus:lusai
      luy:luhya
      lv:latvia
      lzh:klassinen kiina
      lzz:lazi
      mad:madura
      maf:mafa
      mag:magahi
      mai:maithili
      mak:makassar
      man:mandingo
      mas:maasai
      mde:maba
      mdf:mokša
      mdr:mandar
      men:mende
      mer:meru
      mfe:morisyen
      mg:malagassi
      mga:keski-iiri
      mgh:makua-meetto
      mgo:meta’
      mh:marshall
      mi:maori
      mic:micmac
      min:minangkabau
      mk:makedonia
      ml:malajalam
      mn:mongoli
      mnc:mantšu
      mni:manipuri
      moe:innu-aimun
      moh:mohawk
      mos:mossi
      mr:marathi
      mrj:vuorimari
      ms:malaiji
      mt:malta
      mua:mundang
      mul:useita kieliä
      mus:creek
      mwl:mirandeesi
      mwr:marwari
      mwv:mentawai
      my:burma
      mye:myene
      myv:ersä
      mzn:mazandarani
      na:nauru
      nan:min nan -kiina
      nap:napoli
      naq:nama
      nb:norjan bokmål
      nd:pohjois-ndebele
      nds:alasaksa
      nds-NL:alankomaidenalasaksa
      ne:nepali
      new:newari
      ng:ndonga
      nia:nias
      niu:niue
      njo:ao naga
      nl:hollanti
      nl-BE:flaami
      nmg:kwasio
      nn:norjan nynorsk
      nnh:ngiemboon
      no:norja
      nog:nogai
      non:muinaisnorja
      nov:novial
      nqo:n’ko
      nr:etelä-ndebele
      nso:pohjoissotho
      nus:nuer
      nv:navajo
      nwc:klassinen newari
      ny:njandža
      nym:nyamwezi
      nyn:nyankole
      nyo:nyoro
      nzi:nzima
      oc:oksitaani
      oj:odžibwa
      ojb:luoteis-odžibwa
      ojc:keskiojibwa
      ojs:oji-cree
      ojw:länsi-odžibwa
      oka:okanagan
      om:oromo
      or:orija
      os:osseetti
      osa:osage
      ota:osmani
      pa:pandžabi
      pag:pangasinan
      pal:pahlavi
      pam:pampanga
      pap:papiamentu
      pau:palau
      pcd:picardi
      pcm:nigerianpidgin
      pdc:pennsylvaniansaksa
      pdt:plautdietsch
      peo:muinaispersia
      pfl:pfaltsi
      phn:foinikia
      pi:paali
      pis:pijin
      pl:puola
      pms:piemonte
      pnt:pontoksenkreikka
      pon:pohnpei
      pqm:maliseet-passamaquoddy
      prg:muinaispreussi
      pro:muinaisprovensaali
      ps:paštu
      pt:portugali
      pt-BR:brasilianportugali
      pt-PT:euroopanportugali
      qu:ketšua
      quc:kʼicheʼ
      qug:chimborazonylänköketšua
      raj:radžastani
      rap:rapanui
      rar:rarotonga
      rgn:romagnoli
      rhg:rohinga
      rif:tarifit
      rm:retoromaani
      rn:rundi
      ro:romania
      ro-MD:moldova
      rof:rombo
      rom:romani
      rtm:rotuma
      ru:venäjä
      rue:ruteeni
      rug:roviana
      rup:aromania
      rw:ruanda
      rwk:rwa
      sa:sanskrit
      sad:sandawe
      sah:jakuutti
      sam:samarianaramea
      saq:samburu
      sas:sasak
      sat:santali
      saz:sauraštri
      sba:ngambay
      sbp:sangu
      sc:sardi
      scn:sisilia
      sco:skotti
      sd:sindhi
      sdc:sassarinsardi
      sdh:eteläkurdi
      se:pohjoissaame
      see:seneca
      seh:sena
      sei:seri
      sel:selkuppi
      ses:koyraboro senni
      sg:sango
      sga:muinaisiiri
      sgs:samogiitti
      sh:serbokroaatti
      shi:tašelhit
      shn:shan
      shu:tšadinarabia
      si:sinhala
      sid:sidamo
      sk:slovakki
      skr:saraiki
      sl:sloveeni
      slh:lushootseed (eteläinen)
      sli:sleesiansaksa
      sly:selayar
      sm:samoa
      sma:eteläsaame
      smj:luulajansaame
      smn:inarinsaame
      sms:koltansaame
      sn:šona
      snk:soninke
      so:somali
      sog:sogdi
      sq:albania
      sr:serbia
      srn:sranan
      srr:serer
      ss:swazi
      ssy:saho
      st:eteläsotho
      stq:saterlandinfriisi
      str:straits-salish
      su:sunda
      suk:sukuma
      sus:susu
      sux:sumeri
      sv:ruotsi
      sw:swahili
      sw-CD:kongonswahili
      swb:komori
      syc:muinaissyyria
      syr:syyria
      szl:sleesia
      ta:tamili
      tce:etelätutchone
      tcy:tulu
      te:telugu
      tem:temne
      teo:teso
      ter:tereno
      tet:tetum
      tg:tadžikki
      tgx:tagish
      th:thai
      tht:tahlta
      ti:tigrinja
      tig:tigre
      tiv:tiv
      tk:turkmeeni
      tkl:tokelau
      tkr:tsahuri
      tl:tagalog
      tlh:klingon
      tli:tlingit
      tly:tališi
      tmh:tamašek
      tn:tswana
      to:tonga
      tog:malawintonga
      tok:toki pona
      tpi:tok-pisin
      tr:turkki
      tru:turojo
      trv:taroko
      trw:torwali
      ts:tsonga
      tsd:tsakonia
      tsi:tsimši
      tt:tataari
      ttm:pohjoinen tutchone
      ttt:tati
      tum:tumbuka
      tvl:tuvalu
      tw:twi
      twq:tasawaq
      ty:tahiti
      tyv:tuva
      tzm:keskiatlaksentamazight
      udm:udmurtti
      ug:uiguuri
      uga:ugarit
      uk:ukraina
      umb:mbundu
      und:tuntematon kieli
      ur:urdu
      uz:uzbekki
      ve:venda
      vec:venetsia
      vep:vepsä
      vi:vietnam
      vls:länsiflaami
      vmf:maininfrankki
      vmw:makhuwa
      vo:volapük
      vot:vatja
      vro:võro
      vun:vunjo
      wa:valloni
      wae:walser
      wal:wolaitta
      war:waray
      was:washo
      wbp:warlpiri
      wo:wolof
      wuu:wu-kiina
      xal:kalmukki
      xh:xhosa
      xmf:mingreli
      xnr:kangri
      xog:soga
      yao:jao
      yap:japi
      yav:yangben
      ybb:yemba
      yi:jiddiš
      yo:joruba
      yrl:ñeengatú
      yue:kantoninkiina
      yue-alt-menu:kiina (kantonin)
      za:zhuang
      zap:zapoteekki
      zbl:blisskieli
      zea:seelanti
      zen:zenaga
      zgh:vakioitu tamazight
      zh:kiina
      zh-alt-menu:kiina (mandariini)
      zh-Hans-alt-long:mandariinikiina (yksinkertaistettu)
      zh-Hant-alt-long:mandariinikiina (perinteinen)
      zu:zulu
      zun:zuni
      zxx:ei kielellistä sisältöä
      zza:zaza
      """.trimIndent() }

  val fil: String by lazy { """
      aa:Afar
      ab:Abkhazian
      ace:Achinese
      ach:Acoli
      ada:Adangme
      ady:Adyghe
      af:Afrikaans
      agq:Aghem
      ain:Ainu
      ak:Akan
      ale:Aleut
      alt:Southern Altai
      am:Amharic
      an:Aragonese
      ann:Obolo
      anp:Angika
      ar:Arabic
      ar-001:Modernong Karaniwang Arabic
      arn:Mapuche
      arp:Arapaho
      ars:Najdi Arabic
      as:Assamese
      asa:Asu
      ast:Asturian
      atj:Atikamekw
      av:Avaric
      awa:Awadhi
      ay:Aymara
      az:Azerbaijani
      az-alt-short:Azeri
      ba:Bashkir
      ban:Balinese
      bas:Basaa
      be:Belarusian
      bem:Bemba
      bez:Bena
      bg:Bulgarian
      bgc:Haryanvi
      bgn:Kanlurang Balochi
      bho:Bhojpuri
      bi:Bislama
      bin:Bini
      bla:Siksika
      blo:Anii
      bm:Bambara
      bn:Bangla
      bo:Tibetan
      br:Breton
      brx:Bodo
      bs:Bosnian
      bug:Buginese
      byn:Blin
      ca:Catalan
      cay:Cayuga
      ccp:Chakma
      ce:Chechen
      ceb:Cebuano
      cgg:Chiga
      ch:Chamorro
      chk:Chuukese
      chm:Mari
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      ckb:Central Kurdish
      ckb-alt-menu:Kurdish, Central
      ckb-alt-variant:Kurdish, Sorani
      clc:Chilcotin
      co:Corsican
      crg:Michif
      crj:Southern East Cree
      crk:Plains Cree
      crl:Northern East Cree
      crm:Moose Cree
      crr:Carolina Algonquian
      crs:Seselwa Creole French
      cs:Czech
      csw:Latian na Cree
      cu:Church Slavic
      cv:Chuvash
      cy:Welsh
      da:Danish
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:German
      de-AT:Austrian German
      de-CH:Swiss High German
      dgr:Dogrib
      dje:Zarma
      doi:Dogri
      dsb:Lower Sorbian
      dua:Duala
      dv:Divehi
      dyo:Jola-Fonyi
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      eka:Ekajuk
      el:Greek
      en:Ingles
      en-GB-alt-short:Ingles sa UK
      en-US:Ingles (American)
      en-US-alt-short:Ingles sa US
      eo:Esperanto
      es:Spanish
      es-419:Latin American na Espanyol
      es-ES:European Spanish
      es-MX:Mexican na Espanyol
      et:Estonian
      eu:Basque
      ewo:Ewondo
      fa:Persian
      fa-AF:Dari
      ff:Fulah
      fi:Finnish
      fil:Filipino
      fj:Fijian
      fo:Faroese
      fon:Fon
      fr:French
      fr-CH:Swiss na French
      frc:Cajun French
      frr:Hilagang Frisian
      fur:Friulian
      fy:Western Frisian
      ga:Irish
      gaa:Ga
      gag:Gagauz
      gd:Scottish Gaelic
      gez:Geez
      gil:Gilbertese
      gl:Galician
      gn:Guarani
      gor:Gorontalo
      gsw:Swiss German
      gu:Gujarati
      guz:Gusii
      gv:Manx
      gwi:Gwichʼin
      ha:Hausa
      hai:Haida
      haw:Hawaiian
      hax:Katimugang Haida
      he:Hebrew
      hi:Hindi
      hi-Latn-alt-variant:Hinglish
      hil:Hiligaynon
      hmn:Hmong
      hr:Croatian
      hsb:Upper Sorbian
      ht:Haitian
      hu:Hungarian
      hup:Hupa
      hur:Halkomelem
      hy:Armenian
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Indonesian
      ie:Interlingue
      ig:Igbo
      ii:Sichuan Yi
      ikt:Kanlurang Canadian Inuktitut
      ilo:Iloko
      inh:Ingush
      io:Ido
      is:Icelandic
      it:Italian
      iu:Inuktitut
      ja:Japanese
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jv:Javanese
      ka:Georgian
      kab:Kabyle
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kbd:Kabardian
      kcg:Tyap
      kde:Makonde
      kea:Kabuverdianu
      kfo:Koro
      kg:Kongo
      kgp:Kaingang
      kha:Khasi
      khq:Koyra Chiini
      ki:Kikuyu
      kj:Kuanyama
      kk:Kazakh
      kkj:Kako
      kl:Kalaallisut
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Korean
      koi:Komi-Permyak
      kok:Konkani
      kpe:Kpelle
      kr:Kanuri
      krc:Karachay-Balkar
      krl:Karelian
      kru:Kurukh
      ks:Kashmiri
      ksb:Shambala
      ksf:Bafia
      ksh:Colognian
      ku:Kurdish
      kum:Kumyk
      kv:Komi
      kw:Cornish
      kwk:Kwakʼwala
      kxv:Kuvi
      ky:Kirghiz
      la:Latin
      lad:Ladino
      lag:Langi
      lb:Luxembourgish
      lez:Lezghian
      lg:Ganda
      li:Limburgish
      lij:Ligurian
      lil:Lillooet
      lkt:Lakota
      lmo:Lombard
      ln:Lingala
      lo:Lao
      lou:Louisiana Creole
      loz:Lozi
      lrc:Hilagang Luri
      lsm:Saamia
      lt:Lithuanian
      lu:Luba-Katanga
      lua:Luba-Lulua
      lun:Lunda
      luo:Luo
      lus:Mizo
      luy:Luyia
      lv:Latvian
      mad:Madurese
      mag:Magahi
      mai:Maithili
      mak:Makasar
      mas:Masai
      mdf:Moksha
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagasy
      mgh:Makhuwa-Meetto
      mgo:Meta’
      mh:Marshallese
      mi:Māori
      mic:Micmac
      min:Minangkabau
      mk:Macedonian
      ml:Malayalam
      mn:Mongolian
      mni:Manipuri
      moe:Innu-aimun
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      ms:Malay
      mt:Maltese
      mua:Mundang
      mul:Maramihang Wika
      mus:Creek
      mwl:Mirandese
      my:Burmese
      myv:Erzya
      mzn:Mazanderani
      na:Nauru
      nap:Neapolitan
      naq:Nama
      nb:Norwegian Bokmål
      nd:Hilagang Ndebele
      nds:Low German
      nds-NL:Low Saxon
      ne:Nepali
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niuean
      nl:Dutch
      nl-BE:Flemish
      nmg:Kwasio
      nn:Norwegian Nynorsk
      nnh:Ngiemboon
      no:Norwegian
      nog:Nogai
      nqo:N’Ko
      nr:South Ndebele
      nso:Hilagang Sotho
      nus:Nuer
      nv:Navajo
      ny:Nyanja
      nyn:Nyankole
      oc:Occitan
      ojb:Hilagang-Kanluran ng Ojibwa
      ojc:Central Ojibwa
      ojs:Oji-Cree
      ojw:Kanlurang Ojibwa
      oka:Okanagan
      om:Oromo
      or:Odia
      os:Ossetic
      pa:Punjabi
      pag:Pangasinan
      pam:Pampanga
      pap:Papiamento
      pau:Palauan
      pcm:Nigerian Pidgin
      pis:Pijin
      pl:Polish
      pqm:Maliseet-Passamaquoddy
      prg:Prussian
      ps:Pashto
      ps-alt-variant:Pushto
      pt:Portuguese
      pt-BR:Portuges ng Brasil
      pt-PT:European Portuguese
      qu:Quechua
      quc:Kʼicheʼ
      raj:Rajasthani
      rap:Rapanui
      rar:Rarotongan
      rhg:Rohingya
      rm:Romansh
      rn:Rundi
      ro:Romanian
      ro-MD:Moldavian
      rof:Rombo
      ru:Russian
      rup:Aromanian
      rw:Kinyarwanda
      rwk:Rwa
      sa:Sanskrit
      sad:Sandawe
      sah:Yakut
      saq:Samburu
      sat:Santali
      sba:Ngambay
      sbp:Sangu
      sc:Sardinian
      scn:Sicilian
      sco:Scots
      sd:Sindhi
      sdh:Katimugang Kurdish
      se:Hilagang Sami
      seh:Sena
      ses:Koyraboro Senni
      sg:Sango
      sh:Serbo-Croatian
      shi:Tachelhit
      shn:Shan
      si:Sinhala
      sk:Slovak
      sl:Slovenian
      slh:Katimugang Lushootseed
      sm:Samoan
      sma:Katimugang Sami
      smj:Lule Sami
      smn:Inari Sami
      sms:Skolt Sami
      sn:Shona
      snk:Soninke
      so:Somali
      sq:Albanian
      sr:Serbian
      srn:Sranan Tongo
      ss:Swati
      ssy:Saho
      st:Katimugang Sotho
      str:Straits Salish
      su:Sundanese
      suk:Sukuma
      sv:Swedish
      sw:Swahili
      sw-CD:Congo Swahili
      swb:Comorian
      syr:Syriac
      szl:Silesian
      ta:Tamil
      tce:Katimugang Tutchone
      te:Telugu
      tem:Timne
      teo:Teso
      tet:Tetum
      tg:Tajik
      tgx:Tagish
      th:Thai
      tht:Tahltan
      ti:Tigrinya
      tig:Tigre
      tk:Turkmen
      tl:Tagalog
      tlh:Klingon
      tli:Tlingit
      tn:Tswana
      to:Tongan
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Turkish
      trv:Taroko
      ts:Tsonga
      tt:Tatar
      ttm:Northern Tutchone
      tum:Tumbuka
      tvl:Tuvalu
      tw:Twi
      twq:Tasawaq
      ty:Tahitian
      tyv:Tuvinian
      tzm:Central Atlas Tamazight
      udm:Udmurt
      ug:Uyghur
      ug-alt-variant:Uighur
      uk:Ukranian
      umb:Umbundu
      und:Hindi Kilalang Wika
      ur:Urdu
      uz:Uzbek
      vai:Vai
      ve:Venda
      vec:Venetian
      vi:Vietnamese
      vmw:Makhuwa
      vo:Volapük
      vun:Vunjo
      wa:Walloon
      wae:Walser
      wal:Wolaytta
      war:Waray
      wbp:Warlpiri
      wo:Wolof
      wuu:Wu Chinese
      xal:Kalmyk
      xh:Xhosa
      xnr:Kangri
      xog:Soga
      yav:Yangben
      ybb:Yemba
      yi:Yiddish
      yo:Yoruba
      yrl:Nheengatu
      yue:Cantonese
      yue-alt-menu:Chinese, Cantonese
      za:Zhuang
      zgh:Standard Moroccan Tamazight
      zh:Chinese
      zh-alt-menu:Chinese, Mandarin
      zh-Hans:Pinasimpleng Chinese
      zh-Hans-alt-long:Pinasimpleng Mandarin Chinese
      zh-Hant:Tradisyonal na Chinese
      zh-Hant-alt-long:Tradisyonal na Mandarin Chinese
      zu:Zulu
      zun:Zuni
      zxx:Walang nilalaman na ukol sa wika
      zza:Zaza
      """.trimIndent() }

  val fo: String by lazy { """
      aa:afar
      ab:abkhasiskt
      ace:achinese
      ada:adangme
      ady:adyghe
      af:afrikaans
      agq:aghem
      ain:ainu
      ak:akan
      ale:aleut
      alt:suður altai
      am:amhariskt
      an:aragoniskt
      anp:angika
      ar:arabiskt
      ar-001:nútíðar vanligt arabiskt
      arn:mapuche
      arp:arapaho
      as:assamesiskt
      asa:asu
      ast:asturianskt
      av:avariskt
      awa:awadhi
      ay:aymara
      az:aserbajdsjanskt
      az-alt-short:azeri
      ba:bashkir
      ban:balinesiskt
      bas:basaa
      be:hvitarussiskt
      bem:bemba
      bez:bena
      bg:bulgarskt
      bgc:haryanvi
      bgn:vestur balochi
      bho:bhojpuri
      bi:bislama
      bin:bini
      bla:siksika
      blo:anii
      bm:bambara
      bn:bangla
      bo:tibetskt
      br:bretonskt
      brx:bodo
      bs:bosniskt
      bss:bakossi
      bug:buginesiskt
      byn:blin
      ca:katalani
      ccp:khakma
      ce:tjetjenskt
      ceb:cebuano
      cgg:chiga
      ch:chamorro
      chk:chuukese
      chm:mari
      cho:choctaw
      chr:cherokee
      chy:cheyenne
      ckb:miðkurdiskt
      ckb-alt-menu:kurdiskt, mið
      ckb-alt-variant:kurdiskt, sorani
      co:korsikanskt
      crs:seselwa creole franskt
      cs:kekkiskt
      csw:swampy cree
      cu:kirkju sláviskt
      cv:chuvash
      cy:walisiskt
      da:danskt
      dak:dakota
      dar:dargwa
      dav:taita
      de:týskt
      de-CH:høgt týskt (Sveis)
      dgr:dogrib
      dje:sarma
      doi:dogri
      dsb:lágt sorbian
      dua:duala
      dv:divehi
      dyo:jola-fonyi
      dz:dzongkha
      dzg:dazaga
      ebu:embu
      ee:ewe
      efi:efik
      eka:ekajuk
      el:grikskt
      en:enskt
      eo:esperanto
      es:spanskt
      et:estiskt
      eu:baskiskt
      ewo:ewondo
      fa:persiskt
      fa-AF:dari
      ff:fulah
      fi:finskt
      fil:filipiniskt
      fj:fijimál
      fo:føroyskt
      fon:fon
      fr:franskt
      fur:friuliskt
      fy:vestur frísiskt
      ga:írskt
      gaa:ga
      gag:gagauz
      gan:gan kinesiskt
      gd:skotskt gæliskt
      gez:geez
      gil:kiribatiskt
      gl:galisiskt
      gn:guarani
      gor:gorontalo
      gsw:týskt (Sveis)
      gu:gujarati
      guz:gusii
      gv:manx
      gwi:gwich’in
      ha:hausa
      hak:hakka kinesiskt
      haw:hawaiianskt
      he:hebraiskt
      hi:hindi
      hi-Latn-alt-variant:hinglish
      hil:hiligaynon
      hmn:hmong
      hr:kroatiskt
      hsb:ovara sorbian
      hsn:xiang kinesiskt
      ht:haitiskt creole
      hu:ungarskt
      hup:hupa
      hy:armenskt
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonesiskt
      ie:interlingue
      ig:igbo
      ii:sichuan yi
      ilo:iloko
      inh:inguish
      io:ido
      is:íslendskt
      it:italskt
      iu:inuktitut
      ja:japanskt
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jv:javanskt
      ka:georgiskt
      kab:kabyle
      kac:kachin
      kaj:jju
      kam:kamba
      kbd:kabardinskt
      kcg:tyap
      kde:makonde
      kea:grønhøvdaoyggjarskt
      kfo:koro
      kgp:kaingang
      kha:khasi
      khq:koyra chiini
      ki:kikuyu
      kj:kuanyama
      kk:kazakh
      kkj:kako
      kl:kalaallisut
      kln:kalenjin
      km:khmer
      kmb:kimbundu
      kn:kannada
      ko:koreanskt
      koi:komi-permyak
      kok:konkani
      kpe:kpelle
      kr:kanuri
      krc:karachay-balkar
      krl:karelskt
      kru:kurukh
      ks:kashmiri
      ksb:shambala
      ksf:bafia
      ksh:kølnskt
      ku:kurdiskt
      kum:kumyk
      kv:komi
      kw:corniskt
      kxv:kuvi
      ky:kyrgyz
      la:latín
      lad:ladino
      lag:langi
      lah:lahnda
      lb:luksemborgskt
      lez:lezghian
      lg:ganda
      li:limburgiskt
      lij:liguriskt
      lkt:lakota
      lmo:lombard
      ln:lingala
      lo:laoskt
      loz:lozi
      lrc:norður luri
      lt:litaviskt
      lu:luba-katanga
      lua:luba-lulua
      lun:lunda
      lus:mizo
      luy:luyia
      lv:lettiskt
      mad:maduresiskt
      mag:magahi
      mai:maithili
      mak:makasar
      mas:masai
      mdf:moksha
      men:mende
      mer:meru
      mfe:morisyen
      mg:malagassiskt
      mgh:makhuwa-meetto
      mgo:metaʼ
      mh:marshallesiskt
      mi:maori
      mic:micmac
      min:minangkabau
      mk:makedónskt
      ml:malayalam
      mn:mongolskt
      mni:manupuri
      moh:mohawk
      mos:mossi
      mr:marathi
      ms:malaiiskt
      mt:maltiskt
      mua:mundang
      mul:ymisk mál
      mus:creek
      mwl:mirandesiskt
      my:burmesiskt
      myv:erzya
      mzn:mazanderani
      na:nauru
      nan:min nan kinesiskt
      nap:napolitanskt
      naq:nama
      nb:norskt bókmál
      nd:norður ndebele
      nds:lágt týskt
      nds-NL:lágt saksiskt
      ne:nepalskt
      new:newari
      ng:ndonga
      nia:nias
      niu:niuean
      nl:hálendskt
      nl-BE:flamskt
      nmg:kwasio
      nn:nýnorskt
      nnh:ngiemboon
      no:norskt
      nog:nogai
      nqo:nʼko
      nr:suður ndebele
      nso:norður sotho
      nus:nuer
      nv:navajo
      ny:nyanja
      nyn:nyankole
      oc:occitanskt
      om:oromo
      or:odia
      os:ossetiskt
      pa:punjabi
      pag:pangasinan
      pam:pampanga
      pap:papiamento
      pau:palauan
      pcm:nigeriskt pidgin
      pl:pólskt
      prg:prusslanskt
      ps:pashto
      pt:portugiskiskt
      pt-BR:portugiskiskt (Brasilia)
      pt-PT:portugiskiskt (Evropa)
      qu:quechua
      quc:kʼicheʼ
      raj:rajasthani
      rap:rapanui
      rar:rarotongiskt
      rm:retoromanskt
      rn:rundi
      ro:rumenskt
      ro-MD:moldaviskt
      rof:rombo
      ru:russiskt
      rup:aromenskt
      rw:kinyarwanda
      rwk:rwa
      sa:sanskrit
      sad:sandawe
      sah:sakha
      saq:samburu
      sat:santali
      sba:ngambay
      sbp:sangu
      sc:sardiskt
      scn:sisilanskt
      sco:skotskt
      sd:sindhi
      sdh:suður kurdiskt
      se:norður sámiskt
      seh:sena
      ses:koyraboro senni
      sg:sango
      sh:serbokroatiskt
      shi:tachelhit
      shn:shan
      si:singalesiskt
      sk:slovakiskt
      sl:slovenskt
      sm:sámoiskt
      sma:suður sámiskt
      smj:lule sámiskt
      smn:inari sami
      sms:skolt sámiskt
      sn:shona
      snk:soninke
      so:somaliskt
      sq:albanskt
      sr:serbiskt
      srn:sranan tongo
      ss:swatiskt
      ssy:saho
      st:sesotho
      su:sundanesiskt
      suk:sukuma
      sv:svenskt
      sw:swahili
      sw-CD:kongo svahili
      swb:komoriskt
      syr:syriac
      szl:silesiskt
      ta:tamilskt
      te:telugu
      tem:timne
      teo:teso
      tet:tetum
      tg:tajik
      th:tailendskt
      ti:tigrinya
      tig:tigre
      tk:turkmenskt
      tl:tagalog
      tlh:klingonskt
      tn:tswana
      to:tonganskt
      tpi:tok pisin
      tr:turkiskt
      trv:taroko
      ts:tsonga
      tt:tatar
      tum:tumbuka
      tvl:tuvalu
      tw:twi
      twq:tasawaq
      ty:tahitiskt
      tyv:tuvinian
      tzm:miðatlasfjøll tamazight
      udm:udmurt
      ug:uyghur
      uk:ukrainskt
      umb:umbundu
      und:ókent mál
      ur:urdu
      uz:usbekiskt
      ve:venda
      vec:venetiskt
      vi:vjetnamesiskt
      vmw:makhuwa
      vo:volapykk
      vun:vunjo
      wa:walloon
      wae:walser
      wal:wolaytta
      war:waray
      wbp:warlpiri
      wo:wolof
      wuu:wu kinesiskt
      xal:kalmyk
      xh:xhosa
      xnr:kangri
      xog:soga
      yav:yangben
      ybb:yemba
      yi:jiddiskt
      yo:yoruba
      yrl:nheengatu
      yue:kantonesiskt
      yue-alt-menu:kinesiskt, kantonesiskt
      za:zhuang
      zgh:vanligt marokanskt tamazight
      zh:kinesiskt
      zh-alt-menu:kinesiskt, mandarin
      zh-Hans:einkult kinesiskt
      zh-Hans-alt-long:mandarin kinesiskt (einkult)
      zh-Hant:vanligt kinesiskt
      zh-Hant-alt-long:mandarin kinesiskt (vanligt)
      zu:sulu
      zun:zuni
      zxx:einki málsligt innihald
      zza:zaza
      """.trimIndent() }

  val fo_DK: String? = null

  val fr: String by lazy { """
      aa:afar
      ab:abkhaze
      ace:aceh
      ach:acoli
      ada:adangme
      ady:adyguéen
      ae:avestique
      aeb:arabe tunisien
      af:afrikaans
      afh:afrihili
      agq:aghem
      ain:aïnou
      ak:akan
      akk:akkadien
      akz:alabama
      ale:aléoute
      aln:guègue
      alt:altaï du Sud
      am:amharique
      an:aragonais
      ang:ancien anglais
      ann:obolo
      anp:angika
      ar:arabe
      ar-001:arabe standard moderne
      arc:araméen
      arn:mapuche
      aro:araona
      arp:arapaho
      arq:arabe algérien
      ars:arabe najdi
      arw:arawak
      ary:arabe marocain
      arz:arabe égyptien
      as:assamais
      asa:asu
      ase:langue des signes américaine
      ast:asturien
      atj:atikamekw
      av:avar
      avk:kotava
      awa:awadhi
      ay:aymara
      az:azerbaïdjanais
      az-alt-short:azéri
      ba:bachkir
      bal:baloutchi
      ban:balinais
      bar:bavarois
      bas:bassa
      bax:bamoun
      bbc:batak toba
      bbj:ghomalaʼ
      be:biélorusse
      bej:bedja
      bem:bemba
      bew:betawi
      bez:bena
      bfd:bafut
      bfq:badaga
      bg:bulgare
      bgc:haryanvi
      bgn:baloutchi occidental
      bho:bhodjpouri
      bi:bichelamar
      bik:bikol
      bin:bini
      bjn:banjar
      bkm:kom
      bla:siksika
      blo:anii
      bm:bambara
      bn:bengali
      bo:tibétain
      bpy:bishnupriya
      bqi:bakhtiari
      br:breton
      bra:braj
      brh:brahoui
      brx:bodo
      bs:bosniaque
      bss:akoose
      bua:bouriate
      bug:bugi
      bum:boulou
      byn:blin
      byv:médumba
      ca:catalan
      cad:caddo
      car:caribe
      cay:cayuga
      cch:atsam
      ccp:changma kodha
      ce:tchétchène
      ceb:cebuano
      cgg:kiga
      ch:chamorro
      chb:chibcha
      chg:tchaghataï
      chk:chuuk
      chm:mari
      chn:jargon chinook
      cho:choctaw
      chp:chipewyan
      chr:cherokee
      chy:cheyenne
      ckb:sorani
      ckb-alt-menu:kurde sorani
      ckb-alt-variant:sorani
      clc:chilcotin
      co:corse
      cop:copte
      cps:capiznon
      cr:cree
      crg:mitchif
      crh:tatar de Crimée
      crj:cri de l’Est (dialecte du Sud)
      crk:cri des plaines
      crl:cri de l’Est (dialecte du Nord)
      crm:cri de Moose
      crr:algonquin de Caroline
      crs:créole seychellois
      cs:tchèque
      csb:kachoube
      csw:cri des marais
      cu:slavon d’église
      cv:tchouvache
      cy:gallois
      da:danois
      dak:dakota
      dar:dargwa
      dav:taita
      de:allemand
      de-AT:allemand autrichien
      de-CH:allemand suisse
      del:delaware
      den:esclave
      dgr:dogrib
      din:dinka
      dje:zarma
      doi:dogri
      dsb:bas-sorabe
      dtp:dusun central
      dua:douala
      dum:moyen néerlandais
      dv:maldivien
      dyo:diola-fogny
      dyu:dioula
      dz:dzongkha
      dzg:dazaga
      ebu:embu
      ee:éwé
      efi:éfik
      egl:émilien
      egy:égyptien ancien
      eka:ékadjouk
      el:grec
      elx:élamite
      en:anglais
      en-AU:anglais australien
      en-CA:anglais canadien
      en-GB:anglais britannique
      en-GB-alt-short:anglais britannique
      en-US:anglais américain
      en-US-alt-short:anglais américain
      enm:moyen anglais
      eo:espéranto
      es:espagnol
      es-419:espagnol d’Amérique latine
      es-ES:espagnol d’Espagne
      es-MX:espagnol du Mexique
      esu:youpik central
      et:estonien
      eu:basque
      ewo:éwondo
      ext:estrémègne
      fa:persan
      fa-AF:dari
      fan:fang
      fat:fanti
      ff:peul
      fi:finnois
      fil:filipino
      fit:finnois tornédalien
      fj:fidjien
      fo:féroïen
      fon:fon
      fr:français
      fr-CA:français canadien
      fr-CH:français suisse
      frc:français cadien
      frm:moyen français
      fro:ancien français
      frp:francoprovençal
      frr:frison septentrional
      frs:frison oriental
      fur:frioulan
      fy:frison occidental
      ga:irlandais
      gaa:ga
      gag:gagaouze
      gan:gan
      gay:gayo
      gba:gbaya
      gbz:dari zoroastrien
      gd:gaélique écossais
      gez:guèze
      gil:gilbertin
      gl:galicien
      glk:gilaki
      gmh:moyen haut-allemand
      gn:guarani
      goh:ancien haut allemand
      gon:gondi
      gor:gorontalo
      got:gotique
      grb:grebo
      grc:grec ancien
      gsw:suisse allemand
      gu:goudjarati
      guc:wayuu
      gur:gurenne
      guz:gusii
      gv:mannois
      gwi:gwichʼin
      ha:haoussa
      hai:haïda
      hak:hakka
      haw:hawaïen
      hax:haïda du Sud
      he:hébreu
      hi:hindi
      hi-Latn-alt-variant:hinglish
      hif:hindi fidjien
      hil:hiligaynon
      hit:hittite
      hmn:hmong
      ho:hiri motu
      hr:croate
      hsb:haut-sorabe
      hsn:xiang
      ht:créole haïtien
      hu:hongrois
      hup:hupa
      hur:halkomelem
      hy:arménien
      hz:héréro
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonésien
      ie:interlingue
      ig:igbo
      ii:yi du Sichuan
      ik:inupiaq
      ikt:inuktitut de l’Ouest canadien
      ilo:ilocano
      inh:ingouche
      io:ido
      is:islandais
      it:italien
      iu:inuktitut
      izh:ingrien
      ja:japonais
      jam:créole jamaïcain
      jbo:lojban
      jgo:ngomba
      jmc:matchamé
      jpr:judéo-persan
      jrb:judéo-arabe
      jut:jute
      jv:javanais
      ka:géorgien
      kaa:karakalpak
      kab:kabyle
      kac:kachin
      kaj:jju
      kam:kamba
      kaw:kawi
      kbd:kabarde
      kbl:kanembou
      kcg:tyap
      kde:makondé
      kea:capverdien
      ken:kényang
      kfo:koro
      kg:kikongo
      kgp:caingangue
      kha:khasi
      kho:khotanais
      khq:koyra chiini
      khw:khowar
      ki:kikuyu
      kiu:kirmanjki
      kj:kuanyama
      kk:kazakh
      kkj:kako
      kl:groenlandais
      kln:kalendjin
      km:khmer
      kmb:kimboundou
      kn:kannada
      ko:coréen
      koi:komi-permiak
      kok:konkani
      kos:kosraéen
      kpe:kpellé
      kr:kanouri
      krc:karatchaï balkar
      kri:krio
      krj:kinaray-a
      krl:carélien
      kru:kouroukh
      ks:cachemiri
      ksb:shambala
      ksf:bafia
      ksh:kölsch
      ku:kurde
      kum:koumyk
      kut:kutenai
      kv:komi
      kw:cornique
      kwk:kwak’wala
      kxv:kuvi
      ky:kirghize
      la:latin
      lad:ladino
      lag:langi
      lah:lahnda
      lam:lamba
      lb:luxembourgeois
      lez:lezghien
      lfn:lingua franca nova
      lg:ganda
      li:limbourgeois
      lij:ligure
      lil:lillooet
      liv:livonien
      lkt:lakota
      lmo:lombard
      ln:lingala
      lo:lao
      lol:mongo
      lou:créole louisianais
      loz:lozi
      lrc:lori du Nord
      lsm:samia
      lt:lituanien
      ltg:latgalien
      lu:luba-katanga (kiluba)
      lua:luba-kasaï (ciluba)
      lui:luiseño
      lun:lunda
      lus:lushaï
      luy:luyia
      lv:letton
      lzh:chinois littéraire
      lzz:laze
      mad:madurais
      maf:mafa
      mag:magahi
      mai:maïthili
      mak:makassar
      man:mandingue
      mas:maasaï
      mde:maba
      mdf:mokcha
      mdr:mandar
      men:mendé
      mer:meru
      mfe:créole mauricien
      mg:malgache
      mga:moyen irlandais
      mgh:makua
      mgo:metaʼ
      mh:marshallais
      mi:maori
      mic:micmac
      min:minangkabau
      mk:macédonien
      ml:malayalam
      mn:mongol
      mnc:mandchou
      mni:manipuri
      moe:innu-aimun
      moh:mohawk
      mos:moré
      mr:marathi
      mrj:mari occidental
      ms:malais
      mt:maltais
      mua:moundang
      mul:multilingue
      mus:creek
      mwl:mirandais
      mwr:marwarî
      mwv:mentawaï
      my:birman
      mye:myènè
      myv:erzya
      mzn:mazandérani
      na:nauruan
      nan:minnan
      nap:napolitain
      naq:nama
      nb:norvégien bokmål
      nd:ndébélé du Nord
      nds:bas-allemand
      nds-NL:bas-saxon néerlandais
      ne:népalais
      new:newari
      ng:ndonga
      nia:niha
      niu:niuéen
      njo:ao
      nl:néerlandais
      nl-BE:flamand
      nmg:ngoumba
      nn:norvégien nynorsk
      nnh:ngiemboon
      no:norvégien
      nog:nogaï
      non:vieux norrois
      nov:novial
      nqo:n’ko
      nr:ndébélé du Sud
      nso:sotho du Nord
      nus:nuer
      nv:navajo
      nwc:newarî classique
      ny:chewa
      nym:nyamwezi
      nyn:nyankolé
      nyo:nyoro
      nzi:nzema
      oc:occitan
      oj:ojibwa
      ojb:ojibwé du Nord-Ouest
      ojc:ojibwé central
      ojs:oji-cri
      ojw:ojibwé occidental
      oka:colville-okanagan
      om:oromo
      or:odia
      os:ossète
      osa:osage
      ota:turc ottoman
      pa:pendjabi
      pag:pangasinan
      pal:pahlavi
      pam:pampangan
      pap:papiamento
      pau:palau
      pcd:picard
      pcm:pidgin nigérian
      pdc:pennsilfaanisch
      pdt:bas-prussien
      peo:persan ancien
      pfl:allemand palatin
      phn:phénicien
      pi:pali
      pis:pijin
      pl:polonais
      pms:piémontais
      pnt:pontique
      pon:pohnpei
      pqm:malécite-passamaquoddy
      prg:prussien
      pro:provençal ancien
      ps:pachto
      ps-alt-variant:pashto
      pt:portugais
      pt-BR:portugais brésilien
      pt-PT:portugais européen
      qu:quechua
      quc:quiché
      qug:quichua du Haut-Chimborazo
      raj:rajasthani
      rap:rapanui
      rar:rarotongien
      rgn:romagnol
      rhg:rohingya
      rif:rifain
      rm:romanche
      rn:roundi
      ro:roumain
      ro-MD:moldave
      rof:rombo
      rom:romani
      rtm:rotuman
      ru:russe
      rue:ruthène
      rug:roviana
      rup:aroumain
      rw:kinyarwanda
      rwk:rwa
      sa:sanskrit
      sad:sandawe
      sah:iakoute
      sam:araméen samaritain
      saq:samburu
      sas:sasak
      sat:santali
      saz:saurashtra
      sba:ngambay
      sbp:isangu
      sc:sarde
      scn:sicilien
      sco:écossais
      sd:sindhi
      sdc:sarde sassarais
      sdh:kurde du Sud
      se:same du Nord
      see:seneca
      seh:cisena
      sei:séri
      sel:selkoupe
      ses:koyraboro senni
      sg:sango
      sga:ancien irlandais
      sgs:samogitien
      sh:serbo-croate
      shi:chleuh
      shn:shan
      shu:arabe tchadien
      si:cingalais
      sid:sidamo
      sk:slovaque
      sl:slovène
      slh:lushootseed du Sud
      sli:bas-silésien
      sly:sélayar
      sm:samoan
      sma:same du Sud
      smj:same de Lule
      smn:same d’Inari
      sms:same skolt
      sn:shona
      snk:soninké
      so:somali
      sog:sogdien
      sq:albanais
      sr:serbe
      srn:sranan tongo
      srr:sérère
      ss:swati
      ssy:saho
      st:sotho du Sud
      stq:saterlandais
      str:salish des détroits
      su:soundanais
      suk:soukouma
      sus:soussou
      sux:sumérien
      sv:suédois
      sw:swahili
      sw-CD:swahili du Congo
      swb:comorien
      syc:syriaque classique
      syr:syriaque
      szl:silésien
      ta:tamoul
      tce:tutchone du Sud
      tcy:toulou
      te:télougou
      tem:timné
      teo:teso
      ter:tereno
      tet:tétoum
      tg:tadjik
      tgx:tagish
      th:thaï
      tht:tahltan
      ti:tigrigna
      tig:tigré
      tiv:tiv
      tk:turkmène
      tkl:tokelau
      tkr:tsakhour
      tl:tagalog
      tlh:klingon
      tli:tlingit
      tly:talysh
      tmh:tamacheq
      tn:tswana
      to:tongien
      tog:tonga nyasa
      tok:toki pona
      tpi:tok pisin
      tr:turc
      tru:touroyo
      trv:taroko
      ts:tsonga
      tsd:tsakonien
      tsi:tsimshian
      tt:tatar
      ttm:tutchone du Nord
      ttt:tati caucasien
      tum:tumbuka
      tvl:tuvalu
      tw:twi
      twq:tasawaq
      ty:tahitien
      tyv:touvain
      tzm:amazighe de l’Atlas central
      udm:oudmourte
      ug:ouïghour
      ug-alt-variant:ouïgour
      uga:ougaritique
      uk:ukrainien
      umb:umbundu
      und:langue indéterminée
      ur:ourdou
      uz:ouzbek
      vai:vaï
      ve:venda
      vec:vénitien
      vep:vepse
      vi:vietnamien
      vls:flamand occidental
      vmf:franconien du Main
      vmw:macua
      vo:volapük
      vot:vote
      vro:võro
      vun:vunjo
      wa:wallon
      wae:walser
      wal:walamo
      war:waray
      was:washo
      wbp:warlpiri
      wo:wolof
      wuu:wu
      xal:kalmouk
      xh:xhosa
      xmf:mingrélien
      xnr:kangri
      xog:soga
      yao:yao
      yap:yapois
      yav:yangben
      ybb:yemba
      yi:yiddish
      yo:yoruba
      yrl:nheengatou
      yue:cantonais
      yue-alt-menu:chinois cantonais
      za:zhuang
      zap:zapotèque
      zbl:symboles Bliss
      zea:zélandais
      zen:zenaga
      zgh:amazighe standard marocain
      zh:chinois
      zh-alt-menu:chinois mandarin
      zh-Hans:chinois simplifié
      zh-Hans-alt-long:mandarin simplifié
      zh-Hant:chinois traditionnel
      zh-Hant-alt-long:mandarin traditionnel
      zu:zoulou
      zun:zuñi
      zxx:sans contenu linguistique
      zza:zazaki
      """.trimIndent() }

  val fr_BE: String by lazy { """
      frp:franco-provençal
      goh:ancien haut-allemand
      gu:gujarati
      """.trimIndent() }

  val fr_BF: String? = null

  val fr_BI: String? = null

  val fr_BJ: String? = null

  val fr_BL: String? = null

  val fr_CA: String by lazy { """
      ady:adygué
      ang:vieil anglais
      asa:asou
      bbj:ghomala
      bik:bicol
      byn:bilen
      byv:medumba
      chg:tchagatay
      chn:chinook
      ckb:kurde central
      ckb-alt-menu:kurde central
      cr:cri
      crg:michif
      crl:cri du Nord-Est
      crr:algonquin de la Caroline
      den:slave
      dgr:tlicho
      ebu:embou
      en-GB-alt-short:anglais (R.-U.)
      en-US-alt-short:anglais (É.-U.)
      esu:yupik central
      ewo:ewondo
      frc:cajun
      frp:franco-provençal
      goh:vieux haut-allemand
      gu:gujarati
      ii:yi de Sichuan
      ken:kenyang
      kl:kalaallisut
      ks:kashmiri
      ksb:chambala
      liv:live
      lu:luba-katanga
      lzh:chinois classique
      mgh:makhuwa-meetto
      mgo:meta’
      mwr:marwari
      mwv:mentawai
      nds-NL:bas saxon
      njo:ao naga
      nmg:kwasio
      nwc:newari classique
      nyn:nkole
      oka:okanagan
      pau:palauan
      pdc:allemand de Pennsylvanie
      pdt:bas allemand mennonite
      peo:vieux perse
      pfl:palatin
      pis:pidgin
      pro:ancien occitan
      quc:k’iche’
      rar:rarotonga
      sbp:sangu
      sdh:kurde méridional
      sei:seri
      sga:vieil irlandais
      sly:selayar
      smn:sami d’Inari
      stq:frison de Saterland
      sus:sosso
      sw-CD:swahili congolais
      tru:turoyo
      tzm:tamazight
      ug-alt-variant:ouïghour
      yue-alt-menu:chinois, cantonais
      zh-alt-menu:chinois, mandarin
      zh-Hans-alt-long:chinois, mandarin simplifié
      zh-Hant-alt-long:chinois, mandarin traditionnel
      """.trimIndent() }

  val fr_CD: String? = null

  val fr_CF: String? = null

  val fr_CG: String? = null

  val fr_CH: String by lazy { """
      gu:goudjrati
      pdc:allemand de Pennsylvanie
      sdh:kurde méridional
      """.trimIndent() }

  val fr_CI: String? = null

  val fr_CM: String? = null

  val fr_DJ: String? = null

  val fr_DZ: String? = null

  val fr_GA: String? = null

  val fr_GF: String? = null

  val fr_GN: String? = null

  val fr_GP: String? = null

  val fr_GQ: String? = null

  val fr_HT: String? = null

  val fr_KM: String? = null

  val fr_LU: String? = null

  val fr_MA: String? = null

  val fr_MC: String? = null

  val fr_MF: String? = null

  val fr_MG: String? = null

  val fr_ML: String? = null

  val fr_MQ: String? = null

  val fr_MR: String? = null

  val fr_MU: String? = null

  val fr_NC: String? = null

  val fr_NE: String? = null

  val fr_PF: String? = null

  val fr_PM: String? = null

  val fr_RE: String? = null

  val fr_RW: String? = null

  val fr_SC: String? = null

  val fr_SN: String? = null

  val fr_SY: String? = null

  val fr_TD: String? = null

  val fr_TG: String? = null

  val fr_TN: String? = null

  val fr_VU: String? = null

  val fr_WF: String? = null

  val fr_YT: String? = null

  val frr: String by lazy { """
      frr:Nordfriisk
      """.trimIndent() }

  val fur: String by lazy { """
      aa:afar
      ab:abcazian
      ae:avestan
      af:afrikaans
      am:amaric
      an:aragonês
      ang:vieri inglês
      ar:arap
      arc:aramaic
      as:assamês
      ast:asturian
      av:avar
      ay:aymarà
      az:azerbaijani
      az-alt-short:azerbaijani
      be:bielorùs
      bg:bulgar
      bn:bengalês
      bo:tibetan
      br:breton
      bs:bosniac
      ca:catalan
      ce:cecen
      ch:chamorro
      co:cors
      cop:coptic
      cr:cree
      cs:cec
      cu:sclâf de glesie
      cy:galês
      da:danês
      de:todesc
      de-AT:todesc de Austrie
      de-CH:alt todesc de Svuizare
      den:sclâf
      egy:vieri egjizian
      el:grêc
      en:inglês
      en-AU:inglês australian
      en-CA:inglês canadês
      en-GB:inglês britanic
      en-GB-alt-short:inglês britanic
      en-US:ingles merecan
      en-US-alt-short:ingles merecan
      eo:esperanto
      es:spagnûl
      es-419:spagnûl de Americhe Latine
      es-ES:spagnûl iberic
      et:eston
      eu:basc
      fa:persian
      ff:fulah
      fi:finlandês
      fil:filipin
      fj:fizian
      fo:faroês
      fr:francês
      fr-CA:francês dal Canade
      fr-CH:francês de Svuizare
      fro:vieri francês
      fur:furlan
      fy:frisian
      ga:gaelic irlandês
      gd:gaelic scozês
      gl:galizian
      gn:guaranì
      got:gotic
      grc:vieri grêc
      gu:gujarati
      gv:manx
      he:ebraic
      hi:hindi
      hr:cravuat
      ht:haitian
      hu:ongjarês
      hy:armen
      id:indonesian
      ig:igbo
      ik:inupiaq
      io:ido
      is:islandês
      it:talian
      iu:inuktitut
      ja:gjaponês
      ka:gjeorgjian
      kk:kazac
      kl:kalaallisut
      km:khmer
      kn:kannada
      ko:corean
      ku:curd
      kw:cornualiês
      la:latin
      lad:ladin
      lb:lussemburghês
      li:limburghês
      ln:lingala
      lo:lao
      lt:lituan
      lv:leton
      mg:malagasy
      mi:maori
      mk:macedon
      ml:malayalam
      mn:mongul
      mr:marathi
      ms:malês
      mt:maltês
      mul:lenghis multiplis
      mwl:mirandês
      nap:napoletan
      nb:norvegjês bokmål
      nd:ndebele setentrionâl
      nds:bas todesc
      ne:nepalês
      nl:olandês
      nl-BE:flamant
      nn:norvegjês nynorsk
      no:norvegjês
      non:vieri norvegjês
      nso:sotho setentrionâl
      nv:navajo
      oc:ocitan
      or:oriya
      os:osetic
      ota:turc otoman
      pa:punjabi
      pap:papiamento
      peo:vieri persian
      pl:polac
      pro:vieri provenzâl
      ps:pashto
      pt:portughês
      pt-BR:portughês brasilian
      pt-PT:portughês iberic
      qu:quechua
      rm:rumanç
      ro:romen
      ro-MD:moldâf
      ru:rus
      sa:sanscrit
      sc:sardegnûl
      scn:sicilian
      sco:scozês
      sd:sindhi
      se:sami setentrionâl
      sg:sango
      sga:vieri irlandês
      si:sinalês
      sk:slovac
      sl:sloven
      sm:samoan
      so:somal
      sq:albanês
      sr:serp
      ss:swati
      st:sotho meridionâl
      su:sundanês
      sux:sumeric
      sv:svedês
      sw:swahili
      ta:tamil
      te:telegu
      tet:tetum
      tg:tagic
      th:thai
      tk:turcmen
      tl:tagalog
      tr:turc
      tt:tartar
      ty:tahitian
      ug:uigur
      uk:ucrain
      und:indeterminade
      ur:urdu
      uz:uzbec
      ve:venda
      vi:vietnamite
      wa:valon
      wo:wolof
      xh:xhosa
      yi:yiddish
      yo:yoruba
      zh:cinês
      zh-alt-menu:cinês
      zh-Hans:cinês semplificât
      zh-Hans-alt-long:cinês semplificât
      zh-Hant:cinês tradizionâl
      zh-Hant-alt-long:cinês tradizionâl
      zu:zulu
      """.trimIndent() }

  val fy: String by lazy { """
      aa:Afar
      ab:Abchazysk
      ace:Atjeesk
      ach:Akoli
      ada:Adangme
      ady:Adyghe
      ae:Avestysk
      af:Afrikaansk
      afh:Afrihili
      agq:Aghem
      ain:Ainu
      ak:Akan
      akk:Akkadysk
      ale:Aleut
      alt:Sûd-Altaïsk
      am:Amhaarsk
      an:Aragoneesk
      ang:âldingelsk
      anp:Angika
      ar:Arabysk
      ar-001:Modern standert Arabysk
      arc:Arameesk
      arn:Araukaansk
      arp:Arapaho
      arw:Arawak
      as:Assameesk
      asa:Asu
      ast:Asturysk
      av:Avarysk
      awa:Awadhi
      ay:Aymara
      az:Azerbeidzjaansk
      az-alt-short:Azeri
      ba:Basjkiersk
      bal:Baloetsjysk
      ban:Balineesk
      bas:Basa
      bax:Bamoun
      bbj:Ghomala’
      be:Wyt-Russysk
      bej:Beja
      bem:Bemba
      bez:Bena
      bfd:Bafut
      bg:Bulgaarsk
      bho:Bhojpuri
      bi:Bislama
      bik:Bikol
      bin:Bini
      bkm:Kom
      bla:Siksika
      bm:Bambara
      bn:Bengaalsk
      bo:Tibetaansk
      br:Bretonsk
      bra:Braj
      brx:Bodo
      bs:Bosnysk
      bss:Akoose
      bua:Buriat
      bug:Bugineesk
      bum:Bulu
      byn:Blin
      byv:Medumba
      ca:Katalaansk
      cad:Kaddo
      car:Karibysk
      cay:Cayuga
      cch:Atsam
      ce:Tsjetsjeensk
      ceb:Cebuano
      cgg:Chiga
      ch:Chamorro
      chb:Chibcha
      chg:Chagatai
      chk:Chuukeesk
      chm:Mari
      chn:Chinook-jargon
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      ckb:Soranî
      ckb-alt-menu:Soranî
      ckb-alt-variant:Soranî
      co:Korsikaansk
      cop:Koptysk
      cr:Cree
      crh:Krim-Tataarsk
      cs:Tsjechysk
      csb:Kasjoebysk
      cu:Kerkslavysk
      cv:Tsjoevasjysk
      cy:Welsk
      da:Deensk
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:Dútsk
      de-AT:Eastenryks Dútsk
      de-CH:Switsersk Heechdútsk
      del:Delaware
      den:Slave
      dgr:Dogrib
      din:Dinka
      dje:Zarma
      doi:Dogri
      dsb:Nedersorbysk
      dua:Duala
      dum:Middelnederlânsk
      dv:Divehi
      dyo:Jola-Fonyi
      dyu:Dyula
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      egy:Aldegyptysk
      eka:Ekajuk
      el:Gryks
      elx:Elamitysk
      en:Ingelsk
      en-AU:Australysk Ingelsk
      en-CA:Kanadeesk Ingelsk
      en-GB:Britsk Ingelsk
      en-GB-alt-short:Britsk Ingelsk
      en-US:Amerikaansk Ingelsk
      en-US-alt-short:Amerikaansk Ingelsk
      enm:Middelingelsk
      eo:Esperanto
      es:Spaansk
      es-419:Latynsk-Amerikaansk Spaansk
      es-ES:Europeesk Spaansk
      es-MX:Meksikaansk Spaansk
      et:Estlânsk
      eu:Baskysk
      ewo:Ewondo
      fa:Perzysk
      fan:Fang
      fat:Fanti
      ff:Fulah
      fi:Finsk
      fil:Filipynsk
      fj:Fijysk
      fo:Faeröersk
      fon:Fon
      fr:Frânsk
      fr-CA:Kanadeesk Frânsk
      fr-CH:Switserse Frânsk
      frm:Middelfrânsk
      fro:Aldfrânsk
      frr:Noard-Frysk
      frs:East-Frysk
      fur:Friulysk
      fy:Frysk
      ga:Iersk
      gaa:Ga
      gay:Gayo
      gba:Gbaya
      gd:Schotsk Gaelic
      gez:Geez
      gil:Gilberteesk
      gl:Galisysk
      gmh:Middelheechdútsk
      gn:Guaraní
      goh:Alsheechdútsk
      gon:Gondi
      gor:Gorontalo
      got:Gothysk
      grb:Grebo
      grc:Aldgryks
      gsw:Switsers Dútsk
      gu:Gujarati
      guz:Gusii
      gv:Manks
      gwi:Gwichʼin
      ha:Hausa
      hai:Haida
      haw:Hawaïaansk
      he:Hebreeuwsk
      hi:Hindi
      hil:Hiligaynon
      hit:Hettitysk
      hmn:Hmong
      ho:Hiri Motu
      hr:Kroatysk
      hsb:Oppersorbysk
      ht:Haïtiaansk
      hu:Hongaarsk
      hup:Hupa
      hy:Armeensk
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Yndonezysk
      ie:Interlingue
      ig:Igbo
      ii:Sichuan Yi
      ik:Inupiaq
      ilo:Iloko
      inh:Ingoesj
      io:Ido
      is:Yslâns
      it:Italiaansk
      iu:Inuktitut
      ja:Japans
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jpr:Judeo-Perzysk
      jrb:Judeo-Arabysk
      jv:Javaansk
      ka:Georgysk
      kaa:Karakalpaks
      kab:Kabyle
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kaw:Kawi
      kbd:Kabardysk
      kbl:Kanembu
      kcg:Tyap
      kde:Makonde
      kea:Kaapverdysk Creools
      kfo:Koro
      kg:Kongo
      kha:Khasi
      kho:Khotaneesk
      khq:Koyra Chiini
      ki:Kikuyu
      kj:Kuanyama
      kk:Kazachs
      kkj:Kako
      kl:Grienlâns
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Koreaansk
      kok:Konkani
      kos:Kosraeaansk
      kpe:Kpelle
      kr:Kanuri
      krc:Karachay-Balkar
      krl:Karelysk
      kru:Kurukh
      ks:Kasjmiri
      ksb:Shambala
      ksf:Bafia
      ksh:Kölsch
      ku:Koerdysk
      kum:Koemuks
      kut:Kutenai
      kv:Komi
      kw:Cornish
      ky:Kirgizysk
      la:Latyn
      lad:Ladino
      lag:Langi
      lah:Lahnda
      lam:Lamba
      lb:Luxemburgs
      lez:Lezgysk
      lg:Ganda
      li:Limburgs
      lkt:Lakota
      ln:Lingala
      lo:Laotiaansk
      lol:Mongo
      loz:Lozi
      lt:Litouws
      lu:Luba-Katanga
      lua:Luba-Lulua
      lui:Luiseno
      lun:Lunda
      luo:Luo
      lus:Lushai
      luy:Luyia
      lv:Letlâns
      mad:Madurees
      maf:Mafa
      mag:Magahi
      mai:Maithili
      mak:Makassaars
      man:Mandingo
      mas:Masai
      mde:Maba
      mdf:Moksha
      mdr:Mandar
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagasysk
      mga:Middeliers
      mgh:Makhuwa-Meetto
      mgo:Meta’
      mh:Marshallees
      mi:Maori
      mic:Mi’kmaq
      min:Minangkabau
      mk:Macedonysk
      ml:Malayalam
      mn:Mongools
      mnc:Mantsjoe
      mni:Manipoeri
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      ms:Maleis
      mt:Maltees
      mua:Mundang
      mul:Meardere talen
      mus:Creek
      mwl:Mirandees
      mwr:Marwari
      my:Birmees
      mye:Myene
      myv:Erzja
      na:Nauruaansk
      nap:Napolitaansk
      naq:Nama
      nb:Noors - Bokmål
      nd:Noard-Ndbele
      nds:Laagduits
      ne:Nepalees
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niueaansk
      nl:Nederlânsk
      nl-BE:Vlaams
      nmg:Ngumba
      nn:Noors - Nynorsk
      nnh:Ngiemboon
      no:Noors
      nog:Nogai
      non:Aldnoarsk
      nqo:N’ko
      nr:Sûd-Ndbele
      nso:Noard-Sotho
      nus:Nuer
      nv:Navajo
      nwc:Klassiek Newari
      ny:Nyanja
      nym:Nyamwezi
      nyn:Nyankole
      nyo:Nyoro
      nzi:Nzima
      oc:Occitaansk
      oj:Ojibwa
      om:Oromo
      or:Odia
      os:Ossetysk
      osa:Osage
      ota:Ottomaansk-Turks
      pa:Punjabi
      pag:Pangasinan
      pal:Pahlavi
      pam:Pampanga
      pap:Papiaments
      pau:Palauaansk
      peo:Aldperzysk
      phn:Foenisysk
      pi:Pali
      pl:Poalsk
      pon:Pohnpeiaansk
      pro:Aldprovençaals
      ps:Pasjtoe
      ps-alt-variant:Pashto
      pt:Portugeesk
      pt-BR:Brazyljaansk Portugees
      pt-PT:Europees Portugees
      qu:Quechua
      raj:Rajasthani
      rap:Rapanui
      rar:Rarotongan
      rm:Reto-Romaansk
      rn:Kirundi
      ro:Roemeensk
      ro-MD:Moldavysk
      rof:Rombo
      rom:Romani
      ru:Russysk
      rup:Aromaniaansk
      rw:Kinyarwanda
      rwk:Rwa
      sa:Sanskriet
      sad:Sandawe
      sah:Jakoets
      sam:Samaritaansk-Arameesk
      saq:Samburu
      sas:Sasak
      sat:Santali
      sba:Ngambay
      sbp:Sangu
      sc:Sardinysk
      scn:Siciliaansk
      sco:Schots
      sd:Sindhi
      se:Noard-Samysk
      see:Seneca
      seh:Sena
      sel:Selkup
      ses:Koyraboro Senni
      sg:Sango
      sga:Aldyrsk
      sh:Servokroatysk
      shi:Tashelhiyt
      shn:Shan
      shu:Tsjadysk Arabysk
      si:Singalees
      sid:Sidamo
      sk:Slowaaks
      sl:Sloveensk
      sm:Samoaansk
      sma:Sûd-Samysk
      smj:Lule Sami
      smn:Inari Sami
      sms:Skolt Sami
      sn:Shona
      snk:Soninke
      so:Somalysk
      sog:Sogdysk
      sq:Albaneesk
      sr:Servysk
      srn:Sranantongo
      srr:Serer
      ss:Swazi
      ssy:Saho
      st:Sûd-Sotho
      su:Soendaneesk
      suk:Sukuma
      sus:Soesoe
      sux:Soemerysk
      sv:Zweeds
      sw:Swahili
      sw-CD:Congo Swahili
      swb:Shimaore
      syc:Klassiek Syrysk
      syr:Syrysk
      ta:Tamil
      te:Telugu
      tem:Timne
      teo:Teso
      ter:Tereno
      tet:Tetun
      tg:Tadzjieks
      th:Thais
      ti:Tigrinya
      tig:Tigre
      tiv:Tiv
      tk:Turkmeens
      tkl:Tokelaus
      tl:Tagalog
      tlh:Klingon
      tli:Tlingit
      tmh:Tamashek
      tn:Tswana
      to:Tongaansk
      tog:Nyasa Tonga
      tpi:Tok Pisin
      tr:Turks
      trv:Taroko
      ts:Tsonga
      tsi:Tsimshian
      tt:Tataars
      tum:Toemboeka
      tvl:Tuvaluaansk
      tw:Twi
      twq:Tasawaq
      ty:Tahitysk
      tyv:Tuvinysk
      tzm:Tamazight (Sintraal-Marokko)
      udm:Oedmoerts
      ug:Oeigoers
      uga:Oegaritysk
      uk:Oekraïens
      umb:Umbundu
      und:Onbekende taal
      ur:Urdu
      uz:Oezbeeks
      vai:Vai
      ve:Venda
      vi:Vietnamees
      vo:Volapük
      vot:Votysk
      vun:Vunjo
      wa:Waals
      wae:Walser
      wal:Walamo
      war:Waray
      was:Washo
      wo:Wolof
      xal:Kalmyk
      xh:Xhosa
      xog:Soga
      yao:Yao
      yap:Yapees
      yav:Yangben
      ybb:Yemba
      yi:Jiddysk
      yo:Yoruba
      yue:Kantoneesk
      yue-alt-menu:Kantoneesk
      za:Zhuang
      zap:Zapotec
      zbl:Blissymbolen
      zen:Zenaga
      zgh:Standert Marokkaanske Tamazight
      zh:Sineesk
      zh-alt-menu:Sineesk
      zh-Hans:Ferienfâldich Sineesk
      zh-Hans-alt-long:Ferienfâldich Sineesk
      zh-Hant:Tradisjoneel Sineesk
      zh-Hant-alt-long:Tradisjoneel Sineesk
      zu:Zulu
      zun:Zuni
      zxx:Gjin linguïstyske ynhâld
      zza:Zaza
      """.trimIndent() }

  val ga: String by lazy { """
      aa:Afáiris
      ab:Abcáisis
      ace:Aicinéis
      ada:Daingmis
      ady:Adaigéis
      ae:Aivéistis
      af:Afracáinis
      agq:Aigeimis
      ain:Aidhniúis
      ak:Acáinis
      akk:Acáidis
      ale:Ailiúitis
      alt:Altaeis an Deiscirt
      am:Amáiris
      an:Aragóinis
      ang:Sean-Bhéarla
      ann:Obolo
      anp:Aingícis
      ar:Araibis
      ar-001:Araibis Chaighdeánach
      arc:Aramais
      arn:Mapúitsis
      arp:Arapachóis
      ars:Araibis Najdi
      as:Asaimis
      asa:Asúis
      ast:Astúiris
      atj:Atikamekw
      av:Aváiris
      awa:Avaidis
      ay:Aidhmiris
      az:Asarbaiseáinis
      az-alt-short:Asairis
      ba:Baiscíris
      ban:Bailís
      bar:Baváiris
      bas:Basáis
      be:Bealarúisis
      bem:Beimbis
      bez:Beinis
      bg:Bulgáiris
      bgc:Haryanvi
      bho:Vóispiris
      bi:Bioslaimis
      bin:Binis
      bla:Sicsicis
      blo:Anii
      bm:Bambairis
      bn:Beangáilis
      bo:Tibéidis
      br:Briotáinis
      brx:Bódóis
      bs:Boisnis
      bua:Buiriáitis
      bug:Buiginis
      byn:Blinis
      ca:Catalóinis
      cay:teanga Cayuga
      ccp:Seácmais
      ce:Seisnis
      ceb:Seabúáinis
      cgg:Cígis
      ch:Seamóiris
      chk:Siúicísis
      chm:Mairis
      cho:Seactáis
      chp:Siopúáinis
      chr:Seiricis
      chy:Siáinis
      ckb:Coirdis Lárnach
      ckb-alt-menu:Coirdis Lárnach
      ckb-alt-variant:Coirdis, Sóráinis
      clc:Chilcotin
      co:Corsaicis
      cop:Coptais
      cr:Craís
      crg:Michif
      crj:Craís an Deiscirt Thoir
      crk:Plains Cree
      crl:Craís Thoir Thuaidh
      crm:Moose Cree
      crr:teanga Algancach Carolina
      crs:Criól Fraincise Seselwa
      cs:Seicis
      csb:Caisiúibis
      csw:Swampy Cree
      cu:Slavais na hEaglaise
      cv:Suvaisis
      cy:Breatnais
      da:Danmhairgis
      dak:Dacótais
      dar:Dargais
      dav:Taita
      de:Gearmáinis
      de-AT:Gearmáinis na hOstaire
      de-CH:Ard-Ghearmáinis Eilvéiseach
      dgr:Dograibis
      dje:Zarmais
      doi:Dóigris
      dsb:Sorbais Íochtarach
      dua:Duailis
      dum:Meán-Ollainnis
      dv:Divéihis
      dyo:Jóla-Fainis
      dz:Seoinicis
      dzg:Dazaga
      ebu:Ciambúis
      ee:Éabhais
      efi:Eificis
      egy:Sean-Éigiptis
      eka:Acaidiúcais
      el:Gréigis
      en:Béarla
      en-AU:Béarla na hAstráile
      en-CA:Béarla Cheanada
      en-GB:Béarla na Breataine
      en-GB-alt-short:Béarla na R.A.
      en-US:Béarla Mheiriceá
      en-US-alt-short:Béarla S.A.M.
      enm:Meán-Bhéarla
      eo:Esperanto
      es:Spáinnis
      es-419:Spáinnis Mheiriceá Laidinigh
      es-ES:Spáinnis Eorpach
      es-MX:Spáinnis Mheicsiceach
      et:Eastóinis
      eu:Bascais
      ewo:Éabhandóis
      fa:Peirsis
      fa-AF:Dairis
      ff:Fuláinis
      fi:Fionlainnis
      fil:Filipínis
      fj:Fidsis
      fo:Faróis
      fon:Fonais
      fr:Fraincis
      fr-CA:Fraincis Cheanada
      fr-CH:Fraincis na hEilvéise
      frc:Fraincis Cajun
      frm:Meán-Fhraincis
      fro:Sean-Fhraincis
      frr:Freaslainnis an Tuaiscirt
      fur:Friúilis
      fy:Freaslainnis Iartharach
      ga:Gaeilge
      gaa:Geáis
      gan:Sínis Gan
      gd:Gaeilge na hAlban
      gez:Aetóipis
      gil:Gilbeartais
      gl:Gailísis
      gmh:Meán-Ard-Ghearmáinis
      gn:Guaráinis
      goh:Sean-Ard-Ghearmáinis
      gor:Gorantalais
      grc:Sean-Ghréigis
      gsw:Gearmáinis Eilvéiseach
      gu:Gúisearáitis
      guc:Uaúis
      guz:Gúsaís
      gv:Manainnis
      gwi:Goitsinis
      ha:Hásais
      hai:Haídis
      hak:Haicéis
      haw:Haváis
      hax:Haídis an Deiscirt
      he:Eabhrais
      hi:Hiondúis
      hif:Hiondúis Fhidsí
      hil:Hilgeanóinis
      hit:Hitis
      hmn:Hmongais
      ho:Motúis Hírí
      hr:Cróitis
      hsb:Sorbais Uachtarach
      hsn:Sínis Xiang
      ht:Críol Háítí
      hu:Ungáiris
      hup:Húipis
      hur:Halkomelem
      hy:Airméinis
      hz:Heiréiris
      ia:Interlingua
      iba:Ibeainis
      ibb:Ibibis
      id:Indinéisis
      ie:Interlingue
      ig:Íogbóis
      ii:Ís Shichuan
      ik:Iniúipiaicis
      ikt:Ionúitis Iarthar Cheanada
      ilo:Ileacáinis
      inh:Iongúis
      io:Ídis
      is:Íoslainnis
      it:Iodáilis
      iu:Ionúitis
      ja:Seapáinis
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jut:Iútlainnis
      jv:Iáivis
      ka:Seoirsis
      kaa:Cara-Chalpáis
      kab:Caibílis
      kac:Caitsinis
      kaj:Jju
      kam:Cambais
      kbd:Cabairdis
      kcg:Tyap
      kde:Makonde
      kea:Criól Cabo Verde
      kfo:Koro
      kg:Congóis
      kgp:Kaingang
      kha:Caisis
      khq:Songais Iartharach
      ki:Ciocúis
      kj:Cuainiáimis
      kk:Casaicis
      kkj:Cacóis
      kl:Kalaallisut
      kln:Kalenjin
      km:Ciméiris
      kmb:Ciombundais
      kn:Cannadais
      ko:Cóiréis
      kok:Concáinis
      kpe:Caipeilis
      kr:Canúiris
      krc:Caraicí-Balcáiris
      krl:Cairéilis
      kru:Curúicis
      ks:Caismíris
      ksb:Shambala
      ksf:Baifiais
      ksh:Coilsis
      ku:Coirdis
      kum:Cúimicis
      kv:Coimis
      kw:Coirnis
      kwk:Kwakʼwala
      kxv:Kuvi
      ky:Cirgisis
      la:Laidin
      lad:Laidínis
      lag:Ciolaingis
      lah:Puinseáibis Iartharach
      lb:Lucsambuirgis
      lez:Leisgis
      lg:Lugandais
      li:Liombuirgis
      lij:Liogúiris
      lil:Lillooet
      liv:Liovóinis
      lkt:Lacótais
      lmo:Lombairdis
      ln:Liongáilis
      lo:Laoisis
      lou:Criól Louisiana
      loz:Lóisis
      lrc:Lúiris an Tuaiscirt
      lsm:Saamia
      lt:Liotuáinis
      lu:Lúba-Cataingis
      lua:Luba-Lulua
      lun:Lundais
      luo:Lúóis
      lus:Míosóis
      luy:Luyia
      lv:Laitvis
      mad:Maidiúiris
      mag:Magaidis
      mai:Maitilis
      mak:Macasairis
      mas:Másais
      mdf:Mocsais
      men:Meindis
      mer:Meru
      mfe:Morisyen
      mg:Malagáisis
      mga:Meán-Ghaeilge
      mgh:Meiteo-Macuais
      mgo:Metaʼ
      mh:Mairsillis
      mi:Maorais
      mic:Micmeaicis
      min:Míneangcababhais
      mk:Macadóinis
      ml:Mailéalaimis
      mn:Mongóilis
      mni:Manapúiris
      moe:Innu-aimun
      moh:Móháicis
      mos:Mosais
      mr:Maraitis
      mrj:Mairis Iartharach
      ms:Malaeis
      mt:Máltais
      mua:Mundang
      mul:Ilteangacha
      mus:Muscogee
      mwl:Mioraindéis
      mwr:Marmhairis
      my:Burmais
      myv:Éirsis
      mzn:Mázandaráinis
      na:Nárúis
      nan:Sínis Min Nan
      nap:Napóilis
      naq:Nama
      nb:Bocmál
      nd:N-deibéilis an Tuaiscirt
      nds:Gearmáinis Íochtarach
      nds-NL:Sacsainis Íochtarach
      ne:Neipeailis
      new:Néamharais
      ng:Ndongais
      nia:Niaisis
      niu:Níobhais
      nl:Ollainnis
      nl-BE:Pléimeannais
      nmg:Cuaiseois
      nn:Nua-Ioruais
      nnh:Ngiemboon
      no:Ioruais
      nog:Nógaeis
      non:Sean-Lochlainnis
      nqo:N-cóis
      nr:Ndeibéilis an Deiscirt
      nso:Sútúis an Tuaiscirt
      nus:Nuairis
      nv:Navachóis
      ny:Siséivis
      nyn:Niancóilis
      oc:Ocsatáinis
      oj:Óisibis
      ojb:Óisibis Iarthuiscirt
      ojc:Óisibis Lárnach
      ojs:Oji-Cree
      ojw:Óisibis an Iarthar
      oka:Okanagan
      om:Oraimis
      or:Odia
      os:Oiséitis
      pa:Puinseáibis
      pag:Pangasaíneánais
      pam:Pampaingis
      pap:Paipeamaintis
      pau:Palabhais
      pcm:pidsean na Nigéire
      peo:Sean-Pheirsis
      pi:Páilis
      pis:Pijin
      pl:Polainnis
      pqm:Maliseet-Passamaquoddy
      prg:Prúisis
      ps:Paistis
      pt:Portaingéilis
      pt-BR:Portaingéilis Bhrasaíleach
      pt-PT:Portaingéilis Ibéarach
      qu:Ceatsuais
      quc:Cuitséis
      raj:Rajasthani
      rap:Rapanúis
      rar:Raratongais
      rhg:Róihinis
      rm:Rómainis
      rn:Rúindis
      ro:Rómáinis
      ro-MD:Moldáivis
      rof:Rombo
      rom:Romainis
      ru:Rúisis
      rup:Arómáinis
      rw:Ciniaruaindis
      rwk:Rwa
      sa:Sanscrait
      sad:Sandabhais
      sah:Sachais
      sam:Aramais Shamárach
      saq:Samburu
      sat:Santáilis
      sba:Ngambay
      sbp:Sangu
      sc:Sairdínis
      scn:Sicilis
      sco:Albainis
      sd:Sindis
      se:Sáimis an Tuaiscirt
      seh:Sena
      ses:Songais Oirthearach
      sg:Sangóis
      sga:Sean-Ghaeilge
      sh:Seirbea-Chróitis
      shi:Tachelhit
      shn:Seánais
      si:Siolóinis
      sk:Slóvaicis
      sl:Slóivéinis
      slh:Lushootseed an Deiscirt
      sm:Samóis
      sma:Sáimis Theas
      smj:Sáimis Lule
      smn:Sáimis Inari
      sms:Sáimis Skolt
      sn:Seoinis
      snk:Soinincéis
      so:Somáilis
      sog:Sogdánais
      sq:Albáinis
      sr:Seirbis
      srn:Suranaimis
      ss:Suaisis
      st:Sútúis an Deiscirt
      str:Straits Salish
      su:Sundais
      suk:Sucúimis
      sux:Suiméiris
      sv:Sualainnis
      sw:Svahaílis
      sw-CD:Svahaílis an Chongó
      swb:teanga na gComórach
      syr:Siricis
      szl:Siléisis
      ta:Tamailis
      tce:Tutchone an Deiscirt
      te:Teileagúis
      tem:Teimnis
      teo:Teso
      tet:Teitimis
      tg:Taidsícis
      tgx:Tagish
      th:Téalainnis
      tht:Tahltan
      ti:Tigrinis
      tig:Tigréis
      tk:Tuircméinis
      tl:Tagálaigis
      tlh:Klingon
      tli:Clincitis
      tn:Suáinis
      to:Tongais
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Tuircis
      trv:Taroko
      ts:Songais
      tt:Tatairis
      ttm:Northern Tutchone
      tum:Tumbúicis
      tvl:Tuvalu
      tw:Tíbhis
      twq:Tasawaq
      ty:Taihítis
      tyv:Túvainis
      tzm:Tamaisis Atlais Láir
      udm:Udmairtis
      ug:Uigiúiris
      uk:Úcráinis
      umb:Umbundais
      und:Teanga anaithnid
      ur:Urdúis
      uz:Úisbéiceastáinis
      vai:Vadhais
      ve:Veindis
      vec:Veinéisis
      vi:Vítneaimis
      vls:Pléimeannais Iartharach
      vmw:Macuais
      vo:Volapük
      vun:Vunjo
      wa:Vallúnais
      wae:Walser
      wal:Uailéitis
      war:Uairéis
      wo:Volaifis
      wuu:Sínis Wu
      xal:Cailmícis
      xh:Cóisis
      xnr:Kangri
      xog:Soga
      yav:Yangben
      ybb:Yemba
      yi:Giúdais
      yo:Iarúibis
      yrl:Nheengatu
      yue:Cantainis
      yue-alt-menu:Sínis, Cantainis
      za:Siuáingis
      zea:Séalainnis
      zgh:Tamaisis Chaighdeánach Mharacó
      zh:Sínis
      zh-alt-menu:Sínis, Mandairínis
      zh-Hans:Sínis Shimplithe
      zh-Hans-alt-long:Mandairínis Shimplithe
      zh-Hant:Sínis Thraidisiúnta
      zh-Hant-alt-long:Mandairínis Thraidisiúnta
      zu:Súlúis
      zun:Zúinis
      zxx:Gan ábhar teangeolaíoch
      zza:Zázá
      """.trimIndent() }

  val ga_GB: String? = null

  val gaa: String by lazy { """
      en:Blɔfo
      gaa:Gã
      """.trimIndent() }

  val gd: String by lazy { """
      aa:Afar
      ab:Abchasais
      ace:Basa Acèh
      ach:Acoli
      ada:Adangme
      ady:Adyghe
      ae:Avestanais
      aeb:Arabais Thuiniseach
      af:Afraganais
      afh:Afrihili
      agq:Aghem
      ain:Ainu
      ak:Akan
      akk:Acadais
      akz:Alabama
      ale:Aleutais
      aln:Albàinis Ghegeach
      alt:Altais Dheasach
      am:Amtharais
      an:Aragonais
      ang:Seann-Bheurla
      ann:Obolo
      anp:Angika
      apc:Arabais Levantach
      ar:Arabais
      ar-001:Nuadh-Arabais Stannardach
      arc:Aramais
      arn:Mapudungun
      aro:Araona
      arp:Arapaho
      arq:Arabais Aildireach
      ars:Arabais Najdi
      arw:Arawak
      ary:Arabais Mhorocach
      arz:Arabais Èipheiteach
      as:Asamais
      asa:Asu
      ase:Cainnt-shanais na h-Aimeireaga
      ast:Astùrais
      atj:Atikamekw
      av:Avarais
      avk:Kotava
      awa:Awadhi
      ay:Aymara
      az:Asarbaideànais
      az-alt-short:Azeri
      ba:Bashkir
      bal:Baluchì
      ban:Cànan Bali
      bas:Basaa
      bax:Bamun
      bbc:Batak Toba
      bbj:Ghomala
      be:Bealaruisis
      bej:Beja
      bem:Bemba
      bew:Betawi
      bez:Bena
      bfd:Bafut
      bfq:Badaga
      bg:Bulgarais
      bgc:Haryanvi
      bgn:Balochi Shiarach
      bho:Bhojpuri
      bi:Bislama
      bik:Bikol
      bin:Edo
      bjn:Banjar
      bkm:Kom
      bla:Siksika
      blo:Anii
      blt:Tai Dam
      bm:Bambara
      bn:Bangla
      bo:Tibeitis
      bpy:Bishnupriya
      bqi:Bakhtiari
      br:Breatnais
      bra:Braj
      brh:Brahui
      brx:Bodo
      bs:Bosnais
      bss:Akoose
      bua:Buriat
      bug:Cànan nam Bugis
      bum:Bulu
      byn:Blin
      byv:Medumba
      ca:Catalanais
      cad:Caddo
      car:Carib
      cay:Cayuga
      cch:Atsam
      ccp:Chakma
      ce:Deideanais
      ceb:Cebuano
      cgg:Chiga
      ch:Chamorro
      chb:Chibcha
      chg:Chagatai
      chk:Cànan Chuuk
      chm:Mari
      chn:Chinuk Wawa
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      cic:Chickasaw
      ckb:Cùrdais Mheadhanach
      ckb-alt-menu:Cùrdais Mheadhanach
      ckb-alt-variant:Cùrdais Sorani
      clc:Chilcotin
      co:Corsais
      cop:Coptais
      cps:Capiznon
      cr:Cree
      crg:Michif
      crh:Turcais Chriomach
      crj:Cree Ear-dheasach
      crk:Cree nam Machair
      crl:Cree Ear-thuathach
      crm:Moose Cree
      crr:Algonquianais Charolina
      crs:Seiseallais
      cs:Seicis
      csb:Caisiubais
      csw:Omushkego
      cu:Slàbhais na h-Eaglaise
      cv:Chuvash
      cy:Cuimris
      da:Danmhairgis
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:Gearmailtis
      de-AT:Gearmailtis na h-Ostaire
      de-CH:Àrd-Ghearmailtis na h-Eilbheise
      del:Delaware
      den:Slavey
      dgr:Dogrib
      din:Dinka
      dje:Zarma
      doi:Dogri
      dsb:Sòrbais Ìochdarach
      dtp:Dusun Mheadhanach
      dua:Duala
      dum:Meadhan-Dhuitsis
      dv:Divehi
      dyo:Jola-Fonyi
      dyu:Dyula
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      egy:Èipheitis Àrsaidh
      eka:Ekajuk
      el:Greugais
      elx:Elamais
      en:Beurla
      en-AU:Beurla Astràilia
      en-CA:Beurla Chanada
      en-GB:Beurla Bhreatainn
      en-GB-alt-short:Beurla na RA
      en-US:Beurla na h-Aimeireaga
      en-US-alt-short:Beurla nan SA
      enm:Meadhan-Bheurla
      eo:Esperanto
      es:Spàinntis
      es-419:Spàinntis na h-Aimeireaga Laidinneach
      es-ES:Spàinntis Eòrpach
      es-MX:Spàinntis Mheagsagach
      esu:Yupik Mheadhanach
      et:Eastoinis
      eu:Basgais
      ewo:Ewondo
      ext:Cànan na h-Extremadura
      fa:Peirsis
      fa-AF:Dari
      fan:Fang
      fat:Fanti
      ff:Fulah
      fi:Fionnlannais
      fil:Filipinis
      fit:Meänkieli
      fj:Fìdis
      fo:Fàrothais
      fon:Fon
      fr:Fraingis
      fr-CA:Fraingis Chanada
      fr-CH:Fraingis Eilbheiseach
      frc:Fraingis nan Cajun
      frm:Meadhan-Fhraingis
      fro:Seann-Fhraingis
      frp:Arpitan
      frr:Frìoslannais Thuathach
      frs:Frìoslannais Earach
      fur:Friùilis
      fy:Frìoslannais Shiarach
      ga:Gaeilge
      gaa:Ga
      gag:Gagauz
      gan:Gan
      gay:Gayo
      gba:Gbaya
      gbz:Dari Zoroastrach
      gd:Gàidhlig
      gez:Ge’ez
      gil:Ciribeasais
      gl:Gailìsis
      glk:Gilaki
      gmh:Meadhan-Àrd-Gearmailtis
      gn:Guaraní
      goh:Seann-Àrd-Gearmailtis
      gon:Gondi
      gor:Gorontalo
      got:Gotais
      grb:Grebo
      grc:Greugais Àrsaidh
      gsw:Gearmailtis Eilbheiseach
      gu:Gujarati
      guc:Wayuu
      gur:Frafra
      guz:Gusii
      gv:Gaelg
      gwi:Gwichʼin
      ha:Hausa
      hai:Haida
      hak:Hakka
      haw:Cànan Hawai’i
      hax:Haida Dheasach
      he:Eabhra
      hi:Hindis
      hi-Latn-alt-variant:Hinglish
      hif:Hindis Fhìditheach
      hil:Hiligaynon
      hit:Cànan Het
      hmn:Hmong
      hnj:Hmong Njua
      ho:Hiri Motu
      hr:Cròthaisis
      hsb:Sòrbais Uachdarach
      hsn:Xiang
      ht:Crìtheol Haidhti
      hu:Ungairis
      hup:Hupa
      hur:Halkomelem
      hy:Airmeinis
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Innd-Innsis
      ie:Interlingue
      ig:Igbo
      ii:Yi Sichuan
      ik:Inupiaq
      ikt:Inuktitut Shiarach Chanada
      ilo:Iloko
      inh:Ingush
      io:Ido
      is:Innis Tìlis
      it:Eadailtis
      iu:Inuktitut
      ja:Seapanais
      jam:Beurla Crìtheolach Diameuga
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jpr:Peirsis Iùdhach
      jrb:Arabais Iùdhach
      jv:Deàbhanais
      ka:Cairtbheilis
      kaa:Kara-Kalpak
      kab:Kabyle
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kaw:Kawi
      kbd:Cabardais
      kbl:Kanembu
      kcg:Tyap
      kde:Makonde
      kea:Kabuverdianu
      ken:Kenyang
      kfo:Koro
      kg:Kongo
      kgp:Kaingang
      kha:Khasi
      kho:Cànan Khotan
      khq:Koyra Chiini
      khw:Khowar
      ki:Kikuyu
      kiu:Kirmanjki
      kj:Kuanyama
      kk:Casachais
      kkj:Kako
      kl:Kalaallisut
      kln:Kalenjin
      km:Cmèar
      kmb:Kimbundu
      kn:Kannada
      ko:Coirèanais
      koi:Komi-Permyak
      kok:Konkani
      kpe:Kpelle
      kr:Kanuri
      krc:Karachay-Balkar
      kri:Krio
      krj:Kinaray-a
      krl:Cairealais
      kru:Kurukh
      ks:Caismiris
      ksb:Shambala
      ksf:Bafia
      ksh:Gearmailtis Chologne
      ku:Cùrdais
      kum:Kumyk
      kut:Kutenai
      kv:Komi
      kw:Còrnais
      kwk:Kwakʼwala
      kxv:Kuvi
      ky:Cìorgasais
      la:Laideann
      lad:Ladino
      lag:Langi
      lah:Lahnda
      lam:Lamba
      lb:Lugsamburgais
      lez:Leasgais
      lfn:Lingua Franca Nova
      lg:Ganda
      li:Cànan Limburg
      lij:Liogùrais
      lil:Lillooet
      lkt:Lakhóta
      lld:Ladainis
      lmo:Lombardais
      ln:Lingala
      lo:Làtho
      lol:Mongo
      lou:Crìtheol Louisiana
      loz:Lozi
      lrc:Luri Thuathach
      lsm:Saamia
      lt:Liotuainis
      ltg:Latgailis
      lu:Luba-Katanga
      lua:Luba-Lulua
      lui:Luiseño
      lun:Lunda
      luo:Luo
      lus:Mizo
      luy:Luyia
      lv:Laitbheis
      lzh:Sìnis an Litreachais
      lzz:Laz
      mad:Cànan Madhura
      maf:Mafa
      mag:Magahi
      mai:Maithili
      mak:Makasar
      man:Mandingo
      mas:Maasai
      mde:Maba
      mdf:Moksha
      mdr:Mandar
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagasais
      mga:Meadhan-Ghaeilge
      mgh:Makhuwa-Meetto
      mgo:Meta’
      mh:Marshallais
      mhn:Mócheno
      mi:Māori
      mic:Mi’kmaq
      min:Minangkabau
      mk:Masadonais
      ml:Malayalam
      mn:Mongolais
      mnc:Manchu
      mni:Manipuri
      moe:Innu-aimun
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      mrj:Mari Shiarach
      ms:Malaidhis
      mt:Maltais
      mua:Mundang
      mul:Iomadh cànan
      mus:Creek
      mwl:Miorandais
      mwr:Marwari
      mwv:Mentawai
      my:Burmais
      mye:Myene
      myv:Erzya
      mzn:Mazanderani
      na:Nabhru
      nan:Min Nan
      nap:Eadailtis Napoli
      naq:Nama
      nb:Bokmål na Nirribhidh
      nd:Ndebele Thuathach
      nds:Gearmailtis Ìochdarach
      nds-NL:Sagsannais Ìochdarach
      ne:Neapàlais
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Cànan Niue
      njo:Ao Naga
      nl:Duitsis
      nl-BE:Flànrais
      nmg:Kwasio
      nn:Nynorsk na Nirribhidh
      nnh:Ngiemboon
      no:Nirribhis
      nog:Nogai
      non:Seann-Lochlannais
      nov:Novial
      nqo:N’Ko
      nr:Ndebele Dheasach
      nso:Sesotho sa Leboa
      nus:Nuer
      nv:Navajo
      nwc:Newari Chlasaigeach
      ny:Nyanja
      nym:Nyamwezi
      nyn:Nyankole
      nyo:Nyoro
      nzi:Nzima
      oc:Ogsatanais
      oj:Ojibwa
      ojb:Ojibwa Iar-thuathach
      ojc:Ojibwa Mheadhanach
      ojs:Oji-Cree
      ojw:Ojibwa Shiarach
      oka:Okanagan
      om:Oromo
      or:Odia
      os:Ossetic
      osa:Osage
      ota:Turcais Otomanach
      pa:Panjabi
      pag:Pangasinan
      pal:Pahlavi
      pam:Pampanga
      pap:Papiamentu
      pau:Palabhais
      pcd:Picard
      pcm:Beurla Nigèiriach
      pdc:Gearmailtis Phennsylvania
      pdt:Plautdietsch
      peo:Seann-Pheirsis
      phn:Phenicis
      pi:Pali
      pis:Pijin
      pl:Pòlainnis
      pms:Piedmontese
      pon:Cànan Pohnpei
      pqm:Maliseet-Passamaquoddy
      prg:Pruisis
      pro:Seann-Phrovençal
      ps:Pashto
      pt:Portagailis
      pt-BR:Portagailis Bhraisileach
      pt-PT:Portagailis Eòrpach
      qu:Quechua
      quc:K’iche’
      qug:Quichua Àrd-tìr Chimborazo
      raj:Rajasthani
      rap:Rapa Nui
      rar:Cànan Rarotonga
      rgn:Romagnol
      rhg:Rohingya
      rif:Tamaisich an Rif
      rm:Rumains
      rn:Kirundi
      ro:Romàinis
      ro-MD:Moldobhais
      rof:Rombo
      rom:Romanais
      ru:Ruisis
      rue:Rusyn
      rug:Roviana
      rup:Aromanais
      rw:Kinyarwanda
      rwk:Rwa
      sa:Sanskrit
      sad:Sandawe
      sah:Sakha
      sam:Aramais Shamaritanach
      saq:Samburu
      sas:Sasak
      sat:Santali
      saz:Saurashtra
      sba:Ngambay
      sbp:Sangu
      sc:Sàrdais
      scn:Sisilis
      sco:Albais
      sd:Sindhi
      sdc:Sassarese
      sdh:Cùrdais Dheasach
      se:Sàmais Thuathach
      see:Seneca
      seh:Sena
      sei:Seri
      sel:Selkup
      ses:Koyraboro Senni
      sg:Sango
      sga:Seann-Ghaeilge
      sh:Sèirb-Chròthaisis
      shi:Tachelhit
      shn:Shan
      shu:Arabais Seàdach
      si:Sinhala
      sid:Sidamo
      sk:Slòbhacais
      skr:Saraiki
      sl:Slòbhainis
      slh:Lushootseed Dheasach
      sly:Selayar
      sm:Samothais
      sma:Sàmais Dheasach
      smj:Sàmais Lule
      smn:Sàmais Inari
      sms:Sàmais Skolt
      sn:Shona
      snk:Soninke
      so:Somàilis
      sq:Albàinis
      sr:Sèirbis
      srn:Sranan Tongo
      srr:Serer
      ss:Swati
      ssy:Saho
      st:Sesotho
      str:Salish a’ Chaolais
      su:Cànan Sunda
      suk:Sukuma
      sus:Susu
      sux:Cànan Sumer
      sv:Suainis
      sw:Kiswahili
      sw-CD:Kiswahili na Congo
      swb:Comorais
      syc:Suraidheac Chlasaigeach
      syr:Suraidheac
      szl:Sileisis
      ta:Taimilis
      tce:Tutchone Dheasach
      tcy:Tulu
      te:Telugu
      tem:Timne
      teo:Teso
      ter:Terêna
      tet:Tetum
      tg:Taidigis
      tgx:Tagish
      th:Cànan nan Tàidh
      tht:Tahltan
      ti:Tigrinya
      tig:Tigre
      tiv:Tiv
      tk:Turcmanais
      tkl:Tokelau
      tkr:Tsakhur
      tl:Tagalog
      tlh:Klingon
      tli:Tlingit
      tly:Talysh
      tmh:Tamashek
      tn:Tswana
      to:Tonga
      tog:Nyasa Tonga
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Turcais
      tru:Turoyo
      trv:Taroko
      trw:Torwali
      ts:Tsonga
      tsi:Tsimshian
      tt:Tatarais
      ttm:Tutchone Thuathach
      ttt:Tati
      tum:Tumbuka
      tvl:Tubhalu
      tw:Twi
      twq:Tasawaq
      ty:Cànan Tahiti
      tyv:Cànan Tuva
      tzm:Tamaisich an Atlais Mheadhanaich
      udm:Udmurt
      ug:Ùigiurais
      uk:Ucràinis
      umb:Umbundu
      und:Cànan neo-aithnichte
      ur:Ùrdu
      uz:Usbagais
      vai:Vai
      ve:Venda
      vec:Bheinisis
      vep:Veps
      vi:Bhiet-Namais
      vls:Flànrais Shiarach
      vmw:Makhuwa
      vo:Volapük
      vro:Võro
      vun:Vunjo
      wa:Walloon
      wae:Gearmailtis Wallis
      wal:Wolaytta
      war:Waray
      was:Washo
      wbp:Warlpiri
      wo:Wolof
      wuu:Wu
      xal:Kalmyk
      xh:Xhosa
      xnr:Kangri
      xog:Soga
      yao:Yao
      yap:Cànan Yap
      yav:Yangben
      ybb:Yemba
      yi:Iùdhais
      yo:Yoruba
      yrl:Nheengatu
      yue:Cantonais
      yue-alt-menu:Sìnis, Cantonais
      za:Zhuang
      zap:Zapotec
      zbl:Comharran Bliss
      zea:Cànan Zeeland
      zen:Zenaga
      zgh:Tamaisich Stannardach Moroco
      zh:Sìnis
      zh-alt-menu:Sìnis, Mandairinis
      zh-Hans:Sìnis Shimplichte
      zh-Hans-alt-long:Mandairinis Shimplichte
      zh-Hant:Sìnis Thradaiseanta
      zh-Hant-alt-long:Mandairinis Thradaiseanta
      zu:Zulu
      zun:Zuñi
      zxx:Susbaint nach eil ’na chànan
      zza:Zazaki
      """.trimIndent() }

  val gl: String by lazy { """
      aa:afar
      ab:abkhazo
      ace:achinés
      ach:acholí
      ada:adangme
      ady:adigueo
      af:afrikaans
      agq:aghem
      ain:ainu
      ak:akan
      ale:aleutiano
      alt:altai meridional
      am:amhárico
      an:aragonés
      ann:obolo
      anp:angika
      ar:árabe
      ar-001:árabe estándar moderno
      arc:arameo
      arn:mapuche
      arp:arapaho
      ars:árabe najdi
      as:assamés
      asa:asu
      ast:asturiano
      atj:atikamekw
      av:avar
      awa:awadhi
      ay:aimará
      az:acerbaixano
      az-alt-short:azerí
      ba:baxkir
      ban:balinés
      bas:basaa
      be:belaruso
      bem:bemba
      bez:bena
      bg:búlgaro
      bgc:hariani
      bgn:baluchi occidental
      bho:bhojpuri
      bi:bislama
      bin:bini
      bla:siksiká
      blo:anii
      bm:bambara
      bn:bengalí
      bo:tibetano
      br:bretón
      brx:bodo
      bs:bosníaco
      bug:buginés
      byn:blin
      ca:catalán
      cay:cayuga
      ccp:chakma
      ce:checheno
      ceb:cebuano
      cgg:kiga
      ch:chamorro
      chk:chuuk
      chm:mari
      cho:choctaw
      chp:chipewyan
      chr:cherokee
      chy:cheyenne
      ckb:kurdo central
      ckb-alt-menu:kurdo central
      ckb-alt-variant:sorani
      clc:chilcotin
      co:corso
      crg:michif
      crj:cree do sueste
      crk:cree das chairas
      crl:cree do nordeste
      crm:cree de Moose
      crr:algonquino de Carolina
      crs:seselwa (crioulo das Seychelles)
      cs:checo
      csw:cree dos pantanos
      cu:eslavo eclesiástico
      cv:chuvaxo
      cy:galés
      da:dinamarqués
      dak:dakota
      dar:dargwa
      dav:taita
      de:alemán
      de-AT:alemán austríaco
      de-CH:alto alemán suízo
      dgr:dogrib
      dje:zarma
      doi:dogri
      dsb:baixo sorbio
      dua:duala
      dv:divehi
      dyo:jola-fonyi
      dz:dzongkha
      dzg:dazaga
      ebu:embu
      ee:ewe
      efi:efik
      egy:exipcio antigo
      eka:ekajuk
      el:grego
      en:inglés
      en-AU:inglés australiano
      en-CA:inglés canadense
      en-GB:inglés británico
      en-GB-alt-short:inglés (RU)
      en-US:inglés estadounidense
      en-US-alt-short:inglés (EUA)
      eo:esperanto
      es:español
      es-419:español de América
      es-ES:español de España
      es-MX:español de México
      et:estoniano
      eu:éuscaro
      ewo:ewondo
      fa:persa
      fa-AF:dari
      ff:fula
      fi:finés
      fil:filipino
      fj:fixiano
      fo:feroés
      fon:fon
      fr:francés
      fr-CA:francés canadense
      fr-CH:francés suízo
      frc:francés cajun
      frr:frisón setentrional
      fur:friulano
      fy:frisón occidental
      ga:irlandés
      gaa:ga
      gag:gagauz
      gd:gaélico escocés
      gez:ge’ez
      gil:kiribatiano
      gl:galego
      gn:guaraní
      gor:gorontalo
      grc:grego antigo
      gsw:alemán suízo
      gu:guxarati
      guz:gusii
      gv:manx
      gwi:gwichʼin
      ha:hausa
      hai:haida
      haw:hawaiano
      hax:haida do sur
      he:hebreo
      hi:hindi
      hi-Latn:hindi (alfabeto latino)
      hi-Latn-alt-variant:hinglish (alfabeto latino)
      hil:hiligaynon
      hmn:hmong
      hr:croata
      hsb:alto sorbio
      ht:crioulo haitiano
      hu:húngaro
      hup:hupa
      hur:halkomelem
      hy:armenio
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonesio
      ie:occidental
      ig:igbo
      ii:yi sichuanés
      ikt:inuktitut canadense occidental
      ilo:ilocano
      inh:inguxo
      io:ido
      is:islandés
      it:italiano
      iu:inuktitut
      ja:xaponés
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jv:xavanés
      ka:xeorxiano
      kab:cabila
      kac:kachin
      kaj:jju
      kam:kamba
      kbd:cabardiano
      kcg:tyap
      kde:makonde
      kea:caboverdiano
      kfo:koro
      kg:kongo
      kgp:caingangue
      kha:khasi
      khq:koyra chiini
      ki:kikuyu
      kj:kuanyama
      kk:kazako
      kkj:kako
      kl:kalaallisut
      kln:kalenjin
      km:khmer
      kmb:kimbundu
      kn:kannará
      ko:coreano
      koi:komi permio
      kok:konkani
      kpe:kpelle
      kr:kanuri
      krc:carachaio-bálcara
      krl:carelio
      kru:kurukh
      ks:caxemirés
      ksb:shambala
      ksf:bafia
      ksh:kölsch
      ku:kurdo
      kum:kumyk
      kv:komi
      kw:córnico
      kwk:kwakiutl
      kxv:kuvi
      ky:kirguiz
      la:latín
      lad:ladino
      lag:langi
      lb:luxemburgués
      lez:lezguio
      lg:ganda
      li:limburgués
      lij:lígur
      lil:lillooet
      lkt:lakota
      lmo:lombardo
      ln:lingala
      lo:laosiano
      lou:crioulo de Luisiana
      loz:lozi
      lrc:luri setentrional
      lsm:saamia
      lt:lituano
      lu:luba-katanga
      lua:luba-lulua
      lun:lunda
      lus:mizo
      luy:luyia
      lv:letón
      mad:madurés
      mag:magahi
      mai:maithili
      mak:makasar
      mas:masai
      mdf:moksha
      men:mende
      mer:meru
      mfe:crioulo mauriciano
      mg:malgaxe
      mgh:makhuwa-meetto
      mgo:meta’
      mh:marshalés
      mi:maorí
      mic:micmac
      min:minangkabau
      mk:macedonio
      ml:malabar
      mn:mongol
      mni:manipuri
      moe:innu-aimun
      moh:mohawk
      mos:mossi
      mr:marathi
      ms:malaio
      mt:maltés
      mua:mundang
      mul:varias linguas
      mus:creek
      mwl:mirandés
      my:birmano
      myv:erzya
      mzn:mazandaraní
      na:nauruano
      nap:napolitano
      naq:nama
      nb:noruegués bokmål
      nd:ndebele setentrional
      nds:baixo alemán
      nds-NL:baixo saxón
      ne:nepalí
      new:newari
      ng:ndonga
      nia:nias
      niu:niueano
      nl:neerlandés
      nl-BE:flamengo
      nmg:kwasio
      nn:noruegués nynorsk
      nnh:ngiemboon
      no:noruegués
      nog:nogai
      nqo:n’ko
      nr:ndebele meridional
      nso:sesotho do norte
      nus:nuer
      nv:navajo
      ny:chewa
      nyn:nyankole
      oc:occitano
      ojb:ojibwa do noroeste
      ojc:ojibwa
      ojs:oji-cree
      ojw:ojibwa do oeste
      oka:okanagan
      om:oromo
      or:odiá
      os:ossetio
      pa:panxabí
      pag:pangasinan
      pam:pampanga
      pap:papiamento
      pau:palauano
      pcm:pidgin nixeriano
      pis:pijin
      pl:polaco
      pqm:malecite-passamaquoddy
      prg:prusiano
      ps:paxto
      pt:portugués
      pt-BR:portugués do Brasil
      pt-PT:portugués de Portugal
      qu:quechua
      quc:quiché
      raj:rajasthani
      rap:rapanui
      rar:rarotongano
      rhg:rohingya
      rm:romanche
      rn:rundi
      ro:romanés
      ro-MD:moldavo
      rof:rombo
      ru:ruso
      rup:aromanés
      rw:kiñaruanda
      rwk:rwa
      sa:sánscrito
      sad:sandawe
      sah:iacuto
      saq:samburu
      sat:santali
      sba:ngambay
      sbp:sangu
      sc:sardo
      scn:siciliano
      sco:escocés
      sd:sindhi
      sdh:kurdo meridional
      se:saami setentrional
      seh:sena
      ses:koyraboro senni
      sg:sango
      sh:serbocroata
      shi:tachelhit
      shn:shan
      si:cingalés
      sk:eslovaco
      sl:esloveno
      slh:lushootseed do sur
      sm:samoano
      sma:saami meridional
      smj:saami de Lule
      smn:saami de Inari
      sms:saami skolt
      sn:shona
      snk:soninke
      so:somalí
      sq:albanés
      sr:serbio
      srn:sranan tongo
      ss:suazi
      ssy:saho
      st:sesotho
      str:salish dos estreitos
      su:sundanés
      suk:sukuma
      sv:sueco
      sw:suahili
      sw-CD:suahili congolés
      swb:comoriano
      syr:siríaco
      szl:silesiano
      ta:támil
      tce:tutchone do sur
      te:telugu
      tem:temne
      teo:teso
      tet:tetun
      tg:taxico
      tgx:tagish
      th:tailandés
      tht:tahltan
      ti:tigriña
      tig:tigré
      tk:turkmeno
      tl:tagalo
      tlh:klingon
      tli:tlingit
      tn:tswana
      to:tongano
      tok:toki pona
      tpi:tok pisin
      tr:turco
      trv:taroko
      ts:tsonga
      tt:tártaro
      ttm:tutchone do norte
      tum:tumbuka
      tvl:tuvalés
      tw:twi
      twq:tasawaq
      ty:tahitiano
      tyv:tuvaniano
      tzm:tamazight de Marrocos central
      udm:udmurto
      ug:uigur
      uk:ucraíno
      umb:umbundu
      und:lingua descoñecida
      ur:urdú
      uz:uzbeko
      ve:venda
      vec:véneto
      vi:vietnamita
      vmw:makua
      vo:volapuk
      vun:vunjo
      wa:valón
      wae:walser
      wal:wolaytta
      war:waray-waray
      wbp:walrpiri
      wo:wólof
      wuu:chinés wu
      xal:calmuco
      xh:xhosa
      xnr:kangri
      xog:soga
      yav:yangben
      ybb:yemba
      yi:yiddish
      yo:ioruba
      yrl:nheengatu
      yue:cantonés
      yue-alt-menu:chinés cantonés
      za:zhuang
      zgh:tamazight marroquí estándar
      zh:chinés
      zh-alt-menu:chinés mandarín
      zh-Hans:chinés simplificado
      zh-Hans-alt-long:chinés mandarín simplificado
      zh-Hant:chinés tradicional
      zh-Hant-alt-long:chinés mandarín tradicional
      zu:zulú
      zun:zuni
      zxx:sen contido lingüístico
      zza:zazaki
      """.trimIndent() }

  val gn: String by lazy { """
      gn:avañe’ẽ
      """.trimIndent() }

  val gsw: String by lazy { """
      aa:Afar
      ab:Abchasisch
      ace:Aceh
      ach:Acholi
      ada:Adangme
      ady:Adygai
      ae:Avestisch
      af:Afrikaans
      afh:Afrihili
      ain:Ainu
      ak:Akan
      akk:Akkadisch
      ale:Aleutisch
      alt:Süüd-Altaisch
      am:Amharisch
      an:Aragonesisch
      ang:Altänglisch
      anp:Angika
      ar:Arabisch
      arc:Aramääisch
      arn:Araukanisch
      arp:Arapaho
      arw:Arawak
      as:Assamesisch
      ast:Aschturianisch
      av:Awarisch
      awa:Awadhi
      ay:Aymara
      az:Aserbaidschanisch
      az-alt-short:Aserbaidschanisch
      ba:Baschkirisch
      bal:Belutschisch
      ban:Balinesisch
      bas:Basaa
      be:Wiissrussisch
      bej:Bedauye
      bem:Bemba
      bg:Bulgaarisch
      bho:Bhodschpuri
      bi:Bislama
      bik:Bikolisch
      bin:Bini
      bla:Blackfoot-Schpraach
      bm:Bambara
      bn:Bengalisch
      bo:Tibeetisch
      br:Brötoonisch
      bra:Braj-Bhakha
      bs:Bosnisch
      bua:Burjatisch
      bug:Bugineesisch
      byn:Blin
      ca:Katalaanisch
      cad:Caddo
      car:Kariibisch
      cch:Atsam
      ce:Tschetscheenisch
      ceb:Cebuano
      ch:Chamorro
      chb:Tschibtscha
      chg:Tschagataisch
      chk:Trukesisch
      chm:Tscheremissisch
      chn:Chinook
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      co:Korsisch
      cop:Koptisch
      cr:Cree
      crh:Krimtatarisch
      cs:Tschechisch
      csb:Kaschubisch
      cu:Chileslawisch
      cv:Tschuwaschisch
      cy:Walisisch
      da:Tänisch
      dak:Takota
      dar:Targiinisch
      de:Tüütsch
      de-AT:Öschtriichischs Tüütsch
      de-CH:Schwiizer Hochtüütsch
      del:Delaware-Schpraach
      den:Slavey
      dgr:Togrib
      din:Tinka
      doi:Togri
      dsb:Nidersorbisch
      dua:Tuala
      dum:Mittelniderländisch
      dv:Malediivisch
      dyu:Tiula
      dz:Dschongkha
      ee:Ewe
      efi:Efikisch
      egy:Altägyptisch
      eka:Ekajuk
      el:Griechisch
      elx:Elamisch
      en:Änglisch
      en-AU:Auschtralischs Änglisch
      en-CA:Kanadischs Änglisch
      en-GB:Britischs Änglisch
      en-GB-alt-short:Britischs Änglisch
      en-US:Amerikanischs Änglisch
      en-US-alt-short:Amerikanischs Änglisch
      enm:Mittelänglisch
      eo:Eschperanto
      es:Schpanisch
      es-419:Latiinamerikanischs Schpanisch
      es-ES:Ibeerischs Schpanisch
      et:Eestnisch
      eu:Baskisch
      ewo:Ewondo
      fa:Persisch
      fan:Pangwe-Schpraach
      fat:Fanti-Schpraach
      ff:Ful
      fi:Finnisch
      fil:Filipino
      fj:Fidschianisch
      fo:Färöisch
      fon:Fon
      fr:Französisch
      fr-CA:Kanadischs Französisch
      fr-CH:Schwiizer Französisch
      frm:Mittelfranzösisch
      fro:Altfranzösisch
      frr:Nordfriesisch
      frs:Oschtfriesisch
      fur:Friulisch
      fy:Friesisch
      ga:Iirisch
      gaa:Ga
      gay:Gayo
      gba:Gbaya
      gd:Schottisch-Gäälisch
      gez:Geez
      gil:Gilbertesisch
      gl:Galizisch
      gmh:Mittelhochtüütsch
      gn:Guarani
      goh:Althochtüütsch
      gon:Gondi
      gor:Mongondou
      got:Gotisch
      grb:Grebo
      grc:Altgriechisch
      gsw:Schwiizertüütsch
      gu:Gujarati
      gv:Manx-Gäälisch
      gwi:Kutchinisch
      ha:Haussa
      hai:Haida
      haw:Hawaiianisch
      he:Hebräisch
      hi:Hindi
      hil:Hiligaynonisch
      hit:Hethitisch
      hmn:Miao
      ho:Hiri-Motu
      hr:Kroazisch
      hsb:Obersorbisch
      ht:Haitisch
      hu:Ungarisch
      hup:Hupa
      hy:Armenisch
      hz:Herero
      ia:Interlingua
      iba:Ibanisch
      id:Indonesisch
      ie:Interlingue
      ig:Igbo
      ii:Sezuanischs Yi
      ik:Inupiak
      ilo:Ilokano
      inh:Inguschisch
      io:Ido
      is:Iisländisch
      it:Italiänisch
      iu:Inukitut
      ja:Japanisch
      jbo:Lojbanisch
      jpr:Jüüdisch-Persisch
      jrb:Jüüdisch-Arabisch
      jv:Javanisch
      ka:Georgisch
      kaa:Karakalpakisch
      kab:Kabylisch
      kac:Kachin-Schpraach
      kaj:Jju
      kam:Kamba
      kaw:Kawi
      kbd:Kabardinisch
      kcg:Tyap
      kfo:Koro
      kg:Kongolesisch
      kha:Khasisch
      kho:Sakisch
      ki:Kikuyu-Schpraach
      kj:Kwanyama
      kk:Kasachisch
      kl:Gröönländisch
      km:Kambodschanisch
      kmb:Kimbundu-Schpraach
      kn:Kannada
      ko:Koreaanisch
      kok:Konkani
      kos:Kosraeanisch
      kpe:Kpelle-Schpraach
      kr:Kanuri-Schpraach
      krc:Karatschaiisch-Balkarisch
      krl:Karelisch
      kru:Oraon-Schpraach
      ks:Kaschmirisch
      ku:Kurdisch
      kum:Kumükisch
      kut:Kutenai-Schpraach
      kv:Komi-Schpraach
      kw:Kornisch
      ky:Kirgiisisch
      la:Latiin
      lad:Ladino
      lah:Lahndanisch
      lam:Lambanisch
      lb:Luxemburgisch
      lez:Lesgisch
      lg:Ganda-Schpraach
      li:Limburgisch
      ln:Lingala
      lo:Laozisch
      lol:Mongo
      loz:Rotse-Schpraach
      lt:Litauisch
      lu:Luba
      lua:Luba-Lulua
      lui:Luiseno-Schpraach
      lun:Lunda-Schpraach
      luo:Luo-Schpraach
      lus:Lushai-Schpraach
      lv:Lettisch
      mad:Maduresisch
      mag:Khotta
      mai:Maithili
      mak:Makassarisch
      man:Manding-Schpraach
      mas:Massai-Schpraach
      mdf:Mokschamordwinisch
      mdr:Mandaresisch
      men:Mende-Schpraach
      mg:Madagassisch
      mga:Mittelirisch
      mh:Marschallesisch
      mi:Maori
      mic:Micmac-Schpraach
      min:Minangkabau-Schpraach
      mk:Mazedonisch
      ml:Malayalam
      mn:Mongolisch
      mnc:Mandschurisch
      mni:Meithei-Schpraach
      moh:Mohawk-Schpraach
      mos:Mossi-Schpraach
      mr:Marathi
      ms:Malaiisch
      mt:Maltesisch
      mul:Mehrschpraachig
      mus:Muskogee-Schpraach
      mwl:Mirandesisch
      mwr:Marwarisch
      my:Birmanisch
      myv:Erzya
      na:Nauruisch
      nap:Neapolitanisch
      nb:Norwegisch Bokmål
      nd:Nord-Ndebele-Schpraach
      nds:Nidertüütsch
      ne:Nepalesisch
      new:Newarisch
      ng:Ndonga
      nia:Nias-Schpraach
      niu:Niue-Schpraach
      nl:Niderländisch
      nl-BE:Fläämisch
      nn:Norwegisch Nynorsk
      no:Norwegisch
      nog:Nogaisch
      non:Altnordisch
      nqo:N’Ko
      nr:Süüd-Ndebele-Schpraach
      nso:Nord-Sotho-Schpraach
      nv:Navajo-Schpraach
      nwc:Alt-Newari
      ny:Chewa-Schpraach
      nym:Nyamwezi-Schpraach
      nyn:Nyankole
      nyo:Nyoro
      nzi:Nzima
      oc:Okzitanisch
      oj:Ojibwa-Schpraach
      om:Oromo
      or:Orija
      os:Ossezisch
      osa:Osage-Schpraach
      ota:Osmanisch
      pa:Pandschabisch
      pag:Pangasinanisch
      pal:Mittelpersisch
      pam:Pampanggan-Schpraach
      pap:Papiamento
      pau:Palau
      peo:Altpersisch
      phn:Phönikisch
      pi:Pali
      pl:Polnisch
      pon:Ponapeanisch
      pro:Altprovenzalisch
      ps:Paschtu
      pt:Portugiisisch
      pt-BR:Brasilianischs Portugiisisch
      pt-PT:Iberischs Portugiisisch
      qu:Quechua
      raj:Rajasthani
      rap:Oschterinsel-Schpraach
      rar:Rarotonganisch
      rm:Rätoromanisch
      rn:Rundi-Schpraach
      ro:Rumänisch
      ro-MD:Moldawisch
      rom:Zigüünerschpraach
      ru:Russisch
      rup:Aromunisch
      rw:Ruandisch
      sa:Sanschkrit
      sad:Sandawe-Schpraach
      sah:Jakutisch
      sam:Samaritanisch
      sas:Sasak
      sat:Santali
      sc:Sardisch
      scn:Sizilianisch
      sco:Schottisch
      sd:Sindhi
      se:Nord-Samisch
      sel:Selkupisch
      sg:Sango
      sga:Altirisch
      sh:Serbo-Kroatisch
      shn:Schan-Schpraach
      si:Singhalesisch
      sid:Sidamo
      sk:Slowakisch
      sl:Slowenisch
      sm:Samoanisch
      sma:Süüd-Samisch
      smj:Lule-Samisch
      smn:Inari-Samisch
      sms:Skolt-Samisch
      sn:Schhona
      snk:Soninke-Schpraach
      so:Somali
      sog:Sogdisch
      sq:Albanisch
      sr:Serbisch
      srn:Srananisch
      srr:Serer-Schpraach
      ss:Swazi
      st:Süüd-Sotho-Schpraach
      su:Sundanesisch
      suk:Sukuma-Schpraach
      sus:Susu
      sux:Sumerisch
      sv:Schwedisch
      sw:Suaheli
      syc:Altsyrisch
      syr:Syrisch
      ta:Tamilisch
      te:Telugu
      tem:Temne
      ter:Tereno-Schpraach
      tet:Tetum-Schpraach
      tg:Tadschikisch
      th:Thailändisch
      ti:Tigrinja
      tig:Tigre
      tiv:Tiv-Schpraach
      tk:Turkmenisch
      tkl:Tokelauanisch
      tl:Tagalog
      tlh:Klingonisch
      tli:Tlingit-Schpraach
      tmh:Tamaseq
      tn:Tswana-Schpraach
      to:Tongaisch
      tog:Tsonga-Schpraach
      tpi:Neumelanesisch
      tr:Türkisch
      ts:Tsonga
      tsi:Tsimshian-Schpraach
      tt:Tatarisch
      tum:Tumbuka-Schpraach
      tvl:Elliceanisch
      tw:Twi
      ty:Tahitisch
      tyv:Tuwinisch
      udm:Udmurtisch
      ug:Uigurisch
      uga:Ugaritisch
      uk:Ukrainisch
      umb:Mbundu-Schpraach
      und:Unbeschtimmti Schpraach
      ur:Urdu
      uz:Usbekisch
      vai:Vai-Schpraach
      ve:Venda-Schpraach
      vi:Vietnamesisch
      vo:Volapük
      vot:Wotisch
      wa:Wallonisch
      wal:Walamo-Schpraach
      war:Waray
      was:Washo-Schpraach
      wo:Wolof
      xal:Kalmückisch
      xh:Xhosa
      yao:Yao-Schpraach
      yap:Yapesisch
      yi:Jiddisch
      yo:Yoruba
      za:Zhuang
      zap:Zapotekisch
      zbl:Bliss-Symbool
      zen:Zenaga
      zh:Chineesisch
      zh-alt-menu:Chineesisch
      zh-Hans:Veräifachts Chineesisch
      zh-Hans-alt-long:Veräifachts Chineesisch
      zh-Hant:Tradizionells Chineesisch
      zh-Hant-alt-long:Tradizionells Chineesisch
      zu:Zulu
      zun:Zuni-Schpraach
      zxx:Kän schpraachliche Inhalt
      zza:Zaza
      """.trimIndent() }

  val gsw_FR: String? = null

  val gsw_LI: String? = null

  val gu: String by lazy { """
      aa:અફાર
      ab:અબખાજિયન
      ace:અચીની
      ach:એકોલી
      ada:અદાંગ્મી
      ady:અદિઘે
      ae:અવેસ્તન
      af:આફ્રિકન્સ
      afh:અફ્રિહિલી
      agq:અઘેમ
      ain:ઐનુ
      ak:અકાન
      akk:અક્કાદીયાન
      ale:અલેઉત
      alt:દક્ષિણ અલ્તાઇ
      am:એમ્હારિક
      an:અર્ગોનીઝ
      ang:જુની અંગ્રેજી
      ann:ઓબોલો
      anp:અંગીકા
      ar:અરબી
      ar-001:મોડર્ન સ્ટાન્ડર્ડ અરબી
      arc:એરમૈક
      arn:મેપુચે
      arp:અરાપાહો
      arq:આલ્જેરિયન અરબી
      ars:નજદી અરેબિક
      arw:અરાવક
      ary:મોરોક્કન અરબી
      arz:ઈજિપ્શિયન અરબી
      as:આસામી
      asa:અસુ
      ast:અસ્તુરિયન
      atj:એટીકામેકવ
      av:અવેરિક
      awa:અવધી
      ay:આયમારા
      az:અઝરબૈજાની
      az-alt-short:અઝેરી
      ba:બશ્કીર
      bal:બલૂચી
      ban:બાલિનીસ
      bas:બસા
      bax:બામન
      be:બેલારુશિયન
      bej:બેજા
      bem:બેમ્બા
      bez:બેના
      bg:બલ્ગેરિયન
      bgc:હરિયાણવી
      bgn:પશ્ચિમી બાલોચી
      bho:ભોજપુરી
      bi:બિસ્લામા
      bik:બિકોલ
      bin:બિની
      bla:સિક્સિકા
      blo:અની
      bm:બામ્બારા
      bn:બાંગ્લા
      bo:તિબેટીયન
      bpy:બિષ્નુપ્રિયા
      br:બ્રેટોન
      bra:વ્રજ
      brh:બ્રાહુઈ
      brx:બોડો
      bs:બોસ્નિયન
      bua:બુરિયાત
      bug:બુગિનીસ
      byn:બ્લિન
      ca:કતલાન
      cad:કડ્ડો
      car:કરિબ
      cay:કેયુગા
      cch:અત્સમ
      ccp:ચકમા
      ce:ચેચન
      ceb:સિબુઆનો
      cgg:ચિગા
      ch:કેમોરો
      chb:ચિબ્ચા
      chg:છગાતાઇ
      chk:ચૂકીસ
      chm:મારી
      chn:ચિનૂક જાર્ગન
      cho:ચોક્તૌ
      chp:શિપેવ્યાન
      chr:શેરોકી
      chy:શેયેન્ન
      ckb:સેન્ટ્રલ કુર્દિશ
      ckb-alt-menu:કુર્દિશ, સેન્ટ્રલ
      ckb-alt-variant:કુર્દિશ, સોરાની
      clc:ચિલકોટિન
      co:કોર્સિકન
      cop:કોપ્ટિક
      cr:ક્રી
      crg:મિચિફ
      crh:ક્રિમિયન તુર્કી
      crj:દક્ષિણ પૂર્વ ક્રી
      crk:પ્લેઇન્સ ક્રી
      crl:ઉત્તરી પૂર્વ ક્રી
      crm:મૂઝ ક્રી
      crr:કેરોલિના એલ્ગોનક્વિઅન
      crs:સેસેલ્વા ક્રેઓલે ફ્રેન્ચ
      cs:ચેક
      csb:કાશુબિયન
      csw:સ્વેમ્પી ક્રી
      cu:ચર્ચ સ્લાવિક
      cv:ચૂવાશ
      cy:વેલ્શ
      da:ડેનિશ
      dak:દાકોતા
      dar:દાર્ગવા
      dav:તૈતા
      de:જર્મન
      de-AT:ઓસ્ટ્રિઅન જર્મન
      de-CH:સ્વિસ હાય જર્મન
      del:દેલવેર
      den:સ્લેવ
      dgr:ડોગ્રિબ
      din:દિન્કા
      dje:ઝર્મા
      doi:ડોગ્રી
      dsb:લોઅર સોર્બિયન
      dua:દુઆલા
      dum:મધ્ય ડચ
      dv:દિવેહી
      dyo:જોલા-ફોન્યી
      dyu:ડ્યુલા
      dz:ડ્ઝોંગ્ખા
      dzg:દાઝાગા
      ebu:ઍમ્બુ
      ee:ઈવ
      efi:એફિક
      egy:પ્રાચીન ઇજીપ્શિયન
      eka:એકાજુક
      el:ગ્રીક
      elx:એલામાઇટ
      en:અંગ્રેજી
      en-AU:ઓસ્ટ્રેલિયન અંગ્રેજી
      en-CA:કેનેડિયન અંગ્રેજી
      en-GB:બ્રિટિશ અંગ્રેજી
      en-GB-alt-short:યુ.કે. અંગ્રેજી
      en-US:અમેરિકન અંગ્રેજી
      en-US-alt-short:અમેરિકન અંગ્રેજી
      enm:મિડિલ અંગ્રેજી
      eo:એસ્પેરાન્ટો
      es:સ્પેનિશ
      es-419:લેટિન અમેરિકન સ્પેનિશ
      es-ES:યુરોપિયન સ્પેનિશ
      es-MX:મેક્સિકન સ્પેનિશ
      et:એસ્ટોનિયન
      eu:બાસ્ક
      ewo:ઇવોન્ડો
      fa:ફારસી
      fa-AF:ડારી
      fan:ફેંગ
      fat:ફન્ટી
      ff:ફુલા
      fi:ફિનિશ
      fil:ફિલિપિનો
      fj:ફીજીયન
      fo:ફોરિસ્ત
      fon:ફોન
      fr:ફ્રેન્ચ
      fr-CH:સ્વિસ ફ્રેંચ
      frc:કાજૂન ફ્રેન્ચ
      frm:મિડિલ ફ્રેંચ
      fro:જૂની ફ્રેંચ
      frr:ઉત્તરી ફ્રિશિયન
      frs:પૂર્વ ફ્રિશિયન
      fur:ફ્રિયુલિયાન
      fy:પશ્ચિમિ ફ્રિશિયન
      ga:આઇરિશ
      gaa:ગા
      gag:ગાગાઝ
      gan:gan
      gay:ગાયો
      gba:બાયા
      gbz:ઝોરોસ્ટ્રિઅન દારી
      gd:સ્કોટીસ ગેલિક
      gez:ગીઝ
      gil:જિલ્બરટીઝ
      gl:ગેલિશિયન
      gmh:મધ્ય હાઇ જર્મન
      gn:ગુઆરાની
      goh:જૂની હાઇ જર્મન
      gon:ગોંડી
      gor:ગોરોન્તાલો
      got:ગોથિક
      grb:ગ્રેબો
      grc:પ્રાચીન ગ્રીક
      gsw:સ્વિસ જર્મન
      gu:ગુજરાતી
      guz:ગુસી
      gv:માંક્સ
      gwi:ગ્વિચ’ઇન
      ha:હૌસા
      hai:હૈડા
      haw:હવાઇયન
      hax:દક્ષિણ હૈડા
      he:હીબ્રુ
      hi:હિન્દી
      hi-Latn-alt-variant:હિંગ્લિશ
      hif:ફીજી હિંદી
      hil:હિલિગેનોન
      hit:હિટ્ટિતે
      hmn:હમોંગ
      ho:હિરી મોટૂ
      hr:ક્રોએશિયન
      hsb:અપર સોર્બિયન
      ht:હૈતિઅન ક્રેઓલે
      hu:હંગેરિયન
      hup:હૂપા
      hur:હેલ્કોમેલેમ
      hy:આર્મેનિયન
      hz:હેરેરો
      ia:ઇંટરલિંગુઆ
      iba:ઇબાન
      ibb:ઇબિબિઓ
      id:ઇન્ડોનેશિયન
      ie:ઇંટરલિંગ
      ig:ઇગ્બો
      ii:સિચુઆન યી
      ik:ઇનુપિયાક
      ikt:પશ્ચિમ કેનેડિયન ઇનુકિટ્યુટ
      ilo:ઇલોકો
      inh:ઇંગુશ
      io:ઈડો
      is:આઇસલેન્ડિક
      it:ઇટાલિયન
      iu:ઇનુકિટૂટ
      ja:જાપાનીઝ
      jbo:લોજ્બાન
      jgo:નગોમ્બા
      jmc:મકામે
      jpr:જુદેઓ-પર્શિયન
      jrb:જુદેઓ-અરબી
      jv:જાવાનીસ
      ka:જ્યોર્જિયન
      kaa:કારા-કલ્પક
      kab:કબાઇલ
      kac:કાચિન
      kaj:જ્જુ
      kam:કમ્બા
      kaw:કાવી
      kbd:કબાર્ડિયન
      kcg:ત્યાપ
      kde:મકોન્ડે
      kea:કાબુવર્ડિઆનુ
      kfo:કોરો
      kg:કોંગો
      kgp:કૈંગાંગ
      kha:ખાસી
      kho:ખોતાનીસ
      khq:કોયરા ચિનિ
      ki:કિકુયૂ
      kj:ક્વાન્યામા
      kk:કઝાખ
      kkj:કાકો
      kl:કલાલ્લિસુત
      kln:કલેજિન
      km:ખ્મેર
      kmb:કિમ્બન્દુ
      kn:કન્નડ
      ko:કોરિયન
      koi:કોમી-પર્મ્યાક
      kok:કોંકણી
      kos:કોસરિયન
      kpe:ક્પેલ્લે
      kr:કનુરી
      krc:કરાચય-બલ્કાર
      krl:કરેલિયન
      kru:કુરૂખ
      ks:કાશ્મીરી
      ksb:શમ્બાલા
      ksf:બફિયા
      ksh:કોલોગ્નિયન
      ku:કુર્દિશ
      kum:કુમીક
      kut:કુતેનાઇ
      kv:કોમી
      kw:કોર્નિશ
      kwk:ક્વેકવાલા
      kxv:કૂવી
      ky:કિર્ગીઝ
      la:લેટિન
      lad:લાદીનો
      lag:લંગી
      lah:લાહન્ડા
      lam:લામ્બા
      lb:લક્ઝેમબર્ગિશ
      lez:લેઝધીયન
      lfn:લિંગ્વા ફેન્કા નોવા
      lg:ગાંડા
      li:લિંબૂર્ગિશ
      lij:લિગુરીઅન
      lil:લિલુએટ
      lkt:લાકોટા
      lmo:લોંબાર્ડ
      ln:લિંગાલા
      lo:લાઓ
      lol:મોંગો
      lou:લ્યુઇસિયાના ક્રેઓલ
      loz:લોઝી
      lrc:ઉત્તરી લુરી
      lsm:સામિયા
      lt:લિથુઆનિયન
      lu:લૂબા-કટાંગા
      lua:લૂબા-લુલુઆ
      lui:લુઇસેનો
      lun:લુન્ડા
      luo:લ્યુઓ
      lus:મિઝો
      luy:લુઈયા
      lv:લાતવિયન
      mad:માદુરીસ
      mag:મગહી
      mai:મૈથિલી
      mak:મકાસર
      man:મન્ડિન્ગો
      mas:મસાઇ
      mdf:મોક્ષ
      mdr:મંદાર
      men:મેન્ડે
      mer:મેરુ
      mfe:મોરીસ્યેન
      mg:મલાગસી
      mga:મધ્ય આઈરિશ
      mgh:માખુવા-મીટ્ટુ
      mgo:મેતા
      mh:માર્શલીઝ
      mi:માઓરી
      mic:મિકમેક
      min:મિનાંગ્કાબાઉ
      mk:મેસેડોનિયન
      ml:મલયાલમ
      mn:મોંગોલિયન
      mnc:માન્ચુ
      mni:મણિપુરી
      moe:ઇન્નુ-આયમુન
      moh:મોહૌક
      mos:મોસ્સી
      mr:મરાઠી
      mrj:પશ્ચિમી મારી
      ms:મલય
      mt:માલ્ટિઝ
      mua:મુનડાન્ગ
      mul:બહુવિધ ભાષાઓ
      mus:ક્રિક
      mwl:મિરાંડી
      mwr:મારવાડી
      my:બર્મીઝ
      myv:એર્ઝયા
      mzn:મઝાન્દેરાની
      na:નાઉરૂ
      nap:નેપોલિટાન
      naq:નમા
      nb:નોર્વેજિયન બોકમાલ
      nd:ઉત્તર દેબેલ
      nds:લો જર્મન
      nds-NL:લો સેક્સોન
      ne:નેપાળી
      new:નેવારી
      ng:ડોન્ગા
      nia:નિયાસ
      niu:નિયુઆન
      nl:ડચ
      nl-BE:ફ્લેમિશ
      nmg:ક્વાસિઓ
      nn:નોર્વેજિયન નાયનૉર્સ્ક
      nnh:નીએમબુન
      no:નૉર્વેજીયન
      nog:નોગાઇ
      non:જૂની નોર્સ
      nqo:એન’કો
      nr:દક્ષિણ દેબેલ
      nso:ઉત્તરી સોથો
      nus:નુએર
      nv:નાવાજો
      nwc:પરંપરાગત નેવારી
      ny:ન્યાન્જા
      nym:ન્યામવેઝી
      nyn:ન્યાનકોલ
      nyo:ન્યોરો
      nzi:ન્ઝિમા
      oc:ઓક્સિટન
      oj:ઓજિબ્વા
      ojb:ઉત્તરપશ્ચિમી ઓઝિબવે
      ojc:સેન્ટ્રલ ઓઝિબ્વા
      ojs:ઓજી-ક્રી
      ojw:પશ્ચિમી ઓઝિબ્વા
      oka:ઓકાનાગન
      om:ઓરોમો
      or:ઉડિયા
      os:ઓસ્સેટિક
      osa:ઓસેજ
      ota:ઓટોમાન તુર્કિશ
      pa:પંજાબી
      pag:પંગાસીનાન
      pal:પહલવી
      pam:પમ્પાન્ગા
      pap:પાપિયામેન્ટો
      pau:પલાઉઆન
      pcm:નાઇજેરિયન પીજીન
      peo:જૂની ફારસી
      phn:ફોનિશિયન
      pi:પાલી
      pis:પિજિન
      pl:પોલીશ
      pon:પોહપિએન
      pqm:મલિસીટ-પાસમાક્વોડ્ડી
      prg:પ્રુસ્સીયન
      pro:જુની પ્રોવેન્સલ
      ps:પશ્તો
      ps-alt-variant:પુશ્તો
      pt:પોર્ટુગીઝ
      pt-BR:બ્રાઝિલીયન પોર્ટુગીઝ
      pt-PT:યુરોપિયન પોર્ટુગીઝ
      qu:ક્વેચુઆ
      quc:કિચે
      raj:રાજસ્થાની
      rap:રાપાનુઇ
      rar:રારોટોંગન
      rhg:રોહિંગ્યા
      rm:રોમાન્શ
      rn:રૂન્દી
      ro:રોમાનિયન
      ro-MD:મોલડાવિયન
      rof:રોમ્બો
      rom:રોમાની
      ru:રશિયન
      rup:અરોમેનિયન
      rw:કિન્યારવાન્ડા
      rwk:રવા
      sa:સંસ્કૃત
      sad:સોંડવે
      sah:સખા
      sam:સામરિટાન અરેમિક
      saq:સમ્બુરુ
      sas:સાસાક
      sat:સંતાલી
      sba:ન્ગામ્બેય
      sbp:સાંગુ
      sc:સાર્દિનિયન
      scn:સિસિલિયાન
      sco:સ્કોટ્સ
      sd:સિંધી
      sdh:સર્ઘન કુર્દીશ
      se:ઉત્તરી સામી
      seh:સેના
      sel:સેલ્કપ
      ses:કોયરાબોરો સેન્ની
      sg:સાંગો
      sga:જૂની આયરિશ
      sh:સર્બો-ક્રોએશિયન
      shi:તેશીલહિટ
      shn:શેન
      si:સિંહાલી
      sid:સિદામો
      sk:સ્લોવૅક
      sl:સ્લોવેનિયન
      slh:દક્ષિણ લુશુટસીડ
      sm:સામોન
      sma:દક્ષિણી સામી
      smj:લુલે સામી
      smn:ઇનારી સામી
      sms:સ્કોલ્ટ સામી
      sn:શોના
      snk:સોનિન્કે
      so:સોમાલી
      sog:સોગ્ડિએન
      sq:અલ્બેનિયન
      sr:સર્બિયન
      srn:સ્રાનન ટોન્ગો
      srr:સેરેર
      ss:સ્વાતી
      ssy:સાહો
      st:દક્ષિણ સોથો
      str:સ્ટ્રેટ્સ સેલિશ
      su:સંડેનીઝ
      suk:સુકુમા
      sus:સુસુ
      sux:સુમેરિયન
      sv:સ્વીડિશ
      sw:સ્વાહિલી
      sw-CD:કોંગો સ્વાહિલી
      swb:કોમોરિયન
      syc:પરંપરાગત સિરિએક
      syr:સિરિએક
      szl:સિલેસ્યિન
      ta:તમિલ
      tce:દક્ષિણ ટુચૉન
      tcy:તુલુ
      te:તેલુગુ
      tem:ટિમ્ને
      teo:તેસો
      ter:તેરેનો
      tet:તેતુમ
      tg:તાજીક
      tgx:ટાગિશ
      th:થાઈ
      tht:તહલતાન
      ti:ટાઇગ્રિનિયા
      tig:ટાઇગ્રે
      tiv:તિવ
      tk:તુર્કમેન
      tkl:તોકેલાઉ
      tl:ટાગાલોગ
      tlh:ક્લિન્ગોન
      tli:ટ્લિંગિટ
      tmh:તામાશેખ
      tn:ત્સ્વાના
      to:ટોંગાન
      tog:ન્યાસા ટોન્ગા
      tok:ટોકી પોના
      tpi:ટોક પિસિન
      tr:ટર્કિશ
      trv:ટારોકો
      ts:સોંગા
      tsi:સિમ્શિયન
      tt:તતાર
      ttm:ઉત્તરી ટુચૉન
      ttt:મુસ્લિમ તાટ
      tum:તુમ્બુકા
      tvl:તુવાલુ
      tw:ટ્વાઇ
      twq:તસાવાક
      ty:તાહિતિયન
      tyv:ટુવીનિયન
      tzm:સેન્ટ્રલ એટલાસ તામાઝિટ
      udm:ઉદમુર્ત
      ug:ઉઇગુર
      uga:યુગેરિટિક
      uk:યુક્રેનિયન
      umb:ઉમ્બુન્ડૂ
      und:અજ્ઞાત ભાષા
      ur:ઉર્દૂ
      uz:ઉઝ્બેક
      vai:વાઇ
      ve:વેન્દા
      vec:વેનેશ્યિન
      vi:વિયેતનામીસ
      vmw:મખુવા
      vo:વોલાપુક
      vot:વોટિક
      vun:વુન્જો
      wa:વાલૂન
      wae:વેલ્સેર
      wal:વોલાયટ્ટા
      war:વારેય
      was:વાશો
      wbp:વાર્લ્પીરી
      wo:વોલોફ
      wuu:વુ ચાઈનીઝ
      xal:કાલ્મિક
      xh:ખોસા
      xnr:કંગરી
      xog:સોગા
      yao:યાઓ
      yap:યાપીસ
      yav:યાન્ગબેન
      ybb:યેમ્બા
      yi:યિદ્દિશ
      yo:યોરૂબા
      yrl:નહેનગાતુ
      yue:કેંટોનીઝ
      yue-alt-menu:ચાઇનીઝ, કેન્ટોનીઝ
      za:ઝુઆગ
      zap:ઝેપોટેક
      zbl:બ્લિસિમ્બોલ્સ
      zen:ઝેનાગા
      zgh:માનક મોરોક્કન તામાઝિટ
      zh:ચાઇનીઝ
      zh-alt-menu:ચાઇનીઝ, મેન્ડેરિન
      zh-Hans:સરળીકૃત ચાઇનીઝ
      zh-Hans-alt-long:સરળીકૃત મેન્ડેરિન ચાઇનીઝ
      zh-Hant:પારંપરિક ચાઇનીઝ
      zh-Hant-alt-long:પરંપરાગત મેન્ડેરિન ચાઇનીઝ
      zu:ઝુલુ
      zun:ઝૂની
      zxx:કોઇ ભાષાશાસ્ત્રીય સામગ્રી નથી
      zza:ઝાઝા
      """.trimIndent() }

  val guz: String by lazy { """
      ak:Kiakan
      am:Kiamhari
      ar:Kiarabu
      be:Kibelarusi
      bg:Kibulgaria
      bn:Kibangla
      cs:Kichecki
      de:Kijerumani
      el:Kigiriki
      en:Kingereza
      es:Kihispania
      fa:Kiajemi
      fr:Kifaransa
      guz:Ekegusii
      ha:Kihausa
      hi:Kihindi
      hu:Kihungari
      id:Kiindonesia
      ig:Kiigbo
      it:Kiitaliano
      ja:Kijapani
      jv:Kijava
      km:Kikambodia
      ko:Kikorea
      ms:Kimalesia
      my:Kiburma
      ne:Kinepali
      nl:Kiholanzi
      pa:Kipunjabi
      pl:Kipolandi
      pt:Kireno
      ro:Kiromania
      ru:Kirusi
      rw:Kinyarwanda
      so:Kisomali
      sv:Kiswidi
      ta:Kitamil
      th:Kitailandi
      tr:Kituruki
      uk:Kiukrania
      ur:Kiurdu
      vi:Kivietinamu
      yo:Kiyoruba
      zh:Kichina
      zh-alt-menu:Kichina
      zu:Kizulu
      """.trimIndent() }

  val gv: String by lazy { """
      gv:Gaelg
      """.trimIndent() }

  val ha: String by lazy { """
      ab:Abkhazian
      ace:Achinese
      ada:Adangme
      ady:Adyghe
      af:Afirkanci
      agq:Aghem
      ain:Ainu
      ak:Akan
      ale:Aleut
      alt:Altai na Kudanci
      am:Amharik
      an:Aragonesanci
      ann:Obolo
      anp:Angika
      ar:Larabci
      ar-001:Larabci Asali Na Zamani
      arn:Mapuche
      arp:Arapaho
      ars:Larabcin Najdi
      as:Asamisanci
      asa:Asu
      ast:Asturia
      atj:Atikamekw
      av:Avaric
      awa:Awadhi
      ay:Aymaranci
      az:Azerbaijanci
      az-alt-short:Azeri
      ba:Bashkir
      ban:Balenesanci
      bas:Basaa
      be:Belarusanci
      bem:Bemba
      bez:Bena
      bg:Bulgariyanci
      bgc:Haryanvi
      bho:Bhojpuri
      bi:Bislama
      bin:Bini
      bla:Siksiká
      blo:Anii
      bm:Bambara
      bn:Bengali
      bo:Tibetan
      br:Buretananci
      brx:Bodo
      bs:Bosniyanci
      bug:Buginesanci
      byn:Blin
      ca:Kataloniyanci
      cay:Cayuga
      ccp:Chakma
      ce:Chechen
      ceb:Cebuano
      cgg:Chiga
      ch:Chamorro
      chk:Chuukese
      chm:Mari
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      ckb:Kurdawa ta Tsakiya
      ckb-alt-menu:Kurdawa ta Tsakiya
      ckb-alt-variant:Kurdawa ta Tsakiya
      clc:Chilcotin
      co:Corsican
      crg:Michif
      crj:Cree na Kusu-Maso-Gabas
      crk:Plains Cree
      crl:Cree na Arewacin-Gabas
      crm:Moose Cree
      crr:Carolina Algonquian
      cs:Cek
      csw:Swampy Cree
      cu:Church Slavic
      cv:Chuvash
      cy:Welsh
      da:Danish
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:Jamusanci
      de-AT:Jamusanci Ostiriya
      de-CH:Jamusanci Suwizalan
      dgr:Dogrib
      dje:Zarma
      doi:Harshen Dogri
      dsb:Sorbianci ta kasa
      dua:Duala
      dv:Divehi
      dyo:Jola-Fonyi
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      eka:Ekajuk
      el:Girkanci
      en:Turanci
      en-AU:Turanci Ostareliya
      en-GB-alt-short:Turanci (Biritaniya)
      en-US-alt-short:Turanci (Amurka)
      eo:Esperanto
      es:Sifaniyanci
      es-419:Sifaniyancin Latin Amirka
      es-ES:Sifaniyanci Turai
      es-MX:Sifaniyanci Mesiko
      et:Istoniyanci
      eu:Basque
      ewo:Ewondo
      fa:Farisanci
      fa-AF:Farisanci na Afaganistan
      ff:Fula
      fi:Yaren mutanen Finland
      fil:Dan Filifin
      fj:Fijiyanci
      fo:Faroese
      fon:Fon
      fr:Faransanci
      fr-CA:Farasanci Kanada
      fr-CH:Farasanci Suwizalan
      frc:Faransancin Cajun
      frr:Firisiyanci na Arewaci
      fur:Friulian
      fy:Frisian ta Yamma
      ga:Dan Irish
      gaa:Ga
      gd:Kʼabilan Scots Gaelic
      gez:Geez
      gil:Gilbertese
      gl:Bagalike
      gn:Guwaraniyanci
      gor:Gorontalo
      gsw:Jamusanci Swiss
      gu:Gujarati
      guz:Gusii
      gv:Manx
      gwi:Gwichʼin
      ha:Hausa
      hai:Haida
      haw:Hawaiianci
      hax:Haida na Kudanci
      he:Ibrananci
      hi:Harshen Hindi
      hi-Latn-alt-variant:Harshen Hindi (Latin)
      hil:Hiligaynon
      hmn:Hmong
      hr:Kuroshiyan
      hsb:Sorbianci ta Sama
      ht:Haitian Creole
      hu:Harshen Hungari
      hup:Hupa
      hur:Halkomelem
      hy:Armeniyanci
      hz:Herero
      ia:Yare Tsakanin Kasashe
      iba:Iban
      ibb:Ibibio
      id:Harshen Indunusiya
      ie:Intagulanci
      ig:Igbo
      ii:Sichuan Yi
      ikt:Inuktitut na Yammacin Kanada
      ilo:Ikolo
      inh:Ingush
      io:Ido
      is:Yaren mutanen Iceland
      it:Italiyanci
      iu:Inuktitut
      ja:Japananci
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jv:Javananci
      ka:Jojiyanci
      kab:Kabyle
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kbd:Karbadiyanci
      kcg:Tyap
      kde:Makonde
      kea:Kabuverdianu
      kfo:Koro
      kgp:Kaingang
      kha:Khasi
      khq:Koyra Chiini
      ki:Kikuyu
      kj:Kuanyama
      kk:Kazakh
      kkj:Kako
      kl:Kalaallisut
      kln:Kalenjin
      km:Harshen Kimar
      kmb:Kimbundu
      kn:Kannada
      ko:Harshen Koriya
      kok:Konkananci
      kpe:Kpelle
      kr:Kanuri
      krc:Karachay-Balkar
      krl:Kareliyanci
      kru:Kurukh
      ks:Kashmiri
      ksb:Shambala
      ksf:Bafia
      ksh:Colognian
      ku:Kurdanci
      kum:Kumyk
      kv:Komi
      kw:Cornish
      kwk:Kwakʼwala
      kxv:Kavi
      ky:Kirgizanci
      la:Dan Kabilar Latin
      lad:Ladino
      lag:Langi
      lb:Luxembourgish
      lez:Lezghiniyanci
      lg:Ganda
      li:Limburgish
      lij:Liguriyanci
      lil:Lillooet
      lkt:Lakota
      lmo:Lombard
      ln:Lingala
      lo:Lao
      lou:Creole na Louisiana
      loz:Lozi
      lrc:Arewacin Luri
      lsm:Saamiyanci
      lt:Lituweniyanci
      lu:Luba-Katanga
      lua:Luba-Lulua
      lun:Lunda
      luo:Luo
      lus:Mizo
      luy:Luyia
      lv:Latbiyanci
      mad:Madurese
      mag:Magahi
      mai:Maithili
      mak:Makasar
      mas:Harshen Masai
      mdf:Moksha
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagasi
      mgh:Makhuwa-Meetto
      mgo:Metaʼ
      mh:Marshallese
      mi:Maori
      mic:Mi'kmaq
      min:Minangkabau
      mk:Dan Masedoniya
      ml:Malayalamci
      mn:Mongoliyanci
      mni:Manipuri
      moe:Innu-aimun
      moh:Mohawk
      mos:Mossi
      mr:Maratinci
      ms:Harshen Malay
      mt:Harshen Maltis
      mua:Mundang
      mul:Harsuna masu yawa
      mus:Muscogee
      mwl:Mirandese
      my:Burmanci
      myv:Erzya
      mzn:Mazanderani
      na:Nauru
      nap:Neapolitan
      naq:Nama
      nb:Norwegian Bokmål
      nd:North Ndebele
      nds:Low German
      ne:Nepali
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niuean
      nl:Holanci
      nmg:Kwasio
      nn:Norwegian Nynorsk
      nnh:Ngiemboon
      no:Harhsen Norway
      nog:Harshen Nogai
      nqo:N’Ko
      nr:Ndebele na Kudu
      nso:Sotho na Arewaci
      nus:Nuer
      nv:Navajo
      ny:Nyanja
      nyn:Nyankole
      oc:Ositanci
      ojb:Ojibwa na Arewa-Maso-Yamma
      ojc:Ojibwa na Tsakiya
      ojs:Oji-Cree
      ojw:Ojibwa na Yammaci
      oka:Okanagan
      om:Oromo
      or:Odiya
      os:Ossetic
      pa:Punjabi
      pag:Pangasinanci
      pam:Pampanga
      pap:Papiamento
      pau:Palauan
      pcm:Pidgin na Najeriya
      pis:Pijin
      pl:Harshen Polan
      pqm:Maliseet-Passamaquoddy
      prg:Ferusawa
      ps:Pashtanci
      pt:Harshen Potugis
      pt-BR:Harshen Potugis na Birazil
      pt-PT:Potugis Ƙasashen Turai
      qu:Quechua
      raj:Rajasthani
      rap:Rapanui
      rar:Rarotongan
      rhg:Harshen Rohingya
      rm:Romansh
      rn:Rundi
      ro:Romaniyanci
      rof:Rombo
      ru:Rashanci
      rup:Aromaniyanci
      rw:Kinyarwanda
      rwk:Rwa
      sa:Sanskrit
      sad:Sandawe
      sah:Yakut
      saq:Samburu
      sat:Santali
      sba:Ngambay
      sbp:Sangu
      sc:Sardiniyanci
      scn:Sisiliyanci
      sco:Scots
      sd:Sindiyanci
      se:Sami ta Arewa
      seh:Sena
      ses:Koyraboro Senni
      sg:Sango
      sh:Kuroweshiyancin-Sabiya
      shi:Tachelhit
      shn:Shan
      si:Sinhalanci
      sk:Basulke
      sl:Basulabe
      slh:Lushbootseed na Kudanci
      sm:Samoan
      smn:Inari Sami
      sms:Skolt Sami
      sn:Shona
      snk:Soninke
      so:Somalianci
      sq:Albaniyanci
      sr:Sabiyan
      srn:Sranan Tongo
      ss:Swati
      st:Sesotanci
      str:Straits Salish
      su:Harshen Sundanese
      suk:Sukuma
      sv:Harshen Suwedan
      sw:Harshen Suwahili
      swb:Komoriyanci
      syr:Syriac
      szl:Silessiyanci
      ta:Tamil
      tce:Tutchone na Kudanci
      te:Telugu
      tem:Timne
      teo:Teso
      tet:Tatum
      tg:Tajik
      tgx:Tagish
      th:Thai
      tht:Tahltan
      ti:Tigrinyanci
      tig:Tigre
      tk:Tukmenistanci
      tlh:Klingon
      tli:Tlingit
      tn:Tswana
      to:Tonganci
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Harshen Turkiyya
      trv:Taroko
      ts:Tsonga
      tt:Tatar
      ttm:Tutchone na Arewaci
      tum:Tumbuka
      tvl:Tuvalu
      tw:Tiwiniyanci
      twq:Tasawak
      ty:Tahitiyanci
      tyv:Tuviniyanci
      tzm:Tamazight na Atlas Tsaka
      udm:Udmurt
      ug:Ugiranci
      uk:Harshen Yukuren
      umb:Umbundu
      und:Harshen da ba a sani ba
      ur:Urdanci
      uz:Uzbek
      vai:Vai
      ve:Venda
      vec:Veneshiyanci
      vi:Harshen Biyetinam
      vmw:Makhuwa
      vo:Volapük
      vun:Vunjo
      wa:Walloon
      wae:Walser
      wal:Wolaytta
      war:Waray
      wo:Wolof
      wuu:Sinancin Wu
      xal:Kalmyk
      xh:Xhosa
      xnr:Kangri
      xog:Soga
      yav:Yangben
      ybb:Yemba
      yi:Yaren Yiddish
      yo:Yarbanci
      yrl:Nheengatu
      yue:Harshen Cantonese
      yue-alt-menu:Sinanci, Cantonese
      za:Zhuang
      zgh:Daidaitaccen Moroccan Tamazight
      zh:Harshen Sinanci
      zh-alt-menu:Harshen, Sinanci
      zh-Hans:Sauƙaƙaƙƙen Sinanci
      zh-Hans-alt-long:Sauƙaƙaƙƙen Sinanci
      zh-Hant:Sinanci na gargajiya
      zh-Hant-alt-long:Sinanci na gargajiya
      zu:Harshen Zulu
      zun:Zuni
      zxx:Babu abun cikin yare
      zza:Zaza
      """.trimIndent() }

  val ha_GH: String? = null

  val ha_NE: String? = null

  val haw: String by lazy { """
      ar:ʻAlapia
      cy:Wale
      da:Kenemaka
      de:Kelemānia
      el:Helene
      en:Pelekānia
      en-AU:Pelekāne Nū Hōlani
      en-CA:Pelekāne Kanakā
      en-GB:Pelekānia Pekekāne
      en-GB-alt-short:Pelekānia Pekekāne
      en-US:Pelekānia ʻAmelika
      en-US-alt-short:Pelekānia ʻAmelika
      es:Paniolo
      fj:Pīkī
      fr:Palani
      fr-CA:Palani Kanakā
      fr-CH:Kuikilani
      ga:ʻAiliki
      gsw:Kuikilani Kelemānia
      haw:ʻŌlelo Hawaiʻi
      he:Hebera
      it:ʻĪkālia
      ja:Kepanī
      ko:Kōlea
      la:Lākina
      mi:Māori
      nl:Hōlani
      pt:Pukikī
      pt-BR:Pukikī Palakila
      ru:Lūkia
      sm:Kāmoa
      sv:Kuekene
      to:Tonga
      ty:Polapola
      und:ʻIke ʻole ‘ia a kūpono ʻole paha ka ʻōlelo
      vi:Wiekanama
      zh:Pākē
      zh-alt-menu:Pākē
      zh-Hans:Pākē Hoʻomaʻalahi ʻia
      zh-Hans-alt-long:Pākē Hoʻomaʻalahi ʻia
      zh-Hant:Pākē Kuʻuna
      zh-Hant-alt-long:Pākē Kuʻuna
      """.trimIndent() }

  val he: String by lazy { """
      aa:אפארית
      ab:אבחזית
      ace:אכינזית
      ach:אקצ׳ולי
      ada:אדנמה
      ady:אדיגית
      ae:אבסטן
      af:אפריקאנס
      afh:אפריהילי
      agq:אע׳ם
      ain:אינו
      ak:אקאן
      akk:אכדית
      ale:אלאוט
      alt:אלטאי דרומית
      am:אמהרית
      an:אראגונית
      ang:אנגלית עתיקה
      ann:אובולו
      anp:אנג׳יקה
      ar:ערבית
      ar-001:ערבית ספרותית
      arc:ארמית
      arn:אראוקנית
      arp:אראפהו
      ars:ערבית - נג׳ד
      arw:ארוואק
      as:אסאמית
      asa:אסו
      ast:אסטורית
      atj:אטיקמק
      av:אווארית
      awa:אוואדית
      ay:איימארית
      az:אזרית
      az-alt-short:אזרית
      ba:בשקירית
      bal:באלוצ׳י
      ban:באלינזית
      bar:בווארית
      bas:בסאא
      bax:במום
      bbj:גומאלה
      be:בלארוסית
      bej:בז׳ה
      bem:במבה
      bez:בנה
      bfd:באפוט
      bg:בולגרית
      bgc:הריאנבי
      bgn:באלוצ׳י מערבית
      bho:בוג׳פורי
      bi:ביסלמה
      bik:ביקול
      bin:ביני
      bkm:קום
      bla:סיקסיקה
      blo:אני
      bm:במבארה
      bn:בנגלית
      bo:טיבטית
      br:ברטונית
      bra:בראג׳
      brx:בודו
      bs:בוסנית
      bss:אקוסה
      bua:בוריאט
      bug:בוגינזית
      bum:בולו
      byn:בלין
      byv:מדומבה
      ca:קטלאנית
      cad:קאדו
      car:קאריב
      cay:קאיוגה
      cch:אטסם
      ccp:צ׳אקמה
      ce:צ׳צ׳נית
      ceb:סבואנו
      cgg:צ׳יגה
      ch:צ׳מורו
      chb:צ׳יבצ׳ה
      chg:צ׳אגאטאי
      chk:צ׳וקסה
      chm:מארי
      chn:ניב צ׳ינוק
      cho:צ׳וקטאו
      chp:צ׳יפוויאן
      chr:צ׳רוקי
      chy:שאיין
      ckb:כורדית סוראנית
      ckb-alt-menu:כורדית סוראנית
      ckb-alt-variant:כורדית סוראנית
      clc:צ׳ילקוטין
      co:קורסיקנית
      cop:קופטית
      cr:קרי
      crg:מצ׳יף
      crh:טטרית של קרים
      crj:קרי דרום מזרחי
      crk:קרי מישורים
      crl:קרי צפון מזרחי
      crm:מוס קרי
      crr:אלגונקוויאן בקרוליינה
      crs:קריאולית (סיישל)
      cs:צ׳כית
      csb:קשובית
      csw:קרי של אזור הביצות
      cu:סלאבית כנסייתית עתיקה
      cv:צ׳ובאש
      cy:וולשית
      da:דנית
      dak:דקוטה
      dar:דרגווה
      dav:טאיטה
      de:גרמנית
      del:דלאוור
      den:סלאבית
      dgr:דוגריב
      din:דינקה
      dje:זארמה
      doi:דוגרי
      dsb:סורבית תחתית
      dua:דואלה
      dum:הולנדית תיכונה
      dv:דיבהי
      dyo:ג׳ולה פונית
      dyu:דיולה
      dz:דזונקה
      dzg:דזאנגה
      ebu:אמבו
      ee:אווה
      efi:אפיק
      egy:מצרית עתיקה
      eka:אקיוק
      el:יוונית
      elx:עילמית
      en:אנגלית
      enm:אנגלית תיכונה
      eo:אספרנטו
      es:ספרדית
      et:אסטונית
      eu:בסקית
      ewo:אוונדו
      fa:פרסית
      fa-AF:דארי
      fan:פנג
      fat:פאנטי
      ff:פולה
      fi:פינית
      fil:פיליפינית
      fj:פיג׳ית
      fo:פארואזית
      fon:פון
      fr:צרפתית
      frc:צרפתית קייג׳ונית
      frm:צרפתית תיכונה
      fro:צרפתית עתיקה
      frr:פריזית צפונית
      frs:פריזית מזרחית
      fur:פריולית
      fy:פריזית מערבית
      ga:אירית
      gaa:גא
      gag:גגאוזית
      gan:סינית גאן
      gay:גאיו
      gba:גבאיה
      gd:גאלית סקוטית
      gez:געז
      gil:קיריבטית
      gl:גליציאנית
      gmh:גרמנית בינונית-גבוהה
      gn:גוארני
      goh:גרמנית עתיקה גבוהה
      gon:גונדי
      gor:גורונטאלו
      got:גותית
      grb:גרבו
      grc:יוונית עתיקה
      gsw:גרמנית שוויצרית
      gu:גוג׳ארטי
      guz:גוסי
      gv:מאנית
      gwi:גוויצ׳ן
      ha:האוסה
      hai:האידה
      hak:סינית האקה
      haw:הוואית
      hax:האידה דרומית
      he:עברית
      hi:הינדי
      hi-Latn-alt-variant:הינגליש
      hil:היליגאינון
      hit:חתית
      hmn:המונג
      ho:הירי מוטו
      hr:קרואטית
      hsb:סורבית עילית
      hsn:סינית שיאנג
      ht:קריאולית (האיטי)
      hu:הונגרית
      hup:הופה
      hur:הלקומלם
      hy:ארמנית
      hz:הררו
      ia:‏אינטרלינגואה
      iba:איבאן
      ibb:איביביו
      id:אינדונזית
      ie:אינטרלינגה
      ig:איגבו
      ii:סצ׳ואן יי
      ik:אינופיאק
      ikt:אינוקטיטוט במערב קנדה
      ilo:אילוקו
      inh:אינגושית
      io:אידו
      is:איסלנדית
      it:איטלקית
      iu:אינוקטיטוט
      ja:יפנית
      jbo:לוז׳באן
      jgo:נגומבה
      jmc:מאקאמה
      jpr:פרסית יהודית
      jrb:ערבית יהודית
      jv:יאוואית
      ka:גאורגית
      kaa:קארא-קלפאק
      kab:קבילה
      kac:קצ׳ין
      kaj:ג׳ו
      kam:קמבה
      kaw:קאווי
      kbd:קברדית
      kbl:קנמבו
      kcg:טיאפ
      kde:מקונדה
      kea:קאבוורדיאנו
      kfo:קורו
      kg:קונגו
      kgp:קיינגאנג
      kha:קהאסי
      kho:קוטאנזית
      khq:קוירה צ׳יני
      ki:קיקויו
      kj:קואניאמה
      kk:קזחית
      kkj:קאקו
      kl:גרינלנדית
      kln:קלנג׳ין
      km:חמרית
      kmb:קימבונדו
      kn:קנאדה
      ko:קוריאנית
      koi:קומי-פרמיאקית
      kok:קונקאני
      kos:קוסראיאן
      kpe:קפלה
      kr:קאנורי
      krc:קראצ׳י-בלקר
      krl:קארלית
      kru:קורוק
      ks:קשמירית
      ksb:שמבאלה
      ksf:באפיה
      ksh:קולוניאן
      ku:כורדית
      kum:קומיקית
      kut:קוטנאי
      kv:קומי
      kw:קורנית
      kwk:קוואקוואלה
      kxv:קווי
      ky:קירגיזית
      la:לטינית
      lad:לדינו
      lag:לאנגי
      lah:לנדה
      lam:למבה
      lb:לוקסמבורגית
      lez:לזגית
      lg:גאנדה
      li:לימבורגית
      lij:ליגורית
      lil:לילואט
      lkt:לקוטה
      lmo:לומברדית
      ln:לינגלה
      lo:לאו
      lol:מונגו
      lou:קריאולית לואיזיאנית
      loz:לוזית
      lrc:לורית צפונית
      lsm:סמיה
      lt:ליטאית
      lu:לובה-קטנגה
      lua:לובה-לולואה
      lui:לויסנו
      lun:לונדה
      luo:לואו
      lus:מיזו
      luy:לויה
      lv:לטבית
      mad:מדורזית
      maf:מאפאה
      mag:מאגאהית
      mai:מאיטילית
      mak:מקסאר
      man:מנדינגו
      mas:מסאית
      mde:מאבא
      mdf:מוקשה
      mdr:מנדאר
      men:מנדה
      mer:מרו
      mfe:קריאולית מאוריציאנית
      mg:מלגשית
      mga:אירית תיכונה
      mgh:מאקוואה מטו
      mgo:מטא
      mh:מרשלית
      mi:מאורית
      mic:מיקמק
      min:מיננגקבאו
      mk:מקדונית
      ml:מליאלאם
      mn:מונגולית
      mnc:מנצ׳ו
      mni:מניפורית
      moe:אינו-אמון
      moh:מוהוק
      mos:מוסי
      mr:מראטהית
      ms:מלאית
      mt:מלטית
      mua:מונדאנג
      mul:מספר שפות
      mus:קריק
      mwl:מירנדזית
      mwr:מרווארי
      my:בורמזית
      mye:מאיין
      myv:ארזיה
      mzn:מאזאנדראני
      na:נאורית
      nan:סינית מין נאן
      nap:נפוליטנית
      naq:נאמה
      nb:נורווגית ספרותית
      nd:נדבלה צפונית
      nds:גרמנית תחתית
      nds-NL:סקסונית תחתית
      ne:נפאלית
      new:נווארי
      ng:נדונגה
      nia:ניאס
      niu:ניואן
      nl:הולנדית
      nl-BE:הולנדית (פלמית)
      nmg:קוואסיו
      nn:נורווגית חדשה
      nnh:נגיאמבון
      no:נורווגית
      nog:נוגאי
      non:‏נורדית עתיקה
      nqo:נ׳קו
      nr:נדבלה דרומית
      nso:סותו צפונית
      nus:נואר
      nv:נאוואחו
      nwc:נווארית קלאסית
      ny:ניאנג׳ה
      nym:ניאמווזי
      nyn:ניאנקולה
      nyo:ניורו
      nzi:נזימה
      oc:אוקסיטנית
      oj:אוג׳יבווה
      ojb:אוג׳יבווה צפון מערבית
      ojc:אוג׳יבווה (מרכז)
      ojs:אוג׳י-קרי
      ojw:אוביג׳ווה מערבית
      oka:אוקאנגן
      om:אורומו
      or:אורייה
      os:אוסטית
      osa:אוסג׳
      ota:טורקית עות׳מנית
      pa:פנג׳אבי
      pag:פנגסינאן
      pal:פלאבי
      pam:פמפאניה
      pap:פפיאמנטו
      pau:פלוואן
      pcm:פידגין ניגרי
      peo:פרסית עתיקה
      phn:פיניקית
      pi:פאלי
      pis:פייג׳ין
      pl:פולנית
      pon:פונפיאן
      pqm:מליסיט-פאסמקוודי
      prg:פרוסית
      pro:פרובנסאל עתיקה
      ps:פאשטו
      ps-alt-variant:פושטו
      pt:פורטוגזית
      qu:קצ׳ואה
      quc:קיצ׳ה
      raj:ראג׳סטאני
      rap:רפאנוי
      rar:ררוטונגאן
      rhg:רוהינגיה
      rm:רומאנש
      rn:קירונדי
      ro:רומנית
      ro-MD:מולדבית
      rof:רומבו
      rom:רומאני
      ru:רוסית
      rup:ארומנית
      rw:קנירואנדית
      rwk:ראווה
      sa:סנסקריט
      sad:סנדאווה
      sah:סאחה
      sam:ארמית שומרונית
      saq:סמבורו
      sas:סאסק
      sat:סאנטאלי
      sba:נגמבאי
      sbp:סאנגו
      sc:סרדינית
      scn:סיציליאנית
      sco:סקוטית
      sd:סינדהית
      sdh:כורדית דרומית
      se:סמי צפונית
      see:סנקה
      seh:סנה
      sel:סלקופ
      ses:קויראבורו סני
      sg:סנגו
      sga:אירית עתיקה
      sh:סרבו-קרואטית
      shi:שילה
      shn:שאן
      shu:ערבית צ׳אדית
      si:סינהלה
      sid:סידאמו
      sk:סלובקית
      sl:סלובנית
      slh:לשוטסיד
      sm:סמואית
      sma:סאמי דרומית
      smj:לולה סאמי
      smn:אינארי סאמי
      sms:סקולט סאמי
      sn:שונה
      snk:סונינקה
      so:סומלית
      sog:סוגדיאן
      sq:אלבנית
      sr:סרבית
      srn:סרנאן טונגו
      srr:סרר
      ss:סאווזי
      ssy:סאהו
      st:סותו דרומית
      str:סאליש מיצרי חואן דה פוקה
      su:סונדנזית
      suk:סוקומה
      sus:סוסו
      sux:שומרית
      sv:שוודית
      sw:סווהילי
      sw-CD:סווהילי קונגו
      swb:קומורית
      syc:סירית קלאסית
      syr:סורית
      szl:שלזית
      ta:טמילית
      tce:טצ׳ון דרומית
      te:טלוגו
      tem:טימנה
      teo:טסו
      ter:טרנו
      tet:טטום
      tg:טג׳יקית
      tgx:טגישית
      th:תאית
      tht:טלתנית
      ti:תיגרינית
      tig:טיגרית
      tiv:טיב
      tk:טורקמנית
      tkl:טוקלאו
      tl:טאגאלוג
      tlh:קלינגונית
      tli:טלינגיט
      tmh:טמאשק
      tn:סוואנה
      to:טונגאית
      tog:ניאסה טונגה
      tok:טוקי פונה
      tpi:טוק פיסין
      tr:טורקית
      trv:טרוקו
      ts:טסונגה
      tsi:טסימשיאן
      tt:טטרית
      ttm:טצ׳ון צפונית
      tum:טומבוקה
      tvl:טובאלו
      tw:טווי
      twq:טסוואק
      ty:טהיטית
      tyv:טובינית
      tzm:תמאזיגת של מרכז מרוקו
      udm:אודמורט
      ug:אויגורית
      uga:אוגריתית
      uk:אוקראינית
      umb:אומבונדו
      und:שפה לא ידועה
      ur:אורדו
      uz:אוזבקית
      vai:וואי
      ve:וונדה
      vec:ונציאנית
      vi:וייטנאמית
      vmw:מאקואה
      vo:‏וולאפיק
      vot:ווטיק
      vun:וונג׳ו
      wa:ולונית
      wae:וואלסר
      wal:ווליאטה
      war:ווראי
      was:וואשו
      wbp:וורלפירי
      wo:וולוף
      wuu:סינית וו
      xal:קלמיקית
      xh:קוסה
      xnr:קאנגרי
      xog:סוגה
      yao:יאו
      yap:יאפזית
      yav:יאנגבן
      ybb:ימבה
      yi:יידיש
      yo:יורובה
      yrl:נינגטו
      yue:קנטונזית
      yue-alt-menu:סינית, קנטונזית
      za:זואנג
      zap:זאפוטק
      zbl:בליסימבולס
      zen:זנאגה
      zgh:תמזיע׳ת מרוקאית תקנית
      zh:סינית
      zh-alt-menu:סינית, מנדרינית
      zh-Hans:סינית פשוטה
      zh-Hans-alt-long:סינית מנדרינית פשוטה
      zh-Hant:סינית מסורתית
      zh-Hant-alt-long:סינית מנדרינית מסורתית
      zu:זולו
      zun:זוני
      zxx:ללא תוכן לשוני
      zza:זאזא
      """.trimIndent() }

  val hi: String by lazy { """
      aa:अफ़ार
      ab:अब्ख़ाज़ियन
      ace:अचाइनीस
      ach:अकोली
      ada:अदान्गमे
      ady:अदिघे
      ae:अवस्ताई
      af:अफ़्रीकी
      afh:अफ्रिहिली
      agq:अग्हेम
      ain:ऐनू
      ak:अकन
      akk:अक्कादी
      ale:अलेउत
      alt:दक्षिणी अल्ताई
      am:अम्हेरी
      an:अरागोनी
      ang:पुरानी अंग्रेज़ी
      ann:ओबोलो
      anp:अंगिका
      ar:अरबी
      ar-001:आधुनिक मानक अरबी
      arc:ऐरेमेक
      arn:मापूचे
      arp:अरापाहो
      ars:नज्दी अरबी
      ars-alt-menu:अरबी, नज्दी
      arw:अरावक
      as:असमिया
      asa:असु
      ast:अस्तुरियन
      atj:अतिकामेक्व
      av:अवेरिक
      awa:अवधी
      ay:आयमारा
      az:अज़रबैजानी
      az-alt-short:अज़ेरी
      ba:बशख़िर
      bal:बलूची
      ban:बालिनीस
      bas:बसा
      be:बेलारूसी
      bej:बेजा
      bem:बेम्बा
      bew:बेतावी
      bez:बेना
      bg:बुल्गारियाई
      bgc:हरियाणवी
      bgn:पश्चिमी बलोची
      bho:भोजपुरी
      bi:बिस्लामा
      bik:बिकोल
      bin:बिनी
      bla:सिक्सिका
      blo:अनी
      bm:बाम्बारा
      bn:बंगाली
      bo:तिब्बती
      br:ब्रेटन
      bra:ब्रज
      brx:बोडो
      bs:बोस्नियाई
      bss:अकूसे
      bua:बुरियात
      bug:बगिनीस
      byn:ब्लिन
      ca:कातालान
      cad:कैड्डो
      car:कैरिब
      cay:कायुगा
      cch:अत्सम
      ccp:चकमा
      ce:चेचन
      ceb:सिबुआनो
      cgg:शिगा
      ch:कमोरो
      chb:चिब्चा
      chg:छगाताई
      chk:चूकीस
      chm:मारी
      chn:चिनूक जारगॉन
      cho:चोक्तौ
      chp:शिपेव्यान
      chr:चेरोकी
      chy:शेयेन्न
      cic:चिकसॉ
      ckb:सोरानी कुर्दिश
      ckb-alt-menu:कुर्दी, सोरानी
      ckb-alt-variant:सोरानी कुर्दिश
      clc:चिलकोटिन
      co:कोर्सीकन
      cop:कॉप्टिक
      cr:क्री
      crg:मिचिफ़
      crh:क्रीमीन तुर्की
      crj:दक्षिण पूर्वी क्री
      crk:प्लेन्स क्री
      crl:नॉर्दन ईस्ट क्री
      crm:मूस क्री
      crr:कैरोलाइना एल्गोंक्वीयन
      crs:सेसेल्वा क्रिओल फ्रेंच
      cs:चेक
      csb:काशुबियन
      csw:स्वॉम्पी क्री
      cu:चर्च साल्विक
      cv:चूवाश
      cy:वेल्श
      da:डेनिश
      dak:दाकोता
      dar:दार्गवा
      dav:तैता
      de:जर्मन
      de-AT:ऑस्ट्रियाई जर्मन
      de-CH:स्विस उच्च जर्मन
      del:डिलैवेयर
      den:स्लेव
      dgr:डोग्रिब
      din:दिन्का
      dje:झार्मा
      doi:डोगरी
      dsb:निचला सॉर्बियन
      dua:दुआला
      dum:मध्यकालीन पुर्तगाली
      dv:दिवेही
      dyo:जोला-फोंई
      dyu:ड्युला
      dz:ज़ोन्गखा
      dzg:दज़ागा
      ebu:एम्बु
      ee:ईवे
      efi:एफिक
      egy:प्राचीन मिस्री
      eka:एकाजुक
      el:यूनानी
      elx:एलामाइट
      en:अंग्रेज़ी
      en-AU:ऑस्ट्रेलियाई अंग्रेज़ी
      en-CA:कनाडाई अंग्रेज़ी
      en-GB:ब्रिटिश अंग्रेज़ी
      en-GB-alt-short:यू॰के॰ अंग्रेज़ी
      en-US:अमेरिकी अंग्रेज़ी
      en-US-alt-short:अमेरिकी अंग्रेज़ी
      enm:मध्यकालीन अंग्रेज़ी
      eo:एस्पेरेंतो
      es:स्पेनिश
      es-419:लैटिन अमेरिकी स्पेनिश
      es-ES:यूरोपीय स्पेनिश
      es-MX:मैक्सिकन स्पेनिश
      et:एस्टोनियाई
      eu:बास्क
      ewo:इवोन्डो
      fa:फ़ारसी
      fa-AF:दारी
      fan:फैन्ग
      fat:फन्टी
      ff:फुलाह
      fi:फ़िनिश
      fil:फ़िलिपीनो
      fj:फिजियन
      fo:फ़ैरोइज़
      fon:फॉन
      fr:फ़्रेंच
      fr-CA:कनाडाई फ़्रेंच
      fr-CH:स्विस फ़्रेंच
      frc:केजन फ़्रेंच
      frm:मध्यकालीन फ़्रांसीसी
      fro:पुरातन फ़्रांसीसी
      frr:उत्तरी फ़्रीसियाई
      frs:पूर्वी फ़्रीसियाई
      fur:फ्रीयुलीयान
      fy:पश्चिमी फ़्रिसियाई
      ga:आयरिश
      gaa:गा
      gag:गागौज़
      gay:गायो
      gba:ग्बाया
      gd:स्कॉटिश गाएलिक
      gez:गीज़
      gil:गिल्बरतीस
      gl:गैलिशियन
      gmh:मध्यकालीन हाइ जर्मन
      gn:गुआरानी
      goh:पुरातन हाइ जर्मन
      gon:गाँडी
      gor:गोरोन्तालो
      got:गॉथिक
      grb:ग्रेबो
      grc:प्राचीन यूनानी
      gsw:स्विस जर्मन
      gu:गुजराती
      guz:गुसी
      gv:मैंक्स
      gwi:ग्विचइन
      ha:हौसा
      hai:हैडा
      haw:हवाई
      hax:दक्षिणी हाइदा
      he:हिब्रू
      hi:हिन्दी
      hi-Latn-alt-variant:हिंग्लिश
      hil:हिलिगेनन
      hit:हिताइत
      hmn:ह्मॉंग
      hnj:हमोंग नजुआ
      ho:हिरी मोटू
      hr:क्रोएशियाई
      hsb:ऊपरी सॉर्बियन
      ht:हैतियाई
      hu:हंगेरियाई
      hup:हूपा
      hur:हल्कोमेलम
      hy:आर्मेनियाई
      hz:हरैरो
      ia:इंटरलिंगुआ
      iba:इबान
      ibb:इबिबियो
      id:इंडोनेशियाई
      ie:ईन्टरलिंगुइ
      ig:ईग्बो
      ii:सिचुआन यी
      ik:इनुपियाक्
      ikt:पश्चिमी कनाडाई इनुक्टिटुट
      ilo:इलोको
      inh:इंगुश
      io:इडौ
      is:आइसलैंडिक
      it:इतालवी
      iu:इनुक्टिटुट
      ja:जापानी
      jbo:लोज्बान
      jgo:नगोंबा
      jmc:मैकहैमे
      jpr:जुदेओ-पर्शियन
      jrb:जुदेओ-अरेबिक
      jv:जावानीज़
      ka:जॉर्जियाई
      kaa:कारा-कल्पक
      kab:कबाइल
      kac:काचिन
      kaj:ज्जु
      kam:कम्बा
      kaw:कावी
      kbd:कबार्डियन
      kcg:त्याप
      kde:मैकोंड
      kea:काबुवेर्दियानु
      kfo:कोरो
      kg:कोंगो
      kgp:काइंगांग
      kha:खासी
      kho:खोतानीस
      khq:कोयरा चीनी
      ki:किकुयू
      kj:क्वान्यामा
      kk:कज़ाख़
      kkj:काको
      kl:कलालीसुत
      kln:कलेंजिन
      km:खमेर
      kmb:किम्बन्दु
      kn:कन्नड़
      ko:कोरियाई
      koi:कोमी-पर्मयाक
      kok:कोंकणी
      kos:कोसरैन
      kpe:क्पेल
      kr:कनुरी
      krc:कराचय-बल्कार
      krl:करेलियन
      kru:कुरूख
      ks:कश्मीरी
      ksb:शम्बाला
      ksf:बफिआ
      ksh:कोलोनियाई
      ku:कुर्दिश
      kum:कुमीक
      kut:क्यूतनाई
      kv:कोमी
      kw:कोर्निश
      kwk:क्वॉकवाला
      kxv:कुवी
      ky:किर्गीज़
      la:लैटिन
      lad:लादीनो
      lag:लांगि
      lah:लाह्न्डा
      lam:लाम्बा
      lb:लग्ज़मबर्गी
      lez:लेज़्घीयन
      lg:गांडा
      li:लिंबर्गिश
      lij:लिगुरियन
      lil:लिलोएट
      lkt:लैकोटा
      lmo:लॉमबर्ड
      ln:लिंगाला
      lo:लाओ
      lol:मोंगो
      lou:लुईज़ियाना क्रियोल
      loz:लोज़ी
      lrc:उत्तरी लूरी
      lsm:सामिया
      lt:लिथुआनियाई
      lu:ल्यूबा-कटांगा
      lua:ल्यूबा-लुलुआ
      lui:लुइसेनो
      lun:लुन्डा
      luo:ल्युओ
      lus:मिज़ो
      luy:ल्युईआ
      lv:लातवियाई
      mad:मादुरीस
      mag:मगही
      mai:मैथिली
      mak:मकासर
      man:मन्डिन्गो
      mas:मसाई
      mdf:मोक्ष
      mdr:मंदार
      men:मेन्डे
      mer:मेरु
      mfe:मोरीस्येन
      mg:मालागासी
      mga:मध्यकालीन आइरिश
      mgh:मैखुवा-मीट्टो
      mgo:मेटा
      mh:मार्शलीज़
      mi:माओरी
      mic:मिकमैक
      min:मिनांग्काबाउ
      mk:मकदूनियाई
      ml:मलयालम
      mn:मंगोलियाई
      mnc:मन्चु
      mni:मणिपुरी
      moe:इन्नु-एईमन
      moh:मोहौक
      mos:मोस्सी
      mr:मराठी
      ms:मलय
      mt:माल्टीज़
      mua:मुंडैंग
      mul:एकाधिक भाषाएँ
      mus:क्रीक
      mwl:मिरांडी
      mwr:मारवाड़ी
      my:बर्मीज़
      myv:एर्ज़या
      mzn:माज़न्देरानी
      na:नाउरू
      nan:मिन नान
      nap:नीपोलिटन
      naq:नामा
      nb:नॉर्वेजियाई बोकमाल
      nd:उत्तरी देबेल
      nds:निचला जर्मन
      nds-NL:निचली सैक्सन
      ne:नेपाली
      new:नेवाड़ी
      ng:डोन्गा
      nia:नियास
      niu:नियुआन
      nl:डच
      nl-BE:फ़्लेमिश
      nmg:क्वासिओ
      nn:नॉर्वेजियाई नॉयनॉर्स्क
      nnh:गैम्बू
      no:नॉर्वेजियाई
      nog:नोगाई
      non:पुराना नॉर्स
      nqo:एन्को
      nr:दक्षिण देबेल
      nso:उत्तरी सोथो
      nus:नुएर
      nv:नवाहो
      nwc:पारम्परिक नेवारी
      ny:न्यानजा
      nym:न्यामवेज़ी
      nyn:न्यानकोल
      nyo:न्योरो
      nzi:न्ज़ीमा
      oc:ओसीटान
      oj:ओजिब्वा
      ojb:उत्तरपश्चिमी ओजिब्वे
      ojc:सेंट्रल ओजीब्वे
      ojs:ओजी-क्री
      ojw:पश्चिमी ओजिब्वा
      oka:ओकनागन
      om:ओरोमो
      or:ओड़िया
      os:ओस्सेटिक
      osa:ओसेज
      ota:ओटोमान तुर्किश
      pa:पंजाबी
      pag:पंगासीनान
      pal:पाह्लावी
      pam:पाम्पान्गा
      pap:पापियामेन्टो
      pau:पलोउआन
      pcm:नाइजीरियाई पिडगिन
      peo:पुरानी फारसी
      phn:फोएनिशियन
      pi:पाली
      pis:पाईजिन
      pl:पोलिश
      pon:पोह्नपिएन
      pqm:मलेसीट-पासेमेक्वोडी
      prg:प्रुशियाई
      pro:पुरानी प्रोवेन्सल
      ps:पश्तो
      ps-alt-variant:पुश्तो
      pt:पुर्तगाली
      pt-BR:ब्राज़ीली पुर्तगाली
      pt-PT:यूरोपीय पुर्तगाली
      qu:क्वेचुआ
      quc:किश
      raj:राजस्थानी
      rap:रापानुई
      rar:रारोतोंगन
      rhg:रोहिंग्या
      rm:रोमान्श
      rn:रुन्दी
      ro:रोमानियाई
      ro-MD:मोलडावियन
      rof:रोम्बो
      rom:रोमानी
      ru:रूसी
      rup:अरोमानियन
      rw:किन्यारवांडा
      rwk:रवा
      sa:संस्कृत
      sad:सन्डावे
      sah:याकूत
      sam:सामैरिटन अरैमिक
      saq:सैम्बुरु
      sas:सासाक
      sat:संथाली
      sba:न्गाम्बे
      sbp:सैंगु
      sc:सार्दिनियन
      scn:सिसिलियन
      sco:स्कॉट्स
      sd:सिंधी
      sdh:दक्षिणी कार्डिश
      se:नॉर्दन सामी
      seh:सेना
      sel:सेल्कप
      ses:कोयराबोरो सेन्नी
      sg:सांगो
      sga:पुरानी आइरिश
      sh:सेर्बो-क्रोएशियाई
      shi:तैचेल्हित
      shn:शैन
      si:सिंहली
      sid:सिदामो
      sk:स्लोवाक
      sl:स्लोवेनियाई
      slh:दक्षिणी लशूटसीड
      sm:सामोन
      sma:दक्षिणी सामी
      smj:ल्युल सामी
      smn:इनारी सामी
      sms:स्कोल्ट सामी
      sn:शोणा
      snk:सोनिन्के
      so:सोमाली
      sog:सोग्डिएन
      sq:अल्बानियाई
      sr:सर्बियाई
      srn:स्रानान टॉन्गो
      srr:सेरेर
      ss:स्वाती
      ssy:साहो
      st:दक्षिणी सेसेथो
      str:स्ट्रेट्स सैलिश
      su:सुंडानी
      suk:सुकुमा
      sus:सुसु
      sux:सुमेरियन
      sv:स्वीडिश
      sw:स्वाहिली
      sw-CD:कांगो स्वाहिली
      swb:कोमोरियन
      syc:क्लासिकल सिरिएक
      syr:सिरिएक
      szl:सायलिज़ियन
      ta:तमिल
      tce:दक्षिणी टशोनी
      te:तेलुगू
      tem:टिम्ने
      teo:टेसो
      ter:तेरेनो
      tet:तेतुम
      tg:ताजिक
      tgx:टैगिश
      th:थाई
      tht:टैल्हटन
      ti:तिग्रीन्या
      tig:टाइग्रे
      tiv:तिव
      tk:तुर्कमेन
      tkl:तोकेलाऊ
      tl:टैगलॉग
      tlh:क्लिंगन
      tli:त्लिंगित
      tmh:तामाशेक
      tn:सेत्स्वाना
      to:टोंगन
      tog:न्यासा टोन्गा
      tok:टोकी पोना
      tpi:टोक पिसिन
      tr:तुर्की
      trv:तारोको
      ts:सोंगा
      tsi:त्सिमीशियन
      tt:तातार
      ttm:उत्तरी टुशोनी
      tum:तम्बूका
      tvl:तुवालु
      tw:ट्वी
      twq:टासवाक
      ty:ताहितियन
      tyv:तुवीनियन
      tzm:मध्य एटलस तमाज़ित
      udm:उदमुर्त
      ug:उइगर
      uga:युगैरिटिक
      uk:यूक्रेनियाई
      umb:उम्बुन्डु
      und:अज्ञात भाषा
      ur:उर्दू
      uz:उज़्बेक
      vai:वाई
      ve:वेन्दा
      vec:वनीशन
      vi:वियतनामी
      vmw:मखुवा
      vo:वोलापुक
      vot:वॉटिक
      vun:वुंजो
      wa:वाल्लून
      wae:वाल्सर
      wal:वलामो
      war:वारै
      was:वाशो
      wbp:वॉल्पेरी
      wo:वोलोफ़
      wuu:वू चीनी
      xal:काल्मिक
      xh:ख़ोसा
      xnr:कांगड़ी
      xog:सोगा
      yao:याओ
      yap:यापीस
      yav:यांगबेन
      ybb:येंबा
      yi:यहूदी
      yo:योरूबा
      yrl:नेइंगातू
      yue:कैंटोनीज़
      yue-alt-menu:चीनी, कैंटोनीज़
      za:ज़ुआंग
      zap:ज़ेपोटेक
      zbl:ब्लिसिम्बॉल्स
      zen:ज़ेनान्गा
      zgh:मानक मोरक्कन तामाज़ाइट
      zh:चीनी
      zh-alt-menu:चीनी, मैंडेरिन
      zh-Hans:सरलीकृत चीनी
      zh-Hans-alt-long:सरलीकृत मैंडेरिन चीनी
      zh-Hant:पारंपरिक चीनी
      zh-Hant-alt-long:पारंपरिक मैंडेरिन चीनी
      zu:ज़ुलू
      zun:ज़ूनी
      zxx:कोई भाषा सामग्री नहीं
      zza:ज़ाज़ा
      """.trimIndent() }

  val hi_Latn: String by lazy { """
      af:Afreeki
      bgc:Hariyaanvi
      bn:Bangla
      bo:Tibbati
      ckb:Kurdish, Sorani
      crh:Crimean Turkish
      fa:Faarsi
      ff:Fulah
      lah:Lahnda
      mic:Mi'kmaq
      mus:Muscogee
      nan:Min Nan
      nb:Norwegian Bokmal
      nds-NL:Low Saxon
      ug:Uighur
      wal:walamo
      """.trimIndent() }

  val hnj: String by lazy { """
      ar:𞄤𞄣
      bn:𞄜𞄤
      en:𞄥𞄴𞄅𞄇𞄉𞄦𞄱𞄊
      fr:𞄕𞄤𞄰𞄎𞄦𞄴
      hmn:𞄀𞄄𞄰𞄩
      hnj:𞄀𞄄𞄰𞄩𞄍𞄜𞄰
      zh:𞄋𞄄
      zh-alt-menu:𞄋𞄄
      """.trimIndent() }

  val hnj_Hmnp: String? = null

  val hr: String by lazy { """
      aa:afarski
      ab:abhaski
      ace:ačinski
      ach:ačoli
      ada:adangme
      ady:adigejski
      ae:avestički
      af:afrikaans
      afh:afrihili
      agq:aghem
      ain:ainuski
      ak:akanski
      akk:akadski
      ale:aleutski
      alt:južni altai
      am:amharski
      an:aragonski
      ang:staroengleski
      ann:obolo
      anp:angika
      ar:arapski
      ar-001:moderni standardni arapski
      arc:aramejski
      arn:mapuche
      arp:arapaho
      ars:najdi arapski
      ars-alt-menu:arapski, najdi
      arw:aravački
      as:asamski
      asa:asu
      ast:asturijski
      atj:atikamekw
      av:avarski
      awa:awadhi
      ay:ajmarski
      az:azerbajdžanski
      az-alt-short:azerski
      az-Arab:južnoazerbajdžanski
      ba:baškirski
      bal:belučki
      ban:balijski
      bas:basa
      bax:bamunski
      bbj:ghomala
      be:bjeloruski
      bej:beja
      bem:bemba
      bez:bena
      bfd:bafut
      bg:bugarski
      bgc:haryanvi
      bgn:zapadnobaludžijski
      bho:bhojpuri
      bi:bislama
      bik:bikolski
      bin:bini
      bkm:kom
      bla:siksika
      blo:anii
      bm:bambara
      bn:bangla
      bo:tibetski
      br:bretonski
      bra:braj
      brx:bodo
      bs:bosanski
      bss:akoose
      bua:burjatski
      bug:buginski
      bum:bulu
      byn:blin
      byv:medumba
      ca:katalonski
      cad:caddo
      car:karipski
      cay:cayuga
      cch:atsam
      ccp:chakma
      ce:čečenski
      ceb:cebuano
      cgg:chiga
      ch:chamorro
      chb:čibča
      chg:čagatajski
      chk:chuukese
      chm:marijski
      chn:chinook žargon
      cho:choctaw
      chp:chipewyan
      chr:čerokijski
      chy:čejenski
      ckb:soranski kurdski
      ckb-alt-menu:kurdski, sorani
      ckb-alt-variant:kurdski, soranski
      clc:chilcotin
      co:korzički
      cop:koptski
      cr:cree
      crg:michif
      crh:krimski turski
      crj:jugoistični cree
      crk:plains cree
      crl:sjevernoistočni cree
      crm:moose cree
      crr:karolinski algonkijski
      crs:sejšelski kreolski
      cs:češki
      csb:kašupski
      csw:močvarni cree
      cu:crkvenoslavenski
      cv:čuvaški
      cy:velški
      da:danski
      dak:dakota jezik
      dar:dargwa
      dav:taita
      de:njemački
      de-AT:austrijski njemački
      de-CH:gornjonjemački (švicarski)
      del:delavarski
      den:slave
      dgr:dogrib
      din:dinka
      dje:zarma
      doi:dogri
      dsb:donjolužički
      dua:duala
      dum:srednjonizozemski
      dv:divehi
      dyo:jola-fonyi
      dyu:dyula
      dz:dzongkha
      dzg:dazaga
      ebu:embu
      ee:ewe
      efi:efik
      egy:staroegipatski
      eka:ekajuk
      el:grčki
      elx:elamitski
      en:engleski
      en-AU:australski engleski
      en-CA:kanadski engleski
      en-GB:britanski engleski
      en-GB-alt-short:engleski (UK)
      en-US:američki engleski
      en-US-alt-short:engleski (SAD)
      enm:srednjoengleski
      eo:esperanto
      es:španjolski
      es-419:latinoamerički španjolski
      es-ES:europski španjolski
      es-MX:meksički španjolski
      et:estonski
      eu:baskijski
      ewo:ewondo
      fa:perzijski
      fa-AF:dari
      fan:fang
      fat:fanti
      ff:fula
      fi:finski
      fil:filipinski
      fj:fidžijski
      fo:ferojski
      fon:fon
      fr:francuski
      fr-CA:kanadski francuski
      fr-CH:švicarski francuski
      frc:kajunski francuski
      frm:srednjofrancuski
      fro:starofrancuski
      frr:sjevernofrizijski
      frs:istočnofrizijski
      fur:furlanski
      fy:zapadnofrizijski
      ga:irski
      gaa:ga
      gag:gagauski
      gan:gan kineski
      gay:gayo
      gba:gbaya
      gd:škotski gaelski
      gez:geez
      gil:gilbertski
      gl:galicijski
      gmh:srednjogornjonjemački
      gn:gvaranski
      goh:starovisokonjemački
      gon:gondi
      gor:gorontalo
      got:gotski
      grb:grebo
      grc:starogrčki
      gsw:švicarski njemački
      gu:gudžaratski
      guz:gusii
      gv:manski
      gwi:gwich’in
      ha:hausa
      hai:haidi
      hak:hakka kineski
      haw:havajski
      hax:južni haida
      he:hebrejski
      hi:hindski
      hi-Latn-alt-variant:hinglish
      hil:hiligaynonski
      hit:hetitski
      hmn:hmong
      ho:hiri motu
      hr:hrvatski
      hsb:gornjolužički
      hsn:xiang kineski
      ht:haićanski kreolski
      hu:mađarski
      hup:hupa
      hur:halkomelem
      hy:armenski
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonezijski
      ie:interligua
      ig:igbo
      ii:sichuan ji
      ik:inupiaq
      ikt:zapadnokanadski inuktitut
      ilo:iloko
      inh:ingušetski
      io:ido
      is:islandski
      it:talijanski
      iu:inuktitut
      ja:japanski
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jpr:judejsko-perzijski
      jrb:judejsko-arapski
      jv:javanski
      ka:gruzijski
      kaa:kara-kalpak
      kab:kabilski
      kac:kačinski
      kaj:kaje
      kam:kamba
      kaw:kawi
      kbd:kabardinski
      kbl:kanembu
      kcg:tyap
      kde:makonde
      kea:zelenortski
      kfo:koro
      kg:kongo
      kgp:kaingang
      kha:khasi
      kho:khotanese
      khq:koyra chiini
      ki:kikuyu
      kj:kuanyama
      kk:kazaški
      kkj:kako
      kl:kalaallisut
      kln:kalenjin
      km:kmerski
      kmb:kimbundu
      kn:karnatački
      ko:korejski
      koi:komi-permski
      kok:konkani
      kos:naurski
      kpe:kpelle
      kr:kanuri
      krc:karachay-balkar
      krl:karelijski
      kru:kuruški
      ks:kašmirski
      ksb:shambala
      ksf:bafia
      ksh:kelnski
      ku:kurdski
      kum:kumyk
      kut:kutenai
      kv:komi
      kw:kornski
      kwk:kwakʼwala
      kxv:kuvi
      ky:kirgiski
      la:latinski
      lad:ladino
      lag:langi
      lah:lahnda
      lam:lamba
      lb:luksemburški
      lez:lezgiški
      lg:ganda
      li:limburški
      lij:ligurski
      lil:lillooet
      lkt:lakota
      lmo:lombardski
      ln:lingala
      lo:laoski
      lol:mongo
      lou:lujzijanski kreolski
      loz:lozi
      lrc:sjevernolurski
      lsm:saamia
      lt:litavski
      lu:luba-katanga
      lua:luba-lulua
      lui:luiseno
      lun:lunda
      lus:lushai
      luy:luyia
      lv:latvijski
      mad:madurski
      maf:mafa
      mag:magahi
      mai:maithili
      mak:makasar
      man:mandingo
      mas:masajski
      mde:maba
      mdf:moksha
      mdr:mandar
      men:mende
      mer:meru
      mfe:mauricijski kreolski
      mg:malgaški
      mga:srednjoirski
      mgh:makhuwa-meetto
      mgo:meta’
      mh:maršalski
      mi:maorski
      mic:micmac
      min:minangkabau
      mk:makedonski
      ml:malajalamski
      mn:mongolski
      mnc:mandžurski
      mni:manipurski
      moe:innu-aimun
      moh:mohok
      mos:mossi
      mr:marathski
      ms:malajski
      mt:malteški
      mua:mundang
      mul:više jezika
      mus:creek
      mwl:mirandski
      mwr:marwari
      my:burmanski
      mye:myene
      myv:mordvinski
      mzn:mazanderanski
      na:nauru
      nan:min nan kineski
      nap:napolitanski
      naq:nama
      nb:norveški bokmål
      nd:sjeverni ndebele
      nds:donjonjemački
      nds-NL:donjosaksonski
      ne:nepalski
      new:newari
      ng:ndonga
      nia:nias
      niu:niujski
      nl:nizozemski
      nl-BE:flamanski
      nmg:kwasio
      nn:norveški nynorsk
      nnh:ngiemboon
      no:norveški
      nog:nogajski
      non:staronorveški
      nqo:n’ko
      nr:južni ndebele
      nso:sjeverni sotski
      nus:nuerski
      nv:navajo
      nwc:klasični newari
      ny:njandža
      nym:nyamwezi
      nyn:nyankole
      nyo:nyoro
      nzi:nzima
      oc:okcitanski
      oj:ojibwa
      ojb:sjeverozapadni ojibwa
      ojc:centralni ojibwa
      ojs:oji-cree
      ojw:zapadni ojibwa
      oka:okanagan
      om:oromski
      or:orijski
      os:osetski
      osa:osage
      ota:turski - otomanski
      pa:pandžapski
      pag:pangasinan
      pal:pahlavi
      pam:pampanga
      pap:papiamento
      pau:palauanski
      pcm:nigerijski pidžin
      peo:staroperzijski
      phn:fenički
      pi:pali
      pis:pijin
      pl:poljski
      pon:pohnpeian
      pqm:maliseet-Passamaquoddy
      prg:pruski
      pro:staroprovansalski
      ps:paštunski
      ps-alt-variant:puštu
      pt:portugalski
      pt-BR:brazilski portugalski
      pt-PT:europski portugalski
      qu:kečuanski
      quc:kiče
      raj:rajasthani
      rap:rapa nui
      rar:rarotonški
      rhg:rohindža
      rm:retoromanski
      rn:rundi
      ro:rumunjski
      ro-MD:moldavski
      rof:rombo
      rom:romski
      ru:ruski
      rup:aromunski
      rw:kinyarwanda
      rwk:rwa
      sa:sanskrtski
      sad:sandawe
      sah:jakutski
      sam:samarijanski aramejski
      saq:samburu
      sas:sasak
      sat:santalski
      sba:ngambay
      sbp:sangu
      sc:sardski
      scn:sicilijski
      sco:škotski
      sd:sindski
      sdh:južnokurdski
      se:sjeverni sami
      see:seneca
      seh:sena
      sel:selkupski
      ses:koyraboro senni
      sg:sango
      sga:staroirski
      sh:srpsko-hrvatski
      shi:tachelhit
      shn:shan
      shu:čadski arapski
      si:sinhaleški
      sid:sidamo
      sk:slovački
      sl:slovenski
      slh:južni lushootseed
      sm:samoanski
      sma:južni sami
      smj:lule sami
      smn:inari sami
      sms:skolt sami
      sn:shona
      snk:soninke
      so:somalski
      sog:sogdien
      sq:albanski
      sr:srpski
      srn:sranan tongo
      srr:serer
      ss:svati
      ssy:saho
      st:sesotski
      str:sjeverni sališki
      su:sundanski
      suk:sukuma
      sus:susu
      sux:sumerski
      sv:švedski
      sw:svahili
      sw-CD:kongoanski svahili
      swb:komorski
      syc:klasični sirski
      syr:sirijski
      szl:šleski
      ta:tamilski
      tce:južni tutchone
      te:teluški
      tem:temne
      teo:teso
      ter:tereno
      tet:tetum
      tg:tadžički
      tgx:tagish
      th:tajlandski
      tht:tahltan
      ti:tigrinja
      tig:tigriški
      tiv:tiv
      tk:turkmenski
      tkl:tokelaunski
      tl:tagalog
      tlh:klingonski
      tli:tlingit
      tmh:tamašečki
      tn:cvana
      to:tonganski
      tog:nyasa tonga
      tok:toki pona
      tpi:tok pisin
      tr:turski
      trv:taroko
      ts:tsonga
      tsi:tsimshian
      tt:tatarski
      ttm:sjeverni tutchone
      tum:tumbuka
      tvl:tuvaluanski
      tw:twi
      twq:tasawaq
      ty:tahićanski
      tyv:tuvinski
      tzm:tamašek (Srednji Atlas)
      udm:udmurtski
      ug:ujgurski
      uga:ugaritski
      uk:ukrajinski
      umb:umbundu
      und:nepoznati jezik
      ur:urdski
      uz:uzbečki
      ve:venda
      vec:venecijanski
      vi:vijetnamski
      vmw:makhuwa
      vo:volapük
      vot:votski
      vun:vunjo
      wa:valonski
      wae:walserski
      wal:walamo
      war:waray
      was:washo
      wbp:warlpiri
      wo:volof
      wuu:wu kineski
      xal:kalmyk
      xh:xhosa
      xnr:kangri
      xog:soga
      yao:yao
      yap:japski
      yav:yangben
      ybb:yemba
      yi:jidiš
      yo:jorupski
      yrl:nheengatu
      yue:kantonski
      yue-alt-menu:kineski, kantonski
      za:zhuang
      zap:zapotečki
      zbl:Blissovi simboli
      zen:zenaga
      zgh:standardni marokanski tamašek
      zh:kineski
      zh-alt-menu:kineski, mandarinski
      zh-Hans:kineski (pojednostavljeni)
      zh-Hans-alt-long:mandarinski kineski (pojednostavljeni)
      zh-Hant:kineski (tradicionalni)
      zh-Hant-alt-long:mandarinski kineski (tradicionalni)
      zu:zulu
      zun:zuni
      zxx:bez jezičnog sadržaja
      zza:zazaki
      """.trimIndent() }

  val hr_BA: String? = null

  val hsb: String by lazy { """
      aa:afaršćina
      ab:abchazišćina
      ace:achinezišćina
      ada:adangmešćina
      ady:adyghešćina
      af:afrikaanšćina
      agq:aghemšćina
      ain:ainušćina
      ak:akanšćina
      ale:aleutišćina
      alt:južna altaišćina
      am:amharšćina
      an:aragonšćina
      ang:anglosakšćina
      ann:obološćina
      anp:angikašćina
      ar:arabšćina
      ar-001:moderna wysokoarabšćina
      arn:arawkanšćina
      arp:arapahošćina
      ars:najdi arabšćina
      as:asamšćina
      asa:pare
      ast:asturšćina
      atj:atikamekwišćina
      av:awaršćina
      awa:awandhišćina
      ay:aymaršćina
      az:azerbajdźanšćina
      az-alt-short:azerbajdźanšćina
      ba:baškiršćina
      ban:balinezišćina
      bas:basaa
      be:běłorušćina
      bem:bemba
      bez:bena
      bg:bołharšćina
      bgc:haryanvi
      bho:bhojpurišćina
      bi:bislamšćina
      bin:binišćina
      bla:siksikášćina
      blo:aniišćina
      bm:bambara
      bn:bengalšćina
      bo:tibetšćina
      br:bretonšćina
      brx:bodo
      bs:bosnišćina
      bug:buginezišćina
      byn:blinšćina
      ca:katalanšćina
      cay:cayugašćina
      ccp:čakma
      ce:čečenšćina
      ceb:cebuanšćina
      cgg:chiga
      ch:čamoršćina
      chk:chuukezišćina
      chm:marišćina
      cho:choctawšćina
      chp:chipewyanšćina
      chr:cherokee
      chy:cheyennešćina
      ckb:sorani
      ckb-alt-menu:sorani
      ckb-alt-variant:centralna kurdišćina
      clc:chilcotinšćina
      co:korsišćina
      cr:kri
      crg:michifšćina
      crj:južnowuchodna creešćina
      crk:plains creešćina
      crl:sewjernowuchodna creešćina
      crm:moode creešćina
      crr:carolina algonquianšćina
      cs:čěšćina
      csw:swampy creešćina
      cu:cyrkwinosłowjanšćina
      cv:chuvashišćina
      cy:walizišćina
      da:danšćina
      dak:dakotašćina
      dar:dargwašćina
      dav:taita
      de:němčina
      de-AT:awstriska němčina
      de-CH:šwicarska wysokoněmčina
      dgr:dogribšćina
      dje:zarma
      doi:dogrišćina
      dsb:delnjoserbšćina
      dua:duala
      dv:divehi
      dyo:jola-fonyi
      dz:dzongkha
      dzg:dazagašćina
      ebu:embu
      ee:ewe
      efi:efikšćina
      eka:ekajukšćina
      el:grjekšćina
      en:jendźelšćina
      en-AU:awstralska jendźelšćina
      en-CA:kanadiska jendźelšćina
      en-GB:britiska jendźelšćina
      en-GB-alt-short:jendźelšćina (UK)
      en-US:ameriska jendźelšćina
      en-US-alt-short:jendźelšćina (USA)
      eo:esperanto
      es:španišćina
      es-419:łaćonskoameriska španišćina
      es-ES:europska španišćina
      es-MX:mexiska španišćina
      et:estišćina
      eu:baskišćina
      ewo:ewondo
      fa:persišćina
      fa-AF:dari
      ff:fulbšćina
      fi:finšćina
      fil:filipinšćina
      fj:fidźišćina
      fo:färöšćina
      fon:fonšćina
      fr:francošćina
      fr-CA:kanadiska francošćina
      fr-CH:šwicarska francošćina
      frc:cajun francošćina
      frr:sewjernofrizišćina
      fur:friulšćina
      fy:frizišćina
      ga:iršćina
      gaa:gašćina
      gag:gagauzišćina
      gd:šotiska gelšćina
      gez:geezišćina
      gil:gilbertezišćina
      gl:galicišćina
      gn:guarani
      gor:gorontalošćina
      got:gotšćina
      gsw:šwicarska němčina
      gu:gujarati
      guz:gusii
      gv:manšćina
      gwi:gwichʼinšćina
      ha:hausa
      hai:haidašćina
      haw:hawaiišćina
      hax:južna haidašćina
      he:hebrejšćina
      hi:hindišćina
      hil:hiligaynonšćina
      hmn:hmongšćina
      hr:chorwatšćina
      hsb:hornjoserbšćina
      ht:haitišćina
      hu:madźaršćina
      hup:hupašćina
      hur:halkomelemšćina
      hy:armenšćina
      hz:hererošćina
      ia:interlingua
      iba:ibanšćina
      ibb:ibibiošćina
      id:indonešćina
      ie:interlinguešćina
      ig:igbo
      ii:sichuan yi
      ik:inupiak
      ikt:zapadnokanadska inuktitutšćina
      ilo:ilokošćina
      inh:ingushišćina
      io:ido
      is:islandšćina
      it:italšćina
      iu:inuitšćina
      ja:japanšćina
      jbo:lojbanšćina
      jgo:ngomba
      jmc:machame
      jv:javašćina
      ka:georgišćina
      kab:kabylšćina
      kac:kachinšćina
      kaj:jjušćina
      kam:kamba
      kbd:kabardianšćina
      kcg:tyapšćina
      kde:makonde
      kea:kapverdšćina
      kfo:korošćina
      kgp:kaingangšćina
      kha:khasišćina
      khq:koyra chiini
      ki:kikuyu
      kj:kuanyamašćina
      kk:kazachšćina
      kkj:kako
      kl:gröndlandšćina
      kln:kalenjin
      km:khmeršćina
      kmb:kimbundušćina
      kn:kannadšćina
      ko:korejšćina
      koi:permska komišćina
      kok:konkani
      kpe:kpellešćina
      kr:kanurišćina
      krc:karachay-balkaršćina
      krl:karelianšćina
      kru:kurukhšćina
      ks:kašmiršćina
      ksb:šambala
      ksf:bafia
      ksh:kelnšćina
      ku:kurdišćina
      kum:kumykšćina
      kv:komišćina
      kw:kornišćina
      kwk:kwakʼwalašćina
      kxv:kuvišćina
      ky:kirgišćina
      la:łaćonšćina
      lad:ladinšćina
      lag:langi
      lb:luxemburgšćina
      lez:lezgianšćina
      lg:gandšćina
      li:limburšćina
      lij:ligurianšćina
      lil:lillooetšćina
      lkt:lakota
      lmo:lombardšćina
      ln:lingala
      lo:laošćina
      lou:Louisiana kreolšćina
      loz:lozišćina
      lrc:sewjerna lurišćina
      lsm:saamiašćina
      lt:litawšćina
      lu:luba-katanga
      lua:luba-luluašćina
      lun:lundašćina
      lus:mizošćina
      luy:luhya
      lv:letišćina
      mad:madurezišćina
      mag:magahišćina
      mai:maithilšćina
      mak:makasaršćina
      mas:masaišćina
      mdf:mokshašćina
      men:mendišćina
      mer:meru
      mfe:mauriciska kreolšćina
      mg:malagassišćina
      mgh:makhuwa-meetto
      mgo:meta’
      mh:marshallezišćina
      mi:maoršćina
      mic:mi'kmaqšćina
      min:minangkabaušćina
      mk:makedonšćina
      ml:malajamšćina
      mn:mongolšćina
      mni:manipuršćina
      moe:innu-aimunšćina
      moh:mohawkšćina
      mos:mossišćina
      mr:maratišćina
      ms:malajšćina
      mt:maltašćina
      mua:mundang
      mul:wjacerěčne
      mus:krik
      mwl:mirandezišćina
      my:burmašćina
      myv:erzyašćina
      mzn:mazanderanšćina
      na:naurušćina
      nap:neapolitanšćina
      naq:nama
      nb:norwegšćina (bokmål)
      nd:sewjero-ndebele
      nds:delnjoněmčina
      ne:nepalšćina
      new:newarišćina
      ng:ndongašćina
      nia:niazišćina
      niu:niueanšćina
      nl:nižozemšćina
      nl-BE:flamšćina
      nmg:kwasio
      nn:norwegšćina (nynorsk)
      nnh:ngiemboon
      no:norwegšćina
      nog:nogaišćina
      nqo:n’ko
      nr:južna ndebelšćina
      nso:sewjerna sothošćina
      nus:nuer
      nv:navaho
      ny:nyanja
      nyn:nyankole
      oc:okcitanšćina
      ojb:sewjernozapadna ojibwašćina
      ojc:centralna ojibwašćina
      ojs:oji-creešćina
      ojw:zapadna ojibwašćina
      oka:okanaganšćina
      om:oromo
      or:orijšćina
      os:osetšćina
      pa:pandźabšćina
      pag:pangasinanšćina
      pam:pampangašćina
      pap:papiamentošćina
      pau:palauanšćina
      pcm:nigerijanski pidgin
      pis:pijinšćina
      pl:pólšćina
      pqm:maliseet-passamaquoddyšćina
      prg:prušćina
      ps:paštunšćina
      pt:portugalšćina
      pt-BR:brazilska portugalšćina
      pt-PT:europska portugalšćina
      qu:kečua
      quc:kʼicheʼ
      raj:rajasthani
      rap:rapanuišćina
      rar:rarotonganšćina
      rhg:rohingyašćina
      rm:retoromanšćina
      rn:kirundišćina
      ro:rumunšćina
      ro-MD:moldawšćina
      rof:rombo
      ru:rušćina
      rup:armanianšćina
      rw:kinjarwanda
      rwk:rwa
      sa:sanskrit
      sad:sandawešćina
      sah:jakutšćina
      saq:samburu
      sat:santalšćina
      sba:ngambayšćina
      sbp:sangu
      sc:sardinšćina
      scn:sicilšćina
      sco:scotšćina
      sd:sindhišćina
      se:sewjerosamišćina
      seh:sena
      ses:koyra senni
      sg:sango
      sh:serbochorwatšćina
      shi:tašelhit
      shn:shanšćina
      si:singhalšćina
      sk:słowakšćina
      sl:słowjenšćina
      slh:južna lushootseedšćina
      sm:samoašćina
      sma:južnosamišćina
      smj:lule-samišćina
      smn:inari-samišćina
      sms:skolt-samišćina
      sn:šonašćina
      snk:soninkešćina
      so:somališćina
      sq:albanšćina
      sr:serbišćina
      srn:sranan tongošćina
      ss:siswati
      st:južnosotšćina (Sesotho)
      stq:saterfrizišćina
      str:straits salishšćina
      su:sundanezišćina
      suk:sukumašćina
      sv:šwedšćina
      sw:suahelšćina
      sw-CD:kongoska suahelšćina
      swb:comorianšćina
      syr:syriacšćina
      szl:šlezišćina
      ta:tamilšćina
      tce:južna tutchonšćina
      te:telugu
      tem:timnešćina
      teo:teso
      tet:tetumšćina
      tg:tadźikšćina
      tgx:tagishšćina
      th:thailandšćina
      tht:tahltanšćina
      ti:tigrinšćina
      tig:tigrešćina
      tk:turkmenšćina
      tl:tagalog
      tlh:klingonšćina
      tli:tlingitšćina
      tn:tswana
      to:tongašćina
      tok:toki ponašćina
      tpi:tok pisinšćina
      tr:turkowšćina
      trv:tarokošćina
      ts:tsonga
      tt:tataršćina
      ttm:sewjerna tutchonšćina
      tum:tumbukašćina
      tvl:tuvalušćina
      tw:twi
      twq:tasawaq
      ty:tahitišćina
      tyv:tuvinianšćina
      tzm:tamazight (srjedźny Marokko)
      udm:udmurtšćina
      ug:ujguršćina
      uk:ukrainšćina
      umb:umbundušćina
      und:njeznata rěč
      ur:urdušćina
      uz:uzbekšćina
      ve:vendašćina
      vec:venetišćina
      vi:vietnamšćina
      vmw:makhuwašćina
      vo:volapük
      vun:vunjo
      wa:walonšćina
      wae:walzeršćina
      wal:wolayttašćina
      war:warayšćina
      wo:wolof
      wuu:wu chinšćina
      xal:kalmykšćina
      xh:xhosa
      xnr:kangrišćina
      xog:soga
      yav:yangben
      ybb:yembašćina
      yi:jidišćina
      yo:jorubašćina
      yrl:nheengatušćina
      yue:kantonšćina
      yue-alt-menu:chinšćina (kantonšćina)
      za:zhuang
      zgh:tamazight
      zh:chinšćina
      zh-alt-menu:chinšćina (mandarin)
      zh-Hans:chinšćina (zjednorjena)
      zh-Hans-alt-long:chinšćina (zjednorjena)
      zh-Hant:chinšćina (tradicionalna)
      zh-Hant-alt-long:chinšćina (tradicionalna)
      zu:zulušćina
      zun:zunišćina
      zxx:žadyn rěčny wobsah
      zza:zazašćina
      """.trimIndent() }

  val hu: String by lazy { """
      aa:afar
      ab:abház
      ace:achinéz
      ach:akoli
      ada:adangme
      ady:adyghe
      ae:avesztán
      af:afrikaans
      afh:afrihili
      agq:agem
      ain:ainu
      ak:akan
      akk:akkád
      ale:aleut
      alt:dél-altaji
      am:amhara
      an:aragonéz
      ang:óangol
      ann:obolo
      anp:angika
      apc:levantei arab
      ar:arab
      ar-001:modern szabványos arab
      arc:arámi
      arn:mapucse
      arp:arapaho
      ars:nedzsdi arab
      ars-alt-menu:arab, nedzsdi
      arw:aravak
      as:asszámi
      asa:asu
      ast:asztúr
      atj:attikamek
      av:avar
      awa:awádi
      ay:ajmara
      az:azerbajdzsáni
      az-alt-short:azeri
      ba:baskír
      bal:balucsi
      ban:balinéz
      bas:basza
      bax:bamun
      bbj:gomala
      be:belarusz
      bej:bedzsa
      bem:bemba
      bez:bena
      bfd:bafut
      bg:bolgár
      bgc:haryanvi
      bgn:nyugati beludzs
      bho:bodzspuri
      bi:bislama
      bik:bikol
      bin:bini
      bkm:kom
      bla:siksika
      blo:anii
      bm:bambara
      bn:bangla
      bo:tibeti
      br:breton
      bra:braj
      brx:bodo
      bs:bosnyák
      bss:koszi
      bua:burját
      bug:buginéz
      bum:bulu
      byn:blin
      byv:medumba
      ca:katalán
      cad:caddo
      car:karib
      cay:kajuga
      cch:atszam
      ccp:csakma
      ce:csecsen
      ceb:szebuano
      cgg:kiga
      ch:csamoró
      chb:csibcsa
      chg:csagatáj
      chk:csukéz
      chm:mari
      chn:csinuk zsargon
      cho:csoktó
      chp:csipevé
      chr:cseroki
      chy:csejen
      ckb:közép-ázsiai kurd
      ckb-alt-menu:közép-ázsiai kurd
      ckb-alt-variant:kurd, szoráni
      clc:csilkotin
      co:korzikai
      cop:kopt
      cr:krí
      crg:micsif
      crh:krími tatár
      crj:délkeleti krí
      crk:síksági krí
      crl:északkeleti krí
      crm:moose krí
      crr:karolinai algonkin
      crs:szeszelva kreol francia
      cs:cseh
      csb:kasub
      csw:mocsári krí
      cu:egyházi szláv
      cv:csuvas
      cy:walesi
      da:dán
      dak:dakota
      dar:dargva
      dav:taita
      de:német
      de-AT:osztrák német
      de-CH:svájci felnémet
      del:delavár
      den:szlevi
      dgr:dogrib
      din:dinka
      dje:zarma
      doi:dogri
      dsb:alsó-szorb
      dua:duala
      dum:közép holland
      dv:divehi
      dyo:jola-fonyi
      dyu:diula
      dz:dzsonga
      dzg:dazaga
      ebu:embu
      ee:eve
      efi:efik
      egy:óegyiptomi
      eka:ekadzsuk
      el:görög
      elx:elamit
      en:angol
      en-AU:ausztrál angol
      en-CA:kanadai angol
      en-GB:brit angol
      en-GB-alt-short:angol (UK)
      en-US:amerikai angol
      en-US-alt-short:angol (USA)
      enm:közép angol
      eo:eszperantó
      es:spanyol
      es-419:latin-amerikai spanyol
      es-ES:európai spanyol
      es-MX:spanyol (mexikói)
      et:észt
      eu:baszk
      ewo:evondo
      fa:perzsa
      fa-AF:dari
      fan:fang
      fat:fanti
      ff:fulani
      fi:finn
      fil:filippínó
      fj:fidzsi
      fo:feröeri
      fon:fon
      fr:francia
      fr-CA:kanadai francia
      fr-CH:svájci francia
      frc:cajun francia
      frm:közép francia
      fro:ófrancia
      frr:északi fríz
      frs:keleti fríz
      fur:friuli
      fy:nyugati fríz
      ga:ír
      gaa:ga
      gag:gagauz
      gan:gan kínai
      gay:gajo
      gba:gbaja
      gd:skóciai kelta
      gez:geez
      gil:ikiribati
      gl:gallego
      gmh:közép felső német
      gn:guarani
      goh:ófelső német
      gon:gondi
      gor:gorontalo
      got:gót
      grb:grebó
      grc:ógörög
      gsw:svájci német
      gu:gudzsaráti
      guz:guszii
      gv:man-szigeti
      gwi:gvicsin
      ha:hausza
      hai:haida
      hak:hakka kínai
      haw:hawaii
      hax:déli haida
      he:héber
      hi:hindi
      hi-Latn:hindi (latin)
      hi-Latn-alt-variant:hinglish
      hil:ilokano
      hit:hettita
      hmn:hmong
      ho:hiri motu
      hr:horvát
      hsb:felső-szorb
      hsn:xiang kínai
      ht:haiti kreol
      hu:magyar
      hup:hupa
      hur:halkomelem
      hy:örmény
      hz:herero
      ia:interlingva
      iba:iban
      ibb:ibibio
      id:indonéz
      ie:interlingue
      ig:igbó
      ii:szecsuán ji
      ik:inupiak
      ikt:nyugat-kanadai inuit
      ilo:ilokó
      inh:ingus
      io:idó
      is:izlandi
      it:olasz
      iu:inuktitut
      ja:japán
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jpr:zsidó-perzsa
      jrb:zsidó-arab
      jv:jávai
      ka:grúz
      kaa:kara-kalpak
      kab:kabije
      kac:kacsin
      kaj:jju
      kam:kamba
      kaw:kawi
      kbd:kabardi
      kbl:kanembu
      kcg:tyap
      kde:makonde
      kea:kabuverdianu
      kfo:koro
      kg:kongo
      kgp:kaingang
      kha:kaszi
      kho:kotanéz
      khq:kojra-csíni
      ki:kikuju
      kj:kuanyama
      kk:kazah
      kkj:kakó
      kl:grönlandi
      kln:kalendzsin
      km:khmer
      kmb:kimbundu
      kn:kannada
      ko:koreai
      koi:komi-permják
      kok:konkani
      kos:kosrei
      kpe:kpelle
      kr:kanuri
      krc:karacsáj-balkár
      krl:karelai
      kru:kuruh
      ks:kasmíri
      ksb:sambala
      ksf:bafia
      ksh:kölsch
      ku:kurd
      kum:kumük
      kut:kutenai
      kv:komi
      kw:korni
      kwk:kwakʼwala
      kxv:kuvi
      ky:kirgiz
      la:latin
      lad:ladino
      lag:langi
      lah:lahnda
      lam:lamba
      lb:luxemburgi
      lez:lezg
      lg:ganda
      li:limburgi
      lij:ligur
      lil:lillooet
      lkt:lakota
      lmo:lombard
      ln:lingala
      lo:lao
      lol:mongó
      lou:louisianai kreol
      loz:lozi
      lrc:északi luri
      lsm:samia
      lt:litván
      lu:luba-katanga
      lua:luba-lulua
      lui:luiseno
      lun:lunda
      lus:lushai
      luy:lujia
      lv:lett
      mad:madurai
      maf:mafa
      mag:magahi
      mai:maithili
      mak:makaszar
      man:mandingó
      mas:masai
      mde:maba
      mdf:moksán
      mdr:mandar
      men:mende
      mer:meru
      mfe:mauritiusi kreol
      mg:malgas
      mga:közép ír
      mgh:makua-metó
      mgo:meta’
      mh:marshalli
      mi:maori
      mic:mikmak
      min:minangkabau
      mk:macedón
      ml:malajálam
      mn:mongol
      mnc:mandzsu
      mni:manipuri
      moe:innu-aimun
      moh:mohawk
      mos:moszi
      mr:maráthi
      ms:maláj
      mt:máltai
      mua:mundang
      mul:többszörös nyelvek
      mus:krík
      mwl:mirandéz
      mwr:márvári
      my:burmai
      mye:myene
      myv:erzjány
      mzn:mázanderáni
      na:naurui
      nan:min nan kínai
      nap:nápolyi
      naq:nama
      nb:norvég (bokmål)
      nd:északi ndebele
      nds:alsónémet
      nds-NL:alsószász
      ne:nepáli
      new:nevari
      ng:ndonga
      nia:nias
      niu:niuei
      nl:holland
      nl-BE:flamand
      nmg:ngumba
      nn:norvég (nynorsk)
      nnh:ngiemboon
      no:norvég
      nog:nogaj
      non:óskandináv
      nqo:n’kó
      nr:déli ndebele
      nso:északi szeszotó
      nus:nuer
      nv:navahó
      nwc:klasszikus newari
      ny:nyandzsa
      nym:nyamvézi
      nyn:nyankole
      nyo:nyoró
      nzi:nzima
      oc:okszitán
      oj:ojibva
      ojb:északnyugati odzsibva
      ojc:középvidéki odzsibva
      ojs:odzsi-krí
      ojw:nyugati odzsibva
      oka:okanagan
      om:oromo
      or:odia
      os:oszét
      osa:osage
      ota:oszmán-török
      pa:pandzsábi
      pag:pangaszinan
      pal:pahlavi
      pam:pampangan
      pap:papiamento
      pau:palaui
      pcm:nigériai pidgin
      peo:óperzsa
      phn:főniciai
      pi:pali
      pis:pidzsin
      pl:lengyel
      pon:pohnpei
      pqm:maliseet-passamaquoddy
      prg:porosz
      pro:óprovánszi
      ps:pastu
      pt:portugál
      pt-BR:brazíliai portugál
      pt-PT:európai portugál
      qu:kecsua
      quc:kicse
      raj:radzsasztáni
      rap:rapanui
      rar:rarotongai
      rhg:rohingja
      rm:rétoromán
      rn:kirundi
      ro:román
      ro-MD:moldvai
      rof:rombo
      rom:roma
      ru:orosz
      rup:aromán
      rw:kinyarvanda
      rwk:rwo
      sa:szanszkrit
      sad:szandave
      sah:szaha
      sam:szamaritánus arámi
      saq:szamburu
      sas:sasak
      sat:szantáli
      sba:ngambay
      sbp:szangu
      sc:szardíniai
      scn:szicíliai
      sco:skót
      sd:szindhi
      sdh:dél-kurd
      se:északi számi
      see:szeneka
      seh:szena
      sel:szölkup
      ses:kojra-szenni
      sg:szangó
      sga:óír
      sh:szerbhorvát
      shi:tachelhit
      shn:san
      shu:csádi arab
      si:szingaléz
      sid:szidamó
      sk:szlovák
      sl:szlovén
      slh:déli lushootseed
      sm:szamoai
      sma:déli számi
      smj:lulei számi
      smn:inari számi
      sms:kolta számi
      sn:sona
      snk:szoninke
      so:szomáli
      sog:sogdien
      sq:albán
      sr:szerb
      srn:szranai tongó
      srr:szerer
      ss:sziszuati
      ssy:szahó
      st:déli szeszotó
      str:szorosmenti salish
      su:szundanéz
      suk:szukuma
      sus:szuszu
      sux:sumér
      sv:svéd
      sw:szuahéli
      sw-CD:kongói szuahéli
      swb:comorei
      syc:klasszikus szír
      syr:szír
      szl:sziléziai
      ta:tamil
      tce:déli tutchone
      te:telugu
      tem:temne
      teo:teszó
      ter:terenó
      tet:tetum
      tg:tadzsik
      tgx:tagish
      th:thai
      tht:tahltan
      ti:tigrinya
      tig:tigré
      tiv:tiv
      tk:türkmén
      tkl:tokelaui
      tl:tagalog
      tlh:klingon
      tli:tlingit
      tmh:tamasek
      tn:szecsuáni
      to:tongai
      tog:nyugati nyasza
      tok:toki pona
      tpi:tok pisin
      tr:török
      trv:tarokó
      ts:conga
      tsi:csimsiáni
      tt:tatár
      ttm:északi tutchone
      tum:tumbuka
      tvl:tuvalu
      tw:twi
      twq:szavák
      ty:tahiti
      tyv:tuvai
      tzm:közép-atlaszi tamazigt
      udm:udmurt
      ug:ujgur
      uga:ugariti
      uk:ukrán
      umb:umbundu
      und:ismeretlen nyelv
      ur:urdu
      uz:üzbég
      ve:venda
      vec:velencei
      vi:vietnámi
      vmw:makua
      vo:volapük
      vot:votják
      vun:vunjo
      wa:vallon
      wae:walser
      wal:valamo
      war:varaó
      was:vasó
      wbp:warlpiri
      wo:volof
      wuu:wu kínai
      xal:kalmük
      xh:xhosza
      xnr:kangri
      xog:szoga
      yao:jaó
      yap:japi
      yav:jangben
      ybb:jemba
      yi:jiddis
      yo:joruba
      yrl:nheengatu
      yue:kantoni
      yue-alt-menu:kantoni kínai
      za:zsuang
      zap:zapoték
      zbl:Bliss jelképrendszer
      zen:zenaga
      zgh:marokkói tamazight
      zh:kínai
      zh-alt-menu:mandarin
      zh-Hans:egyszerűsített kínai
      zh-Hans-alt-long:kínai (egyszerűsített)
      zh-Hant:hagyományos kínai
      zh-Hant-alt-long:kínai (hagyományos)
      zu:zulu
      zun:zuni
      zxx:nincs nyelvészeti tartalom
      zza:zaza
      """.trimIndent() }

  val hy: String by lazy { """
      aa:աֆարերեն
      ab:աբխազերեն
      ace:աչեհերեն
      ach:աչոլի
      ada:ադանգմերեն
      ady:ադիղերեն
      aeb:թունիսական արաբերեն
      af:աֆրիկաանս
      agq:աղեմ
      ain:այներեն
      ak:աքան
      akk:աքքադերեն
      ale:ալեութերեն
      alt:հարավային ալթայերեն
      am:ամհարերեն
      an:արագոներեն
      ang:հին անգլերեն
      ann:օբոլո
      anp:անգիկա
      ar:արաբերեն
      ar-001:արդի ընդհանուր արաբերեն
      arc:արամեերեն
      arn:մապուչի
      arp:արապահո
      arq:ալժիրական արաբերեն
      ars:նեջդի արաբերեն
      arz:եգիպտական արաբերեն
      as:ասամերեն
      asa:ասու
      ase:ամերիկյան ժեստերի լեզու
      ast:աստուրերեն
      atj:աթիկամեկ
      av:ավարերեն
      awa:ավադհի
      ay:այմարա
      az:ադրբեջաներեն
      az-alt-short:ադրբեջաներեն
      ba:բաշկիրերեն
      ban:բալիերեն
      bas:բասաա
      be:բելառուսերեն
      bem:բեմբա
      bez:բենա
      bg:բուլղարերեն
      bgc:հարյանվի
      bgn:արևմտաբելուջիերեն
      bho:բհոպուրի
      bi:բիսլամա
      bin:բինի
      bla:սիկսիկա
      blo:անիի
      bm:բամբարա
      bn:բենգալերեն
      bo:տիբեթերեն
      br:բրետոներեն
      brx:բոդո
      bs:բոսնիերեն
      bss:աքուզ
      bug:բուգիերեն
      byn:բիլին
      ca:կատալաներեն
      cay:կայուգա
      ccp:չակմա
      ce:չեչեներեն
      ceb:սեբուերեն
      cgg:չիգա
      ch:չամոռո
      chk:տրուկերեն
      chm:մարի
      cho:չոկտո
      chp:չիպևայան
      chr:չերոկի
      chy:շայեն
      ckb:սորանի քրդերեն
      ckb-alt-menu:քրդերեն (սորանի)
      ckb-alt-variant:սորանի
      clc:չիլկոտիներեն
      co:կորսիկերեն
      cop:ղպտերեն
      crg:միչիֆ
      crh:ղրիմյան թուրքերեն
      crj:հարավ-արևելյան քրի
      crk:հարթավայրերի քրի
      crl:հյուսիս-արևելյան քրի
      crm:մուզ քրի
      crr:կարոլինական ալգոնկիներեն
      crs:սեյշելյան խառնակերտ ֆրանսերեն
      cs:չեխերեն
      csw:ճահճի քրի
      cu:սլավոներեն, եկեղեցական
      cv:չուվաշերեն
      cy:ուելսերեն
      da:դանիերեն
      dak:դակոտա
      dar:դարգիներեն
      dav:թաիթա
      de:գերմաներեն
      de-AT:ավստրիական գերմաներեն
      de-CH:շվեյցարական վերին գերմաներեն
      dgr:դոգրիբ
      dje:զարմա
      doi:դոգրի
      dsb:ստորին սորբերեն
      dua:դուալա
      dv:դիվեհի
      dyo:ջոլա-ֆոնյի
      dz:ջոնգքհա
      dzg:դազագա
      ebu:էմբու
      ee:էվե
      efi:էֆիկ
      egy:հին եգիպտերեն
      eka:էկաջուկ
      el:հունարեն
      en:անգլերեն
      en-AU:ավստրալիական անգլերեն
      en-CA:կանադական անգլերեն
      en-GB:բրիտանական անգլերեն
      en-GB-alt-short:բրիտանական անգլերեն
      en-US:ամերիկյան անգլերեն
      en-US-alt-short:ամերիկյան անգլերեն
      eo:էսպերանտո
      es:իսպաներեն
      es-419:լատինամերիկյան իսպաներեն
      es-ES:եվրոպական իսպաներեն
      es-MX:մեքսիկական իսպաներեն
      et:էստոներեն
      eu:բասկերեն
      ewo:էվոնդո
      fa:պարսկերեն
      fa-AF:դարի
      ff:ֆուլահ
      fi:ֆիններեն
      fil:ֆիլիպիներեն
      fit:տորնադելեն ֆիններեն
      fj:ֆիջիերեն
      fo:ֆարյորերեն
      fon:ֆոն
      fr:ֆրանսերեն
      fr-CA:կանադական ֆրանսերեն
      fr-CH:շվեյցարական ֆրանսերեն
      frc:քաջունական ֆրանսերեն
      fro:հին ֆրանսերեն
      frr:հյուսիսային ֆրիզերեն
      frs:արևելաֆրիզերեն
      fur:ֆրիուլիերեն
      fy:արևմտաֆրիզերեն
      ga:իռլանդերեն
      gaa:գայերեն
      gag:գագաուզերեն
      gbz:զրադաշտական դարի
      gd:շոտլանդական գաելերեն
      gez:գեեզ
      gil:կիրիբատի
      gl:գալիսերեն
      gn:գուարանի
      goh:հին վերին գերմաներեն
      gor:գորոնտալո
      got:գոթերեն
      grc:հին հունարեն
      gsw:շվեյցարական գերմաներեն
      gu:գուջարաթի
      guc:վայուու
      guz:գուսի
      gv:մեներեն
      gwi:գվիչին
      ha:հաուսա
      hai:հայդա
      haw:հավայիերեն
      hax:հարավային հայդա
      he:եբրայերեն
      hi:հինդի
      hi-Latn:հինդի (լատինատառ)
      hi-Latn-alt-variant:հինգլիշ
      hil:հիլիգայնոն
      hmn:հմոնգ
      hr:խորվաթերեն
      hsb:վերին սորբերեն
      hsn:սյան չինարեն
      ht:խառնակերտ հայիթերեն
      hu:հունգարերեն
      hup:հուպա
      hur:հալքոմելեմ
      hy:հայերեն
      hz:հերերո
      ia:ինտերլինգուա
      iba:իբաներեն
      ibb:իբիբիո
      id:ինդոնեզերեն
      ie:ինտերլինգուե
      ig:իգբո
      ii:սիչուան
      ikt:արևմտականադական ինուկտիտուտ
      ilo:իլոկերեն
      inh:ինգուշերեն
      io:իդո
      is:իսլանդերեն
      it:իտալերեն
      iu:ինուկտիտուտ
      ja:ճապոներեն
      jbo:լոժբան
      jgo:նգոմբա
      jmc:մաշամե
      jv:ճավայերեն
      ka:վրացերեն
      kab:կաբիլերեն
      kac:կաչիներեն
      kaj:ջյու
      kam:կամբա
      kbd:կաբարդերեն
      kcg:տիապ
      kde:մակոնդե
      kea:կաբուվերդերեն
      kfo:կորո
      kgp:կաինգան
      kha:քասիերեն
      khq:կոյրա չինի
      ki:կիկույու
      kj:կուանյամա
      kk:ղազախերեն
      kkj:կակո
      kl:կալաալիսուտ
      kln:կալենջին
      km:քմերերեն
      kmb:կիմբունդու
      kn:կաննադա
      ko:կորեերեն
      koi:պերմյակ կոմիերեն
      kok:կոնկանի
      kpe:կպելլեերեն
      kr:կանուրի
      krc:կարաչայ-բալկարերեն
      krl:կարելերեն
      kru:կուրուխ
      ks:քաշմիրերեն
      ksb:շամբալա
      ksf:բաֆիա
      ksh:քյոլներեն
      ku:քրդերեն
      kum:կումիկերեն
      kv:կոմիերեն
      kw:կոռներեն
      kwk:կվակվալա
      kxv:կուվի
      ky:ղրղզերեն
      la:լատիներեն
      lad:լադինո
      lag:լանգի
      lb:լյուքսեմբուրգերեն
      lez:լեզգիերեն
      lg:գանդա
      li:լիմբուրգերեն
      lij:լիգուրերեն
      lil:լիլուետ
      lkt:լակոտա
      lmo:լոմբարդերեն
      ln:լինգալա
      lo:լաոսերեն
      lou:լուիզիանական կրեոլերեն
      loz:լոզի
      lrc:հյուսիսային լուրիերեն
      lsm:սաամերեն
      lt:լիտվերեն
      lu:լուբա-կատանգա
      lua:լուբա-լուլուա
      lun:լունդա
      luo:լուո
      lus:միզո
      luy:լույա
      lv:լատվիերեն
      mad:մադուրերեն
      mag:մագահի
      mai:մայթիլի
      mak:մակասարերեն
      mas:մասաի
      mdf:մոկշայերեն
      men:մենդե
      mer:մերու
      mfe:մորիսյեն
      mg:մալգաշերեն
      mgh:մաքուա-մետտո
      mgo:մետա
      mh:մարշալերեն
      mi:մաորի
      mic:միկմակ
      min:մինանգկաբաու
      mk:մակեդոներեն
      ml:մալայալամ
      mn:մոնղոլերեն
      mni:մանիպուրի
      moe:իննու-այմուն
      moh:մոհավք
      mos:մոսսի
      mr:մարաթի
      mrj:արևմտամարիերեն
      ms:մալայերեն
      mt:մալթայերեն
      mua:մունդանգ
      mul:բազմալեզու
      mus:մասքոջի
      mwl:միրանդերեն
      my:բիրմայերեն
      myv:էրզյա
      mzn:մազանդարաներեն
      na:նաուրու
      nap:նեապոլերեն
      naq:նամա
      nb:գրքային նորվեգերեն
      nd:հյուսիսային նդեբելե
      nds:ստորին գերմաներեն
      nds-NL:ստորին սաքսոներեն
      ne:նեպալերեն
      new:նեվարերեն
      ng:նդոնգա
      nia:նիասերեն
      niu:նիուերեն
      nl:հոլանդերեն
      nl-BE:ֆլամանդերեն
      nmg:կվասիո
      nn:նոր նորվեգերեն
      nnh:նգիեմբուն
      no:նորվեգերեն
      nog:նոգայերեն
      non:հին նորվեգերեն
      nqo:նկո
      nr:հարավային նդեբելե
      nso:հյուսիսային սոթո
      nus:նուեր
      nv:նավախո
      ny:նյանջա
      nyn:նյանկոլե
      oc:օքսիտաներեն
      oj:օջիբվա
      ojb:հյուսիս-արևմտյան օջիբվե
      ojc:կենտրոնական օջիբվե
      ojs:օջի քրի
      ojw:արևմտյան օջիբվե
      oka:օկանագան
      om:օրոմո
      or:օրիյա
      os:օսերեն
      osa:օսեյջ
      ota:օսմաներեն
      pa:փենջաբերեն
      pag:պանգասինաներեն
      pal:պահլավերեն
      pam:պամպանգաերեն
      pap:պապյամենտո
      pau:պալաուերեն
      pcd:պիկարդերեն
      pcm:նիգերիական փիջին
      pdc:փենսիլվանական գերմաներեն
      pdt:պլատագերմաներեն
      peo:հին պարսկերեն
      pfl:պալատինյան գերմաներեն
      phn:փյունիկերեն
      pi:պալի
      pis:փիջին
      pl:լեհերեն
      pms:պիեմոնտերեն
      pnt:պոնտերեն
      pon:պոնպեերեն
      pqm:մալեսիտ-պասամակվոդի
      prg:պրուսերեն
      pro:հին պրովանսերեն
      ps:փուշթու
      pt:պորտուգալերեն
      pt-BR:բրազիլական պորտուգալերեն
      pt-PT:եվրոպական պորտուգալերեն
      qu:կեչուա
      quc:քիչե
      raj:ռաջաստաներեն
      rap:ռապանուի
      rar:ռարոտոնգաներեն
      rgn:ռոմանիոլերեն
      rhg:ռոհինջա
      rif:ռիֆերեն
      rm:ռոմանշերեն
      rn:ռունդի
      ro:ռումիներեն
      ro-MD:մոլդովերեն
      rof:ռոմբո
      rom:ռոմաներեն
      rtm:ռոտուման
      ru:ռուսերեն
      rue:ռուսիներեն
      rug:ռովիանա
      rup:արոմաներեն
      rw:կինյառուանդա
      rwk:ռվա
      sa:սանսկրիտ
      sad:սանդավե
      sah:յակուտերեն
      saq:սամբուրու
      sat:սանտալի
      sba:նգամբայ
      sbp:սանգու
      sc:սարդիներեն
      scn:սիցիլիերեն
      sco:շոտլանդերեն
      sd:սինդհի
      sdh:հարավային քրդերեն
      se:հյուսիսային սաամի
      seh:սենա
      ses:կոյրաբորո սեննի
      sg:սանգո
      sga:հին իռլանդերեն
      sh:սերբա-խորվաթերեն
      shi:տաշելհիթ
      shn:շաներեն
      si:սինհալերեն
      sk:սլովակերեն
      sl:սլովեներեն
      slh:հարավային լուշուցիդ
      sm:սամոաերեն
      sma:հարավային սաամի
      smj:լուլե սաամի
      smn:ինարի սաամի
      sms:սկոլտ սաամի
      sn:շոնա
      snk:սոնինկե
      so:սոմալիերեն
      sq:ալբաներեն
      sr:սերբերեն
      srn:սրանան տոնգո
      ss:սվազերեն
      ssy:սահոերեն
      st:հարավային սոթո
      str:սթրեյթս սալիշերեն
      su:սունդաներեն
      suk:սուկումա
      sv:շվեդերեն
      sw:սուահիլի
      sw-CD:կոնգոյի սուահիլի
      swb:կոմորերեն
      syr:ասորերեն
      szl:սիլեզերեն
      ta:թամիլերեն
      tce:հարավային թուտչոնե
      tcy:տուլու
      te:թելուգու
      tem:տեմնե
      teo:տեսո
      ter:տերենո
      tet:տետում
      tg:տաջիկերեն
      tgx:թագիշ
      th:թայերեն
      tht:թալթան
      ti:տիգրինյա
      tig:տիգրե
      tiv:տիվերեն
      tk:թուրքմեներեն
      tkl:տոկելաու
      tkr:ցախուր
      tl:տագալերեն
      tlh:կլինգոն
      tli:տլինգիտ
      tly:թալիշերեն
      tmh:տամաշեկ
      tn:ցվանա
      to:տոնգերեն
      tok:տոկիպոնա
      tpi:տոկ փիսին
      tr:թուրքերեն
      tru:տուրոյո
      trv:տարոկո
      ts:ցոնգա
      tsd:ցակոներեն
      tsi:ցիմշյան
      tt:թաթարերեն
      ttm:հյուսիսային թուտչոնե
      tum:տումբուկա
      tvl:թուվալուերեն
      tw:տուի
      twq:տասավաք
      ty:թաիտերեն
      tyv:տուվերեն
      tzm:կենտրոնատլասյան թամազիղտ
      udm:ուդմուրտերեն
      ug:ույղուրերեն
      uga:ուգարիտերեն
      uk:ուկրաիներեն
      umb:ումբունդու
      und:անհայտ լեզու
      ur:ուրդու
      uz:ուզբեկերեն
      vai:վաի
      ve:վենդա
      vec:վենետերեն
      vep:վեպսերեն
      vi:վիետնամերեն
      vls:արևմտաֆլամանդերեն
      vmw:մաքուա
      vo:վոլապյուկ
      vot:վոդերեն
      vro:վորո
      vun:վունջո
      wa:վալոներեն
      wae:վալսերեն
      wal:վոլայտա
      war:վարայերեն
      was:վաշո
      wbp:վարլպիրի
      wo:վոլոֆ
      wuu:վու չինարեն
      xal:կալմիկերեն
      xh:քոսա
      xnr:կանգրի
      xog:սոգա
      yao:յաո
      yap:յափերեն
      yav:յանգբեն
      ybb:եմբա
      yi:իդիշ
      yo:յորուբա
      yrl:նինգաթու
      yue:կանտոներեն
      yue-alt-menu:չինարեն, կանտոներեն
      za:ժուանգ
      zap:սապոտեկերեն
      zea:զեյլանդերեն
      zen:զենագա
      zgh:ընդհանուր մարոկյան թամազիղտ
      zh:չինարեն
      zh-alt-menu:չինարեն, մանդարին
      zh-Hans:պարզեցված չինարեն
      zh-Hans-alt-long:պարզեցված մանդարին չինարեն
      zh-Hant:ավանդական չինարեն
      zh-Hant-alt-long:ավանդական մանդարին չինարեն
      zu:զուլուերեն
      zun:զունիերեն
      zxx:առանց լեզվային բովանդակության
      zza:զազաերեն
      """.trimIndent() }

  val ia: String by lazy { """
      aa:afar
      ab:abkhazo
      ace:acehnese
      ada:adangme
      ady:adygeano
      af:afrikaans
      agq:aghem
      ain:ainu
      ak:akan
      ale:aleuto
      alt:altai del sud
      am:amharico
      an:aragonese
      ann:obolo
      anp:angika
      apc:arabe levantin
      ar:arabe
      ar-001:arabe standard moderne
      arn:mapuche
      arp:arapaho
      ars:arabe najdi
      as:assamese
      asa:asu
      ast:asturiano
      atj:atikamekw
      av:avaro
      awa:awadhi
      ay:aymara
      az:azerbaidzhano
      az-alt-short:azeri
      ba:bashkir
      bal:baluchi
      ban:balinese
      bas:basaa
      be:bielorusso
      bem:bemba
      bew:betawi
      bez:bena
      bg:bulgaro
      bgc:haryanvi
      bgn:baluchi occidental
      bho:bhojpuri
      bi:bislama
      bin:bini
      bla:siksika
      blo:anii
      blt:tai dam
      bm:bambara
      bn:bengalese
      bo:tibetano
      br:breton
      brx:bodo
      bs:bosniaco
      bss:akoose
      bug:buginese
      byn:blin
      ca:catalano
      cad:caddo
      cay:cayuga
      cch:atsam
      ccp:chakma
      ce:checheno
      ceb:cebuano
      cgg:chiga
      ch:chamorro
      chk:chuukese
      chm:mari
      cho:choctaw
      chp:chipewyan
      chr:cherokee
      chy:cheyenne
      cic:chickasaw
      ckb:kurdo central
      ckb-alt-menu:kurdo central
      ckb-alt-variant:kurdo sorani
      clc:chilcotin
      co:corso
      crg:mitchif
      crj:cree del sud-est
      crk:cree del planas
      crl:cree del nord-est
      crm:cree moose
      crr:algonquino de Carolina
      crs:creolo seychellese
      cs:checo
      csw:cree del paludes
      cu:slavo ecclesiastic
      cv:chuvash
      cy:gallese
      da:danese
      dak:dakota
      dar:dargwa
      dav:taita
      de:germano
      de-AT:germano austriac
      de-CH:alte germano suisse
      dgr:dogrib
      dje:zarma
      doi:dogri
      dsb:basse sorabo
      dua:duala
      dv:divehi
      dyo:jola-fonyi
      dz:dzongkha
      dzg:dazaga
      ebu:embu
      ee:ewe
      efi:efik
      eka:ekajuk
      el:greco
      en:anglese
      en-AU:anglese australian
      en-CA:anglese canadian
      en-GB:anglese britannic
      en-GB-alt-short:anglese (GB)
      en-US:anglese american
      en-US-alt-short:anglese (SUA)
      eo:esperanto
      es:espaniol
      es-419:espaniol latinoamerican
      es-ES:espaniol europee
      es-MX:espaniol mexican
      et:estoniano
      eu:basco
      ewo:ewondo
      fa:persa
      fa-AF:dari
      ff:fula
      fi:finnese
      fil:filipino
      fj:fijiano
      fo:feroese
      fon:fon
      fr:francese
      fr-CA:francese canadian
      fr-CH:francese suisse
      frc:francese cajun
      frr:frison septentrional
      fur:friulano
      fy:frison occidental
      ga:irlandese
      gaa:ga
      gd:gaelico scotese
      gez:ge’ez
      gil:gilbertese
      gl:galleco
      gn:guarani
      gor:gorontalo
      gsw:germano suisse
      gu:gujarati
      guz:gusii
      gv:mannese
      gwi:gwich’in
      ha:hausa
      hai:haida
      haw:hawaiano
      hax:haida del sud
      he:hebreo
      hi:hindi
      hi-Latn-alt-variant:hinglish
      hil:hiligaynon
      hmn:hmong
      hr:croato
      hsb:alte sorabo
      ht:creolo haitian
      hu:hungaro
      hup:hupa
      hur:halkomelem
      hy:armenio
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonesiano
      ie:interlingue
      ig:igbo
      ii:yi de Sichuan
      ikt:inuktitut del west canadian
      ilo:ilocano
      inh:ingush
      io:ido
      is:islandese
      it:italiano
      iu:inuktitut
      ja:japonese
      jbo:lojban
      jgo:ngomba
      jmc:machame
      jv:javanese
      ka:georgiano
      kaa:kara-kalpak
      kab:kabylo
      kac:kachin
      kaj:jju
      kam:kamba
      kbd:cabardiano
      kcg:tyap
      kde:makonde
      kea:capoverdiano
      ken:kenyang
      kfo:koro
      kgp:kaingang
      kha:khasi
      khq:koyra chiini
      ki:kikuyu
      kj:kuanyama
      kk:kazakh
      kkj:kako
      kl:groenlandese
      kln:kalenjin
      km:khmer
      kmb:kimbundu
      kn:kannada
      ko:coreano
      kok:konkani
      kpe:kpelle
      kr:kanuri
      krc:karachay-balkaro
      krl:careliano
      kru:kurukh
      ks:kashmiri
      ksb:shambala
      ksf:bafia
      ksh:coloniese
      ku:kurdo
      kum:kumyko
      kv:komi
      kw:cornico
      kwk:kwakwala
      kxv:kuvi
      ky:kirghizo
      la:latino
      lad:judeo-espaniol
      lag:langi
      lb:luxemburgese
      lez:lezghiano
      lg:luganda
      li:limburgese
      lij:ligure
      lil:lillooet
      lkt:lakota
      lld:ladino
      lmo:lombardo
      ln:lingala
      lo:laotiano
      lou:creolo louisianese
      loz:lozi
      lrc:luri del nord
      lsm:samia
      lt:lithuano
      ltg:latgaliano
      lu:luba-katanga
      lua:luba-lulua
      lun:lunda
      lus:mizo
      luy:luyia
      lv:letton
      mad:madurese
      mag:magahi
      mai:maithili
      mak:macassarese
      mas:masai
      mdf:moksha
      men:mende
      mer:meri
      mfe:creolo mauritian
      mg:malgache
      mgh:macua de Metto
      mgo:metaʼ
      mh:marshallese
      mhn:mocheno
      mi:maori
      mic:micmac
      min:minangkabau
      mk:macedone
      ml:malayalam
      mn:mongol
      mni:manipuri
      moe:innu-aimun
      moh:mohawk
      mos:mossi
      mr:marathi
      ms:malay
      mt:maltese
      mua:mundang
      mul:plure linguas
      mus:creek
      mwl:mirandese
      my:birmano
      myv:erzya
      mzn:mazanderani
      na:nauru
      nap:napolitano
      naq:nama
      nb:norvegiano bokmål
      nd:ndebele del nord
      nds:basse germano
      nds-NL:basse saxone
      ne:nepalese
      new:newari
      ng:ndonga
      nia:nias
      niu:nieuano
      nl:nederlandese
      nl-BE:flamingo
      nmg:kwasio
      nn:norvegiano nynorsk
      nnh:ngiemboon
      no:norvegiano
      nog:nogai
      nqo:n’ko
      nr:ndebele del sud
      nso:sotho del nord
      nus:nuer
      nv:navajo
      ny:nyanja
      nyn:nyankole
      oc:occitano
      ojb:ojibwa del nord-west
      ojc:ojibwa central
      ojs:oji-cree
      ojw:ojibwa del west
      oka:okanagan
      om:oromo
      or:oriya
      os:osseto
      osa:osage
      pa:punjabi
      pag:pangasinan
      pam:pampanga
      pap:papiamento
      pau:palauano
      pcm:pidgin nigerian
      pis:pijin
      pl:polonese
      pqm:malecite-passamaquoddy
      prg:prussiano
      ps:pashto
      pt:portugese
      pt-BR:portugese de Brasil
      pt-PT:portugese de Portugal
      qu:quechua
      quc:kʼicheʼ
      raj:rajasthani
      rap:rapanui
      rar:rarotongano
      rhg:rohingya
      rif:rifeno
      rm:romanche
      rn:rundi
      ro:romaniano
      ro-MD:moldavo
      rof:rombo
      ru:russo
      rup:aromaniano
      rw:kinyarwanda
      rwk:rwa
      sa:sanscrito
      sad:sandawe
      sah:yakuto
      saq:samburu
      sat:santali
      sba:ngambay
      sbp:sangu
      sc:sardo
      scn:siciliano
      sco:scotese
      sd:sindhi
      sdh:kurdo del sud
      se:sami del nord
      seh:sena
      ses:koyraboro senni
      sg:sango
      sh:serbocroato
      shi:tachelhit
      shn:shan
      si:cingalese
      sid:sidamo
      sk:slovaco
      skr:saraiki
      sl:sloveno
      slh:lushootseed del sud
      sm:samoano
      sma:sami del sud
      smj:sami de Lule
      smn:sami de Inari
      sms:sami skolt
      sn:shona
      snk:soninke
      so:somali
      sq:albanese
      sr:serbo
      srn:sranan tongo
      ss:swati
      ssy:saho
      st:sotho del sud
      str:salish del strictos
      su:sundanese
      suk:sukuma
      sv:svedese
      sw:swahili
      sw-CD:swahili del Congo
      swb:comoriano
      syr:syriaco
      szl:silesiano
      ta:tamil
      tce:tutchone del sud
      te:telugu
      tem:temne
      teo:teso
      tet:tetum
      tg:tajiko
      tgx:tagish
      th:thai
      tht:tahltan
      ti:tigrinya
      tig:tigre
      tk:turkmeno
      tlh:klingon
      tli:tlingit
      tn:tswana
      to:tongano
      tok:toki pona
      tpi:tok pisin
      tr:turco
      trv:taroko
      trw:torwali
      ts:tsonga
      tt:tataro
      ttm:tutchone del nord
      tum:tumbuka
      tvl:tuvaluano
      tw:twi
      twq:tasawaq
      ty:tahitiano
      tyv:tuvano
      tzm:tamazight del Atlas Central
      udm:udmurto
      ug:uighur
      uk:ukrainiano
      umb:umbundu
      und:lingua incognite
      ur:urdu
      uz:uzbeko
      ve:venda
      vec:venetiano
      vi:vietnamese
      vmw:macua
      vo:volapük
      vun:vunjo
      wa:wallon
      wae:walser
      wal:wolaytta
      war:waray
      wbp:warlpiri
      wo:wolof
      wuu:wu
      xal:calmuco
      xh:xhosa
      xnr:kangri
      xog:soga
      yav:yangben
      ybb:yemba
      yi:yiddish
      yo:yoruba
      yrl:nheengatu
      yue:cantonese
      yue-alt-menu:chinese cantonese
      za:zhuang
      zgh:tamazight marocchin standard
      zh:chinese
      zh-alt-menu:chinese mandarin
      zh-Hans:chinese simplificate
      zh-Hans-alt-long:chinese mandarin simplificate
      zh-Hant:chinese traditional
      zh-Hant-alt-long:chinese mandarin traditional
      zu:zulu
      zun:zuni
      zxx:sin contento linguistic
      zza:zaza
      """.trimIndent() }

  val id: String by lazy { """
      aa:Afar
      ab:Abkhaz
      ace:Aceh
      ach:Acoli
      ada:Adangme
      ady:Adygei
      ae:Avesta
      aeb:Arab Tunisia
      af:Afrikaans
      afh:Afrihili
      agq:Aghem
      ain:Ainu
      ak:Akan
      akk:Akkadia
      akz:Alabama
      ale:Aleut
      alt:Altai Selatan
      am:Amharik
      an:Aragon
      ang:Inggris Kuno
      ann:Obolo
      anp:Angika
      ar:Arab
      ar-001:Arab Standar Modern
      arc:Aram
      arn:Mapuche
      arp:Arapaho
      arq:Arab Aljazair
      ars:Arab Najdi
      arw:Arawak
      ary:Arab Maroko
      arz:Arab Mesir
      as:Assam
      asa:Asu
      ase:Bahasa Isyarat Amerika
      ast:Asturia
      atj:Atikamekw
      av:Avar
      awa:Awadhi
      ay:Aymara
      az:Azerbaijani
      az-alt-short:Azeri
      ba:Bashkir
      bal:Baluchi
      ban:Bali
      bar:Bavaria
      bas:Basa
      bax:Bamun
      bbc:Batak Toba
      bbj:Ghomala
      be:Belarusia
      bej:Beja
      bem:Bemba
      bew:Betawi
      bez:Bena
      bfd:Bafut
      bg:Bulgaria
      bgc:Haryanvi
      bgn:Balochi Barat
      bho:Bhojpuri
      bi:Bislama
      bik:Bikol
      bin:Bini
      bjn:Banjar
      bkm:Kom
      bla:Siksika
      blo:Anii
      bm:Bambara
      bn:Bengali
      bo:Tibet
      br:Breton
      bra:Braj
      brx:Bodo
      bs:Bosnia
      bss:Akoose
      bua:Buriat
      bug:Bugis
      bum:Bulu
      byn:Blin
      byv:Medumba
      ca:Katalan
      cad:Kado
      car:Karibia
      cay:Cayuga
      cch:Atsam
      ccp:Chakma
      ce:Chechen
      ceb:Cebuano
      cgg:Kiga
      ch:Chamorro
      chb:Chibcha
      chg:Chagatai
      chk:Chuuke
      chm:Mari
      chn:Jargon Chinook
      cho:Koktaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      ckb:Kurdi Sorani
      ckb-alt-menu:Kurdi Sorani
      ckb-alt-variant:Kurdi, Sorani
      clc:Chilcotin
      co:Korsika
      cop:Koptik
      cr:Kree
      crg:Michif
      crh:Tatar Krimea
      crj:East Cree Selatan
      crk:Cree Dataran
      crl:East Cree Utara
      crm:Moose Cree
      crr:Carolina Algonquian
      crs:Seselwa Kreol Prancis
      cs:Ceko
      csb:Kashubia
      csw:Cree Rawa
      cu:Bahasa Gereja Slavonia
      cv:Chuvash
      cy:Welsh
      da:Dansk
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:Jerman
      de-CH:Jerman Tinggi (Swiss)
      del:Delaware
      den:Slave
      dgr:Dogrib
      din:Dinka
      dje:Zarma
      doi:Dogri
      dsb:Sorbia Hilir
      dua:Duala
      dum:Belanda Abad Pertengahan
      dv:Divehi
      dyo:Jola-Fonyi
      dyu:Dyula
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      egy:Mesir Kuno
      eka:Ekajuk
      el:Yunani
      elx:Elam
      en:Inggris
      en-GB:Inggris (Britania)
      en-GB-alt-short:Inggris (UK)
      enm:Inggris Abad Pertengahan
      eo:Esperanto
      es:Spanyol
      es-ES:Spanyol (Eropa)
      et:Estonia
      eu:Basque
      ewo:Ewondo
      fa:Persia
      fa-AF:Persia Dari
      fan:Fang
      fat:Fanti
      ff:Fula
      fi:Suomi
      fil:Filipino
      fj:Fiji
      fo:Faroe
      fon:Fon
      fr:Prancis
      frc:Prancis Cajun
      frm:Prancis Abad Pertengahan
      fro:Prancis Kuno
      frp:Arpitan
      frr:Frisia Utara
      frs:Frisia Timur
      fur:Friuli
      fy:Frisia Barat
      ga:Irlandia
      gaa:Ga
      gag:Gagauz
      gay:Gayo
      gba:Gbaya
      gd:Gaelik Skotlandia
      gez:Geez
      gil:Gilbert
      gl:Galisia
      glk:Gilaki
      gmh:Jerman Abad Pertengahan
      gn:Guarani
      goh:Jerman Kuno
      gon:Gondi
      gor:Gorontalo
      got:Gotik
      grb:Grebo
      grc:Yunani Kuno
      gsw:Jerman (Swiss)
      gu:Gujarat
      guz:Gusii
      gv:Manx
      gwi:Gwich’in
      ha:Hausa
      hai:Haida
      haw:Hawaii
      hax:Haida Selatan
      he:Ibrani
      hi:Hindi
      hi-Latn-alt-variant:Hinglish
      hif:Hindi Fiji
      hil:Hiligaynon
      hit:Hitit
      hmn:Hmong
      ho:Hiri Motu
      hr:Kroasia
      hsb:Sorbia Hulu
      ht:Kreol Haiti
      hu:Hungaria
      hup:Hupa
      hur:Halkomelem
      hy:Armenia
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Indonesia
      ie:Interlingue
      ig:Igbo
      ii:Sichuan Yi
      ik:Inupiak
      ikt:Inuktitut Kanada Barat
      ilo:Iloko
      inh:Ingushetia
      io:Ido
      is:Islandia
      it:Italia
      iu:Inuktitut
      ja:Jepang
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jpr:Ibrani-Persia
      jrb:Ibrani-Arab
      jv:Jawa
      ka:Georgia
      kaa:Kara-Kalpak
      kab:Kabyle
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kaw:Kawi
      kbd:Kabardi
      kbl:Kanembu
      kcg:Tyap
      kde:Makonde
      kea:Kabuverdianu
      ken:Kenyang
      kfo:Koro
      kg:Kongo
      kgp:Kaingang
      kha:Khasi
      kho:Khotan
      khq:Koyra Chiini
      ki:Kikuyu
      kj:Kuanyama
      kk:Kazakh
      kkj:Kako
      kl:Kalaallisut
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Korea
      koi:Komi-Permyak
      kok:Konkani
      kos:Kosre
      kpe:Kpelle
      kr:Kanuri
      krc:Karachai Balkar
      kri:Krio
      krl:Karelia
      kru:Kuruk
      ks:Kashmir
      ksb:Shambala
      ksf:Bafia
      ksh:Dialek Kolsch
      ku:Kurdi
      kum:Kumyk
      kut:Kutenai
      kv:Komi
      kw:Kornish
      kwk:Kwakʼwala
      kxv:Kuvi
      ky:Kirgiz
      la:Latin
      lad:Ladino
      lag:Langi
      lah:Lahnda
      lam:Lamba
      lb:Luksemburg
      lez:Lezghia
      lg:Ganda
      li:Limburgia
      lij:Liguria
      lil:Lillooet
      lkt:Lakota
      lmo:Lombard
      ln:Lingala
      lo:Lao
      lol:Mongo
      lou:Kreol Louisiana
      loz:Lozi
      lrc:Luri Utara
      lsm:Saamia
      lt:Lituania
      lu:Luba-Katanga
      lua:Luba-Lulua
      lui:Luiseno
      lun:Lunda
      luo:Luo
      lus:Mizo
      luy:Luyia
      lv:Latvia
      lzz:Laz
      mad:Madura
      maf:Mafa
      mag:Magahi
      mai:Maithili
      mak:Makasar
      man:Mandingo
      mas:Masai
      mde:Maba
      mdf:Moksha
      mdr:Mandar
      men:Mende
      mer:Meru
      mfe:Morisien
      mg:Malagasi
      mga:Irlandia Abad Pertengahan
      mgh:Makhuwa-Meetto
      mgo:Meta’
      mh:Marshall
      mi:Maori
      mic:Mikmak
      min:Minangkabau
      mk:Makedonia
      ml:Malayalam
      mn:Mongolia
      mnc:Manchuria
      mni:Manipuri
      moe:Innu-aimun
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      ms:Melayu
      mt:Malta
      mua:Mundang
      mul:Beberapa Bahasa
      mus:Bahasa Muskogee
      mwl:Miranda
      mwr:Marwari
      mwv:Mentawai
      my:Burma
      mye:Myene
      myv:Eryza
      mzn:Mazanderani
      na:Nauru
      nap:Neapolitan
      naq:Nama
      nb:Bokmål Norwegia
      nd:Ndebele Utara
      nds:Jerman Rendah
      ne:Nepali
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niuea
      nl:Belanda
      nmg:Kwasio
      nn:Nynorsk Norwegia
      nnh:Ngiemboon
      no:Norwegia
      nog:Nogai
      non:Norse Kuno
      nqo:N’Ko
      nr:Ndebele Selatan
      nso:Sotho Utara
      nus:Nuer
      nv:Navajo
      nwc:Newari Klasik
      ny:Nyanja
      nym:Nyamwezi
      nyn:Nyankole
      nyo:Nyoro
      nzi:Nzima
      oc:Ositania
      oj:Ojibwa
      ojb:Ojibwe Barat Laut
      ojc:Ojibwe Tengah
      ojs:Oji-Cree
      ojw:Ojibwe Barat
      oka:Okanagan
      om:Oromo
      or:Oriya
      os:Ossetia
      osa:Osage
      ota:Turki Osmani
      pa:Punjabi
      pag:Pangasina
      pal:Pahlevi
      pam:Pampanga
      pap:Papiamento
      pau:Palau
      pcm:Pidgin Nigeria
      pdc:Jerman Pennsylvania
      peo:Persia Kuno
      phn:Funisia
      pi:Pali
      pis:Pijin
      pl:Polski
      pon:Pohnpeia
      pqm:Maliseet-Passamaquoddy
      prg:Prusia
      pro:Provencal Lama
      ps:Pashto
      ps-alt-variant:Pushto
      pt:Portugis
      pt-PT:Portugis (Eropa)
      qu:Quechua
      quc:Kʼicheʼ
      raj:Rajasthani
      rap:Rapanui
      rar:Rarotonga
      rhg:Rohingya
      rm:Reto-Roman
      rn:Rundi
      ro:Rumania
      ro-MD:Moldavia
      rof:Rombo
      rom:Romani
      rtm:Rotuma
      ru:Rusia
      rup:Aromania
      rw:Kinyarwanda
      rwk:Rwa
      sa:Sanskerta
      sad:Sandawe
      sah:Sakha
      sam:Aram Samaria
      saq:Samburu
      sas:Sasak
      sat:Santali
      sba:Ngambai
      sbp:Sangu
      sc:Sardinia
      scn:Sisilia
      sco:Skotlandia
      sd:Sindhi
      sdh:Kurdi Selatan
      se:Sami Utara
      see:Seneca
      seh:Sena
      sei:Seri
      sel:Selkup
      ses:Koyraboro Senni
      sg:Sango
      sga:Irlandia Kuno
      sh:Serbo-Kroasia
      shi:Tachelhit
      shn:Shan
      shu:Arab Suwa
      si:Sinhala
      sid:Sidamo
      sk:Slovak
      sl:Slovenia
      slh:Lushootseed Selatan
      sli:Silesia Rendah
      sly:Selayar
      sm:Samoa
      sma:Sami Selatan
      smj:Lule Sami
      smn:Inari Sami
      sms:Skolt Sami
      sn:Shona
      snk:Soninke
      so:Somalia
      sog:Sogdien
      sq:Albania
      sr:Serbia
      srn:Sranan Tongo
      srr:Serer
      ss:Swati
      ssy:Saho
      st:Sotho Selatan
      str:Salish Selat
      su:Sunda
      suk:Sukuma
      sus:Susu
      sux:Sumeria
      sv:Swedia
      sw:Swahili
      sw-CD:Swahili (Kongo)
      swb:Komoria
      syc:Suriah Klasik
      syr:Suriah
      szl:Silesia
      ta:Tamil
      tce:Tutchone Selatan
      tcy:Tulu
      te:Telugu
      tem:Timne
      teo:Teso
      ter:Tereno
      tet:Tetun
      tg:Tajik
      tgx:Tagish
      th:Thai
      tht:Tahltan
      ti:Tigrinya
      tig:Tigre
      tiv:Tiv
      tk:Turkmen
      tkl:Tokelau
      tl:Tagalog
      tlh:Klingon
      tli:Tlingit
      tmh:Tamashek
      tn:Tswana
      to:Tonga
      tog:Nyasa Tonga
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Turki
      tru:Turoyo
      trv:Taroko
      ts:Tsonga
      tsi:Tsimshia
      tt:Tatar
      ttm:Tutchone Utara
      ttt:Tat Muslim
      tum:Tumbuka
      tvl:Tuvalu
      tw:Twi
      twq:Tasawaq
      ty:Tahiti
      tyv:Tuvinia
      tzm:Tamazight Maroko Tengah
      udm:Udmurt
      ug:Uyghur
      ug-alt-variant:Uighur
      uga:Ugarit
      uk:Ukraina
      umb:Umbundu
      und:Bahasa Tidak Dikenal
      ur:Urdu
      uz:Uzbek
      vai:Vai
      ve:Venda
      vec:Venesia
      vi:Vietnam
      vmw:Makhuwa
      vo:Volapuk
      vot:Votia
      vun:Vunjo
      wa:Walloon
      wae:Walser
      wal:Walamo
      war:Warai
      was:Washo
      wbp:Warlpiri
      wo:Wolof
      wuu:Wu Tionghoa
      xal:Kalmuk
      xh:Xhosa
      xnr:Kangri
      xog:Soga
      yao:Yao
      yap:Yapois
      yav:Yangben
      ybb:Yemba
      yi:Yiddish
      yo:Yoruba
      yrl:Nheengatu
      yue:Kanton
      yue-alt-menu:Tionghoa, Kanton
      za:Zhuang
      zap:Zapotek
      zbl:Blissymbol
      zen:Zenaga
      zgh:Tamazight Maroko Standar
      zh:Tionghoa
      zh-alt-menu:Tionghoa, Mandarin
      zh-Hans-alt-long:Tionghoa Mandarin (Sederhana)
      zh-Hant-alt-long:Tionghoa Mandarin (Tradisional)
      zu:Zulu
      zun:Zuni
      zxx:Tidak ada konten linguistik
      zza:Zaza
      """.trimIndent() }

  val ie: String by lazy { """
      ar:arabic
      cs:tchec
      da:danesi
      de:german
      de-AT:austrian german
      de-CH:sviss alt-german
      el:grec
      en:anglesi
      es:hispan
      es-419:hispan del latin America
      es-ES:europan hispan
      es-MX:mexican hispan
      et:estonian
      fa:persian
      fr:francesi
      fr-CH:sviss francesi
      hu:hungarian
      id:indonesian
      ie:Interlingue
      it:italian
      ja:japanesi
      ko:korean
      lij:ligurian
      lv:lettonian
      mt:maltesi
      nl:hollandesi
      nl-BE:flandrian
      pl:polonesi
      prg:prussian
      pt:portugalesi
      pt-BR:brasilian portugalesi
      pt-PT:europan portugalesi
      ru:russ
      sk:slovac
      sl:slovenian
      sv:sved
      sw:swahili
      tr:turc
      und:ínconosset lingue
      zh:chinesi
      zh-alt-menu:chinesi, mandarin
      """.trimIndent() }

  val ig: String by lazy { """
      aa:Afar
      ab:Abkaziani
      ace:Achinisi
      ada:Adangme
      ady:Adigi
      af:Afrikaans
      agq:Aghem
      ain:Ainu
      ak:Akan
      ale:Aleut
      alt:Southern Altai
      am:Amariikị
      an:Aragonisị
      ann:Obolo
      anp:Angika
      apc:apcc
      ar:Arabiikị
      ar-001:Ụdị Arabiikị nke oge a
      arn:Mapuche
      arp:Arapaho
      ars:Najdi Arabikị
      as:Asamisị
      asa:Asụ
      ast:Asturianị
      atj:Atikamekw
      av:Avarịk
      awa:Awadhi
      ay:Aymara
      az:Azerbaijani
      az-alt-short:Azeri
      ba:Bashkir
      bal:Baluchi
      ban:Balinese
      bas:Basaà
      be:Belarusian
      bem:Bembà
      bew:Betawi
      bez:Bena
      bg:Bulgarian
      bgc:Haryanvi
      bgn:Western Balochi
      bho:Bojpuri
      bi:Bislama
      bin:Bini
      bla:Siksikà
      blo:Anii
      blt:Tai Dam
      bm:Bambara
      bn:Bangla
      bo:Tibetan
      br:Breton
      brx:Bodo
      bs:Bosnian
      bss:Akoose
      bug:Buginese
      byn:Blin
      ca:Catalan
      cad:Caddo
      cay:Cayuga
      cch:Atsam
      ccp:Chakma
      ce:Chechen
      ceb:Cebuano
      cgg:Chiga
      ch:Chamorro
      chk:Chuukese
      chm:Mari
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyene
      cic:Chickasaw
      ckb:Central Kurdish
      ckb-alt-menu:Kurdish, Central
      ckb-alt-variant:Kurdish, Sorani
      clc:Chilcotin
      co:Corsican
      crg:Michif
      crj:Southern East Cree
      crk:Plains Cree
      crl:Northern East Cree
      crm:Moose Cree
      crr:Carolina Algonquian
      cs:Czech
      csw:Asụsụ Swampy Kree
      cu:Church slavic
      cv:Chuvash
      cy:Welsh
      da:Danish
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:German
      de-AT:Austrian German
      de-CH:Swiss High German
      dgr:Dogrib
      dje:Zarma
      doi:Dogri
      dsb:Lower Sorbian
      dua:Duala
      dv:Divehi
      dyo:Jola-Fonyi
      dz:Dọzngọka
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      eka:Ekajuk
      el:Grik
      en:Bekee
      en-AU:Bekee ndị Australia
      en-CA:Bekee ndị Canada
      en-GB:Bekee ndị United Kingdom
      en-GB-alt-short:Bekee ndị UK
      en-US:Bekee ndị America
      en-US-alt-short:Bekee ndị US
      eo:Esperanto
      es:Spanish
      es-419:Spanish ndị Latin America
      es-ES:Spanish ndị Europe
      es-MX:Spanish ndị Mexico
      et:Estonian
      eu:Basque
      ewo:Ewondo
      fa:Asụsụ Persia
      fa-AF:Dari
      ff:Fula
      fi:Finnish
      fil:Filipino
      fj:Fijanị
      fo:Faroese
      fon:Fon
      fr:French
      fr-CA:Canadian French
      fr-CH:Swiss French
      frc:Cajun French
      frr:Northern Frisian
      fur:Friulian
      fy:Ọdịda anyanwụ Frisian
      ga:Irish
      gaa:Ga
      gd:Asụsụ Scottish Gaelic
      gez:Geez
      gil:Gilbertese
      gl:Galician
      gn:Guarani
      gor:Gorontalo
      gsw:German Swiss
      gu:Gujarati
      guz:Gusii
      gv:Mansị
      gwi:Gwichʼin
      ha:Hausa
      hai:Haida
      haw:Hawaịlịan
      hax:Southern Haida
      he:Hebrew
      hi:Hindi
      hi-Latn-alt-variant:Hinglish
      hil:Hiligayanon
      hmn:Hmong
      hnj:Hmong Njua
      hr:Croatian
      hsb:Upper Sorbian
      ht:Haịtịan ndị Cerọle
      hu:Hungarian
      hup:Hupa
      hur:Halkomelem
      hy:Armenianị
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Indonesian
      ie:Interlingue
      ig:Igbo
      ii:Sichuan Yi
      ikt:Westarn Canadian Inuktitut
      ilo:Iloko
      inh:Ingush
      io:Ido
      is:Icelandic
      it:Italian
      iu:Inuktitut
      ja:Japanese
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jv:Javanese
      ka:Georgian
      kaa:Kara-Kalpak
      kab:Kabyle
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kbd:Kabadian
      kcg:Tyap
      kde:Makonde
      kea:Kabụverdịanụ
      ken:Kenyang
      kfo:Koro
      kgp:Kaingang
      kha:Khasi
      khq:Koyra Chiini
      ki:Kikuyu
      kj:Kuanyama
      kk:Kazakh
      kkj:Kako
      kl:Kalaallisut
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Korean
      kok:Konkani
      kpe:Kpelle
      kr:Kanuri
      krc:Karachay-Balkar
      krl:Karelian
      kru:Kurukh
      ks:Kashmiri
      ksb:Shambala
      ksf:Bafịa
      ksh:Colognian
      ku:Kurdish
      kum:Kumik
      kv:Komi
      kw:Cornish
      kwk:Kwakʼwala
      kxv:Kuvi
      ky:Kyrgyz
      la:Latin
      lad:Ladino
      lag:Langị
      lb:Luxembourgish
      lez:Lezghian
      lg:Ganda
      li:Limburgish
      lij:Ligurian
      lil:Liloetị
      lkt:Lakota
      lld:ID
      lmo:Lombard
      ln:Lingala
      lo:Lao
      lou:Louisiana Creole
      loz:Lozi
      lrc:Northern Luri
      lsm:Saamia
      lt:Lithuanian
      ltg:Latgalian
      lu:Luba-Katanga
      lua:Luba-Lulua
      lun:Lunda
      lus:Mizo
      luy:Luyia
      lv:Latvian
      mad:Madurese
      mag:Magahi
      mai:Maithili
      mak:Makasar
      mas:Masai
      mdf:Moksha
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagasy
      mgh:Makhuwa-Meetto
      mgo:Meta
      mh:Marshallese
      mhn:mhnn
      mi:Māori
      mic:Mi'kmaw
      min:Minangkabau
      mk:Macedonian
      ml:Malayalam
      mn:Mọngolịan
      mni:Asụsụ Manipuri
      moe:Innu-aimun
      moh:Mohawk
      mos:Mossi
      mr:Asụsụ Marathi
      ms:Malay
      mt:Asụsụ Malta
      mua:Mundang
      mul:Ọtụtụ asụsụ
      mus:Muscogee
      mwl:Mirandese
      my:Burmese
      myv:Erzya
      mzn:Mazanderani
      na:Nauru
      nap:Neapolitan
      naq:Nama
      nb:Norwegian Bokmål
      nd:North Ndebele
      nds:Low German
      nds-NL:Low Saxon
      ne:Nepali
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niuean
      nl:Dutch
      nl-BE:Flemish
      nmg:Kwasio
      nn:Norwegian Nynorsk
      nnh:Ngiemboon
      no:Norwegian
      nog:Nogai
      nqo:N’Ko
      nr:South Ndebele
      nso:Northern Sotho
      nus:Nuer
      nv:Navajo
      ny:Nyanja
      nyn:Nyankole
      oc:Asụsụ Osịtan
      ojb:Northwestern Ojibwa
      ojc:Central Ojibwa
      ojs:Oji-Cree
      ojw:Westarn Ojibwa
      oka:Okanagan
      om:Oromo
      or:Ọdịa
      os:Ossetic
      osa:Osage
      pa:Punjabi
      pag:Pangasinan
      pam:Pampanga
      pap:Papiamento
      pau:Palauan
      pcm:Pidgin ndị Naijirịa
      pis:Pijin
      pl:Asụsụ Polish
      pqm:Maliseet-Passamaquoddy
      prg:Prụssịan
      ps:Pashọ
      pt:Pọrtụgụese
      pt-BR:Asụsụ Portugese ndị Brazil
      pt-PT:Asụsụ Portuguese ndị Europe
      qu:Asụsụ Quechua
      quc:Kʼicheʼ
      raj:Rajastani
      rap:Rapanui
      rar:Rarotongan
      rhg:Rohingya
      rif:Riffian
      rm:Asụsụ Romansh
      rn:Rundi
      ro:Asụsụ Romanian
      ro-MD:Moldavian
      rof:Rombo
      ru:Asụsụ Russia
      rup:Aromanian
      rw:Kinyarwanda
      rwk:Rwa
      sa:Asụsụ Sanskrit
      sad:Sandawe
      sah:Yakut
      saq:Samburu
      sat:Asụsụ Santali
      sba:Ngambay
      sbp:Sangu
      sc:Asụsụ Sardini
      scn:Sicilian
      sco:Scots
      sd:Asụsụ Sindhi
      sdh:Southern Kurdish
      se:Northern Sami
      seh:Sena
      ses:Koyraboro Senni
      sg:Sango
      shi:Tachịkịt
      shn:Shan
      si:Sinhala
      sid:Sidamo
      sk:Asụsụ Slovak
      skr:skrr
      sl:Asụsụ Slovenia
      slh:Southern Lushootseed
      sm:Samoan
      sma:Southern Sami
      smj:Lule Sami
      smn:Inari Sami
      sms:Skolt sami
      sn:Shona
      snk:Soninke
      so:Somali
      sq:Asụsụ Albania
      sr:Asụsụ Serbia
      srn:Sranan Tongo
      ss:Swati
      ssy:Saho
      st:Southern Sotho
      str:Straits Salish
      su:Asụsụ Sundan
      suk:Sukuma
      sv:Sụwidiishi
      sw:Asụsụ Swahili
      swb:Comorian
      syr:Sirịak
      szl:Asụsụ Sileshia
      ta:Tamil
      tce:Southern Tutchone
      te:Telugu
      tem:Timne
      teo:Teso
      tet:Tetum
      tg:Tajik
      tgx:Tagish
      th:Thai
      tht:Tahitan
      ti:Tigrinya
      tig:Tigre
      tk:Turkmen
      tlh:Klingon
      tli:Tlingit
      tn:Tswana
      to:Tongan
      tok:Toki Pona
      tpi:Tok pisin
      tr:Turkish
      trv:Taroko
      trw:Torwali
      ts:Tsonga
      tt:Asụsụ Tatar
      ttm:Northern Tutchone
      tum:Tumbuka
      tvl:Tuvalu
      twq:Tasawaq
      ty:Tahitian
      tyv:Tuvinian
      tzm:Central Atlas Tamazight
      udm:Udmurt
      ug:Uyghur
      uk:Asụsụ Ukrain
      umb:Umbundu
      und:Asụsụ a na-amaghị
      ur:Urdu
      uz:Uzbek
      ve:Venda
      vec:Asụsụ Veneshia
      vi:Vietnamese
      vmw:Makhuwa
      vo:Volapük
      vun:Vunjo
      wa:Walloon
      wae:Walser
      wal:Wolaytta
      war:Waray
      wbp:Warlpiri
      wo:Wolof
      wuu:Wu Chinese
      xal:Kalmyk
      xh:Xhosa
      xnr:Kangri
      xog:Soga
      yav:Yangben
      ybb:Yemba
      yi:Yiddish
      yo:Yoruba
      yrl:Asụsụ Nheengatu
      yue:Cantonese
      yue-alt-menu:Chaịniiz,Cantonese
      za:Zhuang
      zgh:Standard Moroccan Tamazight
      zh:Chaịniiz
      zh-alt-menu:Chaịniiz, Mandarin
      zh-Hans:Asụsụ Chaịniiz dị mfe
      zh-Hans-alt-long:Asụsụ Mandarin Chaịniiz dị mfe
      zh-Hant:Asụsụ ọdịnala Chaịniiz
      zh-Hant-alt-long:Asụsụ ọdịnala Mandarin Chaịniiz
      zu:Zulu
      zun:Zuni
      zxx:Enweghị asụsụ dịnaya
      zza:Zaza
      """.trimIndent() }

  val ii: String by lazy { """
      ar:ꀊꇁꀨꉙ
      ar-001:ꀊꇁꀨꉙ（ꋧꃅ）
      de:ꄓꇩꉙ
      en:ꑱꇩꉙ
      es:ꑭꀠꑸꉙ
      fr:ꃔꇩꉙ
      hi:ꑴꄃꉙ
      hi-Latn-alt-variant:ꑴꐛꑱꉙ
      ii:ꆈꌠꉙ
      it:ꑴꄊꆺꉙ
      ja:ꏝꀪꉙ
      nds:ꃅꄷꀁꂥꄓꉙ
      nl:ꉿꇂꉙ
      pt:ꁍꄨꑸꉙ
      ro:ꇆꂷꆀꑸꉙ
      ru:ꊉꇩꉙ
      sw:ꌖꑟꆺꉙ
      und:ꅉꀋꌠꅇꂷ
      zh:ꍏꇩꉙ
      zh-alt-menu:ꍏꇩꉙ
      """.trimIndent() }

  val io: String by lazy { """
      io:Ido
      """.trimIndent() }

  val `is`: String by lazy { """
      aa:afár
      ab:abkasíska
      ace:akkíska
      ach:acoli
      ada:adangme
      ady:adýge
      ae:avestíska
      af:afríkanska
      afh:afríhílí
      agq:aghem
      ain:aínu (Japan)
      ak:akan
      akk:akkadíska
      ale:aleúska
      alt:suðuraltaíska
      am:amharíska
      an:aragonska
      ang:fornenska
      ann:obolo
      anp:angíka
      ar:arabíska
      ar-001:stöðluð nútímaarabíska
      arc:arameíska
      arn:mapuche
      arp:arapahó
      ars:najdi-arabíska
      arw:aravakska
      as:assamska
      asa:asu
      ast:astúríska
      atj:atikamekw
      av:avaríska
      awa:avadí
      ay:aímara
      az:aserska
      az-alt-short:aserska
      ba:baskír
      bal:balúkí
      ban:balíska
      bas:basa
      bax:bamun
      be:hvítrússneska
      bej:beja
      bem:bemba
      bez:bena
      bg:búlgarska
      bgc:haryanví
      bgn:vesturbalotsí
      bho:bojpúrí
      bi:bíslama
      bik:bíkol
      bin:bíní
      bla:siksika
      blo:anii
      bm:bambara
      bn:bengalska
      bo:tíbeska
      br:bretónska
      bra:braí
      brx:bódó
      bs:bosníska
      bss:bakossi
      bua:búríat
      bug:búgíska
      byn:blín
      ca:katalónska
      cad:kaddó
      car:karíbamál
      cay:kajúga
      cch:atsam
      ccp:tsjakma
      ce:tsjetsjenska
      ceb:kebúanó
      cgg:kíga
      ch:kamorró
      chb:síbsja
      chg:sjagataí
      chk:sjúkíska
      chm:marí
      chn:sínúk
      cho:sjoktá
      chp:sípevíska
      chr:Cherokee-mál
      chy:sjeyen
      ckb:miðkúrdíska
      ckb-alt-menu:miðkúrdíska
      ckb-alt-variant:miðkúrdíska
      clc:chilcotin
      co:korsíska
      cop:koptíska
      cr:krí
      crg:michif
      crh:krímtyrkneska
      crj:suðaustur-cree
      crk:nehiyawak
      crl:norðaustur-cree
      crm:moose cree
      crr:Karólínu-algonkvínska
      crs:seychelles-kreólska
      cs:tékkneska
      csb:kasúbíska
      csw:maskekon
      cu:kirkjuslavneska
      cv:sjúvas
      cy:velska
      da:danska
      dak:dakóta
      dar:dargva
      dav:taíta
      de:þýska
      de-AT:austurrísk þýska
      de-CH:svissnesk háþýska
      del:delaver
      den:slavneska
      dgr:dogríb
      din:dinka
      dje:zarma
      doi:dogrí
      dsb:lágsorbneska
      dua:dúala
      dum:miðhollenska
      dv:dívehí
      dyo:jola-fonyi
      dyu:djúla
      dz:dsongka
      dzg:dazaga
      ebu:embu
      ee:ewe
      efi:efík
      egy:fornegypska
      eka:ekajúk
      el:gríska
      elx:elamít
      en:enska
      en-AU:áströlsk enska
      en-CA:kanadísk enska
      en-GB:bresk enska
      en-GB-alt-short:enska (bresk)
      en-US:bandarísk enska
      en-US-alt-short:enska (BNA)
      enm:miðenska
      eo:esperantó
      es:spænska
      es-419:rómönsk-amerísk spænska
      es-ES:evrópsk spænska
      es-MX:mexíkósk spænska
      et:eistneska
      eu:baskneska
      ewo:evondó
      fa:persneska
      fa-AF:darí
      fan:fang
      fat:fantí
      ff:fúla
      fi:finnska
      fil:filippseyska
      fj:fídjeyska
      fo:færeyska
      fon:fón
      fr:franska
      fr-CA:kanadísk franska
      fr-CH:svissnesk franska
      frc:cajun-franska
      frm:miðfranska
      fro:fornfranska
      frr:norðurfrísneska
      frs:austurfrísneska
      fur:fríúlska
      fy:vesturfrísneska
      ga:írska
      gaa:ga
      gag:gagás
      gan:gan
      gay:gajó
      gba:gbaja
      gd:skosk gelíska
      gez:gís
      gil:gilberska
      gl:galisíska
      gmh:miðháþýska
      gn:gvaraní
      goh:fornháþýska
      gon:gondí
      gor:gorontaló
      got:gotneska
      grb:gerbó
      grc:forngríska
      gsw:svissnesk þýska
      gu:gújaratí
      guz:gusii
      gv:manska
      gwi:gvísín
      ha:hása
      hai:haída
      haw:havaíska
      hax:suður-haída
      he:hebreska
      hi:hindí
      hi-Latn-alt-variant:hinglish
      hil:híligaínon
      hit:hettitíska
      hmn:hmong
      ho:hírímótú
      hr:króatíska
      hsb:hásorbneska
      ht:haítíska
      hu:ungverska
      hup:húpa
      hur:halkomelem
      hy:armenska
      hz:hereró
      ia:interlingua
      iba:íban
      ibb:ibibio
      id:indónesíska
      ie:interlingve
      ig:ígbó
      ii:sísúanjí
      ik:ínúpíak
      ikt:vestur-kanadískt inúktitút
      ilo:ílokó
      inh:ingús
      io:ídó
      is:íslenska
      it:ítalska
      iu:inúktitút
      ja:japanska
      jbo:lojban
      jgo:ngomba
      jmc:masjáme
      jpr:gyðingapersneska
      jrb:gyðingaarabíska
      jv:javanska
      ka:georgíska
      kaa:karakalpak
      kab:kabíle
      kac:kasín
      kaj:jju
      kam:kamba
      kaw:kaví
      kbd:kabardíska
      kcg:tyap
      kde:makonde
      kea:grænhöfðeyska
      kfo:koro
      kg:kongóska
      kgp:kaingang
      kha:kasí
      kho:kotaska
      khq:koyra chiini
      ki:kíkújú
      kj:kúanjama
      kk:kasakska
      kkj:kako
      kl:grænlenska
      kln:kalenjin
      km:kmer
      kmb:kimbúndú
      kn:kannada
      ko:kóreska
      koi:kómí-permyak
      kok:konkaní
      kos:kosraska
      kpe:kpelle
      kr:kanúrí
      krc:karasaíbalkar
      krl:karélska
      kru:kúrúk
      ks:kasmírska
      ksb:sjambala
      ksf:bafía
      ksh:kölníska
      ku:kúrdíska
      kum:kúmík
      kut:kútenaí
      kv:komíska
      kw:kornbreska
      kwk:kwakʼwala
      kxv:kúví
      ky:kirgiska
      la:latína
      lad:ladínska
      lag:langí
      lah:landa
      lam:lamba
      lb:lúxemborgíska
      lez:lesgíska
      lg:ganda
      li:limbúrgíska
      lij:lígúríska
      lil:lillooet
      lkt:lakóta
      lmo:lombardíska
      ln:lingala
      lo:laó
      lol:mongó
      lou:kreólska (Louisiana)
      loz:lozi
      lrc:norðurlúrí
      lsm:saamia
      lt:litháíska
      lu:lúbakatanga
      lua:luba-lulua
      lui:lúisenó
      lun:lúnda
      luo:lúó
      lus:lúsaí
      luy:luyia
      lv:lettneska
      mad:madúrska
      mag:magahí
      mai:maítílí
      mak:makasar
      man:mandingó
      mas:masaí
      mdf:moksa
      mdr:mandar
      men:mende
      mer:merú
      mfe:máritíska
      mg:malagasíska
      mga:miðírska
      mgh:makhuwa-meetto
      mgo:meta’
      mh:marshallska
      mi:maorí
      mic:mikmak
      min:mínangkabá
      mk:makedónska
      ml:malajalam
      mn:mongólska
      mnc:mansjú
      mni:manípúrí
      moe:innu-aimun
      moh:móhíska
      mos:mossí
      mr:maratí
      ms:malaíska
      mt:maltneska
      mua:mundang
      mul:mörg tungumál
      mus:krík
      mwl:mirandesíska
      mwr:marvarí
      my:búrmneska
      myv:ersja
      mzn:masanderaní
      na:nárúska
      nap:napólíska
      naq:nama
      nb:norskt bókmál
      nd:norður-ndebele
      nds:lágþýska; lágsaxneska
      nds-NL:lágsaxneska
      ne:nepalska
      new:nevarí
      ng:ndonga
      nia:nías
      niu:níveska
      nl:hollenska
      nl-BE:flæmska
      nmg:kwasio
      nn:nýnorska
      nnh:ngiemboon
      no:norska
      nog:nógaí
      non:norræna
      nqo:n’ko
      nr:suðurndebele
      nso:norðursótó
      nus:núer
      nv:navahó
      nwc:klassísk nevaríska
      ny:nýanja
      nym:njamvesí
      nyn:nyankole
      nyo:njóró
      nzi:nsíma
      oc:oksítaníska
      oj:ojibva
      ojb:norðvestur-ojibwa
      ojc:ojibwa
      ojs:oji-cree
      ojw:vestur-ojibwa
      oka:okanagan
      om:oromo
      or:óría
      os:ossetíska
      osa:ósage
      ota:tyrkneska, ottóman
      pa:púnjabí
      pag:pangasínmál
      pal:palaví
      pam:pampanga
      pap:papíamentó
      pau:paláska
      pcm:nígerískt pidgin
      peo:fornpersneska
      phn:fönikíska
      pi:palí
      pis:pijin
      pl:pólska
      pon:ponpeiska
      pqm:maliseet-passamaquoddy
      prg:prússneska
      pro:fornpróvensalska
      ps:pastú
      pt:portúgalska
      pt-BR:brasílísk portúgalska
      pt-PT:evrópsk portúgalska
      qu:kvesjúa
      quc:kiche
      raj:rajastaní
      rap:rapanúí
      rar:rarótongska
      rhg:rohingja
      rm:rómanska
      rn:rúndí
      ro:rúmenska
      ro-MD:moldóvska
      rof:rombó
      rom:romaní
      ru:rússneska
      rup:arúmenska
      rw:kínjarvanda
      rwk:rúa
      sa:sanskrít
      sad:sandave
      sah:jakút
      sam:samversk arameíska
      saq:sambúrú
      sas:sasak
      sat:santalí
      sba:ngambay
      sbp:sangú
      sc:sardínska
      scn:sikileyska
      sco:skoska
      sd:sindí
      sdh:suðurkúrdíska
      se:norðursamíska
      seh:sena
      sel:selkúp
      ses:koíraboró-senní
      sg:sangó
      sga:fornírska
      sh:serbókróatíska
      shi:tachelhit
      shn:sjan
      si:singalíska
      sid:sídamó
      sk:slóvakíska
      sl:slóvenska
      slh:suður-lushootseed
      sm:samóska
      sma:suðursamíska
      smj:lúlesamíska
      smn:enaresamíska
      sms:skoltesamíska
      sn:shona
      snk:sóninke
      so:sómalska
      sog:sogdíen
      sq:albanska
      sr:serbneska
      srn:sranan tongo
      srr:serer
      ss:svatí
      ssy:saho
      st:suðursótó
      str:Straits-salisíanska
      su:súndanska
      suk:súkúma
      sus:súsú
      sux:súmerska
      sv:sænska
      sw:svahílí
      sw-CD:kongósvahílí
      swb:shimaoríska
      syc:klassísk sýrlenska
      syr:sýrlenska
      szl:slesíska
      ta:tamílska
      tce:suður-tutchone
      te:telúgú
      tem:tímne
      teo:tesó
      ter:terenó
      tet:tetúm
      tg:tadsjikska
      tgx:tagíska
      th:taílenska
      tht:tahltan
      ti:tígrinja
      tig:tígre
      tiv:tív
      tk:túrkmenska
      tkl:tókeláska
      tl:tagalog
      tlh:klingonska
      tli:tlingit
      tmh:tamasjek
      tn:tsúana
      to:tongverska
      tog:tongverska (nyasa)
      tok:toki pona
      tpi:tokpisin
      tr:tyrkneska
      trv:tarókó
      ts:tsonga
      tsi:tsimsíska
      tt:tatarska
      ttm:norður-tutchone
      tum:túmbúka
      tvl:túvalúska
      tw:tví
      twq:tasawaq
      ty:tahítíska
      tyv:túvínska
      tzm:tamazight
      udm:údmúrt
      ug:úígúr
      uga:úgarítíska
      uk:úkraínska
      umb:úmbúndú
      und:óþekkt tungumál
      ur:úrdú
      uz:úsbekska
      vai:vaí
      ve:venda
      vec:feneyska
      vi:víetnamska
      vmw:makúva
      vo:volapyk
      vot:votíska
      vun:vunjó
      wa:vallónska
      wae:valser
      wal:volayatta
      war:varaí
      was:vasjó
      wbp:varlpiri
      wo:volof
      wuu:wu-kínverska
      xal:kalmúkska
      xh:sósa
      xnr:kangrí
      xog:sóga
      yao:jaó
      yap:japíska
      yav:yangben
      ybb:yemba
      yi:jiddíska
      yo:jórúba
      yrl:nheengatu
      yue:kantónska
      yue-alt-menu:kínverska, kantónska
      za:súang
      zap:sapótek
      zbl:blisstákn
      zen:senaga
      zgh:staðlað marokkóskt tamazight
      zh:kínverska
      zh-alt-menu:kínverska, mandarín
      zh-Hans:kínverska (einfölduð)
      zh-Hans-alt-long:mandarín (einfölduð)
      zh-Hant:kínverska (hefðbundin)
      zh-Hant-alt-long:mandarín (hefðbundin)
      zu:súlú
      zun:súní
      zxx:ekkert tungumálaefni
      zza:zázáíska
      """.trimIndent() }

  val it: String by lazy { """
      aa:afar
      ab:abcaso
      ace:accinese
      ach:acioli
      ada:adangme
      ady:adyghe
      ae:avestan
      aeb:arabo tunisino
      af:afrikaans
      afh:afrihili
      agq:aghem
      ain:ainu
      ak:akan
      akk:accado
      akz:alabama
      ale:aleuto
      aln:albanese ghego
      alt:altai meridionale
      am:amarico
      an:aragonese
      ang:inglese antico
      ann:obolo
      anp:angika
      ar:arabo
      ar-001:arabo moderno standard
      arc:aramaico
      arn:mapudungun
      aro:araona
      arp:arapaho
      arq:arabo algerino
      ars:arabo najd
      arw:aruaco
      ary:arabo marocchino
      arz:arabo egiziano
      as:assamese
      asa:asu
      ase:lingua dei segni americana
      ast:asturiano
      atj:atikamekw
      av:avaro
      avk:kotava
      awa:awadhi
      ay:aymara
      az:azerbaigiano
      az-alt-short:azero
      ba:baschiro
      bal:beluci
      ban:balinese
      bar:bavarese
      bas:basa
      bax:bamun
      bbc:batak toba
      bbj:ghomala
      be:bielorusso
      bej:begia
      bem:wemba
      bew:betawi
      bez:bena
      bfd:bafut
      bfq:badaga
      bg:bulgaro
      bgc:haryanvi
      bgn:beluci occidentale
      bho:bhojpuri
      bi:bislama
      bik:bicol
      bin:bini
      bjn:banjar
      bkm:kom
      bla:siksika
      blo:anii
      bm:bambara
      bn:bengalese
      bo:tibetano
      bpy:bishnupriya
      bqi:bakhtiari
      br:bretone
      bra:braj
      brh:brahui
      brx:bodo
      bs:bosniaco
      bss:akoose
      bua:buriat
      bug:bugi
      bum:bulu
      byn:blin
      byv:medumba
      ca:catalano
      cad:caddo
      car:caribico
      cay:cayuga
      cch:atsam
      ccp:chakma
      ce:ceceno
      ceb:cebuano
      cgg:chiga
      ch:chamorro
      chb:chibcha
      chg:ciagataico
      chk:chuukese
      chm:mari
      chn:gergo chinook
      cho:choctaw
      chp:chipewyan
      chr:cherokee
      chy:cheyenne
      ckb:curdo centrale
      ckb-alt-menu:curdo (centrale)
      ckb-alt-variant:curdo (sorani)
      clc:chilcotin
      co:corso
      cop:copto
      cps:capiznon
      cr:cree
      crg:métchif
      crh:turco crimeo
      crj:cree sud-orientale
      crk:cree delle pianure
      crl:cree nord-orientale
      crm:cree moose
      crr:algonchino della Carolina
      crs:creolo delle Seychelles
      cs:ceco
      csb:kashubian
      csw:cree delle paludi
      cu:slavo ecclesiastico
      cv:ciuvascio
      cy:gallese
      da:danese
      dak:dakota
      dar:dargwa
      dav:taita
      de:tedesco
      de-AT:tedesco austriaco
      de-CH:alto tedesco svizzero
      del:delaware
      den:slave
      dgr:dogrib
      din:dinca
      dje:zarma
      doi:dogri
      dsb:basso sorabo
      dtp:dusun centrale
      dua:duala
      dum:olandese medio
      dv:divehi
      dyo:jola-fony
      dyu:diula
      dz:dzongkha
      dzg:dazaga
      ebu:embu
      ee:ewe
      efi:efik
      egl:emiliano
      egy:egiziano antico
      eka:ekajuka
      el:greco
      elx:elamitico
      en:inglese
      en-AU:inglese australiano
      en-CA:inglese canadese
      en-GB:inglese britannico
      en-GB-alt-short:inglese (GB)
      en-US:inglese americano
      en-US-alt-short:inglese (USA)
      enm:inglese medio
      eo:esperanto
      es:spagnolo
      es-419:spagnolo latinoamericano
      es-ES:spagnolo europeo
      es-MX:spagnolo messicano
      esu:yupik centrale
      et:estone
      eu:basco
      ewo:ewondo
      ext:estremegno
      fa:persiano
      fa-AF:dari
      fan:fang
      fat:fanti
      ff:fulah
      fi:finlandese
      fil:filippino
      fit:finlandese del Tornedalen
      fj:figiano
      fo:faroese
      fon:fon
      fr:francese
      fr-CA:francese canadese
      fr-CH:francese svizzero
      frc:francese cajun
      frm:francese medio
      fro:francese antico
      frp:francoprovenzale
      frr:frisone settentrionale
      frs:frisone orientale
      fur:friulano
      fy:frisone occidentale
      ga:irlandese
      gaa:ga
      gag:gagauzo
      gan:gan
      gay:gayo
      gba:gbaya
      gbz:dari zoroastriano
      gd:gaelico scozzese
      gez:geez
      gil:gilbertese
      gl:galiziano
      glk:gilaki
      gmh:tedesco medio alto
      gn:guaraní
      goh:tedesco antico alto
      gon:gondi
      gor:gorontalo
      got:gotico
      grb:grebo
      grc:greco antico
      gsw:tedesco svizzero
      gu:gujarati
      guc:wayuu
      guz:gusii
      gv:mannese
      gwi:gwichʼin
      ha:hausa
      hai:haida
      hak:hakka
      haw:hawaiano
      hax:haida meridionale
      he:ebraico
      hi:hindi
      hi-Latn-alt-variant:hinglish
      hif:hindi figiano
      hil:ilongo
      hit:hittite
      hmn:hmong
      ho:hiri motu
      hr:croato
      hsb:alto sorabo
      hsn:xiang
      ht:creolo haitiano
      hu:ungherese
      hup:hupa
      hur:halkomelem
      hy:armeno
      hz:herero
      ia:interlingua
      iba:iban
      ibb:ibibio
      id:indonesiano
      ie:interlingue
      ig:igbo
      ii:sichuan yi
      ik:inupiak
      ikt:inuktitut canadese occidentale
      ilo:ilocano
      inh:ingush
      io:ido
      is:islandese
      it:italiano
      iu:inuktitut
      izh:ingrico
      ja:giapponese
      jam:creolo giamaicano
      jbo:lojban
      jgo:ngamambo
      jmc:machame
      jpr:giudeo persiano
      jrb:giudeo arabo
      jut:jutlandico
      jv:giavanese
      ka:georgiano
      kaa:kara-kalpak
      kab:cabilo
      kac:kachin
      kaj:jju
      kam:kamba
      kaw:kawi
      kbd:cabardino
      kbl:kanembu
      kcg:tyap
      kde:makonde
      kea:capoverdiano
      kfo:koro
      kg:kongo
      kgp:kaingang
      kha:khasi
      kho:khotanese
      khq:koyra chiini
      khw:khowar
      ki:kikuyu
      kiu:kirmanjki
      kj:kuanyama
      kk:kazako
      kkj:kako
      kl:groenlandese
      kln:kalenjin
      km:khmer
      kmb:kimbundu
      kn:kannada
      ko:coreano
      koi:permiaco
      kok:konkani
      kos:kosraean
      kpe:kpelle
      kr:kanuri
      krc:karachay-Balkar
      krl:careliano
      kru:kurukh
      ks:kashmiri
      ksb:shambala
      ksf:bafia
      ksh:coloniese
      ku:curdo
      kum:kumyk
      kut:kutenai
      kv:komi
      kw:cornico
      kwk:kwakʼwala
      kxv:kuvi
      ky:kirghiso
      la:latino
      lad:giudeo-spagnolo
      lag:langi
      lah:lahnda
      lam:lamba
      lb:lussemburghese
      lez:lesgo
      lfn:Lingua Franca Nova
      lg:ganda
      li:limburghese
      lij:ligure
      lil:lillooet
      liv:livone
      lkt:lakota
      lld:ladino
      lmo:lombardo
      ln:lingala
      lo:lao
      lol:lolo bantu
      lou:creolo della Louisiana
      loz:lozi
      lrc:luri settentrionale
      lsm:samia
      lt:lituano
      ltg:letgallo
      lu:luba-katanga
      lua:luba-lulua
      lui:luiseno
      lun:lunda
      lus:lushai
      luy:luyia
      lv:lettone
      lzh:cinese classico
      lzz:laz
      mad:madurese
      maf:mafa
      mag:magahi
      mai:maithili
      mak:makasar
      man:mandingo
      mas:masai
      mde:maba
      mdf:moksha
      mdr:mandar
      men:mende
      mer:meru
      mfe:creolo mauriziano
      mg:malgascio
      mga:irlandese medio
      mgh:makhuwa-meetto
      mgo:meta’
      mh:marshallese
      mi:maori
      mic:micmac
      min:menangkabau
      mk:macedone
      ml:malayalam
      mn:mongolo
      mnc:manchu
      mni:manipuri
      moe:innu-aimun
      moh:mohawk
      mos:mossi
      mr:marathi
      mrj:mari occidentale
      ms:malese
      mt:maltese
      mua:mundang
      mul:multilingua
      mus:creek
      mwl:mirandese
      mwr:marwari
      mwv:mentawai
      my:birmano
      mye:myene
      myv:erzya
      mzn:mazandarani
      na:nauru
      nan:min nan
      nap:napoletano
      naq:nama
      nb:norvegese bokmål
      nd:ndebele del nord
      nds:basso tedesco
      nds-NL:basso tedesco olandese
      ne:nepalese
      new:newari
      ng:ndonga
      nia:nias
      niu:niue
      njo:ao
      nl:olandese
      nl-BE:fiammingo
      nmg:kwasio
      nn:norvegese nynorsk
      nnh:ngiemboon
      no:norvegese
      nog:nogai
      non:norse antico
      nov:novial
      nqo:n’ko
      nr:ndebele del sud
      nso:sotho del nord
      nus:nuer
      nv:navajo
      nwc:newari classico
      ny:nyanja
      nym:nyamwezi
      nyn:nyankole
      nyo:nyoro
      nzi:nzima
      oc:occitano
      oj:ojibwa
      ojb:ojibwe nord-occidentale
      ojc:ojibwe centrale
      ojs:oji-cree
      ojw:ojibwe occidentale
      oka:okanagan
      om:oromo
      or:odia
      os:ossetico
      osa:osage
      ota:turco ottomano
      pa:punjabi
      pag:pangasinan
      pal:pahlavi
      pam:pampanga
      pap:papiamento
      pau:palau
      pcd:piccardo
      pcm:pidgin nigeriano
      pdc:tedesco della Pennsylvania
      peo:persiano antico
      pfl:tedesco palatino
      phn:fenicio
      pi:pali
      pis:pijin
      pl:polacco
      pms:piemontese
      pnt:pontico
      pon:ponape
      pqm:malecite-passamaquoddy
      prg:prussiano
      pro:provenzale antico
      ps:pashto
      pt:portoghese
      pt-BR:portoghese brasiliano
      pt-PT:portoghese europeo
      qu:quechua
      quc:k’iche’
      qug:quechua dell’altopiano del Chimborazo
      raj:rajasthani
      rap:rapanui
      rar:rarotonga
      rgn:romagnolo
      rhg:rohingya
      rif:tarifit
      rm:romancio
      rn:rundi
      ro:rumeno
      ro-MD:moldavo
      rof:rombo
      rom:romani
      rtm:rotumano
      ru:russo
      rue:ruteno
      rug:roviana
      rup:arumeno
      rw:kinyarwanda
      rwk:rwa
      sa:sanscrito
      sad:sandawe
      sah:sacha
      sam:aramaico samaritano
      saq:samburu
      sas:sasak
      sat:santali
      saz:saurashtra
      sba:ngambay
      sbp:sangu
      sc:sardo
      scn:siciliano
      sco:scozzese
      sd:sindhi
      sdc:sassarese
      sdh:curdo meridionale
      se:sami del nord
      see:seneca
      seh:sena
      sei:seri
      sel:selkup
      ses:koyraboro senni
      sg:sango
      sga:irlandese antico
      sgs:samogitico
      sh:serbo-croato
      shi:tashelhit
      shn:shan
      shu:arabo ciadiano
      si:singalese
      sid:sidamo
      sk:slovacco
      sl:sloveno
      slh:lushootseed meridionale
      sli:tedesco slesiano
      sly:selayar
      sm:samoano
      sma:sami del sud
      smj:sami di Lule
      smn:sami di Inari
      sms:sami skolt
      sn:shona
      snk:soninke
      so:somalo
      sog:sogdiano
      sq:albanese
      sr:serbo
      srn:sranan tongo
      srr:serer
      ss:swati
      ssy:saho
      st:sotho del sud
      stq:saterfriesisch
      str:salish straits
      su:sundanese
      suk:sukuma
      sus:susu
      sux:sumero
      sv:svedese
      sw:swahili
      sw-CD:swahili del Congo
      swb:comoriano
      syc:siriaco classico
      syr:siriaco
      szl:slesiano
      ta:tamil
      tce:tutchone meridionale
      tcy:tulu
      te:telugu
      tem:temne
      teo:teso
      ter:tereno
      tet:tetum
      tg:tagico
      tgx:tagish
      th:thailandese
      tht:tahltan
      ti:tigrino
      tig:tigre
      tiv:tiv
      tk:turcomanno
      tkl:tokelau
      tkr:tsakhur
      tl:tagalog
      tlh:klingon
      tli:tlingit
      tly:taliscio
      tmh:tamashek
      tn:tswana
      to:tongano
      tog:nyasa del Tonga
      tok:toki pona
      tpi:tok pisin
      tr:turco
      tru:turoyo
      trv:taroko
      ts:tsonga
      tsd:zaconico
      tsi:tsimshian
      tt:tataro
      ttm:tutchone settentrionale
      ttt:tat islamico
      tum:tumbuka
      tvl:tuvalu
      tw:ci
      twq:tasawaq
      ty:taitiano
      tyv:tuvinian
      tzm:tamazight
      udm:udmurt
      ug:uiguro
      uga:ugaritico
      uk:ucraino
      umb:mbundu
      und:lingua imprecisata
      ur:urdu
      uz:uzbeco
      ve:venda
      vec:veneto
      vep:vepso
      vi:vietnamita
      vls:fiammingo occidentale
      vmw:macua
      vo:volapük
      vot:voto
      vro:võro
      vun:vunjo
      wa:vallone
      wae:walser
      wal:walamo
      war:waray
      was:washo
      wbp:warlpiri
      wo:wolof
      wuu:wu
      xal:kalmyk
      xh:xhosa
      xmf:mengrelio
      xnr:kangri
      xog:soga
      yao:yao (bantu)
      yap:yapese
      yav:yangben
      ybb:yemba
      yi:yiddish
      yo:yoruba
      yrl:nheengatu
      yue:cantonese
      yue-alt-menu:cinese (cantonese)
      za:zhuang
      zap:zapotec
      zbl:blissymbol
      zea:zelandese
      zen:zenaga
      zgh:tamazight del Marocco standard
      zh:cinese
      zh-alt-menu:cinese (mandarino)
      zh-Hans:cinese semplificato
      zh-Hans-alt-long:cinese mandarino semplificato
      zh-Hant:cinese tradizionale
      zh-Hant-alt-long:cinese mandarino tradizionale
      zu:zulu
      zun:zuni
      zxx:nessun contenuto linguistico
      zza:zaza
      """.trimIndent() }

  val it_CH: String? = null

  val it_SM: String? = null

  val it_VA: String? = null

  val ja: String by lazy { """
      aa:アファル語
      ab:アブハズ語
      ace:アチェ語
      ach:アチョリ語
      ada:アダングメ語
      ady:アディゲ語
      ae:アヴェスタ語
      aeb:チュニジア・アラビア語
      af:アフリカーンス語
      afh:アフリヒリ語
      agq:アゲム語
      ain:アイヌ語
      ak:アカン語
      akk:アッカド語
      akz:アラバマ語
      ale:アレウト語
      aln:ゲグ・アルバニア語
      alt:南アルタイ語
      am:アムハラ語
      an:アラゴン語
      ang:古英語
      ann:オボロ語
      anp:アンギカ語
      ar:アラビア語
      ar-001:現代標準アラビア語
      arc:アラム語
      arn:マプチェ語
      aro:アラオナ語
      arp:アラパホー語
      arq:アルジェリア・アラビア語
      ars:ナジュド地方・アラビア語
      ars-alt-menu:アラビア語（ナジュド地方）
      arw:アラワク語
      ary:モロッコ・アラビア語
      arz:エジプト・アラビア語
      as:アッサム語
      asa:アス語
      ase:アメリカ手話
      ast:アストゥリアス語
      atj:アティカメク語
      av:アヴァル語
      avk:コタヴァ
      awa:アワディー語
      ay:アイマラ語
      az:アゼルバイジャン語
      az-alt-short:アゼリー語
      ba:バシキール語
      bal:バルーチー語
      ban:バリ語
      bar:バイエルン・オーストリア語
      bas:バサ語
      bax:バムン語
      bbc:トバ・バタク語
      bbj:ゴーマラ語
      be:ベラルーシ語
      bej:ベジャ語
      bem:ベンバ語
      bew:ベタウィ語
      bez:ベナ語
      bfd:バフット語
      bfq:バダガ語
      bg:ブルガリア語
      bgc:ハリヤーンウィー語
      bgn:西バローチー語
      bho:ボージュプリー語
      bi:ビスラマ語
      bik:ビコル語
      bin:ビニ語
      bjn:バンジャル語
      bkm:コム語
      bla:シクシカ語
      blo:アニ語 (blo)
      bm:バンバラ語
      bn:ベンガル語
      bo:チベット語
      bpy:ビシュヌプリヤ・マニプリ語
      bqi:バフティヤーリー語
      br:ブルトン語
      bra:ブラジ語
      brh:ブラフイ語
      brx:ボド語
      bs:ボスニア語
      bss:アコース語
      bua:ブリヤート語
      bug:ブギ語
      bum:ブル語
      byn:ビリン語
      byv:メドゥンバ語
      ca:カタロニア語
      cad:カドー語
      car:カリブ語
      cay:カユーガ語
      cch:チャワイ語
      ccp:チャクマ語
      ce:チェチェン語
      ceb:セブアノ語
      cgg:チガ語
      ch:チャモロ語
      chb:チブチャ語
      chg:チャガタイ語
      chk:チューク語
      chm:マリ語
      chn:チヌーク混成語
      cho:チョクトー語
      chp:チペワイアン語
      chr:チェロキー語
      chy:シャイアン語
      ckb:中央クルド語
      ckb-alt-menu:クルド語（中央）
      ckb-alt-variant:クルド語（ソラニー）
      clc:チルコーティン語
      co:コルシカ語
      cop:コプト語
      cps:カピス語
      cr:クリー語
      crg:ミチフ語
      crh:クリミア・タタール語
      crj:東部クリー語(南部)
      crk:平原クリー語
      crl:東部クリー語(北部)
      crm:ムースクリー語
      crr:カロライナ・アルゴンキン語
      crs:セーシェル・クレオール語
      cs:チェコ語
      csb:カシューブ語
      csw:湿原クリー語
      cu:教会スラブ語
      cv:チュヴァシ語
      cy:ウェールズ語
      da:デンマーク語
      dak:ダコタ語
      dar:ダルグワ語
      dav:タイタ語
      de:ドイツ語
      de-CH:標準ドイツ語 (スイス)
      del:デラウェア語
      den:スレイビー語
      dgr:ドグリブ語
      din:ディンカ語
      dje:ザルマ語
      doi:ドーグリー語
      dsb:低地ソルブ語
      dtp:中央ドゥスン語
      dua:ドゥアラ語
      dum:中世オランダ語
      dv:ディベヒ語
      dyo:ジョラ＝フォニィ語
      dyu:ジュラ語
      dz:ゾンカ語
      dzg:ダザガ語
      ebu:エンブ語
      ee:エウェ語
      efi:エフィク語
      egl:エミリア語
      egy:古代エジプト語
      eka:エカジュク語
      el:ギリシャ語
      elx:エラム語
      en:英語
      en-AU:オーストラリア英語
      en-CA:カナダ英語
      en-GB:イギリス英語
      en-GB-alt-short:英語(英国)
      en-US:アメリカ英語
      en-US-alt-short:英語(米国)
      enm:中英語
      eo:エスペラント語
      es:スペイン語
      es-ES:スペイン語 (イベリア半島)
      esu:中央アラスカ・ユピック語
      et:エストニア語
      eu:バスク語
      ewo:エウォンド語
      ext:エストレマドゥーラ語
      fa:ペルシア語
      fa-AF:ダリー語
      fan:ファング語
      fat:ファンティー語
      ff:フラ語
      fi:フィンランド語
      fil:フィリピノ語
      fit:トルネダール・フィンランド語
      fj:フィジー語
      fo:フェロー語
      fon:フォン語
      fr:フランス語
      frc:ケイジャン・フランス語
      frm:中期フランス語
      fro:古フランス語
      frp:アルピタン語
      frr:北フリジア語
      frs:東フリジア語
      fur:フリウリ語
      fy:西フリジア語
      ga:アイルランド語
      gaa:ガ語
      gag:ガガウズ語
      gan:贛語
      gay:ガヨ語
      gba:バヤ語
      gbz:ダリー語(ゾロアスター教)
      gd:スコットランド・ゲール語
      gez:ゲエズ語
      gil:キリバス語
      gl:ガリシア語
      glk:ギラキ語
      gmh:中高ドイツ語
      gn:グアラニー語
      goh:古高ドイツ語
      gon:ゴーンディー語
      gor:ゴロンタロ語
      got:ゴート語
      grb:グレボ語
      grc:古代ギリシャ語
      gsw:スイスドイツ語
      gu:グジャラート語
      guc:ワユ語
      gur:フラフラ語
      guz:グシイ語
      gv:マン島語
      gwi:グウィッチン語
      ha:ハウサ語
      hai:ハイダ語
      hak:客家語
      haw:ハワイ語
      hax:南部ハイダ語
      he:ヘブライ語
      hi:ヒンディー語
      hi-Latn-alt-variant:インド英語 (ヒングリッシュ)
      hif:フィジー・ヒンディー語
      hil:ヒリガイノン語
      hit:ヒッタイト語
      hmn:フモン語
      ho:ヒリモツ語
      hr:クロアチア語
      hsb:高地ソルブ語
      hsn:湘語
      ht:ハイチ・クレオール語
      hu:ハンガリー語
      hup:フパ語
      hur:ハルコメレム語
      hy:アルメニア語
      hz:ヘレロ語
      ia:インターリングア
      iba:イバン語
      ibb:イビビオ語
      id:インドネシア語
      ie:インターリング
      ig:イボ語
      ii:四川イ語
      ik:イヌピアック語
      ikt:イヌイナクトゥン語
      ilo:イロカノ語
      inh:イングーシ語
      io:イド語
      is:アイスランド語
      it:イタリア語
      iu:イヌクティトット語
      izh:イングリア語
      ja:日本語
      jam:ジャマイカ・クレオール語
      jbo:ロジバン語
      jgo:ンゴンバ語
      jmc:マチャメ語
      jpr:ユダヤ・ペルシア語
      jrb:ユダヤ・アラビア語
      jut:ユトランド語
      jv:ジャワ語
      ka:ジョージア語
      kaa:カラカルパク語
      kab:カビル語
      kac:カチン語
      kaj:カジェ語
      kam:カンバ語
      kaw:カウィ語
      kbd:カバルド語
      kbl:カネンブ語
      kcg:カタブ語
      kde:マコンデ語
      kea:カーボベルデ・クレオール語
      ken:ニャン語
      kfo:コロ語
      kg:コンゴ語
      kgp:カインガング語
      kha:カシ語
      kho:コータン語
      khq:コイラ・チーニ語
      khw:コワール語
      ki:キクユ語
      kiu:キルマンジュキ語
      kj:クワニャマ語
      kk:カザフ語
      kkj:カコ語
      kl:グリーンランド語
      kln:カレンジン語
      km:クメール語
      kmb:キンブンド語
      kn:カンナダ語
      ko:韓国語
      koi:コミ・ペルミャク語
      kok:コンカニ語
      kos:コスラエ語
      kpe:クペレ語
      kr:カヌリ語
      krc:カラチャイ・バルカル語
      kri:クリオ語
      krj:キナライア語
      krl:カレリア語
      kru:クルク語
      ks:カシミール語
      ksb:サンバー語
      ksf:バフィア語
      ksh:ケルン語
      ku:クルド語
      kum:クムク語
      kut:クテナイ語
      kv:コミ語
      kw:コーンウォール語
      kwk:クヮキゥワラ語
      kxv:クーヴィンガ語
      ky:キルギス語
      la:ラテン語
      lad:ラディノ語
      lag:ランギ語
      lah:ラフンダー語
      lam:ランバ語
      lb:ルクセンブルク語
      lez:レズギ語
      lfn:リングア・フランカ・ノバ
      lg:ガンダ語
      li:リンブルフ語
      lij:リグリア語
      lil:リルエット語
      liv:リヴォニア語
      lkt:ラコタ語
      lmo:ロンバルド語
      ln:リンガラ語
      lo:ラオ語
      lol:モンゴ語
      lou:ルイジアナ・クレオール語
      loz:ロジ語
      lrc:北ロル語
      lsm:サーミア語
      lt:リトアニア語
      ltg:ラトガリア語
      lu:ルバ・カタンガ語
      lua:ルバ・ルルア語
      lui:ルイセーニョ語
      lun:ルンダ語
      luo:ルオ語
      lus:ミゾ語
      luy:ルヒヤ語
      lv:ラトビア語
      lzh:漢文
      lzz:ラズ語
      mad:マドゥラ語
      maf:マファ語
      mag:マガヒー語
      mai:マイティリー語
      mak:マカッサル語
      man:マンディンゴ語
      mas:マサイ語
      mde:マバ語
      mdf:モクシャ語
      mdr:マンダル語
      men:メンデ語
      mer:メル語
      mfe:モーリシャス・クレオール語
      mg:マダガスカル語
      mga:中期アイルランド語
      mgh:マクア・ミート語
      mgo:メタ語
      mh:マーシャル語
      mi:マオリ語
      mic:ミクマク語
      min:ミナンカバウ語
      mk:マケドニア語
      ml:マラヤーラム語
      mn:モンゴル語
      mnc:満州語
      mni:マニプリ語
      moe:イヌー＝アイムン語
      moh:モーホーク語
      mos:モシ語
      mr:マラーティー語
      mrj:山地マリ語
      ms:マレー語
      mt:マルタ語
      mua:ムンダン語
      mul:複数言語
      mus:クリーク語
      mwl:ミランダ語
      mwr:マールワーリー語
      mwv:メンタワイ語
      my:ミャンマー語
      mye:ミエネ語
      myv:エルジャ語
      mzn:マーザンダラーン語
      na:ナウル語
      nan:閩南語
      nap:ナポリ語
      naq:ナマ語
      nb:ノルウェー語(ブークモール)
      nd:北ンデベレ語
      nds:低地ドイツ語
      ne:ネパール語
      new:ネワール語
      ng:ンドンガ語
      nia:ニアス語
      niu:ニウーエイ語
      njo:アオ・ナガ語
      nl:オランダ語
      nl-BE:フラマン語
      nmg:クワシオ語
      nn:ノルウェー語(ニーノシュク)
      nnh:ンジエムブーン語
      no:ノルウェー語
      nog:ノガイ語
      non:古ノルド語
      nov:ノヴィアル
      nqo:ンコ語
      nr:南ンデベレ語
      nso:北部ソト語
      nus:ヌエル語
      nv:ナバホ語
      nwc:古典ネワール語
      ny:ニャンジャ語
      nym:ニャムウェジ語
      nyn:ニャンコレ語
      nyo:ニョロ語
      nzi:ンゼマ語
      oc:オック語
      oj:オジブウェー語
      ojb:北西部オジブワ語
      ojc:中部オジブワ語
      ojs:セヴァーン・オジブワ語
      ojw:西部オジブワ語
      oka:オカナガン語
      om:オロモ語
      or:オディア語
      os:オセット語
      osa:オセージ語
      ota:オスマントルコ語
      pa:パンジャブ語
      pag:パンガシナン語
      pal:パフラヴィー語
      pam:パンパンガ語
      pap:パピアメント語
      pau:パラオ語
      pcd:ピカルディ語
      pcm:ナイジェリア・ピジン語
      pdc:ペンシルベニア・ドイツ語
      pdt:メノナイト低地ドイツ語
      peo:古代ペルシア語
      pfl:プファルツ語
      phn:フェニキア語
      pi:パーリ語
      pis:ピジン語
      pl:ポーランド語
      pms:ピエモンテ語
      pnt:ポントス・ギリシャ語
      pon:ポンペイ語
      pqm:マリシート＝パサマコディ語
      prg:プロシア語
      pro:古期プロバンス語
      ps:パシュトゥー語
      ps-alt-variant:パシュトゥ語
      pt:ポルトガル語
      pt-PT:ポルトガル語 (イベリア半島)
      qu:ケチュア語
      quc:キチェ語
      qug:チンボラソ高地ケチュア語
      raj:ラージャスターン語
      rap:ラパヌイ語
      rar:ラロトンガ語
      rgn:ロマーニャ語
      rhg:ロヒンギャ語
      rif:リーフ語
      rm:ロマンシュ語
      rn:ルンディ語
      ro:ルーマニア語
      ro-MD:モルダビア語
      rof:ロンボ語
      rom:ロマーニー語
      rtm:ロツマ語
      ru:ロシア語
      rue:ルシン語
      rug:ロヴィアナ語
      rup:アルーマニア語
      rw:キニアルワンダ語
      rwk:ルワ語
      sa:サンスクリット語
      sad:サンダウェ語
      sah:サハ語
      sam:サマリア・アラム語
      saq:サンブル語
      sas:ササク語
      sat:サンターリー語
      saz:サウラーシュトラ語
      sba:ンガムバイ語
      sbp:サング語
      sc:サルデーニャ語
      scn:シチリア語
      sco:スコットランド語
      sd:シンド語
      sdc:サッサリ・サルデーニャ語
      sdh:南部クルド語
      se:北サーミ語
      see:セネカ語
      seh:セナ語
      sei:セリ語
      sel:セリクプ語
      ses:コイラボロ・センニ語
      sg:サンゴ語
      sga:古アイルランド語
      sgs:サモギティア語
      sh:セルボ・クロアチア語
      shi:タシルハイト語
      shn:シャン語
      shu:チャド・アラビア語
      si:シンハラ語
      sid:シダモ語
      sk:スロバキア語
      sl:スロベニア語
      slh:南部ルシュツィード語
      sli:低シレジア語
      sly:スラヤール語
      sm:サモア語
      sma:南サーミ語
      smj:ルレ・サーミ語
      smn:イナリ・サーミ語
      sms:スコルト・サーミ語
      sn:ショナ語
      snk:ソニンケ語
      so:ソマリ語
      sog:ソグド語
      sq:アルバニア語
      sr:セルビア語
      srn:スリナム語
      srr:セレル語
      ss:スワジ語
      ssy:サホ語
      st:南部ソト語
      stq:ザーターフリジア語
      str:ストレイツセイリッシュ語
      su:スンダ語
      suk:スクマ語
      sus:スス語
      sux:シュメール語
      sv:スウェーデン語
      sw:スワヒリ語
      sw-CD:コンゴ・スワヒリ語
      swb:コモロ語
      syc:古典シリア語
      syr:シリア語
      szl:シレジア語
      ta:タミル語
      tce:南部トゥショーニ語
      tcy:トゥル語
      te:テルグ語
      tem:テムネ語
      teo:テソ語
      ter:テレーノ語
      tet:テトゥン語
      tg:タジク語
      tgx:タギシュ語
      th:タイ語
      tht:タールタン語
      ti:ティグリニア語
      tig:ティグレ語
      tiv:ティブ語
      tk:トルクメン語
      tkl:トケラウ語
      tkr:ツァフル語
      tl:タガログ語
      tlh:クリンゴン語
      tli:トリンギット語
      tly:タリシュ語
      tmh:タマシェク語
      tn:ツワナ語
      to:トンガ語
      tog:トンガ語(ニアサ)
      tok:トキポナ語
      tpi:トク・ピシン語
      tr:トルコ語
      tru:トゥロヨ語
      trv:タロコ語
      ts:ツォンガ語
      tsd:ツァコン語
      tsi:チムシュ語
      tt:タタール語
      ttm:北部トゥショーニ語
      ttt:ムスリム・タタール語
      tum:トゥンブカ語
      tvl:ツバル語
      tw:トウィ語
      twq:タサワク語
      ty:タヒチ語
      tyv:トゥヴァ語
      tzm:中央アトラス・タマジクト語
      udm:ウドムルト語
      ug:ウイグル語
      ug-alt-variant:ウィグル語
      uga:ウガリト語
      uk:ウクライナ語
      umb:ムブンドゥ語
      und:言語不明
      ur:ウルドゥー語
      uz:ウズベク語
      vai:ヴァイ語
      ve:ベンダ語
      vec:ヴェネト語
      vep:ヴェプス語
      vi:ベトナム語
      vls:西フラマン語
      vmf:マインフランク語
      vmw:マクア語
      vo:ヴォラピュク語
      vot:ヴォート語
      vro:ヴォロ語
      vun:ヴンジョ語
      wa:ワロン語
      wae:ヴァリス語
      wal:ウォライタ語
      war:ワライ語
      was:ワショ語
      wbp:ワルピリ語
      wo:ウォロフ語
      wuu:呉語
      xal:カルムイク語
      xh:コサ語
      xmf:メグレル語
      xnr:カーングリー語
      xog:ソガ語
      yao:ヤオ語
      yap:ヤップ語
      yav:ヤンベン語
      ybb:イエンバ語
      yi:イディッシュ語
      yo:ヨルバ語
      yrl:ニェエンガトゥ語
      yue:広東語
      yue-alt-menu:中国語 (広東語)
      za:チワン語
      zap:サポテカ語
      zbl:ブリスシンボル
      zea:ゼーラント語
      zen:ゼナガ語
      zgh:標準モロッコ タマジクト語
      zh:中国語
      zh-alt-menu:中国語 (標準語)
      zh-Hans:簡体中国語
      zh-Hans-alt-long:標準中国語 (簡体字)
      zh-Hant:繁体中国語
      zh-Hant-alt-long:標準中国語 (繁体字)
      zu:ズールー語
      zun:ズニ語
      zxx:言語的内容なし
      zza:ザザ語
      """.trimIndent() }

  val jbo: String by lazy { """
      jbo:la .lojban.
      """.trimIndent() }

  val jgo: String by lazy { """
      ar:Alâbɛ
      de:Njáman
      el:Ŋgɛlɛ̂k
      en:Aŋgɛlúshi
      fr:Fɛlánci
      jgo:Ndaꞌa
      und:cú-pʉɔ yi pɛ́ ká kɛ́ jí
      zh:Shinwâ
      zh-alt-menu:Shinwâ
      """.trimIndent() }

  val jmc: String by lazy { """
      ak:Kiakanyi
      am:Kiamharyi
      ar:Kyiarabu
      be:Kyibelarusi
      bg:Kyibulgaryia
      bn:Kyibangla
      cs:Kyichecki
      de:Kyijerumani
      el:Kyigiriki
      en:Kyingereza
      es:Kyihispania
      fa:Kyiajemi
      fr:Kyifaransa
      ha:Kyihausa
      hi:Kyihindi
      hu:Kyihungari
      id:Kyiindonesia
      ig:Kyiigbo
      it:Kyiitaliano
      ja:Kyijapani
      jmc:Kimachame
      jv:Kyijava
      km:Kyikambodia
      ko:Kyikorea
      ms:Kyimalesia
      my:Kyiburma
      ne:Kyinepali
      nl:Kyiholanzi
      pa:Kyipunjabi
      pl:Kyipolandi
      pt:Kyireno
      ro:Kyiromania
      ru:Kyirusi
      rw:Kyinyarwanda
      so:Kyisomalyi
      sv:Kyiswidi
      ta:Kyitamil
      th:Kyitailandi
      tr:Kyiturukyi
      uk:Kyiukrania
      ur:Kyiurdu
      vi:Kyivietinamu
      yo:Kyiyoruba
      zh:Kyichina
      zh-alt-menu:Kyichina
      zu:Kyizulu
      """.trimIndent() }

  val jv: String by lazy { """
      ab:Abkhazian
      ace:Achinese
      ada:Adangme
      ady:Adyghe
      af:Afrika
      agq:Aghem
      ain:Ainu
      ak:Akan
      ale:Aleut
      alt:Altai Sisih Kidul
      am:Amharik
      an:Aragonese
      ann:Obolo
      anp:Angika
      ar:Arab
      ar-001:Arab Standar Anyar
      arn:Mapushe
      arp:Arapaho
      ars:Arab Najdi
      as:Assam
      asa:Asu
      ast:Asturia
      atj:Atikamekw
      av:Avaric
      awa:Awadhi
      ay:Aymara
      az:Azerbaijan
      az-alt-short:Azerbaijan
      ba:Bashkir
      ban:Bali
      bas:Basaa
      be:Belarus
      bem:Bemba
      bez:Bena
      bg:Bulgaria
      bgc:Haryanvi
      bho:Bhojpuri
      bi:Bislama
      bin:Bini
      bla:Siksiká
      blo:Anii
      bm:Bambara
      bn:Bengali
      bo:Tibet
      br:Breton
      brx:Bodo
      bs:Bosnia lan Hercegovina
      bug:Bugis
      byn:Blin
      ca:Katala
      cay:Kayuga
      ccp:Chakma
      ce:Chechen
      ceb:Cebuano
      cgg:Chiga
      ch:Khamorro
      chk:Chuukese
      chm:Mari
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      ckb:Kurdi Tengah
      ckb-alt-menu:Kurdi Tengah
      ckb-alt-variant:Kurdi Tengah
      clc:Chilcotin
      co:Korsika
      crg:Michif
      crj:Kree Kidul Wetan
      crk:Kree Polos
      crl:Kree Lor Segara
      crm:Moose Cree
      crr:Karolina Algonquian
      cs:Ceska
      csw:Kree Rawa
      cu:Slavia Gerejani
      cv:Khuvash
      cy:Welsh
      da:Dansk
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:Jérman
      de-AT:Jérman Ostenrik
      de-CH:Jérman Switserlan
      dgr:Dogrib
      dje:Zarma
      doi:Dogri
      dsb:Sorbia Non Standar
      dua:Duala
      dv:Divehi
      dyo:Jola-Fonyi
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      eka:Ekajuk
      el:Yunani
      en:Inggris
      en-AU:Inggris Ostrali
      en-CA:Inggris Kanada
      en-GB:Inggris Karajan Manunggal
      en-GB-alt-short:Inggris (Britania)
      en-US:Inggris Amérika Sarékat
      en-US-alt-short:Inggris (AS)
      eo:Esperanto
      es:Spanyol
      es-419:Spanyol (Amerika Latin)
      es-ES:Spanyol (Eropah)
      es-MX:Spanyol (Meksiko)
      et:Estonia
      eu:Basque
      ewo:Ewondo
      fa:Persia
      ff:Fula
      fi:Suomi
      fil:Tagalog
      fj:Fijian
      fo:Faroe
      fon:Fon
      fr:Prancis
      fr-CA:Prancis Kanada
      fr-CH:Prancis Switserlan
      frc:Prancis Cajun
      frr:Frisian Lor Segara
      fur:Friulian
      fy:Frisia Sisih Kulon
      ga:Irlandia
      gaa:Ga
      gd:Gaulia
      gez:Gees
      gil:Gilbertese
      gl:Galisia
      gn:Guarani
      gor:Gorontalo
      gsw:Jerman Swiss
      gu:Gujarat
      guz:Gusii
      gv:Manx
      gwi:Gwichʼin
      ha:Hausa
      hai:Haida
      haw:Hawaii
      hax:Haida Sisih Kidul
      he:Ibrani
      hi:India
      hil:Hiligainon
      hmn:Hmong
      hr:Kroasia
      hsb:Sorbia Standar
      ht:Kreol Haiti
      hu:Hungaria
      hup:Hupa
      hur:Halkomelem
      hy:Armenia
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Indonesia
      ie:Interlingue
      ig:Iqbo
      ii:Sichuan Yi
      ikt:Kanada Inuktitut Sisih Kulon
      ilo:Iloko
      inh:Ingus
      io:Ido
      is:Islandia
      it:Italia
      iu:Inuktitut
      ja:Jepang
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jv:Jawa
      ka:Georgia
      kab:Kabyle
      kac:Kakhin
      kaj:Jju
      kam:Kamba
      kbd:Kabardian
      kcg:Tyap
      kde:Makonde
      kea:Kabuverdianu
      kfo:Koro
      kgp:Kaingang
      kha:Khasi
      khq:Koyra Chiini
      ki:Kikuyu
      kj:Kuanyama
      kk:Kazakh
      kkj:Kako
      kl:Kalaallisut
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Korea
      kok:Konkani
      kpe:Kpelle
      kr:Kanuri
      krc:Karachai-Balkar
      krl:Karelian
      kru:Kuruk
      ks:Kashmiri
      ksb:Shambala
      ksf:Bafia
      ksh:Colonia
      ku:Kurdis
      kum:Kumik
      kv:Komi
      kw:Kernowek
      kwk:Kwakʼwala
      kxv:Kuvi
      ky:Kirgis
      la:Latin
      lad:Ladino
      lag:Langi
      lb:Luksemburg
      lez:Lesghian
      lg:Ganda
      li:Limburgish
      lij:Liguria
      lil:Lillooet
      lkt:Lakota
      lmo:Lombard
      ln:Lingala
      lo:Laos
      lou:Louisiana Creole
      loz:Losi
      lrc:Luri Sisih Lor
      lsm:Saamia
      lt:Lithuania
      lu:Luba-Katanga
      lua:Luba-Lulua
      lun:Lunda
      luo:Luo
      lus:Miso
      luy:Luyia
      lv:Latvia
      mad:Madura
      mag:Magahi
      mai:Maithili
      mak:Makasar
      mas:Masai
      mdf:Moksha
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagasi
      mgh:Makhuwa-Meeto
      mgo:Meta’
      mh:Marshallese
      mi:Maori
      mic:Mi'kmak
      min:Minangkabau
      mk:Makedonia
      ml:Malayalam
      mn:Mongolia
      mni:Manipuri
      moe:Innu-aimun
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      ms:Melayu
      mt:Malta
      mua:Mundang
      mul:Basa Multilingua
      mus:Muskogee
      mwl:Mirandese
      my:Myanmar
      myv:Ersia
      mzn:Mazanderani
      na:Nauru
      nap:Neapolitan
      naq:Nama
      nb:Bokmål Norwegia
      nd:Ndebele Lor
      nds:Jerman Non Standar
      ne:Nepal
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niuean
      nl:Walanda
      nl-BE:Flemis
      nmg:Kwasio
      nn:Nynorsk Norwegia
      nnh:Ngiemboon
      no:Norwegia
      nog:Nogai
      nqo:N’Ko
      nr:Ndebele Kidul
      nso:Sotho Sisih Lor
      nus:Nuer
      nv:Navajo
      ny:Nyanja
      nyn:Nyankole
      oc:Ossitan
      ojb:Ojibwa Kulon Segara
      ojc:Ojibwa Tengah
      ojs:Oji-Kree
      ojw:Ojibwa Sisih Kulon
      oka:Okanagan
      om:Oromo
      or:Odia
      os:Ossetia
      pa:Punjab
      pag:Pangasinan
      pam:Pampanga
      pap:Papiamento
      pau:Palauan
      pcm:Nigeria Pidgin
      pis:Pijin
      pl:Polandia
      pqm:Maliseet-Passamakuoddi
      prg:Prusia
      ps:Pashto
      pt:Portugis
      pt-BR:Portugis Brasil
      pt-PT:Portugis Portugal
      qu:Quechua
      raj:Rajasthani
      rap:Rapanui
      rar:Rarotongan
      rhg:Rohingya
      rm:Roman
      rn:Rundi
      ro:Rumania
      rof:Rombo
      ru:Rusia
      rup:Aromanian
      rw:Kinyarwanda
      rwk:Rwa
      sa:Sanskerta
      sad:Sandawe
      sah:Yakut
      saq:Samburu
      sat:Santali
      sba:Ngambai
      sbp:Sangu
      sc:Sardinia
      scn:Sisilia
      sco:Skots
      sd:Sindhi
      se:Sami Sisih Lor
      seh:Sena
      ses:Koyraboro Senni
      sg:Sango
      shi:Tachelhit
      shn:Shan
      si:Sinhala
      sk:Slowakia
      sl:Slovenia
      slh:Lushootseed Sisih Kidul
      sm:Samoa
      smn:Inari Sami
      sms:Skolt Sami
      sn:Shona
      snk:Soninke
      so:Somalia
      sq:Albania
      sr:Serbia
      srn:Sranan Tongo
      ss:Swati
      st:Sotho Sisih Kidul
      str:Selat Salish
      su:Sunda
      suk:Sukuma
      sv:Swedia
      sw:Swahili
      swb:Komorian
      syr:Siriak
      szl:Silesia
      ta:Tamil
      tce:Tutkhone Sisih Kidul
      te:Telugu
      tem:Timne
      teo:Teso
      tet:Tetum
      tg:Tajik
      tgx:Tagish
      th:Thailand
      tht:Tahltan
      ti:Tigrinya
      tig:Tigre
      tk:Turkmen
      tlh:Klingon
      tli:Tlingit
      tn:Tswana
      to:Tonga
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Turki
      trv:Taroko
      ts:Tsonga
      tt:Tatar
      ttm:Tutkhone Sisih Lor
      tum:Tumbuka
      tvl:Tupalu
      twq:Tasawaq
      ty:Tahiti
      tyv:Tupinian
      tzm:Tamazight Atlas Tengah
      udm:Udmurt
      ug:Uighur
      uk:Ukraina
      umb:Umbundu
      und:Basa Ora Dikenali
      ur:Urdu
      uz:Uzbek
      vai:Vai
      ve:Venda
      vec:Venesia
      vi:Vietnam
      vmw:Makhuwa
      vo:Volapuk
      vun:Vunjo
      wa:Walloon
      wae:Walser
      wal:Wolaitta
      war:Warai
      wo:Wolof
      wuu:Tyonghwa Wu
      xal:Kalmik
      xh:Xhosa
      xnr:Kangri
      xog:Soga
      yav:Yangben
      ybb:Yemba
      yi:Yiddish
      yo:Yoruba
      yrl:Nheengatu
      yue:Kanton
      yue-alt-menu:Tyonghwa, Kanton
      za:Zhuang
      zgh:Tamazight Moroko Standar
      zh:Tyonghwa
      zh-alt-menu:Tyonghwa, Mandarin
      zh-Hans:Tyonghwa (Ringkes)
      zh-Hans-alt-long:Tyonghwa Mandarin (Ringkes)
      zh-Hant:Tyonghwa (Tradisional)
      zh-Hant-alt-long:Tyonghwa Mandarin (Tradisional)
      zu:Zulu
      zun:Zuni
      zxx:Konten tanpa linguistik
      zza:Zaza
      """.trimIndent() }

  val ka: String by lazy { """
      aa:აფარი
      ab:აფხაზური
      ace:აჩეხური
      ach:აჩოლი
      ada:ადანგმე
      ady:ადიღეური
      ae:ავესტური
      af:აფრიკაანსი
      agq:აღემი
      ain:აინუური
      ak:აკანი
      akk:აქადური
      ale:ალეუტური
      alt:სამხრეთ ალთაური
      am:ამჰარული
      an:არაგონული
      ang:ძველი ინგლისური
      ann:ობოლო
      anp:ანგიკა
      ar:არაბული
      ar-001:თანამედროვე სტანდარტული არაბული
      arc:არამეული
      arn:მაპუდუნგუნი
      arp:არაპაჰო
      ars:ნაჯის არაბული
      arw:არავაკი
      as:ასამური
      asa:ასუ
      ast:ასტურიული
      atj:ატიკამეკი
      av:ხუნძური
      awa:ავადი
      ay:აიმარა
      az:აზერბაიჯანული
      az-alt-short:აზერბაიჯანული
      ba:ბაშკირული
      bal:ბელუჯი
      ban:ბალინური
      bas:ბასა
      bax:ბამუნი
      be:ბელარუსული
      bej:ბეჯა
      bem:ბემბა
      bez:ბენა
      bg:ბულგარული
      bgc:ჰარიანვი
      bgn:დასავლეთ ბელუჯი
      bho:ბოჯპური
      bi:ბისლამა
      bin:ბინი
      bla:სიკსიკა
      blo:ანიი
      bm:ბამბარა
      bn:ბენგალური
      bo:ტიბეტური
      br:ბრეტონული
      bra:ბრაჯი
      brx:ბოდო
      bs:ბოსნიური
      bua:ბურიატული
      bug:ბუგინური
      byn:ბილინი
      ca:კატალანური
      cay:კაიუგა
      ccp:ჩაკმა
      ce:ჩეჩნური
      ceb:სებუანო
      cgg:ჩიგა
      ch:ჩამორო
      chb:ჩიბჩა
      chk:ჩუკოტკური
      chm:მარიული
      chn:ჩინუკის ჟარგონი
      cho:ჩოკტო
      chp:ჩიპევიანი
      chr:ჩეროკი
      chy:ჩეიენი
      ckb:ცენტრალური ქურთული
      ckb-alt-menu:ცენტრალური ქურთული
      ckb-alt-variant:ცენტრალური ქურთული
      clc:ჩილკოტინი
      co:კორსიკული
      cop:კოპტური
      cr:კრი
      crg:მიჩიფი
      crh:ყირიმულ-თურქული
      crj:სამხრეთ-აღმოსავლეთის კრი
      crk:დაბლობის კრი
      crl:ჩრდილო-აღმოსავლეთის კრი
      crm:მუსური კრი
      crr:კაროლინური ალგონკინი
      crs:სესელვა-კრეოლური ფრანგული
      cs:ჩეხური
      csb:კაშუბური
      csw:ჭაობის კრი
      cu:საეკლესიო სლავური
      cv:ჩუვაშური
      cy:უელსური
      da:დანიური
      dak:დაკოტური
      dar:დარგუული
      dav:ტაიტა
      de:გერმანული
      de-AT:ავსტრიული გერმანული
      de-CH:შვეიცარიული ზემოგერმანული
      del:დელავერული
      den:სლეივი
      dgr:დოგრიბი
      din:დინკა
      dje:ზარმა
      doi:დოგრი
      dsb:ქვემოსორბული
      dua:დუალა
      dum:საშუალო ჰოლანდიური
      dv:დივეჰი
      dyo:დიოლა
      dyu:დიულა
      dz:ძონგკხა
      dzg:დაზაგა
      ebu:ემბუ
      ee:ევე
      efi:ეფიკი
      egy:ძველეგვიპტური
      eka:ეკაჯუკი
      el:ბერძნული
      en:ინგლისური
      en-AU:ავსტრალიური ინგლისური
      en-CA:კანადური ინგლისური
      en-GB:ბრიტანული ინგლისური
      en-GB-alt-short:ინგლისური (გაერთიანებული სამეფო)
      en-US:ამერიკული ინგლისური
      en-US-alt-short:აშშ ინგლისური
      enm:საშუალო ინგლისური
      eo:ესპერანტო
      es:ესპანური
      es-419:ლათინურ ამერიკული ესპანური
      es-ES:ევროპული ესპანური
      es-MX:მექსიკური ესპანური
      et:ესტონური
      eu:ბასკური
      ewo:ევონდო
      fa:სპარსული
      fa-AF:დარი
      ff:ფულა
      fi:ფინური
      fil:ფილიპინური
      fj:ფიჯი
      fo:ფარერული
      fon:ფონი
      fr:ფრანგული
      fr-CA:კანადური ფრანგული
      fr-CH:შვეიცარიული ფრანგული
      frc:კაჟუნური ფრანგული
      frm:საშუალო ფრანგული
      fro:ძველი ფრანგული
      frr:ჩრდილოფრიზიული
      frs:აღმოსავლეთფრიზიული
      fur:ფრიულური
      fy:დასავლეთფრიზიული
      ga:ირლანდიური
      gaa:გა
      gag:გაგაუზური
      gba:გბაია
      gd:შოტლანდიური გელური
      gez:გეეზი
      gil:გილბერტული
      gl:გალისიური
      gmh:საშუალო ზემოგერმანული
      gn:გუარანი
      goh:ძველი ზემოგერმანული
      gon:გონდი
      gor:გორონტალო
      got:გოთური
      grc:ძველი ბერძნული
      gsw:შვეიცარიული გერმანული
      gu:გუჯარათი
      guz:გუსიი
      gv:მენური
      gwi:გვიჩინი
      ha:ჰაუსა
      hai:ჰაიდა
      haw:ჰავაიური
      hax:სამხრეთული ჰაიდა
      he:ებრაული
      hi:ჰინდი
      hi-Latn-alt-variant:ჰინგლისური
      hil:ჰილიგაინონი
      hit:ხეთური
      hmn:ჰმონგი
      hr:ხორვატული
      hsb:ზემოსორბული
      ht:ჰაიტიური კრეოლი
      hu:უნგრული
      hup:ჰუპა
      hur:ჰალკომელემი
      hy:სომხური
      hz:ჰერერო
      ia:ინტერლინგუალური
      iba:იბანი
      ibb:იბიბიო
      id:ინდონეზიური
      ie:ინტერლინგი
      ig:იგბო
      ii:სიჩუანის ი
      ikt:დასავლეთ-კანადური ინუკტიტუტი
      ilo:ილოკო
      inh:ინგუშური
      io:იდო
      is:ისლანდიური
      it:იტალიური
      iu:ინუკტიტუტი
      ja:იაპონური
      jbo:ლოჟბანი
      jgo:ნგომბა
      jmc:კიმაშამი
      jpr:იუდეო-სპარსული
      jrb:იუდეო-არაბული
      jv:იავური
      ka:ქართული
      kaa:ყარაყალფახური
      kab:კაბილური
      kac:კაჩინი
      kaj:კაჯი
      kam:კამბა
      kbd:ყაბარდოული
      kcg:ტიაპი
      kde:მაკონდე
      kea:კაბუვერდიანუ
      kfo:კორო
      kg:კონგო
      kgp:კაინგანგი
      kha:ხასი
      khq:კოირა-ჩიინი
      ki:კიკუიუ
      kj:კუნამა
      kk:ყაზახური
      kkj:კაკო
      kl:დასავლეთ გრენლანდიური
      kln:კალენჯინი
      km:ქმერული
      kmb:კიმბუნდუ
      kn:კანადა
      ko:კორეული
      koi:კომი-პერმიაკული
      kok:კონკანი
      kos:კუსაიე
      kpe:კპელე
      kr:კანური
      krc:ყარაჩაულ-ბალყარული
      krl:კარელიური
      kru:კურუქი
      ks:ქაშმირული
      ksb:შამბალა
      ksf:ბაფია
      ksh:კიოლში
      ku:ქურთული
      kum:ყუმუხური
      kut:კუტენაი
      kv:კომი
      kw:კორნული
      kwk:კვაკვალა
      kxv:კუვი
      ky:ყირგიზული
      la:ლათინური
      lad:ლადინო
      lag:ლანგი
      lah:ლანდა
      lam:ლამბა
      lb:ლუქსემბურგული
      lez:ლეზგიური
      lg:განდა
      li:ლიმბურგული
      lij:ლიგურიული
      lil:ლილიეტი
      lkt:ლაკოტა
      lmo:ლომბარდიული
      ln:ლინგალა
      lo:ლაოსური
      lol:მონგო
      lou:ლუიზიანას კრეოლური
      loz:ლოზი
      lrc:ჩრდილოეთ ლური
      lsm:სამია
      lt:ლიეტუვური
      lu:ლუბა-კატანგა
      lua:ლუბა-ლულუა
      lui:ლუისენიო
      lun:ლუნდა
      luo:ლუო
      lus:მიზო
      luy:ლუჰია
      lv:ლატვიური
      mad:მადურული
      maf:მაფა
      mag:მაგაჰი
      mai:მაითილი
      mak:მაკასარი
      mas:მასაი
      mde:მაბა
      mdf:მოქშა
      men:მენდე
      mer:მერუ
      mfe:მორისიენი
      mg:მალაგასიური
      mga:საშუალო ირლანდიური
      mgh:მაქუვა-მეეტო
      mgo:მეტა-ენა
      mh:მარშალური
      mi:მაორი
      mic:მიკმაკი
      min:მინანგკაბაუ
      mk:მაკედონური
      ml:მალაიალამური
      mn:მონღოლური
      mnc:მანჯურიული
      mni:მანიპური
      moe:ინუ-აიმუნი
      moh:მოჰაუკური
      mos:მოსი
      mr:მარათჰი
      ms:მალაიური
      mt:მალტური
      mua:მუნდანგი
      mul:სხვადასხვა ენა
      mus:კრიკი
      mwl:მირანდული
      mwr:მარვარი
      my:ბირმული
      mye:მიენე
      myv:ერზია
      mzn:მაზანდერანული
      na:ნაურუ
      nap:ნეაპოლიტანური
      naq:ნამა
      nb:ნორვეგიული ბუკმოლი
      nd:ჩრდილოეთ ნდებელე
      nds:ქვემოგერმანული
      nds-NL:ქვემოსაქსონური
      ne:ნეპალური
      new:ნევარი
      ng:ნდონგა
      nia:ნიასი
      niu:ნიუე
      nl:ნიდერლანდური
      nl-BE:ფლამანდიური
      nmg:კვასიო
      nn:ნორვეგიული ნიუნორსკი
      nnh:ნგიმბუნი
      no:ნორვეგიული
      nog:ნოღაური
      non:ძველსკანდინავიური
      nqo:ნკო
      nr:სამხრეთ ნდებელური
      nso:ჩრდილოეთ სოთო
      nus:ნუერი
      nv:ნავახო
      nwc:კლასიკური ნევარული
      ny:ნიანჯა
      nym:ნიამვეზი
      nyn:ნიანკოლე
      nyo:ნიორო
      nzi:ნზიმა
      oc:ოქსიტანური
      oj:ოჯიბვე
      ojb:ჩრდილო-დასავლეთის ოჯიბვა
      ojc:ცენტრალური ოჯიბვე
      ojs:ოჯი-კრი
      ojw:დასავლეთის ოჯიბვა
      oka:ოკანაგანი
      om:ორომო
      or:ორია
      os:ოსური
      pa:პენჯაბური
      pag:პანგასინანი
      pal:ფალაური
      pam:პამპანგა
      pap:პაპიამენტო
      pau:ფალაუანი
      pcm:ნიგერიული კრეოლური
      peo:ძველი სპარსული
      phn:ფინიკიური
      pi:პალი
      pis:პიჯინი
      pl:პოლონური
      pqm:მალისეტ-პასამაკვოდი
      prg:პრუსიული
      pro:ძველი პროვანსული
      ps:პუშტუ
      pt:პორტუგალიური
      pt-BR:ბრაზილიური პორტუგალიური
      pt-PT:ევროპული პორტუგალიური
      qu:კეჩუა
      quc:კიჩე
      raj:რაჯასთანი
      rap:რაპანუი
      rar:რაროტონგული
      rhg:როჰინგა
      rm:რეტორომანული
      rn:რუნდი
      ro:რუმინული
      ro-MD:მოლდავური
      rof:რომბო
      rom:ბოშური
      ru:რუსული
      rup:არომანული
      rw:კინიარუანდა
      rwk:რუა
      sa:სანსკრიტი
      sad:სანდავე
      sah:იაკუტური
      sam:სამარიულ-არამეული
      saq:სამბურუ
      sat:სანტალი
      sba:ნგამბაი
      sbp:სანგუ
      sc:სარდინიული
      scn:სიცილიური
      sco:შოტლანდიური
      sd:სინდჰური
      sdh:სამხრეთქურთული
      se:ჩრდილოეთ საამური
      see:სენეკა
      seh:სენა
      sel:სელკუპური
      ses:კოირაბორო-სენი
      sg:სანგო
      sga:ძველი ირლანდიური
      sh:სერბულ-ხორვატული
      shi:შილჰა
      shn:შანი
      shu:ჩადური არაბული
      si:სინჰალური
      sk:სლოვაკური
      sl:სლოვენური
      slh:სამხრეთული ლუშუციდი
      sm:სამოა
      sma:სამხრეთსამური
      smj:ლულე-საამური
      smn:ინარი-საამური
      sms:სკოლტ-საამური
      sn:შონა
      snk:სონინკე
      so:სომალიური
      sq:ალბანური
      sr:სერბული
      srn:სრანან ტონგო
      ss:სუატი
      ssy:საჰო
      st:სამხრეთ სოთოს ენა
      str:სტრეიტს სალიში
      su:სუნდური
      suk:სუკუმა
      sux:შუმერული
      sv:შვედური
      sw:სუაჰილი
      sw-CD:კონგოს სუაჰილი
      swb:კომორული
      syc:კლასიკური სირიული
      syr:სირიული
      szl:სილესიური
      ta:ტამილური
      tce:სამხრეთ ტუჩონი
      te:ტელუგუ
      tem:ტინმე
      teo:ტესო
      tet:ტეტუმი
      tg:ტაჯიკური
      tgx:ტაგიში
      th:ტაილანდური
      tht:ტალტანი
      ti:ტიგრინია
      tig:თიგრე
      tk:თურქმენული
      tlh:კლინგონი
      tli:ტლინგიტი
      tn:ტსვანა
      to:ტონგანური
      tok:ტოკი-პონა
      tpi:ტოკ-პისინი
      tr:თურქული
      trv:ტაროკო
      ts:ტსონგა
      tt:თათრული
      ttm:ჩრდილოეთ ტუჩონი
      tum:ტუმბუკა
      tvl:ტუვალუ
      tw:თუი
      twq:ტასავაქი
      ty:ტაიტური
      tyv:ტუვა
      tzm:ცენტრალური მოროკოს ტამაზიგხტი
      udm:უდმურტული
      ug:უიღურული
      uga:უგარითული
      uk:უკრაინული
      umb:უმბუნდუ
      und:უცნობი ენა
      ur:ურდუ
      uz:უზბეკური
      vai:ვაი
      ve:ვენდა
      vec:ვენეციური
      vi:ვიეტნამური
      vmw:მაკჰუვა
      vo:ვოლაპუკი
      vun:ვუნჯო
      wa:ვალონური
      wae:ვალსერი
      wal:ველაითა
      war:ვარაი
      wbp:ვალპირი
      wo:ვოლოფური
      wuu:ვუ
      xal:ყალმუხური
      xh:ქჰოსა
      xnr:კანგრი
      xog:სოგა
      yav:იანგბენი
      ybb:იემბა
      yi:იდიში
      yo:იორუბა
      yrl:ნენგატუ
      yue:კანტონური
      yue-alt-menu:ჩინური, კანტონური
      za:ზჰუანგი
      zbl:ბლისსიმბოლოები
      zen:ზენაგა
      zgh:სტანდარტული მაროკოული ტამაზიგხტი
      zh:ჩინური
      zh-alt-menu:ჩინური, მანდარინი
      zh-Hans:გამარტივებული ჩინური
      zh-Hans-alt-long:გამარტივებული ჩინური მანდარინი
      zh-Hant:ტრადიციული ჩინური
      zh-Hant-alt-long:ტრადიციული ჩინური მანდარინი
      zu:ზულუ
      zun:ზუნი
      zxx:ლინგვისტური შიგთავსი არ არის
      zza:ზაზაკი
      """.trimIndent() }

  val kaa: String by lazy { """
      de:немецше
      de-AT:немецше (Австрия)
      de-CH:немецше (Швейцария)
      fr:французша
      fr-CA:французша (Канада)
      fr-CH:французша (Швейцария)
      hi-Latn:ҳиндше (латын)
      hi-Latn-alt-variant:ҳинглиш (латын)
      it:итальянша
      ja:японша
      kaa:қарақалпақша
      ko:корейсше
      zh:қытайша
      zh-alt-menu:қытайша
      """.trimIndent() }

  val kaa_Cyrl: String? = null

  val kab: String by lazy { """
      ak:Takanit
      am:Tamahrict
      ar:Taɛrabt
      be:Tabilarusit
      bg:Tabulgarit
      bn:Tabengalit
      cs:Tačikit
      de:Talmant
      el:Tagrikit
      en:Taglizit
      es:Taspenyulit
      fa:Tafarisit
      fr:Tafransist
      ha:Tahwasit
      hi:Tahendit
      hu:Tahungarit
      id:Tandunisit
      ig:Tigbut
      it:Taṭalyanit
      ja:Tajapunit
      jv:Tajavanit
      kab:Taqbaylit
      km:Takemrit
      ko:Takurit
      ms:Tamalawit
      my:Taburmisit
      ne:Tanipalit
      nl:Tadučit
      pa:Tapunjabit
      pl:Tapulunit
      pt:Tapurtugalit
      ro:Tarumanit
      ru:Tarusit
      rw:Taruwandit
      so:Taṣumalit
      sv:Taswidit
      ta:Taṭamulit
      th:Taṭaylundit
      tr:Taṭurkit
      uk:Tukranit
      ur:Turdut
      vi:Tabyiṭnamit
      yo:Tayurubit
      zh:Tacinwat, Tamundarint
      zh-alt-menu:Tacinwat, Tamundarint
      zu:Tazulut
      """.trimIndent() }

  val kaj: String by lazy { """
      kaj:Kaje
      """.trimIndent() }

  val kam: String by lazy { """
      ak:Kiakan
      am:Kiamhari
      ar:Kiarabu
      be:Kibelarusi
      bg:Kibulgaria
      bn:Kibangla
      cs:Kichecki
      de:Kijerumani
      el:Kigiriki
      en:Kingereza
      es:Kihispania
      fa:Kiajemi
      fr:Kifaransa
      ha:Kihausa
      hi:Kihindi
      hu:Kihungari
      id:Kiindonesia
      ig:Kiigbo
      it:Kiitaliano
      ja:Kijapani
      jv:Kijava
      kam:Kikamba
      km:Kikambodia
      ko:Kikorea
      ms:Kimalesia
      my:Kiburma
      ne:Kinepali
      nl:Kiholanzi
      pa:Kipunjabi
      pl:Kipolandi
      pt:Kireno
      ro:Kiromania
      ru:Kirusi
      rw:Kinyarwanda
      so:Kisomali
      sv:Kiswidi
      ta:Kitamil
      th:Kitailandi
      tr:Kituruki
      uk:Kiukrania
      ur:Kiurdu
      vi:Kivietinamu
      yo:Kiyoruba
      zh:Kichina
      zh-alt-menu:Kichina
      zu:Kizulu
      """.trimIndent() }

  val kcg: String by lazy { """
      kcg:Katab
      """.trimIndent() }

  val kde: String by lazy { """
      ak:Chakan
      am:Chamhali
      ar:Chalabu
      be:Chibelalusi
      bg:Chibulgalia
      bn:Chibangla
      cs:Chichechi
      de:Chidyelumani
      el:Chigilichi
      en:Chiingeleza
      es:Chihispania
      fa:Chiajemi
      fr:Chifalansa
      ha:Chihausa
      hi:Chihindi
      hu:Chihungali
      id:Chiiongonesia
      ig:Chiigbo
      it:Chiitaliano
      ja:Chidyapani
      jv:Chidyava
      kde:Chimakonde
      km:Chikambodia
      ko:Chikolea
      ms:Chimalesia
      my:Chibulma
      ne:Chinepali
      nl:Chiholanzi
      pa:Chipunjabi
      pl:Chipolandi
      pt:Chileno
      ro:Chilomania
      ru:Chilusi
      rw:Chinyalwanda
      so:Chisomali
      sv:Chiswidi
      ta:Chitamil
      th:Chitailandi
      tr:Chituluchi
      uk:Chiuklania
      ur:Chiuldu
      vi:Chivietinamu
      yo:Chiyoluba
      zh:Chichina
      zh-alt-menu:Chichina
      zu:Chizulu
      """.trimIndent() }

  val kea: String by lazy { """
      ab:abkáziu
      af:afrikaner
      agq:aghem
      ak:akan
      am:amáriku
      ar:árabi
      ar-001:árabi mudernu
      arn:araukanu
      as:asames
      asa:asu
      ast:asturianu
      ay:aimara
      az:azerbaijanu
      az-alt-short:azeri
      ba:baxkir
      ban:balines
      bas:basa
      be:bielorusu
      bem:bemba
      bez:bena
      bg:búlgaru
      bm:bambara
      bn:bengali
      bo:tibetanu
      br:bretãu
      brx:bodo
      bs:bosniu
      ca:katalãu
      ccp:xakma
      ce:txetxenu
      ceb:sebuanu
      cgg:xiga
      chr:xeroki
      ckb:kurdu sentral
      ckb-alt-menu:kurdu sentral
      ckb-alt-variant:kurdu sentral
      co:kórsiku
      cs:txeku
      cu:slavu klériku
      cv:txuvaxi
      cy:gales
      da:dinamarkes
      dav:taita
      de:alemon
      de-AT:alemon austríaku
      de-CH:alemon altu suisu
      dje:zarma
      dsb:sórbiu baxu
      dua:duala
      dyo:jola-fonyi
      dz:dzonka
      ebu:embu
      ee:eve
      el:gregu
      en:ingles
      en-AU:ingles australianu
      en-CA:ingles kanadianu
      en-GB:ingles britániku
      en-GB-alt-short:ingles (R.U.)
      en-US:ingles merkanu
      en-US-alt-short:ingles (S.U.)
      eo:sperantu
      es:spanhol
      es-419:spanhol latinu-merkanu
      es-ES:spanhol europeu
      es-MX:spanhol mexikanu
      et:stonianu
      eu:basku
      ewo:ewondo
      fa:persa
      ff:fula
      fi:finlandes
      fil:filipinu
      fj:fijianu
      fo:faroes
      fr:franses
      fr-CA:franses kanadianu
      fr-CH:franses suisu
      fur:friulanu
      fy:fríziu osidental
      ga:irlandes
      gag:gagauz
      gl:galegu
      gn:guarani
      gsw:alemon suisu
      gu:gujarati
      guz:gusii
      gv:manks
      ha:auza
      haw:avaianu
      he:ebraiku
      hi:indi
      hmn:hmong
      hr:kroata
      hsb:sórbiu altu
      ht:aitianu
      hu:úngaru
      hy:arméniu
      ia:interlingua
      id:indonéziu
      ig:ibo
      ii:nuosu
      is:islandes
      it:italianu
      iu:inuktitut
      ja:japones
      jgo:ñomba
      jmc:matxame
      jv:javanes
      ka:jorjianu
      kab:kabila
      kam:kamba
      kde:makonde
      kea:kabuverdianu
      khq:koira txiini
      ki:kikuiu
      kk:kazak
      kkj:kako
      kl:groenlandes
      kln:kalenjin
      km:kmer
      kn:kanares
      ko:korianu
      koi:komi-permiak
      kok:konkani
      ks:kaxmira
      ksf:bafia
      ksh:kolonhanu
      ku:kurdu
      kw:kórniku
      ky:kirgiz
      la:latin
      lag:langi
      lb:luxemburges
      lg:luganda
      lkt:lakota
      ln:lingala
      lo:lausianu
      lt:lituanu
      lu:luba-katanga
      luo:luo
      luy:luyia
      lv:letãu
      mg:malgaxi
      mgh:makua
      mi:maori
      mk:masedóniu
      ml:malaialam
      mr:marati
      ms:maláiu
      mt:maltes
      my:birmanes
      nb:norueges bokmål
      nds:alemon baxu
      ne:nepales
      nl:olandes
      nl-BE:flamengu
      nmg:kuazio
      nn:norueges nynorsk
      om:oromo
      or:odía
      os:osétiku
      pa:pandjabi
      pl:pulaku
      prg:prusianu
      ps:paxto
      pt:purtuges
      pt-BR:purtuges brazileru
      pt-PT:purtuges europeu
      qu:kexua
      quc:kitxe
      rm:romanxi
      rn:rundi
      ro:rumenu
      ro-MD:rumenu moldáviku
      rof:rombu
      ru:rusu
      rw:kiniaruanda
      rwk:rwa
      sa:sánskritu
      sd:sindi
      ses:koiraboro seni
      si:singales
      sk:slovaku
      sl:slovéniu
      smn:inari sami
      so:somali
      sq:albanes
      sr:sérviu
      su:sundanes
      sv:sueku
      sw:suaíli
      sw-CD:suaíli kongoles
      ta:tamil
      te:telugu
      tg:tadjiki
      th:tailandes
      ti:tigrinia
      tk:turkmenu
      to:tonganes
      tr:turku
      tt:tatar
      tzm:tamaziti di Atlas Sentral
      ug:uigur
      uk:ukranianu
      und:língua diskonxedu
      ur:urdu
      uz:uzbeki
      vi:vietnamita
      wo:uolof
      xh:koza
      yo:ioruba
      yue:kantunes
      yue-alt-menu:kantunes (tradisional)
      zgh:tamazait marokinu padron
      zh:xines
      zh-alt-menu:xines, mandarin
      zh-Hans:xines simplifikadu
      zh-Hans-alt-long:xines mandarin (simplificadu)
      zh-Hant:xines tradisional
      zh-Hant-alt-long:xines mandarin (tradisional)
      zu:zulu
      zxx:sen kontiudu linguístiku
      """.trimIndent() }

  val ken: String by lazy { """
      ken:Kɛnyaŋ
      """.trimIndent() }

  val kgp: String by lazy { """
      aa:afar
      ab:amekaso
      ace:agsẽm
      ach:akori
      ada:anágme
      ady:anhige
      ae:avétiko
      af:afrikỹnẽ
      afh:afrihiri
      agq:aghẽm
      ain:ajinũ
      ak:akỹn
      akk:akajỹnũ
      ale:arevute
      alt:artaj sur
      am:amỹriko
      an:aragonẽ
      ang:ĩnhgrej arkajiku
      anp:ỹgika
      ar:arame
      ar-001:arame ta’ũn
      arc:aramajiko
      arn:mỹpunugũn
      arp:arapaho
      ars:arame nẽgene
      arw:aruvaki
      as:ajamẽ
      asa:asu
      ast:anhturijỹnũ
      av:avariko
      awa:avanhi
      ay:ajimỹra
      az:ajermajỹnũ
      az-alt-short:ajermajỹnũ
      az-Arab:aseri sur
      ba:majkir
      bal:marusi
      ban:marinẽj
      bas:masa
      bax:mamũm
      bbj:gumỹra
      be:huso-kupri
      bej:meja
      bem:mema
      bez:menỹ
      bfd:mafun
      bg:mugaru
      bgn:marusi-rãpurja
      bho:mojpuri
      bi:miramá
      bik:mikor
      bin:minĩ
      bkm:kãm
      bla:sigsika
      bm:mámara
      bn:megari
      bo:timetỹnũ
      br:mretỹ
      bra:mraj
      brx:mono
      bs:mojnia
      bss:akuse
      bua:murijato
      bug:muginẽj
      bum:muru
      byn:mrĩn
      byv:menuma
      ca:katarũg
      cad:kano
      car:karime
      cay:kajuga
      cch:ansỹm
      ccp:sakimỹ
      ce:sesẽnũ
      ceb:semujỹnũ
      cgg:siga
      ch:samãhu
      chb:simsa
      chg:sagataj
      chk:sukese
      chm:mỹri
      chn:jargỹ sinũki
      cho:sogtavo
      chp:sipevyjỹ
      chr:seroki
      chy:sejẽnẽ
      ckb:kurno kuju
      ckb-alt-menu:kurno kuju
      ckb-alt-variant:kurno kuju
      co:korso
      cop:komta
      cr:kri
      crh:krimẽja tá turko
      crs:sejséri krijoro-frỹsej
      cs:séko
      csb:kasumijỹ
      cu:eravu ekresijatiko
      cv:suvase
      cy:garej
      da:nhinỹmỹrkej
      dak:nakota
      dar:narguva
      dav:tajta
      de:arimỹv
      de-CH:suvisa arimỹv-téj
      del:neravare
      den:sirave
      dgr:nogrim
      din:ninka
      dje:jarma
      doi:nogri
      dsb:soramiv rur
      dua:nuvara
      dum:orỹnej kuju
      dv:nivehi
      dyo:jora-fonyj
      dyu:nhivura
      dz:jãnga
      dzg:najaga
      ebu:ẽmu
      ee:eve
      efi:efike
      egy:ejimso arkajku
      eka:ekajuki
      el:gregu
      elx:eramĩte
      en:ĩnhgrej
      enm:ĩnhgrej kuju
      eo:enhperỹtu
      es:enhpỹjór
      et:enhtonĩjỹnũ
      eu:manhku
      ewo:evãnu
      fa:pérsa
      fan:fỹnge
      fat:fỹti
      ff:fura
      fi:fĩranẽj
      fil:firipĩnũ
      fj:fijỹnũ
      fo:fervej
      fon:fãm
      fr:frỹsej
      frc:frỹsej kajũn
      frm:frỹsej kuju
      fro:frỹsej arkajku
      frr:friso tỹ nãrti
      frs:frisỹ rãjur
      fur:frijurỹnũ
      fy:friso rãpur
      ga:irỹnej
      gaa:ga
      gag:gagavuj
      gan:gỹn
      gay:gajo
      gba:gemaja
      gd:gajériko enhkosej
      gez:gij
      gil:gimertej
      gl:garego
      gmh:arimỹv-téj kuju
      gn:góranĩ
      goh:arimỹv-téj arkajku
      gon:gãnni
      gor:gorãntar
      got:gótiko
      grb:gremo
      grc:gregu arkajku
      gsw:arimỹv (Suvisa)
      gu:gujerati
      guz:gusij
      gv:mỹnsi
      gwi:guvisĩn
      ha:havusa
      hai:hajna
      hak:haka
      haw:havajỹnũ
      he:emrajko
      hi:hĩni
      hil:hirigajnãn
      hit:hitita
      hmn:hymãg
      ho:hiri motu
      hr:krovata
      hsb:soramiv téj
      hsn:sijỹg
      ht:hajtijỹnũ
      hu:ũgaru
      hup:hupa
      hy:armẽnĩju
      hz:herero
      ia:vĩ-jãgja
      iba:iman
      ibb:imimijo
      id:ĩnonẽsijo
      ie:vĩ-ag kuju ki
      ig:igmo
      ii:sisuvỹ ji
      ik:ĩnũpijake
      ilo:irukỹnũ
      inh:ĩnguse
      io:ino
      is:kukryr
      it:itarijỹnũ
      iu:inugtituti
      ja:japonẽj
      jbo:rojmán
      jgo:gẽma
      jmc:mỹsame
      jpr:junajko-pérsa
      jrb:junajko-aramiko
      jv:javanẽj
      ka:jiórjijỹnũ
      kaa:kara-karkag
      kab:kamyre
      kac:kasĩn
      kaj:ju
      kam:kỹma
      kaw:kavi
      kbd:kamarnhijỹnũ
      kbl:kanẽnmu
      kcg:tyjam
      kde:mỹkãne
      kea:pu-tánh-vĩ
      kfo:koro
      kg:kãgorej
      kgp:kanhgág
      kha:kasi
      kho:kotanẽj
      khq:kujra sĩnĩ
      ki:kikuju
      kj:kuvanhỹmỹ
      kk:kajake
      kkj:kako
      kl:grohẽrỹnej
      kln:karẽnjĩn
      km:kymẽr
      kmb:kĩmuno
      kn:kanỹrim
      ko:korejỹnũ
      koi:komĩ-permyjag
      kok:kãkani
      kos:kosirajỹn
      kpe:kepere
      kr:kanũri
      krc:karasaj-markar
      krl:karérijo
      kru:kurug
      ks:kasemĩra
      ksb:sỹmara
      ksf:mafija
      ksh:kárysi
      ku:kurno
      kum:kumyg
      kut:kutenaj
      kv:komĩ
      kw:kórnĩko
      ky:kirginh
      la:ratĩnh
      lad:raninũ
      lag:rỹngi
      lah:rahina
      lam:rỹma
      lb:rusẽmurgej
      lez:resgi
      lg:rugỹna
      li:rĩmurgej
      lkt:rakóta
      ln:rĩgara
      lo:raosijỹnũ
      lol:mãgo
      lou:rovusijỹnỹ tá ke pẽ
      loz:roji
      lrc:ruri nãrti
      lt:rituvỹnũ
      lu:ruma-katỹga
      lua:ruma-ruruva
      lui:rujsẽnũ
      lun:rũna
      luo:ruvo
      lus:rusaj
      luy:ruja
      lv:retỹv
      mad:mỹnurej
      maf:mafa
      mag:mỹgahi
      mai:mỹjtiri
      mak:mỹkasar
      man:mỹnhĩga
      mas:mỹsaj
      mde:mama
      mdf:mogsa
      mdr:mỹnar
      men:mẽne
      mer:mẽru
      mfe:mãrisijẽn
      mg:mỹrgase
      mga:irỹnej kuju
      mgh:mỹkuva
      mgo:mẽta
      mh:mỹrsarej
      mi:mỹvóri
      mic:mĩkemỹke
      min:mĩnỹgkamavu
      mk:mỹsenojũ
      ml:mỹrajara
      mn:mãgór
      mnc:mỹsu
      mni:mỹnĩpuri
      moh:mãjkỹnũ
      mos:mosi
      mr:marati
      ms:mỹrajo
      mt:mỹrtej
      mua:mũnág
      mul:vẽnhvĩ’e
      mus:krig
      mwl:mĩrỹnej
      mwr:mỹrvari
      my:mirmỹnẽj
      mye:myene
      myv:érsija
      mzn:mỹsánarỹni
      na:nỹvuruvánũ
      nan:mĩn nỹn
      nap:nỹporitỹnũ
      naq:nỹmỹ
      nb:mógmỹr nãrovegej
      nd:nemere nãrti
      nds:arimỹv rur
      nds-NL:sagsỹv rur
      ne:nẽparej
      new:nẽvari
      ng:nogã
      nia:nĩja
      niu:nivuvejỹnũ
      nl:orỹnej
      nl-BE:framẽgo
      nmg:kivasijo
      nn:nĩnãrsig nãrovegej
      nnh:gijẽmun
      no:nãrovegej
      nog:nãgaj
      non:nãrniko arkajku
      nqo:nyko
      nr:nemere sur
      nso:soto nãrti
      nus:nũver
      nv:nỹvaho
      nwc:nẽvari há tỹvĩ
      ny:nĩjỹnja
      nym:nyjỹm-vesi
      nyn:nyjỹmkore
      nyo:nyjor
      nzi:nĩsimỹ
      oc:ogsitỹnũ
      oj:ojimva
      om:orãmũ
      or:orija
      os:oseto
      osa:osage
      ota:turko otomỹnũ
      pa:pỹjami
      pag:pangasinỹ
      pal:paravi
      pam:pampỹga
      pap:papijamẽto
      pau:paravỹnũ
      pcm:pingĩn nĩjerijỹnũ
      peo:pérsa arkajku
      phn:fenĩso
      pi:pari
      pl:poronẽj
      pon:pãnhpejỹnũ
      prg:prusijỹnũ
      pro:provẽsar arkajku
      ps:pasito
      ps-alt-variant:pusito
      pt:fóg-vĩ
      qu:kinsuva
      quc:kisé
      raj:hajanhtỹnĩ
      rap:hapanũj
      rar:harotãganũ
      rm:homỹse
      rn:hũni
      ro:homẽnũ
      ro-MD:mãrnavijo
      rof:hãmo
      rom:homỹnĩ
      ru:huso
      rup:aromẽnũ
      rw:kinĩjarvỹna
      rwk:hywa
      sa:sỹnhkrito
      sad:sỹnave
      sah:saka
      sam:aramỹjko samaritỹnũ
      saq:sỹmuru
      sas:sasag
      sat:sỹtari
      sba:gỹmaji
      sbp:sỹgu
      sc:sarno
      scn:sisirijỹnũ
      sco:isikoti
      sd:sĩni
      sdh:kurno sur
      se:samĩ nãrti
      see:senẽka
      seh:senỹ
      sel:serkum
      ses:kojyramoro senĩ
      sg:sỹgo
      sga:irỹnej arkajku
      sh:servo-krovata
      shi:tasehiti
      shn:sỹn
      shu:arame sanijỹnũ
      si:sĩgarej
      sid:sinamũ
      sk:erovako
      sl:erovenũ
      sm:samovỹnũ
      sma:samĩ sur
      smj:samĩ Rure tá
      smn:samĩ Inari tá
      sms:samĩ Isikórti tá
      sn:sãnỹ
      snk:sãnĩke
      so:somỹri
      sog:sognijỹnũ
      sq:armánẽj
      sr:sérvijo
      srn:surinỹmẽj
      srr:serere
      ss:suvaji
      ssy:saho
      st:soto sur
      su:sunanẽj
      suk:sukumỹ
      sus:susu
      sux:sumẽrijo
      sv:suvéko
      sw:suvahiri
      sw-CD:suvahiri Kãgo tá
      swb:komorijỹnũ
      syc:sirijako há tỹvĩ
      syr:sirijako
      ta:támĩr
      te:térugo
      tem:timnẽ
      teo:teso
      ter:terẽnũ
      tet:tétũm
      tg:tanhike
      th:tajrỹnej
      ti:tigrinĩja
      tig:tigré
      tiv:tivi
      tk:turkomẽnũ
      tkl:tokeravánũ
      tl:tagaro
      tlh:krĩngãg
      tli:tiringite
      tmh:tamỹséke
      tn:tisuvanỹ
      to:tãnganẽj
      tog:tãnganẽj Nyjasa tá
      tpi:tóg-pisĩn
      tr:turko
      trv:taroko
      ts:tesãga
      tsi:simsijỹnũ
      tt:tartaru
      tum:tũmuka
      tvl:tuvaruvỹnũ
      tw:tuvi
      twq:tasavag
      ty:tajtijỹnũ
      tyv:tuvinijỹnũ
      tzm:tamỹjirte Atara Kuju tá
      udm:unmũrte
      ug:ujgur
      uga:ugaritiko
      uk:ukranĩjỹnũ
      umb:ũmunu
      und:vẽnhvĩ ki kagtĩg
      ur:urnu
      uz:unhmeke
      vai:vaj
      ve:vẽna
      vi:vijétinỹmũ
      vo:vorapuke
      vot:vótiko
      vun:vũjo
      wa:varỹv
      wae:varser
      wal:vorajta
      war:varaj
      was:vaso
      wbp:varpiri
      wo:vorofe
      wuu:vu
      xal:karmĩg
      xh:sosa
      xog:rusoga
      yao:javo
      yap:japese
      yav:jỹgmen
      ybb:jẽma
      yi:jinhise
      yo:joruma
      yrl:nhẽgatu
      yue:kỹtonẽj
      yue-alt-menu:kỹtonẽj (pẽ)
      za:juvỹg
      zap:japoteko
      zbl:sĩmoru mrij
      zen:senỹga
      zgh:tamỹjirte mỹhókinũ pã
      zh:sĩnẽj
      zh-alt-menu:sĩnẽj mỹnarĩj
      zh-Hans:sĩnẽj mẽ
      zh-Hans-alt-long:sĩnẽj mỹnarĩj (mẽ)
      zh-Hant:sĩnẽj pẽ
      zh-Hant-alt-long:sĩnẽj mỹnarĩj (pẽ)
      zu:suru
      zun:sunhi
      zxx:nén ũ vẽnhvĩ ki tũ
      zza:sasaki
      """.trimIndent() }

  val khq: String by lazy { """
      ak:Akan senni
      am:Amhaarik senni
      ar:Laaraw senni
      be:Belaruus senni
      bg:Bulagaari senni
      bn:Bengali senni
      cs:Cek senni
      de:Almaŋ senni
      el:Grek senni
      en:Inglisi senni
      es:Espaaɲe senni
      fa:Farsi senni
      fr:Fransee senni
      ha:Hawsance senni
      hi:Induu senni
      hu:Hungaari senni
      id:Indoneesi senni
      ig:Iboo senni
      it:Itaali senni
      ja:Japonee senni
      jv:Javanee senni
      khq:Koyra ciini
      km:Kmeer senni, Game here
      ko:Koree senni
      ms:Maleezi senni
      my:Burme senni
      ne:Neepal senni
      nl:Holandee senni
      pa:Punjaabi sennii
      pl:Polonee senni
      pt:Portugee senni
      ro:Rumaani senni
      ru:Ruusi senni
      rw:Rwanda senni
      so:Somaali senni
      sv:Suweede senni
      ta:Tamil senni
      th:Taailandu senni
      tr:Turku senni
      uk:Ukreen senni
      ur:Urdu senni
      vi:Vietnaam senni
      yo:Yorbance senni
      zh:Sinuwa senni, Mandareŋ
      zh-alt-menu:Sinuwa senni, Mandareŋ
      zu:Julu senni
      """.trimIndent() }

  val ki: String by lazy { """
      ak:Kiakan
      am:Kiamhari
      ar:Kĩarabu
      be:Kibelarusi
      bg:Kibulgaria
      bn:Kibangla
      cs:Kichecki
      de:Kĩnjeremani
      el:Kigiriki
      en:Gĩthungũ
      es:Kihispania
      fa:Kiajemi
      fr:Kĩbaranja
      ha:Kihausa
      hi:Kĩhĩndĩ
      hu:Kihungari
      id:Kiindonesia
      ig:Kiigbo
      it:Kĩtaliano
      ja:Kĩnjabani
      jv:Kijava
      ki:Gikuyu
      km:Kikambodia
      ko:Kikorea
      ms:Kimalesia
      my:Kiburma
      ne:Kinepali
      nl:Kiholanzi
      pa:Kipunjabi
      pl:Kipolandi
      pt:Kireno
      ro:Kiromania
      ru:Kĩracia
      rw:Kinyarwanda
      so:Kĩcumarĩ
      sv:Kiswidi
      ta:Kitamil
      th:Kitailandi
      tr:Kituruki
      uk:Kiukrania
      ur:Kiurdu
      vi:Kivietinamu
      yo:Kiyoruba
      zh:Kĩcaina
      zh-alt-menu:Kĩcaina
      zu:Kizulu
      """.trimIndent() }

  val kk: String by lazy { """
      aa:афар тілі
      ab:абхаз тілі
      ace:ачех тілі
      ada:адангме тілі
      ady:адыгей тілі
      af:африкаанс тілі
      agq:агем тілі
      ain:айну тілі
      ak:акан тілі
      ale:алеут тілі
      alt:оңтүстік алтай тілі
      am:амхар тілі
      an:арагон тілі
      ann:оболо тілі
      anp:ангика тілі
      ar:араб тілі
      ar-001:қазіргі стандартты араб тілі
      arn:мапуче тілі
      arp:арапахо тілі
      ars:араб тілі (Неджда)
      as:ассам тілі
      asa:асу тілі
      ast:астурия тілі
      atj:атикамек тілі
      av:авар тілі
      awa:авадхи тілі
      ay:аймара тілі
      az:әзірбайжан тілі
      az-alt-short:әзірбайжан тілі
      ba:башқұрт тілі
      ban:бали тілі
      bas:баса тілі
      be:беларусь тілі
      bem:бемба тілі
      bez:бена тілі
      bg:болгар тілі
      bgc:хариани тілі
      bgn:батыс балучи тілі
      bho:бходжпури тілі
      bi:бислама тілі
      bin:бини тілі
      bla:сиксика тілі
      blo:ании тілі
      bm:бамбара тілі
      bn:бенгал тілі
      bo:тибет тілі
      br:бретон тілі
      brx:бодо тілі
      bs:босния тілі
      bug:бугис тілі
      byn:блин тілі
      ca:каталан тілі
      cay:кайюга тілі
      ccp:чакма тілі
      ce:шешен тілі
      ceb:себуано тілі
      cgg:кига тілі
      ch:чаморро тілі
      chk:чуук тілі
      chm:мари тілі
      cho:чокто тілі
      chp:чипевайан тілі
      chr:чероки тілі
      chy:шайен тілі
      ckb:сорани тілі
      ckb-alt-menu:сорани тілі
      ckb-alt-variant:сорани тілі
      clc:чилкотин тілі
      co:корсика тілі
      crg:мичиф тілі
      crj:оңтүстік-шығыс кри тілі
      crk:жазықтағы кри тілі
      crl:солтүстік-шығыс кри тілі
      crm:мус кри тілі
      crr:каролиналық алгонкин тілі
      crs:сейшельдік креол тілі
      cs:чех тілі
      csw:батпақты жердің кри тілі
      cu:шіркеулік славян тілі
      cv:чуваш тілі
      cy:валлий тілі
      da:дат тілі
      dak:дакота тілі
      dar:даргин тілі
      dav:таита тілі
      de:неміс тілі
      de-CH:швейцариялық әдеби неміс тілі
      dgr:догриб тілі
      dje:зарма тілі
      doi:догри тілі
      dsb:төменгі лужица тілі
      dua:дуала тілі
      dv:дивехи тілі
      dyo:диола тілі
      dz:дзонг-кэ тілі
      dzg:дазага тілі
      ebu:эмбу тілі
      ee:эве тілі
      efi:эфик тілі
      eka:экаджук тілі
      el:грек тілі
      en:ағылшын тілі
      eo:эсперанто тілі
      es:испан тілі
      et:эстон тілі
      eu:баск тілі
      ewo:эвондо тілі
      fa:парсы тілі
      fa-AF:дари тілі
      ff:фула тілі
      fi:фин тілі
      fil:филиппин тілі
      fj:фиджи тілі
      fo:фарер тілі
      fon:фон тілі
      fr:француз тілі
      frc:каджун тілі (француз)
      frr:солтүстік фриз тілі
      fur:фриуль тілі
      fy:батыс фриз тілі
      ga:ирланд тілі
      gaa:га тілі
      gag:гагауз тілі
      gd:шотландиялық гэль тілі
      gez:геэз тілі
      gil:гильберт тілі
      gl:галисия тілі
      gn:гуарани тілі
      gor:горонтало тілі
      gsw:неміс тілі (Швейцария)
      gu:гуджарати тілі
      guz:гусии тілі
      gv:мэн тілі
      gwi:гвичин тілі
      ha:хауса тілі
      hai:хайда тілі
      haw:гавайи тілі
      hax:оңтүстік хайда тілі
      he:иврит тілі
      hi:хинди тілі
      hi-Latn-alt-variant:хинглиш
      hil:хилигайнон тілі
      hmn:хмонг тілі
      hr:хорват тілі
      hsb:жоғарғы лужица тілі
      ht:гаити тілі
      hu:венгр тілі
      hup:хупа тілі
      hur:халкомелем тілі
      hy:армян тілі
      hz:гереро тілі
      ia:интерлингва тілі
      iba:ибан тілі
      ibb:ибибио тілі
      id:индонезия тілі
      ie:интерлингве тілі
      ig:игбо тілі
      ii:сычуан и тілі
      ikt:батыс канадалық инуктитут тілі
      ilo:илоко тілі
      inh:ингуш тілі
      io:идо тілі
      is:исланд тілі
      it:итальян тілі
      iu:инуктитут тілі
      ja:жапон тілі
      jbo:ложбан тілі
      jgo:нгомба тілі
      jmc:мачаме тілі
      jv:ява тілі
      ka:грузин тілі
      kab:кабил тілі
      kac:качин тілі
      kaj:каджи тілі
      kam:камба тілі
      kbd:кабардин тілі
      kcg:тьяп тілі
      kde:маконде тілі
      kea:кабувердьяну тілі
      kfo:коро тілі
      kgp:кайнганг тілі
      kha:кхаси тілі
      khq:койра чини тілі
      ki:кикуйю тілі
      kj:кваньяма тілі
      kk:қазақ тілі
      kkj:како тілі
      kl:калаалисут тілі
      kln:каленжин тілі
      km:кхмер тілі
      kmb:кимбунду тілі
      kn:каннада тілі
      ko:корей тілі
      koi:коми-пермяк тілі
      kok:конкани тілі
      kpe:кпелле тілі
      kr:канури тілі
      krc:қарашай-балқар тілі
      krl:карель тілі
      kru:курух тілі
      ks:кашмир тілі
      ksb:шамбала тілі
      ksf:бафиа тілі
      ksh:кёльн тілі
      ku:күрд тілі
      kum:құмық тілі
      kv:коми тілі
      kw:корн тілі
      kwk:квакиутль тілі
      kxv:куви тілі
      ky:қырғыз тілі
      la:латын тілі
      lad:ладино тілі
      lag:ланги тілі
      lb:люксембург тілі
      lez:лезгин тілі
      lg:ганда тілі
      li:лимбург тілі
      lij:лигур тілі
      lil:лиллуэт тілі
      lkt:лакота тілі
      lmo:ломбард тілі
      ln:лингала тілі
      lo:лаос тілі
      lou:креоль тілі (Луизиана)
      loz:лози тілі
      lrc:солтүстік люри тілі
      lsm:самия тілі
      lt:литва тілі
      lu:луба-катанга тілі
      lua:луба-лулуа тілі
      lun:лунда тілі
      luo:луо тілі
      lus:мизо тілі
      luy:лухиа тілі
      lv:латыш тілі
      mad:мадур тілі
      mag:магахи тілі
      mai:майтхили тілі
      mak:макасар тілі
      mas:масай тілі
      mdf:мокша тілі
      men:менде тілі
      mer:меру тілі
      mfe:морисиен тілі
      mg:малагаси тілі
      mgh:макуа-меетто тілі
      mgo:мета тілі
      mh:маршалл тілі
      mi:маори тілі
      mic:микмак тілі
      min:минангкабау тілі
      mk:македон тілі
      ml:малаялам тілі
      mn:моңғол тілі
      mni:манипури тілі
      moe:инну-аймун тілі
      moh:могавк тілі
      mos:мосси тілі
      mr:маратхи тілі
      ms:малай тілі
      mt:мальта тілі
      mua:мунданг тілі
      mul:бірнеше тіл
      mus:крик тілі
      mwl:миранд тілі
      my:бирма тілі
      myv:эрзя тілі
      mzn:мазандеран тілі
      na:науру тілі
      nap:неаполитан тілі
      naq:нама тілі
      nb:норвегиялық букмол тілі
      nd:солтүстік ндебеле тілі
      nds:төменгі неміс тілі
      nds-NL:төменгі саксон тілі
      ne:непал тілі
      new:невар тілі
      ng:ндонга тілі
      nia:ниас тілі
      niu:ниуэ тілі
      nl:нидерланд тілі
      nl-BE:фламанд тілі
      nmg:квасио тілі
      nn:норвегиялық нюнорск тілі
      nnh:нгиембун тілі
      no:норвег тілі
      nog:ноғай тілі
      nqo:нко тілі
      nr:оңтүстік ндебеле тілі
      nso:солтүстік сото тілі
      nus:нуэр тілі
      nv:навахо тілі
      ny:ньянджа тілі
      nyn:нианколе тілі
      oc:окситан тілі
      ojb:солтүстік-батыс оджибве тілі
      ojc:орталық оджибве тілі
      ojs:оджи-кри тілі
      ojw:батыс оджибве тілі
      oka:оканаган тілі
      om:оромо тілі
      or:ория тілі
      os:осетин тілі
      osa:осейдж тілі
      pa:пенджаб тілі
      pag:пангасинан тілі
      pam:пампанга тілі
      pap:папьяменто тілі
      pau:палау тілі
      pcm:нигериялық пиджин тілі
      pis:пиджин тілі
      pl:поляк тілі
      pqm:малесит-пассамакводди тілі
      prg:пруссия тілі
      ps:пушту тілі
      pt:португал тілі
      pt-BR:бразилиялық португал тілі
      pt-PT:еуропалық португал тілі
      qu:кечуа тілі
      quc:киче тілі
      raj:раджастани тілі
      rap:рапануй тілі
      rar:раротонган тілі
      rhg:рохинджа
      rm:романш тілі
      rn:рунди тілі
      ro:румын тілі
      ro-MD:молдован тілі
      rof:ромбо тілі
      ru:орыс тілі
      rup:арумын тілі
      rw:киньяруанда тілі
      rwk:руа тілі
      sa:санскрит тілі
      sad:сандаве тілі
      sah:саха тілі
      saq:самбуру тілі
      sat:сантали тілі
      sba:нгамбай тілі
      sbp:сангу тілі
      sc:сардин тілі
      scn:сицилия тілі
      sco:шотланд тілі
      sd:синдхи тілі
      sdh:оңтүстік күрд тілі
      se:солтүстік саам тілі
      seh:сена тілі
      ses:койраборо сенни тілі
      sg:санго тілі
      sh:серб-хорват тілі
      shi:ташелхит тілі
      shn:шан тілі
      si:сингал тілі
      sk:словак тілі
      sl:словен тілі
      slh:оңтүстік лушуцид тілі
      sm:самоа тілі
      sma:оңтүстік саам тілі
      smj:луле саам тілі
      smn:инари саам тілі
      sms:колтта саам тілі
      sn:шона тілі
      snk:сонинке тілі
      so:сомали тілі
      sq:албан тілі
      sr:серб тілі
      srn:сранан тонго тілі
      ss:свати тілі
      ssy:сахо тілі
      st:оңтүстік сото тілі
      str:солтүстік стрейтс тілі
      su:сундан тілі
      suk:сукума тілі
      sv:швед тілі
      sw:суахили тілі
      sw-CD:конго суахили тілі
      swb:комор тілі
      syr:сирия тілі
      szl:силез тілі
      ta:тамил тілі
      tce:оңтүстік тутчоне тілі
      te:телугу тілі
      tem:темне тілі
      teo:тесо тілі
      tet:тетум тілі
      tg:тәжік тілі
      tgx:тагиш тілі
      th:тай тілі
      tht:тальтан тілі
      ti:тигринья тілі
      tig:тигре тілі
      tk:түрікмен тілі
      tlh:клингон тілі
      tli:тлинкит тілі
      tn:тсвана тілі
      to:тонган тілі
      tok:токипона тілі
      tpi:ток-писин тілі
      tr:түрік тілі
      trv:тароко тілі
      ts:тсонга тілі
      tt:татар тілі
      ttm:солтүстік тутчоне тілі
      tum:тумбука тілі
      tvl:тувалу тілі
      tw:тви тілі
      twq:тасавак тілі
      ty:таити тілі
      tyv:тувин тілі
      tzm:орталық атлас тамазигхт тілі
      udm:удмурт тілі
      ug:ұйғыр тілі
      uk:украин тілі
      umb:умбунду тілі
      und:белгісіз тіл
      ur:урду тілі
      uz:өзбек тілі
      vai:вай тілі
      ve:венда тілі
      vec:венеция тілі
      vi:вьетнам тілі
      vmw:макуа тілі
      vo:волапюк тілі
      vun:вунджо тілі
      wa:валлон тілі
      wae:вальзер тілі
      wal:волайта тілі
      war:варай тілі
      wbp:вальбири тілі
      wo:волоф тілі
      wuu:қытай тілі (У)
      xal:қалмақ тілі
      xh:кхоса тілі
      xnr:кангри тілі
      xog:сога тілі
      yav:янгбен тілі
      ybb:йемба тілі
      yi:идиш тілі
      yo:йоруба тілі
      yrl:ньенгату тілі
      yue:кантон тілі
      yue-alt-menu:қытай тілі (кантон)
      za:чжуан тілі
      zgh:марокколық стандартты тамазигхт тілі
      zh:қытай тілі
      zh-alt-menu:қытай тілі (мандарин)
      zh-Hans:жеңілдетілген қытай тілі
      zh-Hans-alt-long:жеңілдетілген қытай тілі (мандарин)
      zh-Hant:дәстүрлі қытай тілі
      zh-Hant-alt-long:дәстүрлі қытай тілі (мандарин)
      zu:зулу тілі
      zun:зуни тілі
      zxx:тілдік мазмұны жоқ
      zza:заза тілі
      """.trimIndent() }

  val kk_Arab: String by lazy { """
      kk-Arab:قازاق ءتىلى (توتە)
      """.trimIndent() }

  val kk_Cyrl: String? = null

  val kk_KZ: String? = null

  val kkj: String by lazy { """
      en:yaman
      fr:numbu buy
      kkj:kakɔ
      """.trimIndent() }

  val kl: String by lazy { """
      kl:kalaallisut
      """.trimIndent() }

  val kln: String by lazy { """
      ak:kutitab Aka
      am:kutitab Amariek
      ar:kutitab Arabuk
      be:kutitab Belarusa
      bg:kutitab Bulgaria
      bn:kutitab Bengali
      cs:kutitab Chek
      de:kutitab Chermani
      el:kutitab Greece
      en:kutitab Uingeresa
      es:kutitab Espianik
      fa:kutitab Persia
      fr:kutitab Kifaransa
      ha:kutitab Hausa
      hi:kutitab Maindiik
      hu:kutitab Hangari
      id:kutitab Indonesia
      ig:kutitab Igbo
      it:kutitab Talianek
      ja:kutitap Japan
      jv:kutitap Javanese
      kln:Kalenjin
      km:kutitab Kher nebo Kwen
      ko:kutitab Korea
      ms:kutitab Malay
      my:kutitab Burma
      ne:kutitab Nepali
      nl:kutitab Boa
      pa:kutitab Punjab
      pl:kutitap Poland
      pt:kutitab Portugal
      ro:kutitab Romaniek
      ru:kutitab Russia
      rw:kutitab Kinyarwanda
      so:kutitab Somaliek
      sv:kutitab Sweden
      ta:kutitab Tamil
      th:kutitab Thailand
      tr:kutitab Turkey
      uk:kutitab Ukraine
      ur:kutitab Urdu
      vi:kutitab Vietnam
      yo:kutitab Yoruba
      zh:kutitab China
      zh-alt-menu:kutitab China
      zu:kutitab Zulu
      """.trimIndent() }

  val km: String by lazy { """
      aa:អាហ្វារ
      ab:អាប់ខាហ៊្សាន
      ace:អាកហ៊ីនឺស
      ada:អាដេងមី
      ady:អាឌីហ្គី
      ae:អាវេស្ថាន
      af:អាហ្វ្រិកាន
      agq:អាហ្គីម
      ain:អាយនូ
      ak:អាកាន
      ale:អាលូត
      alt:អាល់តៃខាងត្បូង
      am:អាំហារិក
      an:អារ៉ាហ្គោន
      ann:អូបូឡូ
      anp:អាហ្គីកា
      ar:អារ៉ាប់
      ar-001:អារ៉ាប់ស្តង់ដារទំនើប
      arn:ម៉ាពូឈី
      arp:អារ៉ាប៉ាហូ
      ars:អារ៉ាប់ណាឌី
      as:អាសាមីស
      asa:អាស៊ូ
      ast:អាស្ទូរី
      atj:អាទិកាម៉េក
      av:អាវ៉ារីក
      awa:អាវ៉ាឌី
      ay:អីម៉ារ៉ា
      az:អាស៊ែបៃហ្សង់
      az-alt-short:អាហ្ស៊ែរី
      ba:បាស្គៀ
      ban:បាលី
      bas:បាសា
      be:បេឡារុស
      bem:បេមបា
      bez:បេណា
      bg:ប៊ុលហ្ការី
      bgc:ហារីយ៉ាន់វី
      bgn:បាឡូជីខាងលិច
      bho:បូចពូរី
      bi:ប៊ីស្លាម៉ា
      bin:ប៊ីនី
      bla:ស៊ីកស៊ីកា
      blo:អានី
      bm:បាម្បារា
      bn:បង់ក្លាដែស
      bo:ទីបេ
      br:ប្រ៊ីស្តុន
      brx:បូដូ
      bs:បូស្ន៊ី
      bug:ប៊ុកហ្គី
      byn:ប្ល៊ីន
      ca:កាតាឡាន
      cay:ខាយូហ្កា
      ccp:ចាក់ម៉ា
      ce:ឈីឆេន
      ceb:ស៊ីប៊ូអាណូ
      cgg:ឈីហ្កា
      ch:ឈីម៉ូរ៉ូ
      chk:ឈូគី
      chm:ម៉ារី
      cho:ឆុកតាវ
      chp:ឈីប៉េវ៉ាយអិន
      chr:ឆេរូគី
      chy:ឈីយីនី
      ckb:ឃើដភាគកណ្តាល
      ckb-alt-menu:ឃើដភាគកណ្តាល
      ckb-alt-variant:ឃើដភាគកណ្តាល
      clc:ឈីលកូទីន
      co:កូស៊ីខាន
      crg:មីឈីហ្វ
      crj:គ្រីខាងកើត​ប៉ែកខាងត្បូង
      crk:គ្រីតំបន់វាលរាប
      crl:គ្រីខាងកើត​ប៉ែកខាងជើង
      crm:មូសគ្រី
      crr:អាល់ហ្គនខ្វៀន ខារ៉ូលីណា
      crs:សេសេលវ៉ាគ្រីអូល (បារាំង)
      cs:ឆែក
      csw:គ្រីតំបន់ភក់ល្បាប់
      cu:ឈើជស្លាវិក
      cv:ឈូវ៉ាស
      cy:វេល
      da:ដាណឺម៉ាក
      dak:ដាកូតា
      dar:ដាចវ៉ា
      dav:តៃតា
      de:អាល្លឺម៉ង់
      dgr:ដូគ្រីប
      dje:ហ្សាម៉ា
      doi:ដូហ្គ្រី
      dsb:សូប៊ីក្រោម
      dua:ឌួលឡា
      dv:ទេវីហ៊ី
      dyo:ចូឡាហ៊្វុនយី
      dz:ដុងខា
      dzg:ដាហ្សាហ្គា
      ebu:អេមប៊ូ
      ee:អ៊ីវ
      efi:អ៊ីហ្វិក
      eka:អ៊ីកាជុក
      el:ក្រិក
      en:អង់គ្លេស
      en-US-alt-short:អង់គ្លេស (ស.រ.អ.)
      eo:អេស្ពេរ៉ាន់តូ
      es:អេស្ប៉ាញ
      es-ES:អេស្ប៉ាញ (អ៊ឺរ៉ុប)
      et:អេស្តូនី
      eu:បាសខ៍
      ewo:អ៊ីវ៉ុនដូ
      fa:ភឺសៀន
      fa-AF:ដារី
      ff:ហ្វ៊ូឡា
      fi:ហ្វាំងឡង់
      fil:ហ្វ៊ីលីពីន
      fj:ហ៊្វីជី
      fo:ហ្វារូស
      fon:ហ្វ៊ុន
      fr:បារាំង
      frc:បារាំងកាហ្សង់
      frr:ហ្វ្រ៊ីសៀន​ខាងជើង
      fur:ហ៊្វ្រូលាន
      fy:ហ្វ្រីស៊ានខាងលិច
      ga:អៀរឡង់
      gaa:ហ្គា
      gag:កាគូស
      gd:ស្កុតហ្កែលិគ
      gez:ជីស
      gil:ហ្គីលបឺទ
      gl:ហ្កាលីស្យាន
      gn:ហ្គូរ៉ានី
      gor:ហ្គូរុនតាឡូ
      gsw:អាល្លឺម៉ង (ស្វីស)
      gu:ហ្គុយ៉ារ៉ាទី
      guz:ហ្គូស៊ី
      gv:មេន
      gwi:ហ្គីចឈីន
      ha:ហូសា
      hai:ហៃដា
      haw:ហាវ៉ៃ
      hax:ហៃដាខាងត្បូង
      he:ហេប្រឺ
      hi:ហិណ្ឌី
      hi-Latn-alt-variant:ហ៊ីងលីង
      hil:ហ៊ីលីហ្គេណុន
      hmn:ម៉ុង
      hr:ក្រូអាត
      hsb:សូប៊ីលើ
      ht:ហៃទី
      hu:ហុងគ្រី
      hup:ហ៊ូប៉ា
      hur:ហាល់កូម៉េឡេម
      hy:អាមេនី
      hz:ហឺរីរ៉ូ
      ia:អ៊ីនធើលីង
      iba:អ៊ីបាន
      ibb:អាយប៊ីប៊ីអូ
      id:ឥណ្ឌូណេស៊ី
      ie:អ៊ីនធើលីងវេ
      ig:អ៊ីកបូ
      ii:ស៊ីឈាន់យី
      ikt:អ៊ីនុកទីទុត​កាណាដា​ប៉ែកខាងលិច
      ilo:អ៊ីឡូកូ
      inh:អ៊ិនហ្គូស
      io:អ៊ីដូ
      is:អ៊ីស្លង់
      it:អ៊ីតាលី
      iu:អ៊ីនុកទីទុត
      ja:ជប៉ុន
      jbo:លុចបាន
      jgo:ងុំបា
      jmc:ម៉ាឆាំ
      jv:ជ្វា
      ka:ហ្សក​ហ្ស៊ី
      kab:កាប៊ីឡេ
      kac:កាឈីន
      kaj:ជូ
      kam:កាំបា
      kbd:កាបាឌៀ
      kcg:យ៉ាប់
      kde:ម៉ាកូនដេ
      kea:កាប៊ូវឺឌៀនូ
      kfo:គូរូ
      kgp:ខាងហ្កេង
      kha:កាស៊ី
      khq:គុយរ៉ាឈីនី
      ki:គីគូយូ
      kj:គូនយ៉ាម៉ា
      kk:កាហ្សាក់
      kkj:កាកូ
      kl:កាឡាលលីស៊ុត
      kln:កាលែនជីន
      km:ខ្មែរ
      kmb:គីមប៊ុនឌូ
      kn:ខាណាដា
      ko:កូរ៉េ
      koi:គូមីភឹមយ៉ាគ
      kok:គុនកានី
      kpe:គ្លីប
      kr:កានូរី
      krc:ការ៉ាឆាយបាល់កា
      krl:ការីលា
      kru:គូរូក
      ks:កាស្មៀរ
      ksb:សាមបាឡា
      ksf:បាហ្វៀ
      ksh:កូឡូញ
      ku:ឃឺដ
      kum:គូមីគ
      kv:កូមី
      kw:កូនីស
      kwk:ក្វាក់វ៉ាឡា
      kxv:គូវី
      ky:​កៀហ្ស៊ីស
      la:ឡាតំាង
      lad:ឡាឌីណូ
      lag:ឡានហ្គី
      lb:លុចសំបួ
      lez:ឡេសហ្គី
      lg:ហ្កាន់ដា
      li:លីមប៊ូស
      lij:លីគូរី
      lil:លីលលូអេត
      lkt:ឡាកូតា
      lmo:ឡំបាត
      ln:លីនកាឡា
      lo:ឡាវ
      lou:ក្រេអូល លូអ៊ីស៊ីអាណា
      loz:ឡូហ្ស៊ី
      lrc:លូរីខាងជើង
      lsm:សាមៀ
      lt:លីទុយអានី
      lu:លូបាកាតានហ្គា
      lua:លូបាលូឡា
      lun:លុនដា
      luo:លូអូ
      lus:មីហ្សូ
      luy:លូយ៉ា
      lv:ឡាតវី
      mad:ម៉ាឌូរីស
      mag:ម៉ាហ្គាហ៊ី
      mai:ម៉ៃធីលី
      mak:ម៉ាកាសា
      mas:ម៉ាសៃ
      mdf:មុខសា
      men:មេនឌី
      mer:មេរូ
      mfe:ម៉ូរីស៊ីន
      mg:ម៉ាឡាហ្គាស៊ី
      mgh:ម៉ាកគូវ៉ាមីតូ
      mgo:មេតា
      mh:ម៉ាស់សល
      mi:ម៉ោរី
      mic:មិកមេក
      min:មីណាងកាប៊ូ
      mk:ម៉ាសេដូនី
      ml:ម៉ាឡាយ៉ាឡាម
      mn:ម៉ុងហ្គោលី
      mni:ម៉ានីពូរី
      moe:អ៊ីននូអៃមុន
      moh:ម៊ូហាគ
      mos:មូស៊ី
      mr:ម៉ារ៉ាធី
      ms:ម៉ាឡេ
      mt:ម៉ាល់តា
      mua:មុនដាង
      mul:ពហុភាសា
      mus:គ្រីក
      mwl:មីរ៉ានដេស
      my:ភូមា
      myv:អឺហ្ស៊ីយ៉ា
      mzn:ម៉ាហ្សានដឺរេនី
      na:ណូរូ
      nap:នាប៉ូលីតាន
      naq:ណាម៉ា
      nb:ន័រវែស បុកម៉ាល់
      nd:នេបេលេខាងជើង
      nds:អាល្លឺម៉ង់ក្រោម
      nds-NL:ហ្សាក់ស្យុងក្រោម
      ne:នេប៉ាល់
      new:នេវ៉ាវី
      ng:នុនហ្គា
      nia:នីអាស
      niu:នូអៀន
      nl:ហូឡង់
      nl-BE:ផ្លាមីស
      nmg:ក្វាស្យូ
      nn:ន័រវែស នីនូស
      nnh:ងៀមប៊ូន
      no:ន័រវែស
      nog:ណូហ្គៃ
      nqo:នគោ
      nr:នេប៊េលខាងត្បូង
      nso:សូថូខាងជើង
      nus:នូអ័រ
      nv:ណាវ៉ាចូ
      ny:ណានចា
      nyn:ណានកូលេ
      oc:អូសីតាន់
      ojb:អូជីបវ៉ា​ប៉ែកពាយ័ព្យ
      ojc:អូជីពវ៉ាកណ្ដាល
      ojs:អូជីគ្រី
      ojw:អូជីបវ៉ា​ខាងលិច
      oka:អូកាណាហ្កាន
      om:អូរ៉ូម៉ូ
      or:អូឌៀ
      os:អូស៊ីទិក
      pa:បឹនជាពិ
      pag:ភេនហ្គាស៊ីណាន
      pam:ផាមភេនហ្គា
      pap:ប៉ាប៉ៃមេនតូ
      pau:ប៉ាលូអាន
      pcm:ភាសាទំនាក់ទំនងនីហ្សេរីយ៉ា
      pis:ពីជីន
      pl:ប៉ូឡូញ
      pqm:ម៉ាលីស៊ីត ប៉ាសាម៉ាខ្វូឌី
      prg:ព្រូស៊ាន
      ps:បាស្តូ
      pt:ព័រទុយហ្គាល់
      pt-BR:ព័រទុយហ្កាល់ (ប្រេស៊ីល)
      pt-PT:ព័រទុយហ្គាល់ (អឺរ៉ុប)
      qu:ហ្គិកឈួ
      quc:គីចឈី
      raj:រ៉ាចាស់ថានី
      rap:រ៉ាប៉ានូ
      rar:រ៉ារ៉ូតុងហ្គាន
      rhg:រ៉ូហ៊ីងយ៉ា
      rm:រ៉ូម៉ង់
      rn:រុណ្ឌី
      ro:រូម៉ានី
      ro-MD:ម៉ុលដាវី
      rof:រុមបូ
      ru:រុស្ស៊ី
      rup:អារ៉ូម៉ានី
      rw:គិនយ៉ាវ៉ាន់ដា
      rwk:រ៉្វា
      sa:សំស្ក្រឹត
      sad:សានដាវី
      sah:យ៉ាឃុត
      saq:សាមបូរូ
      sat:សាន់តាលី
      sba:ងាំបេយ
      sbp:សានហ្គូ
      sc:សាឌីនា
      scn:ស៊ីស៊ីលាន
      sco:ស្កុត
      sd:ស៊ីនឌី
      sdh:ឃើដភាគខាងត្បូង
      se:សាមីខាងជើង
      seh:ស៊ីណា
      ses:គុយរ៉ាបូរ៉ុស៊ីនី
      sg:សានហ្គោ
      sh:សឺបូក្រូអាត
      shi:តាឈីលហ៊ីត
      shn:សាន
      si:ស្រីលង្កា
      sk:ស្លូវ៉ាគី
      sl:ស្លូវ៉ានី
      slh:ឡាស៊ូតស៊ីតខាងត្បូង
      sm:សាម័រ
      sma:សាមីខាងត្បូង
      smj:លូលីសាមី
      smn:អ៊ីណារីសាមី
      sms:ស្កុលសាមី
      sn:សូណា
      snk:សូនីនគេ
      so:សូម៉ាលី
      sq:អាល់បានី
      sr:ស៊ែប
      srn:ស្រាណានតុងហ្គោ
      ss:ស្វាទី
      ssy:សាហូ
      st:សូថូខាងត្បូង
      str:សាលីសស្ត្រេតស៍
      su:ស៊ូដង់
      suk:ស៊ូគូម៉ា
      sv:ស៊ុយអែត
      sw:ស្វាហ៊ីលី
      sw-CD:កុងហ្គោស្វាហ៊ីលី
      swb:កូម៉ូរី
      syr:ស៊ីរី
      szl:ស៊ីឡេស៊ី
      ta:តាមីល
      tce:ថុចឆុនខាងត្បូង
      te:តេលុគុ
      tem:ធីមនី
      teo:តេសូ
      tet:ទីទុំ
      tg:តាហ្ស៊ីគ
      tgx:តាហ្គីស
      th:ថៃ
      tht:តាល់តាន
      ti:ទីហ្គ្រីញ៉ា
      tig:ធីហ្គ្រា
      tk:តួកម៉េន
      tlh:ឃ្លីនហ្គុន
      tli:ថ្លីងហ្គីត
      tn:ស្វាណា
      to:តុងហ្គា
      tok:តូគីប៉ូណា
      tpi:ថុកពីស៊ីន
      tr:ទួរគី
      trv:តារ៉ូកូ
      ts:សុងហ្គា
      tt:តាតា
      ttm:ថុចឆុនខាងជើង
      tum:ទុមប៊ូកា
      tvl:ទូវ៉ាលូ
      tw:ទ្វី
      twq:តាសាវ៉ាក់
      ty:តាហ៊ីទី
      tyv:ទូវីនៀ
      tzm:តាម៉ាសាយអាត្លាសកណ្តាល
      udm:អាត់មូដ
      ug:អ៊ុយហ្គឺរ
      uk:អ៊ុយក្រែន
      umb:អាម់ប៊ុនឌូ
      und:ភាសាមិនស្គាល់
      ur:អ៊ូរឌូ
      uz:អ៊ូសបេគ
      vai:វៃ
      ve:វេនដា
      vec:វេណេតូ
      vi:វៀតណាម
      vmw:ម៉ាឃូវ៉ា
      vo:វូឡាពូក
      vun:វុនចូ
      wa:វ៉ាលូន
      wae:វេលសឺ
      wal:វ៉ូឡាយតា
      war:វ៉ារេយ
      wbp:វ៉ារីប៉ារី
      wo:វូឡុហ្វ
      wuu:អ៊ូចិន
      xal:កាលមីគ
      xh:ឃសា
      xnr:ខែងគ្រី
      xog:សូហ្គា
      yav:យ៉ាងបេន
      ybb:យេមបា
      yi:យ៉ីឌីស
      yo:យរូបា
      yrl:ញីនហ្កាទូ
      yue:កន្តាំង
      yue-alt-menu:ចិនកាតាំង
      za:ហ្សួង
      zgh:តាម៉ាហ្សៃម៉ារ៉ុកស្តង់ដា
      zh:ចិន
      zh-alt-menu:ចិនកុកងឺ
      zh-Hans:ចិន​អក្សរ​កាត់
      zh-Hans-alt-long:ចិនកុកងឺ (អក្សរ​កាត់)
      zh-Hant:ចិន​អក្សរ​ពេញ
      zh-Hant-alt-long:ចិនកុកងឺ (អក្សរ​ពុម្ព)
      zu:ហ្សូលូ
      zun:ហ្សូនី
      zxx:គ្មាន​ទិន្នន័យ​ភាសា
      zza:ហ្សាហ្សា
      """.trimIndent() }

  val kn: String by lazy { """
      aa:ಅಫಾರ್
      ab:ಅಬ್ಖಾಜಿಯನ್
      ace:ಅಛಿನೀಸ್
      ach:ಅಕೋಲಿ
      ada:ಅಡಂಗ್ಮೆ
      ady:ಅಡೈಘೆ
      ae:ಅವೆಸ್ಟನ್
      af:ಆಫ್ರಿಕಾನ್ಸ್
      afh:ಆಫ್ರಿಹಿಲಿ
      agq:ಅಘೆಮ್
      ain:ಐನು
      ak:ಅಕಾನ್
      akk:ಅಕ್ಕಾಡಿಯನ್
      ale:ಅಲೆಯುಟ್
      alt:ದಕ್ಷಿಣ ಅಲ್ಟಾಯ್
      am:ಅಂಹರಿಕ್
      an:ಅರಗೊನೀಸ್
      ang:ಪ್ರಾಚೀನ ಇಂಗ್ಲೀಷ್
      ann:ಒಬೊಲೊ
      anp:ಆಂಗಿಕಾ
      ar:ಅರೇಬಿಕ್
      ar-001:ಆಧುನಿಕ ಪ್ರಮಾಣಿತ ಅರೇಬಿಕ್
      arc:ಅರಾಮಿಕ್
      arn:ಮಪುಚೆ
      arp:ಅರಪಾಹೋ
      ars:ನ್ಯಾಜ್ಡಿ ಅರೇಬಿಕ್
      arw:ಅರಾವಾಕ್
      as:ಅಸ್ಸಾಮೀಸ್
      asa:ಅಸು
      ast:ಆಸ್ಟುರಿಯನ್
      atj:ಅತಿಕಮೆಕ್
      av:ಅವರಿಕ್
      awa:ಅವಧಿ
      ay:ಅಯ್ಮಾರಾ
      az:ಅಜೆರ್ಬೈಜಾನಿ
      az-alt-short:ಅಝೆರಿ
      ba:ಬಶ್ಕಿರ್
      bal:ಬಲೂಚಿ
      ban:ಬಲಿನೀಸ್
      bas:ಬಸಾ
      be:ಬೆಲರೂಸಿಯನ್
      bej:ಬೇಜಾ
      bem:ಬೆಂಬಾ
      bez:ಬೆನ
      bg:ಬಲ್ಗೇರಿಯನ್
      bgc:ಹರ್ಯಾನ್ವಿ
      bgn:ಪಶ್ಚಿಮ ಬಲೊಚಿ
      bho:ಭೋಜಪುರಿ
      bi:ಬಿಸ್ಲಾಮಾ
      bik:ಬಿಕೊಲ್
      bin:ಬಿನಿ
      bla:ಸಿಕ್ಸಿಕಾ
      blo:ಅನೀ
      bm:ಬಂಬಾರಾ
      bn:ಬಾಂಗ್ಲಾ
      bo:ಟಿಬೇಟಿಯನ್
      br:ಬ್ರೆಟನ್
      bra:ಬ್ರಜ್
      brx:ಬೋಡೊ
      bs:ಬೋಸ್ನಿಯನ್
      bua:ಬುರಿಯಟ್
      bug:ಬುಗಿನೀಸ್
      byn:ಬ್ಲಿನ್
      ca:ಕೆಟಲಾನ್
      cad:ಕ್ಯಾಡ್ಡೋ
      car:ಕಾರಿಬ್
      cay:ಕಯುಗಾ
      cch:ಅಟ್ಸಮ್
      ccp:ಚಕ್ಮಾ
      ce:ಚಚೆನ್
      ceb:ಸೆಬುವಾನೊ
      cgg:ಚಿಗಾ
      ch:ಕಮೊರೊ
      chb:ಚಿಬ್ಚಾ
      chg:ಚಗಟಾಯ್
      chk:ಚೂಕಿಸೆ
      chm:ಮಾರಿ
      chn:ಚಿನೂಕ್ ಜಾರ್ಗೋನ್
      cho:ಚೋಕ್ಟಾವ್
      chp:ಚಿಪೆವ್ಯಾನ್
      chr:ಚೆರೋಕಿ
      chy:ಚೀಯೆನ್ನೇ
      ckb:ಮಧ್ಯ ಕುರ್ದಿಶ್
      ckb-alt-menu:ಮಧ್ಯ ಕುರ್ದಿಶ್
      ckb-alt-variant:ಕುರ್ದಿಶ್, ಸೊರಾನಿ
      clc:ಚಿಲ್ಕೋಟಿನ್
      co:ಕೋರ್ಸಿಕನ್
      cop:ಕೊಪ್ಟಿಕ್
      cr:ಕ್ರೀ
      crg:ಮಿಚಿಫ್
      crh:ಕ್ರಿಮೀಯನ್ ಟರ್ಕಿಷ್
      crj:ದಕ್ಷಿಣ ಪೂರ್ವ ಕ್ರೀ
      crk:ಪ್ಲೇನ್ಸ್ ಕ್ರೀ
      crl:ಉತ್ತರ ಪೂರ್ವ ಕ್ರೀ
      crm:ಮೂಸ್ ಕ್ರೀ
      crr:ಕೆರೊಲಿನಾ ಅಲ್ಗೊಂಕ್ವಿಯನ್
      crs:ಸೆಸೆಲ್ವಾ ಕ್ರಯೋಲ್ ಫ್ರೆಂಚ್
      cs:ಜೆಕ್
      csb:ಕಶುಬಿಯನ್
      csw:ಸ್ವಾಂಪಿ ಕ್ರೀ
      cu:ಚರ್ಚ್ ಸ್ಲಾವಿಕ್
      cv:ಚುವಾಶ್
      cy:ವೆಲ್ಶ್
      da:ಡ್ಯಾನಿಶ್
      dak:ಡಕೋಟಾ
      dar:ದರ್ಗ್ವಾ
      dav:ಟೈಟ
      de:ಜರ್ಮನ್
      de-AT:ಆಸ್ಟ್ರಿಯನ್ ಜರ್ಮನ್
      de-CH:ಸ್ವಿಸ್ ಹೈ ಜರ್ಮನ್
      del:ಡೆಲಾವೇರ್
      den:ಸ್ಲೇವ್
      dgr:ಡೋಗ್ರಿಬ್
      din:ಡಿಂಕಾ
      dje:ಜರ್ಮಾ
      doi:ಡೋಗ್ರಿ
      dsb:ಲೋವರ್ ಸರ್ಬಿಯನ್
      dua:ಡುವಾಲಾ
      dum:ಮಧ್ಯ ಡಚ್
      dv:ದಿವೆಹಿ
      dyo:ಜೊಲ-ಫೊನ್ಯಿ
      dyu:ಡ್ಯೂಲಾ
      dz:ಜೋಂಗ್‌ಖಾ
      dzg:ಡಜಾಗ
      ebu:ಎಂಬು
      ee:ಈವ್
      efi:ಎಫಿಕ್
      egy:ಪ್ರಾಚೀನ ಈಜಿಪ್ಟಿಯನ್
      eka:ಎಕಾಜುಕ್
      el:ಗ್ರೀಕ್
      elx:ಎಲಾಮೈಟ್
      en:ಇಂಗ್ಲಿಷ್
      en-AU:ಆಸ್ಟ್ರೇಲಿಯನ್ ಇಂಗ್ಲಿಷ್
      en-CA:ಕೆನೆಡಿಯನ್ ಇಂಗ್ಲಿಷ್
      en-GB:ಬ್ರಿಟಿಷ್ ಇಂಗ್ಲಿಷ್
      en-GB-alt-short:ಯು.ಕೆ. ಇಂಗ್ಲಿಷ್
      en-US:ಅಮೆರಿಕನ್ ಇಂಗ್ಲಿಷ್
      en-US-alt-short:ಯು.ಎಸ್. ಇಂಗ್ಲಿಷ್
      enm:ಮಧ್ಯ ಇಂಗ್ಲೀಷ್
      eo:ಎಸ್ಪೆರಾಂಟೊ
      es:ಸ್ಪ್ಯಾನಿಷ್
      es-419:ಲ್ಯಾಟಿನ್ ಅಮೇರಿಕನ್ ಸ್ಪ್ಯಾನಿಷ್
      es-ES:ಯುರೋಪಿಯನ್ ಸ್ಪ್ಯಾನಿಷ್
      es-MX:ಮೆಕ್ಸಿಕನ್ ಸ್ಪ್ಯಾನಿಷ್
      et:ಎಸ್ಟೊನಿಯನ್
      eu:ಬಾಸ್ಕ್
      ewo:ಇವಾಂಡೋ
      fa:ಪರ್ಶಿಯನ್
      fa-AF:ದರಿ
      fan:ಫಾಂಗ್
      fat:ಫಾಂಟಿ
      ff:ಫುಲಾ
      fi:ಫಿನ್ನಿಶ್
      fil:ಫಿಲಿಪಿನೊ
      fj:ಫಿಜಿಯನ್
      fo:ಫರೋಸಿ
      fon:ಫೋನ್
      fr:ಫ್ರೆಂಚ್
      fr-CA:ಕೆನೆಡಿಯನ್ ಫ್ರೆಂಚ್
      fr-CH:ಸ್ವಿಸ್ ಫ್ರೆಂಚ್
      frc:ಕಾಜುನ್ ಫ್ರೆಂಚ್
      frm:ಮಧ್ಯ ಫ್ರೆಂಚ್
      fro:ಪ್ರಾಚೀನ ಫ್ರೆಂಚ್
      frr:ಉತ್ತರ ಫ್ರಿಸಿಯನ್
      frs:ಪೂರ್ವ ಫ್ರಿಸಿಯನ್
      fur:ಫ್ರಿಯುಲಿಯನ್
      fy:ಪಶ್ಚಿಮ ಫ್ರಿಸಿಯನ್
      ga:ಐರಿಷ್
      gaa:ಗ
      gag:ಗಗೌಜ್
      gan:ಗಾನ್ ಚೀನೀಸ್
      gay:ಗಾಯೋ
      gba:ಗ್ಬಾಯಾ
      gd:ಸ್ಕಾಟಿಶ್ ಗೆಲಿಕ್
      gez:ಗೀಝ್
      gil:ಗಿಲ್ಬರ್ಟೀಸ್
      gl:ಗ್ಯಾಲಿಶಿಯನ್
      gmh:ಮಧ್ಯ ಹೈ ಜರ್ಮನ್
      gn:ಗೌರಾನಿ
      goh:ಪ್ರಾಚೀನ ಹೈ ಜರ್ಮನ್
      gon:ಗೊಂಡಿ
      gor:ಗೊರೊಂಟಾಲೋ
      got:ಗೋಥಿಕ್
      grb:ಗ್ರೇಬೋ
      grc:ಪ್ರಾಚೀನ ಗ್ರೀಕ್
      gsw:ಸ್ವಿಸ್ ಜರ್ಮನ್
      gu:ಗುಜರಾತಿ
      guz:ಗುಸಿ
      gv:ಮ್ಯಾಂಕ್ಸ್
      gwi:ಗ್ವಿಚ್‌ಇನ್
      ha:ಹೌಸಾ
      hai:ಹೈಡಾ
      hak:ಹಕ್
      haw:ಹವಾಯಿಯನ್
      hax:ದಕ್ಷಿಣ ಹೈಡಾ
      he:ಹೀಬ್ರೂ
      hi:ಹಿಂದಿ
      hi-Latn-alt-variant:ಹಿಂಗ್ಲಿಷ್
      hil:ಹಿಲಿಗೇನನ್
      hit:ಹಿಟ್ಟಿಟೆ
      hmn:ಮೋಂಗ್
      ho:ಹಿರಿ ಮೊಟು
      hr:ಕ್ರೊಯೇಶಿಯನ್
      hsb:ಅಪ್ಪರ್ ಸರ್ಬಿಯನ್
      hsn:ಶಯಾಂಗ್ ಚೀನೀಸೇ
      ht:ಹೈಟಿಯನ್ ಕ್ರಿಯೋಲಿ
      hu:ಹಂಗೇರಿಯನ್
      hup:ಹೂಪಾ
      hur:ಹಾಲ್ಕೊಮೆಲೆಮ್
      hy:ಅರ್ಮೇನಿಯನ್
      hz:ಹೆರೆರೊ
      ia:ಇಂಟರ್‌ಲಿಂಗ್ವಾ
      iba:ಇಬಾನ್
      ibb:ಇಬಿಬಿಯೋ
      id:ಇಂಡೋನೇಶಿಯನ್
      ie:ಇಂಟರ್‌ಲಿಂಗ್
      ig:ಇಗ್ಬೊ
      ii:ಸಿಚುಅನ್ ಯಿ
      ik:ಇನುಪಿಯಾಕ್
      ikt:ಪಶ್ಚಿಮ ಕೆನಡಿಯನ್ ಇನುಕ್ಟಿಟುಟ್
      ilo:ಇಲ್ಲಿಕೋ
      inh:ಇಂಗುಷ್
      io:ಇಡೊ
      is:ಐಸ್‌ಲ್ಯಾಂಡಿಕ್
      it:ಇಟಾಲಿಯನ್
      iu:ಇನುಕ್ಟಿಟುಟ್
      ja:ಜಾಪನೀಸ್
      jbo:ಲೊಜ್ಬಾನ್
      jgo:ನೊಂಬಾ
      jmc:ಮ್ಯಕಮೆ
      jpr:ಜೂಡಿಯೋ-ಪರ್ಶಿಯನ್
      jrb:ಜೂಡಿಯೋ-ಅರೇಬಿಕ್
      jv:ಜಾವಾನೀಸ್
      ka:ಜಾರ್ಜಿಯನ್
      kaa:ಕಾರಾ-ಕಲ್ಪಾಕ್
      kab:ಕಬೈಲ್
      kac:ಕಚಿನ್
      kaj:ಜ್ಜು
      kam:ಕಂಬಾ
      kaw:ಕಾವಿ
      kbd:ಕಬರ್ಡಿಯನ್
      kcg:ಟ್ಯಾಪ್
      kde:ಮ್ಯಾಕೊಂಡ್
      kea:ಕಬುವೆರ್ಡಿಯನು
      kfo:ಕೋರೋ
      kg:ಕಾಂಗೋ
      kgp:ಕೈಗಂಗ್
      kha:ಖಾಸಿ
      kho:ಖೋಟಾನೀಸ್
      khq:ಕೊಯ್ರ ಚೀನಿ
      ki:ಕಿಕುಯು
      kj:ಕ್ವಾನ್‌ಯಾಮಾ
      kk:ಕಝಕ್
      kkj:ಕಾಕೊ
      kl:ಕಲಾಲ್ಲಿಸುಟ್
      kln:ಕಲೆಂಜಿನ್
      km:ಖಮೇರ್
      kmb:ಕಿಂಬುಂಡು
      kn:ಕನ್ನಡ
      ko:ಕೊರಿಯನ್
      koi:ಕೋಮಿ-ಪರ್ಮ್ಯಕ್
      kok:ಕೊಂಕಣಿ
      kos:ಕೊಸರಿಯನ್
      kpe:ಕಪೆಲ್ಲೆ
      kr:ಕನುರಿ
      krc:ಕರಚಯ್-ಬಲ್ಕಾರ್
      krl:ಕರೇಲಿಯನ್
      kru:ಕುರುಖ್
      ks:ಕಾಶ್ಮೀರಿ
      ksb:ಶಂಬಲ
      ksf:ಬಫಿಯ
      ksh:ಕಲೊಗ್ನಿಯನ್
      ku:ಕುರ್ದಿಷ್
      kum:ಕುಮೈಕ್
      kut:ಕುಟೇನಾಯ್
      kv:ಕೋಮಿ
      kw:ಕಾರ್ನಿಷ್
      kwk:ಕ್ವಾಕ್‌ವಾಲಾ
      kxv:ಕುವಿ
      ky:ಕಿರ್ಗಿಜ್
      la:ಲ್ಯಾಟಿನ್
      lad:ಲ್ಯಾಡಿನೋ
      lag:ಲಾಂಗಿ
      lah:ಲಹಂಡಾ
      lam:ಲಂಬಾ
      lb:ಲಕ್ಸಂಬರ್ಗಿಷ್
      lez:ಲೆಜ್ಘಿಯನ್
      lg:ಗಾಂಡಾ
      li:ಲಿಂಬರ್ಗಿಶ್
      lij:ಲಿಗುರಿಯನ್
      lil:ಲಿಲ್ಲೂವೆಟ್
      lkt:ಲಕೊಟ
      lmo:ಲೋಂಬರ್ಡ್
      ln:ಲಿಂಗಾಲ
      lo:ಲಾವೋ
      lol:ಮೊಂಗೋ
      lou:ಲೂಯಿಸಿಯಾನ ಕ್ರಿಯೋಲ್
      loz:ಲೋಝಿ
      lrc:ಉತ್ತರ ಲೂರಿ
      lsm:ಸಾಮಿಯಾ
      lt:ಲಿಥುವೇನಿಯನ್
      lu:ಲೂಬಾ-ಕಟಾಂಗಾ
      lua:ಲುಬ-ಲುಲಾ
      lui:ಲೂಯಿಸೆನೋ
      lun:ಲುಂಡಾ
      luo:ಲುವೋ
      lus:ಮಿಝೋ
      luy:ಲುಯಿಯ
      lv:ಲಾಟ್ವಿಯನ್
      mad:ಮದುರೀಸ್
      mag:ಮಗಾಹಿ
      mai:ಮೈಥಿಲಿ
      mak:ಮಕಾಸರ್
      man:ಮಂಡಿಂಗೊ
      mas:ಮಸಾಯ್
      mdf:ಮೋಕ್ಷ
      mdr:ಮಂದಾರ್
      men:ಮೆಂಡೆ
      mer:ಮೆರು
      mfe:ಮೊರಿಸನ್
      mg:ಮಲಗಾಸಿ
      mga:ಮಧ್ಯ ಐರಿಷ್
      mgh:ಮ್ಯಖುವಾ- ಮೀಟ್ಟೊ
      mgo:ಮೆಟಾ
      mh:ಮಾರ್ಶಲ್ಲೀಸ್
      mi:ಮಾವೋರಿ
      mic:ಮಿಕ್‌ಮ್ಯಾಕ್
      min:ಮಿನಂಗ್‌ಕಬಾವು
      mk:ಮೆಸಿಡೋನಿಯನ್
      ml:ಮಲಯಾಳಂ
      mn:ಮಂಗೋಲಿಯನ್
      mnc:ಮಂಚು
      mni:ಮಣಿಪುರಿ
      moe:ಇನ್ನು-ಐಮುನ್
      moh:ಮೊಹಾವ್ಕ್
      mos:ಮೊಸ್ಸಿ
      mr:ಮರಾಠಿ
      ms:ಮಲಯ್
      mt:ಮಾಲ್ಟೀಸ್
      mua:ಮುಂಡಂಗ್
      mul:ಬಹುಸಂಖ್ಯೆಯ ಭಾಷೆಗಳು
      mus:ಕ್ರೀಕ್
      mwl:ಮಿರಾಂಡೀಸ್
      mwr:ಮಾರ್ವಾಡಿ
      my:ಬರ್ಮೀಸ್
      myv:ಎರ್ಝ್ಯಾ
      mzn:ಮಜಂದೆರಾನಿ
      na:ನೌರು
      nan:ನಾನ್
      nap:ನಿಯಾಪೊಲಿಟನ್
      naq:ನಮ
      nb:ನಾರ್ವೆಜಿಯನ್ ಬೊಕ್ಮಲ್
      nd:ಉತ್ತರ ದೆಬೆಲೆ
      nds:ಲೋ ಜರ್ಮನ್
      nds-NL:ಲೋ ಸ್ಯಾಕ್ಸನ್
      ne:ನೇಪಾಳಿ
      new:ನೇವಾರೀ
      ng:ಡೋಂಗಾ
      nia:ನಿಯಾಸ್
      niu:ನಿಯುವನ್
      nl:ಡಚ್
      nl-BE:ಫ್ಲೆಮಿಷ್
      nmg:ಖ್ವಾಸಿಯೊ
      nn:ನಾರ್ವೇಜಿಯನ್ ನೈನಾರ್ಸ್ಕ್
      nnh:ನಿಂಬೂನ್
      no:ನಾರ್ವೇಜಿಯನ್
      nog:ನೊಗಾಯ್
      non:ಪ್ರಾಚೀನ ನೋರ್ಸ್
      nqo:ಎನ್‌ಕೋ
      nr:ದಕ್ಷಿಣ ದೆಬೆಲೆ
      nso:ಉತ್ತರ ಸೋಥೋ
      nus:ನೂಯರ್
      nv:ನವಾಜೊ
      nwc:ಶಾಸ್ತ್ರೀಯ ನೇವಾರಿ
      ny:ನ್ಯಾಂಜಾ
      nym:ನ್ಯಾಮ್‌ವೆಂಜಿ
      nyn:ನ್ಯಾನ್‌ಕೋಲೆ
      nyo:ನ್ಯೋರೋ
      nzi:ಜೀಮಾ
      oc:ಒಸಿಟನ್
      oj:ಒಜಿಬ್ವಾ
      ojb:ವಾಯುವ್ಯ ಓಜಿಬ್ವಾ
      ojc:ಮಧ್ಯ ಓಜಿಬ್ವಾ
      ojs:ಓಜಿ-ಕ್ರೀ
      ojw:ಪಶ್ಚಿಮ ಓಜಿಬ್ವಾ
      oka:ಒಕನಾಗನ್
      om:ಒರೊಮೊ
      or:ಒಡಿಯ
      os:ಒಸ್ಸೆಟಿಕ್
      osa:ಓಸಾಜ್
      ota:ಒಟ್ಟೋಮನ್ ತುರ್ಕಿಷ್
      pa:ಪಂಜಾಬಿ
      pag:ಪಂಗಾಸಿನನ್
      pal:ಪಹ್ಲವಿ
      pam:ಪಂಪಾಂಗಾ
      pap:ಪಪಿಯಾಮೆಂಟೊ
      pau:ಪಲುಆನ್
      pcm:ನೈಜೀರಿಯನ್ ಪಿಡ್ಗಿನ್
      peo:ಪ್ರಾಚೀನ ಪರ್ಶಿಯನ್
      phn:ಫೀನಿಷಿಯನ್
      pi:ಪಾಲಿ
      pis:ಪಿಜಿನ್
      pl:ಪೊಲಿಶ್
      pon:ಪೋನ್‌‌ಪಿಯನ್
      pqm:ಮ್ಯಾಲಿಸೀಟ್-ಪಸ್ಸಾಮಕ್ವಾಡ್ಡಿ
      prg:ಪ್ರಶಿಯನ್
      pro:ಪ್ರಾಚೀನ ಪ್ರೊವೆನ್ಶಿಯಲ್
      ps:ಪಾಷ್ಟೋ
      ps-alt-variant:ಪುಶ್ತೋ
      pt:ಪೋರ್ಚುಗೀಸ್
      pt-BR:ಬ್ರೆಜಿಲಿಯನ್ ಪೋರ್ಚುಗೀಸ್
      pt-PT:ಯೂರೋಪಿಯನ್ ಪೋರ್ಚುಗೀಸ್
      qu:ಕ್ವೆಚುವಾ
      quc:ಕಿಷೆ
      raj:ರಾಜಸ್ಥಾನಿ
      rap:ರಾಪಾನುಯಿ
      rar:ರಾರೋಟೊಂಗನ್
      rhg:ರೋಹಿಂಗ್ಯಾ
      rm:ರೊಮಾನ್ಶ್
      rn:ರುಂಡಿ
      ro:ರೊಮೇನಿಯನ್
      ro-MD:ಮಾಲ್ಡೇವಿಯನ್
      rof:ರೊಂಬೊ
      rom:ರೋಮಾನಿ
      ru:ರಷ್ಯನ್
      rup:ಅರೋಮಾನಿಯನ್
      rw:ಕಿನ್ಯಾರ್‌ವಾಂಡಾ
      rwk:ರುವ
      sa:ಸಂಸ್ಕೃತ
      sad:ಸಂಡಾವೇ
      sah:ಸಖಾ
      sam:ಸಮರಿಟನ್ ಅರಾಮಿಕ್
      saq:ಸಂಬುರು
      sas:ಸಸಾಕ್
      sat:ಸಂತಾಲಿ
      sba:ನಂಬೇ
      sbp:ಸಂಗು
      sc:ಸರ್ಡೀನಿಯನ್
      scn:ಸಿಸಿಲಿಯನ್
      sco:ಸ್ಕೋಟ್ಸ್
      sd:ಸಿಂಧಿ
      sdh:ದಕ್ಷಿಣ ಕುರ್ದಿಶ್
      se:ಉತ್ತರ ಸಾಮಿ
      seh:ಸೆನ
      sel:ಸೆಲ್ಕಪ್
      ses:ಕೊಯ್ರಬೊರೊ ಸೆನ್ನಿ
      sg:ಸಾಂಗೋ
      sga:ಪ್ರಾಚೀನ ಐರಿಷ್
      sh:ಸರ್ಬೋ-ಕ್ರೊಯೇಶಿಯನ್
      shi:ಟಷೆಲ್‍ಹಿಟ್
      shn:ಶಾನ್
      si:ಸಿಂಹಳ
      sid:ಸಿಡಾಮೋ
      sk:ಸ್ಲೋವಾಕ್
      sl:ಸ್ಲೋವೇನಿಯನ್
      slh:ದಕ್ಷಿಣ ಲುಶೂಟ್‌ಸೀಡ್
      sm:ಸಮೋವನ್
      sma:ದಕ್ಷಿಣ ಸಾಮಿ
      smj:ಲೂಲ್ ಸಾಮಿ
      smn:ಇನಾರಿ ಸಮೀ
      sms:ಸ್ಕೋಟ್ ಸಾಮಿ
      sn:ಶೋನಾ
      snk:ಸೋನಿಂಕೆ
      so:ಸೊಮಾಲಿ
      sog:ಸೋಗ್ಡಿಯನ್
      sq:ಅಲ್ಬೇನಿಯನ್
      sr:ಸೆರ್ಬಿಯನ್
      srn:ಸ್ರಾನನ್ ಟೋಂಗೋ
      srr:ಸೇರೇರ್
      ss:ಸ್ವಾತಿ
      ssy:ಸಹೊ
      st:ದಕ್ಷಿಣ ಸೋಥೋ
      str:ಸ್ಟ್ರೇಟ್ಸ್ ಸೆಲಿಶ್
      su:ಸುಂಡಾನೀಸ್
      suk:ಸುಕುಮಾ
      sus:ಸುಸು
      sux:ಸುಮೇರಿಯನ್
      sv:ಸ್ವೀಡಿಷ್
      sw:ಸ್ವಹಿಲಿ
      sw-CD:ಕಾಂಗೊ ಸ್ವಹಿಲಿ
      swb:ಕೊಮೊರಿಯನ್
      syc:ಶಾಸ್ತ್ರೀಯ ಸಿರಿಯಕ್
      syr:ಸಿರಿಯಾಕ್
      szl:ಸಿಲೆಸಿಯನ್
      ta:ತಮಿಳು
      tce:ದಕ್ಷಿಣ ಟಚ್‌ವನ್
      te:ತೆಲುಗು
      tem:ಟಿಮ್ನೆ
      teo:ಟೆಸೊ
      ter:ಟೆರೆನೋ
      tet:ಟೇಟಮ್
      tg:ತಾಜಿಕ್
      tgx:ಟಾಗಿಶ್
      th:ಥಾಯ್
      tht:ಟಾಹ್ಲ್ಟನ್
      ti:ಟಿಗ್ರಿನ್ಯಾ
      tig:ಟೈಗ್ರೆ
      tiv:ಟಿವ್
      tk:ಟರ್ಕ್‌ಮೆನ್
      tkl:ಟೊಕೆಲಾವ್
      tl:ಟ್ಯಾಗಲೋಗ್
      tlh:ಕ್ಲಿಂಗನ್
      tli:ಟ್ಲಿಂಗಿಟ್
      tmh:ಟಮಾಷೆಕ್
      tn:ಸ್ವಾನಾ
      to:ಟೋಂಗನ್
      tog:ನ್ಯಾಸಾ ಟೋಂಗಾ
      tok:ಟೋಕಿ ಪೋನಾ
      tpi:ಟೋಕ್ ಪಿಸಿನ್
      tr:ಟರ್ಕಿಶ್
      trv:ಟರೊಕೊ
      ts:ಸೋಂಗಾ
      tsi:ಸಿಂಶಿಯನ್
      tt:ಟಾಟರ್
      ttm:ಉತ್ತರ ಟಚ್‌ವನ್
      tum:ತುಂಬುಕಾ
      tvl:ಟುವಾಲು
      tw:ಟ್ವಿ
      twq:ಟಸವಕ್
      ty:ಟಹೀಟಿಯನ್
      tyv:ಟುವಿನಿಯನ್
      tzm:ಮಧ್ಯ ಅಟ್ಲಾಸ್ ಟಮಜೈಟ್
      udm:ಉಡ್‌ಮುರ್ಟ್
      ug:ಉಯಿಘರ್
      ug-alt-variant:ಉಯ್‌ಗರ್
      uga:ಉಗಾರಿಟಿಕ್
      uk:ಉಕ್ರೇನಿಯನ್
      umb:ಉಂಬುಂಡು
      und:ಅಪರಿಚಿತ ಭಾಷೆ
      ur:ಉರ್ದು
      uz:ಉಜ್ಬೇಕ್
      vai:ವಾಯಿ
      ve:ವೆಂಡಾ
      vec:ವೆನಿಶಿಯನ್
      vi:ವಿಯೆಟ್ನಾಮೀಸ್
      vmw:ಮಖುವಾ
      vo:ವೋಲಾಪುಕ್
      vot:ವೋಟಿಕ್
      vun:ವುಂಜೊ
      wa:ವಾಲೂನ್
      wae:ವಾಲ್ಸರ್
      wal:ವಲಾಯ್ತಾ
      war:ವರಾಯ್
      was:ವಾಷೋ
      wbp:ವಾರ್ಲ್‌ಪಿರಿ
      wo:ವೋಲೋಫ್
      wuu:ವು ಚೈನೀಸ್
      xal:ಕಲ್ಮೈಕ್
      xh:ಕ್ಸೋಸ
      xnr:ಕಂಗ್ರಿ
      xog:ಸೊಗ
      yao:ಯಾವೊ
      yap:ಯಪೀಸೆ
      yav:ಯಾಂಗ್ಬೆನ್
      ybb:ಯೆಂಬಾ
      yi:ಯಿಡ್ಡಿಶ್
      yo:ಯೊರುಬಾ
      yrl:ನಿಂಗಾಟು
      yue:ಕ್ಯಾಂಟನೀಸ್
      yue-alt-menu:ಚೈನೀಸ್, ಕ್ಯಾಂಟೊನೀಸ್
      za:ಝೂವಾಂಗ್
      zap:ಝೋಪೊಟೆಕ್
      zbl:ಬ್ಲಿಸ್ಸಿಂಬಲ್ಸ್
      zen:ಝೆನಾಗಾ
      zgh:ಸ್ಟ್ಯಾಂಡರ್ಡ್ ಮೊರೊಕ್ಕನ್ ಟಮಜೈಟ್
      zh:ಚೈನೀಸ್
      zh-alt-menu:ಚೈನೀಸ್, ಮ್ಯಾಂಡರಿನ್
      zh-Hans:ಸರಳೀಕೃತ ಚೈನೀಸ್
      zh-Hans-alt-long:ಸರಳೀಕೃತ ಮ್ಯಾಂಡರಿನ್ ಚೈನೀಸ್
      zh-Hant:ಸಾಂಪ್ರದಾಯಿಕ ಚೈನೀಸ್
      zh-Hant-alt-long:ಸಾಂಪ್ರದಾಯಿಕ ಮ್ಯಾಂಡರಿನ್ ಚೈನೀಸ್
      zu:ಜುಲು
      zun:ಝೂನಿ
      zxx:ಯಾವುದೇ ಭಾಷಾಸಂಬಂಧಿ ವಿಷಯವಿಲ್ಲ
      zza:ಜಾಝಾ
      """.trimIndent() }

  val ko: String by lazy { """
      aa:아파르어
      ab:압카즈어
      ace:아체어
      ach:아콜리어
      ada:아당메어
      ady:아디게어
      ae:아베스타어
      aeb:튀니지 아랍어
      af:아프리칸스어
      afh:아프리힐리어
      agq:아그햄어
      ain:아이누어
      ak:아칸어
      akk:아카드어
      ale:알류트어
      alt:남부 알타이어
      am:암하라어
      an:아라곤어
      ang:고대 영어
      ann:오볼로어
      anp:앙가어
      ar:아랍어
      ar-001:현대 표준 아랍어
      arc:아람어
      arn:마푸둥군어
      arp:아라파호어
      arq:알제리 아랍어
      ars:아랍어(나즈디)
      arw:아라와크어
      ary:모로코 아랍어
      arz:이집트 아랍어
      as:아삼어
      asa:아수어
      ast:아스투리아어
      atj:아티카메쿠어
      av:아바릭어
      awa:아와히어
      ay:아이마라어
      az:아제르바이잔어
      az-alt-short:아제리어
      ba:바슈키르어
      bal:발루치어
      ban:발리어
      bas:바사어
      bax:바문어
      bbj:고말라어
      be:벨라루스어
      bej:베자어
      bem:벰바어
      bez:베나어
      bfd:바푸트어
      bg:불가리아어
      bgc:하리안비어
      bgn:서부 발로치어
      bho:호즈푸리어
      bi:비슬라마어
      bik:비콜어
      bin:비니어
      bkm:콤어
      bla:식시카어
      blo:아니이어
      bm:밤바라어
      bn:벵골어
      bo:티베트어
      br:브르타뉴어
      bra:브라지어
      brh:브라후이어
      brx:보도어
      bs:보스니아어
      bss:아쿠즈어
      bua:부리아타
      bug:부기어
      bum:불루어
      byn:브린어
      byv:메둠바어
      ca:카탈로니아어
      cad:카도어
      car:카리브어
      cay:카유가어
      cch:앗삼어
      ccp:차크마어
      ce:체첸어
      ceb:세부아노어
      cgg:치가어
      ch:차모로어
      chb:치브차어
      chg:차가타이어
      chk:추크어
      chm:마리어
      chn:치누크 자곤
      cho:촉토어
      chp:치페우얀
      chr:체로키어
      chy:샤이엔어
      ckb:소라니 쿠르드어
      ckb-alt-menu:쿠르드어(소라니)
      ckb-alt-variant:쿠르드어(소라니)
      clc:칠코틴어
      co:코르시카어
      cop:콥트어
      cr:크리어
      crg:미치프어
      crh:크리민 터키어; 크리민 타타르어
      crj:남동부 크리어
      crk:평원 크리어
      crl:북동부 크리어
      crm:무스크리어
      crr:캐롤라이나 알곤킨어
      crs:세이셸 크리올 프랑스어
      cs:체코어
      csb:카슈비아어
      csw:습지 크리어
      cu:교회 슬라브어
      cv:추바시어
      cy:웨일스어
      da:덴마크어
      dak:다코타어
      dar:다르그와어
      dav:타이타어
      de:독일어
      de-CH:고지 독일어(스위스)
      del:델라웨어어
      den:슬라브어
      dgr:도그리브어
      din:딩카어
      dje:자르마어
      doi:도그리어
      dsb:저지 소르비아어
      dua:두알라어
      dum:중세 네덜란드어
      dv:디베히어
      dyo:졸라 포니어
      dyu:드율라어
      dz:종카어
      dzg:다장가어
      ebu:엠부어
      ee:에웨어
      efi:이픽어
      egy:고대 이집트어
      eka:이카죽어
      el:그리스어
      elx:엘람어
      en:영어
      enm:중세 영어
      eo:에스페란토어
      es:스페인어
      es-ES:스페인어(유럽)
      et:에스토니아어
      eu:바스크어
      ewo:이원도어
      fa:페르시아어
      fa-AF:다리어
      fan:팡그어
      fat:판티어
      ff:풀라어
      fi:핀란드어
      fil:필리핀어
      fj:피지어
      fo:페로어
      fon:폰어
      fr:프랑스어
      frc:케이준 프랑스어
      frm:중세 프랑스어
      fro:고대 프랑스어
      frr:북부 프리지아어
      frs:동부 프리슬란드어
      fur:프리울리어
      fy:서부 프리지아어
      ga:아일랜드어
      gaa:가어
      gag:가가우스어
      gan:간어
      gay:가요어
      gba:그바야어
      gbz:조로아스터 다리어
      gd:스코틀랜드 게일어
      gez:게이즈어
      gil:키리바시어
      gl:갈리시아어
      glk:길라키어
      gmh:중세 고지 독일어
      gn:과라니어
      goh:고대 고지 독일어
      gon:곤디어
      gor:고론탈로어
      got:고트어
      grb:게르보어
      grc:고대 그리스어
      gsw:독일어(스위스)
      gu:구자라트어
      guz:구시어
      gv:맹크스어
      gwi:그위친어
      ha:하우사어
      hai:하이다어
      hak:하카어
      haw:하와이어
      hax:남부 하이다어
      he:히브리어
      hi:힌디어
      hi-Latn-alt-variant:힝글리시
      hif:피지 힌디어
      hil:헤리가뇬어
      hit:하타이트어
      hmn:히몸어
      ho:히리 모투어
      hr:크로아티아어
      hsb:고지 소르비아어
      hsn:샹어
      ht:아이티어
      hu:헝가리어
      hup:후파어
      hur:할코멜렘어
      hy:아르메니아어
      hz:헤레로어
      ia:인터링구아
      iba:이반어
      ibb:이비비오어
      id:인도네시아어
      ie:인테르링구에
      ig:이그보어
      ii:쓰촨 이어
      ik:이누피아크어
      ikt:캐나다 서부 이누크티투트어
      ilo:이로코어
      inh:인귀시어
      io:이도어
      is:아이슬란드어
      it:이탈리아어
      iu:이눅티투트어
      ja:일본어
      jbo:로반어
      jgo:응곰바어
      jmc:마차메어
      jpr:유대-페르시아어
      jrb:유대-아라비아어
      jv:자바어
      ka:조지아어
      kaa:카라칼파크어
      kab:커바일어
      kac:카친어
      kaj:까꼬토끄어
      kam:캄바어
      kaw:카위어
      kbd:카바르디어
      kbl:카넴부어
      kcg:티얍어
      kde:마콘데어
      kea:크리올어
      kfo:코로어
      kg:콩고어
      kgp:카잉강어
      kha:카시어
      kho:호탄어
      khq:코이라 친니어
      khw:코와르어
      ki:키쿠유어
      kj:쿠안야마어
      kk:카자흐어
      kkj:카코어
      kl:그린란드어
      kln:칼렌진어
      km:크메르어
      kmb:킴분두어
      kn:칸나다어
      ko:한국어
      koi:코미페르먀크어
      kok:코카니어
      kos:코스라이엔어
      kpe:크펠레어
      kr:칸누리어
      krc:카라챠이-발카르어
      krl:카렐리야어
      kru:쿠르크어
      ks:카슈미르어
      ksb:샴발라어
      ksf:바피아어
      ksh:콜로그니안어
      ku:쿠르드어
      kum:쿠믹어
      kut:쿠테네어
      kv:코미어
      kw:콘월어
      kwk:곽왈라어
      kxv:쿠비어
      ky:키르기스어
      la:라틴어
      lad:라디노어
      lag:랑기어
      lah:라한다어
      lam:람바어
      lb:룩셈부르크어
      lez:레즈기안어
      lfn:링구아 프랑카 노바
      lg:간다어
      li:림버거어
      lij:리구리아어
      lil:릴루엣어
      lkt:라코타어
      lmo:롬바르드어
      ln:링갈라어
      lo:라오어
      lol:몽고어
      lou:루이지애나 크리올어
      loz:로지어
      lrc:북부 루리어
      lsm:사미아어
      lt:리투아니아어
      lu:루바-카탄가어
      lua:루바-룰루아어
      lui:루이세노어
      lun:룬다어
      luo:루오어
      lus:루샤이어
      luy:루야어
      lv:라트비아어
      mad:마두라어
      maf:마파어
      mag:마가히어
      mai:마이틸리어
      mak:마카사어
      man:만딩고어
      mas:마사이어
      mde:마바어
      mdf:모크샤어
      mdr:만다르어
      men:멘데어
      mer:메루어
      mfe:모리스얀어
      mg:말라가시어
      mga:중세 아일랜드어
      mgh:마크후와-메토어
      mgo:메타어
      mh:마셜어
      mi:마오리어
      mic:미크맥어
      min:미낭카바우어
      mk:마케도니아어
      ml:말라얄람어
      mn:몽골어
      mnc:만주어
      mni:마니푸리어
      moe:이누아문
      moh:모호크어
      mos:모시어
      mr:마라티어
      mrj:서부 마리어
      ms:말레이어
      mt:몰타어
      mua:문당어
      mul:다중 언어
      mus:크리크어
      mwl:미란데어
      mwr:마르와리어
      my:버마어
      mye:미예네어
      myv:엘즈야어
      mzn:마잔데라니어
      na:나우루어
      nan:민난어
      nap:나폴리어
      naq:나마어
      nb:노르웨이어(보크말)
      nd:북부 은데벨레어
      nds:저지 독일어
      nds-NL:저지 색슨어
      ne:네팔어
      new:네와르어
      ng:느동가어
      nia:니아스어
      niu:니웨언어
      nl:네덜란드어
      nl-BE:플라망어
      nmg:크와시오어
      nn:노르웨이어(니노르스크)
      nnh:느기엠본어
      no:노르웨이어
      nog:노가이어
      non:고대 노르웨이어
      nqo:응코어
      nr:남부 은데벨레어
      nso:북부 소토어
      nus:누에르어
      nv:나바호어
      nwc:고전 네와르어
      ny:냔자어
      nym:니암웨지어
      nyn:니안콜어
      nyo:뉴로어
      nzi:느지마어
      oc:오크어
      oj:오지브와어
      ojb:북서부 오지브와어
      ojc:중앙 오지브와어
      ojs:오지 크리어
      ojw:서부 오지브와어
      oka:오카나간어
      om:오로모어
      or:오리야어
      os:오세트어
      osa:오세이지어
      ota:오스만 터키어
      pa:펀잡어
      pag:판가시난어
      pal:팔레비어
      pam:팜팡가어
      pap:파피아먼토어
      pau:팔라우어
      pcm:나이지리아 피진어
      peo:고대 페르시아어
      phn:페니키아어
      pi:팔리어
      pis:피진어
      pl:폴란드어
      pnt:폰틱어
      pon:폼페이어
      pqm:말리시트 파사마쿼디어
      prg:프러시아어
      pro:고대 프로방스어
      ps:파슈토어
      pt:포르투갈어
      pt-PT:포르투갈어(유럽)
      qu:케추아어
      quc:키체어
      raj:라자스탄어
      rap:라파뉴이
      rar:라로통가어
      rhg:로힝야어
      rm:로만시어
      rn:룬디어
      ro:루마니아어
      ro-MD:몰도바어
      rof:롬보어
      rom:집시어
      ru:러시아어
      rue:루신어
      rup:아로마니아어
      rw:르완다어
      rwk:르와어
      sa:산스크리트어
      sad:산다웨어
      sah:야쿠트어
      sam:사마리아 아랍어
      saq:삼부루어
      sas:사사크어
      sat:산탈리어
      sba:느감바이어
      sbp:상구어
      sc:사르디니아어
      scn:시칠리아어
      sco:스코틀랜드어
      sd:신디어
      sdh:남부 쿠르드어
      se:북부 사미어
      see:세네카어
      seh:세나어
      sel:셀쿠프어
      ses:코이야보로 세니어
      sg:산고어
      sga:고대 아일랜드어
      sh:세르비아-크로아티아어
      shi:타셸히트어
      shn:샨어
      shu:차디언 아라비아어
      si:싱할라어
      sid:시다모어
      sk:슬로바키아어
      sl:슬로베니아어
      slh:남부 루슈트시드어
      sm:사모아어
      sma:남부 사미어
      smj:룰레 사미어
      smn:이나리 사미어
      sms:스콜트 사미어
      sn:쇼나어
      snk:소닌케어
      so:소말리아어
      sog:소그디엔어
      sq:알바니아어
      sr:세르비아어
      srn:스라난 통가어
      srr:세레르어
      ss:시스와티어
      ssy:사호어
      st:남부 소토어
      str:해안 살리시어
      su:순다어
      suk:수쿠마어
      sus:수수어
      sux:수메르어
      sv:스웨덴어
      sw:스와힐리어
      sw-CD:콩고 스와힐리어
      swb:코모로어
      syc:고전 시리아어
      syr:시리아어
      szl:실레시아어
      ta:타밀어
      tce:남부 투톤어
      te:텔루구어
      tem:팀니어
      teo:테조어
      ter:테레노어
      tet:테툼어
      tg:타지크어
      tgx:타기시어
      th:태국어
      tht:탈탄어
      ti:티그리냐어
      tig:티그레어
      tiv:티브어
      tk:투르크멘어
      tkl:토켈라우제도어
      tkr:차후르어
      tl:타갈로그어
      tlh:클링온어
      tli:틀링깃족어
      tly:탈리쉬어
      tmh:타마섹어
      tn:츠와나어
      to:통가어
      tog:니아사 통가어
      tok:도기 보나
      tpi:토크 피신어
      tr:튀르키예어
      trv:타로코어
      ts:총가어
      tsi:트심시안어
      tt:타타르어
      ttm:북부 투톤어
      tum:툼부카어
      tvl:투발루어
      tw:트위어
      twq:타사와크어
      ty:타히티어
      tyv:투비니안어
      tzm:중앙 모로코 타마지트어
      udm:우드말트어
      ug:위구르어
      uga:유가리틱어
      uk:우크라이나어
      umb:움분두어
      und:알 수 없는 언어
      ur:우르두어
      uz:우즈베크어
      vai:바이어
      ve:벤다어
      vec:베네치아어
      vi:베트남어
      vmw:마쿠와어
      vo:볼라퓌크어
      vot:보틱어
      vun:분조어
      wa:왈론어
      wae:월저어
      wal:월라이타어
      war:와라이어
      was:와쇼어
      wbp:왈피리어
      wo:월로프어
      wuu:우어
      xal:칼미크어
      xh:코사어
      xnr:캉리어
      xog:소가어
      yao:야오족어
      yap:얍페세어
      yav:양본어
      ybb:옘바어
      yi:이디시어
      yo:요루바어
      yrl:넨가투어
      yue:광둥어
      yue-alt-menu:중국어(광둥어)
      za:주앙어
      zap:사포테크어
      zbl:블리스 심볼
      zen:제나가어
      zgh:표준 모로코 타마지트어
      zh:중국어
      zh-alt-menu:중국어(만다린)
      zh-Hans-alt-long:중국어(만다린, 간체)
      zh-Hant-alt-long:중국어(만다린, 번체)
      zu:줄루어
      zun:주니어
      zxx:언어 관련 내용 없음
      zza:자자어
      """.trimIndent() }

  val ko_CN: String? = null

  val ko_KP: String? = null

  val kok: String by lazy { """
      aa:अफार
      ab:अबखेज़ियन
      ace:अचायनीज
      ada:अडांग्मे
      ady:अडिघे
      af:अफ्रिकान्स
      agq:अघेम
      ain:आयनू
      ak:अकान
      ale:आलिट
      alt:दक्षिणी अल्टाय
      am:अमहारिक्
      an:आरागोनिस
      ann:ओबोलो
      anp:अंगिका
      ar:अरेबिक
      ar-001:आधुनिक प्रमाणित अरेबिक
      arn:मापुचे
      arp:अरापाहो
      ars:नाझदी अरबी
      as:आसामी
      asa:असु
      ast:अस्टुरियान
      atj:अटिकामेक्वु
      av:अवारिक
      awa:अवधी
      ay:ऐमरा
      az:अझरबैजानी
      az-alt-short:अझेरी
      ba:बष्किर
      ban:बालिनीज
      bas:बस्सा
      be:बेलारुशियन
      bem:बेम्बा
      bez:बेना
      bg:बल्गेरियन
      bgc:हरयाणवी
      bho:भोजपुरी
      bi:बिसलमा
      bin:बिनी
      bla:सिकसिका
      blo:अनी
      bm:बंबारा
      bn:बांग्ला
      bo:तिबेटी
      br:ब्रेटन
      brx:बोडो
      bs:बोस्नियन
      bug:बुगिनिज
      byn:ब्लीन
      ca:कटलान
      cay:कायुगा
      ccp:चाक्मा
      ce:चिचेन
      ceb:सेबुआनो
      cgg:चिगा
      ch:चामोर्रो
      chk:चुकीज
      chm:मारी
      cho:चाकता
      chp:चिपेवायन
      chr:चॅरोकी
      chy:शायान
      ckb:मध्य कर्दिश
      ckb-alt-menu:कर्दिश, मध्य
      ckb-alt-variant:कर्दिश, सोरानी
      clc:चिलकोटिन
      co:कोर्सिकन
      crg:मिचिफ
      crj:आग्नेय क्री
      crk:प्लेन्स क्री
      crl:ईशान्य क्री
      crm:मूझ क्री
      crr:कॅरोलीना अल्गॉन्क्वियन
      crs:सेसेल्वा क्रयॉल फ्रेन्च
      cs:चेक
      csw:स्वॉम्पी क्री
      cu:चर्च स्लेव्हीक
      cv:चुवाश
      cy:वेल्श
      da:डॅनिश
      dak:डाकोटा
      dar:दार्ग्वा
      dav:तायता
      de:जर्मन
      de-AT:ऑस्ट्रियन जर्मन
      de-CH:स्विझ हाय जर्मन
      dgr:डोगरीब
      dje:झर्मा
      doi:डोग्री
      dsb:लोवर सोर्बियन
      dua:डुआला
      dv:दिवेही
      dyo:जोला-फोन्यी
      dz:झोंग्खा
      dzg:डाझागा
      ebu:एम्बु
      ee:एव
      efi:एफीक
      eka:एकाजुक
      el:ग्रीक
      en:इंग्लीश
      en-AU:ऑस्ट्रेलियन इंग्लीश
      en-CA:कॅनडियन इंग्लीश
      en-GB:ब्रिटीश इंग्लीश
      en-GB-alt-short:यूके इंग्लीश
      en-US:अमेरिकन इंग्लीश
      en-US-alt-short:यूएस इंग्लीश
      eo:इस्परान्टो
      es:स्पॅनीश
      es-419:लातीं अमेरिकन स्पॅनीश
      es-ES:युरोपियन स्पॅनीश
      es-MX:मॅक्सिकन स्पॅनीश
      et:इस्टोनियन
      eu:बास्क
      ewo:एवोंडो
      fa:पर्शियन
      fa-AF:दारी
      ff:फुला
      fi:फिनिश
      fil:फिलिपिनो
      fj:फिजी
      fo:फेरोस
      fon:फोन
      fr:फ्रेंच
      fr-CA:कॅनडियन फ्रेंच
      fr-CH:स्विझ फ्रेंच
      frc:कॅजां फ्रेंच
      frr:उत्तरीय फ्रिशियन
      fur:फ्रिलियन
      fy:पश्चिमी फ्रिशियन
      ga:आयरिश
      gaa:गा
      gd:स्कॉटीश गॅलीक
      gez:गेझ
      gil:गिलबर्टीस
      gl:गेलीशियन
      gn:ग्वारानी
      gor:गोरोंटालो
      gsw:स्विस जर्मन
      gu:गुजराती
      guz:गुसी
      gv:मांक्स
      gwi:ग्विच
      ha:हौसा
      hai:हैदा
      haw:हवायियान
      hax:दक्षिणी हैदा
      he:हिब्रू
      hi:हिन्दी
      hi-Latn-alt-variant:हिंग्लीश
      hil:हिलीगायनॉन
      hmn:मोंग
      hr:क्रोएशियन
      hsb:अपर सोर्बियन
      ht:हैतियन क्रेयॉल
      hu:हंगेरियन
      hup:हुपा
      hur:हाल्कोमेलेम
      hy:आर्मेनियन
      hz:हिरिरो
      ia:इन्टरलिंग्वा
      iba:आयबन
      ibb:ईबिबियो
      id:इंडोनेशियन
      ie:इन्टरलिंग्
      ig:इग्बो
      ii:सिच्युआन यी
      ik:इनूपेयाक्
      ikt:पश्चिमी कॅनडियन इनक्तितुत
      ilo:इलोको
      inh:इंगूश
      io:इदो
      is:आयस्लान्डिक
      it:इटालियन
      iu:इन्युक्तिटुट
      ja:जपानी
      jbo:लोजबान
      jgo:गोंबा
      jmc:मचामे
      jv:जावनीज
      ka:जॉर्जियन
      kab:काबायले
      kac:काचीन
      kaj:जु
      kam:कंबा
      kbd:काबार्डियन
      kcg:त्याप
      kde:माकोंडे
      kea:काबुवर्डियनु
      kfo:कोरो
      kgp:कैनगँग
      kha:खासी
      khq:कोयरा छिनी
      ki:किकुयु
      kj:क्वानयामा
      kk:कझाख
      kkj:काको
      kl:कालाल्लिसुट
      kln:कालेंजीन
      km:कंबोडिया
      kmb:किंबुंडु
      kn:कन्नड
      ko:कोरियन
      kok:कोंकणी
      kpe:पेल्ले
      kr:कानुरी
      krc:कराची-बाल्कर
      krl:कारेलियन
      kru:कुरुख
      ks:कश्मीरी
      ksb:शांबाला
      ksf:बाफिया
      ksh:कोलोनियन
      ku:कर्दिश
      kum:कुमयक
      kv:कोमी
      kw:कोर्निश
      kwk:क्वाकवाला
      kxv:कुवी
      ky:किर्गिझ
      la:लॅटिन
      lad:लाडिनो
      lag:लांगी
      lb:लक्झेम्बर्गीश
      lez:लेझघियान
      lg:गांडा
      li:लिंबर्गिश
      lij:लिगुरियन
      lil:लल्युएत
      lkt:लाकोटा
      lmo:लोमबार्ड
      ln:लिंगाला
      lo:लाओ
      lou:ल्युइसियाना क्रियोल
      loz:लोझीं
      lrc:उत्तरीय लुरी
      lsm:सामिया
      lt:लिथुआनियन
      lu:लुबा-काटांगा
      lua:लुबा-लुलुआ
      lun:लुंडा
      luo:लुओ
      lus:मिझो
      luy:ल्युइया
      lv:लात्वियन
      mad:मादुरीज
      mag:मगाही
      mai:मैथिली
      mak:माकासार
      mas:मसाई
      mdf:मोक्ष
      men:मेंडे
      mer:मेरू
      mfe:मोरिसेन
      mg:मलागसी
      mgh:माखुवा-मिट्टो
      mgo:मेटा
      mh:मार्शलीज
      mi:माओरी
      mic:मिक्माक
      min:मिनान्गकाबाव
      mk:मेसेडोनियन
      ml:मल्याळम
      mn:मंगोलियन
      mni:मणिपुरी
      moe:इन्यु-ऐमुन
      moh:मोहाक
      mos:मोस्सी
      mr:मराठी
      ms:मलय
      mt:माल्टिज
      mua:मुडांग
      mul:साबार भाशा
      mus:मस्कोजी
      mwl:मिरांडीस
      my:बर्मीज
      myv:एरझिया
      mzn:मझांडेराणी
      na:नौरू
      nap:नियापोलिटन
      naq:नामा
      nb:नॉर्वेजियन बोकमाल
      nd:उत्तर डेबेले
      nds:लोवर जर्मन
      ne:नेपाळी
      new:नेवारी
      ng:डोंगा
      nia:नियास
      niu:नायान
      nl:डच
      nl-BE:फ्लेमिश
      nmg:क्वासीयो
      nn:नॉर्वेजियन नायनोर्स्क
      nnh:गियेम्बून
      no:नोर्वेजियन
      nog:नोगाय
      nqo:नको
      nr:दक्षिण डेबेले
      nso:उत्तरीय सोथो
      nus:न्युयर
      nv:नावाजो
      ny:नांन्जा
      nyn:नानकोले
      oc:ऑक्सिटन
      ojb:वायव्य ओजिब्वे
      ojc:मध्य ओजिब्वे
      ojs:ओजि-क्री
      ojw:पश्चिमी ओजिब्वे
      oka:ओकानागान
      om:ओरोमो
      or:उडीया
      os:ओसेटिक
      pa:पंजाबी
      pag:पांगासियनान
      pam:पांपान्गा
      pap:पाप्यामेंटो
      pau:पालावान
      pcm:नायजिरियन पिजिन
      pis:पिजिन
      pl:पोलिश
      pqm:मालिसीत-पास्सामाखिडी
      prg:प्रुसियन
      ps:पश्तो
      pt:पोर्तुगीज
      pt-BR:ब्राझिलियन पोर्तुगीज
      pt-PT:युरोपियन पोर्तुगीज
      qu:क्वेच्वा
      quc:किचे
      raj:राजस्थानी
      rap:रापान्यु
      rar:रारोटोंगान
      rhg:रोहिंग्या
      rm:रोमान्श
      rn:रुंदी
      ro:रोमानियन
      ro-MD:मोल्डावियन्
      rof:रोम्बो
      ru:रशियन
      rup:आरोमेनियन
      rw:किन्यार्वान्डा
      rwk:रवा
      sa:संस्कृत
      sad:संडावे
      sah:साखा
      saq:साम्बुरू
      sat:संथाली
      sba:गांबे
      sbp:सांगू
      sc:सार्डिनियान
      scn:सिसिलियान
      sco:स्कॉट्स
      sd:सिंधी
      se:उत्तरीय सामी
      seh:सेना
      ses:कोयराबोरो सेन्नी
      sg:सांगो
      sh:सेर्बो-क्रोयेषियन्
      shi:ताछेल्हीट
      shn:शान
      si:सिंहला
      sk:स्लोवाक
      sl:स्लोवानियन
      slh:दक्षिणी लशूतसीड
      sm:सामोअन
      sma:दक्षिणी सामी
      smj:लुले सामी
      smn:ईनारी सामी
      sms:स्कोल्ट सामी
      sn:शोना
      snk:सोनिके
      so:सोमाली
      sq:आल्बेनियन्
      sr:सर्बियन
      srn:श्रानन टोंगो
      ss:स्वाती
      ssy:साहो
      st:दक्षिणी सोथो
      str:स्ट्रैट सालिश
      su:सुंदनीस
      suk:सुकुमा
      sv:स्विडीश
      sw:स्वाहिली
      sw-CD:काँगो स्वाहिली
      swb:कोमोरियन
      syr:सिरियाक
      szl:सिलेसियान
      ta:तमिळ
      tce:दक्षिणी तुत्चोने
      te:तेलुगू
      tem:तिम्ने
      teo:तेसो
      tet:तेतम
      tg:ताजिक
      tgx:टॅगिश
      th:थाई
      tht:ताहल्तान
      ti:तिग्रिन्या
      tig:टिग्रे
      tk:तुर्कमेन
      tl:तगालोग
      tlh:क्लिंगॉन
      tli:लिंगिट
      tn:सेत्स्वाना
      to:तोंगान
      tok:तोकी पोना
      tpi:तोक पिसीन
      tr:तुर्की
      trv:तारोको
      ts:त्सोंगा
      tt:तातर
      ttm:उत्तरीय तुत्चोने
      tum:तुंबुका
      tvl:तुवालू
      tw:त्वि
      twq:तासावाक
      ty:ताहीशियन
      tyv:तुविनियन
      tzm:केंद्रीय अटलास तामाझायट
      udm:उडमुर्त
      ug:उयघूर
      uk:युक्रेनियन
      umb:उंबुंडु
      und:अज्ञात भास
      ur:उर्दू
      uz:उझबेक
      vai:वाई
      ve:वेंदा
      vec:वेनेशियन
      vi:व्हिएतनामीज
      vmw:माखुवा
      vo:ओलापुक
      vun:वुंजो
      wa:वालून
      wae:वाल्सर
      wal:वोलायटा
      war:वरय
      wo:वोलोफ
      wuu:व्हु चिनी
      xal:कालमायक
      xh:खोसा
      xnr:कांग्री
      xog:सोगा
      yav:यांगबेन
      ybb:येम्बा
      yi:यिडिश
      yo:योरुबा
      yrl:न्हीनगातु
      yue:कॅण्टोनीस
      yue-alt-menu:चिनी, कॅण्टोनीस
      za:झ्हुन्ग
      zgh:प्रमाणीत मॉरोक्कन तमाझीट
      zh:चिनी
      zh-alt-menu:चिनी, मंडारीन
      zh-Hans:सोंपी चिनी
      zh-Hans-alt-long:सोंपी मंडारीन चिनी
      zh-Hant:पारंपारीक चिनी
      zh-Hant-alt-long:पारंपारीक मंडारीन चिनी
      zu:झुलू
      zun:झुनी
      zxx:अणकार सामुग्री ना
      zza:झाझा
      """.trimIndent() }

  val kok_Deva: String? = null

  val kok_Latn: String by lazy { """
      ar:Arbi
      el:Grik
      en:Inglix
      es:Ispanhol
      fr:Fransez
      kn:Kon’nodd
      kok:Konknni
      mr:Moratthi
      zh:Chini
      zh-alt-menu:Chini
      """.trimIndent() }

  val kpe: String by lazy { """
      kpe:Kpɛlɛɛ
      """.trimIndent() }

  val kpe_GN: String? = null

  val ks: String by lazy { """
      aa:اَفار
      ab:اَبخازِیان
      ace:اَچَےنیٖز
      ach:اَکولی
      ada:اَدَنگمیے
      ady:اَدَیٖگیے
      ae:اَویستَن
      af:اَفریٖکانز
      afh:اَفرِہِلی
      ain:اینوٗ
      ak:اَکان
      akk:اَکادِیَن
      ale:اَلویتی
      alt:جنوٗبی اَلتایی
      am:اَمہاری
      an:اَراگونی
      ang:پرون اَنگریٖزی
      anp:اَنگِکا
      ar:عربی
      ar-001:ماڈرن معیٲری عربی
      arc:اَرَمیک
      arn:ایرو کونِیَن
      arp:اَراپاہو
      arw:اَراوَک
      as:اسٲمؠ
      ast:ایسٹوٗریَن
      av:اَوارِک
      awa:اَوَدی
      ay:ایمارا
      az:اَزَربیجانی
      az-alt-short:اَزَربیجانی
      ba:بَشکیٖر
      bal:بَلوٗچی
      ban:بالِنیٖز
      bas:باسا
      be:بیلَروٗشیَن
      bej:بیجا
      bem:بیمبا
      bg:بینا
      bho:بوجپوٗری
      bi:بِسلاما
      bik:بِکول
      bin:بِنی
      bla:سِکسِکا
      bm:بَمبارا
      bn:بَنگٲلؠ
      bo:تِبتی
      br:بریٹَن
      bra:برج
      bs:بوسنِیَن
      bua:بُرِیَت
      bug:بَگنیٖز
      byn:بٕلِن
      ca:کَتلان
      cad:کاڈو
      car:کارِب
      cch:اتسَم
      ce:چیچَن
      ceb:سیباونو
      ch:کَمورو
      chb:چیٖبچا
      chg:چھَگتاے
      chk:چُکیٖز
      chm:ماری
      chn:چِنوٗک جارگَن
      cho:چوکتَو
      chp:شیپویان
      chr:چیروکی
      chy:شییون
      co:کارسِکَن
      cop:کاپٹِک
      cr:کری
      crh:کرٕمیٖن تُرکی
      cs:چیک
      csb:کَشوٗبِیَن
      cu:چٔرچ سلاوِک
      cv:چُواش
      cy:ویلش
      da:ڈینِش
      dak:ڈکوٹا
      dar:دَرگوا
      de:جٔرمَن
      de-AT:آسٹرِیَن جٔرمَن
      de-CH:سٕوِس ہائی جٔرمَن
      del:ڈیلوییَر
      den:سلیو
      dgr:ڈاگرِب
      din:ڈِنکا
      doi:ڈوگری
      dsb:بۆنِم ساربِیَن
      dua:دُوالا
      dum:وَستی پُرتُگالی
      dv:دِویہی
      dyu:ڈِیوٗلا
      dz:زونگکھا
      ee:ایٖو
      efi:ایفِک
      egy:قدیٖمی مِصری
      eka:ایکاجُک
      el:یوٗنٲنی
      elx:ایلامایِٹ
      en:اَنگیٖزؠ
      en-AU:آسٹریلیَن اَنگریٖزؠ
      en-CA:کینَڈِیٲیی اَنگریٖزؠ
      en-GB:بَرطانوی اَنگریٖزؠ
      en-GB-alt-short:UK اَنٛگریٖزؠ
      en-US:امریٖکی اَنٛگریٖزؠ
      en-US-alt-short:US اَنٛگریٖزؠ
      enm:وَسطی اَنگریٖزؠ
      eo:ایسپَرینٹو
      es:ہسپانوی
      es-419:لاطیٖنی امریٖکی ہسپانوی
      es-ES:یوٗرپی ہسپانوی
      es-MX:میکسیکن ہسپانوی
      et:ایسٹونیَن
      eu:باسک
      ewo:ایوونڈو
      fa:فارسی
      fan:فینگ
      fat:فانٹی
      ff:فُلاہ
      fi:فِنِش
      fil:فِلِپیٖنو
      fj:فِجیَن
      fo:فَروس
      fon:فون
      fr:فرانسیسی
      fr-CA:کَنیڈیَن فرانسیسی
      fr-CH:سٕوٕس فرانسیسی
      frm:وسطی فرینچ
      fro:پرون فرینچ
      frr:شُمٲلی فرِشیَن
      frs:مشرِقی فرِشیَن
      fur:فروٗلِیَن
      fy:مغربی فرِشیَن
      ga:اَیرِش
      gaa:گا
      gay:گیےیو
      gba:گبایا
      gd:سکوٹِش گیےلِک
      gez:گیٖز
      gil:گِلبٔرٹیٖز
      gl:گیلِشِیَن
      gmh:وَسطی ہاے جٔرمَن
      gn:گُوارَنی
      goh:پرون ہاے جٔرمَن
      gon:گوندی
      gor:گورینٹیلو
      got:گوتھِک
      grb:گرِبو
      grc:قدیٖم یوٗنٲنی
      gsw:سٕوِس جٔرمَن
      gu:گُجرٲتی
      gv:مینکس
      gwi:گُوِچ اِن
      ha:ہاوسا
      hai:ہَیدا
      haw:ہوایِیَن
      he:عبرٲنؠ
      hi:ہِندی
      hil:ہِلیٖگینَن
      hit:ہِتایِت
      hmn:ہمونگ
      ho:ہِری موتوٗ
      hr:کروشِیَن
      hsb:ہیرِم ساربِیَن
      ht:ہیتِیاں
      hu:ہَنگیریَن
      hup:ہُپا
      hy:اَرمینیَن
      hz:ہیریٖرو
      ia:اِنٹَرلِنگوا
      iba:اِبان
      id:اِنڈونیشیا
      ie:اِنٹَر لِننگویے
      ig:اِگبو
      ii:سِچوان یٖی
      ik:اِنُپِیاک
      ilo:اِلوکو
      inh:اِنگُش
      io:اِڈو
      is:آیِسلینڈِک
      it:اِطالوی
      iu:اِنُکتِتوٗ
      ja:جاپٲنؠ
      jbo:لوجبان
      jpr:جوڈیو فارسی
      jrb:جوڈیو عربی
      jv:جَوَنیٖز
      ka:جارجِیَن
      kaa:کارا کَلپَک
      kab:کَبایِل
      kac:کاچِن
      kaj:جُوٗ
      kam:کامبا
      kaw:کَوی
      kbd:کَبارڈِیَن
      kcg:تَیَپ
      kfo:کورو
      kg:کونگو
      kha:کھاسی
      kho:کھوتَنیٖز
      ki:کِکُیوٗ
      kj:کُوانیاما
      kk:کازَخ
      kl:کَلالِسُت
      km:خَمیر
      kmb:کِمبُندوٗ
      kn:کَنَڑ
      ko:کوریَن
      kok:کونکَنی
      kos:کوسرییَن
      kpe:کَپیلی
      kr:کَنوٗری
      krc:کراچیے بَلکار
      krl:کَریلِیَن
      kru:کُرُکھ
      ks:کٲشُر
      ku:کُردِش
      kum:کُمِک
      kut:کُتینَے
      kv:کومی
      kw:کورنِش
      ky:کِرگِز
      la:لاتیٖنی
      lad:لیڈِنو
      lah:لَہَندا
      lam:لَمبا
      lb:لُکھزیمبورگِش
      lez:لیزگِیَن
      lg:گاندا
      li:لِمبٔرگِش
      ln:لِنگالا
      lo:لاو
      lol:مونگو
      loz:لوزی
      lt:لِتھوانِیَن
      lu:لوُبا کَتَنگا
      lua:لوٗبا لوٗلُوا
      lui:لویِسینو
      lun:لُندا
      luo:لُوو
      lus:لُسہاے
      lv:لَتوِیَن
      mad:مَدُریٖز
      mag:مَگاے
      mai:میتَھلی
      mak:مَکَسار
      man:مَندِنگو
      mas:مَساے
      mdf:موکشا
      mdr:مَندَر
      men:میندیے
      mg:مَلاگَسی
      mga:وَستی ایرِش
      mh:مارشَلیٖز
      mi:ماوری
      mic:مِکمیک
      min:مِنَنگکَباو
      mk:میکَڈونیَن
      ml:مٔلیالَم
      mn:مَنگولی
      mnc:مانچوٗ
      mni:مَنیپوٗری
      moh:موہاک
      mos:موسی
      mr:مَرٲٹھؠ
      ms:مَلَے
      mt:مَلتیٖس
      mul:واریاہ زبان
      mus:کریٖک
      mwl:مِراندیٖز
      mwr:مارواڑی
      my:بٔمیٖز
      myv:ایرزِیا
      na:ناورُ
      nap:نیٖپالیٹَن
      nb:ناروییَن بوکمال
      nd:شُمال ڈَبیل
      nds:بۆنِم جٔرمَن
      ne:نیپٲلؠ
      new:نیواری
      ng:ڈونگا
      nia:نِیاس
      niu:نِیویَن
      nl:ڈَچ
      nl-BE:فلیمِش
      nn:ناروییَن نَے نورسک
      no:ناروییَن
      nog:نوگاے
      non:پرون نارسی
      nqo:این کو
      nr:جنوب ڈیبیل
      nso:شمالی ستھو
      nv:نَواجو
      nwc:کلاسِکَل نیواری
      ny:نِیَنجا
      nym:نِیَمویزی
      nyn:نِیَنکول
      nyo:نِیورو
      nzi:نَظیٖما
      oc:اوکسیٖٹَن
      oj:اوجِبوا
      om:اۆرومو
      or:اۆرِیا
      os:اۆسیٹِک
      osa:اۆسیج
      ota:اوٹومَن تُرکِش
      pa:پَنجٲبؠ
      pag:پَنگاسِنَن
      pal:پَہلَوی
      pam:پَمپَنگا
      pap:پَپِیامینٹو
      pau:پَلااُواں
      peo:پرون فارسی
      phn:فونیٖشیَن
      pi:پالی
      pl:پالِش
      pon:پانپییَن
      pro:پرون پرووینچَل
      ps:پَشتوٗ
      pt:پُرتَگیٖز
      pt-BR:برازیٖلی پُرتَگیٖز
      pt-PT:یوٗرپی پُرتَگیٖز
      qu:کُویشُوا
      raj:راجِستھٲنؠ
      rap:رَپانوی
      rar:رَروٹونگَن
      rm:رومانش
      rn:رُندی
      ro:رومٲنی
      ro-MD:مولداوِیَن
      rom:رومَنی
      ru:روٗسی
      rup:اَرومانی
      rw:کِنیاوِندا
      sa:سَنسکرٕت
      sad:سَندَویے
      sah:یاکُت
      sam:سَمارِتَن اَرامیک
      sas:سَسَک
      sat:سَنتالی
      sc:سراڈیٖنی
      scn:سِچِلِیَن
      sco:سکاٹس
      sd:سِندی
      se:شُمٲلی سَمی
      sel:سیلکُپ
      sg:سَنگو
      sga:پرون ایرِش
      sh:سیربو کروشِیَن
      shn:شان
      si:سِنہالا
      sid:سِدامو
      sk:سلووَک
      sl:سلووینیَن
      sm:سَمواَن
      sma:جنوٗبی سَمی
      smj:لولیے سَمی
      smn:اِناری سَمی
      sms:سکولٹ سَمی
      sn:شونا
      snk:سونِنکیے
      so:سومٲلی
      sog:سوگڈِیَن
      sq:البانِیَن
      sr:سٔربِیَن
      srn:سرانَن ٹونگو
      srr:سیریر
      ss:سواتی
      st:جنوبی ستھو
      su:سَنڈَنیٖز
      suk:سُکُما
      sus:سُسوٗ
      sux:سُمیریَن
      sv:سویٖڈِش
      sw:سواہِلی
      syr:سیٖریٲیی
      ta:تَمِل
      te:تیلگوٗ
      tem:ٹِمنیے
      ter:ٹیرینو
      tet:ٹیٹَم
      tg:تاجِک
      th:تھاے
      ti:ٹِگرِنیا
      tig:ٹاےگریے
      tiv:تیٖو
      tk:تُرکمین
      tkl:ٹوکیٖلاو
      tl:تَماشیک
      tlh:کِلِنگون
      tli:ٹِلِنگِت
      tmh:تاماشیک
      tn:سوانا
      to:ٹونگا
      tog:نیاسا ٹونگا
      tpi:ٹاک پِسِن
      tr:تُرکِش
      ts:ژونگا
      tsi:ژھِمشِیان
      tt:تَتار
      tum:تُمبُکا
      tvl:تُوالوٗ
      tw:توی
      ty:تاہیشِیَن
      tyv:تُویٖنیَن
      udm:اُدمُرت
      uga:اُگارتِک
      uk:یوٗکرینیٲیی
      umb:یُمبُندوٗ
      und:اَنزٲنؠ یا نَہ لَگہٕہار زبان
      ur:اُردوٗ
      uz:اُزبیک
      vai:واے
      ve:ویندا
      vi:وِیَتنَمیٖز
      vo:وولَپُک
      vot:ووتِک
      wa:وَلوٗن
      wal:والامو
      war:وَریے
      was:واشو
      wo:وولوف
      xal:کالمِک
      xh:کھوسا
      yao:یاو
      yap:یَپیٖز
      yi:یِدِش
      yo:یورُبا
      za:زُہانگ
      zap:زَپوتیک
      zen:زیناگا
      zh:"چیٖنی ﴿ترجمع اِشارٕ: خاص طور، مینڈارن چیٖنی۔﴾"
      zh-alt-menu:چیٖنی، مینڈارن
      zh-Hans:سَہل چیٖنی
      zh-Hans-alt-long:سَہل مینڈارن چیٖنی
      zh-Hant:رِوٲجی چیٖنی
      zh-Hant-alt-long:رِوٲجی مینڈارن چیٖنی
      zu:زُلوٗ
      zun:زوٗنی
      zxx:کانہہ تہِ لِسانیاتی مواد نہٕ
      zza:زازا
      """.trimIndent() }

  val ks_Arab: String? = null

  val ks_Deva: String by lazy { """
      de:जर्मन
      de-AT:आस्ट्रियन जर्मन
      de-CH:स्विस हाई जर्मन
      en:अंगरिज़ी
      en-AU:आसट्रेलवी अंगरिज़ी
      en-CA:कनाडियन अंगरिज़ी
      en-GB:बरतानवी अंगरिज़ी
      en-GB-alt-short:UK अंगरिज़ी
      en-US:अमरीकी अंगरिज़ी
      en-US-alt-short:US अंगरिज़ी
      es:हसपानवी
      es-419:लातिनी अमरीकी हसपानवी
      es-ES:यूरपी हसपानवी
      es-MX:मेकसिकी हसपानवी
      fr:फ्रांसीसी
      fr-CA:कनाडियन फ्रांसीसी
      fr-CH:स्विस फ्रांसीसी
      it:इतालवी
      ja:जापानी
      ks:कॉशुर
      pt:पुरतउगाली
      pt-BR:ब्राज़िली पुरतउगाली
      pt-PT:यूरपी पुरतउगाली
      ru:रूसी
      und:नामोलुम ज़बान
      zh:"चीनी (तरजुम इशार: खास तोर, मैन्डरिन चीनी।)"
      zh-alt-menu:चीनी, मैन्डरिन
      zh-Hans:आसान चीनी
      zh-Hans-alt-long:आसान मैन्डरिन चीनी
      zh-Hant:रिवायाती चीनी
      zh-Hant-alt-long:रिवायाती मैन्डरिन चीनी
      """.trimIndent() }

  val ksb: String by lazy { """
      ak:Kiakan
      am:Kiamhali
      ar:Kialabu
      be:Kibelaausi
      bg:Kibulgalia
      bn:Kibangla
      cs:Kichecki
      de:Kijeumani
      el:Kigiiki
      en:Kiingeeza
      es:Kihispania
      fa:Kiajemi
      fr:Kifalansa
      ha:Kihausa
      hi:Kihindi
      hu:Kihungai
      id:Kiindonesia
      ig:Kiigbo
      it:Kiitaliano
      ja:Kijapani
      jv:Kijava
      km:Kikambodia
      ko:Kikolea
      ksb:Kishambaa
      ms:Kimalesia
      my:Kibulma
      ne:Kinepali
      nl:Kiholanzi
      pa:Kipunjabi
      pl:Kipolandi
      pt:Kileno
      ro:Kiomania
      ru:Kilusi
      rw:Kinyalwanda
      so:Kisomali
      sv:Kiswidi
      ta:Kitamil
      th:Kitailandi
      tr:Kituuki
      uk:Kiuklania
      ur:Kiuldu
      vi:Kivietinamu
      yo:Kiyoluba
      zh:Kichina
      zh-alt-menu:Kichina
      zu:Kizulu
      """.trimIndent() }

  val ksf: String by lazy { """
      ak:riakan
      am:riamarik
      ar:riarab
      be:ribɛlɔrís
      bg:ribulgarí
      bn:ribɛngáli
      cs:ricɛ́k
      de:ridjɛrman
      el:rigrɛ́k
      en:riingɛrís
      es:rikpanyá
      fa:ripɛrsán
      fr:ripɛrɛsǝ́
      ha:rikaksa
      hi:riíndí
      hu:riɔngrɔá
      id:riindonɛsí
      ig:riigbo
      it:riitalyɛ́n
      ja:rijapɔ́ŋ
      jv:rijawanɛ́
      km:rikmɛr
      ko:rikɔrɛɛ́
      ksf:rikpa
      ms:rimalaí
      my:ribirmán
      ne:rinepalɛ́
      nl:riɔlándɛ́
      pa:ripɛnjabí
      pl:ripɔlɔ́n
      pt:ripɔrtugɛ́
      ro:rirɔmán
      ru:rirís
      rw:rirwanda
      so:risomalí
      sv:riswɛ́dǝ
      ta:ritamúl
      th:ritaí
      tr:riturk
      uk:riukrɛ́n
      ur:riurdú
      vi:riwyɛtnám
      yo:riyúuba
      zh:ricinɔá
      zh-alt-menu:ricinɔá
      zu:rizúlu
      """.trimIndent() }

  val ksh: String by lazy { """
      aa:Afahresch
      ab:Abchahsesch
      ace:Aschenehsesch
      ada:Adangmesch
      ady:Adygehjsch
      ae:Avästahnesch
      aeb:Tonehsesch Arahbesch
      af:Afrikaans
      afh:Afrehihlesch
      agq:Aghehmesch
      ain:Aijnu
      ak:Akahnesch
      akk:Akahdesch
      ale:Ale’uhtesch
      am:Amhahresch
      an:Arrajonehsesch
      ang:Ahl Änglesch
      anp:Anjikahnesch
      ar:Arahbesch
      ar-001:Schtandatt Arahbesch
      arp:Arrappaho
      arq:Aljehresch Arahbesch
      ary:Marokahnesch Arahbesch
      arz:Äjiptesch Arahbesch
      as:Aßamehsesch
      asa:Pare
      ase:Amärrekahnesche Blendeschprohch
      ast:Astuhrejahnesch
      av:Avahresch
      awa:Awahdesch
      ay:Aimahresch
      az:Asserbaidschahnesch
      az-alt-short:Asehresch
      az-Arab:Södasserbaidschahnesch
      ba:Baschkihresch
      bal:Beluhtschesch
      ban:Balinehsesch
      bar:Bairesch
      bas:Basaa-Schprohche
      be:Wiißrußesch
      bem:Bemba
      bez:Bena
      bg:Bulljahresch
      bho:Bhohdschpuresch
      bi:Bislahmesch
      bin:Edo
      bm:Bambara
      bn:Bängjahlesch
      bo:Tibehtesch
      bpy:Bischnuprejahnesch
      br:Bettohnesch
      bra:Brahjesch
      brh:Brahuijesch
      brx:Boddo
      bs:Boßnesch
      bua:Burejahtesch
      bug:Bujinehsesch
      byn:Bilihnesch
      ca:Kattalahnesch
      ce:Tschätschehnesch
      ceb:Zebuwahnesch
      cgg:Kihja-Schprohch
      ch:Chamorru
      chk:Trukehsesch
      chm:Mahresch
      cho:Tschoktoh
      chr:Tschärrokeh
      chy:Tschäjänn
      ckb:Zäntrahl-Kurrdesch
      ckb-alt-menu:Zäntrahl-Kurrdesch
      ckb-alt-variant:Zäntrahl-Kurrdesch
      co:Korsesch
      cop:Koptesch
      cs:Tschäschesch
      csb:Kaschuhbesch
      cu:Kerscheßlahwesch
      cv:Tschowaschesch
      cy:Wallihsesch
      da:Dähnesch
      dak:Dakohtesch
      dar:Darjihnesch
      dav:Dawedahnesch
      de:Deutsch
      de-AT:Deutsch uß Öhßterich
      de-CH:Deutsch uß de Schweijz
      dgr:Dohjribesch
      dje:Djerma
      dsb:Niddersorbesch
      dua:Du’ala
      dum:Meddelnehderlängsch
      dv:Divehjesch
      dyo:Jola-Fonyisch
      dz:Butahnesch
      dzg:Dassajahnesch
      ebu:Kîembu
      ee:Ewe
      efi:Äffiksch
      egl:Emilijahnesch
      egy:Ahl Äjiptesch
      eka:Ekajukesch
      el:Jrihschesch
      en:Änglesch
      en-AU:Änglesch uß Außtrahlije
      en-CA:Änglesch uß Kanada
      en-GB:Änglesch uß Jruhßbrettannije
      en-GB-alt-short:Brettesch Änglesch
      en-US:Amärrekahnesch Änglesch
      en-US-alt-short:Änglesch uß de USA
      enm:Meddelänglesch
      eo:Esperanto
      es:Schpahnesch
      es-419:Schpahnesch uß Latting-Ammärrika
      es-ES:Schpahnesch en Schpahneje
      es-MX:Schpahnesch en Mäxikoh
      esu:Zäntrahl-Juppik
      et:Äßnesch
      eu:Baskesch
      ewo:Ewonndo
      fa:Pärsesch
      ff:Fulfulde
      fi:Finnesch
      fil:Fillipihnesch
      fj:Fihdschesch
      fo:Färröhresch
      fon:Fohnesch
      fr:Franzühsesch
      fr-CA:Franzühsesch uß Kanada
      fr-CH:Franzühsesch uß de Schweijz
      fur:Frijauhlesch
      fy:Wäßfrihsesch
      ga:Ihresch
      gaa:Jah
      gez:Ji’is-Ahl-Ättejohpesch
      gil:Jillbättehsesch
      gl:Jallihzesch
      gn:Juwarahnesch
      gor:Jorontalohsch
      gsw:Schwitzerdütsch
      gu:Gutscharatesch
      gv:Mangx
      ha:Haußa
      haw:Hauajahnesch
      he:Hebrähjesch
      hi:Hinndi
      hil:Hiligaynon
      hmn:Hmong
      hr:Krowatesch
      hsb:Bovversorrbesch
      ht:Ha’iihtesch
      hu:Unnjarresch
      hup:Hupa
      hy:Armehnesch
      hz:Herrehro
      ia:de Interlingua
      iba:Ibahnesch
      ibb:Ibibio
      id:Indonehsesch
      ig:Igbo
      ilo:Ilokahnesch
      inh:Engjuschesch
      io:Ihdo
      is:Ißlänndesch
      it:Etalljähnesch
      iu:Inuktitut
      izh:Ingjrijahnesch
      ja:Japahnesch
      jam:Jamaikahnesch-Änglesch
      jbo:Lodschbahn
      jgo:Njomba
      jpr:Jühdesch-Pärsesch
      jut:Jüttesch
      jv:Javahnesch
      ka:Je’orjesch
      kab:Kabyhlesch
      kam:Kamba vun Kehnija
      kbd:Kabadihnesch
      kde:Chimakonde
      kea:Kapvärdesch
      kfo:Koro vun de Älfebeijnköß
      kha:Khasi
      khq:Kojra Tschihni
      ki:Rekohjo
      kj:Oschivambo
      kk:Kassakkesch
      kkj:Kako
      kl:Jröhnländesch
      kln:Kaländjihnesch
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Korrejaanesch
      kok:Kon’kahnesch
      kpe:Kpäle
      kr:Kanuhresch
      krc:Karatschaj-Balkahresch-Törkesch
      krl:Karehlesch
      kru:Korochesch
      ks:Kaschmihresch
      ksf:Bafijahnesch
      ksh:Kölsch
      ku:Kurrdesch
      kum:Kumykesch
      kv:Kohmesch
      kw:Kornesch
      ky:Kirjihsesch
      la:Lateijnesch
      lad:Ladihnesch
      lag:Lango
      lah:de Landa-Schprooche
      lb:Luxemborjesch
      lez:Lesjesch
      lg:Lugannda
      li:Lemburjesch
      lkt:Lakota
      ln:Lingjalla
      lo:Lahootesch
      loz:Silohzi
      lrc:Nood-Luhresch
      lt:Littouesch
      lu:Kiluba
      lua:Tschiluba
      lun:Schilunnda
      luo:Luo
      luy:Luhjesch
      lv:Lättesch
      mdf:Mokschah
      mg:Madajaßkesch
      mh:Maschallehsesch
      mi:Ma’ohresch
      mk:Mazedohnesch
      ml:Mallajalam
      mn:Mongjohlesch
      mni:Meitei-Manipuhresch
      mr:Marrahtesch
      ms:Mallaijesch
      mt:Maltehsesch
      mua:Mundang
      mul:-ongerscheidlijje Schprohche-
      mus:Krihk
      mwl:Mirandehsesch
      my:Burmehsesch
      myv:Ärsjahnesch
      na:Nauruhesch
      nap:Napolletahnesch
      nb:Norrwehjesch Bokmål
      nd:Nood-Ndebele
      nds-NL:Nehdersaksesch en de Nederläng
      ne:Nepallehsesch
      new:Newahresch
      ng:Ndongjahnesch
      nl:Holländesch
      nl-BE:Flähmesch
      nmg:Gyele
      nn:Neu Norrwehjesch
      nnh:Njijembohn
      no:Norrwehjesch
      nog:Nojal
      nso:Nood-Sohto
      nv:Navvacho
      ny:Schi-Schewa
      or:Oriija
      os:Oßeetesch
      pa:Panschaabesch
      pl:Pollnesch
      ps:Paschtuunesch
      pt:Pochtojesesch
      pt-BR:Brasilljaanesch Pochtojesesch
      pt-PT:Pochtojesesch uß Pochtojall
      qu:Kättschowa
      quc:K’ische’
      rm:Rätoromaanesch
      rn:K-Rundesch
      ro:Rumänesch
      rof:Kirombo
      ru:Rußßesch
      rup:Arromahnesch
      rw:Kinja-Ruandesch
      sa:Sanskrit
      sah:Jackutesch
      sba:Njambaij
      sd:Sinndi
      se:Nood-Lappländesch
      ses:Kojraboro Senni
      sg:Sangjo
      sh:Särbokowatesch
      shi:Taschelhittesch
      si:Singjaleesesch
      sk:ẞlovakesch
      sl:ẞloveenesch
      sm:Sammohanesch
      smj:Lule-Läppländesch
      smn:Inahri Lappländesch
      sn:Schi-Schona
      so:Somahlesch
      sq:Albahnesch
      sr:Särbesch
      ss:Si-Swatesch
      st:Söd-Sooto
      su:Sindanehsesch
      sv:Schwehdesch
      sw:Suahehlesch
      swb:Kommohresch
      syr:Sührejakkesch
      ta:Tamihlesch
      te:Telluhju
      tet:Tetumsch
      tg:Tadschihkesch
      th:Tailändesch
      ti:Tijrenejahnesch
      tig:Tigre
      tk:Törkmehnesch
      tl:Tajalloch
      tlh:Klingjohnesch
      tn:Se-Zwahnesch
      to:Tongjahnesch
      tpi:Tok Pisin
      tr:Törkesch
      ts:Xi-Zongjahnesch
      tt:Tattahresch
      twq:Tasawaq
      ty:Tahihtesch
      tyv:Tuvinijahnesch
      tzm:Tamasicht ussem meddlere Atlas
      udm:Udmuchtesch
      ug:Uj’juhresch
      uk:Ukrainesch
      umb:Umbundesch
      und:-onbikannte-Schprooch-
      ur:Urdu/Hindi
      uz:Ußbehkesch
      ve:Wenda
      vi:Vijätnammehsesch
      vo:Volapük
      wa:Walohnesch
      wae:Walserdütsch
      wal:Welahmo
      war:Waray-Waray
      wo:Woloff
      xal:Kalmükkesch
      xh:Isi-Khohsa
      ybb:Jämmbah
      yi:Jiddesch
      yo:Joruhba
      yue:Kanton-Schinehsesch
      yue-alt-menu:Kanton-Schinehsesch
      zh:Schinehsesch (Mandarin)
      zh-alt-menu:Schinehsesch (Mandarin)
      zh-Hans:Schinehsesch (eijfache Schreff)
      zh-Hans-alt-long:Schinehsesch (eijfache Schreff)
      zh-Hant:Schinehsesch (tradizjonälle Schreff)
      zh-Hant-alt-long:Schinehsesch (tradizjonälle Schreff)
      zu:Suhlu
      zun:Suhñi
      zxx:kein Schprooch
      zza:Sahsajesch
      """.trimIndent() }

  val ku: String by lazy { """
      aa:afarî
      ab:abxazî
      ace:açehî
      ada:adangmeyî
      ady:adîgeyî
      af:afrîkansî
      agq:aghemî
      ain:aynuyî
      ak:akanî
      ale:alêwîtî
      alt:altayîya başûrî
      am:amharî
      an:aragonî
      ann:obolo
      anp:angîkayî
      apc:erebîya bakurê şamê
      ar:erebî
      ar-001:erebîya modern a standard
      arn:mapuçî
      arp:arapahoyî
      ars:erebîya necdî
      as:asamî
      asa:asûyî
      ast:astûrî
      atj:atîkamekî
      av:avarî
      awa:awadhî
      ay:aymarayî
      az:azerî
      az-alt-short:azerî
      ba:başkîrî
      bal:belûcî
      ban:balînî
      bas:basayî
      be:belarûsî
      bem:bembayî
      bew:betawî
      bez:benayî
      bg:bulgarî
      bgc:haryanvîyî
      bgn:belucîya rojavayî
      bho:bojpûrî
      bi:bîslamayî
      bin:bînîyî
      bla:blakfotî
      blo:bloyî
      blt:tay dam
      bm:bambarayî
      bn:bengalî
      bo:tîbetî
      br:bretonî
      brx:bodoyî
      bs:bosnî
      bss:akooseyî
      bug:bugî
      byn:blînî
      ca:katalanî
      cad:kadoyî
      cay:kayugayî
      cch:atsamî
      ccp:çakmayî
      ce:çeçenî
      ceb:sebwanoyî
      cgg:kîgayî
      ch:çamoroyî
      chk:çûkî
      chm:marî
      cho:çoktavî
      chp:çîpevyayî
      chr:çerokî
      chy:çeyenî
      cic:çîkasawî
      ckb:kurdî (soranî)
      ckb-alt-menu:kurdî (navîn)
      ckb-alt-variant:kurdî (soranî)
      clc:çilkotînî
      co:korsîkayî
      crg:mîçîfî
      crj:krîya rojhilat ya başûrî
      crk:kriya bejayî
      crl:krîya rojhilat ya bakurî
      crm:krîya mûsî
      crr:zimanê karolina algonquianî
      cs:çekî
      csw:krîya swampî
      cu:slavîya kenîseyî
      cv:çuvaşî
      cy:weylsî
      da:danmarkî
      dak:dakotayî
      dar:dargînî
      dav:tayîtayî
      de:almanî
      dgr:dogrîbî
      dje:zarma
      doi:dogrîyî
      dsb:sorbîya jêrîn
      dua:diwalayî
      dv:divehî
      dyo:jola-fonyi
      dz:conxayî
      dzg:dazagayî
      ebu:embuyî
      ee:eweyî
      efi:efîkî
      eka:ekajukî
      el:yûnanî
      en:îngilîzî
      en-GB:îngilîzî (Qiralîyeta Yekbûyî)
      en-GB-alt-short:îngilîzî (QY)
      eo:esperantoyî
      es:spanî
      es-ES:spanî (Ewropa)
      et:estonî
      eu:baskî
      ewo:ewondoyî
      fa:farisî
      fa-AF:derî
      ff:fulahî
      fi:fînî
      fil:fîlîpînoyî
      fj:fîjî
      fo:ferî
      fon:fonî
      fr:fransizî
      fr-CA:fransizî (Kanada)
      fr-CH:fransizî (Swîsre)
      frc:fransizîya kajûnê
      frr:frîsîya bakur
      fur:frîyolî
      fy:frîsî
      ga:îrlendî
      gaa:gayî
      gd:gaelîka skotî
      gez:geez
      gil:kîrîbatî
      gl:galîsî
      gn:guwaranî
      gor:gorontaloyî
      gsw:elmanîşî
      gu:gujaratî
      guz:gusîî
      gv:manksî
      gwi:gwichʼin
      ha:hawsayî
      hai:haydayî
      haw:hawayî
      hax:haîdaya başûrî
      he:îbranî
      hi:hindî
      hi-Latn-alt-variant:hîngilîzî
      hil:hîlîgaynonî
      hmn:hmongî
      hnj:hmongîya njuayî
      hr:xirwatî
      hsb:sorbîya jorîn
      ht:haîtî
      hu:mecarî
      hup:hupayî
      hur:halkomelemî
      hy:ermenî
      hz:hereroyî
      ia:înterlîngua
      iba:iban
      ibb:îbîbîoyî
      id:endonezyayî
      ie:înterlîngue
      ig:îgboyî
      ii:yîyîya siçuwayî
      ikt:inuvialuktun
      ilo:îlokanoyî
      inh:îngûşî
      io:îdoyî
      is:îzlendî
      it:îtalî
      iu:înuîtî
      ja:japonî
      jbo:lojbanî
      jgo:ngomba
      jmc:machame
      jv:javayî
      ka:gurcî
      kaa:kara-kalpakî
      kab:kabîlî
      kac:cingphoyî
      kaj:jju
      kam:kambayî
      kbd:kabardî
      kcg:tyap
      kde:makondeyî
      kea:kapverdî
      ken:kenyangî
      kfo:koro
      kgp:kayingangî
      kha:khasi
      khq:koyra chiini
      ki:kîkûyûyî
      kj:kwanyamayî
      kk:qazaxî
      kkj:kako
      kl:kalalîsûtî
      kln:kalencînî
      km:ximêrî
      kmb:kîmbunduyî
      kn:kannadayî
      ko:koreyî
      kok:konkanî
      kpe:kpelleyî
      kr:kanurîyî
      krc:karaçay-balkarî
      krl:karelî
      kru:kurukh
      ks:keşmîrî
      ksb:shambala
      ksf:bafyayî
      ksh:rîpwarî
      ku:kurdî (kurmancî)
      kum:kumikî
      kv:komî
      kw:kornî
      kwk:kwak’walayî
      kxv:kuvî
      ky:kirgizî
      la:latînî
      lad:ladînoyî
      lag:langî
      lb:luksembûrgî
      lez:lezgînî
      lg:lugandayî
      li:lîmbûrgî
      lij:lîgûrî
      lil:lillooet
      lkt:lakotayî
      lmo:lombardî
      ln:lingalayî
      lo:lawsî
      lou:kreyolîya louisianayê
      loz:lozî
      lrc:lurîya bakur
      lsm:saamia
      lt:lîtwanî
      ltg:latgalî
      lu:luba-katangayî
      lua:luba-kasayî
      lun:lunda
      luo:luoyî
      lus:mizoyî
      luy:luhyayî
      lv:latvîyayî
      mad:madurayî
      mag:magahî
      mai:maithili
      mak:makasarî
      mas:masayî
      mdf:mokşayî
      men:mende
      mer:meruyî
      mfe:morisyenî
      mg:malagasî
      mgh:makhuwa-meetto
      mgo:meta’
      mh:marşalî
      mi:maorî
      mic:mîkmakî
      min:mînangkabawî
      mk:makedonî
      ml:malayalamî
      mn:moxolî
      mni:manipuri
      moe:înûyîya rojhilatî
      moh:mohawkî
      mos:moreyî
      mr:maratî
      ms:malezî
      mt:maltayî
      mua:mundangî
      mul:pirzimanî
      mus:krîkî
      mwl:mîrandî
      my:burmayî
      myv:erzayî
      mzn:mazenderanî
      na:nawrûyî
      nap:napolîtanî
      naq:namayî
      nb:norwecî (bokmål)
      nd:ndebelîya bakurî
      nds:nedersaksî
      ne:nepalî
      new:newarî
      ng:ndongayî
      nia:nîasî
      niu:nîwî
      nl:holendî
      nl-BE:flamî
      nmg:kwasio
      nn:norwecî (nynorsk)
      nnh:ngiemboon
      no:norwecî
      nog:nogayî
      nqo:n’Ko
      nr:ndebelîya başûrî
      nso:sotoyîya bakur
      nus:nuer
      nv:navajoyî
      ny:çîçewayî
      nyn:nyankole
      oc:oksîtanî
      ojb:ojibweyîya bakurî
      ojc:ojibwayîya navîn
      ojs:oji-cree
      ojw:ojîbweyîya rojavayî
      oka:okanagan
      om:oromoyî
      or:oriyayî
      os:osetî
      osa:osageyî
      pa:puncabî
      pag:pangasînanî
      pam:kapampanganî
      pap:papyamentoyî
      pau:palawî
      pcm:pîdgînîya nîjeryayî
      pis:pijînî
      pl:polonî
      pqm:malecite-passamaquoddy
      prg:prûsyayî
      ps:peştûyî
      pt:portugalî
      pt-PT:portugalî (Ewropa)
      qu:keçwayî
      quc:k’iche’
      raj:rajasthanî
      rap:rapanuyî
      rar:rarotongî
      rhg:rohingyayî
      rif:tarifit
      rm:romancî
      rn:rundî
      ro:romanî
      rof:rombo
      ru:rûsî
      rup:aromanî
      rw:kînyariwandayî
      rwk:rwa
      sa:sanskrîtî
      sad:sandawe
      sah:yakutî
      saq:samburuyî
      sat:santalî
      sba:ngambay
      sbp:sanguyî
      sc:sardînî
      scn:sicîlî
      sco:skotî
      sd:sindhî
      sdh:kurdîya başûrî
      se:samîya bakur
      seh:sena
      ses:sonxayî
      sg:sangoyî
      shi:taşelhîtî
      shn:şanî
      si:kîngalî
      sid:sîdamo
      sk:slovakî
      skr:seraîkî
      sl:slovenî
      slh:lushootseeda başûrî
      sm:samoayî
      sma:samîya başûr
      smj:samiya lule
      smn:samîya înarî
      sms:samîya skoltî
      sn:şonayî
      snk:soninke
      so:somalî
      sq:arnawidî
      sr:sirbî
      srn:sirananî
      ss:swazî
      ssy:sahoyî
      st:sotoyîya başûr
      str:saanîçî
      su:sundanî
      suk:sukuma
      sv:swêdî
      sw:swahîlî
      sw-CD:swahîlîya kongoyî
      swb:komorî
      syr:siryanî
      szl:silesî
      ta:tamîlî
      tce:totuçena başûrî
      te:telûgûyî
      tem:temne
      teo:teso
      tet:tetûmî
      tg:tacikî
      tgx:tagîşî
      th:tayî
      tht:tahltan
      ti:tigrînî
      tig:tigre
      tk:tirkmenî
      tlh:klîngonî
      tli:tlingit
      tn:tswanayî
      to:tongî
      tok:toki pona
      tpi:tokpisinî
      tr:tirkî
      trv:tarokoyî
      trw:torwalî
      ts:tsongayî
      tt:teterî
      ttm:tutoçenîya bakur
      tum:tumbukayî
      tvl:tuvalûyî
      twq:tasawaq
      ty:tahîtî
      tyv:tuvanî
      tzm:temazîxtî
      udm:udmurtî
      ug:oygurî
      uk:ukraynî
      umb:umbunduyî
      und:zimanê nenas
      ur:urdûyî
      uz:ozbekî
      vec:venîsî
      vi:vîetnamî
      vmw:makhuwayî
      vo:volapûkî
      vun:vunjo
      wa:walonî
      wae:walserî
      wal:wolaytta
      war:warayî
      wbp:warlpiri
      wo:wolofî
      wuu:çînîya wuyî
      xal:kalmîkî
      xh:xosayî
      xnr:kangrî
      xog:sogayî
      yav:yangben
      ybb:yemba
      yi:yidîşî
      yo:yorubayî
      yrl:nhêngatûyî
      yue:kantonî
      yue-alt-menu:çînî, kantonî
      za:zhuangî
      zgh:amazîxîya fasî
      zh:çînî
      zh-alt-menu:çînî, mandarînî
      zh-Hans:çînîya sadekirî
      zh-Hans-alt-long:çînîya mandarînî ya sadekirî
      zh-Hant:çînîya kevneşopî
      zh-Hant-alt-long:çînîya mandarînî ya kevneşopî
      zu:zuluyî
      zun:zunîyî
      zxx:bê naveroka zimanî
      zza:zazakî (kirdkî, kirmanckî)
      """.trimIndent() }

  val kw: String by lazy { """
      kw:kernewek
      """.trimIndent() }

  val kxv: String by lazy { """
      af:aprikaans
      am:aarmenia
      ar:arabic
      ar-001:punijuga mānānka arabic
      as:aasamis
      az:ajerbaijani
      az-alt-short:ājeri
      be:belarusiati
      bg:bulgeriati
      bn:bangali
      bo:tibetī
      brx:boḍo
      bs:bajniati
      ca:keṭelan
      chr:cerokī
      cs:cek
      da:denis
      de:jerman
      de-AT:ausṭriati jerman
      de-CH:svis high jerman
      doi:ḍogri
      el:grīk
      en:ingrajī
      en-AU:ausṭreliati ingarjī
      en-CA:kanaḍati ingarjī
      en-GB:briṭisti ingrajī
      en-GB-alt-short:juktarajyati ingrajī
      en-US:amerikati ingrajī
      en-US-alt-short:juktarasṭrati ingrajī
      es:spenis
      es-419:laṭin americati spenis
      es-ES:yuropīyati spenis
      es-MX:meksikoti spenis
      et:esṭoniyati
      eu:bask
      fa:persiati
      fa-AF:ḍari
      fi:pinnis
      fil:pilipino
      fr:prenc
      fr-CA:kanaḍati prenc
      fr-CH:svis prenc
      gl:galesiati
      gu:gujraṭī
      he:hibru
      hi-Latn:hindi
      hi-Latn-alt-variant:hindi
      hr:kroesiati
      hu:hngeriyati
      hy:aarmeniati
      id:inḍonesiyati
      is:aislanḍik
      it:iṭaliti
      ja:japanij
      ka:jorjiati
      kk:kjaak
      km:kmer
      kn:knnaḍa
      ko:koriati
      kok:konkanī
      ks:kasmīrī
      kxv:kuvi
      ky:kyrgyj
      lo:lao
      lt:lituaniyati
      lv:laṭviati
      mai:maitilī
      mk:mesiḍoniyati
      ml:malyalam
      mn:mongoliyati
      mni:maṇipurī
      mr:maraṭi
      ms:malei
      my:burmij
      nb:norvejiati būkmal
      ne:nepaḷī
      nl:ḍc
      nl-BE:vlaams
      or:oḍiaa
      pa:pnjabī
      pl:polis
      pt:portugīj
      pt-BR:brajilian portugīj
      pt-PT:yuropīyati portugīj
      ro:romaniyati
      ro-MD:molḍaviati
      ru:rusiyati
      sa:sanskrit
      sat:santalī
      sd:sindi
      si:sinhali
      sk:slovak
      sl:sloveniyati
      sq:albaniyati
      sr:sarbiyati
      sv:sviḍis
      sw:svahili
      sw-CD:kongo svahili
      ta:tamiḷ
      te:telugu
      th:tae
      tr:turkis
      uk:yukraniyati
      ur:urdu
      uz:ujbek
      vi:vietnaamti
      xnr:kangri
      zh:cainati
      zh-alt-menu:cainati, manḍarin
      zh-Hans:sahaj cainati
      zh-Hans-alt-long:sahaj manḍarin cainati
      zh-Hant:hirudlu cainati
      zh-Hant-alt-long:hirudlu manḍarin cainati
      zu:julu
      """.trimIndent() }

  val kxv_Deva: String by lazy { """
      af:आप्रिकान्स
      am:अम्हेरी
      ar:आरॉबिक
      ar-001:पुनिजुगो मानांकॉ आरॉबिक
      as:आसामीस्
      az:अज़रबेजानी
      az-alt-short:अज़ेरी
      be:बेलारूसी
      bg:बुल्गारियाति
      bn:बंगाली
      bo:तिब्बती
      brx:बोडो
      bs:बाॅस्नियाती
      ca:कातालान
      chr:चेरोकी
      cs:चेक
      da:डेनिस
      de:जर्मन
      de-AT:ऑस्ट्रियाति जर्मन
      de-CH:स्विस हाइ ति जर्मन
      doi:डोगरी
      el:ग्रीक
      en:इंराजी
      en-AU:ऑस्ट्रेलियाति इंराजी
      en-CA:कनाडाति इंराजी
      en-GB:ब्रिटिस इंराजी
      en-GB-alt-short:यू॰के॰ राज्यॉ ति इंराजी
      en-US:अमेरिकी इंराजी
      en-US-alt-short:अमेरिकी इंराजी
      es:स्पानिस
      es-419:लातिन आमेरिका ति स्पेनिस
      es-ES:यूरोपीय ति स्पेनिस
      es-MX:मेक्सिको ति स्पेनिस
      et:एस्टोनियाति
      eu:बास्क
      fa:पर्सियन
      fa-AF:डॉरि
      fi:प़िनिस
      fil:प़िलिपीनो
      fr:प़्रेंच
      fr-CA:कनाडाति प़्रेंच
      fr-CH:स्विस प़्रेंच
      gl:ग्यालिसियन
      gu:गुजराटी
      he:हिब्रू
      hi:हिन्दी
      hi-Latn:हिन्दी (लातिन)
      hi-Latn-alt-variant:हिन्दी (लातिन)
      hr:क्रोएसियाति
      hu:हंगेरियाति
      hy:आर्मेनियाति
      id:इंडोनेसियाति
      is:आइसलेंड िक
      it:इताली ती
      ja:जापानीज
      ka:जॉर्जियाति
      kk:कज़ाक़
      km:कमेर
      kn:कन्नड़
      ko:कोरियाति
      kok:कोंकणी
      ks:कस्मीरी
      kxv:कुवि
      ky:किर्गीज़
      lo:लाओ
      lt:लितुआनियाति
      lv:लातवियाति
      mai:मेतिली
      mk:मकदूनियाति
      ml:मलयालम
      mn:मंगोलियाति
      mni:मणिपुरी
      mr:मराठी
      ms:मलय
      my:बर्मीज़
      nb:नॉर्वेजियाति बोकमाल
      ne:नेपाली
      nl:डच
      nl-BE:प़्लेमिस
      or:उड़िया
      pa:पंजाबी
      pl:पोलिस
      pt:पुर्तगाली
      pt-BR:ब्राज़ीली पुर्तगाली
      pt-PT:यूरोपीय पुर्तगाली
      ro:रोमानियाति
      ro-MD:मोलडावियन
      ru:रुसिया ति
      sa:संस्कृत
      sat:संताली
      sd:सिंधी
      si:सिंहली
      sk:स्लोवाक
      sl:स्लोवेनियाति
      sq:अल्बानियाति
      sr:सर्बियाति
      sv:स्वीडिस
      sw:स्वाहिली
      sw-CD:कांगो स्वाहिली
      ta:तमिल
      te:तेलुगू
      th:ताई
      tr:तुर्की
      uk:यूक्रेनियाति
      ur:उर्दू
      uz:उज़्बेक
      vi:वियतनामी
      zh:चीनी
      zh-alt-menu:चीनी, मेंडेरिन
      zh-Hans:साॅहाॅजाॅ चीनी
      zh-Hans-alt-long:साॅहाॅजाॅ मेंडेरिन चीनी
      zh-Hant:हिरूदोल्लु चीनी
      zh-Hant-alt-long:हिरूदोल्लु मेंडेरिन चीनी
      zu:ज़ुलू
      """.trimIndent() }

  val kxv_Latn: String? = null

  val kxv_Orya: String by lazy { """
      af:ଆପ୍ରୀକାନ୍‍ସ
      am:ଆମ୍‍ହେରି
      ar:ଆରବିକ
      ar-001:ପୁନି ଜୁଗ ମାନାଙ୍କ ଆରବିକ୍
      as:ଆସାମିଜ୍
      az:ଆଜେରବେଇଜାନି
      az-alt-short:ଅଜେରି
      be:ବେଲାରୁଷିଆନ୍
      bg:ବୁଲଗାରିଆନ୍
      bn:ବଙ୍ଗାଲି
      bo:ତିବତି
      brx:ବଡ
      bs:ବସନିଆନ୍
      ca:କାଟଲାନ୍
      chr:ଚେରକୀ
      cs:ଚେକ୍
      da:ଡେନିସ୍
      de:ଜର୍ମାନ୍
      de-AT:ଅଷ୍ଟ୍ରିଆ ତି ଜର୍ମାନ
      de-CH:ସ୍ୱିସ୍‌ ହାଇ ତି ଜର୍ମାନ
      doi:ଡଗ୍ରୀ
      el:ଗ୍ରୀକ୍
      en:ଇଂରାଜୀ
      en-AU:ଅଷ୍ଟ୍ରେଲିୟାତି ଇଂରାଜୀ
      en-CA:କାନାଡିୟାତି ଇଂରାଜୀ
      en-GB:ବ୍ରିଟିଶ୍‌ତି ଇଂରାଜୀ
      en-GB-alt-short:ଯୁକ୍ତରାଜ୍ୟତି ଇଂରାଜୀ
      en-US:ଆମେରିକାତି ଇଂରାଜୀ
      en-US-alt-short:ଯୁକ୍ତରାଷ୍ଟ୍ରତି ଇଂରାଜୀ
      es:ସ୍ପାନିସ୍
      es-419:ଲାଟିନ୍‌ ଆମେରିକା ତି ସ୍ପେନିସ୍
      es-ES:ୟୁରପୀୟାତି ସ୍ପେନିସ୍‌
      es-MX:ମେକ୍ସିକତି ସ୍ପେନିସ୍‌
      et:ଏସ୍ଟନିଆ
      eu:ବାସ୍କ
      fa:ପର୍ସିୟାନ୍
      fa-AF:ଡରି
      fi:ପିନିସ୍
      fil:ପିଲିପିନ
      fr:ପ୍ରେଞ୍ଚ‍
      fr-CA:କାନାଡାତି ପ୍ରେଞ୍ଚ‍
      fr-CH:ସ୍ୱିସ୍ ପ୍ରେଞ୍ଚ‍
      gl:ଗଲସିଆତି
      gu:ଗୁଜୁରାଟି
      he:ହିବ୍ରୁ
      hi:ହିନ୍ଦି
      hr:କ୍ରଏସିଆତି
      hu:ହଙ୍ଗେରୀୟାତି
      hy:ଆର୍ମେନିଆତି
      id:ଇଣ୍ଡନେସୀୟା ତି
      is:ଆଇସଲାଣ୍ଡିକ୍
      it:ଇଟାଲି ତି
      ja:ଜାପାନିଜ୍
      ka:ଜର୍ଜିୟାତି
      kk:କାଜାକ୍
      km:କାମେର୍
      kn:କାନ୍ନାଡ଼ା
      ko:କରିଆନ୍ ତି
      kok:କଂଙ୍କଣି
      ks:କାସ୍ମିର
      kxv:କୁୱି
      ky:କୀରଗୀଜ୍
      lo:ଲାଅ
      lt:ଲିଥୁଆନିଆତି
      lv:ଲାଟବିଆତି
      mai:ମଇତିଲୀ
      mk:ମାସେଡୋନିଆ ତି
      ml:ମାଲାୟଲମ୍
      mn:ମଙ୍ଗଲିୟ ତି
      mni:ମଣିପୁରୀ
      mr:ମରାଟୀ
      ms:ମଲୟ
      my:ବର୍ମୀଜ୍
      nb:ନରୱେଜିଆନ୍ ବୋକମଲ୍
      ne:ନେପାଳୀ
      nl:ଡଚ୍
      nl-BE:ପେ୍ଲମିସ୍
      or:ଅଡ଼ିଆ
      pa:ପଞ୍ଜାବୀ
      pl:ପଲିସ୍
      pt:ପର୍ତୁଗୀଜ୍‌
      pt-BR:ବ୍ରାଜିଲିଆନ୍ ପର୍ତୁଗୀଜ୍
      pt-PT:ୟୁରପ୍ ତି ପର୍ତୁଗୀଜ୍
      ro:ରମାନିଆ ତି
      ro-MD:ମଲଡୋଭିଆନ୍ ତି
      ru:ରୁଷିଆ ତି
      sa:ସଂସ୍କୃତ
      sat:ସାନ୍ତାଲି
      sd:ସିନ୍ଦୀ
      si:ସିଂହଲା
      sk:ସ୍ଲବାକ୍
      sl:ସ୍ଲବେନିଆ ତି
      sq:ଆଲବାନିଆନ୍ ତି
      sr:ସର୍ବିୟ ତି
      sv:ସ୍ୱିଡିସ୍
      sw:ସ୍ୱାହିଲି
      sw-CD:କଙ୍ଗ ସ୍ୱାହିଲି
      ta:ତାମିଲ୍
      te:ତେଲୁଗୁ
      th:ତାଇ
      tr:ତୁର୍କିସ୍
      uk:ୟୁକ୍ରାନିଆତି
      ur:ଉର୍ଦୁ
      uz:ଉଜବେକ୍
      vi:ୱିଏତନାମ ତି
      zh:ଚାଇନା ତି
      zh-alt-menu:ଚାଇନା ତି, ମାଣ୍ଡାରିନ୍
      zh-Hans:ସହଜ ଚୀନ
      zh-Hans-alt-long:ସହଜ ମାଣ୍ଡାରିନ୍ ଚାଇନିଜ୍
      zh-Hant:ହିରୁଦଲୁ ଚାଇନିଜ୍‌
      zh-Hant-alt-long:ହିରୁଦଲୁ ମାଣ୍ଡାରିନ୍ ଚାଇନିଜ୍
      zu:ଜୁଲୁ
      """.trimIndent() }

  val kxv_Telu: String by lazy { """
      af:ఆప్రికాన్స్
      am:ఆమ్హెరి
      ar:ఆరబిక్
      ar-001:అదునిక ప్రామాణిక్ అరబిక్
      as:ఆసమీజ్
      az:అజరబైజాని
      az-alt-short:ఆజెరి
      be:బెలారుసియన్
      bg:బుల్గారియన్
      bn:బంగ్లా
      bo:తిబ్బతన్
      brx:బొడొ
      bs:బొస్ నిఆన్
      ca:కాటాలాన్
      chr:చెరొకీ
      cs:చెక్
      da:డెనిస్
      de:జర్మన్
      de-AT:అస్ట్రీయన్ జర్మన్
      de-CH:స్విస్ హఇ జర్మన్
      doi:డోగ్రి
      el:గ్రిక్
      en:ఇంగ్లిస్
      en-AU:అస్ట్రె లియన్ ఇంగ్లిస్
      en-CA:కనెడయన్ ఇంగ్లిస్
      en-GB:బ్రిటిస్ ఇంగ్లిస్
      en-GB-alt-short:యు.కె. ఇంగ్లిస్
      en-US:అమెరికాన్ ఇంగ్లిస్
      en-US-alt-short:యు.ఎస్. ఇంగ్లిస్
      es:స్పెనిస్
      es-419:లాటిన్ అమెరికన్ స్పెనిస్
      es-ES:యురోపియన్ స్పెనిస్
      es-MX:మెక్సికాన్ స్పాస్పెనిస్
      et:ఎస్టొ నియన్
      eu:బాస్క్
      fa:పర్సియన్
      fa-AF:డారి
      fi:పినిస్
      fil:పిలిపినో
      fr:ప్రెంచ్
      fr-CA:కానడియెన్ ప్రేంచ్
      fr-CH:స్విస్ ప్రెంచ్
      gl:గాలసియన్
      gu:గుజరాటి
      he:హిబ్రూ
      hi:హిందీ
      hr:క్రొయేసియన్
      hu:హంగేరియన్
      hy:అర్మేనియన్
      id:ఇండోనేసియన్
      is:అఇస్లెండిక్
      it:ఇటాలియన్
      ja:జపనిస్
      ka:జర్జియన్
      kk:కజక్
      km:కమెర్
      kn:కన్నడ
      ko:కొరియన్
      kok:కొంకణి
      ks:కాస్మిరి
      kxv:కువి
      ky:కిర్గజ్
      lo:లావో
      lt:లితువేనియన్
      lv:లాట్వియన్
      mai:మైతలి
      mk:మాసిడోనియన్
      ml:మలయాలం
      mn:మగోంలియన్
      mni:మణిపురి
      mr:మరాటి
      ms:మలయ్
      my:బర్మీస్
      nb:సార్వేజియన్ బొకమల్
      ne:సేపాలి
      nl:డచ్
      nl-BE:ప్లెమిస్
      or:ఒడియా
      pa:పంజాబి
      pl:పోలిస్
      pt:పోర్తుగీస్
      pt-BR:బ్రెజిలియన్ పోర్తుగీస్
      pt-PT:యురోపియన్ పోర్తుగిస్
      ro:రోమేనియన్
      ro-MD:మెల్డావియన్
      ru:రస్వన్
      sa:సంస్కృతం
      sat:సంతాలి
      sd:సిందీ
      si:సింహళం
      sk:స్లోవక్
      sl:స్లోవేనియన్
      sq:అల్బేనియన్
      sr:సెర్బియన్
      sv:స్విడిస్
      sw:స్వాహిలి
      sw-CD:కాగోం స్వాహిలి
      ta:తమిళము
      te:తెలుగు
      th:తాఇ
      tr:టర్కిస్
      uk:యుక్రెయనియన్
      ur:ఉర్దూ
      uz:ఉజ్బెక్
      vi:వియత్నామీస్
      zh:చైనీస్
      zh-alt-menu:చైనీస్, మాండరిన్
      zh-Hans:సరళీకృత చైనీస్
      zh-Hans-alt-long:సరళీకృత మాండరిన్ చైనీస్
      zh-Hant:సాంప్రదాయక చైనీస్
      zh-Hant-alt-long:సాంప్రదాయకా మాండరిన్ చైనీస్
      zu:జాలూ
      """.trimIndent() }

  val ky: String by lazy { """
      aa:афарча
      ab:абхазча
      ace:ачехче
      ada:адаңмече
      ady:адыгейче
      af:африкаанча
      agq:агемче
      ain:айнуча
      ak:аканча
      ale:алеутча
      alt:түштүк алтайча
      am:амхарча
      an:арагончо
      ann:оболочо (Нигерия)
      anp:ангикача
      ar:арабча
      ar-001:азыркы адабий араб тилинде
      arn:мапучече
      arp:арапахочо
      ars:арабча (нежди диалекти)
      as:ассамча
      asa:асуча
      ast:астурийче
      atj:атикамекче
      av:аварикче
      awa:авадхиче
      ay:аймарача
      az:азербайжанча
      az-alt-short:азерче
      ba:башкырча
      ban:баличе
      bas:басаача
      be:беларусча
      bem:бембача
      bez:бенача
      bg:болгарча
      bgc:харьянвиче
      bgn:чыгыш балучиче
      bho:бхожпуриче
      bi:бисламача
      bin:биниче
      bla:сиксикача
      blo:анииче
      bm:бамбарача
      bn:бангладешче
      bo:тибетче
      br:бретончо
      brx:бодочо
      bs:боснийче
      bug:бугийче
      byn:блинче
      ca:каталончо
      cay:каюгиче
      ccp:чакма
      ce:чеченче
      ceb:себуанча
      cgg:чигача
      ch:чаморрочо
      chk:чуукиче
      chm:мариче
      cho:чокточо
      chp:чипевайанча
      chr:черокиче
      chy:шайеннче
      ckb:борбордук курдча
      ckb-alt-menu:борбордук курдча
      ckb-alt-variant:борбордук курдча
      clc:чилкотинче (британдык колумбиядагы аймак)
      co:корсиканча
      crg:мичифче (индей тили)
      crj:түштүк-чыгыш криче (индей тили)
      crk:өрөөндүк криче (индей тили)
      crl:чыгыш криче (индей тилдери)
      crm:муус криче (индей тили)
      crr:каролиналык алгонкинче
      crs:сеселва креол французча
      cs:чехче
      csw:суампи криче (индей тили)
      cu:чиркөө славянча
      cv:чувашча
      cy:уелшче
      da:датча
      dak:дакотача
      dar:даргинче
      dav:таитача
      de:немисче
      de-CH:адабий немисче (Швейцария)
      dgr:догрибче
      dje:зармача
      doi:догриче
      dsb:төмөнкү сорбианча
      dua:дуалача
      dv:дивехиче
      dyo:жола-фониче
      dz:жонгуча
      dzg:дазагача
      ebu:эмбуча
      ee:эбече
      efi:эфикче
      eka:экажукча
      el:грекче
      en:англисче
      en-US:англисче (Америка Кошмо Штаттары)
      en-US-alt-short:англисче (АКШ)
      eo:эсперанто
      es:испанча
      es-ES:испанча (Европа)
      et:эстончо
      eu:баскча
      ewo:эвондочо
      fa:фарсча
      fa-AF:дари
      ff:фулача
      fi:финче
      fil:филипинче
      fj:фижиче
      fo:фарерче
      fon:фончо
      fr:французча
      frc:французча (кажун диалектиси)
      frr:түндүк фризче (евразиялык тилдер)
      fur:фриулча
      fy:батыш фризче
      ga:ирландча
      gaa:гача
      gag:гагаузча
      gan:Гань Кытайча
      gd:шотладиялык гелча
      gez:гиизче
      gil:гилбертче
      gl:галисияча
      gn:гуараниче
      gor:горонталочо
      gsw:немисче (Швейцария)
      gu:гужаратча
      guz:гусиче
      gv:мэнксыча
      gwi:гвичинче
      ha:хаусача
      hai:хайдача
      hak:Хакка кытайча
      haw:гавайча
      hax:хайдача (индей тили)
      he:ивритче
      hi:хиндиче
      hi-Latn-alt-variant:хинглиш (англис тили + хинди)
      hil:хилигайнончо
      hmn:хмонгчо
      hr:хорватча
      hsb:жогорку сорбианча
      hsn:Сянь Кытайча
      ht:гаитиче
      hu:венгерче
      hup:хупача
      hur:халкомелемче (индей тили)
      hy:армянча
      hz:герерочо
      ia:интерлингва
      iba:ибанча
      ibb:ибибиочо
      id:индонезияча
      ie:интерлинг
      ig:игбочо
      ii:сычуань йиче
      ikt:инуктитутча (Канада)
      ilo:илокочо
      inh:ингушча
      io:идочо
      is:исландча
      it:италиянча
      iu:инуктитутча
      ja:жапончо
      jbo:ложбанча
      jgo:нгомбача
      jmc:мачамече
      jv:жаванизче
      ka:грузинче
      kab:кабылча
      kac:кахинче
      kaj:джуча
      kam:камбача
      kbd:кабардинче
      kcg:тяпча
      kde:макондече
      kea:кабувердиче
      kfo:корочо
      kgp:кайнгангча (индей тили)
      kha:хасиче
      khq:койра чиниче
      ki:кикуйиче
      kj:куаньямача
      kk:казакча
      kkj:какочо
      kl:калаалисутча
      kln:каленжиче
      km:кмерче
      kmb:кимбундуча
      kn:каннадача
      ko:корейче
      koi:коми-пермякча
      kok:конканиче
      kpe:кпеллече
      kr:кануриче
      krc:карачай-балкарча
      krl:карелче
      kru:курухча
      ks:кашмирче
      ksb:шамабалача
      ksf:бафияча
      ksh:колоньяча
      ku:курдча
      kum:кумыкча
      kv:комиче
      kw:корнишче
      kwk:кваквалача (индей тили)
      kxv:куви
      ky:кыргызча
      la:латынча
      lad:ладиночо
      lag:лангиче
      lb:люксембургча
      lez:лезгинче
      lg:гандача
      li:лимбургиче
      lij:лигурча
      lil:лиллуэтче (индей тили)
      lkt:лакотача
      lmo:ломбардча
      ln:лингалача
      lo:лаочо
      lou:луизиана креолчо
      loz:лозиче
      lrc:түндүк луриче
      lsm:саамиача (Уганда, Кения)
      lt:литовчо
      lu:луба-катангача
      lua:луба-лулуача
      lun:лундача
      luo:луочо
      lus:мизочо
      luy:лухияча
      lv:латышча
      mad:мадурисче
      mag:магахиче
      mai:маитиличе
      mak:макасарча
      mas:масайча
      mdf:мокшача
      men:мендече
      mer:меруча
      mfe:морисианча
      mg:малагасча
      mgh:макуача
      mgo:метача
      mh:маршаллча
      mi:маориче
      mic:микмакча
      min:минанкабауча
      mk:македончо
      ml:малайаламча
      mn:монголчо
      mni:манипуриче
      moe:инну-аймунча (индейлер тили)
      moh:мохаукча
      mos:моссиче
      mr:маратиче
      ms:малайча
      mt:малтизче
      mua:мундангча
      mul:бир нече тилде
      mus:крикче
      mwl:мирандизче
      my:бурмача
      myv:эрзянча
      mzn:мазандераниче
      na:науруча
      nap:неополитанча
      naq:намача
      nb:норвежче (букмал)
      nd:түндүк ндыбелче
      nds:төмөнкү немисче
      nds-NL:төмөнкү саксончо
      ne:непалча
      new:невариче
      ng:ндонгача
      nia:ниасча
      niu:ньюанча
      nl:голландча
      nl-BE:фламандча
      nmg:квасиочо
      nn:норвежче (нинорск)
      nnh:нгимбунча
      no:норвежче
      nog:ногайча
      nqo:нкочо
      nr:түштүк ндебелече
      nso:түндүк соточо
      nus:нуерче
      nv:наваджочо
      ny:ньянджача
      nyn:ныйанколчо
      oc:окситанча
      ojb:түндүк-батыш ожибвече (индей тили)
      ojc:борбордук ожибвече
      ojs:ожи-криче (индей тили)
      ojw:батыш ожибвече (индей тили)
      oka:оканаганча (Канада)
      om:оромочо
      or:орияча
      os:осетинче
      pa:пунжабиче
      pag:пангасиче
      pam:пампангача
      pap:папиаменточо
      pau:палауанча
      pcm:аргындашкан тил (Нигерия)
      pis:пижинче (Соломон Аралдары)
      pl:полякча
      pqm:малесит-пассамакуоддиче (индей тили)
      prg:пруссча
      ps:пуштуча
      pt:португалча
      pt-PT:португалча (Европа)
      qu:кечуача
      quc:кичече
      raj:ражастаниче
      rap:рапаньюча
      rar:раротонгача
      rhg:рохинжача
      rm:романшча
      rn:рундиче
      ro:румынча
      ro-MD:молдованча
      rof:ромбочо
      ru:орусча
      rup:аромунча
      rw:руандача
      rwk:руача
      sa:санскритче
      sad:сандавече
      sah:сахача
      saq:самбуруча
      sat:санталиче
      sba:нгамбайча
      sbp:сангуча
      sc:сардинче
      scn:сицилийче
      sco:шотландча
      sd:синдхиче
      sdh:түштүк курдча
      se:түндүк саамиче
      seh:сенача
      ses:койраборо сенниче
      sg:сангочо
      sh:серб-хорват
      shi:ташелитче
      shn:шанча
      si:сингалача
      sk:словакча
      sl:словенче
      slh:түштүк лушуцидче (индей тили)
      sm:самоанча
      sma:түштүк саамиче
      smj:луле саамиче
      smn:инари саамиче
      sms:сколт саамиче
      sn:шонача
      snk:сонинкече
      so:сомаличе
      sq:албанча
      sr:сербче
      srn:сранан тонгочо
      ss:сватиче
      ssy:сахочо
      st:сесоточо
      str:стрейтс салишче (индей тили)
      su:сунданча
      suk:сукумача
      sv:шведче
      sw:суахиличе
      sw-CD:конго суахаличе
      swb:коморчо
      syr:сирияча
      szl:силесче
      ta:тамилче
      tce:түштүк тутчонече (индей тили)
      te:телугуча
      tem:тимнече
      teo:тесочо
      tet:тетумча
      tg:тажикче
      tgx:тагишче (индей тили)
      th:тайча
      tht:талтанча (индей тили)
      ti:тигриниача
      tig:тигрече
      tk:түркмөнчө
      tlh:клингончо
      tli:тлинкитче (индей тили)
      tn:тсванача
      to:тонгача
      tok:токипонача (эксперименталдык тил)
      tpi:ток-писинче
      tr:түркчө
      trv:тарокочо
      ts:тсонгача
      tt:татарча
      ttm:түндүк тутчончо (индей тили)
      tum:тумбукача
      tvl:тувалуча
      tw:тви
      twq:тасабакча
      ty:таитиче
      tyv:тувинче
      tzm:борбордук Атлас тамазигтче
      udm:удмуртча
      ug:уйгурча
      uk:украинче
      umb:умбундуча
      und:белгисиз тилде
      ur:урдуча
      uz:өзбекче
      vai:вайиче
      ve:вендача
      vec:венециянча
      vi:вьетнамча
      vmw:махувача
      vo:волапюкча
      vun:вунжочо
      wa:валлончо
      wae:валцерче
      wal:вольяттача
      war:варайча
      wbp:ворлпириче
      wo:уолофчо
      wuu:'У' диалектинде (Кытай)
      xal:калмыкча
      xh:косача
      xnr:кангри
      xog:согача
      yav:янгбенче
      ybb:йембача
      yi:идишче
      yo:йорубача
      yrl:ньенгатуча (түштүк америка тилдери)
      yue:кантончо
      yue-alt-menu:кытайча (кантончо)
      za:чжуанча
      zgh:марокко тамазигт адабий тилинде
      zh:кытайча
      zh-alt-menu:кытайча (мандарин)
      zh-Hans:кытайча (жөнөкөйлөштүрүлгөн)
      zh-Hans-alt-long:кытайча (жөнөкөйлөштүрүлгөн)
      zh-Hant:кытайча (салттуу)
      zh-Hant-alt-long:кытайча (салттуу)
      zu:зулуча
      zun:зуниче
      zxx:тилдик мазмун жок
      zza:зазача
      """.trimIndent() }

  val lag: String by lazy { """
      ak:Kɨakáani
      am:Kɨmʉháari
      ar:Kɨaráabu
      be:Kɨberalúusi
      bg:Kɨbulugária
      bn:Kɨbangála
      cs:Kɨchéeki
      de:Kɨjerʉmáani
      el:Kɨgiríki
      en:Kɨɨngeréesa
      es:Kɨhispánia
      fa:Kɨajéemi
      fr:Kɨfaráansa
      ha:Kɨhaúusa
      hi:Kɨhíindi
      hu:Kɨhungári
      id:Kɨɨndonésia
      ig:Kiígibo
      it:Kɨtaliáano
      ja:Kɨjapáani
      jv:Kɨjáava
      km:Kɨkambódia
      ko:Kɨkoréa
      lag:Kɨlaangi
      ms:Kɨmelésia
      my:Kɨbáama
      ne:Kɨnepáali
      nl:Kɨholáanzi
      pa:Kɨpúnjabi
      pl:Kɨpólandi
      pt:Kɨréeno
      ro:Kɨromanía
      ru:Kɨrúusi
      rw:Kɨnyarwáanda
      so:Kɨsómáali
      sv:Kɨswíidi
      ta:Kɨtamíili
      th:Kɨtáilandi
      tr:Kɨturúuki
      uk:Kɨukɨranía
      ur:Kɨúrdu
      vi:Kɨvietináamu
      yo:Kɨyorúuba
      zh:Kɨchíina
      zh-alt-menu:Kɨchíina
      zu:Kɨzúulu
      """.trimIndent() }

  val lb: String by lazy { """
      aa:Afar
      ab:Abchasesch
      ace:Aceh-Sprooch
      ach:Acholi-Sprooch
      ada:Adangme
      ady:Adygéiesch
      ae:Avestesch
      aeb:Tunesescht Arabesch
      af:Afrikaans
      afh:Afrihili
      agq:Aghem
      ain:Ainu-Sprooch
      ak:Akan
      akk:Akkadesch
      akz:Alabama
      ale:Aleutesch
      aln:Gegesch
      alt:Süd-Alaesch
      am:Amharesch
      an:Aragonesesch
      ang:Alenglesch
      anp:Angika
      ar:Arabesch
      ar-001:Modernt Héicharabesch
      arc:Aramäesch
      arn:Mapudungun
      aro:Araona
      arp:Arapaho-Sprooch
      arq:Algerescht Arabesch
      arw:Arawak-Sprooch
      ary:Marokkanescht Arabesch
      arz:Egyptescht Arabesch
      as:Assamesesch
      asa:Asu (Tanzania)
      ase:Amerikanesch Zeechesprooch
      ast:Asturianesch
      av:Awaresch
      avk:Kotava
      awa:Awadhi
      ay:Aymara
      az:Aserbaidschanesch
      az-alt-short:Aserbaidschanesch
      ba:Baschkiresch
      bal:Belutschesch
      ban:Balinesesch
      bar:Bairesch
      bas:Basaa-Sprooch
      bax:Bamun
      bbc:Batak Toba
      bbj:Ghomálá’
      be:Wäissrussesch
      bej:Bedauye
      bem:Bemba-Sprooch
      bew:Betawi
      bez:Bena
      bfd:Bafut
      bfq:Badaga
      bg:Bulgaresch
      bho:Bhodschpuri
      bi:Bislama
      bik:Bikol-Sprooch
      bin:Bini-Sprooch
      bjn:Banjaresesch
      bkm:Kom
      bla:Blackfoot-Sprooch
      bm:Bambara-Sprooch
      bn:Bengalesch
      bo:Tibetesch
      bpy:Bishnupriya
      bqi:Bachtiaresch
      br:Bretonesch
      bra:Braj-Bhakha
      brh:Brahui
      brx:Bodo
      bs:Bosnesch
      bss:Akoose
      bua:Burjatesch
      bug:Buginesesch
      bum:Bulu
      byn:Blin
      byv:Medumba
      ca:Katalanesch
      cad:Caddo
      car:Karibesch
      cay:Cayuga
      cch:Atsam
      ce:Tschetschenesch
      ceb:Cebuano
      cgg:Kiga
      ch:Chamorro-Sprooch
      chb:Chibcha-Sprooch
      chg:Tschagataesch
      chk:Trukesesch
      chm:Mari
      chn:Chinook
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      ckb:Sorani
      ckb-alt-menu:Sorani
      ckb-alt-variant:Sorani
      co:Korsesch
      cop:Koptesch
      cps:Capiznon
      cr:Cree
      crh:Krimtataresch
      cs:Tschechesch
      csb:Kaschubesch
      cu:Kiercheslawesch
      cv:Tschuwaschesch
      cy:Walisesch
      da:Dänesch
      dak:Dakota-Sprooch
      dar:Darginesch
      dav:Taita
      de:Däitsch
      de-AT:Éisträichescht Däitsch
      de-CH:Schwäizer Héichdäitsch
      del:Delaware-Sprooch
      den:Slave
      dgr:Dogrib
      din:Dinka-Sprooch
      dje:Zarma
      doi:Dogri
      dsb:Niddersorbesch
      dtp:Zentral-Dusun
      dua:Duala
      dum:Mëttelhollännesch
      dv:Maldivesch
      dyo:Jola-Fonyi
      dyu:Dyula-Sprooch
      dz:Bhutanesch
      dzg:Dazaga
      ebu:Kiembu
      ee:Ewe-Sprooch
      efi:Efik
      egl:Emilianesch
      egy:Egyptesch
      eka:Ekajuk
      el:Griichesch
      elx:Elamesch
      en:Englesch
      en-AU:Australescht Englesch
      en-CA:Kanadescht Englesch
      en-GB:Britescht Englesch
      en-GB-alt-short:Englesch (UK)
      en-US:Amerikanescht Englesch
      en-US-alt-short:Englesch (US)
      enm:Mëttelenglesch
      eo:Esperanto
      es:Spuenesch
      es-419:Latäinamerikanescht Spuenesch
      es-ES:Europäescht Spuenesch
      es-MX:Mexikanescht Spuenesch
      esu:Yup’ik
      et:Estnesch
      eu:Baskesch
      ewo:Ewondo
      ext:Extremaduresch
      fa:Persesch
      fan:Pangwe-Sprooch
      fat:Fanti-Sprooch
      ff:Ful
      fi:Finnesch
      fil:Filipino
      fit:Meänkieli
      fj:Fidschianesch
      fo:Färöesch
      fon:Fon-Sprooch
      fr:Franséisch
      fr-CA:Kanadescht Franséisch
      fr-CH:Schwäizer Franséisch
      frc:Cajun
      frm:Mëttelfranséisch
      fro:Alfranséisch
      frp:Frankoprovenzalesch
      frr:Nordfriesesch
      frs:Ostfriesesch
      fur:Friulesch
      fy:Westfriesesch
      ga:Iresch
      gaa:Ga-Sprooch
      gag:Gagausesch
      gan:Gan-Chinesesch
      gay:Gayo
      gba:Gbaya-Sprooch
      gbz:Zoroastrianescht Dari
      gd:Schottescht Gällesch
      gez:Geez
      gil:Gilbertesesch
      gl:Galizesch
      glk:Gilaki
      gmh:Mëttelhéichdäitsch
      gn:Guarani
      goh:Alhéichdäitsch
      gon:Gondi-Sprooch
      gor:Mongondou
      got:Gotesch
      grb:Grebo-Sprooch
      grc:Algriichesch
      gsw:Schwäizerdäitsch
      gu:Gujarati
      guc:Wayuu
      gur:Farefare
      guz:Gusii-Sprooch
      gv:Manx
      gwi:Kutchin-Sprooch
      ha:Hausa
      hai:Haida-Sprooch
      hak:Hakka-Chinesesch
      haw:Hawaiesch
      he:Hebräesch
      hi:Hindi
      hif:Fidschi-Hindi
      hil:Hiligaynon-Sprooch
      hit:Hethitesch
      hmn:Miao-Sprooch
      ho:Hiri-Motu
      hr:Kroatesch
      hsb:Uewersorbesch
      hsn:Xiang-Chinesesch
      ht:Haitianesch
      hu:Ungaresch
      hup:Hupa
      hy:Armenesch
      hz:Herero-Sprooch
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Indonesesch
      ie:Interlingue
      ig:Igbo-Sprooch
      ii:Sichuan Yi
      ik:Inupiak
      ilo:Ilokano-Sprooch
      inh:Inguschesch
      io:Ido-Sprooch
      is:Islännesch
      it:Italienesch
      iu:Inukitut
      izh:Ischoresch
      ja:Japanesch
      jam:Jamaikanesch-Kreolesch
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jpr:Jiddesch-Persesch
      jrb:Jiddesch-Arabesch
      jut:Jütesch
      jv:Javanesch
      ka:Georgesch
      kaa:Karakalpakesch
      kab:Kabylesch
      kac:Kachin-Sprooch
      kaj:Jju
      kam:Kamba
      kaw:Kawi
      kbd:Kabardinesch
      kbl:Kanembu
      kcg:Tyap
      kde:Makonde
      kea:Kabuverdianu
      ken:Kenyang
      kfo:Koro
      kg:Kongolesesch
      kgp:Kaingang
      kha:Khasi-Sprooch
      kho:Sakesch
      khq:Koyra Chiini
      khw:Khowar
      ki:Kikuyu-Sprooch
      kiu:Kirmanjki
      kj:Kwanyama
      kk:Kasachesch
      kkj:Kako
      kl:Grönlännesch
      kln:Kalenjin
      km:Kambodschanesch
      kmb:Kimbundu-Sprooch
      kn:Kannada
      ko:Koreanesch
      koi:Komi-Permiak
      kok:Konkani
      kos:Kosraeanesch
      kpe:Kpelle-Sprooch
      kr:Kanuri-Sprooch
      krc:Karatschaiesch-Balkaresch
      kri:Krio
      krj:Kinaray-a
      krl:Karelesch
      kru:Oraon-Sprooch
      ks:Kaschmiresch
      ksb:Shambala
      ksf:Bafia
      ksh:Kölsch
      ku:Kurdesch
      kum:Kumükesch
      kut:Kutenai-Sprooch
      kv:Komi-Sprooch
      kw:Kornesch
      ky:Kirgisesch
      la:Latäin
      lad:Ladino
      lag:Langi
      lah:Lahnda
      lam:Lamba-Sprooch
      lb:Lëtzebuergesch
      lez:Lesgesch
      lfn:Lingua Franca Nova
      lg:Ganda-Sprooch
      li:Limburgesch
      lij:Liguresch
      liv:Livesch
      lkt:Lakota-Sprooch
      lmo:Lombardesch
      ln:Lingala
      lo:Laotesch
      lol:Mongo
      loz:Rotse-Sprooch
      lt:Litauesch
      ltg:Lettgallesch
      lu:Luba-Katanga
      lua:Luba-Lulua
      lui:Luiseno-Sprooch
      lun:Lunda-Sprooch
      luo:Luo-Sprooch
      lus:Lushai-Sprooch
      luy:Olulujia
      lv:Lettesch
      lzh:Klassescht Chinesesch
      lzz:Lasesch Sprooch
      mad:Maduresesch
      maf:Mafa
      mag:Khotta
      mai:Maithili
      mak:Makassaresch
      man:Manding-Sprooch
      mas:Massai-Sprooch
      mde:Maba
      mdf:Moksha
      mdr:Mandaresesch
      men:Mende-Sprooch
      mer:Meru-Sprooch
      mfe:Morisyen
      mg:Malagassi-Sprooch
      mga:Mëtteliresch
      mgh:Makhuwa-Meetto
      mgo:Meta’
      mh:Marschallesesch
      mi:Maori
      mic:Micmac-Sprooch
      min:Minangkabau-Sprooch
      mk:Mazedonesch
      ml:Malayalam
      mn:Mongolesch
      mnc:Mandschuresch
      mni:Meithei-Sprooch
      moh:Mohawk-Sprooch
      mos:Mossi-Sprooch
      mr:Marathi
      mrj:West-Mari
      ms:Malaiesch
      mt:Maltesesch
      mua:Mundang
      mul:Méisproocheg
      mus:Muskogee-Sprooch
      mwl:Mirandesesch
      mwr:Marwari
      mwv:Mentawai
      my:Birmanesch
      mye:Myene
      myv:Ersja-Mordwinesch
      mzn:Mazandarani
      na:Nauruesch
      nan:Min-Nan-Chinesesch
      nap:Neapolitanesch
      naq:Nama
      nb:Norwegesch Bokmål
      nd:Nord-Ndebele-Sprooch
      nds:Nidderdäitsch
      ne:Nepalesesch
      new:Newari
      ng:Ndonga
      nia:Nias-Sprooch
      niu:Niue-Sprooch
      njo:Ao Naga
      nl:Hollännesch
      nl-BE:Flämesch
      nmg:Kwasio
      nn:Norwegesch Nynorsk
      nnh:Ngiemboon
      no:Norwegesch
      nog:Nogai
      non:Alnordesch
      nov:Novial
      nqo:N’Ko
      nr:Süd-Ndebele-Sprooch
      nso:Nord-Sotho-Sprooch
      nus:Nuer
      nv:Navajo
      nwc:Al-Newari
      ny:Nyanja-Sprooch
      nym:Nyamwezi-Sprooch
      nyn:Nyankole
      nyo:Nyoro
      nzi:Nzima
      oc:Okzitanesch
      oj:Ojibwa-Sprooch
      om:Oromo
      or:Orija
      os:Ossetesch
      osa:Osage-Sprooch
      ota:Osmanesch
      pa:Pandschabesch
      pag:Pangasinan-Sprooch
      pal:Mëttelpersesch
      pam:Pampanggan-Sprooch
      pap:Papiamento
      pau:Palau
      pcd:Picardesch
      pdc:Pennsylvaniadäitsch
      pdt:Plattdäitsch
      peo:Alpersesch
      pfl:Pfälzesch Däitsch
      phn:Phönikesch
      pi:Pali
      pl:Polnesch
      pms:Piemontesesch
      pnt:Pontesch
      pon:Ponapeanesch
      prg:Preisesch
      pro:Alprovenzalesch
      ps:Paschtu
      pt:Portugisesch
      pt-BR:Brasilianescht Portugisesch
      pt-PT:Europäescht Portugisesch
      qu:Quechua
      quc:Quiché-Sprooch
      qug:Kichwa (Chimborazo-Gebidder)
      raj:Rajasthani
      rap:Ouschterinsel-Sprooch
      rar:Rarotonganesch
      rgn:Romagnol
      rif:Tarifit
      rm:Rätoromanesch
      rn:Rundi-Sprooch
      ro:Rumänesch
      ro-MD:Moldawesch
      rof:Rombo
      rom:Romani
      rtm:Rotumanesch
      ru:Russesch
      rue:Russinesch
      rug:Roviana
      rup:Aromunesch
      rw:Ruandesch
      rwk:Rwa
      sa:Sanskrit
      sad:Sandawe-Sprooch
      sah:Jakutesch
      sam:Samaritanesch
      saq:Samburu
      sas:Sasak
      sat:Santali
      saz:Saurashtra
      sba:Ngambay
      sbp:Sangu
      sc:Sardesch
      scn:Sizilianesch
      sco:Schottesch
      sd:Sindhi
      sdc:Sassaresesch
      se:Nordsamesch
      see:Seneca
      seh:Sena
      sei:Seri
      sel:Selkupesch
      ses:Koyra Senni
      sg:Sango
      sga:Aliresch
      sgs:Samogitesch
      sh:Serbo-Kroatesch
      shi:Taschelhit
      shn:Schan-Sprooch
      shu:Tschadesch-Arabesch
      si:Singhalesesch
      sid:Sidamo
      sk:Slowakesch
      sl:Slowenesch
      sli:Nidderschlesesch
      sly:Selayar
      sm:Samoanesch
      sma:Südsamesch
      smj:Lule-Lappesch
      smn:Inari-Lappesch
      sms:Skolt-Lappesch
      sn:Shona
      snk:Soninke-Sprooch
      so:Somali
      sog:Sogdesch
      sq:Albanesch
      sr:Serbesch
      srn:Srananesch
      srr:Serer-Sprooch
      ss:Swazi
      ssy:Saho
      st:Süd-Sotho-Sprooch
      stq:Saterfriesesch
      su:Sundanesesch
      suk:Sukuma-Sprooch
      sus:Susu
      sux:Sumeresch
      sv:Schwedesch
      sw:Suaheli
      sw-CD:Kongo-Swahili
      swb:Komoresch
      syc:Alsyresch
      syr:Syresch
      szl:Schlesesch
      ta:Tamilesch
      tcy:Tulu
      te:Telugu
      tem:Temne
      teo:Teso
      ter:Tereno-Sprooch
      tet:Tetum-Sprooch
      tg:Tadschikesch
      th:Thailännesch
      ti:Tigrinja
      tig:Tigre
      tiv:Tiv-Sprooch
      tk:Turkmenesch
      tkl:Tokelauanesch
      tkr:Tsachuresch
      tl:Dagalog
      tlh:Klingonesch
      tli:Tlingit-Sprooch
      tly:Talesch
      tmh:Tamaseq
      tn:Tswana-Sprooch
      to:Tongaesch
      tog:Tsonga-Sprooch
      tpi:Neimelanesesch
      tr:Tierkesch
      tru:Turoyo
      trv:Seediq
      ts:Tsonga
      tsd:Tsakonesch
      tsi:Tsimshian-Sprooch
      tt:Tataresch
      ttt:Tatesch
      tum:Tumbuka-Sprooch
      tvl:Elliceanesch
      tw:Twi
      twq:Tasawaq
      ty:Tahitesch
      tyv:Tuwinesch
      tzm:Mëttlert-Atlas-Tamazight
      udm:Udmurtesch
      ug:Uiguresch
      uga:Ugaritesch
      uk:Ukrainesch
      umb:Mbundu-Sprooch
      und:Onbestëmmt Sprooch
      ur:Urdu
      uz:Usbekesch
      vai:Vai-Sprooch
      ve:Venda-Sprooch
      vec:Venezesch
      vep:Wepsesch
      vi:Vietnamesesch
      vls:Westflämesch
      vmf:Mainfränkesch
      vo:Volapük
      vot:Wotesch
      vro:Voro
      vun:Vunjo
      wa:Wallounesch
      wae:Walliserdäitsch
      wal:Walamo-Sprooch
      war:Waray
      was:Washo-Sprooch
      wo:Wolof
      wuu:Wu-Chinesesch
      xal:Kalmückesch
      xh:Xhosa
      xmf:Mingrelesch Sprooch
      xog:Soga
      yao:Yao-Sprooch
      yap:Yapesesch
      yav:Yangben
      ybb:Yemba
      yi:Jiddesch
      yo:Yoruba
      yrl:Nheengatu
      yue:Kantonesesch
      yue-alt-menu:Kantonesesch
      za:Zhuang
      zap:Zapotekesch
      zbl:Bliss-Symboler
      zea:Seelännesch
      zen:Zenaga
      zgh:Marokkanescht Standard-Tamazight
      zh:Chinesesch
      zh-alt-menu:Chinesesch
      zh-Hans:Chinesesch (vereinfacht)
      zh-Hans-alt-long:Chinesesch (vereinfacht)
      zh-Hant:Chinesesch (traditionell)
      zh-Hant-alt-long:Chinesesch (traditionell)
      zu:Zulu
      zun:Zuni-Sprooch
      zxx:Keng Sproochinhalter
      zza:Zaza
      """.trimIndent() }

  val lg: String by lazy { """
      ak:Lu-akaani
      am:Lu-amhariki
      ar:Luwarabu
      be:Lubelarusi
      bg:Lubulugariya
      bn:Lubengali
      cs:Luceeke
      de:Ludaaki
      el:Lugereeki/Luyonaani
      en:Lungereza
      es:Lusipanya
      fa:Luperusi
      fr:Lufalansa
      ha:Luhawuza
      hi:Luhindu
      hu:Luhangare
      id:Luyindonezya
      ig:Luyibo
      it:Luyitale
      ja:Lujapani
      jv:Lunnajjava
      km:Lukme
      ko:Lukoreya
      lg:Luganda
      ms:Lumalayi
      my:Lubbama
      ne:Lunepali
      nl:Luholandi
      pa:Lupunjabi
      pl:Lupolandi
      pt:Lupotugiizi
      ro:Lulomaniya
      ru:Lulasa
      rw:Lunarwanda
      so:Lusomaliya
      sv:Luswideni
      ta:Lutamiiru
      th:Luttaayi
      tr:Lutake
      uk:Luyukurayine
      ur:Lu-urudu
      vi:Luvyetinaamu
      yo:Luyoruba
      zh:Lucayina
      zh-alt-menu:Lucayina
      zu:Luzzulu
      """.trimIndent() }

  val lij: String by lazy { """
      en:ingleise
      lij:ligure
      """.trimIndent() }

  val lkt: String by lazy { """
      ab:Abkhaz Iyápi
      ady:Adyghe Iyápi
      ae:Avestan Iyápi
      af:Afrikaans Iyápi
      alt:Itóǧata Altai Iyápi
      am:Amharic Iyápi
      ar:Arab Iyápi
      arp:Maȟpíya Tȟó Iyápi
      as:Assamese Iyápi
      av:Avaric Iyápi
      az:Azerbaijani Iyápi
      az-alt-short:Azerbaijani Iyápi
      ba:Bashkir Iyápi
      bal:Baluchi Iyápi
      bax:Bamun Iyápi
      be:Belarus Iyápi
      bej:Beja Iyápi
      bg:Bulgar Iyápi
      bn:Bengali Iyápi
      bo:Tibetan Iyápi
      bs:Bosnia Iyápi
      bua:Buriat Iyápi
      ca:Catalan Iyápi
      ce:Chechen Iyápi
      chm:Mari Iyápi
      chr:Cherokee Iyápi
      chy:Šahíyela Iyápi
      cop:Coptic Iyápi
      cr:Maštíŋča Oyáte Iyápi
      crh:Crimean Turkish Iyápi
      cs:Czech Iyápi
      cv:Chuvash Iyápi
      cy:Wales Iyápi
      da:Dane Iyápi
      dak:Dakȟótiyapi
      dar:Dargwa Iyápi
      de:Iyášiča Iyápi
      doi:Dogri Iyápi
      el:Greece Iyápi
      en:Wašíčuiyapi
      en-GB:Šagláša Wašíčuiyapi
      en-GB-alt-short:Šagláša Wašíčuiyapi
      en-US:Mílahaŋska Wašíčuiyapi
      en-US-alt-short:Mílahaŋska Wašíčuiyapi
      eo:Esperanto Iyápi
      es:Spayóla Iyápi
      es-419:Wiyóȟpeyata Spayóla Iyápi
      es-ES:Spayólaȟča Iyápi
      et:Estonia Iyápi
      eu:Basque Iyápi
      fa:Persian Iyápi
      fi:Finnish Iyápi
      fil:Filipino Iyápi
      fj:Fiji Iyápi
      fo:Faroese Iyápi
      fr:Wašíču Ikčéka Iyápi
      ga:Irish Iyápi
      gba:Gbaya Iyápi
      gl:Galician Iyápi
      gn:Guarani Iyápi
      gu:Gujarati Iyápi
      ha:Hausa Iyápi
      haw:Hawaiian Iyápi
      he:Hebrew Iyápi
      hi:Hindi Iyápi
      hr:Croatian Iyápi
      ht:Haiti Iyápi
      hu:Hungary Iyápi
      hy:Armenia Iyápi
      id:Indonesia Iyápi
      ig:Igbo Iyápi
      inh:Ingush Iyápi
      is:Iceland Iyápi
      it:Italia Iyápi
      ja:Kisúŋla Iyápi
      jv:Java Iyápi
      ka:Georia Iyápi
      kaa:Kara-Kalpak Iyápi
      kbd:Kabardian Iyápi
      kk:Kazakh Iyápi
      km:Khmer Iyápi
      kn:Kannada Iyápi
      ko:Korea Iyápi
      ks:Kashmir Iyápi
      ku:Kurd Iyápi
      ky:Kirghiz Iyápi
      la:Latin Iyápi
      lah:Lahnda Iyápi
      lb:Luxembourg Iyápi
      lkt:Lakȟólʼiyapi
      lo:Lao Iyápi
      lt:Lithuania Iyápilt
      lus:Mizo Iyápi
      lv:Latvia Iyápi
      mg:Malagasy Iyápi
      mi:Maori Iyápi
      mk:Macedonia Iyápi
      ml:Malayalam Iyápi
      mni:Namipuri Iyápi
      mr:Marathi Iyápi
      ms:Malay Iyápi
      mt:Maltese Iyápi
      my:Burmese Iyápi
      ne:Nepal Iyápi
      nl:Dutch Iyápi
      nl-BE:Flemish Iyápi
      nv:Šináglegleǧa Iyápi
      oj:Ȟaȟátȟuŋwaŋ Iyápi
      or:Oriya Iyápi
      pa:Punjabi Iyápi
      pl:Polish Iyápi
      ps:Pashto Iyápi
      pt:Portuguese Iyápi
      qu:Quechua Iyápi
      rm:Romansh Iyápi
      ro:Romanian Iyápi
      ru:Russia Iyápi
      sa:Sanskrit Iyápi
      sd:Sindhi Iyápi
      si:Sinhala Iyápi
      sk:Slovak Iyápi
      sl:Slovenian Iyápi
      so:Somali Iyápi
      sq:Albanian Iyápi
      sr:Serbia Iyápi
      su:Sundanese Iyápi
      sv:Swedish Iyápi
      sw:Swahili Iyápi
      swb:Comonian Iyápi
      ta:Tamil Iyápi
      te:Telugu Iyápi
      tg:Tajik Iyápi
      th:Thai Iyápi
      ti:Tigrinya Iyápi
      tk:Turkmen Iyápi
      to:Tongan Iyápi
      tr:Turkish Iyápi
      tt:Tatar Iyápi
      ug:Uyghur Iyápi
      uk:Ukrain Iyápi
      und:Tukté iyápi tȟaŋíŋ šni
      ur:Urdu Iyápi
      uz:Uzbek Iyápi
      vi:Vietnamese Iyápi
      wo:Wolof Iyápi
      xh:Xhosa Iyápi
      yo:Yoruba Iyápi
      zh:Pȟečhókaŋ Háŋska Iyápi
      zh-alt-menu:Pȟečhókaŋ Háŋska Iyápi
      zh-Hans:Pȟečhókaŋ Háŋska Iyápi Ikčéka
      zh-Hans-alt-long:Pȟečhókaŋ Háŋska Iyápi Ikčéka
      zh-Hant:Pȟečhókaŋ Háŋska Iyápi Ȟče
      zh-Hant-alt-long:Pȟečhókaŋ Háŋska Iyápi Ȟče
      zu:Zulu Iyápi
      zza:Zaza Iyápi
      """.trimIndent() }

  val lld: String by lazy { """
      aa:afar
      ab:abkhasich
      af:afrikaans
      ak:akan
      am:amarich
      an:aragonesc
      ar:arabich
      ar-001:arabich modern standard
      as:assamesc
      az:azerbaijan
      az-alt-short:azerbaijan
      ba:bashkir
      be:belarus
      bg:bulgar
      bm:bambara
      bn:bengalesc
      bo:tibetan
      br:breton
      bs:bosniach
      ca:catalan
      ce:cecen
      chr:cherokee
      co:corsich
      cs:cech
      cu:slav eclesiastich
      cv:ciuvascich
      cy:galesc
      da:danesc
      de:todësch
      de-AT:todësch dl’Austria
      de-CH:todësch standard dla Svizera
      dv:divehi
      dz:dzongkha
      ee:ewe
      el:grech
      en:inglesc
      en-GB:inglesc (UK)
      en-GB-alt-short:inglesc (UK)
      en-US:inglesc (USA)
      en-US-alt-short:inglesc (USA)
      eo:esperanto
      es:spagnol
      et:eston
      eu:basch
      fa:persian
      fa-AF:dari
      ff:fula
      fi:finlandesc
      fil:filipin
      fo:faroesc
      fr:franzesc
      fur:furlan
      fy:frison dl vest
      ga:irlandesc
      gd:gaelich scozesc
      gl:galizian
      gn:guaraní
      gu:gujarati
      gv:manx
      ha:haussa
      he:ebraich
      hi:hindi
      hi-Latn:hindi (latin)
      hi-Latn-alt-variant:hinglish
      hr:croat
      hu:ungaresc
      hy:armenich
      ia:interlingua
      id:indonesian
      ie:interlingue
      ig:igbo
      ii:sichuan yi
      io:ido
      is:islandesc
      it:talian
      iu:inuktitut
      ja:iapanesc
      jv:giavanesc
      ka:georgian
      kgp:kaingang
      ki:kikuyu
      kk:kazakh
      kl:groenlandesc
      km:khmer
      kn:kannada
      ko:corean
      ks:kashmiri
      ku:curdich
      kw:cornich
      ky:kyrgyz
      la:latin
      lb:lussemburghesc
      lg:ganda
      lld:ladin
      ln:lingala
      lo:lao
      lt:lituan
      lu:luba-katanga
      lv:leton
      mg:malgasich
      mi:maori
      mk:macedonich
      ml:malayalam
      mn:mongolich
      mr:marathi
      ms:malesc
      mt:maltesc
      my:birmanich
      nb:norvegesc bokmål
      nd:ndebele dl nord
      ne:nepalesc
      nl:neerlandesc
      nl-BE:flamesc
      nn:norvegesc nynorsk
      no:norvegesc
      nr:ndebele dl süd
      nv:navajan
      ny:nyanja
      oc:ocitan
      om:oromo
      or:odia
      os:ossetich
      pa:punjabi
      pl:polach
      ps:pashto
      pt:portoghesc
      qu:quechua
      rm:rumanc
      rn:rundi
      ro:rumen
      ro-MD:moldavich
      ru:rus
      rw:kinyarwanda
      sa:sanscrit
      sc:sard
      sd:sindhi
      se:sami dl nord
      sg:sango
      si:singalesc
      sk:slovach
      sl:sloven
      sn:shona
      so:somalich
      sq:albanesc
      sr:serb
      ss:swati
      st:sotho dl süd
      su:sundanesc
      sv:svedesc
      sw:swahili
      sw-CD:swahili dl Congo
      ta:tamilich
      te:telugu
      tg:tajich
      th:thailandesc
      ti:tigrin
      tk:turcmenich
      tn:tswana
      to:tongaich
      tr:türch
      ts:tsonga
      tt:tatarich
      ug:uigurich
      uk:ucrainich
      und:lingaz nia conesciü
      ur:urdu
      uz:uzbech
      ve:venda
      vi:vietnamesc
      vo:volapük
      wa:valonesc
      wo:wolof
      xh:xhosa
      yi:yiddish
      yo:yoruba
      yrl:nheengatu
      za:zhuang
      zh:cinesc
      zh-alt-menu:cinesc (mandarin)
      zh-Hans:cinesc scemplifiché
      zh-Hans-alt-long:cinesc mandarin scemplifiché
      zh-Hant:cinesc tradizional
      zh-Hant-alt-long:cinesc mandarin tradizional
      zu:zulu
      """.trimIndent() }

  val lmo: String by lazy { """
      en:ingles
      lmo:Lombard
      """.trimIndent() }

  val ln: String by lazy { """
      ak:akan
      am:liamariki
      ar:lialabo
      be:libyelorisí
      bg:libiligali
      bn:libengali
      cs:litshekɛ
      de:lialemá
      el:ligeleki
      en:lingɛlɛ́sa
      es:lisipanye
      fa:lipelésanɛ
      fr:lifalansɛ́
      ha:hausa
      hi:lihindi
      hu:liongili
      id:lindonezi
      ig:igbo
      it:litaliano
      ja:lizapɔ
      jv:lizava
      km:likambodza
      ko:likoreya
      ln:lingála
      ms:limalezi
      my:libilimá
      ne:linepalɛ
      nl:lifalamá
      pa:lipendzabi
      pl:lipolonɛ
      pt:lipulutugɛ́si
      ro:liromani
      ru:lirisí
      rw:kinyarwanda
      so:lisomali
      sv:lisuwedɛ
      ta:litamuli
      th:litaye
      tr:litiliki
      uk:likrɛni
      ur:liurdu
      vi:liviyetinámi
      yo:yoruba
      zh:lisinwa
      zh-alt-menu:lisinwa
      zu:zulu
      """.trimIndent() }

  val ln_AO: String? = null

  val ln_CF: String? = null

  val ln_CG: String? = null

  val lo: String by lazy { """
      aa:ອະຟາ
      ab:ແອບຄາຊຽນ
      ace:ແອັກຊີເນັສ
      ach:ອາໂຄລີ
      ada:ອາແດງມີ
      ady:ເອດີຮິ
      ae:ອາເວັສແຕນ
      af:ອາຟຣິການ
      afh:ແອຟີຮີລີ
      agq:ອາເຮັມ
      ain:ໄອນູ
      ak:ອາການ
      akk:ອັກກາດຽມ
      ale:ອາເລີດ
      alt:ອານໄຕໃຕ້
      am:ອຳຮາຣິກ
      an:ອາຣາໂກເນັດ
      ang:ອັງກິດໂບຮານ
      ann:ໂອໂບໂລ
      anp:ແອນຈີກາ
      ar:ອາຣັບ
      ar-001:ອາຣາບິກມາດຕະຖານສະໄໝໃໝ່
      arc:ອາລາມິກ
      arn:ມາພຸດຊີ
      arp:ອາຣາປາໂຮ
      ars:ນາຈດີ ອາຣາບິກ
      arw:ອາຣາແວກ
      as:ອັສຊາມີສ
      asa:ອາຊູ
      ast:ອັສຕູຮຽນ
      atj:ອາຕິກາແມກ
      av:ອາວາຣິກ
      awa:ອາວາຮິ
      ay:ອາຍມາລາ
      az:ອາເຊີໄບຈານິ
      az-alt-short:ອາ​ເຊີ​ຣີ
      ba:ບາຣກີ
      bal:ບາລູຊີ
      ban:ບາລີເນັດ
      bas:ບາຊາ
      bax:ບາມຸນ
      bbj:ໂຄມາລາ
      be:ເບລາຣັສຊຽນ
      bej:ບີເຈ
      bem:ເບັມບາ
      bez:ບີນາ
      bfd:ບາຟັດ
      bg:ບັງກາຣຽນ
      bgc:ຮາຢານວີ
      bgn:ບາໂລຈີ ພາກຕາເວັນຕົກ
      bho:ໂບພູຣິ
      bi:ບິສລະມາ
      bik:ບີຄອນ
      bin:ບີນີ
      bkm:ກົມ
      bla:ຊິກຊິກາ
      blo:ອານີ
      bm:ບາມບາຣາ
      bn:ເບັງກາລີ
      bo:ທິເບທັນ
      br:ເບຣຕັນ
      bra:ບຣາ
      brx:ໂບດູ
      bs:ບອສນຽນ
      bss:ອາຄຸດ
      bua:ບູຣຽດ
      bug:ບູຈີເນັດ
      bum:ບູລູ
      byn:ບລິນ
      byv:ເມດູມບາ
      ca:ຄາຕາລານ
      cad:ແຄດໂດ
      car:ຄາຣິບ
      cay:ຄາຢູກາ
      cch:ອາດແຊມ
      ccp:ຊາກມາ
      ce:ຊີເຄນ
      ceb:ຊີບູໂນ
      cgg:ຊີກາ
      ch:ຊາມໍໂຣ
      chb:ຊິບຊາ
      chg:ຊາກາໄຕ
      chk:ຊູເກດ
      chm:ມາຣິ
      chn:ຊີນຸກຈາກອນ
      cho:ຊອກຕິວ
      chp:ຊີພິວຢານ
      chr:ຊີໂຣກີ
      chy:ຊີເຢນນີ
      ckb:ໂຊຣານິ ເຄີດິຊ
      ckb-alt-menu:ໂຊຣານິ ເຄີດິຊ
      ckb-alt-variant:ໂຊຣານິ ເຄີດິຊ
      clc:ຊິວໂຄຕິນ
      co:ຄໍຊິກາ
      cop:ຄອບຕິກ
      cr:ຄີ
      crg:ມິຊິຟ
      crh:ຄຣີເມນເຕີຄິຊ
      crj:ຄຣີຕາເວັນອອກສ່ຽງໃຕ້
      crk:ເພລນຄຣີ
      crl:ຄຣີຕາເວັນອອກສ່ຽງເໜືອ
      crm:ມູສຄຣີ
      crr:ຄາໂຣລິນາ ອາກອນຄວຽນ
      crs:ເຊເຊວາ ໂຄຣດ ຝຣັ່ງ
      cs:ເຊກ
      csb:ກາຊູບຽນ
      csw:ຊວາມປີຄຣີ
      cu:ໂບດສລາວິກ
      cv:ຊູວາຊ
      cy:ເວວ
      da:ແດນິຊ
      dak:ດາໂກຕາ
      dar:ດາກວາ
      dav:ໄຕຕາ
      de:ເຢຍລະມັນ
      de-AT:ເຢຍລະມັນ (ໂອສຕຣິດ)
      de-CH:ສະວິສ ໄຮ ເຈີແມນ
      del:ເດລາວາ
      den:ຊີເລັບ
      dgr:ໂດກຣິບ
      din:ດິນກາ
      dje:ຊາມາ
      doi:ດອກຣີ
      dsb:ຊໍບຽນຕໍ່ກວ່າ
      dua:ດົວລາ
      dum:ດັກກາງ
      dv:ດີວີຮີ
      dyo:ໂຈລາ-ຟອນຢີ
      dyu:ດູລາ
      dz:ດີຊອງຄາ
      dzg:ດາຊາກາ
      ebu:ເອັມບູ
      ee:ອິວາ
      efi:ອີຟິກ
      egy:ອີຢິບບູຮານ
      eka:ອີກາຈັກ
      el:ກຣີກ
      elx:ອີລາໄມ
      en:ອັງກິດ
      en-GB:ອັງກິດ (ບຣິດທິຊ)
      en-GB-alt-short:ອັງກິດ (ສະຫະລາດຊະອານາຈັກ)
      en-US:ອັງກິດ (ອາເມລິກັນ)
      en-US-alt-short:ອັງກິດ (ສະຫະລັດອາເມລິກາ)
      enm:ອັງກິດກາງ
      eo:ເອສປາຍ
      es:ສະແປນນິຊ
      es-419:ລາຕິນ ອາເມຣິກັນ ສະແປນນິຊ
      es-ES:ສະເປັນ ຢຸໂຣບ
      es-MX:ເມັກຊິກັນ ສະແປນນິຊ
      et:ເອສໂຕນຽນ
      eu:ບັສກີ
      ewo:ອີວອນດູ
      fa:ເປີຊຽນ
      fa-AF:ດາຣີ
      fan:ແຟງ
      fat:ແຟນຕີ
      ff:ຟູລາ
      fi:ຟິນນິຊ
      fil:ຟີລິປີໂນ
      fj:ຟິຈຽນ
      fo:ຟາໂຣສ
      fon:ຟອນ
      fr:ຝຣັ່ງ
      fr-CH:ຝຣັ່ງ (ສວິສ)
      frc:ຝຣັ່ງເຄຈຸນ
      frm:ຟຮັ່ງເສດກາງ
      fro:ຟຮັ່ງເສດໂບຮານ
      frr:ຟຣີຊຽນເໜືອ
      frs:ຟຣີຊຽນຕາເວັນອອກ
      fur:ຟຣີລຽນ
      fy:ຟຣິຊຽນ ຕາເວັນຕົກ
      ga:ໄອຣິສ
      gaa:ກາ
      gag:ກາກາອຸຊ
      gay:ກາໂຢ
      gba:ບາຍາ
      gd:ສະກັອດເກລິກ
      gez:ກີ
      gil:ກິນເບີເທັດ
      gl:ກາລິຊຽນ
      gmh:ເຢຍລະມັນສູງກາງ
      gn:ກົວຣານີ
      goh:ເຢຍລະມັນສູງໂບຮານ
      gon:ກອນດີ
      gor:ໂກຣອນຕາໂຣ
      got:ກອດຮິກ
      grb:ກຣີໂບ
      grc:ແອນຊຽນກຣີກ
      gsw:ສະວິສ ເຈີແມນ
      gu:ກູຈາຣາຕິ
      guz:ກູຊິ
      gv:ແມງຊ໌
      gwi:ວິດອິນ
      ha:ເຮົາຊາ
      hai:ໄຮດາ
      haw:ຮາໄວອຽນ
      hax:ໄຮດາໃຕ້
      he:ຮີບຣິວ
      hi:ຮິນດິ
      hi-Latn-alt-variant:ຮິນກລີຊ
      hil:ຮິຣິໄກນອນ
      hit:ຮິດໄຕ
      hmn:ມອງ
      ho:ຮິຣິໂມຕູ
      hr:ໂຄຣເອທຽນ
      hsb:ຊໍບຽນ ທາງຕອນເໜືອ
      ht:ໄຮຕຽນ
      hu:ຮັງກາຣຽນ
      hup:ຮູປາ
      hur:ຮາລໂກເມລຽມ
      hy:ອາເມນຽນ
      hz:ເຮິຮິໂຣ
      ia:ອິນເຕີລິງລົວ
      iba:ໄອບານ
      ibb:ໄອໄບໄບໂອ
      id:ອິນໂດເນຊຽນ
      ie:ອິນເຕີລິງກຣີ
      ig:ອິກໂບ
      ii:ເສສວນ ອີ
      ik:ອິນນູປຽກ
      ikt:ອິນັກທິທັດຄານາດາຕາເວັນຕົກ
      ilo:ໄອໂລໂກ
      inh:ອິນກັຊ
      io:ອີໂດ
      is:ໄອສແລນດິກ
      it:ອິຕາລຽນ
      iu:ອິນນຸກຕິຕັດ
      ja:ຍີ່ປຸ່ນ
      jbo:ໂລບບັນ
      jgo:ງອມບາ
      jmc:ມາແຊມ
      jpr:ຈູແດວ-ເພີຊຽນ
      jrb:ຈູແດວ-ອາລາບິກ
      jv:ຈາແວນີສ
      ka:ຈໍຈຽນ
      kaa:ກາຣາ-ການປາກ
      kab:ກາໄບລ໌
      kac:ກາຊິນ
      kaj:ຈຣູ
      kam:ກາມບາ
      kaw:ກະວີ
      kbd:ກາບາດຽນ
      kbl:ຄາແນມບູ
      kcg:ຕີບ
      kde:ມາຄອນເດ
      kea:ຄາເວີເດຍນູ
      kfo:ໂຄໂລ
      kg:ຄອງໂກ
      kgp:ເຄນກັງ
      kha:ຄາສິ
      kho:ໂຄຕັນ
      khq:ຄອຍຣາ ຊິນີ
      ki:ຄິຄູຢຸ
      kj:ກວນຍາມາ
      kk:ຄາຊັກ
      kkj:ຄາໂກ
      kl:ກຣີນແລນລິດ
      kln:ຄາເລັນຈິນ
      km:ຂະເໝນ
      kmb:ຄິມບັນດູ
      kn:ຄັນນາດາ
      ko:ເກົາຫລີ
      koi:ໂຄມີ-ເພີມຢັກ
      kok:ກອນການີ
      kos:ຄູສໄລ
      kpe:ກາແປຣ
      kr:ຄານຸລິ
      krc:ກາຣາໄຊ-ບານກາ
      krl:ກາເຣລຽນ
      kru:ກູຣູກ
      ks:ຄາສເມຍຣິ
      ksb:ຊຳບາລ້າ
      ksf:ບາເຟຍ
      ksh:ໂຄລອກນຽນ
      ku:ເຄີດິສ
      kum:ຄູມີກ
      kut:ຄູເທໄນ
      kv:ໂຄມິ
      kw:ຄໍນິຊ
      kwk:ຄວາກຄວາກລາ
      kxv:ຄູວີ
      ky:ເກຍກີສ
      la:ລາຕິນ
      lad:ລາດີໂນ
      lag:ແລນກິ
      lah:ລານດາ
      lam:ແລມບາ
      lb:ລັກເຊມບວກກິຊ
      lez:ລີຊຽນ
      lg:ແກນດາ
      li:ລິມເບີກີຊ
      lij:ລີກູຣຽນ
      lil:ລິນລູເອັດ
      lkt:ລາໂກຕາ
      lmo:ລອມບາດ
      ln:ລິງກາລາ
      lo:ລາວ
      lol:ແມັງໂກ້
      lou:ລຸຍຊີອານນາ ຄຣີໂອນ
      loz:ໂລຊິ
      lrc:ລູຣິ ທາງຕອນເໜືອ
      lsm:ຊາອາເມຍ
      lt:ລິທົວນຽນ
      lu:ລູບາ-ຄາຕັງກາ
      lua:ລູບາ-ລູລົວ
      lui:ລູເຊໂນ
      lun:ລຸນດາ
      luo:ລົວ
      lus:ມີໂຊ
      luy:ລູໄຍ
      lv:ລັດວຽນ
      mad:ມາດູລາ
      maf:ມາຟາ
      mag:ມາກາຮິ
      mai:ໄມທີລິ
      mak:ມາກາຊາຣ
      man:ມັນດິງກາ
      mas:ມາໄຊ
      mde:ມາບາ
      mdf:ມອກຊາ
      mdr:ມານດາຣ
      men:ເມນເດ
      mer:ເມຣູ
      mfe:ມໍຣິສເຢນ
      mg:ມາລາກາສຊີ
      mga:ໄອລິດກາງ
      mgh:ມາຄູວາ-ມີດໂຕ
      mgo:ເມທາ
      mh:ມາຊານເລັດ
      mi:ມາວຣິ
      mic:ມິກແມກ
      min:ມີແນງກາບູ
      mk:ແມຊິໂດນຽນ
      ml:ມາເລອາລຳ
      mn:ມອງໂກເລຍ
      mnc:ແມນຈູ
      mni:ມານີພູຣິ
      moe:ອິນນຸໄອມັນ
      moh:ໂມຫາ
      mos:ມອສຊີ
      mr:ມາຣາທີ
      ms:ມາເລ
      mt:ມອລທີສ
      mua:ມັນດັງ
      mul:ຫລາຍພາສາ
      mus:ມັສໂກກີ
      mwl:ມີລັນດາ
      mwr:ມາວາຣິ
      my:ມຽນມາ
      mye:ມໍຢິນ
      myv:ເອີຍາ
      mzn:ມາແຊນເດີລັງ
      na:ນາຢູລູ
      nap:ນາໂປລີ
      naq:ນາມາ
      nb:ນໍເວຈຽນ ບັອກມອລ
      nd:ເອັນເດເບເລເໜືອ
      nds:ເຢຍລະມັນ ຕອນໃຕ້
      nds-NL:ຊາຊອນ ຕອນໄຕ
      ne:ເນປາລີ
      new:ນີວາຣິ
      ng:ເອັນດອງກາ
      nia:ນີ່ອັດ
      niu:ນີ່ອູ
      nl:ດັຊ
      nl-BE:ຟລີມິຊ
      nmg:ກວາຊີໂອ
      nn:ນໍເວຈຽນ ນີນອກ
      nnh:ຈີ່ມບູນ
      no:ນໍເວຈຽນ
      nog:ນໍໄກ
      non:ນໍໂບຮານ
      nqo:ເອັນໂກ
      nr:ນີບີລີໃຕ້
      nso:ໂຊໂທເໜືອ
      nus:ເນີ
      nv:ນາວາໂຈ
      nwc:ເນວາດັ້ງເດີມ
      ny:ນານຈາ
      nym:ນາມວີຊິ
      nyn:ນານຄອນ
      nyo:ໂນໂຣ
      nzi:ນິມາ
      oc:ອັອກຊີຕານ
      oj:ໂອຈິບວາ
      ojb:ໂອຈິບວາຕາເວັນຕົກສ່ຽງເໜືອ
      ojc:ໂອຈິບວາກາງ
      ojs:ໂອຈິຄຣີ
      ojw:ໂອຈິບວາຕາເວັນຕົກ
      oka:ໂອກະນາກັນ
      om:ໂອໂຣໂມ
      or:ໂອເດຍ
      os:ອອດເຊຕິກ
      osa:ໂອແຊກ
      ota:ຕູກີອອດໂຕມັນ
      pa:ປັນຈາບີ
      pag:ປານກາຊີນານ
      pal:ພາລາວີ
      pam:ປາມປານກາ
      pap:ປາມເປຍເມັນໂທ
      pau:ປາລົວອານ
      pcm:ໄນຈີຣຽນພິດກິນ
      peo:ເປີເຊຍໂບຮານ
      phn:ຟີນີເຊຍ
      pi:ປາລີ
      pis:ປິຈິນ
      pl:ໂປລິຊ
      pon:ພອນເພ
      pqm:ມາລິຊີດ ພາສຊາມາໂຄດດີ
      prg:ປຣັສຊຽນ
      pro:ໂປວອງຊານໂບຮານ
      ps:ປາສໂຕ
      pt:ປອກຕຸຍກິສ
      pt-PT:ປອກຕຸຍກິສ ຢຸໂຣບ
      qu:ຄີຊົວ
      quc:Kʼicheʼ
      raj:ຣາຈັສທານິ
      rap:ຣາປານຸຍ
      rar:ຣາໂຣທອນການ
      rhg:ໂຣຮິນຢາ
      rm:ໂຣແມນຊ໌
      rn:ຣຸນດິ
      ro:ໂຣແມນຽນ
      ro-MD:ໂມດາວຽນ
      rof:ຣົມໂບ
      rom:ໂຣເມນີ
      ru:ລັດເຊຍ
      rup:ອາໂຣມານຽນ
      rw:ຄິນຢາວານດາ
      rwk:ອາຣວາ
      sa:ສັນສະກຣິດ
      sad:ຊັນດາວ
      sah:ຊາກາ
      sam:ສາມາຣິແຕນ-
      saq:ຊຳບູຣູ
      sas:ຊາຊັກ
      sat:ຊານທາລິ
      sba:ກຳເບ
      sbp:ຊານກູ
      sc:ສາດີນຽນ
      scn:ຊີຊິລີນ
      sco:ສກອດ
      sd:ສິນທິ
      sdh:ພາກໄຕ້ ຂອງ ກູດິດ
      se:ຊາມິເໜືອ
      see:ຊີນີກາ
      seh:ຊີນາ
      sel:ເຊນຄັບ
      ses:ໂຄຍຣາໂບໂຣ ເຊນນິ
      sg:ແຊງໂກ
      sga:ອີຣິຊເກົ່າ
      sh:ເຊີໂບ-ໂກເຊຍ
      shi:ທາເຊວຫິດ
      shn:ຊານ
      shu:ອາລັບ-ຊາດ
      si:ສິນຫາລາ
      sid:ຊິດາໂມ
      sk:ສະໂລແວັກ
      sl:ສະໂລເວນຽນ
      slh:ລູຊຸດຊີດໃຕ້
      sm:ຊາມົວ
      sma:ຊາມິໃຕ້
      smj:ລຸນຊາມິ
      smn:ອີນາຣິຊາມິ
      sms:ສກອດຊາມິ
      sn:ໂຊນາ
      snk:ໂຊນິນກີ
      so:ໂຊມາລີ
      sog:ຊອກດິນ
      sq:ອານບານຽນ
      sr:ເຊີບຽນ
      srn:ສຣານນານຕອນໂກ
      srr:ເຊເລີ
      ss:ສະວາຕິ
      ssy:ຊາໂຮ
      st:ໂຊໂທໃຕ້
      str:ຊ່ອງແຄບເຊລີຊ
      su:ຊຸນແດນນີສ
      suk:ຊູຄູມ້າ
      sus:ຊູຊູ
      sux:ຊູເມີເລຍ
      sv:ສະວີດິຊ
      sw:ຊວາຮີລິ
      sw-CD:ຄອງໂກ ຊວາຮີລິ
      swb:ໂຄໂນຣຽນ
      syc:ຊີເລຍແບບດັ້ງເດີມ
      syr:ຊີເລຍ
      szl:ຊີເລສຊຽນ
      ta:ທາມິລ
      tce:ທຸດຊອນໃຕ້
      te:ເຕລູກູ
      tem:ທີມເນ
      teo:ເຕໂຊ
      ter:ເຕເລໂນ
      tet:ເຕຕູມ
      tg:ທາຈິກ
      tgx:ທາກີຊ
      th:ໄທ
      tht:ທາວທັນ
      ti:ຕິກຣິນຢາ
      tig:ໄທກຣີ
      tiv:ຕີວ
      tk:ເທີກເມັນ
      tkl:ໂຕເກເລົາ
      tl:ຕາກາລອກ
      tlh:ຄຣິງກອນ
      tli:ທລີງກິດ
      tmh:ທາມາກເຊກ
      tn:ເຕສະວານາ
      to:ທອງການ
      tog:ນາຍອາຊາຕອງກາ
      tok:ໂທກີໂພນາ
      tpi:ທອກພີຊິນ
      tr:ເທີຄິຊ
      trv:ຕາໂລໂກ
      ts:ເຕຊອງກາ
      tsi:ຊີມຊີແອນ
      tt:ທາທາ
      ttm:ທັດໂຈນເເໜືອ
      tum:ຕຳບູກາ
      tvl:ຕູວາລູ
      tw:ທວີ
      twq:ຕາຊາວັກ
      ty:ຕາຮີຕຽນ
      tyv:ຕູວີນຽນ
      tzm:ອັດລາສ ທາມາຊີກ ກາງ
      udm:ອຸດມັດ
      ug:ອຸຍເຄີ
      uga:ຢູກາລິກ
      uk:ຢູເຄຣນຽນ
      umb:ອຳບັນດູ
      und:ບໍ່ສາມາດລະບຸພາສາ
      ur:ອູຣດູ
      uz:ອຸສເບກ
      vai:ໄວ
      ve:ເວນດາ
      vec:ເວເນຊຽນ
      vi:ຫວຽດນາມ
      vmw:ມາຄູວາ
      vo:ໂວລາພັກ
      vot:ໂວຕິກ
      vun:ວັນໂຈ
      wa:ວໍລູມ
      wae:ວາເຊີ
      wal:ໂວເລຕາ
      war:ວາເລ
      was:ວາໂຊ
      wbp:ວາຣພິຣິ
      wo:ວໍລອບ
      wuu:ຈີນອູ
      xal:ການມິກ
      xh:ໂຮຊາ
      xnr:ຄັງຣີ
      xog:ໂຊກາ
      yao:ເຢົ້າ
      yap:ຢັບ
      yav:ແຍງເບນ
      ybb:ແຢມບາ
      yi:ຢິວ
      yo:ໂຢຣູບາ
      yrl:ນີນກາຕູ
      yue:ກວາງຕຸ້ງ
      yue-alt-menu:ພາສາຈີນ, ຈີນກວາງຕຸ້ງ
      za:ຊວາງ
      zap:ຊາໂປແຕບ
      zbl:ສັນຍາລັກບລີຊິມ
      zen:ເຊນາກາ
      zgh:ໂມຣັອກແຄນ ທາມາຊີກ ມາດຕະຖານ
      zh:ຈີນ
      zh-alt-menu:ພາສາຈີນ, ພາສາຈີນກາງ
      zh-Hans:ຈີນແບບຮຽບງ່າຍ
      zh-Hans-alt-long:ພາສາຈີນກາງ
      zh-Hant:ຈີນແບບດັ້ງເດີມ
      zh-Hant-alt-long:ພາສາຈີນແມນດາຣິນດັ້ງເດີມ
      zu:ຊູລູ
      zun:ຊູນີ
      zxx:ບໍ່ມີເນື້ອຫາພາສາ
      zza:ຊາຊາ
      """.trimIndent() }

  val lrc: String by lazy { """
      ab:آذأربایئجانی
      af:آفریکانس
      agq:آقئم
      ak:آکان
      am:أمھأری
      ar:أرأڤی
      ar-001:عروی مدرن
      arn:ماپوٙچئ
      as:آسامی
      asa:آسوٙ
      az:آذأربایئجانی ھارگە
      az-alt-short:آذأری
      az-Arab:آذأری ھارگە
      ba:باشکیری
      be:بئلاروٙسی
      bem:بیما
      bez:بئنا
      bg:بولغاری
      bgn:بألوٙچی أقتوٙنئشین
      bm:بامبارا
      bn:بأنگالی
      bo:تأبأتی
      br:بئرئتون
      brx:بودو
      bs:بوسنیایی
      ca:کاتالان
      ce:چئچئنی
      cgg:چیگا
      chr:چوروٙکی
      ckb:کوردی سوٙرانی
      ckb-alt-menu:کوردی سوٙرانی
      ckb-alt-variant:کوردی سوٙرانی
      co:کوریسکان
      cv:چواشی
      cy:ڤئلزی
      da:دانمارکی
      dav:تایتا
      de:آلمانی
      de-AT:آلمانی ئوتریشی
      de-CH:آلمانی سوٙییسی
      dje:زارما
      dsb:سوربی ھاری
      dua:دوٙالا
      dyo:جولا فوٙنیی
      dz:زوٙنگخا
      ebu:ئمبو
      ee:ئڤئ
      el:یوٙنانی
      en:ئینگیلیسی
      en-AU:ئینگیلیسی ئوستارالیایی
      en-CA:ئینگیلیسی کانادایی
      en-GB:ئینگیلیسی بئریتانیایی
      en-GB-alt-short:ئینگیلیسی بئریتانیا گأپ
      en-US:ئینگیلیسی ئمریکایی
      en-US-alt-short:ئینگیلیسی ئمریکایی
      eo:ئسپئرانتو
      es:ئسپانیایی
      es-419:ئسپانیایی ئمریکا لاتین
      es-ES:ئسپانیایی ئوروٙپا
      es-MX:ئسپانیایی مئکزیک
      et:ئستونیایی
      eu:باسکی
      fa:فارسی
      fi:فأنلاندی
      fil:فیلیپینی
      fj:فیجی
      fo:فاروٙسی
      fr:فآرانسئ ئی
      fr-CA:فآرانسئ ئی کانادا
      fr-CH:فآرانسئ ئی سوٙییس
      fy:فئریسی أفتونئشین
      ga:ئیرلأندی
      gag:گاگائوز
      gl:گالیسی
      gn:گوٙآرانی
      gsw:آلمانی سوٙئیسی
      gu:گوجأراتی
      guz:گوٙسی
      gv:مانکس
      ha:ھائوسا
      haw:ھاڤایی
      he:عئبری
      hi:ھئنی
      hr:کوروڤاتی
      hsb:سوربی ڤارو
      ht:ھاییتی
      hu:مأجاری
      hy:أرمأنی
      id:أندونئزیایی
      ig:ئیگبو
      ii:سی چوان یی
      is:ئیسلأندی
      it:ئیتالیایی
      iu:ئینوکتیتوٙت
      ja:جاپوٙنی
      jgo:نئگوٙمبا
      jmc:ماچامئ
      jv:جاڤئ یی
      ka:گورجی
      kab:کابیلئ
      kam:کامبا
      kde:ماکوٙندئ
      kea:کاباردینو
      khq:کی یورا چینی
      ki:کیکیوٙ
      kk:قأزاق
      kl:کالالیسوٙت
      kln:کالئجین
      km:خئمئر
      kn:کاناد
      ko:کورئ یی
      koi:کومی پئرمیاک
      kok:کوٙنکانی
      ks:کأشمیری
      ksb:شامبالا
      ksf:بافیا
      ku:کوردی کورمانجی
      kw:کورنیش
      ky:قئرقیزی
      la:لاتین
      lag:لانگی
      lb:لوٙکزامبوٙرگی
      lg:گاندا
      lkt:لاکوٙتا
      ln:لینگالا
      lo:لاو
      lrc:لۊری شومالی
      lt:لیتوڤانیایی
      lu:لوٙبا کاتانگا
      luo:لوٙ
      luy:لوٙئیا
      lv:لاتوڤیایی
      mas:ماسایی
      mer:مئرو
      mfe:موٙریسی
      mg:مالاگاشی
      mgh:ماخوڤا میتو
      mgo:مئتاٛ
      mi:مائوری
      mk:مأقدوٙنی
      ml:مالایام
      mn:موغولی
      moh:موٙھاڤک
      mr:مأراتی
      ms:مالایی
      mt:مالتی
      mua:موٙندانگ
      my:بئرمئ یی
      mzn:مازأندأرانی
      naq:ناما
      nb:نورڤئجی بوٙکمال
      nd:نئدئبئلئ شومالی
      nds:آلمانی ھاری
      nds-NL:آلمانی ھارگە جا
      ne:نئپالی
      nl:ھولأندی
      nl-BE:فئلاماندی
      nmg:کئڤاسیوٙ
      nn:نورڤئجی نینورسک
      nqo:نئکوٙ
      nus:نیوٙئر
      nyn:نیان کوٙلئ
      om:ئوروموٙ
      or:ئوریا
      pa:پأنجابی
      pl:لأھئستانی
      ps:پأشتوٙ
      pt:پورتئغالی
      pt-BR:پورتئغالی بئرئزیل
      pt-PT:پورتئغالی ئوروٙپایی
      qu:کوچوٙا
      quc:کیچی
      rm:رومانش
      rn:راندی
      ro:رومانیایی
      ro-MD:رومانیایی مولداڤی
      rof:رومبو
      ru:روٙسی
      rw:کینیاروآندا
      rwk:رئڤا
      sa:سانسکئریت
      saq:سامبوٙروٙ
      sbp:سانگوٙ
      sd:سئندی
      sdh:کوردی ھارگە
      se:سامی شومالی
      seh:سئنا
      ses:کیارابورو سئنی
      sg:سانگو
      shi:تاچئلھیت
      si:سینھالا
      sk:ئسلوڤاکی
      sl:ئسلوڤئنیایی
      sma:سامی ھارگە
      smj:لۉلئ سامی
      smn:ئیناری سامی
      sms:ئسکولت سامی
      sn:شونا
      so:سوٙمالی
      sq:آلبانی
      sr:سئربی
      su:سوٙدانی
      sv:سوٙئدی
      sw:سأڤاحیلی
      sw-CD:سأڤاحیلی کونگو
      ta:تامیل
      te:تئلئگو
      teo:تئسو
      tg:تاجیکی
      th:تایلأندی
      ti:تیگرینیا
      tk:تورکأمأنی
      to:توٙنگان
      tr:تورکی
      tt:تاتار
      twq:تاساڤاق
      tzm:تامازیغ مینجایی
      ug:ئویغوٙر
      uk:ئوکراینی
      und:زوٙن نادیار
      ur:ئوردوٙ
      uz:ئوزبأکی
      vai:ڤای
      vi:ڤییئتنامی
      vun:ڤوٙنجوٙ
      wbp:ڤارلپیری
      wo:ڤولوف
      xh:خوٙسا
      xog:سوٙگا
      yo:یوروبا
      zgh:تامازیغ مأراکئشی
      zh:چینی
      zh-alt-menu:چینی
      zh-Hans:چینی سادە بیە
      zh-Hans-alt-long:چینی سادە بیە
      zh-Hant:چینی سونأتی
      zh-Hant-alt-long:چینی سونأتی
      zu:زولو
      zxx:بی نئشوٙ
      """.trimIndent() }

  val lrc_IQ: String? = null

  val lt: String by lazy { """
      aa:afarų
      ab:abchazų
      ace:ačinezų
      ach:akolių
      ada:adangmų
      ady:adygėjų
      ae:avestų
      aeb:Tuniso arabų
      af:afrikanų
      afh:afrihili
      agq:aghemų
      ain:ainų
      ak:akanų
      akk:akadianų
      akz:alabamiečių
      ale:aleutų
      aln:albanų kalbos gegų tarmė
      alt:pietų Altajaus
      am:amharų
      an:aragonesų
      ang:senoji anglų
      ann:obolų
      anp:angikų
      ar:arabų
      ar-001:šiuolaikinė standartinė arabų
      arc:aramaikų
      arn:mapudungunų
      aro:araonų
      arp:arapahų
      arq:Alžyro arabų
      ars:arabų najdi
      arw:aravakų
      ary:Maroko arabų
      arz:Egipto arabų
      as:asamų
      asa:asu
      ase:Amerikos ženklų kalba
      ast:asturianų
      atj:atikamekų
      av:avarikų
      avk:kotava
      awa:avadhi
      ay:aimarų
      az:azerbaidžaniečių
      az-alt-short:azeri
      ba:baškirų
      bal:baluči
      ban:baliečių
      bar:bavarų
      bas:basų
      bax:bamunų
      bbc:batak toba
      bbj:ghomalų
      be:baltarusių
      bej:bėjų
      bem:bembų
      bew:betavi
      bez:benų
      bfd:bafutų
      bfq:badaga
      bg:bulgarų
      bgc:harijanvi
      bgn:vakarų beludžių
      bho:baučpuri
      bi:bislama
      bik:bikolų
      bin:bini
      bjn:bandžarų
      bkm:komų
      bla:siksikų
      blo:guanų
      bm:bambarų
      bn:bengalų
      bo:tibetiečių
      bpy:bišnuprijos
      bqi:bakhtiari
      br:bretonų
      bra:brajų
      brh:brahujų
      brx:bodo
      bs:bosnių
      bss:akūsų
      bua:buriatų
      bug:buginezų
      bum:bulu
      byn:blin
      byv:medumbų
      ca:katalonų
      cad:kado
      car:karibų
      cay:kaijūgų
      cch:atsamų
      ccp:Čakma
      ce:čečėnų
      ceb:sebuanų
      cgg:čigų
      ch:čamorų
      chb:čibčų
      chg:čagatų
      chk:čukesų
      chm:marių
      chn:činuk žargonas
      cho:čoktau
      chp:čipvėjų
      chr:čerokių
      chy:čajenų
      ckb:soranių kurdų
      ckb-alt-menu:soranių kurdų
      ckb-alt-variant:soranių kurdų
      clc:čilkotinų
      co:korsikiečių
      cop:koptų
      cps:capiznon
      cr:kry
      crg:metisų
      crh:Krymo turkų
      crj:pietryčių kri
      crk:supraprastinta kri
      crl:šiaurės rytų kri
      crm:muskri
      crr:pamlikų
      crs:Seišelių kreolų ir prancūzų
      cs:čekų
      csb:kašubų
      csw:pelkynų kri
      cu:bažnytinė slavų
      cv:čiuvašų
      cy:valų
      da:danų
      dak:dakotų
      dar:dargva
      dav:taitų
      de:vokiečių
      de-AT:Austrijos vokiečių
      de-CH:Šveicarijos aukštutinė vokiečių
      del:delavero
      den:slave
      dgr:dogribų
      din:dinkų
      dje:zarmų
      doi:dogri
      dsb:žemutinių sorbų
      dtp:centrinio Dusuno
      dua:dualų
      dum:Vidurio Vokietijos
      dv:divehų
      dyo:džiola-foni
      dyu:dyulų
      dz:botijų
      dzg:dazagų
      ebu:embu
      ee:evių
      efi:efik
      egl:italų kalbos Emilijos tarmė
      egy:senovės egiptiečių
      eka:ekajuk
      el:graikų
      elx:elamitų
      en:anglų
      en-AU:Australijos anglų
      en-CA:Kanados anglų
      en-GB:Didžiosios Britanijos anglų
      en-GB-alt-short:anglų (JK)
      en-US:Jungtinių Valstijų anglų
      en-US-alt-short:anglų (JAV)
      enm:Vidurio Anglijos
      eo:esperanto
      es:ispanų
      esu:centrinės Aliaskos jupikų
      et:estų
      eu:baskų
      ewo:evondo
      ext:ispanų kalbos Ekstremadūros tarmė
      fa:persų
      fan:fangų
      fat:fanti
      ff:fulahų
      fi:suomių
      fil:filipiniečių
      fit:suomių kalbos Tornedalio tarmė
      fj:fidžių
      fo:farerų
      fon:fon
      fr:prancūzų
      fr-CA:Kanados prancūzų
      fr-CH:Šveicarijos prancūzų
      frc:kadžunų prancūzų
      frm:Vidurio Prancūzijos
      fro:senoji prancūzų
      frp:arpitano
      frr:šiaurinių fryzų
      frs:rytų fryzų
      fur:friulių
      fy:vakarų fryzų
      ga:airių
      gaa:ga
      gag:gagaūzų
      gan:kinų kalbos dziangsi tarmė
      gay:gajo
      gba:gbaja
      gbz:zoroastrų dari
      gd:škotų (gėlų)
      gez:gyz
      gil:kiribati
      gl:galisų
      glk:gilaki
      gmh:Vidurio Aukštosios Vokietijos
      gn:gvaranių
      goh:senoji Aukštosios Vokietijos
      gon:gondi
      gor:gorontalo
      got:gotų
      grb:grebo
      grc:senovės graikų
      gsw:Šveicarijos vokiečių
      gu:gudžaratų
      guc:vajų
      gur:frafra
      guz:gusi
      gv:meniečių
      gwi:gvičino
      ha:hausų
      hai:haido
      hak:kinų kalbos hakų tarmė
      haw:havajiečių
      hax:Pietų Haidos
      he:hebrajų
      hi:hindi
      hif:Fidžio hindi
      hil:hiligainonų
      hit:hititų
      hmn:hmong
      ho:hiri motu
      hr:kroatų
      hsb:aukštutinių sorbų
      hsn:kinų kalbos hunano tarmė
      ht:Haičio
      hu:vengrų
      hup:hupa
      hur:halkomelemų
      hy:armėnų
      hz:hererų
      ia:tarpinė
      iba:iban
      ibb:ibibijų
      id:indoneziečių
      ie:interkalba
      ig:igbų
      ii:sičuan ji
      ik:inupiakų
      ikt:vakarų kanadiečių inuktitutas
      ilo:ilokų
      inh:ingušų
      io:ido
      is:islandų
      it:italų
      iu:inukitut
      izh:ingrų
      ja:japonų
      jam:Jamaikos kreolų anglų
      jbo:loiban
      jgo:ngombų
      jmc:mačamų
      jpr:judėjų persų
      jrb:judėjų arabų
      jut:danų kalbos jutų tarmė
      jv:javiečių
      ka:gruzinų
      kaa:karakalpakų
      kab:kebailų
      kac:kačinų
      kaj:ju
      kam:kembų
      kaw:kavių
      kbd:kabardinų
      kbl:kanembų
      kcg:tyap
      kde:makondų
      kea:Žaliojo Kyšulio kreolų
      ken:kenyang
      kfo:koro
      kg:Kongo
      kgp:kaingang
      kha:kasi
      kho:kotanezų
      khq:kojra čini
      khw:khovarų
      ki:kikujų
      kiu:kirmanjki
      kj:kuaniama
      kk:kazachų
      kkj:kako
      kl:kalalisut
      kln:kalenjinų
      km:khmerų
      kmb:kimbundu
      kn:kanadų
      ko:korėjiečių
      koi:komių-permių
      kok:konkanių
      kos:kosreanų
      kpe:kpelių
      kr:kanurių
      krc:karačiajų balkarijos
      kri:krio
      krj:kinaray-a
      krl:karelų
      kru:kuruk
      ks:kašmyrų
      ksb:šambalų
      ksf:bafų
      ksh:kolognų
      ku:kurdų
      kum:kumikų
      kut:kutenai
      kv:komi
      kw:kornų
      kwk:kvakvalų
      kxv:kuvi
      ky:kirgizų
      la:lotynų
      lad:ladino
      lag:langi
      lah:landa
      lam:lamba
      lb:liuksemburgiečių
      lez:lezginų
      lfn:naujoji frankų kalba
      lg:ganda
      li:limburgiečių
      lij:ligūrų
      lil:liluetų
      liv:lyvių
      lkt:lakotų
      lmo:lombardų
      ln:ngalų
      lo:laosiečių
      lol:mongų
      lou:Luizianos kreolų
      loz:lozių
      lrc:šiaurės luri
      lsm:samių
      lt:lietuvių
      ltg:latgalių
      lu:luba katanga
      lua:luba lulua
      lui:luiseno
      lun:Lundos
      lus:mizo
      luy:luja
      lv:latvių
      lzh:klasikinė kinų
      lzz:laz
      mad:madurezų
      maf:mafų
      mag:magahi
      mai:maithili
      mak:Makasaro
      man:mandingų
      mas:masajų
      mde:mabų
      mdf:mokša
      mdr:mandarų
      men:mende
      mer:merų
      mfe:morisijų
      mg:malagasų
      mga:Vidurio Airijos
      mgh:makua-maeto
      mgo:meta
      mh:Maršalo Salų
      mi:maorių
      mic:mikmakų
      min:minangkabau
      mk:makedonų
      ml:malajalių
      mn:mongolų
      mnc:manču
      mni:manipurių
      moe:montanjų
      moh:mohok
      mos:mosi
      mr:maratų
      mrj:vakarų mari
      ms:malajiečių
      mt:maltiečių
      mua:mundangų
      mul:kelios kalbos
      mus:krykų
      mwl:mirandezų
      mwr:marvari
      mwv:mentavai
      my:birmiečių
      mye:mjenų
      myv:erzyjų
      mzn:mazenderanių
      na:naurų
      nan:kinų kalbos pietų minų tarmė
      nap:neapoliečių
      naq:nama
      nb:norvegų bukmolas
      nd:šiaurės ndebelų
      nds:Žemutinės Vokietijos
      nds-NL:Žemutinės Saksonijos (Nyderlandai)
      ne:nepaliečių
      new:nevari
      ng:ndongų
      nia:nias
      niu:niujiečių
      njo:ao naga
      nl:olandų
      nl-BE:flamandų
      nmg:kvasių
      nn:naujoji norvegų
      nnh:ngiembūnų
      no:norvegų
      nog:nogų
      non:senoji norsų
      nov:novial
      nqo:enko
      nr:pietų ndebele
      nso:šiaurės Soto
      nus:nuerų
      nv:navajų
      nwc:klasikinė nevari
      ny:nianjų
      nym:niamvezi
      nyn:niankolų
      nyo:niorų
      nzi:nzima
      oc:očitarų
      oj:ojibva
      ojb:šiaurės vakarų odžibvių
      ojc:ojibvų
      ojs:odži kri
      ojw:vakarų odžibvių
      oka:okanaganų
      om:oromų
      or:odijų
      os:osetinų
      osa:osage
      ota:osmanų turkų
      pa:pendžabų
      pag:pangasinanų
      pal:vidurinė persų kalba
      pam:pampangų
      pap:papiamento
      pau:palauliečių
      pcd:pikardų
      pcm:Nigerijos pidžinų
      pdc:Pensilvanijos vokiečių
      pdt:vokiečių kalbos žemaičių tarmė
      peo:senoji persų
      pfl:vokiečių kalbos Pfalco tarmė
      phn:finikiečių
      pi:pali
      pis:pidžinų
      pl:lenkų
      pms:italų kalbos Pjemonto tarmė
      pnt:Ponto
      pon:Ponapės
      pqm:Maliset-Pasamakvodžio
      prg:prūsų
      pro:senovės provansalų
      ps:puštūnų
      pt:portugalų
      qu:kečujų
      quc:kičių
      qug:Čimboraso aukštumų kečujų
      raj:Radžastano
      rap:rapanui
      rar:rarotonganų
      rgn:italų kalbos Romanijos tarmė
      rhg:rochindža
      rif:rifų
      rm:retoromanų
      rn:rundi
      ro:rumunų
      ro-MD:moldavų
      rof:rombo
      rom:romų
      rtm:rotumanų
      ru:rusų
      rue:rusinų
      rug:Rovianos
      rup:aromanių
      rw:kinjaruandų
      rwk:rua
      sa:sanskritas
      sad:sandavių
      sah:jakutų
      sam:samarėjų aramių
      saq:sambūrų
      sas:sasak
      sat:santalių
      saz:sauraštrų
      sba:ngambajų
      sbp:sangų
      sc:sardiniečių
      scn:siciliečių
      sco:škotų
      sd:sindų
      sdc:sasaresų sardinų
      sdh:pietų kurdų
      se:šiaurės samių
      see:senecų
      seh:senų
      sei:seri
      sel:selkup
      ses:kojraboro seni
      sg:sango
      sga:senoji airių
      sgs:žemaičių
      sh:serbų-kroatų
      shi:tachelhitų
      shn:šan
      shu:chadian arabų
      si:sinhalų
      sid:sidamų
      sk:slovakų
      sl:slovėnų
      slh:pietų lushusidų
      sli:sileziečių žemaičių
      sly:selajarų
      sm:Samoa
      sma:pietų samių
      smj:Liuleo samių
      smn:Inario samių
      sms:Skolto samių
      sn:šonų
      snk:soninke
      so:somaliečių
      sog:sogdien
      sq:albanų
      sr:serbų
      srn:sranan tongo
      srr:sererų
      ss:svatų
      ssy:saho
      st:pietų Soto
      stq:Saterlendo fryzų
      str:Sališo sąsiaurio
      su:sundų
      suk:sukuma
      sus:susu
      sux:šumerų
      sv:švedų
      sw:suahilių
      sw-CD:Kongo suahilių
      swb:komorų
      syc:klasikinė sirų
      syr:sirų
      szl:sileziečių
      ta:tamilų
      tce:pietų tučonų
      tcy:tulų
      te:telugų
      tem:timne
      teo:teso
      ter:Tereno
      tet:tetum
      tg:tadžikų
      tgx:tagišų
      th:tajų
      tht:taltanų
      ti:tigrajų
      tig:tigre
      tiv:tiv
      tk:turkmėnų
      tkl:Tokelau
      tkr:tsakurų
      tl:tagalogų
      tlh:klingonų
      tli:tlingitų
      tly:talyšų
      tmh:tamašek
      tn:tsvanų
      to:tonganų
      tog:niasa tongų
      tok:Toki Pona
      tpi:Papua pidžinų
      tr:turkų
      tru:turoyo
      trv:Taroko
      ts:tsongų
      tsd:tsakonų
      tsi:tsimšian
      tt:totorių
      ttm:šiaurės tutsonų
      ttt:musulmonų tatų
      tum:tumbukų
      tvl:Tuvalu
      tw:tvi
      twq:tasavakų
      ty:taitiečių
      tyv:tuvių
      tzm:Centrinio Maroko tamazitų
      udm:udmurtų
      ug:uigūrų
      uga:ugaritų
      uk:ukrainiečių
      umb:umbundu
      und:nežinoma kalba
      ur:urdų
      uz:uzbekų
      ve:vendų
      vec:venetų
      vep:vepsų
      vi:vietnamiečių
      vls:vakarų flamandų
      vmf:pagrindinė frankonų
      vmw:makua
      vo:volapiuko
      vot:Votik
      vro:veru
      vun:vunjo
      wa:valonų
      wae:valserų
      wal:valamo
      war:varai
      was:Vašo
      wbp:valrpiri
      wo:volofų
      wuu:kinų kalbos vu tarmė
      xal:kalmukų
      xh:kosų
      xmf:megrelų
      xnr:kangri
      xog:sogų
      yao:jao
      yap:japezų
      yav:jangbenų
      ybb:jembų
      yi:jidiš
      yo:jorubų
      yrl:njengatu
      yue:kinų kalbos Kantono tarmė
      yue-alt-menu:kinų kalbos Kantono tarmė
      za:chuang
      zap:zapotekų
      zbl:BLISS simbolių
      zea:zelandų
      zen:zenaga
      zgh:standartinė Maroko tamazigtų
      zh:kinų
      zh-alt-menu:kinų, mandarinų
      zh-Hans:supaprastintoji kinų
      zh-Hans-alt-long:supaprastintoji mandarinų kinų
      zh-Hant:tradicinė kinų
      zh-Hant-alt-long:tradicinė mandarinų kinų
      zu:zulų
      zun:Zuni
      zxx:nėra kalbinio turinio
      zza:zaza
      """.trimIndent() }

  val lu: String by lazy { """
      ak:Liakan
      am:Liamhariki
      ar:Arabi
      be:Belarusi
      bg:Bulegari
      bn:Bengali
      cs:Tsheki
      de:Lizelumani
      el:Giliki
      en:Lingelesa
      es:Lihispania
      fa:Mpepajemi
      fr:Mfwàlànsa
      ha:Hausa
      hi:Hindi
      hu:Hongili
      id:Lindonezia
      ig:Igbo
      it:Litali
      ja:Liyapani
      jv:Java
      ko:Likoreya
      lu:Tshiluba
      ms:Limalezia
      ne:nepali
      nl:olandi
      pa:Lipunjabi
      pl:Mpoloni
      pt:Mputulugɛsi
      ro:Liromani
      ru:Lirisi
      rw:kinyarwanda
      so:Lisomali
      sv:Lisuwidi
      ta:Mtamuili
      th:Ntailandi
      tr:Ntuluki
      uk:Nkrani
      ur:Urdu
      vi:Liviyetinamu
      yo:Nyoruba
      zh:shinɛ
      zh-alt-menu:shinɛ
      zu:Nzulu
      """.trimIndent() }

  val luo: String by lazy { """
      ak:Kiakan
      am:Kiamhari
      ar:Kiarabu
      be:Kibelarusi
      bg:Kibulgaria
      bn:Kibangla
      cs:Kichecki
      de:Kijerumani
      el:Kigiriki
      en:Kingereza
      es:Kihispania
      fa:Kiajemi
      fr:Kifaransa
      ha:Kihausa
      hi:Kihindi
      hu:Kihungari
      id:Kiindonesia
      ig:Kiigbo
      it:Kiitaliano
      ja:Kijapani
      jv:Kijava
      km:Kikambodia
      ko:Kikorea
      luo:Dholuo
      ms:Kimalesia
      my:Kiburma
      ne:Kinepali
      nl:Kiholanzi
      pa:Kipunjabi
      pl:Kipolandi
      pt:Kireno
      ro:Kiromania
      ru:Kirusi
      rw:Kinyarwanda
      so:Kisomali
      sv:Kiswidi
      ta:Kitamil
      th:Kitailandi
      tr:Kituruki
      uk:Kiukrania
      ur:Kiurdu
      vi:Kivietinamu
      yo:Kiyoruba
      zh:Kichina
      zh-alt-menu:Kichina
      zu:Kizulu
      """.trimIndent() }

  val luy: String by lazy { """
      ak:Kiakan
      am:Kiamhari
      ar:Kiarabu
      be:Kibelarusi
      bg:Kibulgaria
      bn:Kibangla
      cs:Kichecki
      de:Kijerumani
      el:Kigiriki
      en:Lusungu
      es:Kihispania
      fa:Kiajemi
      fr:Kifaransa
      ha:Kihausa
      hi:Luhindi
      hu:Kihungari
      id:Kiindonesia
      ig:Kiigbo
      it:Kiitaliano
      ja:Kijapani
      jv:Kijava
      km:Kikambodia
      ko:Kikorea
      luy:Luluhia
      ms:Kimalesia
      my:Kiburma
      ne:Kinepali
      nl:Kiholanzi
      pa:Kipunjabi
      pl:Kipolandi
      pt:Kireno
      ro:Kiromania
      ru:Kirusi
      rw:Kinyarwanda
      so:Kisomali
      sv:Kiswidi
      ta:Kitamil
      th:Kitailandi
      tr:Kituruki
      uk:Kiukrania
      ur:Kiurdu
      vi:Kivietinamu
      yo:Kiyoruba
      zh:Kichina
      zh-alt-menu:Kichina
      zu:Kizulu
      """.trimIndent() }

  val lv: String by lazy { """
      aa:afāru
      ab:abhāzu
      ace:ačinu
      ach:ačolu
      ada:adangmu
      ady:adigu
      ae:avesta
      af:afrikandu
      afh:afrihili
      agq:aghemu
      ain:ainu
      ak:akanu
      akk:akadiešu
      ale:aleutu
      alt:dienvidaltajiešu
      am:amharu
      an:aragoniešu
      ang:senangļu
      ann:obolo
      anp:angika
      ar:arābu
      ar-001:mūsdienu standarta arābu
      arc:aramiešu
      arn:araukāņu
      arp:arapahu
      ars:ņedžu arābu
      arw:aravaku
      as:asamiešu
      asa:asu
      ast:astūriešu
      atj:atikameku
      av:avāru
      awa:avadhu
      ay:aimaru
      az:azerbaidžāņu
      az-alt-short:azerbaidžāņu
      az-Arab:dienvidazerbaidžāņu
      ba:baškīru
      bal:beludžu
      ban:baliešu
      bas:basu
      bax:bamumu
      bbj:gomalu
      be:baltkrievu
      bej:bedžu
      bem:bembu
      bez:bena
      bfd:bafutu
      bg:bulgāru
      bgc:harjanvi
      bgn:rietumbeludžu
      bho:bhodžpūru
      bi:bišlamā
      bik:bikolu
      bin:binu
      bkm:komu
      bla:siksiku
      blo:anī
      bm:bambaru
      bn:bengāļu
      bo:tibetiešu
      br:bretoņu
      bra:bradžiešu
      brx:bodo
      bs:bosniešu
      bss:nkosi
      bua:burjatu
      bug:bugu
      bum:bulu
      byn:bilinu
      byv:medumbu
      ca:katalāņu
      cad:kadu
      car:karību
      cay:kajuga
      cch:atsamu
      ccp:čakmu
      ce:čečenu
      ceb:sebuāņu
      cgg:kiga
      ch:čamorru
      chb:čibču
      chg:džagatajs
      chk:čūku
      chm:mariešu
      chn:činuku žargons
      cho:čoktavu
      chp:čipevaianu
      chr:čiroku
      chy:šejenu
      ckb:centrālkurdu
      ckb-alt-menu:centrālkurdu
      ckb-alt-variant:sorani kurdu
      clc:čilkotīnu
      co:korsikāņu
      cop:koptu
      cr:krī
      crg:mičifu
      crh:Krimas tatāru
      crj:dienvidaustrumu krī
      crk:līdzenumu krī
      crl:ziemeļaustrumu krī
      crm:mūsu krī
      crr:Karolīnas algonkinu
      crs:franciskā kreoliskā valoda (Seišelu salas)
      cs:čehu
      csb:kašubu
      csw:purvu krī
      cu:baznīcslāvu
      cv:čuvašu
      cy:velsiešu
      da:dāņu
      dak:dakotu
      dar:dargu
      dav:taitu
      de:vācu
      de-CH:augšvācu (Šveice)
      del:delavēru
      den:sleivu
      dgr:dogribu
      din:dinku
      dje:zarmu
      doi:dogru
      dsb:lejassorbu
      dua:dualu
      dum:vidusholandiešu
      dv:maldīviešu
      dyo:diola-fonjī
      dyu:diūlu
      dz:dzongke
      dzg:dazu
      ebu:kjembu
      ee:evu
      efi:efiku
      egy:ēģiptiešu
      eka:ekadžuku
      el:grieķu
      elx:elamiešu
      en:angļu
      en-GB:angļu (Lielbritānija)
      en-GB-alt-short:angļu (Lielbritānija)
      enm:vidusangļu
      eo:esperanto
      es:spāņu
      et:igauņu
      eu:basku
      ewo:evondu
      fa:persiešu
      fa-AF:darī
      fan:fangu
      fat:fantu
      ff:fulu
      fi:somu
      fil:filipīniešu
      fj:fidžiešu
      fo:fēru
      fon:fonu
      fr:franču
      frc:kadžūnu franču
      frm:vidusfranču
      fro:senfranču
      frr:ziemeļfrīzu
      frs:austrumfrīzu
      fur:friūlu
      fy:rietumfrīzu
      ga:īru
      gaa:ga
      gag:gagauzu
      gay:gajo
      gba:gbaju
      gd:skotu gēlu
      gez:gēzu
      gil:kiribatiešu
      gl:galisiešu
      gmh:vidusaugšvācu
      gn:gvaranu
      goh:senaugšvācu
      gon:gondu valodas
      gor:gorontalu
      got:gotu
      grb:grebo
      grc:sengrieķu
      gsw:Šveices vācu
      gu:gudžaratu
      guz:gusii
      gv:meniešu
      gwi:kučinu
      ha:hausu
      hai:haidu
      haw:havajiešu
      hax:dienvidhaidu
      he:ivrits
      hi:hindi
      hi-Latn-alt-variant:hinglišs
      hil:hiligainonu
      hit:hetu
      hmn:hmongu
      ho:hirimotu
      hr:horvātu
      hsb:augšsorbu
      ht:haitiešu
      hu:ungāru
      hup:hupu
      hur:halkomelenu
      hy:armēņu
      hz:hereru
      ia:interlingva
      iba:ibanu
      ibb:ibibio
      id:indonēziešu
      ie:interlingve
      ig:igbo
      ii:Sičuaņas ji
      ik:inupiaku
      ikt:Rietumkanādas inuītu
      ilo:iloku
      inh:ingušu
      io:ido
      is:islandiešu
      it:itāļu
      iu:inuītu
      ja:japāņu
      jbo:ložbans
      jgo:ngomba
      jmc:mačamu
      jpr:jūdpersiešu
      jrb:jūdarābu
      jv:javiešu
      ka:gruzīnu
      kaa:karakalpaku
      kab:kabilu
      kac:kačinu
      kaj:kadži
      kam:kambu
      kaw:kāvi
      kbd:kabardiešu
      kbl:kaņembu
      kcg:katabu
      kde:makonde
      kea:kaboverdiešu
      kfo:koru
      kg:kongu
      kgp:kaingangs
      kha:khasu
      kho:hotaniešu
      khq:koiračiinī
      ki:kikuju
      kj:kvaņamu
      kk:kazahu
      kkj:kako
      kl:grenlandiešu
      kln:kalendžīnu
      km:khmeru
      kmb:kimbundu
      kn:kannadu
      ko:korejiešu
      koi:komiešu-permiešu
      kok:konkanu
      kos:kosrājiešu
      kpe:kpellu
      kr:kanuru
      krc:karačaju un balkāru
      krl:karēļu
      kru:kuruhu
      ks:kašmiriešu
      ksb:šambalu
      ksf:bafiju
      ksh:Ķelnes vācu
      ku:kurdu
      kum:kumiku
      kut:kutenaju
      kv:komiešu
      kw:korniešu
      kwk:kvakvala
      kxv:kuvi
      ky:kirgīzu
      la:latīņu
      lad:ladino
      lag:langi
      lah:landu
      lam:lambu
      lb:luksemburgiešu
      lez:lezgīnu
      lg:gandu
      li:limburgiešu
      lij:ligūriešu
      lil:lilluetu
      lkt:lakotu
      lmo:lombardiešu
      ln:lingala
      lo:laosiešu
      lol:mongu
      lou:Luiziānas kreolu
      loz:lozu
      lrc:ziemeļluru
      lsm:sāmia
      lt:lietuviešu
      lu:lubakatanga
      lua:lubalulva
      lui:luisenu
      lun:lundu
      lus:lušeju
      luy:luhju
      lv:latviešu
      mad:maduriešu
      maf:mafu
      mag:magahiešu
      mai:maithili
      mak:makasaru
      man:mandingu
      mas:masaju
      mde:mabu
      mdf:mokšu
      mdr:mandaru
      men:mendu
      mer:meru
      mfe:Maurīcijas kreolu
      mg:malagasu
      mga:vidusīru
      mgh:makua-mīto
      mgo:metu
      mh:māršaliešu
      mi:maoru
      mic:mikmaku
      min:minangkabavu
      mk:maķedoniešu
      ml:malajalu
      mn:mongoļu
      mnc:mandžūru
      mni:manipūru
      moe:motanju
      moh:mohauku
      mos:mosu
      mr:marathu
      ms:malajiešu
      mt:maltiešu
      mua:mundangu
      mul:vairākas valodas
      mus:krīku
      mwl:mirandiešu
      mwr:marvaru
      my:birmiešu
      mye:mjenu
      myv:erzju
      mzn:mazanderāņu
      na:nauruiešu
      nap:neapoliešu
      naq:nama
      nb:norvēģu bukmols
      nd:ziemeļndebelu
      nds:lejasvācu
      nds-NL:lejassakšu
      ne:nepāliešu
      new:nevaru
      ng:ndongu
      nia:njasu
      niu:niuāņu
      nl:holandiešu
      nl-BE:flāmu
      nmg:kvasio
      nn:jaunnorvēģu
      nnh:ngjembūnu
      no:norvēģu
      nog:nogaju
      non:sennorvēģu
      nqo:nko
      nr:dienvidndebelu
      nso:ziemeļsotu
      nus:nueru
      nv:navahu
      nwc:klasiskā nevaru
      ny:čičeva
      nym:ņamvezu
      nyn:ņankolu
      nyo:ņoru
      nzi:nzemu
      oc:oksitāņu
      oj:odžibvu
      ojb:ziemeļrietumu odžibvu
      ojc:centrālā odžibvu
      ojs:odži-krī
      ojw:rietumodžibvu
      oka:okanaganu
      om:oromu
      or:oriju
      os:osetīnu
      osa:važāžu
      ota:turku osmaņu
      pa:pandžabu
      pag:pangasinanu
      pal:pehlevi
      pam:pampanganu
      pap:papjamento
      pau:palaviešu
      pcm:Nigērijas pidžinvaloda
      peo:senpersu
      phn:feniķiešu
      pi:pāli
      pis:pidžinvaloda
      pl:poļu
      pon:ponapiešu
      pqm:malisetu-pasamakvodi
      prg:prūšu
      pro:senprovansiešu
      ps:puštu
      pt:portugāļu
      qu:kečvu
      quc:kiče
      raj:radžastāņu
      rap:rapanuju
      rar:rarotongiešu
      rhg:rohindžu
      rm:retoromāņu
      rn:rundu
      ro:rumāņu
      ro-MD:moldāvu
      rof:rombo
      rom:čigānu
      ru:krievu
      rup:aromūnu
      rw:kiņaruanda
      rwk:ruanda
      sa:sanskrits
      sad:sandavu
      sah:jakutu
      sam:Samārijas aramiešu
      saq:samburu
      sas:sasaku
      sat:santalu
      sba:ngambeju
      sbp:sangu
      sc:sardīniešu
      scn:sicīliešu
      sco:skotu
      sd:sindhu
      sdh:dienvidkurdu
      se:ziemeļsāmu
      see:seneku
      seh:senu
      sel:selkupu
      ses:koiraboro senni
      sg:sango
      sga:senīru
      sh:serbu–horvātu
      shi:šilhu
      shn:šanu
      shu:Čadas arābu
      si:singāļu
      sid:sidamu
      sk:slovāku
      sl:slovēņu
      slh:dienvidlušucīdu
      sm:samoāņu
      sma:dienvidsāmu
      smj:Luleo sāmu
      smn:Inari sāmu
      sms:skoltsāmu
      sn:šonu
      snk:soninku
      so:somāļu
      sog:sogdiešu
      sq:albāņu
      sr:serbu
      srn:sranantogo
      srr:serēru
      ss:svatu
      ssy:saho
      st:dienvidsotu
      str:šauruma sališu
      su:zundu
      suk:sukumu
      sus:susu
      sux:šumeru
      sv:zviedru
      sw:svahili
      sw-CD:svahili (Kongo)
      swb:komoru
      syc:klasiskā sīriešu
      syr:sīriešu
      szl:silēziešu
      ta:tamilu
      tce:dienvidtutčonu
      te:telugu
      tem:temnu
      teo:teso
      ter:tereno
      tet:tetumu
      tg:tadžiku
      tgx:tagišu
      th:taju
      tht:tahltanu
      ti:tigrinja
      tig:tigru
      tiv:tivu
      tk:turkmēņu
      tkl:tokelaviešu
      tl:tagalu
      tlh:klingoņu
      tli:tlinkitu
      tmh:tuaregu
      tn:cvanu
      to:tongiešu
      tog:Njasas tongu
      tok:tokiponu
      tpi:tokpisins
      tr:turku
      trv:taroko
      ts:congu
      tsi:cimšiāņu
      tt:tatāru
      ttm:ziemeļu tučonu
      tum:tumbuku
      tvl:tuvaliešu
      tw:tvī
      twq:tasavaku
      ty:taitiešu
      tyv:tuviešu
      tzm:Centrālmarokas tamazīts
      udm:udmurtu
      ug:uiguru
      uga:ugaritiešu
      uk:ukraiņu
      umb:umbundu
      und:nezināma valoda
      ur:urdu
      uz:uzbeku
      vai:vaju
      ve:vendu
      vec:venēciešu
      vi:vjetnamiešu
      vmw:makua
      vo:volapiks
      vot:votu
      vun:vundžo
      wa:valoņu
      wae:Vallisas vācu
      wal:valamu
      war:varaju
      was:vašo
      wbp:varlpirī
      wo:volofu
      wuu:vu ķīniešu
      xal:kalmiku
      xh:khosu
      xnr:kangri
      xog:sogu
      yao:jao
      yap:japiešu
      yav:janbaņu
      ybb:jembu
      yi:jidišs
      yo:jorubu
      yrl:njengatu
      yue:kantoniešu
      yue-alt-menu:ķīniešu (kantoniešu)
      za:džuanu
      zap:sapoteku
      zbl:blissimbolika
      zen:zenagu
      zgh:standarta tamazigtu (Maroka)
      zh:ķīniešu
      zh-alt-menu:ķīniešu (mandarīnu)
      zh-Hans:ķīniešu vienkāršotā
      zh-Hans-alt-long:ķīniešu vienkāršotā (mandarīnu)
      zh-Hant:ķīniešu tradicionālā
      zh-Hant-alt-long:ķīniešu tradicionālā (mandarīnu)
      zu:zulu
      zun:zunju
      zxx:bez lingvistiska satura
      zza:zazaki
      """.trimIndent() }

  val mai: String by lazy { """
      ab:अबखाजियान
      ace:ऐचिनीज
      ada:अदेंग
      ady:अदिगे
      af:अफ्रीकांस
      agq:अगेम
      ain:आयू
      ak:अकेन
      ale:अल्यूट
      alt:दक्षिणी अलटाई
      am:अम्हरिक
      an:अरगोनीज
      ann:ओबोलो
      anp:अंगिका
      ar:अरबी
      ar-001:आधुनिक मानक अरबी
      arn:मापुचे
      arp:अरापहो
      ars:नजदी अरबी
      as:असमी
      asa:असु
      ast:अस्तुरियाई
      atj:अतिकामेक
      av:अवरिक
      awa:अवधी
      ay:आयमरा
      az:अजरबैजानी
      az-alt-short:अजेरी
      ba:बशकीर
      ban:बाली
      bas:बासा
      be:बेलारूसी
      bem:बेम्बा
      bez:बेना
      bg:बुलगेरियाई
      bho:भोजपुरी
      bi:बिसलामा
      bin:बिनी
      bla:सिकसिका
      bm:बमबारा
      bn:बंगाली
      bo:तिब्बती
      br:ब्रेटन
      brx:बोडो
      bs:बोसनियाई
      bug:बगिनीज
      byn:बलिन
      ca:केटालान
      cay:केयुगा
      ccp:चकमा
      ce:चेचेन
      ceb:सेबुयानो
      cgg:चिजिया
      ch:चमोरो
      chk:चुकीज
      chm:मारी
      cho:चोकटाउ
      chp:चिपवायन
      chr:चेरोकी
      chy:शयेन
      ckb:सेंट्रल कुर्दी
      ckb-alt-menu:कुर्दी, सेंट्रल
      ckb-alt-variant:कुर्दी, सोरानी
      clc:चोकोटिन
      co:कोर्शियाई
      crg:मिचिफ
      crj:दक्षिण-पुरबी क्री
      crk:प्लेंस क्री
      crl:उत्तर-पूरबी क्री
      crm:मूज क्री
      crr:केरोलिना अलगोनकुइन
      cs:चेक
      csw:स्वम्पी क्री
      cv:शुवास
      cy:बेल्श
      da:डेनिश
      dak:डकोटा
      dar:डर्गबा
      dav:टैटा
      de:जर्मन
      de-AT:ऑस्ट्रियाई जर्मन
      de-CH:स्विस उच्च जर्मन
      dgr:डोग्रीब
      dje:जरमा
      doi:डोगरी
      dsb:लोअर सोर्बियाई
      dua:डुआला
      dv:डिबेही
      dyo:जोला-फोनी
      dz:जोनखा
      dzg:दजागा
      ebu:एमबु
      ee:इयु
      efi:एफिक
      eka:एकाजुक
      el:यूनानी
      en:अंगरेजी
      en-AU:आस्ट्रेलियाई अंंगरेजी
      en-CA:कनाडाई अंग्रेज़ी
      en-GB:ब्रिटिश अंग्रेज़ी
      en-GB-alt-short:यू॰के॰ अंग्रेज़ी
      en-US:अमेरिकी अंग्रेज़ी
      en-US-alt-short:अमेरिकी अंग्रेज़ी
      eo:एसपेरेंटो
      es:स्पेनिश
      es-419:लैटिन अमेरिकी स्पेनिश
      es-ES:यूरोपीय स्पेनिश
      es-MX:मैक्सिकन स्पेनिश
      et:एसटोनियाई
      eu:बास्क
      ewo:इवोनडो
      fa:परसियन
      fa-AF:परसियन डारी
      ff:फुलाह
      fi:फिनिश
      fil:फिलिपीनो
      fj:फिजी
      fo:फेरोइज
      fon:फोन
      fr:फ़्रेंच
      fr-CA:कनाडाई फ़्रेंच
      fr-CH:स्विस फ़्रेंच
      frc:केजन फ्रांसीसी
      fur:फ्रियूयन
      fy:पश्चिमी फ्रीजन
      ga:आइरिश
      gaa:गा
      gd:स्काउटिस गेलिक
      gez:गीज
      gil:गिलबर्टीज
      gl:गेलिशियन
      gn:गुआरानी
      gor:गोरोंटेलो
      gsw:स्वीस जर्मन
      gu:गुजराती
      guz:गुसी
      gv:मेंक्स
      gwi:गुअचीन
      ha:हउसा
      hai:हैदा
      haw:हवाईयन
      hax:दक्षिणी हैदा
      he:हीब्रू
      hi:हिन्दी
      hi-Latn:हिन्दी (ल्याटिन)
      hi-Latn-alt-variant:हिन्दी (ल्याटिन)
      hil:हिलिगेनन
      hmn:मौंग
      hr:क्रोशियाई
      hsb:उच्च सोर्बियाई
      ht:हैतियाई क्रियोल
      hu:हंगेरियन
      hup:हुपा
      hur:हलकोमैलेम
      hy:अर्मेनियाई
      hz:हैरेरो
      ia:इंटरलिंगुआ
      iba:इबन
      ibb:इबिबियो
      id:इंडोनेशियाई
      ig:इगबो
      ii:सिचुआन यी
      ikt:पश्चिमी कनाडाई इनुकतुत
      ilo:इलोको
      inh:इंगुश
      io:ईडो
      is:आइसलैंडी
      it:इतालवी
      iu:इनुकतितुत
      ja:जापानी
      jbo:लोजबन
      jgo:नेगोमबा
      jmc:मैकेम
      jv:जावानी
      ka:जार्जियाई
      kab:कबाइल
      kac:कचिन
      kaj:जू
      kam:कामबा
      kbd:कबर्दियन
      kcg:टियाप
      kde:मकोंडे
      kea:काबुबरदियानु
      kfo:कोरो
      kgp:कैनगैंग
      kha:खासी
      khq:कोयरा चीनी
      ki:किकुयू
      kj:कुअनयामा
      kk:कजाक
      kkj:काको
      kl:कलालिसुत
      kln:केलैंजिन
      km:खमेर
      kmb:किमबुंडू
      kn:कन्नड़
      ko:कोरियाई
      kok:कोंकणी
      kpe:कपैले
      kr:कनुरी
      krc:करचय-बालकर
      krl:केरैलियन
      kru:कुरूक
      ks:कशमीरी
      ksb:शमबाला
      ksf:बाफिया
      ksh:कोलोनियन
      ku:कुर्दी
      kum:कुमिक
      kv:कोमी
      kw:कोर्निश
      kwk:कुअकवाला
      ky:किर्गिज
      la:लातिन
      lad:लडीनो
      lag:लंगी
      lb:लगजमबर्गी
      lez:लजगियान
      lg:गंडा
      li:लिमबर्गिश
      lil:लिलुइट
      lkt:लकोटा
      ln:लिंगाला
      lo:लाओ
      lou:लुइसियाना क्रियोल
      loz:लोजी
      lrc:उत्तरी लूरी
      lsm:सामिया
      lt:लिथुआनियाई
      lu:लुबा-कटांगा
      lua:लुबा-लुलुआ
      lun:लुंडा
      luo:लुओ
      lus:मिजो
      luy:लुुइया
      lv:लातवियाई
      mad:मदुरीज
      mag:मगही
      mai:मैथिली
      mak:मकसर
      mas:मसाई
      mdf:मोकशा
      men:मेंडे
      mer:मेरू
      mfe:मोरीसेन
      mg:मलगासी
      mgh:मखुआ-मेटो
      mgo:मेटा
      mh:मार्शेलीज
      mi:माओरी
      mic:मिकमक
      min:मिननकबाऊ
      mk:मेसिडोनियाई
      ml:मलयालम
      mn:मोंगोलियाई
      mni:मणिपुरी
      moe:इनु-ऐमन
      moh:मोहौक
      mos:मोसी
      mr:मराठी
      ms:मलय
      mt:मलटीज
      mua:मुंडांग
      mul:एक सं बेसी भाषा
      mus:मसकोगी
      mwl:मिरंडीज
      my:बर्मी
      myv:अरजाया
      mzn:मजनदेरानी
      na:नउरू
      nap:नेपोलिटन
      naq:नामा
      nb:नार्वेजियन बोकमाल
      nd:उत्तरी डेबले
      nds:लो जर्मन
      ne:नेपाली
      new:नेबारी
      ng:एनडोंगा
      nia:नियास
      niu:नियुएन
      nl:डच
      nl-BE:फ्लेमिश
      nmg:कवासियो
      nn:नार्वेजियन निनोरेस्क
      nnh:जियमबून
      no:नार्वेजियन
      nog:नोगई
      nqo:एनको
      nr:दक्षिणी एनडेबेले
      nso:उत्तरी सोथो
      nus:नूअर
      nv:नवाजो
      ny:नींजा
      nyn:नीयनकोले
      oc:औकसीटान
      ojb:उत्तरी-पश्चिम ओजिवा
      ojc:सेंट्रल ओजिबा
      ojs:ओजि-क्री
      ojw:पश्चिमी ओजिबा
      oka:ओकंगान
      om:ओरोमो
      or:उड़िया
      os:ओसेटिक
      pa:पंजाबी
      pag:पैंगासिनान
      pam:पैमपंगा
      pap:पैपियामेंटो
      pau:पलौआन
      pcm:नाइजीरियाई पिजिन
      pis:पिजिन
      pl:पोलिश
      pqm:मलिसीट-पैसमाकोडी
      ps:पश्तो
      pt:पुर्तगाली
      pt-BR:ब्राज़ीली पुर्तगाली
      pt-PT:यूरोपीय पुर्तगाली
      qu:कुएचुआ
      rap:रपानुई
      rar:रेरोटोंगन
      rhg:रोहिंग्या
      rm:रोमांश
      rn:रूंडी
      ro:रोमानियाई
      rof:रोमबो
      ru:रूसी
      rup:अरोमानियाई
      rw:किनयरवांडा
      rwk:रूवा
      sa:संस्कृत
      sad:संदाउ
      sah:सखा
      saq:समबुरू
      sat:संथाली
      sba:नामबे
      sbp:सांगू
      sc:सार्डिनियाई
      scn:सिसिलियाई
      sco:स्काउट्स
      sd:सिंधी
      se:उत्तरी सामी
      seh:सेना
      ses:कोयराबोरो सैनी
      sg:सांगो
      shi:टेचलहिट
      shn:शान
      si:सिंहला
      sk:स्लोबाक
      sl:स्लोबेनियाई
      slh:दक्षिणी लसूटसीड
      sm:समोअन
      smn:इनारी सामी
      sms:स्कोल्ट समी
      sn:शोना
      snk:सोनिनके
      so:सोमाली
      sq:अलबानिया
      sr:सर्बियाई
      srn:श्रेनन टोंगो
      ss:स्वाती
      st:दक्षिणी सोथो
      str:स्ट्रेट्स सैलिस
      su:सुंदनेजे
      suk:सुकुमा
      sv:स्वीडिश
      sw:स्वाहिलि
      swb:कोमोरायन
      syr:सीरियक
      ta:तमिल
      tce:दक्षिणी टोचेन
      te:तेलगू
      tem:टिमने
      teo:टेसो
      tet:टैटम
      tg:ताजिक
      tgx:टेगिश
      th:थाई
      tht:टालटन
      ti:टिगरिनया
      tig:टिगरे
      tk:तुर्कमैन
      tlh:किलिंगौन
      tli:टिलिंगिट
      tn:टुआना
      to:टोंगन
      tok:टोकी पोना
      tpi:टोक पिसिन
      tr:टर्किश
      trv:टरोको
      ts:शोंगा
      tt:ततार
      ttm:उत्तरी टचोन
      tum:टुमबुका
      tvl:टुवालू
      twq:टासावाक
      ty:ताहितियन
      tyv:टुविनियन
      tzm:सेंट्रल एटलस टेमेजिघ
      udm:उदमुर्त
      ug:उइगर
      uk:यूक्रेनी
      umb:उमबुंदू
      und:अज्ञात भाषा
      ur:उर्दू
      uz:उजबेक
      vai:बाई
      ve:बेंदा
      vi:बियतनामी
      vun:बुंजो
      wa:बलून
      wae:बालसर
      wal:बोलेटा
      war:बरय
      wo:बोलोफ
      wuu:ऊ चीनी
      xal:कलमिक
      xh:खोसा
      xog:सोगा
      yav:यंगबैन
      ybb:येमबा
      yi:ईडिश
      yo:योरूबा
      yrl:एनहींगाटु
      yue:केंटोनी
      yue-alt-menu:चीनी, केंटोनी
      za:जा
      zgh:मानक मोरोक्कन टेमेजिग्थ
      zh:चीनी
      zh-alt-menu:चीनी, मैंडेरिन
      zh-Hans:सरलीकृत चीनी
      zh-Hans-alt-long:सरलीकृत मैंडेरिन चीनी
      zh-Hant:पारंपरिक चीनी
      zh-Hant-alt-long:पारंपरिक मैंडेरिन चीनी
      zu:जुलू
      zun:जूनी
      zxx:कुनु भाषाई सामग्री नहि
      zza:जाजा
      """.trimIndent() }

  val mas: String by lazy { """
      ak:nkʉtʉ́k ɔ́ɔ̄ lAkan
      am:nkʉtʉ́k ɔ́ɔ̄ lAmhari
      ar:nkʉtʉ́k ɔ́ɔ̄ lmarabu
      be:nkʉtʉ́k ɔ́ɔ̄ lBelarusi
      bg:nkʉtʉ́k ɔ́ɔ̄ lBulgaria
      bn:lnkʉtʉ́k ɔ́ɔ̄ lBengali
      cs:nkʉtʉ́k ɔ́ɔ̄ lcheki
      de:nkʉtʉ́k ɔ́ɔ̄ ljerumani
      el:nkʉtʉ́k ɔ́ɔ̄ lgiriki
      en:nkʉtʉ́k ɔ́ɔ̄ nkɨ́resa
      es:nkʉtʉ́k ɔ́ɔ̄ lspania
      fa:nkʉtʉ́k ɔ́ɔ̄ lpersia
      fr:nkʉtʉ́k ɔ́ɔ̄ faransa
      ha:nkʉtʉ́k ɔ́ɔ̄ hausa
      hi:nkʉtʉ́k ɔ́ɔ̄ lmoindi
      hu:nkʉtʉ́k ɔ́ɔ̄ lhungari
      id:nkʉtʉ́k ɔ́ɔ̄ Indonesia
      ig:nkʉtʉ́k ɔ́ɔ̄ Igbo
      it:nkʉtʉ́k ɔ́ɔ̄ ltalian
      ja:nkʉtʉ́k ɔ́ɔ̄ japani
      jv:nkʉtʉ́k ɔ́ɔ̄ ljana
      km:nkʉtʉ́k ɔ́ɔ̄ lkambodia
      ko:nkʉtʉ́k ɔ́ɔ̄ lkorea
      mas:Maa
      ms:nkʉtʉ́k ɔ́ɔ̄ malay
      my:nkʉtʉ́k ɔ́ɔ̄ lBurma
      ne:nkʉtʉ́k ɔ́ɔ̄ lnepali
      nl:nkʉtʉ́k ɔ́ɔ̄ lduchi
      pa:nkʉtʉ́k ɔ́ɔ̄ lpunjabi
      pl:nkʉtʉ́k ɔ́ɔ̄ lpoland
      pt:nkʉtʉ́k ɔ́ɔ̄ lportuguese
      ro:nkʉtʉ́k ɔ́ɔ̄ lromania
      ru:nkʉtʉ́k ɔ́ɔ̄ lrusi
      rw:nkʉtʉ́k ɔ́ɔ̄ lruwanda
      so:nkʉtʉ́k ɔ́ɔ̄ lchumari
      sv:nkʉtʉ́k ɔ́ɔ̄ lswidi
      ta:nkʉtʉ́k ɔ́ɔ̄ ltamil
      th:nkʉtʉ́k ɔ́ɔ̄ ltai
      tr:nkʉtʉ́k ɔ́ɔ̄ lturuki
      uk:nkʉtʉ́k ɔ́ɔ̄ lkrania
      ur:nkʉtʉ́k ɔ́ɔ̄ lurdu
      vi:nkʉtʉ́k ɔ́ɔ̄ lvietinamu
      yo:nkʉtʉ́k ɔ́ɔ̄ lyoruba
      zh:nkʉtʉ́k ɔ́ɔ̄ lchina
      zh-alt-menu:nkʉtʉ́k ɔ́ɔ̄ lchina
      zu:nkʉtʉ́k ɔ́ɔ̄ lzulu
      """.trimIndent() }

  val mas_TZ: String? = null

  val mdf: String by lazy { """
      mdf:мокшень кяль
      """.trimIndent() }

  val mer: String by lazy { """
      ak:Kĩakani
      am:Kĩamarĩki
      ar:Kĩarabu
      be:Kĩbelarusi
      bg:Kĩbulugĩria
      bn:Kĩbangira
      cs:Kĩcheki
      de:Kĩnjamanĩ
      el:Kĩngiriki
      en:Kĩngeretha
      es:Kĩspĩni
      fa:Kĩpasia
      fr:Kĩfuransi
      ha:Kĩhausa
      hi:Kĩhĩndi
      hu:Kĩhangarĩ
      id:Kĩindonesia
      ig:Kĩigbo
      it:Kĩitalĩ
      ja:Kĩjapani
      jv:Kĩjava
      km:Kĩkambodia
      ko:Kĩkorea
      mer:Kĩmĩrũ
      ms:Kĩmalesia
      my:Kĩburma
      ne:Kĩnepali
      nl:Kĩholandi
      pa:Kĩpunjabu
      pl:Kĩpolandi
      pt:Kĩpochogo
      ro:Kĩromania
      ru:Kĩrashia
      rw:Kĩrwanda
      so:Kĩsomali
      sv:Kĩswideni
      ta:Kĩtamilu
      th:Kĩthailandi
      tr:Kĩtakĩ
      uk:Kĩukirĩni
      ur:Kĩurdu
      vi:Kĩvietinamu
      yo:Kĩyoruba
      zh:Kĩchina
      zh-alt-menu:Kĩchina
      zu:Kĩzulu
      """.trimIndent() }

  val mfe: String by lazy { """
      ak:akan
      am:amarik
      ar:arab
      be:bieloris
      bg:bilgar
      bn:bengali
      cs:tchek
      de:alman
      el:grek
      en:angle
      es:espagnol
      fa:persan
      fr:franse
      ha:haoussa
      hi:hindi
      hu:hongrwa
      id:indonezien
      ig:igbo
      it:italien
      ja:zapone
      jv:zavane
      km:khmer, santral
      ko:koreen
      mfe:kreol morisien
      ms:male
      my:birman
      ne:nepale
      nl:olande
      pa:penjabi
      pl:polone
      pt:portige
      ro:roumin
      ru:ris
      rw:rwanda
      so:somali
      sv:swedwa
      ta:tamoul
      th:thaï
      tr:tirk
      uk:ikrenien
      ur:ourdou
      vi:vietnamien
      yo:yoruba
      zh:sinwa, mandarin
      zh-alt-menu:sinwa, mandarin
      zu:zoulou
      """.trimIndent() }

  val mg: String by lazy { """
      ak:Akan
      am:Amharika
      ar:Arabo
      be:Bielorosy
      bg:Biolgara
      bn:Bengali
      cs:Tseky
      de:Alemanina
      el:Grika
      en:Anglisy
      es:Espaniola
      fa:Persa
      fr:Frantsay
      ha:haoussa
      hi:hindi
      hu:hongroà
      id:Indonezianina
      ig:igbo
      it:Italianina
      ja:Japoney
      jv:Javaney
      km:khmer
      ko:Koreanina
      mg:Malagasy
      ms:Malay
      my:Birmana
      ne:Nepale
      nl:Holandey
      pa:Penjabi
      pl:Poloney
      pt:Portiogey
      ro:Romanianina
      ru:Rosianina
      rw:Roande
      so:Somalianina
      sv:Soisa
      ta:Tamoila
      th:Taioaney
      tr:Tiorka
      uk:Okrainianina
      ur:Ordò
      vi:Vietnamianina
      yo:Yôrobà
      zh:Sinoa, Mandarin
      zh-alt-menu:Sinoa, Mandarin
      zu:Zolò
      """.trimIndent() }

  val mgh: String by lazy { """
      ak:Ikan
      am:Imhari
      ar:Iarabu
      be:Ibelausi
      bg:Ibulgaria
      bn:Ibangla
      cs:Icheki
      de:Ijerimani
      el:Igiriki
      en:Ingilishi
      es:Ihispaniola
      fa:Iajemi
      fr:Ifaransa
      ha:Ihausa
      hi:Ihindi
      hu:Ihungari
      ig:Igbo
      it:Italiano
      ja:Ijapani
      jv:Ijava
      km:Ikambodia
      ko:Ikorea
      mgh:Makua
      ms:Imalesia
      my:Iburma
      ne:Inepali
      nl:Iholanzi
      pa:Ipunjabi
      pl:Ipolandi
      pt:Nreno
      ro:Iromania
      ru:Irisi
      rw:Inyaranda
      so:Isomali
      sv:Iswidi
      ta:Itamil
      th:Itailandi
      tr:Ituruki
      uk:Iukran
      ur:Ihurdu
      vi:Ivyetinamu
      yo:Iyoruba
      zh:Ichina
      zh-alt-menu:Ichina
      zu:Izulu
      """.trimIndent() }

  val mgo: String by lazy { """
      mgo:metaʼ
      und:ngam tisɔʼ
      """.trimIndent() }

  val mi: String by lazy { """
      ab:Apakāhiana
      ace:Akanīhi
      ada:Atāngami
      ady:Āteke
      af:Awherikāna
      agq:Ākeme
      ain:Ainu
      ak:Ākana
      ale:Ariuta
      alt:Ātai ki te Tonga
      am:Amahereka
      an:Arakonihi
      ann:Ōporo
      anp:Anahika
      ar:Ārapi
      ar-001:Ārapi Moroki
      arn:Mapūte
      arp:Arapaho
      ars:Arapika Nahāri
      as:Āhamēhi
      asa:Ahu
      ast:Ahitūriana
      atj:Atikameke
      av:Āwhāriki
      awa:Awāti
      ay:Aimāra
      az:Atepaihānia
      az-alt-short:Ahēri
      ba:Pākīra
      ban:Pārinīhi
      bas:Pahā
      be:Perarūhiana
      bem:Pema
      bez:Pena
      bg:Purukāriana
      bgc:Herianawhi
      bho:Pōhipuri
      bi:Pihirāma
      bin:Pini
      bla:Hihika
      bm:Pāpara
      bn:Pākara
      bo:Tipete
      br:Peretana
      brx:Pōto
      bs:Pōngiana
      bug:Pukenīhi
      byn:Pirina
      ca:Katarana
      cay:Keiūka
      ccp:Tiakamā
      ce:Tietiene
      ceb:Hepuano
      cgg:Tieka
      ch:Tiamoro
      chk:Tiukīhi
      chm:Mari
      cho:Tiokatō
      chp:Tiepewaiana
      chr:Tierokī
      chy:Haiene
      ckb:Kūrihi Waenga
      ckb-alt-menu:Kūrihi, Waenga
      ckb-alt-variant:Kūrihi, Hōrani
      clc:Tiekautini
      co:Kōhikana
      crg:Mītiwhi
      crj:Kirī Tonga-mā-Rāwhiti
      crk:Pareina Kirī
      crl:Kirī Raki-mā-Rāwhiti
      crm:Mūhi Kirī
      crr:Arakōkiana Kararaina
      cs:Tieke
      csw:Wāpi Kirī
      cv:Tiuwhāhi
      cy:Werehi
      da:Teina
      dak:Takōta
      dar:Tākawa
      dav:Taita
      de:Tiamana
      de-AT:Tiamana Ateriana
      de-CH:Tiamana Ōkawa Huiterangi
      dgr:Tōkiripi
      dje:Tāma
      doi:Tōkiri
      dsb:Hōpiana Hakahaka
      dua:Tuāra
      dv:Tīwhehi
      dyo:Hora-Whōni
      dz:Tonoka
      dzg:Tahāka
      ebu:Emepū
      ee:Ewe
      efi:Ewhiki
      eka:Ekatika
      el:Kariki
      en:Ingarihi
      en-AU:Ingarihi Ahitereiriana
      en-CA:Ingarihi Kānata
      en-GB:Ingarihi Piritene
      en-GB-alt-short:Ingarihi UK
      en-US:Ingarihi Amerikana
      en-US-alt-short:Ingarihi US
      eo:Eheperāto
      es:Pāniora
      es-419:Pāniora Amerikana ki te Tonga
      es-ES:Pāniora Ūropi
      es-MX:Pāniora Mehikana
      et:Etōniana
      eu:Pākihi
      ewo:Ewāto
      fa:Pāhiana
      fa-AF:Tāri
      ff:Whūra
      fi:Whinirānia
      fil:Piripīno
      fj:Whītīana
      fo:Wharoīhi
      fon:Whāna
      fr:Wīwī
      fr-CA:Wīwī Kānata
      fr-CH:Wīwī Huiterangi
      frc:Wīwī Keihana
      frr:Whirīhiana ki te Raki
      fur:Whiriūriana
      fy:Whirīhiana ki te Uru
      ga:Airihi
      gaa:Kā
      gd:Keiriki Kotimana
      gez:Kīhi
      gil:Kiripatīhi
      gl:Karīhia
      gn:Kuaranī
      gor:Korōtaro
      gsw:Tiamana Huiterangi
      gu:Kutarāti
      guz:Kūhī
      gv:Manaki
      gwi:Kuitīna
      ha:Hauha
      hai:Heira
      haw:Wāhu
      hax:Haira ki te Tonga
      he:Hīperu
      hi:Hīni
      hi-Latn-alt-variant:Hīngarihi
      hil:Hirikaina
      hmn:Mōnga
      hr:Koroātiana
      hsb:Hōpiana Maunga
      ht:Kereō Haiti
      hu:Hanekari
      hup:Hupa
      hur:Hākomerema
      hy:Āmeniana
      hz:Herero
      ia:Inarīngua
      iba:Īpana
      ibb:Ipīpio
      id:Initonīhiana
      ig:Ikapo
      ii:Hīhuana Eī
      ikt:Inukitetūta Kānata ki te Uru
      ilo:Iroko
      inh:Inguihi
      io:Īto
      is:Tiorangi
      it:Itāriana
      iu:Inukitetūta
      ja:Hapanihi
      jbo:Rōpāna
      jgo:Nakōma
      jmc:Mākame
      jv:Hāwhanihi
      ka:Hōriana
      kab:Kapāiro
      kac:Katīana
      kaj:Heiho
      kam:Kāmapa
      kbd:Kapāriana
      kcg:Tiapa
      kde:Makonote
      kea:Kapuwētianu
      kfo:Koro
      kgp:Keinganga
      kha:Kahi
      khq:Kōira Tīni
      ki:Kikūiu
      kj:Kuoniāma
      kk:Kahāka
      kkj:Kako
      kl:Kararīhutu
      kln:Karenini
      km:Kimēra
      kmb:Kimipunu
      kn:Kanara
      ko:Kōreana
      kok:Kōkani
      kpe:Kepēre
      kr:Kanuri
      krc:Karatai-Pāka
      krl:Kareriana
      kru:Kuruka
      ks:Kahimiri
      ksb:Hapāra
      ksf:Pāwhia
      ksh:Korōniana
      ku:Kūrihi
      kum:Kumiki
      kv:Komi
      kw:Kōnihi
      kwk:Kuakawara
      ky:Kiakihi
      la:Rātini
      lad:Ratino
      lag:Rangi
      lb:Rakapuō
      lez:Rēhiana
      lg:Kānata
      li:Ripūkuihi
      lil:Riruete
      lkt:Rakōta
      ln:Ringāra
      lo:Rao
      lou:Kreōro Ruihiana
      loz:Rohi
      lrc:Ruri ki te Raki
      lsm:Hāmia
      lt:Rituānia
      lu:Rupa Katanga
      lua:Rupa Rurua
      lun:Runa
      luo:Ruo
      lus:Mīho
      luy:Rūia
      lv:Rāwhia
      mad:Maturīhi
      mag:Makāhi
      mai:Maitiri
      mak:Makahā
      mas:Māhai
      mdf:Mōkaha
      men:Menēte
      mer:Meru
      mfe:Morihiene
      mg:Marakāhi
      mgh:Makuwa-Mēto
      mgo:Meta
      mh:Mararīhi
      mi:Māori
      mic:Mīkamā
      min:Minākapao
      mk:Makerōnia
      ml:Mareiārama
      mn:Mongōria
      mni:Manipuri
      moe:Inu-aimuna
      moh:Mauhōka
      mos:Mohi
      mr:Marati
      ms:Marei
      mt:Mārata
      mua:Mūnatanga
      mul:Ngā reo maha
      mus:Mukōki
      mwl:Miranatīhi
      my:Pēmīhi
      myv:Erehīa
      mzn:Mahaterani
      na:Nauru
      nap:Neaporitana
      naq:Nama
      nb:Pakamō Nōwei
      nd:Enetepēra ki te Raki
      nds:Tiamana Hakahaka
      ne:Nepari
      new:Newari
      ng:Natōka
      nia:Niāhi
      niu:Niueana
      nl:Tati
      nl-BE:Tati Whēmirihi
      nmg:Kuahio
      nn:Nīnōka Nōwei
      nnh:Nekiepūna
      no:Nōwei
      nog:Nōkai
      nqo:Unukō
      nr:Enetepēra ki te Tonga
      nso:Hoto ki te Raki
      nus:Nua
      nv:Nawahō
      ny:Niānia
      nyn:Niānakore
      oc:Ōkitana
      ojb:Ōtīpia Raki-mā-Uru
      ojc:Ohīpawe Waenga
      ojs:Ōti-Kirī
      ojw:Ōhīpiwa ki te Uru
      oka:Ōkanakana
      om:Ōromo
      or:Ōtia
      os:Ōtītiki
      pa:Punutapi
      pag:Pāngahina
      pam:Pamapaka
      pap:Papiamēto
      pau:Pārau
      pcm:Ngāitiriana Kōrapurapu
      pis:Pītini
      pl:Pōrihi
      pqm:Marahiti-Pehamakoare
      ps:Pāhitō
      pt:Pōtukīhi
      pt-BR:Pōtukīhi Parahi
      pt-PT:Pōtukīhi Uropi
      qu:Kētua
      raj:Ratiahitani
      rap:Rapanui
      rar:Rarotonga
      rhg:Rohingia
      rm:Romānihi
      rn:Rūniti
      ro:Romeinia
      rof:Romopo
      ru:Ruhiana
      rup:Aromeiniana
      rw:Kiniawāna
      rwk:Rawa
      sa:Hanahiti
      sad:Hātawe
      sah:Hakūta
      saq:Hāmapuru
      sat:Hatāri
      sba:Nekāpei
      sbp:Hāngu
      sc:Hārinia
      scn:Hihiriana
      sco:Kotimana
      sd:Hiniti
      se:Hami ki te Raki
      seh:Hena
      ses:Kōiraporo Heni
      sg:Hāngo
      shi:Tāhehita
      shn:Hāna
      si:Hinihāra
      sk:Horowākia
      sl:Horowinia
      slh:Ratūti ki te Tonga
      sm:Hāmoa
      smn:Inari Hami
      sms:Hakoto Hāmi
      sn:Hōna
      snk:Honīke
      so:Hamāri
      sq:Arapeiniana
      sr:Hirupia
      srn:Harāna Tongo
      ss:Wāti
      st:Hōto ki te Tonga
      str:Hārihi Kuititanga
      su:Hunanīhi
      suk:Hukuma
      sv:Huitene
      sw:Wāhīri
      swb:Komōriana
      syr:Hīriaka
      ta:Tamira
      tce:Tatōne ki te Tonga
      te:Teruku
      tem:Tīmene
      teo:Teho
      tet:Tetumu
      tg:Tāhiki
      tgx:Tākihi
      th:Tai
      tht:Tātana
      ti:Tekirinia
      tig:Tīkara
      tk:Tākamana
      tlh:Kirīngona
      tli:Tirīkiti
      tn:Hawāna
      to:Tonga
      tok:Toki Pona
      tpi:Toko Pīhini
      tr:Tākei
      trv:Taroko
      ts:Honga
      tt:Tatā
      ttm:Tūtone ki te Raki
      tum:Tumūka
      tvl:Tuwaru
      twq:Tahawaka
      ty:Tahiti
      tyv:Tuwīniana
      tzm:Tamahīta Te Puku o Atarihi
      udm:Ūmutu
      ug:Wīkura
      uk:Ukareinga
      umb:Ūpunu
      und:Reo Tē Mōhiotia
      ur:Ūrutu
      uz:Ūpeke
      vai:Wai
      ve:Wēnera
      vi:Whitināmu
      vun:Whunio
      wa:Warūna
      wae:Wāhere
      wal:Wareita
      war:Warei
      wo:Warawhe
      wuu:Hainamana Wū
      xal:Karamiki
      xh:Tōha
      xog:Hoka
      yav:Angapene
      ybb:Emapa
      yi:Irihi
      yo:Ōrūpa
      yrl:Nīkātū
      yue:Katonīhi
      yue-alt-menu:Hainamana, Katonīhi
      zgh:Moroko Tamatai
      zh:Hainamana
      zh-alt-menu:Hainamana Manarini
      zh-Hans:Hainamana Māmā
      zh-Hans-alt-long:Hainamana Māmā
      zh-Hant:Hainamana Tukuiho
      zh-Hant-alt-long:Hainamana Tukuiho
      zu:Tūru
      zun:Tuni
      zxx:Wetereo kiko kore
      zza:Tātā
      """.trimIndent() }

  val mic: String by lazy { """
      mic:Lʼnuiʼsuti
      """.trimIndent() }

  val mk: String by lazy { """
      aa:афарски
      ab:апхаски
      ace:ачешки
      ach:аколи
      ada:адангме
      ady:адигејски
      ae:авестански
      aeb:туниски арапски
      af:африканс
      afh:африхили
      agq:агемски
      ain:ајну
      ak:акански
      akk:акадски
      akz:алабамски
      ale:алеутски
      aln:гешки албански
      alt:јужноалтајски
      am:амхарски
      an:арагонски
      ang:староанглиски
      ann:оболо
      anp:ангика
      ar:арапски
      ar-001:современ стандардизиран арапски
      arc:арамејски
      arn:мапучки
      aro:араона
      arp:арапахо
      arq:алжирски арапски
      ars:неџдиски арапски
      arw:аравачки
      ary:марокански арапски
      arz:египетски арапски
      as:асамски
      asa:асу
      ase:американски знаковен јазик
      ast:астурски
      atj:атикамек
      av:аварски
      avk:котава
      awa:авади
      ay:ајмарски
      az:азербејџански
      az-alt-short:азерски
      ba:башкирски
      bal:белуџиски
      ban:балиски
      bar:баварски
      bas:баса
      bax:бамунски
      bbc:тоба
      bbj:гомала
      be:белоруски
      bej:беџа
      bem:бемба
      bew:бетавски
      bez:бена
      bfd:бафут
      bfq:бадага
      bg:бугарски
      bgc:харијанви
      bgn:западен балочи
      bho:боџпури
      bi:бислама
      bik:биколски
      bin:бини
      bjn:банџарски
      bkm:ком
      bla:сиксика
      blo:ании
      bm:бамбара
      bn:бенгалски
      bo:тибетски
      bpy:бишнуприја
      bqi:бахтијарски
      br:бретонски
      bra:брај
      brh:брахујски
      brx:бодо
      bs:босански
      bss:акосе
      bua:бурјатски
      bug:бугиски
      bum:булу
      byn:биленски
      byv:медумба
      ca:каталонски
      cad:кадо
      car:карипски
      cay:кајуга
      cch:ацам
      ccp:чакмански
      ce:чеченски
      ceb:себуански
      cgg:чига
      ch:чаморски
      chb:чибча
      chg:чагатајски
      chk:чучки
      chm:мариски
      chn:чинучки жаргон
      cho:чоктавски
      chp:чипевјански
      chr:чероки
      chy:чејенски
      ckb:централнокурдски
      ckb-alt-menu:курдски, централен
      ckb-alt-variant:курдски, сорани
      clc:чилкотински
      co:корзикански
      cop:коптски
      cps:капизнон
      cr:кри
      crg:мичиф
      crh:кримскотурски
      crj:југоисточен кријски
      crk:прериски кријски
      crl:североисточен кријски
      crm:лосовски кријски
      crr:каролински алгонкински
      crs:француски (Сеселва креоли)
      cs:чешки
      csb:кашупски
      csw:мочуришен кријски
      cu:црковнословенски
      cv:чувашки
      cy:велшки
      da:дански
      dak:дакота
      dar:даргва
      dav:таита
      de:германски
      de-AT:австриски германски
      de-CH:швајцарски горногермански
      del:делавер
      den:слејви
      dgr:догрипски
      din:динка
      dje:зарма
      doi:догри
      dsb:долнолужички
      dtp:дусунски
      dua:дуала
      dum:среднохоландски
      dv:дивехи
      dyo:јола-фоњи
      dyu:џула
      dz:ѕонгка
      dzg:дазага
      ebu:ембу
      ee:еве
      efi:ефик
      egl:емилијански
      egy:староегипетски
      eka:екаџук
      el:грчки
      elx:еламски
      en:англиски
      en-AU:австралиски англиски
      en-CA:канадски англиски
      en-GB:британски англиски
      en-GB-alt-short:англиски (ОК)
      en-US:американски англиски
      en-US-alt-short:англиски (САД)
      enm:средноанглиски
      eo:есперанто
      es:шпански
      es-419:латиноамерикански шпански
      es-ES:шпански (Европа)
      es-MX:мексикански шпански
      esu:централнојупички
      et:естонски
      eu:баскиски
      ewo:евондо
      ext:екстремадурски
      fa:персиски
      fa-AF:дари
      fan:фанг
      fat:фанти
      ff:фула
      fi:фински
      fil:филипински
      fit:турнедаленски фински
      fj:фиџиски
      fo:фарски
      fon:фон
      fr:француски
      fr-CA:канадски француски
      fr-CH:швајцарски француски
      frc:каџунски француски
      frm:среднофранцуски
      fro:старофранцуски
      frp:франкопровансалски
      frr:севернофризиски
      frs:источнофризиски
      fur:фурлански
      fy:западнофризиски
      ga:ирски
      gaa:га
      gag:гагауски
      gan:ган
      gay:гајо
      gba:гбаја
      gbz:зороастриски дари
      gd:шкотски гелски
      gez:гиз
      gil:гилбертански
      gl:галисиски
      glk:гилански
      gmh:средногорногермански
      gn:гварански
      goh:старогорногермански
      gon:гонди
      gor:горонтало
      got:готски
      grb:гребо
      grc:старогрчки
      gsw:швајцарски германски
      gu:гуџарати
      guc:гвахиро
      gur:фарефаре
      guz:гуси
      gv:манкс
      gwi:гвичински
      ha:хауса
      hai:хајда
      hak:хака
      haw:хавајски
      hax:јужен хајда
      he:хебрејски
      hi:хинди
      hi-Latn-alt-variant:хинди англиски
      hif:фиџиски хинди
      hil:хилигајнонски
      hit:хетитски
      hmn:хмонг
      ho:хири моту
      hr:хрватски
      hsb:горнолужички
      hsn:сјанг
      ht:хаитски
      hu:унгарски
      hup:хупа
      hur:халкомелем
      hy:ерменски
      hz:хереро
      ia:интерлингва
      iba:ибан
      ibb:ибибио
      id:индонезиски
      ie:интерлингве
      ig:игбо
      ii:сичуан ји
      ik:инупијачки
      ikt:западноканадски инуктитут
      ilo:илокански
      inh:ингушки
      io:идо
      is:исландски
      it:италијански
      iu:инуктитут
      izh:ижорски
      ja:јапонски
      jam:јамајски креолски
      jbo:ложбан
      jgo:нгомба
      jmc:мачаме
      jpr:еврејскоперсиски
      jrb:еврејскоарапски
      jut:јитски
      jv:јавански
      ka:грузиски
      kaa:каракалпачки
      kab:кабилски
      kac:качински
      kaj:каџе
      kam:камба
      kaw:кави
      kbd:кабардински
      kbl:канембу
      kcg:тјап
      kde:маконде
      kea:кабувердиану
      ken:кењанг
      kfo:коро
      kg:конго
      kgp:каинганшки
      kha:каси
      kho:хотански
      khq:којра чиини
      khw:коварски
      ki:кикују
      kiu:зазаки
      kj:квањама
      kk:казашки
      kkj:како
      kl:калалисут
      kln:каленџин
      km:кмерски
      kmb:кимбунду
      kn:каннада
      ko:корејски
      koi:коми-пермјачки
      kok:конкани
      kos:козрејски
      kpe:кпеле
      kr:канури
      krc:карачаевско-балкарски
      kri:крио
      krj:кинарајски
      krl:карелски
      kru:курух
      ks:кашмирски
      ksb:шамбала
      ksf:бафија
      ksh:колоњски
      ku:курдски
      kum:кумички
      kut:кутенајски
      kv:коми
      kw:корнски
      kwk:кваквала
      kxv:куви
      ky:киргиски
      la:латински
      lad:ладино
      lag:ланги
      lah:ланда
      lam:ламба
      lb:луксембуршки
      lez:лезгински
      lfn:лингва франка нова
      lg:ганда
      li:лимбуршки
      lij:лигурски
      lil:лилуетски
      liv:ливонски
      lkt:лакотски
      lmo:ломбардиски
      ln:лингала
      lo:лаошки
      lol:монго
      lou:луизијански креолски
      loz:лози
      lrc:севернолуриски
      lsm:самиски
      lt:литвански
      ltg:латгалски
      lu:луба-катанга
      lua:луба-лулуа
      lui:лујсењски
      lun:лунда
      luo:луо
      lus:мизо
      luy:луја
      lv:латвиски
      lzh:книжевен кинески
      lzz:ласки
      mad:мадурски
      maf:мафа
      mag:магахи
      mai:маитили
      mak:макасарски
      man:мандинго
      mas:масајски
      mde:маба
      mdf:мокшански
      mdr:мандарски
      men:менде
      mer:меру
      mfe:морисјен
      mg:малгашки
      mga:средноирски
      mgh:макува-мито
      mgo:мета
      mh:маршалски
      mi:маорски
      mic:микмак
      min:минангкабау
      mk:македонски
      ml:малајалски
      mn:монголски
      mnc:манџурски
      mni:манипурски
      moe:ину-аимунски
      moh:мохавски
      mos:моси
      mr:марати
      mrj:западномариски
      ms:малајски
      mt:малтешки
      mua:мунданг
      mul:повеќе јазици
      mus:крик
      mwl:мирандски
      mwr:марвари
      my:бурмански
      mye:мјене
      myv:ерзјански
      mzn:мазендерански
      na:науруански
      nan:јужномински
      nap:неаполски
      naq:нама
      nb:норвешки букмол
      nd:северен ндебеле
      nds:долногермански
      nds-NL:долносаксонски
      ne:непалски
      new:неварски
      ng:ндонга
      nia:нијас
      niu:ниујески
      njo:ао нага
      nl:холандски
      nl-BE:фламански
      nmg:квазио
      nn:норвешки нинорск
      nnh:нгиембун
      no:норвешки
      nog:ногајски
      non:старонордиски
      nov:новијал
      nqo:нко
      nr:јужен ндебеле
      nso:северносотски
      nus:нуер
      nv:навахо
      nwc:класичен неварски
      ny:њанџа
      nym:њамвези
      nyn:њанколе
      nyo:њоро
      nzi:нзима
      oc:окситански
      oj:оџибва
      ojb:северозападен оџибва
      ojc:централен оџибва
      ojs:очиски кријски
      ojw:западен оџибва
      oka:оканагански
      om:оромо
      or:одија
      os:осетски
      osa:осашки
      ota:отомански турски
      pa:пенџапски
      pag:пангасинански
      pal:средноперсиски
      pam:пампанга
      pap:папијаменто
      pau:палауански
      pcd:пикардски
      pcm:нигериски пиџин
      pdc:пенсилваниски германски
      pdt:менонитски долногермански
      peo:староперсиски
      pfl:фалечкогермански
      phn:феникиски
      pi:пали
      pis:пиџин
      pl:полски
      pms:пиемонтски
      pnt:понтски
      pon:понпејски
      pqm:малиситски пасамакводски
      prg:пруски
      pro:старопровансалски
      ps:паштунски
      pt:португалски
      pt-BR:бразилски португалски
      pt-PT:португалски (Европа)
      qu:кечуански
      quc:киче
      qug:кичвански
      raj:раџастански
      rap:рапанујски
      rar:раротонгански
      rgn:ромањолски
      rhg:рохиншки
      rif:рифски
      rm:реторомански
      rn:рунди
      ro:романски
      ro-MD:молдавски
      rof:ромбо
      rom:ромски
      rtm:ротумански
      ru:руски
      rue:русински
      rug:ровијански
      rup:влашки
      rw:руандски
      rwk:руа
      sa:санскрит
      sad:сандаве
      sah:јакутски
      sam:самарјански арамејски
      saq:самбуру
      sas:сасачки
      sat:сантали
      saz:саураштра
      sba:нгембеј
      sbp:сангу
      sc:сардински
      scn:сицилијански
      sco:шкотски германски
      sd:синди
      sdc:сасарски сардински
      sdh:јужнокурдски
      se:северен сами
      see:сенека
      seh:сена
      sei:сери
      sel:селкупски
      ses:којраборо сени
      sg:санго
      sga:староирски
      sgs:самогитски
      sh:српскохрватски
      shi:тачелхит
      shn:шан
      shu:чадски арапски
      si:синхалски
      sid:сидамо
      sk:словачки
      sl:словенечки
      slh:јужен лушуцид
      sli:долношлезиски
      sly:селајарски
      sm:самоански
      sma:јужен сами
      smj:луле сами
      smn:инариски сами
      sms:сколт сами
      sn:шона
      snk:сонинке
      so:сомалиски
      sog:зогдијански
      sq:албански
      sr:српски
      srn:срански тонго
      srr:серер
      ss:свати
      ssy:сахо
      st:сесото
      stq:затерландски фризиски
      str:салишки (Северен Теснец)
      su:сундски
      suk:сукума
      sus:сусу
      sux:сумерски
      sv:шведски
      sw:свахили
      sw-CD:конгоански свахили
      swb:коморијански
      syc:класичен сириски
      syr:сириски
      szl:шлезиски
      ta:тамилски
      tce:јужнотучонски
      tcy:тулу
      te:телугу
      tem:тимне
      teo:тесо
      ter:терено
      tet:тетум
      tg:таџикистански
      tgx:тагишки
      th:тајландски
      tht:талтански
      ti:тигриња
      tig:тигре
      tiv:тив
      tk:туркменски
      tkl:токелауански
      tkr:цахурски
      tl:тагалог
      tlh:клингонски
      tli:тлингит
      tly:талишки
      tmh:тамашек
      tn:цвана
      to:тонгајски
      tog:њаса тонга
      tok:токи пона
      tpi:ток писин
      tr:турски
      tru:туројо
      trv:тароко
      ts:цонга
      tsd:цаконски
      tsi:цимшијански
      tt:татарски
      ttm:севернотучонски
      ttt:татски
      tum:тумбука
      tvl:тувалуански
      tw:тви
      twq:тазавак
      ty:тахитски
      tyv:тувански
      tzm:централноатлански тамазитски
      udm:удмуртски
      ug:ујгурски
      uga:угаритски
      uk:украински
      umb:умбунду
      und:непознат јазик
      ur:урду
      uz:узбечки
      vai:вај
      ve:венда
      vec:венецијански
      vep:вепшки
      vi:виетнамски
      vls:западнофламански
      vmf:мајнскофранконски
      vmw:макуа
      vo:волапик
      vot:вотски
      vro:виру
      vun:вунџо
      wa:валонски
      wae:валсер
      wal:воламо
      war:варајски
      was:вашо
      wbp:варлпири
      wo:волофски
      wuu:ву
      xal:калмички
      xh:коса
      xmf:мегрелски
      xnr:кангри
      xog:сога
      yao:јао
      yap:јапски
      yav:јенгбен
      ybb:јемба
      yi:јидиш
      yo:јорупски
      yrl:њенгату
      yue:кантонски
      yue-alt-menu:кантонски кинески
      za:џуаншки
      zap:запотечки
      zbl:блиссимболи
      zea:зеландски
      zen:зенага
      zgh:стандарден марокански тамазитски
      zh:кинески
      zh-alt-menu:мандарински кинески
      zh-Hans:поедноставен кинески
      zh-Hans-alt-long:поедноставен мандарински
      zh-Hant:традиционален кинески
      zh-Hant-alt-long:традиционален мандарински
      zu:зулу
      zun:зуни
      zxx:без лингвистичка содржина
      zza:заза
      """.trimIndent() }

  val ml: String by lazy { """
      aa:അഫാർ
      ab:അബ്‌ഖാസിയൻ
      ace:അചിനീസ്
      ach:അകോലി
      ada:അഡാങ്‌മി
      ady:അഡൈഗേ
      ae:അവസ്റ്റാൻ
      af:ആഫ്രിക്കാൻസ്
      afh:ആഫ്രിഹിലി
      agq:ആഘേം
      ain:ഐനു
      ak:അകാൻ‌
      akk:അക്കാഡിയൻ
      ale:അലൂട്ട്
      alt:തെക്കൻ അൾത്തായി
      am:അംഹാരിക്
      an:അരഗോണീസ്
      ang:പഴയ ഇംഗ്ലീഷ്
      ann:ഒബോളോ
      anp:ആൻഗിക
      ar:അറബിക്
      ar-001:ആധുനിക സ്റ്റാൻഡേർഡ് അറബിക്
      arc:അരമായ
      arn:മാപുചി
      arp:അറാപഹോ
      ars:നജ്‌ദി അറബിക്
      arw:അറാവക്
      as:ആസ്സാമീസ്
      asa:ആസു
      ast:അസ്ട്ടൂരിയൻ
      atj:അറ്റികമെക്‌വ്
      av:അവാരിക്
      awa:അവാധി
      ay:അയ്മാറ
      az:അസർബൈജാനി
      az-alt-short:അസേരി
      ba:ബഷ്ഖിർ
      bal:ബലൂചി
      ban:ബാലിനീസ്
      bas:ബാസ
      bax:ബാമുൻ
      bbj:ഘോമാല
      be:ബെലാറുഷ്യൻ
      bej:ബേജ
      bem:ബേംബ
      bez:ബെനാ
      bfd:ബാഫട്ട്
      bg:ബൾഗേറിയൻ
      bgc:ഹർയാൻവി
      bgn:പശ്ചിമ ബലൂചി
      bho:ഭോജ്‌പുരി
      bi:ബിസ്‌ലാമ
      bik:ബികോൽ
      bin:ബിനി
      bkm:കോം
      bla:സിക്സിക
      blo:അനി
      bm:ബംബാറ
      bn:ബംഗ്ലാ
      bo:ടിബറ്റൻ
      br:ബ്രെട്ടൺ
      bra:ബ്രജ്
      brx:ബോഡോ
      bs:ബോസ്നിയൻ
      bss:അക്കൂസ്
      bua:ബുറിയത്ത്
      bug:ബുഗിനീസ്
      bum:ബുളു
      byn:ബ്ലിൻ
      byv:മെഡുംബ
      ca:കറ്റാലാൻ
      cad:കാഡോ
      car:കാരിബ്
      cay:കയൂഗ
      cch:അറ്റ്സാം
      ccp:ചക്‌മ
      ce:ചെചൻ
      ceb:സെബുവാനോ
      cgg:ചിഗ
      ch:ചമോറോ
      chb:ചിബ്ച
      chg:ഷാഗതായ്
      chk:ചൂകീസ്
      chm:മാരി
      chn:ചിനൂഗ് ജാർഗൺ
      cho:ചോക്റ്റാവ്
      chp:ചിപേവ്യൻ
      chr:ഷെരോക്കി
      chy:ഷായാൻ
      ckb:സെൻട്രൽ കുർദിഷ്
      ckb-alt-menu:സെൻട്രൽ കുർദിഷ്
      ckb-alt-variant:സൊറാനി കുർദിഷ്
      clc:ചിൽകോട്ടിൻ
      co:കോർസിക്കൻ
      cop:കോപ്റ്റിക്
      cr:ക്രീ
      crg:മിചിഫ്
      crh:ക്രിമിയൻ ടർക്കിഷ്
      crj:സതേൺ ഈസ്റ്റ് ക്രീ
      crk:പ്ലെയ്‌ൻസ് ക്രീ
      crl:നോർത്തേൺ ഈസ്റ്റ് ക്രീ
      crm:മൂസ് ക്രീ
      crr:കരോലീന അൽഗോൻക്വിയാൻ
      crs:സെഷൽവ ക്രിയോൾ ഫ്രഞ്ച്
      cs:ചെക്ക്
      csb:കാഷുബിയാൻ
      csw:സ്വാംപി ക്രീ
      cu:ചർച്ച് സ്ലാവിക്
      cv:ചുവാഷ്
      cy:വെൽഷ്
      da:ഡാനിഷ്
      dak:ഡകോട്ട
      dar:ഡർഗ്വാ
      dav:തൈത
      de:ജർമ്മൻ
      de-AT:ഓസ്‌ട്രിയൻ ജർമ്മൻ
      de-CH:സ്വിസ് ഹൈ ജർമ്മൻ
      del:ദെലവേർ
      den:സ്ലേവ്
      dgr:ഡോഗ്രിബ്
      din:ദിൻക
      dje:സാർമ്മ
      doi:ഡോഗ്രി
      dsb:ലോവർ സോർബിയൻ
      dua:ദ്വാല
      dum:മദ്ധ്യ ഡച്ച്
      dv:ദിവെഹി
      dyo:ജോല-ഫോൻയി
      dyu:ദ്വൈല
      dz:ദ്‌സോങ്ക
      dzg:ഡാസാഗ
      ebu:എംബു
      ee:യൂ
      efi:എഫിക്
      egy:പ്രാചീന ഈജിപ്ഷ്യൻ
      eka:എകാജുക്
      el:ഗ്രീക്ക്
      elx:എലാമൈറ്റ്
      en:ഇംഗ്ലീഷ്
      en-AU:ഓസ്‌ട്രേലിയൻ ഇംഗ്ലീഷ്
      en-CA:കനേഡിയൻ ഇംഗ്ലീഷ്
      en-GB:ബ്രിട്ടീഷ് ഇംഗ്ലീഷ്
      en-GB-alt-short:യു.കെ. ഇംഗ്ലീഷ്
      en-US:അമേരിക്കൻ ഇംഗ്ലീഷ്
      en-US-alt-short:യു.എസ്. ഇംഗ്ലീഷ്
      enm:മദ്ധ്യ ഇംഗ്ലീഷ്
      eo:എസ്‌പരാന്റോ
      es:സ്‌പാനിഷ്
      es-419:ലാറ്റിൻ അമേരിക്കൻ സ്‌പാനിഷ്
      es-ES:യൂറോപ്യൻ സ്‌പാനിഷ്
      es-MX:മെക്സിക്കൻ സ്പാനിഷ്
      et:എസ്റ്റോണിയൻ
      eu:ബാസ്‌ക്
      ewo:എവോൻഡോ
      fa:പേർഷ്യൻ
      fa-AF:ഡാരി
      fan:ഫങ്
      fat:ഫാന്റി
      ff:ഫുല
      fi:ഫിന്നിഷ്
      fil:ഫിലിപ്പിനോ
      fj:ഫിജിയൻ
      fo:ഫാറോസ്
      fon:ഫോൻ
      fr:ഫ്രഞ്ച്
      fr-CA:കനേഡിയൻ ഫ്രഞ്ച്
      fr-CH:സ്വിസ് ഫ്രഞ്ച്
      frc:കേജൺ ഫ്രഞ്ച്
      frm:മദ്ധ്യ ഫ്രഞ്ച്
      fro:പഴയ ഫ്രഞ്ച്
      frr:നോർത്തേൻ ഫ്രിഷ്യൻ
      frs:ഈസ്റ്റേൺ ഫ്രിഷ്യൻ
      fur:ഫ്രിയുലിയാൻ
      fy:പശ്ചിമ ഫ്രിഷിയൻ
      ga:ഐറിഷ്
      gaa:ഗാ
      gag:ഗാഗൂസ്
      gan:ഗാൻ ചൈനീസ്
      gay:ഗയൊ
      gba:ഗബ്യ
      gd:സ്കോട്ടിഷ് ഗൈലിക്
      gez:ഗീസ്
      gil:ഗിൽബർട്ടീസ്
      gl:ഗലീഷ്യൻ
      gmh:മദ്ധ്യ ഉച്ച ജർമൻ
      gn:ഗ്വരനി
      goh:ഓൾഡ് ഹൈ ജർമൻ
      gon:ഗോണ്ഡി
      gor:ഗൊറോന്റാലോ
      got:ഗോഥിക്ക്
      grb:ഗ്രബൊ
      grc:പുരാതന ഗ്രീക്ക്
      gsw:സ്വിസ് ജർമ്മൻ
      gu:ഗുജറാത്തി
      guz:ഗുസീ
      gv:മാൻസ്
      gwi:ഗ്വിച്ചിൻ
      ha:ഹൗസ
      hai:ഹൈഡ
      hak:ഹാക്ക ചൈനീസ്
      haw:ഹവായിയൻ
      hax:സതേൺ ഹൈഡ
      he:ഹീബ്രു
      hi:ഹിന്ദി
      hi-Latn-alt-variant:ഹിംഗ്ലീഷ്
      hil:ഹിലിഗയ്നോൺ
      hit:ഹിറ്റൈറ്റ്
      hmn:മോങ്
      ho:ഹിരി മോതു
      hr:ക്രൊയേഷ്യൻ
      hsb:അപ്പർ സോർബിയൻ
      hsn:ഷ്യാങ് ചൈനീസ്
      ht:ഹെയ്‌തിയൻ ക്രിയോൾ
      hu:ഹംഗേറിയൻ
      hup:ഹൂപ
      hur:ഹോക്കൊമെലം
      hy:അർമേനിയൻ
      hz:ഹെരേരൊ
      ia:ഇന്റർലിംഗ്വ
      iba:ഇബാൻ
      ibb:ഇബീബിയോ
      id:ഇന്തോനേഷ്യൻ
      ie:ഇന്റർലിംഗ്വേ
      ig:ഇഗ്ബോ
      ii:ഷുവാൻയി
      ik:ഇനുപിയാക്
      ikt:വെസ്റ്റേൺ കനേഡിയൻ ഇനുക്ടിറ്റൂറ്റ്
      ilo:ഇലോകോ
      inh:ഇങ്കുഷ്
      io:ഇഡോ
      is:ഐസ്‌ലാൻഡിക്
      it:ഇറ്റാലിയൻ
      iu:ഇനുക്റ്റിറ്റുട്ട്
      ja:ജാപ്പനീസ്
      jbo:ലോജ്ബാൻ
      jgo:ഗോമ്പ
      jmc:മചേം
      jpr:ജൂഡിയോ-പേർഷ്യൻ
      jrb:ജൂഡിയോ-അറബിക്
      jv:ജാവനീസ്
      ka:ജോർജിയൻ
      kaa:കര-കാൽപ്പക്
      kab:കബൈൽ
      kac:കാചിൻ
      kaj:ജ്യൂ
      kam:കംബ
      kaw:കാവി
      kbd:കബർഡിയാൻ
      kbl:കനെംബു
      kcg:ട്യാപ്
      kde:മക്കോണ്ടെ
      kea:കബുവെർദിയാനു
      kfo:കോറോ
      kg:കോംഗോ
      kgp:കെയിൻഗാംഗ്
      kha:ഖാസി
      kho:ഘോറ്റാനേസേ
      khq:കൊയ്റ ചീനി
      ki:കികൂയു
      kj:ക്വാന്യമ
      kk:കസാഖ്
      kkj:കാകോ
      kl:കലാല്ലിസുട്ട്
      kln:കലെഞ്ചിൻ
      km:ഖമെർ
      kmb:കിംബുണ്ടു
      kn:കന്നഡ
      ko:കൊറിയൻ
      koi:കോമി-പെർമ്യാക്ക്
      kok:കൊങ്കണി
      kos:കൊസറേയൻ
      kpe:പെൽ
      kr:കനൂറി
      krc:കരാചൈ-ബാൽകാർ
      krl:കരീലിയൻ
      kru:കുരുഖ്
      ks:കശ്‌മീരി
      ksb:ഷംഭാള
      ksf:ബാഫിയ
      ksh:കൊളോണിയൻ
      ku:കുർദ്ദിഷ്
      kum:കൂമിക്ക്
      kut:കുതേനൈ
      kv:കോമി
      kw:കോർണിഷ്
      kwk:ക്വാക്വല
      kxv:കുവി
      ky:കിർഗിസ്
      la:ലാറ്റിൻ
      lad:ലഡീനോ
      lag:ലാംഗി
      lah:ലഹ്‌ൻഡ
      lam:ലംബ
      lb:ലക്‌സംബർഗിഷ്
      lez:ലസ്ഗിയൻ
      lg:ഗാണ്ട
      li:ലിംബർഗിഷ്
      lij:ലിഗൂറിയൻ
      lil:ലില്ലുവെറ്റ്
      lkt:ലകൗട്ട
      lmo:ലൊംബാർഡ്
      ln:ലിംഗാല
      lo:ലാവോ
      lol:മോങ്കോ
      lou:ലൂസിയാന ക്രിയോൾ
      loz:ലൊസി
      lrc:വടക്കൻ ലൂറി
      lsm:സാമിയ
      lt:ലിത്വാനിയൻ
      lu:ലുബ-കറ്റംഗ
      lua:ലൂബ-ലുലുവ
      lui:ലൂയിസെനോ
      lun:ലുൻഡ
      luo:ലുവോ
      lus:മിസോ
      luy:ലുയിയ
      lv:ലാറ്റ്വിയൻ
      mad:മദുരേസേ
      maf:മാഫ
      mag:മഗാഹി
      mai:മൈഥിലി
      mak:മകാസർ
      man:മണ്ഡിൻഗോ
      mas:മസായ്
      mde:മാബ
      mdf:മോക്ഷ
      mdr:മണ്ഡാർ
      men:മെൻഡെ
      mer:മേരു
      mfe:മൊറിസിൻ
      mg:മലഗാസി
      mga:മദ്ധ്യ ഐറിഷ്
      mgh:മാഖുവാ-മീത്തോ
      mgo:മേത്താ
      mh:മാർഷല്ലീസ്
      mi:മവോറി
      mic:മിക്മാക്
      min:മിനാങ്കബൗ
      mk:മാസിഡോണിയൻ
      ml:മലയാളം
      mn:മംഗോളിയൻ
      mnc:മാൻ‌ചു
      mni:മണിപ്പൂരി
      moe:ഇന്നു-ഐമൂൻ
      moh:മോഹാക്
      mos:മൊസ്സി
      mr:മറാത്തി
      ms:മലെയ്
      mt:മാൾട്ടീസ്
      mua:മുന്ദാംഗ്
      mul:പലഭാഷകൾ
      mus:ക്രീക്ക്
      mwl:മിരാൻറസേ
      mwr:മർവാരി
      my:ബർമീസ്
      mye:മയീൻ
      myv:ഏഴ്സ്യ
      mzn:മസന്ററാനി
      na:നൗറു
      nan:മിൻ നാൻ ചൈനീസ്
      nap:നെപ്പോളിറ്റാൻ
      naq:നാമ
      nb:നോർവീജിയൻ ബുക്‌മൽ
      nd:നോർത്ത് ഡെബിൾ
      nds:ലോ ജർമൻ
      nds-NL:ലോ സാക്സൺ
      ne:നേപ്പാളി
      new:നേവാരി
      ng:ഡോങ്ക
      nia:നിയാസ്
      niu:ന്യുവാൻ
      nl:ഡച്ച്
      nl-BE:ഫ്ലമിഷ്
      nmg:ക്വേസിയോ
      nn:നോർവീജിയൻ നൈനോർക്‌സ്
      nnh:ഗീംബൂൺ
      no:നോർവീജിയൻ
      nog:നോഗൈ
      non:പഴയ നോഴ്‌സ്
      nqo:ഇൻകോ
      nr:ദക്ഷിണ നെഡിബിൾ
      nso:നോർത്തേൻ സോതോ
      nus:നുവേർ
      nv:നവാജോ
      nwc:ക്ലാസിക്കൽ നേവാരി
      ny:ന്യൻജ
      nym:ന്യാംവേസി
      nyn:ന്യാൻകോൾ
      nyo:ന്യോറോ
      nzi:സിമ
      oc:ഓക്‌സിറ്റൻ
      oj:ഓജിബ്വാ
      ojb:നോർത്ത്‌വെസ്റ്റേൺ ഒജീബ്‌വെ
      ojc:സെൻട്രൽ ഒജീബ്‌വെ
      ojs:ഒജി-ക്രീ
      ojw:വെസ്റ്റേൺ ഒജീബ്‌വെ
      oka:ഒകാനഗൻ
      om:ഒറോമോ
      or:ഒഡിയ
      os:ഒസ്സെറ്റിക്
      osa:ഒസേജ്
      ota:ഓട്ടോമൻ തുർക്കിഷ്
      pa:പഞ്ചാബി
      pag:പങ്കാസിനൻ
      pal:പാഹ്ലവി
      pam:പാംപൻഗ
      pap:പാപിയാമെന്റൊ
      pau:പലാവുൻ
      pcm:നൈജീരിയൻ പിഡ്‌ഗിൻ
      peo:പഴയ പേർഷ്യൻ
      phn:ഫീനിഷ്യൻ
      pi:പാലി
      pis:പിജിൻ
      pl:പോളിഷ്
      pon:പൊൻപിയൻ
      pqm:മലിസീറ്റ്-പസാമക്വുഡി
      prg:പ്രഷ്യൻ
      pro:പഴയ പ്രൊവൻഷ്ൽ
      ps:പഷ്‌തോ
      ps-alt-variant:പുഷ്തോ
      pt:പോർച്ചുഗീസ്
      pt-BR:ബ്രസീലിയൻ പോർച്ചുഗീസ്
      pt-PT:യൂറോപ്യൻ പോർച്ചുഗീസ്
      qu:ക്വെച്ചുവ
      quc:ക്വിച്ചെ
      raj:രാജസ്ഥാനി
      rap:രാപനൂയി
      rar:രാരോടോങ്കൻ
      rhg:റോഹിംഗാ
      rm:റൊമാഞ്ച്
      rn:റുണ്ടി
      ro:റൊമാനിയൻ
      ro-MD:മോൾഡാവിയൻ
      rof:റോംബോ
      rom:റൊമാനി
      ru:റഷ്യൻ
      rup:ആരോമാനിയൻ
      rw:കിന്യാർവാണ്ട
      rwk:റുവാ
      sa:സംസ്‌കൃതം
      sad:സാൻഡവേ
      sah:സാഖ
      sam:സമരിയാക്കാരുടെ അരമായ
      saq:സംബുരു
      sas:സസാക്
      sat:സന്താലി
      sba:ഗംബായ്
      sbp:സംഗു
      sc:സർഡിനിയാൻ
      scn:സിസിലിയൻ
      sco:സ്കോട്സ്
      sd:സിന്ധി
      sdh:തെക്കൻ കുർദ്ദിഷ്
      se:വടക്കൻ സമി
      see:സെനേക
      seh:സേന
      sel:സെൽകപ്
      ses:കൊയ്റാബൊറോ സെന്നി
      sg:സാംഗോ
      sga:പഴയ ഐറിഷ്
      sh:സെർബോ-ക്രൊയേഷ്യൻ
      shi:താച്ചലിറ്റ്
      shn:ഷാൻ
      shu:ചാഡിയൻ അറബി
      si:സിംഹള
      sid:സിഡാമോ
      sk:സ്ലോവാക്
      sl:സ്ലോവേനിയൻ
      slh:സതേൺ ലുഷൂറ്റ്‌സീഡ്
      sm:സമോവൻ
      sma:തെക്കൻ സമി
      smj:ലൂലീ സമി
      smn:ഇനാരി സമി
      sms:സ്കോൾട്ട് സമി
      sn:ഷോണ
      snk:സോണിൻകെ
      so:സോമാലി
      sog:സോജിഡിയൻ
      sq:അൽബേനിയൻ
      sr:സെർബിയൻ
      srn:ശ്രാനൻ ഡോങ്കോ
      srr:സെറർ
      ss:സ്വാറ്റി
      ssy:സാഹോ
      st:തെക്കൻ സോതോ
      str:സ്ട്രെയ്റ്റ്സ് സെയ്‌ലിഷ്
      su:സുണ്ടാനീസ്
      suk:സുകുമ
      sus:സുസു
      sux:സുമേരിയൻ
      sv:സ്വീഡിഷ്
      sw:സ്വാഹിലി
      sw-CD:കോംഗോ സ്വാഹിലി
      swb:കൊമോറിയൻ
      syc:പുരാതന സുറിയാനിഭാഷ
      syr:സുറിയാനി
      szl:സൈലേഷ്യൻ
      ta:തമിഴ്
      tce:സതേൺ ടറ്റ്ഷോൺ
      te:തെലുങ്ക്
      tem:ടിംനേ
      teo:ടെസോ
      ter:ടെറേനോ
      tet:ടെറ്റും
      tg:താജിക്
      tgx:ടാഗിഷ്
      th:തായ്
      tht:ടാഹ്‌ൽടൻ
      ti:ടൈഗ്രിന്യ
      tig:ടൈഗ്രി
      tiv:ടിവ്
      tk:തുർക്‌മെൻ
      tkl:ടൊക്കേലൗ
      tl:തഗാലോഗ്
      tlh:ക്ലിംഗോൺ
      tli:ലിംഗ്വിറ്റ്
      tmh:ടമഷേക്
      tn:സ്വാന
      to:ടോംഗൻ
      tog:ന്യാസാ ഡോങ്ക
      tok:ടോകി പോന
      tpi:ടോക് പിസിൻ
      tr:ടർക്കിഷ്
      trv:തരോക്കോ
      ts:സോംഗ
      tsi:സിംഷ്യൻ
      tt:ടാട്ടർ
      ttm:നോർത്തേൺ ടറ്റ്ഷോൺ
      tum:ടുംബുക
      tvl:ടുവാലു
      tw:ട്വി
      twq:ടസവാക്ക്
      ty:താഹിതിയൻ
      tyv:തുവിനിയൻ
      tzm:മധ്യ അറ്റ്‌ലസ് ടമാസൈറ്റ്
      udm:ഉഡ്മുർട്ട്
      ug:ഉയ്ഘുർ
      ug-alt-variant:ഉയ്ഗൂർ
      uga:ഉഗറിട്ടിക്
      uk:ഉക്രേനിയൻ
      umb:ഉംബുന്ദു
      und:അജ്ഞാത ഭാഷ
      ur:ഉറുദു
      uz:ഉസ്‌ബെക്ക്
      vai:വൈ
      ve:വെന്ദ
      vec:വെനീഷ്യൻ
      vi:വിയറ്റ്നാമീസ്
      vmw:മഖുവ
      vo:വോളാപുക്
      vot:വോട്ടിക്
      vun:വുൻജോ
      wa:വല്ലൂൺ
      wae:വാൾസർ
      wal:വൊലൈറ്റ
      war:വാരേയ്
      was:വാഷൊ
      wbp:വൂൾപിരി
      wo:വൊളോഫ്
      wuu:വു ചൈനീസ്
      xal:കാൽമിക്
      xh:ഖോസ
      xnr:കാങ്ടി
      xog:സോഗോ
      yao:യാവോ
      yap:യെപ്പീസ്
      yav:യാംഗ്ബെൻ
      ybb:യംബ
      yi:യിദ്ദിഷ്
      yo:യൊറൂബാ
      yrl:നീൻഗാറ്റു
      yue:കാന്റണീസ്
      yue-alt-menu:ചൈനീസ്, കാന്റണീസ്
      za:സ്വാംഗ്
      zap:സാപ്പോടെക്
      zbl:ബ്ലിസ്സിംബൽസ്
      zen:സെനഗ
      zgh:സ്റ്റാൻഡേർഡ് മൊറോക്കൻ റ്റാമസിയറ്റ്
      zh:ചൈനീസ്
      zh-alt-menu:ചൈനീസ്, മാൻഡറിൻ
      zh-Hans:ലളിതമാക്കിയ ചൈനീസ്
      zh-Hans-alt-long:ലളിതവൽകൃത മാൻഡറിൻ ചൈനീസ്
      zh-Hant:പരമ്പരാഗത ചൈനീസ്
      zh-Hant-alt-long:പരമ്പരാഗത മാൻഡറിൻ ചൈനീസ്
      zu:സുലു
      zun:സുനി
      zxx:ഭാഷാപരമായ ഉള്ളടക്കമൊന്നുമില്ല
      zza:സാസാ
      """.trimIndent() }

  val mn: String by lazy { """
      aa:афар
      ab:абхаз
      ace:ачин
      ada:адангмэ
      ady:адигэ
      af:африкаанс
      agq:агем
      ain:айну
      ak:акан
      ale:алют
      alt:өмнөд алтай
      am:амхар
      an:арагон
      ann:оболо
      anp:ангик
      ar:араб
      ar-001:стандарт араб
      arn:мапүчи
      arp:арапаго
      ars:наджи араб
      as:ассам
      asa:асу
      ast:астури
      atj:атикамек
      av:авар
      awa:авадхи
      ay:аймара
      az:азербайжан
      az-alt-short:азери
      ba:башкир
      ban:бали
      bas:басаа
      be:беларусь
      bem:бемба
      bez:бена
      bg:болгар
      bgc:харьянви
      bho:божпури
      bi:бислам
      bin:бини
      bla:сиксика
      blo:Ани
      bm:бамбара
      bn:бенгал
      bo:төвд
      br:бретон
      brx:бодо
      bs:босни
      bug:буги
      byn:блин
      ca:каталан
      cay:кайюга хэл
      ccp:чакма
      ce:чечень
      ceb:себуано
      cgg:чига
      ch:чаморро
      chk:чуук
      chm:мари хэл
      cho:чоктау
      chp:чипевайан
      chr:чероки
      chy:чэенн
      ckb:төв курд
      ckb-alt-menu:Курд, Төв
      ckb-alt-variant:Курд, Сорани
      clc:чилкотин
      co:корсик
      crg:мичиф
      crj:зүүн өмнөд кри
      crk:плэйн кри
      crl:зүүн хойд кри
      crm:мүүс кри
      crr:каролина алгонкинск хэл
      crs:сеселва креол франц
      cs:чех
      csw:свампи кри
      cu:сүмийн славян
      cv:чуваш
      cy:уэльс
      da:дани
      dak:дакота
      dar:даргва
      dav:тайта
      de:герман
      de-CH:герман (Швейцар)
      dgr:догриб
      dje:зарма
      doi:догри
      dsb:доод сорби
      dua:дуала
      dv:дивехи
      dyo:жола-фони
      dz:зонха
      dzg:дазага
      ebu:эмбу
      ee:эвэ
      efi:эфик
      eka:экажук
      el:грек
      en:англи
      en-AU:австрали-англи
      en-CA:канад-англи
      en-GB:британи-англи
      en-GB-alt-short:британи-англи
      en-US:америк-англи
      en-US-alt-short:америк-англи
      eo:эсперанто
      es:испани
      es-419:испани хэл (Латин Америк)
      es-ES:испани хэл (Европ)
      es-MX:испани хэл (Мексик)
      et:эстони
      eu:баск
      ewo:эвондо
      fa:перс
      ff:фула
      fi:фин
      fil:филипино
      fj:фижи
      fo:фарер
      fon:фон
      fr:франц
      fr-CH:франц (Швейцар)
      frc:франц, кажун
      frr:хойд фриз
      fur:фриулан
      fy:баруун фриз
      ga:ирланд
      gaa:га
      gag:гагуз
      gd:шотландын гел
      gez:гийз
      gil:гилберт
      gl:галего
      gn:гуарани
      gor:горонтало
      gsw:швейцари-герман
      gu:гужарати
      guz:гузы
      gv:манкс
      gwi:гвичин
      ha:хауса
      hai:хайда
      haw:хавай
      hax:өмнөд хайда
      he:еврей
      hi:хинди
      hi-Latn-alt-variant:хинглиш
      hil:хилигайнон
      hmn:хмонг
      hr:хорват
      hsb:дээд сорби
      ht:Гаитийн креол
      hu:мажар
      hup:хупа
      hur:халкомелем
      hy:армен
      hz:хереро
      ia:интерлингво
      iba:ибан
      ibb:ибибио
      id:индонези
      ie:нэгдмэл хэл
      ig:игбо
      ii:сычуань и
      ikt:баруун канадын инуктитут
      ilo:илоко
      inh:ингуш
      io:идо
      is:исланд
      it:итали
      iu:инуктитут
      ja:япон
      jbo:ложбан
      jgo:нгомба
      jmc:мачамэ
      jv:ява
      ka:гүрж
      kab:кабиле
      kac:качин
      kaj:жжу
      kam:камба
      kbd:кабардин
      kcg:тяп
      kde:маконде
      kea:кабүвердиану
      kfo:коро
      kgp:кайнганг
      kha:каси
      khq:койра чини
      ki:кикуюү
      kj:куаньяма
      kk:казах
      kkj:како
      kl:калалисут
      kln:каленжин
      km:кхмер
      kmb:кимбунду
      kn:каннада
      ko:солонгос
      koi:коми-пермяк
      kok:конкани
      kpe:кпелле
      kr:канури
      krc:карачай-балкар
      krl:карель
      kru:курук
      ks:кашмир
      ksb:шамбал
      ksf:бафиа
      ksh:кёльш
      ku:курд
      kum:кумук
      kv:коми
      kw:корн
      kwk:квак вала
      kxv:куви
      ky:киргиз
      la:латин
      lad:ладин
      lag:ланги
      lb:люксембург
      lez:лезги
      lg:ганда
      li:лимбург
      lij:лигури
      lil:лиллуэт
      lkt:лакота
      lmo:ломбард
      ln:лингала
      lo:лаос
      lou:луизиана креоле
      loz:лози
      lrc:хойд лури
      lsm:самиа
      lt:литва
      lu:луба-катанга
      lua:луба-лулуа
      lun:лунда
      luo:луо
      lus:мизо
      luy:луяа
      lv:латви
      mad:мадури хэл
      mag:магахи
      mai:май
      mak:макасар
      mas:масай
      mdf:мокша
      men:менде
      mer:меру
      mfe:морисен
      mg:малагаси
      mgh:макува-мито
      mgo:мета
      mh:маршалл
      mi:маори
      mic:микмак
      min:минангкабау
      mk:македон
      ml:малаялам
      mn:монгол
      mni:манипури
      moe:инну-аймун
      moh:мохаук
      mos:мосси
      mr:марати
      ms:малай
      mt:малта
      mua:мунданг
      mul:олон хэл
      mus:крик
      mwl:меранди
      my:бирм
      myv:эрзя
      mzn:мазандерани
      na:науру
      nap:неаполитан
      naq:нама
      nb:норвегийн букмол
      nd:хойд ндебеле
      nds:доод герман
      ne:балба
      new:невари
      ng:ндонга
      nia:ниас хэл
      niu:ниуэ
      nl:нидерланд
      nl-BE:фламанд
      nmg:квазио
      nn:норвегийн нинорск
      nnh:нгиембүүн
      no:норвег
      nog:ногаи
      nqo:нко
      nr:өмнөд ндебеле
      nso:хойд сото
      nus:нуер
      nv:навахо
      ny:нянжа
      nyn:нянколе
      oc:окситан
      ojb:баруун хойд ожибва
      ojc:төв ожибва
      ojs:ожи кри
      ojw:баруун ожибва
      oka:оканаган
      om:оромо
      or:ория
      os:оссетин
      pa:панжаби
      pag:пангасин
      pam:пампанга
      pap:папьяменто
      pau:палау
      pcm:нигерийн пиджин
      pis:пижин
      pl:польш
      pqm:малесит-пассамакводди
      prg:прусс
      ps:пушту
      pt:португал
      pt-BR:португал хэл (Бразил)
      pt-PT:португал хэл (Европ)
      qu:кечуа
      quc:киче
      raj:ражастани
      rap:рапануи
      rar:раротонг
      rhg:рохинжа
      rm:романш
      rn:рунди
      ro:румын
      ro-MD:молдав
      rof:ромбо
      ru:орос
      rup:ароманы
      rw:киньяруанда
      rwk:рва
      sa:санскрит
      sad:сандавэ
      sah:саха
      saq:самбүрү
      sat:сантали
      sba:нгамбай
      sbp:сангү
      sc:сардин
      scn:сицил
      sco:шотланд
      sd:синдхи
      se:хойд сами
      seh:сена
      ses:кёраборо сени
      sg:санго
      sh:хорватын серб
      shi:тачелхит
      shn:шань
      si:синхала
      sk:словак
      sl:словени
      slh:өмнөд лушуцид
      sm:самоа
      sma:өмнөд сами
      smj:люле сами
      smn:инари сами
      sms:сколт сами
      sn:шона
      snk:сонинке
      so:сомали
      sq:албани
      sr:серб
      srn:сранан тонго
      ss:свати
      ssy:сахо
      st:сесото
      str:стрейтс салиш
      su:сундан
      suk:сукума
      sv:швед
      sw:свахили
      sw-CD:конгогийн свахили
      swb:комори
      syr:сири
      szl:силез
      ta:тамил
      tce:өмнөд тутчоне
      te:тэлүгү
      tem:тимн
      teo:тэсо
      tet:тетум
      tg:тажик
      tgx:тагиш
      th:тай
      tht:талтан
      ti:тигринья
      tig:тигр
      tk:туркмен
      tlh:клингон
      tli:тлингит
      tn:цвана
      to:тонга
      tok:токипона
      tpi:ток писин
      tr:турк
      trv:тароко
      ts:цонга
      tt:татар
      ttm:хойд тутчоне
      tum:тумбула
      tvl:тувалу
      tw:тви
      twq:тасавак
      ty:таити
      tyv:тува
      tzm:Төв Атласын тамазигхт
      udm:удмурт
      ug:уйгур
      uk:украин
      umb:умбунду
      und:үл мэдэгдэх хэл
      ur:урду
      uz:узбек
      vai:вай
      ve:венда
      vec:венец
      vi:вьетнам
      vmw:макуа
      vo:волапюк
      vun:вунжо
      wa:уоллун
      wae:уолсэр
      wal:уоллайтта
      war:варай
      wo:волоф
      wuu:хятад, ву хэл
      xal:халимаг
      xh:хоса
      xnr:кангри
      xog:сога
      yav:янгбен
      ybb:емба
      yi:иддиш
      yo:ёруба
      yrl:ньенгату
      yue:кантон
      yue-alt-menu:хятад, кантон
      za:чжуанг
      zgh:стандарт тамазайт (Морокко)
      zh:хятад
      zh-alt-menu:хятад, мандарин
      zh-Hans:хялбаршуулсан хятад
      zh-Hans-alt-long:хялбаршуулсан мандарин хятад
      zh-Hant:уламжлалт хятад
      zh-Hant-alt-long:уламжлалт мандарин хятад
      zu:зулу
      zun:зуни
      zxx:хэл зүйн агуулгагүй
      zza:заза
      """.trimIndent() }

  val mn_Mong_MN: String by lazy { """
      de:ᠭᠧᠷᠮᠠᠨ
      de-AT:ᠠᠦᠰᠲᠷᠢ ᠭᠧᠷᠮᠠᠨ
      de-CH:ᠰᠸᠢᠼᠸᠵᠯᠡᠨᠳᠠ ᠭᠧᠷᠮᠠᠨ
      en:ᠠᠨᠭᠭᠯᠢ
      en-AU:ᠠᠥ᠋ᠰᠲ᠋ᠠᠷᠠᠯᠢᠢ᠎ᠠ ᠠᠨᠭᠭᠯᠢ
      en-CA:ᠻᠠᠨᠠᠳᠠ ᠠᠨᠭᠭᠯᠢ
      en-GB:ᠪᠷᠢᠲ᠋ᠠᠨᠢ ᠠᠨᠭᠭᠯᠢ
      en-GB-alt-short:ᠪᠷᠢᠲ᠋ᠠᠨᠢ ᠠᠨᠭᠭᠯᠢ
      en-US:ᠠᠮᠧᠷᠢᠺᠠ ᠠᠨᠭᠭᠯᠢ
      en-US-alt-short:ᠠᠮᠧᠷᠢᠺᠠ ᠠᠨᠭᠭᠯᠢ
      es:ᠢᠰᠫᠠᠨᠢ
      es-419:ᠢᠰᠫᠠᠨᠢ (ᠯᠠᠠᠲ᠋ᠢᠨ ᠡᠠᠮᠸᠷᠢᠺᠠ)
      es-ES:ᠢᠰᠫᠠᠨᠢ (ᠢᠰᠫᠠᠨᠢ)
      es-MX:ᠢᠰᠫᠠᠨᠢ (ᠮᠸᠺᠰᠢᠺᠦ)
      fr:ᠹᠷᠠᠨᠼᠠ
      fr-CA:ᠹᠷᠠᠨᠼᠠ ᠹᠷᠠᠨᠼᠠ
      fr-CH:ᠰᠸᠢᠼᠸᠵᠯᠡᠨ᠋ᠳ᠋ ᠹᠷᠠᠨᠼᠠ
      it:ᠢᠲ᠋ᠠᠯᠢ
      ja:ᠶᠡᠫᠥᠠ
      mn:ᠮᠣᠩᠭᠣᠯ
      pt:ᠫᠣᠷᠲ᠋ᠦ᠋ᠭᠠᠯᠢ
      pt-PT:ᠫᠣᠷᠲ᠋ᠦ᠋ᠭᠠᠯᠢ (ᠫᠣᠷᠲ᠋ᠦ᠋ᠭᠠᠯᠢ)
      ru:ᠣᠷᠣᠰ
      und:ᠲᠣᠳᠣᠷᠬᠠᠢ ᠥᠭᠡᠢ ᠬᠡᠯᠡ
      zh:ᠬᠢᠳᠠᠳ
      zh-alt-menu:ᠬᠢᠳᠠᠳ
      zh-Hans:ᠬᠢᠯᠪᠠᠷᠰᠢᠭᠣᠯᠣᠭᠰᠠᠨ ᠬᠢᠳᠠᠳ
      zh-Hans-alt-long:ᠬᠢᠯᠪᠠᠷᠰᠢᠭᠣᠯᠣᠭᠰᠠᠨ ᠬᠢᠳᠠᠳ
      zh-Hant:ᠣᠯᠠᠮᠵᠢᠯᠠᠯᠳᠥ ᠬᠢᠳᠠᠳ
      zh-Hant-alt-long:ᠣᠯᠠᠮᠵᠢᠯᠠᠯᠳᠥ ᠬᠢᠳᠠᠳ
      """.trimIndent() }

  val mni: String by lazy { """
      ar:আরাবিক
      ar-001:মোর্দর্ন স্তেন্দর্দ আরাবিক
      bn:বাংলা
      de:জর্মন
      de-AT:ওষ্ট্রিয়ান জর্মন
      de-CH:স্বিজ হায় জর্মন
      en:ইংলিস
      en-AU:ওষ্ট্রেলিয়ান ইংলিস
      en-CA:কানাদিয়ান ইংলিস
      en-GB:ব্রিটিশ ইংলিস
      en-GB-alt-short:য়ু কে ইংলিস
      en-US:অমেরিকান ইংলিস
      en-US-alt-short:য়ু এস ইংলিস
      es:স্পেনিস
      es-419:লেটিন অমেরিকান স্পেনিস
      es-ES:য়ুরোপিয়ান স্পেনিস
      es-MX:মেক্সিকান স্পেনিস
      fr:ফ্রেঞ্চ
      fr-CA:কানাদিয়ান ফ্রেঞ্চ
      fr-CH:স্বিজ ফ্রেঞ্চ
      hi:হিন্দী
      id:ইন্দোনেসিয়া
      it:ইটালিয়ন
      ja:জাপানিজ
      ko:কোরিয়ন
      mni:মৈতৈলোন্
      nl:দচ
      nl-BE:ফ্লেমিশ
      pl:পোলিশ
      pt:পোর্টুগিজ
      pt-BR:ব্রাজিলিয়ান পোর্টুগিজ
      pt-PT:য়ুরোপিয়ান পোর্টুগিজ
      ru:রুসিয়ান
      th:থাই
      tr:টর্কিশ
      und:মশকখংদবা লোল
      zh:চাইনিজ
      zh-alt-menu:চাইনিজ মন্দারিন
      zh-Hans:সিমপ্লিফাইদ চাইনিজ
      zh-Hans-alt-long:সিমপ্লিফাইদ মন্দারিন চাইনিজ
      zh-Hant:ত্রেদিস্নেল চাইনিজ
      zh-Hant-alt-long:ত্রেদিস্নেল মন্দারিন চাইনিজ
      """.trimIndent() }

  val mni_Beng: String? = null

  val mni_Mtei: String by lazy { """
      mni:ꯃꯤꯇꯩꯂꯣꯟ
      """.trimIndent() }

  val moh: String by lazy { """
      moh:Kanienʼkéha
      """.trimIndent() }

  val mr: String by lazy { """
      aa:अफार
      ab:अबखेजियन
      ace:अचीनी
      ach:अकोली
      ada:अडांग्मे
      ady:अडिघे
      ae:अवेस्तन
      af:अफ्रिकान्स
      afh:अफ्रिहिली
      agq:अघेम
      ain:ऐनू
      ak:अकान
      akk:अक्केडियन
      ale:अलेउत
      alt:दक्षिणात्य अल्ताई
      am:अम्हारिक
      an:अर्गोनीज
      ang:पुरातन इंग्रजी
      ann:ओबोलो
      anp:अंगिका
      ar:अरबी
      ar-001:आधुनिक प्रमाणित अरबी
      arc:अ‍ॅरेमाइक
      arn:मापुची
      arp:आरापाहो
      ars:नजदी अरबी
      arw:आरावाक
      as:आसामी
      asa:असु
      ast:अस्तुरियन
      atj:अटिकमेक
      av:अ‍ॅव्हेरिक
      awa:अवधी
      ay:ऐमरा
      az:अझरबैजानी
      az-alt-short:अझेरी
      ba:बष्किर
      bal:बलुची
      ban:बालिनीज
      bas:बसा
      be:बेलारुशियन
      bej:बेजा
      bem:बेम्बा
      bez:बेना
      bg:बल्गेरियन
      bgc:हरियाणवी
      bgn:पश्चिमी बालोची
      bho:भोजपुरी
      bi:बिस्लामा
      bik:बिकोल
      bin:बिनी
      bla:सिक्सिका
      blo:ॲनीआय
      bm:बाम्बारा
      bn:बंगाली
      bo:तिबेटी
      br:ब्रेतॉन
      bra:ब्रज
      brx:बोडो
      bs:बोस्नियन
      bua:बुरियात
      bug:बगिनीस
      byn:ब्लिन
      ca:कातालान
      cad:कॅड्डो
      car:कॅरिब
      cay:केयुगा
      cch:अत्सम
      ccp:चाकमा
      ce:चेचेन
      ceb:सिबुआनो
      cgg:किगा
      ch:कॅमोरो
      chb:चिब्चा
      chg:छागाताइ
      chk:चूकीसे
      chm:मारी
      chn:चिनूक जारगॉन
      cho:चोक्तौ
      chp:शिपेव्यान
      chr:चेरोकी
      chy:शेयेन्न
      ckb:मध्य कुर्दिश
      ckb-alt-menu:कुर्दिश, मध्य
      ckb-alt-variant:कुर्दिश, सोरानी
      clc:चिलकोटिन
      co:कॉर्सिकन
      cop:कॉप्टिक
      cr:क्री
      crg:मिचिफो
      crh:क्राइमीन तुर्की
      crj:दक्षिणात्य इस्ट क्री
      crk:प्लेन्स क्री
      crl:नॉर्दर्न ईस्ट क्री
      crm:मूस क्री
      crr:कॅरोलिना अल्गोंक्वियन
      crs:सेसेल्वा क्रिओल फ्रेंच
      cs:झेक
      csb:काशुबियन
      csw:स्वॅम्पी क्री
      cu:चर्च स्लाव्हिक
      cv:चूवाश
      cy:वेल्श
      da:डॅनिश
      dak:डाकोटा
      dar:दार्गवा
      dav:तायता
      de:जर्मन
      de-AT:ऑस्ट्रियन जर्मन
      de-CH:स्विस हाय जर्मन
      del:डेलावेयर
      den:स्लाव्ह
      dgr:डोग्रिब
      din:डिन्का
      dje:झार्मा
      doi:डोगरी
      dsb:लोअर सोर्बियन
      dua:दुआला
      dum:मिडल डच
      dv:दिवेही
      dyo:जोला-फॉन्यी
      dyu:ड्युला
      dz:झोंगखा
      dzg:दाझागा
      ebu:एम्बू
      ee:एवे
      efi:एफिक
      egy:प्राचीन इजिप्शियन
      eka:एकाजुक
      el:ग्रीक
      elx:एलामाइट
      en:इंग्रजी
      en-AU:ऑस्ट्रेलियन इंग्रजी
      en-CA:कॅनडियन इंग्रजी
      en-GB:ब्रिटिश इंग्रजी
      en-GB-alt-short:यू.के. इंग्रजी
      en-US:अमेरिकन इंग्रजी
      en-US-alt-short:यू.एस. इंग्रजी
      enm:मिडल इंग्रजी
      eo:एस्परान्टो
      es:स्पॅनिश
      es-419:लॅटिन अमेरिकन स्पॅनिश
      es-ES:युरोपियन स्पॅनिश
      es-MX:मेक्सिकन स्पॅनिश
      et:इस्टोनियन
      eu:बास्क
      ewo:इवोन्डो
      fa:फारसी
      fa-AF:दारी
      fan:फँग
      fat:फन्टी
      ff:फुलाह
      fi:फिनिश
      fil:फिलिपिनो
      fj:फिजियन
      fo:फरोइज
      fon:फॉन
      fr:फ्रेंच
      fr-CA:कॅनडियन फ्रेंच
      fr-CH:स्विस फ्रेंच
      frc:केजॉन फ्रेंच
      frm:मिडल फ्रेंच
      fro:पुरातन फ्रेंच
      frr:उत्तरी फ्रिशियन
      frs:पौर्वात्य फ्रिशियन
      fur:फ्रियुलियान
      fy:पश्चिमी फ्रिशियन
      ga:आयरिश
      gaa:गा
      gag:गागाउझ
      gan:गॅन चिनी
      gay:गायो
      gba:बाया
      gd:स्कॉटिश गेलिक
      gez:गीझ
      gil:जिल्बरटीज
      gl:गॅलिशियन
      gmh:मिडल हाय जर्मन
      gn:गुआरनी
      goh:पुरातन हाइ जर्मन
      gon:गाँडी
      gor:गोरोन्तालो
      got:गॉथिक
      grb:ग्रेबो
      grc:प्राचीन ग्रीक
      gsw:स्विस जर्मन
      gu:गुजराती
      guz:गसी
      gv:मांक्स
      gwi:ग्विच’इन
      ha:हौसा
      hai:हैडा
      hak:हाक्का चिनी
      haw:हवाईयन
      hax:दक्षिणात्य हैडा
      he:हिब्रू
      hi:हिंदी
      hi-Latn-alt-variant:हिंग्लिश
      hil:हिलीगेनॉन
      hit:हिट्टिते
      hmn:माँग
      ho:हिरी मॉटू
      hr:क्रोएशियन
      hsb:अप्पर सॉर्बियन
      hsn:शियांग चिनी
      ht:हैतीयन क्रेओल
      hu:हंगेरियन
      hup:हूपा
      hur:हॉल्कमेलम
      hy:अर्मेनियन
      hz:हरेरो
      ia:इंटरलिंग्वा
      iba:इबान
      ibb:इबिबिओ
      id:इंडोनेशियन
      ie:इंटरलिंग
      ig:ईग्बो
      ii:सिचुआन यी
      ik:इनूपियाक
      ikt:वेस्टर्न कॅनेडियन इनुकिटुट
      ilo:इलोको
      inh:इंगुश
      io:इडौ
      is:आईसलँडिक
      it:इटालियन
      iu:इनुक्तीटुट
      ja:जपानी
      jbo:लोज्बान
      jgo:गोम्बा
      jmc:मशामे
      jpr:जुदेओ-फारसी
      jrb:जुदेओ-अरबी
      jv:जावानीज
      ka:जॉर्जियन
      kaa:कारा-कल्पक
      kab:कबाइल
      kac:काचिन
      kaj:ज्जु
      kam:काम्बा
      kaw:कावी
      kbd:कबार्डियन
      kcg:त्याप
      kde:माकोन्दे
      kea:काबवर्दियानु
      kfo:कोरो
      kg:काँगो
      kgp:काइंगांग
      kha:खासी
      kho:खोतानीस
      khq:कोयरा चीनी
      ki:किकुयू
      kj:क्वान्यामा
      kk:कझाक
      kkj:काको
      kl:कलाल्लिसत
      kln:कालेंजीन
      km:ख्मेर
      kmb:किम्बन्दु
      kn:कन्नड
      ko:कोरियन
      koi:कोमी-परम्याक
      kok:कोंकणी
      kos:कोसरियन
      kpe:क्पेल्ले
      kr:कनुरी
      krc:कराचय-बाल्कर
      krl:करेलियन
      kru:कुरूख
      ks:काश्मीरी
      ksb:शांबाला
      ksf:बाफिया
      ksh:कोलोग्नियन
      ku:कुर्दिश
      kum:कुमीक
      kut:कुतेनाई
      kv:कोमी
      kw:कोर्निश
      kwk:क्वक्क्वाला
      kxv:कुवी
      ky:किरगीझ
      la:लॅटिन
      lad:लादीनो
      lag:लांगी
      lah:लाह्न्डा
      lam:लाम्बा
      lb:लक्झेंबर्गिश
      lez:लेझ्घीयन
      lg:गांडा
      li:लिंबूर्गिश
      lij:लिगुरिअन
      lil:लिलूएट
      lkt:लाकोटा
      lmo:लोंबार्ड
      ln:लिंगाला
      lo:लाओ
      lol:मोंगो
      lou:ल्युसियाना क्रिओल
      loz:लोझि
      lrc:उत्तरी ल्युरी
      lsm:सामिया
      lt:लिथुआनियन
      lu:ल्यूबा-कटांगा
      lua:लुबा-लुलुआ
      lui:लुइसेनो
      lun:लुन्डा
      luo:ल्युओ
      lus:मिझो
      luy:ल्युइया
      lv:लात्व्हियन
      mad:मादुरीस
      mag:मगही
      mai:मैथिली
      mak:मकस्सर
      man:मन्डिन्गो
      mas:मसाई
      mdf:मोक्ष
      mdr:मंडार
      men:मेन्डे
      mer:मेरू
      mfe:मोरिस्येन
      mg:मलागसी
      mga:मिडल आयरिश
      mgh:माखुव्हा-मीट्टो
      mgo:मीटा
      mh:मार्शलीज
      mi:माओरी
      mic:मिकमॅक
      min:मिनांग्काबाउ
      mk:मॅसेडोनियन
      ml:मल्याळम
      mn:मंगोलियन
      mnc:मान्चु
      mni:मणिपुरी
      moe:इन्नू-ॲमन
      moh:मोहॉक
      mos:मोस्सी
      mr:मराठी
      ms:मलय
      mt:माल्टिज्
      mua:मुंडांग
      mul:एकाधिक भाषा
      mus:क्रीक
      mwl:मिरांडिज्
      mwr:मारवाडी
      my:बर्मी
      myv:एर्झ्या
      mzn:माझानदेरानी
      na:नउरू
      nan:मिन नान चिनी
      nap:नेपोलिटान
      naq:नामा
      nb:नॉर्वेजियन बोकमाल
      nd:उत्तर देबेली
      nds:लो जर्मन
      nds-NL:लो सॅक्सन
      ne:नेपाळी
      new:नेवारी
      ng:डोंगा
      nia:नियास
      niu:नियुआन
      nl:डच
      nl-BE:फ्लेमिश
      nmg:क्वासिओ
      nn:नॉर्वेजियन न्योर्स्क
      nnh:जिएम्बून
      no:नॉर्वेजियन
      nog:नोगाई
      non:पुरातन नॉर्स
      nqo:एन्को
      nr:दक्षिणात्य देबेली
      nso:उत्तरी सोथो
      nus:नुएर
      nv:नावाजो
      nwc:अभिजात नेवारी
      ny:न्यान्जा
      nym:न्यामवेझी
      nyn:न्यानकोल
      nyo:न्योरो
      nzi:न्झिमा
      oc:ऑक्सितान
      oj:ओजिब्वा
      ojb:नॉर्थवेस्टर्न ओजिब्वा
      ojc:सेंट्रल ओजिब्वा
      ojs:ओजी-क्री
      ojw:वेस्टर्न ओजिबवा
      oka:ओकनागन
      om:ओरोमो
      or:उडिया
      os:ओस्सेटिक
      osa:ओसेज
      ota:ओटोमान तुर्किश
      pa:पंजाबी
      pag:पंगासीनान
      pal:पहलवी
      pam:पाम्पान्गा
      pap:पापियामेन्टो
      pau:पालाउआन
      pcm:नायजिरिअन पिजिन
      peo:पुरातन फारसी
      phn:फोनिशियन
      pi:पाली
      pis:पिजिन
      pl:पोलिश
      pon:पोह्नपियन
      pqm:मालीसेट-पासामाक्वाड्डी
      prg:प्रुशियन
      pro:पुरातन प्रोव्हेन्सल
      ps:पश्तो
      ps-alt-variant:पुश्तो
      pt:पोर्तुगीज
      pt-BR:ब्राझिलियन पोर्तुगीज
      pt-PT:युरोपियन पोर्तुगीज
      qu:क्वेचुआ
      quc:कीशेइ
      raj:राजस्थानी
      rap:रापानुई
      rar:रारोटोंगन
      rhg:रोहिंग्या
      rm:रोमान्श
      rn:रुन्दी
      ro:रोमानियन
      ro-MD:मोल्डाव्हियन
      rof:रोम्बो
      rom:रोमानी
      ru:रशियन
      rup:अरोमानियन
      rw:किन्यार्वान्डा
      rwk:रव्हा
      sa:संस्कृत
      sad:सँडवे
      sah:साखा
      sam:सामरिटान अरॅमिक
      saq:सांबुरू
      sas:सासाक
      sat:संताली
      sba:गाम्बे
      sbp:सांगु
      sc:सर्दिनियन
      scn:सिसिलियन
      sco:स्कॉट्स
      sd:सिंधी
      sdh:दक्षिणी कुर्दिश
      se:उत्तरी सामी
      seh:सेना
      sel:सेल्कप
      ses:कोयराबोरो सेन्नी
      sg:सांगो
      sga:पुरातन आयरिश
      sh:सर्बो-क्रोएशियन
      shi:ताशेल्हिट
      shn:शॅन
      si:सिंहला
      sid:सिदामो
      sk:स्लोव्हाक
      sl:स्लोव्हेनियन
      slh:दक्षिणात्य लुशूटसीड
      sm:सामोअन
      sma:दक्षिणात्य सामी
      smj:ल्युल सामी
      smn:इनारी सामी
      sms:स्कोल्ट सामी
      sn:शोना
      snk:सोनिन्के
      so:सोमाली
      sog:सोग्डिएन
      sq:अल्बानियन
      sr:सर्बियन
      srn:स्रानान टॉन्गो
      srr:सेरेर
      ss:स्वाती
      ssy:साहो
      st:दक्षिणी सोथो
      str:स्ट्राइट्स सालीश
      su:सुंदानीज
      suk:सुकुमा
      sus:सुसु
      sux:सुमेरियन
      sv:स्वीडिश
      sw:स्वाहिली
      sw-CD:काँगो स्वाहिली
      swb:कोमोरियन
      syc:अभिजात सिरियाक
      syr:सिरियाक
      szl:सिलेशियन
      ta:तामिळ
      tce:दक्षिणात्य टचोन
      te:तेलगू
      tem:टिम्ने
      teo:तेसो
      ter:तेरेनो
      tet:तेतुम
      tg:ताजिक
      tgx:टॅगिश
      th:थाई
      tht:तहल्टन
      ti:तिग्रिन्या
      tig:टाइग्रे
      tiv:तिव
      tk:तुर्कमेन
      tkl:टोकेलाऊ
      tl:टागालोग
      tlh:क्लिंगॉन
      tli:लिंगित
      tmh:तामाशेक
      tn:त्स्वाना
      to:टोंगन
      tog:न्यासा टोन्गा
      tok:टोकि पोना
      tpi:टोक पिसिन
      tr:तुर्की
      trv:तारोको
      ts:सोंगा
      tsi:सिम्शियन
      tt:तातर
      ttm:नॉर्दर्न टचोन
      tum:तुम्बुका
      tvl:टुवालु
      tw:ट्वी
      twq:तासाव्हाक
      ty:ताहितीयन
      tyv:टुवीनियन
      tzm:मध्य अ‍ॅटलास तॅमाझाइट
      udm:उदमुर्त
      ug:उइगुर
      uga:युगॅरिटिक
      uk:युक्रेनियन
      umb:उम्बुन्डु
      und:अज्ञात भाषा
      ur:उर्दू
      uz:उझ्बेक
      vai:वाई
      ve:व्हेंदा
      vec:व्हेनेशियन
      vi:व्हिएतनामी
      vmw:मखुवा
      vo:ओलापुक
      vot:वॉटिक
      vun:वुंजो
      wa:वालून
      wae:वालसेर
      wal:वोलायता
      war:वारे
      was:वाशो
      wbp:वार्लपिरी
      wo:वोलोफ
      wuu:व्हू चिनी
      xal:काल्मिक
      xh:खोसा
      xnr:कांगरी
      xog:सोगा
      yao:याओ
      yap:यापीस
      yav:यांगबेन
      ybb:येमबा
      yi:यिद्दिश
      yo:योरुबा
      yrl:न्हेंगाटू
      yue:कँटोनीज
      yue-alt-menu:चीनी, कँटोनीज
      za:झुआंग
      zap:झेपोटेक
      zbl:ब्लिसिम्बॉल्स
      zen:झेनान्गा
      zgh:प्रमाण मोरोक्कन तॅमॅझायट
      zh:चीनी
      zh-alt-menu:चीनी, मँडेरिन
      zh-Hans:सरलीकृत चीनी
      zh-Hans-alt-long:सरलीकृत मँडेरिन चीनी
      zh-Hant:पारंपारिक चीनी
      zh-Hant-alt-long:पारंपारिक मँडेरिन चीनी
      zu:झुलू
      zun:झुनी
      zxx:भाषावैज्ञानिक सामग्री नाही
      zza:झाझा
      """.trimIndent() }

  val ms: String by lazy { """
      aa:Afar
      ab:Abkhazia
      ace:Aceh
      ach:Akoli
      ada:Adangme
      ady:Adyghe
      ae:Avestan
      aeb:Arab Tunisia
      af:Afrikaans
      agq:Aghem
      ain:Ainu
      ak:Akan
      ale:Aleut
      alt:Altai Selatan
      am:Amharic
      an:Aragon
      ann:Obolo
      anp:Angika
      ar:Arab
      ar-001:Arab Standard Moden
      arn:Mapuche
      arp:Arapaho
      arq:Arab Algeria
      ars:Arab Najdi
      ary:Arab Maghribi
      arz:Arab Mesir
      as:Assam
      asa:Asu
      ast:Asturia
      atj:Atikamekw
      av:Avaric
      awa:Awadhi
      ay:Aymara
      az:Azerbaijan
      az-alt-short:Azeri
      ba:Bashkir
      bal:Baluchi
      ban:Bali
      bas:Basaa
      bax:Bamun
      bbj:Ghomala
      be:Belarus
      bej:Beja
      bem:Bemba
      bez:Bena
      bfd:Bafut
      bg:Bulgaria
      bgc:Haryanvi
      bgn:Balochi Barat
      bho:Bhojpuri
      bi:Bislama
      bin:Bini
      bkm:Kom
      bla:Siksika
      blo:Anii
      bm:Bambara
      bn:Benggali
      bo:Tibet
      bpy:Bishnupriya
      br:Breton
      brh:Brahui
      brx:Bodo
      bs:Bosnia
      bss:Akoose
      bua:Buriat
      bug:Bugis
      bum:Bulu
      byn:Blin
      byv:Medumba
      ca:Catalonia
      cay:Cayuga
      ccp:Chakma
      ce:Chechen
      ceb:Cebuano
      cgg:Chiga
      ch:Chamorro
      chk:Chukese
      chm:Mari
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      ckb:Kurdi Tengah
      ckb-alt-menu:Kurdi, Tengah
      ckb-alt-variant:Kurdi, Sorani
      clc:Chilcotin
      co:Corsica
      cop:Coptic
      crg:Michif
      crh:Turki Krimea
      crj:Cree Tenggara
      crk:Plains Cree
      crl:Timur Laut Cree
      crm:Moose Cree
      crr:Carolina Algonquian
      crs:Perancis Seselwa Creole
      cs:Czech
      csw:Swampy Cree
      cu:Slavik Gereja
      cv:Chuvash
      cy:Wales
      da:Denmark
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:Jerman
      de-AT:Jerman Austria
      de-CH:Jerman Halus Switzerland
      dgr:Dogrib
      dje:Zarma
      doi:Dogri
      dsb:Sorbian Rendah
      dua:Duala
      dv:Divehi
      dyo:Jola-Fonyi
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      eka:Ekajuk
      el:Greek
      en:Inggeris
      en-AU:Inggeris Australia
      en-CA:Inggeris Kanada
      en-GB:Inggeris British
      en-GB-alt-short:Inggeris U.K.
      en-US:Inggeris AS
      en-US-alt-short:Inggeris A.S.
      eo:Esperanto
      es:Sepanyol
      es-419:Sepanyol Amerika Latin
      es-ES:Sepanyol Eropah
      es-MX:Sepanyol Mexico
      et:Estonia
      eu:Basque
      ewo:Ewondo
      fa:Parsi
      fa-AF:Dari
      ff:Fulah
      fi:Finland
      fil:Filipina
      fj:Fiji
      fo:Faroe
      fon:Fon
      fr:Perancis
      fr-CA:Perancis Kanada
      fr-CH:Perancis Switzerland
      frc:Perancis Cajun
      frr:Frisian Utara
      fur:Friulian
      fy:Frisian Barat
      ga:Ireland
      gaa:Ga
      gag:Gagauz
      gan:Cina Gan
      gba:Gbaya
      gbz:Zoroastrian Dari
      gd:Scots Gaelic
      gez:Geez
      gil:Kiribati
      gl:Galicia
      glk:Gilaki
      gn:Guarani
      gor:Gorontalo
      grc:Greek Purba
      gsw:Jerman Switzerland
      gu:Gujarat
      guz:Gusii
      gv:Manx
      gwi:Gwichʼin
      ha:Hausa
      hai:Haida
      hak:Cina Hakka
      haw:Hawaii
      hax:Haida Selatan
      he:Ibrani
      hi:Hindi
      hi-Latn-alt-variant:Hinglish
      hil:Hiligaynon
      hmn:Hmong
      hr:Croatia
      hsb:Sorbian Atas
      hsn:Cina Xiang
      ht:Kreol Haiti
      hu:Hungary
      hup:Hupa
      hur:Halkomelem
      hy:Armenia
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Indonesia
      ie:Interlingue
      ig:Igbo
      ii:Sichuan Yi
      ikt:Inuktitut Kanada Barat
      ilo:Iloko
      inh:Ingush
      io:Ido
      is:Iceland
      it:Itali
      iu:Inuktitut
      ja:Jepun
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jv:Jawa
      ka:Georgia
      kab:Kabyle
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kbd:Kabardia
      kbl:Kanembu
      kcg:Tyap
      kde:Makonde
      kea:Kabuverdianu
      kfo:Koro
      kg:Kongo
      kgp:Kaingang
      kha:Khasi
      khq:Koyra Chiini
      khw:Khowar
      ki:Kikuya
      kj:Kuanyama
      kk:Kazakhstan
      kkj:Kako
      kl:Kalaallisut
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Korea
      koi:Komi-Permyak
      kok:Konkani
      kpe:Kpelle
      kr:Kanuri
      krc:Karachay-Balkar
      krl:Karelian
      kru:Kurukh
      ks:Kashmir
      ksb:Shambala
      ksf:Bafia
      ksh:Colognian
      ku:Kurdish
      kum:Kumyk
      kv:Komi
      kw:Cornish
      kwk:Kwak’wala
      kxv:Kuvi
      ky:Kirghiz
      la:Latin
      lad:Ladino
      lag:Langi
      lah:Lahnda
      lb:Luxembourg
      lez:Lezghian
      lg:Ganda
      li:Limburgish
      lij:Liguria
      lil:Lillooet
      lkt:Lakota
      lmo:Lombard
      ln:Lingala
      lo:Laos
      lou:Kreol Louisiana
      loz:Lozi
      lrc:Luri Utara
      lsm:Saamia
      lt:Lithuania
      lu:Luba-Katanga
      lua:Luba-Lulua
      lun:Lunda
      luo:Luo
      lus:Mizo
      luy:Luyia
      lv:Latvia
      mad:Madura
      maf:Mafa
      mag:Magahi
      mai:Maithili
      mak:Makasar
      mas:Masai
      mde:Maba
      mdf:Moksha
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagasy
      mgh:Makhuwa-Meetto
      mgo:Meta’
      mh:Marshall
      mi:Maori
      mic:Micmac
      min:Minangkabau
      mk:Macedonia
      ml:Malayalam
      mn:Mongolia
      mni:Manipuri
      moe:Innu-aimun
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      ms:Melayu
      mt:Malta
      mua:Mundang
      mul:Pelbagai Bahasa
      mus:Creek
      mwl:Mirandese
      my:Burma
      mye:Myene
      myv:Erzya
      mzn:Mazanderani
      na:Nauru
      nan:Cina Min Nan
      nap:Neapolitan
      naq:Nama
      nb:Bokmal Norway
      nd:Ndebele Utara
      nds:Jerman Rendah
      nds-NL:Saxon Rendah
      ne:Nepal
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niu
      nl:Belanda
      nl-BE:Flemish
      nmg:Kwasio
      nn:Nynorsk Norway
      nnh:Ngiemboon
      no:Norway
      nog:Nogai
      nqo:N’ko
      nr:Ndebele Selatan
      nso:Sotho Utara
      nus:Nuer
      nv:Navajo
      ny:Nyanja
      nyn:Nyankole
      oc:Occitania
      ojb:Ojibwa Barat Laut
      ojc:Ojibwa Tengah
      ojs:Oji-Cree
      ojw:Ojibwa Barat
      oka:Okanagan
      om:Oromo
      or:Odia
      os:Ossete
      pa:Punjabi
      pag:Pangasinan
      pam:Pampanga
      pap:Papiamento
      pau:Palauan
      pcm:Nigerian Pidgin
      pis:Pijin
      pl:Poland
      pqm:Maliseet-Passamaquoddy
      prg:Prusia
      ps:Pashto
      ps-alt-variant:Pushto
      pt:Portugis
      pt-BR:Portugis Brazil
      pt-PT:Portugis Eropah
      qu:Quechua
      quc:Kʼicheʼ
      raj:Rajasthani
      rap:Rapanui
      rar:Rarotonga
      rhg:Rohingya
      rm:Romansh
      rn:Rundi
      ro:Romania
      ro-MD:Moldavia
      rof:Rombo
      ru:Rusia
      rup:Aromanian
      rw:Kinyarwanda
      rwk:Rwa
      sa:Sanskrit
      sad:Sandawe
      sah:Sakha
      saq:Samburu
      sat:Santali
      sba:Ngambay
      sbp:Sangu
      sc:Sardinia
      scn:Sicili
      sco:Scots
      sd:Sindhi
      sdh:Kurdish Selatan
      se:Sami Utara
      see:Seneca
      seh:Sena
      ses:Koyraboro Senni
      sg:Sango
      sh:SerboCroatia
      shi:Tachelhit
      shn:Shan
      shu:Arab Chadian
      si:Sinhala
      sk:Slovak
      sl:Slovenia
      slh:Lushootseed Selatan
      sm:Samoa
      sma:Sami Selatan
      smj:Lule Sami
      smn:Inari Sami
      sms:Skolt Sami
      sn:Shona
      snk:Soninke
      so:Somali
      sq:Albania
      sr:Serbia
      srn:Sranan Tongo
      ss:Swati
      ssy:Saho
      st:Sotho Selatan
      str:Straits Salish
      su:Sunda
      suk:Sukuma
      sv:Sweden
      sw:Swahili
      sw-CD:Congo Swahili
      swb:Comoria
      syr:Syriac
      szl:Silesia
      ta:Tamil
      tce:Tutchone Selatan
      te:Telugu
      tem:Timne
      teo:Teso
      tet:Tetum
      tg:Tajik
      tgx:Tagish
      th:Thai
      tht:Tahltan
      ti:Tigrinya
      tig:Tigre
      tk:Turkmen
      tlh:Klingon
      tli:Tlingit
      tly:Talysh
      tn:Tswana
      to:Tonga
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Turki
      trv:Taroko
      ts:Tsonga
      tt:Tatar
      ttm:Tutchone Utara
      tum:Tumbuka
      tvl:Tuvalu
      tw:Twi
      twq:Tasawaq
      ty:Tahiti
      tyv:Tuvinian
      tzm:Tamazight Atlas Tengah
      udm:Udmurt
      ug:Uyghur
      ug-alt-variant:Uighur
      uk:Ukraine
      umb:Umbundu
      und:Bahasa Tidak Diketahui
      ur:Urdu
      uz:Uzbekistan
      vai:Vai
      ve:Venda
      vec:Venetia
      vi:Vietnam
      vmw:Makhuwa
      vo:Volapük
      vun:Vunjo
      wa:Walloon
      wae:Walser
      wal:Wolaytta
      war:Waray
      wbp:Warlpiri
      wo:Wolof
      wuu:Cina Wu
      xal:Kalmyk
      xh:Xhosa
      xnr:Kangri
      xog:Soga
      yav:Yangben
      ybb:Yemba
      yi:Yiddish
      yo:Yoruba
      yrl:Nheengatu
      yue:Kantonis
      yue-alt-menu:Cina, Kantonis
      za:Zhuang
      zgh:Tamazight Maghribi Standard
      zh:Cina
      zh-alt-menu:Cina, Mandarin
      zh-Hans:Cina Ringkas
      zh-Hans-alt-long:Cina Mandarin Ringkas
      zh-Hant:Cina Tradisional
      zh-Hant-alt-long:Cina Mandarin Tradisional
      zu:Zulu
      zun:Zuni
      zxx:Tiada kandungan linguistik
      zza:Zaza
      """.trimIndent() }

  val ms_BN: String? = null

  val ms_ID: String? = null

  val ms_SG: String? = null

  val mt: String by lazy { """
      aa:Afar
      ab:Abkażjan
      ace:Aċiniż
      ach:Akoli
      ada:Adangme
      ady:Adyghe
      ae:Avestan
      af:Afrikans
      afh:Afriħili
      agq:Aghem
      ain:Ajnu
      ak:Akan
      akk:Akkadjen
      ale:Aleut
      alt:Altai tan-Nofsinhar
      am:Amhariku
      an:Aragoniż
      ang:Ingliż Antik
      anp:Angika
      ar:Għarbi
      ar-001:Għarbi Standard Modern
      arc:Aramajk
      arn:Mapuche
      arp:Arapaho
      arw:Arawak
      as:Assamiż
      asa:Asu
      ast:Asturian
      av:Avarik
      awa:Awadhi
      ay:Aymara
      az:Ażerbajġani
      az-alt-short:Ażeri
      ba:Bashkir
      bal:Baluċi
      ban:Baliniż
      bas:Basa
      be:Belarussu
      bej:Beja
      bem:Bemba
      bez:Bena
      bg:Bulgaru
      bho:Bhojpuri
      bi:Bislama
      bik:Bikol
      bin:Bini
      bla:Siksika
      bm:Bambara
      bn:Bengali
      bo:Tibetjan
      br:Breton
      bra:Braj
      brx:Bodo
      bs:Bożnijaku
      bua:Burjat
      bug:Buginese
      byn:Blin
      ca:Katalan
      cad:Kaddo
      car:Karib
      cch:Atsam
      ce:Chechen
      ceb:Cebuano
      cgg:Chiga
      ch:Chamorro
      chb:Chibcha
      chg:Chagatai
      chk:Ċukiż
      chm:Mari
      chn:Chinook Jargon
      cho:Choctaw
      chp:Ċipewjan
      chr:Cherokee
      chy:Cheyenne
      ckb:Kurd Ċentrali
      ckb-alt-menu:Kurd Ċentrali
      ckb-alt-variant:Kurd Ċentrali
      co:Korsiku
      cop:Koptiku
      cr:Cree
      crh:Tork tal-Krimea
      crs:Franċiż tas-Seselwa Creole
      cs:Ċek
      csb:Kashubian
      cu:Slaviku tal-Knisja
      cv:Chuvash
      cy:Welsh
      da:Daniż
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:Ġermaniż
      de-AT:Ġermaniż Awstrijak
      de-CH:Ġermaniż Żvizzeru
      del:Delawerjan
      den:Slav
      dgr:Dogrib
      din:Dinka
      dje:Zarma
      doi:Dogri
      dsb:Sorbjan Komuni
      dua:Dwala
      dum:Olandiż Medjevali
      dv:Divehi
      dyo:Jola-Fonyi
      dyu:Dyula
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      egy:Eġizzjan (Antik)
      eka:Ekajuk
      el:Grieg
      elx:Elamit
      en:Ingliż
      en-AU:Ingliż Awstraljan
      en-CA:Ingliż Kanadiż
      en-GB:Ingliż Brittaniku
      en-GB-alt-short:Ingliż (UK)
      en-US:Ingliż Amerikan
      en-US-alt-short:Ingliż (US)
      enm:Ingliż Medjevali
      eo:Esperanto
      es:Spanjol
      es-419:Spanjol Latin Amerikan
      es-ES:Spanjol Ewropew
      es-MX:Spanjol tal-Messiku
      et:Estonjan
      eu:Bask
      ewo:Ewondo
      fa:Persjan
      fan:Fang
      fat:Fanti
      ff:Fulah
      fi:Finlandiż
      fil:Filippin
      fj:Fiġjan
      fo:Faroese
      fon:Fon
      fr:Franċiż
      fr-CA:Franċiż Kanadiż
      fr-CH:Franċiż Żvizzeru
      frm:Franċiż Medjevali
      fro:Franċiż Antik
      fur:Frijuljan
      fy:Frisian tal-Punent
      ga:Irlandiż
      gaa:Ga
      gay:Gayo
      gba:Gbaya
      gd:Galliku Skoċċiż
      gez:Geez
      gil:Gilbertjan
      gl:Galiċjan
      gmh:Ġermaniż Medjevali Pulit
      gn:Guarani
      goh:Ġermaniż Antik, Pulit
      gon:Gondi
      gor:Gorontalo
      got:Gotiku
      grb:Grebo
      grc:Grieg, Antik
      gsw:Ġermaniż tal-Iżvizzera
      gu:Gujarati
      guz:Gusii
      gv:Manx
      gwi:Gwiċin
      ha:Hausa
      hai:Haida
      haw:Ħawajjan
      he:Ebrajk
      hi:Hindi
      hil:Hiligaynon
      hit:Hittite
      hmn:Hmong
      ho:Hiri Motu
      hr:Kroat
      hsb:Sorbjan ta’ Fuq
      ht:Creole ta’ Haiti
      hu:Ungeriż
      hup:Hupa
      hy:Armen
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Indoneżjan
      ie:Interlingue
      ig:Igbo
      ii:Sichuan Yi
      ik:Inupjak
      ilo:Iloko
      inh:Ingush
      io:Ido
      is:Iżlandiż
      it:Taljan
      iu:Inuktitut
      ja:Ġappuniż
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jpr:Lhudi-Persjan
      jrb:Lhudi-Għarbi
      jv:Ġavaniż
      ka:Ġorġjan
      kaa:Kara-Kalpak
      kab:Kabuljan
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kaw:Kawi
      kbd:Kabardian
      kcg:Tyap
      kde:Makonde
      kea:Cape Verdjan
      kfo:Koro
      kg:Kongo
      kha:Khasi
      kho:Kotaniż
      khq:Koyra Chiini
      ki:Kikuju
      kj:Kuanyama
      kk:Każak
      kkj:Kako
      kl:Kalallisut
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Korean
      kok:Konkani
      kos:Kosrejan
      kpe:Kpelle
      kr:Kanuri
      krc:Karachay-Balkar
      krl:Kareljan
      kru:Kurux
      ks:Kashmiri
      ksb:Shambala
      ksf:Bafia
      ksh:Kolonjan
      ku:Kurd
      kum:Kumyk
      kut:Kutenaj
      kv:Komi
      kw:Korniku
      ky:Kirgiż
      la:Latin
      lad:Ladino
      lag:Langi
      lah:Lahnda
      lam:Lamba
      lb:Lussemburgiż
      lez:Leżgjan
      lg:Ganda
      li:Limburgish
      lkt:Lakota
      ln:Lingaljan
      lo:Laosjan
      lol:Mongo
      loz:Lożi
      lrc:Luri tat-Tramuntana
      lt:Litwan
      lu:Luba-Katanga
      lua:Luba-Luluwa
      lui:Luiseno
      lun:Lunda
      luo:Luo
      lus:Mizo
      luy:Luyia
      lv:Latvjan
      mad:Maduriż
      mag:Magahi
      mai:Maithili
      mak:Makasar
      man:Mandingo
      mas:Masai
      mdf:Moksha
      mdr:Mandar
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagasy
      mga:Irlandiż Medjevali
      mgh:Makhuwa-Meetto
      mgo:Metà
      mh:Marshalljaniż
      mi:Maori
      mic:Micmac
      min:Minangkabau
      mk:Maċedonjan
      ml:Malayalam
      mn:Mongoljan
      mnc:Manchu
      mni:Manipuri
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      ms:Malay
      mt:Malti
      mua:Mundang
      mul:Lingwi Diversi
      mus:Kriek
      mwl:Mirandiż
      mwr:Marwari
      my:Burmiż
      myv:Erzya
      mzn:Mazanderani
      na:Naurujan
      nap:Naplitan
      naq:Nama
      nb:Bokmal Norveġiż
      nd:Ndebeli tat-Tramuntana
      nds:Ġermaniż Komuni
      nds-NL:Sassonu Komuni
      ne:Nepaliż
      new:Newari
      ng:Ndonga
      nia:Nijas
      niu:Niuean
      nl:Olandiż
      nl-BE:Fjamming
      nmg:Kwasio
      nn:Ninorsk Norveġiż
      nnh:Ngiemboon
      no:Norveġiż
      nog:Nogai
      non:Nors Antik
      nqo:N’Ko
      nr:Ndebele tan-Nofsinhar
      nso:Soto tat-Tramuntana
      nus:Nuer
      nv:Navajo
      nwc:Newari Klassiku
      ny:Nyanja
      nym:Njamweżi
      nyn:Nyankole
      nyo:Nyoro
      nzi:Nzima
      oc:Oċċitan
      oj:Oġibwa
      om:Oromo
      or:Odia
      os:Ossettiku
      osa:Osaġjan
      ota:Tork Ottoman
      pa:Punjabi
      pag:Pangasinjan
      pal:Pahlavi
      pam:Pampanga
      pap:Papiamento
      pau:Palawjan
      pcm:Pidgin Niġerjan
      peo:Persjan Antik
      phn:Feniċju
      pi:Pali
      pl:Pollakk
      pon:Ponpejan
      prg:Prussu
      pro:Provenzal Antik
      ps:Pashto
      pt:Portugiż
      pt-BR:Portugiż tal-Brażil
      pt-PT:Portugiż Ewropew
      qu:Quechua
      quc:K’iche’
      raj:Raġastani
      rap:Rapanwi
      rar:Rarotongani
      rm:Romanz
      rn:Rundi
      ro:Rumen
      ro-MD:Moldovan
      rof:Rombo
      rom:Romanesk
      ru:Russu
      rup:Aromanjan
      rw:Kinjarwanda
      rwk:Rwa
      sa:Sanskrit
      sad:Sandawe
      sah:Sakha
      sam:Samaritan Aramajk
      saq:Samburu
      sas:Sasak
      sat:Santali
      sba:Ngambay
      sbp:Sangu
      sc:Sardinjan
      scn:Sqalli
      sco:Skoċċiż
      sd:Sindhi
      se:Sami tat-Tramuntana
      seh:Sena
      sel:Selkup
      ses:Koyraboro Senni
      sg:Sango
      sga:Irlandiż Antik
      sh:Serbo-Kroat
      shi:Tachelhit
      shn:Shan
      si:Sinhala
      sid:Sidamo
      sk:Slovakk
      sl:Sloven
      sm:Samoan
      sma:Sami tan-Nofsinhar
      smj:Lule Sami
      smn:Inari Sami
      sms:Skolt Sami
      sn:Shona
      snk:Soninke
      so:Somali
      sog:Sogdien
      sq:Albaniż
      sr:Serb
      srn:Sranan Tongo
      srr:Serer
      ss:Swati
      ssy:Saho
      st:Soto tan-Nofsinhar
      su:Sundaniż
      suk:Sukuma
      sus:Susu
      sux:Sumerjan
      sv:Żvediż
      sw:Swahili
      sw-CD:Swahili tar-Repubblika Demokratika tal-Kongo
      swb:Komorjan
      syr:Sirjan
      ta:Tamil
      te:Telugu
      tem:Timne
      teo:Teso
      ter:Tereno
      tet:Tetum
      tg:Taġik
      th:Tajlandiż
      ti:Tigrinya
      tig:Tigre
      tiv:Tiv
      tk:Turkmeni
      tkl:Tokelau
      tl:Tagalog
      tlh:Klingon
      tli:Tlingit
      tmh:Tamashek
      tn:Tswana
      to:Tongan
      tog:Nyasa Tonga
      tpi:Tok Pisin
      tr:Tork
      trv:Taroko
      ts:Tsonga
      tsi:Tsimshian
      tt:Tatar
      tum:Tumbuka
      tvl:Tuvalu
      tw:Twi
      twq:Tasawaq
      ty:Taħitjan
      tyv:Tuvinjan
      tzm:Tamazight tal-Atlas Ċentrali
      udm:Udmurt
      ug:Uyghur
      uga:Ugaritiku
      uk:Ukren
      umb:Umbundu
      und:Lingwa Mhix Magħrufa
      ur:Urdu
      uz:Uzbek
      vai:Vai
      ve:Venda
      vi:Vjetnamiż
      vo:Volapuk
      vot:Votik
      vun:Vunjo
      wa:Walloon
      wae:Walser
      wal:Walamo
      war:Waray
      was:Washo
      wo:Wolof
      xal:Kalmyk
      xh:Xhosa
      xog:Soga
      yao:Yao
      yap:Yapese
      yav:Yangben
      ybb:Yemba
      yi:Yiddish
      yo:Yoruba
      yue:Kantoniż
      yue-alt-menu:Kantoniż
      za:Zhuang
      zap:Zapotec
      zen:Zenaga
      zgh:Tamazight Standard tal-Marokk
      zh:Ċiniż
      zh-alt-menu:Ċiniż
      zh-Hans:Ċiniż Simplifikat
      zh-Hans-alt-long:Ċiniż Simplifikat
      zh-Hant:Ċiniż Tradizzjonali
      zh-Hant-alt-long:Ċiniż Tradizzjonali
      zu:Zulu
      zun:Zuni
      zxx:Bla kontenut lingwistiku
      zza:Zaza
      """.trimIndent() }

  val mua: String by lazy { """
      ak:akaŋ
      am:amharik
      ar:arabiya
      be:belarussiya
      bg:bulgaria
      bn:bengalia
      cs:syekya
      de:germaŋ
      el:grek
      en:zah Anglofoŋ
      es:Espaniya
      fa:Persia
      fr:zah sǝr Franssǝ
      ha:haussa
      hi:hindi
      hu:hungariya
      id:indonesiya
      ig:igbo
      it:italiya
      ja:zah sǝr Japoŋ
      jv:javaniya
      km:kmer
      ko:korea
      ms:malasiya
      mua:MUNDAŊ
      my:birmania
      ne:Nepaliya
      nl:zah sǝr ma kasǝŋ
      pa:Pǝnjabi
      pl:Poloniya
      pt:Zah sǝr Portugal
      ro:Romaniya
      ru:Russiya
      rw:Zah sǝr Rwanda
      so:Somaliya
      sv:Swedia
      ta:Tamul
      tr:Turk
      uk:Ukrainia
      ur:Urdu
      vi:Vietnamiya
      yo:Yoruba
      zh:zah Syiŋ
      zh-alt-menu:zah Syiŋ
      zu:Zulu
      """.trimIndent() }

  val mus: String by lazy { """
      mus:Mvskoke
      """.trimIndent() }

  val my: String by lazy { """
      aa:အာဖာ
      ab:အဘ်ခါဇီရာ
      ace:အာချေး
      ada:ဒန်မဲ
      ady:အဒိုင်ဂီ
      af:အာဖရိကန်
      agq:အာဂ်ဟိန်း
      ain:အိန်နု
      ak:အာကန်
      ale:အာလီယု
      alt:တောင် အာလ်တိုင်း
      am:အမ်ဟာရစ်ခ်
      an:အာရာဂွန်
      ang:အင်ဂလို ဆက္ကစွန်
      ann:အိုဘိုလို
      anp:အန်ဂီကာ
      ar:အာရဗီ
      ar-001:ခေတ်သစ် ရှေ့ဆောင် အာရဗီ
      arn:မာပုချီ
      arp:အာရာပါဟို
      ars:နာ့ဂျဒီ အာရဗစ်
      as:အာသံ
      asa:အာစု
      ast:အက်စ်တိုးရီးယား
      atj:အာတီကမဲကု
      av:အာဗာရစ်ခ်
      awa:အာဝါဒီ
      ay:အိုင်မာရ
      az:အဇာဘိုင်ဂျန်
      az-alt-short:အဇာရီ
      ba:ဘက်ရှ်ကာ
      ban:ဘာလီ
      bas:ဘာဆာ
      be:ဘီလာရုစ်
      bem:ဘိန်ဘာ
      bez:ဘီနာ
      bg:ဘူလ်ဂေးရီးယား
      bgc:ဟာယန်ဗီ
      bgn:အနောက် ဘဲလိုချီ
      bho:ဘို့ဂျ်ပူရီ
      bi:ဘစ်စ်လာမာ
      bin:ဘီနီ
      bla:စစ္စီကာ
      blo:အန်နီ
      bm:ဘန်ဘာရာ
      bn:ဘင်္ဂါလီ
      bo:တိဘက်
      br:ဘရီတွန်
      brx:ဗိုဒို
      bs:ဘော့စ်နီးယား
      bug:ဘူဂစ်စ်
      byn:ဘလင်
      ca:ကတ်တလန်
      cay:ကာယုဂါ
      ccp:ချတ်ခ်မာ
      ce:ချက်ချန်း
      ceb:စီဗူအာနို
      cgg:ချီဂါ
      ch:ချမိုရို
      chk:ချူကီးစ်
      chm:မာရီ
      cho:ချော့တို
      chp:ချီပွေဝိုင်ရန်
      chr:ချာရိုကီ
      chy:ချေယန်း
      ckb:ဗဟိုဒေသသုံး ကဒ်ဘာသာ
      ckb-alt-menu:ကဒ် ဗဟို
      ckb-alt-variant:ကဒ် ဆိုရာနီ
      clc:ချီကိုလ်တင်
      co:ခိုစီကန်
      cr:ခရီး
      crg:မစ်ချစ်ခ်
      crj:တောင်ပိုင်း အရှေ့ခရီ
      crk:ပလိန်းစ် ခရီ
      crl:မြောက်ပိုင်း အရှေ့ခရီ
      crm:မုစ်ခရီး
      crr:ကယ်ရိုလိုင်းနား အယ်လ်ဂွန်းကီယန်
      crs:ခရီအိုလီ
      cs:ချက်
      csw:ဆွမ်ပီ ခရီ
      cu:ချပ်ချ် စလာဗစ်
      cv:ချူဗက်ရှ်
      cy:ဝေလ
      da:ဒိန်းမတ်
      dak:ဒါကိုတာ
      dar:ဒါဂ်ဝါ
      dav:တိုင်တာ
      de:ဂျာမန်
      de-AT:ဩစတြီးယား ဂျာမန်
      de-CH:အလီမဲန်နစ် ဂျာမန်
      del:ဒယ်လာဝဲလ်
      dgr:ဒေါ့ဂ်ရစ်ဘ်
      dje:ဇာမာ
      doi:ဒိုဂရီ
      dsb:အနိမ့် ဆိုဘီယန်း
      dua:ဒူအလာ
      dum:အလယ်ပိုင်း ဒတ်ချ်
      dv:ဒီဗာဟီ
      dyo:ဂျိုလာ-ဖွန်ရီ
      dz:ဒဇွန်ကာ
      dzg:ဒဇာဂါ
      ebu:အမ်ဘူ
      ee:အီဝီ
      efi:အာဖိခ်
      egy:ရှေးဟောင်း အီဂျစ်
      eka:အီကာဂျုခ်
      el:ဂရိ
      en:အင်္ဂလိပ်
      en-AU:ဩစတြေးလျ အင်္ဂလိပ်
      en-CA:ကနေဒါ အင်္ဂလိပ်
      en-GB:ဗြိတိသျှ အင်္ဂလိပ်
      en-GB-alt-short:ယူကေ အင်္ဂလိပ်
      en-US:အမေရိကန် အင်္ဂလိပ်
      en-US-alt-short:ယူအက်စ် အင်္ဂလိပ်
      enm:အလယ်ပိုင်း အင်္ဂလိပ်
      eo:အက်စ်ပရန်တို
      es:စပိန်
      es-ES:စပိန် (ဥရောပ)
      es-MX:စပိန် (မက္ကဆီကို)
      et:အက်စ်တိုးနီးယား
      eu:ဘာစ်ခ်
      ewo:အီဝန်ဒို
      fa:ပါရှန်
      fa-AF:ဒါရီ
      ff:ဖူလာ
      fi:ဖင်လန်
      fil:ဖိလစ်ပိုင်
      fj:ဖီဂျီ
      fo:ဖာရို
      fon:ဖော်န်
      fr:ပြင်သစ်
      fr-CA:ကနေဒါ ပြင်သစ်
      fr-CH:ဆွစ် ပြင်သစ်
      frc:ကေဂျန် ဖရန့်စ်
      frm:အလယ်ပိုင်း ပြင်သစ်
      fro:ဖရန်စီစ်
      frr:မြောက် ဖရီစီရန်
      frs:အရှေ့ ဖရီစီရန်
      fur:ဖရူလီယန်း
      fy:အနောက် ဖရီစီရန်
      ga:အိုင်းရစ်ရှ်
      gaa:ဂါ
      gag:ဂါဂုဇ်
      gd:စကော့တစ်ရှ် ဂေးလစ်ခ်
      gez:ဂီးဇ်
      gil:ကာရီဗာတီ
      gl:ဂါလီစီယာ
      gmh:အလယ်ပိုင်း အမြင့် ဂျာမန်
      gn:ဂူအာရာနီ
      gor:ဂိုရိုတာလို
      grc:ရှေးဟောင်း ဂရိ
      gsw:ဆွစ် ဂျာမန်
      gu:ဂူဂျာရသီ
      guz:ဂူစီး
      gv:မန်းဇ်
      gwi:ဂွစ်ချင်
      ha:ဟာဥစာ
      hai:ဟေဒါ
      haw:ဟာဝိုင်ယီ
      hax:တောင် ဟိုင်ဒါ
      he:ဟီဘရူး
      hi:ဟိန္ဒီ
      hi-Latn:ဟိန္ဒီ (လက်တင်)
      hi-Latn-alt-variant:ဟိန္ဒီ (လက်တင်)
      hil:ဟီလီဂေနွန်
      hmn:မုံ
      hr:ခရိုအေးရှား
      hsb:ဆက္ကဆိုနီ
      ht:ဟေတီ
      hu:ဟန်ဂေရီ
      hup:ဟူပါ
      hur:ဟော့ကမိုလွမ်
      hy:အာမေးနီးယား
      hz:ဟီရဲရို
      ia:အင်တာလင်ဂွါ
      iba:အီဗန်
      ibb:အီဘီဘီယို
      id:အင်ဒိုနီးရှား
      ie:အင်တာလင်း
      ig:အစ္ဂဘို
      ii:စီချွမ် ရီ
      ikt:အနောက် ကနေဒီယန် အီနုတီတွတ်
      ilo:အီလိုကို
      inh:အင်ဂုရှ်
      io:အီဒို
      is:အိုက်စ်လန်
      it:အီတလီ
      iu:အီနုခ်တီတု
      ja:ဂျပန်
      jbo:လိုဂျ်ဘန်
      jgo:ဂွမ်ဘာ
      jmc:မချာမီ
      jpr:ဂျူဒီယို-ပါရှန်
      jrb:ဂျူဒီယို-အာရဗီ
      jv:ဂျာဗား
      ka:ဂျော်ဂျီယာ
      kab:ကဘိုင်လ်
      kac:ကချင်
      kaj:ဂျူအူ
      kam:ကမ်ဘာ
      kbd:ကဘာဒင်
      kcg:တိုင်အပ်
      kde:မာခွန်ဒီ
      kea:ကဘူဗာဒီအာနူ
      kfo:ကိုရို
      kg:ကွန်ဂို
      kgp:ကိန်းဂန်
      kha:ခါစီ
      khq:ကိုရာ ချီအီနီ
      ki:ကီကူယူ
      kj:ကွန်းယာမာ
      kk:ကာဇာချ
      kkj:ကကို
      kl:ကလာအ်လီဆပ်
      kln:ကလန်ဂျင်
      km:ခမာ
      kmb:ကင်ဘွန်ဒူ
      kn:ကန်နာဒါ
      ko:ကိုရီးယား
      koi:ကိုမီ-ပါမြက်
      kok:ကွန်ကနီ
      kpe:ကပ်ပဲလ်
      kr:ကနူရီ
      krc:ကရာချေး-ဘာကာ
      krl:ကာရီလီယန်
      kru:ကူရုပ်ခ်
      ks:ကက်ရှ်မီးယား
      ksb:ရှန်ဘာလာ
      ksf:ဘာဖီအာ
      ksh:ကိုလိုနီယန်း
      ku:ကဒ်
      kum:ကွမ်မိုက်
      kv:ကိုမီ
      kw:ခိုနီရှ်
      kwk:ကွပ်ခ်ဝါလာ
      kxv:ကူဗီ
      ky:ကာဂျစ်
      la:လက်တင်
      lad:လာဒီနို
      lag:လန်ဂီ
      lb:လူဇင်ဘတ်
      lez:လက်ဇ်ဂီးယား
      lg:ဂန်ဒါ
      li:လင်ဘာဂစ်ရှ်
      lij:လက်ဂါးရီရန်
      lil:လာလူးဝစ်တ်
      lkt:လာကိုတာ
      lmo:လန်းဘတ်
      ln:လင်ဂါလာ
      lo:လာအို
      lou:လူဝီဇီယားနား ခရီးယို
      loz:လိုဇီ
      lrc:မြောက်လူရီ
      lsm:ဆာမိအာ
      lt:လစ်သူဝေးနီးယား
      lu:လူဘာ-ကတန်ဂါ
      lua:လူဘာ-လူလူအာ
      lun:လွန်ဒါ
      luo:လူအို
      lus:မီဇို
      luy:လူရီအာ
      lv:လတ်ဗီးယား
      mad:မဒူရာ
      mag:မဂါဟီ
      mai:မိုင်သီလီ
      mak:မကာဆာ
      mas:မာဆိုင်
      mdf:မို့ခ်ရှာ
      men:မန်ဒဲ
      mer:မီရု
      mfe:မောရစ်ရှ
      mg:မာလဂက်စီ
      mga:အလယ်ပိုင်း အိုင်းရစ်ရှ်
      mgh:မာခူဝါ-မီအီတို
      mgo:မီတာ
      mh:မာရှယ်လိဇ်
      mi:မာအိုရီ
      mic:မစ်ခ်မက်ခ်
      min:စူကူမီနန်
      mk:မက်ဆီဒိုးနီးယား
      ml:မလေယာလမ်
      mn:မွန်ဂိုလီးယား
      mnc:မန်ချူး
      mni:မနိပူရ
      moe:အီနုအေမွန်
      moh:မိုဟော့ခ်
      mos:မိုစီ
      mr:မာရသီ
      ms:မလေး
      mt:မော်လ်တာ
      mua:မွန်ဒန်း
      mul:ဘာသာစကား အမျိုးမျိုး
      mus:ခရိချ
      mwl:မီရန်ဒီးဇ်
      my:မြန်မာ
      myv:အီဇယာ
      mzn:မာဇန်ဒါရန်နီ
      na:နော်ရူး
      nap:နပိုလီတန်
      naq:နာမာ
      nb:နော်ဝေ ဘွတ်ခ်မော်လ်
      nd:မြောက် အွန်န်ဒီဘီလီ
      nds:အနိမ့် ဂျာမန်
      nds-NL:ဂျာမန် (နယ်သာလန်)
      ne:နီပေါ
      new:နီဝါရီ
      ng:အွန်ဒွန်ဂါ
      nia:နီးရပ်စ်
      niu:နူအဲယန်း
      nl:ဒတ်ခ်ျ
      nl-BE:ဖလီမစ်ရှ်
      nmg:ကွာစီအို
      nn:နော်ဝေ နီးနောစ်
      nnh:အွန်ရဲဘွန်း
      no:နော်ဝေ
      nog:နိုဂိုင်
      nqo:အွန်ကို
      nr:တောင် အွန်န်ဘီလီ
      nso:မြောက် ဆိုသို
      nus:နူအာ
      nv:နာဗာဟို
      ny:နရန်ဂျာ
      nyn:နရန်ကိုလီ
      oc:အိုစီတန်
      ojb:အိုဂျစ်ဘွာ
      ojc:အိုဂျစ်ဘွေး
      ojs:အိုဂျီခရီ
      ojw:အနောက် အိုဂျီဘွာ
      oka:အိုကနဂန်
      om:အိုရိုမို
      or:အိုရီရာ
      os:အိုဆဲတစ်ခ်
      pa:ပန်ချာပီ
      pag:ပန်ဂါစီနန်
      pam:ပမ်ပန်ညာ
      pap:ပါပီမင်တို
      pau:ပလာအို
      pcm:နိုင်ဂျီးရီးယား ပစ်ဂျင်
      peo:ပါရှန် အဟောင်း
      pi:ပါဠိ
      pis:ပီဂျင်
      pl:ပိုလန်
      pqm:မလိဇိ ပါစမ်မကွာဒီ
      prg:ပရူရှန်
      ps:ပက်ရှ်တွန်း
      pt:ပေါ်တူဂီ
      pt-BR:ဘရာဇီး ပေါ်တူဂီ
      pt-PT:ဥရောပ ပေါ်တူဂီ
      qu:ခီချူဝါအိုဝါ
      quc:ကီခ်အီချီ
      raj:ရာဂျာစတာနီ
      rap:ရပန်နူအီ
      rar:ရရိုတွန်ဂန်
      rhg:ရိုဟင်ဂျာ
      rm:ရောမ
      rn:ရွန်ဒီ
      ro:ရိုမေနီယား
      ro-MD:မော်လဒိုဗာ
      rof:ရွမ်ဘို
      ru:ရုရှ
      rup:အာရိုမန်းနီးယန်း
      rw:ကင်ရာဝန်ဒါ
      rwk:ရူဝမ်
      sa:သင်္သကရိုက်
      sad:ဆန်ဒါဝီ
      sah:ဆခါ
      saq:ဆမ်ဘူရူ
      sat:ဆန်တာလီ
      sba:အွန်ဂမ်းဘေး
      sbp:ဆန်ဂု
      sc:ဆာဒီနီးယား
      scn:စစ္စလီ
      sco:စကော့တ်
      sd:စင်ဒီ
      se:မြောက် ဆာမိ
      seh:စီနာ
      ses:ကိုရာဘိုရို ဆမ်နီ
      sg:ဆန်ဂို
      sga:အိုင်းရစ် ဟောင်း
      shi:တာချယ်လ်ဟစ်
      shn:ရှမ်း
      si:စင်ဟာလာ
      sk:ဆလိုဗက်
      sl:ဆလိုဗေးနီးယား
      slh:တောင် လာ့ရှုစတိ
      sm:ဆမိုအာ
      sma:တောင် ဆာမိ
      smj:လူလီ ဆာမိ
      smn:အီနာရီ ဆာမိ
      sms:စခိုးလ် ဆာမိ
      sn:ရှိုနာ
      snk:ဆိုနင်ကေး
      so:ဆိုမာလီ
      sq:အယ်လ်ဘေးနီးယား
      sr:ဆားဘီးယား
      srn:ဆရာနန် တွန်ဂို
      ss:ဆွာဇီလန်
      ssy:ဆာဟို
      st:တောင်ပိုင်း ဆိုသို
      str:ဆဲလစ်ရှ် ရေလက်ကြား
      su:ဆူဒန်
      suk:ဆူကူမာ
      sv:ဆွီဒင်
      sw:ဆွာဟီလီ
      sw-CD:ကွန်ဂို ဆွာဟီလီ
      swb:ကိုမိုရီးယန်း
      syr:ဆီးရီးယား
      szl:စလီရှန်
      ta:တမီးလ်
      tce:တောင် တပ်ချွန်
      te:တီလီဂူ
      tem:တင်မ်နဲ
      teo:တီဆို
      tet:တီတွမ်
      tg:တာဂျစ်
      tgx:တာဂစ်ရှ်
      th:ထိုင်း
      tht:တဟီတန်
      ti:တီဂ်ရင်ယာ
      tig:တီဂရီ
      tk:တာ့ခ်မင်နစ္စတန်
      tlh:ကလင်ဂွန်
      tli:တလင်းဂစ်
      tn:တီဆဝါနာ
      to:တွန်ဂါ
      tok:တိုကီပိုနာ
      tpi:တော့ခ် ပိစင်
      tr:တူရကီ
      trv:တရိုကို
      ts:ဆွန်ဂါ
      tt:တာတာ
      ttm:မြောက် တပ်ချွန်
      tum:တမ်ဘူကာ
      tvl:တူဗာလူ
      twq:တာဆာဝါချ
      ty:တဟီတီ
      tyv:တူဗန်
      tzm:အလယ်အာ့တလာစ် တာမာဇိုက်
      udm:အူမူရတ်
      ug:ဝီဂါ
      uk:ယူကရိန်း
      umb:အူဘန်ဒူ
      und:မသိသော ဘာသာ
      ur:အူရ်ဒူ
      uz:ဥဇဘတ်
      vai:ဗိုင်
      ve:ဗင်န်ဒါ
      vec:ဗနီးရှန်
      vi:ဗီယက်နမ်
      vmw:မတ်ကူးဝါး
      vo:ဗိုလာပိုက်
      vun:ဗွန်ဂျို
      wa:ဝါလူးန်
      wae:ဝေါလ်ဆာ
      wal:ဝိုလက်တာ
      war:ဝါရေး
      wbp:ဝေါလ်ပီရီ
      wo:ဝူလိုဖ်
      wuu:ဝူ တရုတ်
      xal:ကာလ်မိုက်
      xh:ဇိုစာ
      xnr:ခန်းဂရီ
      xog:ဆိုဂါ
      yav:ရန်ဘဲန်
      ybb:ရမ်ဘာ
      yi:ရဟူဒီ
      yo:ယိုရူဘာ
      yrl:အန်ဟင်းဂတူ
      yue:ကွမ်းတုံ
      yue-alt-menu:တရုတ်/ ကွမ်းတုံ
      za:ဂျွမ်
      zgh:မိုရိုကို တမဇိုက်
      zh:တရုတ်
      zh-alt-menu:ပြည်ကြီးတရုတ်
      zh-Hans-alt-long:ပြည်ကြီးတရုတ် (ရိုးရှင်း)
      zh-Hant-alt-long:ပြည်ကြီးတရုတ် (ရိုးရာ)
      zu:ဇူးလူး
      zun:ဇူနီ
      zxx:ဘာသာစကားနှင့် ပတ်သက်သောအရာ မရှိပါ
      zza:ဇာဇာ
      """.trimIndent() }

  val myv: String by lazy { """
      myv:эрзянь кель
      """.trimIndent() }

  val mzn: String by lazy { """
      ab:آبخازی
      af:آفریکانس
      agq:آقم
      ak:آکان
      am:امهری
      ar:عربی
      ar-001:مدرن استاندارد عربی
      arn:ماپوچه
      as:آسامی
      asa:آسو
      az:آذری ِترکی
      az-alt-short:آذری
      az-Arab:جنوبی آذری ترکی
      ba:باشقیری
      be:بلاروسی
      bem:بمبایی
      bez:بنایی
      bg:بلغاری
      bgn:غربی بلوچی
      bm:بامبارایی
      bn:بنگالی
      bo:تبتی
      br:برِتونی
      brx:بدویی
      bs:بوسنیایی
      ca:کاتالونی
      ce:چچنی
      cgg:چیگا
      chr:چروکیایی
      ckb:میونی کوردی
      ckb-alt-menu:میونی کوردی
      ckb-alt-variant:میونی کوردی
      co:کورسیکان
      cs:چکی
      cv:چوواشی
      cy:ولزی
      da:دانمارکی
      dav:تایتا
      de:آلمانی
      de-AT:اتریش ِآلمانی
      de-CH:سوییس ِآلمانی
      dje:زارمایی
      dsb:پایین صربی
      dua:دوئالایی
      dyo:جولا-فونی
      dz:دزونگخا
      ebu:امبو
      ee:اوه‌یی
      el:یونانی
      en:انگلیسی
      en-AU:استرالیای ِانگلیسی
      en-CA:کانادای ِانگلیسی
      en-GB:بریتیش انگلیسی
      en-GB-alt-short:بریتانیای ِانگلیسی
      en-US:امریکن انگلیسی
      en-US-alt-short:آمریکای ِانگلیسی
      eo:اسپرانتو
      es:ایسپانیولی
      es-419:جنوبی آمریکای ِایسپانیولی
      es-ES:اروپای ِایسپانیولی
      es-MX:مکزیک ِایسپانیولی
      et:استونیایی
      eu:باسکی
      fa:فارسی
      fi:فینیش
      fil:فیلیپینو
      fj:فیجیایی
      fo:فارویی
      fr:فرانسوی
      fr-CA:کانادای ِفرانسوی
      fr-CH:سوییس ِفرانسوی
      fy:غربی فیریزی
      ga:ایریش
      gag:گاگائوزی
      gl:گالیک
      gn:گورانی
      gsw:سوییس آلمانی
      gu:گجراتی
      guz:گوسی
      gv:مانکس
      ha:هوسا
      haw:هاواییایی
      he:عبری
      hi:هندی
      hr:کرواتی
      hsb:بالایی صربی
      ht:هائتیایی
      hu:مجاری
      hy:ارمنی
      id:اندونزیایی
      ig:ایگبو
      ii:سیچوئان یی
      is:ایسلندی
      it:ایتالیایی
      iu:انوکتیتوت
      ja:جاپونی
      jgo:نگومبا
      jmc:ماچامه
      jv:جاوایی
      ka:گرجی
      kab:قبایلی
      kam:کامبایی
      kde:ماکونده
      kea:کیپ وُردی
      khq:کویرا چیینی
      ki:کیکویو
      kk:قزاقی
      kl:کالائلیسوت
      kln:کالنجین
      km:خمری
      kn:کانّادا
      ko:کُره‌یی
      koi:کومی-پرمیاک
      kok:کونکانی
      ks:کشمیری
      ksb:شامبالا
      ksf:بافیایی
      ku:کوردی
      kw:کورنیش
      ky:قرقیزی
      la:لاتین
      lag:لانگی
      lb:لوکزامبورگی
      lg:گاندا
      lkt:لاکوتا
      ln:لینگالا
      lo:لائویی
      lrc:شمالی لُری
      lt:لتونیایی
      lu:لوبا-کاتانگا
      luo:لوئو
      luy:لوییا
      lv:لاتویایی
      mas:ماسایی
      mer:مِرویی
      mfe:موریسین
      mg:مالاگاسی
      mgh:ماخوئا-میتو
      mgo:مِتاء
      mi:مائوری
      mk:مقدونی
      ml:مالایالام
      mn:مغولی
      moh:موهاک
      mr:ماراتی
      ms:مالایی
      mt:مالتی
      mua:موندانگ
      my:برمه‌یی
      mzn:مازرونی
      naq:ناما
      nb:نروژی بوکمال
      nd:شمالی ندبله
      nds:پایین آلمانی
      nds-NL:پایین ساکسونی
      ne:نپالی
      nl:هلندی
      nl-BE:فلمیش
      nmg:کوئاسیو
      nn:نروژی نینورسک
      nqo:نئکو
      nus:نوئر
      nyn:نیانکوله
      om:اورومو
      or:اوریا
      pa:پنجابی
      pl:لهستونی
      ps:پشتو
      pt:پرتغالی
      pt-BR:برزیل ِپرتغالی
      pt-PT:اروپای ِپرتغالی
      qu:قوئچوئا
      quc:کئیچه‌ئی
      rm:رومانش
      rn:روندی
      ro:رومانیایی
      ro-MD:مولداوی
      rof:رومبو
      ru:روسی
      rw:کنیاروآندایی
      rwk:روآیی
      sa:سانسکریت
      saq:سامبورو
      sbp:سانگوو
      sd:سندی
      sdh:جنوبی کردی
      se:شمالی سامی
      seh:سِنایی
      ses:کویرابورا سنی
      sg:سانگو
      shi:تاچلهیت
      si:سینهالا
      sk:اسلواکی
      sl:اسلوونیایی
      sma:جنوبی سامی
      smj:لوله سامی
      smn:ایناری سامی
      sms:سکولت سامی
      sn:شونا
      so:سومالیایی
      sq:آلبانیایی
      sr:صربی
      su:سوندانسی
      sv:سوئدی
      sw:سواحیلی
      sw-CD:کنگو سواحیلی
      ta:تامیلی
      te:تلوگویی
      teo:تسویی
      tg:تاجیکی
      th:تایی
      ti:تیگرینیایی
      tk:ترکمونی
      to:تونگانی
      tr:ترکی
      tt:تاتاری
      twq:تاساواقی
      tzm:میونی اطلس تامزیقی
      ug:ئوغوری
      uk:اوکراینی
      und:نشناسی‌یه زوون
      ur:اردو
      uz:ازبکی
      vai:وایی
      vi:ویتنامی
      vun:وونجویی
      wbp:والرپیری
      wo:وولفی
      xh:خوسا
      xog:سوگا
      yo:یوروبا
      zgh:مراکش ِاستاندارد ِتامازیقتی
      zh:چینی
      zh-alt-menu:چینی
      zh-Hans:ساده چینی
      zh-Hans-alt-long:ساده چینی
      zh-Hant:سنتی چینی
      zh-Hant-alt-long:سنتی چینی
      zu:زولو
      zxx:این زوون بشناسی‌یه نیّه
      """.trimIndent() }

  val naq: String by lazy { """
      ak:Akangowab
      am:Amharicgowab
      ar:Arabiǁî gowab
      be:Belarusanǁî gowab
      bg:Bulgariaǁî gowab
      bn:Bengaliǁî gowab
      cs:Czechǁî gowab
      de:Duits
      el:Xriks
      en:Engels
      es:Spaans
      fa:Persiaǁî gowab
      fr:Frans
      ha:Hausagowab
      hi:Hindigowab
      hu:Hungariaǁî gowab
      id:Indonesiaǁî gowab
      ig:Igbogowab
      it:Italians
      ja:Japanees
      jv:Javanese
      km:Khmerǁî gowab, Central
      ko:Koreaǁî gowab
      ms:Malayǁî gowab
      my:Burmesǁî gowab
      naq:Khoekhoegowab
      ne:Nepalǁî gowab
      nl:Hollands
      pa:Punjabigowab
      pl:Poleǁî gowab
      pt:Portugees
      ro:Romaniaǁî gowab
      ru:Russiaǁî gowab
      rw:Rwandaǁî gowab
      so:Somaliǁî gowab
      sv:Swedeǁî gowab
      ta:Tamilǁî gowab
      th:Thaiǁî gowab
      tr:Turkeǁî gowab
      uk:Ukrainiaǁî gowab
      ur:Urduǁî gowab
      vi:Vietnamǁî gowab
      yo:Yorubab
      zh:Chineesǁî gowab, Mandarinni
      zh-alt-menu:Chineesǁî gowab, Mandarinni
      zu:Zulub
      """.trimIndent() }

  val nb: String? = null

  val nb_SJ: String? = null

  val nd: String by lazy { """
      ak:isi-Akhani
      am:isi-Amaharikhi
      ar:isi-Alabhu
      be:isi-Bhelarashiyani
      bg:isi-Bulgaria
      bn:isi-Bhengali
      cs:isi-Czech
      de:isi-Jalimani
      el:isi-Giliki
      en:isi-Ngisi
      es:isi-Sipeyini
      fa:isi-Pheshiyani
      fr:isi-Fulentshi
      ha:isi-Hausa
      hi:isi-Hindi
      hu:isi-Hangari
      id:isi-Indonesia
      ig:isi-Igbo
      it:isi-Italiano
      ja:isi-Japhani
      jv:isi-Java
      km:isi-Khambodiya
      ko:isi-Koriya
      ms:isi-Malayi
      my:isi-Burma
      nd:isiNdebele
      ne:isi-Nepali
      nl:isi-Dutch
      pa:isi-Phunjabi
      pl:isi-Pholoshi
      pt:isi-Potukezi
      ro:isi-Romani
      ru:isi-Rashiya
      rw:isi-Ruwanda
      so:isi-Somali
      sv:isi-Swidishi
      ta:isi-Thamil
      th:isi-Thayi
      tr:isi-Thekishi
      uk:isi-Ukrain
      ur:isi-Udu
      vi:isi-Vietnamese
      yo:isi-Yorubha
      zh:isi-China
      zh-alt-menu:isi-China
      zu:isi-Zulu
      """.trimIndent() }

  val nds: String by lazy { """
      en:Engelsch
      nds:Neddersass’sch
      """.trimIndent() }

  val nds_NL: String? = null

  val ne: String by lazy { """
      aa:अफार
      ab:अब्खाजियाली
      ace:अचाइनिज
      ach:अकोली
      ada:अदाङमे
      ady:अदिघे
      ae:अवेस्तान
      af:अफ्रिकान्स
      afh:अफ्रिहिली
      agq:आघेम
      ain:अइनु
      ak:आकान
      akk:अक्कादियाली
      akz:अलाबामा
      ale:अलेउट
      aln:घेग अल्बानियाली
      alt:दक्षिणी आल्टाइ
      am:अम्हारिक
      an:अरागोनी
      ang:पुरातन अङ्ग्रेजी
      ann:ओबोलो
      anp:अङ्गिका
      ar:अरबी
      ar-001:आधुनिक मानक अरबी
      arc:अरामाइक
      arn:मापुचे
      aro:अराओना
      arp:अरापाहो
      arq:अल्जेरियाली अरबी
      ars:नाज्दी अरविक
      arw:अरावाक
      ary:मोरोक्कोली अरबी
      arz:इजिप्ट अरबी
      as:आसामी
      asa:आसु
      ase:अमेरिकी साङ्केतिक भाषा
      ast:अस्टुरियाली
      atj:आतिकामिको
      av:अवारिक
      avk:कोटावा
      awa:अवधी
      ay:ऐमारा
      az:अजरबैजानी
      az-alt-short:अजेरी
      ba:बास्किर
      bal:बालुची
      ban:बाली
      bar:बाभारियाली
      bas:बासा
      bax:बामुन
      bbc:बाताक तोबा
      bbj:घोमाला
      be:बेलारुसी
      bej:बेजा
      bem:बेम्बा
      bew:बेटावी
      bez:बेना
      bfd:बाफुट
      bfq:बडागा
      bg:बुल्गेरियाली
      bgc:हरयाणवी
      bgn:पश्चिम बालोची
      bho:भोजपुरी
      bi:बिस्लाम
      bik:बिकोल
      bin:बिनी
      bjn:बन्जार
      bkm:कोम
      bla:सिक्सिका
      blo:अनी
      bm:बाम्बारा
      bn:बंगाली
      bo:तिब्बती
      bpy:विष्णुप्रिया
      bqi:बाख्तिआरी
      br:ब्रेटन
      bra:ब्रज
      brh:ब्राहुइ
      brx:बोडो
      bs:बोस्नियाली
      bss:अकुज
      bua:बुरिआत
      bug:बुगिनियाली
      bum:बुलु
      byn:ब्लिन
      byv:मेडुम्बा
      ca:क्याटालन
      cad:काड्डो
      car:क्यारिब
      cay:कायुगा
      cch:अट्साम
      ccp:चाक्मा
      ce:चेचेन
      ceb:सेबुआनो
      cgg:चिगा
      ch:चामोर्रो
      chb:चिब्चा
      chg:चागाटाई
      chk:चुकेसे
      chm:मारी
      chn:चिनुक जार्गन
      cho:चोक्टाव
      chp:चिपेव्यान
      chr:चेरोकी
      chy:चेयेन्ने
      ckb:मध्यवर्ती कुर्दिस
      ckb-alt-menu:मध्यवर्ती कुर्दिस
      ckb-alt-variant:मध्यवर्ती कुर्दिस
      clc:चिलकोटिन
      co:कोर्सिकन
      cop:कोप्टिक
      cps:कापिज्नोन
      cr:क्री
      crg:मिचिफ
      crh:क्रिमियाली तुर्क
      crj:दक्षिण पूर्वी क्री
      crk:प्लेन्स क्री
      crl:उत्तर पूर्वी क्री
      crm:मुज क्री
      crr:क्यारोलिना एल्गोनक्वियन
      crs:सेसेल्वा क्रिओल फ्रान्सेली
      cs:चेक
      csb:कासुवियन
      csw:स्वाम्पी क्री
      cu:चर्च स्लाभिक
      cv:चुभास
      cy:वेल्श
      da:डेनिस
      dak:डाकोटा
      dar:दार्ग्वा
      dav:ताइता
      de:जर्मन
      de-AT:अस्ट्रिएन जर्मन
      de-CH:स्वीस हाई जर्मन
      del:देलावर
      dgr:दोग्रिब
      din:दिन्का
      dje:जर्मा
      doi:डोगरी
      dsb:तल्लो सोर्बियन
      dtp:केन्द्रीय दुसुन
      dua:दुवाला
      dum:मध्य डच
      dv:दिबेही
      dyo:जोला-फोनिल
      dyu:द्युला
      dz:जोङ्खा
      dzg:दाजागा
      ebu:एम्बु
      ee:इवी
      efi:एफिक
      egl:एमिलियाली
      egy:पुरातन इजिप्टी
      eka:एकाजुक
      el:ग्रीक
      elx:एलामाइट
      en:अङ्ग्रेजी
      en-AU:अस्ट्रेलियाली अङ्ग्रेजी
      en-CA:क्यानाडेली अङ्ग्रेजी
      en-GB:बेलायती अङ्ग्रेजी
      en-GB-alt-short:संयुक्त अधिराज्य अङ्ग्रेजी
      en-US:अमेरिकी अङ्ग्रेजी
      en-US-alt-short:युएस अङ्ग्रेजी
      enm:मध्य अङ्ग्रेजी
      eo:एस्पेरान्तो
      es:स्पेनी
      es-419:ल्याटिन अमेरिकी स्पेनी
      es-ES:युरोपेली स्पेनी
      es-MX:मेक्सिकन स्पेनी
      esu:केन्द्रीय युपिक
      et:इस्टोनियन
      eu:बास्क
      ewo:इवोन्डो
      ext:एक्सट्रेमादुराली
      fa:फारसी
      fa-AF:दारी
      fan:फाङ
      fat:फान्टी
      ff:फुलाह
      fi:फिनिस
      fil:फिलिपिनी
      fj:फिजियन
      fo:फारोज
      fon:फोन
      fr:फ्रान्सेली
      fr-CA:क्यानेडाली फ्रान्सेली
      fr-CH:स्विस फ्रेन्च
      frc:काहुन फ्रान्सेली
      frm:मध्य फ्रान्सेली
      fro:पुरातन फ्रान्सेली
      frp:अर्पितान
      frr:उत्तरी फ्रिजी
      frs:पूर्वी फ्रिसियाली
      fur:फ्रिउलियाली
      fy:पश्चिमी फ्रिसियन
      ga:आइरिस
      gaa:गा
      gag:गगाउज
      gan:गान चिनियाँ
      gay:गायो
      gba:ग्बाया
      gd:स्कटिस गाएलिक
      gez:गिज
      gil:गिल्बर्टी
      gl:गलिसियाली
      glk:गिलाकी
      gmh:मध्य उच्च जर्मन
      gn:गुवारानी
      goh:पुरातन उच्च जर्मन
      gon:गोन्डी
      gor:गोरोन्टालो
      got:गोथिक
      grb:ग्रेबो
      grc:पुरातन ग्रिक
      gsw:स्वीस जर्मन
      gu:गुजराती
      gur:फ्राफ्रा
      guz:गुसी
      gv:मान्क्स
      gwi:गुइचिन
      ha:हाउसा
      hai:हाइदा
      hak:हक्का चिनियाँ
      haw:हवाइयन
      hax:दक्षिणी हैडा
      he:हिब्रु
      hi:हिन्दी
      hi-Latn-alt-variant:हिङ्लिस
      hif:फिजी हिन्दी
      hil:हिलिगायनोन
      hit:हिट्टिटे
      hmn:हमोङ
      ho:हिरी मोटु
      hr:क्रोयसियाली
      hsb:माथिल्लो सोर्बियन
      hsn:जियाङ चिनियाँ
      ht:हैटियाली क्रियोल
      hu:हङ्गेरियाली
      hup:हुपा
      hur:हाल्कोमेलेम
      hy:आर्मेनियाली
      hz:हेरेरो
      ia:इन्टर्लिङ्गुआ
      iba:इबान
      ibb:इबिबियो
      id:इन्डोनेसियाली
      ie:इन्टरलिङ्ग्वे
      ig:इग्बो
      ii:सिचुआन यि
      ik:इनुपिआक्
      ikt:पश्चिमी क्यानेडेली इनुक्टिटुट
      ilo:इयोको
      inh:इन्गस
      io:इडो
      is:आइसल्यान्डियाली
      it:इटालेली
      iu:इनुक्टिटुट
      izh:इन्ग्रियाली
      ja:जापानी
      jam:जमैकाली क्रेओले अङ्ग्रेजी
      jbo:लोज्बान
      jgo:न्गोम्बा
      jmc:माचामे
      jpr:जुडियो-फारसी
      jrb:जुडियो-अरबी
      jut:जुटिस
      jv:जाभानी
      ka:जर्जियाली
      kaa:कारा-काल्पाक
      kab:काबिल
      kac:काचिन
      kaj:ज्जु
      kam:काम्बा
      kaw:कावी
      kbd:काबार्दियाली
      kbl:कानेम्बु
      kcg:टुआप
      kde:माकोन्डे
      kea:काबुभेर्डियानु
      ken:केनयाङ
      kfo:कोरो
      kg:कोङ्गो
      kgp:काइनगाङ
      kha:खासी
      kho:खोटानी
      khq:कोयरा चिनी
      khw:खोवार
      ki:किकुयु
      kiu:किर्मान्जकी
      kj:कुआन्यामा
      kk:काजाख
      kkj:काको
      kl:कालालिसुट
      kln:कालेन्जिन
      km:खमेर
      kmb:किम्बुन्डु
      kn:कन्नाडा
      ko:कोरियाली
      koi:कोमी-पर्म्याक
      kok:कोन्कानी
      kos:कोस्राली
      kpe:क्पेल्ले
      kr:कानुरी
      krc:काराचाय-बाल्कर
      kri:क्रिओ
      krj:किनाराय-ए
      krl:करेलियन
      kru:कुरुख
      ks:कास्मिरी
      ksb:शाम्बाला
      ksf:बाफिया
      ksh:कोलोग्नियाली
      ku:कुर्दी
      kum:कुमिक
      kut:कुतेनाइ
      kv:कोमी
      kw:कोर्निस
      kwk:क्वाकवाला
      kxv:कुभी
      ky:किर्गिज
      la:ल्याटिन
      lad:लाडिनो
      lag:लाङ्गी
      lah:लाहन्डा
      lam:लाम्बा
      lb:लक्जेम्बर्गी
      lez:लाज्घियाली
      lfn:लिङ्गुवा फ्राङ्का नोभा
      lg:गान्डा
      li:लिम्बुर्गी
      lij:लिगुरियाली
      lil:लिलुएट
      liv:लिभोनियाली
      lkt:लाकोता
      lmo:लोम्बार्ड
      ln:लिङ्गाला
      lo:लाओ
      lol:मोङ्गो
      lou:लुसियाना क्रियोल
      loz:लोजी
      lrc:उत्तरी लुरी
      lsm:सामिया
      lt:लिथुआनियाली
      ltg:लाट्गाली
      lu:लुबा-काताङ्गा
      lua:लुबा-लुलुआ
      lui:लुइसेनो
      lun:लुन्डा
      luo:लुओ
      lus:मिजो
      luy:लुइया
      lv:लात्भियाली
      lzh:साहित्यिक चिनियाँ
      lzz:लाज
      mad:मादुरेसे
      maf:माफा
      mag:मगधी
      mai:मैथिली
      mak:माकासार
      man:मान्दिङो
      mas:मसाई
      mde:माबा
      mdf:मोक्ष
      mdr:मन्दर
      men:मेन्डे
      mer:मेरू
      mfe:मोरिसेन
      mg:मलागासी
      mga:मध्य आयरिस
      mgh:माखुवा-मिट्टो
      mgo:मेटा
      mh:मार्साली
      mi:माओरी
      mic:मिकमाक
      min:मिनाङकाबाउ
      mk:म्यासेडोनियन
      ml:मलयालम
      mn:मङ्गोलियाली
      mnc:मान्चु
      mni:मनिपुरी
      moe:इन्नु-ऐमन
      moh:मोहक
      mos:मोस्सी
      mr:मराठी
      ms:मलाय
      mt:माल्टिज
      mua:मुन्डाङ
      mul:बहुभाषा
      mus:क्रिक
      mwl:मिरान्डी
      mwr:माडवारी
      mwv:मेन्टावाई
      my:बर्मेली
      mye:म्येने
      myv:इर्ज्या
      mzn:मजानडेरानी
      na:नाउरू
      nan:मिन नान चिनियाँ
      nap:नेपोलिटान
      naq:नामा
      nb:नर्वेली बोकमाल
      nd:उत्तरी न्डेबेले
      nds:तल्लो जर्मन
      nds-NL:तल्लो साक्सन
      ne:नेपाली
      new:नेवारी
      ng:न्दोन्गा
      nia:नियास
      niu:निउएन
      njo:अओ नागा
      nl:डच
      nl-BE:फ्लेमिस
      nmg:क्वासियो
      nn:नर्वेली नाइनोर्स्क
      nnh:न्गिएम्बुन
      no:नर्वेली
      nog:नोगाइ
      non:पुरानो नोर्से
      nov:नोभियल
      nqo:नको
      nr:दक्षिण न्देबेले
      nso:उत्तरी सोथो
      nus:नुएर
      nv:नाभाजो
      nwc:परम्परागत नेवारी
      ny:न्यान्जा
      nym:न्यामवेजी
      nyn:न्यान्कोल
      nyo:न्योरो
      nzi:नजिमा
      oc:अक्सिटन
      oj:ओजिब्वा
      ojb:उत्तरपश्चिम ओजिब्बा
      ojc:सेन्ट्रल अजिब्बा
      ojs:ओजी क्री
      ojw:पश्चिमी ओजिबा
      oka:ओकानागान
      om:ओरोमो
      or:उडिया
      os:ओस्सेटिक
      osa:ओसागे
      ota:अटोमन तुर्की
      pa:पंजाबी
      pag:पाङ्गासिनान
      pal:पाहलावी
      pam:पामपाङ्गा
      pap:पापियामेन्तो
      pau:पालाउवाली
      pcd:पिकार्ड
      pcm:नाइजेरियाली पिड्जिन
      pdc:पेन्सिलभानियाली जर्मन
      peo:पुरातन फारसी
      pfl:पालाटिन जर्मन
      phn:फोनिसियाली
      pi:पाली
      pis:पिजिन
      pl:पोलिस
      pms:पिएडमोन्तेसे
      pnt:पोन्टिक
      pqm:मालिसीट पासामाक्वेडी
      prg:प्रसियाली
      pro:पुरातन प्रोभेन्काल
      ps:पास्तो
      pt:पोर्तुगी
      pt-BR:ब्राजिली पोर्तुगी
      pt-PT:युरोपेली पोर्तुगी
      qu:क्वेचुवा
      quc:किचे
      qug:चिम्बोराजो उच्चस्थान किचुआ
      raj:राजस्थानी
      rap:रापानुई
      rar:रारोटोङ्गान
      rhg:रोहिङ्ग्या
      rm:रोमानिस
      rn:रुन्डी
      ro:रोमानियाली
      ro-MD:मोल्डाभियाली
      rof:रोम्बो
      ru:रसियाली
      rup:अरोमानीयाली
      rw:किन्यारवान्डा
      rwk:र्‌वा
      sa:संस्कृत
      sad:सान्डेअ
      sah:साखा
      saq:साम्बुरू
      sat:सान्ताली
      sba:न्गामबाय
      sbp:साङ्गु
      sc:सार्डिनियाली
      scn:सिसिलियाली
      sco:स्कट्स
      sd:सिन्धी
      sdh:दक्षिणी कुर्दिश
      se:उत्तरी सामी
      seh:सेना
      ses:कोयराबोरो सेन्नी
      sg:साङ्गो
      sga:पुरातन आयरीस
      shi:टाचेल्हिट
      shn:शान
      shu:चाड अरबी
      si:सिन्हाली
      sk:स्लोभाकियाली
      sl:स्लोभेनियाली
      slh:दक्षिनी लुस्होस्टेड
      sli:तल्लो सिलेसियाली
      sm:सामोआ
      sma:दक्षिणी सामी
      smj:लुले सामी
      smn:इनारी सामी
      sms:स्कोइट सामी
      sn:शोना
      snk:सोनिन्के
      so:सोमाली
      sq:अल्बानियाली
      sr:सर्बियाली
      srn:स्रानान टोङ्गो
      ss:स्वाती
      ssy:साहो
      st:दक्षिणी सोथो
      str:स्ट्रेट स्यालिस
      su:सुडानी
      suk:सुकुमा
      sus:सुसू
      sux:सुमेरियाली
      sv:स्विडिस
      sw:स्वाहिली
      sw-CD:कङ्गो स्वाहिली
      swb:कोमोरी
      syc:परम्परागत सिरियाक
      syr:सिरियाक
      szl:सिलेसियाली
      ta:तामिल
      tce:दक्षिनी टुट्चोन
      te:तेलुगु
      tem:टिम्ने
      teo:टेसो
      tet:टेटुम
      tg:ताजिक
      tgx:टागिस
      th:थाई
      tht:टाहल्टन
      ti:टिग्रिन्या
      tig:टिग्रे
      tk:टर्कमेन
      tlh:क्लिङ्गन
      tli:ट्लिङ्गिट
      tn:ट्स्वाना
      to:टोङ्गन
      tog:न्यास टोङ्गा
      tok:टोकी पोना
      tpi:टोक पिसिन
      tr:टर्किश
      trv:टारोको
      ts:ट्सोङ्गा
      tt:तातार
      ttm:उत्तरी टुचोन
      ttt:मुस्लिम टाट
      tum:टुम्बुका
      tvl:टुभालु
      twq:तासावाक
      ty:टाहिटियन
      tyv:टुभिनियाली
      tzm:केन्द्रीय एट्लास टामाजिघट
      udm:उड्मुर्ट
      ug:उइघुर
      uk:युक्रेनी
      umb:उम्बुन्डी
      und:अज्ञात भाषा
      ur:उर्दु
      uz:उज्बेकी
      vai:भाइ
      ve:भेन्डा
      vec:भेनेसियाली
      vi:भियतनामी
      vmf:मुख्य-फ्राङ्कोनियाली
      vmw:मखुवा
      vo:भोलापिक
      vun:भुन्जो
      wa:वाल्लुन
      wae:वाल्सर
      wal:वोलेट्टा
      war:वारे
      wbp:वार्ल्पिरी
      wo:वुलुफ
      wuu:ऊ चिनियाँ
      xal:काल्मिक
      xh:खोसा
      xmf:मिनग्रेलियाली
      xnr:काङ्ग्री
      xog:सोगा
      yav:याङ्बेन
      ybb:येम्बा
      yi:यिद्दिस
      yo:योरूवा
      yrl:न्हिनगातु
      yue:क्यान्टोनिज
      yue-alt-menu:चिनियाँ, क्यान्टोनिज
      za:झुुआङ्ग
      zbl:ब्लिससिम्बोल्स
      zgh:मानक मोरोक्कोन तामाजिघट
      zh:चिनियाँ
      zh-alt-menu:चिनियाँ, म्यान्डरिन
      zh-Hans:सरलिकृत चिनियाँ
      zh-Hans-alt-long:सरलिकृत म्यान्डरिन चिनियाँ
      zh-Hant:परम्परागत चिनियाँ
      zh-Hant-alt-long:परम्परागत म्यान्डरिन चिनियाँ
      zu:जुलु
      zun:जुनी
      zxx:भाषिक सामग्री छैन
      zza:जाजा
      """.trimIndent() }

  val ne_IN: String? = null

  val nl: String by lazy { """
      aa:Afar
      ab:Abchazisch
      ace:Atjehs
      ach:Akoli
      ada:Adangme
      ady:Adygees
      ae:Avestisch
      aeb:Tunesisch Arabisch
      af:Afrikaans
      afh:Afrihili
      agq:Aghem
      ain:Aino
      ajp:Zuid-Levantijns-Arabisch
      ak:Akan
      akk:Akkadisch
      akz:Alabama
      ale:Aleoetisch
      aln:Gegisch
      alt:Zuid-Altaïsch
      am:Amhaars
      an:Aragonees
      ang:Oudengels
      ann:Obolo
      anp:Angika
      apc:Levantijns-Arabisch
      ar:Arabisch
      ar-001:modern standaard Arabisch
      arc:Aramees
      arn:Mapudungun
      aro:Araona
      arp:Arapaho
      arq:Algerijns Arabisch
      ars:Nadjdi-Arabisch
      ars-alt-menu:Arabisch, Nadjdi
      arw:Arawak
      ary:Marokkaans Arabisch
      arz:Egyptisch Arabisch
      as:Assamees
      asa:Asu
      ase:Amerikaanse Gebarentaal
      ast:Asturisch
      atj:Atikamekw
      av:Avarisch
      avk:Kotava
      awa:Awadhi
      ay:Aymara
      az:Azerbeidzjaans
      az-alt-short:Azeri
      ba:Basjkiers
      bal:Beloetsji
      ban:Balinees
      bar:Beiers
      bas:Basa
      bax:Bamoun
      bbc:Batak Toba
      bbj:Ghomala’
      be:Belarussisch
      bej:Beja
      bem:Bemba
      bew:Bataviaans
      bez:Bena
      bfd:Bafut
      bfq:Badaga
      bg:Bulgaars
      bgc:Haryanvi
      bgn:Westers Beloetsji
      bho:Bhojpuri
      bi:Bislama
      bik:Bikol
      bin:Bini
      bjn:Banjar
      bkm:Kom
      bla:Siksika
      blo:Anii
      bm:Bambara
      bn:Bengaals
      bo:Tibetaans
      bpy:Bishnupriya
      bqi:Bakhtiari
      br:Bretons
      bra:Braj
      brh:Brahui
      brx:Bodo
      bs:Bosnisch
      bss:Akoose
      bua:Boerjatisch
      bug:Buginees
      bum:Bulu
      byn:Blin
      byv:Medumba
      ca:Catalaans
      cad:Caddo
      car:Caribisch
      cay:Cayuga
      cch:Atsam
      ccp:Chakma
      ce:Tsjetsjeens
      ceb:Cebuano
      cgg:Chiga
      ch:Chamorro
      chb:Chibcha
      chg:Chagatai
      chk:Chuukees
      chm:Mari
      chn:Chinook Jargon
      cho:Choctaw
      chp:Chipewyan
      chr:Cherokee
      chy:Cheyenne
      ckb:Soranî
      ckb-alt-menu:Koerdisch, Soranî
      ckb-alt-variant:Koerdisch, Soranî
      clc:Chilcotin
      co:Corsicaans
      cop:Koptisch
      cps:Capiznon
      cr:Cree
      crg:Michif
      crh:Krim-Tataars
      crj:Zuidoost-Cree
      crk:Plains Cree
      crl:Noordoost-Cree
      crm:Moose Cree
      crr:Carolina Algonkisch
      crs:Seychellencreools
      cs:Tsjechisch
      csb:Kasjoebisch
      csw:Swampy Cree
      cu:Kerkslavisch
      cv:Tsjoevasjisch
      cy:Welsh
      da:Deens
      dak:Dakota
      dar:Dargwa
      dav:Taita
      de:Duits
      del:Delaware
      den:Slavey
      dgr:Dogrib
      din:Dinka
      dje:Zarma
      doi:Dogri
      dsb:Nedersorbisch
      dtp:Dusun
      dua:Duala
      dum:Middelnederlands
      dv:Divehi
      dyo:Jola-Fonyi
      dyu:Dyula
      dz:Dzongkha
      dzg:Dazaga
      ebu:Embu
      ee:Ewe
      efi:Efik
      egl:Emiliano
      egy:Oudegyptisch
      eka:Ekajuk
      el:Grieks
      elx:Elamitisch
      en:Engels
      enm:Middelengels
      eo:Esperanto
      es:Spaans
      esu:Yupik
      et:Estisch
      eu:Baskisch
      ewo:Ewondo
      ext:Extremeens
      fa:Perzisch
      fa-AF:Dari
      fan:Fang
      fat:Fanti
      ff:Fulah
      fi:Fins
      fil:Filipijns
      fit:Tornedal-Fins
      fj:Fijisch
      fo:Faeröers
      fon:Fon
      fr:Frans
      frc:Cajun-Frans
      frm:Middelfrans
      fro:Oudfrans
      frp:Arpitaans
      frr:Noord-Fries
      frs:Oost-Fries
      fur:Friulisch
      fy:Fries
      ga:Iers
      gaa:Ga
      gag:Gagaoezisch
      gan:Ganyu
      gay:Gayo
      gba:Gbaya
      gbz:Zoroastrisch Dari
      gd:Schots-Gaelisch
      gez:Ge’ez
      gil:Gilbertees
      gl:Galicisch
      glk:Gilaki
      gmh:Middelhoogduits
      gn:Guaraní
      goh:Oudhoogduits
      gon:Gondi
      gor:Gorontalo
      got:Gothisch
      grb:Grebo
      grc:Oudgrieks
      gsw:Zwitserduits
      gu:Gujarati
      guc:Wayuu
      gur:Gurune
      guz:Gusii
      gv:Manx
      gwi:Gwichʼin
      ha:Hausa
      hai:Haida
      hak:Hakka
      haw:Hawaïaans
      hax:Zuid-Haida
      he:Hebreeuws
      hi:Hindi
      hi-Latn-alt-variant:Hinglish
      hif:Fijisch Hindi
      hil:Hiligaynon
      hit:Hettitisch
      hmn:Hmong
      ho:Hiri Motu
      hr:Kroatisch
      hsb:Oppersorbisch
      hsn:Xiangyu
      ht:Haïtiaans Creools
      hu:Hongaars
      hup:Hupa
      hur:Halkomelem
      hy:Armeens
      hz:Herero
      ia:Interlingua
      iba:Iban
      ibb:Ibibio
      id:Indonesisch
      ie:Interlingue
      ig:Igbo
      ii:Yi
      ik:Inupiaq
      ikt:Westelijk Canadees Inuktitut
      ilo:Iloko
      inh:Ingoesjetisch
      io:Ido
      is:IJslands
      it:Italiaans
      iu:Inuktitut
      izh:Ingrisch
      ja:Japans
      jam:Jamaicaans Creools
      jbo:Lojban
      jgo:Ngomba
      jmc:Machame
      jpr:Judeo-Perzisch
      jrb:Judeo-Arabisch
      jut:Jutlands
      jv:Javaans
      ka:Georgisch
      kaa:Karakalpaks
      kab:Kabylisch
      kac:Kachin
      kaj:Jju
      kam:Kamba
      kaw:Kawi
      kbd:Kabardisch
      kbl:Kanembu
      kcg:Tyap
      kde:Makonde
      kea:Kaapverdisch Creools
      ken:Kenyang
      kfo:Koro
      kg:Kongo
      kgp:Kaingang
      kha:Khasi
      kho:Khotanees
      khq:Koyra Chiini
      khw:Khowar
      ki:Gikuyu
      kiu:Kirmanckî
      kj:Kuanyama
      kk:Kazachs
      kkj:Kako
      kl:Groenlands
      kln:Kalenjin
      km:Khmer
      kmb:Kimbundu
      kn:Kannada
      ko:Koreaans
      koi:Komi-Permjaaks
      kok:Konkani
      kos:Kosraeaans
      kpe:Kpelle
      kr:Kanuri
      krc:Karatsjaj-Balkarisch
      kri:Krio
      krj:Kinaray-a
      krl:Karelisch
      kru:Kurukh
      ks:Kasjmiri
      ksb:Shambala
      ksf:Bafia
      ksh:Kölsch
      ku:Koerdisch
      kum:Koemuks
      kut:Kutenai
      kv:Komi
      kw:Cornish
      kwk:Kwakʼwala
      kxv:Kuvi
      ky:Kirgizisch
      la:Latijn
      lad:Ladino
      lag:Langi
      lah:Lahnda
      lam:Lamba
      lb:Luxemburgs
      lez:Lezgisch
      lfn:Lingua Franca Nova
      lg:Luganda
      li:Limburgs
      lij:Ligurisch
      lil:Lillooet
      liv:Lijfs
      lkt:Lakota
      lmo:Lombardisch
      ln:Lingala
      lo:Laotiaans
      lol:Mongo
      lou:Louisiana-Creools
      loz:Lozi
      lrc:Noordelijk Luri
      lsm:Saamia
      lt:Litouws
      ltg:Letgaals
      lu:Luba-Katanga
      lua:Luba-Lulua
      lui:Luiseno
      lun:Lunda
      luo:Luo
      lus:Mizo
      luy:Luyia
      lv:Lets
      lzh:Klassiek Chinees
      lzz:Lazisch
      mad:Madoerees
      maf:Mafa
      mag:Magahi
      mai:Maithili
      mak:Makassaars
      man:Mandingo
      mas:Maa
      mde:Maba
      mdf:Moksja
      mdr:Mandar
      men:Mende
      mer:Meru
      mfe:Morisyen
      mg:Malagassisch
      mga:Middeliers
      mgh:Makhuwa-Meetto
      mgo:Meta’
      mh:Marshallees
      mi:Maori
      mic:Mi’kmaq
      min:Minangkabau
      mk:Macedonisch
      ml:Malayalam
      mn:Mongools
      mnc:Mantsjoe
      mni:Meitei
      moe:Innu-aimun
      moh:Mohawk
      mos:Mossi
      mr:Marathi
      mrj:West-Mari
      ms:Maleis
      mt:Maltees
      mua:Mundang
      mul:meerdere talen
      mus:Creek
      mwl:Mirandees
      mwr:Marwari
      mwv:Mentawai
      my:Birmaans
      mye:Myene
      myv:Erzja
      mzn:Mazanderani
      na:Nauruaans
      nan:Minnanyu
      nap:Napolitaans
      naq:Nama
      nb:Noors - Bokmål
      nd:Noord-Ndebele
      nds:Nedersaksisch
      nds-NL:Nederduits
      ne:Nepalees
      new:Newari
      ng:Ndonga
      nia:Nias
      niu:Niueaans
      njo:Ao Naga
      nl:Nederlands
      nl-BE:Vlaams
      nmg:Ngumba
      nn:Noors - Nynorsk
      nnh:Ngiemboon
      no:Noors
      nog:Nogai
      non:Oudnoors
      nov:Novial
      nqo:N’Ko
      nr:Zuid-Ndbele
      nso:Noord-Sotho
      nus:Nuer
      nv:Navajo
      nwc:Klassiek Nepalbhasa
      ny:Nyanja
      nym:Nyamwezi
      nyn:Nyankole
      nyo:Nyoro
      nzi:Nzima
      oc:Occitaans
      oj:Ojibwa
      ojb:Noordwest-Ojibwe
      ojc:Centraal Ojibwa
      ojs:Oji-Cree
      ojw:West-Ojibwe
      oka:Okanagan
      om:Afaan Oromo
      or:Odia
      os:Ossetisch
      osa:Osage
      ota:Ottomaans-Turks
      pa:Punjabi
      pag:Pangasinan
      pal:Pahlavi
      pam:Pampanga
      pap:Papiaments
      pau:Palaus
      pcd:Picardisch
      pcm:Nigeriaans Pidgin
      pdc:Pennsylvania-Duits
      pdt:Plautdietsch
      peo:Oudperzisch
      pfl:Paltsisch
      phn:Foenicisch
      pi:Pali
      pis:Pijin
      pl:Pools
      pms:Piëmontees
      pnt:Pontisch
      pon:Pohnpeiaans
      pqm:Maliseet-Passamaquoddy
      prg:Oudpruisisch
      pro:Oudprovençaals
      ps:Pasjtoe
      ps-alt-variant:Pashto
      pt:Portugees
      qu:Quechua
      quc:K’iche’
      qug:Kichwa
      raj:Rajasthani
      rap:Rapanui
      rar:Rarotongan
      rgn:Romagnol
      rhg:Rohingya
      rif:Riffijns
      rm:Reto-Romaans
      rn:Kirundi
      ro:Roemeens
      rof:Rombo
      rom:Romani
      rtm:Rotumaans
      ru:Russisch
      rue:Roetheens
      rug:Roviana
      rup:Aroemeens
      rw:Kinyarwanda
      rwk:Rwa
      sa:Sanskriet
      sad:Sandawe
      sah:Jakoets
      sam:Samaritaans-Aramees
      saq:Samburu
      sas:Sasak
      sat:Santali
      saz:Saurashtra
      sba:Ngambay
      sbp:Sangu
      sc:Sardijns
      scn:Siciliaans
      sco:Schots
      sd:Sindhi
      sdc:Sassarees
      sdh:Pahlavani
      se:Noord-Samisch
      see:Seneca
      seh:Sena
      sei:Seri
      sel:Selkoeps
      ses:Koyraboro Senni
      sg:Sango
      sga:Oudiers
      sgs:Samogitisch
      sh:Servo-Kroatisch
      shi:Tashelhiyt
      shn:Shan
      shu:Tsjadisch Arabisch
      si:Singalees
      sid:Sidamo
      sk:Slowaaks
      sl:Sloveens
      slh:Zuid-Lushootseed
      sli:Silezisch Duits
      sly:Selayar
      sm:Samoaans
      sma:Zuid-Samisch
      smj:Lule-Samisch
      smn:Inari-Samisch
      sms:Skolt-Samisch
      sn:Shona
      snk:Soninke
      so:Somalisch
      sog:Sogdisch
      sq:Albanees
      sr:Servisch
      srn:Sranantongo
      srr:Serer
      ss:Swazi
      ssy:Saho
      st:Zuid-Sotho
      stq:Saterfries
      str:Straits Salish
      su:Soendanees
      suk:Sukuma
      sus:Soesoe
      sux:Soemerisch
      sv:Zweeds
      sw:Swahili
      swb:Shimaore
      syc:Klassiek Syrisch
      syr:Syrisch
      szl:Silezisch
      ta:Tamil
      tce:Zuid-Tutchone
      tcy:Tulu
      te:Telugu
      tem:Timne
      teo:Teso
      ter:Tereno
      tet:Tetun
      tg:Tadzjieks
      tgx:Tagish
      th:Thai
      tht:Tahltan
      ti:Tigrinya
      tig:Tigre
      tiv:Tiv
      tk:Turkmeens
      tkl:Tokelaus
      tkr:Tsakhur
      tl:Tagalog
      tlh:Klingon
      tli:Tlingit
      tly:Talysh
      tmh:Tamashek
      tn:Tswana
      to:Tongaans
      tog:Nyasa Tonga
      tok:Toki Pona
      tpi:Tok Pisin
      tr:Turks
      tru:Turoyo
      trv:Taroko
      ts:Tsonga
      tsd:Tsakonisch
      tsi:Tsimshian
      tt:Tataars
      ttm:Noord-Tutchone
      ttt:Moslim Tat
      tum:Toemboeka
      tvl:Tuvaluaans
      tw:Twi
      twq:Tasawaq
      ty:Tahitiaans
      tyv:Toevaans
      tzm:Tamazight (Centraal-Marokko)
      udm:Oedmoerts
      ug:Oeigoers
      uga:Oegaritisch
      uk:Oekraïens
      umb:Umbundu
      und:onbekende taal
      ur:Urdu
      uz:Oezbeeks
      vai:Vai
      ve:Venda
      vec:Venetiaans
      vep:Wepsisch
      vi:Vi