package net.codinux.i18n

import kotlin.String

/**
 * Defines all Variants known to CLDR.
 *
 * @param code The variant code, five to eight lowercase letters, or four characters starting with a digit.
 *
 * Or in [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) notation:
 *  variant       = 5*8alphanum         ; registered variants
 *    / (DIGIT 3alphanum)
 * @param englishName English name of the variant.
 */
enum class Variant(
  val code: String,
  val englishName: String?,
) {
  _1606nict("1606nict", null),
  _1694acad("1694acad", null),
  _1901("1901", "Traditional German orthography"),
  _1959acad("1959acad", null),
  _1994("1994", "Standardized Resian orthography"),
  _1996("1996", "German orthography of 1996"),
  Abl1943("abl1943", null),
  Akuapem("akuapem", null),
  Alalc97("alalc97", null),
  Aluku("aluku", null),
  Anpezo("anpezo", null),
  Ao1990("ao1990", null),
  Aranes("aranes", null),
  Arevela("arevela", null),
  Arevmda("arevmda", null),
  Arkaika("arkaika", null),
  Asante("asante", null),
  Auvern("auvern", null),
  Baku1926("baku1926", null),
  Balanka("balanka", null),
  Barla("barla", null),
  Basiceng("basiceng", null),
  Bauddha("bauddha", null),
  Bciav("bciav", null),
  Bcizbl("bcizbl", null),
  Biscayan("biscayan", null),
  Biske("biske", null),
  Blasl("blasl", null),
  Bohoric("bohoric", null),
  Boont("boont", null),
  Bornholm("bornholm", null),
  Cisaup("cisaup", null),
  Colb1945("colb1945", null),
  Cornu("cornu", null),
  Creiss("creiss", null),
  Dajnko("dajnko", null),
  Ekavsk("ekavsk", null),
  Emodeng("emodeng", null),
  Fascia("fascia", null),
  Fodom("fodom", null),
  Fonipa("fonipa", null),
  Fonkirsh("fonkirsh", null),
  Fonnapa("fonnapa", null),
  Fonupa("fonupa", null),
  FonupaAltSecondary("fonupa-alt-secondary", null),
  Fonxsamp("fonxsamp", null),
  Gallo("gallo", null),
  Gascon("gascon", null),
  Gherd("gherd", null),
  Grclass("grclass", null),
  Grital("grital", null),
  Grmistr("grmistr", null),
  Hepburn("hepburn", null),
  Hognorsk("hognorsk", null),
  Hsistemo("hsistemo", null),
  Ijekavsk("ijekavsk", null),
  Itihasa("itihasa", null),
  Ivanchov("ivanchov", null),
  Jauer("jauer", null),
  Jyutping("jyutping", null),
  Kkcor("kkcor", null),
  Kociewie("kociewie", null),
  Kscor("kscor", null),
  Laukika("laukika", null),
  Lemosin("lemosin", null),
  Lengadoc("lengadoc", null),
  Lipaw("lipaw", null),
  Ltg1929("ltg1929", null),
  Ltg2007("ltg2007", null),
  Luna1918("luna1918", null),
  Metelko("metelko", null),
  Monoton("monoton", null),
  Ndyuka("ndyuka", null),
  Nedis("nedis", null),
  Newfound("newfound", null),
  Nicard("nicard", null),
  Njiva("njiva", null),
  Nulik("nulik", null),
  Osojs("osojs", null),
  Oxendict("oxendict", null),
  Pahawh2("pahawh2", null),
  Pahawh3("pahawh3", null),
  Pahawh4("pahawh4", null),
  Pamaka("pamaka", null),
  Peano("peano", null),
  Pehoeji("pehoeji", null),
  Petr1708("petr1708", null),
  Pinyin("pinyin", null),
  Polyton("polyton", null),
  Posix("posix", null),
  Provenc("provenc", null),
  Puter("puter", null),
  Revised("revised", null),
  Rigik("rigik", null),
  Rozaj("rozaj", null),
  Rumgr("rumgr", null),
  Saaho("saaho", null),
  Scotland("scotland", null),
  Scouse("scouse", null),
  Simple("simple", null),
  Solba("solba", null),
  Sotav("sotav", null),
  Spanglis("spanglis", null),
  Surmiran("surmiran", null),
  Sursilv("sursilv", null),
  Sutsilv("sutsilv", null),
  Synnejyl("synnejyl", null),
  Tailo("tailo", null),
  Tarask("tarask", null),
  Tongyong("tongyong", null),
  Tunumiit("tunumiit", null),
  Uccor("uccor", null),
  Ucrcor("ucrcor", null),
  Ulster("ulster", null),
  Unifon("unifon", null),
  Vaidika("vaidika", null),
  Valbadia("valbadia", null),
  Valencia("valencia", null),
  Vallader("vallader", null),
  Vecdruka("vecdruka", null),
  Vivaraup("vivaraup", null),
  Wadegile("wadegile", null),
  Xsistemo("xsistemo", null),
}
