package net.codinux.i18n

import kotlin.String

/**
 * @param code The UN/ECE code of this unit from UN/ECE Recommendation Nº20 and Nº21 [https://unece.org/trade/uncefact/cl-recommendations](https://unece.org/trade/uncefact/cl-recommendations).
 * @param englishName English name of this unit.
 * @param symbol The symbol used to represent the unit of measure as in ISO 31 / 80000.
 */
enum class UnitAll(
  val code: String,
  val englishName: String,
  val symbol: String?,
  val groupOrCategory: String?,
) {
  _10("10", "group", null, "3.9"),
  _11("11", "outfit", null, "3.9"),
  _13("13", "ration", null, "3.9"),
  _14("14", "shot", null, "3.9"),
  _15("15", "stick, military", null, "3.9"),
  _1A("1A", "Drum, steel", null, null),
  _1B("1B", "Drum, aluminium", null, null),
  _1D("1D", "Drum, plywood", null, null),
  _1F("1F", "Container, flexible", null, null),
  _1G("1G", "Drum, fibre", null, null),
  _1I("1I", "fixed rate", null, "3.9"),
  _1W("1W", "Drum, wooden", null, null),
  _20("20", "twenty foot container", null, "3.4"),
  _21("21", "forty foot container", null, "3.4"),
  _22("22", "decilitre per gram", "dl/g", "03"),
  _23("23", "gram per cubic centimetre", "g/cm³", "03"),
  _24("24", "theoretical pound", null, "3.1"),
  _25("25", "gram per square centimetre", "g/cm²", "03"),
  _27("27", "theoretical ton", null, "3.1"),
  _28("28", "kilogram per square metre", "kg/m²", "03"),
  _2A("2A", "radian per second", "rad/s", "01"),
  _2B("2B", "radian per second squared", "rad/s²", "01"),
  _2C("2C", "roentgen", "R", "10"),
  _2G("2G", "volt AC", "V", "3.1"),
  _2H("2H", "volt DC", "V", "3.1"),
  _2I("2I", "British thermal unit (international table) per hour", "BtuIT/h", "04"),
  _2J("2J", "cubic centimetre per second", "cm³/s", "03"),
  _2K("2K", "cubic foot per hour", "ft³/h", "03"),
  _2L("2L", "cubic foot per minute", "ft³/min", "03"),
  _2M("2M", "centimetre per second", "cm/s", "01"),
  _2N("2N", "decibel", "dB", "02"),
  _2P("2P", "kilobyte", "kbyte", "3.6"),
  _2Q("2Q", "kilobecquerel", "kBq", "09"),
  _2R("2R", "kilocurie", "kCi", "09"),
  _2U("2U", "megagram", "Mg", "03"),
  _2X("2X", "metre per minute", "m/min", "01"),
  _2Y("2Y", "milliroentgen", "mR", "10"),
  _2Z("2Z", "millivolt", "mV", "05"),
  _33("33", "kilopascal square metre per gram", "kPa·m²/g", "13"),
  _34("34", "kilopascal per millimetre", "kPa/mm", "13"),
  _35("35", "millilitre per square centimetre second", "ml/(cm²·s)", "13"),
  _37("37", "ounce per square foot", "oz/ft²", "03"),
  _38("38", "ounce per square foot per 0,01inch", "oz/(ft²/cin)", "3"),
  _3A("3A", "Jerrican, steel", null, null),
  _3B("3B", "megajoule", "MJ", "03"),
  _3C("3C", "manmonth", null, "3.9"),
  _3H("3H", "Jerrican, plastic", null, null),
  _40("40", "millilitre per second", "ml/s", "03"),
  _41("41", "millilitre per minute", "ml/min", "03"),
  _43("43", "Bag, super bulk", null, null),
  _44("44", "Bag, polybag", null, null),
  _4A("4A", "Box, steel", null, null),
  _4B("4B", "Box, aluminium", null, null),
  _4C("4C", "centistokes", "cSt", "03"),
  _4D("4D", "Box, plywood", null, null),
  _4F("4F", "Box, reconstituted wood", null, null),
  _4G("4G", "microlitre", "µl", "01"),
  _4H("4H", "micrometre (micron)", "µm", "01"),
  _4K("4K", "milliampere", "mA", "05"),
  _4L("4L", "megabyte", "Mbyte", "3.6"),
  _4M("4M", "milligram per hour", "mg/h", "03"),
  _4N("4N", "megabecquerel", "MBq", "09"),
  _4O("4O", "microfarad", "µF", "05"),
  _4P("4P", "newton per metre", "N/m", "03"),
  _4Q("4Q", "ounce inch", "oz·in", "03"),
  _4R("4R", "ounce foot", "oz·ft", "03"),
  _4T("4T", "picofarad", "pF", "05"),
  _4U("4U", "pound per hour", "lb/h", "03"),
  _4W("4W", "ton (US) per hour", "ton (US) /h", "03"),
  _4X("4X", "kilolitre per hour", "kl/h", "03"),
  _56("56", "sitas", null, "3.9"),
  _57("57", "mesh", null, "3.9"),
  _58("58", "net kilogram", null, "3.1"),
  _59("59", "part per million", "ppm", "3.7"),
  _5A("5A", "barrel (US) per minute", "barrel (US)/min", "03"),
  _5B("5B", "batch", null, "3.9"),
  _5E("5E", "MMSCF/day", null, "3.9"),
  _5H("5H", "Bag, woven plastic", null, null),
  _5J("5J", "hydraulic horse power", null, "3.5"),
  _5L("5L", "Bag, textile", null, null),
  _5M("5M", "Bag, paper", null, null),
  _60("60", "percent weight", null, "3.7"),
  _61("61", "part per billion (US)", "ppb", "3.7"),
  _6H("6H", "Composite packaging, plastic receptacle", null, null),
  _6P("6P", "Composite packaging, glass receptacle", null, null),
  _74("74", "millipascal", "mPa", "03"),
  _77("77", "milli-inch", "mil", "01"),
  _7A("7A", "Case, car", null, null),
  _7B("7B", "Case, wooden", null, null),
  _80("80", "pound per square inch absolute", "lb/in²", "03"),
  _81("81", "henry", "H", "05"),
  _85("85", "foot pound-force", "ft·lbf", "03"),
  _87("87", "pound per cubic foot", "lb/ft³", "03"),
  _89("89", "poise", "P", "03"),
  _8A("8A", "Pallet, wooden", null, null),
  _8B("8B", "Crate, wooden", null, null),
  _8C("8C", "Bundle, wooden", null, null),
  _91("91", "stokes", "St", "03"),
  A10("A10", "ampere square metre per joule second", "A·m²/(J·s)", "09"),
  A11("A11", "angstrom", "Å", "01"),
  A12("A12", "astronomical unit", "ua", "01"),
  A13("A13", "attojoule", "aJ", "03"),
  A14("A14", "barn", "b", "10"),
  A15("A15", "barn per electronvolt", "b/eV", "10"),
  A16("A16", "barn per steradian electronvolt", "b/(sr·eV)", "10"),
  A17("A17", "barn per steradian", "b/sr", "10"),
  A18("A18", "becquerel per kilogram", "Bq/kg", "09"),
  A19("A19", "becquerel per cubic metre", "Bq/m³", "09"),
  A2("A2", "ampere per centimetre", "A/cm", "05"),
  A20("A20", "British thermal unit (international table) per second square foot degree Rankine", "BtuIT/(s·ft²·°R)", "04"),
  A21("A21", "British thermal unit (international table) per pound degree Rankine", "Btu/IT(lb·°R)", "04"),
  A22("A22", "British thermal unit (international table) per second foot degree Rankine", "BtuIT/(s·ft·°R)", "04"),
  A23("A23", "British thermal unit (international table) per hour square foot degree Rankine", "BtuIT/(h·ft²·°R)", "04"),
  A24("A24", "candela per square metre", "cd/m²", "06"),
  A26("A26", "coulomb metre", "C·m", "05"),
  A27("A27", "coulomb metre squared per volt", "C·m²/V", "08"),
  A28("A28", "coulomb per cubic centimetre", "C/cm³", "05"),
  A29("A29", "coulomb per cubic metre", "C/m³", "05"),
  A3("A3", "ampere per millimetre", "A/mm", "05"),
  A30("A30", "coulomb per cubic millimetre", "C/mm³", "05"),
  A31("A31", "coulomb per kilogram second", "C/(kg·s)", "10"),
  A32("A32", "coulomb per mole", "C/mol", "08"),
  A33("A33", "coulomb per square centimetre", "C/cm²", "05"),
  A34("A34", "coulomb per square metre", "C/m²", "05"),
  A35("A35", "coulomb per square millimetre", "C/mm²", "05"),
  A36("A36", "cubic centimetre per mole", "cm³/mol", "08"),
  A37("A37", "cubic decimetre per mole", "dm³/mol", "08"),
  A38("A38", "cubic metre per coulomb", "m³/C", "12"),
  A39("A39", "cubic metre per kilogram", "m³/kg", "03"),
  A4("A4", "ampere per square centimetre", "A/cm²", "05"),
  A40("A40", "cubic metre per mole", "m³/mol", "08"),
  A41("A41", "ampere per square metre", "A/m²", "05"),
  A42("A42", "curie per kilogram", "Ci/kg", "09"),
  A43("A43", "deadweight tonnage", "dwt", "3.4"),
  A44("A44", "decalitre", "dal", "01"),
  A45("A45", "decametre", "dam", "01"),
  A47("A47", "decitex", "dtex (g/10km)", "3.5"),
  A48("A48", "degree Rankine", "°R", "04"),
  A49("A49", "denier", "den (g/9 km)", "3.5"),
  A5("A5", "ampere square metre", "A·m²", "05"),
  A53("A53", "electronvolt", "eV", "03"),
  A54("A54", "electronvolt per metre", "eV/m", "10"),
  A55("A55", "electronvolt square metre", "eV·m²", "10"),
  A56("A56", "electronvolt square metre per kilogram", "eV·m²/kg", "10"),
  A59("A59", "8-part cloud cover", null, "3.9"),
  A6("A6", "ampere per square metre kelvin squared", "A/(m²·K²)", "12"),
  A68("A68", "exajoule", "EJ", "03"),
  A69("A69", "farad per metre", "F/m", "05"),
  A7("A7", "ampere per square millimetre", "A/mm²", "05"),
  A70("A70", "femtojoule", "fJ", "03"),
  A71("A71", "femtometre", "fm", "01"),
  A73("A73", "foot per second squared", "ft/s²", "01"),
  A74("A74", "foot pound-force per second", "ft·lbf/s", "03"),
  A75("A75", "freight ton", null, "3.4"),
  A76("A76", "gal", "Gal", "01"),
  A8("A8", "ampere second", "A·s", "05"),
  A84("A84", "gigacoulomb per cubic metre", "GC/m³", "05"),
  A85("A85", "gigaelectronvolt", "GeV", "03"),
  A86("A86", "gigahertz", "GHz", "02"),
  A87("A87", "gigaohm", "GΩ", "05"),
  A88("A88", "gigaohm metre", "GΩ·m", "05"),
  A89("A89", "gigapascal", "GPa", "03"),
  A9("A9", "rate", null, "3.9"),
  A90("A90", "gigawatt", "GW", "03"),
  A91("A91", "gon", "gon", "01"),
  A93("A93", "gram per cubic metre", "g/m³", "03"),
  A94("A94", "gram per mole", "g/mol", "08"),
  A95("A95", "gray", "Gy", "10"),
  A96("A96", "gray per second", "Gy/s", "10"),
  A97("A97", "hectopascal", "hPa", "03"),
  A98("A98", "henry per metre", "H/m", "05"),
  A99("A99", "bit", "bit", "3.6"),
  AA("AA", "ball", null, "3.9"),
  AB("AB", "bulk pack", "pk", "3.9"),
  AC("AC", "Receptacle, paper", null, null),
  ACR("ACR", "acre", "acre", "01"),
  ACT("ACT", "activity", null, "3.2"),
  AD("AD", "byte", "byte", "3.6"),
  AE("AE", "ampere per metre", "A/m", "05"),
  AF("AF", "Pallet, modular, collars 80cms * 60cms", null, null),
  AG("AG", "Pallet, shrinkwrapped", null, null),
  AH("AH", "additional minute", null, "3.5"),
  AI("AI", "average minute per call", null, "3.5"),
  AJ("AJ", "Cone", null, null),
  AK("AK", "fathom", "fth", "01"),
  AL("AL", "access line", null, "3.5"),
  AM("AM", "Ampoule, non-protected", null, null),
  AMH("AMH", "ampere hour", "A·h", "05"),
  AMP("AMP", "ampere", "A", "05"),
  ANN("ANN", "year", "y", "01"),
  AP("AP", "Ampoule, protected", null, null),
  APZ("APZ", "troy ounce or apothecary ounce", "tr oz", "03"),
  AQ("AQ", "anti-hemophilic factor (AHF) unit", null, "3.9"),
  AS("AS", "assortment", null, "3.9"),
  ASM("ASM", "alcoholic strength by mass", null, "3.5"),
  ASU("ASU", "alcoholic strength by volume", null, "3.5"),
  AT("AT", "Atomizer", null, null),
  ATM("ATM", "standard atmosphere", "atm", "03"),
  AV("AV", "Capsule", null, null),
  AWG("AWG", "american wire gauge", "AWG", "01"),
  AY("AY", "assembly", null, "3.9"),
  AZ("AZ", "British thermal unit (international table) per pound", "BtuIT/lb", "04"),
  B1("B1", "barrel (US) per day", "barrel (US)/d", "3.5"),
  B10("B10", "bit per second", "bit/s", "3.6"),
  B11("B11", "joule per kilogram kelvin", "J/(kg·K)", "04"),
  B12("B12", "joule per metre", "J/m", "10"),
  B13("B13", "joule per square metre", "J/m²", "06"),
  B14("B14", "joule per metre to the fourth power", "J/m⁴", "06"),
  B15("B15", "joule per mole", "J/mol", "08"),
  B16("B16", "joule per mole kelvin", "J/(mol·K)", "08"),
  B17("B17", "credit", null, "3.9"),
  B18("B18", "joule second", "J·s", "09"),
  B19("B19", "digit", null, "3.7"),
  B20("B20", "joule square metre per kilogram", "J·m²/kg", "10"),
  B21("B21", "kelvin per watt", "K/W", "04"),
  B22("B22", "kiloampere", "kA", "05"),
  B23("B23", "kiloampere per square metre", "kA/m²", "05"),
  B24("B24", "kiloampere per metre", "kA/m", "05"),
  B25("B25", "kilobecquerel per kilogram", "kBq/kg", "09"),
  B26("B26", "kilocoulomb", "kC", "05"),
  B27("B27", "kilocoulomb per cubic metre", "kC/m³", "05"),
  B28("B28", "kilocoulomb per square metre", "kC/m²", "05"),
  B29("B29", "kiloelectronvolt", "keV", "03"),
  B3("B3", "batting pound", null, "3.1"),
  B30("B30", "gibibit", "Gibit", "3.6"),
  B31("B31", "kilogram metre per second", "kg·m/s", "03"),
  B32("B32", "kilogram metre squared", "kg·m²", "03"),
  B33("B33", "kilogram metre squared per second", "kg·m²/s", "03"),
  B34("B34", "kilogram per cubic decimetre", "kg/dm³", "03"),
  B35("B35", "kilogram per litre", "kg/l or kg/L", "03"),
  B4("B4", "barrel, imperial", null, "3.5"),
  B41("B41", "kilojoule per kelvin", "kJ/K", "04"),
  B42("B42", "kilojoule per kilogram", "kJ/kg", "04"),
  B43("B43", "kilojoule per kilogram kelvin", "kJ/(kg·K)", "04"),
  B44("B44", "kilojoule per mole", "kJ/mol", "08"),
  B45("B45", "kilomole", "kmol", "08"),
  B46("B46", "kilomole per cubic metre", "kmol/m³", "08"),
  B47("B47", "kilonewton", "kN", "03"),
  B48("B48", "kilonewton metre", "kN·m", "03"),
  B49("B49", "kiloohm", "kΩ", "05"),
  B50("B50", "kiloohm metre", "kΩ·m", "05"),
  B52("B52", "kilosecond", "ks", "01"),
  B53("B53", "kilosiemens", "kS", "05"),
  B54("B54", "kilosiemens per metre", "kS/m", "05"),
  B55("B55", "kilovolt per metre", "kV/m", "05"),
  B56("B56", "kiloweber per metre", "kWb/m", "05"),
  B57("B57", "light year", "ly", "01"),
  B58("B58", "litre per mole", "l/mol", "08"),
  B59("B59", "lumen hour", "lm·h", "06"),
  B60("B60", "lumen per square metre", "lm/m²", "06"),
  B61("B61", "lumen per watt", "lm/W", "06"),
  B62("B62", "lumen second", "lm·s", "06"),
  B63("B63", "lux hour", "lx·h", "06"),
  B64("B64", "lux second", "lx·s", "06"),
  B66("B66", "megaampere per square metre", "MA/m²", "05"),
  B67("B67", "megabecquerel per kilogram", "MBq/kg", "09"),
  B68("B68", "gigabit", "Gbit", "3.6"),
  B69("B69", "megacoulomb per cubic metre", "MC/m³", "05"),
  B7("B7", "cycle", null, "3.9"),
  B70("B70", "megacoulomb per square metre", "MC/m²", "05"),
  B71("B71", "megaelectronvolt", "MeV", "03"),
  B72("B72", "megagram per cubic metre", "Mg/m³", "03"),
  B73("B73", "meganewton", "MN", "03"),
  B74("B74", "meganewton metre", "MN·m", "03"),
  B75("B75", "megaohm", "MΩ", "05"),
  B76("B76", "megaohm metre", "MΩ·m", "05"),
  B77("B77", "megasiemens per metre", "MS/m", "05"),
  B78("B78", "megavolt", "MV", "05"),
  B79("B79", "megavolt per metre", "MV/m", "05"),
  B8("B8", "joule per cubic metre", "J/m³", "05"),
  B80("B80", "gigabit per second", "Gbit/s", "3.6"),
  B81("B81", "reciprocal metre squared reciprocal second", "m⁻²/s", "10"),
  B82("B82", "inch per linear foot", null, "3.1"),
  B83("B83", "metre to the fourth power", "m⁴", "03"),
  B84("B84", "microampere", "µA", "05"),
  B85("B85", "microbar", "µbar", "03"),
  B86("B86", "microcoulomb", "µC", "05"),
  B87("B87", "microcoulomb per cubic metre", "µC/m³", "05"),
  B88("B88", "microcoulomb per square metre", "µC/m²", "05"),
  B89("B89", "microfarad per metre", "µF/m", "05"),
  B90("B90", "microhenry", "µH", "05"),
  B91("B91", "microhenry per metre", "µH/m", "05"),
  B92("B92", "micronewton", "µN", "03"),
  B93("B93", "micronewton metre", "µN·m", "03"),
  B94("B94", "microohm", "µΩ", "05"),
  B95("B95", "microohm metre", "µΩ·m", "05"),
  B96("B96", "micropascal", "µPa", "03"),
  B97("B97", "microradian", "µrad", "01"),
  B98("B98", "microsecond", "µs", "01"),
  B99("B99", "microsiemens", "µS", "05"),
  BA("BA", "Barrel", null, null),
  BAR("BAR", "bar [unit of pressure]", "bar", "03"),
  BB("BB", "base box", null, "3.5"),
  BC("BC", "Bottlecrate / bottlerack", null, null),
  BD("BD", "Board", null, null),
  BE("BE", "Bundle", null, null),
  BF("BF", "Balloon, non-protected", null, null),
  BFT("BFT", "board foot", "fbm", "3.5"),
  BG("BG", "Bag", null, null),
  BH("BH", "Bunch", null, null),
  BHP("BHP", "brake horse power", "BHP", "03"),
  BI("BI", "Bin", null, null),
  BIL("BIL", "billion (EUR)", null, "3.7"),
  BJ("BJ", "Bucket", null, null),
  BK("BK", "Basket", null, null),
  BL("BL", "Bale, compressed", null, null),
  BLD("BLD", "dry barrel (US)", "bbl (US)", "01"),
  BLL("BLL", "barrel (US)", "barrel (US)", "01"),
  BM("BM", "Basin", null, null),
  BN("BN", "Bale, non-compressed", null, null),
  BO("BO", "Bottle, non-protected, cylindrical", null, null),
  BP("BP", "hundred board foot", null, "3.5"),
  BPM("BPM", "beats per minute", "BPM", "3.1"),
  BQ("BQ", "Bottle, protected cylindrical", null, null),
  BQL("BQL", "becquerel", "Bq", "09"),
  BR("BR", "Bar", null, null),
  BS("BS", "Bottle, non-protected, bulbous", null, null),
  BT("BT", "Bolt", null, null),
  BTU("BTU", "British thermal unit (international table)", "BtuIT", "04"),
  BU("BU", "Butt", null, null),
  BUA("BUA", "bushel (US)", "bu (US)", "01"),
  BUI("BUI", "bushel (UK)", "bushel (UK)", "01"),
  BV("BV", "Bottle, protected bulbous", null, null),
  BW("BW", "Box, for liquids", null, null),
  BX("BX", "Box", null, null),
  BY("BY", "Board, in bundle/bunch/truss", null, null),
  BZ("BZ", "Bars, in bundle/bunch/truss", null, null),
  C0("C0", "call", null, "3.5"),
  C10("C10", "millifarad", "mF", "05"),
  C11("C11", "milligal", "mGal", "01"),
  C12("C12", "milligram per metre", "mg/m", "03"),
  C13("C13", "milligray", "mGy", "10"),
  C14("C14", "millihenry", "mH", "05"),
  C15("C15", "millijoule", "mJ", "03"),
  C16("C16", "millimetre per second", "mm/s", "01"),
  C17("C17", "millimetre squared per second", "mm²/s", "03"),
  C18("C18", "millimole", "mmol", "08"),
  C19("C19", "mole per kilogram", "mol/kg", "08"),
  C20("C20", "millinewton", "mN", "03"),
  C21("C21", "kibibit", "Kibit", "3.6"),
  C22("C22", "millinewton per metre", "mN/m", "03"),
  C23("C23", "milliohm metre", "mΩ·m", "05"),
  C24("C24", "millipascal second", "mPa·s", "03"),
  C25("C25", "milliradian", "mrad", "01"),
  C26("C26", "millisecond", "ms", "01"),
  C27("C27", "millisiemens", "mS", "05"),
  C28("C28", "millisievert", "mSv", "10"),
  C29("C29", "millitesla", "mT", "05"),
  C3("C3", "microvolt per metre", "µV/m", "05"),
  C30("C30", "millivolt per metre", "mV/m", "05"),
  C31("C31", "milliwatt", "mW", "03"),
  C32("C32", "milliwatt per square metre", "mW/m²", "07"),
  C33("C33", "milliweber", "mWb", "05"),
  C34("C34", "mole", "mol", "08"),
  C35("C35", "mole per cubic decimetre", "mol/dm³", "08"),
  C36("C36", "mole per cubic metre", "mol/m³", "08"),
  C37("C37", "kilobit", "kbit", "3.6"),
  C38("C38", "mole per litre", "mol/l", "08"),
  C39("C39", "nanoampere", "nA", "05"),
  C40("C40", "nanocoulomb", "nC", "05"),
  C41("C41", "nanofarad", "nF", "05"),
  C42("C42", "nanofarad per metre", "nF/m", "05"),
  C43("C43", "nanohenry", "nH", "05"),
  C44("C44", "nanohenry per metre", "nH/m", "05"),
  C45("C45", "nanometre", "nm", "01"),
  C46("C46", "nanoohm metre", "nΩ·m", "05"),
  C47("C47", "nanosecond", "ns", "01"),
  C48("C48", "nanotesla", "nT", "05"),
  C49("C49", "nanowatt", "nW", "05"),
  C50("C50", "neper", "Np", "02"),
  C51("C51", "neper per second", "Np/s", "02"),
  C52("C52", "picometre", "pm", "01"),
  C53("C53", "newton metre second", "N·m·s", "03"),
  C54("C54", "newton metre squared per kilogram squared", "N·m²/kg²", "03"),
  C55("C55", "newton per square metre", "N/m²", "03"),
  C56("C56", "newton per square millimetre", "N/mm²", "03"),
  C57("C57", "newton second", "N·s", "03"),
  C58("C58", "newton second per metre", "N·s/m", "07"),
  C59("C59", "octave", null, "07"),
  C60("C60", "ohm centimetre", "Ω·cm", "05"),
  C61("C61", "ohm metre", "Ω·m", "05"),
  C62("C62", "one", "1", "03"),
  C63("C63", "parsec", "pc", "01"),
  C64("C64", "pascal per kelvin", "Pa/K", "04"),
  C65("C65", "pascal second", "Pa·s", "03"),
  C66("C66", "pascal second per cubic metre", "Pa·s/m³", "07"),
  C67("C67", "pascal second per metre", "Pa· s/m", "07"),
  C68("C68", "petajoule", "PJ", "03"),
  C69("C69", "phon", null, "07"),
  C7("C7", "centipoise", "cP", "03"),
  C70("C70", "picoampere", "pA", "05"),
  C71("C71", "picocoulomb", "pC", "05"),
  C72("C72", "picofarad per metre", "pF/m", "05"),
  C73("C73", "picohenry", "pH", "05"),
  C74("C74", "kilobit per second", "kbit/s", "3.6"),
  C75("C75", "picowatt", "pW", "05"),
  C76("C76", "picowatt per square metre", "pW/m²", "07"),
  C78("C78", "pound-force", "lbf", "03"),
  C79("C79", "kilovolt ampere hour", "kVAh", "3.1"),
  C8("C8", "millicoulomb per kilogram", "mC/kg", "10"),
  C80("C80", "rad", "rad", "10"),
  C81("C81", "radian", "rad", "01"),
  C82("C82", "radian square metre per mole", "rad·m²/mol", "08"),
  C83("C83", "radian square metre per kilogram", "rad·m²/kg", "08"),
  C84("C84", "radian per metre", "rad/m", "06"),
  C85("C85", "reciprocal angstrom", "Å⁻¹", "12"),
  C86("C86", "reciprocal cubic metre", "m⁻³", "08"),
  C87("C87", "reciprocal cubic metre per second", "m⁻³/s", "10"),
  C88("C88", "reciprocal electron volt per cubic metre", "eV⁻¹/m³", "12"),
  C89("C89", "reciprocal henry", "H⁻¹", "05"),
  C9("C9", "coil group", null, "3.9"),
  C90("C90", "reciprocal joule per cubic metre", "J⁻¹/m³", "12"),
  C91("C91", "reciprocal kelvin or kelvin to the power minus one", "K⁻¹", "04"),
  C92("C92", "reciprocal metre", "m⁻¹", "01"),
  C93("C93", "reciprocal square metre", "m⁻²", "06"),
  C94("C94", "reciprocal minute", "min⁻¹", "02"),
  C95("C95", "reciprocal mole", "mol⁻¹", "08"),
  C96("C96", "reciprocal pascal or pascal to the power minus one", "Pa⁻¹", "03"),
  C97("C97", "reciprocal second", "s⁻¹", "02"),
  C99("C99", "reciprocal second per metre squared", "s⁻¹/m²", "06"),
  CA("CA", "Can, rectangular", null, null),
  CB("CB", "Crate, beer", null, null),
  CC("CC", "Churn", null, null),
  CCT("CCT", "carrying capacity in metric ton", null, "3.4"),
  CD("CD", "Can, with handle and spout", null, null),
  CDL("CDL", "candela", "cd", "06"),
  CE("CE", "Creel", null, null),
  CEL("CEL", "degree Celsius", "°C", "04"),
  CEN("CEN", "hundred", null, "3.7"),
  CF("CF", "Coffer", null, null),
  CG("CG", "card", null, "3.9"),
  CGM("CGM", "centigram", "cg", "03"),
  CH("CH", "Chest", null, null),
  CI("CI", "Canister", null, null),
  CJ("CJ", "Coffin", null, null),
  CK("CK", "Cask", null, null),
  CKG("CKG", "coulomb per kilogram", "C/kg", "10"),
  CL("CL", "Coil", null, null),
  CLF("CLF", "hundred leave", null, "3.8"),
  CLT("CLT", "centilitre", "cl", "01"),
  CM("CM", "Card", null, null),
  CMK("CMK", "square centimetre", "cm²", "01"),
  CMQ("CMQ", "cubic centimetre", "cm³", "01"),
  CMT("CMT", "centimetre", "cm", "01"),
  CN("CN", "Container, not otherwise specified as transport equipment", null, null),
  CNP("CNP", "hundred pack", null, """
  |3.2
  |3.8
  """.trimMargin()),
  CNT("CNT", "cental (UK)", null, "3.5"),
  CO("CO", "Carboy, non-protected", null, null),
  COU("COU", "coulomb", "C", "05"),
  CP("CP", "Carboy, protected", null, null),
  CQ("CQ", "Cartridge", null, null),
  CR("CR", "Crate", null, null),
  CS("CS", "Case", null, null),
  CT("CT", "Carton", null, null),
  CTG("CTG", "content gram", null, "3.1"),
  CTM("CTM", "metric carat", null, "3.5"),
  CTN("CTN", "content ton (metric)", null, "3.1"),
  CU("CU", "Cup", null, null),
  CUR("CUR", "curie", "Ci", "09"),
  CV("CV", "Cover", null, null),
  CW("CW", "Cage, roll", null, null),
  CWA("CWA", "hundred pound (cwt) / hundred weight (US)", "cwt (US)", "03"),
  CWI("CWI", "hundred weight (UK)", "cwt (UK)", "03"),
  CX("CX", "Can, cylindrical", null, null),
  CY("CY", "Cylinder", null, null),
  CZ("CZ", "Canvas", null, null),
  D03("D03", "kilowatt hour per hour", "kW·h/h", "3.1"),
  D04("D04", "lot [unit of weight]", null, "3.2"),
  D1("D1", "reciprocal second per steradian", "s⁻¹/sr", "06"),
  D10("D10", "siemens per metre", "S/m", "05"),
  D11("D11", "mebibit", "Mibit", "3.6"),
  D12("D12", "siemens square metre per mole", "S·m²/mol", "08"),
  D13("D13", "sievert", "Sv", "10"),
  D15("D15", "sone", null, "07"),
  D16("D16", "square centimetre per erg", "cm²/erg", "10"),
  D17("D17", "square centimetre per steradian erg", "cm²/(sr·erg)", "10"),
  D18("D18", "metre kelvin", "m·K", "06"),
  D19("D19", "square metre kelvin per watt", "m²·K/W", "04"),
  D2("D2", "reciprocal second per steradian metre squared", "s⁻¹/(sr·m²)", "06"),
  D20("D20", "square metre per joule", "m²/J", "10"),
  D21("D21", "square metre per kilogram", "m²/kg", "10"),
  D22("D22", "square metre per mole", "m²/mol", "06"),
  D23("D23", "pen gram (protein)", null, "3.9"),
  D24("D24", "square metre per steradian", "m²/sr", "10"),
  D25("D25", "square metre per steradian joule", "m²/(sr·J)", "10"),
  D26("D26", "square metre per volt second", "m²/(V·s)", "10"),
  D27("D27", "steradian", "sr", "01"),
  D29("D29", "terahertz", "THz", "02"),
  D30("D30", "terajoule", "TJ", "03"),
  D31("D31", "terawatt", "TW", "05"),
  D32("D32", "terawatt hour", "TW·h", "03"),
  D33("D33", "tesla", "T", "05"),
  D34("D34", "tex", "tex (g/km)", "3.5"),
  D36("D36", "megabit", "Mbit", "3.6"),
  D41("D41", "tonne per cubic metre", "t/m³", "03"),
  D42("D42", "tropical year", "y (tropical)", "01"),
  D43("D43", "unified atomic mass unit", "u", "08"),
  D44("D44", "var", "var", "05"),
  D45("D45", "volt squared per kelvin squared", "V²/K²", "05"),
  D46("D46", "volt - ampere", "V·A", "05"),
  D47("D47", "volt per centimetre", "V/cm", "05"),
  D48("D48", "volt per kelvin", "V/K", "12"),
  D49("D49", "millivolt per kelvin", "mV/K", "12"),
  D5("D5", "kilogram per square centimetre", "kg/cm²", "03"),
  D50("D50", "volt per metre", "V/m", "05"),
  D51("D51", "volt per millimetre", "V/mm", "05"),
  D52("D52", "watt per kelvin", "W/K", "04"),
  D53("D53", "watt per metre kelvin", "W/(m·K)", "04"),
  D54("D54", "watt per square metre", "W/m²", "04"),
  D55("D55", "watt per square metre kelvin", "W/(m²·K)", "04"),
  D56("D56", "watt per square metre kelvin to the fourth power", "W/(m²·K⁴)", "06"),
  D57("D57", "watt per steradian", "W/sr", "06"),
  D58("D58", "watt per steradian square metre", "W/(sr·m²)", "06"),
  D59("D59", "weber per metre", "Wb/m", "05"),
  D6("D6", "roentgen per second", "R/s", "10"),
  D60("D60", "weber per millimetre", "Wb/mm", "05"),
  D61("D61", "minute [unit of angle]", "'", "01"),
  D62("D62", "second [unit of angle]", "\"", "01"),
  D63("D63", "book", null, "3.9"),
  D65("D65", "round", null, "3.9"),
  D68("D68", "number of words", null, "3.7"),
  D69("D69", "inch to the fourth power", "in⁴", "03"),
  D73("D73", "joule square metre", "J·m²", "10"),
  D74("D74", "kilogram per mole", "kg/mol", "08"),
  D77("D77", "megacoulomb", "MC", "05"),
  D78("D78", "megajoule per second", "MJ/s", "3.1"),
  D80("D80", "microwatt", "µW", "03"),
  D81("D81", "microtesla", "µT", "05"),
  D82("D82", "microvolt", "µV", "05"),
  D83("D83", "millinewton metre", "mN·m", "03"),
  D85("D85", "microwatt per square metre", "µW/m²", "07"),
  D86("D86", "millicoulomb", "mC", "05"),
  D87("D87", "millimole per kilogram", "mmol/kg", "08"),
  D88("D88", "millicoulomb per cubic metre", "mC/m³", "05"),
  D89("D89", "millicoulomb per square metre", "mC/m²", "05"),
  D91("D91", "rem", "rem", "10"),
  D93("D93", "second per cubic metre", "s/m³", "08"),
  D94("D94", "second per cubic metre radian", "s/(rad·m³)", "12"),
  D95("D95", "joule per gram", "J/g", "04"),
  DA("DA", "Crate, multiple layer, plastic", null, null),
  DAA("DAA", "decare", "daa", "01"),
  DAD("DAD", "ten day", null, "3.2"),
  DAY("DAY", "day", "d", "01"),
  DB("DB", "dry pound", null, "3.1"),
  DBM("DBM", "Decibel-milliwatts", "dBm", "3.1"),
  DBW("DBW", "Decibel watt", "dBW", "3.1"),
  DC("DC", "Crate, multiple layer, cardboard", null, null),
  DD("DD", "degree [unit of angle]", "°", "01"),
  DEC("DEC", "decade", null, "3.8"),
  DG("DG", "decigram", "dg", "03"),
  DH("DH", "Box, Commonwealth Handling Equipment Pool (CHEP), Eurobox", null, null),
  DI("DI", "Drum, iron", null, null),
  DJ("DJ", "decagram", "dag", "03"),
  DK("DK", "Crate, bulk, cardboard", null, null),
  DL("DL", "Crate, bulk, plastic", null, null),
  DLT("DLT", "decilitre", "dl", "01"),
  DM("DM", "Crate, bulk, wooden", null, null),
  DMA("DMA", "cubic decametre", "dam³", "01"),
  DMK("DMK", "square decimetre", "dm²", "01"),
  DMO("DMO", "standard kilolitre", null, "3.1"),
  DMQ("DMQ", "cubic decimetre", "dm³", "01"),
  DMT("DMT", "decimetre", "dm", "01"),
  DN("DN", "decinewton metre", "dN·m", "03"),
  DP("DP", "Demijohn, protected", null, null),
  DPC("DPC", "dozen piece", null, "3.2"),
  DPR("DPR", "dozen pair", null, "3.2"),
  DPT("DPT", "displacement tonnage", null, "3.4"),
  DR("DR", "Drum", null, null),
  DRA("DRA", "dram (US)", null, "3.5"),
  DRI("DRI", "dram (UK)", null, "3.5"),
  DRL("DRL", "dozen roll", null, "3.2"),
  DS("DS", "Tray, one layer no cover, plastic", null, null),
  DT("DT", "dry ton", null, "3.1"),
  DTN("DTN", "decitonne", "dt or dtn", "03"),
  DU("DU", "Tray, one layer no cover, polystyrene", null, null),
  DV("DV", "Tray, one layer no cover, cardboard", null, null),
  DW("DW", "Tray, two layers no cover, plastic tray", null, null),
  DWT("DWT", "pennyweight", null, "3.5"),
  DX("DX", "Tray, two layers no cover, wooden", null, null),
  DY("DY", "Tray, two layers no cover, cardboard", null, null),
  DZN("DZN", "dozen", "DOZ", "3.7"),
  DZP("DZP", "dozen pack", null, "3.2"),
  E01("E01", "newton per square centimetre", "N/cm²", "03"),
  E07("E07", "megawatt hour per hour", "MW·h/h", "3.1"),
  E08("E08", "megawatt per hertz", "MW/Hz", "3.1"),
  E09("E09", "milliampere hour", "mA·h", "05"),
  E10("E10", "degree day", "deg da", "3.5"),
  E12("E12", "mille", null, "3.9"),
  E14("E14", "kilocalorie (international table)", "kcalIT", "04"),
  E15("E15", "kilocalorie (thermochemical) per hour", "kcalth/h", "04"),
  E16("E16", "million Btu(IT) per hour", "BtuIT/h", "3.1"),
  E17("E17", "cubic foot per second", "ft³/s", "3.1"),
  E18("E18", "tonne per hour", "t/h", "03"),
  E19("E19", "ping", null, "3.1"),
  E20("E20", "megabit per second", "Mbit/s", "3.6"),
  E21("E21", "shares", null, "3.7"),
  E22("E22", "TEU", null, "3.4"),
  E23("E23", "tyre", null, "3.7"),
  E25("E25", "active unit", null, "3.9"),
  E27("E27", "dose", null, "3.9"),
  E28("E28", "air dry ton", null, "3.1"),
  E30("E30", "strand", null, "3.7"),
  E31("E31", "square metre per litre", "m²/l", "3.1"),
  E32("E32", "litre per hour", "l/h", "3.1"),
  E33("E33", "foot per thousand", null, "3.1"),
  E34("E34", "gigabyte", "Gbyte", "3.6"),
  E35("E35", "terabyte", "Tbyte", "3.6"),
  E36("E36", "petabyte", "Pbyte", "3.6"),
  E37("E37", "pixel", null, "3.6"),
  E38("E38", "megapixel", null, "3.6"),
  E39("E39", "dots per inch", "dpi", "3.6"),
  E4("E4", "gross kilogram", null, "3.1"),
  E40("E40", "part per hundred thousand", "ppht", "3.7"),
  E41("E41", "kilogram-force per square millimetre", "kgf·m/cm²", "03"),
  E42("E42", "kilogram-force per square centimetre", "kgf/cm²", "03"),
  E43("E43", "joule per square centimetre", "J/cm²", "06"),
  E44("E44", "kilogram-force metre per square centimetre", "kgf·m/cm²", "3.5"),
  E45("E45", "milliohm", "mΩ", "05"),
  E46("E46", "kilowatt hour per cubic metre", "kW·h/m³", "3.1"),
  E47("E47", "kilowatt hour per kelvin", "kW·h/K", "3.1"),
  E48("E48", "service unit", null, "3.5"),
  E49("E49", "working day", null, "3.5"),
  E50("E50", "accounting unit", null, "3.5"),
  E51("E51", "job", null, "3.5"),
  E52("E52", "run foot", null, "3.5"),
  E53("E53", "test", null, "3.5"),
  E54("E54", "trip", null, "3.5"),
  E55("E55", "use", null, "3.5"),
  E56("E56", "well", null, "3.5"),
  E57("E57", "zone", null, "3.5"),
  E58("E58", "exabit per second", "Ebit/s", "3.6"),
  E59("E59", "exbibyte", "Eibyte", "3.6"),
  E60("E60", "pebibyte", "Pibyte", "3.6"),
  E61("E61", "tebibyte", "Tibyte", "3.6"),
  E62("E62", "gibibyte", "Gibyte", "3.6"),
  E63("E63", "mebibyte", "Mibyte", "3.6"),
  E64("E64", "kibibyte", "Kibyte", "3.6"),
  E65("E65", "exbibit per metre", "Eibit/m", "3.6"),
  E66("E66", "exbibit per square metre", "Eibit/m²", "3.6"),
  E67("E67", "exbibit per cubic metre", "Eibit/m³", "3.6"),
  E68("E68", "gigabyte per second", "Gbyte/s", "3.6"),
  E69("E69", "gibibit per metre", "Gibit/m", "3.6"),
  E70("E70", "gibibit per square metre", "Gibit/m²", "3.6"),
  E71("E71", "gibibit per cubic metre", "Gibit/m³", "3.6"),
  E72("E72", "kibibit per metre", "Kibit/m", "3.6"),
  E73("E73", "kibibit per square metre", "Kibit/m²", "3.6"),
  E74("E74", "kibibit per cubic metre", "Kibit/m³", "3.6"),
  E75("E75", "mebibit per metre", "Mibit/m", "3.6"),
  E76("E76", "mebibit per square metre", "Mibit/m²", "3.6"),
  E77("E77", "mebibit per cubic metre", "Mibit/m³", "3.6"),
  E78("E78", "petabit", "Pbit", "3.6"),
  E79("E79", "petabit per second", "Pbit/s", "3.6"),
  E80("E80", "pebibit per metre", "Pibit/m", "3.6"),
  E81("E81", "pebibit per square metre", "Pibit/m²", "3.6"),
  E82("E82", "pebibit per cubic metre", "Pibit/m³", "3.6"),
  E83("E83", "terabit", "Tbit", "3.6"),
  E84("E84", "terabit per second", "Tbit/s", "3.6"),
  E85("E85", "tebibit per metre", "Tibit/m", "3.6"),
  E86("E86", "tebibit per cubic metre", "Tibit/m³", "3.6"),
  E87("E87", "tebibit per square metre", "Tibit/m²", "3.6"),
  E88("E88", "bit per metre", "bit/m", "3.6"),
  E89("E89", "bit per square metre", "bit/m²", "3.6"),
  E90("E90", "reciprocal centimetre", "cm⁻¹", "3.1"),
  E91("E91", "reciprocal day", "d⁻¹", "3.1"),
  E92("E92", "cubic decimetre per hour", "dm³/h", "03"),
  E93("E93", "kilogram per hour", "kg/h", "03"),
  E94("E94", "kilomole per second", "kmol/s", "08"),
  E95("E95", "mole per second", "mol/s", "08"),
  E96("E96", "degree per second", "°/s", "01"),
  E97("E97", "millimetre per degree Celcius metre", "mm/(°C·m)", "04"),
  E98("E98", "degree Celsius per kelvin", "°C/K", "04"),
  E99("E99", "hectopascal per bar", "hPa/bar", "03"),
  EA("EA", "each", null, "3.2"),
  EB("EB", "electronic mail box", null, "3.9"),
  EC("EC", "Bag, plastic", null, null),
  ED("ED", "Case, with pallet base", null, null),
  EE("EE", "Case, with pallet base, wooden", null, null),
  EF("EF", "Case, with pallet base, cardboard", null, null),
  EG("EG", "Case, with pallet base, plastic", null, null),
  EH("EH", "Case, with pallet base, metal", null, null),
  EI("EI", "Case, isothermic", null, null),
  EN("EN", "Envelope", null, null),
  EQ("EQ", "equivalent gallon", null, "3.1"),
  F01("F01", "bit per cubic metre", "bit/m³", "3.6"),
  F02("F02", "kelvin per kelvin", "K/K", "04"),
  F03("F03", "kilopascal per bar", "kPa/bar", "03"),
  F04("F04", "millibar per bar", "mbar/bar", "03"),
  F05("F05", "megapascal per bar", "MPa/bar", "03"),
  F06("F06", "poise per bar", "P/bar", "03"),
  F07("F07", "pascal per bar", "Pa/bar", "03"),
  F08("F08", "milliampere per inch", "mA/in", "05"),
  F10("F10", "kelvin per hour", "K/h", "04"),
  F11("F11", "kelvin per minute", "K/min", "04"),
  F12("F12", "kelvin per second", "K/s", "04"),
  F13("F13", "slug", "slug", "03"),
  F14("F14", "gram per kelvin", "g/K", "03"),
  F15("F15", "kilogram per kelvin", "kg/K", "03"),
  F16("F16", "milligram per kelvin", "mg/K", "03"),
  F17("F17", "pound-force per foot", "lbf/ft", "03"),
  F18("F18", "kilogram square centimetre", "kg·cm²", "03"),
  F19("F19", "kilogram square millimetre", "kg·mm²", "03"),
  F20("F20", "pound inch squared", "lb·in²", "03"),
  F21("F21", "pound-force inch", "lbf·in", "03"),
  F22("F22", "pound-force foot per ampere", "lbf·ft/A", "03"),
  F23("F23", "gram per cubic decimetre", "g/dm³", "03"),
  F24("F24", "kilogram per kilomole", "kg/kmol", "03"),
  F25("F25", "gram per hertz", "g/Hz", "03"),
  F26("F26", "gram per day", "g/d", "03"),
  F27("F27", "gram per hour", "g/h", "03"),
  F28("F28", "gram per minute", "g/min", "03"),
  F29("F29", "gram per second", "g/s", "03"),
  F30("F30", "kilogram per day", "kg/d", "03"),
  F31("F31", "kilogram per minute", "kg/min", "03"),
  F32("F32", "milligram per day", "mg/d", "03"),
  F33("F33", "milligram per minute", "mg/min", "03"),
  F34("F34", "milligram per second", "mg/s", "03"),
  F35("F35", "gram per day kelvin", "g/(d·K)", "03"),
  F36("F36", "gram per hour kelvin", "g/(h·K)", "03"),
  F37("F37", "gram per minute kelvin", "g/(min·K)", "03"),
  F38("F38", "gram per second kelvin", "g/(s·K)", "03"),
  F39("F39", "kilogram per day kelvin", "kg/(d·K)", "03"),
  F40("F40", "kilogram per hour kelvin", "kg/(h·K)", "03"),
  F41("F41", "kilogram per minute kelvin", "kg/(min·K)", "03"),
  F42("F42", "kilogram per second kelvin", "kg/(s·K)", "03"),
  F43("F43", "milligram per day kelvin", "mg/(d·K)", "03"),
  F44("F44", "milligram per hour kelvin", "mg/(h·K)", "03"),
  F45("F45", "milligram per minute kelvin", "mg/(min·K)", "03"),
  F46("F46", "milligram per second kelvin", "mg/(s·K)", "03"),
  F47("F47", "newton per millimetre", "N/mm", "03"),
  F48("F48", "pound-force per inch", "lbf/in", "03"),
  F49("F49", "rod [unit of distance]", "rd (US)", "01"),
  F50("F50", "micrometre per kelvin", "µm/K", "01"),
  F51("F51", "centimetre per kelvin", "cm/K", "01"),
  F52("F52", "metre per kelvin", "m/K", "01"),
  F53("F53", "millimetre per kelvin", "mm/K", "04"),
  F54("F54", "milliohm per metre", "mΩ/m", "05"),
  F55("F55", "ohm per mile (statute mile)", "Ω/mi", "05"),
  F56("F56", "ohm per kilometre", "Ω/km", "05"),
  F57("F57", "milliampere per pound-force per square inch", "mA/(lbf/in²)", "05"),
  F58("F58", "reciprocal bar", "1/bar", "03"),
  F59("F59", "milliampere per bar", "mA/bar", "05"),
  F60("F60", "degree Celsius per bar", "°C/bar", "04"),
  F61("F61", "kelvin per bar", "K/bar", "04"),
  F62("F62", "gram per day bar", "g/(d·bar)", "03"),
  F63("F63", "gram per hour bar", "g/(h·bar)", "03"),
  F64("F64", "gram per minute bar", "g/(min·bar)", "03"),
  F65("F65", "gram per second bar", "g/(s·bar)", "03"),
  F66("F66", "kilogram per day bar", "kg/(d·bar)", "03"),
  F67("F67", "kilogram per hour bar", "kg/(h·bar)", "03"),
  F68("F68", "kilogram per minute bar", "kg/(min·bar)", "03"),
  F69("F69", "kilogram per second bar", "kg/(s·bar)", "03"),
  F70("F70", "milligram per day bar", "mg/(d·bar)", "03"),
  F71("F71", "milligram per hour bar", "mg/(h·bar)", "03"),
  F72("F72", "milligram per minute bar", "mg/(min·bar)", "03"),
  F73("F73", "milligram per second bar", "mg/(s·bar)", "03"),
  F74("F74", "gram per bar", "g/bar", "03"),
  F75("F75", "milligram per bar", "mg/bar", "03"),
  F76("F76", "milliampere per millimetre", "mA/mm", "05"),
  F77("F77", "pascal second per kelvin", "Pa.s/K", "03"),
  F78("F78", "inch of water", "inH₂O", "03"),
  F79("F79", "inch of mercury", "inHg", "03"),
  F80("F80", "water horse power", null, "03"),
  F81("F81", "bar per kelvin", "bar/K", "04"),
  F82("F82", "hectopascal per kelvin", "hPa/K", "03"),
  F83("F83", "kilopascal per kelvin", "kPa/K", "03"),
  F84("F84", "millibar per kelvin", "mbar/K", "03"),
  F85("F85", "megapascal per kelvin", "MPa/K", "03"),
  F86("F86", "poise per kelvin", "P/K", "03"),
  F87("F87", "volt per litre minute", "V/(l·min)", "05"),
  F88("F88", "newton centimetre", "N·cm", "03"),
  F89("F89", "newton metre per degree", "Nm/°", "03"),
  F90("F90", "newton metre per ampere", "N·m/A", "03"),
  F91("F91", "bar litre per second", "bar·l/s", "03"),
  F92("F92", "bar cubic metre per second", "bar·m³/s", "03"),
  F93("F93", "hectopascal litre per second", "hPa·l/s", "03"),
  F94("F94", "hectopascal cubic metre per second", "hPa·m³/s", "03"),
  F95("F95", "millibar litre per second", "mbar·l/s", "03"),
  F96("F96", "millibar cubic metre per second", "mbar·m³/s", "03"),
  F97("F97", "megapascal litre per second", "MPa·l/s", "03"),
  F98("F98", "megapascal cubic metre per second", "MPa·m³/s", "03"),
  F99("F99", "pascal litre per second", "Pa·l/s", "03"),
  FAH("FAH", "degree Fahrenheit", "°F", "04"),
  FAR("FAR", "farad", "F", "05"),
  FB("FB", "Flexibag", null, null),
  FBM("FBM", "fibre metre", null, "3.1"),
  FC("FC", "thousand cubic foot", "kft³", "3.8"),
  FD("FD", "Crate, framed", null, null),
  FE("FE", "Flexitank", null, null),
  FF("FF", "hundred cubic metre", null, "3.8"),
  FH("FH", "micromole", "µmol", "08"),
  FI("FI", "Firkin", null, null),
  FIT("FIT", "failures in time", "FIT", "3.8"),
  FL("FL", "flake ton", null, "3.1"),
  FNU("FNU", "Formazin nephelometric unit", "FNU", "3.5"),
  FO("FO", "Footlocker", null, null),
  FOT("FOT", "foot", "ft", "01"),
  FP("FP", "pound per square foot", "lb/ft²", "03"),
  FR("FR", "foot per minute", "ft/min", "01"),
  FS("FS", "foot per second", "ft/s", "01"),
  FT("FT", "Foodtainer", null, null),
  FTK("FTK", "square foot", "ft²", "01"),
  FTQ("FTQ", "cubic foot", "ft³", "01"),
  FW("FW", "Cart, flatbed", null, null),
  FX("FX", "Bag, flexible container", null, null),
  G01("G01", "pascal cubic metre per second", "Pa·m³/s", "03"),
  G04("G04", "centimetre per bar", "cm/bar", "01"),
  G05("G05", "metre per bar", "m/bar", "01"),
  G06("G06", "millimetre per bar", "mm/bar", "01"),
  G08("G08", "square inch per second", "in²/s", "03"),
  G09("G09", "square metre per second kelvin", "m²/(s·K)", "03"),
  G10("G10", "stokes per kelvin", "St/K", "03"),
  G11("G11", "gram per cubic centimetre bar", "g/(cm³·bar)", "03"),
  G12("G12", "gram per cubic decimetre bar", "g/(dm³·bar)", "03"),
  G13("G13", "gram per litre bar", "g/(l·bar)", "03"),
  G14("G14", "gram per cubic metre bar", "g/(m³·bar)", "03"),
  G15("G15", "gram per millilitre bar", "g/(ml·bar)", "03"),
  G16("G16", "kilogram per cubic centimetre bar", "kg/(cm³·bar)", "03"),
  G17("G17", "kilogram per litre bar", "kg/(l·bar)", "03"),
  G18("G18", "kilogram per cubic metre bar", "kg/(m³·bar)", "03"),
  G19("G19", "newton metre per kilogram", "N·m/kg", "03"),
  G2("G2", "US gallon per minute", "gal (US) /min", "03"),
  G20("G20", "pound-force foot per pound", "lbf·ft/lb", "03"),
  G21("G21", "cup [unit of volume]", "cup (US)", "01"),
  G23("G23", "peck", "pk (US)", "01"),
  G24("G24", "tablespoon (US)", "tablespoon (US)", "01"),
  G25("G25", "teaspoon (US)", "teaspoon (US)", "01"),
  G26("G26", "stere", "st", "01"),
  G27("G27", "cubic centimetre per kelvin", "cm³/K", "01"),
  G28("G28", "litre per kelvin", "l/K", "01"),
  G29("G29", "cubic metre per kelvin", "m³/K", "01"),
  G3("G3", "Imperial gallon per minute", "gal (UK) /min", "03"),
  G30("G30", "millilitre per kelvin", "ml/K", "01"),
  G31("G31", "kilogram per cubic centimetre", "kg/cm³", "03"),
  G32("G32", "ounce (avoirdupois) per cubic yard", "oz/yd³", "03"),
  G33("G33", "gram per cubic centimetre kelvin", "g/(cm³·K)", "03"),
  G34("G34", "gram per cubic decimetre kelvin", "g/(dm³·K)", "03"),
  G35("G35", "gram per litre kelvin", "g/(l·K)", "03"),
  G36("G36", "gram per cubic metre kelvin", "g/(m³·K)", "03"),
  G37("G37", "gram per millilitre kelvin", "g/(ml·K)", "03"),
  G38("G38", "kilogram per cubic centimetre kelvin", "kg/(cm³·K)", "03"),
  G39("G39", "kilogram per litre kelvin", "kg/(l·K)", "03"),
  G40("G40", "kilogram per cubic metre kelvin", "kg/(m³·K)", "03"),
  G41("G41", "square metre per second bar", "m²/(s·bar)", "03"),
  G42("G42", "microsiemens per centimetre", "µS/cm", "05"),
  G43("G43", "microsiemens per metre", "µS/m", "05"),
  G44("G44", "nanosiemens per centimetre", "nS/cm", "05"),
  G45("G45", "nanosiemens per metre", "nS/m", "05"),
  G46("G46", "stokes per bar", "St/bar", "03"),
  G47("G47", "cubic centimetre per day", "cm³/d", "03"),
  G48("G48", "cubic centimetre per hour", "cm³/h", "03"),
  G49("G49", "cubic centimetre per minute", "cm³/min", "03"),
  G50("G50", "gallon (US) per hour", "gal/h", "03"),
  G51("G51", "litre per second", "l/s", "03"),
  G52("G52", "cubic metre per day", "m³/d", "03"),
  G53("G53", "cubic metre per minute", "m³/min", "03"),
  G54("G54", "millilitre per day", "ml/d", "03"),
  G55("G55", "millilitre per hour", "ml/h", "03"),
  G56("G56", "cubic inch per hour", "in³/h", "03"),
  G57("G57", "cubic inch per minute", "in³/min", "03"),
  G58("G58", "cubic inch per second", "in³/s", "03"),
  G59("G59", "milliampere per litre minute", "mA/(l·min)", "05"),
  G60("G60", "volt per bar", "V/bar", "05"),
  G61("G61", "cubic centimetre per day kelvin", "cm³/(d·K)", "03"),
  G62("G62", "cubic centimetre per hour kelvin", "cm³/(h·K)", "03"),
  G63("G63", "cubic centimetre per minute kelvin", "cm³/(min·K)", "03"),
  G64("G64", "cubic centimetre per second kelvin", "cm³/(s·K)", "03"),
  G65("G65", "litre per day kelvin", "l/(d·K)", "03"),
  G66("G66", "litre per hour kelvin", "l/(h·K)", "03"),
  G67("G67", "litre per minute kelvin", "l/(min·K)", "03"),
  G68("G68", "litre per second kelvin", "l/(s·K)", "03"),
  G69("G69", "cubic metre per day kelvin", "m³/(d·K)", "03"),
  G70("G70", "cubic metre per hour kelvin", "m³/(h·K)", "03"),
  G71("G71", "cubic metre per minute kelvin", "m³/(min·K)", "03"),
  G72("G72", "cubic metre per second kelvin", "m³/(s·K)", "03"),
  G73("G73", "millilitre per day kelvin", "ml/(d·K)", "03"),
  G74("G74", "millilitre per hour kelvin", "ml/(h·K)", "03"),
  G75("G75", "millilitre per minute kelvin", "ml/(min·K)", "03"),
  G76("G76", "millilitre per second kelvin", "ml/(s·K)", "03"),
  G77("G77", "millimetre to the fourth power", "mm⁴", "03"),
  G78("G78", "cubic centimetre per day bar", "cm³/(d·bar)", "03"),
  G79("G79", "cubic centimetre per hour bar", "cm³/(h·bar)", "03"),
  G80("G80", "cubic centimetre per minute bar", "cm³/(min·bar)", "03"),
  G81("G81", "cubic centimetre per second bar", "cm³/(s·bar)", "03"),
  G82("G82", "litre per day bar", "l/(d·bar)", "03"),
  G83("G83", "litre per hour bar", "l/(h·bar)", "03"),
  G84("G84", "litre per minute bar", "l/(min·bar)", "03"),
  G85("G85", "litre per second bar", "l/(s·bar)", "03"),
  G86("G86", "cubic metre per day bar", "m³/(d·bar)", "03"),
  G87("G87", "cubic metre per hour bar", "m³/(h·bar)", "03"),
  G88("G88", "cubic metre per minute bar", "m³/(min·bar)", "03"),
  G89("G89", "cubic metre per second bar", "m³/(s·bar)", "03"),
  G90("G90", "millilitre per day bar", "ml/(d·bar)", "03"),
  G91("G91", "millilitre per hour bar", "ml/(h·bar)", "03"),
  G92("G92", "millilitre per minute bar", "ml/(min·bar)", "03"),
  G93("G93", "millilitre per second bar", "ml/(s·bar)", "03"),
  G94("G94", "cubic centimetre per bar", "cm³/bar", "01"),
  G95("G95", "litre per bar", "l/bar", "01"),
  G96("G96", "cubic metre per bar", "m³/bar", "01"),
  G97("G97", "millilitre per bar", "ml/bar", "01"),
  G98("G98", "microhenry per kiloohm", "µH/kΩ", "05"),
  G99("G99", "microhenry per ohm", "µH/Ω", "05"),
  GB("GB", "gallon (US) per day", "gal (US)/d", "3.5"),
  GBQ("GBQ", "gigabecquerel", "GBq", "09"),
  GDW("GDW", "gram, dry weight", null, "3.1"),
  GE("GE", "pound per gallon (US)", "lb/gal (US)", "03"),
  GF("GF", "gram per metre (gram per 100 centimetres)", "g/m", "03"),
  GFI("GFI", "gram of fissile isotope", "gi F/S", "3.1"),
  GGR("GGR", "great gross", null, "3.7"),
  GI("GI", "Girder", null, null),
  GIA("GIA", "gill (US)", "gi (US)", "3.5"),
  GIC("GIC", "gram, including container", null, "3.1"),
  GII("GII", "gill (UK)", "gi (UK)", "3.5"),
  GIP("GIP", "gram, including inner packaging", null, "3.1"),
  GJ("GJ", "gram per millilitre", "g/ml", "03"),
  GL("GL", "gram per litre", "g/l", "03"),
  GLD("GLD", "dry gallon (US)", "dry gal (US)", "01"),
  GLI("GLI", "gallon (UK)", "gal (UK)", "01"),
  GLL("GLL", "gallon (US)", "gal (US)", "01"),
  GM("GM", "gram per square metre", "g/m²", "03"),
  GO("GO", "milligram per square metre", "mg/m²", "03"),
  GP("GP", "milligram per cubic metre", "mg/m³", "03"),
  GQ("GQ", "microgram per cubic metre", "µg/m³", "03"),
  GR("GR", "Receptacle, glass", null, null),
  GRM("GRM", "gram", "g", "03"),
  GRN("GRN", "grain", "gr", "03"),
  GRO("GRO", "gross", "gr", "3.7"),
  GU("GU", "Tray, containing horizontally stacked flat items", null, null),
  GV("GV", "gigajoule", "GJ", "03"),
  GWH("GWH", "gigawatt hour", "GW·h", "03"),
  GY("GY", "Bag, gunny", null, null),
  GZ("GZ", "Girders, in bundle/bunch/truss", null, null),
  H03("H03", "henry per kiloohm", "H/kΩ", "05"),
  H04("H04", "henry per ohm", "H/Ω", "05"),
  H05("H05", "millihenry per kiloohm", "mH/kΩ", "05"),
  H06("H06", "millihenry per ohm", "mH/Ω", "05"),
  H07("H07", "pascal second per bar", "Pa·s/bar", "03"),
  H08("H08", "microbecquerel", "µBq", "09"),
  H09("H09", "reciprocal year", "1/y", "02"),
  H10("H10", "reciprocal hour", "1/h", "02"),
  H11("H11", "reciprocal month", "1/mo", "02"),
  H12("H12", "degree Celsius per hour", "°C/h", "04"),
  H13("H13", "degree Celsius per minute", "°C/min", "04"),
  H14("H14", "degree Celsius per second", "°C/s", "04"),
  H15("H15", "square centimetre per gram", "cm²/g", "03"),
  H16("H16", "square decametre", "dam²", "01"),
  H18("H18", "square hectometre", "hm²", "01"),
  H19("H19", "cubic hectometre", "hm³", "01"),
  H20("H20", "cubic kilometre", "km³", "01"),
  H21("H21", "blank", null, "3.2"),
  H22("H22", "volt square inch per pound-force", "V/(lbf/in²)", "05"),
  H23("H23", "volt per inch", "V/in", "05"),
  H24("H24", "volt per microsecond", "V/µs", "05"),
  H25("H25", "percent per kelvin", "%/K", "3.7"),
  H26("H26", "ohm per metre", "Ω/m", "05"),
  H27("H27", "degree per metre", "°/m", "01"),
  H28("H28", "microfarad per kilometre", "µF/km", "05"),
  H29("H29", "microgram per litre", "µg/l", "03"),
  H30("H30", "square micrometre (square micron)", "µm²", "01"),
  H31("H31", "ampere per kilogram", "A/kg", "05"),
  H32("H32", "ampere squared second", "A²·s", "05"),
  H33("H33", "farad per kilometre", "F/km", "05"),
  H34("H34", "hertz metre", "Hz·m", "05"),
  H35("H35", "kelvin metre per watt", "K·m/W", "04"),
  H36("H36", "megaohm per kilometre", "MΩ/km", "05"),
  H37("H37", "megaohm per metre", "MΩ/m", "05"),
  H38("H38", "megaampere", "MA", "05"),
  H39("H39", "megahertz kilometre", "MHz·km", "05"),
  H40("H40", "newton per ampere", "N/A", "03"),
  H41("H41", "newton metre watt to the power minus 0,5", "N·m·W⁻⁰‧⁵", "03"),
  H42("H42", "pascal per metre", "Pa/m", "13"),
  H43("H43", "siemens per centimetre", "S/cm", "05"),
  H44("H44", "teraohm", "TΩ", "05"),
  H45("H45", "volt second per metre", "V·s/m", "05"),
  H46("H46", "volt per second", "V/s", "05"),
  H47("H47", "watt per cubic metre", "W/m³", "06"),
  H48("H48", "attofarad", "aF", "05"),
  H49("H49", "centimetre per hour", "cm/h", "01"),
  H50("H50", "reciprocal cubic centimetre", "cm⁻³", "08"),
  H51("H51", "decibel per kilometre", "dB/km", "07"),
  H52("H52", "decibel per metre", "dB/m", "07"),
  H53("H53", "kilogram per bar", "kg/bar", "03"),
  H54("H54", "kilogram per cubic decimetre kelvin", "(kg/dm³)/K", "03"),
  H55("H55", "kilogram per cubic decimetre bar", "(kg/dm³)/bar", "03"),
  H56("H56", "kilogram per square metre second", "kg/(m²·s)", "03"),
  H57("H57", "inch per two pi radiant", "in/revolution", "01"),
  H58("H58", "metre per volt second", "m/(V·s)", "10"),
  H59("H59", "square metre per newton", "m²/N", "01"),
  H60("H60", "cubic metre per cubic metre", "m³/m³", "03"),
  H61("H61", "millisiemens per centimetre", "mS/cm", "05"),
  H62("H62", "millivolt per minute", "mV/min", "05"),
  H63("H63", "milligram per square centimetre", "mg/cm²", "03"),
  H64("H64", "milligram per gram", "mg/g", "03"),
  H65("H65", "millilitre per cubic metre", "ml/m³", "03"),
  H66("H66", "millimetre per year", "mm/y", "01"),
  H67("H67", "millimetre per hour", "mm/h", "01"),
  H68("H68", "millimole per gram", "mmol/g", "08"),
  H69("H69", "picopascal per kilometre", "pPa/km", "13"),
  H70("H70", "picosecond", "ps", "01"),
  H71("H71", "percent per month", "%/mo", "3.7"),
  H72("H72", "percent per hectobar", "%/hbar", "3.7"),
  H73("H73", "percent per decakelvin", "%/daK", "3.7"),
  H74("H74", "watt per metre", "W/m", "06"),
  H75("H75", "decapascal", "daPa", "03"),
  H76("H76", "gram per millimetre", "g/mm", "03"),
  H77("H77", "module width", "MW", "3"),
  H79("H79", "French gauge", "Fg", "01"),
  H80("H80", "rack unit", "U or RU", "3"),
  H81("H81", "millimetre per minute", "mm/min", "01"),
  H82("H82", "big point", "bp", "3.5"),
  H83("H83", "litre per kilogram", "l/kg", "03"),
  H84("H84", "gram millimetre", "g·mm", "01"),
  H85("H85", "reciprocal week", "1/wk", "02"),
  H87("H87", "piece", null, "3.8"),
  H88("H88", "megaohm kilometre", "MΩ·km", "05"),
  H89("H89", "percent per ohm", "%/Ω", "3.7"),
  H90("H90", "percent per degree", "%/°", "3.7"),
  H91("H91", "percent per ten thousand", "%/10000", "3.7"),
  H92("H92", "percent per one hundred thousand", "%/100000", "3.7"),
  H93("H93", "percent per hundred", "%/100", "3.7"),
  H94("H94", "percent per thousand", "%/1000", "3.7"),
  H95("H95", "percent per volt", "%/V", "3.7"),
  H96("H96", "percent per bar", "%/bar", "3.7"),
  H98("H98", "percent per inch", "%/in", "3.7"),
  H99("H99", "percent per metre", "%/m", "3.7"),
  HA("HA", "hank", null, "3.9"),
  HAD("HAD", "Piece Day", "piece·d", "3"),
  HB("HB", "Basket, with handle, wooden", null, null),
  HBA("HBA", "hectobar", "hbar", "03"),
  HBX("HBX", "hundred boxes", null, "3.2"),
  HC("HC", "hundred count", null, "3.7"),
  HDW("HDW", "hundred kilogram, dry weight", null, "3.1"),
  HEA("HEA", "head", null, "3.5"),
  HG("HG", "Hogshead", null, null),
  HGM("HGM", "hectogram", "hg", "03"),
  HH("HH", "hundred cubic foot", null, "3.8"),
  HIU("HIU", "hundred international unit", null, "3.7"),
  HKM("HKM", "hundred kilogram, net mass", null, "3.1"),
  HLT("HLT", "hectolitre", "hl", "01"),
  HM("HM", "mile per hour (statute mile)", "mile/h", "01"),
  HMO("HMO", "Piece Month", "piece·mo", "3"),
  HMQ("HMQ", "million cubic metre", "Mm³", "3.8"),
  HMT("HMT", "hectometre", "hm", "01"),
  HN("HN", "Hanger", null, null),
  HPA("HPA", "hectolitre of pure alcohol", null, "3.1"),
  HR("HR", "Hamper", null, null),
  HTZ("HTZ", "hertz", "Hz", "02"),
  HUR("HUR", "hour", "h", "01"),
  HWE("HWE", "Piece Week", "piece·k", "3"),
  IA("IA", "inch pound (pound inch)", "in·lb", "03"),
  IB("IB", "Package, display, cardboard", null, null),
  IC("IC", "Package, display, plastic", null, null),
  ID("ID", "Package, display, metal", null, null),
  IE("IE", "person", null, "3.9"),
  IF("IF", "Package, flow", null, null),
  IG("IG", "Package, paper wrapped", null, null),
  IH("IH", "Drum, plastic", null, null),
  IK("IK", "Package, cardboard, with bottle grip-holes", null, null),
  IL("IL", "Tray, rigid, lidded stackable (CEN TS 14482:2002)", null, null),
  IN("IN", "Ingot", null, null),
  INH("INH", "inch", "in", "01"),
  INK("INK", "square inch", "in²", "01"),
  INQ("INQ", "cubic inch", "in³", "01"),
  ISD("ISD", "international sugar degree", null, "3.5"),
  IU("IU", "inch per second", "in/s", "01"),
  IUG("IUG", "international unit per gram", null, "3.7"),
  IV("IV", "inch per second squared", "in/s²", "01"),
  IZ("IZ", "Ingots, in bundle/bunch/truss", null, null),
  J10("J10", "percent per millimetre", "%/mm", "3.7"),
  J12("J12", "per mille per psi", "‰/psi", "3.7"),
  J13("J13", "degree API", "°API", "3.5"),
  J14("J14", "degree Baume (origin scale)", "°Bé", "3.5"),
  J15("J15", "degree Baume (US heavy)", "°Bé (US heavy)", "3.5"),
  J16("J16", "degree Baume (US light)", "°Bé (US light)", "3.5"),
  J17("J17", "degree Balling", "°Balling", "3.5"),
  J18("J18", "degree Brix", "°Bx", "3.5"),
  J19("J19", "degree Fahrenheit hour square foot per British thermal unit (thermochemical)", "°F·h·ft²/Btuth", "04"),
  J2("J2", "joule per kilogram", "J/kg", "04"),
  J20("J20", "degree Fahrenheit per kelvin", "°F/K", "04"),
  J21("J21", "degree Fahrenheit per bar", "°F/bar", "04"),
  J22("J22", "degree Fahrenheit hour square foot per British thermal unit (international table)", "°F·h·ft²/BtuIT", "04"),
  J23("J23", "degree Fahrenheit per hour", "°F/h", "04"),
  J24("J24", "degree Fahrenheit per minute", "°F/min", "04"),
  J25("J25", "degree Fahrenheit per second", "°F/s", "04"),
  J26("J26", "reciprocal degree Fahrenheit", "1/°F", "04"),
  J27("J27", "degree Oechsle", "°Oechsle", "3.5"),
  J28("J28", "degree Rankine per hour", "°R/h", "04"),
  J29("J29", "degree Rankine per minute", "°R/min", "04"),
  J30("J30", "degree Rankine per second", "°R/s", "04"),
  J31("J31", "degree Twaddell", "°Tw", "3.5"),
  J32("J32", "micropoise", "µP", "03"),
  J33("J33", "microgram per kilogram", "µg/kg", "03"),
  J34("J34", "microgram per cubic metre kelvin", "(µg/m³)/K", "03"),
  J35("J35", "microgram per cubic metre bar", "(µg/m³)/bar", "03"),
  J36("J36", "microlitre per litre", "µl/l", "01"),
  J38("J38", "baud", "Bd", "3.6"),
  J39("J39", "British thermal unit (mean)", "Btu", "04"),
  J40("J40", "British thermal unit (international table) foot per hour square foot degree Fahrenheit", "BtuIT·ft/(h·ft²·°F)", "04"),
  J41("J41", "British thermal unit (international table) inch per hour square foot degree Fahrenheit", "BtuIT·in/(h·ft²·°F)", "04"),
  J42("J42", "British thermal unit (international table) inch per second square foot degree Fahrenheit", "BtuIT·in/(s·ft²·°F)", "04"),
  J43("J43", "British thermal unit (international table) per pound degree Fahrenheit", "BtuIT/(lb·°F)", "04"),
  J44("J44", "British thermal unit (international table) per minute", "BtuIT/min", "04"),
  J45("J45", "British thermal unit (international table) per second", "BtuIT/s", "04"),
  J46("J46", "British thermal unit (thermochemical) foot per hour square foot degree Fahrenheit", "Btuth·ft/(h·ft²·°F)", "04"),
  J47("J47", "British thermal unit (thermochemical) per hour", "Btuth/h", "04"),
  J48("J48", "British thermal unit (thermochemical) inch per hour square foot degree Fahrenheit", "Btuth·in/(h·ft²·°F)", "04"),
  J49("J49", "British thermal unit (thermochemical) inch per second square foot degree Fahrenheit", "Btuth·in/(s·ft²·°F)", "04"),
  J50("J50", "British thermal unit (thermochemical) per pound degree Fahrenheit", "Btuth/(lb·°F)", "04"),
  J51("J51", "British thermal unit (thermochemical) per minute", "Btuth/min", "04"),
  J52("J52", "British thermal unit (thermochemical) per second", "Btuth/s", "04"),
  J53("J53", "coulomb square metre per kilogram", "C·m²/kg", "10"),
  J54("J54", "megabaud", "MBd", "3.6"),
  J55("J55", "watt second", "W·s", "04"),
  J56("J56", "bar per bar", "bar/bar", "03"),
  J57("J57", "barrel (UK petroleum)", "bbl (UK liq.)", "01"),
  J58("J58", "barrel (UK petroleum) per minute", "bbl (UK liq.)/min", "03"),
  J59("J59", "barrel (UK petroleum) per day", "bbl (UK liq.)/d", "03"),
  J60("J60", "barrel (UK petroleum) per hour", "bbl (UK liq.)/h", "03"),
  J61("J61", "barrel (UK petroleum) per second", "bbl (UK liq.)/s", "03"),
  J62("J62", "barrel (US petroleum) per hour", "bbl (US)/h", "03"),
  J63("J63", "barrel (US petroleum) per second", "bbl (US)/s", "03"),
  J64("J64", "bushel (UK) per day", "bu (UK)/d", "03"),
  J65("J65", "bushel (UK) per hour", "bu (UK)/h", "03"),
  J66("J66", "bushel (UK) per minute", "bu (UK)/min", "03"),
  J67("J67", "bushel (UK) per second", "bu (UK)/s", "03"),
  J68("J68", "bushel (US dry) per day", "bu (US dry)/d", "03"),
  J69("J69", "bushel (US dry) per hour", "bu (US dry)/h", "03"),
  J70("J70", "bushel (US dry) per minute", "bu (US dry)/min", "03"),
  J71("J71", "bushel (US dry) per second", "bu (US dry)/s", "03"),
  J72("J72", "centinewton metre", "cN·m", "03"),
  J73("J73", "centipoise per kelvin", "cP/K", "03"),
  J74("J74", "centipoise per bar", "cP/bar", "03"),
  J75("J75", "calorie (mean)", "cal", "04"),
  J76("J76", "calorie (international table) per gram degree Celsius", "calIT/(g·°C)", "04"),
  J78("J78", "calorie (thermochemical) per centimetre second degree Celsius", "calth/(cm·s·°C)", "04"),
  J79("J79", "calorie (thermochemical) per gram degree Celsius", "calth/(g·°C)", "04"),
  J81("J81", "calorie (thermochemical) per minute", "calth/min", "04"),
  J82("J82", "calorie (thermochemical) per second", "calth/s", "04"),
  J83("J83", "clo", "clo", "04"),
  J84("J84", "centimetre per second kelvin", "(cm/s)/K", "01"),
  J85("J85", "centimetre per second bar", "(cm/s)/bar", "01"),
  J87("J87", "cubic centimetre per cubic metre", "cm³/m³", "01"),
  J90("J90", "cubic decimetre per day", "dm³/d", "03"),
  J91("J91", "cubic decimetre per cubic metre", "dm³/m³", "01"),
  J92("J92", "cubic decimetre per minute", "dm³/min", "03"),
  J93("J93", "cubic decimetre per second", "dm³/s", "03"),
  J95("J95", "ounce (UK fluid) per day", "fl oz (UK)/d", "03"),
  J96("J96", "ounce (UK fluid) per hour", "fl oz (UK)/h", "03"),
  J97("J97", "ounce (UK fluid) per minute", "fl oz (UK)/min", "03"),
  J98("J98", "ounce (UK fluid) per second", "fl oz (UK)/s", "03"),
  J99("J99", "ounce (US fluid) per day", "fl oz (US)/d", "03"),
  JB("JB", "Bag, jumbo", null, null),
  JC("JC", "Jerrican, rectangular", null, null),
  JE("JE", "joule per kelvin", "J/K", "04"),
  JG("JG", "Jug", null, null),
  JK("JK", "megajoule per kilogram", "MJ/kg", "04"),
  JM("JM", "megajoule per cubic metre", "MJ/m³", "06"),
  JNT("JNT", "pipeline joint", null, "3.5"),
  JOU("JOU", "joule", "J", "03"),
  JPS("JPS", "hundred metre", null, "3.1"),
  JR("JR", "Jar", null, null),
  JT("JT", "Jutebag", null, null),
  JWL("JWL", "number of jewels", null, "3.7"),
  JY("JY", "Jerrican, cylindrical", null, null),
  K1("K1", "kilowatt demand", null, "3.5"),
  K10("K10", "ounce (US fluid) per hour", "fl oz (US)/h", "03"),
  K11("K11", "ounce (US fluid) per minute", "fl oz (US)/min", "03"),
  K12("K12", "ounce (US fluid) per second", "fl oz (US)/s", "03"),
  K13("K13", "foot per degree Fahrenheit", "ft/°F", "01"),
  K14("K14", "foot per hour", "ft/h", "01"),
  K15("K15", "foot pound-force per hour", "ft·lbf/h", "03"),
  K16("K16", "foot pound-force per minute", "ft·lbf/min", "03"),
  K17("K17", "foot per psi", "ft/psi", "01"),
  K18("K18", "foot per second degree Fahrenheit", "(ft/s)/°F", "01"),
  K19("K19", "foot per second psi", "(ft/s)/psi", "01"),
  K2("K2", "kilovolt ampere reactive demand", null, "3.5"),
  K20("K20", "reciprocal cubic foot", "1/ft³", "08"),
  K21("K21", "cubic foot per degree Fahrenheit", "ft³/°F", "01"),
  K22("K22", "cubic foot per day", "ft³/d", "03"),
  K23("K23", "cubic foot per psi", "ft³/psi", "01"),
  K26("K26", "gallon (UK) per day", "gal (UK)/d", "03"),
  K27("K27", "gallon (UK) per hour", "gal (UK)/h", "03"),
  K28("K28", "gallon (UK) per second", "gal (UK)/s", "03"),
  K3("K3", "kilovolt ampere reactive hour", "kvar·h", "3.5"),
  K30("K30", "gallon (US liquid) per second", "gal (US liq.)/s", "03"),
  K31("K31", "gram-force per square centimetre", "gf/cm²", "03"),
  K32("K32", "gill (UK) per day", "gi (UK)/d", "03"),
  K33("K33", "gill (UK) per hour", "gi (UK)/h", "03"),
  K34("K34", "gill (UK) per minute", "gi (UK)/min", "03"),
  K35("K35", "gill (UK) per second", "gi (UK)/s", "03"),
  K36("K36", "gill (US) per day", "gi (US)/d", "03"),
  K37("K37", "gill (US) per hour", "gi (US)/h", "03"),
  K38("K38", "gill (US) per minute", "gi (US)/min", "03"),
  K39("K39", "gill (US) per second", "gi (US)/s", "03"),
  K40("K40", "standard acceleration of free fall", "gn", "01"),
  K41("K41", "grain per gallon (US)", "gr/gal (US)", "03"),
  K42("K42", "horsepower (boiler)", "boiler hp", "03"),
  K43("K43", "horsepower (electric)", "electric hp", "05"),
  K45("K45", "inch per degree Fahrenheit", "in/°F", "01"),
  K46("K46", "inch per psi", "in/psi", "01"),
  K47("K47", "inch per second degree Fahrenheit", "(in/s)/°F", "01"),
  K48("K48", "inch per second psi", "(in/s)/psi", "01"),
  K49("K49", "reciprocal cubic inch", "1/in³", "08"),
  K50("K50", "kilobaud", "kBd", "3.6"),
  K51("K51", "kilocalorie (mean)", "kcal", "04"),
  K52("K52", "kilocalorie (international table) per hour metre degree Celsius", "kcal/(m·h·°C)", "04"),
  K53("K53", "kilocalorie (thermochemical)", "kcalth", "04"),
  K54("K54", "kilocalorie (thermochemical) per minute", "kcalth/min", "04"),
  K55("K55", "kilocalorie (thermochemical) per second", "kcalth/s", "04"),
  K58("K58", "kilomole per hour", "kmol/h", "08"),
  K59("K59", "kilomole per cubic metre kelvin", "(kmol/m³)/K", "08"),
  K6("K6", "kilolitre", "kl", "01"),
  K60("K60", "kilomole per cubic metre bar", "(kmol/m³)/bar", "08"),
  K61("K61", "kilomole per minute", "kmol/min", "08"),
  K62("K62", "litre per litre", "l/l", "01"),
  K63("K63", "reciprocal litre", "1/l", "08"),
  K64("K64", "pound (avoirdupois) per degree Fahrenheit", "lb/°F", "03"),
  K65("K65", "pound (avoirdupois) square foot", "lb·ft²", "03"),
  K66("K66", "pound (avoirdupois) per day", "lb/d", "03"),
  K67("K67", "pound per foot hour", "lb/(ft·h)", "03"),
  K68("K68", "pound per foot second", "lb/(ft·s)", "03"),
  K69("K69", "pound (avoirdupois) per cubic foot degree Fahrenheit", "(lb/ft³)/°F", "03"),
  K70("K70", "pound (avoirdupois) per cubic foot psi", "(lb/ft³)/psi", "03"),
  K71("K71", "pound (avoirdupois) per gallon (UK)", "lb/gal (UK)", "03"),
  K73("K73", "pound (avoirdupois) per hour degree Fahrenheit", "(lb/h)/°F", "03"),
  K74("K74", "pound (avoirdupois) per hour psi", "(lb/h)/psi", "03"),
  K75("K75", "pound (avoirdupois) per cubic inch degree Fahrenheit", "(lb/in³)/°F", "03"),
  K76("K76", "pound (avoirdupois) per cubic inch psi", "(lb/in³)/psi", "03"),
  K77("K77", "pound (avoirdupois) per psi", "lb/psi", "03"),
  K78("K78", "pound (avoirdupois) per minute", "lb/min", "03"),
  K79("K79", "pound (avoirdupois) per minute degree Fahrenheit", "lb/(min·°F)", "03"),
  K80("K80", "pound (avoirdupois) per minute psi", "(lb/min)/psi", "03"),
  K81("K81", "pound (avoirdupois) per second", "lb/s", "03"),
  K82("K82", "pound (avoirdupois) per second degree Fahrenheit", "(lb/s)/°F", "03"),
  K83("K83", "pound (avoirdupois) per second psi", "(lb/s)/psi", "03"),
  K84("K84", "pound per cubic yard", "lb/yd³", "03"),
  K85("K85", "pound-force per square foot", "lbf/ft²", "03"),
  K86("K86", "pound-force per square inch degree Fahrenheit", "psi/°F", "03"),
  K87("K87", "psi cubic inch per second", "psi·in³/s", "03"),
  K88("K88", "psi litre per second", "psi·l/s", "03"),
  K89("K89", "psi cubic metre per second", "psi·m³/s", "03"),
  K90("K90", "psi cubic yard per second", "psi·yd³/s", "03"),
  K91("K91", "pound-force second per square foot", "lbf·s/ft²", "03"),
  K92("K92", "pound-force second per square inch", "lbf·s/in²", "03"),
  K93("K93", "reciprocal psi", "1/psi", "08"),
  K94("K94", "quart (UK liquid) per day", "qt (UK liq.)/d", "03"),
  K95("K95", "quart (UK liquid) per hour", "qt (UK liq.)/h", "03"),
  K96("K96", "quart (UK liquid) per minute", "qt (UK liq.)/min", "03"),
  K97("K97", "quart (UK liquid) per second", "qt (UK liq.)/s", "03"),
  K98("K98", "quart (US liquid) per day", "qt (US liq.)/d", "03"),
  K99("K99", "quart (US liquid) per hour", "qt (US liq.)/h", "03"),
  KA("KA", "cake", null, "3.9"),
  KAT("KAT", "katal", "kat", "08"),
  KB("KB", "kilocharacter", null, "3.9"),
  KBA("KBA", "kilobar", "kbar", "03"),
  KCC("KCC", "kilogram of choline chloride", "kg C₅ H₁₄ClNO", "3.1"),
  KDW("KDW", "kilogram drained net weight", "kg/net eda", "3.1"),
  KEL("KEL", "kelvin", "K", "04"),
  KG("KG", "Keg", null, null),
  KGM("KGM", "kilogram", "kg", "03"),
  KGS("KGS", "kilogram per second", "kg/s", "03"),
  KHY("KHY", "kilogram of hydrogen peroxide", "kg H₂O₂", "3.1"),
  KHZ("KHZ", "kilohertz", "kHz", "02"),
  KI("KI", "kilogram per millimetre width", null, "3.1"),
  KIC("KIC", "kilogram, including container", null, "3.1"),
  KIP("KIP", "kilogram, including inner packaging", null, "3.1"),
  KJ("KJ", "kilosegment", null, "3.6"),
  KJO("KJO", "kilojoule", "kJ", "03"),
  KL("KL", "kilogram per metre", "kg/m", "03"),
  KLK("KLK", "lactic dry material percentage", null, "3.5"),
  KLX("KLX", "kilolux", "klx", "06"),
  KMA("KMA", "kilogram of methylamine", "kg met.am.", "3.1"),
  KMH("KMH", "kilometre per hour", "km/h", "01"),
  KMK("KMK", "square kilometre", "km²", "01"),
  KMQ("KMQ", "kilogram per cubic metre", "kg/m³", "03"),
  KMT("KMT", "kilometre", "km", "01"),
  KNI("KNI", "kilogram of nitrogen", "kg N", "3.1"),
  KNM("KNM", "kilonewton per square metre", "KN/m2", "03"),
  KNS("KNS", "kilogram named substance", null, "3.1"),
  KNT("KNT", "knot", "kn", "01"),
  KO("KO", "milliequivalence caustic potash per gram of product", null, "3.9"),
  KPA("KPA", "kilopascal", "kPa", "03"),
  KPH("KPH", "kilogram of potassium hydroxide (caustic potash)", "kg KOH", "3.1"),
  KPO("KPO", "kilogram of potassium oxide", "kg K₂O", "3.1"),
  KPP("KPP", "kilogram of phosphorus pentoxide (phosphoric anhydride)", null, "3.1"),
  KR("KR", "kiloroentgen", "kR", "10"),
  KSD("KSD", "kilogram of substance 90 % dry", "kg 90 % sdt", "3.1"),
  KSH("KSH", "kilogram of sodium hydroxide (caustic soda)", "kg NaOH", "3.1"),
  KT("KT", "kit", null, "3.2"),
  KTN("KTN", "kilotonne", "kt", "03"),
  KUR("KUR", "kilogram of uranium", "kg U", "3.1"),
  KVA("KVA", "kilovolt - ampere", "kV·A", "05"),
  KVR("KVR", "kilovar", "kvar", "05"),
  KVT("KVT", "kilovolt", "kV", "05"),
  KW("KW", "kilogram per millimetre", "kg/mm", "03"),
  KWH("KWH", "kilowatt hour", "kW·h", "03"),
  KWN("KWN", "Kilowatt hour per normalized cubic metre", null, "03"),
  KWO("KWO", "kilogram of tungsten trioxide", "kg WO₃", "3.1"),
  KWS("KWS", "Kilowatt hour per standard cubic metre", null, "03"),
  KWT("KWT", "kilowatt", "kW", "03"),
  KWY("KWY", "kilowatt year", "kW/year", "2"),
  KX("KX", "millilitre per kilogram", "ml/kg", "03"),
  L10("L10", "quart (US liquid) per minute", "qt (US liq.)/min", "03"),
  L11("L11", "quart (US liquid) per second", "qt (US liq.)/s", "03"),
  L12("L12", "metre per second kelvin", "(m/s)/K", "01"),
  L13("L13", "metre per second bar", "(m/s)/bar", "01"),
  L14("L14", "square metre hour degree Celsius per kilocalorie (international table)", "m²·h·°C/kcal", "04"),
  L15("L15", "millipascal second per kelvin", "mPa·s/K", "03"),
  L16("L16", "millipascal second per bar", "mPa·s/bar", "03"),
  L17("L17", "milligram per cubic metre kelvin", "(mg/m³)/K", "03"),
  L18("L18", "milligram per cubic metre bar", "(mg/m³)/bar", "03"),
  L19("L19", "millilitre per litre", "ml/l", "01"),
  L2("L2", "litre per minute", "l/min", "03"),
  L20("L20", "reciprocal cubic millimetre", "1/mm³", "08"),
  L21("L21", "cubic millimetre per cubic metre", "mm³/m³", "01"),
  L23("L23", "mole per hour", "mol/h", "08"),
  L24("L24", "mole per kilogram kelvin", "(mol/kg)/K", "08"),
  L25("L25", "mole per kilogram bar", "(mol/kg)/bar", "08"),
  L26("L26", "mole per litre kelvin", "(mol/l)/K", "08"),
  L27("L27", "mole per litre bar", "(mol/l)/bar", "08"),
  L28("L28", "mole per cubic metre kelvin", "(mol/m³)/K", "08"),
  L29("L29", "mole per cubic metre bar", "(mol/m³)/bar", "08"),
  L30("L30", "mole per minute", "mol/min", "08"),
  L31("L31", "milliroentgen aequivalent men", "mrem", "10"),
  L32("L32", "nanogram per kilogram", "ng/kg", "03"),
  L33("L33", "ounce (avoirdupois) per day", "oz/d", "03"),
  L34("L34", "ounce (avoirdupois) per hour", "oz/h", "03"),
  L35("L35", "ounce (avoirdupois) per minute", "oz/min", "03"),
  L36("L36", "ounce (avoirdupois) per second", "oz/s", "03"),
  L37("L37", "ounce (avoirdupois) per gallon (UK)", "oz/gal (UK)", "03"),
  L38("L38", "ounce (avoirdupois) per gallon (US)", "oz/gal (US)", "03"),
  L39("L39", "ounce (avoirdupois) per cubic inch", "oz/in³", "03"),
  L40("L40", "ounce (avoirdupois)-force", "ozf", "03"),
  L41("L41", "ounce (avoirdupois)-force inch", "ozf·in", "03"),
  L42("L42", "picosiemens per metre", "pS/m", "05"),
  L43("L43", "peck (UK)", "pk (UK)", "01"),
  L44("L44", "peck (UK) per day", "pk (UK)/d", "03"),
  L45("L45", "peck (UK) per hour", "pk (UK)/h", "03"),
  L46("L46", "peck (UK) per minute", "pk (UK)/min", "03"),
  L47("L47", "peck (UK) per second", "pk (UK)/s", "03"),
  L48("L48", "peck (US dry) per day", "pk (US dry)/d", "03"),
  L49("L49", "peck (US dry) per hour", "pk (US dry)/h", "03"),
  L50("L50", "peck (US dry) per minute", "pk (US dry)/min", "03"),
  L51("L51", "peck (US dry) per second", "pk (US dry)/s", "03"),
  L52("L52", "psi per psi", "psi/psi", "03"),
  L53("L53", "pint (UK) per day", "pt (UK)/d", "03"),
  L54("L54", "pint (UK) per hour", "pt (UK)/h", "03"),
  L55("L55", "pint (UK) per minute", "pt (UK)/min", "03"),
  L56("L56", "pint (UK) per second", "pt (UK)/s", "03"),
  L57("L57", "pint (US liquid) per day", "pt (US liq.)/d", "03"),
  L58("L58", "pint (US liquid) per hour", "pt (US liq.)/h", "03"),
  L59("L59", "pint (US liquid) per minute", "pt (US liq.)/min", "03"),
  L60("L60", "pint (US liquid) per second", "pt (US liq.)/s", "03"),
  L63("L63", "slug per day", "slug/d", "03"),
  L64("L64", "slug per foot second", "slug/(ft·s)", "03"),
  L65("L65", "slug per cubic foot", "slug/ft³", "03"),
  L66("L66", "slug per hour", "slug/h", "03"),
  L67("L67", "slug per minute", "slug/min", "03"),
  L68("L68", "slug per second", "slug/s", "03"),
  L69("L69", "tonne per kelvin", "t/K", "03"),
  L70("L70", "tonne per bar", "t/bar", "03"),
  L71("L71", "tonne per day", "t/d", "03"),
  L72("L72", "tonne per day kelvin", "(t/d)/K", "03"),
  L73("L73", "tonne per day bar", "(t/d)/bar", "03"),
  L74("L74", "tonne per hour kelvin", "(t/h)/K", "03"),
  L75("L75", "tonne per hour bar", "(t/h)/bar", "03"),
  L76("L76", "tonne per cubic metre kelvin", "(t/m³)/K", "03"),
  L77("L77", "tonne per cubic metre bar", "(t/m³)/bar", "03"),
  L78("L78", "tonne per minute", "t/min", "03"),
  L79("L79", "tonne per minute kelvin", "(t/min)/K", "03"),
  L80("L80", "tonne per minute bar", "(t/min)/bar", "03"),
  L81("L81", "tonne per second", "t/s", "03"),
  L82("L82", "tonne per second kelvin", "(t/s)/K", "03"),
  L83("L83", "tonne per second bar", "(t/s)/bar", "03"),
  L84("L84", "ton (UK shipping)", "British shipping ton", "01"),
  L85("L85", "ton long per day", "ton (UK)/d", "03"),
  L86("L86", "ton (US shipping)", "(US) shipping ton", "01"),
  L87("L87", "ton short per degree Fahrenheit", "ton (US)/°F", "03"),
  L88("L88", "ton short per day", "ton (US)/d", "03"),
  L89("L89", "ton short per hour degree Fahrenheit", "ton (US)/(h·°F)", "03"),
  L90("L90", "ton short per hour psi", "(ton (US)/h)/psi", "03"),
  L91("L91", "ton short per psi", "ton (US)/psi", "03"),
  L92("L92", "ton (UK long) per cubic yard", "ton.l/yd³ (UK)", "03"),
  L93("L93", "ton (US short) per cubic yard", "ton.s/yd³ (US)", "03"),
  L94("L94", "ton-force (US short)", "ton.sh-force", "03"),
  L95("L95", "common year", "y (365 days)", "01"),
  L96("L96", "sidereal year", "y (sidereal)", "01"),
  L98("L98", "yard per degree Fahrenheit", "yd/°F", "01"),
  L99("L99", "yard per psi", "yd/psi", "01"),
  LA("LA", "pound per cubic inch", "lb/in³", "03"),
  LAC("LAC", "lactose excess percentage", null, "3.5"),
  LBR("LBR", "pound", "lb", "03"),
  LBT("LBT", "troy pound (US)", null, "3.5"),
  LD("LD", "litre per day", "l/d", "03"),
  LE("LE", "Luggage", null, null),
  LEF("LEF", "leaf", null, "3.5"),
  LF("LF", "linear foot", null, "3.1"),
  LG("LG", "Log", null, null),
  LH("LH", "labour hour", null, "3.1"),
  LK("LK", "link", null, "3.9"),
  LM("LM", "linear metre", null, "3.1"),
  LN("LN", "length", null, "3.9"),
  LO("LO", "lot [unit of procurement]", null, "3.9"),
  LP("LP", "liquid pound", null, "3.1"),
  LPA("LPA", "litre of pure alcohol", null, "3.1"),
  LR("LR", "layer", null, "3.9"),
  LS("LS", "lump sum", null, "3.9"),
  LT("LT", "Lot", null, null),
  LTN("LTN", "ton (UK) or long ton (US)", "ton (UK)", "03"),
  LTR("LTR", "litre", "l", "01"),
  LU("LU", "Lug", null, null),
  LUB("LUB", "metric ton, lubricating oil", null, "3.1"),
  LUM("LUM", "lumen", "lm", "06"),
  LUX("LUX", "lux", "lx", "06"),
  LV("LV", "Liftvan", null, null),
  LY("LY", "linear yard", null, "3.1"),
  LZ("LZ", "Logs, in bundle/bunch/truss", null, null),
  M1("M1", "milligram per litre", "mg/l", "03"),
  M10("M10", "reciprocal cubic yard", "1/yd³", "08"),
  M11("M11", "cubic yard per degree Fahrenheit", "yd³/°F", "01"),
  M12("M12", "cubic yard per day", "yd³/d", "03"),
  M13("M13", "cubic yard per hour", "yd³/h", "03"),
  M14("M14", "cubic yard per psi", "yd³/psi", "01"),
  M15("M15", "cubic yard per minute", "yd³/min", "03"),
  M16("M16", "cubic yard per second", "yd³/s", "03"),
  M17("M17", "kilohertz metre", "kHz·m", "05"),
  M18("M18", "gigahertz metre", "GHz·m", "05"),
  M19("M19", "Beaufort", "Bft", "3"),
  M20("M20", "reciprocal megakelvin or megakelvin to the power minus one", "1/MK", "04"),
  M21("M21", "reciprocal kilovolt - ampere reciprocal hour", "1/kVAh", "05"),
  M22("M22", "millilitre per square centimetre minute", "(ml/min)/cm²", "01"),
  M23("M23", "newton per centimetre", "N/cm", "03"),
  M24("M24", "ohm kilometre", "Ω·km", "05"),
  M25("M25", "percent per degree Celsius", "%/°C", "3.7"),
  M26("M26", "gigaohm per metre", "GΩ/m", "05"),
  M27("M27", "megahertz metre", "MHz·m", "05"),
  M29("M29", "kilogram per kilogram", "kg/kg", "03"),
  M30("M30", "reciprocal volt - ampere reciprocal second", "1/(V·A·s)", "05"),
  M31("M31", "kilogram per kilometre", "kg/km", "03"),
  M32("M32", "pascal second per litre", "Pa·s/l", "07"),
  M33("M33", "millimole per litre", "mmol/l", "08"),
  M34("M34", "newton metre per square metre", "N·m/m²", "03"),
  M35("M35", "millivolt - ampere", "mV·A", "05"),
  M36("M36", "30-day month", "mo (30 days)", "3.7"),
  M37("M37", "actual/360", "y (360 days)", "3.7"),
  M38("M38", "kilometre per second squared", "km/s²", "01"),
  M39("M39", "centimetre per second squared", "cm/s²", "01"),
  M4("M4", "monetary value", null, "3.9"),
  M40("M40", "yard per second squared", "yd/s²", "01"),
  M41("M41", "millimetre per second squared", "mm/s²", "01"),
  M42("M42", "mile (statute mile) per second squared", "mi/s²", "01"),
  M43("M43", "mil", "mil", "01"),
  M44("M44", "revolution", "rev", "01"),
  M45("M45", "degree [unit of angle] per second squared", "°/s²", "01"),
  M46("M46", "revolution per minute", "r/min", "01"),
  M47("M47", "circular mil", "cmil", "01"),
  M48("M48", "square mile (based on U.S. survey foot)", "mi² (US survey)", "01"),
  M49("M49", "chain (based on U.S. survey foot)", "ch (US survey)", "01"),
  M5("M5", "microcurie", "µCi", "09"),
  M50("M50", "furlong", "fur", "01"),
  M51("M51", "foot (U.S. survey)", "ft (US survey)", "01"),
  M52("M52", "mile (based on U.S. survey foot)", "mi (US survey)", "01"),
  M53("M53", "metre per pascal", "m/Pa", "01"),
  M55("M55", "metre per radiant", "m/rad", "01"),
  M56("M56", "shake", "shake", "01"),
  M57("M57", "mile per minute", "mi/min", "01"),
  M58("M58", "mile per second", "mi/s", "01"),
  M59("M59", "metre per second pascal", "(m/s)/Pa", "01"),
  M60("M60", "metre per hour", "m/h", "01"),
  M61("M61", "inch per year", "in/y", "01"),
  M62("M62", "kilometre per second", "km/s", "01"),
  M63("M63", "inch per minute", "in/min", "01"),
  M64("M64", "yard per second", "yd/s", "01"),
  M65("M65", "yard per minute", "yd/min", "01"),
  M66("M66", "yard per hour", "yd/h", "01"),
  M67("M67", "acre-foot (based on U.S. survey foot)", "acre-ft (US survey)", "01"),
  M68("M68", "cord (128 ft3)", "cord", "01"),
  M69("M69", "cubic mile (UK statute)", "mi³", "01"),
  M7("M7", "micro-inch", "µin", "01"),
  M70("M70", "ton, register", "RT", "01"),
  M71("M71", "cubic metre per pascal", "m³/Pa", "01"),
  M72("M72", "bel", "B", "02"),
  M73("M73", "kilogram per cubic metre pascal", "(kg/m³)/Pa", "03"),
  M74("M74", "kilogram per pascal", "kg/Pa", "03"),
  M75("M75", "kilopound-force", "kip", "03"),
  M76("M76", "poundal", "pdl", "03"),
  M77("M77", "kilogram metre per second squared", "kg·m/s²", "03"),
  M78("M78", "pond", "p", "03"),
  M79("M79", "square foot per hour", "ft²/h", "03"),
  M80("M80", "stokes per pascal", "St/Pa", "03"),
  M81("M81", "square centimetre per second", "cm²/s", "03"),
  M82("M82", "square metre per second pascal", "(m²/s)/Pa", "03"),
  M83("M83", "denier", "den", "03"),
  M84("M84", "pound per yard", "lb/yd", "03"),
  M85("M85", "ton, assay", null, "03"),
  M86("M86", "pfund", "pfd", "03"),
  M87("M87", "kilogram per second pascal", "(kg/s)/Pa", "03"),
  M88("M88", "tonne per month", "t/mo", "03"),
  M89("M89", "tonne per year", "t/y", "03"),
  M9("M9", "million Btu per 1000 cubic foot", "MBTU/kft³", "3.9"),
  M90("M90", "kilopound per hour", "klb/h", "03"),
  M91("M91", "pound per pound", "lb/lb", "03"),
  M92("M92", "pound-force foot", "lbf·ft", "03"),
  M93("M93", "newton metre per radian", "N·m/rad", "03"),
  M94("M94", "kilogram metre", "kg·m", "03"),
  M95("M95", "poundal foot", "pdl·ft", "03"),
  M96("M96", "poundal inch", "pdl·in", "03"),
  M97("M97", "dyne metre", "dyn·m", "03"),
  M98("M98", "kilogram centimetre per second", "kg·(cm/s)", "03"),
  M99("M99", "gram centimetre per second", "g·(cm/s)", "03"),
  MA("MA", "Crate, metal", null, null),
  MAH("MAH", "megavolt ampere reactive hour", "Mvar·h", "3.1"),
  MAL("MAL", "megalitre", "Ml", "01"),
  MAM("MAM", "megametre", "Mm", "01"),
  MAR("MAR", "megavar", "kvar", "05"),
  MAW("MAW", "megawatt", "MW", "03"),
  MB("MB", "Bag, multiply", null, null),
  MBE("MBE", "thousand standard brick equivalent", null, "3.5"),
  MBF("MBF", "thousand board foot", null, "3.5"),
  MBR("MBR", "millibar", "mbar", "03"),
  MC("MC", "microgram", "µg", "03"),
  MCU("MCU", "millicurie", "mCi", "09"),
  MD("MD", "air dry metric ton", null, "3.1"),
  ME("ME", "Container, metal", null, null),
  MGM("MGM", "milligram", "mg", "03"),
  MHZ("MHZ", "megahertz", "MHz", "02"),
  MIK("MIK", "square mile (statute mile)", "mi²", "01"),
  MIL("MIL", "thousand", null, "3.7"),
  MIN("MIN", "minute [unit of time]", "min", "01"),
  MIO("MIO", "million", null, "3.7"),
  MIU("MIU", "million international unit", null, "3.7"),
  MKD("MKD", "Square Metre Day", "m²·d", "3"),
  MKM("MKM", "Square Metre Month", "m²·mo", "3"),
  MKW("MKW", "Square Metre Week", "m²· wk", "3"),
  MLD("MLD", "milliard", null, "3.7"),
  MLT("MLT", "millilitre", "ml", "01"),
  MMK("MMK", "square millimetre", "mm²", "01"),
  MMQ("MMQ", "cubic millimetre", "mm³", "01"),
  MMT("MMT", "millimetre", "mm", "01"),
  MND("MND", "kilogram, dry weight", null, "3.1"),
  MNJ("MNJ", "Mega Joule per Normalised cubic Metre", "MJ/m³", "3"),
  MON("MON", "month", "mo", "01"),
  MPA("MPA", "megapascal", "MPa", "03"),
  MQD("MQD", "Cubic Metre Day", "m³·d", "3"),
  MQH("MQH", "cubic metre per hour", "m³/h", "03"),
  MQM("MQM", "Cubic Metre Month", "m³·mo", "3"),
  MQS("MQS", "cubic metre per second", "m³/s", "03"),
  MQW("MQW", "Cubic Metre Week", "m³·wk", "3"),
  MR("MR", "Receptacle, metal", null, null),
  MRD("MRD", "Metre Day", "m·day", "3"),
  MRM("MRM", "Metre Month", "m·mo", "3"),
  MRW("MRW", "Metre Week", "m·wk", "3"),
  MS("MS", "Sack, multi-wall", null, null),
  MSK("MSK", "metre per second squared", "m/s²", "01"),
  MT("MT", "Mat", null, null),
  MTK("MTK", "square metre", "m²", "01"),
  MTQ("MTQ", "cubic metre", "m³", "01"),
  MTR("MTR", "metre", "m", "01"),
  MTS("MTS", "metre per second", "m/s", "01"),
  MTZ("MTZ", "millihertz", "mHz", "02"),
  MVA("MVA", "megavolt - ampere", "MV·A", "05"),
  MW("MW", "Receptacle, plastic wrapped", null, null),
  MWH("MWH", "megawatt hour (1000 kW.h)", "MW·h", "03"),
  MX("MX", "Matchbox", null, null),
  N1("N1", "pen calorie", null, "3.9"),
  N10("N10", "pound foot per second", "lb·(ft/s)", "03"),
  N11("N11", "pound inch per second", "lb·(in/s)", "03"),
  N12("N12", "Pferdestaerke", "PS", "03"),
  N13("N13", "centimetre of mercury (0 ºC)", "cmHg (0 ºC)", "03"),
  N14("N14", "centimetre of water (4 ºC)", "cmH₂O (4 °C)", "03"),
  N15("N15", "foot of water (39.2 ºF)", "ftH₂O (39,2 ºF)", "03"),
  N16("N16", "inch of mercury (32 ºF)", "inHG (32 ºF)", "03"),
  N17("N17", "inch of mercury (60 ºF)", "inHg (60 ºF)", "03"),
  N18("N18", "inch of water (39.2 ºF)", "inH₂O (39,2 ºF)", "03"),
  N19("N19", "inch of water (60 ºF)", "inH₂O (60 ºF)", "03"),
  N20("N20", "kip per square inch", "ksi", "03"),
  N21("N21", "poundal per square foot", "pdl/ft²", "03"),
  N22("N22", "ounce (avoirdupois) per square inch", "oz/in²", "03"),
  N23("N23", "conventional metre of water", "mH₂O", "03"),
  N24("N24", "gram per square millimetre", "g/mm²", "03"),
  N25("N25", "pound per square yard", "lb/yd²", "03"),
  N26("N26", "poundal per square inch", "pdl/in²", "03"),
  N27("N27", "foot to the fourth power", "ft⁴", "03"),
  N28("N28", "cubic decimetre per kilogram", "dm³/kg", "03"),
  N29("N29", "cubic foot per pound", "ft³/lb", "03"),
  N3("N3", "print point", null, "3.5"),
  N30("N30", "cubic inch per pound", "in³/lb", "03"),
  N31("N31", "kilonewton per metre", "kN/m", "03"),
  N32("N32", "poundal per inch", "pdl/in", "03"),
  N33("N33", "pound-force per yard", "lbf/yd", "03"),
  N34("N34", "poundal second per square foot", "(pdl/ft²)·s", "03"),
  N35("N35", "poise per pascal", "P/Pa", "03"),
  N36("N36", "newton second per square metre", "(N/m²)·s", "03"),
  N37("N37", "kilogram per metre second", "kg/(m·s)", "03"),
  N38("N38", "kilogram per metre minute", "kg/(m·min)", "03"),
  N39("N39", "kilogram per metre day", "kg/(m·d)", "03"),
  N40("N40", "kilogram per metre hour", "kg/(m·h)", "03"),
  N41("N41", "gram per centimetre second", "g/(cm·s)", "03"),
  N42("N42", "poundal second per square inch", "(pdl/in²)·s", "03"),
  N43("N43", "pound per foot minute", "lb/(ft·min)", "03"),
  N44("N44", "pound per foot day", "lb/(ft·d)", "03"),
  N45("N45", "cubic metre per second pascal", "(m³/s)/Pa", "03"),
  N46("N46", "foot poundal", "ft·pdl", "03"),
  N47("N47", "inch poundal", "in·pdl", "03"),
  N48("N48", "watt per square centimetre", "W/cm²", "04"),
  N49("N49", "watt per square inch", "W/in²", "04"),
  N50("N50", "British thermal unit (international table) per square foot hour", "BtuIT/(ft²·h)", "04"),
  N51("N51", "British thermal unit (thermochemical) per square foot hour", "Btuth/(ft²·h)", "04"),
  N52("N52", "British thermal unit (thermochemical) per square foot minute", "Btuth/(ft²·min)", "04"),
  N53("N53", "British thermal unit (international table) per square foot second", "BtuIT/(ft²·s)", "04"),
  N54("N54", "British thermal unit (thermochemical) per square foot second", "Btuth/(ft²·s)", "04"),
  N55("N55", "British thermal unit (international table) per square inch second", "BtuIT/(in²·s)", "04"),
  N56("N56", "calorie (thermochemical) per square centimetre minute", "calth/(cm²·min)", "04"),
  N57("N57", "calorie (thermochemical) per square centimetre second", "calth/(cm²·s)", "04"),
  N58("N58", "British thermal unit (international table) per cubic foot", "BtuIT/ft³", "04"),
  N59("N59", "British thermal unit (thermochemical) per cubic foot", "Btuth/ft³", "04"),
  N60("N60", "British thermal unit (international table) per degree Fahrenheit", "BtuIT/ºF", "04"),
  N61("N61", "British thermal unit (thermochemical) per degree Fahrenheit", "Btuth/ºF", "04"),
  N62("N62", "British thermal unit (international table) per degree Rankine", "BtuIT/ºR", "04"),
  N63("N63", "British thermal unit (thermochemical) per degree Rankine", "Btuth/ºR", "04"),
  N64("N64", "British thermal unit (thermochemical) per pound degree Rankine", "(Btuth/°R)/lb", "04"),
  N65("N65", "kilocalorie (international table) per gram kelvin", "(kcalIT/K)/g", "04"),
  N66("N66", "British thermal unit (39 ºF)", "Btu (39 ºF)", "04"),
  N67("N67", "British thermal unit (59 ºF)", "Btu (59 ºF)", "04"),
  N68("N68", "British thermal unit (60 ºF)", "Btu (60 ºF)", "04"),
  N69("N69", "calorie (20 ºC)", "cal₂₀", "04"),
  N70("N70", "quad (1015 BtuIT)", "quad", "04"),
  N71("N71", "therm (EC)", "thm (EC)", "04"),
  N72("N72", "therm (U.S.)", "thm (US)", "04"),
  N73("N73", "British thermal unit (thermochemical) per pound", "Btuth/lb", "04"),
  N74("N74", "British thermal unit (international table) per hour square foot degree Fahrenheit", "BtuIT/(h·ft²·ºF)", "04"),
  N75("N75", "British thermal unit (thermochemical) per hour square foot degree Fahrenheit", "Btuth/(h·ft²·ºF)", "04"),
  N76("N76", "British thermal unit (international table) per second square foot degree Fahrenheit", "BtuIT/(s·ft²·ºF)", "04"),
  N77("N77", "British thermal unit (thermochemical) per second square foot degree Fahrenheit", "Btuth/(s·ft²·ºF)", "04"),
  N78("N78", "kilowatt per square metre kelvin", "kW/(m²·K)", "04"),
  N79("N79", "kelvin per pascal", "K/Pa", "04"),
  N80("N80", "watt per metre degree Celsius", "W/(m·°C)", "04"),
  N81("N81", "kilowatt per metre kelvin", "kW/(m·K)", "04"),
  N82("N82", "kilowatt per metre degree Celsius", "kW/(m·°C)", "04"),
  N83("N83", "metre per degree Celcius metre", "m/(°C·m)", "04"),
  N84("N84", "degree Fahrenheit hour per British thermal unit (international table)", "ºF/(BtuIT/h)", "04"),
  N85("N85", "degree Fahrenheit hour per British thermal unit (thermochemical)", "ºF/(Btuth/h)", "04"),
  N86("N86", "degree Fahrenheit second per British thermal unit (international table)", "ºF/(BtuIT/s)", "04"),
  N87("N87", "degree Fahrenheit second per British thermal unit (thermochemical)", "ºF/(Btuth/s)", "04"),
  N88("N88", "degree Fahrenheit hour square foot per British thermal unit (international table) inch", "ºF·h·ft²/(BtuIT·in)", "04"),
  N89("N89", "degree Fahrenheit hour square foot per British thermal unit (thermochemical) inch", "ºF·h·ft²/(Btuth·in)", "04"),
  N90("N90", "kilofarad", "kF", "05"),
  N91("N91", "reciprocal joule", "1/J", "05"),
  N92("N92", "picosiemens", "pS", "05"),
  N93("N93", "ampere per pascal", "A/Pa", "05"),
  N94("N94", "franklin", "Fr", "05"),
  N95("N95", "ampere minute", "A·min", "05"),
  N96("N96", "biot", "Bi", "05"),
  N97("N97", "gilbert", "Gi", "05"),
  N98("N98", "volt per pascal", "V/Pa", "05"),
  N99("N99", "picovolt", "pV", "05"),
  NA("NA", "milligram per kilogram", "mg/kg", "03"),
  NAR("NAR", "number of articles", null, "3.7"),
  NCL("NCL", "number of cells", null, "3.7"),
  NE("NE", "Unpacked or unpackaged", null, null),
  NEW("NEW", "newton", "N", "03"),
  NF("NF", "message", null, "3.9"),
  NG("NG", "Unpacked or unpackaged, multiple units", null, null),
  NIU("NIU", "number of international units", null, "3.7"),
  NL("NL", "load", null, "3.4"),
  NM3("NM3", "Normalised cubic metre", null, "01"),
  NMI("NMI", "nautical mile", "n mile", "01"),
  NMP("NMP", "number of packs", null, "3.7"),
  NPT("NPT", "number of parts", null, "3.7"),
  NS("NS", "Nest", null, null),
  NT("NT", "net ton", null, "3.4"),
  NTU("NTU", "Nephelometric turbidity unit", "NTU", "3.5"),
  NU("NU", "newton metre", "N·m", "03"),
  NV("NV", "Net, tube, textile", null, null),
  NX("NX", "part per thousand", "‰", "3.7"),
  O1("O1", "Two sided cage on wheels with fixing strap", null, null),
  O2("O2", "Trolley", null, null),
  O3("O3", "Oneway pallet ISO 0 - 1/2 EURO Pallet", null, null),
  O4("O4", "Oneway pallet ISO 1 - 1/1 EURO Pallet", null, null),
  O5("O5", "Oneway pallet ISO 2 - 2/1 EURO Pallet", null, null),
  O6("O6", "Pallet with exceptional dimensions", null, null),
  O7("O7", "Wooden pallet  40 cm x 80 cm", null, null),
  O8("O8", "Plastic pallet SRS 60 cm x 80 cm", null, null),
  O9("O9", "Plastic pallet SRS 80 cm x 120 cm", null, null),
  OA("OA", "panel", null, "3.9"),
  OB("OB", "Pallet, CHEP 80 cm x 120 cm", null, null),
  OC("OC", "Pallet, CHEP 100 cm x 120 cm", null, null),
  OD("OD", "Pallet, AS 4068-1993", null, null),
  ODE("ODE", "ozone depletion equivalent", null, "3.1"),
  ODG("ODG", "ODS Grams", null, "3.1"),
  ODK("ODK", "ODS Kilograms", null, "3.1"),
  ODM("ODM", "ODS Milligrams", null, "3.1"),
  OE("OE", "Pallet, ISO T11", null, null),
  OF("OF", "Platform, unspecified weight or dimension", null, null),
  OG("OG", "Pallet ISO 0 - 1/2 EURO Pallet", null, null),
  OH("OH", "Pallet ISO 1 - 1/1 EURO Pallet", null, null),
  OHM("OHM", "ohm", "Ω", "05"),
  OI("OI", "Pallet ISO 2 – 2/1 EURO Pallet", null, null),
  OJ("OJ", "1/4 EURO Pallet", null, null),
  OK("OK", "Block", null, null),
  OL("OL", "1/8 EURO Pallet", null, null),
  OM("OM", "Synthetic pallet ISO 1", null, null),
  ON("ON", "ounce per square yard", "oz/yd²", "03"),
  ONZ("ONZ", "ounce (avoirdupois)", "oz", "03"),
  OP("OP", "Wholesaler pallet", null, null),
  OPM("OPM", "oscillations per minute", "o/min", "02"),
  OQ("OQ", "Pallet 80 X 100 cm", null, null),
  OR("OR", "Pallet 60 X 100 cm", null, null),
  OS("OS", "Oneway pallet", null, null),
  OT("OT", "overtime hour", null, "3.1"),
  OU("OU", "Container, outer", null, null),
  OV("OV", "Returnable pallet", null, null),
  OW("OW", "Large bag, pallet sized", null, null),
  OX("OX", "A wheeled pallet with raised rim (81 x 67 x 135)", null, null),
  OY("OY", "A Wheeled pallet with raised rim (81 x 72 x 135)", null, null),
  OZ("OZ", "Wheeled pallet with raised rim ( 81 x 60 x 16)", null, null),
  OZA("OZA", "fluid ounce (US)", "fl oz (US)", "01"),
  OZI("OZI", "fluid ounce (UK)", "fl oz (UK)", "01"),
  P1("P1", "percent", "% or pct", "3.7"),
  P10("P10", "coulomb per metre", "C/m", "05"),
  P11("P11", "kiloweber", "kWb", "05"),
  P12("P12", "gamma", "γ", "05"),
  P13("P13", "kilotesla", "kT", "05"),
  P14("P14", "joule per second", "J/s", "05"),
  P15("P15", "joule per minute", "J/min", "05"),
  P16("P16", "joule per hour", "J/h", "05"),
  P17("P17", "joule per day", "J/d", "05"),
  P18("P18", "kilojoule per second", "kJ/s", "05"),
  P19("P19", "kilojoule per minute", "kJ/min", "05"),
  P2("P2", "pound per foot", "lb/ft", "03"),
  P20("P20", "kilojoule per hour", "kJ/h", "05"),
  P21("P21", "kilojoule per day", "kJ/d", "05"),
  P22("P22", "nanoohm", "nΩ", "05"),
  P23("P23", "ohm circular-mil per foot", "Ω·cmil/ft", "05"),
  P24("P24", "kilohenry", "kH", "05"),
  P25("P25", "lumen per square foot", "lm/ft²", "06"),
  P26("P26", "phot", "ph", "06"),
  P27("P27", "footcandle", "ftc", "06"),
  P28("P28", "candela per square inch", "cd/in²", "06"),
  P29("P29", "footlambert", "ftL", "06"),
  P3("P3", "LPR pallet 60 cm x 80 cm", null, null),
  P30("P30", "lambert", "Lb", "06"),
  P31("P31", "stilb", "sb", "06"),
  P32("P32", "candela per square foot", "cd/ft²", "06"),
  P33("P33", "kilocandela", "kcd", "06"),
  P34("P34", "millicandela", "mcd", "06"),
  P35("P35", "Hefner-Kerze", "HK", "06"),
  P36("P36", "international candle", "IK", "06"),
  P37("P37", "British thermal unit (international table) per square foot", "BtuIT/ft²", "06"),
  P38("P38", "British thermal unit (thermochemical) per square foot", "Btuth/ft²", "06"),
  P39("P39", "calorie (thermochemical) per square centimetre", "calth/cm²", "06"),
  P4("P4", "LPR pallet 80 cm x 120 cm", null, null),
  P40("P40", "langley", "Ly", "06"),
  P41("P41", "decade (logarithmic)", "dec", "07"),
  P42("P42", "pascal squared second", "Pa²·s", "07"),
  P43("P43", "bel per metre", "B/m", "07"),
  P44("P44", "pound mole", "lbmol", "08"),
  P45("P45", "pound mole per second", "lbmol/s", "08"),
  P46("P46", "pound mole per minute", "lbmol/h", "08"),
  P47("P47", "kilomole per kilogram", "kmol/kg", "08"),
  P48("P48", "pound mole per pound", "lbmol/lb", "08"),
  P49("P49", "newton square metre per ampere", "N·m²/A", "08"),
  P5("P5", "five pack", null, "3.2"),
  P50("P50", "weber metre", "Wb·m", "08"),
  P51("P51", "mol per kilogram pascal", "(mol/kg)/Pa", "08"),
  P52("P52", "mol per cubic metre pascal", "(mol/m³)/Pa", "08"),
  P53("P53", "unit pole", "unit pole", "12"),
  P54("P54", "milligray per second", "mGy/s", "10"),
  P55("P55", "microgray per second", "µGy/s", "10"),
  P56("P56", "nanogray per second", "nGy/s", "10"),
  P57("P57", "gray per minute", "Gy/min", "10"),
  P58("P58", "milligray per minute", "mGy/min", "10"),
  P59("P59", "microgray per minute", "µGy/min", "10"),
  P60("P60", "nanogray per minute", "nGy/min", "10"),
  P61("P61", "gray per hour", "Gy/h", "10"),
  P62("P62", "milligray per hour", "mGy/h", "10"),
  P63("P63", "microgray per hour", "µGy/h", "10"),
  P64("P64", "nanogray per hour", "nGy/h", "10"),
  P65("P65", "sievert per second", "Sv/s", "10"),
  P66("P66", "millisievert per second", "mSv/s", "10"),
  P67("P67", "microsievert per second", "µSv/s", "10"),
  P68("P68", "nanosievert per second", "nSv/s", "10"),
  P69("P69", "rem per second", "rem/s", "10"),
  P70("P70", "sievert per hour", "Sv/h", "10"),
  P71("P71", "millisievert per hour", "mSv/h", "10"),
  P72("P72", "microsievert per hour", "µSv/h", "10"),
  P73("P73", "nanosievert per hour", "nSv/h", "10"),
  P74("P74", "sievert per minute", "Sv/min", "10"),
  P75("P75", "millisievert per minute", "mSv/min", "10"),
  P76("P76", "microsievert per minute", "µSv/min", "10"),
  P77("P77", "nanosievert per minute", "nSv/min", "10"),
  P78("P78", "reciprocal square inch", "1/in²", "10"),
  P79("P79", "pascal square metre per kilogram", "Pa/(kg/m²)", "13"),
  P80("P80", "millipascal per metre", "mPa/m", "13"),
  P81("P81", "kilopascal per metre", "kPa/m", "13"),
  P82("P82", "hectopascal per metre", "hPa/m", "13"),
  P83("P83", "standard atmosphere per metre", "Atm/m", "13"),
  P84("P84", "technical atmosphere per metre", "at/m", "13"),
  P85("P85", "torr per metre", "Torr/m", "13"),
  P86("P86", "psi per inch", "psi/in", "13"),
  P87("P87", "cubic metre per second square metre", "(m³/s)/m²", "13"),
  P88("P88", "rhe", "rhe", "3.5"),
  P89("P89", "pound-force foot per inch", "lbf·ft/in", "3.5"),
  P90("P90", "pound-force inch per inch", "lbf·in/in", "3.5"),
  P91("P91", "perm (0 ºC)", "perm (0 ºC)", "3.5"),
  P92("P92", "perm (23 ºC)", "perm (23 ºC)", "3.5"),
  P93("P93", "byte per second", "byte/s", "3.6"),
  P94("P94", "kilobyte per second", "kbyte/s", "3.6"),
  P95("P95", "megabyte per second", "Mbyte/s", "3.6"),
  P96("P96", "reciprocal volt", "1/V", "3.5"),
  P97("P97", "reciprocal radian", "1/rad", "3.5"),
  P98("P98", "pascal to the power sum of stoichiometric numbers", "PaΣνB", "3.5"),
  P99("P99", "mole per cubiv metre to the power sum of stoichiometric numbers", "(mol/m³)∑νB", "3.5"),
  PA("PA", "Packet", null, null),
  PAL("PAL", "pascal", "Pa", "03"),
  PB("PB", "Pallet, box Combined open-ended box and pallet", null, null),
  PC("PC", "Parcel", null, null),
  PD("PD", "pad", null, "3.9"),
  PE("PE", "Pallet, modular, collars 80cms * 120cms", null, null),
  PF("PF", "Pen", null, null),
  PFL("PFL", "proof litre", null, "3.1"),
  PG("PG", "Plate", null, null),
  PGL("PGL", "proof gallon", null, "3.1"),
  PH("PH", "Pitcher", null, null),
  PI("PI", "pitch", null, "3.5"),
  PJ("PJ", "Punnet", null, null),
  PK("PK", "Package", null, null),
  PL("PL", "Pail", null, null),
  PLA("PLA", "degree Plato", "°P", "3.5"),
  PN("PN", "Plank", null, null),
  PO("PO", "pound per inch of length", "lb/in", "03"),
  PP("PP", "Piece", null, null),
  PQ("PQ", "page per inch", "ppi", "3.5"),
  PR("PR", "pair", null, "3.7"),
  PS("PS", "pound-force per square inch", "lbf/in²", "03"),
  PT("PT", "Pot", null, null),
  PTD("PTD", "dry pint (US)", "dry pt (US)", "01"),
  PTI("PTI", "pint (UK)", "pt (UK)", "01"),
  PTL("PTL", "liquid pint (US)", "liq pt (US)", "01"),
  PTN("PTN", "portion", "PTN", "3.5"),
  PU("PU", "Tray", null, null),
  PV("PV", "Pipes, in bundle/bunch/truss", null, null),
  PX("PX", "Pallet", null, null),
  PY("PY", "Plates, in bundle/bunch/truss", null, null),
  PZ("PZ", "Planks, in bundle/bunch/truss", null, null),
  Q10("Q10", "joule per tesla", "J/T", "3.5"),
  Q11("Q11", "erlang", "E", "3.6"),
  Q12("Q12", "octet", "o", "3.6"),
  Q13("Q13", "octet per second", "o/s", "3.6"),
  Q14("Q14", "shannon", "Sh", "3.6"),
  Q15("Q15", "hartley", "Hart", "3.6"),
  Q16("Q16", "natural unit of information", "nat", "3.6"),
  Q17("Q17", "shannon per second", "Sh/s", "3.6"),
  Q18("Q18", "hartley per second", "Hart/s", "3.6"),
  Q19("Q19", "natural unit of information per second", "nat/s", "3.6"),
  Q20("Q20", "second per kilogramm", "s/kg", "3.5"),
  Q21("Q21", "watt square metre", "W·m²", "3.5"),
  Q22("Q22", "second per radian cubic metre", "1/(Hz·rad·m³)", "3.5"),
  Q23("Q23", "weber to the power minus one", "1/Wb", "3.5"),
  Q24("Q24", "reciprocal inch", "1/in", "3.5"),
  Q25("Q25", "dioptre", "dpt", "3.5"),
  Q26("Q26", "one per one", "1/1", "3.5"),
  Q27("Q27", "newton metre per metre", "N·m/m²", "3.5"),
  Q28("Q28", "kilogram per square metre pascal second", "kg/(m²·Pa·s)", "3.5"),
  Q29("Q29", "microgram per hectogram", "µg/hg", "03"),
  Q3("Q3", "meal", null, "3.9"),
  Q30("Q30", "pH (potential of Hydrogen)", "pH", "08"),
  Q31("Q31", "kilojoule per gram", "kJ/g", "04"),
  Q32("Q32", "femtolitre", "fl", "01"),
  Q33("Q33", "picolitre", "pl", "01"),
  Q34("Q34", "nanolitre", "nl", "01"),
  Q35("Q35", "megawatts per minute", "MW/min", "03"),
  Q36("Q36", "square metre per cubic metre", "m2/m3", "3"),
  Q37("Q37", "Standard cubic metre per day", null, "03"),
  Q38("Q38", "Standard cubic metre per hour", null, "03"),
  Q39("Q39", "Normalized cubic metre per day", null, "03"),
  Q40("Q40", "Normalized cubic metre per hour", null, "03"),
  Q41("Q41", "Joule per normalised cubic metre", null, "03"),
  Q42("Q42", "Joule per standard cubic metre", null, "03"),
  QA("QA", "page - facsimile", null, "3.5"),
  QAN("QAN", "quarter (of a year)", null, "3.8"),
  QB("QB", "page - hardcopy", null, "3.5"),
  QC("QC", "Drum, aluminium, non-removable head", null, null),
  QD("QD", "Drum, aluminium, removable head", null, null),
  QF("QF", "Drum, plastic, non-removable head", null, null),
  QG("QG", "Drum, plastic, removable head", null, null),
  QH("QH", "Barrel, wooden, bung type", null, null),
  QJ("QJ", "Barrel, wooden, removable head", null, null),
  QK("QK", "Jerrican, steel, non-removable head", null, null),
  QL("QL", "Jerrican, steel, removable head", null, null),
  QM("QM", "Jerrican, plastic, non-removable head", null, null),
  QN("QN", "Jerrican, plastic, removable head", null, null),
  QP("QP", "Box, wooden, natural wood, ordinary", null, null),
  QQ("QQ", "Box, wooden, natural wood, with sift proof walls", null, null),
  QR("QR", "quire", "qr", "3.5"),
  QS("QS", "Box, plastic, solid", null, null),
  QTD("QTD", "dry quart (US)", "dry qt (US)", "01"),
  QTI("QTI", "quart (UK)", "qt (UK)", "01"),
  QTL("QTL", "liquid quart (US)", "liq qt (US)", "01"),
  QTR("QTR", "quarter (UK)", "Qr (UK)", "3.5"),
  R1("R1", "pica", null, "3.5"),
  R9("R9", "thousand cubic metre", null, "3.8"),
  RD("RD", "Rod", null, null),
  RG("RG", "Ring", null, null),
  RH("RH", "running or operating hour", null, "3.1"),
  RJ("RJ", "Rack, clothing hanger", null, null),
  RK("RK", "Rack", null, null),
  RL("RL", "Reel", null, null),
  RM("RM", "ream", null, "3.5"),
  RO("RO", "Roll", null, null),
  ROM("ROM", "room", null, "3.9"),
  RP("RP", "pound per ream", null, "3.5"),
  RPM("RPM", "revolutions per minute", "r/min", "02"),
  RPS("RPS", "revolutions per second", "r/s", "02"),
  RT("RT", "revenue ton mile", null, "3.4"),
  RZ("RZ", "Rods, in bundle/bunch/truss", null, null),
  S3("S3", "square foot per second", "ft²/s", "03"),
  S4("S4", "square metre per second", "m²/s", "03"),
  SA("SA", "Sack", null, null),
  SAN("SAN", "half year (6 months)", null, "3.8"),
  SB("SB", "Slab", null, null),
  SC("SC", "Crate, shallow", null, null),
  SCO("SCO", "score", null, "3.7"),
  SCR("SCR", "scruple", null, "3.5"),
  SD("SD", "Spindle", null, null),
  SE("SE", "Sea-chest", null, null),
  SEC("SEC", "second [unit of time]", "s", "01"),
  SET("SET", "set", null, "3.2"),
  SG("SG", "segment", null, "3.9"),
  SH("SH", "Sachet", null, null),
  SI("SI", "Skid", null, null),
  SIE("SIE", "siemens", "S", "05"),
  SK("SK", "Case, skeleton", null, null),
  SL("SL", "Slipsheet", null, null),
  SM("SM", "Sheetmetal", null, null),
  SM3("SM3", "Standard cubic metre", null, "01"),
  SMI("SMI", "mile (statute mile)", "mile", "01"),
  SO("SO", "Spool", null, null),
  SP("SP", "Sheet, plastic wrapping", null, null),
  SQ("SQ", "square", null, "3.9"),
  SQR("SQR", "square, roofing", null, "3.1"),
  SR("SR", "strip", null, "3.9"),
  SS("SS", "Case, steel", null, null),
  ST("ST", "Sheet", null, null),
  STC("STC", "stick", null, "3.9"),
  STI("STI", "stone (UK)", "st", "03"),
  STK("STK", "stick, cigarette", null, "3.9"),
  STL("STL", "standard litre", null, "3.1"),
  STN("STN", "ton (US) or short ton (UK/US)", "ton (US)", "03"),
  STW("STW", "straw", null, "3.9"),
  SU("SU", "Suitcase", null, null),
  SV("SV", "Envelope, steel", null, null),
  SW("SW", "skein", null, "3.9"),
  SX("SX", "shipment", null, "3.4"),
  SY("SY", "Sleeve", null, null),
  SYR("SYR", "syringe", null, "3.9"),
  SZ("SZ", "Sheets, in bundle/bunch/truss", null, null),
  T0("T0", "telecommunication line in service", null, "3.5"),
  T1("T1", "Tablet", null, null),
  T3("T3", "thousand piece", null, "3.8"),
  TAH("TAH", "kiloampere hour (thousand ampere hour)", "kA·h", "05"),
  TAN("TAN", "total acid number", "TAN", "3.5"),
  TB("TB", "Tub", null, null),
  TC("TC", "Tea-chest", null, null),
  TD("TD", "Tube, collapsible", null, null),
  TE("TE", "Tyre", null, null),
  TG("TG", "Tank container, generic", null, null),
  TI("TI", "thousand square inch", null, "3.8"),
  TIC("TIC", "metric ton, including container", null, "3.1"),
  TIP("TIP", "metric ton, including inner packaging", null, "3.1"),
  TK("TK", "Tank, rectangular", null, null),
  TKM("TKM", "tonne kilometre", "t·km", "3.4"),
  TL("TL", "Tub, with lid", null, null),
  TMS("TMS", "kilogram of imported meat, less offal", null, "3.5"),
  TN("TN", "Tin", null, null),
  TNE("TNE", "tonne (metric ton)", "t", "03"),
  TO("TO", "Tun", null, null),
  TP("TP", "ten pack", null, "3.2"),
  TPI("TPI", "teeth per inch", "TPI", "3.1"),
  TPR("TPR", "ten pair", null, "3.8"),
  TQD("TQD", "thousand cubic metre per day", "km³/d", "3.8"),
  TR("TR", "Trunk", null, null),
  TRL("TRL", "trillion (EUR)", null, "3.7"),
  TS("TS", "Truss", null, null),
  TST("TST", "ten set", null, "3.9"),
  TT("TT", "Bag, tote", null, null),
  TTS("TTS", "ten thousand sticks", null, "3.9"),
  TU("TU", "Tube", null, null),
  TV("TV", "Tube, with nozzle", null, null),
  TW("TW", "Pallet, triwall", null, null),
  TY("TY", "Tank, cylindrical", null, null),
  TZ("TZ", "Tubes, in bundle/bunch/truss", null, null),
  U1("U1", "treatment", null, "3.9"),
  U2("U2", "tablet", null, "3.9"),
  UB("UB", "telecommunication line in service average", null, "3.5"),
  UC("UC", "telecommunication port", null, "3.5"),
  UN("UN", "Unit", null, null),
  VA("VA", "volt - ampere per kilogram", "V·A / kg", "3.9"),
  VG("VG", "Bulk, gas (at 1031 mbar and 15°C)", null, null),
  VI("VI", "Vial", null, null),
  VK("VK", "Vanpack", null, null),
  VL("VL", "Bulk, liquid", null, null),
  VLT("VLT", "volt", "V", "05"),
  VN("VN", "Vehicle", null, null),
  VO("VO", "Bulk, solid, large particles (“nodules”)", null, null),
  VP("VP", "percent volume", null, "3.7"),
  VQ("VQ", "Bulk, liquefied gas (at abnormal temperature/pressure)", null, null),
  VR("VR", "Bulk, solid, granular particles (“grains”)", null, null),
  VS("VS", "Bulk, scrap metal", null, null),
  VY("VY", "Bulk, solid, fine particles (“powders”)", null, null),
  W2("W2", "wet kilo", null, "3.1"),
  WA("WA", "watt per kilogram", "W/kg", "3.9"),
  WB("WB", "wet pound", null, "3.1"),
  WC("WC", "Intermediate bulk container, steel", null, null),
  WCD("WCD", "cord", null, "3.5"),
  WD("WD", "Intermediate bulk container, aluminium", null, null),
  WE("WE", "wet ton", null, "3.1"),
  WEB("WEB", "weber", "Wb", "05"),
  WEE("WEE", "week", "wk", "01"),
  WF("WF", "Intermediate bulk container, metal", null, null),
  WG("WG", "wine gallon", null, "3.1"),
  WH("WH", "Intermediate bulk container, aluminium, pressurised > 10 kpa", null, null),
  WHR("WHR", "watt hour", "W·h", "03"),
  WJ("WJ", "Intermediate bulk container, metal, pressure 10 kpa", null, null),
  WK("WK", "Intermediate bulk container, steel, liquid", null, null),
  WL("WL", "Intermediate bulk container, aluminium, liquid", null, null),
  WM("WM", "working month", null, "3.1"),
  WN("WN", "Intermediate bulk container, woven plastic, without coat/liner", null, null),
  WP("WP", "Intermediate bulk container, woven plastic, coated", null, null),
  WQ("WQ", "Intermediate bulk container, woven plastic, with liner", null, null),
  WR("WR", "Intermediate bulk container, woven plastic, coated and liner", null, null),
  WS("WS", "Intermediate bulk container, plastic film", null, null),
  WSD("WSD", "standard", "std", "3.5"),
  WT("WT", "Intermediate bulk container, textile with out coat/liner", null, null),
  WTT("WTT", "watt", "W", "03"),
  WU("WU", "Intermediate bulk container, natural wood, with inner liner", null, null),
  WV("WV", "Intermediate bulk container, textile, coated", null, null),
  WW("WW", "Intermediate bulk container, textile, with liner", null, null),
  WX("WX", "Intermediate bulk container, textile, coated and liner", null, null),
  WY("WY", "Intermediate bulk container, plywood, with inner liner", null, null),
  WZ("WZ", "Intermediate bulk container, reconstituted wood, with inner liner", null, null),
  X1("X1", "Gunter's chain", "ch (UK)", "01"),
  XA("XA", "Bag, woven plastic, without inner coat/liner", null, null),
  XB("XB", "Bag, woven plastic, sift proof", null, null),
  XC("XC", "Bag, woven plastic, water resistant", null, null),
  XD("XD", "Bag, plastics film", null, null),
  XF("XF", "Bag, textile, without inner coat/liner", null, null),
  XG("XG", "Bag, textile, sift proof", null, null),
  XH("XH", "Bag, textile, water resistant", null, null),
  XJ("XJ", "Bag, paper, multi-wall", null, null),
  XK("XK", "Bag, paper, multi-wall, water resistant", null, null),
  YA("YA", "Composite packaging, plastic receptacle in steel drum", null, null),
  YB("YB", "Composite packaging, plastic receptacle in steel crate box", null, null),
  YC("YC", "Composite packaging, plastic receptacle in aluminium drum", null, null),
  YD("YD", "Composite packaging, plastic receptacle in aluminium crate", null, null),
  YDK("YDK", "square yard", "yd²", "01"),
  YDQ("YDQ", "cubic yard", "yd³", "01"),
  YF("YF", "Composite packaging, plastic receptacle in wooden box", null, null),
  YG("YG", "Composite packaging, plastic receptacle in plywood drum", null, null),
  YH("YH", "Composite packaging, plastic receptacle in plywood box", null, null),
  YJ("YJ", "Composite packaging, plastic receptacle in fibre drum", null, null),
  YK("YK", "Composite packaging, plastic receptacle in fibreboard box", null, null),
  YL("YL", "Composite packaging, plastic receptacle in plastic drum", null, null),
  YM("YM", "Composite packaging, plastic receptacle in solid plastic box", null, null),
  YN("YN", "Composite packaging, glass receptacle in steel drum", null, null),
  YP("YP", "Composite packaging, glass receptacle in steel crate box", null, null),
  YQ("YQ", "Composite packaging, glass receptacle in aluminium drum", null, null),
  YR("YR", "Composite packaging, glass receptacle in aluminium crate", null, null),
  YRD("YRD", "yard", "yd", "01"),
  YS("YS", "Composite packaging, glass receptacle in wooden box", null, null),
  YT("YT", "Composite packaging, glass receptacle in plywood drum", null, null),
  YV("YV", "Composite packaging, glass receptacle in wickerwork hamper", null, null),
  YW("YW", "Composite packaging, glass receptacle in fibre drum", null, null),
  YX("YX", "Composite packaging, glass receptacle in fibreboard box", null, null),
  YY("YY", "Composite packaging, glass receptacle in expandable plastic pack", null, null),
  YZ("YZ", "Composite packaging, glass receptacle in solid plastic pack", null, null),
  Z11("Z11", "hanging container", null, "3.9"),
  Z9("Z9", "nanomole", "nmol", "08"),
  ZA("ZA", "Intermediate bulk container, paper, multi-wall", null, null),
  ZB("ZB", "Bag, large", null, null),
  ZC("ZC", "Intermediate bulk container, paper, multi-wall, water resistant", null, null),
  ZD("ZD", "Intermediate bulk container, rigid plastic, with structural equipment, solids", null, null),
  ZF("ZF", "Intermediate bulk container, rigid plastic, freestanding, solids", null, null),
  ZG("ZG", "Intermediate bulk container, rigid plastic, with structural equipment, pressurised", null, null),
  ZH("ZH", "Intermediate bulk container, rigid plastic, freestanding, pressurised", null, null),
  ZJ("ZJ", "Intermediate bulk container, rigid plastic, with structural equipment, liquids", null, null),
  ZK("ZK", "Intermediate bulk container, rigid plastic, freestanding, liquids", null, null),
  ZL("ZL", "Intermediate bulk container, composite, rigid plastic, solids", null, null),
  ZM("ZM", "Intermediate bulk container, composite, flexible plastic, solids", null, null),
  ZN("ZN", "Intermediate bulk container, composite, rigid plastic, pressurised", null, null),
  ZP("ZP", "page", null, "3.5"),
  ZQ("ZQ", "Intermediate bulk container, composite, rigid plastic, liquids", null, null),
  ZR("ZR", "Intermediate bulk container, composite, flexible plastic, liquids", null, null),
  ZS("ZS", "Intermediate bulk container, composite", null, null),
  ZT("ZT", "Intermediate bulk container, fibreboard", null, null),
  ZU("ZU", "Intermediate bulk container, flexible", null, null),
  ZV("ZV", "Intermediate bulk container, metal, other than steel", null, null),
  ZW("ZW", "Intermediate bulk container, natural wood", null, null),
  ZX("ZX", "Intermediate bulk container, plywood", null, null),
  ZY("ZY", "Intermediate bulk container, reconstituted wood", null, null),
  ZZ("ZZ", "mutually defined", null, "3.9"),
}
