package net.codinux.i18n

import kotlin.String
import net.codinux.collections.ImmutableMap
import net.codinux.collections.immutableMapOf

object RegionDisplayNames {
  val af: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "wêreld",
    "002" to "Afrika",
    "003" to "Noord-Amerika",
    "005" to "Suid-Amerika",
    "009" to "Oseanië",
    "011" to "Wes-Afrika",
    "013" to "Sentraal-Amerika",
    "014" to "Oos-Afrika",
    "015" to "Noord-Afrika",
    "017" to "Midde-Afrika",
    "018" to "Suider-Afrika",
    "019" to "Amerikas",
    "021" to "Noordelike Amerika",
    "029" to "Karibiese streek",
    "030" to "Oos-Asië",
    "034" to "Suid-Asië",
    "035" to "Suidoos-Asië",
    "039" to "Suid-Europa",
    "053" to "Australasië",
    "054" to "Melanesië",
    "057" to "Mikronesiese streek",
    "061" to "Polinesië",
    "142" to "Asië",
    "143" to "Sentraal-Asië",
    "145" to "Wes-Asië",
    "150" to "Europa",
    "151" to "Oos-Europa",
    "154" to "Noord-Europa",
    "155" to "Wes-Europa",
    "202" to "Afrika suid van die Sahara",
    "419" to "Latyns-Amerika",
    "AC" to "Ascensioneiland",
    "AD" to "Andorra",
    "AE" to "Verenigde Arabiese Emirate",
    "AF" to "Afganistan",
    "AG" to "Antigua en Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albanië",
    "AM" to "Armenië",
    "AO" to "Angola",
    "AQ" to "Antarktika",
    "AR" to "Argentinië",
    "AS" to "Amerikaanse Samoa",
    "AT" to "Oostenryk",
    "AU" to "Australië",
    "AW" to "Aruba",
    "AX" to "Ålandeilande",
    "AZ" to "Azerbeidjan",
    "BA" to "Bosnië en Herzegowina",
    "BB" to "Barbados",
    "BD" to "Bangladesj",
    "BE" to "België",
    "BF" to "Burkina Faso",
    "BG" to "Bulgarye",
    "BH" to "Bahrein",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Sint Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Broenei",
    "BO" to "Bolivië",
    "BQ" to "Karibiese Nederland",
    "BR" to "Brasilië",
    "BS" to "Bahamas",
    "BT" to "Bhoetan",
    "BV" to "Bouvet-eiland",
    "BW" to "Botswana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kokoseilande",
    "CD" to "Demokratiese Republiek van die Kongo",
    "CF" to "Sentraal-Afrikaanse Republiek",
    "CG" to "Kongo-Brazzaville",
    "CH" to "Switserland",
    "CI" to "Ivoorkus",
    "CK" to "Cookeilande",
    "CL" to "Chili",
    "CM" to "Kameroen",
    "CN" to "China",
    "CO" to "Colombië",
    "CP" to "Clippertoneiland",
    "CR" to "Costa Rica",
    "CU" to "Kuba",
    "CV" to "Kaap Verde",
    "CW" to "Curaçao",
    "CX" to "Kerseiland",
    "CY" to "Siprus",
    "CZ" to "Tsjeggië",
    "DE" to "Duitsland",
    "DG" to "Diego Garcia",
    "DJ" to "Djiboeti",
    "DK" to "Denemarke",
    "DM" to "Dominica",
    "DO" to "Dominikaanse Republiek",
    "DZ" to "Algerië",
    "EA" to "Ceuta en Melilla",
    "EC" to "Ecuador",
    "EE" to "Estland",
    "EG" to "Egipte",
    "EH" to "Wes-Sahara",
    "ER" to "Eritrea",
    "ES" to "Spanje",
    "ET" to "Ethiopië",
    "EU" to "Europese Unie",
    "EZ" to "Eurosone",
    "FI" to "Finland",
    "FJ" to "Fidji",
    "FK" to "Falklandeilande",
    "FM" to "Mikronesië",
    "FO" to "Faroëreilande",
    "FR" to "Frankryk",
    "GA" to "Gaboen",
    "GB" to "Verenigde Koninkryk",
    "GD" to "Grenada",
    "GE" to "Georgië",
    "GF" to "Frans-Guyana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Groenland",
    "GM" to "Gambië",
    "GN" to "Guinee",
    "GP" to "Guadeloupe",
    "GQ" to "Ekwatoriaal-Guinee",
    "GR" to "Griekeland",
    "GS" to "Suid-Georgië en die Suidelike Sandwicheilande",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinee-Bissau",
    "GY" to "Guyana",
    "HK" to "Hongkong SAS China",
    "HM" to "Heardeiland en McDonaldeilande",
    "HN" to "Honduras",
    "HR" to "Kroasië",
    "HT" to "Haïti",
    "HU" to "Hongarye",
    "IC" to "Kanariese Eilande",
    "ID" to "Indonesië",
    "IE" to "Ierland",
    "IL" to "Israel",
    "IM" to "Eiland Man",
    "IN" to "Indië",
    "IO" to "Brits-Indiese Oseaangebied",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Ysland",
    "IT" to "Italië",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Jordanië",
    "JP" to "Japan",
    "KE" to "Kenia",
    "KG" to "Kirgistan",
    "KH" to "Kambodja",
    "KI" to "Kiribati",
    "KM" to "Comore",
    "KN" to "Sint Kitts en Nevis",
    "KP" to "Noord-Korea",
    "KR" to "Suid-Korea",
    "KW" to "Koeweit",
    "KY" to "Kaaimanseilande",
    "KZ" to "Kazakstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "Sint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberië",
    "LS" to "Lesotho",
    "LT" to "Litaue",
    "LU" to "Luxemburg",
    "LV" to "Letland",
    "LY" to "Libië",
    "MA" to "Marokko",
    "MC" to "Monaco",
    "MD" to "Moldowa",
    "ME" to "Montenegro",
    "MF" to "Sint Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshalleilande",
    "MK" to "Noord-Macedonië",
    "ML" to "Mali",
    "MM" to "Mianmar (Birma)",
    "MN" to "Mongolië",
    "MO" to "Macau SAS China",
    "MP" to "Noord-Mariane-eilande",
    "MQ" to "Martinique",
    "MR" to "Mauritanië",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maledive",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Maleisië",
    "MZ" to "Mosambiek",
    "NA" to "Namibië",
    "NC" to "Nieu-Kaledonië",
    "NE" to "Niger",
    "NF" to "Norfolkeiland",
    "NG" to "Nigerië",
    "NI" to "Nicaragua",
    "NL" to "Nederland",
    "NO" to "Noorweë",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nieu-Seeland",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Frans-Polinesië",
    "PG" to "Papoea-Nieu-Guinee",
    "PH" to "Filippyne",
    "PK" to "Pakistan",
    "PL" to "Pole",
    "PM" to "Sint Pierre en Miquelon",
    "PN" to "Pitcairneilande",
    "PR" to "Puerto Rico",
    "PS" to "Palestynse Grondgebiede",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Katar",
    "QO" to "Afgeleë Oseanië",
    "RE" to "Réunion",
    "RO" to "Roemenië",
    "RS" to "Serwië",
    "RU" to "Rusland",
    "RW" to "Rwanda",
    "SA" to "Saoedi-Arabië",
    "SB" to "Salomonseilande",
    "SC" to "Seychelle",
    "SD" to "Soedan",
    "SE" to "Swede",
    "SG" to "Singapoer",
    "SH" to "Sint Helena",
    "SI" to "Slowenië",
    "SJ" to "Spitsbergen en Jan Mayen",
    "SK" to "Slowakye",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalië",
    "SR" to "Suriname",
    "SS" to "Suid-Soedan",
    "ST" to "São Tomé en Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Sirië",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks- en Caicoseilande",
    "TD" to "Tsjad",
    "TF" to "Franse Suidelike Gebiede",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tadjikistan",
    "TK" to "Tokelau",
    "TL" to "Oos-Timor",
    "TM" to "Turkmenistan",
    "TN" to "Tunisië",
    "TO" to "Tonga",
    "TR" to "Turkye",
    "TT" to "Trinidad en Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzanië",
    "UA" to "Oekraïne",
    "UG" to "Uganda",
    "UM" to "Klein afgeleë eilande van die VSA",
    "UN" to "Verenigde Nasies",
    "US" to "Verenigde State van Amerika",
    "UY" to "Uruguay",
    "UZ" to "Oesbekistan",
    "VA" to "Vatikaanstad",
    "VC" to "Sint Vincent en die Grenadine",
    "VE" to "Venezuela",
    "VG" to "Britse Maagde-eilande",
    "VI" to "VSA se Maagde-eilande",
    "VN" to "Viëtnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis en Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudoaksente",
    "XB" to "Pseudotweerigting",
    "XK" to "Kosovo",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Suid-Afrika",
    "ZM" to "Zambië",
    "ZW" to "Zimbabwe",
    "ZZ" to "Onbekende gebied",
  ) }

  val af_NA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val agq: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Àndolà",
    "AE" to "Yùnaetɛ Alab ɛmelɛ̀",
    "AF" to "Àfɨ̀ganìsɨ̀tân",
    "AG" to "Àntigwà à Bàbudà",
    "AI" to "Àŋgwilà",
    "AL" to "Àabɛnìa",
    "AM" to "Àmɛnyìa",
    "AO" to "Àŋgolà",
    "AR" to "Àdzɛ̀ntinà",
    "AS" to "Àmɛlekan Samwà",
    "AT" to "Usɨtɨ̀là",
    "AU" to "Ùsɨ̀tɛ̀lɛlìa",
    "AW" to "Àlubà",
    "AZ" to "Àzɨbɛ̀dzân",
    "BA" to "Bosɨnyìa à Hɛ̀zɛ̀gòvinà",
    "BB" to "Bàbadòs",
    "BD" to "Baŋgɨ̀làdɛ̂",
    "BE" to "Bɛɛdzwùm",
    "BF" to "Bùkinà Fasò",
    "BG" to "Bùugɛlìa",
    "BH" to "Bàlaen",
    "BI" to "Bùlundì",
    "BJ" to "Bɛ̀nɨ̂ŋ",
    "BM" to "Bɛ̀mudà",
    "BN" to "Bɨ̀lunè",
    "BO" to "Bòlevà",
    "BR" to "Bɨ̀làzîi",
    "BS" to "Bàhamàs",
    "BT" to "Mbutàn",
    "BW" to "Bòtɨ̀swǎnà",
    "BY" to "Bɛlàlûs",
    "BZ" to "Bɛ̀lezɨ̀",
    "CA" to "Kanadà",
    "CD" to "Dɛ̀mùkàlatì Lèkpubèlè è Kuŋgù",
    "CF" to "Sɛnta Afɨlekan Lèkpobèlè",
    "CG" to "Kuŋgù",
    "CH" to "Suezàlân",
    "CI" to "Ku Dɨ̀vûa",
    "CK" to "Chwɨla ŋ̀ Kûʔ",
    "CL" to "Chilè",
    "CM" to "Kàmàlûŋ",
    "CN" to "Chaenà",
    "CO" to "Kòlombìa",
    "CR" to "Kòsɨ̀tà Lekà",
    "CU" to "Kuuwbà",
    "CV" to "Chwɨla ŋ̀ Kɛ̀b Vɛ̂ɛ",
    "CY" to "Saekpùlù",
    "CZ" to "Chɛ̂ Lèkpubèlè",
    "DE" to "Dzamanè",
    "DJ" to "Dzìbuwtì",
    "DK" to "Dɛnɨmà",
    "DM" to "Dòmenekà",
    "DO" to "Dòmenekà Lèkpubèlè",
    "DZ" to "Àadzɛlìa",
    "EC" to "Ekwadò",
    "EE" to "Èsɨ̀tonyìa",
    "EG" to "Edzì",
    "ER" to "Èletɨ̀là",
    "ES" to "Sɨ̀kpɛ̂n",
    "ET" to "Ètyǒpìa",
    "FI" to "Fɨnlàn",
    "FJ" to "Fidzi",
    "FK" to "Chwɨlà fɨ Fakɨlàn",
    "FM" to "Maekòlòneshìa",
    "FR" to "Fàlâŋnsì",
    "GA" to "Gàbûn",
    "GB" to "Yùnaetɛ Kiŋdɔ̀m",
    "GD" to "Gɨ̀lɛnadà",
    "GE" to "Dzɔɔdzìa",
    "GF" to "Gàyanà è Fàlâŋnsì",
    "GH" to "Gaanà",
    "GI" to "Dzibɨ̀latà",
    "GL" to "Gɨ̀lenlân",
    "GM" to "Gambìa",
    "GN" to "Ginè",
    "GP" to "Gwadalukpɛ̀",
    "GQ" to "Èkwɛ̀tolia Ginè",
    "GR" to "Gɨ̀lês",
    "GT" to "Gwàtɨ̀malà",
    "GU" to "Gwam",
    "GW" to "Ginè Bìsawù",
    "GY" to "Gùyanà",
    "HN" to "Hɔndulàs",
    "HR" to "Kòwɛshìa",
    "HT" to "Hǎetì",
    "HU" to "Hɔŋgàlè",
    "ID" to "Èndòneshìa",
    "IE" to "Aelɨ̀lân",
    "IL" to "Ezɨ̀lɛ̂",
    "IN" to "Endìa",
    "IQ" to "Èlâkɨ̀",
    "IR" to "Èlân",
    "IS" to "Aesɨ̀lân",
    "IT" to "Etalè",
    "JM" to "Dzàmɛkà",
    "JO" to "Dzodàn",
    "JP" to "Dzàkpân",
    "KE" to "Kɨnyà",
    "KG" to "Kìdzisɨ̀tân",
    "KH" to "Kàmbodìa",
    "KI" to "Kèlèbati",
    "KM" to "Komolòs",
    "KN" to "Sɛ̀n Kî à Nevì",
    "KP" to "Kùulîa, Ekùw",
    "KR" to "Kùulîa, Emàm",
    "KW" to "Kùwɛ̂",
    "KY" to "Chwɨlà ŋ̀ Kaemàn",
    "KZ" to "Kàzasɨ̀tân",
    "LA" to "Làwos",
    "LB" to "Lɛbanè",
    "LC" to "Sɛ̀n Lushìa",
    "LI" to "Letɨnshɨ̀n",
    "LK" to "Sɨ̀le Laŋkà",
    "LR" to "Làebɛlìa",
    "LS" to "Lɛ̀sotù",
    "LT" to "Lètwǎnyìa",
    "LU" to "Luzɨmbùʔ",
    "LV" to "Làtɨva",
    "LY" to "Lebìa",
    "MA" to "Mòlokò",
    "MC" to "Mùnaku",
    "MD" to "Mòodovà",
    "MG" to "Màdàgasɨkà",
    "MH" to "Chwɨlà fɨ Mashà",
    "ML" to "Malè",
    "MM" to "Mǐanmà",
    "MN" to "Mùŋgolìa",
    "MP" to "Chwɨlà m̀ Màlǐanà mɨ̀ Ekùw mò",
    "MQ" to "Màtìnekì",
    "MR" to "Mùlètanyìa",
    "MS" to "Mùŋtselà",
    "MT" to "Maatà",
    "MU" to "Mùleshwɨ̀s",
    "MV" to "Màdivè",
    "MW" to "Màlawì",
    "MX" to "Mɛkɨzikù",
    "MY" to "Màlɛshìa",
    "MZ" to "Mùzàmbî",
    "NA" to "Nàmibìa",
    "NC" to "Kàlèdonyìa È fūghū",
    "NE" to "Naedzà",
    "NF" to "Chwɨlà fɨ Nufòʔ",
    "NG" to "Gɨ̀anyɨ",
    "NI" to "Nikàlagwà",
    "NL" to "Nedàlân",
    "NO" to "Noowɛ̂ɛ",
    "NP" to "Nɛkpâa",
    "NR" to "Nàwulù",
    "NU" to "Niyu",
    "NZ" to "Zìlân È fūghū",
    "OM" to "Umàn",
    "PA" to "Kpanàma",
    "PE" to "Kpɛlû",
    "PF" to "Kpoleneshìa è Fàlâŋnsì",
    "PG" to "Kpakpua Ginè È fūghū",
    "PH" to "Felèkpî",
    "PK" to "Kpakìsɨ̀tân",
    "PL" to "Kpulàn",
    "PM" to "Sɛ̀n Kpiyɛ̀ à Mikelɔŋ",
    "PN" to "Kpitɨ̀kalè",
    "PR" to "Kpǒto Leko",
    "PS" to "Adzɨmā kɨ ŋgùŋ kɨ Palɛsɨtɨnyia à kɨ Gazà kò",
    "PT" to "Kputuwgà",
    "PW" to "Kpàlawù",
    "PY" to "Kpalàgwɛ̂",
    "QA" to "Katà",
    "RE" to "Lèyunyɔ̀ŋ",
    "RO" to "Lùmanyìa",
    "RU" to "Loshìa",
    "RW" to "Lùwandà",
    "SA" to "Sawudi Alabi",
    "SB" to "Chwɨlà fɨ Solomwɨ̀n",
    "SC" to "Sɛchɛ̀lɛ̀s",
    "SD" to "Sùdân",
    "SE" to "Suedɨ̀n",
    "SG" to "Siŋgàkpôo",
    "SH" to "Sɛ̀n Èlenà",
    "SI" to "Sɨ̀lòvɨnyìa",
    "SK" to "Sɨ̀lòvɨkɨ̀a",
    "SL" to "Silìa lûŋ",
    "SM" to "Sàn Màlenù",
    "SN" to "Sɛ̀nɛ̀gâa",
    "SO" to "Sòmalìa",
    "SR" to "Sulènamè",
    "ST" to "Sawo Tɔ̀me à Kpèlènsikpɛ̀",
    "SV" to "Esàvadò",
    "SY" to "Silîa",
    "SZ" to "Shǔazìlân",
    "TC" to "Chwɨla n Tɨtê à Kaekùs",
    "TD" to "Châ",
    "TG" to "Tugù",
    "TH" to "Taelàn",
    "TJ" to "Tàdzikìsɨ̀tân",
    "TK" to "Tuwkelawù",
    "TL" to "Ês Taemò",
    "TM" to "Tekɨmènèsɨ̀tân",
    "TN" to "Tùneshìa",
    "TO" to "Tuŋgà",
    "TR" to "Teekì",
    "TT" to "Tèlenedà à Tòbagù",
    "TV" to "Tuwvalùw",
    "TW" to "Taewàn",
    "TZ" to "Tàanzanyìa",
    "UA" to "Yùkɛ̀lɛ̂",
    "UG" to "Yùgandà",
    "US" to "USA",
    "UY" to "Yulùgwɛ̂",
    "UZ" to "Yùzɨ̀bɛkìsɨ̀tân",
    "VA" to "Vatikàn Sɨ̀tɛ̂",
    "VC" to "Sɛ̀n Vinsɨ̀n à Gɨlenadi Ù tē",
    "VE" to "Vɛ̀nɛ̀zǔɛɛlà",
    "VG" to "Chwɨlà m̀ Vidzinyìa m̀ Bɨ̀letì mò",
    "VI" to "U. S. Chwɨlà fɨ Mbuʔmbu",
    "VN" to "Vìyɛnàm",
    "VU" to "Vànǔatùw",
    "WF" to "Wales à Fùwtuwnà",
    "WS" to "Sàmowà",
    "YE" to "Yɛmɛ̀n",
    "YT" to "Màyotì",
    "ZA" to "Afɨlekà ghɨ Emàm ghò",
    "ZM" to "Zambìa",
    "ZW" to "Zìmbagbɛ̀",
  ) }

  val ak: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "wiase",
    "002" to "Abibirem",
    "003" to "Amɛrika Atifi",
    "005" to "Amɛrika Anaafoɔ",
    "009" to "Osiana",
    "011" to "Abibirem Atɔeɛ Fam",
    "013" to "Amɛrika Mfimfini",
    "014" to "Abibirem Apueiɛ Fam",
    "015" to "Abibirem Atifi Fam",
    "017" to "Abibirem Mfimfini",
    "018" to "Abibirem Anaafoɔ Fam",
    "019" to "Amɛrikafoɔ",
    "021" to "Amɛrika Atifi Fam",
    "029" to "Karibia",
    "030" to "Asia Apueiɛ",
    "034" to "Asia Anaafoɔ",
    "035" to "Asia Anaafoɔ Apuieɛ",
    "039" to "Yuropu Anaafoɔ",
    "053" to "Ɔstrelia ne Asia",
    "054" to "Melanesia",
    "057" to "Micronesia Mantam",
    "061" to "Pɔlenesia",
    "142" to "Asia",
    "143" to "Asia Mfimfini",
    "145" to "Asia Atɔeɛ",
    "150" to "Yuropu",
    "151" to "Yuropu Apuieɛ",
    "154" to "Yuropu Atifi",
    "155" to "Yuropu Atɔeɛ",
    "202" to "Abibirem Mpaprɛ Anaafoɔ",
    "419" to "Laaten Amɛrika",
    "AC" to "Asɛnhyin",
    "AD" to "Andora",
    "AE" to "United Arab Emirates",
    "AF" to "Afganistan",
    "AG" to "Antigua ne Baabuda",
    "AI" to "Anguila",
    "AL" to "Albenia",
    "AM" to "Aamenia",
    "AO" to "Angola",
    "AQ" to "Antaatika",
    "AR" to "Agyɛntina",
    "AS" to "Amɛrika Samoa",
    "AT" to "Ɔstria",
    "AU" to "Ɔstrelia",
    "AW" to "Aruba",
    "AX" to "Aland Aeland",
    "AZ" to "Asabegyan",
    "BA" to "Bosnia ne Hɛzegovina",
    "BB" to "Baabados",
    "BD" to "Bangladɛhye",
    "BE" to "Bɛlgyium",
    "BF" to "Bɔkina Faso",
    "BG" to "Bɔlgeria",
    "BH" to "Baren",
    "BI" to "Burundi",
    "BJ" to "Bɛnin",
    "BL" to "St. Baatilemi",
    "BM" to "Bɛmuda",
    "BN" to "Brunae",
    "BO" to "Bolivia",
    "BQ" to "Caribbean Netherlands",
    "BR" to "Brazil",
    "BS" to "Bahama",
    "BT" to "Butan",
    "BV" to "Bouvet Island",
    "BW" to "Bɔtswana",
    "BY" to "Bɛlarus",
    "BZ" to "Beliz",
    "CA" to "Kanada",
    "CC" to "Kokoso Supɔ",
    "CD" to "Kongo Kinhyaahya",
    "CF" to "Afrika Finimfin Man",
    "CG" to "Kongo",
    "CH" to "Swetzaland",
    "CI" to "Kodivuwa",
    "CK" to "Kuk Nsupɔ",
    "CL" to "Kyili",
    "CM" to "Kamɛrun",
    "CN" to "Kyaena",
    "CO" to "Kolombia",
    "CP" to "Klepatin Aeland",
    "CR" to "Kɔsta Rika",
    "CU" to "Kuba",
    "CV" to "Kepvɛdfo Islands",
    "CW" to "Kurakaw",
    "CX" to "Buronya Supɔ",
    "CY" to "Saeprɔso",
    "CZ" to "Kyɛk",
    "DE" to "Gyaaman",
    "DG" to "Diɛgo Gaasia",
    "DJ" to "Gyibuti",
    "DK" to "Dɛnmak",
    "DM" to "Dɔmeneka",
    "DO" to "Dɔmeneka Man",
    "DZ" to "Ɔlgyeria",
    "EA" to "Ceuta ne Melilla",
    "EC" to "Yikuwedɔ",
    "EE" to "Ɛstonia",
    "EG" to "Misrim",
    "EH" to "Sahara Atɔeɛ",
    "ER" to "Ɛritrea",
    "ES" to "Spain",
    "ET" to "Ithiopia",
    "EU" to "Yuropu Nkabomkuo",
    "EZ" to "Yuropu Fam",
    "FI" to "Finland",
    "FJ" to "Figyi",
    "FK" to "Fɔkman Aeland",
    "FM" to "Maekronehyia",
    "FO" to "Faro Aeland",
    "FR" to "Franse",
    "GA" to "Gabɔn",
    "GB" to "UK",
    "GD" to "Grenada",
    "GE" to "Gyɔgyea",
    "GF" to "Frɛnkye Gayana",
    "GG" to "Guɛnse",
    "GH" to "Gaana",
    "GI" to "Gyebralta",
    "GL" to "Greenman",
    "GM" to "Gambia",
    "GN" to "Gini",
    "GP" to "Guwadelup",
    "GQ" to "Gini Ikuweta",
    "GR" to "Greekman",
    "GS" to "Gyɔɔgyia Anaafoɔ ne Sandwich Aeland Anaafoɔ",
    "GT" to "Guwatemala",
    "GU" to "Guam",
    "GW" to "Gini Bisaw",
    "GY" to "Gayana",
    "HK" to "Hɔnkɔn Kyaena",
    "HM" to "Heard ne McDonald Supɔ",
    "HN" to "Hɔnduras",
    "HR" to "Krowehyia",
    "HT" to "Heiti",
    "HU" to "Hangari",
    "IC" to "Canary Islands",
    "ID" to "Indɔnehyia",
    "IE" to "Aereland",
    "IL" to "Israe",
    "IM" to "Isle of Man",
    "IN" to "India",
    "IO" to "Britenfo Man Wɔ India Po No Mu",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Aesland",
    "IT" to "Itali",
    "JE" to "Gyɛsi",
    "JM" to "Gyameka",
    "JO" to "Gyɔdan",
    "JP" to "Gyapan",
    "KE" to "Kenya",
    "KG" to "Kɛɛgestan",
    "KH" to "Kambodia",
    "KI" to "Kiribati",
    "KM" to "Kɔmɔrɔs",
    "KN" to "Saint Kitts ne Nɛves",
    "KP" to "Korea Atifi",
    "KR" to "Korea Anaafoɔ",
    "KW" to "Kuweti",
    "KY" to "Kemanfo Islands",
    "KZ" to "Kazakstan",
    "LA" to "Laos",
    "LB" to "Lɛbanɔn",
    "LC" to "Saint Lucia",
    "LI" to "Lektenstaen",
    "LK" to "Sri Lanka",
    "LR" to "Laeberia",
    "LS" to "Lesoto",
    "LT" to "Lituwenia",
    "LU" to "Lusimbɛg",
    "LV" to "Latvia",
    "LY" to "Libya",
    "MA" to "Moroko",
    "MC" to "Monako",
    "MD" to "Mɔldova",
    "ME" to "Mɔntenegro",
    "MF" to "St. Maatin",
    "MG" to "Madagaska",
    "MH" to "Mahyaa Aeland",
    "MK" to "Mesidonia Atifi",
    "ML" to "Mali",
    "MM" to "Mayaama (Bɛɛma)",
    "MN" to "Mɔngolia",
    "MO" to "Makaw Kyaena",
    "MP" to "Mariana Atifi Fam Aeland",
    "MQ" to "Matinik",
    "MR" to "Mɔretenia",
    "MS" to "Mantserat",
    "MT" to "Mɔlta",
    "MU" to "Mɔrehyeɔs",
    "MV" to "Maldives",
    "MW" to "Malawi",
    "MX" to "Mɛksiko",
    "MY" to "Malehyia",
    "MZ" to "Mozambik",
    "NA" to "Namibia",
    "NC" to "Kaledonia Foforo",
    "NE" to "Nigyɛɛ",
    "NF" to "Norfold Supɔ",
    "NG" to "Naegyeria",
    "NI" to "Nekaraguwa",
    "NL" to "Nɛdɛland",
    "NO" to "Nɔɔwe",
    "NP" to "Nɛpal",
    "NR" to "Naworu",
    "NU" to "Niyu",
    "NZ" to "Ziland Foforo",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Frɛnkye Pɔlenehyia",
    "PG" to "Papua Gini Foforɔ",
    "PH" to "Filipin",
    "PK" to "Pakistan",
    "PL" to "Pɔland",
    "PM" to "Saint Pierre ne Miquelon",
    "PN" to "Pitkaan Nsupɔ",
    "PR" to "Puɛto Riko",
    "PS" to "Palestaen West Bank ne Gaza",
    "PT" to "Pɔtugal",
    "PW" to "Palau",
    "PY" to "Paraguae",
    "QA" to "Kata",
    "QO" to "Osiana Ano Ano",
    "RE" to "Reyuniɔn",
    "RO" to "Romenia",
    "RS" to "Sɛbia",
    "RU" to "Rɔhyea",
    "RW" to "Rewanda",
    "SA" to "Saudi Arabia",
    "SB" to "Solomɔn Aeland",
    "SC" to "Seyhyɛl",
    "SD" to "Sudan",
    "SE" to "Sweden",
    "SG" to "Singapɔ",
    "SH" to "Saint Helena",
    "SI" to "Slovinia",
    "SJ" to "Svalbard ne Jan Mayen",
    "SK" to "Slovakia",
    "SL" to "Sɛra Liɔn",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "Sudan Anaafoɔ",
    "ST" to "São Tomé ne Príncipe",
    "SV" to "Ɛl Salvadɔ",
    "SX" to "Sint Maaten",
    "SY" to "Siria",
    "SZ" to "Swaziland",
    "TA" to "Tristan da Kuna",
    "TC" to "Turks ne Caicos Islands",
    "TD" to "Kyad",
    "TF" to "Franse Anaafoɔ Nsaase",
    "TG" to "Togo",
    "TH" to "Taeland",
    "TJ" to "Tagyikistan",
    "TK" to "Tokelau",
    "TL" to "Timɔ Boka",
    "TM" to "Tɛkmɛnistan",
    "TN" to "Tunihyia",
    "TO" to "Tonga",
    "TR" to "Tɛɛki",
    "TT" to "Trinidad ne Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tansania",
    "UA" to "Ukren",
    "UG" to "Yuganda",
    "UM" to "U.S. Nkyɛnnkyɛn Supɔ Ahodoɔ",
    "UN" to "Amansan Nkabomkuo",
    "US" to "Amɛrika",
    "UY" to "Yurugwae",
    "UZ" to "Usbɛkistan",
    "VA" to "Vatican Man",
    "VC" to "Saint Vincent ne Grenadines",
    "VE" to "Venezuela",
    "VG" to "Ngresifoɔ Virgin Island",
    "VI" to "Amɛrika Virgin Islands",
    "VN" to "Viɛtnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis ne Futuna",
    "WS" to "Samoa",
    "XA" to "Anto Kasa",
    "XB" to "Anto Bidi",
    "XK" to "Kosovo",
    "YE" to "Yɛmɛn",
    "YT" to "Mayɔte",
    "ZA" to "Abibirem Anaafoɔ",
    "ZM" to "Zambia",
    "ZW" to "Zimbabue",
    "ZZ" to "Mantam a Yɛnnim",
  ) }

  val am: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "ዓለም",
    "002" to "አፍሪካ",
    "003" to "ሰሜን አሜሪካ",
    "005" to "ደቡብ አሜሪካ",
    "009" to "ኦሺያንያ",
    "011" to "ምዕራባዊ አፍሪካ",
    "013" to "መካከለኛው አሜሪካ",
    "014" to "ምስራቅ አፍሪካ",
    "015" to "ሰሜናዊ አፍሪካ",
    "017" to "መካከለኛው አፍሪካ",
    "018" to "ደቡባዊ አፍሪካ",
    "019" to "አሜሪካ",
    "021" to "ሰሜናዊ አሜሪካ",
    "029" to "ካሪቢያን",
    "030" to "ምስራቃዊ እስያ",
    "034" to "ደቡባዊ እስያ",
    "035" to "ደቡብ ምስራቅ እስያ",
    "039" to "ደቡባዊ አውሮፓ",
    "053" to "አውስትራሌዥያ",
    "054" to "ሜላኔዥያ",
    "057" to "የማይክሮኔዥያን ክልል",
    "061" to "ፖሊኔዥያ",
    "142" to "እስያ",
    "143" to "መካከለኛው እስያ",
    "145" to "ምዕራባዊ እስያ",
    "150" to "አውሮፓ",
    "151" to "ምስራቅ አውሮፓ",
    "154" to "ሰሜናዊ አውሮፓ",
    "155" to "ምዕራብ አውሮፓ",
    "202" to "ከሰሃራ በታች አፍሪካ",
    "419" to "ላቲን አሜሪካ",
    "AC" to "አሴንሽን ደሴት",
    "AD" to "አንዶራ",
    "AE" to "የተባበሩት ዓረብ ኤምሬትስ",
    "AF" to "አፍጋኒስታን",
    "AG" to "አንቲጓ እና ባርቡዳ",
    "AI" to "አንጉይላ",
    "AL" to "አልባኒያ",
    "AM" to "አርሜኒያ",
    "AO" to "አንጐላ",
    "AQ" to "አንታርክቲካ",
    "AR" to "አርጀንቲና",
    "AS" to "የአሜሪካ ሳሞአ",
    "AT" to "ኦስትሪያ",
    "AU" to "አውስትራልያ",
    "AW" to "አሩባ",
    "AX" to "የአላንድ ደሴቶች",
    "AZ" to "አዘርባጃን",
    "BA" to "ቦስኒያ እና ሄርዞጎቪኒያ",
    "BB" to "ባርቤዶስ",
    "BD" to "ባንግላዲሽ",
    "BE" to "ቤልጄም",
    "BF" to "ቡርኪና ፋሶ",
    "BG" to "ቡልጋሪያ",
    "BH" to "ባህሬን",
    "BI" to "ብሩንዲ",
    "BJ" to "ቤኒን",
    "BL" to "ሴንት ባርቴሌሚ",
    "BM" to "ቤርሙዳ",
    "BN" to "ብሩኒ",
    "BO" to "ቦሊቪያ",
    "BQ" to "የካሪቢያን ኔዘርላንድስ",
    "BR" to "ብራዚል",
    "BS" to "ባሃማስ",
    "BT" to "ቡህታን",
    "BV" to "ቡቬት ደሴት",
    "BW" to "ቦትስዋና",
    "BY" to "ቤላሩስ",
    "BZ" to "በሊዝ",
    "CA" to "ካናዳ",
    "CC" to "ኮኮስ(ኬሊንግ) ደሴቶች",
    "CD" to "ኮንጎ-ኪንሻሳ",
    "CF" to "ማዕከላዊ አፍሪካ ሪፑብሊክ",
    "CG" to "ኮንጎ ብራዛቪል",
    "CH" to "ስዊዘርላንድ",
    "CI" to "ኮትዲቯር",
    "CK" to "ኩክ ደሴቶች",
    "CL" to "ቺሊ",
    "CM" to "ካሜሩን",
    "CN" to "ቻይና",
    "CO" to "ኮሎምቢያ",
    "CP" to "ክሊፐርቶን ደሴት",
    "CR" to "ኮስታሪካ",
    "CU" to "ኩባ",
    "CV" to "ኬፕቨርዴ",
    "CW" to "ኩራሳዎ",
    "CX" to "ክሪስማስ ደሴት",
    "CY" to "ሳይፕረስ",
    "CZ" to "ቼቺያ",
    "DE" to "ጀርመን",
    "DG" to "ዲዬጎ ጋርሲያ",
    "DJ" to "ጂቡቲ",
    "DK" to "ዴንማርክ",
    "DM" to "ዶሚኒካ",
    "DO" to "ዶመኒካን ሪፑብሊክ",
    "DZ" to "አልጄሪያ",
    "EA" to "ሴኡታና ሜሊላ",
    "EC" to "ኢኳዶር",
    "EE" to "ኤስቶኒያ",
    "EG" to "ግብጽ",
    "EH" to "ምዕራባዊ ሳህራ",
    "ER" to "ኤርትራ",
    "ES" to "ስፔን",
    "ET" to "ኢትዮጵያ",
    "EU" to "የአውሮፓ ህብረት",
    "EZ" to "የዩሮ ዞን",
    "FI" to "ፊንላንድ",
    "FJ" to "ፊጂ",
    "FK" to "የፎክላንድ ደሴቶች",
    "FM" to "ማይክሮኔዢያ",
    "FO" to "የፋሮ ደሴቶች",
    "FR" to "ፈረንሳይ",
    "GA" to "ጋቦን",
    "GB" to "ዩናይትድ ኪንግደም",
    "GD" to "ግሬናዳ",
    "GE" to "ጆርጂያ",
    "GF" to "የፈረንሳይ ጉዊአና",
    "GG" to "ጉርነሲ",
    "GH" to "ጋና",
    "GI" to "ጂብራልተር",
    "GL" to "ግሪንላንድ",
    "GM" to "ጋምቢያ",
    "GN" to "ጊኒ",
    "GP" to "ጉዋደሉፕ",
    "GQ" to "ኢኳቶሪያል ጊኒ",
    "GR" to "ግሪክ",
    "GS" to "ደቡብ ጆርጂያ እና የደቡብ ሳንድዊች ደሴቶች",
    "GT" to "ጉዋቲማላ",
    "GU" to "ጉዋም",
    "GW" to "ጊኒ-ቢሳው",
    "GY" to "ጉያና",
    "HK" to "ሆንግ ኮንግ ልዩ የአስተዳደር ክልል ቻይና",
    "HM" to "ኽርድ ኣና ማክዶናልድ ደሴቶች",
    "HN" to "ሆንዱራስ",
    "HR" to "ክሮኤሽያ",
    "HT" to "ሀይቲ",
    "HU" to "ሀንጋሪ",
    "IC" to "የካናሪ ደሴቶች",
    "ID" to "ኢንዶኔዢያ",
    "IE" to "አየርላንድ",
    "IL" to "እስራኤል",
    "IM" to "አይል ኦፍ ማን",
    "IN" to "ህንድ",
    "IO" to "የብሪታኒያ ህንድ ውቂያኖስ ግዛት",
    "IQ" to "ኢራቅ",
    "IR" to "ኢራን",
    "IS" to "አይስላንድ",
    "IT" to "ጣሊያን",
    "JE" to "ጀርዚ",
    "JM" to "ጃማይካ",
    "JO" to "ጆርዳን",
    "JP" to "ጃፓን",
    "KE" to "ኬንያ",
    "KG" to "ኪርጊስታን",
    "KH" to "ካምቦዲያ",
    "KI" to "ኪሪባቲ",
    "KM" to "ኮሞሮስ",
    "KN" to "ቅዱስ ኪትስ እና ኔቪስ",
    "KP" to "ሰሜን ኮሪያ",
    "KR" to "ደቡብ ኮሪያ",
    "KW" to "ኩዌት",
    "KY" to "ካይማን ደሴቶች",
    "KZ" to "ካዛኪስታን",
    "LA" to "ላኦስ",
    "LB" to "ሊባኖስ",
    "LC" to "ሴንት ሉቺያ",
    "LI" to "ሊችተንስታይን",
    "LK" to "ሲሪላንካ",
    "LR" to "ላይቤሪያ",
    "LS" to "ሌሶቶ",
    "LT" to "ሊቱዌኒያ",
    "LU" to "ሉክሰምበርግ",
    "LV" to "ላትቪያ",
    "LY" to "ሊቢያ",
    "MA" to "ሞሮኮ",
    "MC" to "ሞናኮ",
    "MD" to "ሞልዶቫ",
    "ME" to "ሞንተኔግሮ",
    "MF" to "ሴንት ማርቲን",
    "MG" to "ማዳጋስካር",
    "MH" to "ማርሻል ደሴቶች",
    "MK" to "ሰሜን መቄዶንያ",
    "ML" to "ማሊ",
    "MM" to "ማይናማር(በርማ)",
    "MN" to "ሞንጎሊያ",
    "MO" to "ማካኦ ልዩ የአስተዳደር ክልል ቻይና",
    "MP" to "የሰሜናዊ ማሪያና ደሴቶች",
    "MQ" to "ማርቲኒክ",
    "MR" to "ሞሪቴኒያ",
    "MS" to "ሞንትሴራት",
    "MT" to "ማልታ",
    "MU" to "ሞሪሸስ",
    "MV" to "ማልዲቭስ",
    "MW" to "ማላዊ",
    "MX" to "ሜክሲኮ",
    "MY" to "ማሌዢያ",
    "MZ" to "ሞዛምቢክ",
    "NA" to "ናሚቢያ",
    "NC" to "ኒው ካሌዶኒያ",
    "NE" to "ኒጀር",
    "NF" to "ኖርፎልክ ደሴት",
    "NG" to "ናይጄሪያ",
    "NI" to "ኒካራጓ",
    "NL" to "ኔዘርላንድ",
    "NO" to "ኖርዌይ",
    "NP" to "ኔፓል",
    "NR" to "ናኡሩ",
    "NU" to "ኒዌ",
    "NZ" to "ኒው ዚላንድ",
    "OM" to "ኦማን",
    "PA" to "ፓናማ",
    "PE" to "ፔሩ",
    "PF" to "የፈረንሳይ ፖሊኔዢያ",
    "PG" to "ፓፑዋ ኒው ጊኒ",
    "PH" to "ፊሊፒንስ",
    "PK" to "ፓኪስታን",
    "PL" to "ፖላንድ",
    "PM" to "ሴንት ፒዬር እና ሚኩኤሎን",
    "PN" to "ፒትካኢርን ደሴቶች",
    "PR" to "ፑዌርቶ ሪኮ",
    "PS" to "የፍልስጤም ግዛት",
    "PT" to "ፖርቱጋል",
    "PW" to "ፓላው",
    "PY" to "ፓራጓይ",
    "QA" to "ኳታር",
    "QO" to "የኦሺያንያ ዳርቻ",
    "RE" to "ሪዩኒየን",
    "RO" to "ሮሜኒያ",
    "RS" to "ሰርብያ",
    "RU" to "ሩስያ",
    "RW" to "ሩዋንዳ",
    "SA" to "ሳውድአረቢያ",
    "SB" to "ሰለሞን ደሴቶች",
    "SC" to "ሲሼልስ",
    "SD" to "ሱዳን",
    "SE" to "ስዊድን",
    "SG" to "ሲንጋፖር",
    "SH" to "ሴንት ሄለና",
    "SI" to "ስሎቬኒያ",
    "SJ" to "ስቫልባርድ እና ጃን ማየን",
    "SK" to "ስሎቫኪያ",
    "SL" to "ሴራሊዮን",
    "SM" to "ሳን ማሪኖ",
    "SN" to "ሴኔጋል",
    "SO" to "ሶማሊያ",
    "SR" to "ሱሪናም",
    "SS" to "ደቡብ ሱዳን",
    "ST" to "ሳኦ ቶሜ እና ፕሪንሲፔ",
    "SV" to "ኤል ሳልቫዶር",
    "SX" to "ሲንት ማርተን",
    "SY" to "ሶሪያ",
    "SZ" to "ኤስዋቲኒ",
    "TA" to "ትሪስታን ዳ ኩንሃ",
    "TC" to "የቱርኮችና የካኢኮስ ደሴቶች",
    "TD" to "ቻድ",
    "TF" to "የፈረንሳይ ደቡባዊ ግዛቶች",
    "TG" to "ቶጐ",
    "TH" to "ታይላንድ",
    "TJ" to "ታጃኪስታን",
    "TK" to "ቶክላው",
    "TL" to "ቲሞር ሌስቴ",
    "TM" to "ቱርክሜኒስታን",
    "TN" to "ቱኒዚያ",
    "TO" to "ቶንጋ",
    "TR" to "ቱርክ",
    "TT" to "ትሪናዳድ እና ቶቤጎ",
    "TV" to "ቱቫሉ",
    "TW" to "ታይዋን",
    "TZ" to "ታንዛኒያ",
    "UA" to "ዩክሬን",
    "UG" to "ዩጋንዳ",
    "UM" to "የዩ ኤስ ጠረፍ ላይ ያሉ ደሴቶች",
    "UN" to "የተባበሩት መንግስታት",
    "US" to "ዩናይትድ ስቴትስ",
    "UY" to "ኡራጓይ",
    "UZ" to "ኡዝቤኪስታን",
    "VA" to "ቫቲካን ከተማ",
    "VC" to "ሴንት ቪንሴንት እና ግሬናዲንስ",
    "VE" to "ቬንዙዌላ",
    "VG" to "የእንግሊዝ ቨርጂን ደሴቶች",
    "VI" to "የአሜሪካ ቨርጂን ደሴቶች",
    "VN" to "ቬትናም",
    "VU" to "ቫኑአቱ",
    "WF" to "ዋሊስ እና ፉቱና ደሴቶች",
    "WS" to "ሳሞአ",
    "XA" to "የሀሰት ትእምርት",
    "XB" to "የሀሰት ባለሁለት አቅጣጫ",
    "XK" to "ኮሶቮ",
    "YE" to "የመን",
    "YT" to "ሜይኦቴ",
    "ZA" to "ደቡብ አፍሪካ",
    "ZM" to "ዛምቢያ",
    "ZW" to "ዚምቧቤ",
    "ZZ" to "ያልታወቀ ክልል",
  ) }

  val ar: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "العالم",
    "002" to "أفريقيا",
    "003" to "أمريكا الشمالية",
    "005" to "أمريكا الجنوبية",
    "009" to "أوقيانوسيا",
    "011" to "غرب أفريقيا",
    "013" to "أمريكا الوسطى",
    "014" to "شرق أفريقيا",
    "015" to "شمال أفريقيا",
    "017" to "وسط أفريقيا",
    "018" to "أفريقيا الجنوبية",
    "019" to "الأمريكتان",
    "021" to "شمال أمريكا",
    "029" to "الكاريبي",
    "030" to "شرق آسيا",
    "034" to "جنوب آسيا",
    "035" to "جنوب شرق آسيا",
    "039" to "جنوب أوروبا",
    "053" to "أسترالاسيا",
    "054" to "ميلانيزيا",
    "057" to "الجزر الميكرونيزية",
    "061" to "بولينيزيا",
    "142" to "آسيا",
    "143" to "وسط آسيا",
    "145" to "غرب آسيا",
    "150" to "أوروبا",
    "151" to "شرق أوروبا",
    "154" to "شمال أوروبا",
    "155" to "غرب أوروبا",
    "202" to "أفريقيا جنوب الصحراء الكبرى",
    "419" to "أمريكا اللاتينية",
    "AC" to "جزيرة أسينشيون",
    "AD" to "أندورا",
    "AE" to "الإمارات العربية المتحدة",
    "AF" to "أفغانستان",
    "AG" to "أنتيغوا وبربودا",
    "AI" to "أنغويلا",
    "AL" to "ألبانيا",
    "AM" to "أرمينيا",
    "AO" to "أنغولا",
    "AQ" to "أنتاركتيكا",
    "AR" to "الأرجنتين",
    "AS" to "ساموا الأمريكية",
    "AT" to "النمسا",
    "AU" to "أستراليا",
    "AW" to "أروبا",
    "AX" to "جزر آلاند",
    "AZ" to "أذربيجان",
    "BA" to "البوسنة والهرسك",
    "BB" to "بربادوس",
    "BD" to "بنغلاديش",
    "BE" to "بلجيكا",
    "BF" to "بوركينا فاسو",
    "BG" to "بلغاريا",
    "BH" to "البحرين",
    "BI" to "بوروندي",
    "BJ" to "بنين",
    "BL" to "سان بارتليمي",
    "BM" to "برمودا",
    "BN" to "بروناي",
    "BO" to "بوليفيا",
    "BQ" to "هولندا الكاريبية",
    "BR" to "البرازيل",
    "BS" to "جزر البهاما",
    "BT" to "بوتان",
    "BV" to "جزيرة بوفيه",
    "BW" to "بوتسوانا",
    "BY" to "بيلاروس",
    "BZ" to "بليز",
    "CA" to "كندا",
    "CC" to "جزر كوكوس (كيلينغ)",
    "CD" to "الكونغو - كينشاسا",
    "CF" to "جمهورية أفريقيا الوسطى",
    "CG" to "الكونغو - برازافيل",
    "CH" to "سويسرا",
    "CI" to "ساحل العاج",
    "CK" to "جزر كوك",
    "CL" to "تشيلي",
    "CM" to "الكاميرون",
    "CN" to "الصين",
    "CO" to "كولومبيا",
    "CP" to "جزيرة كليبيرتون",
    "CR" to "كوستاريكا",
    "CU" to "كوبا",
    "CV" to "الرأس الأخضر",
    "CW" to "كوراساو",
    "CX" to "جزيرة كريسماس",
    "CY" to "قبرص",
    "CZ" to "التشيك",
    "DE" to "ألمانيا",
    "DG" to "دييغو غارسيا",
    "DJ" to "جيبوتي",
    "DK" to "الدانمرك",
    "DM" to "دومينيكا",
    "DO" to "جمهورية الدومينيكان",
    "DZ" to "الجزائر",
    "EA" to "سيوتا وميليلا",
    "EC" to "الإكوادور",
    "EE" to "إستونيا",
    "EG" to "مصر",
    "EH" to "الصحراء الغربية",
    "ER" to "إريتريا",
    "ES" to "إسبانيا",
    "ET" to "إثيوبيا",
    "EU" to "الاتحاد الأوروبي",
    "EZ" to "منطقة اليورو",
    "FI" to "فنلندا",
    "FJ" to "فيجي",
    "FK" to "جزر فوكلاند",
    "FM" to "ميكرونيزيا",
    "FO" to "جزر فارو",
    "FR" to "فرنسا",
    "GA" to "الغابون",
    "GB" to "المملكة المتحدة",
    "GD" to "غرينادا",
    "GE" to "جورجيا",
    "GF" to "غويانا الفرنسية",
    "GG" to "غيرنزي",
    "GH" to "غانا",
    "GI" to "جبل طارق",
    "GL" to "غرينلاند",
    "GM" to "غامبيا",
    "GN" to "غينيا",
    "GP" to "غوادلوب",
    "GQ" to "غينيا الاستوائية",
    "GR" to "اليونان",
    "GS" to "جورجيا الجنوبية وجزر ساندويتش الجنوبية",
    "GT" to "غواتيمالا",
    "GU" to "غوام",
    "GW" to "غينيا بيساو",
    "GY" to "غيانا",
    "HK" to "هونغ كونغ الصينية (منطقة إدارية خاصة)",
    "HM" to "جزيرة هيرد وجزر ماكدونالد",
    "HN" to "هندوراس",
    "HR" to "كرواتيا",
    "HT" to "هايتي",
    "HU" to "هنغاريا",
    "IC" to "جزر الكناري",
    "ID" to "إندونيسيا",
    "IE" to "أيرلندا",
    "IL" to "إسرائيل",
    "IM" to "جزيرة مان",
    "IN" to "الهند",
    "IO" to "الإقليم البريطاني في المحيط الهندي",
    "IQ" to "العراق",
    "IR" to "إيران",
    "IS" to "آيسلندا",
    "IT" to "إيطاليا",
    "JE" to "جيرسي",
    "JM" to "جامايكا",
    "JO" to "الأردن",
    "JP" to "اليابان",
    "KE" to "كينيا",
    "KG" to "قيرغيزستان",
    "KH" to "كمبوديا",
    "KI" to "كيريباتي",
    "KM" to "جزر القمر",
    "KN" to "سانت كيتس ونيفيس",
    "KP" to "كوريا الشمالية",
    "KR" to "كوريا الجنوبية",
    "KW" to "الكويت",
    "KY" to "جزر كايمان",
    "KZ" to "كازاخستان",
    "LA" to "لاوس",
    "LB" to "لبنان",
    "LC" to "سانت لوسيا",
    "LI" to "ليختنشتاين",
    "LK" to "سريلانكا",
    "LR" to "ليبيريا",
    "LS" to "ليسوتو",
    "LT" to "ليتوانيا",
    "LU" to "لوكسمبورغ",
    "LV" to "لاتفيا",
    "LY" to "ليبيا",
    "MA" to "المغرب",
    "MC" to "موناكو",
    "MD" to "مولدوفا",
    "ME" to "الجبل الأسود",
    "MF" to "سان مارتن",
    "MG" to "مدغشقر",
    "MH" to "جزر مارشال",
    "MK" to "مقدونيا الشمالية",
    "ML" to "مالي",
    "MM" to "ميانمار (بورما)",
    "MN" to "منغوليا",
    "MO" to "منطقة ماكاو الإدارية الخاصة",
    "MP" to "جزر ماريانا الشمالية",
    "MQ" to "جزر المارتينيك",
    "MR" to "موريتانيا",
    "MS" to "مونتسرات",
    "MT" to "مالطا",
    "MU" to "موريشيوس",
    "MV" to "جزر المالديف",
    "MW" to "ملاوي",
    "MX" to "المكسيك",
    "MY" to "ماليزيا",
    "MZ" to "موزمبيق",
    "NA" to "ناميبيا",
    "NC" to "كاليدونيا الجديدة",
    "NE" to "النيجر",
    "NF" to "جزيرة نورفولك",
    "NG" to "نيجيريا",
    "NI" to "نيكاراغوا",
    "NL" to "هولندا",
    "NO" to "النرويج",
    "NP" to "نيبال",
    "NR" to "ناورو",
    "NU" to "نيوي",
    "NZ" to "نيوزيلندا",
    "OM" to "عُمان",
    "PA" to "بنما",
    "PE" to "بيرو",
    "PF" to "بولينيزيا الفرنسية",
    "PG" to "بابوا غينيا الجديدة",
    "PH" to "الفلبين",
    "PK" to "باكستان",
    "PL" to "بولندا",
    "PM" to "سان بيير ومكويلون",
    "PN" to "جزر بيتكيرن",
    "PR" to "بورتوريكو",
    "PS" to "الأراضي الفلسطينية",
    "PT" to "البرتغال",
    "PW" to "بالاو",
    "PY" to "باراغواي",
    "QA" to "قطر",
    "QO" to "أوقيانوسيا النائية",
    "RE" to "روينيون",
    "RO" to "رومانيا",
    "RS" to "صربيا",
    "RU" to "روسيا",
    "RW" to "رواندا",
    "SA" to "المملكة العربية السعودية",
    "SB" to "جزر سليمان",
    "SC" to "سيشل",
    "SD" to "السودان",
    "SE" to "السويد",
    "SG" to "سنغافورة",
    "SH" to "سانت هيلينا",
    "SI" to "سلوفينيا",
    "SJ" to "سفالبارد وجان ماين",
    "SK" to "سلوفاكيا",
    "SL" to "سيراليون",
    "SM" to "سان مارينو",
    "SN" to "السنغال",
    "SO" to "الصومال",
    "SR" to "سورينام",
    "SS" to "جنوب السودان",
    "ST" to "ساو تومي وبرينسيبي",
    "SV" to "السلفادور",
    "SX" to "سانت مارتن",
    "SY" to "سوريا",
    "SZ" to "إسواتيني",
    "TA" to "تريستان دا كونا",
    "TC" to "جزر توركس وكايكوس",
    "TD" to "تشاد",
    "TF" to "الأقاليم الجنوبية الفرنسية",
    "TG" to "توغو",
    "TH" to "تايلاند",
    "TJ" to "طاجيكستان",
    "TK" to "توكيلاو",
    "TL" to "تيمور - ليشتي",
    "TM" to "تركمانستان",
    "TN" to "تونس",
    "TO" to "تونغا",
    "TR" to "تركيا",
    "TT" to "ترينيداد وتوباغو",
    "TV" to "توفالو",
    "TW" to "تايوان",
    "TZ" to "تنزانيا",
    "UA" to "أوكرانيا",
    "UG" to "أوغندا",
    "UM" to "جزر الولايات المتحدة النائية",
    "UN" to "الأمم المتحدة",
    "US" to "الولايات المتحدة",
    "UY" to "أورغواي",
    "UZ" to "أوزبكستان",
    "VA" to "الفاتيكان",
    "VC" to "سانت فنسنت وجزر غرينادين",
    "VE" to "فنزويلا",
    "VG" to "جزر فيرجن البريطانية",
    "VI" to "جزر فيرجن الأمريكية",
    "VN" to "فيتنام",
    "VU" to "فانواتو",
    "WF" to "جزر والس وفوتونا",
    "WS" to "ساموا",
    "XA" to "لكنات تجريبية غير أصلية",
    "XB" to "لكنات تجريبية ثنائية الاتجاه",
    "XK" to "كوسوفو",
    "YE" to "اليمن",
    "YT" to "مايوت",
    "ZA" to "جنوب أفريقيا",
    "ZM" to "زامبيا",
    "ZW" to "زيمبابوي",
    "ZZ" to "منطقة غير معروفة",
  ) }

  val ar_AE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_BH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_DJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_DZ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_EG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_EH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_ER: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_IL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_IQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_JO: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_KM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_KW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_LB: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_LY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "EA" to "سبتة ومليلية",
    "MS" to "مونتيسيرات",
    "UY" to "أوروغواي",
  ) }

  val ar_MA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_OM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_PS: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_QA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AC" to "جزيرة أسينشين",
    "EA" to "سبتة ومليلية",
    "MO" to "ماكاو الصينية (منطقة إدارية خاصة)",
    "MS" to "مونتيسيرات",
    "UY" to "أوروغواي",
  ) }

  val ar_SD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SO: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SS: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SY: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_TD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_TN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_YE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val `as`: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "বিশ্ব",
    "002" to "আফ্ৰিকা",
    "003" to "উত্তৰ আমেৰিকা",
    "005" to "দক্ষিণ আমেৰিকা",
    "009" to "অ’চেনীয়া",
    "011" to "পাশ্চাত্য আফ্ৰিকা",
    "013" to "মধ্য আমেৰিকা",
    "014" to "প্ৰাচ্য আফ্ৰিকা",
    "015" to "উদীচ্য আফ্ৰিকা",
    "017" to "মধ্য আফ্ৰিকা",
    "018" to "দাক্ষিণাত্য আফ্ৰিকা",
    "019" to "আমেৰিকাছ্",
    "021" to "উদীচ্য আমেৰিকা",
    "029" to "কেৰিবিয়ান",
    "030" to "প্ৰাচ্য এছিয়া",
    "034" to "দাক্ষিণাত্য এছিয়া",
    "035" to "দক্ষিণ-পূব এছিয়া",
    "039" to "দাক্ষিণাত্য ইউৰোপ",
    "053" to "অষ্ট্ৰেলেছিয়া",
    "054" to "মেলানেছিয়া",
    "057" to "মাইক্ৰোনেচিয় ক্ষেত্ৰ",
    "061" to "পলিনেচিয়া",
    "142" to "এছিয়া",
    "143" to "মধ্য এছিয়া",
    "145" to "পাশ্চাত্য এছিয়া",
    "150" to "ইউৰোপ",
    "151" to "প্ৰাচ্য ইউৰোপ",
    "154" to "উদীচ্য ইউৰোপ",
    "155" to "পাশ্চাত্য ইউৰোপ",
    "202" to "উপ-ছাহাৰান আফ্ৰিকা",
    "419" to "লেটিন আমেৰিকা",
    "AC" to "এচেনচিয়ন দ্বীপ",
    "AD" to "আন্দোৰা",
    "AE" to "সংযুক্ত আৰব আমিৰাত",
    "AF" to "আফগানিস্তান",
    "AG" to "এণ্টিগুৱা আৰু বাৰ্বুডা",
    "AI" to "এনগুইলা",
    "AL" to "আলবেনিয়া",
    "AM" to "আৰ্মেনিয়া",
    "AO" to "এংগোলা",
    "AQ" to "এণ্টাৰ্কটিকা",
    "AR" to "আৰ্জেণ্টিনা",
    "AS" to "আমেৰিকান চামোৱা",
    "AT" to "অষ্ট্ৰিয়া",
    "AU" to "অষ্ট্ৰেলিয়া",
    "AW" to "আৰুবা",
    "AX" to "আলণ্ড দ্বীপপুঞ্জ",
    "AZ" to "আজাৰবেইজান",
    "BA" to "ব’ছনিয়া আৰু হাৰ্জেগ’ভিনা",
    "BB" to "বাৰ্বাডোচ",
    "BD" to "বাংলাদেশ",
    "BE" to "বেলজিয়াম",
    "BF" to "বুৰকিনা ফাচো",
    "BG" to "বুলগেৰিয়া",
    "BH" to "বাহৰেইন",
    "BI" to "বুৰুণ্ডি",
    "BJ" to "বেনিন",
    "BL" to "ছেইণ্ট বাৰ্থলেমে",
    "BM" to "বাৰ্মুডা",
    "BN" to "ব্ৰুনেই",
    "BO" to "বলিভিয়া",
    "BQ" to "কেৰিবিয়ান নেদাৰলেণ্ডছ",
    "BR" to "ব্ৰাজিল",
    "BS" to "বাহামাছ",
    "BT" to "ভুটান",
    "BV" to "বুভে দ্বীপ",
    "BW" to "ব’টচোৱানা",
    "BY" to "বেলাৰুছ",
    "BZ" to "বেলিজ",
    "CA" to "কানাডা",
    "CC" to "কোকোচ (কীলিং) দ্বীপপুঞ্জ",
    "CD" to "কঙ্গো - কিনচাছা",
    "CF" to "মধ্য আফ্রিকান প্রজাতন্ত্র",
    "CG" to "কঙ্গো - ব্রাজাভিল",
    "CH" to "চুইজাৰলেণ্ড",
    "CI" to "কোটে ডি আইভৰ",
    "CK" to "কুক দ্বীপপুঞ্জ",
    "CL" to "চিলি",
    "CM" to "কেমেৰুণ",
    "CN" to "চীন",
    "CO" to "কলম্বিয়া",
    "CP" to "ক্লিপাৰটোন দ্বীপ",
    "CR" to "কোষ্টা ৰিকা",
    "CU" to "কিউবা",
    "CV" to "কেপ ভার্দে",
    "CW" to "কুৰাকাও",
    "CX" to "খ্ৰীষ্টমাছ দ্বীপ",
    "CY" to "চাইপ্ৰাছ",
    "CZ" to "চিজেচিয়া",
    "DE" to "জাৰ্মানী",
    "DG" to "ডিয়েগো গাৰ্চিয়া",
    "DJ" to "জিবুটি",
    "DK" to "ডেনমাৰ্ক",
    "DM" to "ড’মিনিকা",
    "DO" to "ড’মিনিকান ৰিপাব্লিক",
    "DZ" to "আলজেৰিয়া",
    "EA" to "চেউটা আৰু মেলিলা",
    "EC" to "ইকুৱেডৰ",
    "EE" to "ইষ্টোনিয়া",
    "EG" to "ইজিপ্ত",
    "EH" to "পশ্চিমীয় ছাহাৰা",
    "ER" to "এৰিত্ৰিয়া",
    "ES" to "স্পেইন",
    "ET" to "ইথিঅ’পিয়া",
    "EU" to "ইউৰোপীয় সংঘ",
    "EZ" to "ইউৰোজ’ন",
    "FI" to "ফিনলেণ্ড",
    "FJ" to "ফিজি",
    "FK" to "ফকলেণ্ড দ্বীপপুঞ্জ",
    "FM" to "মাইক্ৰোনেচিয়া",
    "FO" to "ফাৰো দ্বীপপুঞ্জ",
    "FR" to "ফ্ৰান্স",
    "GA" to "গেবন",
    "GB" to "সংযুক্ত ৰাজ্য",
    "GD" to "গ্ৰেনাডা",
    "GE" to "জৰ্জিয়া",
    "GF" to "ফ্ৰান্স গয়ানা",
    "GG" to "গোৰেনচি",
    "GH" to "ঘানা",
    "GI" to "জিব্ৰাল্টৰ",
    "GL" to "গ্ৰীণলেণ্ড",
    "GM" to "গাম্বিয়া",
    "GN" to "গিনি",
    "GP" to "গুৱাডেলুপ",
    "GQ" to "ইকুৱেটৰিয়েল গিনি",
    "GR" to "গ্ৰীচ",
    "GS" to "দক্ষিণ জৰ্জিয়া আৰু দক্ষিণ চেণ্ডৱিচ দ্বীপপুঞ্জ",
    "GT" to "গুৱাটেমালা",
    "GU" to "গুৱাম",
    "GW" to "গিনি-বিছাও",
    "GY" to "গায়ানা",
    "HK" to "হং কং এছ. এ. আৰ. চীন",
    "HM" to "হাৰ্ড দ্বীপ আৰু মেকডোনাল্ড দ্বীপপুঞ্জ",
    "HN" to "হন্দুৰাছ",
    "HR" to "ক্ৰোৱেছিয়া",
    "HT" to "হাইটি",
    "HU" to "হাংগেৰী",
    "IC" to "কেনেৰী দ্বীপপুঞ্জ",
    "ID" to "ইণ্ডোনেচিয়া",
    "IE" to "আয়াৰলেণ্ড",
    "IL" to "ইজৰাইল",
    "IM" to "আইল অফ মেন",
    "IN" to "ভাৰত",
    "IO" to "ব্ৰিটিছ ইণ্ডিয়ান অ’চন টেৰিট’ৰি",
    "IQ" to "ইৰাক",
    "IR" to "ইৰান",
    "IS" to "আইচলেণ্ড",
    "IT" to "ইটালি",
    "JE" to "জাৰ্চি",
    "JM" to "জামাইকা",
    "JO" to "জৰ্ডান",
    "JP" to "জাপান",
    "KE" to "কেনিয়া",
    "KG" to "কিৰ্গিজস্তান",
    "KH" to "কম্বোডিয়া",
    "KI" to "কিৰিবাটি",
    "KM" to "কোমোৰোজ",
    "KN" to "ছেইণ্ট কিটছ আৰু নেভিছ",
    "KP" to "উত্তৰ কোৰিয়া",
    "KR" to "দক্ষিণ কোৰিয়া",
    "KW" to "কুৱেইট",
    "KY" to "কেইমেন দ্বীপপুঞ্জ",
    "KZ" to "কাজাখাস্তান",
    "LA" to "লাওচ",
    "LB" to "লেবানন",
    "LC" to "ছেইণ্ট লুচিয়া",
    "LI" to "লিচটেনষ্টেইন",
    "LK" to "শ্রীলংকা",
    "LR" to "লিবেৰিয়া",
    "LS" to "লেছ’থ’",
    "LT" to "লিথুৱানিয়া",
    "LU" to "লাক্সেমবাৰ্গ",
    "LV" to "লাটভিয়া",
    "LY" to "লিবিয়া",
    "MA" to "মৰক্কো",
    "MC" to "মোনাকো",
    "MD" to "মোলডোভা",
    "ME" to "মণ্টেনেগ্ৰু",
    "MF" to "ছেইণ্ট মাৰ্টিন",
    "MG" to "মাদাগাস্কাৰ",
    "MH" to "মাৰ্শ্বাল দ্বীপপুঞ্জ",
    "MK" to "উত্তৰ মেচিডোনীয়া",
    "ML" to "মালি",
    "MM" to "ম্যানমাৰ (বাৰ্মা)",
    "MN" to "মঙ্গোলিয়া",
    "MO" to "মাকাও এছ. এ. আৰ. চীন",
    "MP" to "উত্তৰ মাৰিয়ানা দ্বীপপুঞ্জ",
    "MQ" to "মাৰ্টিনিক",
    "MR" to "মাউৰিটানিয়া",
    "MS" to "ম’ণ্টছেৰাট",
    "MT" to "মাল্টা",
    "MU" to "মৰিছাছ",
    "MV" to "মালদ্বীপ",
    "MW" to "মালাৱি",
    "MX" to "মেক্সিকো",
    "MY" to "মালয়েচিয়া",
    "MZ" to "ম’জামবিক",
    "NA" to "নামিবিয়া",
    "NC" to "নিউ কেলিডোনিয়া",
    "NE" to "নাইজাৰ",
    "NF" to "ন’ৰফ’ক দ্বীপ",
    "NG" to "নাইজেৰিয়া",
    "NI" to "নিকাৰাগুৱা",
    "NL" to "নেডাৰলেণ্ড",
    "NO" to "নৰৱে",
    "NP" to "নেপাল",
    "NR" to "নাউৰু",
    "NU" to "নিউ",
    "NZ" to "নিউজিলেণ্ড",
    "OM" to "ওমান",
    "PA" to "পানামা",
    "PE" to "পেৰু",
    "PF" to "ফ্ৰান্স পোলেনচিয়া",
    "PG" to "পাপুৱা নিউ গিনি",
    "PH" to "ফিলিপাইনছ",
    "PK" to "পাকিস্তান",
    "PL" to "পোলেণ্ড",
    "PM" to "ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলন",
    "PN" to "পিটকেইৰ্ণ দ্বীপপুঞ্জ",
    "PR" to "পুৱেৰ্টো ৰিকো",
    "PS" to "ফিলিস্তিন অঞ্চল",
    "PT" to "পৰ্তুগাল",
    "PW" to "পালাউ",
    "PY" to "পাৰাগুৱে",
    "QA" to "কাটাৰ",
    "QO" to "আউটলায়িং অ’চিয়ানিয়া",
    "RE" to "ৰিইউনিয়ন",
    "RO" to "ৰোমানিয়া",
    "RS" to "ছাৰ্বিয়া",
    "RU" to "ৰাছিয়া",
    "RW" to "ৰোৱাণ্ডা",
    "SA" to "চৌডি আৰবিয়া",
    "SB" to "চোলোমোন দ্বীপপুঞ্জ",
    "SC" to "ছিচিলিছ",
    "SD" to "চুডান",
    "SE" to "চুইডেন",
    "SG" to "ছিংগাপুৰ",
    "SH" to "ছেইণ্ট হেলেনা",
    "SI" to "শ্লোভেনিয়া",
    "SJ" to "চাভালবাৰ্ড আৰু জন মেয়ন",
    "SK" to "শ্লোভাকিয়া",
    "SL" to "চিয়েৰা লিঅ’ন",
    "SM" to "চান মাৰিনো",
    "SN" to "চেনেগাল",
    "SO" to "চোমালিয়া",
    "SR" to "ছুৰিনাম",
    "SS" to "দক্ষিণ চুডান",
    "ST" to "চাও টোমে আৰু প্ৰিনচিপে",
    "SV" to "এল ছেলভেড’ৰ",
    "SX" to "চিণ্ট মাৰ্টেন",
    "SY" to "চিৰিয়া",
    "SZ" to "ইচ্চুটিনি",
    "TA" to "ত্ৰিস্তান দ্যা কুনহা",
    "TC" to "টাৰ্কছ অৰু কেইক’ছ দ্বীপপুঞ্জ",
    "TD" to "চাড",
    "TF" to "দক্ষিণ ফ্ৰান্সৰ অঞ্চল",
    "TG" to "টোগো",
    "TH" to "থাইলেণ্ড",
    "TJ" to "তাজিকিস্তান",
    "TK" to "টোকেলাউ",
    "TL" to "টিমোৰ-লেচটে",
    "TM" to "তুৰ্কমেনিস্তান",
    "TN" to "টুনিচিয়া",
    "TO" to "টংগা",
    "TR" to "তুৰ্কিয়ে",
    "TT" to "ট্ৰিনিডাড আৰু টোবাগো",
    "TV" to "টুভালু",
    "TW" to "টাইৱান",
    "TZ" to "তাঞ্জানিয়া",
    "UA" to "ইউক্ৰেইন",
    "UG" to "উগাণ্ডা",
    "UM" to "ইউ. এছ. আউটলায়িং দ্বীপপুঞ্জ",
    "UN" to "ৰাষ্ট্ৰসংঘ",
    "US" to "মাৰ্কিন যুক্তৰাষ্ট্ৰ",
    "UY" to "উৰুগুৱে",
    "UZ" to "উজবেকিস্তান",
    "VA" to "ভেটিকান চিটি",
    "VC" to "ছেইণ্ট ভিনচেণ্ট আৰু গ্ৰীণাডাইনছ",
    "VE" to "ভেনিজুৱেলা",
    "VG" to "ব্ৰিটিছ ভাৰ্জিন দ্বীপপুঞ্জ",
    "VI" to "ইউ. এছ. ভাৰ্জিন দ্বীপপুঞ্জ",
    "VN" to "ভিয়েটনাম",
    "VU" to "ভানাটু",
    "WF" to "ৱালিছ আৰু ফুটুনা",
    "WS" to "চামোৱা",
    "XA" to "ছুডু-একচেণ্ট",
    "XB" to "ছুডু-বিডি",
    "XK" to "কচ’ভ’",
    "YE" to "য়েমেন",
    "YT" to "মায়োট্টে",
    "ZA" to "দক্ষিণ আফ্রিকা",
    "ZM" to "জাম্বিয়া",
    "ZW" to "জিম্বাবৱে",
    "ZZ" to "অজ্ঞাত ক্ষেত্ৰ",
  ) }

  val asa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Falme dha Kiarabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AR" to "Ajentina",
    "AS" to "Thamoa ya Marekani",
    "AT" to "Authtria",
    "AU" to "Authtralia",
    "AW" to "Aruba",
    "AZ" to "Adhabajani",
    "BA" to "Bothnia na Hedhegovina",
    "BB" to "Babadothi",
    "BD" to "Bangladeshi",
    "BE" to "Ubelgiji",
    "BF" to "Bukinafatho",
    "BG" to "Bulgaria",
    "BH" to "Bahareni",
    "BI" to "Burundi",
    "BJ" to "Benini",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BR" to "Brazili",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botthwana",
    "BY" to "Belaruthi",
    "BZ" to "Belidhe",
    "CA" to "Kanada",
    "CD" to "Jamhuri ya Kidemokrathia ya Kongo",
    "CF" to "Jamhuri ya Afrika ya Kati",
    "CG" to "Kongo",
    "CH" to "Uthwithi",
    "CI" to "Kodivaa",
    "CK" to "Vithiwa vya Cook",
    "CL" to "Chile",
    "CM" to "Kameruni",
    "CN" to "China",
    "CO" to "Kolombia",
    "CR" to "Kothtarika",
    "CU" to "Kuba",
    "CV" to "Kepuvede",
    "CY" to "Kuprothi",
    "CZ" to "Jamhuri ya Cheki",
    "DE" to "Ujerumani",
    "DJ" to "Jibuti",
    "DK" to "Denmaki",
    "DM" to "Dominika",
    "DO" to "Jamhuri ya Dominika",
    "DZ" to "Aljeria",
    "EC" to "Ekwado",
    "EE" to "Ethtonia",
    "EG" to "Mithri",
    "ER" to "Eritrea",
    "ES" to "Hithpania",
    "ET" to "Uhabeshi",
    "FI" to "Ufini",
    "FJ" to "Fiji",
    "FK" to "Vithiwa vya Falkland",
    "FM" to "Mikronethia",
    "FR" to "Ufarantha",
    "GA" to "Gaboni",
    "GB" to "Uingeredha",
    "GD" to "Grenada",
    "GE" to "Jojia",
    "GF" to "Gwiyana ya Ufarantha",
    "GH" to "Ghana",
    "GI" to "Jibralta",
    "GL" to "Grinlandi",
    "GM" to "Gambia",
    "GN" to "Gine",
    "GP" to "Gwadelupe",
    "GQ" to "Ginekweta",
    "GR" to "Ugiriki",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Hondurathi",
    "HR" to "Korathia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "ID" to "Indonethia",
    "IE" to "Ayalandi",
    "IL" to "Ithraeli",
    "IN" to "India",
    "IQ" to "Iraki",
    "IR" to "Uajemi",
    "IS" to "Aithlandi",
    "IT" to "Italia",
    "JM" to "Jamaika",
    "JO" to "Yordani",
    "JP" to "Japani",
    "KE" to "Kenya",
    "KG" to "Kirigizithtani",
    "KH" to "Kambodia",
    "KI" to "Kiribati",
    "KM" to "Komoro",
    "KN" to "Thantakitdhi na Nevith",
    "KP" to "Korea Kathkazini",
    "KR" to "Korea Kuthini",
    "KW" to "Kuwaiti",
    "KY" to "Vithiwa vya Kayman",
    "KZ" to "Kazakithtani",
    "LA" to "Laothi",
    "LB" to "Lebanoni",
    "LC" to "Thantaluthia",
    "LI" to "Lishenteni",
    "LK" to "Thirilanka",
    "LR" to "Liberia",
    "LS" to "Lethoto",
    "LT" to "Litwania",
    "LU" to "Lathembagi",
    "LV" to "Lativia",
    "LY" to "Libya",
    "MA" to "Moroko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "MG" to "Bukini",
    "MH" to "Vithiwa vya Marshal",
    "ML" to "Mali",
    "MM" to "Myama",
    "MN" to "Mongolia",
    "MP" to "Vithiwa vya Mariana vya Kathkazini",
    "MQ" to "Martiniki",
    "MR" to "Moritania",
    "MS" to "Monttherrati",
    "MT" to "Malta",
    "MU" to "Morithi",
    "MV" to "Modivu",
    "MW" to "Malawi",
    "MX" to "Mekthiko",
    "MY" to "Malethia",
    "MZ" to "Mthumbiji",
    "NA" to "Namibia",
    "NC" to "Nyukaledonia",
    "NE" to "Nijeri",
    "NF" to "Kithiwa cha Norfok",
    "NG" to "Nijeria",
    "NI" to "Nikaragwa",
    "NL" to "Uholandhi",
    "NO" to "Norwe",
    "NP" to "Nepali",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nyudhilandi",
    "OM" to "Omani",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia ya Ufarantha",
    "PG" to "Papua",
    "PH" to "Filipino",
    "PK" to "Pakithtani",
    "PL" to "Polandi",
    "PM" to "Thantapieri na Mikeloni",
    "PN" to "Pitkairni",
    "PR" to "Pwetoriko",
    "PS" to "Palestina",
    "PT" to "Ureno",
    "PW" to "Palau",
    "PY" to "Paragwai",
    "QA" to "Katari",
    "RE" to "Riyunioni",
    "RO" to "Romania",
    "RU" to "Uruthi",
    "RW" to "Rwanda",
    "SA" to "Thaudi",
    "SB" to "Vithiwa vya Tholomon",
    "SC" to "Shelisheli",
    "SD" to "Thudani",
    "SE" to "Uthwidi",
    "SG" to "Thingapoo",
    "SH" to "Thantahelena",
    "SI" to "Thlovenia",
    "SK" to "Tholvakia",
    "SL" to "Thiera Leoni",
    "SM" to "Thamarino",
    "SN" to "Thenegali",
    "SO" to "Thomalia",
    "SR" to "Thurinamu",
    "ST" to "Thao Tome na Principe",
    "SV" to "Elsavado",
    "SY" to "Thiria",
    "SZ" to "Uthwadhi",
    "TC" to "Vithiwa vya Turki na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tailandi",
    "TJ" to "Tajikithtani",
    "TK" to "Tokelau",
    "TL" to "Timori ya Mashariki",
    "TM" to "Turukimenithtani",
    "TN" to "Tunithia",
    "TO" to "Tonga",
    "TR" to "Uturuki",
    "TT" to "Trinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tadhania",
    "UG" to "Uganda",
    "US" to "Marekani",
    "UY" to "Urugwai",
    "UZ" to "Udhibekithtani",
    "VA" to "Vatikani",
    "VC" to "Thantavithenti na Grenadini",
    "VE" to "Venezuela",
    "VG" to "Vithiwa vya Virgin vya Uingeredha",
    "VI" to "Vithiwa vya Virgin vya Marekani",
    "VN" to "Vietinamu",
    "VU" to "Vanuatu",
    "WF" to "Walith na Futuna",
    "WS" to "Thamoa",
    "YE" to "Yemeni",
    "YT" to "Mayotte",
    "ZA" to "Afrika Kuthini",
    "ZM" to "Dhambia",
    "ZW" to "Dhimbabwe",
  ) }

  val ast: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Mundu",
    "002" to "África",
    "003" to "Norteamérica",
    "005" to "América del Sur",
    "009" to "Oceanía",
    "011" to "África Occidental",
    "013" to "América Central",
    "014" to "África Oriental",
    "015" to "África del Norte",
    "017" to "África Central",
    "018" to "África del Sur",
    "019" to "América",
    "021" to "América del Norte",
    "029" to "Caribe",
    "030" to "Asia Oriental",
    "034" to "Asia del Sur",
    "035" to "Sureste Asiáticu",
    "039" to "Europa del Sur",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Rexón de Micronesia",
    "061" to "Polinesia",
    "142" to "Asia",
    "143" to "Asia Central",
    "145" to "Asia Occidental",
    "150" to "Europa",
    "151" to "Europa Oriental",
    "154" to "Europa del Norte",
    "155" to "Europa Occidental",
    "419" to "América Llatina",
    "AC" to "Islla Ascensión",
    "AD" to "Andorra",
    "AE" to "Emiratos Árabes Xuníos",
    "AF" to "Afganistán",
    "AG" to "Antigua y Barbuda",
    "AI" to "Anguila",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "L’Antártida",
    "AR" to "Arxentina",
    "AS" to "Samoa Americana",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Islles Aland",
    "AZ" to "Azerbaixán",
    "BA" to "Bosnia y Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladex",
    "BE" to "Bélxica",
    "BF" to "Burkina Fasu",
    "BG" to "Bulgaria",
    "BH" to "Baḥréin",
    "BI" to "Burundi",
    "BJ" to "Benín",
    "BL" to "San Bartolomé",
    "BM" to "Les Bermudes",
    "BN" to "Brunéi",
    "BO" to "Bolivia",
    "BQ" to "Caribe neerlandés",
    "BR" to "Brasil",
    "BS" to "Les Bahames",
    "BT" to "Bután",
    "BV" to "Islla Bouvet",
    "BW" to "Botsuana",
    "BY" to "Bielorrusia",
    "BZ" to "Belize",
    "CA" to "Canadá",
    "CC" to "Islles Cocos (Keeling)",
    "CD" to "Congu - Kinxasa",
    "CF" to "República Centroafricana",
    "CG" to "Congu - Brazzaville",
    "CH" to "Suiza",
    "CI" to "Costa de Marfil",
    "CK" to "Islles Cook",
    "CL" to "Chile",
    "CM" to "Camerún",
    "CN" to "China",
    "CO" to "Colombia",
    "CP" to "Islla Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cabu Verde",
    "CW" to "Curaçao",
    "CX" to "Islla Christmas",
    "CY" to "Xipre",
    "CZ" to "Chequia",
    "DE" to "Alemaña",
    "DG" to "Diego Garcia",
    "DJ" to "Xibuti",
    "DK" to "Dinamarca",
    "DM" to "Dominica",
    "DO" to "República Dominicana",
    "DZ" to "Arxelia",
    "EA" to "Ceuta y Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Exiptu",
    "EH" to "Sáḥara Occidental",
    "ER" to "Eritrea",
    "ES" to "España",
    "ET" to "Etiopía",
    "EU" to "Xunión Europea",
    "EZ" to "Eurozona",
    "FI" to "Finlandia",
    "FJ" to "Islles Fixi",
    "FK" to "Falkland Islands",
    "FM" to "Micronesia",
    "FO" to "Islles Feroe",
    "FR" to "Francia",
    "GA" to "Gabón",
    "GB" to "Reinu Xuníu",
    "GD" to "Granada",
    "GE" to "Xeorxa",
    "GF" to "Guyana Francesa",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Xibraltar",
    "GL" to "Groenlandia",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadalupe",
    "GQ" to "Guinea Ecuatorial",
    "GR" to "Grecia",
    "GS" to "Islles Xeorxa del Sur y Sandwich del Sur",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bisáu",
    "GY" to "Guyana",
    "HK" to "ARE China de Ḥong Kong",
    "HM" to "Islles Heard y McDonald",
    "HN" to "Hondures",
    "HR" to "Croacia",
    "HT" to "Haití",
    "HU" to "Hungría",
    "IC" to "Islles Canaries",
    "ID" to "Indonesia",
    "IE" to "Irlanda",
    "IL" to "Israel",
    "IM" to "Islla de Man",
    "IN" to "India",
    "IQ" to "Iraq",
    "IR" to "Irán",
    "IS" to "Islandia",
    "IT" to "Italia",
    "JE" to "Jersey",
    "JM" to "Xamaica",
    "JO" to "Xordania",
    "JP" to "Xapón",
    "KE" to "Kenia",
    "KG" to "Kirguistán",
    "KH" to "Camboya",
    "KI" to "Kiribati",
    "KM" to "Les Comores",
    "KN" to "Saint Kitts y Nevis",
    "KP" to "Corea del Norte",
    "KR" to "Corea del Sur",
    "KW" to "Kuwait",
    "KY" to "Islles Caimán",
    "KZ" to "Kazakstán",
    "LA" to "Laos",
    "LB" to "Líbanu",
    "LC" to "Santa Llucía",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesothu",
    "LT" to "Lituania",
    "LU" to "Luxemburgu",
    "LV" to "Letonia",
    "LY" to "Libia",
    "MA" to "Marruecos",
    "MC" to "Mónacu",
    "MD" to "Moldavia",
    "ME" to "Montenegru",
    "MF" to "Saint Martin",
    "MG" to "Madagascar",
    "MH" to "Islles Marshall",
    "ML" to "Malí",
    "MM" to "Myanmar (Birmania)",
    "MN" to "Mongolia",
    "MO" to "ARE China de Macáu",
    "MP" to "Islles Marianes del Norte",
    "MQ" to "La Martinica",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauriciu",
    "MV" to "Les Maldives",
    "MW" to "Malaui",
    "MX" to "Méxicu",
    "MY" to "Malasia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "Nueva Caledonia",
    "NE" to "El Níxer",
    "NF" to "Islla Norfolk",
    "NG" to "Nixeria",
    "NI" to "Nicaragua",
    "NL" to "Países Baxos",
    "NO" to "Noruega",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nueva Zelanda",
    "OM" to "Omán",
    "PA" to "Panamá",
    "PE" to "Perú",
    "PF" to "Polinesia Francesa",
    "PG" to "Papúa Nueva Guinea",
    "PH" to "Filipines",
    "PK" to "Paquistán",
    "PL" to "Polonia",
    "PM" to "Saint Pierre y Miquelon",
    "PN" to "Islles Pitcairn",
    "PR" to "Puertu Ricu",
    "PS" to "Territorios Palestinos",
    "PT" to "Portugal",
    "PW" to "Paláu",
    "PY" to "Paraguái",
    "QA" to "Qatar",
    "QO" to "Oceanía esterior",
    "RE" to "Reunión",
    "RO" to "Rumanía",
    "RS" to "Serbia",
    "RU" to "Rusia",
    "RW" to "Ruanda",
    "SA" to "Arabia Saudita",
    "SB" to "Islles Salomón",
    "SC" to "Les Seixeles",
    "SD" to "Sudán",
    "SE" to "Suecia",
    "SG" to "Singapur",
    "SH" to "Santa Helena",
    "SI" to "Eslovenia",
    "SJ" to "Svalbard ya Islla Jan Mayen",
    "SK" to "Eslovaquia",
    "SL" to "Sierra Lleona",
    "SM" to "San Marín",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Surinam",
    "SS" to "Sudán del Sur",
    "ST" to "Santu Tomé y Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Siria",
    "SZ" to "Suazilandia",
    "TA" to "Tristán da Cunha",
    "TC" to "Islles Turques y Caicos",
    "TD" to "Chad",
    "TF" to "Tierres Australes Franceses",
    "TG" to "Togu",
    "TH" to "Tailandia",
    "TJ" to "Taxiquistán",
    "TK" to "Tokeláu",
    "TL" to "Timor Oriental",
    "TM" to "Turkmenistán",
    "TN" to "Tunicia",
    "TO" to "Tonga",
    "TR" to "Turquía",
    "TT" to "Trinidá y Tobagu",
    "TV" to "Tuvalu",
    "TW" to "Taiwán",
    "TZ" to "Tanzania",
    "UA" to "Ucraína",
    "UG" to "Uganda",
    "UM" to "Islles Perifériques Menores de los EE.XX.",
    "UN" to "Naciones Xuníes",
    "US" to "Estaos Xuníos",
    "UY" to "Uruguái",
    "UZ" to "Uzbequistán",
    "VA" to "Ciudá del Vaticanu",
    "VC" to "San Vicente y Granadines",
    "VE" to "Venezuela",
    "VG" to "Islles Vírxenes Britániques",
    "VI" to "Islles Vírxenes Americanes",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis y Futuna",
    "WS" to "Samoa",
    "XK" to "Kosovu",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "Sudáfrica",
    "ZM" to "Zambia",
    "ZW" to "Zimbabue",
    "ZZ" to "Rexón desconocida",
  ) }

  val az: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Dünya",
    "002" to "Afrika",
    "003" to "Şimali Amerika",
    "005" to "Cənubi Amerika",
    "009" to "Okeaniya",
    "011" to "Qərbi Afrika",
    "013" to "Mərkəzi Amerika",
    "014" to "Şərqi Afrika",
    "015" to "Şimali Afrika",
    "017" to "Mərkəzi Afrika",
    "018" to "Cənubi Afrika",
    "019" to "Amerika",
    "021" to "Şimal Amerikası",
    "029" to "Karib",
    "030" to "Şərqi Asiya",
    "034" to "Cənubi Asiya",
    "035" to "Cənub-Şərqi Asiya",
    "039" to "Cənubi Avropa",
    "053" to "Avstralaziya",
    "054" to "Melaneziya",
    "057" to "Mikroneziya Regionu",
    "061" to "Polineziya",
    "142" to "Asiya",
    "143" to "Mərkəzi Asiya",
    "145" to "Qərbi Asiya",
    "150" to "Avropa",
    "151" to "Şərqi Avropa",
    "154" to "Şimali Avropa",
    "155" to "Qərbi Avropa",
    "202" to "Saharadan cənub",
    "419" to "Latın Amerikası",
    "AC" to "Askenson adası",
    "AD" to "Andorra",
    "AE" to "Birləşmiş Ərəb Əmirlikləri",
    "AF" to "Əfqanıstan",
    "AG" to "Antiqua və Barbuda",
    "AI" to "Angilya",
    "AL" to "Albaniya",
    "AM" to "Ermənistan",
    "AO" to "Anqola",
    "AQ" to "Antarktika",
    "AR" to "Argentina",
    "AS" to "Amerika Samoası",
    "AT" to "Avstriya",
    "AU" to "Avstraliya",
    "AW" to "Aruba",
    "AX" to "Aland adaları",
    "AZ" to "Azərbaycan",
    "BA" to "Bosniya və Herseqovina",
    "BB" to "Barbados",
    "BD" to "Banqladeş",
    "BE" to "Belçika",
    "BF" to "Burkina Faso",
    "BG" to "Bolqarıstan",
    "BH" to "Bəhreyn",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Sent-Bartelemi",
    "BM" to "Bermud adaları",
    "BN" to "Bruney",
    "BO" to "Boliviya",
    "BQ" to "Karib Niderlandı",
    "BR" to "Braziliya",
    "BS" to "Baham adaları",
    "BT" to "Butan",
    "BV" to "Buve adası",
    "BW" to "Botsvana",
    "BY" to "Belarus",
    "BZ" to "Beliz",
    "CA" to "Kanada",
    "CC" to "Kokos (Kilinq) adaları",
    "CD" to "Konqo - Kinşasa",
    "CF" to "Mərkəzi Afrika Respublikası",
    "CG" to "Konqo - Brazzavil",
    "CH" to "İsveçrə",
    "CI" to "Kotd’ivuar",
    "CK" to "Kuk adaları",
    "CL" to "Çili",
    "CM" to "Kamerun",
    "CN" to "Çin",
    "CO" to "Kolumbiya",
    "CP" to "Klipperton adası",
    "CR" to "Kosta Rika",
    "CU" to "Kuba",
    "CV" to "Kabo-Verde",
    "CW" to "Kurasao",
    "CX" to "Milad adası",
    "CY" to "Kipr",
    "CZ" to "Çexiya",
    "DE" to "Almaniya",
    "DG" to "Dieqo Qarsiya",
    "DJ" to "Cibuti",
    "DK" to "Danimarka",
    "DM" to "Dominika",
    "DO" to "Dominikan Respublikası",
    "DZ" to "Əlcəzair",
    "EA" to "Seuta və Melilya",
    "EC" to "Ekvador",
    "EE" to "Estoniya",
    "EG" to "Misir",
    "EH" to "Qərbi Saxara",
    "ER" to "Eritreya",
    "ES" to "İspaniya",
    "ET" to "Efiopiya",
    "EU" to "Avropa Birliyi",
    "EZ" to "Avrozona",
    "FI" to "Finlandiya",
    "FJ" to "Fici",
    "FK" to "Folklend adaları",
    "FM" to "Mikroneziya",
    "FO" to "Farer adaları",
    "FR" to "Fransa",
    "GA" to "Qabon",
    "GB" to "Birləşmiş Krallıq",
    "GD" to "Qrenada",
    "GE" to "Gürcüstan",
    "GF" to "Fransa Qvianası",
    "GG" to "Gernsi",
    "GH" to "Qana",
    "GI" to "Cəbəllütariq",
    "GL" to "Qrenlandiya",
    "GM" to "Qambiya",
    "GN" to "Qvineya",
    "GP" to "Qvadelupa",
    "GQ" to "Ekvatorial Qvineya",
    "GR" to "Yunanıstan",
    "GS" to "Cənubi Corciya və Cənubi Sendviç adaları",
    "GT" to "Qvatemala",
    "GU" to "Quam",
    "GW" to "Qvineya-Bisau",
    "GY" to "Qayana",
    "HK" to "Honq Konq Xüsusi İnzibati Rayonu Çin",
    "HM" to "Herd və Makdonald adaları",
    "HN" to "Honduras",
    "HR" to "Xorvatiya",
    "HT" to "Haiti",
    "HU" to "Macarıstan",
    "IC" to "Kanar adaları",
    "ID" to "İndoneziya",
    "IE" to "İrlandiya",
    "IL" to "İsrail",
    "IM" to "Men adası",
    "IN" to "Hindistan",
    "IO" to "Britaniyanın Hind Okeanı Ərazisi",
    "IQ" to "İraq",
    "IR" to "İran",
    "IS" to "İslandiya",
    "IT" to "İtaliya",
    "JE" to "Cersi",
    "JM" to "Yamayka",
    "JO" to "İordaniya",
    "JP" to "Yaponiya",
    "KE" to "Keniya",
    "KG" to "Qırğızıstan",
    "KH" to "Kamboca",
    "KI" to "Kiribati",
    "KM" to "Komor adaları",
    "KN" to "Sent-Kits və Nevis",
    "KP" to "Şimali Koreya",
    "KR" to "Cənubi Koreya",
    "KW" to "Küveyt",
    "KY" to "Kayman adaları",
    "KZ" to "Qazaxıstan",
    "LA" to "Laos",
    "LB" to "Livan",
    "LC" to "Sent-Lusiya",
    "LI" to "Lixtenşteyn",
    "LK" to "Şri-Lanka",
    "LR" to "Liberiya",
    "LS" to "Lesoto",
    "LT" to "Litva",
    "LU" to "Lüksemburq",
    "LV" to "Latviya",
    "LY" to "Liviya",
    "MA" to "Mərakeş",
    "MC" to "Monako",
    "MD" to "Moldova",
    "ME" to "Monteneqro",
    "MF" to "Sent Martin",
    "MG" to "Madaqaskar",
    "MH" to "Marşal adaları",
    "MK" to "Şimali Makedoniya",
    "ML" to "Mali",
    "MM" to "Myanma",
    "MN" to "Monqolustan",
    "MO" to "Makao XİR Çin",
    "MP" to "Şimali Marian adaları",
    "MQ" to "Martinik",
    "MR" to "Mavritaniya",
    "MS" to "Monserat",
    "MT" to "Malta",
    "MU" to "Mavriki",
    "MV" to "Maldiv adaları",
    "MW" to "Malavi",
    "MX" to "Meksika",
    "MY" to "Malayziya",
    "MZ" to "Mozambik",
    "NA" to "Namibiya",
    "NC" to "Yeni Kaledoniya",
    "NE" to "Niger",
    "NF" to "Norfolk adası",
    "NG" to "Nigeriya",
    "NI" to "Nikaraqua",
    "NL" to "Niderland",
    "NO" to "Norveç",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Yeni Zelandiya",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Fransa Polineziyası",
    "PG" to "Papua-Yeni Qvineya",
    "PH" to "Filippin",
    "PK" to "Pakistan",
    "PL" to "Polşa",
    "PM" to "Müqəddəs Pyer və Mikelon",
    "PN" to "Pitkern adaları",
    "PR" to "Puerto Riko",
    "PS" to "Fələstin Əraziləri",
    "PT" to "Portuqaliya",
    "PW" to "Palau",
    "PY" to "Paraqvay",
    "QA" to "Qətər",
    "QO" to "Uzaq Okeaniya",
    "RE" to "Reyunyon",
    "RO" to "Rumıniya",
    "RS" to "Serbiya",
    "RU" to "Rusiya",
    "RW" to "Ruanda",
    "SA" to "Səudiyyə Ərəbistanı",
    "SB" to "Solomon adaları",
    "SC" to "Seyşel adaları",
    "SD" to "Sudan",
    "SE" to "İsveç",
    "SG" to "Sinqapur",
    "SH" to "Müqəddəs Yelena",
    "SI" to "Sloveniya",
    "SJ" to "Svalbard və Yan-Mayen",
    "SK" to "Slovakiya",
    "SL" to "Syerra-Leone",
    "SM" to "San-Marino",
    "SN" to "Seneqal",
    "SO" to "Somali",
    "SR" to "Surinam",
    "SS" to "Cənubi Sudan",
    "ST" to "San-Tome və Prinsipi",
    "SV" to "Salvador",
    "SX" to "Sint-Marten",
    "SY" to "Suriya",
    "SZ" to "Esvatini",
    "TA" to "Tristan da Kunya",
    "TC" to "Törks və Kaykos adaları",
    "TD" to "Çad",
    "TF" to "Fransanın Cənub Əraziləri",
    "TG" to "Toqo",
    "TH" to "Tailand",
    "TJ" to "Tacikistan",
    "TK" to "Tokelau",
    "TL" to "Şərqi Timor",
    "TM" to "Türkmənistan",
    "TN" to "Tunis",
    "TO" to "Tonqa",
    "TR" to "Türkiyə",
    "TT" to "Trinidad və Tobaqo",
    "TV" to "Tuvalu",
    "TW" to "Tayvan",
    "TZ" to "Tanzaniya",
    "UA" to "Ukrayna",
    "UG" to "Uqanda",
    "UM" to "ABŞ-a bağlı kiçik adacıqlar",
    "UN" to "Birləşmiş Millətlər Təşkilatı",
    "US" to "Amerika Birləşmiş Ştatları",
    "UY" to "Uruqvay",
    "UZ" to "Özbəkistan",
    "VA" to "Vatikan",
    "VC" to "Sent-Vinsent və Qrenadinlər",
    "VE" to "Venesuela",
    "VG" to "Britaniyanın Virgin adaları",
    "VI" to "ABŞ Virgin adaları",
    "VN" to "Vyetnam",
    "VU" to "Vanuatu",
    "WF" to "Uollis və Futuna",
    "WS" to "Samoa",
    "XA" to "Psevdo-Aksent",
    "XB" to "Psevdo-Bidi",
    "XK" to "Kosovo",
    "YE" to "Yəmən",
    "YT" to "Mayot",
    "ZA" to "Cənub Afrika",
    "ZM" to "Zambiya",
    "ZW" to "Zimbabve",
    "ZZ" to "Naməlum Region",
  ) }

  val az_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "دۆنیا",
  ) }

  val az_Arab_IQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val az_Arab_TR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val az_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Дүнја",
    "002" to "Африка",
    "003" to "Шимали Америка",
    "005" to "Ҹәнуби Америка",
    "009" to "Океанија",
    "011" to "Гәрби Африка",
    "013" to "Мәркәзи Америка",
    "014" to "Шәрги Африка",
    "015" to "Шимали Африка",
    "017" to "Мәркәзи Африка",
    "018" to "Ҹәнуби Африка",
    "019" to "Америка",
    "021" to "Шимал Америкасы",
    "029" to "Кариб",
    "030" to "Шәрги Асија",
    "034" to "Ҹәнуби Асија",
    "035" to "Ҹәнуб-Шәрги Асија",
    "039" to "Ҹәнуби Авропа",
    "053" to "Австралазија",
    "054" to "Меланезија",
    "057" to "Микронезија Реҝиону",
    "061" to "Полинезија",
    "142" to "Асија",
    "143" to "Мәркәзи Асија",
    "145" to "Гәрби Асија",
    "150" to "Авропа",
    "151" to "Шәрги Авропа",
    "154" to "Шимали Авропа",
    "155" to "Гәрби Авропа",
    "419" to "Латын Америкасы",
    "AC" to "Аскенсон адасы",
    "AD" to "Андорра",
    "AE" to "Бирләшмиш Әрәб Әмирликләри",
    "AF" to "Әфганыстан",
    "AG" to "Антигуа вә Барбуда",
    "AI" to "Анҝилја",
    "AL" to "Албанија",
    "AM" to "Ермәнистан",
    "AO" to "Ангола",
    "AQ" to "Антарктика",
    "AR" to "Арҝентина",
    "AS" to "Америка Самоасы",
    "AT" to "Австрија",
    "AU" to "Австралија",
    "AW" to "Аруба",
    "AX" to "Аланд адалары",
    "AZ" to "Азәрбајҹан",
    "BA" to "Боснија вә Һерсеговина",
    "BB" to "Барбадос",
    "BD" to "Бангладеш",
    "BE" to "Белчика",
    "BF" to "Буркина Фасо",
    "BG" to "Болгарыстан",
    "BH" to "Бәһрејн",
    "BI" to "Бурунди",
    "BJ" to "Бенин",
    "BL" to "Сент-Бартелеми",
    "BM" to "Бермуд адалары",
    "BN" to "Брунеј",
    "BO" to "Боливија",
    "BR" to "Бразилија",
    "BS" to "Баһам адалары",
    "BT" to "Бутан",
    "BV" to "Буве адасы",
    "BW" to "Ботсвана",
    "BY" to "Беларус",
    "BZ" to "Белиз",
    "CA" to "Канада",
    "CC" to "Кокос (Килинг) адалары",
    "CD" to "Конго-Киншаса",
    "CF" to "Мәркәзи Африка Республикасы",
    "CG" to "Конго-Браззавил",
    "CH" to "Исвечрә",
    "CI" to "Котд’ивуар",
    "CK" to "Кук адалары",
    "CL" to "Чили",
    "CM" to "Камерун",
    "CN" to "Чин",
    "CO" to "Колумбија",
    "CP" to "Клиппертон адасы",
    "CR" to "Коста Рика",
    "CU" to "Куба",
    "CV" to "Кабо-Верде",
    "CW" to "Курасао",
    "CX" to "Милад адасы",
    "CY" to "Кипр",
    "CZ" to "Чехија",
    "DE" to "Алманија",
    "DG" to "Диего Гарсија",
    "DJ" to "Ҹибути",
    "DK" to "Данимарка",
    "DM" to "Доминика",
    "DO" to "Доминикан Республикасы",
    "DZ" to "Әлҹәзаир",
    "EA" to "Сеута вә Мелилја",
    "EC" to "Еквадор",
    "EE" to "Естонија",
    "EG" to "Мисир",
    "ER" to "Еритреја",
    "ES" to "Испанија",
    "ET" to "Ефиопија",
    "EU" to "Авропа Бирлији",
    "FI" to "Финландија",
    "FJ" to "Фиҹи",
    "FK" to "Фолкленд адалары",
    "FM" to "Микронезија",
    "FO" to "Фарер адалары",
    "FR" to "Франса",
    "GA" to "Габон",
    "GB" to "Бирләшмиш Краллыг",
    "GD" to "Гренада",
    "GE" to "Ҝүрҹүстан",
    "GF" to "Франса Гвианасы",
    "GG" to "Ҝернси",
    "GH" to "Гана",
    "GI" to "Ҹәбәллүтариг",
    "GL" to "Гренландија",
    "GM" to "Гамбија",
    "GN" to "Гвинеја",
    "GP" to "Гваделупа",
    "GQ" to "Екваториал Гвинеја",
    "GR" to "Јунаныстан",
    "GS" to "Ҹәнуби Ҹорҹија вә Ҹәнуби Сендвич адалары",
    "GT" to "Гватемала",
    "GU" to "Гуам",
    "GW" to "Гвинеја-Бисау",
    "GY" to "Гајана",
    "HK" to "Һонк Конг Хүсуси Инзибати Әрази Чин",
    "HM" to "Һерд вә Макдоналд адалары",
    "HN" to "Һондурас",
    "HR" to "Хорватија",
    "HT" to "Һаити",
    "HU" to "Маҹарыстан",
    "IC" to "Канар адалары",
    "ID" to "Индонезија",
    "IE" to "Ирландија",
    "IL" to "Исраил",
    "IM" to "Мен адасы",
    "IN" to "Һиндистан",
    "IQ" to "Ираг",
    "IR" to "Иран",
    "IS" to "Исландија",
    "IT" to "Италија",
    "JE" to "Ҹерси",
    "JM" to "Јамајка",
    "JO" to "Иорданија",
    "JP" to "Јапонија",
    "KE" to "Кенија",
    "KG" to "Гырғызыстан",
    "KH" to "Камбоҹа",
    "KI" to "Кирибати",
    "KM" to "Комор адалары",
    "KN" to "Сент-Китс вә Невис",
    "KP" to "Шимали Кореја",
    "KR" to "Ҹәнуби Кореја",
    "KW" to "Күвејт",
    "KY" to "Кајман адалары",
    "KZ" to "Газахыстан",
    "LA" to "Лаос",
    "LB" to "Ливан",
    "LC" to "Сент-Лусија",
    "LI" to "Лихтенштејн",
    "LK" to "Шри-Ланка",
    "LR" to "Либерија",
    "LS" to "Лесото",
    "LT" to "Литва",
    "LU" to "Лүксембург",
    "LV" to "Латвија",
    "LY" to "Ливија",
    "MA" to "Мәракеш",
    "MC" to "Монако",
    "MD" to "Молдова",
    "ME" to "Монтенегро",
    "MF" to "Сент Мартин",
    "MG" to "Мадагаскар",
    "MH" to "Маршал адалары",
    "ML" to "Мали",
    "MM" to "Мјанма",
    "MN" to "Монголустан",
    "MO" to "Макао Хүсуси Инзибати Әрази Чин",
    "MP" to "Шимали Мариан адалары",
    "MQ" to "Мартиник",
    "MR" to "Мавританија",
    "MS" to "Монсерат",
    "MT" to "Малта",
    "MU" to "Маврики",
    "MV" to "Малдив адалары",
    "MW" to "Малави",
    "MX" to "Мексика",
    "MY" to "Малајзија",
    "MZ" to "Мозамбик",
    "NA" to "Намибија",
    "NC" to "Јени Каледонија",
    "NE" to "Ниҝер",
    "NF" to "Норфолк адасы",
    "NG" to "Ниҝерија",
    "NI" to "Никарагуа",
    "NL" to "Нидерланд",
    "NO" to "Норвеч",
    "NP" to "Непал",
    "NR" to "Науру",
    "NU" to "Ниуе",
    "NZ" to "Јени Зеландија",
    "OM" to "Оман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PF" to "Франса Полинезијасы",
    "PG" to "Папуа-Јени Гвинеја",
    "PH" to "Филиппин",
    "PK" to "Пакистан",
    "PL" to "Полша",
    "PM" to "Мүгәддәс Пјер вә Микелон",
    "PN" to "Питкерн адалары",
    "PR" to "Пуерто Рико",
    "PT" to "Португалија",
    "PW" to "Палау",
    "PY" to "Парагвај",
    "QA" to "Гәтәр",
    "QO" to "Узаг Океанија",
    "RE" to "Рејунјон",
    "RO" to "Румынија",
    "RS" to "Сербија",
    "RU" to "Русија",
    "RW" to "Руанда",
    "SA" to "Сәудијјә Әрәбистаны",
    "SB" to "Соломон адалары",
    "SC" to "Сејшел адалары",
    "SD" to "Судан",
    "SE" to "Исвеч",
    "SG" to "Сингапур",
    "SH" to "Мүгәддәс Јелена",
    "SI" to "Словенија",
    "SJ" to "Свалбард вә Јан-Мајен",
    "SK" to "Словакија",
    "SL" to "Сјерра-Леоне",
    "SM" to "Сан-Марино",
    "SN" to "Сенегал",
    "SO" to "Сомали",
    "SR" to "Суринам",
    "SS" to "Ҹәнуби Судан",
    "ST" to "Сан-Томе вә Принсипи",
    "SV" to "Салвадор",
    "SX" to "Синт-Мартен",
    "SY" to "Сурија",
    "SZ" to "Свазиленд",
    "TA" to "Тристан да Кунја",
    "TC" to "Төркс вә Кајкос адалары",
    "TD" to "Чад",
    "TF" to "Франсанын Ҹәнуб Әразиләри",
    "TG" to "Того",
    "TH" to "Таиланд",
    "TJ" to "Таҹикистан",
    "TK" to "Токелау",
    "TL" to "Шәрги Тимор",
    "TM" to "Түркмәнистан",
    "TN" to "Тунис",
    "TO" to "Тонга",
    "TR" to "Түркијә",
    "TT" to "Тринидад вә Тобаго",
    "TV" to "Тувалу",
    "TW" to "Тајван",
    "TZ" to "Танзанија",
    "UA" to "Украјна",
    "UG" to "Уганда",
    "UM" to "АБШ-а бағлы кичик адаҹыглар",
    "US" to "Америка Бирләшмиш Штатлары",
    "UY" to "Уругвај",
    "UZ" to "Өзбәкистан",
    "VA" to "Ватикан",
    "VC" to "Сент-Винсент вә Гренадинләр",
    "VE" to "Венесуела",
    "VG" to "Британијанын Вирҝин адалары",
    "VI" to "АБШ Вирҝин адалары",
    "VN" to "Вјетнам",
    "VU" to "Вануату",
    "WF" to "Уоллис вә Футуна",
    "WS" to "Самоа",
    "XK" to "Косово",
    "YE" to "Јәмән",
    "YT" to "Мајот",
    "ZA" to "Ҹәнуб Африка",
    "ZM" to "Замбија",
    "ZW" to "Зимбабве",
    "ZZ" to "Намәлум Реҝион",
  ) }

  val az_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Dünya",
    "002" to "Afrika",
    "003" to "Şimali Amerika",
    "005" to "Cənubi Amerika",
    "009" to "Okeaniya",
    "011" to "Qərbi Afrika",
    "013" to "Mərkəzi Amerika",
    "014" to "Şərqi Afrika",
    "015" to "Şimali Afrika",
    "017" to "Mərkəzi Afrika",
    "018" to "Cənubi Afrika",
    "019" to "Amerika",
    "021" to "Şimal Amerikası",
    "029" to "Karib",
    "030" to "Şərqi Asiya",
    "034" to "Cənubi Asiya",
    "035" to "Cənub-Şərqi Asiya",
    "039" to "Cənubi Avropa",
    "053" to "Avstralaziya",
    "054" to "Melaneziya",
    "057" to "Mikroneziya Regionu",
    "061" to "Polineziya",
    "142" to "Asiya",
    "143" to "Mərkəzi Asiya",
    "145" to "Qərbi Asiya",
    "150" to "Avropa",
    "151" to "Şərqi Avropa",
    "154" to "Şimali Avropa",
    "155" to "Qərbi Avropa",
    "202" to "Saharadan cənub",
    "419" to "Latın Amerikası",
    "AC" to "Askenson adası",
    "AD" to "Andorra",
    "AE" to "Birləşmiş Ərəb Əmirlikləri",
    "AF" to "Əfqanıstan",
    "AG" to "Antiqua və Barbuda",
    "AI" to "Angilya",
    "AL" to "Albaniya",
    "AM" to "Ermənistan",
    "AO" to "Anqola",
    "AQ" to "Antarktika",
    "AR" to "Argentina",
    "AS" to "Amerika Samoası",
    "AT" to "Avstriya",
    "AU" to "Avstraliya",
    "AW" to "Aruba",
    "AX" to "Aland adaları",
    "AZ" to "Azərbaycan",
    "BA" to "Bosniya və Herseqovina",
    "BB" to "Barbados",
    "BD" to "Banqladeş",
    "BE" to "Belçika",
    "BF" to "Burkina Faso",
    "BG" to "Bolqarıstan",
    "BH" to "Bəhreyn",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Sent-Bartelemi",
    "BM" to "Bermud adaları",
    "BN" to "Bruney",
    "BO" to "Boliviya",
    "BQ" to "Karib Niderlandı",
    "BR" to "Braziliya",
    "BS" to "Baham adaları",
    "BT" to "Butan",
    "BV" to "Buve adası",
    "BW" to "Botsvana",
    "BY" to "Belarus",
    "BZ" to "Beliz",
    "CA" to "Kanada",
    "CC" to "Kokos (Kilinq) adaları",
    "CD" to "Konqo - Kinşasa",
    "CF" to "Mərkəzi Afrika Respublikası",
    "CG" to "Konqo - Brazzavil",
    "CH" to "İsveçrə",
    "CI" to "Kotd’ivuar",
    "CK" to "Kuk adaları",
    "CL" to "Çili",
    "CM" to "Kamerun",
    "CN" to "Çin",
    "CO" to "Kolumbiya",
    "CP" to "Klipperton adası",
    "CR" to "Kosta Rika",
    "CU" to "Kuba",
    "CV" to "Kabo-Verde",
    "CW" to "Kurasao",
    "CX" to "Milad adası",
    "CY" to "Kipr",
    "CZ" to "Çexiya",
    "DE" to "Almaniya",
    "DG" to "Dieqo Qarsiya",
    "DJ" to "Cibuti",
    "DK" to "Danimarka",
    "DM" to "Dominika",
    "DO" to "Dominikan Respublikası",
    "DZ" to "Əlcəzair",
    "EA" to "Seuta və Melilya",
    "EC" to "Ekvador",
    "EE" to "Estoniya",
    "EG" to "Misir",
    "EH" to "Qərbi Saxara",
    "ER" to "Eritreya",
    "ES" to "İspaniya",
    "ET" to "Efiopiya",
    "EU" to "Avropa Birliyi",
    "EZ" to "Avrozona",
    "FI" to "Finlandiya",
    "FJ" to "Fici",
    "FK" to "Folklend adaları",
    "FM" to "Mikroneziya",
    "FO" to "Farer adaları",
    "FR" to "Fransa",
    "GA" to "Qabon",
    "GB" to "Birləşmiş Krallıq",
    "GD" to "Qrenada",
    "GE" to "Gürcüstan",
    "GF" to "Fransa Qvianası",
    "GG" to "Gernsi",
    "GH" to "Qana",
    "GI" to "Cəbəllütariq",
    "GL" to "Qrenlandiya",
    "GM" to "Qambiya",
    "GN" to "Qvineya",
    "GP" to "Qvadelupa",
    "GQ" to "Ekvatorial Qvineya",
    "GR" to "Yunanıstan",
    "GS" to "Cənubi Corciya və Cənubi Sendviç adaları",
    "GT" to "Qvatemala",
    "GU" to "Quam",
    "GW" to "Qvineya-Bisau",
    "GY" to "Qayana",
    "HK" to "Honq Konq Xüsusi İnzibati Rayonu Çin",
    "HM" to "Herd və Makdonald adaları",
    "HN" to "Honduras",
    "HR" to "Xorvatiya",
    "HT" to "Haiti",
    "HU" to "Macarıstan",
    "IC" to "Kanar adaları",
    "ID" to "İndoneziya",
    "IE" to "İrlandiya",
    "IL" to "İsrail",
    "IM" to "Men adası",
    "IN" to "Hindistan",
    "IO" to "Britaniyanın Hind Okeanı Ərazisi",
    "IQ" to "İraq",
    "IR" to "İran",
    "IS" to "İslandiya",
    "IT" to "İtaliya",
    "JE" to "Cersi",
    "JM" to "Yamayka",
    "JO" to "İordaniya",
    "JP" to "Yaponiya",
    "KE" to "Keniya",
    "KG" to "Qırğızıstan",
    "KH" to "Kamboca",
    "KI" to "Kiribati",
    "KM" to "Komor adaları",
    "KN" to "Sent-Kits və Nevis",
    "KP" to "Şimali Koreya",
    "KR" to "Cənubi Koreya",
    "KW" to "Küveyt",
    "KY" to "Kayman adaları",
    "KZ" to "Qazaxıstan",
    "LA" to "Laos",
    "LB" to "Livan",
    "LC" to "Sent-Lusiya",
    "LI" to "Lixtenşteyn",
    "LK" to "Şri-Lanka",
    "LR" to "Liberiya",
    "LS" to "Lesoto",
    "LT" to "Litva",
    "LU" to "Lüksemburq",
    "LV" to "Latviya",
    "LY" to "Liviya",
    "MA" to "Mərakeş",
    "MC" to "Monako",
    "MD" to "Moldova",
    "ME" to "Monteneqro",
    "MF" to "Sent Martin",
    "MG" to "Madaqaskar",
    "MH" to "Marşal adaları",
    "MK" to "Şimali Makedoniya",
    "ML" to "Mali",
    "MM" to "Myanma",
    "MN" to "Monqolustan",
    "MO" to "Makao XİR Çin",
    "MP" to "Şimali Marian adaları",
    "MQ" to "Martinik",
    "MR" to "Mavritaniya",
    "MS" to "Monserat",
    "MT" to "Malta",
    "MU" to "Mavriki",
    "MV" to "Maldiv adaları",
    "MW" to "Malavi",
    "MX" to "Meksika",
    "MY" to "Malayziya",
    "MZ" to "Mozambik",
    "NA" to "Namibiya",
    "NC" to "Yeni Kaledoniya",
    "NE" to "Niger",
    "NF" to "Norfolk adası",
    "NG" to "Nigeriya",
    "NI" to "Nikaraqua",
    "NL" to "Niderland",
    "NO" to "Norveç",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Yeni Zelandiya",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Fransa Polineziyası",
    "PG" to "Papua-Yeni Qvineya",
    "PH" to "Filippin",
    "PK" to "Pakistan",
    "PL" to "Polşa",
    "PM" to "Müqəddəs Pyer və Mikelon",
    "PN" to "Pitkern adaları",
    "PR" to "Puerto Riko",
    "PS" to "Fələstin Əraziləri",
    "PT" to "Portuqaliya",
    "PW" to "Palau",
    "PY" to "Paraqvay",
    "QA" to "Qətər",
    "QO" to "Uzaq Okeaniya",
    "RE" to "Reyunyon",
    "RO" to "Rumıniya",
    "RS" to "Serbiya",
    "RU" to "Rusiya",
    "RW" to "Ruanda",
    "SA" to "Səudiyyə Ərəbistanı",
    "SB" to "Solomon adaları",
    "SC" to "Seyşel adaları",
    "SD" to "Sudan",
    "SE" to "İsveç",
    "SG" to "Sinqapur",
    "SH" to "Müqəddəs Yelena",
    "SI" to "Sloveniya",
    "SJ" to "Svalbard və Yan-Mayen",
    "SK" to "Slovakiya",
    "SL" to "Syerra-Leone",
    "SM" to "San-Marino",
    "SN" to "Seneqal",
    "SO" to "Somali",
    "SR" to "Surinam",
    "SS" to "Cənubi Sudan",
    "ST" to "San-Tome və Prinsipi",
    "SV" to "Salvador",
    "SX" to "Sint-Marten",
    "SY" to "Suriya",
    "SZ" to "Esvatini",
    "TA" to "Tristan da Kunya",
    "TC" to "Törks və Kaykos adaları",
    "TD" to "Çad",
    "TF" to "Fransanın Cənub Əraziləri",
    "TG" to "Toqo",
    "TH" to "Tailand",
    "TJ" to "Tacikistan",
    "TK" to "Tokelau",
    "TL" to "Şərqi Timor",
    "TM" to "Türkmənistan",
    "TN" to "Tunis",
    "TO" to "Tonqa",
    "TR" to "Türkiyə",
    "TT" to "Trinidad və Tobaqo",
    "TV" to "Tuvalu",
    "TW" to "Tayvan",
    "TZ" to "Tanzaniya",
    "UA" to "Ukrayna",
    "UG" to "Uqanda",
    "UM" to "ABŞ-a bağlı kiçik adacıqlar",
    "UN" to "Birləşmiş Millətlər Təşkilatı",
    "US" to "Amerika Birləşmiş Ştatları",
    "UY" to "Uruqvay",
    "UZ" to "Özbəkistan",
    "VA" to "Vatikan",
    "VC" to "Sent-Vinsent və Qrenadinlər",
    "VE" to "Venesuela",
    "VG" to "Britaniyanın Virgin adaları",
    "VI" to "ABŞ Virgin adaları",
    "VN" to "Vyetnam",
    "VU" to "Vanuatu",
    "WF" to "Uollis və Futuna",
    "WS" to "Samoa",
    "XA" to "Psevdo-Aksent",
    "XB" to "Psevdo-Bidi",
    "XK" to "Kosovo",
    "YE" to "Yəmən",
    "YT" to "Mayot",
    "ZA" to "Cənub Afrika",
    "ZM" to "Zambiya",
    "ZW" to "Zimbabve",
    "ZZ" to "Naməlum Region",
  ) }

  val bal_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Donyá",
    "002" to "Afriká",
    "003" to "Shemáli Amriká",
    "005" to "Zerbári Amriká",
    "009" to "Ushiáná",
    "011" to "Rónendi Apriká",
    "013" to "Myáni Amriká",
    "014" to "Ródarátki Apriká",
    "015" to "Shemáli Apriká",
    "017" to "Myáni Apriká",
    "018" to "Jonubi Apriká",
    "019" to "Amriká",
    "021" to "Shemáli Amrika",
    "029" to "Kerébian",
    "030" to "Ródarátki Ásiá",
    "034" to "Zerbári Ásiá",
    "035" to "Zerbárródarátki Ásiá",
    "039" to "Zerbári Yurop",
    "053" to "Ástrálásiá",
    "054" to "Melanésiá",
    "057" to "Máekrónési Damag",
    "061" to "Pólinisiá",
    "142" to "Ásiá",
    "143" to "Myáni Ásiá",
    "145" to "Rónendi Ásiá",
    "150" to "Yurop",
    "151" to "Ródarátki Yurop",
    "154" to "Shemáli Yurop",
    "155" to "Rónendi Yurop",
    "202" to "Sab-Sahári Apriká",
    "419" to "Látini Amriká",
    "AC" to "Asenshan Islánd",
    "AD" to "Andorrá",
    "AE" to "Emárát",
    "AF" to "Awghánestán",
    "AG" to "Antiga o Barbuda",
    "AI" to "Angwila",
    "AL" to "Albániá",
    "AM" to "Árminiá",
    "AO" to "Angólá",
    "AQ" to "Antárktiká",
    "AR" to "Arjentiná",
    "AS" to "Amriki Samóá",
    "AT" to "Ástriá",
    "AU" to "Ásthréliá",
    "AW" to "Aruba",
    "AX" to "Áwlánd Islánd",
    "AZ" to "Ázerbáiján",
    "BA" to "Bósniá",
    "BB" to "Barbadós",
    "BD" to "Bangaladésh",
    "BE" to "Béljiam",
    "BF" to "Burkiná Pásó",
    "BG" to "Balgáriá",
    "BH" to "Bahren",
    "BI" to "Borondi",
    "BJ" to "Benin",
    "BL" to "St. Bartélémi",
    "BM" to "Barmudá",
    "BN" to "Brunái",
    "BO" to "Boliwiá",
    "BQ" to "Kerébi Nedarlánd",
    "BR" to "Brázil",
    "BS" to "Bahamas",
    "BT" to "Buthán",
    "BV" to "Bówet Islánd",
    "BW" to "Bostwáná",
    "BY" to "Bélárus",
    "BZ" to "Belize",
    "CA" to "Kaynadhá",
    "CC" to "Kukus Islánd (Kileng)",
    "CD" to "Kángó-Kenshásá",
    "CF" to "Myáni Apriki Eshtán",
    "CG" to "Kángó-Brázáwille",
    "CH" to "Swizarlánd",
    "CI" to "Kóté diáwóri",
    "CK" to "Kuk Islánd",
    "CL" to "Chilay",
    "CM" to "Kaymrun",
    "CN" to "Chin",
    "CO" to "Kólambiá",
    "CP" to "Klipperton Islánd",
    "CQ" to "Sárk",
    "CR" to "Kóstá Riká",
    "CU" to "Kyubá",
    "CV" to "Kap Wardé",
    "CW" to "Churácháó",
    "CX" to "Kresmes Islánd",
    "CY" to "Sáipras",
    "CZ" to "Chéchiá",
    "DE" to "Jarmani",
    "DG" to "Diégó Gárshiá",
    "DJ" to "Djebuti",
    "DK" to "Denmárk",
    "DM" to "Duminiká",
    "DO" to "Duminiki Están",
    "DZ" to "Aljiriá",
    "EA" to "Siótó o Melilá",
    "EC" to "Ekwádór",
    "EE" to "Estóniá",
    "EG" to "Mesr",
    "EH" to "Róbarkati Sahárá",
    "ER" to "Eritiriá",
    "ES" to "Espin",
    "ET" to "Etupiá",
    "EU" to "Yuropi Yunian",
    "EZ" to "Yurop-damag",
    "FI" to "Fenlánd",
    "FJ" to "Fiji",
    "FK" to "Páklánd Islánd",
    "FM" to "Mikrónéshiá",
    "FO" to "Faróé Islánd",
    "FR" to "Paráns",
    "GA" to "Gabon",
    "GB" to "Bartániá",
    "GD" to "Gerená",
    "GE" to "Járjiá",
    "GF" to "Pránsi Gwiáná",
    "GG" to "Gwernsay",
    "GH" to "Gáná",
    "GI" to "Gibráltar",
    "GL" to "Grinlánd",
    "GM" to "Gambiá",
    "GN" to "Giniá",
    "GP" to "Gwádelóp",
    "GQ" to "Ekwáturi Giniá",
    "GR" to "Yunán",
    "GS" to "Zerbári Járjiá",
    "GT" to "Gwátémálá",
    "GU" to "Guám",
    "GW" to "Giniá-Bissáu",
    "GY" to "Goyáná",
    "HK" to "Háng Káng o SAR Chin",
    "HM" to "Hard o Mekdónald Islánd",
    "HN" to "Honduras",
    "HR" to "Króshiá",
    "HT" to "Hayti",
    "HU" to "Hangari",
    "IC" to "Kanaray Islánd",
    "ID" to "Endhonéshiá",
    "IE" to "Áerlánd",
    "IL" to "Esráil",
    "IM" to "Áisale Mardom",
    "IN" to "Hendostán",
    "IO" to "Bartáni Hendi Zerdamag",
    "IQ" to "Erák",
    "IR" to "Érán",
    "IS" to "Áeslánd",
    "IT" to "Itáliá",
    "JE" to "Jersé",
    "JM" to "Jamáeká",
    "JO" to "Ordon",
    "JP" to "Jápán",
    "KE" to "Kiniá",
    "KG" to "Karghazestán",
    "KH" to "Kambódhiá",
    "KI" to "Kiribáti",
    "KM" to "Komórós",
    "KN" to "St. Kitts o Newis",
    "KP" to "Shamáli Kóriá",
    "KR" to "Zerbári Kóriá",
    "KW" to "Kwayt",
    "KY" to "Kaymi Islánd",
    "KZ" to "Kázakhestán",
    "LA" to "Láus",
    "LB" to "Lebnán",
    "LC" to "St. Lusiá",
    "LI" to "Lichtenstén",
    "LK" to "Sari Lanká",
    "LR" to "Láibériá",
    "LS" to "Lesótó",
    "LT" to "Lituániá",
    "LU" to "Loksembórg",
    "LV" to "Latwiá",
    "LY" to "Libyá",
    "MA" to "Morókó",
    "MC" to "Monákó",
    "MD" to "Moldowá",
    "ME" to "Montenegró",
    "MF" to "St. Mártin",
    "MG" to "Madagáskar",
    "MH" to "Marshall Islánd",
    "MK" to "Shemáli Makduniá",
    "ML" to "Máli",
    "MM" to "Myanmár (Barmá)",
    "MN" to "Mangóliá",
    "MO" to "Makaó SAR Chin",
    "MP" to "Shemáli Máriáná Islánd",
    "MQ" to "Mártinik",
    "MR" to "Muritániá",
    "MS" to "Montserrat",
    "MT" to "Máltá",
    "MU" to "Murishias",
    "MV" to "Máldip",
    "MW" to "Maláwi",
    "MX" to "Meksikó",
    "MY" to "Maléshiá",
    "MZ" to "Mózambik",
    "NA" to "Namibiá",
    "NC" to "Niu Káledóniá",
    "NE" to "Náiger",
    "NF" to "Nórfolk Islánd",
    "NG" to "Náijériá",
    "NI" to "Nekárágóá",
    "NL" to "Nedarlánd",
    "NO" to "Nárway",
    "NP" to "Népál",
    "NR" to "Náuru",
    "NU" to "Niué",
    "NZ" to "Nyu Zilánd",
    "OM" to "Omán",
    "PA" to "Pánámá",
    "PE" to "Péru",
    "PF" to "Paránsi Pulinishiá",
    "PG" to "Pápuá Niu Giniá",
    "PH" to "Pelpin",
    "PK" to "Pákestán",
    "PL" to "Pólánd",
    "PM" to "St. Péri o Mikwélin",
    "PN" to "Pitkarén Islánd",
    "PR" to "Piuró Rikó",
    "PS" to "Palastinay Damag",
    "PT" to "Portogál",
    "PW" to "Paláu",
    "PY" to "Parágóay",
    "QA" to "Gatar",
    "QO" to "Tálánén Zerbahrag",
    "RE" to "Réyunian",
    "RO" to "Rumániá",
    "RS" to "Sarbiá",
    "RU" to "Rus",
    "RW" to "Rwándhá",
    "SA" to "Saudi Arab",
    "SB" to "Solomán Islánd",
    "SC" to "Sécheles",
    "SD" to "Sudán",
    "SE" to "Swidhan",
    "SG" to "Sengápur",
    "SH" to "St. Heléná",
    "SI" to "Slowiniá",
    "SJ" to "Swalbard o Jan Mayén",
    "SK" to "Slowákiá",
    "SL" to "Sierrá Leóne",
    "SM" to "San Mariánó",
    "SN" to "Senigál",
    "SO" to "Sómáliá",
    "SR" to "Surinaym",
    "SS" to "Zerbári Sudán",
    "ST" to "Sáó Tóme o Prensip",
    "SV" to "El Salwadór",
    "SX" to "Sint Márten",
    "SY" to "Suriá",
    "SZ" to "Eswatini",
    "TA" to "Tristan dá Chonhá",
    "TC" to "Tork o Káikói Islánd",
    "TD" to "Chád",
    "TF" to "Pránsi Zerbári Damag",
    "TG" to "Tógó",
    "TH" to "Táilánd",
    "TJ" to "Tájekestán",
    "TK" to "Tokéláu",
    "TL" to "Témur-Leste",
    "TM" to "Torkmenestán",
    "TN" to "Tunishiá",
    "TO" to "Tongá",
    "TR" to "Turkiye",
    "TT" to "Trinidad o Tobágó",
    "TV" to "Tuwalu",
    "TW" to "Táiwán",
    "TZ" to "Tanzániá",
    "UA" to "Yukrén",
    "UG" to "Yugandhá",
    "UM" to "U.S. Daráén Islánd",
    "UN" to "Myánostománi Gal",
    "US" to "Amrikáay Tepákén Están",
    "UY" to "Yurógóay",
    "UZ" to "Ozbekestán",
    "VA" to "Wátikán Sethi",
    "VC" to "St. Wensent o Grenádin",
    "VE" to "Wenezwélá",
    "VG" to "Bretáni Ajgén Islánd",
    "VI" to "Amriki Ajgén Islánd",
    "VN" to "Wietnám",
    "VU" to "Wanuátu",
    "WF" to "Wális o Futuná",
    "WS" to "Samóá",
    "XA" to "Kesási-Gálwár",
    "XB" to "Kesási- Bidi",
    "XK" to "Kósówó",
    "YE" to "Yaman",
    "YT" to "Mayotte",
    "ZA" to "Zerbári Apriká",
    "ZM" to "Zambiá",
    "ZW" to "Zembábwé",
    "ZZ" to "Nagisshetagén damag",
  ) }

  val bas: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Àŋdɔ̂r",
    "AE" to "Àdnà i Bilɔ̀ŋ bi Arābìà",
    "AF" to "Àfgànìstâŋ",
    "AG" to "Àŋtigà ɓɔ Bàrbudà",
    "AI" to "Àŋgiyà",
    "AL" to "Àlbanìà",
    "AM" to "Àrmenìà",
    "AO" to "Àŋgolà",
    "AR" to "Àrgàŋtinà",
    "AT" to "Òstrǐk",
    "AU" to "Òstralìà",
    "AW" to "Àrubà",
    "AZ" to "Àzɛ̀rbajàŋ",
    "BA" to "Bòhnià Ɛrzègòvinà",
    "BB" to "Bàrbadò",
    "BD" to "Bàŋglàdɛ̂s",
    "BE" to "Bɛlgyùm",
    "BF" to "Bùrkìnà Fasò",
    "BG" to "Bùlgarìà",
    "BH" to "Bàraìn",
    "BI" to "Bùrundì",
    "BJ" to "Bènɛ̂ŋ",
    "BM" to "Bɛ̀rmudà",
    "BN" to "Brunei",
    "BO" to "Bòlivìà",
    "BR" to "Bràsîl",
    "BS" to "Bàhamàs",
    "BT" to "Bùtân",
    "BW" to "Bòdsùanà",
    "BY" to "Bèlarùs",
    "BZ" to "Bèlîs",
    "CA" to "Kànadà",
    "CD" to "Kòŋgo ìkɛŋi",
    "CF" to "Ŋ̀ɛm Afrīkà",
    "CG" to "Kòŋgo",
    "CH" to "Sùwîs",
    "CI" to "Màŋ mi Njɔ̂k",
    "CK" to "Bìòn bi Kook",
    "CL" to "Kìlî",
    "CM" to "Kàmɛ̀rûn",
    "CN" to "Kinà",
    "CO" to "Kɔ̀lɔmbìà",
    "CR" to "Kòstà Rikà",
    "CU" to "Kubà",
    "CV" to "Kabwɛ᷆r",
    "CY" to "Kiprò",
    "DE" to "Jamân",
    "DJ" to "Jìbutì",
    "DK" to "Dànmârk",
    "DM" to "Dòmnîk",
    "DO" to "Dòmnikà",
    "DZ" to "Àlgerìà",
    "EC" to "Èkwàtorìà",
    "EE" to "Èstonìà",
    "EG" to "Ègîptò",
    "ER" to "Èrìtrěà",
    "ES" to "Pànya",
    "ET" to "Ètìopìà",
    "FI" to "Fìnlând",
    "FJ" to "Fiji",
    "FK" to "Bìòn bi Falkland",
    "FM" to "Mìkrònesìà",
    "FR" to "Pùlàsi / Fɛ̀lɛ̀nsi /",
    "GA" to "Gàbɔ̂ŋ",
    "GB" to "Àdnà i Lɔ̂ŋ",
    "GD" to "Grènadà",
    "GE" to "Gèɔrgìà",
    "GF" to "Gùyanà Pùlàsi",
    "GH" to "Ganà",
    "GI" to "Gìlbràtâr",
    "GL" to "Grǐnlànd",
    "GM" to "Gàmbià",
    "GN" to "Gìnê",
    "GP" to "Gwàdèlûp",
    "GQ" to "Gìne Èkwàtorìà",
    "GR" to "Grǐkyà",
    "GT" to "Gwàtèmalà",
    "GU" to "Gùâm",
    "GW" to "Gìne Bìsàô",
    "GY" to "Gùyanà",
    "HN" to "Ɔ̀ŋduràs",
    "HR" to "Kròasìà",
    "HT" to "Àitì",
    "HU" to "Ɔ̀ŋgriì",
    "ID" to "Indònèsià",
    "IE" to "Ìrlând",
    "IL" to "Isràɛ̂l",
    "IN" to "Indìà",
    "IQ" to "Ìrâk",
    "IR" to "Ìrâŋ",
    "IS" to "Ìslandìà",
    "IT" to "Ìtalìà",
    "JM" to "Jàmàikà",
    "JO" to "Yɔ̀rdanià",
    "KE" to "Kenìà",
    "KG" to "Kìrgìzìstàŋ",
    "KH" to "Kàmbodìà",
    "KI" to "Kìrìbatì",
    "KM" to "Kɔ̀mɔ̂r",
    "KN" to "Nûmpubi Kîts nì Nevìs",
    "KP" to "Kɔ̀re ì Ŋ̀ɔmbɔk",
    "KR" to "Kɔ̀re ì Ŋ̀wɛ̀lmbɔk",
    "KW" to "Kòwêt",
    "KY" to "Bìòn bi Kaymàn",
    "KZ" to "Kàzàkstâŋ",
    "LA" to "Làôs",
    "LB" to "Lèbanòn",
    "LC" to "Nûmpubi Lusì",
    "LI" to "Ligstɛntàn",
    "LK" to "Srìlaŋkà",
    "LR" to "Lìberìà",
    "LS" to "Lesòtò",
    "LT" to "Lìtùanìà",
    "LU" to "Lùgsàmbûr",
    "LV" to "Làdvià",
    "LY" to "Libìà",
    "MA" to "Màrokò",
    "MC" to "Mònakò",
    "MD" to "Moldavìà",
    "MG" to "Màdàgàskâr",
    "MH" to "Bìòn bi Marcàl",
    "ML" to "Màli",
    "MM" to "Myànmâr",
    "MN" to "Mòŋgolìà",
    "MP" to "Bìòn bi Marìanà ŋ̀ɔmbɔk",
    "MQ" to "Màrtìnîk",
    "MR" to "Mòrìtanìà",
    "MS" to "Mɔ̀ŋseràt",
    "MT" to "Maltà",
    "MU" to "Mòrîs",
    "MV" to "Màldîf",
    "MW" to "Màlàwi",
    "MX" to "Mɛ̀gsîk",
    "MY" to "Màlɛ̀sìà",
    "MZ" to "Mòsàmbîk",
    "NA" to "Nàmibìà",
    "NC" to "Kàlèdonìà Yɔ̀ndɔ",
    "NE" to "Nìjɛ̂r",
    "NF" to "Òn i Nɔrfɔ̂k",
    "NG" to "Nìgerìà",
    "NI" to "Nìkàragwà",
    "NL" to "Ǹlɛndi",
    "NO" to "Nɔ̀rvegìà",
    "NP" to "Nèpâl",
    "NR" to "Nerù",
    "NU" to "Nìuɛ̀",
    "NZ" to "Sìlând Yɔ̀ndɔ",
    "OM" to "Òmân",
    "PA" to "Pànàma",
    "PE" to "Pèrû",
    "PF" to "Pòlìnesìà Pùlàsi",
    "PG" to "Gìne ì Pàpu",
    "PH" to "Fìlìpîn",
    "PK" to "Pàkìstân",
    "PL" to "Pòlànd",
    "PM" to "Nûmpubi Petrò nì Mikèlôn",
    "PN" to "Pìdkaìrn",
    "PR" to "Pɔ̀rtò Rikò",
    "PS" to "Pàlɛ̀htinà Hyɔ̀ŋg nì Gazà",
    "PT" to "Pɔ̀tɔkì",
    "PW" to "Pàlaù",
    "PY" to "Pàràgwê",
    "QA" to "Kàtâr",
    "RE" to "Rèunyɔ̂ŋ",
    "RO" to "Rùmanìà",
    "RU" to "Ruslànd",
    "RW" to "Rùandà",
    "SA" to "Sàudi Àrabìà",
    "SB" to "Bìòn bi Salōmò",
    "SC" to "Sèsɛ̂l",
    "SD" to "Sùdâŋ",
    "SE" to "Swedɛ̀n",
    "SG" to "Sìŋgàpûr",
    "SH" to "Nûmpubi Ɛlēnà",
    "SI" to "Slòvanìà",
    "SK" to "Slòvakìà",
    "SL" to "Sièra Lèɔ̂n",
    "SM" to "Nûmpubi Māatìn",
    "SN" to "Sènègâl",
    "SO" to "Sòmalìà",
    "SR" to "Sùrinâm",
    "ST" to "Sào Tòme ɓɔ Prɛ̀ŋcipè",
    "SV" to "Sàlvàdɔ̂r",
    "SY" to "Sirìà",
    "SZ" to "Swàzìlând",
    "TC" to "Bìòn bi Tûrks nì Kalkòs",
    "TD" to "Câd",
    "TG" to "Tògo",
    "TH" to "Taylànd",
    "TJ" to "Tàjìkìstaŋ",
    "TK" to "Tòkèlaò",
    "TL" to "Tìmɔ̂r lìkòl",
    "TM" to "Tùrgmènìstân",
    "TN" to "Tùnisìà",
    "TO" to "Tɔŋgà",
    "TR" to "Tùrkây",
    "TT" to "Trìnidàd ɓɔ Tòbagò",
    "TV" to "Tùvàlù",
    "TW" to "Tàywân",
    "TZ" to "Tànzànià",
    "UA" to "Ùkrɛ̌n",
    "UG" to "Ùgandà",
    "US" to "Àdnà i Bilɔ̀ŋ bi Amerkà",
    "UY" to "Ùrùgwêy",
    "UZ" to "Ùzbèkìstân",
    "VA" to "Vàtìkâŋ",
    "VC" to "Nûmpubi Vɛ̂ŋsâŋ nì grènàdîn",
    "VE" to "Vènèzùelà",
    "VG" to "Bìòn bi kɔnji bi Ŋgisì",
    "VI" to "Bìòn bi kɔnji bi U.S.",
    "VN" to "Vìɛ̀dnâm",
    "VU" to "Vànùatù",
    "WF" to "Wàlîs nì Fùtunà",
    "WS" to "Sàmoà",
    "YE" to "Yèmɛ̂n",
    "YT" to "Màyɔ̂t",
    "ZA" to "Àfrǐkà Sɔ̀",
    "ZM" to "Zàmbià",
    "ZW" to "Zìmbàbwê",
  ) }

  val be: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Свет",
    "002" to "Афрыка",
    "003" to "Паўночная Амерыка",
    "005" to "Паўднёвая Амерыка",
    "009" to "Акіянія",
    "011" to "Заходняя Афрыка",
    "013" to "Цэнтральная Амерыка",
    "014" to "Усходняя Афрыка",
    "015" to "Паўночная Афрыка",
    "017" to "Сярэдняя Афрыка",
    "018" to "Паўднёвая Афрыка",
    "019" to "Паўночная і Паўднёвая Амерыкі",
    "021" to "Паўночнаамерыканскі рэгіён",
    "029" to "Карыбскі рэгіён",
    "030" to "Усходняя Азія",
    "034" to "Паўднёвая Азія",
    "035" to "Паўднёва-Усходняя Азія",
    "039" to "Паўднёвая Еўропа",
    "053" to "Аўстралазія",
    "054" to "Меланезія",
    "057" to "Мікранезійскі рэгіён",
    "061" to "Палінезія",
    "142" to "Азія",
    "143" to "Цэнтральная Азія",
    "145" to "Заходняя Азія",
    "150" to "Еўропа",
    "151" to "Усходняя Еўропа",
    "154" to "Паўночная Еўропа",
    "155" to "Заходняя Еўропа",
    "202" to "Трапічная Афрыка",
    "419" to "Лацінская Амерыка",
    "AC" to "Востраў Узнясення",
    "AD" to "Андора",
    "AE" to "Аб’яднаныя Арабскія Эміраты",
    "AF" to "Афганістан",
    "AG" to "Антыгуа і Барбуда",
    "AI" to "Ангілья",
    "AL" to "Албанія",
    "AM" to "Арменія",
    "AO" to "Ангола",
    "AQ" to "Антарктыка",
    "AR" to "Аргенціна",
    "AS" to "Амерыканскае Самоа",
    "AT" to "Аўстрыя",
    "AU" to "Аўстралія",
    "AW" to "Аруба",
    "AX" to "Аландскія астравы",
    "AZ" to "Азербайджан",
    "BA" to "Боснія і Герцагавіна",
    "BB" to "Барбадас",
    "BD" to "Бангладэш",
    "BE" to "Бельгія",
    "BF" to "Буркіна-Фасо",
    "BG" to "Балгарыя",
    "BH" to "Бахрэйн",
    "BI" to "Бурундзі",
    "BJ" to "Бенін",
    "BL" to "Сен-Бартэльмі",
    "BM" to "Бермудскія астравы",
    "BN" to "Бруней",
    "BO" to "Балівія",
    "BQ" to "Карыбскія Нідэрланды",
    "BR" to "Бразілія",
    "BS" to "Багамскія астравы",
    "BT" to "Бутан",
    "BV" to "Востраў Бувэ",
    "BW" to "Батсвана",
    "BY" to "Беларусь",
    "BZ" to "Беліз",
    "CA" to "Канада",
    "CC" to "Какосавыя (Кілінг) астравы",
    "CD" to "Конга (Кіншаса)",
    "CF" to "Цэнтральна-Афрыканская Рэспубліка",
    "CG" to "Конга - Бразавіль",
    "CH" to "Швейцарыя",
    "CI" to "Кот-д’Івуар",
    "CK" to "Астравы Кука",
    "CL" to "Чылі",
    "CM" to "Камерун",
    "CN" to "Кітай",
    "CO" to "Калумбія",
    "CP" to "Востраў Кліпертан",
    "CR" to "Коста-Рыка",
    "CU" to "Куба",
    "CV" to "Каба-Вердэ",
    "CW" to "Кюрасаа",
    "CX" to "Востраў Каляд",
    "CY" to "Кіпр",
    "CZ" to "Чэхія",
    "DE" to "Германія",
    "DG" to "Востраў Дыега-Гарсія",
    "DJ" to "Джыбуці",
    "DK" to "Данія",
    "DM" to "Дамініка",
    "DO" to "Дамініканская Рэспубліка",
    "DZ" to "Алжыр",
    "EA" to "Сеута і Мелілья",
    "EC" to "Эквадор",
    "EE" to "Эстонія",
    "EG" to "Егіпет",
    "EH" to "Заходняя Сахара",
    "ER" to "Эрытрэя",
    "ES" to "Іспанія",
    "ET" to "Эфіопія",
    "EU" to "Еўрапейскі саюз",
    "EZ" to "Еўразона",
    "FI" to "Фінляндыя",
    "FJ" to "Фіджы",
    "FK" to "Фалклендскія астравы",
    "FM" to "Мікранезія",
    "FO" to "Фарэрскія астравы",
    "FR" to "Францыя",
    "GA" to "Габон",
    "GB" to "Вялікабрытанія",
    "GD" to "Грэнада",
    "GE" to "Грузія",
    "GF" to "Французская Гвіяна",
    "GG" to "Гернсі",
    "GH" to "Гана",
    "GI" to "Гібралтар",
    "GL" to "Грэнландыя",
    "GM" to "Гамбія",
    "GN" to "Гвінея",
    "GP" to "Гвадэлупа",
    "GQ" to "Экватарыяльная Гвінея",
    "GR" to "Грэцыя",
    "GS" to "Паўднёвая Георгія і Паўднёвыя Сандвічавы астравы",
    "GT" to "Гватэмала",
    "GU" to "Гуам",
    "GW" to "Гвінея-Бісау",
    "GY" to "Гаяна",
    "HK" to "Ганконг, САР (Кітай)",
    "HM" to "Астравы Херд і Макдональд",
    "HN" to "Гандурас",
    "HR" to "Харватыя",
    "HT" to "Гаіці",
    "HU" to "Венгрыя",
    "IC" to "Канарскія астравы",
    "ID" to "Інданезія",
    "IE" to "Ірландыя",
    "IL" to "Ізраіль",
    "IM" to "Востраў Мэн",
    "IN" to "Індыя",
    "IO" to "Брытанская тэрыторыя ў Індыйскім акіяне",
    "IQ" to "Ірак",
    "IR" to "Іран",
    "IS" to "Ісландыя",
    "IT" to "Італія",
    "JE" to "Джэрсі",
    "JM" to "Ямайка",
    "JO" to "Іарданія",
    "JP" to "Японія",
    "KE" to "Кенія",
    "KG" to "Кыргызстан",
    "KH" to "Камбоджа",
    "KI" to "Кірыбаці",
    "KM" to "Каморскія астравы",
    "KN" to "Сент-Кітс і Невіс",
    "KP" to "Паўночная Карэя",
    "KR" to "Паўднёвая Карэя",
    "KW" to "Кувейт",
    "KY" to "Кайманавы астравы",
    "KZ" to "Казахстан",
    "LA" to "Лаос",
    "LB" to "Ліван",
    "LC" to "Сент-Люсія",
    "LI" to "Ліхтэнштэйн",
    "LK" to "Шры-Ланка",
    "LR" to "Ліберыя",
    "LS" to "Лесота",
    "LT" to "Літва",
    "LU" to "Люксембург",
    "LV" to "Латвія",
    "LY" to "Лівія",
    "MA" to "Марока",
    "MC" to "Манака",
    "MD" to "Малдова",
    "ME" to "Чарнагорыя",
    "MF" to "Сен-Мартэн",
    "MG" to "Мадагаскар",
    "MH" to "Маршалавы астравы",
    "MK" to "Паўночная Македонія",
    "ML" to "Малі",
    "MM" to "М’янма (Бірма)",
    "MN" to "Манголія",
    "MO" to "Макаа, САР (Кітай)",
    "MP" to "Паўночныя Марыянскія астравы",
    "MQ" to "Марцініка",
    "MR" to "Маўрытанія",
    "MS" to "Мантсерат",
    "MT" to "Мальта",
    "MU" to "Маўрыкій",
    "MV" to "Мальдывы",
    "MW" to "Малаві",
    "MX" to "Мексіка",
    "MY" to "Малайзія",
    "MZ" to "Мазамбік",
    "NA" to "Намібія",
    "NC" to "Новая Каледонія",
    "NE" to "Нігер",
    "NF" to "Востраў Норфалк",
    "NG" to "Нігерыя",
    "NI" to "Нікарагуа",
    "NL" to "Нідэрланды",
    "NO" to "Нарвегія",
    "NP" to "Непал",
    "NR" to "Науру",
    "NU" to "Ніуэ",
    "NZ" to "Новая Зеландыя",
    "OM" to "Аман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PF" to "Французская Палінезія",
    "PG" to "Папуа-Новая Гвінея",
    "PH" to "Філіпіны",
    "PK" to "Пакістан",
    "PL" to "Польшча",
    "PM" to "Сен-П’ер і Мікелон",
    "PN" to "Астравы Піткэрн",
    "PR" to "Пуэрта-Рыка",
    "PS" to "Палесцінскія Тэрыторыі",
    "PT" to "Партугалія",
    "PW" to "Палау",
    "PY" to "Парагвай",
    "QA" to "Катар",
    "QO" to "Аддаленыя тэрыторыі Акіяніі",
    "RE" to "Рэюньён",
    "RO" to "Румынія",
    "RS" to "Сербія",
    "RU" to "Расія",
    "RW" to "Руанда",
    "SA" to "Саудаўская Аравія",
    "SB" to "Саламонавы астравы",
    "SC" to "Сейшэльскія астравы",
    "SD" to "Судан",
    "SE" to "Швецыя",
    "SG" to "Сінгапур",
    "SH" to "Востраў Святой Алены",
    "SI" to "Славенія",
    "SJ" to "Шпіцберген і Ян-Маен",
    "SK" to "Славакія",
    "SL" to "Сьера-Леонэ",
    "SM" to "Сан-Марына",
    "SN" to "Сенегал",
    "SO" to "Самалі",
    "SR" to "Сурынам",
    "SS" to "Паўднёвы Судан",
    "ST" to "Сан-Тамэ і Прынсіпі",
    "SV" to "Сальвадор",
    "SX" to "Сінт-Мартэн",
    "SY" to "Сірыя",
    "SZ" to "Эсватыні",
    "TA" to "Трыстан-да-Кунья",
    "TC" to "Астравы Цёркс і Кайкас",
    "TD" to "Чад",
    "TF" to "Французскія паўднёвыя тэрыторыі",
    "TG" to "Тога",
    "TH" to "Тайланд",
    "TJ" to "Таджыкістан",
    "TK" to "Такелау",
    "TL" to "Тымор-Лешці",
    "TM" to "Туркменістан",
    "TN" to "Туніс",
    "TO" to "Тонга",
    "TR" to "Турцыя",
    "TT" to "Трынідад і Табага",
    "TV" to "Тувалу",
    "TW" to "Тайвань",
    "TZ" to "Танзанія",
    "UA" to "Украіна",
    "UG" to "Уганда",
    "UM" to "Малыя Аддаленыя астравы ЗША",
    "UN" to "Арганізацыя Аб’яднаных Нацый",
    "US" to "Злучаныя Штаты Амерыкі",
    "UY" to "Уругвай",
    "UZ" to "Узбекістан",
    "VA" to "Ватыкан",
    "VC" to "Сент-Вінсент і Грэнадзіны",
    "VE" to "Венесуэла",
    "VG" to "Брытанскія Віргінскія астравы",
    "VI" to "Амерыканскія Віргінскія астравы",
    "VN" to "В’етнам",
    "VU" to "Вануату",
    "WF" to "Уоліс і Футуна",
    "WS" to "Самоа",
    "XA" to "Псеўдаакцэнты",
    "XB" to "Псеўдадвухнапрамкавы",
    "XK" to "Косава",
    "YE" to "Емен",
    "YT" to "Маёта",
    "ZA" to "Паўднёва-Афрыканская Рэспубліка",
    "ZM" to "Замбія",
    "ZW" to "Зімбабвэ",
    "ZZ" to "Невядомы рэгіён",
  ) }

  val be_tarask: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bem: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ZM" to "Zambia",
  ) }

  val bez: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Huandola",
    "AE" to "Hufalme dza Hihalabu",
    "AF" to "Huafuganistani",
    "AG" to "Huantigua na Hubarubuda",
    "AI" to "Huanguila",
    "AL" to "Hualbania",
    "AM" to "Huamenia",
    "AO" to "Huangola",
    "AR" to "Huajendina",
    "AS" to "Husamoa ya Humalekani",
    "AT" to "Huastlia",
    "AU" to "Huaustlalia",
    "AW" to "Hualuba",
    "AZ" to "Huazabajani",
    "BA" to "Hubosinia na Huhezegovina",
    "BB" to "Hubabadosi",
    "BD" to "Hubangaladeshi",
    "BE" to "Huubelgiji",
    "BF" to "Hubukinafaso",
    "BG" to "Hubulgaria",
    "BH" to "Hubahaleni",
    "BI" to "Huburundi",
    "BJ" to "Hubenini",
    "BM" to "Hubelmuda",
    "BN" to "Hubrunei",
    "BO" to "Hubolivia",
    "BR" to "Hublazili",
    "BS" to "Hubahama",
    "BT" to "Hubutani",
    "BW" to "Hubotiswana",
    "BY" to "Hubelalusi",
    "BZ" to "Hubelize",
    "CA" to "Hukanada",
    "CD" to "Ijamhuri ya Hidemokrasi ya Hukongo",
    "CF" to "Ijamhuri ya Afrika ya Pagati",
    "CG" to "Hukongo",
    "CH" to "Huuswisi",
    "CI" to "Hukodivaa",
    "CK" to "Ifisima fya Kook",
    "CL" to "Huchile",
    "CM" to "Hukameruni",
    "CN" to "Huchina",
    "CO" to "Hukolombia",
    "CR" to "Hukostarika",
    "CU" to "Hukuba",
    "CV" to "Hukepuvede",
    "CY" to "Hukuprosi",
    "CZ" to "Ijamhuri ya Cheki",
    "DE" to "Huujerumani",
    "DJ" to "Hujibuti",
    "DK" to "Hudenmaki",
    "DM" to "Hudominika",
    "DO" to "Ijamhuri ya Hudominika",
    "DZ" to "Hualjelia",
    "EC" to "Huekwado",
    "EE" to "Huestonia",
    "EG" to "Humisri",
    "ER" to "Hueritrea",
    "ES" to "Huhispania",
    "ET" to "Huuhabeshi",
    "FI" to "Huufini",
    "FJ" to "Hufiji",
    "FK" to "Ifisima fya Falkland",
    "FM" to "Humikronesia",
    "FR" to "Huufaransa",
    "GA" to "Hugaboni",
    "GB" to "Huuingereza",
    "GD" to "Hugrenada",
    "GE" to "Hujojia",
    "GF" to "Hugwiyana ya Huufaransa",
    "GH" to "Hughana",
    "GI" to "Hujiblalta",
    "GL" to "Hujinlandi",
    "GM" to "Hugambia",
    "GN" to "Hujine",
    "GP" to "Hugwadelupe",
    "GQ" to "Huginekweta",
    "GR" to "Huugiliki",
    "GT" to "Hugwatemala",
    "GU" to "Hugwam",
    "GW" to "Huginebisau",
    "GY" to "Huguyana",
    "HN" to "Huhondulasi",
    "HR" to "Hukorasia",
    "HT" to "Huhaiti",
    "HU" to "Huhungalia",
    "ID" to "Huindonesia",
    "IE" to "Huayalandi",
    "IL" to "Huislaheli",
    "IN" to "Huindia",
    "IQ" to "Huilaki",
    "IR" to "Huuajemi",
    "IS" to "Huaislandi",
    "IT" to "Huitalia",
    "JM" to "Hujamaika",
    "JO" to "Huyolodani",
    "JP" to "Hujapani",
    "KE" to "Hukenya",
    "KG" to "Hukiligizistani",
    "KH" to "Hukambodia",
    "KI" to "Hukilibati",
    "KM" to "Hukomoro",
    "KN" to "Husantakitzi na Hunevis",
    "KP" to "Hukolea Kaskazini",
    "KR" to "Hukolea Kusini",
    "KW" to "Hukuwaiti",
    "KY" to "Ifisima fya Kayman",
    "KZ" to "Hukazakistani",
    "LA" to "Hulaosi",
    "LB" to "Hulebanoni",
    "LC" to "Husantalusia",
    "LI" to "Hulishenteni",
    "LK" to "Husirilanka",
    "LR" to "Hulibelia",
    "LS" to "Hulesoto",
    "LT" to "Hulitwania",
    "LU" to "Hulasembagi",
    "LV" to "Hulativia",
    "LY" to "Hulibiya",
    "MA" to "Humoloko",
    "MC" to "Humonako",
    "MD" to "Humoldova",
    "MG" to "Hubukini",
    "MH" to "Ifisima fya Marshal",
    "ML" to "Humali",
    "MM" to "Humyama",
    "MN" to "Humongolia",
    "MP" to "Ifisima fya Mariana fya Hukaskazini",
    "MQ" to "Humartiniki",
    "MR" to "Humolitania",
    "MS" to "Humontserrati",
    "MT" to "Humalta",
    "MU" to "Humolisi",
    "MV" to "Humodivu",
    "MW" to "Humalawi",
    "MX" to "Humeksiko",
    "MY" to "Humalesia",
    "MZ" to "Humusumbiji",
    "NA" to "Hunamibia",
    "NC" to "Hunyukaledonia",
    "NE" to "Hunijeli",
    "NF" to "Ihisima sha Norfok",
    "NG" to "Hunijelia",
    "NI" to "Hunikaragwa",
    "NL" to "Huuholanzi",
    "NO" to "Hunolwe",
    "NP" to "Hunepali",
    "NR" to "Hunauru",
    "NU" to "Huniue",
    "NZ" to "Hunyuzilandi",
    "OM" to "Huomani",
    "PA" to "Hupanama",
    "PE" to "Hupelu",
    "PF" to "Hupolinesia ya Huufaransa",
    "PG" to "Hupapua",
    "PH" to "Hufilipino",
    "PK" to "Hupakistani",
    "PL" to "Hupolandi",
    "PM" to "Husantapieri na Humikeloni",
    "PN" to "Hupitkaini",
    "PR" to "Hupwetoriko",
    "PS" to "Ulubali lwa Magharibi nu Gaza wa Hupalestina",
    "PT" to "Huuleno",
    "PW" to "Hupalau",
    "PY" to "Hupalagwai",
    "QA" to "Hukatali",
    "RE" to "Huliyunioni",
    "RO" to "Hulomania",
    "RU" to "Huulusi",
    "RW" to "Hulwanda",
    "SA" to "Husaudi",
    "SB" to "Ifisima fya Solomon",
    "SC" to "Hushelisheli",
    "SD" to "Husudani",
    "SE" to "Huuswidi",
    "SG" to "Husingapoo",
    "SH" to "Husantahelena",
    "SI" to "Huslovenia",
    "SK" to "Huslovakia",
    "SL" to "Husiela Lioni",
    "SM" to "Husamalino",
    "SN" to "Husenegali",
    "SO" to "Husomalia",
    "SR" to "Husurinamu",
    "ST" to "Husaotome na Huprinsipe",
    "SV" to "Huelsavado",
    "SY" to "Husilia",
    "SZ" to "Huuswazi",
    "TC" to "Ifisima fya Turki na Kaiko",
    "TD" to "Huchadi",
    "TG" to "Hutogo",
    "TH" to "Hutailandi",
    "TJ" to "Hutajikistani",
    "TK" to "Hutokelau",
    "TL" to "Hutimori ya Mashariki",
    "TM" to "Huuturukimenistani",
    "TN" to "Hutunisia",
    "TO" to "Hutonga",
    "TR" to "Huuturuki",
    "TT" to "Hutrinad na Hutobago",
    "TV" to "Hutuvalu",
    "TW" to "Hutaiwani",
    "TZ" to "Hutanzania",
    "UA" to "Huukraini",
    "UG" to "Huuganda",
    "US" to "Humalekani",
    "UY" to "Huulugwai",
    "UZ" to "Huuzibekistani",
    "VA" to "Huvatikani",
    "VC" to "Husantavisenti na Hugrenadini",
    "VE" to "Huvenezuela",
    "VG" to "Ifisima fya Virgin fya Huingereza",
    "VI" to "Ifisima fya Virgin fya Humelekani",
    "VN" to "Huvietinamu",
    "VU" to "Huvanuatu",
    "WF" to "Huwalis na Hufutuna",
    "WS" to "Husamoa",
    "YE" to "Huyemeni",
    "YT" to "Humayotte",
    "ZA" to "Huafrika iya Hukusini",
    "ZM" to "Huzambia",
    "ZW" to "Huzimbabwe",
  ) }

  val bg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "свят",
    "002" to "Африка",
    "003" to "Северноамерикански континент",
    "005" to "Южна Америка",
    "009" to "Океания",
    "011" to "Западна Афирка",
    "013" to "Централна Америка",
    "014" to "Източна Африка",
    "015" to "Северна Африка",
    "017" to "Централна Африка",
    "018" to "Южноафрикански регион",
    "019" to "Америка",
    "021" to "Северна Америка",
    "029" to "Карибски регион",
    "030" to "Източна Азия",
    "034" to "Южна Азия",
    "035" to "Югоизточна Азия",
    "039" to "Южна Европа",
    "053" to "Австралазия",
    "054" to "Меланезия",
    "057" to "Микронезийски регион",
    "061" to "Полинезия",
    "142" to "Азия",
    "143" to "Централна Азия",
    "145" to "Западна Азия",
    "150" to "Европа",
    "151" to "Източна Европа",
    "154" to "Северна Европа",
    "155" to "Западна Европа",
    "202" to "Субсахарска Африка",
    "419" to "Латинска Америка",
    "AC" to "остров Възнесение",
    "AD" to "Андора",
    "AE" to "Обединени арабски емирства",
    "AF" to "Афганистан",
    "AG" to "Антигуа и Барбуда",
    "AI" to "Ангуила",
    "AL" to "Албания",
    "AM" to "Армения",
    "AO" to "Ангола",
    "AQ" to "Антарктика",
    "AR" to "Аржентина",
    "AS" to "Американска Самоа",
    "AT" to "Австрия",
    "AU" to "Австралия",
    "AW" to "Аруба",
    "AX" to "Оландски острови",
    "AZ" to "Азербайджан",
    "BA" to "Босна и Херцеговина",
    "BB" to "Барбадос",
    "BD" to "Бангладеш",
    "BE" to "Белгия",
    "BF" to "Буркина Фасо",
    "BG" to "България",
    "BH" to "Бахрейн",
    "BI" to "Бурунди",
    "BJ" to "Бенин",
    "BL" to "Сен Бартелеми",
    "BM" to "Бермудски острови",
    "BN" to "Бруней Даруссалам",
    "BO" to "Боливия",
    "BQ" to "Карибска Нидерландия",
    "BR" to "Бразилия",
    "BS" to "Бахамски острови",
    "BT" to "Бутан",
    "BV" to "остров Буве",
    "BW" to "Ботсвана",
    "BY" to "Беларус",
    "BZ" to "Белиз",
    "CA" to "Канада",
    "CC" to "Кокосови острови (острови Кийлинг)",
    "CD" to "Конго (Киншаса)",
    "CF" to "Централноафриканска република",
    "CG" to "Конго (Бразавил)",
    "CH" to "Швейцария",
    "CI" to "Кот д’Ивоар",
    "CK" to "острови Кук",
    "CL" to "Чили",
    "CM" to "Камерун",
    "CN" to "Китай",
    "CO" to "Колумбия",
    "CP" to "остров Клипертон",
    "CR" to "Коста Рика",
    "CU" to "Куба",
    "CV" to "Кабо Верде",
    "CW" to "Кюрасао",
    "CX" to "остров Рождество",
    "CY" to "Кипър",
    "CZ" to "Чехия",
    "DE" to "Германия",
    "DG" to "Диего Гарсия",
    "DJ" to "Джибути",
    "DK" to "Дания",
    "DM" to "Доминика",
    "DO" to "Доминиканска република",
    "DZ" to "Алжир",
    "EA" to "Сеута и Мелия",
    "EC" to "Еквадор",
    "EE" to "Естония",
    "EG" to "Египет",
    "EH" to "Западна Сахара",
    "ER" to "Еритрея",
    "ES" to "Испания",
    "ET" to "Етиопия",
    "EU" to "Европейски съюз",
    "EZ" to "еврозона",
    "FI" to "Финландия",
    "FJ" to "Фиджи",
    "FK" to "Фолкландски острови",
    "FM" to "Микронезия",
    "FO" to "Фарьорски острови",
    "FR" to "Франция",
    "GA" to "Габон",
    "GB" to "Обединеното кралство",
    "GD" to "Гренада",
    "GE" to "Грузия",
    "GF" to "Френска Гвиана",
    "GG" to "Гърнзи",
    "GH" to "Гана",
    "GI" to "Гибралтар",
    "GL" to "Гренландия",
    "GM" to "Гамбия",
    "GN" to "Гвинея",
    "GP" to "Гваделупа",
    "GQ" to "Екваториална Гвинея",
    "GR" to "Гърция",
    "GS" to "Южна Джорджия и Южни Сандвичеви острови",
    "GT" to "Гватемала",
    "GU" to "Гуам",
    "GW" to "Гвинея-Бисау",
    "GY" to "Гаяна",
    "HK" to "Хонконг, САР на Китай",
    "HM" to "острови Хърд и Макдоналд",
    "HN" to "Хондурас",
    "HR" to "Хърватия",
    "HT" to "Хаити",
    "HU" to "Унгария",
    "IC" to "Канарски острови",
    "ID" to "Индонезия",
    "IE" to "Ирландия",
    "IL" to "Израел",
    "IM" to "остров Ман",
    "IN" to "Индия",
    "IO" to "Британска територия в Индийския океан",
    "IQ" to "Ирак",
    "IR" to "Иран",
    "IS" to "Исландия",
    "IT" to "Италия",
    "JE" to "Джърси",
    "JM" to "Ямайка",
    "JO" to "Йордания",
    "JP" to "Япония",
    "KE" to "Кения",
    "KG" to "Киргизстан",
    "KH" to "Камбоджа",
    "KI" to "Кирибати",
    "KM" to "Коморски острови",
    "KN" to "Сейнт Китс и Невис",
    "KP" to "Северна Корея",
    "KR" to "Южна Корея",
    "KW" to "Кувейт",
    "KY" to "Кайманови острови",
    "KZ" to "Казахстан",
    "LA" to "Лаос",
    "LB" to "Ливан",
    "LC" to "Сейнт Лусия",
    "LI" to "Лихтенщайн",
    "LK" to "Шри Ланка",
    "LR" to "Либерия",
    "LS" to "Лесото",
    "LT" to "Литва",
    "LU" to "Люксембург",
    "LV" to "Латвия",
    "LY" to "Либия",
    "MA" to "Мароко",
    "MC" to "Монако",
    "MD" to "Молдова",
    "ME" to "Черна гора",
    "MF" to "Сен Мартен",
    "MG" to "Мадагаскар",
    "MH" to "Маршалови острови",
    "MK" to "Северна Македония",
    "ML" to "Мали",
    "MM" to "Мианмар (Бирма)",
    "MN" to "Монголия",
    "MO" to "Макао, САР на Китай",
    "MP" to "Северни Мариански острови",
    "MQ" to "Мартиника",
    "MR" to "Мавритания",
    "MS" to "Монтсерат",
    "MT" to "Малта",
    "MU" to "Мавриций",
    "MV" to "Малдиви",
    "MW" to "Малави",
    "MX" to "Мексико",
    "MY" to "Малайзия",
    "MZ" to "Мозамбик",
    "NA" to "Намибия",
    "NC" to "Нова Каледония",
    "NE" to "Нигер",
    "NF" to "остров Норфолк",
    "NG" to "Нигерия",
    "NI" to "Никарагуа",
    "NL" to "Нидерландия",
    "NO" to "Норвегия",
    "NP" to "Непал",
    "NR" to "Науру",
    "NU" to "Ниуе",
    "NZ" to "Нова Зеландия",
    "OM" to "Оман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PF" to "Френска Полинезия",
    "PG" to "Папуа-Нова Гвинея",
    "PH" to "Филипини",
    "PK" to "Пакистан",
    "PL" to "Полша",
    "PM" to "Сен Пиер и Микелон",
    "PN" to "Острови Питкерн",
    "PR" to "Пуерто Рико",
    "PS" to "Палестински територии",
    "PT" to "Португалия",
    "PW" to "Палау",
    "PY" to "Парагвай",
    "QA" to "Катар",
    "QO" to "Отдалечени острови на Океания",
    "RE" to "Реюнион",
    "RO" to "Румъния",
    "RS" to "Сърбия",
    "RU" to "Русия",
    "RW" to "Руанда",
    "SA" to "Саудитска Арабия",
    "SB" to "Соломонови острови",
    "SC" to "Сейшели",
    "SD" to "Судан",
    "SE" to "Швеция",
    "SG" to "Сингапур",
    "SH" to "Света Елена",
    "SI" to "Словения",
    "SJ" to "Свалбард и Ян Майен",
    "SK" to "Словакия",
    "SL" to "Сиера Леоне",
    "SM" to "Сан Марино",
    "SN" to "Сенегал",
    "SO" to "Сомалия",
    "SR" to "Суринам",
    "SS" to "Южен Судан",
    "ST" to "Сао Томе и Принсипи",
    "SV" to "Салвадор",
    "SX" to "Синт Мартен",
    "SY" to "Сирия",
    "SZ" to "Есватини",
    "TA" to "Тристан да Куня",
    "TC" to "острови Търкс и Кайкос",
    "TD" to "Чад",
    "TF" to "Френски южни територии",
    "TG" to "Того",
    "TH" to "Тайланд",
    "TJ" to "Таджикистан",
    "TK" to "Токелау",
    "TL" to "Тимор Лесте",
    "TM" to "Туркменистан",
    "TN" to "Тунис",
    "TO" to "Тонга",
    "TR" to "Турция",
    "TT" to "Тринидад и Тобаго",
    "TV" to "Тувалу",
    "TW" to "Тайван",
    "TZ" to "Танзания",
    "UA" to "Украйна",
    "UG" to "Уганда",
    "UM" to "Отдалечени острови на САЩ",
    "UN" to "Организация на обединените нации",
    "US" to "Съединени щати",
    "UY" to "Уругвай",
    "UZ" to "Узбекистан",
    "VA" to "Ватикан",
    "VC" to "Сейнт Винсънт и Гренадини",
    "VE" to "Венецуела",
    "VG" to "Британски Вирджински острови",
    "VI" to "Американски Вирджински острови",
    "VN" to "Виетнам",
    "VU" to "Вануату",
    "WF" to "Уолис и Футуна",
    "WS" to "Самоа",
    "XA" to "Псевдоакценти",
    "XB" to "Псевдодвупосочни",
    "XK" to "Косово",
    "YE" to "Йемен",
    "YT" to "Майот",
    "ZA" to "Южна Африка",
    "ZM" to "Замбия",
    "ZW" to "Зимбабве",
    "ZZ" to "непознат регион",
  ) }

  val bgc: ImmutableMap<String, String> by lazy { immutableMapOf(
    "IN" to "भारत",
    "ZZ" to "अणजाण जगह",
  ) }

  val bgn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "دونیا/جهان",
    "002" to "افریقا",
    "009" to "اوقیانوسیه",
    "019" to "امریکای براعظم",
    "053" to "استرالیا",
    "142" to "اسیا",
    "150" to "اورورپا",
    "AE" to "متحدین عربین امارات",
    "AI" to "انگویلا",
    "AO" to "انگولا",
    "AR" to "ارجنٹاین",
    "AU" to "اسٹرالیا",
    "AZ" to "آزربایجان",
    "BE" to "بیلجیم",
    "BG" to "بولغاریه",
    "BH" to "بحرین",
    "BI" to "بروندی",
    "BM" to "بیرمودا",
    "BN" to "برونی",
    "BO" to "بولیویه",
    "BR" to "برازیل",
    "BS" to "بهاماس",
    "BT" to "بوتان",
    "CA" to "کاناڈا",
    "CL" to "چیلی",
    "CM" to "کامیرون",
    "CN" to "چین",
    "CO" to "کولومبیا",
    "CU" to "کوبا",
    "CY" to "قبرس",
    "DE" to "جرمنی",
    "DJ" to "جیبوتی",
    "DZ" to "الجزایر",
    "EC" to "اکوادور",
    "EG" to "مصر",
    "EH" to "روچ‌کپتین سحرا",
    "ER" to "اریتره",
    "ES" to "هسپانیه",
    "ET" to "ایتوپیه",
    "EU" to "اورورپایی یکویی",
    "FJ" to "فیجی",
    "FR" to "فرانسه",
    "GA" to "گابون",
    "GE" to "گرجستان",
    "GH" to "گانا",
    "GL" to "گرینلاند",
    "GM" to "گامبیا",
    "GN" to "گوینیا",
    "GR" to "یونان",
    "GY" to "گویانا",
    "HK" to "هانگ کانگ",
    "HU" to "هنگری",
    "ID" to "ایندونیزیا",
    "IL" to "اسرائیل",
    "IQ" to "عراق",
    "IT" to "ایتالیه",
    "JO" to "اردن",
    "KE" to "کینیا",
    "KG" to "قیرغیزستان",
    "KH" to "کمبودیا",
    "KM" to "کومورس",
    "KW" to "کویٹ",
    "KZ" to "قزاقستان",
    "LA" to "لاوس",
    "LB" to "لیبنان",
    "LY" to "لیبیا",
    "MA" to "مراکو",
    "MD" to "مالداویا",
    "MG" to "ماداگاسکار",
    "ML" to "مالی",
    "MT" to "مالته",
    "MU" to "موریتانیا",
    "MX" to "مکسیکو",
    "MY" to "مالیزیا",
    "NE" to "نیجیر",
    "NG" to "نایجیریا",
    "NZ" to "نیوزلنڈ",
    "OM" to "ئومان",
    "PA" to "پانامه",
    "PE" to "پیرو",
    "PH" to "فلیپین",
    "PT" to "پورتگال",
    "PY" to "پاراگوی",
    "QA" to "قطر",
    "RO" to "رومانیه",
    "RS" to "سیربستان",
    "RW" to "روندا",
    "SC" to "سیشیل",
    "SD" to "سوڈان",
    "SG" to "سینگاپور",
    "SN" to "سینیگال",
    "SO" to "سومالیا",
    "SR" to "سورینامی",
    "SY" to "سوریه",
    "TD" to "چاد",
    "TH" to "ٹایلنڈ",
    "TJ" to "تاجیکستان",
    "TM" to "تورکمنستان",
    "TN" to "ٹونیس",
    "TZ" to "تانزانیا",
    "UG" to "اوگاندا",
    "US" to "متحدین ایالات",
    "UY" to "اوراگوی",
    "UZ" to "اوزبکیستان",
    "VE" to "وینزوویلا",
    "VN" to "ویتنام",
    "YE" to "یمن",
    "ZM" to "زامبیا",
    "ZW" to "زیمبابوی",
    "ZZ" to "نازانتین سیمسر",
  ) }

  val bgn_AE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bgn_AF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bgn_IR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bgn_OM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bho: ImmutableMap<String, String> by lazy { immutableMapOf(
    "IN" to "भारत",
    "ZZ" to "अनजान इलाका",
  ) }

  val blo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "nɖulinya",
    "002" to "Garɩɖontǝna",
    "003" to "Gamalɩkatǝna gʊnyɩpɛnɛlaŋ",
    "005" to "Gamalɩkatǝna gʊnyɩsonolaŋ",
    "009" to "Oseyanii",
    "011" to "Garɩɖontǝna gɩteŋshilelaŋ",
    "013" to "Gamalɩkatǝna gɩcɩɩca",
    "014" to "Garɩɖontǝna gajakalaŋ",
    "015" to "Garɩɖontǝna gʊnyɩpɛnɛlaŋ",
    "017" to "Garɩɖontǝna gɩcɩɩca",
    "018" to "Garɩɖontǝna gʊnyɩsonolaŋ",
    "019" to "Gamalɩkatǝna",
    "021" to "Gamalɩkatǝna kagʊnyɩpɛnɛlaŋ",
    "029" to "Karayiib",
    "030" to "Gacǝlǝŋtǝna gajakalaŋ",
    "034" to "Gacǝlǝŋtǝna gʊnyɩsonolaŋ",
    "035" to "Gacǝlǝŋtǝna gʊsono na gajakayɛlaŋ kʊfɔɔ nɩ",
    "039" to "Garɩfɔntǝna gʊnyɩsonolaŋ",
    "053" to "Ɔstracǝlǝŋtǝna",
    "054" to "Melanesiya",
    "057" to "Mikronesiya kagʊsaʊ",
    "061" to "Polinesiya",
    "142" to "Gacǝlǝŋtǝna",
    "143" to "Gacǝlǝŋtǝna gɩcɩɩca",
    "145" to "Gacǝlǝŋtǝna gɩteŋshilelaŋ",
    "150" to "Garɩfɔntǝna",
    "151" to "Garɩfɔntǝna gajakalaŋ",
    "154" to "Garɩfɔntǝna gʊnyɩpɛnɛlaŋ",
    "155" to "Garɩfɔntǝna gɩteŋshilelaŋ",
    "202" to "Garɩɖontǝna Sahara katǝntǝn",
    "419" to "Latɛŋ kaAmalɩkatǝna",
    "AC" to "Asɛnsiyɔɔn kaAtukǝltǝna",
    "AD" to "Anɖɔraa",
    "AE" to "Emiir baGanɔ gaɖɔŋkɔnɔ kaAlaaributǝna",
    "AF" to "Afganistan",
    "AG" to "Antiguwaa na Barbuɖaa",
    "AI" to "Aŋguwilaa",
    "AL" to "Albanii",
    "AM" to "Armenii",
    "AO" to "Aŋgolaa",
    "AQ" to "Gatutaltǝna",
    "AR" to "Arjantin",
    "AS" to "Samowa Amalɩka kaja",
    "AT" to "Otrish",
    "AU" to "Ɔstraliya",
    "AW" to "Arubaa",
    "AX" to "Ɔɔlanɖ kaBʊtǝlǝltǝna",
    "AZ" to "Asɛrbaɩjaŋ",
    "BA" to "Bɔsniya na Hɛrsegɔfina",
    "BB" to "Barbaɖɔɔsɩ",
    "BD" to "Baŋglaɖɛɛshɩ",
    "BE" to "Bɛljiiki",
    "BF" to "Burkinaa",
    "BG" to "Bulgarii",
    "BH" to "Barɛɛn",
    "BI" to "Burunɖii",
    "BJ" to "Benɛɛ",
    "BL" to "Sɛŋ-Batolomayɔ",
    "BM" to "Bɛrmuɖaa",
    "BN" to "Brunɛɩ",
    "BO" to "Bolifiya",
    "BQ" to "Holanɖ kaKarayiib",
    "BR" to "Bresil",
    "BS" to "Bahamaasɩ",
    "BT" to "Butan",
    "BV" to "Bufee kaAtukǝltǝna",
    "BW" to "Bɔsʊwanaa",
    "BY" to "Belaruus",
    "BZ" to "Beliis",
    "CA" to "Kanaɖaa",
    "CC" to "Kokoos (Kiiliŋ) kaBʊtukǝltǝna",
    "CD" to "Koŋgoo Kinshasaa",
    "CF" to "Santrafrika",
    "CG" to "Koŋgoo Brasafil",
    "CH" to "Suwis",
    "CI" to "Koɖifʊaa",
    "CK" to "Kʊkʊ kaBʊtukǝltǝna",
    "CL" to "Shilii",
    "CM" to "Kamerun",
    "CN" to "Caɩna",
    "CO" to "Kolɔmbii",
    "CP" to "Klipɛɛtɔn kaAtukǝltǝna",
    "CQ" to "Sark",
    "CR" to "Kɔsta Rikaa",
    "CU" to "Kubaa",
    "CV" to "Kapfɛɛr",
    "CW" to "Kurasawuu",
    "CX" to "Nowɛl kaAtukǝltǝna",
    "CY" to "Ciprɔs",
    "CZ" to "Cɛk",
    "DE" to "Gajaamatǝna",
    "DG" to "Ɖiyego Garsiya",
    "DJ" to "Jibutii",
    "DK" to "Ɖanǝmark",
    "DM" to "Ɖominikaa",
    "DO" to "Ɖominikaa kaRepibliiki",
    "DZ" to "Aljerii",
    "EA" to "Seyuta na Meliliya",
    "EC" to "Ekuwaɖɔɔr",
    "EE" to "Ɛstoniya",
    "EG" to "Ejipti",
    "EH" to "Sarawii",
    "ER" to "Eritree",
    "ES" to "Ɛspanyǝ",
    "ET" to "Etiyopii",
    "EU" to "Ganɔ gaɖɔŋkɔnɔ kaBʊtǝna Garɩfɔntǝna nɩ",
    "EZ" to "Eroo kaBʊtǝna",
    "FI" to "Fɛnlanɖ",
    "FJ" to "Fiji",
    "FK" to "Fɔklanɖ kaBʊtukǝltǝna",
    "FM" to "Mikronesiya",
    "FO" to "Faroi kaBʊtukǝltǝna",
    "FR" to "Gafɔntǝna",
    "GA" to "Gabɔŋ",
    "GB" to "Gagɛɛshɩtǝna",
    "GD" to "Grenaɖaa",
    "GE" to "Jɔrjiya",
    "GF" to "Guyanaa Gafɔntǝna kaja",
    "GG" to "Gǝrǝnsɛɩ",
    "GH" to "Gana",
    "GI" to "Gibraltaa",
    "GL" to "Grinlanɖ",
    "GM" to "Gambii",
    "GN" to "Ginee",
    "GP" to "Guwaɖeluupu",
    "GQ" to "Ginee Malabo",
    "GR" to "Grɛs",
    "GS" to "Jɔrjiya gʊnyɩsonolaŋ kaja na Sanɖuush gʊnyɩsonolaŋ kaBʊtukǝltǝna",
    "GT" to "Guwatemalaa",
    "GU" to "Guwam",
    "GW" to "Ginee Bisoo",
    "GY" to "Guyanaa",
    "HK" to "Hɔŋ Kɔŋ Caɩna kaja",
    "HM" to "Hɛɛrɖ na Mɛkɖɔnalɖ kaBʊtukǝltǝna",
    "HN" to "Hɔnɖuraasɩ",
    "HR" to "Krowasii",
    "HT" to "Hayitii",
    "HU" to "Ɔŋgrii",
    "IC" to "Kanarii kaBʊtukǝltǝna",
    "ID" to "Ɛnɖonosii",
    "IE" to "Irlanɖ",
    "IL" to "Yishraɛl",
    "IM" to "Man kaAtukǝltǝna",
    "IN" to "Inɖiya",
    "IO" to "Gɛɛshɩ kaAtǝna Inɖiya kaTeŋku nɩ",
    "IQ" to "Ɩraakɩ",
    "IR" to "Iraŋ",
    "IS" to "Islanɖ",
    "IT" to "Italii",
    "JE" to "Jersei",
    "JM" to "Jamaɩka",
    "JO" to "Jɔrɖanii",
    "JP" to "Japaŋ",
    "KE" to "Keniya",
    "KG" to "Kirgistan",
    "KH" to "Kamboɖiya",
    "KI" to "Kiribatii",
    "KM" to "Komɔɔr",
    "KN" to "Sɛŋ Kits na Nefis",
    "KP" to "Koree gʊnyɩpɛnɛlaŋ",
    "KR" to "Koree gʊnyɩsonolaŋ",
    "KW" to "Koweeti",
    "KY" to "Kayimaan kaBʊtukǝltǝna",
    "KZ" to "Kasastan",
    "LA" to "Lawɔs",
    "LB" to "Liibaaŋ",
    "LC" to "Sɛŋ Lusiya",
    "LI" to "Liishtɛntaɩn",
    "LK" to "Siri Laŋkaa",
    "LR" to "Liberiya",
    "LS" to "Lesotoo",
    "LT" to "Lituwaniya",
    "LU" to "Lusɛmbuur",
    "LV" to "Lɛtfiya",
    "LY" to "Libii",
    "MA" to "Morooko",
    "MC" to "Monakoo",
    "MD" to "Mɔlɖafiya",
    "ME" to "Mɔntenegroo",
    "MF" to "Sɛŋ Martɛɛŋ",
    "MG" to "Maɖagaskaa",
    "MH" to "Marshal kaBʊtukǝltǝna",
    "MK" to "Maseɖoniya gʊnyɩpɛnɛlaŋ kaja",
    "ML" to "Malii",
    "MM" to "Miyanmaa (Birmanii)",
    "MN" to "Mɔŋgolii",
    "MO" to "Makawoo Caɩna kaja",
    "MP" to "Mariyan kaBʊtukǝltǝna gʊnyɩpɛnɛlaŋ",
    "MQ" to "Martiniiki",
    "MR" to "Moritanii",
    "MS" to "Mɔnsɛraatɩ",
    "MT" to "Malta",
    "MU" to "Imoris",
    "MV" to "Malɖiifu",
    "MW" to "Malawii",
    "MX" to "Mɛsik",
    "MY" to "Malɛsii",
    "MZ" to "Mosambii",
    "NA" to "Namibii",
    "NC" to "Kaleɖonii afɔlɩ",
    "NE" to "Nijɛr",
    "NF" to "Nɔrfook kaAtukǝltǝna",
    "NG" to "Nanjiiriya",
    "NI" to "Nikaraguwaa",
    "NL" to "Holanɖ",
    "NO" to "Nɔrfɛsh",
    "NP" to "Neepal",
    "NR" to "Nawuru",
    "NU" to "Niwuye",
    "NZ" to "Selanɖ afɔlɩ",
    "OM" to "Oman",
    "PA" to "Panamaa",
    "PE" to "Peruu",
    "PF" to "Polinesiya Gafɔntǝna kaja",
    "PG" to "Papuasii Ginee afɔlɩ",
    "PH" to "Filipiin",
    "PK" to "Pakistan",
    "PL" to "Polanɖ",
    "PM" to "Sɛŋ-Petrɔs na Mikelɔŋ",
    "PN" to "Pɩtkɛɛn kaBʊtukǝltǝna",
    "PR" to "Pɔrto Rikoo",
    "PS" to "Palɛstiin kAsàʊ",
    "PT" to "Pɔrtigal",
    "PW" to "Palawoo",
    "PY" to "Paraguwee",
    "QA" to "Kataa",
    "QO" to "Oseyanii kasaʊlǝŋka",
    "RE" to "Reeniyɔŋ",
    "RO" to "Romanii",
    "RS" to "Sɛrbii",
    "RU" to "Rɔɔshɩya",
    "RW" to "Rʊwanɖaa",
    "SA" to "Sauɖiya",
    "SB" to "Salomɔɔn kaBʊtukǝltǝna",
    "SC" to "Seshɛl",
    "SD" to "Suɖaŋ",
    "SE" to "Sʊwɛɖ",
    "SG" to "Siŋgapuur",
    "SH" to "Sɛŋ Elenaa (kaAtukǝltǝna)",
    "SI" to "Slofeniya",
    "SJ" to "Sǝfalbaaɖ na Yan Mayɛn",
    "SK" to "Slofakii",
    "SL" to "Seraleyɔn",
    "SM" to "Sɛŋ Marinoo",
    "SN" to "Senegal",
    "SO" to "Somalii",
    "SR" to "Surinam",
    "SS" to "Suɖaŋ gʊnyɩsonolaŋ",
    "ST" to "Saotomee",
    "SV" to "Ɛl Salfaɖɔɔr",
    "SX" to "Sɛŋ Martɛɛŋ (Holanɖ kaja)",
    "SY" to "Sirii",
    "SZ" to "Ɛsʊwatinii",
    "TA" to "Tristan ɖa Kuna",
    "TC" to "Turkisii na Kayɩkɔɔsɩ kaBʊtukǝltǝna",
    "TD" to "Caɖ",
    "TF" to "Gafɔntǝna kaBʊtǝna gʊnyɩsonolaŋ kabʊja",
    "TG" to "Togoo",
    "TH" to "Taɩlanɖ",
    "TJ" to "Tajikistan",
    "TK" to "Tokelaʊ",
    "TL" to "Timɔɔ gajakalaŋ",
    "TM" to "Turkmenistan",
    "TN" to "Tunisii",
    "TO" to "Tɔŋga",
    "TR" to "Turkii",
    "TT" to "Triniɖaaɖ na Tobagoo",
    "TV" to "Tufalu",
    "TW" to "Taɩwan",
    "TZ" to "Taŋsanii",
    "UA" to "Ikrɛɛn",
    "UG" to "Uganɖaa",
    "UM" to "Ganɔ gaɖɔŋkɔnɔ kaBʊtǝna Amalɩka nɩ kaBʊtukǝltǝna bʊlǝŋka",
    "UN" to "Ganɔ gaɖɔŋkɔnɔ kaBʊtǝna nɖulinya nɩ",
    "US" to "Ganɔ gaɖɔŋkɔnɔ kaBʊtǝna Amalɩka nɩ",
    "UY" to "Uruguwee",
    "UZ" to "Usbeekistan",
    "VA" to "Fatikaŋ kaMpá",
    "VC" to "Sɛŋ Fɩnsaŋ na Grenaɖiniisi",
    "VE" to "Fenesuwelaa",
    "VG" to "Fɩrjɩɩn kǝBʊtukǝltǝna Gɛɛshɩ kabʊja",
    "VI" to "Fɩrjɩɩn kaBʊtukǝltǝna Amalɩka kabʊja",
    "VN" to "Fɛtnam",
    "VU" to "Fanuwatu",
    "WF" to "Walis na Futuna",
    "WS" to "Samowa",
    "XA" to "sǝɖoo-aksaŋ",
    "XB" to "sǝɖoo-biɖi",
    "XK" to "Kɔsofoo",
    "YE" to "Yemɛn",
    "YT" to "Mayɔɔtɩ",
    "ZA" to "Sautafrika",
    "ZM" to "Sambii",
    "ZW" to "Simbabʊwee",
    "ZZ" to "gʊsaʊɩ kʊyɔʊ ʊ mana ma",
  ) }

  val bm: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andɔr",
    "AE" to "Arabu mara kafoli",
    "AF" to "Afiganistaŋ",
    "AG" to "Antiga-ni-Barbuda",
    "AI" to "Angiya",
    "AL" to "Alibani",
    "AM" to "Arimeni",
    "AO" to "Angola",
    "AR" to "Arizantin",
    "AS" to "Samowa amerikani",
    "AT" to "Otirisi",
    "AU" to "Ositirali",
    "AW" to "Aruba",
    "AZ" to "Azɛrbayjaŋ",
    "BA" to "Bozni-Ɛrizigovini",
    "BB" to "Barbadi",
    "BD" to "Bɛngiladɛsi",
    "BE" to "Bɛliziki",
    "BF" to "Burukina Faso",
    "BG" to "Buligari",
    "BH" to "Bareyini",
    "BI" to "Burundi",
    "BJ" to "Benɛn",
    "BM" to "Bermudi",
    "BN" to "Burinɛyi",
    "BO" to "Bolivi",
    "BR" to "Berezili",
    "BS" to "Bahamasi",
    "BT" to "Butaŋ",
    "BW" to "Bɔtisiwana",
    "BY" to "Belarusi",
    "BZ" to "Belizi",
    "CA" to "Kanada",
    "CD" to "Kongo ka republiki demɔkratiki",
    "CF" to "Santarafiriki",
    "CG" to "Kongo",
    "CH" to "Suwisi",
    "CI" to "Kodiwari",
    "CK" to "Kuki Gun",
    "CL" to "Sili",
    "CM" to "Kameruni",
    "CN" to "Siniwajamana",
    "CO" to "Kolombi",
    "CR" to "Kɔsitarika",
    "CU" to "Kuba",
    "CV" to "Capivɛrdi",
    "CY" to "Cipri",
    "CZ" to "Ceki republiki",
    "DE" to "Alimaɲi",
    "DJ" to "Jibuti",
    "DK" to "Danemarki",
    "DM" to "Dɔminiki",
    "DO" to "Dɔmimiki republiki",
    "DZ" to "Alizeri",
    "EC" to "Ekwatɔr",
    "EE" to "Esetoni",
    "EG" to "Eziputi",
    "ER" to "Eritere",
    "ES" to "Esipaɲi",
    "ET" to "Etiopi",
    "FI" to "Finilandi",
    "FJ" to "Fiji",
    "FK" to "Maluwini Gun",
    "FM" to "Mikironesi",
    "FR" to "Faransi",
    "GA" to "Gabɔŋ",
    "GB" to "Angilɛtɛri",
    "GD" to "Granadi",
    "GE" to "Zeyɔrzi",
    "GF" to "Faransi ka gwiyani",
    "GH" to "Gana",
    "GI" to "Zibralitari",
    "GL" to "Gɔrɔhenelandi",
    "GM" to "Ganbi",
    "GN" to "Gine",
    "GP" to "Gwadelup",
    "GQ" to "Gine ekwatɔri",
    "GR" to "Gɛrɛsi",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Gine Bisawo",
    "GY" to "Gwiyana",
    "HN" to "Hɔndirasi",
    "HR" to "Kroasi",
    "HT" to "Ayiti",
    "HU" to "Hɔngri",
    "ID" to "Ɛndonezi",
    "IE" to "Irilandi",
    "IL" to "Isirayeli",
    "IN" to "Ɛndujamana",
    "IQ" to "Iraki",
    "IR" to "Iraŋ",
    "IS" to "Isilandi",
    "IT" to "Itali",
    "JM" to "Zamayiki",
    "JO" to "Zɔrdani",
    "JP" to "Zapɔn",
    "KE" to "Keniya",
    "KG" to "Kirigizisitaŋ",
    "KH" to "Kamboji",
    "KI" to "Kiribati",
    "KM" to "Komɔri",
    "KN" to "Kristɔfo-Senu-ni-Ɲevɛs",
    "KP" to "Kɛɲɛka Kore",
    "KR" to "Worodugu Kore",
    "KW" to "Kowɛti",
    "KY" to "Bama Gun",
    "KZ" to "Kazakistaŋ",
    "LA" to "Layosi",
    "LB" to "Libaŋ",
    "LC" to "Lusi-Senu",
    "LI" to "Lisɛnsitayini",
    "LK" to "Sirilanka",
    "LR" to "Liberiya",
    "LS" to "Lesoto",
    "LT" to "Lituyani",
    "LU" to "Likisanburu",
    "LV" to "Letoni",
    "LY" to "Libi",
    "MA" to "Marɔku",
    "MC" to "Monako",
    "MD" to "Molidavi",
    "MG" to "Madagasikari",
    "MH" to "Marisali Gun",
    "ML" to "Mali",
    "MM" to "Myanimari",
    "MN" to "Moŋoli",
    "MP" to "Kɛɲɛka Mariyani Gun",
    "MQ" to "Maritiniki",
    "MR" to "Mɔritani",
    "MS" to "Moŋsera",
    "MT" to "Malti",
    "MU" to "Morisi",
    "MV" to "Maldivi",
    "MW" to "Malawi",
    "MX" to "Meksiki",
    "MY" to "Malɛzi",
    "MZ" to "Mozanbiki",
    "NA" to "Namibi",
    "NC" to "Kaledoni Koura",
    "NE" to "Nizɛri",
    "NF" to "Nɔrofoliki Gun",
    "NG" to "Nizeriya",
    "NI" to "Nikaragwa",
    "NL" to "Peyiba",
    "NO" to "Nɔriwɛzi",
    "NP" to "Nepali",
    "NR" to "Nawuru",
    "NU" to "Nyuwe",
    "NZ" to "Zelandi Koura",
    "OM" to "Omaŋ",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Faransi ka polinezi",
    "PG" to "Papuwasi-Gine-Koura",
    "PH" to "Filipini",
    "PK" to "Pakisitaŋ",
    "PL" to "Poloɲi",
    "PM" to "Piyɛri-Senu-ni-Mikelɔŋ",
    "PN" to "Pitikarini",
    "PR" to "Pɔrotoriko",
    "PS" to "Palesitini",
    "PT" to "Pɔritigali",
    "PW" to "Palawu",
    "PY" to "Paraguwayi",
    "QA" to "Katari",
    "RE" to "Reyuɲɔŋ",
    "RO" to "Rumani",
    "RU" to "Irisi",
    "RW" to "Ruwanda",
    "SA" to "Arabiya Sawudiya",
    "SB" to "Salomo Gun",
    "SC" to "Sesɛli",
    "SD" to "Sudaŋ",
    "SE" to "Suwɛdi",
    "SG" to "Sɛngapuri",
    "SH" to "Ɛlɛni Senu",
    "SI" to "Sloveni",
    "SK" to "Slowaki",
    "SL" to "Siyera Lewɔni",
    "SM" to "Marini-Senu",
    "SN" to "Senegali",
    "SO" to "Somali",
    "SR" to "Surinami",
    "ST" to "Sawo Tome-ni-Prinicipe",
    "SV" to "Salivadɔr",
    "SY" to "Siri",
    "SZ" to "Swazilandi",
    "TC" to "Turiki Gun ni Kayiki",
    "TD" to "Cadi",
    "TG" to "Togo",
    "TH" to "Tayilandi",
    "TJ" to "Tajikisitani",
    "TK" to "Tokelo",
    "TL" to "Kɔrɔn Timɔr",
    "TM" to "Turikimenisitani",
    "TN" to "Tunizi",
    "TO" to "Tonga",
    "TR" to "Turiki",
    "TT" to "Trinite-ni-Tobago",
    "TV" to "Tuvalu",
    "TW" to "Tayiwani",
    "TZ" to "Tanzani",
    "UA" to "Ukɛrɛni",
    "UG" to "Uganda",
    "US" to "Ameriki",
    "UY" to "Urugwayi",
    "UZ" to "Uzebekisitani",
    "VA" to "Vatikaŋ",
    "VC" to "Vinisɛn-Senu-ni-Grenadini",
    "VE" to "Venezuwela",
    "VG" to "Angilɛ ka Sungurunnin Gun",
    "VI" to "Ameriki ka Sungurunnin Gun",
    "VN" to "Wiyɛtinamu",
    "VU" to "Vanuwatu",
    "WF" to "Walisi-ni-Futuna",
    "WS" to "Samowa",
    "YE" to "Yemɛni",
    "YT" to "Mayoti",
    "ZA" to "Worodugu Afriki",
    "ZM" to "Zanbi",
    "ZW" to "Zimbabuwe",
  ) }

  val bn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "পৃথিবী",
    "002" to "আফ্রিকা",
    "003" to "উত্তর আমেরিকা",
    "005" to "দক্ষিণ আমেরিকা",
    "009" to "ওশিয়ানিয়া",
    "011" to "পশ্চিম আফ্রিকা",
    "013" to "মধ্য আমেরিকা",
    "014" to "পূর্ব আফ্রিকা",
    "015" to "উত্তর আফ্রিকা",
    "017" to "মধ্য আফ্রিকা",
    "018" to "দক্ষিন আফ্রিকা",
    "019" to "আমেরিকা",
    "021" to "উত্তরাঞ্চলীয় আমেরিকা",
    "029" to "ক্যারিবিয়ান",
    "030" to "পূর্ব এশিয়া",
    "034" to "দক্ষিণ এশিয়া",
    "035" to "দক্ষিণ পূর্ব এশিয়া",
    "039" to "দক্ষিণ ইউরোপ",
    "053" to "অস্ট্রেলেশিয়া",
    "054" to "মেলানেশিয়া",
    "057" to "মাইক্রোনেশিয়া অঞ্চল",
    "061" to "পলিনেশিয়া",
    "142" to "এশিয়া",
    "143" to "মধ্য এশিয়া",
    "145" to "পশ্চিম এশিয়া",
    "150" to "ইউরোপ",
    "151" to "পূর্ব ইউরোপ",
    "154" to "উত্তর ইউরোপ",
    "155" to "পশ্চিম ইউরোপ",
    "202" to "উপ সাহারান আফ্রিকা",
    "419" to "লাতিন আমেরিকা",
    "AC" to "অ্যাসেনশন দ্বীপপুঞ্জ",
    "AD" to "আন্ডোরা",
    "AE" to "সংযুক্ত আরব আমিরাত",
    "AF" to "আফগানিস্তান",
    "AG" to "অ্যান্টিগুয়া ও বারবুডা",
    "AI" to "অ্যাঙ্গুইলা",
    "AL" to "আলবেনিয়া",
    "AM" to "আর্মেনিয়া",
    "AO" to "অ্যাঙ্গোলা",
    "AQ" to "অ্যান্টার্কটিকা",
    "AR" to "আর্জেন্টিনা",
    "AS" to "আমেরিকান সামোয়া",
    "AT" to "অস্ট্রিয়া",
    "AU" to "অস্ট্রেলিয়া",
    "AW" to "আরুবা",
    "AX" to "অলান্ড দ্বীপপুঞ্জ",
    "AZ" to "আজারবাইজান",
    "BA" to "বসনিয়া ও হার্জেগোভিনা",
    "BB" to "বার্বাডোজ",
    "BD" to "বাংলাদেশ",
    "BE" to "বেলজিয়াম",
    "BF" to "বুরকিনা ফাসো",
    "BG" to "বুলগেরিয়া",
    "BH" to "বাহারিন",
    "BI" to "বুরুন্ডি",
    "BJ" to "বেনিন",
    "BL" to "সেন্ট বার্থেলেমি",
    "BM" to "বারমুডা",
    "BN" to "ব্রুনেই",
    "BO" to "বলিভিয়া",
    "BQ" to "ক্যারিবিয়ান নেদারল্যান্ডস",
    "BR" to "ব্রাজিল",
    "BS" to "বাহামা দ্বীপপুঞ্জ",
    "BT" to "ভুটান",
    "BV" to "বোভেট দ্বীপ",
    "BW" to "বতসোয়ানা",
    "BY" to "বেলারুশ",
    "BZ" to "বেলিজ",
    "CA" to "কানাডা",
    "CC" to "কোকোস (কিলিং) দ্বীপপুঞ্জ",
    "CD" to "কঙ্গো-কিনশাসা",
    "CF" to "মধ্য আফ্রিকার প্রজাতন্ত্র",
    "CG" to "কঙ্গো - ব্রাজাভিল",
    "CH" to "সুইজারল্যান্ড",
    "CI" to "কোট ডি‘আইভোর",
    "CK" to "কুক দ্বীপপুঞ্জ",
    "CL" to "চিলি",
    "CM" to "ক্যামেরুন",
    "CN" to "চীন",
    "CO" to "কলম্বিয়া",
    "CP" to "ক্লিপারটন দ্বীপপুঞ্জ",
    "CR" to "কোস্টারিকা",
    "CU" to "কিউবা",
    "CV" to "কেপ ভার্দে",
    "CW" to "কুরাসাও",
    "CX" to "ক্রিসমাস দ্বীপ",
    "CY" to "সাইপ্রাস",
    "CZ" to "চেকিয়া",
    "DE" to "জার্মানি",
    "DG" to "দিয়েগো গার্সিয়া",
    "DJ" to "জিবুতি",
    "DK" to "ডেনমার্ক",
    "DM" to "ডোমিনিকা",
    "DO" to "ডোমেনিকান প্রজাতন্ত্র",
    "DZ" to "আলজেরিয়া",
    "EA" to "কুউটা এবং মেলিলা",
    "EC" to "ইকুয়েডর",
    "EE" to "এস্তোনিয়া",
    "EG" to "মিশর",
    "EH" to "পশ্চিম সাহারা",
    "ER" to "ইরিত্রিয়া",
    "ES" to "স্পেন",
    "ET" to "ইথিওপিয়া",
    "EU" to "ইউরোপীয় ইউনিয়ন",
    "EZ" to "ইউরোজোন",
    "FI" to "ফিনল্যান্ড",
    "FJ" to "ফিজি",
    "FK" to "ফকল্যান্ড দ্বীপপুঞ্জ",
    "FM" to "মাইক্রোনেশিয়া",
    "FO" to "ফ্যারো দ্বীপপুঞ্জ",
    "FR" to "ফ্রান্স",
    "GA" to "গ্যাবন",
    "GB" to "যুক্তরাজ্য",
    "GD" to "গ্রেনাডা",
    "GE" to "জর্জিয়া",
    "GF" to "ফরাসী গায়ানা",
    "GG" to "গার্নসি",
    "GH" to "ঘানা",
    "GI" to "জিব্রাল্টার",
    "GL" to "গ্রীনল্যান্ড",
    "GM" to "গাম্বিয়া",
    "GN" to "গিনি",
    "GP" to "গুয়াদেলৌপ",
    "GQ" to "নিরক্ষীয় গিনি",
    "GR" to "গ্রীস",
    "GS" to "দক্ষিণ জর্জিয়া ও দক্ষিণ স্যান্ডউইচ দ্বীপপুঞ্জ",
    "GT" to "গুয়াতেমালা",
    "GU" to "গুয়াম",
    "GW" to "গিনি-বিসাউ",
    "GY" to "গিয়ানা",
    "HK" to "হংকং এসএআর চীনা",
    "HM" to "হার্ড এবং ম্যাকডোনাল্ড দ্বীপপুঞ্জ",
    "HN" to "হন্ডুরাস",
    "HR" to "ক্রোয়েশিয়া",
    "HT" to "হাইতি",
    "HU" to "হাঙ্গেরি",
    "IC" to "ক্যানারি দ্বীপপুঞ্জ",
    "ID" to "ইন্দোনেশিয়া",
    "IE" to "আয়ারল্যান্ড",
    "IL" to "ইজরায়েল",
    "IM" to "আইল অফ ম্যান",
    "IN" to "ভারত",
    "IO" to "ব্রিটিশ ভারত মহাসাগরীয় অঞ্চল",
    "IQ" to "ইরাক",
    "IR" to "ইরান",
    "IS" to "আইসল্যান্ড",
    "IT" to "ইতালি",
    "JE" to "জার্সি",
    "JM" to "জামাইকা",
    "JO" to "জর্ডন",
    "JP" to "জাপান",
    "KE" to "কেনিয়া",
    "KG" to "কিরগিজিস্তান",
    "KH" to "কম্বোডিয়া",
    "KI" to "কিরিবাতি",
    "KM" to "কমোরোস",
    "KN" to "সেন্ট কিটস ও নেভিস",
    "KP" to "উত্তর কোরিয়া",
    "KR" to "দক্ষিণ কোরিয়া",
    "KW" to "কুয়েত",
    "KY" to "কেম্যান দ্বীপপুঞ্জ",
    "KZ" to "কাজাখস্তান",
    "LA" to "লাওস",
    "LB" to "লেবানন",
    "LC" to "সেন্ট লুসিয়া",
    "LI" to "লিচেনস্টেইন",
    "LK" to "শ্রীলঙ্কা",
    "LR" to "লাইবেরিয়া",
    "LS" to "লেসোথো",
    "LT" to "লিথুয়ানিয়া",
    "LU" to "লাক্সেমবার্গ",
    "LV" to "লাটভিয়া",
    "LY" to "লিবিয়া",
    "MA" to "মোরক্কো",
    "MC" to "মোনাকো",
    "MD" to "মলডোভা",
    "ME" to "মন্টিনিগ্রো",
    "MF" to "সেন্ট মার্টিন",
    "MG" to "মাদাগাস্কার",
    "MH" to "মার্শাল দ্বীপপুঞ্জ",
    "MK" to "উত্তর ম্যাসেডোনিয়া",
    "ML" to "মালি",
    "MM" to "মায়ানমার (বার্মা)",
    "MN" to "মঙ্গোলিয়া",
    "MO" to "ম্যাকাও এসএআর চীন",
    "MP" to "উত্তরাঞ্চলীয় মারিয়ানা দ্বীপপুঞ্জ",
    "MQ" to "মার্টিনিক",
    "MR" to "মরিতানিয়া",
    "MS" to "মন্টসেরাট",
    "MT" to "মাল্টা",
    "MU" to "মরিশাস",
    "MV" to "মালদ্বীপ",
    "MW" to "মালাউই",
    "MX" to "মেক্সিকো",
    "MY" to "মালয়েশিয়া",
    "MZ" to "মোজাম্বিক",
    "NA" to "নামিবিয়া",
    "NC" to "নিউ ক্যালেডোনিয়া",
    "NE" to "নাইজার",
    "NF" to "নরফোক দ্বীপ",
    "NG" to "নাইজেরিয়া",
    "NI" to "নিকারাগুয়া",
    "NL" to "নেদারল্যান্ডস",
    "NO" to "নরওয়ে",
    "NP" to "নেপাল",
    "NR" to "নাউরু",
    "NU" to "নিউয়ে",
    "NZ" to "নিউজিল্যান্ড",
    "OM" to "ওমান",
    "PA" to "পানামা",
    "PE" to "পেরু",
    "PF" to "ফরাসী পলিনেশিয়া",
    "PG" to "পাপুয়া নিউ গিনি",
    "PH" to "ফিলিপাইন",
    "PK" to "পাকিস্তান",
    "PL" to "পোল্যান্ড",
    "PM" to "সেন্ট পিয়ের ও মিকুয়েলন",
    "PN" to "পিটকেয়ার্ন দ্বীপপুঞ্জ",
    "PR" to "পুয়ের্তো রিকো",
    "PS" to "প্যালেস্টাইন ভূখণ্ড",
    "PT" to "পর্তুগাল",
    "PW" to "পালাউ",
    "PY" to "প্যারাগুয়ে",
    "QA" to "কাতার",
    "QO" to "আউটলাইনিং ওসানিয়া",
    "RE" to "রিইউনিয়ন",
    "RO" to "রোমানিয়া",
    "RS" to "সার্বিয়া",
    "RU" to "রাশিয়া",
    "RW" to "রুয়ান্ডা",
    "SA" to "সৌদি আরব",
    "SB" to "সলোমন দ্বীপপুঞ্জ",
    "SC" to "সিসিলি",
    "SD" to "সুদান",
    "SE" to "সুইডেন",
    "SG" to "সিঙ্গাপুর",
    "SH" to "সেন্ট হেলেনা",
    "SI" to "স্লোভানিয়া",
    "SJ" to "স্বালবার্ড ও জান মেয়েন",
    "SK" to "স্লোভাকিয়া",
    "SL" to "সিয়েরা লিওন",
    "SM" to "সান মারিনো",
    "SN" to "সেনেগাল",
    "SO" to "সোমালিয়া",
    "SR" to "সুরিনাম",
    "SS" to "দক্ষিণ সুদান",
    "ST" to "সাওটোমা ও প্রিন্সিপি",
    "SV" to "এল সালভেদর",
    "SX" to "সিন্ট মার্টেন",
    "SY" to "সিরিয়া",
    "SZ" to "ইসওয়াতিনি",
    "TA" to "ট্রিস্টান ডা কুনহা",
    "TC" to "তুর্কস ও কাইকোস দ্বীপপুঞ্জ",
    "TD" to "চাদ",
    "TF" to "ফরাসী দক্ষিণাঞ্চল",
    "TG" to "টোগো",
    "TH" to "থাইল্যান্ড",
    "TJ" to "তাজিকিস্তান",
    "TK" to "টোকেলাউ",
    "TL" to "তিমুর-লেস্তে",
    "TM" to "তুর্কমেনিস্তান",
    "TN" to "তিউনিসিয়া",
    "TO" to "টোঙ্গা",
    "TR" to "তুরস্ক",
    "TT" to "ত্রিনিনাদ ও টোব্যাগো",
    "TV" to "টুভালু",
    "TW" to "তাইওয়ান",
    "TZ" to "তাঞ্জানিয়া",
    "UA" to "ইউক্রেন",
    "UG" to "উগান্ডা",
    "UM" to "যুক্তরাষ্ট্রের পার্শ্ববর্তী দ্বীপপুঞ্জ",
    "UN" to "জাতিসংঘ",
    "US" to "মার্কিন যুক্তরাষ্ট্র",
    "UY" to "উরুগুয়ে",
    "UZ" to "উজবেকিস্তান",
    "VA" to "ভ্যাটিকান সিটি",
    "VC" to "সেন্ট ভিনসেন্ট ও গ্রেনাডিনস",
    "VE" to "ভেনেজুয়েলা",
    "VG" to "ব্রিটিশ ভার্জিন দ্বীপপুঞ্জ",
    "VI" to "মার্কিন যুক্তরাষ্ট্রীয় ভার্জিন দ্বীপপুঞ্জ",
    "VN" to "ভিয়েতনাম",
    "VU" to "ভানুয়াটু",
    "WF" to "ওয়ালিস ও ফুটুনা",
    "WS" to "সামোয়া",
    "XA" to "সিউডো-অ্যাকসেন্ট",
    "XB" to "সিউডো-বিডি",
    "XK" to "কসোভো",
    "YE" to "ইয়েমেন",
    "YT" to "মায়োত্তে",
    "ZA" to "দক্ষিণ আফ্রিকা",
    "ZM" to "জাম্বিয়া",
    "ZW" to "জিম্বাবোয়ে",
    "ZZ" to "অজানা অঞ্চল",
  ) }

  val bn_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "018" to "দক্ষিণাঞ্চলীয় আফ্রিকা",
    "202" to "সাহারা-নিম্ন আফ্রিকা",
    "QO" to "ওশিয়ানিয়ার দূরবর্তী অঞ্চল",
    "UM" to "মার্কিন যুক্তরাষ্ট্রের দূরবর্তী দ্বীপপুঞ্জ",
  ) }

  val bo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "འཛམ་གླིང་།",
    "CN" to "རྒྱ་ནག",
    "DE" to "འཇར་མན་",
    "GB" to "དབྱིན་ཇི་",
    "IN" to "རྒྱ་གར་",
    "IT" to "ཨི་ཀྲར་ལི་",
    "JP" to "ཉི་ཧོང་",
    "KR" to "ལྷོ་ཀོ་རི་ཡ།",
    "NP" to "བལ་ཡུལ་",
    "RU" to "ཨུ་རུ་སུ་",
    "US" to "ཨ་མེ་རི་ཀ།",
    "ZZ" to "མིའི་ཤེས་རྟོགས་མ་བྱུང་བའི་ཁོར་ཡུག",
  ) }

  val bo_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "009" to "ཨོཤི་ཡཱན་ན།",
  ) }

  val br: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Bed",
    "002" to "Afrika",
    "003" to "Norzhamerika",
    "005" to "Suamerika",
    "009" to "Oseania",
    "011" to "Afrika ar Cʼhornôg",
    "013" to "Kreizamerika",
    "014" to "Afrika ar Reter",
    "015" to "Afrika an Norzh",
    "017" to "Afrika ar Cʼhreiz",
    "018" to "Afrika ar Su",
    "019" to "Amerikaoù",
    "021" to "Amerika an Norzh",
    "029" to "Karib",
    "030" to "Azia ar Reter",
    "034" to "Azia ar Su",
    "035" to "Azia ar Gevred",
    "039" to "Europa ar Su",
    "053" to "Aostralazia",
    "054" to "Melanezia",
    "057" to "Rannved Mikronezia",
    "061" to "Polinezia",
    "142" to "Azia",
    "143" to "Azia ar Cʼhreiz",
    "145" to "Azia ar Cʼhornôg",
    "150" to "Europa",
    "151" to "Europa ar Reter",
    "154" to "Europa an Norzh",
    "155" to "Europa ar Cʼhornôg",
    "202" to "Afrika issaharat",
    "419" to "Amerika Latin",
    "AC" to "Enez Ascension",
    "AD" to "Andorra",
    "AE" to "Emirelezhioù Arab Unanet",
    "AF" to "Afghanistan",
    "AG" to "Antigua ha Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarktika",
    "AR" to "Arcʼhantina",
    "AS" to "Samoa Amerikan",
    "AT" to "Aostria",
    "AU" to "Aostralia",
    "AW" to "Aruba",
    "AX" to "Inizi Åland",
    "AZ" to "Azerbaidjan",
    "BA" to "Bosnia ha Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgia",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrein",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Karib Nederlandat",
    "BR" to "Brazil",
    "BS" to "Bahamas",
    "BT" to "Bhoutan",
    "BV" to "Enez Bouvet",
    "BW" to "Botswana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Inizi Kokoz",
    "CD" to "Kongo - Kinshasa",
    "CF" to "Republik Kreizafrikan",
    "CG" to "Kongo - Brazzaville",
    "CH" to "Suis",
    "CI" to "Aod an Olifant",
    "CK" to "Inizi Cook",
    "CL" to "Chile",
    "CM" to "Kameroun",
    "CN" to "Sina",
    "CO" to "Kolombia",
    "CP" to "Enez Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Kuba",
    "CV" to "Kab-Glas",
    "CW" to "Curaçao",
    "CX" to "Enez Christmas",
    "CY" to "Kiprenez",
    "CZ" to "Tchekia",
    "DE" to "Alamagn",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Danmark",
    "DM" to "Dominica",
    "DO" to "Republik Dominikan",
    "DZ" to "Aljeria",
    "EA" to "Ceuta ha Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egipt",
    "EH" to "Sahara ar Cʼhornôg",
    "ER" to "Eritrea",
    "ES" to "Spagn",
    "ET" to "Etiopia",
    "EU" to "Unaniezh Europa",
    "EZ" to "takad an euro",
    "FI" to "Finland",
    "FJ" to "Fidji",
    "FK" to "Inizi Falkland",
    "FM" to "Mikronezia",
    "FO" to "Inizi Faero",
    "FR" to "Frañs",
    "GA" to "Gabon",
    "GB" to "Rouantelezh-Unanet",
    "GD" to "Grenada",
    "GE" to "Jorjia",
    "GF" to "Gwiana cʼhall",
    "GG" to "Gwernenez",
    "GH" to "Ghana",
    "GI" to "Jibraltar",
    "GL" to "Greunland",
    "GM" to "Gambia",
    "GN" to "Ginea",
    "GP" to "Gwadeloup",
    "GQ" to "Ginea ar Cʼheheder",
    "GR" to "Gres",
    "GS" to "Inizi Georgia ar Su hag Inizi Sandwich ar Su",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Ginea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong RMD Sina",
    "HM" to "Inizi Heard ha McDonald",
    "HN" to "Honduras",
    "HR" to "Kroatia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "IC" to "Inizi Kanariez",
    "ID" to "Indonezia",
    "IE" to "Iwerzhon",
    "IL" to "Israel",
    "IM" to "Enez Vanav",
    "IN" to "India",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Island",
    "IT" to "Italia",
    "JE" to "Jerzenez",
    "JM" to "Jamaika",
    "JO" to "Jordania",
    "JP" to "Japan",
    "KE" to "Kenya",
    "KG" to "Kyrgyzstan",
    "KH" to "Kambodja",
    "KI" to "Kiribati",
    "KM" to "Komorez",
    "KN" to "Saint Kitts ha Nevis",
    "KP" to "Korea an Norzh",
    "KR" to "Korea ar Su",
    "KW" to "Koweit",
    "KY" to "Inizi Cayman",
    "KZ" to "Kazakstan",
    "LA" to "Laos",
    "LB" to "Liban",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lituania",
    "LU" to "Luksembourg",
    "LV" to "Latvia",
    "LY" to "Libia",
    "MA" to "Maroko",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "Saint Martin",
    "MG" to "Madagaskar",
    "MH" to "Inizi Marshall",
    "MK" to "Makedonia an Norzh",
    "ML" to "Mali",
    "MM" to "Myanmar (Birmania)",
    "MN" to "Mongolia",
    "MO" to "Macau RMD Sina",
    "MP" to "Inizi Mariana an Norzh",
    "MQ" to "Martinik",
    "MR" to "Maouritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Moris",
    "MV" to "Maldivez",
    "MW" to "Malawi",
    "MX" to "Mecʼhiko",
    "MY" to "Malaysia",
    "MZ" to "Mozambik",
    "NA" to "Namibia",
    "NC" to "Kaledonia Nevez",
    "NE" to "Niger",
    "NF" to "Enez Norfolk",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Izelvroioù",
    "NO" to "Norvegia",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Zeland-Nevez",
    "OM" to "Oman",
    "PA" to "Panamá",
    "PE" to "Perou",
    "PF" to "Polinezia Cʼhall",
    "PG" to "Papoua Ginea-Nevez",
    "PH" to "Filipinez",
    "PK" to "Pakistan",
    "PL" to "Polonia",
    "PM" to "Sant-Pêr-ha-Mikelon",
    "PN" to "Enez Pitcairn",
    "PR" to "Puerto Rico",
    "PS" to "Tiriadoù Palestina",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Oseania diabell",
    "RE" to "Ar Reünion",
    "RO" to "Roumania",
    "RS" to "Serbia",
    "RU" to "Rusia",
    "RW" to "Rwanda",
    "SA" to "Arabia Saoudat",
    "SB" to "Inizi Salomon",
    "SC" to "Sechelez",
    "SD" to "Soudan",
    "SE" to "Sveden",
    "SG" to "Singapour",
    "SH" to "Saint-Helena",
    "SI" to "Slovenia",
    "SJ" to "Svalbard",
    "SK" to "Slovakia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Surinam",
    "SS" to "Susoudan",
    "ST" to "São Tomé ha Príncipe",
    "SV" to "Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Siria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Inizi Turks ha Caicos",
    "TD" to "Tchad",
    "TF" to "Douaroù aostral Frañs",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tadjikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunizia",
    "TO" to "Tonga",
    "TR" to "Turkia",
    "TT" to "Trinidad ha Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraina",
    "UG" to "Ouganda",
    "UM" to "Inizi diabell ar Stadoù-Unanet",
    "UN" to "Broadoù unanet",
    "US" to "Stadoù-Unanet",
    "UY" to "Uruguay",
    "UZ" to "Ouzbekistan",
    "VA" to "Vatikan",
    "VC" to "Sant Visant hag ar Grenadinez",
    "VE" to "Venezuela",
    "VG" to "Inizi Gwercʼh Breizh-Veur",
    "VI" to "Inizi Gwercʼh ar Stadoù-Unanet",
    "VN" to "Viêt Nam",
    "VU" to "Vanuatu",
    "WF" to "Wallis ha Futuna",
    "WS" to "Samoa",
    "XA" to "pouez-mouezh gaou",
    "XB" to "BiDi gaou",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "Suafrika",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Rannved dianav",
  ) }

  val brx: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "बुहुम",
    "002" to "आफ्रिका",
    "003" to "साहा आमेरिका",
    "005" to "खोला आमेरिका",
    "009" to "ओशेआनिया",
    "011" to "सोनाबारि आफ्रिका",
    "013" to "मिरु आमेरिका",
    "014" to "सानजायारि आफ्रिका",
    "015" to "साहायारि आफ्रिका",
    "017" to "गेजेरारि आफ्रिका",
    "018" to "खोलायारि आफ्रिका",
    "019" to "आमेरिकानि",
    "021" to "साहायारि आमेरिका",
    "029" to "केरिबियान",
    "030" to "सानजायारि एसिया",
    "034" to "खोलायारि एसिया",
    "035" to "खोला-सानजा एसिया",
    "039" to "खोलायारि यूरोप",
    "053" to "अस्ट्रेलएसिया",
    "054" to "मेलानेसिया",
    "057" to "माईक्र’नेसियायारि ओनसोल",
    "061" to "पलिनेसिया",
    "142" to "एसिया",
    "143" to "मिरु एसिया",
    "145" to "सोनाबारि एसिया",
    "150" to "यूरोप",
    "151" to "सानजायारि यूरोप",
    "154" to "साहायारि यूरोप",
    "155" to "सोनाबारि यूरोप",
    "202" to "साहारायारि लोब्बा गोनां आफ्रिका",
    "419" to "लेटीन आमेरिका",
    "AC" to "एसेनसिअन द्वीप",
    "AD" to "एन्डर्रा",
    "AE" to "जथाय आराब एमिरेत",
    "AF" to "आफगानिस्तान",
    "AG" to "एन्टिगुआ आरो बारबुडा",
    "AI" to "एंगुइल्ला",
    "AL" to "आल्बानिया",
    "AM" to "आर्मेनिया",
    "AO" to "आंगला",
    "AQ" to "एन्टार्कटिका",
    "AR" to "आर्जेन्टिना",
    "AS" to "आमेरिकान सामआ",
    "AT" to "अस्ट्रिया",
    "AU" to "अस्ट्रेलिया",
    "AW" to "आरूबा",
    "AX" to "आलाण्ड द्वीपफोर",
    "AZ" to "आजेरबाईजान",
    "BA" to "बसनिया आरो होर्जेगभिना",
    "BB" to "बारबाड’स",
    "BD" to "बांलादेश",
    "BE" to "बेलजियाम",
    "BF" to "बुर्किना फास’",
    "BG" to "बुल्गारिया",
    "BH" to "बाहरैन",
    "BI" to "बुरूण्डी",
    "BJ" to "बेनिन",
    "BL" to "सैन्ट बार्थेलेमी",
    "BM" to "बारमूडा",
    "BN" to "ब्रूने",
    "BO" to "बलिभिया",
    "BQ" to "केरिबियान नेदारलेण्डस",
    "BR" to "ब्राजील",
    "BS" to "बाहामास",
    "BT" to "भूटान",
    "BV" to "बूभेट द्वीप",
    "BW" to "बत्स्वाना",
    "BY" to "बेलारूस",
    "BZ" to "बेलिज",
    "CA" to "केनाडा",
    "CC" to "कक’स द्वीपफोर",
    "CD" to "कंग’-किनशासा",
    "CF" to "मिरु आफ्रिका सुबुंखुंथाय",
    "CG" to "कंग’- ब्राज्जाभील",
    "CH" to "सुईजारलेण्ड",
    "CI" to "कट दिभवेर",
    "CK" to "कुक द्वीप",
    "CL" to "चिले",
    "CM" to "केमेरून",
    "CN" to "चाइना",
    "CO" to "कलम्बिया",
    "CP" to "क्लिप्पार्टन द्वीप",
    "CR" to "कस्टा रिका",
    "CU" to "क्यूबा",
    "CV" to "केप भेर्दे",
    "CW" to "कुरासाव",
    "CX" to "ख्रिसमास द्वीपफोर",
    "CY" to "साइप्रास",
    "CZ" to "चेखिया",
    "DE" to "जार्मानी",
    "DG" to "दियेग’ गार्सिया",
    "DJ" to "जिबौति",
    "DK" to "डेनमार्क",
    "DM" to "दमिनिका",
    "DO" to "दमिनिकान सुबुंखुंथाय",
    "DZ" to "आल्जेरिया",
    "EA" to "किउता आरो मेलिल्ला",
    "EC" to "एक्वाड’र",
    "EE" to "एस्ट’निया",
    "EG" to "ईजिप्त",
    "EH" to "सोनाबारि साहारा",
    "ER" to "एरिट्रिया",
    "ES" to "स्पैन",
    "ET" to "इथिय’पिया",
    "EU" to "यूरोपनि जथाय",
    "EZ" to "यूरो ओनसोल",
    "FI" to "फिनलेण्ड",
    "FJ" to "फिजी",
    "FK" to "फकलेण्ड द्वीपफोर",
    "FM" to "माइक्रनेशिया",
    "FO" to "फेर’ द्वीपफोर",
    "FR" to "फ्रान्स",
    "GA" to "गाबन",
    "GB" to "जथाय ब्रिटिश हादोर",
    "GD" to "ग्रेनादा",
    "GE" to "जर्जिया",
    "GF" to "फ्रेन्च गिआना",
    "GG" to "गोर्नसि",
    "GH" to "घाना",
    "GI" to "जिब्राल्टार",
    "GL" to "ग्रीनलेण्ड",
    "GM" to "गाम्बिया",
    "GN" to "गिनीया",
    "GP" to "ग्वादेल्यूप",
    "GQ" to "बिसुबारि गिनीया",
    "GR" to "ग्रीस",
    "GS" to "खोला जर्जिया आरो खोला सेण्डवीच द्वीपफोर",
    "GT" to "गुवाटेमाला",
    "GU" to "गुआम",
    "GW" to "गिनीया- बिसाऊ",
    "GY" to "गुयाना",
    "HK" to "हंकं एस.ए.आर चाइना",
    "HM" to "होर्द आरो मेकद’नाल्ड द्वीपफोर",
    "HN" to "हण्डूरास",
    "HR" to "क्रवेशिया",
    "HT" to "हाइती",
    "HU" to "हांगारी",
    "IC" to "कानारि द्वीपफोर",
    "ID" to "इण्ड’नेशिया",
    "IE" to "आयारलेण्ड",
    "IL" to "इज्राईल",
    "IM" to "आयोल अफ मेन",
    "IN" to "भारत",
    "IO" to "ब्रिटिशनि भारतारि लैथो बाहागो",
    "IQ" to "ईराक",
    "IR" to "ईरान",
    "IS" to "आइसलेण्ड",
    "IT" to "इटाली",
    "JE" to "जोर्सि",
    "JM" to "जामाइका",
    "JO" to "जर्डान",
    "JP" to "जापान",
    "KE" to "केनिया",
    "KG" to "किर्गीस्तान",
    "KH" to "कम्ब’डिया",
    "KI" to "किरिबाती",
    "KM" to "कम’र’ज",
    "KN" to "सैन्ट कीत्स आरो नेभिस",
    "KP" to "साहा करिया",
    "KR" to "खोला करिया",
    "KW" to "कुवैत",
    "KY" to "कैमेन द्वीपफोर",
    "KZ" to "काजाखस्तान",
    "LA" to "लाओस",
    "LB" to "लेबान’न",
    "LC" to "सैन्ट लुसिया",
    "LI" to "लिक्तोनस्ताईन",
    "LK" to "श्रीलंका",
    "LR" to "लाइबेरिया",
    "LS" to "लेस’थ’",
    "LT" to "लिथुआनिया",
    "LU" to "लाक्जेमबुर्ग",
    "LV" to "लाटभीया",
    "LY" to "लीबिया",
    "MA" to "मरक्क’",
    "MC" to "मनाक’",
    "MD" to "मल्ड’भा",
    "ME" to "मन्टेनेग्र’",
    "MF" to "सैन्ट मार्तिन",
    "MG" to "मादागास्कार",
    "MH" to "मार्शेल द्वीप",
    "MK" to "साहा मेसेड’निया",
    "ML" to "माली",
    "MM" to "म्यानमार",
    "MN" to "मंगलिया",
    "MO" to "माकाउ एस.ए.आर चाइना",
    "MP" to "साहायारि मारियाना द्वीप",
    "MQ" to "मार्तिनिक",
    "MR" to "माउरिटानिया",
    "MS" to "मनत्सेरात",
    "MT" to "माल्टा",
    "MU" to "मरिसियास",
    "MV" to "मालदीव",
    "MW" to "मालावी",
    "MX" to "मेक्सिक’",
    "MY" to "मालेशिया",
    "MZ" to "मजाम्बिक",
    "NA" to "नामीबिया",
    "NC" to "निउ केलेडनिया",
    "NE" to "नाइजेर",
    "NF" to "नर्फ’क द्वीप",
    "NG" to "नाइजेरिया",
    "NI" to "निकारागुआ",
    "NL" to "नेदारलेण्ड",
    "NO" to "नरवै",
    "NP" to "नेपाल",
    "NR" to "नाउरू",
    "NU" to "नीयूए",
    "NZ" to "न्यूजीलेण्ड",
    "OM" to "ओमान",
    "PA" to "पानामा",
    "PE" to "पेरू",
    "PF" to "फ्रेन्च पलिनेशिया",
    "PG" to "पापुआ निउ गिनी",
    "PH" to "फिलीपिन्स",
    "PK" to "पाकिस्तान",
    "PL" to "पलेण्ड",
    "PM" to "सैन्ट. पिएर आरो मिकैलन",
    "PN" to "पिटकाईर्न द्वीप",
    "PR" to "पुवेर्ट’ रीक’",
    "PS" to "पेलेस्ताइननि ओनसोलफोर",
    "PT" to "पर्तुगाल",
    "PW" to "पालाऊ",
    "PY" to "पारागुए",
    "QA" to "कातार",
    "QO" to "बायजोआरि असियानिया",
    "RE" to "रेयूनियन",
    "RO" to "रमानिया",
    "RS" to "सार्बिया",
    "RU" to "रासिया",
    "RW" to "रूआण्डा",
    "SA" to "साउदि आराबिया",
    "SB" to "सल’मन द्वीप",
    "SC" to "सैशेल्लेस",
    "SD" to "सूदान",
    "SE" to "स्वीडेन",
    "SG" to "सिंंगाप’र",
    "SH" to "सैन्ट हेलेना",
    "SI" to "स्ल’भेनिया",
    "SJ" to "स्भालबार्ड आरो जान मायेन",
    "SK" to "स्लभाकिया",
    "SL" to "सियेरा लेओन",
    "SM" to "सान मेरिन’",
    "SN" to "सेनेगाल",
    "SO" to "समालिया",
    "SR" to "सुरिनाम",
    "SS" to "खोला सुदान",
    "ST" to "साऊ तमे आरो प्रिन्सिप",
    "SV" to "एल साल्भाड’र",
    "SX" to "सिन्त मार्तेन",
    "SY" to "सीरिया",
    "SZ" to "एस्वातिनि",
    "TA" to "त्रिस्तान दा कुन्हा",
    "TC" to "तुर्की आरो काईक’ज द्वीपफोर",
    "TD" to "चाड",
    "TF" to "फ्रान्सनि खोलायारि बाहागोफोर",
    "TG" to "टग’",
    "TH" to "थाइलेण्ड",
    "TJ" to "ताजिकिस्तान",
    "TK" to "टकेलाऊ",
    "TL" to "तिमर-लेस्ते",
    "TM" to "तुर्कमेनीस्तान",
    "TN" to "त्युनिशिया",
    "TO" to "टंगा",
    "TR" to "तुर्की",
    "TT" to "त्रिनिडाड आरो तबेग’",
    "TV" to "तुभालु",
    "TW" to "ताइवान",
    "TZ" to "तान्जानिया",
    "UA" to "यूक्रेन",
    "UG" to "उगाण्डा",
    "UM" to "इउ.एस नि बायजोआरि द्वीपफोर",
    "UN" to "जथाय हादोरफोर",
    "US" to "जथाय हादोर आमेरिका",
    "UY" to "ऊरुगुवे",
    "UZ" to "उजबेकिस्तान",
    "VA" to "भेटिकान नोगोर",
    "VC" to "सैन्ट भिन्सेन्ट आरो ग्रेनादीन्स",
    "VE" to "भेनेजुवेला",
    "VG" to "ब्रिटिश भार्जिन द्वीपफोर",
    "VI" to "इउ. एस भार्जिन द्वीपफोर",
    "VN" to "भियेतनाम",
    "VU" to "भानुआटु",
    "WF" to "वालिस आरो फ्युचुना",
    "WS" to "सामआ",
    "XA" to "नंखाइ-गारांबोलो",
    "XB" to "नंखाइ- बिदि",
    "XK" to "कस’भ’",
    "YE" to "येमेन",
    "YT" to "मायत्ते",
    "ZA" to "खोला आफ्रिका",
    "ZM" to "जाम्बिया",
    "ZW" to "जिम्बाब्वे",
    "ZZ" to "मिथियै ओनसोल",
  ) }

  val bs: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Svijet",
    "002" to "Afrika",
    "003" to "Sjeverna Amerika",
    "005" to "Južna Amerika",
    "009" to "Okeanija",
    "011" to "Zapadna Afrika",
    "013" to "Srednja Amerika",
    "014" to "Istočna Afrika",
    "015" to "Sjeverna Afrika",
    "017" to "Srednja Afrika",
    "018" to "Južna Afrika",
    "019" to "Amerika",
    "021" to "Sjeverni dio Amerike",
    "029" to "Karibi",
    "030" to "Istočna Azija",
    "034" to "Južna Azija",
    "035" to "Jugoistočna Azija",
    "039" to "Južna Evropa",
    "053" to "Australazija",
    "054" to "Melanezija",
    "057" to "Mikronezijska regija",
    "061" to "Polinezija",
    "142" to "Azija",
    "143" to "Srednja Azija",
    "145" to "Zapadna Azija",
    "150" to "Evropa",
    "151" to "Istočna Evropa",
    "154" to "Sjeverna Evropa",
    "155" to "Zapadna Evropa",
    "202" to "Subsaharska Afrika",
    "419" to "Latinska Amerika",
    "AC" to "Ostrvo Ascension",
    "AD" to "Andora",
    "AE" to "Ujedinjeni Arapski Emirati",
    "AF" to "Afganistan",
    "AG" to "Antigva i Barbuda",
    "AI" to "Angvila",
    "AL" to "Albanija",
    "AM" to "Armenija",
    "AO" to "Angola",
    "AQ" to "Antarktika",
    "AR" to "Argentina",
    "AS" to "Američka Samoa",
    "AT" to "Austrija",
    "AU" to "Australija",
    "AW" to "Aruba",
    "AX" to "Olandska ostrva",
    "AZ" to "Azerbejdžan",
    "BA" to "Bosna i Hercegovina",
    "BB" to "Barbados",
    "BD" to "Bangladeš",
    "BE" to "Belgija",
    "BF" to "Burkina Faso",
    "BG" to "Bugarska",
    "BH" to "Bahrein",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Sveti Bartolomej",
    "BM" to "Bermuda",
    "BN" to "Brunej",
    "BO" to "Bolivija",
    "BQ" to "Karipska Holandija",
    "BR" to "Brazil",
    "BS" to "Bahami",
    "BT" to "Butan",
    "BV" to "Ostrvo Buve",
    "BW" to "Bocvana",
    "BY" to "Bjelorusija",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kokosova (Keelingova) ostrva",
    "CD" to "Demokratska Republika Kongo",
    "CF" to "Centralnoafrička Republika",
    "CG" to "Kongo",
    "CH" to "Švicarska",
    "CI" to "Obala Slonovače",
    "CK" to "Kukova ostrva",
    "CL" to "Čile",
    "CM" to "Kamerun",
    "CN" to "Kina",
    "CO" to "Kolumbija",
    "CP" to "Ostrvo Clipperton",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Zelenortska Ostrva",
    "CW" to "Kurasao",
    "CX" to "Božićno ostrvo",
    "CY" to "Kipar",
    "CZ" to "Češka",
    "DE" to "Njemačka",
    "DG" to "Dijego Garsija",
    "DJ" to "Džibuti",
    "DK" to "Danska",
    "DM" to "Dominika",
    "DO" to "Dominikanska Republika",
    "DZ" to "Alžir",
    "EA" to "Seuta i Melilja",
    "EC" to "Ekvador",
    "EE" to "Estonija",
    "EG" to "Egipat",
    "EH" to "Zapadna Sahara",
    "ER" to "Eritreja",
    "ES" to "Španija",
    "ET" to "Etiopija",
    "EU" to "Evropska unija",
    "EZ" to "Eurozona",
    "FI" to "Finska",
    "FJ" to "Fidži",
    "FK" to "Folklandska ostrva",
    "FM" to "Mikronezija",
    "FO" to "Farska ostrva",
    "FR" to "Francuska",
    "GA" to "Gabon",
    "GB" to "Ujedinjeno Kraljevstvo",
    "GD" to "Grenada",
    "GE" to "Gruzija",
    "GF" to "Francuska Gvajana",
    "GG" to "Guernsey",
    "GH" to "Gana",
    "GI" to "Gibraltar",
    "GL" to "Grenland",
    "GM" to "Gambija",
    "GN" to "Gvineja",
    "GP" to "Gvadalupe",
    "GQ" to "Ekvatorijalna Gvineja",
    "GR" to "Grčka",
    "GS" to "Južna Džordžija i Južna Sendvič ostrva",
    "GT" to "Gvatemala",
    "GU" to "Guam",
    "GW" to "Gvineja-Bisao",
    "GY" to "Gvajana",
    "HK" to "Hong Kong (SAR Kina)",
    "HM" to "Ostrvo Heard i arhipelag McDonald",
    "HN" to "Honduras",
    "HR" to "Hrvatska",
    "HT" to "Haiti",
    "HU" to "Mađarska",
    "IC" to "Kanarska ostrva",
    "ID" to "Indonezija",
    "IE" to "Irska",
    "IL" to "Izrael",
    "IM" to "Ostrvo Man",
    "IN" to "Indija",
    "IO" to "Britanska Teritorija u Indijskom Okeanu",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Island",
    "IT" to "Italija",
    "JE" to "Jersey",
    "JM" to "Jamajka",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenija",
    "KG" to "Kirgistan",
    "KH" to "Kambodža",
    "KI" to "Kiribati",
    "KM" to "Komori",
    "KN" to "Sveti Kits i Nevis",
    "KP" to "Sjeverna Koreja",
    "KR" to "Južna Koreja",
    "KW" to "Kuvajt",
    "KY" to "Kajmanska ostrva",
    "KZ" to "Kazahstan",
    "LA" to "Laos",
    "LB" to "Liban",
    "LC" to "Sveta Lucija",
    "LI" to "Lihtenštajn",
    "LK" to "Šri Lanka",
    "LR" to "Liberija",
    "LS" to "Lesoto",
    "LT" to "Litvanija",
    "LU" to "Luksemburg",
    "LV" to "Latvija",
    "LY" to "Libija",
    "MA" to "Maroko",
    "MC" to "Monako",
    "MD" to "Moldavija",
    "ME" to "Crna Gora",
    "MF" to "Sveti Martin",
    "MG" to "Madagaskar",
    "MH" to "Maršalova ostrva",
    "MK" to "Sjeverna Makedonija",
    "ML" to "Mali",
    "MM" to "Mijanmar",
    "MN" to "Mongolija",
    "MO" to "Makao (SAR Kina)",
    "MP" to "Sjeverna Marijanska ostrva",
    "MQ" to "Martinik",
    "MR" to "Mauritanija",
    "MS" to "Monserat",
    "MT" to "Malta",
    "MU" to "Mauricijus",
    "MV" to "Maldivi",
    "MW" to "Malavi",
    "MX" to "Meksiko",
    "MY" to "Malezija",
    "MZ" to "Mozambik",
    "NA" to "Namibija",
    "NC" to "Nova Kaledonija",
    "NE" to "Niger",
    "NF" to "Ostrvo Norfolk",
    "NG" to "Nigerija",
    "NI" to "Nikaragva",
    "NL" to "Nizozemska",
    "NO" to "Norveška",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Novi Zeland",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Francuska Polinezija",
    "PG" to "Papua Nova Gvineja",
    "PH" to "Filipini",
    "PK" to "Pakistan",
    "PL" to "Poljska",
    "PM" to "Sveti Petar i Mikelon",
    "PN" to "Pitkernska Ostrva",
    "PR" to "Porto Riko",
    "PS" to "Palestinska Teritorija",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paragvaj",
    "QA" to "Katar",
    "QO" to "Vanjska Okeanija",
    "RE" to "Reunion",
    "RO" to "Rumunija",
    "RS" to "Srbija",
    "RU" to "Rusija",
    "RW" to "Ruanda",
    "SA" to "Saudijska Arabija",
    "SB" to "Solomonska Ostrva",
    "SC" to "Sejšeli",
    "SD" to "Sudan",
    "SE" to "Švedska",
    "SG" to "Singapur",
    "SH" to "Sveta Helena",
    "SI" to "Slovenija",
    "SJ" to "Svalbard i Jan Mayen",
    "SK" to "Slovačka",
    "SL" to "Sijera Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalija",
    "SR" to "Surinam",
    "SS" to "Južni Sudan",
    "ST" to "Sao Tome i Principe",
    "SV" to "Salvador",
    "SX" to "Sint Marten",
    "SY" to "Sirija",
    "SZ" to "Esvatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Ostrva Turks i Kaikos",
    "TD" to "Čad",
    "TF" to "Francuske Južne Teritorije",
    "TG" to "Togo",
    "TH" to "Tajland",
    "TJ" to "Tadžikistan",
    "TK" to "Tokelau",
    "TL" to "Istočni Timor",
    "TM" to "Turkmenistan",
    "TN" to "Tunis",
    "TO" to "Tonga",
    "TR" to "Turska",
    "TT" to "Trinidad i Tobago",
    "TV" to "Tuvalu",
    "TW" to "Tajvan",
    "TZ" to "Tanzanija",
    "UA" to "Ukrajina",
    "UG" to "Uganda",
    "UM" to "Američka Vanjska Ostrva",
    "UN" to "Ujedinjene Nacije",
    "US" to "Sjedinjene Države",
    "UY" to "Urugvaj",
    "UZ" to "Uzbekistan",
    "VA" to "Vatikan",
    "VC" to "Sveti Vinsent i Grenadin",
    "VE" to "Venecuela",
    "VG" to "Britanska Djevičanska ostrva",
    "VI" to "Američka Djevičanska ostrva",
    "VN" to "Vijetnam",
    "VU" to "Vanuatu",
    "WF" to "Ostrva Valis i Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo naglasci",
    "XB" to "Pseudo bidi",
    "XK" to "Kosovo",
    "YE" to "Jemen",
    "YT" to "Majote",
    "ZA" to "Južnoafrička Republika",
    "ZM" to "Zambija",
    "ZW" to "Zimbabve",
    "ZZ" to "Nepoznata oblast",
  ) }

  val bs_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Свијет",
    "002" to "Африка",
    "003" to "Сјеверноамерички континент",
    "005" to "Јужна Америка",
    "009" to "Океанија",
    "011" to "Западна Африка",
    "013" to "Централна Америка",
    "014" to "Источна Африка",
    "015" to "Сјеверна Африка",
    "017" to "Централна Африка",
    "018" to "Јужна Африка",
    "019" to "Сјеверна и Јужна Америка",
    "021" to "Сјеверна Америка",
    "029" to "Кариби",
    "030" to "Источна Азија",
    "034" to "Јужна Азија",
    "035" to "Југоисточна Азија",
    "039" to "Јужна Европа",
    "053" to "Аустралија и Нови Зеланд",
    "054" to "Меланезија",
    "057" to "Микронезијски регион",
    "061" to "Полинезија",
    "142" to "Азија",
    "143" to "Централна Азија",
    "145" to "Западна Азија",
    "150" to "Европа",
    "151" to "Источна Европа",
    "154" to "Сјеверна Европа",
    "155" to "Западна Европа",
    "202" to "Подсахарска Африка",
    "419" to "Латинска Америка",
    "AC" to "Острво Асенсион",
    "AD" to "Андора",
    "AE" to "Уједињени Арапски Емирати",
    "AF" to "Афганистан",
    "AG" to "Антигва и Барбуда",
    "AI" to "Ангвила",
    "AL" to "Албанија",
    "AM" to "Арменија",
    "AO" to "Ангола",
    "AQ" to "Антарктик",
    "AR" to "Аргентина",
    "AS" to "Америчка Самоа",
    "AT" to "Аустрија",
    "AU" to "Аустралија",
    "AW" to "Аруба",
    "AX" to "Оландска острва",
    "AZ" to "Азербејџан",
    "BA" to "Босна и Херцеговина",
    "BB" to "Барбадос",
    "BD" to "Бангладеш",
    "BE" to "Белгија",
    "BF" to "Буркина Фасо",
    "BG" to "Бугарска",
    "BH" to "Бахреин",
    "BI" to "Бурунди",
    "BJ" to "Бенин",
    "BL" to "Свети Бартоломеј",
    "BM" to "Бермуди",
    "BN" to "Брунеј",
    "BO" to "Боливија",
    "BQ" to "Карипска Холандија",
    "BR" to "Бразил",
    "BS" to "Бахами",
    "BT" to "Бутан",
    "BV" to "Острво Буве",
    "BW" to "Боцвана",
    "BY" to "Бјелорусија",
    "BZ" to "Белизе",
    "CA" to "Канада",
    "CC" to "Кокос (Келинг) Острва",
    "CD" to "Демократска Република Конго",
    "CF" to "Централноафричка Република",
    "CG" to "Конго",
    "CH" to "Швицарска",
    "CI" to "Обала Слоноваче (Кот д’Ивоар)",
    "CK" to "Кукова Острва",
    "CL" to "Чиле",
    "CM" to "Камерун",
    "CN" to "Кина",
    "CO" to "Колумбија",
    "CP" to "Острво Клипертон",
    "CR" to "Костарика",
    "CU" to "Куба",
    "CV" to "Зеленортска Острва",
    "CW" to "Курасао",
    "CX" to "Божићно острво",
    "CY" to "Кипар",
    "CZ" to "Чешка",
    "DE" to "Њемачка",
    "DG" to "Дијего Гарсија",
    "DJ" to "Џибути",
    "DK" to "Данска",
    "DM" to "Доминика",
    "DO" to "Доминиканска Република",
    "DZ" to "Алжир",
    "EA" to "Сеута и Мелиља",
    "EC" to "Еквадор",
    "EE" to "Естонија",
    "EG" to "Египат",
    "EH" to "Западна Сахара",
    "ER" to "Еритреја",
    "ES" to "Шпанија",
    "ET" to "Етиопија",
    "EU" to "Европска унија",
    "EZ" to "Еурозона",
    "FI" to "Финска",
    "FJ" to "Фиџи",
    "FK" to "Фокландска Острва",
    "FM" to "Микронезија",
    "FO" to "Фарска острва",
    "FR" to "Француска",
    "GA" to "Габон",
    "GB" to "Уједињено Краљевство",
    "GD" to "Гренада",
    "GE" to "Грузија",
    "GF" to "Француска Гвајана",
    "GG" to "Гернзи",
    "GH" to "Гана",
    "GI" to "Гибралтар",
    "GL" to "Гренланд",
    "GM" to "Гамбија",
    "GN" to "Гвинеја",
    "GP" to "Гваделупе",
    "GQ" to "Екваторијална Гвинеја",
    "GR" to "Грчка",
    "GS" to "Јужна Џорџија и Јужна Сендвичка Острва",
    "GT" to "Гватемала",
    "GU" to "Гуам",
    "GW" to "Гвинеја-Бисау",
    "GY" to "Гвајана",
    "HK" to "Хонг Конг С. А. Р.",
    "HM" to "Херд и Мекдоналд Острва",
    "HN" to "Хондурас",
    "HR" to "Хрватска",
    "HT" to "Хаити",
    "HU" to "Мађарска",
    "IC" to "Канарска острва",
    "ID" to "Индонезија",
    "IE" to "Ирска",
    "IL" to "Израел",
    "IM" to "Острво Мен",
    "IN" to "Индија",
    "IO" to "Британска територија у Индијском океану",
    "IQ" to "Ирак",
    "IR" to "Иран",
    "IS" to "Исланд",
    "IT" to "Италија",
    "JE" to "Џерзи",
    "JM" to "Јамајка",
    "JO" to "Јордан",
    "JP" to "Јапан",
    "KE" to "Кенија",
    "KG" to "Киргизстан",
    "KH" to "Камбоџа",
    "KI" to "Кирибати",
    "KM" to "Комори",
    "KN" to "Свети Китс и Невис",
    "KP" to "Сјеверна Кореја",
    "KR" to "Јужна Кореја",
    "KW" to "Кувајт",
    "KY" to "Кајманска острва",
    "KZ" to "Казахстан",
    "LA" to "Лаос",
    "LB" to "Либан",
    "LC" to "Света Луција",
    "LI" to "Лихтенштајн",
    "LK" to "Шри Ланка",
    "LR" to "Либерија",
    "LS" to "Лесото",
    "LT" to "Литванија",
    "LU" to "Луксембург",
    "LV" to "Латвија",
    "LY" to "Либија",
    "MA" to "Мароко",
    "MC" to "Монако",
    "MD" to "Молдавија",
    "ME" to "Црна Гора",
    "MF" to "Свети Мартин",
    "MG" to "Мадагаскар",
    "MH" to "Маршалска Острва",
    "MK" to "Сјеверна Македонија",
    "ML" to "Мали",
    "MM" to "Мјанмар",
    "MN" to "Монголија",
    "MO" to "Макао С. А. Р.",
    "MP" to "Сјеверна Маријанска Острва",
    "MQ" to "Мартиник",
    "MR" to "Мауританија",
    "MS" to "Монсерат",
    "MT" to "Малта",
    "MU" to "Маурицијус",
    "MV" to "Малдиви",
    "MW" to "Малави",
    "MX" to "Мексико",
    "MY" to "Малезија",
    "MZ" to "Мозамбик",
    "NA" to "Намибија",
    "NC" to "Нова Каледонија",
    "NE" to "Нигер",
    "NF" to "Острво Норфолк",
    "NG" to "Нигерија",
    "NI" to "Никарагва",
    "NL" to "Холандија",
    "NO" to "Норвешка",
    "NP" to "Непал",
    "NR" to "Науру",
    "NU" to "Ниуе",
    "NZ" to "Нови Зеланд",
    "OM" to "Оман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PF" to "Француска Полинезија",
    "PG" to "Папуа Нова Гвинеја",
    "PH" to "Филипини",
    "PK" to "Пакистан",
    "PL" to "Пољска",
    "PM" to "Сен Пјер и Микелон",
    "PN" to "Питкерн",
    "PR" to "Порторико",
    "PS" to "Палестинске територије",
    "PT" to "Португал",
    "PW" to "Палау",
    "PY" to "Парагвај",
    "QA" to "Катар",
    "QO" to "Остала океанија",
    "RE" to "Реинион",
    "RO" to "Румунија",
    "RS" to "Србија",
    "RU" to "Русија",
    "RW" to "Руанда",
    "SA" to "Саудијска Арабија",
    "SB" to "Соломонска Острва",
    "SC" to "Сејшели",
    "SD" to "Судан",
    "SE" to "Шведска",
    "SG" to "Сингапур",
    "SH" to "Света Хелена",
    "SI" to "Словенија",
    "SJ" to "Свалбард и Јан Мајен",
    "SK" to "Словачка",
    "SL" to "Сијера Леоне",
    "SM" to "Сан Марино",
    "SN" to "Сенегал",
    "SO" to "Сомалија",
    "SR" to "Суринам",
    "SS" to "Јужни Судан",
    "ST" to "Сао Томе и Принципе",
    "SV" to "Салвадор",
    "SX" to "Свети Мартин (Холандија)",
    "SY" to "Сирија",
    "SZ" to "Есватини",
    "TA" to "Тристан да Куња",
    "TC" to "Туркс и Кајкос Острва",
    "TD" to "Чад",
    "TF" to "Француске Јужне Територије",
    "TG" to "Того",
    "TH" to "Тајланд",
    "TJ" to "Таџикистан",
    "TK" to "Токелау",
    "TL" to "Тимор-Лесте",
    "TM" to "Туркменистан",
    "TN" to "Тунис",
    "TO" to "Тонга",
    "TR" to "Турска",
    "TT" to "Тринидад и Тобаго",
    "TV" to "Тувалу",
    "TW" to "Тајван",
    "TZ" to "Танзанија",
    "UA" to "Украјина",
    "UG" to "Уганда",
    "UM" to "Мања удаљена острва САД",
    "UN" to "Уједињене нације",
    "US" to "Сједињене Америчке Државе",
    "UY" to "Уругвај",
    "UZ" to "Узбекистан",
    "VA" to "Ватикан",
    "VC" to "Свети Винсент и Гренадини",
    "VE" to "Венецуела",
    "VG" to "Британска Дјевичанска острва",
    "VI" to "Америчка Дјевичанска острва",
    "VN" to "Вијетнам",
    "VU" to "Вануату",
    "WF" to "Валис и Футуна",
    "WS" to "Самоа",
    "XA" to "псеудо акценти",
    "XB" to "псеудо двосмјерно",
    "XK" to "Косово",
    "YE" to "Јемен",
    "YT" to "Мајоте",
    "ZA" to "Јужноафричка Република",
    "ZM" to "Замбија",
    "ZW" to "Зимбабве",
    "ZZ" to "Непозната или неважећа област",
  ) }

  val bs_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Svijet",
    "002" to "Afrika",
    "003" to "Sjeverna Amerika",
    "005" to "Južna Amerika",
    "009" to "Okeanija",
    "011" to "Zapadna Afrika",
    "013" to "Srednja Amerika",
    "014" to "Istočna Afrika",
    "015" to "Sjeverna Afrika",
    "017" to "Srednja Afrika",
    "018" to "Južna Afrika",
    "019" to "Amerika",
    "021" to "Sjeverni dio Amerike",
    "029" to "Karibi",
    "030" to "Istočna Azija",
    "034" to "Južna Azija",
    "035" to "Jugoistočna Azija",
    "039" to "Južna Evropa",
    "053" to "Australazija",
    "054" to "Melanezija",
    "057" to "Mikronezijska regija",
    "061" to "Polinezija",
    "142" to "Azija",
    "143" to "Srednja Azija",
    "145" to "Zapadna Azija",
    "150" to "Evropa",
    "151" to "Istočna Evropa",
    "154" to "Sjeverna Evropa",
    "155" to "Zapadna Evropa",
    "202" to "Subsaharska Afrika",
    "419" to "Latinska Amerika",
    "AC" to "Ostrvo Ascension",
    "AD" to "Andora",
    "AE" to "Ujedinjeni Arapski Emirati",
    "AF" to "Afganistan",
    "AG" to "Antigva i Barbuda",
    "AI" to "Angvila",
    "AL" to "Albanija",
    "AM" to "Armenija",
    "AO" to "Angola",
    "AQ" to "Antarktika",
    "AR" to "Argentina",
    "AS" to "Američka Samoa",
    "AT" to "Austrija",
    "AU" to "Australija",
    "AW" to "Aruba",
    "AX" to "Olandska ostrva",
    "AZ" to "Azerbejdžan",
    "BA" to "Bosna i Hercegovina",
    "BB" to "Barbados",
    "BD" to "Bangladeš",
    "BE" to "Belgija",
    "BF" to "Burkina Faso",
    "BG" to "Bugarska",
    "BH" to "Bahrein",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Sveti Bartolomej",
    "BM" to "Bermuda",
    "BN" to "Brunej",
    "BO" to "Bolivija",
    "BQ" to "Karipska Holandija",
    "BR" to "Brazil",
    "BS" to "Bahami",
    "BT" to "Butan",
    "BV" to "Ostrvo Buve",
    "BW" to "Bocvana",
    "BY" to "Bjelorusija",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kokosova (Keelingova) ostrva",
    "CD" to "Demokratska Republika Kongo",
    "CF" to "Centralnoafrička Republika",
    "CG" to "Kongo",
    "CH" to "Švicarska",
    "CI" to "Obala Slonovače",
    "CK" to "Kukova ostrva",
    "CL" to "Čile",
    "CM" to "Kamerun",
    "CN" to "Kina",
    "CO" to "Kolumbija",
    "CP" to "Ostrvo Clipperton",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Zelenortska Ostrva",
    "CW" to "Kurasao",
    "CX" to "Božićno ostrvo",
    "CY" to "Kipar",
    "CZ" to "Češka",
    "DE" to "Njemačka",
    "DG" to "Dijego Garsija",
    "DJ" to "Džibuti",
    "DK" to "Danska",
    "DM" to "Dominika",
    "DO" to "Dominikanska Republika",
    "DZ" to "Alžir",
    "EA" to "Seuta i Melilja",
    "EC" to "Ekvador",
    "EE" to "Estonija",
    "EG" to "Egipat",
    "EH" to "Zapadna Sahara",
    "ER" to "Eritreja",
    "ES" to "Španija",
    "ET" to "Etiopija",
    "EU" to "Evropska unija",
    "EZ" to "Eurozona",
    "FI" to "Finska",
    "FJ" to "Fidži",
    "FK" to "Folklandska ostrva",
    "FM" to "Mikronezija",
    "FO" to "Farska ostrva",
    "FR" to "Francuska",
    "GA" to "Gabon",
    "GB" to "Ujedinjeno Kraljevstvo",
    "GD" to "Grenada",
    "GE" to "Gruzija",
    "GF" to "Francuska Gvajana",
    "GG" to "Guernsey",
    "GH" to "Gana",
    "GI" to "Gibraltar",
    "GL" to "Grenland",
    "GM" to "Gambija",
    "GN" to "Gvineja",
    "GP" to "Gvadalupe",
    "GQ" to "Ekvatorijalna Gvineja",
    "GR" to "Grčka",
    "GS" to "Južna Džordžija i Južna Sendvič ostrva",
    "GT" to "Gvatemala",
    "GU" to "Guam",
    "GW" to "Gvineja-Bisao",
    "GY" to "Gvajana",
    "HK" to "Hong Kong (SAR Kina)",
    "HM" to "Ostrvo Heard i arhipelag McDonald",
    "HN" to "Honduras",
    "HR" to "Hrvatska",
    "HT" to "Haiti",
    "HU" to "Mađarska",
    "IC" to "Kanarska ostrva",
    "ID" to "Indonezija",
    "IE" to "Irska",
    "IL" to "Izrael",
    "IM" to "Ostrvo Man",
    "IN" to "Indija",
    "IO" to "Britanska Teritorija u Indijskom Okeanu",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Island",
    "IT" to "Italija",
    "JE" to "Jersey",
    "JM" to "Jamajka",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenija",
    "KG" to "Kirgistan",
    "KH" to "Kambodža",
    "KI" to "Kiribati",
    "KM" to "Komori",
    "KN" to "Sveti Kits i Nevis",
    "KP" to "Sjeverna Koreja",
    "KR" to "Južna Koreja",
    "KW" to "Kuvajt",
    "KY" to "Kajmanska ostrva",
    "KZ" to "Kazahstan",
    "LA" to "Laos",
    "LB" to "Liban",
    "LC" to "Sveta Lucija",
    "LI" to "Lihtenštajn",
    "LK" to "Šri Lanka",
    "LR" to "Liberija",
    "LS" to "Lesoto",
    "LT" to "Litvanija",
    "LU" to "Luksemburg",
    "LV" to "Latvija",
    "LY" to "Libija",
    "MA" to "Maroko",
    "MC" to "Monako",
    "MD" to "Moldavija",
    "ME" to "Crna Gora",
    "MF" to "Sveti Martin",
    "MG" to "Madagaskar",
    "MH" to "Maršalova ostrva",
    "MK" to "Sjeverna Makedonija",
    "ML" to "Mali",
    "MM" to "Mijanmar",
    "MN" to "Mongolija",
    "MO" to "Makao (SAR Kina)",
    "MP" to "Sjeverna Marijanska ostrva",
    "MQ" to "Martinik",
    "MR" to "Mauritanija",
    "MS" to "Monserat",
    "MT" to "Malta",
    "MU" to "Mauricijus",
    "MV" to "Maldivi",
    "MW" to "Malavi",
    "MX" to "Meksiko",
    "MY" to "Malezija",
    "MZ" to "Mozambik",
    "NA" to "Namibija",
    "NC" to "Nova Kaledonija",
    "NE" to "Niger",
    "NF" to "Ostrvo Norfolk",
    "NG" to "Nigerija",
    "NI" to "Nikaragva",
    "NL" to "Nizozemska",
    "NO" to "Norveška",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Novi Zeland",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Francuska Polinezija",
    "PG" to "Papua Nova Gvineja",
    "PH" to "Filipini",
    "PK" to "Pakistan",
    "PL" to "Poljska",
    "PM" to "Sveti Petar i Mikelon",
    "PN" to "Pitkernska Ostrva",
    "PR" to "Porto Riko",
    "PS" to "Palestinska Teritorija",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paragvaj",
    "QA" to "Katar",
    "QO" to "Vanjska Okeanija",
    "RE" to "Reunion",
    "RO" to "Rumunija",
    "RS" to "Srbija",
    "RU" to "Rusija",
    "RW" to "Ruanda",
    "SA" to "Saudijska Arabija",
    "SB" to "Solomonska Ostrva",
    "SC" to "Sejšeli",
    "SD" to "Sudan",
    "SE" to "Švedska",
    "SG" to "Singapur",
    "SH" to "Sveta Helena",
    "SI" to "Slovenija",
    "SJ" to "Svalbard i Jan Mayen",
    "SK" to "Slovačka",
    "SL" to "Sijera Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalija",
    "SR" to "Surinam",
    "SS" to "Južni Sudan",
    "ST" to "Sao Tome i Principe",
    "SV" to "Salvador",
    "SX" to "Sint Marten",
    "SY" to "Sirija",
    "SZ" to "Esvatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Ostrva Turks i Kaikos",
    "TD" to "Čad",
    "TF" to "Francuske Južne Teritorije",
    "TG" to "Togo",
    "TH" to "Tajland",
    "TJ" to "Tadžikistan",
    "TK" to "Tokelau",
    "TL" to "Istočni Timor",
    "TM" to "Turkmenistan",
    "TN" to "Tunis",
    "TO" to "Tonga",
    "TR" to "Turska",
    "TT" to "Trinidad i Tobago",
    "TV" to "Tuvalu",
    "TW" to "Tajvan",
    "TZ" to "Tanzanija",
    "UA" to "Ukrajina",
    "UG" to "Uganda",
    "UM" to "Američka Vanjska Ostrva",
    "UN" to "Ujedinjene Nacije",
    "US" to "Sjedinjene Države",
    "UY" to "Urugvaj",
    "UZ" to "Uzbekistan",
    "VA" to "Vatikan",
    "VC" to "Sveti Vinsent i Grenadin",
    "VE" to "Venecuela",
    "VG" to "Britanska Djevičanska ostrva",
    "VI" to "Američka Djevičanska ostrva",
    "VN" to "Vijetnam",
    "VU" to "Vanuatu",
    "WF" to "Ostrva Valis i Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo naglasci",
    "XB" to "Pseudo bidi",
    "XK" to "Kosovo",
    "YE" to "Jemen",
    "YT" to "Majote",
    "ZA" to "Južnoafrička Republika",
    "ZM" to "Zambija",
    "ZW" to "Zimbabve",
    "ZZ" to "Nepoznata oblast",
  ) }

  val bss: ImmutableMap<String, String> by lazy { immutableMapOf(
    "CM" to "Kamerûn",
  ) }

  val ca: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Món",
    "002" to "Àfrica",
    "003" to "Amèrica del Nord",
    "005" to "Amèrica del Sud",
    "009" to "Oceania",
    "011" to "Àfrica occidental",
    "013" to "Amèrica Central",
    "014" to "Àfrica oriental",
    "015" to "Àfrica septentrional",
    "017" to "Àfrica central",
    "018" to "Àfrica meridional",
    "019" to "Amèrica",
    "021" to "Amèrica septentrional",
    "029" to "Carib",
    "030" to "Àsia oriental",
    "034" to "Àsia meridional",
    "035" to "Àsia sud-oriental",
    "039" to "Europa meridional",
    "053" to "Australàsia",
    "054" to "Melanèsia",
    "057" to "Regió de la Micronèsia",
    "061" to "Polinèsia",
    "142" to "Àsia",
    "143" to "Àsia central",
    "145" to "Àsia occidental",
    "150" to "Europa",
    "151" to "Europa oriental",
    "154" to "Europa septentrional",
    "155" to "Europa occidental",
    "202" to "Àfrica subsahariana",
    "419" to "Amèrica Llatina",
    "AC" to "Illa de l’Ascensió",
    "AD" to "Andorra",
    "AE" to "Emirats Àrabs Units",
    "AF" to "Afganistan",
    "AG" to "Antigua i Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albània",
    "AM" to "Armènia",
    "AO" to "Angola",
    "AQ" to "Antàrtida",
    "AR" to "Argentina",
    "AS" to "Samoa Americana",
    "AT" to "Àustria",
    "AU" to "Austràlia",
    "AW" to "Aruba",
    "AX" to "Illes Åland",
    "AZ" to "Azerbaidjan",
    "BA" to "Bòsnia i Hercegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Bèlgica",
    "BF" to "Burkina Faso",
    "BG" to "Bulgària",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benín",
    "BL" to "Saint-Barthélemy",
    "BM" to "Bermudes",
    "BN" to "Brunei",
    "BO" to "Bolívia",
    "BQ" to "Carib Neerlandès",
    "BR" to "Brasil",
    "BS" to "Bahames",
    "BT" to "Bhutan",
    "BV" to "Illa Bouvet",
    "BW" to "Botswana",
    "BY" to "Belarús",
    "BZ" to "Belize",
    "CA" to "Canadà",
    "CC" to "Illes Cocos (Keeling)",
    "CD" to "Congo - Kinshasa",
    "CF" to "República Centreafricana",
    "CG" to "Congo - Brazzaville",
    "CH" to "Suïssa",
    "CI" to "Côte d’Ivoire",
    "CK" to "Illes Cook",
    "CL" to "Xile",
    "CM" to "Camerun",
    "CN" to "Xina",
    "CO" to "Colòmbia",
    "CP" to "Illa Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cap Verd",
    "CW" to "Curaçao",
    "CX" to "Illa Christmas",
    "CY" to "Xipre",
    "CZ" to "Txèquia",
    "DE" to "Alemanya",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Dinamarca",
    "DM" to "Dominica",
    "DO" to "República Dominicana",
    "DZ" to "Algèria",
    "EA" to "Ceuta i Melilla",
    "EC" to "Equador",
    "EE" to "Estònia",
    "EG" to "Egipte",
    "EH" to "Sàhara Occidental",
    "ER" to "Eritrea",
    "ES" to "Espanya",
    "ET" to "Etiòpia",
    "EU" to "Unió Europea",
    "EZ" to "zona euro",
    "FI" to "Finlàndia",
    "FJ" to "Fiji",
    "FK" to "Illes Falkland",
    "FM" to "Micronèsia",
    "FO" to "Illes Fèroe",
    "FR" to "França",
    "GA" to "Gabon",
    "GB" to "Regne Unit",
    "GD" to "Grenada",
    "GE" to "Geòrgia",
    "GF" to "Guaiana Francesa",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Groenlàndia",
    "GM" to "Gàmbia",
    "GN" to "Guinea",
    "GP" to "Guadalupe",
    "GQ" to "Guinea Equatorial",
    "GR" to "Grècia",
    "GS" to "Illes Geòrgia del Sud i Sandwich del Sud",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong (RAE Xina)",
    "HM" to "Illes Heard i McDonald",
    "HN" to "Hondures",
    "HR" to "Croàcia",
    "HT" to "Haití",
    "HU" to "Hongria",
    "IC" to "Illes Canàries",
    "ID" to "Indonèsia",
    "IE" to "Irlanda",
    "IL" to "Israel",
    "IM" to "Illa de Man",
    "IN" to "Índia",
    "IO" to "Territori Britànic de l’Oceà Índic",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Islàndia",
    "IT" to "Itàlia",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordània",
    "JP" to "Japó",
    "KE" to "Kenya",
    "KG" to "Kirguizstan",
    "KH" to "Cambodja",
    "KI" to "Kiribati",
    "KM" to "Comores",
    "KN" to "Saint Kitts i Nevis",
    "KP" to "Corea del Nord",
    "KR" to "Corea del Sud",
    "KW" to "Kuwait",
    "KY" to "Illes Caiman",
    "KZ" to "Kazakhstan",
    "LA" to "Lao",
    "LB" to "Líban",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Libèria",
    "LS" to "Lesotho",
    "LT" to "Lituània",
    "LU" to "Luxemburg",
    "LV" to "Letònia",
    "LY" to "Líbia",
    "MA" to "Marroc",
    "MC" to "Mònaco",
    "MD" to "Moldàvia",
    "ME" to "Montenegro",
    "MF" to "Saint Martin",
    "MG" to "Madagascar",
    "MH" to "Illes Marshall",
    "MK" to "Macedònia del Nord",
    "ML" to "Mali",
    "MM" to "Myanmar (Birmània)",
    "MN" to "Mongòlia",
    "MO" to "Macau (RAE Xina)",
    "MP" to "Illes Marianes del Nord",
    "MQ" to "Martinica",
    "MR" to "Mauritània",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Maurici",
    "MV" to "Maldives",
    "MW" to "Malawi",
    "MX" to "Mèxic",
    "MY" to "Malàisia",
    "MZ" to "Moçambic",
    "NA" to "Namíbia",
    "NC" to "Nova Caledònia",
    "NE" to "Níger",
    "NF" to "Illa Norfolk",
    "NG" to "Nigèria",
    "NI" to "Nicaragua",
    "NL" to "Països Baixos",
    "NO" to "Noruega",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nova Zelanda",
    "OM" to "Oman",
    "PA" to "Panamà",
    "PE" to "Perú",
    "PF" to "Polinèsia Francesa",
    "PG" to "Papua Nova Guinea",
    "PH" to "Filipines",
    "PK" to "Pakistan",
    "PL" to "Polònia",
    "PM" to "Saint-Pierre-et-Miquelon",
    "PN" to "Illes Pitcairn",
    "PR" to "Puerto Rico",
    "PS" to "Territoris palestins",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguai",
    "QA" to "Qatar",
    "QO" to "Territoris allunyats d’Oceania",
    "RE" to "Illa de la Reunió",
    "RO" to "Romania",
    "RS" to "Sèrbia",
    "RU" to "Rússia",
    "RW" to "Ruanda",
    "SA" to "Aràbia Saudí",
    "SB" to "Illes Salomó",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Suècia",
    "SG" to "Singapur",
    "SH" to "Santa Helena",
    "SI" to "Eslovènia",
    "SJ" to "Svalbard i Jan Mayen",
    "SK" to "Eslovàquia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somàlia",
    "SR" to "Surinam",
    "SS" to "Sudan del Sud",
    "ST" to "São Tomé i Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Síria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Illes Turks i Caicos",
    "TD" to "Txad",
    "TF" to "Terres Australs Antàrtiques Franceses",
    "TG" to "Togo",
    "TH" to "Tailàndia",
    "TJ" to "Tadjikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunísia",
    "TO" to "Tonga",
    "TR" to "Turquia",
    "TT" to "Trinidad i Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzània",
    "UA" to "Ucraïna",
    "UG" to "Uganda",
    "UM" to "Illes Menors Allunyades dels Estats Units",
    "UN" to "Nacions Unides",
    "US" to "Estats Units",
    "UY" to "Uruguai",
    "UZ" to "Uzbekistan",
    "VA" to "Ciutat del Vaticà",
    "VC" to "Saint Vincent i les Grenadines",
    "VE" to "Veneçuela",
    "VG" to "Illes Verges Britàniques",
    "VI" to "Illes Verges dels Estats Units",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis i Futuna",
    "WS" to "Samoa",
    "XA" to "pseudoaccents",
    "XB" to "pseudobidi",
    "XK" to "Kosovo",
    "YE" to "Iemen",
    "YT" to "Mayotte",
    "ZA" to "Sud-àfrica",
    "ZM" to "Zàmbia",
    "ZW" to "Zimbàbue",
    "ZZ" to "regió desconeguda",
  ) }

  val ca_AD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ca_ES_valencia: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Món",
    "002" to "Àfrica",
    "003" to "Amèrica del Nord",
    "005" to "Amèrica del Sud",
    "009" to "Oceania",
    "011" to "Àfrica occidental",
    "013" to "Amèrica Central",
    "014" to "Àfrica oriental",
    "015" to "Àfrica septentrional",
    "017" to "Àfrica central",
    "018" to "Àfrica meridional",
    "019" to "Amèrica",
    "021" to "Amèrica septentrional",
    "029" to "Carib",
    "030" to "Àsia oriental",
    "034" to "Àsia meridional",
    "035" to "Àsia sud-oriental",
    "039" to "Europa meridional",
    "053" to "Australàsia",
    "054" to "Melanèsia",
    "057" to "Regió de la Micronèsia",
    "061" to "Polinèsia",
    "142" to "Àsia",
    "143" to "Àsia central",
    "145" to "Àsia occidental",
    "150" to "Europa",
    "151" to "Europa oriental",
    "154" to "Europa septentrional",
    "155" to "Europa occidental",
    "202" to "Àfrica subsahariana",
    "419" to "Amèrica Llatina",
    "AC" to "Illa de l’Ascensió",
    "AD" to "Andorra",
    "AE" to "Emirats Àrabs Units",
    "AF" to "Afganistan",
    "AG" to "Antigua i Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albània",
    "AM" to "Armènia",
    "AO" to "Angola",
    "AQ" to "Antàrtida",
    "AR" to "Argentina",
    "AS" to "Samoa Americana",
    "AT" to "Àustria",
    "AU" to "Austràlia",
    "AW" to "Aruba",
    "AX" to "Illes Åland",
    "AZ" to "Azerbaidjan",
    "BA" to "Bòsnia i Hercegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Bèlgica",
    "BF" to "Burkina Faso",
    "BG" to "Bulgària",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benín",
    "BL" to "Saint-Barthélemy",
    "BM" to "Bermudes",
    "BN" to "Brunei",
    "BO" to "Bolívia",
    "BQ" to "Carib Neerlandès",
    "BR" to "Brasil",
    "BS" to "Bahames",
    "BT" to "Bhutan",
    "BV" to "Illa Bouvet",
    "BW" to "Botswana",
    "BY" to "Belarús",
    "BZ" to "Belize",
    "CA" to "Canadà",
    "CC" to "Illes Cocos (Keeling)",
    "CD" to "Congo - Kinshasa",
    "CF" to "República Centreafricana",
    "CG" to "Congo - Brazzaville",
    "CH" to "Suïssa",
    "CI" to "Côte d’Ivoire",
    "CK" to "Illes Cook",
    "CL" to "Xile",
    "CM" to "Camerun",
    "CN" to "Xina",
    "CO" to "Colòmbia",
    "CP" to "Illa Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cap Verd",
    "CW" to "Curaçao",
    "CX" to "Illa Christmas",
    "CY" to "Xipre",
    "CZ" to "Txèquia",
    "DE" to "Alemanya",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Dinamarca",
    "DM" to "Dominica",
    "DO" to "República Dominicana",
    "DZ" to "Algèria",
    "EA" to "Ceuta i Melilla",
    "EC" to "Equador",
    "EE" to "Estònia",
    "EG" to "Egipte",
    "EH" to "Sàhara Occidental",
    "ER" to "Eritrea",
    "ES" to "Espanya",
    "ET" to "Etiòpia",
    "EU" to "Unió Europea",
    "EZ" to "zona euro",
    "FI" to "Finlàndia",
    "FJ" to "Fiji",
    "FK" to "Illes Falkland",
    "FM" to "Micronèsia",
    "FO" to "Illes Fèroe",
    "FR" to "França",
    "GA" to "Gabon",
    "GB" to "Regne Unit",
    "GD" to "Grenada",
    "GE" to "Geòrgia",
    "GF" to "Guaiana Francesa",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Groenlàndia",
    "GM" to "Gàmbia",
    "GN" to "Guinea",
    "GP" to "Guadalupe",
    "GQ" to "Guinea Equatorial",
    "GR" to "Grècia",
    "GS" to "Illes Geòrgia del Sud i Sandwich del Sud",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong (RAE Xina)",
    "HM" to "Illes Heard i McDonald",
    "HN" to "Hondures",
    "HR" to "Croàcia",
    "HT" to "Haití",
    "HU" to "Hongria",
    "IC" to "Illes Canàries",
    "ID" to "Indonèsia",
    "IE" to "Irlanda",
    "IL" to "Israel",
    "IM" to "Illa de Man",
    "IN" to "Índia",
    "IO" to "Territori Britànic de l’Oceà Índic",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Islàndia",
    "IT" to "Itàlia",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordània",
    "JP" to "Japó",
    "KE" to "Kenya",
    "KG" to "Kirguizstan",
    "KH" to "Cambodja",
    "KI" to "Kiribati",
    "KM" to "Comores",
    "KN" to "Saint Kitts i Nevis",
    "KP" to "Corea del Nord",
    "KR" to "Corea del Sud",
    "KW" to "Kuwait",
    "KY" to "Illes Caiman",
    "KZ" to "Kazakhstan",
    "LA" to "Lao",
    "LB" to "Líban",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Libèria",
    "LS" to "Lesotho",
    "LT" to "Lituània",
    "LU" to "Luxemburg",
    "LV" to "Letònia",
    "LY" to "Líbia",
    "MA" to "Marroc",
    "MC" to "Mònaco",
    "MD" to "Moldàvia",
    "ME" to "Montenegro",
    "MF" to "Saint Martin",
    "MG" to "Madagascar",
    "MH" to "Illes Marshall",
    "MK" to "Macedònia del Nord",
    "ML" to "Mali",
    "MM" to "Myanmar (Birmània)",
    "MN" to "Mongòlia",
    "MO" to "Macau (RAE Xina)",
    "MP" to "Illes Marianes del Nord",
    "MQ" to "Martinica",
    "MR" to "Mauritània",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Maurici",
    "MV" to "Maldives",
    "MW" to "Malawi",
    "MX" to "Mèxic",
    "MY" to "Malàisia",
    "MZ" to "Moçambic",
    "NA" to "Namíbia",
    "NC" to "Nova Caledònia",
    "NE" to "Níger",
    "NF" to "Illa Norfolk",
    "NG" to "Nigèria",
    "NI" to "Nicaragua",
    "NL" to "Països Baixos",
    "NO" to "Noruega",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nova Zelanda",
    "OM" to "Oman",
    "PA" to "Panamà",
    "PE" to "Perú",
    "PF" to "Polinèsia Francesa",
    "PG" to "Papua Nova Guinea",
    "PH" to "Filipines",
    "PK" to "Pakistan",
    "PL" to "Polònia",
    "PM" to "Saint-Pierre-et-Miquelon",
    "PN" to "Illes Pitcairn",
    "PR" to "Puerto Rico",
    "PS" to "Territoris palestins",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguai",
    "QA" to "Qatar",
    "QO" to "Territoris allunyats d’Oceania",
    "RE" to "Illa de la Reunió",
    "RO" to "Romania",
    "RS" to "Sèrbia",
    "RU" to "Rússia",
    "RW" to "Ruanda",
    "SA" to "Aràbia Saudí",
    "SB" to "Illes Salomó",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Suècia",
    "SG" to "Singapur",
    "SH" to "Santa Helena",
    "SI" to "Eslovènia",
    "SJ" to "Svalbard i Jan Mayen",
    "SK" to "Eslovàquia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somàlia",
    "SR" to "Surinam",
    "SS" to "Sudan del Sud",
    "ST" to "São Tomé i Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Síria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Illes Turks i Caicos",
    "TD" to "Txad",
    "TF" to "Terres Australs Antàrtiques Franceses",
    "TG" to "Togo",
    "TH" to "Tailàndia",
    "TJ" to "Tadjikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunísia",
    "TO" to "Tonga",
    "TR" to "Turquia",
    "TT" to "Trinidad i Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzània",
    "UA" to "Ucraïna",
    "UG" to "Uganda",
    "UM" to "Illes Menors Allunyades dels Estats Units",
    "UN" to "Nacions Unides",
    "US" to "Estats Units",
    "UY" to "Uruguai",
    "UZ" to "Uzbekistan",
    "VA" to "Ciutat del Vaticà",
    "VC" to "Saint Vincent i les Grenadines",
    "VE" to "Veneçuela",
    "VG" to "Illes Verges Britàniques",
    "VI" to "Illes Verges dels Estats Units",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis i Futuna",
    "WS" to "Samoa",
    "XA" to "pseudoaccents",
    "XB" to "pseudobidi",
    "XK" to "Kosovo",
    "YE" to "Iemen",
    "YT" to "Mayotte",
    "ZA" to "Sud-àfrica",
    "ZM" to "Zàmbia",
    "ZW" to "Zimbàbue",
    "ZZ" to "regió desconeguda",
  ) }

  val ca_FR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ca_IT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ccp: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "𑄛𑄨𑄖𑄴𑄗𑄨𑄟𑄨",
    "002" to "𑄃𑄜𑄳𑄢𑄨𑄇",
    "003" to "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄃𑄟𑄬𑄢𑄨𑄇",
    "005" to "𑄘𑄨𑄉𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇",
    "009" to "𑄃𑄮𑄥𑄨𑄠𑄚𑄨𑄠",
    "011" to "𑄛𑄧𑄏𑄨𑄟𑄴 𑄃𑄜𑄳𑄢𑄨𑄇",
    "013" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄜𑄳𑄢𑄨𑄇",
    "014" to "𑄛𑄪𑄇𑄴𑄘𑄩 𑄃𑄜𑄳𑄢𑄨𑄇",
    "015" to "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄃𑄜𑄳𑄢𑄨𑄇",
    "017" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄜𑄳𑄢𑄨𑄇",
    "019" to "𑄃𑄟𑄬𑄢𑄨𑄇𑄥𑄴",
    "021" to "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄎𑄉𑄢𑄴 𑄃𑄟𑄬𑄢𑄨𑄇",
    "029" to "𑄇𑄳𑄠𑄢𑄝𑄨𑄠𑄚𑄴",
    "030" to "𑄛𑄪𑄉𑄬𑄘𑄩 𑄃𑄬𑄥𑄨𑄠",
    "034" to "𑄘𑄧𑄉𑄨𑄚𑄬 𑄃𑄬𑄥𑄨𑄠",
    "035" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄛𑄪𑄇𑄴 𑄃𑄬𑄥𑄨𑄠",
    "039" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴",
    "053" to "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄣𑄬𑄥𑄨𑄠",
    "054" to "𑄟𑄳𑄠𑄣𑄬𑄚𑄬𑄥𑄨𑄠",
    "057" to "𑄟𑄭𑄇𑄳𑄢𑄮𑄚𑄬𑄥𑄨𑄠 𑄎𑄉",
    "061" to "𑄛𑄧𑄣𑄨𑄚𑄬𑄥𑄨𑄠",
    "142" to "𑄃𑄬𑄥𑄨𑄠",
    "143" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄬𑄥𑄨𑄠",
    "145" to "𑄛𑄧𑄎𑄨𑄟𑄴 𑄃𑄬𑄥𑄨𑄠",
    "150" to "𑄄𑄃𑄪𑄢𑄮𑄛𑄴",
    "151" to "𑄛𑄪𑄉𑄬𑄘𑄨 𑄄𑄃𑄪𑄢𑄮𑄛𑄴",
    "154" to "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴",
    "155" to "𑄛𑄧𑄎𑄨𑄟𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴",
    "419" to "𑄣𑄳𑄠𑄑𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇",
    "AC" to "𑄃𑄳𑄠𑄥𑄴𑄥𑄬𑄚𑄴𑄥𑄧𑄚𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴",
    "AD" to "𑄃𑄚𑄴𑄓𑄮𑄢",
    "AE" to "𑄎𑄧𑄙 𑄃𑄢𑄧𑄝𑄴 𑄃𑄟𑄨𑄢𑄖𑄴",
    "AF" to "𑄃𑄛𑄴𑄉𑄚𑄨𑄌𑄴𑄖𑄚𑄴",
    "AG" to "𑄆𑄚𑄴𑄖𑄨𑄉𑄱 𑄃𑄮 𑄝𑄢𑄴𑄟𑄪𑄓",
    "AI" to "𑄄𑄳𑄠𑄋𑄴𑄉𑄪𑄃𑄨𑄣",
    "AL" to "𑄃𑄣𑄴𑄝𑄬𑄚𑄨𑄠",
    "AM" to "𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠",
    "AO" to "𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣",
    "AQ" to "𑄃𑄳𑄠𑄚𑄴𑄑𑄢𑄴𑄇𑄧𑄑𑄨𑄇",
    "AR" to "𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚",
    "AS" to "𑄃𑄟𑄬𑄢𑄨𑄇𑄚𑄴 𑄥𑄟𑄮𑄠",
    "AT" to "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠",
    "AU" to "𑄃𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠",
    "AW" to "𑄃𑄢𑄪𑄝",
    "AX" to "𑄃𑄣𑄚𑄴𑄓𑄧 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "AZ" to "𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴",
    "BA" to "𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄮 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚",
    "BB" to "𑄝𑄢𑄴𑄝𑄘𑄮𑄌𑄴",
    "BD" to "𑄝𑄁𑄣𑄘𑄬𑄌𑄴",
    "BE" to "𑄝𑄬𑄣𑄴𑄎𑄨𑄠𑄟𑄴",
    "BF" to "𑄝𑄪𑄢𑄴𑄇𑄨𑄚 𑄜𑄥𑄮",
    "BG" to "𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄨𑄠",
    "BH" to "𑄝𑄦𑄧𑄢𑄭𑄚𑄴",
    "BI" to "𑄝𑄪𑄢𑄪𑄚𑄴𑄘𑄨",
    "BJ" to "𑄝𑄬𑄚𑄨𑄚𑄴",
    "BL" to "𑄥𑄬𑄚𑄴𑄑𑄴 𑄝𑄢𑄴𑄗𑄬𑄣𑄨𑄟𑄨",
    "BM" to "𑄝𑄢𑄴𑄟𑄪𑄓",
    "BN" to "𑄝𑄳𑄢𑄪𑄚𑄬𑄭",
    "BO" to "𑄝𑄧𑄣𑄨𑄞𑄨𑄠",
    "BQ" to "𑄇𑄳𑄠𑄢𑄨𑄝𑄨𑄠𑄚𑄴 𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄧𑄥𑄴",
    "BR" to "𑄝𑄳𑄢𑄎𑄨𑄣𑄴",
    "BS" to "𑄝𑄦𑄟 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "BT" to "𑄞𑄪𑄑𑄚𑄴",
    "BV" to "𑄝𑄮𑄞𑄬𑄑𑄴 𑄞𑄨𑄘𑄳𑄠",
    "BW" to "𑄝𑄧𑄖𑄴𑄥𑄮𑄠𑄚",
    "BY" to "𑄝𑄬𑄣𑄢𑄪𑄌𑄴",
    "BZ" to "𑄝𑄬𑄣𑄨𑄎𑄴",
    "CA" to "𑄇𑄚𑄓",
    "CC" to "𑄇𑄮𑄇𑄮𑄌𑄴 (𑄇𑄨𑄣𑄨𑄁) 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "CD" to "𑄇𑄧𑄋𑄴𑄉𑄮-𑄚𑄨𑄇𑄴𑄥𑄥",
    "CF" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄜𑄳𑄢𑄨𑄇𑄢𑄴𑄛𑄳𑄢𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧",
    "CG" to "𑄇𑄧𑄋𑄴𑄉𑄮-𑄝𑄳𑄢𑄎𑄞𑄨𑄣𑄴",
    "CH" to "𑄥𑄭𑄪𑄎𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴",
    "CI" to "𑄃𑄭𑄞𑄧𑄢𑄨 𑄇𑄮𑄌𑄴𑄑𑄴",
    "CK" to "𑄇𑄪𑄇𑄪 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "CL" to "𑄌𑄨𑄣𑄨",
    "CM" to "𑄇𑄳𑄠𑄟𑄬𑄢𑄪𑄚𑄴",
    "CN" to "𑄌𑄩𑄚𑄴",
    "CO" to "𑄃𑄣𑄧𑄟𑄴𑄝𑄨𑄠",
    "CP" to "𑄇𑄳𑄣𑄨𑄛𑄢𑄴𑄑𑄧𑄚𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄳𑄓𑄴",
    "CR" to "𑄇𑄮𑄥𑄳𑄑𑄢𑄨𑄇",
    "CU" to "𑄇𑄨𑄃𑄪𑄝",
    "CV" to "𑄇𑄬𑄛𑄴𑄞𑄢𑄴𑄘𑄬",
    "CW" to "𑄇𑄨𑄃𑄪𑄢𑄥𑄃𑄮",
    "CX" to "𑄇𑄳𑄢𑄨𑄥𑄴𑄟𑄥𑄴 𑄞𑄨𑄘𑄳𑄠",
    "CY" to "𑄥𑄭𑄛𑄳𑄢𑄥𑄴",
    "CZ" to "𑄌𑄬𑄌𑄨𑄠",
    "DE" to "𑄎𑄢𑄴𑄟𑄚𑄨",
    "DG" to "𑄘𑄨𑄠𑄬𑄉𑄮 𑄉𑄢𑄴𑄥𑄨𑄠",
    "DJ" to "𑄎𑄨𑄝𑄪𑄖𑄨",
    "DK" to "𑄓𑄬𑄚𑄴𑄟𑄢𑄴𑄇𑄧",
    "DM" to "𑄓𑄮𑄟𑄨𑄚𑄨𑄇",
    "DO" to "𑄓𑄮𑄟𑄨𑄚𑄨𑄇𑄚𑄴 𑄛𑄳𑄢𑄧𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧",
    "DZ" to "𑄃𑄢𑄴𑄎𑄬𑄢𑄨𑄠",
    "EA" to "𑄇𑄪𑄃𑄪𑄑 𑄃𑄳𑄃 𑄟𑄬𑄣𑄨𑄣",
    "EC" to "𑄄𑄇𑄪𑄠𑄬𑄓𑄧𑄢𑄴",
    "EE" to "𑄆𑄌𑄴𑄖𑄮𑄚𑄨𑄠",
    "EG" to "𑄟𑄨𑄥𑄧𑄢𑄴",
    "EH" to "𑄛𑄧𑄎𑄨𑄟𑄴 𑄥𑄦𑄢",
    "ER" to "𑄄𑄢𑄨𑄖𑄳𑄢𑄨𑄠",
    "ES" to "𑄥𑄳𑄛𑄬𑄚𑄴",
    "ET" to "𑄃𑄨𑄜𑄨𑄃𑄮𑄛𑄨𑄠",
    "EU" to "𑄄𑄃𑄪𑄢𑄮𑄛𑄩𑄠𑄧 𑄄𑄃𑄪𑄚𑄨𑄠𑄧𑄚𑄴",
    "FI" to "𑄜𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴",
    "FJ" to "𑄜𑄨𑄎𑄨",
    "FK" to "𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "FM" to "𑄟𑄭𑄇𑄳𑄢𑄮𑄚𑄬𑄥𑄨𑄠",
    "FO" to "𑄜𑄳𑄠𑄢𑄧𑄃𑄮 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "FR" to "𑄜𑄳𑄢𑄚𑄴𑄥𑄴",
    "GA" to "𑄉𑄳𑄠𑄝𑄧𑄚𑄴",
    "GB" to "𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮",
    "GD" to "𑄉𑄳𑄢𑄬𑄚𑄓",
    "GE" to "𑄎𑄧𑄢𑄴𑄎𑄨𑄠",
    "GF" to "𑄜𑄧𑄢𑄥𑄩 𑄉𑄠𑄚",
    "GG" to "𑄉𑄳𑄢𑄚𑄴𑄏𑄨",
    "GH" to "𑄊𑄚",
    "GI" to "𑄎𑄨𑄝𑄳𑄢𑄣𑄴𑄑𑄢𑄴",
    "GL" to "𑄉𑄳𑄢𑄩𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴",
    "GM" to "𑄉𑄟𑄴𑄝𑄨𑄠",
    "GN" to "𑄉𑄨𑄚𑄨",
    "GP" to "𑄉𑄪𑄠𑄘𑄬𑄣𑄯𑄛𑄴",
    "GQ" to "𑄚𑄨𑄢𑄧𑄇𑄴𑄈𑄩𑄠𑄧 𑄉𑄨𑄚𑄨",
    "GR" to "𑄉𑄳𑄢𑄨𑄌𑄴",
    "GS" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄎𑄧𑄢𑄴𑄎𑄨𑄠 𑄃𑄮 𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄳𑄠𑄚𑄴𑄓𑄃𑄪𑄃𑄨𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "GT" to "𑄉𑄪𑄠𑄖𑄬𑄟𑄣",
    "GU" to "𑄉𑄪𑄠𑄟𑄴",
    "GW" to "𑄉𑄨𑄚𑄨-𑄝𑄨𑄥𑄃𑄪",
    "GY" to "𑄉𑄨𑄠𑄚",
    "HK" to "𑄦𑄧𑄁𑄇𑄧𑄁 𑄆𑄌𑄴𑄃𑄬𑄃𑄢𑄴 𑄌𑄩𑄚",
    "HM" to "𑄦𑄢𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠 𑄃𑄳𑄃 𑄟𑄳𑄠𑄇𑄴𑄓𑄮𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "HN" to "𑄦𑄪𑄚𑄴𑄓𑄪𑄢𑄥𑄴",
    "HR" to "𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠",
    "HT" to "𑄦𑄭𑄖𑄨",
    "HU" to "𑄦𑄧𑄋𑄴𑄉𑄬𑄢𑄨",
    "IC" to "𑄇𑄳𑄠𑄚𑄢𑄨 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "ID" to "𑄄𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠",
    "IE" to "𑄃𑄠𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴",
    "IL" to "𑄄𑄎𑄴𑄢𑄠𑄬𑄣𑄴",
    "IM" to "𑄃𑄭𑄣𑄴 𑄃𑄧𑄜𑄴 𑄟𑄳𑄠𑄚𑄴",
    "IN" to "𑄞𑄢𑄧𑄖𑄴",
    "IQ" to "𑄄𑄢𑄇𑄴",
    "IR" to "𑄄𑄢𑄚𑄴",
    "IS" to "𑄃𑄭𑄥𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴",
    "IT" to "𑄄𑄖𑄣𑄨",
    "JE" to "𑄎𑄢𑄴𑄥𑄨",
    "JM" to "𑄎𑄟𑄭𑄇",
    "JO" to "𑄎𑄧𑄢𑄴𑄓𑄧𑄚𑄴",
    "JP" to "𑄎𑄛𑄚𑄴",
    "KE" to "𑄇𑄬𑄚𑄨𑄠",
    "KG" to "𑄇𑄨𑄢𑄴𑄉𑄨𑄎𑄨𑄌𑄴𑄖𑄚𑄴",
    "KH" to "𑄇𑄧𑄟𑄴𑄝𑄮𑄓𑄨𑄠",
    "KI" to "𑄇𑄨𑄢𑄨𑄝𑄖𑄨",
    "KM" to "𑄇𑄧𑄟𑄮𑄢𑄮𑄌𑄴",
    "KN" to "𑄥𑄬𑄚𑄴𑄑𑄴 𑄇𑄨𑄑𑄴𑄥𑄴 𑄃𑄮 𑄚𑄬𑄞𑄨𑄌𑄴",
    "KP" to "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄇𑄮𑄢𑄨𑄠",
    "KR" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄮𑄢𑄨𑄠",
    "KW" to "𑄇𑄪𑄠𑄬𑄖𑄴",
    "KY" to "𑄇𑄬𑄟𑄳𑄠𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "KZ" to "𑄇𑄎𑄈𑄌𑄴𑄖𑄚𑄴",
    "LA" to "𑄣𑄃𑄮𑄌𑄴",
    "LB" to "𑄣𑄬𑄝𑄚𑄧𑄚𑄴",
    "LC" to "𑄥𑄬𑄚𑄴𑄑𑄴 𑄣𑄪𑄥𑄨𑄠",
    "LI" to "𑄣𑄨𑄌𑄬𑄚𑄴𑄥𑄳𑄑𑄬𑄃𑄨𑄚𑄴",
    "LK" to "𑄥𑄳𑄢𑄨𑄣𑄧𑄁𑄇",
    "LR" to "𑄃𑄭𑄝𑄬𑄢𑄨𑄠",
    "LS" to "𑄣𑄬𑄥𑄮𑄗𑄮",
    "LT" to "𑄣𑄨𑄗𑄪𑄠𑄚𑄨𑄠",
    "LU" to "𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄧",
    "LV" to "𑄣𑄖𑄴𑄞𑄨𑄠",
    "LY" to "𑄣𑄨𑄝𑄨𑄠",
    "MA" to "𑄟𑄮𑄢𑄧𑄇𑄴𑄇𑄮",
    "MC" to "𑄟𑄮𑄚𑄇𑄮",
    "MD" to "𑄟𑄮𑄣𑄴𑄘𑄞𑄨𑄠",
    "ME" to "𑄟𑄧𑄚𑄴𑄑𑄨𑄚𑄨𑄉𑄳𑄢𑄮",
    "MF" to "𑄥𑄬𑄚𑄴𑄑𑄴 𑄟𑄢𑄴𑄑𑄨𑄚𑄴",
    "MG" to "𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴",
    "MH" to "𑄟𑄢𑄴𑄥𑄣𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "MK" to "𑄟𑄳𑄠𑄥𑄓𑄮𑄚𑄨𑄠",
    "ML" to "𑄟𑄣𑄨",
    "MM" to "𑄟𑄠𑄚𑄴𑄟𑄢𑄴 (𑄝𑄢𑄴𑄟)",
    "MN" to "𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄠",
    "MO" to "𑄟𑄳𑄠𑄇𑄃𑄮 𑄆𑄌𑄴𑄃𑄬𑄃𑄢𑄴 𑄌𑄩𑄚",
    "MP" to "𑄅𑄪𑄖𑄴𑄖𑄮𑄉𑄎𑄢𑄴 𑄟𑄢𑄨𑄠𑄚 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "MQ" to "𑄟𑄢𑄴𑄑𑄨𑄚𑄨𑄇𑄴",
    "MR" to "𑄟𑄧𑄢𑄨𑄖𑄚𑄨𑄠",
    "MS" to "𑄟𑄧𑄚𑄴𑄑𑄴𑄥𑄬𑄢𑄑𑄴",
    "MT" to "𑄟𑄣𑄴𑄑",
    "MU" to "𑄟𑄧𑄢𑄨𑄥𑄥𑄴",
    "MV" to "𑄟𑄣𑄴𑄘𑄨𑄛𑄴",
    "MW" to "𑄟𑄣𑄃𑄪𑄃𑄨",
    "MX" to "𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄮",
    "MY" to "𑄟𑄣𑄴𑄠𑄬𑄥𑄨𑄠",
    "MZ" to "𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴",
    "NA" to "𑄚𑄟𑄨𑄝𑄨𑄠",
    "NC" to "𑄚𑄱 𑄇𑄳𑄠𑄣𑄬𑄓𑄮𑄚𑄨𑄠",
    "NE" to "𑄚𑄭𑄎𑄢𑄴",
    "NF" to "𑄚𑄨𑄢𑄴𑄜𑄮𑄇𑄴 𑄞𑄨𑄘𑄳𑄠",
    "NG" to "𑄚𑄭𑄎𑄬𑄢𑄨𑄠",
    "NI" to "𑄚𑄨𑄇𑄢𑄉𑄪𑄠",
    "NL" to "𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴𑄥𑄴",
    "NO" to "𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬",
    "NP" to "𑄚𑄬𑄛𑄣𑄴",
    "NR" to "𑄚𑄃𑄪𑄢𑄪",
    "NU" to "𑄚𑄨𑄃𑄪𑄠𑄬",
    "NZ" to "𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴",
    "OM" to "𑄃𑄮𑄟𑄚𑄴",
    "PA" to "𑄛𑄚𑄟",
    "PE" to "𑄛𑄬𑄢𑄪",
    "PF" to "𑄜𑄧𑄢𑄥𑄩 𑄛𑄧𑄣𑄨𑄚𑄬𑄥𑄨𑄠",
    "PG" to "𑄛𑄛𑄪𑄠 𑄚𑄨𑄃𑄪 𑄉𑄨𑄚𑄨",
    "PH" to "𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴",
    "PK" to "𑄛𑄇𑄨𑄌𑄴𑄖𑄚𑄴",
    "PL" to "𑄛𑄮𑄣𑄳𑄠𑄚𑄴𑄓𑄴",
    "PM" to "𑄥𑄬𑄚𑄴𑄑𑄴 𑄛𑄨𑄠𑄬𑄢𑄴 𑄃𑄮 𑄟𑄨𑄢𑄪𑄠𑄬𑄣𑄧𑄚𑄴",
    "PN" to "𑄛𑄨𑄇𑄴𑄇𑄬𑄠𑄢𑄴𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "PR" to "𑄛𑄪𑄠𑄬𑄢𑄴𑄖𑄮 𑄢𑄨𑄇𑄮",
    "PS" to "𑄜𑄨𑄣𑄨𑄌𑄴𑄖𑄨𑄚𑄴 𑄎𑄉𑄊𑄚𑄨",
    "PT" to "𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄣𑄴",
    "PW" to "𑄛𑄣𑄃𑄪",
    "PY" to "𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄬",
    "QA" to "𑄇𑄖𑄢𑄴",
    "QO" to "𑄃𑄅𑄪𑄑𑄣𑄭𑄚𑄨𑄁 𑄃𑄮𑄥𑄚𑄨𑄠",
    "RE" to "𑄢𑄨𑄃𑄨𑄃𑄪𑄚𑄨𑄠𑄧𑄚𑄴",
    "RO" to "𑄢𑄮𑄟𑄚𑄨𑄠",
    "RS" to "𑄥𑄢𑄴𑄝𑄨𑄠",
    "RU" to "𑄢𑄥𑄨𑄠",
    "RW" to "𑄢𑄪𑄠𑄚𑄴𑄓",
    "SA" to "𑄥𑄯𑄘𑄨 𑄃𑄢𑄧𑄝𑄴",
    "SB" to "𑄥𑄧𑄣𑄮𑄟𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "SC" to "𑄥𑄨𑄥𑄨𑄣𑄨",
    "SD" to "𑄥𑄪𑄘𑄚𑄴",
    "SE" to "𑄥𑄭𑄪𑄓𑄬𑄚𑄴",
    "SG" to "𑄥𑄨𑄋𑄴𑄉𑄛𑄪𑄢𑄴",
    "SH" to "𑄥𑄬𑄚𑄴𑄑𑄴 𑄦𑄬𑄣𑄬𑄚",
    "SI" to "𑄥𑄳𑄣𑄮𑄞𑄚𑄨𑄠",
    "SJ" to "𑄥𑄣𑄴𑄝𑄢𑄴𑄓𑄴 𑄃𑄮 𑄎𑄚𑄴 𑄟𑄬𑄠𑄬𑄚𑄴",
    "SK" to "𑄥𑄳𑄣𑄮𑄞𑄇𑄨𑄠",
    "SL" to "𑄥𑄨𑄠𑄬𑄢𑄣𑄨𑄃𑄮𑄚𑄴",
    "SM" to "𑄥𑄚𑄴 𑄟𑄢𑄨𑄚𑄮",
    "SN" to "𑄥𑄬𑄚𑄬𑄉𑄣𑄴",
    "SO" to "𑄥𑄮𑄟𑄣𑄨𑄠",
    "SR" to "𑄥𑄪𑄢𑄨𑄚𑄟𑄴",
    "SS" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄪𑄘𑄚𑄴",
    "ST" to "𑄥𑄃𑄮𑄑𑄟 𑄃𑄮 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄨",
    "SV" to "𑄆𑄣𑄴 𑄥𑄣𑄴𑄞𑄬𑄘𑄧𑄢𑄴",
    "SX" to "𑄥𑄨𑄚𑄴𑄑𑄴 𑄟𑄢𑄴𑄑𑄬𑄚𑄴",
    "SY" to "𑄥𑄨𑄢𑄨𑄠",
    "SZ" to "𑄥𑄮𑄠𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴",
    "TA" to "𑄑𑄳𑄢𑄌𑄴𑄑𑄚𑄴 𑄓 𑄇𑄪𑄚𑄴𑄦",
    "TC" to "𑄖𑄪𑄢𑄴𑄇𑄧𑄌𑄴 𑄃𑄮 𑄇𑄭𑄇𑄮𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "TD" to "𑄌𑄘𑄴",
    "TF" to "𑄜𑄢𑄥𑄩 𑄘𑄧𑄉𑄨𑄚𑄧 𑄎𑄉",
    "TG" to "𑄑𑄮𑄉𑄮",
    "TH" to "𑄗𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴",
    "TJ" to "𑄖𑄎𑄨𑄇𑄴𑄥𑄳𑄗𑄚𑄴",
    "TK" to "𑄑𑄮𑄇𑄬𑄣𑄃𑄪",
    "TL" to "𑄖𑄨𑄟𑄪𑄢𑄴-𑄣𑄬𑄌𑄴𑄖𑄬",
    "TM" to "𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄴",
    "TN" to "𑄖𑄨𑄃𑄪𑄚𑄨𑄥𑄨𑄠",
    "TO" to "𑄑𑄮𑄋𑄴𑄉",
    "TR" to "𑄖𑄪𑄢𑄧𑄌𑄴𑄇𑄧",
    "TT" to "𑄖𑄳𑄢𑄨𑄚𑄨𑄚𑄘𑄴 𑄃𑄮 𑄑𑄮𑄝𑄳𑄠𑄉𑄮",
    "TV" to "𑄑𑄪𑄞𑄣𑄪",
    "TW" to "𑄖𑄭𑄤𑄚𑄴",
    "TZ" to "𑄖𑄚𑄴𑄎𑄚𑄨𑄠",
    "UA" to "𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄬𑄚𑄴",
    "UG" to "𑄅𑄉𑄚𑄴𑄓",
    "UM" to "𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄦𑄭𑄇𑄪𑄢𑄬 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "UN" to "𑄎𑄘𑄨𑄥𑄧𑄁𑄊𑄧",
    "US" to "𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮",
    "UY" to "𑄅𑄪𑄢𑄪𑄉𑄪𑄠𑄬",
    "UZ" to "𑄅𑄪𑄎𑄴𑄝𑄬𑄇𑄨𑄌𑄴𑄖𑄚𑄴",
    "VA" to "𑄞𑄳𑄠𑄑𑄨𑄇𑄚𑄴 𑄥𑄨𑄑𑄨",
    "VC" to "𑄥𑄬𑄚𑄴𑄑𑄴 𑄞𑄨𑄚𑄴𑄥𑄬𑄚𑄴𑄑𑄴 𑄃𑄮 𑄘𑄳𑄠 𑄉𑄳𑄢𑄬𑄚𑄓𑄨𑄚𑄴𑄥𑄴",
    "VE" to "𑄞𑄬𑄚𑄬𑄎𑄪𑄠𑄬𑄣",
    "VG" to "𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄞𑄢𑄴𑄎𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "VI" to "𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄞𑄢𑄴𑄎𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠",
    "VN" to "𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄴",
    "VU" to "𑄞𑄚𑄪𑄠𑄑𑄪",
    "WF" to "𑄤𑄣𑄨𑄌𑄴 𑄃𑄮 𑄜𑄪𑄑𑄪𑄚",
    "WS" to "𑄥𑄟𑄮𑄠",
    "XK" to "𑄇𑄧𑄥𑄮𑄞𑄮",
    "YE" to "𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄴",
    "YT" to "𑄟𑄠𑄮𑄖𑄴𑄖𑄬",
    "ZA" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇",
    "ZM" to "𑄎𑄟𑄴𑄝𑄨𑄠",
    "ZW" to "𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬",
    "ZZ" to "𑄃𑄨𑄌𑄨𑄚𑄴 𑄎𑄉",
  ) }

  val ccp_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ce: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Дерригдуьненан",
    "002" to "Африка",
    "003" to "Къилбаседа Америка",
    "005" to "Къилба Америка",
    "009" to "Океани",
    "011" to "Малхбузен Африка",
    "013" to "Юккъера Америка",
    "014" to "Малхбален Африка",
    "015" to "Къилбаседа Африка",
    "017" to "Юккъера Африка",
    "018" to "Къилба Африка",
    "019" to "Къилбаседа а, къилба а Америка",
    "021" to "Къилбаседа Америка – АЦШ а, Канада а",
    "029" to "Карибаш",
    "030" to "Юккъера Ази",
    "034" to "Къилба Ази",
    "035" to "Къилба-малхбален Ази",
    "039" to "Къилба Европа",
    "053" to "Австралази",
    "054" to "Меланези",
    "057" to "Микронези",
    "061" to "Полинези",
    "142" to "Ази",
    "143" to "Юккъера Малхбале",
    "145" to "Юккъера а, Гергара а Малхбале",
    "150" to "Европа",
    "151" to "Малхбален Европа",
    "154" to "Къилбаседа Европа",
    "155" to "Малхбузен Европа",
    "419" to "Латинан Америка",
    "AC" to "Айъадаларан гӀайре",
    "AD" to "Андорра",
    "AE" to "Ӏарбийн Цхьанатоьхна Эмираташ",
    "AF" to "ОвхӀан мохк",
    "AG" to "Антигуа а, Барбуда а",
    "AI" to "Ангилья",
    "AL" to "Албани",
    "AM" to "Эрмалойчоь",
    "AO" to "Ангола",
    "AQ" to "Антарктида",
    "AR" to "Аргентина",
    "AS" to "Американ Самоа",
    "AT" to "Австри",
    "AU" to "Австрали",
    "AW" to "Аруба",
    "AX" to "Аландан гӀайренаш",
    "AZ" to "Азербайджан",
    "BA" to "Босни а, Герцеговина а",
    "BB" to "Барбадос",
    "BD" to "Бангладеш",
    "BE" to "Бельги",
    "BF" to "Буркина- Фасо",
    "BG" to "Болгари",
    "BH" to "Бахрейн",
    "BI" to "Бурунди",
    "BJ" to "Бенин",
    "BL" to "Сен-Бартельми",
    "BM" to "Бермудан гӀайренаш",
    "BN" to "Бруней-Даруссалам",
    "BO" to "Боливи",
    "BQ" to "Бонэйр, Синт-Эстатиус а, Саба а",
    "BR" to "Бразили",
    "BS" to "Багаман гӀайренаш",
    "BT" to "Бутан",
    "BV" to "Бувен гӀайре",
    "BW" to "Ботсвана",
    "BY" to "Белорусси",
    "BZ" to "Белиз",
    "CA" to "Канада",
    "CC" to "Кокосийн гӀайренаш",
    "CD" to "Демократин Республика Конго",
    "CF" to "Юккъерчу Африкин Республика",
    "CG" to "Конго - Браззавиль",
    "CH" to "Швейцари",
    "CI" to "Кот-Д’ивуар",
    "CK" to "Кукан гӀайренаш",
    "CL" to "Чили",
    "CM" to "Камерун",
    "CN" to "Цийчоь",
    "CO" to "Колумби",
    "CP" to "Клиппертон",
    "CR" to "Коста-Рика",
    "CU" to "Куба",
    "CV" to "Кабо-Верде",
    "CW" to "Кюрасао",
    "CX" to "ГӀайре ӏиса пайхӏамар вина де",
    "CY" to "Кипр",
    "CZ" to "Чехи",
    "DE" to "Германи",
    "DG" to "Диего-Гарси",
    "DJ" to "Джибути",
    "DK" to "Дани",
    "DM" to "Доминика",
    "DO" to "Доминикан Республика",
    "DZ" to "Алжир",
    "EA" to "Сеута а, Мелилья а",
    "EC" to "Эквадор",
    "EE" to "Эстони",
    "EG" to "Мисар",
    "EH" to "Малхбузен Саьхьара",
    "ER" to "Эритрей",
    "ES" to "Испани",
    "ET" to "Эфиопи",
    "EU" to "Евробарт",
    "EZ" to "еврозона",
    "FI" to "Финлянди",
    "FJ" to "Фиджи",
    "FK" to "Фолклендан гӀайренаш",
    "FM" to "Микронезин Федеративни штаташ",
    "FO" to "Фарерийн гӀайренаш",
    "FR" to "Франци",
    "GA" to "Габон",
    "GB" to "Йоккха Британи",
    "GD" to "Гренада",
    "GE" to "Гуьржийчоь",
    "GF" to "Французийн Гвиана",
    "GG" to "Гернси",
    "GH" to "Гана",
    "GI" to "Гибралтар",
    "GL" to "Гренланди",
    "GM" to "Гамби",
    "GN" to "Гвиней",
    "GP" to "Гваделупа",
    "GQ" to "Экваторан Гвиней",
    "GR" to "Греци",
    "GS" to "Къилба Джорджи а, Къилба Гавайн гӀайренаш а",
    "GT" to "Гватемала",
    "GU" to "Гуам",
    "GW" to "Гвиней-Бисау",
    "GY" to "Гайана",
    "HK" to "Гонконг (ша-къаьстина кӀошт)",
    "HM" to "Херд гӀайре а, Макдональд гӀайренаш а",
    "HN" to "Гондурас",
    "HR" to "Хорвати",
    "HT" to "Гаити",
    "HU" to "Венгри",
    "IC" to "Канаран гӀайренаш",
    "ID" to "Индонези",
    "IE" to "Ирланди",
    "IL" to "Израиль",
    "IM" to "Мэн гӀайре",
    "IN" to "ХӀинди",
    "IQ" to "Ӏиракъ",
    "IR" to "ГӀажарийчоь",
    "IS" to "Исланди",
    "IT" to "Итали",
    "JE" to "Джерси",
    "JM" to "Ямайка",
    "JO" to "Урдан",
    "JP" to "Япони",
    "KE" to "Кени",
    "KG" to "Киргизи",
    "KH" to "Камбоджа",
    "KI" to "Кирибати",
    "KM" to "Комораш",
    "KN" to "Сент-Китс а, Невис а",
    "KP" to "Къилбаседа Корей",
    "KR" to "Къилба Корей",
    "KW" to "Кувейт",
    "KY" to "Кайман гӀайренаш",
    "KZ" to "Кхазакхстан",
    "LA" to "Лаос",
    "LB" to "Ливан",
    "LC" to "Сент-Люси",
    "LI" to "Лихтенштейн",
    "LK" to "Шри-Ланка",
    "LR" to "Либери",
    "LS" to "Лесото",
    "LT" to "Литва",
    "LU" to "Люксембург",
    "LV" to "Латви",
    "LY" to "Ливи",
    "MA" to "Марокко",
    "MC" to "Монако",
    "MD" to "Молдави",
    "ME" to "Ӏаьржаламанчоь",
    "MF" to "Сен-Мартен",
    "MG" to "Мадагаскар",
    "MH" to "Маршаллан гӀайренаш",
    "ML" to "Мали",
    "MM" to "Мьянма (Бирма)",
    "MN" to "Монголи",
    "MO" to "Макао (ша-къаьстина кӀошт)",
    "MP" to "Къилбаседа Марианан гӀайренаш",
    "MQ" to "Мартиника",
    "MR" to "Мавритани",
    "MS" to "Монтсеррат",
    "MT" to "Мальта",
    "MU" to "Маврики",
    "MV" to "Мальдиваш",
    "MW" to "Малави",
    "MX" to "Мексика",
    "MY" to "Малайзи",
    "MZ" to "Мозамбик",
    "NA" to "Намиби",
    "NC" to "Керла Каледони",
    "NE" to "Нигер",
    "NF" to "Норфолк гӀайре",
    "NG" to "Нигери",
    "NI" to "Никарагуа",
    "NL" to "Нидерландаш",
    "NO" to "Норвеги",
    "NP" to "Непал",
    "NR" to "Науру",
    "NU" to "Ниуэ",
    "NZ" to "Керла Зеланди",
    "OM" to "Ӏоман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PF" to "Французийн Полинези",
    "PG" to "Папуа — Керла Гвиней",
    "PH" to "Филиппинаш",
    "PK" to "Пакистан",
    "PL" to "Польша",
    "PM" to "Сен-Пьер а, Микелон а",
    "PN" to "Питкэрн гӀайренаш",
    "PR" to "Пуэрто-Рико",
    "PS" to "ПалестӀинан латтанаш",
    "PT" to "Португали",
    "PW" to "Палау",
    "PY" to "Парагвай",
    "QA" to "Катар",
    "QO" to "Арахьара Океани",
    "RE" to "Реюньон",
    "RO" to "Румыни",
    "RS" to "Серби",
    "RU" to "Росси",
    "RW" to "Руанда",
    "SA" to "СаӀудийн Ӏаьрбийчоь",
    "SB" to "Соломонан гӀайренаш",
    "SC" to "Сейшелан гӀайренаш",
    "SD" to "Судан",
    "SE" to "Швеци",
    "SG" to "Сингапур",
    "SH" to "Сийлахьчу Еленин гӀайре",
    "SI" to "Словени",
    "SJ" to "Шпицберген а, Ян-Майен а",
    "SK" to "Словаки",
    "SL" to "Сьерра- Леоне",
    "SM" to "Сан-Марино",
    "SN" to "Сенегал",
    "SO" to "Сомали",
    "SR" to "Суринам",
    "SS" to "Къилба Судан",
    "ST" to "Сан-Томе а, Принсипи а",
    "SV" to "Сальвадор",
    "SX" to "Синт-Мартен",
    "SY" to "Шема",
    "SZ" to "Свазиленд",
    "TA" to "Тристан-да- Кунья",
    "TC" to "Тёркс а, Кайкос а гӀайренаш",
    "TD" to "Чад",
    "TF" to "Французийн къилба латтанаш",
    "TG" to "Того",
    "TH" to "Таиланд",
    "TJ" to "Таджикистан",
    "TK" to "Токелау",
    "TL" to "Малхбален Тимор",
    "TM" to "Туркмени",
    "TN" to "Тунис",
    "TO" to "Тонга",
    "TR" to "Туркойчоь",
    "TT" to "Тринидад а, Тобаго а",
    "TV" to "Тувалу",
    "TW" to "Тайвань",
    "TZ" to "Танзани",
    "UA" to "Украина",
    "UG" to "Уганда",
    "UM" to "АЦШн арахьара кегийн гӀайренаш",
    "UN" to "Вовшахкхетта Къаьмнийн Организаци",
    "US" to "Цхьанатоьхна Штаташ",
    "UY" to "Уругвай",
    "UZ" to "Узбекистан",
    "VA" to "Ватикан",
    "VC" to "Сент-Винсент а, Гренадинаш а",
    "VE" to "Венесуэла",
    "VG" to "Виргинийн гӀайренаш (Британи)",
    "VI" to "Виргинийн гӀайренаш (АЦШ)",
    "VN" to "Вьетнам",
    "VU" to "Вануату",
    "WF" to "Уоллис а, Футуна а",
    "WS" to "Самоа",
    "XK" to "Косово",
    "YE" to "Йемен",
    "YT" to "Майотта",
    "ZA" to "Къилба-Африкин Республика",
    "ZM" to "Замби",
    "ZW" to "Зимбабве",
    "ZZ" to "Йоьвзуш йоцу регион",
  ) }

  val ceb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "kalibutan",
    "002" to "Africa",
    "003" to "North America",
    "005" to "South America",
    "009" to "Oceania",
    "011" to "Western Africa",
    "013" to "Central America",
    "014" to "Eastern Africa",
    "015" to "Northern Africa",
    "017" to "Middle Africa",
    "018" to "Southern Africa",
    "019" to "Americas",
    "021" to "Northern America",
    "029" to "Caribbean",
    "030" to "Eastern Asia",
    "034" to "Southern Asia",
    "035" to "Southeast Asia",
    "039" to "Southern Europe",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Micronesian Region",
    "061" to "Polynesia",
    "142" to "Asia",
    "143" to "Central Asia",
    "145" to "Western Asia",
    "150" to "Europe",
    "151" to "Eastern Europe",
    "154" to "Northern Europe",
    "155" to "Western Europe",
    "202" to "Sub-Saharan Africa",
    "419" to "Latin America",
    "AC" to "Ascension Island",
    "AD" to "Andorra",
    "AE" to "United Arab Emirates",
    "AF" to "Afghanistan",
    "AG" to "Antigua & Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarctica",
    "AR" to "Argentina",
    "AS" to "American Samoa",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Aland Islands",
    "AZ" to "Azerbaijan",
    "BA" to "Bosnia & Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgium",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthelemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Caribbean Netherlands",
    "BR" to "Brazil",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Bouvet Island",
    "BW" to "Botswana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Cocos (Keeling) Islands",
    "CD" to "Congo - Kinshasa",
    "CF" to "Central African Republic",
    "CG" to "Congo - Brazzaville",
    "CH" to "Switzerland",
    "CI" to "Cote d’Ivoire",
    "CK" to "Cook Islands",
    "CL" to "Chile",
    "CM" to "Cameroon",
    "CN" to "China",
    "CO" to "Colombia",
    "CP" to "Clipperton Island",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cape Verde",
    "CW" to "Curacao",
    "CX" to "Christmas Island",
    "CY" to "Cyprus",
    "CZ" to "Czechia",
    "DE" to "Germany",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Denmark",
    "DM" to "Dominica",
    "DO" to "Dominican Republic",
    "DZ" to "Algeria",
    "EA" to "Ceuta & Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egypt",
    "EH" to "Western Sahara",
    "ER" to "Eritrea",
    "ES" to "Espanya",
    "ET" to "Ethiopia",
    "EU" to "European Union",
    "EZ" to "Eurozone",
    "FI" to "Finland",
    "FJ" to "Fiji",
    "FK" to "Falkland Islands",
    "FM" to "Micronesia",
    "FO" to "Faroe Islands",
    "FR" to "France",
    "GA" to "Gabon",
    "GB" to "United Kingdom",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "French Guiana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Greenland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Equatorial Guinea",
    "GR" to "Greece",
    "GS" to "South Georgia & South Sandwich Islands",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong SAR China",
    "HM" to "Heard & McDonald Islands",
    "HN" to "Honduras",
    "HR" to "Croatia",
    "HT" to "Haiti",
    "HU" to "Hungary",
    "IC" to "Canary Islands",
    "ID" to "Indonesia",
    "IE" to "Ireland",
    "IL" to "Israel",
    "IM" to "Isle of Man",
    "IN" to "India",
    "IO" to "Teritoryo sa British Indian Ocean",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Iceland",
    "IT" to "Italya",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenya",
    "KG" to "Kyrgyzstan",
    "KH" to "Cambodia",
    "KI" to "Kiribati",
    "KM" to "Comoros",
    "KN" to "St. Kitts & Nevis",
    "KP" to "North Korea",
    "KR" to "South Korea",
    "KW" to "Kuwait",
    "KY" to "Cayman Islands",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Lebanon",
    "LC" to "St. Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lithuania",
    "LU" to "Luxembourg",
    "LV" to "Latvia",
    "LY" to "Libya",
    "MA" to "Morocco",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "St. Martin",
    "MG" to "Madagascar",
    "MH" to "Marshall Islands",
    "MK" to "North Macedonia",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Macao SAR China",
    "MP" to "Northern Mariana Islands",
    "MQ" to "Martinique",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldives",
    "MW" to "Malawi",
    "MX" to "Mexico",
    "MY" to "Malaysia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "New Caledonia",
    "NE" to "Niger",
    "NF" to "Norfolk Island",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Netherlands",
    "NO" to "Norway",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "New Zealand",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "French Polynesia",
    "PG" to "Papua New Guinea",
    "PH" to "Pilipinas",
    "PK" to "Pakistan",
    "PL" to "Poland",
    "PM" to "St. Pierre & Miquelon",
    "PN" to "Pitcairn Islands",
    "PR" to "Puerto Rico",
    "PS" to "Palestinian Territories",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Outlying Oceania",
    "RE" to "Reunion",
    "RO" to "Romania",
    "RS" to "Serbia",
    "RU" to "Russia",
    "RW" to "Rwanda",
    "SA" to "Saudi Arabia",
    "SB" to "Solomon Islands",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Sweden",
    "SG" to "Singapore",
    "SH" to "St. Helena",
    "SI" to "Slovenia",
    "SJ" to "Svalbard & Jan Mayen",
    "SK" to "Slovakia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "South Sudan",
    "ST" to "Sao Tome & Principe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks & Caicos Islands",
    "TD" to "Chad",
    "TF" to "French Southern Territories",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tajikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turkiye",
    "TT" to "Trinidad & Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraine",
    "UG" to "Uganda",
    "UM" to "U.S. Outlying Islands",
    "UN" to "Hiniusang Kanasoran",
    "US" to "Estados Unidos",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Vatican City",
    "VC" to "St. Vincent & Grenadines",
    "VE" to "Venezuela",
    "VG" to "British Virgin Islands",
    "VI" to "U.S. Virgin Islands",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis & Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo-Accents",
    "XB" to "Pseudo-Bidi",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "South Africa",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Wala Mailhing Rehiyon",
  ) }

  val cgg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Amahanga ga Buharabu ageeteereine",
    "AF" to "Afuganistani",
    "AG" to "Angiguwa na Babuda",
    "AI" to "Angwira",
    "AL" to "Arubania",
    "AM" to "Arimeniya",
    "AO" to "Angora",
    "AR" to "Arigentina",
    "AS" to "Samowa ya Ameerika",
    "AT" to "Osituria",
    "AU" to "Ositureeriya",
    "AW" to "Aruba",
    "AZ" to "Azabagyani",
    "BA" to "Boziniya na Hezegovina",
    "BB" to "Babadosi",
    "BD" to "Bangaradeshi",
    "BE" to "Bubirigi",
    "BF" to "Bokina Faso",
    "BG" to "Burugariya",
    "BH" to "Bahareni",
    "BI" to "Burundi",
    "BJ" to "Benini",
    "BM" to "Berimuda",
    "BN" to "Burunei",
    "BO" to "Boriiviya",
    "BR" to "Buraziiri",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botswana",
    "BY" to "Bararusi",
    "BZ" to "Berize",
    "CA" to "Kanada",
    "CD" to "Demokoratika Ripaaburika ya Kongo",
    "CF" to "Eihanga rya Rwagati ya Afirika",
    "CG" to "Kongo",
    "CH" to "Swisi",
    "CI" to "Aivore Kositi",
    "CK" to "Ebizinga bya Kuuku",
    "CL" to "Chile",
    "CM" to "Kameruuni",
    "CN" to "China",
    "CO" to "Korombiya",
    "CR" to "Kositarika",
    "CU" to "Cuba",
    "CV" to "Ebizinga bya Kepuvade",
    "CY" to "Saipurasi",
    "CZ" to "Ripaaburika ya Zeeki",
    "DE" to "Bugirimaani",
    "DJ" to "Gyibuti",
    "DK" to "Deenimaaka",
    "DM" to "Dominika",
    "DO" to "Ripaaburika ya Dominica",
    "DZ" to "Arigyeriya",
    "EC" to "Ikweda",
    "EE" to "Esitoniya",
    "EG" to "Misiri",
    "ER" to "Eriteriya",
    "ES" to "Sipeyini",
    "ET" to "Ethiyopiya",
    "FI" to "Bufini",
    "FJ" to "Figyi",
    "FK" to "Ebizinga bya Faakilanda",
    "FM" to "Mikironesiya",
    "FR" to "Bufaransa",
    "GA" to "Gabooni",
    "GB" to "Bungyereza",
    "GD" to "Gurenada",
    "GE" to "Gyogiya",
    "GF" to "Guyana ya Bufaransa",
    "GH" to "Gana",
    "GI" to "Giburaata",
    "GL" to "Guriinirandi",
    "GM" to "Gambiya",
    "GN" to "Gine",
    "GP" to "Gwaderupe",
    "GQ" to "Guni",
    "GR" to "Guriisi",
    "GT" to "Gwatemara",
    "GU" to "Gwamu",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Hondurasi",
    "HR" to "Korasiya",
    "HT" to "Haiti",
    "HU" to "Hangare",
    "ID" to "Indoneeziya",
    "IE" to "Irerandi",
    "IL" to "Isirairi",
    "IN" to "Indiya",
    "IQ" to "Iraaka",
    "IR" to "Iraani",
    "IS" to "Aisilandi",
    "IT" to "Itare",
    "JM" to "Gyamaika",
    "JO" to "Yorudaani",
    "JP" to "Gyapaani",
    "KE" to "Kenya",
    "KG" to "Kirigizistani",
    "KH" to "Kambodiya",
    "KI" to "Kiribati",
    "KM" to "Koromo",
    "KN" to "Senti Kittis na Nevisi",
    "KP" to "Koreya Amatemba",
    "KR" to "Koreya Amashuuma",
    "KW" to "Kuweiti",
    "KY" to "Ebizinga bya Kayimani",
    "KZ" to "Kazakisitani",
    "LA" to "Layosi",
    "LB" to "Lebanoni",
    "LC" to "Senti Rusiya",
    "LI" to "Lishenteni",
    "LK" to "Siriranka",
    "LR" to "Liberiya",
    "LS" to "Lesotho",
    "LT" to "Lithuania",
    "LU" to "Lakizembaaga",
    "LV" to "Latviya",
    "LY" to "Libya",
    "MA" to "Morocco",
    "MC" to "Monaco",
    "MD" to "Moridova",
    "MG" to "Madagasika",
    "MH" to "Ebizinga bya Marshaa",
    "ML" to "Mari",
    "MM" to "Myanamar",
    "MN" to "Mongoria",
    "MP" to "Ebizinga by’amatemba ga Mariana",
    "MQ" to "Martinique",
    "MR" to "Mauriteeniya",
    "MS" to "Montserrati",
    "MT" to "Marita",
    "MU" to "Maurishiasi",
    "MV" to "Maridives",
    "MW" to "Marawi",
    "MX" to "Mexico",
    "MY" to "marayizia",
    "MZ" to "Mozambique",
    "NA" to "Namibiya",
    "NC" to "Niukaredonia",
    "NE" to "Naigya",
    "NF" to "Ekizinga Norifoko",
    "NG" to "Naigyeriya",
    "NI" to "Nikaragwa",
    "NL" to "Hoorandi",
    "NO" to "Noorwe",
    "NP" to "Nepo",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Niuzirandi",
    "OM" to "Omaani",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia ya Bufaransa",
    "PG" to "Papua",
    "PH" to "Firipino",
    "PK" to "Pakisitaani",
    "PL" to "Poorandi",
    "PM" to "Senti Piyerre na Mikweron",
    "PN" to "Pitkaini",
    "PR" to "Pwetoriko",
    "PT" to "Pocugo",
    "PW" to "Palaawu",
    "PY" to "Paragwai",
    "QA" to "Kata",
    "RE" to "Riyuniyoni",
    "RO" to "Romaniya",
    "RU" to "Rrasha",
    "RW" to "Rwanda",
    "SA" to "Saudi Areebiya",
    "SB" to "Ebizinga bya Surimaani",
    "SC" to "Shesheresi",
    "SD" to "Sudani",
    "SE" to "Swideni",
    "SG" to "Singapo",
    "SH" to "Senti Herena",
    "SI" to "Sirovaaniya",
    "SK" to "Sirovaakiya",
    "SL" to "Sirra Riyooni",
    "SM" to "Samarino",
    "SN" to "Senego",
    "SO" to "Somaariya",
    "SR" to "Surinaamu",
    "ST" to "Sawo Tome na Purinsipo",
    "SV" to "Eri Salivado",
    "SY" to "Siriya",
    "SZ" to "Swazirandi",
    "TC" to "Ebizinga bya Buturuki na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tairandi",
    "TJ" to "Tajikisitani",
    "TK" to "Tokerawu",
    "TL" to "Burugweizooba bwa Timori",
    "TM" to "Turukimenisitani",
    "TN" to "Tunizia",
    "TO" to "Tonga",
    "TR" to "Buturuki /Take",
    "TT" to "Turinidad na Tobago",
    "TV" to "Tuvaru",
    "TW" to "Tayiwaani",
    "TZ" to "Tanzania",
    "UA" to "Ukureini",
    "UG" to "Uganda",
    "US" to "Amerika",
    "UY" to "Urugwai",
    "UZ" to "Uzibekisitani",
    "VA" to "Vatikani",
    "VC" to "Senti Vinsent na Gurenadini",
    "VE" to "Venezuwera",
    "VG" to "Ebizinga bya Virigini ebya Bungyereza",
    "VI" to "Ebizinga bya Virigini ebya Amerika",
    "VN" to "Viyetinaamu",
    "VU" to "Vanuatu",
    "WF" to "Warris na Futuna",
    "WS" to "Samowa",
    "YE" to "Yemeni",
    "YT" to "Mayote",
    "ZA" to "Sausi Afirika",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
  ) }

  val cho: ImmutableMap<String, String> by lazy { immutableMapOf(
    "US" to "United States",
  ) }

  val chr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "ᎡᎶᎯ",
    "002" to "ᎬᎿᎨᏍᏛ",
    "003" to "ᏧᏴᏢ ᎠᎹᏰᏟ",
    "005" to "ᏧᎦᏃᏮ ᎠᎺᎵᎦ",
    "009" to "ᎣᏏᏰᏂᎠ",
    "011" to "ᏭᏕᎵᎬ ᏗᏜ ᎬᎿᎨᏍᏛ",
    "013" to "ᎠᏰᏟ ᎠᎹᏰᏟ",
    "014" to "ᏗᎧᎸᎬ ᏗᏜ ᎬᎿᎨᏍᏛ",
    "015" to "ᏧᏴᏢ ᏗᏜ ᎬᎿᎨᏍᏛ",
    "017" to "ᎠᏰᏟ ᎬᎿᎨᏍᏛ",
    "018" to "ᏧᎦᎾᏮ ᏗᏜ ᎬᎿᎨᏍᏛ",
    "019" to "ᎠᎺᎵᎦᎢ",
    "021" to "ᏧᏴᏢ ᏗᏜ ᎠᎹᏰᏟ",
    "029" to "ᎨᏆᏙᏯ",
    "030" to "ᏗᎧᎸᎬ ᏗᏜ ᏓᎶᏂᎨᏍᏛ",
    "034" to "ᏧᎦᎾᏮ ᏗᏜ ᏓᎶᏂᎨᏍᏛ",
    "035" to "ᏧᎦᎾᏮ ᏗᎧᎸᎬ ᏓᎶᏂᎨᏍᏛ",
    "039" to "ᏧᎦᎾᏮ ᏗᏜ ᏳᎳᏛ",
    "053" to "ᎠᏍᏔᎴᏏᎠ",
    "054" to "ᎺᎳᏁᏏᎠ",
    "057" to "ᎠᏰᏟ ᏧᎾᎵᎪᎯ ᎾᎿ ᎹᎢᏉᏂᏏᏯ ᎢᎬᎾᏕᎾ",
    "061" to "ᏆᎵᏂᏏᎠ",
    "142" to "ᏓᎶᎾᎨᏍᏛ",
    "143" to "ᎠᏰᏟ ᏓᎶᏂᎨᏍᏛ",
    "145" to "ᏭᏕᎵᎬ ᏗᏜ ᏓᎶᏂᎨᏍᏛ",
    "150" to "ᏳᎳᏛ",
    "151" to "ᏗᎧᎸᎬ ᏗᏜ ᏳᎳᏛ",
    "154" to "ᏧᏴᏢ ᏗᏜ ᏳᎳᏛ",
    "155" to "ᏭᏕᎵᎬ ᏗᏜ ᏳᎳᏛ",
    "202" to "ᎭᏫᏂ-ᏌᎭᏩ ᎬᎿᎨᏍᏛ",
    "419" to "ᎳᏘᏂ ᎠᎹᏰᏟ",
    "AC" to "ᎤᎵᏌᎳᏓᏅ ᎤᎦᏚᏛᎢ",
    "AD" to "ᎠᏂᏙᎳ",
    "AE" to "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎡᎳᏈ ᎢᎹᎵᏘᏏ",
    "AF" to "ᎠᏫᎨᏂᏍᏖᏂ",
    "AG" to "ᎤᏪᏘ & ᏆᏊᏓ",
    "AI" to "ᎠᏂᎩᎳ",
    "AL" to "ᎠᎵᏇᏂᏯ",
    "AM" to "ᎠᎵᎻᏂᎠ",
    "AO" to "ᎠᏂᎪᎳ",
    "AQ" to "ᏧᏁᏍᏓᎸ",
    "AR" to "ᎠᏥᏂᏘᏂᎠ",
    "AS" to "ᎠᎺᎵᎧ ᏌᎼᎠ",
    "AT" to "ᎠᏍᏟᏯ",
    "AU" to "ᎡᎳᏗᏜ",
    "AW" to "ᎠᎷᏆ",
    "AX" to "ᎣᎴᏅᏓ ᏚᎦᏚᏛᎢ",
    "AZ" to "ᎠᏎᏆᏣᏂ",
    "BA" to "ᏉᏏᏂᎠ & ᎲᏤᎪᏫᎾ",
    "BB" to "ᏆᏇᏙᏍ",
    "BD" to "ᏆᏂᎦᎵᏕᏍ",
    "BE" to "ᏇᎵᏥᎥᎻ",
    "BF" to "ᏋᎩᎾ ᏩᏐ",
    "BG" to "ᏊᎵᎨᎵᎠ",
    "BH" to "ᏆᎭᎴᎢᏂ",
    "BI" to "ᏋᎷᏂᏗ",
    "BJ" to "ᏆᏂᎢᏂ",
    "BL" to "ᎤᏓᏅᏘ ᏆᏕᎳᎻ",
    "BM" to "ᏆᏊᏓ",
    "BN" to "ᏊᎾᎢ",
    "BO" to "ᏉᎵᏫᎠ",
    "BQ" to "ᎧᎵᏈᎢᏂᎯ ᎾᏍᎩᏁᏛᎳᏂ",
    "BR" to "ᏆᏏᎵ",
    "BS" to "ᎾᏍᎩ ᏆᎭᎹᏍ",
    "BT" to "ᏊᏔᏂ",
    "BV" to "ᏊᏪ ᎤᎦᏚᏛᎢ",
    "BW" to "ᏆᏣᏩᎾ",
    "BY" to "ᏇᎳᎷᏍ",
    "BZ" to "ᏇᎵᏍ",
    "CA" to "ᎨᎾᏓ",
    "CC" to "ᎪᎪᏍ (ᎩᎵᏂ) ᏚᎦᏚᏛᎢ",
    "CD" to "ᎧᏂᎪ - ᎨᏂᏝᏌ",
    "CF" to "ᎬᎿᎨᏍᏛ ᎠᏰᏟ ᏍᎦᏚᎩ",
    "CG" to "ᎧᏂᎪ - ᏆᏌᏩᎵ",
    "CH" to "ᏍᏫᏍ",
    "CI" to "ᎢᏬᎵ ᎾᎿ ᎠᎹᏳᎶᏗ",
    "CK" to "ᎠᏓᏍᏓᏴᎲᏍᎩ ᏚᎦᏚᏛᎢ",
    "CL" to "ᏥᎵ",
    "CM" to "ᎧᎹᎷᏂ",
    "CN" to "ᏓᎶᏂᎨᏍᏛ",
    "CO" to "ᎪᎸᎻᏈᎢᎠ",
    "CP" to "ᎦᏂᏴᏔᏅᎣᏓᎸ ᎤᎦᏚᏛᎢ",
    "CR" to "ᎪᏍᏓ ᎵᎧ",
    "CU" to "ᎫᏆ",
    "CV" to "ᎢᎬᎾᏕᎾ ᎢᏤᏳᏍᏗ",
    "CW" to "ᎫᎳᎨᎣ",
    "CX" to "ᏓᏂᏍᏓᏲᎯᎲ ᎤᎦᏚᏛᎢ",
    "CY" to "ᏌᎢᏆᏍ",
    "CZ" to "ᏤᎩᎠ",
    "DE" to "ᎠᏂᏛᏥ",
    "DG" to "ᏗᏰᎪ ᎦᏏᏯ",
    "DJ" to "ᏥᏊᏗ",
    "DK" to "ᏗᏂᎹᎦ",
    "DM" to "ᏙᎻᏂᎧ",
    "DO" to "ᏙᎻᏂᎧᏂ ᏍᎦᏚᎩ",
    "DZ" to "ᎠᎵᏥᎵᏯ",
    "EA" to "ᏑᏔ ᎠᎴ ᎺᎵᏯ",
    "EC" to "ᎡᏆᏙᎵ",
    "EE" to "ᎡᏍᏙᏂᏯ",
    "EG" to "ᎢᏥᏈᎢ",
    "EH" to "ᏭᏕᎵᎬ ᏗᏜ ᏌᎮᎳ",
    "ER" to "ᎡᎵᏟᏯ",
    "ES" to "ᎠᏂᏍᏆᏂᏱ",
    "ET" to "ᎢᏗᎣᏈᎠ",
    "EU" to "ᏳᎳᏛ ᎠᏂᎤᎾᏓᏡᎬ",
    "EZ" to "ᏳᎶᎠᏍᏓᏅᏅ",
    "FI" to "ᏫᏂᎦᏙᎯ",
    "FJ" to "ᏫᏥ",
    "FK" to "ᏩᎩ ᏚᎦᏚᏛᎢ",
    "FM" to "ᎹᎢᏉᏂᏏᏯ",
    "FO" to "ᏪᎶ ᏚᎦᏚᏛᎢ",
    "FR" to "ᎦᎸᏥᏱ",
    "GA" to "ᎦᏉᏂ",
    "GB" to "ᎩᎵᏏᏲ",
    "GD" to "ᏋᎾᏓ",
    "GE" to "ᏣᎠᏥᎢ",
    "GF" to "ᎠᏂᎦᎸᏥ ᎩᎠ",
    "GG" to "ᎬᏂᏏ",
    "GH" to "ᎦᎠᎾ",
    "GI" to "ᏥᏆᎵᏓ",
    "GL" to "ᎢᏤᏍᏛᏱ",
    "GM" to "ᎦᎹᏈᎢᎠ",
    "GN" to "ᎩᎢᏂ",
    "GP" to "ᏩᏓᎷᏇ",
    "GQ" to "ᎡᏆᏙᎵᎠᎵ ᎩᎢᏂ",
    "GR" to "ᎪᎢᎯ",
    "GS" to "ᏧᎦᏃᏮ ᏣᎠᏥᎢ ᎠᎴ ᎾᏍᎩ ᏧᎦᏃᏮ ᎠᏍᏛᎭᏟ ᏚᎦᏚᏛᎢ",
    "GT" to "ᏩᏔᎹᎳ",
    "GU" to "ᏆᎻ",
    "GW" to "ᎩᎢᏂ-ᏈᏌᎤᏫ",
    "GY" to "ᎦᏯᎾ",
    "HK" to "ᎰᏂᎩ ᎪᏂᎩ ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ ᏓᎶᏂᎨᏍᏛ",
    "HM" to "ᎲᏗ ᎤᎦᏚᏛᎢ ᎠᎴ ᎺᎩᏓᎾᎵᏗ ᏚᎦᏚᏛᎢ",
    "HN" to "ᎭᏂᏚᎳᏍ",
    "HR" to "ᎧᎶᎡᏏᎠ",
    "HT" to "ᎮᎢᏘ",
    "HU" to "ᎲᏂᎦᎵ",
    "IC" to "ᏥᏍᏆ ᏚᎦᏚᏛᎢ",
    "ID" to "ᎢᏂᏙᏂᏍᏯ",
    "IE" to "ᎠᏲᎳᏂ",
    "IL" to "ᎢᏏᎵᏱ",
    "IM" to "ᎤᏍᏗ ᎤᎦᏚᏛᎢ ᎾᎿ ᎠᏍᎦᏯ",
    "IN" to "ᎢᏅᏗᎾ",
    "IO" to "ᏈᏗᏏ ᏴᏫᏯ ᎠᎺᏉ ᎢᎬᎾᏕᏅ",
    "IQ" to "ᎢᎳᎩ",
    "IR" to "ᎢᎴᏂ",
    "IS" to "ᏧᏁᏍᏓᎸᎯ",
    "IT" to "ᎢᏔᎵ",
    "JE" to "ᏨᎵᏏ",
    "JM" to "ᏣᎺᎢᎧ",
    "JO" to "ᏦᏓᏂ",
    "JP" to "ᏣᏩᏂᏏ",
    "KE" to "ᎨᏂᏯ",
    "KG" to "ᎩᎵᏣᎢᏍ",
    "KH" to "ᎧᎹᏉᏗᎠᏂ",
    "KI" to "ᎧᎵᏆᏘ",
    "KM" to "ᎪᎼᎳᏍ",
    "KN" to "ᎤᏓᏅᏘ ᎨᏘᏏ ᎠᎴ ᏁᏪᏏ",
    "KP" to "ᏧᏴᏢ ᎪᎵᎠ",
    "KR" to "ᏧᎦᏃᏮ ᎪᎵᎠ",
    "KW" to "ᎫᏪᎢᏘ",
    "KY" to "ᎨᎢᎹᏂ ᏚᎦᏚᏛᎢ",
    "KZ" to "ᎧᏎᎧᏍᏕᏂ",
    "LA" to "ᎴᎣᏍ",
    "LB" to "ᎴᏆᎾᏂ",
    "LC" to "ᎤᏓᏅᏘ ᎷᏏᏯ",
    "LI" to "ᎵᎦᏗᏂᏍᏓᏂ",
    "LK" to "ᏍᎵ ᎳᏂᎧ",
    "LR" to "ᎳᏈᎵᏯ",
    "LS" to "ᎴᏐᏙ",
    "LT" to "ᎵᏗᏪᏂᎠ",
    "LU" to "ᎸᎧᏎᏋᎩ",
    "LV" to "ᎳᏘᏫᎠ",
    "LY" to "ᎵᏈᏯ",
    "MA" to "ᎼᎶᎪ",
    "MC" to "ᎹᎾᎪ",
    "MD" to "ᎹᎵᏙᏫᎠ",
    "ME" to "ᎼᏂᏔᏁᎦᎶ",
    "MF" to "ᎤᏓᏅᏘ ᏡᏡ",
    "MG" to "ᎹᏓᎦᏍᎧᎵ",
    "MH" to "ᎹᏌᎵ ᏚᎦᏚᏛᎢ",
    "MK" to "ᏧᏴᏜ ᎹᏎᏙᏂᏯ",
    "ML" to "ᎹᎵ",
    "MM" to "ᎹᏯᎹᎵ (ᏇᎵᎹ)",
    "MN" to "ᎹᏂᎪᎵᎠ",
    "MO" to "ᎹᎧᎣ (ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ) ᏣᎢ",
    "MP" to "ᏧᏴᏢ ᏗᏜ ᎹᎵᎠᎾ ᏚᎦᏚᏛᎢ",
    "MQ" to "ᎹᏘᏂᎨ",
    "MR" to "ᎹᏘᎢᏯ",
    "MS" to "ᎹᏂᏘᏌᎳᏗ",
    "MT" to "ᎹᎵᏔ",
    "MU" to "ᎼᎵᏏᎥᏍ",
    "MV" to "ᎹᎵᏗᏫᏍ",
    "MW" to "ᎹᎳᏫ",
    "MX" to "ᎠᏂᏍᏆᏂ",
    "MY" to "ᎹᎴᏏᎢᎠ",
    "MZ" to "ᎼᏎᎻᏇᎩ",
    "NA" to "ᎾᎻᏈᎢᏯ",
    "NC" to "ᎢᏤ ᎧᎵᏙᏂᎠᏂ",
    "NE" to "ᎾᎢᏨ",
    "NF" to "ᏃᎵᏬᎵᎩ ᎤᎦᏚᏛᎢ",
    "NG" to "ᏂᏥᎵᏯ",
    "NI" to "ᏂᎧᎳᏆ",
    "NL" to "ᏁᏛᎳᏂ",
    "NO" to "ᏃᏪ",
    "NP" to "ᏁᏆᎵ",
    "NR" to "ᏃᎤᎷ",
    "NU" to "ᏂᏳ",
    "NZ" to "ᎢᏤ ᏏᎢᎴᏂᏗ",
    "OM" to "ᎣᎺᏂ",
    "PA" to "ᏆᎾᎹ",
    "PE" to "ᏇᎷ",
    "PF" to "ᎠᏂᎦᎸᏥ ᏆᎵᏂᏏᎠ",
    "PG" to "ᏆᏇ ᎢᏤ ᎩᎢᏂ",
    "PH" to "ᎠᏂᏈᎵᎩᏃ",
    "PK" to "ᏆᎩᏍᏖᏂ",
    "PL" to "ᏉᎳᏂ",
    "PM" to "ᎤᏓᏅᏘ ᏈᏰ ᎠᎴ ᎻᏇᎶᏂ",
    "PN" to "ᏈᎧᎵᏂ ᏚᎦᏚᏛᎢ",
    "PR" to "ᏇᎡᏙ ᎵᎢᎪ",
    "PS" to "ᏆᎴᏍᏗᏂᎠᏂ ᏄᎬᏫᏳᏌᏕᎩ",
    "PT" to "ᏉᏥᎦᎳ",
    "PW" to "ᏆᎴᎠᏫ",
    "PY" to "ᏆᎳᏇᎢᏯ",
    "QA" to "ᎧᏔᎵ",
    "QO" to "ᎠᏍᏛ ᎣᏏᏰᏂᎠ",
    "RE" to "ᎴᏳᏂᎠᏂ",
    "RO" to "ᎶᎹᏂᏯ",
    "RS" to "ᏒᏈᏯ",
    "RU" to "ᏲᏂᎢ",
    "RW" to "ᎶᏩᏂᏓ",
    "SA" to "ᏌᎤᏗ ᎡᎴᏈᎠ",
    "SB" to "ᏐᎶᎹᏂ ᏚᎦᏚᏛᎢ",
    "SC" to "ᏏᎡᏥᎵᏍ",
    "SD" to "ᏑᏕᏂ",
    "SE" to "ᏍᏫᏕᏂ",
    "SG" to "ᏏᏂᎦᏉᎵ",
    "SH" to "ᎤᏓᏅᏘ ᎮᎵᎾ",
    "SI" to "ᏍᎶᏫᏂᎠ",
    "SJ" to "ᏍᏩᎵᏆᎵᏗ ᎠᎴ ᏤᏂ ᎹᏰᏂ",
    "SK" to "ᏍᎶᏩᎩᎠ",
    "SL" to "ᏏᎡᎳ ᎴᎣᏂ",
    "SM" to "ᎤᏓᏅᏘ ᎹᎵᎢᏃ",
    "SN" to "ᏏᏂᎦᎵ",
    "SO" to "ᏐᎹᎵ",
    "SR" to "ᏒᎵᎾᎻ",
    "SS" to "ᏧᎦᎾᏮ ᏑᏕᏂ",
    "ST" to "ᏌᎣ ᏙᎺ ᎠᎴ ᏈᏂᏏᏇ",
    "SV" to "ᎡᎵᏌᎵᏆᏙᎵ",
    "SX" to "ᏏᏂᏘ ᎹᏘᏂ",
    "SY" to "ᏏᎵᎠ",
    "SZ" to "ᎡᏍᏩᏘᏂ",
    "TA" to "ᏟᏍᏛᏂ Ꮣ ᎫᎾᎭ",
    "TC" to "ᎠᏂᏛᎵᎩ ᎠᎴ ᎨᎢᎪ ᏚᎦᏚᏛᎢ",
    "TD" to "ᏣᏗ",
    "TF" to "ᎠᏂᎦᎸᏥ ᏧᎦᎾᏮ ᎦᏙᎯ ᎤᎵᏍᏛᎢ",
    "TG" to "ᏙᎪ",
    "TH" to "ᏔᏯᎴᏂ",
    "TJ" to "ᏔᏥᎩᏍᏕᏂ",
    "TK" to "ᏙᎨᎳᏭ",
    "TL" to "ᏘᎼᎵ-ᎴᏍᏖ",
    "TM" to "ᏛᎵᎩᎺᏂᏍᏔᏂ",
    "TN" to "ᏚᏂᏏᏍᎠ",
    "TO" to "ᏙᎾᎦ",
    "TR" to "ᎬᏃ",
    "TT" to "ᏟᏂᏕᏗ ᎠᎴ ᏙᏆᎪ",
    "TV" to "ᏚᏩᎷ",
    "TW" to "ᏔᎢᏩᏂ",
    "TZ" to "ᏖᏂᏏᏂᏯ",
    "UA" to "ᏳᎧᎴᏂ",
    "UG" to "ᏳᎦᏂᏓ",
    "UM" to "U.S. ᎠᏍᏛ ᏚᎦᏚᏛᎢ",
    "UN" to "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎠᏰᎵ ᏚᎾᏙᏢᏒ",
    "US" to "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ",
    "UY" to "ᏳᎷᏇ",
    "UZ" to "ᎤᏍᏇᎩᏍᏖᏂ",
    "VA" to "ᎠᏥᎳᏁᏠ ᎦᏚᎲ",
    "VC" to "ᎤᏓᏅᏘ ᏫᏂᏏᏂᏗ ᎠᎴ ᎾᏍᎩ ᏇᎾᏗᏁᏍ",
    "VE" to "ᏪᏁᏑᏪᎳ",
    "VG" to "ᏈᏗᏍ ᎠᏒᏂᎸ ᏂᎨᏒᎾ ᏚᎦᏚᏛᎢ",
    "VI" to "U.S. ᎠᏒᏂᎸ ᏂᎨᏒᎾ ᏚᎦᏚᏛᎢ",
    "VN" to "ᏫᎡᏘᎾᎻ",
    "VU" to "ᏩᏂᎤᏩᏚ",
    "WF" to "ᏩᎵᏍ ᎠᎴ ᏊᏚᎾ",
    "WS" to "ᏌᎼᎠ",
    "XA" to "ᏡᏙ-ᏄᏍᏛᎢᎥᎧᏁᎬᎢ",
    "XB" to "ᏡᏙ-ᏈᏗ",
    "XK" to "ᎪᏐᏉ",
    "YE" to "ᏰᎺᏂ",
    "YT" to "ᎺᏯᏖ",
    "ZA" to "ᏧᎦᎾᏮ ᎬᎿᎨᏍᏛ",
    "ZM" to "ᏌᎻᏈᏯ",
    "ZW" to "ᏏᎻᏆᏇ",
    "ZZ" to "ᏄᏬᎵᏍᏛᎾ ᎤᏔᏂᏗᎦᏙᎯ",
  ) }

  val cic: ImmutableMap<String, String> by lazy { immutableMapOf(
    "US" to "United States",
  ) }

  val ckb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "جیهان",
    "002" to "ئەفریقا",
    "003" to "ئەمەریکای باکوور",
    "005" to "ئەمەریکای باشوور",
    "009" to "ئۆقیانووسیا",
    "011" to "ڕۆژاوای ئەفریقا",
    "013" to "ئەمریکای ناوەڕاست",
    "014" to "ڕۆژھەڵاتی ئەفریقا",
    "015" to "باکووری ئەفریقا",
    "017" to "ناوەڕاستی ئەفریقا",
    "018" to "باشووری ئەفریقا",
    "019" to "ئەمەریکای باکوور و باشوور",
    "021" to "ئەمریکای باکوور",
    "029" to "کاریبی",
    "030" to "ڕۆژهەڵاتی ئاسیا",
    "034" to "باشووری ئاسیا",
    "035" to "باشووری ڕۆژھەڵاتی ئاسیا",
    "039" to "باشووری ئەورووپا",
    "053" to "ئۆسترالیا",
    "054" to "میلانێزیا",
    "057" to "ناوچەی مایکرۆنیزیا",
    "061" to "پۆلینیزیا",
    "142" to "ئاسیا",
    "143" to "ناوەڕاستی ئاسیا",
    "145" to "ڕۆژاوای ئاسیا",
    "150" to "ئەورووپا",
    "151" to "ڕۆژهەڵاتی ئەورووپا",
    "154" to "باکووری ئەورووپا",
    "155" to "ڕۆژاوای ئەورووپا",
    "202" to "ئەفریقای ژێر سەحرا",
    "419" to "ئەمەریکای لاتین",
    "AC" to "دوورگەی ئاسینسیۆن",
    "AD" to "ئاندۆرا",
    "AE" to "میرنشینە یەکگرتووە عەرەبییەکان",
    "AF" to "ئەفغانستان",
    "AG" to "ئانتیگوا و باربودا",
    "AI" to "ئانگویلا",
    "AL" to "ئەڵبانیا",
    "AM" to "ئەرمەنستان",
    "AO" to "ئەنگۆلا",
    "AQ" to "ئانتارکتیکا",
    "AR" to "ئەرژەنتین",
    "AS" to "ساموای ئەمەریکایی",
    "AT" to "نەمسا",
    "AU" to "ئوسترالیا",
    "AW" to "ئارووبا",
    "AX" to "دوورگەکانی ئالاند",
    "AZ" to "ئازەربایجان",
    "BA" to "بۆسنیا و ھەرزەگۆڤینا",
    "BB" to "باربادۆس",
    "BD" to "بەنگلادیش",
    "BE" to "بەلژیک",
    "BF" to "بورکینافاسۆ",
    "BG" to "بولگاریا",
    "BH" to "بەحرەین",
    "BI" to "بوروندی",
    "BJ" to "بێنین",
    "BL" to "سەن بارتێلێمی",
    "BM" to "بێرموودا",
    "BN" to "بروونای",
    "BO" to "بۆلیڤیا",
    "BQ" to "دوورگە کاریبیەکانی هۆڵەندا",
    "BR" to "برازیل",
    "BS" to "بەھاما",
    "BT" to "بووتان",
    "BV" to "دوورگەی بووڤێ",
    "BW" to "بۆتسوانا",
    "BY" to "بیلاڕووس",
    "BZ" to "بەلیز",
    "CA" to "کەنەدا",
    "CC" to "دوورگەکانی کیلینگ",
    "CD" to "کۆنگۆ کینشاسا",
    "CF" to "کۆماری ئەفریقای ناوەڕاست",
    "CG" to "کۆنگۆ برازاڤیل",
    "CH" to "سویسڕا",
    "CI" to "کۆتدیڤوار",
    "CK" to "دوورگەکانی کوک",
    "CL" to "چیلی",
    "CM" to "کامیرۆن",
    "CN" to "چین",
    "CO" to "کۆلۆمبیا",
    "CP" to "دوورگەی کلیپێرتۆن",
    "CR" to "کۆستاریکا",
    "CU" to "کووبا",
    "CV" to "کەیپڤەرد",
    "CW" to "کوراچاو",
    "CX" to "دوورگەی کریسمس",
    "CY" to "قیبرس",
    "CZ" to "کۆماری چیک",
    "DE" to "ئەڵمانیا",
    "DG" to "دیەگۆ گارسیا",
    "DJ" to "جیبووتی",
    "DK" to "دانمارک",
    "DM" to "دۆمینیکا",
    "DO" to "کۆماری دۆمینیکا",
    "DZ" to "جەزایر",
    "EA" to "سێئووتا و مێلییا",
    "EC" to "ئیکوادۆر",
    "EE" to "ئیستۆنیا",
    "EG" to "میسر",
    "EH" to "سەحرای ڕۆژاوا",
    "ER" to "ئەریتریا",
    "ES" to "ئیسپانیا",
    "ET" to "ئەتیۆپیا",
    "EU" to "یەکێتیی ئەورووپا",
    "EZ" to "ناوچەی یۆرۆ",
    "FI" to "فینلاند",
    "FJ" to "فیجی",
    "FK" to "دوورگەکانی مالڤیناس (دوورگەکانی فاڵکلاند)",
    "FM" to "مایکرۆنیزیا",
    "FO" to "دوورگەکانی فارەو",
    "FR" to "فەڕەنسا",
    "GA" to "گابۆن",
    "GB" to "شانشینی یەکگرتوو",
    "GD" to "گرینادا",
    "GE" to "گورجستان",
    "GF" to "گیانای فەرەنسا",
    "GG" to "گێرنزی",
    "GH" to "غەنا",
    "GI" to "گیبرالتار",
    "GL" to "گرینلاند",
    "GM" to "گامبیا",
    "GN" to "گینێ",
    "GP" to "گوادێلۆپ",
    "GQ" to "گینێی ئیستوایی",
    "GR" to "یۆنان",
    "GS" to "دوورگەکانی جۆرجیا و ساندویچی باشوور",
    "GT" to "گواتیمالا",
    "GU" to "گوام",
    "GW" to "گینێ بیساو",
    "GY" to "گویانا",
    "HK" to "هۆنگ کۆنگ",
    "HM" to "دوورگەکانی هێرد و مەکدانڵد",
    "HN" to "ھۆندووراس",
    "HR" to "کرۆواتیا",
    "HT" to "ھایتی",
    "HU" to "هەنگاریا",
    "IC" to "دوورگەکانی کەناری",
    "ID" to "ئیندۆنیزیا",
    "IE" to "ئیرلەند",
    "IL" to "ئیسرائیل",
    "IM" to "دوورگەی مان",
    "IN" to "ھیندستان",
    "IQ" to "عێراق",
    "IR" to "ئێران",
    "IS" to "ئایسلەند",
    "IT" to "ئیتالیا",
    "JE" to "جێرسی",
    "JM" to "جامایکا",
    "JO" to "ئوردن",
    "JP" to "ژاپۆن",
    "KE" to "کینیا",
    "KG" to "کرگیزستان",
    "KH" to "کەمبۆدیا",
    "KI" to "کیریباس",
    "KM" to "دوورگەکانی کۆمۆر",
    "KN" to "سەن کیتس و نیڤیس",
    "KP" to "کۆریای باکوور",
    "KR" to "کۆریای باشوور",
    "KW" to "کوەیت",
    "KY" to "دوورگەکانی کایمان",
    "KZ" to "کازاخستان",
    "LA" to "لاوس",
    "LB" to "لوبنان",
    "LC" to "سەن لووسیا",
    "LI" to "لیختنشتاین",
    "LK" to "سریلانکا",
    "LR" to "لیبەریا",
    "LS" to "لەسۆتۆ",
    "LT" to "لیتوانایا",
    "LU" to "لوکسەمبورگ",
    "LV" to "لاتڤیا",
    "LY" to "لیبیا",
    "MA" to "مەغریب",
    "MC" to "مۆناکۆ",
    "MD" to "مۆلدۆڤا",
    "ME" to "مۆنتینیگرۆ",
    "MF" to "سەن مارتین",
    "MG" to "ماداگاسکار",
    "MH" to "دوورگەکانی مارشاڵ",
    "MK" to "مەکدۆنیای باکوور",
    "ML" to "مالی",
    "MM" to "میانمار",
    "MN" to "مەنگۆلیا",
    "MO" to "ماکائۆ",
    "MP" to "دوورگەکانی ماریانای باکوور",
    "MQ" to "مارتینیک",
    "MR" to "مۆریتانیا",
    "MS" to "مۆنتسێرات",
    "MT" to "ماڵتا",
    "MU" to "مووریتیووس",
    "MV" to "مالدیڤ",
    "MW" to "مالاوی",
    "MX" to "مەکسیک",
    "MY" to "مالیزیا",
    "MZ" to "مۆزامبیک",
    "NA" to "نامیبیا",
    "NC" to "نیووکالێدۆنیا",
    "NE" to "نیجەر",
    "NF" to "دوورگەی نۆرفۆڵک",
    "NG" to "نیجریا",
    "NI" to "نیکاراگوا",
    "NL" to "ھۆڵەندا",
    "NO" to "نۆرویژ",
    "NP" to "نیپال",
    "NR" to "نائوروو",
    "NU" to "نیووئی",
    "NZ" to "نیوزیلاند",
    "OM" to "عومان",
    "PA" to "پاناما",
    "PE" to "پێروو",
    "PF" to "پۆلینیسیای فەرەنسا",
    "PG" to "پاپوا گینێی نوێ",
    "PH" to "فلیپین",
    "PK" to "پاکستان",
    "PL" to "پۆڵەندا",
    "PM" to "سەن پیێر و میکێلۆن",
    "PN" to "دوورگەکانی پیتکەرن",
    "PR" to "پۆرتۆڕیکۆ",
    "PS" to "ناوچە فەلەستینیەکان",
    "PT" to "پورتوگال",
    "PW" to "پالاو",
    "PY" to "پاراگوای",
    "QA" to "قەتەر",
    "QO" to "دەرەوەی ئۆقیانووسیا",
    "RE" to "ڕییوونیەن",
    "RO" to "ڕۆمانیا",
    "RS" to "سربیا",
    "RU" to "ڕووسیا",
    "RW" to "ڕواندا",
    "SA" to "عەرەبستانی سەعوودی",
    "SB" to "دوورگەکانی سلێمان",
    "SC" to "سیشێل",
    "SD" to "سوودان",
    "SE" to "سوید",
    "SG" to "سینگاپور",
    "SH" to "سەن هێلێنا",
    "SI" to "سلۆڤێنیا",
    "SJ" to "سڤالبارد و یان مایەن",
    "SK" to "سلۆڤاکیا",
    "SL" to "سیەرالیۆن",
    "SM" to "سان مارینۆ",
    "SN" to "سێنێگاڵ",
    "SO" to "سۆمالیا",
    "SR" to "سورینام",
    "SS" to "سوودانی باشوور",
    "ST" to "ساوتۆمێ و پرینسیپی",
    "SV" to "ئێلسالڤادۆر",
    "SX" to "سینت مارتن",
    "SY" to "سووریا",
    "SZ" to "سوازیلاند",
    "TA" to "تریستێن دا کوونا",
    "TC" to "دوورگەکانی تورکس و کایکۆس",
    "TD" to "چاد",
    "TF" to "هەرێمە باشووریەکانی فەرەنسا",
    "TG" to "تۆگۆ",
    "TH" to "تایلەند",
    "TJ" to "تاجیکستان",
    "TK" to "تۆکێلاو",
    "TL" to "تیمۆری ڕۆژھەڵات",
    "TM" to "تورکمانستان",
    "TN" to "توونس",
    "TO" to "تۆنگا",
    "TR" to "تورکیا",
    "TT" to "ترینیداد و تۆباگو",
    "TV" to "تووڤالوو",
    "TW" to "تایوان",
    "TZ" to "تانزانیا",
    "UA" to "ئۆکرانیا",
    "UG" to "ئوگاندا",
    "UM" to "دوورگەکانی دەرەوەی ئەمریکا",
    "UN" to "نەتەوە یەکگرتووەکان",
    "US" to "ویلایەتە یەکگرتووەکان",
    "UY" to "ئوروگوای",
    "UZ" to "ئوزبەکستان",
    "VA" to "ڤاتیکان",
    "VC" to "سەینت ڤینسەنت و گرینادینز",
    "VE" to "ڤەنزوێلا",
    "VG" to "دوورگەکانی ڤیرجنی بەریتانیا",
    "VI" to "دوورگەکانی ڤیرجنی ئەمەریکا",
    "VN" to "ڤیەتنام",
    "VU" to "ڤانوواتوو",
    "WF" to "والیس و فوتونا",
    "WS" to "ساموا",
    "XK" to "کۆسۆڤۆ",
    "YE" to "یەمەن",
    "YT" to "مایۆت",
    "ZA" to "ئەفریقای باشوور",
    "ZM" to "زامبیا",
    "ZW" to "زیمبابوی",
    "ZZ" to "ناوچەی نەناسراو",
  ) }

  val ckb_IR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val cs: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "svět",
    "002" to "Afrika",
    "003" to "Severní Amerika",
    "005" to "Jižní Amerika",
    "009" to "Oceánie",
    "011" to "západní Afrika",
    "013" to "Střední Amerika",
    "014" to "východní Afrika",
    "015" to "severní Afrika",
    "017" to "střední Afrika",
    "018" to "jižní Afrika",
    "019" to "Amerika",
    "021" to "Severní Amerika (oblast)",
    "029" to "Karibik",
    "030" to "východní Asie",
    "034" to "jižní Asie",
    "035" to "jihovýchodní Asie",
    "039" to "jižní Evropa",
    "053" to "Australasie",
    "054" to "Melanésie",
    "057" to "Mikronésie (region)",
    "061" to "Polynésie",
    "142" to "Asie",
    "143" to "Střední Asie",
    "145" to "západní Asie",
    "150" to "Evropa",
    "151" to "východní Evropa",
    "154" to "severní Evropa",
    "155" to "západní Evropa",
    "202" to "subsaharská Afrika",
    "419" to "Latinská Amerika",
    "AC" to "Ascension",
    "AD" to "Andorra",
    "AE" to "Spojené arabské emiráty",
    "AF" to "Afghánistán",
    "AG" to "Antigua a Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albánie",
    "AM" to "Arménie",
    "AO" to "Angola",
    "AQ" to "Antarktida",
    "AR" to "Argentina",
    "AS" to "Americká Samoa",
    "AT" to "Rakousko",
    "AU" to "Austrálie",
    "AW" to "Aruba",
    "AX" to "Ålandy",
    "AZ" to "Ázerbájdžán",
    "BA" to "Bosna a Hercegovina",
    "BB" to "Barbados",
    "BD" to "Bangladéš",
    "BE" to "Belgie",
    "BF" to "Burkina Faso",
    "BG" to "Bulharsko",
    "BH" to "Bahrajn",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Svatý Bartoloměj",
    "BM" to "Bermudy",
    "BN" to "Brunej",
    "BO" to "Bolívie",
    "BQ" to "Karibské Nizozemsko",
    "BR" to "Brazílie",
    "BS" to "Bahamy",
    "BT" to "Bhútán",
    "BV" to "Bouvetův ostrov",
    "BW" to "Botswana",
    "BY" to "Bělorusko",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kokosové ostrovy",
    "CD" to "Kongo – Kinshasa",
    "CF" to "Středoafrická republika",
    "CG" to "Kongo – Brazzaville",
    "CH" to "Švýcarsko",
    "CI" to "Pobřeží slonoviny",
    "CK" to "Cookovy ostrovy",
    "CL" to "Chile",
    "CM" to "Kamerun",
    "CN" to "Čína",
    "CO" to "Kolumbie",
    "CP" to "Clippertonův ostrov",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Kapverdy",
    "CW" to "Curaçao",
    "CX" to "Vánoční ostrov",
    "CY" to "Kypr",
    "CZ" to "Česko",
    "DE" to "Německo",
    "DG" to "Diego García",
    "DJ" to "Džibutsko",
    "DK" to "Dánsko",
    "DM" to "Dominika",
    "DO" to "Dominikánská republika",
    "DZ" to "Alžírsko",
    "EA" to "Ceuta a Melilla",
    "EC" to "Ekvádor",
    "EE" to "Estonsko",
    "EG" to "Egypt",
    "EH" to "Západní Sahara",
    "ER" to "Eritrea",
    "ES" to "Španělsko",
    "ET" to "Etiopie",
    "EU" to "Evropská unie",
    "EZ" to "eurozóna",
    "FI" to "Finsko",
    "FJ" to "Fidži",
    "FK" to "Falklandské ostrovy",
    "FM" to "Mikronésie",
    "FO" to "Faerské ostrovy",
    "FR" to "Francie",
    "GA" to "Gabon",
    "GB" to "Spojené království",
    "GD" to "Grenada",
    "GE" to "Gruzie",
    "GF" to "Francouzská Guyana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Grónsko",
    "GM" to "Gambie",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Rovníková Guinea",
    "GR" to "Řecko",
    "GS" to "Jižní Georgie a Jižní Sandwichovy ostrovy",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hongkong – ZAO Číny",
    "HM" to "Heardův ostrov a McDonaldovy ostrovy",
    "HN" to "Honduras",
    "HR" to "Chorvatsko",
    "HT" to "Haiti",
    "HU" to "Maďarsko",
    "IC" to "Kanárské ostrovy",
    "ID" to "Indonésie",
    "IE" to "Irsko",
    "IL" to "Izrael",
    "IM" to "Ostrov Man",
    "IN" to "Indie",
    "IO" to "Britské indickooceánské území",
    "IQ" to "Irák",
    "IR" to "Írán",
    "IS" to "Island",
    "IT" to "Itálie",
    "JE" to "Jersey",
    "JM" to "Jamajka",
    "JO" to "Jordánsko",
    "JP" to "Japonsko",
    "KE" to "Keňa",
    "KG" to "Kyrgyzstán",
    "KH" to "Kambodža",
    "KI" to "Kiribati",
    "KM" to "Komory",
    "KN" to "Svatý Kryštof a Nevis",
    "KP" to "Severní Korea",
    "KR" to "Jižní Korea",
    "KW" to "Kuvajt",
    "KY" to "Kajmanské ostrovy",
    "KZ" to "Kazachstán",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "Svatá Lucie",
    "LI" to "Lichtenštejnsko",
    "LK" to "Srí Lanka",
    "LR" to "Libérie",
    "LS" to "Lesotho",
    "LT" to "Litva",
    "LU" to "Lucembursko",
    "LV" to "Lotyšsko",
    "LY" to "Libye",
    "MA" to "Maroko",
    "MC" to "Monako",
    "MD" to "Moldavsko",
    "ME" to "Černá Hora",
    "MF" to "Svatý Martin (Francie)",
    "MG" to "Madagaskar",
    "MH" to "Marshallovy ostrovy",
    "MK" to "Severní Makedonie",
    "ML" to "Mali",
    "MM" to "Myanmar (Barma)",
    "MN" to "Mongolsko",
    "MO" to "Macao – ZAO Číny",
    "MP" to "Severní Mariany",
    "MQ" to "Martinik",
    "MR" to "Mauritánie",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauricius",
    "MV" to "Maledivy",
    "MW" to "Malawi",
    "MX" to "Mexiko",
    "MY" to "Malajsie",
    "MZ" to "Mosambik",
    "NA" to "Namibie",
    "NC" to "Nová Kaledonie",
    "NE" to "Niger",
    "NF" to "Norfolk",
    "NG" to "Nigérie",
    "NI" to "Nikaragua",
    "NL" to "Nizozemsko",
    "NO" to "Norsko",
    "NP" to "Nepál",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nový Zéland",
    "OM" to "Omán",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Francouzská Polynésie",
    "PG" to "Papua-Nová Guinea",
    "PH" to "Filipíny",
    "PK" to "Pákistán",
    "PL" to "Polsko",
    "PM" to "Saint-Pierre a Miquelon",
    "PN" to "Pitcairnovy ostrovy",
    "PR" to "Portoriko",
    "PS" to "Palestinská území",
    "PT" to "Portugalsko",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Katar",
    "QO" to "vnější Oceánie",
    "RE" to "Réunion",
    "RO" to "Rumunsko",
    "RS" to "Srbsko",
    "RU" to "Rusko",
    "RW" to "Rwanda",
    "SA" to "Saúdská Arábie",
    "SB" to "Šalamounovy ostrovy",
    "SC" to "Seychely",
    "SD" to "Súdán",
    "SE" to "Švédsko",
    "SG" to "Singapur",
    "SH" to "Svatá Helena",
    "SI" to "Slovinsko",
    "SJ" to "Špicberky a Jan Mayen",
    "SK" to "Slovensko",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somálsko",
    "SR" to "Surinam",
    "SS" to "Jižní Súdán",
    "ST" to "Svatý Tomáš a Princův ostrov",
    "SV" to "Salvador",
    "SX" to "Svatý Martin (Nizozemsko)",
    "SY" to "Sýrie",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks a Caicos",
    "TD" to "Čad",
    "TF" to "Francouzská jižní území",
    "TG" to "Togo",
    "TH" to "Thajsko",
    "TJ" to "Tádžikistán",
    "TK" to "Tokelau",
    "TL" to "Východní Timor",
    "TM" to "Turkmenistán",
    "TN" to "Tunisko",
    "TO" to "Tonga",
    "TR" to "Turecko",
    "TT" to "Trinidad a Tobago",
    "TV" to "Tuvalu",
    "TW" to "Tchaj-wan",
    "TZ" to "Tanzanie",
    "UA" to "Ukrajina",
    "UG" to "Uganda",
    "UM" to "Menší odlehlé ostrovy USA",
    "UN" to "Organizace spojených národů",
    "US" to "Spojené státy",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistán",
    "VA" to "Vatikán",
    "VC" to "Svatý Vincenc a Grenadiny",
    "VE" to "Venezuela",
    "VG" to "Britské Panenské ostrovy",
    "VI" to "Americké Panenské ostrovy",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis a Futuna",
    "WS" to "Samoa",
    "XA" to "simulovaná diakritika",
    "XB" to "simulovaný obousměrný zápis",
    "XK" to "Kosovo",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Jihoafrická republika",
    "ZM" to "Zambie",
    "ZW" to "Zimbabwe",
    "ZZ" to "neznámá oblast",
  ) }

  val csw: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "ᐊᐢᑭᕀ",
    "003" to "ᒥᐦᑭᓇᕽ ᒥᓂᐢᑎᐠ",
    "005" to "ᓵᐘᓄᕽ ᒥᐦᑭᓇᕽ ᒥᓂᐢᑎᐠ",
    "013" to "ᐋᐱᐦᑕᐤ ᒥᐦᑭᓇᕽ ᒥᓂᐢᑎᐠ",
    "021" to "ᑮᐍᑎᓄᕽ ᒥᐦᑭᓇᕽ ᒥᓂᐢᑎᐠ",
    "CA" to "ᑳᓇᑕ",
    "EU" to "ᐊᑳᒪᐢᑮᔭ",
    "EZ" to "ᐊᑳᒪᐢᑮᕽ",
    "UN" to "ᒫᒫᐏ ᐊᐢᑮᔭ",
    "US" to "ᑭᐦᒋ ᒨᑯᒫᓂᕽ",
  ) }

  val cv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "тӗнче",
    "002" to "Африка",
    "003" to "Ҫурҫӗр Америка",
    "005" to "Кӑнтӑр Америка",
    "009" to "Океани",
    "011" to "Анӑҫ Африка",
    "013" to "Тӗп Америка",
    "014" to "Хӗвелтухӑҫ Африка",
    "015" to "Ҫурҫӗр Африка",
    "017" to "Тӗп Африка",
    "018" to "Кӑнтӑр Африка",
    "019" to "Америка",
    "021" to "Ҫурҫӗр Америка регион",
    "029" to "Карибсем",
    "030" to "Хӗвелтухӑҫ Ази",
    "034" to "Кӑнтӑр Ази",
    "035" to "Кӑнтӑр хӗвелтухӑҫ Ази",
    "039" to "Кӑнтӑр Европа",
    "053" to "Австралази",
    "054" to "Меланези",
    "057" to "Микронези регион",
    "061" to "Полинези",
    "142" to "Ази",
    "143" to "Тӗп Ази",
    "145" to "Анӑҫ Ази",
    "150" to "Европа",
    "151" to "Хӗвелтухӑҫ Европа",
    "154" to "Ҫурҫӗр Европа",
    "155" to "Анӑҫ Европа",
    "202" to "Тропик Африка",
    "419" to "Латинла Америка",
    "AC" to "Вознесени утравӗ",
    "AD" to "Андорра",
    "AE" to "Арапсен Пӗрлешӳллӗ Эмирачӗ",
    "AF" to "Афганистан",
    "AG" to "Антигуа тата Барбуда",
    "AI" to "Ангилья",
    "AL" to "Албани",
    "AM" to "Армени",
    "AO" to "Ангола",
    "AQ" to "Антарктида",
    "AR" to "Аргентина",
    "AS" to "Америка Самоа",
    "AT" to "Австри",
    "AU" to "Австрали",
    "AW" to "Аруба",
    "AX" to "Аланди утравӗсем",
    "AZ" to "Азербайджан",
    "BA" to "Боснипе Герцеговина",
    "BB" to "Барбадос",
    "BD" to "Бангладеш",
    "BE" to "Бельги",
    "BF" to "Буркина-Фасо",
    "BG" to "Болгари",
    "BH" to "Бахрейн",
    "BI" to "Бурунди",
    "BJ" to "Бенин",
    "BL" to "Сен-Бартелеми",
    "BM" to "Бермуд утравӗсем",
    "BN" to "Бруней-Даруссалам",
    "BO" to "Боливи",
    "BQ" to "Бонэйр, Синт-Эстатиус тата Саба",
    "BR" to "Бразили",
    "BS" to "Пахам утравӗсем",
    "BT" to "Бутан",
    "BV" to "Буве утравӗ",
    "BW" to "Ботсвана",
    "BY" to "Беларуҫ",
    "BZ" to "Белиз",
    "CA" to "Канада",
    "CC" to "Кокос утравӗсем",
    "CD" to "Конго - Киншаса",
    "CF" to "Тӗп Африка Республики",
    "CG" to "Конго - Браззавиль",
    "CH" to "Швейцари",
    "CI" to "Кот-д’Ивуар",
    "CK" to "Кук утравӗсем",
    "CL" to "Чили",
    "CM" to "Камерун",
    "CN" to "Китай",
    "CO" to "Колумби",
    "CP" to "Клиппертон утравӗ",
    "CR" to "Коста-Рика",
    "CU" to "Куба",
    "CV" to "Кабо-Верде",
    "CW" to "Кюрасао",
    "CX" to "Раштав утравӗ",
    "CY" to "Кипр",
    "CZ" to "Чехи",
    "DE" to "Германи",
    "DG" to "Диего-Гарсия",
    "DJ" to "Джибути",
    "DK" to "Дани",
    "DM" to "Доминика",
    "DO" to "Доминикан Республики",
    "DZ" to "Алжир",
    "EA" to "Сеута тата Мелилья",
    "EC" to "Эквадор",
    "EE" to "Эстони",
    "EG" to "Египет",
    "EH" to "Анӑҫ Сахара",
    "ER" to "Эритрей",
    "ES" to "Испани",
    "ET" to "Эфиопи",
    "EU" to "Европа пӗрлешӗвӗ",
    "EZ" to "Еврозон",
    "FI" to "Финлянди",
    "FJ" to "Фиджи",
    "FK" to "Фолкленд утравӗсем",
    "FM" to "Микронези",
    "FO" to "Фарер утравӗсем",
    "FR" to "Франци",
    "GA" to "Габон",
    "GB" to "Аслӑ Британи",
    "GD" to "Гренада",
    "GE" to "Грузи",
    "GF" to "Франци Гвиана",
    "GG" to "Гернси",
    "GH" to "Гана",
    "GI" to "Гибралтар",
    "GL" to "Гренланди",
    "GM" to "Гамби",
    "GN" to "Гвиней",
    "GP" to "Гваделупа",
    "GQ" to "Экваториаллӑ Гвиней",
    "GR" to "Греци",
    "GS" to "Кӑнтӑр Георги тата Сандвичев утравӗсем",
    "GT" to "Гватемала",
    "GU" to "Гуам",
    "GW" to "Гвиней-Бисау",
    "GY" to "Гайана",
    "HK" to "Гонконг (САР)",
    "HM" to "Херд тата Макдональд утравӗ",
    "HN" to "Гондурас",
    "HR" to "Хорвати",
    "HT" to "Гаити",
    "HU" to "Венгри",
    "IC" to "Канар утравӗсем",
    "ID" to "Индонези",
    "IE" to "Ирланди",
    "IL" to "Израиль",
    "IM" to "Мэн утравӗ",
    "IN" to "Инди",
    "IQ" to "Ирак",
    "IR" to "Иран",
    "IS" to "Исланди",
    "IT" to "Итали",
    "JE" to "Джерси",
    "JM" to "Ямайка",
    "JO" to "Иордани",
    "JP" to "Япони",
    "KE" to "Кени",
    "KG" to "Киргизи",
    "KH" to "Камбоджа",
    "KI" to "Кирибати",
    "KM" to "Комор утравӗсем",
    "KN" to "Сент-Китс тата Невис",
    "KP" to "КХДР",
    "KR" to "Корей Республики",
    "KW" to "Кувейт",
    "KY" to "Кайман утравӗсем",
    "KZ" to "Казахстан",
    "LA" to "Лаос",
    "LB" to "Ливан",
    "LC" to "Сент-Люсия",
    "LI" to "Лихтенштейн",
    "LK" to "Шри-Ланка",
    "LR" to "Либери",
    "LS" to "Лесото",
    "LT" to "Литва",
    "LU" to "Люксембург",
    "LV" to "Латви",
    "LY" to "Ливи",
    "MA" to "Марокко",
    "MC" to "Монако",
    "MD" to "Молдова",
    "ME" to "Черногори",
    "MF" to "Сен-Мартен",
    "MG" to "Мадагаскар",
    "MH" to "Маршаллов утравӗсем",
    "MK" to "Ҫурҫӗр Македони",
    "ML" to "Мали",
    "MM" to "Мьянма (Бирма)",
    "MN" to "Монголи",
    "MO" to "Макао (САР)",
    "MP" to "Ҫурҫӗр Мариан утравӗсем",
    "MQ" to "Мартиника",
    "MR" to "Мавритани",
    "MS" to "Монтсеррат",
    "MT" to "Мальта",
    "MU" to "Маврики",
    "MV" to "Мальдивсем",
    "MW" to "Малави",
    "MX" to "Мексика",
    "MY" to "Малайзи",
    "MZ" to "Мозамбик",
    "NA" to "Намиби",
    "NC" to "Ҫӗнӗ Каледони",
    "NE" to "Нигер",
    "NF" to "Норфолк утравӗ",
    "NG" to "Нигери",
    "NI" to "Никарагуа",
    "NL" to "Нидерланд",
    "NO" to "Норвеги",
    "NP" to "Непал",
    "NR" to "Науру",
    "NU" to "Ниуэ",
    "NZ" to "Ҫӗнӗ Зеланди",
    "OM" to "Оман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PF" to "Франци Полинези",
    "PG" to "Папуа — Ҫӗнӗ Гвиней",
    "PH" to "Филиппинсем",
    "PK" to "Пакистан",
    "PL" to "Польша",
    "PM" to "Сен-Пьер & Микелон",
    "PN" to "Питкэрн утравӗсем",
    "PR" to "Пуэрто-Рико",
    "PS" to "Палестинӑн территорийӗсем",
    "PT" to "Португали",
    "PW" to "Палау",
    "PY" to "Парагвай",
    "QA" to "Катар",
    "QO" to "Тулаш Океани",
    "RE" to "Реюньон",
    "RO" to "Румыни",
    "RS" to "Серби",
    "RU" to "Раҫҫей",
    "RW" to "Руанда",
    "SA" to "Сауд Аравийӗ",
    "SB" to "Соломон утравӗсем",
    "SC" to "Сейшел утравӗсем",
    "SD" to "Судан",
    "SE" to "Швеци",
    "SG" to "Сингапур",
    "SH" to "Сӑваплӑ Елена утравӗ",
    "SI" to "Словени",
    "SJ" to "Шпицберген тата Ян-Майен",
    "SK" to "Словаки",
    "SL" to "Сьерра-Леоне",
    "SM" to "Сан-Марино",
    "SN" to "Сенегал",
    "SO" to "Сомали",
    "SR" to "Суринам",
    "SS" to "Кӑнтӑр Судан",
    "ST" to "Сан-Томе тата Принсипи",
    "SV" to "Сальвадор",
    "SX" to "Синт-Мартен",
    "SY" to "Сири",
    "SZ" to "Эсватини",
    "TA" to "Тристан-да-Кунья",
    "TC" to "Тёркс тата Кайкос утравӗсем",
    "TD" to "Чад",
    "TF" to "Франци Кӑнтӑр территорийӗсем",
    "TG" to "Того",
    "TH" to "Таиланд",
    "TJ" to "Таджикистан",
    "TK" to "Токелау",
    "TL" to "Хӗвелтухӑҫ Тимор",
    "TM" to "Туркменистан",
    "TN" to "Тунис",
    "TO" to "Тонга",
    "TR" to "Турци",
    "TT" to "Тринидад тата Тобаго",
    "TV" to "Тувалу",
    "TW" to "Тайвань",
    "TZ" to "Танзани",
    "UA" to "Украина",
    "UG" to "Уганда",
    "UM" to "Тулашӗнчи утравӗсем (АПШ)",
    "UN" to "Пӗрлешӳллӗ Нацисен Организацийӗ",
    "US" to "Пӗрлешӗннӗ Штатсем",
    "UY" to "Уругвай",
    "UZ" to "Узбекистан",
    "VA" to "Ватикан",
    "VC" to "Сент-Винсент тата Гренадины",
    "VE" to "Венесуэла",
    "VG" to "Британин Виргини утравӗсем",
    "VI" to "Виргини утравӗсем (АПШ)",
    "VN" to "Вьетнам",
    "VU" to "Вануату",
    "WF" to "Уоллис тата Футуна",
    "WS" to "Самоа",
    "XA" to "псевдакцентсем",
    "XB" to "псевд-Bidi",
    "XK" to "Косово",
    "YE" to "Йемен",
    "YT" to "Майотта",
    "ZA" to "Кӑнтӑр Африка Республики",
    "ZM" to "Замби",
    "ZW" to "Зимбабве",
    "ZZ" to "паллӑ мар регион",
  ) }

  val cy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Y Byd",
    "002" to "Affrica",
    "003" to "Gogledd America",
    "005" to "De America",
    "009" to "Oceania",
    "011" to "Gorllewin Affrica",
    "013" to "Canolbarth America",
    "014" to "Dwyrain Affrica",
    "015" to "Gogledd Affrica",
    "017" to "Canol Affrica",
    "018" to "Deheudir Affrica",
    "019" to "Yr Amerig",
    "021" to "America i’r Gogledd o Fecsico",
    "029" to "Y Caribî",
    "030" to "Dwyrain Asia",
    "034" to "De Asia",
    "035" to "De-Ddwyrain Asia",
    "039" to "De Ewrop",
    "053" to "Awstralasia",
    "054" to "Melanesia",
    "057" to "Rhanbarth Micronesia",
    "061" to "Polynesia",
    "142" to "Asia",
    "143" to "Canol Asia",
    "145" to "Gorllewin Asia",
    "150" to "Ewrop",
    "151" to "Dwyrain Ewrop",
    "154" to "Gogledd Ewrop",
    "155" to "Gorllewin Ewrop",
    "202" to "Affrica Is-Sahara",
    "419" to "America Ladin",
    "AC" to "Ynys Ascension",
    "AD" to "Andorra",
    "AE" to "Emiradau Arabaidd Unedig",
    "AF" to "Afghanistan",
    "AG" to "Antigua a Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarctica",
    "AR" to "Yr Ariannin",
    "AS" to "Samoa America",
    "AT" to "Awstria",
    "AU" to "Awstralia",
    "AW" to "Aruba",
    "AX" to "Ynysoedd Åland",
    "AZ" to "Aserbaijan",
    "BA" to "Bosnia a Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Gwlad Belg",
    "BF" to "Burkina Faso",
    "BG" to "Bwlgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolifia",
    "BQ" to "Antilles yr Iseldiroedd",
    "BR" to "Brasil",
    "BS" to "Y Bahamas",
    "BT" to "Bhutan",
    "BV" to "Ynys Bouvet",
    "BW" to "Botswana",
    "BY" to "Belarws",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Ynysoedd Cocos (Keeling)",
    "CD" to "Y Congo - Kinshasa",
    "CF" to "Gweriniaeth Canolbarth Affrica",
    "CG" to "Y Congo - Brazzaville",
    "CH" to "Y Swistir",
    "CI" to "Côte d’Ivoire",
    "CK" to "Ynysoedd Cook",
    "CL" to "Chile",
    "CM" to "Camerŵn",
    "CN" to "Tsieina",
    "CO" to "Colombia",
    "CP" to "Ynys Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Ciwba",
    "CV" to "Cabo Verde",
    "CW" to "Curaçao",
    "CX" to "Ynys y Nadolig",
    "CY" to "Cyprus",
    "CZ" to "Tsiecia",
    "DE" to "Yr Almaen",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Denmarc",
    "DM" to "Dominica",
    "DO" to "Gweriniaeth Dominica",
    "DZ" to "Algeria",
    "EA" to "Ceuta a Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Yr Aifft",
    "EH" to "Gorllewin Sahara",
    "ER" to "Eritrea",
    "ES" to "Sbaen",
    "ET" to "Ethiopia",
    "EU" to "Yr Undeb Ewropeaidd",
    "EZ" to "Ardal yr Ewro",
    "FI" to "Y Ffindir",
    "FJ" to "Fiji",
    "FK" to "Ynysoedd y Falkland/Malvinas",
    "FM" to "Micronesia",
    "FO" to "Ynysoedd Ffaro",
    "FR" to "Ffrainc",
    "GA" to "Gabon",
    "GB" to "Y Deyrnas Unedig",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "Guyane Ffrengig",
    "GG" to "Ynys y Garn",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Yr Ynys Las",
    "GM" to "Gambia",
    "GN" to "Gini",
    "GP" to "Guadeloupe",
    "GQ" to "Gini Gyhydeddol",
    "GR" to "Gwlad Groeg",
    "GS" to "De Georgia ac Ynysoedd Sandwich y De",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guiné-Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong SAR Tsieina",
    "HM" to "Ynys Heard ac Ynysoedd McDonald",
    "HN" to "Honduras",
    "HR" to "Croatia",
    "HT" to "Haiti",
    "HU" to "Hwngari",
    "IC" to "Yr Ynysoedd Dedwydd",
    "ID" to "Indonesia",
    "IE" to "Iwerddon",
    "IL" to "Israel",
    "IM" to "Ynys Manaw",
    "IN" to "India",
    "IO" to "Tiriogaeth Brydeinig Cefnfor India",
    "IQ" to "Irac",
    "IR" to "Iran",
    "IS" to "Gwlad yr Iâ",
    "IT" to "Yr Eidal",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Gwlad Iorddonen",
    "JP" to "Japan",
    "KE" to "Kenya",
    "KG" to "Kyrgyzstan",
    "KH" to "Cambodia",
    "KI" to "Kiribati",
    "KM" to "Comoros",
    "KN" to "Saint Kitts a Nevis",
    "KP" to "Gogledd Corea",
    "KR" to "De Corea",
    "KW" to "Kuwait",
    "KY" to "Ynysoedd Cayman",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Libanus",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lithwania",
    "LU" to "Lwcsembwrg",
    "LV" to "Latfia",
    "LY" to "Libya",
    "MA" to "Moroco",
    "MC" to "Monaco",
    "MD" to "Moldofa",
    "ME" to "Montenegro",
    "MF" to "Saint Martin",
    "MG" to "Madagascar",
    "MH" to "Ynysoedd Marshall",
    "MK" to "Gogledd Macedonia",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Macau SAR Tsieina",
    "MP" to "Ynysoedd Gogledd Mariana",
    "MQ" to "Martinique",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Y Maldives",
    "MW" to "Malawi",
    "MX" to "Mecsico",
    "MY" to "Malaysia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "Caledonia Newydd",
    "NE" to "Niger",
    "NF" to "Ynys Norfolk",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Yr Iseldiroedd",
    "NO" to "Norwy",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Seland Newydd",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Periw",
    "PF" to "Polynesia Ffrengig",
    "PG" to "Papua Guinea Newydd",
    "PH" to "Y Philipinau",
    "PK" to "Pakistan",
    "PL" to "Gwlad Pwyl",
    "PM" to "Saint-Pierre-et-Miquelon",
    "PN" to "Ynysoedd Pitcairn",
    "PR" to "Puerto Rico",
    "PS" to "Tiriogaethau Palesteinaidd",
    "PT" to "Portiwgal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Oceania Bellennig",
    "RE" to "Réunion",
    "RO" to "Rwmania",
    "RS" to "Serbia",
    "RU" to "Rwsia",
    "RW" to "Rwanda",
    "SA" to "Saudi Arabia",
    "SB" to "Ynysoedd Solomon",
    "SC" to "Seychelles",
    "SD" to "Swdan",
    "SE" to "Sweden",
    "SG" to "Singapore",
    "SH" to "Saint Helena",
    "SI" to "Slofenia",
    "SJ" to "Svalbard a Jan Mayen",
    "SK" to "Slofacia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "De Swdan",
    "ST" to "São Tomé a Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Ynysoedd Turks a Caicos",
    "TD" to "Tsiad",
    "TF" to "Tiroedd Deheuol ac Antarctig Ffrainc",
    "TG" to "Togo",
    "TH" to "Gwlad Thai",
    "TJ" to "Tajicistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Tyrcmenistan",
    "TN" to "Tiwnisia",
    "TO" to "Tonga",
    "TR" to "Twrci",
    "TT" to "Trinidad a Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Wcráin",
    "UG" to "Uganda",
    "UM" to "Ynysoedd Pellennig UDA",
    "UN" to "Y Cenhedloedd Unedig",
    "US" to "Yr Unol Daleithiau",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Y Fatican",
    "VC" to "Saint Vincent a’r Grenadines",
    "VE" to "Venezuela",
    "VG" to "Ynysoedd Gwyryf Prydain",
    "VI" to "Ynysoedd Gwyryf yr Unol Daleithiau",
    "VN" to "Fietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis a Futuna",
    "WS" to "Samoa",
    "XA" to "Acenion Ffug",
    "XB" to "Bidi Ffug",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "De Affrica",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Rhanbarth Anhysbys",
  ) }

  val da: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Verden",
    "002" to "Afrika",
    "003" to "Nordamerika",
    "005" to "Sydamerika",
    "009" to "Oceanien",
    "011" to "Vestafrika",
    "013" to "Mellemamerika",
    "014" to "Østafrika",
    "015" to "Nordafrika",
    "017" to "Centralafrika",
    "018" to "Det sydlige Afrika",
    "019" to "Nord-, Mellem- og Sydamerika",
    "021" to "Det nordlige Amerika",
    "029" to "Caribien",
    "030" to "Østasien",
    "034" to "Sydasien",
    "035" to "Sydøstasien",
    "039" to "Sydeuropa",
    "053" to "Australasien",
    "054" to "Melanesien",
    "057" to "Mikronesiske område",
    "061" to "Polynesien",
    "142" to "Asien",
    "143" to "Centralasien",
    "145" to "Vestasien",
    "150" to "Europa",
    "151" to "Østeuropa",
    "154" to "Nordeuropa",
    "155" to "Vesteuropa",
    "202" to "Subsaharisk Afrika",
    "419" to "Latinamerika",
    "AC" to "Ascensionøen",
    "AD" to "Andorra",
    "AE" to "De Forenede Arabiske Emirater",
    "AF" to "Afghanistan",
    "AG" to "Antigua og Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albanien",
    "AM" to "Armenien",
    "AO" to "Angola",
    "AQ" to "Antarktis",
    "AR" to "Argentina",
    "AS" to "Amerikansk Samoa",
    "AT" to "Østrig",
    "AU" to "Australien",
    "AW" to "Aruba",
    "AX" to "Åland",
    "AZ" to "Aserbajdsjan",
    "BA" to "Bosnien-Hercegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgien",
    "BF" to "Burkina Faso",
    "BG" to "Bulgarien",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "De tidligere Nederlandske Antiller",
    "BR" to "Brasilien",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Bouvetøen",
    "BW" to "Botswana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Cocosøerne",
    "CD" to "Congo-Kinshasa",
    "CF" to "Den Centralafrikanske Republik",
    "CG" to "Congo-Brazzaville",
    "CH" to "Schweiz",
    "CI" to "Elfenbenskysten",
    "CK" to "Cookøerne",
    "CL" to "Chile",
    "CM" to "Cameroun",
    "CN" to "Kina",
    "CO" to "Colombia",
    "CP" to "Clippertonøen",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Kap Verde",
    "CW" to "Curaçao",
    "CX" to "Juleøen",
    "CY" to "Cypern",
    "CZ" to "Tjekkiet",
    "DE" to "Tyskland",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Danmark",
    "DM" to "Dominica",
    "DO" to "Den Dominikanske Republik",
    "DZ" to "Algeriet",
    "EA" to "Ceuta og Melilla",
    "EC" to "Ecuador",
    "EE" to "Estland",
    "EG" to "Egypten",
    "EH" to "Vestsahara",
    "ER" to "Eritrea",
    "ES" to "Spanien",
    "ET" to "Etiopien",
    "EU" to "Den Europæiske Union",
    "EZ" to "eurozonen",
    "FI" to "Finland",
    "FJ" to "Fiji",
    "FK" to "Falklandsøerne",
    "FM" to "Mikronesien",
    "FO" to "Færøerne",
    "FR" to "Frankrig",
    "GA" to "Gabon",
    "GB" to "Storbritannien",
    "GD" to "Grenada",
    "GE" to "Georgien",
    "GF" to "Fransk Guyana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Grønland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Ækvatorialguinea",
    "GR" to "Grækenland",
    "GS" to "South Georgia og De Sydlige Sandwichøer",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "SAR Hongkong",
    "HM" to "Heard Island og McDonald Islands",
    "HN" to "Honduras",
    "HR" to "Kroatien",
    "HT" to "Haiti",
    "HU" to "Ungarn",
    "IC" to "Kanariske øer",
    "ID" to "Indonesien",
    "IE" to "Irland",
    "IL" to "Israel",
    "IM" to "Isle of Man",
    "IN" to "Indien",
    "IO" to "Det Britiske Territorium i Det Indiske Ocean",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Island",
    "IT" to "Italien",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenya",
    "KG" to "Kirgisistan",
    "KH" to "Cambodja",
    "KI" to "Kiribati",
    "KM" to "Comorerne",
    "KN" to "Saint Kitts og Nevis",
    "KP" to "Nordkorea",
    "KR" to "Sydkorea",
    "KW" to "Kuwait",
    "KY" to "Caymanøerne",
    "KZ" to "Kasakhstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Litauen",
    "LU" to "Luxembourg",
    "LV" to "Letland",
    "LY" to "Libyen",
    "MA" to "Marokko",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "Saint Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshalløerne",
    "MK" to "Nordmakedonien",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongoliet",
    "MO" to "SAR Macao",
    "MP" to "Nordmarianerne",
    "MQ" to "Martinique",
    "MR" to "Mauretanien",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldiverne",
    "MW" to "Malawi",
    "MX" to "Mexico",
    "MY" to "Malaysia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "Ny Kaledonien",
    "NE" to "Niger",
    "NF" to "Norfolk Island",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Nederlandene",
    "NO" to "Norge",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "New Zealand",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Fransk Polynesien",
    "PG" to "Papua Ny Guinea",
    "PH" to "Filippinerne",
    "PK" to "Pakistan",
    "PL" to "Polen",
    "PM" to "Saint Pierre og Miquelon",
    "PN" to "Pitcairn",
    "PR" to "Puerto Rico",
    "PS" to "De palæstinensiske områder",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Ydre Oceanien",
    "RE" to "Réunion",
    "RO" to "Rumænien",
    "RS" to "Serbien",
    "RU" to "Rusland",
    "RW" to "Rwanda",
    "SA" to "Saudi-Arabien",
    "SB" to "Salomonøerne",
    "SC" to "Seychellerne",
    "SD" to "Sudan",
    "SE" to "Sverige",
    "SG" to "Singapore",
    "SH" to "St. Helena",
    "SI" to "Slovenien",
    "SJ" to "Svalbard og Jan Mayen",
    "SK" to "Slovakiet",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Surinam",
    "SS" to "Sydsudan",
    "ST" to "São Tomé og Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syrien",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks- og Caicosøerne",
    "TD" to "Tchad",
    "TF" to "De Franske Besiddelser i Det Sydlige Indiske Ocean og Antarktis",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tadsjikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunesien",
    "TO" to "Tonga",
    "TR" to "Tyrkiet",
    "TT" to "Trinidad og Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraine",
    "UG" to "Uganda",
    "UM" to "Amerikanske oversøiske øer",
    "UN" to "De Forenede Nationer",
    "US" to "USA",
    "UY" to "Uruguay",
    "UZ" to "Usbekistan",
    "VA" to "Vatikanstaten",
    "VC" to "Saint Vincent og Grenadinerne",
    "VE" to "Venezuela",
    "VG" to "De Britiske Jomfruøer",
    "VI" to "De Amerikanske Jomfruøer",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis og Futuna",
    "WS" to "Samoa",
    "XA" to "pseudo-accenter",
    "XB" to "pseudo-bidi",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "Sydafrika",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Ukendt område",
  ) }

  val da_GL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val dav: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Falme za Kiarabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AR" to "Ajentina",
    "AS" to "Samoa ya Marekani",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AZ" to "Azabajani",
    "BA" to "Bosnia na Hezegovina",
    "BB" to "Babadosi",
    "BD" to "Bangladeshi",
    "BE" to "Ubelgiji",
    "BF" to "Bukinafaso",
    "BG" to "Bulgaria",
    "BH" to "Bahareni",
    "BI" to "Burundi",
    "BJ" to "Benini",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BR" to "Brazili",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botswana",
    "BY" to "Belarusi",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CD" to "Jamhuri ya Kidemokrasia ya Kongo",
    "CF" to "Jamhuri ya Afrika ya Kati",
    "CG" to "Kongo",
    "CH" to "Uswisi",
    "CI" to "Kodivaa",
    "CK" to "Visiwa vya Cook",
    "CL" to "Chile",
    "CM" to "Kameruni",
    "CN" to "China",
    "CO" to "Kolombia",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Kepuvede",
    "CY" to "Kuprosi",
    "CZ" to "Jamhuri ya Cheki",
    "DE" to "Ujerumani",
    "DJ" to "Jibuti",
    "DK" to "Denmaki",
    "DM" to "Dominika",
    "DO" to "Jamhuri ya Dominika",
    "DZ" to "Aljeria",
    "EC" to "Ekwado",
    "EE" to "Estonia",
    "EG" to "Misri",
    "ER" to "Eritrea",
    "ES" to "Hispania",
    "ET" to "Uhabeshi",
    "FI" to "Ufini",
    "FJ" to "Fiji",
    "FK" to "Visiwa vya Falkland",
    "FM" to "Mikronesia",
    "FR" to "Ufaransa",
    "GA" to "Gaboni",
    "GB" to "Uingereza",
    "GD" to "Grenada",
    "GE" to "Jojia",
    "GF" to "Gwiyana ya Ufaransa",
    "GH" to "Ghana",
    "GI" to "Jibralta",
    "GL" to "Grinlandi",
    "GM" to "Gambia",
    "GN" to "Gine",
    "GP" to "Gwadelupe",
    "GQ" to "Ginekweta",
    "GR" to "Ugiriki",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Hondurasi",
    "HR" to "Korasia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "ID" to "Indonesia",
    "IE" to "Ayalandi",
    "IL" to "Israeli",
    "IN" to "India",
    "IQ" to "Iraki",
    "IR" to "Uajemi",
    "IS" to "Aislandi",
    "IT" to "Italia",
    "JM" to "Jamaika",
    "JO" to "Yordani",
    "JP" to "Japani",
    "KE" to "Kenya",
    "KG" to "Kirigizistani",
    "KH" to "Kambodia",
    "KI" to "Kiribati",
    "KM" to "Komoro",
    "KN" to "Santakitzi na Nevis",
    "KP" to "Korea Kaskazini",
    "KR" to "Korea Kusini",
    "KW" to "Kuwaiti",
    "KY" to "Visiwa vya Kayman",
    "KZ" to "Kazakistani",
    "LA" to "Laosi",
    "LB" to "Lebanoni",
    "LC" to "Santalusia",
    "LI" to "Lishenteni",
    "LK" to "Sirilanka",
    "LR" to "Liberia",
    "LS" to "Lesoto",
    "LT" to "Litwania",
    "LU" to "Lasembagi",
    "LV" to "Lativia",
    "LY" to "Libya",
    "MA" to "Moroko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "MG" to "Bukini",
    "MH" to "Visiwa vya Marshal",
    "ML" to "Mali",
    "MM" to "Myama",
    "MN" to "Mongolia",
    "MP" to "Visiwa vya Mariana vya Kaskazini",
    "MQ" to "Martiniki",
    "MR" to "Moritania",
    "MS" to "Montserrati",
    "MT" to "Malta",
    "MU" to "Morisi",
    "MV" to "Modivu",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malesia",
    "MZ" to "Msumbiji",
    "NA" to "Namibia",
    "NC" to "Nyukaledonia",
    "NE" to "Nijeri",
    "NF" to "Kisiwa cha Norfok",
    "NG" to "Nijeria",
    "NI" to "Nikaragwa",
    "NL" to "Uholanzi",
    "NO" to "Norwe",
    "NP" to "Nepali",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nyuzilandi",
    "OM" to "Omani",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia ya Ufaransa",
    "PG" to "Papua",
    "PH" to "Filipino",
    "PK" to "Pakistani",
    "PL" to "Polandi",
    "PM" to "Santapieri na Mikeloni",
    "PN" to "Pitkairni",
    "PR" to "Pwetoriko",
    "PS" to "Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina",
    "PT" to "Ureno",
    "PW" to "Palau",
    "PY" to "Paragwai",
    "QA" to "Katari",
    "RE" to "Riyunioni",
    "RO" to "Romania",
    "RU" to "Urusi",
    "RW" to "Rwanda",
    "SA" to "Saudi",
    "SB" to "Visiwa vya Solomon",
    "SC" to "Shelisheli",
    "SD" to "Sudani",
    "SE" to "Uswidi",
    "SG" to "Singapoo",
    "SH" to "Santahelena",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SL" to "Siera Leoni",
    "SM" to "Samarino",
    "SN" to "Senegali",
    "SO" to "Somalia",
    "SR" to "Surinamu",
    "ST" to "Sao Tome na Principe",
    "SV" to "Elsavado",
    "SY" to "Siria",
    "SZ" to "Uswazi",
    "TC" to "Visiwa vya Turki na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tailandi",
    "TJ" to "Tajikistani",
    "TK" to "Tokelau",
    "TL" to "Timori ya Mashariki",
    "TM" to "Turukimenistani",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Uturuki",
    "TT" to "Trinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tanzania",
    "UA" to "Ukraini",
    "UG" to "Uganda",
    "US" to "Marekani",
    "UY" to "Urugwai",
    "UZ" to "Uzibekistani",
    "VA" to "Vatikani",
    "VC" to "Santavisenti na Grenadini",
    "VE" to "Venezuela",
    "VG" to "Visiwa vya Virgin vya Uingereza",
    "VI" to "Visiwa vya Virgin vya Marekani",
    "VN" to "Vietinamu",
    "VU" to "Vanuatu",
    "WF" to "Walis na Futuna",
    "WS" to "Samoa",
    "YE" to "Yemeni",
    "YT" to "Mayotte",
    "ZA" to "Afrika Kusini",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
  ) }

  val de: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Welt",
    "002" to "Afrika",
    "003" to "Nordamerika",
    "005" to "Südamerika",
    "009" to "Ozeanien",
    "011" to "Westafrika",
    "013" to "Mittelamerika",
    "014" to "Ostafrika",
    "015" to "Nordafrika",
    "017" to "Zentralafrika",
    "018" to "Südliches Afrika",
    "019" to "Amerika",
    "021" to "Nördliches Amerika",
    "029" to "Karibik",
    "030" to "Ostasien",
    "034" to "Südasien",
    "035" to "Südostasien",
    "039" to "Südeuropa",
    "053" to "Australasien",
    "054" to "Melanesien",
    "057" to "Mikronesisches Inselgebiet",
    "061" to "Polynesien",
    "142" to "Asien",
    "143" to "Zentralasien",
    "145" to "Westasien",
    "150" to "Europa",
    "151" to "Osteuropa",
    "154" to "Nordeuropa",
    "155" to "Westeuropa",
    "202" to "Subsahara-Afrika",
    "419" to "Lateinamerika",
    "AC" to "Ascension",
    "AD" to "Andorra",
    "AE" to "Vereinigte Arabische Emirate",
    "AF" to "Afghanistan",
    "AG" to "Antigua und Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albanien",
    "AM" to "Armenien",
    "AO" to "Angola",
    "AQ" to "Antarktis",
    "AR" to "Argentinien",
    "AS" to "Amerikanisch-Samoa",
    "AT" to "Österreich",
    "AU" to "Australien",
    "AW" to "Aruba",
    "AX" to "Ålandinseln",
    "AZ" to "Aserbaidschan",
    "BA" to "Bosnien und Herzegowina",
    "BB" to "Barbados",
    "BD" to "Bangladesch",
    "BE" to "Belgien",
    "BF" to "Burkina Faso",
    "BG" to "Bulgarien",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei Darussalam",
    "BO" to "Bolivien",
    "BQ" to "Karibische Niederlande",
    "BR" to "Brasilien",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Bouvetinsel",
    "BW" to "Botsuana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kokosinseln",
    "CD" to "Kongo-Kinshasa",
    "CF" to "Zentralafrikanische Republik",
    "CG" to "Kongo-Brazzaville",
    "CH" to "Schweiz",
    "CI" to "Côte d’Ivoire",
    "CK" to "Cookinseln",
    "CL" to "Chile",
    "CM" to "Kamerun",
    "CN" to "China",
    "CO" to "Kolumbien",
    "CP" to "Clipperton-Insel",
    "CR" to "Costa Rica",
    "CU" to "Kuba",
    "CV" to "Cabo Verde",
    "CW" to "Curaçao",
    "CX" to "Weihnachtsinsel",
    "CY" to "Zypern",
    "CZ" to "Tschechien",
    "DE" to "Deutschland",
    "DG" to "Diego Garcia",
    "DJ" to "Dschibuti",
    "DK" to "Dänemark",
    "DM" to "Dominica",
    "DO" to "Dominikanische Republik",
    "DZ" to "Algerien",
    "EA" to "Ceuta und Melilla",
    "EC" to "Ecuador",
    "EE" to "Estland",
    "EG" to "Ägypten",
    "EH" to "Westsahara",
    "ER" to "Eritrea",
    "ES" to "Spanien",
    "ET" to "Äthiopien",
    "EU" to "Europäische Union",
    "EZ" to "Eurozone",
    "FI" to "Finnland",
    "FJ" to "Fidschi",
    "FK" to "Falklandinseln",
    "FM" to "Mikronesien",
    "FO" to "Färöer",
    "FR" to "Frankreich",
    "GA" to "Gabun",
    "GB" to "Vereinigtes Königreich",
    "GD" to "Grenada",
    "GE" to "Georgien",
    "GF" to "Französisch-Guayana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Grönland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Äquatorialguinea",
    "GR" to "Griechenland",
    "GS" to "Südgeorgien und die Südlichen Sandwichinseln",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Sonderverwaltungsregion Hongkong",
    "HM" to "Heard und McDonaldinseln",
    "HN" to "Honduras",
    "HR" to "Kroatien",
    "HT" to "Haiti",
    "HU" to "Ungarn",
    "IC" to "Kanarische Inseln",
    "ID" to "Indonesien",
    "IE" to "Irland",
    "IL" to "Israel",
    "IM" to "Isle of Man",
    "IN" to "Indien",
    "IO" to "Britisches Territorium im Indischen Ozean",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Island",
    "IT" to "Italien",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Jordanien",
    "JP" to "Japan",
    "KE" to "Kenia",
    "KG" to "Kirgisistan",
    "KH" to "Kambodscha",
    "KI" to "Kiribati",
    "KM" to "Komoren",
    "KN" to "St. Kitts und Nevis",
    "KP" to "Nordkorea",
    "KR" to "Südkorea",
    "KW" to "Kuwait",
    "KY" to "Kaimaninseln",
    "KZ" to "Kasachstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "St. Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Litauen",
    "LU" to "Luxemburg",
    "LV" to "Lettland",
    "LY" to "Libyen",
    "MA" to "Marokko",
    "MC" to "Monaco",
    "MD" to "Republik Moldau",
    "ME" to "Montenegro",
    "MF" to "St. Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshallinseln",
    "MK" to "Nordmazedonien",
    "ML" to "Mali",
    "MM" to "Myanmar",
    "MN" to "Mongolei",
    "MO" to "Sonderverwaltungsregion Macau",
    "MP" to "Nördliche Marianen",
    "MQ" to "Martinique",
    "MR" to "Mauretanien",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Malediven",
    "MW" to "Malawi",
    "MX" to "Mexiko",
    "MY" to "Malaysia",
    "MZ" to "Mosambik",
    "NA" to "Namibia",
    "NC" to "Neukaledonien",
    "NE" to "Niger",
    "NF" to "Norfolkinsel",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Niederlande",
    "NO" to "Norwegen",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Neuseeland",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Französisch-Polynesien",
    "PG" to "Papua-Neuguinea",
    "PH" to "Philippinen",
    "PK" to "Pakistan",
    "PL" to "Polen",
    "PM" to "St. Pierre und Miquelon",
    "PN" to "Pitcairninseln",
    "PR" to "Puerto Rico",
    "PS" to "Palästinensische Autonomiegebiete",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Katar",
    "QO" to "Äußeres Ozeanien",
    "RE" to "Réunion",
    "RO" to "Rumänien",
    "RS" to "Serbien",
    "RU" to "Russland",
    "RW" to "Ruanda",
    "SA" to "Saudi-Arabien",
    "SB" to "Salomonen",
    "SC" to "Seychellen",
    "SD" to "Sudan",
    "SE" to "Schweden",
    "SG" to "Singapur",
    "SH" to "St. Helena",
    "SI" to "Slowenien",
    "SJ" to "Spitzbergen und Jan Mayen",
    "SK" to "Slowakei",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "Südsudan",
    "ST" to "São Tomé und Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syrien",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks- und Caicosinseln",
    "TD" to "Tschad",
    "TF" to "Französische Süd- und Antarktisgebiete",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tadschikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunesien",
    "TO" to "Tonga",
    "TR" to "Türkei",
    "TT" to "Trinidad und Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tansania",
    "UA" to "Ukraine",
    "UG" to "Uganda",
    "UM" to "Amerikanische Überseeinseln",
    "UN" to "Vereinte Nationen",
    "US" to "Vereinigte Staaten",
    "UY" to "Uruguay",
    "UZ" to "Usbekistan",
    "VA" to "Vatikanstadt",
    "VC" to "St. Vincent und die Grenadinen",
    "VE" to "Venezuela",
    "VG" to "Britische Jungferninseln",
    "VI" to "Amerikanische Jungferninseln",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis und Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo-Akzente",
    "XB" to "Pseudo-Bidi",
    "XK" to "Kosovo",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Südafrika",
    "ZM" to "Sambia",
    "ZW" to "Simbabwe",
    "ZZ" to "Unbekannte Region",
  ) }

  val de_AT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "SJ" to "Svalbard und Jan Mayen",
  ) }

  val de_BE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val de_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BN" to "Brunei",
    "BW" to "Botswana",
    "CV" to "Kapverden",
    "QO" to "Äusseres Ozeanien",
    "SB" to "Salomon-Inseln",
    "TL" to "Osttimor",
    "ZW" to "Zimbabwe",
  ) }

  val de_IT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val de_LI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val de_LU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val dje: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andoora",
    "AE" to "Laaraw Imaarawey Margantey",
    "AF" to "Afgaanistan",
    "AG" to "Antigua nda Barbuuda",
    "AI" to "Angiiya",
    "AL" to "Albaani",
    "AM" to "Armeeni",
    "AO" to "Angoola",
    "AR" to "Argentine",
    "AS" to "Ameriki Samoa",
    "AT" to "Otriši",
    "AU" to "Ostraali",
    "AW" to "Aruuba",
    "AZ" to "Azerbaayijaŋ",
    "BA" to "Bosni nda Herzegovine",
    "BB" to "Barbaados",
    "BD" to "Bangladeši",
    "BE" to "Belgiiki",
    "BF" to "Burkina faso",
    "BG" to "Bulgaari",
    "BH" to "Bahareen",
    "BI" to "Burundi",
    "BJ" to "Beniŋ",
    "BM" to "Bermuda",
    "BN" to "Bruunee",
    "BO" to "Boolivi",
    "BR" to "Breezil",
    "BS" to "Bahamas",
    "BT" to "Buutaŋ",
    "BW" to "Botswaana",
    "BY" to "Biloriši",
    "BZ" to "Beliizi",
    "CA" to "Kanaada",
    "CD" to "Kongoo demookaratiki laboo",
    "CF" to "Centraafriki koyra",
    "CG" to "Kongoo",
    "CH" to "Swisu",
    "CI" to "Kudwar",
    "CK" to "Kuuk gungey",
    "CL" to "Šiili",
    "CM" to "Kameruun",
    "CN" to "Šiin",
    "CO" to "Kolombi",
    "CR" to "Kosta rika",
    "CU" to "Kuuba",
    "CV" to "Kapuver gungey",
    "CY" to "Šiipur",
    "CZ" to "Cek labo",
    "DE" to "Almaaɲe",
    "DJ" to "Jibuuti",
    "DK" to "Danemark",
    "DO" to "Doominiki laboo",
    "DZ" to "Alžeeri",
    "EC" to "Ekwateer",
    "EE" to "Estooni",
    "EG" to "Misra",
    "ER" to "Eritree",
    "ES" to "Espaaɲe",
    "ET" to "Ecioopi",
    "FI" to "Finlandu",
    "FJ" to "Fiji",
    "FK" to "Kalkan gungey",
    "FM" to "Mikronezi",
    "FR" to "Faransi",
    "GA" to "Gaabon",
    "GB" to "Albaasalaama Marganta",
    "GD" to "Grenaada",
    "GE" to "Gorgi",
    "GF" to "Faransi Guyaan",
    "GH" to "Gaana",
    "GI" to "Gibraltar",
    "GL" to "Grinland",
    "GM" to "Gambi",
    "GN" to "Gine",
    "GP" to "Gwadeluup",
    "GQ" to "Ginee Ekwatorial",
    "GR" to "Greece",
    "GT" to "Gwatemaala",
    "GU" to "Guam",
    "GW" to "Gine-Bisso",
    "GY" to "Guyaane",
    "HN" to "Honduras",
    "HR" to "Krwaasi",
    "HT" to "Haiti",
    "HU" to "Hungaari",
    "ID" to "Indoneezi",
    "IE" to "Irlandu",
    "IL" to "Israyel",
    "IN" to "Indu laboo",
    "IQ" to "Iraak",
    "IR" to "Iraan",
    "IS" to "Ayseland",
    "IT" to "Itaali",
    "JM" to "Jamaayik",
    "JO" to "Urdun",
    "JP" to "Jaapoŋ",
    "KE" to "Keeniya",
    "KG" to "Kyrgyzstan",
    "KH" to "kamboogi",
    "KI" to "Kiribaati",
    "KM" to "Komoor",
    "KN" to "Seŋ Kitts nda Nevis",
    "KP" to "Gurma Kooree",
    "KR" to "Hawsa Kooree",
    "KW" to "Kuweet",
    "KY" to "Kayman gungey",
    "KZ" to "Kaazakstan",
    "LA" to "Laawos",
    "LB" to "Lubnaan",
    "LC" to "Seŋ Lussia",
    "LI" to "Liechtenstein",
    "LK" to "Srilanka",
    "LR" to "Liberia",
    "LS" to "Leesoto",
    "LT" to "Lituaani",
    "LU" to "Luxembourg",
    "LV" to "Letooni",
    "LY" to "Liibi",
    "MA" to "Maarok",
    "MC" to "Monako",
    "MD" to "Moldovi",
    "MG" to "Madagascar",
    "MH" to "Maršal gungey",
    "ML" to "Maali",
    "MM" to "Maynamar",
    "MN" to "Mongooli",
    "MP" to "Mariana Gurma Gungey",
    "MQ" to "Martiniiki",
    "MR" to "Mooritaani",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mooris gungey",
    "MV" to "Maldiivu",
    "MW" to "Malaawi",
    "MX" to "Mexiki",
    "MY" to "Maleezi",
    "MZ" to "Mozambik",
    "NA" to "Naamibi",
    "NC" to "Kaaledooni Taagaa",
    "NE" to "Nižer",
    "NF" to "Norfolk Gungoo",
    "NG" to "Naajiriia",
    "NI" to "Nikaragwa",
    "NL" to "Hollandu",
    "NO" to "Norveej",
    "NP" to "Neepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Zeelandu Taaga",
    "OM" to "Omaan",
    "PA" to "Panama",
    "PE" to "Peeru",
    "PF" to "Faransi Polineezi",
    "PG" to "Papua Ginee Taaga",
    "PH" to "Filipine",
    "PK" to "Paakistan",
    "PL" to "Poloɲe",
    "PM" to "Seŋ Piyer nda Mikelon",
    "PN" to "Pitikarin",
    "PR" to "Porto Riko",
    "PS" to "Palestine Dangay nda Gaaza",
    "PT" to "Portugaal",
    "PW" to "Palu",
    "PY" to "Paraguwey",
    "QA" to "Kataar",
    "RE" to "Reenioŋ",
    "RO" to "Rumaani",
    "RU" to "Iriši laboo",
    "RW" to "Rwanda",
    "SA" to "Saudiya",
    "SB" to "Solomon Gungey",
    "SC" to "Seešel",
    "SD" to "Suudaŋ",
    "SE" to "Sweede",
    "SG" to "Singapur",
    "SH" to "Seŋ Helena",
    "SI" to "Sloveeni",
    "SK" to "Slovaaki",
    "SL" to "Seera Leon",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somaali",
    "SR" to "Surinaam",
    "ST" to "Sao Tome nda Prinsipe",
    "SV" to "Salvador laboo",
    "SY" to "Suuria",
    "SZ" to "Swaziland",
    "TC" to "Turk nda Kayikos Gungey",
    "TD" to "Caadu",
    "TG" to "Togo",
    "TH" to "Taayiland",
    "TJ" to "Taažikistan",
    "TK" to "Tokelau",
    "TL" to "Timoor hawsa",
    "TM" to "Turkmenistaŋ",
    "TN" to "Tunizi",
    "TO" to "Tonga",
    "TR" to "Turki",
    "TT" to "Trinidad nda Tobaago",
    "TV" to "Tuvalu",
    "TW" to "Taayiwan",
    "TZ" to "Tanzaani",
    "UA" to "Ukreen",
    "UG" to "Uganda",
    "US" to "Ameriki Laabu Margantey",
    "UY" to "Uruguwey",
    "UZ" to "Uzbeekistan",
    "VA" to "Vaatikan Laama",
    "VC" to "Seŋvinsaŋ nda Grenadine",
    "VE" to "Veneezuyeela",
    "VG" to "Britiši Virgin gungey",
    "VI" to "Ameerik Virgin Gungey",
    "VN" to "Vietnaam",
    "VU" to "Vanautu",
    "WF" to "Wallis nda Futuna",
    "WS" to "Samoa",
    "YE" to "Yaman",
    "YT" to "Mayooti",
    "ZA" to "Hawsa Afriki Laboo",
    "ZM" to "Zambi",
    "ZW" to "Zimbabwe",
  ) }

  val doi: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BR" to "ब्राजील",
    "CN" to "चीन",
    "DE" to "जर्मनी",
    "FR" to "फ्रांस",
    "GB" to "यूनाइटेड किंगडम",
    "IN" to "भारत",
    "IT" to "इटली",
    "JP" to "जापान",
    "RU" to "रूस",
    "US" to "यूएस",
    "ZZ" to "अनजांता खेत्तर",
  ) }

  val dsb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "swět",
    "002" to "Afrika",
    "003" to "Pódpołnocna Amerika",
    "005" to "Pódpołdnjowa Amerika",
    "009" to "Oceaniska",
    "011" to "Pódwjacorna Afrika",
    "013" to "Srjejźna Amerika",
    "014" to "pódzajtšna Afrika",
    "015" to "pódpołnocna Afrika",
    "017" to "srjejźna Afrika",
    "018" to "pódpołdnjowa Afrika",
    "019" to "Amerika",
    "021" to "pódpołnocny ameriski kontinent",
    "029" to "Karibiska",
    "030" to "pódzajtšna Azija",
    "034" to "pódpołdnjowa Azija",
    "035" to "krotkozajtšna Azija",
    "039" to "pódpołdnjowa Europa",
    "053" to "Awstralazija",
    "054" to "Melaneziska",
    "057" to "Mikroneziska (kupowy region)",
    "061" to "Polyneziska",
    "142" to "Azija",
    "143" to "centralna Azija",
    "145" to "pódwjacorna Azija",
    "150" to "Europa",
    "151" to "pódzajtšna Europa",
    "154" to "pódpołnocna Europa",
    "155" to "pódwjacorna Europa",
    "202" to "subsaharojska Afrika",
    "419" to "Łatyńska Amerika",
    "AC" to "Ascension",
    "AD" to "Andorra",
    "AE" to "Zjadnośone arabiske emiraty",
    "AF" to "Afghanistan",
    "AG" to "Antigua a Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albańska",
    "AM" to "Armeńska",
    "AO" to "Angola",
    "AQ" to "Antarktis",
    "AR" to "Argentinska",
    "AS" to "Ameriska Samoa",
    "AT" to "Awstriska",
    "AU" to "Awstralska",
    "AW" to "Aruba",
    "AX" to "Åland",
    "AZ" to "Azerbajdžan",
    "BA" to "Bosniska a Hercegowina",
    "BB" to "Barbados",
    "BD" to "Bangladeš",
    "BE" to "Belgiska",
    "BF" to "Burkina Faso",
    "BG" to "Bulgarska",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthélemy",
    "BM" to "Bermudy",
    "BN" to "Brunei",
    "BO" to "Boliwiska",
    "BQ" to "Karibiska Nižozemska",
    "BR" to "Brazilska",
    "BS" to "Bahamy",
    "BT" to "Bhutan",
    "BV" to "Bouvetowa kupa",
    "BW" to "Botswana",
    "BY" to "Běłoruska",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kokosowe kupy",
    "CD" to "Kongo-Kinshasa",
    "CF" to "Centralnoafriska republika",
    "CG" to "Kongo-Brazzaville",
    "CH" to "Šwicarska",
    "CI" to "Côte d’Ivoire",
    "CK" to "Cookowe kupy",
    "CL" to "Chilska",
    "CM" to "Kamerun",
    "CN" to "China",
    "CO" to "Kolumbiska",
    "CP" to "Clippertonowa kupa",
    "CR" to "Kosta Rika",
    "CU" to "Kuba",
    "CV" to "Kap Verde",
    "CW" to "Curaçao",
    "CX" to "Gódowne kupy",
    "CY" to "Cypriska",
    "CZ" to "Česka republika",
    "DE" to "Nimska",
    "DG" to "Diego Garcia",
    "DJ" to "Džibuti",
    "DK" to "Dańska",
    "DM" to "Dominika",
    "DO" to "Dominikańska republika",
    "DZ" to "Algeriska",
    "EA" to "Ceuta a Melilla",
    "EC" to "Ekwador",
    "EE" to "Estniska",
    "EG" to "Egyptojska",
    "EH" to "Pódwjacorna Sahara",
    "ER" to "Eritreja",
    "ES" to "Špańska",
    "ET" to "Etiopiska",
    "EU" to "Europska unija",
    "EZ" to "europasmo",
    "FI" to "Finska",
    "FJ" to "Fidži",
    "FK" to "Falklandske kupy",
    "FM" to "Mikroneziska",
    "FO" to "Färöje",
    "FR" to "Francojska",
    "GA" to "Gabun",
    "GB" to "Zjadnośone kralejstwo",
    "GD" to "Grenada",
    "GE" to "Georgiska",
    "GF" to "Francojska Guyana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Grönlandska",
    "GM" to "Gambija",
    "GN" to "Gineja",
    "GP" to "Guadeloupe",
    "GQ" to "Ekwatorialna Gineja",
    "GR" to "Grichiska",
    "GS" to "Pódpołdnjowa Georgiska a Pódpołdnjowe Sandwichowe kupy",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Gineja-Bissau",
    "GY" to "Guyana",
    "HK" to "Wósebna zastojnstwowa cona Hongkong",
    "HM" to "Heardowa kupa a McDonaldowe kupy",
    "HN" to "Honduras",
    "HR" to "Chorwatska",
    "HT" to "Haiti",
    "HU" to "Hungorska",
    "IC" to "Kanariske kupy",
    "ID" to "Indoneziska",
    "IE" to "Irska",
    "IL" to "Israel",
    "IM" to "Man",
    "IN" to "Indiska",
    "IO" to "Britiski indiskooceaniski teritorium",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Islandska",
    "IT" to "Italska",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Jordaniska",
    "JP" to "Japańska",
    "KE" to "Kenia",
    "KG" to "Kirgizistan",
    "KH" to "Kambodža",
    "KI" to "Kiribati",
    "KM" to "Komory",
    "KN" to "St. Kitts a Nevis",
    "KP" to "Pódpołnocna Koreja",
    "KR" to "Pódpołdnjowa Koreja",
    "KW" to "Kuwait",
    "KY" to "Kajmaniske kupy",
    "KZ" to "Kazachstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "St. Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberija",
    "LS" to "Lesotho",
    "LT" to "Litawska",
    "LU" to "Luxemburgska",
    "LV" to "Letiska",
    "LY" to "Libyska",
    "MA" to "Marokko",
    "MC" to "Monaco",
    "MD" to "Moldawska",
    "ME" to "Carna Góra",
    "MF" to "St. Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshallowe kupy",
    "MK" to "Pódpołnocna Makedańska",
    "ML" to "Mali",
    "MM" to "Myanmar",
    "MN" to "Mongolska",
    "MO" to "Wósebna zastojnstwowa cona Macao",
    "MP" to "Pódpołnocne Mariany",
    "MQ" to "Martinique",
    "MR" to "Mawretańska",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Malediwy",
    "MW" to "Malawi",
    "MX" to "Mexiko",
    "MY" to "Malajzija",
    "MZ" to "Mosambik",
    "NA" to "Namibija",
    "NC" to "Nowa Kaledoniska",
    "NE" to "Niger",
    "NF" to "Norfolkowa kupa",
    "NG" to "Nigerija",
    "NI" to "Nikaragua",
    "NL" to "Nižozemska",
    "NO" to "Norwegska",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nowoseelandska",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Francojska Polyneziska",
    "PG" to "Papua-Neuguinea",
    "PH" to "Filipiny",
    "PK" to "Pakistan",
    "PL" to "Pólska",
    "PM" to "St. Pierre a Miquelon",
    "PN" to "Pitcairnowe kupy",
    "PR" to "Puerto Rico",
    "PS" to "Palestinski awtonomny teritorium",
    "PT" to "Portugalska",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Katar",
    "QO" to "wenkowna Oceaniska",
    "RE" to "Réunion",
    "RO" to "Rumuńska",
    "RS" to "Serbiska",
    "RU" to "Ruska",
    "RW" to "Ruanda",
    "SA" to "Saudi-Arabiska",
    "SB" to "Salomony",
    "SC" to "Seychelle",
    "SD" to "Sudan",
    "SE" to "Šwedska",
    "SG" to "Singapur",
    "SH" to "St. Helena",
    "SI" to "Słowjeńska",
    "SJ" to "Svalbard a Jan Mayen",
    "SK" to "Słowakska",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalija",
    "SR" to "Surinamska",
    "SS" to "Pódpołdnjowy Sudan",
    "ST" to "São Tomé a Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syriska",
    "SZ" to "Swasiska",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks a Caicos kupy",
    "TD" to "Čad",
    "TF" to "Francojski pódpołdnjowy a antarktiski teritorium",
    "TG" to "Togo",
    "TH" to "Thailandska",
    "TJ" to "Tadźikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmeniska",
    "TN" to "Tuneziska",
    "TO" to "Tonga",
    "TR" to "Turkojska",
    "TT" to "Trinidad a Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tansanija",
    "UA" to "Ukraina",
    "UG" to "Uganda",
    "UM" to "Ameriska Oceaniska",
    "UN" to "Zjadnośone narody",
    "US" to "Zjadnośone staty Ameriki",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Vatikańske město",
    "VC" to "St. Vincent a Grenadiny",
    "VE" to "Venezuela",
    "VG" to "Britiske kněžniske kupy",
    "VI" to "Ameriske kněžniske kupy",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis a Futuna",
    "WS" to "Samoa",
    "XA" to "pseudo-akcenty",
    "XB" to "pseudo-bidi",
    "XK" to "Kosowo",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Pódpołdnjowa Afrika (Republika)",
    "ZM" to "Sambija",
    "ZW" to "Simbabwe",
    "ZZ" to "njeznaty region",
  ) }

  val dua: ImmutableMap<String, String> by lazy { immutableMapOf(
    "CM" to "Cameroun",
  ) }

  val dyo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andorra",
    "AF" to "Afganistan",
    "AG" to "Antigua di Barbuda",
    "AI" to "Angiiya",
    "AL" to "Albani",
    "AM" to "Armeni",
    "AO" to "Angola",
    "AR" to "Arsantin",
    "AS" to "Samoa yati Amerik",
    "AT" to "Otris",
    "AU" to "Ostraalia",
    "AW" to "Aruba",
    "AZ" to "Aserbaysan",
    "BA" to "Bosni di Hersegovin",
    "BB" to "Barbad",
    "BD" to "Banglades",
    "BE" to "Belsik",
    "BF" to "Burukiina Faso",
    "BG" to "Bulgari",
    "BH" to "Bahrayn",
    "BI" to "Burundi",
    "BJ" to "Bene",
    "BM" to "Bermud",
    "BN" to "Buruney",
    "BO" to "Boliivi",
    "BR" to "Bresil",
    "BS" to "Bahama",
    "BT" to "Butan",
    "BW" to "Boswana",
    "BY" to "Belarus",
    "BZ" to "Beliis",
    "CA" to "Kanada",
    "CD" to "Mofam demokratik mati Kongo",
    "CG" to "Kongo",
    "CI" to "Koddiwar",
    "CL" to "Cili",
    "CM" to "Kamerun",
    "CN" to "Siin",
    "CO" to "Kolombi",
    "CR" to "Kosta Rika",
    "CU" to "Kuba",
    "CV" to "Kap Ver",
    "CY" to "Siipr",
    "CZ" to "Mofam mati Cek",
    "DE" to "Almaañ",
    "DJ" to "Jibuti",
    "DK" to "Danmark",
    "DM" to "Dominika",
    "DO" to "Mofam mati Dominik",
    "DZ" to "Alseri",
    "EC" to "Ekuador",
    "EE" to "Estoni",
    "EG" to "Esípt",
    "ER" to "Eritree",
    "ES" to "Espaañ",
    "ET" to "Ecoopi",
    "FI" to "Finland",
    "FJ" to "Fiji",
    "FR" to "Frans",
    "GA" to "Gabon",
    "GD" to "Grenada",
    "GE" to "Seorsi",
    "GH" to "Gaana",
    "GI" to "Sipraltaar",
    "GL" to "Greenland",
    "GM" to "Gambi",
    "GN" to "Giné",
    "GP" to "Guwadalup",
    "GR" to "Gres",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Giné Bisaau",
    "GY" to "Giyan",
    "HN" to "Onduras",
    "HR" to "Kroasi",
    "HT" to "Ayti",
    "HU" to "Oŋri",
    "ID" to "Endonesi",
    "IE" to "Irland",
    "IL" to "Israel",
    "IN" to "End",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Iisland",
    "IT" to "Itali",
    "JM" to "Samaik",
    "JP" to "Sapoŋ",
    "KE" to "Keniya",
    "KH" to "Kamboj",
    "KM" to "Komor",
    "LC" to "Saŋ Lusia",
    "LK" to "Siri Lanka",
    "LR" to "Liberia",
    "MG" to "Madagaskaar",
    "ML" to "Mali",
    "NF" to "Ecinkey yati Noorfok",
    "SA" to "Abari Saudi",
    "SD" to "Sudan",
    "SG" to "Singapur",
    "SI" to "Sloveni",
    "SK" to "Slovaki",
    "SL" to "Serra Leon",
    "SN" to "Senegal",
    "SO" to "Somali",
    "SV" to "Salvadoor",
    "TD" to "Cad",
    "TG" to "Togo",
    "TH" to "Tailand",
  ) }

  val dz: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "འཛམ་གླིང༌",
    "002" to "ཨཕ་རི་ཀ",
    "003" to "བྱང་ཨ་མི་རི་ཀ",
    "005" to "ལྷོ་ཨ་མི་རི་ཀ",
    "009" to "ཨོཤི་ཡཱན་ན",
    "011" to "ནུབ་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ",
    "013" to "བར་ཕྱོགས་ཨ་མི་རི་ཀ",
    "014" to "ཤར་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ",
    "015" to "བྱང་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ",
    "017" to "སྦུག་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ",
    "018" to "ལྷོའི་ཨཕ་རི་ཀ",
    "019" to "ཨ་མི་རི་ཀ་ཚུ",
    "021" to "བྱང་ཕྱོགས་ཀྱི་ཨ་མི་རི་ཀ",
    "029" to "ཀེ་རི་བི་ཡེན",
    "030" to "ཤར་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ",
    "034" to "ལྷོའི་ཨེ་ཤི་ཡ",
    "035" to "ལྷོ་ཤར་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ",
    "039" to "ལྷོའི་ཡུ་རོབ",
    "053" to "ཨཱོས་ཊྲེལ་ཨེ་ཤི་ཡ",
    "054" to "མེ་ལ་ནི་ཤི་ཡ",
    "057" to "ལུང་ཕྱོགས་མའི་ཀྲོ་ནི་ཤི་ཡ",
    "061" to "པོ་ལི་ནི་ཤི་ཡ",
    "142" to "ཨེ་ཤི་ཡ",
    "143" to "སྦུག་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ",
    "145" to "ནུབ་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ",
    "150" to "ཡུ་རོབ",
    "151" to "ཤར་ཕྱོགས་ཀྱི་ཡུ་རོབ",
    "154" to "བྱང་ཕྱོགས་ཀྱི་ཡུ་རོབ",
    "155" to "ནུབ་ཕྱོགས་ཀྱི་ཡུ་རོབ",
    "419" to "ལེ་ཊིནཨ་མི་རི་ཀ",
    "AC" to "ཨེ་སེན་ཤུན་ཚོ་གླིང༌",
    "AD" to "ཨཱན་དོ་ར",
    "AE" to "ཡུ་ནཱའི་ཊེཌ་ ཨ་རབ་ ཨེ་མེ་རེཊས",
    "AF" to "ཨཕ་གྷ་ནི་སཏཱན",
    "AG" to "ཨན་ཊི་གུ་ཝ་ ཨེནཌ་ བྷར་བྷུ་ཌ",
    "AI" to "ཨང་གི་ལ",
    "AL" to "ཨཱལ་བེ་ནི་ཡ",
    "AM" to "ཨར་མི་ནི་ཡ",
    "AO" to "ཨང་གྷོ་ལ",
    "AQ" to "འཛམ་གླིང་ལྷོ་མཐའི་ཁྱགས་གླིང",
    "AR" to "ཨར་ཇེན་ཊི་ན",
    "AS" to "ས་མོ་ཨ་ཡུ་ཨེས་ཨེ་མངའ་ཁོངས",
    "AT" to "ཨཱོས་ཊྲི་ཡ",
    "AU" to "ཨཱོས་ཊྲེལ་ལི་ཡ",
    "AW" to "ཨ་རུ་བཱ",
    "AX" to "ཨ་ལནཌ་གླིང་ཚོམ",
    "AZ" to "ཨ་ཛར་བྷའི་ཇཱན",
    "BA" to "བྷོས་ནི་ཡ་ ཨེནཌ་ ཧར་ཛི་གྷོ་བི་ན",
    "BB" to "བྷར་བེ་ཌོས",
    "BD" to "བངྒ་ལ་དེཤ",
    "BE" to "བྷེལ་ཇམ",
    "BF" to "བྷར་ཀི་ན་ ཕེ་སོ",
    "BG" to "བུལ་ག་རི་ཡ",
    "BH" to "བྷ་རེན",
    "BI" to "བྷུ་རུན་ཌི",
    "BJ" to "བྷེ་ནིན",
    "BL" to "སེནཊ་ བར་ཐོ་ལོམ་མིའུ",
    "BM" to "བར་མུ་ཌ",
    "BN" to "བྷྲུ་ནའི",
    "BO" to "བྷེ་ལི་བི་ཡ",
    "BQ" to "ཀེ་རི་བི་ཡེན་ནེ་དར་ལནཌས྄",
    "BR" to "བྲ་ཛིལ",
    "BS" to "བྷ་ཧ་མས྄",
    "BT" to "འབྲུག",
    "BV" to "བོའུ་ཝེཊ་མཚོ་གླིང",
    "BW" to "བྷོཙ་ཝ་ན",
    "BY" to "བེལ་ཨ་རུ་སུ",
    "BZ" to "བྷེ་ལིཛ",
    "CA" to "ཀེ་ན་ཌ",
    "CC" to "ཀོ་ཀོས་གླིང་ཚོམ",
    "CD" to "ཀོང་གྷོ ཀིན་ཤ་ས",
    "CF" to "སེན་ཊལ་ ཨཕ་རི་ཀཱན་ རི་པབ་ལིཀ",
    "CG" to "ཀོང་གྷོ བྷྲ་ཛ་བིལ",
    "CH" to "སུ་ཝིཊ་ཛར་ལེནཌ",
    "CI" to "ཀོ་ཊེ་ ཌི་ཨི་ཝོ་རེ",
    "CK" to "ཀུག་གླིང་ཚོམ",
    "CL" to "ཅི་ལི",
    "CM" to "ཀེ་མ་རུན",
    "CN" to "རྒྱ་ནག",
    "CO" to "ཀོ་ལོམ་བྷི་ཡ",
    "CP" to "ཀི་ལི་པེར་ཊོན་མཚོ་གླིང་",
    "CR" to "ཀོས་ཊ་རི་ཀ",
    "CU" to "ཀིའུ་བྷ",
    "CV" to "ཀེཔ་བཱཌ",
    "CW" to "ཀྱཱུར་ར་ཀོ",
    "CX" to "ཁི་རིསྟ་མེས་མཚོ་གླིང",
    "CY" to "སཱའི་པྲས",
    "CZ" to "ཅེཀ་ རི་པབ་ལིཀ",
    "DE" to "ཇཱར་མ་ནི",
    "DG" to "ཌི་ཡེ་གོ་གར་སིའོ",
    "DJ" to "ཇི་བྷུ་ཊི",
    "DK" to "ཌེན་མཱཀ",
    "DM" to "ཌོ་མི་ནི་ཀ",
    "DO" to "ཌོ་མི་ནི་ཀཱན་ རི་པབ་ལིཀ",
    "DZ" to "ཨཱལ་ཇི་རི་ཡ",
    "EA" to "སེ་ཨུ་ཏ་ ཨེནཌ་ མེལ་ལི་ལ",
    "EC" to "ཨེ་ཁྭ་ཌོར",
    "EE" to "ཨེས་ཊོ་ནི་ཡ",
    "EG" to "ཨི་ཇིབཊ",
    "EH" to "ནུབ་ཕྱོགས་ ས་ཧཱ་ར",
    "ER" to "ཨེ་རི་ཊྲེ་ཡ",
    "ES" to "ཨིས་པེན",
    "ET" to "ཨི་ཐི་ཡོ་པི་ཡ",
    "EU" to "ཡུ་རོབ་གཅིག་བསྡོམས་ཚོགས་པ",
    "FI" to "ཕིན་ལེནཌ",
    "FJ" to "ཕི་ཇི",
    "FK" to "ཕལྐ་ལནྜ་གླིང་ཚོམ",
    "FM" to "མའི་ཀྲོ་ནི་ཤི་ཡ",
    "FO" to "ཕཱའེ་རོ་གླིང་ཚོམ",
    "FR" to "ཕྲཱནས",
    "GA" to "གྷ་བྷོན",
    "GB" to "ཡུ་ནཱའི་ཊེཌ་ ཀིང་ཌམ",
    "GD" to "གྲྀ་ན་ཌ",
    "GE" to "ཇཽར་ཇཱ",
    "GF" to "གུའི་ཡ་ན་ ཕྲནས྄་མངའ་ཁོངས",
    "GG" to "གུ་ཨེརྣ་སི",
    "GH" to "གྷ་ན",
    "GI" to "ཇིབ་རཱལ་ཊར",
    "GL" to "གིརཱིན་ལནཌ྄",
    "GM" to "གྷེམ་བི་ཡ",
    "GN" to "གྷི་ནི",
    "GP" to "གོ་ཌེ་ལུ་པེ",
    "GQ" to "ཨེ་ཀུ་ཊོ་རེལ་ གི་ནི",
    "GR" to "གིརིས྄",
    "GS" to "སཱའུཐ་ཇཽར་ཇཱ་ དང་ སཱའུཐ་སེནཌ྄་ཝིཅ་གླིང་ཚོམ",
    "GT" to "གྷོ་ཊ་མ་ལ",
    "GU" to "གུ་འམ་ མཚོ་གླིང",
    "GW" to "གྷི་ནི་ བྷི་སཱའུ",
    "GY" to "གྷ་ཡ་ན",
    "HK" to "ཧོང་ཀོང་ཅཱའི་ན",
    "HM" to "ཧཱརཌ་མཚོ་གླིང་ དང་ མེཀ་ཌོ་ནལཌ྄་གླིང་ཚོམ",
    "HN" to "ཧཱན་ཌུ་རཱས྄",
    "HR" to "ཀྲོ་ཨེ་ཤ",
    "HT" to "ཧེ་ཊི",
    "HU" to "ཧཱང་གྷ་རི",
    "IC" to "ཀ་ནེ་རི་གླིང་ཚོམ",
    "ID" to "ཨིན་ཌོ་ནེ་ཤི་ཡ",
    "IE" to "ཨཱ་ཡ་ལེནཌ",
    "IL" to "ཨིས་ར་ཡེལ",
    "IM" to "ཨ་ཡུལ་ ཨོཕ་ མཱན",
    "IN" to "རྒྱ་གར",
    "IQ" to "ཨི་རཱཀ",
    "IR" to "ཨི་རཱན",
    "IS" to "ཨཱའིས་ལེནཌ",
    "IT" to "ཨི་ཊ་ལི",
    "JE" to "ཇེར་སི",
    "JM" to "ཇཱ་མཻ་ཀ",
    "JO" to "ཇོར་ཌན",
    "JP" to "ཇ་པཱན",
    "KE" to "ཀེན་ཡ",
    "KG" to "ཀིར་གིས་སཏཱན",
    "KH" to "ཀམ་བྷོ་ཌི་ཡ",
    "KI" to "ཀི་རི་བ་ཏི་མཚོ་གླིང",
    "KM" to "ཀོ་མོ་རོས",
    "KN" to "སེནཊ་ ཀིཊས་ དང་ ནེ་བིས",
    "KP" to "བྱང་ ཀོ་རི་ཡ",
    "KR" to "ལྷོ་ ཀོ་རི་ཡ",
    "KW" to "ཀུ་ཝེཊ",
    "KY" to "ཁེ་མེན་གླིང་ཚོམ",
    "KZ" to "ཀ་ཛགས་སཏཱན",
    "LA" to "ལཱ་ཝོས",
    "LB" to "ལེ་བ་ནོན",
    "LC" to "སེནཊ་ ལུ་སི་ཡ",
    "LI" to "ལིཀ་ཏནས་ཏ་ཡིན",
    "LK" to "ཤྲཱི་ལང་ཀ",
    "LR" to "ལཱའི་བེ་རི་ཡ",
    "LS" to "ལཻ་སོ་ཐོ",
    "LT" to "ལི་ཐུ་ཝེ་ནི་ཡ",
    "LU" to "ལག་ཛམ་བོརྒ",
    "LV" to "ལཊ་བི་ཡ",
    "LY" to "ལི་བི་ཡ",
    "MA" to "མོ་རོ་ཀོ",
    "MC" to "མོ་ན་ཀོ",
    "MD" to "མོལ་དོ་བཱ",
    "ME" to "མོན་ཊི་ནེག་རོ",
    "MF" to "སེནཊ་ མཱར་ཊིན",
    "MG" to "མ་དཱ་གེས་ཀར",
    "MH" to "མར་ཤེལ་གླིང་ཚོམ",
    "ML" to "མཱ་ལི",
    "MM" to "མི་ཡཱན་མར་ (བྷར་མ)",
    "MN" to "སོག་པོ་ཡུལ",
    "MO" to "མཀ་ཨའུ་ཅཱའི་ན",
    "MP" to "བྱང་ཕྱོགས་ཀྱི་མ་ར་ཡ་ན་གླིང་ཚོམ",
    "MQ" to "མཱར་ཊི་ནིཀ",
    "MR" to "མོ་རི་ཊེ་ནི་ཡ",
    "MS" to "མོན་ས་རཊ",
    "MT" to "མཱལ་ཊ",
    "MU" to "མོ་རི་ཤཱས",
    "MV" to "མཱལ་དིབས",
    "MW" to "མ་ལ་ཝི",
    "MX" to "མེཀ་སི་ཀོ",
    "MY" to "མ་ལེ་ཤི་ཡ",
    "MZ" to "མོ་ཛམ་བྷིཀ",
    "NA" to "ན་མི་བི་ཡ",
    "NC" to "ནིའུ་ཀ་ལི་དོ་ནི་ཡ",
    "NE" to "ནཱའི་ཇཱ",
    "NF" to "ནོར་ཕོལཀ་མཚོ་གླིང༌",
    "NG" to "ནཱའི་ཇི་རི་ཡ",
    "NI" to "ནི་ཀྲ་ཝ་ག",
    "NL" to "ནེ་དར་ལནཌས྄",
    "NO" to "ནོར་ཝེ",
    "NP" to "བལ་ཡུལ",
    "NR" to "ནའུ་རུ་",
    "NU" to "ནི་ཨུ་ཨཻ",
    "NZ" to "ནིའུ་ཛི་ལེནཌ",
    "OM" to "ཨོ་མཱན",
    "PA" to "པ་ན་མ",
    "PE" to "པེ་རུ",
    "PF" to "ཕྲཱནས྄་ཀྱི་པོ་ལི་ནི་ཤི་ཡ",
    "PG" to "པ་པུ་ ནིའུ་གི་ནི",
    "PH" to "ཕི་ལི་པིནས",
    "PK" to "པ་ཀི་སཏཱན",
    "PL" to "པོ་ལེནཌ",
    "PM" to "སིནཊ་པི་ཡེར་ ཨེནཌ་ མིཀོ་ལེན",
    "PN" to "པིཊ་ཀེ་ཡེརན་གླིང་ཚོམ",
    "PR" to "པུ་འེར་ཊོ་རི་ཁོ",
    "PS" to "པེ་ལིསི་ཊི་ནི་ཡན་ཊེ་རི་ཐོ་རི",
    "PT" to "པོར་ཅུ་གཱལ",
    "PW" to "པ་ལའུ",
    "PY" to "པ་ར་གུ་ཝའི",
    "QA" to "ཀ་ཊར",
    "QO" to "ཨོཤི་ཡཱན་ན་གྱི་མཐའ་མཚམས",
    "RE" to "རེ་ཡུ་ནི་ཡོན",
    "RO" to "རོ་མེ་ནི་ཡ",
    "RS" to "སཱར་བྷི་ཡ",
    "RU" to "ཨུ་རུ་སུ",
    "RW" to "རུ་ཝན་ཌ",
    "SA" to "སཱཝ་དི་ ཨ་རེ་བྷི་ཡ",
    "SB" to "སོ་ལོ་མོན་ གླིང་ཚོམ",
    "SC" to "སེ་ཤཱལས",
    "SD" to "སུ་ཌཱན",
    "SE" to "སུའི་ཌེན",
    "SG" to "སིང་ག་པོར",
    "SH" to "སེནཊ་ ཧེ་ལི་ན",
    "SI" to "སུ་ལོ་བི་ནི་ཡ",
    "SJ" to "སྭཱལ་བྷརྡ་ ཨེནཌ་ ཇཱན་མ་ཡེན",
    "SK" to "སུ་ལོ་བཱ་ཀི་ཡ",
    "SL" to "སི་ར་ ལི་འོན",
    "SM" to "སཱན་མ་རི་ནོ",
    "SN" to "སེ་ནི་གྷལ",
    "SO" to "སོ་མ་ལི་ཡ",
    "SR" to "སུ་རི་ནཱམ",
    "SS" to "སཱའུཐ་ སུ་ཌཱན",
    "ST" to "སཝ་ ཊོ་མེ་ ཨེནཌ་ པྲྀན་སི་པེ",
    "SV" to "ཨེལ་སལ་བ་ཌོར",
    "SX" to "སིནཊ་ མཱར་ཊེན",
    "SY" to "སི་རི་ཡ",
    "SZ" to "སུ་ཝ་ཛི་ལེནཌ",
    "TA" to "ཏྲིས་ཏན་ད་ཀུན་ཧ",
    "TC" to "ཏུརྐས྄་ ཨེནཌ་ ཀ་ཀོས་གླིང་ཚོམ",
    "TD" to "ཅཱཌ",
    "TF" to "ཕྲནཅ་གི་ལྷོ་ཕྱོགས་མངའ་ཁོངས",
    "TG" to "ཊོ་གྷོ",
    "TH" to "ཐཱའི་ལེནཌ",
    "TJ" to "ཏ་ཇིག་གི་སཏཱན",
    "TK" to "ཏོ་ཀེ་ལའུ་ མཚོ་གླིང",
    "TL" to "ཏི་་མོར་ལེ་ཨེསཊ",
    "TM" to "ཊཱརཀ་མེནའི་སཏཱན",
    "TN" to "ཊུ་ནི་ཤི་ཡ",
    "TO" to "ཊོང་གྷ",
    "TR" to "ཊཱར་ཀི",
    "TT" to "ཊི་ནི་ཌཱཌ་ ཨེནཌ་ ཊོ་བྷེ་གྷོ",
    "TV" to "ཏུ་ཝ་ལུ",
    "TW" to "ཊཱའི་ཝཱན",
    "TZ" to "ཊཱན་ཛཱ་ནི་ཡ",
    "UA" to "ཡུ་ཀརེན",
    "UG" to "ཡུ་གྷན་ཌ",
    "UM" to "ཡུ་ཨེས་གྱི་མཐའ་མཚམས་མཚོ་གླིང་",
    "US" to "ཡུ་ཨེས་ཨེ",
    "UY" to "ཡུ་རུ་གུ་ཝའི",
    "UZ" to "ཨུས་བེག་གི་སཏཱན",
    "VA" to "བ་ཊི་ཀཱན་ སི་ཊི",
    "VC" to "སེནཊ་ཝིན་སེནཌ྄ ཨེནཌ་ གི་རེ་ན་དིནས྄",
    "VE" to "བེ་ནི་ཛུ་ཝེ་ལ",
    "VG" to "ཝརཇིན་གླིང་ཚོམ་ བྲཱི་ཊིཤ་མངའ་ཁོངས",
    "VI" to "ཝརཇིན་གླིང་ཚོམ་ ཡུ་ཨེས་ཨེ་མངའ་ཁོངས",
    "VN" to "བེཊ་ནཱམ",
    "VU" to "ཝ་ནུ་ཨ་ཏུ",
    "WF" to "ཝལ་ལིས྄་ ཨེནཌ་ ཕུ་ཏུ་ན་",
    "WS" to "ས་མོ་ཨ",
    "YE" to "ཡེ་མེན",
    "YT" to "མེ་ཡོཊ",
    "ZA" to "སཱའུཐ་ ཨཕ་རི་ཀ",
    "ZM" to "ཛམ་བྷི་ཡ",
    "ZW" to "ཛིམ་བྷབ་ཝེ",
    "ZZ" to "ངོ་མ་ཤེས་པའི་ལུང་ཕྱོགས",
  ) }

  val ebu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Falme za Kiarabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AR" to "Ajentina",
    "AS" to "Samoa ya Marekani",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AZ" to "Azabajani",
    "BA" to "Bosnia na Hezegovina",
    "BB" to "Babadosi",
    "BD" to "Bangladeshi",
    "BE" to "Ubelgiji",
    "BF" to "Bukinafaso",
    "BG" to "Bulgaria",
    "BH" to "Bahareni",
    "BI" to "Burundi",
    "BJ" to "Benini",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BR" to "Brazili",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botswana",
    "BY" to "Belarusi",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CD" to "Jamhuri ya Kidemokrasia ya Kongo",
    "CF" to "Jamhuri ya Afrika ya Kati",
    "CG" to "Kongo",
    "CH" to "Uswisi",
    "CI" to "Kodivaa",
    "CK" to "Visiwa vya Cook",
    "CL" to "Chile",
    "CM" to "Kameruni",
    "CN" to "China",
    "CO" to "Kolombia",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Kepuvede",
    "CY" to "Kuprosi",
    "CZ" to "Jamhuri ya Cheki",
    "DE" to "Ujerumani",
    "DJ" to "Jibuti",
    "DK" to "Denmaki",
    "DM" to "Dominika",
    "DO" to "Jamhuri ya Dominika",
    "DZ" to "Aljeria",
    "EC" to "Ekwado",
    "EE" to "Estonia",
    "EG" to "Misri",
    "ER" to "Eritrea",
    "ES" to "Hispania",
    "ET" to "Uhabeshi",
    "FI" to "Ufini",
    "FJ" to "Fiji",
    "FK" to "Visiwa vya Falkland",
    "FM" to "Mikronesia",
    "FR" to "Ufaransa",
    "GA" to "Gaboni",
    "GB" to "Uingereza",
    "GD" to "Grenada",
    "GE" to "Jojia",
    "GF" to "Gwiyana ya Ufaransa",
    "GH" to "Ghana",
    "GI" to "Jibralta",
    "GL" to "Grinlandi",
    "GM" to "Gambia",
    "GN" to "Gine",
    "GP" to "Gwadelupe",
    "GQ" to "Ginekweta",
    "GR" to "Ugiriki",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Hondurasi",
    "HR" to "Korasia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "ID" to "Indonesia",
    "IE" to "Ayalandi",
    "IL" to "Israeli",
    "IN" to "India",
    "IQ" to "Iraki",
    "IR" to "Uajemi",
    "IS" to "Aislandi",
    "IT" to "Italia",
    "JM" to "Jamaika",
    "JO" to "Yordani",
    "JP" to "Japani",
    "KE" to "Kenya",
    "KG" to "Kirigizistani",
    "KH" to "Kambodia",
    "KI" to "Kiribati",
    "KM" to "Komoro",
    "KN" to "Santakitzi na Nevis",
    "KP" to "Korea Kaskazini",
    "KR" to "Korea Kusini",
    "KW" to "Kuwaiti",
    "KY" to "Visiwa vya Kayman",
    "KZ" to "Kazakistani",
    "LA" to "Laosi",
    "LB" to "Lebanoni",
    "LC" to "Santalusia",
    "LI" to "Lishenteni",
    "LK" to "Sirilanka",
    "LR" to "Liberia",
    "LS" to "Lesoto",
    "LT" to "Litwania",
    "LU" to "Lasembagi",
    "LV" to "Lativia",
    "LY" to "Libya",
    "MA" to "Moroko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "MG" to "Bukini",
    "MH" to "Visiwa vya Marshal",
    "ML" to "Mali",
    "MM" to "Myama",
    "MN" to "Mongolia",
    "MP" to "Visiwa vya Mariana vya Kaskazini",
    "MQ" to "Martiniki",
    "MR" to "Moritania",
    "MS" to "Montserrati",
    "MT" to "Malta",
    "MU" to "Morisi",
    "MV" to "Modivu",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malesia",
    "MZ" to "Msumbiji",
    "NA" to "Namibia",
    "NC" to "Nyukaledonia",
    "NE" to "Nijeri",
    "NF" to "Kisiwa cha Norfok",
    "NG" to "Nijeria",
    "NI" to "Nikaragwa",
    "NL" to "Uholanzi",
    "NO" to "Norwe",
    "NP" to "Nepali",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nyuzilandi",
    "OM" to "Omani",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia ya Ufaransa",
    "PG" to "Papua",
    "PH" to "Filipino",
    "PK" to "Pakistani",
    "PL" to "Polandi",
    "PM" to "Santapieri na Mikeloni",
    "PN" to "Pitkairni",
    "PR" to "Pwetoriko",
    "PS" to "Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina",
    "PT" to "Ureno",
    "PW" to "Palau",
    "PY" to "Paragwai",
    "QA" to "Katari",
    "RE" to "Riyunioni",
    "RO" to "Romania",
    "RU" to "Urusi",
    "RW" to "Rwanda",
    "SA" to "Saudi",
    "SB" to "Visiwa vya Solomon",
    "SC" to "Shelisheli",
    "SD" to "Sudani",
    "SE" to "Uswidi",
    "SG" to "Singapoo",
    "SH" to "Santahelena",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SL" to "Siera Leoni",
    "SM" to "Samarino",
    "SN" to "Senegali",
    "SO" to "Somalia",
    "SR" to "Surinamu",
    "ST" to "Sao Tome na Principe",
    "SV" to "Elsavado",
    "SY" to "Siria",
    "SZ" to "Uswazi",
    "TC" to "Visiwa vya Turki na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tailandi",
    "TJ" to "Tajikistani",
    "TK" to "Tokelau",
    "TL" to "Timori ya Mashariki",
    "TM" to "Turukimenistani",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Uturuki",
    "TT" to "Trinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tanzania",
    "UA" to "Ukraini",
    "UG" to "Uganda",
    "US" to "Marekani",
    "UY" to "Urugwai",
    "UZ" to "Uzibekistani",
    "VA" to "Vatikani",
    "VC" to "Santavisenti na Grenadini",
    "VE" to "Venezuela",
    "VG" to "Visiwa vya Virgin vya Uingereza",
    "VI" to "Visiwa vya Virgin vya Marekani",
    "VN" to "Vietinamu",
    "VU" to "Vanuatu",
    "WF" to "Walis na Futuna",
    "WS" to "Samoa",
    "YE" to "Yemeni",
    "YT" to "Mayotte",
    "ZA" to "Afrika Kusini",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
  ) }

  val ee: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "xexeme",
    "002" to "Afrika nutome",
    "003" to "Dziehe Amerika nutome",
    "005" to "Anyiehe Amerika nutome",
    "009" to "Oceania nutome",
    "011" to "Ɣetoɖoƒelɔƒo Afrika nutome",
    "013" to "Titina Amerika nutome",
    "014" to "Ɣedzeƒe Afrika nutome",
    "015" to "Dziehe Afrika nutome",
    "017" to "Titina Afrika nutome",
    "018" to "Anyiehelɔƒo Afrika nutome",
    "019" to "Amerika nutome",
    "021" to "Dziehelɔƒo Amerika nutome",
    "029" to "Karibbea nutome",
    "030" to "Ɣedzeƒe Asia nutome",
    "034" to "Anyiehelɔƒo Asia nutome",
    "035" to "Anyiehe Ɣedzeƒe Afrika nutome",
    "039" to "Anyiehelɔƒo Europa nutome",
    "053" to "Australia kple New Zealand nutome",
    "054" to "Melanesia nutome",
    "057" to "Mikronesia",
    "061" to "Pɔlinesia nutome",
    "142" to "Asia nutome",
    "143" to "Titina Asia nutome",
    "145" to "Ɣetoɖoƒelɔƒo Asia nutome",
    "150" to "Europa nutome",
    "151" to "Ɣedzeƒe Europa nutome",
    "154" to "Dziehelɔƒo Europa nutome",
    "155" to "Ɣetoɖoƒelɔƒo Europa nutome",
    "419" to "Latin Amerika nutome",
    "AC" to "Ascension ƒudomekpo nutome",
    "AD" to "Andorra nutome",
    "AE" to "United Arab Emirates nutome",
    "AF" to "Afghanistan nutome",
    "AG" to "́Antigua kple Barbuda nutome",
    "AI" to "Anguilla nutome",
    "AL" to "Albania nutome",
    "AM" to "Armenia nutome",
    "AO" to "Angola nutome",
    "AQ" to "Antartica nutome",
    "AR" to "Argentina nutome",
    "AS" to "Amerika Samoa nutome",
    "AT" to "Austria nutome",
    "AU" to "Australia nutome",
    "AW" to "Aruba nutome",
    "AX" to "Åland ƒudomekpo nutome",
    "AZ" to "Azerbaijan nutome",
    "BA" to "Bosnia kple Herzergovina nutome",
    "BB" to "Barbados nutome",
    "BD" to "Bangladesh nutome",
    "BE" to "Belgium nutome",
    "BF" to "Burkina Faso nutome",
    "BG" to "Bulgaria nutome",
    "BH" to "Bahrain nutome",
    "BI" to "Burundi nutome",
    "BJ" to "Benin nutome",
    "BL" to "Saint Barthélemy nutome",
    "BM" to "Bermuda nutome",
    "BN" to "Brunei nutome",
    "BO" to "Bolivia nutome",
    "BR" to "Brazil nutome",
    "BS" to "Bahamas nutome",
    "BT" to "Bhutan nutome",
    "BV" to "Bouvet ƒudomekpo nutome",
    "BW" to "Botswana nutome",
    "BY" to "Belarus nutome",
    "BZ" to "Belize nutome",
    "CA" to "Canada nutome",
    "CC" to "Kokos (Kiling) fudomekpo nutome",
    "CD" to "Kongo Kinshasa nutome",
    "CF" to "Titina Afrika repɔblik nutome",
    "CG" to "Kongo Brazzaville nutome",
    "CH" to "Switzerland nutome",
    "CI" to "Kote d’Ivoire nutome",
    "CK" to "Kook ƒudomekpo nutome",
    "CL" to "Tsile nutome",
    "CM" to "Kamerun nutome",
    "CN" to "Tsaina nutome",
    "CO" to "Kolombia nutome",
    "CP" to "Klipaton ƒudomekpo nutome",
    "CR" to "Kosta Rika nutome",
    "CU" to "Kuba nutome",
    "CV" to "Kape Verde nutome",
    "CX" to "Kristmas ƒudomekpo nutome",
    "CY" to "Saiprus nutome",
    "CZ" to "Tsɛk repɔblik nutome",
    "DE" to "Germania nutome",
    "DG" to "Diego Garsia nutome",
    "DJ" to "Dzibuti nutome",
    "DK" to "Denmark nutome",
    "DM" to "Dominika nutome",
    "DO" to "Dominika repɔblik nutome",
    "DZ" to "Algeria nutome",
    "EA" to "Keuta and Melilla nutome",
    "EC" to "Ekuadɔ nutome",
    "EE" to "Estonia nutome",
    "EG" to "Egypte nutome",
    "EH" to "Ɣetoɖoƒe Sahara nutome",
    "ER" to "Eritrea nutome",
    "ES" to "Spain nutome",
    "ET" to "Etiopia nutome",
    "EU" to "Europa Wɔɖeka nutome",
    "FI" to "Finland nutome",
    "FJ" to "Fidzi nutome",
    "FK" to "Falkland ƒudomekpowo nutome",
    "FM" to "Mikronesia nutome",
    "FO" to "Faroe ƒudomekpowo nutome",
    "FR" to "France nutome",
    "GA" to "Gabɔn nutome",
    "GB" to "United Kingdom nutome",
    "GD" to "Grenada nutome",
    "GE" to "Georgia nutome",
    "GF" to "Frentsi Gayana nutome",
    "GG" to "Guernse nutome",
    "GH" to "Ghana nutome",
    "GI" to "Gibraltar nutome",
    "GL" to "Grinland nutome",
    "GM" to "Gambia nutome",
    "GN" to "Guini nutome",
    "GP" to "Guadelupe nutome",
    "GQ" to "Ekuatorial Guini nutome",
    "GR" to "Greece nutome",
    "GS" to "Anyiehe Georgia kple Anyiehe Sandwich ƒudomekpowo nutome",
    "GT" to "Guatemala nutome",
    "GU" to "Guam nutome",
    "GW" to "Gini-Bisao nutome",
    "GY" to "Guyanadu",
    "HK" to "Hɔng Kɔng SAR Tsaina nutome",
    "HM" to "Heard kple Mcdonald ƒudomekpowo nutome",
    "HN" to "Hondurasdu",
    "HR" to "Kroatsia nutome",
    "HT" to "Haiti nutome",
    "HU" to "Hungari nutome",
    "IC" to "Kanari ƒudomekpowo nutome",
    "ID" to "Indonesia nutome",
    "IE" to "Ireland nutome",
    "IL" to "Israel nutome",
    "IM" to "Aisle of Man nutome",
    "IN" to "India nutome",
    "IQ" to "iraqdukɔ",
    "IR" to "Iran nutome",
    "IS" to "Aiseland nutome",
    "IT" to "Italia nutome",
    "JE" to "Dzɛse nutome",
    "JM" to "Dzamaika nutome",
    "JO" to "Yordan nutome",
    "JP" to "Dzapan nutome",
    "KE" to "Kenya nutome",
    "KG" to "Kirgizstan nutome",
    "KH" to "Kambodia nutome",
    "KI" to "Kiribati nutome",
    "KM" to "Komoros nutome",
    "KN" to "Saint Kitis kple Nevis nutome",
    "KP" to "Dziehe Korea nutome",
    "KR" to "Anyiehe Korea nutome",
    "KW" to "Kuwait nutome",
    "KY" to "Kayman ƒudomekpowo nutome",
    "KZ" to "Kazakstan nutome",
    "LA" to "Laos nutome",
    "LB" to "Lebanɔn nutome",
    "LC" to "Saint Lusia nutome",
    "LI" to "Litsenstein nutome",
    "LK" to "Sri Lanka nutome",
    "LR" to "Liberia nutome",
    "LS" to "Lɛsoto nutome",
    "LT" to "Lituania nutome",
    "LU" to "Lazembɔg nutome",
    "LV" to "Latvia nutome",
    "LY" to "Libya nutome",
    "MA" to "Moroko nutome",
    "MC" to "Monako nutome",
    "MD" to "Moldova nutome",
    "ME" to "Montenegro nutome",
    "MF" to "Saint Martin nutome",
    "MG" to "Madagaska nutome",
    "MH" to "Marshal ƒudomekpowo nutome",
    "ML" to "Mali nutome",
    "MM" to "Myanmar (Burma) nutome",
    "MN" to "Mongolia nutome",
    "MO" to "Macau SAR Tsaina nutome",
    "MP" to "Dziehe Marina ƒudomekpowo nutome",
    "MQ" to "Martiniki nutome",
    "MR" to "Mauritania nutome",
    "MS" to "Montserrat nutome",
    "MT" to "Malta nutome",
    "MU" to "mauritiusdukɔ",
    "MV" to "maldivesdukɔ",
    "MW" to "Malawi nutome",
    "MX" to "Mexico nutome",
    "MY" to "Malaysia nutome",
    "MZ" to "Mozambiki nutome",
    "NA" to "Namibia nutome",
    "NC" to "New Kaledonia nutome",
    "NE" to "Niger nutome",
    "NF" to "Norfolk ƒudomekpo nutome",
    "NG" to "Nigeria nutome",
    "NI" to "Nicaraguadukɔ",
    "NL" to "Netherlands nutome",
    "NO" to "Norway nutome",
    "NP" to "Nepal nutome",
    "NR" to "Nauru nutome",
    "NU" to "Niue nutome",
    "NZ" to "New Zealand nutome",
    "OM" to "Oman nutome",
    "PA" to "Panama nutome",
    "PE" to "Peru nutome",
    "PF" to "Frentsi Pɔlinesia nutome",
    "PG" to "Papua New Gini nutome",
    "PH" to "Filipini nutome",
    "PK" to "Pakistan nutome",
    "PL" to "Poland nutome",
    "PM" to "Saint Pierre kple Mikelɔn nutome",
    "PN" to "Pitkairn ƒudomekpo nutome",
    "PR" to "Puerto Riko nutome",
    "PS" to "Palestinia nutome",
    "PT" to "Portugal nutome",
    "PW" to "Palau nutome",
    "PY" to "Paragua nutome",
    "QA" to "Katar nutome",
    "QO" to "Outlaying Oceania nutome",
    "RE" to "Réunion nutome",
    "RO" to "Romania nutome",
    "RU" to "Russia nutome",
    "RW" to "Rwanda nutome",
    "SA" to "Saudi Arabia nutome",
    "SB" to "Solomon ƒudomekpowo nutome",
    "SC" to "Seshɛls nutome",
    "SD" to "Sudan nutome",
    "SE" to "Sweden nutome",
    "SG" to "Singapɔr nutome",
    "SH" to "Saint Helena nutome",
    "SI" to "Slovenia nutome",
    "SJ" to "Svalbard kple Yan Mayen nutome",
    "SK" to "Slovakia nutome",
    "SL" to "Sierra Leone nutome",
    "SM" to "San Marino nutome",
    "SN" to "Senegal nutome",
    "SO" to "Somalia nutome",
    "SR" to "Suriname nutome",
    "ST" to "São Tomé kple Príncipe nutome",
    "SV" to "El Salvadɔ nutome",
    "SY" to "Siria nutome",
    "SZ" to "Swaziland nutome",
    "TA" to "Tristan da Kunha nutome",
    "TC" to "Tɛks kple Kaikos ƒudomekpowo nutome",
    "TD" to "Tsad nutome",
    "TF" to "Anyiehe Franseme nutome",
    "TG" to "Togo nutome",
    "TH" to "Thailand nutome",
    "TJ" to "Tajikistan nutome",
    "TK" to "Tokelau nutome",
    "TL" to "Timor-Leste nutome",
    "TM" to "Tɛkmenistan nutome",
    "TN" to "Tunisia nutome",
    "TO" to "Tonga nutome",
    "TR" to "Tɛki nutome",
    "TT" to "Trinidad kple Tobago nutome",
    "TV" to "Tuvalu nutome",
    "TW" to "Taiwan nutome",
    "TZ" to "Tanzania nutome",
    "UA" to "Ukraine nutome",
    "UG" to "Uganda nutome",
    "UM" to "U.S. Minor Outlaying ƒudomekpowo nutome",
    "US" to "USA nutome",
    "UY" to "uruguaydukɔ",
    "UZ" to "Uzbekistan nutome",
    "VA" to "Vatikandu nutome",
    "VC" to "Saint Vincent kple Grenadine nutome",
    "VE" to "Venezuela nutome",
    "VG" to "Britaintɔwo ƒe Virgin ƒudomekpowo nutome",
    "VI" to "U.S. Vɛrgin ƒudomekpowo nutome",
    "VN" to "Vietnam nutome",
    "VU" to "Vanuatu nutome",
    "WF" to "Wallis kple Futuna nutome",
    "WS" to "Samoa nutome",
    "YE" to "Yemen nutome",
    "YT" to "Mayotte nutome",
    "ZA" to "Anyiehe Africa nutome",
    "ZM" to "Zambia nutome",
    "ZW" to "Zimbabwe nutome",
    "ZZ" to "nutome manya",
  ) }

  val ee_TG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val el: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Κόσμος",
    "002" to "Αφρική",
    "003" to "Βόρεια Αμερική",
    "005" to "Νότια Αμερική",
    "009" to "Ωκεανία",
    "011" to "Δυτική Αφρική",
    "013" to "Κεντρική Αμερική",
    "014" to "Ανατολική Αφρική",
    "015" to "Βόρεια Αφρική",
    "017" to "Μέση Αφρική",
    "018" to "Νότιος Αφρική",
    "019" to "Αμερική",
    "021" to "Βόρειος Αμερική",
    "029" to "Καραϊβική",
    "030" to "Ανατολική Ασία",
    "034" to "Νότια Ασία",
    "035" to "Νοτιοανατολική Ασία",
    "039" to "Νότια Ευρώπη",
    "053" to "Αυστραλασία",
    "054" to "Μελανησία",
    "057" to "Περιοχή Μικρονησίας",
    "061" to "Πολυνησία",
    "142" to "Ασία",
    "143" to "Κεντρική Ασία",
    "145" to "Δυτική Ασία",
    "150" to "Ευρώπη",
    "151" to "Ανατολική Ευρώπη",
    "154" to "Βόρεια Ευρώπη",
    "155" to "Δυτική Ευρώπη",
    "202" to "Υποσαχάρια Αφρική",
    "419" to "Λατινική Αμερική",
    "AC" to "Νήσος Ασενσιόν",
    "AD" to "Ανδόρα",
    "AE" to "Ηνωμένα Αραβικά Εμιράτα",
    "AF" to "Αφγανιστάν",
    "AG" to "Αντίγκουα και Μπαρμπούντα",
    "AI" to "Ανγκουίλα",
    "AL" to "Αλβανία",
    "AM" to "Αρμενία",
    "AO" to "Αγκόλα",
    "AQ" to "Ανταρκτική",
    "AR" to "Αργεντινή",
    "AS" to "Αμερικανική Σαμόα",
    "AT" to "Αυστρία",
    "AU" to "Αυστραλία",
    "AW" to "Αρούμπα",
    "AX" to "Νήσοι Όλαντ",
    "AZ" to "Αζερμπαϊτζάν",
    "BA" to "Βοσνία - Ερζεγοβίνη",
    "BB" to "Μπαρμπέιντος",
    "BD" to "Μπανγκλαντές",
    "BE" to "Βέλγιο",
    "BF" to "Μπουρκίνα Φάσο",
    "BG" to "Βουλγαρία",
    "BH" to "Μπαχρέιν",
    "BI" to "Μπουρούντι",
    "BJ" to "Μπενίν",
    "BL" to "Άγιος Βαρθολομαίος",
    "BM" to "Βερμούδες",
    "BN" to "Μπρουνέι",
    "BO" to "Βολιβία",
    "BQ" to "Ολλανδία Καραϊβικής",
    "BR" to "Βραζιλία",
    "BS" to "Μπαχάμες",
    "BT" to "Μπουτάν",
    "BV" to "Νήσος Μπουβέ",
    "BW" to "Μποτσουάνα",
    "BY" to "Λευκορωσία",
    "BZ" to "Μπελίζ",
    "CA" to "Καναδάς",
    "CC" to "Νήσοι Κόκος (Κίλινγκ)",
    "CD" to "Κονγκό - Κινσάσα",
    "CF" to "Κεντροαφρικανική Δημοκρατία",
    "CG" to "Κονγκό - Μπραζαβίλ",
    "CH" to "Ελβετία",
    "CI" to "Ακτή Ελεφαντοστού",
    "CK" to "Νήσοι Κουκ",
    "CL" to "Χιλή",
    "CM" to "Καμερούν",
    "CN" to "Κίνα",
    "CO" to "Κολομβία",
    "CP" to "Νήσος Κλίπερτον",
    "CR" to "Κόστα Ρίκα",
    "CU" to "Κούβα",
    "CV" to "Πράσινο Ακρωτήριο",
    "CW" to "Κουρασάο",
    "CX" to "Νήσος των Χριστουγέννων",
    "CY" to "Κύπρος",
    "CZ" to "Τσεχία",
    "DE" to "Γερμανία",
    "DG" to "Ντιέγκο Γκαρσία",
    "DJ" to "Τζιμπουτί",
    "DK" to "Δανία",
    "DM" to "Ντομίνικα",
    "DO" to "Δομινικανή Δημοκρατία",
    "DZ" to "Αλγερία",
    "EA" to "Θέουτα και Μελίγια",
    "EC" to "Ισημερινός",
    "EE" to "Εσθονία",
    "EG" to "Αίγυπτος",
    "EH" to "Δυτική Σαχάρα",
    "ER" to "Ερυθραία",
    "ES" to "Ισπανία",
    "ET" to "Αιθιοπία",
    "EU" to "Ευρωπαϊκή Ένωση",
    "EZ" to "Ευρωζώνη",
    "FI" to "Φινλανδία",
    "FJ" to "Φίτζι",
    "FK" to "Νήσοι Φόκλαντ",
    "FM" to "Μικρονησία",
    "FO" to "Νήσοι Φερόες",
    "FR" to "Γαλλία",
    "GA" to "Γκαμπόν",
    "GB" to "Ηνωμένο Βασίλειο",
    "GD" to "Γρενάδα",
    "GE" to "Γεωργία",
    "GF" to "Γαλλική Γουιάνα",
    "GG" to "Γκέρνζι",
    "GH" to "Γκάνα",
    "GI" to "Γιβραλτάρ",
    "GL" to "Γροιλανδία",
    "GM" to "Γκάμπια",
    "GN" to "Γουινέα",
    "GP" to "Γουαδελούπη",
    "GQ" to "Ισημερινή Γουινέα",
    "GR" to "Ελλάδα",
    "GS" to "Νήσοι Νότια Γεωργία και Νότιες Σάντουιτς",
    "GT" to "Γουατεμάλα",
    "GU" to "Γκουάμ",
    "GW" to "Γουινέα Μπισάου",
    "GY" to "Γουιάνα",
    "HK" to "Χονγκ Κονγκ ΕΔΠ Κίνας",
    "HM" to "Νήσοι Χερντ και Μακντόναλντ",
    "HN" to "Ονδούρα",
    "HR" to "Κροατία",
    "HT" to "Αϊτή",
    "HU" to "Ουγγαρία",
    "IC" to "Κανάριοι Νήσοι",
    "ID" to "Ινδονησία",
    "IE" to "Ιρλανδία",
    "IL" to "Ισραήλ",
    "IM" to "Νήσος του Μαν",
    "IN" to "Ινδία",
    "IO" to "Βρετανικά Εδάφη Ινδικού Ωκεανού",
    "IQ" to "Ιράκ",
    "IR" to "Ιράν",
    "IS" to "Ισλανδία",
    "IT" to "Ιταλία",
    "JE" to "Τζέρζι",
    "JM" to "Τζαμάικα",
    "JO" to "Ιορδανία",
    "JP" to "Ιαπωνία",
    "KE" to "Κένυα",
    "KG" to "Κιργιστάν",
    "KH" to "Καμπότζη",
    "KI" to "Κιριμπάτι",
    "KM" to "Κομόρες",
    "KN" to "Σεν Κιτς και Νέβις",
    "KP" to "Βόρεια Κορέα",
    "KR" to "Νότια Κορέα",
    "KW" to "Κουβέιτ",
    "KY" to "Νήσοι Κέιμαν",
    "KZ" to "Καζακστάν",
    "LA" to "Λάος",
    "LB" to "Λίβανος",
    "LC" to "Αγία Λουκία",
    "LI" to "Λιχτενστάιν",
    "LK" to "Σρι Λάνκα",
    "LR" to "Λιβερία",
    "LS" to "Λεσότο",
    "LT" to "Λιθουανία",
    "LU" to "Λουξεμβούργο",
    "LV" to "Λετονία",
    "LY" to "Λιβύη",
    "MA" to "Μαρόκο",
    "MC" to "Μονακό",
    "MD" to "Μολδαβία",
    "ME" to "Μαυροβούνιο",
    "MF" to "Άγιος Μαρτίνος (Γαλλικό τμήμα)",
    "MG" to "Μαδαγασκάρη",
    "MH" to "Νήσοι Μάρσαλ",
    "MK" to "Βόρεια Μακεδονία",
    "ML" to "Μάλι",
    "MM" to "Μιανμάρ (Βιρμανία)",
    "MN" to "Μογγολία",
    "MO" to "Μακάο ΕΔΠ Κίνας",
    "MP" to "Νήσοι Βόρειες Μαριάνες",
    "MQ" to "Μαρτινίκα",
    "MR" to "Μαυριτανία",
    "MS" to "Μονσεράτ",
    "MT" to "Μάλτα",
    "MU" to "Μαυρίκιος",
    "MV" to "Μαλδίβες",
    "MW" to "Μαλάουι",
    "MX" to "Μεξικό",
    "MY" to "Μαλαισία",
    "MZ" to "Μοζαμβίκη",
    "NA" to "Ναμίμπια",
    "NC" to "Νέα Καληδονία",
    "NE" to "Νίγηρας",
    "NF" to "Νήσος Νόρφολκ",
    "NG" to "Νιγηρία",
    "NI" to "Νικαράγουα",
    "NL" to "Κάτω Χώρες",
    "NO" to "Νορβηγία",
    "NP" to "Νεπάλ",
    "NR" to "Ναουρού",
    "NU" to "Νιούε",
    "NZ" to "Νέα Ζηλανδία",
    "OM" to "Ομάν",
    "PA" to "Παναμάς",
    "PE" to "Περού",
    "PF" to "Γαλλική Πολυνησία",
    "PG" to "Παπούα Νέα Γουινέα",
    "PH" to "Φιλιππίνες",
    "PK" to "Πακιστάν",
    "PL" to "Πολωνία",
    "PM" to "Σεν Πιερ και Μικελόν",
    "PN" to "Νήσοι Πίτκερν",
    "PR" to "Πουέρτο Ρίκο",
    "PS" to "Παλαιστινιακά Εδάφη",
    "PT" to "Πορτογαλία",
    "PW" to "Παλάου",
    "PY" to "Παραγουάη",
    "QA" to "Κατάρ",
    "QO" to "Περιφερειακή Ωκεανία",
    "RE" to "Ρεϊνιόν",
    "RO" to "Ρουμανία",
    "RS" to "Σερβία",
    "RU" to "Ρωσία",
    "RW" to "Ρουάντα",
    "SA" to "Σαουδική Αραβία",
    "SB" to "Νήσοι Σολομώντος",
    "SC" to "Σεϋχέλλες",
    "SD" to "Σουδάν",
    "SE" to "Σουηδία",
    "SG" to "Σιγκαπούρη",
    "SH" to "Αγία Ελένη",
    "SI" to "Σλοβενία",
    "SJ" to "Σβάλμπαρντ και Γιαν Μαγιέν",
    "SK" to "Σλοβακία",
    "SL" to "Σιέρα Λεόνε",
    "SM" to "Άγιος Μαρίνος",
    "SN" to "Σενεγάλη",
    "SO" to "Σομαλία",
    "SR" to "Σουρινάμ",
    "SS" to "Νότιο Σουδάν",
    "ST" to "Σάο Τομέ και Πρίνσιπε",
    "SV" to "Ελ Σαλβαδόρ",
    "SX" to "Άγιος Μαρτίνος (Ολλανδικό τμήμα)",
    "SY" to "Συρία",
    "SZ" to "Εσουατίνι",
    "TA" to "Τριστάν ντα Κούνια",
    "TC" to "Νήσοι Τερκς και Κάικος",
    "TD" to "Τσαντ",
    "TF" to "Γαλλικά Νότια Εδάφη",
    "TG" to "Τόγκο",
    "TH" to "Ταϊλάνδη",
    "TJ" to "Τατζικιστάν",
    "TK" to "Τοκελάου",
    "TL" to "Τιμόρ-Λέστε",
    "TM" to "Τουρκμενιστάν",
    "TN" to "Τυνησία",
    "TO" to "Τόνγκα",
    "TR" to "Τουρκία",
    "TT" to "Τρινιντάντ και Τομπάγκο",
    "TV" to "Τουβαλού",
    "TW" to "Ταϊβάν",
    "TZ" to "Τανζανία",
    "UA" to "Ουκρανία",
    "UG" to "Ουγκάντα",
    "UM" to "Απομακρυσμένες Νησίδες ΗΠΑ",
    "UN" to "Ηνωμένα Έθνη",
    "US" to "Ηνωμένες Πολιτείες",
    "UY" to "Ουρουγουάη",
    "UZ" to "Ουζμπεκιστάν",
    "VA" to "Βατικανό",
    "VC" to "Άγιος Βικέντιος και Γρεναδίνες",
    "VE" to "Βενεζουέλα",
    "VG" to "Βρετανικές Παρθένες Νήσοι",
    "VI" to "Αμερικανικές Παρθένες Νήσοι",
    "VN" to "Βιετνάμ",
    "VU" to "Βανουάτου",
    "WF" to "Γουάλις και Φουτούνα",
    "WS" to "Σαμόα",
    "XA" to "Ψευδο-προφορές",
    "XB" to "Ψευδο-αμφικατευθυντικό",
    "XK" to "Κοσσυφοπέδιο",
    "YE" to "Υεμένη",
    "YT" to "Μαγιότ",
    "ZA" to "Νότια Αφρική",
    "ZM" to "Ζάμπια",
    "ZW" to "Ζιμπάμπουε",
    "ZZ" to "Άγνωστη περιοχή",
  ) }

  val el_CY: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val el_polyton: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Ἀνδόρα",
    "AE" to "Ἠνωμένα Ἀραβικὰ Ἐμιράτα",
    "AF" to "Ἀφγανιστάν",
    "AG" to "Ἀντίγκουα καὶ Μπαρμπούντα",
    "AI" to "Ἀνγκουίλα",
    "AL" to "Ἀλβανία",
    "AM" to "Ἀρμενία",
    "AO" to "Ἀνγκόλα",
    "AQ" to "Ἀνταρκτική",
    "AR" to "Ἀργεντινή",
    "AS" to "Ἀμερικανικὴ Σαμόα",
    "AT" to "Αὐστρία",
    "AU" to "Αὐστραλία",
    "AW" to "Ἀρούμπα",
    "AZ" to "Ἀζερμπαϊτζάν",
    "BA" to "Βοσνία - Ἐρζεγοβίνη",
    "BM" to "Βερμοῦδες",
    "BV" to "Νῆσος Μπουβέ",
    "CC" to "Νῆσοι Κόκος (Κήλινγκ)",
    "CD" to "Κονγκό, Λαϊκὴ Δημοκρατία τοῦ",
    "CF" to "Κεντροαφρικανικὴ Δημοκρατία",
    "CH" to "Ἑλβετία",
    "CK" to "Νῆσοι Κούκ",
    "CX" to "Νῆσος Χριστουγέννων",
    "DO" to "Δομινικανὴ Δημοκρατία",
    "DZ" to "Ἀλγερία",
    "EC" to "Ἰσημερινός",
    "EE" to "Ἐσθονία",
    "EG" to "Αἴγυπτος",
    "EH" to "Δυτικὴ Σαχάρα",
    "ER" to "Ἐρυθραία",
    "ES" to "Ἱσπανία",
    "ET" to "Αἰθιοπία",
    "FM" to "Μικρονησία, Ὁμόσπονδες Πολιτεῖες τῆς",
    "FO" to "Νῆσοι Φερόες",
    "GB" to "Ἡνωμένο Βασίλειο",
    "GF" to "Γαλλικὴ Γουιάνα",
    "GQ" to "Ἰσημερινὴ Γουινέα",
    "GR" to "Ἑλλάδα",
    "HK" to "Χὸνγκ Κόνγκ, Εἰδικὴ Διοικητικὴ Περιφέρεια τῆς Κίνας",
    "HM" to "Νῆσοι Χὲρντ καὶ Μακντόναλντ",
    "HN" to "Ὁνδούρα",
    "HT" to "Ἁϊτή",
    "HU" to "Οὑγγαρία",
    "ID" to "Ἰνδονησία",
    "IE" to "Ἰρλανδία",
    "IL" to "Ἰσραήλ",
    "IN" to "Ἰνδία",
    "IQ" to "Ἰράκ",
    "IR" to "Ἰράν, Ἰσλαμικὴ Δημοκρατία τοῦ",
    "IS" to "Ἰσλανδία",
    "IT" to "Ἰταλία",
    "JO" to "Ἰορδανία",
    "JP" to "Ἰαπωνία",
    "KN" to "Σαὶντ Κὶτς καὶ Νέβις",
    "KY" to "Νῆσοι Κέιμαν",
    "LA" to "Λατινικὴ Ἀμερική",
    "LC" to "Ἁγία Λουκία",
    "LK" to "Σρὶ Λάνκα",
    "LU" to "Λουξεμβοῦργο",
    "MD" to "Μολδαβία, Δημοκρατία τῆς",
    "MH" to "Νῆσοι Μάρσαλ",
    "ML" to "Μαλί",
    "MO" to "Μακάο, Εἰδικὴ Διοικητικὴ Περιφέρεια τῆς Κίνας",
    "MP" to "Νῆσοι Βόρειες Μαριάνες",
    "NF" to "Νῆσος Νόρφολκ",
    "NL" to "Ὁλλανδία",
    "OM" to "Ὀμάν",
    "PF" to "Γαλλικὴ Πολυνησία",
    "PM" to "Σαὶντ Πιὲρ καὶ Μικελόν",
    "PS" to "Παλαιστινιακὰ Ἐδάφη",
    "SA" to "Σαουδικὴ Ἀραβία",
    "SB" to "Νῆσοι Σολομῶντος",
    "SH" to "Ἁγία Ἑλένη",
    "SJ" to "Νῆσοι Σβάλμπαρ καὶ Γιὰν Μαγιέν",
    "SM" to "Ἅγιος Μαρίνος",
    "ST" to "Σάο Τομὲ καὶ Πρίνσιπε",
    "SV" to "Ἒλ Σαλβαδόρ",
    "SY" to "Συρία, Ἀραβικὴ Δημοκρατία τῆς",
    "TC" to "Νῆσοι Τὲρκς καὶ Κάικος",
    "TD" to "Τσάντ",
    "TF" to "Γαλλικὰ Νότια Ἐδάφη",
    "TL" to "Ἀνατολικὸ Τιμόρ",
    "TT" to "Τρινιδὰδ καὶ Τομπάγκο",
    "UA" to "Οὐκρανία",
    "UG" to "Οὐγκάντα",
    "UM" to "Ἀπομακρυσμένες Νησίδες τῶν Ἡνωμένων Πολιτειῶν",
    "US" to "Ἡνωμένες Πολιτεῖες",
    "UY" to "Οὐρουγουάη",
    "UZ" to "Οὐζμπεκιστάν",
    "VA" to "Ἁγία Ἕδρα (Βατικανό)",
    "VC" to "Ἅγιος Βικέντιος καὶ Γρεναδίνες",
    "VG" to "Βρετανικὲς Παρθένοι Νῆσοι",
    "VI" to "Ἀμερικανικὲς Παρθένοι Νῆσοι",
    "WF" to "Νῆσοι Οὐάλλις καὶ Φουτουνά",
    "YE" to "Ὑεμένη",
    "ZA" to "Νότια Ἀφρική",
  ) }

  val en: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "world",
    "002" to "Africa",
    "003" to "North America",
    "005" to "South America",
    "009" to "Oceania",
    "011" to "Western Africa",
    "013" to "Central America",
    "014" to "Eastern Africa",
    "015" to "Northern Africa",
    "017" to "Middle Africa",
    "018" to "Southern Africa",
    "019" to "Americas",
    "021" to "Northern America",
    "029" to "Caribbean",
    "030" to "Eastern Asia",
    "034" to "Southern Asia",
    "035" to "Southeast Asia",
    "039" to "Southern Europe",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Micronesian Region",
    "061" to "Polynesia",
    "142" to "Asia",
    "143" to "Central Asia",
    "145" to "Western Asia",
    "150" to "Europe",
    "151" to "Eastern Europe",
    "154" to "Northern Europe",
    "155" to "Western Europe",
    "202" to "Sub-Saharan Africa",
    "419" to "Latin America",
    "AC" to "Ascension Island",
    "AD" to "Andorra",
    "AE" to "United Arab Emirates",
    "AF" to "Afghanistan",
    "AG" to "Antigua & Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarctica",
    "AR" to "Argentina",
    "AS" to "American Samoa",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Åland Islands",
    "AZ" to "Azerbaijan",
    "BA" to "Bosnia & Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgium",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Caribbean Netherlands",
    "BR" to "Brazil",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Bouvet Island",
    "BW" to "Botswana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Cocos (Keeling) Islands",
    "CD" to "Congo - Kinshasa",
    "CF" to "Central African Republic",
    "CG" to "Congo - Brazzaville",
    "CH" to "Switzerland",
    "CI" to "Côte d’Ivoire",
    "CK" to "Cook Islands",
    "CL" to "Chile",
    "CM" to "Cameroon",
    "CN" to "China",
    "CO" to "Colombia",
    "CP" to "Clipperton Island",
    "CQ" to "Sark",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cape Verde",
    "CW" to "Curaçao",
    "CX" to "Christmas Island",
    "CY" to "Cyprus",
    "CZ" to "Czechia",
    "DE" to "Germany",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Denmark",
    "DM" to "Dominica",
    "DO" to "Dominican Republic",
    "DZ" to "Algeria",
    "EA" to "Ceuta & Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egypt",
    "EH" to "Western Sahara",
    "ER" to "Eritrea",
    "ES" to "Spain",
    "ET" to "Ethiopia",
    "EU" to "European Union",
    "EZ" to "Eurozone",
    "FI" to "Finland",
    "FJ" to "Fiji",
    "FK" to "Falkland Islands",
    "FM" to "Micronesia",
    "FO" to "Faroe Islands",
    "FR" to "France",
    "GA" to "Gabon",
    "GB" to "United Kingdom",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "French Guiana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Greenland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Equatorial Guinea",
    "GR" to "Greece",
    "GS" to "South Georgia & South Sandwich Islands",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong SAR China",
    "HM" to "Heard & McDonald Islands",
    "HN" to "Honduras",
    "HR" to "Croatia",
    "HT" to "Haiti",
    "HU" to "Hungary",
    "IC" to "Canary Islands",
    "ID" to "Indonesia",
    "IE" to "Ireland",
    "IL" to "Israel",
    "IM" to "Isle of Man",
    "IN" to "India",
    "IO" to "British Indian Ocean Territory",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Iceland",
    "IT" to "Italy",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenya",
    "KG" to "Kyrgyzstan",
    "KH" to "Cambodia",
    "KI" to "Kiribati",
    "KM" to "Comoros",
    "KN" to "St. Kitts & Nevis",
    "KP" to "North Korea",
    "KR" to "South Korea",
    "KW" to "Kuwait",
    "KY" to "Cayman Islands",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Lebanon",
    "LC" to "St. Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lithuania",
    "LU" to "Luxembourg",
    "LV" to "Latvia",
    "LY" to "Libya",
    "MA" to "Morocco",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "St. Martin",
    "MG" to "Madagascar",
    "MH" to "Marshall Islands",
    "MK" to "North Macedonia",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Macao SAR China",
    "MP" to "Northern Mariana Islands",
    "MQ" to "Martinique",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldives",
    "MW" to "Malawi",
    "MX" to "Mexico",
    "MY" to "Malaysia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "New Caledonia",
    "NE" to "Niger",
    "NF" to "Norfolk Island",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Netherlands",
    "NO" to "Norway",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "New Zealand",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "French Polynesia",
    "PG" to "Papua New Guinea",
    "PH" to "Philippines",
    "PK" to "Pakistan",
    "PL" to "Poland",
    "PM" to "St. Pierre & Miquelon",
    "PN" to "Pitcairn Islands",
    "PR" to "Puerto Rico",
    "PS" to "Palestinian Territories",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Outlying Oceania",
    "RE" to "Réunion",
    "RO" to "Romania",
    "RS" to "Serbia",
    "RU" to "Russia",
    "RW" to "Rwanda",
    "SA" to "Saudi Arabia",
    "SB" to "Solomon Islands",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Sweden",
    "SG" to "Singapore",
    "SH" to "St. Helena",
    "SI" to "Slovenia",
    "SJ" to "Svalbard & Jan Mayen",
    "SK" to "Slovakia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "South Sudan",
    "ST" to "São Tomé & Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks & Caicos Islands",
    "TD" to "Chad",
    "TF" to "French Southern Territories",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tajikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Türkiye",
    "TT" to "Trinidad & Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraine",
    "UG" to "Uganda",
    "UM" to "U.S. Outlying Islands",
    "UN" to "United Nations",
    "US" to "United States",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Vatican City",
    "VC" to "St. Vincent & Grenadines",
    "VE" to "Venezuela",
    "VG" to "British Virgin Islands",
    "VI" to "U.S. Virgin Islands",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis & Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo-Accents",
    "XB" to "Pseudo-Bidi",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "South Africa",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Unknown Region",
  ) }

  val en_001: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_150: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_AE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_AG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_AI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_AS: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_AT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_AU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "World",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VI" to "US Virgin Islands",
  ) }

  val en_BB: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_BE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_BI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_BM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_BS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_BW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_BZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_CA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "057" to "Micronesian region",
    "AG" to "Antigua and Barbuda",
    "BA" to "Bosnia and Herzegovina",
    "BL" to "Saint-Barthélemy",
    "EA" to "Ceuta and Melilla",
    "GS" to "South Georgia and South Sandwich Islands",
    "HM" to "Heard and McDonald Islands",
    "KN" to "Saint Kitts and Nevis",
    "LC" to "Saint Lucia",
    "MF" to "Saint Martin",
    "PM" to "Saint-Pierre-et-Miquelon",
    "PS" to "Palestinian territories",
    "SH" to "Saint Helena",
    "SJ" to "Svalbard and Jan Mayen",
    "ST" to "São Tomé and Príncipe",
    "TC" to "Turks and Caicos Islands",
    "TT" to "Trinidad and Tobago",
    "UM" to "US Outlying Islands",
    "VC" to "Saint Vincent and the Grenadines",
    "VI" to "US Virgin Islands",
    "WF" to "Wallis and Futuna",
  ) }

  val en_CC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_CK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_CX: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_CY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_DE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_DG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_DK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_DM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_Dsrt: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "𐐎𐐲𐑉𐑊𐐼",
    "002" to "𐐈𐑁𐑉𐐲𐐿𐐲",
    "003" to "𐐤𐐱𐑉𐑃 𐐊𐑋𐐯𐑉𐐲𐐿𐐲",
    "005" to "𐐝𐐵𐑃 𐐊𐑋𐐯𐑉𐐲𐐿𐐲",
    "009" to "𐐄𐑇𐐨𐐰𐑌𐐨𐐲",
    "011" to "𐐎𐐯𐑅𐐻𐐲𐑉𐑌 𐐈𐑁𐑉𐐲𐐿𐐲",
    "013" to "𐐝𐐯𐑌𐐻𐑉𐐲𐑊 𐐊𐑋𐐯𐑉𐐲𐐿𐐲",
    "014" to "𐐀𐑅𐐻𐐲𐑉𐑌 𐐈𐑁𐑉𐐲𐐿𐐲",
    "015" to "𐐤𐐱𐑉𐑄𐐲𐑉𐑌 𐐈𐑁𐑉𐐲𐐿𐐲",
    "017" to "𐐣𐐮𐐼𐑊 𐐈𐑁𐑉𐐮𐐿𐐲",
    "018" to "𐐝𐐲𐑄𐐲𐑉𐑌 𐐈𐑁𐑉𐐲𐐿𐐲",
    "019" to "𐐊𐑋𐐯𐑉𐐲𐐿𐐲𐑆",
    "021" to "𐐤𐐱𐑉𐑄𐐲𐑉𐑌 𐐊𐑋𐐯𐑉𐐲𐐿𐐲",
    "029" to "𐐗𐐯𐑉𐐲𐐺𐐨𐐲𐑌",
    "030" to "𐐀𐑅𐐻𐐲𐑉𐑌 𐐁𐑈𐐲",
    "034" to "𐐝𐐲𐑄𐐲𐑉𐑌 𐐁𐑈𐐲",
    "035" to "𐐝𐐵𐑃-𐐀𐑅𐐻𐐲𐑉𐑌 𐐁𐑈𐐲",
    "039" to "𐐝𐐲𐑄𐐲𐑉𐑌 𐐏𐐲𐑉𐐲𐐹",
    "053" to "𐐉𐑅𐐻𐑉𐐩𐑊𐐨𐐲 𐐰𐑌𐐼 𐐤𐐭 𐐞𐐨𐑊𐐲𐑌𐐼",
    "054" to "𐐣𐐯𐑊𐐲𐑌𐐨𐑈𐐲",
    "057" to "𐐣𐐴𐐿𐑉𐐲𐑌𐐨𐑈𐐲𐑌 𐐡𐐨𐐾𐐲𐑌",
    "061" to "𐐑𐐪𐑊𐐲𐑌𐐨𐑈𐐲",
    "142" to "𐐁𐑈𐐲",
    "143" to "𐐝𐐯𐑌𐐻𐑉𐐲𐑊 𐐁𐑈𐐲",
    "145" to "𐐎𐐯𐑅𐐻𐐲𐑉𐑌 𐐁𐑈𐐲",
    "150" to "𐐏𐐲𐑉𐐲𐐹",
    "151" to "𐐀𐑅𐐻𐐲𐑉𐑌 𐐏𐐲𐑉𐐲𐐹",
    "154" to "𐐤𐐱𐑉𐑄𐐲𐑉𐑌 𐐏𐐲𐑉𐐲𐐹",
    "155" to "𐐎𐐯𐑅𐐻𐐲𐑉𐑌 𐐏𐐲𐑉𐐲𐐹",
    "419" to "𐐢𐐰𐐻𐑌 𐐊𐑋𐐯𐑉𐐲𐐿𐐲 𐐰𐑌𐐼 𐑄 𐐗𐐯𐑉𐐲𐐺𐐨𐐲𐑌",
    "AD" to "𐐈𐑌𐐼𐐱𐑉𐐲",
    "AE" to "𐐏𐐭𐑌𐐴𐐼𐐮𐐼 𐐇𐑉𐐲𐐺 𐐇𐑋𐐲𐑉𐐩𐐻𐑅",
    "AF" to "𐐈𐑁𐑀𐐰𐑌𐐲𐑅𐐻𐐰𐑌",
    "AG" to "𐐈𐑌𐐻𐐨𐑀𐐶𐐲 𐐰𐑌𐐼 𐐒𐐪𐑉𐐺𐐷𐐭𐐼𐐲",
    "AI" to "𐐈𐑍𐑀𐐶𐐮𐑊𐐲",
    "AL" to "𐐈𐑊𐐺𐐩𐑌𐐨𐐲",
    "AM" to "𐐂𐑉𐑋𐐨𐑌𐐨𐐲",
    "AO" to "𐐈𐑌𐑀𐐬𐑊𐐲",
    "AQ" to "𐐈𐑌𐐻𐐪𐑉𐐿𐐻𐐮𐐿𐐲",
    "AR" to "𐐂𐑉𐐾𐐲𐑌𐐻𐐨𐑌𐐲",
    "AS" to "𐐊𐑋𐐯𐑉𐐲𐐿𐐲𐑌 𐐝𐐲𐑋𐐬𐐲",
    "AT" to "𐐉𐑅𐐻𐑉𐐨𐐲",
    "AU" to "𐐉𐑅𐐻𐑉𐐩𐑊𐐨𐐲",
    "AW" to "𐐊𐑉𐐭𐐺𐐲",
    "AX" to "𐐈𐑊𐐰𐑌𐐼 𐐌𐑊𐐲𐑌𐐼𐑆",
    "AZ" to "𐐈𐑆𐐲𐑉𐐺𐐴𐑈𐐪𐑌",
    "BA" to "𐐒𐐱𐑆𐑌𐐨𐐲 𐐰𐑌𐐼 𐐐𐐲𐑉𐐻𐑅𐐲𐑀𐐬𐑂𐐨𐑌𐐲",
    "BB" to "𐐒𐐪𐑉𐐺𐐩𐐼𐐬𐑅",
    "BD" to "𐐒𐐪𐑍𐑀𐑊𐐲𐐼𐐯𐑇",
    "BE" to "𐐒𐐯𐑊𐐾𐐲𐑋",
    "BF" to "𐐒𐐲𐑉𐐿𐐩𐑌𐐲 𐐙𐐰𐑅𐐬",
    "BG" to "𐐒𐐲𐑊𐑀𐐯𐑉𐐨𐐲",
    "BH" to "𐐒𐐪𐑉𐐩𐑌",
    "BI" to "𐐒𐐲𐑉𐐳𐑌𐐼𐐨",
    "BJ" to "𐐒𐐲𐑌𐐨𐑌",
    "BL" to "𐐝𐐩𐑌𐐻 𐐒𐐪𐑉𐐻𐐩𐑊𐐲𐑋𐐨",
    "BM" to "𐐒𐐲𐑉𐑋𐐷𐐭𐐼𐐲",
    "BN" to "𐐒𐑉𐐭𐑌𐐴",
    "BO" to "𐐒𐐬𐑊𐐮𐑂𐐨𐐲",
    "BR" to "𐐒𐑉𐐲𐑆𐐮𐑊",
    "BS" to "𐐒𐐲𐐸𐐪𐑋𐐲𐑅",
    "BT" to "𐐒𐐭𐐻𐐪𐑌",
    "BV" to "𐐒𐐭𐑂𐐩 𐐌𐑊𐐲𐑌𐐼",
    "BW" to "𐐒𐐪𐐻𐑅𐐶𐐪𐑌𐐲",
    "BY" to "𐐒𐐯𐑊𐐲𐑉𐐭𐑅",
    "BZ" to "𐐒𐐲𐑊𐐨𐑆",
    "CA" to "𐐗𐐰𐑌𐐲𐐼𐐲",
    "CC" to "𐐗𐐬𐐿𐐬𐑆 𐐌𐑊𐐲𐑌𐐼𐑆",
    "CD" to "𐐗𐐪𐑍𐑀𐐬 - 𐐗𐐲𐑌𐑇𐐪𐑅𐐲",
    "CF" to "𐐝𐐯𐑌𐐻𐑉𐐲𐑊 𐐈𐑁𐑉𐐲𐐿𐐲𐑌 𐐡𐐨𐐹𐐲𐐺𐑊𐐮𐐿",
    "CG" to "𐐗𐐪𐑍𐑀𐐬 - 𐐒𐑉𐐪𐑆𐐲𐑂𐐮𐑊",
    "CH" to "𐐝𐐶𐐮𐐻𐑅𐐲𐑉𐑊𐐲𐑌𐐼",
    "CI" to "𐐌𐑂𐑉𐐨 𐐗𐐬𐑅𐐻",
    "CK" to "𐐗𐐳𐐿 𐐌𐑊𐐲𐑌𐐼𐑆",
    "CL" to "𐐕𐐨𐑊𐐩",
    "CM" to "𐐗𐐰𐑋𐐲𐑉𐐭𐑌",
    "CN" to "𐐕𐐴𐑌𐐲",
    "CO" to "𐐗𐐲𐑊𐐲𐑋𐐺𐐨𐐲",
    "CR" to "𐐗𐐱𐑅𐐻𐐲 𐐡𐐨𐐿𐐲",
    "CU" to "𐐗𐐷𐐭𐐺𐐲",
    "CV" to "𐐗𐐩𐐹 𐐚𐐯𐑉𐐼𐐨",
    "CX" to "𐐗𐑉𐐮𐑅𐑋𐐲𐑅 𐐌𐑊𐐲𐑌𐐼",
    "CY" to "𐐝𐐴𐐹𐑉𐐲𐑅",
    "CZ" to "𐐕𐐯𐐿 𐐡𐐨𐐹𐐲𐐺𐑊𐐮𐐿",
    "DE" to "𐐖𐐲𐑉𐑋𐐲𐑌𐐨",
    "DJ" to "𐐖𐐲𐐺𐐭𐐼𐐨",
    "DK" to "𐐔𐐯𐑌𐑋𐐪𐑉𐐿",
    "DM" to "𐐔𐐪𐑋𐐲𐑌𐐨𐐿𐐲",
    "DO" to "𐐔𐐲𐑋𐐮𐑌𐐲𐐿𐐲𐑌 𐐡𐐨𐐹𐐲𐐺𐑊𐐮𐐿",
    "DZ" to "𐐈𐑊𐐾𐐮𐑉𐐨𐐲",
    "EC" to "𐐇𐐿𐐶𐐲𐐼𐐱𐑉",
    "EE" to "𐐇𐑅𐐻𐐬𐑌𐐨𐐲",
    "EG" to "𐐀𐐾𐐲𐐹𐐻",
    "EH" to "𐐎𐐯𐑅𐐻𐐲𐑉𐑌 𐐝𐐲𐐸𐐱𐑉𐐲",
    "ER" to "𐐇𐑉𐐮𐐻𐑉𐐨𐐲",
    "ES" to "𐐝𐐹𐐩𐑌",
    "ET" to "𐐀𐑃𐐨𐐬𐐹𐐨𐐲",
    "EU" to "𐐏𐐲𐑉𐐲𐐹𐐨𐐲𐑌 𐐏𐐭𐑌𐐷𐐲𐑌",
    "FI" to "𐐙𐐮𐑌𐑊𐐲𐑌𐐼",
    "FJ" to "𐐙𐐨𐐾𐐨",
    "FK" to "𐐙𐐪𐑊𐐿𐑊𐐲𐑌𐐼 𐐌𐑊𐐲𐑌𐐼𐑆",
    "FM" to "𐐣𐐴𐐿𐑉𐐲𐑌𐐨𐑈𐐲",
    "FO" to "𐐙𐐯𐑉𐐬 𐐌𐑊𐐲𐑌𐐼𐑆",
    "FR" to "𐐙𐑉𐐰𐑌𐑅",
    "GA" to "𐐘𐐲𐐺𐐪𐑌",
    "GB" to "𐐏𐐭𐑌𐐴𐐻𐐲𐐼 𐐗𐐨𐑍𐐼𐐲𐑋",
    "GD" to "𐐘𐑉𐐲𐑌𐐩𐐼𐐲",
    "GE" to "𐐖𐐱𐑉𐐾𐐲",
    "GF" to "𐐙𐑉𐐯𐑌𐐽 𐐘𐐨𐐪𐑌𐐲",
    "GG" to "𐐘𐐲𐑉𐑌𐑆𐐨",
    "GH" to "𐐘𐐪𐑌𐐲",
    "GI" to "𐐖𐐲𐐺𐑉𐐱𐑊𐐻𐐲𐑉",
    "GL" to "𐐘𐑉𐐨𐑌𐑊𐐲𐑌𐐼",
    "GM" to "𐐘𐐰𐑋𐐺𐐨𐐲",
    "GN" to "𐐘𐐮𐑌𐐨",
    "GP" to "𐐘𐐶𐐪𐐼𐐲𐑊𐐭𐐹",
    "GQ" to "𐐇𐐿𐐶𐐲𐐻𐐱𐑉𐐨𐐲𐑊 𐐘𐐮𐑌𐐨",
    "GR" to "𐐘𐑉𐐨𐑅",
    "GS" to "𐐝𐐵𐑃 𐐖𐐱𐑉𐐾𐐲 𐐰𐑌𐐼 𐑄 𐐝𐐵𐑃 𐐝𐐰𐑌𐐼𐐶𐐮𐐽 𐐌𐑊𐐲𐑌𐐼𐑆",
    "GT" to "𐐘𐐶𐐪𐐼𐐲𐑋𐐪𐑊𐐲",
    "GU" to "𐐘𐐶𐐪𐑋",
    "GW" to "𐐘𐐮𐑌𐐨-𐐒𐐮𐑅𐐵",
    "GY" to "𐐘𐐴𐐰𐑌𐐲",
    "HK" to "𐐐𐐬𐑍 𐐗𐐬𐑍 𐐝𐐈𐐡 𐐕𐐴𐑌𐐲",
    "HM" to "𐐐𐐲𐑉𐐼 𐐌𐑊𐐲𐑌𐐼 𐐰𐑌𐐼 𐐣𐐿𐐔𐐱𐑌𐐲𐑊𐐼 𐐌𐑊𐐲𐑌𐐼𐑆",
    "HN" to "𐐐𐐪𐑌𐐼𐐭𐑉𐐲𐑅",
    "HR" to "𐐗𐑉𐐬𐐩𐑇𐐲",
    "HT" to "𐐐𐐩𐐻𐐨",
    "HU" to "𐐐𐐲𐑍𐑀𐐲𐑉𐐨",
    "ID" to "𐐆𐑌𐐼𐐲𐑌𐐨𐑈𐐲",
    "IE" to "𐐌𐑉𐑊𐐲𐑌𐐼",
    "IL" to "𐐆𐑆𐑉𐐨𐐲𐑊",
    "IM" to "𐐌𐐲𐑊 𐐲𐑁 𐐣𐐰𐑌",
    "IN" to "𐐆𐑌𐐼𐐨𐐲",
    "IQ" to "𐐆𐑉𐐰𐐿",
    "IR" to "𐐆𐑉𐐪𐑌",
    "IS" to "𐐌𐑅𐑊𐐲𐑌𐐼",
    "IT" to "𐐆𐐻𐐲𐑊𐐨",
    "JE" to "𐐖𐐲𐑉𐑆𐐨",
    "JM" to "𐐖𐐲𐑋𐐩𐐿𐐲",
    "JO" to "𐐖𐐱𐑉𐐼𐐲𐑌",
    "JP" to "𐐖𐐲𐐹𐐰𐑌",
    "KE" to "𐐗𐐯𐑌𐐷𐐲",
    "KG" to "𐐗𐐮𐑉𐑀𐐲𐑅𐐻𐐰𐑌",
    "KH" to "𐐗𐐰𐑋𐐺𐐬𐐼𐐨𐐲",
    "KI" to "𐐗𐐮𐑉𐐲𐐺𐐪𐐻𐐨",
    "KM" to "𐐗𐐪𐑋𐐲𐑉𐐬𐑆",
    "KN" to "𐐝𐐩𐑌𐐻 𐐗𐐮𐐻𐑅 𐐰𐑌𐐼 𐐤𐐨𐑂𐐮𐑅",
    "KP" to "𐐤𐐱𐑉𐑃 𐐗𐐲𐑉𐐨𐐲",
    "KR" to "𐐝𐐵𐑃 𐐗𐐲𐑉𐐨𐐲",
    "KW" to "𐐗𐐲𐐶𐐩𐐻",
    "KY" to "𐐗𐐩𐑋𐐲𐑌 𐐌𐑊𐐲𐑌𐐼𐑆",
    "KZ" to "𐐗𐐲𐑆𐐪𐐿𐑅𐐻𐐪𐑌",
    "LA" to "𐐢𐐪𐐬𐑅",
    "LB" to "𐐢𐐯𐐺𐐲𐑌𐐪𐑌",
    "LI" to "𐐢𐐮𐐿𐐻𐐲𐑌𐑅𐐻𐐴𐑌",
    "LK" to "𐐟𐑉𐐨 𐐢𐐰𐑍𐐿𐐲",
    "LR" to "𐐢𐐴𐐺𐐮𐑉𐐨𐐲",
    "LS" to "𐐢𐐲𐑅𐐬𐑃𐐬",
    "LT" to "𐐢𐐮𐑃𐐲𐐶𐐩𐑌𐐨𐐲",
    "LU" to "𐐢𐐲𐐿𐑅𐐲𐑋𐐺𐐲𐑉𐑀",
    "LV" to "𐐢𐐰𐐻𐑂𐐨𐐲",
    "LY" to "𐐢𐐮𐐺𐐨𐐲",
    "MA" to "𐐣𐐲𐑉𐐪𐐿𐐬",
    "MC" to "𐐣𐐪𐑌𐐲𐐿𐐬",
    "MD" to "𐐣𐐱𐑊𐐼𐐬𐑂𐐲",
    "ME" to "𐐣𐐪𐑌𐐲𐑌𐐨𐑀𐑉𐐬",
    "MF" to "𐐝𐐩𐑌𐐻 𐐣𐐪𐑉𐐻𐑌",
    "MG" to "𐐣𐐰𐐼𐐲𐑀𐐰𐑅𐐿𐐲𐑉",
    "MH" to "𐐣𐐪𐑉𐑇𐐲𐑊 𐐌𐑊𐐲𐑌𐐼𐑆",
    "MK" to "𐐣𐐰𐑅𐐲𐐼𐐬𐑌𐐨𐐲",
    "ML" to "𐐣𐐪𐑊𐐨",
    "MM" to "𐐣𐐨𐐲𐑌𐑋𐐪𐑉",
    "MN" to "𐐣𐐪𐑍𐑀𐐬𐑊𐐨𐐲",
    "MO" to "𐐣𐐲𐐿𐐵 𐐝𐐈𐐡 𐐕𐐴𐑌𐐲",
    "MP" to "𐐤𐐱𐑉𐑄𐐲𐑉𐑌 𐐣𐐰𐑉𐐨𐐱𐑌𐐲 𐐌𐑊𐐲𐑌𐐼𐑆",
    "MQ" to "𐐣𐐪𐑉𐐻𐑌𐐨𐐿",
    "MR" to "𐐣𐐱𐑉𐐲𐐻𐐩𐑌𐐨𐐲",
    "MS" to "𐐣𐐪𐑌𐐻𐑅𐐲𐑉𐐪𐐻",
    "MT" to "𐐣𐐱𐑊𐐻𐐲",
    "MU" to "𐐣𐐱𐑉𐐮𐑇𐐲𐑅",
    "MV" to "𐐣𐐪𐑊𐐼𐐨𐑂𐑆",
    "MW" to "𐐣𐐲𐑊𐐪𐐶𐐨",
    "MX" to "𐐣𐐯𐐿𐑅𐐲𐐿𐐬",
    "MY" to "𐐣𐐲𐑊𐐩𐑈𐐲",
    "MZ" to "𐐣𐐬𐑆𐐰𐑋𐐺𐐨𐐿",
    "NA" to "𐐤𐐲𐑋𐐮𐐺𐐨𐐲",
    "NC" to "𐐤𐐭 𐐗𐐰𐑊𐐲𐐼𐐬𐑌𐐷𐐲",
    "NE" to "𐐤𐐴𐐾𐐲𐑉",
    "NF" to "𐐤𐐱𐑉𐑁𐐲𐐿 𐐌𐑊𐐲𐑌𐐼",
    "NG" to "𐐤𐐴𐐾𐐮𐑉𐐨𐐲",
    "NI" to "𐐤𐐮𐐿𐐲𐑉𐐪𐑀𐐶𐐲",
    "NL" to "𐐤𐐯𐑄𐐲𐑉𐑊𐐲𐑌𐐼𐑆",
    "NO" to "𐐤𐐱𐑉𐐶𐐩",
    "NP" to "𐐤𐐩𐐹𐐪𐑊",
    "NR" to "𐐤𐐪𐐭𐑉𐐭",
    "NU" to "𐐤𐐷𐐭𐐩",
    "NZ" to "𐐤𐐭 𐐞𐐨𐑊𐐲𐑌𐐼",
    "OM" to "𐐄𐑋𐐲𐑌",
    "PA" to "𐐑𐐰𐑌𐐲𐑋𐐪",
    "PE" to "𐐑𐐲𐑉𐐭",
    "PF" to "𐐙𐑉𐐯𐑌𐐽 𐐑𐐪𐑊𐐲𐑌𐐨𐑈𐐲",
    "PG" to "𐐑𐐰𐐹𐐷𐐳𐐲 𐐤𐐭 𐐘𐐮𐑌𐐨",
    "PH" to "𐐙𐐮𐑊𐐲𐐹𐐨𐑌𐑆",
    "PK" to "𐐑𐐰𐐿𐐲𐑅𐐻𐐰𐑌",
    "PL" to "𐐑𐐬𐑊𐐲𐑌𐐼",
    "PM" to "𐐝𐐩𐑌𐐻 𐐑𐐨𐐯𐑉 𐐰𐑌𐐼 𐐣𐐨𐐿𐐲𐑊𐐪𐑌",
    "PN" to "𐐑𐐮𐐻𐐿𐐯𐑉𐑌",
    "PR" to "𐐑𐐶𐐯𐑉𐐻𐐬 𐐡𐐨𐐿𐐬",
    "PS" to "𐐑𐐰𐑊𐐲𐑅𐐻𐐮𐑌𐐨𐐲𐑌 𐐓𐐯𐑉𐐲𐐻𐐱𐑉𐐨",
    "PT" to "𐐑𐐱𐑉𐐽𐐲𐑀𐐲𐑊",
    "PW" to "𐐑𐐲𐑊𐐵",
    "PY" to "𐐑𐐯𐑉𐐲𐑀𐐶𐐴",
    "QA" to "𐐗𐐲𐐻𐐪𐑉",
    "QO" to "𐐍𐐻𐑊𐐴𐐮𐑍 𐐄𐑇𐐨𐐰𐑌𐐨𐐲",
    "RE" to "𐐡𐐨𐐷𐐭𐑌𐐷𐐲𐑌",
    "RO" to "𐐡𐐬𐑋𐐩𐑌𐐨𐐲",
    "RS" to "𐐝𐐲𐑉𐐺𐐨𐐲",
    "RU" to "𐐡𐐲𐑇𐐲",
    "RW" to "𐐡𐐲𐐶𐐪𐑌𐐼𐐲",
    "SA" to "𐐝𐐵𐐼𐐨 𐐊𐑉𐐩𐐺𐐨𐐲",
    "SB" to "𐐝𐐪𐑊𐐲𐑋𐐲𐑌 𐐌𐑊𐐲𐑌𐐼𐑆",
    "SC" to "𐐝𐐩𐑇𐐯𐑊𐑆",
    "SD" to "𐐝𐐭𐐼𐐰𐑌",
    "SE" to "𐐝𐐶𐐨𐐼𐑌",
    "SG" to "𐐝𐐮𐑍𐐲𐐹𐐱𐑉",
    "SH" to "𐐝𐐩𐑌𐐻 𐐐𐐯𐑊𐐲𐑌𐐲",
    "SI" to "𐐝𐑊𐐬𐑂𐐨𐑌𐐨𐐲",
    "SJ" to "𐐝𐑂𐐪𐑊𐐺𐐪𐑉𐐼 𐐰𐑌𐐼 𐐖𐐰𐑌 𐐣𐐴𐐲𐑌",
    "SK" to "𐐝𐑊𐐬𐑂𐐪𐐿𐐨𐐲",
    "SL" to "𐐝𐐨𐐯𐑉𐐲 𐐢𐐨𐐬𐑌",
    "SM" to "𐐝𐐪𐑌 𐐣𐐲𐑉𐐨𐑌𐐬",
    "SN" to "𐐝𐐯𐑌𐐲𐑀𐐱𐑊",
    "SO" to "𐐝𐐲𐑋𐐪𐑊𐐨𐐲",
    "SR" to "𐐝𐐭𐑉𐐲𐑌𐐪𐑋",
    "ST" to "𐐝𐐵 𐐓𐐬𐑋 𐐰𐑌𐐼 𐐑𐑉𐐮𐑌𐐽𐐮𐐹𐐩",
    "SV" to "𐐇𐑊 𐐝𐐰𐑊𐑂𐐲𐐼𐐱𐑉",
    "SY" to "𐐝𐐮𐑉𐐨𐐲",
    "SZ" to "𐐝𐐶𐐪𐑆𐐨𐑊𐐰𐑌𐐼",
    "TC" to "𐐓𐐲𐑉𐐿𐑅 𐐰𐑌𐐼 𐐗𐐴𐐿𐐬𐑆 𐐌𐑊𐐲𐑌𐐼𐑆",
    "TD" to "𐐕𐐰𐐼",
    "TF" to "𐐙𐑉𐐯𐑌𐐽 𐐝𐐲𐑄𐐲𐑉𐑌 𐐓𐐯𐑉𐐲𐐻𐐱𐑉𐐨𐑆",
    "TG" to "𐐓𐐬𐑀𐐬",
    "TH" to "𐐓𐐴𐑊𐐰𐑌𐐼",
    "TJ" to "𐐓𐐲𐐾𐐨𐐿𐐲𐑅𐐻𐐰𐑌",
    "TK" to "𐐓𐐬𐐿𐐯𐑊𐐵",
    "TL" to "𐐀𐑅𐐻 𐐓𐐨𐑋𐐱𐑉",
    "TM" to "𐐓𐐲𐑉𐐿𐑋𐐯𐑌𐐲𐑅𐐻𐐰𐑌",
    "TO" to "𐐓𐐪𐑍𐑀𐐲",
    "TR" to "𐐓𐐲𐑉𐐿𐐨",
    "TT" to "𐐓𐑉𐐮𐑌𐐮𐐼𐐰𐐼 𐐰𐑌𐐼 𐐓𐐲𐐺𐐩𐑀𐐬",
    "TV" to "𐐓𐐲𐑂𐐪𐑊𐐭",
    "TW" to "𐐓𐐴𐐶𐐪𐑌",
    "TZ" to "𐐓𐐰𐑌𐑆𐐲𐑌𐐨𐐲",
    "UG" to "𐐏𐐭𐑀𐐰𐑌𐐼𐐲",
    "UM" to "𐐏𐐭𐑌𐐰𐐮𐐻𐐲𐐼 𐐝𐐻𐐩𐐻𐑅 𐐣𐐴𐑌𐐬𐑉 𐐍𐐻𐑊𐐴𐐨𐑍 𐐌𐑊𐐲𐑌𐐼𐑆",
    "US" to "𐐏𐐭𐑌𐐴𐐻𐐲𐐼 𐐝𐐻𐐩𐐻𐑅",
    "UY" to "𐐏𐐳𐑉𐐲𐑀𐐶𐐴",
    "UZ" to "𐐅𐑆𐐺𐐯𐐿𐐲𐑅𐐻𐐰𐑌",
    "VA" to "𐐚𐐰𐐼𐐲𐐿𐐲𐑌",
    "VC" to "𐐝𐐩𐑌𐐻 𐐚𐐮𐑌𐑅𐐲𐑌𐐻 𐐰𐑌𐐼 𐑄 𐐘𐑉𐐯𐑌𐐲𐐼𐐨𐑌𐑆",
    "VG" to "𐐒𐑉𐐮𐐼𐐮𐑇 𐐚𐐲𐑉𐐾𐐲𐑌 𐐌𐑊𐐲𐑌𐐼𐑆",
    "VI" to "𐐏.𐐝. 𐐚𐐲𐑉𐐾𐐲𐑌 𐐌𐑊𐐲𐑌𐐼𐑆",
    "VN" to "𐐚𐐨𐐯𐐻𐑌𐐪𐑋",
    "VU" to "𐐚𐐪𐑌𐐳𐐪𐐼𐐭",
    "WF" to "𐐎𐐪𐑊𐐮𐑅 𐐰𐑌𐐼 𐐙𐐭𐐻𐐭𐑌𐐲",
    "WS" to "𐐝𐐲𐑋𐐬𐐲",
    "YE" to "𐐏𐐯𐑋𐐲𐑌",
    "YT" to "𐐣𐐪𐐷𐐱𐐻",
    "ZA" to "𐐝𐐵𐑃 𐐈𐑁𐑉𐐲𐐿𐐲",
    "ZM" to "𐐞𐐰𐑋𐐺𐐨𐐲",
    "ZW" to "𐐞𐐮𐑋𐐺𐐪𐐺𐐶𐐩",
    "ZZ" to "𐐊𐑌𐐬𐑌 𐐬𐑉 𐐆𐑌𐑂𐐰𐑊𐐮𐐼 𐐡𐐨𐐾𐐲𐑌",
  ) }

  val en_ER: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_FI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_FJ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_FK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_FM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_GB: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_GD: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_GG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_GI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_GM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_GU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_GY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_HK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_ID: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_IE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_IL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_IM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_IO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_JE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_JM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_KE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_KI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_KN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_KY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_LC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_LR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_LS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_MG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_MH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_MO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_MP: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_MS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_MT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_MU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_MV: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_MW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_MY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_NA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_NF: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_NG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_NL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_NR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_NU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_NZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_PG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_PH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_PK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_PN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_PR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_PW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_RW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SB: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SD: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SX: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_SZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_TC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_TK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_TO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_TT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_TV: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_TZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_UG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_UM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_VC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_VG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_VI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_VU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_WS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_ZA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_ZM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val en_ZW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BL" to "St Barthélemy",
    "KN" to "St Kitts & Nevis",
    "LC" to "St Lucia",
    "MF" to "St Martin",
    "PM" to "St Pierre & Miquelon",
    "SH" to "St Helena",
    "UM" to "US Outlying Islands",
    "VC" to "St Vincent & the Grenadines",
    "VI" to "US Virgin Islands",
  ) }

  val eo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mondo",
    "AD" to "Andoro",
    "AE" to "Unuiĝintaj Arabaj Emirlandoj",
    "AF" to "Afganujo",
    "AG" to "Antigvo kaj Barbudo",
    "AI" to "Angvilo",
    "AL" to "Albanujo",
    "AM" to "Armenujo",
    "AO" to "Angolo",
    "AQ" to "Antarkto",
    "AR" to "Argentino",
    "AT" to "Aŭstrujo",
    "AU" to "Aŭstralio",
    "AW" to "Arubo",
    "AZ" to "Azerbajĝano",
    "BA" to "Bosnujo kaj Hercegovino",
    "BB" to "Barbado",
    "BD" to "Bangladeŝo",
    "BE" to "Belgujo",
    "BF" to "Burkino",
    "BG" to "Bulgarujo",
    "BH" to "Barejno",
    "BI" to "Burundo",
    "BJ" to "Benino",
    "BM" to "Bermudoj",
    "BN" to "Brunejo",
    "BO" to "Bolivio",
    "BR" to "Brazilo",
    "BS" to "Bahamoj",
    "BT" to "Butano",
    "BW" to "Bocvano",
    "BY" to "Belorusujo",
    "BZ" to "Belizo",
    "CA" to "Kanado",
    "CF" to "Centr-Afrika Respubliko",
    "CG" to "Kongo Brazavila",
    "CH" to "Svisujo",
    "CI" to "Ebur-Bordo",
    "CK" to "Kukinsuloj",
    "CL" to "Ĉilio",
    "CM" to "Kameruno",
    "CN" to "Ĉinujo",
    "CO" to "Kolombio",
    "CR" to "Kostariko",
    "CU" to "Kubo",
    "CV" to "Kaboverdo",
    "CY" to "Kipro",
    "CZ" to "Ĉeĥujo",
    "DE" to "Germanujo",
    "DJ" to "Ĝibutio",
    "DK" to "Danujo",
    "DM" to "Dominiko",
    "DO" to "Domingo",
    "DZ" to "Alĝerio",
    "EC" to "Ekvadoro",
    "EE" to "Estonujo",
    "EG" to "Egiptujo",
    "EH" to "Okcidenta Saharo",
    "ER" to "Eritreo",
    "ES" to "Hispanujo",
    "ET" to "Etiopujo",
    "FI" to "Finnlando",
    "FJ" to "Fiĝoj",
    "FM" to "Mikronezio",
    "FO" to "Ferooj",
    "FR" to "Francujo",
    "GA" to "Gabono",
    "GB" to "Unuiĝinta Reĝlando",
    "GD" to "Grenado",
    "GE" to "Kartvelujo",
    "GF" to "Franca Gviano",
    "GH" to "Ganao",
    "GI" to "Ĝibraltaro",
    "GL" to "Gronlando",
    "GM" to "Gambio",
    "GN" to "Gvineo",
    "GP" to "Gvadelupo",
    "GQ" to "Ekvatora Gvineo",
    "GR" to "Grekujo",
    "GS" to "Sud-Georgio kaj Sud-Sandviĉinsuloj",
    "GT" to "Gvatemalo",
    "GU" to "Gvamo",
    "GW" to "Gvineo-Bisaŭo",
    "GY" to "Gujano",
    "HM" to "Herda kaj Makdonaldaj Insuloj",
    "HN" to "Honduro",
    "HR" to "Kroatujo",
    "HT" to "Haitio",
    "HU" to "Hungarujo",
    "ID" to "Indonezio",
    "IE" to "Irlando",
    "IL" to "Israelo",
    "IN" to "Hindujo",
    "IQ" to "Irako",
    "IR" to "Irano",
    "IS" to "Islando",
    "IT" to "Italujo",
    "JM" to "Jamajko",
    "JO" to "Jordanio",
    "JP" to "Japanujo",
    "KE" to "Kenjo",
    "KG" to "Kirgizujo",
    "KH" to "Kamboĝo",
    "KI" to "Kiribato",
    "KM" to "Komoroj",
    "KN" to "Sankta Kristoforo kaj Neviso",
    "KP" to "Nord-Koreo",
    "KR" to "Sud-Koreo",
    "KW" to "Kuvajto",
    "KY" to "Kejmanoj",
    "KZ" to "Kazaĥujo",
    "LA" to "Laoso",
    "LB" to "Libano",
    "LC" to "Sankta Lucio",
    "LI" to "Liĥtenŝtejno",
    "LK" to "Srilanko",
    "LR" to "Liberio",
    "LS" to "Lesoto",
    "LT" to "Litovujo",
    "LU" to "Luksemburgo",
    "LV" to "Latvujo",
    "LY" to "Libio",
    "MA" to "Maroko",
    "MC" to "Monako",
    "MD" to "Moldavujo",
    "MG" to "Madagaskaro",
    "MH" to "Marŝaloj",
    "ML" to "Malio",
    "MM" to "Birmo",
    "MN" to "Mongolujo",
    "MP" to "Nord-Marianoj",
    "MQ" to "Martiniko",
    "MR" to "Maŭritanujo",
    "MT" to "Malto",
    "MU" to "Maŭricio",
    "MV" to "Maldivoj",
    "MW" to "Malavio",
    "MX" to "Meksiko",
    "MY" to "Malajzio",
    "MZ" to "Mozambiko",
    "NA" to "Namibio",
    "NC" to "Nov-Kaledonio",
    "NE" to "Niĝero",
    "NF" to "Norfolkinsulo",
    "NG" to "Niĝerio",
    "NI" to "Nikaragvo",
    "NL" to "Nederlando",
    "NO" to "Norvegujo",
    "NP" to "Nepalo",
    "NR" to "Nauro",
    "NU" to "Niuo",
    "NZ" to "Nov-Zelando",
    "OM" to "Omano",
    "PA" to "Panamo",
    "PE" to "Peruo",
    "PF" to "Franca Polinezio",
    "PG" to "Papuo-Nov-Gvineo",
    "PH" to "Filipinoj",
    "PK" to "Pakistano",
    "PL" to "Pollando",
    "PM" to "Sankta Piero kaj Mikelono",
    "PN" to "Pitkarna Insulo",
    "PR" to "Puertoriko",
    "PT" to "Portugalujo",
    "PW" to "Palaŭo",
    "PY" to "Paragvajo",
    "QA" to "Kataro",
    "RE" to "Reunio",
    "RO" to "Rumanujo",
    "RU" to "Rusujo",
    "RW" to "Ruando",
    "SA" to "Sauda Arabujo",
    "SB" to "Salomonoj",
    "SC" to "Sejŝeloj",
    "SD" to "Sudano",
    "SE" to "Svedujo",
    "SG" to "Singapuro",
    "SH" to "Sankta Heleno",
    "SI" to "Slovenujo",
    "SJ" to "Svalbardo kaj Janmajeno",
    "SK" to "Slovakujo",
    "SL" to "Sieraleono",
    "SM" to "Sanmarino",
    "SN" to "Senegalo",
    "SO" to "Somalujo",
    "SR" to "Surinamo",
    "ST" to "Santomeo kaj Principeo",
    "SV" to "Salvadoro",
    "SY" to "Sirio",
    "SZ" to "Svazilando",
    "TD" to "Ĉado",
    "TG" to "Togolando",
    "TH" to "Tajlando",
    "TJ" to "Taĝikujo",
    "TM" to "Turkmenujo",
    "TN" to "Tunizio",
    "TO" to "Tongo",
    "TR" to "Turkujo",
    "TT" to "Trinidado kaj Tobago",
    "TV" to "Tuvalo",
    "TW" to "Tajvano",
    "TZ" to "Tanzanio",
    "UA" to "Ukrainujo",
    "UG" to "Ugando",
    "UM" to "Usonaj malgrandaj insuloj",
    "US" to "Usono",
    "UY" to "Urugvajo",
    "UZ" to "Uzbekujo",
    "VA" to "Vatikano",
    "VC" to "Sankta Vincento kaj Grenadinoj",
    "VE" to "Venezuelo",
    "VG" to "Britaj Virgulininsuloj",
    "VI" to "Usonaj Virgulininsuloj",
    "VN" to "Vjetnamo",
    "VU" to "Vanuatuo",
    "WF" to "Valiso kaj Futuno",
    "WS" to "Samoo",
    "YE" to "Jemeno",
    "YT" to "Majoto",
    "ZA" to "Sud-Afriko",
    "ZM" to "Zambio",
    "ZW" to "Zimbabvo",
  ) }

  val es: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Mundo",
    "002" to "África",
    "003" to "América del Norte",
    "005" to "Sudamérica",
    "009" to "Oceanía",
    "011" to "África occidental",
    "013" to "Centroamérica",
    "014" to "África oriental",
    "015" to "África septentrional",
    "017" to "África central",
    "018" to "África meridional",
    "019" to "América",
    "021" to "Norteamérica",
    "029" to "Caribe",
    "030" to "Asia oriental",
    "034" to "Asia meridional",
    "035" to "Sudeste asiático",
    "039" to "Europa meridional",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Región de Micronesia",
    "061" to "Polinesia",
    "142" to "Asia",
    "143" to "Asia central",
    "145" to "Asia occidental",
    "150" to "Europa",
    "151" to "Europa oriental",
    "154" to "Europa septentrional",
    "155" to "Europa occidental",
    "202" to "África subsahariana",
    "419" to "Latinoamérica",
    "AC" to "Isla de la Ascensión",
    "AD" to "Andorra",
    "AE" to "Emiratos Árabes Unidos",
    "AF" to "Afganistán",
    "AG" to "Antigua y Barbuda",
    "AI" to "Anguila",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antártida",
    "AR" to "Argentina",
    "AS" to "Samoa Americana",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Islas Aland",
    "AZ" to "Azerbaiyán",
    "BA" to "Bosnia y Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladés",
    "BE" to "Bélgica",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Baréin",
    "BI" to "Burundi",
    "BJ" to "Benín",
    "BL" to "San Bartolomé",
    "BM" to "Bermudas",
    "BN" to "Brunéi",
    "BO" to "Bolivia",
    "BQ" to "Caribe neerlandés",
    "BR" to "Brasil",
    "BS" to "Bahamas",
    "BT" to "Bután",
    "BV" to "Isla Bouvet",
    "BW" to "Botsuana",
    "BY" to "Bielorrusia",
    "BZ" to "Belice",
    "CA" to "Canadá",
    "CC" to "Islas Cocos",
    "CD" to "República Democrática del Congo",
    "CF" to "República Centroafricana",
    "CG" to "Congo",
    "CH" to "Suiza",
    "CI" to "Côte d’Ivoire",
    "CK" to "Islas Cook",
    "CL" to "Chile",
    "CM" to "Camerún",
    "CN" to "China",
    "CO" to "Colombia",
    "CP" to "Isla Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cabo Verde",
    "CW" to "Curazao",
    "CX" to "Isla de Navidad",
    "CY" to "Chipre",
    "CZ" to "Chequia",
    "DE" to "Alemania",
    "DG" to "Diego García",
    "DJ" to "Yibuti",
    "DK" to "Dinamarca",
    "DM" to "Dominica",
    "DO" to "República Dominicana",
    "DZ" to "Argelia",
    "EA" to "Ceuta y Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egipto",
    "EH" to "Sáhara Occidental",
    "ER" to "Eritrea",
    "ES" to "España",
    "ET" to "Etiopía",
    "EU" to "Unión Europea",
    "EZ" to "zona del euro",
    "FI" to "Finlandia",
    "FJ" to "Fiyi",
    "FK" to "Islas Malvinas",
    "FM" to "Micronesia",
    "FO" to "Islas Feroe",
    "FR" to "Francia",
    "GA" to "Gabón",
    "GB" to "Reino Unido",
    "GD" to "Granada",
    "GE" to "Georgia",
    "GF" to "Guayana Francesa",
    "GG" to "Guernesey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Groenlandia",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadalupe",
    "GQ" to "Guinea Ecuatorial",
    "GR" to "Grecia",
    "GS" to "Islas Georgia del Sur y Sandwich del Sur",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bisáu",
    "GY" to "Guyana",
    "HK" to "RAE de Hong Kong (China)",
    "HM" to "Islas Heard y McDonald",
    "HN" to "Honduras",
    "HR" to "Croacia",
    "HT" to "Haití",
    "HU" to "Hungría",
    "IC" to "Canarias",
    "ID" to "Indonesia",
    "IE" to "Irlanda",
    "IL" to "Israel",
    "IM" to "Isla de Man",
    "IN" to "India",
    "IO" to "Territorio Británico del Océano Índico",
    "IQ" to "Irak",
    "IR" to "Irán",
    "IS" to "Islandia",
    "IT" to "Italia",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordania",
    "JP" to "Japón",
    "KE" to "Kenia",
    "KG" to "Kirguistán",
    "KH" to "Camboya",
    "KI" to "Kiribati",
    "KM" to "Comoras",
    "KN" to "San Cristóbal y Nieves",
    "KP" to "Corea del Norte",
    "KR" to "Corea del Sur",
    "KW" to "Kuwait",
    "KY" to "Islas Caimán",
    "KZ" to "Kazajistán",
    "LA" to "Laos",
    "LB" to "Líbano",
    "LC" to "Santa Lucía",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesoto",
    "LT" to "Lituania",
    "LU" to "Luxemburgo",
    "LV" to "Letonia",
    "LY" to "Libia",
    "MA" to "Marruecos",
    "MC" to "Mónaco",
    "MD" to "Moldavia",
    "ME" to "Montenegro",
    "MF" to "San Martín",
    "MG" to "Madagascar",
    "MH" to "Islas Marshall",
    "MK" to "Macedonia del Norte",
    "ML" to "Mali",
    "MM" to "Myanmar (Birmania)",
    "MN" to "Mongolia",
    "MO" to "RAE de Macao (China)",
    "MP" to "Islas Marianas del Norte",
    "MQ" to "Martinica",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauricio",
    "MV" to "Maldivas",
    "MW" to "Malaui",
    "MX" to "México",
    "MY" to "Malasia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "Nueva Caledonia",
    "NE" to "Níger",
    "NF" to "Isla Norfolk",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Países Bajos",
    "NO" to "Noruega",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nueva Zelanda",
    "OM" to "Omán",
    "PA" to "Panamá",
    "PE" to "Perú",
    "PF" to "Polinesia Francesa",
    "PG" to "Papúa Nueva Guinea",
    "PH" to "Filipinas",
    "PK" to "Pakistán",
    "PL" to "Polonia",
    "PM" to "San Pedro y Miquelón",
    "PN" to "Islas Pitcairn",
    "PR" to "Puerto Rico",
    "PS" to "Territorios Palestinos",
    "PT" to "Portugal",
    "PW" to "Palaos",
    "PY" to "Paraguay",
    "QA" to "Catar",
    "QO" to "Territorios alejados de Oceanía",
    "RE" to "Reunión",
    "RO" to "Rumanía",
    "RS" to "Serbia",
    "RU" to "Rusia",
    "RW" to "Ruanda",
    "SA" to "Arabia Saudí",
    "SB" to "Islas Salomón",
    "SC" to "Seychelles",
    "SD" to "Sudán",
    "SE" to "Suecia",
    "SG" to "Singapur",
    "SH" to "Santa Elena",
    "SI" to "Eslovenia",
    "SJ" to "Svalbard y Jan Mayen",
    "SK" to "Eslovaquia",
    "SL" to "Sierra Leona",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Surinam",
    "SS" to "Sudán del Sur",
    "ST" to "Santo Tomé y Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Siria",
    "SZ" to "Esuatini",
    "TA" to "Tristán de Acuña",
    "TC" to "Islas Turcas y Caicos",
    "TD" to "Chad",
    "TF" to "Territorios Australes Franceses",
    "TG" to "Togo",
    "TH" to "Tailandia",
    "TJ" to "Tayikistán",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistán",
    "TN" to "Túnez",
    "TO" to "Tonga",
    "TR" to "Turquía",
    "TT" to "Trinidad y Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwán",
    "TZ" to "Tanzania",
    "UA" to "Ucrania",
    "UG" to "Uganda",
    "UM" to "Islas menores alejadas de EE. UU.",
    "UN" to "Naciones Unidas",
    "US" to "Estados Unidos",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistán",
    "VA" to "Ciudad del Vaticano",
    "VC" to "San Vicente y las Granadinas",
    "VE" to "Venezuela",
    "VG" to "Islas Vírgenes Británicas",
    "VI" to "Islas Vírgenes de EE. UU.",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis y Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudoacentos",
    "XB" to "Pseudobidi",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "Sudáfrica",
    "ZM" to "Zambia",
    "ZW" to "Zimbabue",
    "ZZ" to "Región desconocida",
  ) }

  val es_419: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "BA" to "Bosnia-Herzegovina",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
    "TL" to "Timor Oriental",
    "UM" to "Islas Ultramarinas de EE.UU.",
  ) }

  val es_AR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_BO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_BR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "BA" to "Bosnia-Herzegovina",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
    "TL" to "Timor Oriental",
    "UM" to "Islas Ultramarinas de EE.UU.",
  ) }

  val es_BZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "BA" to "Bosnia-Herzegovina",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
    "TL" to "Timor Oriental",
    "UM" to "Islas Ultramarinas de EE.UU.",
  ) }

  val es_CL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EH" to "Sahara Occidental",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_CO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_CR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_CU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "BA" to "Bosnia-Herzegovina",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
    "TL" to "Timor Oriental",
    "UM" to "Islas Ultramarinas de EE.UU.",
  ) }

  val es_DO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_EA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_EC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_GQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_GT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_HN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_IC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_MX: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África Occidental",
    "014" to "África Oriental",
    "030" to "Asia Oriental",
    "035" to "Sudeste Asiático",
    "145" to "Asia Occidental",
    "151" to "Europa Oriental",
    "155" to "Europa Occidental",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "EZ" to "Eurozona",
    "GG" to "Guernsey",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
    "SZ" to "Eswatini",
    "TL" to "Timor Oriental",
  ) }

  val es_NI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_PA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_PE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_PH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_PR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "BA" to "Bosnia-Herzegovina",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
    "TL" to "Timor Oriental",
  ) }

  val es_PY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val es_SV: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "BA" to "Bosnia-Herzegovina",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
    "TL" to "Timor Oriental",
  ) }

  val es_US: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EH" to "Sahara Occidental",
    "EZ" to "Eurozona",
    "GG" to "Guernsey",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
    "TL" to "Timor Oriental",
  ) }

  val es_UY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "BA" to "Bosnia-Herzegovina",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
    "TL" to "Timor Oriental",
    "UM" to "Islas Ultramarinas de EE.UU.",
  ) }

  val es_VE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "011" to "África del Oeste",
    "014" to "África del Este",
    "015" to "África del Norte",
    "018" to "África del Sur",
    "030" to "Asia del Este",
    "034" to "Asia del Sur",
    "035" to "Asia sudoriental",
    "039" to "Europa del Sur",
    "145" to "Asia del Oeste",
    "151" to "Europa del Este",
    "154" to "Europa del Norte",
    "155" to "Europa del Oeste",
    "AC" to "Isla Ascensión",
    "AX" to "Islas Åland",
    "CG" to "República del Congo",
    "CI" to "Costa de Marfil",
    "EZ" to "Eurozona",
    "GS" to "Islas Georgia del Sur y Sándwich del Sur",
    "IC" to "Islas Canarias",
    "QO" to "Islas Ultramarinas",
    "RO" to "Rumania",
    "SA" to "Arabia Saudita",
  ) }

  val et: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "maailm",
    "002" to "Aafrika",
    "003" to "Põhja-Ameerika",
    "005" to "Lõuna-Ameerika",
    "009" to "Okeaania",
    "011" to "Lääne-Aafrika",
    "013" to "Kesk-Ameerika",
    "014" to "Ida-Aafrika",
    "015" to "Põhja-Aafrika",
    "017" to "Kesk-Aafrika",
    "018" to "Lõuna-Aafrika",
    "019" to "Ameerika",
    "021" to "Ameerika põhjaosa",
    "029" to "Kariibi piirkond",
    "030" to "Ida-Aasia",
    "034" to "Lõuna-Aasia",
    "035" to "Kagu-Aasia",
    "039" to "Lõuna-Euroopa",
    "053" to "Australaasia",
    "054" to "Melaneesia",
    "057" to "Mikroneesia (piirkond)",
    "061" to "Polüneesia",
    "142" to "Aasia",
    "143" to "Kesk-Aasia",
    "145" to "Lääne-Aasia",
    "150" to "Euroopa",
    "151" to "Ida-Euroopa",
    "154" to "Põhja-Euroopa",
    "155" to "Lääne-Euroopa",
    "202" to "Sahara-tagune Aafrika",
    "419" to "Ladina-Ameerika",
    "AC" to "Ascensioni saar",
    "AD" to "Andorra",
    "AE" to "Araabia Ühendemiraadid",
    "AF" to "Afganistan",
    "AG" to "Antigua ja Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albaania",
    "AM" to "Armeenia",
    "AO" to "Angola",
    "AQ" to "Antarktika",
    "AR" to "Argentina",
    "AS" to "Ameerika Samoa",
    "AT" to "Austria",
    "AU" to "Austraalia",
    "AW" to "Aruba",
    "AX" to "Ahvenamaa",
    "AZ" to "Aserbaidžaan",
    "BA" to "Bosnia ja Hertsegoviina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgia",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaaria",
    "BH" to "Bahrein",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint-Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Boliivia",
    "BQ" to "Kariibi Madalmaad",
    "BR" to "Brasiilia",
    "BS" to "Bahama",
    "BT" to "Bhutan",
    "BV" to "Bouvet’ saar",
    "BW" to "Botswana",
    "BY" to "Valgevene",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kookossaared",
    "CD" to "Kongo DV",
    "CF" to "Kesk-Aafrika Vabariik",
    "CG" to "Kongo Vabariik",
    "CH" to "Šveits",
    "CI" to "Elevandiluurannik",
    "CK" to "Cooki saared",
    "CL" to "Tšiili",
    "CM" to "Kamerun",
    "CN" to "Hiina",
    "CO" to "Colombia",
    "CP" to "Clippertoni saar",
    "CQ" to "Sark",
    "CR" to "Costa Rica",
    "CU" to "Kuuba",
    "CV" to "Roheneemesaared",
    "CW" to "Curaçao",
    "CX" to "Jõulusaar",
    "CY" to "Küpros",
    "CZ" to "Tšehhi",
    "DE" to "Saksamaa",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Taani",
    "DM" to "Dominica",
    "DO" to "Dominikaani Vabariik",
    "DZ" to "Alžeeria",
    "EA" to "Ceuta ja Melilla",
    "EC" to "Ecuador",
    "EE" to "Eesti",
    "EG" to "Egiptus",
    "EH" to "Lääne-Sahara",
    "ER" to "Eritrea",
    "ES" to "Hispaania",
    "ET" to "Etioopia",
    "EU" to "Euroopa Liit",
    "EZ" to "euroala",
    "FI" to "Soome",
    "FJ" to "Fidži",
    "FK" to "Falklandi saared",
    "FM" to "Mikroneesia",
    "FO" to "Fääri saared",
    "FR" to "Prantsusmaa",
    "GA" to "Gabon",
    "GB" to "Ühendkuningriik",
    "GD" to "Grenada",
    "GE" to "Gruusia",
    "GF" to "Prantsuse Guajaana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Gröönimaa",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Ekvatoriaal-Guinea",
    "GR" to "Kreeka",
    "GS" to "Lõuna-Georgia ja Lõuna-Sandwichi saared",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hongkongi erihalduspiirkond",
    "HM" to "Heardi ja McDonaldi saared",
    "HN" to "Honduras",
    "HR" to "Horvaatia",
    "HT" to "Haiti",
    "HU" to "Ungari",
    "IC" to "Kanaari saared",
    "ID" to "Indoneesia",
    "IE" to "Iirimaa",
    "IL" to "Iisrael",
    "IM" to "Mani saar",
    "IN" to "India",
    "IO" to "Briti India ookeani ala",
    "IQ" to "Iraak",
    "IR" to "Iraan",
    "IS" to "Island",
    "IT" to "Itaalia",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordaania",
    "JP" to "Jaapan",
    "KE" to "Keenia",
    "KG" to "Kõrgõzstan",
    "KH" to "Kambodža",
    "KI" to "Kiribati",
    "KM" to "Komoorid",
    "KN" to "Saint Kitts ja Nevis",
    "KP" to "Põhja-Korea",
    "KR" to "Lõuna-Korea",
    "KW" to "Kuveit",
    "KY" to "Kaimanisaared",
    "KZ" to "Kasahstan",
    "LA" to "Laos",
    "LB" to "Liibanon",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Libeeria",
    "LS" to "Lesotho",
    "LT" to "Leedu",
    "LU" to "Luksemburg",
    "LV" to "Läti",
    "LY" to "Liibüa",
    "MA" to "Maroko",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "Saint-Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshalli Saared",
    "MK" to "Põhja-Makedoonia",
    "ML" to "Mali",
    "MM" to "Myanmar (Birma)",
    "MN" to "Mongoolia",
    "MO" to "Macau erihalduspiirkond",
    "MP" to "Põhja-Mariaanid",
    "MQ" to "Martinique",
    "MR" to "Mauritaania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldiivid",
    "MW" to "Malawi",
    "MX" to "Mehhiko",
    "MY" to "Malaisia",
    "MZ" to "Mosambiik",
    "NA" to "Namiibia",
    "NC" to "Uus-Kaledoonia",
    "NE" to "Niger",
    "NF" to "Norfolk",
    "NG" to "Nigeeria",
    "NI" to "Nicaragua",
    "NL" to "Holland",
    "NO" to "Norra",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Uus-Meremaa",
    "OM" to "Omaan",
    "PA" to "Panama",
    "PE" to "Peruu",
    "PF" to "Prantsuse Polüneesia",
    "PG" to "Paapua Uus-Guinea",
    "PH" to "Filipiinid",
    "PK" to "Pakistan",
    "PL" to "Poola",
    "PM" to "Saint-Pierre ja Miquelon",
    "PN" to "Pitcairni saared",
    "PR" to "Puerto Rico",
    "PS" to "Palestiina alad",
    "PT" to "Portugal",
    "PW" to "Belau",
    "PY" to "Paraguay",
    "QA" to "Katar",
    "QO" to "Okeaania hajasaared",
    "RE" to "Réunion",
    "RO" to "Rumeenia",
    "RS" to "Serbia",
    "RU" to "Venemaa",
    "RW" to "Rwanda",
    "SA" to "Saudi Araabia",
    "SB" to "Saalomoni Saared",
    "SC" to "Seišellid",
    "SD" to "Sudaan",
    "SE" to "Rootsi",
    "SG" to "Singapur",
    "SH" to "Saint Helena",
    "SI" to "Sloveenia",
    "SJ" to "Svalbard ja Jan Mayen",
    "SK" to "Slovakkia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somaalia",
    "SR" to "Suriname",
    "SS" to "Lõuna-Sudaan",
    "ST" to "São Tomé ja Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Süüria",
    "SZ" to "Svaasimaa",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks ja Caicos",
    "TD" to "Tšaad",
    "TF" to "Prantsuse Lõunaalad",
    "TG" to "Togo",
    "TH" to "Tai",
    "TJ" to "Tadžikistan",
    "TK" to "Tokelau",
    "TL" to "Ida-Timor",
    "TM" to "Türkmenistan",
    "TN" to "Tuneesia",
    "TO" to "Tonga",
    "TR" to "Türgi",
    "TT" to "Trinidad ja Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tansaania",
    "UA" to "Ukraina",
    "UG" to "Uganda",
    "UM" to "Ühendriikide hajasaared",
    "UN" to "Ühinenud Rahvaste Organisatsioon",
    "US" to "Ameerika Ühendriigid",
    "UY" to "Uruguay",
    "UZ" to "Usbekistan",
    "VA" to "Vatikan",
    "VC" to "Saint Vincent ja Grenadiinid",
    "VE" to "Venezuela",
    "VG" to "Briti Neitsisaared",
    "VI" to "USA Neitsisaared",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis ja Futuna",
    "WS" to "Samoa",
    "XA" to "pseudo-aktsent",
    "XB" to "pseudo-Bidi",
    "XK" to "Kosovo",
    "YE" to "Jeemen",
    "YT" to "Mayotte",
    "ZA" to "Lõuna-Aafrika Vabariik",
    "ZM" to "Sambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "tundmatu piirkond",
  ) }

  val eu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Mundua",
    "002" to "Afrika",
    "003" to "Ipar Amerika",
    "005" to "Hego Amerika",
    "009" to "Ozeania",
    "011" to "Mendebaldeko Afrika",
    "013" to "Erdialdeko Amerika",
    "014" to "Ekialdeko Afrika",
    "015" to "Ipar Afrika",
    "017" to "Erdialdeko Afrika",
    "018" to "Hegoaldeko Afrika",
    "019" to "Amerika",
    "021" to "Amerikako iparraldea",
    "029" to "Karibea",
    "030" to "Ekialdeko Asia",
    "034" to "Hego Asia",
    "035" to "Hego-ekialdeko Asia",
    "039" to "Hego Europa",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Mikronesia eskualdea",
    "061" to "Polinesia",
    "142" to "Asia",
    "143" to "Erdialdeko Asia",
    "145" to "Mendebaldeko Asia",
    "150" to "Europa",
    "151" to "Ekialdeko Europa",
    "154" to "Ipar Europa",
    "155" to "Mendebaldeko Europa",
    "202" to "Saharaz hegoaldeko Afrika",
    "419" to "Latinoamerika",
    "AC" to "Ascension uhartea",
    "AD" to "Andorra",
    "AE" to "Arabiar Emirerri Batuak",
    "AF" to "Afganistan",
    "AG" to "Antigua eta Barbuda",
    "AI" to "Aingira",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antartika",
    "AR" to "Argentina",
    "AS" to "Samoa Estatubatuarra",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Åland",
    "AZ" to "Azerbaijan",
    "BA" to "Bosnia-Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgika",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Karibeko Herbehereak",
    "BR" to "Brasil",
    "BS" to "Bahamak",
    "BT" to "Bhutan",
    "BV" to "Bouvet uhartea",
    "BW" to "Botswana",
    "BY" to "Bielorrusia",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Cocos (Keeling) uharteak",
    "CD" to "Kongoko Errepublika Demokratikoa",
    "CF" to "Afrika Erdiko Errepublika",
    "CG" to "Kongo",
    "CH" to "Suitza",
    "CI" to "Boli Kosta",
    "CK" to "Cook uharteak",
    "CL" to "Txile",
    "CM" to "Kamerun",
    "CN" to "Txina",
    "CO" to "Kolonbia",
    "CP" to "Clipperton uhartea",
    "CR" to "Costa Rica",
    "CU" to "Kuba",
    "CV" to "Cabo Verde",
    "CW" to "Curaçao",
    "CX" to "Christmas uhartea",
    "CY" to "Zipre",
    "CZ" to "Txekia",
    "DE" to "Alemania",
    "DG" to "Diego García",
    "DJ" to "Djibuti",
    "DK" to "Danimarka",
    "DM" to "Dominika",
    "DO" to "Dominikar Errepublika",
    "DZ" to "Aljeria",
    "EA" to "Ceuta eta Melilla",
    "EC" to "Ekuador",
    "EE" to "Estonia",
    "EG" to "Egipto",
    "EH" to "Mendebaldeko Sahara",
    "ER" to "Eritrea",
    "ES" to "Espainia",
    "ET" to "Etiopia",
    "EU" to "Europar Batasuna",
    "EZ" to "Eurogunea",
    "FI" to "Finlandia",
    "FJ" to "Fiji",
    "FK" to "Falklandak",
    "FM" to "Mikronesia",
    "FO" to "Faroe uharteak",
    "FR" to "Frantzia",
    "GA" to "Gabon",
    "GB" to "Erresuma Batua",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "Guyana Frantsesa",
    "GG" to "Guernesey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Groenlandia",
    "GM" to "Gambia",
    "GN" to "Ginea",
    "GP" to "Guadalupe",
    "GQ" to "Ekuatore Ginea",
    "GR" to "Grezia",
    "GS" to "Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Ginea Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong Txinako AEB",
    "HM" to "Heard eta McDonald uharteak",
    "HN" to "Honduras",
    "HR" to "Kroazia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "IC" to "Kanariak",
    "ID" to "Indonesia",
    "IE" to "Irlanda",
    "IL" to "Israel",
    "IM" to "Man uhartea",
    "IN" to "India",
    "IO" to "Indiako Ozeanoko lurralde britainiarra",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Islandia",
    "IT" to "Italia",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Jordania",
    "JP" to "Japonia",
    "KE" to "Kenya",
    "KG" to "Kirgizistan",
    "KH" to "Kanbodia",
    "KI" to "Kiribati",
    "KM" to "Komoreak",
    "KN" to "Saint Kitts eta Nevis",
    "KP" to "Ipar Korea",
    "KR" to "Hego Korea",
    "KW" to "Kuwait",
    "KY" to "Kaiman uharteak",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Libano",
    "LC" to "Santa Luzia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lituania",
    "LU" to "Luxenburgo",
    "LV" to "Letonia",
    "LY" to "Libia",
    "MA" to "Maroko",
    "MC" to "Monako",
    "MD" to "Moldavia",
    "ME" to "Montenegro",
    "MF" to "San Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshall Uharteak",
    "MK" to "Ipar Mazedonia",
    "ML" to "Mali",
    "MM" to "Myanmar (Birmania)",
    "MN" to "Mongolia",
    "MO" to "Macau Txinako AEB",
    "MP" to "Ipar Mariana uharteak",
    "MQ" to "Martinika",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Maurizio",
    "MV" to "Maldivak",
    "MW" to "Malawi",
    "MX" to "Mexiko",
    "MY" to "Malaysia",
    "MZ" to "Mozambike",
    "NA" to "Namibia",
    "NC" to "Kaledonia Berria",
    "NE" to "Niger",
    "NF" to "Norfolk uhartea",
    "NG" to "Nigeria",
    "NI" to "Nikaragua",
    "NL" to "Herbehereak",
    "NO" to "Norvegia",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Zeelanda Berria",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia Frantsesa",
    "PG" to "Papua Ginea Berria",
    "PH" to "Filipinak",
    "PK" to "Pakistan",
    "PL" to "Polonia",
    "PM" to "Saint-Pierre eta Mikelune",
    "PN" to "Pitcairn uharteak",
    "PR" to "Puerto Rico",
    "PS" to "Palestinar Lurralde Okupatuak",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguai",
    "QA" to "Qatar",
    "QO" to "Mugaz kanpoko Ozeania",
    "RE" to "Reunion",
    "RO" to "Errumania",
    "RS" to "Serbia",
    "RU" to "Errusia",
    "RW" to "Ruanda",
    "SA" to "Saudi Arabia",
    "SB" to "Salomon Uharteak",
    "SC" to "Seychelleak",
    "SD" to "Sudan",
    "SE" to "Suedia",
    "SG" to "Singapur",
    "SH" to "Santa Helena",
    "SI" to "Eslovenia",
    "SJ" to "Svalbard eta Jan Mayen uharteak",
    "SK" to "Eslovakia",
    "SL" to "Sierra Leona",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Surinam",
    "SS" to "Hego Sudan",
    "ST" to "Sao Tome eta Principe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Siria",
    "SZ" to "Swazilandia",
    "TA" to "Tristan da Cunha",
    "TC" to "Turk eta Caico uharteak",
    "TD" to "Txad",
    "TF" to "Hegoaldeko lurralde frantsesak",
    "TG" to "Togo",
    "TH" to "Thailandia",
    "TJ" to "Tajikistan",
    "TK" to "Tokelau",
    "TL" to "Ekialdeko Timor",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turkia",
    "TT" to "Trinidad eta Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraina",
    "UG" to "Uganda",
    "UM" to "Ameriketako Estatu Batuetako Kanpoaldeko Uharte Txikiak",
    "UN" to "Nazio Batuak",
    "US" to "Ameriketako Estatu Batuak",
    "UY" to "Uruguai",
    "UZ" to "Uzbekistan",
    "VA" to "Vatikano Hiria",
    "VC" to "Saint Vincent eta Grenadinak",
    "VE" to "Venezuela",
    "VG" to "Birjina uharte britainiarrak",
    "VI" to "Birjina uharte amerikarrak",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis eta Futuna",
    "WS" to "Samoa",
    "XA" to "Sasiazentuak",
    "XB" to "Pseudobidia",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "Hegoafrika",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Eskualde ezezaguna",
  ) }

  val ewo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andór",
    "AE" to "Bemirá yá Arábə uní",
    "AF" to "Afəganisətán",
    "AG" to "Antígwa ai Barəbúda",
    "AI" to "Angíyə",
    "AL" to "Aləbánia",
    "AM" to "Arəménia",
    "AO" to "Angolá",
    "AR" to "Arəhenətína",
    "AS" to "Bəsamóa yá Amə́rəka",
    "AT" to "Osətəlía",
    "AU" to "Osətəlalí",
    "AW" to "Arúba",
    "AZ" to "Azɛrəbaidzáŋ",
    "BA" to "Bosəní ai ɛrəzegovín",
    "BB" to "Barəbád",
    "BD" to "Bangaladɛ́s",
    "BE" to "Bɛləhíg",
    "BF" to "Buləkiná Fasó",
    "BG" to "Buləgarí",
    "BH" to "Bahərɛ́n",
    "BI" to "Burundí",
    "BJ" to "Bəníŋ",
    "BM" to "Bɛrəmúd",
    "BN" to "Buluné",
    "BO" to "Bolívia",
    "BR" to "Bəlazíl",
    "BS" to "Bahámas",
    "BT" to "Butáŋ",
    "BW" to "Botswaná",
    "BY" to "Bəlarús",
    "BZ" to "Bəlís",
    "CA" to "kanadá",
    "CD" to "ǹnam Kongó Demokəlatíg",
    "CF" to "ǹnam Zǎŋ Afiriká",
    "CG" to "Kongó",
    "CH" to "Suís",
    "CI" to "Kód Divɔ́r",
    "CK" to "Minlán Mí kúg",
    "CL" to "Tsilí",
    "CM" to "Kamərún",
    "CN" to "Tsáina",
    "CO" to "Kolɔmbí",
    "CR" to "Kosta Ríka",
    "CU" to "Kubá",
    "CV" to "Minlán Mí Káb Vɛr",
    "CY" to "Sipəlús",
    "CZ" to "Ǹnam Tsɛ́g",
    "DE" to "Ndzáman",
    "DJ" to "Dzibutí",
    "DK" to "Danəmárəg",
    "DM" to "Dómənika",
    "DO" to "République dominicaine",
    "DZ" to "Aləyéria",
    "EC" to "Ekwatór",
    "EE" to "Esetoní",
    "EG" to "Ehíbətɛn",
    "ER" to "Elitəlé",
    "ES" to "Kpənyá",
    "ET" to "Etiopí",
    "FI" to "Finəlán",
    "FJ" to "Fidzí",
    "FK" to "Minlán Mi Fóləkəlan",
    "FM" to "Mikoronésia",
    "FR" to "Fulɛnsí",
    "GA" to "Gabóŋ",
    "GB" to "Ǹnam Engəlis",
    "GD" to "Gələnádə",
    "GE" to "Horə́yia",
    "GF" to "Guyán yá Fulɛnsí",
    "GH" to "Ganá",
    "GI" to "Yiləbalatár",
    "GL" to "Goelán",
    "GM" to "Gambí",
    "GN" to "Giné",
    "GP" to "Guadəlúb",
    "GQ" to "Giné Ekwató",
    "GR" to "Gəlɛ́s",
    "GT" to "Guatemalá",
    "GU" to "Guám",
    "GW" to "Giné Bisaó",
    "GY" to "Guyán",
    "HN" to "Ondurás",
    "HR" to "Kəlowásia",
    "HT" to "Aití",
    "HU" to "Ongirí",
    "ID" to "ɛndonésia",
    "IE" to "Irəlándə",
    "IL" to "Isəraɛ́l",
    "IN" to "ɛ́ndə",
    "IQ" to "Irág",
    "IR" to "Irán",
    "IS" to "Isəlándə",
    "IT" to "Itáliɛn",
    "JM" to "Hamaíka",
    "JO" to "Horədaní",
    "JP" to "Hapɔ́n",
    "KE" to "Keniá",
    "KG" to "Kirigisətán",
    "KH" to "kambodía",
    "KI" to "Kiribatí",
    "KM" to "Komɔ́r",
    "KN" to "Ǹfúfúb-Kilisətóv-ai-Nevis",
    "KP" to "Koré yá Nór",
    "KR" to "Koré yá Súd",
    "KW" to "Kowɛ́d",
    "KY" to "Minlán Mí Kalimáŋ",
    "KZ" to "Kazakətáŋ",
    "LA" to "Laós",
    "LB" to "Libáŋ",
    "LC" to "Ǹfúfúb-Lúsia",
    "LI" to "Lísə́sə́táin",
    "LK" to "Səri Laŋká",
    "LR" to "Libéria",
    "LS" to "Ləsotó",
    "LT" to "Lituaní",
    "LU" to "Lukəzambúd",
    "LV" to "Lətoní",
    "LY" to "Libí",
    "MA" to "Marɔ́g",
    "MC" to "Mɔnakó",
    "MD" to "Molədaví",
    "MG" to "Madagasəkárə",
    "MH" to "Minlán Mí Maresál",
    "ML" to "Malí",
    "MM" to "Mianəmár",
    "MN" to "Mɔngɔ́lia",
    "MP" to "Minlán Mi Marián yá Nór",
    "MQ" to "Marətiníg",
    "MR" to "Moritaní",
    "MS" to "Mɔ́ntserád",
    "MT" to "Málətə",
    "MU" to "Morís",
    "MV" to "Malədívə",
    "MW" to "Malawí",
    "MX" to "Mɛkəsíg",
    "MY" to "Malɛ́zia",
    "MZ" to "Mozambíg",
    "NA" to "Namibí",
    "NC" to "Ǹkpámɛn Kaledónia",
    "NE" to "Nihɛ́r",
    "NF" to "Minlán Nɔrəfɔ́ləkə",
    "NG" to "Nihéria",
    "NI" to "Nikarágua",
    "NL" to "Pɛíbá",
    "NO" to "Nɔrəvɛ́s",
    "NP" to "Nepál",
    "NR" to "Naurú",
    "NU" to "Niué",
    "NZ" to "Ǹkpámɛn Zeláŋ",
    "OM" to "Omán",
    "PA" to "Panamá",
    "PE" to "Perú",
    "PF" to "Polinesí yá Fulɛnsí",
    "PG" to "Papwazi yá Ǹkpámɛ́n Giné",
    "PH" to "Filipín",
    "PK" to "Pakisətán",
    "PL" to "fólis",
    "PM" to "Ǹfúfúb-Píɛr-ai-Mikəlɔ́ŋ",
    "PN" to "Pítə́kɛ́rɛnə",
    "PR" to "Pwɛrəto Ríko",
    "PS" to "Ǹnam Palɛsətín",
    "PT" to "fɔrətugɛ́s",
    "PW" to "Palau",
    "PY" to "Paragué",
    "QA" to "Katár",
    "RE" to "Reuniɔ́ŋ",
    "RO" to "Rumaní",
    "RU" to "Rúsian",
    "RW" to "Ruwandá",
    "SA" to "Arabí Saudí",
    "SB" to "Minlán Mí Solomɔ́n",
    "SC" to "Sɛsɛ́l",
    "SD" to "Sudáŋ",
    "SE" to "Suwɛ́d",
    "SG" to "Singapúr",
    "SH" to "Ǹfúfúb-Ɛlɛ́na",
    "SI" to "Səlovénia",
    "SK" to "Səlovakí",
    "SL" to "Sierá-leónə",
    "SM" to "Ǹfúfúb Maríno",
    "SN" to "Senegál",
    "SO" to "Somália",
    "SR" to "Surinám",
    "ST" to "Saó Tomé ai Pəlinəsípe",
    "SV" to "Saləvadór",
    "SY" to "Sirí",
    "SZ" to "Swazilándə",
    "TC" to "Minlán Mí túrə́g-ai-Kaíg",
    "TD" to "Tsád",
    "TG" to "Togó",
    "TH" to "Tailán",
    "TJ" to "Tadzikisətáŋ",
    "TK" to "Tokeló",
    "TL" to "Timôr",
    "TM" to "Turəkəmənisətáŋ",
    "TN" to "Tunisí",
    "TO" to "Tɔngá",
    "TR" to "Turəkí",
    "TT" to "Təlinité-ai-Tobágo",
    "TV" to "Tuvalú",
    "TW" to "Taiwán",
    "TZ" to "Taŋəzaní",
    "UA" to "Ukərɛ́n",
    "UG" to "Ugandá",
    "US" to "Ǹnam Amɛrəkə",
    "UY" to "Urugué",
    "UZ" to "Uzubekisətán",
    "VA" to "Ǹnam Vatikán",
    "VC" to "Ǹfúfúb-Vɛngəsáŋ-ai-Bə Gələnadín",
    "VE" to "Venezuéla",
    "VG" to "ńnam Minlán ɛ́ngəlís",
    "VI" to "Minlán Mi Amɛrəkə",
    "VN" to "Viɛdənám",
    "VU" to "Vanuátu",
    "WF" to "Walís-ai-Futúna",
    "WS" to "Samoá",
    "YE" to "Yemɛ́n",
    "YT" to "Mayɔ́d",
    "ZA" to "Afiríka yá Súd",
    "ZM" to "Zambí",
    "ZW" to "Zimbabwé",
  ) }

  val fa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "جهان",
    "002" to "افریقا",
    "003" to "امریکای شمالی",
    "005" to "امریکای جنوبی",
    "009" to "اقیانوسیه",
    "011" to "غرب افریقا",
    "013" to "امریکای مرکزی",
    "014" to "شرق افریقا",
    "015" to "شمال افریقا",
    "017" to "مرکز افریقا",
    "018" to "جنوب افریقا",
    "019" to "امریکا",
    "021" to "شمال امریکا",
    "029" to "کارائیب",
    "030" to "شرق آسیا",
    "034" to "جنوب آسیا",
    "035" to "جنوب شرق آسیا",
    "039" to "جنوب اروپا",
    "053" to "استرالزی",
    "054" to "ملانزی",
    "057" to "ناحیهٔ میکرونزی",
    "061" to "پلی‌نزی",
    "142" to "آسیا",
    "143" to "آسیای مرکزی",
    "145" to "غرب آسیا",
    "150" to "اروپا",
    "151" to "شرق اروپا",
    "154" to "شمال اروپا",
    "155" to "غرب اروپا",
    "202" to "افریقای جنوب صحرا",
    "419" to "امریکای لاتین",
    "AC" to "جزایر آسنسیون",
    "AD" to "آندورا",
    "AE" to "امارات متحدهٔ عربی",
    "AF" to "افغانستان",
    "AG" to "آنتیگوا و باربودا",
    "AI" to "آنگویلا",
    "AL" to "آلبانی",
    "AM" to "ارمنستان",
    "AO" to "آنگولا",
    "AQ" to "جنوبگان",
    "AR" to "آرژانتین",
    "AS" to "ساموآی امریکا",
    "AT" to "اتریش",
    "AU" to "استرالیا",
    "AW" to "آروبا",
    "AX" to "جزایر آلاند",
    "AZ" to "جمهوری آذربایجان",
    "BA" to "بوسنی و هرزگوین",
    "BB" to "باربادوس",
    "BD" to "بنگلادش",
    "BE" to "بلژیک",
    "BF" to "بورکینافاسو",
    "BG" to "بلغارستان",
    "BH" to "بحرین",
    "BI" to "بوروندی",
    "BJ" to "بنین",
    "BL" to "سن بارتلمی",
    "BM" to "برمودا",
    "BN" to "برونئی",
    "BO" to "بولیوی",
    "BQ" to "جزایر کارائیب هلند",
    "BR" to "برزیل",
    "BS" to "باهاما",
    "BT" to "بوتان",
    "BV" to "جزیرهٔ بووه",
    "BW" to "بوتسوانا",
    "BY" to "بلاروس",
    "BZ" to "بلیز",
    "CA" to "کانادا",
    "CC" to "جزایر کوکوس",
    "CD" to "کنگو - کینشاسا",
    "CF" to "جمهوری افریقای مرکزی",
    "CG" to "کنگو - برازویل",
    "CH" to "سوئیس",
    "CI" to "ساحل عاج",
    "CK" to "جزایر کوک",
    "CL" to "شیلی",
    "CM" to "کامرون",
    "CN" to "چین",
    "CO" to "کلمبیا",
    "CP" to "جزایر کلیپرتون",
    "CR" to "کاستاریکا",
    "CU" to "کوبا",
    "CV" to "کیپ‌ورد",
    "CW" to "کوراسائو",
    "CX" to "جزیرهٔ کریسمس",
    "CY" to "قبرس",
    "CZ" to "چک",
    "DE" to "آلمان",
    "DG" to "دیه‌گو گارسیا",
    "DJ" to "جیبوتی",
    "DK" to "دانمارک",
    "DM" to "دومینیکا",
    "DO" to "جمهوری دومینیکن",
    "DZ" to "الجزایر",
    "EA" to "سبته و ملیله",
    "EC" to "اکوادور",
    "EE" to "استونی",
    "EG" to "مصر",
    "EH" to "صحرای غربی",
    "ER" to "اریتره",
    "ES" to "اسپانیا",
    "ET" to "اتیوپی",
    "EU" to "اتحادیهٔ اروپا",
    "EZ" to "منطقهٔ یورو",
    "FI" to "فنلاند",
    "FJ" to "فیجی",
    "FK" to "جزایر فالکلند",
    "FM" to "میکرونزی",
    "FO" to "جزایر فارو",
    "FR" to "فرانسه",
    "GA" to "گابن",
    "GB" to "بریتانیا",
    "GD" to "گرنادا",
    "GE" to "گرجستان",
    "GF" to "گویان فرانسه",
    "GG" to "گرنزی",
    "GH" to "غنا",
    "GI" to "جبل‌الطارق",
    "GL" to "گرینلند",
    "GM" to "گامبیا",
    "GN" to "گینه",
    "GP" to "گوادلوپ",
    "GQ" to "گینهٔ استوایی",
    "GR" to "یونان",
    "GS" to "جورجیای جنوبی و جزایر ساندویچ جنوبی",
    "GT" to "گواتمالا",
    "GU" to "گوام",
    "GW" to "گینهٔ بیسائو",
    "GY" to "گویان",
    "HK" to "هنگ‌کنگ، منطقهٔ ویژهٔ اداری چین",
    "HM" to "هرد و جزایر مک‌دونالد",
    "HN" to "هندوراس",
    "HR" to "کرواسی",
    "HT" to "هائیتی",
    "HU" to "مجارستان",
    "IC" to "جزایر قناری",
    "ID" to "اندونزی",
    "IE" to "ایرلند",
    "IL" to "اسرائیل",
    "IM" to "جزیرهٔ من",
    "IN" to "هند",
    "IO" to "قلمرو بریتانیا در اقیانوس هند",
    "IQ" to "عراق",
    "IR" to "ایران",
    "IS" to "ایسلند",
    "IT" to "ایتالیا",
    "JE" to "جرزی",
    "JM" to "جامائیکا",
    "JO" to "اردن",
    "JP" to "ژاپن",
    "KE" to "کنیا",
    "KG" to "قرقیزستان",
    "KH" to "کامبوج",
    "KI" to "کیریباتی",
    "KM" to "کومور",
    "KN" to "سنت کیتس و نویس",
    "KP" to "کرهٔ شمالی",
    "KR" to "کرهٔ جنوبی",
    "KW" to "کویت",
    "KY" to "جزایر کِیمن",
    "KZ" to "قزاقستان",
    "LA" to "لائوس",
    "LB" to "لبنان",
    "LC" to "سنت لوسیا",
    "LI" to "لیختن‌اشتاین",
    "LK" to "سری‌لانکا",
    "LR" to "لیبریا",
    "LS" to "لسوتو",
    "LT" to "لیتوانی",
    "LU" to "لوکزامبورگ",
    "LV" to "لتونی",
    "LY" to "لیبی",
    "MA" to "مراکش",
    "MC" to "موناکو",
    "MD" to "مولداوی",
    "ME" to "مونته‌نگرو",
    "MF" to "سنت مارتین",
    "MG" to "ماداگاسکار",
    "MH" to "جزایر مارشال",
    "MK" to "مقدونیهٔ شمالی",
    "ML" to "مالی",
    "MM" to "میانمار (برمه)",
    "MN" to "مغولستان",
    "MO" to "ماکائو، منطقهٔ ویژهٔ اداری چین",
    "MP" to "جزایر ماریانای شمالی",
    "MQ" to "مارتینیک",
    "MR" to "موریتانی",
    "MS" to "مونت‌سرات",
    "MT" to "مالت",
    "MU" to "موریس",
    "MV" to "مالدیو",
    "MW" to "مالاوی",
    "MX" to "مکزیک",
    "MY" to "مالزی",
    "MZ" to "موزامبیک",
    "NA" to "نامیبیا",
    "NC" to "کالدونیای جدید",
    "NE" to "نیجر",
    "NF" to "جزیرهٔ نورفولک",
    "NG" to "نیجریه",
    "NI" to "نیکاراگوئه",
    "NL" to "هلند",
    "NO" to "نروژ",
    "NP" to "نپال",
    "NR" to "نائورو",
    "NU" to "نیوئه",
    "NZ" to "نیوزیلند",
    "OM" to "عمان",
    "PA" to "پاناما",
    "PE" to "پرو",
    "PF" to "پلی‌نزی فرانسه",
    "PG" to "پاپوا گینهٔ نو",
    "PH" to "فیلیپین",
    "PK" to "پاکستان",
    "PL" to "لهستان",
    "PM" to "سن پیر و میکلن",
    "PN" to "جزایر پیت‌کرن",
    "PR" to "پورتوریکو",
    "PS" to "سرزمین‌های فلسطینی",
    "PT" to "پرتغال",
    "PW" to "پالائو",
    "PY" to "پاراگوئه",
    "QA" to "قطر",
    "QO" to "بخش‌های دورافتادهٔ اقیانوسیه",
    "RE" to "رئونیون",
    "RO" to "رومانی",
    "RS" to "صربستان",
    "RU" to "روسیه",
    "RW" to "رواندا",
    "SA" to "عربستان سعودی",
    "SB" to "جزایر سلیمان",
    "SC" to "سیشل",
    "SD" to "سودان",
    "SE" to "سوئد",
    "SG" to "سنگاپور",
    "SH" to "سنت هلن",
    "SI" to "اسلوونی",
    "SJ" to "سوالبارد و یان ماین",
    "SK" to "اسلواکی",
    "SL" to "سیرالئون",
    "SM" to "سان‌مارینو",
    "SN" to "سنگال",
    "SO" to "سومالی",
    "SR" to "سورینام",
    "SS" to "سودان جنوبی",
    "ST" to "سائوتومه و پرینسیپ",
    "SV" to "السالوادور",
    "SX" to "سنت مارتن",
    "SY" to "سوریه",
    "SZ" to "اسواتینی",
    "TA" to "تریستان دا کونا",
    "TC" to "جزایر تورکس و کایکوس",
    "TD" to "چاد",
    "TF" to "سرزمین‌های جنوبی فرانسه",
    "TG" to "توگو",
    "TH" to "تایلند",
    "TJ" to "تاجیکستان",
    "TK" to "توکلائو",
    "TL" to "تیمور-لسته",
    "TM" to "ترکمنستان",
    "TN" to "تونس",
    "TO" to "تونگا",
    "TR" to "ترکیه",
    "TT" to "ترینیداد و توباگو",
    "TV" to "تووالو",
    "TW" to "تایوان",
    "TZ" to "تانزانیا",
    "UA" to "اوکراین",
    "UG" to "اوگاندا",
    "UM" to "جزایر دورافتادهٔ ایالات متحده",
    "UN" to "سازمان ملل متحد",
    "US" to "ایالات متحده",
    "UY" to "اروگوئه",
    "UZ" to "ازبکستان",
    "VA" to "واتیکان",
    "VC" to "سنت وینسنت و گرنادین",
    "VE" to "ونزوئلا",
    "VG" to "جزایر ویرجین بریتانیا",
    "VI" to "جزایر ویرجین ایالات متحده",
    "VN" to "ویتنام",
    "VU" to "وانواتو",
    "WF" to "والیس و فوتونا",
    "WS" to "ساموآ",
    "XA" to "انگلیسی با لهجه خارجی",
    "XB" to "مجازی - دوجهته",
    "XK" to "کوزوو",
    "YE" to "یمن",
    "YT" to "مایوت",
    "ZA" to "افریقای جنوبی",
    "ZM" to "زامبیا",
    "ZW" to "زیمبابوه",
    "ZZ" to "ناحیهٔ نامشخص",
  ) }

  val fa_AF: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "اندورا",
    "AG" to "انتیگوا و باربودا",
    "AL" to "البانیا",
    "AO" to "انگولا",
    "AQ" to "انترکتیکا",
    "AR" to "ارجنتاین",
    "BA" to "بوسنیا و هرزه‌گوینا",
    "BD" to "بنگله‌دیش",
    "BE" to "بلجیم",
    "BG" to "بلغاریا",
    "BN" to "برونی",
    "BO" to "بولیویا",
    "BR" to "برازیل",
    "BS" to "بهاماس",
    "CD" to "کانگو - کینشاسا",
    "CG" to "کانگو - برازویل",
    "CH" to "سویس",
    "CL" to "چلی",
    "CO" to "کولمبیا",
    "CR" to "کاستریکا",
    "CU" to "کیوبا",
    "DK" to "دنمارک",
    "EA" to "سئوتا و ملیلا",
    "EE" to "استونیا",
    "ER" to "اریتریا",
    "ES" to "هسپانیه",
    "ET" to "ایتوپیا",
    "FI" to "فنلند",
    "FM" to "میکرونزیا",
    "GD" to "گرینادا",
    "GH" to "گانا",
    "GN" to "گینیا",
    "GQ" to "گینیا استوایی",
    "GT" to "گواتیمالا",
    "GW" to "گینیا بیسائو",
    "GY" to "گیانا",
    "HK" to "هانگ کانگ، ناحیهٔ ویژهٔ حکومتی چین",
    "HN" to "هاندوراس",
    "HR" to "کروشیا",
    "HT" to "هایتی",
    "ID" to "اندونیزیا",
    "IE" to "آیرلند",
    "IS" to "آیسلند",
    "JP" to "جاپان",
    "KE" to "کینیا",
    "KH" to "کمپوچیا",
    "KP" to "کوریای شمالی",
    "KR" to "کوریای جنوبی",
    "LK" to "سریلانکا",
    "LS" to "لیسوتو",
    "LT" to "لتوانیا",
    "LV" to "لاتویا",
    "LY" to "لیبیا",
    "MG" to "مادغاسکر",
    "MN" to "منگولیا",
    "MR" to "موریتانیا",
    "MT" to "مالتا",
    "MX" to "مکسیکو",
    "MY" to "مالیزیا",
    "MZ" to "موزمبیق",
    "NG" to "نیجریا",
    "NI" to "نیکاراگوا",
    "NL" to "هالند",
    "NO" to "ناروی",
    "NP" to "نیپال",
    "NZ" to "زیلاند جدید",
    "PA" to "پانامه",
    "PE" to "پیرو",
    "PG" to "پاپوا نیو گینیا",
    "PL" to "پولند",
    "PT" to "پرتگال",
    "PY" to "پاراگوای",
    "RO" to "رومانیا",
    "SE" to "سویدن",
    "SG" to "سینگاپور",
    "SI" to "سلونیا",
    "SJ" to "اسوالبارد و جان ماین",
    "SK" to "سلواکیا",
    "SL" to "سیرالیون",
    "SN" to "سینیگال",
    "SO" to "سومالیه",
    "SV" to "السلوادور",
    "TJ" to "تاجکستان",
    "UG" to "یوگاندا",
    "UY" to "یوروگوای",
    "VC" to "سنت وینسنت و گرنادین‌ها",
    "VE" to "ونزویلا",
    "XK" to "کوسوا",
    "ZW" to "زیمبابوی",
  ) }

  val ff: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Anndoora",
    "AE" to "Emiraat Araab Denntuɗe",
    "AF" to "Afganistaan",
    "AG" to "Antiguwaa e Barbudaa",
    "AI" to "Anngiyaa",
    "AL" to "Albanii",
    "AM" to "Armenii",
    "AO" to "Anngolaa",
    "AR" to "Arjantiin",
    "AS" to "Samowa Amerik",
    "AT" to "Otiriis",
    "AU" to "Ostaraalii",
    "AW" to "Aruuba",
    "AZ" to "Ajerbayjaan",
    "BA" to "Bosnii Hersegowiin",
    "BB" to "Barbadoos",
    "BD" to "Banglaadees",
    "BE" to "Beljik",
    "BF" to "Burkibaa Faaso",
    "BG" to "Bulgarii",
    "BH" to "Bahreyn",
    "BI" to "Burunndi",
    "BJ" to "Benee",
    "BM" to "Bermudaa",
    "BN" to "Burnaay",
    "BO" to "Boliwii",
    "BR" to "Beresiil",
    "BS" to "Bahamaas",
    "BT" to "Butaan",
    "BW" to "Botswaana",
    "BY" to "Belaruus",
    "BZ" to "Beliise",
    "CA" to "Kanadaa",
    "CD" to "Ndenndaandi Demokaraasiire Konngo",
    "CF" to "Ndenndaandi Santarafrik",
    "CG" to "Konngo",
    "CH" to "Suwiis",
    "CI" to "Kodduwaar",
    "CK" to "Duuɗe Kuuk",
    "CL" to "Cilii",
    "CM" to "Kameruun",
    "CN" to "Siin",
    "CO" to "Kolombiya",
    "CR" to "Kosta Rikaa",
    "CU" to "Kubaa",
    "CV" to "Duuɗe Kap Weer",
    "CY" to "Siipar",
    "CZ" to "Ndenndaandi Cek",
    "DE" to "Almaañ",
    "DJ" to "Jibutii",
    "DK" to "Danmark",
    "DM" to "Dominika",
    "DO" to "Ndenndanndi Dominika",
    "DZ" to "Alaseri",
    "EC" to "Ekuwatoor",
    "EE" to "Estoni",
    "EG" to "Ejipt",
    "ER" to "Eriteree",
    "ES" to "Espaañ",
    "ET" to "Ecoppi",
    "FI" to "Fenland",
    "FJ" to "Fijji",
    "FK" to "Duuɗe Falkland",
    "FM" to "Mikoronesii",
    "FR" to "Farayse",
    "GA" to "Gaboo",
    "GB" to "Laamateeri Rentundi",
    "GD" to "Garnaad",
    "GE" to "Jeorgii",
    "GF" to "Giyaan Farayse",
    "GH" to "Ganaa",
    "GI" to "Jibraltaar",
    "GL" to "Gorwendland",
    "GM" to "Gammbi",
    "GN" to "Gine",
    "GP" to "Gwaadalup",
    "GQ" to "Ginee Ekuwaatoriyaal",
    "GR" to "Gerees",
    "GT" to "Gwaatemalaa",
    "GU" to "Guwam",
    "GW" to "Gine-Bisaawo",
    "GY" to "Giyaan",
    "HN" to "Onnduraas",
    "HR" to "Korwasii",
    "HT" to "Haytii",
    "HU" to "Onngiri",
    "ID" to "Enndonesii",
    "IE" to "Irlannda",
    "IL" to "Israa’iila",
    "IN" to "Enndo",
    "IQ" to "Iraak",
    "IR" to "Iraan",
    "IS" to "Islannda",
    "IT" to "Itali",
    "JM" to "Jamayka",
    "JO" to "Jordani",
    "JP" to "Sapoo",
    "KE" to "Keñaa",
    "KG" to "Kirgistaan",
    "KH" to "Kambodso",
    "KI" to "Kiribari",
    "KM" to "Komoor",
    "KN" to "Sent Kits e Newis",
    "KP" to "Koree Rewo",
    "KR" to "Koree Worgo",
    "KW" to "Kuweyti",
    "KY" to "Duuɗe Kaymaa",
    "KZ" to "Kasakstaan",
    "LA" to "Lawoos",
    "LB" to "Libaa",
    "LC" to "Sent Lusiyaa",
    "LI" to "Lincenstayn",
    "LK" to "Siri Lanka",
    "LR" to "Liberiyaa",
    "LS" to "Lesoto",
    "LT" to "Lituaanii",
    "LU" to "Liksembuur",
    "LV" to "Letonii",
    "LY" to "Libi",
    "MA" to "Maruk",
    "MC" to "Monaakoo",
    "MD" to "Moldawii",
    "MG" to "Madagaskaar",
    "MH" to "Duuɗe Marsaal",
    "ML" to "Maali",
    "MM" to "Miyamaar",
    "MN" to "Monngolii",
    "MP" to "Duuɗe Mariyaana Rewo",
    "MQ" to "Martinik",
    "MR" to "Muritani",
    "MS" to "Monseraat",
    "MT" to "Malte",
    "MU" to "Moriis",
    "MV" to "Maldiiwe",
    "MW" to "Malaawi",
    "MX" to "Meksik",
    "MY" to "Malesii",
    "MZ" to "Mosammbik",
    "NA" to "Namibii",
    "NC" to "Nuwel Kaledonii",
    "NE" to "Nijeer",
    "NF" to "Duuɗe Norfolk",
    "NG" to "Nijeriyaa",
    "NI" to "Nikaraguwaa",
    "NL" to "Nederlannda",
    "NO" to "Norwees",
    "NP" to "Nepaal",
    "NR" to "Nawuru",
    "NU" to "Niuwe",
    "NZ" to "Nuwel Selannda",
    "OM" to "Omaan",
    "PA" to "Panamaa",
    "PE" to "Peru",
    "PF" to "Polinesii Farayse",
    "PG" to "Papuwaa Nuwel Gine",
    "PH" to "Filipiin",
    "PK" to "Pakistaan",
    "PL" to "Poloñ",
    "PM" to "See Piyeer e Mikeloo",
    "PN" to "Pitkern",
    "PR" to "Porto Rikoo",
    "PS" to "Palestiin Sisjordani e Gaasaa",
    "PT" to "Purtugaal",
    "PW" to "Palawu",
    "PY" to "Paraguwaay",
    "QA" to "Kataar",
    "RE" to "Rewiñoo",
    "RO" to "Rumanii",
    "RU" to "Riisii",
    "RW" to "Ruwanndaa",
    "SA" to "Arabii Sawdit",
    "SB" to "Duuɗe Solomon",
    "SC" to "Seysel",
    "SD" to "Sudaan",
    "SE" to "Suweed",
    "SG" to "Sinngapuur",
    "SH" to "Sent Helen",
    "SI" to "Slowenii",
    "SK" to "Slowakii",
    "SL" to "Seraa liyon",
    "SM" to "See Maree",
    "SN" to "Senegaal",
    "SO" to "Somalii",
    "SR" to "Surinaam",
    "ST" to "Sawo Tome e Perensipe",
    "SV" to "El Salwador",
    "SY" to "Sirii",
    "SZ" to "Swaasilannda",
    "TC" to "Duuɗe Turke e Keikoos",
    "TD" to "Caad",
    "TG" to "Togoo",
    "TH" to "Taylannda",
    "TJ" to "Tajikistaan",
    "TK" to "Tokelaaw",
    "TL" to "Timoor Fuɗnaange",
    "TM" to "Turkmenistaan",
    "TN" to "Tunisii",
    "TO" to "Tonngaa",
    "TR" to "Turkii",
    "TT" to "Tirnidaad e Tobaago",
    "TV" to "Tuwaluu",
    "TW" to "Taywaan",
    "TZ" to "Tansanii",
    "UA" to "Ukereen",
    "UG" to "Unganndaa",
    "US" to "Dowlaaji Dentuɗi Amerik",
    "UY" to "Uruguwaay",
    "UZ" to "Usbekistaan",
    "VA" to "Dowla Waticaan",
    "VC" to "See Weesaa e Garnadiin",
    "VE" to "Wenesuwelaa",
    "VG" to "duuɗe kecce britanii",
    "VI" to "Duuɗe Kecce Amerik",
    "VN" to "Wiyetnaam",
    "VU" to "Wanuwaatuu",
    "WF" to "Walis e Futuna",
    "WS" to "Samowaa",
    "YE" to "Yemen",
    "YT" to "Mayoot",
    "ZA" to "Afrik bŋ Worgo",
    "ZM" to "Sammbi",
    "ZW" to "Simbaabuwe",
  ) }

  val ff_Adlm: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "𞤀𞤣𞤵𞤲𞤢",
    "002" to "𞤀𞤬𞤪𞤭𞤳𞤢𞥄",
    "003" to "𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫 𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄",
    "005" to "𞤙𞤢𞤥𞤲𞤢𞥄𞤲𞤺𞤫 𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄",
    "009" to "𞤌𞤧𞤭𞤴𞤢𞤲𞤭𞥅",
    "011" to "𞤖𞤭𞥅𞤪𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞥄",
    "013" to "𞤚𞤵𞤥𞤦𞤮 𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄",
    "014" to "𞤊𞤵𞤯𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞥄",
    "015" to "𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞥄",
    "017" to "𞤚𞤵𞤥𞤦𞤮 𞤀𞤬𞤪𞤭𞤳𞤢𞥄",
    "018" to "𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞥄",
    "019" to "𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄",
    "021" to "𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄",
    "029" to "𞤑𞤢𞤪𞤦𞤭𞤴𞤢𞥄",
    "030" to "𞤊𞤵𞤯𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞥄𞤧𞤭𞤴𞤢",
    "034" to "𞤙𞤢𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞥄𞤧𞤭𞤴𞤢",
    "035" to "𞤙𞤢𞤥𞤬𞤭𞤯𞤲𞤢𞥄𞤲𞤺𞤫 𞤀𞥄𞤧𞤭𞤴𞤢",
    "039" to "𞤙𞤢𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤓𞤪𞤨𞤢",
    "053" to "𞤀𞤧𞤼𞤢𞤪𞤤𞤢𞥄𞤧𞤭𞤴𞤢𞥄",
    "054" to "𞤃𞤭𞤤𞤢𞤲𞤭𞥅𞤧𞤴𞤢",
    "057" to "𞤖𞤭𞤤𞥆𞤮 𞤃𞤭𞤳𞤪𞤮𞤲𞤭𞥅𞤧𞤸𞤮",
    "061" to "𞤆𞤮𞤤𞤭𞤲𞤭𞥅𞤧𞤴𞤢",
    "142" to "𞤀𞥄𞤧𞤭𞤴𞤢",
    "143" to "𞤚𞤵𞤥𞤦𞤮𞥅𞤪𞤭 𞤀𞥄𞤧𞤭𞤴𞤢",
    "145" to "𞤖𞤭𞥅𞤪𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤀𞥄𞤧𞤭𞤴𞤢",
    "150" to "𞤓𞤪𞤨𞤢",
    "151" to "𞤊𞤵𞤯𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤓𞤪𞤨𞤢",
    "154" to "𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤓𞤪𞤨𞤢",
    "155" to "𞤖𞤭𞥅𞤪𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭 𞤓𞤪𞤨𞤢",
    "202" to "𞤀𞤬𞤪𞤭𞤳𞤢𞥄 𞤂𞤫𞤧-𞤅𞤢𞥄𞤸𞤢𞤪𞤢",
    "419" to "𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞥄 𞤂𞤢𞤼𞤭𞤲𞤳𞤮",
    "AC" to "𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤀𞤧𞤢𞤲𞤧𞤮𞥅𞤲",
    "AD" to "𞤀𞤲𞤣𞤮𞤪𞤢𞥄",
    "AE" to "𞤁𞤫𞤲𞤼𞤢𞤤 𞤋𞤥𞤪𞤢𞥄𞤼𞤭 𞤀𞥄𞤪𞤢𞤦𞤵",
    "AF" to "𞤀𞤬𞤺𞤢𞤲𞤭𞤧𞤼𞤢𞥄𞤲",
    "AG" to "𞤀𞤲𞤼𞤭𞤺𞤵𞤱𞤢 & 𞤄𞤢𞤪𞤦𞤵𞥅𞤣𞤢",
    "AI" to "𞤀𞤲𞤺𞤭𞤤𞤢𞥄",
    "AL" to "𞤀𞤤𞤦𞤢𞤲𞤭𞤴𞤢𞥄",
    "AM" to "𞤀𞤪𞤥𞤫𞤲𞤭𞤴𞤢𞥄",
    "AO" to "𞤀𞤲𞤺𞤮𞤤𞤢𞥄",
    "AQ" to "𞤀𞤲𞤼𞤢𞤪𞤼𞤭𞤳𞤢𞥄",
    "AR" to "𞤀𞤪𞤶𞤢𞤲𞤼𞤭𞤲𞤢𞥄",
    "AS" to "𞤅𞤢𞤥𞤵𞤱𞤢 𞤀𞤥𞤫𞤪𞤭𞤳𞤭𞤴𞤢𞤲𞤳𞤮",
    "AT" to "𞤌𞤼𞤭𞤪𞤧𞤢",
    "AU" to "𞤌𞤧𞤼𞤢𞤪𞤤𞤭𞤴𞤢𞥄",
    "AW" to "𞤀𞤪𞤵𞤦𞤢𞥄",
    "AX" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤀𞤤𞤢𞤲𞤣",
    "AZ" to "𞤀𞥁𞤫𞤪𞤦𞤢𞤭𞤶𞤢𞥄𞤲",
    "BA" to "𞤄𞤮𞤧𞤲𞤭𞤴𞤢 & 𞤖𞤫𞤪𞤧𞤫𞤳𞤮𞤾𞤭𞤲𞤢𞥄",
    "BB" to "𞤄𞤢𞤪𞤦𞤫𞥅𞤣𞤮𞥅𞤧",
    "BD" to "𞤄𞤢𞤲𞤺𞤭𞤤𞤢𞤣𞤫𞥅𞤧",
    "BE" to "𞤄𞤫𞤤𞤶𞤭𞤳𞤢𞥄",
    "BF" to "𞤄𞤵𞤪𞤳𞤭𞤲𞤢 𞤊𞤢𞤧𞤮𞥅",
    "BG" to "𞤄𞤵𞥅𞤤𞤺𞤢𞤪𞤭𞤴𞤢𞥄",
    "BH" to "𞤄𞤢𞤸𞤢𞤪𞤢𞤴𞤲",
    "BI" to "𞤄𞤵𞤪𞤵𞤲𞤣𞤭",
    "BJ" to "𞤄𞤫𞤲𞤫𞤲",
    "BL" to "𞤅𞤼. 𞤄𞤢𞤪𞤼𞤫𞤤𞤭𞤥𞤭",
    "BM" to "𞤄𞤭𞤪𞤥𞤵𞤣𞤢",
    "BN" to "𞤄𞤵𞤪𞤲𞤢𞥄𞤴",
    "BO" to "𞤄𞤮𞤤𞤭𞥅𞤾𞤭𞤴𞤢𞥄",
    "BQ" to "𞤑𞤢𞤪𞤦𞤭𞤴𞤢𞥄 𞤖𞤮𞤤𞤢𞤲𞤣𞤭𞤴𞤢𞥄",
    "BR" to "𞤄𞤪𞤢𞤧𞤭𞤤",
    "BS" to "𞤄𞤢𞤸𞤢𞤥𞤢𞥄𞤧",
    "BT" to "𞤄𞤵𞥅𞤼𞤢𞥄𞤲",
    "BV" to "𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤄𞤵𞥅𞤾𞤫𞥅",
    "BW" to "𞤄𞤮𞤼𞤧𞤵𞤱𞤢𞥄𞤲𞤢",
    "BY" to "𞤄𞤫𞤤𞤢𞤪𞤵𞥅𞤧",
    "BZ" to "𞤄𞤫𞤤𞤭𞥅𞥁",
    "CA" to "𞤑𞤢𞤲𞤢𞤣𞤢𞥄",
    "CC" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤑𞤮𞤳𞤮𞥅𞤧 (𞤑𞤭𞥅𞤤𞤭𞤲𞤺)",
    "CD" to "𞤑𞤮𞤲𞤺𞤮 - 𞤑𞤭𞤲𞤧𞤢𞤧𞤢",
    "CF" to "𞤐𞤣𞤫𞤲𞤣𞤭 𞤚𞤵𞤥𞤦𞤮𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞥄",
    "CG" to "𞤑𞤮𞤲𞤺𞤮 - 𞤄𞤪𞤢𞥁𞤢𞤾𞤭𞤤",
    "CH" to "𞤅𞤵𞤱𞤭𞤪𞤧𞤢𞥄",
    "CI" to "𞤑𞤮𞤼𞤣𞤭𞤾𞤢𞥄𞤪",
    "CK" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤑𞤵𞥅𞤳",
    "CL" to "𞤕𞤭𞤤𞤫𞥊𞥅",
    "CM" to "𞤑𞤢𞤥𞤢𞤪𞤵𞥅𞤲",
    "CN" to "𞤕𞤢𞤴𞤲𞤢",
    "CO" to "𞤑𞤮𞤤𞤮𞤥𞤦𞤭𞤴𞤢𞥄",
    "CP" to "𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤑𞤭𞤤𞤭𞤨𞤫𞤪𞤼𞤮𞤲",
    "CR" to "𞤑𞤮𞤧𞤼𞤢 𞤈𞤭𞤳𞤢𞥄",
    "CU" to "𞤑𞤵𞥅𞤦𞤢𞥄",
    "CV" to "𞤑𞤢𞥄𞤦𞤮 𞤜𞤫𞤪𞤣𞤫",
    "CW" to "𞤑𞤵𞥅𞤪𞤢𞤧𞤢𞤱𞤮",
    "CX" to "𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤑𞤭𞤪𞤧𞤭𞤥𞤢𞥄𞤧",
    "CY" to "𞤑𞤵𞤦𞤪𞤵𞥅𞤧",
    "CZ" to "𞤕𞤫𞥅𞤳𞤭𞤴𞤢𞥄",
    "DE" to "𞤔𞤫𞤪𞤥𞤢𞤲𞤭𞥅",
    "DG" to "𞤔𞤮𞤺𞤮 𞤘𞤢𞥄𞤪𞤧𞤭𞤴𞤢",
    "DJ" to "𞤔𞤭𞤦𞤵𞥅𞤼𞤭",
    "DK" to "𞤁𞤢𞤲𞤵𞤥𞤢𞤪𞤳",
    "DM" to "𞤁𞤮𞤥𞤭𞤲𞤭𞤳𞤢𞥄",
    "DO" to "𞤐𞤣𞤫𞤲𞤣𞤭 𞤁𞤮𞤥𞤭𞤲𞤭𞤳𞤢𞥄",
    "DZ" to "𞤀𞤤𞤶𞤢𞤪𞤭𞥅",
    "EA" to "𞤅𞤭𞤼𞥆𞤢 & 𞤃𞤫𞤤𞤭𞤤𞤢",
    "EC" to "𞤉𞤳𞤵𞤱𞤢𞤣𞤮𞥅𞤪",
    "EE" to "𞤉𞤧𞤼𞤮𞤲𞤭𞤴𞤢𞥄",
    "EG" to "𞤃𞤭𞤧𞤭𞤪𞤢",
    "EH" to "𞤅𞤢𞥄𞤸𞤢𞤪𞤢 𞤖𞤭𞥅𞤲𞤢𞥄𞤪𞤭",
    "ER" to "𞤉𞤪𞤭𞥅𞤼𞤫𞤪𞤫",
    "ES" to "𞤉𞤧𞤨𞤢𞤻𞤢𞥄",
    "ET" to "𞤀𞤦𞤢𞤧𞤭𞤲𞤭𞥅",
    "EU" to "𞤑𞤢𞤱𞤼𞤢𞤤 𞤓𞤪𞤨𞤢",
    "EZ" to "𞤊𞤭𞤪𞤤𞤢 𞤓𞤪𞤮𞥅",
    "FI" to "𞤊𞤭𞤲𞤤𞤢𞤲𞤣",
    "FJ" to "𞤊𞤭𞤶𞤭𞥅",
    "FK" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤊𞤢𞤤𞤳𞤵𞤤𞤢𞤲𞤣",
    "FM" to "𞤃𞤭𞤳𞤪𞤮𞤲𞤫𞥅𞤧𞤭𞤴𞤢",
    "FO" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤊𞤢𞤪𞤵𞥅𞤧",
    "FR" to "𞤊𞤢𞤪𞤢𞤲𞤧𞤭",
    "GA" to "𞤘𞤢𞤦𞤮𞤲",
    "GB" to "𞤁𞤫𞤲𞤼𞤢𞤤 𞤐𞤺𞤫𞤯𞤵𞥅𞤪𞤭",
    "GD" to "𞤘𞤢𞤪𞤲𞤢𞤣𞤢𞥄",
    "GE" to "𞤔𞤮𞤪𞤶𞤭𞤴𞤢𞥄",
    "GF" to "𞤘𞤵𞤴𞤢𞥄𞤲 𞤊𞤪𞤢𞤲𞤧𞤭𞤲𞤳𞤮",
    "GG" to "𞤘𞤢𞤪𞤲𞤫𞤧𞤭𞥅",
    "GH" to "𞤘𞤢𞤲𞤢",
    "GI" to "𞤔𞤭𞤦𞤪𞤢𞤤𞤼𞤢𞥄",
    "GL" to "𞤘𞤭𞤪𞤤𞤢𞤲𞤣𞤭",
    "GM" to "𞤘𞤢𞤥𞤦𞤭𞤴𞤢",
    "GN" to "𞤘𞤭𞤲𞤫",
    "GP" to "𞤘𞤵𞤱𞤢𞤣𞤢𞤤𞤵𞤨𞤫𞥅",
    "GQ" to "𞤘𞤭𞤲𞤫 𞤕𞤢𞤳𞤢𞤲𞤼𞤫𞥅𞤪𞤭",
    "GR" to "𞤀𞤤𞤴𞤵𞤲𞤢𞥄𞤲",
    "GS" to "𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫 𞤔𞤮𞤪𞤶𞤭𞤴𞤢 & 𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫 𞤅𞤢𞤲𞤣𞤵𞤱𞤭𞥅𞤷",
    "GT" to "𞤘𞤵𞤱𞤢𞤼𞤫𞤥𞤢𞤤𞤢𞥄",
    "GU" to "𞤘𞤵𞤱𞤢𞥄𞤥",
    "GW" to "𞤘𞤭𞤲𞤫-𞤄𞤭𞤧𞤢𞤱𞤮𞥅",
    "GY" to "𞤘𞤢𞤴𞤢𞤲𞤢𞥄",
    "HK" to "𞤖𞤂𞤀 𞤕𞤢𞤴𞤲𞤢 𞤫 𞤖𞤮𞤲𞤺 𞤑𞤮𞤲𞤺",
    "HM" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤖𞤭𞤪𞤣𞤭 & 𞤃𞤢𞤳𞤣𞤮𞤲𞤢𞤤",
    "HN" to "𞤖𞤮𞤲𞤣𞤭𞤪𞤢𞥄𞤧",
    "HR" to "𞤑𞤵𞤪𞤱𞤢𞥄𞤧𞤭𞤴𞤢",
    "HT" to "𞤖𞤢𞤴𞤼𞤭𞥅",
    "HU" to "𞤖𞤢𞤲𞤺𞤢𞤪𞤭𞤴𞤢𞥄",
    "IC" to "𞤅𞤵𞤪𞤭𞥅𞤪𞤫-𞤑𞤢𞤲𞤢𞤪𞤭𞥅",
    "ID" to "𞤋𞤲𞤣𞤮𞤲𞤭𞥅𞤧𞤴𞤢",
    "IE" to "𞤋𞤪𞤤𞤢𞤲𞤣",
    "IL" to "𞤋𞤧𞤪𞤢𞥄𞤴𞤭𞥅𞤤",
    "IM" to "𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤃𞤫𞥅𞤲",
    "IN" to "𞤋𞤲𞤣𞤭𞤴𞤢",
    "IQ" to "𞤋𞤪𞤢𞥄𞤳",
    "IR" to "𞤋𞤪𞤢𞥄𞤲",
    "IS" to "𞤀𞤴𞤧𞤵𞤤𞤢𞤲𞤣",
    "IT" to "𞤋𞤼𞤢𞤤𞤭𞥅",
    "JE" to "𞤔𞤫𞤪𞤧𞤭𞥅",
    "JM" to "𞤔𞤢𞤥𞤢𞤴𞤳𞤢𞥄",
    "JO" to "𞤔𞤮𞤪𞤣𞤢𞥄𞤲",
    "JP" to "𞤐𞤭𞤨𞥆𞤮𞤲",
    "KE" to "𞤑𞤫𞤲𞤭𞤴𞤢𞥄",
    "KG" to "𞤑𞤭𞤪𞤶𞤭𞤧𞤼𞤢𞥄𞤲",
    "KH" to "𞤑𞤢𞤥𞤦𞤮𞥅𞤣𞤭𞤴𞤢",
    "KI" to "𞤑𞤭𞤪𞤦𞤢𞤼𞤭𞥅",
    "KM" to "𞤑𞤮𞤥𞤮𞥅𞤪𞤮",
    "KN" to "𞤅𞤼. 𞤑𞤪𞤭𞤧𞤼𞤮𞤦𞤢𞤤 & 𞤐𞤫𞥅𞤾𞤭𞤧",
    "KP" to "𞤑𞤮𞥅𞤪𞤫𞤴𞤢𞥄 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫",
    "KR" to "𞤑𞤮𞥅𞤪𞤫𞤴𞤢𞥄 𞤙𞤢𞤥𞤲𞤢𞥄𞤲𞤺𞤫",
    "KW" to "𞤑𞤵𞤱𞤢𞤴𞤼𞤵",
    "KY" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤑𞤢𞤴𞤥𞤢𞥄𞤲",
    "KZ" to "𞤑𞤢𞥁𞤢𞤧𞤼𞤢𞥄𞤲",
    "LA" to "𞤂𞤢𞤱𞤮𞥅𞤧",
    "LB" to "𞤂𞤭𞤦𞤢𞤲𞤮𞥅𞤲",
    "LC" to "𞤅𞤼. 𞤂𞤵𞥅𞤧𞤭𞤴𞤢",
    "LI" to "𞤂𞤭𞤧𞤼𞤫𞤲𞤧𞤭𞤼𞤫𞥅𞤲",
    "LK" to "𞤅𞤭𞤪 𞤂𞤢𞤲𞤳𞤢𞥄",
    "LR" to "𞤂𞤢𞤦𞤭𞤪𞤭𞤴𞤢𞥄",
    "LS" to "𞤂𞤫𞤧𞤮𞤼𞤮𞥅",
    "LT" to "𞤂𞤭𞤼𞤵𞤾𞤢",
    "LU" to "𞤂𞤵𞤳𞤧𞤢𞤲𞤦𞤵𞥅𞤺",
    "LV" to "𞤂𞤢𞤼𞤾𞤭𞤴𞤢",
    "LY" to "𞤂𞤭𞤦𞤭𞤴𞤢𞥄",
    "MA" to "𞤃𞤢𞤪𞤮𞥅𞤳",
    "MC" to "𞤃𞤮𞤲𞤢𞤳𞤮𞥅",
    "MD" to "𞤃𞤮𞤤𞤣𞤮𞤾𞤢𞥄",
    "ME" to "𞤃𞤮𞤲𞤼𞤫𞤲𞤫𞥅𞤺𞤮𞤪𞤮",
    "MF" to "𞤅𞤼. 𞤃𞤢𞤪𞤼𞤫𞤲",
    "MG" to "𞤃𞤢𞤣𞤢𞤺𞤢𞤧𞤳𞤢𞥄𞤪",
    "MH" to "𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤃𞤢𞤪𞥃𞤢𞤤",
    "MK" to "𞤃𞤢𞤳𞤫𞤣𞤮𞤲𞤭𞤴𞤢𞥄 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫",
    "ML" to "𞤃𞤢𞥄𞤤𞤭",
    "MM" to "𞤃𞤭𞤴𞤢𞤥𞤢𞥄𞤪 (𞤄𞤵𞥅𞤪𞤥𞤢)",
    "MN" to "𞤃𞤮𞤲𞤺𞤮𞤤𞤭𞤴𞤢",
    "MO" to "𞤖𞤂𞤀 𞤕𞤢𞤴𞤲𞤢 𞤫 𞤃𞤢𞤳𞤢𞤱𞤮𞥅",
    "MP" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤃𞤢𞤪𞤭𞤴𞤢𞥄𞤲𞤢 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤭",
    "MQ" to "𞤃𞤢𞤪𞤼𞤭𞤲𞤭𞤳𞤢𞥄",
    "MR" to "𞤃𞤮𞤪𞤼𞤢𞤲𞤭𞥅",
    "MS" to "𞤃𞤮𞤲𞤧𞤭𞤪𞤢𞥄𞤼",
    "MT" to "𞤃𞤢𞤤𞤼𞤢",
    "MU" to "𞤃𞤮𞤪𞤭𞥅𞤧𞤭",
    "MV" to "𞤃𞤢𞤤𞤣𞤭𞥅𞤬",
    "MW" to "𞤃𞤢𞤤𞤢𞤱𞤭𞥅",
    "MX" to "𞤃𞤫𞤳𞤧𞤭𞤳𞤮𞥅",
    "MY" to "𞤃𞤢𞤤𞤫𞥅𞤧𞤭𞤴𞤢",
    "MZ" to "𞤃𞤮𞤧𞤢𞤥𞤦𞤭𞥅𞤳",
    "NA" to "𞤐𞤢𞤥𞤭𞥅𞤦𞤭𞤴𞤢𞥄",
    "NC" to "𞤑𞤢𞤤𞤭𞤣𞤮𞤲𞤭𞤴𞤢𞥄 𞤖𞤫𞤧𞤮",
    "NE" to "𞤐𞤭𞥅𞤶𞤫𞤪",
    "NF" to "𞤅𞤵𞤪𞤭𞥅𞤪𞤫 𞤐𞤮𞤪𞤬𞤮𞤤𞤳𞤵",
    "NG" to "𞤐𞤢𞤶𞤫𞤪𞤭𞤴𞤢𞥄",
    "NI" to "𞤐𞤭𞤳𞤢𞤪𞤢𞤺𞤵𞤱𞤢𞥄",
    "NL" to "𞤖𞤮𞤤𞤢𞤲𞤣𞤭𞤴𞤢𞥄",
    "NO" to "𞤐𞤮𞤪𞤺𞤫𞤴𞤢𞥄",
    "NP" to "𞤐𞤭𞤨𞤢𞥄𞤤",
    "NR" to "𞤐𞤢𞤱𞤪𞤵",
    "NU" to "𞤐𞤵𞥅𞤱𞤭",
    "NZ" to "𞤐𞤫𞤱 𞤟𞤫𞤤𞤢𞤲𞤣",
    "OM" to "𞤌𞥅𞤥𞤢𞥄𞤲",
    "PA" to "𞤆𞤢𞤲𞤢𞤥𞤢",
    "PE" to "𞤆𞤫𞤪𞤵𞥅",
    "PF" to "𞤆𞤮𞤤𞤭𞤲𞤫𞥅𞤧𞤭𞤴𞤢 𞤊𞤪𞤢𞤲𞤧𞤭𞤲𞤳𞤮",
    "PG" to "𞤆𞤢𞤨𞤵𞤱𞤢 𞤘𞤭𞤲𞤫 𞤖𞤫𞤧𞤮",
    "PH" to "𞤊𞤭𞤤𞤭𞤨𞤭𞥅𞤲",
    "PK" to "𞤆𞤢𞤳𞤭𞤧𞤼𞤢𞥄𞤲",
    "PL" to "𞤆𞤮𞤤𞤢𞤲𞤣",
    "PM" to "𞤅𞤼. 𞤆𞤭𞤴𞤫𞥅𞤪 & 𞤃𞤭𞤳𞤫𞤤𞤮𞤲",
    "PN" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤆𞤭𞤼𞤳𞤭𞥅𞤪𞤲𞤵",
    "PR" to "𞤆𞤮𞤪𞤼𞤮 𞤈𞤭𞤳𞤮𞥅",
    "PS" to "𞤂𞤫𞤧𞤣𞤭𞥅𞤶𞤭 𞤊𞤢𞤤𞤫𞤧𞤼𞤭𞥅𞤲",
    "PT" to "𞤆𞤮𞥅𞤪𞤼𞤵𞤺𞤢𞥄𞤤",
    "PW" to "𞤆𞤢𞤤𞤢𞤱",
    "PY" to "𞤆𞤢𞥄𞤪𞤢𞤺𞤵𞤱𞤢𞥄𞤴",
    "QA" to "𞤊𞤢𞤤𞤫𞤧𞤼𞤭𞥅𞤲",
    "QO" to "𞤚𞤢𞤼𞥆𞤫𞥅𞤪𞤭 𞤌𞤧𞤴𞤢𞤲𞤭𞤴𞤢",
    "RE" to "𞤈𞤫𞥅𞤲𞤭𞤴𞤮𞤲",
    "RO" to "𞤈𞤵𞤥𞤢𞥄𞤲𞤭𞤴𞤢",
    "RS" to "𞤅𞤫𞤪𞤦𞤭𞤴𞤢𞥄",
    "RU" to "𞤈𞤮𞥅𞤧𞤭𞤴𞤢",
    "RW" to "𞤈𞤵𞤱𞤢𞤲𞤣𞤢𞥄",
    "SA" to "𞤅𞤢𞤵𞥅𞤣 𞤀𞥄𞤪𞤢𞤦𞤭𞤴𞤢𞥄",
    "SB" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤅𞤵𞤤𞤢𞤴𞤥𞤢𞥄𞤲",
    "SC" to "𞤅𞤫𞤴𞤭𞤧𞤫𞤤",
    "SD" to "𞤅𞤵𞤣𞤢𞥄𞤲",
    "SE" to "𞤅𞤵𞤱𞤫𞤣𞤭𞤴𞤢𞥄",
    "SG" to "𞤅𞤭𞤲𞤺𞤢𞤨𞤵𞥅𞤪",
    "SH" to "𞤅𞤫𞤲-𞤖𞤫𞤤𞤫𞤲𞤢𞥄",
    "SI" to "𞤅𞤵𞤤𞤮𞤾𞤫𞤲𞤭𞤴𞤢𞥄",
    "SJ" to "𞤅𞤢𞤾𞤢𞤤𞤦𞤢𞤪𞤣 & 𞤔𞤢𞤲 𞤃𞤢𞤴𞤫𞤲",
    "SK" to "𞤅𞤵𞤤𞤮𞤾𞤢𞥄𞤳𞤭𞤴𞤢",
    "SL" to "𞤅𞤢𞤪𞤢𞤤𞤮𞤲",
    "SM" to "𞤅𞤢𞤲 𞤃𞤢𞤪𞤭𞤲𞤮𞥅",
    "SN" to "𞤅𞤫𞤲𞤫𞤺𞤢𞥄𞤤",
    "SO" to "𞤅𞤵𞥅𞤥𞤢𞥄𞤤𞤭",
    "SR" to "𞤅𞤵𞤪𞤭𞤲𞤢𞥄𞤥",
    "SS" to "𞤅𞤵𞤣𞤢𞥄𞤲 𞤂𞤫𞤧𞤤𞤫𞤴𞤪𞤭",
    "ST" to "𞤅𞤢𞤱𞤵 𞤚𞤵𞤥𞤫𞥅 & 𞤆𞤫𞤪𞤫𞤲𞤧𞤭𞤨𞤫",
    "SV" to "𞤉𞤤 𞤅𞤢𞤤𞤾𞤢𞤣𞤮𞥅𞤪",
    "SX" to "𞤅𞤫𞤲𞤼𞤵 𞤃𞤢𞥄𞤪𞤼𞤫𞤲",
    "SY" to "𞤅𞤵𞥅𞤪𞤭𞤴𞤢𞥄",
    "SZ" to "𞤉𞤧𞤱𞤢𞤼𞤭𞤲𞤭",
    "TA" to "𞤚𞤵𞤪𞤧𞤵𞤼𞤢𞤲 𞤁𞤢𞤳𞤵𞤲𞤸𞤢",
    "TC" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤚𞤵𞤪𞤳𞤵𞤧 & 𞤑𞤢𞤴𞤳𞤮𞥅𞤧",
    "TD" to "𞤕𞤢𞥄𞤣",
    "TF" to "𞤚𞤵𞤥𞤦𞤫 𞤂𞤫𞤧𞤤𞤫𞤴𞤶𞤫 𞤊𞤪𞤢𞤲𞤧𞤭",
    "TG" to "𞤚𞤮𞤺𞤮",
    "TH" to "𞤚𞤢𞥄𞤴𞤤𞤢𞤲𞤣",
    "TJ" to "𞤚𞤢𞤶𞤭𞤳𞤭𞤧𞤼𞤢𞥄𞤲",
    "TK" to "𞤚𞤮𞥅𞤳𞤮𞤤𞤢𞥄𞤱𞤵",
    "TL" to "𞤚𞤭𞤥𞤮𞥅𞤪 𞤂𞤫𞤧𞤼𞤫",
    "TM" to "𞤚𞤵𞤪𞤳𞤵𞤥𞤫𞤲𞤭𞤧𞤼𞤢𞥄𞤲",
    "TN" to "𞤚𞤵𞤲𞤭𞥅𞤧𞤢",
    "TO" to "𞤚𞤮𞤲𞤺𞤢",
    "TR" to "𞤚𞤵𞤪𞤳𞤭𞤴𞤢𞥄",
    "TT" to "𞤚𞤭𞤪𞤲𞤭𞤣𞤢𞥄𞤣 & 𞤚𞤮𞤦𞤢𞤺𞤮𞥅",
    "TV" to "𞤚𞤵𞥅𞤾𞤢𞤤𞤵",
    "TW" to "𞤚𞤢𞤴𞤱𞤢𞥄𞤲",
    "TZ" to "𞤚𞤢𞤲𞤧𞤢𞤲𞤭𞥅",
    "UA" to "𞤓𞤳𞤪𞤫𞥅𞤲𞤭𞤴𞤢",
    "UG" to "𞤓𞤺𞤢𞤲𞤣𞤢𞥄",
    "UM" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤁𞤢𞥄𞤴𞤭𞥅𞤯𞤫 𞤁𞤂𞤀",
    "UN" to "𞤑𞤢𞤱𞤼𞤢𞤤 𞤘𞤫𞤲𞤯𞤭",
    "US" to "𞤁𞤫𞤲𞤼𞤢𞤤 𞤂𞤢𞤪𞤫",
    "UY" to "𞤒𞤵𞤪𞤺𞤮𞤴",
    "UZ" to "𞤓𞥁𞤦𞤫𞤳𞤭𞤧𞤼𞤢𞥄𞤲",
    "VA" to "𞤜𞤢𞤼𞤭𞤳𞤢𞥄𞤲",
    "VC" to "𞤅𞤼. 𞤜𞤭𞤲𞤧𞤢𞤲 & 𞤘𞤭𞤪𞤲𞤢𞤣𞤭𞥅𞤲",
    "VE" to "𞤜𞤫𞥊𞤲𞤭𞥅𞥁𞤵𞤱𞤫𞤤𞤢𞥄",
    "VG" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤜𞤭𞤪𞤺𞤭𞥅𞤲 𞤄𞤪𞤭𞤼𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤶𞤫",
    "VI" to "𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤜𞤭𞤪𞤺𞤭𞥅𞤲 𞤁𞤂𞤀",
    "VN" to "𞤜𞤭𞤴𞤫𞤼𞤲𞤢𞥄𞤥",
    "VU" to "𞤜𞤢𞤲𞤵𞤱𞤢𞥄𞤼𞤵",
    "WF" to "𞤏𞤢𞤤𞥆𞤭𞥅𞤧 & 𞤊𞤵𞤼𞤵𞤲𞤢",
    "WS" to "𞤅𞤢𞤥𞤵𞤱𞤢",
    "XA" to "𞤌𞤻𞤵𞤲𞤣𞤫-𞤃𞤢𞤧𞤫",
    "XB" to "𞤌𞤻𞤵𞤲𞤣𞤫-𞤄𞤭𞤣𞤭",
    "XK" to "𞤑𞤮𞥅𞤧𞤮𞤾𞤮𞥅",
    "YE" to "𞤒𞤢𞤥𞤢𞤲",
    "YT" to "𞤃𞤢𞤴𞤮𞥅𞤼𞤵",
    "ZA" to "𞤀𞤬𞤪𞤭𞤳𞤢 𞤂𞤫𞤧𞤤𞤫𞤴𞤪𞤭",
    "ZM" to "𞤟𞤢𞤥𞤦𞤭𞤴𞤢",
    "ZW" to "𞤟𞤭𞤥𞤦𞤢𞥄𞤥𞤵𞤴𞤢",
    "ZZ" to "𞤖𞤭𞤤𞥆𞤮 𞤀𞤧-𞤢𞤲𞤣𞤢𞥄𞤲𞤺𞤮",
  ) }

  val ff_Adlm_BF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_GM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_GW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_LR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_NG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_SL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_SN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Anndoora",
    "AE" to "Emiraat Araab Denntuɗe",
    "AF" to "Afganistaan",
    "AG" to "Antiguwaa e Barbudaa",
    "AI" to "Anngiyaa",
    "AL" to "Albanii",
    "AM" to "Armenii",
    "AO" to "Anngolaa",
    "AR" to "Arjantiin",
    "AS" to "Samowa Amerik",
    "AT" to "Otiriis",
    "AU" to "Ostaraalii",
    "AW" to "Aruuba",
    "AZ" to "Ajerbayjaan",
    "BA" to "Bosnii Hersegowiin",
    "BB" to "Barbadoos",
    "BD" to "Banglaadees",
    "BE" to "Beljik",
    "BF" to "Burkibaa Faaso",
    "BG" to "Bulgarii",
    "BH" to "Bahreyn",
    "BI" to "Burunndi",
    "BJ" to "Benee",
    "BM" to "Bermudaa",
    "BN" to "Burnaay",
    "BO" to "Boliwii",
    "BR" to "Beresiil",
    "BS" to "Bahamaas",
    "BT" to "Butaan",
    "BW" to "Botswaana",
    "BY" to "Belaruus",
    "BZ" to "Beliise",
    "CA" to "Kanadaa",
    "CD" to "Ndenndaandi Demokaraasiire Konngo",
    "CF" to "Ndenndaandi Santarafrik",
    "CG" to "Konngo",
    "CH" to "Suwiis",
    "CI" to "Kodduwaar",
    "CK" to "Duuɗe Kuuk",
    "CL" to "Cilii",
    "CM" to "Kameruun",
    "CN" to "Siin",
    "CO" to "Kolombiya",
    "CR" to "Kosta Rikaa",
    "CU" to "Kubaa",
    "CV" to "Duuɗe Kap Weer",
    "CY" to "Siipar",
    "CZ" to "Ndenndaandi Cek",
    "DE" to "Almaañ",
    "DJ" to "Jibutii",
    "DK" to "Danmark",
    "DM" to "Dominika",
    "DO" to "Ndenndanndi Dominika",
    "DZ" to "Alaseri",
    "EC" to "Ekuwatoor",
    "EE" to "Estoni",
    "EG" to "Ejipt",
    "ER" to "Eriteree",
    "ES" to "Espaañ",
    "ET" to "Ecoppi",
    "FI" to "Fenland",
    "FJ" to "Fijji",
    "FK" to "Duuɗe Falkland",
    "FM" to "Mikoronesii",
    "FR" to "Farayse",
    "GA" to "Gaboo",
    "GB" to "Laamateeri Rentundi",
    "GD" to "Garnaad",
    "GE" to "Jeorgii",
    "GF" to "Giyaan Farayse",
    "GH" to "Ganaa",
    "GI" to "Jibraltaar",
    "GL" to "Gorwendland",
    "GM" to "Gammbi",
    "GN" to "Gine",
    "GP" to "Gwaadalup",
    "GQ" to "Ginee Ekuwaatoriyaal",
    "GR" to "Gerees",
    "GT" to "Gwaatemalaa",
    "GU" to "Guwam",
    "GW" to "Gine-Bisaawo",
    "GY" to "Giyaan",
    "HN" to "Onnduraas",
    "HR" to "Korwasii",
    "HT" to "Haytii",
    "HU" to "Onngiri",
    "ID" to "Enndonesii",
    "IE" to "Irlannda",
    "IL" to "Israa’iila",
    "IN" to "Enndo",
    "IQ" to "Iraak",
    "IR" to "Iraan",
    "IS" to "Islannda",
    "IT" to "Itali",
    "JM" to "Jamayka",
    "JO" to "Jordani",
    "JP" to "Sapoo",
    "KE" to "Keñaa",
    "KG" to "Kirgistaan",
    "KH" to "Kambodso",
    "KI" to "Kiribari",
    "KM" to "Komoor",
    "KN" to "Sent Kits e Newis",
    "KP" to "Koree Rewo",
    "KR" to "Koree Worgo",
    "KW" to "Kuweyti",
    "KY" to "Duuɗe Kaymaa",
    "KZ" to "Kasakstaan",
    "LA" to "Lawoos",
    "LB" to "Libaa",
    "LC" to "Sent Lusiyaa",
    "LI" to "Lincenstayn",
    "LK" to "Siri Lanka",
    "LR" to "Liberiyaa",
    "LS" to "Lesoto",
    "LT" to "Lituaanii",
    "LU" to "Liksembuur",
    "LV" to "Letonii",
    "LY" to "Libi",
    "MA" to "Maruk",
    "MC" to "Monaakoo",
    "MD" to "Moldawii",
    "MG" to "Madagaskaar",
    "MH" to "Duuɗe Marsaal",
    "ML" to "Maali",
    "MM" to "Miyamaar",
    "MN" to "Monngolii",
    "MP" to "Duuɗe Mariyaana Rewo",
    "MQ" to "Martinik",
    "MR" to "Muritani",
    "MS" to "Monseraat",
    "MT" to "Malte",
    "MU" to "Moriis",
    "MV" to "Maldiiwe",
    "MW" to "Malaawi",
    "MX" to "Meksik",
    "MY" to "Malesii",
    "MZ" to "Mosammbik",
    "NA" to "Namibii",
    "NC" to "Nuwel Kaledonii",
    "NE" to "Nijeer",
    "NF" to "Duuɗe Norfolk",
    "NG" to "Nijeriyaa",
    "NI" to "Nikaraguwaa",
    "NL" to "Nederlannda",
    "NO" to "Norwees",
    "NP" to "Nepaal",
    "NR" to "Nawuru",
    "NU" to "Niuwe",
    "NZ" to "Nuwel Selannda",
    "OM" to "Omaan",
    "PA" to "Panamaa",
    "PE" to "Peru",
    "PF" to "Polinesii Farayse",
    "PG" to "Papuwaa Nuwel Gine",
    "PH" to "Filipiin",
    "PK" to "Pakistaan",
    "PL" to "Poloñ",
    "PM" to "See Piyeer e Mikeloo",
    "PN" to "Pitkern",
    "PR" to "Porto Rikoo",
    "PS" to "Palestiin Sisjordani e Gaasaa",
    "PT" to "Purtugaal",
    "PW" to "Palawu",
    "PY" to "Paraguwaay",
    "QA" to "Kataar",
    "RE" to "Rewiñoo",
    "RO" to "Rumanii",
    "RU" to "Riisii",
    "RW" to "Ruwanndaa",
    "SA" to "Arabii Sawdit",
    "SB" to "Duuɗe Solomon",
    "SC" to "Seysel",
    "SD" to "Sudaan",
    "SE" to "Suweed",
    "SG" to "Sinngapuur",
    "SH" to "Sent Helen",
    "SI" to "Slowenii",
    "SK" to "Slowakii",
    "SL" to "Seraa liyon",
    "SM" to "See Maree",
    "SN" to "Senegaal",
    "SO" to "Somalii",
    "SR" to "Surinaam",
    "ST" to "Sawo Tome e Perensipe",
    "SV" to "El Salwador",
    "SY" to "Sirii",
    "SZ" to "Swaasilannda",
    "TC" to "Duuɗe Turke e Keikoos",
    "TD" to "Caad",
    "TG" to "Togoo",
    "TH" to "Taylannda",
    "TJ" to "Tajikistaan",
    "TK" to "Tokelaaw",
    "TL" to "Timoor Fuɗnaange",
    "TM" to "Turkmenistaan",
    "TN" to "Tunisii",
    "TO" to "Tonngaa",
    "TR" to "Turkii",
    "TT" to "Tirnidaad e Tobaago",
    "TV" to "Tuwaluu",
    "TW" to "Taywaan",
    "TZ" to "Tansanii",
    "UA" to "Ukereen",
    "UG" to "Unganndaa",
    "US" to "Dowlaaji Dentuɗi Amerik",
    "UY" to "Uruguwaay",
    "UZ" to "Usbekistaan",
    "VA" to "Dowla Waticaan",
    "VC" to "See Weesaa e Garnadiin",
    "VE" to "Wenesuwelaa",
    "VG" to "duuɗe kecce britanii",
    "VI" to "Duuɗe Kecce Amerik",
    "VN" to "Wiyetnaam",
    "VU" to "Wanuwaatuu",
    "WF" to "Walis e Futuna",
    "WS" to "Samowaa",
    "YE" to "Yemen",
    "YT" to "Mayoot",
    "ZA" to "Afrik bŋ Worgo",
    "ZM" to "Sammbi",
    "ZW" to "Simbaabuwe",
  ) }

  val ff_Latn_BF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_LR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_NG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_SL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fi: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "maailma",
    "002" to "Afrikka",
    "003" to "Pohjois-Amerikka",
    "005" to "Etelä-Amerikka",
    "009" to "Oseania",
    "011" to "Länsi-Afrikka",
    "013" to "Väli-Amerikka",
    "014" to "Itä-Afrikka",
    "015" to "Pohjois-Afrikka",
    "017" to "Keski-Afrikka",
    "018" to "eteläinen Afrikka",
    "019" to "Amerikka",
    "021" to "pohjoinen Amerikka",
    "029" to "Karibia",
    "030" to "Itä-Aasia",
    "034" to "Etelä-Aasia",
    "035" to "Kaakkois-Aasia",
    "039" to "Etelä-Eurooppa",
    "053" to "Australaasia",
    "054" to "Melanesia",
    "057" to "Mikronesian alue",
    "061" to "Polynesia",
    "142" to "Aasia",
    "143" to "Keski-Aasia",
    "145" to "Länsi-Aasia",
    "150" to "Eurooppa",
    "151" to "Itä-Eurooppa",
    "154" to "Pohjois-Eurooppa",
    "155" to "Länsi-Eurooppa",
    "202" to "Saharan eteläpuolinen Afrikka",
    "419" to "Latinalainen Amerikka",
    "AC" to "Ascension-saari",
    "AD" to "Andorra",
    "AE" to "Arabiemiirikunnat",
    "AF" to "Afganistan",
    "AG" to "Antigua ja Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarktis",
    "AR" to "Argentiina",
    "AS" to "Amerikan Samoa",
    "AT" to "Itävalta",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Ahvenanmaa",
    "AZ" to "Azerbaidžan",
    "BA" to "Bosnia ja Hertsegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgia",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint-Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Karibian Alankomaat",
    "BR" to "Brasilia",
    "BS" to "Bahama",
    "BT" to "Bhutan",
    "BV" to "Bouvet’nsaari",
    "BW" to "Botswana",
    "BY" to "Valko-Venäjä",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kookossaaret (Keelingsaaret)",
    "CD" to "Kongon demokraattinen tasavalta",
    "CF" to "Keski-Afrikan tasavalta",
    "CG" to "Kongon tasavalta",
    "CH" to "Sveitsi",
    "CI" to "Norsunluurannikko",
    "CK" to "Cookinsaaret",
    "CL" to "Chile",
    "CM" to "Kamerun",
    "CN" to "Kiina",
    "CO" to "Kolumbia",
    "CP" to "Clippertoninsaari",
    "CQ" to "Sark",
    "CR" to "Costa Rica",
    "CU" to "Kuuba",
    "CV" to "Kap Verde",
    "CW" to "Curaçao",
    "CX" to "Joulusaari",
    "CY" to "Kypros",
    "CZ" to "Tšekki",
    "DE" to "Saksa",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Tanska",
    "DM" to "Dominica",
    "DO" to "Dominikaaninen tasavalta",
    "DZ" to "Algeria",
    "EA" to "Ceuta ja Melilla",
    "EC" to "Ecuador",
    "EE" to "Viro",
    "EG" to "Egypti",
    "EH" to "Länsi-Sahara",
    "ER" to "Eritrea",
    "ES" to "Espanja",
    "ET" to "Etiopia",
    "EU" to "Euroopan unioni",
    "EZ" to "euroalue",
    "FI" to "Suomi",
    "FJ" to "Fidži",
    "FK" to "Falklandinsaaret",
    "FM" to "Mikronesia",
    "FO" to "Färsaaret",
    "FR" to "Ranska",
    "GA" to "Gabon",
    "GB" to "Iso-Britannia",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "Ranskan Guayana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Grönlanti",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Päiväntasaajan Guinea",
    "GR" to "Kreikka",
    "GS" to "Etelä-Georgia ja Eteläiset Sandwichinsaaret",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hongkong – Kiinan erityishallintoalue",
    "HM" to "Heard ja McDonaldinsaaret",
    "HN" to "Honduras",
    "HR" to "Kroatia",
    "HT" to "Haiti",
    "HU" to "Unkari",
    "IC" to "Kanariansaaret",
    "ID" to "Indonesia",
    "IE" to "Irlanti",
    "IL" to "Israel",
    "IM" to "Mansaari",
    "IN" to "Intia",
    "IO" to "Brittiläinen Intian valtameren alue",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Islanti",
    "IT" to "Italia",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Jordania",
    "JP" to "Japani",
    "KE" to "Kenia",
    "KG" to "Kirgisia",
    "KH" to "Kambodža",
    "KI" to "Kiribati",
    "KM" to "Komorit",
    "KN" to "Saint Kitts ja Nevis",
    "KP" to "Pohjois-Korea",
    "KR" to "Etelä-Korea",
    "KW" to "Kuwait",
    "KY" to "Caymansaaret",
    "KZ" to "Kazakstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Liettua",
    "LU" to "Luxemburg",
    "LV" to "Latvia",
    "LY" to "Libya",
    "MA" to "Marokko",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "Saint-Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshallinsaaret",
    "MK" to "Pohjois-Makedonia",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Macao – Kiinan erityishallintoalue",
    "MP" to "Pohjois-Mariaanit",
    "MQ" to "Martinique",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Malediivit",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malesia",
    "MZ" to "Mosambik",
    "NA" to "Namibia",
    "NC" to "Uusi-Kaledonia",
    "NE" to "Niger",
    "NF" to "Norfolkinsaari",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Alankomaat",
    "NO" to "Norja",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Uusi-Seelanti",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Ranskan Polynesia",
    "PG" to "Papua-Uusi-Guinea",
    "PH" to "Filippiinit",
    "PK" to "Pakistan",
    "PL" to "Puola",
    "PM" to "Saint-Pierre ja Miquelon",
    "PN" to "Pitcairn",
    "PR" to "Puerto Rico",
    "PS" to "Palestiinalaisalue",
    "PT" to "Portugali",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Oseanian erillissaaret",
    "RE" to "Réunion",
    "RO" to "Romania",
    "RS" to "Serbia",
    "RU" to "Venäjä",
    "RW" to "Ruanda",
    "SA" to "Saudi-Arabia",
    "SB" to "Salomonsaaret",
    "SC" to "Seychellit",
    "SD" to "Sudan",
    "SE" to "Ruotsi",
    "SG" to "Singapore",
    "SH" to "Saint Helena",
    "SI" to "Slovenia",
    "SJ" to "Huippuvuoret ja Jan Mayen",
    "SK" to "Slovakia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "Etelä-Sudan",
    "ST" to "São Tomé ja Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syyria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks- ja Caicossaaret",
    "TD" to "Tšad",
    "TF" to "Ranskan eteläiset ja antarktiset alueet",
    "TG" to "Togo",
    "TH" to "Thaimaa",
    "TJ" to "Tadžikistan",
    "TK" to "Tokelau",
    "TL" to "Itä-Timor",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turkki",
    "TT" to "Trinidad ja Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tansania",
    "UA" to "Ukraina",
    "UG" to "Uganda",
    "UM" to "Yhdysvaltain erillissaaret",
    "UN" to "Yhdistyneet kansakunnat",
    "US" to "Yhdysvallat",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Vatikaani",
    "VC" to "Saint Vincent ja Grenadiinit",
    "VE" to "Venezuela",
    "VG" to "Brittiläiset Neitsytsaaret",
    "VI" to "Yhdysvaltain Neitsytsaaret",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis ja Futuna",
    "WS" to "Samoa",
    "XA" to "pseudoaksentit",
    "XB" to "kaksisuuntainen pseudo",
    "XK" to "Kosovo",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Etelä-Afrikka",
    "ZM" to "Sambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "tuntematon alue",
  ) }

  val fil: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Mundo",
    "002" to "Africa",
    "003" to "Hilagang Amerika",
    "005" to "Timog Amerika",
    "009" to "Oceania",
    "011" to "Kanlurang Africa",
    "013" to "Gitnang Amerika",
    "014" to "Silangang Africa",
    "015" to "Hilagang Africa",
    "017" to "Gitnang Africa",
    "018" to "Katimugang Africa",
    "019" to "Americas",
    "021" to "Northern America",
    "029" to "Carribbean",
    "030" to "Silangang Asya",
    "034" to "Katimugang Asya",
    "035" to "Timog-Silangang Asya",
    "039" to "Katimugang Europe",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Rehiyon ng Micronesia",
    "061" to "Polynesia",
    "142" to "Asya",
    "143" to "Gitnang Asya",
    "145" to "Kanlurang Asya",
    "150" to "Europe",
    "151" to "Silangang Europe",
    "154" to "Hilagang Europe",
    "155" to "Kanlurang Europe",
    "202" to "Sub-Saharan Africa",
    "419" to "Latin America",
    "AC" to "Acsencion island",
    "AD" to "Andorra",
    "AE" to "United Arab Emirates",
    "AF" to "Afghanistan",
    "AG" to "Antigua & Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarctica",
    "AR" to "Argentina",
    "AS" to "American Samoa",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Åland Islands",
    "AZ" to "Azerbaijan",
    "BA" to "Bosnia and Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgium",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Caribbean Netherlands",
    "BR" to "Brazil",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Bouvet Island",
    "BW" to "Botswana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Cocos (Keeling) Islands",
    "CD" to "Congo - Kinshasa",
    "CF" to "Central African Republic",
    "CG" to "Congo - Brazzaville",
    "CH" to "Switzerland",
    "CI" to "Côte d’Ivoire",
    "CK" to "Cook Islands",
    "CL" to "Chile",
    "CM" to "Cameroon",
    "CN" to "China",
    "CO" to "Colombia",
    "CP" to "Clipperton Island",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cape Verde",
    "CW" to "Curaçao",
    "CX" to "Christmas Island",
    "CY" to "Cyprus",
    "CZ" to "Czechia",
    "DE" to "Germany",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Denmark",
    "DM" to "Dominica",
    "DO" to "Dominican Republic",
    "DZ" to "Algeria",
    "EA" to "Ceuta & Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egypt",
    "EH" to "Kanlurang Sahara",
    "ER" to "Eritrea",
    "ES" to "Spain",
    "ET" to "Ethiopia",
    "EU" to "European Union",
    "EZ" to "Eurozone",
    "FI" to "Finland",
    "FJ" to "Fiji",
    "FK" to "Falkland Islands",
    "FM" to "Micronesia",
    "FO" to "Faroe Islands",
    "FR" to "France",
    "GA" to "Gabon",
    "GB" to "United Kingdom",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "French Guiana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Greenland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Equatorial Guinea",
    "GR" to "Greece",
    "GS" to "South Georgia & South Sandwich Islands",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong SAR China",
    "HM" to "Heard & McDonald Islands",
    "HN" to "Honduras",
    "HR" to "Croatia",
    "HT" to "Haiti",
    "HU" to "Hungary",
    "IC" to "Canary Islands",
    "ID" to "Indonesia",
    "IE" to "Ireland",
    "IL" to "Israel",
    "IM" to "Isle of Man",
    "IN" to "India",
    "IO" to "British Indian Ocean Territory",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Iceland",
    "IT" to "Italy",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenya",
    "KG" to "Kyrgyzstan",
    "KH" to "Cambodia",
    "KI" to "Kiribati",
    "KM" to "Comoros",
    "KN" to "St. Kitts & Nevis",
    "KP" to "Hilagang Korea",
    "KR" to "Timog Korea",
    "KW" to "Kuwait",
    "KY" to "Cayman Islands",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Lebanon",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lithuania",
    "LU" to "Luxembourg",
    "LV" to "Latvia",
    "LY" to "Libya",
    "MA" to "Morocco",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "Saint Martin",
    "MG" to "Madagascar",
    "MH" to "Marshall Islands",
    "MK" to "North Macedonia",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Macau SAR China",
    "MP" to "Northern Mariana Islands",
    "MQ" to "Martinique",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldives",
    "MW" to "Malawi",
    "MX" to "Mexico",
    "MY" to "Malaysia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "New Caledonia",
    "NE" to "Niger",
    "NF" to "Norfolk Island",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Netherlands",
    "NO" to "Norway",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "New Zealand",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "French Polynesia",
    "PG" to "Papua New Guinea",
    "PH" to "Pilipinas",
    "PK" to "Pakistan",
    "PL" to "Poland",
    "PM" to "St. Pierre & Miquelon",
    "PN" to "Pitcairn Islands",
    "PR" to "Puerto Rico",
    "PS" to "Palestinian Territories",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Outlying Oceania",
    "RE" to "Réunion",
    "RO" to "Romania",
    "RS" to "Serbia",
    "RU" to "Russia",
    "RW" to "Rwanda",
    "SA" to "Saudi Arabia",
    "SB" to "Solomon Islands",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Sweden",
    "SG" to "Singapore",
    "SH" to "St. Helena",
    "SI" to "Slovenia",
    "SJ" to "Svalbard & Jan Mayen",
    "SK" to "Slovakia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "Timog Sudan",
    "ST" to "São Tomé & Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syria",
    "SZ" to "Swaziland",
    "TA" to "Tristan de Cunha",
    "TC" to "Turks & Caicos Islands",
    "TD" to "Chad",
    "TF" to "French Southern Territories",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tajikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Türkiye",
    "TT" to "Trinidad & Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraine",
    "UG" to "Uganda",
    "UM" to "U.S. Outlying Islands",
    "UN" to "United Nations",
    "US" to "Estados Unidos",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Vatican City",
    "VC" to "St. Vincent & Grenadines",
    "VE" to "Venezuela",
    "VG" to "British Virgin Islands",
    "VI" to "U.S. Virgin Islands",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis & Futuna",
    "WS" to "Samoa",
    "XA" to "Mga Pseudo-Accent",
    "XB" to "Pseudo-Bidi",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "South Africa",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Hindi Kilalang Rehiyon",
  ) }

  val fo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "heimur",
    "002" to "Afrika",
    "003" to "Norðuramerika",
    "005" to "Suðuramerika",
    "009" to "Osiania",
    "011" to "Vesturafrika",
    "013" to "Miðamerika",
    "014" to "Eysturafrika",
    "015" to "Norðurafrika",
    "017" to "Miðafrika",
    "018" to "sunnari partur av Afrika",
    "019" to "Amerika",
    "021" to "Amerika norðanfyri Meksiko",
    "029" to "Karibia",
    "030" to "Eysturasia",
    "034" to "Suðurasia",
    "035" to "Útsynningsasia",
    "039" to "Suðurevropa",
    "053" to "Avstralasia",
    "054" to "Melanesia",
    "057" to "Mikronesi øki",
    "061" to "Polynesia",
    "142" to "Asia",
    "143" to "Miðasia",
    "145" to "Vesturasia",
    "150" to "Evropa",
    "151" to "Eysturevropa",
    "154" to "Norðurevropa",
    "155" to "Vesturevropa",
    "202" to "Afrika sunnanfyri Sahara",
    "419" to "Latínamerika",
    "AC" to "Ascension",
    "AD" to "Andorra",
    "AE" to "Sameindu Emirríkini",
    "AF" to "Afganistan",
    "AG" to "Antigua & Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarktis",
    "AR" to "Argentina",
    "AS" to "Amerikanska Samoa",
    "AT" to "Eysturríki",
    "AU" to "Avstralia",
    "AW" to "Aruba",
    "AX" to "Áland",
    "AZ" to "Aserbadjan",
    "BA" to "Bosnia-Hersegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesj",
    "BE" to "Belgia",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Barein",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Niðurlonds Karibia",
    "BR" to "Brasil",
    "BS" to "Bahamaoyggjar",
    "BT" to "Butan",
    "BV" to "Bouvetoyggj",
    "BW" to "Botsvana",
    "BY" to "Hvítarussland",
    "BZ" to "Belis",
    "CA" to "Kanada",
    "CC" to "Kokosoyggjar",
    "CD" to "Kongo, Dem. Lýðveldið",
    "CF" to "Miðafrikalýðveldið",
    "CG" to "Kongo",
    "CH" to "Sveis",
    "CI" to "Fílabeinsstrondin",
    "CK" to "Cooksoyggjar",
    "CL" to "Kili",
    "CM" to "Kamerun",
    "CN" to "Kina",
    "CO" to "Kolombia",
    "CP" to "Clipperton",
    "CQ" to "Sark",
    "CR" to "Kosta Rika",
    "CU" to "Kuba",
    "CV" to "Grønhøvdaoyggjar",
    "CW" to "Curaçao",
    "CX" to "Jólaoyggjin",
    "CY" to "Kýpros",
    "CZ" to "Kekkia",
    "DE" to "Týskland",
    "DG" to "Diego Garcia",
    "DJ" to "Djibuti",
    "DK" to "Danmark",
    "DM" to "Dominika",
    "DO" to "Dominikalýðveldið",
    "DZ" to "Algeria",
    "EA" to "Ceuta & Melilla",
    "EC" to "Ekvador",
    "EE" to "Estland",
    "EG" to "Egyptaland",
    "EH" to "Vestursahara",
    "ER" to "Eritrea",
    "ES" to "Spania",
    "ET" to "Etiopia",
    "EU" to "Evropasamveldið",
    "EZ" to "Evrasona",
    "FI" to "Finnland",
    "FJ" to "Fiji",
    "FK" to "Falklandsoyggjar",
    "FM" to "Mikronesiasamveldið",
    "FO" to "Føroyar",
    "FR" to "Frakland",
    "GA" to "Gabon",
    "GB" to "Stórabretland",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "Franska Gujana",
    "GG" to "Guernsey",
    "GH" to "Gana",
    "GI" to "Gibraltar",
    "GL" to "Grønland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Ekvatorguinea",
    "GR" to "Grikkaland",
    "GS" to "Suðurgeorgia og Suðursandwichoyggjar",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Gujana",
    "HK" to "Hong Kong SAR Kina",
    "HM" to "Heard og McDonaldoyggjar",
    "HN" to "Honduras",
    "HR" to "Kroatia",
    "HT" to "Haiti",
    "HU" to "Ungarn",
    "IC" to "Kanariuoyggjar",
    "ID" to "Indonesia",
    "IE" to "Írland",
    "IL" to "Ísrael",
    "IM" to "Isle of Man",
    "IN" to "India",
    "IO" to "Stóra Bretlands Indiahavoyggjar",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Ísland",
    "IT" to "Italia",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenja",
    "KG" to "Kirgisia",
    "KH" to "Kambodja",
    "KI" to "Kiribati",
    "KM" to "Komoroyggjar",
    "KN" to "St. Kitts & Nevis",
    "KP" to "Norðurkorea",
    "KR" to "Suðurkorea",
    "KW" to "Kuvait",
    "KY" to "Caymanoyggjar",
    "KZ" to "Kasakstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "St. Lusia",
    "LI" to "Liktinstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesoto",
    "LT" to "Litava",
    "LU" to "Luksemborg",
    "LV" to "Lettland",
    "LY" to "Libya",
    "MA" to "Marokko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "St-Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshalloyggjar",
    "MK" to "Norður Makedónia",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Makao SAR Kina",
    "MP" to "Norðaru Mariuoyggjar",
    "MQ" to "Martinique",
    "MR" to "Móritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Móritius",
    "MV" to "Maldivoyggjar",
    "MW" to "Malavi",
    "MX" to "Meksiko",
    "MY" to "Malaisia",
    "MZ" to "Mosambik",
    "NA" to "Namibia",
    "NC" to "Nýkaledónia",
    "NE" to "Niger",
    "NF" to "Norfolksoyggj",
    "NG" to "Nigeria",
    "NI" to "Nikaragua",
    "NL" to "Niðurlond",
    "NO" to "Noreg",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nýsæland",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Franska Polynesia",
    "PG" to "Papua Nýguinea",
    "PH" to "Filipsoyggjar",
    "PK" to "Pakistan",
    "PL" to "Pólland",
    "PM" to "Saint Pierre & Miquelon",
    "PN" to "Pitcairnoyggjar",
    "PR" to "Puerto Riko",
    "PS" to "Palestinskt landøki",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguai",
    "QA" to "Katar",
    "QO" to "fjarskoti Osiania",
    "RE" to "Réunion",
    "RO" to "Rumenia",
    "RS" to "Serbia",
    "RU" to "Russland",
    "RW" to "Ruanda",
    "SA" to "Saudiarabia",
    "SB" to "Salomonoyggjar",
    "SC" to "Seyskelloyggjar",
    "SD" to "Sudan",
    "SE" to "Svøríki",
    "SG" to "Singapor",
    "SH" to "St. Helena",
    "SI" to "Slovenia",
    "SJ" to "Svalbard & Jan Mayen",
    "SK" to "Slovakia",
    "SL" to "Sierra Leona",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Surinam",
    "SS" to "Suðursudan",
    "ST" to "Sao Tome & Prinsipi",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Sýria",
    "SZ" to "Esvatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks- og Caicosoyggjar",
    "TD" to "Kjad",
    "TF" to "Fronsku sunnaru landaøki",
    "TG" to "Togo",
    "TH" to "Tailand",
    "TJ" to "Tadsjikistan",
    "TK" to "Tokelau",
    "TL" to "Eysturtimor",
    "TM" to "Turkmenistan",
    "TN" to "Tunesia",
    "TO" to "Tonga",
    "TR" to "Turkaland",
    "TT" to "Trinidad & Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taivan",
    "TZ" to "Tansania",
    "UA" to "Ukraina",
    "UG" to "Uganda",
    "UM" to "Sambandsríki Amerikas fjarskotnu oyggjar",
    "UN" to "Sameindu Tjóðir",
    "US" to "Sambandsríki Amerika",
    "UY" to "Uruguai",
    "UZ" to "Usbekistan",
    "VA" to "Vatikanbýur",
    "VC" to "St. Vinsent & Grenadinoyggjar",
    "VE" to "Venesuela",
    "VG" to "Stóra Bretlands Jomfrúoyggjar",
    "VI" to "Sambandsríki Amerikas Jomfrúoyggjar",
    "VN" to "Vjetnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis- og Futunaoyggjar",
    "WS" to "Samoa",
    "XA" to "óekta tónalag",
    "XB" to "óektaður BIDI tekstur",
    "XK" to "Kosovo",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Suðurafrika",
    "ZM" to "Sambia",
    "ZW" to "Simbabvi",
    "ZZ" to "ókent øki",
  ) }

  val fo_DK: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Monde",
    "002" to "Afrique",
    "003" to "Amérique du Nord",
    "005" to "Amérique du Sud",
    "009" to "Océanie",
    "011" to "Afrique occidentale",
    "013" to "Amérique centrale",
    "014" to "Afrique orientale",
    "015" to "Afrique septentrionale",
    "017" to "Afrique centrale",
    "018" to "Afrique australe",
    "019" to "Amériques",
    "021" to "Amérique septentrionale",
    "029" to "Caraïbes",
    "030" to "Asie de l’Est",
    "034" to "Asie du Sud",
    "035" to "Asie du Sud-Est",
    "039" to "Europe du Sud",
    "053" to "Australasie",
    "054" to "Mélanésie",
    "057" to "région micronésienne",
    "061" to "Polynésie",
    "142" to "Asie",
    "143" to "Asie centrale",
    "145" to "Asie de l’Ouest",
    "150" to "Europe",
    "151" to "Europe de l’Est",
    "154" to "Europe du Nord",
    "155" to "Europe de l’Ouest",
    "202" to "Afrique subsaharienne",
    "419" to "Amérique latine",
    "AC" to "Île de l’Ascension",
    "AD" to "Andorre",
    "AE" to "Émirats arabes unis",
    "AF" to "Afghanistan",
    "AG" to "Antigua-et-Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albanie",
    "AM" to "Arménie",
    "AO" to "Angola",
    "AQ" to "Antarctique",
    "AR" to "Argentine",
    "AS" to "Samoa américaines",
    "AT" to "Autriche",
    "AU" to "Australie",
    "AW" to "Aruba",
    "AX" to "Îles Åland",
    "AZ" to "Azerbaïdjan",
    "BA" to "Bosnie-Herzégovine",
    "BB" to "Barbade",
    "BD" to "Bangladesh",
    "BE" to "Belgique",
    "BF" to "Burkina Faso",
    "BG" to "Bulgarie",
    "BH" to "Bahreïn",
    "BI" to "Burundi",
    "BJ" to "Bénin",
    "BL" to "Saint-Barthélemy",
    "BM" to "Bermudes",
    "BN" to "Brunei",
    "BO" to "Bolivie",
    "BQ" to "Pays-Bas caribéens",
    "BR" to "Brésil",
    "BS" to "Bahamas",
    "BT" to "Bhoutan",
    "BV" to "Île Bouvet",
    "BW" to "Botswana",
    "BY" to "Biélorussie",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Îles Cocos",
    "CD" to "Congo-Kinshasa",
    "CF" to "République centrafricaine",
    "CG" to "Congo-Brazzaville",
    "CH" to "Suisse",
    "CI" to "Côte d’Ivoire",
    "CK" to "Îles Cook",
    "CL" to "Chili",
    "CM" to "Cameroun",
    "CN" to "Chine",
    "CO" to "Colombie",
    "CP" to "Île Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cap-Vert",
    "CW" to "Curaçao",
    "CX" to "Île Christmas",
    "CY" to "Chypre",
    "CZ" to "Tchéquie",
    "DE" to "Allemagne",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Danemark",
    "DM" to "Dominique",
    "DO" to "République dominicaine",
    "DZ" to "Algérie",
    "EA" to "Ceuta et Melilla",
    "EC" to "Équateur",
    "EE" to "Estonie",
    "EG" to "Égypte",
    "EH" to "Sahara occidental",
    "ER" to "Érythrée",
    "ES" to "Espagne",
    "ET" to "Éthiopie",
    "EU" to "Union européenne",
    "EZ" to "zone euro",
    "FI" to "Finlande",
    "FJ" to "Fidji",
    "FK" to "Îles Malouines",
    "FM" to "Micronésie",
    "FO" to "Îles Féroé",
    "FR" to "France",
    "GA" to "Gabon",
    "GB" to "Royaume-Uni",
    "GD" to "Grenade",
    "GE" to "Géorgie",
    "GF" to "Guyane française",
    "GG" to "Guernesey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Groenland",
    "GM" to "Gambie",
    "GN" to "Guinée",
    "GP" to "Guadeloupe",
    "GQ" to "Guinée équatoriale",
    "GR" to "Grèce",
    "GS" to "Géorgie du Sud-et-les Îles Sandwich du Sud",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinée-Bissau",
    "GY" to "Guyana",
    "HK" to "R.A.S. chinoise de Hong Kong",
    "HM" to "Îles Heard-et-MacDonald",
    "HN" to "Honduras",
    "HR" to "Croatie",
    "HT" to "Haïti",
    "HU" to "Hongrie",
    "IC" to "Îles Canaries",
    "ID" to "Indonésie",
    "IE" to "Irlande",
    "IL" to "Israël",
    "IM" to "Île de Man",
    "IN" to "Inde",
    "IO" to "Territoire britannique de l’océan Indien",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Islande",
    "IT" to "Italie",
    "JE" to "Jersey",
    "JM" to "Jamaïque",
    "JO" to "Jordanie",
    "JP" to "Japon",
    "KE" to "Kenya",
    "KG" to "Kirghizstan",
    "KH" to "Cambodge",
    "KI" to "Kiribati",
    "KM" to "Comores",
    "KN" to "Saint-Christophe-et-Niévès",
    "KP" to "Corée du Nord",
    "KR" to "Corée du Sud",
    "KW" to "Koweït",
    "KY" to "Îles Caïmans",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Liban",
    "LC" to "Sainte-Lucie",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lituanie",
    "LU" to "Luxembourg",
    "LV" to "Lettonie",
    "LY" to "Libye",
    "MA" to "Maroc",
    "MC" to "Monaco",
    "MD" to "Moldavie",
    "ME" to "Monténégro",
    "MF" to "Saint-Martin",
    "MG" to "Madagascar",
    "MH" to "Îles Marshall",
    "MK" to "Macédoine du Nord",
    "ML" to "Mali",
    "MM" to "Myanmar (Birmanie)",
    "MN" to "Mongolie",
    "MO" to "R.A.S. chinoise de Macao",
    "MP" to "Îles Mariannes du Nord",
    "MQ" to "Martinique",
    "MR" to "Mauritanie",
    "MS" to "Montserrat",
    "MT" to "Malte",
    "MU" to "Maurice",
    "MV" to "Maldives",
    "MW" to "Malawi",
    "MX" to "Mexique",
    "MY" to "Malaisie",
    "MZ" to "Mozambique",
    "NA" to "Namibie",
    "NC" to "Nouvelle-Calédonie",
    "NE" to "Niger",
    "NF" to "Île Norfolk",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Pays-Bas",
    "NO" to "Norvège",
    "NP" to "Népal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nouvelle-Zélande",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Pérou",
    "PF" to "Polynésie française",
    "PG" to "Papouasie-Nouvelle-Guinée",
    "PH" to "Philippines",
    "PK" to "Pakistan",
    "PL" to "Pologne",
    "PM" to "Saint-Pierre-et-Miquelon",
    "PN" to "Îles Pitcairn",
    "PR" to "Porto Rico",
    "PS" to "Territoires palestiniens",
    "PT" to "Portugal",
    "PW" to "Palaos",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "régions éloignées de l’Océanie",
    "RE" to "La Réunion",
    "RO" to "Roumanie",
    "RS" to "Serbie",
    "RU" to "Russie",
    "RW" to "Rwanda",
    "SA" to "Arabie saoudite",
    "SB" to "Îles Salomon",
    "SC" to "Seychelles",
    "SD" to "Soudan",
    "SE" to "Suède",
    "SG" to "Singapour",
    "SH" to "Sainte-Hélène",
    "SI" to "Slovénie",
    "SJ" to "Svalbard et Jan Mayen",
    "SK" to "Slovaquie",
    "SL" to "Sierra Leone",
    "SM" to "Saint-Marin",
    "SN" to "Sénégal",
    "SO" to "Somalie",
    "SR" to "Suriname",
    "SS" to "Soudan du Sud",
    "ST" to "Sao Tomé-et-Principe",
    "SV" to "Salvador",
    "SX" to "Saint-Martin (partie néerlandaise)",
    "SY" to "Syrie",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Îles Turques-et-Caïques",
    "TD" to "Tchad",
    "TF" to "Terres australes françaises",
    "TG" to "Togo",
    "TH" to "Thaïlande",
    "TJ" to "Tadjikistan",
    "TK" to "Tokelau",
    "TL" to "Timor oriental",
    "TM" to "Turkménistan",
    "TN" to "Tunisie",
    "TO" to "Tonga",
    "TR" to "Turquie",
    "TT" to "Trinité-et-Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taïwan",
    "TZ" to "Tanzanie",
    "UA" to "Ukraine",
    "UG" to "Ouganda",
    "UM" to "Îles mineures éloignées des États-Unis",
    "UN" to "Nations Unies",
    "US" to "États-Unis",
    "UY" to "Uruguay",
    "UZ" to "Ouzbékistan",
    "VA" to "État de la Cité du Vatican",
    "VC" to "Saint-Vincent-et-les Grenadines",
    "VE" to "Venezuela",
    "VG" to "Îles Vierges britanniques",
    "VI" to "Îles Vierges des États-Unis",
    "VN" to "Viêt Nam",
    "VU" to "Vanuatu",
    "WF" to "Wallis-et-Futuna",
    "WS" to "Samoa",
    "XA" to "pseudo-accents",
    "XB" to "pseudo-bidi",
    "XK" to "Kosovo",
    "YE" to "Yémen",
    "YT" to "Mayotte",
    "ZA" to "Afrique du Sud",
    "ZM" to "Zambie",
    "ZW" to "Zimbabwe",
    "ZZ" to "région indéterminée",
  ) }

  val fr_BE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "GS" to "Îles Géorgie du Sud et Sandwich du Sud",
  ) }

  val fr_BF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_BI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_BJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_BL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "030" to "Asie orientale",
    "039" to "Europe méridionale",
    "145" to "Asie occidentale",
    "151" to "Europe orientale",
    "154" to "Europe septentrionale",
    "155" to "Europe occidentale",
    "AC" to "île de l’Ascension",
    "AX" to "îles d’Åland",
    "BN" to "Brunéi",
    "BV" to "île Bouvet",
    "BY" to "Bélarus",
    "BZ" to "Bélize",
    "CC" to "îles Cocos (Keeling)",
    "CK" to "îles Cook",
    "CP" to "île Clipperton",
    "CX" to "île Christmas",
    "FK" to "îles Malouines",
    "FO" to "îles Féroé",
    "HM" to "îles Heard et McDonald",
    "IC" to "îles Canaries",
    "IM" to "île de Man",
    "KG" to "Kirghizistan",
    "KN" to "Saint‑Kitts‑et‑Nevis",
    "LR" to "Libéria",
    "MF" to "Saint-Martin (France)",
    "MM" to "Myanmar",
    "MP" to "Mariannes du Nord",
    "NF" to "île Norfolk",
    "NG" to "Nigéria",
    "PN" to "îles Pitcairn",
    "QO" to "Océanie lointaine",
    "RE" to "la Réunion",
    "SX" to "Saint-Martin (Pays-Bas)",
    "TL" to "Timor-Leste",
    "UM" to "îles mineures éloignées des États-Unis",
    "VA" to "Cité du Vatican",
    "VE" to "Vénézuéla",
    "VG" to "îles Vierges britanniques",
    "VI" to "îles Vierges américaines",
    "VN" to "Vietnam",
  ) }

  val fr_CD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_DJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_DZ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GP: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_HT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_KM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_LU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_ML: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_NC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_PF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_PM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_RE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_RW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_SC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_SN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_SY: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_TD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_TG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_TN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_VU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_WF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_YT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fur: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Mont",
    "002" to "Afriche",
    "003" to "Americhe dal Nord",
    "005" to "Americhe meridionâl",
    "009" to "Oceanie",
    "011" to "Afriche ocidentâl",
    "013" to "Americhe centrâl",
    "014" to "Afriche orientâl",
    "015" to "Afriche setentrionâl",
    "017" to "Afriche di mieç",
    "018" to "Afriche meridionâl",
    "019" to "Americhis",
    "021" to "Americhe setentrionâl",
    "029" to "caraibic",
    "030" to "Asie orientâl",
    "034" to "Asie meridionâl",
    "035" to "Asie sud orientâl",
    "039" to "Europe meridionâl",
    "053" to "Australie e Gnove Zelande",
    "054" to "Melanesie",
    "057" to "Regjon de Micronesie",
    "061" to "Polinesie",
    "142" to "Asie",
    "143" to "Asie centrâl",
    "145" to "Asie ocidentâl",
    "150" to "Europe",
    "151" to "Europe orientâl",
    "154" to "Europe setentrionâl",
    "155" to "Europe ocidentâl",
    "419" to "Americhe latine",
    "AD" to "Andorra",
    "AE" to "Emirâts araps unîts",
    "AF" to "Afghanistan",
    "AG" to "Antigua e Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albanie",
    "AM" to "Armenie",
    "AO" to "Angola",
    "AQ" to "Antartic",
    "AR" to "Argjentine",
    "AS" to "Samoa merecanis",
    "AT" to "Austrie",
    "AU" to "Australie",
    "AW" to "Aruba",
    "AX" to "Isulis Aland",
    "AZ" to "Azerbaigian",
    "BA" to "Bosnie e Ercegovine",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgjiche",
    "BF" to "Burkina Faso",
    "BG" to "Bulgarie",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Sant Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivie",
    "BR" to "Brasîl",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Isule Bouvet",
    "BW" to "Botswana",
    "BY" to "Bielorussie",
    "BZ" to "Belize",
    "CA" to "Canade",
    "CC" to "Isulis Cocos",
    "CD" to "Republiche Democratiche dal Congo",
    "CF" to "Republiche centri africane",
    "CG" to "Congo - Brazzaville",
    "CH" to "Svuizare",
    "CI" to "Cueste di Avoli",
    "CK" to "Isulis Cook",
    "CL" to "Cile",
    "CM" to "Camerun",
    "CN" to "Cine",
    "CO" to "Colombie",
    "CP" to "Isule Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cjâf vert",
    "CX" to "Isule Christmas",
    "CY" to "Cipri",
    "CZ" to "Republiche ceche",
    "DE" to "Gjermanie",
    "DG" to "Diego Garcia",
    "DJ" to "Gibuti",
    "DK" to "Danimarcje",
    "DM" to "Dominiche",
    "DO" to "Republiche dominicane",
    "DZ" to "Alzerie",
    "EA" to "Ceuta e Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonie",
    "EG" to "Egjit",
    "EH" to "Sahara ocidentâl",
    "ER" to "Eritree",
    "ES" to "Spagne",
    "ET" to "Etiopie",
    "EU" to "Union europeane",
    "FI" to "Finlandie",
    "FJ" to "Fizi",
    "FK" to "Isulis Falkland",
    "FM" to "Micronesie",
    "FO" to "Isulis Faroe",
    "FR" to "France",
    "GA" to "Gabon",
    "GB" to "Ream unît",
    "GD" to "Grenada",
    "GE" to "Gjeorgjie",
    "GF" to "Guiana francês",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gjibraltar",
    "GL" to "Groenlande",
    "GM" to "Gambia",
    "GN" to "Guinee",
    "GP" to "Guadalupe",
    "GQ" to "Guinee ecuatoriâl",
    "GR" to "Grecie",
    "GS" to "Georgia dal Sud e Isulis Sandwich dal Sud",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Regjon aministrative speciâl de Cine di Hong Kong",
    "HM" to "Isule Heard e Isulis McDonald",
    "HN" to "Honduras",
    "HR" to "Cravuazie",
    "HT" to "Haiti",
    "HU" to "Ongjarie",
    "IC" to "Isulis Canariis",
    "ID" to "Indonesie",
    "IE" to "Irlande",
    "IL" to "Israêl",
    "IM" to "Isule di Man",
    "IN" to "India",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Islande",
    "IT" to "Italie",
    "JE" to "Jersey",
    "JM" to "Gjamaiche",
    "JO" to "Jordanie",
    "JP" to "Gjapon",
    "KE" to "Kenya",
    "KG" to "Kirghizstan",
    "KH" to "Camboze",
    "KI" to "Kiribati",
    "KM" to "Comoris",
    "KN" to "San Kitts e Nevis",
    "KP" to "Coree dal nord",
    "KR" to "Coree dal sud",
    "KW" to "Kuwait",
    "KY" to "Isulis Cayman",
    "KZ" to "Kazachistan",
    "LA" to "Laos",
    "LB" to "Liban",
    "LC" to "Sante Lusie",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberie",
    "LS" to "Lesotho",
    "LT" to "Lituanie",
    "LU" to "Lussemburc",
    "LV" to "Letonie",
    "LY" to "Libie",
    "MA" to "Maroc",
    "MC" to "Monaco",
    "MD" to "Moldavie",
    "ME" to "Montenegro",
    "MF" to "Sant Martin",
    "MG" to "Madagascar",
    "MH" to "Isulis Marshall",
    "ML" to "Mali",
    "MM" to "Birmanie",
    "MN" to "Mongolie",
    "MO" to "Regjon aministrative speciâl de Cine di Macao",
    "MP" to "Isulis Mariana dal Nord",
    "MQ" to "Martiniche",
    "MR" to "Mauritanie",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Maurizi",
    "MV" to "Maldivis",
    "MW" to "Malawi",
    "MX" to "Messic",
    "MY" to "Malaysia",
    "MZ" to "Mozambic",
    "NA" to "Namibie",
    "NC" to "Gnove Caledonie",
    "NE" to "Niger",
    "NF" to "Isole Norfolk",
    "NG" to "Nigerie",
    "NI" to "Nicaragua",
    "NL" to "Paîs bas",
    "NO" to "Norvegje",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Gnove Zelande",
    "OM" to "Oman",
    "PA" to "Panamà",
    "PE" to "Perù",
    "PF" to "Polinesie francês",
    "PG" to "Papue Gnove Guinee",
    "PH" to "Filipinis",
    "PK" to "Pakistan",
    "PL" to "Polonie",
    "PM" to "San Pierre e Miquelon",
    "PN" to "Pitcairn",
    "PR" to "Porto Rico",
    "PS" to "Teritoris palestinês",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Oceanie periferiche",
    "RE" to "Reunion",
    "RO" to "Romanie",
    "RS" to "Serbie",
    "RU" to "Russie",
    "RW" to "Ruande",
    "SA" to "Arabie Saudide",
    "SB" to "Isulis Salomon",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Svezie",
    "SG" to "Singapore",
    "SH" to "Sante Eline",
    "SI" to "Slovenie",
    "SJ" to "Svalbard e Jan Mayen",
    "SK" to "Slovachie",
    "SL" to "Sierra Leone",
    "SM" to "San Marin",
    "SN" to "Senegal",
    "SO" to "Somalie",
    "SR" to "Suriname",
    "ST" to "Sao Tomè e Principe",
    "SV" to "El Salvador",
    "SY" to "Sirie",
    "SZ" to "Swaziland",
    "TA" to "Tristan da Cunha",
    "TC" to "Isulis Turks e Caicos",
    "TD" to "Çad",
    "TF" to "Teritoris meridionâi francês",
    "TG" to "Togo",
    "TH" to "Tailandie",
    "TJ" to "Tazikistan",
    "TK" to "Tokelau",
    "TL" to "Timor orientâl",
    "TM" to "Turkmenistan",
    "TN" to "Tunisie",
    "TO" to "Tonga",
    "TR" to "Turchie",
    "TT" to "Trinidad e Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzanie",
    "UA" to "Ucraine",
    "UG" to "Uganda",
    "UM" to "Isulis periferichis minôrs dai Stâts Unîts",
    "US" to "Stâts Unîts",
    "UY" to "Uruguay",
    "UZ" to "Uzbechistan",
    "VA" to "Vatican",
    "VC" to "San Vincent e lis Grenadinis",
    "VE" to "Venezuela",
    "VG" to "Isulis vergjinis britanichis",
    "VI" to "Isulis vergjinis americanis",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis e Futuna",
    "WS" to "Samoa",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "Sud Afriche",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Regjon no cognossude o no valide",
  ) }

  val fy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Wrâld",
    "002" to "Afrika",
    "003" to "Noard-Amerika",
    "005" to "Sûd-Amerika",
    "009" to "Oceanië",
    "011" to "West-Afrika",
    "013" to "Midden-Amerika",
    "014" to "East-Afrika",
    "015" to "Noard-Afrika",
    "017" to "Sintraal-Afrika",
    "018" to "Sûdelijk Afrika",
    "019" to "Amerika",
    "021" to "Noardlik Amerika",
    "029" to "Karibysk gebiet",
    "030" to "East-Azië",
    "034" to "Sûd-Azië",
    "035" to "Sûdoost-Azië",
    "039" to "Sûd-Europa",
    "053" to "Australazië",
    "054" to "Melanesië",
    "057" to "Micronesyske regio",
    "061" to "Polynesië",
    "142" to "Azië",
    "143" to "Sintraal-Azië",
    "145" to "West-Azië",
    "150" to "Europa",
    "151" to "East-Europa",
    "154" to "Noard-Europa",
    "155" to "West-Europa",
    "419" to "Latynsk-Amearika",
    "AC" to "Ascension",
    "AD" to "Andorra",
    "AE" to "Verenigde Arabyske Emiraten",
    "AF" to "Afghanistan",
    "AG" to "Antigua en Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albanië",
    "AM" to "Armenië",
    "AO" to "Angola",
    "AQ" to "Antarctica",
    "AR" to "Argentinië",
    "AS" to "Amerikaansk Samoa",
    "AT" to "Eastenryk",
    "AU" to "Australië",
    "AW" to "Aruba",
    "AX" to "Ålân",
    "AZ" to "Azerbeidzjan",
    "BA" to "Bosnië en Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "België",
    "BF" to "Burkina Faso",
    "BG" to "Bulgarije",
    "BH" to "Bahrein",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Karibysk Nederlân",
    "BR" to "Brazilië",
    "BS" to "Bahama’s",
    "BT" to "Bhutan",
    "BV" to "Bouveteilân",
    "BW" to "Botswana",
    "BY" to "Wit-Ruslân",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Kokosilanen",
    "CD" to "Congo-Kinshasa",
    "CF" to "Sintraal-Afrikaanske Republyk",
    "CG" to "Congo-Brazzaville",
    "CH" to "Switserlân",
    "CI" to "Ivoorkust",
    "CK" to "Cookeilannen",
    "CL" to "Chili",
    "CM" to "Kameroen",
    "CN" to "Sina",
    "CO" to "Kolombia",
    "CP" to "Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Kuba",
    "CV" to "Kaapverdië",
    "CW" to "Curaçao",
    "CX" to "Krysteilan",
    "CY" to "Syprus",
    "CZ" to "Tsjechje",
    "DE" to "Dútslân",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Denemarken",
    "DM" to "Dominika",
    "DO" to "Dominikaanske Republyk",
    "DZ" to "Algerije",
    "EA" to "Ceuta en Melilla",
    "EC" to "Ecuador",
    "EE" to "Estlân",
    "EG" to "Egypte",
    "EH" to "Westelijke Sahara",
    "ER" to "Eritrea",
    "ES" to "Spanje",
    "ET" to "Ethiopië",
    "EU" to "Europeeske Unie",
    "FI" to "Finlân",
    "FJ" to "Fiji",
    "FK" to "Falklâneilannen",
    "FM" to "Micronesië",
    "FO" to "Faeröer",
    "FR" to "Frankrijk",
    "GA" to "Gabon",
    "GB" to "Verenigd Koninkrijk",
    "GD" to "Grenada",
    "GE" to "Georgië",
    "GF" to "Frans-Guyana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Grienlân",
    "GM" to "Gambia",
    "GN" to "Guinee",
    "GP" to "Guadeloupe",
    "GQ" to "Equatoriaal-Guinea",
    "GR" to "Grikelân",
    "GS" to "Sûd-Georgia en Sûdlike Sandwicheilannen",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinee-Bissau",
    "GY" to "Guyana",
    "HK" to "Hongkong SAR van Sina",
    "HM" to "Heard- en McDonaldeilannen",
    "HN" to "Honduras",
    "HR" to "Kroatië",
    "HT" to "Haïti",
    "HU" to "Hongarije",
    "IC" to "Kanaryske Eilânnen",
    "ID" to "Yndonesië",
    "IE" to "Ierlân",
    "IL" to "Israël",
    "IM" to "Isle of Man",
    "IN" to "India",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Yslân",
    "IT" to "Italië",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordanië",
    "JP" to "Japan",
    "KE" to "Kenia",
    "KG" to "Kirgizië",
    "KH" to "Cambodja",
    "KI" to "Kiribati",
    "KM" to "Comoren",
    "KN" to "Saint Kitts en Nevis",
    "KP" to "Noard-Korea",
    "KR" to "Sûd-Korea",
    "KW" to "Koeweit",
    "KY" to "Caymaneilannen",
    "KZ" to "Kazachstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Litouwen",
    "LU" to "Luxemburg",
    "LV" to "Letlân",
    "LY" to "Libië",
    "MA" to "Marokko",
    "MC" to "Monaco",
    "MD" to "Moldavië",
    "ME" to "Montenegro",
    "MF" to "Saint-Martin",
    "MG" to "Madeiaskar",
    "MH" to "Marshalleilannen",
    "ML" to "Mali",
    "MM" to "Myanmar (Birma)",
    "MN" to "Mongolië",
    "MO" to "Macao SAR van Sina",
    "MP" to "Noardlike Marianeneilannen",
    "MQ" to "Martinique",
    "MR" to "Mauritanië",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldiven",
    "MW" to "Malawi",
    "MX" to "Mexico",
    "MY" to "Maleisië",
    "MZ" to "Mozambique",
    "NA" to "Namibië",
    "NC" to "Nij-Caledonië",
    "NE" to "Niger",
    "NF" to "Norfolkeilân",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Nederlân",
    "NO" to "Noarwegen",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nij-Seelân",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Frans-Polynesië",
    "PG" to "Papoea-Nij-Guinea",
    "PH" to "Filipijnen",
    "PK" to "Pakistan",
    "PL" to "Polen",
    "PM" to "Saint-Pierre en Miquelon",
    "PN" to "Pitcairneilannen",
    "PR" to "Puerto Rico",
    "PS" to "Palestynske gebieten",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Oerig Oceanië",
    "RE" to "Réunion",
    "RO" to "Roemenië",
    "RS" to "Servië",
    "RU" to "Ruslân",
    "RW" to "Rwanda",
    "SA" to "Saoedi-Arabië",
    "SB" to "Salomonseilannen",
    "SC" to "Seychellen",
    "SD" to "Soedan",
    "SE" to "Zweden",
    "SG" to "Singapore",
    "SH" to "Sint-Helena",
    "SI" to "Slovenië",
    "SJ" to "Spitsbergen en Jan Mayen",
    "SK" to "Slowakije",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalië",
    "SR" to "Suriname",
    "SS" to "Sûd-Soedan",
    "ST" to "Sao Tomé en Principe",
    "SV" to "El Salvador",
    "SX" to "Sint-Maarten",
    "SY" to "Syrië",
    "SZ" to "Swazilân",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks- en Caicoseilannen",
    "TD" to "Tsjaad",
    "TF" to "Franse Gebieden in de zuidelijke Indyske Oseaan",
    "TG" to "Togo",
    "TH" to "Thailân",
    "TJ" to "Tadzjikistan",
    "TK" to "Tokelau",
    "TL" to "East-Timor",
    "TM" to "Turkmenistan",
    "TN" to "Tunesië",
    "TO" to "Tonga",
    "TR" to "Turkije",
    "TT" to "Trinidad en Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Oekraïne",
    "UG" to "Oeganda",
    "UM" to "Lyts ôflizzen eilannen fan de Ferienigde Staten",
    "US" to "Ferienigde Staten",
    "UY" to "Uruguay",
    "UZ" to "Oezbekistan",
    "VA" to "Vaticaanstêd",
    "VC" to "Saint Vincent en de Grenadines",
    "VE" to "Venezuela",
    "VG" to "Britse Maagdeneilannen",
    "VI" to "Amerikaanske Maagdeneilannen",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis en Futuna",
    "WS" to "Samoa",
    "XK" to "Kosovo",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Sûd-Afrika",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Unbekend gebiet",
  ) }

  val ga: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "an Domhan",
    "002" to "an Afraic",
    "003" to "Meiriceá Thuaidh",
    "005" to "Meiriceá Theas",
    "009" to "an Aigéine",
    "011" to "Iarthar na hAfraice",
    "013" to "Meiriceá Láir",
    "014" to "Oirthear na hAfraice",
    "015" to "Tuaisceart na hAfraice",
    "017" to "an Afraic Láir",
    "018" to "Deisceart na hAfraice",
    "019" to "Críocha Mheiriceá",
    "021" to "Tuaisceart Mheiriceá",
    "029" to "an Mhuir Chairib",
    "030" to "Oirthear na hÁise",
    "034" to "Deisceart na hÁise",
    "035" to "an Áise Thoir Theas",
    "039" to "Deisceart na hEorpa",
    "053" to "an Astraláise",
    "054" to "an Mheilinéis",
    "057" to "an Réigiún Micrinéiseach",
    "061" to "an Pholainéis",
    "142" to "an Áise",
    "143" to "an Áise Láir",
    "145" to "Iarthar na hÁise",
    "150" to "an Eoraip",
    "151" to "Oirthear na hEorpa",
    "154" to "Tuaisceart na hEorpa",
    "155" to "Iarthar na hEorpa",
    "202" to "an Afraic fho-Shahárach",
    "419" to "Meiriceá Laidineach",
    "AC" to "Oileán na Deascabhála",
    "AD" to "Andóra",
    "AE" to "Aontas na nÉimíríochtaí Arabacha",
    "AF" to "an Afganastáin",
    "AG" to "Antigua agus Barbúda",
    "AI" to "Angaíle",
    "AL" to "an Albáin",
    "AM" to "an Airméin",
    "AO" to "Angóla",
    "AQ" to "Antartaice",
    "AR" to "an Airgintín",
    "AS" to "Samó Mheiriceá",
    "AT" to "an Ostair",
    "AU" to "an Astráil",
    "AW" to "Arúba",
    "AX" to "Oileáin Åland",
    "AZ" to "an Asarbaiseáin",
    "BA" to "an Bhoisnia agus an Heirseagaivéin",
    "BB" to "Barbadós",
    "BD" to "an Bhanglaidéis",
    "BE" to "an Bheilg",
    "BF" to "Buircíne Fasó",
    "BG" to "an Bhulgáir",
    "BH" to "Bairéin",
    "BI" to "an Bhurúin",
    "BJ" to "Beinin",
    "BL" to "Saint Barthélemy",
    "BM" to "Beirmiúda",
    "BN" to "Brúiné",
    "BO" to "an Bholaiv",
    "BQ" to "an Ísiltír Chairibeach",
    "BR" to "an Bhrasaíl",
    "BS" to "na Bahámaí",
    "BT" to "an Bhútáin",
    "BV" to "Oileán Bouvet",
    "BW" to "an Bhotsuáin",
    "BY" to "an Bhealarúis",
    "BZ" to "an Bheilís",
    "CA" to "Ceanada",
    "CC" to "Oileáin Cocos (Keeling)",
    "CD" to "Poblacht Dhaonlathach an Chongó",
    "CF" to "Poblacht na hAfraice Láir",
    "CG" to "Congó-Brazzaville",
    "CH" to "an Eilvéis",
    "CI" to "An Cósta Eabhair",
    "CK" to "Oileáin Cook",
    "CL" to "an tSile",
    "CM" to "Camarún",
    "CN" to "an tSín",
    "CO" to "an Cholóim",
    "CP" to "Oileán Clipperton",
    "CR" to "Cósta Ríce",
    "CU" to "Cúba",
    "CV" to "Rinn Verde",
    "CW" to "Cúrasó",
    "CX" to "Oileán na Nollag",
    "CY" to "an Chipir",
    "CZ" to "an tSeicia",
    "DE" to "an Ghearmáin",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "an Danmhairg",
    "DM" to "Doiminice",
    "DO" to "an Phoblacht Dhoiminiceach",
    "DZ" to "An Ailgéir",
    "EA" to "Ceuta agus Melilla",
    "EC" to "Eacuadór",
    "EE" to "an Eastóin",
    "EG" to "An Éigipt",
    "EH" to "An Sahára Thiar",
    "ER" to "an Eiritré",
    "ES" to "an Spáinn",
    "ET" to "an Aetóip",
    "EU" to "an tAontas Eorpach",
    "EZ" to "Limistéar an euro",
    "FI" to "an Fhionlainn",
    "FJ" to "Fidsí",
    "FK" to "Oileáin Fháclainne",
    "FM" to "an Mhicrinéis",
    "FO" to "Oileáin Fharó",
    "FR" to "an Fhrainc",
    "GA" to "an Ghabúin",
    "GB" to "an Ríocht Aontaithe",
    "GD" to "Greanáda",
    "GE" to "an tSeoirsia",
    "GF" to "Guáin na Fraince",
    "GG" to "Geansaí",
    "GH" to "Gána",
    "GI" to "Giobráltar",
    "GL" to "an Ghraonlainn",
    "GM" to "An Ghaimbia",
    "GN" to "An Ghuine",
    "GP" to "Guadalúip",
    "GQ" to "an Ghuine Mheánchiorclach",
    "GR" to "an Ghréig",
    "GS" to "An tSeoirsia Theas agus Oileáin Sandwich Theas",
    "GT" to "Guatamala",
    "GU" to "Guam",
    "GW" to "Guine Bissau",
    "GY" to "An Ghuáin",
    "HK" to "Sainréigiún Riaracháin Hong Cong, Daonphoblacht na Síne",
    "HM" to "Oileán Heard agus Oileáin McDonald",
    "HN" to "Hondúras",
    "HR" to "an Chróit",
    "HT" to "Háítí",
    "HU" to "an Ungáir",
    "IC" to "Na hOileáin Chanáracha",
    "ID" to "an Indinéis",
    "IE" to "Éire",
    "IL" to "Iosrael",
    "IM" to "Oileán Mhanann",
    "IN" to "an India",
    "IO" to "Críoch Aigéan Indiach na Breataine",
    "IQ" to "an Iaráic",
    "IR" to "an Iaráin",
    "IS" to "an Íoslainn",
    "IT" to "an Iodáil",
    "JE" to "Geirsí",
    "JM" to "Iamáice",
    "JO" to "an Iordáin",
    "JP" to "an tSeapáin",
    "KE" to "an Chéinia",
    "KG" to "an Chirgeastáin",
    "KH" to "an Chambóid",
    "KI" to "Ciribeas",
    "KM" to "Oileáin Chomóra",
    "KN" to "San Críostóir-Nimheas",
    "KP" to "an Chóiré Thuaidh",
    "KR" to "an Chóiré Theas",
    "KW" to "Cuáit",
    "KY" to "Oileáin Cayman",
    "KZ" to "an Chasacstáin",
    "LA" to "Laos",
    "LB" to "an Liobáin",
    "LC" to "Saint Lucia",
    "LI" to "Lichtinstéin",
    "LK" to "Srí Lanca",
    "LR" to "An Libéir",
    "LS" to "Leosóta",
    "LT" to "an Liotuáin",
    "LU" to "Lucsamburg",
    "LV" to "an Laitvia",
    "LY" to "An Libia",
    "MA" to "Maracó",
    "MC" to "Monacó",
    "MD" to "an Mholdóiv",
    "ME" to "Montainéagró",
    "MF" to "Saint-Martin",
    "MG" to "Madagascar",
    "MH" to "Oileáin Marshall",
    "MK" to "an Mhacadóin Thuaidh",
    "ML" to "Mailí",
    "MM" to "Maenmar (Burma)",
    "MN" to "an Mhongóil",
    "MO" to "Sainréigiún Riaracháin Macao, Daonphoblacht na Síne",
    "MP" to "Na hOileáin Mháirianacha Thuaidh",
    "MQ" to "Martinique",
    "MR" to "An Mháratái",
    "MS" to "Montsarat",
    "MT" to "Málta",
    "MU" to "Oileán Mhuirís",
    "MV" to "Oileáin Mhaildíve",
    "MW" to "an Mhaláiv",
    "MX" to "Meicsiceo",
    "MY" to "an Mhalaeisia",
    "MZ" to "Mósaimbíc",
    "NA" to "an Namaib",
    "NC" to "an Nua-Chaladóin",
    "NE" to "An Nígir",
    "NF" to "Oileán Norfolk",
    "NG" to "An Nigéir",
    "NI" to "Nicearagua",
    "NL" to "an Ísiltír",
    "NO" to "an Iorua",
    "NP" to "Neipeal",
    "NR" to "Nárú",
    "NU" to "Niue",
    "NZ" to "an Nua-Shéalainn",
    "OM" to "Óman",
    "PA" to "Panama",
    "PE" to "Peiriú",
    "PF" to "Polainéis na Fraince",
    "PG" to "Nua-Ghuine Phapua",
    "PH" to "Na hOileáin Fhilipíneacha",
    "PK" to "an Phacastáin",
    "PL" to "an Pholainn",
    "PM" to "San Pierre agus Miquelon",
    "PN" to "Oileáin Pitcairn",
    "PR" to "Pórtó Ríce",
    "PS" to "na Críocha Palaistíneacha",
    "PT" to "an Phortaingéil",
    "PW" to "Oileáin Palau",
    "PY" to "Paragua",
    "QA" to "Catar",
    "QO" to "an Aigéine Imeallach",
    "RE" to "La Réunion",
    "RO" to "an Rómáin",
    "RS" to "an tSeirbia",
    "RU" to "an Rúis",
    "RW" to "Ruanda",
    "SA" to "an Araib Shádach",
    "SB" to "Oileáin Sholaimh",
    "SC" to "na Séiséil",
    "SD" to "An tSúdáin",
    "SE" to "an tSualainn",
    "SG" to "Singeapór",
    "SH" to "San Héilin",
    "SI" to "an tSlóivéin",
    "SJ" to "Svalbard agus Jan Mayen",
    "SK" to "an tSlóvaic",
    "SL" to "Siarra Leon",
    "SM" to "San Mairíne",
    "SN" to "An tSeineagáil",
    "SO" to "an tSomáil",
    "SR" to "Suranam",
    "SS" to "an tSúdáin Theas",
    "ST" to "São Tomé agus Príncipe",
    "SV" to "An tSalvadóir",
    "SX" to "Sint Maarten",
    "SY" to "an tSiria",
    "SZ" to "eSuaitíní",
    "TA" to "Tristan da Cunha",
    "TC" to "Oileáin na dTurcach agus Caicos",
    "TD" to "Sead",
    "TF" to "Críocha Francacha Dheisceart an Domhain",
    "TG" to "Tóga",
    "TH" to "an Téalainn",
    "TJ" to "an Táidsíceastáin",
    "TK" to "Tócalá",
    "TL" to "Tíomór Thoir",
    "TM" to "an Tuircméanastáin",
    "TN" to "An Tuinéis",
    "TO" to "Tonga",
    "TR" to "an Tuirc",
    "TT" to "Oileán na Tríonóide agus Tobága",
    "TV" to "Túvalú",
    "TW" to "an Téaváin",
    "TZ" to "an Tansáin",
    "UA" to "an Úcráin",
    "UG" to "Uganda",
    "UM" to "Oileáin Imeallacha S.A.M.",
    "UN" to "na Náisiúin Aontaithe",
    "US" to "Stáit Aontaithe Mheiriceá",
    "UY" to "Uragua",
    "UZ" to "an Úisbéiceastáin",
    "VA" to "Cathair na Vatacáine",
    "VC" to "San Uinseann agus na Greanáidíní",
    "VE" to "Veiniséala",
    "VG" to "Oileáin Bhriotanacha na Maighdean",
    "VI" to "Oileáin Mheiriceánacha na Maighdean",
    "VN" to "Vítneam",
    "VU" to "Vanuatú",
    "WF" to "Vailís agus Futúna",
    "WS" to "Samó",
    "XA" to "Bréagaicinn",
    "XB" to "Bréag-Bidi",
    "XK" to "an Chosaiv",
    "YE" to "Éimin",
    "YT" to "Mayotte",
    "ZA" to "an Afraic Theas",
    "ZM" to "an tSaimbia",
    "ZW" to "an tSiombáib",
    "ZZ" to "Réigiún Anaithnid",
  ) }

  val ga_GB: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gaa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "GH" to "Ghana",
  ) }

  val gd: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "An Saoghal",
    "002" to "Afraga",
    "003" to "Aimeireaga a Tuath",
    "005" to "Aimeireaga a Deas",
    "009" to "Roinn a’ Chuain Sèimh",
    "011" to "Afraga an Iar",
    "013" to "Meadhan Aimeireaga",
    "014" to "Afraga an Ear",
    "015" to "Afraga a Tuath",
    "017" to "Meadhan Afraga",
    "018" to "Ceann a Deas Afraga",
    "019" to "An Dà Aimeireaga",
    "021" to "Ceann a Tuath Aimeireaga",
    "029" to "Am Muir Caraibeach",
    "030" to "Àisia an Ear",
    "034" to "Àisia a Deas",
    "035" to "Àisia an Ear-dheas",
    "039" to "An Roinn-Eòrpa a Deas",
    "053" to "Astràilia is Sealainn Nuadh",
    "054" to "Na h-Eileanan Dubha",
    "057" to "Roinn nam Meanbh-Eileanan",
    "061" to "Poilinèis",
    "142" to "Àisia",
    "143" to "Meadhan Àisia",
    "145" to "Àisia an Iar",
    "150" to "An Roinn-Eòrpa",
    "151" to "An Roinn-Eòrpa an Ear",
    "154" to "An Roinn-Eòrpa a Tuath",
    "155" to "An Roinn-Eòrpa an Iar",
    "202" to "Afraga Deas air an t-Sathara",
    "419" to "Aimeireaga Laidinneach",
    "AC" to "Eilean na Deasgabhalach",
    "AD" to "Andorra",
    "AE" to "Na h-Iomaratan Arabach Aonaichte",
    "AF" to "Afghanastàn",
    "AG" to "Aintìoga is Barbuda",
    "AI" to "Anguillia",
    "AL" to "Albàinia",
    "AM" to "Airmeinea",
    "AO" to "Angòla",
    "AQ" to "An Antartaig",
    "AR" to "An Argantain",
    "AS" to "Samotha na h-Aimeireaga",
    "AT" to "An Ostair",
    "AU" to "Astràilia",
    "AW" to "Arùba",
    "AX" to "Na h-Eileanan Åland",
    "AZ" to "Asarbaideàn",
    "BA" to "Bosna is Hearsagobhana",
    "BB" to "Barbados",
    "BD" to "Bangladais",
    "BE" to "A’ Bheilg",
    "BF" to "Buirciona Faso",
    "BG" to "A’ Bhulgair",
    "BH" to "Bachrain",
    "BI" to "Burundaidh",
    "BJ" to "Beinin",
    "BL" to "Saint Barthélemy",
    "BM" to "Bearmùda",
    "BN" to "Brùnaigh",
    "BO" to "Boilibhia",
    "BQ" to "Na Tìrean Ìsle Caraibeach",
    "BR" to "Braisil",
    "BS" to "Na h-Eileanan Bhathama",
    "BT" to "Butàn",
    "BV" to "Eilean Bouvet",
    "BW" to "Botsuana",
    "BY" to "A’ Bhealaruis",
    "BZ" to "A’ Bheilìs",
    "CA" to "Canada",
    "CC" to "Na h-Eileanan Chocos (Keeling)",
    "CD" to "Congo - Kinshasa",
    "CF" to "Poblachd Meadhan Afraga",
    "CG" to "A’ Chongo - Brazzaville",
    "CH" to "An Eilbheis",
    "CI" to "Côte d’Ivoire",
    "CK" to "Eileanan Cook",
    "CL" to "An t-Sile",
    "CM" to "Camarun",
    "CN" to "An t-Sìn",
    "CO" to "Coloimbia",
    "CP" to "Eilean Clipperton",
    "CQ" to "Sarc",
    "CR" to "Costa Rìcea",
    "CU" to "Cùba",
    "CV" to "An Ceap Uaine",
    "CW" to "Curaçao",
    "CX" to "Eilean na Nollaig",
    "CY" to "Cìopras",
    "CZ" to "An t-Seic",
    "DE" to "A’ Ghearmailt",
    "DG" to "Diego Garcia",
    "DJ" to "Diobùtaidh",
    "DK" to "An Danmhairg",
    "DM" to "Doiminicea",
    "DO" to "A’ Phoblachd Dhoiminiceach",
    "DZ" to "Aildiria",
    "EA" to "Ceuta agus Melilla",
    "EC" to "Eacuador",
    "EE" to "An Eastoin",
    "EG" to "An Èipheit",
    "EH" to "Sathara an Iar",
    "ER" to "Eartra",
    "ES" to "An Spàinnt",
    "ET" to "An Itiop",
    "EU" to "An t-Aonadh Eòrpach",
    "EZ" to "Raon an Eòro",
    "FI" to "An Fhionnlann",
    "FJ" to "Fìdi",
    "FK" to "Na h-Eileanan Fàclannach",
    "FM" to "Na Meanbh-eileanan",
    "FO" to "Na h-Eileanan Fàro",
    "FR" to "An Fhraing",
    "GA" to "Gabon",
    "GB" to "An Rìoghachd Aonaichte",
    "GD" to "Greanàda",
    "GE" to "A’ Chairtbheil",
    "GF" to "Guidheàna na Frainge",
    "GG" to "Geàrnsaidh",
    "GH" to "Gàna",
    "GI" to "Diobraltar",
    "GL" to "A’ Ghraonlann",
    "GM" to "A’ Ghaimbia",
    "GN" to "Gini",
    "GP" to "Guadalup",
    "GQ" to "Gini Mheadhan-Chriosach",
    "GR" to "A’ Ghreug",
    "GS" to "Seòirsea a Deas is na h-Eileanan Sandwich a Deas",
    "GT" to "Guatamala",
    "GU" to "Guam",
    "GW" to "Gini-Bioso",
    "GY" to "Guidheàna",
    "HK" to "Hong Kong SAR na Sìne",
    "HM" to "Eilean Heard is Eileanan MhicDhòmhnaill",
    "HN" to "Hondùras",
    "HR" to "A’ Chròthais",
    "HT" to "Haidhti",
    "HU" to "An Ungair",
    "IC" to "Na h-Eileanan Canàrach",
    "ID" to "Na h-Innd-innse",
    "IE" to "Èirinn",
    "IL" to "Iosrael",
    "IM" to "Eilean Mhanainn",
    "IN" to "Na h-Innseachan",
    "IO" to "Ranntair Breatannach Cuan nan Innseachan",
    "IQ" to "Ioràc",
    "IR" to "Ioràn",
    "IS" to "Innis Tìle",
    "IT" to "An Eadailt",
    "JE" to "Deàrsaidh",
    "JM" to "Diameuga",
    "JO" to "Iòrdan",
    "JP" to "An t-Seapan",
    "KE" to "Ceinia",
    "KG" to "Cìorgastan",
    "KH" to "Cambuidea",
    "KI" to "Ciribeas",
    "KM" to "Comoros",
    "KN" to "Naomh Crìstean is Nibheis",
    "KP" to "Coirèa a Tuath",
    "KR" to "Coirèa",
    "KW" to "Cuibhèit",
    "KY" to "Na h-Eileanan Caimean",
    "KZ" to "Casachstàn",
    "LA" to "Làthos",
    "LB" to "Leabanon",
    "LC" to "Naomh Lùisea",
    "LI" to "Lichtenstein",
    "LK" to "Sri Lanca",
    "LR" to "Libèir",
    "LS" to "Leasoto",
    "LT" to "An Liotuain",
    "LU" to "Lugsamburg",
    "LV" to "An Laitbhe",
    "LY" to "Libia",
    "MA" to "Moroco",
    "MC" to "Monaco",
    "MD" to "A’ Mholdobha",
    "ME" to "Am Monadh Neagrach",
    "MF" to "Naomh Màrtainn",
    "MG" to "Madagasgar",
    "MH" to "Eileanan Mharshall",
    "MK" to "A’ Mhasadon a Tuath",
    "ML" to "Màili",
    "MM" to "Miànmar",
    "MN" to "Dùthaich nam Mongol",
    "MO" to "Macàthu SAR na Sìne",
    "MP" to "Na h-Eileanan Mairianach a Tuath",
    "MQ" to "Mairtinic",
    "MR" to "Moratàinea",
    "MS" to "Montsarat",
    "MT" to "Malta",
    "MU" to "Na h-Eileanan Mhoiriseas",
    "MV" to "Na h-Eileanan Mhaladaibh",
    "MW" to "Malabhaidh",
    "MX" to "Meagsago",
    "MY" to "Malaidhsea",
    "MZ" to "Mòsaimbic",
    "NA" to "An Namaib",
    "NC" to "Cailleann Nuadh",
    "NE" to "Nìgeir",
    "NF" to "Eilean Norfolk",
    "NG" to "Nigèiria",
    "NI" to "Niocaragua",
    "NL" to "Na Tìrean Ìsle",
    "NO" to "Nirribhidh",
    "NP" to "Neapàl",
    "NR" to "Nabhru",
    "NU" to "Niue",
    "NZ" to "Sealainn Nuadh",
    "OM" to "Omàn",
    "PA" to "Panama",
    "PE" to "Pearù",
    "PF" to "Poilinèis na Frainge",
    "PG" to "Gini Nuadh Phaputhach",
    "PH" to "Na h-Eileanan Filipineach",
    "PK" to "Pagastàn",
    "PL" to "A’ Phòlainn",
    "PM" to "Saint Pierre agus Miquelon",
    "PN" to "Eileanan Pheit a’ Chàirn",
    "PR" to "Porto Rìceo",
    "PS" to "Ùghdarras nam Palastaineach",
    "PT" to "A’ Phortagail",
    "PW" to "Palabh",
    "PY" to "Paraguaidh",
    "QA" to "Catar",
    "QO" to "Roinn Iomallach a’ Chuain Sèimh",
    "RE" to "Réunion",
    "RO" to "Romàinia",
    "RS" to "An t-Sèirb",
    "RU" to "An Ruis",
    "RW" to "Rubhanda",
    "SA" to "Aràibia nan Sabhd",
    "SB" to "Eileanan Sholaimh",
    "SC" to "Na h-Eileanan Sheiseall",
    "SD" to "Sudàn",
    "SE" to "An t-Suain",
    "SG" to "Singeapòr",
    "SH" to "Eilean Naomh Eilidh",
    "SI" to "An t-Slòbhain",
    "SJ" to "Svalbard is Jan Mayen",
    "SK" to "An t-Slòbhac",
    "SL" to "Siarra Leòmhann",
    "SM" to "San Marino",
    "SN" to "Seanagal",
    "SO" to "Somàilia",
    "SR" to "Suranam",
    "SS" to "Sudàn a Deas",
    "ST" to "São Tomé agus Príncipe",
    "SV" to "An Salbhador",
    "SX" to "Sint Maarten",
    "SY" to "Siridhea",
    "SZ" to "eSwatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Na h-Eileanan Turcach is Caiceo",
    "TD" to "An t-Seàd",
    "TF" to "Ranntairean a Deas na Frainge",
    "TG" to "Togo",
    "TH" to "Dùthaich nan Tàidh",
    "TJ" to "Taidigeastàn",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turcmanastàn",
    "TN" to "Tuinisea",
    "TO" to "Tonga",
    "TR" to "An Tuirc",
    "TT" to "Trianaid agus Tobago",
    "TV" to "Tubhalu",
    "TW" to "Taidh-Bhàn",
    "TZ" to "An Tansan",
    "UA" to "An Ucràin",
    "UG" to "Uganda",
    "UM" to "Meanbh-Eileanan Iomallach nan SA",
    "UN" to "Na Dùthchannan Aonaichte",
    "US" to "Na Stàitean Aonaichte",
    "UY" to "Uruguaidh",
    "UZ" to "Usbagastàn",
    "VA" to "Cathair na Bhatacain",
    "VC" to "Naomh Bhionsant agus Eileanan Greanadach",
    "VE" to "A’ Bheiniseala",
    "VG" to "Eileanan Breatannach na Maighdinn",
    "VI" to "Eileanan na Maighdinn aig na SA",
    "VN" to "Bhiet-Nam",
    "VU" to "Vanuatu",
    "WF" to "Uallas agus Futuna",
    "WS" to "Samotha",
    "XA" to "Sràcan fuadain",
    "XB" to "Dà-chomhaireach fuadain",
    "XK" to "A’ Chosobho",
    "YE" to "An Eaman",
    "YT" to "Mayotte",
    "ZA" to "Afraga a Deas",
    "ZM" to "Sàimbia",
    "ZW" to "An t-Sìombab",
    "ZZ" to "Roinn-dùthcha neo-aithnichte",
  ) }

  val gl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Mundo",
    "002" to "África",
    "003" to "América do Norte",
    "005" to "América do Sur",
    "009" to "Oceanía",
    "011" to "África Occidental",
    "013" to "América Central",
    "014" to "África Oriental",
    "015" to "África Setentrional",
    "017" to "África Central",
    "018" to "África Meridional",
    "019" to "América",
    "021" to "América Setentrional",
    "029" to "Caribe",
    "030" to "Asia Oriental",
    "034" to "Asia Meridional",
    "035" to "Sueste Asiático",
    "039" to "Europa Meridional",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Rexión de Micronesia",
    "061" to "Polinesia",
    "142" to "Asia",
    "143" to "Asia Central",
    "145" to "Asia Occidental",
    "150" to "Europa",
    "151" to "Europa do Leste",
    "154" to "Europa Setentrional",
    "155" to "Europa Occidental",
    "202" to "África subsahariana",
    "419" to "América Latina",
    "AC" to "Illa de Ascensión",
    "AD" to "Andorra",
    "AE" to "Emiratos Árabes Unidos",
    "AF" to "Afganistán",
    "AG" to "Antigua e Barbuda",
    "AI" to "Anguila",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antártida",
    "AR" to "Arxentina",
    "AS" to "Samoa Americana",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Illas Åland",
    "AZ" to "Acerbaixán",
    "BA" to "Bosnia e Hercegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Bélxica",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benín",
    "BL" to "Saint Barthélemy",
    "BM" to "Illas Bermudas",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Caribe Neerlandés",
    "BR" to "Brasil",
    "BS" to "Bahamas",
    "BT" to "Bután",
    "BV" to "Illa Bouvet",
    "BW" to "Botswana",
    "BY" to "Belarús",
    "BZ" to "Belize",
    "CA" to "Canadá",
    "CC" to "Illas Cocos (Keeling)",
    "CD" to "República Democrática do Congo",
    "CF" to "República Centroafricana",
    "CG" to "República do Congo",
    "CH" to "Suíza",
    "CI" to "Côte d’Ivoire",
    "CK" to "Illas Cook",
    "CL" to "Chile",
    "CM" to "Camerún",
    "CN" to "China",
    "CO" to "Colombia",
    "CP" to "Illa Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cabo Verde",
    "CW" to "Curaçao",
    "CX" to "Illa Christmas",
    "CY" to "Chipre",
    "CZ" to "Chequia",
    "DE" to "Alemaña",
    "DG" to "Diego García",
    "DJ" to "Djibuti",
    "DK" to "Dinamarca",
    "DM" to "Dominica",
    "DO" to "República Dominicana",
    "DZ" to "Alxeria",
    "EA" to "Ceuta e Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Exipto",
    "EH" to "Sáhara Occidental",
    "ER" to "Eritrea",
    "ES" to "España",
    "ET" to "Etiopía",
    "EU" to "Unión Europea",
    "EZ" to "Eurozona",
    "FI" to "Finlandia",
    "FJ" to "Fixi",
    "FK" to "Illas Malvinas",
    "FM" to "Micronesia",
    "FO" to "Illas Feroe",
    "FR" to "Francia",
    "GA" to "Gabón",
    "GB" to "Reino Unido",
    "GD" to "Granada",
    "GE" to "Xeorxia",
    "GF" to "Güiana Francesa",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Xibraltar",
    "GL" to "Groenlandia",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadalupe",
    "GQ" to "Guinea Ecuatorial",
    "GR" to "Grecia",
    "GS" to "Illas Xeorxia do Sur e Sandwich do Sur",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea Bissau",
    "GY" to "Güiana",
    "HK" to "Hong Kong RAE da China",
    "HM" to "Illa Heard e Illas McDonald",
    "HN" to "Honduras",
    "HR" to "Croacia",
    "HT" to "Haití",
    "HU" to "Hungría",
    "IC" to "Illas Canarias",
    "ID" to "Indonesia",
    "IE" to "Irlanda",
    "IL" to "Israel",
    "IM" to "Illa de Man",
    "IN" to "India",
    "IO" to "Territorio Británico do Océano Índico",
    "IQ" to "Iraq",
    "IR" to "Irán",
    "IS" to "Islandia",
    "IT" to "Italia",
    "JE" to "Jersey",
    "JM" to "Xamaica",
    "JO" to "Xordania",
    "JP" to "Xapón",
    "KE" to "Kenya",
    "KG" to "Kirguizistán",
    "KH" to "Camboxa",
    "KI" to "Kiribati",
    "KM" to "Comores",
    "KN" to "Saint Kitts e Nevis",
    "KP" to "Corea do Norte",
    "KR" to "Corea do Sur",
    "KW" to "Kuwait",
    "KY" to "Illas Caimán",
    "KZ" to "Kazakistán",
    "LA" to "Laos",
    "LB" to "Líbano",
    "LC" to "Santa Lucía",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lituania",
    "LU" to "Luxemburgo",
    "LV" to "Letonia",
    "LY" to "Libia",
    "MA" to "Marrocos",
    "MC" to "Mónaco",
    "MD" to "República Moldova",
    "ME" to "Montenegro",
    "MF" to "Saint Martin",
    "MG" to "Madagascar",
    "MH" to "Illas Marshall",
    "MK" to "Macedonia do Norte",
    "ML" to "Malí",
    "MM" to "Myanmar (Birmania)",
    "MN" to "Mongolia",
    "MO" to "Macau RAE da China",
    "MP" to "Illas Marianas do Norte",
    "MQ" to "Martinica",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauricio",
    "MV" to "Maldivas",
    "MW" to "Malawi",
    "MX" to "México",
    "MY" to "Malaisia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "Nova Caledonia",
    "NE" to "Níxer",
    "NF" to "Illa Norfolk",
    "NG" to "Nixeria",
    "NI" to "Nicaragua",
    "NL" to "Países Baixos",
    "NO" to "Noruega",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nova Zelandia",
    "OM" to "Omán",
    "PA" to "Panamá",
    "PE" to "Perú",
    "PF" to "Polinesia Francesa",
    "PG" to "Papúa-Nova Guinea",
    "PH" to "Filipinas",
    "PK" to "Paquistán",
    "PL" to "Polonia",
    "PM" to "Saint Pierre et Miquelon",
    "PN" to "Illas Pitcairn",
    "PR" to "Porto Rico",
    "PS" to "Territorios Palestinos",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguai",
    "QA" to "Qatar",
    "QO" to "Territorios afastados de Oceanía",
    "RE" to "Reunión",
    "RO" to "Romanía",
    "RS" to "Serbia",
    "RU" to "Rusia",
    "RW" to "Ruanda",
    "SA" to "Arabia Saudita",
    "SB" to "Illas Salomón",
    "SC" to "Seychelles",
    "SD" to "Sudán",
    "SE" to "Suecia",
    "SG" to "Singapur",
    "SH" to "Santa Helena",
    "SI" to "Eslovenia",
    "SJ" to "Svalbard e Jan Mayen",
    "SK" to "Eslovaquia",
    "SL" to "Serra Leoa",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "Sudán do Sur",
    "ST" to "San Tomé e Príncipe",
    "SV" to "O Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Siria",
    "SZ" to "Eswatini",
    "TA" to "Tristán da Cunha",
    "TC" to "Illas Turks e Caicos",
    "TD" to "Chad",
    "TF" to "Territorios Austrais Franceses",
    "TG" to "Togo",
    "TH" to "Tailandia",
    "TJ" to "Taxiquistán",
    "TK" to "Tokelau",
    "TL" to "Timor Leste",
    "TM" to "Turkmenistán",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turquía",
    "TT" to "Trinidad e Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwán",
    "TZ" to "Tanzania",
    "UA" to "Ucraína",
    "UG" to "Uganda",
    "UM" to "Illas Menores Distantes dos Estados Unidos",
    "UN" to "Nacións Unidas",
    "US" to "Estados Unidos",
    "UY" to "Uruguai",
    "UZ" to "Uzbekistán",
    "VA" to "Cidade do Vaticano",
    "VC" to "San Vicente e as Granadinas",
    "VE" to "Venezuela",
    "VG" to "Illas Virxes Británicas",
    "VI" to "Illas Virxes Estadounidenses",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis e Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudoacentos",
    "XB" to "Pseudobidireccional",
    "XK" to "Kosovo",
    "YE" to "Iemen",
    "YT" to "Mayotte",
    "ZA" to "Suráfrica",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Rexión descoñecida",
  ) }

  val gsw: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Wält",
    "002" to "Afrika",
    "003" to "Nordameerika",
    "005" to "Süüdameerika",
    "009" to "Ozeaanie",
    "011" to "Weschtafrika",
    "013" to "Mittelameerika",
    "014" to "Oschtafrika",
    "015" to "Nordafrika",
    "017" to "Zentraalafrika",
    "018" to "Süüdlichs Afrika",
    "019" to "Nord-, Mittel- und Süüdameerika",
    "021" to "Nördlichs Ameerika",
    "029" to "Karibik",
    "030" to "Oschtaasie",
    "034" to "Süüdaasie",
    "035" to "Süüdoschtaasie",
    "039" to "Süüdeuropa",
    "053" to "Auschtraalie und Nöiseeland",
    "054" to "Melaneesie",
    "057" to "Mikroneesischs Inselgebiet",
    "061" to "Polineesie",
    "142" to "Aasie",
    "143" to "Zentraalaasie",
    "145" to "Weschtaasie",
    "150" to "Euroopa",
    "151" to "Oschteuroopa",
    "154" to "Nordeuroopa",
    "155" to "Weschteuroopa",
    "419" to "Latiinameerika",
    "AD" to "Andorra",
    "AE" to "Veräinigti Arabischi Emirate",
    "AF" to "Afganischtan",
    "AG" to "Antigua und Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albaanie",
    "AM" to "Armeenie",
    "AO" to "Angoola",
    "AQ" to "Antarktis",
    "AR" to "Argentiinie",
    "AS" to "Amerikaanisch-Samoa",
    "AT" to "Ööschtriich",
    "AU" to "Auschtraalie",
    "AW" to "Aruba",
    "AX" to "Aaland-Insle",
    "AZ" to "Aserbäidschan",
    "BA" to "Bosnie und Herzegowina",
    "BB" to "Barbados",
    "BD" to "Bangladesch",
    "BE" to "Belgie",
    "BF" to "Burkina Faaso",
    "BG" to "Bulgaarie",
    "BH" to "Bachräin",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthelemi",
    "BM" to "Bermuuda",
    "BN" to "Brunäi Tarussalam",
    "BO" to "Boliivie",
    "BR" to "Brasilie",
    "BS" to "Bahaamas",
    "BT" to "Bhutan",
    "BV" to "Bouvet-Insle",
    "BW" to "Botswana",
    "BY" to "Wiissrussland",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kokos-Insle",
    "CD" to "Temokraatischi Republik Kongo",
    "CF" to "Zentraalafrikaanischi Republik",
    "CG" to "Kongo",
    "CH" to "Schwiiz",
    "CI" to "Elfebäiküschte",
    "CK" to "Cook-Insle",
    "CL" to "Tschile",
    "CM" to "Kamerun",
    "CN" to "Chiina",
    "CO" to "Kolumbie",
    "CR" to "Coschta Rica",
    "CU" to "Kuba",
    "CV" to "Kap Verde",
    "CX" to "Wienachts-Insle",
    "CY" to "Zypere",
    "CZ" to "Tschechischi Republik",
    "DE" to "Tüütschland",
    "DJ" to "Tschibuuti",
    "DK" to "Tänemark",
    "DM" to "Tominica",
    "DO" to "Tominikaanischi Republik",
    "DZ" to "Algeerie",
    "EC" to "Ecuador",
    "EE" to "Eestland",
    "EG" to "Ägüpte",
    "EH" to "Weschtsahara",
    "ER" to "Äritreea",
    "ES" to "Schpanie",
    "ET" to "Äthiopie",
    "EU" to "Europääischi Unioon",
    "FI" to "Finnland",
    "FJ" to "Fitschi",
    "FK" to "Falkland-Insle",
    "FM" to "Mikroneesie",
    "FO" to "Färöer",
    "FR" to "Frankriich",
    "GA" to "Gabun",
    "GB" to "Veräinigts Chönigriich",
    "GD" to "Grenada",
    "GE" to "Geoorgie",
    "GF" to "Französisch-Guäjaana",
    "GG" to "Gäärnsi",
    "GH" to "Gaana",
    "GI" to "Gibraltar",
    "GL" to "Gröönland",
    "GM" to "Gambia",
    "GN" to "Gineea",
    "GP" to "Guadälup",
    "GQ" to "Äquatoriaalgineea",
    "GR" to "Griecheland",
    "GS" to "Süüdgeorgie und d’süüdlichi Sändwitsch-Insle",
    "GT" to "Guatemaala",
    "GU" to "Guam",
    "GW" to "Gineea-Bissau",
    "GY" to "Guäjaana",
    "HK" to "Sonderverwaltigszone Hongkong",
    "HM" to "Höörd- und MäcDonald-Insle",
    "HN" to "Honduras",
    "HR" to "Kroaazie",
    "HT" to "Haiti",
    "HU" to "Ungarn",
    "ID" to "Indoneesie",
    "IE" to "Irland",
    "IL" to "Israel",
    "IM" to "Insle vo Män",
    "IN" to "Indie",
    "IQ" to "Iraak",
    "IR" to "Iraan",
    "IS" to "Iisland",
    "IT" to "Itaalie",
    "JE" to "Dschörsi",
    "JM" to "Dschamäika",
    "JO" to "Jordaanie",
    "JP" to "Japan",
    "KE" to "Keenia",
    "KG" to "Kirgiisischtan",
    "KH" to "Kambodscha",
    "KI" to "Kiribaati",
    "KM" to "Komoore",
    "KN" to "St. Kitts und Niuwis",
    "KP" to "Demokraatischi Volksrepublik Koreea",
    "KR" to "Republik Koreea",
    "KW" to "Kuwäit",
    "KY" to "Käimän-Insle",
    "KZ" to "Kasachschtan",
    "LA" to "Laaos",
    "LB" to "Libanon",
    "LC" to "St. Lutschiia",
    "LI" to "Liächteschtäi",
    "LK" to "Schri Lanka",
    "LR" to "Libeeria",
    "LS" to "Lesooto",
    "LT" to "Littaue",
    "LU" to "Luxemburg",
    "LV" to "Lettland",
    "LY" to "Lüübie",
    "MA" to "Marokko",
    "MC" to "Monaco",
    "MD" to "Republik Moldau",
    "ME" to "Monteneegro",
    "MF" to "St. Martin",
    "MG" to "Madagaschkar",
    "MH" to "Marshallinsle",
    "ML" to "Maali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolei",
    "MO" to "Sonderverwaltigszone Macao",
    "MP" to "Nördlichi Mariaane",
    "MQ" to "Martinigg",
    "MR" to "Mauretaanie",
    "MS" to "Moosörrat",
    "MT" to "Malta",
    "MU" to "Mauriizius",
    "MV" to "Malediiwe",
    "MW" to "Malaawi",
    "MX" to "Mexiko",
    "MY" to "Maläisia",
    "MZ" to "Mosambik",
    "NA" to "Namiibia",
    "NC" to "Nöikaledoonie",
    "NE" to "Niger",
    "NF" to "Norfolk-Insle",
    "NG" to "Nigeeria",
    "NI" to "Nicaraagua",
    "NL" to "Holland",
    "NO" to "Norweege",
    "NP" to "Neepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nöiseeland",
    "OM" to "Omaan",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Französisch-Polineesie",
    "PG" to "Papua-Neuguinea",
    "PH" to "Philippiine",
    "PK" to "Pakischtan",
    "PL" to "Poole",
    "PM" to "St. Pierr und Miggelo",
    "PN" to "Pitggäärn",
    "PR" to "Puerto Riggo",
    "PS" to "Paläschtinänsischi Gebiet",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguai",
    "QA" to "Ggatar",
    "QO" to "Üssers Ozeaanie",
    "RE" to "Reünioon",
    "RO" to "Rumäänie",
    "RS" to "Särbie",
    "RU" to "Russland",
    "RW" to "Ruanda",
    "SA" to "Saudi-Araabie",
    "SB" to "Salomoone",
    "SC" to "Seischälle",
    "SD" to "Sudan",
    "SE" to "Schweede",
    "SG" to "Singapuur",
    "SH" to "St. Helena",
    "SI" to "Sloweenie",
    "SJ" to "Svalbard und Jaan Määie",
    "SK" to "Slowakäi",
    "SL" to "Sierra Leoone",
    "SM" to "San Mariino",
    "SN" to "Senegal",
    "SO" to "Somaalie",
    "SR" to "Surinam",
    "ST" to "Sao Tome und Prinssipe",
    "SV" to "El Salvador",
    "SY" to "Süürie",
    "SZ" to "Swasiland",
    "TC" to "Törks- und Gaiggos-Insle",
    "TD" to "Tschad",
    "TF" to "Französischi Süüd- und Antarktisgebiet",
    "TG" to "Toogo",
    "TH" to "Thailand",
    "TJ" to "Tadschikischtan",
    "TK" to "Tokelau",
    "TL" to "Oschttimor",
    "TM" to "Turkmeenischtan",
    "TN" to "Tuneesie",
    "TO" to "Tonga",
    "TR" to "Türggei",
    "TT" to "Trinidad und Tobaago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tansaniia",
    "UA" to "Ukraiine",
    "UG" to "Uganda",
    "UM" to "Amerikanisch-Ozeaanie",
    "US" to "Veräinigti Schtaate",
    "UY" to "Uruguay",
    "UZ" to "Uschbeekischtan",
    "VA" to "Vatikanstadt",
    "VC" to "St. Vincent und d’Grönadiine",
    "VE" to "Venezueela",
    "VG" to "Britischi Jungfere-Insle",
    "VI" to "Amerikaanischi Jungfere-Insle",
    "VN" to "Wietnam",
    "VU" to "Wanuatu",
    "WF" to "Wallis und Futuuna",
    "WS" to "Samooa",
    "YE" to "Jeeme",
    "YT" to "Majott",
    "ZA" to "Süüdafrika",
    "ZM" to "Sambia",
    "ZW" to "Simbabwe",
    "ZZ" to "Unbekannti oder ungültigi Regioon",
  ) }

  val gsw_FR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gsw_LI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "વિશ્વ",
    "002" to "આફ્રિકા",
    "003" to "ઉત્તર અમેરિકા",
    "005" to "દક્ષિણ અમેરિકા",
    "009" to "ઓશનિયા",
    "011" to "પશ્ચિમી આફ્રિકા",
    "013" to "મધ્ય અમેરિકા",
    "014" to "પૂર્વીય આફ્રિકા",
    "015" to "ઉત્તરી આફ્રિકા",
    "017" to "મધ્ય આફ્રિકા",
    "018" to "સધર્ન આફ્રિકા",
    "019" to "અમેરિકા",
    "021" to "ઉત્તરી અમેરિકા",
    "029" to "કેરિબિયન",
    "030" to "પૂર્વીય એશિયા",
    "034" to "દક્ષિણ એશિયા",
    "035" to "દક્ષિણપૂર્વ એશિયા",
    "039" to "દક્ષિણ યુરોપ",
    "053" to "ઓસ્ટ્રેલેશિયા",
    "054" to "મેલાનેશિયા",
    "057" to "માઈક્રોનેશિયન ક્ષેત્ર",
    "061" to "પોલિનેશિયા",
    "142" to "એશિયા",
    "143" to "મધ્ય એશિયા",
    "145" to "પશ્ચિમી એશિયા",
    "150" to "યુરોપ",
    "151" to "પૂર્વીય યુરોપ",
    "154" to "ઉત્તરીય યુરોપ",
    "155" to "પશ્ચિમી યુરોપ",
    "202" to "સબ-સહારન આફ્રિકા",
    "419" to "લેટિન અમેરિકા",
    "AC" to "એસેન્શન આઇલેન્ડ",
    "AD" to "ઍંડોરા",
    "AE" to "યુનાઇટેડ આરબ અમીરાત",
    "AF" to "અફઘાનિસ્તાન",
    "AG" to "ઍન્ટિગુઆ અને બર્મુડા",
    "AI" to "ઍંગ્વિલા",
    "AL" to "અલ્બેનિયા",
    "AM" to "આર્મેનિયા",
    "AO" to "અંગોલા",
    "AQ" to "એન્ટાર્કટિકા",
    "AR" to "આર્જેન્ટીના",
    "AS" to "અમેરિકન સમોઆ",
    "AT" to "ઑસ્ટ્રિયા",
    "AU" to "ઑસ્ટ્રેલિયા",
    "AW" to "અરુબા",
    "AX" to "ઑલેન્ડ આઇલેન્ડ્સ",
    "AZ" to "અઝરબૈજાન",
    "BA" to "બોસ્નિયા અને હર્ઝેગોવિના",
    "BB" to "બારબાડોસ",
    "BD" to "બાંગ્લાદેશ",
    "BE" to "બેલ્જીયમ",
    "BF" to "બુર્કિના ફાસો",
    "BG" to "બલ્ગેરિયા",
    "BH" to "બેહરીન",
    "BI" to "બુરુંડી",
    "BJ" to "બેનિન",
    "BL" to "સેંટ બાર્થેલેમી",
    "BM" to "બર્મુડા",
    "BN" to "બ્રુનેઇ",
    "BO" to "બોલિવિયા",
    "BQ" to "કેરેબિયન નેધરલેન્ડ્ઝ",
    "BR" to "બ્રાઝિલ",
    "BS" to "બહામાસ",
    "BT" to "ભૂટાન",
    "BV" to "બૌવેત આઇલેન્ડ",
    "BW" to "બોત્સ્વાના",
    "BY" to "બેલારુસ",
    "BZ" to "બેલીઝ",
    "CA" to "કેનેડા",
    "CC" to "કોકોઝ (કીલીંગ) આઇલેન્ડ્સ",
    "CD" to "કોંગો - કિંશાસા",
    "CF" to "સેન્ટ્રલ આફ્રિકન રિપબ્લિક",
    "CG" to "કોંગો - બ્રાઝાવિલે",
    "CH" to "સ્વિટ્ઝર્લૅન્ડ",
    "CI" to "કોટ ડીઆઇવરી",
    "CK" to "કુક આઇલેન્ડ્સ",
    "CL" to "ચિલી",
    "CM" to "કૅમરૂન",
    "CN" to "ચીન",
    "CO" to "કોલમ્બિયા",
    "CP" to "ક્લિપરટન આઇલેન્ડ",
    "CR" to "કોસ્ટા રિકા",
    "CU" to "ક્યુબા",
    "CV" to "કૅપ વર્ડે",
    "CW" to "ક્યુરાસાઓ",
    "CX" to "ક્રિસમસ આઇલેન્ડ",
    "CY" to "સાયપ્રસ",
    "CZ" to "ચેકીયા",
    "DE" to "જર્મની",
    "DG" to "ડિએગો ગારસિઆ",
    "DJ" to "જીબૌટી",
    "DK" to "ડેનમાર્ક",
    "DM" to "ડોમિનિકા",
    "DO" to "ડોમિનિકન રિપબ્લિક",
    "DZ" to "અલ્જીરિયા",
    "EA" to "સ્યુટા અને મેલિલા",
    "EC" to "એક્વાડોર",
    "EE" to "એસ્ટોનિયા",
    "EG" to "ઇજિપ્ત",
    "EH" to "પશ્ચિમી સહારા",
    "ER" to "એરિટ્રિયા",
    "ES" to "સ્પેન",
    "ET" to "ઇથિઓપિયા",
    "EU" to "યુરોપિયન સંઘ",
    "EZ" to "યુરોઝોન",
    "FI" to "ફિનલેન્ડ",
    "FJ" to "ફીજી",
    "FK" to "ફૉકલેન્ડ આઇલેન્ડ્સ",
    "FM" to "માઇક્રોનેશિયા",
    "FO" to "ફેરો આઇલેન્ડ્સ",
    "FR" to "ફ્રાંસ",
    "GA" to "ગેબન",
    "GB" to "યુનાઇટેડ કિંગડમ",
    "GD" to "ગ્રેનેડા",
    "GE" to "જ્યોર્જિયા",
    "GF" to "ફ્રેંચ ગયાના",
    "GG" to "ગ્વેર્નસે",
    "GH" to "ઘાના",
    "GI" to "જીબ્રાલ્ટર",
    "GL" to "ગ્રીનલેન્ડ",
    "GM" to "ગેમ્બિયા",
    "GN" to "ગિની",
    "GP" to "ગ્વાડેલોપ",
    "GQ" to "ઇક્વેટોરિયલ ગિની",
    "GR" to "ગ્રીસ",
    "GS" to "દક્ષિણ જ્યોર્જિયા અને દક્ષિણ સેન્ડવિચ આઇલેન્ડ્સ",
    "GT" to "ગ્વાટેમાલા",
    "GU" to "ગ્વામ",
    "GW" to "ગિની-બિસાઉ",
    "GY" to "ગયાના",
    "HK" to "હોંગકોંગ SAR ચીન",
    "HM" to "હર્ડ અને મેકડોનાલ્ડ આઇલેન્ડ્સ",
    "HN" to "હોન્ડુરસ",
    "HR" to "ક્રોએશિયા",
    "HT" to "હૈતિ",
    "HU" to "હંગેરી",
    "IC" to "કૅનેરી આઇલેન્ડ્સ",
    "ID" to "ઇન્ડોનેશિયા",
    "IE" to "આયર્લેન્ડ",
    "IL" to "ઇઝરાઇલ",
    "IM" to "આઇલ ઑફ મેન",
    "IN" to "ભારત",
    "IO" to "બ્રિટિશ ઇન્ડિયન ઓશન ટેરિટરી",
    "IQ" to "ઇરાક",
    "IR" to "ઈરાન",
    "IS" to "આઇસલેન્ડ",
    "IT" to "ઇટાલી",
    "JE" to "જર્સી",
    "JM" to "જમૈકા",
    "JO" to "જોર્ડન",
    "JP" to "જાપાન",
    "KE" to "કેન્યા",
    "KG" to "કિર્ગિઝ્સ્તાન",
    "KH" to "કંબોડિયા",
    "KI" to "કિરિબાટી",
    "KM" to "કોમોરસ",
    "KN" to "સેંટ કિટ્સ અને નેવિસ",
    "KP" to "ઉત્તર કોરિયા",
    "KR" to "દક્ષિણ કોરિયા",
    "KW" to "કુવૈત",
    "KY" to "કેમેન આઇલેન્ડ્સ",
    "KZ" to "કઝાકિસ્તાન",
    "LA" to "લાઓસ",
    "LB" to "લેબનોન",
    "LC" to "સેંટ લુસિયા",
    "LI" to "લૈચટેંસ્ટેઇન",
    "LK" to "શ્રીલંકા",
    "LR" to "લાઇબેરિયા",
    "LS" to "લેસોથો",
    "LT" to "લિથુઆનિયા",
    "LU" to "લક્ઝમબર્ગ",
    "LV" to "લાત્વિયા",
    "LY" to "લિબિયા",
    "MA" to "મોરોક્કો",
    "MC" to "મોનાકો",
    "MD" to "મોલડોવા",
    "ME" to "મૉન્ટેનેગ્રો",
    "MF" to "સેંટ માર્ટિન",
    "MG" to "મેડાગાસ્કર",
    "MH" to "માર્શલ આઇલેન્ડ્સ",
    "MK" to "ઉત્તર મેસેડોનિયા",
    "ML" to "માલી",
    "MM" to "મ્યાંમાર (બર્મા)",
    "MN" to "મંગોલિયા",
    "MO" to "મકાઉ SAR ચીન",
    "MP" to "ઉત્તરી મારિયાના આઇલેન્ડ્સ",
    "MQ" to "માર્ટીનીક",
    "MR" to "મૌરિટાનિયા",
    "MS" to "મોંટસેરાત",
    "MT" to "માલ્ટા",
    "MU" to "મોરિશિયસ",
    "MV" to "માલદિવ્સ",
    "MW" to "માલાવી",
    "MX" to "મેક્સિકો",
    "MY" to "મલેશિયા",
    "MZ" to "મોઝામ્બિક",
    "NA" to "નામિબિયા",
    "NC" to "ન્યુ સેલેડોનિયા",
    "NE" to "નાઇજર",
    "NF" to "નોરફોક આઇલેન્ડ્સ",
    "NG" to "નાઇજેરિયા",
    "NI" to "નિકારાગુઆ",
    "NL" to "નેધરલેન્ડ્સ",
    "NO" to "નૉર્વે",
    "NP" to "નેપાળ",
    "NR" to "નૌરુ",
    "NU" to "નીયુ",
    "NZ" to "ન્યુઝીલેન્ડ",
    "OM" to "ઓમાન",
    "PA" to "પનામા",
    "PE" to "પેરુ",
    "PF" to "ફ્રેંચ પોલિનેશિયા",
    "PG" to "પાપુઆ ન્યૂ ગિની",
    "PH" to "ફિલિપિન્સ",
    "PK" to "પાકિસ્તાન",
    "PL" to "પોલેંડ",
    "PM" to "સેંટ પીએરી અને મિક્યુલોન",
    "PN" to "પીટકૈર્ન આઇલેન્ડ્સ",
    "PR" to "પ્યુઅર્ટો રિકો",
    "PS" to "પેલેસ્ટિનિયન ટેરિટરી",
    "PT" to "પોર્ટુગલ",
    "PW" to "પલાઉ",
    "PY" to "પેરાગ્વે",
    "QA" to "કતાર",
    "QO" to "આઉટલાઈન્ગ ઓશનિયા",
    "RE" to "રીયુનિયન",
    "RO" to "રોમાનિયા",
    "RS" to "સર્બિયા",
    "RU" to "રશિયા",
    "RW" to "રવાંડા",
    "SA" to "સાઉદી અરેબિયા",
    "SB" to "સોલોમન આઇલેન્ડ્સ",
    "SC" to "સેશેલ્સ",
    "SD" to "સુદાન",
    "SE" to "સ્વીડન",
    "SG" to "સિંગાપુર",
    "SH" to "સેંટ હેલેના",
    "SI" to "સ્લોવેનિયા",
    "SJ" to "સ્વાલબર્ડ અને જેન મેયન",
    "SK" to "સ્લોવેકિયા",
    "SL" to "સીએરા લેઓન",
    "SM" to "સૅન મેરિનો",
    "SN" to "સેનેગલ",
    "SO" to "સોમાલિયા",
    "SR" to "સુરીનામ",
    "SS" to "દક્ષિણ સુદાન",
    "ST" to "સાઓ ટૉમ અને પ્રિંસિપે",
    "SV" to "એલ સેલ્વાડોર",
    "SX" to "સિંટ માર્ટેન",
    "SY" to "સીરિયા",
    "SZ" to "એસ્વાટીની",
    "TA" to "ત્રિસ્તાન દા કુન્હા",
    "TC" to "તુર્ક્સ અને કેકોઝ આઇલેન્ડ્સ",
    "TD" to "ચાડ",
    "TF" to "ફ્રેંચ સધર્ન ટેરિટરીઝ",
    "TG" to "ટોગો",
    "TH" to "થાઇલેંડ",
    "TJ" to "તાજીકિસ્તાન",
    "TK" to "ટોકેલાઉ",
    "TL" to "તિમોર-લેસ્તે",
    "TM" to "તુર્કમેનિસ્તાન",
    "TN" to "ટ્યુનિશિયા",
    "TO" to "ટોંગા",
    "TR" to "તુર્કિયે",
    "TT" to "ટ્રિનીદાદ અને ટોબેગો",
    "TV" to "તુવાલુ",
    "TW" to "તાઇવાન",
    "TZ" to "તાંઝાનિયા",
    "UA" to "યુક્રેન",
    "UG" to "યુગાંડા",
    "UM" to "યુ.એસ. આઉટલાઇનિંગ આઇલેન્ડ્સ",
    "UN" to "સંયુક્ત રાષ્ટ્ર",
    "US" to "યુનાઇટેડ સ્ટેટ્સ",
    "UY" to "ઉરુગ્વે",
    "UZ" to "ઉઝ્બેકિસ્તાન",
    "VA" to "વેટિકન સિટી",
    "VC" to "સેંટ વિન્સેંટ અને ગ્રેનેડાઇંસ",
    "VE" to "વેનેઝુએલા",
    "VG" to "બ્રિટિશ વર્જિન આઇલેન્ડ્સ",
    "VI" to "યુએસ વર્જિન આઇલેન્ડ્સ",
    "VN" to "વિયેતનામ",
    "VU" to "વાનુઆતુ",
    "WF" to "વૉલિસ અને ફ્યુચુના",
    "WS" to "સમોઆ",
    "XA" to "સ્યુડો-ઍક્સન્ટ",
    "XB" to "સ્યુડો-દ્વિદિશ",
    "XK" to "કોસોવો",
    "YE" to "યમન",
    "YT" to "મેયોટ",
    "ZA" to "દક્ષિણ આફ્રિકા",
    "ZM" to "ઝામ્બિયા",
    "ZW" to "ઝિમ્બાબ્વે",
    "ZZ" to "અજ્ઞાત પ્રદેશ",
  ) }

  val guz: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Falme za Kiarabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AR" to "Ajentina",
    "AS" to "Samoa ya Marekani",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AZ" to "Azabajani",
    "BA" to "Bosnia na Hezegovina",
    "BB" to "Babadosi",
    "BD" to "Bangladeshi",
    "BE" to "Ubelgiji",
    "BF" to "Bukinafaso",
    "BG" to "Bulgaria",
    "BH" to "Bahareni",
    "BI" to "Burundi",
    "BJ" to "Benini",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BR" to "Brazili",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botswana",
    "BY" to "Belarusi",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CD" to "Jamhuri ya Kidemokrasia ya Kongo",
    "CF" to "Jamhuri ya Afrika ya Kati",
    "CG" to "Kongo",
    "CH" to "Uswisi",
    "CI" to "Kodivaa",
    "CK" to "Visiwa vya Cook",
    "CL" to "Chile",
    "CM" to "Kameruni",
    "CN" to "China",
    "CO" to "Kolombia",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Kepuvede",
    "CY" to "Kuprosi",
    "CZ" to "Jamhuri ya Cheki",
    "DE" to "Ujerumani",
    "DJ" to "Jibuti",
    "DK" to "Denmaki",
    "DM" to "Dominika",
    "DO" to "Jamhuri ya Dominika",
    "DZ" to "Aljeria",
    "EC" to "Ekwado",
    "EE" to "Estonia",
    "EG" to "Misri",
    "ER" to "Eritrea",
    "ES" to "Hispania",
    "ET" to "Uhabeshi",
    "FI" to "Ufini",
    "FJ" to "Fiji",
    "FK" to "Visiwa vya Falkland",
    "FM" to "Mikronesia",
    "FR" to "Ufaransa",
    "GA" to "Gaboni",
    "GB" to "Uingereza",
    "GD" to "Grenada",
    "GE" to "Jojia",
    "GF" to "Gwiyana ya Ufaransa",
    "GH" to "Ghana",
    "GI" to "Jibralta",
    "GL" to "Grinlandi",
    "GM" to "Gambia",
    "GN" to "Gine",
    "GP" to "Gwadelupe",
    "GQ" to "Ginekweta",
    "GR" to "Ugiriki",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Hondurasi",
    "HR" to "Korasia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "ID" to "Indonesia",
    "IE" to "Ayalandi",
    "IL" to "Israeli",
    "IN" to "India",
    "IQ" to "Iraki",
    "IR" to "Uajemi",
    "IS" to "Aislandi",
    "IT" to "Italia",
    "JM" to "Jamaika",
    "JO" to "Yordani",
    "JP" to "Japani",
    "KE" to "Kenya",
    "KG" to "Kirigizistani",
    "KH" to "Kambodia",
    "KI" to "Kiribati",
    "KM" to "Komoro",
    "KN" to "Santakitzi na Nevis",
    "KP" to "Korea Kaskazini",
    "KR" to "Korea Kusini",
    "KW" to "Kuwaiti",
    "KY" to "Visiwa vya Kayman",
    "KZ" to "Kazakistani",
    "LA" to "Laosi",
    "LB" to "Lebanoni",
    "LC" to "Santalusia",
    "LI" to "Lishenteni",
    "LK" to "Sirilanka",
    "LR" to "Liberia",
    "LS" to "Lesoto",
    "LT" to "Litwania",
    "LU" to "Lasembagi",
    "LV" to "Lativia",
    "LY" to "Libya",
    "MA" to "Moroko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "MG" to "Bukini",
    "MH" to "Visiwa vya Marshal",
    "ML" to "Mali",
    "MM" to "Myama",
    "MN" to "Mongolia",
    "MP" to "Visiwa vya Mariana vya Kaskazini",
    "MQ" to "Martiniki",
    "MR" to "Moritania",
    "MS" to "Montserrati",
    "MT" to "Malta",
    "MU" to "Morisi",
    "MV" to "Modivu",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malesia",
    "MZ" to "Msumbiji",
    "NA" to "Namibia",
    "NC" to "Nyukaledonia",
    "NE" to "Nijeri",
    "NF" to "Kisiwa cha Norfok",
    "NG" to "Nijeria",
    "NI" to "Nikaragwa",
    "NL" to "Uholanzi",
    "NO" to "Norwe",
    "NP" to "Nepali",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nyuzilandi",
    "OM" to "Omani",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia ya Ufaransa",
    "PG" to "Papua",
    "PH" to "Filipino",
    "PK" to "Pakistani",
    "PL" to "Polandi",
    "PM" to "Santapieri na Mikeloni",
    "PN" to "Pitkairni",
    "PR" to "Pwetoriko",
    "PS" to "Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina",
    "PT" to "Ureno",
    "PW" to "Palau",
    "PY" to "Paragwai",
    "QA" to "Katari",
    "RE" to "Riyunioni",
    "RO" to "Romania",
    "RU" to "Urusi",
    "RW" to "Rwanda",
    "SA" to "Saudi",
    "SB" to "Visiwa vya Solomon",
    "SC" to "Shelisheli",
    "SD" to "Sudani",
    "SE" to "Uswidi",
    "SG" to "Singapoo",
    "SH" to "Santahelena",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SL" to "Siera Leoni",
    "SM" to "Samarino",
    "SN" to "Senegali",
    "SO" to "Somalia",
    "SR" to "Surinamu",
    "ST" to "Sao Tome na Principe",
    "SV" to "Elsavado",
    "SY" to "Siria",
    "SZ" to "Uswazi",
    "TC" to "Visiwa vya Turki na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tailandi",
    "TJ" to "Tajikistani",
    "TK" to "Tokelau",
    "TL" to "Timori ya Mashariki",
    "TM" to "Turukimenistani",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Uturuki",
    "TT" to "Trinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tanzania",
    "UA" to "Ukraini",
    "UG" to "Uganda",
    "US" to "Marekani",
    "UY" to "Urugwai",
    "UZ" to "Uzibekistani",
    "VA" to "Vatikani",
    "VC" to "Santavisenti na Grenadini",
    "VE" to "Venezuela",
    "VG" to "Visiwa vya Virgin vya Uingereza",
    "VI" to "Visiwa vya Virgin vya Marekani",
    "VN" to "Vietinamu",
    "VU" to "Vanuatu",
    "WF" to "Walis na Futuna",
    "WS" to "Samoa",
    "YE" to "Yemeni",
    "YT" to "Mayotte",
    "ZA" to "Afrika Kusini",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
  ) }

  val gv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "GB" to "Rywvaneth Unys",
    "IM" to "Ellan Vannin",
  ) }

  val ha: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Duniya",
    "002" to "Afirka",
    "003" to "Amurka ta Arewa",
    "005" to "Amurka ta Kudu",
    "009" to "Osheniya",
    "011" to "Afirka ta Yamma",
    "013" to "Amurka ta Tsakiya",
    "014" to "Afirka ta Gabas",
    "015" to "Arewacin Afirka",
    "017" to "Afirka ta Tsakiya",
    "018" to "Kudancin Afirka",
    "019" to "Nahiyoyin Amurka",
    "021" to "Arewacin Amurka",
    "029" to "Karebiyan",
    "030" to "Gabashin Asiya",
    "034" to "Kudancin Asiya",
    "035" to "Kudu Maso Gabashin Asiya",
    "039" to "Kudancin Turai",
    "053" to "Asturelasiya",
    "054" to "Melanesia",
    "057" to "Yankin Micronesiya",
    "061" to "Kasar Polynesia",
    "142" to "Asiya",
    "143" to "Asiya ta Tsakiya",
    "145" to "Yammacin Asiya",
    "150" to "Turai",
    "151" to "Gabashin Turai",
    "154" to "Arewacin Turai",
    "155" to "Yammacin Turai",
    "202" to "Afirka ta Kudancin Sahara",
    "419" to "Latin Amurka",
    "AC" to "Tsibirin Ascension",
    "AD" to "Andora",
    "AE" to "Haɗaɗɗiyar Daular Larabawa",
    "AF" to "Afaganistan",
    "AG" to "Antigua da Barbuda",
    "AI" to "Angila",
    "AL" to "Albaniya",
    "AM" to "Armeniya",
    "AO" to "Angola",
    "AQ" to "Antatika",
    "AR" to "Ajentina",
    "AS" to "Samowa Ta Amurka",
    "AT" to "Ostiriya",
    "AU" to "Ostareliya",
    "AW" to "Aruba",
    "AX" to "Tsibirai na Åland",
    "AZ" to "Azarbaijan",
    "BA" to "Bosniya da Harzagobina",
    "BB" to "Barbadas",
    "BD" to "Bangladesh",
    "BE" to "Belgiyom",
    "BF" to "Burkina Faso",
    "BG" to "Bulgariya",
    "BH" to "Baharen",
    "BI" to "Burundi",
    "BJ" to "Binin",
    "BL" to "San Barthélemy",
    "BM" to "Barmuda",
    "BN" to "Burune",
    "BO" to "Bolibiya",
    "BQ" to "Caribbean Netherlands",
    "BR" to "Birazil",
    "BS" to "Bahamas",
    "BT" to "Butan",
    "BV" to "Tsibirin Bouvet",
    "BW" to "Baswana",
    "BY" to "Belarus",
    "BZ" to "Beliz",
    "CA" to "Kanada",
    "CC" to "Tsibirai Cocos (Keeling)",
    "CD" to "Jamhuriyar Dimokuraɗiyyar Kongo",
    "CF" to "Jamhuriyar Afirka Ta Tsakiya",
    "CG" to "Kongo",
    "CH" to "Suwizalan",
    "CI" to "Aibari Kwas",
    "CK" to "Tsibiran Cook",
    "CL" to "Chile",
    "CM" to "Kamaru",
    "CN" to "Sin",
    "CO" to "Kolambiya",
    "CP" to "Tsibirin Clipperton",
    "CR" to "Kwasta Rika",
    "CU" to "Kyuba",
    "CV" to "Tsibiran Cape Verde",
    "CW" to "Ƙasar Curaçao",
    "CX" to "Tsibirin Kirsmati",
    "CY" to "Saifurus",
    "CZ" to "Czechia",
    "DE" to "Jamus",
    "DG" to "Tsibirn Diego Garcia",
    "DJ" to "Jibuti",
    "DK" to "Danmark",
    "DM" to "Dominika",
    "DO" to "Jamhuriyar Dominika",
    "DZ" to "Aljeriya",
    "EA" to "Ceuta da Melilla",
    "EC" to "Ekwador",
    "EE" to "Estoniya",
    "EG" to "Misira",
    "EH" to "Yammacin Sahara",
    "ER" to "Eritireya",
    "ES" to "Sipen",
    "ET" to "Habasha",
    "EU" to "Tarayyar Turai",
    "EZ" to "Sashin Turai",
    "FI" to "Finlan",
    "FJ" to "Fiji",
    "FK" to "Tsibiran Falkilan",
    "FM" to "Mikuronesiya",
    "FO" to "Tsibirai na Faroe",
    "FR" to "Faransa",
    "GA" to "Gabon",
    "GB" to "Biritaniya",
    "GD" to "Girnada",
    "GE" to "Jojiya",
    "GF" to "Gini Ta Faransa",
    "GG" to "Yankin Guernsey",
    "GH" to "Gana",
    "GI" to "Jibaraltar",
    "GL" to "Grinlan",
    "GM" to "Gambiya",
    "GN" to "Gini",
    "GP" to "Gwadaluf",
    "GQ" to "Ikwatoriyal Gini",
    "GR" to "Girka",
    "GS" to "Kudancin Geogia da Kudancin Tsibirin Sandiwic",
    "GT" to "Gwatamala",
    "GU" to "Guam",
    "GW" to "Gini Bisau",
    "GY" to "Guyana",
    "HK" to "Babban Yankin Mulkin Hong Kong na Ƙasar Sin",
    "HM" to "Tsibirin Heard da McDonald",
    "HN" to "Yankin Honduras",
    "HR" to "Kurowaishiya",
    "HT" to "Haiti",
    "HU" to "Hungari",
    "IC" to "Tsibiran Canary",
    "ID" to "Indunusiya",
    "IE" to "Ayalan",
    "IL" to "Israʼila",
    "IM" to "Isle of Man",
    "IN" to "Indiya",
    "IO" to "Yankin Birtaniya Na Tekun Indiya",
    "IQ" to "Iraƙi",
    "IR" to "Iran",
    "IS" to "Aisalan",
    "IT" to "Italiya",
    "JE" to "Kasar Jersey",
    "JM" to "Jamaika",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenya",
    "KG" to "Kirgizistan",
    "KH" to "Kambodiya",
    "KI" to "Kiribati",
    "KM" to "Kwamoras",
    "KN" to "San Kiti Da Nebis",
    "KP" to "Koriya Ta Arewa",
    "KR" to "Koriya Ta Kudu",
    "KW" to "Kuwet",
    "KY" to "Tsibiran Kaiman",
    "KZ" to "Kazakistan",
    "LA" to "Lawos",
    "LB" to "Labanan",
    "LC" to "San Lusiya",
    "LI" to "Licansitan",
    "LK" to "Siri Lanka",
    "LR" to "Laberiya",
    "LS" to "Lesoto",
    "LT" to "Lituweniya",
    "LU" to "Lukusambur",
    "LV" to "Litibiya",
    "LY" to "Libiya",
    "MA" to "Maroko",
    "MC" to "Monako",
    "MD" to "Maldoba",
    "ME" to "Manteneguro",
    "MF" to "San Martin",
    "MG" to "Madagaskar",
    "MH" to "Tsibiran Marshal",
    "MK" to "Macedonia ta Arewa",
    "ML" to "Mali",
    "MM" to "Burma, Miyamar",
    "MN" to "Mangoliya",
    "MO" to "Babban Yankin Mulkin Macao na Ƙasar Sin",
    "MP" to "Tsibiran Mariyana Na Arewa",
    "MQ" to "Martinik",
    "MR" to "Moritaniya",
    "MS" to "Manserati",
    "MT" to "Malta",
    "MU" to "Moritus",
    "MV" to "Maldibi",
    "MW" to "Malawi",
    "MX" to "Mesiko",
    "MY" to "Malesiya",
    "MZ" to "Mozambik",
    "NA" to "Namibiya",
    "NC" to "Kaledoniya Sabuwa",
    "NE" to "Nijar",
    "NF" to "Tsibirin Narfalk",
    "NG" to "Nijeriya",
    "NI" to "Nikaraguwa",
    "NL" to "Holan",
    "NO" to "Norwe",
    "NP" to "Nefal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nuzilan",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Feru",
    "PF" to "Folinesiya Ta Faransa",
    "PG" to "Papuwa Nugini",
    "PH" to "Filipin",
    "PK" to "Pakistan",
    "PL" to "Polan",
    "PM" to "San Piyar da Mikelan",
    "PN" to "Tsibiran Pitcairn",
    "PR" to "Porto Riko",
    "PS" to "Yankunan Palasɗinu",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Faragwai",
    "QA" to "Katar",
    "QO" to "Bakin Teku",
    "RE" to "Rawuniyan",
    "RO" to "Romaniya",
    "RS" to "Sabiya",
    "RU" to "Rasha",
    "RW" to "Ruwanda",
    "SA" to "Saudiyya",
    "SB" to "Tsibiran Salaman",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Suwedan",
    "SG" to "Singapur",
    "SH" to "San Helena",
    "SI" to "Sulobeniya",
    "SJ" to "Svalbard da Jan Mayen",
    "SK" to "Sulobakiya",
    "SL" to "Salewo",
    "SM" to "San Marino",
    "SN" to "Sanigal",
    "SO" to "Somaliya",
    "SR" to "Suriname",
    "SS" to "Sudan ta Kudu",
    "ST" to "Sawo Tome Da Paransip",
    "SV" to "El Salbador",
    "SX" to "San Maarten",
    "SY" to "Sham, Siriya",
    "SZ" to "Eswatini",
    "TA" to "Tritan da Kunha",
    "TC" to "Turkis Da Tsibiran Kaikwas",
    "TD" to "Cadi",
    "TF" to "Yankin Faransi ta Kudu",
    "TG" to "Togo",
    "TH" to "Tailan",
    "TJ" to "Tajikistan",
    "TK" to "Takelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkumenistan",
    "TN" to "Tunisiya",
    "TO" to "Tonga",
    "TR" to "Turkiyya",
    "TT" to "Tirinidad Da Tobago",
    "TV" to "Tubalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzaniya",
    "UA" to "Yukaran",
    "UG" to "Yuganda",
    "UM" to "Rukunin Tsibirin U.S",
    "UN" to "Majalisar Ɗinkin Duniya",
    "US" to "Amurka",
    "UY" to "Yurigwai",
    "UZ" to "Uzubekistan",
    "VA" to "Birnin Batikan",
    "VC" to "San Binsan Da Girnadin",
    "VE" to "Benezuwela",
    "VG" to "Tsibirin Birjin Na Birtaniya",
    "VI" to "Tsibiran Birjin Ta Amurka",
    "VN" to "Biyetinam",
    "VU" to "Banuwatu",
    "WF" to "Walis Da Futuna",
    "WS" to "Samoa",
    "XA" to "Gurɓataccen Karin harshe",
    "XB" to "Gurɓataccen Bidi",
    "XK" to "Kasar Kosovo",
    "YE" to "Yamen",
    "YT" to "Mayoti",
    "ZA" to "Afirka Ta Kudu",
    "ZM" to "Zambiya",
    "ZW" to "Zimbabuwe",
    "ZZ" to "Yanki da ba a sani ba",
  ) }

  val ha_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ha_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val haw: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AU" to "Nūhōlani",
    "CA" to "Kanakā",
    "CN" to "Kina",
    "DE" to "Kelemānia",
    "DK" to "Kenemaka",
    "ES" to "Kepania",
    "FR" to "Palani",
    "GB" to "Aupuni Mōʻī Hui Pū ʻIa",
    "GR" to "Helene",
    "IE" to "ʻIlelani",
    "IL" to "ʻIseraʻela",
    "IN" to "ʻĪnia",
    "IT" to "ʻĪkālia",
    "JP" to "Iāpana",
    "MX" to "Mekiko",
    "NL" to "Hōlani",
    "NZ" to "Aotearoa",
    "PH" to "ʻĀina Pilipino",
    "RU" to "Lūkia",
    "US" to "ʻAmelika Hui Pū ʻIa",
  ) }

  val he: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "העולם",
    "002" to "אפריקה",
    "003" to "צפון אמריקה",
    "005" to "דרום אמריקה",
    "009" to "אוקיאניה",
    "011" to "מערב אפריקה",
    "013" to "מרכז אמריקה",
    "014" to "מזרח אפריקה",
    "015" to "צפון אפריקה",
    "017" to "מרכז אפריקה",
    "018" to "דרום יבשת אפריקה",
    "019" to "אמריקה",
    "021" to "אמריקה הצפונית",
    "029" to "האיים הקריביים",
    "030" to "מזרח אסיה",
    "034" to "דרום אסיה",
    "035" to "דרום־מזרח אסיה",
    "039" to "דרום אירופה",
    "053" to "אוסטרלאסיה",
    "054" to "מלנזיה",
    "057" to "אזור מיקרונזיה",
    "061" to "פולינזיה",
    "142" to "אסיה",
    "143" to "מרכז אסיה",
    "145" to "מערב אסיה",
    "150" to "אירופה",
    "151" to "מזרח אירופה",
    "154" to "צפון אירופה",
    "155" to "מערב אירופה",
    "202" to "אפריקה שמדרום לסהרה",
    "419" to "אמריקה הלטינית",
    "AC" to "האי אסנשן",
    "AD" to "אנדורה",
    "AE" to "איחוד האמירויות הערביות",
    "AF" to "אפגניסטן",
    "AG" to "אנטיגואה וברבודה",
    "AI" to "אנגווילה",
    "AL" to "אלבניה",
    "AM" to "ארמניה",
    "AO" to "אנגולה",
    "AQ" to "אנטארקטיקה",
    "AR" to "ארגנטינה",
    "AS" to "סמואה האמריקנית",
    "AT" to "אוסטריה",
    "AU" to "אוסטרליה",
    "AW" to "ארובה",
    "AX" to "איי אולנד",
    "AZ" to "אזרבייג׳ן",
    "BA" to "בוסניה והרצגובינה",
    "BB" to "ברבדוס",
    "BD" to "בנגלדש",
    "BE" to "בלגיה",
    "BF" to "בורקינה פאסו",
    "BG" to "בולגריה",
    "BH" to "בחריין",
    "BI" to "בורונדי",
    "BJ" to "בנין",
    "BL" to "סנט ברתולומיאו",
    "BM" to "ברמודה",
    "BN" to "ברוניי",
    "BO" to "בוליביה",
    "BQ" to "האיים הקריביים ההולנדיים",
    "BR" to "ברזיל",
    "BS" to "איי בהאמה",
    "BT" to "בהוטן",
    "BV" to "האי בובה",
    "BW" to "בוטסואנה",
    "BY" to "בלארוס",
    "BZ" to "בליז",
    "CA" to "קנדה",
    "CC" to "איי קוקוס (קילינג)",
    "CD" to "קונגו - קינשאסה",
    "CF" to "הרפובליקה המרכז-אפריקאית",
    "CG" to "קונגו - ברזאויל",
    "CH" to "שווייץ",
    "CI" to "חוף השנהב",
    "CK" to "איי קוק",
    "CL" to "צ׳ילה",
    "CM" to "קמרון",
    "CN" to "סין",
    "CO" to "קולומביה",
    "CP" to "האי קליפרטון",
    "CR" to "קוסטה ריקה",
    "CU" to "קובה",
    "CV" to "כף ורדה",
    "CW" to "קוראסאו",
    "CX" to "אי חג המולד",
    "CY" to "קפריסין",
    "CZ" to "צ׳כיה",
    "DE" to "גרמניה",
    "DG" to "דייגו גרסיה",
    "DJ" to "ג׳יבוטי",
    "DK" to "דנמרק",
    "DM" to "דומיניקה",
    "DO" to "הרפובליקה הדומיניקנית",
    "DZ" to "אלג׳יריה",
    "EA" to "סאוטה ומלייה",
    "EC" to "אקוודור",
    "EE" to "אסטוניה",
    "EG" to "מצרים",
    "EH" to "סהרה המערבית",
    "ER" to "אריתריאה",
    "ES" to "ספרד",
    "ET" to "אתיופיה",
    "EU" to "האיחוד האירופי",
    "EZ" to "גוש האירו",
    "FI" to "פינלנד",
    "FJ" to "פיג׳י",
    "FK" to "איי פוקלנד",
    "FM" to "מיקרונזיה",
    "FO" to "איי פארו",
    "FR" to "צרפת",
    "GA" to "גבון",
    "GB" to "בריטניה",
    "GD" to "גרנדה",
    "GE" to "גאורגיה",
    "GF" to "גיאנה הצרפתית",
    "GG" to "גרנזי",
    "GH" to "גאנה",
    "GI" to "גיברלטר",
    "GL" to "גרינלנד",
    "GM" to "גמביה",
    "GN" to "גינאה",
    "GP" to "גוואדלופ",
    "GQ" to "גינאה המשוונית",
    "GR" to "יוון",
    "GS" to "ג׳ורג׳יה הדרומית ואיי סנדוויץ׳ הדרומיים",
    "GT" to "גואטמלה",
    "GU" to "גואם",
    "GW" to "גינאה-ביסאו",
    "GY" to "גיאנה",
    "HK" to "הונג קונג (אזור מנהלי מיוחד של סין)",
    "HM" to "איי הרד ומקדונלד",
    "HN" to "הונדורס",
    "HR" to "קרואטיה",
    "HT" to "האיטי",
    "HU" to "הונגריה",
    "IC" to "האיים הקנריים",
    "ID" to "אינדונזיה",
    "IE" to "אירלנד",
    "IL" to "ישראל",
    "IM" to "האי מאן",
    "IN" to "הודו",
    "IO" to "הטריטוריה הבריטית באוקיינוס ההודי",
    "IQ" to "עיראק",
    "IR" to "איראן",
    "IS" to "איסלנד",
    "IT" to "איטליה",
    "JE" to "ג׳רזי",
    "JM" to "ג׳מייקה",
    "JO" to "ירדן",
    "JP" to "יפן",
    "KE" to "קניה",
    "KG" to "קירגיזסטן",
    "KH" to "קמבודיה",
    "KI" to "קיריבאטי",
    "KM" to "קומורו",
    "KN" to "סנט קיטס ונוויס",
    "KP" to "קוריאה הצפונית",
    "KR" to "קוריאה הדרומית",
    "KW" to "כווית",
    "KY" to "איי קיימן",
    "KZ" to "קזחסטן",
    "LA" to "לאוס",
    "LB" to "לבנון",
    "LC" to "סנט לוסיה",
    "LI" to "ליכטנשטיין",
    "LK" to "סרי לנקה",
    "LR" to "ליבריה",
    "LS" to "לסוטו",
    "LT" to "ליטא",
    "LU" to "לוקסמבורג",
    "LV" to "לטביה",
    "LY" to "לוב",
    "MA" to "מרוקו",
    "MC" to "מונקו",
    "MD" to "מולדובה",
    "ME" to "מונטנגרו",
    "MF" to "סן מרטן",
    "MG" to "מדגסקר",
    "MH" to "איי מרשל",
    "MK" to "מקדוניה הצפונית",
    "ML" to "מאלי",
    "MM" to "מיאנמר (בורמה)",
    "MN" to "מונגוליה",
    "MO" to "מקאו (אזור מנהלי מיוחד של סין)",
    "MP" to "איי מריאנה הצפוניים",
    "MQ" to "מרטיניק",
    "MR" to "מאוריטניה",
    "MS" to "מונסראט",
    "MT" to "מלטה",
    "MU" to "מאוריציוס",
    "MV" to "האיים המלדיביים",
    "MW" to "מלאווי",
    "MX" to "מקסיקו",
    "MY" to "מלזיה",
    "MZ" to "מוזמביק",
    "NA" to "נמיביה",
    "NC" to "קלדוניה החדשה",
    "NE" to "ניז׳ר",
    "NF" to "האי נורפוק",
    "NG" to "ניגריה",
    "NI" to "ניקרגואה",
    "NL" to "הולנד",
    "NO" to "נורווגיה",
    "NP" to "נפאל",
    "NR" to "נאורו",
    "NU" to "ניווה",
    "NZ" to "ניו זילנד",
    "OM" to "עומאן",
    "PA" to "פנמה",
    "PE" to "פרו",
    "PF" to "פולינזיה הצרפתית",
    "PG" to "פפואה גינאה החדשה",
    "PH" to "הפיליפינים",
    "PK" to "פקיסטן",
    "PL" to "פולין",
    "PM" to "סנט פייר ומיקלון",
    "PN" to "איי פיטקרן",
    "PR" to "פוארטו ריקו",
    "PS" to "השטחים הפלסטיניים",
    "PT" to "פורטוגל",
    "PW" to "פלאו",
    "PY" to "פרגוואי",
    "QA" to "קטאר",
    "QO" to "טריטוריות באוקיאניה",
    "RE" to "ראוניון",
    "RO" to "רומניה",
    "RS" to "סרביה",
    "RU" to "רוסיה",
    "RW" to "רואנדה",
    "SA" to "ערב הסעודית",
    "SB" to "איי שלמה",
    "SC" to "איי סיישל",
    "SD" to "סודן",
    "SE" to "שוודיה",
    "SG" to "סינגפור",
    "SH" to "סנט הלנה",
    "SI" to "סלובניה",
    "SJ" to "סבאלברד ויאן מאיין",
    "SK" to "סלובקיה",
    "SL" to "סיירה לאון",
    "SM" to "סן מרינו",
    "SN" to "סנגל",
    "SO" to "סומליה",
    "SR" to "סורינאם",
    "SS" to "דרום סודן",
    "ST" to "סאו טומה ופרינסיפה",
    "SV" to "אל סלבדור",
    "SX" to "סנט מארטן",
    "SY" to "סוריה",
    "SZ" to "אסוואטיני",
    "TA" to "טריסטן דה קונה",
    "TC" to "איי טרקס וקייקוס",
    "TD" to "צ׳אד",
    "TF" to "הטריטוריות הדרומיות של צרפת",
    "TG" to "טוגו",
    "TH" to "תאילנד",
    "TJ" to "טג׳יקיסטן",
    "TK" to "טוקלאו",
    "TL" to "טימור-לסטה",
    "TM" to "טורקמניסטן",
    "TN" to "תוניסיה",
    "TO" to "טונגה",
    "TR" to "טורקיה",
    "TT" to "טרינידד וטובגו",
    "TV" to "טובאלו",
    "TW" to "טייוואן",
    "TZ" to "טנזניה",
    "UA" to "אוקראינה",
    "UG" to "אוגנדה",
    "UM" to "האיים המרוחקים הקטנים של ארה״ב",
    "UN" to "האומות המאוחדות",
    "US" to "ארצות הברית",
    "UY" to "אורוגוואי",
    "UZ" to "אוזבקיסטן",
    "VA" to "הוותיקן",
    "VC" to "סנט וינסנט והגרנדינים",
    "VE" to "ונצואלה",
    "VG" to "איי הבתולה הבריטיים",
    "VI" to "איי הבתולה של ארצות הברית",
    "VN" to "וייטנאם",
    "VU" to "ונואטו",
    "WF" to "איי ווליס ופוטונה",
    "WS" to "סמואה",
    "XA" to "מבטאים חלקיים",
    "XB" to "דו-כיווני חלקי",
    "XK" to "קוסובו",
    "YE" to "תימן",
    "YT" to "מאיוט",
    "ZA" to "דרום אפריקה",
    "ZM" to "זמביה",
    "ZW" to "זימבבואה",
    "ZZ" to "אזור לא ידוע",
  ) }

  val hi: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "विश्व",
    "002" to "अफ़्रीका",
    "003" to "उत्तर अमेरिका",
    "005" to "दक्षिण अमेरिका",
    "009" to "ओशिआनिया",
    "011" to "पश्चिमी अफ़्रीका",
    "013" to "मध्य अमेरिका",
    "014" to "पूर्वी अफ़्रीका",
    "015" to "उत्तरी अफ़्रीका",
    "017" to "मध्य अफ़्रीका",
    "018" to "दक्षिणी अफ़्रीका",
    "019" to "अमेरिकाज़",
    "021" to "उत्तरी अमेरिका",
    "029" to "कैरिबियन",
    "030" to "पूर्वी एशिया",
    "034" to "दक्षिणी एशिया",
    "035" to "दक्षिण-पूर्व एशिया",
    "039" to "दक्षिणी यूरोप",
    "053" to "ऑस्ट्रेलेशिया",
    "054" to "मेलानेशिया",
    "057" to "माइक्रोनेशियाई क्षेत्र",
    "061" to "पोलिनेशिया",
    "142" to "एशिया",
    "143" to "मध्य एशिया",
    "145" to "पश्चिमी एशिया",
    "150" to "यूरोप",
    "151" to "पूर्वी यूरोप",
    "154" to "उत्तरी यूरोप",
    "155" to "पश्चिमी यूरोप",
    "202" to "उप-सहारा अफ़्रीका",
    "419" to "लैटिन अमेरिका",
    "AC" to "असेंशन द्वीप",
    "AD" to "एंडोरा",
    "AE" to "संयुक्त अरब अमीरात",
    "AF" to "अफ़गानिस्तान",
    "AG" to "एंटिगुआ और बरबुडा",
    "AI" to "एंग्विला",
    "AL" to "अल्बानिया",
    "AM" to "आर्मेनिया",
    "AO" to "अंगोला",
    "AQ" to "अंटार्कटिका",
    "AR" to "अर्जेंटीना",
    "AS" to "अमेरिकी समोआ",
    "AT" to "ऑस्ट्रिया",
    "AU" to "ऑस्ट्रेलिया",
    "AW" to "अरूबा",
    "AX" to "एलैंड द्वीपसमूह",
    "AZ" to "अज़रबैजान",
    "BA" to "बोस्निया और हर्ज़ेगोविना",
    "BB" to "बारबाडोस",
    "BD" to "बांग्लादेश",
    "BE" to "बेल्जियम",
    "BF" to "बुर्किना फ़ासो",
    "BG" to "बुल्गारिया",
    "BH" to "बहरीन",
    "BI" to "बुरुंडी",
    "BJ" to "बेनिन",
    "BL" to "सेंट बार्थेलेमी",
    "BM" to "बरमूडा",
    "BN" to "ब्रूनेई",
    "BO" to "बोलीविया",
    "BQ" to "कैरिबियन नीदरलैंड",
    "BR" to "ब्राज़ील",
    "BS" to "बहामास",
    "BT" to "भूटान",
    "BV" to "बोवेत द्वीप",
    "BW" to "बोत्स्वाना",
    "BY" to "बेलारूस",
    "BZ" to "बेलीज़",
    "CA" to "कनाडा",
    "CC" to "कोकोस (कीलिंग) द्वीपसमूह",
    "CD" to "कांगो - किंशासा",
    "CF" to "मध्य अफ़्रीकी गणराज्य",
    "CG" to "कांगो – ब्राज़ाविल",
    "CH" to "स्विट्ज़रलैंड",
    "CI" to "कोत दिवुआर",
    "CK" to "कुक द्वीपसमूह",
    "CL" to "चिली",
    "CM" to "कैमरून",
    "CN" to "चीन",
    "CO" to "कोलंबिया",
    "CP" to "क्लिपर्टन द्वीप",
    "CR" to "कोस्टारिका",
    "CU" to "क्यूबा",
    "CV" to "केप वर्ड",
    "CW" to "कुरासाओ",
    "CX" to "क्रिसमस द्वीप",
    "CY" to "साइप्रस",
    "CZ" to "चेकिया",
    "DE" to "जर्मनी",
    "DG" to "डिएगो गार्सिया",
    "DJ" to "जिबूती",
    "DK" to "डेनमार्क",
    "DM" to "डोमिनिका",
    "DO" to "डोमिनिकन गणराज्य",
    "DZ" to "अल्जीरिया",
    "EA" to "सेउटा और मेलिला",
    "EC" to "इक्वाडोर",
    "EE" to "एस्टोनिया",
    "EG" to "मिस्र",
    "EH" to "पश्चिमी सहारा",
    "ER" to "इरिट्रिया",
    "ES" to "स्पेन",
    "ET" to "इथियोपिया",
    "EU" to "यूरोपीय संघ",
    "EZ" to "यूरोज़ोन",
    "FI" to "फ़िनलैंड",
    "FJ" to "फ़िजी",
    "FK" to "फ़ॉकलैंड द्वीपसमूह",
    "FM" to "माइक्रोनेशिया",
    "FO" to "फ़ेरो द्वीपसमूह",
    "FR" to "फ़्रांस",
    "GA" to "गैबॉन",
    "GB" to "यूनाइटेड किंगडम",
    "GD" to "ग्रेनाडा",
    "GE" to "जॉर्जिया",
    "GF" to "फ़्रेंच गुयाना",
    "GG" to "गर्नसी",
    "GH" to "घाना",
    "GI" to "जिब्राल्टर",
    "GL" to "ग्रीनलैंड",
    "GM" to "गाम्बिया",
    "GN" to "गिनी",
    "GP" to "ग्वाडेलूप",
    "GQ" to "इक्वेटोरियल गिनी",
    "GR" to "यूनान",
    "GS" to "दक्षिण जॉर्जिया और दक्षिण सैंडविच द्वीपसमूह",
    "GT" to "ग्वाटेमाला",
    "GU" to "गुआम",
    "GW" to "गिनी-बिसाउ",
    "GY" to "गुयाना",
    "HK" to "हाँग काँग (चीन विशेष प्रशासनिक क्षेत्र)",
    "HM" to "हर्ड द्वीप और मैकडोनॉल्ड द्वीपसमूह",
    "HN" to "होंडूरास",
    "HR" to "क्रोएशिया",
    "HT" to "हैती",
    "HU" to "हंगरी",
    "IC" to "कैनेरी द्वीपसमूह",
    "ID" to "इंडोनेशिया",
    "IE" to "आयरलैंड",
    "IL" to "इज़राइल",
    "IM" to "आइल ऑफ़ मैन",
    "IN" to "भारत",
    "IO" to "ब्रिटिश हिंद महासागरीय क्षेत्र",
    "IQ" to "इराक",
    "IR" to "ईरान",
    "IS" to "आइसलैंड",
    "IT" to "इटली",
    "JE" to "जर्सी",
    "JM" to "जमैका",
    "JO" to "जॉर्डन",
    "JP" to "जापान",
    "KE" to "केन्या",
    "KG" to "किर्गिज़स्तान",
    "KH" to "कंबोडिया",
    "KI" to "किरिबाती",
    "KM" to "कोमोरोस",
    "KN" to "सेंट किट्स और नेविस",
    "KP" to "उत्तर कोरिया",
    "KR" to "दक्षिण कोरिया",
    "KW" to "कुवैत",
    "KY" to "कैमेन द्वीपसमूह",
    "KZ" to "कज़ाखस्तान",
    "LA" to "लाओस",
    "LB" to "लेबनान",
    "LC" to "सेंट लूसिया",
    "LI" to "लिचेंस्टीन",
    "LK" to "श्रीलंका",
    "LR" to "लाइबेरिया",
    "LS" to "लेसोथो",
    "LT" to "लिथुआनिया",
    "LU" to "लग्ज़मबर्ग",
    "LV" to "लातविया",
    "LY" to "लीबिया",
    "MA" to "मोरक्को",
    "MC" to "मोनाको",
    "MD" to "मॉल्डोवा",
    "ME" to "मोंटेनेग्रो",
    "MF" to "सेंट मार्टिन",
    "MG" to "मेडागास्कर",
    "MH" to "मार्शल द्वीपसमूह",
    "MK" to "उत्तरी मकदूनिया",
    "ML" to "माली",
    "MM" to "म्यांमार (बर्मा)",
    "MN" to "मंगोलिया",
    "MO" to "मकाऊ (विशेष प्रशासनिक क्षेत्र चीन)",
    "MP" to "उत्तरी मारियाना द्वीपसमूह",
    "MQ" to "मार्टीनिक",
    "MR" to "मॉरिटानिया",
    "MS" to "मोंटसेरात",
    "MT" to "माल्टा",
    "MU" to "मॉरीशस",
    "MV" to "मालदीव",
    "MW" to "मलावी",
    "MX" to "मैक्सिको",
    "MY" to "मलेशिया",
    "MZ" to "मोज़ांबिक",
    "NA" to "नामीबिया",
    "NC" to "न्यू कैलेडोनिया",
    "NE" to "नाइजर",
    "NF" to "नॉरफ़ॉक द्वीप",
    "NG" to "नाइजीरिया",
    "NI" to "निकारागुआ",
    "NL" to "नीदरलैंड",
    "NO" to "नॉर्वे",
    "NP" to "नेपाल",
    "NR" to "नाउरु",
    "NU" to "नीयू",
    "NZ" to "न्यूज़ीलैंड",
    "OM" to "ओमान",
    "PA" to "पनामा",
    "PE" to "पेरू",
    "PF" to "फ़्रेंच पोलिनेशिया",
    "PG" to "पापुआ न्यू गिनी",
    "PH" to "फ़िलिपींस",
    "PK" to "पाकिस्तान",
    "PL" to "पोलैंड",
    "PM" to "सेंट पिएरे और मिक्वेलान",
    "PN" to "पिटकैर्न द्वीपसमूह",
    "PR" to "पोर्टो रिको",
    "PS" to "फ़िलिस्तीनी क्षेत्र",
    "PT" to "पुर्तगाल",
    "PW" to "पलाऊ",
    "PY" to "पराग्वे",
    "QA" to "क़तर",
    "QO" to "आउटलाइंग ओशिनिया",
    "RE" to "रियूनियन",
    "RO" to "रोमानिया",
    "RS" to "सर्बिया",
    "RU" to "रूस",
    "RW" to "रवांडा",
    "SA" to "सऊदी अरब",
    "SB" to "सोलोमन द्वीपसमूह",
    "SC" to "सेशेल्स",
    "SD" to "सूडान",
    "SE" to "स्वीडन",
    "SG" to "सिंगापुर",
    "SH" to "सेंट हेलेना",
    "SI" to "स्लोवेनिया",
    "SJ" to "स्वालबार्ड और जान मायेन",
    "SK" to "स्लोवाकिया",
    "SL" to "सिएरा लियोन",
    "SM" to "सैन मेरीनो",
    "SN" to "सेनेगल",
    "SO" to "सोमालिया",
    "SR" to "सूरीनाम",
    "SS" to "दक्षिण सूडान",
    "ST" to "साओ टोम और प्रिंसिपे",
    "SV" to "अल सल्वाडोर",
    "SX" to "सिंट मार्टिन",
    "SY" to "सीरिया",
    "SZ" to "एस्वाटिनी",
    "TA" to "ट्रिस्टन दा कुना",
    "TC" to "तुर्क और कैकोज़ द्वीपसमूह",
    "TD" to "चाड",
    "TF" to "फ़्रांसीसी दक्षिणी क्षेत्र",
    "TG" to "टोगो",
    "TH" to "थाईलैंड",
    "TJ" to "ताजिकिस्तान",
    "TK" to "तोकेलाउ",
    "TL" to "तिमोर-लेस्त",
    "TM" to "तुर्कमेनिस्तान",
    "TN" to "ट्यूनीशिया",
    "TO" to "टोंगा",
    "TR" to "तुर्किये",
    "TT" to "त्रिनिदाद और टोबैगो",
    "TV" to "तुवालू",
    "TW" to "ताइवान",
    "TZ" to "तंज़ानिया",
    "UA" to "यूक्रेन",
    "UG" to "युगांडा",
    "UM" to "यू॰एस॰ आउटलाइंग द्वीपसमूह",
    "UN" to "संयुक्त राष्ट्र",
    "US" to "संयुक्त राज्य",
    "UY" to "उरूग्वे",
    "UZ" to "उज़्बेकिस्तान",
    "VA" to "वेटिकन सिटी",
    "VC" to "सेंट विंसेंट और ग्रेनाडाइंस",
    "VE" to "वेनेज़ुएला",
    "VG" to "ब्रिटिश वर्जिन द्वीपसमूह",
    "VI" to "यू॰एस॰ वर्जिन द्वीपसमूह",
    "VN" to "वियतनाम",
    "VU" to "वनुआतू",
    "WF" to "वालिस और फ़्यूचूना",
    "WS" to "समोआ",
    "XA" to "सूडो-एक्सेंट",
    "XB" to "सूडो-बायडायरेक्शनल",
    "XK" to "कोसोवो",
    "YE" to "यमन",
    "YT" to "मायोते",
    "ZA" to "दक्षिण अफ़्रीका",
    "ZM" to "ज़ाम्बिया",
    "ZW" to "ज़िम्बाब्वे",
    "ZZ" to "अज्ञात क्षेत्र",
  ) }

  val hi_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "world",
    "002" to "Africa",
    "003" to "North America",
    "005" to "South America",
    "009" to "Oceania",
    "011" to "Western Africa",
    "013" to "Central America",
    "014" to "Eastern Africa",
    "015" to "Northern Africa",
    "017" to "Middle Africa",
    "018" to "Southern Africa",
    "019" to "Americas",
    "021" to "Northern America",
    "029" to "Caribbean",
    "030" to "Eastern Asia",
    "034" to "Southern Asia",
    "035" to "Southeast Asia",
    "039" to "Southern Europe",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Micronesian Region",
    "061" to "Polynesia",
    "142" to "Asia",
    "143" to "Central Asia",
    "145" to "Western Asia",
    "150" to "Europe",
    "151" to "Eastern Europe",
    "154" to "Northern Europe",
    "155" to "Western Europe",
    "202" to "Sub-Saharan Africa",
    "419" to "Latin America",
    "AC" to "Ascension Island",
    "AD" to "Andorra",
    "AE" to "United Arab Emirates",
    "AF" to "Afghanistan",
    "AG" to "Antigua & Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarctica",
    "AR" to "Argentina",
    "AS" to "American Samoa",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Aland Islands",
    "AZ" to "Azerbaijan",
    "BA" to "Bosnia & Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgium",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthelemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Caribbean Netherlands",
    "BR" to "Brazil",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Bouvet Island",
    "BW" to "Botswana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Cocos (Keeling) Islands",
    "CD" to "Congo - Kinshasa",
    "CF" to "Central African Republic",
    "CG" to "Congo - Brazzaville",
    "CH" to "Switzerland",
    "CI" to "Cote d’Ivoire",
    "CK" to "Cook Islands",
    "CL" to "Chile",
    "CM" to "Cameroon",
    "CN" to "China",
    "CO" to "Colombia",
    "CP" to "Clipperton Island",
    "CQ" to "Sark",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cape Verde",
    "CW" to "Curacao",
    "CX" to "Christmas Island",
    "CY" to "Cyprus",
    "CZ" to "Czechia",
    "DE" to "Germany",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Denmark",
    "DM" to "Dominica",
    "DO" to "Dominican Republic",
    "DZ" to "Algeria",
    "EA" to "Ceuta & Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egypt",
    "EH" to "Western Sahara",
    "ER" to "Eritrea",
    "ES" to "Spain",
    "ET" to "Ethiopia",
    "EU" to "European Union",
    "EZ" to "Eurozone",
    "FI" to "Finland",
    "FJ" to "Fiji",
    "FK" to "Falkland Islands",
    "FM" to "Micronesia",
    "FO" to "Faroe Islands",
    "FR" to "France",
    "GA" to "Gabon",
    "GB" to "United Kingdom",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "French Guiana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Greenland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Equatorial Guinea",
    "GR" to "Greece",
    "GS" to "South Georgia & South Sandwich Islands",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong SAR China",
    "HM" to "Heard & McDonald Islands",
    "HN" to "Honduras",
    "HR" to "Croatia",
    "HT" to "Haiti",
    "HU" to "Hungary",
    "IC" to "Canary Islands",
    "ID" to "Indonesia",
    "IE" to "Ireland",
    "IL" to "Israel",
    "IM" to "Isle of Man",
    "IN" to "Bharat",
    "IO" to "British Indian Ocean Territory",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Iceland",
    "IT" to "Italy",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenya",
    "KG" to "Kyrgyzstan",
    "KH" to "Cambodia",
    "KI" to "Kiribati",
    "KM" to "Comoros",
    "KN" to "St. Kitts & Nevis",
    "KP" to "North Korea",
    "KR" to "South Korea",
    "KW" to "Kuwait",
    "KY" to "Cayman Islands",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Lebanon",
    "LC" to "St. Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lithuania",
    "LU" to "Luxembourg",
    "LV" to "Latvia",
    "LY" to "Libya",
    "MA" to "Morocco",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "St. Martin",
    "MG" to "Madagascar",
    "MH" to "Marshall Islands",
    "MK" to "North Macedonia",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Macao SAR China",
    "MP" to "Northern Mariana Islands",
    "MQ" to "Martinique",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldives",
    "MW" to "Malawi",
    "MX" to "Mexico",
    "MY" to "Malaysia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "New Caledonia",
    "NE" to "Niger",
    "NF" to "Norfolk Island",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Netherlands",
    "NO" to "Norway",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "New Zealand",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "French Polynesia",
    "PG" to "Papua New Guinea",
    "PH" to "Philippines",
    "PK" to "Pakistan",
    "PL" to "Poland",
    "PM" to "St. Pierre & Miquelon",
    "PN" to "Pitcairn Islands",
    "PR" to "Puerto Rico",
    "PS" to "Palestinian Territories",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Outlying Oceania",
    "RE" to "Reunion",
    "RO" to "Romania",
    "RS" to "Serbia",
    "RU" to "Russia",
    "RW" to "Rwanda",
    "SA" to "Saudi Arabia",
    "SB" to "Solomon Islands",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Sweden",
    "SG" to "Singapore",
    "SH" to "St. Helena",
    "SI" to "Slovenia",
    "SJ" to "Svalbard & Jan Mayen",
    "SK" to "Slovakia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "South Sudan",
    "ST" to "Sao Tome & Principe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks & Caicos Islands",
    "TD" to "Chad",
    "TF" to "French Southern Territories",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tajikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turkiye",
    "TT" to "Trinidad & Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraine",
    "UG" to "Uganda",
    "UM" to "U.S. Outlying Islands",
    "UN" to "United Nations",
    "US" to "United States",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Vatican City",
    "VC" to "St. Vincent & Grenadines",
    "VE" to "Venezuela",
    "VG" to "British Virgin Islands",
    "VI" to "U.S. Virgin Islands",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis & Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo-Accents",
    "XB" to "Pseudo-Bidirectional",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "South Africa",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Unknown Region",
  ) }

  val hnj: ImmutableMap<String, String> by lazy { immutableMapOf(
    "US" to "𞄒𞄫𞄱𞄔𞄩𞄴",
  ) }

  val hnj_Hmnp: ImmutableMap<String, String> by lazy { immutableMapOf(
    "US" to "𞄒𞄫𞄱𞄔𞄩𞄴",
  ) }

  val hr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Svijet",
    "002" to "Afrika",
    "003" to "Sjevernoamerički kontinent",
    "005" to "Južna Amerika",
    "009" to "Oceanija",
    "011" to "Zapadna Afrika",
    "013" to "Centralna Amerika",
    "014" to "Istočna Afrika",
    "015" to "Sjeverna Afrika",
    "017" to "Središnja Afrika",
    "018" to "Južna Afrika",
    "019" to "Amerike",
    "021" to "Sjeverna Amerika",
    "029" to "Karibi",
    "030" to "Istočna Azija",
    "034" to "Južna Azija",
    "035" to "Jugoistočna Azija",
    "039" to "Južna Europa",
    "053" to "Australazija",
    "054" to "Melanezija",
    "057" to "Mikronezijsko područje",
    "061" to "Polinezija",
    "142" to "Azija",
    "143" to "Srednja Azija",
    "145" to "Zapadna Azija",
    "150" to "Europa",
    "151" to "Istočna Europa",
    "154" to "Sjeverna Europa",
    "155" to "Zapadna Europa",
    "202" to "Subsaharska Afrika",
    "419" to "Latinska Amerika",
    "AC" to "Otok Uzašašća",
    "AD" to "Andora",
    "AE" to "Ujedinjeni Arapski Emirati",
    "AF" to "Afganistan",
    "AG" to "Antigva i Barbuda",
    "AI" to "Angvila",
    "AL" to "Albanija",
    "AM" to "Armenija",
    "AO" to "Angola",
    "AQ" to "Antarktika",
    "AR" to "Argentina",
    "AS" to "Američka Samoa",
    "AT" to "Austrija",
    "AU" to "Australija",
    "AW" to "Aruba",
    "AX" to "Ålandski otoci",
    "AZ" to "Azerbajdžan",
    "BA" to "Bosna i Hercegovina",
    "BB" to "Barbados",
    "BD" to "Bangladeš",
    "BE" to "Belgija",
    "BF" to "Burkina Faso",
    "BG" to "Bugarska",
    "BH" to "Bahrein",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint Barthélemy",
    "BM" to "Bermudi",
    "BN" to "Brunej",
    "BO" to "Bolivija",
    "BQ" to "Karipski otoci Nizozemske",
    "BR" to "Brazil",
    "BS" to "Bahami",
    "BT" to "Butan",
    "BV" to "Otok Bouvet",
    "BW" to "Bocvana",
    "BY" to "Bjelorusija",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kokosovi (Keelingovi) Otoci",
    "CD" to "Kongo - Kinshasa",
    "CF" to "Srednjoafrička Republika",
    "CG" to "Kongo - Brazzaville",
    "CH" to "Švicarska",
    "CI" to "Obala Bjelokosti",
    "CK" to "Cookovi Otoci",
    "CL" to "Čile",
    "CM" to "Kamerun",
    "CN" to "Kina",
    "CO" to "Kolumbija",
    "CP" to "Otok Clipperton",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Zelenortska Republika",
    "CW" to "Curaçao",
    "CX" to "Božićni Otok",
    "CY" to "Cipar",
    "CZ" to "Češka",
    "DE" to "Njemačka",
    "DG" to "Diego Garcia",
    "DJ" to "Džibuti",
    "DK" to "Danska",
    "DM" to "Dominika",
    "DO" to "Dominikanska Republika",
    "DZ" to "Alžir",
    "EA" to "Ceuta i Melilla",
    "EC" to "Ekvador",
    "EE" to "Estonija",
    "EG" to "Egipat",
    "EH" to "Zapadna Sahara",
    "ER" to "Eritreja",
    "ES" to "Španjolska",
    "ET" to "Etiopija",
    "EU" to "Europska unija",
    "EZ" to "eurozona",
    "FI" to "Finska",
    "FJ" to "Fidži",
    "FK" to "Falklandski Otoci",
    "FM" to "Mikronezija",
    "FO" to "Ovčji Otoci",
    "FR" to "Francuska",
    "GA" to "Gabon",
    "GB" to "Ujedinjeno Kraljevstvo",
    "GD" to "Grenada",
    "GE" to "Gruzija",
    "GF" to "Francuska Gijana",
    "GG" to "Guernsey",
    "GH" to "Gana",
    "GI" to "Gibraltar",
    "GL" to "Grenland",
    "GM" to "Gambija",
    "GN" to "Gvineja",
    "GP" to "Guadalupe",
    "GQ" to "Ekvatorska Gvineja",
    "GR" to "Grčka",
    "GS" to "Južna Georgia i Otoci Južni Sandwich",
    "GT" to "Gvatemala",
    "GU" to "Guam",
    "GW" to "Gvineja Bisau",
    "GY" to "Gvajana",
    "HK" to "PUP Hong Kong Kina",
    "HM" to "Otoci Heard i McDonald",
    "HN" to "Honduras",
    "HR" to "Hrvatska",
    "HT" to "Haiti",
    "HU" to "Mađarska",
    "IC" to "Kanari",
    "ID" to "Indonezija",
    "IE" to "Irska",
    "IL" to "Izrael",
    "IM" to "Otok Man",
    "IN" to "Indija",
    "IO" to "Britanski Indijskooceanski Teritorij",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Island",
    "IT" to "Italija",
    "JE" to "Jersey",
    "JM" to "Jamajka",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenija",
    "KG" to "Kirgistan",
    "KH" to "Kambodža",
    "KI" to "Kiribati",
    "KM" to "Komori",
    "KN" to "Sveti Kristofor i Nevis",
    "KP" to "Sjeverna Koreja",
    "KR" to "Južna Koreja",
    "KW" to "Kuvajt",
    "KY" to "Kajmanski Otoci",
    "KZ" to "Kazahstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "Sveta Lucija",
    "LI" to "Lihtenštajn",
    "LK" to "Šri Lanka",
    "LR" to "Liberija",
    "LS" to "Lesoto",
    "LT" to "Litva",
    "LU" to "Luksemburg",
    "LV" to "Latvija",
    "LY" to "Libija",
    "MA" to "Maroko",
    "MC" to "Monako",
    "MD" to "Moldavija",
    "ME" to "Crna Gora",
    "MF" to "Saint Martin",
    "MG" to "Madagaskar",
    "MH" to "Maršalovi Otoci",
    "MK" to "Sjeverna Makedonija",
    "ML" to "Mali",
    "MM" to "Mjanmar (Burma)",
    "MN" to "Mongolija",
    "MO" to "PUP Makao Kina",
    "MP" to "Sjevernomarijanski Otoci",
    "MQ" to "Martinik",
    "MR" to "Mauretanija",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauricijus",
    "MV" to "Maldivi",
    "MW" to "Malavi",
    "MX" to "Meksiko",
    "MY" to "Malezija",
    "MZ" to "Mozambik",
    "NA" to "Namibija",
    "NC" to "Nova Kaledonija",
    "NE" to "Niger",
    "NF" to "Otok Norfolk",
    "NG" to "Nigerija",
    "NI" to "Nikaragva",
    "NL" to "Nizozemska",
    "NO" to "Norveška",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Novi Zeland",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Francuska Polinezija",
    "PG" to "Papua Nova Gvineja",
    "PH" to "Filipini",
    "PK" to "Pakistan",
    "PL" to "Poljska",
    "PM" to "Sveti Petar i Mikelon",
    "PN" to "Pitcairnovi Otoci",
    "PR" to "Portoriko",
    "PS" to "Palestinsko područje",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paragvaj",
    "QA" to "Katar",
    "QO" to "Vanjska područja Oceanije",
    "RE" to "Réunion",
    "RO" to "Rumunjska",
    "RS" to "Srbija",
    "RU" to "Rusija",
    "RW" to "Ruanda",
    "SA" to "Saudijska Arabija",
    "SB" to "Salomonovi Otoci",
    "SC" to "Sejšeli",
    "SD" to "Sudan",
    "SE" to "Švedska",
    "SG" to "Singapur",
    "SH" to "Sveta Helena",
    "SI" to "Slovenija",
    "SJ" to "Svalbard i Jan Mayen",
    "SK" to "Slovačka",
    "SL" to "Sijera Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalija",
    "SR" to "Surinam",
    "SS" to "Južni Sudan",
    "ST" to "Sveti Toma i Princip",
    "SV" to "Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Sirija",
    "SZ" to "Esvatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Otoci Turks i Caicos",
    "TD" to "Čad",
    "TF" to "Francuski Južni Teritoriji",
    "TG" to "Togo",
    "TH" to "Tajland",
    "TJ" to "Tadžikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunis",
    "TO" to "Tonga",
    "TR" to "Turska",
    "TT" to "Trinidad i Tobago",
    "TV" to "Tuvalu",
    "TW" to "Tajvan",
    "TZ" to "Tanzanija",
    "UA" to "Ukrajina",
    "UG" to "Uganda",
    "UM" to "Mali udaljeni otoci SAD-a",
    "UN" to "Ujedinjeni narodi",
    "US" to "Sjedinjene Američke Države",
    "UY" to "Urugvaj",
    "UZ" to "Uzbekistan",
    "VA" to "Vatikan",
    "VC" to "Sveti Vincent i Grenadini",
    "VE" to "Venezuela",
    "VG" to "Britanski Djevičanski Otoci",
    "VI" to "Američki Djevičanski Otoci",
    "VN" to "Vijetnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis i Futuna",
    "WS" to "Samoa",
    "XA" to "pseudo naglasci",
    "XB" to "pseudo bidi",
    "XK" to "Kosovo",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Južnoafrička Republika",
    "ZM" to "Zambija",
    "ZW" to "Zimbabve",
    "ZZ" to "nepoznato područje",
  ) }

  val hr_BA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val hsb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "swět",
    "002" to "Afrika",
    "003" to "Sewjerna Amerika",
    "005" to "Južna Amerika",
    "009" to "Oceaniska",
    "011" to "zapadna Afrika",
    "013" to "Srjedźna Amerika",
    "014" to "wuchodna Afrika",
    "015" to "sewjerna Afrika",
    "017" to "srjedźna Afrika",
    "018" to "južna Afrika",
    "019" to "Amerika",
    "021" to "sewjerny ameriski kontinent",
    "029" to "Karibika",
    "030" to "wuchodna Azija",
    "034" to "južna Azija",
    "035" to "juhowuchodna Azija",
    "039" to "južna Europa",
    "053" to "Awstralazija",
    "054" to "Melaneziska",
    "057" to "Mikroneziska (kupowy region)",
    "061" to "Polyneziska",
    "142" to "Azija",
    "143" to "centralna Azija",
    "145" to "zapadna Azija",
    "150" to "Europa",
    "151" to "wuchodna Europa",
    "154" to "sewjerna Europa",
    "155" to "zapadna Europa",
    "202" to "subsaharaska Afrika",
    "419" to "Łaćonska Amerika",
    "AC" to "Ascension",
    "AD" to "Andorra",
    "AE" to "Zjednoćene arabske emiraty",
    "AF" to "Afghanistan",
    "AG" to "Antigua a Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albanska",
    "AM" to "Armenska",
    "AO" to "Angola",
    "AQ" to "Antarktika",
    "AR" to "Argentinska",
    "AS" to "Ameriska Samoa",
    "AT" to "Awstriska",
    "AU" to "Awstralska",
    "AW" to "Aruba",
    "AX" to "Åland",
    "AZ" to "Azerbajdźan",
    "BA" to "Bosniska a Hercegowina",
    "BB" to "Barbados",
    "BD" to "Bangladeš",
    "BE" to "Belgiska",
    "BF" to "Burkina Faso",
    "BG" to "Bołharska",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthélemy",
    "BM" to "Bermudy",
    "BN" to "Brunei",
    "BO" to "Boliwiska",
    "BQ" to "Karibiska Nižozemska",
    "BR" to "Brazilska",
    "BS" to "Bahamy",
    "BT" to "Bhutan",
    "BV" to "Bouvetowa kupa",
    "BW" to "Botswana",
    "BY" to "Běłoruska",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kokosowe kupy",
    "CD" to "Kongo-Kinshasa",
    "CF" to "Centralnoafriska republika",
    "CG" to "Kongo-Brazzaville",
    "CH" to "Šwicarska",
    "CI" to "Côte d’Ivoire",
    "CK" to "Cookowe kupy",
    "CL" to "Chilska",
    "CM" to "Kamerun",
    "CN" to "China",
    "CO" to "Kolumbiska",
    "CP" to "Clippertonowa kupa",
    "CR" to "Kosta Rika",
    "CU" to "Kuba",
    "CV" to "Kap Verde",
    "CW" to "Curaçao",
    "CX" to "Hodowna kupa",
    "CY" to "Cypern",
    "CZ" to "Čěska republika",
    "DE" to "Němska",
    "DG" to "Diego Garcia",
    "DJ" to "Dźibuti",
    "DK" to "Danska",
    "DM" to "Dominika",
    "DO" to "Dominikanska republika",
    "DZ" to "Algeriska",
    "EA" to "Ceuta a Melilla",
    "EC" to "Ekwador",
    "EE" to "Estiska",
    "EG" to "Egyptowska",
    "EH" to "Zapadna Sahara",
    "ER" to "Eritreja",
    "ES" to "Španiska",
    "ET" to "Etiopiska",
    "EU" to "Europska unija",
    "EZ" to "europasmo",
    "FI" to "Finska",
    "FJ" to "Fidźi",
    "FK" to "Falklandske kupy",
    "FM" to "Mikroneziska",
    "FO" to "Färöske kupy",
    "FR" to "Francoska",
    "GA" to "Gabun",
    "GB" to "Zjednoćene kralestwo",
    "GD" to "Grenada",
    "GE" to "Georgiska",
    "GF" to "Francoska Guyana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Grönlandska",
    "GM" to "Gambija",
    "GN" to "Gineja",
    "GP" to "Guadeloupe",
    "GQ" to "Ekwatorialna Gineja",
    "GR" to "Grjekska",
    "GS" to "Južna Georgiska a Južne Sandwichowe kupy",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Gineja-Bissau",
    "GY" to "Guyana",
    "HK" to "Wosebita zarjadniska cona Hongkong",
    "HM" to "Heardowa kupa a McDonaldowe kupy",
    "HN" to "Honduras",
    "HR" to "Chorwatska",
    "HT" to "Haiti",
    "HU" to "Madźarska",
    "IC" to "Kanariske kupy",
    "ID" to "Indoneska",
    "IE" to "Irska",
    "IL" to "Israel",
    "IM" to "Man",
    "IN" to "Indiska",
    "IO" to "Britiski teritorij w Indiskim oceanje",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Islandska",
    "IT" to "Italska",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Jordaniska",
    "JP" to "Japanska",
    "KE" to "Kenija",
    "KG" to "Kirgizistan",
    "KH" to "Kambodźa",
    "KI" to "Kiribati",
    "KM" to "Komory",
    "KN" to "St. Kitts a Nevis",
    "KP" to "Sewjerna Koreja",
    "KR" to "Južna Koreja",
    "KW" to "Kuwait",
    "KY" to "Kajmanske kupy",
    "KZ" to "Kazachstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "St. Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberija",
    "LS" to "Lesotho",
    "LT" to "Litawska",
    "LU" to "Luxemburgska",
    "LV" to "Letiska",
    "LY" to "Libyska",
    "MA" to "Marokko",
    "MC" to "Monaco",
    "MD" to "Moldawska",
    "ME" to "Montenegro",
    "MF" to "St. Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshallowe kupy",
    "MK" to "Serwjerna Makedonska",
    "ML" to "Mali",
    "MM" to "Myanmar",
    "MN" to "Mongolska",
    "MO" to "Wosebita zarjadniska cona Macao",
    "MP" to "Sewjerne Mariany",
    "MQ" to "Martinique",
    "MR" to "Mawretanska",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Malediwy",
    "MW" to "Malawi",
    "MX" to "Mexiko",
    "MY" to "Malajzija",
    "MZ" to "Mosambik",
    "NA" to "Namibija",
    "NC" to "Nowa Kaledoniska",
    "NE" to "Niger",
    "NF" to "Norfolkowa kupa",
    "NG" to "Nigerija",
    "NI" to "Nikaragua",
    "NL" to "Nižozemska",
    "NO" to "Norwegska",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nowoseelandska",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Francoska Polyneziska",
    "PG" to "Papuwa-Nowa Gineja",
    "PH" to "Filipiny",
    "PK" to "Pakistan",
    "PL" to "Pólska",
    "PM" to "St. Pierre a Miquelon",
    "PN" to "Pitcairnowe kupy",
    "PR" to "Puerto Rico",
    "PS" to "Palestinski awtonomny teritorij",
    "PT" to "Portugalska",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Katar",
    "QO" to "Wonkowna Oceaniska",
    "RE" to "Réunion",
    "RO" to "Rumunska",
    "RS" to "Serbiska",
    "RU" to "Ruska",
    "RW" to "Ruanda",
    "SA" to "Sawdi-Arabska",
    "SB" to "Salomony",
    "SC" to "Seychelle",
    "SD" to "Sudan",
    "SE" to "Šwedska",
    "SG" to "Singapur",
    "SH" to "St. Helena",
    "SI" to "Słowjenska",
    "SJ" to "Svalbard a Jan Mayen",
    "SK" to "Słowakska",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalija",
    "SR" to "Surinam",
    "SS" to "Južny Sudan",
    "ST" to "São Tomé a Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syriska",
    "SZ" to "Swaziska",
    "TA" to "Tristan da Cunha",
    "TC" to "kupy Turks a Caicos",
    "TD" to "Čad",
    "TF" to "Francoski južny a antarktiski teritorij",
    "TG" to "Togo",
    "TH" to "Thailandska",
    "TJ" to "Tadźikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmeniska",
    "TN" to "Tuneziska",
    "TO" to "Tonga",
    "TR" to "Turkowska",
    "TT" to "Trinidad a Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tansanija",
    "UA" to "Ukraina",
    "UG" to "Uganda",
    "UM" to "Ameriska Oceaniska",
    "UN" to "Zjednoćene narody",
    "US" to "Zjednoćene staty Ameriki",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Vatikanske město",
    "VC" to "St. Vincent a Grenadiny",
    "VE" to "Venezuela",
    "VG" to "Britiske knježniske kupy",
    "VI" to "Ameriske knježniske kupy",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis a Futuna",
    "WS" to "Samoa",
    "XA" to "pseudo-akcenty",
    "XB" to "pseudo-bidi",
    "XK" to "Kosowo",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Južna Afrika (Republika)",
    "ZM" to "Sambija",
    "ZW" to "Simbabwe",
    "ZZ" to "njeznaty region",
  ) }

  val hu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Világ",
    "002" to "Afrika",
    "003" to "Észak-Amerika",
    "005" to "Dél-Amerika",
    "009" to "Óceánia",
    "011" to "Nyugat-Afrika",
    "013" to "Közép-Amerika",
    "014" to "Kelet-Afrika",
    "015" to "Észak-Afrika",
    "017" to "Közép-Afrika",
    "018" to "Afrika déli része",
    "019" to "Amerika",
    "021" to "Amerika északi része",
    "029" to "Karib-térség",
    "030" to "Kelet-Ázsia",
    "034" to "Dél-Ázsia",
    "035" to "Délkelet-Ázsia",
    "039" to "Dél-Európa",
    "053" to "Ausztrálázsia",
    "054" to "Melanézia",
    "057" to "Mikronéziai régió",
    "061" to "Polinézia",
    "142" to "Ázsia",
    "143" to "Közép-Ázsia",
    "145" to "Nyugat-Ázsia",
    "150" to "Európa",
    "151" to "Kelet-Európa",
    "154" to "Észak-Európa",
    "155" to "Nyugat-Európa",
    "202" to "Szubszaharai Afrika",
    "419" to "Latin-Amerika",
    "AC" to "Ascension-sziget",
    "AD" to "Andorra",
    "AE" to "Egyesült Arab Emírségek",
    "AF" to "Afganisztán",
    "AG" to "Antigua és Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albánia",
    "AM" to "Örményország",
    "AO" to "Angola",
    "AQ" to "Antarktisz",
    "AR" to "Argentína",
    "AS" to "Amerikai Szamoa",
    "AT" to "Ausztria",
    "AU" to "Ausztrália",
    "AW" to "Aruba",
    "AX" to "Åland-szigetek",
    "AZ" to "Azerbajdzsán",
    "BA" to "Bosznia-Hercegovina",
    "BB" to "Barbados",
    "BD" to "Banglades",
    "BE" to "Belgium",
    "BF" to "Burkina Faso",
    "BG" to "Bulgária",
    "BH" to "Bahrein",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint-Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolívia",
    "BQ" to "Holland Karib-térség",
    "BR" to "Brazília",
    "BS" to "Bahama-szigetek",
    "BT" to "Bhután",
    "BV" to "Bouvet-sziget",
    "BW" to "Botswana",
    "BY" to "Belarusz",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kókusz (Keeling)-szigetek",
    "CD" to "Kongó – Kinshasa",
    "CF" to "Közép-afrikai Köztársaság",
    "CG" to "Kongó – Brazzaville",
    "CH" to "Svájc",
    "CI" to "Elefántcsontpart",
    "CK" to "Cook-szigetek",
    "CL" to "Chile",
    "CM" to "Kamerun",
    "CN" to "Kína",
    "CO" to "Kolumbia",
    "CP" to "Clipperton-sziget",
    "CQ" to "Sark",
    "CR" to "Costa Rica",
    "CU" to "Kuba",
    "CV" to "Zöld-foki Köztársaság",
    "CW" to "Curaçao",
    "CX" to "Karácsony-sziget",
    "CY" to "Ciprus",
    "CZ" to "Csehország",
    "DE" to "Németország",
    "DG" to "Diego Garcia",
    "DJ" to "Dzsibuti",
    "DK" to "Dánia",
    "DM" to "Dominika",
    "DO" to "Dominikai Köztársaság",
    "DZ" to "Algéria",
    "EA" to "Ceuta és Melilla",
    "EC" to "Ecuador",
    "EE" to "Észtország",
    "EG" to "Egyiptom",
    "EH" to "Nyugat-Szahara",
    "ER" to "Eritrea",
    "ES" to "Spanyolország",
    "ET" to "Etiópia",
    "EU" to "Európai Unió",
    "EZ" to "Eurózóna",
    "FI" to "Finnország",
    "FJ" to "Fidzsi",
    "FK" to "Falkland-szigetek",
    "FM" to "Mikronézia",
    "FO" to "Feröer szigetek",
    "FR" to "Franciaország",
    "GA" to "Gabon",
    "GB" to "Egyesült Királyság",
    "GD" to "Grenada",
    "GE" to "Grúzia",
    "GF" to "Francia Guyana",
    "GG" to "Guernsey",
    "GH" to "Ghána",
    "GI" to "Gibraltár",
    "GL" to "Grönland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Egyenlítői-Guinea",
    "GR" to "Görögország",
    "GS" to "Déli-Georgia és Déli-Sandwich-szigetek",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Bissau-Guinea",
    "GY" to "Guyana",
    "HK" to "Hongkong KKT",
    "HM" to "Heard-sziget és McDonald-szigetek",
    "HN" to "Honduras",
    "HR" to "Horvátország",
    "HT" to "Haiti",
    "HU" to "Magyarország",
    "IC" to "Kanári-szigetek",
    "ID" to "Indonézia",
    "IE" to "Írország",
    "IL" to "Izrael",
    "IM" to "Man-sziget",
    "IN" to "India",
    "IO" to "Brit Indiai-óceáni Terület",
    "IQ" to "Irak",
    "IR" to "Irán",
    "IS" to "Izland",
    "IT" to "Olaszország",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordánia",
    "JP" to "Japán",
    "KE" to "Kenya",
    "KG" to "Kirgizisztán",
    "KH" to "Kambodzsa",
    "KI" to "Kiribati",
    "KM" to "Comore-szigetek",
    "KN" to "Saint Kitts és Nevis",
    "KP" to "Észak-Korea",
    "KR" to "Dél-Korea",
    "KW" to "Kuvait",
    "KY" to "Kajmán-szigetek",
    "KZ" to "Kazahsztán",
    "LA" to "Laosz",
    "LB" to "Libanon",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Srí Lanka",
    "LR" to "Libéria",
    "LS" to "Lesotho",
    "LT" to "Litvánia",
    "LU" to "Luxemburg",
    "LV" to "Lettország",
    "LY" to "Líbia",
    "MA" to "Marokkó",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "ME" to "Montenegró",
    "MF" to "Saint Martin",
    "MG" to "Madagaszkár",
    "MH" to "Marshall-szigetek",
    "MK" to "Észak-Macedónia",
    "ML" to "Mali",
    "MM" to "Mianmar",
    "MN" to "Mongólia",
    "MO" to "Makaó KKT",
    "MP" to "Északi Mariana-szigetek",
    "MQ" to "Martinique",
    "MR" to "Mauritánia",
    "MS" to "Montserrat",
    "MT" to "Málta",
    "MU" to "Mauritius",
    "MV" to "Maldív-szigetek",
    "MW" to "Malawi",
    "MX" to "Mexikó",
    "MY" to "Malajzia",
    "MZ" to "Mozambik",
    "NA" to "Namíbia",
    "NC" to "Új-Kaledónia",
    "NE" to "Niger",
    "NF" to "Norfolk-sziget",
    "NG" to "Nigéria",
    "NI" to "Nicaragua",
    "NL" to "Hollandia",
    "NO" to "Norvégia",
    "NP" to "Nepál",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Új-Zéland",
    "OM" to "Omán",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Francia Polinézia",
    "PG" to "Pápua Új-Guinea",
    "PH" to "Fülöp-szigetek",
    "PK" to "Pakisztán",
    "PL" to "Lengyelország",
    "PM" to "Saint-Pierre és Miquelon",
    "PN" to "Pitcairn-szigetek",
    "PR" to "Puerto Rico",
    "PS" to "Palesztin Autonómia",
    "PT" to "Portugália",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Katar",
    "QO" to "Külső-Óceánia",
    "RE" to "Réunion",
    "RO" to "Románia",
    "RS" to "Szerbia",
    "RU" to "Oroszország",
    "RW" to "Ruanda",
    "SA" to "Szaúd-Arábia",
    "SB" to "Salamon-szigetek",
    "SC" to "Seychelle-szigetek",
    "SD" to "Szudán",
    "SE" to "Svédország",
    "SG" to "Szingapúr",
    "SH" to "Szent Ilona",
    "SI" to "Szlovénia",
    "SJ" to "Svalbard és Jan Mayen",
    "SK" to "Szlovákia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Szenegál",
    "SO" to "Szomália",
    "SR" to "Suriname",
    "SS" to "Dél-Szudán",
    "ST" to "São Tomé és Príncipe",
    "SV" to "Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Szíria",
    "SZ" to "Szváziföld",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks- és Caicos-szigetek",
    "TD" to "Csád",
    "TF" to "Francia Déli Területek",
    "TG" to "Togo",
    "TH" to "Thaiföld",
    "TJ" to "Tádzsikisztán",
    "TK" to "Tokelau",
    "TL" to "Kelet-Timor",
    "TM" to "Türkmenisztán",
    "TN" to "Tunézia",
    "TO" to "Tonga",
    "TR" to "Törökország",
    "TT" to "Trinidad és Tobago",
    "TV" to "Tuvalu",
    "TW" to "Tajvan",
    "TZ" to "Tanzánia",
    "UA" to "Ukrajna",
    "UG" to "Uganda",
    "UM" to "Az USA lakatlan külbirtokai",
    "UN" to "Egyesült Nemzetek Szervezete",
    "US" to "Egyesült Államok",
    "UY" to "Uruguay",
    "UZ" to "Üzbegisztán",
    "VA" to "Vatikán",
    "VC" to "Saint Vincent és a Grenadine-szigetek",
    "VE" to "Venezuela",
    "VG" to "Brit Virgin-szigetek",
    "VI" to "Amerikai Virgin-szigetek",
    "VN" to "Vietnám",
    "VU" to "Vanuatu",
    "WF" to "Wallis és Futuna",
    "WS" to "Szamoa",
    "XA" to "Pszeudo-nyelvjárások",
    "XB" to "Pszeudo-kétirányú",
    "XK" to "Koszovó",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Dél-afrikai Köztársaság",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Ismeretlen körzet",
  ) }

  val hy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Աշխարհ",
    "002" to "Աֆրիկա",
    "003" to "Հյուսիսային Ամերիկա",
    "005" to "Հարավային Ամերիկա",
    "009" to "Օվկիանիա",
    "011" to "Արևմտյան Աֆրիկա",
    "013" to "Կենտրոնական Ամերիկա",
    "014" to "Արևելյան Աֆրիկա",
    "015" to "Հյուսիսային Աֆրիկա",
    "017" to "Կենտրոնական Աֆրիկա",
    "018" to "Հարավային Աֆրիկա",
    "019" to "Ամերիկա",
    "021" to "Հյուսիսային Ամերիկա - ԱՄՆ և Կանադա",
    "029" to "Կարիբներ",
    "030" to "Արևելյան Ասիա",
    "034" to "Հարավային Ասիա",
    "035" to "Հարավարևելյան Ասիա",
    "039" to "Հարավային Եվրոպա",
    "053" to "Ավստրալասիա",
    "054" to "Մելանեզիա",
    "057" to "Միկրոնեզյան տարածաշրջան",
    "061" to "Պոլինեզիա",
    "142" to "Ասիա",
    "143" to "Կենտրոնական Ասիա",
    "145" to "Արևմտյան Ասիա",
    "150" to "Եվրոպա",
    "151" to "Արևելյան Եվրոպա",
    "154" to "Հյուսիսային Եվրոպա",
    "155" to "Արևմտյան Եվրոպա",
    "202" to "Արևադարձային Աֆրիկա",
    "419" to "Լատինական Ամերիկա",
    "AC" to "Համբարձման կղզի",
    "AD" to "Անդորրա",
    "AE" to "Արաբական Միացյալ Էմիրություններ",
    "AF" to "Աֆղանստան",
    "AG" to "Անտիգուա և Բարբուդա",
    "AI" to "Անգուիլա",
    "AL" to "Ալբանիա",
    "AM" to "Հայաստան",
    "AO" to "Անգոլա",
    "AQ" to "Անտարկտիդա",
    "AR" to "Արգենտինա",
    "AS" to "Ամերիկյան Սամոա",
    "AT" to "Ավստրիա",
    "AU" to "Ավստրալիա",
    "AW" to "Արուբա",
    "AX" to "Ալանդյան կղզիներ",
    "AZ" to "Ադրբեջան",
    "BA" to "Բոսնիա և Հերցեգովինա",
    "BB" to "Բարբադոս",
    "BD" to "Բանգլադեշ",
    "BE" to "Բելգիա",
    "BF" to "Բուրկինա Ֆասո",
    "BG" to "Բուլղարիա",
    "BH" to "Բահրեյն",
    "BI" to "Բուրունդի",
    "BJ" to "Բենին",
    "BL" to "Սուրբ Բարդուղիմեոս",
    "BM" to "Բերմուդներ",
    "BN" to "Բրունեյ",
    "BO" to "Բոլիվիա",
    "BQ" to "Կարիբյան Նիդեռլանդներ",
    "BR" to "Բրազիլիա",
    "BS" to "Բահամյան կղզիներ",
    "BT" to "Բութան",
    "BV" to "Բուվե կղզի",
    "BW" to "Բոտսվանա",
    "BY" to "Բելառուս",
    "BZ" to "Բելիզ",
    "CA" to "Կանադա",
    "CC" to "Կոկոսյան (Քիլինգ) կղզիներ",
    "CD" to "Կոնգո - Կինշասա",
    "CF" to "Կենտրոնական Աֆրիկյան Հանրապետություն",
    "CG" to "Կոնգո - Բրազավիլ",
    "CH" to "Շվեյցարիա",
    "CI" to "Կոտ դ՚Իվուար",
    "CK" to "Կուկի կղզիներ",
    "CL" to "Չիլի",
    "CM" to "Կամերուն",
    "CN" to "Չինաստան",
    "CO" to "Կոլումբիա",
    "CP" to "Քլիփերթոն կղզի",
    "CR" to "Կոստա Ռիկա",
    "CU" to "Կուբա",
    "CV" to "Կաբո Վերդե",
    "CW" to "Կյուրասաո",
    "CX" to "Սուրբ Ծննդյան կղզի",
    "CY" to "Կիպրոս",
    "CZ" to "Չեխիա",
    "DE" to "Գերմանիա",
    "DG" to "Դիեգո Գարսիա",
    "DJ" to "Ջիբութի",
    "DK" to "Դանիա",
    "DM" to "Դոմինիկա",
    "DO" to "Դոմինիկյան Հանրապետություն",
    "DZ" to "Ալժիր",
    "EA" to "Սեուտա և Մելիլյա",
    "EC" to "Էկվադոր",
    "EE" to "Էստոնիա",
    "EG" to "Եգիպտոս",
    "EH" to "Արևմտյան Սահարա",
    "ER" to "Էրիթրեա",
    "ES" to "Իսպանիա",
    "ET" to "Եթովպիա",
    "EU" to "Եվրոպական Միություն",
    "EZ" to "Եվրագոտի",
    "FI" to "Ֆինլանդիա",
    "FJ" to "Ֆիջի",
    "FK" to "Ֆոլքլենդյան կղզիներ",
    "FM" to "Միկրոնեզիա",
    "FO" to "Ֆարերյան կղզիներ",
    "FR" to "Ֆրանսիա",
    "GA" to "Գաբոն",
    "GB" to "Միացյալ Թագավորություն",
    "GD" to "Գրենադա",
    "GE" to "Վրաստան",
    "GF" to "Ֆրանսիական Գվիանա",
    "GG" to "Գերնսի",
    "GH" to "Գանա",
    "GI" to "Ջիբրալթար",
    "GL" to "Գրենլանդիա",
    "GM" to "Գամբիա",
    "GN" to "Գվինեա",
    "GP" to "Գվադելուպա",
    "GQ" to "Հասարակածային Գվինեա",
    "GR" to "Հունաստան",
    "GS" to "Հարավային Ջորջիա և Հարավային Սենդվիչյան կղզիներ",
    "GT" to "Գվատեմալա",
    "GU" to "Գուամ",
    "GW" to "Գվինեա-Բիսաու",
    "GY" to "Գայանա",
    "HK" to "Հոնկոնգի ՀՎՇ",
    "HM" to "Հերդ կղզի և ՄակԴոնալդի կղզիներ",
    "HN" to "Հոնդուրաս",
    "HR" to "Խորվաթիա",
    "HT" to "Հայիթի",
    "HU" to "Հունգարիա",
    "IC" to "Կանարյան կղզիներ",
    "ID" to "Ինդոնեզիա",
    "IE" to "Իռլանդիա",
    "IL" to "Իսրայել",
    "IM" to "Մեն կղզի",
    "IN" to "Հնդկաստան",
    "IO" to "Բրիտանական տարածք Հնդկական Օվկիանոսում",
    "IQ" to "Իրաք",
    "IR" to "Իրան",
    "IS" to "Իսլանդիա",
    "IT" to "Իտալիա",
    "JE" to "Ջերսի",
    "JM" to "Ճամայկա",
    "JO" to "Հորդանան",
    "JP" to "Ճապոնիա",
    "KE" to "Քենիա",
    "KG" to "Ղրղզստան",
    "KH" to "Կամբոջա",
    "KI" to "Կիրիբատի",
    "KM" to "Կոմորյան կղզիներ",
    "KN" to "Սենթ Քիտս և Նևիս",
    "KP" to "Հյուսիսային Կորեա",
    "KR" to "Հարավային Կորեա",
    "KW" to "Քուվեյթ",
    "KY" to "Կայմանյան կղզիներ",
    "KZ" to "Ղազախստան",
    "LA" to "Լաոս",
    "LB" to "Լիբանան",
    "LC" to "Սենթ Լյուսիա",
    "LI" to "Լիխտենշտեյն",
    "LK" to "Շրի Լանկա",
    "LR" to "Լիբերիա",
    "LS" to "Լեսոտո",
    "LT" to "Լիտվա",
    "LU" to "Լյուքսեմբուրգ",
    "LV" to "Լատվիա",
    "LY" to "Լիբիա",
    "MA" to "Մարոկկո",
    "MC" to "Մոնակո",
    "MD" to "Մոլդովա",
    "ME" to "Չեռնոգորիա",
    "MF" to "Սեն Մարտեն",
    "MG" to "Մադագասկար",
    "MH" to "Մարշալյան կղզիներ",
    "MK" to "Հյուսիսային Մակեդոնիա",
    "ML" to "Մալի",
    "MM" to "Մյանմա (Բիրմա)",
    "MN" to "Մոնղոլիա",
    "MO" to "Չինաստանի Մակաո ՀՎՇ",
    "MP" to "Հյուսիսային Մարիանյան կղզիներ",
    "MQ" to "Մարտինիկա",
    "MR" to "Մավրիտանիա",
    "MS" to "Մոնսեռատ",
    "MT" to "Մալթա",
    "MU" to "Մավրիկիոս",
    "MV" to "Մալդիվներ",
    "MW" to "Մալավի",
    "MX" to "Մեքսիկա",
    "MY" to "Մալայզիա",
    "MZ" to "Մոզամբիկ",
    "NA" to "Նամիբիա",
    "NC" to "Նոր Կալեդոնիա",
    "NE" to "Նիգեր",
    "NF" to "Նորֆոլկ կղզի",
    "NG" to "Նիգերիա",
    "NI" to "Նիկարագուա",
    "NL" to "Նիդեռլանդներ",
    "NO" to "Նորվեգիա",
    "NP" to "Նեպալ",
    "NR" to "Նաուրու",
    "NU" to "Նիուե",
    "NZ" to "Նոր Զելանդիա",
    "OM" to "Օման",
    "PA" to "Պանամա",
    "PE" to "Պերու",
    "PF" to "Ֆրանսիական Պոլինեզիա",
    "PG" to "Պապուա Նոր Գվինեա",
    "PH" to "Ֆիլիպիններ",
    "PK" to "Պակիստան",
    "PL" to "Լեհաստան",
    "PM" to "Սեն Պիեռ և Միքելոն",
    "PN" to "Պիտկեռն կղզիներ",
    "PR" to "Պուերտո Ռիկո",
    "PS" to "Պաղեստինյան տարածքներ",
    "PT" to "Պորտուգալիա",
    "PW" to "Պալաու",
    "PY" to "Պարագվայ",
    "QA" to "Կատար",
    "QO" to "Արտաքին Օվկիանիա",
    "RE" to "Ռեյունիոն",
    "RO" to "Ռումինիա",
    "RS" to "Սերբիա",
    "RU" to "Ռուսաստան",
    "RW" to "Ռուանդա",
    "SA" to "Սաուդյան Արաբիա",
    "SB" to "Սողոմոնյան կղզիներ",
    "SC" to "Սեյշելներ",
    "SD" to "Սուդան",
    "SE" to "Շվեդիա",
    "SG" to "Սինգապուր",
    "SH" to "Սուրբ Հեղինեի կղզի",
    "SI" to "Սլովենիա",
    "SJ" to "Սվալբարդ և Յան Մայեն",
    "SK" to "Սլովակիա",
    "SL" to "Սիեռա Լեոնե",
    "SM" to "Սան Մարինո",
    "SN" to "Սենեգալ",
    "SO" to "Սոմալի",
    "SR" to "Սուրինամ",
    "SS" to "Հարավային Սուդան",
    "ST" to "Սան Տոմե և Փրինսիպի",
    "SV" to "Սալվադոր",
    "SX" to "Սինտ Մարտեն",
    "SY" to "Սիրիա",
    "SZ" to "Էսվատինի",
    "TA" to "Տրիստան դա Կունյա",
    "TC" to "Թըրքս և Կայկոս կղզիներ",
    "TD" to "Չադ",
    "TF" to "Ֆրանսիական Հարավային Տարածքներ",
    "TG" to "Տոգո",
    "TH" to "Թաիլանդ",
    "TJ" to "Տաջիկստան",
    "TK" to "Տոկելաու",
    "TL" to "Թիմոր Լեշտի",
    "TM" to "Թուրքմենստան",
    "TN" to "Թունիս",
    "TO" to "Տոնգա",
    "TR" to "Թուրքիա",
    "TT" to "Տրինիդադ և Տոբագո",
    "TV" to "Տուվալու",
    "TW" to "Թայվան",
    "TZ" to "Տանզանիա",
    "UA" to "Ուկրաինա",
    "UG" to "Ուգանդա",
    "UM" to "Արտաքին կղզիներ (ԱՄՆ)",
    "UN" to "Միավորված ազգերի կազմակերպություն",
    "US" to "Միացյալ Նահանգներ",
    "UY" to "Ուրուգվայ",
    "UZ" to "Ուզբեկստան",
    "VA" to "Վատիկան",
    "VC" to "Սենթ Վինսենթ և Գրենադիններ",
    "VE" to "Վենեսուելա",
    "VG" to "Բրիտանական Վիրջինյան կղզիներ",
    "VI" to "ԱՄՆ Վիրջինյան կղզիներ",
    "VN" to "Վիետնամ",
    "VU" to "Վանուատու",
    "WF" to "Ուոլիս և Ֆուտունա",
    "WS" to "Սամոա",
    "XA" to "կեղծ տարբերիչներ",
    "XB" to "կեղծ երկուղղված",
    "XK" to "Կոսովո",
    "YE" to "Եմեն",
    "YT" to "Մայոտ",
    "ZA" to "Հարավաֆրիկյան Հանրապետություն",
    "ZM" to "Զամբիա",
    "ZW" to "Զիմբաբվե",
    "ZZ" to "Անհայտ տարածաշրջան",
  ) }

  val ia: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "mundo",
    "002" to "Africa",
    "003" to "America del Nord",
    "005" to "America del Sud",
    "009" to "Oceania",
    "011" to "Africa occidental",
    "013" to "America central",
    "014" to "Africa oriental",
    "015" to "Africa septentrional",
    "017" to "Africa central",
    "018" to "Africa meridional",
    "019" to "Americas",
    "021" to "America septentrional",
    "029" to "Caribes",
    "030" to "Asia oriental",
    "034" to "Asia meridional",
    "035" to "Asia del sud-est",
    "039" to "Europa meridional",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Region micronesian",
    "061" to "Polynesia",
    "142" to "Asia",
    "143" to "Asia central",
    "145" to "Asia occidental",
    "150" to "Europa",
    "151" to "Europa oriental",
    "154" to "Europa septentrional",
    "155" to "Europa occidental",
    "202" to "Africa subsaharian",
    "419" to "America latin",
    "AC" to "Insula del Ascension",
    "AD" to "Andorra",
    "AE" to "Emiratos Arabe Unite",
    "AF" to "Afghanistan",
    "AG" to "Antigua e Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarctica",
    "AR" to "Argentina",
    "AS" to "Samoa american",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Insulas Åland",
    "AZ" to "Azerbaidzhan",
    "BA" to "Bosnia e Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgica",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Sancte Bartholomeo",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Paises Basse caribe",
    "BR" to "Brasil",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Insula de Bouvet",
    "BW" to "Botswana",
    "BY" to "Bielorussia",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Insulas Cocos (Keeling)",
    "CD" to "Congo - Kinshasa",
    "CF" to "Republica African Central",
    "CG" to "Congo - Brazzaville",
    "CH" to "Suissa",
    "CI" to "Costa de Ebore",
    "CK" to "Insulas Cook",
    "CL" to "Chile",
    "CM" to "Camerun",
    "CN" to "China",
    "CO" to "Colombia",
    "CP" to "Insula Clipperton",
    "CQ" to "Sark",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Capo Verde",
    "CW" to "Curaçao",
    "CX" to "Insula de Natal",
    "CY" to "Cypro",
    "CZ" to "Chechia",
    "DE" to "Germania",
    "DG" to "Diego Garcia",
    "DJ" to "Djibuti",
    "DK" to "Danmark",
    "DM" to "Dominica",
    "DO" to "Republica Dominican",
    "DZ" to "Algeria",
    "EA" to "Ceuta e Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egypto",
    "EH" to "Sahara occidental",
    "ER" to "Eritrea",
    "ES" to "Espania",
    "ET" to "Ethiopia",
    "EU" to "Union Europee",
    "EZ" to "Zona euro",
    "FI" to "Finlandia",
    "FJ" to "Fiji",
    "FK" to "Insulas Falkland",
    "FM" to "Micronesia",
    "FO" to "Insulas Feroe",
    "FR" to "Francia",
    "GA" to "Gabon",
    "GB" to "Regno Unite",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "Guyana francese",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Groenlandia",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Guinea equatorial",
    "GR" to "Grecia",
    "GS" to "Georgia del Sud e Insulas Sandwich Austral",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hongkong, R.A.S. de China",
    "HM" to "Insulas Heard e McDonald",
    "HN" to "Honduras",
    "HR" to "Croatia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "IC" to "Insulas Canari",
    "ID" to "Indonesia",
    "IE" to "Irlanda",
    "IL" to "Israel",
    "IM" to "Insula de Man",
    "IN" to "India",
    "IO" to "Territorio oceanic britanno-indian",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Islanda",
    "IT" to "Italia",
    "JE" to "Jersey",
    "JM" to "Jamaica",
    "JO" to "Jordania",
    "JP" to "Japon",
    "KE" to "Kenya",
    "KG" to "Kirghizistan",
    "KH" to "Cambodgia",
    "KI" to "Kiribati",
    "KM" to "Comoros",
    "KN" to "Sancte Christophoro e Nevis",
    "KP" to "Corea del Nord",
    "KR" to "Corea del Sud",
    "KW" to "Kuwait",
    "KY" to "Insulas de Caiman",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Libano",
    "LC" to "Sancte Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lituania",
    "LU" to "Luxemburg",
    "LV" to "Lettonia",
    "LY" to "Libya",
    "MA" to "Marocco",
    "MC" to "Monaco",
    "MD" to "Moldavia",
    "ME" to "Montenegro",
    "MF" to "Sancte Martino francese",
    "MG" to "Madagascar",
    "MH" to "Insulas Marshall",
    "MK" to "Macedonia del Nord",
    "ML" to "Mali",
    "MM" to "Myanmar (Birmania)",
    "MN" to "Mongolia",
    "MO" to "Macao, R.A.S. de China",
    "MP" to "Insulas Marianna del Nord",
    "MQ" to "Martinica",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritio",
    "MV" to "Maldivas",
    "MW" to "Malawi",
    "MX" to "Mexico",
    "MY" to "Malaysia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "Nove Caledonia",
    "NE" to "Niger",
    "NF" to "Insula Norfolk",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Nederlandia",
    "NO" to "Norvegia",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nove Zelanda",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polynesia francese",
    "PG" to "Papua Nove Guinea",
    "PH" to "Philippinas",
    "PK" to "Pakistan",
    "PL" to "Polonia",
    "PM" to "St. Pierre e Miquelon",
    "PN" to "Insulas Pitcairn",
    "PR" to "Porto Rico",
    "PS" to "Territorios palestin",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Oceania remote",
    "RE" to "Reunion",
    "RO" to "Romania",
    "RS" to "Serbia",
    "RU" to "Russia",
    "RW" to "Ruanda",
    "SA" to "Arabia Saudita",
    "SB" to "Insulas Solomon",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Svedia",
    "SG" to "Singapur",
    "SH" to "Sancte Helena",
    "SI" to "Slovenia",
    "SJ" to "Svalbard e Jan Mayen",
    "SK" to "Slovachia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "Sudan del Sud",
    "ST" to "São Tomé e Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sancte Martino nederlandese",
    "SY" to "Syria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Insulas Turcos e Caicos",
    "TD" to "Tchad",
    "TF" to "Territorios meridional francese",
    "TG" to "Togo",
    "TH" to "Thailandia",
    "TJ" to "Tadzhikistan",
    "TK" to "Tokelau",
    "TL" to "Timor del Est",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turchia",
    "TT" to "Trinidad e Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraina",
    "UG" to "Uganda",
    "UM" to "Insulas peripheric del SUA",
    "UN" to "Nationes Unite",
    "US" to "Statos Unite",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Citate del Vaticano",
    "VC" to "Sancte Vincente e le Grenadinas",
    "VE" to "Venezuela",
    "VG" to "Insulas Virgine britannic",
    "VI" to "Insulas Virgine statounitese",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis e Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo-accentos",
    "XB" to "Pseudo-bidi",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "Africa del Sud",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Region incognite",
  ) }

  val id: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Dunia",
    "002" to "Afrika",
    "003" to "Amerika Utara",
    "005" to "Amerika Selatan",
    "009" to "Oseania",
    "011" to "Afrika Bagian Barat",
    "013" to "Amerika Tengah",
    "014" to "Afrika Bagian Timur",
    "015" to "Afrika Bagian Utara",
    "017" to "Afrika Bagian Tengah",
    "018" to "Afrika Bagian Selatan",
    "019" to "Amerika",
    "021" to "Amerika Bagian Utara",
    "029" to "Kepulauan Karibia",
    "030" to "Asia Bagian Timur",
    "034" to "Asia Bagian Selatan",
    "035" to "Asia Tenggara",
    "039" to "Eropa Bagian Selatan",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Wilayah Mikronesia",
    "061" to "Polinesia",
    "142" to "Asia",
    "143" to "Asia Tengah",
    "145" to "Asia Bagian Barat",
    "150" to "Eropa",
    "151" to "Eropa Bagian Timur",
    "154" to "Eropa Bagian Utara",
    "155" to "Eropa Bagian Barat",
    "202" to "Afrika Sub-Sahara",
    "419" to "Amerika Latin",
    "AC" to "Pulau Ascension",
    "AD" to "Andorra",
    "AE" to "Uni Emirat Arab",
    "AF" to "Afganistan",
    "AG" to "Antigua dan Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarktika",
    "AR" to "Argentina",
    "AS" to "Samoa Amerika",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Kepulauan Aland",
    "AZ" to "Azerbaijan",
    "BA" to "Bosnia dan Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgia",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Belanda Karibia",
    "BR" to "Brasil",
    "BS" to "Bahama",
    "BT" to "Bhutan",
    "BV" to "Pulau Bouvet",
    "BW" to "Botswana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kepulauan Cocos (Keeling)",
    "CD" to "Kongo - Kinshasa",
    "CF" to "Republik Afrika Tengah",
    "CG" to "Kongo - Brazzaville",
    "CH" to "Swiss",
    "CI" to "Côte d’Ivoire",
    "CK" to "Kepulauan Cook",
    "CL" to "Cile",
    "CM" to "Kamerun",
    "CN" to "Tiongkok",
    "CO" to "Kolombia",
    "CP" to "Pulau Clipperton",
    "CR" to "Kosta Rika",
    "CU" to "Kuba",
    "CV" to "Tanjung Verde",
    "CW" to "Curaçao",
    "CX" to "Pulau Natal",
    "CY" to "Siprus",
    "CZ" to "Ceko",
    "DE" to "Jerman",
    "DG" to "Diego Garcia",
    "DJ" to "Jibuti",
    "DK" to "Denmark",
    "DM" to "Dominika",
    "DO" to "Republik Dominika",
    "DZ" to "Aljazair",
    "EA" to "Ceuta dan Melilla",
    "EC" to "Ekuador",
    "EE" to "Estonia",
    "EG" to "Mesir",
    "EH" to "Sahara Barat",
    "ER" to "Eritrea",
    "ES" to "Spanyol",
    "ET" to "Etiopia",
    "EU" to "Uni Eropa",
    "EZ" to "Zona Euro",
    "FI" to "Finlandia",
    "FJ" to "Fiji",
    "FK" to "Kepulauan Falkland",
    "FM" to "Mikronesia",
    "FO" to "Kepulauan Faroe",
    "FR" to "Prancis",
    "GA" to "Gabon",
    "GB" to "Inggris Raya",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "Guyana Prancis",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Greenland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Guinea Ekuatorial",
    "GR" to "Yunani",
    "GS" to "Georgia Selatan & Kep. Sandwich Selatan",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong DAK Tiongkok",
    "HM" to "Pulau Heard dan Kepulauan McDonald",
    "HN" to "Honduras",
    "HR" to "Kroasia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "IC" to "Kepulauan Canaria",
    "ID" to "Indonesia",
    "IE" to "Irlandia",
    "IL" to "Israel",
    "IM" to "Pulau Man",
    "IN" to "India",
    "IO" to "Wilayah Inggris di Samudra Hindia",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Islandia",
    "IT" to "Italia",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Yordania",
    "JP" to "Jepang",
    "KE" to "Kenya",
    "KG" to "Kirgizstan",
    "KH" to "Kamboja",
    "KI" to "Kiribati",
    "KM" to "Komoro",
    "KN" to "Saint Kitts dan Nevis",
    "KP" to "Korea Utara",
    "KR" to "Korea Selatan",
    "KW" to "Kuwait",
    "KY" to "Kepulauan Cayman",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Lebanon",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lituania",
    "LU" to "Luksemburg",
    "LV" to "Latvia",
    "LY" to "Libya",
    "MA" to "Maroko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "Saint Martin",
    "MG" to "Madagaskar",
    "MH" to "Kepulauan Marshall",
    "MK" to "Makedonia Utara",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Makau DAK Tiongkok",
    "MP" to "Kepulauan Mariana Utara",
    "MQ" to "Martinik",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maladewa",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malaysia",
    "MZ" to "Mozambik",
    "NA" to "Namibia",
    "NC" to "Kaledonia Baru",
    "NE" to "Niger",
    "NF" to "Kepulauan Norfolk",
    "NG" to "Nigeria",
    "NI" to "Nikaragua",
    "NL" to "Belanda",
    "NO" to "Norwegia",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Selandia Baru",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia Prancis",
    "PG" to "Papua Nugini",
    "PH" to "Filipina",
    "PK" to "Pakistan",
    "PL" to "Polandia",
    "PM" to "Saint Pierre dan Miquelon",
    "PN" to "Kepulauan Pitcairn",
    "PR" to "Puerto Riko",
    "PS" to "Wilayah Palestina",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Oseania Luar",
    "RE" to "Réunion",
    "RO" to "Rumania",
    "RS" to "Serbia",
    "RU" to "Rusia",
    "RW" to "Rwanda",
    "SA" to "Arab Saudi",
    "SB" to "Kepulauan Solomon",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Swedia",
    "SG" to "Singapura",
    "SH" to "Saint Helena",
    "SI" to "Slovenia",
    "SJ" to "Kepulauan Svalbard dan Jan Mayen",
    "SK" to "Slovakia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "Sudan Selatan",
    "ST" to "Sao Tome dan Principe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Suriah",
    "SZ" to "eSwatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Kepulauan Turks dan Caicos",
    "TD" to "Chad",
    "TF" to "Wilayah Selatan Prancis",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tajikistan",
    "TK" to "Tokelau",
    "TL" to "Timor Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turki",
    "TT" to "Trinidad dan Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraina",
    "UG" to "Uganda",
    "UM" to "Kepulauan Terluar AS",
    "UN" to "Perserikatan Bangsa-Bangsa",
    "US" to "Amerika Serikat",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Vatikan",
    "VC" to "Saint Vincent dan Grenadine",
    "VE" to "Venezuela",
    "VG" to "Kepulauan Virgin Britania Raya",
    "VI" to "Kepulauan Virgin Amerika Serikat",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Kepulauan Wallis dan Futuna",
    "WS" to "Samoa",
    "XA" to "Aksen Asing",
    "XB" to "Pseudo-Bidi",
    "XK" to "Kosovo",
    "YE" to "Yaman",
    "YT" to "Mayotte",
    "ZA" to "Afrika Selatan",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Wilayah Tidak Dikenal",
  ) }

  val ie: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "munde",
    "002" to "Africa",
    "005" to "Sud-America",
    "009" to "Oceania",
    "013" to "central America",
    "019" to "Americas",
    "021" to "Nord-America",
    "142" to "Asia",
    "150" to "Europa",
    "419" to "latin America",
    "AL" to "Albania",
    "AQ" to "Antarctica",
    "AT" to "Austria",
    "BA" to "Bosnia e Herzegovina",
    "BE" to "Belgia",
    "BG" to "Bulgaria",
    "CH" to "Svissia",
    "CZ" to "Tchekia",
    "DE" to "Germania",
    "DK" to "Dania",
    "EE" to "Estonia",
    "ER" to "Eritrea",
    "ES" to "Hispania",
    "ET" to "Etiopia",
    "EU" to "Union Europan",
    "EZ" to "Zone de euro",
    "FI" to "Finland",
    "FJ" to "Fidji",
    "FR" to "Francia",
    "GB" to "Unit Reyia",
    "GR" to "Grecia",
    "GY" to "Guyana",
    "HR" to "Croatia",
    "HU" to "Hungaria",
    "ID" to "Indonesia",
    "IE" to "Irland",
    "IN" to "India",
    "IR" to "Iran",
    "IS" to "Island",
    "IT" to "Italia",
    "KH" to "Cambodja",
    "LK" to "Sri-Lanka",
    "LU" to "Luxemburg",
    "MC" to "Mónaco",
    "ME" to "Montenegro",
    "MK" to "Nord-Macedonia",
    "MQ" to "Martinica",
    "MT" to "Malta",
    "MU" to "Mauricio",
    "MV" to "Maldivas",
    "NF" to "Insul Norfolk",
    "NR" to "Nauru",
    "NZ" to "Nov-Zeland",
    "PE" to "Perú",
    "PH" to "Filipines",
    "PK" to "Pakistan",
    "PL" to "Polonia",
    "PR" to "Porto-Rico",
    "PT" to "Portugal",
    "PW" to "Palau",
    "RO" to "Rumania",
    "RS" to "Serbia",
    "RU" to "Russia",
    "SE" to "Svedia",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SM" to "San-Marino",
    "SX" to "Sint-Maarten",
    "TC" to "Turks e Caicos",
    "TD" to "Tchad",
    "TK" to "Tokelau",
    "TL" to "Ost-Timor",
    "TT" to "Trinidad e Tobago",
    "TV" to "Tuvalu",
    "UA" to "Ukraina",
    "UN" to "Unit Nationes",
    "VU" to "Vanuatu",
    "WS" to "Samoa",
    "XK" to "Kosovo",
    "ZZ" to "ínconosset region",
  ) }

  val ig: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Uwa",
    "002" to "Afrika",
    "003" to "Mpaghara Ugwu Amerịka",
    "005" to "Mpaghara Mgbada Ugwu America",
    "009" to "Oceania",
    "011" to "Mpaghara Ọdịda Anyanwụ Afrịka",
    "013" to "Etiti America",
    "014" to "Mpaghara Ọwụwa Anyanwụ Afrịka",
    "015" to "Mpaghara Ugwu Afrịka",
    "017" to "Etiti Afrịka",
    "018" to "Mpaghara Mgbada Ugwu Afrịka",
    "019" to "Amerịka",
    "021" to "Mpaghara Ugwu America",
    "029" to "Caribbean",
    "030" to "Mpaghara Ọwụwa Anyanwụ Asia",
    "034" to "Mpaghara Mgbada Ugwu Asia",
    "035" to "Mpaghara Mgbada Ugwu Asia dị na Ọwụwa Anyanwụ",
    "039" to "Mpaghara Mgbada Ugwu Europe",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Mpaghara Micronesian",
    "061" to "Polynesia",
    "142" to "Asia",
    "143" to "Etiti Asia",
    "145" to "Mpaghara Ọdịda Anyanwụ Asia",
    "150" to "Europe",
    "151" to "Mpaghara Ọwụwa Anyanwụ Europe",
    "154" to "Mpaghara Ugwu Europe",
    "155" to "Mpaghara Ọdịda Anyanwụ Europe",
    "202" to "Sub-Saharan Afrịka",
    "419" to "Latin America",
    "AC" to "Ascension Island",
    "AD" to "Andorra",
    "AE" to "United Arab Emirates",
    "AF" to "Afghanistan",
    "AG" to "Antigua na Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antarctica",
    "AR" to "Argentina",
    "AS" to "American Samoa",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Åland Islands",
    "AZ" to "Azerbaijan",
    "BA" to "Bosnia & Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgium",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthélemy",
    "BM" to "Bemuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Caribbean Netherlands",
    "BR" to "Brazil",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Bouvet Island",
    "BW" to "Botswana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Agwaetiti Cocos (Keeling)",
    "CD" to "Congo - Kinshasa",
    "CF" to "Central African Republik",
    "CG" to "Congo",
    "CH" to "Switzerland",
    "CI" to "Côte d’Ivoire",
    "CK" to "Agwaetiti Cook",
    "CL" to "Chile",
    "CM" to "Cameroon",
    "CN" to "China",
    "CO" to "Colombia",
    "CP" to "Agwaetiti Clipperton",
    "CQ" to "Sark",
    "CR" to "Kosta Rika",
    "CU" to "Cuba",
    "CV" to "Cape Verde",
    "CW" to "Kurakao",
    "CX" to "Agwaetiti Christmas",
    "CY" to "Cyprus",
    "CZ" to "Czechia",
    "DE" to "Germany",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Denmark",
    "DM" to "Dominica",
    "DO" to "Dominican Republik",
    "DZ" to "Algeria",
    "EA" to "Ceuta & Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egypt",
    "EH" to "Ọdịda Anyanwụ Sahara",
    "ER" to "Eritrea",
    "ES" to "Spain",
    "ET" to "Ethiopia",
    "EU" to "Otu nzukọ mba Europe",
    "EZ" to "Gburugburu Euro",
    "FI" to "Finland",
    "FJ" to "Fiji",
    "FK" to "Falkland Islands",
    "FM" to "Micronesia",
    "FO" to "Faroe Islands",
    "FR" to "France",
    "GA" to "Gabon",
    "GB" to "United Kingdom",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "French Guiana",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Greenland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Equatorial Guinea",
    "GR" to "Greece",
    "GS" to "South Georgia & South Sandwich Islands",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Kong SAR China",
    "HM" to "Agwaetiti Heard na Agwaetiti McDonald",
    "HN" to "Honduras",
    "HR" to "Croatia",
    "HT" to "Haiti",
    "HU" to "Hungary",
    "IC" to "Canary Islands",
    "ID" to "Indonesia",
    "IE" to "Ireland",
    "IL" to "Israel",
    "IM" to "Isle of Man",
    "IN" to "India",
    "IO" to "British Indian Ocean Territory",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Iceland",
    "IT" to "Italy",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenya",
    "KG" to "Kyrgyzstan",
    "KH" to "Cambodia",
    "KI" to "Kiribati",
    "KM" to "Comoros",
    "KN" to "St. Kitts & Nevis",
    "KP" to "North Korea",
    "KR" to "South Korea",
    "KW" to "Kuwait",
    "KY" to "Cayman Islands",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Lebanon",
    "LC" to "St. Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lithuania",
    "LU" to "Luxembourg",
    "LV" to "Latvia",
    "LY" to "Libia",
    "MA" to "Morocco",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "St. Martin",
    "MG" to "Madagascar",
    "MH" to "Agwaetiti Marshall",
    "MK" to "North Macedonia",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Macao SAR China",
    "MP" to "Agwaetiti Northern Mariana",
    "MQ" to "Martinique",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldivesa",
    "MW" to "Malawi",
    "MX" to "Mexico",
    "MY" to "Malaysia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "New Caledonia",
    "NE" to "Niger",
    "NF" to "Agwaetiti Norfolk",
    "NG" to "Naịjịrịa",
    "NI" to "Nicaragua",
    "NL" to "Netherlands",
    "NO" to "Norway",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "New Zealand",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "French Polynesia",
    "PG" to "Papua New Guinea",
    "PH" to "Philippines",
    "PK" to "Pakistan",
    "PL" to "Poland",
    "PM" to "St. Pierre & Miquelon",
    "PN" to "Agwaetiti Pitcairn",
    "PR" to "Puerto Rico",
    "PS" to "Mpaghara ndị Palestine",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Outlying Oceania",
    "RE" to "Réunion",
    "RO" to "Romania",
    "RS" to "Serbia",
    "RU" to "Russia",
    "RW" to "Rwanda",
    "SA" to "Saudi Arabia",
    "SB" to "Agwaetiti Solomon",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Sweden",
    "SG" to "Singapore",
    "SH" to "St. Helena",
    "SI" to "Slovenia",
    "SJ" to "Svalbard & Jan Mayen",
    "SK" to "Slovakia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "South Sudan",
    "ST" to "São Tomé & Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks & Caicos Islands",
    "TD" to "Chad",
    "TF" to "Ụmụ ngalaba Frenchi Southern",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tajikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Türkiye",
    "TT" to "Trinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraine",
    "UG" to "Uganda",
    "UM" to "Obere Agwaetiti Dị Na Mpụga U.S",
    "UN" to "Mba Ụwa Jikọrọ Ọnụ",
    "US" to "United States",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Vatican City",
    "VC" to "St. Vincent & Grenadines",
    "VE" to "Venezuela",
    "VG" to "British Virgin Islands",
    "VI" to "U.S. Virgin Islands",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis & Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo-Accents",
    "XB" to "Pseudo-Bidi",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "South Africa",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Mpaghara A na-amaghị",
  ) }

  val ii: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "ꋧꃅ",
    "002" to "ꃏꍏ",
    "003" to "ꀙꂰꍏ",
    "005" to "ꆆꂰꍏ",
    "009" to "ꄊꑸꍏ",
    "019" to "ꂰꍏ",
    "142" to "ꑸꍏ",
    "150" to "ꉩꍏ",
    "BE" to "ꀘꆹꏃ",
    "BR" to "ꀠꑭ",
    "CN" to "ꍏꇩ",
    "DE" to "ꄓꇩ",
    "FR" to "ꃔꇩ",
    "GB" to "ꑱꇩ",
    "IN" to "ꑴꄗ",
    "IT" to "ꑴꄊꆺ",
    "JP" to "ꏝꀪ",
    "MX" to "ꃀꑭꇬ",
    "RU" to "ꊉꇆꌦ",
    "US" to "ꂰꇩ",
    "ZZ" to "ꃅꄷꅉꀋꐚꌠ",
  ) }

  val `is`: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Heimurinn",
    "002" to "Afríka",
    "003" to "Norður-Ameríka",
    "005" to "Suður-Ameríka",
    "009" to "Eyjaálfa",
    "011" to "Vestur-Afríka",
    "013" to "Mið-Ameríka",
    "014" to "Austur-Afríka",
    "015" to "Norður-Afríka",
    "017" to "Mið-Afríka",
    "018" to "Suðurhluti Afríku",
    "019" to "Ameríka",
    "021" to "Ameríka norðan Mexíkó",
    "029" to "Karíbahafið",
    "030" to "Austur-Asía",
    "034" to "Suður-Asía",
    "035" to "Suðaustur-Asía",
    "039" to "Suður-Evrópa",
    "053" to "Ástralasía",
    "054" to "Melanesía",
    "057" to "Míkrónesíusvæðið",
    "061" to "Pólýnesía",
    "142" to "Asía",
    "143" to "Mið-Asía",
    "145" to "Vestur-Asía",
    "150" to "Evrópa",
    "151" to "Austur-Evrópa",
    "154" to "Norður-Evrópa",
    "155" to "Vestur-Evrópa",
    "202" to "Afríka sunnan Sahara",
    "419" to "Rómanska Ameríka",
    "AC" to "Ascension-eyja",
    "AD" to "Andorra",
    "AE" to "Sameinuðu arabísku furstadæmin",
    "AF" to "Afganistan",
    "AG" to "Antígva og Barbúda",
    "AI" to "Angvilla",
    "AL" to "Albanía",
    "AM" to "Armenía",
    "AO" to "Angóla",
    "AQ" to "Suðurskautslandið",
    "AR" to "Argentína",
    "AS" to "Bandaríska Samóa",
    "AT" to "Austurríki",
    "AU" to "Ástralía",
    "AW" to "Arúba",
    "AX" to "Álandseyjar",
    "AZ" to "Aserbaídsjan",
    "BA" to "Bosnía og Hersegóvína",
    "BB" to "Barbados",
    "BD" to "Bangladess",
    "BE" to "Belgía",
    "BF" to "Búrkína Fasó",
    "BG" to "Búlgaría",
    "BH" to "Barein",
    "BI" to "Búrúndí",
    "BJ" to "Benín",
    "BL" to "Sankti Bartólómeusareyjar",
    "BM" to "Bermúdaeyjar",
    "BN" to "Brúnei",
    "BO" to "Bólivía",
    "BQ" to "Karíbahafshluti Hollands",
    "BR" to "Brasilía",
    "BS" to "Bahamaeyjar",
    "BT" to "Bútan",
    "BV" to "Bouveteyja",
    "BW" to "Botsvana",
    "BY" to "Hvíta-Rússland",
    "BZ" to "Belís",
    "CA" to "Kanada",
    "CC" to "Kókoseyjar (Keeling)",
    "CD" to "Kongó-Kinshasa",
    "CF" to "Mið-Afríkulýðveldið",
    "CG" to "Kongó-Brazzaville",
    "CH" to "Sviss",
    "CI" to "Fílabeinsströndin",
    "CK" to "Cooks-eyjar",
    "CL" to "Síle",
    "CM" to "Kamerún",
    "CN" to "Kína",
    "CO" to "Kólumbía",
    "CP" to "Clipperton-eyja",
    "CR" to "Kostaríka",
    "CU" to "Kúba",
    "CV" to "Grænhöfðaeyjar",
    "CW" to "Curacao",
    "CX" to "Jólaey",
    "CY" to "Kýpur",
    "CZ" to "Tékkland",
    "DE" to "Þýskaland",
    "DG" to "Diego Garcia",
    "DJ" to "Djíbútí",
    "DK" to "Danmörk",
    "DM" to "Dóminíka",
    "DO" to "Dóminíska lýðveldið",
    "DZ" to "Alsír",
    "EA" to "Ceuta og Melilla",
    "EC" to "Ekvador",
    "EE" to "Eistland",
    "EG" to "Egyptaland",
    "EH" to "Vestur-Sahara",
    "ER" to "Erítrea",
    "ES" to "Spánn",
    "ET" to "Eþíópía",
    "EU" to "Evrópusambandið",
    "EZ" to "Evrusvæðið",
    "FI" to "Finnland",
    "FJ" to "Fídjíeyjar",
    "FK" to "Falklandseyjar",
    "FM" to "Míkrónesía",
    "FO" to "Færeyjar",
    "FR" to "Frakkland",
    "GA" to "Gabon",
    "GB" to "Bretland",
    "GD" to "Grenada",
    "GE" to "Georgía",
    "GF" to "Franska Gvæjana",
    "GG" to "Guernsey",
    "GH" to "Gana",
    "GI" to "Gíbraltar",
    "GL" to "Grænland",
    "GM" to "Gambía",
    "GN" to "Gínea",
    "GP" to "Gvadelúpeyjar",
    "GQ" to "Miðbaugs-Gínea",
    "GR" to "Grikkland",
    "GS" to "Suður-Georgía og Suður-Sandvíkureyjar",
    "GT" to "Gvatemala",
    "GU" to "Gvam",
    "GW" to "Gínea-Bissá",
    "GY" to "Gvæjana",
    "HK" to "sérstjórnarsvæðið Hong Kong",
    "HM" to "Heard og McDonaldseyjar",
    "HN" to "Hondúras",
    "HR" to "Króatía",
    "HT" to "Haítí",
    "HU" to "Ungverjaland",
    "IC" to "Kanaríeyjar",
    "ID" to "Indónesía",
    "IE" to "Írland",
    "IL" to "Ísrael",
    "IM" to "Mön",
    "IN" to "Indland",
    "IO" to "Bresku Indlandshafseyjar",
    "IQ" to "Írak",
    "IR" to "Íran",
    "IS" to "Ísland",
    "IT" to "Ítalía",
    "JE" to "Jersey",
    "JM" to "Jamaíka",
    "JO" to "Jórdanía",
    "JP" to "Japan",
    "KE" to "Kenía",
    "KG" to "Kirgistan",
    "KH" to "Kambódía",
    "KI" to "Kíribatí",
    "KM" to "Kómoreyjar",
    "KN" to "Sankti Kitts og Nevis",
    "KP" to "Norður-Kórea",
    "KR" to "Suður-Kórea",
    "KW" to "Kúveit",
    "KY" to "Caymaneyjar",
    "KZ" to "Kasakstan",
    "LA" to "Laos",
    "LB" to "Líbanon",
    "LC" to "Sankti Lúsía",
    "LI" to "Liechtenstein",
    "LK" to "Srí Lanka",
    "LR" to "Líbería",
    "LS" to "Lesótó",
    "LT" to "Litháen",
    "LU" to "Lúxemborg",
    "LV" to "Lettland",
    "LY" to "Líbía",
    "MA" to "Marokkó",
    "MC" to "Mónakó",
    "MD" to "Moldóva",
    "ME" to "Svartfjallaland",
    "MF" to "Saint-Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshalleyjar",
    "MK" to "Norður-Makedónía",
    "ML" to "Malí",
    "MM" to "Mjanmar (Búrma)",
    "MN" to "Mongólía",
    "MO" to "sérstjórnarsvæðið Makaó",
    "MP" to "Norður-Maríanaeyjar",
    "MQ" to "Martiník",
    "MR" to "Máritanía",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Máritíus",
    "MV" to "Maldíveyjar",
    "MW" to "Malaví",
    "MX" to "Mexíkó",
    "MY" to "Malasía",
    "MZ" to "Mósambík",
    "NA" to "Namibía",
    "NC" to "Nýja-Kaledónía",
    "NE" to "Níger",
    "NF" to "Norfolkeyja",
    "NG" to "Nígería",
    "NI" to "Níkaragva",
    "NL" to "Holland",
    "NO" to "Noregur",
    "NP" to "Nepal",
    "NR" to "Nárú",
    "NU" to "Niue",
    "NZ" to "Nýja-Sjáland",
    "OM" to "Óman",
    "PA" to "Panama",
    "PE" to "Perú",
    "PF" to "Franska Pólýnesía",
    "PG" to "Papúa Nýja-Gínea",
    "PH" to "Filippseyjar",
    "PK" to "Pakistan",
    "PL" to "Pólland",
    "PM" to "Sankti Pierre og Miquelon",
    "PN" to "Pitcairn-eyjar",
    "PR" to "Púertó Ríkó",
    "PS" to "Heimastjórnarsvæði Palestínumanna",
    "PT" to "Portúgal",
    "PW" to "Palá",
    "PY" to "Paragvæ",
    "QA" to "Katar",
    "QO" to "Ytri Eyjaálfa",
    "RE" to "Réunion",
    "RO" to "Rúmenía",
    "RS" to "Serbía",
    "RU" to "Rússland",
    "RW" to "Rúanda",
    "SA" to "Sádi-Arabía",
    "SB" to "Salómonseyjar",
    "SC" to "Seychelles-eyjar",
    "SD" to "Súdan",
    "SE" to "Svíþjóð",
    "SG" to "Singapúr",
    "SH" to "Sankti Helena",
    "SI" to "Slóvenía",
    "SJ" to "Svalbarði og Jan Mayen",
    "SK" to "Slóvakía",
    "SL" to "Síerra Leóne",
    "SM" to "San Marínó",
    "SN" to "Senegal",
    "SO" to "Sómalía",
    "SR" to "Súrínam",
    "SS" to "Suður-Súdan",
    "ST" to "Saó Tóme og Prinsípe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Sýrland",
    "SZ" to "Esvatíní",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks- og Caicoseyjar",
    "TD" to "Tsjad",
    "TF" to "Frönsku suðlægu landsvæðin",
    "TG" to "Tógó",
    "TH" to "Taíland",
    "TJ" to "Tadsíkistan",
    "TK" to "Tókelá",
    "TL" to "Tímor-Leste",
    "TM" to "Túrkmenistan",
    "TN" to "Túnis",
    "TO" to "Tonga",
    "TR" to "Tyrkland",
    "TT" to "Trínidad og Tóbagó",
    "TV" to "Túvalú",
    "TW" to "Taívan",
    "TZ" to "Tansanía",
    "UA" to "Úkraína",
    "UG" to "Úganda",
    "UM" to "Smáeyjar Bandaríkjanna",
    "UN" to "Sameinuðu þjóðirnar",
    "US" to "Bandaríkin",
    "UY" to "Úrúgvæ",
    "UZ" to "Úsbekistan",
    "VA" to "Vatíkanið",
    "VC" to "Sankti Vinsent og Grenadíneyjar",
    "VE" to "Venesúela",
    "VG" to "Bresku Jómfrúaeyjar",
    "VI" to "Bandarísku Jómfrúaeyjar",
    "VN" to "Víetnam",
    "VU" to "Vanúatú",
    "WF" to "Wallis- og Fútúnaeyjar",
    "WS" to "Samóa",
    "XA" to "gervihreimur",
    "XB" to "gervistaður",
    "XK" to "Kósóvó",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Suður-Afríka",
    "ZM" to "Sambía",
    "ZW" to "Simbabve",
    "ZZ" to "Óþekkt svæði",
  ) }

  val it: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Mondo",
    "002" to "Africa",
    "003" to "Nord America",
    "005" to "America del Sud",
    "009" to "Oceania",
    "011" to "Africa occidentale",
    "013" to "America Centrale",
    "014" to "Africa orientale",
    "015" to "Nordafrica",
    "017" to "Africa centrale",
    "018" to "Africa del Sud",
    "019" to "Americhe",
    "021" to "America del Nord",
    "029" to "Caraibi",
    "030" to "Asia orientale",
    "034" to "Asia del Sud",
    "035" to "Sud-est asiatico",
    "039" to "Europa meridionale",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Regione micronesiana",
    "061" to "Polinesia",
    "142" to "Asia",
    "143" to "Asia centrale",
    "145" to "Asia occidentale",
    "150" to "Europa",
    "151" to "Europa orientale",
    "154" to "Europa settentrionale",
    "155" to "Europa occidentale",
    "202" to "Africa subsahariana",
    "419" to "America Latina",
    "AC" to "Isola Ascensione",
    "AD" to "Andorra",
    "AE" to "Emirati Arabi Uniti",
    "AF" to "Afghanistan",
    "AG" to "Antigua e Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antartide",
    "AR" to "Argentina",
    "AS" to "Samoa Americane",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Isole Åland",
    "AZ" to "Azerbaigian",
    "BA" to "Bosnia ed Erzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgio",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrein",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint-Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Caraibi Olandesi",
    "BR" to "Brasile",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Isola Bouvet",
    "BW" to "Botswana",
    "BY" to "Bielorussia",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Isole Cocos (Keeling)",
    "CD" to "Congo - Kinshasa",
    "CF" to "Repubblica Centrafricana",
    "CG" to "Congo-Brazzaville",
    "CH" to "Svizzera",
    "CI" to "Costa d’Avorio",
    "CK" to "Isole Cook",
    "CL" to "Cile",
    "CM" to "Camerun",
    "CN" to "Cina",
    "CO" to "Colombia",
    "CP" to "Isola di Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Capo Verde",
    "CW" to "Curaçao",
    "CX" to "Isola Christmas",
    "CY" to "Cipro",
    "CZ" to "Cechia",
    "DE" to "Germania",
    "DG" to "Diego Garcia",
    "DJ" to "Gibuti",
    "DK" to "Danimarca",
    "DM" to "Dominica",
    "DO" to "Repubblica Dominicana",
    "DZ" to "Algeria",
    "EA" to "Ceuta e Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egitto",
    "EH" to "Sahara Occidentale",
    "ER" to "Eritrea",
    "ES" to "Spagna",
    "ET" to "Etiopia",
    "EU" to "Unione europea",
    "EZ" to "Eurozona",
    "FI" to "Finlandia",
    "FJ" to "Figi",
    "FK" to "Isole Falkland",
    "FM" to "Micronesia",
    "FO" to "Isole Fær Øer",
    "FR" to "Francia",
    "GA" to "Gabon",
    "GB" to "Regno Unito",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "Guyana Francese",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibilterra",
    "GL" to "Groenlandia",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadalupa",
    "GQ" to "Guinea Equatoriale",
    "GR" to "Grecia",
    "GS" to "Georgia del Sud e Sandwich Australi",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "RAS di Hong Kong",
    "HM" to "Isole Heard e McDonald",
    "HN" to "Honduras",
    "HR" to "Croazia",
    "HT" to "Haiti",
    "HU" to "Ungheria",
    "IC" to "Isole Canarie",
    "ID" to "Indonesia",
    "IE" to "Irlanda",
    "IL" to "Israele",
    "IM" to "Isola di Man",
    "IN" to "India",
    "IO" to "Territorio Britannico dell’Oceano Indiano",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Islanda",
    "IT" to "Italia",
    "JE" to "Jersey",
    "JM" to "Giamaica",
    "JO" to "Giordania",
    "JP" to "Giappone",
    "KE" to "Kenya",
    "KG" to "Kirghizistan",
    "KH" to "Cambogia",
    "KI" to "Kiribati",
    "KM" to "Comore",
    "KN" to "Saint Kitts e Nevis",
    "KP" to "Corea del Nord",
    "KR" to "Corea del Sud",
    "KW" to "Kuwait",
    "KY" to "Isole Cayman",
    "KZ" to "Kazakistan",
    "LA" to "Laos",
    "LB" to "Libano",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lituania",
    "LU" to "Lussemburgo",
    "LV" to "Lettonia",
    "LY" to "Libia",
    "MA" to "Marocco",
    "MC" to "Monaco",
    "MD" to "Moldavia",
    "ME" to "Montenegro",
    "MF" to "Saint Martin",
    "MG" to "Madagascar",
    "MH" to "Isole Marshall",
    "MK" to "Macedonia del Nord",
    "ML" to "Mali",
    "MM" to "Myanmar (Birmania)",
    "MN" to "Mongolia",
    "MO" to "RAS di Macao",
    "MP" to "Isole Marianne Settentrionali",
    "MQ" to "Martinica",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldive",
    "MW" to "Malawi",
    "MX" to "Messico",
    "MY" to "Malaysia",
    "MZ" to "Mozambico",
    "NA" to "Namibia",
    "NC" to "Nuova Caledonia",
    "NE" to "Niger",
    "NF" to "Isola Norfolk",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Paesi Bassi",
    "NO" to "Norvegia",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nuova Zelanda",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Perù",
    "PF" to "Polinesia Francese",
    "PG" to "Papua Nuova Guinea",
    "PH" to "Filippine",
    "PK" to "Pakistan",
    "PL" to "Polonia",
    "PM" to "Saint-Pierre e Miquelon",
    "PN" to "Isole Pitcairn",
    "PR" to "Portorico",
    "PS" to "Territori Palestinesi",
    "PT" to "Portogallo",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Oceania lontana",
    "RE" to "Riunione",
    "RO" to "Romania",
    "RS" to "Serbia",
    "RU" to "Russia",
    "RW" to "Ruanda",
    "SA" to "Arabia Saudita",
    "SB" to "Isole Salomone",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Svezia",
    "SG" to "Singapore",
    "SH" to "Sant’Elena",
    "SI" to "Slovenia",
    "SJ" to "Svalbard e Jan Mayen",
    "SK" to "Slovacchia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "Sud Sudan",
    "ST" to "São Tomé e Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Siria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Isole Turks e Caicos",
    "TD" to "Ciad",
    "TF" to "Terre Australi Francesi",
    "TG" to "Togo",
    "TH" to "Thailandia",
    "TJ" to "Tagikistan",
    "TK" to "Tokelau",
    "TL" to "Timor Est",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turchia",
    "TT" to "Trinidad e Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ucraina",
    "UG" to "Uganda",
    "UM" to "Isole Minori Esterne degli Stati Uniti",
    "UN" to "Nazioni Unite",
    "US" to "Stati Uniti",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Città del Vaticano",
    "VC" to "Saint Vincent e Grenadine",
    "VE" to "Venezuela",
    "VG" to "Isole Vergini Britanniche",
    "VI" to "Isole Vergini Americane",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis e Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo-accenti",
    "XB" to "Pseudo-bidi",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "Sudafrica",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Regione sconosciuta",
  ) }

  val it_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val it_SM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val it_VA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ja: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "世界",
    "002" to "アフリカ",
    "003" to "北アメリカ大陸",
    "005" to "南アメリカ",
    "009" to "オセアニア",
    "011" to "西アフリカ",
    "013" to "中央アメリカ",
    "014" to "東アフリカ",
    "015" to "北アフリカ",
    "017" to "中部アフリカ",
    "018" to "南部アフリカ",
    "019" to "アメリカ大陸",
    "021" to "北アメリカ",
    "029" to "カリブ",
    "030" to "東アジア",
    "034" to "南アジア",
    "035" to "東南アジア",
    "039" to "南ヨーロッパ",
    "053" to "オーストララシア",
    "054" to "メラネシア",
    "057" to "ミクロネシア",
    "061" to "ポリネシア",
    "142" to "アジア",
    "143" to "中央アジア",
    "145" to "西アジア",
    "150" to "ヨーロッパ",
    "151" to "東ヨーロッパ",
    "154" to "北ヨーロッパ",
    "155" to "西ヨーロッパ",
    "202" to "サブサハラアフリカ",
    "419" to "ラテンアメリカ",
    "AC" to "アセンション島",
    "AD" to "アンドラ",
    "AE" to "アラブ首長国連邦",
    "AF" to "アフガニスタン",
    "AG" to "アンティグア・バーブーダ",
    "AI" to "アンギラ",
    "AL" to "アルバニア",
    "AM" to "アルメニア",
    "AO" to "アンゴラ",
    "AQ" to "南極",
    "AR" to "アルゼンチン",
    "AS" to "米領サモア",
    "AT" to "オーストリア",
    "AU" to "オーストラリア",
    "AW" to "アルバ",
    "AX" to "オーランド諸島",
    "AZ" to "アゼルバイジャン",
    "BA" to "ボスニア・ヘルツェゴビナ",
    "BB" to "バルバドス",
    "BD" to "バングラデシュ",
    "BE" to "ベルギー",
    "BF" to "ブルキナファソ",
    "BG" to "ブルガリア",
    "BH" to "バーレーン",
    "BI" to "ブルンジ",
    "BJ" to "ベナン",
    "BL" to "サン・バルテルミー",
    "BM" to "バミューダ",
    "BN" to "ブルネイ",
    "BO" to "ボリビア",
    "BQ" to "オランダ領カリブ",
    "BR" to "ブラジル",
    "BS" to "バハマ",
    "BT" to "ブータン",
    "BV" to "ブーベ島",
    "BW" to "ボツワナ",
    "BY" to "ベラルーシ",
    "BZ" to "ベリーズ",
    "CA" to "カナダ",
    "CC" to "ココス(キーリング)諸島",
    "CD" to "コンゴ民主共和国(キンシャサ)",
    "CF" to "中央アフリカ共和国",
    "CG" to "コンゴ共和国(ブラザビル)",
    "CH" to "スイス",
    "CI" to "コートジボワール",
    "CK" to "クック諸島",
    "CL" to "チリ",
    "CM" to "カメルーン",
    "CN" to "中国",
    "CO" to "コロンビア",
    "CP" to "クリッパートン島",
    "CR" to "コスタリカ",
    "CU" to "キューバ",
    "CV" to "カーボベルデ",
    "CW" to "キュラソー",
    "CX" to "クリスマス島",
    "CY" to "キプロス",
    "CZ" to "チェコ",
    "DE" to "ドイツ",
    "DG" to "ディエゴガルシア島",
    "DJ" to "ジブチ",
    "DK" to "デンマーク",
    "DM" to "ドミニカ国",
    "DO" to "ドミニカ共和国",
    "DZ" to "アルジェリア",
    "EA" to "セウタ・メリリャ",
    "EC" to "エクアドル",
    "EE" to "エストニア",
    "EG" to "エジプト",
    "EH" to "西サハラ",
    "ER" to "エリトリア",
    "ES" to "スペイン",
    "ET" to "エチオピア",
    "EU" to "欧州連合",
    "EZ" to "ユーロ圏",
    "FI" to "フィンランド",
    "FJ" to "フィジー",
    "FK" to "フォークランド諸島",
    "FM" to "ミクロネシア連邦",
    "FO" to "フェロー諸島",
    "FR" to "フランス",
    "GA" to "ガボン",
    "GB" to "イギリス",
    "GD" to "グレナダ",
    "GE" to "ジョージア",
    "GF" to "仏領ギアナ",
    "GG" to "ガーンジー",
    "GH" to "ガーナ",
    "GI" to "ジブラルタル",
    "GL" to "グリーンランド",
    "GM" to "ガンビア",
    "GN" to "ギニア",
    "GP" to "グアドループ",
    "GQ" to "赤道ギニア",
    "GR" to "ギリシャ",
    "GS" to "サウスジョージア・サウスサンドウィッチ諸島",
    "GT" to "グアテマラ",
    "GU" to "グアム",
    "GW" to "ギニアビサウ",
    "GY" to "ガイアナ",
    "HK" to "中華人民共和国香港特別行政区",
    "HM" to "ハード島・マクドナルド諸島",
    "HN" to "ホンジュラス",
    "HR" to "クロアチア",
    "HT" to "ハイチ",
    "HU" to "ハンガリー",
    "IC" to "カナリア諸島",
    "ID" to "インドネシア",
    "IE" to "アイルランド",
    "IL" to "イスラエル",
    "IM" to "マン島",
    "IN" to "インド",
    "IO" to "英領インド洋地域",
    "IQ" to "イラク",
    "IR" to "イラン",
    "IS" to "アイスランド",
    "IT" to "イタリア",
    "JE" to "ジャージー",
    "JM" to "ジャマイカ",
    "JO" to "ヨルダン",
    "JP" to "日本",
    "KE" to "ケニア",
    "KG" to "キルギス",
    "KH" to "カンボジア",
    "KI" to "キリバス",
    "KM" to "コモロ",
    "KN" to "セントクリストファー・ネーヴィス",
    "KP" to "北朝鮮",
    "KR" to "韓国",
    "KW" to "クウェート",
    "KY" to "ケイマン諸島",
    "KZ" to "カザフスタン",
    "LA" to "ラオス",
    "LB" to "レバノン",
    "LC" to "セントルシア",
    "LI" to "リヒテンシュタイン",
    "LK" to "スリランカ",
    "LR" to "リベリア",
    "LS" to "レソト",
    "LT" to "リトアニア",
    "LU" to "ルクセンブルク",
    "LV" to "ラトビア",
    "LY" to "リビア",
    "MA" to "モロッコ",
    "MC" to "モナコ",
    "MD" to "モルドバ",
    "ME" to "モンテネグロ",
    "MF" to "サン・マルタン",
    "MG" to "マダガスカル",
    "MH" to "マーシャル諸島",
    "MK" to "北マケドニア",
    "ML" to "マリ",
    "MM" to "ミャンマー (ビルマ)",
    "MN" to "モンゴル",
    "MO" to "中華人民共和国マカオ特別行政区",
    "MP" to "北マリアナ諸島",
    "MQ" to "マルティニーク",
    "MR" to "モーリタニア",
    "MS" to "モントセラト",
    "MT" to "マルタ",
    "MU" to "モーリシャス",
    "MV" to "モルディブ",
    "MW" to "マラウイ",
    "MX" to "メキシコ",
    "MY" to "マレーシア",
    "MZ" to "モザンビーク",
    "NA" to "ナミビア",
    "NC" to "ニューカレドニア",
    "NE" to "ニジェール",
    "NF" to "ノーフォーク島",
    "NG" to "ナイジェリア",
    "NI" to "ニカラグア",
    "NL" to "オランダ",
    "NO" to "ノルウェー",
    "NP" to "ネパール",
    "NR" to "ナウル",
    "NU" to "ニウエ",
    "NZ" to "ニュージーランド",
    "OM" to "オマーン",
    "PA" to "パナマ",
    "PE" to "ペルー",
    "PF" to "仏領ポリネシア",
    "PG" to "パプアニューギニア",
    "PH" to "フィリピン",
    "PK" to "パキスタン",
    "PL" to "ポーランド",
    "PM" to "サンピエール島・ミクロン島",
    "PN" to "ピトケアン諸島",
    "PR" to "プエルトリコ",
    "PS" to "パレスチナ自治区",
    "PT" to "ポルトガル",
    "PW" to "パラオ",
    "PY" to "パラグアイ",
    "QA" to "カタール",
    "QO" to "オセアニア周辺地域",
    "RE" to "レユニオン",
    "RO" to "ルーマニア",
    "RS" to "セルビア",
    "RU" to "ロシア",
    "RW" to "ルワンダ",
    "SA" to "サウジアラビア",
    "SB" to "ソロモン諸島",
    "SC" to "セーシェル",
    "SD" to "スーダン",
    "SE" to "スウェーデン",
    "SG" to "シンガポール",
    "SH" to "セントヘレナ",
    "SI" to "スロベニア",
    "SJ" to "スバールバル諸島・ヤンマイエン島",
    "SK" to "スロバキア",
    "SL" to "シエラレオネ",
    "SM" to "サンマリノ",
    "SN" to "セネガル",
    "SO" to "ソマリア",
    "SR" to "スリナム",
    "SS" to "南スーダン",
    "ST" to "サントメ・プリンシペ",
    "SV" to "エルサルバドル",
    "SX" to "シント・マールテン",
    "SY" to "シリア",
    "SZ" to "エスワティニ",
    "TA" to "トリスタン・ダ・クーニャ",
    "TC" to "タークス・カイコス諸島",
    "TD" to "チャド",
    "TF" to "仏領極南諸島",
    "TG" to "トーゴ",
    "TH" to "タイ",
    "TJ" to "タジキスタン",
    "TK" to "トケラウ",
    "TL" to "東ティモール",
    "TM" to "トルクメニスタン",
    "TN" to "チュニジア",
    "TO" to "トンガ",
    "TR" to "トルコ",
    "TT" to "トリニダード・トバゴ",
    "TV" to "ツバル",
    "TW" to "台湾",
    "TZ" to "タンザニア",
    "UA" to "ウクライナ",
    "UG" to "ウガンダ",
    "UM" to "合衆国領有小離島",
    "UN" to "国際連合",
    "US" to "アメリカ合衆国",
    "UY" to "ウルグアイ",
    "UZ" to "ウズベキスタン",
    "VA" to "バチカン市国",
    "VC" to "セントビンセント及びグレナディーン諸島",
    "VE" to "ベネズエラ",
    "VG" to "英領ヴァージン諸島",
    "VI" to "米領ヴァージン諸島",
    "VN" to "ベトナム",
    "VU" to "バヌアツ",
    "WF" to "ウォリス・フツナ",
    "WS" to "サモア",
    "XA" to "疑似アクセント",
    "XB" to "疑似 BIDI",
    "XK" to "コソボ",
    "YE" to "イエメン",
    "YT" to "マヨット",
    "ZA" to "南アフリカ",
    "ZM" to "ザンビア",
    "ZW" to "ジンバブエ",
    "ZZ" to "不明な地域",
  ) }

  val jgo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Mbí",
    "002" to "Afɛlîk",
    "019" to "Amɛlîk",
    "142" to "Azî",
    "150" to "Ʉlôp",
    "AO" to "Aŋgɔ́la",
    "AR" to "Ajɛntîn",
    "BF" to "Mbulukína Fásɔ",
    "BI" to "Mbulundí",
    "BJ" to "Mbɛnɛ̂ŋ",
    "BO" to "Mbɔlivî",
    "BR" to "Mbɛlazîl",
    "BW" to "Mbɔtswána",
    "CA" to "Kanadâ",
    "CD" to "Kɔ́ŋgɔ-Kinshása",
    "CG" to "Kɔ́ŋgɔ-Mbɛlazavîl",
    "CH" to "Sẅísɛ",
    "CI" to "Kɔ́t Ndivwâ",
    "CL" to "Cíllɛ",
    "CM" to "Kamɛlûn",
    "CN" to "Shîn",
    "CO" to "Kɔllɔmbî",
    "CU" to "Kúba",
    "DE" to "Njáman",
    "DJ" to "Njimbúti",
    "DZ" to "Aljɛlî",
    "EC" to "Ɛkwandɔ̂",
    "EG" to "Ɛjíptɛ",
    "ER" to "Ɛlitɛlɛ́ya",
    "ES" to "Ɛspániya",
    "ET" to "Ɛtiyɔpî",
    "FR" to "Fɛlánci",
    "GA" to "Ŋgabɔ̂ŋ",
    "GH" to "Ŋgána",
    "GM" to "Ŋgambî",
    "GN" to "Ŋginɛ̂",
    "GQ" to "Ŋginɛ̂ Ɛkwatɔliyâl",
    "GR" to "Ŋgɛlɛ̂k",
    "GW" to "Ŋginɛ̂ Mbisáwu",
    "IL" to "Islayɛ̂l",
    "IN" to "Ándɛ",
    "IQ" to "Ilâk",
    "IT" to "Italî",
    "JP" to "Japɔ̂n",
    "KE" to "Kɛ́nya",
    "KM" to "Kɔmɔ́lɔshi",
    "LR" to "Libɛrî",
    "LS" to "Lɛsɔ́tɔ",
    "LY" to "Libî",
    "MA" to "Mɔlɔ̂k",
    "MG" to "Mándaŋgasɛkâ",
    "ML" to "Malî",
    "MR" to "Mɔlitanî",
    "MW" to "Maláwi",
    "MX" to "Mɛksîk",
    "MZ" to "Mɔzambîk",
    "NA" to "Namimbî",
    "NE" to "Nijɛ̂",
    "NG" to "Ninjɛliyâ",
    "NO" to "Nɔlɛvɛ́jɛ",
    "PE" to "Pɛlû",
    "RE" to "Lɛ́uniyɔ̂n",
    "RS" to "Sɛlɛbî",
    "RU" to "Lusî",
    "RW" to "Luwánda",
    "SC" to "Pɛsɛ́shɛl",
    "SD" to "Sundân",
    "SL" to "Siyɛ́la Lɛɔ̂n",
    "SN" to "Sɛnɛgâl",
    "SO" to "Sɔmalî",
    "ST" to "Sáwɔŋ Tɔmɛ́ nɛ́ Pɛlínsipɛ",
    "SZ" to "Swazilân",
    "TD" to "Cât",
    "TG" to "Tɔ́ŋgɔ",
    "TN" to "Tunizî",
    "TZ" to "Tanzanî",
    "UG" to "Uŋgánda",
    "VE" to "Vɛnɛzwɛ́la",
    "YT" to "Mayɔ̂t",
    "ZM" to "Zambî",
    "ZW" to "Zimbámbwɛ",
    "ZZ" to "ŋgɔŋ yi pɛ́ ká kɛ́ jʉɔ",
  ) }

  val jmc: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Falme za Kiarabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AR" to "Ajentina",
    "AS" to "Samoa ya Marekani",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AZ" to "Azabajani",
    "BA" to "Bosnia na Hezegovina",
    "BB" to "Babadosi",
    "BD" to "Bangladeshi",
    "BE" to "Ubelgiji",
    "BF" to "Bukinafaso",
    "BG" to "Bulgaria",
    "BH" to "Bahareni",
    "BI" to "Burundi",
    "BJ" to "Benini",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BR" to "Brazili",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botswana",
    "BY" to "Belarusi",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CD" to "Jamhuri ya Kidemokrasia ya Kongo",
    "CF" to "Jamhuri ya Afrika ya Kati",
    "CG" to "Kongo",
    "CH" to "Uswisi",
    "CI" to "Kodivaa",
    "CK" to "Visiwa vya Cook",
    "CL" to "Chile",
    "CM" to "Kameruni",
    "CN" to "China",
    "CO" to "Kolombia",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Kepuvede",
    "CY" to "Kuprosi",
    "CZ" to "Jamhuri ya Cheki",
    "DE" to "Ujerumani",
    "DJ" to "Jibuti",
    "DK" to "Denmaki",
    "DM" to "Dominika",
    "DO" to "Jamhuri ya Dominika",
    "DZ" to "Aljeria",
    "EC" to "Ekwado",
    "EE" to "Estonia",
    "EG" to "Misri",
    "ER" to "Eritrea",
    "ES" to "Hispania",
    "ET" to "Uhabeshi",
    "FI" to "Ufini",
    "FJ" to "Fiji",
    "FK" to "Visiwa vya Falkland",
    "FM" to "Mikronesia",
    "FR" to "Ufaransa",
    "GA" to "Gaboni",
    "GB" to "Uingereza",
    "GD" to "Grenada",
    "GE" to "Jojia",
    "GF" to "Gwiyana ya Ufaransa",
    "GH" to "Ghana",
    "GI" to "Jibralta",
    "GL" to "Grinlandi",
    "GM" to "Gambia",
    "GN" to "Gine",
    "GP" to "Gwadelupe",
    "GQ" to "Ginekweta",
    "GR" to "Ugiriki",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Hondurasi",
    "HR" to "Korasia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "ID" to "Indonesia",
    "IE" to "Ayalandi",
    "IL" to "Israeli",
    "IN" to "India",
    "IQ" to "Iraki",
    "IR" to "Uajemi",
    "IS" to "Aislandi",
    "IT" to "Italia",
    "JM" to "Jamaika",
    "JO" to "Yordani",
    "JP" to "Japani",
    "KE" to "Kenya",
    "KG" to "Kirigizistani",
    "KH" to "Kambodia",
    "KI" to "Kiribati",
    "KM" to "Komoro",
    "KN" to "Santakitzi na Nevis",
    "KP" to "Korea Kaskazini",
    "KR" to "Korea Kusini",
    "KW" to "Kuwaiti",
    "KY" to "Visiwa vya Kayman",
    "KZ" to "Kazakistani",
    "LA" to "Laosi",
    "LB" to "Lebanoni",
    "LC" to "Santalusia",
    "LI" to "Lishenteni",
    "LK" to "Sirilanka",
    "LR" to "Liberia",
    "LS" to "Lesoto",
    "LT" to "Litwania",
    "LU" to "Lasembagi",
    "LV" to "Lativia",
    "LY" to "Libya",
    "MA" to "Moroko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "MG" to "Bukini",
    "MH" to "Visiwa vya Marshal",
    "ML" to "Mali",
    "MM" to "Myama",
    "MN" to "Mongolia",
    "MP" to "Visiwa vya Mariana vya Kaskazini",
    "MQ" to "Martiniki",
    "MR" to "Moritania",
    "MS" to "Montserrati",
    "MT" to "Malta",
    "MU" to "Morisi",
    "MV" to "Modivu",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malesia",
    "MZ" to "Msumbiji",
    "NA" to "Namibia",
    "NC" to "Nyukaledonia",
    "NE" to "Nijeri",
    "NF" to "Kisiwa cha Norfok",
    "NG" to "Nijeria",
    "NI" to "Nikaragwa",
    "NL" to "Uholanzi",
    "NO" to "Norwe",
    "NP" to "Nepali",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nyuzilandi",
    "OM" to "Omani",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia ya Ufaransa",
    "PG" to "Papua",
    "PH" to "Filipino",
    "PK" to "Pakistani",
    "PL" to "Polandi",
    "PM" to "Santapieri na Mikeloni",
    "PN" to "Pitkairni",
    "PR" to "Pwetoriko",
    "PS" to "Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina",
    "PT" to "Ureno",
    "PW" to "Palau",
    "PY" to "Paragwai",
    "QA" to "Katari",
    "RE" to "Riyunioni",
    "RO" to "Romania",
    "RU" to "Urusi",
    "RW" to "Rwanda",
    "SA" to "Saudi",
    "SB" to "Visiwa vya Solomon",
    "SC" to "Shelisheli",
    "SD" to "Sudani",
    "SE" to "Uswidi",
    "SG" to "Singapoo",
    "SH" to "Santahelena",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SL" to "Siera Leoni",
    "SM" to "Samarino",
    "SN" to "Senegali",
    "SO" to "Somalia",
    "SR" to "Surinamu",
    "ST" to "Sao Tome na Principe",
    "SV" to "Elsavado",
    "SY" to "Siria",
    "SZ" to "Uswazi",
    "TC" to "Visiwa vya Turki na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tailandi",
    "TJ" to "Tajikistani",
    "TK" to "Tokelau",
    "TL" to "Timori ya Mashariki",
    "TM" to "Turukimenistani",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Uturuki",
    "TT" to "Trinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tanzania",
    "UA" to "Ukraini",
    "UG" to "Uganda",
    "US" to "Marekani",
    "UY" to "Urugwai",
    "UZ" to "Uzibekistani",
    "VA" to "Vatikani",
    "VC" to "Santavisenti na Grenadini",
    "VE" to "Venezuela",
    "VG" to "Visiwa vya Virgin vya Uingereza",
    "VI" to "Visiwa vya Virgin vya Marekani",
    "VN" to "Vietinamu",
    "VU" to "Vanuatu",
    "WF" to "Walis na Futuna",
    "WS" to "Samoa",
    "YE" to "Yemeni",
    "YT" to "Mayotte",
    "ZA" to "Afrika Kusini",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
  ) }

  val jv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Donya",
    "002" to "Afrika",
    "003" to "Amérika Lor",
    "005" to "Amérika Kidul",
    "009" to "Oséania",
    "011" to "Afrika Kulon",
    "013" to "Amérika Tengah",
    "014" to "Afrika Wétan",
    "015" to "Afrika Lor",
    "017" to "Afrika Sisih Tengah",
    "018" to "Afrika Sisih Kidul",
    "019" to "Amérika",
    "021" to "Amérika Sisih Lor",
    "029" to "Karibia",
    "030" to "Asia Wétan",
    "034" to "Asia Kidul",
    "035" to "Asia Kidul-wétan",
    "039" to "Éropah Kidul",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Daerah Mikronesia",
    "061" to "Polinesia",
    "142" to "Asia",
    "143" to "Asia Tengah",
    "145" to "Asia Kulon",
    "150" to "Éropah",
    "151" to "Éropah Wétan",
    "154" to "Éropah Lor",
    "155" to "Éropah Kulon",
    "202" to "Afrika Kidule Sahara",
    "419" to "Amérika Latin",
    "AC" to "Pulo Ascension",
    "AD" to "Andora",
    "AE" to "Uni Émirat Arab",
    "AF" to "Afganistan",
    "AG" to "Antigua lan Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albani",
    "AM" to "Arménia",
    "AO" to "Angola",
    "AQ" to "Antartika",
    "AR" to "Argèntina",
    "AS" to "Samoa Amerika",
    "AT" to "Ostenrik",
    "AU" to "Ostrali",
    "AW" to "Aruba",
    "AX" to "Kapuloan Alan",
    "AZ" to "Azerbaijan",
    "BA" to "Bosnia lan Hèrségovina",
    "BB" to "Barbadhos",
    "BD" to "Banggaladésa",
    "BE" to "Bèlgi",
    "BF" to "Burkina Faso",
    "BG" to "Bulgari",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Bénin",
    "BL" to "Saint Barthélémi",
    "BM" to "Bermuda",
    "BN" to "Brunéi",
    "BO" to "Bolivia",
    "BQ" to "Karibia Walanda",
    "BR" to "Brasil",
    "BS" to "Bahama",
    "BT" to "Bhutan",
    "BV" to "Pulo Bovèt",
    "BW" to "Botswana",
    "BY" to "Bélarus",
    "BZ" to "Bélisé",
    "CA" to "Kanada",
    "CC" to "Kapuloan Cocos (Keeling)",
    "CD" to "Kongo - Kinshasa",
    "CF" to "Républik Afrika Tengah",
    "CG" to "Kongo - Brassaville",
    "CH" to "Switserlan",
    "CI" to "Pasisir Gadhing",
    "CK" to "Kapuloan Cook",
    "CL" to "Cilé",
    "CM" to "Kamerun",
    "CN" to "Tyongkok",
    "CO" to "Kolombia",
    "CP" to "Pulo Clipperton",
    "CR" to "Kosta Rika",
    "CU" to "Kuba",
    "CV" to "Pongol Verdé",
    "CW" to "Kurasao",
    "CX" to "Pulo Natal",
    "CY" to "Siprus",
    "CZ" to "Céko",
    "DE" to "Jérman",
    "DG" to "Diego Garcia",
    "DJ" to "Jibuti",
    "DK" to "Dhènemarken",
    "DM" to "Dominika",
    "DO" to "Républik Dominika",
    "DZ" to "Aljasair",
    "EA" to "Séuta lan Melila",
    "EC" to "Ékuadhor",
    "EE" to "Éstonia",
    "EG" to "Mesir",
    "EH" to "Sahara Kulon",
    "ER" to "Éritréa",
    "ES" to "Sepanyol",
    "ET" to "Étiopia",
    "EU" to "Uni Éropah",
    "EZ" to "Zona Éuro",
    "FI" to "Finlan",
    "FJ" to "Fiji",
    "FK" to "Kapuloan Falkland",
    "FM" to "Féderasi Mikronésia",
    "FO" to "Kapuloan Faro",
    "FR" to "Prancis",
    "GA" to "Gabon",
    "GB" to "Karajan Manunggal",
    "GD" to "Grénada",
    "GE" to "Géorgia",
    "GF" to "Guyana Prancis",
    "GG" to "Guernsei",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Greenland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadélup",
    "GQ" to "Guinéa Katulistiwa",
    "GR" to "Grikenlan",
    "GS" to "Georgia Kidul lan Kapuloan Sandwich Kidul",
    "GT" to "Guatémala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Laladan Administratif Astamiwa Hong Kong",
    "HM" to "Kapuloan Heard lan McDonald",
    "HN" to "Honduras",
    "HR" to "Kroasia",
    "HT" to "Haiti",
    "HU" to "Honggari",
    "IC" to "Kapuloan Kanari",
    "ID" to "Indonésia",
    "IE" to "Républik Irlan",
    "IL" to "Israèl",
    "IM" to "Pulo Man",
    "IN" to "Indhia",
    "IO" to "Wilayah Inggris ing Segara Hindia",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Èslan",
    "IT" to "Itali",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Yordania",
    "JP" to "Jepang",
    "KE" to "Kénya",
    "KG" to "Kirgistan",
    "KH" to "Kamboja",
    "KI" to "Kiribati",
    "KM" to "Komoro",
    "KN" to "Saint Kits lan Nèvis",
    "KP" to "Korea Lor",
    "KR" to "Koréa Kidul",
    "KW" to "Kuwait",
    "KY" to "Kapuloan Kéman",
    "KZ" to "Kasakstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "Santa Lusia",
    "LI" to "Liktenstén",
    "LK" to "Sri Lanka",
    "LR" to "Libèria",
    "LS" to "Lésotho",
    "LT" to "Litowen",
    "LU" to "Luksemburg",
    "LV" to "Latvia",
    "LY" to "Libya",
    "MA" to "Maroko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "ME" to "Montenégro",
    "MF" to "Santa Martin",
    "MG" to "Madagaskar",
    "MH" to "Kapuloan Marshall",
    "MK" to "Républik Makédonia Lor",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Laladan Administratif Astamiwa Makau",
    "MP" to "Kapuloan Mariana Lor",
    "MQ" to "Martinik",
    "MR" to "Mauritania",
    "MS" to "Monsérat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maladéwa",
    "MW" to "Malawi",
    "MX" to "Mèksiko",
    "MY" to "Malaysia",
    "MZ" to "Mosambik",
    "NA" to "Namibia",
    "NC" to "Kalédonia Anyar",
    "NE" to "Nigér",
    "NF" to "Pulo Norfolk",
    "NG" to "Nigéria",
    "NI" to "Nikaragua",
    "NL" to "Walanda",
    "NO" to "Nurwègen",
    "NP" to "Népal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Selandia Anyar",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia Prancis",
    "PG" to "Papua Nugini",
    "PH" to "Pilipina",
    "PK" to "Pakistan",
    "PL" to "Polen",
    "PM" to "Saint Pièr lan Mikuélon",
    "PN" to "Kapuloan Pitcairn",
    "PR" to "Puèrto Riko",
    "PS" to "Tlatah Palèstina",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Katar",
    "QO" to "Oseania Paling Njaba",
    "RE" to "Réunion",
    "RO" to "Ruméni",
    "RS" to "Sèrbi",
    "RU" to "Rusia",
    "RW" to "Rwanda",
    "SA" to "Arab Saudi",
    "SB" to "Kapuloan Suleman",
    "SC" to "Sésèl",
    "SD" to "Sudan",
    "SE" to "Swèdhen",
    "SG" to "Singapura",
    "SH" to "Saint Héléna",
    "SI" to "Slovénia",
    "SJ" to "Svalbard lan Jan Mayen",
    "SK" to "Slowak",
    "SL" to "Siéra Léoné",
    "SM" to "San Marino",
    "SN" to "Sénégal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "Sudan Kidul",
    "ST" to "Sao Tomé lan Principé",
    "SV" to "Èl Salvador",
    "SX" to "Sint Martén",
    "SY" to "Suriah",
    "SZ" to "Swasiland",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks lan Kapuloan Kaikos",
    "TD" to "Chad",
    "TF" to "Wilayah Prancis nang Kutub Kidul",
    "TG" to "Togo",
    "TH" to "Tanah Thai",
    "TJ" to "Tajikistan",
    "TK" to "Tokelau",
    "TL" to "Timor Leste",
    "TM" to "Turkménistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turki",
    "TT" to "Trinidad lan Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tansania",
    "UA" to "Ukrania",
    "UG" to "Uganda",
    "UM" to "Kapuloan AS Paling Njaba",
    "UN" to "Pasarékatan Bangsa-Bangsa",
    "US" to "Amérika Sarékat",
    "UY" to "Uruguay",
    "UZ" to "Usbèkistan",
    "VA" to "Kutha Vatikan",
    "VC" to "Saint Vinsen lan Grénadin",
    "VE" to "Vénésuéla",
    "VG" to "Kapuloan Virgin Britania",
    "VI" to "Kapuloan Virgin Amérika",
    "VN" to "Viètnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis lan Futuna",
    "WS" to "Samoa",
    "XA" to "Logat Semu",
    "XB" to "Rong Arah Semu",
    "XK" to "Kosovo",
    "YE" to "Yaman",
    "YT" to "Mayotte",
    "ZA" to "Afrika Kidul",
    "ZM" to "Sambia",
    "ZW" to "Simbabwe",
    "ZZ" to "Daerah Ora Dikenali",
  ) }

  val ka: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "მსოფლიო",
    "002" to "აფრიკა",
    "003" to "ჩრდილოეთ ამერიკა",
    "005" to "სამხრეთ ამერიკა",
    "009" to "ოკეანეთი",
    "011" to "დასავლეთ აფრიკა",
    "013" to "ცენტრალური ამერიკა",
    "014" to "აღმოსავლეთ აფრიკა",
    "015" to "ჩრდილოეთ აფრიკა",
    "017" to "შუა აფრიკა",
    "018" to "სამხრეთ აფრიკა",
    "019" to "ამერიკები",
    "021" to "ამერიკის ჩრდილოეთი",
    "029" to "კარიბის ზღვა",
    "030" to "აღმოსავლეთ აზია",
    "034" to "სამხრეთ აზია",
    "035" to "სამხრეთ-აღმოსავლეთ აზია",
    "039" to "სამხრეთ ევროპა",
    "053" to "ავსტრალაზია",
    "054" to "მელანეზია",
    "057" to "მიკრონეზიის რეგიონი",
    "061" to "პოლინეზია",
    "142" to "აზია",
    "143" to "ცენტრალური აზია",
    "145" to "დასავლეთ აზია",
    "150" to "ევროპა",
    "151" to "აღმოსავლეთ ევროპა",
    "154" to "ჩრდილოეთ ევროპა",
    "155" to "დასავლეთ ევროპა",
    "202" to "სუბსაჰარული აფრიკა",
    "419" to "ლათინური ამერიკა",
    "AC" to "ამაღლების კუნძული",
    "AD" to "ანდორა",
    "AE" to "არაბთა გაერთიანებული საამიროები",
    "AF" to "ავღანეთი",
    "AG" to "ანტიგუა და ბარბუდა",
    "AI" to "ანგილია",
    "AL" to "ალბანეთი",
    "AM" to "სომხეთი",
    "AO" to "ანგოლა",
    "AQ" to "ანტარქტიკა",
    "AR" to "არგენტინა",
    "AS" to "ამერიკის სამოა",
    "AT" to "ავსტრია",
    "AU" to "ავსტრალია",
    "AW" to "არუბა",
    "AX" to "ალანდის კუნძულები",
    "AZ" to "აზერბაიჯანი",
    "BA" to "ბოსნია და ჰერცეგოვინა",
    "BB" to "ბარბადოსი",
    "BD" to "ბანგლადეში",
    "BE" to "ბელგია",
    "BF" to "ბურკინა-ფასო",
    "BG" to "ბულგარეთი",
    "BH" to "ბაჰრეინი",
    "BI" to "ბურუნდი",
    "BJ" to "ბენინი",
    "BL" to "სენ-ბართელმი",
    "BM" to "ბერმუდა",
    "BN" to "ბრუნეი",
    "BO" to "ბოლივია",
    "BQ" to "კარიბის ნიდერლანდები",
    "BR" to "ბრაზილია",
    "BS" to "ბაჰამის კუნძულები",
    "BT" to "ბუტანი",
    "BV" to "ბუვე",
    "BW" to "ბოტსვანა",
    "BY" to "ბელარუსი",
    "BZ" to "ბელიზი",
    "CA" to "კანადა",
    "CC" to "ქოქოსის (კილინგის) კუნძულები",
    "CD" to "კონგო - კინშასა",
    "CF" to "ცენტრალური აფრიკის რესპუბლიკა",
    "CG" to "კონგო - ბრაზავილი",
    "CH" to "შვეიცარია",
    "CI" to "კოტ-დივუარი",
    "CK" to "კუკის კუნძულები",
    "CL" to "ჩილე",
    "CM" to "კამერუნი",
    "CN" to "ჩინეთი",
    "CO" to "კოლუმბია",
    "CP" to "კლიპერტონის კუნძული",
    "CR" to "კოსტა-რიკა",
    "CU" to "კუბა",
    "CV" to "კაბო-ვერდე",
    "CW" to "კიურასაო",
    "CX" to "შობის კუნძული",
    "CY" to "კვიპროსი",
    "CZ" to "ჩეხეთი",
    "DE" to "გერმანია",
    "DG" to "დიეგო-გარსია",
    "DJ" to "ჯიბუტი",
    "DK" to "დანია",
    "DM" to "დომინიკა",
    "DO" to "დომინიკელთა რესპუბლიკა",
    "DZ" to "ალჟირი",
    "EA" to "სეუტა და მელილა",
    "EC" to "ეკვადორი",
    "EE" to "ესტონეთი",
    "EG" to "ეგვიპტე",
    "EH" to "დასავლეთ საჰარა",
    "ER" to "ერიტრეა",
    "ES" to "ესპანეთი",
    "ET" to "ეთიოპია",
    "EU" to "ევროკავშირი",
    "EZ" to "ევროზონა",
    "FI" to "ფინეთი",
    "FJ" to "ფიჯი",
    "FK" to "ფოლკლენდის კუნძულები",
    "FM" to "მიკრონეზია",
    "FO" to "ფარერის კუნძულები",
    "FR" to "საფრანგეთი",
    "GA" to "გაბონი",
    "GB" to "გაერთიანებული სამეფო",
    "GD" to "გრენადა",
    "GE" to "საქართველო",
    "GF" to "საფრანგეთის გვიანა",
    "GG" to "გერნსი",
    "GH" to "განა",
    "GI" to "გიბრალტარი",
    "GL" to "გრენლანდია",
    "GM" to "გამბია",
    "GN" to "გვინეა",
    "GP" to "გვადელუპა",
    "GQ" to "ეკვატორული გვინეა",
    "GR" to "საბერძნეთი",
    "GS" to "სამხრეთ ჯორჯია და სამხრეთ სენდვიჩის კუნძულები",
    "GT" to "გვატემალა",
    "GU" to "გუამი",
    "GW" to "გვინეა-ბისაუ",
    "GY" to "გაიანა",
    "HK" to "ჰონკონგის სპეციალური ადმინისტრაციული რეგიონი, ჩინეთი",
    "HM" to "ჰერდი და მაკდონალდის კუნძულები",
    "HN" to "ჰონდურასი",
    "HR" to "ხორვატია",
    "HT" to "ჰაიტი",
    "HU" to "უნგრეთი",
    "IC" to "კანარის კუნძულები",
    "ID" to "ინდონეზია",
    "IE" to "ირლანდია",
    "IL" to "ისრაელი",
    "IM" to "მენის კუნძული",
    "IN" to "ინდოეთი",
    "IO" to "ბრიტანეთის ტერიტორია ინდოეთის ოკეანეში",
    "IQ" to "ერაყი",
    "IR" to "ირანი",
    "IS" to "ისლანდია",
    "IT" to "იტალია",
    "JE" to "ჯერსი",
    "JM" to "იამაიკა",
    "JO" to "იორდანია",
    "JP" to "იაპონია",
    "KE" to "კენია",
    "KG" to "ყირგიზეთი",
    "KH" to "კამბოჯა",
    "KI" to "კირიბატი",
    "KM" to "კომორის კუნძულები",
    "KN" to "სენტ-კიტსი და ნევისი",
    "KP" to "ჩრდილოეთ კორეა",
    "KR" to "სამხრეთ კორეა",
    "KW" to "ქუვეითი",
    "KY" to "კაიმანის კუნძულები",
    "KZ" to "ყაზახეთი",
    "LA" to "ლაოსი",
    "LB" to "ლიბანი",
    "LC" to "სენტ-ლუსია",
    "LI" to "ლიხტენშტაინი",
    "LK" to "შრი-ლანკა",
    "LR" to "ლიბერია",
    "LS" to "ლესოთო",
    "LT" to "ლიეტუვა",
    "LU" to "ლუქსემბურგი",
    "LV" to "ლატვია",
    "LY" to "ლიბია",
    "MA" to "მაროკო",
    "MC" to "მონაკო",
    "MD" to "მოლდოვა",
    "ME" to "მონტენეგრო",
    "MF" to "სენ-მარტენი",
    "MG" to "მადაგასკარი",
    "MH" to "მარშალის კუნძულები",
    "MK" to "ჩრდილოეთ მაკედონია",
    "ML" to "მალი",
    "MM" to "მიანმარი (ბირმა)",
    "MN" to "მონღოლეთი",
    "MO" to "მაკაოს სპეციალური ადმინისტრაციული რეგიონი, ჩინეთი",
    "MP" to "ჩრდილოეთ მარიანას კუნძულები",
    "MQ" to "მარტინიკა",
    "MR" to "მავრიტანია",
    "MS" to "მონსერატი",
    "MT" to "მალტა",
    "MU" to "მავრიკი",
    "MV" to "მალდივები",
    "MW" to "მალავი",
    "MX" to "მექსიკა",
    "MY" to "მალაიზია",
    "MZ" to "მოზამბიკი",
    "NA" to "ნამიბია",
    "NC" to "ახალი კალედონია",
    "NE" to "ნიგერი",
    "NF" to "ნორფოლკის კუნძული",
    "NG" to "ნიგერია",
    "NI" to "ნიკარაგუა",
    "NL" to "ნიდერლანდები",
    "NO" to "ნორვეგია",
    "NP" to "ნეპალი",
    "NR" to "ნაურუ",
    "NU" to "ნიუე",
    "NZ" to "ახალი ზელანდია",
    "OM" to "ომანი",
    "PA" to "პანამა",
    "PE" to "პერუ",
    "PF" to "საფრანგეთის პოლინეზია",
    "PG" to "პაპუა-ახალი გვინეა",
    "PH" to "ფილიპინები",
    "PK" to "პაკისტანი",
    "PL" to "პოლონეთი",
    "PM" to "სენ-პიერი და მიკელონი",
    "PN" to "პიტკერნის კუნძულები",
    "PR" to "პუერტო-რიკო",
    "PS" to "პალესტინის ტერიტორიები",
    "PT" to "პორტუგალია",
    "PW" to "პალაუ",
    "PY" to "პარაგვაი",
    "QA" to "კატარი",
    "QO" to "შორეული ოკეანეთი",
    "RE" to "რეუნიონი",
    "RO" to "რუმინეთი",
    "RS" to "სერბეთი",
    "RU" to "რუსეთი",
    "RW" to "რუანდა",
    "SA" to "საუდის არაბეთი",
    "SB" to "სოლომონის კუნძულები",
    "SC" to "სეიშელის კუნძულები",
    "SD" to "სუდანი",
    "SE" to "შვედეთი",
    "SG" to "სინგაპური",
    "SH" to "წმინდა ელენეს კუნძული",
    "SI" to "სლოვენია",
    "SJ" to "შპიცბერგენი და იან-მაიენი",
    "SK" to "სლოვაკეთი",
    "SL" to "სიერა-ლეონე",
    "SM" to "სან-მარინო",
    "SN" to "სენეგალი",
    "SO" to "სომალი",
    "SR" to "სურინამი",
    "SS" to "სამხრეთ სუდანი",
    "ST" to "სან-ტომე და პრინსიპი",
    "SV" to "სალვადორი",
    "SX" to "სინტ-მარტენი",
    "SY" to "სირია",
    "SZ" to "სვაზილენდი",
    "TA" to "ტრისტან-და-კუნია",
    "TC" to "თერქს-ქაიქოსის კუნძულები",
    "TD" to "ჩადი",
    "TF" to "ფრანგული სამხრეთის ტერიტორიები",
    "TG" to "ტოგო",
    "TH" to "ტაილანდი",
    "TJ" to "ტაჯიკეთი",
    "TK" to "ტოკელაუ",
    "TL" to "ტიმორ-ლესტე",
    "TM" to "თურქმენეთი",
    "TN" to "ტუნისი",
    "TO" to "ტონგა",
    "TR" to "თურქეთი",
    "TT" to "ტრინიდადი და ტობაგო",
    "TV" to "ტუვალუ",
    "TW" to "ტაივანი",
    "TZ" to "ტანზანია",
    "UA" to "უკრაინა",
    "UG" to "უგანდა",
    "UM" to "აშშ-ის შორეული კუნძულები",
    "UN" to "გაერო",
    "US" to "ამერიკის შეერთებული შტატები",
    "UY" to "ურუგვაი",
    "UZ" to "უზბეკეთი",
    "VA" to "ქალაქი ვატიკანი",
    "VC" to "სენტ-ვინსენტი და გრენადინები",
    "VE" to "ვენესუელა",
    "VG" to "ბრიტანეთის ვირჯინის კუნძულები",
    "VI" to "აშშ-ის ვირჯინის კუნძულები",
    "VN" to "ვიეტნამი",
    "VU" to "ვანუატუ",
    "WF" to "უოლისი და ფუტუნა",
    "WS" to "სამოა",
    "XA" to "ფსევდო-აქცენტები",
    "XB" to "ფსევდო-ორმიმართულებიანი",
    "XK" to "კოსოვო",
    "YE" to "იემენი",
    "YT" to "მაიოტა",
    "ZA" to "სამხრეთ აფრიკის რესპუბლიკა",
    "ZM" to "ზამბია",
    "ZW" to "ზიმბაბვე",
    "ZZ" to "უცნობი რეგიონი",
  ) }

  val kaa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "дүнья",
    "002" to "Африка",
    "003" to "Арқа Америка",
    "005" to "Қубла Америка",
    "009" to "Океания",
    "011" to "Батыс Африка",
    "013" to "Орайлық Америка",
    "014" to "Шығыс Африка",
    "015" to "Арқа Африка",
    "017" to "Орайлық Африка",
    "018" to "Қубла Африка",
    "019" to "Америка",
    "021" to "Арқа Америка – AҚШ ҳәм Канада",
    "029" to "Кариб бассейни",
    "030" to "Шығыс Азия",
    "034" to "Қубла Азия",
    "035" to "Қубла-шығыс Азия",
    "039" to "Қубла Европа",
    "053" to "Австралазия",
    "054" to "Меланезия",
    "057" to "Микронезия",
    "061" to "Полинезия",
    "142" to "Азия",
    "143" to "Орайлық Азия",
    "145" to "Батыс Азия",
    "150" to "Европа",
    "151" to "Шығыс Европа",
    "154" to "Арқа Европа",
    "155" to "Батыс Европа",
    "202" to "Тропикалық Африка",
    "419" to "Латын Америкасы",
    "AD" to "Андорра",
    "AE" to "Бирлескен Араб Әмирликлери",
    "AF" to "Аўғанстан",
    "AG" to "Антигуа ҳәм Барбуда",
    "AI" to "Ангилья",
    "AL" to "Албания",
    "AM" to "Армения",
    "AO" to "Ангола",
    "AR" to "Аргентина",
    "AT" to "Австрия",
    "AU" to "Австралия",
    "AW" to "Аруба",
    "AX" to "Аланд атаўлары",
    "AZ" to "Әзербайжан",
    "BA" to "Босния ҳәм Герцеговина",
    "BB" to "Барбадос",
    "BD" to "Бангладеш",
    "BE" to "Бельгия",
    "BF" to "Буркина-Фасо",
    "BG" to "Болгария",
    "BH" to "Бахрейн",
    "BI" to "Бурунди",
    "BJ" to "Бенин",
    "BL" to "Сен-Бартелеми",
    "BM" to "Бермуд атаўлары",
    "BN" to "Бруней",
    "BO" to "Боливия",
    "BQ" to "Бонэйр, Синт-Эстатиус ҳәм Саба",
    "BR" to "Бразилия",
    "BS" to "Багама атаўлары",
    "BT" to "Бутан",
    "BV" to "Буве атаўы",
    "BW" to "Ботсвана",
    "BY" to "Беларусь",
    "BZ" to "Белиз",
    "CA" to "Канада",
    "CC" to "Кокос атаўлары",
    "CD" to "Конго - Киншаса",
    "CF" to "Орайлық Африка Республикасы",
    "CG" to "Конго - Браззавиль",
    "CH" to "Швейцария",
    "CI" to "Кот-дИвуар",
    "CK" to "Кук атаўлары",
    "CL" to "Чили",
    "CM" to "Камерун",
    "CN" to "Қытай",
    "CO" to "Колумбия",
    "CR" to "Коста-Рика",
    "CU" to "Куба",
    "CV" to "Кабо-Верде",
    "CW" to "Кюрасао",
    "CY" to "Кипр",
    "CZ" to "Чехия",
    "DE" to "Германия",
    "DJ" to "Джибути",
    "DK" to "Дания",
    "DM" to "Доминика",
    "DO" to "Доминикана Республикасы",
    "DZ" to "Алжир",
    "EA" to "Сеута ҳәм Мелилья",
    "EC" to "Эквадор",
    "EE" to "Эстония",
    "EG" to "Мысыр",
    "EH" to "Батыс Сахара",
    "ER" to "Эритрея",
    "ES" to "Испания",
    "ET" to "Эфиопия",
    "EU" to "Европа Аўқамы",
    "EZ" to "Еврозона",
    "FI" to "Финляндия",
    "FJ" to "Фиджи",
    "FK" to "Фолкленд атаўлары",
    "FM" to "Микронезия Федеративлик Штатлары",
    "FO" to "Фарер атаўлары",
    "FR" to "Франция",
    "GA" to "Габон",
    "GB" to "Уллы Британия",
    "GD" to "Гренада",
    "GE" to "Грузия",
    "GF" to "Француз Гвианасы",
    "GG" to "Гернси",
    "GH" to "Гана",
    "GI" to "Гибралтар",
    "GL" to "Гренландия",
    "GM" to "Гамбия",
    "GN" to "Гвинея",
    "GP" to "Гваделупа",
    "GQ" to "Экваториальлық Гвинея",
    "GR" to "Греция",
    "GS" to "Қубла Георгия ҳәм Қубла Сэндвич атаўлары",
    "GT" to "Гватемала",
    "GU" to "Гуам",
    "GW" to "Гвинея-Бисау",
    "GY" to "Гайана",
    "HK" to "Гонконг ААР",
    "HN" to "Гондурас",
    "HR" to "Хорватия",
    "HT" to "Гаити",
    "HU" to "Венгрия",
    "IC" to "Канар атаўлары",
    "ID" to "Индонезия",
    "IE" to "Ирландия",
    "IL" to "Израиль",
    "IM" to "Мэн атаўы",
    "IN" to "Ҳиндстан",
    "IO" to "Британияныӊ Ҳинд океанындағы территориясы",
    "IQ" to "Ирак",
    "IR" to "Иран",
    "IS" to "Исландия",
    "IT" to "Италия",
    "JE" to "Джерси",
    "JM" to "Ямайка",
    "JO" to "Иордания",
    "JP" to "Япония",
    "KE" to "Кения",
    "KG" to "Қырғызстан",
    "KH" to "Камбоджа",
    "KI" to "Кирибати",
    "KM" to "Комор атаўлары",
    "KN" to "Сент-Китс ҳәм Невис",
    "KP" to "Арқа Корея",
    "KR" to "Қубла Корея",
    "KW" to "Кувейт",
    "KY" to "Кайман атаўлары",
    "KZ" to "Қазақстан",
    "LA" to "Лаос",
    "LB" to "Ливан",
    "LC" to "Сент-Люсия",
    "LI" to "Лихтенштейн",
    "LK" to "Шри-Ланка",
    "LR" to "Либерия",
    "LS" to "Лесото",
    "LT" to "Литва",
    "LU" to "Люксембург",
    "LV" to "Латвия",
    "LY" to "Ливия",
    "MA" to "Марокко",
    "MC" to "Монако",
    "MD" to "Молдова",
    "ME" to "Черногория",
    "MF" to "Сен-Мартен",
    "MG" to "Мадагаскар",
    "MH" to "Маршалл атаўлары",
    "MK" to "Арқа Македония",
    "ML" to "Мали",
    "MM" to "Мьянма (Бирма)",
    "MN" to "Монголия",
    "MO" to "Макао ААР",
    "MQ" to "Мартиника",
    "MR" to "Мавритания",
    "MS" to "Монтсеррат",
    "MT" to "Мальта",
    "MU" to "Маврикий",
    "MV" to "Мальдив",
    "MW" to "Малави",
    "MX" to "Мексика",
    "MY" to "Малайзия",
    "MZ" to "Мозамбик",
    "NA" to "Намибия",
    "NC" to "Жаӊа Каледония",
    "NE" to "Нигер",
    "NG" to "Нигерия",
    "NI" to "Никарагуа",
    "NL" to "Нидерландия",
    "NO" to "Норвегия",
    "NP" to "Непал",
    "NR" to "Науру",
    "NZ" to "Жаӊа Зеландия",
    "OM" to "Оман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PG" to "Папуа — Жаӊа Гвинея",
    "PH" to "Филиппин",
    "PK" to "Пакистан",
    "PL" to "Польша",
    "PM" to "Сен-Пьер ҳәм Микелон",
    "PN" to "Питкэрн атаўлары",
    "PR" to "Пуэрто-Рико",
    "PS" to "Палестина территориялары",
    "PT" to "Португалия",
    "PW" to "Палау",
    "PY" to "Парагвай",
    "QA" to "Қатар",
    "QO" to "Сыртқы Океания",
    "RE" to "Реюньон",
    "RO" to "Румыния",
    "RS" to "Сербия",
    "RU" to "Россия",
    "RW" to "Руанда",
    "SA" to "Саудия Арабстаны",
    "SB" to "Соломон атаўлары",
    "SC" to "Сейшель атаўлары",
    "SD" to "Судан",
    "SE" to "Швеция",
    "SG" to "Сингапур",
    "SI" to "Словения",
    "SJ" to "Шпицберген ҳәм Ян-Майен",
    "SK" to "Словакия",
    "SL" to "Сьерра-Леоне",
    "SM" to "Сан-Марино",
    "SN" to "Сенегал",
    "SO" to "Сомали",
    "SR" to "Суринам",
    "SS" to "Қубла Судан",
    "ST" to "Сан-Томе ҳәм Принсипи",
    "SV" to "Сальвадор",
    "SX" to "Синт-Мартен",
    "SY" to "Сирия",
    "SZ" to "Эсватини",
    "TC" to "Тёркс ҳәм Кайкос атаўлары",
    "TD" to "Чад",
    "TF" to "Француз Қубла территориялары",
    "TG" to "Того",
    "TH" to "Таиланд",
    "TJ" to "Тәжикстан",
    "TK" to "Токелау",
    "TL" to "Шығыс Тимор",
    "TM" to "Түркменстан",
    "TN" to "Тунис",
    "TO" to "Тонга",
    "TR" to "Түркия",
    "TT" to "Тринидад ҳәм Тобаго",
    "TV" to "Тувалу",
    "TW" to "Тайвань",
    "TZ" to "Танзания",
    "UA" to "Украина",
    "UG" to "Уганда",
    "UN" to "Бирлескен Миллетлер Шөлкеми",
    "US" to "Америка Қурама Штатлары",
    "UY" to "Уругвай",
    "UZ" to "Өзбекстан",
    "VA" to "Ватикан",
    "VC" to "Сент-Винсент ҳәм Гренадин атаўлары",
    "VE" to "Венесуэла",
    "VG" to "Британия Виргин атаўлары",
    "VI" to "Америка Виргин атаўлары",
    "VN" to "Вьетнам",
    "VU" to "Вануату",
    "WS" to "Самоа",
    "XA" to "қалпеки пәт",
    "XB" to "қалпеки Bidi",
    "XK" to "Косово",
    "YE" to "Йемен",
    "YT" to "Майотта",
    "ZA" to "Қубла Африка Республикасы",
    "ZM" to "Замбия",
    "ZW" to "Зимбабве",
    "ZZ" to "белгисиз аймақ",
  ) }

  val kaa_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "дүнья",
    "002" to "Африка",
    "003" to "Арқа Америка",
    "005" to "Қубла Америка",
    "009" to "Океания",
    "011" to "Батыс Африка",
    "013" to "Орайлық Америка",
    "014" to "Шығыс Африка",
    "015" to "Арқа Африка",
    "017" to "Орайлық Африка",
    "018" to "Қубла Африка",
    "019" to "Америка",
    "021" to "Арқа Америка – AҚШ ҳәм Канада",
    "029" to "Кариб бассейни",
    "030" to "Шығыс Азия",
    "034" to "Қубла Азия",
    "035" to "Қубла-шығыс Азия",
    "039" to "Қубла Европа",
    "053" to "Австралазия",
    "054" to "Меланезия",
    "057" to "Микронезия",
    "061" to "Полинезия",
    "142" to "Азия",
    "143" to "Орайлық Азия",
    "145" to "Батыс Азия",
    "150" to "Европа",
    "151" to "Шығыс Европа",
    "154" to "Арқа Европа",
    "155" to "Батыс Европа",
    "202" to "Тропикалық Африка",
    "419" to "Латын Америкасы",
    "AD" to "Андорра",
    "AE" to "Бирлескен Араб Әмирликлери",
    "AF" to "Аўғанстан",
    "AG" to "Антигуа ҳәм Барбуда",
    "AI" to "Ангилья",
    "AL" to "Албания",
    "AM" to "Армения",
    "AO" to "Ангола",
    "AR" to "Аргентина",
    "AT" to "Австрия",
    "AU" to "Австралия",
    "AW" to "Аруба",
    "AX" to "Аланд атаўлары",
    "AZ" to "Әзербайжан",
    "BA" to "Босния ҳәм Герцеговина",
    "BB" to "Барбадос",
    "BD" to "Бангладеш",
    "BE" to "Бельгия",
    "BF" to "Буркина-Фасо",
    "BG" to "Болгария",
    "BH" to "Бахрейн",
    "BI" to "Бурунди",
    "BJ" to "Бенин",
    "BL" to "Сен-Бартелеми",
    "BM" to "Бермуд атаўлары",
    "BN" to "Бруней",
    "BO" to "Боливия",
    "BQ" to "Бонэйр, Синт-Эстатиус ҳәм Саба",
    "BR" to "Бразилия",
    "BS" to "Багама атаўлары",
    "BT" to "Бутан",
    "BV" to "Буве атаўы",
    "BW" to "Ботсвана",
    "BY" to "Беларусь",
    "BZ" to "Белиз",
    "CA" to "Канада",
    "CC" to "Кокос атаўлары",
    "CD" to "Конго - Киншаса",
    "CF" to "Орайлық Африка Республикасы",
    "CG" to "Конго - Браззавиль",
    "CH" to "Швейцария",
    "CI" to "Кот-дИвуар",
    "CK" to "Кук атаўлары",
    "CL" to "Чили",
    "CM" to "Камерун",
    "CN" to "Қытай",
    "CO" to "Колумбия",
    "CR" to "Коста-Рика",
    "CU" to "Куба",
    "CV" to "Кабо-Верде",
    "CW" to "Кюрасао",
    "CY" to "Кипр",
    "CZ" to "Чехия",
    "DE" to "Германия",
    "DJ" to "Джибути",
    "DK" to "Дания",
    "DM" to "Доминика",
    "DO" to "Доминикана Республикасы",
    "DZ" to "Алжир",
    "EA" to "Сеута ҳәм Мелилья",
    "EC" to "Эквадор",
    "EE" to "Эстония",
    "EG" to "Мысыр",
    "EH" to "Батыс Сахара",
    "ER" to "Эритрея",
    "ES" to "Испания",
    "ET" to "Эфиопия",
    "EU" to "Европа Аўқамы",
    "EZ" to "Еврозона",
    "FI" to "Финляндия",
    "FJ" to "Фиджи",
    "FK" to "Фолкленд атаўлары",
    "FM" to "Микронезия Федеративлик Штатлары",
    "FO" to "Фарер атаўлары",
    "FR" to "Франция",
    "GA" to "Габон",
    "GB" to "Уллы Британия",
    "GD" to "Гренада",
    "GE" to "Грузия",
    "GF" to "Француз Гвианасы",
    "GG" to "Гернси",
    "GH" to "Гана",
    "GI" to "Гибралтар",
    "GL" to "Гренландия",
    "GM" to "Гамбия",
    "GN" to "Гвинея",
    "GP" to "Гваделупа",
    "GQ" to "Экваториальлық Гвинея",
    "GR" to "Греция",
    "GS" to "Қубла Георгия ҳәм Қубла Сэндвич атаўлары",
    "GT" to "Гватемала",
    "GU" to "Гуам",
    "GW" to "Гвинея-Бисау",
    "GY" to "Гайана",
    "HK" to "Гонконг ААР",
    "HN" to "Гондурас",
    "HR" to "Хорватия",
    "HT" to "Гаити",
    "HU" to "Венгрия",
    "IC" to "Канар атаўлары",
    "ID" to "Индонезия",
    "IE" to "Ирландия",
    "IL" to "Израиль",
    "IM" to "Мэн атаўы",
    "IN" to "Ҳиндстан",
    "IO" to "Британияныӊ Ҳинд океанындағы территориясы",
    "IQ" to "Ирак",
    "IR" to "Иран",
    "IS" to "Исландия",
    "IT" to "Италия",
    "JE" to "Джерси",
    "JM" to "Ямайка",
    "JO" to "Иордания",
    "JP" to "Япония",
    "KE" to "Кения",
    "KG" to "Қырғызстан",
    "KH" to "Камбоджа",
    "KI" to "Кирибати",
    "KM" to "Комор атаўлары",
    "KN" to "Сент-Китс ҳәм Невис",
    "KP" to "Арқа Корея",
    "KR" to "Қубла Корея",
    "KW" to "Кувейт",
    "KY" to "Кайман атаўлары",
    "KZ" to "Қазақстан",
    "LA" to "Лаос",
    "LB" to "Ливан",
    "LC" to "Сент-Люсия",
    "LI" to "Лихтенштейн",
    "LK" to "Шри-Ланка",
    "LR" to "Либерия",
    "LS" to "Лесото",
    "LT" to "Литва",
    "LU" to "Люксембург",
    "LV" to "Латвия",
    "LY" to "Ливия",
    "MA" to "Марокко",
    "MC" to "Монако",
    "MD" to "Молдова",
    "ME" to "Черногория",
    "MF" to "Сен-Мартен",
    "MG" to "Мадагаскар",
    "MH" to "Маршалл атаўлары",
    "MK" to "Арқа Македония",
    "ML" to "Мали",
    "MM" to "Мьянма (Бирма)",
    "MN" to "Монголия",
    "MO" to "Макао ААР",
    "MQ" to "Мартиника",
    "MR" to "Мавритания",
    "MS" to "Монтсеррат",
    "MT" to "Мальта",
    "MU" to "Маврикий",
    "MV" to "Мальдив",
    "MW" to "Малави",
    "MX" to "Мексика",
    "MY" to "Малайзия",
    "MZ" to "Мозамбик",
    "NA" to "Намибия",
    "NC" to "Жаӊа Каледония",
    "NE" to "Нигер",
    "NG" to "Нигерия",
    "NI" to "Никарагуа",
    "NL" to "Нидерландия",
    "NO" to "Норвегия",
    "NP" to "Непал",
    "NR" to "Науру",
    "NZ" to "Жаӊа Зеландия",
    "OM" to "Оман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PG" to "Папуа — Жаӊа Гвинея",
    "PH" to "Филиппин",
    "PK" to "Пакистан",
    "PL" to "Польша",
    "PM" to "Сен-Пьер ҳәм Микелон",
    "PN" to "Питкэрн атаўлары",
    "PR" to "Пуэрто-Рико",
    "PS" to "Палестина территориялары",
    "PT" to "Португалия",
    "PW" to "Палау",
    "PY" to "Парагвай",
    "QA" to "Қатар",
    "QO" to "Сыртқы Океания",
    "RE" to "Реюньон",
    "RO" to "Румыния",
    "RS" to "Сербия",
    "RU" to "Россия",
    "RW" to "Руанда",
    "SA" to "Саудия Арабстаны",
    "SB" to "Соломон атаўлары",
    "SC" to "Сейшель атаўлары",
    "SD" to "Судан",
    "SE" to "Швеция",
    "SG" to "Сингапур",
    "SI" to "Словения",
    "SJ" to "Шпицберген ҳәм Ян-Майен",
    "SK" to "Словакия",
    "SL" to "Сьерра-Леоне",
    "SM" to "Сан-Марино",
    "SN" to "Сенегал",
    "SO" to "Сомали",
    "SR" to "Суринам",
    "SS" to "Қубла Судан",
    "ST" to "Сан-Томе ҳәм Принсипи",
    "SV" to "Сальвадор",
    "SX" to "Синт-Мартен",
    "SY" to "Сирия",
    "SZ" to "Эсватини",
    "TC" to "Тёркс ҳәм Кайкос атаўлары",
    "TD" to "Чад",
    "TF" to "Француз Қубла территориялары",
    "TG" to "Того",
    "TH" to "Таиланд",
    "TJ" to "Тәжикстан",
    "TK" to "Токелау",
    "TL" to "Шығыс Тимор",
    "TM" to "Түркменстан",
    "TN" to "Тунис",
    "TO" to "Тонга",
    "TR" to "Түркия",
    "TT" to "Тринидад ҳәм Тобаго",
    "TV" to "Тувалу",
    "TW" to "Тайвань",
    "TZ" to "Танзания",
    "UA" to "Украина",
    "UG" to "Уганда",
    "UN" to "Бирлескен Миллетлер Шөлкеми",
    "US" to "Америка Қурама Штатлары",
    "UY" to "Уругвай",
    "UZ" to "Өзбекстан",
    "VA" to "Ватикан",
    "VC" to "Сент-Винсент ҳәм Гренадин атаўлары",
    "VE" to "Венесуэла",
    "VG" to "Британия Виргин атаўлары",
    "VI" to "Америка Виргин атаўлары",
    "VN" to "Вьетнам",
    "VU" to "Вануату",
    "WS" to "Самоа",
    "XA" to "қалпеки пәт",
    "XB" to "қалпеки Bidi",
    "XK" to "Косово",
    "YE" to "Йемен",
    "YT" to "Майотта",
    "ZA" to "Қубла Африка Республикасы",
    "ZM" to "Замбия",
    "ZW" to "Зимбабве",
    "ZZ" to "белгисиз аймақ",
  ) }

  val kab: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Undura",
    "AE" to "Tigeldunin Yedduklen Taɛrabin",
    "AF" to "Afɣanistan",
    "AG" to "Untiga d Barbuda",
    "AI" to "Ungiya",
    "AL" to "Lalbani",
    "AM" to "Arminya",
    "AO" to "Ungula",
    "AR" to "Arjuntin",
    "AS" to "Samwa Tamarikanit",
    "AT" to "Ustriya",
    "AU" to "Ustrali",
    "AW" to "Aruba",
    "AZ" to "Azrabijan",
    "BA" to "Busna d Hersek",
    "BB" to "Barbadus",
    "BD" to "Bangladac",
    "BE" to "Belǧik",
    "BF" to "Burkina Fasu",
    "BG" to "Bulgari",
    "BH" to "Baḥrin",
    "BI" to "Burandi",
    "BJ" to "Binin",
    "BM" to "Bermuda",
    "BN" to "Bruney",
    "BO" to "Bulivi",
    "BR" to "Brizil",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BW" to "Bustwana",
    "BY" to "Bilarus",
    "BZ" to "Biliz",
    "CA" to "Kanada",
    "CD" to "Tigduda Tagdudant n Kungu",
    "CF" to "Tigduda n Tefriqt Talemmast",
    "CG" to "Kungu",
    "CH" to "Swis",
    "CI" to "Kuṭ Divwar",
    "CK" to "Tigzirin n Kuk",
    "CL" to "Cili",
    "CM" to "Kamirun",
    "CN" to "Lacin",
    "CO" to "Kulumbi",
    "CR" to "Kusta Rika",
    "CU" to "Kuba",
    "CV" to "Tigzirin n yixef azegzaw",
    "CY" to "Cipr",
    "CZ" to "Čček",
    "DE" to "Lalman",
    "DJ" to "Ǧibuti",
    "DK" to "Denmark",
    "DM" to "Duminik",
    "DO" to "Tigduda Taduminikit",
    "DZ" to "Lezzayer",
    "EC" to "Ikwaṭur",
    "EE" to "Istunya",
    "EG" to "Maṣr",
    "ER" to "Iritiria",
    "ES" to "Spanya",
    "ET" to "Utyupi",
    "FI" to "Finlund",
    "FJ" to "Fiji",
    "FK" to "Tigzirin n Falkland",
    "FM" to "Mikrunizya",
    "FR" to "Fransa",
    "GA" to "Gabun",
    "GB" to "Tagelda Yedduklen",
    "GD" to "Grunad",
    "GE" to "Jiyurji",
    "GF" to "Ɣana tafransist",
    "GH" to "Ɣana",
    "GI" to "Jibraltar",
    "GL" to "Grunland",
    "GM" to "Gambya",
    "GN" to "Ɣinya",
    "GP" to "Gwadalupi",
    "GQ" to "Ɣinya Tasebgast",
    "GR" to "Lagris",
    "GT" to "Gwatimala",
    "GU" to "Gwam",
    "GW" to "Ɣinya-Bisaw",
    "GY" to "Guwana",
    "HN" to "Hunduras",
    "HR" to "Kerwasya",
    "HT" to "Hayti",
    "HU" to "Hungri",
    "ID" to "Indunizi",
    "IE" to "Lirlund",
    "IL" to "Izrayil",
    "IN" to "Lhend",
    "IQ" to "Lɛiraq",
    "IR" to "Iran",
    "IS" to "Island",
    "IT" to "Ṭelyan",
    "JM" to "Jamyika",
    "JO" to "Lajurdani",
    "JP" to "Jappu",
    "KE" to "Kinya",
    "KG" to "Kirigistan",
    "KH" to "Cambudya",
    "KI" to "Kiribati",
    "KM" to "Kumur",
    "KN" to "San Kits d Nivis",
    "KP" to "Kurya, Ufella",
    "KR" to "Kurya, Wadda",
    "KW" to "Kuwayt",
    "KY" to "Tigzirin n Kamyan",
    "KZ" to "Kazaxistan",
    "LA" to "Laws",
    "LB" to "Lubnan",
    "LC" to "San Lučya",
    "LI" to "Layctenstan",
    "LK" to "Sri Lanka",
    "LR" to "Libirya",
    "LS" to "Lizuṭu",
    "LT" to "Liṭwanya",
    "LU" to "Luksamburg",
    "LV" to "Latvia",
    "LY" to "Libya",
    "MA" to "Lmerruk",
    "MC" to "Munaku",
    "MD" to "Muldabi",
    "MG" to "Madaɣecqer",
    "MH" to "Tigzirin n Marcal",
    "ML" to "Mali",
    "MM" to "Myanmar",
    "MN" to "Mungulya",
    "MP" to "Tigzirin n Maryan Ufella",
    "MQ" to "Martinik",
    "MR" to "Muriṭanya",
    "MS" to "Munsirat",
    "MT" to "Malṭ",
    "MU" to "Muris",
    "MV" to "Maldib",
    "MW" to "Malawi",
    "MX" to "Meksik",
    "MY" to "Malizya",
    "MZ" to "Muzembiq",
    "NA" to "Namibya",
    "NC" to "Kalidunya Tamaynut",
    "NE" to "Nijer",
    "NF" to "Tigzirin Tinawfukin",
    "NG" to "Nijirya",
    "NI" to "Nikaragwa",
    "NL" to "Timura-Yessakesren",
    "NO" to "Nurvij",
    "NP" to "Nipal",
    "NR" to "Nuru",
    "NU" to "Niwi",
    "NZ" to "Ziland Tamaynut",
    "OM" to "Ɛuman",
    "PA" to "Panam",
    "PE" to "Piru",
    "PF" to "Pulunizi tafransist",
    "PG" to "Ɣinya Tamaynut Tapaput",
    "PH" to "Filipin",
    "PK" to "Pakistan",
    "PL" to "Pulund",
    "PM" to "San Pyar d Miklun",
    "PN" to "Pitkarin",
    "PR" to "Purtu Riku",
    "PS" to "Falisṭin d Ɣezza",
    "PT" to "Purtugal",
    "PW" to "Palu",
    "PY" to "Paragway",
    "QA" to "Qaṭar",
    "RE" to "Timlilit",
    "RO" to "Rumani",
    "RU" to "Rrus",
    "RW" to "Ruwanda",
    "SA" to "Suɛudiya Taɛrabt",
    "SB" to "Tigzirin n Sulumun",
    "SC" to "Seycel",
    "SD" to "Sudan",
    "SE" to "Swid",
    "SG" to "Singafur",
    "SH" to "Sant Ilina",
    "SI" to "Sluvinya",
    "SK" to "Sluvakya",
    "SL" to "Sira Lyun",
    "SM" to "San Marinu",
    "SN" to "Sinigal",
    "SO" to "Ṣumal",
    "SR" to "Surinam",
    "ST" to "Saw Tumi d Pransip",
    "SV" to "Salvadur",
    "SY" to "Surya",
    "SZ" to "Swazilund",
    "TC" to "Ṭurk d Tegzirin n Kaykus",
    "TD" to "Čad",
    "TG" to "Ṭugu",
    "TH" to "Ṭayland",
    "TJ" to "Tajikistan",
    "TK" to "Ṭuklu",
    "TL" to "Tumur Asamar",
    "TM" to "Ṭurkmanistan",
    "TN" to "Tunes",
    "TO" to "Ṭunga",
    "TR" to "Ṭurk",
    "TT" to "Ṭrindad d Ṭubagu",
    "TV" to "Ṭuvalu",
    "TW" to "Ṭaywan",
    "TZ" to "Ṭanzanya",
    "UA" to "Ukran",
    "UG" to "Uɣanda",
    "US" to "WDM",
    "UY" to "Urugway",
    "UZ" to "Uzbaxistan",
    "VA" to "Awanek n Vatikan",
    "VC" to "San Vansu d Grunadin",
    "VE" to "Venzwila",
    "VG" to "Tigzirin Tiverjiniyin Tigliziyin",
    "VI" to "W.D. Tigzirin n Virginya",
    "VN" to "Vyeṭnam",
    "VU" to "Vanwatu",
    "WF" to "Wallis d Futuna",
    "WS" to "Samwa",
    "YE" to "Lyamen",
    "YT" to "Mayuṭ",
    "ZA" to "Tafriqt Wadda",
    "ZM" to "Zambya",
    "ZW" to "Zimbabwi",
  ) }

  val kam: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Falme za Kiarabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AR" to "Ajentina",
    "AS" to "Samoa ya Marekani",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AZ" to "Azabajani",
    "BA" to "Bosnia na Hezegovina",
    "BB" to "Babadosi",
    "BD" to "Bangladeshi",
    "BE" to "Ubelgiji",
    "BF" to "Bukinafaso",
    "BG" to "Bulgaria",
    "BH" to "Bahareni",
    "BI" to "Mbulundi",
    "BJ" to "Benini",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BR" to "Brazili",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botswana",
    "BY" to "Belarusi",
    "BZ" to "Belize",
    "CA" to "Kananda",
    "CD" to "Jamhuri ya Kidemokrasia ya Kongo",
    "CF" to "Jamhuri ya Afrika ya Kati",
    "CG" to "Kongo",
    "CH" to "Uswisi",
    "CI" to "Kodivaa",
    "CK" to "Isiwa sya Cook",
    "CL" to "Chile",
    "CM" to "Kameluni",
    "CN" to "Kyaina",
    "CO" to "Kolombia",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Kepuvede",
    "CY" to "Kuprosi",
    "CZ" to "Jamhuri ya Cheki",
    "DE" to "Ujerumani",
    "DJ" to "Jibuti",
    "DK" to "Denmaki",
    "DM" to "Dominika",
    "DO" to "Jamhuri ya Dominika",
    "DZ" to "Aljeria",
    "EC" to "Ekwado",
    "EE" to "Estonia",
    "EG" to "Misili",
    "ER" to "Eritrea",
    "ES" to "Hispania",
    "ET" to "Uhabeshi",
    "FI" to "Ufini",
    "FJ" to "Fiji",
    "FK" to "Visiwa vya Falkland",
    "FM" to "Mikronesia",
    "FR" to "Uvalanza",
    "GA" to "Gaboni",
    "GB" to "Uingereza",
    "GD" to "Grenada",
    "GE" to "Jojia",
    "GF" to "Gwiyana ya Ufaransa",
    "GH" to "Ghana",
    "GI" to "Jibralta",
    "GL" to "Grinlandi",
    "GM" to "Gambia",
    "GN" to "Gine",
    "GP" to "Gwadelupe",
    "GQ" to "Ginekweta",
    "GR" to "Ugiriki",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Hondurasi",
    "HR" to "Korasia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "ID" to "Indonesia",
    "IE" to "Ayalandi",
    "IL" to "Israeli",
    "IN" to "India",
    "IQ" to "Iraki",
    "IR" to "Uajemi",
    "IS" to "Aislandi",
    "IT" to "Italia",
    "JM" to "Jamaika",
    "JO" to "Yordani",
    "JP" to "Japani",
    "KE" to "Kenya",
    "KG" to "Kirigizistani",
    "KH" to "Kambodia",
    "KI" to "Kiribati",
    "KM" to "Komoro",
    "KN" to "Santakitzi na Nevis",
    "KP" to "Korea Kaskazini",
    "KR" to "Korea Kusini",
    "KW" to "Kuwaiti",
    "KY" to "Isiwa sya Kayman",
    "KZ" to "Kazakistani",
    "LA" to "Laosi",
    "LB" to "Lebanoni",
    "LC" to "Santalusia",
    "LI" to "Lishenteni",
    "LK" to "Sirilanka",
    "LR" to "Liberia",
    "LS" to "Lesoto",
    "LT" to "Litwania",
    "LU" to "Lasembagi",
    "LV" to "Lativia",
    "LY" to "Libya",
    "MA" to "Moroko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "MG" to "Bukini",
    "MH" to "Visiwa vya Marshal",
    "ML" to "Mali",
    "MM" to "Myama",
    "MN" to "Mongolia",
    "MP" to "Visiwa vya Mariana vya Kaskazini",
    "MQ" to "Martiniki",
    "MR" to "Moritania",
    "MS" to "Montserrati",
    "MT" to "Malta",
    "MU" to "Morisi",
    "MV" to "Modivu",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malesia",
    "MZ" to "Msumbiji",
    "NA" to "Namibia",
    "NC" to "Nyukaledonia",
    "NE" to "Nijeri",
    "NF" to "Kisiwa cha Norfok",
    "NG" to "Nijeria",
    "NI" to "Nikaragwa",
    "NL" to "Uholanzi",
    "NO" to "Norwe",
    "NP" to "Nepali",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nyuzilandi",
    "OM" to "Omani",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia ya Ufaransa",
    "PG" to "Papua",
    "PH" to "Filipino",
    "PK" to "Pakistani",
    "PL" to "Polandi",
    "PM" to "Santapieri na Mikeloni",
    "PN" to "Pitkairni",
    "PR" to "Pwetoriko",
    "PS" to "Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina",
    "PT" to "Ureno",
    "PW" to "Palau",
    "PY" to "Paragwai",
    "QA" to "Katari",
    "RE" to "Riyunioni",
    "RO" to "Romania",
    "RU" to "Urusi",
    "RW" to "Lwanda",
    "SA" to "Saudi",
    "SB" to "Isiwa sya Solomon",
    "SC" to "Shelisheli",
    "SD" to "Sudani",
    "SE" to "Uswidi",
    "SG" to "Singapoo",
    "SH" to "Santahelena",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SL" to "Siera Leoni",
    "SM" to "Samarino",
    "SN" to "Senegali",
    "SO" to "Somalia",
    "SR" to "Surinamu",
    "ST" to "Sao Tome na Principe",
    "SV" to "Elsavado",
    "SY" to "Siria",
    "SZ" to "Uswazi",
    "TC" to "Visiwa vya Turki na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tailandi",
    "TJ" to "Tajikistani",
    "TK" to "Tokelau",
    "TL" to "Timori ya Mashariki",
    "TM" to "Turukimenistani",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Uturuki",
    "TT" to "Trinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tanzania",
    "UA" to "Ukraini",
    "UG" to "Ukanda",
    "US" to "Marekani",
    "UY" to "Urugwai",
    "UZ" to "Uzibekistani",
    "VA" to "Vatikani",
    "VC" to "Santavisenti na Grenadini",
    "VE" to "Venezuela",
    "VG" to "Visiwa vya Virgin vya Uingereza",
    "VI" to "Visiwa vya Virgin vya Marekani",
    "VN" to "Vietinamu",
    "VU" to "Vanuatu",
    "WF" to "Walis na Futuna",
    "WS" to "Samoa",
    "YE" to "Yemeni",
    "YT" to "Mayotte",
    "ZA" to "Afrika Kusini",
    "ZM" to "Nzambia",
    "ZW" to "Nzimbambwe",
  ) }

  val kde: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andola",
    "AE" to "Dimiliki dya Vakulungwa va Chalabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Balbuda",
    "AI" to "Angwila",
    "AL" to "Albania",
    "AM" to "Almenia",
    "AO" to "Angola",
    "AR" to "Adyentina",
    "AS" to "Samoa ya Malekani",
    "AT" to "Austlia",
    "AU" to "Austlalia",
    "AW" to "Aluba",
    "AZ" to "Azabadyani",
    "BA" to "Bosnia na Hezegovina",
    "BB" to "Babadosi",
    "BD" to "Bangladeshi",
    "BE" to "Ubelgidi",
    "BF" to "Buchinafaso",
    "BG" to "Bulgalia",
    "BH" to "Bahaleni",
    "BI" to "Bulundi",
    "BJ" to "Benini",
    "BM" to "Belmuda",
    "BN" to "Blunei",
    "BO" to "Bolivia",
    "BR" to "Blazili",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botswana",
    "BY" to "Belalusi",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CD" to "Jamuhuli ya Chidemoklasia ya kuKongo",
    "CF" to "Jamuhuli ya Afilika ya Paching’ati",
    "CG" to "Kongo",
    "CH" to "Uswisi",
    "CI" to "Kodivaa",
    "CK" to "Chisiwa cha Cook",
    "CL" to "Chile",
    "CM" to "Kameluni",
    "CN" to "China",
    "CO" to "Kolombia",
    "CR" to "Kostalika",
    "CU" to "Kuba",
    "CV" to "Kepuvede",
    "CY" to "Kuplosi",
    "CZ" to "Jamuhuli ya Chechi",
    "DE" to "Udyerumani",
    "DJ" to "Dyibuti",
    "DK" to "Denmaki",
    "DM" to "Dominika",
    "DO" to "Jamuhuli ya Dominika",
    "DZ" to "Aljelia",
    "EC" to "Ekwado",
    "EE" to "Estonia",
    "EG" to "Misli",
    "ER" to "Elitilea",
    "ES" to "Hispania",
    "ET" to "Uhabeshi",
    "FI" to "Ufini",
    "FJ" to "Fiji",
    "FK" to "Chisiwa cha Falkland",
    "FM" to "Mikilonesia",
    "FR" to "Ufalansa",
    "GA" to "Gaboni",
    "GB" to "Nngalesa",
    "GD" to "Glenada",
    "GE" to "Dyodya",
    "GF" to "Gwiyana ya Ufalansa",
    "GH" to "Ghana",
    "GI" to "Diblalta",
    "GL" to "Glinlandi",
    "GM" to "Gambia",
    "GN" to "Gine",
    "GP" to "Gwadelupe",
    "GQ" to "Ginekweta",
    "GR" to "Ugilichi",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Hondulasi",
    "HR" to "Kolasia",
    "HT" to "Haiti",
    "HU" to "Hungalia",
    "ID" to "Indonesia",
    "IE" to "Ayalandi",
    "IL" to "Islaeli",
    "IN" to "India",
    "IQ" to "Ilaki",
    "IR" to "Uadyemi",
    "IS" to "Aislandi",
    "IT" to "Italia",
    "JM" to "Dyamaika",
    "JO" to "Yordani",
    "JP" to "Dyapani",
    "KE" to "Kenya",
    "KG" to "Kiligizistani",
    "KH" to "Kambodia",
    "KI" to "Kilibati",
    "KM" to "Komolo",
    "KN" to "Santakitzi na Nevis",
    "KP" to "Kolea Kasikazini",
    "KR" to "Kolea Kusini",
    "KW" to "Kuwaiti",
    "KY" to "Chisiwa cha Kemen",
    "KZ" to "Kazachistani",
    "LA" to "Laosi",
    "LB" to "Lebanoni",
    "LC" to "Santalusia",
    "LI" to "Lishenteni",
    "LK" to "Sililanka",
    "LR" to "Libelia",
    "LS" to "Lesoto",
    "LT" to "Litwania",
    "LU" to "Lasembagi",
    "LV" to "Lativia",
    "LY" to "Libya",
    "MA" to "Moloko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "MG" to "Bukini",
    "MH" to "Chisiwa cha Malushal",
    "ML" to "Mali",
    "MM" to "Myama",
    "MN" to "Mongolia",
    "MP" to "Chisiwa cha Marian cha Kasikazini",
    "MQ" to "Malitiniki",
    "MR" to "Molitania",
    "MS" to "Monselati",
    "MT" to "Malta",
    "MU" to "Molisi",
    "MV" to "Modivu",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malesia",
    "MZ" to "Msumbiji",
    "NA" to "Namibia",
    "NC" to "Nyukaledonia",
    "NE" to "Nidyeli",
    "NF" to "Chisiwa cha Nolufok",
    "NG" to "Nidyelia",
    "NI" to "Nikalagwa",
    "NL" to "Uholanzi",
    "NO" to "Norwe",
    "NP" to "Nepali",
    "NR" to "Naulu",
    "NU" to "Niue",
    "NZ" to "Nyuzilandi",
    "OM" to "Omani",
    "PA" to "Panama",
    "PE" to "Pelu",
    "PF" to "Polinesia ya Ufalansa",
    "PG" to "Papua",
    "PH" to "Filipino",
    "PK" to "Pakistani",
    "PL" to "Polandi",
    "PM" to "Santapieli na Mikeloni",
    "PN" to "Pitikeluni",
    "PR" to "Pwetoliko",
    "PS" to "Nchingu wa Magalibi wa Mpanda wa kuGaza wa kuPales",
    "PT" to "Uleno",
    "PW" to "Palau",
    "PY" to "Palagwai",
    "QA" to "Katali",
    "RE" to "Liyunioni",
    "RO" to "Lomania",
    "RU" to "Ulusi",
    "RW" to "Lwanda",
    "SA" to "Saudia",
    "SB" to "Chisiwa cha Solomon",
    "SC" to "Shelisheli",
    "SD" to "Sudani",
    "SE" to "Uswidi",
    "SG" to "Singapoo",
    "SH" to "Santahelena",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SL" to "Siela Leoni",
    "SM" to "Samalino",
    "SN" to "Senegali",
    "SO" to "Somalia",
    "SR" to "Sulinamu",
    "ST" to "Saotome na Prinsipe",
    "SV" to "Elsavado",
    "SY" to "Silia",
    "SZ" to "Uswazi",
    "TC" to "Chisiwa cha Tuluchi na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tailandi",
    "TJ" to "Tadikistani",
    "TK" to "Tokelau",
    "TL" to "Timoli ya Mashaliki",
    "TM" to "Tuluchimenistani",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Utuluchi",
    "TT" to "Tilinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tanzania",
    "UA" to "Uklaini",
    "UG" to "Uganda",
    "US" to "Malekani",
    "UY" to "Ulugwai",
    "UZ" to "Uzibechistani",
    "VA" to "Vatikani",
    "VC" to "Santavisenti na Glenadini",
    "VE" to "Venezuela",
    "VG" to "Chisiwa Chivihi cha Wingalesa",
    "VI" to "Chisiwa Chivihi cha Malekani",
    "VN" to "Vietinamu",
    "VU" to "Vanuatu",
    "WF" to "Walis na Futuna",
    "WS" to "Samoa",
    "YE" to "Yemeni",
    "YT" to "Maole",
    "ZA" to "Afilika Kusini",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
  ) }

  val kea: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Mundu",
    "002" to "Áfrika",
    "003" to "Merka di Norti",
    "005" to "Merka di Sul",
    "009" to "Oseania",
    "011" to "Áfrika Osidental",
    "013" to "Merka Sentral",
    "014" to "Áfrika Oriental",
    "015" to "Norti di Áfrika",
    "017" to "Áfrika Sentral",
    "018" to "Sul di Áfrika",
    "019" to "Merkas",
    "021" to "Norti di Merka",
    "029" to "Karaibas",
    "030" to "Ázia Oriental",
    "034" to "Sul di Ázia",
    "035" to "Sudesti Aziátiku",
    "039" to "Europa di Sul",
    "053" to "Australázia",
    "054" to "Melanézia",
    "057" to "Rejion di Mikronézia",
    "061" to "Polinézia",
    "142" to "Ázia",
    "143" to "Ázia Sentral",
    "145" to "Ázia Osidental",
    "150" to "Europa",
    "151" to "Europa Oriental",
    "154" to "Europa di Norti",
    "155" to "Europa Osidental",
    "202" to "Áfrika Subisariana",
    "419" to "Merka Latinu",
    "AC" to "Ilha di Asenson",
    "AD" to "Andora",
    "AE" to "Emiradus Árabi Unidu",
    "AF" to "Afeganistãu",
    "AG" to "Antigua i Barbuda",
    "AI" to "Angila",
    "AL" to "Albánia",
    "AM" to "Arménia",
    "AO" to "Angola",
    "AQ" to "Antártika",
    "AR" to "Arjentina",
    "AS" to "Samoa Merkanu",
    "AT" to "Áustria",
    "AU" to "Austrália",
    "AW" to "Aruba",
    "AX" to "Ilhas Åland",
    "AZ" to "Azerbaidjan",
    "BA" to "Bósnia i Erzegovina",
    "BB" to "Barbadus",
    "BD" to "Bangladexi",
    "BE" to "Béljika",
    "BF" to "Burkina Fasu",
    "BG" to "Bulgária",
    "BH" to "Barain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "San Bartolomeu",
    "BM" to "Bermudas",
    "BN" to "Brunei",
    "BO" to "Bolívia",
    "BQ" to "Karaibas Olandezas",
    "BR" to "Brazil",
    "BS" to "Baamas",
    "BT" to "Butan",
    "BV" to "Ilha Buvê",
    "BW" to "Botsuana",
    "BY" to "Belarus",
    "BZ" to "Belizi",
    "CA" to "Kanadá",
    "CC" to "Ilhas Kokus (Keeling)",
    "CD" to "Kongu - Kinxasa",
    "CF" to "Republika Sentru-Afrikanu",
    "CG" to "Kongu - Brazavili",
    "CH" to "Suisa",
    "CI" to "Kosta di Marfin",
    "CK" to "Ilhas Kuk",
    "CL" to "Xili",
    "CM" to "Kamarons",
    "CN" to "Xina",
    "CO" to "Kolómbia",
    "CP" to "Ilha Kliperton",
    "CR" to "Kosta Rika",
    "CU" to "Kuba",
    "CV" to "Kabu Verdi",
    "CW" to "Kurasau",
    "CX" to "Ilha di Natal",
    "CY" to "Xipri",
    "CZ" to "Txékia",
    "DE" to "Alimanha",
    "DG" to "Diegu Garsia",
    "DJ" to "Djibuti",
    "DK" to "Dinamarka",
    "DM" to "Dominika",
    "DO" to "Repúblika Dominikana",
    "DZ" to "Arjélia",
    "EA" to "Seuta i Melilha",
    "EC" to "Ekuador",
    "EE" to "Stónia",
    "EG" to "Ejitu",
    "EH" to "Sara Osidental",
    "ER" to "Iritreia",
    "ES" to "Spanha",
    "ET" to "Etiópia",
    "EU" to "Union Europeia",
    "EZ" to "Eurozona",
    "FI" to "Finlándia",
    "FJ" to "Fidji",
    "FK" to "Ilhas Malvinas",
    "FM" to "Mikronézia",
    "FO" to "Ilhas Faroe",
    "FR" to "Fransa",
    "GA" to "Gabon",
    "GB" to "Reinu Unidu",
    "GD" to "Granada",
    "GE" to "Jiórjia",
    "GF" to "Giana Franseza",
    "GG" to "Gernzi",
    "GH" to "Gana",
    "GI" to "Jibraltar",
    "GL" to "Gronelándia",
    "GM" to "Gámbia",
    "GN" to "Gine",
    "GP" to "Guadalupi",
    "GQ" to "Gine Ekuatorial",
    "GR" to "Grésia",
    "GS" to "Ilhas Jeórjia di Sul i Sanduixi di Sul",
    "GT" to "Guatimala",
    "GU" to "Guam",
    "GW" to "Gine-Bisau",
    "GY" to "Giana",
    "HK" to "Hong Kong, Rejion Administrativu Spesial di Xina",
    "HM" to "Ilhas Heard i McDonald",
    "HN" to "Onduras",
    "HR" to "Kroásia",
    "HT" to "Aití",
    "HU" to "Ungria",
    "IC" to "Kanárias",
    "ID" to "Indonézia",
    "IE" to "Irlanda",
    "IL" to "Israel",
    "IM" to "Ilha di Man",
    "IN" to "Índia",
    "IQ" to "Iraki",
    "IR" to "Irãu",
    "IS" to "Islándia",
    "IT" to "Itália",
    "JE" to "Jersi",
    "JM" to "Jamaika",
    "JO" to "Jordánia",
    "JP" to "Japon",
    "KE" to "Kénia",
    "KG" to "Kirgistan",
    "KH" to "Kambodja",
    "KI" to "Kiribati",
    "KM" to "Kamoris",
    "KN" to "San Kristovan i Nevis",
    "KP" to "Koreia di Norti",
    "KR" to "Koreia di Sul",
    "KW" to "Kueiti",
    "KY" to "Ilhas Kaimon",
    "KZ" to "Kazakistan",
    "LA" to "Laus",
    "LB" to "Líbanu",
    "LC" to "Santa Lúsia",
    "LI" to "Lixenstain",
    "LK" to "Sri Lanka",
    "LR" to "Libéria",
    "LS" to "Lezotu",
    "LT" to "Lituánia",
    "LU" to "Luxemburgu",
    "LV" to "Letónia",
    "LY" to "Líbia",
    "MA" to "Marokus",
    "MC" to "Mónaku",
    "MD" to "Moldávia",
    "ME" to "Montenegru",
    "MF" to "San Martinhu (Fransa)",
    "MG" to "Madagaskar",
    "MH" to "Ilhas Marxal",
    "MK" to "Masidónia di Norti",
    "ML" to "Mali",
    "MM" to "Mianmar (Birmánia)",
    "MN" to "Mongólia",
    "MO" to "Makau, Rejion Administrativu Spesial di Xina",
    "MP" to "Ilhas Marianas di Norti",
    "MQ" to "Martinika",
    "MR" to "Mauritánia",
    "MS" to "Monserat",
    "MT" to "Malta",
    "MU" to "Maurísia",
    "MV" to "Maldivas",
    "MW" to "Malaui",
    "MX" to "Méxiku",
    "MY" to "Malázia",
    "MZ" to "Musambiki",
    "NA" to "Namíbia",
    "NC" to "Nova Kalidónia",
    "NE" to "Nijer",
    "NF" to "Ilhas Norfolk",
    "NG" to "Nijéria",
    "NI" to "Nikarágua",
    "NL" to "Olanda",
    "NO" to "Noruega",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nova Zilándia",
    "OM" to "Oman",
    "PA" to "Panamá",
    "PE" to "Peru",
    "PF" to "Polinézia Franseza",
    "PG" to "Papua-Nova Gine",
    "PH" to "Filipinas",
    "PK" to "Pakistan",
    "PL" to "Pulónia",
    "PM" to "San Piere i Mikelon",
    "PN" to "Ilhas Pitkairn",
    "PR" to "Portu Riku",
    "PS" to "Tiritóriu palistinianu",
    "PT" to "Purtugal",
    "PW" to "Palau",
    "PY" to "Paraguai",
    "QA" to "Katar",
    "QO" to "Ilhas di Oseania",
    "RE" to "Runion",
    "RO" to "Ruménia",
    "RS" to "Sérvia",
    "RU" to "Rúsia",
    "RW" to "Ruanda",
    "SA" to "Arábia Saudita",
    "SB" to "Ilhas Salumãu",
    "SC" to "Seixelis",
    "SD" to "Sudon",
    "SE" to "Suésia",
    "SG" to "Singapura",
    "SH" to "Santa Ilena",
    "SI" to "Slovénia",
    "SJ" to "Svalbard i Jan Maien",
    "SK" to "Slovákia",
    "SL" to "Sera Lioa",
    "SM" to "San Marinu",
    "SN" to "Senegal",
    "SO" to "Sumália",
    "SR" to "Surinami",
    "SS" to "Sudon di Sul",
    "ST" to "San Tume i Prínsipi",
    "SV" to "El Salvador",
    "SX" to "San Martinhu (Olanda)",
    "SY" to "Síria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Kunha",
    "TC" to "Ilhas Turkas i Kaikus",
    "TD" to "Txadi",
    "TF" to "Terras Franses di Sul",
    "TG" to "Togu",
    "TH" to "Tailándia",
    "TJ" to "Tadjikistan",
    "TK" to "Tokelau",
    "TL" to "Timor Lesti",
    "TM" to "Turkumenistan",
    "TN" to "Tunízia",
    "TO" to "Tonga",
    "TR" to "Turkia",
    "TT" to "Trinidad i Tobagu",
    "TV" to "Tuvalu",
    "TW" to "Taiuan",
    "TZ" to "Tanzánia",
    "UA" to "Ukránia",
    "UG" to "Uganda",
    "UM" to "Ilhas Minoris Distantis de Stadus Unidus",
    "UN" to "Nasons Unidas",
    "US" to "Stadus Unidos di Merka",
    "UY" to "Uruguai",
    "UZ" to "Uzbekistan",
    "VA" to "Vatikanu",
    "VC" to "San Bisenti i Granadinas",
    "VE" to "Vinizuela",
    "VG" to "Ilhas Virjens Británikas",
    "VI" to "Ilhas Virjens Merkanas",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Ualis i Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo-sotakis",
    "XB" to "Pseudo-bidiresional",
    "XK" to "Kozovu",
    "YE" to "Iémen",
    "YT" to "Maiote",
    "ZA" to "Áfrika di Sul",
    "ZM" to "Zámbia",
    "ZW" to "Zimbábui",
    "ZZ" to "Rejion Diskonxedu",
  ) }

  val kgp: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Tã mĩ ke kar",
    "002" to "Afrika",
    "003" to "Nãrti-Amẽrika",
    "005" to "Sur-Amẽrika",
    "009" to "Oseanĩja",
    "011" to "Afrika Rãpur",
    "013" to "Amẽrika-Kuju",
    "014" to "Afrika Rãjur",
    "015" to "Nãrti-Afrika",
    "017" to "Afrika-Kuju",
    "018" to "Afrika Mẽrinhonỹr",
    "019" to "Amẽrika ag",
    "021" to "Amẽrika Setẽntrionỹr",
    "029" to "Karime",
    "030" to "Ajia Rãjur",
    "034" to "Ajia Mẽrinhonỹr",
    "035" to "Ajia Sur-Rãjur",
    "039" to "Orópa Mẽrinhonỹr",
    "053" to "Ausitrarajia",
    "054" to "Mẽranẽjia",
    "057" to "Mĩkronẽjia Pénĩn",
    "061" to "Porinẽjia",
    "142" to "Ajia",
    "143" to "Ajia-Kuju",
    "145" to "Ajia-Rãpur",
    "150" to "Orópa",
    "151" to "Orópa-Rãjur",
    "154" to "Orópa Setẽntrionỹr",
    "155" to "Orópa Rãpur",
    "202" to "Afrika Sahara-Jẽgu",
    "419" to "Amẽrika Ratinỹ",
    "AC" to "Asẽnsỹv Goj-vẽso",
    "AD" to "Ỹnora",
    "AE" to "Emĩrano Arame Unĩno",
    "AF" to "Afeganĩtã",
    "AG" to "Ỹntiguva kar Marmuna",
    "AI" to "Ỹngira",
    "AL" to "Armánĩja",
    "AM" to "Armẽnĩja",
    "AO" to "Ỹgóra",
    "AQ" to "Ỹntartina",
    "AR" to "Arjẽtinỹ",
    "AS" to "Samãva Amẽrikynỹ",
    "AT" to "Agtirija",
    "AU" to "Avotyraria",
    "AW" to "Aruma",
    "AX" to "Gojga Goj-vẽso",
    "AZ" to "Ajermajjáv",
    "BA" to "Mósinĩja",
    "BB" to "Juvã-mág",
    "BD" to "Mágranési",
    "BE" to "Mérjika",
    "BF" to "Murkinỹ Faso",
    "BG" to "Murgarjia",
    "BH" to "Marẽj",
    "BI" to "Murũni",
    "BJ" to "Menĩnh",
    "BL" to "Sỹ Martoromeu",
    "BM" to "Mermũna",
    "BN" to "Mrunẽj",
    "BO" to "Morivija",
    "BQ" to "Pajisi Rur Karimejã",
    "BR" to "Mrasir",
    "BS" to "Mahámỹ",
    "BT" to "Mutỹv",
    "BV" to "Muve Goj-vẽso",
    "BW" to "Monsuvỹnỹ",
    "BY" to "Miero-Husija",
    "BZ" to "Merije",
    "CA" to "Kanỹna",
    "CC" to "Kokonh Goj-vẽso (Killing)",
    "CD" to "Kãgo - Kĩsaja",
    "CF" to "Afrikanỹ-kuju Repumrika",
    "CG" to "Kãgo Repumrika",
    "CH" to "Suvisa",
    "CI" to "Jãn-mág-kupri Fyr",
    "CK" to "Kuki Goj-vẽso",
    "CL" to "Sire",
    "CM" to "Kamỹrãj",
    "CN" to "Sĩnỹ",
    "CO" to "Korãmija",
    "CP" to "Kripertãn Goj-vẽso",
    "CR" to "Konhta Rika",
    "CU" to "Kuma",
    "CV" to "Pu Tánh",
    "CW" to "Kurasavo",
    "CX" to "Krĩtimỹnh Goj-vẽso",
    "CY" to "Sipre",
    "CZ" to "Sékija",
    "DE" to "Aremỹija",
    "DG" to "Niego Garsija",
    "DJ" to "Nhimuti",
    "DK" to "Ninỹmỹrka",
    "DM" to "Nomĩnĩka",
    "DO" to "Repumrika Nomĩnĩkỹnỹ",
    "DZ" to "Arjérija",
    "EA" to "Sevuta kar Mẽrira",
    "EC" to "Ekuvanor",
    "EE" to "Enhtonĩja",
    "EG" to "Ejito",
    "EH" to "Sahara Rãpur",
    "ER" to "Erytiréja",
    "ES" to "Enhpỹnija",
    "ET" to "Etiópija",
    "EU" to "Unĩjáv Oropéja",
    "EZ" to "Evoro Ga",
    "FI" to "Fĩrỹnija",
    "FJ" to "Fiji",
    "FK" to "Mỹrvĩnỹ Goj-vẽso",
    "FM" to "Goj-vẽso-sĩ Kẽsir",
    "FO" to "Faróve Goj-vẽso",
    "FR" to "Frỹsa",
    "GA" to "Gabã",
    "GB" to "Rejnũ Unĩnu",
    "GD" to "Granỹna",
    "GE" to "Jiórja",
    "GF" to "Frỹsa Gijanỹ",
    "GG" to "Gérnesej",
    "GH" to "Ganỹ",
    "GI" to "Gimrar-tar",
    "GL" to "Groẽrỹnija",
    "GM" to "Gỹmija",
    "GN" to "Ginẽ",
    "GP" to "Guvanarupe",
    "GQ" to "Ginẽ Ekuvatoriar",
    "GR" to "Grésa",
    "GS" to "Jiórja-Sur kar Sỹnvisi-Sur Goj-vẽso Ag",
    "GT" to "Guvatimỹra",
    "GU" to "Guvỹm",
    "GW" to "Ginẽ-Misav",
    "GY" to "Gijỹnỹ",
    "HK" to "Hãg Kãg, Sinỹ ERA",
    "HM" to "Hárni kar Magtonarni Goj-vẽso Ag",
    "HN" to "Hãnura",
    "HR" to "Kroasa",
    "HT" to "Ajti",
    "HU" to "Ũgrija",
    "IC" to "Kanỹrija Goj-vẽso",
    "ID" to "Ĩnonẽja",
    "IE" to "Irỹna",
    "IL" to "Isihaé",
    "IM" to "Mỹn Goj-vẽso",
    "IN" to "Ĩnija",
    "IQ" to "Iraki",
    "IR" to "Irỹ",
    "IS" to "Inhrỹnija",
    "IT" to "Itarija",
    "JE" to "Jérsej",
    "JM" to "Jamỹjka",
    "JO" to "Jornánĩja",
    "JP" to "Japã",
    "KE" to "Kenĩja",
    "KG" to "Kirginhtỹv",
    "KH" to "Kỹmója",
    "KI" to "Kirimati",
    "KM" to "Komãre",
    "KN" to "Sỹ Krinhtóvỹv kar Nẽvinh",
    "KP" to "Nãrti-Koréja",
    "KR" to "Sur-Koréja",
    "KW" to "Kuvajti",
    "KY" to "Kajmỹm Goj-vẽso",
    "KZ" to "Kajakinhtỹv",
    "LA" to "Raosi",
    "LB" to "Rimanã",
    "LC" to "Sỹta Rusija",
    "LI" to "Rinhsiténh-tajin",
    "LK" to "Siri Rỹnka",
    "LR" to "Rimérija",
    "LS" to "Resotu",
    "LT" to "Rituỹnĩja",
    "LU" to "Rusẽmurgu",
    "LV" to "Retãnĩja",
    "LY" to "Rimija",
    "MA" to "Mỹhókonh",
    "MC" to "Mãnỹko",
    "MD" to "Mãrnova",
    "ME" to "Krĩsá",
    "MF" to "Sỹ Mỹrtĩjũ",
    "MG" to "Mỹnaganhtar",
    "MH" to "MỹrSar Goj-vẽso",
    "MK" to "Nãrti-Mỹsenonĩja",
    "ML" to "Mỹri",
    "MM" to "Mĩjỹmỹr",
    "MN" to "Mãngórija",
    "MO" to "Mỹkav, Sĩnỹ ERA",
    "MP" to "Nãrti-Mỹrijỹnỹ Goj-vẽso",
    "MQ" to "Mỹrtinĩka",
    "MR" to "Mãritỹnĩja",
    "MS" to "Mãtisehati",
    "MT" to "Mỹrta",
    "MU" to "Mãriso",
    "MV" to "Mỹrniva",
    "MW" to "Mỹravi",
    "MX" to "Mẽsiku",
    "MY" to "Mỹraja",
    "MZ" to "Mãsỹmiki",
    "NA" to "Nỹmĩmija",
    "NC" to "Karenonĩja Tãg",
    "NE" to "Nĩjer",
    "NF" to "Nãrforki Goj-vẽso",
    "NG" to "Nĩjérija",
    "NI" to "Nĩkaragva",
    "NL" to "Pajisi Rur",
    "NO" to "Nãrovéga",
    "NP" to "Nẽpar",
    "NR" to "Nỹuru",
    "NU" to "Nĩvue",
    "NZ" to "Jerỹnija Tãg",
    "OM" to "Omỹ",
    "PA" to "Panỹmỹ",
    "PE" to "Piru",
    "PF" to "Frỹsa Porinẽja",
    "PG" to "Papuva-Ginẽ Tãg",
    "PH" to "Firipinỹ",
    "PK" to "Pakinhtỹv",
    "PL" to "Porãnija",
    "PM" to "Sỹ Penru kar Mĩkerỹv",
    "PN" to "Pinkajir Goj-vẽso",
    "PR" to "Portu Hiku",
    "PS" to "Tehitórijo Parenhtinũ",
    "PT" to "Portugar",
    "PW" to "Paravu",
    "PY" to "Paraguvaj",
    "QA" to "Katar",
    "QO" to "Osiỹnĩja Kuvar-gy",
    "RE" to "Hujáv",
    "RO" to "Homẽnĩja",
    "RS" to "Sérvija",
    "RU" to "Husija",
    "RW" to "Huỹna",
    "SA" to "Aramija Savnita",
    "SB" to "Saromỹv Goj-vẽso",
    "SC" to "Sejserenh",
    "SD" to "Suná",
    "SE" to "Suésa",
    "SG" to "Sĩgapura",
    "SH" to "Sỹnta Erenỹ",
    "SI" to "Enhrovenĩja",
    "SJ" to "Inhvarmarni kar Jan Mỹjẽn",
    "SK" to "Enhrovakija",
    "SL" to "Krĩ Mĩgkusũg-fi",
    "SM" to "Sỹ Mỹrĩnũ",
    "SN" to "Senẽgar",
    "SO" to "Somỹrija",
    "SR" to "Surinỹmĩ",
    "SS" to "Sur-Sunáv",
    "ST" to "Sỹ Tomẽ kar Prĩsipi",
    "SV" to "Er Sarvanor",
    "SX" to "Sĩti Mỹ’artẽn",
    "SY" to "Sirija",
    "SZ" to "Esuatinĩ",
    "TA" to "Trinhtỹv Nakũja",
    "TC" to "Turka kar Kajko Goj-vẽso Ag",
    "TD" to "Sane",
    "TF" to "Sur Frỹsa Tehitórijo",
    "TG" to "Togo",
    "TH" to "Taj-Ga",
    "TJ" to "Tanijikinhtỹv",
    "TK" to "Tokeravu",
    "TL" to "Timãr-Rãjur",
    "TM" to "Turkomẽnĩnhtỹv",
    "TN" to "Tunĩja",
    "TO" to "Tãga",
    "TR" to "Turkija",
    "TT" to "Trĩnane kar Tomagu",
    "TV" to "Tuvaru",
    "TW" to "Tajuvỹ",
    "TZ" to "Tỹnjỹnĩja",
    "UA" to "Ukrỹnĩja",
    "UG" to "Ugỹna",
    "UM" to "EUA Goj-vẽso Kãsir",
    "UN" to "Nỹsãn Unĩna",
    "US" to "Enhtano Unĩno",
    "UY" to "Urugvaj",
    "UZ" to "Unhmekinhtỹv",
    "VA" to "Vatikỹnũ Emã-mág",
    "VC" to "Sỹ Visenti kar Granỹninỹ",
    "VE" to "Venẽjuvéra",
    "VG" to "Mritỹnĩja Goj-vẽso",
    "VI" to "Virjĩg Goj-vẽso tỹ Amẽrikỹnỹ",
    "VN" to "Vijétinỹ",
    "VU" to "Vanũvatu",
    "WF" to "Varinh kar Futunỹ",
    "WS" to "Samãva",
    "XA" to "Ón vĩ ag",
    "XB" to "Ón régre mĩ.",
    "XK" to "Kosovo",
    "YE" to "Jemẽn",
    "YT" to "Mỹjóte",
    "ZA" to "Sur-Afrika",
    "ZM" to "Jỹmija",
    "ZW" to "Jĩmamuje",
    "ZZ" to "Reji’ỹv Veja tũ",
  ) }

  val khq: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andoora",
    "AE" to "Laaraw Imaarawey Margantey",
    "AF" to "Afgaanistan",
    "AG" to "Antigua nda Barbuuda",
    "AI" to "Angiiya",
    "AL" to "Albaani",
    "AM" to "Armeeni",
    "AO" to "Angoola",
    "AR" to "Argentine",
    "AS" to "Ameriki Samoa",
    "AT" to "Otriši",
    "AU" to "Ostraali",
    "AW" to "Aruuba",
    "AZ" to "Azerbaayijaŋ",
    "BA" to "Bosni nda Herzegovine",
    "BB" to "Barbaados",
    "BD" to "Bangladeši",
    "BE" to "Belgiiki",
    "BF" to "Burkina faso",
    "BG" to "Bulgaari",
    "BH" to "Bahareen",
    "BI" to "Burundi",
    "BJ" to "Beniŋ",
    "BM" to "Bermuda",
    "BN" to "Bruunee",
    "BO" to "Boolivi",
    "BR" to "Breezil",
    "BS" to "Bahamas",
    "BT" to "Buutaŋ",
    "BW" to "Botswaana",
    "BY" to "Biloriši",
    "BZ" to "Beliizi",
    "CA" to "Kanaada",
    "CD" to "Kongoo demookaratiki laboo",
    "CF" to "Centraafriki koyra",
    "CG" to "Kongoo",
    "CH" to "Swisu",
    "CI" to "Kudwar",
    "CK" to "Kuuk gungey",
    "CL" to "Šiili",
    "CM" to "Kameruun",
    "CN" to "Šiin",
    "CO" to "Kolombi",
    "CR" to "Kosta rika",
    "CU" to "Kuuba",
    "CV" to "Kapuver gungey",
    "CY" to "Šiipur",
    "CZ" to "Cek labo",
    "DE" to "Almaaɲe",
    "DJ" to "Jibuuti",
    "DK" to "Danemark",
    "DM" to "Doominiki",
    "DO" to "Doominiki laboo",
    "DZ" to "Alžeeri",
    "EC" to "Ekwateer",
    "EE" to "Estooni",
    "EG" to "Misra",
    "ER" to "Eritree",
    "ES" to "Espaaɲe",
    "ET" to "Ecioopi",
    "FI" to "Finlandu",
    "FJ" to "Fiji",
    "FK" to "Kalkan gungey",
    "FM" to "Mikronezi",
    "FR" to "Faransi",
    "GA" to "Gaabon",
    "GB" to "Albaasalaama Marganta",
    "GD" to "Grenaada",
    "GE" to "Gorgi",
    "GF" to "Faransi Guyaan",
    "GH" to "Gaana",
    "GI" to "Gibraltar",
    "GL" to "Grinland",
    "GM" to "Gambi",
    "GN" to "Gine",
    "GP" to "Gwadeluup",
    "GQ" to "Ginee Ekwatorial",
    "GR" to "Greece",
    "GT" to "Gwatemaala",
    "GU" to "Guam",
    "GW" to "Gine-Bisso",
    "GY" to "Guyaane",
    "HN" to "Honduras",
    "HR" to "Krwaasi",
    "HT" to "Haiti",
    "HU" to "Hungaari",
    "ID" to "Indoneezi",
    "IE" to "Irlandu",
    "IL" to "Israyel",
    "IN" to "Indu laboo",
    "IQ" to "Iraak",
    "IR" to "Iraan",
    "IS" to "Ayceland",
    "IT" to "Itaali",
    "JM" to "Jamaayik",
    "JO" to "Urdun",
    "JP" to "Jaapoŋ",
    "KE" to "Keeniya",
    "KG" to "Kyrgyzstan",
    "KH" to "Kamboogi",
    "KI" to "Kiribaati",
    "KM" to "Komoor",
    "KN" to "Seŋ Kitts nda Nevis",
    "KP" to "Kooree, Gurma",
    "KR" to "Kooree, Hawsa",
    "KW" to "Kuweet",
    "KY" to "Kayman gungey",
    "KZ" to "Kaazakstan",
    "LA" to "Laawos",
    "LB" to "Lubnaan",
    "LC" to "Seŋ Lussia",
    "LI" to "Liechtenstein",
    "LK" to "Srilanka",
    "LR" to "Liberia",
    "LS" to "Leesoto",
    "LT" to "Lituaani",
    "LU" to "Luxembourg",
    "LV" to "Letooni",
    "LY" to "Liibi",
    "MA" to "Maarok",
    "MC" to "Monako",
    "MD" to "Moldovi",
    "MG" to "Madagascar",
    "MH" to "Maršal gungey",
    "ML" to "Maali",
    "MM" to "Maynamar",
    "MN" to "Mongooli",
    "MP" to "Mariana Gurma Gungey",
    "MQ" to "Martiniiki",
    "MR" to "Mooritaani",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mooris gungey",
    "MV" to "Maldiivu",
    "MW" to "Malaawi",
    "MX" to "Mexiki",
    "MY" to "Maleezi",
    "MZ" to "Mozambik",
    "NA" to "Naamibi",
    "NC" to "Kaaledooni Taagaa",
    "NE" to "Nižer",
    "NF" to "Norfolk Gungoo",
    "NG" to "Naajiriia",
    "NI" to "Nikaragwa",
    "NL" to "Hollandu",
    "NO" to "Norveej",
    "NP" to "Neepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Zeelandu Taaga",
    "OM" to "Omaan",
    "PA" to "Panama",
    "PE" to "Peeru",
    "PF" to "Faransi Polineezi",
    "PG" to "Papua Ginee Taaga",
    "PH" to "Filipine",
    "PK" to "Paakistan",
    "PL" to "Poloɲe",
    "PM" to "Seŋ Piyer nda Mikelon",
    "PN" to "Pitikarin",
    "PR" to "Porto Riko",
    "PS" to "Palestine Dangay nda Gaaza",
    "PT" to "Portugaal",
    "PW" to "Palu",
    "PY" to "Paraguwey",
    "QA" to "Kataar",
    "RE" to "Reenioŋ",
    "RO" to "Rumaani",
    "RU" to "Iriši laboo",
    "RW" to "Rwanda",
    "SA" to "Saudiya",
    "SB" to "Solomon Gungey",
    "SC" to "Seešel",
    "SD" to "Suudaŋ",
    "SE" to "Sweede",
    "SG" to "Singapur",
    "SH" to "Seŋ Helena",
    "SI" to "Sloveeni",
    "SK" to "Slovaaki",
    "SL" to "Seera Leon",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somaali",
    "SR" to "Surinaam",
    "ST" to "Sao Tome nda Prinsipe",
    "SV" to "Salvador laboo",
    "SY" to "Suuria",
    "SZ" to "Swaziland",
    "TC" to "Turk nda Kayikos Gungey",
    "TD" to "Caadu",
    "TG" to "Togo",
    "TH" to "Taayiland",
    "TJ" to "Taažikistan",
    "TK" to "Tokelau",
    "TL" to "Timoor hawsa",
    "TM" to "Turkmenistaŋ",
    "TN" to "Tunizi",
    "TO" to "Tonga",
    "TR" to "Turki",
    "TT" to "Trinidad nda Tobaago",
    "TV" to "Tuvalu",
    "TW" to "Taayiwan",
    "TZ" to "Tanzaani",
    "UA" to "Ukreen",
    "UG" to "Uganda",
    "US" to "Ameriki Laabu Margantey",
    "UY" to "Uruguwey",
    "UZ" to "Uzbeekistan",
    "VA" to "Vaatikan Laama",
    "VC" to "Seŋvinsaŋ nda Grenadine",
    "VE" to "Veneezuyeela",
    "VG" to "Britiši Virgin gungey",
    "VI" to "Ameerik Virgin Gungey",
    "VN" to "Vietnaam",
    "VU" to "Vanautu",
    "WF" to "Wallis nda Futuna",
    "WS" to "Samoa",
    "YE" to "Yaman",
    "YT" to "Mayooti",
    "ZA" to "Hawsa Afriki Laboo",
    "ZM" to "Zambi",
    "ZW" to "Zimbabwe",
  ) }

  val ki: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Falme za Kiarabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AR" to "Ajentina",
    "AS" to "Samoa ya Marekani",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AZ" to "Azabajani",
    "BA" to "Bosnia na Hezegovina",
    "BB" to "Babadosi",
    "BD" to "Bangladeshi",
    "BE" to "Ubelgiji",
    "BF" to "Bukinafaso",
    "BG" to "Bulgaria",
    "BH" to "Bahareni",
    "BI" to "Mburundi",
    "BJ" to "Benini",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BR" to "Brazili",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botswana",
    "BY" to "Belarusi",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CD" to "Jamhuri ya Kidemokrasia ya Kongo",
    "CF" to "Jamhuri ya Afrika ya Kati",
    "CG" to "Kongo",
    "CH" to "Uswisi",
    "CI" to "Kodivaa",
    "CK" to "Visiwa vya Cook",
    "CL" to "Chile",
    "CM" to "Kameruni",
    "CN" to "Caina",
    "CO" to "Kolombia",
    "CR" to "Kostarika",
    "CU" to "Kiumba",
    "CV" to "Kepuvede",
    "CY" to "Kuprosi",
    "CZ" to "Jamhuri ya Cheki",
    "DE" to "Njeremani",
    "DJ" to "Jibuti",
    "DK" to "Denmaki",
    "DM" to "Dominika",
    "DO" to "Jamhuri ya Dominika",
    "DZ" to "Aljeria",
    "EC" to "Ekwado",
    "EE" to "Estonia",
    "EG" to "Misri",
    "ER" to "Eritrea",
    "ES" to "Hispania",
    "ET" to "Uhabeshi",
    "FI" to "Ufini",
    "FJ" to "Fiji",
    "FK" to "Visiwa vya Falkland",
    "FM" to "Mikronesia",
    "FR" to "Ubaranja",
    "GA" to "Gaboni",
    "GB" to "Ngeretha",
    "GD" to "Grenada",
    "GE" to "Jojia",
    "GF" to "Gwiyana ya Ufaransa",
    "GH" to "Ngana",
    "GI" to "Jibralta",
    "GL" to "Grinlandi",
    "GM" to "Gambia",
    "GN" to "Gine",
    "GP" to "Gwadelupe",
    "GQ" to "Ginekweta",
    "GR" to "Ugiriki",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Hondurasi",
    "HR" to "Korasia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "ID" to "Indonesia",
    "IE" to "Ayalandi",
    "IL" to "Israeli",
    "IN" to "India",
    "IQ" to "Iraki",
    "IR" to "Uajemi",
    "IS" to "Aislandi",
    "IT" to "Italia",
    "JM" to "Jamaika",
    "JO" to "Njorondani",
    "JP" to "Njabani",
    "KE" to "Kenya",
    "KG" to "Kirigizistani",
    "KH" to "Kambodia",
    "KI" to "Kiribati",
    "KM" to "Komoro",
    "KN" to "Santakitzi na Nevis",
    "KP" to "Korea Kaskazini",
    "KR" to "Korea Kusini",
    "KW" to "Kuwaiti",
    "KY" to "Visiwa vya Kayman",
    "KZ" to "Kazakistani",
    "LA" to "Laosi",
    "LB" to "Lebanoni",
    "LC" to "Santalusia",
    "LI" to "Lishenteni",
    "LK" to "Sirilanka",
    "LR" to "Liberia",
    "LS" to "Lesoto",
    "LT" to "Litwania",
    "LU" to "Lasembagi",
    "LV" to "Lativia",
    "LY" to "Libya",
    "MA" to "Moroko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "MG" to "Bukini",
    "MH" to "Visiwa vya Marshal",
    "ML" to "Mali",
    "MM" to "Myama",
    "MN" to "Mongolia",
    "MP" to "Visiwa vya Mariana vya Kaskazini",
    "MQ" to "Martiniki",
    "MR" to "Moritania",
    "MS" to "Montserrati",
    "MT" to "Malta",
    "MU" to "Morisi",
    "MV" to "Modivu",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malesia",
    "MZ" to "Msumbiji",
    "NA" to "Namimbia",
    "NC" to "Nyukaledonia",
    "NE" to "Nijeri",
    "NF" to "Kisiwa cha Norfok",
    "NG" to "Nainjeria",
    "NI" to "Nikaragwa",
    "NL" to "Uholanzi",
    "NO" to "Norwe",
    "NP" to "Nepali",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nyuzilandi",
    "OM" to "Omani",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia ya Ufaransa",
    "PG" to "Papua",
    "PH" to "Filipino",
    "PK" to "Pakistani",
    "PL" to "Polandi",
    "PM" to "Santapieri na Mikeloni",
    "PN" to "Pitkairni",
    "PR" to "Pwetoriko",
    "PS" to "Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina",
    "PT" to "Ureno",
    "PW" to "Palau",
    "PY" to "Paragwai",
    "QA" to "Katari",
    "RE" to "Riyunioni",
    "RO" to "Romania",
    "RU" to "Urusi",
    "RW" to "Rwanda",
    "SA" to "Saudi",
    "SB" to "Visiwa vya Solomon",
    "SC" to "Shelisheli",
    "SD" to "Sudani",
    "SE" to "Uswidi",
    "SG" to "Singapoo",
    "SH" to "Santahelena",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SL" to "Siera Leoni",
    "SM" to "Samarino",
    "SN" to "Senegali",
    "SO" to "Somaria",
    "SR" to "Surinamu",
    "ST" to "Sao Tome na Principe",
    "SV" to "Elsavado",
    "SY" to "Siria",
    "SZ" to "Uswazi",
    "TC" to "Visiwa vya Turki na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tailandi",
    "TJ" to "Tajikistani",
    "TK" to "Tokelau",
    "TL" to "Timori ya Mashariki",
    "TM" to "Turukimenistani",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Uturuki",
    "TT" to "Trinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tanzania",
    "UA" to "Ukraini",
    "UG" to "Uganda",
    "US" to "Amerika",
    "UY" to "Urugwai",
    "UZ" to "Uzibekistani",
    "VA" to "Vatikani",
    "VC" to "Santavisenti na Grenadini",
    "VE" to "Venezuela",
    "VG" to "Visiwa vya Virgin vya Uingereza",
    "VI" to "Visiwa vya Virgin vya Marekani",
    "VN" to "Vietinamu",
    "VU" to "Vanuatu",
    "WF" to "Walis na Futuna",
    "WS" to "Samoa",
    "YE" to "Yemeni",
    "YT" to "Mayotte",
    "ZA" to "Afrika Kusini",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
  ) }

  val kk: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "әлем",
    "002" to "Африка",
    "003" to "Солтүстік Америка",
    "005" to "Оңтүстік Америка",
    "009" to "Океания",
    "011" to "Батыс Африка",
    "013" to "Орталық Америка",
    "014" to "Шығыс Африка",
    "015" to "Солтүстік Африка",
    "017" to "Орталық Африка",
    "018" to "Оңтүстік Африка аймағы",
    "019" to "Америка",
    "021" to "Солтүстік Америка (аймақ)",
    "029" to "Кариб",
    "030" to "Шығыс Азия",
    "034" to "Оңтүстік Азия",
    "035" to "Оңтүстік-Шығыс Азия",
    "039" to "Оңтүстік Еуропа",
    "053" to "Аустралазия",
    "054" to "Меланезия",
    "057" to "Микронезия аймағы",
    "061" to "Полинезия",
    "142" to "Азия",
    "143" to "Орталық Азия",
    "145" to "Батыс Азия",
    "150" to "Еуропа",
    "151" to "Шығыс Еуропа",
    "154" to "Солтүстік Еуропа",
    "155" to "Батыс Еуропа",
    "202" to "Субсахаралық Африка",
    "419" to "Латын Америкасы",
    "AC" to "Әскенжін аралы",
    "AD" to "Андорра",
    "AE" to "Біріккен Араб Әмірліктері",
    "AF" to "Ауғанстан",
    "AG" to "Антигуа және Барбуда",
    "AI" to "Ангилья",
    "AL" to "Албания",
    "AM" to "Армения",
    "AO" to "Ангола",
    "AQ" to "Антарктида",
    "AR" to "Аргентина",
    "AS" to "Америкалық Самоа",
    "AT" to "Аустрия",
    "AU" to "Аустралия",
    "AW" to "Аруба",
    "AX" to "Аланд аралдары",
    "AZ" to "Әзірбайжан",
    "BA" to "Босния және Герцеговина",
    "BB" to "Барбадос",
    "BD" to "Бангладеш",
    "BE" to "Бельгия",
    "BF" to "Буркина-Фасо",
    "BG" to "Болгария",
    "BH" to "Бахрейн",
    "BI" to "Бурунди",
    "BJ" to "Бенин",
    "BL" to "Сен-Бартелеми",
    "BM" to "Бермуд аралдары",
    "BN" to "Бруней",
    "BO" to "Боливия",
    "BQ" to "Бонэйр, Синт-Эстатиус және Саба",
    "BR" to "Бразилия",
    "BS" to "Багам аралдары",
    "BT" to "Бутан",
    "BV" to "Буве аралы",
    "BW" to "Ботсвана",
    "BY" to "Беларусь",
    "BZ" to "Белиз",
    "CA" to "Канада",
    "CC" to "Кокос (Килинг) аралдары",
    "CD" to "Конго",
    "CF" to "Орталық Африка Республикасы",
    "CG" to "Конго-Браззавиль Республикасы",
    "CH" to "Швейцария",
    "CI" to "Кот-д’Ивуар",
    "CK" to "Кук аралдары",
    "CL" to "Чили",
    "CM" to "Камерун",
    "CN" to "Қытай",
    "CO" to "Колумбия",
    "CP" to "Клиппертон аралы",
    "CR" to "Коста-Рика",
    "CU" to "Куба",
    "CV" to "Кабо-Верде",
    "CW" to "Кюрасао",
    "CX" to "Рождество аралы",
    "CY" to "Кипр",
    "CZ" to "Чехия",
    "DE" to "Германия",
    "DG" to "Диего-Гарсия",
    "DJ" to "Джибути",
    "DK" to "Дания",
    "DM" to "Доминика",
    "DO" to "Доминикан Республикасы",
    "DZ" to "Алжир",
    "EA" to "Сеута және Мелилья",
    "EC" to "Эквадор",
    "EE" to "Эстония",
    "EG" to "Мысыр",
    "EH" to "Батыс Сахара",
    "ER" to "Эритрея",
    "ES" to "Испания",
    "ET" to "Эфиопия",
    "EU" to "Еуропалық Одақ",
    "EZ" to "Еуроаймақ",
    "FI" to "Финляндия",
    "FJ" to "Фиджи",
    "FK" to "Фолкленд аралдары",
    "FM" to "Микронезия",
    "FO" to "Фарер аралдары",
    "FR" to "Франция",
    "GA" to "Габон",
    "GB" to "Ұлыбритания",
    "GD" to "Гренада",
    "GE" to "Грузия",
    "GF" to "Француз Гвианасы",
    "GG" to "Гернси",
    "GH" to "Гана",
    "GI" to "Гибралтар",
    "GL" to "Гренландия",
    "GM" to "Гамбия",
    "GN" to "Гвинея",
    "GP" to "Гваделупа",
    "GQ" to "Экваторлық Гвинея",
    "GR" to "Грекия",
    "GS" to "Оңтүстік Георгия және Оңтүстік Сандвич аралдары",
    "GT" to "Гватемала",
    "GU" to "Гуам",
    "GW" to "Гвинея-Бисау",
    "GY" to "Гайана",
    "HK" to "Сянган АӘА",
    "HM" to "Херд аралы және Макдональд аралдары",
    "HN" to "Гондурас",
    "HR" to "Хорватия",
    "HT" to "Гаити",
    "HU" to "Венгрия",
    "IC" to "Канар аралдары",
    "ID" to "Индонезия",
    "IE" to "Ирландия",
    "IL" to "Израиль",
    "IM" to "Мэн аралы",
    "IN" to "Үндістан",
    "IO" to "Үнді мұхитындағы Британ аймағы",
    "IQ" to "Ирак",
    "IR" to "Иран",
    "IS" to "Исландия",
    "IT" to "Италия",
    "JE" to "Джерси",
    "JM" to "Ямайка",
    "JO" to "Иордания",
    "JP" to "Жапония",
    "KE" to "Кения",
    "KG" to "Қырғызстан",
    "KH" to "Камбоджа",
    "KI" to "Кирибати",
    "KM" to "Комор аралдары",
    "KN" to "Сент-Китс және Невис",
    "KP" to "Солтүстік Корея",
    "KR" to "Оңтүстік Корея",
    "KW" to "Кувейт",
    "KY" to "Кайман аралдары",
    "KZ" to "Қазақстан",
    "LA" to "Лаос",
    "LB" to "Ливан",
    "LC" to "Сент-Люсия",
    "LI" to "Лихтенштейн",
    "LK" to "Шри-Ланка",
    "LR" to "Либерия",
    "LS" to "Лесото",
    "LT" to "Литва",
    "LU" to "Люксембург",
    "LV" to "Латвия",
    "LY" to "Ливия",
    "MA" to "Марокко",
    "MC" to "Монако",
    "MD" to "Молдова",
    "ME" to "Черногория",
    "MF" to "Сен-Мартен",
    "MG" to "Мадагаскар",
    "MH" to "Маршалл аралдары",
    "MK" to "Солтүстік Македония",
    "ML" to "Мали",
    "MM" to "Мьянма (Бирма)",
    "MN" to "Моңғолия",
    "MO" to "Макао АӘА",
    "MP" to "Солтүстік Мариана аралдары",
    "MQ" to "Мартиника",
    "MR" to "Мавритания",
    "MS" to "Монтсеррат",
    "MT" to "Мальта",
    "MU" to "Маврикий",
    "MV" to "Мальдив аралдары",
    "MW" to "Малави",
    "MX" to "Мексика",
    "MY" to "Малайзия",
    "MZ" to "Мозамбик",
    "NA" to "Намибия",
    "NC" to "Жаңа Каледония",
    "NE" to "Нигер",
    "NF" to "Норфолк аралы",
    "NG" to "Нигерия",
    "NI" to "Никарагуа",
    "NL" to "Нидерланд",
    "NO" to "Норвегия",
    "NP" to "Непал",
    "NR" to "Науру",
    "NU" to "Ниуэ",
    "NZ" to "Жаңа Зеландия",
    "OM" to "Оман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PF" to "Француз Полинезиясы",
    "PG" to "Папуа — Жаңа Гвинея",
    "PH" to "Филиппин аралдары",
    "PK" to "Пәкістан",
    "PL" to "Польша",
    "PM" to "Сен-Пьер және Микелон",
    "PN" to "Питкэрн аралдары",
    "PR" to "Пуэрто-Рико",
    "PS" to "Палестина аймақтары",
    "PT" to "Португалия",
    "PW" to "Палау",
    "PY" to "Парагвай",
    "QA" to "Катар",
    "QO" to "Сыртқы Океания",
    "RE" to "Реюньон",
    "RO" to "Румыния",
    "RS" to "Сербия",
    "RU" to "Ресей",
    "RW" to "Руанда",
    "SA" to "Сауд Арабиясы",
    "SB" to "Соломон аралдары",
    "SC" to "Сейшель аралдары",
    "SD" to "Судан",
    "SE" to "Швеция",
    "SG" to "Сингапур",
    "SH" to "Әулие Елена аралы",
    "SI" to "Словения",
    "SJ" to "Шпицберген және Ян-Майен",
    "SK" to "Словакия",
    "SL" to "Сьерра-Леоне",
    "SM" to "Сан-Марино",
    "SN" to "Сенегал",
    "SO" to "Сомали",
    "SR" to "Суринам",
    "SS" to "Оңтүстік Судан",
    "ST" to "Сан-Томе және Принсипи",
    "SV" to "Сальвадор",
    "SX" to "Синт-Мартен",
    "SY" to "Сирия",
    "SZ" to "Эсватини",
    "TA" to "Тристан-да-Кунья",
    "TC" to "Теркс және Кайкос аралдары",
    "TD" to "Чад",
    "TF" to "Францияның оңтүстік аймақтары",
    "TG" to "Того",
    "TH" to "Таиланд",
    "TJ" to "Тәжікстан",
    "TK" to "Токелау",
    "TL" to "Тимор-Лесте",
    "TM" to "Түрікменстан",
    "TN" to "Тунис",
    "TO" to "Тонга",
    "TR" to "Түркия",
    "TT" to "Тринидад және Тобаго",
    "TV" to "Тувалу",
    "TW" to "Тайвань",
    "TZ" to "Танзания",
    "UA" to "Украина",
    "UG" to "Уганда",
    "UM" to "АҚШ-тың сыртқы кіші аралдары",
    "UN" to "Біріккен Ұлттар Ұйымы",
    "US" to "Америка Құрама Штаттары",
    "UY" to "Уругвай",
    "UZ" to "Өзбекстан",
    "VA" to "Ватикан",
    "VC" to "Сент-Винсент және Гренадин аралдары",
    "VE" to "Венесуэла",
    "VG" to "Британдық Виргин аралдары",
    "VI" to "АҚШ-тың Виргин аралдары",
    "VN" to "Вьетнам",
    "VU" to "Вануату",
    "WF" to "Уоллис және Футуна",
    "WS" to "Самоа",
    "XA" to "жалған акцент",
    "XB" to "жалған Bidi",
    "XK" to "Косово",
    "YE" to "Йемен",
    "YT" to "Майотта",
    "ZA" to "Оңтүстік Африка",
    "ZM" to "Замбия",
    "ZW" to "Зимбабве",
    "ZZ" to "Белгісіз аймақ",
  ) }

  val kk_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "әлем",
    "002" to "Африка",
    "003" to "Солтүстік Америка",
    "005" to "Оңтүстік Америка",
    "009" to "Океания",
    "011" to "Батыс Африка",
    "013" to "Орталық Америка",
    "014" to "Шығыс Африка",
    "015" to "Солтүстік Африка",
    "017" to "Орталық Африка",
    "018" to "Оңтүстік Африка аймағы",
    "019" to "Америка",
    "021" to "Солтүстік Америка (аймақ)",
    "029" to "Кариб",
    "030" to "Шығыс Азия",
    "034" to "Оңтүстік Азия",
    "035" to "Оңтүстік-Шығыс Азия",
    "039" to "Оңтүстік Еуропа",
    "053" to "Аустралазия",
    "054" to "Меланезия",
    "057" to "Микронезия аймағы",
    "061" to "Полинезия",
    "142" to "Азия",
    "143" to "Орталық Азия",
    "145" to "Батыс Азия",
    "150" to "Еуропа",
    "151" to "Шығыс Еуропа",
    "154" to "Солтүстік Еуропа",
    "155" to "Батыс Еуропа",
    "202" to "Субсахаралық Африка",
    "419" to "Латын Америкасы",
    "AC" to "Әскенжін аралы",
    "AD" to "Андорра",
    "AE" to "Біріккен Араб Әмірліктері",
    "AF" to "Ауғанстан",
    "AG" to "Антигуа және Барбуда",
    "AI" to "Ангилья",
    "AL" to "Албания",
    "AM" to "Армения",
    "AO" to "Ангола",
    "AQ" to "Антарктида",
    "AR" to "Аргентина",
    "AS" to "Америкалық Самоа",
    "AT" to "Аустрия",
    "AU" to "Аустралия",
    "AW" to "Аруба",
    "AX" to "Аланд аралдары",
    "AZ" to "Әзірбайжан",
    "BA" to "Босния және Герцеговина",
    "BB" to "Барбадос",
    "BD" to "Бангладеш",
    "BE" to "Бельгия",
    "BF" to "Буркина-Фасо",
    "BG" to "Болгария",
    "BH" to "Бахрейн",
    "BI" to "Бурунди",
    "BJ" to "Бенин",
    "BL" to "Сен-Бартелеми",
    "BM" to "Бермуд аралдары",
    "BN" to "Бруней",
    "BO" to "Боливия",
    "BQ" to "Бонэйр, Синт-Эстатиус және Саба",
    "BR" to "Бразилия",
    "BS" to "Багам аралдары",
    "BT" to "Бутан",
    "BV" to "Буве аралы",
    "BW" to "Ботсвана",
    "BY" to "Беларусь",
    "BZ" to "Белиз",
    "CA" to "Канада",
    "CC" to "Кокос (Килинг) аралдары",
    "CD" to "Конго",
    "CF" to "Орталық Африка Республикасы",
    "CG" to "Конго-Браззавиль Республикасы",
    "CH" to "Швейцария",
    "CI" to "Кот-д’Ивуар",
    "CK" to "Кук аралдары",
    "CL" to "Чили",
    "CM" to "Камерун",
    "CN" to "Қытай",
    "CO" to "Колумбия",
    "CP" to "Клиппертон аралы",
    "CR" to "Коста-Рика",
    "CU" to "Куба",
    "CV" to "Кабо-Верде",
    "CW" to "Кюрасао",
    "CX" to "Рождество аралы",
    "CY" to "Кипр",
    "CZ" to "Чехия",
    "DE" to "Германия",
    "DG" to "Диего-Гарсия",
    "DJ" to "Джибути",
    "DK" to "Дания",
    "DM" to "Доминика",
    "DO" to "Доминикан Республикасы",
    "DZ" to "Алжир",
    "EA" to "Сеута және Мелилья",
    "EC" to "Эквадор",
    "EE" to "Эстония",
    "EG" to "Мысыр",
    "EH" to "Батыс Сахара",
    "ER" to "Эритрея",
    "ES" to "Испания",
    "ET" to "Эфиопия",
    "EU" to "Еуропалық Одақ",
    "EZ" to "Еуроаймақ",
    "FI" to "Финляндия",
    "FJ" to "Фиджи",
    "FK" to "Фолкленд аралдары",
    "FM" to "Микронезия",
    "FO" to "Фарер аралдары",
    "FR" to "Франция",
    "GA" to "Габон",
    "GB" to "Ұлыбритания",
    "GD" to "Гренада",
    "GE" to "Грузия",
    "GF" to "Француз Гвианасы",
    "GG" to "Гернси",
    "GH" to "Гана",
    "GI" to "Гибралтар",
    "GL" to "Гренландия",
    "GM" to "Гамбия",
    "GN" to "Гвинея",
    "GP" to "Гваделупа",
    "GQ" to "Экваторлық Гвинея",
    "GR" to "Грекия",
    "GS" to "Оңтүстік Георгия және Оңтүстік Сандвич аралдары",
    "GT" to "Гватемала",
    "GU" to "Гуам",
    "GW" to "Гвинея-Бисау",
    "GY" to "Гайана",
    "HK" to "Сянган АӘА",
    "HM" to "Херд аралы және Макдональд аралдары",
    "HN" to "Гондурас",
    "HR" to "Хорватия",
    "HT" to "Гаити",
    "HU" to "Венгрия",
    "IC" to "Канар аралдары",
    "ID" to "Индонезия",
    "IE" to "Ирландия",
    "IL" to "Израиль",
    "IM" to "Мэн аралы",
    "IN" to "Үндістан",
    "IO" to "Үнді мұхитындағы Британ аймағы",
    "IQ" to "Ирак",
    "IR" to "Иран",
    "IS" to "Исландия",
    "IT" to "Италия",
    "JE" to "Джерси",
    "JM" to "Ямайка",
    "JO" to "Иордания",
    "JP" to "Жапония",
    "KE" to "Кения",
    "KG" to "Қырғызстан",
    "KH" to "Камбоджа",
    "KI" to "Кирибати",
    "KM" to "Комор аралдары",
    "KN" to "Сент-Китс және Невис",
    "KP" to "Солтүстік Корея",
    "KR" to "Оңтүстік Корея",
    "KW" to "Кувейт",
    "KY" to "Кайман аралдары",
    "KZ" to "Қазақстан",
    "LA" to "Лаос",
    "LB" to "Ливан",
    "LC" to "Сент-Люсия",
    "LI" to "Лихтенштейн",
    "LK" to "Шри-Ланка",
    "LR" to "Либерия",
    "LS" to "Лесото",
    "LT" to "Литва",
    "LU" to "Люксембург",
    "LV" to "Латвия",
    "LY" to "Ливия",
    "MA" to "Марокко",
    "MC" to "Монако",
    "MD" to "Молдова",
    "ME" to "Черногория",
    "MF" to "Сен-Мартен",
    "MG" to "Мадагаскар",
    "MH" to "Маршалл аралдары",
    "MK" to "Солтүстік Македония",
    "ML" to "Мали",
    "MM" to "Мьянма (Бирма)",
    "MN" to "Моңғолия",
    "MO" to "Макао АӘА",
    "MP" to "Солтүстік Мариана аралдары",
    "MQ" to "Мартиника",
    "MR" to "Мавритания",
    "MS" to "Монтсеррат",
    "MT" to "Мальта",
    "MU" to "Маврикий",
    "MV" to "Мальдив аралдары",
    "MW" to "Малави",
    "MX" to "Мексика",
    "MY" to "Малайзия",
    "MZ" to "Мозамбик",
    "NA" to "Намибия",
    "NC" to "Жаңа Каледония",
    "NE" to "Нигер",
    "NF" to "Норфолк аралы",
    "NG" to "Нигерия",
    "NI" to "Никарагуа",
    "NL" to "Нидерланд",
    "NO" to "Норвегия",
    "NP" to "Непал",
    "NR" to "Науру",
    "NU" to "Ниуэ",
    "NZ" to "Жаңа Зеландия",
    "OM" to "Оман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PF" to "Француз Полинезиясы",
    "PG" to "Папуа — Жаңа Гвинея",
    "PH" to "Филиппин аралдары",
    "PK" to "Пәкістан",
    "PL" to "Польша",
    "PM" to "Сен-Пьер және Микелон",
    "PN" to "Питкэрн аралдары",
    "PR" to "Пуэрто-Рико",
    "PS" to "Палестина аймақтары",
    "PT" to "Португалия",
    "PW" to "Палау",
    "PY" to "Парагвай",
    "QA" to "Катар",
    "QO" to "Сыртқы Океания",
    "RE" to "Реюньон",
    "RO" to "Румыния",
    "RS" to "Сербия",
    "RU" to "Ресей",
    "RW" to "Руанда",
    "SA" to "Сауд Арабиясы",
    "SB" to "Соломон аралдары",
    "SC" to "Сейшель аралдары",
    "SD" to "Судан",
    "SE" to "Швеция",
    "SG" to "Сингапур",
    "SH" to "Әулие Елена аралы",
    "SI" to "Словения",
    "SJ" to "Шпицберген және Ян-Майен",
    "SK" to "Словакия",
    "SL" to "Сьерра-Леоне",
    "SM" to "Сан-Марино",
    "SN" to "Сенегал",
    "SO" to "Сомали",
    "SR" to "Суринам",
    "SS" to "Оңтүстік Судан",
    "ST" to "Сан-Томе және Принсипи",
    "SV" to "Сальвадор",
    "SX" to "Синт-Мартен",
    "SY" to "Сирия",
    "SZ" to "Эсватини",
    "TA" to "Тристан-да-Кунья",
    "TC" to "Теркс және Кайкос аралдары",
    "TD" to "Чад",
    "TF" to "Францияның оңтүстік аймақтары",
    "TG" to "Того",
    "TH" to "Таиланд",
    "TJ" to "Тәжікстан",
    "TK" to "Токелау",
    "TL" to "Тимор-Лесте",
    "TM" to "Түрікменстан",
    "TN" to "Тунис",
    "TO" to "Тонга",
    "TR" to "Түркия",
    "TT" to "Тринидад және Тобаго",
    "TV" to "Тувалу",
    "TW" to "Тайвань",
    "TZ" to "Танзания",
    "UA" to "Украина",
    "UG" to "Уганда",
    "UM" to "АҚШ-тың сыртқы кіші аралдары",
    "UN" to "Біріккен Ұлттар Ұйымы",
    "US" to "Америка Құрама Штаттары",
    "UY" to "Уругвай",
    "UZ" to "Өзбекстан",
    "VA" to "Ватикан",
    "VC" to "Сент-Винсент және Гренадин аралдары",
    "VE" to "Венесуэла",
    "VG" to "Британдық Виргин аралдары",
    "VI" to "АҚШ-тың Виргин аралдары",
    "VN" to "Вьетнам",
    "VU" to "Вануату",
    "WF" to "Уоллис және Футуна",
    "WS" to "Самоа",
    "XA" to "жалған акцент",
    "XB" to "жалған Bidi",
    "XK" to "Косово",
    "YE" to "Йемен",
    "YT" to "Майотта",
    "ZA" to "Оңтүстік Африка",
    "ZM" to "Замбия",
    "ZW" to "Зимбабве",
    "ZZ" to "Белгісіз аймақ",
  ) }

  val kk_KZ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kkj: ImmutableMap<String, String> by lazy { immutableMapOf(
    "CM" to "Kamɛrun",
  ) }

  val kl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "GL" to "Kalaallit Nunaat",
  ) }

  val kln: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Emetab Andorra",
    "AE" to "Emetab kibagenge nebo arabuk",
    "AF" to "Emetab Afghanistan",
    "AG" to "Emetab Antigua ak Barbuda",
    "AI" to "Emetab Anguilla",
    "AL" to "Emetab Albania",
    "AM" to "Emetab Armenia",
    "AO" to "Emetab Angola",
    "AR" to "Emetab Argentina",
    "AS" to "Emetab American Samoa",
    "AT" to "Emetab Austria",
    "AU" to "Emetab Australia",
    "AW" to "Emetab Aruba",
    "AZ" to "Emetab Azerbaijan",
    "BA" to "Emetab Bosnia ak Herzegovina",
    "BB" to "Emetab Barbados",
    "BD" to "Emetab Bangladesh",
    "BE" to "Emetab Belgium",
    "BF" to "Emetab Burkina Faso",
    "BG" to "Emetab Bulgaria",
    "BH" to "Emetab Bahrain",
    "BI" to "Emetab Burundi",
    "BJ" to "Emetab Benin",
    "BM" to "Emetab Bermuda",
    "BN" to "Emetab Brunei",
    "BO" to "Emetab Bolivia",
    "BR" to "Emetab Brazil",
    "BS" to "Emetab Bahamas",
    "BT" to "Emetab Bhutan",
    "BW" to "Emetab Botswana",
    "BY" to "Emetab Belarus",
    "BZ" to "Emetab Belize",
    "CA" to "Emetab Canada",
    "CD" to "Emetab Congo - Kinshasa",
    "CF" to "Emetab Afrika nebo Kwen",
    "CG" to "Emetab Congo - Brazzaville",
    "CH" to "Emetab Switzerland",
    "CI" to "Emetab Côte d’Ivoire",
    "CK" to "Ikwembeyotab Cook",
    "CL" to "Emetab Chile",
    "CM" to "Emetab Cameroon",
    "CN" to "Emetab China",
    "CO" to "Emetab Colombia",
    "CR" to "Emetab Costa Rica",
    "CU" to "Emetab Cuba",
    "CV" to "Ikwembeyotab Cape Verde",
    "CY" to "Emetab Cyprus",
    "CZ" to "Emetab Czech Republic",
    "DE" to "Emetab Geruman",
    "DJ" to "Emetab Djibouti",
    "DK" to "Emetab Denmark",
    "DM" to "Emetab Dominica",
    "DO" to "Emetab Dominican Republic",
    "DZ" to "Emetab Algeria",
    "EC" to "Emetab Ecuador",
    "EE" to "Emetab Estonia",
    "EG" to "Emetab Misiri",
    "ER" to "Emetab Eritrea",
    "ES" to "Emetab Spain",
    "ET" to "Emetab Ethiopia",
    "FI" to "Emetab Finland",
    "FJ" to "Emetab Fiji",
    "FK" to "Ikwembeyotab Falkland",
    "FM" to "Emetab Micronesia",
    "FR" to "Emetab France",
    "GA" to "Emetab Gabon",
    "GB" to "Emetab Kibagenge nebo Uingereza",
    "GD" to "Emetab Grenada",
    "GE" to "Emetab Georgia",
    "GF" to "Emetab Guiana nebo Ufaransa",
    "GH" to "Emetab Ghana",
    "GI" to "Emetab Gibraltar",
    "GL" to "Emetab Greenland",
    "GM" to "Emetab Gambia",
    "GN" to "Emetab Guinea",
    "GP" to "Emetab Guadeloupe",
    "GQ" to "Emetab Equatorial Guinea",
    "GR" to "Emetab Greece",
    "GT" to "Emetab Guatemala",
    "GU" to "Emetab Guam",
    "GW" to "Emetab Guinea-Bissau",
    "GY" to "Emetab Guyana",
    "HN" to "Emetab Honduras",
    "HR" to "Emetab Croatia",
    "HT" to "Emetab Haiti",
    "HU" to "Emetab Hungary",
    "ID" to "Emetab Indonesia",
    "IE" to "Emetab Ireland",
    "IL" to "Emetab Israel",
    "IN" to "Emetab India",
    "IQ" to "Emetab Iraq",
    "IR" to "Emetab Iran",
    "IS" to "Emetab Iceland",
    "IT" to "Emetab Italy",
    "JM" to "Emetab Jamaica",
    "JO" to "Emetab Jordan",
    "JP" to "Emetab Japan",
    "KE" to "Emetab Kenya",
    "KG" to "Emetab Kyrgyzstan",
    "KH" to "Emetab Cambodia",
    "KI" to "Emetab Kiribati",
    "KM" to "Emetab Comoros",
    "KN" to "Emetab Saint Kitts ak Nevis",
    "KP" to "Emetab Korea nebo murot katam",
    "KR" to "Emetab korea nebo murot tai",
    "KW" to "Emetab Kuwait",
    "KY" to "Ikwembeyotab Cayman",
    "KZ" to "Emetab Kazakhstan",
    "LA" to "Emetab Laos",
    "LB" to "Emetab Lebanon",
    "LC" to "Emetab Lucia Ne",
    "LI" to "Emetab Liechtenstein",
    "LK" to "Emetab Sri Lanka",
    "LR" to "Emetab Liberia",
    "LS" to "Emetab Lesotho",
    "LT" to "Emetab Lithuania",
    "LU" to "Emetab Luxembourg",
    "LV" to "Emetab Latvia",
    "LY" to "Emetab Libya",
    "MA" to "Emetab Morocco",
    "MC" to "Emetab Monaco",
    "MD" to "Emetab Moldova",
    "MG" to "Emetab Madagascar",
    "MH" to "Ikwembeiyotab Marshall",
    "ML" to "Emetab Mali",
    "MM" to "Emetab Myanmar",
    "MN" to "Emetab Mongolia",
    "MP" to "Ikwembeiyotab Mariana nebo murot katam",
    "MQ" to "Emetab Martinique",
    "MR" to "Emetab Mauritania",
    "MS" to "Emetab Montserrat",
    "MT" to "Emetab Malta",
    "MU" to "Emetab Mauritius",
    "MV" to "Emetab Maldives",
    "MW" to "Emetab Malawi",
    "MX" to "Emetab Mexico",
    "MY" to "Emetab Malaysia",
    "MZ" to "Emetab Mozambique",
    "NA" to "Emetab Namibia",
    "NC" to "Emetab New Caledonia",
    "NE" to "Emetab niger",
    "NF" to "Ikwembeiyotab Norfork",
    "NG" to "Emetab Nigeria",
    "NI" to "Emetab Nicaragua",
    "NL" to "Emetab Holand",
    "NO" to "Emetab Norway",
    "NP" to "Emetab Nepal",
    "NR" to "Emetab Nauru",
    "NU" to "Emetab Niue",
    "NZ" to "Emetab New Zealand",
    "OM" to "Emetab Oman",
    "PA" to "Emetab Panama",
    "PE" to "Emetab Peru",
    "PF" to "Emetab Polynesia nebo ufaransa",
    "PG" to "Emetab Papua New Guinea",
    "PH" to "Emetab Philippines",
    "PK" to "Emetab Pakistan",
    "PL" to "Emetab Poland",
    "PM" to "Emetab Peter Ne titil ak Miquelon",
    "PN" to "Emetab Pitcairn",
    "PR" to "Emetab Puerto Rico",
    "PS" to "Emetab Palestine",
    "PT" to "Emetab Portugal",
    "PW" to "Emetab Palau",
    "PY" to "Emetab Paraguay",
    "QA" to "Emetab Qatar",
    "RE" to "Emetab Réunion",
    "RO" to "Emetab Romania",
    "RU" to "Emetab Russia",
    "RW" to "Emetab Rwanda",
    "SA" to "Emetab Saudi Arabia",
    "SB" to "Ikwembeiyotab Solomon",
    "SC" to "Emetab Seychelles",
    "SD" to "Emetab Sudan",
    "SE" to "Emetab Sweden",
    "SG" to "Emetab Singapore",
    "SH" to "Emetab Helena Ne tilil",
    "SI" to "Emetab Slovenia",
    "SK" to "Emetab Slovakia",
    "SL" to "Emetab Sierra Leone",
    "SM" to "Emetab San Marino",
    "SN" to "Emetab Senegal",
    "SO" to "Emetab Somalia",
    "SR" to "Emetab Suriname",
    "ST" to "Emetab São Tomé and Príncipe",
    "SV" to "Emetab El Salvador",
    "SY" to "Emetab Syria",
    "SZ" to "Emetab Swaziland",
    "TC" to "Ikwembeiyotab Turks ak Caicos",
    "TD" to "Emetab Chad",
    "TG" to "Emetab Togo",
    "TH" to "Emetab Thailand",
    "TJ" to "Emetab Tajikistan",
    "TK" to "Emetab Tokelau",
    "TL" to "Emetab Timor nebo Murot tai",
    "TM" to "Emetab Turkmenistan",
    "TN" to "Emetab Tunisia",
    "TO" to "Emetab Tonga",
    "TR" to "Emetab Turkey",
    "TT" to "Emetab Trinidad ak Tobago",
    "TV" to "Emetab Tuvalu",
    "TW" to "Emetab Taiwan",
    "TZ" to "Emetab Tanzania",
    "UA" to "Emetab Ukrainie",
    "UG" to "Emetab Uganda",
    "US" to "Emetab amerika",
    "UY" to "Emetab Uruguay",
    "UZ" to "Emetab Uzibekistani",
    "VA" to "Emetab Vatican",
    "VC" to "Emetab Vincent netilil ak Grenadines",
    "VE" to "Emetab Venezuela",
    "VG" to "Ikwembeyotab British Virgin",
    "VI" to "Ikwemweiyotab Amerika",
    "VN" to "Emetab Vietnam",
    "VU" to "Emetab Vanuatu",
    "WF" to "Emetab Walis ak Futuna",
    "WS" to "Emetab Samoa",
    "YE" to "Emetab Yemen",
    "YT" to "Emetab Mayotte",
    "ZA" to "Emetab Afrika nebo Murot tai",
    "ZM" to "Emetab Zambia",
    "ZW" to "Emetab Zimbabwe",
  ) }

  val km: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "ពិភពលោក",
    "002" to "អាហ្វ្រិក",
    "003" to "អាមេរិក​ខាង​ជើង",
    "005" to "អាមេរិក​ខាង​ត្បូង",
    "009" to "អូសេអានី",
    "011" to "អាហ្វ្រិក​ខាង​លិច",
    "013" to "អាមេរិក​កណ្ដាល",
    "014" to "អាហ្វ្រិកខាងកើត",
    "015" to "អាហ្វ្រិក​ខាង​ជើង",
    "017" to "អាហ្វ្រិក​កណ្តាល",
    "018" to "អាហ្វ្រិកភាគខាងត្បូង",
    "019" to "អាមេរិក",
    "021" to "អាមេរិក​ភាគ​ខាង​ជើង",
    "029" to "ការ៉ាប៊ីន",
    "030" to "អាស៊ី​ខាង​កើត",
    "034" to "អាស៊ី​ខាង​ត្បូង",
    "035" to "អាស៊ីអាគ្នេយ៍",
    "039" to "អឺរ៉ុប​ខាង​ត្បូង",
    "053" to "អូស្ត្រាឡាស៊ី",
    "054" to "មេឡាណេស៊ី",
    "057" to "តំបន់​មីក្រូណេស៊ី",
    "061" to "ប៉ូលីណេស៊ី",
    "142" to "អាស៊ី",
    "143" to "អាស៊ី​កណ្ដាល",
    "145" to "អាស៊ី​ខាង​លិច",
    "150" to "អឺរ៉ុប",
    "151" to "អឺរ៉ុប​ខាង​កើត",
    "154" to "អឺរ៉ុប​ខាង​ជើង",
    "155" to "អឺរ៉ុប​ខាង​លិច",
    "202" to "អនុតំបន់សាហារ៉ាអាហ្វ្រិក",
    "419" to "អាមេរិក​ឡាទីន",
    "AC" to "កោះ​អាសេនសិន",
    "AD" to "អង់ដូរ៉ា",
    "AE" to "អេមីរ៉ាត​អារ៉ាប់​រួម",
    "AF" to "អាហ្វហ្កានីស្ថាន",
    "AG" to "អង់ទីហ្គា និង បាប៊ុយដា",
    "AI" to "អង់ហ្គីឡា",
    "AL" to "អាល់បានី",
    "AM" to "អាមេនី",
    "AO" to "អង់ហ្គោឡា",
    "AQ" to "អង់តាក់ទិក",
    "AR" to "អាហ្សង់ទីន",
    "AS" to "សាម័រ អាមេរិកាំង",
    "AT" to "អូទ្រីស",
    "AU" to "អូស្ត្រាលី",
    "AW" to "អារូបា",
    "AX" to "កោះ​អាឡង់",
    "AZ" to "អាស៊ែបៃហ្សង់",
    "BA" to "បូស្ន៊ី និងហឺហ្ស៊ីហ្គូវីណា",
    "BB" to "បាបាដុស",
    "BD" to "បង់ក្លាដែស",
    "BE" to "បែលហ្ស៊ិក",
    "BF" to "បួគីណាហ្វាសូ",
    "BG" to "ប៊ុលហ្ការី",
    "BH" to "បារ៉ែន",
    "BI" to "ប៊ូរុនឌី",
    "BJ" to "បេណាំង",
    "BL" to "សាំង​បាថេឡេមី",
    "BM" to "ប៊ឺមុយដា",
    "BN" to "ព្រុយណេ",
    "BO" to "បូលីវី",
    "BQ" to "ហូឡង់ ការ៉ាប៊ីន",
    "BR" to "ប្រេស៊ីល",
    "BS" to "បាហាម៉ា",
    "BT" to "ប៊ូតង់",
    "BV" to "កោះ​ប៊ូវ៉េត",
    "BW" to "បុតស្វាណា",
    "BY" to "បេឡារុស",
    "BZ" to "បេលី",
    "CA" to "កាណាដា",
    "CC" to "កោះ​កូកូស (គីលីង)",
    "CD" to "កុងហ្គោ- គីនស្ហាសា",
    "CF" to "សាធារណរដ្ឋអាហ្វ្រិកកណ្ដាល",
    "CG" to "កុងហ្គោ - ប្រាហ្សាវីល",
    "CH" to "ស្វ៊ីស",
    "CI" to "កូតឌីវ័រ",
    "CK" to "កោះ​ខូក",
    "CL" to "ស៊ីលី",
    "CM" to "កាមេរូន",
    "CN" to "ចិន",
    "CO" to "កូឡុំប៊ី",
    "CP" to "កោះ​ឃ្លីភឺតុន",
    "CR" to "កូស្តារីកា",
    "CU" to "គុយបា",
    "CV" to "កាប់វែរ",
    "CW" to "កូរ៉ាកៅ",
    "CX" to "កោះ​គ្រីស្មាស",
    "CY" to "ស៊ីប",
    "CZ" to "ឆែក",
    "DE" to "អាល្លឺម៉ង់",
    "DG" to "ឌៀហ្គោហ្គាស៊ី",
    "DJ" to "ជីប៊ូទី",
    "DK" to "ដាណឺម៉ាក",
    "DM" to "ដូមីនីក",
    "DO" to "សាធារណរដ្ឋ​ដូមីនីក",
    "DZ" to "អាល់ហ្សេរី",
    "EA" to "ជឺតា និង​ម៉េលីឡា",
    "EC" to "អេក្វាទ័រ",
    "EE" to "អេស្តូនី",
    "EG" to "អេហ្ស៊ីប",
    "EH" to "សាហារ៉ាខាងលិច",
    "ER" to "អេរីត្រេ",
    "ES" to "អេស្ប៉ាញ",
    "ET" to "អេត្យូពី",
    "EU" to "សហភាព​អឺរ៉ុប",
    "EZ" to "តំបន់ចាយលុយអឺរ៉ូ",
    "FI" to "ហ្វាំងឡង់",
    "FJ" to "ហ្វីជី",
    "FK" to "កោះ​ហ្វក់ឡែន",
    "FM" to "មីក្រូណេស៊ី",
    "FO" to "កោះ​ហ្វារ៉ូ",
    "FR" to "បារាំង",
    "GA" to "ហ្គាបុង",
    "GB" to "ចក្រភព​អង់គ្លេស",
    "GD" to "ហ្គ្រើណាដ",
    "GE" to "ហ្សកហ្ស៊ី",
    "GF" to "ហ្គីអាណា បារាំង",
    "GG" to "ហ្គេនស៊ី",
    "GH" to "ហ្គាណា",
    "GI" to "ហ្ស៊ីប្រាល់តា",
    "GL" to "ហ្គ្រោអង់ឡង់",
    "GM" to "ហ្គំប៊ី",
    "GN" to "ហ្គីណេ",
    "GP" to "ហ្គោដឺឡុប",
    "GQ" to "ហ្គីណេអេក្វាទ័រ",
    "GR" to "ក្រិក",
    "GS" to "កោះ​ហ្សកហ្ស៊ី​ខាងត្បូង និង សង់វិច​ខាងត្បូង",
    "GT" to "ក្វាតេម៉ាឡា",
    "GU" to "ហ្គាំ",
    "GW" to "ហ្គីណេប៊ីស្សូ",
    "GY" to "ហ្គីយ៉ាន",
    "HK" to "ហុងកុង តំបន់រដ្ឋបាលពិសេសចិន",
    "HM" to "កោះ​ហឺដនិង​ម៉ាក់ដូណាល់",
    "HN" to "ហុងឌូរ៉ាស",
    "HR" to "ក្រូអាស៊ី",
    "HT" to "ហៃទី",
    "HU" to "ហុងគ្រី",
    "IC" to "កោះ​កាណារី",
    "ID" to "ឥណ្ឌូណេស៊ី",
    "IE" to "អៀរឡង់",
    "IL" to "អ៊ីស្រាអែល",
    "IM" to "អែលអុហ្វមែន",
    "IN" to "ឥណ្ឌា",
    "IO" to "ដែនដី​អង់គ្លេស​នៅ​មហា​សមុទ្រ​ឥណ្ឌា",
    "IQ" to "អ៊ីរ៉ាក់",
    "IR" to "អ៊ីរ៉ង់",
    "IS" to "អ៊ីស្លង់",
    "IT" to "អ៊ីតាលី",
    "JE" to "ជើស៊ី",
    "JM" to "ហ្សាម៉ាអ៊ីក",
    "JO" to "ហ៊្សកដានី",
    "JP" to "ជប៉ុន",
    "KE" to "កេនយ៉ា",
    "KG" to "កៀហ្ស៊ីស៊ីស្ថាន",
    "KH" to "កម្ពុជា",
    "KI" to "គិរីបាទី",
    "KM" to "កូម័រ",
    "KN" to "សាំង​គីត និង ណេវីស",
    "KP" to "កូរ៉េ​ខាង​ជើង",
    "KR" to "កូរ៉េ​ខាង​ត្បូង",
    "KW" to "កូវ៉ែត",
    "KY" to "កោះ​កៃម៉ង់",
    "KZ" to "កាហ្សាក់ស្ថាន",
    "LA" to "ឡាវ",
    "LB" to "លីបង់",
    "LC" to "សាំងលូស៊ី",
    "LI" to "លិចតិនស្ដាញ",
    "LK" to "ស្រីលង្កា",
    "LR" to "លីបេរីយ៉ា",
    "LS" to "ឡេសូតូ",
    "LT" to "លីទុយអានី",
    "LU" to "លុចសំបួ",
    "LV" to "ឡេតូនី",
    "LY" to "លីប៊ី",
    "MA" to "ម៉ារ៉ុក",
    "MC" to "ម៉ូណាកូ",
    "MD" to "ម៉ុលដាវី",
    "ME" to "ម៉ុងតេណេហ្គ្រោ",
    "MF" to "សាំង​ម៉ាទីន",
    "MG" to "ម៉ាដាហ្គាស្កា",
    "MH" to "កោះ​ម៉ាស់សល",
    "MK" to "ម៉ាសេដ្វានខាងជើង",
    "ML" to "ម៉ាលី",
    "MM" to "មីយ៉ាន់ម៉ា (ភូមា)",
    "MN" to "ម៉ុងហ្គោលី",
    "MO" to "ម៉ាកាវ តំបន់រដ្ឋបាលពិសេសចិន",
    "MP" to "កោះ​ម៉ារីណា​ខាង​ជើង",
    "MQ" to "ម៉ាទីនីក",
    "MR" to "ម៉ូរីតានី",
    "MS" to "ម៉ុងស៊ែរ៉ា",
    "MT" to "ម៉ាល់ត៍",
    "MU" to "ម៉ូរីស",
    "MV" to "ម៉ាល់ឌីវ",
    "MW" to "ម៉ាឡាវី",
    "MX" to "ម៉ិកស៊ិក",
    "MY" to "ម៉ាឡេស៊ី",
    "MZ" to "ម៉ូសំប៊ិក",
    "NA" to "ណាមីប៊ី",
    "NC" to "នូវែល​កាឡេដូនី",
    "NE" to "នីហ្សេ",
    "NF" to "កោះ​ណ័រហ្វក់",
    "NG" to "នីហ្សេរីយ៉ា",
    "NI" to "នីការ៉ាហ្គា",
    "NL" to "ហូឡង់",
    "NO" to "ន័រវែស",
    "NP" to "នេប៉ាល់",
    "NR" to "ណូរូ",
    "NU" to "ណៀ",
    "NZ" to "នូវែល​សេឡង់",
    "OM" to "អូម៉ង់",
    "PA" to "ប៉ាណាម៉ា",
    "PE" to "ប៉េរូ",
    "PF" to "ប៉ូលី​ណេស៊ី​បារាំង",
    "PG" to "ប៉ាពូអាស៊ី​នូវែលហ្គីណេ",
    "PH" to "ហ្វ៊ីលីពីន",
    "PK" to "ប៉ាគីស្ថាន",
    "PL" to "ប៉ូឡូញ",
    "PM" to "សង់ព្យែរ និង​មីគីឡុង",
    "PN" to "កោះ​ភីតកាន",
    "PR" to "ព័រតូរីកូ",
    "PS" to "ដែនដីប៉ាឡេស្ទីន",
    "PT" to "ព័រទុយហ្កាល់",
    "PW" to "ផៅឡូ",
    "PY" to "ប៉ារ៉ាហ្គាយ",
    "QA" to "កាតា",
    "QO" to "តំបន់ជាយអូសេអានី",
    "RE" to "រេអុយញ៉ុង",
    "RO" to "រូម៉ានី",
    "RS" to "សែប៊ី",
    "RU" to "រុស្ស៊ី",
    "RW" to "រវ៉ាន់ដា",
    "SA" to "អារ៉ាប៊ីសាអូឌីត",
    "SB" to "កោះ​សូឡូម៉ុង",
    "SC" to "សីស្ហែល",
    "SD" to "ស៊ូដង់",
    "SE" to "ស៊ុយអែត",
    "SG" to "សិង្ហបុរី",
    "SH" to "សង់​ហេឡេណា",
    "SI" to "ស្លូវេនី",
    "SJ" to "ស្វាលបាដ និង ហ្សង់ម៉ាយេន",
    "SK" to "ស្លូវ៉ាគី",
    "SL" to "សៀរ៉ាឡេអូន",
    "SM" to "សាន​ម៉ារីណូ",
    "SN" to "សេណេហ្គាល់",
    "SO" to "សូម៉ាលី",
    "SR" to "សូរីណាម",
    "SS" to "ស៊ូដង់​ខាង​ត្បូង",
    "ST" to "សៅតូម៉េ និង ប្រាំងស៊ីប",
    "SV" to "អែលសាល់វ៉ាឌ័រ",
    "SX" to "សីង​ម៉ាធីន",
    "SY" to "ស៊ីរី",
    "SZ" to "ស្វាស៊ីឡង់",
    "TA" to "ទ្រីស្តង់​ដា​ចូនហា",
    "TC" to "កោះ​ទួគ និង កៃកូស",
    "TD" to "ឆាដ",
    "TF" to "ដែនដី​បារាំង​នៅ​ភាគខាងត្បូង",
    "TG" to "តូហ្គោ",
    "TH" to "ថៃ",
    "TJ" to "តាហ្ស៊ីគីស្ថាន",
    "TK" to "តូខេឡៅ",
    "TL" to "ទីម័រលេស្តេ",
    "TM" to "តួកម៉េនីស្ថាន",
    "TN" to "ទុយនីស៊ី",
    "TO" to "តុងហ្គា",
    "TR" to "តួកគី",
    "TT" to "ទ្រីនីដាត និង​តូបាហ្គោ",
    "TV" to "ទូវ៉ាលូ",
    "TW" to "តៃវ៉ាន់",
    "TZ" to "តង់សានី",
    "UA" to "អ៊ុយក្រែន",
    "UG" to "អ៊ូហ្គង់ដា",
    "UM" to "កោះ​អៅឡាយីង​អាមេរិក",
    "UN" to "អង្គការសហប្រជាជាតិ",
    "US" to "សហរដ្ឋអាមេរិក",
    "UY" to "អ៊ុយរូហ្គាយ",
    "UZ" to "អ៊ូសបេគីស្ថាន",
    "VA" to "បុរី​វ៉ាទីកង់",
    "VC" to "សាំង​វ៉ាំងសង់ និង ហ្គ្រេណាឌីន",
    "VE" to "វ៉េណេស៊ុយអេឡា",
    "VG" to "កោះ​វឺជិន​ចក្រភព​អង់គ្លេស",
    "VI" to "កោះ​វឺជីន​អាមេរិក",
    "VN" to "វៀតណាម",
    "VU" to "វ៉ានូទូ",
    "WF" to "វ៉ាលីស និង​ហ្វូទូណា",
    "WS" to "សាម័រ",
    "XA" to "Pseudo-Accents",
    "XB" to "Pseudo-Bidi",
    "XK" to "កូសូវ៉ូ",
    "YE" to "យេម៉ែន",
    "YT" to "ម៉ាយុត",
    "ZA" to "អាហ្វ្រិកខាងត្បូង",
    "ZM" to "សំប៊ី",
    "ZW" to "ស៊ីមបាវ៉េ",
    "ZZ" to "តំបន់មិនស្គាល់",
  ) }

  val kn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "ಪ್ರಪಂಚ",
    "002" to "ಆಫ್ರಿಕಾ",
    "003" to "ಉತ್ತರ ಅಮೇರಿಕಾ",
    "005" to "ದಕ್ಷಿಣ ಅಮೇರಿಕಾ",
    "009" to "ಓಶಿಯೇನಿಯಾ",
    "011" to "ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾ",
    "013" to "ಮಧ್ಯ ಅಮೇರಿಕಾ",
    "014" to "ಪೂರ್ವ ಆಫ್ರಿಕಾ",
    "015" to "ಉತ್ತರ ಆಫ್ರಿಕಾ",
    "017" to "ಮಧ್ಯ ಆಫ್ರಿಕಾ",
    "018" to "ಆಫ್ರಿಕಾದ ದಕ್ಷಿಣ ಭಾಗ",
    "019" to "ಅಮೆರಿಕಾಸ್",
    "021" to "ಅಮೇರಿಕಾದ ಉತ್ತರ ಭಾಗ",
    "029" to "ಕೆರೀಬಿಯನ್",
    "030" to "ಪೂರ್ವ ಏಷ್ಯಾ",
    "034" to "ದಕ್ಷಿಣ ಏಷ್ಯಾ",
    "035" to "ಆಗ್ನೇಯ ಏಷ್ಯಾ",
    "039" to "ದಕ್ಷಿಣ ಯೂರೋಪ್",
    "053" to "ಆಸ್ಟ್ರೇಲೇಷ್ಯಾ",
    "054" to "ಮೆಲನೇಷಿಯಾ",
    "057" to "ಮೈಕ್ರೋನೇಶಿಯನ್ ಪ್ರದೇಶ",
    "061" to "ಪಾಲಿನೇಷ್ಯಾ",
    "142" to "ಏಷ್ಯಾ",
    "143" to "ಮಧ್ಯ ಏಷ್ಯಾ",
    "145" to "ಪಶ್ಚಿಮ ಏಷ್ಯಾ",
    "150" to "ಯೂರೋಪ್",
    "151" to "ಪೂರ್ವ ಯೂರೋಪ್",
    "154" to "ಉತ್ತರ ಯೂರೋಪ್",
    "155" to "ಪಶ್ಚಿಮ ಯೂರೋಪ್",
    "202" to "ಉಪ-ಸಹಾರನ್ ಆಫ್ರಿಕಾ",
    "419" to "ಲ್ಯಾಟಿನ್ ಅಮೇರಿಕಾ",
    "AC" to "ಅಸೆನ್ಶನ್ ದ್ವೀಪ",
    "AD" to "ಅಂಡೋರಾ",
    "AE" to "ಯುನೈಟೆಡ್ ಅರಬ್ ಎಮಿರೇಟ್ಸ್",
    "AF" to "ಅಫಘಾನಿಸ್ಥಾನ",
    "AG" to "ಆಂಟಿಗುವಾ ಮತ್ತು ಬರ್ಬುಡಾ",
    "AI" to "ಆಂಗ್ವಿಲ್ಲಾ",
    "AL" to "ಅಲ್ಬೇನಿಯಾ",
    "AM" to "ಆರ್ಮೇನಿಯ",
    "AO" to "ಅಂಗೋಲಾ",
    "AQ" to "ಅಂಟಾರ್ಟಿಕಾ",
    "AR" to "ಅರ್ಜೆಂಟಿನಾ",
    "AS" to "ಅಮೇರಿಕನ್ ಸಮೋವಾ",
    "AT" to "ಆಸ್ಟ್ರಿಯಾ",
    "AU" to "ಆಸ್ಟ್ರೇಲಿಯಾ",
    "AW" to "ಅರುಬಾ",
    "AX" to "ಆಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು",
    "AZ" to "ಅಜರ್ಬೈಜಾನ್",
    "BA" to "ಬೋಸ್ನಿಯಾ ಮತ್ತು ಹರ್ಜೆಗೋವಿನಾ",
    "BB" to "ಬಾರ್ಬಡೋಸ್",
    "BD" to "ಬಾಂಗ್ಲಾದೇಶ",
    "BE" to "ಬೆಲ್ಜಿಯಮ್",
    "BF" to "ಬುರ್ಕಿನಾ ಫಾಸೊ",
    "BG" to "ಬಲ್ಗೇರಿಯಾ",
    "BH" to "ಬಹ್ರೇನ್",
    "BI" to "ಬುರುಂಡಿ",
    "BJ" to "ಬೆನಿನ್",
    "BL" to "ಸೇಂಟ್ ಬಾರ್ಥೆಲೆಮಿ",
    "BM" to "ಬರ್ಮುಡಾ",
    "BN" to "ಬ್ರೂನಿ",
    "BO" to "ಬೊಲಿವಿಯಾ",
    "BQ" to "ಕೆರೀಬಿಯನ್ ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್",
    "BR" to "ಬ್ರೆಜಿಲ್",
    "BS" to "ಬಹಾಮಾಸ್",
    "BT" to "ಭೂತಾನ್",
    "BV" to "ಬೋವೆಟ್ ದ್ವೀಪ",
    "BW" to "ಬೋಟ್ಸ್‌ವಾನಾ",
    "BY" to "ಬೆಲಾರಸ್",
    "BZ" to "ಬೆಲಿಜ್",
    "CA" to "ಕೆನಡಾ",
    "CC" to "ಕೊಕೊಸ್ (ಕೀಲಿಂಗ್) ದ್ವೀಪಗಳು",
    "CD" to "ಕಾಂಗೋ - ಕಿನ್ಶಾಸಾ",
    "CF" to "ಮಧ್ಯ ಆಫ್ರಿಕಾ ಗಣರಾಜ್ಯ",
    "CG" to "ಕಾಂಗೋ - ಬ್ರಾಜಾವಿಲ್ಲೇ",
    "CH" to "ಸ್ವಿಟ್ಜರ್ಲ್ಯಾಂಡ್",
    "CI" to "ಕೋತ್ ದ್‘ಇವಾರ್",
    "CK" to "ಕುಕ್ ದ್ವೀಪಗಳು",
    "CL" to "ಚಿಲಿ",
    "CM" to "ಕ್ಯಾಮರೂನ್",
    "CN" to "ಚೀನಾ",
    "CO" to "ಕೊಲಂಬಿಯಾ",
    "CP" to "ಕ್ಲಿಪ್ಪರ್‌ಟಾನ್ ದ್ವೀಪ",
    "CR" to "ಕೊಸ್ಟಾ ರಿಕಾ",
    "CU" to "ಕ್ಯೂಬಾ",
    "CV" to "ಕೇಪ್ ವರ್ಡೆ",
    "CW" to "ಕುರಾಕಾವ್",
    "CX" to "ಕ್ರಿಸ್ಮಸ್ ದ್ವೀಪ",
    "CY" to "ಸೈಪ್ರಸ್",
    "CZ" to "ಝೆಕಿಯಾ",
    "DE" to "ಜರ್ಮನಿ",
    "DG" to "ಡೈಗೋ ಗಾರ್ಸಿಯ",
    "DJ" to "ಜಿಬೂಟಿ",
    "DK" to "ಡೆನ್ಮಾರ್ಕ್",
    "DM" to "ಡೊಮಿನಿಕಾ",
    "DO" to "ಡೊಮೆನಿಕನ್ ರಿಪಬ್ಲಿಕ್",
    "DZ" to "ಅಲ್ಜೀರಿಯ",
    "EA" to "ಸೆಯುಟಾ ಹಾಗೂ ಮೆಲಿಲ್ಲಾ",
    "EC" to "ಈಕ್ವೆಡಾರ್",
    "EE" to "ಎಸ್ಟೋನಿಯಾ",
    "EG" to "ಈಜಿಪ್ಟ್",
    "EH" to "ಪಶ್ಚಿಮ ಸಹಾರಾ",
    "ER" to "ಎರಿಟ್ರಿಯಾ",
    "ES" to "ಸ್ಪೇನ್",
    "ET" to "ಇಥಿಯೋಪಿಯಾ",
    "EU" to "ಯುರೋಪಿಯನ್ ಒಕ್ಕೂಟ",
    "EZ" to "ಯೂರೋಝೋನ್‌",
    "FI" to "ಫಿನ್‌ಲ್ಯಾಂಡ್",
    "FJ" to "ಫಿಜಿ",
    "FK" to "ಫಾಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು",
    "FM" to "ಮೈಕ್ರೋನೇಶಿಯಾ",
    "FO" to "ಫರೋ ದ್ವೀಪಗಳು",
    "FR" to "ಫ್ರಾನ್ಸ್",
    "GA" to "ಗೆಬೊನ್",
    "GB" to "ಯುನೈಟೆಡ್ ಕಿಂಗ್‌ಡಮ್",
    "GD" to "ಗ್ರೆನೆಡಾ",
    "GE" to "ಜಾರ್ಜಿಯಾ",
    "GF" to "ಫ್ರೆಂಚ್ ಗಯಾನಾ",
    "GG" to "ಗುರ್ನ್‌ಸೆ",
    "GH" to "ಘಾನಾ",
    "GI" to "ಗಿಬ್ರಾಲ್ಟರ್",
    "GL" to "ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್",
    "GM" to "ಗ್ಯಾಂಬಿಯಾ",
    "GN" to "ಗಿನಿ",
    "GP" to "ಗುಡೆಲೋಪ್",
    "GQ" to "ಈಕ್ವೆಟೋರಿಯಲ್ ಗಿನಿ",
    "GR" to "ಗ್ರೀಸ್",
    "GS" to "ದಕ್ಷಿಣ ಜಾರ್ಜಿಯಾ ಮತ್ತು ದಕ್ಷಿಣ ಸ್ಯಾಂಡ್‍ವಿಚ್ ದ್ವೀಪಗಳು",
    "GT" to "ಗ್ವಾಟೆಮಾಲಾ",
    "GU" to "ಗುವಾಮ್",
    "GW" to "ಗಿನಿ-ಬಿಸ್ಸಾವ್",
    "GY" to "ಗಯಾನಾ",
    "HK" to "ಹಾಂಗ್ ಕಾಂಗ್ ಎಸ್ಎಆರ್ ಚೈನಾ",
    "HM" to "ಹರ್ಡ್ ಮತ್ತು ಮ್ಯಾಕ್‌ಡೋನಾಲ್ಡ್ ದ್ವೀಪಗಳು",
    "HN" to "ಹೊಂಡುರಾಸ್",
    "HR" to "ಕ್ರೊಯೇಷಿಯಾ",
    "HT" to "ಹೈಟಿ",
    "HU" to "ಹಂಗೇರಿ",
    "IC" to "ಕ್ಯಾನರಿ ದ್ವೀಪಗಳು",
    "ID" to "ಇಂಡೋನೇಶಿಯಾ",
    "IE" to "ಐರ್ಲೆಂಡ್",
    "IL" to "ಇಸ್ರೇಲ್",
    "IM" to "ಐಲ್ ಆಫ್ ಮ್ಯಾನ್",
    "IN" to "ಭಾರತ",
    "IO" to "ಬ್ರಿಟೀಷ್ ಹಿಂದೂ ಮಹಾಸಾಗರದ ಪ್ರದೇಶ",
    "IQ" to "ಇರಾಕ್",
    "IR" to "ಇರಾನ್",
    "IS" to "ಐಸ್‌ಲ್ಯಾಂಡ್",
    "IT" to "ಇಟಲಿ",
    "JE" to "ಜೆರ್ಸಿ",
    "JM" to "ಜಮೈಕಾ",
    "JO" to "ಜೋರ್ಡಾನ್",
    "JP" to "ಜಪಾನ್",
    "KE" to "ಕೀನ್ಯಾ",
    "KG" to "ಕಿರ್ಗಿಸ್ಥಾನ್",
    "KH" to "ಕಾಂಬೋಡಿಯಾ",
    "KI" to "ಕಿರಿಬಾಟಿ",
    "KM" to "ಕೊಮೊರೊಸ್",
    "KN" to "ಸೇಂಟ್ ಕಿಟ್ಸ್ ಮತ್ತು ನೆವಿಸ್",
    "KP" to "ಉತ್ತರ ಕೊರಿಯಾ",
    "KR" to "ದಕ್ಷಿಣ ಕೊರಿಯಾ",
    "KW" to "ಕುವೈತ್",
    "KY" to "ಕೇಮನ್ ದ್ವೀಪಗಳು",
    "KZ" to "ಕಝಾಕಿಸ್ಥಾನ್",
    "LA" to "ಲಾವೋಸ್",
    "LB" to "ಲೆಬನಾನ್",
    "LC" to "ಸೇಂಟ್ ಲೂಸಿಯಾ",
    "LI" to "ಲಿಚೆನ್‌ಸ್ಟೈನ್",
    "LK" to "ಶ್ರೀಲಂಕಾ",
    "LR" to "ಲಿಬೇರಿಯಾ",
    "LS" to "ಲೆಸೊಥೊ",
    "LT" to "ಲಿಥುವೇನಿಯಾ",
    "LU" to "ಲಕ್ಸೆಂಬರ್ಗ್",
    "LV" to "ಲಾಟ್ವಿಯಾ",
    "LY" to "ಲಿಬಿಯಾ",
    "MA" to "ಮೊರಾಕ್ಕೊ",
    "MC" to "ಮೊನಾಕೊ",
    "MD" to "ಮೊಲ್ಡೋವಾ",
    "ME" to "ಮೊಂಟೆನೆಗ್ರೋ",
    "MF" to "ಸೇಂಟ್ ಮಾರ್ಟಿನ್",
    "MG" to "ಮಡಗಾಸ್ಕರ್",
    "MH" to "ಮಾರ್ಷಲ್ ದ್ವೀಪಗಳು",
    "MK" to "ಉತ್ತರ ಮ್ಯಾಸಿಡೋನಿಯಾ",
    "ML" to "ಮಾಲಿ",
    "MM" to "ಮಯನ್ಮಾರ್ (ಬರ್ಮಾ)",
    "MN" to "ಮಂಗೋಲಿಯಾ",
    "MO" to "ಮಕಾವು ಎಸ್ಎಆರ್ ಚೈನಾ",
    "MP" to "ಉತ್ತರ ಮರಿಯಾನಾ ದ್ವೀಪಗಳು",
    "MQ" to "ಮಾರ್ಟಿನಿಕ್",
    "MR" to "ಮಾರಿಟೇನಿಯಾ",
    "MS" to "ಮಾಂಟ್‌ಸೆರಟ್",
    "MT" to "ಮಾಲ್ಟಾ",
    "MU" to "ಮಾರಿಷಸ್",
    "MV" to "ಮಾಲ್ಡೀವ್ಸ್",
    "MW" to "ಮಲಾವಿ",
    "MX" to "ಮೆಕ್ಸಿಕೊ",
    "MY" to "ಮಲೇಶಿಯಾ",
    "MZ" to "ಮೊಜಾಂಬಿಕ್",
    "NA" to "ನಮೀಬಿಯಾ",
    "NC" to "ನ್ಯೂ ಕ್ಯಾಲಿಡೋನಿಯಾ",
    "NE" to "ನೈಜರ್",
    "NF" to "ನಾರ್ಫೋಕ್ ದ್ವೀಪ",
    "NG" to "ನೈಜೀರಿಯಾ",
    "NI" to "ನಿಕಾರಾಗುವಾ",
    "NL" to "ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್",
    "NO" to "ನಾರ್ವೆ",
    "NP" to "ನೇಪಾಳ",
    "NR" to "ನೌರು",
    "NU" to "ನಿಯು",
    "NZ" to "ನ್ಯೂಜಿಲೆಂಡ್",
    "OM" to "ಓಮನ್",
    "PA" to "ಪನಾಮಾ",
    "PE" to "ಪೆರು",
    "PF" to "ಫ್ರೆಂಚ್ ಪಾಲಿನೇಷ್ಯಾ",
    "PG" to "ಪಪುವಾ ನ್ಯೂಗಿನಿಯಾ",
    "PH" to "ಫಿಲಿಫೈನ್ಸ್",
    "PK" to "ಪಾಕಿಸ್ತಾನ",
    "PL" to "ಪೋಲ್ಯಾಂಡ್",
    "PM" to "ಸೇಂಟ್ ಪಿಯರ್ ಮತ್ತು ಮಿಕ್ವೆಲನ್",
    "PN" to "ಪಿಟ್‌ಕೈರ್ನ್ ದ್ವೀಪಗಳು",
    "PR" to "ಪ್ಯೂರ್ಟೋ ರಿಕೊ",
    "PS" to "ಪ್ಯಾಲೇಸ್ಟೇನಿಯನ್ ಪ್ರದೇಶಗಳು",
    "PT" to "ಪೋರ್ಚುಗಲ್",
    "PW" to "ಪಲಾವು",
    "PY" to "ಪರಾಗ್ವೇ",
    "QA" to "ಖತಾರ್",
    "QO" to "ಔಟ್ ಲೈಯಿಂಗ್ ಓಷಿಯಾನಿಯಾ",
    "RE" to "ರಿಯೂನಿಯನ್",
    "RO" to "ರೊಮೇನಿಯಾ",
    "RS" to "ಸೆರ್ಬಿಯಾ",
    "RU" to "ರಷ್ಯಾ",
    "RW" to "ರುವಾಂಡಾ",
    "SA" to "ಸೌದಿ ಅರೇಬಿಯಾ",
    "SB" to "ಸಾಲೊಮನ್ ದ್ವೀಪಗಳು",
    "SC" to "ಸೀಶೆಲ್ಲೆಸ್",
    "SD" to "ಸುಡಾನ್",
    "SE" to "ಸ್ವೀಡನ್",
    "SG" to "ಸಿಂಗಪುರ್",
    "SH" to "ಸೇಂಟ್ ಹೆಲೆನಾ",
    "SI" to "ಸ್ಲೋವೇನಿಯಾ",
    "SJ" to "ಸ್ವಾಲ್ಬಾರ್ಡ್ ಮತ್ತು ಜಾನ್ ಮೆಯನ್",
    "SK" to "ಸ್ಲೊವಾಕಿಯಾ",
    "SL" to "ಸಿಯೆರ್ರಾ ಲಿಯೋನ್",
    "SM" to "ಸ್ಯಾನ್ ಮೆರಿನೋ",
    "SN" to "ಸೆನೆಗಲ್",
    "SO" to "ಸೊಮಾಲಿಯಾ",
    "SR" to "ಸುರಿನಾಮ್",
    "SS" to "ದಕ್ಷಿಣ ಸುಡಾನ್",
    "ST" to "ಸಾವೋ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪಿ",
    "SV" to "ಎಲ್ ಸಾಲ್ವೇಡಾರ್",
    "SX" to "ಸಿಂಟ್ ಮಾರ್ಟೆನ್",
    "SY" to "ಸಿರಿಯಾ",
    "SZ" to "ಎಸ್ವಾಟಿನಿ",
    "TA" to "ಟ್ರಿಸ್ತನ್ ಡಾ ಕುನ್ಹಾ",
    "TC" to "ಟರ್ಕ್ಸ್ ಮತ್ತು ಕೈಕೋಸ್ ದ್ವೀಪಗಳು",
    "TD" to "ಚಾದ್",
    "TF" to "ಫ್ರೆಂಚ್ ದಕ್ಷಿಣ ಪ್ರದೇಶಗಳು",
    "TG" to "ಟೋಗೋ",
    "TH" to "ಥೈಲ್ಯಾಂಡ್",
    "TJ" to "ತಜಿಕಿಸ್ತಾನ್",
    "TK" to "ಟೊಕೆಲಾವ್",
    "TL" to "ಟಿಮೋರ್ ಲೆಸ್ಟೆ",
    "TM" to "ತುರ್ಕಮೆನಿಸ್ತಾನ್",
    "TN" to "ಟುನೀಶಿಯ",
    "TO" to "ಟೊಂಗಾ",
    "TR" to "ತುರ್ಕಿಯೆ",
    "TT" to "ಟ್ರಿನಿಡಾಡ್ ಮತ್ತು ಟೊಬಾಗೊ",
    "TV" to "ಟುವಾಲು",
    "TW" to "ತೈವಾನ್",
    "TZ" to "ತಾಂಜೇನಿಯಾ",
    "UA" to "ಉಕ್ರೈನ್",
    "UG" to "ಉಗಾಂಡಾ",
    "UM" to "ಯುಎಸ್‌ ಔಟ್‌ಲೇಯಿಂಗ್ ದ್ವೀಪಗಳು",
    "UN" to "ಸಂಯುಕ್ತ ಸಂಸ್ಥಾನಗಳು",
    "US" to "ಯುನೈಟೆಡ್ ಸ್ಟೇಟ್ಸ್",
    "UY" to "ಉರುಗ್ವೆ",
    "UZ" to "ಉಜ್ಬೇಕಿಸ್ಥಾನ್",
    "VA" to "ವ್ಯಾಟಿಕನ್ ಸಿಟಿ",
    "VC" to "ಸೇಂಟ್. ವಿನ್ಸೆಂಟ್ ಮತ್ತು ಗ್ರೆನೆಡೈನ್ಸ್",
    "VE" to "ವೆನೆಜುವೆಲಾ",
    "VG" to "ಬ್ರಿಟಿಷ್ ವರ್ಜಿನ್ ದ್ವೀಪಗಳು",
    "VI" to "ಯು.ಎಸ್. ವರ್ಜಿನ್ ದ್ವೀಪಗಳು",
    "VN" to "ವಿಯೆಟ್ನಾಮ್",
    "VU" to "ವನೌಟು",
    "WF" to "ವಾಲಿಸ್ ಮತ್ತು ಫುಟುನಾ",
    "WS" to "ಸಮೋವಾ",
    "XA" to "ಸ್ಯುಡೊ ಉಚ್ಛಾರಣೆಗಳು",
    "XB" to "ಸ್ಯುಡೊ-ಬಿಡಿ",
    "XK" to "ಕೊಸೊವೊ",
    "YE" to "ಯೆಮನ್",
    "YT" to "ಮಯೊಟ್ಟೆ",
    "ZA" to "ದಕ್ಷಿಣ ಆಫ್ರಿಕಾ",
    "ZM" to "ಜಾಂಬಿಯ",
    "ZW" to "ಜಿಂಬಾಬ್ವೆ",
    "ZZ" to "ಅಜ್ಞಾತ ಪ್ರದೇಶ",
  ) }

  val ko: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "세계",
    "002" to "아프리카",
    "003" to "북아메리카",
    "005" to "남아메리카",
    "009" to "오세아니아",
    "011" to "서부 아프리카",
    "013" to "중앙 아메리카",
    "014" to "동부 아프리카",
    "015" to "북부 아프리카",
    "017" to "중부 아프리카",
    "018" to "남부 아프리카",
    "019" to "아메리카 대륙",
    "021" to "북부 아메리카",
    "029" to "카리브 제도",
    "030" to "동아시아",
    "034" to "남아시아",
    "035" to "동남아시아",
    "039" to "남유럽",
    "053" to "오스트랄라시아",
    "054" to "멜라네시아",
    "057" to "미크로네시아 지역",
    "061" to "폴리네시아",
    "142" to "아시아",
    "143" to "중앙 아시아",
    "145" to "서아시아",
    "150" to "유럽",
    "151" to "동유럽",
    "154" to "북유럽",
    "155" to "서유럽",
    "202" to "사하라 사막 이남 아프리카",
    "419" to "라틴 아메리카",
    "AC" to "어센션섬",
    "AD" to "안도라",
    "AE" to "아랍에미리트",
    "AF" to "아프가니스탄",
    "AG" to "앤티가 바부다",
    "AI" to "앵귈라",
    "AL" to "알바니아",
    "AM" to "아르메니아",
    "AO" to "앙골라",
    "AQ" to "남극 대륙",
    "AR" to "아르헨티나",
    "AS" to "아메리칸 사모아",
    "AT" to "오스트리아",
    "AU" to "오스트레일리아",
    "AW" to "아루바",
    "AX" to "올란드 제도",
    "AZ" to "아제르바이잔",
    "BA" to "보스니아 헤르체고비나",
    "BB" to "바베이도스",
    "BD" to "방글라데시",
    "BE" to "벨기에",
    "BF" to "부르키나파소",
    "BG" to "불가리아",
    "BH" to "바레인",
    "BI" to "부룬디",
    "BJ" to "베냉",
    "BL" to "생바르텔레미",
    "BM" to "버뮤다",
    "BN" to "브루나이",
    "BO" to "볼리비아",
    "BQ" to "네덜란드령 카리브",
    "BR" to "브라질",
    "BS" to "바하마",
    "BT" to "부탄",
    "BV" to "부베섬",
    "BW" to "보츠와나",
    "BY" to "벨라루스",
    "BZ" to "벨리즈",
    "CA" to "캐나다",
    "CC" to "코코스 제도",
    "CD" to "콩고-킨샤사",
    "CF" to "중앙 아프리카 공화국",
    "CG" to "콩고-브라자빌",
    "CH" to "스위스",
    "CI" to "코트디부아르",
    "CK" to "쿡 제도",
    "CL" to "칠레",
    "CM" to "카메룬",
    "CN" to "중국",
    "CO" to "콜롬비아",
    "CP" to "클리퍼턴섬",
    "CR" to "코스타리카",
    "CU" to "쿠바",
    "CV" to "카보베르데",
    "CW" to "퀴라소",
    "CX" to "크리스마스섬",
    "CY" to "키프로스",
    "CZ" to "체코",
    "DE" to "독일",
    "DG" to "디에고 가르시아",
    "DJ" to "지부티",
    "DK" to "덴마크",
    "DM" to "도미니카",
    "DO" to "도미니카 공화국",
    "DZ" to "알제리",
    "EA" to "세우타 및 멜리야",
    "EC" to "에콰도르",
    "EE" to "에스토니아",
    "EG" to "이집트",
    "EH" to "서사하라",
    "ER" to "에리트리아",
    "ES" to "스페인",
    "ET" to "에티오피아",
    "EU" to "유럽 연합",
    "EZ" to "유로존",
    "FI" to "핀란드",
    "FJ" to "피지",
    "FK" to "포클랜드 제도",
    "FM" to "미크로네시아",
    "FO" to "페로 제도",
    "FR" to "프랑스",
    "GA" to "가봉",
    "GB" to "영국",
    "GD" to "그레나다",
    "GE" to "조지아",
    "GF" to "프랑스령 기아나",
    "GG" to "건지",
    "GH" to "가나",
    "GI" to "지브롤터",
    "GL" to "그린란드",
    "GM" to "감비아",
    "GN" to "기니",
    "GP" to "과들루프",
    "GQ" to "적도 기니",
    "GR" to "그리스",
    "GS" to "사우스조지아 사우스샌드위치 제도",
    "GT" to "과테말라",
    "GU" to "괌",
    "GW" to "기니비사우",
    "GY" to "가이아나",
    "HK" to "홍콩(중국 특별행정구)",
    "HM" to "허드 맥도널드 제도",
    "HN" to "온두라스",
    "HR" to "크로아티아",
    "HT" to "아이티",
    "HU" to "헝가리",
    "IC" to "카나리아 제도",
    "ID" to "인도네시아",
    "IE" to "아일랜드",
    "IL" to "이스라엘",
    "IM" to "맨섬",
    "IN" to "인도",
    "IO" to "영국령 인도양 지역",
    "IQ" to "이라크",
    "IR" to "이란",
    "IS" to "아이슬란드",
    "IT" to "이탈리아",
    "JE" to "저지",
    "JM" to "자메이카",
    "JO" to "요르단",
    "JP" to "일본",
    "KE" to "케냐",
    "KG" to "키르기스스탄",
    "KH" to "캄보디아",
    "KI" to "키리바시",
    "KM" to "코모로",
    "KN" to "세인트키츠 네비스",
    "KP" to "북한",
    "KR" to "대한민국",
    "KW" to "쿠웨이트",
    "KY" to "케이맨 제도",
    "KZ" to "카자흐스탄",
    "LA" to "라오스",
    "LB" to "레바논",
    "LC" to "세인트루시아",
    "LI" to "리히텐슈타인",
    "LK" to "스리랑카",
    "LR" to "라이베리아",
    "LS" to "레소토",
    "LT" to "리투아니아",
    "LU" to "룩셈부르크",
    "LV" to "라트비아",
    "LY" to "리비아",
    "MA" to "모로코",
    "MC" to "모나코",
    "MD" to "몰도바",
    "ME" to "몬테네그로",
    "MF" to "생마르탱",
    "MG" to "마다가스카르",
    "MH" to "마셜 제도",
    "MK" to "북마케도니아",
    "ML" to "말리",
    "MM" to "미얀마",
    "MN" to "몽골",
    "MO" to "마카오(중국 특별행정구)",
    "MP" to "북마리아나제도",
    "MQ" to "마르티니크",
    "MR" to "모리타니",
    "MS" to "몬트세라트",
    "MT" to "몰타",
    "MU" to "모리셔스",
    "MV" to "몰디브",
    "MW" to "말라위",
    "MX" to "멕시코",
    "MY" to "말레이시아",
    "MZ" to "모잠비크",
    "NA" to "나미비아",
    "NC" to "뉴칼레도니아",
    "NE" to "니제르",
    "NF" to "노퍽섬",
    "NG" to "나이지리아",
    "NI" to "니카라과",
    "NL" to "네덜란드",
    "NO" to "노르웨이",
    "NP" to "네팔",
    "NR" to "나우루",
    "NU" to "니우에",
    "NZ" to "뉴질랜드",
    "OM" to "오만",
    "PA" to "파나마",
    "PE" to "페루",
    "PF" to "프랑스령 폴리네시아",
    "PG" to "파푸아뉴기니",
    "PH" to "필리핀",
    "PK" to "파키스탄",
    "PL" to "폴란드",
    "PM" to "생피에르 미클롱",
    "PN" to "핏케언 제도",
    "PR" to "푸에르토리코",
    "PS" to "팔레스타인 지구",
    "PT" to "포르투갈",
    "PW" to "팔라우",
    "PY" to "파라과이",
    "QA" to "카타르",
    "QO" to "오세아니아 외곽",
    "RE" to "레위니옹",
    "RO" to "루마니아",
    "RS" to "세르비아",
    "RU" to "러시아",
    "RW" to "르완다",
    "SA" to "사우디아라비아",
    "SB" to "솔로몬 제도",
    "SC" to "세이셸",
    "SD" to "수단",
    "SE" to "스웨덴",
    "SG" to "싱가포르",
    "SH" to "세인트헬레나",
    "SI" to "슬로베니아",
    "SJ" to "스발바르제도-얀마웬섬",
    "SK" to "슬로바키아",
    "SL" to "시에라리온",
    "SM" to "산마리노",
    "SN" to "세네갈",
    "SO" to "소말리아",
    "SR" to "수리남",
    "SS" to "남수단",
    "ST" to "상투메 프린시페",
    "SV" to "엘살바도르",
    "SX" to "신트마르턴",
    "SY" to "시리아",
    "SZ" to "에스와티니",
    "TA" to "트리스탄다쿠나",
    "TC" to "터크스 케이커스 제도",
    "TD" to "차드",
    "TF" to "프랑스령 남방 지역",
    "TG" to "토고",
    "TH" to "태국",
    "TJ" to "타지키스탄",
    "TK" to "토켈라우",
    "TL" to "동티모르",
    "TM" to "투르크메니스탄",
    "TN" to "튀니지",
    "TO" to "통가",
    "TR" to "튀르키예",
    "TT" to "트리니다드 토바고",
    "TV" to "투발루",
    "TW" to "대만",
    "TZ" to "탄자니아",
    "UA" to "우크라이나",
    "UG" to "우간다",
    "UM" to "미국령 해외 제도",
    "UN" to "국제연합",
    "US" to "미국",
    "UY" to "우루과이",
    "UZ" to "우즈베키스탄",
    "VA" to "바티칸 시국",
    "VC" to "세인트빈센트그레나딘",
    "VE" to "베네수엘라",
    "VG" to "영국령 버진아일랜드",
    "VI" to "미국령 버진아일랜드",
    "VN" to "베트남",
    "VU" to "바누아투",
    "WF" to "왈리스-푸투나 제도",
    "WS" to "사모아",
    "XA" to "유사 억양",
    "XB" to "유사 양방향",
    "XK" to "코소보",
    "YE" to "예멘",
    "YT" to "마요트",
    "ZA" to "남아프리카",
    "ZM" to "잠비아",
    "ZW" to "짐바브웨",
    "ZZ" to "알려지지 않은 지역",
  ) }

  val ko_CN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ko_KP: ImmutableMap<String, String> by lazy { immutableMapOf(
    "KP" to "조선민주주의인민공화국",
  ) }

  val kok: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "जग",
    "002" to "आफ्रिका",
    "003" to "उत्तर अमेरिका",
    "005" to "दक्षिण अमेरिका",
    "009" to "ओसेनिया",
    "011" to "अस्तंत आफ्रिका",
    "013" to "मध्य अमेरिका",
    "014" to "उदेंत आफ्रिका",
    "015" to "उत्तरीय आफ्रिका",
    "017" to "मध्य आफ्रिका",
    "018" to "दक्षिण आफ्रिका",
    "019" to "अमेरिकास",
    "021" to "उत्तरीय अमेरिका",
    "029" to "कॅरिबियन",
    "030" to "उदेंत आशिया",
    "034" to "दक्षिण आशिया",
    "035" to "आग्नेय आशिया",
    "039" to "दक्षिण युरोप",
    "053" to "ऑस्ट्रेलेसिया",
    "054" to "मेलानेसिया",
    "057" to "मायक्रोनेशियन प्रांत",
    "061" to "पोलिनेशिया",
    "142" to "आशिया",
    "143" to "मध्य आशिया",
    "145" to "अस्तंत आशिया",
    "150" to "युरोप",
    "151" to "उदेंत युरोप",
    "154" to "उत्तर युरोप",
    "155" to "अस्तंत युरोप",
    "202" to "उप-सहाराई आफ्रिका",
    "419" to "लॅटीन अमेरिका",
    "AC" to "असेंशन आयलँड",
    "AD" to "अंडोरा",
    "AE" to "युनाइटेड अरब इमीरात",
    "AF" to "अफगानिस्तान",
    "AG" to "एँटिगुआ आनी बारबुडा",
    "AI" to "अंगुला",
    "AL" to "अल्बानीया",
    "AM" to "आर्मीनीया",
    "AO" to "अंगोला",
    "AQ" to "अंटार्क्टिका",
    "AR" to "अर्जेंटिना",
    "AS" to "अमेरिकी सामोआ",
    "AT" to "ऑस्ट्रिया",
    "AU" to "ऑस्ट्रेलीया",
    "AW" to "अरुबा",
    "AX" to "अलांड जुवे",
    "AZ" to "अजरबैजान",
    "BA" to "बोस्निया आनी हेर्जेगोविना",
    "BB" to "बारबाडोस",
    "BD" to "बांगलादेश",
    "BE" to "बेल्जियम",
    "BF" to "बुर्किना फॅसो",
    "BG" to "बल्गेरीया",
    "BH" to "बेहरेन",
    "BI" to "बुरुंडी",
    "BJ" to "बेनीन",
    "BL" to "सॅंट बार्थेल्मी",
    "BM" to "बर्मुडा",
    "BN" to "ब्रूनेई",
    "BO" to "बोलिव्हिया",
    "BQ" to "कॅरिबियन निदरलँड",
    "BR" to "ब्राझील",
    "BS" to "बहामास",
    "BT" to "भूतान",
    "BV" to "बोवट आयलँड",
    "BW" to "बोत्सवाना",
    "BY" to "बेलारूस",
    "BZ" to "बेलिझ",
    "CA" to "कॅनडा",
    "CC" to "कोकोस (कीलिंग) आयलँड",
    "CD" to "कोंगो - किंशासा",
    "CF" to "मध्य अफ्रीकी लोकसत्तकराज्य",
    "CG" to "कोंगो - ब्राझाविला",
    "CH" to "स्विट्ज़रलैंड",
    "CI" to "कोत द’ईवोआर",
    "CK" to "कुक आयलँड्स",
    "CL" to "चिली",
    "CM" to "कॅमेरून",
    "CN" to "चीन",
    "CO" to "कोलंबिया",
    "CP" to "क्लिपरटॉन आयलँड",
    "CR" to "कोस्ता रिका",
    "CU" to "क्युबा",
    "CV" to "केप वर्दी",
    "CW" to "कुरसावो",
    "CX" to "क्रिसमस आयलँड",
    "CY" to "सायप्रस",
    "CZ" to "चेकिया",
    "DE" to "जर्मनी",
    "DG" to "दिगो गार्सिया",
    "DJ" to "जिबूती",
    "DK" to "डेनमार्क",
    "DM" to "डोमिनीका",
    "DO" to "डोमिनिकन प्रजासत्ताक",
    "DZ" to "अल्जेरिया",
    "EA" to "सिटा आनी मेलिल्ला",
    "EC" to "इक्वाडोर",
    "EE" to "एस्टोनिया",
    "EG" to "ईजिप्त",
    "EH" to "अस्तंत सहारा",
    "ER" to "इरिट्रिया",
    "ES" to "स्पेन",
    "ET" to "इथियोपिया",
    "EU" to "युरोपियन युनियन",
    "EZ" to "युरोझोन",
    "FI" to "फिनलँड",
    "FJ" to "फिजी",
    "FK" to "फ़ॉकलैंड आइलैंड्स",
    "FM" to "मायक्रोनेशिया",
    "FO" to "फैरो आयलँड्स",
    "FR" to "फ्रान्स",
    "GA" to "गॅबोन",
    "GB" to "युनायटेड किंगडम",
    "GD" to "ग्रेनॅडा",
    "GE" to "जॉर्जिया",
    "GF" to "फ्रेन्च गयाना",
    "GG" to "गर्नसी",
    "GH" to "घाना",
    "GI" to "जिब्राल्टर",
    "GL" to "ग्रीनलँड",
    "GM" to "गॅम्बिया",
    "GN" to "गुएनिया",
    "GP" to "ग्वाडेलोप",
    "GQ" to "इक्वेटोरियल गुएनिया",
    "GR" to "ग्रीस",
    "GS" to "दक्षिण जोर्जिया आनी दक्षिण सॅण्डविच आयलँड्स",
    "GT" to "ग्वाटेमाला",
    "GU" to "गुआम",
    "GW" to "गुअनिया-बिसाउ",
    "GY" to "गयाना",
    "HK" to "हाँग काँग एसएआर चीन",
    "HM" to "हर्ड ऍंड मॅक्डोनाल्ड आयलँड्स",
    "HN" to "हॉनडुरस",
    "HR" to "क्रोयेशीया",
    "HT" to "हैती",
    "HU" to "हंगेरी",
    "IC" to "कॅनरी आयलैंड्स",
    "ID" to "इंडोनेशीया",
    "IE" to "आयरलँड",
    "IL" to "इस्त्राइल",
    "IM" to "इसले ऑफ मॅन",
    "IN" to "भारत",
    "IO" to "ब्रिटिश हिंद महासागरीय क्षेत्र",
    "IQ" to "इराक",
    "IR" to "इरान",
    "IS" to "आइसलैंड",
    "IT" to "इटली",
    "JE" to "जर्सी",
    "JM" to "जमैका",
    "JO" to "जॉर्डन",
    "JP" to "जपान",
    "KE" to "केनया",
    "KG" to "किर्गिझस्तान",
    "KH" to "कंबोडिया",
    "KI" to "किरिबाती",
    "KM" to "कोमोरोस",
    "KN" to "सेंट किट्स आनी नेविस",
    "KP" to "उत्तर कोरिया",
    "KR" to "दक्षिण कोरिया",
    "KW" to "कुवेत",
    "KY" to "कैमेन आइलैंड्स",
    "KZ" to "कझाकस्तान",
    "LA" to "लाओस",
    "LB" to "लेबनान",
    "LC" to "सँट लुसिया",
    "LI" to "लिचेंस्टीन",
    "LK" to "श्री लंका",
    "LR" to "लायबेरीया",
    "LS" to "लिसोथो",
    "LT" to "लिथुआनिया",
    "LU" to "लक्सेमबर्ग",
    "LV" to "लॅटविया",
    "LY" to "लीबिया",
    "MA" to "मोरोक्को",
    "MC" to "मोनॅको",
    "MD" to "माल्डोवा",
    "ME" to "मॉन्टॅनग्रो",
    "MF" to "सॅंट मार्टिन",
    "MG" to "माडागास्कर",
    "MH" to "मार्शल आयलँड्स",
    "MK" to "उत्तर मॅसिडोनिया",
    "ML" to "माली",
    "MM" to "म्यानमार (बर्मा)",
    "MN" to "मंगोलिया",
    "MO" to "मकाव एसएआर चीन",
    "MP" to "उत्तरी मरिना आयसलैण्ड",
    "MQ" to "मार्टीनिक",
    "MR" to "मॉरिटानिया",
    "MS" to "मॉन्टसेराट",
    "MT" to "माल्टा",
    "MU" to "मॉरिशस",
    "MV" to "मालदीव",
    "MW" to "मलावी",
    "MX" to "मेक्सिको",
    "MY" to "मलेशिया",
    "MZ" to "मॉझांबीक",
    "NA" to "नामीबिया",
    "NC" to "न्यू कॅलिडोनिया",
    "NE" to "नायजर",
    "NF" to "नॉरफॉक आयलँड",
    "NG" to "नायजेरिया",
    "NI" to "निकारगुवा",
    "NL" to "नॅदरलँड",
    "NO" to "नॉर्वे",
    "NP" to "नेपाळ",
    "NR" to "नावरू",
    "NU" to "नीयू",
    "NZ" to "न्युझीलॅन्ड",
    "OM" to "ओमान",
    "PA" to "पनामा",
    "PE" to "पेरू",
    "PF" to "फ्रेन्च पोलिनेसिया",
    "PG" to "पापुआ न्यु गिनी",
    "PH" to "फिलीपिन्झ",
    "PK" to "पाकिस्तान",
    "PL" to "पोलंड",
    "PM" to "सँ. पायरे आनी मिकेलन",
    "PN" to "पिटकॅरन आयलँड्स",
    "PR" to "प्युएर्तो रिको",
    "PS" to "पेलेस्टीनियन प्रांत",
    "PT" to "पुर्तगाल",
    "PW" to "पलाऊ",
    "PY" to "पैराग्वे",
    "QA" to "कतार",
    "QO" to "आवटलायींग ओशेनिया",
    "RE" to "रीयूनियन",
    "RO" to "रोमानीया",
    "RS" to "सर्बिया",
    "RU" to "रूस",
    "RW" to "रवांडा",
    "SA" to "सऊदी अरेबिया",
    "SB" to "सोलोमन आइलँड्स",
    "SC" to "सेशेल्स",
    "SD" to "सूडान",
    "SE" to "स्वीडन",
    "SG" to "सिंगापूर",
    "SH" to "सेंट हेलिना",
    "SI" to "स्लोवेनिया",
    "SJ" to "स्वालबार्ड आनी जान मेयन",
    "SK" to "स्लोवाकिया",
    "SL" to "सिएरा लियॉन",
    "SM" to "सॅन मारीनो",
    "SN" to "सिनिगल",
    "SO" to "सोमालिया",
    "SR" to "सुरीनाम",
    "SS" to "दक्षिण सुडान",
    "ST" to "साओ टोम आनी प्रिन्सिप",
    "SV" to "एल साल्वाडोर",
    "SX" to "सिंट मार्टेन",
    "SY" to "सिरिया",
    "SZ" to "इस्वातिनी",
    "TA" to "त्रिस्तान दा कुन्हा",
    "TC" to "तुर्क्स आनी कॅकोज आयलँड्स",
    "TD" to "चाड",
    "TF" to "फ्रेंच दक्षिणी प्रांत",
    "TG" to "टोगो",
    "TH" to "थायलँड",
    "TJ" to "तजीकिस्तान",
    "TK" to "टोकलाऊ",
    "TL" to "तिमोर-लेस्ते",
    "TM" to "तुर्कमेनिस्तान",
    "TN" to "ट्यूनीशिया",
    "TO" to "टोंगा",
    "TR" to "तुर्की",
    "TT" to "ट्रिनीदाद आनी टोबॅगो",
    "TV" to "टुवालू",
    "TW" to "तायवान",
    "TZ" to "तांझानिया",
    "UA" to "युक्रेन",
    "UG" to "युगांडा",
    "UM" to "यु. एस. मायनर आवटलायींग आयलँड्‍स",
    "UN" to "युनायटेड नेशन्स",
    "US" to "युनायटेड स्टेट्स",
    "UY" to "उरूग्वे",
    "UZ" to "उझ्बेकिस्तान",
    "VA" to "वॅटिकन सिटी",
    "VC" to "सेंट विंसेंट ऐंड द ग्रेनेडाइंस",
    "VE" to "विनेझुएला",
    "VG" to "ब्रिटिश वर्जिन आयलँड्स",
    "VI" to "यु. एस. वर्जिन आयलँड्‍स",
    "VN" to "व्हिएतनाम",
    "VU" to "वनौतू",
    "WF" to "वालिस आनी फ्यूचूना",
    "WS" to "सामोआ",
    "XA" to "स्युडो-ऍक्सेंट",
    "XB" to "स्युडो-बिडी",
    "XK" to "कोसोवो",
    "YE" to "येमेन",
    "YT" to "मेयोट",
    "ZA" to "दक्षिण आफ्रीका",
    "ZM" to "झांबिया",
    "ZW" to "जिम्बाब्वे",
    "ZZ" to "अज्ञात प्रांत",
  ) }

  val kok_Deva: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "जग",
    "002" to "आफ्रिका",
    "003" to "उत्तर अमेरिका",
    "005" to "दक्षिण अमेरिका",
    "009" to "ओसेनिया",
    "011" to "अस्तंत आफ्रिका",
    "013" to "मध्य अमेरिका",
    "014" to "उदेंत आफ्रिका",
    "015" to "उत्तरीय आफ्रिका",
    "017" to "मध्य आफ्रिका",
    "018" to "दक्षिण आफ्रिका",
    "019" to "अमेरिकास",
    "021" to "उत्तरीय अमेरिका",
    "029" to "कॅरिबियन",
    "030" to "उदेंत आशिया",
    "034" to "दक्षिण आशिया",
    "035" to "आग्नेय आशिया",
    "039" to "दक्षिण युरोप",
    "053" to "ऑस्ट्रेलेसिया",
    "054" to "मेलानेसिया",
    "057" to "मायक्रोनेशियन प्रांत",
    "061" to "पोलिनेशिया",
    "142" to "आशिया",
    "143" to "मध्य आशिया",
    "145" to "अस्तंत आशिया",
    "150" to "युरोप",
    "151" to "उदेंत युरोप",
    "154" to "उत्तर युरोप",
    "155" to "अस्तंत युरोप",
    "202" to "उप-सहाराई आफ्रिका",
    "419" to "लॅटीन अमेरिका",
    "AC" to "असेंशन आयलँड",
    "AD" to "अंडोरा",
    "AE" to "युनाइटेड अरब इमीरात",
    "AF" to "अफगानिस्तान",
    "AG" to "एँटिगुआ आनी बारबुडा",
    "AI" to "अंगुला",
    "AL" to "अल्बानीया",
    "AM" to "आर्मीनीया",
    "AO" to "अंगोला",
    "AQ" to "अंटार्क्टिका",
    "AR" to "अर्जेंटिना",
    "AS" to "अमेरिकी सामोआ",
    "AT" to "ऑस्ट्रिया",
    "AU" to "ऑस्ट्रेलीया",
    "AW" to "अरुबा",
    "AX" to "अलांड जुवे",
    "AZ" to "अजरबैजान",
    "BA" to "बोस्निया आनी हेर्जेगोविना",
    "BB" to "बारबाडोस",
    "BD" to "बांगलादेश",
    "BE" to "बेल्जियम",
    "BF" to "बुर्किना फॅसो",
    "BG" to "बल्गेरीया",
    "BH" to "बेहरेन",
    "BI" to "बुरुंडी",
    "BJ" to "बेनीन",
    "BL" to "सॅंट बार्थेल्मी",
    "BM" to "बर्मुडा",
    "BN" to "ब्रूनेई",
    "BO" to "बोलिव्हिया",
    "BQ" to "कॅरिबियन निदरलँड",
    "BR" to "ब्राझील",
    "BS" to "बहामास",
    "BT" to "भूतान",
    "BV" to "बोवट आयलँड",
    "BW" to "बोत्सवाना",
    "BY" to "बेलारूस",
    "BZ" to "बेलिझ",
    "CA" to "कॅनडा",
    "CC" to "कोकोस (कीलिंग) आयलँड",
    "CD" to "कोंगो - किंशासा",
    "CF" to "मध्य अफ्रीकी लोकसत्तकराज्य",
    "CG" to "कोंगो - ब्राझाविला",
    "CH" to "स्विट्ज़रलैंड",
    "CI" to "कोत द’ईवोआर",
    "CK" to "कुक आयलँड्स",
    "CL" to "चिली",
    "CM" to "कॅमेरून",
    "CN" to "चीन",
    "CO" to "कोलंबिया",
    "CP" to "क्लिपरटॉन आयलँड",
    "CR" to "कोस्ता रिका",
    "CU" to "क्युबा",
    "CV" to "केप वर्दी",
    "CW" to "कुरसावो",
    "CX" to "क्रिसमस आयलँड",
    "CY" to "सायप्रस",
    "CZ" to "चेकिया",
    "DE" to "जर्मनी",
    "DG" to "दिगो गार्सिया",
    "DJ" to "जिबूती",
    "DK" to "डेनमार्क",
    "DM" to "डोमिनीका",
    "DO" to "डोमिनिकन प्रजासत्ताक",
    "DZ" to "अल्जेरिया",
    "EA" to "सिटा आनी मेलिल्ला",
    "EC" to "इक्वाडोर",
    "EE" to "एस्टोनिया",
    "EG" to "ईजिप्त",
    "EH" to "अस्तंत सहारा",
    "ER" to "इरिट्रिया",
    "ES" to "स्पेन",
    "ET" to "इथियोपिया",
    "EU" to "युरोपियन युनियन",
    "EZ" to "युरोझोन",
    "FI" to "फिनलँड",
    "FJ" to "फिजी",
    "FK" to "फ़ॉकलैंड आइलैंड्स",
    "FM" to "मायक्रोनेशिया",
    "FO" to "फैरो आयलँड्स",
    "FR" to "फ्रान्स",
    "GA" to "गॅबोन",
    "GB" to "युनायटेड किंगडम",
    "GD" to "ग्रेनॅडा",
    "GE" to "जॉर्जिया",
    "GF" to "फ्रेन्च गयाना",
    "GG" to "गर्नसी",
    "GH" to "घाना",
    "GI" to "जिब्राल्टर",
    "GL" to "ग्रीनलँड",
    "GM" to "गॅम्बिया",
    "GN" to "गुएनिया",
    "GP" to "ग्वाडेलोप",
    "GQ" to "इक्वेटोरियल गुएनिया",
    "GR" to "ग्रीस",
    "GS" to "दक्षिण जोर्जिया आनी दक्षिण सॅण्डविच आयलँड्स",
    "GT" to "ग्वाटेमाला",
    "GU" to "गुआम",
    "GW" to "गुअनिया-बिसाउ",
    "GY" to "गयाना",
    "HK" to "हाँग काँग एसएआर चीन",
    "HM" to "हर्ड ऍंड मॅक्डोनाल्ड आयलँड्स",
    "HN" to "हॉनडुरस",
    "HR" to "क्रोयेशीया",
    "HT" to "हैती",
    "HU" to "हंगेरी",
    "IC" to "कॅनरी आयलैंड्स",
    "ID" to "इंडोनेशीया",
    "IE" to "आयरलँड",
    "IL" to "इस्त्राइल",
    "IM" to "इसले ऑफ मॅन",
    "IN" to "भारत",
    "IO" to "ब्रिटिश हिंद महासागरीय क्षेत्र",
    "IQ" to "इराक",
    "IR" to "इरान",
    "IS" to "आइसलैंड",
    "IT" to "इटली",
    "JE" to "जर्सी",
    "JM" to "जमैका",
    "JO" to "जॉर्डन",
    "JP" to "जपान",
    "KE" to "केनया",
    "KG" to "किर्गिझस्तान",
    "KH" to "कंबोडिया",
    "KI" to "किरिबाती",
    "KM" to "कोमोरोस",
    "KN" to "सेंट किट्स आनी नेविस",
    "KP" to "उत्तर कोरिया",
    "KR" to "दक्षिण कोरिया",
    "KW" to "कुवेत",
    "KY" to "कैमेन आइलैंड्स",
    "KZ" to "कझाकस्तान",
    "LA" to "लाओस",
    "LB" to "लेबनान",
    "LC" to "सँट लुसिया",
    "LI" to "लिचेंस्टीन",
    "LK" to "श्री लंका",
    "LR" to "लायबेरीया",
    "LS" to "लिसोथो",
    "LT" to "लिथुआनिया",
    "LU" to "लक्सेमबर्ग",
    "LV" to "लॅटविया",
    "LY" to "लीबिया",
    "MA" to "मोरोक्को",
    "MC" to "मोनॅको",
    "MD" to "माल्डोवा",
    "ME" to "मॉन्टॅनग्रो",
    "MF" to "सॅंट मार्टिन",
    "MG" to "माडागास्कर",
    "MH" to "मार्शल आयलँड्स",
    "MK" to "उत्तर मॅसिडोनिया",
    "ML" to "माली",
    "MM" to "म्यानमार (बर्मा)",
    "MN" to "मंगोलिया",
    "MO" to "मकाव एसएआर चीन",
    "MP" to "उत्तरी मरिना आयसलैण्ड",
    "MQ" to "मार्टीनिक",
    "MR" to "मॉरिटानिया",
    "MS" to "मॉन्टसेराट",
    "MT" to "माल्टा",
    "MU" to "मॉरिशस",
    "MV" to "मालदीव",
    "MW" to "मलावी",
    "MX" to "मेक्सिको",
    "MY" to "मलेशिया",
    "MZ" to "मॉझांबीक",
    "NA" to "नामीबिया",
    "NC" to "न्यू कॅलिडोनिया",
    "NE" to "नायजर",
    "NF" to "नॉरफॉक आयलँड",
    "NG" to "नायजेरिया",
    "NI" to "निकारगुवा",
    "NL" to "नॅदरलँड",
    "NO" to "नॉर्वे",
    "NP" to "नेपाळ",
    "NR" to "नावरू",
    "NU" to "नीयू",
    "NZ" to "न्युझीलॅन्ड",
    "OM" to "ओमान",
    "PA" to "पनामा",
    "PE" to "पेरू",
    "PF" to "फ्रेन्च पोलिनेसिया",
    "PG" to "पापुआ न्यु गिनी",
    "PH" to "फिलीपिन्झ",
    "PK" to "पाकिस्तान",
    "PL" to "पोलंड",
    "PM" to "सँ. पायरे आनी मिकेलन",
    "PN" to "पिटकॅरन आयलँड्स",
    "PR" to "प्युएर्तो रिको",
    "PS" to "पेलेस्टीनियन प्रांत",
    "PT" to "पुर्तगाल",
    "PW" to "पलाऊ",
    "PY" to "पैराग्वे",
    "QA" to "कतार",
    "QO" to "आवटलायींग ओशेनिया",
    "RE" to "रीयूनियन",
    "RO" to "रोमानीया",
    "RS" to "सर्बिया",
    "RU" to "रूस",
    "RW" to "रवांडा",
    "SA" to "सऊदी अरेबिया",
    "SB" to "सोलोमन आइलँड्स",
    "SC" to "सेशेल्स",
    "SD" to "सूडान",
    "SE" to "स्वीडन",
    "SG" to "सिंगापूर",
    "SH" to "सेंट हेलिना",
    "SI" to "स्लोवेनिया",
    "SJ" to "स्वालबार्ड आनी जान मेयन",
    "SK" to "स्लोवाकिया",
    "SL" to "सिएरा लियॉन",
    "SM" to "सॅन मारीनो",
    "SN" to "सिनिगल",
    "SO" to "सोमालिया",
    "SR" to "सुरीनाम",
    "SS" to "दक्षिण सुडान",
    "ST" to "साओ टोम आनी प्रिन्सिप",
    "SV" to "एल साल्वाडोर",
    "SX" to "सिंट मार्टेन",
    "SY" to "सिरिया",
    "SZ" to "इस्वातिनी",
    "TA" to "त्रिस्तान दा कुन्हा",
    "TC" to "तुर्क्स आनी कॅकोज आयलँड्स",
    "TD" to "चाड",
    "TF" to "फ्रेंच दक्षिणी प्रांत",
    "TG" to "टोगो",
    "TH" to "थायलँड",
    "TJ" to "तजीकिस्तान",
    "TK" to "टोकलाऊ",
    "TL" to "तिमोर-लेस्ते",
    "TM" to "तुर्कमेनिस्तान",
    "TN" to "ट्यूनीशिया",
    "TO" to "टोंगा",
    "TR" to "तुर्की",
    "TT" to "ट्रिनीदाद आनी टोबॅगो",
    "TV" to "टुवालू",
    "TW" to "तायवान",
    "TZ" to "तांझानिया",
    "UA" to "युक्रेन",
    "UG" to "युगांडा",
    "UM" to "यु. एस. मायनर आवटलायींग आयलँड्‍स",
    "UN" to "युनायटेड नेशन्स",
    "US" to "युनायटेड स्टेट्स",
    "UY" to "उरूग्वे",
    "UZ" to "उझ्बेकिस्तान",
    "VA" to "वॅटिकन सिटी",
    "VC" to "सेंट विंसेंट ऐंड द ग्रेनेडाइंस",
    "VE" to "विनेझुएला",
    "VG" to "ब्रिटिश वर्जिन आयलँड्स",
    "VI" to "यु. एस. वर्जिन आयलँड्‍स",
    "VN" to "व्हिएतनाम",
    "VU" to "वनौतू",
    "WF" to "वालिस आनी फ्यूचूना",
    "WS" to "सामोआ",
    "XA" to "स्युडो-ऍक्सेंट",
    "XB" to "स्युडो-बिडी",
    "XK" to "कोसोवो",
    "YE" to "येमेन",
    "YT" to "मेयोट",
    "ZA" to "दक्षिण आफ्रीका",
    "ZM" to "झांबिया",
    "ZW" to "जिम्बाब्वे",
    "ZZ" to "अज्ञात प्रांत",
  ) }

  val kok_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "CN" to "Chin",
    "CY" to "Siprus",
    "DE" to "Jermon",
    "EG" to "Ejipt",
    "ES" to "Ispania",
    "FR" to "Frans",
    "GR" to "Gres",
    "IN" to "Bharot",
    "IT" to "Italia",
    "LY" to "Libia",
    "MK" to "Ut’tor Masedonia",
    "RU" to "Roxya",
  ) }

  val ks: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "دُنیا",
    "002" to "اَفریٖکا",
    "003" to "شُمٲلی اَمریٖکا",
    "005" to "جَنوٗنی اَمرٖیٖکا",
    "009" to "اوشَنیا",
    "011" to "مَغریٖبی اَفریٖکا",
    "013" to "مرکٔزی اَمریٖکا",
    "014" to "مَشرِقی اَفریٖکا",
    "015" to "شُمٲلی اَفریٖکا",
    "017" to "وسطی اَفریٖکا",
    "018" to "جنوٗبی اَفریٖکا",
    "019" to "اَمریٖکَس",
    "021" to "شُمٲلی اَمریٖکا خٕطہٕ",
    "029" to "کَرِببیٖن",
    "030" to "مَشرِقی ایشیا",
    "034" to "جنوٗبی ایشیا",
    "035" to "جنوٗبہِ مَشرِقی ایشیا",
    "039" to "جنوٗبی یوٗرَپ",
    "053" to "آسٹریلیشیا",
    "054" to "مؠلَنیٖشِیا",
    "057" to "مَیکرونَیشِیَن خٕطہٕ",
    "061" to "پالنیشِیا",
    "142" to "ایشیا",
    "143" to "مرکٔزی ایشیا",
    "145" to "مَغرِبی ایشیا",
    "150" to "یوٗرَپ",
    "151" to "مشرِقی یوٗرَپ",
    "154" to "شُمٲلی یوٗرَپ",
    "155" to "مغرِبی یوٗرَپ",
    "202" to "ذیلی سہارن افریقہ",
    "419" to "لاطیٖنی اَمریٖکا",
    "AC" to "ایسنشن جزیرٕ",
    "AD" to "اینڈورا",
    "AE" to "مُتحدہ عرَب امارات",
    "AF" to "اَفغانَستان",
    "AG" to "اؠنٹِگُوا تہٕ باربوڑا",
    "AI" to "انگوئیلا",
    "AL" to "البانیا",
    "AM" to "اَرمانِیا",
    "AO" to "انگولا",
    "AQ" to "اینٹارٹِکا",
    "AR" to "أرجَنٹینا",
    "AS" to "اَمریٖکَن سَموا",
    "AT" to "آسٹریا",
    "AU" to "آسٹریلِیا",
    "AW" to "اَروٗبا",
    "AX" to "ایلینڑ جٔزیٖرٕ",
    "AZ" to "آذربائیجان",
    "BA" to "بوسنِیا تہٕ ہَرزِگووِنا",
    "BB" to "باربیڈوس",
    "BD" to "بَنگلادیش",
    "BE" to "بیلجِیَم",
    "BF" to "بُرکِنا فیسو",
    "BG" to "بَلجیرِیا",
    "BH" to "بحریٖن",
    "BI" to "بورَنڈِ",
    "BJ" to "بِنِن",
    "BL" to "سینٹ بارتَھیلمی",
    "BM" to "برمودا",
    "BN" to "برونے",
    "BO" to "بولِوِیا",
    "BQ" to "کیریبین نیدرلینڈس",
    "BR" to "برازِل",
    "BS" to "بَہامَس",
    "BT" to "بوٗٹان",
    "BV" to "بووَٹ جٔزیٖرٕ",
    "BW" to "بوتَسوانا",
    "BY" to "بیلاروٗس",
    "BZ" to "بیلز",
    "CA" to "کینیڈا",
    "CC" to "کوکَس (کیٖلِنگ) جٔزیٖرٕ",
    "CD" to "کونگو کِنشاسا",
    "CF" to "مرکٔزی اَفریٖکی جموٗریَت",
    "CG" to "کونگو بٔرزاوِلی",
    "CH" to "سُوِزَرلینڑ",
    "CI" to "کوٹ ڈلوائر",
    "CK" to "کُک جٔزیٖرٕ",
    "CL" to "چِلی",
    "CM" to "کیمِروٗن",
    "CN" to "چیٖن",
    "CO" to "کولَمبِیا",
    "CP" to "کلیپرٹن جزیرٕ",
    "CR" to "کوسٹا ریکا",
    "CU" to "کیوٗبا",
    "CV" to "کیپ ؤرڑی",
    "CW" to "کیوراکو",
    "CX" to "کرِسمَس جٔزیٖرٕ",
    "CY" to "سائپرس",
    "CZ" to "چیکیا",
    "DE" to "جرمٔنی",
    "DG" to "ڈیگو گریشیا",
    "DJ" to "جِبوٗتی",
    "DK" to "ڈینمارٕک",
    "DM" to "ڈومِنِکا",
    "DO" to "ڈومِنِکَن جموٗرِیَت",
    "DZ" to "اؠلجیرِیا",
    "EA" to "سیوٹا تٕہ مٔلیلا",
    "EC" to "اِکواڑور",
    "EE" to "ایسٹونِیا",
    "EG" to "مصر",
    "EH" to "مشرِقی سَہارا",
    "ER" to "اِرٕٹِیا",
    "ES" to "سٕپین",
    "ET" to "اِتھوپِیا",
    "EU" to "یوٗرپی یونین",
    "EZ" to "یوٗرو زون",
    "FI" to "فِن لینڈ",
    "FJ" to "فِجی",
    "FK" to "فٕلاکلینڑ جٔزیٖرٕ",
    "FM" to "مائیکرونیشیا",
    "FO" to "فارو جزیرہ",
    "FR" to "فرانس",
    "GA" to "گیبان",
    "GB" to "متحدہ مملِکت",
    "GD" to "گرینیڈا",
    "GE" to "جارجِیا",
    "GF" to "فرانسِسی گِانا",
    "GG" to "گورنسے",
    "GH" to "گانا",
    "GI" to "جِبرالٹَر",
    "GL" to "گرین لینڈ",
    "GM" to "گَمبِیا",
    "GN" to "گِنی",
    "GP" to "گواڈلوپ",
    "GQ" to "اِکوِٹورِیَل گِنی",
    "GR" to "گریٖس",
    "GS" to "جنوٗبی جارجِیا تہٕ جنوٗبی سینڑوٕچ جٔزیٖرٕ",
    "GT" to "گواٹمالا",
    "GU" to "گُوام",
    "GW" to "گیٖنی بِساو",
    "GY" to "گُیانا",
    "HK" to "ہانگ کانگ ایس اے آر چیٖن",
    "HM" to "ہَرٕڑ تہٕ مؠکڈونالڑٕ جٔزیٖرٕ",
    "HN" to "ہونڈورس",
    "HR" to "کروشِیا",
    "HT" to "ہیتی",
    "HU" to "ہَنگری",
    "IC" to "کینری جزیرٕ",
    "ID" to "انڈونیشیا",
    "IE" to "اَیَرلینڑ",
    "IL" to "اسرا ییل",
    "IM" to "آیِل آف مین",
    "IN" to "ہِندوستان",
    "IQ" to "ایٖراق",
    "IR" to "ایٖران",
    "IS" to "اَیِسلینڑ",
    "IT" to "اِٹلی",
    "JE" to "جٔرسی",
    "JM" to "جَمایکا",
    "JO" to "جورڈن",
    "JP" to "جاپان",
    "KE" to "کِنیا",
    "KG" to "کرغزستان",
    "KH" to "کَمبوڑِیا",
    "KI" to "کِرٕباتی",
    "KM" to "کَمورَس",
    "KN" to "سینٹ کِٹَس تہٕ نیوِس",
    "KP" to "شُمٲلی کورِیا",
    "KR" to "جنوٗبی کورِیا",
    "KW" to "کُویت",
    "KY" to "کیمَن جٔزیٖرٕ",
    "KZ" to "قازقستان",
    "LA" to "لاس",
    "LB" to "لؠبنان",
    "LC" to "سینٹ لوٗسِیا",
    "LI" to "لِکٹیسٹیٖن",
    "LK" to "سری لنکا",
    "LR" to "لایبیرِیا",
    "LS" to "لیسوتھو",
    "LT" to "لِتھُوانِیا",
    "LU" to "لَکسَمبٔرٕگ",
    "LV" to "لیٹوِیا",
    "LY" to "لِبیا",
    "MA" to "موروکو",
    "MC" to "مونیکو",
    "MD" to "مولڈووا",
    "ME" to "موٹونیگِریو",
    "MF" to "سینٹ مارٹِن",
    "MG" to "میڈاگاسکار",
    "MH" to "مارشَل جٔزیٖرٕ",
    "MK" to "شُمالی میسڈونیا",
    "ML" to "مالی",
    "MM" to "میانمار (برما)",
    "MN" to "مَنگولِیا",
    "MO" to "مَکاوو ایس اے آر چیٖن",
    "MP" to "شُمٲلی مارِیانا جٔزیٖرٕ",
    "MQ" to "مارٹِنِک",
    "MR" to "مارٕٹانِیا",
    "MS" to "مانٹسیراٹ",
    "MT" to "مالٹا",
    "MU" to "مورِشَس",
    "MV" to "مالدیٖو",
    "MW" to "ملاوی",
    "MX" to "مؠکسِکو",
    "MY" to "مَلیشِیا",
    "MZ" to "موزَمبِک",
    "NA" to "نامِبِیا",
    "NC" to "نِو کیلِڑونِیا",
    "NE" to "نایجَر",
    "NF" to "نارفاک جٔزیٖرٕ",
    "NG" to "نایجیرِیا",
    "NI" to "ناکاراگُوا",
    "NL" to "نیٖدَرلینڑ",
    "NO" to "ناروے",
    "NP" to "نیپال",
    "NR" to "نارووٗ",
    "NU" to "نیوٗ",
    "NZ" to "نیوزی لینڈ",
    "OM" to "اومان",
    "PA" to "پَناما",
    "PE" to "پیٖروٗ",
    "PF" to "فرانسی پولِنیشِیا",
    "PG" to "پاپُوا نیوٗ گیٖنی",
    "PH" to "فلپائن",
    "PK" to "پاکِستان",
    "PL" to "پولینڈ",
    "PM" to "سینٹ پیٖری تہٕ موکیلِیَن",
    "PN" to "پِٹکیرٕنؠ جٔزیٖرٕ",
    "PR" to "پٔرٹو رِکو",
    "PS" to "فلسطینی علاقٕہ",
    "PT" to "پُرتِگال",
    "PW" to "پَلاو",
    "PY" to "پَراگُے",
    "QA" to "قَطِر",
    "QO" to "آوُٹلاینِگ اوشینِیا",
    "RE" to "رِیوٗنِیَن",
    "RO" to "رومانِیا",
    "RS" to "سَربِیا",
    "RU" to "روٗس",
    "RW" to "روٗوانڈا",
    "SA" to "سعودی عرب",
    "SB" to "سولامان جٔزیٖرٕ",
    "SC" to "سیشَلِس",
    "SD" to "سوٗڈان",
    "SE" to "سویڈن",
    "SG" to "سِنگاپوٗر",
    "SH" to "سینٹ ہؠلِنا",
    "SI" to "سَلووینِیا",
    "SJ" to "سَوالبریڑ تہٕ جان ماییڑ",
    "SK" to "سَلوواکِیا",
    "SL" to "سیرا لیون",
    "SM" to "سین میرِنو",
    "SN" to "سینیگَل",
    "SO" to "سومالِیا",
    "SR" to "سُرِنام",
    "SS" to "جنوبی سوڈان",
    "ST" to "ساو توم تہٕ پرنسِپی",
    "SV" to "ایل سلویڈر",
    "SX" to "سِنٹ مارٹِن",
    "SY" to "شام",
    "SZ" to "ایسواتنی",
    "TA" to "ٹریسٹن ڈا کنہا",
    "TC" to "تُرکس تٕہ کیکو جزیرٕ",
    "TD" to "چاڑ",
    "TF" to "فرانسِسی جَنوٗبی عَلاقہٕ",
    "TG" to "ٹوگو",
    "TH" to "تھائی لینڈ",
    "TJ" to "تاجکِستان",
    "TK" to "ٹوکلو",
    "TL" to "تیمور-لیسٹ",
    "TM" to "تُرکمنستان",
    "TN" to "ٹونیشِیا",
    "TO" to "ٹونگا",
    "TR" to "تُرکی",
    "TT" to "ٹرنِنداد تہٕ ٹوبیگو",
    "TV" to "توٗوالوٗ",
    "TW" to "تایوان",
    "TZ" to "تَنجانِیا",
    "UA" to "یوٗرِکین",
    "UG" to "یوٗگانڑا",
    "UM" to "یوٗنایٹِڑ سِٹیٹِس ماینَر آوُٹلییِنگ جٔزیٖرٕ",
    "UN" to "متحدہ مُمٲلک",
    "US" to "یوٗنایٹِڑ سِٹیٹِس",
    "UY" to "یوٗروگے",
    "UZ" to "اُزبِکِستان",
    "VA" to "ویٹِکَن سِٹی",
    "VC" to "سینٹ وینسؠٹ تہٕ گریناڑاینٕز",
    "VE" to "وینازوٗلا",
    "VG" to "بَرطانوی ؤرجِن جٔزیٖرٕ",
    "VI" to "یوٗ ایس ؤرجِن جٔزیٖرٕ",
    "VN" to "ویتنام",
    "VU" to "وانوٗتوٗ",
    "WF" to "والِس تہٕ فیوٗچوٗنا",
    "WS" to "سامو",
    "XA" to "سوڈو-ایسنٹس",
    "XB" to "سوڈو-بیڈی",
    "XK" to "کوسوو",
    "YE" to "یَمَن",
    "YT" to "مَییٹ",
    "ZA" to "جنوبی افریقہ",
    "ZM" to "زیمبیا",
    "ZW" to "زِمبابے",
    "ZZ" to "نامولوٗم علاقٕہ",
  ) }

  val ks_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "دُنیا",
    "002" to "اَفریٖکا",
    "003" to "شُمٲلی اَمریٖکا",
    "005" to "جَنوٗنی اَمرٖیٖکا",
    "009" to "اوشَنیا",
    "011" to "مَغریٖبی اَفریٖکا",
    "013" to "مرکٔزی اَمریٖکا",
    "014" to "مَشرِقی اَفریٖکا",
    "015" to "شُمٲلی اَفریٖکا",
    "017" to "وسطی اَفریٖکا",
    "018" to "جنوٗبی اَفریٖکا",
    "019" to "اَمریٖکَس",
    "021" to "شُمٲلی اَمریٖکا خٕطہٕ",
    "029" to "کَرِببیٖن",
    "030" to "مَشرِقی ایشیا",
    "034" to "جنوٗبی ایشیا",
    "035" to "جنوٗبہِ مَشرِقی ایشیا",
    "039" to "جنوٗبی یوٗرَپ",
    "053" to "آسٹریلیشیا",
    "054" to "مؠلَنیٖشِیا",
    "057" to "مَیکرونَیشِیَن خٕطہٕ",
    "061" to "پالنیشِیا",
    "142" to "ایشیا",
    "143" to "مرکٔزی ایشیا",
    "145" to "مَغرِبی ایشیا",
    "150" to "یوٗرَپ",
    "151" to "مشرِقی یوٗرَپ",
    "154" to "شُمٲلی یوٗرَپ",
    "155" to "مغرِبی یوٗرَپ",
    "202" to "ذیلی سہارن افریقہ",
    "419" to "لاطیٖنی اَمریٖکا",
    "AC" to "ایسنشن جزیرٕ",
    "AD" to "اینڈورا",
    "AE" to "مُتحدہ عرَب امارات",
    "AF" to "اَفغانَستان",
    "AG" to "اؠنٹِگُوا تہٕ باربوڑا",
    "AI" to "انگوئیلا",
    "AL" to "البانیا",
    "AM" to "اَرمانِیا",
    "AO" to "انگولا",
    "AQ" to "اینٹارٹِکا",
    "AR" to "أرجَنٹینا",
    "AS" to "اَمریٖکَن سَموا",
    "AT" to "آسٹریا",
    "AU" to "آسٹریلِیا",
    "AW" to "اَروٗبا",
    "AX" to "ایلینڑ جٔزیٖرٕ",
    "AZ" to "آذربائیجان",
    "BA" to "بوسنِیا تہٕ ہَرزِگووِنا",
    "BB" to "باربیڈوس",
    "BD" to "بَنگلادیش",
    "BE" to "بیلجِیَم",
    "BF" to "بُرکِنا فیسو",
    "BG" to "بَلجیرِیا",
    "BH" to "بحریٖن",
    "BI" to "بورَنڈِ",
    "BJ" to "بِنِن",
    "BL" to "سینٹ بارتَھیلمی",
    "BM" to "برمودا",
    "BN" to "برونے",
    "BO" to "بولِوِیا",
    "BQ" to "کیریبین نیدرلینڈس",
    "BR" to "برازِل",
    "BS" to "بَہامَس",
    "BT" to "بوٗٹان",
    "BV" to "بووَٹ جٔزیٖرٕ",
    "BW" to "بوتَسوانا",
    "BY" to "بیلاروٗس",
    "BZ" to "بیلز",
    "CA" to "کینیڈا",
    "CC" to "کوکَس (کیٖلِنگ) جٔزیٖرٕ",
    "CD" to "کونگو کِنشاسا",
    "CF" to "مرکٔزی اَفریٖکی جموٗریَت",
    "CG" to "کونگو بٔرزاوِلی",
    "CH" to "سُوِزَرلینڑ",
    "CI" to "کوٹ ڈلوائر",
    "CK" to "کُک جٔزیٖرٕ",
    "CL" to "چِلی",
    "CM" to "کیمِروٗن",
    "CN" to "چیٖن",
    "CO" to "کولَمبِیا",
    "CP" to "کلیپرٹن جزیرٕ",
    "CR" to "کوسٹا ریکا",
    "CU" to "کیوٗبا",
    "CV" to "کیپ ؤرڑی",
    "CW" to "کیوراکو",
    "CX" to "کرِسمَس جٔزیٖرٕ",
    "CY" to "سائپرس",
    "CZ" to "چیکیا",
    "DE" to "جرمٔنی",
    "DG" to "ڈیگو گریشیا",
    "DJ" to "جِبوٗتی",
    "DK" to "ڈینمارٕک",
    "DM" to "ڈومِنِکا",
    "DO" to "ڈومِنِکَن جموٗرِیَت",
    "DZ" to "اؠلجیرِیا",
    "EA" to "سیوٹا تٕہ مٔلیلا",
    "EC" to "اِکواڑور",
    "EE" to "ایسٹونِیا",
    "EG" to "مصر",
    "EH" to "مشرِقی سَہارا",
    "ER" to "اِرٕٹِیا",
    "ES" to "سٕپین",
    "ET" to "اِتھوپِیا",
    "EU" to "یوٗرپی یونین",
    "EZ" to "یوٗرو زون",
    "FI" to "فِن لینڈ",
    "FJ" to "فِجی",
    "FK" to "فٕلاکلینڑ جٔزیٖرٕ",
    "FM" to "مائیکرونیشیا",
    "FO" to "فارو جزیرہ",
    "FR" to "فرانس",
    "GA" to "گیبان",
    "GB" to "متحدہ مملِکت",
    "GD" to "گرینیڈا",
    "GE" to "جارجِیا",
    "GF" to "فرانسِسی گِانا",
    "GG" to "گورنسے",
    "GH" to "گانا",
    "GI" to "جِبرالٹَر",
    "GL" to "گرین لینڈ",
    "GM" to "گَمبِیا",
    "GN" to "گِنی",
    "GP" to "گواڈلوپ",
    "GQ" to "اِکوِٹورِیَل گِنی",
    "GR" to "گریٖس",
    "GS" to "جنوٗبی جارجِیا تہٕ جنوٗبی سینڑوٕچ جٔزیٖرٕ",
    "GT" to "گواٹمالا",
    "GU" to "گُوام",
    "GW" to "گیٖنی بِساو",
    "GY" to "گُیانا",
    "HK" to "ہانگ کانگ ایس اے آر چیٖن",
    "HM" to "ہَرٕڑ تہٕ مؠکڈونالڑٕ جٔزیٖرٕ",
    "HN" to "ہونڈورس",
    "HR" to "کروشِیا",
    "HT" to "ہیتی",
    "HU" to "ہَنگری",
    "IC" to "کینری جزیرٕ",
    "ID" to "انڈونیشیا",
    "IE" to "اَیَرلینڑ",
    "IL" to "اسرا ییل",
    "IM" to "آیِل آف مین",
    "IN" to "ہِندوستان",
    "IQ" to "ایٖراق",
    "IR" to "ایٖران",
    "IS" to "اَیِسلینڑ",
    "IT" to "اِٹلی",
    "JE" to "جٔرسی",
    "JM" to "جَمایکا",
    "JO" to "جورڈن",
    "JP" to "جاپان",
    "KE" to "کِنیا",
    "KG" to "کرغزستان",
    "KH" to "کَمبوڑِیا",
    "KI" to "کِرٕباتی",
    "KM" to "کَمورَس",
    "KN" to "سینٹ کِٹَس تہٕ نیوِس",
    "KP" to "شُمٲلی کورِیا",
    "KR" to "جنوٗبی کورِیا",
    "KW" to "کُویت",
    "KY" to "کیمَن جٔزیٖرٕ",
    "KZ" to "قازقستان",
    "LA" to "لاس",
    "LB" to "لؠبنان",
    "LC" to "سینٹ لوٗسِیا",
    "LI" to "لِکٹیسٹیٖن",
    "LK" to "سری لنکا",
    "LR" to "لایبیرِیا",
    "LS" to "لیسوتھو",
    "LT" to "لِتھُوانِیا",
    "LU" to "لَکسَمبٔرٕگ",
    "LV" to "لیٹوِیا",
    "LY" to "لِبیا",
    "MA" to "موروکو",
    "MC" to "مونیکو",
    "MD" to "مولڈووا",
    "ME" to "موٹونیگِریو",
    "MF" to "سینٹ مارٹِن",
    "MG" to "میڈاگاسکار",
    "MH" to "مارشَل جٔزیٖرٕ",
    "MK" to "شُمالی میسڈونیا",
    "ML" to "مالی",
    "MM" to "میانمار (برما)",
    "MN" to "مَنگولِیا",
    "MO" to "مَکاوو ایس اے آر چیٖن",
    "MP" to "شُمٲلی مارِیانا جٔزیٖرٕ",
    "MQ" to "مارٹِنِک",
    "MR" to "مارٕٹانِیا",
    "MS" to "مانٹسیراٹ",
    "MT" to "مالٹا",
    "MU" to "مورِشَس",
    "MV" to "مالدیٖو",
    "MW" to "ملاوی",
    "MX" to "مؠکسِکو",
    "MY" to "مَلیشِیا",
    "MZ" to "موزَمبِک",
    "NA" to "نامِبِیا",
    "NC" to "نِو کیلِڑونِیا",
    "NE" to "نایجَر",
    "NF" to "نارفاک جٔزیٖرٕ",
    "NG" to "نایجیرِیا",
    "NI" to "ناکاراگُوا",
    "NL" to "نیٖدَرلینڑ",
    "NO" to "ناروے",
    "NP" to "نیپال",
    "NR" to "نارووٗ",
    "NU" to "نیوٗ",
    "NZ" to "نیوزی لینڈ",
    "OM" to "اومان",
    "PA" to "پَناما",
    "PE" to "پیٖروٗ",
    "PF" to "فرانسی پولِنیشِیا",
    "PG" to "پاپُوا نیوٗ گیٖنی",
    "PH" to "فلپائن",
    "PK" to "پاکِستان",
    "PL" to "پولینڈ",
    "PM" to "سینٹ پیٖری تہٕ موکیلِیَن",
    "PN" to "پِٹکیرٕنؠ جٔزیٖرٕ",
    "PR" to "پٔرٹو رِکو",
    "PS" to "فلسطینی علاقٕہ",
    "PT" to "پُرتِگال",
    "PW" to "پَلاو",
    "PY" to "پَراگُے",
    "QA" to "قَطِر",
    "QO" to "آوُٹلاینِگ اوشینِیا",
    "RE" to "رِیوٗنِیَن",
    "RO" to "رومانِیا",
    "RS" to "سَربِیا",
    "RU" to "روٗس",
    "RW" to "روٗوانڈا",
    "SA" to "سعودی عرب",
    "SB" to "سولامان جٔزیٖرٕ",
    "SC" to "سیشَلِس",
    "SD" to "سوٗڈان",
    "SE" to "سویڈن",
    "SG" to "سِنگاپوٗر",
    "SH" to "سینٹ ہؠلِنا",
    "SI" to "سَلووینِیا",
    "SJ" to "سَوالبریڑ تہٕ جان ماییڑ",
    "SK" to "سَلوواکِیا",
    "SL" to "سیرا لیون",
    "SM" to "سین میرِنو",
    "SN" to "سینیگَل",
    "SO" to "سومالِیا",
    "SR" to "سُرِنام",
    "SS" to "جنوبی سوڈان",
    "ST" to "ساو توم تہٕ پرنسِپی",
    "SV" to "ایل سلویڈر",
    "SX" to "سِنٹ مارٹِن",
    "SY" to "شام",
    "SZ" to "ایسواتنی",
    "TA" to "ٹریسٹن ڈا کنہا",
    "TC" to "تُرکس تٕہ کیکو جزیرٕ",
    "TD" to "چاڑ",
    "TF" to "فرانسِسی جَنوٗبی عَلاقہٕ",
    "TG" to "ٹوگو",
    "TH" to "تھائی لینڈ",
    "TJ" to "تاجکِستان",
    "TK" to "ٹوکلو",
    "TL" to "تیمور-لیسٹ",
    "TM" to "تُرکمنستان",
    "TN" to "ٹونیشِیا",
    "TO" to "ٹونگا",
    "TR" to "تُرکی",
    "TT" to "ٹرنِنداد تہٕ ٹوبیگو",
    "TV" to "توٗوالوٗ",
    "TW" to "تایوان",
    "TZ" to "تَنجانِیا",
    "UA" to "یوٗرِکین",
    "UG" to "یوٗگانڑا",
    "UM" to "یوٗنایٹِڑ سِٹیٹِس ماینَر آوُٹلییِنگ جٔزیٖرٕ",
    "UN" to "متحدہ مُمٲلک",
    "US" to "یوٗنایٹِڑ سِٹیٹِس",
    "UY" to "یوٗروگے",
    "UZ" to "اُزبِکِستان",
    "VA" to "ویٹِکَن سِٹی",
    "VC" to "سینٹ وینسؠٹ تہٕ گریناڑاینٕز",
    "VE" to "وینازوٗلا",
    "VG" to "بَرطانوی ؤرجِن جٔزیٖرٕ",
    "VI" to "یوٗ ایس ؤرجِن جٔزیٖرٕ",
    "VN" to "ویتنام",
    "VU" to "وانوٗتوٗ",
    "WF" to "والِس تہٕ فیوٗچوٗنا",
    "WS" to "سامو",
    "XA" to "سوڈو-ایسنٹس",
    "XB" to "سوڈو-بیڈی",
    "XK" to "کوسوو",
    "YE" to "یَمَن",
    "YT" to "مَییٹ",
    "ZA" to "جنوبی افریقہ",
    "ZM" to "زیمبیا",
    "ZW" to "زِمبابے",
    "ZZ" to "نامولوٗم علاقٕہ",
  ) }

  val ks_Deva: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BR" to "ब्राज़ील",
    "CN" to "चीन",
    "DE" to "जर्मन",
    "FR" to "फ्रांस",
    "GB" to "मुतहीद बादशाहत",
    "IN" to "हिंदोस्तान",
    "IT" to "इटली",
    "JP" to "जापान",
    "RU" to "रूस",
    "US" to "मूतहीद रियासत",
    "ZZ" to "नामोलुम अलाक़",
  ) }

  val ksb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andola",
    "AE" to "Falme za Kialabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Balbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Almenia",
    "AO" to "Angola",
    "AR" to "Ajentina",
    "AS" to "Samoa ya Malekani",
    "AT" to "Austlia",
    "AU" to "Austlalia",
    "AW" to "Aluba",
    "AZ" to "Azabajani",
    "BA" to "Bosnia na Hezegovina",
    "BB" to "Babadosi",
    "BD" to "Bangladeshi",
    "BF" to "Bukinafaso",
    "BG" to "Bulgalia",
    "BH" to "Bahaleni",
    "BI" to "Bulundi",
    "BJ" to "Benini",
    "BM" to "Belmuda",
    "BN" to "Blunei",
    "BO" to "Bolivia",
    "BR" to "Blazili",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botswana",
    "BY" to "Belalusi",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CD" to "Jamhuli ya Kidemoklasia ya Kongo",
    "CF" to "Jamhuli ya Afrika ya Gati",
    "CG" to "Kongo",
    "CH" to "Uswisi",
    "CI" to "Kodivaa",
    "CK" to "Visiwa vya Cook",
    "CL" to "Chile",
    "CM" to "Kameluni",
    "CN" to "China",
    "CO" to "Kolombia",
    "CR" to "Kostalika",
    "CU" to "Kuba",
    "CV" to "Kepuvede",
    "CY" to "Kuplosi",
    "CZ" to "Jamhuli ya Cheki",
    "DE" to "Ujeumani",
    "DJ" to "Jibuti",
    "DK" to "Denmaki",
    "DM" to "Dominika",
    "DO" to "Jamhuli ya Dominika",
    "DZ" to "Aljelia",
    "EC" to "Ekwado",
    "EE" to "Estonia",
    "EG" to "Misli",
    "ER" to "Elitlea",
    "ES" to "Hispania",
    "ET" to "Uhabeshi",
    "FI" to "Ufini",
    "FJ" to "Fiji",
    "FK" to "Visiwa vya Falkland",
    "FM" to "Miklonesia",
    "FR" to "Ufalansa",
    "GA" to "Gaboni",
    "GB" to "Uingeeza",
    "GD" to "Glenada",
    "GE" to "Jojia",
    "GF" to "Gwiyana ya Ufalansa",
    "GH" to "Ghana",
    "GI" to "Jiblalta",
    "GL" to "Glinlandi",
    "GM" to "Gambia",
    "GN" to "Gine",
    "GP" to "Gwadelupe",
    "GQ" to "Ginekweta",
    "GR" to "Ugiiki",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Honduasi",
    "HR" to "Kolasia",
    "HT" to "Haiti",
    "HU" to "Hungalia",
    "ID" to "Indonesia",
    "IE" to "Ayalandi",
    "IL" to "Islaeli",
    "IN" to "India",
    "IQ" to "Ilaki",
    "IR" to "Uajemi",
    "IS" to "Aislandi",
    "IT" to "Italia",
    "JM" to "Jamaika",
    "JO" to "Yoldani",
    "JP" to "Japani",
    "KE" to "Kenya",
    "KG" to "Kiigizistani",
    "KH" to "Kambodia",
    "KI" to "Kiibati",
    "KM" to "Komolo",
    "KN" to "Santakitzi na Nevis",
    "KP" to "Kolea Kaskazini",
    "KR" to "Kolea Kusini",
    "KW" to "Kuwaiti",
    "KY" to "Visiwa vya Kayman",
    "KZ" to "Kazakistani",
    "LA" to "Laosi",
    "LB" to "Lebanoni",
    "LC" to "Santalusia",
    "LI" to "Lishenteni",
    "LK" to "Sililanka",
    "LR" to "Libelia",
    "LS" to "Lesoto",
    "LT" to "Litwania",
    "LU" to "Lasembagi",
    "LV" to "Lativia",
    "LY" to "Libya",
    "MA" to "Moloko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "MG" to "Bukini",
    "MH" to "Visiwa vya Mashal",
    "ML" to "Mali",
    "MM" to "Myama",
    "MN" to "Mongolia",
    "MP" to "Visiwa vya Maliana vya Kaskazini",
    "MQ" to "Maltiniki",
    "MR" to "Maulitania",
    "MS" to "Montselati",
    "MT" to "Malta",
    "MU" to "Molisi",
    "MV" to "Modivu",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malesia",
    "MZ" to "Msumbiji",
    "NA" to "Namibia",
    "NC" to "Nyukaledonia",
    "NE" to "Naija",
    "NF" to "Kisiwa cha Nolfok",
    "NG" to "Naijelia",
    "NI" to "Nikalagwa",
    "NL" to "Uholanzi",
    "NO" to "Nolwei",
    "NP" to "Nepali",
    "NR" to "Naulu",
    "NU" to "Niue",
    "NZ" to "Nyuzilandi",
    "OM" to "Omani",
    "PA" to "Panama",
    "PE" to "Pelu",
    "PF" to "Polinesia ya Ufalansa",
    "PG" to "Papua",
    "PH" to "Filipino",
    "PK" to "Pakistani",
    "PL" to "Polandi",
    "PM" to "Santapieli na Mikeloni",
    "PN" to "Pitkailni",
    "PR" to "Pwetoliko",
    "PS" to "Ukingo wa Maghalibi na Ukanda wa Gaza wa Palestina",
    "PT" to "Uleno",
    "PW" to "Palau",
    "PY" to "Palagwai",
    "QA" to "Katali",
    "RE" to "Liyunioni",
    "RO" to "Lomania",
    "RU" to "Ulusi",
    "RW" to "Lwanda",
    "SA" to "Saudi",
    "SB" to "Visiwa vya Solomon",
    "SC" to "Shelisheli",
    "SD" to "Sudani",
    "SE" to "Uswidi",
    "SG" to "Singapoo",
    "SH" to "Santahelena",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SL" to "Siela Leoni",
    "SM" to "Samalino",
    "SN" to "Senegali",
    "SO" to "Somalia",
    "SR" to "Sulinamu",
    "ST" to "Sao Tome na Plincipe",
    "SV" to "Elsavado",
    "SY" to "Silia",
    "SZ" to "Uswazi",
    "TC" to "Visiwa vya Tulki na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tailandi",
    "TJ" to "Tajikistani",
    "TK" to "Tokelau",
    "TL" to "Timoli ya Mashaliki",
    "TM" to "Tulukimenistani",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Utuluki",
    "TT" to "Tlinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tanzania",
    "UA" to "Uklaini",
    "UG" to "Uganda",
    "US" to "Malekani",
    "UY" to "Ulugwai",
    "UZ" to "Uzibekistani",
    "VA" to "Vatikani",
    "VC" to "Santavisenti na Glenadini",
    "VE" to "Venezuela",
    "VG" to "Visiwa vya Vilgin vya Uingeeza",
    "VI" to "Visiwa vya Vilgin vya Malekani",
    "VN" to "Vietinamu",
    "VU" to "Vanuatu",
    "WF" to "Walis na Futuna",
    "WS" to "Samoa",
    "YE" to "Yemeni",
    "YT" to "Mayotte",
    "ZA" to "Aflika Kusini",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
  ) }

  val ksf: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "andɔrǝ",
    "AE" to "bǝlɔŋ bǝ kaksa bɛ táatáaŋzǝn",
    "AF" to "afganistáŋ",
    "AG" to "antiga ri barbúda",
    "AI" to "angiya",
    "AL" to "albaní",
    "AM" to "armɛní",
    "AO" to "angóla",
    "AR" to "arjǝntín",
    "AS" to "samɔa a amɛrika",
    "AT" to "otric",
    "AU" to "ɔstralí",
    "AW" to "aruba",
    "AZ" to "azabecán",
    "BA" to "bɔsnyɛ ri hɛrsǝgɔvín",
    "BB" to "baabaadǝ",
    "BD" to "baŋladɛ́c",
    "BE" to "bɛljík",
    "BF" to "bukína fǝ́ asɔ",
    "BG" to "bulgarí",
    "BH" to "barǝ́n",
    "BI" to "burundí",
    "BJ" to "bɛnǝ́n",
    "BM" to "bɛɛmúdǝ",
    "BN" to "brunǝ́",
    "BO" to "bɔɔlíví",
    "BR" to "brɛsíl",
    "BS" to "baamás",
    "BT" to "bután",
    "BW" to "botswana",
    "BY" to "bɛlaris",
    "BZ" to "bɛliz",
    "CA" to "kanada",
    "CD" to "kɔngó anyɔ́n",
    "CF" to "santrafrík",
    "CG" to "kɔngó",
    "CH" to "swís",
    "CI" to "kɔtiwuár",
    "CK" to "zɛ i kúk",
    "CL" to "cíli",
    "CM" to "kamɛrún",
    "CN" to "cín",
    "CO" to "kolɔmbí",
    "CR" to "kɔstaríka",
    "CU" to "kuba",
    "CV" to "kapvɛr",
    "CY" to "cíprɛ",
    "CZ" to "cɛ́k",
    "DE" to "djɛrman",
    "DJ" to "dyibutí",
    "DK" to "danmak",
    "DM" to "dɔminik",
    "DO" to "dɔminik rɛpublík",
    "DZ" to "aljɛrí",
    "EC" to "ɛkwatɛǝ́",
    "EE" to "ɛstoní",
    "EG" to "ɛjípt",
    "ER" to "ɛritrɛ́",
    "ES" to "kpanyá",
    "ET" to "ɛtyɔpí",
    "FI" to "fínlan",
    "FJ" to "fíji",
    "FK" to "zǝ maalwín",
    "FM" to "mikronɛ́si",
    "FR" to "pɛrɛsǝ́",
    "GA" to "gabɔŋ",
    "GB" to "kǝlɔŋ kǝ kǝtáatáaŋzǝn",
    "GD" to "grɛnadǝ",
    "GE" to "jɔrjí",
    "GF" to "guyán i pɛrɛsǝ́",
    "GH" to "gána",
    "GI" to "jibraltá",
    "GL" to "grínlan",
    "GM" to "gambí",
    "GN" to "ginɛ́",
    "GP" to "gwadɛlúp",
    "GQ" to "ginɛ́ ɛkwatɔrial",
    "GR" to "grɛ́k",
    "GT" to "gwátǝmala",
    "GU" to "gwám",
    "GW" to "ginɛ́ bisɔ́",
    "GY" to "guyán",
    "HN" to "ɔnduras",
    "HR" to "krwasí",
    "HT" to "ayiti",
    "HU" to "ɔngrí",
    "ID" to "indonɛsí",
    "IE" to "ilán",
    "IL" to "israɛ́l",
    "IN" to "indí",
    "IQ" to "irák",
    "IR" to "iráŋ",
    "IS" to "zǝ i glás",
    "IT" to "italí",
    "JM" to "jamaík",
    "JO" to "jɔrdán",
    "JP" to "japɔ́ŋ",
    "KE" to "kɛnya",
    "KG" to "kigistáŋ",
    "KH" to "kambodj",
    "KI" to "kiribáti",
    "KM" to "komɔr",
    "KN" to "sɛnkrǝstɔ́f ri nyɛ́vǝ",
    "KP" to "korɛanɔ́r",
    "KR" to "korɛasud",
    "KW" to "kuwɛit",
    "KY" to "zǝ i gan",
    "KZ" to "kazakstáŋ",
    "LA" to "laɔs",
    "LB" to "libáŋ",
    "LC" to "sɛntlísí",
    "LI" to "lictɛnstɛ́n",
    "LK" to "srílaŋka",
    "LR" to "libɛrya",
    "LS" to "lǝsóto",
    "LT" to "litwaní",
    "LU" to "luksɛmbúr",
    "LV" to "lɛtoní",
    "LY" to "libí",
    "MA" to "marɔk",
    "MC" to "monako",
    "MD" to "mɔldaví",
    "MG" to "madagaska",
    "MH" to "zǝ i marcál",
    "ML" to "mali",
    "MM" to "myanmár",
    "MN" to "mɔŋolí",
    "MP" to "zǝ maryánnɔ́r",
    "MQ" to "matiník",
    "MR" to "mwaritaní",
    "MS" to "mɔnsɛrat",
    "MT" to "maltǝ",
    "MU" to "mwarís",
    "MV" to "maldivǝ",
    "MW" to "malawi",
    "MX" to "mɛksík",
    "MY" to "malɛsí",
    "MZ" to "mosambík",
    "NA" to "namibí",
    "NC" to "kalɛdoní anyɔ́n",
    "NE" to "nijɛ́r",
    "NF" to "zɛ nɔ́fɔlk",
    "NG" to "nijɛ́rya",
    "NI" to "níkarágwa",
    "NL" to "kǝlɔŋ kǝ ázǝ",
    "NO" to "nɔrvɛjǝ",
    "NP" to "nɛpal",
    "NR" to "nwarú",
    "NU" to "niwɛ́",
    "NZ" to "zɛlan anyɔ́n",
    "OM" to "oman",
    "PA" to "panama",
    "PE" to "pɛrú",
    "PF" to "pɔlinɛsí a pɛrɛsǝ́",
    "PG" to "papwazí ginɛ́ anyɔ́n",
    "PH" to "filipǝ́n",
    "PK" to "pakistáŋ",
    "PL" to "polɔ́n",
    "PM" to "sɛnpyɛr ri mikɛlɔŋ",
    "PN" to "pitkɛ́n",
    "PR" to "pɔtoríko",
    "PS" to "zǝ palɛstínǝ",
    "PT" to "portugál",
    "PW" to "palwa",
    "PY" to "paragwɛ́",
    "QA" to "katá",
    "RE" to "rɛunyɔŋ",
    "RO" to "rɔmaní",
    "RU" to "risí",
    "RW" to "rwanda",
    "SA" to "arabí saodí",
    "SB" to "zǝ salomɔ́n",
    "SC" to "sɛcɛl",
    "SD" to "sudan",
    "SE" to "swɛdǝ",
    "SG" to "siŋapó",
    "SH" to "sɛntɛ́len",
    "SI" to "slovɛní",
    "SK" to "slovakí",
    "SL" to "syɛraleon",
    "SM" to "sɛnmarǝn",
    "SN" to "sɛnɛgal",
    "SO" to "somalí",
    "SR" to "surinam",
    "ST" to "saotomɛ́ ri priŋsib",
    "SV" to "salvadɔr",
    "SY" to "sirí",
    "SZ" to "swazilan",
    "TC" to "zǝ tirk ri kakɔs",
    "TD" to "caád",
    "TG" to "togo",
    "TH" to "tɛlan",
    "TJ" to "tadjikistaŋ",
    "TK" to "tokǝlao",
    "TL" to "timor anǝ á ɛst",
    "TM" to "tirkmɛnistaŋ",
    "TN" to "tunɛsí",
    "TO" to "tɔŋa",
    "TR" to "tirkí",
    "TT" to "tɛrinitɛ ri tobago",
    "TV" to "tuwalu",
    "TW" to "tɛwán",
    "TZ" to "tanzaní",
    "UA" to "ukrain",
    "UG" to "uganda",
    "US" to "amɛrika",
    "UY" to "urugwɛ́",
    "UZ" to "usbɛkistaŋ",
    "VA" to "watikáŋ",
    "VC" to "sɛnvǝnsǝŋ ri grɛnadín",
    "VE" to "wɛnǝzwɛla",
    "VG" to "zǝ bɛ gɔn inɛ a ingɛrís",
    "VI" to "zǝ bɛ gɔn inɛ á amɛrika",
    "VN" to "wyɛtnám",
    "VU" to "wanwatu",
    "WF" to "walis ri futuna",
    "WS" to "samɔa",
    "YE" to "yɛmɛn",
    "YT" to "mayɔ́t",
    "ZA" to "afrik anǝ a sud",
    "ZM" to "zambí",
    "ZW" to "zimbabwɛ́",
  ) }

  val ksh: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "de Ääd",
    "002" to "Affrika",
    "003" to "Nood-Amärrika",
    "005" to "Söhd-Amärrika",
    "009" to "Ozejahneje",
    "011" to "Wäß-Affrika",
    "013" to "Meddelammärrika",
    "014" to "Oß-Affrika",
    "015" to "Nood-Affrika",
    "017" to "Meddel-Affrika",
    "018" to "Söhd-Affrika",
    "019" to "Ammärrika",
    "021" to "der Norde vun Amärrika",
    "029" to "de Karribik",
    "030" to "Oß-Aasije",
    "034" to "Söhd-Aasije",
    "035" to "Söhd-Oß-Aasije",
    "039" to "Söhd-Europpa",
    "053" to "de Rejjohn öm Austrahlije",
    "054" to "Mellanehsije",
    "057" to "de Rejohn vun Mikronehseje",
    "061" to "Polinehsije",
    "142" to "Aasije",
    "143" to "Meddelaasije",
    "145" to "Wäß-Aasije",
    "150" to "Europpa",
    "151" to "Oß-Europpa",
    "154" to "Nood-Europpa",
    "155" to "Wäß-Europpa",
    "419" to "Lateinamärrika",
    "AC" to "Aßension",
    "AD" to "Andorra",
    "AE" to "Vereinschte Arrabesche Emmirate",
    "AF" to "Afjaanistahn",
    "AG" to "Antigwa un Barbuda",
    "AI" to "Anggwilla",
    "AL" to "Albaanije",
    "AM" to "Arrmeenije",
    "AO" to "Angjoola",
    "AQ" to "der Södpol",
    "AR" to "Ajjentiinije",
    "AS" to "Ammerikaanesch Sammoha",
    "AT" to "Öösterisch",
    "AU" to "Austraalije",
    "AW" to "Aruba",
    "AX" to "de Ohland-Enselle",
    "AZ" to "Asserbaidschahn",
    "BA" to "Boßnije un Herzegovina",
    "BB" to "de Ensel Barbados",
    "BD" to "Bangladesch",
    "BE" to "Bellje",
    "BF" to "Bukkinna-Faase",
    "BG" to "Bulljaarije",
    "BH" to "Bachrain",
    "BI" to "Burundi",
    "BJ" to "dä Benin",
    "BL" to "de Zint Battälmi-Enselle",
    "BM" to "de Bermudas",
    "BN" to "Brunei",
    "BO" to "Bolliivije",
    "BQ" to "de karribbesche Nederläng",
    "BR" to "Brasilije",
    "BS" to "de Bahamas",
    "BT" to "Buttaan",
    "BV" to "de Buvee-Ensel",
    "BW" to "Bozwaana",
    "BY" to "Wießrußland",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "de Kokkos-Enselle",
    "CD" to "dä Konggo (Kinschasa)",
    "CF" to "de Zäntraalaffrikaanesche Republik",
    "CG" to "dä Konggo (Brassavill)",
    "CH" to "de Schweiz",
    "CI" to "Älfebeijn-Köß",
    "CK" to "de Kuuk-Enselle",
    "CL" to "Schiile",
    "CM" to "Kammeruhn",
    "CN" to "Schiina",
    "CO" to "Kolumbije",
    "CP" to "de Klipperton-Ensel",
    "CR" to "Kostarika",
    "CU" to "Kuhba",
    "CV" to "de kapvärdesche Enselle",
    "CW" to "Curaçao",
    "CX" to "de Weihnaachs-Ensel",
    "CY" to "Züppere",
    "CZ" to "de Tschäschei",
    "DE" to "Doütschland",
    "DG" to "de Diego-Garcia-Ensel",
    "DJ" to "Dschibutti",
    "DK" to "Dänemark",
    "DM" to "Dominnika",
    "DO" to "de Dommenekaanesche Reppublik",
    "DZ" to "Alljeerije",
    "EA" to "Ze’uta un Meliija",
    "EC" to "Äkwador",
    "EE" to "Äßland",
    "EG" to "Äjüpte",
    "EH" to "Wäß-Sahara",
    "ER" to "Äritreja",
    "ES" to "Schpaanije",
    "ET" to "Ättijoopije",
    "EU" to "de Europähjesche Unijon",
    "FI" to "Finnland",
    "FJ" to "de Fidschi-Endelle",
    "FK" to "de Falkland-Enselle",
    "FM" to "Mikroneesije",
    "FO" to "de Färrör-Enselle",
    "FR" to "Frankrisch",
    "GA" to "Jabuhn",
    "GB" to "Jruußbrettannije",
    "GD" to "Jrenahda",
    "GE" to "Jeorrjije",
    "GF" to "Franzüüsesch Jujaana",
    "GG" to "Jöönsei",
    "GH" to "Jaana",
    "GI" to "Jibralltaa",
    "GL" to "Jröhnland",
    "GM" to "Jambija",
    "GN" to "Jinneha",
    "GP" to "Juadelupp",
    "GQ" to "Äquatorial Jineeja",
    "GR" to "Jriescheland",
    "GS" to "Söd-Jeorjie un de södlijje Botteramms-Enselle",
    "GT" to "Juwatemahla",
    "GU" to "Juham",
    "GW" to "Jinneha_Bißau",
    "GY" to "Jujaana",
    "HK" to "Hongkong",
    "HM" to "de Heart Ensel un de McDonald-Enselle",
    "HN" to "Honduras",
    "HR" to "Krowazije",
    "HT" to "Ha’itti",
    "HU" to "Unjann",
    "IC" to "de Kannaresche Enselle",
    "ID" to "Indoneesije",
    "IE" to "Irrland",
    "IL" to "Ißraäl",
    "IM" to "de Ensel Män",
    "IN" to "Indije",
    "IQ" to "Irak",
    "IR" to "Persije",
    "IS" to "Ißland",
    "IT" to "Itaalije",
    "JE" to "Jööseh",
    "JM" to "Jammaika",
    "JO" to "Jordaanije",
    "JP" to "Japan",
    "KE" to "Keenija",
    "KG" to "Kirrjiisije",
    "KH" to "Kambodscha",
    "KI" to "Kiribati",
    "KM" to "de Kommoore",
    "KN" to "Zint Kitts un Nevis",
    "KP" to "Nood-Koreja",
    "KR" to "Söd-Koreja",
    "KW" to "Kuweit",
    "KY" to "de Kaiman-Enselle",
    "KZ" to "Kassakstahn",
    "LA" to "La’os",
    "LB" to "Lebbannon",
    "LC" to "de Ensel Zint-Lutscha",
    "LI" to "Lischteschtein",
    "LK" to "Sri Lanka",
    "LR" to "Libeerija",
    "LS" to "Lesooto",
    "LT" to "Littaue",
    "LU" to "Luxembursch",
    "LV" to "Lätland",
    "LY" to "Libbije",
    "MA" to "Marokko",
    "MC" to "Monakko",
    "MD" to "Moldaavije",
    "ME" to "et Monteneejro",
    "MF" to "de Zint-Määtes-Ensel",
    "MG" to "Maddajaska",
    "MH" to "de Machschall-Enselle",
    "ML" to "Maali",
    "MM" to "Birma",
    "MN" to "Mongjolei",
    "MO" to "Makau",
    "MP" to "de nöödlijje Marijanne-Enselle",
    "MQ" to "Machtinik",
    "MR" to "Mautitaanije",
    "MS" to "Mongßerrat",
    "MT" to "Malta",
    "MU" to "Maurizijus",
    "MV" to "Mallediive",
    "MW" to "Malawi",
    "MX" to "Mäxiko",
    "MY" to "Malaisije",
    "MZ" to "Mosambik",
    "NA" to "Namiibije",
    "NC" to "Neuschottland",
    "NE" to "Nijer",
    "NF" to "de Noofok-Ensel",
    "NG" to "Nikaraagua",
    "NI" to "Nikarahguwa",
    "NL" to "de Nederläng",
    "NO" to "Norrweeje",
    "NP" to "Nepall",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Neuseeland",
    "OM" to "Oman",
    "PA" to "Pannama",
    "PE" to "Perruh",
    "PF" to "Franzüüsesch Pollineesije",
    "PG" to "Papuwa Neujineeja",
    "PH" to "Fillipiine",
    "PK" to "Pakistahn",
    "PL" to "Pole",
    "PM" to "Zint Pjäär un Mikelong",
    "PN" to "de Pitkärn-Ensel",
    "PR" to "Pochtoriko",
    "PS" to "Palästina",
    "PT" to "Pochtojall",
    "PW" to "Pallau",
    "PY" to "Parraguwai",
    "QA" to "Kataa",
    "QO" to "Ozejahnije ußerhallef",
    "RE" to "Rehunjohn",
    "RO" to "Romäänije",
    "RS" to "Särbije",
    "RU" to "Rußland",
    "RW" to "Ruanda",
    "SA" to "Saudi Arraabije",
    "SB" to "de Solomone-Enselle",
    "SC" to "de Seischälle",
    "SD" to "Noodsudahn",
    "SE" to "Schweede",
    "SG" to "Singjapuur",
    "SH" to "de Ensel Zint Hellena",
    "SI" to "ẞloveenije",
    "SJ" to "de Enselle Svalbard un Jan Mayen",
    "SK" to "ẞlovakei",
    "SL" to "Sjärra Lejone",
    "SM" to "San-Marino",
    "SN" to "der Sennejall",
    "SO" to "Somaalije",
    "SR" to "Sürinamm",
    "SS" to "Södsudahn",
    "ST" to "Zint Tommeh un Printschipe",
    "SV" to "Äl Slavadohr",
    "SX" to "Zint Maarten",
    "SY" to "Sürije",
    "SZ" to "ẞwaasiland",
    "TA" to "Tristan da Cunja",
    "TC" to "de Enselle Turks un Kaikos",
    "TD" to "der Tschadd",
    "TF" to "Franzüüsesche Södsee-Enselle",
    "TG" to "Toojo",
    "TH" to "Tailand",
    "TJ" to "Tadschikistahn",
    "TK" to "Tokelau",
    "TL" to "Oß-Timor",
    "TM" to "Turkmenistahn",
    "TN" to "Tuneesije",
    "TO" to "Tongga",
    "TR" to "de Törkei",
    "TT" to "Trinidad un Tobähjo",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tansanija",
    "UA" to "de Ukra’iine",
    "UG" to "Ujanda",
    "UM" to "de Vereineschte Schtaate vun Amärrika ier ußerhallef jelääje Enselsche",
    "US" to "de vereineschte Schtaate vun Ammärrika",
    "UY" to "Urrujwai",
    "UZ" to "Ußbeekistahn",
    "VA" to "der Vattikahn",
    "VC" to "Zint Vinzänz un de Jrenadines-Enselle",
    "VE" to "Venezuela",
    "VG" to "de brettesche Juffer-Enselle",
    "VI" to "de ammärrikahnesche Juffer-Enselle",
    "VN" to "Vijätnamm",
    "VU" to "Vanuatu",
    "WF" to "Wallis un Futuna",
    "WS" to "Sammoha",
    "XK" to "Kosovo",
    "YE" to "Jämme",
    "YT" to "Majott",
    "ZA" to "de Republik Södaffrika",
    "ZM" to "Sambija",
    "ZW" to "Simbabwe",
    "ZZ" to "- Jähjend onbikannt -",
  ) }

  val ku: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "dinya",
    "002" to "Afrîka",
    "003" to "Amerîkaya Bakur",
    "005" to "Amerîkaya Başûr",
    "009" to "Okyanûsya",
    "011" to "Rojavayê Afrîkayê",
    "013" to "Amerîkaya Navîn",
    "014" to "Rojhilatê Afrîkayê",
    "015" to "Bakurê Afrîkayê",
    "017" to "Afrîkaya Navîn",
    "018" to "Başûrê Afrîkayê",
    "019" to "Amerîka",
    "021" to "Bakurê Amerîkayê",
    "029" to "Karayîb",
    "030" to "Rojhilatê Asyayê",
    "034" to "Başûrê Asyayê",
    "035" to "Başûrrojhilatê Asyayê",
    "039" to "Başûrê Ewropayê",
    "053" to "Awistralasya",
    "054" to "Melanezya",
    "057" to "Herêma Mîkronezyayê",
    "061" to "Polînezya",
    "142" to "Asya",
    "143" to "Asyaya Navîn",
    "145" to "Rojavayê Asyayê",
    "150" to "Ewropa",
    "151" to "Rojhilatê Ewropayê",
    "154" to "Bakurê Ewropayê",
    "155" to "Rojavayê Ewropayê",
    "202" to "Afrîkaya Jêra Sahrayê",
    "419" to "Amerîkaya Latîn",
    "AC" to "Girava Ascensionê",
    "AD" to "Andorra",
    "AE" to "Mîrgehên Erebî yên Yekbûyî",
    "AF" to "Efxanistan",
    "AG" to "Antîgua û Berbûda",
    "AI" to "Anguîla",
    "AL" to "Albanya",
    "AM" to "Ermenistan",
    "AO" to "Angola",
    "AQ" to "Antarktîka",
    "AR" to "Arjantîn",
    "AS" to "Samoaya Amerîkanî",
    "AT" to "Awistirya",
    "AU" to "Awistralya",
    "AW" to "Arûba",
    "AX" to "Giravên Alandê",
    "AZ" to "Azerbeycan",
    "BA" to "Bosna û Hersek",
    "BB" to "Barbados",
    "BD" to "Bengladeş",
    "BE" to "Belçîka",
    "BF" to "Burkîna Faso",
    "BG" to "Bulgaristan",
    "BH" to "Behreyn",
    "BI" to "Bûrûndî",
    "BJ" to "Bênîn",
    "BL" to "Saint Barthelemy",
    "BM" to "Bermûda",
    "BN" to "Brûney",
    "BO" to "Bolîvya",
    "BQ" to "Holendaya Karayîbê",
    "BR" to "Brezîlya",
    "BS" to "Bahama",
    "BT" to "Bûtan",
    "BV" to "Girava Bouvetê",
    "BW" to "Botswana",
    "BY" to "Belarûs",
    "BZ" to "Belîze",
    "CA" to "Kanada",
    "CC" to "Giravên Kokosê (Keeling)",
    "CD" to "Kongo - Kînşasa",
    "CF" to "Komara Afrîkaya Navîn",
    "CG" to "Kongo - Brazzaville",
    "CH" to "Swîsre",
    "CI" to "Côte d’Ivoire",
    "CK" to "Giravên Cookê",
    "CL" to "Şîle",
    "CM" to "Kamerûn",
    "CN" to "Çîn",
    "CO" to "Kolombîya",
    "CP" to "Girava Clippertonê",
    "CQ" to "Sark",
    "CR" to "Kosta Rîka",
    "CU" to "Kuba",
    "CV" to "Kap Verde",
    "CW" to "Curaçao",
    "CX" to "Girava Christmasê",
    "CY" to "Qibris",
    "CZ" to "Çekya",
    "DE" to "Almanya",
    "DG" to "Diego Garcia",
    "DJ" to "Cîbûtî",
    "DK" to "Danîmarka",
    "DM" to "Domînîka",
    "DO" to "Komara Domînîkê",
    "DZ" to "Cezayîr",
    "EA" to "Ceuta û Melîla",
    "EC" to "Ekwador",
    "EE" to "Estonya",
    "EG" to "Misir",
    "EH" to "Sahraya Rojava",
    "ER" to "Erître",
    "ES" to "Spanya",
    "ET" to "Etîyopya",
    "EU" to "Yekîtîya Ewropayê",
    "EZ" to "Herêma Ewroyê",
    "FI" to "Fînlenda",
    "FJ" to "Fîjî",
    "FK" to "Giravên Falklandê",
    "FM" to "Mîkronezya",
    "FO" to "Giravên Faroeyê",
    "FR" to "Fransa",
    "GA" to "Gabon",
    "GB" to "Qiralîyeta Yekbûyî",
    "GD" to "Grenada",
    "GE" to "Gurcistan",
    "GF" to "Guyanaya Fransî",
    "GG" to "Guernsey",
    "GH" to "Gana",
    "GI" to "Cebelîtariq",
    "GL" to "Grînlanda",
    "GM" to "Gambîya",
    "GN" to "Gîne",
    "GP" to "Guadeloupe",
    "GQ" to "Gîneya Ekwadorê",
    "GR" to "Yûnanistan",
    "GS" to "Giravên Georgîyaya Başûr û Sandwicha Başûr",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Gîne-Bissau",
    "GY" to "Guyana",
    "HK" to "Hong Konga HîT ya Çînê",
    "HM" to "Giravên Heard û MacDonaldê",
    "HN" to "Hondûras",
    "HR" to "Xirwatistan",
    "HT" to "Haîtî",
    "HU" to "Macaristan",
    "IC" to "Giravên Kanaryayê",
    "ID" to "Endonezya",
    "IE" to "Îrlanda",
    "IL" to "Îsraîl",
    "IM" to "Girava Manê",
    "IN" to "Hindistan",
    "IO" to "Herêma Okyanûsa Hindî ya Brîtanyayê",
    "IQ" to "Îraq",
    "IR" to "Îran",
    "IS" to "Îslanda",
    "IT" to "Îtalya",
    "JE" to "Jersey",
    "JM" to "Jamaîka",
    "JO" to "Urdun",
    "JP" to "Japonya",
    "KE" to "Kenya",
    "KG" to "Qirgizistan",
    "KH" to "Kamboçya",
    "KI" to "Kirîbatî",
    "KM" to "Komor",
    "KN" to "Saint Kitts û Nevîs",
    "KP" to "Koreya Bakur",
    "KR" to "Koreya Başûr",
    "KW" to "Kuweyt",
    "KY" to "Giravên Kaymanê",
    "KZ" to "Qazaxistan",
    "LA" to "Laos",
    "LB" to "Libnan",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Srî Lanka",
    "LR" to "Lîberya",
    "LS" to "Lesoto",
    "LT" to "Lîtvanya",
    "LU" to "Luksembûrg",
    "LV" to "Letonya",
    "LY" to "Lîbya",
    "MA" to "Fas",
    "MC" to "Monako",
    "MD" to "Moldova",
    "ME" to "Montenegro",
    "MF" to "Saint Martin",
    "MG" to "Madagaskar",
    "MH" to "Giravên Marşalê",
    "MK" to "Makendonyaya Bakur",
    "ML" to "Malî",
    "MM" to "Myanmar (Bûrma)",
    "MN" to "Moxolistan",
    "MO" to "Makaoya Hît ya Çînê",
    "MP" to "Giravên Bakurê Marianan",
    "MQ" to "Martînîk",
    "MR" to "Morîtanya",
    "MS" to "Montserat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldîva",
    "MW" to "Malawî",
    "MX" to "Meksîka",
    "MY" to "Malezya",
    "MZ" to "Mozambîk",
    "NA" to "Namîbya",
    "NC" to "Kaledonyaya Nû",
    "NE" to "Nîjer",
    "NF" to "Girava Norfolkê",
    "NG" to "Nîjerya",
    "NI" to "Nîkaragua",
    "NL" to "Holanda",
    "NO" to "Norwêc",
    "NP" to "Nepal",
    "NR" to "Naûrû",
    "NU" to "Niûe",
    "NZ" to "Zelandaya Nû",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Perû",
    "PF" to "Polînezyaya Fransizî",
    "PG" to "Papua Gîneya Nû",
    "PH" to "Fîlîpîn",
    "PK" to "Pakistan",
    "PL" to "Polonya",
    "PM" to "Saint-Pierre û Miquelon",
    "PN" to "Giravên Pitcairnê",
    "PR" to "Porto Rîko",
    "PS" to "Herêmên Filîstînî",
    "PT" to "Portûgal",
    "PW" to "Palau",
    "PY" to "Paragûay",
    "QA" to "Qeter",
    "QO" to "Okyanûsyaya Dûr",
    "RE" to "Réunion",
    "RO" to "Romanya",
    "RS" to "Sirbistan",
    "RU" to "Rûsya",
    "RW" to "Rwanda",
    "SA" to "Erebistana Siûdî",
    "SB" to "Giravên Solomonê",
    "SC" to "Seyşel",
    "SD" to "Sûdan",
    "SE" to "Swêd",
    "SG" to "Sîngapûr",
    "SH" to "Saint Helena",
    "SI" to "Slovenya",
    "SJ" to "Svalbard û Jan Mayen",
    "SK" to "Slovakya",
    "SL" to "Sierra Leone",
    "SM" to "San Marîno",
    "SN" to "Senegal",
    "SO" to "Somalya",
    "SR" to "Surînam",
    "SS" to "Sûdana Başûr",
    "ST" to "Sao Tome û Prînsîpe",
    "SV" to "El Salvador",
    "SX" to "Sint Marteen",
    "SY" to "Sûrîye",
    "SZ" to "Eswatînî",
    "TA" to "Tristan da Cunha",
    "TC" to "Giravên Turks û Kaîkosê",
    "TD" to "Çad",
    "TF" to "Herêmên Başûr ên Fransayê",
    "TG" to "Togo",
    "TH" to "Tayland",
    "TJ" to "Tacîkistan",
    "TK" to "Tokelau",
    "TL" to "Tîmor-Leste",
    "TM" to "Tirkmenistan",
    "TN" to "Tûnis",
    "TO" to "Tonga",
    "TR" to "Tirkîye",
    "TT" to "Trînîdad û Tobago",
    "TV" to "Tûvalû",
    "TW" to "Taywan",
    "TZ" to "Tanzanya",
    "UA" to "Ûkrayna",
    "UG" to "Ûganda",
    "UM" to "Giravên Biçûk ên Derveyî DYAyê",
    "UN" to "Miletên Yekbûyî",
    "US" to "Dewletên Yekbûyî yên Amerîkayê",
    "UY" to "Ûrûguay",
    "UZ" to "Ozbekistan",
    "VA" to "Vatîkan",
    "VC" to "Saint Vincent û Giravên Grenadînê",
    "VE" to "Venezuela",
    "VG" to "Giravên Vîrjînê yên Brîtanyayê",
    "VI" to "Giravên Vîrjînê yên Amerîkayê",
    "VN" to "Vîetnam",
    "VU" to "Vanûatû",
    "WF" to "Wallis û Futuna",
    "WS" to "Samoa",
    "XA" to "Aksanên Psodoyê",
    "XB" to "Psodo Bidî",
    "XK" to "Kosova",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "Afrîkaya Başûr",
    "ZM" to "Zambîya",
    "ZW" to "Zîmbabwe",
    "ZZ" to "Herêma Nenas",
  ) }

  val kw: ImmutableMap<String, String> by lazy { immutableMapOf(
    "GB" to "Rywvaneth Unys",
  ) }

  val kxv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "raji, purti",
    "419" to "laṭin amerika",
    "AD" to "ānḍorā",
    "AE" to "aanḍiti arab emireṭs",
    "AF" to "aapganistan",
    "AG" to "eṇṭigaa aḍe barbuḍaa",
    "AI" to "anguila",
    "AL" to "albania",
    "AM" to "aarmenia",
    "AO" to "angola",
    "AQ" to "ānṭarkṭikā",
    "AR" to "aarhenṭina",
    "AS" to "amerikati samva",
    "AT" to "austria",
    "AU" to "astrelia",
    "AW" to "aruba",
    "AX" to "eleṇḍ dīp",
    "AZ" to "ajerbaijan",
    "BA" to "bajnia aḍe hertsegovina",
    "BB" to "barbaḍos",
    "BD" to "banglades",
    "BE" to "beljiym",
    "BF" to "burkina paso",
    "BG" to "bulgaria",
    "BH" to "bāren",
    "BI" to "buruṇḍī",
    "BJ" to "benīn",
    "BL" to "se barṭelemi",
    "BM" to "bermuḍā",
    "BN" to "brunae",
    "BO" to "boliviā",
    "BQ" to "karibiyn nedrlends",
    "BR" to "brājil",
    "BS" to "bāhāmās",
    "BT" to "buṭān",
    "BW" to "boṭsvana",
    "BY" to "belarūs",
    "BZ" to "belīj",
    "CA" to "kanaḍa",
    "CC" to "kokos keling dīp",
    "CD" to "kongo - kinsasa",
    "CF" to "madini aaprika republik",
    "CG" to "kongo - brajavil",
    "CH" to "svitjerlaṇḍ",
    "CI" to "koṭ ḍi vaa",
    "CK" to "kuk dīp",
    "CL" to "cili",
    "CM" to "kemarun",
    "CN" to "caina",
    "CO" to "kolmbiaa",
    "CR" to "kosta rika",
    "CU" to "kyuba",
    "CV" to "kep vrḍi",
    "CW" to "kyurasao",
    "CX" to "kristmas dīp",
    "CY" to "saipras",
    "CZ" to "cekiya",
    "DE" to "jermanī",
    "DG" to "ḍiego garsia",
    "DJ" to "jibutī",
    "DK" to "ḍenmark",
    "DM" to "dominika",
    "DO" to "dominikan republik",
    "DZ" to "aljīriaa",
    "EA" to "seuṭa aḍe melila",
    "EC" to "ekvaḍor",
    "EE" to "esṭoniya",
    "EG" to "ījipṭ",
    "EH" to "vedakuṇpu sahara",
    "ER" to "īriṭriaa",
    "ES" to "spein",
    "ET" to "ītiyopiya",
    "FI" to "pinlaṇd",
    "FJ" to "piji",
    "FK" to "paklaṇd dīp",
    "FM" to "micronesiaa",
    "FO" to "pēro dīp",
    "FR" to "prans",
    "GA" to "gbon",
    "GB" to "uniṭeḍ kingḍom",
    "GD" to "graneida",
    "GE" to "jeorjiaa",
    "GF" to "prenc guiyana",
    "GG" to "grnse",
    "GH" to "gana",
    "GI" to "jbralṭr",
    "GL" to "grīnlanḍ",
    "GM" to "gambia",
    "GN" to "gini",
    "GP" to "gvadelup",
    "GQ" to "ikveṭorial gini",
    "GR" to "grīs",
    "GS" to "dakiṇ jārjiā aḍe dakiṇ sandwich dīp",
    "GT" to "gvaṭemala",
    "GU" to "guām",
    "GW" to "gini-bisau",
    "GY" to "guyana",
    "HK" to "hong kong (sar) caina",
    "HN" to "honḍuras",
    "HR" to "kroesia",
    "HT" to "haiti",
    "HU" to "hungarī",
    "IC" to "kanari dīp",
    "ID" to "inḍonesiya",
    "IE" to "aayarlanḍ",
    "IL" to "israel",
    "IM" to "aail āp man",
    "IN" to "inḍiā",
    "IO" to "briṭis inḍiāti samudra handi",
    "IQ" to "irak",
    "IR" to "iran",
    "IS" to "aislanḍ",
    "IT" to "iṭalī",
    "JE" to "jersī",
    "JM" to "jamaika",
    "JO" to "jorḍan",
    "JP" to "japan",
    "KE" to "kenya",
    "KG" to "kirgistan",
    "KH" to "kamboḍia",
    "KI" to "kiribaṭi",
    "KM" to "komoros",
    "KN" to "seint kiṭs āḍe nebis",
    "KP" to "uttar koriya",
    "KR" to "dkiṇ koriyaa",
    "KW" to "kuvet",
    "KY" to "keimen dīp",
    "KZ" to "kajakstan",
    "LA" to "laos",
    "LB" to "lebanon",
    "LC" to "seint lusiya",
    "LI" to "likṭensṭein",
    "LK" to "sri lanka",
    "LR" to "laiberīya",
    "LS" to "lesotho",
    "LT" to "liṭuaania",
    "LU" to "lksemborg",
    "LV" to "laṭviya",
    "LY" to "libya",
    "MA" to "morkko",
    "MC" to "monako",
    "MD" to "molḍovaa",
    "ME" to "monṭenegro",
    "MF" to "seint martin",
    "MG" to "madagascar",
    "MH" to "marsall dīp",
    "MK" to "uttar mesiḍoniya",
    "ML" to "mali",
    "MM" to "myanmar (brma)",
    "MN" to "mongolia",
    "MO" to "makao sar cina",
    "MP" to "uttar mariyana dīp",
    "MQ" to "marṭinik",
    "MR" to "mauriṭaniya",
    "MS" to "monṭserrarṭ",
    "MT" to "malṭaa",
    "MU" to "mauriss",
    "MV" to "māldīp",
    "MW" to "malavī",
    "MX" to "meksīko",
    "MY" to "maleseāā",
    "MZ" to "mojambik",
    "NA" to "namibia",
    "NC" to "nyu keleḍoniya",
    "NE" to "naījr",
    "NF" to "norpok dīp",
    "NG" to "naigeria",
    "NI" to "nikaraguaa",
    "NL" to "nederlanḍs",
    "NO" to "norvay",
    "NP" to "nepal",
    "NR" to "nauru",
    "NU" to "niyu",
    "NZ" to "nyu jīlanḍ",
    "OM" to "oman",
    "PA" to "panema",
    "PE" to "peru",
    "PF" to "prenc",
    "PG" to "papua nyu gini",
    "PH" to "pilippines",
    "PK" to "pakistan",
    "PL" to "polanḍ",
    "PM" to "seint pierri ande mikelon",
    "PN" to "piṭkarn dīp",
    "PR" to "puerto rico",
    "PS" to "palesṭiati handi",
    "PT" to "portugal",
    "PW" to "palau",
    "PY" to "pareguvai",
    "QA" to "katar",
    "RE" to "riyuniyn",
    "RO" to "romaniya",
    "RS" to "serbia",
    "RU" to "russia",
    "RW" to "rvanḍa",
    "SA" to "saūdi arabiya",
    "SB" to "soloman dīp",
    "SC" to "siselles",
    "SD" to "suḍan",
    "SE" to "sviḍen",
    "SG" to "singapor",
    "SH" to "seint helena",
    "SI" to "slovenia",
    "SJ" to "svalbard aḍe jan mayen",
    "SK" to "slovakia",
    "SL" to "sierra leyon",
    "SM" to "san marino",
    "SN" to "senegal",
    "SO" to "somaliya",
    "SR" to "surīname",
    "SS" to "dkiṇ sūdan",
    "ST" to "sao tom aḍe prinsipe",
    "SV" to "el salvador",
    "SX" to "sint mārṭen",
    "SY" to "sīriya",
    "SZ" to "esvaṭini",
    "TC" to "turks aḍe keikes dīp",
    "TD" to "cad",
    "TF" to "prēnch dakiṇ teritorī",
    "TG" to "ṭogo",
    "TH" to "tailanḍ",
    "TJ" to "tajākīstān",
    "TK" to "ṭokelau",
    "TL" to "ṭimor - leste",
    "TM" to "turkmenīstān",
    "TN" to "ṭunisiaa",
    "TO" to "ṭonga",
    "TR" to "turkī",
    "TT" to "ṭriniḍaḍ aḍe ṭobego",
    "TV" to "tuvala",
    "TW" to "taivan",
    "TZ" to "ṭanjaniya",
    "UA" to "yūkrain",
    "UG" to "yūganḍa",
    "UM" to "yu.es. aautlaing dīp",
    "US" to "yunaiṭeḍ stets",
    "UY" to "ūrugve",
    "UZ" to "ūjbekistaan",
    "VA" to "bāṭikān",
    "VC" to "seint vinseṇṭ aḍe grenaḍi",
    "VE" to "venejuela",
    "VG" to "briṭis vrjin dīp",
    "VI" to "yu.es. vrjin dīp",
    "VN" to "viyetnam",
    "VU" to "vanuaatu",
    "WF" to "vallis aḍe puṭuna",
    "WS" to "samoaa",
    "XK" to "kosovo",
    "YE" to "yemen",
    "YT" to "mayoṭṭ",
    "ZA" to "dkīṇ aaprika",
    "ZM" to "jambiya",
    "ZW" to "jimbabve",
  ) }

  val kxv_Deva: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "राजि, पृती",
    "419" to "लातिन आमेरिका ति",
    "AD" to "अंडोरा",
    "AE" to "आण्डी ति अरब एमिरेट्स",
    "AF" to "अप़गानिस्तान",
    "AG" to "एंटिगुआ ऑड़े बरबुडा",
    "AI" to "एंग्विला",
    "AL" to "अल्बानिया",
    "AM" to "आर्मेनिया",
    "AO" to "अंगोला",
    "AQ" to "अंटार्कटिका",
    "AR" to "अर्जेंटीना",
    "AS" to "आमेरिका-ति समोआ",
    "AT" to "ऑस्ट्रिया",
    "AU" to "ऑस्ट्रेलिया",
    "AW" to "अरूबा",
    "AX" to "एलेंड द्वीप",
    "AZ" to "अज़रबेजान",
    "BA" to "बोस्निया ऑड़े हर्ज़ेगोविना",
    "BB" to "बारबाडोस",
    "BD" to "बांग्लादेस",
    "BE" to "बेल्जियम",
    "BF" to "बुर्किना प़ासो",
    "BG" to "बुल्गारिया",
    "BH" to "बहरीन",
    "BI" to "बुरुंडी",
    "BJ" to "बेनिन",
    "BL" to "सेंट बार्तेलेमी",
    "BM" to "बरमूडा",
    "BN" to "ब्रूनेई",
    "BO" to "बोलीविया",
    "BQ" to "केरिबियन नीदरलेंड",
    "BR" to "ब्राज़ील",
    "BS" to "बहामास",
    "BT" to "बुटान",
    "BW" to "बोत्स्वाना",
    "BY" to "बेलारूस",
    "BZ" to "बेलीज़",
    "CA" to "कानाडा",
    "CC" to "कोकोस (कीलिंग) द्वीप",
    "CD" to "कांगो - किंसासा",
    "CF" to "मध्य अप़्रीकी गणराज्य",
    "CG" to "कांगो – ब्राज़ाविल",
    "CH" to "स्विट्ज़रलेंड",
    "CI" to "कोट डी वोआ",
    "CK" to "कुक द्वीप",
    "CL" to "चिली",
    "CM" to "केमरून",
    "CN" to "चीन",
    "CO" to "कोलंबिया",
    "CR" to "कोस्टारिका",
    "CU" to "क्यूबा",
    "CV" to "केप वर्ड",
    "CW" to "क्यूरासाओ",
    "CX" to "क्रिसमस द्वीप",
    "CY" to "साइप्रस",
    "CZ" to "चेकिया",
    "DE" to "जर्मनी",
    "DG" to "डिएगो गार्सिया",
    "DJ" to "जिबूती",
    "DK" to "डेनमार्क",
    "DM" to "डोमिनिका",
    "DO" to "डोमिनिकन गणराज्य",
    "DZ" to "अल्जीरिया",
    "EA" to "सेउटा ऑड़े मेलिला",
    "EC" to "इक्वाडोर",
    "EE" to "एस्टोनिया",
    "EG" to "मिस्र",
    "EH" to "वेड़ा कुण्पु सहारा",
    "ER" to "इरिट्रिया",
    "ES" to "स्पेन",
    "ET" to "इतियोपिया",
    "FI" to "प़िनलेंड",
    "FJ" to "प़िजी",
    "FK" to "प़ॉकलेंड द्वीप",
    "FM" to "माइक्रोनेसिया",
    "FO" to "पेरो दीप",
    "FR" to "प़्रांस",
    "GA" to "ग्याबॉन",
    "GB" to "यूनाइटेड किंगडम",
    "GD" to "ग्रेनाडा",
    "GE" to "जॉर्जिया",
    "GF" to "प़्रेंच गुयाना",
    "GG" to "गर्नसी",
    "GH" to "गाना",
    "GI" to "जिब्राल्टर",
    "GL" to "ग्रीनलेंड",
    "GM" to "गाम्बिया",
    "GN" to "गिनी",
    "GP" to "ग्वाडेलूप",
    "GQ" to "इक्वेटोरियल गिनी",
    "GR" to "यूनान",
    "GS" to "दकिण जॉर्जिया अड़े दकिण सैंडविच दीप",
    "GT" to "ग्वाटेमाला",
    "GU" to "गुआम",
    "GW" to "गिनी-बिसाउ",
    "GY" to "गुयाना",
    "HK" to "हाँग काँग (एस ए आर चीन)",
    "HN" to "होंडूरास",
    "HR" to "क्रोएसिया",
    "HT" to "हाइती",
    "HU" to "हंगरी",
    "IC" to "केनेरी द्वीप",
    "ID" to "इंडोनेसिया",
    "IE" to "आयरलेंड",
    "IL" to "इज़राइल",
    "IM" to "आइल ऑप़ मेन",
    "IN" to "बारत",
    "IO" to "ब्रिटिस हिंद सामुद्रि हांडि",
    "IQ" to "इराक",
    "IR" to "ईरान",
    "IS" to "आइसलेंड",
    "IT" to "इटली",
    "JE" to "जर्सी",
    "JM" to "जमेका",
    "JO" to "जॉर्डन",
    "JP" to "जापान",
    "KE" to "केन्या",
    "KG" to "किर्गिज़स्तान",
    "KH" to "कंबोडिया",
    "KI" to "किरिबाती",
    "KM" to "कोमोरोस",
    "KN" to "सेंट किट्स ऑड़े नेविस",
    "KP" to "उतर कोरिया",
    "KR" to "दॉकिण कोरिया",
    "KW" to "कुवेत",
    "KY" to "केमेन द्वीप",
    "KZ" to "कज़ाकस्तान",
    "LA" to "लाओस",
    "LB" to "लेबनान",
    "LC" to "सेंट लूसिया",
    "LI" to "लिक्टेन्स्टीन",
    "LK" to "स्रीलंका",
    "LR" to "लाइबेरिया",
    "LS" to "लेसोतो",
    "LT" to "लितुआनिया",
    "LU" to "लग्ज़मबर्ग",
    "LV" to "लातविया",
    "LY" to "लीबिया",
    "MA" to "मोरक्को",
    "MC" to "मोनाको",
    "MD" to "मॉल्डोवा",
    "ME" to "मोंटेनेग्रो",
    "MF" to "सेंट मार्टिन",
    "MG" to "मेडागास्कर",
    "MH" to "मार्सल द्वीप",
    "MK" to "उतॉरॉ मकदूनिया",
    "ML" to "माली",
    "MM" to "म्यांमार (बर्मा)",
    "MN" to "मंगोलिया",
    "MO" to "मकाऊ (एस ए आर चीन)",
    "MP" to "उतॉरॉ मारियाना द्वीप",
    "MQ" to "मार्टीनिक",
    "MR" to "मॉरिटानिया",
    "MS" to "मोंटसेरात",
    "MT" to "माल्टा",
    "MU" to "मॉरीसस",
    "MV" to "मालदीप",
    "MW" to "मलावी",
    "MX" to "मेक्सिको",
    "MY" to "मलेसिया",
    "MZ" to "मोज़ांबिक",
    "NA" to "नामीबिया",
    "NC" to "न्यू केलेडोनिया",
    "NE" to "नाइजर",
    "NF" to "नॉरप़ॉक द्वीप",
    "NG" to "नाइजीरिया",
    "NI" to "निकारागुआ",
    "NL" to "नीदरलेंड",
    "NO" to "नॉर्वे",
    "NP" to "नेपाल",
    "NR" to "नाउरु",
    "NU" to "नीयू",
    "NZ" to "न्यूज़ीलेंड",
    "OM" to "ओमान",
    "PA" to "पनामा",
    "PE" to "पेरू",
    "PF" to "प़्रेंच पोलिनेसिया",
    "PG" to "पापुआ न्यू गिनी",
    "PH" to "प़िलिपींस",
    "PK" to "पाकिस्तान",
    "PL" to "पोलेंड",
    "PM" to "सेंट पिएरे ऑड़े मिक्वेलान",
    "PN" to "पिटकेर्न द्वीप",
    "PR" to "पोर्टो रिको",
    "PS" to "प़िलिस्तीनी क्षेत्र",
    "PT" to "पुर्तगाल",
    "PW" to "पलाऊ",
    "PY" to "पराग्वे",
    "QA" to "क़तर",
    "RE" to "रियूनियन",
    "RO" to "रोमानिया",
    "RS" to "सर्बिया",
    "RU" to "रूस",
    "RW" to "र्-वांडा",
    "SA" to "सऊदी अरब",
    "SB" to "सोलोमन द्वीप",
    "SC" to "सेसेल्स",
    "SD" to "सूडान",
    "SE" to "स्वीडन",
    "SG" to "सिंगापुर",
    "SH" to "सेंट हेलेना",
    "SI" to "स्लोवेनिया",
    "SJ" to "स्वालबार्ड ऑड़े जान मायेन",
    "SK" to "स्लोवाकिया",
    "SL" to "सिएरा लियोन",
    "SM" to "सेन मेरीनो",
    "SN" to "सेनेगल",
    "SO" to "सोमालिया",
    "SR" to "सूरीनाम",
    "SS" to "दॉकिण सूडान",
    "ST" to "साओ टोम ऑड़े प्रिंसिपे",
    "SV" to "अल सल्वाडोर",
    "SX" to "सिंट माऽरतेन",
    "SY" to "सीरिया",
    "SZ" to "एस्वाटिनी",
    "TC" to "तुर्क ऑड़े केकोज़ द्वीप",
    "TD" to "चाड",
    "TF" to "प्रेंच दकिनी टेरिटोरी",
    "TG" to "टोगो",
    "TH" to "ताईलेंड",
    "TJ" to "तजाकिस्तान",
    "TK" to "तोकेलाउ",
    "TL" to "तिमोर-लेस्त",
    "TM" to "तुर्कमेनिस्तान",
    "TN" to "ट्यूनीसिया",
    "TO" to "टोंगा",
    "TR" to "तुर्की",
    "TT" to "त्रिनिदाद ऑड़े टोबेगो",
    "TV" to "तुवालू",
    "TW" to "ताइवान",
    "TZ" to "तंज़ानिया",
    "UA" to "यूक्रेन",
    "UG" to "युगांडा",
    "UM" to "यू॰एस॰ आउटलाइंग द्वीप",
    "US" to "आण्डि ति राज्यॉ",
    "UY" to "उरूग्वे",
    "UZ" to "उज़्बेकिस्तान",
    "VA" to "बाटिकान सिटी",
    "VC" to "सेंट विंसेंट ऑड़े ग्रेनाडाइंस",
    "VE" to "वेनेज़ुएला",
    "VG" to "ब्रिटिस वर्जिन द्वीप",
    "VI" to "यू॰एस॰ वर्जिन द्वीप",
    "VN" to "वियतनाम",
    "VU" to "वनुआतू",
    "WF" to "वालिस ऑड़े प़्यूचूना",
    "WS" to "समोआ",
    "XK" to "कोसोवो",
    "YE" to "यमन",
    "YT" to "मायोते",
    "ZA" to "दॉकिण आप़्रीका",
    "ZM" to "ज़ाम्बिया",
    "ZW" to "ज़िम्बाब्वे",
  ) }

  val kxv_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "raji, purti",
    "419" to "laṭin amerika",
    "AD" to "ānḍorā",
    "AE" to "aanḍiti arab emireṭs",
    "AF" to "aapganistan",
    "AG" to "eṇṭigaa aḍe barbuḍaa",
    "AI" to "anguila",
    "AL" to "albania",
    "AM" to "aarmenia",
    "AO" to "angola",
    "AQ" to "ānṭarkṭikā",
    "AR" to "aarhenṭina",
    "AS" to "amerikati samva",
    "AT" to "austria",
    "AU" to "astrelia",
    "AW" to "aruba",
    "AX" to "eleṇḍ dīp",
    "AZ" to "ajerbaijan",
    "BA" to "bajnia aḍe hertsegovina",
    "BB" to "barbaḍos",
    "BD" to "banglades",
    "BE" to "beljiym",
    "BF" to "burkina paso",
    "BG" to "bulgaria",
    "BH" to "bāren",
    "BI" to "buruṇḍī",
    "BJ" to "benīn",
    "BL" to "se barṭelemi",
    "BM" to "bermuḍā",
    "BN" to "brunae",
    "BO" to "boliviā",
    "BQ" to "karibiyn nedrlends",
    "BR" to "brājil",
    "BS" to "bāhāmās",
    "BT" to "buṭān",
    "BW" to "boṭsvana",
    "BY" to "belarūs",
    "BZ" to "belīj",
    "CA" to "kanaḍa",
    "CC" to "kokos keling dīp",
    "CD" to "kongo - kinsasa",
    "CF" to "madini aaprika republik",
    "CG" to "kongo - brajavil",
    "CH" to "svitjerlaṇḍ",
    "CI" to "koṭ ḍi vaa",
    "CK" to "kuk dīp",
    "CL" to "cili",
    "CM" to "kemarun",
    "CN" to "caina",
    "CO" to "kolmbiaa",
    "CR" to "kosta rika",
    "CU" to "kyuba",
    "CV" to "kep vrḍi",
    "CW" to "kyurasao",
    "CX" to "kristmas dīp",
    "CY" to "saipras",
    "CZ" to "cekiya",
    "DE" to "jermanī",
    "DG" to "ḍiego garsia",
    "DJ" to "jibutī",
    "DK" to "ḍenmark",
    "DM" to "dominika",
    "DO" to "dominikan republik",
    "DZ" to "aljīriaa",
    "EA" to "seuṭa aḍe melila",
    "EC" to "ekvaḍor",
    "EE" to "esṭoniya",
    "EG" to "ījipṭ",
    "EH" to "vedakuṇpu sahara",
    "ER" to "īriṭriaa",
    "ES" to "spein",
    "ET" to "ītiyopiya",
    "FI" to "pinlaṇd",
    "FJ" to "piji",
    "FK" to "paklaṇd dīp",
    "FM" to "micronesiaa",
    "FO" to "pēro dīp",
    "FR" to "prans",
    "GA" to "gbon",
    "GB" to "uniṭeḍ kingḍom",
    "GD" to "graneida",
    "GE" to "jeorjiaa",
    "GF" to "prenc guiyana",
    "GG" to "grnse",
    "GH" to "gana",
    "GI" to "jbralṭr",
    "GL" to "grīnlanḍ",
    "GM" to "gambia",
    "GN" to "gini",
    "GP" to "gvadelup",
    "GQ" to "ikveṭorial gini",
    "GR" to "grīs",
    "GS" to "dakiṇ jārjiā aḍe dakiṇ sandwich dīp",
    "GT" to "gvaṭemala",
    "GU" to "guām",
    "GW" to "gini-bisau",
    "GY" to "guyana",
    "HK" to "hong kong (sar) caina",
    "HN" to "honḍuras",
    "HR" to "kroesia",
    "HT" to "haiti",
    "HU" to "hungarī",
    "IC" to "kanari dīp",
    "ID" to "inḍonesiya",
    "IE" to "aayarlanḍ",
    "IL" to "israel",
    "IM" to "aail āp man",
    "IN" to "inḍiā",
    "IO" to "briṭis inḍiāti samudra handi",
    "IQ" to "irak",
    "IR" to "iran",
    "IS" to "aislanḍ",
    "IT" to "iṭalī",
    "JE" to "jersī",
    "JM" to "jamaika",
    "JO" to "jorḍan",
    "JP" to "japan",
    "KE" to "kenya",
    "KG" to "kirgistan",
    "KH" to "kamboḍia",
    "KI" to "kiribaṭi",
    "KM" to "komoros",
    "KN" to "seint kiṭs āḍe nebis",
    "KP" to "uttar koriya",
    "KR" to "dkiṇ koriyaa",
    "KW" to "kuvet",
    "KY" to "keimen dīp",
    "KZ" to "kajakstan",
    "LA" to "laos",
    "LB" to "lebanon",
    "LC" to "seint lusiya",
    "LI" to "likṭensṭein",
    "LK" to "sri lanka",
    "LR" to "laiberīya",
    "LS" to "lesotho",
    "LT" to "liṭuaania",
    "LU" to "lksemborg",
    "LV" to "laṭviya",
    "LY" to "libya",
    "MA" to "morkko",
    "MC" to "monako",
    "MD" to "molḍovaa",
    "ME" to "monṭenegro",
    "MF" to "seint martin",
    "MG" to "madagascar",
    "MH" to "marsall dīp",
    "MK" to "uttar mesiḍoniya",
    "ML" to "mali",
    "MM" to "myanmar (brma)",
    "MN" to "mongolia",
    "MO" to "makao sar cina",
    "MP" to "uttar mariyana dīp",
    "MQ" to "marṭinik",
    "MR" to "mauriṭaniya",
    "MS" to "monṭserrarṭ",
    "MT" to "malṭaa",
    "MU" to "mauriss",
    "MV" to "māldīp",
    "MW" to "malavī",
    "MX" to "meksīko",
    "MY" to "maleseāā",
    "MZ" to "mojambik",
    "NA" to "namibia",
    "NC" to "nyu keleḍoniya",
    "NE" to "naījr",
    "NF" to "norpok dīp",
    "NG" to "naigeria",
    "NI" to "nikaraguaa",
    "NL" to "nederlanḍs",
    "NO" to "norvay",
    "NP" to "nepal",
    "NR" to "nauru",
    "NU" to "niyu",
    "NZ" to "nyu jīlanḍ",
    "OM" to "oman",
    "PA" to "panema",
    "PE" to "peru",
    "PF" to "prenc",
    "PG" to "papua nyu gini",
    "PH" to "pilippines",
    "PK" to "pakistan",
    "PL" to "polanḍ",
    "PM" to "seint pierri ande mikelon",
    "PN" to "piṭkarn dīp",
    "PR" to "puerto rico",
    "PS" to "palesṭiati handi",
    "PT" to "portugal",
    "PW" to "palau",
    "PY" to "pareguvai",
    "QA" to "katar",
    "RE" to "riyuniyn",
    "RO" to "romaniya",
    "RS" to "serbia",
    "RU" to "russia",
    "RW" to "rvanḍa",
    "SA" to "saūdi arabiya",
    "SB" to "soloman dīp",
    "SC" to "siselles",
    "SD" to "suḍan",
    "SE" to "sviḍen",
    "SG" to "singapor",
    "SH" to "seint helena",
    "SI" to "slovenia",
    "SJ" to "svalbard aḍe jan mayen",
    "SK" to "slovakia",
    "SL" to "sierra leyon",
    "SM" to "san marino",
    "SN" to "senegal",
    "SO" to "somaliya",
    "SR" to "surīname",
    "SS" to "dkiṇ sūdan",
    "ST" to "sao tom aḍe prinsipe",
    "SV" to "el salvador",
    "SX" to "sint mārṭen",
    "SY" to "sīriya",
    "SZ" to "esvaṭini",
    "TC" to "turks aḍe keikes dīp",
    "TD" to "cad",
    "TF" to "prēnch dakiṇ teritorī",
    "TG" to "ṭogo",
    "TH" to "tailanḍ",
    "TJ" to "tajākīstān",
    "TK" to "ṭokelau",
    "TL" to "ṭimor - leste",
    "TM" to "turkmenīstān",
    "TN" to "ṭunisiaa",
    "TO" to "ṭonga",
    "TR" to "turkī",
    "TT" to "ṭriniḍaḍ aḍe ṭobego",
    "TV" to "tuvala",
    "TW" to "taivan",
    "TZ" to "ṭanjaniya",
    "UA" to "yūkrain",
    "UG" to "yūganḍa",
    "UM" to "yu.es. aautlaing dīp",
    "US" to "yunaiṭeḍ stets",
    "UY" to "ūrugve",
    "UZ" to "ūjbekistaan",
    "VA" to "bāṭikān",
    "VC" to "seint vinseṇṭ aḍe grenaḍi",
    "VE" to "venejuela",
    "VG" to "briṭis vrjin dīp",
    "VI" to "yu.es. vrjin dīp",
    "VN" to "viyetnam",
    "VU" to "vanuaatu",
    "WF" to "vallis aḍe puṭuna",
    "WS" to "samoaa",
    "XK" to "kosovo",
    "YE" to "yemen",
    "YT" to "mayoṭṭ",
    "ZA" to "dkīṇ aaprika",
    "ZM" to "jambiya",
    "ZW" to "jimbabve",
  ) }

  val kxv_Orya: ImmutableMap<String, String> by lazy { immutableMapOf(
    "419" to "ଲାଟିନ୍‌ ଆମେରିକା",
    "AD" to "ଆଣ୍ଡୋରା",
    "AE" to "ଆଣ୍ଡିତି ଆରବ ଏମିରେଟସ୍",
    "AF" to "ଆପଗାନିସ୍ତାନ୍",
    "AG" to "ଏଣ୍ଟିଗୁଆ ଅଡ଼େ ବାରବୁଦା",
    "AI" to "ଏଙ୍ଗ୍ୱିଲା",
    "AL" to "ଆଲବାନିଆ",
    "AM" to "ଆର୍ମେନିଆ",
    "AO" to "ଅଙ୍ଗଲା",
    "AQ" to "ଆଣ୍ଟାର୍କଟିକା",
    "AR" to "ଅର୍ଜେଣ୍ଟିନା",
    "AS" to "ଅମେରିକା ତି ସମୱା",
    "AT" to "ଅଷ୍ଟ୍ରିଆ",
    "AU" to "ଅଷ୍ଟ୍ରେଲିଆ",
    "AW" to "ଅରୁବା",
    "AX" to "ଏଲେଣ୍ଡ",
    "AZ" to "ଅଜେର୍‍‍ବାଇଜାନ୍",
    "BA" to "ବସ୍ନିଆ ଅଡ଼େ ହର୍ଜଗୱିନା",
    "BB" to "ବାର୍‍ବଡସ",
    "BD" to "ବାଂଲାଦେଶ",
    "BE" to "ବେଲଜିୟମ୍",
    "BF" to "ବୁର୍କିନା ପାସ୍ୱ",
    "BG" to "ବୁଲ୍‍ଗାରିଆ",
    "BH" to "ବହରେନ୍",
    "BI" to "ବୁରୁନ୍ଦି",
    "BJ" to "ବେନିନ୍",
    "BL" to "ସେଣ୍ଟ ବାର୍ତେଲେମି",
    "BM" to "ବର୍‍ମୁଣ୍ଡା",
    "BN" to "ବ୍ରୂନେଇ",
    "BO" to "ବଲିୱିୟା",
    "BQ" to "କାରିବିୟନ ନେଦରଲ୍ୟାଣ୍ଡସ୍",
    "BR" to "ବ୍ରାଜିଲ୍",
    "BS" to "ବାହାମାସ୍",
    "BT" to "ବୁଟାନ",
    "BW" to "ବସ୍ଟୱାନା",
    "BY" to "ବେଲାରୂସ୍",
    "BZ" to "ବେଲିଜ୍",
    "CA" to "କାନାଡା",
    "CC" to "କକସ୍ (କିଲିଂ) ଦିପ",
    "CD" to "କଙ୍ଗ-କିଂସାସା",
    "CF" to "ମାଦିନି ଆପ୍ରିକା ରିପବ୍ଲିକ୍",
    "CG" to "କଂଙ୍ଗ- ବ୍ରାଜାୱିଲି",
    "CH" to "ସ୍ୱୀଜଅର୍‍ଲାଣ୍ଡ",
    "CI" to "କଟ ଡି ୱା",
    "CK" to "କୁକ ଦିପ",
    "CL" to "ଚିଲି",
    "CM" to "କାମେରନ୍",
    "CN" to "ଚିନ୍",
    "CO" to "କଲମ୍ବିଆ",
    "CR" to "କସ୍ଟା ରିକା",
    "CU" to "କ୍ୟୁବା",
    "CV" to "କେପ୍ ୱଡ଼",
    "CW" to "କ୍ୟୁରାସାଅ",
    "CX" to "କ୍ରିସ୍ଟମାସ୍ ଦିପ",
    "CY" to "ସାଇପ୍ରସ୍",
    "CZ" to "ଚେକିଆ",
    "DE" to "ଜର୍ମାନି",
    "DG" to "ଡିଏଗ ଗାର୍ସିଆ",
    "DJ" to "ଜିବୁତି",
    "DK" to "ଡେନମାର୍କ",
    "DM" to "ଡମିନିକା",
    "DO" to "ଡମିନିକା ତି ରିପବ୍ଲିକ୍",
    "DZ" to "ଅଲଜେରିଆ",
    "EA" to "ସେଅଟା ଅଡ଼େ ମେଲିଲା",
    "EC" to "ଇକ୍ୱାଡର",
    "EE" to "ଏସ୍ଟନିଆ",
    "EG" to "ଇଜିପ୍ଟ",
    "EH" to "ୱେଡ଼ାକୁଣ୍ପୁ ସାହାରା",
    "ER" to "ଇରିଟ୍ରିଆ",
    "ES" to "ସ୍ପେନ୍",
    "ET" to "ଇତିୟପିଆ",
    "FI" to "ପିନ୍‍ଲାଣ୍ଡ",
    "FJ" to "ପିଜି",
    "FK" to "ପାକ୍‍ଲାଣ୍ଡ ଦିପ",
    "FM" to "ମାକ୍ରନେସିଆ",
    "FO" to "ପେରୋ ଦୀପ",
    "FR" to "ପ୍ରାନ୍ସ",
    "GA" to "ଗାବନ",
    "GB" to "ଇଉନାଇଟେଡ୍ କିଂଡମ୍",
    "GD" to "ଗ୍ରେନାଡା",
    "GE" to "ଜର୍ଜିଆ",
    "GF" to "ପ୍ରେଞ୍ଚ୍ ଗୁୟାନା",
    "GG" to "ଗର୍ନସି",
    "GH" to "ଗାନା",
    "GI" to "ଜିବ୍ରାଲଟର",
    "GL" to "ଗ୍ରୀନ୍ ଲାଣ୍ଡ",
    "GM" to "ଗାମ୍ବିଆ",
    "GN" to "ଗିନି",
    "GP" to "ଗ୍ୱାଡେଲୁପ",
    "GQ" to "ଇକ୍ୟୁଏଟେରିୟଲ ଗିନି",
    "GR" to "ଗ୍ରିସ୍",
    "GS" to "ଦକିନ ଜର୍ଜିଆ ଅଡ଼େ ଦକିନ ସାଣ୍ଡୱିଚ୍ ଦୀପ",
    "GT" to "ଗ୍ୱାଟେମାଲା",
    "GU" to "ଗୁଆମ୍",
    "GW" to "ଗିନି ବିସାଉ",
    "GY" to "ଗୁୟାନା",
    "HK" to "ହଂଗ କଂଗ (ଏସଏଆର୍ ଚିନା)",
    "HN" to "ହଣ୍ଡୁରାସ",
    "HR" to "କ୍ରସିଆ",
    "HT" to "ହାଇତି",
    "HU" to "ହଙ୍ଗେରି",
    "IC" to "କେନାରି ଦିପ",
    "ID" to "ଇଣ୍ଡନେସିୟା",
    "IE" to "ଅଇରଲାଣ୍ଡ",
    "IL" to "ଇସରାଇଲ",
    "IM" to "ମାଣିସି ତା ଦିପ",
    "IN" to "ବାରତ",
    "IO" to "ବ୍ରିଟିସ୍ ହିନ୍ଦ ସାମୁଦ୍ରି ହାନ୍ଦି",
    "IQ" to "ଇରାକ",
    "IR" to "ଇରାନ",
    "IS" to "ଆଇସଲାଣ୍ଡ",
    "IT" to "ଇଟାଲି",
    "JE" to "ଜରସି",
    "JM" to "ଜାମାଇକା",
    "JO" to "ଜର୍ଡାନ",
    "JP" to "ଜାପାନ",
    "KE" to "କେନ୍ୟା",
    "KG" to "କିରଗିସ୍ତାନ",
    "KH" to "କମ୍ବଡିଆ",
    "KI" to "କିରିବାତି",
    "KM" to "କମରସ",
    "KN" to "ସେଣ୍ଟ. କିଟ୍ସ ଅଡ଼େ ନେବିସ",
    "KP" to "ଉତର କରିୟା",
    "KR" to "ଦକିଣ କରିୟା",
    "KW" to "କୁୱେତ୍",
    "KY" to "କାଇମାନ ଦିପ",
    "KZ" to "କାଜାକସ୍ତାନ",
    "LA" to "ଲାଅସ୍",
    "LB" to "ଲେବନାନ",
    "LC" to "ସେଣ୍ଟ. ଲୁସିଆ",
    "LI" to "ଲିକ୍‍ଟନ୍‍ସ୍ଟାଇନ୍",
    "LK" to "ସ୍ରି ଲଙ୍କା",
    "LR" to "ଲାଇବେରିଆ",
    "LS" to "ଲେସତ",
    "LT" to "ଲିତୁଆନିଆ",
    "LU" to "ଲଗ୍ଜମବର୍ଗ",
    "LV" to "ଲାତ୍‍ୱିୟା",
    "LY" to "ଲିବିୟା",
    "MA" to "ମରକ",
    "MC" to "ମନାକ",
    "MD" to "ମଲ୍‍ଡୱା",
    "ME" to "ମଣ୍ଟେନେଗ୍ର",
    "MF" to "ସେଣ୍ଟ ମାର୍ଟିନ",
    "MG" to "ମାଡ଼ାଗାସ୍କାର",
    "MH" to "ମାର୍ସାଲ ଦିପ",
    "MK" to "ଉତର ମାସାଡନିୟା",
    "ML" to "ମାଲି",
    "MM" to "ମିୟାଁମାର (ବର୍ମା)",
    "MN" to "ମଙ୍ଗଲିୟା",
    "MO" to "ମକାଉ ଏସଏଆର ଚିନା",
    "MP" to "ଉତର ମାରିୟାନ ଦିପ",
    "MQ" to "ମାର୍ଟିନିକ୍",
    "MR" to "ମଉରିଟାନିୟା",
    "MS" to "ମଣ୍ଟସେରେଟ",
    "MT" to "ମାଲ୍ଟା",
    "MU" to "ମରିସସ୍",
    "MV" to "ମାଲଦୀପି",
    "MW" to "ମଲାୱି",
    "MX" to "ମେକ୍ସିକ",
    "MY" to "ମାଲେସିଆ",
    "MZ" to "ମଜାମ୍ବିକ",
    "NA" to "ନାମିବିୟା",
    "NC" to "ନ୍ୟୁ କେଲେଡନିୟା",
    "NE" to "ନାଇଜର",
    "NF" to "ନର୍‍ପକ୍ ଦିପ",
    "NG" to "ନାଇଜେରିଆ",
    "NI" to "ନିକାରଗୁଆ",
    "NL" to "ନେଦରଲାଣ୍ଡ",
    "NO" to "ନରୱେ",
    "NP" to "ନେପାଲ",
    "NR" to "ନାଉରୁ",
    "NU" to "ନିୟୁ",
    "NZ" to "ନିୟୁଜିଲାଣ୍ଡ",
    "OM" to "ଅମାନ",
    "PA" to "ପନମା",
    "PE" to "ପେରୁ",
    "PF" to "ପ୍ରେଞ୍ଚ୍ ପଲିନେସିୟା",
    "PG" to "ପପୁଆ ନିୟୁ ଗିନି",
    "PH" to "ପିଲିପାଇନ୍ସ",
    "PK" to "ପାକିସ୍ତାନ",
    "PL" to "ପଲାଣ୍ଡ",
    "PM" to "ସେଣ୍ଟ ପିଏରେ ଅଡ଼େ ମିକ୍ୱେଲାନ",
    "PN" to "ପିଟ୍‍କଇର୍ନ୍ ଦିପ",
    "PR" to "ପର୍ଟ ରିକ",
    "PS" to "ପାଲେସ୍ଟିଆତି ହାନ୍ଦି",
    "PT" to "ପର୍ତୁଗାଲ",
    "PW" to "ପଲାଉ",
    "PY" to "ପରଗ୍ୱେ",
    "QA" to "କତର",
    "RE" to "ରିୟୁନିୟନ",
    "RO" to "ରମାନିଆ",
    "RS" to "ସର୍ବିୟା",
    "RU" to "ରୁସିଆ",
    "RW" to "ର୍‍ୱାଣ୍ଡା",
    "SA" to "ସାଉଦି ଆରବ",
    "SB" to "ସଲମନ ଦିପ",
    "SC" to "ସିସେଲ୍ସ",
    "SD" to "ସୁଡାନ",
    "SE" to "ସ୍ୱିଡେନ",
    "SG" to "ସିଙ୍ଗାପୁର",
    "SH" to "ସେଣ୍ଟ ହେଲେନ",
    "SI" to "ସ୍ଲବେନିଆ",
    "SJ" to "ସ୍ୱାଲବାର୍ଡ ଅଡ଼େ ଜାନ ମାୟେନ",
    "SK" to "ସ୍ଲବାକିୟା",
    "SL" to "ସିଏରା ଲିୟନ",
    "SM" to "ସନ ମାରିନ",
    "SN" to "ସେନେଗାଲ",
    "SO" to "ସମାଲିଆ",
    "SR" to "ସୁରିନାମ",
    "SS" to "ଦକିଣ ସୁଡାନ",
    "ST" to "ସାଅ ଟମ ଅଡ଼େ ପ୍ରିନ୍ସିପେ",
    "SV" to "ଅଲ ସଲବାଡର",
    "SX" to "ସିଣ୍ଟ ମାର୍ଟିନ",
    "SY" to "ସିରିୟା",
    "SZ" to "ଏସ୍ୱାଟିନି",
    "TC" to "ତୁର୍କ ଅଡ଼େ କାଇକସ ଦିପ",
    "TD" to "ଚାଡ",
    "TF" to "ପ୍ରେଞ୍ଚ ଦକିନୀୟ ଟେରିଟୋରୀ",
    "TG" to "ଟଗ",
    "TH" to "ତାଇଲାଣ୍ଡ",
    "TJ" to "ତାଜିକିସ୍ତାନ",
    "TK" to "ତକେଲାଉ",
    "TL" to "ତିମର-ଲେସ୍ତେ",
    "TM" to "ତୁର୍କମେନିସ୍ତାନ",
    "TN" to "ଟ୍ୟୁନିସିୟା",
    "TO" to "ଟଙ୍ଗ",
    "TR" to "ତୁର୍କି",
    "TT" to "ତ୍ରିନିଡାଡ ଅଡ଼େ ଟବାଗ",
    "TV" to "ତୁୱାଲୁ",
    "TW" to "ତାଇୱାନ",
    "TZ" to "ତାଞ୍ଜାନିୟା",
    "UA" to "ୟୁକ୍ରେନ୍",
    "UG" to "ଉଗାଣ୍ଡା",
    "UM" to "ୟୁ ଏସ୍ ଆଉଟଲାଇଙ୍କ ଦିପ",
    "US" to "ଆଣ୍ଡିତି ରାଜ୍ୟ",
    "UY" to "ଉରୁଗ୍ୱେ",
    "UZ" to "ଉଜବେକିସ୍ତାନ",
    "VA" to "ବାଟିକାନ୍ ସିଟି",
    "VC" to "ସେଣ୍ଟ ୱିନସେଣ୍ଟ ଅଡ଼େ ଗ୍ରିନାଡାଇନ୍ସ",
    "VE" to "ୱେନେଜୁଏଲ",
    "VG" to "ବ୍ରିଟିସ୍ ୱିରଜିନ ଦିପ",
    "VI" to "ୟୁ ଏସ ୱିରଜିନ ଦିପ",
    "VN" to "ୱିଏତନାମ",
    "VU" to "ୱାନୁଆତୁ",
    "WF" to "ୱାଲିସ ଅଡ଼େ ପୁଟୁନା",
    "WS" to "ସମୱା",
    "XK" to "କସୱ",
    "YE" to "ୟମନ",
    "YT" to "ମାୟତେ",
    "ZA" to "ଦକିଣ ଆପ୍ରିକା",
    "ZM" to "ଜାମ୍ବିୟା",
    "ZW" to "ଜିମ୍ବାୱେ",
  ) }

  val kxv_Telu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "ప్రపంచం",
    "419" to "లాటిన్ ఆమెరిక",
    "AD" to "ఆండొర",
    "AE" to "యునైటెడ్ ఆరబ్ ఎమిరేబ్స్",
    "AF" to "ఆప్గనిస్తాన్",
    "AG" to "ఆంటిగ్వా మరియు బార్బుడా",
    "AI" to "ఆంగ్విల్లా",
    "AL" to "ఆల్లేనియా",
    "AM" to "ఆర్మేనియా",
    "AO" to "ఆంగోలా",
    "AQ" to "ఆంటార్కటికా",
    "AR" to "ఆర్జెంటినా",
    "AS" to "ఆమెరికన్ సమూవా",
    "AT" to "ఆస్ట్రీయా",
    "AU" to "ఆస్ట్రేలియా",
    "AW" to "ఆరుబా",
    "AX" to "ఆలాండ్ దీపులు",
    "AZ" to "ఆజర్బైజాన్",
    "BA" to "బోస్నియా మరియు బెర్జిగోవినా",
    "BB" to "బార్బడోస్",
    "BD" to "బంగ్లాదేస్",
    "BE" to "బెల్జియం",
    "BF" to "బుర్కినా పాసో",
    "BG" to "బుల్గేరియ",
    "BH" to "బహరిన్",
    "BI" to "బురుండి",
    "BJ" to "బెనిన్",
    "BL" to "సెంట్ బర్తెలిమి",
    "BM" to "బర్ముడా",
    "BN" to "బ్రునేఇ",
    "BO" to "బొలివియా",
    "BQ" to "కరీబియన్ నెదర్లాండ్స",
    "BR" to "బ్రాజిల్",
    "BS" to "బహామాస్",
    "BT" to "బుటాన్",
    "BW" to "బోట్స్వానా",
    "BY" to "బెలారస్",
    "BZ" to "బెలిజ్",
    "CA" to "కెనడా",
    "CC" to "కోకోస్ (కీలింగ్) దీవులు",
    "CD" to "కాంగో కిన్సాసా",
    "CF" to "సెంట్రల్ ఆప్రికన్ రిపబ్లిక్",
    "CG" to "కాంగో- బ్రాజావిల్లి",
    "CH" to "స్విజర్లాండ్",
    "CI" to "కోట్ డి ఐవోర్",
    "CK" to "కుక్ దీపులు",
    "CL" to "చిలి",
    "CM" to "కామెరూన్",
    "CN" to "చినా",
    "CO" to "కొలంబియా",
    "CR" to "కోస్టా రికా",
    "CU" to "క్యూబా",
    "CV" to "కేప్ వడ్",
    "CW" to "క్వురసో",
    "CX" to "క్రిస్ట మాస్ దీపుపు",
    "CY" to "సైప్రస్",
    "CZ" to "చెకియా",
    "DE" to "జర్మనీ",
    "DG" to "డియాగో గార్సియా",
    "DJ" to "జిబుతి",
    "DK" to "డెన్మార్క",
    "DM" to "డొమినికా",
    "DO" to "డొమినికాన్ రిపబ్లిక్",
    "DZ" to "ఆల్జిరియా",
    "EA" to "స్యూటా & మెలిల్లా",
    "EC" to "ఈక్వడార్",
    "EE" to "ఎస్టోనియా",
    "EG" to "ఈజిప్ట్",
    "EH" to "పడమటి సహారా",
    "ER" to "ఇరిట్రియా",
    "ES" to "స్పెన్",
    "ET" to "ఇతియోపియా",
    "FI" to "పిన్లాండ్",
    "FJ" to "పిజీ",
    "FK" to "ఫాక్‌ల్యాండ్ దీవులు",
    "FM" to "మైక్రోనేసియా",
    "FO" to "పెరొ దీప",
    "FR" to "ప్రాన్స్",
    "GA" to "గాబన్",
    "GB" to "యునైటెడ్ కింగ్‌డమ్",
    "GD" to "గ్రెనడా",
    "GE" to "జార్జియా",
    "GF" to "ప్రెంచ్ గుయానా",
    "GG" to "గర్నసీ",
    "GH" to "గనా",
    "GI" to "జిబ్రాల్టర్",
    "GL" to "గ్రీన్లండ్",
    "GM" to "గంబియా",
    "GN" to "గినియా",
    "GP" to "గ్వడెలుప్",
    "GQ" to "ఈక్వటోరియల్ గినియా",
    "GR" to "గ్రీస్",
    "GS" to "దకిన జర్జిఆ అదే దకిన సండవిచ్ దిప",
    "GT" to "గ్వటెమాలా",
    "GU" to "గ్వమ్",
    "GW" to "గినియా-బిస్సావ్",
    "GY" to "గుయానా",
    "HK" to "హాంకాంగ్ ఎస్ఎఆర్ చినా",
    "HN" to "హండురాస్",
    "HR" to "క్రొయేసియా",
    "HT" to "హైటి",
    "HU" to "హంగేరీ",
    "IC" to "కేనరీ దీపులు",
    "ID" to "ఇండోనేసియా",
    "IE" to "ఐర్లాండ్",
    "IL" to "ఇజ్రాయెల్",
    "IM" to "ఐల్ ఆప్ మాన్",
    "IN" to "బారతదెసాం",
    "IO" to "బ్రిటిస్ హీందూ మహాసముద్ర ప్రాంతం",
    "IQ" to "ఇరాక్",
    "IR" to "ఇరాన్",
    "IS" to "ఐస్లాండ్",
    "IT" to "ఇటలి",
    "JE" to "జెర్సీ",
    "JM" to "జమైకా",
    "JO" to "జోర్డాన్",
    "JP" to "జపాన్",
    "KE" to "కెన్యా",
    "KG" to "కిర్గజిస్తాన్",
    "KH" to "కంబోడియా",
    "KI" to "కీరిబాటి",
    "KM" to "కొమొరోస్",
    "KN" to "సెయింట్ కిట్స్ మరియు నెవిస్",
    "KP" to "ఉత్తర కొరియా",
    "KR" to "దకిణ కొరియా",
    "KW" to "కువైట్",
    "KY" to "కేమాన్ దీపులు",
    "KZ" to "కజకిస్తాన్",
    "LA" to "లావోస్",
    "LB" to "లెబనాన్",
    "LC" to "సెయింట్ లూసియా",
    "LI" to "లిక్టెన్‌స్టెయిన్",
    "LK" to "స్రీ లంక",
    "LR" to "లైబీరియా",
    "LS" to "లెసోతో",
    "LT" to "లీతువేనియ",
    "LU" to "లక్సెంబర్గ్",
    "LV" to "లాత్వియా",
    "LY" to "లిబియా",
    "MA" to "మొరాకో",
    "MC" to "మొనాకో",
    "MD" to "మోల్డొవా",
    "ME" to "మాంటెనెగ్రో",
    "MF" to "సెయింట్ మార్టిన్",
    "MG" to "మడగాస్కర్",
    "MH" to "మార్సాల్ దీపులు",
    "MK" to "ఉత్తర మాసిడోనియా",
    "ML" to "మాలి",
    "MM" to "మయన్మార్ (బర్మా)",
    "MN" to "మంగోలియా",
    "MO" to "మకావ్ ఎస్ఏఆర్ చైనా",
    "MP" to "ఉత్తర మరియానా దీవులు",
    "MQ" to "మార్ర్టనీక్",
    "MR" to "మౌరిటేనియా",
    "MS" to "మాంట్సెరాట్",
    "MT" to "మాల్డా",
    "MU" to "మారిసస్",
    "MV" to "మాలదిపి",
    "MW" to "మలావీ",
    "MX" to "మెక్సికో",
    "MY" to "మలేసియా",
    "MZ" to "మొజాంబిక్",
    "NA" to "నమీబియా",
    "NC" to "క్రొత్త కెలెడోనియా",
    "NE" to "నఇజర్",
    "NF" to "నార్పోక్ దీవ",
    "NG" to "నౌజీరియా",
    "NI" to "నికరాగువా",
    "NL" to "నెదర్లాండ్స్",
    "NO" to "నార్వే",
    "NP" to "నేపాల్",
    "NR" to "నౌరు",
    "NU" to "నియూ",
    "NZ" to "న్యూజిలాండ్",
    "OM" to "ఓమన్",
    "PA" to "పనామా",
    "PE" to "పెరూ",
    "PF" to "ప్రెంచ్ పోలినిసియా",
    "PG" to "పాపువా న్యూ గనియా",
    "PH" to "పిలిప్పైన్స్",
    "PK" to "పాకిస్తాన్",
    "PL" to "పోలాండ్",
    "PM" to "సెయింట్ పియెర్ మరియు మికెలాన్",
    "PN" to "పిట్‌కెయిర్న్ దీవులు",
    "PR" to "ప్యూర్టో రికో",
    "PS" to "పాలస్తీనియన్ ప్రాంతాలు",
    "PT" to "పోర్చుగల్",
    "PW" to "పాలావ్",
    "PY" to "పరాగ్వే",
    "QA" to "కతార",
    "RE" to "రీయూనియన్",
    "RO" to "రోమేనియా",
    "RS" to "సెర్బియా",
    "RU" to "రస్యా",
    "RW" to "రువాండా",
    "SA" to "సౌదీ అరేబియా",
    "SB" to "సోలమన్ దీవులు",
    "SC" to "సీషెల్స్",
    "SD" to "సూడాన్",
    "SE" to "స్వీడన్",
    "SG" to "సింగపూర్",
    "SH" to "సెయింట్ హెలెనా",
    "SI" to "స్లోవేనియా",
    "SJ" to "స్వాల్‌బార్డ్ మరియు జాన్ మాయెన్",
    "SK" to "స్లొవేకియా",
    "SL" to "సియెర్రా లియాన్",
    "SM" to "సస్ మారిసో",
    "SN" to "సెనెగల్",
    "SO" to "సోమలియా",
    "SR" to "సూరినామ్",
    "SS" to "దక్షిణ సూడాన్",
    "ST" to "సావో టోమ్ మరియు ప్రిన్సిపి",
    "SV" to "ఎల్ సాల్వడోర్",
    "SX" to "సింట్ మార్టెన్",
    "SY" to "సిరియా",
    "SZ" to "ఈస్వాటిని",
    "TC" to "టర్క్స్ మరియు కైకోస్ దీవులు",
    "TD" to "చాద్",
    "TF" to "ప్రెంచ్ దకినియ టెరిటొరి",
    "TG" to "టోగో",
    "TH" to "తయిలాండ్",
    "TJ" to "తాజాకిస్తాన",
    "TK" to "టోకెలావ్",
    "TL" to "టిమోర్-లెస్టె",
    "TM" to "తుర్క్‍మెనిస్తన్",
    "TN" to "ట్యునీషియా",
    "TO" to "టోంగా",
    "TR" to "టర్కీ",
    "TT" to "ట్రినిడాడ్ మరియు టొబాగో",
    "TV" to "టువాలు",
    "TW" to "తైవాన్",
    "TZ" to "టాంజానియా",
    "UA" to "ఉక్రెయిన్",
    "UG" to "ఉగాండా",
    "UM" to "సంయుక్త రాజ్య అమెరికా బయట ఉన్న దీవులు",
    "US" to "యునైటెడ్ స్టేట్స్",
    "UY" to "ఉరుగ్వే",
    "UZ" to "ఉజ్బెకిస్తాన్",
    "VA" to "బాటికాన్ సిటి",
    "VC" to "సెయింట్ విన్సెంట్ మరియు గ్రెనడీన్స్",
    "VE" to "వెనిజులా",
    "VG" to "బ్రిటిష్ వర్జిన్ దీవులు",
    "VI" to "యు.ఎస్. వర్జిన్ దీవులు",
    "VN" to "వియత్నాం",
    "VU" to "వనాటు",
    "WF" to "వాల్లిస్ మరియు ఫుటునా",
    "WS" to "సమోవా",
    "XK" to "కొసోవో",
    "YE" to "యెమెన్",
    "YT" to "మాయొట్",
    "ZA" to "దకిణ అప్రికా",
    "ZM" to "జంబియా",
    "ZW" to "జింబాబ్వే",
  ) }

  val ky: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Дүйнө",
    "002" to "Африка",
    "003" to "Түндүк Америка",
    "005" to "Түштүк Америка",
    "009" to "Океания",
    "011" to "Батыш Африка",
    "013" to "Борбордук Америка",
    "014" to "Чыгыш Африка",
    "015" to "Түндүк Африка",
    "017" to "Борбордук Африка",
    "018" to "Түштүк Африка",
    "019" to "Америка",
    "021" to "Түндүк Америка (чөлкөм)",
    "029" to "Кариб аралдары",
    "030" to "Чыгыш Азия",
    "034" to "Түштүк Азия",
    "035" to "Түштүк-Чыгыш Азия",
    "039" to "Түштүк Европа",
    "053" to "Австралазия",
    "054" to "Меланезия",
    "057" to "Микронезия чөлкөмү",
    "061" to "Полинезия",
    "142" to "Азия",
    "143" to "Борбор Азия",
    "145" to "Батыш Азия",
    "150" to "Европа",
    "151" to "Чыгыш Европа",
    "154" to "Түндүк Европа",
    "155" to "Батыш Европа",
    "202" to "Африка өлкөлөрү",
    "419" to "Латын Америкасы",
    "AC" to "Вознесение аралы",
    "AD" to "Андорра",
    "AE" to "Бириккен Араб Эмираттары",
    "AF" to "Афганистан",
    "AG" to "Антигуа жана Барбуда",
    "AI" to "Ангилья",
    "AL" to "Албания",
    "AM" to "Армения",
    "AO" to "Ангола",
    "AQ" to "Антарктида",
    "AR" to "Аргентина",
    "AS" to "Америкалык Самоа",
    "AT" to "Австрия",
    "AU" to "Австралия",
    "AW" to "Аруба",
    "AX" to "Аланд аралдары",
    "AZ" to "Азербайжан",
    "BA" to "Босния жана Герцеговина",
    "BB" to "Барбадос",
    "BD" to "Бангладеш",
    "BE" to "Бельгия",
    "BF" to "Буркина-Фасо",
    "BG" to "Болгария",
    "BH" to "Бахрейн",
    "BI" to "Бурунди",
    "BJ" to "Бенин",
    "BL" to "Сент Бартелеми",
    "BM" to "Бермуд аралдары",
    "BN" to "Бруней",
    "BO" to "Боливия",
    "BQ" to "Кариб Нидерланддары",
    "BR" to "Бразилия",
    "BS" to "Багама аралдары",
    "BT" to "Бутан",
    "BV" to "Буве аралы",
    "BW" to "Ботсвана",
    "BY" to "Беларусь",
    "BZ" to "Белиз",
    "CA" to "Канада",
    "CC" to "Кокос (Килинг) аралдары",
    "CD" to "Конго-Киншаса",
    "CF" to "Борбордук Африка Республикасы",
    "CG" to "Конго-Браззавил",
    "CH" to "Швейцария",
    "CI" to "Кот-д’Ивуар",
    "CK" to "Кук аралдары",
    "CL" to "Чили",
    "CM" to "Камерун",
    "CN" to "Кытай",
    "CO" to "Колумбия",
    "CP" to "Клиппертон аралы",
    "CR" to "Коста-Рика",
    "CU" to "Куба",
    "CV" to "Кабо-Верде",
    "CW" to "Кюрасао",
    "CX" to "Рождество аралы",
    "CY" to "Кипр",
    "CZ" to "Чехия",
    "DE" to "Германия",
    "DG" to "Диего Гарсия",
    "DJ" to "Джибути",
    "DK" to "Дания",
    "DM" to "Доминика",
    "DO" to "Доминика Республикасы",
    "DZ" to "Алжир",
    "EA" to "Сеута жана Мелилла",
    "EC" to "Эквадор",
    "EE" to "Эстония",
    "EG" to "Египет",
    "EH" to "Батыш Сахара",
    "ER" to "Эритрея",
    "ES" to "Испания",
    "ET" to "Эфиопия",
    "EU" to "Европа Биримдиги",
    "EZ" to "Еврозона",
    "FI" to "Финляндия",
    "FJ" to "Фиджи",
    "FK" to "Фолкленд аралдары",
    "FM" to "Микронезия",
    "FO" to "Фарер аралдары",
    "FR" to "Франция",
    "GA" to "Габон",
    "GB" to "Улуу Британия",
    "GD" to "Гренада",
    "GE" to "Грузия",
    "GF" to "Франция Гвианасы",
    "GG" to "Гернси",
    "GH" to "Гана",
    "GI" to "Гибралтар",
    "GL" to "Гренландия",
    "GM" to "Гамбия",
    "GN" to "Гвинея",
    "GP" to "Гваделупа",
    "GQ" to "Экватордук Гвинея",
    "GR" to "Греция",
    "GS" to "Түштүк Жоржия жана Түштүк Сэндвич аралдары",
    "GT" to "Гватемала",
    "GU" to "Гуам",
    "GW" to "Гвинея-Бисау",
    "GY" to "Гайана",
    "HK" to "Гонконг Кытай ААА",
    "HM" to "Херд жана Макдональд аралдары",
    "HN" to "Гондурас",
    "HR" to "Хорватия",
    "HT" to "Гаити",
    "HU" to "Венгрия",
    "IC" to "Канар аралдары",
    "ID" to "Индонезия",
    "IE" to "Ирландия",
    "IL" to "Израиль",
    "IM" to "Мэн аралы",
    "IN" to "Индия",
    "IO" to "Инди океанындагы Британ территориясы",
    "IQ" to "Ирак",
    "IR" to "Иран",
    "IS" to "Исландия",
    "IT" to "Италия",
    "JE" to "Жерси",
    "JM" to "Ямайка",
    "JO" to "Иордания",
    "JP" to "Жапония",
    "KE" to "Кения",
    "KG" to "Кыргызстан",
    "KH" to "Камбоджа",
    "KI" to "Кирибати",
    "KM" to "Коморос",
    "KN" to "Сент-Китс жана Невис",
    "KP" to "Түндүк Корея",
    "KR" to "Түштүк Корея",
    "KW" to "Кувейт",
    "KY" to "Кайман аралдары",
    "KZ" to "Казакстан",
    "LA" to "Лаос",
    "LB" to "Ливан",
    "LC" to "Сент-Люсия",
    "LI" to "Лихтенштейн",
    "LK" to "Шри-Ланка",
    "LR" to "Либерия",
    "LS" to "Лесото",
    "LT" to "Литва",
    "LU" to "Люксембург",
    "LV" to "Латвия",
    "LY" to "Ливия",
    "MA" to "Марокко",
    "MC" to "Монако",
    "MD" to "Молдова",
    "ME" to "Черногория",
    "MF" to "Сент-Мартин",
    "MG" to "Мадагаскар",
    "MH" to "Маршалл аралдары",
    "MK" to "Түндүк Македония",
    "ML" to "Мали",
    "MM" to "Мьянма (Бирма)",
    "MN" to "Монголия",
    "MO" to "Макао Кытай ААА",
    "MP" to "Түндүк Мариана аралдары",
    "MQ" to "Мартиника",
    "MR" to "Мавритания",
    "MS" to "Монтсеррат",
    "MT" to "Мальта",
    "MU" to "Маврикий",
    "MV" to "Мальдив",
    "MW" to "Малави",
    "MX" to "Мексика",
    "MY" to "Малайзия",
    "MZ" to "Мозамбик",
    "NA" to "Намибия",
    "NC" to "Жаңы Каледония",
    "NE" to "Нигер",
    "NF" to "Норфолк аралы",
    "NG" to "Нигерия",
    "NI" to "Никарагуа",
    "NL" to "Нидерланд",
    "NO" to "Норвегия",
    "NP" to "Непал",
    "NR" to "Науру",
    "NU" to "Ниуэ",
    "NZ" to "Жаңы Зеландия",
    "OM" to "Оман",
    "PA" to "Панама",
    "PE" to "Перу",
    "PF" to "Полинезия (франциялык)",
    "PG" to "Папуа-Жаңы Гвинея",
    "PH" to "Филиппин",
    "PK" to "Пакистан",
    "PL" to "Польша",
    "PM" to "Сен-Пьер жана Микелон",
    "PN" to "Питкэрн аралдары",
    "PR" to "Пуэрто-Рико",
    "PS" to "Палестина аймактары",
    "PT" to "Португалия",
    "PW" to "Палау",
    "PY" to "Парагвай",
    "QA" to "Катар",
    "QO" to "Алыскы Океания",
    "RE" to "Реюньон",
    "RO" to "Румыния",
    "RS" to "Сербия",
    "RU" to "Россия",
    "RW" to "Руанда",
    "SA" to "Сауд Арабиясы",
    "SB" to "Соломон аралдары",
    "SC" to "Сейшел аралдары",
    "SD" to "Судан",
    "SE" to "Швеция",
    "SG" to "Сингапур",
    "SH" to "Ыйык Елена",
    "SI" to "Словения",
    "SJ" to "Шпицберген жана Ян-Майен",
    "SK" to "Словакия",
    "SL" to "Сьерра-Леоне",
    "SM" to "Сан Марино",
    "SN" to "Сенегал",
    "SO" to "Сомали",
    "SR" to "Суринам",
    "SS" to "Түштүк Судан",
    "ST" to "Сан-Томе жана Принсипи",
    "SV" to "Эль-Сальвадор",
    "SX" to "Синт-Мартен",
    "SY" to "Сирия",
    "SZ" to "Свазиленд",
    "TA" to "Тристан-да-Кунья",
    "TC" to "Түркс жана Кайкос аралдары",
    "TD" to "Чад",
    "TF" to "Франциянын Түштүктөгү аймактары",
    "TG" to "Того",
    "TH" to "Тайланд",
    "TJ" to "Тажикстан",
    "TK" to "Токелау",
    "TL" to "Тимор-Лесте",
    "TM" to "Түркмөнстан",
    "TN" to "Тунис",
    "TO" to "Тонга",
    "TR" to "Түркия",
    "TT" to "Тринидад жана Тобаго",
    "TV" to "Тувалу",
    "TW" to "Тайвань",
    "TZ" to "Танзания",
    "UA" to "Украина",
    "UG" to "Уганда",
    "UM" to "АКШнын сырткы аралдары",
    "UN" to "БУ",
    "US" to "Кошмо Штаттар",
    "UY" to "Уругвай",
    "UZ" to "Өзбекстан",
    "VA" to "Ватикан",
    "VC" to "Сент-Винсент жана Гренадиндер",
    "VE" to "Венесуэла",
    "VG" to "Виргин аралдары (Британия)",
    "VI" to "Виргин аралдары (АКШ)",
    "VN" to "Вьетнам",
    "VU" to "Вануату",
    "WF" to "Уоллис жана Футуна",
    "WS" to "Самоа",
    "XA" to "Жасалма- Акцент",
    "XB" to "Жасалма - эки тараптуу",
    "XK" to "Косово",
    "YE" to "Йемен",
    "YT" to "Майотта",
    "ZA" to "Түштүк-Африка Республикасы",
    "ZM" to "Замбия",
    "ZW" to "Зимбабве",
    "ZZ" to "Белгисиз чөлкөм",
  ) }

  val lag: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andóra",
    "AE" to "Ʉtemi wa Kɨaráabu",
    "AF" to "Afuganisitáani",
    "AG" to "Antigúua na Baribúuda",
    "AI" to "Anguíila",
    "AL" to "Alubánia",
    "AM" to "Ariménia",
    "AO" to "Angóola",
    "AR" to "Ajentíina",
    "AS" to "Samóoa ya Amerɨ́ka",
    "AT" to "Áusitiria",
    "AU" to "Ausiteréelia",
    "AW" to "Arúuba",
    "AZ" to "Azabajáani",
    "BA" to "Bósinia",
    "BB" to "Babadóosi",
    "BD" to "Bangaladéeshi",
    "BE" to "Ʉbeligíiji",
    "BF" to "Bukinafáaso",
    "BG" to "Buligaría",
    "BH" to "Baharéeni",
    "BI" to "Burúundi",
    "BJ" to "Beníini",
    "BM" to "Berimúuda",
    "BN" to "Burunéei",
    "BO" to "Bolívia",
    "BR" to "Brasíili",
    "BS" to "Baháama",
    "BT" to "Butáani",
    "BW" to "Botiswáana",
    "BY" to "Belarúusi",
    "BZ" to "Belíise",
    "CA" to "Kánada",
    "CD" to "Jamuhúuri ya Kɨdemokurasía ya Kóongo",
    "CF" to "Juhúuri ya Afɨrɨka ya katɨ katɨ",
    "CG" to "Kóongo",
    "CH" to "Uswíisi",
    "CI" to "Ivori Kositi",
    "CK" to "Visíiwa vya Kúuku",
    "CL" to "Chíile",
    "CM" to "Kamerúuni",
    "CN" to "Chíina",
    "CO" to "Kolómbia",
    "CR" to "Kósita Rɨ́ɨka",
    "CU" to "Kyúuba",
    "CV" to "Kepuvéede",
    "CY" to "Kupuróosi",
    "CZ" to "Jamuhúuri ya Chéeki",
    "DE" to "Ʉjerumáani",
    "DJ" to "Jibúuti",
    "DK" to "Denimaki",
    "DM" to "Domínɨka",
    "DO" to "Jamuhúuri ya Dominɨka",
    "DZ" to "Alijéria",
    "EC" to "Íkwado",
    "EE" to "Estonía",
    "EG" to "Mísiri",
    "ER" to "Eriterea",
    "ES" to "Hisipánia",
    "ET" to "Ʉhabéeshi",
    "FI" to "Ufíini",
    "FJ" to "Fíiji",
    "FK" to "Visíiwa vya Fakulandi",
    "FM" to "Mikironésia",
    "FR" to "Ʉfaráansa",
    "GA" to "Gabóoni",
    "GB" to "Ʉɨngeréesa",
    "GD" to "Girenáada",
    "GE" to "Jójia",
    "GF" to "Gwiyáana yʉ Ʉfaráansa",
    "GH" to "Gáana",
    "GI" to "Jiburálita",
    "GL" to "Giriniláandi",
    "GM" to "Gámbia",
    "GN" to "Gíine",
    "GP" to "Gwadelúupe",
    "GQ" to "Gíine Ikwéeta",
    "GR" to "Ugiríki",
    "GT" to "Gwatemáala",
    "GU" to "Gwani",
    "GW" to "Gíine Bisáau",
    "GY" to "Guyáana",
    "HN" to "Honduráasi",
    "HR" to "Koréshia",
    "HT" to "Haíiti",
    "HU" to "Hungária",
    "ID" to "Indonésia",
    "IE" to "Ayaláandi",
    "IL" to "Isiraéeli",
    "IN" to "Índia",
    "IQ" to "Iráaki",
    "IR" to "Ʉajéemi",
    "IS" to "Aisiláandi",
    "IT" to "Itália",
    "JM" to "Jamáika",
    "JO" to "Jódani",
    "JP" to "Japáani",
    "KE" to "Kéenya",
    "KG" to "Kirigisitáani",
    "KH" to "Kambódia",
    "KI" to "Kiribáati",
    "KM" to "Komóoro",
    "KN" to "Mʉtakatíifu kitisi na Nevíisi",
    "KP" to "Koréa yʉ ʉtʉrʉko",
    "KR" to "Koréa ya Saame",
    "KW" to "Kʉwáiti",
    "KY" to "Visíiwa vya Kayimani",
    "KZ" to "Kazakasitáani",
    "LA" to "Laóosi",
    "LB" to "Lebanóoni",
    "LC" to "Mʉtakatíifu Lusíia",
    "LI" to "Lishentéeni",
    "LK" to "Siriláanka",
    "LR" to "Liibéria",
    "LS" to "Lesóoto",
    "LT" to "Lisuánia",
    "LU" to "Lasembáagi",
    "LV" to "Lativia",
    "LY" to "Líbia",
    "MA" to "Moróoko",
    "MC" to "Monáako",
    "MD" to "Molidóova",
    "MG" to "Bukíini",
    "MH" to "Visíiwa vya Marisháali",
    "ML" to "Máali",
    "MM" to "Miáama",
    "MN" to "Mongólia",
    "MP" to "Visiwa vya Mariana vya Kaskazini",
    "MQ" to "Maritiníiki",
    "MR" to "Moritánia",
    "MS" to "Monteráati",
    "MT" to "Málita",
    "MU" to "Moríisi",
    "MV" to "Modíivu",
    "MW" to "Maláawi",
    "MX" to "Mekisiko",
    "MY" to "Maleísia",
    "MZ" to "Musumbíiji",
    "NA" to "Namíbia",
    "NC" to "Kaledónia Ifya",
    "NE" to "Níija",
    "NF" to "Kisíiwa cha Nofifóoki",
    "NG" to "Niijéria",
    "NI" to "Nikarágʉa",
    "NL" to "Ʉholáanzi",
    "NO" to "Norwe",
    "NP" to "Nepáali",
    "NR" to "Naúuru",
    "NU" to "Niúue",
    "NZ" to "Nyuzílandi",
    "OM" to "Ómani",
    "PA" to "Panáama",
    "PE" to "Péeru",
    "PF" to "Polinésia yʉ Ʉfaráansa",
    "PG" to "Papúua",
    "PH" to "Ufilipíino",
    "PK" to "Pakisitáani",
    "PL" to "Pólandi",
    "PM" to "Mʉtakatíifu Peéteri na Mɨkaéeli",
    "PN" to "Patikaírini",
    "PR" to "Pwetorɨ́ɨko",
    "PS" to "Mweemberera wa kʉmweeri wa Gáaza",
    "PT" to "Ʉréeno",
    "PW" to "Paláau",
    "PY" to "Paraguáai",
    "QA" to "Katáari",
    "RE" to "Reyunióoni",
    "RO" to "Romaníia",
    "RU" to "Urúusi",
    "RW" to "Rwáanda",
    "SA" to "Saudíia Arabíia",
    "SB" to "Visíiwa vya Solomóoni",
    "SC" to "Shelishéeli",
    "SD" to "Sudáani",
    "SE" to "Uswíidi",
    "SG" to "Singapoo",
    "SH" to "Mʉtakatíifu Heléena",
    "SI" to "Sulovénia",
    "SK" to "Sulováakia",
    "SL" to "Seraleóoni",
    "SM" to "Samaríino",
    "SN" to "Senegáali",
    "SO" to "Somália",
    "SR" to "Surináamu",
    "ST" to "Sao Tóome na Pirinsipe",
    "SV" to "Elisalivado",
    "SY" to "Síria",
    "SZ" to "Ʉswáazi",
    "TC" to "Visíiwa vya Turíiki na Kaíiko",
    "TD" to "Cháadi",
    "TG" to "Tóogo",
    "TH" to "Táilandi",
    "TJ" to "Tajikisitáani",
    "TK" to "Tokeláau",
    "TL" to "Timóori yi Itʉʉmba",
    "TM" to "Uturukimenisitáani",
    "TN" to "Tunísia",
    "TO" to "Tóonga",
    "TR" to "Uturúuki",
    "TT" to "Tiriníida ya Tobáago",
    "TV" to "Tuváalu",
    "TW" to "Taiwáani",
    "TZ" to "Taansanía",
    "UA" to "Ʉkɨréeni",
    "UG" to "Ʉgáanda",
    "US" to "Amerɨka",
    "UY" to "Uruguáai",
    "UZ" to "Usibekisitáani",
    "VA" to "Vatikáani",
    "VC" to "Mʉtakatíifu Viséenti na Gernadíini",
    "VE" to "Venezuéela",
    "VG" to "Visíiwa vya Vigíini vya Ʉɨngeréesa",
    "VI" to "Visíiwa vya Vigíini vya Amerɨ́ka",
    "VN" to "Vietináamu",
    "VU" to "Vanuáatu",
    "WF" to "Walíisi na Futúuna",
    "WS" to "Samóoa",
    "YE" to "Yémeni",
    "YT" to "Mayóote",
    "ZA" to "Afɨrɨka ya Saame",
    "ZM" to "Sámbia",
    "ZW" to "Simbáabwe",
  ) }

  val lb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Welt",
    "002" to "Afrika",
    "003" to "Nordamerika",
    "005" to "Südamerika",
    "009" to "Ozeanien",
    "011" to "Westafrika",
    "013" to "Mëttelamerika",
    "014" to "Ostafrika",
    "015" to "Nordafrika",
    "017" to "Zentralafrika",
    "018" to "Südlecht Afrika",
    "019" to "Amerika",
    "021" to "Nërdlecht Amerika",
    "029" to "Karibik",
    "030" to "Ostasien",
    "034" to "Südasien",
    "035" to "Südostasien",
    "039" to "Südeuropa",
    "053" to "Australien an Neiséiland",
    "054" to "Melanesien",
    "057" to "Mikronesescht Inselgebitt",
    "061" to "Polynesien",
    "142" to "Asien",
    "143" to "Zentralasien",
    "145" to "Westasien",
    "150" to "Europa",
    "151" to "Osteuropa",
    "154" to "Nordeuropa",
    "155" to "Westeuropa",
    "419" to "Latäinamerika",
    "AC" to "Ascension",
    "AD" to "Andorra",
    "AE" to "Vereenegt Arabesch Emirater",
    "AF" to "Afghanistan",
    "AG" to "Antigua a Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albanien",
    "AM" to "Armenien",
    "AO" to "Angola",
    "AQ" to "Antarktis",
    "AR" to "Argentinien",
    "AS" to "Amerikanesch-Samoa",
    "AT" to "Éisträich",
    "AU" to "Australien",
    "AW" to "Aruba",
    "AX" to "Ålandinselen",
    "AZ" to "Aserbaidschan",
    "BA" to "Bosnien an Herzegowina",
    "BB" to "Barbados",
    "BD" to "Bangladesch",
    "BE" to "Belsch",
    "BF" to "Burkina Faso",
    "BG" to "Bulgarien",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "Saint-Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivien",
    "BQ" to "Karibescht Holland",
    "BR" to "Brasilien",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Bouvetinsel",
    "BW" to "Botsuana",
    "BY" to "Wäissrussland",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CC" to "Kokosinselen",
    "CD" to "Kongo-Kinshasa",
    "CF" to "Zentralafrikanesch Republik",
    "CG" to "Kongo-Brazzaville",
    "CH" to "Schwäiz",
    "CI" to "Côte d’Ivoire",
    "CK" to "Cookinselen",
    "CL" to "Chile",
    "CM" to "Kamerun",
    "CN" to "China",
    "CO" to "Kolumbien",
    "CP" to "Clipperton-Insel",
    "CR" to "Costa Rica",
    "CU" to "Kuba",
    "CV" to "Kap Verde",
    "CW" to "Curaçao",
    "CX" to "Chrëschtdagsinsel",
    "CY" to "Zypern",
    "CZ" to "Tschechien",
    "DE" to "Däitschland",
    "DG" to "Diego Garcia",
    "DJ" to "Dschibuti",
    "DK" to "Dänemark",
    "DM" to "Dominica",
    "DO" to "Dominikanesch Republik",
    "DZ" to "Algerien",
    "EA" to "Ceuta a Melilla",
    "EC" to "Ecuador",
    "EE" to "Estland",
    "EG" to "Egypten",
    "EH" to "Westsahara",
    "ER" to "Eritrea",
    "ES" to "Spanien",
    "ET" to "Ethiopien",
    "EU" to "Europäesch Unioun",
    "FI" to "Finnland",
    "FJ" to "Fidschi",
    "FK" to "Falklandinselen",
    "FM" to "Mikronesien",
    "FO" to "Färöer",
    "FR" to "Frankräich",
    "GA" to "Gabun",
    "GB" to "Groussbritannien",
    "GD" to "Grenada",
    "GE" to "Georgien",
    "GF" to "Guayane",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Grönland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Equatorialguinea",
    "GR" to "Griicheland",
    "GS" to "Südgeorgien an déi Südlech Sandwichinselen",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Spezialverwaltungszon Hong Kong",
    "HM" to "Heard- a McDonald-Inselen",
    "HN" to "Honduras",
    "HR" to "Kroatien",
    "HT" to "Haiti",
    "HU" to "Ungarn",
    "IC" to "Kanaresch Inselen",
    "ID" to "Indonesien",
    "IE" to "Irland",
    "IL" to "Israel",
    "IM" to "Isle of Man",
    "IN" to "Indien",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Island",
    "IT" to "Italien",
    "JE" to "Jersey",
    "JM" to "Jamaika",
    "JO" to "Jordanien",
    "JP" to "Japan",
    "KE" to "Kenia",
    "KG" to "Kirgisistan",
    "KH" to "Kambodscha",
    "KI" to "Kiribati",
    "KM" to "Komoren",
    "KN" to "St. Kitts an Nevis",
    "KP" to "Nordkorea",
    "KR" to "Südkorea",
    "KW" to "Kuwait",
    "KY" to "Kaimaninselen",
    "KZ" to "Kasachstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "St. Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Litauen",
    "LU" to "Lëtzebuerg",
    "LV" to "Lettland",
    "LY" to "Libyen",
    "MA" to "Marokko",
    "MC" to "Monaco",
    "MD" to "Moldawien",
    "ME" to "Montenegro",
    "MF" to "St. Martin",
    "MG" to "Madagaskar",
    "MH" to "Marshallinselen",
    "MK" to "Nordmazedonien",
    "ML" to "Mali",
    "MM" to "Myanmar",
    "MN" to "Mongolei",
    "MO" to "Spezialverwaltungszon Macau",
    "MP" to "Nërdlech Marianen",
    "MQ" to "Martinique",
    "MR" to "Mauretanien",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldiven",
    "MW" to "Malawi",
    "MX" to "Mexiko",
    "MY" to "Malaysia",
    "MZ" to "Mosambik",
    "NA" to "Namibia",
    "NC" to "Neikaledonien",
    "NE" to "Niger",
    "NF" to "Norfolkinsel",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Holland",
    "NO" to "Norwegen",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Neiséiland",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Franséisch-Polynesien",
    "PG" to "Papua-Neiguinea",
    "PH" to "Philippinnen",
    "PK" to "Pakistan",
    "PL" to "Polen",
    "PM" to "St. Pierre a Miquelon",
    "PN" to "Pitcairninselen",
    "PR" to "Puerto Rico",
    "PS" to "Palestinensesch Autonomiegebidder",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Katar",
    "QO" to "Baussecht Ozeanien",
    "RE" to "Réunion",
    "RO" to "Rumänien",
    "RS" to "Serbien",
    "RU" to "Russland",
    "RW" to "Ruanda",
    "SA" to "Saudi-Arabien",
    "SB" to "Salomonen",
    "SC" to "Seychellen",
    "SD" to "Sudan",
    "SE" to "Schweden",
    "SG" to "Singapur",
    "SH" to "St. Helena",
    "SI" to "Slowenien",
    "SJ" to "Svalbard a Jan Mayen",
    "SK" to "Slowakei",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "SS" to "Südsudan",
    "ST" to "São Tomé a Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Syrien",
    "SZ" to "Swasiland",
    "TA" to "Tristan da Cunha",
    "TC" to "Turks- a Caicosinselen",
    "TD" to "Tschad",
    "TF" to "Franséisch Süd- an Antarktisgebidder",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tadschikistan",
    "TK" to "Tokelau",
    "TL" to "Osttimor",
    "TM" to "Turkmenistan",
    "TN" to "Tunesien",
    "TO" to "Tonga",
    "TR" to "Tierkei",
    "TT" to "Trinidad an Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tansania",
    "UA" to "Ukrain",
    "UG" to "Uganda",
    "UM" to "Amerikanesch-Ozeanien",
    "US" to "Vereenegt Staaten",
    "UY" to "Uruguay",
    "UZ" to "Usbekistan",
    "VA" to "Vatikanstad",
    "VC" to "St. Vincent an d’Grenadinnen",
    "VE" to "Venezuela",
    "VG" to "Britesch Joffereninselen",
    "VI" to "Amerikanesch Joffereninselen",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis a Futuna",
    "WS" to "Samoa",
    "XK" to "Kosovo",
    "YE" to "Jemen",
    "YT" to "Mayotte",
    "ZA" to "Südafrika",
    "ZM" to "Sambia",
    "ZW" to "Simbabwe",
    "ZZ" to "Onbekannt Regioun",
  ) }

  val lg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Emireeti",
    "AF" to "Afaganisitani",
    "AG" to "Antigwa ne Barabuda",
    "AI" to "Angwila",
    "AL" to "Alibaniya",
    "AM" to "Arameniya",
    "AO" to "Angola",
    "AR" to "Arigentina",
    "AS" to "Samowa omumerika",
    "AT" to "Awusituriya",
    "AU" to "Awusitureliya",
    "AW" to "Aruba",
    "AZ" to "Azerebayijaani",
    "BA" to "Boziniya Hezegovina",
    "BB" to "Barabadosi",
    "BD" to "Bangaladesi",
    "BE" to "Bubirigi",
    "BF" to "Burukina Faso",
    "BG" to "Bulugariya",
    "BH" to "Baareeni",
    "BI" to "Burundi",
    "BJ" to "Benini",
    "BM" to "Beremuda",
    "BN" to "Burunayi",
    "BO" to "Boliviya",
    "BR" to "Buraziiri",
    "BS" to "Bahamasi",
    "BT" to "Butaani",
    "BW" to "Botiswana",
    "BY" to "Belarusi",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CD" to "Kongo - Zayire",
    "CF" to "Lipubulika eya Senturafiriki",
    "CG" to "Kongo",
    "CH" to "Switizirandi",
    "CI" to "Kote Divwa",
    "CK" to "Bizinga bya Kkuki",
    "CL" to "Cile",
    "CM" to "Kameruuni",
    "CN" to "Cayina",
    "CO" to "Kolombya",
    "CR" to "Kosita Rika",
    "CU" to "Cuba",
    "CV" to "Bizinga by’e Kepu Veredi",
    "CY" to "Sipuriya",
    "CZ" to "Lipubulika ya Ceeka",
    "DE" to "Budaaki",
    "DJ" to "Jjibuti",
    "DK" to "Denimaaka",
    "DM" to "Dominika",
    "DO" to "Lipubulika ya Dominika",
    "DZ" to "Aligerya",
    "EC" to "Ekwado",
    "EE" to "Esitoniya",
    "EG" to "Misiri",
    "ER" to "Eritureya",
    "ES" to "Sipeyini",
    "ET" to "Esyopya",
    "FI" to "Finilandi",
    "FJ" to "Fiji",
    "FK" to "Bizinga by’eFalikalandi",
    "FM" to "Mikuronezya",
    "FR" to "Bufalansa",
    "GA" to "Gaboni",
    "GB" to "Bungereza",
    "GD" to "Gurenada",
    "GE" to "Gyogya",
    "GF" to "Guyana enfalansa",
    "GH" to "Gana",
    "GI" to "Giburalita",
    "GL" to "Gurenelandi",
    "GM" to "Gambya",
    "GN" to "Gini",
    "GP" to "Gwadalupe",
    "GQ" to "Gayana ey’oku ekweta",
    "GR" to "Bugereeki/Buyonaani",
    "GT" to "Gwatemala",
    "GU" to "Gwamu",
    "GW" to "Gini-Bisawu",
    "GY" to "Gayana",
    "HN" to "Hundurasi",
    "HR" to "Kurowesya",
    "HT" to "Hayiti",
    "HU" to "Hangare",
    "ID" to "Yindonezya",
    "IE" to "Ayalandi",
    "IL" to "Yisirayeri",
    "IN" to "Buyindi",
    "IQ" to "Yiraaka",
    "IR" to "Yiraani",
    "IS" to "Ayisirandi",
    "IT" to "Yitale",
    "JM" to "Jamayika",
    "JO" to "Yorodani",
    "JP" to "Japani",
    "KE" to "Kenya",
    "KG" to "Kirigizisitaani",
    "KH" to "Kambodya",
    "KI" to "Kiribati",
    "KM" to "Bizinga by’eKomoro",
    "KN" to "Senti Kitisi ne Nevisi",
    "KP" to "Koreya ey’omumambuka",
    "KR" to "Koreya ey’omumaserengeta",
    "KW" to "Kuweti",
    "KY" to "Bizinga ebya Kayimaani",
    "KZ" to "Kazakisitaani",
    "LA" to "Lawosi",
    "LB" to "Lebanoni",
    "LC" to "Senti Luciya",
    "LI" to "Licitensitayini",
    "LK" to "Sirilanka",
    "LR" to "Liberya",
    "LS" to "Lesoso",
    "LT" to "Lisuwenya",
    "LU" to "Lukisembaaga",
    "LV" to "Lativya",
    "LY" to "Libya",
    "MA" to "Moroko",
    "MC" to "Monako",
    "MD" to "Molodova",
    "MG" to "Madagasika",
    "MH" to "Bizinga bya Mariso",
    "ML" to "Mali",
    "MM" to "Myanima",
    "MN" to "Mongoliya",
    "MP" to "Bizinga bya Mariyana eby’omumambuka",
    "MQ" to "Maritiniiki",
    "MR" to "Mawulitenya",
    "MS" to "Monteseraati",
    "MT" to "Malita",
    "MU" to "Mawulisyasi",
    "MV" to "Bizinga by’eMalidive",
    "MW" to "Malawi",
    "MX" to "Mekisiko",
    "MY" to "Malezya",
    "MZ" to "Mozambiiki",
    "NA" to "Namibiya",
    "NC" to "Kaledonya mupya",
    "NE" to "Nije",
    "NF" to "Kizinga ky’eNorofoko",
    "NG" to "Nayijerya",
    "NI" to "Nikaraguwa",
    "NL" to "Holandi",
    "NO" to "Nowe",
    "NP" to "Nepalo",
    "NR" to "Nawuru",
    "NU" to "Niyuwe",
    "NZ" to "Niyuziirandi",
    "OM" to "Omaani",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesiya enfalansa",
    "PG" to "Papwa Nyugini",
    "PH" to "Bizinga bya Firipino",
    "PK" to "Pakisitaani",
    "PL" to "Polandi",
    "PM" to "Senti Piyere ne Mikeloni",
    "PN" to "Pitikeeni",
    "PR" to "Potoriko",
    "PS" to "Palesitayini",
    "PT" to "Potugaali",
    "PW" to "Palawu",
    "PY" to "Paragwayi",
    "QA" to "Kataa",
    "RE" to "Leyunyoni",
    "RO" to "Lomaniya",
    "RU" to "Lasa",
    "RW" to "Rwanda",
    "SA" to "Sawudarebya - Buwarabu",
    "SB" to "Bizanga by’eSolomooni",
    "SC" to "Sesere",
    "SD" to "Sudaani",
    "SE" to "Swideni",
    "SG" to "Singapowa",
    "SH" to "Senti Herena",
    "SI" to "Sirovenya",
    "SK" to "Sirovakya",
    "SL" to "Siyeralewone",
    "SM" to "Sanimarino",
    "SN" to "Senegaalo",
    "SO" to "Somaliya",
    "SR" to "Surinaamu",
    "ST" to "Sanitome ne Purincipe",
    "SV" to "El salivado",
    "SY" to "Siriya",
    "SZ" to "Swazirandi",
    "TC" to "Bizinga by’eTaaka ne Kayikosi",
    "TD" to "Caadi",
    "TG" to "Togo",
    "TH" to "Tayirandi",
    "TJ" to "Tajikisitaani",
    "TK" to "Tokelawu",
    "TL" to "Timowa",
    "TM" to "Takimenesitaani",
    "TN" to "Tunisya",
    "TO" to "Tonga",
    "TR" to "Ttake",
    "TT" to "Turindaadi ne Tobago",
    "TV" to "Tuvalu",
    "TW" to "Tayiwani",
    "TZ" to "Tanzaniya",
    "UA" to "Yukurayine",
    "UG" to "Yuganda",
    "US" to "Amerika",
    "UY" to "Wurugwayi",
    "UZ" to "Wuzibekisitaani",
    "VA" to "Vatikaani",
    "VC" to "Senti Vinsenti ne Gurendadiini",
    "VE" to "Venzwera",
    "VG" to "Bizinga ebya Virigini ebitwalibwa Bungereza",
    "VI" to "Bizinga bya Virigini eby’Amerika",
    "VN" to "Vyetinaamu",
    "VU" to "Vanawuwatu",
    "WF" to "Walisi ne Futuna",
    "WS" to "Samowa",
    "YE" to "Yemeni",
    "YT" to "Mayotte",
    "ZA" to "Sawusafirika",
    "ZM" to "Zambya",
    "ZW" to "Zimbabwe",
  ) }

  val lij: ImmutableMap<String, String> by lazy { immutableMapOf(
    "FR" to "Fransa",
    "IT" to "Italia",
    "MC" to "Monego",
  ) }

  val lkt: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "Makȟásitomni",
    "002" to "Hásapa Makȟáwita",
    "019" to "Khéya Wíta",
    "142" to "Hazíla Makȟáwita",
    "150" to "Wašíču Makȟáwita",
    "CA" to "Uŋčíyapi Makȟóčhe",
    "CN" to "Pȟečhókaŋhaŋska Makȟóčhe",
    "DE" to "Iyášiča Makȟóčhe",
    "ES" to "Spayólaȟče Makȟóčhe",
    "JP" to "Kisúŋla Makȟóčhe",
    "MX" to "Spayóla Makȟóčhe",
    "US" to "Mílahaŋska Tȟamákȟočhe",
  ) }

  val lld: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "monn",
    "002" to "Africa",
    "005" to "America dl Süd",
    "009" to "Ozeania",
    "011" to "Africa ozidentala",
    "013" to "America Zentrala",
    "014" to "Africa orientala",
    "015" to "Africa dl Nord",
    "017" to "Africa zentrala",
    "018" to "Africa dl Süd",
    "019" to "Americhes",
    "021" to "America dl Nord",
    "029" to "Caraibi",
    "030" to "Asia orientala",
    "034" to "Asia dl Süd",
    "035" to "Asia dl Süd-Ost",
    "039" to "Europa dl Süd",
    "053" to "Australasia",
    "054" to "Melanesia",
    "057" to "Isoles dla Micronesia",
    "061" to "Polinesia",
    "142" to "Asia",
    "143" to "Asia zentrala",
    "145" to "Asia ozidentala",
    "150" to "Europa",
    "151" to "Europa orientala",
    "154" to "Europa dl Nord",
    "155" to "Europa ozidentala",
    "202" to "Africa sot-sahariana",
    "419" to "America latina",
    "AC" to "Isola dl’Ascensiun",
    "AD" to "Andorra",
    "AE" to "Emirac Arabics Unis",
    "AF" to "Afghanistan",
    "AG" to "Antigua y Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AQ" to "Antartida",
    "AR" to "Argentina",
    "AS" to "Samoa americana",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AX" to "Isoles Åland",
    "AZ" to "Azerbaijan",
    "BA" to "Bosnia y Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesc",
    "BE" to "Belgio",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BL" to "St. Barthélemy",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BQ" to "Caraibi olandesc",
    "BR" to "Brasil",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BV" to "Isola Bouvet",
    "BW" to "Botswana",
    "BY" to "Belaruscia",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CC" to "Isoles Cocos (Keeling)",
    "CD" to "Congo - Kinshasa",
    "CF" to "Republica Zentrafricana",
    "CG" to "Congo - Brazzaville",
    "CH" to "Svizera",
    "CI" to "Costa d’Avore",
    "CK" to "Isoles Cook",
    "CL" to "Cile",
    "CM" to "Camerun",
    "CN" to "Cina",
    "CO" to "Colombia",
    "CP" to "Isola de Clipperton",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Capo Verde",
    "CW" to "Curaçao",
    "CX" to "Isola dl Nadé",
    "CY" to "Ziper",
    "CZ" to "Cechia",
    "DE" to "Paisc Todësc",
    "DG" to "Diego Garcia",
    "DJ" to "Djibouti",
    "DK" to "Danimarca",
    "DM" to "Dominica",
    "DO" to "Republica Dominicana",
    "DZ" to "Algeria",
    "EA" to "Ceuta y Melilla",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egit",
    "EH" to "Sahara ozidentala",
    "ER" to "Eritrea",
    "ES" to "Spagna",
    "ET" to "Etiopia",
    "EU" to "Uniun Europeica",
    "EZ" to "Zona Euro",
    "FI" to "Finlandia",
    "FJ" to "Fiji",
    "FK" to "Isoles Falkland",
    "FM" to "Micronesia",
    "FO" to "Isoles Faroer",
    "FR" to "Francia",
    "GA" to "Gabun",
    "GB" to "Rëgn Uní",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "Guiana franzeja",
    "GG" to "Guernsey",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Groenlandia",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Guinea ecuatoriala",
    "GR" to "Grecia",
    "GS" to "Georgia dl Süd y Isoles Sandwich dl Süd",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HK" to "Regiun aministrativa speziala de Hong Kong",
    "HM" to "Isoles Heard y McDonald",
    "HN" to "Honduras",
    "HR" to "Croazia",
    "HT" to "Haiti",
    "HU" to "Ungaria",
    "IC" to "Isoles Canaries",
    "ID" to "Indonesia",
    "IE" to "Irlanda",
    "IL" to "Israel",
    "IM" to "Isola de Man",
    "IN" to "India",
    "IO" to "Teritore britanich dl Ozean Indian",
    "IQ" to "Irak",
    "IR" to "Iran",
    "IS" to "Islanda",
    "IT" to "Talia",
    "JE" to "Jersey",
    "JM" to "Giamaica",
    "JO" to "Iordania",
    "JP" to "Iapan",
    "KE" to "Kenia",
    "KG" to "Kyrgystan",
    "KH" to "Cambogia",
    "KI" to "Kiribati",
    "KM" to "Comores",
    "KN" to "St. Kitts y Nevis",
    "KP" to "Corea dl Nord",
    "KR" to "Corea dl Süd",
    "KW" to "Kuwait",
    "KY" to "Isoles Cayman",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Libanon",
    "LC" to "St. Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lituania",
    "LU" to "Lussemburgh",
    "LV" to "Letonia",
    "LY" to "Libia",
    "MA" to "Maroco",
    "MC" to "Monaco",
    "MD" to "Moldavia",
    "ME" to "Montenegro",
    "MF" to "St. Martin",
    "MG" to "Madagascar",
    "MH" to "Isoles Marshall",
    "MK" to "Macedonia dl Nord",
    "ML" to "Mali",
    "MM" to "Myanmar (Burma)",
    "MN" to "Mongolia",
    "MO" to "Regiun aministrativa speziala de Macao",
    "MP" to "Isoles Marianes dl Nord",
    "MQ" to "Martinica",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldives",
    "MW" to "Malawi",
    "MX" to "Messich",
    "MY" to "Malesia",
    "MZ" to "Mozambich",
    "NA" to "Namibia",
    "NC" to "Nöia Caledonia",
    "NE" to "Niger",
    "NF" to "Isola Norfolk",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Paisc Basc",
    "NO" to "Norvegia",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nöia Zelanda",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Perú",
    "PF" to "Polinesia franzeja",
    "PG" to "Papua Nöia Guinea",
    "PH" to "Filipines",
    "PK" to "Pakistan",
    "PL" to "Polonia",
    "PM" to "St. Pierre y Miquelon",
    "PN" to "Isoles Pitcairn",
    "PR" to "Puerto Rico",
    "PS" to "Teritori palestinesc",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "QO" to "Ozeania dlafora",
    "RE" to "Réunion",
    "RO" to "Romania",
    "RS" to "Serbia",
    "RU" to "Ruscia",
    "RW" to "Ruanda",
    "SA" to "Arabia Saudita",
    "SB" to "Isoles Salomon",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Svezia",
    "SG" to "Singapur",
    "SH" to "St. Helena",
    "SI" to "Slovenia",
    "SJ" to "Svalbard y Jan Mayen",
    "SK" to "Slovachia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Surinam",
    "SS" to "Sudan dl Süd",
    "ST" to "São Tomé y Príncipe",
    "SV" to "El Salvador",
    "SX" to "Sint Maarten",
    "SY" to "Siria",
    "SZ" to "Eswatini",
    "TA" to "Tristan da Cunha",
    "TC" to "Isoles Turks y Caicos",
    "TD" to "Ciad",
    "TF" to "Teritori franzesc dl Süd y dl’Antartica",
    "TG" to "Togo",
    "TH" to "Thailandia",
    "TJ" to "Tajikistan",
    "TK" to "Tokelau",
    "TL" to "Timor-Leste",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turchia",
    "TT" to "Trinidad y Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ucraina",
    "UG" to "Uganda",
    "UM" to "Isoles mëndres dlafora di Stac Unis",
    "UN" to "Naziuns Unides",
    "US" to "Stac Unis",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Cité dl Vatican",
    "VC" to "St. Vincent y Grenadines",
    "VE" to "Venezuela",
    "VG" to "Isoles Vergines britaniches",
    "VI" to "Isoles Vergines americanes",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis y Futuna",
    "WS" to "Samoa",
    "XA" to "Pseudo-azënc",
    "XB" to "Pseudo-bidi",
    "XK" to "Kosovo",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "Südafrica",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
    "ZZ" to "Raiun nia conesciü",
  ) }

  val lmo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "IT" to "Italia",
  ) }

  val ln: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andorɛ",
    "AE" to "Lɛmila alabo",
    "AF" to "Afiganisitá",
    "AG" to "Antiga mpé Barbuda",
    "AI" to "Angiyɛ",
    "AL" to "Alibani",
    "AM" to "Amɛni",
    "AO" to "Angóla",
    "AQ" to "Antarctique",
    "AR" to "Arizantinɛ",
    "AS" to "Samoa ya Ameriki",
    "AT" to "Otilisi",
    "AU" to "Ositáli",
    "AW" to "Aruba",
    "AZ" to "Azɛlɛbaizá",
    "BA" to "Bosini mpé Hezegovine",
    "BB" to "Barɛbadɛ",
    "BD" to "Bengalidɛsi",
    "BE" to "Beleziki",
    "BF" to "Bukina Faso",
    "BG" to "Biligari",
    "BH" to "Bahrɛnɛ",
    "BI" to "Burundi",
    "BJ" to "Benɛ",
    "BM" to "Bermuda",
    "BN" to "Brineyi",
    "BO" to "Bolivi",
    "BR" to "Brezílɛ",
    "BS" to "Bahamasɛ",
    "BT" to "Butáni",
    "BW" to "Botswana",
    "BY" to "Byelorisi",
    "BZ" to "Belizɛ",
    "CA" to "Kanada",
    "CD" to "Republíki ya Kongó Demokratíki",
    "CF" to "Repibiki ya Afríka ya Káti",
    "CG" to "Kongo",
    "CH" to "Swisɛ",
    "CI" to "Kotídivualɛ",
    "CK" to "Bisanga bya Kookɛ",
    "CL" to "Síli",
    "CM" to "Kamɛrune",
    "CN" to "Sinɛ",
    "CO" to "Kolombi",
    "CR" to "Kositarika",
    "CU" to "Kiba",
    "CV" to "Bisanga bya Kapevɛrɛ",
    "CY" to "Sípɛlɛ",
    "CZ" to "Shekia",
    "DE" to "Alemani",
    "DJ" to "Dzibuti",
    "DK" to "Danɛmarike",
    "DM" to "Domínike",
    "DO" to "Repibiki ya Domínikɛ",
    "DZ" to "Alizɛri",
    "EC" to "Ekwatɛ́lɛ",
    "EE" to "Esitoni",
    "EG" to "Ezípite",
    "ER" to "Elitelɛ",
    "ES" to "Esipanye",
    "ET" to "Etsíopi",
    "FI" to "Filandɛ",
    "FJ" to "Fidzi",
    "FK" to "Bisanga bya Maluni",
    "FM" to "Mikronezi",
    "FR" to "Falánsɛ",
    "GA" to "Gabɔ",
    "GB" to "Angɛlɛtɛ́lɛ",
    "GD" to "Gelenadɛ",
    "GE" to "Zorzi",
    "GF" to "Giyanɛ ya Falánsɛ",
    "GG" to "Guernesey",
    "GH" to "Gana",
    "GI" to "Zibatalɛ",
    "GL" to "Gowelande",
    "GM" to "Gambi",
    "GN" to "Ginɛ",
    "GP" to "Gwadɛlupɛ",
    "GQ" to "Ginɛ́kwatɛ́lɛ",
    "GR" to "Geleki",
    "GS" to "Îles de Géorgie du Sud et Sandwich du Sud",
    "GT" to "Gwatémala",
    "GU" to "Gwamɛ",
    "GW" to "Ginɛbisau",
    "GY" to "Giyane",
    "HM" to "Ile Heard et Iles McDonald",
    "HN" to "Ondurasɛ",
    "HR" to "Krowasi",
    "HT" to "Ayiti",
    "HU" to "Ongili",
    "ID" to "Indonezi",
    "IE" to "Irelandɛ",
    "IL" to "Isirayelɛ",
    "IN" to "Índɛ",
    "IQ" to "Iraki",
    "IR" to "Irâ",
    "IS" to "Isilandɛ",
    "IT" to "Itali",
    "JM" to "Zamaiki",
    "JO" to "Zɔdani",
    "JP" to "Zapɔ",
    "KE" to "Kenya",
    "KG" to "Kigizisitá",
    "KH" to "Kambodza",
    "KI" to "Kiribati",
    "KM" to "Komorɛ",
    "KN" to "Sántu krístofe mpé Nevɛ̀s",
    "KP" to "Korɛ ya nɔ́rdi",
    "KR" to "Korɛ ya súdi",
    "KW" to "Koweti",
    "KY" to "Bisanga bya Kayíma",
    "KZ" to "Kazakisitá",
    "LA" to "Lawosi",
    "LB" to "Libá",
    "LC" to "Sántu lisi",
    "LI" to "Lishɛteni",
    "LK" to "Sirilanka",
    "LR" to "Libériya",
    "LS" to "Lesoto",
    "LT" to "Litwani",
    "LU" to "Likisambulu",
    "LV" to "Letoni",
    "LY" to "Libí",
    "MA" to "Marokɛ",
    "MC" to "Monako",
    "MD" to "Molidavi",
    "ME" to "Monténégro",
    "MG" to "Madagasikari",
    "MH" to "Bisanga bya Marishalɛ",
    "ML" to "Malí",
    "MM" to "Birmanie",
    "MN" to "Mongolí",
    "MP" to "Bisanga bya Marianɛ ya nɔ́rdi",
    "MQ" to "Martiniki",
    "MR" to "Moritani",
    "MS" to "Mɔsera",
    "MT" to "Malitɛ",
    "MU" to "Morisɛ",
    "MV" to "Madívɛ",
    "MW" to "Malawi",
    "MX" to "Meksike",
    "MY" to "Malezi",
    "MZ" to "Mozambíki",
    "NA" to "Namibi",
    "NC" to "Kaledoni ya sika",
    "NE" to "Nizɛrɛ",
    "NF" to "Esanga Norfokɛ",
    "NG" to "Nizerya",
    "NI" to "Nikaragwa",
    "NL" to "Olandɛ",
    "NO" to "Norivezɛ",
    "NP" to "Nepálɛ",
    "NR" to "Nauru",
    "NU" to "Nyué",
    "NZ" to "Zelandɛ ya sika",
    "OM" to "Ománɛ",
    "PA" to "Panama",
    "PE" to "Péru",
    "PF" to "Polinezi ya Falánsɛ",
    "PG" to "Papwazi Ginɛ ya sika",
    "PH" to "Filipinɛ",
    "PK" to "Pakisitá",
    "PL" to "Poloni",
    "PM" to "Sántu pététo mpé Mikelɔ",
    "PN" to "Pikairni",
    "PR" to "Pɔtoriko",
    "PS" to "Palɛsine",
    "PT" to "Putúlugɛsi",
    "PW" to "Palau",
    "PY" to "Palagwei",
    "QA" to "Katari",
    "RE" to "Lenyo",
    "RO" to "Romani",
    "RS" to "Serbie",
    "RU" to "Risí",
    "RW" to "Rwanda",
    "SA" to "Alabi Sawuditɛ",
    "SB" to "Bisanga Solomɔ",
    "SC" to "Sɛshɛlɛ",
    "SD" to "Sudá",
    "SE" to "Swédɛ",
    "SG" to "Singapurɛ",
    "SH" to "Sántu eleni",
    "SI" to "Siloveni",
    "SK" to "Silovaki",
    "SL" to "Siera Leonɛ",
    "SM" to "Sántu Marinɛ",
    "SN" to "Senegalɛ",
    "SO" to "Somali",
    "SR" to "Surinamɛ",
    "ST" to "Sao Tomé mpé Presipɛ",
    "SV" to "Savadɔrɛ",
    "SY" to "Sirí",
    "SZ" to "Swazilandi",
    "TC" to "Bisanga bya Turki mpé Kaiko",
    "TD" to "Tsádi",
    "TF" to "Terres australes et antarctiques françaises",
    "TG" to "Togo",
    "TH" to "Tailandɛ",
    "TJ" to "Tazikisitá",
    "TK" to "Tokelau",
    "TL" to "Timorɛ ya Moniɛlɛ",
    "TM" to "Tikɛménisitá",
    "TN" to "Tinizi",
    "TO" to "Tonga",
    "TR" to "Tiliki",
    "TT" to "Tinidadɛ mpé Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwanin",
    "TZ" to "Tanzani",
    "UA" to "Ikrɛni",
    "UG" to "Uganda",
    "US" to "Ameriki",
    "UY" to "Irigwei",
    "UZ" to "Uzibɛkisitá",
    "VA" to "Vatiká",
    "VC" to "Sántu vesá mpé Gelenadinɛ",
    "VE" to "Venézuela",
    "VG" to "Bisanga bya Vierzi ya Angɛlɛtɛ́lɛ",
    "VI" to "Bisanga bya Vierzi ya Ameriki",
    "VN" to "Viyetinamɛ",
    "VU" to "Vanuatu",
    "WF" to "Walisɛ mpé Futuna",
    "WS" to "Samoa",
    "YE" to "Yemɛnɛ",
    "YT" to "Mayotɛ",
    "ZA" to "Afríka ya Súdi",
    "ZM" to "Zambi",
    "ZW" to "Zimbabwe",
  ) }

  val ln_AO: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ln_CF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ln_CG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val lo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "ໂລກ",
    "002" to "ອາຟຣິກາ",
    "003" to "ອາເມລິກາເໜືອ",
    "005" to "ອາເມລິກາໃຕ້",
    "009" to "ໂອຊີອານີ",
    "011" to "ອາຟຣິກາຕາເວັນຕົກ",
    "013" to "ອາເມລິກາກາງ",
    "014" to "ອາຟຣິກາຕາເວັນອອກ",
    "015" to "ອາຟຣິກາເໜືອ",
    "017" to "ອາຟຣິກາກາງ",
    "018" to "ອາຟຣິກາຕອນໃຕ້",
    "019" to "ອາເມຣິກາ",
    "021" to "ພາກເໜືອອາເມລີກາ",
    "029" to "ຄາຣິບບຽນ",
    "030" to "ອາຊີຕາເວັນອອກ",
    "034" to "ອາຊີໃຕ້",
    "035" to "ອາຊີຕາເວັນອອກສຽງໃຕ້",
    "039" to "ຢູໂຣບໃຕ້",
    "053" to "ໂອດສະຕາລີ",
    "054" to "ເມລານີເຊຍ",
    "057" to "ເຂດໄມໂຄຣເນຊຽນ",
    "061" to "ໂພລີນີເຊຍ",
    "142" to "ອາຊີ",
    "143" to "ອາຊີກາງ",
    "145" to "ອາຊີຕາເວັນຕົກ",
    "150" to "ຢູໂຣບ",
    "151" to "ຢູໂຣບຕາເວັນອອກ",
    "154" to "ຢູໂຣບເໜືອ",
    "155" to "ຢູໂຣບຕາເວັນຕົກ",
    "202" to "ຊັບ ຊາຮາຣານ ອາຟຣິກາ",
    "419" to "ລາຕິນ ອາເມລິກາ",
    "AC" to "ເກາະອາເຊນຊັນ",
    "AD" to "ອັນດໍຣາ",
    "AE" to "ສະຫະລັດອາຣັບເອມິເຣດ",
    "AF" to "ອາຟການິດສະຖານ",
    "AG" to "ແອນທິກົວ ແລະ ບາບູດາ",
    "AI" to "ແອນກຸຍລາ",
    "AL" to "ແອວເບເນຍ",
    "AM" to "ອາເມເນຍ",
    "AO" to "ແອງໂກລາ",
    "AQ" to "ແອນຕາດຕິກາ",
    "AR" to "ອາເຈນທິນາ",
    "AS" to "ອາເມຣິກາ ຊາມົວ",
    "AT" to "ອອສເທຣຍ",
    "AU" to "ອອສເຕຣເລຍ",
    "AW" to "ອາຣູບາ",
    "AX" to "ຫມູ່ເກາະໂອລັນ",
    "AZ" to "ອາເຊີໄບຈານ",
    "BA" to "ບອດສະເນຍ ແລະ ແຮສໂກວີນາ",
    "BB" to "ບາບາໂດສ",
    "BD" to "ບັງກະລາເທດ",
    "BE" to "ເບວຢຽມ",
    "BF" to "ເບີກິນາ ຟາໂຊ",
    "BG" to "ບັງກາເຣຍ",
    "BH" to "ບາເຣນ",
    "BI" to "ບູຣຸນດິ",
    "BJ" to "ເບນິນ",
    "BL" to "ເຊນ ບາເທເລມີ",
    "BM" to "ເບີມິວດາ",
    "BN" to "ບຣູໄນ",
    "BO" to "ໂບລິເວຍ",
    "BQ" to "ຄາຣິບບຽນ ເນເທີແລນ",
    "BR" to "ບຣາຊິວ",
    "BS" to "ບາຮາມາສ",
    "BT" to "ພູຖານ",
    "BV" to "ເກາະບູເວດ",
    "BW" to "ບອດສະວານາ",
    "BY" to "ເບລາຣຸສ",
    "BZ" to "ເບລີຊ",
    "CA" to "ແຄນາດາ",
    "CC" to "ຫມູ່ເກາະໂກໂກສ",
    "CD" to "ຄອງໂກ - ຄິນຊາຊາ",
    "CF" to "ສາທາລະນະລັດອາຟຣິກາກາງ",
    "CG" to "ຄອງໂກ - ບຣາຊາວິວ",
    "CH" to "ສະວິດເຊີແລນ",
    "CI" to "ໂຄຕີ ວົວ",
    "CK" to "ໝູ່ເກາະຄຸກ",
    "CL" to "ຊິລີ",
    "CM" to "ຄາເມຣູນ",
    "CN" to "ຈີນ",
    "CO" to "ໂຄລົມເບຍ",
    "CP" to "ເກາະຄລິບເປີຕັນ",
    "CR" to "ໂຄສຕາ ຣິກາ",
    "CU" to "ຄິວບາ",
    "CV" to "ເຄບ ເວີດ",
    "CW" to "ຄູຣາຊາວ",
    "CX" to "ເກາະຄຣິສມາດ",
    "CY" to "ໄຊປຣັສ",
    "CZ" to "ເຊັກເຊຍ",
    "DE" to "ເຢຍລະມັນ",
    "DG" to "ດິເອໂກ ກາເຊຍ",
    "DJ" to "ຈິບູຕິ",
    "DK" to "ເດນມາກ",
    "DM" to "ໂດມີນິຄາ",
    "DO" to "ສາທາລະນະລັດ ໂດມິນິກັນ",
    "DZ" to "ອັລຈິເຣຍ",
    "EA" to "ເຊວຕາ & ເມລິນລາ",
    "EC" to "ເອກວາດໍ",
    "EE" to "ເອສໂຕເນຍ",
    "EG" to "ອີຢິບ",
    "EH" to "ຊາຮາຣາຕາເວັນຕົກ",
    "ER" to "ເອຣິເທຣຍ",
    "ES" to "ສະເປນ",
    "ET" to "ອີທິໂອເປຍ",
    "EU" to "ສະຫະພາບຢູໂຣບ",
    "EZ" to "ເຂດຢູໂຣບ",
    "FI" to "ຟິນແລນ",
    "FJ" to "ຟິຈິ",
    "FK" to "ຫມູ່ເກາະຟອກແລນ",
    "FM" to "ໄມໂຄຣນີເຊຍ",
    "FO" to "ຫມູ່ເກາະແຟໂຣ",
    "FR" to "ຝຣັ່ງ",
    "GA" to "ກາບອນ",
    "GB" to "ສະຫະລາດຊະອະນາຈັກ",
    "GD" to "ເກຣເນດາ",
    "GE" to "ຈໍເຈຍ",
    "GF" to "ເຟຣນຊ໌ ກຸຍອານາ",
    "GG" to "ເກີນຊີ",
    "GH" to "ການາ",
    "GI" to "ຈິບບຣອນທາ",
    "GL" to "ກຣີນແລນ",
    "GM" to "ສາທາລະນະລັດແກມເບຍ",
    "GN" to "ກິນີ",
    "GP" to "ກົວດາລູບ",
    "GQ" to "ເອຄົວໂທຣຽວ ກີນີ",
    "GR" to "ກຣີຊ",
    "GS" to "ໝູ່ເກາະ ຈໍເຈຍຕອນໃຕ້ ແລະ ແຊນວິດຕອນໃຕ້",
    "GT" to "ກົວເທມາລາ",
    "GU" to "ກວາມ",
    "GW" to "ກິນີ-ບິສເຊົາ",
    "GY" to "ກາຍຢານາ",
    "HK" to "ຮົງກົງ ເຂດປົກຄອງພິເສດ ຈີນ",
    "HM" to "ໝູ່ເກາະເຮີດ & ແມັກໂດນອລ",
    "HN" to "ຮອນດູຣັສ",
    "HR" to "ໂຄຣເອເທຍ",
    "HT" to "ໄຮຕິ",
    "HU" to "ຮັງກາຣີ",
    "IC" to "ໝູ່ເກາະຄານາຣີ",
    "ID" to "ອິນໂດເນເຊຍ",
    "IE" to "ໄອແລນ",
    "IL" to "ອິສຣາເອວ",
    "IM" to "ເອວ ອອບ ແມນ",
    "IN" to "ອິນເດຍ",
    "IO" to "ເຂດແດນອັງກິດໃນມະຫາສະໝຸດອິນເດຍ",
    "IQ" to "ອີຣັກ",
    "IR" to "ອີຣານ",
    "IS" to "ໄອສແລນ",
    "IT" to "ອິຕາລີ",
    "JE" to "ເຈີຊີ",
    "JM" to "ຈາໄມຄາ",
    "JO" to "ຈໍແດນ",
    "JP" to "ຍີ່ປຸ່ນ",
    "KE" to "ເຄນຢາ",
    "KG" to "ຄຽກກິດສະຖານ",
    "KH" to "ກຳປູເຈຍ",
    "KI" to "ຄິຣິບາທິ",
    "KM" to "ໂຄໂມໂຣສ",
    "KN" to "ເຊນ ຄິດ ແລະ ເນວິສ",
    "KP" to "ເກົາຫລີເໜືອ",
    "KR" to "ເກົາຫລີໃຕ້",
    "KW" to "ກູເວດ",
    "KY" to "ໝູ່ເກາະ ເຄແມນ",
    "KZ" to "ຄາຊັກສະຖານ",
    "LA" to "ລາວ",
    "LB" to "ເລບານອນ",
    "LC" to "ເຊນ ລູເຊຍ",
    "LI" to "ລິດເທນສະຕາຍ",
    "LK" to "ສີລັງກາ",
    "LR" to "ລິເບີເຣຍ",
    "LS" to "ເລໂຊໂທ",
    "LT" to "ລິທົວເນຍ",
    "LU" to "ລຸກແຊມເບີກ",
    "LV" to "ລັດເວຍ",
    "LY" to "ລິເບຍ",
    "MA" to "ໂມຣັອກໂຄ",
    "MC" to "ໂມນາໂຄ",
    "MD" to "ໂມນໂດວາ",
    "ME" to "ມອນເຕເນໂກຣ",
    "MF" to "ເຊນ ມາທິນ",
    "MG" to "ມາດາກາສະກາ",
    "MH" to "ຫມູ່ເກາະມາແຊວ",
    "MK" to "ແມຊິໂດເນຍເໜືອ",
    "ML" to "ມາລີ",
    "MM" to "ມຽນມາ (ເບີມາ)",
    "MN" to "ມອງໂກເລຍ",
    "MO" to "ມາກາວ ເຂດປົກຄອງພິເສດ ຈີນ",
    "MP" to "ໝູ່ເກາະມາເຣຍນາຕອນເໜືອ",
    "MQ" to "ມາຕິນີກ",
    "MR" to "ມົວຣິເທເນຍ",
    "MS" to "ມອນເຊີຣາດ",
    "MT" to "ມອນທາ",
    "MU" to "ມົວຣິຊຽສ",
    "MV" to "ມັນດິຟ",
    "MW" to "ມາລາວີ",
    "MX" to "ເມັກຊິໂກ",
    "MY" to "ມາເລເຊຍ",
    "MZ" to "ໂມແຊມບິກ",
    "NA" to "ນາມີເບຍ",
    "NC" to "ນິວ ຄາເລໂດເນຍ",
    "NE" to "ນິເຈີ",
    "NF" to "ເກາະນໍໂຟກ",
    "NG" to "ໄນຈີເຣຍ",
    "NI" to "ນິກຄາຣາກົວ",
    "NL" to "ເນເທີແລນ",
    "NO" to "ນໍເວ",
    "NP" to "ເນປານ",
    "NR" to "ນາອູຣູ",
    "NU" to "ນີອູເອ",
    "NZ" to "ນິວຊີແລນ",
    "OM" to "ໂອມານ",
    "PA" to "ພານາມາ",
    "PE" to "ເປຣູ",
    "PF" to "ເຟຣນຊ໌ ໂພລິນີເຊຍ",
    "PG" to "ປາປົວນິວກີນີ",
    "PH" to "ຟິລິບປິນ",
    "PK" to "ປາກິດສະຖານ",
    "PL" to "ໂປແລນ",
    "PM" to "ເຊນ ປີແອ ມິເກວລອນ",
    "PN" to "ໝູ່ເກາະພິດແຄນ",
    "PR" to "ເພືອໂຕ ຣິໂກ",
    "PS" to "ດິນແດນປາເລດສະຕິນ",
    "PT" to "ພອລທູໂກ",
    "PW" to "ປາລາວ",
    "PY" to "ພາຣາກວຍ",
    "QA" to "ກາຕາ",
    "QO" to "ເຂດຫ່າງໄກໂອຊີເນຍ",
    "RE" to "ເຣອູນິຍົງ",
    "RO" to "ໂຣແມເນຍ",
    "RS" to "ເຊີເບຍ",
    "RU" to "ຣັດເຊຍ",
    "RW" to "ຣວັນດາ",
    "SA" to "ຊາອຸດິ ອາຣາເບຍ",
    "SB" to "ຫມູ່ເກາະໂຊໂລມອນ",
    "SC" to "ເຊເຊວເລສ",
    "SD" to "ຊູດານ",
    "SE" to "ສະວີເດັນ",
    "SG" to "ສິງກະໂປ",
    "SH" to "ເຊນ ເຮເລນາ",
    "SI" to "ສະໂລເວເນຍ",
    "SJ" to "ສະວາບາ ແລະ ແຢນ ມາເຢນ",
    "SK" to "ສະໂລວາເກຍ",
    "SL" to "ເຊຍຣາ ລີໂອນ",
    "SM" to "ແຊນ ມາຣິໂນ",
    "SN" to "ເຊນີໂກລ",
    "SO" to "ໂຊມາເລຍ",
    "SR" to "ຊູຣິນາມ",
    "SS" to "ຊູດານໃຕ້",
    "ST" to "ເຊົາທູເມ ແລະ ພຣິນຊິບ",
    "SV" to "ເອວ ຊໍວາດໍ",
    "SX" to "ຊິນ ມາເທັນ",
    "SY" to "ຊີເຣຍ",
    "SZ" to "​ເອ​ສະ​ວາ​ຕິ​ນີ",
    "TA" to "ທຣິສຕັນ ດາ ກັນຮາ",
    "TC" to "ໝູ່ເກາະ ເທີກ ແລະ ໄຄໂຄສ",
    "TD" to "ຊາດ",
    "TF" to "ເຂດແດນທາງໃຕ້ຂອງຝຮັ່ງ",
    "TG" to "ໂຕໂກ",
    "TH" to "ໄທ",
    "TJ" to "ທາຈິກິດສະຖານ",
    "TK" to "ໂຕເກເລົາ",
    "TL" to "ທິມໍ-ເລສເຕ",
    "TM" to "ເທີກເມນິສະຖານ",
    "TN" to "ຕູນິເຊຍ",
    "TO" to "ທອງກາ",
    "TR" to "ເທີຄີ",
    "TT" to "ທຣິນິແດດ ແລະ ໂທແບໂກ",
    "TV" to "ຕູວາລູ",
    "TW" to "ໄຕ້ຫວັນ",
    "TZ" to "ທານຊາເນຍ",
    "UA" to "ຢູເຄຣນ",
    "UG" to "ອູການດາ",
    "UM" to "ໝູ່ເກາະຮອບນອກຂອງສະຫະລັດຯ",
    "UN" to "ສະຫະປະຊາຊາດ",
    "US" to "ສະຫະລັດ",
    "UY" to "ອູຣຸກວຍ",
    "UZ" to "ອຸສເບກິສະຖານ",
    "VA" to "ນະຄອນ ວາຕິກັນ",
    "VC" to "ເຊນ ວິນເຊນ ແລະ ເກຣເນດິນ",
    "VE" to "ເວເນຊູເອລາ",
    "VG" to "ໝູ່ເກາະ ເວີຈິນຂອງອັງກິດ",
    "VI" to "ໝູ່ເກາະ ເວີຈິນ ຂອງສະຫະລັດ",
    "VN" to "ຫວຽດນາມ",
    "VU" to "ວານົວຕູ",
    "WF" to "ວາລລິສ ແລະ ຟູຕູນາ",
    "WS" to "ຊາມົວ",
    "XA" to "ສຳນຽງຊູໂດ",
    "XB" to "ຊູໂດບີດີ",
    "XK" to "ໂຄໂຊໂວ",
    "YE" to "ເຢເມນ",
    "YT" to "ມາຢັອດ",
    "ZA" to "ອາຟຣິກາໃຕ້",
    "ZM" to "ແຊມເບຍ",
    "ZW" to "ຊິມບັບເວ",
    "ZZ" to "ຂົງເຂດທີ່ບໍ່ຮູ້ຈັກ",
  ) }

  val lrc: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "دونیا",
    "002" to "ئفریقا",
    "003" to "ئمریکا شومالی",
    "005" to "ئمریکا ھارگە",
    "009" to "ھوم پئڤأند جأھوٙن آڤ",
    "013" to "مینجا ئمریکا",
    "019" to "ئمریکا",
    "021" to "ئمریکا ڤارو",
    "029" to "کارائیب",
    "142" to "آسیا",
    "150" to "ئوروٙپا",
    "419" to "ئمریکا لاتین",
    "BR" to "بئرئزیل",
    "CN" to "چین",
    "DE" to "آلمان",
    "FR" to "فأرانسە",
    "GB" to "بیریتانیا گأپ",
    "IN" to "ھئن",
    "IT" to "ئیتالیا",
    "JP" to "جاپوٙن",
    "RU" to "روٙسیە",
    "US" to "ڤولاتیا یأکاگئرتە",
    "ZZ" to "راساگە نادیار",
  ) }

  val lrc_IQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val lt: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "pasaulis",
    "002" to "Afrika",
    "003" to "Šiaurės Amerika",
    "005" to "Pietų Amerika",
    "009" to "Okeanija",
    "011" to "Vakarų Afrika",
    "013" to "Centrinė Amerika",
    "014" to "Rytų Afrika",
    "015" to "Šiaurės Afrika",
    "017" to "Vidurio Afrika",
    "018" to "Pietinė Afrika",
    "019" to "Amerika",
    "021" to "Šiaurinė Amerika",
    "029" to "Karibai",
    "030" to "Rytų Azija",
    "034" to "Pietų Azija",
    "035" to "Pietryčių Azija",
    "039" to "Pietų Europa",
    "053" to "Australazija",
    "054" to "Melanezija",
    "057" to "Mikronezijos regionas",
    "061" to "Polinezija",
    "142" to "Azija",
    "143" to "Centrinė Azija",
    "145" to "Vakarų Azija",
    "150" to "Europa",
    "151" to "Rytų Europa",
    "154" to "Šiaurės Europa",
    "155" to "Vakarų Europa",
    "202" to "Užsachario Afrika",
    "419" to "Lotynų Amerika",
    "AC" to "Dangun Žengimo sala",
    "AD" to "Andora",
    "AE" to "Jungtiniai Arabų Emyratai",
    "AF" to "Afganistanas",
    "AG" to "Antigva ir Barbuda",
    "AI" to "Angilija",
    "AL" to "Albanija",
    "AM" to "Armėnija",
    "AO" to "Angola",
    "AQ" to "Antarktida",
    "AR" to "Argentina",
    "AS" to "Amerikos Samoa",
    "AT" to "Austrija",
    "AU" to "Australija",
    "AW" to "Aruba",
    "AX" to "Alandų Salos",
    "AZ" to "Azerbaidžanas",
    "BA" to "Bosnija ir Hercegovina",
    "BB" to "Barbadosas",
    "BD" to "Bangladešas",
    "BE" to "Belgija",
    "BF" to "Burkina Fasas",
    "BG" to "Bulgarija",
    "BH" to "Bahreinas",
    "BI" to "Burundis",
    "BJ" to "Beninas",
    "BL" to "Sen Bartelemi",
    "BM" to "Bermuda",
    "BN" to "Brunėjus",
    "BO" to "Bolivija",
    "BQ" to "Karibų Nyderlandai",
    "BR" to "Brazilija",
    "BS" to "Bahamos",
    "BT" to "Butanas",
    "BV" to "Buvė Sala",
    "BW" to "Botsvana",
    "BY" to "Baltarusija",
    "BZ" to "Belizas",
    "CA" to "Kanada",
    "CC" to "Kokosų (Kilingo) Salos",
    "CD" to "Kongas-Kinšasa",
    "CF" to "Centrinės Afrikos Respublika",
    "CG" to "Kongas-Brazavilis",
    "CH" to "Šveicarija",
    "CI" to "Dramblio Kaulo Krantas",
    "CK" to "Kuko Salos",
    "CL" to "Čilė",
    "CM" to "Kamerūnas",
    "CN" to "Kinija",
    "CO" to "Kolumbija",
    "CP" to "Klipertono sala",
    "CR" to "Kosta Rika",
    "CU" to "Kuba",
    "CV" to "Žaliasis Kyšulys",
    "CW" to "Kiurasao",
    "CX" to "Kalėdų Sala",
    "CY" to "Kipras",
    "CZ" to "Čekija",
    "DE" to "Vokietija",
    "DG" to "Diego Garsija",
    "DJ" to "Džibutis",
    "DK" to "Danija",
    "DM" to "Dominika",
    "DO" to "Dominikos Respublika",
    "DZ" to "Alžyras",
    "EA" to "Seuta ir Melila",
    "EC" to "Ekvadoras",
    "EE" to "Estija",
    "EG" to "Egiptas",
    "EH" to "Vakarų Sachara",
    "ER" to "Eritrėja",
    "ES" to "Ispanija",
    "ET" to "Etiopija",
    "EU" to "Europos Sąjunga",
    "EZ" to "euro zona",
    "FI" to "Suomija",
    "FJ" to "Fidžis",
    "FK" to "Folklando Salos",
    "FM" to "Mikronezija",
    "FO" to "Farerų Salos",
    "FR" to "Prancūzija",
    "GA" to "Gabonas",
    "GB" to "Jungtinė Karalystė",
    "GD" to "Grenada",
    "GE" to "Gruzija",
    "GF" to "Prancūzijos Gviana",
    "GG" to "Gernsis",
    "GH" to "Gana",
    "GI" to "Gibraltaras",
    "GL" to "Grenlandija",
    "GM" to "Gambija",
    "GN" to "Gvinėja",
    "GP" to "Gvadelupa",
    "GQ" to "Pusiaujo Gvinėja",
    "GR" to "Graikija",
    "GS" to "Pietų Džordžija ir Pietų Sandvičo salos",
    "GT" to "Gvatemala",
    "GU" to "Guamas",
    "GW" to "Bisau Gvinėja",
    "GY" to "Gajana",
    "HK" to "Ypatingasis Administracinis Kinijos Regionas Honkongas",
    "HM" to "Herdo ir Makdonaldo Salos",
    "HN" to "Hondūras",
    "HR" to "Kroatija",
    "HT" to "Haitis",
    "HU" to "Vengrija",
    "IC" to "Kanarų salos",
    "ID" to "Indonezija",
    "IE" to "Airija",
    "IL" to "Izraelis",
    "IM" to "Meno Sala",
    "IN" to "Indija",
    "IO" to "Indijos Vandenyno Britų Sritis",
    "IQ" to "Irakas",
    "IR" to "Iranas",
    "IS" to "Islandija",
    "IT" to "Italija",
    "JE" to "Džersis",
    "JM" to "Jamaika",
    "JO" to "Jordanija",
    "JP" to "Japonija",
    "KE" to "Kenija",
    "KG" to "Kirgizija",
    "KH" to "Kambodža",
    "KI" to "Kiribatis",
    "KM" to "Komorai",
    "KN" to "Sent Kitsas ir Nevis",
    "KP" to "Šiaurės Korėja",
    "KR" to "Pietų Korėja",
    "KW" to "Kuveitas",
    "KY" to "Kaimanų Salos",
    "KZ" to "Kazachstanas",
    "LA" to "Laosas",
    "LB" to "Libanas",
    "LC" to "Sent Lusija",
    "LI" to "Lichtenšteinas",
    "LK" to "Šri Lanka",
    "LR" to "Liberija",
    "LS" to "Lesotas",
    "LT" to "Lietuva",
    "LU" to "Liuksemburgas",
    "LV" to "Latvija",
    "LY" to "Libija",
    "MA" to "Marokas",
    "MC" to "Monakas",
    "MD" to "Moldova",
    "ME" to "Juodkalnija",
    "MF" to "Sen Martenas",
    "MG" to "Madagaskaras",
    "MH" to "Maršalo Salos",
    "MK" to "Šiaurės Makedonija",
    "ML" to "Malis",
    "MM" to "Mianmaras (Birma)",
    "MN" to "Mongolija",
    "MO" to "Ypatingasis Administracinis Kinijos Regionas Makao",
    "MP" to "Marianos Šiaurinės Salos",
    "MQ" to "Martinika",
    "MR" to "Mauritanija",
    "MS" to "Montseratas",
    "MT" to "Malta",
    "MU" to "Mauricijus",
    "MV" to "Maldyvai",
    "MW" to "Malavis",
    "MX" to "Meksika",
    "MY" to "Malaizija",
    "MZ" to "Mozambikas",
    "NA" to "Namibija",
    "NC" to "Naujoji Kaledonija",
    "NE" to "Nigeris",
    "NF" to "Norfolko sala",
    "NG" to "Nigerija",
    "NI" to "Nikaragva",
    "NL" to "Nyderlandai",
    "NO" to "Norvegija",
    "NP" to "Nepalas",
    "NR" to "Nauru",
    "NU" to "Niujė",
    "NZ" to "Naujoji Zelandija",
    "OM" to "Omanas",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Prancūzijos Polinezija",
    "PG" to "Papua Naujoji Gvinėja",
    "PH" to "Filipinai",
    "PK" to "Pakistanas",
    "PL" to "Lenkija",
    "PM" to "Sen Pjeras ir Mikelonas",
    "PN" to "Pitkerno salos",
    "PR" to "Puerto Rikas",
    "PS" to "Palestinos teritorija",
    "PT" to "Portugalija",
    "PW" to "Palau",
    "PY" to "Paragvajus",
    "QA" to "Kataras",
    "QO" to "Nuošali Okeanija",
    "RE" to "Reunjonas",
    "RO" to "Rumunija",
    "RS" to "Serbija",
    "RU" to "Rusija",
    "RW" to "Ruanda",
    "SA" to "Saudo Arabija",
    "SB" to "Saliamono Salos",
    "SC" to "Seišeliai",
    "SD" to "Sudanas",
    "SE" to "Švedija",
    "SG" to "Singapūras",
    "SH" to "Šv. Elenos Sala",
    "SI" to "Slovėnija",
    "SJ" to "Svalbardas ir Janas Majenas",
    "SK" to "Slovakija",
    "SL" to "Siera Leonė",
    "SM" to "San Marinas",
    "SN" to "Senegalas",
    "SO" to "Somalis",
    "SR" to "Surinamas",
    "SS" to "Pietų Sudanas",
    "ST" to "San Tomė ir Prinsipė",
    "SV" to "Salvadoras",
    "SX" to "Sint Martenas",
    "SY" to "Sirija",
    "SZ" to "Svazilandas",
    "TA" to "Tristano da Kunjos",
    "TC" to "Terkso ir Kaikoso Salos",
    "TD" to "Čadas",
    "TF" to "Prancūzijos Pietų sritys",
    "TG" to "Togas",
    "TH" to "Tailandas",
    "TJ" to "Tadžikija",
    "TK" to "Tokelau",
    "TL" to "Rytų Timoras",
    "TM" to "Turkmėnistanas",
    "TN" to "Tunisas",
    "TO" to "Tonga",
    "TR" to "Turkija",
    "TT" to "Trinidadas ir Tobagas",
    "TV" to "Tuvalu",
    "TW" to "Taivanas",
    "TZ" to "Tanzanija",
    "UA" to "Ukraina",
    "UG" to "Uganda",
    "UM" to "Jungtinių Valstijų Mažosios Tolimosios Salos",
    "UN" to "Jungtinės Tautos",
    "US" to "Jungtinės Valstijos",
    "UY" to "Urugvajus",
    "UZ" to "Uzbekistanas",
    "VA" to "Vatikano Miesto Valstybė",
    "VC" to "Šventasis Vincentas ir Grenadinai",
    "VE" to "Venesuela",
    "VG" to "Didžiosios Britanijos Mergelių Salos",
    "VI" to "Jungtinių Valstijų Mergelių Salos",
    "VN" to "Vietnamas",
    "VU" to "Vanuatu",
    "WF" to "Volisas ir Futūna",
    "WS" to "Samoa",
    "XA" to "pseudo A",
    "XB" to "pseudo B",
    "XK" to "Kosovas",
    "YE" to "Jemenas",
    "YT" to "Majotas",
    "ZA" to "Pietų Afrika",
    "ZM" to "Zambija",
    "ZW" to "Zimbabvė",
    "ZZ" to "nežinoma sritis",
  ) }

  val lu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andore",
    "AE" to "Lemila alabu",
    "AF" to "Afuganisita",
    "AG" to "Antiga ne Barbuda",
    "AI" to "Angiye",
    "AL" to "Alubani",
    "AM" to "Ameni",
    "AO" to "Angola",
    "AR" to "Alijantine",
    "AS" to "Samoa wa Ameriki",
    "AT" to "Otilisi",
    "AU" to "Ositali",
    "AW" to "Aruba",
    "AZ" to "Ajelbayidja",
    "BA" to "Mbosini ne Hezegovine",
    "BB" to "Barebade",
    "BD" to "Benguladeshi",
    "BE" to "Belejiki",
    "BF" to "Bukinafaso",
    "BG" to "Biligari",
    "BH" to "Bahrene",
    "BI" to "Burundi",
    "BJ" to "Bene",
    "BM" to "Bermuda",
    "BN" to "Brineyi",
    "BO" to "Mbolivi",
    "BR" to "Mnulezile",
    "BS" to "Bahamase",
    "BT" to "Butani",
    "BW" to "Mbotswana",
    "BY" to "Byelorisi",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CD" to "Ditunga wa Kongu",
    "CF" to "Ditunga dya Afrika wa munkatshi",
    "CG" to "Kongu",
    "CH" to "Swise",
    "CI" to "Kotedivuale",
    "CK" to "Lutanda lua Kookɛ",
    "CL" to "Shili",
    "CM" to "Kamerune",
    "CN" to "Shine",
    "CO" to "Kolombi",
    "CR" to "Kositarika",
    "CU" to "Kuba",
    "CV" to "Lutanda lua Kapevele",
    "CY" to "Shipele",
    "CZ" to "Ditunga dya Tsheka",
    "DE" to "Alemanu",
    "DJ" to "Djibuti",
    "DK" to "Danemalaku",
    "DM" to "Duminiku",
    "DO" to "Ditunga wa Duminiku",
    "DZ" to "Alijeri",
    "EC" to "Ekwatele",
    "EE" to "Esitoni",
    "EG" to "Mushidi",
    "ER" to "Elitele",
    "ES" to "Nsipani",
    "ET" to "Etshiopi",
    "FI" to "Filande",
    "FJ" to "Fuji",
    "FK" to "Lutanda lua Maluni",
    "FM" to "Mikronezi",
    "FR" to "Nfalanse",
    "GA" to "Ngabu",
    "GB" to "Angeletele",
    "GD" to "Ngelenade",
    "GE" to "Joriji",
    "GF" to "Giyane wa Nfalanse",
    "GH" to "Ngana",
    "GI" to "Jibeletale",
    "GL" to "Ngowelande",
    "GM" to "Gambi",
    "GN" to "Ngine",
    "GP" to "Ngwadelupe",
    "GQ" to "Gine Ekwatele",
    "GR" to "Ngeleka",
    "GT" to "Ngwatemala",
    "GU" to "Ngwame",
    "GW" to "Nginebisau",
    "GY" to "Ngiyane",
    "HN" to "Ondurase",
    "HR" to "Krowasi",
    "HT" to "Ayiti",
    "HU" to "Ongili",
    "ID" to "Indonezi",
    "IE" to "Irelande",
    "IL" to "Isirayele",
    "IN" to "Inde",
    "IQ" to "Iraki",
    "IR" to "Ira",
    "IS" to "Isilande",
    "IT" to "Itali",
    "JM" to "Jamaiki",
    "JO" to "Jodani",
    "JP" to "Japu",
    "KE" to "Kenya",
    "KG" to "Kigizisita",
    "KH" to "Kambodza",
    "KI" to "Kiribati",
    "KM" to "Komoru",
    "KN" to "Santu krístofe ne Neves",
    "KP" to "Kore wa muulu",
    "KR" to "Kore wa mwinshi",
    "KW" to "Koweti",
    "KY" to "Lutanda lua Kayima",
    "KZ" to "Kazakusita",
    "LA" to "Lawosi",
    "LB" to "Liba",
    "LC" to "Santu lisi",
    "LI" to "Lishuteni",
    "LK" to "Sirilanka",
    "LR" to "Liberiya",
    "LS" to "Lesoto",
    "LT" to "Litwani",
    "LU" to "Likisambulu",
    "LV" to "Letoni",
    "LY" to "Libi",
    "MA" to "Maroke",
    "MC" to "Monaku",
    "MD" to "Molidavi",
    "MG" to "Madagasikari",
    "MH" to "Lutanda lua Marishale",
    "ML" to "Mali",
    "MM" to "Myamare",
    "MN" to "Mongoli",
    "MP" to "Lutanda lua Mariane wa muulu",
    "MQ" to "Martiniki",
    "MR" to "Moritani",
    "MS" to "Musera",
    "MT" to "Malite",
    "MU" to "Morise",
    "MV" to "Madive",
    "MW" to "Malawi",
    "MX" to "Meksike",
    "MY" to "Malezi",
    "MZ" to "Mozambiki",
    "NA" to "Namibi",
    "NC" to "Kaledoni wa mumu",
    "NE" to "Nijere",
    "NF" to "Lutanda lua Norfok",
    "NG" to "Nijerya",
    "NI" to "Nikaragwa",
    "NL" to "Olandɛ",
    "NO" to "Noriveje",
    "NP" to "Nepálɛ",
    "NR" to "Nauru",
    "NU" to "Nyue",
    "NZ" to "Zelanda wa mumu",
    "OM" to "Omane",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinezi wa Nfalanse",
    "PG" to "Papwazi wa Nginɛ wa mumu",
    "PH" to "Nfilipi",
    "PK" to "Pakisita",
    "PL" to "Mpoloni",
    "PM" to "Santu pététo ne Mikelu",
    "PN" to "Pikairni",
    "PR" to "Mpotoriku",
    "PS" to "Palesine",
    "PT" to "Mputulugeshi",
    "PW" to "Palau",
    "PY" to "Palagwei",
    "QA" to "Katari",
    "RE" to "Lenyo",
    "RO" to "Romani",
    "RU" to "Risi",
    "RW" to "Rwanda",
    "SA" to "Alabu Nsawudi",
    "SB" to "Lutanda lua Solomu",
    "SC" to "Seshele",
    "SD" to "Suda",
    "SE" to "Suwedi",
    "SG" to "Singapure",
    "SH" to "Santu eleni",
    "SI" to "Siloveni",
    "SK" to "Silovaki",
    "SL" to "Siera Leone",
    "SM" to "Santu Marine",
    "SN" to "Senegale",
    "SO" to "Somali",
    "SR" to "Suriname",
    "ST" to "Sao Tome ne Presipɛ",
    "SV" to "Savadore",
    "SY" to "Siri",
    "SZ" to "Swazilandi",
    "TC" to "Lutanda lua Tuluki ne Kaiko",
    "TD" to "Tshadi",
    "TG" to "Togu",
    "TH" to "Tayilanda",
    "TJ" to "Tazikisita",
    "TK" to "Tokelau",
    "TL" to "Timoru wa diboku",
    "TM" to "Tukemenisita",
    "TN" to "Tinizi",
    "TO" to "Tonga",
    "TR" to "Tuluki",
    "TT" to "Tinidade ne Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tanzani",
    "UA" to "Ukreni",
    "UG" to "Uganda",
    "US" to "Ameriki",
    "UY" to "Irigwei",
    "UZ" to "Uzibekisita",
    "VA" to "Nvatika",
    "VC" to "Santu vesa ne Ngelenadine",
    "VE" to "Venezuela",
    "VG" to "Lutanda lua Vierzi wa Angeletele",
    "VI" to "Lutanda lua Vierzi wa Ameriki",
    "VN" to "Viyetiname",
    "VU" to "Vanuatu",
    "WF" to "Walise ne Futuna",
    "WS" to "Samoa",
    "YE" to "Yemenu",
    "YT" to "Mayote",
    "ZA" to "Afrika ya Súdi",
    "ZM" to "Zambi",
    "ZW" to "Zimbabwe",
  ) }

  val luo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andorra",
    "AE" to "United Arab Emirates",
    "AF" to "Afghanistan",
    "AG" to "Antigua gi Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AR" to "Argentina",
    "AS" to "American Samoa",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AZ" to "Azerbaijan",
    "BA" to "Bosnia gi Herzegovina",
    "BB" to "Barbados",
    "BD" to "Bangladesh",
    "BE" to "Belgium",
    "BF" to "Burkina Faso",
    "BG" to "Bulgaria",
    "BH" to "Bahrain",
    "BI" to "Burundi",
    "BJ" to "Benin",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BR" to "Brazil",
    "BS" to "Bahamas",
    "BT" to "Bhutan",
    "BW" to "Botswana",
    "BY" to "Belarus",
    "BZ" to "Belize",
    "CA" to "Canada",
    "CD" to "Democratic Reof the Congo",
    "CF" to "Central African Republic",
    "CG" to "Congo",
    "CH" to "Switzerland",
    "CI" to "Côte d",
    "CK" to "Cook Islands",
    "CL" to "Chile",
    "CM" to "Cameroon",
    "CN" to "China",
    "CO" to "Colombia",
    "CR" to "Costa Rica",
    "CU" to "Cuba",
    "CV" to "Cape Verde Islands",
    "CY" to "Cyprus",
    "CZ" to "Czech Republic",
    "DE" to "Germany",
    "DJ" to "Djibouti",
    "DK" to "Denmark",
    "DM" to "Dominica",
    "DO" to "Dominican Republic",
    "DZ" to "Algeria",
    "EC" to "Ecuador",
    "EE" to "Estonia",
    "EG" to "Egypt",
    "ER" to "Eritrea",
    "ES" to "Spain",
    "ET" to "Ethiopia",
    "FI" to "Finland",
    "FJ" to "Fiji",
    "FK" to "Chuia mar Falkland",
    "FM" to "Micronesia",
    "FR" to "France",
    "GA" to "Gabon",
    "GB" to "United Kingdom",
    "GD" to "Grenada",
    "GE" to "Georgia",
    "GF" to "French Guiana",
    "GH" to "Ghana",
    "GI" to "Gibraltar",
    "GL" to "Greenland",
    "GM" to "Gambia",
    "GN" to "Guinea",
    "GP" to "Guadeloupe",
    "GQ" to "Equatorial Guinea",
    "GR" to "Greece",
    "GT" to "Guatemala",
    "GU" to "Guam",
    "GW" to "Guinea-Bissau",
    "GY" to "Guyana",
    "HN" to "Honduras",
    "HR" to "Croatia",
    "HT" to "Haiti",
    "HU" to "Hungary",
    "ID" to "Indonesia",
    "IE" to "Ireland",
    "IL" to "Israel",
    "IN" to "India",
    "IQ" to "Iraq",
    "IR" to "Iran",
    "IS" to "Iceland",
    "IT" to "Italy",
    "JM" to "Jamaica",
    "JO" to "Jordan",
    "JP" to "Japan",
    "KE" to "Kenya",
    "KG" to "Kyrgyzstan",
    "KH" to "Cambodia",
    "KI" to "Kiribati",
    "KM" to "Comoros",
    "KN" to "Saint Kitts gi Nevis",
    "KP" to "Korea Masawa",
    "KR" to "Korea Milambo",
    "KW" to "Kuwait",
    "KY" to "Cayman Islands",
    "KZ" to "Kazakhstan",
    "LA" to "Laos",
    "LB" to "Lebanon",
    "LC" to "Saint Lucia",
    "LI" to "Liechtenstein",
    "LK" to "Sri Lanka",
    "LR" to "Liberia",
    "LS" to "Lesotho",
    "LT" to "Lithuania",
    "LU" to "Luxembourg",
    "LV" to "Latvia",
    "LY" to "Libya",
    "MA" to "Morocco",
    "MC" to "Monaco",
    "MD" to "Moldova",
    "MG" to "Madagascar",
    "MH" to "Chuia mar Marshall",
    "ML" to "Mali",
    "MM" to "Myanmar",
    "MN" to "Mongolia",
    "MP" to "Northern Mariana Islands",
    "MQ" to "Martinique",
    "MR" to "Mauritania",
    "MS" to "Montserrat",
    "MT" to "Malta",
    "MU" to "Mauritius",
    "MV" to "Maldives",
    "MW" to "Malawi",
    "MX" to "Mexico",
    "MY" to "Malaysia",
    "MZ" to "Mozambique",
    "NA" to "Namibia",
    "NC" to "New Caledonia",
    "NE" to "Niger",
    "NF" to "Chuia mar Norfolk",
    "NG" to "Nigeria",
    "NI" to "Nicaragua",
    "NL" to "Netherlands",
    "NO" to "Norway",
    "NP" to "Nepal",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "New Zealand",
    "OM" to "Oman",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "French Polynesia",
    "PG" to "Papua New Guinea",
    "PH" to "Philippines",
    "PK" to "Pakistan",
    "PL" to "Poland",
    "PM" to "Saint Pierre gi Miquelon",
    "PN" to "Pitcairn",
    "PR" to "Puerto Rico",
    "PS" to "Palestinian West Bank gi Gaza",
    "PT" to "Portugal",
    "PW" to "Palau",
    "PY" to "Paraguay",
    "QA" to "Qatar",
    "RE" to "Réunion",
    "RO" to "Romania",
    "RU" to "Russia",
    "RW" to "Rwanda",
    "SA" to "Saudi Arabia",
    "SB" to "Solomon Islands",
    "SC" to "Seychelles",
    "SD" to "Sudan",
    "SE" to "Sweden",
    "SG" to "Singapore",
    "SH" to "Saint Helena",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SL" to "Sierra Leone",
    "SM" to "San Marino",
    "SN" to "Senegal",
    "SO" to "Somalia",
    "SR" to "Suriname",
    "ST" to "São Tomé gi Príncipe",
    "SV" to "El Salvador",
    "SY" to "Syria",
    "SZ" to "Swaziland",
    "TC" to "Turks gi Caicos Islands",
    "TD" to "Chad",
    "TG" to "Togo",
    "TH" to "Thailand",
    "TJ" to "Tajikistan",
    "TK" to "Tokelau",
    "TL" to "East Timor",
    "TM" to "Turkmenistan",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Turkey",
    "TT" to "Trinidad gi Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwan",
    "TZ" to "Tanzania",
    "UA" to "Ukraine",
    "UG" to "Uganda",
    "US" to "USA",
    "UY" to "Uruguay",
    "UZ" to "Uzbekistan",
    "VA" to "Vatican State",
    "VC" to "Saint Vincent gi Grenadines",
    "VE" to "Venezuela",
    "VG" to "British Virgin Islands",
    "VI" to "U.S. Virgin Islands",
    "VN" to "Vietnam",
    "VU" to "Vanuatu",
    "WF" to "Wallis gi Futuna",
    "WS" to "Samoa",
    "YE" to "Yemen",
    "YT" to "Mayotte",
    "ZA" to "South Africa",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
  ) }

  val luy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Falme za Kiarabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AR" to "Ajentina",
    "AS" to "Samoa lya Marekani",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AZ" to "Azabajani",
    "BA" to "Bosnia na Hezegovina",
    "BB" to "Babadosi",
    "BD" to "Bangladeshi",
    "BE" to "Ubelgiji",
    "BF" to "Bukinafaso",
    "BG" to "Bulgaria",
    "BH" to "Bahareni",
    "BI" to "Burundi",
    "BJ" to "Benini",
    "BM" to "Bermuda",
    "BN" to "Brunei",
    "BO" to "Bolivia",
    "BR" to "Brazili",
    "BS" to "Bahama",
    "BT" to "Butani",
    "BW" to "Botswana",
    "BY" to "Belarusi",
    "BZ" to "Belize",
    "CA" to "Kanada",
    "CD" to "Jamhuri ya Kidemokrasia ya Kongo",
    "CF" to "Jamhuri ya Afrika ya Kati",
    "CG" to "Kongo",
    "CH" to "Uswisi",
    "CI" to "Kodivaa",
    "CK" to "Visiwa vya Cook",
    "CL" to "Chile",
    "CM" to "Kameruni",
    "CN" to "China",
    "CO" to "Kolombia",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Kepuvede",
    "CY" to "Kuprosi",
    "CZ" to "Jamhuri ya Cheki",
    "DE" to "Ujerumani",
    "DJ" to "Jibuti",
    "DK" to "Denmaki",
    "DM" to "Dominika",
    "DO" to "Jamhuri ya Dominika",
    "DZ" to "Aljeria",
    "EC" to "Ekwado",
    "EE" to "Estonia",
    "EG" to "Misri",
    "ER" to "Eritrea",
    "ES" to "Hispania",
    "ET" to "Uhabeshi",
    "FI" to "Ufini",
    "FJ" to "Fiji",
    "FK" to "Visiwa vya Falkland",
    "FM" to "Mikronesia",
    "FR" to "Ufaransa",
    "GA" to "Gaboni",
    "GB" to "Uingereza",
    "GD" to "Grenada",
    "GE" to "Jojia",
    "GF" to "Gwiyana ya Ufaransa",
    "GH" to "Ghana",
    "GI" to "Jibralta",
    "GL" to "Grinlandi",
    "GM" to "Gambia",
    "GN" to "Gine",
    "GP" to "Gwadelupe",
    "GQ" to "Ginekweta",
    "GR" to "Ugiriki",
    "GT" to "Gwatemala",
    "GU" to "Gwam",
    "GW" to "Ginebisau",
    "GY" to "Guyana",
    "HN" to "Hondurasi",
    "HR" to "Korasia",
    "HT" to "Haiti",
    "HU" to "Hungaria",
    "ID" to "Indonesia",
    "IE" to "Ayalandi",
    "IL" to "Israeli",
    "IN" to "India",
    "IQ" to "Iraki",
    "IR" to "Uajemi",
    "IS" to "Aislandi",
    "IT" to "Italia",
    "JM" to "Jamaika",
    "JO" to "Yordani",
    "JP" to "Japani",
    "KE" to "Kenya",
    "KG" to "Kirigizistani",
    "KH" to "Kambodia",
    "KI" to "Kiribati",
    "KM" to "Komoro",
    "KN" to "Santakitzi na Nevis",
    "KP" to "Korea Kaskazini",
    "KR" to "Korea Kusini",
    "KW" to "Kuwaiti",
    "KY" to "Visiwa vya Kayman",
    "KZ" to "Kazakistani",
    "LA" to "Laosi",
    "LB" to "Lebanoni",
    "LC" to "Santalusia",
    "LI" to "Lishenteni",
    "LK" to "Sirilanka",
    "LR" to "Liberia",
    "LS" to "Lesoto",
    "LT" to "Litwania",
    "LU" to "Lasembagi",
    "LV" to "Lativia",
    "LY" to "Libya",
    "MA" to "Moroko",
    "MC" to "Monako",
    "MD" to "Moldova",
    "MG" to "Bukini",
    "MH" to "Visiwa vya Marshal",
    "ML" to "Mali",
    "MM" to "Myama",
    "MN" to "Mongolia",
    "MP" to "Visiwa vya Mariana vya Kaskazini",
    "MQ" to "Martiniki",
    "MR" to "Moritania",
    "MS" to "Montserrati",
    "MT" to "Malta",
    "MU" to "Morisi",
    "MV" to "Modivu",
    "MW" to "Malawi",
    "MX" to "Meksiko",
    "MY" to "Malesia",
    "MZ" to "Msumbiji",
    "NA" to "Namibia",
    "NC" to "Nyukaledonia",
    "NE" to "Nijeri",
    "NF" to "Kisiwa cha Norfok",
    "NG" to "Nijeria",
    "NI" to "Nikaragwa",
    "NL" to "Uholanzi",
    "NO" to "Norwe",
    "NP" to "Nepali",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Nyuzilandi",
    "OM" to "Omani",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Polinesia ya Ufaransa",
    "PG" to "Papua",
    "PH" to "Filipino",
    "PK" to "Pakistani",
    "PL" to "Polandi",
    "PM" to "Santapieri na Mikeloni",
    "PN" to "Pitkairni",
    "PR" to "Pwetoriko",
    "PS" to "Ukingo wa Magharibi na Ukanda wa Gaza wa Palestina",
    "PT" to "Ureno",
    "PW" to "Palau",
    "PY" to "Paragwai",
    "QA" to "Katari",
    "RE" to "Riyunioni",
    "RO" to "Romania",
    "RU" to "Urusi",
    "RW" to "Rwanda",
    "SA" to "Saudi",
    "SB" to "Visiwa vya Solomon",
    "SC" to "Shelisheli",
    "SD" to "Sudani",
    "SE" to "Uswidi",
    "SG" to "Singapoo",
    "SH" to "Santahelena",
    "SI" to "Slovenia",
    "SK" to "Slovakia",
    "SL" to "Siera Leoni",
    "SM" to "Samarino",
    "SN" to "Senegali",
    "SO" to "Somalia",
    "SR" to "Surinamu",
    "ST" to "Sao Tome na Principe",
    "SV" to "Elsavado",
    "SY" to "Siria",
    "SZ" to "Uswazi",
    "TC" to "Visiwa vya Turki na Kaiko",
    "TD" to "Chadi",
    "TG" to "Togo",
    "TH" to "Tailandi",
    "TJ" to "Tajikistani",
    "TK" to "Tokelau",
    "TL" to "Timori ya Mashariki",
    "TM" to "Turukimenistani",
    "TN" to "Tunisia",
    "TO" to "Tonga",
    "TR" to "Uturuki",
    "TT" to "Trinidad na Tobago",
    "TV" to "Tuvalu",
    "TW" to "Taiwani",
    "TZ" to "Tanzania",
    "UA" to "Ukraini",
    "UG" to "Uganda",
    "US" to "Marekani",
    "UY" to "Urugwai",
    "UZ" to "Uzibekistani",
    "VA" to "Vatikani",
    "VC" to "Santavisenti na Grenadini",
    "VE" to "Venezuela",
    "VG" to "Visiwa vya Virgin vya Uingereza",
    "VI" to "Visiwa vya Virgin vya Marekani",
    "VN" to "Vietinamu",
    "VU" to "Vanuatu",
    "WF" to "Walis na Futuna",
    "WS" to "Samoa",
    "YE" to "Yemeni",
    "YT" to "Mayotte",
    "ZA" to "Afrika Kusini",
    "ZM" to "Zambia",
    "ZW" to "Zimbabwe",
  ) }

  val lv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "pasaule",
    "002" to "Āfrika",
    "003" to "Ziemeļamerika",
    "005" to "Dienvidamerika",
    "009" to "Okeānija",
    "011" to "Rietumāfrika",
    "013" to "Centrālamerika",
    "014" to "Austrumāfrika",
    "015" to "Ziemeļāfrika",
    "017" to "Vidusāfrika",
    "018" to "Dienvidāfrika",
    "019" to "Amerika",
    "021" to "Amerikas ziemeļu daļa",
    "029" to "Karību jūras reģions",
    "030" to "Austrumāzija",
    "034" to "Dienvidāzija",
    "035" to "Centrālaustrumāzija",
    "039" to "Dienvideiropa",
    "053" to "Austrālāzija",
    "054" to "Melanēzija",
    "057" to "Mikronēzijas reģions",
    "061" to "Polinēzija",
    "142" to "Āzija",
    "143" to "Centrālāzija",
    "145" to "Rietumāzija",
    "150" to "Eiropa",
    "151" to "Austrumeiropa",
    "154" to "Ziemeļeiropa",
    "155" to "Rietumeiropa",
    "202" to "Subsahāras Āfrika",
    "419" to "Latīņamerika",
    "AC" to "Debesbraukšanas sala",
    "AD" to "Andora",
    "AE" to "Apvienotie Arābu Emirāti",
    "AF" to "Afganistāna",
    "AG" to "Antigva un Barbuda",
    "AI" to "Angilja",
    "AL" to "Albānija",
    "AM" to "Armēnija",
    "AO" to "Angola",
    "AQ" to "Antarktika",
    "AR" to "Argentīna",
    "AS" to "ASV Samoa",
    "AT" to "Austrija",
    "AU" to "Austrālija",
    "AW" to "Aruba",
    "AX" to "Olandes salas",
    "AZ" to "Azerbaidžāna",
    "BA" to "Bosnija un Hercegovina",
    "BB" to "Barbadosa",
    "BD" to "Bangladeša",
    "BE" to "Beļģija",
    "BF" to "Burkinafaso",
    "BG" to "Bulgārija",
    "BH" to "Bahreina",
    "BI" to "Burundija",
    "BJ" to "Benina",
    "BL" to "Senbartelmī",
    "BM" to "Bermudu salas",
    "BN" to "Bruneja",
    "BO" to "Bolīvija",
    "BQ" to "Nīderlandes Karību salas",
    "BR" to "Brazīlija",
    "BS" to "Bahamu salas",
    "BT" to "Butāna",
    "BV" to "Buvē sala",
    "BW" to "Botsvāna",
    "BY" to "Baltkrievija",
    "BZ" to "Beliza",
    "CA" to "Kanāda",
    "CC" to "Kokosu (Kīlinga) salas",
    "CD" to "Kongo (Kinšasa)",
    "CF" to "Centrālāfrikas Republika",
    "CG" to "Kongo (Brazavila)",
    "CH" to "Šveice",
    "CI" to "Kotdivuāra",
    "CK" to "Kuka salas",
    "CL" to "Čīle",
    "CM" to "Kamerūna",
    "CN" to "Ķīna",
    "CO" to "Kolumbija",
    "CP" to "Klipertona sala",
    "CR" to "Kostarika",
    "CU" to "Kuba",
    "CV" to "Kaboverde",
    "CW" to "Kirasao",
    "CX" to "Ziemsvētku sala",
    "CY" to "Kipra",
    "CZ" to "Čehija",
    "DE" to "Vācija",
    "DG" to "Djego Garsijas atols",
    "DJ" to "Džibutija",
    "DK" to "Dānija",
    "DM" to "Dominika",
    "DO" to "Dominikāna",
    "DZ" to "Alžīrija",
    "EA" to "Seūta un Melilja",
    "EC" to "Ekvadora",
    "EE" to "Igaunija",
    "EG" to "Ēģipte",
    "EH" to "Rietumsahāra",
    "ER" to "Eritreja",
    "ES" to "Spānija",
    "ET" to "Etiopija",
    "EU" to "Eiropas Savienība",
    "EZ" to "Eirozona",
    "FI" to "Somija",
    "FJ" to "Fidži",
    "FK" to "Folklenda salas",
    "FM" to "Mikronēzija",
    "FO" to "Fēru salas",
    "FR" to "Francija",
    "GA" to "Gabona",
    "GB" to "Apvienotā Karaliste",
    "GD" to "Grenāda",
    "GE" to "Gruzija",
    "GF" to "Francijas Gviāna",
    "GG" to "Gērnsija",
    "GH" to "Gana",
    "GI" to "Gibraltārs",
    "GL" to "Grenlande",
    "GM" to "Gambija",
    "GN" to "Gvineja",
    "GP" to "Gvadelupa",
    "GQ" to "Ekvatoriālā Gvineja",
    "GR" to "Grieķija",
    "GS" to "Dienviddžordžija un Dienvidsendviču salas",
    "GT" to "Gvatemala",
    "GU" to "Guama",
    "GW" to "Gvineja-Bisava",
    "GY" to "Gajāna",
    "HK" to "Ķīnas īpašās pārvaldes apgabals Honkonga",
    "HM" to "Hērda sala un Makdonalda salas",
    "HN" to "Hondurasa",
    "HR" to "Horvātija",
    "HT" to "Haiti",
    "HU" to "Ungārija",
    "IC" to "Kanāriju salas",
    "ID" to "Indonēzija",
    "IE" to "Īrija",
    "IL" to "Izraēla",
    "IM" to "Menas sala",
    "IN" to "Indija",
    "IO" to "Indijas okeāna Britu teritorija",
    "IQ" to "Irāka",
    "IR" to "Irāna",
    "IS" to "Islande",
    "IT" to "Itālija",
    "JE" to "Džērsija",
    "JM" to "Jamaika",
    "JO" to "Jordānija",
    "JP" to "Japāna",
    "KE" to "Kenija",
    "KG" to "Kirgizstāna",
    "KH" to "Kambodža",
    "KI" to "Kiribati",
    "KM" to "Komoru salas",
    "KN" to "Sentkitsa un Nevisa",
    "KP" to "Ziemeļkoreja",
    "KR" to "Dienvidkoreja",
    "KW" to "Kuveita",
    "KY" to "Kaimanu salas",
    "KZ" to "Kazahstāna",
    "LA" to "Laosa",
    "LB" to "Libāna",
    "LC" to "Sentlūsija",
    "LI" to "Lihtenšteina",
    "LK" to "Šrilanka",
    "LR" to "Libērija",
    "LS" to "Lesoto",
    "LT" to "Lietuva",
    "LU" to "Luksemburga",
    "LV" to "Latvija",
    "LY" to "Lībija",
    "MA" to "Maroka",
    "MC" to "Monako",
    "MD" to "Moldova",
    "ME" to "Melnkalne",
    "MF" to "Senmartēna",
    "MG" to "Madagaskara",
    "MH" to "Māršala salas",
    "MK" to "Ziemeļmaķedonija",
    "ML" to "Mali",
    "MM" to "Mjanma (Birma)",
    "MN" to "Mongolija",
    "MO" to "ĶTR īpašais administratīvais reģions Makao",
    "MP" to "Ziemeļu Marianas salas",
    "MQ" to "Martinika",
    "MR" to "Mauritānija",
    "MS" to "Montserrata",
    "MT" to "Malta",
    "MU" to "Maurīcija",
    "MV" to "Maldīvija",
    "MW" to "Malāvija",
    "MX" to "Meksika",
    "MY" to "Malaizija",
    "MZ" to "Mozambika",
    "NA" to "Namībija",
    "NC" to "Jaunkaledonija",
    "NE" to "Nigēra",
    "NF" to "Norfolkas sala",
    "NG" to "Nigērija",
    "NI" to "Nikaragva",
    "NL" to "Nīderlande",
    "NO" to "Norvēģija",
    "NP" to "Nepāla",
    "NR" to "Nauru",
    "NU" to "Niue",
    "NZ" to "Jaunzēlande",
    "OM" to "Omāna",
    "PA" to "Panama",
    "PE" to "Peru",
    "PF" to "Francijas Polinēzija",
    "PG" to "Papua-Jaungvineja",
    "PH" to "Filipīnas",
    "PK" to "Pakistāna",
    "PL" to "Polija",
    "PM" to "Senpjēra un Mikelona",
    "PN" to "Pitkērnas salas",
    "PR" to "Puertoriko",
    "PS" to "Palestīnas teritorijas",
    "PT" to "Portugāle",
    "PW" to "Palau",
    "PY" to "Paragvaja",
    "QA" to "Katara",
    "QO" to "Okeānijas attālās salas",
    "RE" to "Reinjona",
    "RO" to "Rumānija",
    "RS" to "Serbija",
    "RU" to "Krievija",
    "RW" to "Ruanda",
    "SA" to "Saūda Arābija",
    "SB" to "Zālamana salas",
    "SC" to "Seišelu salas",
    "SD" to "Sudāna",
    "SE" to "Zviedrija",
    "SG" to "Singapūra",
    "SH" to "Sv.Helēnas sala",
    "SI" to "Slovēnija",
    "SJ" to "Svalbāra un Jana Majena sala",
    "SK" to "Slovākija",
    "SL" to "Sjerraleone",
    "SM" to "Sanmarīno",
    "SN" to "Senegāla",
    "SO" to "Somālija",
    "SR" to "Surinama",
    "SS" to "Dienvidsudāna",
    "ST" to "Santome un Prinsipi",
    "SV" to "Salvadora",
    "SX" to "Sintmārtena",
    "SY" to "Sīrija",
    "SZ" to "Svatini",
    "TA" to "Tristana da Kuņjas salu teritorijas",
    "TC" to "Tērksas un Kaikosas salas",
    "TD" to "Čada",
    "TF" to "Francijas Dienvidjūru teritorija",
    "TG" to "Togo",
    "TH" to "Taizeme",
    "TJ" to "Tadžikistāna",
    "TK" to "Tokelau",
    "TL" to "Austrumtimora",
    "TM" to "Turkmenistāna",
    "TN" to "Tunisija",
    "TO" to "Tonga",
    "TR" to "Turcija",
    "TT" to "Trinidāda un Tobāgo",
    "TV" to "Tuvalu",
    "TW" to "Taivāna",
    "TZ" to "Tanzānija",
    "UA" to "Ukraina",
    "UG" to "Uganda",
    "UM" to "ASV Mazās Aizjūras salas",
    "UN" to "Apvienoto Nāciju Organizācija",
    "US" to "Amerikas Savienotās Valstis",
    "UY" to "Urugvaja",
    "UZ" to "Uzbekistāna",
    "VA" to "Vatikāns",
    "VC" to "Sentvinsenta un Grenadīnas",
    "VE" to "Venecuēla",
    "VG" to "Britu Virdžīnas",
    "VI" to "ASV Virdžīnas",
    "VN" to "Vjetnama",
    "VU" to "Vanuatu",
    "WF" to "Volisa un Futunas salas",
    "WS" to "Samoa",
    "XA" to "pseidoakcenti",
    "XB" to "pseidodivvirzienu",
    "XK" to "Kosova",
    "YE" to "Jemena",
    "YT" to "Majota",
    "ZA" to "Dienvidāfrikas Republika",
    "ZM" to "Zambija",
    "ZW" to "Zimbabve",
    "ZZ" to "nezināms reģions",
  ) }

  val mai: ImmutableMap<String, String> by lazy { immutableMapOf(
    "001" to "विश्व",
    "002" to "अफ्रीका",
    "003" to "उत्तरी अमेरिका",
    "005" to "दक्षिण अमेरिका",
    "009" to "ओसेनिया",
    "011" to "पश्चिमी अफ्रीका",
    "013" to "मध्य अमेरिका",
    "014" to "पूरबी अफ्रीका",
    "015" to "उत्तरी अफ्रीका",
    "017" to "मध्य अफ्रीका",
    "018" to "दक्षिणी अफ्रीका",
    "019" to "अमेरिका",
    "021" to "उत्तर अमेरिका",
    "029" to "कैरिबियाई",
    "030" to "पूरबी एशिया",
    "034" to "दक्षिणी एशिया",
    "035" to "दक्षिण-पूरबी एशिया",
    "039" to "दक्षिणी यूरोप",
    "053" to "आस्ट्रेलेशिया",
    "054" to "मेलानेशिया",
    "057" to "माइक्रोनेशियाई क्षेत्र",
    "061" to "पोलिनेशिया",
    "142" to "एशिया",
    "143" to "मध्य एशिया",
    "145" to "पश्चिमी एशिया",
    "150" to "यूरोप",
    "151" to "पूरबी यूरोप",
    "154" to "उत्तरी यूरोप",
    "155" to "पश्चिमी यूरोप",
    "202" to "उप सहारा अफ्रीका",
    "419" to "लातिन अमेरिका",
    "AC" to "असेंशन द्वीप",
    "AD" to "एंडोरा",
    "AE" to "संयुक्त अरब अमीरात",
    "AF" to "अफगानिस्तान",
    "AG" to "एंटिगुआ आ बारबुडा",
    "AI" to "एंग्विला",
    "AL" to "अलबानिया",
    "AM" to "आरमेनिया",
    "AO" to "अंगोला",
    "AQ" to "अंटार्टिका",
    "AR" to "अर्जेंटिना",
    "AS" to "अमेरिकी समोआ",
    "AT" to "आस्ट्रिया",
    "AU" to "आस्ट्रेलिया",
    "AW" to "अरूबा",
    "AX" to "अलैंड द्वीपसमूह",
    "AZ" to "अजरबैजान",
    "BA" to "बोस्निया आ हर्जेगोबिना",
    "BB" to "बारबाडोस",
    "BD" to "बंगलादेश",
    "BE" to "बेल्जियम",
    "BF" to "बुरकिना फासो",
    "BG" to "बुल्गारिया",
    "BH" to "बहरीन",
    "BI" to "बुरूंडी",
    "BJ" to "बेनिन",
    "BL" to "सेंट बार्थेलेमी",
    "BM" to "बरमुडा",
    "BN" to "ब्रूनेई",
    "BO" to "बोलिबिया",
    "BQ" to "कैरिबियाई नीदरलैंड",
    "BR" to "ब्राज़ील",
    "BS" to "बहामास",
    "BT" to "भूटान",
    "BV" to "बोबेत द्वीप",
    "BW" to "बोत्सबाना",
    "BY" to "बेलारूस",
    "BZ" to "बेलीज",
    "CA" to "कनाडा",
    "CC" to "कोकेज (कीलिंग) द्वीपसमूह",
    "CD" to "कांगो-किंशासा",
    "CF" to "मध्य अफ्रीकी रिपब्लिक",
    "CG" to "कांगो-ब्राजाबिले",
    "CH" to "स्विट्जरलैंड",
    "CI" to "कोट डी आइवर",
    "CK" to "कुक द्वीपसमूह",
    "CL" to "चिली",
    "CM" to "कैमरून",
    "CN" to "चीन",
    "CO" to "कोलंबिया",
    "CP" to "क्लिपर्टन द्वीप",
    "CR" to "कोस्टारिका",
    "CU" to "क्यूबा",
    "CV" to "कैप बर्डे",
    "CW" to "कुरासाओ",
    "CX" to "क्रिसमस द्वीप",
    "CY" to "साइप्रस",
    "CZ" to "चेकिया",
    "DE" to "जर्मनी",
    "DG" to "डियागो गार्सिया",
    "DJ" to "जिबूति",
    "DK" to "डेनमार्क",
    "DM" to "डोमिनिका",
    "DO" to "डोमिनिकन रिपब्लिक",
    "DZ" to "अल्जीरिया",
    "EA" to "सेउटा आ मेलिला",
    "EC" to "इक्वाडोर",
    "EE" to "एस्टोनिया",
    "EG" to "मिस्र",
    "EH" to "पश्चिमी सहारा",
    "ER" to "एरिट्रिया",
    "ES" to "स्पेन",
    "ET" to "इथोपिया",
    "EU" to "यूरोपीय यूनियन",
    "EZ" to "यूरो जोन",
    "FI" to "फिनलैंड",
    "FJ" to "फिजी",
    "FK" to "फाकलैंड द्वीपसमूह",
    "FM" to "माइक्रोनेशिया",
    "FO" to "फेरो द्वीपसमूह",
    "FR" to "फ़्रांस",
    "GA" to "गैबन",
    "GB" to "यूनाइटेड किंगडम",
    "GD" to "ग्रेनाडा",
    "GE" to "जार्जिया",
    "GF" to "फ्रेंच गुयाना",
    "GG" to "गर्नसी",
    "GH" to "घाना",
    "GI" to "जिब्राल्टर",
    "GL" to "ग्रीनलैंड",
    "GM" to "गाम्बिया",
    "GN" to "गिनी",
    "GP" to "ग्वाडेलूप",
    "GQ" to "इक्वेटोरियल गिनी",
    "GR" to "यूनान",
    "GS" to "दक्षिण जार्जिया आ दक्षिण सैंडविच द्वीपसमूह",
    "GT" to "ग्वाटेमाला",
    "GU" to "गुआम",
    "GW" to "गिनी-बिसाऊ",
    "GY" to "गुयाना",
    "HK" to "हांग कांग (विशेष प्रशासनिक क्षेत्र चीन)",
    "HM" to "हर्ड आ मैकडोनल्ड द्वीपसमूह",
    "HN" to "होंडुरास",
    "HR" to "क्रोएशिया",
    "HT" to "हैती",
    "HU" to "हंगरी",
    "IC" to "कैनरी द्वीपसमूह",
    "ID" to "इंडोनेशिया",
    "IE" to "आयरलैंड",
    "IL" to "इजरायल",
    "IM" to "आइल ऑफ मैन",
    "IN" to "भारत",
    "IO" to "ब्रिटिश हिंद महासागरीय क्षेत्र",
    "IQ" to "इराक",
    "IR" to "ईरान",
    "IS" to "आइसलैंड",
    "IT" to "इटली",
    "JE" to "जरसी",
    "JM" to "जमैका",
    "JO" to "जार्डन",
    "JP" to "जापान",
    "KE" to "केन्या",
    "KG" to "किर्गिजस्तान",
    "KH" to "कंबोडिया",
    "KI" to "किरिबाती",
    "KM" to "कोमोरोस",
    "KN" to "सेंट किट्स आ नेविस",
    "KP" to "उत्तर कोरिया",
    "KR" to "दक्षिण कोरिया",
    "KW" to "कुवैत",
    "KY" to "कैमेन द्वीपसमूह",
    "KZ" to "कजाखस्तान",
    "LA" to "लाओस",
    "LB" to "लेबनान",
    "LC" to "सेंट लूसिया",
    "LI" to "लिख्तेंस्ताइन",
    "LK" to "श्रीलंका",
    "LR" to "लाइबेरिया",
    "LS" to "लेसोथो",
    "LT" to "लिथुआनिया",
    "LU" to "लग्जमबर्ग",
    "LV" to "लातविया",
    "LY" to "लीबिया",
    "MA" to "मोरोक्को",
    "MC" to "मोनाको",
    "MD" to "मोलडोवा",
    "ME" to "मोंटेनीग्रो",
    "MF" to "सेंट मार्टिन",
    "MG" to "मेडागास्कर",
    "MH" to "मार्शल द्वीपसमूह",
    "MK" to "उत्तरी मकदूनिया",
    "ML" to "माली",
    "MM" to "मयनमार (बर्मा)",
    "MN" to "मंगोलिया",
    "MO" to "मकाउ (विशेष प्रशासनिक क्षेत्र चीन)",
    "MP" to "उत्तर मरीना द्वीपसमूह",
    "MQ" to "मार्टिनिक",
    "MR" to "मारिटानिया",
    "MS" to "मोंटसेरात",
    "MT" to "माल्टा",
    "MU" to "मारीशस",
    "MV" to "मालदीब",
    "MW" to "मलाबी",
    "MX" to "मैक्सिको",
    "MY" to "मलेशिया",
    "MZ" to "मोजाम्बिक",
    "NA" to "नामीबिया",
    "NC" to "न्यू कैलेडोनिया",
    "NE" to "नाइजर",
    "NF" to "नौरफोक द्वीप",
    "NG" to "नाइजीरिया",
    "NI" to "निकारागुआ",
    "NL" to "नीदरलैंड",
    "NO" to "नार्वे",
    "NP" to "नेपाल",
    "NR" to "नौरू",
    "NU" to "नीयू",
    "NZ" to "न्यूजीलैंड",
    "OM" to "ओमान",
    "PA" to "पनामा",
    "PE" to "पेरू",
    "PF" to "फ्रेंच पोलिनेशिया",
    "PG" to "पापुआ न्यू गिनी",
    "PH" to "फिलिपींस",
    "PK" to "पाकिस्तान",
    "PL" to "पोलैंड",
    "PM" to "सेंट पियरे आ मिक्वेलान",
    "PN" to "पिटकेयर्न द्वीपसमूह",
    "PR" to "प्योर्टो रिको",
    "PS" to "फिलिस्तीनी क्षेत्र",
    "PT" to "पुर्तगाल",
    "PW" to "पलाऊ",
    "PY" to "पराग्वे",
    "QA" to "कतर",
    "QO" to "आउटलाइंग ओसेनिया",
    "RE" to "रियूनियन",
    "RO" to "रोमानिया",
    "RS" to "सर्बिया",
    "RU" to "रूस",
    "RW" to "रवांडा",
    "SA" to "सऊदी अरब",
    "SB" to "सोलोमन द्वीपसमूह",
    "SC" to "सेशेल्स",
    "SD" to "सूडान",
    "SE" to "स्वीडन",
    "SG" to "सिंगापुर",
    "SH" to "सेंट हेलेना",
    "SI" to "स्लोबेनिया",
    "SJ" to "स्वालबार्ड आ जान मायेन",
    "SK" to "स्लोवाकिया",
    "SL" to "सियरा लियोन",
    "SM" to "सेन मरीनो",
    "SN" to "सेनेगल",
    "SO" to "सोमालिया",
    "SR" to "सुरीनाम",
    "SS" to "दक्षिण सुडान",
    "ST" to "साओ टोम आ प्रिंसिप",
    "SV" to "अल सल्वाडोर",
    "SX" to "सिंट मार्टेन",
    "SY" to "सीरिया",
    "SZ" to "एस्वाटिनी",
    "TA" to "ट्रिस्टन दा कुना",
    "TC" to "तुर्क आ कैकोज द्वीपसमूह",
    "TD" to "चाड",
    "TF" to "फ्रांसीसी दक्षिणी क्षेत्र",
    "TG" to "टोगो",
    "TH" to "थाईलैंड",
    "TJ" to "ताजिकिस्तान",
    "TK" to "टोकेलाऊ",
    "TL" to "तिमोर-लेस्त",
    "TM" to "तुर्कमेनिस्तान",
    "TN" to "ट्यूनिशिया",
    "TO" to "टोंगा",
    "TR" to "तुर्की",
    "TT" to "ट्रिनिदाद आ टोबैगो",
    "TV" to "टुवालू",
    "TW" to "ताइबान",
    "TZ" to "तंजानिया",
    "UA" to "यूक्रेन",
    "UG" to "युगांडा",
    "UM" to "यू॰एस॰ आउटलाइंग द्वीपसमूह",
    "UN" to "संयुक्त राष्ट्र",
    "US" to "संयुक्त राज्य",
    "UY" to "उरुग्वे",
    "UZ" to "उजबेकिस्तान",
    "VA" to "वेटिकन सिटी",
    "VC" to "सेंट विंसेंट आ ग्रेनाडाइंस",
    "VE" to "बेनेजुएला",
    "VG" to "ब्रिटिश वर्जिन द्वीपसमूह",
    "VI" to "यू॰एस॰ वर्जिन द्वीपसमूह",
    "VN" to "बियतनाम",
    "VU" to "बनातू",
    "WF" to "बालिस आ फुटुना",
    "WS" to "समोआ",
    "XA" to "छद्म उच्चारण",
    "XB" to "छद्म बिडि",
    "XK" to "कोसोवो",
    "YE" to "यमन",
    "YT" to "मयोटे",
    "ZA" to "दक्षिण अफ्रीका",
    "ZM" to "जाम्बिया",
    "ZW" to "जिम्बाब्बे",
    "ZZ" to "अज्ञात क्षेत्र",
  ) }

  val mas: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AD" to "Andora",
    "AE" to "Falme za Kiarabu",
    "AF" to "Afuganistani",
    "AG" to "Antigua na Barbuda",
    "AI" to "Anguilla",
    "AL" to "Albania",
    "AM" to "Armenia",
    "AO" to "Angola",
    "AR" to "Ajentina",
    "AS" to "Samoa ya Marekani",
    "AT" to "Austria",
    "AU" to "Australia",
    "AW" to "Aruba",
    "AZ" to "Azabajani",
    "BA" to "Bosnia na Hezegovina",
    "BB" to "Babadosi",