package net.codinux.i18n

import kotlin.String

/**
 * @param isoCode Lowercase alpha-2 two-letter or alpha-3 three-letter ISO 639 language code.
 */
enum class Language(
  val isoCode: String,
) {
  Afar("aa"),
  Abkhazian("ab"),
  Acehnese("ace"),
  Acoli("ach"),
  Adangme("ada"),
  Adyghe("ady"),
  Avestan("ae"),
  TunisianArabic("aeb"),
  Afrikaans("af"),
  Afrihili("afh"),
  Aghem("agq"),
  Ainu("ain"),
  SouthernLevantineArabic("ajp"),
  Akan("ak"),
  Akkadian("akk"),
  Alabama("akz"),
  Aleut("ale"),
  GhegAlbanian("aln"),
  SouthernAltai("alt"),
  Amharic("am"),
  Aragonese("an"),
  OldEnglish("ang"),
  Obolo("ann"),
  Angika("anp"),
  LevantineArabic("apc"),
  Arabic("ar"),
  ModernStandardArabic("ar-001"),
  Aramaic("arc"),
  Mapuche("arn"),
  Araona("aro"),
  Arapaho("arp"),
  AlgerianArabic("arq"),
  NajdiArabic("ars"),
  ArabicNajdi("ars-alt-menu"),
  Arawak("arw"),
  MoroccanArabic("ary"),
  EgyptianArabic("arz"),
  Assamese("as"),
  Asu("asa"),
  AmericanSignLanguage("ase"),
  Asturian("ast"),
  Atikamekw("atj"),
  Avaric("av"),
  Kotava("avk"),
  Awadhi("awa"),
  Aymara("ay"),
  Azerbaijani("az"),
  Azeri("az-alt-short"),
  Bashkir("ba"),
  Baluchi("bal"),
  Balinese("ban"),
  Bavarian("bar"),
  Basaa("bas"),
  Bamun("bax"),
  BatakToba("bbc"),
  Ghomala("bbj"),
  Belarusian("be"),
  Beja("bej"),
  Bemba("bem"),
  Betawi("bew"),
  Bena("bez"),
  Bafut("bfd"),
  Badaga("bfq"),
  Bulgarian("bg"),
  Haryanvi("bgc"),
  WesternBalochi("bgn"),
  Bhojpuri("bho"),
  Bislama("bi"),
  Bikol("bik"),
  Bini("bin"),
  Banjar("bjn"),
  Kom("bkm"),
  Siksika("bla"),
  Anii("blo"),
  TaiDam("blt"),
  Bambara("bm"),
  Bangla("bn"),
  Tibetan("bo"),
  Bishnupriya("bpy"),
  Bakhtiari("bqi"),
  Breton("br"),
  Braj("bra"),
  Brahui("brh"),
  Bodo("brx"),
  Bosnian("bs"),
  Akoose("bss"),
  Buriat("bua"),
  Buginese("bug"),
  Bulu("bum"),
  Blin("byn"),
  Medumba("byv"),
  Catalan("ca"),
  Caddo("cad"),
  Carib("car"),
  Cayuga("cay"),
  Atsam("cch"),
  Chakma("ccp"),
  Chechen("ce"),
  Cebuano("ceb"),
  Chiga("cgg"),
  Chamorro("ch"),
  Chibcha("chb"),
  Chagatai("chg"),
  Chuukese("chk"),
  Mari("chm"),
  ChinookJargon("chn"),
  Choctaw("cho"),
  Chipewyan("chp"),
  Cherokee("chr"),
  Cheyenne("chy"),
  Chickasaw("cic"),
  CentralKurdish("ckb"),
  KurdishCentral("ckb-alt-menu"),
  KurdishSorani("ckb-alt-variant"),
  Chilcotin("clc"),
  Corsican("co"),
  Coptic("cop"),
  Capiznon("cps"),
  Cree("cr"),
  Michif("crg"),
  CrimeanTatar("crh"),
  SouthernEastCree("crj"),
  PlainsCree("crk"),
  NorthernEastCree("crl"),
  MooseCree("crm"),
  CarolinaAlgonquian("crr"),
  SeselwaCreoleFrench("crs"),
  Czech("cs"),
  Kashubian("csb"),
  SwampyCree("csw"),
  ChurchSlavic("cu"),
  Chuvash("cv"),
  WoodsCree("cwd"),
  Welsh("cy"),
  Danish("da"),
  Dakota("dak"),
  Dargwa("dar"),
  Taita("dav"),
  German("de"),
  AustrianGerman("de-AT"),
  SwissHighGerman("de-CH"),
  Delaware("del"),
  Slave("den"),
  Dogrib("dgr"),
  Dinka("din"),
  Zarma("dje"),
  Dogri("doi"),
  LowerSorbian("dsb"),
  CentralDusun("dtp"),
  Duala("dua"),
  MiddleDutch("dum"),
  Divehi("dv"),
  JolaFonyi("dyo"),
  Dyula("dyu"),
  Dzongkha("dz"),
  Dazaga("dzg"),
  Embu("ebu"),
  Ewe("ee"),
  Efik("efi"),
  Emilian("egl"),
  AncientEgyptian("egy"),
  Ekajuk("eka"),
  Greek("el"),
  Elamite("elx"),
  English("en"),
  AustralianEnglish("en-AU"),
  CanadianEnglish("en-CA"),
  BritishEnglish("en-GB"),
  UKEnglish("en-GB-alt-short"),
  AmericanEnglish("en-US"),
  USEnglish("en-US-alt-short"),
  MiddleEnglish("enm"),
  Esperanto("eo"),
  Spanish("es"),
  LatinAmericanSpanish("es-419"),
  EuropeanSpanish("es-ES"),
  MexicanSpanish("es-MX"),
  CentralYupik("esu"),
  Estonian("et"),
  Basque("eu"),
  Ewondo("ewo"),
  Extremaduran("ext"),
  Persian("fa"),
  Dari("fa-AF"),
  Fang("fan"),
  Fanti("fat"),
  Fula("ff"),
  Finnish("fi"),
  Filipino("fil"),
  TornedalenFinnish("fit"),
  Fijian("fj"),
  Faroese("fo"),
  Fon("fon"),
  French("fr"),
  CanadianFrench("fr-CA"),
  SwissFrench("fr-CH"),
  CajunFrench("frc"),
  MiddleFrench("frm"),
  OldFrench("fro"),
  Arpitan("frp"),
  NorthernFrisian("frr"),
  EasternFrisian("frs"),
  Friulian("fur"),
  WesternFrisian("fy"),
  Irish("ga"),
  Ga("gaa"),
  Gagauz("gag"),
  GanChinese("gan"),
  Gayo("gay"),
  Gbaya("gba"),
  ZoroastrianDari("gbz"),
  ScottishGaelic("gd"),
  Geez("gez"),
  Gilbertese("gil"),
  Galician("gl"),
  Gilaki("glk"),
  MiddleHighGerman("gmh"),
  Guarani("gn"),
  OldHighGerman("goh"),
  Gondi("gon"),
  Gorontalo("gor"),
  Gothic("got"),
  Grebo("grb"),
  AncientGreek("grc"),
  SwissGerman("gsw"),
  Gujarati("gu"),
  Wayuu("guc"),
  Frafra("gur"),
  Gusii("guz"),
  Manx("gv"),
  Gwichin("gwi"),
  Hausa("ha"),
  Haida("hai"),
  HakkaChinese("hak"),
  Hawaiian("haw"),
  SouthernHaida("hax"),
  NorthernHaida("hdn"),
  Hebrew("he"),
  Hindi("hi"),
  HindiLatin("hi-Latn"),
  Hinglish("hi-Latn-alt-variant"),
  FijiHindi("hif"),
  Hiligaynon("hil"),
  Hittite("hit"),
  Hmong("hmn"),
  HmongNjua("hnj"),
  HiriMotu("ho"),
  Croatian("hr"),
  UpperSorbian("hsb"),
  XiangChinese("hsn"),
  HaitianCreole("ht"),
  Hungarian("hu"),
  Hupa("hup"),
  Halkomelem("hur"),
  Armenian("hy"),
  Herero("hz"),
  Interlingua("ia"),
  Iban("iba"),
  Ibibio("ibb"),
  Indonesian("id"),
  Interlingue("ie"),
  Igbo("ig"),
  SichuanYi("ii"),
  Inupiaq("ik"),
  EasternCanadianInuktitut("ike"),
  WesternCanadianInuktitut("ikt"),
  Iloko("ilo"),
  Ingush("inh"),
  Ido("io"),
  Icelandic("is"),
  Italian("it"),
  Inuktitut("iu"),
  Ingrian("izh"),
  Japanese("ja"),
  JamaicanCreoleEnglish("jam"),
  Lojban("jbo"),
  Ngomba("jgo"),
  Machame("jmc"),
  JudeoPersian("jpr"),
  JudeoArabic("jrb"),
  Jutish("jut"),
  Javanese("jv"),
  Georgian("ka"),
  KaraKalpak("kaa"),
  Kabyle("kab"),
  Kachin("kac"),
  Jju("kaj"),
  Kamba("kam"),
  Kawi("kaw"),
  Kabardian("kbd"),
  Kanembu("kbl"),
  Tyap("kcg"),
  Makonde("kde"),
  Kabuverdianu("kea"),
  Kenyang("ken"),
  Koro("kfo"),
  Kongo("kg"),
  Kaingang("kgp"),
  Khasi("kha"),
  Khotanese("kho"),
  KoyraChiini("khq"),
  Khowar("khw"),
  Kikuyu("ki"),
  Kirmanjki("kiu"),
  Kuanyama("kj"),
  Kazakh("kk"),
  Kako("kkj"),
  Kalaallisut("kl"),
  Kalenjin("kln"),
  Khmer("km"),
  Kimbundu("kmb"),
  Kannada("kn"),
  Korean("ko"),
  KomiPermyak("koi"),
  Konkani("kok"),
  Kosraean("kos"),
  Kpelle("kpe"),
  Kanuri("kr"),
  KarachayBalkar("krc"),
  Krio("kri"),
  KinarayA("krj"),
  Karelian("krl"),
  Kurukh("kru"),
  Kashmiri("ks"),
  Shambala("ksb"),
  Bafia("ksf"),
  Colognian("ksh"),
  Kurdish("ku"),
  Kumyk("kum"),
  Kutenai("kut"),
  Komi("kv"),
  Cornish("kw"),
  Kwakwala("kwk"),
  Kuvi("kxv"),
  Kyrgyz("ky"),
  Kirghiz("ky-alt-variant"),
  Latin("la"),
  Ladino("lad"),
  Langi("lag"),
  WesternPanjabi("lah"),
  Lamba("lam"),
  Luxembourgish("lb"),
  Lezghian("lez"),
  LinguaFrancaNova("lfn"),
  Ganda("lg"),
  Limburgish("li"),
  Ligurian("lij"),
  Lillooet("lil"),
  Livonian("liv"),
  Lakota("lkt"),
  Ladin("lld"),
  Lombard("lmo"),
  Lingala("ln"),
  Lao("lo"),
  Mongo("lol"),
  LouisianaCreole("lou"),
  Lozi("loz"),
  NorthernLuri("lrc"),
  Saamia("lsm"),
  Lithuanian("lt"),
  Latgalian("ltg"),
  LubaKatanga("lu"),
  LubaLulua("lua"),
  Luiseno("lui"),
  Lunda("lun"),
  Luo("luo"),
  Mizo("lus"),
  Luyia("luy"),
  Latvian("lv"),
  LiteraryChinese("lzh"),
  Laz("lzz"),
  Madurese("mad"),
  Mafa("maf"),
  Magahi("mag"),
  Maithili("mai"),
  Makasar("mak"),
  Mandingo("man"),
  Masai("mas"),
  Maba("mde"),
  Moksha("mdf"),
  Mandar("mdr"),
  Mende("men"),
  Meru("mer"),
  Morisyen("mfe"),
  Malagasy("mg"),
  MiddleIrish("mga"),
  MakhuwaMeetto("mgh"),
  Meta("mgo"),
  Marshallese("mh"),
  Mocheno("mhn"),
  Maori("mi"),
  Mikmaw("mic"),
  Minangkabau("min"),
  Macedonian("mk"),
  Malayalam("ml"),
  Mongolian("mn"),
  Manchu("mnc"),
  Manipuri("mni"),
  InnuAimun("moe"),
  Mohawk("moh"),
  Mossi("mos"),
  Marathi("mr"),
  WesternMari("mrj"),
  Malay("ms"),
  Maltese("mt"),
  Mundang("mua"),
  MultipleLanguages("mul"),
  Muscogee("mus"),
  Mvskoke("mus-alt-official"),
  Mirandese("mwl"),
  Marwari("mwr"),
  Mentawai("mwv"),
  Burmese("my"),
  MyanmarLanguage("my-alt-variant"),
  Myene("mye"),
  Erzya("myv"),
  Mazanderani("mzn"),
  Nauru("na"),
  MinNanChinese("nan"),
  Neapolitan("nap"),
  Nama("naq"),
  NorwegianBokmal("nb"),
  NorthNdebele("nd"),
  LowGerman("nds"),
  LowSaxon("nds-NL"),
  Nepali("ne"),
  Newari("new"),
  Ndonga("ng"),
  Nias("nia"),
  Niuean("niu"),
  AoNaga("njo"),
  Dutch("nl"),
  Flemish("nl-BE"),
  Kwasio("nmg"),
  NorwegianNynorsk("nn"),
  Ngiemboon("nnh"),
  Norwegian("no"),
  Nogai("nog"),
  OldNorse("non"),
  Novial("nov"),
  NKo("nqo"),
  SouthNdebele("nr"),
  NorthernSotho("nso"),
  Nuer("nus"),
  Navajo("nv"),
  ClassicalNewari("nwc"),
  Nyanja("ny"),
  Nyamwezi("nym"),
  Nyankole("nyn"),
  Nyoro("nyo"),
  Nzima("nzi"),
  Occitan("oc"),
  Ojibwa("oj"),
  NorthwesternOjibwa("ojb"),
  CentralOjibwa("ojc"),
  EasternOjibwa("ojg"),
  OjiCree("ojs"),
  WesternOjibwa("ojw"),
  Okanagan("oka"),
  Oromo("om"),
  Odia("or"),
  Ossetic("os"),
  Osage("osa"),
  OttomanTurkish("ota"),
  Punjabi("pa"),
  Pangasinan("pag"),
  Pahlavi("pal"),
  Pampanga("pam"),
  Papiamento("pap"),
  Palauan("pau"),
  Picard("pcd"),
  NigerianPidgin("pcm"),
  PennsylvaniaGerman("pdc"),
  Plautdietsch("pdt"),
  OldPersian("peo"),
  PalatineGerman("pfl"),
  Phoenician("phn"),
  Pali("pi"),
  Pijin("pis"),
  Polish("pl"),
  Piedmontese("pms"),
  Pontic("pnt"),
  Pohnpeian("pon"),
  MaliseetPassamaquoddy("pqm"),
  Prussian("prg"),
  OldProvencal("pro"),
  Pashto("ps"),
  Pushto("ps-alt-variant"),
  Portuguese("pt"),
  BrazilianPortuguese("pt-BR"),
  EuropeanPortuguese("pt-PT"),
  Quechua("qu"),
  Kiche("quc"),
  ChimborazoHighlandQuichua("qug"),
  Rajasthani("raj"),
  Rapanui("rap"),
  Rarotongan("rar"),
  Romagnol("rgn"),
  Rohingya("rhg"),
  Riffian("rif"),
  Romansh("rm"),
  Rundi("rn"),
  Romanian("ro"),
  Moldavian("ro-MD"),
  Rombo("rof"),
  Romany("rom"),
  Rotuman("rtm"),
  Russian("ru"),
  Rusyn("rue"),
  Roviana("rug"),
  Aromanian("rup"),
  Kinyarwanda("rw"),
  Rwa("rwk"),
  Sanskrit("sa"),
  Sandawe("sad"),
  Yakut("sah"),
  SamaritanAramaic("sam"),
  Samburu("saq"),
  Sasak("sas"),
  Santali("sat"),
  Saurashtra("saz"),
  Ngambay("sba"),
  Sangu("sbp"),
  Sardinian("sc"),
  Sicilian("scn"),
  Scots("sco"),
  Sindhi("sd"),
  SassareseSardinian("sdc"),
  SouthernKurdish("sdh"),
  NorthernSami("se"),
  SamiNorthern("se-alt-menu"),
  Seneca("see"),
  Sena("seh"),
  Seri("sei"),
  Selkup("sel"),
  KoyraboroSenni("ses"),
  Sango("sg"),
  OldIrish("sga"),
  Samogitian("sgs"),
  SerboCroatian("sh"),
  Tachelhit("shi"),
  Shan("shn"),
  ChadianArabic("shu"),
  Sinhala("si"),
  Sidamo("sid"),
  Slovak("sk"),
  Saraiki("skr"),
  Slovenian("sl"),
  SouthernLushootseed("slh"),
  LowerSilesian("sli"),
  Selayar("sly"),
  Samoan("sm"),
  SouthernSami("sma"),
  SamiSouthern("sma-alt-menu"),
  LuleSami("smj"),
  SamiLule("smj-alt-menu"),
  InariSami("smn"),
  SamiInari("smn-alt-menu"),
  SkoltSami("sms"),
  SamiSkolt("sms-alt-menu"),
  Shona("sn"),
  Soninke("snk"),
  Somali("so"),
  Sogdien("sog"),
  Albanian("sq"),
  Serbian("sr"),
  Montenegrin("sr-ME"),
  SrananTongo("srn"),
  Serer("srr"),
  Swati("ss"),
  Saho("ssy"),
  SouthernSotho("st"),
  SaterlandFrisian("stq"),
  StraitsSalish("str"),
  Sundanese("su"),
  Sukuma("suk"),
  Susu("sus"),
  Sumerian("sux"),
  Swedish("sv"),
  Swahili("sw"),
  CongoSwahili("sw-CD"),
  Comorian("swb"),
  ClassicalSyriac("syc"),
  Syriac("syr"),
  Silesian("szl"),
  Tamil("ta"),
  SouthernTutchone("tce"),
  Tulu("tcy"),
  Telugu("te"),
  Timne("tem"),
  Teso("teo"),
  Tereno("ter"),
  Tetum("tet"),
  Tajik("tg"),
  Tagish("tgx"),
  Thai("th"),
  Tahltan("tht"),
  Tigrinya("ti"),
  Tigre("tig"),
  Tiv("tiv"),
  Turkmen("tk"),
  Tokelau("tkl"),
  Tsakhur("tkr"),
  Tagalog("tl"),
  Klingon("tlh"),
  Tlingit("tli"),
  Talysh("tly"),
  Tamashek("tmh"),
  Tswana("tn"),
  Tongan("to"),
  NyasaTonga("tog"),
  TokiPona("tok"),
  TokPisin("tpi"),
  Turkish("tr"),
  Turoyo("tru"),
  Taroko("trv"),
  Torwali("trw"),
  Tsonga("ts"),
  Tsakonian("tsd"),
  Tsimshian("tsi"),
  Tatar("tt"),
  NorthernTutchone("ttm"),
  MuslimTat("ttt"),
  Tumbuka("tum"),
  Tuvalu("tvl"),
  Twi("tw"),
  Tasawaq("twq"),
  Tahitian("ty"),
  Tuvinian("tyv"),
  CentralAtlasTamazight("tzm"),
  Udmurt("udm"),
  Uyghur("ug"),
  Uighur("ug-alt-variant"),
  Ugaritic("uga"),
  Ukrainian("uk"),
  Umbundu("umb"),
  UnknownLanguage("und"),
  Urdu("ur"),
  Uzbek("uz"),
  Vai("vai"),
  Venda("ve"),
  Venetian("vec"),
  Veps("vep"),
  Vietnamese("vi"),
  WestFlemish("vls"),
  MainFranconian("vmf"),
  Makhuwa("vmw"),
  Volapuk("vo"),
  Votic("vot"),
  Voro("vro"),
  Vunjo("vun"),
  Walloon("wa"),
  Walser("wae"),
  Wolaytta("wal"),
  Waray("war"),
  Washo("was"),
  Warlpiri("wbp"),
  Wolof("wo"),
  WuChinese("wuu"),
  Kalmyk("xal"),
  Xhosa("xh"),
  Mingrelian("xmf"),
  Kangri("xnr"),
  Soga("xog"),
  Yao("yao"),
  Yapese("yap"),
  Yangben("yav"),
  Yemba("ybb"),
  Yiddish("yi"),
  Yoruba("yo"),
  Nheengatu("yrl"),
  Cantonese("yue"),
  ChineseCantonese("yue-alt-menu"),
  Zhuang("za"),
  Zapotec("zap"),
  Blissymbols("zbl"),
  Zeelandic("zea"),
  Zenaga("zen"),
  StandardMoroccanTamazight("zgh"),
  Chinese("zh"),
  SimplifiedChinese("zh-Hans"),
  SimplifiedMandarinChinese("zh-Hans-alt-long"),
  TraditionalChinese("zh-Hant"),
  TraditionalMandarinChinese("zh-Hant-alt-long"),
  MandarinChinese("zh-alt-long"),
  ChineseMandarin("zh-alt-menu"),
  Zulu("zu"),
  Zuni("zun"),
  NoLinguisticContent("zxx"),
  Zaza("zza"),
}
