package net.codinux.i18n

import kotlin.String
import net.codinux.collections.ImmutableMap
import net.codinux.collections.immutableMapOf

object CurrencyDisplayNames {
  val aa: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val aa_DJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val aa_ER: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ab: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val af: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Verenigde Arabiese Emirate-dirham",
    "AFN" to "Afgaanse afgani",
    "ALL" to "Albanese lek",
    "AMD" to "Armeense dram",
    "ANG" to "Nederlands-Antilliaanse gulde",
    "AOA" to "Angolese kwanza",
    "ARS" to "Argentynse peso",
    "AUD" to "Australiese dollar",
    "AWG" to "Arubaanse floryn",
    "AZN" to "Azerbeidjaanse manat",
    "BAM" to "Bosnies-Herzegowiniese omskakelbare marka",
    "BBD" to "Barbados-dollar",
    "BDT" to "Bangladesjiese taka",
    "BGN" to "Bulgaarse lev",
    "BHD" to "Bahreinse dinar",
    "BIF" to "Burundiese frank",
    "BMD" to "Bermuda-dollar",
    "BND" to "Broeneise dollar",
    "BOB" to "Boliviaanse boliviano",
    "BRL" to "Brasilliaanse reaal",
    "BSD" to "Bahamiaanse dollar",
    "BTN" to "Bhoetanese ngoeltroem",
    "BWP" to "Botswana-pula",
    "BYN" to "Belarusiese roebel",
    "BYR" to "Belo-Russiese roebel (2000–2016)",
    "BZD" to "Beliziese dollar",
    "CAD" to "Kanadese dollar",
    "CDF" to "Kongolese frank",
    "CHF" to "Switserse frank",
    "CLP" to "Chileense peso",
    "CNH" to "Chinese joean (buiteland)",
    "CNY" to "Chinese joean",
    "COP" to "Colombiaanse peso",
    "CRC" to "Costa Ricaanse colón",
    "CUC" to "Kubaanse omskakelbare peso",
    "CUP" to "Kubaanse peso",
    "CVE" to "Kaap Verdiese escudo",
    "CZK" to "Tsjeggiese kroon",
    "DJF" to "Djiboeti-frank",
    "DKK" to "Deense kroon",
    "DOP" to "Dominikaanse peso",
    "DZD" to "Algeriese dinar",
    "EGP" to "Egiptiese pond",
    "ERN" to "Eritrese nakfa",
    "ETB" to "Etiopiese birr",
    "EUR" to "Euro",
    "FJD" to "Fidjiaanse dollar",
    "FKP" to "Falkland-eilandse pond",
    "GBP" to "Britse pond",
    "GEL" to "Georgiese lari",
    "GHC" to "Ghanese cedi (1979–2007)",
    "GHS" to "Ghanese cedi",
    "GIP" to "Gibraltarese pond",
    "GMD" to "Gambiese dalasi",
    "GNF" to "Guinese frank",
    "GNS" to "Guinese syli",
    "GTQ" to "Guatemalaanse kwetsal",
    "GYD" to "Guyanese dollar",
    "HKD" to "Hongkongse dollar",
    "HNL" to "Hondurese lempira",
    "HRK" to "Kroatiese kuna",
    "HTG" to "Haïtiaanse gourde",
    "HUF" to "Hongaarse florint",
    "IDR" to "Indonesiese roepia",
    "ILS" to "Israeliese nuwe sikkel",
    "INR" to "Indiese roepee",
    "IQD" to "Irakse dinar",
    "IRR" to "Iranse rial",
    "ISK" to "Yslandse kroon",
    "ITL" to "Italiaanse lier",
    "JMD" to "Jamaikaanse dollar",
    "JOD" to "Jordaniese dinar",
    "JPY" to "Japannese jen",
    "KES" to "Keniaanse sjieling",
    "KGS" to "Kirgisiese som",
    "KHR" to "Kambodjaanse riel",
    "KMF" to "Comoraanse frank",
    "KPW" to "Noord-Koreaanse won",
    "KRW" to "Suid-Koreaanse won",
    "KWD" to "Koeweitse dinar",
    "KYD" to "Cayman-eilandse dollar",
    "KZT" to "Kazakse tenge",
    "LAK" to "Laosiaanse kip",
    "LBP" to "Libanese pond",
    "LKR" to "Sri Lankaanse roepee",
    "LRD" to "Liberiese dollar",
    "LSL" to "Lesotho loti",
    "LTL" to "Litause litas",
    "LVL" to "Lettiese lats",
    "LYD" to "Libiese dinar",
    "MAD" to "Marokkaanse dirham",
    "MDL" to "Moldowiese leu",
    "MGA" to "Malgassiese ariary",
    "MKD" to "Macedoniese denar",
    "MMK" to "Mianmese kyat",
    "MNT" to "Mongoolse toegrik",
    "MOP" to "Macaose pataca",
    "MRO" to "Mauritaniese ouguiya (1973–2017)",
    "MRU" to "Mauritaniese ouguiya",
    "MUR" to "Mauritiaanse roepee",
    "MVR" to "Malediviese rufia",
    "MWK" to "Malawiese kwacha",
    "MXN" to "Meksikaanse peso",
    "MYR" to "Maleisiese ringgit",
    "MZM" to "Mosambiekse metical (1980–2006)",
    "MZN" to "Mosambiekse metical",
    "NAD" to "Namibiese dollar",
    "NGN" to "Nigeriese naira",
    "NIO" to "Nicaraguaanse córdoba",
    "NOK" to "Noorse kroon",
    "NPR" to "Nepalese roepee",
    "NZD" to "Nieu-Seelandse dollar",
    "OMR" to "Omaanse rial",
    "PAB" to "Panamese balboa",
    "PEN" to "Peruaanse sol",
    "PGK" to "Papoea-Nieu-Guinese kina",
    "PHP" to "Filippynse peso",
    "PKR" to "Pakistanse roepee",
    "PLN" to "Poolse zloty",
    "PYG" to "Paraguaanse guarani",
    "QAR" to "Katarrese rial",
    "RON" to "Roemeense leu",
    "RSD" to "Serwiese dinar",
    "RUB" to "Russiese roebel",
    "RWF" to "Rwandese frank",
    "SAR" to "Saoedi-Arabiese riyal",
    "SBD" to "Salomonseilandse dollar",
    "SCR" to "Seychellese roepee",
    "SDG" to "Soedannese pond",
    "SDP" to "Soedannese pond (1957–1998)",
    "SEK" to "Sweedse kroon",
    "SGD" to "Singapoer-dollar",
    "SHP" to "Sint Helena-pond",
    "SLE" to "Sierra Leoniese leone",
    "SLL" to "Sierra Leoniese leone (1964—2022)",
    "SOS" to "Somaliese sjieling",
    "SRD" to "Surinaamse dollar",
    "SSP" to "Suid-Soedanese pond",
    "STD" to "São Tomé en Príncipe dobra (1977–2017)",
    "STN" to "São Tomé en Príncipe-dobra",
    "SYP" to "Siriese pond",
    "SZL" to "Swazilandse lilangeni",
    "THB" to "Thaise baht",
    "TJS" to "Tadjikse somoni",
    "TMT" to "Turkmeense manat",
    "TND" to "Tunisiese dinar",
    "TOP" to "Tongaanse pa’anga",
    "TRL" to "Turkse lier (1922–2005)",
    "TRY" to "Turkse lira",
    "TTD" to "Trinidad en Tobago-dollar",
    "TWD" to "Nuwe Taiwanese dollar",
    "TZS" to "Tanzaniese sjieling",
    "UAH" to "Oekraïnse hriwna",
    "UGX" to "Ugandese sjieling",
    "USD" to "VSA-dollar",
    "UYU" to "Uruguaanse peso",
    "UZS" to "Oezbekiese som",
    "VEF" to "Venezolaanse bolivar",
    "VES" to "Venezolaanse bolívar",
    "VND" to "Viëtnamese dong",
    "VUV" to "Vanuatuse vatu",
    "WST" to "Samoaanse tala",
    "XAF" to "Sentraal Afrikaanse CFA-frank",
    "XCD" to "Oos-Karibiese dollar",
    "XOF" to "Wes-Afrikaanse CFA-frank",
    "XPF" to "CFP-frank",
    "XXX" to "Onbekende geldeenheid",
    "YER" to "Jemenitiese rial",
    "ZAR" to "Suid-Afrikaanse rand",
    "ZMK" to "Zambiese kwacha (1968–2012)",
    "ZMW" to "Zambiese kwacha",
    "ZWD" to "Zimbabwiese dollar",
  ) }

  val af_NA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val agq: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dilàm è Yùnaetɛ Alab Emelɛ̀",
    "AOA" to "Kwanzà è Àŋgolà",
    "AUD" to "Dɔlà e Ùsɨ̀tɛ̀lɛlìa",
    "BHD" to "Dinà è Balae",
    "BIF" to "Fàlâŋ è Bùlundì",
    "BWP" to "Kpuwlà è Botɨshǔanà",
    "CAD" to "Dɔlà è Kanadà",
    "CDF" to "Fàlâŋ è Kuŋgùlê",
    "CHF" to "Fàlâŋ è Sues",
    "CNY" to "Yùwân Lèmembi è Chaenî",
    "CVE" to "Kàbòvàdianù è Èsùkudò",
    "DJF" to "Fàlâŋ è Dzìbutì",
    "DZD" to "Dinà è Àdzɛlìa",
    "EGP" to "Bɔ̀ŋ è Edzì",
    "ERN" to "Nakafa è Èletɨ̀làe",
    "ETB" to "Bîi è Etyǒkpìa",
    "EUR" to "Yulù",
    "GBP" to "Bɔ̀ŋ è Bèletì",
    "GHC" to "Sɛ̀di è Gaanà",
    "GMD" to "Dàlasì è Gambìa",
    "GNS" to "Fàlâŋ è Ginè",
    "INR" to "Lukpì è Endìa",
    "JPY" to "Ghɨ̂n Dzàkpànê",
    "KES" to "Shwɨlà tɨ Kenyà",
    "KMF" to "Fàlâŋ è Komolìa",
    "LRD" to "Dɔlà Làebɛlìa",
    "LSL" to "Lɔtì Lèsutù",
    "LYD" to "Dinà è Lebìa",
    "MAD" to "Dilàm è Mòlokò",
    "MGA" to "Àlǐalè è Màlàgasì",
    "MRO" to "Ùgueya è Mùlètenyìa (1973–2017)",
    "MRU" to "Ùgueya è Mùlètenyìa",
    "MUR" to "Lukpìi è Mùleshòs",
    "MWK" to "Kwachà è Màlawè",
    "MZM" to "Mètikà è Mùzàmbî",
    "NAD" to "Dɔlà è Nàmibìa",
    "NGN" to "Naelà è Gɨ̀anyɨ",
    "RWF" to "Fàlâŋ è Lùwandà",
    "SAR" to "Leyà è Sàwudì",
    "SCR" to "Lukpìi è Sɛchɛ̀lɛ̀",
    "SDG" to "Bɔ̀ŋ è Sùdànê",
    "SHP" to "Bɔ̀ŋ è Sɛ̀n Èlenà",
    "SLE" to "Lyɔ̂ŋ",
    "SLL" to "Lyɔ̂ŋ (1964—2022)",
    "SOS" to "Shwɨlà è Sùmalìa",
    "STD" to "Dɔbàlà è Sàwu Tɔ̀me à Pèlènsipè (1977–2017)",
    "STN" to "Dɔbàlà è Sàwu Tɔ̀me à Pèlènsipè",
    "SZL" to "Lèlàŋgenè",
    "TND" to "Dinà è Tùwneshìa",
    "TZS" to "Shwɨlà è Tàanzanyìa",
    "UGX" to "Shwɨlà è Yùgandà",
    "USD" to "Dɔlà è US",
    "XAF" to "CFA Fàlâŋ BEAC",
    "XOF" to "CFA Fàlâŋ BCEAO",
    "ZAR" to "Lân è Afɨlekà ghɨ Emàm ghò",
    "ZMK" to "Kwachà è Zambìa (1968–2012)",
    "ZMW" to "Kwachà è Zambìa",
    "ZWD" to "Dɔlà è Zìmbagbɛ̀",
  ) }

  val ak: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Ɛmirete Arab Nkabɔmu Deram",
    "AFN" to "Afghanfoɔ Afghani",
    "ALL" to "Albania Lek",
    "AMD" to "Amɛnia dram",
    "ANG" to "Nɛdɛlande Antɛlia guuda",
    "AOA" to "Angola Kwanza",
    "ARS" to "Agɛntina peso",
    "AUD" to "Ɔstrelia Dɔla",
    "AWG" to "Aruba flɔrin",
    "AZN" to "Azɛbagyan manat",
    "BAM" to "Bɔsnia-Hɛzegɔvina nsesa maake",
    "BBD" to "Babadɔso dɔla",
    "BDT" to "Bangladehye taka",
    "BGN" to "Bɔɔgaria lɛv",
    "BHD" to "Baren Dina",
    "BIF" to "Burundi Frank",
    "BMD" to "Bɛɛmuda dɔla",
    "BND" to "Brunei dɔla",
    "BOB" to "Bolivia boliviano",
    "BRL" to "Brazil reale",
    "BSD" to "Bahama dɔla",
    "BTN" to "Butanfoɔ ngutrum",
    "BWP" to "Botswana Pula",
    "BYN" to "Bɛlaruhyia ruble",
    "BZD" to "Belize Dɔla",
    "CAD" to "Kanada Dɔla",
    "CDF" to "Kongo Frank",
    "CHF" to "Swiss Franc",
    "CLP" to "Kyili Peso",
    "CNH" to "kyaena yuan (offshore)",
    "CNY" to "kyaena yuan",
    "COP" to "Kolombia peso",
    "CRC" to "Kɔsta Rika kɔlɔn",
    "CUC" to "Kuba nsesa peso",
    "CUP" to "Kuba peso",
    "CVE" to "Ɛskudo",
    "CZK" to "Kyɛk koruna",
    "DJF" to "Gyebuti Frank",
    "DKK" to "Danefoɔ krone",
    "DOP" to "Dɔmenika peso",
    "DZD" to "Ɔlgyeria Dina",
    "EGP" to "Egypt Pɔn",
    "ERN" to "Ɛretereya Nakfa",
    "ETB" to "Itiopia Bir",
    "EUR" to "Iro",
    "FJD" to "Figyi Dɔla",
    "FKP" to "Fɔkland Aelande Pɔn",
    "GBP" to "Breten Pɔn",
    "GEL" to "Gyɔɔgyia lari",
    "GHC" to "Ghana Sidi (1979–2007)",
    "GHS" to "Ghana Sidi",
    "GIP" to "Gyebrotaa pɔn",
    "GMD" to "Gambia Dalasi",
    "GNF" to "Gini franke",
    "GNS" to "Gini Frank",
    "GTQ" to "Guatemala kwɛtsaa",
    "GYD" to "Gayana dɔla",
    "HKD" to "Hɔnkɔn Dɔla",
    "HNL" to "Hɔndura lɛmpira",
    "HRK" to "Krohyia kuna",
    "HTG" to "Haiti gɔɔde",
    "HUF" to "Hangari fɔrint",
    "IDR" to "Indɔnihyia rupia",
    "ILS" to "Israel hyekel foforɔ",
    "INR" to "India Rupi",
    "IQD" to "Irak dinaa",
    "IRR" to "Yiranfoɔ rial",
    "ISK" to "Icelandfoɔ Króna",
    "JMD" to "Gyameka dɔla",
    "JOD" to "Gyɔɔdan dinaa",
    "JPY" to "Gyapan Yɛn",
    "KES" to "Kenya Hyelen",
    "KGS" to "Kagyɛstan som",
    "KHR" to "Kambodia riel",
    "KMF" to "Komoro Frank",
    "KPW" to "Korea Atifi won",
    "KRW" to "Korea Anaafoɔ won",
    "KWD" to "Kuwait dinaa",
    "KYD" to "Kayemanfo Aelande dɔla",
    "KZT" to "Kagyastan tenge",
    "LAK" to "Laohyia kip",
    "LBP" to "Lɛbanon pɔn",
    "LKR" to "Sri Lankafoɔ rupee",
    "LRD" to "Laeberia Dɔla",
    "LSL" to "Lesoto Loti",
    "LYD" to "Libya Dina",
    "MAD" to "Moroko Diram",
    "MDL" to "Moldova Leu",
    "MGA" to "Madagasi Frank",
    "MKD" to "Masidonia denaa",
    "MMK" to "Mayamaa kyat",
    "MNT" to "Mongoliafoɔ tugrike",
    "MOP" to "Makaw pataka",
    "MRO" to "Mɔretenia Ouguiya (1973–2017)",
    "MRU" to "Mɔretenia Ouguiya",
    "MUR" to "Mɔrehyeɔs Rupi",
    "MVR" to "Maldivefoɔ rufiyaa",
    "MWK" to "Malawi Kwakya",
    "MXN" to "Mɛksiko pɛso",
    "MYR" to "Malaahyia ringgit",
    "MZM" to "Mozambik Metical",
    "MZN" to "Mozambik mɛtikaa",
    "NAD" to "Namibia Dɔla",
    "NGN" to "Naegyeria Naira",
    "NIO" to "Nikaragua kɔɔdɔba",
    "NOK" to "Nɔɔwee Krone",
    "NPR" to "Nepalfoɔ rupee",
    "NZD" to "New Zealand Dɔla",
    "OMR" to "Oman rial",
    "PAB" to "Panama baaboa",
    "PEN" to "Pɛruvia sol",
    "PGK" to "Papua New Gini kina",
    "PHP" to "Filipine peso",
    "PKR" to "Pakistanfoɔ rupee",
    "PLN" to "Pɔlihye zloty",
    "PYG" to "Paragayana guarani",
    "QAR" to "Kata riyaa",
    "RON" to "Romania Leu",
    "RSD" to "Sɛɛbia dinaa",
    "RUB" to "Rɔhyia rubuu",
    "RWF" to "Rewanda Frank",
    "SAR" to "Saudi Riyal",
    "SBD" to "Solomon Aeland Dɔla",
    "SCR" to "Seyhyɛls Rupi",
    "SDG" to "Sudan Dina",
    "SDP" to "Sudan Pɔn",
    "SEK" to "Sweden Krona",
    "SGD" to "Singapɔɔ dɔla",
    "SHP" to "St Helena Pɔn",
    "SLE" to "Leone",
    "SLL" to "Leone (1964—2022)",
    "SOS" to "Somailia Hyelen",
    "SRD" to "Suriname dɔla",
    "SSP" to "Sudan Anaafoɔ Pɔn",
    "STD" to "Sao Tome ne Principe Dobra (1977–2017)",
    "STN" to "Sao Tome ne Principe Dobra",
    "SYP" to "Siria pɔn",
    "SZL" to "Lilangeni",
    "THB" to "Tai bat",
    "TJS" to "Tagyikistan somoni",
    "TMT" to "Tɛkmɛstan manat",
    "TND" to "Tunisia Dina",
    "TOP" to "Tonga Paʻanga",
    "TRY" to "Tɛki lira",
    "TTD" to "Trinidad ne Tobago dɔla",
    "TWD" to "Taewanfoɔ dɔla foforɔ",
    "TZS" to "Tanzania Hyelen",
    "UAH" to "Yukren hryvnia",
    "UGX" to "Uganda Hyelen",
    "USD" to "Amɛrika Dɔla",
    "UYU" to "Yurugueɛ peso",
    "UZS" to "Yusbɛkistan som",
    "VES" to "Venezuelan bolívar",
    "VND" to "Viɛtnamfoɔ dɔn",
    "VUV" to "Vanuatu vatu",
    "WST" to "Samoa Tala",
    "XAF" to "Afrika Mfinimfini Sefa",
    "XCD" to "Karibine Apueeɛ dɔla",
    "XOF" to "Afrika Atɔeɛ Sefa",
    "XPF" to "CFP Franc",
    "XXX" to "sika a yɛnnim",
    "YER" to "Yɛmɛn rial",
    "ZAR" to "Afrika Anaafo Rand",
    "ZMK" to "Zambia Kwacha (1968–2012)",
    "ZMW" to "Zambia Kwakya",
    "ZWD" to "Zimbabwe Dɔla",
  ) }

  val am: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "የተባበሩት የአረብ ኤምሬትስ ድርሀም",
    "AFN" to "የአፍጋን አፍጋኒ",
    "ALL" to "የአልባንያ ሌክ",
    "AMD" to "የአርመን ድራም",
    "ANG" to "ኔዘርላንድስ አንቲሊአን ጊልደር",
    "AOA" to "የአንጎላ ኩዋንዛ",
    "ARS" to "የአርጀንቲና ፔሶ",
    "AUD" to "የአውስትራሊያ ዶላር",
    "AWG" to "አሩባን ፍሎሪን",
    "AZN" to "የአዛርባጃን ማናት",
    "BAM" to "የቦስኒያ ሄርዞጎቪና የሚመነዘር ማርክ",
    "BBD" to "የባርቤዶስ ዶላር",
    "BDT" to "የባንግላዲሽ ታካ",
    "BGN" to "የቡልጋሪያ ሌቭ",
    "BHD" to "የባኽሬን ዲናር",
    "BIF" to "የብሩንዲ ፍራንክ",
    "BMD" to "የቤርሙዳ ዶላር",
    "BND" to "የብሩኔ ዶላር",
    "BOB" to "የቦሊቪያ ቦሊቪያኖ",
    "BRL" to "የብራዚል ሪል",
    "BSD" to "የባሃማስ ዶላር",
    "BTN" to "ብሁታኒዝ ንጉልትረም",
    "BWP" to "የቦትስዋና ፑላ",
    "BYN" to "የቤላሩስያ ሩብል",
    "BYR" to "የቤላሩስያ ሩብል (2000–2016)",
    "BZD" to "የቤሊዝ ዶላር",
    "CAD" to "የካናዳ ዶላር",
    "CDF" to "የኮንጐ ፍራንክ ኮንጐሌዝ",
    "CHF" to "የስዊስ ፍራንክ",
    "CLP" to "የቺሊ ፔሶ",
    "CNH" to "የቻይና ዩዋን (የውጭ ምንዛሪ)",
    "CNY" to "የቻይና የን",
    "COP" to "የኮሎምቢያ ፔሶ",
    "CRC" to "የኮስታሪካ ኮሎን",
    "CUC" to "የኩባ የሚመነዘር ፔሶ",
    "CUP" to "የኩባ ፔሶ",
    "CVE" to "የኬፕ ቫርዲ ኤስኩዶ",
    "CZK" to "ቼክ ሪፐብሊክ ኮሩና",
    "DJF" to "የጅቡቲ ፍራንክ",
    "DKK" to "የዴንማርክ ክሮን",
    "DOP" to "የዶሚኒክ ፔሶ",
    "DZD" to "የአልጄሪያ ዲናር",
    "EGP" to "የግብጽ ፓውንድ",
    "ERN" to "የኤርትራ ናቅፋ",
    "ETB" to "የኢትዮጵያ ብር",
    "EUR" to "ዩሮ",
    "FJD" to "የፊጂ ዶላር",
    "FKP" to "የፎክላንድ ደሴቶች ፓውንድ",
    "GBP" to "የእንግሊዝ ፓውንድ ስተርሊንግ",
    "GEL" to "የጆርጅያ ላሪ",
    "GHC" to "የጋና ሴዲ",
    "GHS" to "የጋና ሲዲ",
    "GIP" to "ጂብራልተር ፓውንድ",
    "GMD" to "የጋምቢያ ዳላሲ",
    "GNF" to "የጊኒ ፍራንክ",
    "GTQ" to "ጓቲማላን ኩቲዛል",
    "GYD" to "የጉየና ዶላር",
    "HKD" to "የሆንግኮንግ ዶላር",
    "HNL" to "የሃንዱራ ሌምፓአይራ",
    "HRK" to "የክሮሽያ ኩና",
    "HTG" to "የሃያቲ ጓርዴ",
    "HUF" to "የሃንጋሪያን ፎሪንት",
    "IDR" to "የኢንዶኔዥያ ሩፒሃ",
    "ILS" to "የእስራኤል አዲስ ሽቅል",
    "INR" to "የሕንድ ሩፒ",
    "IQD" to "የኢራቅ ዲናር",
    "IRR" to "የኢራን ሪአል",
    "ISK" to "የአይስላንድ ክሮና",
    "JMD" to "የጃማይካ ዶላር",
    "JOD" to "የጆርዳን ዲናር",
    "JPY" to "የጃፓን የን",
    "KES" to "የኬኒያ ሺሊንግ",
    "KGS" to "የኪርጊስታን ሶም",
    "KHR" to "የካምቦዲያ ሬል",
    "KMF" to "የኮሞሮ ፍራንክ",
    "KPW" to "የሰሜን ኮሪያ ዎን",
    "KRW" to "የደቡብ ኮሪያ ዎን",
    "KWD" to "የኩዌት ዲናር",
    "KYD" to "የካይማን ደሴቶች ዶላር",
    "KZT" to "የካዛኪስታን ተንጌ",
    "LAK" to "የላኦቲ ኪፕ",
    "LBP" to "የሊባኖስ ፓውንድ",
    "LKR" to "የሲሪላንካ ሩፒ",
    "LRD" to "የላይቤሪያ ዶላር",
    "LSL" to "የሌሶቶ ሎቲ",
    "LTL" to "ሊቱዌንያን ሊታስ",
    "LVL" to "የላቲቫ ላትስ",
    "LYD" to "የሊቢያ ዲናር",
    "MAD" to "የሞሮኮ ዲርሀም",
    "MDL" to "ሞልዶቫን ሊኡ",
    "MGA" to "የማደጋስካር ማላጋስይ አሪያርይ",
    "MKD" to "የሜቆድንያ ዲናር",
    "MMK" to "የማያናማር ክያት",
    "MNT" to "የሞንጎሊያን ቱግሪክ",
    "MOP" to "የማካኔዝ ፓታካ",
    "MRO" to "የሞሪቴኒያ ኦውጉያ (1973–2017)",
    "MRU" to "የሞሪቴኒያ ኦውጉያ",
    "MUR" to "የሞሪሸስ ሩፒ",
    "MVR" to "የማልዲቫ ሩፊያ",
    "MWK" to "የማላዊ ኩዋቻ",
    "MXN" to "የሜክሲኮ ፔሶ",
    "MYR" to "የማሌዥያ ሪንጊት",
    "MZN" to "የሞዛምቢክ ሜቲካል",
    "NAD" to "የናሚቢያ ዶላር",
    "NGN" to "የናይጄሪያ ናይራ",
    "NIO" to "የኒካራጓ ኮርዶባ",
    "NOK" to "የኖርዌይ ክሮን",
    "NPR" to "የኔፓል ሩፒ",
    "NZD" to "የኒውዚላንድ ዶላር",
    "OMR" to "የኦማን ሪአል",
    "PAB" to "ፓናማኒአን ባልቦአ",
    "PEN" to "የፔሩቪያ ሶል",
    "PGK" to "የፓፕዋ ኒው ጊኒ ኪና",
    "PHP" to "የፊሊፒንስ ፔሶ",
    "PKR" to "የፓኪስታን ሩፒ",
    "PLN" to "የፖላንድ ዝሎቲ",
    "PYG" to "የፓራጓይ ጉአራኒ",
    "QAR" to "የኳታር ሪአል",
    "RON" to "የሮማኒያ ለው",
    "RSD" to "የሰርቢያ ዲናር",
    "RUB" to "የሩስያ ሩብል",
    "RWF" to "የሩዋንዳ ፍራንክ",
    "SAR" to "የሳውዲ ሪያል",
    "SBD" to "የሰለሞን ደሴቶች ዶላር",
    "SCR" to "የሲሼል ሩፒ",
    "SDG" to "የሱዳን ፓውንድ",
    "SDP" to "የሱዳን ፓውንድ (1957–1998)",
    "SEK" to "የስዊድን ክሮና",
    "SGD" to "የሲንጋፖር ዶላር",
    "SHP" to "የሴይንት ሔሌና ፓውንድ",
    "SLE" to "የሴራሊዎን ሊዎን",
    "SLL" to "የሴራሊዎን ሊዎን (1964—2022)",
    "SOS" to "የሶማሌ ሺሊንግ",
    "SRD" to "የሰርናሜዝ ዶላር",
    "SSP" to "የደቡብ ሱዳን ፓውንድ",
    "STD" to "የሳኦ ቶሜ እና ፕሪንሲፔ ዶብራ (1977–2017)",
    "STN" to "የሳኦ ቶሜ እና ፕሪንሲፔ ዶብራ",
    "SYP" to "የሲሪያ ፓውንድ",
    "SZL" to "የስዋዚላንድ ሊላንገኒ",
    "THB" to "የታይላንድ ባህት",
    "TJS" to "የታጂክስታን ሶሞኒ",
    "TMT" to "ቱርክሜኒስታኒ ማናት",
    "TND" to "የቱኒዚያ ዲናር",
    "TOP" to "ቶንጋን ፓ’አንጋ",
    "TRY" to "የቱርክ ሊራ",
    "TTD" to "የትሪንዳድ እና ቶቤጎዶላር",
    "TWD" to "የአዲሷ ታይዋን ዶላር",
    "TZS" to "የታንዛኒያ ሺሊንግ",
    "UAH" to "የዩክሬን ሀሪይቭኒአ",
    "UGX" to "የዩጋንዳ ሺሊንግ",
    "USD" to "የአሜሪካን ዶላር",
    "UYU" to "የኡራጓይ ፔሶ",
    "UZS" to "የኡዝፔኪስታን ሶም",
    "VEF" to "የቬንዝዌላ ቦሊቫር (2008–2018)",
    "VES" to "የቬንዝዌላ-ቦሊቫር",
    "VND" to "የቭየትናም ዶንግ",
    "VUV" to "የቫንዋንቱ ቫቱ",
    "WST" to "ሳሞአን ታላ",
    "XAF" to "የመካከለኛው አፍሪካ ሴፋ ፍራንክ",
    "XCD" to "የምዕራብ ካሪብያን ዶላር",
    "XOF" to "የምዕራብ አፍሪካ ሴፋ ፍራንክ",
    "XPF" to "ሲ ኤፍ ፒ ፍራንክ",
    "XXX" to "ያልታወቀ ገንዘብ",
    "YER" to "የየመን ሪአል",
    "ZAR" to "የደቡብ አፍሪካ ራንድ",
    "ZMK" to "የዛምቢያ ክዋቻ (1968–2012)",
    "ZMW" to "የዛምቢያ ክዋቻ",
    "ZWD" to "የዚምቧቡዌ ዶላር",
  ) }

  val an: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ann: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val apc: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "بيستا أندوري",
    "AED" to "درهم إماراتي",
    "AFA" to "أفغاني - 1927-2002",
    "AFN" to "أفغاني",
    "ALL" to "ليك ألباني",
    "AMD" to "درام أرميني",
    "ANG" to "غيلدر أنتيلي هولندي",
    "AOA" to "كوانزا أنغولي",
    "AOK" to "كوانزا أنجولي - 1977-1990",
    "AON" to "كوانزا أنجولي جديدة - 1990-2000",
    "AOR" to "كوانزا أنجولي معدلة - 1995 - 1999",
    "ARA" to "استرال أرجنتيني",
    "ARP" to "بيزو أرجنتيني - 1983-1985",
    "ARS" to "بيزو أرجنتيني",
    "ATS" to "شلن نمساوي",
    "AUD" to "دولار أسترالي",
    "AWG" to "فلورن أروبي",
    "AZM" to "مانات أذريبجاني",
    "AZN" to "مانات أذربيجان",
    "BAD" to "دينار البوسنة والهرسك",
    "BAM" to "مارك البوسنة والهرسك قابل للتحويل",
    "BBD" to "دولار بربادوسي",
    "BDT" to "تاكا بنغلاديشي",
    "BEC" to "فرنك بلجيكي قابل للتحويل",
    "BEF" to "فرنك بلجيكي",
    "BEL" to "فرنك بلجيكي مالي",
    "BGN" to "ليف بلغاري",
    "BHD" to "دينار بحريني",
    "BIF" to "فرنك بروندي",
    "BMD" to "دولار برمودي",
    "BND" to "دولار بروناي",
    "BOB" to "بوليفيانو بوليفي",
    "BOP" to "بيزو بوليفي",
    "BOV" to "مفدول بوليفي",
    "BRB" to "نوفو كروزايرو برازيلي - 1967-1986",
    "BRC" to "كروزادو برازيلي",
    "BRE" to "كروزايرو برازيلي - 1990-1993",
    "BRL" to "ريال برازيلي",
    "BSD" to "دولار باهامي",
    "BTN" to "نولتوم بوتاني",
    "BUK" to "كيات بورمي",
    "BWP" to "بولا بتسواني",
    "BYB" to "روبل بيلاروسي جديد - 1994-1999",
    "BYN" to "روبل بيلاروسي",
    "BYR" to "روبل بيلاروسي (٢٠٠٠–٢٠١٦)",
    "BZD" to "دولار بليزي",
    "CAD" to "دولار كندي",
    "CDF" to "فرنك كونغولي",
    "CHF" to "فرنك سويسري",
    "CLP" to "بيزو تشيلي",
    "CNH" to "يوان صيني (في الخارج)",
    "CNY" to "يوان صيني",
    "COP" to "بيزو كولومبي",
    "CRC" to "كولن كوستاريكي",
    "CSD" to "دينار صربي قديم",
    "CSK" to "كرونة تشيكوسلوفاكيا",
    "CUC" to "بيزو كوبي قابل للتحويل",
    "CUP" to "بيزو كوبي",
    "CVE" to "اسكودو الرأس الأخضر",
    "CYP" to "جنيه قبرصي",
    "CZK" to "كرونة تشيكية",
    "DDM" to "أوستمارك ألماني شرقي",
    "DEM" to "مارك ألماني",
    "DJF" to "فرنك جيبوتي",
    "DKK" to "كرونة دنماركية",
    "DOP" to "بيزو الدومنيكان",
    "DZD" to "دينار جزائري",
    "EEK" to "كرونة استونية",
    "EGP" to "جنيه مصري",
    "ERN" to "ناكفا أريتري",
    "ESP" to "بيزيتا إسباني",
    "ETB" to "بير أثيوبي",
    "EUR" to "يورو",
    "FIM" to "ماركا فنلندي",
    "FJD" to "دولار فيجي",
    "FKP" to "جنيه جزر فوكلاند",
    "FRF" to "فرنك فرنسي",
    "GBP" to "جنيه إسترليني",
    "GEL" to "لارى جورجي",
    "GHC" to "سيدي غاني",
    "GHS" to "سيدي غانا",
    "GIP" to "جنيه جبل طارق",
    "GMD" to "دلاسي غامبي",
    "GNF" to "فرنك غينيا",
    "GNS" to "سيلي غينيا",
    "GQE" to "اكويل جونينا غينيا الاستوائيّة",
    "GRD" to "دراخما يوناني",
    "GTQ" to "كوتزال غواتيمالا",
    "GWE" to "اسكود برتغالي غينيا",
    "GWP" to "بيزو غينيا بيساو",
    "GYD" to "دولار غيانا",
    "HKD" to "دولار هونغ كونغ",
    "HNL" to "ليمبيرا هنداروس",
    "HRD" to "دينار كرواتي",
    "HRK" to "كونا كرواتي",
    "HTG" to "جوردى هايتي",
    "HUF" to "فورينت هنغاري",
    "IDR" to "روبية إندونيسية",
    "IEP" to "جنيه إيرلندي",
    "ILP" to "جنيه إسرائيلي",
    "ILS" to "شيكل إسرائيلي جديد",
    "INR" to "روبية هندي",
    "IQD" to "دينار عراقي",
    "IRR" to "ريال إيراني",
    "ISK" to "كرونة أيسلندية",
    "ITL" to "ليرة إيطالية",
    "JMD" to "دولار جامايكي",
    "JOD" to "دينار أردني",
    "JPY" to "ين ياباني",
    "KES" to "شلن كينيي",
    "KGS" to "سوم قيرغستاني",
    "KHR" to "رييال كمبودي",
    "KMF" to "فرنك جزر القمر",
    "KPW" to "وون كوريا الشمالية",
    "KRW" to "وون كوريا الجنوبية",
    "KWD" to "دينار كويتي",
    "KYD" to "دولار جزر كيمن",
    "KZT" to "تينغ كازاخستاني",
    "LAK" to "كيب لاوسي",
    "LBP" to "جنيه لبناني",
    "LKR" to "روبية سريلانكية",
    "LRD" to "دولار ليبيري",
    "LSL" to "لوتي ليسوتو",
    "LTL" to "ليتا ليتوانية",
    "LTT" to "تالوناس ليتواني",
    "LUC" to "فرنك لوكسمبرج قابل للتحويل",
    "LUF" to "فرنك لوكسمبرج",
    "LUL" to "فرنك لوكسمبرج المالي",
    "LVL" to "لاتس لاتفيا",
    "LVR" to "روبل لاتفيا",
    "LYD" to "دينار ليبي",
    "MAD" to "درهم مغربي",
    "MAF" to "فرنك مغربي",
    "MDL" to "ليو مولدوفي",
    "MGA" to "أرياري مدغشقر",
    "MGF" to "فرنك مدغشقر",
    "MKD" to "دينار مقدوني",
    "MLF" to "فرنك مالي",
    "MMK" to "كيات ميانمار",
    "MNT" to "توغروغ منغولي",
    "MOP" to "باتاكا ماكاوي",
    "MRO" to "أوقية موريتانية - 1973-2017",
    "MRU" to "أوقية موريتانية",
    "MTL" to "ليرة مالطية",
    "MTP" to "جنيه مالطي",
    "MUR" to "روبية موريشيوسية",
    "MVR" to "روفيه جزر المالديف",
    "MWK" to "كواشا مالاوي",
    "MXN" to "بيزو مكسيكي",
    "MXP" to "بيزو فضي مكسيكي - 1861-1992",
    "MYR" to "رينغيت ماليزي",
    "MZE" to "اسكود موزمبيقي",
    "MZN" to "متكال موزمبيقي",
    "NAD" to "دولار ناميبي",
    "NGN" to "نايرا نيجيري",
    "NIC" to "كوردوبة نيكاراجوا",
    "NIO" to "قرطبة نيكاراغوا",
    "NLG" to "جلدر هولندي",
    "NOK" to "كرونة نرويجية",
    "NPR" to "روبية نيبالي",
    "NZD" to "دولار نيوزيلندي",
    "OMR" to "ريال عماني",
    "PAB" to "بالبوا بنمي",
    "PEN" to "سول بيروفي",
    "PGK" to "كينا بابوا غينيا الجديدة",
    "PHP" to "بيزو فلبيني",
    "PKR" to "روبية باكستاني",
    "PLN" to "زلوتي بولندي",
    "PLZ" to "زلوتي بولندي - 1950-1995",
    "PTE" to "اسكود برتغالي",
    "PYG" to "غواراني باراغواي",
    "QAR" to "ريال قطري",
    "RHD" to "دولار روديسي",
    "ROL" to "ليو روماني قديم",
    "RON" to "ليو روماني",
    "RSD" to "دينار صربي",
    "RUB" to "روبل روسي",
    "RUR" to "روبل روسي - 1991-1998",
    "RWF" to "فرنك رواندي",
    "SAR" to "ريال سعودي",
    "SBD" to "دولار جزر سليمان",
    "SCR" to "روبية سيشيلية",
    "SDD" to "دينار سوداني",
    "SDG" to "جنيه سوداني",
    "SDP" to "جنيه سوداني قديم",
    "SEK" to "كرونة سويدية",
    "SGD" to "دولار سنغافوري",
    "SHP" to "جنيه سانت هيلين",
    "SIT" to "تولار سلوفيني",
    "SKK" to "كرونة سلوفاكية",
    "SLE" to "ليون سيراليوني",
    "SLL" to "ليون سيراليوني - 1964-2022",
    "SOS" to "شلن صومالي",
    "SRD" to "دولار سورينامي",
    "SRG" to "جلدر سورينامي",
    "SSP" to "جنيه جنوب السودان",
    "STD" to "دوبرا ساو تومي وبرينسيبي - 1977-2017",
    "STN" to "دوبرا ساو تومي وبرينسيبي",
    "SUR" to "روبل سوفيتي",
    "SVC" to "كولون سلفادوري",
    "SYP" to "ليرة سورية",
    "SZL" to "ليلانجيني سوازيلندي",
    "THB" to "باخت تايلاندي",
    "TJR" to "روبل طاجيكستاني",
    "TJS" to "سوموني طاجيكستاني",
    "TMM" to "مانات تركمنستاني",
    "TMT" to "مانات تركمانستان",
    "TND" to "دينار تونسي",
    "TOP" to "بانغا تونغا",
    "TPE" to "اسكود تيموري",
    "TRL" to "ليرة تركي",
    "TRY" to "ليرة تركية",
    "TTD" to "دولار ترينداد وتوباغو",
    "TWD" to "دولار تايواني",
    "TZS" to "شلن تنزاني",
    "UAH" to "هريفنيا أوكراني",
    "UGS" to "شلن أوغندي - 1966-1987",
    "UGX" to "شلن أوغندي",
    "USD" to "دولار أمريكي",
    "USN" to "دولار أمريكي (اليوم التالي)‏",
    "USS" to "دولار أمريكي (نفس اليوم)‏",
    "UYP" to "بيزو أوروجواي - 1975-1993",
    "UYU" to "بيزو اوروغواي",
    "UZS" to "سوم أوزبكستاني",
    "VEB" to "بوليفار فنزويلي - 1871-2008",
    "VEF" to "بوليفار فنزويلي - 2008–2018",
    "VES" to "بوليفار فنزويلي",
    "VND" to "دونج فيتنامي",
    "VUV" to "فاتو فانواتو",
    "WST" to "تالا ساموا",
    "XAF" to "فرنك وسط أفريقي",
    "XAG" to "فضة",
    "XAU" to "ذهب",
    "XBA" to "الوحدة الأوروبية المركبة",
    "XBB" to "الوحدة المالية الأوروبية",
    "XBC" to "الوحدة الحسابية الأوروبية",
    "XBD" to "(XBD)وحدة الحساب الأوروبية",
    "XCD" to "دولار شرق الكاريبي",
    "XDR" to "حقوق السحب الخاصة",
    "XEU" to "وحدة النقد الأوروبية",
    "XFO" to "فرنك فرنسي ذهبي",
    "XFU" to "(UIC)فرنك فرنسي",
    "XOF" to "فرنك غرب أفريقي",
    "XPD" to "بالاديوم",
    "XPF" to "فرنك سي إف بي",
    "XPT" to "البلاتين",
    "XTS" to "كود اختبار العملة",
    "XXX" to "عملة غير معروفة",
    "YDD" to "دينار يمني",
    "YER" to "ريال يمني",
    "YUD" to "دينار يوغسلافي",
    "YUN" to "دينار يوغسلافي قابل للتحويل",
    "ZAL" to "راند جنوب أفريقيا -مالي",
    "ZAR" to "راند جنوب أفريقيا",
    "ZMK" to "كواشا زامبي - 1968-2012",
    "ZMW" to "كواشا زامبي",
    "ZRN" to "زائير زائيري جديد",
    "ZRZ" to "زائير زائيري",
    "ZWD" to "دولار زمبابوي",
    "ZWL" to "دولار زمبابوي 2009",
  ) }

  val ar_AE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_BH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_DJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_DZ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_EG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_EH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_ER: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_IL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_IQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_JO: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_KM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_KW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_LB: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_LY: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_MA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_OM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_PS: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_QA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SO: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SS: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SY: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_TD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_TN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_YE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val arn: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val `as`: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "সংযুক্ত আৰব আমিৰাত ডিৰহেম",
    "AFN" to "আফগান আফগানী",
    "ALL" to "আলবেনীয় লেক",
    "AMD" to "আৰ্মেনিয়ান ড্ৰাম",
    "ANG" to "নেডাৰলেণ্ডছ এণ্টিলিয়েন গিল্ডাৰ",
    "AOA" to "এংগোলান কোৱাঞ্জা",
    "ARS" to "আৰ্জেণ্টাইন পেছো",
    "AUD" to "অষ্ট্ৰেলিয়ান ডলাৰ",
    "AWG" to "আৰুবান ফ্ল’ৰিন",
    "AZN" to "আজেৰবাইজানী মানাত",
    "BAM" to "ব’ছনিয়া আৰু হাৰ্জেগ’ভিনা কনভাৰ্টিব্‌ল মাৰ্ক",
    "BBD" to "বাৰ্বাডিয়ান ডলাৰ",
    "BDT" to "বাংলাদেশী টাকা",
    "BGN" to "বুলগেৰীয় লেভ",
    "BHD" to "বাহৰেইনী ডিনাৰ",
    "BIF" to "বুৰুণ্ডিয়ান ফ্ৰেংক",
    "BMD" to "বাৰ্মুডান ডলাৰ",
    "BND" to "ব্ৰুনেই ডলাৰ",
    "BOB" to "বলিভিয়ান বলিভিয়ানো",
    "BRL" to "ব্ৰাজিলিয়ান ৰিয়েল",
    "BSD" to "বাহামিয়ান ডলাৰ",
    "BTN" to "ভুটানী নংগলট্ৰাম",
    "BWP" to "ব’টচোৱানান পুলা",
    "BYN" to "বেলাৰুছীয় ৰুবেল",
    "BZD" to "বেলিজ ডলাৰ",
    "CAD" to "কানাডিয়ান ডলাৰ",
    "CDF" to "কংগো ফ্ৰেংক",
    "CHF" to "চুইছ ফ্ৰেংক",
    "CLP" to "চিলিয়ান পেছো",
    "CNH" to "চীনা ইউৱান (অফশ্ব’ৰ)",
    "CNY" to "চীনা ইউৱান",
    "COP" to "কলম্বিয়ান পেছো",
    "CRC" to "কোষ্টা ৰিকান কোলন",
    "CUC" to "কিউবান ৰূপান্তৰযোগ্য পেছো",
    "CUP" to "কিউবান পেছো",
    "CVE" to "কেপ ভাৰ্দে এছকুডো",
    "CZK" to "চেক কোৰুনা",
    "DJF" to "জিবুটি ফ্ৰেংক",
    "DKK" to "ডেনিচ ক্ৰোন",
    "DOP" to "ড’মিনিকান পেছো",
    "DZD" to "আলজেৰীয় ডিনাৰ",
    "EGP" to "ইজিপ্তৰ পাউণ্ড",
    "ERN" to "এৰিট্ৰিয়ন নাক্‌ফা",
    "ETB" to "ইথিঅ’পিয়ান বিৰ",
    "EUR" to "ইউৰো",
    "FJD" to "ফিজিয়ান ডলাৰ",
    "FKP" to "ফকলেণ্ড দ্বীপপুঞ্জৰ পাউণ্ড",
    "GBP" to "ব্ৰিটিছ পাউণ্ড",
    "GEL" to "জৰ্জিয়ান লাৰি",
    "GHS" to "ঘানাৰ চেডি",
    "GIP" to "জিব্ৰাল্টৰ পাউণ্ড",
    "GMD" to "গাম্বিয়া ডালাছি",
    "GNF" to "গিনি ফ্ৰেংক",
    "GTQ" to "গুৱাটেমালা কুৱেৎজাল",
    "GYD" to "গায়ানিজ ডলাৰ",
    "HKD" to "হং কং ডলাৰ",
    "HNL" to "হোন্দুৰান লেম্পিৰা",
    "HRK" to "ক্ৰোৱেছিয়ান কুনা",
    "HTG" to "হাইটিয়ান গৌৰ্ড",
    "HUF" to "হাংগেৰীয়ান ফ’ৰিণ্ট",
    "IDR" to "ইণ্ডোনেচিয়ান ৰুপিয়াহ",
    "ILS" to "ইজৰাইলী নিউ শ্বেকেল",
    "INR" to "ভাৰতীয় ৰুপী",
    "IQD" to "ইৰাকী ডিনাৰ",
    "IRR" to "ইৰানীয়ান ৰিয়েল",
    "ISK" to "আইচলেণ্ডিক ক্ৰোনা",
    "JMD" to "জামাইকান ডলাৰ",
    "JOD" to "জৰ্ডানিয়ান ডিনাৰ",
    "JPY" to "জাপানী য়েন",
    "KES" to "কেনিয়ান শ্বিলিং",
    "KGS" to "কিৰ্গিস্তানী ছোম",
    "KHR" to "কেম্ব’ডিয়ান ৰিয়েল",
    "KMF" to "ক’মোৰিয়ান ফ্ৰেংক",
    "KPW" to "উত্তৰ কোৰিয়াৰ ওৱান",
    "KRW" to "দক্ষিণ কোৰিয়াৰ ওৱান",
    "KWD" to "কুৱেইটি ডিনাৰ",
    "KYD" to "কেইমেন দ্বীপপুঞ্জৰ ডলাৰ",
    "KZT" to "কাজাখস্তানী তেঞ্জ",
    "LAK" to "লাওচিয়ান কিপ",
    "LBP" to "লেবানীজ পাউণ্ড",
    "LKR" to "শ্ৰীলংকান ৰুপী",
    "LRD" to "লাইবেৰিয়ান ডলাৰ",
    "LSL" to "লেচোথো লোটি",
    "LYD" to "লিবিয়ান ডিনাৰ",
    "MAD" to "মৰোক্কান ডিৰহাম",
    "MDL" to "মোলডোভান লেউ",
    "MGA" to "মালাগাছী এৰিয়াৰী",
    "MKD" to "মেচিডোনীয় ডেনাৰ",
    "MMK" to "ম্যানমাৰ কিয়াট",
    "MNT" to "মঙ্গোলিয়ান টুৰ্গিক",
    "MOP" to "মেকানীজ পাটাকা",
    "MRO" to "ম’ৰিটেনিয়ান ঔগুইয়া (1973–2017)",
    "MRU" to "ম’ৰিটেনিয়ান ঔগুইয়া",
    "MUR" to "মৰিচিয়ান ৰুপী",
    "MVR" to "মালডিভিয়ান ৰুফিয়া",
    "MWK" to "মালাউইয়ান কোৱাচা",
    "MXN" to "মেক্সিকান পেছো",
    "MYR" to "মালায়েচিয়ান ৰিংগিট",
    "MZN" to "মোজাম্বিকান মেটিকল",
    "NAD" to "নামিবিয়ান ডলাৰ",
    "NGN" to "নাইজেৰিয়ান নাইৰা",
    "NIO" to "নিকাৰাগুৱান কোৰ্ডোবা",
    "NOK" to "নৰৱেজিয়ান ক্ৰোন",
    "NPR" to "নেপালী ৰুপী",
    "NZD" to "নিউজিলেণ্ড ডলাৰ",
    "OMR" to "ওমানি ৰিয়েল",
    "PAB" to "পানামেনিয়ান বাল্বোৱা",
    "PEN" to "পেৰুভিয়ান ছ’ল",
    "PGK" to "পাপুৱা নিউ গিনি কিনা",
    "PHP" to "ফিলিপিন পেইছ’",
    "PKR" to "পাকিস্তানী ৰুপী",
    "PLN" to "প’লিচ জোল্টী",
    "PYG" to "পাৰাগুয়ান গুৱাৰানি",
    "QAR" to "কাটাৰি ৰিয়েল",
    "RON" to "ৰোমানীয় লেউ",
    "RSD" to "চাৰ্বিয়ান ডিনাৰ",
    "RUB" to "ৰাছিয়ান ৰুব্‌ল",
    "RWF" to "ৰোৱান্দান ফ্ৰেংক",
    "SAR" to "চৌডি ৰিয়েল",
    "SBD" to "চোলোমোন দ্বীপপুঞ্জৰ ডলাৰ",
    "SCR" to "ছেচেলৱা ৰুপী",
    "SDG" to "চুডানী পাউণ্ড",
    "SEK" to "চুইডিছ ক্ৰোনা",
    "SGD" to "ছিংগাপুৰ ডলাৰ",
    "SHP" to "ছেইণ্ট হেলেনা পাউণ্ড",
    "SLE" to "চিয়েৰা লিঅ’নৰ লিঅ’ন",
    "SLL" to "চিয়েৰা লিঅ’নৰ লিঅ’ন (1964—2022)",
    "SOS" to "চোমালি শ্বিলিং",
    "SRD" to "ছুৰিনামী ডলাৰ",
    "SSP" to "দক্ষিণ চুডানীজ পাউণ্ড",
    "STD" to "চাও টোমে আৰু প্ৰিনচিপে ডোব্‌ৰা (1977–2017)",
    "STN" to "চাও টোমে আৰু প্ৰিনচিপে ডোব্‌ৰা",
    "SYP" to "চিৰিয়ান পাউণ্ড",
    "SZL" to "স্বাজি লিলেংগেনি",
    "THB" to "থাই বাত",
    "TJS" to "তাজিকিস্তানী ছোমনি",
    "TMT" to "তুৰ্কমেনিস্তানী মানাত",
    "TND" to "টুনিচিয়ান ডিনাৰ",
    "TOP" to "টংগান পাআংগা",
    "TRY" to "তুৰ্কীৰ লিৰা",
    "TTD" to "ট্ৰিনিডাড আৰু টোবাগো ডলাৰ",
    "TWD" to "নিউ টাইৱান ডলাৰ",
    "TZS" to "টানজানিয়ান শ্বিলিং",
    "UAH" to "ইউক্ৰেইনীয় হৃভনিয়া",
    "UGX" to "উগাণ্ডান শ্বিলিং",
    "USD" to "ইউ. এছ. ডলাৰ",
    "UYU" to "উৰুগুৱেয়ান পেছো",
    "UZS" to "উজবেকিস্তানী ছোম",
    "VEB" to "ভেনিজুৱেলান বলিভাৰ (1871–2008)",
    "VEF" to "ভেনিজুৱেলান বলিভাৰ (2008–2018)",
    "VES" to "ভেনিজুৱেলান বলিভাৰ",
    "VND" to "ভিয়েটনামীজ ডং",
    "VUV" to "ভানাটুৰ ভাটু",
    "WST" to "ছামোৱান টালা",
    "XAF" to "মধ্য আফ্ৰিকান CFA ফ্ৰেংক",
    "XCD" to "ইষ্ট কেৰিবিয়ান ডলাৰ",
    "XOF" to "পশ্চিম আফ্ৰিকান CFA ফ্ৰেংক",
    "XPF" to "CFP ফ্ৰেংক",
    "XXX" to "অজ্ঞাত মুদ্ৰা",
    "YER" to "য়েমেনী ৰিয়েল",
    "ZAR" to "দক্ষিণ আফ্ৰিকাৰ ৰাণ্ড",
    "ZMW" to "জাম্বিয়ান কোৱাচা",
  ) }

  val asa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "dirham ya Falme dha Kiarabu",
    "AOA" to "kwandha ya Angola",
    "AUD" to "dola ya Authtralia",
    "BHD" to "dinari ya Bahareni",
    "BIF" to "faranga ya Burundi",
    "BWP" to "pula ya Botthwana",
    "CAD" to "dola ya Kanada",
    "CDF" to "faranga ya Kongo",
    "CHF" to "faranga ya Uthwithi",
    "CNY" to "yuan renminbi ya China",
    "CVE" to "ethkudo ya Kepuvede",
    "DJF" to "faranga ya Jibuti",
    "DZD" to "dinari ya Aljeria",
    "EGP" to "pauni ya Mithri",
    "ERN" to "nakfa ya Eritrea",
    "ETB" to "bir ya Uhabeshi",
    "EUR" to "yuro",
    "GBP" to "pauni ya Uingeredha",
    "GHC" to "thedi ya Ghana",
    "GMD" to "dalathi ya Gambia",
    "GNS" to "faranga ya Gine",
    "INR" to "rupia ya India",
    "JPY" to "tharafu ya Kijapani",
    "KES" to "shilingi ya Kenya",
    "KMF" to "faranga ya Komoro",
    "LRD" to "dola ya Liberia",
    "LSL" to "loti ya Lethoto",
    "LYD" to "dinari ya Libya",
    "MAD" to "dirham ya Moroko",
    "MGA" to "faranga ya Bukini",
    "MRO" to "ugwiya ya Moritania (1973–2017)",
    "MRU" to "ugwiya ya Moritania",
    "MUR" to "rupia ya Morithi",
    "MWK" to "kwacha ya Malawi",
    "MZM" to "metikali ya Mthumbiji",
    "NAD" to "dola ya Namibia",
    "NGN" to "naira ya Nijeria",
    "RWF" to "faranga ya Rwanda",
    "SAR" to "riyal ya Thaudia",
    "SCR" to "rupia ya Shelisheli",
    "SDG" to "dinari ya Thudani",
    "SDP" to "pauni ya Thudani",
    "SHP" to "pauni ya Thantahelena",
    "SLE" to "leoni",
    "SLL" to "leoni (1964—2022)",
    "SOS" to "shilingi ya Thomalia",
    "STD" to "dobra ya Thao Tome na Principe (1977–2017)",
    "STN" to "dobra ya Thao Tome na Principe",
    "SZL" to "lilangeni",
    "TND" to "dinari ya Tunithia",
    "TZS" to "shilingi ya Tandhania",
    "UGX" to "shilingi ya Uganda",
    "USD" to "dola ya Marekani",
    "XAF" to "faranga CFA BEAC",
    "XOF" to "faranga CFA BCEAO",
    "ZAR" to "randi ya Afrika Kuthini",
    "ZMK" to "kwacha ya Dhambia (1968–2012)",
    "ZMW" to "kwacha ya Dhambia",
    "ZWD" to "dola ya Dhimbabwe",
  ) }

  val ast: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Peseta andorrana",
    "AED" to "Dirḥam de los Emiratos Árabes Xuníos",
    "AFA" to "Afganí afganistanu (1927–2002)",
    "AFN" to "Afganí afganistanu",
    "ALK" to "Lek albanés (1946–1965)",
    "ALL" to "Lek albanés",
    "AMD" to "Dram armeniu",
    "ANG" to "Guílder de les Antilles Neerlandeses",
    "AOA" to "Kwanza angolanu",
    "AOK" to "Kwanza angolanu (1977–1991)",
    "AON" to "Kwanza nuevu angolanu (1990–2000)",
    "AOR" to "Kwanza angolanu reaxustáu (1995–1999)",
    "ARA" to "Austral arxentín",
    "ARL" to "Pesu Ley arxentín (1970–1983)",
    "ARM" to "Pesu arxentín (1881–1970)",
    "ARP" to "Pesu arxentín (1983–1985)",
    "ARS" to "pesu arxentín",
    "ATS" to "Chelín austriacu",
    "AUD" to "Dólar australianu",
    "AWG" to "Florín arubanu",
    "AZM" to "Manat azerbaixanu (1993–2006)",
    "AZN" to "Manat azerbaixanu",
    "BAD" to "Dinar de Bosnia-Herzegovina (1992–1994)",
    "BAM" to "marcu convertible de Bosnia-Herzegovina",
    "BAN" to "Dinar nuevu de Bosnia-Herzegovina (1994–1997)",
    "BBD" to "Dólar barbadianu",
    "BDT" to "Taka bangladexí",
    "BEC" to "Francu belga (convertible)",
    "BEF" to "Francu belga",
    "BEL" to "Francu belga (financieru)",
    "BGL" to "Lev fuerte búlgaru",
    "BGM" to "Lev socialista búlgaru",
    "BGN" to "Lev búlgaru",
    "BGO" to "Lev búlgaru (1879–1952)",
    "BHD" to "Dinar baḥreiní",
    "BIF" to "Francu burundianu",
    "BMD" to "Dólar bermudianu",
    "BND" to "dólar bruneyanu",
    "BOB" to "Bolivianu de Bolivia",
    "BOL" to "Boliviano de Bolivia (1863–1963)",
    "BOP" to "Pesu bolivianu",
    "BOV" to "Bolivianos mvdol",
    "BRB" to "Cruzeiro nuevu brasilanu (1967–1986)",
    "BRC" to "Cruzado brasilanu (1986–1989)",
    "BRE" to "Cruzeiro brasilanu (1990–1993)",
    "BRL" to "real brasilanu",
    "BRN" to "Cruzado nuevu brasilanu (1989–1990)",
    "BRR" to "Cruzeiro brasilanu (1993–1994)",
    "BRZ" to "Cruzeiru brasilanu (1942–1967)",
    "BSD" to "Dólar bahamés",
    "BTN" to "Ngultrum butanés",
    "BUK" to "Kyat birmanu",
    "BWP" to "Pula botsuaniana",
    "BYB" to "Rublu nuevu bielorrusu (1994–1999)",
    "BYN" to "Rublu bielorrusu",
    "BYR" to "Rublu bielorrusu (2000–2016)",
    "BZD" to "Dólar belizianu",
    "CAD" to "Dólar canadiense",
    "CDF" to "francu congolés",
    "CHE" to "Euru WIR",
    "CHF" to "francu suizu",
    "CHW" to "Francu WIR",
    "CLE" to "Escudu chilenu",
    "CLF" to "Unidá de cuenta chilena (UF)",
    "CLP" to "pesu chilenu",
    "CNX" to "Dólar del Bancu Popular Chinu",
    "CNY" to "Yuan chinu",
    "COP" to "pesu colombianu",
    "COU" to "Unidá de valor real colombiana",
    "CRC" to "Colón costarricanu",
    "CSD" to "Dinar serbiu (2002–2006)",
    "CSK" to "Corona fuerte checoslovaca",
    "CUC" to "Pesu cubanu convertible",
    "CUP" to "Pesu cubanu",
    "CVE" to "escudu cabuverdianu",
    "CYP" to "Llibra xipriota",
    "CZK" to "Corona checa",
    "DDM" to "Marcu d’Alemaña Oriental",
    "DEM" to "Marcu alemán",
    "DJF" to "Francu xibutianu",
    "DKK" to "corona danesa",
    "DOP" to "Pesu dominicanu",
    "DZD" to "dinar arxelín",
    "ECS" to "Sucre ecuatorianu",
    "ECV" to "Unidá ecuatoriana de valor constante",
    "EEK" to "Corona estonia",
    "EGP" to "llibra exipciana",
    "ERN" to "Nakfa eritréu",
    "ESA" to "Peseta española (cuenta A)",
    "ESB" to "Peseta española (cuenta convertible)",
    "ESP" to "Peseta española",
    "ETB" to "Birr etíope",
    "EUR" to "euro",
    "FIM" to "Marcu finlandés",
    "FJD" to "dólar fixanu",
    "FKP" to "llibra malviniana",
    "FRF" to "Francu francés",
    "GBP" to "llibra esterlina",
    "GEK" to "Kupon larit xeorxanu",
    "GEL" to "Lari xeorxanu",
    "GHC" to "Cedi ghanianu (1979–2007)",
    "GHS" to "cedi ghanianu",
    "GIP" to "llibra de Xibraltar",
    "GMD" to "dalasi gambianu",
    "GNF" to "francu guineanu",
    "GNS" to "syli guineanu",
    "GQE" to "Ekwele de Guinea Ecuatorial",
    "GRD" to "Dracma griegu",
    "GTQ" to "Quetzal guatemalianu",
    "GWE" to "Escudo de Guinea portuguesa",
    "GWP" to "Pesu de Guinea-Bisáu",
    "GYD" to "dólar guyanés",
    "HKD" to "Dólar hongkonés",
    "HNL" to "Lempira hondurana",
    "HRD" to "Dinar croata",
    "HRK" to "Kuna croata",
    "HTG" to "Gourde haitianu",
    "HUF" to "Forint húngaru",
    "IDR" to "rupiah indonesia",
    "IEP" to "Llibra irlandesa",
    "ILP" to "Llibra israelina",
    "ILR" to "Xequel israelín (1980–1985)",
    "ILS" to "Xequel nuevu israelín",
    "INR" to "Rupia india",
    "IQD" to "Dinar iraquín",
    "IRR" to "Rial iranín",
    "ISJ" to "Corona islandesa (1918–1981)",
    "ISK" to "corona islandesa",
    "ITL" to "Llira italiana",
    "JMD" to "Dólar xamaicanu",
    "JOD" to "Dinar xordanu",
    "JPY" to "Yen xaponés",
    "KES" to "Shilling kenianu",
    "KGS" to "Som kirguistanín",
    "KHR" to "riel camboyanu",
    "KMF" to "Francu comoranu",
    "KPW" to "Won norcoreanu",
    "KRH" to "Hwan surcoreanu (1953–1962)",
    "KRO" to "Won surcoreanu (1945–1953)",
    "KRW" to "Won surcoreanu",
    "KWD" to "Dinar kuwaitianu",
    "KYD" to "dólar caimanés",
    "KZT" to "Tenge kazaquistanín",
    "LAK" to "kip laosianu",
    "LBP" to "Llibra libanesa",
    "LKR" to "Rupia de Sri Lanka",
    "LRD" to "dólar liberianu",
    "LSL" to "Loti de Lesothu",
    "LTL" to "Litas lituanu",
    "LTT" to "Talonas lituanu",
    "LUC" to "Francu convertible luxemburgués",
    "LUF" to "Francu luxemburgués",
    "LUL" to "Francu financieru luxemburgués",
    "LVL" to "Lats letón",
    "LVR" to "Rublu letón",
    "LYD" to "dinar libiu",
    "MAD" to "dirḥam marroquín",
    "MAF" to "francu marroquín",
    "MCF" to "Francu monegascu",
    "MDC" to "Cupón moldavu",
    "MDL" to "Leu moldavu",
    "MGA" to "Ariary malgaxe",
    "MGF" to "Francu malgaxe",
    "MKD" to "Denar macedoniu",
    "MKN" to "Denar macedoniu (1992–1993)",
    "MLF" to "Francu malianu",
    "MMK" to "kyat de Myanmar",
    "MNT" to "Tugrik mongol",
    "MOP" to "Pataca de Macáu",
    "MRO" to "ouguiya mauritanu (1973–2017)",
    "MRU" to "ouguiya mauritanu",
    "MTL" to "Llira maltesa",
    "MTP" to "Llibra maltesa",
    "MUR" to "Rupia mauriciana",
    "MVP" to "Rupia maldiviana (1947–1981)",
    "MVR" to "Rufiyaa maldiviana",
    "MWK" to "Kwacha malauianu",
    "MXN" to "Pesu mexicanu",
    "MXP" to "Pesu de plata mexicanu (1861–1992)",
    "MXV" to "Unidá d’inversión mexicana",
    "MYR" to "ringgit malasiu",
    "MZE" to "Escudu mozambicanu",
    "MZM" to "Metical mozambicanu (1980–2006)",
    "MZN" to "Metical mozambicanu",
    "NAD" to "Dólar namibianu",
    "NGN" to "naira nixeriana",
    "NIC" to "Córdoba nicaraguanu (1988–1991)",
    "NIO" to "Córdoba nicaraguanu",
    "NLG" to "Florín neerlandés",
    "NOK" to "corona noruega",
    "NPR" to "Rupia nepalesa",
    "NZD" to "dólar neozelandés",
    "OMR" to "Rial omanianu",
    "PAB" to "Balboa panamiegu",
    "PEI" to "Inti peruanu",
    "PEN" to "Sol peruanu",
    "PES" to "Sol peruanu (1863–1965)",
    "PGK" to "kina papuana",
    "PHP" to "pesu filipín",
    "PKR" to "Rupia paquistanina",
    "PLN" to "Zloty polacu",
    "PLZ" to "Zloty polacu (1950–1995)",
    "PTE" to "Escudu portugués",
    "PYG" to "guaraní paraguayu",
    "QAR" to "Rial qatarín",
    "RHD" to "Dólar rodesianu",
    "ROL" to "Leu rumanu (1952–2006)",
    "RON" to "Leu rumanu",
    "RSD" to "dinar serbiu",
    "RUB" to "Rublu rusu",
    "RUR" to "Rublu rusu (1991–1998)",
    "RWF" to "Francu ruandés",
    "SAR" to "Riyal saudita",
    "SBD" to "dólar salomonés",
    "SCR" to "Rupia seixelesa",
    "SDD" to "dinar sudanés (1992–2007)",
    "SDG" to "llibra sudanesa",
    "SDP" to "llibra sudanesa (1957–1998)",
    "SEK" to "corona sueca",
    "SGD" to "dólar singapuranu",
    "SHP" to "llibra de Santa Lena",
    "SIT" to "Tolar eslovenu",
    "SKK" to "Corona eslovaca",
    "SLE" to "leone sierralleonés",
    "SOS" to "Shilling somalín",
    "SRD" to "dólar surinamés",
    "SRG" to "Florín surinamés",
    "SSP" to "llibra sursudanesa",
    "STD" to "dobra de Santu Tomé y Príncipe (1977–2017)",
    "STN" to "dobra de Santu Tomé y Príncipe",
    "SUR" to "Rublu soviéticu",
    "SVC" to "Colón salvadorianu",
    "SYP" to "Llibra siria",
    "SZL" to "Lilangeni suazilandés",
    "THB" to "baht tailandés",
    "TJR" to "Rublu taxiquistanín",
    "TJS" to "Somoni taxiquistanín",
    "TMM" to "Manat turcomanu (1993–2009)",
    "TMT" to "Manat turcomanu",
    "TND" to "dinar tunecín",
    "TOP" to "paʻanga tonganu",
    "TPE" to "Escudu timorés",
    "TRL" to "Llira turca (1922–2005)",
    "TRY" to "Llira turca",
    "TTD" to "dólar de Trinidá y Tobagu",
    "TWD" to "Dólar nuevu taiwanés",
    "TZS" to "Shilling tanzanianu",
    "UAH" to "Grivna ucraína",
    "UAK" to "Karbovanets ucraína",
    "UGS" to "Shilling ugandés (1966–1987)",
    "UGX" to "Shilling ugandés",
    "USD" to "Dólar estaunidense",
    "USN" to "Dólar d’EE.XX. (día siguiente)",
    "USS" to "Dólar d’EE.XX. (mesmu día)",
    "UYI" to "Pesu uruguayu (Unidaes indexaes)",
    "UYP" to "Pesu uruguayu (1975–1993)",
    "UYU" to "pesu uruguayu",
    "UZS" to "Som uzbequistanín",
    "VEB" to "Bolívar venezolanu (1871–2008)",
    "VEF" to "bolívar venezolanu (2008–2018)",
    "VES" to "bolívar venezolanu",
    "VND" to "dong vietnamín",
    "VNN" to "Dong vietnamín (1978–1985)",
    "VUV" to "vatu vanuatuanu",
    "WST" to "tala samoanu",
    "XAF" to "Francu CFA centroafricanu",
    "XAG" to "Plata",
    "XAU" to "Oru",
    "XBA" to "Unidá Compuesta Europea",
    "XBB" to "Unidá monetaria europea",
    "XBC" to "Unidá de cuenta europea (XBC)",
    "XBD" to "Unidá de cuenta europea (XBD)",
    "XCD" to "dólar del Caribe Oriental",
    "XDR" to "Drechos especiales de xiru",
    "XEU" to "Unidá de divisa europea",
    "XFO" to "Francu oru francés",
    "XFU" to "Francu UIC francés",
    "XOF" to "francu CFA BCEAO",
    "XPD" to "Paladiu",
    "XPF" to "francu CFP",
    "XPT" to "Platín",
    "XRE" to "Fondos RINET",
    "XSU" to "Sucre",
    "XTS" to "Códigu monetariu de prueba",
    "XUA" to "unidá de cuenta ADB",
    "XXX" to "Divisa desconocida",
    "YDD" to "Dinar yemenín",
    "YER" to "Rial yemenín",
    "YUD" to "Dinar fuerte yugoslavu (1966–1990)",
    "YUM" to "Dinar nuevu yugoslavu (1994–2002)",
    "YUN" to "Dinar convertible yugoslavu (1990–1992)",
    "YUR" to "Dinar reformáu yugoslavu (1992–1993)",
    "ZAL" to "Rand sudafricanu (financieru)",
    "ZAR" to "Rand sudafricanu",
    "ZMK" to "Kwacha zambianu (1968–2012)",
    "ZMW" to "Kwacha zambianu",
    "ZRN" to "Zaire nuevu zairiegu (1993–1998)",
    "ZRZ" to "Zaire zairiegu (1971–1993)",
    "ZWD" to "Dólar zimbabuanu (1980–2008)",
    "ZWL" to "Dólar zimbabuanu (2009)",
    "ZWR" to "Dólar zimbabuanu (2008)",
  ) }

  val az: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andora Pesetası",
    "AED" to "Birləşmiş Ərəb Əmirlikləri Dirhəmi",
    "AFA" to "Əfqanıstan Əfqanisi (1927–2002)",
    "AFN" to "Əfqanıstan Əfqanisi",
    "ALK" to "Albaniya Leki (1946–1965)",
    "ALL" to "Albaniya Leki",
    "AMD" to "Ermənistan Dramı",
    "ANG" to "Niderland Antilyası Gilderi",
    "AOA" to "Anqola Kvanzası",
    "AOK" to "Anqola Kvanzasi (1977–1990)",
    "AON" to "Anqola Yeni Kvanzası (1990–2000)",
    "AOR" to "Anqola Kvanzası (1995–1999)",
    "ARA" to "Argentina avstralı",
    "ARP" to "Argentina pesosu (1983–1985)",
    "ARS" to "Argentina Pesosu",
    "ATS" to "Avstriya Şillinqi",
    "AUD" to "Avstraliya Dolları",
    "AWG" to "Aruba Florini",
    "AZM" to "Azərbaycan Manatı (1993–2006)",
    "AZN" to "Azərbaycan Manatı",
    "BAD" to "Bosniya-Herseqovina Dinarı",
    "BAM" to "Bosniya-Herseqovina Markası",
    "BBD" to "Barbados Dolları",
    "BDT" to "Banqladeş Takası",
    "BEC" to "Belçika Frankı (deyşirik)",
    "BEF" to "Belçika Frankı",
    "BEL" to "Belçika Frankı (finans)",
    "BGL" to "Bolqarıstan Levası",
    "BGN" to "Bolqarıstan Levi",
    "BHD" to "Bəhreyn Dinarı",
    "BIF" to "Burundi Frankı",
    "BMD" to "Bermuda Dolları",
    "BND" to "Bruney Dolları",
    "BOB" to "Boliviya Bolivianosu",
    "BOP" to "Boliviya pesosu",
    "BOV" to "Boliviya mvdolı",
    "BRB" to "Braziliya kruzeyro novası",
    "BRC" to "Braziliya kruzadosu",
    "BRE" to "Braziliya kruzeyrosu (1990–1993)",
    "BRL" to "Braziliya Realı",
    "BRN" to "Braziliya kruzado novası",
    "BRR" to "Braziliya kruzeyrosu",
    "BSD" to "Baham Dolları",
    "BTN" to "Butan Nqultrumu",
    "BUK" to "Burmis Kyatı",
    "BWP" to "Botsvana Pulası",
    "BYB" to "Belarus Yeni Rublu (1994–1999)",
    "BYN" to "Belarus Rublu",
    "BYR" to "Belarus Rublu (2000–2016)",
    "BZD" to "Beliz Dolları",
    "CAD" to "Kanada Dolları",
    "CDF" to "Konqo Frankı",
    "CHE" to "WIR Avro",
    "CHF" to "İsveçrə Frankı",
    "CHW" to "WIR Frankası",
    "CLP" to "Çili Pesosu",
    "CNH" to "Çin Yuanı (ofşor)",
    "CNY" to "Çin Yuanı",
    "COP" to "Kolumbiya Pesosu",
    "CRC" to "Kosta Rika Kolonu",
    "CSD" to "Serbiya Dinarı (2002–2006)",
    "CSK" to "Çexoslavakiya Korunası",
    "CUC" to "Kuba Çevrilən Pesosu",
    "CUP" to "Kuba Pesosu",
    "CVE" to "Kape Verde Eskudosu",
    "CYP" to "Kipr Paundu",
    "CZK" to "Çexiya Korunası",
    "DDM" to "Şərq Almaniya Ostmarkı",
    "DEM" to "Alman Markası",
    "DJF" to "Cibuti Frankı",
    "DKK" to "Danimarka Kronu",
    "DOP" to "Dominika Pesosu",
    "DZD" to "Əlcəzair Dinarı",
    "ECS" to "Ekvador Sukresi",
    "EEK" to "Estoniya Krunu",
    "EGP" to "Misir Funtu",
    "ERN" to "Eritreya Nakfası",
    "ESA" to "İspan Pesetası (A account)",
    "ESB" to "İspan Pesetası (dəyşirik)",
    "ESP" to "İspan Pesetası",
    "ETB" to "Efiopiya Bırrı",
    "EUR" to "Avro",
    "FIM" to "Fin Markası",
    "FJD" to "Fici Dolları",
    "FKP" to "Folklend Adaları Funtu",
    "FRF" to "Fransız Markası",
    "GBP" to "Britaniya Funtu",
    "GEK" to "Gürcüstan Kupon Lariti",
    "GEL" to "Gürcüstan Larisi",
    "GHC" to "Qana Sedisi (1979–2007)",
    "GHS" to "Qana Sedisi",
    "GIP" to "Cəbəli-Tariq Funtu",
    "GMD" to "Qambiya Dalasisi",
    "GNF" to "Qvineya Frankı",
    "GNS" to "Qvineya Sulisi",
    "GQE" to "Ekvatoriya Gvineya Ekvele Quneanası",
    "GRD" to "Yunan Draçması",
    "GTQ" to "Qvatemala Küetzalı",
    "GWE" to "Portugal Qvineya Eskudosu",
    "GWP" to "Qvineya-Bisau Pesosu",
    "GYD" to "Qayana Dolları",
    "HKD" to "Honq Konq Dolları",
    "HNL" to "Honduras Lempirası",
    "HRD" to "Xorvatiya Dinarı",
    "HRK" to "Xorvatiya Kunası",
    "HTG" to "Haiti Qourdu",
    "HUF" to "Macarıstan Forinti",
    "IDR" to "İndoneziya Rupisi",
    "IEP" to "İrlandiya Paundu",
    "ILP" to "İzrail Paundu",
    "ILR" to "İsrail Şekeli (1980–1985)",
    "ILS" to "İsrail Yeni Şekeli",
    "INR" to "Hindistan Rupisi",
    "IQD" to "İraq Dinarı",
    "IRR" to "İran Rialı",
    "ISJ" to "İslandiya Kronu (1918–1981)",
    "ISK" to "İslandiya Kronu",
    "ITL" to "İtaliya Lirası",
    "JMD" to "Yamayka Dolları",
    "JOD" to "İordaniya Dinarı",
    "JPY" to "Yaponiya Yeni",
    "KES" to "Keniya Şillinqi",
    "KGS" to "Qırğızıstan Somu",
    "KHR" to "Kamboca Rieli",
    "KMF" to "Komor Frankı",
    "KPW" to "Şimali Koreya Vonu",
    "KRW" to "Cənubi Koreya Vonu",
    "KWD" to "Küveyt Dinarı",
    "KYD" to "Kayman Adaları Dolları",
    "KZT" to "Qazaxıstan Tengesi",
    "LAK" to "Laos Kipi",
    "LBP" to "Livan Funtu",
    "LKR" to "Şri Lanka Rupisi",
    "LRD" to "Liberiya Dolları",
    "LSL" to "Lesoto Lotisi",
    "LTL" to "Litva Liti",
    "LTT" to "Litva Talonası",
    "LUC" to "Luksemburq Frankası (dəyişik)",
    "LUF" to "Luksemburq Frankası",
    "LUL" to "Luksemburq Frankası (finans)",
    "LVL" to "Latviya Latı",
    "LVR" to "Latviya Rublu",
    "LYD" to "Liviya Dinarı",
    "MAD" to "Mərakeş Dirhəmi",
    "MAF" to "Mərakeş Frankası",
    "MDL" to "Moldova Leyi",
    "MGA" to "Madaqaskar Ariarisi",
    "MGF" to "Madaqaskar Frankası",
    "MKD" to "Makedoniya Dinarı",
    "MKN" to "Makedoniya Dinarı (1992–1993)",
    "MLF" to "Mali Frankı",
    "MMK" to "Myanma Kiyatı",
    "MNT" to "Monqoliya Tuqriki",
    "MOP" to "Makao Patakası",
    "MRO" to "Mavritaniya Ugiyası (1973–2017)",
    "MRU" to "Mavritaniya Ugiyası",
    "MTP" to "Maltiz Paundu",
    "MUR" to "Mavriki Rupisi",
    "MVR" to "Maldiv Rufiyası",
    "MWK" to "Malavi Kvaçası",
    "MXN" to "Meksika Pesosu",
    "MXP" to "Meksika gümüş pesosu",
    "MYR" to "Malayziya Ringiti",
    "MZE" to "Mozambik Eskudosu",
    "MZM" to "Mozambik Metikalı (1980–2006)",
    "MZN" to "Mozambik Metikalı",
    "NAD" to "Namibiya Dolları",
    "NGN" to "Nigeriya Nairası",
    "NIC" to "Nikaraqua kordobu",
    "NIO" to "Nikaraqua Kordobası",
    "NLG" to "Hollandiya Gilderi",
    "NOK" to "Norveç Kronu",
    "NPR" to "Nepal Rupisi",
    "NZD" to "Yeni Zelandiya Dolları",
    "OMR" to "Oman Rialı",
    "PAB" to "Panama Balboası",
    "PEI" to "Peru Inti",
    "PEN" to "Peru Solu",
    "PES" to "Peru Solu (1863–1965)",
    "PGK" to "Papua Yeni Qvineya Kinası",
    "PHP" to "Filippin Pesosu",
    "PKR" to "Pakistan Rupisi",
    "PLN" to "Polşa Zlotısı",
    "PLZ" to "Polşa Zlotısı (1950–1995)",
    "PTE" to "Portuqal Eskudosu",
    "PYG" to "Paraqvay Quaranisi",
    "QAR" to "Qatar Rialı",
    "RHD" to "Rodezian Dolları",
    "ROL" to "Rumıniya Leyi (1952–2006)",
    "RON" to "Rumıniya Leyi",
    "RSD" to "Serbiya Dinarı",
    "RUB" to "Rusiya Rublu",
    "RUR" to "Rusiya Rublu (1991–1998)",
    "RWF" to "Ruanda Frankı",
    "SAR" to "Səudiyyə Riyalı",
    "SBD" to "Solomon Adaları Dolları",
    "SCR" to "Seyşel Rupisi",
    "SDG" to "Sudan Funtu",
    "SEK" to "İsveç Kronu",
    "SGD" to "Sinqapur Dolları",
    "SHP" to "Müqəddəs Yelena Funtu",
    "SIT" to "Sloveniya Toları",
    "SKK" to "Slovak Korunası",
    "SLE" to "Sierra Leon Leonu",
    "SLL" to "Sierra Leon Leonu (1964—2022)",
    "SOS" to "Somali Şillinqi",
    "SRD" to "Surinam Dolları",
    "SSP" to "Cənubi Sudan Funtu",
    "STD" to "San Tom və Prinsip Dobrası (1977–2017)",
    "STN" to "San Tom və Prinsip Dobrası",
    "SUR" to "Sovet Rublu",
    "SVC" to "El Salvador kolonu",
    "SYP" to "Suriya Funtu",
    "SZL" to "Svazilend Lilangenini",
    "THB" to "Tayland Batı",
    "TJR" to "Tacikistan Rublu",
    "TJS" to "Tacikistan Somonisi",
    "TMM" to "Türkmənistan Manatı (1993–2009)",
    "TMT" to "Türkmənistan Manatı",
    "TND" to "Tunis Dinarı",
    "TOP" to "Tonqa Panqası",
    "TPE" to "Timor Eskudu",
    "TRL" to "Türkiyə Lirəsi (1922–2005)",
    "TRY" to "Türkiyə Lirəsi",
    "TTD" to "Trinidad və Tobaqo Dolları",
    "TWD" to "Tayvan Yeni Dolları",
    "TZS" to "Tanzaniya Şillinqi",
    "UAH" to "Ukrayna Qrivnası",
    "UAK" to "Ukrayna Karbovenesası",
    "UGS" to "Uqanda Şillinqi (1966–1987)",
    "UGX" to "Uqanda Şillinqi",
    "USD" to "ABŞ Dolları",
    "USN" to "ABŞ dolları (yeni gün)",
    "USS" to "ABŞ dolları (həmin gün)",
    "UYI" to "Uruqvay pesosu Unidades Indexadas",
    "UYP" to "Uruqvay Pesosu (1975–1993)",
    "UYU" to "Uruqvay Pesosu",
    "UZS" to "Özbəkistan Somu",
    "VEB" to "Venesuela Bolivarı (1871–2008)",
    "VEF" to "Venesuela Bolivarı (2008–2018)",
    "VES" to "Venesuela Bolivarı",
    "VND" to "Vyetnam Donqu",
    "VNN" to "Vyetnam Donqu (1978–1985)",
    "VUV" to "Vanuatu Vatusu",
    "WST" to "Samoa Talası",
    "XAF" to "Kamerun Frankı",
    "XAG" to "gümüş",
    "XAU" to "qızıl",
    "XCD" to "Şərqi Karib Dolları",
    "XFO" to "Fransız Gızıl Frankı",
    "XFU" to "Fransız UİC Frankı",
    "XOF" to "Fil Dişi Sahili Frankı",
    "XPD" to "Palladium",
    "XPF" to "Fransız Polineziyası Frankı",
    "XPT" to "Platinum",
    "XXX" to "Naməlum Valyuta",
    "YDD" to "Yəmən Dinarı",
    "YER" to "Yəmən Rialı",
    "YUD" to "Yuqoslaviya Dinarı (1966–1990)",
    "YUM" to "Yuqoslaviya Yeni Dinarı (1994–2002)",
    "YUN" to "Yuqoslaviya Dinarı (1990–1992)",
    "ZAL" to "Cənubi Afrika Randı (finans)",
    "ZAR" to "Cənubi Afrika Randı",
    "ZMK" to "Zambiya Kvaçası (1968–2012)",
    "ZMW" to "Zambiya Kvaçası",
    "ZRN" to "Zair Yeni Zairi (1993–1998)",
    "ZRZ" to "Zair Zairi (1971–1993)",
    "ZWD" to "Zimbabve Dolları (1980–2008)",
    "ZWL" to "Zimbabve Dolları (2009)",
    "ZWR" to "Zimbabve Dolları (2008)",
  ) }

  val az_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val az_Arab_IQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val az_Arab_TR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val az_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val az_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andora Pesetası",
    "AED" to "Birləşmiş Ərəb Əmirlikləri Dirhəmi",
    "AFA" to "Əfqanıstan Əfqanisi (1927–2002)",
    "AFN" to "Əfqanıstan Əfqanisi",
    "ALK" to "Albaniya Leki (1946–1965)",
    "ALL" to "Albaniya Leki",
    "AMD" to "Ermənistan Dramı",
    "ANG" to "Niderland Antilyası Gilderi",
    "AOA" to "Anqola Kvanzası",
    "AOK" to "Anqola Kvanzasi (1977–1990)",
    "AON" to "Anqola Yeni Kvanzası (1990–2000)",
    "AOR" to "Anqola Kvanzası (1995–1999)",
    "ARA" to "Argentina avstralı",
    "ARP" to "Argentina pesosu (1983–1985)",
    "ARS" to "Argentina Pesosu",
    "ATS" to "Avstriya Şillinqi",
    "AUD" to "Avstraliya Dolları",
    "AWG" to "Aruba Florini",
    "AZM" to "Azərbaycan Manatı (1993–2006)",
    "AZN" to "Azərbaycan Manatı",
    "BAD" to "Bosniya-Herseqovina Dinarı",
    "BAM" to "Bosniya-Herseqovina Markası",
    "BBD" to "Barbados Dolları",
    "BDT" to "Banqladeş Takası",
    "BEC" to "Belçika Frankı (deyşirik)",
    "BEF" to "Belçika Frankı",
    "BEL" to "Belçika Frankı (finans)",
    "BGL" to "Bolqarıstan Levası",
    "BGN" to "Bolqarıstan Levi",
    "BHD" to "Bəhreyn Dinarı",
    "BIF" to "Burundi Frankı",
    "BMD" to "Bermuda Dolları",
    "BND" to "Bruney Dolları",
    "BOB" to "Boliviya Bolivianosu",
    "BOP" to "Boliviya pesosu",
    "BOV" to "Boliviya mvdolı",
    "BRB" to "Braziliya kruzeyro novası",
    "BRC" to "Braziliya kruzadosu",
    "BRE" to "Braziliya kruzeyrosu (1990–1993)",
    "BRL" to "Braziliya Realı",
    "BRN" to "Braziliya kruzado novası",
    "BRR" to "Braziliya kruzeyrosu",
    "BSD" to "Baham Dolları",
    "BTN" to "Butan Nqultrumu",
    "BUK" to "Burmis Kyatı",
    "BWP" to "Botsvana Pulası",
    "BYB" to "Belarus Yeni Rublu (1994–1999)",
    "BYN" to "Belarus Rublu",
    "BYR" to "Belarus Rublu (2000–2016)",
    "BZD" to "Beliz Dolları",
    "CAD" to "Kanada Dolları",
    "CDF" to "Konqo Frankı",
    "CHE" to "WIR Avro",
    "CHF" to "İsveçrə Frankı",
    "CHW" to "WIR Frankası",
    "CLP" to "Çili Pesosu",
    "CNH" to "Çin Yuanı (ofşor)",
    "CNY" to "Çin Yuanı",
    "COP" to "Kolumbiya Pesosu",
    "CRC" to "Kosta Rika Kolonu",
    "CSD" to "Serbiya Dinarı (2002–2006)",
    "CSK" to "Çexoslavakiya Korunası",
    "CUC" to "Kuba Çevrilən Pesosu",
    "CUP" to "Kuba Pesosu",
    "CVE" to "Kape Verde Eskudosu",
    "CYP" to "Kipr Paundu",
    "CZK" to "Çexiya Korunası",
    "DDM" to "Şərq Almaniya Ostmarkı",
    "DEM" to "Alman Markası",
    "DJF" to "Cibuti Frankı",
    "DKK" to "Danimarka Kronu",
    "DOP" to "Dominika Pesosu",
    "DZD" to "Əlcəzair Dinarı",
    "ECS" to "Ekvador Sukresi",
    "EEK" to "Estoniya Krunu",
    "EGP" to "Misir Funtu",
    "ERN" to "Eritreya Nakfası",
    "ESA" to "İspan Pesetası (A account)",
    "ESB" to "İspan Pesetası (dəyşirik)",
    "ESP" to "İspan Pesetası",
    "ETB" to "Efiopiya Bırrı",
    "EUR" to "Avro",
    "FIM" to "Fin Markası",
    "FJD" to "Fici Dolları",
    "FKP" to "Folklend Adaları Funtu",
    "FRF" to "Fransız Markası",
    "GBP" to "Britaniya Funtu",
    "GEK" to "Gürcüstan Kupon Lariti",
    "GEL" to "Gürcüstan Larisi",
    "GHC" to "Qana Sedisi (1979–2007)",
    "GHS" to "Qana Sedisi",
    "GIP" to "Cəbəli-Tariq Funtu",
    "GMD" to "Qambiya Dalasisi",
    "GNF" to "Qvineya Frankı",
    "GNS" to "Qvineya Sulisi",
    "GQE" to "Ekvatoriya Gvineya Ekvele Quneanası",
    "GRD" to "Yunan Draçması",
    "GTQ" to "Qvatemala Küetzalı",
    "GWE" to "Portugal Qvineya Eskudosu",
    "GWP" to "Qvineya-Bisau Pesosu",
    "GYD" to "Qayana Dolları",
    "HKD" to "Honq Konq Dolları",
    "HNL" to "Honduras Lempirası",
    "HRD" to "Xorvatiya Dinarı",
    "HRK" to "Xorvatiya Kunası",
    "HTG" to "Haiti Qourdu",
    "HUF" to "Macarıstan Forinti",
    "IDR" to "İndoneziya Rupisi",
    "IEP" to "İrlandiya Paundu",
    "ILP" to "İzrail Paundu",
    "ILR" to "İsrail Şekeli (1980–1985)",
    "ILS" to "İsrail Yeni Şekeli",
    "INR" to "Hindistan Rupisi",
    "IQD" to "İraq Dinarı",
    "IRR" to "İran Rialı",
    "ISJ" to "İslandiya Kronu (1918–1981)",
    "ISK" to "İslandiya Kronu",
    "ITL" to "İtaliya Lirası",
    "JMD" to "Yamayka Dolları",
    "JOD" to "İordaniya Dinarı",
    "JPY" to "Yaponiya Yeni",
    "KES" to "Keniya Şillinqi",
    "KGS" to "Qırğızıstan Somu",
    "KHR" to "Kamboca Rieli",
    "KMF" to "Komor Frankı",
    "KPW" to "Şimali Koreya Vonu",
    "KRW" to "Cənubi Koreya Vonu",
    "KWD" to "Küveyt Dinarı",
    "KYD" to "Kayman Adaları Dolları",
    "KZT" to "Qazaxıstan Tengesi",
    "LAK" to "Laos Kipi",
    "LBP" to "Livan Funtu",
    "LKR" to "Şri Lanka Rupisi",
    "LRD" to "Liberiya Dolları",
    "LSL" to "Lesoto Lotisi",
    "LTL" to "Litva Liti",
    "LTT" to "Litva Talonası",
    "LUC" to "Luksemburq Frankası (dəyişik)",
    "LUF" to "Luksemburq Frankası",
    "LUL" to "Luksemburq Frankası (finans)",
    "LVL" to "Latviya Latı",
    "LVR" to "Latviya Rublu",
    "LYD" to "Liviya Dinarı",
    "MAD" to "Mərakeş Dirhəmi",
    "MAF" to "Mərakeş Frankası",
    "MDL" to "Moldova Leyi",
    "MGA" to "Madaqaskar Ariarisi",
    "MGF" to "Madaqaskar Frankası",
    "MKD" to "Makedoniya Dinarı",
    "MKN" to "Makedoniya Dinarı (1992–1993)",
    "MLF" to "Mali Frankı",
    "MMK" to "Myanma Kiyatı",
    "MNT" to "Monqoliya Tuqriki",
    "MOP" to "Makao Patakası",
    "MRO" to "Mavritaniya Ugiyası (1973–2017)",
    "MRU" to "Mavritaniya Ugiyası",
    "MTP" to "Maltiz Paundu",
    "MUR" to "Mavriki Rupisi",
    "MVR" to "Maldiv Rufiyası",
    "MWK" to "Malavi Kvaçası",
    "MXN" to "Meksika Pesosu",
    "MXP" to "Meksika gümüş pesosu",
    "MYR" to "Malayziya Ringiti",
    "MZE" to "Mozambik Eskudosu",
    "MZM" to "Mozambik Metikalı (1980–2006)",
    "MZN" to "Mozambik Metikalı",
    "NAD" to "Namibiya Dolları",
    "NGN" to "Nigeriya Nairası",
    "NIC" to "Nikaraqua kordobu",
    "NIO" to "Nikaraqua Kordobası",
    "NLG" to "Hollandiya Gilderi",
    "NOK" to "Norveç Kronu",
    "NPR" to "Nepal Rupisi",
    "NZD" to "Yeni Zelandiya Dolları",
    "OMR" to "Oman Rialı",
    "PAB" to "Panama Balboası",
    "PEI" to "Peru Inti",
    "PEN" to "Peru Solu",
    "PES" to "Peru Solu (1863–1965)",
    "PGK" to "Papua Yeni Qvineya Kinası",
    "PHP" to "Filippin Pesosu",
    "PKR" to "Pakistan Rupisi",
    "PLN" to "Polşa Zlotısı",
    "PLZ" to "Polşa Zlotısı (1950–1995)",
    "PTE" to "Portuqal Eskudosu",
    "PYG" to "Paraqvay Quaranisi",
    "QAR" to "Qatar Rialı",
    "RHD" to "Rodezian Dolları",
    "ROL" to "Rumıniya Leyi (1952–2006)",
    "RON" to "Rumıniya Leyi",
    "RSD" to "Serbiya Dinarı",
    "RUB" to "Rusiya Rublu",
    "RUR" to "Rusiya Rublu (1991–1998)",
    "RWF" to "Ruanda Frankı",
    "SAR" to "Səudiyyə Riyalı",
    "SBD" to "Solomon Adaları Dolları",
    "SCR" to "Seyşel Rupisi",
    "SDG" to "Sudan Funtu",
    "SEK" to "İsveç Kronu",
    "SGD" to "Sinqapur Dolları",
    "SHP" to "Müqəddəs Yelena Funtu",
    "SIT" to "Sloveniya Toları",
    "SKK" to "Slovak Korunası",
    "SLE" to "Sierra Leon Leonu",
    "SLL" to "Sierra Leon Leonu (1964—2022)",
    "SOS" to "Somali Şillinqi",
    "SRD" to "Surinam Dolları",
    "SSP" to "Cənubi Sudan Funtu",
    "STD" to "San Tom və Prinsip Dobrası (1977–2017)",
    "STN" to "San Tom və Prinsip Dobrası",
    "SUR" to "Sovet Rublu",
    "SVC" to "El Salvador kolonu",
    "SYP" to "Suriya Funtu",
    "SZL" to "Svazilend Lilangenini",
    "THB" to "Tayland Batı",
    "TJR" to "Tacikistan Rublu",
    "TJS" to "Tacikistan Somonisi",
    "TMM" to "Türkmənistan Manatı (1993–2009)",
    "TMT" to "Türkmənistan Manatı",
    "TND" to "Tunis Dinarı",
    "TOP" to "Tonqa Panqası",
    "TPE" to "Timor Eskudu",
    "TRL" to "Türkiyə Lirəsi (1922–2005)",
    "TRY" to "Türkiyə Lirəsi",
    "TTD" to "Trinidad və Tobaqo Dolları",
    "TWD" to "Tayvan Yeni Dolları",
    "TZS" to "Tanzaniya Şillinqi",
    "UAH" to "Ukrayna Qrivnası",
    "UAK" to "Ukrayna Karbovenesası",
    "UGS" to "Uqanda Şillinqi (1966–1987)",
    "UGX" to "Uqanda Şillinqi",
    "USD" to "ABŞ Dolları",
    "USN" to "ABŞ dolları (yeni gün)",
    "USS" to "ABŞ dolları (həmin gün)",
    "UYI" to "Uruqvay pesosu Unidades Indexadas",
    "UYP" to "Uruqvay Pesosu (1975–1993)",
    "UYU" to "Uruqvay Pesosu",
    "UZS" to "Özbəkistan Somu",
    "VEB" to "Venesuela Bolivarı (1871–2008)",
    "VEF" to "Venesuela Bolivarı (2008–2018)",
    "VES" to "Venesuela Bolivarı",
    "VND" to "Vyetnam Donqu",
    "VNN" to "Vyetnam Donqu (1978–1985)",
    "VUV" to "Vanuatu Vatusu",
    "WST" to "Samoa Talası",
    "XAF" to "Kamerun Frankı",
    "XAG" to "gümüş",
    "XAU" to "qızıl",
    "XCD" to "Şərqi Karib Dolları",
    "XFO" to "Fransız Gızıl Frankı",
    "XFU" to "Fransız UİC Frankı",
    "XOF" to "Fil Dişi Sahili Frankı",
    "XPD" to "Palladium",
    "XPF" to "Fransız Polineziyası Frankı",
    "XPT" to "Platinum",
    "XXX" to "Naməlum Valyuta",
    "YDD" to "Yəmən Dinarı",
    "YER" to "Yəmən Rialı",
    "YUD" to "Yuqoslaviya Dinarı (1966–1990)",
    "YUM" to "Yuqoslaviya Yeni Dinarı (1994–2002)",
    "YUN" to "Yuqoslaviya Dinarı (1990–1992)",
    "ZAL" to "Cənubi Afrika Randı (finans)",
    "ZAR" to "Cənubi Afrika Randı",
    "ZMK" to "Zambiya Kvaçası (1968–2012)",
    "ZMW" to "Zambiya Kvaçası",
    "ZRN" to "Zair Yeni Zairi (1993–1998)",
    "ZRZ" to "Zair Zairi (1971–1993)",
    "ZWD" to "Zimbabve Dolları (1980–2008)",
    "ZWL" to "Zimbabve Dolları (2009)",
    "ZWR" to "Zimbabve Dolları (2008)",
  ) }

  val ba: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bal: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bal_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bal_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Emáráti Darham",
    "AFN" to "Awgáni Awgáni",
    "ALL" to "Albániái Lek",
    "AMD" to "Árminiái Dram",
    "ANG" to "Nedarlándi Antilli Gelder",
    "AOA" to "Angólái Kwanzá",
    "ARS" to "Arjentinái Paysó",
    "AUD" to "Ástráliái Dhálar",
    "AWG" to "Arubi Flórin",
    "AZN" to "Ázerbáijáni Manat",
    "BAM" to "Bósniá-Herzigówinái Badali Mark",
    "BBD" to "Barbadi Dhálar",
    "BDT" to "Bangaladéshi Thakká",
    "BGN" to "Bulgáriái Lew",
    "BHD" to "Bahreni Dinár",
    "BIF" to "Burundi Fránk",
    "BMD" to "Bermudá Dhálar",
    "BND" to "Brunái Dhálar",
    "BOB" to "Boliwiái Boliwiánó",
    "BRL" to "Brázili riál",
    "BSD" to "Bahami Dhálar",
    "BTN" to "Butháni Ngultrum",
    "BWP" to "Botswánái Pulá",
    "BYN" to "Bélárusi Rubel",
    "BZD" to "Belizé Dhálar",
    "CAD" to "Kaynadhái Dhálar",
    "CDF" to "Kángói Fránk",
    "CHF" to "Swizi Fránk",
    "CLP" to "Chilayi Paysó",
    "CNH" to "Chini Yuán (Ápshór)",
    "CNY" to "Chini Yuán",
    "COP" to "Kolambiái Paysó",
    "CRC" to "Kóstá Rikái Kolón",
    "CUC" to "Kyubái Badali Paysó",
    "CUP" to "Kyubái Paysó",
    "CVE" to "Kayp Werdi Eskudó",
    "CZK" to "Chek Koruná",
    "DJF" to "Djebuti Fránk",
    "DKK" to "Danmárki Koron",
    "DOP" to "Dominiki Paysó",
    "DZD" to "Aljiriái Dinár",
    "EGP" to "Mesri Pawndh",
    "ERN" to "Eritiriái Nakfá",
    "ETB" to "Etiupiái Birr",
    "EUR" to "Yuró",
    "FJD" to "Fiji Dhálar",
    "FKP" to "Fálklánd Islándi Pawndh",
    "GBP" to "Bartáni pawndh",
    "GEL" to "Járjiái Lari",
    "GHS" to "Gánái Sédi",
    "GIP" to "Gibraltar Pawndh",
    "GMD" to "Gambiái Dalasi",
    "GNF" to "Gwiniái Fránk",
    "GTQ" to "Gwátemálái Kwetzal",
    "GYD" to "Góyánái Dhálar",
    "HKD" to "Háng Káng Dhálar",
    "HNL" to "Hondurái Lempirá",
    "HRK" to "Króáshiái Kuná",
    "HTG" to "Haiti Gurde",
    "HUF" to "Hungáriái Forint",
    "IDR" to "Endhónishiái Rupiá",
    "ILS" to "Esráili Nókén Shekel",
    "INR" to "Hendostáni Rupi",
    "IQD" to "Eráki Dinár",
    "IRR" to "Éráni Ryál",
    "ISK" to "Isláni Króná",
    "JMD" to "Jamáiki Dhálar",
    "JOD" to "Ordoni Dinár",
    "JPY" to "Jápáni Yen",
    "KES" to "Kinyái Shilling",
    "KGS" to "Kargestáni Som",
    "KHR" to "Kambódhiái Riél",
    "KMF" to "Komóriái Éránk",
    "KPW" to "Shemáli Kóriái Won",
    "KRW" to "Zerbári Kóriái Won",
    "KWD" to "Kwayti Dinár",
    "KYD" to "Kayman Islándi Dhálar",
    "KZT" to "Kázakestáni Tengé",
    "LAK" to "Laótiái Kip",
    "LBP" to "Lebnáni Pawndh",
    "LKR" to "Sri Lankái Rupi",
    "LRD" to "Láibiriái Dhálar",
    "LSL" to "Lesótó Lóti",
    "LYD" to "Libyái Dinár",
    "MAD" to "Mórokói Darham",
    "MDL" to "Moldówi Leu",
    "MGA" to "Malagasi Ariári",
    "MKD" to "Makduniái Dinár",
    "MMK" to "Myanmár Kyát",
    "MNT" to "Mongóliái Tugrik",
    "MOP" to "Makani Pataká",
    "MRU" to "Mauritániái Ugwiyá",
    "MUR" to "Muritániái Rupi",
    "MVR" to "Máldipi Rupiyá",
    "MWK" to "Malawi Kwachá",
    "MXN" to "Meksikói Paysó",
    "MYR" to "Malishiái Ringgit",
    "MZN" to "Mózambiki Metikal",
    "NAD" to "Namibiái Dhálar",
    "NGN" to "Náijiriái Nairá",
    "NIO" to "Nikárágóái Kordobá",
    "NOK" to "Nárwéji Koron",
    "NPR" to "Népáli Rupi",
    "NZD" to "Nyu Zilánd Dhálar",
    "OMR" to "Ománi Riál",
    "PAB" to "Panamániái Balbóá",
    "PEN" to "Péruwi Sól",
    "PGK" to "Pápuá Nyu Gwini Kiná",
    "PHP" to "Pelpini Paysó",
    "PKR" to "Pákestáni Rupi",
    "PLN" to "Pólándi Zlóti",
    "PYG" to "Payráguyái Gwarani",
    "QAR" to "Gatari Riál",
    "RON" to "Rumániái Leu",
    "RSD" to "Sarbiái Dinár",
    "RUB" to "Rusi Rubel",
    "RWF" to "Rwándái Fránk",
    "SAR" to "Saudi Riál",
    "SBD" to "Solomán Islánd Dhálar",
    "SCR" to "Seychelli Rupi",
    "SDG" to "Sudáni Pawndh",
    "SEK" to "Swidi Koron",
    "SGD" to "Singápur Dhálar",
    "SHP" to "St. Helénái Pawndh",
    "SLE" to "Siérá Leóni León",
    "SLL" to "Siérá Leóni León (1964—2022)",
    "SOS" to "Sómáli Shilling",
    "SRD" to "Surinami Dhálar",
    "SSP" to "Zerbári Sudáni Pawndh",
    "STN" to "Sáó Tómé o Prensip Dobrá",
    "SYP" to "Suriái Pawndh",
    "SZL" to "Swázi Lilangeni",
    "THB" to "Tái Baht",
    "TJS" to "Tájekestáni Somoni",
    "TMT" to "TRKM",
    "TND" to "Tunisi Dinár",
    "TOP" to "Tongan Pángá",
    "TRY" to "Torki Lirá",
    "TTD" to "Trinidadi o Tobagó Dhálar",
    "TWD" to "Nyu Táiwán Dhálar",
    "TZS" to "Tanzániái Shilling",
    "UAH" to "Yukrayni Hriwniá",
    "UGX" to "Yugandhái Shilling",
    "USD" to "Amriki dhálar",
    "UYU" to "Yurógóyái Paysó",
    "UZS" to "Ozbekestáni Som",
    "VES" to "Wénezwélái Boliwar",
    "VND" to "Wietnámi Dong",
    "VUV" to "Wanuátu Wátu",
    "WST" to "Samóan Talá",
    "XAF" to "Delgáhi Aprikái CFA Fránk",
    "XCD" to "Ródarátki Karibiái Dhálar",
    "XOF" to "Rónendi Aprikái CFA Fránk",
    "XPF" to "CFP Fránk",
    "XXX" to "Nazántagén Zarr",
    "YER" to "Yamani Riál",
    "ZAR" to "Zerbári Aprikái Rand",
    "ZMW" to "Zambiái Kwachá",
  ) }

  val bas: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirhàm èmìrâ",
    "AOA" to "Kwànza àŋgolà",
    "AUD" to "Dɔ̀lâr òstralìà",
    "BHD" to "Dinâr Bàraìn",
    "BIF" to "Frǎŋ bùrundì",
    "BWP" to "Pùla Bòtswanà",
    "CAD" to "Dɔ̀lâr kànadà",
    "CDF" to "Frǎŋ kòŋgo",
    "CHF" to "Frǎŋ sùwîs",
    "CNY" to "Yùan kinà",
    "CVE" to "Èskudò kabwe᷆r",
    "DJF" to "Frǎŋ jìbutì",
    "DZD" to "Dìnâr àlgerìà",
    "EGP" to "Paùnd ègîptò",
    "ERN" to "Nafkà èrìtrěà",
    "ETB" to "Bîr ètìopìà",
    "EUR" to "Èrô",
    "GBP" to "Stɛrlìŋ ŋgìsì",
    "GHC" to "Sèdi gānà",
    "GMD" to "Dalasì gambìà",
    "GNS" to "Frǎŋ gìnê",
    "INR" to "Rùpi īndìà",
    "JPY" to "Yɛ̂n yàpân",
    "KES" to "Silîŋ kenìà",
    "KMF" to "Frǎŋ kòmorà",
    "LRD" to "Dɔ̀lâr lìberìà",
    "LSL" to "Lotì lèsòtò",
    "LYD" to "Dìnâr libìà",
    "MAD" to "Dìrham màrôk",
    "MGA" to "Frǎŋ màlàgasì",
    "MRO" to "Ùgwiya mòrìtanìa (1973–2017)",
    "MRU" to "Ùgwiya mòrìtanìa",
    "MUR" to "Rupìɛ̀ mòrîs",
    "MWK" to "Kwaca màlawì",
    "MZM" to "Mètìkal mòsàmbîk",
    "NAD" to "Dɔ̀lâr nàmibìà",
    "NGN" to "Nayrà nìgerìà",
    "RWF" to "Frǎŋ Rùandà",
    "SAR" to "Rìal sàudì",
    "SCR" to "Rùpiɛ̀ sèsɛ̂l",
    "SDG" to "Dìnâr sùdân",
    "SDP" to "Paùnd sùdân",
    "SHP" to "Paùnd hèlenà",
    "SLE" to "Lèonɛ̀",
    "SLL" to "Lèonɛ̀ (1964—2022)",
    "SOS" to "Silîŋ sòmàli",
    "STD" to "Dobrà sàotòme (1977–2017)",
    "STN" to "Dobrà sàotòme",
    "SZL" to "Lìlàŋgeni swàzì",
    "TND" to "Dìnâr tùnîs",
    "TZS" to "Silîŋ tànzànià",
    "UGX" to "Silîŋ ùgàndà",
    "USD" to "Dɔla àmerkà",
    "XAF" to "Frǎŋ CFA (BEAC)",
    "XOF" to "Frǎŋ CFA (BCEAO)",
    "ZAR" to "Rân àfrǐkàsɔ̀",
    "ZMK" to "Kwàca sàmbià (1968–2012)",
    "ZMW" to "Kwàca sàmbià",
    "ZWD" to "Dɔ̀lâr sìmbàbwê",
  ) }

  val be: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "дырхам ААЭ",
    "AFN" to "афганскі афгані",
    "ALL" to "албанскі лек",
    "AMD" to "армянскі драм",
    "ANG" to "нідэрландскі антыльскі гульдэн",
    "AOA" to "ангольская кванза",
    "ARS" to "аргенцінскае песа",
    "AUD" to "аўстралійскі долар",
    "AWG" to "арубанскі фларын",
    "AZN" to "азербайджанскі манат",
    "BAM" to "канверсоўная марка Босніі і Герцагавіны",
    "BBD" to "барбадаскі долар",
    "BDT" to "бангладэшская така",
    "BGN" to "балгарскі леў",
    "BHD" to "бахрэйнскі дынар",
    "BIF" to "бурундзійскі франк",
    "BMD" to "бермудскі долар",
    "BND" to "брунейскі долар",
    "BOB" to "балівіяна",
    "BRL" to "бразільскі рэал",
    "BSD" to "багамскі долар",
    "BTN" to "бутанскі нгултрум",
    "BWP" to "батсванская пула",
    "BYN" to "беларускі рубель",
    "BYR" to "беларускі рубель (2000–2016)",
    "BZD" to "белізскі долар",
    "CAD" to "канадскі долар",
    "CDF" to "кангалезскі франк",
    "CHF" to "швейцарскі франк",
    "CLP" to "чылійскае песа",
    "CNH" to "афшорны кітайскі юань",
    "CNY" to "кітайскі юань",
    "COP" to "калумбійскае песа",
    "CRC" to "коста-рыканскі калон",
    "CUC" to "кубінскае канверсоўнае песа",
    "CUP" to "кубінскае песа",
    "CVE" to "эскуда Каба-Вердэ",
    "CZK" to "чэшская крона",
    "DJF" to "джыбуційскі франк",
    "DKK" to "дацкая крона",
    "DOP" to "дамініканскае песа",
    "DZD" to "алжырскі дынар",
    "EGP" to "егіпецкі фунт",
    "ERN" to "эрытрэйская накфа",
    "ETB" to "эфіопскі быр",
    "EUR" to "еўра",
    "FJD" to "фіджыйскі долар",
    "FKP" to "фунт Фалклендскіх астравоў",
    "GBP" to "брытанскі фунт стэрлінгаў",
    "GEL" to "грузінскі лары",
    "GHS" to "ганскі седзі",
    "GIP" to "гібралтарскі фунт",
    "GMD" to "гамбійскі даласі",
    "GNF" to "гвінейскі франк",
    "GTQ" to "гватэмальскі кетсаль",
    "GYD" to "гаянскі долар",
    "HKD" to "ганконгскі долар",
    "HNL" to "гандураская лемпіра",
    "HRK" to "харвацкая куна",
    "HTG" to "гаіцянскі гурд",
    "HUF" to "венгерскі форынт",
    "IDR" to "інданезійская рупія",
    "ILS" to "новы ізраільскі шэкель",
    "INR" to "індыйская рупія",
    "IQD" to "іракскі дынар",
    "IRR" to "іранскі рыял",
    "ISK" to "ісландская крона",
    "JMD" to "ямайскі долар",
    "JOD" to "іарданскі дынар",
    "JPY" to "японская іена",
    "KES" to "кенійскі шылінг",
    "KGS" to "кіргізскі сом",
    "KHR" to "камбаджыйскі рыель",
    "KMF" to "каморскі франк",
    "KPW" to "паўночнакарэйская вона",
    "KRW" to "паўднёвакарэйская вона",
    "KWD" to "кувейцкі дынар",
    "KYD" to "долар Кайманавых астравоў",
    "KZT" to "казахстанскі тэнге",
    "LAK" to "лаоскі кіп",
    "LBP" to "ліванскі фунт",
    "LKR" to "шры-ланкійская рупія",
    "LRD" to "ліберыйскі долар",
    "LSL" to "лесоцкі лоці",
    "LYD" to "лівійскі дынар",
    "MAD" to "мараканскі дырхам",
    "MDL" to "малдаўскі лей",
    "MGA" to "малагасійскі арыяры",
    "MKD" to "македонскі дэнар",
    "MMK" to "м’янманскі к’ят",
    "MNT" to "мангольскі тугрык",
    "MOP" to "патака Макаа",
    "MRO" to "маўрытанская ўгія (1973–2017)",
    "MRU" to "маўрытанская угія",
    "MUR" to "маўрыкійская рупія",
    "MVR" to "мальдыўская руфія",
    "MWK" to "малавійская квача",
    "MXN" to "мексіканскае песа",
    "MYR" to "малайзійскі рынгіт",
    "MZN" to "мазамбікскі метыкал",
    "NAD" to "намібійскі долар",
    "NGN" to "нігерыйская наіра",
    "NIO" to "нікарагуанская кордаба",
    "NOK" to "нарвежская крона",
    "NPR" to "непальская рупія",
    "NZD" to "новазеландскі долар",
    "OMR" to "аманскі рыял",
    "PAB" to "панамскае бальбоа",
    "PEN" to "перуанскі соль",
    "PGK" to "кіна Папуа-Новай Гвінеі",
    "PHP" to "філіпінскае песа",
    "PKR" to "пакістанская рупія",
    "PLN" to "польскі злоты",
    "PYG" to "парагвайскі гуарані",
    "QAR" to "катарскі рыял",
    "RON" to "румынскі лей",
    "RSD" to "сербскі дынар",
    "RUB" to "расійскі рубель",
    "RWF" to "руандыйскі франк",
    "SAR" to "саудаўскі рыял",
    "SBD" to "долар Саламонавых астравоў",
    "SCR" to "сейшэльская рупія",
    "SDG" to "суданскі фунт",
    "SEK" to "шведская крона",
    "SGD" to "сінгапурскі долар",
    "SHP" to "фунт в-ва Святой Алены",
    "SLE" to "сьера-леонскі леонэ",
    "SLL" to "сьера-леонскі леонэ (1964—2022)",
    "SOS" to "самалійскі шылінг",
    "SRD" to "сурынамскі долар",
    "SSP" to "паўднёвасуданскі фунт",
    "STD" to "добра Сан-Тамэ і Прынсіпі (1977–2017)",
    "STN" to "добра Сан-Тамэ і Прынсіпі",
    "SYP" to "сірыйскі фунт",
    "SZL" to "свазілендскі лілангені",
    "THB" to "тайскі бат",
    "TJS" to "таджыкскі самані",
    "TMT" to "туркменскі манат",
    "TND" to "туніскі дынар",
    "TOP" to "танганская паанга",
    "TRY" to "турэцкая ліра",
    "TTD" to "долар Трынідада і Табага",
    "TWD" to "новы тайваньскі долар",
    "TZS" to "танзанійскі шылінг",
    "UAH" to "украінская грыўня",
    "UGX" to "угандыйскі шылінг",
    "USD" to "долар ЗША",
    "UYU" to "уругвайскае песа",
    "UZS" to "узбекскі сум",
    "VEF" to "венесуальскі балівар (2008–2018)",
    "VES" to "венесуэльскі балівар",
    "VND" to "в’етнамскі донг",
    "VUV" to "вануацкі вату",
    "WST" to "самаанская тала",
    "XAF" to "цэнтральнаафрыканскі франк КФА",
    "XCD" to "усходнекарыбскі долар",
    "XOF" to "заходнеафрыканскі франк КФА",
    "XPF" to "французскі ціхаакіянскі франк",
    "XXX" to "невядомая валюта",
    "YER" to "еменскі рыал",
    "ZAR" to "паўднёваафрыканскі рэнд",
    "ZMW" to "замбійская квача",
  ) }

  val be_tarask: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bem: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bew: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bez: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Lupila lwa Hufalme dza Huhihalabu",
    "AOA" to "Lupila lwa Huangola",
    "AUD" to "Lupila lwa Huaustlalia",
    "BHD" to "Lupila lwa Hubahareni",
    "BIF" to "Lupila lwa Huburundi",
    "BWP" to "Lupila lwa Hubotswana",
    "CAD" to "Lupila lwa Hukanada",
    "CDF" to "Lupila lwa Hukongo",
    "CHF" to "Lupila lwa Huuswisi",
    "CNY" to "Lupila lwa Huchina",
    "CVE" to "Lupila lwa Hukepuvede",
    "DJF" to "Lupila lwa Hujibuti",
    "DZD" to "Lupila lwa Hualjelia",
    "EGP" to "Lupila lwa Humisri",
    "ERN" to "Lupila lwa Hueritrea",
    "ETB" to "Lupila lwa Huuhabeshi",
    "EUR" to "Lupila lwa Yulo",
    "GBP" to "Lupila lwa Huuingereza",
    "GHC" to "Lupila lwa Hughana",
    "GMD" to "Lupila lwa Hugambia",
    "GNS" to "Lupila lwa Hujine",
    "INR" to "Lupila lwa Huindia",
    "JPY" to "Lupila lwa Hijapani",
    "KES" to "Shilingi ya Hukenya",
    "KMF" to "Lupila lwa Hukomoro",
    "LRD" to "Lupila lwa Hulibelia",
    "LSL" to "Lupila lwa Hulesoto",
    "LYD" to "Lupila lwa Hulibya",
    "MAD" to "Lupila lwa Humoloko",
    "MGA" to "Lupila lwa Hubukini",
    "MRO" to "Lupila lwa Humolitania (1973–2017)",
    "MRU" to "Lupila lwa Humolitania",
    "MUR" to "Lupila lwa Humolisi",
    "MWK" to "Lupila lwa Humalawi",
    "MZM" to "Lupila lwa Humsumbiji",
    "NAD" to "Lupila lwa Hunamibia",
    "NGN" to "Lupila lwa Hunijelia",
    "RWF" to "Lupila lwa Hurwanda",
    "SAR" to "Lupila lwa Husaudi",
    "SCR" to "Lupila lwa Hushelisheli",
    "SDG" to "Lupila lwa Husudani",
    "SHP" to "Lupila lwa Husantahelena",
    "SLE" to "Lupila lwa Lioni",
    "SLL" to "Lupila lwa Lioni (1964—2022)",
    "SOS" to "Lupila lwa Husomalia",
    "STD" to "Lupila lwa Husaotome na Huprinisipe (1977–2017)",
    "STN" to "Lupila lwa Husaotome na Huprinisipe",
    "SZL" to "Lupila lwa Lilangeni",
    "TND" to "Lupila lwa Hutunisia",
    "TZS" to "Shilingi ya Hutanzania",
    "UGX" to "Shilingi ya Huuganda",
    "USD" to "Lupila lwa Humalekani",
    "XAF" to "Lupila lwa CFA BEAC",
    "XOF" to "Lupila lwa CFA BCEAO",
    "ZAR" to "Lupila lwa Huafriaka ya Hukusini",
    "ZMK" to "Lupila lwa Huzambia (1968–2012)",
    "ZMW" to "Lupila lwa Huzambia",
    "ZWD" to "Lupila lwa Huzimbabwe",
  ) }

  val bg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Андорска песета",
    "AED" to "Дирхам на Обединените арабски емирства",
    "AFA" to "Афганистански афган (1927–2002)",
    "AFN" to "Афганистански афган",
    "ALL" to "Албански лек",
    "AMD" to "Арменски драм",
    "ANG" to "Антилски гулден",
    "AOA" to "Анголска кванза",
    "AOK" to "Анголска кванца (1977–1990)",
    "AON" to "Анголска нова кванца (1990–2000)",
    "AOR" to "Анголска нова кванца (1995–1999)",
    "ARA" to "Аржентински австрал",
    "ARP" to "Аржентинско песо (1983–1985)",
    "ARS" to "Аржентинско песо",
    "ATS" to "Австрийски шилинг",
    "AUD" to "Австралийски долар",
    "AWG" to "Арубски флорин",
    "AZM" to "Азербайджански манат (1993–2006)",
    "AZN" to "Азербайджански манат",
    "BAD" to "Босна и Херцеговина-динар",
    "BAM" to "Босненска конвертируема марка",
    "BBD" to "Барбадоски долар",
    "BDT" to "Бангладешка така",
    "BEC" to "Белгийски франк (конвертируем)",
    "BEF" to "Белгийски франк",
    "BEL" to "Белгийски франк (финансов)",
    "BGL" to "Български конвертируем лев (1962–1999)",
    "BGN" to "Български лев",
    "BHD" to "Бахрейнски динар",
    "BIF" to "Бурундийски франк",
    "BMD" to "Бермудски долар",
    "BND" to "Брунейски долар",
    "BOB" to "Боливийско боливиано",
    "BOP" to "Боливийско песо",
    "BOV" to "Боливийски мвдол",
    "BRB" to "Бразилско ново крузейро (1967–1986)",
    "BRC" to "Бразилско крозадо",
    "BRE" to "Бразилско крузейро (1990–1993)",
    "BRL" to "Бразилски реал",
    "BRN" to "Бразилско ново крозадо",
    "BRR" to "Бразилско крузейро",
    "BSD" to "Бахамски долар",
    "BTN" to "Бутански нгултрум",
    "BUK" to "Бирмански киат",
    "BWP" to "Ботсванска пула",
    "BYB" to "Беларуска нова рубла (1994–1999)",
    "BYN" to "Беларуска рубла",
    "BYR" to "Беларуска рубла (2000–2016)",
    "BZD" to "Белизийски долар",
    "CAD" to "Канадски долар",
    "CDF" to "Конгоански франк",
    "CHE" to "WIR евро",
    "CHF" to "Швейцарски франк",
    "CHW" to "WIR франк",
    "CLF" to "Условна разчетна единица на Чили",
    "CLP" to "Чилийско песо",
    "CNH" to "Китайски юан (офшорен)",
    "CNY" to "Китайски юан",
    "COP" to "Колумбийско песо",
    "COU" to "Колумбийска единица на реалната стойност",
    "CRC" to "Костарикански колон",
    "CSD" to "Стар сръбски динар",
    "CSK" to "Чехословашка конвертируема крона",
    "CUC" to "Кубинско конвертируемо песо",
    "CUP" to "Кубинско песо",
    "CVE" to "Ескудо на Кабо Верде",
    "CYP" to "Кипърска лира",
    "CZK" to "Чешка крона",
    "DDM" to "Източногерманска марка",
    "DEM" to "Германска марка",
    "DJF" to "Джибутски франк",
    "DKK" to "Датска крона",
    "DOP" to "Доминиканско песо",
    "DZD" to "Алжирски динар",
    "ECS" to "Еквадорско сукре",
    "ECV" to "Еквадорска банкова единица",
    "EEK" to "Естонска крона",
    "EGP" to "Египетска лира",
    "ERN" to "Еритрейска накфа",
    "ESP" to "Испанска песета",
    "ETB" to "Етиопски бир",
    "EUR" to "Евро",
    "FIM" to "Финландска марка",
    "FJD" to "Фиджийски долар",
    "FKP" to "Фолкландска лира",
    "FRF" to "Френски франк",
    "GBP" to "Британска лира",
    "GEK" to "Грузински купон",
    "GEL" to "Грузински лари",
    "GHC" to "Ганайско седи (1979–2007)",
    "GHS" to "Ганайско седи",
    "GIP" to "Гибралтарска лира",
    "GMD" to "Гамбийско даласи",
    "GNF" to "Гвинейски франк",
    "GNS" to "Гвинейска сили",
    "GQE" to "Екваториално гвинейско еквеле",
    "GRD" to "Гръцка драхма",
    "GTQ" to "Гватемалски кетцал",
    "GWE" to "Ескудо от Португалска Гвинея",
    "GWP" to "Гвинея-Бисау песо",
    "GYD" to "Гаянски долар",
    "HKD" to "Хонконгски долар",
    "HNL" to "Хондураска лемпира",
    "HRD" to "Хърватски динар",
    "HRK" to "Хърватска куна",
    "HTG" to "Хаитски гурд",
    "HUF" to "Унгарски форинт",
    "IDR" to "Индонезийска рупия",
    "IEP" to "Ирландска лира",
    "ILP" to "Израелска лира",
    "ILS" to "Израелски нов шекел",
    "INR" to "Индийска рупия",
    "IQD" to "Иракски динар",
    "IRR" to "Ирански риал",
    "ISK" to "Исландска крона",
    "ITL" to "Италианска лира",
    "JMD" to "Ямайски долар",
    "JOD" to "Йордански динар",
    "JPY" to "Японска йена",
    "KES" to "Кенийски шилинг",
    "KGS" to "Киргизстански сом",
    "KHR" to "Камбоджански риел",
    "KMF" to "Коморски франк",
    "KPW" to "Севернокорейски вон",
    "KRW" to "Южнокорейски вон",
    "KWD" to "Кувейтски динар",
    "KYD" to "Кайманов долар",
    "KZT" to "Казахстанско тенге",
    "LAK" to "Лаоски кип",
    "LBP" to "Ливанска лира",
    "LKR" to "Шриланкска рупия",
    "LRD" to "Либерийски долар",
    "LSL" to "Лесотско лоти",
    "LTL" to "Литовски литас",
    "LTT" to "Литовски талон",
    "LUF" to "Люксембургски франк",
    "LVL" to "Латвийски лат",
    "LVR" to "Латвийска рубла",
    "LYD" to "Либийски динар",
    "MAD" to "Марокански дирхам",
    "MAF" to "Марокански франк",
    "MDL" to "Молдовска лея",
    "MGA" to "Малгашко ариари",
    "MGF" to "Малгашки франк - Мадагаскар",
    "MKD" to "Македонски денар",
    "MLF" to "Малийски франк",
    "MMK" to "Мианмарски киат",
    "MNT" to "Монголски тугрик",
    "MOP" to "Патака на Макао",
    "MRO" to "Мавританска угия (1973–2017)",
    "MRU" to "Мавританска угия",
    "MTL" to "Малтийска лира",
    "MUR" to "Маврицийска рупия",
    "MVR" to "Малдивска руфия",
    "MWK" to "Малавийска куача",
    "MXN" to "Мексиканско песо",
    "MXP" to "Мексиканско сребърно песо (1861–1992)",
    "MXV" to "Мексиканска конвертируема единица (UDI)",
    "MYR" to "Малайзийски рингит",
    "MZE" to "Мозамбикско ескудо",
    "MZM" to "Мозамбикски метикал (1980–2006)",
    "MZN" to "Мозамбикски метикал",
    "NAD" to "Намибийски долар",
    "NGN" to "Нигерийска найра",
    "NIC" to "Никарагуанска кордоба (1988–1991)",
    "NIO" to "Никарагуанска кордоба",
    "NLG" to "Холандски гулден",
    "NOK" to "Норвежка крона",
    "NPR" to "Непалска рупия",
    "NZD" to "Новозеландски долар",
    "OMR" to "Омански риал",
    "PAB" to "Панамска балбоа",
    "PEI" to "Перуанско инти",
    "PEN" to "Перуански сол",
    "PES" to "Перуански сол (1863–1965)",
    "PGK" to "Папуа-новогвинейска кина",
    "PHP" to "Филипинско песо",
    "PKR" to "Пакистанска рупия",
    "PLN" to "Полска злота",
    "PLZ" to "Полска злота (1950–1995)",
    "PTE" to "Португалско ескудо",
    "PYG" to "Парагвайско гуарани",
    "QAR" to "Катарски риал",
    "RHD" to "Родезийски долар",
    "ROL" to "Стара румънска лея",
    "RON" to "Румънска лея",
    "RSD" to "Сръбски динар",
    "RUB" to "Руска рубла",
    "RUR" to "Руска рубла (1991–1998)",
    "RWF" to "Руандски франк",
    "SAR" to "саудитски риал",
    "SBD" to "Долар на Соломоновите острови",
    "SCR" to "Сейшелска рупия",
    "SDD" to "Судански динар",
    "SDG" to "Суданска лира",
    "SEK" to "Шведска крона",
    "SGD" to "Сингапурски долар",
    "SHP" to "Лира на Света Елена",
    "SIT" to "Словенски толар",
    "SKK" to "Словашка крона",
    "SLE" to "Сиералеонско леоне",
    "SLL" to "Сиералеонско леоне (1964 – 2022)",
    "SOS" to "Сомалийски шилинг",
    "SRD" to "Суринамски долар",
    "SRG" to "Суринамски гилдер",
    "SSP" to "Южносуданска лира",
    "STD" to "Добра на Сао Томе и Принсипи (1977–2017)",
    "STN" to "Добра на Сао Томе и Принсипи",
    "SUR" to "Съветска рубла",
    "SVC" to "Салвадорски колон",
    "SYP" to "Сирийска лира",
    "SZL" to "Свазилендски лилангени",
    "THB" to "Тайландски бат",
    "TJR" to "Таджикистанска рубла",
    "TJS" to "Таджикистански сомони",
    "TMM" to "Туркменистански манат",
    "TMT" to "Туркменски манат",
    "TND" to "Тунизийски динар",
    "TOP" to "Тонганска паанга",
    "TPE" to "Тиморско ескудо",
    "TRL" to "Турска лира (1922–2005)",
    "TRY" to "Турска лира",
    "TTD" to "Долар на Тринидад и Тобаго",
    "TWD" to "Тайвански долар",
    "TZS" to "Танзанийски шилинг",
    "UAH" to "Украинска гривня",
    "UAK" to "Украински карбованец",
    "UGS" to "Угандийски шилинг (1966–1987)",
    "UGX" to "Угандски шилинг",
    "USD" to "Щатски долар",
    "UYI" to "Уругвайско песо (индекс на инфлацията)",
    "UYP" to "Уругвайско песо (1975–1993)",
    "UYU" to "Уругвайско песо",
    "UZS" to "Узбекски сум",
    "VEB" to "Венецуелски боливар (1871–2008)",
    "VEF" to "Венецуелски боливар",
    "VES" to "Венецуелски боливар (VES)",
    "VND" to "Виетнамски донг",
    "VUV" to "Вануатско вату",
    "WST" to "Самоанска тала",
    "XAF" to "Централноафрикански франк",
    "XAG" to "Сребро",
    "XAU" to "Злато",
    "XBA" to "Европейска съставна единица",
    "XBB" to "Европейска валутна единица",
    "XBC" to "Европейска единица по сметка (XBC)",
    "XBD" to "Европейска единица по сметка (XBD)",
    "XCD" to "Източнокарибски долар",
    "XDR" to "Специални права на тираж",
    "XEU" to "Еку на ЕИО",
    "XFO" to "Френски златен франк",
    "XOF" to "Западноафрикански франк",
    "XPD" to "Паладий",
    "XPF" to "CFP франк",
    "XPT" to "Платина",
    "XTS" to "Код резервиран за целите на тестване",
    "XXX" to "Непозната валута",
    "YDD" to "Йеменски динар",
    "YER" to "Йеменски риал",
    "YUD" to "Югославски твърд динар",
    "YUM" to "Югославски динар",
    "YUN" to "Югославски конвертируем динар",
    "ZAL" to "Южноафрикански ранд (финансов)",
    "ZAR" to "Южноафрикански ранд",
    "ZMK" to "Замбийска квача (1968–2012)",
    "ZMW" to "Замбийска куача",
    "ZRN" to "Заирско ново зайре",
    "ZRZ" to "Заирско зайре",
    "ZWD" to "Зимбабвийски долар",
    "ZWL" to "Зимбабвийски долар (2009)",
  ) }

  val bgc: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bgn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AFN" to "اوگانستانئ اوگانی",
    "BDT" to "بنگلادیشئ ٹاکه",
    "BTN" to "بوتانئ انگولٹروم",
    "INR" to "هندوستانئ روپی",
    "IRR" to "ایرانئ ریال",
    "LKR" to "سریلانکایی روپی",
    "MVR" to "مالدیوی روپی",
    "NPR" to "نیپالین روپی",
    "PKR" to "پاکستانئ روپی",
    "RUB" to "روسین روبل",
  ) }

  val bgn_AE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bgn_AF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bgn_IR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bgn_OM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bho: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val blo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Emiir baGanɔ gaɖɔŋkɔnɔ kaAlaaributǝna kaɖiram",
    "AFN" to "Afganistan kahafganii",
    "ALL" to "Albanii kalɛɛkɩ",
    "AMD" to "Armenii kaɖram",
    "ANG" to "Holanɖ kaKarayiib kafɔlɔrɛŋ",
    "AOA" to "Aŋgolaa kakʊwansa",
    "ARS" to "Arjantin kapɛsoo",
    "AUD" to "Ɔstraliya kaɖala",
    "AWG" to "Arubaa kafɔlɔrɛŋ",
    "AZN" to "Asɛrbaɩjaŋ kamanaatɩ",
    "BAM" to "Bɔsniya na Hɛrsegɔfina kamarkɩ",
    "BBD" to "Barbaɖɔɔsɩ kaɖala",
    "BDT" to "Baŋglaɖɛɛshɩ kataka",
    "BGN" to "Bulgarii kalɛɛfʊ",
    "BHD" to "Barɛɛn kaɖinaa",
    "BIF" to "Burunɖii kafaraŋ",
    "BMD" to "Bɛrmuɖaa kaɖala",
    "BND" to "Brunɛɩ kaɖala",
    "BOB" to "Bolifiya kabolifiyano",
    "BRL" to "Bresil kareyal",
    "BSD" to "Bahamaasɩ kaɖala",
    "BTN" to "Butan kaŋgulturɔm",
    "BWP" to "Bɔsʊwanaa kapula",
    "BYN" to "Belaruus karubǝl",
    "BZD" to "Beliis kaɖala",
    "CAD" to "Kanaɖaa kaɖala",
    "CDF" to "Koŋgoo kafaraŋ",
    "CHF" to "Suwis kafaraŋ",
    "CLP" to "Shilii kapɛsoo",
    "CNH" to "Caɩna kayuwan ba sǝ̂ra afʊba ma",
    "CNY" to "Caɩna kayuwan",
    "COP" to "Kolɔmbii kapɛsoo",
    "CRC" to "Kɔsta Rikaa kakolɔn",
    "CUC" to "Kubaa kapɛsoo ba sǝ̂ra afʊba ma",
    "CUP" to "Kubaa kapɛsoo",
    "CVE" to "Kapfɛɛr kahɛskuɖoo",
    "CZK" to "Cɛk kakrona",
    "DJF" to "Jibutii kafaraŋ",
    "DKK" to "Ɖanǝmark kakrona",
    "DOP" to "Ɖominikaa kapɛsoo",
    "DZD" to "Aljerii kaɖinaa",
    "EGP" to "Ejipti kapɔŋ",
    "ERN" to "Eritree kanafka",
    "ETB" to "Etiyopii kabiir",
    "EUR" to "eroo",
    "FJD" to "Fiji kaɖala",
    "FKP" to "Fɔklanɖ kaBʊtukǝltǝna kapɔŋ",
    "GBP" to "Gagɛɛshɩtǝna kapɔŋ",
    "GEL" to "Jɔrjiya kalari",
    "GHS" to "Gana kasiɖi",
    "GIP" to "Gibraltaa kapɔŋ",
    "GMD" to "Gambii kaɖalaasi",
    "GNF" to "Ginee kafaraŋ",
    "GTQ" to "Guwatemalaa kakesaal",
    "GYD" to "Guyanaa kaɖala",
    "HKD" to "Hɔŋ Kɔŋ kaɖala",
    "HNL" to "Hɔnɖuraasɩ kalampira",
    "HRK" to "Krowasii kakuna",
    "HTG" to "Hayitii kaguurɖi",
    "HUF" to "Ɔŋgrii kafɔrɩntɩ",
    "IDR" to "Ɛnɖonosii karupiyaa",
    "ILS" to "Yishraɛl kashekɛl afɔlɩ",
    "INR" to "Inɖiya karupii",
    "IQD" to "Ɩraakɩ kaɖinaa",
    "IRR" to "Iraŋ kariyal",
    "ISK" to "Islanɖ kakrona",
    "JMD" to "Jamaɩka kaɖala",
    "JOD" to "Jɔrɖanii kaɖinaa",
    "JPY" to "Japaŋ kayɛn",
    "KES" to "Keniya kashílè",
    "KGS" to "Kirgistan kasɔm",
    "KHR" to "Kamboɖiya kariyɛl",
    "KMF" to "Komɔɔr kafaraŋ",
    "KPW" to "Koree gʊnyɩpɛnɛlaŋ kawɔn",
    "KRW" to "Koree gʊnyɩsonolaŋ kawɔn",
    "KWD" to "Koweeti kaɖinaa",
    "KYD" to "Kayimaan kaBʊtukǝltǝna kaɖala",
    "KZT" to "Kasastan katɛŋgɛ",
    "LAK" to "Lawɔs kakip",
    "LBP" to "Liibaaŋ kapɔŋ",
    "LKR" to "Siri Laŋkaa karupii",
    "LRD" to "Liberiya kaɖala",
    "LSL" to "Lesotoo kaloti",
    "LYD" to "Libii kaɖinaa",
    "MAD" to "Morooko kaɖiram",
    "MDL" to "Molɖafiya kalewu",
    "MGA" to "Maɖagaskaa kaharɩyaarɩ",
    "MKD" to "Maseɖoniya kaɖenaa",
    "MMK" to "Miyanmaa kakiyaatɩ",
    "MNT" to "Mɔŋgolii katugiriiki",
    "MOP" to "Makawoo kapataka",
    "MRU" to "Moritanii kahugiya",
    "MUR" to "Imoris karupii",
    "MVR" to "Malɖiifu karufiyaa",
    "MWK" to "Malawii kakʊwaasha",
    "MXN" to "Mɛsik kapɛsoo",
    "MYR" to "Malɛsii kariŋgiiti",
    "MZN" to "Mosambii kametikal",
    "NAD" to "Namibii kaɖala",
    "NGN" to "Nanjiiriya kanɛɛra",
    "NIO" to "Nikaraguwaa kakɔrɖoba",
    "NOK" to "Nɔrfɛsh kakrona",
    "NPR" to "Neepal karupii",
    "NZD" to "Selanɖ afɔlɩ kaɖala",
    "OMR" to "Oman kariyal",
    "PAB" to "Panamaa kabalbowa",
    "PEN" to "Peruu kasol",
    "PGK" to "Papuasii Ginee afɔlɩ kakina",
    "PHP" to "Filipiin kapɛsoo",
    "PKR" to "Pakistan karupii",
    "PLN" to "Polanɖ kasǝlɔɔtɩ",
    "PYG" to "Paraguwee kaguwarani",
    "QAR" to "Kataa kariyal",
    "RON" to "Romanii kalewu",
    "RSD" to "Sɛrbii kaɖinaa",
    "RUB" to "Rɔɔshɩya karubǝl",
    "RWF" to "Rʊwanɖaa kafaraŋ",
    "SAR" to "Sauɖiya kariyal",
    "SBD" to "Salomɔɔn kaBʊtukǝltǝna kaɖala",
    "SCR" to "Seshɛl karupii",
    "SDG" to "Suɖaŋ kapɔŋ",
    "SEK" to "Sʊwɛɖ kakrona",
    "SGD" to "Siŋgapuur kaɖala",
    "SHP" to "Sɛŋ Elenaa kapɔŋ",
    "SLE" to "Seraleyɔn kaleyɔn",
    "SLL" to "Seraleyɔn kaleyɔn (1964—2022)",
    "SOS" to "Somalii kashílè",
    "SRD" to "Surinam kaɖala",
    "SSP" to "Suɖaŋ gʊnyɩsonolaŋ kapɔŋ",
    "STN" to "Saotomee kaɖobra",
    "SYP" to "Sirii kapɔŋ",
    "SZL" to "Sʊwasilanɖ kalilaŋgenii",
    "THB" to "Taɩlanɖ kabaatɩ",
    "TJS" to "Tajikistan kasomooni",
    "TMT" to "Turkmenistan kamanaatɩ",
    "TND" to "Tunisii kaɖinaa",
    "TOP" to "Tɔŋga kapaŋga",
    "TRY" to "Turkii kalira",
    "TTD" to "Triniɖaaɖ na Tobagoo kaɖala",
    "TWD" to "Taɩwan kaɖala afɔlɩ",
    "TZS" to "Taŋsanii kashílè",
    "UAH" to "Ikrɛɛn karifniya",
    "UGX" to "Uganɖaa kashílè",
    "USD" to "Amalɩka kaɖala",
    "UYU" to "Uruguwee kapɛsoo",
    "UZS" to "Usbeekistan kasɔm",
    "VES" to "Fenesuwelaa kabolifar",
    "VND" to "Fɛtnam kaɖɔŋgɩ",
    "VUV" to "Fanuwatu kafatu",
    "WST" to "Samowa katala",
    "XAF" to "Garɩɖontǝna gɩcɩɩca kasɛɛfa",
    "XCD" to "Karayiib gajakalaŋ kaɖala",
    "XOF" to "Garɩɖontǝna gɩteŋshilelaŋ kasɛɛfa",
    "XPF" to "Polinesiya Gafɔntǝna kaja kafaraŋ",
    "XXX" to "gɩtanɩɩ kʊyɔʊ ʊ mana ma",
    "YER" to "Yemɛn kariyal",
    "ZAR" to "Sautafrika karanɖɩ",
    "ZMW" to "Sambii kakʊwaasha",
  ) }

  val blt: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bm: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "arabu mara kafoli Diram",
    "AOA" to "angola Kwanza",
    "AUD" to "ositirali Dolar",
    "BHD" to "bareyini Dinar",
    "BIF" to "burundi Fraŋ",
    "BWP" to "bɔtisiwana Pula",
    "CAD" to "kanada Dolar",
    "CDF" to "kongole Fraŋ",
    "CHF" to "suwisi Fraŋ",
    "CNY" to "siniwa Yuwan",
    "CVE" to "capivɛrdi Esekudo",
    "DJF" to "jibuti Fraŋ",
    "DZD" to "alizeri Dinar",
    "EGP" to "eziputi Livri",
    "ERN" to "eritere Nafika",
    "ETB" to "etiopi Bir",
    "EUR" to "ero",
    "GBP" to "angilɛ Livri",
    "GHC" to "gana Sedi",
    "GMD" to "gambi Dalasi",
    "GNS" to "gine Fraŋ",
    "INR" to "Ɛndu Rupi",
    "JPY" to "zapɔne Yɛn",
    "KES" to "keniya Siling",
    "KMF" to "komɔri Fraŋ",
    "LRD" to "liberiya Dolar",
    "LSL" to "lesoto Loti",
    "LYD" to "libi Dinar",
    "MAD" to "marɔku Diram",
    "MGA" to "madagasikari Fraŋ",
    "MRO" to "mɔritani Uguwiya (1973–2017)",
    "MRU" to "mɔritani Uguwiya",
    "MUR" to "morisi Rupi",
    "MWK" to "malawi Kwaca",
    "MZM" to "mozanbiki Metikali",
    "NAD" to "namibi Dolar",
    "NGN" to "nizeriya Nɛra",
    "RWF" to "ruwanda Fraŋ",
    "SAR" to "sawudiya Riyal",
    "SCR" to "sesɛli Rupi",
    "SDG" to "sudani Dinar",
    "SDP" to "sudani Livri",
    "SHP" to "Ɛlɛni-Senu Livri",
    "SLE" to "siyeralewɔni Lewɔni",
    "SLL" to "siyeralewɔni Lewɔni (1964—2022)",
    "SOS" to "somali Siling",
    "STD" to "sawotome Dobra (1977–2017)",
    "STN" to "sawotome Dobra",
    "SZL" to "swazilandi Lilangeni",
    "TND" to "tunizi Dinar",
    "TZS" to "tanzani Siling",
    "UGX" to "uganda Siling",
    "USD" to "ameriki Dolar",
    "XAF" to "sefa Fraŋ (BEAC)",
    "XOF" to "sefa Fraŋ (BCEAO)",
    "ZAR" to "sudafriki Randi",
    "ZMK" to "zambi Kwaca (1968–2012)",
    "ZMW" to "zambi Kwaca",
    "ZWD" to "zimbabuwe Dolar",
  ) }

  val bm_Nkoo: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "এ্যান্ডোরান পেসেতা",
    "AED" to "সংযুক্ত আরব আমিরাত দিরহাম",
    "AFA" to "আফগানি (১৯২৭–২০০২)",
    "AFN" to "আফগান আফগানি",
    "ALL" to "আলবেনিয়ান লেক",
    "AMD" to "আরমেনিয়ান দ্রাম",
    "ANG" to "নেদারল্যান্ড এ্যান্টিলিয়ান গুল্ডের",
    "AOA" to "এ্যাঙ্গোলান কওয়ানজা",
    "AOK" to "এ্যাঙ্গোলান কওয়ানজা (১৯৭৭–১৯৯০)",
    "AON" to "এ্যাঙ্গোলান নতুন কওয়ানজা (১৯৯৫–২০০০)",
    "AOR" to "এ্যাঙ্গোলান কওয়ানজা (১৯৯৫–১৯৯৯)",
    "ARA" to "আর্জেন্টিনা অস্ট্রাল",
    "ARP" to "আর্জেন্টিনা পেসো (১৯৮৩–১৯৮৫)",
    "ARS" to "আর্জেন্টিনা পেসো",
    "ATS" to "অস্ট্রিয়ান শিলিং",
    "AUD" to "অস্ট্রেলিয়ান ডলার",
    "AWG" to "আরুবা ফ্লোরিন",
    "AZM" to "আজারবাইজান মানাত (১৯৯৩–২০০৬)",
    "AZN" to "আজারবাইজান মানাত",
    "BAD" to "বসনিয়া এবং হার্জেগোভিনা দিনার",
    "BAM" to "বসনিয়া এবং হার্জেগোভিনা বিনিমেয় মার্ক",
    "BBD" to "বার্বেডোজ ডলার",
    "BDT" to "বাংলাদেশী টাকা",
    "BEC" to "বেলজিয়ান ফ্রাঙ্ক (রূপান্তরযোগ্য)",
    "BEF" to "বেলজিয়ান ফ্রাঙ্ক",
    "BEL" to "বেলজিয়ান ফ্রাঙ্ক (আর্থিক)",
    "BGL" to "বুলগেরীয় হার্ড লেভ",
    "BGN" to "বুলগেরীয় লেভ",
    "BHD" to "বাহরাইনি দিনার",
    "BIF" to "বুরুন্ডি ফ্রাঙ্ক",
    "BMD" to "বারমিউডান ডলার",
    "BND" to "ব্রুনেই ডলার",
    "BOB" to "বলিভিয়ান বলিভিয়ানো",
    "BOP" to "বলিভিয়ান পেসো",
    "BOV" to "বলিভিয়ান মভডোল",
    "BRB" to "ব্রাজিলিয়ান ক্রুজেয়রোনোভো (১৯৬৭–১৯৮৬)",
    "BRC" to "ব্রাজিলিয়ান ক্রুজেইডাউ",
    "BRE" to "ব্রাজিলিয়ান ক্রুজেয়রো (১৯৯০–১৯৯৩)",
    "BRL" to "ব্রাজিলিয়ান রিয়েল",
    "BRN" to "ব্রাজিলিয়ান ক্রুজেইডো নোভো",
    "BRR" to "ব্রাজিলিয়ান ক্রুজেয়রো",
    "BSD" to "বাহামিয়ান ডলার",
    "BTN" to "ভুটানি এনগুল্ট্রুম",
    "BUK" to "বর্মি কিয়াৎ",
    "BWP" to "বতসোয়ানা পুলা",
    "BYB" to "বেলারুশিয়ান নিউ রুবেল (১৯৯৪–১৯৯৯)",
    "BYN" to "বেলারুশিয়ান রুবেল",
    "BYR" to "বেলারুশিয়ান রুবেল (2000–2016)",
    "BZD" to "বেলিজ ডলার",
    "CAD" to "কানাডিয়ান ডলার",
    "CDF" to "কঙ্গোলিস ফ্র্যাঙ্ক",
    "CHE" to "সুইজারল্যান্ড ইউরো",
    "CHF" to "সুইস ফ্রাঁ",
    "CHW" to "সুইজারল্যান্ড ফ্রাঙ্ক",
    "CLF" to "চিলিয়ান উনিদাদেস দি ফোমেন্তো",
    "CLP" to "চিলি পেসো",
    "CNH" to "চাইনিজ ইউয়ান (অফশোর)",
    "CNY" to "চীনা য়ুয়ান",
    "COP" to "কলোম্বিয়ান পেসো",
    "COU" to "উনিদাদ দি ভ্যালোর রিয়েল",
    "CRC" to "কোস্টা রিকা কোলোন",
    "CSD" to "প্রাচীন সারবিয়ান দিনার",
    "CSK" to "চেকোস্লোভাক হার্ড কোরুনা",
    "CUC" to "কিউবান রূপান্তরযোগ্য পেসো",
    "CUP" to "কিউবান পেসো",
    "CVE" to "কেপ ভার্দে এসকুডো",
    "CYP" to "সাইপ্রাস পাউন্ড",
    "CZK" to "চেক প্রজাতন্ত্র কোরুনা",
    "DDM" to "পূর্ব জার্মান মার্ক",
    "DEM" to "ডয়চ্ মার্ক",
    "DJF" to "জিবুতি ফ্রাঙ্ক",
    "DKK" to "ড্যানিশ ক্রোন",
    "DOP" to "ডোমিনিকান পেসো",
    "DZD" to "আলজেরীয় দিনার",
    "ECS" to "ইকুয়াডোর সুক্রে",
    "ECV" to "ইকুয়াডোর উনিদাদেস দি ভেলর কনসতান্তে (ইউভিসি)",
    "EEK" to "এস্তোনিয়া ক্রুনি",
    "EGP" to "মিশরীয় পাউন্ড",
    "ERN" to "এরিট্রিয়েন নাকফা",
    "ESA" to "স্প্যানিশ পেসেতা (একই হিসাব)",
    "ESB" to "স্প্যানিশ পেসেতা (রূপান্তরযোগ্য হিসাব)",
    "ESP" to "স্প্যানিশ পেসেতা",
    "ETB" to "ইথিওপিয়ান বির",
    "EUR" to "ইউরো",
    "FIM" to "ফিনিস মার্কা",
    "FJD" to "ফিজি ডলার",
    "FKP" to "ফকল্যান্ড দ্বীপপুঞ্জ পাউন্ড",
    "FRF" to "ফরাসি ফ্রাঙ্ক",
    "GBP" to "ব্রিটিশ পাউন্ড",
    "GEK" to "জর্জিয়ান কুপন লারিট",
    "GEL" to "জর্জিয়ান লারি",
    "GHC" to "ঘানা সেডি (১৯৭৯–২০০৭)",
    "GHS" to "ঘানা সেডি",
    "GIP" to "জিব্রাল্টার পাউন্ড",
    "GMD" to "গাম্বিয়া ডালাসি",
    "GNF" to "গিনি ফ্রাঙ্ক",
    "GNS" to "গিনি সাইলি",
    "GQE" to "ইকুয়েটোরিয়াল গিনি ইকুয়িলি",
    "GRD" to "গ্রীক দ্রাচমা",
    "GTQ" to "গুয়াতেমালা কুয়েৎজাল",
    "GWE" to "পর্তুগিজ গিনি এসকুডো",
    "GWP" to "গিনি বিসাউ পেসো",
    "GYD" to "গায়ানিজ ডলার",
    "HKD" to "হংকং ডলার",
    "HNL" to "হন্ডুরাস লেম্পিরা",
    "HRD" to "ক্রোয়েশিয়ান দিনার",
    "HRK" to "ক্রোয়েশিয়ান কুনা",
    "HTG" to "হাইতি গৌর্দে",
    "HUF" to "হাঙ্গেরিয়ান ফোরিন্ট",
    "IDR" to "ইন্দোনেশিয়ান রুপিয়াহ",
    "IEP" to "ইরিশ পাউন্ড",
    "ILP" to "ইস্রাইলি পাউন্ড",
    "ILS" to "ইসরায়েলি নতুন শেকেল",
    "INR" to "ভারতীয় রুপি",
    "IQD" to "ইরাকি দিনার",
    "IRR" to "ইরানিয়ান রিয়াল",
    "ISK" to "আইসল্যান্ডীয় ক্রোনা",
    "ITL" to "ইতালীয় লিরা",
    "JMD" to "জামাইকান ডলার",
    "JOD" to "জর্ডানিয়ান দিনার",
    "JPY" to "জাপানি ইয়েন",
    "KES" to "কেনিয়ান শিলিং",
    "KGS" to "কিরগিজস্তান সোম",
    "KHR" to "কম্বোডিয়ান রিয়েল",
    "KMF" to "কমোরিয়ান ফ্রাঙ্ক",
    "KPW" to "উত্তর কোরিয়ার ওন",
    "KRW" to "দক্ষিণ কোরিয়ান ওন",
    "KWD" to "কুয়েতি দিনার",
    "KYD" to "কেম্যান দ্বীপপুঞ্জের ডলার",
    "KZT" to "কাজাখাস্তানি টেঙ্গে",
    "LAK" to "লেউশান কিপ",
    "LBP" to "লেবানিজ পাউন্ড",
    "LKR" to "শ্রীলঙ্কান রুপি",
    "LRD" to "লিবেরিয়ান ডলার",
    "LSL" to "লেসুটু লোটি",
    "LTL" to "লিথুইনিয়ান লিটা",
    "LTT" to "লিথুইনিয়ান টালোন্যাস",
    "LUC" to "লুক্সেমবার্গ রুপান্তযোগ্য ফ্রাঙ্ক",
    "LUF" to "লুক্সেমবার্গ ফ্রাঙ্ক",
    "LUL" to "লুক্সেমবার্গ ফাইনেনশিয়াল ফ্রাঙ্ক",
    "LVL" to "ল্যাটভিয়ান ল্যাট্‌স",
    "LVR" to "ল্যাটভিয়ান রুবল",
    "LYD" to "লিবিয়ান দিনার",
    "MAD" to "মোরোক্কান দিরহাম",
    "MAF" to "মোরোক্কান ফ্রাঙ্ক",
    "MDL" to "মোল্ডোভান লেয়ু",
    "MGA" to "মাদাগাস্কার আরিয়ারি",
    "MGF" to "মাদাগাস্কার ফ্রাঙ্ক",
    "MKD" to "ম্যাসেডোনিয়ান দিনার",
    "MLF" to "মালি ফ্রাঙ্ক",
    "MMK" to "মায়ানমার কিয়াত",
    "MNT" to "মঙ্গোলিয়ান তুগরিক",
    "MOP" to "ম্যাক্যাও পাটাকা",
    "MRO" to "মৌরিতানিয়ান ওউগুইয়া (১৯৭৩–২০১৭)",
    "MRU" to "মৌরিতানিয়ান ওউগুইয়া",
    "MTL" to "মাল্টা লিরা",
    "MTP" to "মাল্টা পাউন্ড",
    "MUR" to "মৌরিতানিয়ান রুপি",
    "MVR" to "মালদিভিয়ান রুফিয়া",
    "MWK" to "মালাউইয়ান কোয়াচা",
    "MXN" to "ম্যাক্সিকান পেসো",
    "MXP" to "ম্যাক্সিকান সিলভার পেসো (১৮৬১–১৯৯২)",
    "MXV" to "মেক্সিকান উনিদাদ দি ইনভার্সান (UDI)",
    "MYR" to "মালয়েশিয়ান রিঙ্গিৎ",
    "MZE" to "মোজাম্বিক এসকুডো",
    "MZM" to "প্রাচীন মোজাম্বিক মেটিকেল",
    "MZN" to "মোজাম্বিক মেটিকেল",
    "NAD" to "নামিবিয়া ডলার",
    "NGN" to "নাইজেরিয়ান নায়রা",
    "NIC" to "নিকারাগুয়ান কর্ডোবা (১৯৮৮–১৯৯১)",
    "NIO" to "নিকারাগুয়ান কর্ডোবা",
    "NLG" to "নেদারল্যান্ড গুল্ডের",
    "NOK" to "নরওয়েজিয়ান ক্রোন",
    "NPR" to "নেপালি রুপি",
    "NZD" to "নিউজিল্যান্ড ডলার",
    "OMR" to "ওমানি রিয়াল",
    "PAB" to "পানামানিয়ান বালবোয়া",
    "PEI" to "পেরুভিয়ান ইন্তি",
    "PEN" to "পেরুভিয়ান সোল",
    "PES" to "পেরুভিয়ান সোল (1863–1965)",
    "PGK" to "পাপুয়া নিউ গিনিয়ান কিনা",
    "PHP" to "ফিলিপাইন পেসো",
    "PKR" to "পাকিস্তানি রুপি",
    "PLN" to "পোলিশ জ্লোটি",
    "PLZ" to "পোলিশ জ্লোটি (১৯৫০–১৯৯৫)",
    "PTE" to "পর্তুগিজ এসকুডো",
    "PYG" to "প্যারাগুয়ান গুয়ারানি",
    "QAR" to "কাতার রিয়াল",
    "RHD" to "রোডেশিয়ান ডলার",
    "ROL" to "প্রাচীন রুমানিয়া লেয়ু",
    "RON" to "রুমানিয়া লেয়ু",
    "RSD" to "সারবিয়ান দিনার",
    "RUB" to "রাশিয়ান রুবেল",
    "RUR" to "রাশিয়ান রুবল (১৯৯১–১৯৯৮)",
    "RWF" to "রুয়ান্ডান ফ্রাঙ্ক",
    "SAR" to "সৌদি রিয়াল",
    "SBD" to "সলোমন দ্বীপপুঞ্জ ডলার",
    "SCR" to "সেয়চেল্লোইস রুপি",
    "SDD" to "প্রাচীন সুদানি দিনার",
    "SDG" to "সুদানি পাউন্ড",
    "SDP" to "প্রাচীন সুদানি পাউন্ড",
    "SEK" to "সুইডিশ ক্রোনা",
    "SGD" to "সিঙ্গাপুর ডলার",
    "SHP" to "সেন্ট হেলেনা পাউন্ড",
    "SIT" to "স্লোভানিয়া টোলার",
    "SKK" to "স্লোভাক কোরুনা",
    "SLE" to "সিয়েরা লিয়নের লিয়ন",
    "SLL" to "সিয়েরা লিয়নের লিয়ন (1964—2022)",
    "SOS" to "সোমালি শিলিং",
    "SRD" to "সুরিনামিজ ডলার",
    "SRG" to "সুরিনাম গিল্ডার",
    "SSP" to "দক্ষিণ সুদানি পাউন্ড",
    "STD" to "সাও টোমে এবং প্রিন্সিপে ডোবরা (১৯৭৭–২০১৭)",
    "STN" to "সাও টোমে এবং প্রিন্সিপে ডোবরা",
    "SUR" to "সোভিয়েত রুবল",
    "SVC" to "এল স্যালভোডোর কোলোন",
    "SYP" to "সিরিয়ান পাউন্ড",
    "SZL" to "সোয়াজিল্যান্ড লিলাঙ্গেনি",
    "THB" to "থাই বাত",
    "TJR" to "তাজিকিস্তান রুবল",
    "TJS" to "তাজিকিস্তান সোমোনি",
    "TMM" to "তুর্কমেনিস্টানি মানাত",
    "TMT" to "তুর্কমেনিস্তান মানত",
    "TND" to "তিউনেশিয়ান দিনার",
    "TOP" to "টোঙ্গা পা’আঙ্গা",
    "TPE" to "তিমুর এসকুডো",
    "TRL" to "প্রাচীন তুর্কি লিরা",
    "TRY" to "তুর্কি লিরা",
    "TTD" to "ত্রিনিদাদ এবং টোবাগো ডলার",
    "TWD" to "নতুন তাইওয়ান ডলার",
    "TZS" to "তাঞ্জনিয়া শিলিং",
    "UAH" to "ইউক্রেইন হৃভনিয়া",
    "UAK" to "ইউক্রেইন কার্বোভ্যান্টস",
    "UGS" to "উগান্ডান শিলিং (১৯৬৬–১৯৮৭)",
    "UGX" to "উগান্ডান শিলিং",
    "USD" to "মার্কিন ডলার",
    "USN" to "মার্কিন ডলার (পরবর্তী দিন)",
    "USS" to "মার্কিন ডলার (একই দিন)",
    "UYI" to "উরুগুয়ায়ান পেসো এন উনিদাদেস ইনডেক্সেডাস",
    "UYP" to "উরুগুয়ে পেসো (১৯৭৫–১৯৯৩)",
    "UYU" to "উরুগুয়ে পেসো",
    "UZS" to "উজবেকিস্তানি সোম",
    "VEB" to "ভেনিজুয়েলান বলিভার (১৮৭১–২০০৮)",
    "VEF" to "ভেনিজুয়েলীয় বলিভার (২০০৮–২০১৮)",
    "VES" to "ভেনিজুয়েলীয় বলিভার",
    "VND" to "ভিয়েতনামি ডঙ্গ",
    "VUV" to "ভানুয়াতু ভাতু",
    "WST" to "সামোয়ান টালা",
    "XAF" to "মধ্য আফ্রিকান [CFA] ফ্র্যাঙ্ক",
    "XAG" to "সিলভার",
    "XAU" to "গোল্ড",
    "XBB" to "ইউরোপীয় আর্থিক একক",
    "XCD" to "পূর্ব ক্যারাবিয়ান ডলার",
    "XEU" to "ইউরোপীয় মুদ্রা একক",
    "XFO" to "ফরাসি গোল্ড ফ্রাঙ্ক",
    "XFU" to "ফরাসি ইউআইসি - ফ্রাঙ্ক",
    "XOF" to "পশ্চিম আফ্রিকান [CFA] ফ্র্যাঙ্ক",
    "XPD" to "প্যালেডিয়াম",
    "XPF" to "সিএফপি ফ্র্যাঙ্ক",
    "XPT" to "প্লাটিনাম",
    "XXX" to "অজানা মুদ্রা",
    "YDD" to "ইয়েমেনি দিনার",
    "YER" to "ইয়েমেনি রিয়াল",
    "YUD" to "যুগোশ্লাভিয় হার্ড দিনার",
    "YUM" to "যুগোশ্লাভিয় নোভি দিনার",
    "YUN" to "যুগোশ্লাভিয় রুপান্তরযোগ্য দিনার",
    "ZAL" to "দক্ষিণ আফ্রিকান র‌্যান্ড",
    "ZAR" to "দক্ষিণ আফ্রিকান রেন্ড",
    "ZMK" to "জাম্বিয়ান কওয়াচা (১৯৬৮–২০১২)",
    "ZMW" to "জাম্বিয়ান কওয়াচা",
    "ZRN" to "জাইরিয়ান নিউ জাইরে",
    "ZRZ" to "জাইরিয়ান জাইরে",
    "ZWD" to "জিম্বাবুয়ে ডলার (১৯৮০–২০০৮)",
    "ZWL" to "জিম্বাবুয়ে ডলার (২০০৯)",
    "ZWR" to "জিম্বাবুয়ে ডলার (২০০৮)",
  ) }

  val bn_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "নেদারল্যান্ডস অ্যান্টিলিয়ান গিল্ডার",
    "AWG" to "আরুবান গিল্ডার",
    "BMD" to "বারমুডান ডলার",
    "GTQ" to "গুয়াতেমালান কেৎসাল",
    "HNL" to "হন্ডুরান লেম্পিরা",
    "HTG" to "হাইতিয়ান গুর্দ",
    "MXN" to "মেক্সিকান পেসো",
    "XCD" to "পূর্ব ক্যারিবিয়ান ডলার",
  ) }

  val bo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "CNY" to "ཡུ་ཨན་",
    "INR" to "རྒྱ་གར་སྒོར་",
    "USD" to "ཨ་རིའི་སྒོར་",
    "XXX" to "མ་རྟོགས་པའི་ནུས་མེད་དངུལ་ལོར",
  ) }

  val bo_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val br: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "peseta Andorra",
    "AED" to "dirham EAU",
    "AFA" to "afghani Afghanistan (1927–2002)",
    "AFN" to "afghani Afghanistan",
    "ALK" to "lek Albania (1946–1965)",
    "ALL" to "lek Albania",
    "AMD" to "dram Armenia",
    "ANG" to "florin Antilhez nederlandat",
    "AOA" to "kwanza Angola",
    "AOK" to "kwanza Angola (1977–1991)",
    "AON" to "kwanza nevez Angola (1990–2000)",
    "ARM" to "peso Arcʼhantina (1881–1970)",
    "ARP" to "peso Arcʼhantina (1983–1985)",
    "ARS" to "peso Arcʼhantina",
    "ATS" to "schilling Aostria",
    "AUD" to "dollar Aostralia",
    "AWG" to "florin Aruba",
    "AZM" to "manat Azerbaidjan (1993–2006)",
    "AZN" to "manat Azerbaidjan",
    "BAD" to "dinar Bosnia ha Herzegovina (1992–1994)",
    "BAM" to "mark kemmadus Bosnia ha Herzegovina",
    "BAN" to "dinar nevez Bosnia ha Herzegovina (1994–1997)",
    "BBD" to "dollar Barbados",
    "BDT" to "taka Bangladesh",
    "BEC" to "lur Belgia (kemmadus)",
    "BEF" to "lur Belgia",
    "BGM" to "lev sokialour Bulgaria",
    "BGN" to "lev Bulgaria",
    "BGO" to "lev Bulgaria (1879–1952)",
    "BHD" to "dinar Bahrein",
    "BIF" to "lur Burundi",
    "BMD" to "dollar Bermuda",
    "BND" to "dollar Brunei",
    "BOB" to "boliviano Bolivia",
    "BOL" to "boliviano Bolivia (1863–1963)",
    "BOP" to "peso Bolivia",
    "BRL" to "real Brazil",
    "BSD" to "dollar Bahamas",
    "BTN" to "ngultrum Bhoutan",
    "BUK" to "kyat Birmania",
    "BWP" to "pula Botswana",
    "BYB" to "roubl nevez Belarus (1994–1999)",
    "BYN" to "roubl Belarus",
    "BYR" to "roubl Belarus (2000–2016)",
    "BZD" to "dollar Belize",
    "CAD" to "dollar Kanada",
    "CDF" to "lur Kongo",
    "CHE" to "euro WIR",
    "CHF" to "lur Suis",
    "CHW" to "lur WIR",
    "CLE" to "escudo Chile",
    "CLF" to "unanenn jediñ Chile",
    "CLP" to "peso Chile",
    "CNH" to "yuan Sina (diavaez)",
    "CNX" to "dollar Bank poblel Sina",
    "CNY" to "yuan Sina",
    "COP" to "peso Kolombia",
    "CRC" to "colón Costa Rica",
    "CSD" to "dinar Serbia (2002–2006)",
    "CUC" to "peso kemmadus Kuba",
    "CUP" to "peso Kuba",
    "CVE" to "escudo Kab Glas",
    "CYP" to "lur Kiprenez",
    "CZK" to "kurunenn Tchek",
    "DDM" to "mark Alamagn ar Reter",
    "DEM" to "mark Alamagn",
    "DJF" to "lur Djibouti",
    "DKK" to "kurunenn Danmark",
    "DOP" to "peso Dominikan",
    "DZD" to "dinar Aljeria",
    "EEK" to "kurunenn Estonia",
    "EGP" to "lur Egipt",
    "ERN" to "nakfa Eritrea",
    "ESB" to "peseta gemmadus Spagn",
    "ESP" to "peseta Spagn",
    "ETB" to "birr Etiopia",
    "EUR" to "euro",
    "FIM" to "mark Finland",
    "FJD" to "dollar Fidji",
    "FKP" to "lur Inizi Falkland",
    "FRF" to "lur gall",
    "GBP" to "lur Breizh-Veur",
    "GEL" to "lari Jorjia",
    "GHS" to "cedi Ghana",
    "GIP" to "lur Jibraltar",
    "GMD" to "dalasi Gambia",
    "GNF" to "lur Ginea",
    "GNS" to "syli Ginea",
    "GQE" to "ekwele Ginea ar Cʼheheder",
    "GRD" to "drakm Gres",
    "GTQ" to "quetzal Guatemala",
    "GWP" to "peso Ginea-Bissau",
    "GYD" to "dollar Guyana",
    "HKD" to "dollar Hong Kong",
    "HNL" to "lempira Honduras",
    "HRD" to "dinar Kroatia",
    "HRK" to "kuna Kroatia",
    "HTG" to "gourde Haiti",
    "HUF" to "forint Hungaria",
    "IDR" to "roupi Indonezia",
    "IEP" to "lur Iwerzhon",
    "ILP" to "lur Israel",
    "ILR" to "shekel Israel (1980–1985)",
    "ILS" to "shekel nevez Israel",
    "INR" to "roupi India",
    "IQD" to "dinar Iraq",
    "IRR" to "rial Iran",
    "ISJ" to "kurunenn Island (1918–1981)",
    "ISK" to "kurunenn Island",
    "ITL" to "lur Italia",
    "JMD" to "dollar Jamaika",
    "JOD" to "dinar Jordania",
    "JPY" to "yen Japan",
    "KES" to "shilling Kenya",
    "KGS" to "som Kyrgyzstan",
    "KHR" to "riel Kambodja",
    "KMF" to "lur Komorez",
    "KPW" to "won Korea an Norzh",
    "KRH" to "hwan Korea ar Su (1953–1962)",
    "KRO" to "won Korea ar Su (1945–1953)",
    "KRW" to "won Korea ar Su",
    "KWD" to "dinar Koweit",
    "KYD" to "dollar Inizi Cayman",
    "KZT" to "tenge Kazakstan",
    "LAK" to "kip Laos",
    "LBP" to "lur Liban",
    "LKR" to "roupi Sri Lanka",
    "LRD" to "dollar Liberia",
    "LSL" to "loti Lesotho",
    "LTL" to "litas Lituania",
    "LTT" to "talonas Lituania",
    "LUC" to "lur kemmadus Luksembourg",
    "LUF" to "lur Luksembourg",
    "LVL" to "lats Latvia",
    "LVR" to "roubl Latvia",
    "LYD" to "dinar Libia",
    "MAD" to "dirham Maroko",
    "MAF" to "lur Maroko",
    "MCF" to "lur Monaco",
    "MDL" to "leu Moldova",
    "MGA" to "ariary Madagaskar",
    "MGF" to "lur Madagaskar",
    "MKD" to "denar Makedonia",
    "MKN" to "denar Makedonia (1992–1993)",
    "MLF" to "lur Mali",
    "MMK" to "kyat Myanmar",
    "MNT" to "tugrik Mongolia",
    "MOP" to "pataca Macau",
    "MRO" to "ouguiya Maouritania (1973–2017)",
    "MRU" to "ouguiya Maouritania",
    "MTL" to "lira Malta",
    "MTP" to "lur Malta",
    "MUR" to "roupi Moris",
    "MVP" to "roupi Maldivez",
    "MVR" to "rufiyaa Maldivez",
    "MWK" to "kwacha Malawi",
    "MXN" to "peso Mecʼhiko",
    "MXP" to "peso arcʼhant Mecʼhiko (1861–1992)",
    "MYR" to "ringgit Malaysia",
    "MZE" to "escudo Mozambik",
    "MZM" to "metical Mozambik (1980–2006)",
    "MZN" to "metical Mozambik",
    "NAD" to "dollar Namibia",
    "NGN" to "naira Nigeria",
    "NIC" to "cordoba Nicaragua (1988–1991)",
    "NIO" to "cordoba Nicaragua",
    "NLG" to "florin an Izelvroioù",
    "NOK" to "kurunenn Norvegia",
    "NPR" to "roupi Nepal",
    "NZD" to "dollar Zeland-Nevez",
    "OMR" to "rial Oman",
    "PAB" to "balboa Panamá",
    "PEN" to "sol Perou",
    "PES" to "sol Perou (1863–1965)",
    "PGK" to "kina Papoua Ginea-Nevez",
    "PHP" to "peso Filipinez",
    "PKR" to "roupi Pakistan",
    "PLN" to "zloty Polonia",
    "PLZ" to "zloty Polonia (1950–1995)",
    "PTE" to "escudo Portugal",
    "PYG" to "guarani Paraguay",
    "QAR" to "rial Qatar",
    "RHD" to "dollar Rodezia",
    "ROL" to "leu Roumania (1952–2006)",
    "RON" to "leu Roumania",
    "RSD" to "dinar Serbia",
    "RUB" to "roubl Rusia",
    "RUR" to "roubl Rusia (1991–1998)",
    "RWF" to "lur Rwanda",
    "SAR" to "riyal Arabia Saoudat",
    "SBD" to "dollar Inizi Salomon",
    "SCR" to "roupi Sechelez",
    "SDD" to "dinar Soudan (1992–2007)",
    "SDG" to "lur Soudan",
    "SDP" to "lur Soudan (1957–1998)",
    "SEK" to "kurunenn Sveden",
    "SGD" to "dollar Singapour",
    "SHP" to "lur Saint-Helena",
    "SIT" to "tolar Slovenia",
    "SKK" to "kurunenn Slovakia",
    "SLE" to "leone Sierra Leone",
    "SLL" to "leone Sierra Leone (1964—2022)",
    "SOS" to "shilling Somalia",
    "SRD" to "dollar Surinam",
    "SRG" to "florin Surinam",
    "SSP" to "lur Susoudan",
    "STD" to "dobra São Tomé ha Príncipe (1977–2017)",
    "STN" to "dobra São Tomé ha Príncipe",
    "SUR" to "roubl soviedel",
    "SVC" to "colón Salvador",
    "SYP" to "lur Siria",
    "SZL" to "lilangeni Swaziland",
    "THB" to "baht Thailand",
    "TJR" to "roubl Tadjikistan",
    "TJS" to "somoni Tadjikistan",
    "TMM" to "manat Turkmenistan (1993–2009)",
    "TMT" to "manat Turkmenistan",
    "TND" to "dinar Tunizia",
    "TOP" to "paʻanga Tonga",
    "TPE" to "escudo Timor",
    "TRL" to "lur Turkia (1922–2005)",
    "TRY" to "lur Turkia",
    "TTD" to "dollar Trinidad ha Tobago",
    "TWD" to "dollar nevez Taiwan",
    "TZS" to "shilling Tanzania",
    "UAH" to "hryvnia Ukraina",
    "UGS" to "shilling Ouganda (1966–1987)",
    "UGX" to "shilling Ouganda",
    "USD" to "dollar SU",
    "UYP" to "peso Uruguay (1975–1993)",
    "UYU" to "peso Uruguay",
    "UZS" to "som Ouzbekistan",
    "VEB" to "bolivar Venezuela (1871–2008)",
    "VEF" to "bolivar Venezuela (2008–2018)",
    "VES" to "bolivar Venezuela",
    "VND" to "dong Viêt Nam",
    "VNN" to "dong Viêt Nam (1978–1985)",
    "VUV" to "vatu Vanuatu",
    "WST" to "tala Samoa",
    "XAF" to "lur CFA Kreizafrika",
    "XAG" to "arcʼhant",
    "XAU" to "aour",
    "XBA" to "unanenn genaoz europat",
    "XBB" to "unanenn voneiz europat",
    "XBC" to "unanenn jediñ europat (XBC)",
    "XBD" to "unanenn jediñ europat (XBD)",
    "XCD" to "dollar Karib ar reter",
    "XDR" to "gwirioù tennañ arbennik",
    "XEU" to "unanenn jediñ europat",
    "XFO" to "lur aour Frañs",
    "XFU" to "lur Unaniezh etrebroadel an hentoù-houarn",
    "XOF" to "lur CFA Afrika ar Cʼhornôg",
    "XPD" to "palladiom",
    "XPF" to "lur CFP",
    "XPT" to "platin",
    "XTS" to "kod moneiz amprouiñ",
    "XUA" to "unanenn jediñ BAD",
    "XXX" to "moneiz dianav",
    "YDD" to "dinar Yemen",
    "YER" to "rial Yemen",
    "YUM" to "dinar nevez Yougoslavia (1994–2002)",
    "YUN" to "dinar kemmadus Yougoslavia (1990–1992)",
    "YUR" to "dinar adreizhet Yougoslavia (1992–1993)",
    "ZAR" to "rand Suafrika",
    "ZMK" to "kwacha Zambia (1968–2012)",
    "ZMW" to "kwacha Zambia",
    "ZWD" to "dollar Zimbabwe (1980–2008)",
    "ZWL" to "dollar Zimbabwe (2009)",
    "ZWR" to "dollar Zimbabwe (2008)",
  ) }

  val brx: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "ऐन्डोरा का पेसेता",
    "AED" to "इउ.ए.इ दिर्हाम",
    "AFA" to "अफ़ग़ानी 1927–2002",
    "AFN" to "अफ़ग़ानी",
    "ALL" to "आल्बानियानि लेक",
    "AMD" to "आर्मेनियानि द्राम",
    "ANG" to "नेदारलेण्डनि एन्टिलियान गिल्डार",
    "AOA" to "आंगलानि क्वान्जा",
    "AOK" to "एंगोला क्वानज़ा (1977–1990)",
    "AON" to "एंगोला नया क्वानज़ा (1990–20000)",
    "AOR" to "एंगोला क्वानज़ा सुधारीत (1995–1999)",
    "ARA" to "अर्जेण्टीनी ओस्ट्राल",
    "ARP" to "अर्जेण्टीनी पेसो (1983–1985)",
    "ARS" to "आर्जेन्टिनानि पेस’",
    "ATS" to "ऑस्ट्रियन शीलींग",
    "AUD" to "ऑस्ट्रेलियन डॉलर",
    "AWG" to "आरूबान फ्ल’रिन",
    "AZM" to "आज़रबैजानी मनात (1993–2006)",
    "AZN" to "आजेरबाईजाननि मनात",
    "BAD" to "बोसनिया हेर्ज़ेगोविना का दीनार",
    "BAM" to "बसनिया-हार्जेगभिनानि सोलायहाथाव मार्क",
    "BBD" to "बारबाद’सनि डलार",
    "BDT" to "बांगलादेश टका",
    "BEC" to "बेल्जियन फ्राँ कनवर्टीबल",
    "BEF" to "बेल्जियन फ्राँ",
    "BEL" to "बेल्जियन फ्राँ फिनानसीयल (वित्तीय)",
    "BGL" to "बल्गेरियाई हार्ड लेव",
    "BGN" to "बुल्गारियानि लेभ",
    "BHD" to "बाहरैननि दिनार",
    "BIF" to "बुरूण्डीनि फ्रांक",
    "BMD" to "बारमुडानि डलार",
    "BND" to "ब्रुनई डॉलर",
    "BOB" to "बलिभियानि बलिभियान’",
    "BOP" to "बोलिवियाई पेसो",
    "BOV" to "बोलिवियाई डॉलर",
    "BRB" to "ब्रज़ीली नया क्रुज़ेरो (1967–1986)",
    "BRC" to "ब्रज़ीली क्रुज़ाडो",
    "BRE" to "ब्रज़ीली क्रुज़ेरो (190–1993)",
    "BRL" to "ब्राजिलनि रीयाल",
    "BRN" to "ब्रज़ीली नया क्रुज़ाडो",
    "BRR" to "ब्रज़ीली क्रुज़ेरो",
    "BSD" to "बाहामासनि डलार",
    "BTN" to "भुतान का नगुलत्रुम",
    "BUK" to "बर्मी (म्यानमारी) क्याट",
    "BWP" to "बत्स्वानानि पुला",
    "BYB" to "बेलारुसी नया रूबल (194–1999)",
    "BYN" to "बेलारुसनि रूबल",
    "BYR" to "बेलारुसी रूबल (2000–2016)",
    "BZD" to "बेलीज डलार",
    "CAD" to "कानाडानि डलार",
    "CDF" to "कंग’नि फ्रांक",
    "CHE" to "आईरलैण्ड का युरो",
    "CHF" to "सुईस फ्रांक",
    "CHW" to "आईरलैण्ड का फ़्रैंक",
    "CLF" to "चीली का ऊनीदादेस द फोमेंटो",
    "CLP" to "चिलीनि पेस’",
    "CNH" to "चाइनीज युवान ( हाब्रांनि गोजान)",
    "CNY" to "चाइनीज युवान",
    "COP" to "कल’म्बयानि पेस’",
    "COU" to "युनीदाद द वालोर रेआल",
    "CRC" to "क’स्टा रिकानि कल’न",
    "CSD" to "सर्बिया का डीनार",
    "CSK" to "चैकोस्लोवाकिय हार्ड कोरुना",
    "CUC" to "किउबानि सोलायहाथाव पेस’",
    "CUP" to "किउबानि पेस’",
    "CVE" to "केप भेर्देनि एस्कुद’",
    "CYP" to "साईप्रस का पाऊंड",
    "CZK" to "चेखनि करुना",
    "DDM" to "ईस्ट जर्मन ओस्टमार्क",
    "DEM" to "डॉईच मार्क",
    "DJF" to "जिबौतिनि फ्रांक",
    "DKK" to "डेनमार्कनि क्र’न",
    "DOP" to "डमिनिकानि पेस’",
    "DZD" to "आल्जेरियानि दिनार",
    "ECS" to "एक्वादोर सुक्रे",
    "ECV" to "एक्वादोर युनीदाद दे वालोर कॉनस्तांते",
    "EEK" to "एस्टोनियाई क्रून",
    "EGP" to "ईजिप्तनि पाउण्ड",
    "ERN" to "एरित्रीयानि नाकफा",
    "ESA" to "हीस्पानी पेसेता (ए अकाऊँट)",
    "ESB" to "हीस्पानी पेसेता (कनवर्टीबल अकाऊँट)",
    "ESP" to "हीस्पानी पेसेता",
    "ETB" to "इथिय’पियानि बीर्र",
    "EUR" to "इउर’",
    "FIM" to "फीनीश मार्क्का",
    "FJD" to "फ़िजी का डॉलर",
    "FKP" to "फ’कलेण्ड द्वीपफोरनि पाउण्ड",
    "FRF" to "फ्राँसीसी फ्राँ",
    "GBP" to "ब्रिटिश पाउण्ड",
    "GEK" to "जॉर्जिया का कुपोन लारीत",
    "GEL" to "जर्जियानि लारी",
    "GHC" to "घाना चेदी (1979–2007)",
    "GHS" to "घानानि सेदि",
    "GIP" to "जिब्राल्टारनि पाउण्ड",
    "GMD" to "गाम्बियानि दालासि",
    "GNF" to "गिनीयानि फ्रांक",
    "GNS" to "गीनी सीली",
    "GQE" to "ऐक्वाटरी गीनी एक्वेले गीनीआना",
    "GRD" to "युनानी द्राखमा",
    "GTQ" to "गुआतेमालानि क्वेत्जाल",
    "GWE" to "पुरतुगी गीनी का एस्कुएदो",
    "GWP" to "गीनी बिस्साऊ का पेसो",
    "GYD" to "गुयानानि डलार",
    "HKD" to "हंकं डलार",
    "HNL" to "हन्दुरासनि लेम्पिरा",
    "HRD" to "क्रोएशियाई दीनार",
    "HRK" to "क्रवेशियानि कुना",
    "HTG" to "हाईतीनि गूर्द",
    "HUF" to "हांगारीनि फरिन्त",
    "IDR" to "इण्डोनेशियाई रुपिया",
    "IEP" to "आईरीश पौंड",
    "ILP" to "इस्राइली पौंड",
    "ILS" to "इज्राईलनि गोदान शेकेल",
    "INR" to "भारतनि रुपी",
    "IQD" to "ईराकनि दिनार",
    "IRR" to "ईरानी रीयाल",
    "ISK" to "आईसलेण्डनि क्र’ना",
    "ITL" to "इतली का लीरा",
    "JMD" to "जामाईकानि डलार",
    "JOD" to "जर्डाननि दिनार",
    "JPY" to "जापानीज येन",
    "KES" to "केनियानि शिलिं",
    "KGS" to "कीर्गीस्ताननि स’म",
    "KHR" to "कंबोडिया का रिएल",
    "KMF" to "कम’र’नि फ्रांक",
    "KPW" to "साहा करियानि व’न",
    "KRW" to "खोला करियानि व’न",
    "KWD" to "कुवैतनि दिनार",
    "KYD" to "कैमेन द्वीपनि डलार",
    "KZT" to "काजाखस्ताननि तेंगे",
    "LAK" to "लाओस का कीप",
    "LBP" to "लेबान’ननि पाउण्ड",
    "LKR" to "श्री लंका रूपी",
    "LRD" to "लीबेरियानि डलार",
    "LSL" to "लेस’थ’नि लटि",
    "LTL" to "लिथुआनियाई लिता",
    "LTT" to "लिथुआनियाई टालोनास",
    "LUC" to "लुक्ज़मबुर्गी कनवर्टीबल फ्राँ",
    "LUF" to "लुक्ज़मबुर्गी फ्राँ",
    "LUL" to "लुक्ज़मबुर्गी वीत्ती फ्राँ",
    "LVL" to "लाटवियाई लाट्स",
    "LVR" to "लाटवियाई रूबल",
    "LYD" to "लिबियानि दिनार",
    "MAD" to "मरक्क’नि दिर्हाम",
    "MAF" to "मोरक्किय फ्राँ",
    "MDL" to "मल्ड’भानि लिउ",
    "MGA" to "मालागासी आरिआरी",
    "MGF" to "मादागास्करी फ्राँ",
    "MKD" to "मेसेड’नियानि देनार",
    "MLF" to "माली का फ्राँ",
    "MMK" to "म्यानमारी क्याट",
    "MNT" to "मंगलियानि तुग्रीक",
    "MOP" to "माकाउनि पाताका",
    "MRO" to "मौरिटानी ऊगुया (1973–2017)",
    "MRU" to "म’रिशियानि ऊगुया",
    "MTL" to "माल्टी लीरा",
    "MTP" to "माल्टी पौंड",
    "MUR" to "मरिसियानि रुपी",
    "MVR" to "मालदीव द्वीप का रूफिया",
    "MWK" to "मालावीनि क्वाचा",
    "MXN" to "मेक्सिकान पेस’",
    "MXP" to "मेक्सिकन रजती पेसो (1861–1992)",
    "MXV" to "मेक्सिकन युनीदाद द ईनवेरसिओन (युडीआई)",
    "MYR" to "मलेशियन रिंगित",
    "MZE" to "मोज़ांबीक एस्कुएदो",
    "MZM" to "मोज़ांबीक पुराना मेतीकाल",
    "MZN" to "मजाम्बिकनि मेटिकेल",
    "NAD" to "नामिबियानि डलार",
    "NGN" to "नाइजेरियानि नायरा",
    "NIC" to "नीकारागुआई कोर्दोबा",
    "NIO" to "निकारागुआनि कर्द’बा",
    "NLG" to "नेदरलैण्ड गीलडर",
    "NOK" to "नरवैनि क्र’न",
    "NPR" to "नेपाली रुपी",
    "NZD" to "न्यूज़ीलैंड डॉलर",
    "OMR" to "अमाननि रियाल",
    "PAB" to "पानामानि बाल्ब’आ",
    "PEI" to "पेरूवाई ईंटी",
    "PEN" to "पेरूनि सल",
    "PES" to "पेरुवाई सोल (1863–1965)",
    "PGK" to "पापुआ न्यु गीनी का कीना",
    "PHP" to "फ़िलिपीन का पेसो",
    "PKR" to "पाकिस्तानी रुपया",
    "PLN" to "पलेण्डनि ज्ल’टी",
    "PTE" to "पुरतुगी एस्कुदो",
    "PYG" to "पारागुवेनि गुआरानी",
    "QAR" to "कातारनि रियाल",
    "RHD" to "रोडेशियाई डॉलर",
    "ROL" to "रोमानियाई पुरानी ल",
    "RON" to "रमानियानि लिउ",
    "RSD" to "सार्बियानि दिनार",
    "RUB" to "रासियानि रूबल",
    "RWF" to "रुवान्दानि फ्रांक",
    "SAR" to "साउदि रियाल",
    "SBD" to "सोलोमन द्वीप का डॉलर",
    "SCR" to "सैशेल्लेसनि रूपी",
    "SDD" to "सुदानी पुराना डॉलर",
    "SDG" to "सुदाननि पाउण्ड",
    "SDP" to "सुदानी पुराना पौंड",
    "SEK" to "स्वीडेननि क्र’ना",
    "SGD" to "सिंगापुर डॉलर",
    "SHP" to "सैन्ट हेलेनानि पाउण्ड",
    "SIT" to "स्लोवेनियाई तोलार",
    "SKK" to "स्लोवाकी कोरुना",
    "SLE" to "सीयेर्रा लिय’ननि लीयन",
    "SLL" to "सीयेर्रा लिय’ननि लीयन (1964—2022)",
    "SOS" to "समालियानि शिलिं",
    "SRD" to "सुरीनामनि डलार",
    "SRG" to "सुरीनाम गील्डर",
    "SSP" to "खोला सुदानारि पाउण्ड",
    "STD" to "साँव तोमे एवं प्रीन्सीपे का डोब्रा (1977–2017)",
    "STN" to "साऊ तमे आरो प्रिन्सिपनि दब्रा",
    "SUR" to "सोवियत रूबल",
    "SVC" to "एल सालवादर कोलोन",
    "SYP" to "सीरियानि पाउण्ड",
    "SZL" to "स्वाजी लीलांगेनी",
    "THB" to "थाई बाह्ट",
    "TJR" to "ताजीक़ीस्तानी रूबल",
    "TJS" to "ताजिकिस्ताननि सम’नि",
    "TMM" to "तुर्कमेनीस्तानी मानाट",
    "TMT" to "तुर्कमेनीस्ताननि मानात",
    "TND" to "त्सुनीसीयानि दिनार",
    "TOP" to "टॉंगा पाईंगा",
    "TPE" to "तीमोरी एस्कुदो",
    "TRL" to "तुर्की लीरा",
    "TRY" to "तुर्कीनि लीरा",
    "TTD" to "त्रिनिदाद आरो तबाग’ डलार",
    "TWD" to "ताईवाननि गोदान डलार",
    "TZS" to "तान्जानियानि शिलिं",
    "UAH" to "युक्रेननि ह्रीभनिया",
    "UAK" to "युक्रेनी कार्बोवानेत्ज़",
    "UGS" to "युगाँडाई शीलींग (1996–1987)",
    "UGX" to "उगाण्डानि शिलिं",
    "USD" to "इउ.एस डलार",
    "USN" to "अमरिकी डॉलर (अगले दिन का)",
    "USS" to "अमरिकी डॉलर (इसी दिन का)",
    "UYI" to "ऊरुगुए का पेसो आन ऊनीदादोस ईंदेक्सादास",
    "UYP" to "ऊरुगुए का पेसो (1975–1993)",
    "UYU" to "उरुगुवेनि पेस’",
    "UZS" to "उजबेकिस्ताननि स’म",
    "VEB" to "वेनेज़ुएलाई बोलिवार (1871–2008)",
    "VEF" to "वेनेज़ुएलाई बोलिवार (2008–2018)",
    "VES" to "भेनेजुवेलानि बलिभार",
    "VND" to "वीयतनामी डॉंग",
    "VUV" to "वनुआटु वटु",
    "WST" to "वेस्टर्न समोआ ताला",
    "XAF" to "मिरु आफ्रिकानि सि.एफ.ए फ्रांक",
    "XAG" to "रजत",
    "XAU" to "सोना",
    "XBA" to "एक्यु",
    "XBB" to "एम्यु",
    "XBC" to "यूरोपी एकाऊंट का युनीट (एक्स बी सी)",
    "XBD" to "यूरोपी एकाऊंट का युनीट (एक्स बी डी)",
    "XCD" to "सानजा केरिबियान डलार",
    "XDR" to "स्पेशियल ड्राईंग राईट्स",
    "XEU" to "यूरोपी मुद्रा (एक्यु)",
    "XFO" to "फ्रानसीसी सुवर्ण फ्राँ",
    "XFU" to "फ्रानसीसी युआईसी फ्राँ",
    "XOF" to "सोनाब आफ्रिकानि सि.एफ.ए फ्रांक",
    "XPD" to "पैलेडियम",
    "XPF" to "फ्रानसीसी फेदेरेशनी फ्राँ",
    "XPT" to "प्लैटीनम",
    "XRE" to "रीनैट फंड्स",
    "XTS" to "टेस्टींग करनसी कोड",
    "XXX" to "मिथियै रां",
    "YDD" to "यमनी दीनार",
    "YER" to "येमेननि रियाल",
    "YUD" to "युगोस्लावी हार्ड दीनार",
    "YUM" to "युगोस्लावी नोवीय (नये) दीनार",
    "YUN" to "युगोस्लावी कनवर्टीबल दीनार",
    "ZAR" to "खोला आफ्रिकानि राण्ड",
    "ZMK" to "ज़ाम्बियाई क्वाचा (1968–2012)",
    "ZMW" to "जाम्बियानि क्वाचा",
    "ZRN" to "ज़ाईरी नये ज़ाईर",
    "ZRZ" to "ज़ाईरी ज़ाईर",
    "ZWD" to "ज़ीम्बाबवेई डॉलर",
  ) }

  val bs: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorska pezeta",
    "AED" to "Dirham Ujedinjenih Arapskih Emirata",
    "AFA" to "Avganistanski avgani (1927–2002)",
    "AFN" to "Afganistanski afgan",
    "ALK" to "Albanski lek (1946–1965)",
    "ALL" to "Albanski lek",
    "AMD" to "Armenski dram",
    "ANG" to "Holandskoantilski gulden",
    "AOA" to "Angolska kvanza",
    "AOK" to "Angolijska kvanza (1977–1991)",
    "AON" to "Angolijska nova kvanza (1990–2000)",
    "AOR" to "Angolijska kvanza reajustado (1995–1999)",
    "ARA" to "Argentinski austral",
    "ARL" to "argentinskih pezosa leja",
    "ARM" to "argentinskih pezosa monedo nacional",
    "ARP" to "Argentinski pezo (1983–1985)",
    "ARS" to "Argentinski pezos",
    "ATS" to "Austrijski šiling",
    "AUD" to "Australijski dolar",
    "AWG" to "Arubanski florin",
    "AZM" to "Azerbejdžanski manat (1993–2006)",
    "AZN" to "Azerbejdžanski manat",
    "BAD" to "Bosanskohercegovački dinar",
    "BAM" to "Bosanskohercegovačka konvertibilna marka",
    "BAN" to "Bosanskohercegovački novi dinar",
    "BBD" to "Barbadoski dolar",
    "BDT" to "Bangladeška taka",
    "BEC" to "Belgijski frank (konvertibilni)",
    "BEF" to "Belgijski franak",
    "BEL" to "Belgijski frank (finansijski)",
    "BGL" to "Bugarski tvrdi lev",
    "BGM" to "Bugarski socijalistički lev",
    "BGN" to "Bugarski lev",
    "BGO" to "Bugarski lev (1879–1952)",
    "BHD" to "Bahreinski dinar",
    "BIF" to "Burundski franak",
    "BMD" to "Bermudski dolar",
    "BND" to "Brunejski dolar",
    "BOB" to "Bolivijski boliviano",
    "BOL" to "Bolivijski boliviano (1863–1963)",
    "BOP" to "Bolivijski pezo",
    "BOV" to "Bolivijski mvdol",
    "BRB" to "Brazilski kruzeiro novo (1967–1986)",
    "BRC" to "Brazilski kruzado (1986–1989)",
    "BRE" to "Brazilski kruzeiro (1990–1993)",
    "BRL" to "Brazilski real",
    "BRN" to "Brazilski kruzado novo (1989–1990)",
    "BRR" to "Brazilski kruzeiro (1993–1994)",
    "BRZ" to "Brazilski kruzeiro (1942–1967)",
    "BSD" to "Bahamski dolar",
    "BTN" to "Butanski ngultrum",
    "BUK" to "Burmanski kjat",
    "BWP" to "Bocvanska pula",
    "BYB" to "Beloruska nova rublja (1994–1999)",
    "BYN" to "Bjeloruska rublja",
    "BYR" to "Bjeloruska rublja (2000–2016)",
    "BZD" to "Belizeanski dolar",
    "CAD" to "Kanadski dolar",
    "CDF" to "Kongoanski franak",
    "CHE" to "WIR Evro",
    "CHF" to "Švicarski franak",
    "CHW" to "WIR franak",
    "CLE" to "Čileanski eskudo",
    "CLF" to "Čileanski unidades de fomento",
    "CLP" to "Čileanski pezos",
    "CNH" to "Kineski juan (izvanteritorijalni)",
    "CNX" to "Dolar kineske narodne banke",
    "CNY" to "Kineski juan",
    "COP" to "Kolumbijski pezos",
    "COU" to "Kolumbijski Unidade real de valor",
    "CRC" to "Kostarikanski kolon",
    "CSD" to "Srpski dinar (2002–2006)",
    "CSK" to "Čehoslovačka tvrda koruna",
    "CUC" to "Kubanski konvertibilni pezos",
    "CUP" to "kubanski pezos",
    "CVE" to "Zelenortski eskudo",
    "CYP" to "Kipratska funta",
    "CZK" to "Češka kruna",
    "DDM" to "Istočnoevropska marka",
    "DEM" to "Nemačka marka",
    "DJF" to "Džibutski franak",
    "DKK" to "Danska kruna",
    "DOP" to "Dominikanski pezos",
    "DZD" to "Alžirski dinar",
    "ECS" to "Ekvadorijski sukr",
    "ECV" to "Ekvadorski unidad de valor konstantin (UVC)",
    "EEK" to "Estonska kruna",
    "EGP" to "Egipatska funta",
    "ERN" to "Eritrejska nakfa",
    "ESA" to "Španska pezeta (račun) ESA",
    "ESB" to "Španska pezeta (konvertibilni račun)",
    "ESP" to "Španska pezeta",
    "ETB" to "Etiopski bir",
    "EUR" to "Euro",
    "FIM" to "Finska marka",
    "FJD" to "Fidžijski dolar",
    "FKP" to "Folklandska funta",
    "FRF" to "Francuski franak",
    "GBP" to "Britanska funta",
    "GEK" to "Gruzijski kupon larit",
    "GEL" to "Gruzijski lari",
    "GHC" to "Ganijski cedi (1979–2007)",
    "GHS" to "Ganski cedi",
    "GIP" to "Gibraltarska funta",
    "GMD" to "Gambijski dalasi",
    "GNF" to "Gvinejski franak",
    "GNS" to "Gvinejski sili",
    "GQE" to "Evatorijalna gvineja ekvele",
    "GRD" to "Drahma",
    "GTQ" to "Gvatemalski kecal",
    "GWE" to "Portugalska Gvineja eskudo",
    "GWP" to "Gvineja bisao pezo",
    "GYD" to "Gvajanski dolar",
    "HKD" to "Honkonški dolar",
    "HNL" to "Honduraška lempira",
    "HRD" to "Hrvatski dinar",
    "HRK" to "Hrvatska kuna",
    "HTG" to "Haićanski gurd",
    "HUF" to "Mađarska forinta",
    "IDR" to "Indonežanska rupija",
    "IEP" to "Irska funta",
    "ILP" to "Izraelska funta",
    "ILR" to "stari izraelski šekeli",
    "ILS" to "Izraelski novi šekel",
    "INR" to "Indijska rupija",
    "IQD" to "Irački dinar",
    "IRR" to "Iranski rijal",
    "ISJ" to "stara islandska kruna",
    "ISK" to "Islandska kruna",
    "ITL" to "Italijanska lira",
    "JMD" to "Jamajčanski dolar",
    "JOD" to "Jordanski dinar",
    "JPY" to "Japanski jen",
    "KES" to "Kenijski šiling",
    "KGS" to "Kirgistanski som",
    "KHR" to "Kambodžanski rijel",
    "KMF" to "Komorski franak",
    "KPW" to "Sjevernokorejski von",
    "KRH" to "Južno-korejski hvan (1953–1962)",
    "KRO" to "Južno-korejski Von (1945–1953)",
    "KRW" to "Južnokorejski von",
    "KWD" to "Kuvajtski dinar",
    "KYD" to "Kajmanski dolar",
    "KZT" to "Kazahstanski tenge",
    "LAK" to "Laoski kip",
    "LBP" to "Libanska funta",
    "LKR" to "Šrilankanska rupija",
    "LRD" to "Liberijski dolar",
    "LSL" to "Lesotski loti",
    "LTL" to "Litvanski litas",
    "LTT" to "Litvanski talonas",
    "LUC" to "Luksemburški konvertibilni franak",
    "LUF" to "Luksemburški franak",
    "LUL" to "Luksemburški finansijski franak",
    "LVL" to "Letonski lats",
    "LVR" to "Latvijska rublja",
    "LYD" to "Libijski dinar",
    "MAD" to "Marokanski dirham",
    "MAF" to "Marokanski franak",
    "MCF" to "Monegaskaški franak",
    "MDC" to "Moldavski kupon",
    "MDL" to "Moldavski lej",
    "MGA" to "Malagaški arijari",
    "MGF" to "Malagasijski franak",
    "MKD" to "Makedonski denar",
    "MKN" to "Makedonski denar (1992–1993)",
    "MLF" to "Malijanski franak",
    "MMK" to "Mijanmarski kjat",
    "MNT" to "Mongolski tugrik",
    "MOP" to "Makaonska pataka",
    "MRO" to "Mauritanijska ugvija (1973–2017)",
    "MRU" to "mauritanijska ugvija",
    "MTL" to "Malteška lira",
    "MTP" to "Malteška funta",
    "MUR" to "Mauricijska rupija",
    "MVR" to "Maldivska rufija",
    "MWK" to "Malavijska kvača",
    "MXN" to "Meksički pezos",
    "MXP" to "Meksijski srebrno pezo (1861–1992)",
    "MXV" to "Meksijski unidad de inverzion",
    "MYR" to "Malezijski ringit",
    "MZE" to "Mozambijski eskudo",
    "MZM" to "Mozambijski metikal (1980–2006)",
    "MZN" to "Mozambijski metikal",
    "NAD" to "Namibijski dolar",
    "NGN" to "Nigerijska naira",
    "NIC" to "Nikaragvanška kordoba (1988–1991)",
    "NIO" to "Nikaragvanska kordoba",
    "NLG" to "Holandski gulden",
    "NOK" to "Norveška kruna",
    "NPR" to "Nepalska rupija",
    "NZD" to "Novozelandski dolar",
    "OMR" to "Omanski rijal",
    "PAB" to "Panamska balboa",
    "PEI" to "Peruvijski inti",
    "PEN" to "Peruanski sol",
    "PES" to "Peruvijski sol (1863–1965)",
    "PGK" to "Kina Papue Nove Gvineje",
    "PHP" to "Filipinski pezos",
    "PKR" to "Pakistanska rupija",
    "PLN" to "Poljski zlot",
    "PLZ" to "Poljski zloti (1950–1995)",
    "PTE" to "Portugalski eskudo",
    "PYG" to "Paragvajski gvarani",
    "QAR" to "Katarski rijal",
    "RHD" to "Rodizijski dolar",
    "ROL" to "Rumunski leu (1952–2006)",
    "RON" to "Rumunski lej",
    "RSD" to "Srpski dinar",
    "RUB" to "Ruska rublja",
    "RUR" to "Ruska rublja (1991–1998)",
    "RWF" to "Ruandski franak",
    "SAR" to "Saudijski rijal",
    "SBD" to "Solomonski dolar",
    "SCR" to "Sejšelska rupija",
    "SDD" to "Sudanski dinar (1992–2007)",
    "SDG" to "Sudanska funta",
    "SDP" to "Sudanska funta (1957–1998)",
    "SEK" to "Švedska kruna",
    "SGD" to "Singapurski dolar",
    "SHP" to "Svetohelenska funta",
    "SIT" to "Slovenski tolar",
    "SKK" to "Slovačka kruna",
    "SLE" to "Sijeraleonski leone",
    "SLL" to "Sijeraleonski leone (1964—2022)",
    "SOS" to "Somalski šiling",
    "SRD" to "Surinamski dolar",
    "SRG" to "Surinamski gilder",
    "SSP" to "Južnosudanska funta",
    "STD" to "Dobra Sao Toma i Principa (1977–2017)",
    "STN" to "Dobra Sao Toma i Principa",
    "SUR" to "Sovjetska rublja",
    "SVC" to "Salvadorski kolon",
    "SYP" to "Sirijska funta",
    "SZL" to "Svazilendski lilangeni",
    "THB" to "Tajlandski baht",
    "TJR" to "Tadžakistanska rublja",
    "TJS" to "Tadžikistanski somoni",
    "TMM" to "Turkmenistanski manat (1993–2009)",
    "TMT" to "Turkmenistanski manat",
    "TND" to "Tuniški dinar",
    "TOP" to "Tonganska panga",
    "TPE" to "Timorški eskudo",
    "TRL" to "Turska lira (1922–2005)",
    "TRY" to "Turska lira",
    "TTD" to "Trinidadtobaški dolar",
    "TWD" to "Novi tajvanski dolar",
    "TZS" to "Tanzanijski šiling",
    "UAH" to "Ukrajinska hrivnja",
    "UAK" to "Ukrajinski karbovaneti",
    "UGS" to "Ugandijski šiling (1966–1987)",
    "UGX" to "Ugandski šiling",
    "USD" to "Američki dolar",
    "USN" to "SAD dolar (sledeći dan)",
    "USS" to "SAD dolar (isti dan)",
    "UYI" to "Urugvajski pezo en unidades indeksades",
    "UYP" to "Urugvajski pezo (1975–1993)",
    "UYU" to "Urugvajski pezos",
    "UZS" to "Uzbekistanski som",
    "VEB" to "Venecuelanski bolivar (1871–2008)",
    "VEF" to "venecuelanski bolivar (2008–2018)",
    "VES" to "Venecuelanski bolivar",
    "VND" to "Vijetnamski dong",
    "VNN" to "Vijetnamski dong (1978–1985)",
    "VUV" to "Vanuatski vatu",
    "WST" to "Samoanska tala",
    "XAF" to "Centralnoafrički franak (CFA)",
    "XAG" to "Srebro",
    "XAU" to "Zlato",
    "XBA" to "Evropska kompozitna jedinica",
    "XBB" to "Evropska novčana jedinica",
    "XBC" to "Evropska jedinica računa (XBC)",
    "XBD" to "Evropska jedinica računa (XBD)",
    "XCD" to "Istočnokaripski dolar",
    "XDR" to "Posebna prava",
    "XEU" to "Evropska valutna jedinica",
    "XFO" to "Francuski zlatni frank",
    "XFU" to "Francuski UIC-frank",
    "XOF" to "Zapadnoafrički franak (CFA)",
    "XPD" to "Paladijum",
    "XPF" to "Franak (CFP)",
    "XPT" to "Platina",
    "XRE" to "RINET fondovi",
    "XTS" to "Kod testirane valute",
    "XXX" to "Nepoznata valuta",
    "YDD" to "Jemenski dinar",
    "YER" to "Jemenski rijal",
    "YUD" to "Jugoslovenski tvrdi dinar",
    "YUM" to "Jugoslovenski novi dinar",
    "YUN" to "Jugoslovenski konvertibilni dinar",
    "YUR" to "Jugoslovenski reformirani dinar",
    "ZAL" to "Južnoafrički rand (finansijski)",
    "ZAR" to "Južnoafrički rand",
    "ZMK" to "Zambijska kvača (1968–2012)",
    "ZMW" to "Zambijska kvača",
    "ZRN" to "Zairski novi zair (1993–1998)",
    "ZRZ" to "Zairski zair (1971–1993)",
    "ZWD" to "Zimbabvejski dolar (1980–2008)",
    "ZWL" to "Zimbabvejski dolar (2009)",
    "ZWR" to "Zimbabvejski dolar (2008)",
  ) }

  val bs_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Андорска пезета",
    "AED" to "Уједињени арапски емирати дирхам",
    "AFA" to "Авганистански авган (1927–2002)",
    "AFN" to "Афганистански афгани",
    "ALL" to "Албански лек",
    "AMD" to "Арменски драм",
    "ANG" to "Холандски антили гилдер",
    "AOA" to "Анголска кванза",
    "AOK" to "анголијска кванза (1977–1990)",
    "AON" to "Анголијска нова кванза (1990–2000)",
    "AOR" to "Анголска кванза реађустадо (1995–1999)",
    "ARA" to "Аргентински аустрал",
    "ARP" to "аргентински пезо (1983–1985)",
    "ARS" to "Аргентински пезос",
    "ATS" to "Аустријски шилинг",
    "AUD" to "Аустралијски долар",
    "AWG" to "Арубански флорин",
    "AZM" to "Азербејџански манат (1993–2006)",
    "AZN" to "Азербејџански манат",
    "BAD" to "Босанско-Херцеговачки динар",
    "BAM" to "Конвертибилна марка",
    "BBD" to "Барбадоски долар",
    "BDT" to "Бангладешка така",
    "BEC" to "Белгијски франак (конвертибилни)",
    "BEF" to "Белгијски франак",
    "BEL" to "Белгијски франак (финансијски)",
    "BGL" to "Бугарски тврди лев",
    "BGN" to "Бугарски лев",
    "BHD" to "Бахреински динар",
    "BIF" to "Бурундски франак",
    "BMD" to "Бермудски долар",
    "BND" to "Брунејски долар",
    "BOB" to "Боливијски боливиано",
    "BOP" to "Боливијски пезо",
    "BOV" to "Боливијски мвдол",
    "BRB" to "Бразилски нови крузеиро (1967–1986)",
    "BRC" to "Бразилијски крузадо",
    "BRE" to "Бразилски крузеиро (1990–1993)",
    "BRL" to "Бразилски реал",
    "BRN" to "Бразилијски нови крузадо",
    "BRR" to "Бразилски крузеиро",
    "BSD" to "Бахамски долар",
    "BTN" to "Бутански нгултрум",
    "BUK" to "Бурмански кјат",
    "BWP" to "Боцванска пула",
    "BYB" to "Белоруска нова рубља (1994–1999)",
    "BYN" to "Белоруска рубља",
    "BYR" to "Белоруска рубља (2000–2016)",
    "BZD" to "Белизеански долар",
    "CAD" to "Канадски долар",
    "CDF" to "Конгоански франак",
    "CHE" to "WIR евро",
    "CHF" to "Швајцарски франак",
    "CHW" to "WIR франак",
    "CLF" to "Чилеовски унидадес се фоменто",
    "CLP" to "Чилеански пезос",
    "CNH" to "Кинески јуан (острвски)",
    "CNY" to "Кинески јуан",
    "COP" to "Колумбијски пезос",
    "COU" to "Унидад де валоршки реал",
    "CRC" to "Костарикански колон",
    "CSD" to "Стари српски динар",
    "CSK" to "Чехословачка тврда круна",
    "CUC" to "кубански конвертибилни пезос",
    "CUP" to "Кубански пезос",
    "CVE" to "Зеленортски ескудо",
    "CYP" to "Кипарска фунта",
    "CZK" to "Чешка круна",
    "DDM" to "Источно-немачка марка",
    "DEM" to "Немачка марка",
    "DJF" to "Џибутски франак",
    "DKK" to "Данска круна",
    "DOP" to "Доминикански пезос",
    "DZD" to "Алжирски динар",
    "ECS" to "Еквадорски сакр",
    "ECV" to "Еквадорски унидад де валор константе",
    "EEK" to "Естонска кроон",
    "EGP" to "Египатска фунта",
    "ERN" to "Еритрејска накфа",
    "ESA" to "Шпанска пезета (рачун)",
    "ESB" to "Шпанска пезета (конвертибилнирачун)",
    "ESP" to "Шпанска пезета",
    "ETB" to "Етиопијски бир",
    "EUR" to "Евро",
    "FIM" to "Финска марка",
    "FJD" to "Фиџи долар",
    "FKP" to "Фолкландска фунта",
    "FRF" to "Француски франак",
    "GBP" to "Британска фунта",
    "GEK" to "Грузијски купон ларит",
    "GEL" to "Грузијски лари",
    "GHC" to "Гански цеди (1979–2007)",
    "GHS" to "Гански цеди",
    "GIP" to "Гибралтаска фунта",
    "GMD" to "Гамбијски даласи",
    "GNF" to "Гвинејски франак",
    "GNS" to "Гвинејски сили",
    "GQE" to "Екваторијално-гвинејски еквеле",
    "GRD" to "Грчка драхма",
    "GTQ" to "Гватемалски квецал",
    "GWE" to "португалска гвинеја ескудо",
    "GWP" to "Гвинеја Бисао Пезо",
    "GYD" to "Гвајански долар",
    "HKD" to "Хонгконшки долар",
    "HNL" to "Хондурашка лемпира",
    "HRD" to "Хрватски динар",
    "HRK" to "Хрватска куна",
    "HTG" to "Хаићански гурд",
    "HUF" to "Мађарска форинта",
    "IDR" to "Индонежанска рупија",
    "IEP" to "Ирска фунта",
    "ILP" to "Израелска фунта",
    "ILR" to "стари израелски шекели",
    "ILS" to "Израелски нови шекел",
    "INR" to "Индијска рупија",
    "IQD" to "Ирачки динар",
    "IRR" to "Ирански ријал",
    "ISJ" to "стара исландска круна",
    "ISK" to "Исландска круна",
    "ITL" to "Италијанска лира",
    "JMD" to "Јамајски долар",
    "JOD" to "Јордански динар",
    "JPY" to "Јапански јен",
    "KES" to "Кенијски шилинг",
    "KGS" to "Киргистански сом",
    "KHR" to "Камбоџански ријел",
    "KMF" to "Коморски франак",
    "KPW" to "Севернокорејски вон",
    "KRW" to "Јужнокорејски вон",
    "KWD" to "Кувајтски динар",
    "KYD" to "Кајмански долар",
    "KZT" to "Казахстански тенге",
    "LAK" to "Лаоски кип",
    "LBP" to "Либанска фунта",
    "LKR" to "Шриланканска рупија",
    "LRD" to "Либеријски долар",
    "LSL" to "Лесото лоти",
    "LTL" to "Литвански литас",
    "LTT" to "Литвански талонас",
    "LUC" to "Луксембуршки конвертибилни франак",
    "LUF" to "Луксембуршки франак",
    "LUL" to "Луксембуршки финансијски франак",
    "LVL" to "Латвијски лати",
    "LVR" to "атвијска рубља",
    "LYD" to "Либијски динар",
    "MAD" to "Марокански дирхам",
    "MAF" to "Марокански франак",
    "MDL" to "Молдавски леј",
    "MGA" to "Мадагаскарски аријари",
    "MGF" to "Малагасијски франак",
    "MKD" to "Македонски денар",
    "MLF" to "Малијански франак",
    "MMK" to "Мијанмарски кјат",
    "MNT" to "Монголски тугрик",
    "MOP" to "Макаоска патака",
    "MRO" to "Мауританијска угвија (1973–2017)",
    "MRU" to "Мауританска огија",
    "MTL" to "Малтешка лира",
    "MTP" to "Малтешка фунта",
    "MUR" to "Маурицијска рупија",
    "MVR" to "Малдивска руфија",
    "MWK" to "Малавијска квача",
    "MXN" to "Мексички пезос",
    "MXP" to "Мексички сребрни пезо (1861–1992)",
    "MXV" to "Мексички унидад де инверсион (UDI)",
    "MYR" to "Малезијски рингит",
    "MZE" to "Мозамбијски ескудо",
    "MZM" to "Стари мозамбијски метикал",
    "MZN" to "Мозамбијски метикал",
    "NAD" to "Намибијски долар",
    "NGN" to "Нигеријска наира",
    "NIC" to "Никарагванска кордоба",
    "NIO" to "Никарагванска златна кордоба",
    "NLG" to "Холандски гулден",
    "NOK" to "Норвешка круна",
    "NPR" to "Непалска рупија",
    "NZD" to "Новозеландски долар",
    "OMR" to "Омански ријал",
    "PAB" to "Панамска балбоа",
    "PEI" to "Перуански инти",
    "PEN" to "Перуански сол",
    "PES" to "Перуански сол (1863–1965)",
    "PGK" to "Папуанска кина",
    "PHP" to "Филипински пезос",
    "PKR" to "Пакистанска рупија",
    "PLN" to "Пољски злот",
    "PLZ" to "Пољски злоти (1950–1995)",
    "PTE" to "Португалски ескудо",
    "PYG" to "Парагвајски гварани",
    "QAR" to "Катарски ријал",
    "RHD" to "Родејскидолар",
    "ROL" to "Стари румунски љу",
    "RON" to "Румунски леј",
    "RSD" to "Српски динар",
    "RUB" to "Руска рубља",
    "RUR" to "Руска рубља (1991–1998)",
    "RWF" to "Руандски франак",
    "SAR" to "Саудијски ријал",
    "SBD" to "Соломонски долар",
    "SCR" to "Сејшелска рупија",
    "SDD" to "Стари судански динар",
    "SDG" to "Суданска фунта",
    "SDP" to "Стара суданска фунта",
    "SEK" to "Шведска круна",
    "SGD" to "Сингапурски долар",
    "SHP" to "Света Јелена фунта",
    "SIT" to "Словеначки толар",
    "SKK" to "Словачка круна",
    "SLE" to "Сијералеонски леоне",
    "SLL" to "Сијералеонски леоне (1964—2022)",
    "SOS" to "Сомалијски шилинг",
    "SRD" to "Суринамски долар",
    "SRG" to "Суринамски гилдер",
    "SSP" to "Јужносуданска фунта",
    "STD" to "Сао Томе и Принципе добра (1977–2017)",
    "STN" to "Сао Томе и Принципе добра",
    "SUR" to "Совјетска рубља",
    "SVC" to "Салвадорски колон",
    "SYP" to "Сиријска фунта",
    "SZL" to "Свазилендски лилангени",
    "THB" to "Тајски бахт",
    "TJR" to "Таџихистанска рубља",
    "TJS" to "Таџикистански сомони",
    "TMM" to "Туркменистански манат (1993–2009)",
    "TMT" to "Туркменистански манат",
    "TND" to "Туниски динар",
    "TOP" to "Тонгоанска панга",
    "TPE" to "Тиморшки ескудо",
    "TRL" to "Стара турска лира",
    "TRY" to "Турска лира",
    "TTD" to "Тринидад-тобагошки долар",
    "TWD" to "Нови тајвански долар",
    "TZS" to "Танзанијски шилинг",
    "UAH" to "Украјинска хривња",
    "UAK" to "Украјински карбованети",
    "UGS" to "Угандски шилинг (1966–1987)",
    "UGX" to "Угандски шилинг",
    "USD" to "Амерички долар",
    "USN" to "САД долар (следећи дан)",
    "USS" to "САД долар (исти дан)",
    "UYI" to "Уругвајски пезо ен унидадес индексадас",
    "UYP" to "Уругвајски пезо (1975–1993)",
    "UYU" to "Уругвајски пезос",
    "UZS" to "Узбекистански сом",
    "VEB" to "Венецуелански боливар (1871–2008)",
    "VEF" to "Венецуелански боливар (2008–2018)",
    "VES" to "Венецуелански боливар",
    "VND" to "Вијетнамски донг",
    "VUV" to "Вануатски вату",
    "WST" to "Самоанска тала",
    "XAF" to "CFA франак BEAC",
    "XAG" to "Сребро",
    "XAU" to "Злато",
    "XBA" to "Европска композитна јединица",
    "XBB" to "Европска новчана јединица",
    "XBC" to "Европска јединица рачуна (XBC)",
    "XBD" to "Европска јединица рачуна (XBD)",
    "XCD" to "Источно-карибски долар",
    "XDR" to "Посебна цртаћа права",
    "XEU" to "Европска валутна јединица",
    "XFO" to "Француски златни франак",
    "XFU" to "Француски UIC-франак",
    "XOF" to "CFA франак BCEAO",
    "XPD" to "Паладијум",
    "XPF" to "CFP франак",
    "XPT" to "Платина",
    "XRE" to "RINET фонд",
    "XTS" to "Код тестиране валуте",
    "XXX" to "Непозната или неважећа валута",
    "YDD" to "Јеменски динар",
    "YER" to "Јеменски ријал",
    "YUD" to "Југословенски тврди динар",
    "YUM" to "Југословенски нови динар",
    "YUN" to "Југословенски конвертибилни динар",
    "ZAL" to "Јужно-афрички ранд (финансијски)",
    "ZAR" to "Јужноафрички ранд",
    "ZMK" to "Замбијска квача (1968–2012)",
    "ZMW" to "Замбијска квача",
    "ZRN" to "Заирски нови заир",
    "ZRZ" to "Заирски заир",
    "ZWD" to "Зимбабвејски долар",
    "ZWL" to "Зимбабвеански долар (2009)",
    "ZWR" to "Зимбабвеански долар (2008)",
  ) }

  val bs_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorska pezeta",
    "AED" to "Dirham Ujedinjenih Arapskih Emirata",
    "AFA" to "Avganistanski avgani (1927–2002)",
    "AFN" to "Afganistanski afgan",
    "ALK" to "Albanski lek (1946–1965)",
    "ALL" to "Albanski lek",
    "AMD" to "Armenski dram",
    "ANG" to "Holandskoantilski gulden",
    "AOA" to "Angolska kvanza",
    "AOK" to "Angolijska kvanza (1977–1991)",
    "AON" to "Angolijska nova kvanza (1990–2000)",
    "AOR" to "Angolijska kvanza reajustado (1995–1999)",
    "ARA" to "Argentinski austral",
    "ARL" to "argentinskih pezosa leja",
    "ARM" to "argentinskih pezosa monedo nacional",
    "ARP" to "Argentinski pezo (1983–1985)",
    "ARS" to "Argentinski pezos",
    "ATS" to "Austrijski šiling",
    "AUD" to "Australijski dolar",
    "AWG" to "Arubanski florin",
    "AZM" to "Azerbejdžanski manat (1993–2006)",
    "AZN" to "Azerbejdžanski manat",
    "BAD" to "Bosanskohercegovački dinar",
    "BAM" to "Bosanskohercegovačka konvertibilna marka",
    "BAN" to "Bosanskohercegovački novi dinar",
    "BBD" to "Barbadoski dolar",
    "BDT" to "Bangladeška taka",
    "BEC" to "Belgijski frank (konvertibilni)",
    "BEF" to "Belgijski franak",
    "BEL" to "Belgijski frank (finansijski)",
    "BGL" to "Bugarski tvrdi lev",
    "BGM" to "Bugarski socijalistički lev",
    "BGN" to "Bugarski lev",
    "BGO" to "Bugarski lev (1879–1952)",
    "BHD" to "Bahreinski dinar",
    "BIF" to "Burundski franak",
    "BMD" to "Bermudski dolar",
    "BND" to "Brunejski dolar",
    "BOB" to "Bolivijski boliviano",
    "BOL" to "Bolivijski boliviano (1863–1963)",
    "BOP" to "Bolivijski pezo",
    "BOV" to "Bolivijski mvdol",
    "BRB" to "Brazilski kruzeiro novo (1967–1986)",
    "BRC" to "Brazilski kruzado (1986–1989)",
    "BRE" to "Brazilski kruzeiro (1990–1993)",
    "BRL" to "Brazilski real",
    "BRN" to "Brazilski kruzado novo (1989–1990)",
    "BRR" to "Brazilski kruzeiro (1993–1994)",
    "BRZ" to "Brazilski kruzeiro (1942–1967)",
    "BSD" to "Bahamski dolar",
    "BTN" to "Butanski ngultrum",
    "BUK" to "Burmanski kjat",
    "BWP" to "Bocvanska pula",
    "BYB" to "Beloruska nova rublja (1994–1999)",
    "BYN" to "Bjeloruska rublja",
    "BYR" to "Bjeloruska rublja (2000–2016)",
    "BZD" to "Belizeanski dolar",
    "CAD" to "Kanadski dolar",
    "CDF" to "Kongoanski franak",
    "CHE" to "WIR Evro",
    "CHF" to "Švicarski franak",
    "CHW" to "WIR franak",
    "CLE" to "Čileanski eskudo",
    "CLF" to "Čileanski unidades de fomento",
    "CLP" to "Čileanski pezos",
    "CNH" to "Kineski juan (izvanteritorijalni)",
    "CNX" to "Dolar kineske narodne banke",
    "CNY" to "Kineski juan",
    "COP" to "Kolumbijski pezos",
    "COU" to "Kolumbijski Unidade real de valor",
    "CRC" to "Kostarikanski kolon",
    "CSD" to "Srpski dinar (2002–2006)",
    "CSK" to "Čehoslovačka tvrda koruna",
    "CUC" to "Kubanski konvertibilni pezos",
    "CUP" to "kubanski pezos",
    "CVE" to "Zelenortski eskudo",
    "CYP" to "Kipratska funta",
    "CZK" to "Češka kruna",
    "DDM" to "Istočnoevropska marka",
    "DEM" to "Nemačka marka",
    "DJF" to "Džibutski franak",
    "DKK" to "Danska kruna",
    "DOP" to "Dominikanski pezos",
    "DZD" to "Alžirski dinar",
    "ECS" to "Ekvadorijski sukr",
    "ECV" to "Ekvadorski unidad de valor konstantin (UVC)",
    "EEK" to "Estonska kruna",
    "EGP" to "Egipatska funta",
    "ERN" to "Eritrejska nakfa",
    "ESA" to "Španska pezeta (račun) ESA",
    "ESB" to "Španska pezeta (konvertibilni račun)",
    "ESP" to "Španska pezeta",
    "ETB" to "Etiopski bir",
    "EUR" to "Euro",
    "FIM" to "Finska marka",
    "FJD" to "Fidžijski dolar",
    "FKP" to "Folklandska funta",
    "FRF" to "Francuski franak",
    "GBP" to "Britanska funta",
    "GEK" to "Gruzijski kupon larit",
    "GEL" to "Gruzijski lari",
    "GHC" to "Ganijski cedi (1979–2007)",
    "GHS" to "Ganski cedi",
    "GIP" to "Gibraltarska funta",
    "GMD" to "Gambijski dalasi",
    "GNF" to "Gvinejski franak",
    "GNS" to "Gvinejski sili",
    "GQE" to "Evatorijalna gvineja ekvele",
    "GRD" to "Drahma",
    "GTQ" to "Gvatemalski kecal",
    "GWE" to "Portugalska Gvineja eskudo",
    "GWP" to "Gvineja bisao pezo",
    "GYD" to "Gvajanski dolar",
    "HKD" to "Honkonški dolar",
    "HNL" to "Honduraška lempira",
    "HRD" to "Hrvatski dinar",
    "HRK" to "Hrvatska kuna",
    "HTG" to "Haićanski gurd",
    "HUF" to "Mađarska forinta",
    "IDR" to "Indonežanska rupija",
    "IEP" to "Irska funta",
    "ILP" to "Izraelska funta",
    "ILR" to "stari izraelski šekeli",
    "ILS" to "Izraelski novi šekel",
    "INR" to "Indijska rupija",
    "IQD" to "Irački dinar",
    "IRR" to "Iranski rijal",
    "ISJ" to "stara islandska kruna",
    "ISK" to "Islandska kruna",
    "ITL" to "Italijanska lira",
    "JMD" to "Jamajčanski dolar",
    "JOD" to "Jordanski dinar",
    "JPY" to "Japanski jen",
    "KES" to "Kenijski šiling",
    "KGS" to "Kirgistanski som",
    "KHR" to "Kambodžanski rijel",
    "KMF" to "Komorski franak",
    "KPW" to "Sjevernokorejski von",
    "KRH" to "Južno-korejski hvan (1953–1962)",
    "KRO" to "Južno-korejski Von (1945–1953)",
    "KRW" to "Južnokorejski von",
    "KWD" to "Kuvajtski dinar",
    "KYD" to "Kajmanski dolar",
    "KZT" to "Kazahstanski tenge",
    "LAK" to "Laoski kip",
    "LBP" to "Libanska funta",
    "LKR" to "Šrilankanska rupija",
    "LRD" to "Liberijski dolar",
    "LSL" to "Lesotski loti",
    "LTL" to "Litvanski litas",
    "LTT" to "Litvanski talonas",
    "LUC" to "Luksemburški konvertibilni franak",
    "LUF" to "Luksemburški franak",
    "LUL" to "Luksemburški finansijski franak",
    "LVL" to "Letonski lats",
    "LVR" to "Latvijska rublja",
    "LYD" to "Libijski dinar",
    "MAD" to "Marokanski dirham",
    "MAF" to "Marokanski franak",
    "MCF" to "Monegaskaški franak",
    "MDC" to "Moldavski kupon",
    "MDL" to "Moldavski lej",
    "MGA" to "Malagaški arijari",
    "MGF" to "Malagasijski franak",
    "MKD" to "Makedonski denar",
    "MKN" to "Makedonski denar (1992–1993)",
    "MLF" to "Malijanski franak",
    "MMK" to "Mijanmarski kjat",
    "MNT" to "Mongolski tugrik",
    "MOP" to "Makaonska pataka",
    "MRO" to "Mauritanijska ugvija (1973–2017)",
    "MRU" to "mauritanijska ugvija",
    "MTL" to "Malteška lira",
    "MTP" to "Malteška funta",
    "MUR" to "Mauricijska rupija",
    "MVR" to "Maldivska rufija",
    "MWK" to "Malavijska kvača",
    "MXN" to "Meksički pezos",
    "MXP" to "Meksijski srebrno pezo (1861–1992)",
    "MXV" to "Meksijski unidad de inverzion",
    "MYR" to "Malezijski ringit",
    "MZE" to "Mozambijski eskudo",
    "MZM" to "Mozambijski metikal (1980–2006)",
    "MZN" to "Mozambijski metikal",
    "NAD" to "Namibijski dolar",
    "NGN" to "Nigerijska naira",
    "NIC" to "Nikaragvanška kordoba (1988–1991)",
    "NIO" to "Nikaragvanska kordoba",
    "NLG" to "Holandski gulden",
    "NOK" to "Norveška kruna",
    "NPR" to "Nepalska rupija",
    "NZD" to "Novozelandski dolar",
    "OMR" to "Omanski rijal",
    "PAB" to "Panamska balboa",
    "PEI" to "Peruvijski inti",
    "PEN" to "Peruanski sol",
    "PES" to "Peruvijski sol (1863–1965)",
    "PGK" to "Kina Papue Nove Gvineje",
    "PHP" to "Filipinski pezos",
    "PKR" to "Pakistanska rupija",
    "PLN" to "Poljski zlot",
    "PLZ" to "Poljski zloti (1950–1995)",
    "PTE" to "Portugalski eskudo",
    "PYG" to "Paragvajski gvarani",
    "QAR" to "Katarski rijal",
    "RHD" to "Rodizijski dolar",
    "ROL" to "Rumunski leu (1952–2006)",
    "RON" to "Rumunski lej",
    "RSD" to "Srpski dinar",
    "RUB" to "Ruska rublja",
    "RUR" to "Ruska rublja (1991–1998)",
    "RWF" to "Ruandski franak",
    "SAR" to "Saudijski rijal",
    "SBD" to "Solomonski dolar",
    "SCR" to "Sejšelska rupija",
    "SDD" to "Sudanski dinar (1992–2007)",
    "SDG" to "Sudanska funta",
    "SDP" to "Sudanska funta (1957–1998)",
    "SEK" to "Švedska kruna",
    "SGD" to "Singapurski dolar",
    "SHP" to "Svetohelenska funta",
    "SIT" to "Slovenski tolar",
    "SKK" to "Slovačka kruna",
    "SLE" to "Sijeraleonski leone",
    "SLL" to "Sijeraleonski leone (1964—2022)",
    "SOS" to "Somalski šiling",
    "SRD" to "Surinamski dolar",
    "SRG" to "Surinamski gilder",
    "SSP" to "Južnosudanska funta",
    "STD" to "Dobra Sao Toma i Principa (1977–2017)",
    "STN" to "Dobra Sao Toma i Principa",
    "SUR" to "Sovjetska rublja",
    "SVC" to "Salvadorski kolon",
    "SYP" to "Sirijska funta",
    "SZL" to "Svazilendski lilangeni",
    "THB" to "Tajlandski baht",
    "TJR" to "Tadžakistanska rublja",
    "TJS" to "Tadžikistanski somoni",
    "TMM" to "Turkmenistanski manat (1993–2009)",
    "TMT" to "Turkmenistanski manat",
    "TND" to "Tuniški dinar",
    "TOP" to "Tonganska panga",
    "TPE" to "Timorški eskudo",
    "TRL" to "Turska lira (1922–2005)",
    "TRY" to "Turska lira",
    "TTD" to "Trinidadtobaški dolar",
    "TWD" to "Novi tajvanski dolar",
    "TZS" to "Tanzanijski šiling",
    "UAH" to "Ukrajinska hrivnja",
    "UAK" to "Ukrajinski karbovaneti",
    "UGS" to "Ugandijski šiling (1966–1987)",
    "UGX" to "Ugandski šiling",
    "USD" to "Američki dolar",
    "USN" to "SAD dolar (sledeći dan)",
    "USS" to "SAD dolar (isti dan)",
    "UYI" to "Urugvajski pezo en unidades indeksades",
    "UYP" to "Urugvajski pezo (1975–1993)",
    "UYU" to "Urugvajski pezos",
    "UZS" to "Uzbekistanski som",
    "VEB" to "Venecuelanski bolivar (1871–2008)",
    "VEF" to "venecuelanski bolivar (2008–2018)",
    "VES" to "Venecuelanski bolivar",
    "VND" to "Vijetnamski dong",
    "VNN" to "Vijetnamski dong (1978–1985)",
    "VUV" to "Vanuatski vatu",
    "WST" to "Samoanska tala",
    "XAF" to "Centralnoafrički franak (CFA)",
    "XAG" to "Srebro",
    "XAU" to "Zlato",
    "XBA" to "Evropska kompozitna jedinica",
    "XBB" to "Evropska novčana jedinica",
    "XBC" to "Evropska jedinica računa (XBC)",
    "XBD" to "Evropska jedinica računa (XBD)",
    "XCD" to "Istočnokaripski dolar",
    "XDR" to "Posebna prava",
    "XEU" to "Evropska valutna jedinica",
    "XFO" to "Francuski zlatni frank",
    "XFU" to "Francuski UIC-frank",
    "XOF" to "Zapadnoafrički franak (CFA)",
    "XPD" to "Paladijum",
    "XPF" to "Franak (CFP)",
    "XPT" to "Platina",
    "XRE" to "RINET fondovi",
    "XTS" to "Kod testirane valute",
    "XXX" to "Nepoznata valuta",
    "YDD" to "Jemenski dinar",
    "YER" to "Jemenski rijal",
    "YUD" to "Jugoslovenski tvrdi dinar",
    "YUM" to "Jugoslovenski novi dinar",
    "YUN" to "Jugoslovenski konvertibilni dinar",
    "YUR" to "Jugoslovenski reformirani dinar",
    "ZAL" to "Južnoafrički rand (finansijski)",
    "ZAR" to "Južnoafrički rand",
    "ZMK" to "Zambijska kvača (1968–2012)",
    "ZMW" to "Zambijska kvača",
    "ZRN" to "Zairski novi zair (1993–1998)",
    "ZRZ" to "Zairski zair (1971–1993)",
    "ZWD" to "Zimbabvejski dolar (1980–2008)",
    "ZWL" to "Zimbabvejski dolar (2009)",
    "ZWR" to "Zimbabvejski dolar (2008)",
  ) }

  val bss: ImmutableMap<String, String> by lazy { immutableMapOf(
    "XAF" to "Frânke CFA",
  ) }

  val byn: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ca: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "pesseta andorrana",
    "AED" to "dírham dels Emirats Àrabs Units",
    "AFA" to "afgani afganès (1927–2002)",
    "AFN" to "afgani afganès",
    "ALK" to "lek albanès (1946–1965)",
    "ALL" to "lek",
    "AMD" to "dram",
    "ANG" to "florí de les Antilles Neerlandeses",
    "AOA" to "kwanza angolès",
    "AOK" to "kwanza angolès (1977–1991)",
    "AON" to "nou kwanza angolès (1990–2000)",
    "AOR" to "kwanza angolès reajustat (1995–1999)",
    "ARA" to "austral argentí",
    "ARL" to "peso ley argentí (1970–1983)",
    "ARM" to "peso argentí (1981–1970)",
    "ARP" to "peso argentí (1983–1985)",
    "ARS" to "peso argentí",
    "ATS" to "xíling austríac",
    "AUD" to "dòlar australià",
    "AWG" to "florí d’Aruba",
    "AZM" to "manat azerbaidjanès (1993–2006)",
    "AZN" to "manat azerbaidjanès",
    "BAD" to "dinar de Bòsnia i Hercegovina (1992–1994)",
    "BAM" to "marc convertible de Bòsnia i Hercegovina",
    "BAN" to "nou dinar de Bòsnia i Hercegovina (1994–1997)",
    "BBD" to "dòlar de Barbados",
    "BDT" to "taka",
    "BEC" to "franc belga (convertible)",
    "BEF" to "franc belga",
    "BEL" to "franc belga (financer)",
    "BGL" to "lev fort búlgar",
    "BGM" to "lev socialista búlgar",
    "BGN" to "lev",
    "BGO" to "lev búlgar (1879–1952)",
    "BHD" to "dinar de Bahrain",
    "BIF" to "franc de Burundi",
    "BMD" to "dòlar de les Bermudes",
    "BND" to "dòlar de Brunei",
    "BOB" to "bolivià",
    "BOL" to "boliviano bolivià (1863–1963)",
    "BOP" to "peso bolivià",
    "BOV" to "MVDOL bolivià",
    "BRB" to "cruzeiro novo brasiler (1967–1986)",
    "BRC" to "cruzado brasiler",
    "BRE" to "cruzeiro brasiler (1990–1993)",
    "BRL" to "real brasiler",
    "BRN" to "cruzado novo brasiler",
    "BRR" to "cruzeiro brasiler",
    "BRZ" to "antic cruzeiro brasiler",
    "BSD" to "dòlar de les Bahames",
    "BTN" to "ngultrum de Bhutan",
    "BUK" to "kyat birmà",
    "BWP" to "pula de Botswana",
    "BYB" to "nou ruble bielorús (1994–1999)",
    "BYN" to "ruble belarús",
    "BYR" to "ruble bielorús (2000–2016)",
    "BZD" to "dòlar de Belize",
    "CAD" to "dòlar canadenc",
    "CDF" to "franc congolès",
    "CHE" to "euro WIR",
    "CHF" to "franc suís",
    "CHW" to "franc WIR",
    "CLE" to "escut xilè",
    "CLF" to "unidad de fomento xilena",
    "CLP" to "peso xilè",
    "CNH" to "iuan xinès extracontinental",
    "CNX" to "dòlars del Banc Popular Xinès",
    "CNY" to "iuan",
    "COP" to "peso colombià",
    "COU" to "unidad de valor real colombiana",
    "CRC" to "colon costa-riqueny",
    "CSD" to "dinar serbi antic",
    "CSK" to "corona forta txecoslovaca",
    "CUC" to "peso convertible cubà",
    "CUP" to "peso cubà",
    "CVE" to "escut de Cap Verd",
    "CYP" to "lliura xipriota",
    "CZK" to "corona txeca",
    "DDM" to "marc de l’Alemanya Oriental",
    "DEM" to "marc alemany",
    "DJF" to "franc de Djibouti",
    "DKK" to "corona danesa",
    "DOP" to "peso dominicà",
    "DZD" to "dinar algerià",
    "ECS" to "sucre equatorià",
    "ECV" to "unidad de valor constante (UVC) equatoriana",
    "EEK" to "corona estoniana",
    "EGP" to "lliura egípcia",
    "ERN" to "nakfa eritreu",
    "ESA" to "pesseta espanyola (compte A)",
    "ESB" to "pesseta espanyola (compte convertible)",
    "ESP" to "pesseta espanyola",
    "ETB" to "birr etíop",
    "EUR" to "euro",
    "FIM" to "marc finlandès",
    "FJD" to "dòlar fijià",
    "FKP" to "lliura de les illes Malvines",
    "FRF" to "franc francès",
    "GBP" to "lliura esterlina",
    "GEK" to "cupó de lari georgià",
    "GEL" to "lari",
    "GHC" to "cedi ghanès (1979–2007)",
    "GHS" to "cedi ghanès",
    "GIP" to "lliura de Gibraltar",
    "GMD" to "dalasi gambià",
    "GNF" to "franc guineà",
    "GNS" to "syli guineà",
    "GQE" to "ekwele de Guinea Equatorial",
    "GRD" to "dracma grega",
    "GTQ" to "quetzal",
    "GWE" to "escut de la Guinea Portuguesa",
    "GWP" to "peso de Guinea Bissau",
    "GYD" to "dòlar de Guyana",
    "HKD" to "dòlar de Hong Kong",
    "HNL" to "lempira",
    "HRD" to "dinar croat",
    "HRK" to "kuna",
    "HTG" to "gourde",
    "HUF" to "fòrint",
    "IDR" to "rupia indonèsia",
    "IEP" to "lliura irlandesa",
    "ILP" to "lliura israeliana",
    "ILR" to "xéquel israelià",
    "ILS" to "nou xéquel israelià",
    "INR" to "rupia índia",
    "IQD" to "dinar iraquià",
    "IRR" to "rial iranià",
    "ISJ" to "corona islandesa antiga",
    "ISK" to "corona islandesa",
    "ITL" to "lira italiana",
    "JMD" to "dòlar jamaicà",
    "JOD" to "dinar jordà",
    "JPY" to "ien",
    "KES" to "xíling kenyà",
    "KGS" to "som kirguís",
    "KHR" to "riel cambodjà",
    "KMF" to "franc de les Comores",
    "KPW" to "won nord-coreà",
    "KRH" to "hwan sud-coreà (1953–1962)",
    "KRO" to "antic won sud-coreà",
    "KRW" to "won sud-coreà",
    "KWD" to "dinar kuwaitià",
    "KYD" to "dòlar de les illes Caiman",
    "KZT" to "tenge",
    "LAK" to "kip laosià",
    "LBP" to "lliura libanesa",
    "LKR" to "rupia de Sri Lanka",
    "LRD" to "dòlar liberià",
    "LSL" to "loti",
    "LTL" to "litas lituà",
    "LTT" to "talonas lituà",
    "LUC" to "franc convertible luxemburguès",
    "LUF" to "franc luxemburguès",
    "LUL" to "franc financer luxemburguès",
    "LVL" to "lats letó",
    "LVR" to "ruble letó",
    "LYD" to "dinar libi",
    "MAD" to "dírham marroquí",
    "MAF" to "franc marroquí",
    "MCF" to "franc monegasc",
    "MDC" to "cupó moldau",
    "MDL" to "leu moldau",
    "MGA" to "ariary malgaix",
    "MGF" to "franc malgaix",
    "MKD" to "dinar macedoni",
    "MKN" to "denar macedoni (1992–1993)",
    "MLF" to "franc malià",
    "MMK" to "kyat de Myanmar",
    "MNT" to "tögrög mongol",
    "MOP" to "pataca de Macau",
    "MRO" to "ouguiya maurità (1973–2017)",
    "MRU" to "ouguiya maurità",
    "MTL" to "lira maltesa",
    "MTP" to "lliura maltesa",
    "MUR" to "rupia mauriciana",
    "MVR" to "rupia de les Maldives",
    "MWK" to "kwacha malawià",
    "MXN" to "peso mexicà",
    "MXP" to "peso de plata mexicà (1861–1992)",
    "MXV" to "unidad de inversión (UDI) mexicana",
    "MYR" to "ringgit",
    "MZE" to "escut moçambiquès",
    "MZM" to "antic metical moçambiquès",
    "MZN" to "metical moçambiquès",
    "NAD" to "dòlar namibià",
    "NGN" to "naira nigerià",
    "NIC" to "córdoba nicaragüenca",
    "NIO" to "córdoba nicaragüenc",
    "NLG" to "florí neerlandès",
    "NOK" to "corona noruega",
    "NPR" to "rupia nepalesa",
    "NZD" to "dòlar neozelandès",
    "OMR" to "rial omanita",
    "PAB" to "balboa",
    "PEI" to "inti peruà",
    "PEN" to "sol",
    "PES" to "sol peruà (1863–1965)",
    "PGK" to "kina",
    "PHP" to "peso filipí",
    "PKR" to "rupia pakistanesa",
    "PLN" to "zloty",
    "PLZ" to "zloty polonès (1950–1995)",
    "PTE" to "escut portuguès",
    "PYG" to "guaraní",
    "QAR" to "rial de Qatar",
    "RHD" to "dòlar rhodesià",
    "ROL" to "antic leu romanès",
    "RON" to "leu romanès",
    "RSD" to "dinar serbi",
    "RUB" to "ruble",
    "RUR" to "ruble rus (1991–1998)",
    "RWF" to "franc de Ruanda",
    "SAR" to "rial saudita",
    "SBD" to "dòlar de les illes Salomó",
    "SCR" to "rupia de les Seychelles",
    "SDD" to "dinar sudanès",
    "SDG" to "lliura sudanesa",
    "SDP" to "antiga lliura sudanesa",
    "SEK" to "corona sueca",
    "SGD" to "dòlar de Singapur",
    "SHP" to "lliura de Santa Helena",
    "SIT" to "tolar eslovè",
    "SKK" to "corona eslovaca",
    "SLE" to "leone de Sierra Leone",
    "SLL" to "leone de Sierra Leone (1964—2022)",
    "SOS" to "xíling somali",
    "SRD" to "dòlar de Surinam",
    "SRG" to "florí de Surinam",
    "SSP" to "lliura del Sudan del Sud",
    "STD" to "dobra de São Tomé i Príncipe (1977–2017)",
    "STN" to "dobra de São Tomé i Príncipe",
    "SUR" to "ruble soviètic",
    "SVC" to "colon salvadorenc",
    "SYP" to "lliura siriana",
    "SZL" to "lilangeni swazi",
    "THB" to "baht",
    "TJR" to "ruble tadjik",
    "TJS" to "somoni tadjik",
    "TMM" to "manat turcman (1993–2009)",
    "TMT" to "manat turcman",
    "TND" to "dinar tunisià",
    "TOP" to "pa‘anga tongà",
    "TPE" to "escut de Timor",
    "TRL" to "lira turca (1922–2005)",
    "TRY" to "lira turca",
    "TTD" to "dòlar de Trinitat i Tobago",
    "TWD" to "nou dòlar de Taiwan",
    "TZS" to "xíling tanzà",
    "UAH" to "hrívnia",
    "UAK" to "karbóvanets ucraïnès",
    "UGS" to "xíling ugandès (1966–1987)",
    "UGX" to "xíling ugandès",
    "USD" to "dòlar dels Estats Units",
    "USN" to "dòlar dels Estats Units (dia següent)",
    "USS" to "dòlar dels Estats Units (mateix dia)",
    "UYI" to "peso uruguaià en unitats indexades",
    "UYP" to "peso uruguaià (1975–1993)",
    "UYU" to "peso uruguaià",
    "UZS" to "som uzbek",
    "VEB" to "bolívar veneçolà (1871–2008)",
    "VEF" to "bolívar veneçolà (2008–2018)",
    "VES" to "bolívar veneçolà",
    "VND" to "dong vietnamita",
    "VNN" to "dong vietnamita (1978–1985)",
    "VUV" to "vatu de Vanuatu",
    "WST" to "tala samoà",
    "XAF" to "franc CFA BEAC",
    "XAG" to "plata",
    "XAU" to "or",
    "XBA" to "unitat compensatòria europea",
    "XBB" to "unitat monetària europea",
    "XBC" to "unitat de compte europea (XBC)",
    "XBD" to "unitat de compte europea (XBD)",
    "XCD" to "dòlar del Carib Oriental",
    "XDR" to "drets especials de gir",
    "XEU" to "unitat de moneda europea",
    "XFO" to "franc or francès",
    "XFU" to "franc UIC francès",
    "XOF" to "franc CFA BCEAO",
    "XPD" to "pal·ladi",
    "XPF" to "franc CFP",
    "XPT" to "platí",
    "XRE" to "fons RINET",
    "XTS" to "codi reservat per a proves",
    "XXX" to "moneda desconeguda",
    "YDD" to "dinar iemenita",
    "YER" to "rial iemenita",
    "YUD" to "dinar fort iugoslau",
    "YUM" to "nou dinar iugoslau",
    "YUN" to "dinar convertible iugoslau",
    "YUR" to "dinar iugoslau reformat (1992–1993)",
    "ZAL" to "rand sud-africà (financer)",
    "ZAR" to "rand sud-africà",
    "ZMK" to "kwacha zambià (1968–2012)",
    "ZMW" to "kwacha zambià",
    "ZRN" to "nou zaire zairès",
    "ZRZ" to "zaire zairès",
    "ZWD" to "dòlar zimbabuès (1980–2008)",
    "ZWL" to "dòlar zimbabuès (2009)",
    "ZWR" to "dòlar zimbabuès (2008)",
  ) }

  val ca_AD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ca_ES_valencia: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "pesseta andorrana",
    "AED" to "dírham dels Emirats Àrabs Units",
    "AFA" to "afgani afganès (1927–2002)",
    "AFN" to "afgani afganès",
    "ALK" to "lek albanès (1946–1965)",
    "ALL" to "lek",
    "AMD" to "dram",
    "ANG" to "florí de les Antilles Neerlandeses",
    "AOA" to "kwanza angolès",
    "AOK" to "kwanza angolès (1977–1991)",
    "AON" to "nou kwanza angolès (1990–2000)",
    "AOR" to "kwanza angolès reajustat (1995–1999)",
    "ARA" to "austral argentí",
    "ARL" to "peso ley argentí (1970–1983)",
    "ARM" to "peso argentí (1981–1970)",
    "ARP" to "peso argentí (1983–1985)",
    "ARS" to "peso argentí",
    "ATS" to "xíling austríac",
    "AUD" to "dòlar australià",
    "AWG" to "florí d’Aruba",
    "AZM" to "manat azerbaidjanès (1993–2006)",
    "AZN" to "manat azerbaidjanès",
    "BAD" to "dinar de Bòsnia i Hercegovina (1992–1994)",
    "BAM" to "marc convertible de Bòsnia i Hercegovina",
    "BAN" to "nou dinar de Bòsnia i Hercegovina (1994–1997)",
    "BBD" to "dòlar de Barbados",
    "BDT" to "taka",
    "BEC" to "franc belga (convertible)",
    "BEF" to "franc belga",
    "BEL" to "franc belga (financer)",
    "BGL" to "lev fort búlgar",
    "BGM" to "lev socialista búlgar",
    "BGN" to "lev",
    "BGO" to "lev búlgar (1879–1952)",
    "BHD" to "dinar de Bahrain",
    "BIF" to "franc de Burundi",
    "BMD" to "dòlar de les Bermudes",
    "BND" to "dòlar de Brunei",
    "BOB" to "bolivià",
    "BOL" to "boliviano bolivià (1863–1963)",
    "BOP" to "peso bolivià",
    "BOV" to "MVDOL bolivià",
    "BRB" to "cruzeiro novo brasiler (1967–1986)",
    "BRC" to "cruzado brasiler",
    "BRE" to "cruzeiro brasiler (1990–1993)",
    "BRL" to "real brasiler",
    "BRN" to "cruzado novo brasiler",
    "BRR" to "cruzeiro brasiler",
    "BRZ" to "antic cruzeiro brasiler",
    "BSD" to "dòlar de les Bahames",
    "BTN" to "ngultrum de Bhutan",
    "BUK" to "kyat birmà",
    "BWP" to "pula de Botswana",
    "BYB" to "nou ruble bielorús (1994–1999)",
    "BYN" to "ruble belarús",
    "BYR" to "ruble bielorús (2000–2016)",
    "BZD" to "dòlar de Belize",
    "CAD" to "dòlar canadenc",
    "CDF" to "franc congolès",
    "CHE" to "euro WIR",
    "CHF" to "franc suís",
    "CHW" to "franc WIR",
    "CLE" to "escut xilè",
    "CLF" to "unidad de fomento xilena",
    "CLP" to "peso xilè",
    "CNH" to "iuan xinès extracontinental",
    "CNX" to "dòlars del Banc Popular Xinès",
    "CNY" to "iuan",
    "COP" to "peso colombià",
    "COU" to "unidad de valor real colombiana",
    "CRC" to "colon costa-riqueny",
    "CSD" to "dinar serbi antic",
    "CSK" to "corona forta txecoslovaca",
    "CUC" to "peso convertible cubà",
    "CUP" to "peso cubà",
    "CVE" to "escut de Cap Verd",
    "CYP" to "lliura xipriota",
    "CZK" to "corona txeca",
    "DDM" to "marc de l’Alemanya Oriental",
    "DEM" to "marc alemany",
    "DJF" to "franc de Djibouti",
    "DKK" to "corona danesa",
    "DOP" to "peso dominicà",
    "DZD" to "dinar algerià",
    "ECS" to "sucre equatorià",
    "ECV" to "unidad de valor constante (UVC) equatoriana",
    "EEK" to "corona estoniana",
    "EGP" to "lliura egípcia",
    "ERN" to "nakfa eritreu",
    "ESA" to "pesseta espanyola (compte A)",
    "ESB" to "pesseta espanyola (compte convertible)",
    "ESP" to "pesseta espanyola",
    "ETB" to "birr etíop",
    "EUR" to "euro",
    "FIM" to "marc finlandès",
    "FJD" to "dòlar fijià",
    "FKP" to "lliura de les illes Malvines",
    "FRF" to "franc francès",
    "GBP" to "lliura esterlina",
    "GEK" to "cupó de lari georgià",
    "GEL" to "lari",
    "GHC" to "cedi ghanès (1979–2007)",
    "GHS" to "cedi ghanès",
    "GIP" to "lliura de Gibraltar",
    "GMD" to "dalasi gambià",
    "GNF" to "franc guineà",
    "GNS" to "syli guineà",
    "GQE" to "ekwele de Guinea Equatorial",
    "GRD" to "dracma grega",
    "GTQ" to "quetzal",
    "GWE" to "escut de la Guinea Portuguesa",
    "GWP" to "peso de Guinea Bissau",
    "GYD" to "dòlar de Guyana",
    "HKD" to "dòlar de Hong Kong",
    "HNL" to "lempira",
    "HRD" to "dinar croat",
    "HRK" to "kuna",
    "HTG" to "gourde",
    "HUF" to "fòrint",
    "IDR" to "rupia indonèsia",
    "IEP" to "lliura irlandesa",
    "ILP" to "lliura israeliana",
    "ILR" to "xéquel israelià",
    "ILS" to "nou xéquel israelià",
    "INR" to "rupia índia",
    "IQD" to "dinar iraquià",
    "IRR" to "rial iranià",
    "ISJ" to "corona islandesa antiga",
    "ISK" to "corona islandesa",
    "ITL" to "lira italiana",
    "JMD" to "dòlar jamaicà",
    "JOD" to "dinar jordà",
    "JPY" to "ien",
    "KES" to "xíling kenyà",
    "KGS" to "som kirguís",
    "KHR" to "riel cambodjà",
    "KMF" to "franc de les Comores",
    "KPW" to "won nord-coreà",
    "KRH" to "hwan sud-coreà (1953–1962)",
    "KRO" to "antic won sud-coreà",
    "KRW" to "won sud-coreà",
    "KWD" to "dinar kuwaitià",
    "KYD" to "dòlar de les illes Caiman",
    "KZT" to "tenge",
    "LAK" to "kip laosià",
    "LBP" to "lliura libanesa",
    "LKR" to "rupia de Sri Lanka",
    "LRD" to "dòlar liberià",
    "LSL" to "loti",
    "LTL" to "litas lituà",
    "LTT" to "talonas lituà",
    "LUC" to "franc convertible luxemburguès",
    "LUF" to "franc luxemburguès",
    "LUL" to "franc financer luxemburguès",
    "LVL" to "lats letó",
    "LVR" to "ruble letó",
    "LYD" to "dinar libi",
    "MAD" to "dírham marroquí",
    "MAF" to "franc marroquí",
    "MCF" to "franc monegasc",
    "MDC" to "cupó moldau",
    "MDL" to "leu moldau",
    "MGA" to "ariary malgaix",
    "MGF" to "franc malgaix",
    "MKD" to "dinar macedoni",
    "MKN" to "denar macedoni (1992–1993)",
    "MLF" to "franc malià",
    "MMK" to "kyat de Myanmar",
    "MNT" to "tögrög mongol",
    "MOP" to "pataca de Macau",
    "MRO" to "ouguiya maurità (1973–2017)",
    "MRU" to "ouguiya maurità",
    "MTL" to "lira maltesa",
    "MTP" to "lliura maltesa",
    "MUR" to "rupia mauriciana",
    "MVR" to "rupia de les Maldives",
    "MWK" to "kwacha malawià",
    "MXN" to "peso mexicà",
    "MXP" to "peso de plata mexicà (1861–1992)",
    "MXV" to "unidad de inversión (UDI) mexicana",
    "MYR" to "ringgit",
    "MZE" to "escut moçambiquès",
    "MZM" to "antic metical moçambiquès",
    "MZN" to "metical moçambiquès",
    "NAD" to "dòlar namibià",
    "NGN" to "naira nigerià",
    "NIC" to "córdoba nicaragüenca",
    "NIO" to "córdoba nicaragüenc",
    "NLG" to "florí neerlandès",
    "NOK" to "corona noruega",
    "NPR" to "rupia nepalesa",
    "NZD" to "dòlar neozelandès",
    "OMR" to "rial omanita",
    "PAB" to "balboa",
    "PEI" to "inti peruà",
    "PEN" to "sol",
    "PES" to "sol peruà (1863–1965)",
    "PGK" to "kina",
    "PHP" to "peso filipí",
    "PKR" to "rupia pakistanesa",
    "PLN" to "zloty",
    "PLZ" to "zloty polonès (1950–1995)",
    "PTE" to "escut portuguès",
    "PYG" to "guaraní",
    "QAR" to "rial de Qatar",
    "RHD" to "dòlar rhodesià",
    "ROL" to "antic leu romanès",
    "RON" to "leu romanès",
    "RSD" to "dinar serbi",
    "RUB" to "ruble",
    "RUR" to "ruble rus (1991–1998)",
    "RWF" to "franc de Ruanda",
    "SAR" to "rial saudita",
    "SBD" to "dòlar de les illes Salomó",
    "SCR" to "rupia de les Seychelles",
    "SDD" to "dinar sudanès",
    "SDG" to "lliura sudanesa",
    "SDP" to "antiga lliura sudanesa",
    "SEK" to "corona sueca",
    "SGD" to "dòlar de Singapur",
    "SHP" to "lliura de Santa Helena",
    "SIT" to "tolar eslovè",
    "SKK" to "corona eslovaca",
    "SLE" to "leone de Sierra Leone",
    "SLL" to "leone de Sierra Leone (1964—2022)",
    "SOS" to "xíling somali",
    "SRD" to "dòlar de Surinam",
    "SRG" to "florí de Surinam",
    "SSP" to "lliura del Sudan del Sud",
    "STD" to "dobra de São Tomé i Príncipe (1977–2017)",
    "STN" to "dobra de São Tomé i Príncipe",
    "SUR" to "ruble soviètic",
    "SVC" to "colon salvadorenc",
    "SYP" to "lliura siriana",
    "SZL" to "lilangeni swazi",
    "THB" to "baht",
    "TJR" to "ruble tadjik",
    "TJS" to "somoni tadjik",
    "TMM" to "manat turcman (1993–2009)",
    "TMT" to "manat turcman",
    "TND" to "dinar tunisià",
    "TOP" to "pa‘anga tongà",
    "TPE" to "escut de Timor",
    "TRL" to "lira turca (1922–2005)",
    "TRY" to "lira turca",
    "TTD" to "dòlar de Trinitat i Tobago",
    "TWD" to "nou dòlar de Taiwan",
    "TZS" to "xíling tanzà",
    "UAH" to "hrívnia",
    "UAK" to "karbóvanets ucraïnès",
    "UGS" to "xíling ugandès (1966–1987)",
    "UGX" to "xíling ugandès",
    "USD" to "dòlar dels Estats Units",
    "USN" to "dòlar dels Estats Units (dia següent)",
    "USS" to "dòlar dels Estats Units (mateix dia)",
    "UYI" to "peso uruguaià en unitats indexades",
    "UYP" to "peso uruguaià (1975–1993)",
    "UYU" to "peso uruguaià",
    "UZS" to "som uzbek",
    "VEB" to "bolívar veneçolà (1871–2008)",
    "VEF" to "bolívar veneçolà (2008–2018)",
    "VES" to "bolívar veneçolà",
    "VND" to "dong vietnamita",
    "VNN" to "dong vietnamita (1978–1985)",
    "VUV" to "vatu de Vanuatu",
    "WST" to "tala samoà",
    "XAF" to "franc CFA BEAC",
    "XAG" to "plata",
    "XAU" to "or",
    "XBA" to "unitat compensatòria europea",
    "XBB" to "unitat monetària europea",
    "XBC" to "unitat de compte europea (XBC)",
    "XBD" to "unitat de compte europea (XBD)",
    "XCD" to "dòlar del Carib Oriental",
    "XDR" to "drets especials de gir",
    "XEU" to "unitat de moneda europea",
    "XFO" to "franc or francès",
    "XFU" to "franc UIC francès",
    "XOF" to "franc CFA BCEAO",
    "XPD" to "pal·ladi",
    "XPF" to "franc CFP",
    "XPT" to "platí",
    "XRE" to "fons RINET",
    "XTS" to "codi reservat per a proves",
    "XXX" to "moneda desconeguda",
    "YDD" to "dinar iemenita",
    "YER" to "rial iemenita",
    "YUD" to "dinar fort iugoslau",
    "YUM" to "nou dinar iugoslau",
    "YUN" to "dinar convertible iugoslau",
    "YUR" to "dinar iugoslau reformat (1992–1993)",
    "ZAL" to "rand sud-africà (financer)",
    "ZAR" to "rand sud-africà",
    "ZMK" to "kwacha zambià (1968–2012)",
    "ZMW" to "kwacha zambià",
    "ZRN" to "nou zaire zairès",
    "ZRZ" to "zaire zairès",
    "ZWD" to "dòlar zimbabuès (1980–2008)",
    "ZWL" to "dòlar zimbabuès (2009)",
    "ZWR" to "dòlar zimbabuès (2008)",
  ) }

  val ca_FR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ca_IT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val cad: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val cch: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ccp: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "𑄃𑄳𑄠𑄚𑄴𑄓𑄮𑄢𑄚𑄴 𑄛𑄬𑄥𑄬𑄖",
    "AED" to "𑄎𑄧𑄙 𑄃𑄢𑄧𑄝𑄴 𑄃𑄟𑄨𑄢𑄖𑄴 𑄘𑄨𑄢𑄴𑄦𑄟𑄴",
    "AFA" to "𑄃𑄛𑄴𑄉𑄚𑄨 (𑄷𑄿𑄸𑄽-𑄸𑄶𑄶𑄸)",
    "AFN" to "𑄃𑄜𑄴𑄉𑄚𑄴 𑄃𑄜𑄴𑄉𑄚𑄨",
    "ALL" to "𑄃𑄣𑄴𑄝𑄬𑄚𑄨𑄠𑄚𑄴 𑄣𑄬𑄇𑄴",
    "AMD" to "𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄚𑄴 𑄘𑄳𑄢𑄟𑄴",
    "ANG" to "𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄃𑄳𑄠𑄚𑄴𑄑𑄨𑄣𑄨𑄠𑄚𑄴 𑄉𑄪𑄣𑄴𑄓𑄬𑄢𑄴",
    "AOA" to "𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣𑄚𑄴 𑄇𑄧𑄤𑄮𑄚𑄴𑄎",
    "AOK" to "𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣𑄚𑄴 𑄇𑄧𑄤𑄮𑄚𑄴𑄎(𑄷𑄿𑄽𑄽-𑄷𑄿𑄿𑄶)",
    "AON" to "𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣𑄚𑄴 𑄚𑄱 𑄇𑄧𑄤𑄮𑄚𑄴𑄎(𑄷𑄿𑄿𑄻-𑄸𑄶𑄶𑄶)",
    "AOR" to "𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣𑄚𑄴 𑄇𑄧𑄤𑄮𑄚𑄴𑄎(𑄷𑄿𑄿𑄻-𑄷𑄿𑄿𑄿)",
    "ARA" to "𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄣𑄴",
    "ARP" to "𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄛𑄬𑄥𑄮 (𑄷𑄿𑄾𑄹-𑄷𑄿𑄾𑄻)",
    "ARS" to "𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄛𑄬𑄥𑄮",
    "ATS" to "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠𑄚𑄴 𑄥𑄨𑄣𑄨𑄁",
    "AUD" to "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴",
    "AWG" to "𑄃𑄢𑄪𑄝 𑄉𑄨𑄣𑄴𑄓𑄢𑄴",
    "AZM" to "𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴 𑄟𑄚𑄖𑄴 (𑄷𑄿𑄿𑄹-𑄸𑄶𑄶𑄼)",
    "AZN" to "𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴 𑄟𑄚𑄖𑄴",
    "BAD" to "𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄳𑄃 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚 𑄘𑄨𑄚𑄢𑄴",
    "BAM" to "𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄳𑄃 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚 𑄟𑄢𑄴𑄇𑄴",
    "BBD" to "𑄝𑄢𑄴𑄝𑄬𑄓𑄮𑄎𑄴 𑄓𑄧𑄣𑄢𑄴",
    "BDT" to "𑄝𑄁𑄣𑄘𑄬𑄥𑄨 𑄑𑄬𑄋",
    "BEC" to "𑄝𑄬𑄣𑄴𑄘𑄎𑄨𑄠𑄚𑄴 𑄜𑄳𑄢𑄋𑄴𑄇𑄴 (𑄝𑄮𑄘𑄮𑄣𑄬𑄭𑄛𑄢𑄬)",
    "BEF" to "𑄝𑄬𑄣𑄴𑄘𑄎𑄨𑄠𑄚𑄴 𑄜𑄳𑄢𑄋𑄴𑄇𑄴",
    "BEL" to "𑄝𑄬𑄣𑄴𑄘𑄎𑄨𑄠𑄚𑄴 𑄜𑄳𑄢𑄋𑄴𑄇𑄴 (𑄃𑄢𑄴𑄗𑄨𑄇𑄴)",
    "BGL" to "𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄩𑄠𑄧 𑄦𑄢𑄴𑄓𑄴 𑄣𑄬𑄞𑄴",
    "BGN" to "𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄩𑄠𑄧 𑄚𑄱 𑄣𑄬𑄞𑄴",
    "BHD" to "𑄝𑄦𑄧𑄢𑄭𑄚𑄨 𑄘𑄨𑄚𑄢𑄴",
    "BIF" to "𑄝𑄪𑄢𑄪𑄚𑄴𑄓𑄨 𑄜𑄳𑄢𑄋𑄴𑄇𑄴",
    "BMD" to "𑄝𑄢𑄴𑄟𑄨𑄅𑄪𑄓𑄚𑄴 𑄓𑄧𑄣𑄢𑄴",
    "BND" to "𑄝𑄳𑄢𑄪𑄚𑄬𑄭 𑄓𑄧𑄣𑄢𑄴",
    "BOB" to "𑄝𑄧𑄣𑄨𑄞𑄨𑄠𑄚𑄮",
    "BOP" to "𑄝𑄧𑄣𑄨𑄞𑄨𑄠𑄚𑄴 𑄛𑄬𑄥𑄮",
    "BOV" to "𑄝𑄧𑄣𑄨𑄞𑄨𑄠𑄚𑄴 𑄟𑄧𑄞𑄴𑄓𑄮𑄣𑄴",
    "BRB" to "𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄇𑄳𑄢𑄪𑄎𑄬𑄠𑄧𑄢𑄮𑄚𑄮𑄞𑄮 (𑄷𑄿𑄼𑄽-𑄷𑄿𑄾𑄼)",
    "BRC" to "𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄇𑄳𑄢𑄪𑄎𑄬𑄭𑄓𑄅𑄪",
    "BRE" to "𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄇𑄳𑄢𑄪𑄎𑄬𑄠𑄧𑄢𑄮 (𑄷𑄿𑄿𑄶-𑄷𑄿𑄿𑄹)",
    "BRL" to "𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄬𑄣𑄴",
    "BRN" to "𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄝𑄳𑄢𑄪𑄎𑄬𑄭𑄓𑄮 𑄚𑄮𑄞𑄮",
    "BRR" to "𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄝𑄳𑄢𑄪𑄎𑄬𑄠𑄧𑄢𑄮",
    "BSD" to "𑄝𑄦𑄟𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴",
    "BTN" to "𑄞𑄪𑄑𑄚𑄨 𑄃𑄬𑄚𑄴𑄉𑄪𑄣𑄴𑄑𑄳𑄢𑄟𑄴𑄛𑄴",
    "BUK" to "𑄝𑄧𑄢𑄴𑄟𑄨 𑄇𑄨𑄠𑄖𑄴",
    "BWP" to "𑄝𑄧𑄖𑄴𑄥𑄮𑄠𑄚 𑄛𑄪𑄣",
    "BYB" to "𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄚𑄴 𑄚𑄨𑄅𑄪 𑄢𑄪𑄝𑄬𑄣𑄴 (𑄷𑄿𑄿𑄺-𑄷𑄿𑄿𑄿)",
    "BYN" to "𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴",
    "BYR" to "𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴(𑄸𑄶𑄶𑄶-𑄸𑄶𑄷𑄼)",
    "BZD" to "𑄝𑄬𑄣𑄨𑄎𑄴 𑄓𑄧𑄣𑄢𑄴",
    "CAD" to "𑄇𑄚𑄓𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴",
    "CDF" to "𑄇𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄌𑄴 𑄜𑄳𑄢𑄁𑄇𑄴",
    "CHF" to "𑄥𑄭𑄪𑄥𑄴 𑄜𑄳𑄢𑄀",
    "CLF" to "𑄌𑄨𑄣𑄨𑄠𑄚𑄴 𑄃𑄪𑄚𑄨𑄘𑄘𑄬𑄥𑄴 𑄘𑄨 𑄜𑄮𑄟𑄬𑄚𑄴𑄖𑄮",
    "CLP" to "𑄌𑄨𑄣𑄨 𑄛𑄬𑄥𑄮",
    "CNY" to "𑄌𑄩𑄚 𑄠𑄪𑄠𑄚𑄴",
    "COP" to "𑄇𑄧𑄣𑄮𑄟𑄴𑄝𑄨𑄠𑄚𑄴 𑄛𑄬𑄥𑄮",
    "COU" to "𑄃𑄪𑄚𑄨𑄘𑄖𑄴 𑄘𑄨 𑄞𑄳𑄠𑄣𑄮𑄢𑄴 𑄢𑄨𑄠𑄬𑄣𑄴",
    "CRC" to "𑄇𑄮𑄥𑄴𑄑𑄢𑄨𑄇 𑄇𑄮𑄣𑄮𑄚𑄴",
    "CSD" to "𑄛𑄪𑄢𑄮𑄚𑄨 𑄥𑄢𑄴𑄝𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴",
    "CSK" to "𑄌𑄬𑄇𑄮𑄥𑄳𑄣𑄮𑄞𑄇𑄴 𑄦𑄢𑄴𑄓𑄴 𑄇𑄮𑄢𑄪𑄚",
    "CUC" to "𑄇𑄨𑄅𑄪𑄝𑄚𑄴 𑄝𑄮𑄘𑄮𑄣𑄨𑄛𑄢𑄬 𑄛𑄬𑄥𑄮",
    "CUP" to "𑄇𑄨𑄅𑄪𑄝𑄚𑄴 𑄛𑄬𑄥𑄮",
    "CVE" to "𑄇𑄬𑄛𑄴 𑄞𑄢𑄴𑄘𑄬 𑄃𑄬𑄥𑄴𑄇𑄪𑄓𑄮",
    "CYP" to "𑄥𑄭𑄛𑄳𑄢𑄥𑄴 𑄛𑄃𑄪𑄚𑄴𑄓𑄴",
    "CZK" to "𑄌𑄬𑄇𑄴 𑄛𑄳𑄢𑄧𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧 𑄇𑄮𑄢𑄪𑄚",
    "DDM" to "𑄛𑄪𑄉𑄬𑄘𑄨 𑄎𑄢𑄴𑄟𑄚𑄴 𑄟𑄢𑄴𑄇𑄴",
    "DEM" to "𑄓𑄧𑄠𑄧𑄌𑄴 𑄟𑄢𑄴𑄇𑄴",
    "DJF" to "𑄎𑄨𑄝𑄪𑄖𑄨 𑄜𑄳𑄢𑄁𑄇𑄴",
    "DKK" to "𑄓𑄳𑄠𑄚𑄨𑄌𑄴 𑄇𑄳𑄢𑄯𑄚𑄴",
    "DOP" to "𑄓𑄮𑄟𑄨𑄚𑄨𑄇𑄚𑄴 𑄛𑄬𑄥𑄮",
    "DZD" to "𑄃𑄢𑄴𑄎𑄬𑄢𑄩𑄠𑄧 𑄘𑄨𑄚𑄢𑄴",
    "ECS" to "𑄃𑄨𑄇𑄪𑄠𑄓𑄮𑄢𑄴 𑄥𑄪𑄇𑄳𑄢𑄬",
    "ECV" to "𑄃𑄨𑄇𑄪𑄠𑄓𑄮𑄢𑄴 𑄃𑄪𑄚𑄨𑄘𑄘𑄬𑄌𑄴 𑄘𑄨 𑄞𑄬𑄣𑄧𑄢𑄴 𑄇𑄧𑄚𑄴𑄥𑄴𑄖𑄚𑄴𑄖𑄬 (𑄃𑄨𑄅𑄪𑄞𑄨𑄥𑄨)",
    "EEK" to "𑄃𑄬𑄌𑄴𑄖𑄮𑄚𑄨𑄠 𑄇𑄳𑄢𑄪𑄚𑄨",
    "EGP" to "𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄴 𑄛𑄅𑄪𑄚𑄴𑄓𑄴",
    "ERN" to "𑄃𑄬𑄢𑄨𑄑𑄳𑄢𑄨𑄠𑄬𑄚𑄴 𑄚𑄇𑄴𑄜",
    "ESA" to "𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄥𑄴 𑄛𑄬𑄥𑄬𑄖 (𑄃𑄬𑄇𑄴𑄇𑄭𑄪 𑄦𑄨𑄎𑄬𑄛𑄴)",
    "ESB" to "𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄥𑄴 𑄛𑄬𑄥𑄬𑄖 (𑄝𑄮𑄘𑄮𑄣𑄬𑄭 𑄛𑄢𑄬 𑄦𑄨𑄎𑄬𑄛𑄴)",
    "ESP" to "𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄥𑄴 𑄛𑄬𑄥𑄬𑄖",
    "ETB" to "𑄃𑄨𑄗𑄨𑄃𑄮𑄛𑄨𑄠𑄚𑄴 𑄝𑄨𑄢𑄴",
    "EUR" to "𑄃𑄨𑄅𑄪𑄢𑄮",
    "FIM" to "𑄜𑄨𑄚𑄨𑄥𑄴 𑄟𑄢𑄴𑄇",
    "FJD" to "𑄜𑄨𑄎𑄨 𑄓𑄧𑄣𑄢𑄴",
    "FKP" to "𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬 𑄛𑄃𑄪𑄚𑄴𑄓𑄴",
    "FRF" to "𑄜𑄧𑄢𑄥𑄨 𑄜𑄳𑄢𑄁𑄇𑄴",
    "GBP" to "𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄛𑄃𑄪𑄚𑄴",
    "GEK" to "𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴 𑄇𑄪𑄛𑄧𑄚𑄴 𑄣𑄢𑄨𑄖𑄴",
    "GEL" to "𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴 𑄣𑄢𑄨",
    "GHC" to "𑄊𑄚 𑄥𑄬𑄓𑄨 (𑄷𑄿𑄽𑄿-𑄸𑄶𑄶𑄽)",
    "GHS" to "𑄊𑄚 𑄥𑄬𑄓𑄨",
    "GIP" to "𑄎𑄨𑄝𑄳𑄢𑄣𑄴𑄑𑄢𑄴 𑄛𑄅𑄪𑄚𑄳𑄓𑄴",
    "GMD" to "𑄉𑄟𑄴𑄝𑄨𑄠 𑄓𑄣𑄥𑄨",
    "GNF" to "𑄉𑄨𑄚𑄨 𑄜𑄳𑄢𑄋𑄳𑄇𑄴",
    "GNS" to "𑄉𑄨𑄚𑄨 𑄥𑄭𑄣𑄨",
    "GQE" to "𑄃𑄨𑄇𑄪𑄠𑄬𑄑𑄮𑄢𑄨𑄠𑄣𑄴 𑄉𑄨𑄚𑄨 𑄃𑄨𑄇𑄪𑄠𑄨𑄣𑄨",
    "GRD" to "𑄉𑄳𑄢𑄩𑄇𑄴 𑄘𑄳𑄢𑄌𑄴𑄟",
    "GTQ" to "𑄉𑄪𑄠𑄖𑄬𑄟𑄣𑄧 𑄇𑄪𑄠𑄬𑄖𑄴𑄎𑄣𑄴",
    "GWE" to "𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴 𑄉𑄨𑄚𑄨 𑄃𑄬𑄥𑄴𑄇𑄪𑄓𑄮",
    "GWP" to "𑄉𑄨𑄚𑄨 𑄥𑄨𑄥𑄅𑄪 𑄛𑄬𑄥𑄮",
    "GYD" to "𑄉𑄭𑄠𑄬𑄚 𑄓𑄧𑄣𑄢𑄴",
    "HKD" to "𑄦𑄧𑄁𑄇𑄧𑄁 𑄓𑄧𑄣𑄢𑄴",
    "HNL" to "𑄦𑄪𑄚𑄴𑄓𑄪𑄢𑄥𑄴 𑄣𑄬𑄟𑄴𑄛𑄨𑄢",
    "HRD" to "𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴",
    "HRK" to "𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠𑄚𑄴 𑄇𑄪𑄚",
    "HTG" to "𑄦𑄭𑄖𑄨 𑄉𑄯𑄢𑄴𑄘𑄬",
    "HUF" to "𑄦𑄋𑄴𑄉𑄬𑄢𑄨𑄠𑄚𑄴 𑄜𑄮𑄢𑄨𑄚𑄳𑄑𑄴",
    "IDR" to "𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨𑄠𑄳𑄦𑄴",
    "IEP" to "𑄃𑄨𑄢𑄨𑄌𑄴 𑄛𑄅𑄪𑄚𑄳𑄓𑄴",
    "ILP" to "𑄃𑄨𑄥𑄳𑄢𑄭𑄣𑄨 𑄛𑄅𑄪𑄚𑄳𑄓𑄴",
    "ILS" to "𑄃𑄨𑄥𑄳𑄢𑄭𑄣𑄨 𑄚𑄱 𑄥𑄬𑄇𑄬𑄣𑄴",
    "INR" to "𑄃𑄨𑄚𑄴𑄘𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨",
    "IQD" to "𑄃𑄨𑄢𑄇𑄨 𑄘𑄨𑄚𑄢𑄴",
    "IRR" to "𑄃𑄨𑄢𑄚𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄣𑄴",
    "ISK" to "𑄃𑄭𑄥𑄴𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄇𑄳𑄢𑄯𑄚𑄴",
    "ITL" to "𑄃𑄨𑄖𑄣𑄨𑄠𑄧 𑄣𑄨𑄢",
    "JMD" to "𑄎𑄟𑄭𑄇𑄚𑄴 𑄓𑄧𑄣𑄢𑄴",
    "JOD" to "𑄎𑄧𑄢𑄴𑄓𑄚𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴",
    "JPY" to "𑄎𑄛𑄚𑄨 𑄃𑄨𑄠𑄬𑄚𑄴",
    "KES" to "𑄇𑄬𑄚𑄨𑄠𑄚𑄴 𑄥𑄨𑄣𑄨𑄁",
    "KGS" to "𑄇𑄨𑄢𑄴𑄉𑄨𑄎𑄴𑄃𑄨𑄥𑄴𑄖𑄚𑄴 𑄥𑄮𑄟𑄴",
    "KHR" to "𑄇𑄧𑄟𑄴𑄝𑄮𑄓𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄬𑄣𑄴",
    "KMF" to "𑄇𑄧𑄟𑄴𑄝𑄮𑄢𑄮 𑄜𑄳𑄢𑄋𑄳𑄇𑄴",
    "KPW" to "𑄃𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄇𑄮𑄢𑄨𑄠𑄢𑄴 𑄃𑄮𑄚𑄴",
    "KRW" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄮𑄢𑄨𑄠𑄢𑄴 𑄃𑄮𑄚𑄴",
    "KWD" to "𑄇𑄪𑄠𑄬𑄖𑄨 𑄘𑄨𑄚𑄢𑄴",
    "KYD" to "𑄇𑄬𑄟𑄳𑄠𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄢𑄴 𑄓𑄧𑄣𑄢𑄴",
    "KZT" to "𑄇𑄎𑄈𑄥𑄴𑄖𑄚𑄨 𑄑𑄬𑄋𑄴𑄉𑄬",
    "LAK" to "𑄣𑄬𑄅𑄪𑄥𑄚𑄴 𑄇𑄨𑄛𑄴",
    "LBP" to "𑄣𑄬𑄝𑄚𑄨𑄎𑄴 𑄛𑄅𑄪𑄚𑄳𑄓𑄴",
    "LKR" to "𑄥𑄳𑄢𑄨𑄣𑄧𑄁𑄇𑄚𑄴 𑄢𑄪𑄛𑄨",
    "LRD" to "𑄣𑄨𑄝𑄬𑄢𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴",
    "LSL" to "𑄣𑄬𑄥𑄪𑄑𑄪 𑄣𑄮𑄑𑄨",
    "LTL" to "𑄣𑄨𑄗𑄭𑄪𑄚𑄨𑄠𑄚𑄴 𑄣𑄨𑄑",
    "LTT" to "𑄣𑄨𑄗𑄭𑄪𑄚𑄨𑄠𑄚𑄴 𑄑𑄣𑄮𑄚𑄳𑄠𑄥𑄴",
    "LUC" to "𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄴 𑄝𑄮𑄘𑄮𑄣𑄬𑄝𑄢𑄴 𑄜𑄳𑄢𑄇𑄳𑄋𑄴",
    "LUF" to "𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄴 𑄜𑄳𑄢𑄇𑄳𑄋𑄴",
    "LUL" to "𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄴 𑄜𑄭𑄚𑄬𑄚𑄴𑄥𑄨𑄠𑄣𑄴 𑄜𑄳𑄢𑄇𑄳𑄋𑄴",
    "LVL" to "𑄣𑄳𑄠𑄑𑄴𑄞𑄨𑄠𑄚𑄴 𑄣𑄳𑄠𑄑𑄴𑄥𑄴",
    "LVR" to "𑄣𑄳𑄠𑄑𑄴𑄞𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄧𑄣𑄴",
    "LYD" to "𑄣𑄨𑄝𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴",
    "MAD" to "𑄟𑄮𑄢𑄮𑄇𑄳𑄦𑄚𑄴 𑄘𑄨𑄢𑄴𑄦𑄟𑄴",
    "MAF" to "𑄟𑄮𑄢𑄮𑄇𑄳𑄦𑄚𑄴 𑄜𑄳𑄢𑄋𑄳𑄇𑄴",
    "MDL" to "𑄟𑄮𑄣𑄴𑄓𑄮𑄞𑄚𑄴 𑄣𑄬𑄠𑄪",
    "MGA" to "𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴 𑄃𑄢𑄨𑄠𑄢𑄨",
    "MGF" to "𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴 𑄜𑄳𑄢𑄋𑄳𑄇𑄴",
    "MKD" to "𑄟𑄳𑄠𑄥𑄬𑄓𑄮𑄚𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴",
    "MLF" to "𑄟𑄣𑄨 𑄜𑄳𑄢𑄋𑄳𑄇𑄴",
    "MMK" to "𑄟𑄠𑄚𑄴𑄟𑄢𑄴 𑄇𑄨𑄠𑄖𑄴",
    "MNT" to "𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄠𑄚𑄴 𑄖𑄪𑄇𑄴𑄢𑄨𑄇𑄴",
    "MOP" to "𑄟𑄳𑄠𑄇𑄳𑄠𑄃𑄮 𑄛𑄑𑄇",
    "MRO" to "𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄃𑄮𑄃𑄪𑄉𑄭𑄪𑄠",
    "MTL" to "𑄟𑄣𑄴𑄑 𑄣𑄨𑄢",
    "MTP" to "𑄟𑄣𑄴𑄑 𑄛𑄃𑄪𑄚𑄳𑄓𑄴",
    "MUR" to "𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨",
    "MVR" to "𑄟𑄣𑄴𑄘𑄨𑄞𑄨𑄠𑄚𑄴 𑄢𑄪𑄜𑄨𑄠",
    "MWK" to "𑄟𑄣𑄃𑄪𑄃𑄨𑄠𑄚𑄴 𑄇𑄧𑄤𑄌𑄴",
    "MXN" to "𑄟𑄳𑄠𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄛𑄬𑄥𑄮",
    "MXP" to "𑄟𑄳𑄠𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄥𑄨𑄣𑄴𑄞𑄢𑄴 𑄛𑄬𑄥𑄮 (𑄷𑄾𑄼𑄷-𑄷𑄿𑄿𑄸)",
    "MXV" to "𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄃𑄪𑄚𑄨𑄘𑄖𑄴 𑄘𑄨 𑄃𑄨𑄚𑄴𑄞𑄢𑄴𑄥𑄧𑄚𑄴(UDI)",
    "MYR" to "𑄟𑄣𑄴𑄠𑄬𑄥𑄨𑄠𑄚𑄴 𑄢𑄨𑄁𑄉𑄨𑄖𑄴",
    "MZE" to "𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴 𑄃𑄬𑄥𑄴𑄇𑄪𑄓𑄮",
    "MZM" to "𑄛𑄪𑄢𑄮𑄚𑄨 𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴 𑄟𑄬𑄑𑄨𑄇𑄬𑄣𑄴",
    "MZN" to "𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴 𑄟𑄬𑄑𑄨𑄇𑄬𑄣𑄴",
    "NAD" to "𑄚𑄟𑄨𑄝𑄨𑄠 𑄓𑄧𑄣𑄢𑄴",
    "NGN" to "𑄚𑄭𑄎𑄬𑄢𑄨𑄠𑄚𑄴 𑄚𑄠𑄴𑄢",
    "NIC" to "𑄚𑄨𑄇𑄢𑄉𑄪𑄠𑄚 𑄇𑄧𑄢𑄴𑄓𑄮𑄝(𑄷𑄿𑄾𑄾-𑄷𑄿𑄿𑄷)",
    "NIO" to "𑄚𑄨𑄇𑄢𑄉𑄪𑄠𑄚 𑄇𑄧𑄢𑄴𑄓𑄮𑄝",
    "NLG" to "𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄉𑄪𑄣𑄴𑄓𑄬𑄢𑄴",
    "NOK" to "𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬 𑄇𑄳𑄢𑄯𑄚𑄴",
    "NPR" to "𑄚𑄬𑄛𑄣𑄨 𑄢𑄪𑄛𑄨",
    "NZD" to "𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄓𑄧𑄣𑄢𑄴",
    "OMR" to "𑄃𑄮𑄟𑄚𑄨 𑄢𑄨𑄠𑄣𑄴",
    "PAB" to "𑄛𑄚𑄟 𑄝𑄬𑄣𑄴𑄝𑄮𑄠",
    "PEI" to "𑄛𑄬𑄢𑄪𑄞𑄨𑄠𑄚𑄴 𑄃𑄨𑄚𑄴𑄖𑄨",
    "PEN" to "𑄛𑄬𑄢𑄪𑄞𑄨𑄠𑄚𑄴 𑄥𑄮𑄣𑄴",
    "PES" to "𑄛𑄬𑄢𑄪𑄞𑄨𑄠𑄚𑄴 𑄥𑄮𑄣𑄴(𑄷𑄾𑄼𑄹-𑄷𑄿𑄼𑄻)",
    "PGK" to "𑄛𑄛𑄱 𑄚𑄨𑄃𑄪 𑄉𑄨𑄚𑄨 𑄉𑄨𑄚𑄨𑄠𑄚𑄴 𑄇𑄨𑄚",
    "PHP" to "𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴 𑄛𑄬𑄥𑄮",
    "PKR" to "𑄛𑄇𑄨𑄥𑄴𑄖𑄚𑄨 𑄢𑄪𑄛𑄨",
    "PLN" to "𑄛𑄮𑄣𑄨𑄌𑄴 𑄎𑄧𑄣𑄮𑄑𑄨",
    "PLZ" to "𑄛𑄮𑄣𑄨𑄌𑄴 𑄎𑄧𑄣𑄮𑄑𑄨(𑄷𑄿𑄻𑄶-𑄷𑄿𑄿𑄻)",
    "PTE" to "𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄌𑄴 𑄃𑄬𑄥𑄴𑄇𑄪𑄓𑄮",
    "PYG" to "𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄚𑄴 𑄉𑄪𑄠𑄢𑄚𑄨",
    "QAR" to "𑄇𑄖𑄢𑄴 𑄢𑄨𑄠𑄳𑄠𑄣𑄴",
    "RHD" to "𑄢𑄮𑄓𑄬𑄥𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴",
    "ROL" to "𑄛𑄪𑄢𑄮𑄚𑄨 𑄢𑄪𑄟𑄚𑄨𑄠 𑄣𑄬𑄠𑄪",
    "RON" to "𑄢𑄪𑄟𑄚𑄨𑄠 𑄣𑄬𑄠𑄪",
    "RSD" to "𑄥𑄢𑄴𑄝𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴",
    "RUB" to "𑄢𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴",
    "RUR" to "𑄢𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄧𑄣𑄴(𑄷𑄿𑄿𑄷-𑄷𑄿𑄿𑄾)",
    "RWF" to "𑄢𑄪𑄠𑄚𑄴𑄓𑄚𑄴 𑄜𑄳𑄢𑄋𑄳𑄇𑄴",
    "SAR" to "𑄥𑄯𑄘𑄨 𑄢𑄨𑄠𑄣𑄴",
    "SBD" to "𑄥𑄧𑄣𑄮𑄟𑄧𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄢𑄴 𑄓𑄧𑄣𑄢𑄴",
    "SCR" to "𑄥𑄬𑄠𑄧𑄥𑄬𑄣𑄴𑄣𑄮𑄃𑄨𑄌𑄴 𑄢𑄪𑄛𑄨",
    "SDD" to "𑄛𑄪𑄢𑄮𑄚𑄨 𑄥𑄪𑄘𑄚𑄨 𑄘𑄨𑄚𑄢𑄴",
    "SDG" to "𑄥𑄪𑄘𑄚𑄨 𑄛𑄃𑄪𑄚𑄳𑄓𑄴",
    "SDP" to "𑄛𑄪𑄢𑄮𑄚𑄨 𑄥𑄪𑄘𑄚𑄨 𑄛𑄃𑄪𑄚𑄳𑄓𑄴",
    "SEK" to "𑄥𑄭𑄪𑄓𑄨𑄥𑄴 𑄇𑄳𑄢𑄮𑄚",
    "SGD" to "𑄥𑄨𑄁𑄉𑄛𑄪𑄢𑄴 𑄓𑄧𑄣𑄢𑄴",
    "SHP" to "𑄥𑄬𑄚𑄳𑄑𑄴 𑄦𑄬𑄣𑄬𑄚 𑄛𑄃𑄪𑄚𑄳𑄓𑄴",
    "SIT" to "𑄥𑄳𑄣𑄮𑄞𑄚𑄨𑄠 𑄑𑄮𑄣𑄢𑄴",
    "SKK" to "𑄥𑄳𑄣𑄮𑄞𑄇𑄴 𑄇𑄮𑄢𑄪𑄚",
    "SLE" to "𑄥𑄨𑄠𑄬𑄢𑄣𑄨𑄠𑄧𑄚𑄴 𑄣𑄨𑄠𑄧𑄚𑄴",
    "SLL" to "𑄥𑄨𑄠𑄬𑄢𑄣𑄨𑄠𑄧𑄚𑄴 𑄣𑄨𑄠𑄧𑄚𑄴 (1964—2022)",
    "SOS" to "𑄥𑄮𑄟𑄣𑄨 𑄥𑄨𑄣𑄨𑄁",
    "SRD" to "𑄥𑄪𑄢𑄨𑄚𑄟𑄴 𑄓𑄧𑄣𑄢𑄴",
    "SRG" to "𑄥𑄪𑄢𑄨𑄚𑄟𑄴 𑄉𑄨𑄣𑄴𑄓𑄢𑄴",
    "SSP" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄪𑄘𑄚𑄨 𑄛𑄃𑄪𑄚𑄳𑄓𑄴",
    "STD" to "𑄥𑄃𑄮 𑄑𑄮𑄟𑄬 𑄃𑄳𑄃 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄬 𑄓𑄮𑄛𑄴𑄢",
    "SUR" to "𑄥𑄮𑄣𑄨𑄠𑄬𑄖𑄴 𑄢𑄪𑄝𑄧𑄣𑄴",
    "SVC" to "𑄃𑄬𑄣𑄴 𑄥𑄳𑄠𑄣𑄴𑄞𑄮𑄓𑄮𑄢𑄴 𑄇𑄮𑄣𑄮𑄚𑄴",
    "SYP" to "𑄥𑄨𑄢𑄨𑄠𑄚𑄴 𑄛𑄃𑄪𑄚𑄳𑄓𑄴",
    "SZL" to "𑄥𑄮𑄠𑄎𑄨𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄣𑄨𑄣𑄋𑄴𑄉𑄬𑄚𑄨",
    "THB" to "𑄗𑄭 𑄝𑄖𑄴",
    "TJR" to "𑄖𑄎𑄨𑄇𑄨𑄌𑄴𑄖𑄚𑄴 𑄢𑄪𑄝𑄧𑄣𑄴",
    "TJS" to "𑄖𑄎𑄨𑄇𑄨𑄌𑄴𑄖𑄚𑄴 𑄥𑄮𑄟𑄮𑄚𑄨",
    "TMM" to "𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄨 𑄟𑄚𑄖𑄴 (1993–2009)",
    "TMT" to "𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄨 𑄟𑄚𑄖𑄴",
    "TND" to "𑄖𑄨𑄃𑄪𑄚𑄬𑄥𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴",
    "TOP" to "𑄑𑄮𑄋𑄴𑄉 𑄛𑄳𑄃 𑄃𑄋𑄴𑄉",
    "TPE" to "𑄖𑄨𑄟𑄪𑄢𑄴 𑄃𑄬𑄌𑄴𑄇𑄪𑄓𑄮",
    "TRL" to "𑄛𑄪𑄢𑄮𑄚𑄴 𑄖𑄪𑄢𑄴𑄇𑄨 𑄣𑄨𑄢",
    "TRY" to "𑄖𑄪𑄢𑄴𑄇𑄨 𑄣𑄨𑄢",
    "TTD" to "𑄖𑄳𑄢𑄨𑄚𑄨𑄘𑄖𑄴 𑄃𑄳𑄃 𑄑𑄮𑄝𑄉𑄮 𑄓𑄧𑄣𑄢𑄴",
    "TWD" to "𑄚𑄱 𑄦𑄭𑄤𑄚𑄴𑄓𑄧𑄣𑄢𑄴",
    "TZS" to "𑄖𑄚𑄴𑄎𑄚𑄨𑄠 𑄥𑄨𑄣𑄨𑄁",
    "UAH" to "ই𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄭𑄚𑄴 𑄢𑄨𑄛𑄴𑄚𑄨𑄠",
    "UAK" to "𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄭𑄚𑄴 𑄇𑄢𑄴𑄝𑄮𑄞𑄳𑄠𑄚𑄴𑄑𑄧𑄌𑄴",
    "UGS" to "𑄃𑄪𑄉𑄚𑄴𑄓𑄚𑄴 𑄥𑄨𑄣𑄨𑄁 (𑄷𑄿𑄼𑄼-𑄷𑄿𑄾𑄽)",
    "UGX" to "𑄃𑄪𑄉𑄚𑄴𑄓𑄚𑄴 𑄥𑄨𑄣𑄨𑄁",
    "USD" to "𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄓𑄧𑄣𑄢𑄴",
    "USN" to "𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄓𑄧𑄣𑄢𑄴 (𑄛𑄧𑄢𑄬 𑄘𑄨𑄚𑄴)",
    "USS" to "𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄓𑄧𑄣𑄢𑄴 (𑄃𑄬𑄇𑄴𑄇𑄰𑄪 𑄘𑄨𑄚𑄴)",
    "UYI" to "𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄚𑄴 𑄛𑄬𑄥𑄮 𑄃𑄬𑄚𑄴 𑄃𑄪𑄚𑄨𑄘𑄘𑄬𑄌𑄴 𑄃𑄨𑄚𑄴𑄓𑄬𑄇𑄴𑄥𑄬𑄓𑄥𑄴",
    "UYP" to "𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄬 𑄛𑄬𑄥𑄮 (𑄷𑄿𑄽𑄻-𑄷𑄿𑄿𑄹)",
    "UYU" to "𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄬 𑄛𑄬𑄥𑄮",
    "UZS" to "𑄃𑄪𑄌𑄴𑄝𑄬𑄇𑄨𑄌𑄴𑄖𑄚𑄨 𑄥𑄮𑄟𑄴",
    "VEB" to "𑄞𑄬𑄚𑄨𑄎𑄪𑄔𑄮𑄣𑄚𑄴 𑄝𑄧𑄣𑄨𑄞𑄢𑄴(𑄷𑄾𑄽𑄷-𑄸𑄶𑄶𑄾)",
    "VEF" to "𑄞𑄬𑄚𑄨𑄎𑄪𑄔𑄮𑄣𑄚𑄴 𑄝𑄧𑄣𑄨𑄞𑄢𑄴",
    "VND" to "𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄨 𑄓𑄧𑄋𑄴𑄉𑄧",
    "VUV" to "𑄞𑄚𑄪𑄠𑄖𑄪 𑄞𑄖𑄪",
    "WST" to "𑄥𑄟𑄮𑄠𑄚𑄴 𑄑𑄣",
    "XAF" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴[CFA] 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴",
    "XAG" to "𑄥𑄨𑄣𑄴𑄞𑄢𑄴",
    "XAU" to "𑄉𑄮𑄣𑄳𑄓𑄴",
    "XCD" to "𑄛𑄪𑄉𑄬𑄘𑄨 𑄇𑄳𑄠𑄢𑄝𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴",
    "XEU" to "𑄃𑄨𑄃𑄪𑄢𑄮𑄛𑄨𑄠𑄚𑄴 𑄑𑄬𑄋𑄢𑄴 𑄃𑄬𑄇𑄧𑄇𑄴",
    "XFO" to "𑄜𑄧𑄢𑄥𑄨 𑄉𑄮𑄣𑄳𑄓𑄴 𑄜𑄳𑄢𑄋𑄳𑄇𑄴",
    "XFU" to "𑄜𑄧𑄢𑄥𑄨 𑄃𑄨𑄃𑄪𑄃𑄭𑄥𑄨 𑄜𑄳𑄢𑄋𑄳𑄇𑄴",
    "XOF" to "𑄛𑄧𑄎𑄨𑄟𑄴 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴 [CFA] 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴",
    "XPD" to "𑄛𑄳𑄠𑄣𑄬𑄓𑄨𑄠𑄟𑄴",
    "XPF" to "𑄥𑄨𑄃𑄬𑄛𑄴𑄛𑄨 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴",
    "XPT" to "𑄛𑄳𑄣𑄑𑄨𑄚𑄟𑄴",
    "XXX" to "𑄦𑄧𑄝𑄢𑄴 𑄚𑄧𑄛𑄬𑄠𑄬 𑄑𑄬𑄋",
    "YDD" to "𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄨 𑄘𑄨𑄚𑄢𑄴",
    "YER" to "𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄨 𑄢𑄨𑄠𑄣𑄴",
    "YUD" to "𑄡𑄪𑄉𑄮𑄥𑄳𑄣𑄞𑄨𑄠𑄧 𑄦𑄢𑄴𑄓𑄴 𑄘𑄨𑄚𑄢𑄴",
    "YUM" to "𑄡𑄪𑄉𑄮𑄥𑄳𑄣𑄞𑄨𑄠𑄧 𑄚𑄮𑄞𑄨 𑄘𑄨𑄚𑄢𑄴",
    "YUN" to "𑄡𑄪𑄉𑄮𑄥𑄳𑄣𑄞𑄨𑄠𑄧 𑄝𑄮𑄘𑄮𑄣𑄬𑄭𑄛𑄢𑄬 𑄘𑄨𑄚𑄢𑄴",
    "ZAR" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴 𑄢𑄳𑄠𑄚𑄳𑄓𑄴",
    "ZMK" to "𑄎𑄟𑄴𑄝𑄨𑄠𑄚𑄴 𑄇𑄧𑄤𑄌 (𑄷𑄿𑄼𑄾-𑄸𑄶𑄷𑄸)",
    "ZMW" to "𑄎𑄟𑄴𑄝𑄨𑄠𑄚𑄴 𑄇𑄧𑄤𑄌",
    "ZRN" to "𑄎𑄭𑄢𑄨𑄠𑄚𑄴 𑄚𑄨𑄅𑄪 𑄎𑄭𑄢𑄬 (1993–1998)",
    "ZRZ" to "𑄎𑄭𑄢𑄨𑄠𑄚𑄴 𑄚𑄨𑄅𑄪 𑄎𑄭𑄢𑄬 (1971–1993)",
    "ZWD" to "𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬 𑄓𑄧𑄣𑄢𑄴 (𑄷𑄿𑄾𑄶-𑄸𑄶𑄶𑄾)",
    "ZWL" to "𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬 𑄓𑄧𑄣𑄢𑄴 (𑄸𑄶𑄶𑄿)",
    "ZWR" to "𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬 𑄓𑄧𑄣𑄢𑄴 (𑄸𑄶𑄶𑄾)",
  ) }

  val ccp_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ce: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Дирхам ӀЦЭ",
    "AFN" to "ОвхӀан-пачхьалкхан афгани",
    "ALL" to "Албанин лек",
    "AMD" to "Эрмалойчоьнан драм",
    "ANG" to "Нидерландин Антилин гульден",
    "AOA" to "Анголан кванза",
    "ARS" to "Аргентинан песо",
    "AUD" to "Австралин доллар",
    "AWG" to "Арубан флорин",
    "AZN" to "Азербайджанан манат",
    "BAM" to "Боснин а, Герцеговинан а хийцалун марка",
    "BBD" to "Барбадосан доллар",
    "BDT" to "Бангладешан така",
    "BGN" to "Болгарин лев",
    "BHD" to "Бахрейнан динар",
    "BIF" to "Бурундин франк",
    "BMD" to "Бермудан доллар",
    "BND" to "Брунейн доллар",
    "BOB" to "Боливин боливиано",
    "BRL" to "Бразилин реал",
    "BSD" to "Багаман доллар",
    "BTN" to "Бутанан нгултрум",
    "BWP" to "Ботсванан пула",
    "BYN" to "Белоруссин сом",
    "BYR" to "Белоруссин сом (2000–2016)",
    "BZD" to "Белизин доллар",
    "CAD" to "Канадан доллар",
    "CDF" to "Конголезин франк",
    "CHF" to "Швейцарин франк",
    "CLP" to "Чилин песо",
    "CNY" to "Китайн юань",
    "COP" to "Колумбин песо",
    "CRC" to "Костарикан колон",
    "CUC" to "Кубан хийцалун песо",
    "CUP" to "Кубан песо",
    "CVE" to "Кабо-Верден эскудо",
    "CZK" to "Чехин крона",
    "DJF" to "Джибутин франк",
    "DKK" to "Данин крона",
    "DOP" to "Доминикан песо",
    "DZD" to "Алжиран динар",
    "EGP" to "Мисаран фунт",
    "ERN" to "Эритрейн накфа",
    "ETB" to "Эфиопин быр",
    "EUR" to "Евро",
    "FJD" to "Фиджин доллар",
    "FKP" to "Фолклендан гӀайренийн фунт",
    "GBP" to "Англин фунт",
    "GEL" to "Гуьржийчоьнан лари",
    "GHS" to "Ганан седи",
    "GIP" to "Гибралтаран фунт",
    "GMD" to "Гамбин даласи",
    "GNF" to "Гвинейн франк",
    "GTQ" to "Гватемалан кетсаль",
    "GYD" to "Гайанан доллар",
    "HKD" to "Гонконган доллар",
    "HNL" to "Гондурасан лемпира",
    "HRK" to "Хорватин куна",
    "HTG" to "Гаитин гурд",
    "HUF" to "Венгрин форинт",
    "IDR" to "Индонезин рупи",
    "ILS" to "Израилан керла шекель",
    "INR" to "Индин рупи",
    "IQD" to "Ӏиракъан динар",
    "IRR" to "ГӀажарийчоьнан риал",
    "ISK" to "Исландин крона",
    "JMD" to "Ямайн доллар",
    "JOD" to "Урданан динар",
    "JPY" to "Японин иена",
    "KES" to "Кенин шиллинг",
    "KGS" to "Киргизин сом",
    "KHR" to "Камбоджан риель",
    "KMF" to "Коморийн гӀайренийн франк",
    "KPW" to "Къилбаседа Корейн вона",
    "KRW" to "Къилба Корейн вона",
    "KWD" to "Кувейтан динар",
    "KYD" to "Кайманийн гӀайренийн доллар",
    "KZT" to "Кхазакхстанан тенге",
    "LAK" to "Лаосан кип",
    "LBP" to "Ливанан фунт",
    "LKR" to "Шри-Ланкан рупи",
    "LRD" to "Либерин доллар",
    "LYD" to "Ливин динар",
    "MAD" to "Мароккон дирхам",
    "MDL" to "Молдавин лей",
    "MGA" to "Малагасийн ариари",
    "MKD" to "Македонин динар",
    "MMK" to "Мьянман кьят",
    "MNT" to "Монголин тугрик",
    "MOP" to "Макаон патака",
    "MRO" to "Мавританин уги (1973–2017)",
    "MRU" to "Мавританин уги",
    "MUR" to "Маврикин рупи",
    "MVR" to "Мальдивийн руфи",
    "MWK" to "Малавин квача",
    "MXN" to "Мексикан песо",
    "MYR" to "Малайзин ринггит",
    "MZN" to "Мозамбикан метикал",
    "NAD" to "Намибин доллар",
    "NGN" to "Нигерин найра",
    "NIO" to "Никарагуан кордоба",
    "NOK" to "Норвегин крона",
    "NPR" to "Непалан рупи",
    "NZD" to "Керла Зеландин доллар",
    "OMR" to "Оманан риал",
    "PAB" to "Панаман бальбоа",
    "PEN" to "Перун соль",
    "PGK" to "Папуа — Керла Гвинейн кина",
    "PHP" to "Филиппинийн песо",
    "PKR" to "Пакистанан рупи",
    "PLN" to "Польшан злотый",
    "PYG" to "Парагвайн гуарани",
    "QAR" to "Катаран риал",
    "RON" to "Румынин лей",
    "RSD" to "Сербин динар",
    "RUB" to "Российн сом",
    "RWF" to "Руандан франк",
    "SAR" to "СаӀудийн Ӏаьрбийчоьнан риал",
    "SBD" to "Соломонан гӀайренийн доллар",
    "SCR" to "Сейшелан рупи",
    "SDG" to "Суданан фунт",
    "SEK" to "Швецин крона",
    "SGD" to "Сингапуран доллар",
    "SHP" to "Сийлахьчу Еленин гӀайрен фунт",
    "SLE" to "Леоне",
    "SLL" to "Леоне (1964—2022)",
    "SOS" to "Сомалин шиллинг",
    "SRD" to "Суринаман доллар",
    "SSP" to "Къилба Суданан фунт",
    "STD" to "Сан-Томен а, Принсипин а добра (1977–2017)",
    "STN" to "Сан-Томен а, Принсипин а добра",
    "SYP" to "Шеман фунт",
    "SZL" to "Свазилендан лилангени",
    "THB" to "Таиландан бат",
    "TJS" to "Таджикистанан сомони",
    "TMT" to "Туркменин керла манат",
    "TND" to "Тунисан динар",
    "TOP" to "Тонганан паанга",
    "TRY" to "Туркойчоьнан лира",
    "TTD" to "Тринидадан а, Тобагон а доллар",
    "TWD" to "Тайванан керла доллар",
    "TZS" to "Танзанин шиллинг",
    "UAH" to "Украинан гривна",
    "UGX" to "Угандан шиллинг",
    "USD" to "АЦШн доллар",
    "UYU" to "Уругвайн песо",
    "UZS" to "Узбекистанан сом",
    "VEF" to "Венесуэлан боливар (2008–2018)",
    "VES" to "Венесуэлан боливар",
    "VND" to "Вьетнаман донг",
    "VUV" to "Вануатун вату",
    "WST" to "Самоанан тала",
    "XAF" to "Юккъерчу Африкан КФА франк",
    "XCD" to "Малхбален Карибийн доллар",
    "XOF" to "Малхбузен Африкан КФА франк",
    "XPF" to "Французийн Тийна океанан франк",
    "XXX" to "девзаш доцу я лелаш доцу ахча",
    "YER" to "Йеменан риал",
    "ZAR" to "Къилба-Африкин рэнд",
    "ZMW" to "Замбин квача",
  ) }

  val ceb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "United Arab Emirates Dirham",
    "AFN" to "Afghan Afghani",
    "ALL" to "Albanian Lek",
    "AMD" to "Armenian Dram",
    "ANG" to "Netherlands Antillean Guilder",
    "AOA" to "Angolan Kwanza",
    "ARS" to "Argentine Peso",
    "AUD" to "Australian Dollar",
    "AWG" to "Aruban Florin",
    "AZN" to "Azerbaijani Manat",
    "BAM" to "Bosnia-Herzegovina Convertible Mark",
    "BBD" to "Barbadian Dollar",
    "BDT" to "Bangladeshi Taka",
    "BGN" to "Bulgarian Lev",
    "BHD" to "Bahraini Dinar",
    "BIF" to "Burundian Franc",
    "BMD" to "Bermudan Dollar",
    "BND" to "Brunei Dollar",
    "BOB" to "Bolivian Boliviano",
    "BRL" to "Brazilian Real",
    "BSD" to "Bahamian Dollar",
    "BTN" to "Bhutanese Ngultrum",
    "BWP" to "Botswanan Pula",
    "BYN" to "Belarusian Ruble",
    "BZD" to "Belize Dollar",
    "CAD" to "Canadian Dollar",
    "CDF" to "Congolese Franc",
    "CHF" to "Swiss Franc",
    "CLP" to "Chilean Peso",
    "CNH" to "Chinese Yuan (offshore)",
    "CNY" to "Chinese Yuan",
    "COP" to "Colombian Peso",
    "CRC" to "Costa Rican Colon",
    "CUC" to "Cuban Convertible Peso",
    "CUP" to "Cuban Peso",
    "CVE" to "Cape Verdean Escudo",
    "CZK" to "Czech Koruna",
    "DJF" to "Djiboutian Franc",
    "DKK" to "Danish Krone",
    "DOP" to "Dominican Peso",
    "DZD" to "Algerian Dinar",
    "EGP" to "Egyptian Pound",
    "ERN" to "Eritrean Nakfa",
    "ETB" to "Ethiopian Birr",
    "EUR" to "Euro",
    "FJD" to "Fijian Dollar",
    "FKP" to "Falkland Islands Pound",
    "GBP" to "British Pound",
    "GEL" to "Georgian Lari",
    "GHS" to "Ghanaian Cedi",
    "GIP" to "Gibraltar Pound",
    "GMD" to "Gambian Dalasi",
    "GNF" to "Guinean Franc",
    "GTQ" to "Guatemalan Quetzal",
    "GYD" to "Guyanaese Dollar",
    "HKD" to "Hong Kong Dollar",
    "HNL" to "Honduran Lempira",
    "HRK" to "Croatian Kuna",
    "HTG" to "Haitian Gourde",
    "HUF" to "Hungarian Forint",
    "IDR" to "Indonesian Rupiah",
    "ILS" to "Israeli New Shekel",
    "INR" to "Indian Rupee",
    "IQD" to "Iraqi Dinar",
    "IRR" to "Iranian Rial",
    "ISK" to "Icelandic Krona",
    "JMD" to "Jamaican Dollar",
    "JOD" to "Jordanian Dinar",
    "JPY" to "Japanese Yen",
    "KES" to "Kenyan Shilling",
    "KGS" to "Kyrgystani Som",
    "KHR" to "Cambodian Riel",
    "KMF" to "Comorian Franc",
    "KPW" to "North Korean Won",
    "KRW" to "South Korean Won",
    "KWD" to "Kuwaiti Dinar",
    "KYD" to "Cayman Islands Dollar",
    "KZT" to "Kazakhstani Tenge",
    "LAK" to "Laotian Kip",
    "LBP" to "Lebanese Pound",
    "LKR" to "Sri Lankan Rupee",
    "LRD" to "Liberian Dollar",
    "LSL" to "Lesotho Loti",
    "LYD" to "Libyan Dinar",
    "MAD" to "Moroccan Dirham",
    "MDL" to "Moldovan Leu",
    "MGA" to "Malagasy Ariary",
    "MKD" to "Macedonian Denar",
    "MMK" to "Myanmar Kyat",
    "MNT" to "Mongolian Tugrik",
    "MOP" to "Macanese Pataca",
    "MRU" to "Mauritanian Ouguiya",
    "MUR" to "Mauritian Rupee",
    "MVR" to "Maldivian Rufiyaa",
    "MWK" to "Malawian Kwacha",
    "MXN" to "Mexican Peso",
    "MYR" to "Malaysian Ringgit",
    "MZN" to "Mozambican Metical",
    "NAD" to "Namibian Dollar",
    "NGN" to "Nigerian Naira",
    "NIO" to "Nicaraguan Cordoba",
    "NOK" to "Norwegian Krone",
    "NPR" to "Nepalese Rupee",
    "NZD" to "New Zealand Dollar",
    "OMR" to "Omani Rial",
    "PAB" to "Panamanian Balboa",
    "PEN" to "Peruvian Sol",
    "PGK" to "Papua New Guinean Kina",
    "PHP" to "Philippine Peso",
    "PKR" to "Pakistani Rupee",
    "PLN" to "Polish Zloty",
    "PYG" to "Paraguayan Guarani",
    "QAR" to "Qatari Rial",
    "RON" to "Romanian Leu",
    "RSD" to "Serbian Dinar",
    "RUB" to "Russian Ruble",
    "RWF" to "Rwandan Franc",
    "SAR" to "Saudi Riyal",
    "SBD" to "Solomon Islands Dollar",
    "SCR" to "Seychellois Rupee",
    "SDG" to "Sudanese Pound",
    "SEK" to "Swedish Krona",
    "SGD" to "Singapore Dollar",
    "SHP" to "St. Helena Pound",
    "SLE" to "Sierra Leonean Leone",
    "SLL" to "Sierra Leonean Leone (1964—2022)",
    "SOS" to "Somali Shilling",
    "SRD" to "Surinamese Dollar",
    "SSP" to "South Sudanese Pound",
    "STN" to "Sao Tome & Principe Dobra",
    "SYP" to "Syrian Pound",
    "SZL" to "Swazi Lilangeni",
    "THB" to "Thai Baht",
    "TJS" to "Tajikistani Somoni",
    "TMT" to "Turkmenistani Manat",
    "TND" to "Tunisian Dinar",
    "TOP" to "Tongan Paʻanga",
    "TRY" to "Turkish Lira",
    "TTD" to "Trinidad & Tobago Dollar",
    "TWD" to "New Taiwan Dollar",
    "TZS" to "Tanzanian Shilling",
    "UAH" to "Ukrainian Hryvnia",
    "UGX" to "Ugandan Shilling",
    "USD" to "US Dollar",
    "UYU" to "Uruguayan Peso",
    "UZS" to "Uzbekistani Som",
    "VES" to "Venezuelan Bolivar",
    "VND" to "Vietnamese Dong",
    "VUV" to "Vanuatu Vatu",
    "WST" to "Samoan Tala",
    "XAF" to "Central African CFA Franc",
    "XCD" to "East Caribbean Dollar",
    "XOF" to "West African CFA Franc",
    "XPF" to "CFP Franc",
    "XXX" to "Wala Nailhi nga Kwarta",
    "YER" to "Yemeni Rial",
    "ZAR" to "South African Rand",
    "ZMW" to "Zambian Kwacha",
  ) }

  val cgg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham za Buharabu",
    "AOA" to "Kwanza ya Angora",
    "AUD" to "Doora ya Austureeriya",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pura ya Botswana",
    "CAD" to "Doora ya Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Swisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Gyibuti",
    "DZD" to "Dinari ya Arigyeriya",
    "EGP" to "Paundi ya Misiri",
    "ERN" to "Nakfa ya Eritireya",
    "ETB" to "Birr ya Ethiopiya",
    "EUR" to "Yuro",
    "GBP" to "Paundi ya Bungyereza",
    "GHC" to "Cedi ya Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Guinea",
    "INR" to "Rupiya ya India",
    "JPY" to "Yeni ya Japaani",
    "KES" to "Shiringi ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Doora ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirram ya Moroko",
    "MGA" to "Ariari ya Maragariita",
    "MRO" to "Ougwiya ya Mouriteeniya (1973–2017)",
    "MRU" to "Ougwiya ya Mouriteeniya",
    "MUR" to "Rupiiha ya Mauritiasi",
    "MWK" to "Kwaca ya Malawi",
    "MZM" to "Metikari ya Mozambikwi",
    "NAD" to "Doora ya Namibiya",
    "NGN" to "Naira ya Naigyeriya",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riya ya Saudi",
    "SCR" to "Rupiiha ya Sherisheri",
    "SDG" to "Dinari ya Sudani",
    "SDP" to "Paundi ya Sudan",
    "SHP" to "Paundi ya Senti Herena",
    "SLE" to "Leone",
    "SLL" to "Leone (1964—2022)",
    "SOS" to "Eshiringi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Purinsipo (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Purinsipo",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "Eshiringi ya Tanzania",
    "UGX" to "Eshiringi ya Uganda",
    "USD" to "Doora ya America",
    "XAF" to "Faranga ya CFA BEAC",
    "XOF" to "Faranga ya CFA BCEAO",
    "ZAR" to "Randi ya Sausi Afirika",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Doora ya Zimbabwe",
  ) }

  val cho: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val chr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎡᎳᏈ ᎢᎹᎵᏘᏏ ᎠᏕᎳ",
    "AFN" to "ᎠᏫᎨᏂᏍᏖᏂ ᎠᏕᎳ",
    "ALL" to "ᎠᎵᏇᏂᏯ ᎠᏕᎳ",
    "AMD" to "ᎠᎵᎻᏂᎠ ᎠᏕᎳ",
    "ANG" to "ᎾᏍᎩᏁᏛᎳᏂ ᎠᏂᏘᎵᏏ ᎠᏕᎳ",
    "AOA" to "ᎠᏂᎪᎳ ᎠᏕᎳ",
    "ARS" to "ᎠᏥᏂᏘᏂᎠ ᎠᏕᎳ",
    "AUD" to "ᎡᎳᏗᏜ ᎠᏕᎳ",
    "AWG" to "ᎠᎷᏆ ᎠᏕᎳ",
    "AZN" to "ᎠᏏᎵᏆᏌᏂ ᎠᏕᎳ",
    "BAM" to "ᏉᏏᏂᎠ-ᎲᏤᎪᏫ ᎦᏁᏟᏴᏍᏔᏅ ᎠᏕᎳ",
    "BBD" to "ᏆᏇᏙᏍ ᎠᏕᎳ",
    "BDT" to "ᏆᏂᎦᎵᏕᏍ ᎠᏕᎳ",
    "BGN" to "ᏊᎵᎨᎵᎠ ᎠᏕᎳ",
    "BHD" to "ᏆᎭᎴᎢᏂ ᎠᏕᎳ",
    "BIF" to "ᏋᎷᏂᏗ ᎠᏕᎳ",
    "BMD" to "ᏆᏊᏓ ᎠᏕᎳ",
    "BND" to "ᏊᎾᎢ ᎠᏕᎳ",
    "BOB" to "ᏉᎵᏫᎠ ᎠᏕᎳ",
    "BRL" to "ᏆᏏᎵᎢ ᎠᏕᎳ",
    "BSD" to "ᏆᎭᎹ ᎠᏕᎳ",
    "BTN" to "ᏊᏔᏂ ᎠᏕᎳ",
    "BWP" to "ᏆᏣᏩᎾ ᎠᏕᎳ",
    "BYN" to "ᏇᎳᎷᏍ ᎠᏕᎳ",
    "BYR" to "ᏇᎳᎷᏍ ᎠᏕᎳ (2000–2016)",
    "BZD" to "ᏇᎵᏍ ᎠᏕᎳ",
    "CAD" to "ᎨᎾᏓ ᎠᏕᎳ",
    "CDF" to "ᎧᏂᎪ ᎠᏕᎳ",
    "CHF" to "ᏍᏫᏏ ᎠᏕᎳ",
    "CLP" to "ᏥᎵ ᎠᏕᎳ",
    "CNH" to "ᏣᏂᏏ ᎠᏕᎳ (ᏓᎹᏳᏟᏗ)",
    "CNY" to "ᏓᎶᏂᎨ ᎠᏕᎳ",
    "COP" to "ᎪᎸᎻᏈᎢᎠ ᎠᏕᎳ",
    "CRC" to "ᎪᏍᏓᎵᎧ ᎠᏕᎳ",
    "CUC" to "ᎫᏆ ᎦᏁᏟᏴᏍᏔᏅ ᎠᏕᎳ",
    "CUP" to "ᎫᏆ ᎠᏕᎳ",
    "CVE" to "ᎢᎬᎾᏕᎾ ᎢᏤᏳᏍᏗ ᎠᏕᎳ",
    "CZK" to "ᏤᎩ ᎠᏕᎳ",
    "DJF" to "ᏥᏊᏗ ᎠᏕᎳ",
    "DKK" to "ᏕᏂᏍ ᎠᏕᎳ",
    "DOP" to "ᏙᎻᏂᎧᏂ ᎠᏕᎳ",
    "DZD" to "ᎠᎵᏥᎵᏯ ᎠᏕᎳ",
    "EGP" to "ᎢᏥᏈᎢ ᎠᏕᎳ",
    "ERN" to "ᎡᎵᏟᏯ ᎠᏕᎳ",
    "ETB" to "ᎢᏗᎣᏈᎠ ᎠᏕᎳ",
    "EUR" to "ᏳᎳᏛ ᎠᏕᎳ",
    "FJD" to "ᏫᎩ ᎠᏕᎳ",
    "FKP" to "ᏩᎩᎤ ᏚᎦᏚᏛᎢ ᎠᏕᎳ",
    "GBP" to "ᎩᎵᏏᏲ ᎠᏕᎳ",
    "GEL" to "ᏣᎠᏥᎢ ᎠᏕᎳ",
    "GHS" to "ᎦᎠᎾ ᎠᏕᎳ",
    "GIP" to "ᏥᏆᎵᏓ ᎠᏕᎳ",
    "GMD" to "ᎦᎹᏈᎢᎠ ᎠᏕᎳ",
    "GNF" to "ᎩᎢᏂ ᎠᏕᎳ",
    "GTQ" to "ᏆᏖᎹᎳ ᎠᏕᎳ",
    "GYD" to "ᎦᏯᎾ ᎠᏕᎳ",
    "HKD" to "ᎰᏂᎩ ᎪᏂᎩ ᎠᏕᎳ",
    "HNL" to "ᎭᏂᏚᎳᏍ ᎠᏕᎳ",
    "HRK" to "ᎧᎶᎡᏏᎠ ᎠᏕᎳ",
    "HTG" to "ᎮᏘ ᎠᏕᎳ",
    "HUF" to "ᎲᏂᎦᎵ ᎠᏕᎳ",
    "IDR" to "ᎢᏂᏙᏂᏍᏯ ᎠᏕᎳ",
    "ILS" to "ᎢᏏᎵᏱ ᎢᏤ ᎠᏕᎳ",
    "INR" to "ᎢᏂᏗᎢᎠ ᎠᏕᎳ",
    "IQD" to "ᎢᎳᎩ ᎠᏕᎳ",
    "IRR" to "ᎢᎴᏂ ᎠᏕᎳ",
    "ISK" to "ᏧᏁᏍᏓᎸᎯ ᎠᏕᎳ",
    "JMD" to "ᏣᎺᎢᎧ ᎠᏕᎳ",
    "JOD" to "ᏦᏓᏂ ᎠᏕᎳ",
    "JPY" to "ᏣᏩᏂᏏ ᎠᏕᎳ",
    "KES" to "ᎨᏂᏯ ᎠᏕᎳ",
    "KGS" to "ᎩᎵᏣᎢᏍ ᎠᏕᎳ",
    "KHR" to "ᎧᎹᏉᏗᎠᏂ ᎠᏕᎳ",
    "KMF" to "ᎪᎼᎳᏍ ᎠᏕᎳ",
    "KPW" to "ᏧᏴᏢ ᎪᎵᎠ ᎠᏕᎳ",
    "KRW" to "ᏧᎦᎾᏮ ᎪᎵᎠ ᎠᏕᎳ",
    "KWD" to "ᎫᏪᎢᏘ ᎠᏕᎳ",
    "KYD" to "ᎨᎢᎹᏂ ᏚᎦᏚᏛᎢ ᎠᏕᎳ",
    "KZT" to "ᎧᏎᎧᏍᏕᏂ ᎠᏕᎳ",
    "LAK" to "ᎳᎣ ᎠᏕᎳ",
    "LBP" to "ᎴᏆᎾᏂ ᎠᏕᎳ",
    "LKR" to "ᏍᎵ ᎳᏂᎧ ᎠᏕᎳ",
    "LRD" to "ᎳᏈᎵᏯ ᎠᏕᎳ",
    "LSL" to "ᎴᏐᏠ ᎶᏘ",
    "LYD" to "ᎵᏈᏯ ᎠᏕᎳ",
    "MAD" to "ᎼᎶᎪ ᎠᏕᎳ",
    "MDL" to "ᎹᎵᏙᏫᎠ ᎠᏕᎳ",
    "MGA" to "ᎹᎳᎦᏏ ᎠᏕᎳ",
    "MKD" to "ᎹᏎᏙᏂᎠ ᎠᏕᎳ",
    "MMK" to "ᎹᏯᎹᎵ ᎠᏕᎳ",
    "MNT" to "ᎹᏂᎪᎵᎠ ᎠᏕᎳ",
    "MOP" to "ᎹᎧᎣ ᎠᏕᎳ",
    "MRO" to "ᎹᏈᏔᏂᎠ ᎠᏕᎳ (1973–2017)",
    "MRU" to "ᎹᏈᏔᏂᎠ ᎠᏕᎳ",
    "MUR" to "ᎹᏘᎢᏯ ᎠᏕᎳ",
    "MVR" to "ᎹᎵᏗᏫᏍ ᎠᏕᎳ",
    "MWK" to "ᎹᎳᏫ ᎠᏕᎳ",
    "MXN" to "ᏍᏆᏂ ᎠᏕᎳ",
    "MYR" to "ᎹᎴᏏᎢᎠ ᎠᏕᎳ",
    "MZN" to "ᎼᏎᎻᏇᎩ ᎠᏕᎳ",
    "NAD" to "ᎾᎻᏈᎢᏯ ᎠᏕᎳ",
    "NGN" to "ᏂᏥᎵᏯ ᎠᏕᎳ",
    "NIO" to "ᏂᎧᎳᏆ ᎠᏕᎳ",
    "NOK" to "ᏃᏪ ᎠᏕᎳ",
    "NPR" to "ᏁᏆᎵ ᎠᏕᎳ",
    "NZD" to "ᎢᏤ ᏏᎢᎴᏂᏗ ᎠᏕᎳ",
    "OMR" to "ᎣᎺᏂ ᎠᏕᎳ",
    "PAB" to "ᏆᎾᎹ ᎠᏕᎳ",
    "PEN" to "ᏇᎷ ᎠᏕᎳ",
    "PGK" to "ᏆᏇ ᎢᏤ ᎩᎢᏂ ᎠᏕᎳ",
    "PHP" to "ᎠᏂᏈᎵᎩᏃ ᎠᏕᎳ",
    "PKR" to "ᏆᎩᏍᏖᏂ ᎠᏕᎳ",
    "PLN" to "ᏉᎳᏂ ᎠᏕᎳ",
    "PYG" to "ᏆᎳᏇᎢᏯ ᎠᏕᎳ",
    "QAR" to "ᎧᏔᎵ ᎠᏕᎳ",
    "RON" to "ᎶᎹᏂᏯ ᎠᏕᎳ",
    "RSD" to "ᏒᏈᏯ ᎠᏕᎳ",
    "RUB" to "ᏲᏂᎢ ᎠᏕᎳ",
    "RWF" to "ᎶᏩᏂᏓ ᎠᏕᎳ",
    "SAR" to "ᏌᎤᏗ ᎠᏕᎳ",
    "SBD" to "ᏐᎶᎹᏂ ᏚᎦᏚᏛᎢ ᎠᏕᎳ",
    "SCR" to "ᏏᎡᏥᎵᏍ ᎠᏕᎳ",
    "SDG" to "ᏑᏕᏂ ᎠᏕᎳ",
    "SEK" to "ᏍᏫᏕᏂ ᎠᏕᎳ",
    "SGD" to "ᏏᏂᎦᏉᎵ ᎠᏕᎳ",
    "SHP" to "ᎤᏓᏅᏘ ᎮᎵᎾ ᎠᏕᎳ",
    "SLE" to "ᏏᎡᎳᎴᎣᏂ ᎠᏕᎳ",
    "SLL" to "ᏏᎡᎳᎴᎣᏂ ᎠᏕᎳ (1964—2022)",
    "SOS" to "ᏐᎹᎵ ᎠᏕᎳ",
    "SRD" to "ᏒᎵᎾᎻ ᎠᏕᎳ",
    "SSP" to "ᏧᎦᎾᏮ ᏑᏕᏂ ᎠᏕᎳ",
    "STD" to "ᏌᎣᏙᎺ ᎠᎴ ᏈᏂᏏᏇ ᎠᏕᎳ (1977–2017)",
    "STN" to "ᏌᎣᏙᎺ & ᏈᏂᏏᏇ ᎠᏕᎳ",
    "SYP" to "ᏏᎵᎠ ᎠᏕᎳ",
    "SZL" to "ᏍᏩᏏ ᎠᏕᎳ",
    "THB" to "ᏔᏯᎴᏂ ᎠᏕᎳ",
    "TJS" to "ᏔᏥᎩᏍᏕᏂ ᎠᏕᎳ",
    "TMT" to "ᏛᎵᎩᎺᏂᏍᏔᏂ ᎠᏕᎳ",
    "TND" to "ᏚᏂᏏᏍᎠ ᎠᏕᎳ",
    "TOP" to "ᏔᏂᎪ ᎠᏕᎳ",
    "TRY" to "ᎬᏃ ᎠᏕᎳ",
    "TTD" to "ᏟᏂᏕᏗ & ᏙᏆᎪ ᎠᏕᎳ",
    "TWD" to "ᎢᏤ ᏔᎢᏩᏂ ᎠᏕᎳ",
    "TZS" to "ᏖᏂᏏᏂᏯ ᎠᏕᎳ",
    "UAH" to "ᏳᎧᎴᏂ ᎠᏕᎳ",
    "UGX" to "ᏳᎦᏂᏓ ᎠᏕᎳ",
    "USD" to "US ᎠᏕᎳ",
    "UYU" to "ᏳᎷᏇ ᎠᏕᎳ",
    "UZS" to "ᎤᏍᏇᎩᏍᏖᏂ ᎠᏕᎳ",
    "VEF" to "ᏪᏁᏑᏪ ᎠᏕᎳ (2008–2018)",
    "VES" to "ᏪᏁᏑᏪ ᎠᏕᎳ",
    "VND" to "ᏫᎡᏘᎾᎻᏍ ᎠᏕᎳ",
    "VUV" to "ᏩᏂᎤᏩᏚ ᎠᏕᎳ",
    "WST" to "ᏌᎼᎠ ᎠᏕᎳ",
    "XAF" to "ᎠᏰᏟ ᎬᎿᎨᏍᏛ CFA ᎠᏕᎳ",
    "XCD" to "ᏗᎧᎸᎬ ᎨᏆᏙᏯ ᎠᏕᎳ",
    "XOF" to "ᏭᏕᎵᎬ ᎬᎿᎨᏍᏛ CFA ᎠᏕᎳ",
    "XPF" to "CFP ᎠᏕᎳ",
    "XXX" to "ᏄᏬᎵᏍᏛᎾ ᎠᏕᎳ",
    "YER" to "ᏰᎺᏂ ᎠᏕᎳ",
    "ZAR" to "ᏧᎦᎾᏮ ᎬᎿᎨᏍᏛ ᎠᏕᎳ",
    "ZMW" to "ᏏᎻᏆᏇ ᎠᏕᎳ",
  ) }

  val cic: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ckb: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ckb_IR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val co: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val cs: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "andorrská peseta",
    "AED" to "SAE dirham",
    "AFA" to "afghánský afghán (1927–2002)",
    "AFN" to "afghánský afghán",
    "ALK" to "albánský lek (1946–1965)",
    "ALL" to "albánský lek",
    "AMD" to "arménský dram",
    "ANG" to "nizozemskoantilský gulden",
    "AOA" to "angolská kwanza",
    "AOK" to "angolská kwanza (1977–1991)",
    "AON" to "angolská kwanza (1990–2000)",
    "AOR" to "angolská kwanza (1995–1999)",
    "ARA" to "argentinský austral",
    "ARL" to "argentinské peso ley (1970–1983)",
    "ARM" to "argentinské peso (1881–1970)",
    "ARP" to "argentinské peso (1983–1985)",
    "ARS" to "argentinské peso",
    "ATS" to "rakouský šilink",
    "AUD" to "australský dolar",
    "AWG" to "arubský zlatý",
    "AZM" to "ázerbájdžánský manat (1993–2006)",
    "AZN" to "ázerbájdžánský manat",
    "BAD" to "bosenský dinár (1992–1994)",
    "BAM" to "bosenská konvertibilní marka",
    "BAN" to "bosenský nový dinár (1994–1997)",
    "BBD" to "barbadoský dolar",
    "BDT" to "bangladéšská taka",
    "BEC" to "belgický konvertibilní frank",
    "BEF" to "belgický frank",
    "BEL" to "belgický finanční frank",
    "BGL" to "bulharský tvrdý leva",
    "BGM" to "bulharský socialistický leva",
    "BGN" to "bulharský leva",
    "BGO" to "bulharský lev (1879–1952)",
    "BHD" to "bahrajnský dinár",
    "BIF" to "burundský frank",
    "BMD" to "bermudský dolar",
    "BND" to "brunejský dolar",
    "BOB" to "bolivijský boliviano",
    "BOL" to "bolivijský boliviano (1863–1963)",
    "BOP" to "bolivijské peso",
    "BOV" to "bolivijský mvdol",
    "BRB" to "brazilské nové cruzeiro (1967–1986)",
    "BRC" to "brazilské cruzado (1986–1989)",
    "BRE" to "brazilské cruzeiro (1990–1993)",
    "BRL" to "brazilský real",
    "BRN" to "brazilské nové cruzado (1989–1990)",
    "BRR" to "brazilské cruzeiro (1993–1994)",
    "BRZ" to "brazilské cruzeiro (1942–1967)",
    "BSD" to "bahamský dolar",
    "BTN" to "bhútánský ngultrum",
    "BUK" to "barmský kyat",
    "BWP" to "botswanská pula",
    "BYB" to "běloruský rubl (1994–1999)",
    "BYN" to "běloruský rubl",
    "BYR" to "běloruský rubl (2000–2016)",
    "BZD" to "belizský dolar",
    "CAD" to "kanadský dolar",
    "CDF" to "konžský frank",
    "CHE" to "švýcarské WIR-euro",
    "CHF" to "švýcarský frank",
    "CHW" to "švýcarský WIR-frank",
    "CLE" to "chilské escudo",
    "CLF" to "chilská účetní jednotka (UF)",
    "CLP" to "chilské peso",
    "CNH" to "čínský jüan (offshore)",
    "CNX" to "čínský dolar ČLB",
    "CNY" to "čínský jüan",
    "COP" to "kolumbijské peso",
    "COU" to "kolumbijská jednotka reálné hodnoty",
    "CRC" to "kostarický colón",
    "CSD" to "srbský dinár (2002–2006)",
    "CSK" to "československá koruna",
    "CUC" to "kubánské konvertibilní peso",
    "CUP" to "kubánské peso",
    "CVE" to "kapverdské escudo",
    "CYP" to "kyperská libra",
    "CZK" to "česká koruna",
    "DDM" to "východoněmecká marka",
    "DEM" to "německá marka",
    "DJF" to "džibutský frank",
    "DKK" to "dánská koruna",
    "DOP" to "dominikánské peso",
    "DZD" to "alžírský dinár",
    "ECS" to "ekvádorský sucre",
    "ECV" to "ekvádorská jednotka konstantní hodnoty",
    "EEK" to "estonská koruna",
    "EGP" to "egyptská libra",
    "ERN" to "eritrejská nakfa",
    "ESA" to "španělská peseta („A“ účet)",
    "ESB" to "španělská peseta (konvertibilní účet)",
    "ESP" to "španělská peseta",
    "ETB" to "etiopský birr",
    "EUR" to "euro",
    "FIM" to "finská marka",
    "FJD" to "fidžijský dolar",
    "FKP" to "falklandská libra",
    "FRF" to "francouzský frank",
    "GBP" to "britská libra",
    "GEK" to "gruzínské kuponové lari",
    "GEL" to "gruzínské lari",
    "GHC" to "ghanský cedi (1979–2007)",
    "GHS" to "ghanský cedi",
    "GIP" to "gibraltarská libra",
    "GMD" to "gambijský dalasi",
    "GNF" to "guinejský frank",
    "GNS" to "guinejský syli",
    "GQE" to "rovníkovoguinejský ekwele",
    "GRD" to "řecká drachma",
    "GTQ" to "guatemalský quetzal",
    "GWE" to "portugalskoguinejské escudo",
    "GWP" to "guinejsko-bissauské peso",
    "GYD" to "guyanský dolar",
    "HKD" to "hongkongský dolar",
    "HNL" to "honduraská lempira",
    "HRD" to "chorvatský dinár",
    "HRK" to "chorvatská kuna",
    "HTG" to "haitský gourde",
    "HUF" to "maďarský forint",
    "IDR" to "indonéská rupie",
    "IEP" to "irská libra",
    "ILP" to "izraelská libra",
    "ILR" to "izraelský šekel (1980–1985)",
    "ILS" to "izraelský nový šekel",
    "INR" to "indická rupie",
    "IQD" to "irácký dinár",
    "IRR" to "íránský rijál",
    "ISJ" to "islandská koruna (1918–1981)",
    "ISK" to "islandská koruna",
    "ITL" to "italská lira",
    "JMD" to "jamajský dolar",
    "JOD" to "jordánský dinár",
    "JPY" to "japonský jen",
    "KES" to "keňský šilink",
    "KGS" to "kyrgyzský som",
    "KHR" to "kambodžský riel",
    "KMF" to "komorský frank",
    "KPW" to "severokorejský won",
    "KRH" to "jihokorejský hwan (1953–1962)",
    "KRO" to "jihokorejský won (1945–1953)",
    "KRW" to "jihokorejský won",
    "KWD" to "kuvajtský dinár",
    "KYD" to "kajmanský dolar",
    "KZT" to "kazašské tenge",
    "LAK" to "laoský kip",
    "LBP" to "libanonská libra",
    "LKR" to "srílanská rupie",
    "LRD" to "liberijský dolar",
    "LSL" to "lesothský loti",
    "LTL" to "litevský litas",
    "LTT" to "litevský talonas",
    "LUC" to "lucemburský konvertibilní frank",
    "LUF" to "lucemburský frank",
    "LUL" to "lucemburský finanční frank",
    "LVL" to "lotyšský lat",
    "LVR" to "lotyšský rubl",
    "LYD" to "libyjský dinár",
    "MAD" to "marocký dinár",
    "MAF" to "marocký frank",
    "MCF" to "monacký frank",
    "MDC" to "moldavský kupon",
    "MDL" to "moldavský leu",
    "MGA" to "madagaskarský ariary",
    "MGF" to "madagaskarský frank",
    "MKD" to "makedonský denár",
    "MKN" to "makedonský denár (1992–1993)",
    "MLF" to "malijský frank",
    "MMK" to "myanmarský kyat",
    "MNT" to "mongolský tugrik",
    "MOP" to "macajská pataca",
    "MRO" to "mauritánská ouguiya (1973–2017)",
    "MRU" to "mauritánská ouguiya",
    "MTL" to "maltská lira",
    "MTP" to "maltská libra",
    "MUR" to "mauricijská rupie",
    "MVP" to "maledivská rupie (1947–1981)",
    "MVR" to "maledivská rupie",
    "MWK" to "malawijská kwacha",
    "MXN" to "mexické peso",
    "MXP" to "mexické stříbrné peso (1861–1992)",
    "MXV" to "mexická investiční jednotka",
    "MYR" to "malajsijský ringgit",
    "MZE" to "mosambický escudo",
    "MZM" to "mosambický metical (1980–2006)",
    "MZN" to "mozambický metical",
    "NAD" to "namibijský dolar",
    "NGN" to "nigerijská naira",
    "NIC" to "nikaragujská córdoba (1988–1991)",
    "NIO" to "nikaragujská córdoba",
    "NLG" to "nizozemský gulden",
    "NOK" to "norská koruna",
    "NPR" to "nepálská rupie",
    "NZD" to "novozélandský dolar",
    "OMR" to "ománský rijál",
    "PAB" to "panamská balboa",
    "PEI" to "peruánská inti",
    "PEN" to "peruánský sol",
    "PES" to "peruánský sol (1863–1965)",
    "PGK" to "papuánská nová kina",
    "PHP" to "filipínské peso",
    "PKR" to "pákistánská rupie",
    "PLN" to "polský zlotý",
    "PLZ" to "polský zlotý (1950–1995)",
    "PTE" to "portugalské escudo",
    "PYG" to "paraguajské guarani",
    "QAR" to "katarský rijál",
    "RHD" to "rhodéský dolar",
    "ROL" to "rumunské leu (1952–2006)",
    "RON" to "rumunský leu",
    "RSD" to "srbský dinár",
    "RUB" to "ruský rubl",
    "RUR" to "ruský rubl (1991–1998)",
    "RWF" to "rwandský frank",
    "SAR" to "saúdský rijál",
    "SBD" to "šalamounský dolar",
    "SCR" to "seychelská rupie",
    "SDD" to "súdánský dinár (1992–2007)",
    "SDG" to "súdánská libra",
    "SDP" to "súdánská libra (1957–1998)",
    "SEK" to "švédská koruna",
    "SGD" to "singapurský dolar",
    "SHP" to "svatohelenská libra",
    "SIT" to "slovinský tolar",
    "SKK" to "slovenská koruna",
    "SLE" to "sierraleonský leone",
    "SLL" to "sierraleonský leone (1964—2022)",
    "SOS" to "somálský šilink",
    "SRD" to "surinamský dolar",
    "SRG" to "surinamský zlatý",
    "SSP" to "jihosúdánská libra",
    "STD" to "svatotomášská dobra (1977–2017)",
    "STN" to "svatotomášská dobra",
    "SUR" to "sovětský rubl",
    "SVC" to "salvadorský colón",
    "SYP" to "syrská libra",
    "SZL" to "svazijský lilangeni",
    "THB" to "thajský baht",
    "TJR" to "tádžický rubl",
    "TJS" to "tádžické somoni",
    "TMM" to "turkmenský manat (1993–2009)",
    "TMT" to "turkmenský manat",
    "TND" to "tuniský dinár",
    "TOP" to "tonžská paanga",
    "TPE" to "timorské escudo",
    "TRL" to "turecká lira (1922–2005)",
    "TRY" to "turecká lira",
    "TTD" to "trinidadský dolar",
    "TWD" to "tchajwanský dolar",
    "TZS" to "tanzanský šilink",
    "UAH" to "ukrajinská hřivna",
    "UAK" to "ukrajinský karbovanec",
    "UGS" to "ugandský šilink (1966–1987)",
    "UGX" to "ugandský šilink",
    "USD" to "americký dolar",
    "USN" to "americký dolar (příští den)",
    "USS" to "americký dolar (týž den)",
    "UYI" to "uruguayské peso (v indexovaných jednotkách)",
    "UYP" to "uruguayské peso (1975–1993)",
    "UYU" to "uruguayské peso",
    "UZS" to "uzbecký sum",
    "VEB" to "venezuelský bolívar (1871–2008)",
    "VEF" to "venezuelský bolívar (2008–2018)",
    "VES" to "venezuelský bolívar",
    "VND" to "vietnamský dong",
    "VNN" to "vietnamský dong (1978–1985)",
    "VUV" to "vanuatský vatu",
    "WST" to "samojská tala",
    "XAF" to "CFA/BEAC frank",
    "XAG" to "stříbro",
    "XAU" to "zlato",
    "XBA" to "evropská smíšená jednotka",
    "XBB" to "evropská peněžní jednotka",
    "XBC" to "evropská jednotka účtu 9 (XBC)",
    "XBD" to "evropská jednotka účtu 17 (XBD)",
    "XCD" to "východokaribský dolar",
    "XDR" to "SDR",
    "XEU" to "evropská měnová jednotka",
    "XFO" to "francouzský zlatý frank",
    "XFU" to "francouzský UIC frank",
    "XOF" to "CFA/BCEAO frank",
    "XPD" to "palladium",
    "XPF" to "CFP frank",
    "XPT" to "platina",
    "XRE" to "kód fondů RINET",
    "XSU" to "sucre",
    "XTS" to "kód zvlášť vyhrazený pro testovací účely",
    "XXX" to "neznámá měna",
    "YDD" to "jemenský dinár",
    "YER" to "jemenský rijál",
    "YUD" to "jugoslávský dinár (1966–1990)",
    "YUM" to "jugoslávský nový dinár (1994–2002)",
    "YUN" to "jugoslávský konvertibilní dinár (1990–1992)",
    "YUR" to "jugoslávský reformovaný dinár (1992–1993)",
    "ZAL" to "jihoafrický finanční rand",
    "ZAR" to "jihoafrický rand",
    "ZMK" to "zambijská kwacha (1968–2012)",
    "ZMW" to "zambijská kwacha",
    "ZRN" to "zairský nový zaire (1993–1998)",
    "ZRZ" to "zairský zaire (1971–1993)",
    "ZWD" to "zimbabwský dolar (1980–2008)",
    "ZWL" to "zimbabwský dolar (2009)",
    "ZWR" to "zimbabwský dolar (2008)",
  ) }

  val csw: ImmutableMap<String, String> by lazy { immutableMapOf(
    "CAD" to "ᑲᓀᑎᔭᐣ ᐯᔭᐠᐚᐱᐢᐠ",
  ) }

  val cu: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val cv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "АПЭ дирхамӗ",
    "AFN" to "афганийӗ",
    "ALL" to "Албани лекӗ",
    "AMD" to "Армяни драмӗ",
    "ANG" to "Нидерланд Антиллиан гульденӗ",
    "AOA" to "Ангола кванзӗ",
    "ARS" to "Аргентина песийӗ",
    "AUD" to "Австрали долларӗ",
    "AWG" to "Аруба флоринӗ",
    "AZN" to "Азербайджан маначӗ",
    "BAM" to "Боснипе Герцеговина конвертланакан марки",
    "BBD" to "Барбадос долларӗ",
    "BDT" to "Бангладеш таки",
    "BGN" to "Болгари левӗ",
    "BHD" to "Бахрейн динарӗ",
    "BIF" to "Бурунди франкӗ",
    "BMD" to "Бермуд долларӗ",
    "BND" to "Бруней долларӗ",
    "BOB" to "Боливи боливианӗ",
    "BRL" to "Бразили реалӗ",
    "BSD" to "Багам долларӗ",
    "BTN" to "Бутан нгултрумӗ",
    "BWP" to "Ботсвана пули",
    "BYN" to "Беларуҫ тенкӗ",
    "BZD" to "Белиз долларӗ",
    "CAD" to "Канада долларӗ",
    "CDF" to "Конголези франкӗ",
    "CHF" to "Швейцари франкӗ",
    "CLP" to "Чили песийӗ",
    "CNH" to "Китай офшор юанӗ",
    "CNY" to "Китай юанӗ",
    "COP" to "Колумби песийӗ",
    "CRC" to "Коста-Рика колонӗ",
    "CUC" to "Куба конвертланакан песийӗ",
    "CUP" to "Куба песийӗ",
    "CVE" to "Кабо-Верде эскудӗ",
    "CZK" to "Чехи кронӗ",
    "DJF" to "Джибути франкӗ",
    "DKK" to "Дани кронӗ",
    "DOP" to "Доминикан песийӗ",
    "DZD" to "Алжир динарӗ",
    "EGP" to "Египет фунчӗ",
    "ERN" to "Эритрей накфӗ",
    "ETB" to "Эфиопи бырӗ",
    "EUR" to "евро",
    "FJD" to "Фиджи долларӗ",
    "FKP" to "Факланд утравӗсен фунчӗ",
    "GBP" to "Британи фунчӗ",
    "GEL" to "Грузи ларийӗ",
    "GHS" to "Гана седийӗ",
    "GIP" to "Гибралтар фунчӗ",
    "GMD" to "Гамби даласийӗ",
    "GNF" to "Гвиней франкӗ",
    "GTQ" to "Гватемала кетсалӗ",
    "GYD" to "Гайана долларӗ",
    "HKD" to "Гонконг долларӗ",
    "HNL" to "Гондурас лемпирӗ",
    "HRK" to "Хорвати куни",
    "HTG" to "Гаити гурдӗ",
    "HUF" to "Венгри форинчӗ",
    "IDR" to "Индонези рупийӗ",
    "ILS" to "Ҫӗнӗ Израиль шекелӗ",
    "INR" to "Инди рупийӗ",
    "IQD" to "Ирак динарӗ",
    "IRR" to "Иран риалӗ",
    "ISK" to "Исланди кронӗ",
    "JMD" to "Ямайка долларӗ",
    "JOD" to "Иордан динарӗ",
    "JPY" to "Япони иени",
    "KES" to "Кени шиллингӗ",
    "KGS" to "Киргиз сомӗ",
    "KHR" to "Камбоджа риелӗ",
    "KMF" to "Комора франкӗ",
    "KPW" to "КХДР вони",
    "KRW" to "Корей вони",
    "KWD" to "Кувейт динарӗ",
    "KYD" to "Кайман утравӗсен долларӗ",
    "KZT" to "Казах тенгейӗ",
    "LAK" to "Лаос кипӗ",
    "LBP" to "Ливан фунчӗ",
    "LKR" to "Шри-ланка рупийӗ",
    "LRD" to "Либери долларӗ",
    "LSL" to "Лесото лотийӗ",
    "LYD" to "Ливи динарӗ",
    "MAD" to "Марокко дирхамӗ",
    "MDL" to "Молдова лайӗ",
    "MGA" to "Малагаси ариарийӗ",
    "MKD" to "Македони денарӗ",
    "MMK" to "Мьянман кьятӗ",
    "MNT" to "Монголи тугрикӗ",
    "MOP" to "Макао патаки",
    "MRU" to "Мавритани угийӗ",
    "MUR" to "Маврики рупийӗ",
    "MVR" to "Мальдивсен руфийӗ",
    "MWK" to "Малави квачӗ",
    "MXN" to "Мексика песийӗ",
    "MYR" to "Малайзи ринггичӗ",
    "MZN" to "Мозамбик метикалӗ",
    "NAD" to "Намиби долларӗ",
    "NGN" to "Нигери найрӗ",
    "NIO" to "Никарагуа кордобӗ",
    "NOK" to "Норвеги кронӗ",
    "NPR" to "Непал рупийӗ",
    "NZD" to "Ҫӗнӗ Зеланди долларӗ",
    "OMR" to "Оман риалӗ",
    "PAB" to "Панама бальбоа",
    "PEN" to "Перу солӗ",
    "PGK" to "Папуа – Ҫӗнӗ Гвиней кини",
    "PHP" to "Филиппин песийӗ",
    "PKR" to "пакистан рупийӗ",
    "PLN" to "Польша злотыйӗ",
    "PYG" to "Парагвай гуаранӗ",
    "QAR" to "Катар риалӗ",
    "RON" to "Румыни лейӗ",
    "RSD" to "Серби динарӗ",
    "RUB" to "Раҫҫей тенкӗ",
    "RWF" to "Руанда франкӗ",
    "SAR" to "Сауд риялӗ",
    "SBD" to "Соломон утравӗсен долларӗ",
    "SCR" to "Сейшел рупийӗ",
    "SDG" to "Судан фунчӗ",
    "SEK" to "Швеци кронӗ",
    "SGD" to "Сингапур долларӗ",
    "SHP" to "Сӑваплӑ Елена утравӗн фунчӗ",
    "SLE" to "леонӗ",
    "SLL" to "леонӗ (1964—2022)",
    "SOS" to "Сомали шиллингӗ",
    "SRD" to "Суринам долларӗ",
    "SSP" to "Кӑнтӑр Судан фунчӗ",
    "STN" to "Сан-Томе тата Принсипи добрӗ",
    "SYP" to "Сири фунчӗ",
    "SZL" to "Свази лилангенийӗ",
    "THB" to "Таиланд барӗ",
    "TJS" to "Таджик сомонийӗ",
    "TMT" to "Туркмен маначӗ",
    "TND" to "Тунези динарӗ",
    "TOP" to "Тонган паанги",
    "TRY" to "Турци лири",
    "TTD" to "Тринидад тата Тобаго долларӗ",
    "TWD" to "Ҫӗнӗ Тайван долларӗ",
    "TZS" to "Танзани шиллингӗ",
    "UAH" to "Украина гривни",
    "UGX" to "Уганда шиллингӗ",
    "USD" to "АПШ долларӗ",
    "UYU" to "Уругвай песийӗ",
    "UZS" to "Узбек сумӗ",
    "VES" to "Венесуэла боливарӗ",
    "VND" to "Вьетнам донгӗ",
    "VUV" to "Вануату ватуйӗ",
    "WST" to "Самоа тали",
    "XAF" to "Тӗп Африка КФА франкӗ",
    "XCD" to "Хӗвелтухӑҫ Карибсем долларӗ",
    "XOF" to "КФА ВСЕАО франкӗ",
    "XPF" to "Франци Лӑпкӑ океан франкӗ",
    "XXX" to "паллӑ мар валюта",
    "YER" to "Йемен риалӗ",
    "ZAR" to "Кӑнтӑр Африка рэндӗ",
    "ZMW" to "Замби квачи",
  ) }

  val cy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham Yr Emiradau Arabaidd Unedig",
    "AFA" to "Afghani Afghanistan (1927–2002)",
    "AFN" to "Afghani Afghanistan",
    "ALL" to "Lek Albania",
    "AMD" to "Dram Armenia",
    "ANG" to "Guilder Antilles yr Iseldiroedd",
    "AOA" to "Kwanza Angola",
    "AOK" to "Kwanza Angola (1977–1991)",
    "AON" to "Kwanza Newydd Angola (1990–2000)",
    "AOR" to "Kwanza Ailgymhwysedig Angola (1995–1999)",
    "ARA" to "Austral yr Ariannin",
    "ARL" to "Peso Ley yr Ariannin (1970–1983)",
    "ARM" to "Peso yr Ariannin (1881–1970)",
    "ARP" to "Peso yr Ariannin (1983–1985)",
    "ARS" to "Peso yr Ariannin",
    "ATS" to "Swllt Awstria",
    "AUD" to "Doler Awstralia",
    "AWG" to "Fflorin Aruba",
    "AZM" to "Manat Azerbaijan (1993–2006)",
    "AZN" to "Manat Azerbaijan",
    "BAM" to "Marc Trosadwy Bosnia a Hercegovina",
    "BBD" to "Doler Barbados",
    "BDT" to "Taka Bangladesh",
    "BEC" to "Ffranc Gwlad Belg (arnewidiol)",
    "BEF" to "Ffranc Gwlad Belg",
    "BEL" to "Ffranc Gwlad Belg (ariannol)",
    "BGM" to "Lev Sosialaidd Bwlgaria",
    "BGN" to "Lev Bwlgaria",
    "BGO" to "Lev Bwlgaria (1879–1952)",
    "BHD" to "Dinar Bahrain",
    "BIF" to "Ffranc Burundi",
    "BMD" to "Doler Bermuda",
    "BND" to "Doler Brunei",
    "BOB" to "Boliviano Bolifia",
    "BOL" to "Boliviano Bolifia (1863–1963)",
    "BOP" to "Peso Bolifia",
    "BOV" to "Mvdol Bolifia",
    "BRB" to "Cruzeiro Newydd Brasil (1967–1986)",
    "BRC" to "Cruzado Brasil (1986–1989)",
    "BRE" to "Cruzeiro Brasil (1990–1993)",
    "BRL" to "Real Brasil",
    "BRN" to "Cruzado Newydd Brasil (1989–1990)",
    "BRR" to "Cruzeiro Brasil (1993–1994)",
    "BRZ" to "Cruzeiro Brasil (1942–1967)",
    "BSD" to "Doler y Bahamas",
    "BTN" to "Ngultrum Bhutan",
    "BUK" to "Kyat Byrma",
    "BWP" to "Pula Botswana",
    "BYN" to "Rwbl Belarws",
    "BYR" to "Rwbl Belarws (2000–2016)",
    "BZD" to "Doler Belize",
    "CAD" to "Doler Canada",
    "CDF" to "Ffranc Congo",
    "CHE" to "Ewro WIR",
    "CHF" to "Ffranc y Swistir",
    "CHW" to "Ffranc WIR",
    "CLE" to "Escudo Chile",
    "CLF" to "Uned Cyfrifo Chile (UF)",
    "CLP" to "Peso Chile",
    "CNH" to "Yuan Tsieina (ar y môr)",
    "CNX" to "Doler Banc Pobl Tsieina",
    "CNY" to "Yuan Tsieina",
    "COP" to "Peso Colombia",
    "COU" to "Uned Gwir Werth Colombia",
    "CRC" to "Colón Costa Rica",
    "CUC" to "Peso Trosadwy Ciwba",
    "CUP" to "Peso Ciwba",
    "CVE" to "Esgwdo Cabo Verde",
    "CYP" to "Punt Cyprus",
    "CZK" to "Koruna’r Weriniaeth Tsiec",
    "DDM" to "Marc Dwyrain yr Almaen",
    "DEM" to "Marc yr Almaen",
    "DJF" to "Ffranc Djibouti",
    "DKK" to "Krone Denmarc",
    "DOP" to "Peso Gweriniaeth Dominica",
    "DZD" to "Dinar Algeria",
    "ECS" to "Sucre Ecuador",
    "ECV" to "Uned Gwerth Gyson Ecuador",
    "EEK" to "Kroon Estonia",
    "EGP" to "Punt Yr Aifft",
    "ERN" to "Nakfa Eritrea",
    "ETB" to "Birr Ethiopia",
    "EUR" to "Ewro",
    "FIM" to "Markka’r Ffindir",
    "FJD" to "Doler Ffiji",
    "FKP" to "Punt Ynysoedd Falkland/Malvinas",
    "FRF" to "Ffranc Ffrainc",
    "GBP" to "Punt Prydain",
    "GEK" to "Kupon Larit Georgia",
    "GEL" to "Lari Georgia",
    "GHC" to "Cedi Ghana (1979–2007)",
    "GHS" to "Cedi Ghana",
    "GIP" to "Punt Gibraltar",
    "GMD" to "Dalasi Gambia",
    "GNF" to "Ffranc Guinée",
    "GNS" to "Syli Guinée",
    "GQE" to "Ekwele Guinea Gyhydeddol",
    "GTQ" to "Quetzal Guatemala",
    "GWP" to "Peso Guiné-Bissau",
    "GYD" to "Doler Guyana",
    "HKD" to "Doler Hong Kong",
    "HNL" to "Lempira Honduras",
    "HRK" to "Kuna Croatia",
    "HTG" to "Gourde Haiti",
    "HUF" to "Fforint Hwngari",
    "IDR" to "Rupiah Indonesia",
    "IEP" to "Punt Iwerddon",
    "ILP" to "Punt Israel",
    "ILR" to "Shegel Israel (1980–1985)",
    "ILS" to "Shegel Newydd Israel",
    "INR" to "Rwpî India",
    "IQD" to "Dinar Irac",
    "IRR" to "Rial Iran",
    "ISJ" to "Króna Gwlad yr Iâ (1918 – 1981)",
    "ISK" to "Króna Gwlad yr Iâ",
    "JMD" to "Doler Jamaica",
    "JOD" to "Dinar Gwlad yr Iorddonen",
    "JPY" to "Yen Japan",
    "KES" to "Swllt Kenya",
    "KGS" to "Som Kyrgyzstan",
    "KHR" to "Riel Cambodia",
    "KMF" to "Ffranc Comoros",
    "KPW" to "Won Gogledd Corea",
    "KRH" to "Hwan De Corea (1953–1962)",
    "KRO" to "Won De Corea (1945–1953)",
    "KRW" to "Won De Corea",
    "KWD" to "Dinar Kuwait",
    "KYD" to "Doler Ynysoedd Cayman",
    "KZT" to "Tenge Kazakstan",
    "LAK" to "Kip Laos",
    "LBP" to "Punt Libanus",
    "LKR" to "Rwpî Sri Lanka",
    "LRD" to "Doler Liberia",
    "LSL" to "Loti Lesotho",
    "LTL" to "Litas Lithwania",
    "LTT" to "Talonas Lithwania",
    "LUF" to "Ffranc Lwcsembwrg",
    "LVL" to "Lats Latfia",
    "LVR" to "Rwbl Latfia",
    "LYD" to "Dinar Libya",
    "MAD" to "Dirham Moroco",
    "MAF" to "Ffranc Moroco",
    "MCF" to "Ffranc Monaco",
    "MDL" to "Leu Moldofa",
    "MGA" to "Ariary Madagascar",
    "MGF" to "Ffranc Madagascar",
    "MKD" to "Denar Macedonia",
    "MLF" to "Ffranc Mali",
    "MMK" to "Kyat Myanmar",
    "MNT" to "Tugrik Mongolia",
    "MOP" to "pataca Macau",
    "MRO" to "Ouguiya Mauritania (1973–2017)",
    "MRU" to "Ouguiya Mauritania",
    "MUR" to "Rwpî Mauritius",
    "MVP" to "Rwpî’r Maldives (1947–1981)",
    "MVR" to "Rufiyaa’r Maldives",
    "MWK" to "Kwacha Malawi",
    "MXN" to "Peso Mecsico",
    "MXP" to "Peso Arian México (1861–1992)",
    "MXV" to "Uned Fuddsoddi México",
    "MYR" to "Ringgit Malaysia",
    "MZE" to "Escudo Mozambique",
    "MZM" to "Metical Mozambique (1980–2006)",
    "MZN" to "Metical Mozambique",
    "NAD" to "Doler Namibia",
    "NGN" to "Naira Nigeria",
    "NIC" to "Córdoba Nicaragua (1988–1991)",
    "NIO" to "Cordoba Nicaragwa",
    "NLG" to "Guilder yr Iseldiroedd",
    "NOK" to "Krone Norwy",
    "NPR" to "Rwpî Nepal",
    "NZD" to "Doler Seland Newydd",
    "OMR" to "Rial Oman",
    "PAB" to "Balboa Panama",
    "PEI" to "Inti Periw",
    "PEN" to "Sol Periw",
    "PES" to "Sol Periw (1863–1965)",
    "PGK" to "Kina Papua Guinea Newydd",
    "PHP" to "Peso Philipinas",
    "PKR" to "Rwpî Pacistan",
    "PLN" to "Zloty Gwlad Pwyl",
    "PYG" to "Guarani Paraguay",
    "QAR" to "Rial Qatar",
    "RHD" to "Doler Rhodesia",
    "RON" to "Leu Rwmania",
    "RSD" to "Dinar Serbia",
    "RUB" to "Rwbl Rwsia",
    "RWF" to "Ffranc Rwanda",
    "SAR" to "Riyal Saudi Arabia",
    "SBD" to "Doler Ynysoedd Solomon",
    "SCR" to "Rwpî Seychelles",
    "SDD" to "Dinar Sudan (1992–2007)",
    "SDG" to "Punt Sudan",
    "SDP" to "Punt Sudan (1957–1998)",
    "SEK" to "Krona Sweden",
    "SGD" to "Doler Singapore",
    "SHP" to "Punt St Helena",
    "SLE" to "Leone Sierra Leone",
    "SLL" to "Leone Sierra Leone (1964—2022)",
    "SOS" to "Swllt Somalia",
    "SRD" to "Doler Surinam",
    "SRG" to "Guilder Surinam",
    "SSP" to "Punt De Sudan",
    "STD" to "Dobra São Tomé a Príncipe (1977–2017)",
    "STN" to "Dobra São Tomé a Príncipe",
    "SVC" to "Colón El Salvador",
    "SYP" to "Punt Syria",
    "SZL" to "Lilangeni Gwlad Swazi",
    "THB" to "Baht Gwlad Thai",
    "TJR" to "Rwbl Tajikistan",
    "TJS" to "Somoni Tajikistan",
    "TMM" to "Manat Turkmenistan (1993–2009)",
    "TMT" to "Manat Turkmenistan",
    "TND" to "Dinar Tunisia",
    "TOP" to "Paʻanga Tonga",
    "TPE" to "Escudo Timor",
    "TRL" to "Lira Twrci (1922–2005)",
    "TRY" to "Lira Twrci",
    "TTD" to "Doler Trinidad a Tobago",
    "TWD" to "Doler Newydd Taiwan",
    "TZS" to "Swllt Tanzania",
    "UAH" to "Hryvnia Wcráin",
    "UGS" to "Swllt Uganda (1966–1987)",
    "UGX" to "Swllt Uganda",
    "USD" to "Doler UDA",
    "USN" to "Doler UDA (y diwrnod nesaf)",
    "USS" to "Doler UDA (yr un diwrnod)",
    "UYP" to "Peso Uruguay (1975–1993)",
    "UYU" to "Peso Uruguay",
    "UZS" to "Som Uzbekistan",
    "VEB" to "Bolívar Venezuela (1871–2008)",
    "VEF" to "Bolívar Venezuela (2008–2018)",
    "VES" to "Bolívar Venezuela",
    "VND" to "Dong Fietnam",
    "VNN" to "Dong Fietnam (1978–1985)",
    "VUV" to "Vatu Vanuatu",
    "WST" to "Tala Samoa",
    "XAF" to "Ffranc CFA Canol Affrica",
    "XAG" to "Arian",
    "XAU" to "Aur",
    "XBA" to "Uned Cyfansawdd Ewropeaidd",
    "XBB" to "Uned Ariannol Ewropeaidd",
    "XCD" to "Doler Dwyrain y Caribî",
    "XEU" to "Uned Arian Cyfred Ewropeaidd",
    "XOF" to "Ffranc CFA Gorllewin Affrica",
    "XPD" to "Paladiwm",
    "XPF" to "Ffranc CFP",
    "XPT" to "Platinwm",
    "XSU" to "Sucre",
    "XXX" to "Arian Cyfred Anhysbys",
    "YDD" to "Dinar Yemen",
    "YER" to "Rial Yemen",
    "ZAL" to "Rand (ariannol) De Affrica",
    "ZAR" to "Rand De Affrica",
    "ZMK" to "Kwacha Zambia (1968–2012)",
    "ZMW" to "Kwacha Zambia",
    "ZRN" to "Zaire Newydd Zaire (1993–1998)",
    "ZRZ" to "Zaire Zaire (1971–1993)",
    "ZWD" to "Doler Zimbabwe (1980–2008)",
    "ZWL" to "Doler Zimbabwe (2009)",
    "ZWR" to "Doler Zimbabwe (2008)",
  ) }

  val da: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorransk peseta",
    "AED" to "dirham fra de Forenede Arabiske Emirater",
    "AFA" to "Afghansk afghani (1927–2002)",
    "AFN" to "afghansk afghani",
    "ALL" to "albansk lek",
    "AMD" to "armensk dram",
    "ANG" to "Nederlandske Antiller-gylden",
    "AOA" to "angolansk kwanza",
    "AOK" to "Angolansk kwanza (1977–1990)",
    "AON" to "Angolansk nye kwanza (1990–2000)",
    "AOR" to "Angolansk kwanza (1995–1999)",
    "ARA" to "Argentinsk austral",
    "ARP" to "Argentinsk peso (1983–1985)",
    "ARS" to "argentinsk peso",
    "ATS" to "Østrigsk schilling",
    "AUD" to "australsk dollar",
    "AWG" to "arubansk florin",
    "AZM" to "Aserbajdsjansk manat (1993–2006)",
    "AZN" to "aserbajdsjansk manat",
    "BAD" to "Bosnien-Hercegovinsk dinar",
    "BAM" to "bosnien-hercegovinsk konvertibel mark",
    "BBD" to "barbadisk dollar",
    "BDT" to "bangladeshisk taka",
    "BEC" to "Belgisk franc (konvertibel)",
    "BEF" to "Belgisk franc",
    "BEL" to "Belgisk franc (financial)",
    "BGL" to "Bulgarsk hard lev",
    "BGN" to "bulgarsk lev",
    "BHD" to "bahrainsk dinar",
    "BIF" to "burundisk franc",
    "BMD" to "bermudansk dollar",
    "BND" to "bruneisk dollar",
    "BOB" to "boliviansk boliviano",
    "BOP" to "Boliviansk peso",
    "BOV" to "Boliviansk mvdol",
    "BRB" to "Brasiliansk cruzeiro novo (1967–1986)",
    "BRC" to "Brasiliansk cruzado (1986–1989)",
    "BRE" to "Brasiliansk cruzeiro (1990–1993)",
    "BRL" to "brasiliansk real",
    "BRN" to "Brasiliansk cruzado novo (1989–1990)",
    "BRR" to "Brasiliansk cruzeiro (1993–1994)",
    "BSD" to "bahamansk dollar",
    "BTN" to "bhutansk ngultrum",
    "BUK" to "Burmesisk kyat",
    "BWP" to "botswansk pula",
    "BYB" to "Hviderussisk rubel (1994–1999)",
    "BYN" to "hviderussisk rubel",
    "BYR" to "hviderussisk rubel (2000–2016)",
    "BZD" to "belizisk dollar",
    "CAD" to "canadisk dollar",
    "CDF" to "congolesisk franc",
    "CHE" to "WIR euro",
    "CHF" to "schweizerfranc",
    "CHW" to "WIR franc",
    "CLP" to "chilensk peso",
    "CNH" to "kinesisk yuan (offshore)",
    "CNY" to "kinesisk yuan",
    "COP" to "colombiansk peso",
    "CRC" to "costaricansk colón",
    "CSD" to "Serbisk dinar (2002–2006)",
    "CSK" to "Tjekkoslovakisk hard koruna",
    "CUC" to "cubansk konvertibel peso",
    "CUP" to "cubansk peso",
    "CVE" to "kapverdisk escudo",
    "CYP" to "Cypriotisk pund",
    "CZK" to "tjekkisk koruna",
    "DDM" to "Østtysk mark",
    "DEM" to "Tysk mark",
    "DJF" to "djiboutisk franc",
    "DKK" to "dansk krone",
    "DOP" to "dominikansk peso",
    "DZD" to "algerisk dinar",
    "ECS" to "Ecuadoriansk sucre",
    "EEK" to "Estisk kroon",
    "EGP" to "egyptisk pund",
    "ERN" to "eritreisk nakfa",
    "ESA" to "Spansk peseta (A–konto)",
    "ESB" to "Spansk peseta (konvertibel konto)",
    "ESP" to "Spansk peseta",
    "ETB" to "etiopisk birr",
    "EUR" to "euro",
    "FIM" to "Finsk mark",
    "FJD" to "fijiansk dollar",
    "FKP" to "pund fra Falklandsøerne",
    "FRF" to "Fransk franc",
    "GBP" to "britisk pund",
    "GEK" to "Georgisk kupon larit",
    "GEL" to "georgisk lari",
    "GHC" to "Ghanesisk cedi (1979–2007)",
    "GHS" to "ghanesisk cedi",
    "GIP" to "gibraltarisk pund",
    "GMD" to "gambisk dalasi",
    "GNF" to "guineansk franc",
    "GNS" to "Guineansk syli",
    "GQE" to "Ækvatorialguineask ekwele",
    "GRD" to "Græsk drakme",
    "GTQ" to "guatemalansk quetzal",
    "GWE" to "Portugisisk guinea escudo",
    "GWP" to "Guineansk peso",
    "GYD" to "guyansk dollar",
    "HKD" to "hongkongsk dollar",
    "HNL" to "honduransk lempira",
    "HRD" to "Kroatisk dinar",
    "HRK" to "kroatisk kuna",
    "HTG" to "haitisk gourde",
    "HUF" to "ungarsk forint",
    "IDR" to "indonesisk rupiah",
    "IEP" to "Irsk pund",
    "ILP" to "Israelsk pund",
    "ILS" to "ny israelsk shekel",
    "INR" to "indisk rupee",
    "IQD" to "irakisk dinar",
    "IRR" to "iransk rial",
    "ISK" to "islandsk krone",
    "ITL" to "Italiensk lire",
    "JMD" to "jamaicansk dollar",
    "JOD" to "jordansk dinar",
    "JPY" to "japansk yen",
    "KES" to "kenyansk shilling",
    "KGS" to "kirgisisk som",
    "KHR" to "cambodjansk riel",
    "KMF" to "comorisk franc",
    "KPW" to "nordkoreansk won",
    "KRW" to "sydkoreansk won",
    "KWD" to "kuwaitisk dinar",
    "KYD" to "caymansk dollar",
    "KZT" to "kasakhisk tenge",
    "LAK" to "laotisk kip",
    "LBP" to "libanesisk pund",
    "LKR" to "srilankansk rupee",
    "LRD" to "liberisk dollar",
    "LSL" to "lesothisk loti",
    "LTL" to "Litauisk litas",
    "LTT" to "Litauisk talonas",
    "LUC" to "Luxembourgsk konvertibel franc",
    "LUF" to "Luxembourgsk franc",
    "LUL" to "Luxembourgsk finansiel franc",
    "LVL" to "Lettisk lat",
    "LVR" to "Lettisk rubel",
    "LYD" to "libysk dinar",
    "MAD" to "marokkansk dirham",
    "MAF" to "Marokkansk franc",
    "MDL" to "moldovisk leu",
    "MGA" to "madagaskisk ariary",
    "MGF" to "Madagaskisk franc",
    "MKD" to "makedonsk denar",
    "MLF" to "Malisk franc",
    "MMK" to "myanmarsk kyat",
    "MNT" to "mongolsk tugrik",
    "MOP" to "macaosk pataca",
    "MRO" to "mauritansk ouguiya (1973–2017)",
    "MRU" to "mauritansk ouguiya",
    "MTL" to "Maltesisk lira",
    "MTP" to "Maltesisk pund",
    "MUR" to "mauritisk rupee",
    "MVR" to "maldivisk rufiyaa",
    "MWK" to "malawisk kwacha",
    "MXN" to "mexicansk peso",
    "MXP" to "Mexicansk silver peso (1861–1992)",
    "MYR" to "malaysisk ringgit",
    "MZE" to "Mozambiquisk escudo",
    "MZM" to "Mozambiquisk metical (1980–2006)",
    "MZN" to "mozambiquisk metical",
    "NAD" to "namibisk dollar",
    "NGN" to "nigeriansk naira",
    "NIC" to "Nicaraguansk cordoba (1988–1991)",
    "NIO" to "nicaraguansk cordoba",
    "NLG" to "Hollandsk guilder",
    "NOK" to "norsk krone",
    "NPR" to "nepalesisk rupee",
    "NZD" to "newzealandsk dollar",
    "OMR" to "omansk rial",
    "PAB" to "panamansk balboa",
    "PEI" to "peruviansk inti",
    "PEN" to "peruansk sol",
    "PES" to "peruviansk sol (1863–1965)",
    "PGK" to "papuansk kina",
    "PHP" to "filippinsk peso",
    "PKR" to "pakistansk rupee",
    "PLN" to "polsk zloty",
    "PLZ" to "Polsk zloty (1950–1995)",
    "PTE" to "Portugisisk escudo",
    "PYG" to "paraguaysk guarani",
    "QAR" to "qatarsk rial",
    "ROL" to "Rumænsk leu (1952–2006)",
    "RON" to "rumænsk leu",
    "RSD" to "serbisk dinar",
    "RUB" to "russisk rubel",
    "RUR" to "Russisk rubel (1991–1998)",
    "RWF" to "rwandisk franc",
    "SAR" to "saudiarabisk riyal",
    "SBD" to "salomonsk dollar",
    "SCR" to "seychellisk rupee",
    "SDD" to "Sudansk dinar (1992–2007)",
    "SDG" to "sudansk pund",
    "SDP" to "Sudansk pund (1957–1998)",
    "SEK" to "svensk krone",
    "SGD" to "singaporeansk dollar",
    "SHP" to "pund fra Saint Helena",
    "SIT" to "Slovensk tolar",
    "SKK" to "Slovakisk koruna",
    "SLE" to "sierraleonsk leone",
    "SLL" to "sierraleonsk leone (1964—2022)",
    "SOS" to "somalisk shilling",
    "SRD" to "surinamsk dollar",
    "SRG" to "Surinamsk guilder",
    "SSP" to "sydsudansk pund",
    "STD" to "dobra fra Sao Tome og Principe (1977–2017)",
    "STN" to "dobra fra Sao Tome og Principe",
    "SUR" to "Sovjetisk rubel",
    "SVC" to "Salvadoransk colon",
    "SYP" to "syrisk pund",
    "SZL" to "swazilandsk lilangeni",
    "THB" to "thailandsk baht",
    "TJR" to "Tadsjikisk rubel",
    "TJS" to "tadsjikisk somoni",
    "TMM" to "Turkmensk manat (1993–2009)",
    "TMT" to "turkmensk manat",
    "TND" to "tunesisk dinar",
    "TOP" to "tongansk paʻanga",
    "TPE" to "Escudo fra Timor",
    "TRL" to "Tyrkisk lire (1922–2005)",
    "TRY" to "tyrkisk lira",
    "TTD" to "trinidadisk dollar",
    "TWD" to "ny taiwansk dollar",
    "TZS" to "tanzanisk shilling",
    "UAH" to "ukrainsk grynia",
    "UAK" to "Ukrainsk karbovanetz",
    "UGS" to "Ugandisk shilling (1966–1987)",
    "UGX" to "ugandisk shilling",
    "USD" to "amerikansk dollar",
    "USN" to "Amerikansk dollar (næste dag)",
    "USS" to "Amerikansk dollar (samme dag)",
    "UYP" to "Uruguayansk peso (1975–1993)",
    "UYU" to "uruguayansk peso",
    "UZS" to "usbekisk sum",
    "VEB" to "Venezuelansk bolivar (1871–2008)",
    "VEF" to "venezuelansk bolivar (2008–2018)",
    "VES" to "venezuelansk bolivar",
    "VND" to "vietnamesisk dong",
    "VUV" to "vanuaisk vatu",
    "WST" to "samoansk tala",
    "XAF" to "CFA-franc (BEAC)",
    "XAG" to "Sølv",
    "XAU" to "Guld",
    "XBA" to "EURCO",
    "XBB" to "EMU",
    "XCD" to "østkaribisk dollar",
    "XDR" to "SDR",
    "XEU" to "ECU",
    "XFO" to "Fransk guldfranc",
    "XFU" to "Fransk UIC-franc",
    "XOF" to "CFA-franc BCEAO",
    "XPD" to "Palladium",
    "XPF" to "CFP-franc",
    "XPT" to "Platin",
    "XRE" to "RINET-fond",
    "XTS" to "testvalutakode",
    "XXX" to "ukendt valuta",
    "YDD" to "Yemenitisk dinar",
    "YER" to "yemenitisk rial",
    "YUD" to "Jugoslavisk hard dinar (1966–1990)",
    "YUM" to "Jugoslavisk noviy dinar (1994–2002)",
    "YUN" to "Jugoslavisk konvertibel dinar (1990–1992)",
    "ZAL" to "Sydafrikansk rand (financial)",
    "ZAR" to "sydafrikansk rand",
    "ZMK" to "Zambisk kwacha (1968–2012)",
    "ZMW" to "zambisk kwacha",
    "ZRN" to "Ny zairisk zaire (1993–1998)",
    "ZRZ" to "Zairisk zaire (1971–1993)",
    "ZWD" to "Zimbabwisk dollar (1980–2008)",
    "ZWL" to "Zimbabwisk dollar (2009)",
    "ZWR" to "Zimbabwisk dollar (2008)",
  ) }

  val da_GL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val dav: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham ya Falme za Kiarabu",
    "AOA" to "Kwanza ya Angola",
    "AUD" to "Dola ya Australia",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pula ya Botswana",
    "CAD" to "Dola ya Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Uswisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Jibuti",
    "DZD" to "Dinari ya Aljeria",
    "EGP" to "Pauni ya Misri",
    "ERN" to "Nakfa ya Eritrea",
    "ETB" to "Bir ya Uhabeshi",
    "EUR" to "Yuro",
    "GBP" to "Pauni ya Uingereza",
    "GHC" to "Sedi ya Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Gine",
    "INR" to "Rupia ya India",
    "JPY" to "Sarafu ya Kijapani",
    "KES" to "Shilingi ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Dola ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirham ya Moroko",
    "MGA" to "Ariary ya Bukini",
    "MRO" to "Ugwiya ya Moritania (1973–2017)",
    "MRU" to "Ugwiya ya Moritania",
    "MUR" to "Rupia ya Morisi",
    "MWK" to "Kwacha ya Malawi",
    "MZM" to "Metikali ya Msumbiji",
    "NAD" to "Dola ya Namibia",
    "NGN" to "Naira ya Nijeria",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riyal ya Saudia",
    "SCR" to "Rupia ya Shelisheli",
    "SDG" to "Pauni ya Sudani",
    "SHP" to "Pauni ya Santahelena",
    "SLE" to "Leoni",
    "SLL" to "Leoni (1964—2022)",
    "SOS" to "Shilingi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Principe (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Principe",
    "SZL" to "Lilangeni",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "Shilingi ya Tanzania",
    "UGX" to "Shilingi ya Uganda",
    "USD" to "Dola ya Marekani",
    "XAF" to "Faranga CFA BEAC",
    "XOF" to "Faranga CFA BCEAO",
    "ZAR" to "Randi ya Afrika Kusini",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Dola ya Zimbabwe",
  ) }

  val de: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorranische Pesete",
    "AED" to "VAE-Dirham",
    "AFA" to "Afghanische Afghani (1927–2002)",
    "AFN" to "Afghanischer Afghani",
    "ALK" to "Albanischer Lek (1946–1965)",
    "ALL" to "Albanischer Lek",
    "AMD" to "Armenischer Dram",
    "ANG" to "Niederländische-Antillen-Gulden",
    "AOA" to "Angolanischer Kwanza",
    "AOK" to "Angolanischer Kwanza (1977–1990)",
    "AON" to "Angolanischer Neuer Kwanza (1990–2000)",
    "AOR" to "Angolanischer Kwanza Reajustado (1995–1999)",
    "ARA" to "Argentinischer Austral",
    "ARL" to "Argentinischer Peso Ley (1970–1983)",
    "ARM" to "Argentinischer Peso (1881–1970)",
    "ARP" to "Argentinischer Peso (1983–1985)",
    "ARS" to "Argentinischer Peso",
    "ATS" to "Österreichischer Schilling",
    "AUD" to "Australischer Dollar",
    "AWG" to "Aruba-Florin",
    "AZM" to "Aserbaidschan-Manat (1993–2006)",
    "AZN" to "Aserbaidschan-Manat",
    "BAD" to "Bosnien und Herzegowina Dinar (1992–1994)",
    "BAM" to "Konvertible Mark Bosnien und Herzegowina",
    "BAN" to "Bosnien und Herzegowina Neuer Dinar (1994–1997)",
    "BBD" to "Barbados-Dollar",
    "BDT" to "Bangladesch-Taka",
    "BEC" to "Belgischer Franc (konvertibel)",
    "BEF" to "Belgischer Franc",
    "BEL" to "Belgischer Finanz-Franc",
    "BGL" to "Bulgarische Lew (1962–1999)",
    "BGM" to "Bulgarischer Lew (1952–1962)",
    "BGN" to "Bulgarischer Lew",
    "BGO" to "Bulgarischer Lew (1879–1952)",
    "BHD" to "Bahrain-Dinar",
    "BIF" to "Burundi-Franc",
    "BMD" to "Bermuda-Dollar",
    "BND" to "Brunei-Dollar",
    "BOB" to "Bolivianischer Boliviano",
    "BOL" to "Bolivianischer Boliviano (1863–1963)",
    "BOP" to "Bolivianischer Peso",
    "BOV" to "Boliviansiche Mvdol",
    "BRB" to "Brasilianischer Cruzeiro Novo (1967–1986)",
    "BRC" to "Brasilianischer Cruzado (1986–1989)",
    "BRE" to "Brasilianischer Cruzeiro (1990–1993)",
    "BRL" to "Brasilianischer Real",
    "BRN" to "Brasilianischer Cruzado Novo (1989–1990)",
    "BRR" to "Brasilianischer Cruzeiro (1993–1994)",
    "BRZ" to "Brasilianischer Cruzeiro (1942–1967)",
    "BSD" to "Bahamas-Dollar",
    "BTN" to "Bhutan-Ngultrum",
    "BUK" to "Birmanischer Kyat",
    "BWP" to "Botswanischer Pula",
    "BYB" to "Belarus-Rubel (1994–1999)",
    "BYN" to "Weißrussischer Rubel",
    "BYR" to "Weißrussischer Rubel (2000–2016)",
    "BZD" to "Belize-Dollar",
    "CAD" to "Kanadischer Dollar",
    "CDF" to "Kongo-Franc",
    "CHE" to "WIR-Euro",
    "CHF" to "Schweizer Franken",
    "CHW" to "WIR Franken",
    "CLE" to "Chilenischer Escudo",
    "CLF" to "Chilenische Unidades de Fomento",
    "CLP" to "Chilenischer Peso",
    "CNH" to "Renminbi-Yuan (Offshore)",
    "CNX" to "Dollar der Chinesischen Volksbank",
    "CNY" to "Renminbi Yuan",
    "COP" to "Kolumbianischer Peso",
    "COU" to "Kolumbianische Unidades de valor real",
    "CRC" to "Costa-Rica-Colón",
    "CSD" to "Serbischer Dinar (2002–2006)",
    "CSK" to "Tschechoslowakische Krone",
    "CUC" to "Kubanischer Peso (konvertibel)",
    "CUP" to "Kubanischer Peso",
    "CVE" to "Cabo-Verde-Escudo",
    "CYP" to "Zypern-Pfund",
    "CZK" to "Tschechische Krone",
    "DDM" to "Mark der DDR",
    "DEM" to "Deutsche Mark",
    "DJF" to "Dschibuti-Franc",
    "DKK" to "Dänische Krone",
    "DOP" to "Dominikanischer Peso",
    "DZD" to "Algerischer Dinar",
    "ECS" to "Ecuadorianischer Sucre",
    "ECV" to "Verrechnungseinheit für Ecuador",
    "EEK" to "Estnische Krone",
    "EGP" to "Ägyptisches Pfund",
    "ERN" to "Eritreischer Nakfa",
    "ESA" to "Spanische Peseta (A–Konten)",
    "ESB" to "Spanische Peseta (konvertibel)",
    "ESP" to "Spanische Peseta",
    "ETB" to "Äthiopischer Birr",
    "EUR" to "Euro",
    "FIM" to "Finnische Mark",
    "FJD" to "Fidschi-Dollar",
    "FKP" to "Falkland-Pfund",
    "FRF" to "Französischer Franc",
    "GBP" to "Britisches Pfund",
    "GEK" to "Georgischer Kupon Larit",
    "GEL" to "Georgischer Lari",
    "GHC" to "Ghanaischer Cedi (1979–2007)",
    "GHS" to "Ghanaischer Cedi",
    "GIP" to "Gibraltar-Pfund",
    "GMD" to "Gambia-Dalasi",
    "GNF" to "Guinea-Franc",
    "GNS" to "Guineischer Syli",
    "GQE" to "Äquatorialguinea-Ekwele",
    "GRD" to "Griechische Drachme",
    "GTQ" to "Guatemaltekischer Quetzal",
    "GWE" to "Portugiesisch Guinea Escudo",
    "GWP" to "Guinea-Bissau Peso",
    "GYD" to "Guyana-Dollar",
    "HKD" to "Hongkong-Dollar",
    "HNL" to "Honduras-Lempira",
    "HRD" to "Kroatischer Dinar",
    "HRK" to "Kroatischer Kuna",
    "HTG" to "Haitianische Gourde",
    "HUF" to "Ungarischer Forint",
    "IDR" to "Indonesische Rupiah",
    "IEP" to "Irisches Pfund",
    "ILP" to "Israelisches Pfund",
    "ILR" to "Israelischer Schekel (1980–1985)",
    "ILS" to "Israelischer Neuer Schekel",
    "INR" to "Indische Rupie",
    "IQD" to "Irakischer Dinar",
    "IRR" to "Iranischer Rial",
    "ISJ" to "Isländische Krone (1918–1981)",
    "ISK" to "Isländische Krone",
    "ITL" to "Italienische Lira",
    "JMD" to "Jamaika-Dollar",
    "JOD" to "Jordanischer Dinar",
    "JPY" to "Japanischer Yen",
    "KES" to "Kenia-Schilling",
    "KGS" to "Kirgisischer Som",
    "KHR" to "Kambodschanischer Riel",
    "KMF" to "Komoren-Franc",
    "KPW" to "Nordkoreanischer Won",
    "KRH" to "Südkoreanischer Hwan (1953–1962)",
    "KRO" to "Südkoreanischer Won (1945–1953)",
    "KRW" to "Südkoreanischer Won",
    "KWD" to "Kuwait-Dinar",
    "KYD" to "Kaiman-Dollar",
    "KZT" to "Kasachischer Tenge",
    "LAK" to "Laotischer Kip",
    "LBP" to "Libanesisches Pfund",
    "LKR" to "Sri-Lanka-Rupie",
    "LRD" to "Liberianischer Dollar",
    "LSL" to "Loti",
    "LTL" to "Litauischer Litas",
    "LTT" to "Litauischer Talonas",
    "LUC" to "Luxemburgischer Franc (konvertibel)",
    "LUF" to "Luxemburgischer Franc",
    "LUL" to "Luxemburgischer Finanz-Franc",
    "LVL" to "Lettischer Lats",
    "LVR" to "Lettischer Rubel",
    "LYD" to "Libyscher Dinar",
    "MAD" to "Marokkanischer Dirham",
    "MAF" to "Marokkanischer Franc",
    "MCF" to "Monegassischer Franc",
    "MDC" to "Moldau-Cupon",
    "MDL" to "Moldau-Leu",
    "MGA" to "Madagaskar-Ariary",
    "MGF" to "Madagaskar-Franc",
    "MKD" to "Mazedonischer Denar",
    "MKN" to "Mazedonischer Denar (1992–1993)",
    "MLF" to "Malischer Franc",
    "MMK" to "Myanmarischer Kyat",
    "MNT" to "Mongolischer Tögrög",
    "MOP" to "Macao-Pataca",
    "MRO" to "Mauretanischer Ouguiya (1973–2017)",
    "MRU" to "Mauretanischer Ouguiya",
    "MTL" to "Maltesische Lira",
    "MTP" to "Maltesisches Pfund",
    "MUR" to "Mauritius-Rupie",
    "MVP" to "Malediven-Rupie (alt)",
    "MVR" to "Malediven-Rufiyaa",
    "MWK" to "Malawi-Kwacha",
    "MXN" to "Mexikanischer Peso",
    "MXP" to "Mexikanischer Silber-Peso (1861–1992)",
    "MXV" to "Mexicanischer Unidad de Inversion (UDI)",
    "MYR" to "Malaysischer Ringgit",
    "MZE" to "Mosambikanischer Escudo",
    "MZM" to "Mosambikanischer Metical (1980–2006)",
    "MZN" to "Mosambikanischer Metical",
    "NAD" to "Namibia-Dollar",
    "NGN" to "Nigerianischer Naira",
    "NIC" to "Nicaraguanischer Córdoba (1988–1991)",
    "NIO" to "Nicaragua-Córdoba",
    "NLG" to "Niederländischer Gulden",
    "NOK" to "Norwegische Krone",
    "NPR" to "Nepalesische Rupie",
    "NZD" to "Neuseeland-Dollar",
    "OMR" to "Omanischer Rial",
    "PAB" to "Panamaischer Balboa",
    "PEI" to "Peruanischer Inti",
    "PEN" to "Peruanischer Sol",
    "PES" to "Peruanischer Sol (1863–1965)",
    "PGK" to "Papua-neuguineischer Kina",
    "PHP" to "Philippinischer Peso",
    "PKR" to "Pakistanische Rupie",
    "PLN" to "Polnischer Złoty",
    "PLZ" to "Polnischer Zloty (1950–1995)",
    "PTE" to "Portugiesischer Escudo",
    "PYG" to "Paraguayischer Guaraní",
    "QAR" to "Katar-Riyal",
    "RHD" to "Rhodesischer Dollar",
    "ROL" to "Rumänischer Leu (1952–2006)",
    "RON" to "Rumänischer Leu",
    "RSD" to "Serbischer Dinar",
    "RUB" to "Russischer Rubel",
    "RUR" to "Russischer Rubel (1991–1998)",
    "RWF" to "Ruanda-Franc",
    "SAR" to "Saudi-Rial",
    "SBD" to "Salomonen-Dollar",
    "SCR" to "Seychellen-Rupie",
    "SDD" to "Sudanesischer Dinar (1992–2007)",
    "SDG" to "Sudanesisches Pfund",
    "SDP" to "Sudanesisches Pfund (1957–1998)",
    "SEK" to "Schwedische Krone",
    "SGD" to "Singapur-Dollar",
    "SHP" to "St.-Helena-Pfund",
    "SIT" to "Slowenischer Tolar",
    "SKK" to "Slowakische Krone",
    "SLE" to "Sierra-leonischer Leone",
    "SLL" to "Sierra-leonischer Leone (1964–2022)",
    "SOS" to "Somalia-Schilling",
    "SRD" to "Suriname-Dollar",
    "SRG" to "Suriname Gulden",
    "SSP" to "Südsudanesisches Pfund",
    "STD" to "São-toméischer Dobra (1977–2017)",
    "STN" to "São-toméischer Dobra",
    "SUR" to "Sowjetischer Rubel",
    "SVC" to "El Salvador Colon",
    "SYP" to "Syrisches Pfund",
    "SZL" to "Swasiländischer Lilangeni",
    "THB" to "Thailändischer Baht",
    "TJR" to "Tadschikistan Rubel",
    "TJS" to "Tadschikistan-Somoni",
    "TMM" to "Turkmenistan-Manat (1993–2009)",
    "TMT" to "Turkmenistan-Manat",
    "TND" to "Tunesischer Dinar",
    "TOP" to "Tongaischer Paʻanga",
    "TPE" to "Timor-Escudo",
    "TRL" to "Türkische Lira (1922–2005)",
    "TRY" to "Türkische Lira",
    "TTD" to "Trinidad-und-Tobago-Dollar",
    "TWD" to "Neuer Taiwan-Dollar",
    "TZS" to "Tansania-Schilling",
    "UAH" to "Ukrainische Hrywnja",
    "UAK" to "Ukrainischer Karbovanetz",
    "UGS" to "Uganda-Schilling (1966–1987)",
    "UGX" to "Uganda-Schilling",
    "USD" to "US-Dollar",
    "USN" to "US Dollar (Nächster Tag)",
    "USS" to "US Dollar (Gleicher Tag)",
    "UYI" to "Uruguayischer Peso (Indexierte Rechnungseinheiten)",
    "UYP" to "Uruguayischer Peso (1975–1993)",
    "UYU" to "Uruguayischer Peso",
    "UZS" to "Usbekistan-Sum",
    "VEB" to "Venezolanischer Bolívar (1871–2008)",
    "VEF" to "Venezolanischer Bolívar (2008–2018)",
    "VES" to "Venezolanischer Bolívar",
    "VND" to "Vietnamesischer Dong",
    "VNN" to "Vietnamesischer Dong(1978–1985)",
    "VUV" to "Vanuatu-Vatu",
    "WST" to "Samoanischer Tala",
    "XAF" to "CFA-Franc (BEAC)",
    "XAG" to "Unze Silber",
    "XAU" to "Unze Gold",
    "XBA" to "Europäische Rechnungseinheit",
    "XBB" to "Europäische Währungseinheit (XBB)",
    "XBC" to "Europäische Rechnungseinheit (XBC)",
    "XBD" to "Europäische Rechnungseinheit (XBD)",
    "XCD" to "Ostkaribischer Dollar",
    "XDR" to "Sonderziehungsrechte",
    "XEU" to "Europäische Währungseinheit (XEU)",
    "XFO" to "Französischer Gold-Franc",
    "XFU" to "Französischer UIC-Franc",
    "XOF" to "CFA-Franc (BCEAO)",
    "XPD" to "Unze Palladium",
    "XPF" to "CFP-Franc",
    "XPT" to "Unze Platin",
    "XRE" to "RINET Funds",
    "XSU" to "SUCRE",
    "XTS" to "Testwährung",
    "XUA" to "Rechnungseinheit der AfEB",
    "XXX" to "Unbekannte Währung",
    "YDD" to "Jemen-Dinar",
    "YER" to "Jemen-Rial",
    "YUD" to "Jugoslawischer Dinar (1966–1990)",
    "YUM" to "Jugoslawischer Neuer Dinar (1994–2002)",
    "YUN" to "Jugoslawischer Dinar (konvertibel)",
    "YUR" to "Jugoslawischer reformierter Dinar (1992–1993)",
    "ZAL" to "Südafrikanischer Rand (Finanz)",
    "ZAR" to "Südafrikanischer Rand",
    "ZMK" to "Kwacha (1968–2012)",
    "ZMW" to "Kwacha",
    "ZRN" to "Zaire-Neuer Zaïre (1993–1998)",
    "ZRZ" to "Zaire-Zaïre (1971–1993)",
    "ZWD" to "Simbabwe-Dollar (1980–2008)",
    "ZWL" to "Simbabwe-Dollar (2009)",
    "ZWR" to "Simbabwe-Dollar (2008)",
  ) }

  val de_AT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val de_BE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val de_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BYN" to "Weissrussischer Rubel",
    "BYR" to "Weissrussischer Rubel (2000–2016)",
    "STN" to "São-toméischer Dobra (2018)",
  ) }

  val de_IT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val de_LI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val de_LU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val dje: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Laaraw Immaara Margantey Dirham",
    "AOA" to "Angoola Kwanza",
    "AUD" to "Ostraali Dollar",
    "BHD" to "Bahareen Dinar",
    "BIF" to "Burundi Fraŋ",
    "BWP" to "Botswaana Pund",
    "CAD" to "Kanaada Dollar",
    "CDF" to "Kongo Fraŋ",
    "CHF" to "Swisu Fraŋ",
    "CNY" to "Sinwa Yuan Renminbi",
    "CVE" to "Kapuver Escudo",
    "DJF" to "Jibuuti Fraŋ",
    "DZD" to "Alžeeri Dinar",
    "EGP" to "Misra Pund",
    "ERN" to "Eritree Nafka",
    "ETB" to "Ecioopi Birr",
    "EUR" to "Eero",
    "GBP" to "Britin Pund",
    "GHC" to "Gaana Šiidi",
    "GMD" to "Gambi Dalasi",
    "GNS" to "Ginee Fraŋ",
    "INR" to "Indu Rupii",
    "JPY" to "Jaapoŋ Yen",
    "KES" to "Keeniya Šiiliŋ",
    "KMF" to "Komoor Fraŋ",
    "LRD" to "Liberia Dollar",
    "LSL" to "Leezoto Loti",
    "LYD" to "Liibi Dinar",
    "MAD" to "Maarok Dirham",
    "MGA" to "Malgaaši Fraŋ",
    "MRO" to "Mooritaani Ugiya (1973–2017)",
    "MRU" to "Mooritaani Ugiya",
    "MUR" to "Mooris Rupii",
    "MWK" to "Malaawi Kwaca",
    "MZM" to "Mozambik Metikal",
    "NAD" to "Naamibi Dollar",
    "NGN" to "Naajiriya Neera",
    "RWF" to "Rwanda Fraŋ",
    "SAR" to "Saudiya Riyal",
    "SCR" to "Seešel Rupii",
    "SDG" to "Suudaŋ Dinar",
    "SDP" to "Suudaŋ Pund",
    "SHP" to "Seŋ Helena Fraŋ",
    "SLE" to "Leeon",
    "SLL" to "Leeon (1964—2022)",
    "SOS" to "Somaali Šiiliŋ",
    "STD" to "Sao Tome nda Prinsipe Dobra (1977–2017)",
    "STN" to "Sao Tome nda Prinsipe Dobra",
    "SZL" to "Lilangeni",
    "TND" to "Tunizi Dinar",
    "TZS" to "Tanzaani Šiiliŋ",
    "UGX" to "Uganda Šiiliŋ",
    "USD" to "Ameriki Dollar",
    "XAF" to "CFA Fraŋ (BEAC)",
    "XOF" to "CFA Fraŋ (BCEAO)",
    "ZAR" to "Hawasa Afriki Rand",
    "ZMK" to "Zambi Kwaca (1968–2012)",
    "ZMW" to "Zambi Kwaca",
    "ZWD" to "Zimbabwe Dollar",
  ) }

  val doi: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "ब्राजीली रियाल",
    "CNY" to "चीनी युआन",
    "EUR" to "यूरो",
    "GBP" to "ब्रिटिश पाउंड",
    "INR" to "भारती रपेऽ",
    "JPY" to "जापानी येन",
    "RUB" to "रूसी रूबल",
    "USD" to "यूएस डालर",
    "XXX" to "अनजांती करंसी",
  ) }

  val dsb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "andorraska peseta",
    "AED" to "ZAE dirham",
    "AFN" to "afghaniski afgani",
    "ALL" to "albański lek",
    "AMD" to "armeński dram",
    "ANG" to "nižozemsko-antilski gulden",
    "AOA" to "angolska kwanza",
    "AOK" to "angolska kwanza (1977–1990)",
    "AON" to "angolska nowa kwanza (1990–2000)",
    "AOR" to "angolska kwanza reajustado (1995–1999)",
    "ARA" to "argentinski austral",
    "ARP" to "argentinski peso (1983–1985)",
    "ARS" to "argentinski peso",
    "ATS" to "rakuski šiling",
    "AUD" to "awstralski dolar",
    "AWG" to "aruba-florin",
    "AZM" to "azerbajdžaniski manat (1993–2006)",
    "AZN" to "azerbajdžaniski manat",
    "BAD" to "bosniski dinar",
    "BAM" to "bosniska konwertibelna marka",
    "BBD" to "barbadoski dolar",
    "BDT" to "bangladešska taka",
    "BEC" to "belgiski frank (konwertibelny)",
    "BEF" to "belgiski frank",
    "BEL" to "belgiski financny frank",
    "BGL" to "bulgarski lew (1962–1999)",
    "BGN" to "bulgarski lew",
    "BHD" to "bahrainski dinar",
    "BIF" to "burundiski frank",
    "BMD" to "bermudaski dolar",
    "BND" to "bruneiski dolar",
    "BOB" to "boliwiski boliviano",
    "BOP" to "boliwiski peso",
    "BOV" to "boliwiski mvdol",
    "BRB" to "brazilski nowy cruzeiro (1967–1986)",
    "BRC" to "brazilski cruzado (1986–1989)",
    "BRE" to "brazilski cruzeiro (1990–1993)",
    "BRL" to "brazilski real",
    "BRN" to "brazilski nowy cruzado (1989–1990)",
    "BRR" to "brazilski cruzeiro (1993–1994)",
    "BSD" to "bahamaski dolar",
    "BTN" to "bhutański ngultrum",
    "BUK" to "burmaski kyat",
    "BWP" to "botswaniska pula",
    "BYB" to "běłoruski rubl (1994–1999)",
    "BYN" to "běłoruski rubl",
    "BYR" to "běłoruski rubl (2000–2016)",
    "BZD" to "belizeski dolar",
    "CAD" to "kanadiski dolar",
    "CDF" to "kongoski frank",
    "CHF" to "šwicarski frank",
    "CLP" to "chilski peso",
    "CNH" to "chinski yuan (offshore)",
    "CNY" to "chinski yuan",
    "COP" to "kolumbiski peso",
    "CRC" to "kosta-rikański colón",
    "CUC" to "kubański konwertibelny peso",
    "CUP" to "kubański peso",
    "CVE" to "kapverdski escudo",
    "CZK" to "česka krona",
    "DJF" to "dźibutiski frank",
    "DKK" to "dańska krona",
    "DOP" to "dominikański peso",
    "DZD" to "algeriski dinar",
    "EGP" to "egyptojski punt",
    "ERN" to "eritrejska nakfa",
    "ETB" to "etiopiski birr",
    "EUR" to "euro",
    "FJD" to "fidźiski dolar",
    "FKP" to "falklandski punt",
    "GBP" to "britiski punt",
    "GEL" to "georgiski lari",
    "GHS" to "ghanaski cedi",
    "GIP" to "gibraltiski punt",
    "GMD" to "gambiski dalasi",
    "GNF" to "guineski frank",
    "GTQ" to "guatemalski quetzal",
    "GWP" to "Guinea-Bissau peso",
    "GYD" to "guyański dolar",
    "HKD" to "hongkongski dolar",
    "HNL" to "honduraska lempira",
    "HRK" to "chorwatska kuna",
    "HTG" to "haitiska gourda",
    "HUF" to "madźarski forint",
    "IDR" to "indoneska rupija",
    "ILS" to "israelski nowy šekel",
    "INR" to "indiska rupija",
    "IQD" to "irakski dinar",
    "IRR" to "irański rial",
    "ISK" to "islandska krona",
    "JMD" to "jamaiski dolar",
    "JOD" to "jordaniski dinar",
    "JPY" to "japański yen",
    "KES" to "keniaski šiling",
    "KGS" to "kirgiski som",
    "KHR" to "kambodžaski riel",
    "KMF" to "komorski frank",
    "KPW" to "pódpołnocnokorejski won",
    "KRW" to "pódpołdnjowokorejski won",
    "KWD" to "kuwaitski dinar",
    "KYD" to "kajmaniski dolar",
    "KZT" to "kazachski tenge",
    "LAK" to "laoski kip",
    "LBP" to "libanoński punt",
    "LKR" to "sri-lankaska rupija",
    "LRD" to "liberiski dolar",
    "LSL" to "lesothiski loti",
    "LTL" to "litawski litas",
    "LVL" to "letiski lat",
    "LYD" to "libyski dinar",
    "MAD" to "marokkoski dirham",
    "MDL" to "moldawiski leu",
    "MGA" to "madagaskarski ariary",
    "MKD" to "makedoński denar",
    "MMK" to "myanmarski kyat",
    "MNT" to "mongolski tugrik",
    "MOP" to "macaoska pataca",
    "MRO" to "mauretański ouguiya (1973–2017)",
    "MRU" to "mauretański ouguiya",
    "MUR" to "mauriciska rupija",
    "MVR" to "malediwiska rupija",
    "MWK" to "malawiski kwacha",
    "MXN" to "mexiski peso",
    "MYR" to "malajziski ringgit",
    "MZE" to "Mozabicke escudo",
    "MZM" to "mosambikski metical (1980–2006)",
    "MZN" to "mosambikski metical",
    "NAD" to "namibiski dolar",
    "NGN" to "nigeriska naira",
    "NIO" to "nikaraguaska cordoba",
    "NOK" to "norwegska krona",
    "NPR" to "nepalska rupija",
    "NZD" to "nowoseelandski dolar",
    "OMR" to "omański rial",
    "PAB" to "panamaski balboa",
    "PEN" to "peruski sol",
    "PGK" to "papua-neuguinejska kina",
    "PHP" to "filipinski peso",
    "PKR" to "pakistańska rupija",
    "PLN" to "pólski złoty",
    "PYG" to "paraguayski guarani",
    "QAR" to "katarski rial",
    "RON" to "rumuński leu",
    "RSD" to "serbiski dinar",
    "RUB" to "ruski rubl",
    "RWF" to "ruandiski frank",
    "SAR" to "saudi-arabiski rial",
    "SBD" to "salomoński dolar",
    "SCR" to "seychelska rupija",
    "SDG" to "sudański punt",
    "SEK" to "šwedska krona",
    "SGD" to "singapurski dolar",
    "SHP" to "St. Helena punt",
    "SLE" to "sierra-leoneski leone",
    "SLL" to "sierra-leoneski leone (1964—2022)",
    "SOS" to "somaliski šiling",
    "SRD" to "surinamski dolar",
    "SSP" to "pódpołdnjowosudański punt",
    "STD" to "são-tomeska dobra (1977–2017)",
    "STN" to "são-tomeska dobra",
    "SVC" to "el-salvadorski colón",
    "SYP" to "syriski punt",
    "SZL" to "swasiski lilangeni",
    "THB" to "thaiski baht",
    "TJS" to "tadźikiski somoni",
    "TMT" to "turkmeniski manat",
    "TND" to "tuneziski dinar",
    "TOP" to "tongaski paʻanga",
    "TRY" to "turkojska lira",
    "TTD" to "trinidad-tobagoski dolar",
    "TWD" to "nowy taiwański dolar",
    "TZS" to "tansaniski šiling",
    "UAH" to "ukrainska griwna",
    "UGX" to "ugandaski šiling",
    "USD" to "ameriski dolar",
    "UYU" to "uruguayski peso",
    "UZS" to "usbekiski sum",
    "VEF" to "venezuelski bolívar (2008–2018)",
    "VES" to "venezuelski bolívar",
    "VND" to "vietnamski dong",
    "VUV" to "vanuatski vatu",
    "WST" to "samoaska tala",
    "XAF" to "CFA-frank (BEAC)",
    "XCD" to "pódzajtšnokaribiski dolar",
    "XOF" to "CFA-frank (BCEAO)",
    "XPF" to "CFP-frank",
    "XXX" to "njeznate pjenjeze",
    "YER" to "jemeński rial",
    "ZAR" to "pódpołdnjowoafriski rand",
    "ZMW" to "sambiska kwacha",
  ) }

  val dua: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val dv: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val dyo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AOA" to "kwanza yati Angola",
    "AUD" to "dolaar yati Ostraalia",
    "BHD" to "dinaar yati Bahrayn",
    "BIF" to "fraaŋ yati Burundi",
    "BWP" to "pula yati Boswana",
    "CAD" to "dolaar yati Kanada",
    "CDF" to "fraaŋ yati Kongo",
    "CNY" to "yuan yati Siin",
    "CVE" to "eskuudo yati Kap Ver",
    "DJF" to "fraaŋ yati Jibuti",
    "DZD" to "dinaar yati Alseri",
    "EGP" to "liiverey yati Esípt",
    "ERN" to "nafka yati Eritree",
    "ETB" to "birr yati Ecoopi",
    "EUR" to "euro",
    "GHC" to "cedi yati Gaana",
    "GMD" to "dalasi yati Gambi",
    "GNS" to "sili yati Giné",
    "INR" to "rupii yati End",
    "JPY" to "yen yati Sapoŋ",
    "KES" to "silliŋ yati Keniya",
    "KMF" to "fraaŋ yati Komor",
    "LRD" to "dolaar yati Liberia",
    "LYD" to "dinaar yati Libia",
    "MGA" to "ariari yati Madagaskaar",
    "MRO" to "ugiiya yati Mooritanii (1973–2017)",
    "MRU" to "ugiiya yati Mooritanii",
    "MWK" to "kwacha yati Malawi",
    "XAF" to "seefa BEAC",
    "XOF" to "seefa yati BCEAO",
  ) }

  val dz: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "ཡུ་ནཱའི་ཊེཌ་ ཨ་རབ་ ཨེ་མེ་རེཊས་ཀྱི་དངུལ་ ཌིར་ཧཱམ",
    "AFN" to "ཨཕ་གཱན་གྱི་དངུལ་ ཨཕ་ག་ནི",
    "AUD" to "ཨཱོས་ཊྲེ་ལི་ཡ་གི་དངུལ་ ཌོ་ལར",
    "BDT" to "བྷང་ལ་དེཤ་གི་དངུལ་ ཏ་ཀ",
    "BMD" to "བར་མུ་ཌ་གི་དངུལ་ ཌོ་ལར",
    "BRL" to "བྲ་ཛིལ་གྱི་དངུལ་ རེ་ཡལ",
    "BTN" to "དངུལ་ཀྲམ",
    "CAD" to "ཀེ་ན་ཌ་གི་དངུལ་ ཌོ་ལར",
    "CHF" to "སུ་ཡིས་ཀྱི་དངུལ་ ཕྲངཀ",
    "CLP" to "ཅི་ལི་གི་དངུལ་ པེ་སོ",
    "CNY" to "རྒྱ་ནག་གི་དངུལ་ ཡུ་ཝཱན",
    "COP" to "ཀོ་ལོམ་བྷི་ཡ་གི་དངུལ་ པེ་སོ",
    "CUP" to "ཀིའུ་བྷ་གི་དངུལ་ པེ་སོ",
    "DKK" to "ཌེན་མཱཀ་གི་དངུལ་ ཀྲོན",
    "DZD" to "ཨཱལ་ཇི་རི་ཡ་གི་དངུལ་ ཌའི་ནར",
    "EGP" to "ཨི་ཇིབཊ་གི་དངུལ་ པ་འུནཌ",
    "EUR" to "ཡུ་རོ༌དངུལ་",
    "GBP" to "བྲི་ཊིཤ་ པ་འུནཌ་ ཨིས་ཊར་ལིང",
    "HKD" to "ཧོང་ཀོང་གི་དངུལ་ ཌོ་ལར",
    "IDR" to "ཨིན་ཌོ་ནེ་ཤི་ཡ་གི་དངུལ་ རུ་པི་ཡ",
    "ILS" to "ཨིས་རེལ་གྱི་དངུལ་གསརཔ་ ཤེ་ཀེལ",
    "INR" to "རྒྱ་གར་གྱི་དངུལ་ རུ་པི",
    "IQD" to "ཨི་རཱཀ་གི་དངུལ་ ཌི་ན",
    "IRR" to "ཨི་རཱན་གྱི་དངུལ་ རི་ཨཱལ",
    "ISK" to "ཨཱཡིས་ལེནཌ་གི་དངུལ་ ཀྲོ་ན",
    "JMD" to "ཇཱ་མཻ་ཀ་གི་དངུལ་ ཌོ་ལར",
    "JOD" to "ཇོར་ཌན་གྱི་དངུལ་ ཌི་ན",
    "JPY" to "ཇཱ་པཱན་གྱི་དངུལ་ ཡེན",
    "KES" to "ཀེན་ཡ་གི་དངུལ་ ཤི་ལིང",
    "KHR" to "ཀེམ་བྷོ་ཌི་ཡ་གི་དངུལ་ རི་ཨཱལ",
    "KPW" to "ནོརཐ་ ཀོ་རི་ཡ་གི་དངུལ་ ཝོན",
    "KRW" to "སཱའུཐ་ ཀོ་རི་ཡ་གི་དངུལ་ ཝོན",
    "KWD" to "ཀུ་ཝེཊ་གི་དངུལ་ ཌི་ན",
    "KZT" to "ཀ་ཛགས་ཏཱན་གྱི་དངུལ་ ཏེང་གེ",
    "LAK" to "ལཱ་ཝོས་ཀྱི་དངུལ་ ཀིཔ",
    "LBP" to "ལེ་བ་ནོན་གྱི་དངུལ་ པ་འུནཌ",
    "LKR" to "ཤྲི་ ལང་ཀ་གི་དངུལ་ རུ་པི",
    "LRD" to "ལཱའི་བེ་རི་ཡ་གི་དངུལ་ ཌོ་ལར",
    "LYD" to "ལི་བི་ཡ་གི་དངུལ་ ཌི་ན",
    "MAD" to "མོ་རོ་ཀོ་གི་དངུལ་ ཌིར་ཧཱམ",
    "MMK" to "མི་ཡཱན་མར་གྱི་དངུལ་ ཅཱཏ",
    "MNT" to "སོག་པོའི་དངུལ་ ཏུ་གྲིཀ",
    "MVR" to "མཱལ་དིབས་ཀྱི་དངུལ་ རུ་ཕི་ཡ",
    "MXN" to "མེཀ་སི་ཀོ་གི་དངུལ་ པེ་སོ",
    "MYR" to "མ་ལེ་ཤི་ཡ་གི་དངུལ་ རིང་གིཊ",
    "NOK" to "ནོར་ཝེ་གི་དངུལ་ ཀྲོ་ན",
    "NPR" to "བལ་པོའི་དངུལ་ རུ་པི",
    "NZD" to "ནིའུ་ཛི་ལེནཌ་གི་དངུལ་ ཌོ་ལར",
    "OMR" to "ཨོ་མཱན་གྱི་དངུལ་ རི་ཨཱལ",
    "PAB" to "པ་ན་མ་གི་དངུལ་ བཱལ་བོ་ཝ",
    "PEN" to "པ་རུ་གི་དངུལ་ ནུ་བོ་ སཱོལ",
    "PHP" to "ཕི་ལི་པིནས་གྱི་དངུལ་ པེ་སོ",
    "PKR" to "པ་ཀིས་ཏཱན་གྱི་དངུལ་ རུ་པི",
    "PLN" to "པོ་ལེནཌ་ཀྱི་དངུལ ཛ྄ལོ་ཊི",
    "QAR" to "ཀ་ཊར་གྱི་དངུལ་ རི་ཨཱལ",
    "RUB" to "ཨུ་རུ་སུ་གི་དངུལ་ རུ་བཱལ",
    "SAR" to "སཱཝ་དིའི་དངུལ་ རི་ཡཱལ",
    "SCR" to "སེ་ཤཱལས་ཀྱི་དངུལ་ རུ་པི",
    "SEK" to "སུའི་ཌེན་གྱི་དངུལ་ ཀྲོ་ན",
    "SGD" to "སིང་ག་པོར་གྱི་དངུལ་ ཌོ་ལར",
    "SYP" to "སི་རི་ཡ་གི་དངུལ་ པ་འུནཌ",
    "THB" to "ཐཱའི་ལེནཌ་གི་དངུལ་ བཱཏ",
    "TJS" to "ཏ་ཇི་ཀིས་ཏཱན་གྱི་དངུལ་ སོ་མོ་ནི",
    "TRY" to "ཊཱར་ཀི་གི་དངུལ་ ལི་ར",
    "TWD" to "ཊཱའི་ཝཱན་གི་དངུལ ཌོ་ལར",
    "TZS" to "ཊཱན་ཛཱ་ནི་ཡ་གི་དངུལ་ ཤི་ལིང",
    "UGX" to "ཡུ་གྷེན་ཌ་གི་དངུལ་ ཤི་ལིང",
    "USD" to "ཡུ་ཨེས་ ཌོ་ལར",
    "UYU" to "ཡུ་རུ་གུ་ཝའི་གི་དངུལ་ པེ་སོ",
    "UZS" to "ཨུས་བེ་ཀིས་ཏཱན་གྱི་དངུལ་ སོམ",
    "VEF" to "བེ་ནི་ཛུ་ཝེ་ལ་གི་དངུལ་ བོ་ལི་བར (2008–2018)",
    "VES" to "བེ་ནི་ཛུ་ཝེ་ལ་གི་དངུལ་ བོ་ལི་བར",
    "VND" to "བེཊ་ནཱམ་གྱི་དངུལ་ ཌོང",
    "XXX" to "མ་ཤེས་པའི་དངུལ",
    "ZAR" to "སཱའུཐ་ ཨཕ་རི་ཀ་གི་དངུལ་ རཱནད",
  ) }

  val ebu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham ya Falme za Kiarabu",
    "AOA" to "Kwanza ya Angola",
    "AUD" to "Dora ya Australia",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pula ya Botswana",
    "CAD" to "Dola ya Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Uswisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Jibuti",
    "DZD" to "Dinari ya Aljeria",
    "EGP" to "Pauni ya Misri",
    "ERN" to "Nakfa ya Eritrea",
    "ETB" to "Bir ya Uhabeshi",
    "EUR" to "Yuro",
    "GBP" to "Pauni ya Uingereza",
    "GHC" to "Sedi ya Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Gine",
    "INR" to "Rupia ya India",
    "JPY" to "Sarafu ya Kijapani",
    "KES" to "Shilingi ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Dola ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirham ya Moroko",
    "MGA" to "Ariary ya Bukini",
    "MRO" to "Ugwiya ya Moritania (1973–2017)",
    "MRU" to "Ugwiya ya Moritania",
    "MUR" to "Rupia ya Morisi",
    "MWK" to "Kwacha ya Malawi",
    "MZM" to "Metikali ya Msumbiji",
    "NAD" to "Dola ya Namibia",
    "NGN" to "Naira ya Nijeria",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riyal ya Saudia",
    "SCR" to "Rupia ya Shelisheli",
    "SDG" to "Pauni ya Sudani",
    "SHP" to "Pauni ya Santahelena",
    "SLE" to "Leoni",
    "SLL" to "Leoni (1964—2022)",
    "SOS" to "Shilingi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Principe (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Principe",
    "SZL" to "Lilangeni",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "Shilingi ya Tanzania",
    "UGX" to "Shilingi ya Uganda",
    "USD" to "Dola ya Marekani",
    "XAF" to "Faranga CFA BEAC",
    "XOF" to "Faranga CFA BCEAO",
    "ZAR" to "Randi ya Afrika Kusini",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Dola ya Zimbabwe",
  ) }

  val ee: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "andorraga peseta",
    "AED" to "united arab emiratesga dirham",
    "AFA" to "afghanistanga afghani (1927–2002)",
    "AFN" to "afghanistanga afghani",
    "ALK" to "albaniaga lek (1946–1965)",
    "ALL" to "albaniaga lek",
    "AMD" to "armeniaga dram",
    "ANG" to "netherlands antilleaga guilder",
    "AOA" to "angolaga kwanza",
    "AOK" to "angolaga kwanza (1977–1991)",
    "AON" to "angolaga kwanza (1990–2000)",
    "AOR" to "angolaga kwanza xoxotɔ (1995–1999)",
    "ARA" to "argentinaga austral",
    "ARL" to "argentinaga peso ley (1970–1983)",
    "ARM" to "argentinaga peso (1881–1970)",
    "ARP" to "argentinaga peso (1983–1985)",
    "ARS" to "argentinaga peso",
    "ATS" to "ɔstriaga schilling",
    "AUD" to "Australiaga dollar",
    "AWG" to "arubaga lorin",
    "AZM" to "azerbaidzanga manat (1993–2006)",
    "AZN" to "azerbaidzanga manat",
    "BAD" to "bosnia-herzegovinaga dinar (1992–1994)",
    "BAM" to "bosnia-herzegovinaga convertible mark",
    "BAN" to "bosnia kple herzegovinaga dinar yeyètɔ (1994–1997)",
    "BBD" to "barbadosga dollar",
    "BDT" to "bangladeshga taka",
    "BEC" to "beldziumga franc (convertible)",
    "BEF" to "beldziumga franc",
    "BEL" to "beldziumga franc (financial)",
    "BGL" to "bɔlgariaga hard lev",
    "BGM" to "bɔlgariaga socialist lev",
    "BGN" to "bulgariaga lev",
    "BGO" to "bulgariaga lev (1879–1952)",
    "BHD" to "bahrainga dinar",
    "BIF" to "burundiga franc",
    "BMD" to "bermudaga dollar",
    "BND" to "bruneiga dollar",
    "BOB" to "boliviaga boliviano",
    "BOL" to "boliviaga boliviano (1863–1963)",
    "BOP" to "boliviaga peso",
    "BOV" to "boliviaga mvdol",
    "BRB" to "braziliaga cruzeiro xoxotɔ (1967–1986)",
    "BRC" to "brazilia cruzado (1986–1989)",
    "BRE" to "braziliaga cruzeiro xoxotɔ gbãtɔ (1990–1993)",
    "BRL" to "braziliaga real",
    "BRN" to "brazilia cruzado xoxotɔ (1989–1990)",
    "BRR" to "braziliaga cruzeiro (1993–1994)",
    "BRZ" to "braziliaga cruzeiro (1942–1967)",
    "BSD" to "bahamasga dollar",
    "BTN" to "bhutanga ngultrum",
    "BUK" to "burmaga kyat",
    "BWP" to "botswanaga pula",
    "BYB" to "belarusiaga ruble yeytɔ (1994–1999)",
    "BYN" to "belarusiaga ruble",
    "BYR" to "belarusiaga ruble (2000–2016)",
    "BZD" to "belizega dollar",
    "CAD" to "canadaga dollar",
    "CDF" to "kongoga franc",
    "CHE" to "WIR euro CHE",
    "CHF" to "switzerlandga franc",
    "CHW" to "WIR euro CHW",
    "CLE" to "tsilega escudo",
    "CLF" to "tsilegakɔnta dzidzenu UF",
    "CLP" to "chilega peso",
    "CNX" to "tsainatɔwo ƒe gadzraɖoƒe dollar",
    "CNY" to "Chinesega yuan",
    "COP" to "colombiaga peso",
    "COU" to "kolombiaga vavãtɔ",
    "CRC" to "costa ricaga colón",
    "CSD" to "serbiaga dinar (2002–2006)",
    "CSK" to "tsɛkoslovakiaga hard koruna",
    "CUC" to "cubaga convertible peso",
    "CUP" to "cubaga peso",
    "CVE" to "kape verdega escudo",
    "CYP" to "saipriɔtga pound",
    "CZK" to "czechga koruna",
    "DDM" to "ɣedzeƒe germaniaga mark",
    "DEM" to "germaniaga mark",
    "DJF" to "dziboutiga franc",
    "DKK" to "denmarkga krone",
    "DOP" to "dominicaga peso",
    "DZD" to "aldzeriaga dinar",
    "ECS" to "ekuadɔga sucre",
    "ECV" to "ekuadɔ dzidzenu matrɔmatrɔ",
    "EEK" to "estoniaga kroon",
    "EGP" to "egyptega pound",
    "ERN" to "eritreaga nakfa",
    "ESA" to "spaniaga peseta (A)",
    "ESB" to "spaniaga peseta (Convertible)",
    "ESP" to "spaniaga peseta",
    "ETB" to "ethiopiaga birr",
    "EUR" to "euro",
    "FIM" to "finlandga markka",
    "FJD" to "fidziga dollar",
    "FKP" to "falkland islands pound",
    "FRF" to "frentsiga franc",
    "GBP" to "britainga pound",
    "GEK" to "dzɔdziaga kupon larit",
    "GEL" to "dzɔdziaga lari",
    "GHC" to "ghana siɖi (1979–2007)",
    "GHS" to "ghana siɖi",
    "GIP" to "gilbratarga pound",
    "GMD" to "gambiaga dalasi",
    "GNF" to "giniga franc",
    "GNS" to "giniga syli",
    "GQE" to "ekuatorial giniga ekwele",
    "GRD" to "grisiga drachma",
    "GTQ" to "guatemalaga quetzal",
    "GWE" to "pɔtugaltɔwo ƒe giniga escudo",
    "GWP" to "gini-bisau peso",
    "GYD" to "guyanaga dollar",
    "HKD" to "Hong Kongga dollar",
    "HNL" to "honduraga lempira",
    "HRD" to "kroatiaga dinar",
    "HRK" to "croatiaga kuna",
    "HTG" to "haitiga gourde",
    "HUF" to "hungariaga forint",
    "IDR" to "Indonesiaga rupiah",
    "IEP" to "ireland pound",
    "ILP" to "israelga pound",
    "ILR" to "israelga sheqel (1980–1985)",
    "ILS" to "israelga yeyetɔ sheqel",
    "INR" to "Indiaga rupee",
    "IQD" to "irakga dinar",
    "IRR" to "iranga rial",
    "ISJ" to "aiselandga króna (1918–1981)",
    "ISK" to "icelandga króna",
    "ITL" to "italiaga lira",
    "JMD" to "jamaicaga dollar",
    "JOD" to "yɔdanga dinar",
    "JPY" to "Japanesega yen",
    "KES" to "kenyaga shilling",
    "KGS" to "kirgistanga som",
    "KHR" to "kambodiaga riel",
    "KMF" to "komoroga franc",
    "KPW" to "dziehe koreaga won",
    "KRH" to "anyiehe koreaga hwan (1953–1962)",
    "KRO" to "anyiehe koreaga won (1945–1953)",
    "KRW" to "South Koreaga won",
    "KWD" to "kuwaitga dinar",
    "KYD" to "cayman islandsga dollar",
    "KZT" to "kazakhstanga tenge",
    "LAK" to "laosga kip",
    "LBP" to "lebanonga pound",
    "LKR" to "sri lankaga rupee",
    "LRD" to "liberiaga dollar",
    "LSL" to "lesotoga loti",
    "LTL" to "lithuaniaga litas",
    "LTT" to "lithuaniaga talonas",
    "LUC" to "lazembɔgga convertible franc",
    "LUF" to "lazembɔgga franc",
    "LUL" to "lazembɔgga gadzikpɔ franc",
    "LVL" to "latviaga lats",
    "LVR" to "latviaga ruble",
    "LYD" to "libyaga dinar",
    "MAD" to "morokoga dirham",
    "MAF" to "morokoga franc",
    "MCF" to "monegaskga franc",
    "MDC" to "moldovaga cupon",
    "MDL" to "moldovaga leu",
    "MGA" to "malagasega ariary",
    "MGF" to "malagasega franc",
    "MKD" to "marcedoniaga denar",
    "MKN" to "makedoniaga denar (1992–1993)",
    "MLF" to "maliga franc",
    "MMK" to "myanmaga kyat",
    "MNT" to "mongoliaga tugrik",
    "MOP" to "makanesega pataca",
    "MRO" to "mɔritaniaga ouguiya (1973–2017)",
    "MRU" to "mɔritaniaga ouguiya",
    "MTL" to "maltaga lira",
    "MTP" to "maltaga pound",
    "MUR" to "mɔritiusga rupee",
    "MVR" to "maldiviaga rufiyaa",
    "MXN" to "mexicoga peso",
    "MYR" to "malaysiaga ringit",
    "NGN" to "naidzeriaga naira",
    "NIC" to "nikaraguaga córdoba (1988–1991)",
    "NIO" to "nicaraguaga córdoba",
    "NLG" to "hollandga guilder",
    "NOK" to "norwayga krone",
    "NPR" to "nepalga rupee",
    "NZD" to "new zealanɖga dollar",
    "OMR" to "omanga rial",
    "PAB" to "panamaga balboa",
    "PEI" to "peruga inti",
    "PEN" to "peruga sol",
    "PES" to "peruga sol (1863–1965)",
    "PGK" to "papua new guineaga kina",
    "PHP" to "filipiniga peso",
    "PKR" to "pakistaniga rupee",
    "PLN" to "polandga zloty",
    "PLZ" to "polanɖga zloty (1950–1995)",
    "PTE" to "pɔtugalga escudo",
    "PYG" to "paraguayga guarani",
    "QAR" to "katarga rial",
    "RHD" to "rhodesiaga dollar",
    "ROL" to "romaniaga leu (1952–2006)",
    "RON" to "romaniaga leu",
    "RSD" to "serbiaga dinar",
    "RUB" to "russiaga ruble",
    "RUR" to "rɔtsiaga ruble (1991–1998)",
    "RWF" to "rwandaga franc",
    "SAR" to "Saudi Arabiaga riyal",
    "SBD" to "solomon ƒudomekpo dukɔwo ƒe ga dollar",
    "SCR" to "sɛtselsga rupee",
    "SDD" to "sudanga dinar (1992–2007)",
    "SDG" to "sudanga pound",
    "SDP" to "sudanga pound (1957–1998)",
    "SEK" to "swedenga krone",
    "SGD" to "singapɔga dollar",
    "SHP" to "saint helenaga pound",
    "SIT" to "slovaniaga tolar",
    "SKK" to "slovakga koruna",
    "SLE" to "sierra leonega leone",
    "SLL" to "sierra leonega leone (1964—2022)",
    "SOS" to "somaliaga shilling",
    "SRD" to "surinamga dollar",
    "SRG" to "surinamega guilder",
    "STD" to "são tomé kple príncipega dobra (1977–2017)",
    "STN" to "são tomé kple príncipega dobra",
    "SUR" to "sovietga rouble",
    "SVC" to "salvadɔga colón",
    "SYP" to "syriaga pound",
    "SZL" to "swaziga lilangeni",
    "THB" to "Thailandga baht",
    "TJR" to "tajikistanga ruble",
    "TJS" to "tajikistanga somoni",
    "TMM" to "turkmenistanga manat (1993–2009)",
    "TMT" to "turkmenistanga manat",
    "TND" to "tunisiaga dinar",
    "TOP" to "tonagaga pa’anga",
    "TPE" to "timɔga escudo",
    "TRL" to "tɛkiiga lira (1922–2005)",
    "TRY" to "Turkishga lira",
    "TTD" to "trinidad & tobagoga dollar",
    "TWD" to "Taiwanga dollar",
    "TZS" to "Tanzaniatɔwofɛgadudu",
    "UAH" to "ukrainega hryvnia",
    "UAK" to "ukrainega karbovanet",
    "UGS" to "ugandaga shilling (1966–1987)",
    "UGX" to "ugandaga shilling",
    "USD" to "us ga dollar",
    "USN" to "us ga dollar (ŋkeke si gbɔna tɔ)",
    "USS" to "us ga dollar (ŋkeke ma ke tɔ)",
    "UYI" to "uruguayga peso UYI",
    "UYP" to "uruguayga peso (1975–1993)",
    "UYU" to "uruguayga peso",
    "UZS" to "uzbekistanga som",
    "VEB" to "venezuelaga bolívar (1871–2008)",
    "VEF" to "venezuelaga bolívar (2008–2018)",
    "VES" to "venezuelaga bolívar",
    "VND" to "vietnamga dong",
    "VNN" to "vietnamga dong (1978–1985)",
    "VUV" to "vanuatuga vatu",
    "WST" to "samaoga tala",
    "XAF" to "ɣetoɖofe afrikaga CFA franc BEAC",
    "XAG" to "klosalo",
    "XAU" to "sika",
    "XBA" to "europa dzidzenu xba",
    "XBB" to "europa gadzidzenu xbb",
    "XBC" to "europa kɔnta dzidzenu xbc",
    "XBD" to "europa kɔnta dzidzenu xbd",
    "XCD" to "east caribbeanga dollar",
    "XDR" to "gaɖuɖu ɖoɖo tɔxɛ",
    "XEU" to "europa gaɖuɖu",
    "XFO" to "fransemega sika franc",
    "XFU" to "frentsi UIC-franc",
    "XOF" to "ɣetoɖofe afrikaga CFA franc BCEAO",
    "XPD" to "palladiumga",
    "XPF" to "CFP ga franc",
    "XPT" to "platinum",
    "XRE" to "RINET gadodo XRE",
    "XTS" to "gaɖuɖu dodokpɔ dzesi xts",
    "XXX" to "gaɖuɖu manya",
    "YDD" to "yemeniga dinar",
    "YER" to "yemeniga rial",
    "YUD" to "yugoslaviaga hard dinar (1966–1990)",
    "YUM" to "yugoslaviaga yeyetɔ dinar (1994–2002)",
    "YUN" to "yugoslaviaga convertible dinar (1990–1992)",
    "YUR" to "yugoslaviaga dinar (1992–1993)",
    "ZAL" to "anyiehe afrikaga rand (gadzikpɔtɔ)",
    "ZAR" to "South Africaga rand",
    "ZMK" to "zambiaga kwacha (1968–2012)",
    "ZMW" to "zambiaga kwacha",
    "ZRN" to "zairega yeyetɔ zaire",
    "ZRZ" to "zairega zaire (1971–1993)",
    "ZWD" to "zimbabwega dollar (1980–2008)",
    "ZWL" to "zimbabwega dollar (2009)",
    "ZWR" to "zimbabwega dollar (2008)",
  ) }

  val ee_TG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val el: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Πεσέτα Ανδόρας",
    "AED" to "Ντιράμ Ηνωμένων Αραβικών Εμιράτων",
    "AFA" to "Αφγανί Αφγανιστάν (1927–2002)",
    "AFN" to "Αφγάνι Αφγανιστάν",
    "ALL" to "Λεκ Αλβανίας",
    "AMD" to "Ντραμ Αρμενίας",
    "ANG" to "Γκίλντα Ολλανδικών Αντιλλών",
    "AOA" to "Κουάνζα Ανγκόλας",
    "AOK" to "Κουάνζα Ανγκόλας (1977–1990)",
    "AON" to "Νέα Κουάνζα Ανγκόλας (1990–2000)",
    "ARA" to "Ωστράλ Αργετινής",
    "ARP" to "Πέσο Αργεντινής (1983–1985)",
    "ARS" to "Πέσο Αργεντινής",
    "ATS" to "Σελίνι Αυστρίας",
    "AUD" to "Δολάριο Αυστραλίας",
    "AWG" to "Φλορίνι Αρούμπας",
    "AZM" to "Μανάτ Αζερμπαϊτζάν (1993–2006)",
    "AZN" to "Μανάτ Αζερμπαϊτζάν",
    "BAD" to "Δηνάριο Βοσνίας-Ερζεγοβίνης",
    "BAM" to "Μετατρέψιμο Μάρκο Βοσνίας-Ερζεγοβίνης",
    "BBD" to "Δολάριο Μπαρμπέιντος",
    "BDT" to "Τάκα Μπαγκλαντές",
    "BEC" to "Φράγκο Βελγίου (μετατρέψιμο)",
    "BEF" to "Φράγκο Βελγίου",
    "BEL" to "Φράγκο Βελγίου (οικονομικό)",
    "BGL" to "Μεταλλικό Λεβ Βουλγαρίας",
    "BGN" to "Λεβ Βουλγαρίας",
    "BHD" to "Δηνάριο Μπαχρέιν",
    "BIF" to "Φράγκο Μπουρούντι",
    "BMD" to "Δολάριο Βερμούδων",
    "BND" to "Δολάριο Μπρουνέι",
    "BOB" to "Μπολιβιάνο Βολιβίας",
    "BOP" to "Πέσο Βολιβίας",
    "BOV" to "Μβδολ Βολιβίας",
    "BRB" to "Νέο Κρουζιέρο Βραζιλίας (1967–1986)",
    "BRC" to "Κρουζάντο Βραζιλίας",
    "BRE" to "Κρουζιέρο Βραζιλίας (1990–1993)",
    "BRL" to "Ρεάλ Βραζιλίας",
    "BRN" to "Νέο Κρουζάντο Βραζιλίας",
    "BRR" to "Κρουζιέρο Βραζιλίας",
    "BSD" to "Δολάριο Μπαχαμών",
    "BTN" to "Νγκούλτρουμ Μπουτάν",
    "BUK" to "Κιατ Βιρμανίας",
    "BWP" to "Πούλα Μποτσουάνας",
    "BYB" to "Νέο Ρούβλι Λευκορωσίας (1994–1999)",
    "BYN" to "Ρούβλι Λευκορωσίας",
    "BYR" to "Ρούβλι Λευκορωσίας (2000–2016)",
    "BZD" to "Δολάριο Μπελίζ",
    "CAD" to "Δολάριο Καναδά",
    "CDF" to "Φράγκο Κονγκό",
    "CHE" to "Ευρώ WIR",
    "CHF" to "Φράγκο Ελβετίας",
    "CHW" to "Φράγκο WIR",
    "CLF" to "Ουνιδάδες ντε φομέντο Χιλής",
    "CLP" to "Πέσο Χιλής",
    "CNH" to "Γουάν Κίνας (υπεράκτιο)",
    "CNY" to "Γουάν Κίνας",
    "COP" to "Πέσο Κολομβίας",
    "CRC" to "Κολόν Κόστα Ρίκα",
    "CSD" to "Παλαιό Δηνάριο Σερβίας",
    "CSK" to "Σκληρή Κορόνα Τσεχοσλοβακίας",
    "CUC" to "Μετατρέψιμο πέσο Κούβας",
    "CUP" to "Πέσο Κούβας",
    "CVE" to "Εσκούδο Πράσινου Ακρωτηρίου",
    "CYP" to "Λίρα Κύπρου",
    "CZK" to "Κορόνα Τσεχίας",
    "DDM" to "Οστμάρκ Ανατολικής Γερμανίας",
    "DEM" to "Μάρκο Γερμανίας",
    "DJF" to "Φράγκο Τζιμπουτί",
    "DKK" to "Κορόνα Δανίας",
    "DOP" to "Πέσο Δομινικανής Δημοκρατίας",
    "DZD" to "Δηνάριο Αλγερίας",
    "ECS" to "Σούκρε Εκουαδόρ",
    "EEK" to "Κορόνα Εσθονίας",
    "EGP" to "Λίρα Αιγύπτου",
    "ERN" to "Νάκφα Ερυθραίας",
    "ESA" to "πεσέτα Ισπανίας (λογαριασμός Α)",
    "ESB" to "πεσέτα Ισπανίας (μετατρέψιμος λογαριασμός)",
    "ESP" to "Πεσέτα Ισπανίας",
    "ETB" to "Μπιρ Αιθιοπίας",
    "EUR" to "Ευρώ",
    "FIM" to "Μάρκο Φινλανδίας",
    "FJD" to "Δολάριο Φίτζι",
    "FKP" to "Λίρα Νήσων Φόκλαντ",
    "FRF" to "Φράγκο Γαλλίας",
    "GBP" to "Λίρα Στερλίνα Βρετανίας",
    "GEK" to "Κούπον Λάρι Γεωργίας",
    "GEL" to "Λάρι Γεωργίας",
    "GHC" to "Σέντι Γκάνας (1979–2007)",
    "GHS" to "Σέντι Γκάνας",
    "GIP" to "Λίρα Γιβραλτάρ",
    "GMD" to "Νταλάσι Γκάμπιας",
    "GNF" to "Φράγκο Γουινέας",
    "GNS" to "Συλί Γουινέας",
    "GQE" to "Εκγουέλε Ισημερινής Γουινέας",
    "GRD" to "Δραχμή Ελλάδας",
    "GTQ" to "Κουετσάλ Γουατεμάλας",
    "GWE" to "Γκινέα Εσκούδο Πορτογαλίας",
    "GWP" to "Πέσο Γουινέας-Μπισάου",
    "GYD" to "Δολάριο Γουιάνας",
    "HKD" to "Δολάριο Χονγκ Κονγκ",
    "HNL" to "Λεμπίρα Ονδούρας",
    "HRD" to "Δηνάριο Κροατίας",
    "HRK" to "Κούνα Κροατίας",
    "HTG" to "Γκουρντ Αϊτής",
    "HUF" to "Φιορίνι Ουγγαρίας",
    "IDR" to "Ρουπία Ινδονησίας",
    "IEP" to "Λίρα Ιρλανδίας",
    "ILP" to "Λίρα Ισραήλ",
    "ILR" to "παλιό σεκέλ Ισραήλ",
    "ILS" to "Νέο Σέκελ Ισραήλ",
    "INR" to "Ρουπία Ινδίας",
    "IQD" to "Δηνάριο Ιράκ",
    "IRR" to "Ριάλ Ιράν",
    "ISJ" to "Παλιά κορόνα Ισλανδίας",
    "ISK" to "Κορόνα Ισλανδίας",
    "ITL" to "Λιρέτα Ιταλίας",
    "JMD" to "Δολάριο Τζαμάικας",
    "JOD" to "Δηνάριο Ιορδανίας",
    "JPY" to "Γιεν Ιαπωνίας",
    "KES" to "Σελίνι Κένυας",
    "KGS" to "Σομ Κιργιζίας",
    "KHR" to "Ρίελ Καμπότζης",
    "KMF" to "Φράγκο Κομορών",
    "KPW" to "Γουόν Βόρειας Κορέας",
    "KRW" to "Γουόν Νότιας Κορέας",
    "KWD" to "Δηνάριο Κουβέιτ",
    "KYD" to "Δολάριο Νήσων Κέιμαν",
    "KZT" to "Τένγκε Καζακστάν",
    "LAK" to "Κιπ Λάος",
    "LBP" to "Λίρα Λιβάνου",
    "LKR" to "Ρουπία Σρι Λάνκα",
    "LRD" to "Δολάριο Λιβερίας",
    "LSL" to "Λότι Λεσότο",
    "LTL" to "Λίτα Λιθουανίας",
    "LTT" to "Ταλόνας Λιθουανίας",
    "LUC" to "Μετατρέψιμο Φράγκο Λουξεμβούργου",
    "LUF" to "Φράγκο Λουξεμβούργου",
    "LUL" to "Οικονομικό Φράγκο Λουξεμβούργου",
    "LVL" to "Λατς Λετονίας",
    "LVR" to "Ρούβλι Λετονίας",
    "LYD" to "Δηνάριο Λιβύης",
    "MAD" to "Ντιράμ Μαρόκου",
    "MAF" to "Φράγκο Μαρόκου",
    "MDL" to "Λέου Μολδαβίας",
    "MGA" to "Αριάρι Μαδαγασκάρης",
    "MGF" to "Φράγκο Μαδαγασκάρης",
    "MKD" to "Δηνάριο ΠΓΔΜ",
    "MLF" to "Φράγκο Μαλί",
    "MMK" to "Κιάτ Μιανμάρ",
    "MNT" to "Τουγκρίκ Μογγολίας",
    "MOP" to "Πατάκα Μακάο",
    "MRO" to "Ουγκίγια Μαυριτανίας (1973–2017)",
    "MRU" to "Ουγκίγια Μαυριτανίας",
    "MTL" to "Λιρέτα Μάλτας",
    "MTP" to "Λίρα Μάλτας",
    "MUR" to "Ρουπία Μαυρικίου",
    "MVR" to "Ρουφίγια Μαλδίβων",
    "MWK" to "Κουάτσα Μαλάουι",
    "MXN" to "Πέσο Μεξικού",
    "MXP" to "Ασημένιο Πέσο Μεξικού (1861–1992)",
    "MYR" to "Ρινγκίτ Μαλαισίας",
    "MZE" to "Εσκούδο Μοζαμβίκης",
    "MZM" to "Παλαιό Μετικάλ Μοζαμβίκης",
    "MZN" to "Μετικάλ Μοζαμβίκης",
    "NAD" to "Δολάριο Ναμίμπιας",
    "NGN" to "Νάιρα Νιγηρίας",
    "NIC" to "Κόρδοβα Νικαράγουας",
    "NIO" to "Χρυσή Κόρδοβα Νικαράγουας",
    "NLG" to "Γκίλντα Ολλανδίας",
    "NOK" to "Κορόνα Νορβηγίας",
    "NPR" to "Ρουπία Νεπάλ",
    "NZD" to "Δολάριο Νέας Ζηλανδίας",
    "OMR" to "Ριάλ Ομάν",
    "PAB" to "Μπαλμπόα Παναμά",
    "PEI" to "Ίντι Περού",
    "PEN" to "Σολ Περού",
    "PES" to "Σολ Περού (1863–1965)",
    "PGK" to "Κίνα Παπούας Νέας Γουινέας",
    "PHP" to "Πέσο Φιλιππίνων",
    "PKR" to "Ρουπία Πακιστάν",
    "PLN" to "Ζλότι Πολωνίας",
    "PLZ" to "Ζλότυ Πολωνίας (1950–1995)",
    "PTE" to "Εσκούδο Πορτογαλίας",
    "PYG" to "Γκουαρανί Παραγουάης",
    "QAR" to "Ριάλ Κατάρ",
    "RHD" to "Δολάριο Ροδεσίας",
    "ROL" to "Λέι Ρουμανίας",
    "RON" to "Λέου Ρουμανίας",
    "RSD" to "Δηνάριο Σερβίας",
    "RUB" to "Ρούβλι Ρωσίας",
    "RUR" to "Ρούβλι Ρωσίας (1991–1998)",
    "RWF" to "Φράγκο Ρουάντας",
    "SAR" to "Ριάλ Σαουδικής Αραβίας",
    "SBD" to "Δολάριο Νήσων Σολομώντος",
    "SCR" to "Ρουπία Σεϋχελλών",
    "SDD" to "Δηνάριο Σουδάν",
    "SDG" to "Λίρα Σουδάν",
    "SDP" to "Παλαιά Λίρα Σουδάν",
    "SEK" to "Κορόνα Σουηδίας",
    "SGD" to "Δολάριο Σιγκαπούρης",
    "SHP" to "Λίρα Αγίας Ελένης",
    "SIT" to "Τόλαρ Σλοβενίας",
    "SKK" to "Κορόνα Σλοβενίας",
    "SLE" to "Λεόνε Σιέρα Λεόνε",
    "SLL" to "Λεόνε Σιέρα Λεόνε (1964—2022)",
    "SOS" to "Σελίνι Σομαλίας",
    "SRD" to "Δολάριο Σουρινάμ",
    "SRG" to "Γκίλντα Σουρινάμ",
    "SSP" to "Λίρα Νότιου Σουδάν",
    "STD" to "Ντόμπρα Σάο Τομέ και Πρίνσιπε (1977–2017)",
    "STN" to "Ντόμπρα Σάο Τομέ και Πρίνσιπε",
    "SUR" to "Σοβιετικό Ρούβλι",
    "SVC" to "Κολόν Ελ Σαλβαδόρ",
    "SYP" to "Λίρα Συρίας",
    "SZL" to "Λιλανγκένι Σουαζιλάνδης",
    "THB" to "Μπατ Ταϊλάνδης",
    "TJR" to "Ρούβλι Τατζικιστάν",
    "TJS" to "Σομόνι Τατζικιστάν",
    "TMM" to "Μανάτ Τουρκμενιστάν",
    "TMT" to "Μάνατ Τουρκμενιστάν",
    "TND" to "Δηνάριο Τυνησίας",
    "TOP" to "Παάγκα Τόνγκα",
    "TPE" to "Εσκούδο Τιμόρ",
    "TRL" to "Παλιά Λίρα Τουρκίας",
    "TRY" to "Λίρα Τουρκίας",
    "TTD" to "Δολάριο Τρινιντάντ και Τομπάγκο",
    "TWD" to "Νέο δολάριο Ταϊβάν",
    "TZS" to "Σελίνι Τανζανίας",
    "UAH" to "Γρίβνα Ουκρανίας",
    "UAK" to "Καρμποβανέτς Ουκρανίας",
    "UGS" to "Σελίνι Ουγκάντας (1966–1987)",
    "UGX" to "Σελίνι Ουγκάντας",
    "USD" to "Δολάριο ΗΠΑ",
    "USN" to "Δολάριο ΗΠΑ (επόμενη ημέρα)",
    "USS" to "Δολάριο ΗΠΑ (ίδια ημέρα)",
    "UYP" to "Πέσο Ουρουγουάης (1975–1993)",
    "UYU" to "Πέσο Ουρουγουάης",
    "UZS" to "Σομ Ουζμπεκιστάν",
    "VEB" to "Μπολιβάρ Βενεζουέλας (1871–2008)",
    "VEF" to "Μπολιβάρ Βενεζουέλας (2008–2018)",
    "VES" to "Μπολιβάρ Βενεζουέλας",
    "VND" to "Ντονγκ Βιετνάμ",
    "VUV" to "Βατού Βανουάτου",
    "WST" to "Τάλα Σαμόα",
    "XAF" to "Φράγκο CFA Κεντρικής Αφρικής",
    "XBA" to "Ευρωπαϊκή Σύνθετη Μονάδα",
    "XBB" to "Ευρωπαϊκή Νομισματική Μονάδα",
    "XBC" to "Ευρωπαϊκή μονάδα λογαριασμού (XBC)",
    "XBD" to "Ευρωπαϊκή μονάδα λογαριασμού (XBD)",
    "XCD" to "Δολάριο Ανατολικής Καραϊβικής",
    "XDR" to "Ειδικά Δικαιώματα Ανάληψης",
    "XEU" to "Ευρωπαϊκή Συναλλαγματική Μονάδα",
    "XFO" to "Χρυσό Φράγκο Γαλλίας",
    "XFU" to "UIC-Φράγκο Γαλλίας",
    "XOF" to "Φράγκο CFA Δυτικής Αφρικής",
    "XPF" to "Φράγκο CFP",
    "XXX" to "Άγνωστο νόμισμα",
    "YDD" to "Δηνάριο Υεμένης",
    "YER" to "Ριάλ Υεμένης",
    "YUD" to "Μεταλλικό Δηνάριο Γιουγκοσλαβίας",
    "YUM" to "Νέο Δηνάριο Γιουγκοσλαβίας",
    "YUN" to "Μετατρέψιμο Δηνάριο Γιουγκοσλαβίας",
    "ZAL" to "Ραντ Νότιας Αφρικής (οικονομικό)",
    "ZAR" to "Ραντ Νότιας Αφρικής",
    "ZMK" to "Κουάνζα Ζαΐρ (1968–2012)",
    "ZMW" to "Κουάτσα Ζάμπιας",
    "ZRN" to "Νέο Ζαΐρ Ζαΐρ",
    "ZRZ" to "Ζαΐρ Ζαΐρ",
    "ZWD" to "Δολάριο Ζιμπάμπουε",
    "ZWL" to "Δολάριο Ζιμπάμπουε (2009)",
  ) }

  val el_CY: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val el_polyton: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Πεσέτα Ἀνδόρας",
    "AED" to "Ντιρὰμ Ἡνωμένων Ἀραβικῶν Ἐμιράτων",
    "ALL" to "Λὲκ Ἀλβανίας",
    "AMD" to "Dram Ἀρμενίας",
    "ANG" to "Γκίλντα Ὁλλανδικῶν Ἀντιλλῶν",
    "AOA" to "Kwanza Ἀνγκόλας",
    "AOK" to "Kwanza Ἀνγκόλας (1977–1990)",
    "AON" to "Νέα Kwanza Ἀνγκόλας (1990–2000)",
    "AOR" to "Kwanza Reajustado Ἀνγκόλας (1995–1999)",
    "ARA" to "Austral Ἀργεντινῆς",
    "ARP" to "Πέσο Ἀργεντινῆς (1983–1985)",
    "ARS" to "Πέσο Ἀργεντινῆς",
    "ATS" to "Σελίνι Αὐστρίας",
    "AUD" to "Δολάριο Αὐστραλίας",
    "AWG" to "Γκίλντα Ἀρούμπα",
    "AZM" to "Μανὰτ Ἀζερμπαϊτζάν",
    "BAD" to "Δηνάριο Βοσνίας-Ἑρζεγοβίνης",
    "BAM" to "Μάρκο Βοσνίας-Ἑρζεγοβίνης",
    "BEL" to "Φράγκο Βελγίου (οἰκονομικό)",
    "BGL" to "Μεταλλικὸ Λὲβ Βουλγαρίας",
    "BGN" to "Νέο Λὲβ Βουλγαρίας",
    "CAD" to "Δολάριο Καναδᾶ",
    "CHF" to "Φράγκο Ἑλβετίας",
    "CLF" to "Unidades de Fomento Χιλῆς",
    "CLP" to "Πέσο Χιλῆς",
    "CSK" to "Σκληρὴ Κορόνα Τσεχοσλοβακίας",
    "CVE" to "Ἐσκούδο Πράσινου Ἀκρωτηρίου",
    "DDM" to "Ostmark Ἀνατολικῆς Γερμανίας",
    "DZD" to "Δηνάριο Ἀλγερίας",
    "ECS" to "Sucre Ἰσημερινοῦ",
    "ECV" to "Unidad de Valor Constante (UVC) Ἰσημερινοῦ",
    "EEK" to "Κορόνα Ἐστονίας",
    "EGP" to "Λίρα Αἰγύπτου",
    "ERN" to "Nakfa Ἐρυθραίας",
    "ESP" to "Πεσέτα Ἱσπανίας",
    "ETB" to "Birr Αἰθιοπίας",
    "EUR" to "Εὐρώ",
    "FKP" to "Λίρα Νήσων Φώλκλαντ",
    "GMD" to "Dalasi Γκάμπιας",
    "GQE" to "Ekwele Guineana Ἰσημερινῆς Γουινέας",
    "GTQ" to "Quetzal Γουατεμάλας",
    "GWE" to "Γκινέα Ἐσκούδο Πορτογαλίας",
    "HKD" to "Δολάριο Χὸνγκ Κόνγκ",
    "HTG" to "Gourde Ἁϊτῆς",
    "HUF" to "Φιορίνι Οὑγγαρίας",
    "IDR" to "Ρούπια Ἰνδονησίας",
    "IEP" to "Λίρα Ἰρλανδίας",
    "ILP" to "Λίρα Ἰσραήλ",
    "ILS" to "Νέο Sheqel Ἰσραήλ",
    "INR" to "Ρούπια Ἰνδίας",
    "IQD" to "Δηνάριο Ἰράκ",
    "IRR" to "Rial Ἰράκ",
    "ISK" to "Κορόνα Ἰσλανδίας",
    "ITL" to "Λιρέτα Ἰταλίας",
    "JOD" to "Δηνάριο Ἰορδανίας",
    "JPY" to "Γιὲν Ἰαπωνίας",
    "LKR" to "Ρούπια Σρὶ Λάνκας",
    "MOP" to "Pataca Μακάου",
    "MXN" to "Πέσο Μεξικοῦ",
    "MXP" to "Ἀσημένιο Πέσο Μεξικοῦ (1861–1992)",
    "MXV" to "Unidad de Inversion (UDI) Μεξικοῦ",
    "MZE" to "Ἐσκούδο Μοζαμβίκης",
    "NIO" to "Χρυσὴ Κόρδοβα Νικαράγουας",
    "NLG" to "Γκίλντα Ὁλλανδίας",
    "PAB" to "Μπαλμπόα Παναμᾶ",
    "PGK" to "Kina Παπούα Νέα Γουινέας",
    "PTE" to "Ἐσκούδο Πορτογαλίας",
    "PYG" to "Γκουαρανὶ Παραγουάης",
    "SBD" to "Δολάριο Νήσων Σολομῶντος",
    "SCR" to "Ρούπια Σεϋχελῶν",
    "SHP" to "Λίρα Ἀγίας Ἑλένης",
    "SUR" to "Σοβιετικὸ Ρούβλι",
    "SVC" to "Colon Ἒλ Σαλβαδόρ",
    "SZL" to "Lilangeni Ζουαζιλάνδης",
    "THB" to "Μπὰτ Ταϊλάνδης",
    "TMM" to "Μανὰτ Τουρκμενιστάν",
    "TPE" to "Ἐσκούδο Τιμόρ",
    "TTD" to "Δολάριο Τρινιδὰδ καὶ Τομπάγκο",
    "UAH" to "Hryvnia Οὐκρανίας",
    "UAK" to "Karbovanetz Οὐκρανίας",
    "UGS" to "Σελίνι Οὐγκάντας (1966–1987)",
    "UGX" to "Σελίνι Οὐγκάντας",
    "USN" to "Δολάριο ΗΠΑ (Ἑπόμενη ἡμέρα)",
    "USS" to "Δολάριο ΗΠΑ (Ἴδια ἡμέρα)",
    "UYP" to "Πέσο Οὐρουγουάης (1975–1993)",
    "UYU" to "Πέσο Uruguayo Οὐρουγουάης",
    "UZS" to "Sum Οὐζμπεκιστάν",
    "VEB" to "Μπολιβὰλ Βενεζουέλας",
    "WST" to "Tala Δυτικῆς Σαμόας",
    "XBA" to "Εὐρωπαϊκὴ Σύνθετη Μονάδα",
    "XBB" to "Εὐρωπαϊκὴ Νομισματικὴ Μονάδα",
    "XBC" to "Εὐρωπαϊκὴ Μονάδα Λογαριασμοῦ (XBC)",
    "XBD" to "Εὐρωπαϊκὴ Μονάδα Λογαριασμοῦ (XBD)",
    "XCD" to "Δολάριο Ἀνατολικῆς Καραϊβικῆς",
    "XDR" to "Εἰδικὰ Δικαιώματα Ἀνάληψης",
    "XEU" to "Εὐρωπαϊκὴ Συναλλαγματικὴ Μονάδα",
    "XFO" to "Χρυσὸ Φράγκο Γαλλίας",
    "YDD" to "Δηνάριο Ὑεμένης",
    "YER" to "Rial Ὑεμένης",
    "YUD" to "Μεταλλικὸ Δηνάριο Γιουγκοσλαβίας",
    "ZAL" to "Ραντ Νότιας Ἀφρικῆς (οἰκονομικό)",
    "ZAR" to "Ρὰντ Νότιας Ἀφρικῆς",
  ) }

  val en: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorran Peseta",
    "AED" to "United Arab Emirates Dirham",
    "AFA" to "Afghan Afghani (1927–2002)",
    "AFN" to "Afghan Afghani",
    "ALK" to "Albanian Lek (1946–1965)",
    "ALL" to "Albanian Lek",
    "AMD" to "Armenian Dram",
    "ANG" to "Netherlands Antillean Guilder",
    "AOA" to "Angolan Kwanza",
    "AOK" to "Angolan Kwanza (1977–1991)",
    "AON" to "Angolan New Kwanza (1990–2000)",
    "AOR" to "Angolan Readjusted Kwanza (1995–1999)",
    "ARA" to "Argentine Austral",
    "ARL" to "Argentine Peso Ley (1970–1983)",
    "ARM" to "Argentine Peso (1881–1970)",
    "ARP" to "Argentine Peso (1983–1985)",
    "ARS" to "Argentine Peso",
    "ATS" to "Austrian Schilling",
    "AUD" to "Australian Dollar",
    "AWG" to "Aruban Florin",
    "AZM" to "Azerbaijani Manat (1993–2006)",
    "AZN" to "Azerbaijani Manat",
    "BAD" to "Bosnia-Herzegovina Dinar (1992–1994)",
    "BAM" to "Bosnia-Herzegovina Convertible Mark",
    "BAN" to "Bosnia-Herzegovina New Dinar (1994–1997)",
    "BBD" to "Barbadian Dollar",
    "BDT" to "Bangladeshi Taka",
    "BEC" to "Belgian Franc (convertible)",
    "BEF" to "Belgian Franc",
    "BEL" to "Belgian Franc (financial)",
    "BGL" to "Bulgarian Hard Lev",
    "BGM" to "Bulgarian Socialist Lev",
    "BGN" to "Bulgarian Lev",
    "BGO" to "Bulgarian Lev (1879–1952)",
    "BHD" to "Bahraini Dinar",
    "BIF" to "Burundian Franc",
    "BMD" to "Bermudan Dollar",
    "BND" to "Brunei Dollar",
    "BOB" to "Bolivian Boliviano",
    "BOL" to "Bolivian Boliviano (1863–1963)",
    "BOP" to "Bolivian Peso",
    "BOV" to "Bolivian Mvdol",
    "BRB" to "Brazilian New Cruzeiro (1967–1986)",
    "BRC" to "Brazilian Cruzado (1986–1989)",
    "BRE" to "Brazilian Cruzeiro (1990–1993)",
    "BRL" to "Brazilian Real",
    "BRN" to "Brazilian New Cruzado (1989–1990)",
    "BRR" to "Brazilian Cruzeiro (1993–1994)",
    "BRZ" to "Brazilian Cruzeiro (1942–1967)",
    "BSD" to "Bahamian Dollar",
    "BTN" to "Bhutanese Ngultrum",
    "BUK" to "Burmese Kyat",
    "BWP" to "Botswanan Pula",
    "BYB" to "Belarusian Ruble (1994–1999)",
    "BYN" to "Belarusian Ruble",
    "BYR" to "Belarusian Ruble (2000–2016)",
    "BZD" to "Belize Dollar",
    "CAD" to "Canadian Dollar",
    "CDF" to "Congolese Franc",
    "CHE" to "WIR Euro",
    "CHF" to "Swiss Franc",
    "CHW" to "WIR Franc",
    "CLE" to "Chilean Escudo",
    "CLF" to "Chilean Unit of Account (UF)",
    "CLP" to "Chilean Peso",
    "CNH" to "Chinese Yuan (offshore)",
    "CNX" to "Chinese People’s Bank Dollar",
    "CNY" to "Chinese Yuan",
    "COP" to "Colombian Peso",
    "COU" to "Colombian Real Value Unit",
    "CRC" to "Costa Rican Colón",
    "CSD" to "Serbian Dinar (2002–2006)",
    "CSK" to "Czechoslovak Hard Koruna",
    "CUC" to "Cuban Convertible Peso",
    "CUP" to "Cuban Peso",
    "CVE" to "Cape Verdean Escudo",
    "CYP" to "Cypriot Pound",
    "CZK" to "Czech Koruna",
    "DDM" to "East German Mark",
    "DEM" to "German Mark",
    "DJF" to "Djiboutian Franc",
    "DKK" to "Danish Krone",
    "DOP" to "Dominican Peso",
    "DZD" to "Algerian Dinar",
    "ECS" to "Ecuadorian Sucre",
    "ECV" to "Ecuadorian Unit of Constant Value",
    "EEK" to "Estonian Kroon",
    "EGP" to "Egyptian Pound",
    "ERN" to "Eritrean Nakfa",
    "ESA" to "Spanish Peseta (A account)",
    "ESB" to "Spanish Peseta (convertible account)",
    "ESP" to "Spanish Peseta",
    "ETB" to "Ethiopian Birr",
    "EUR" to "Euro",
    "FIM" to "Finnish Markka",
    "FJD" to "Fijian Dollar",
    "FKP" to "Falkland Islands Pound",
    "FRF" to "French Franc",
    "GBP" to "British Pound",
    "GEK" to "Georgian Kupon Larit",
    "GEL" to "Georgian Lari",
    "GHC" to "Ghanaian Cedi (1979–2007)",
    "GHS" to "Ghanaian Cedi",
    "GIP" to "Gibraltar Pound",
    "GMD" to "Gambian Dalasi",
    "GNF" to "Guinean Franc",
    "GNS" to "Guinean Syli",
    "GQE" to "Equatorial Guinean Ekwele",
    "GRD" to "Greek Drachma",
    "GTQ" to "Guatemalan Quetzal",
    "GWE" to "Portuguese Guinea Escudo",
    "GWP" to "Guinea-Bissau Peso",
    "GYD" to "Guyanaese Dollar",
    "HKD" to "Hong Kong Dollar",
    "HNL" to "Honduran Lempira",
    "HRD" to "Croatian Dinar",
    "HRK" to "Croatian Kuna",
    "HTG" to "Haitian Gourde",
    "HUF" to "Hungarian Forint",
    "IDR" to "Indonesian Rupiah",
    "IEP" to "Irish Pound",
    "ILP" to "Israeli Pound",
    "ILR" to "Israeli Shekel (1980–1985)",
    "ILS" to "Israeli New Shekel",
    "INR" to "Indian Rupee",
    "IQD" to "Iraqi Dinar",
    "IRR" to "Iranian Rial",
    "ISJ" to "Icelandic Króna (1918–1981)",
    "ISK" to "Icelandic Króna",
    "ITL" to "Italian Lira",
    "JMD" to "Jamaican Dollar",
    "JOD" to "Jordanian Dinar",
    "JPY" to "Japanese Yen",
    "KES" to "Kenyan Shilling",
    "KGS" to "Kyrgystani Som",
    "KHR" to "Cambodian Riel",
    "KMF" to "Comorian Franc",
    "KPW" to "North Korean Won",
    "KRH" to "South Korean Hwan (1953–1962)",
    "KRO" to "South Korean Won (1945–1953)",
    "KRW" to "South Korean Won",
    "KWD" to "Kuwaiti Dinar",
    "KYD" to "Cayman Islands Dollar",
    "KZT" to "Kazakhstani Tenge",
    "LAK" to "Laotian Kip",
    "LBP" to "Lebanese Pound",
    "LKR" to "Sri Lankan Rupee",
    "LRD" to "Liberian Dollar",
    "LSL" to "Lesotho Loti",
    "LTL" to "Lithuanian Litas",
    "LTT" to "Lithuanian Talonas",
    "LUC" to "Luxembourgian Convertible Franc",
    "LUF" to "Luxembourgian Franc",
    "LUL" to "Luxembourg Financial Franc",
    "LVL" to "Latvian Lats",
    "LVR" to "Latvian Ruble",
    "LYD" to "Libyan Dinar",
    "MAD" to "Moroccan Dirham",
    "MAF" to "Moroccan Franc",
    "MCF" to "Monegasque Franc",
    "MDC" to "Moldovan Cupon",
    "MDL" to "Moldovan Leu",
    "MGA" to "Malagasy Ariary",
    "MGF" to "Malagasy Franc",
    "MKD" to "Macedonian Denar",
    "MKN" to "Macedonian Denar (1992–1993)",
    "MLF" to "Malian Franc",
    "MMK" to "Myanmar Kyat",
    "MNT" to "Mongolian Tugrik",
    "MOP" to "Macanese Pataca",
    "MRO" to "Mauritanian Ouguiya (1973–2017)",
    "MRU" to "Mauritanian Ouguiya",
    "MTL" to "Maltese Lira",
    "MTP" to "Maltese Pound",
    "MUR" to "Mauritian Rupee",
    "MVP" to "Maldivian Rupee (1947–1981)",
    "MVR" to "Maldivian Rufiyaa",
    "MWK" to "Malawian Kwacha",
    "MXN" to "Mexican Peso",
    "MXP" to "Mexican Silver Peso (1861–1992)",
    "MXV" to "Mexican Investment Unit",
    "MYR" to "Malaysian Ringgit",
    "MZE" to "Mozambican Escudo",
    "MZM" to "Mozambican Metical (1980–2006)",
    "MZN" to "Mozambican Metical",
    "NAD" to "Namibian Dollar",
    "NGN" to "Nigerian Naira",
    "NIC" to "Nicaraguan Córdoba (1988–1991)",
    "NIO" to "Nicaraguan Córdoba",
    "NLG" to "Dutch Guilder",
    "NOK" to "Norwegian Krone",
    "NPR" to "Nepalese Rupee",
    "NZD" to "New Zealand Dollar",
    "OMR" to "Omani Rial",
    "PAB" to "Panamanian Balboa",
    "PEI" to "Peruvian Inti",
    "PEN" to "Peruvian Sol",
    "PES" to "Peruvian Sol (1863–1965)",
    "PGK" to "Papua New Guinean Kina",
    "PHP" to "Philippine Peso",
    "PKR" to "Pakistani Rupee",
    "PLN" to "Polish Zloty",
    "PLZ" to "Polish Zloty (1950–1995)",
    "PTE" to "Portuguese Escudo",
    "PYG" to "Paraguayan Guarani",
    "QAR" to "Qatari Riyal",
    "RHD" to "Rhodesian Dollar",
    "ROL" to "Romanian Leu (1952–2006)",
    "RON" to "Romanian Leu",
    "RSD" to "Serbian Dinar",
    "RUB" to "Russian Ruble",
    "RUR" to "Russian Ruble (1991–1998)",
    "RWF" to "Rwandan Franc",
    "SAR" to "Saudi Riyal",
    "SBD" to "Solomon Islands Dollar",
    "SCR" to "Seychellois Rupee",
    "SDD" to "Sudanese Dinar (1992–2007)",
    "SDG" to "Sudanese Pound",
    "SDP" to "Sudanese Pound (1957–1998)",
    "SEK" to "Swedish Krona",
    "SGD" to "Singapore Dollar",
    "SHP" to "St. Helena Pound",
    "SIT" to "Slovenian Tolar",
    "SKK" to "Slovak Koruna",
    "SLE" to "Sierra Leonean Leone",
    "SLL" to "Sierra Leonean Leone (1964—2022)",
    "SOS" to "Somali Shilling",
    "SRD" to "Surinamese Dollar",
    "SRG" to "Surinamese Guilder",
    "SSP" to "South Sudanese Pound",
    "STD" to "São Tomé & Príncipe Dobra (1977–2017)",
    "STN" to "São Tomé & Príncipe Dobra",
    "SUR" to "Soviet Rouble",
    "SVC" to "Salvadoran Colón",
    "SYP" to "Syrian Pound",
    "SZL" to "Swazi Lilangeni",
    "THB" to "Thai Baht",
    "TJR" to "Tajikistani Ruble",
    "TJS" to "Tajikistani Somoni",
    "TMM" to "Turkmenistani Manat (1993–2009)",
    "TMT" to "Turkmenistani Manat",
    "TND" to "Tunisian Dinar",
    "TOP" to "Tongan Paʻanga",
    "TPE" to "Timorese Escudo",
    "TRL" to "Turkish Lira (1922–2005)",
    "TRY" to "Turkish Lira",
    "TTD" to "Trinidad & Tobago Dollar",
    "TWD" to "New Taiwan Dollar",
    "TZS" to "Tanzanian Shilling",
    "UAH" to "Ukrainian Hryvnia",
    "UAK" to "Ukrainian Karbovanets",
    "UGS" to "Ugandan Shilling (1966–1987)",
    "UGX" to "Ugandan Shilling",
    "USD" to "US Dollar",
    "USN" to "US Dollar (Next day)",
    "USS" to "US Dollar (Same day)",
    "UYI" to "Uruguayan Peso (Indexed Units)",
    "UYP" to "Uruguayan Peso (1975–1993)",
    "UYU" to "Uruguayan Peso",
    "UYW" to "Uruguayan Nominal Wage Index Unit",
    "UZS" to "Uzbekistani Som",
    "VEB" to "Venezuelan Bolívar (1871–2008)",
    "VED" to "Bolívar Soberano",
    "VEF" to "Venezuelan Bolívar (2008–2018)",
    "VES" to "Venezuelan Bolívar",
    "VND" to "Vietnamese Dong",
    "VNN" to "Vietnamese Dong (1978–1985)",
    "VUV" to "Vanuatu Vatu",
    "WST" to "Samoan Tala",
    "XAF" to "Central African CFA Franc",
    "XAG" to "Silver",
    "XAU" to "Gold",
    "XBA" to "European Composite Unit",
    "XBB" to "European Monetary Unit",
    "XBC" to "European Unit of Account (XBC)",
    "XBD" to "European Unit of Account (XBD)",
    "XCD" to "East Caribbean Dollar",
    "XCG" to "Caribbean guilder",
    "XDR" to "Special Drawing Rights",
    "XEU" to "European Currency Unit",
    "XFO" to "French Gold Franc",
    "XFU" to "French UIC-Franc",
    "XOF" to "West African CFA Franc",
    "XPD" to "Palladium",
    "XPF" to "CFP Franc",
    "XPT" to "Platinum",
    "XRE" to "RINET Funds",
    "XSU" to "Sucre",
    "XTS" to "Testing Currency Code",
    "XUA" to "ADB Unit of Account",
    "XXX" to "Unknown Currency",
    "YDD" to "Yemeni Dinar",
    "YER" to "Yemeni Rial",
    "YUD" to "Yugoslavian Hard Dinar (1966–1990)",
    "YUM" to "Yugoslavian New Dinar (1994–2002)",
    "YUN" to "Yugoslavian Convertible Dinar (1990–1992)",
    "YUR" to "Yugoslavian Reformed Dinar (1992–1993)",
    "ZAL" to "South African Rand (financial)",
    "ZAR" to "South African Rand",
    "ZMK" to "Zambian Kwacha (1968–2012)",
    "ZMW" to "Zambian Kwacha",
    "ZRN" to "Zairean New Zaire (1993–1998)",
    "ZRZ" to "Zairean Zaire (1971–1993)",
    "ZWD" to "Zimbabwean Dollar (1980–2008)",
    "ZWG" to "Zimbabwean Gold",
    "ZWL" to "Zimbabwean Dollar (2009–2024)",
    "ZWR" to "Zimbabwean Dollar (2008)",
  ) }

  val en_001: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_150: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_AE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_AG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_AI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_AS: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_AT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_AU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BAM" to "Bosnia-Herzegovina Convertible Marka",
    "BBD" to "Barbados Dollar",
    "BMD" to "Bermuda Dollar",
    "BOB" to "Bolivian boliviano",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "ILS" to "Israeli Shekel",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "SLL" to "Sierra Leonean Leone (1964–2022)",
    "SRD" to "Suriname Dollar",
    "TJR" to "Tajikistani Rouble",
    "UYU" to "Peso Uruguayo",
    "VES" to "Venezuelan bolívar",
  ) }

  val en_BB: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_BE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_BI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_BM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_BS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_BW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_BZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_CA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "Saint Helena Pound",
    "STN" to "São Tomé and Príncipe Dobra",
    "TJR" to "Tajikistani Rouble",
    "TTD" to "Trinidad and Tobago Dollar",
    "XXX" to "unknown currency",
  ) }

  val en_CC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_CK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_CX: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_CY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_DE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_DG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_DK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_DM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_Dsrt: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_ER: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_FI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_FJ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_FK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_FM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_GB: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_GD: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_GG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "GBP" to "UK Pound",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_GI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_GM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_GU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_GY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_HK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_ID: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_IE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_IL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_IM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "GBP" to "UK Pound",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "KGS" to "Kyrgyzstani Som",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
    "VEF" to "Venezuelan Bolívar",
    "VES" to "VEF",
  ) }

  val en_IO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_JE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "GBP" to "UK Pound",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_JM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_KE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_KI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_KN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_KY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_LC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_LR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_LS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_MG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_MH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_MO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_MP: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_MS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_MT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_MU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_MV: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_MW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_MY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_NA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_NF: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_NG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_NL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_NR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_NU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_NZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_PG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_PH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_PK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_PN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_PR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_PW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_RW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SB: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SD: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SX: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_SZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_Shaw: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_TC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_TK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_TO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_TT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_TV: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_TZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_UG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_UM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_VC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_VG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_VI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_VU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_WS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_ZA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_ZM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val en_ZW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Bermudian Dollar",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "LVR" to "Latvian Rouble",
    "RUB" to "Russian Rouble",
    "RUR" to "Russian Rouble (1991–1998)",
    "SHP" to "St Helena Pound",
    "TJR" to "Tajikistani Rouble",
  ) }

  val eo: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "peseta andorrana",
    "AED" to "dírham de los Emiratos Árabes Unidos",
    "AFA" to "afgani (1927–2002)",
    "AFN" to "afgani afgano",
    "ALL" to "lek albanés",
    "AMD" to "dram armenio",
    "ANG" to "florín antillano",
    "AOA" to "kuanza angoleño",
    "AOK" to "kwanza angoleño (1977–1990)",
    "AON" to "nuevo kwanza angoleño (1990–2000)",
    "AOR" to "kwanza reajustado angoleño (1995–1999)",
    "ARA" to "austral argentino",
    "ARP" to "peso argentino (1983–1985)",
    "ARS" to "peso argentino",
    "ATS" to "chelín austriaco",
    "AUD" to "dólar australiano",
    "AWG" to "florín arubeño",
    "AZM" to "manat azerí (1993–2006)",
    "AZN" to "manat azerbaiyano",
    "BAD" to "dinar bosnio",
    "BAM" to "marco convertible de Bosnia y Herzegovina",
    "BBD" to "dólar barbadense",
    "BDT" to "taka bangladesí",
    "BEC" to "franco belga (convertible)",
    "BEF" to "franco belga",
    "BEL" to "franco belga (financiero)",
    "BGL" to "lev fuerte búlgaro",
    "BGN" to "leva búlgara",
    "BHD" to "dinar bareiní",
    "BIF" to "franco burundés",
    "BMD" to "dólar bermudeño",
    "BND" to "dólar bruneano",
    "BOB" to "boliviano",
    "BOP" to "peso boliviano",
    "BOV" to "MVDOL boliviano",
    "BRB" to "nuevo cruceiro brasileño (1967–1986)",
    "BRC" to "cruzado brasileño",
    "BRE" to "cruceiro brasileño (1990–1993)",
    "BRL" to "real brasileño",
    "BRN" to "nuevo cruzado brasileño",
    "BRR" to "cruceiro brasileño",
    "BSD" to "dólar bahameño",
    "BTN" to "gultrum butanés",
    "BUK" to "kyat birmano",
    "BWP" to "pula botsuano",
    "BYB" to "nuevo rublo bielorruso (1994–1999)",
    "BYN" to "rublo bielorruso",
    "BYR" to "rublo bielorruso (2000–2016)",
    "BZD" to "dólar beliceño",
    "CAD" to "dólar canadiense",
    "CDF" to "franco congoleño",
    "CHE" to "euro WIR",
    "CHF" to "franco suizo",
    "CHW" to "franco WIR",
    "CLF" to "unidad de fomento chilena",
    "CLP" to "peso chileno",
    "CNH" to "yuan chino (extracontinental)",
    "CNY" to "yuan renminbi",
    "COP" to "peso colombiano",
    "COU" to "unidad de valor real colombiana",
    "CRC" to "colón costarricense",
    "CSD" to "antiguo dinar serbio",
    "CSK" to "corona fuerte checoslovaca",
    "CUC" to "peso cubano convertible",
    "CUP" to "peso cubano",
    "CVE" to "escudo de Cabo Verde",
    "CYP" to "libra chipriota",
    "CZK" to "corona checa",
    "DDM" to "ostmark de Alemania del Este",
    "DEM" to "marco alemán",
    "DJF" to "franco yibutiano",
    "DKK" to "corona danesa",
    "DOP" to "peso dominicano",
    "DZD" to "dinar argelino",
    "ECS" to "sucre ecuatoriano",
    "ECV" to "unidad de valor constante (UVC) ecuatoriana",
    "EEK" to "corona estonia",
    "EGP" to "libra egipcia",
    "ERN" to "nakfa eritreo",
    "ESA" to "peseta española (cuenta A)",
    "ESB" to "peseta española (cuenta convertible)",
    "ESP" to "peseta española",
    "ETB" to "bir etíope",
    "EUR" to "euro",
    "FIM" to "marco finlandés",
    "FJD" to "dólar fiyiano",
    "FKP" to "libra malvinense",
    "FRF" to "franco francés",
    "GBP" to "libra esterlina",
    "GEK" to "kupon larit georgiano",
    "GEL" to "lari georgiano",
    "GHC" to "cedi ghanés (1979–2007)",
    "GHS" to "cedi ghanés",
    "GIP" to "libra gibraltareña",
    "GMD" to "dalasi gambiano",
    "GNF" to "franco guineano",
    "GNS" to "syli guineano",
    "GQE" to "ekuele de Guinea Ecuatorial",
    "GRD" to "dracma griego",
    "GTQ" to "quetzal guatemalteco",
    "GWE" to "escudo de Guinea Portuguesa",
    "GWP" to "peso de Guinea-Bissáu",
    "GYD" to "dólar guyanés",
    "HKD" to "dólar hongkonés",
    "HNL" to "lempira hondureño",
    "HRD" to "dinar croata",
    "HRK" to "kuna croata",
    "HTG" to "gurde haitiano",
    "HUF" to "forinto húngaro",
    "IDR" to "rupia indonesia",
    "IEP" to "libra irlandesa",
    "ILP" to "libra israelí",
    "ILS" to "nuevo séquel israelí",
    "INR" to "rupia india",
    "IQD" to "dinar iraquí",
    "IRR" to "rial iraní",
    "ISK" to "corona islandesa",
    "ITL" to "lira italiana",
    "JMD" to "dólar jamaicano",
    "JOD" to "dinar jordano",
    "JPY" to "yen japonés",
    "KES" to "chelín keniano",
    "KGS" to "som kirguís",
    "KHR" to "riel camboyano",
    "KMF" to "franco comorense",
    "KPW" to "won norcoreano",
    "KRW" to "won surcoreano",
    "KWD" to "dinar kuwaití",
    "KYD" to "dólar de las Islas Caimán",
    "KZT" to "tengue kazajo",
    "LAK" to "kip laosiano",
    "LBP" to "libra libanesa",
    "LKR" to "rupia esrilanquesa",
    "LRD" to "dólar liberiano",
    "LSL" to "loti lesotense",
    "LTL" to "litas lituano",
    "LTT" to "talonas lituano",
    "LUC" to "franco convertible luxemburgués",
    "LUF" to "franco luxemburgués",
    "LUL" to "franco financiero luxemburgués",
    "LVL" to "lats letón",
    "LVR" to "rublo letón",
    "LYD" to "dinar libio",
    "MAD" to "dírham marroquí",
    "MAF" to "franco marroquí",
    "MDL" to "leu moldavo",
    "MGA" to "ariari malgache",
    "MGF" to "franco malgache",
    "MKD" to "dinar macedonio",
    "MLF" to "franco malí",
    "MMK" to "kiat de Myanmar",
    "MNT" to "tugrik mongol",
    "MOP" to "pataca macaense",
    "MRO" to "uguiya (1973–2017)",
    "MRU" to "uguiya mauritano",
    "MTL" to "lira maltesa",
    "MTP" to "libra maltesa",
    "MUR" to "rupia mauriciana",
    "MVR" to "rufiya maldiva",
    "MWK" to "kuacha malauí",
    "MXN" to "peso mexicano",
    "MXP" to "peso de plata mexicano (1861–1992)",
    "MXV" to "unidad de inversión (UDI) mexicana",
    "MYR" to "ringit malasio",
    "MZE" to "escudo mozambiqueño",
    "MZM" to "antiguo metical mozambiqueño",
    "MZN" to "metical mozambiqueño",
    "NAD" to "dólar namibio",
    "NGN" to "naira nigeriano",
    "NIC" to "córdoba nicaragüense (1988–1991)",
    "NIO" to "córdoba oro",
    "NLG" to "florín neerlandés",
    "NOK" to "corona noruega",
    "NPR" to "rupia nepalí",
    "NZD" to "dólar neozelandés",
    "OMR" to "rial omaní",
    "PAB" to "balboa panameño",
    "PEI" to "inti peruano",
    "PEN" to "sol peruano",
    "PES" to "sol peruano (1863–1965)",
    "PGK" to "kina papú",
    "PHP" to "peso filipino",
    "PKR" to "rupia pakistaní",
    "PLN" to "esloti polaco",
    "PLZ" to "zloty polaco (1950–1995)",
    "PTE" to "escudo portugués",
    "PYG" to "guaraní paraguayo",
    "QAR" to "rial catarí",
    "RHD" to "dólar rodesiano",
    "ROL" to "antiguo leu rumano",
    "RON" to "leu rumano",
    "RSD" to "dinar serbio",
    "RUB" to "rublo ruso",
    "RUR" to "rublo ruso (1991–1998)",
    "RWF" to "franco ruandés",
    "SAR" to "rial saudí",
    "SBD" to "dólar salomonense",
    "SCR" to "rupia seychellense",
    "SDD" to "dinar sudanés",
    "SDG" to "libra sudanesa",
    "SDP" to "libra sudanesa antigua",
    "SEK" to "corona sueca",
    "SGD" to "dólar singapurense",
    "SHP" to "libra de Santa Elena",
    "SIT" to "tólar esloveno",
    "SKK" to "corona eslovaca",
    "SLE" to "leona sierraleonesa",
    "SLL" to "leona sierraleonesa (1964–2022)",
    "SOS" to "chelín somalí",
    "SRD" to "dólar surinamés",
    "SRG" to "florín surinamés",
    "SSP" to "libra sursudanesa",
    "STD" to "dobra (1977–2017)",
    "STN" to "dobra santotomense",
    "SUR" to "rublo soviético",
    "SVC" to "colón salvadoreño",
    "SYP" to "libra siria",
    "SZL" to "lilangeni esuatiní",
    "THB" to "bat tailandés",
    "TJR" to "rublo tayiko",
    "TJS" to "somoni tayiko",
    "TMM" to "manat turcomano (1993–2009)",
    "TMT" to "manat turcomano",
    "TND" to "dinar tunecino",
    "TOP" to "paanga tongano",
    "TPE" to "escudo timorense",
    "TRL" to "lira turca (1922–2005)",
    "TRY" to "lira turca",
    "TTD" to "dólar de Trinidad y Tobago",
    "TWD" to "nuevo dólar taiwanés",
    "TZS" to "chelín tanzano",
    "UAH" to "grivna ucraniana",
    "UAK" to "karbovanet ucraniano",
    "UGS" to "chelín ugandés (1966–1987)",
    "UGX" to "chelín ugandés",
    "USD" to "dólar estadounidense",
    "USN" to "dólar estadounidense (día siguiente)",
    "USS" to "dólar estadounidense (mismo día)",
    "UYI" to "peso uruguayo en unidades indexadas",
    "UYP" to "peso uruguayo (1975–1993)",
    "UYU" to "peso uruguayo",
    "UYW" to "unidad previsional uruguayo",
    "UZS" to "sum uzbeko",
    "VEB" to "bolívar venezolano (1871–2008)",
    "VEF" to "bolívar venezolano (2008–2018)",
    "VES" to "bolívar venezolano",
    "VND" to "dong vietnamita",
    "VUV" to "vatu vanuatense",
    "WST" to "tala samoano",
    "XAF" to "franco CFA de África Central",
    "XAG" to "plata",
    "XAU" to "oro",
    "XBA" to "unidad compuesta europea",
    "XBB" to "unidad monetaria europea",
    "XBC" to "unidad de cuenta europea (XBC)",
    "XBD" to "unidad de cuenta europea (XBD)",
    "XCD" to "dólar del Caribe Oriental",
    "XCG" to "florín caribeño",
    "XDR" to "derechos especiales de giro",
    "XEU" to "unidad de moneda europea",
    "XFO" to "franco oro francés",
    "XFU" to "franco UIC francés",
    "XOF" to "franco CFA de África Occidental",
    "XPD" to "paladio",
    "XPF" to "franco CFP",
    "XPT" to "platino",
    "XRE" to "fondos RINET",
    "XTS" to "código reservado para pruebas",
    "XXX" to "moneda desconocida",
    "YDD" to "dinar yemení",
    "YER" to "rial yemení",
    "YUD" to "dinar fuerte yugoslavo",
    "YUM" to "super dinar yugoslavo",
    "YUN" to "dinar convertible yugoslavo",
    "ZAL" to "rand sudafricano (financiero)",
    "ZAR" to "rand sudafricano",
    "ZMK" to "kwacha zambiano (1968–2012)",
    "ZMW" to "kuacha zambiano",
    "ZRN" to "nuevo zaire zaireño",
    "ZRZ" to "zaire zaireño",
    "ZWD" to "dólar de Zimbabue",
    "ZWL" to "dólar zimbabuense",
  ) }

  val es_419: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_AR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_BO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_BR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_BZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_CL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "CLP" to "Peso chileno",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_CO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_CR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_CU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_DO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_EA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_EC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_GQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_GT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "GTQ" to "quetzal",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_HN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_IC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_MX: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "BTN" to "ngultrum butanés",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MVR" to "rupia de Maldivas",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandés",
    "UZS" to "som uzbeko",
    "ZMW" to "kwacha zambiano",
  ) }

  val es_NI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_PA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_PE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_PH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_PR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_PY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_SV: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_US: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "BTN" to "ngultrum butanés",
    "ETB" to "birr",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "bat",
    "UZS" to "sum",
    "XAF" to "franco CFA de África central",
    "ZMW" to "kwacha zambiano",
  ) }

  val es_UY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
  ) }

  val es_VE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ANG" to "florín de las Antillas Neerlandesas",
    "BMD" to "dólar de Bermudas",
    "HTG" to "gourde haitiano",
    "KZT" to "tenge kazajo",
    "MWK" to "kwacha malauí",
    "NIO" to "córdoba nicaragüense",
    "SLE" to "leone",
    "SLL" to "leones (1964—2022)",
    "THB" to "baht tailandes",
    "UZS" to "som uzbeko",
    "VES" to "bolívar soberano",
  ) }

  val et: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorra peseeta",
    "AED" to "Araabia Ühendemiraatide dirhem",
    "AFA" to "Afganistani afgaani (1927–2002)",
    "AFN" to "Afganistani afgaani",
    "ALK" to "Albaania lekk (1946–1965)",
    "ALL" to "Albaania lekk",
    "AMD" to "Armeenia dramm",
    "ANG" to "Hollandi Antillide kulden",
    "AOA" to "Angola kvanza",
    "AOK" to "Angola kvanza (1977–1990)",
    "AON" to "Angola kvanza (1990–2000)",
    "AOR" to "Angola reformitud kvanza, 1995–1999",
    "ARA" to "Argentina austral",
    "ARM" to "Argentina peeso (1881–1970)",
    "ARP" to "Argentina peeso (1983–1985)",
    "ARS" to "Argentina peeso",
    "ATS" to "Austria šilling",
    "AUD" to "Austraalia dollar",
    "AWG" to "Aruba kulden",
    "AZM" to "Aserbaidžaani manat (1993–2006)",
    "AZN" to "Aserbaidžaani manat",
    "BAD" to "Bosnia ja Hertsegoviina dinaar (1992–1994)",
    "BAM" to "Bosnia ja Hertsegoviina konverteeritav mark",
    "BAN" to "Bosnia ja Hertsegoviina uus dinaar (1994–1997)",
    "BBD" to "Barbadose dollar",
    "BDT" to "Bangladeshi taka",
    "BEC" to "Belgia konverteeritav frank",
    "BEF" to "Belgia frank",
    "BEL" to "Belgia arveldusfrank",
    "BGL" to "Bulgaaria püsiv leev",
    "BGN" to "Bulgaaria leev",
    "BGO" to "Bulgaaria leev (1879–1952)",
    "BHD" to "Bahreini dinaar",
    "BIF" to "Burundi frank",
    "BMD" to "Bermuda dollar",
    "BND" to "Brunei dollar",
    "BOB" to "Boliivia boliviaano",
    "BOL" to "Boliivia boliviaano (1863–1963)",
    "BOP" to "Boliivia peeso",
    "BRB" to "Brasiilia uus kruseiro (1967–1986)",
    "BRC" to "Brasiilia krusado",
    "BRE" to "Brasiilia kruseiro (1990–1993)",
    "BRL" to "Brasiilia reaal",
    "BRR" to "Brasiilia kruseiro (1993–1994)",
    "BRZ" to "Brasiilia kruseiro (1942–1967)",
    "BSD" to "Bahama dollar",
    "BTN" to "Bhutani ngultrum",
    "BUK" to "Birma kjatt",
    "BWP" to "Botswana pula",
    "BYB" to "Valgevene uus rubla (1994–1999)",
    "BYN" to "Valgevene rubla",
    "BYR" to "Valgevene rubla (2000–2016)",
    "BZD" to "Belize’i dollar",
    "CAD" to "Kanada dollar",
    "CDF" to "Kongo frank",
    "CHF" to "Šveitsi frank",
    "CLE" to "Tšiili eskuudo",
    "CLP" to "Tšiili peeso",
    "CNH" to "Hiina jüaan (välismaine turg)",
    "CNY" to "Hiina jüaan",
    "COP" to "Colombia peeso",
    "CRC" to "Costa Rica koloon",
    "CSD" to "Serbia dinaar (2002–2006)",
    "CSK" to "Tšehhoslovakkia kõva kroon",
    "CUC" to "Kuuba konverteeritav peeso",
    "CUP" to "Kuuba peeso",
    "CVE" to "Cabo Verde eskuudo",
    "CYP" to "Küprose nael",
    "CZK" to "Tšehhi kroon",
    "DDM" to "Ida-Saksa mark",
    "DEM" to "Saksa mark",
    "DJF" to "Djibouti frank",
    "DKK" to "Taani kroon",
    "DOP" to "Dominikaani peeso",
    "DZD" to "Alžeeria dinaar",
    "ECS" to "Ecuadori sukre",
    "EEK" to "Eesti kroon",
    "EGP" to "Egiptuse nael",
    "ERN" to "Eritrea nakfa",
    "ESP" to "Hispaania peseeta",
    "ETB" to "Etioopia birr",
    "EUR" to "euro",
    "FIM" to "Soome mark",
    "FJD" to "Fidži dollar",
    "FKP" to "Falklandi saarte nael",
    "FRF" to "Prantsuse frank",
    "GBP" to "Suurbritannia naelsterling",
    "GEL" to "Gruusia lari",
    "GHC" to "Ghana sedi (1979–2007)",
    "GHS" to "Ghana sedi",
    "GIP" to "Gibraltari nael",
    "GMD" to "Gambia dalasi",
    "GNF" to "Guinea frank",
    "GNS" to "Guinea syli",
    "GRD" to "Kreeka drahm",
    "GTQ" to "Guatemala ketsaal",
    "GWE" to "Portugali Guinea eskuudo",
    "GWP" to "Guinea-Bissau peeso",
    "GYD" to "Guyana dollar",
    "HKD" to "Hongkongi dollar",
    "HNL" to "Hondurase lempiira",
    "HRD" to "Horvaatia dinaar",
    "HRK" to "Horvaatia kuna",
    "HTG" to "Haiti gurd",
    "HUF" to "Ungari forint",
    "IDR" to "Indoneesia ruupia",
    "IEP" to "Iiri nael",
    "ILP" to "Iisraeli nael",
    "ILR" to "Iisraeli seekel (1980–1985)",
    "ILS" to "Iisraeli uus seekel",
    "INR" to "India ruupia",
    "IQD" to "Iraagi dinaar",
    "IRR" to "Iraani riaal",
    "ISJ" to "Islandi kroon (1918–1981)",
    "ISK" to "Islandi kroon",
    "ITL" to "Itaalia liir",
    "JMD" to "Jamaica dollar",
    "JOD" to "Jordaania dinaar",
    "JPY" to "Jaapani jeen",
    "KES" to "Keenia šilling",
    "KGS" to "Kõrgõzstani somm",
    "KHR" to "Kambodža riaal",
    "KMF" to "Komoori frank",
    "KPW" to "Põhja-Korea vonn",
    "KRO" to "Lõuna-Korea vonn (1945–1953)",
    "KRW" to "Lõuna-Korea vonn",
    "KWD" to "Kuveidi dinaar",
    "KYD" to "Kaimanisaarte dollar",
    "KZT" to "Kasahstani tenge",
    "LAK" to "Laose kiip",
    "LBP" to "Liibanoni nael",
    "LKR" to "Sri Lanka ruupia",
    "LRD" to "Libeeria dollar",
    "LSL" to "Lesotho loti",
    "LTL" to "Leedu litt",
    "LUC" to "Luksemburgi konverteeritav frank",
    "LUF" to "Luksemburgi frank",
    "LVL" to "Läti latt",
    "LVR" to "Läti rubla",
    "LYD" to "Liibüa dinaar",
    "MAD" to "Maroko dirhem",
    "MAF" to "Maroko frank",
    "MCF" to "Monaco frank",
    "MDL" to "Moldova leu",
    "MGA" to "Madagaskari ariari",
    "MGF" to "Madagaskari frank",
    "MKD" to "Makedoonia dinaar",
    "MKN" to "Makedoonia dinaar (1992–1993)",
    "MLF" to "Mali frank",
    "MMK" to "Myanmari kjatt",
    "MNT" to "Mongoolia tugrik",
    "MOP" to "Macau pataaka",
    "MRO" to "Mauritaania ugia (1973–2017)",
    "MRU" to "Mauritaania ugia",
    "MTL" to "Malta liir",
    "MTP" to "Malta nael",
    "MUR" to "Mauritiuse ruupia",
    "MVP" to "Maldiivi ruupia (1947–1981)",
    "MVR" to "Maldiivi ruupia",
    "MWK" to "Malawi kvatša",
    "MXN" to "Mehhiko peeso",
    "MXP" to "Mehhiko peeso (1861–1992)",
    "MYR" to "Malaisia ringgit",
    "MZE" to "Mosambiigi eskuudo",
    "MZM" to "Mosambiigi metikal (1980–2006)",
    "MZN" to "Mosambiigi metikal",
    "NAD" to "Namiibia dollar",
    "NGN" to "Nigeeria naira",
    "NIC" to "Nicaragua kordoba (1988–1991)",
    "NIO" to "Nicaragua kordoba",
    "NLG" to "Hollandi kulden",
    "NOK" to "Norra kroon",
    "NPR" to "Nepali ruupia",
    "NZD" to "Uus-Meremaa dollar",
    "OMR" to "Omaani riaal",
    "PAB" to "Panama balboa",
    "PEI" to "Peruu inti",
    "PEN" to "Peruu soll",
    "PES" to "Peruu soll (1863–1965)",
    "PGK" to "Paapua Uus-Guinea kina",
    "PHP" to "Filipiini peeso",
    "PKR" to "Pakistani ruupia",
    "PLN" to "Poola zlott",
    "PLZ" to "Poola zlott (1950–1995)",
    "PTE" to "Portugali eskuudo",
    "PYG" to "Paraguay guaranii",
    "QAR" to "Katari riaal",
    "RHD" to "Rodeesia dollar",
    "ROL" to "Rumeenia leu (1952–2006)",
    "RON" to "Rumeenia leu",
    "RSD" to "Serbia dinaar",
    "RUB" to "Venemaa rubla",
    "RUR" to "Venemaa rubla (1991–1998)",
    "RWF" to "Rwanda frank",
    "SAR" to "Saudi Araabia riaal",
    "SBD" to "Saalomoni Saarte dollar",
    "SCR" to "Seišelli ruupia",
    "SDD" to "Sudaani dinaar (1992–2007)",
    "SDG" to "Sudaani nael",
    "SDP" to "Sudaani nael (1957–1998)",
    "SEK" to "Rootsi kroon",
    "SGD" to "Singapuri dollar",
    "SHP" to "Saint Helena nael",
    "SIT" to "Sloveenia tolar",
    "SKK" to "Slovaki kroon",
    "SLE" to "Sierra Leone leoone",
    "SLL" to "Sierra Leone leoone (1964–2022)",
    "SOS" to "Somaalia šilling",
    "SRD" to "Suriname dollar",
    "SRG" to "Suriname kulden",
    "SSP" to "Lõuna-Sudaani nael",
    "STD" to "São Tomé ja Príncipe dobra (1977–2017)",
    "STN" to "São Tomé ja Príncipe dobra",
    "SUR" to "NSVL-i rubla",
    "SVC" to "El Salvadori koloon",
    "SYP" to "Süüria nael",
    "SZL" to "Svaasimaa lilangeni",
    "THB" to "Tai baat",
    "TJR" to "Tadžikistani rubla",
    "TJS" to "Tadžikistani somoni",
    "TMM" to "Türkmenistani manat (1993–2009)",
    "TMT" to "Türkmenistani manat",
    "TND" to "Tuneesia dinaar",
    "TOP" to "Tonga pa’anga",
    "TPE" to "Timori eskuudo",
    "TRL" to "Türgi liir (1922–2005)",
    "TRY" to "Türgi liir",
    "TTD" to "Trinidadi ja Tobago dollar",
    "TWD" to "uus Taiwani dollar",
    "TZS" to "Tansaania šilling",
    "UAH" to "Ukraina grivna",
    "UAK" to "Ukraina karbovanets",
    "UGS" to "Uganda šilling (1966–1987)",
    "UGX" to "Uganda šilling",
    "USD" to "USA dollar",
    "USN" to "USA järgmise päeva dollar",
    "USS" to "USA sama päeva dollar",
    "UYP" to "Uruguay peeso (1975–1993)",
    "UYU" to "Uruguay peeso",
    "UZS" to "Usbekistani somm",
    "VEB" to "Venezuela boliivar (1871–2008)",
    "VEF" to "Venezuela boliivar (2008–2018)",
    "VES" to "Venezuela boliivar",
    "VND" to "Vietnami dong",
    "VNN" to "Vietnami dong (1978–1985)",
    "VUV" to "Vanuatu vatu",
    "WST" to "Samoa taala",
    "XAF" to "Kesk-Aafrika CFA frank",
    "XAG" to "hõbe",
    "XAU" to "kuld",
    "XBA" to "EURCO",
    "XBB" to "Euroopa rahaühik",
    "XBC" to "Euroopa rahaline arvestusühik (XBC)",
    "XBD" to "Euroopa rahaline arvestusühik (XBD)",
    "XCD" to "Ida-Kariibi dollar",
    "XDR" to "Rahvusvahelise Valuutafondi arvestusühik",
    "XEU" to "eküü",
    "XFO" to "Prantsuse kuldfrank",
    "XFU" to "Prantsuse UIC-frank",
    "XOF" to "Lääne-Aafrika CFA frank",
    "XPD" to "pallaadium",
    "XPF" to "CFP frank",
    "XPT" to "plaatina",
    "XTS" to "vääringute testkood",
    "XXX" to "määramata rahaühik",
    "YDD" to "Jeemeni dinaar",
    "YER" to "Jeemeni riaal",
    "YUD" to "Jugoslaavia kõva dinaar (1966–1990)",
    "YUM" to "Jugoslaavia uus dinaar (1994–2002)",
    "YUN" to "Jugoslaavia konverteeritav dinaar (1990–1992)",
    "YUR" to "Jugoslaavia reformitud dinaar (1992–1993)",
    "ZAR" to "Lõuna-Aafrika rand",
    "ZMK" to "Sambia kvatša (1968–2012)",
    "ZMW" to "Sambia kvatša",
    "ZRZ" to "Sairi zaire",
    "ZWD" to "Zimbabwe dollar (1980–2008)",
    "ZWL" to "Zimbabwe dollar (2009)",
    "ZWR" to "Zimbabwe dollar (2008)",
  ) }

  val eu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "pezeta andorratarra",
    "AED" to "Arabiar Emirerri Batuetako dirhama",
    "AFA" to "afghani afgandarra (1927–2002)",
    "AFN" to "afgani afganiarra",
    "ALK" to "lek albaniarra (1946–1965)",
    "ALL" to "lek albaniarra",
    "AMD" to "dram armeniarra",
    "ANG" to "florin antillarra",
    "AOA" to "kwanza angolarra",
    "AOK" to "kwanza angolarra (1977–1991)",
    "AON" to "kwanza angolar berria (1990–2000)",
    "AOR" to "kwanza angolar birdoitua (1995–1999)",
    "ARA" to "austral argentinarra",
    "ARL" to "peso ley argentinarra (1970–1983)",
    "ARM" to "peso argentinarra (1981–1970)",
    "ARP" to "peso argentinarra (1983–1985)",
    "ARS" to "peso argentinarra",
    "ATS" to "txelin austriarra",
    "AUD" to "dolar australiarra",
    "AWG" to "florin arubarra",
    "AZM" to "manat azerbaijandarra (1993–2006)",
    "AZN" to "manat azerbaijandarra",
    "BAD" to "dinar bosnia-herzegovinarra (1992–1994)",
    "BAM" to "marko bihurgarri bosniarra",
    "BAN" to "dinar bosnia-herzegovinar berria (1994–1997)",
    "BBD" to "dolar barbadostarra",
    "BDT" to "taka bangladeshtarra",
    "BEC" to "franko belgikarra (bihurgarria)",
    "BEF" to "franko belgikarra",
    "BEL" to "franko belgikarra (finantzarioa)",
    "BGL" to "Lev bulgariar indartsua",
    "BGM" to "Lev bulgariar sozialista",
    "BGN" to "lev bulgariarra",
    "BGO" to "Lev bulgariarra (1879–1952)",
    "BHD" to "dinar bahraindarra",
    "BIF" to "franko burundiarra",
    "BMD" to "dolar bermudarra",
    "BND" to "dolar bruneitarra",
    "BOB" to "boliviano boliviarra",
    "BOL" to "boliviano boliviarra (1863–1963)",
    "BOP" to "peso boliviarra",
    "BOV" to "mvdol boliviarra",
    "BRB" to "cruzeiro brasildar berria (1967–1986)",
    "BRC" to "cruzado brasildarra (1986–1989)",
    "BRE" to "cruzeiro brasildarra (1990–1993)",
    "BRL" to "erreal brasildarra",
    "BRN" to "cruzado brasildar berria (1989–1990)",
    "BRR" to "cruzeiro brasildar berria (1993–1994)",
    "BRZ" to "cruzeiro brasildarra (1942–1967)",
    "BSD" to "dolar bahamarra",
    "BTN" to "ngultrum bhutandarra",
    "BUK" to "kyat birmaniarra",
    "BWP" to "pula botswanarra",
    "BYB" to "errublo bielorrusiarra (1994–1999)",
    "BYN" to "errublo bielorrusiarra",
    "BYR" to "Bielorrusiako errubloa (2000–2016)",
    "BZD" to "dolar belizetarra",
    "CAD" to "dolar kanadarra",
    "CDF" to "franko kongoarra",
    "CHE" to "WIR euroa",
    "CHF" to "franko suitzarra",
    "CHW" to "WIR frankoa",
    "CLE" to "ezkutu txiletarra",
    "CLF" to "kontu-unitate txiletarra (UF)",
    "CLP" to "peso txiletarra",
    "CNH" to "yuan txinatarra (itsasoz haraindikoa)",
    "CNX" to "Txinako Herri Bankuaren dolarra",
    "CNY" to "yuan txinatarra",
    "COP" to "peso kolonbiarra",
    "COU" to "erreal kolonbiarraren balio-unitatea",
    "CRC" to "colon costarricarra",
    "CSD" to "dinar serbiarra (2002–2006)",
    "CSK" to "Txekoslovakiako koroa indartsua",
    "CUC" to "peso bihurgarri kubatarra",
    "CUP" to "peso kubatarra",
    "CVE" to "ezkutu caboverdetarra",
    "CYP" to "libera zipretarra",
    "CZK" to "koroa txekiarra",
    "DDM" to "Ekialdeko Alemaniako markoa",
    "DEM" to "marko alemana",
    "DJF" to "franko djibutiarra",
    "DKK" to "koroa danimarkarra",
    "DOP" to "peso dominikarra",
    "DZD" to "dinar aljeriarra",
    "ECS" to "sukre ekuadortarra",
    "ECV" to "balio-unitate konstante ekuadortarra",
    "EEK" to "kroon estoniarra",
    "EGP" to "libera egiptoarra",
    "ERN" to "nakfa eritrearra",
    "ESA" to "pezeta espainiarra (A kontua)",
    "ESB" to "pezeta espainiarra (kontu bihurgarria)",
    "ESP" to "pezeta espainiarra",
    "ETB" to "birr etiopiarra",
    "EUR" to "euroa",
    "FIM" to "markka finlandiarra",
    "FJD" to "dolar fijiarra",
    "FKP" to "libera falklandarra",
    "FRF" to "libera frantsesa",
    "GBP" to "libera esterlina",
    "GEK" to "kupon larit georgiarra",
    "GEL" to "lari georgiarra",
    "GHC" to "cedi ghanatarra (1979–2007)",
    "GHS" to "cedi ghanatarra",
    "GIP" to "libera gibraltartarra",
    "GMD" to "dalasi gambiarra",
    "GNF" to "franko ginearra",
    "GNS" to "syli ginearra",
    "GQE" to "ekwele ekuatoreginearra",
    "GRD" to "drakma greziarra",
    "GTQ" to "ketzal guatemalarra",
    "GWE" to "Gineako ezkutu portugesa",
    "GWP" to "peso gineabissautarra",
    "GYD" to "dolar guyanarra",
    "HKD" to "dolar hongkongtarra",
    "HNL" to "lempira hodurastarra",
    "HRD" to "dinar kroaziarra",
    "HRK" to "kuna kroaziarra",
    "HTG" to "gourde haitiarra",
    "HUF" to "forint hungariarra",
    "IDR" to "errupia indonesiarra",
    "IEP" to "libera irlandarra",
    "ILP" to "libera israeldarra",
    "ILR" to "shekel israeldarra (1980–1985)",
    "ILS" to "shekel israeldar berria",
    "INR" to "errupia indiarra",
    "IQD" to "dinar irakiarra",
    "IRR" to "rial irandarra",
    "ISJ" to "koroa islandiarra (1918–1981)",
    "ISK" to "koroa islandiarra",
    "ITL" to "lira italiarra",
    "JMD" to "dolar jamaikarra",
    "JOD" to "dinar jordaniarra",
    "JPY" to "yen japoniarra",
    "KES" to "txelin kenyarra",
    "KGS" to "som kirgizistandarra",
    "KHR" to "riel kanbodiarra",
    "KMF" to "franko komoretarra",
    "KPW" to "won iparkorearra",
    "KRH" to "hwan hegokorearra (1953–1962)",
    "KRO" to "won hegokorearra (1945–1953)",
    "KRW" to "won hegokorearra",
    "KWD" to "dinar kuwaitarra",
    "KYD" to "dolar kaimandarra",
    "KZT" to "tenge kazakhstandarra",
    "LAK" to "kip laostarra",
    "LBP" to "libera libanoarra",
    "LKR" to "errupia srilankarra",
    "LRD" to "dolar liberiarra",
    "LSL" to "loti lesothoarra",
    "LTL" to "Lituaniako litasa",
    "LTT" to "Lituaniako talonasa",
    "LUC" to "Luxenburgoko franko bihurgarria",
    "LUF" to "Luxenburgoko frankoa",
    "LUL" to "Luxenburgoko finantza-frankoa",
    "LVL" to "Letoniako latsa",
    "LVR" to "Letoniako errubloa",
    "LYD" to "dinar libiarra",
    "MAD" to "dirham marokoarra",
    "MAF" to "franko marokoarra",
    "MCF" to "Monakoko frankoa",
    "MDC" to "kupoi moldaviarra",
    "MDL" to "leu moldaviarra",
    "MGA" to "ariary madagaskartarra",
    "MGF" to "franko malagasiarra",
    "MKD" to "dinar mazedoniarra",
    "MKN" to "dinar mazedoniarra (1992–1993)",
    "MLF" to "franko maliarra",
    "MMK" to "kyat myanmartarra",
    "MNT" to "tugrik mongoliarra",
    "MOP" to "pataca macauarra",
    "MRO" to "Mauritaniako ouguiya (1973–2017)",
    "MRU" to "uguiya mauritaniarra",
    "MTL" to "lira maltarra",
    "MTP" to "libera maltar",
    "MUR" to "errupia mauriziarra",
    "MVP" to "errupia maldivarra (1947–1981)",
    "MVR" to "rufiyaa maldivarra",
    "MWK" to "kwacha malawiarra",
    "MXN" to "peso mexikarra",
    "MXP" to "Zilar-peso amerikarra (1861–1992)",
    "MXV" to "Inbertsio-unitate mexikarra",
    "MYR" to "ringgit malaysiarra",
    "MZE" to "ezkutu mozambiketarra",
    "MZM" to "metikal mozambiketarra",
    "MZN" to "metical mozambiketarra",
    "NAD" to "dolar namibiarra",
    "NGN" to "naira nigeriarra",
    "NIC" to "kordoba nikaraguar (1988–1991)",
    "NIO" to "cordoba nikaraguarra",
    "NLG" to "gilder herbeheretarra",
    "NOK" to "koroa norvegiarra",
    "NPR" to "errupia nepaldarra",
    "NZD" to "dolar zeelandaberritarra",
    "OMR" to "rial omandarra",
    "PAB" to "balboa panamarra",
    "PEI" to "inti perutarra",
    "PEN" to "sol perutarra",
    "PES" to "sol perutarra (1863–1965)",
    "PGK" to "kina gineaberriarra",
    "PHP" to "peso filipinarra",
    "PKR" to "errupia pakistandarra",
    "PLN" to "zloty poloniarra",
    "PLZ" to "zloty poloniarra (1950–1995)",
    "PTE" to "ezkutu portugesa",
    "PYG" to "guarani paraguaitarra",
    "QAR" to "riyal qatartarra",
    "RHD" to "dolar rhodesiarra",
    "ROL" to "leu errumaniarra (1952–2006)",
    "RON" to "leu errumaniarra",
    "RSD" to "dinar serbiarra",
    "RUB" to "errublo errusiarra",
    "RUR" to "errublo errusiarra (1991–1998)",
    "RWF" to "franko ruandarra",
    "SAR" to "riyal saudiarabiarra",
    "SBD" to "dolar salomondarra",
    "SCR" to "errupia seychelletarra",
    "SDD" to "dinar sudandarra (1992–2007)",
    "SDG" to "libera sudandarra",
    "SDP" to "libera sudandarra (1957–1998)",
    "SEK" to "koroa suediarra",
    "SGD" to "dolar singapurtarra",
    "SHP" to "Santa Helenako libera",
    "SIT" to "tolar esloveniarra",
    "SKK" to "koroa eslovakiarra",
    "SLE" to "leone sierraleonar berria",
    "SLL" to "leone sierraleonarra",
    "SOS" to "txelin somaliarra",
    "SRD" to "dolar surinamdarra",
    "SRG" to "gilder surinamdarra",
    "SSP" to "libera hegosudandarra",
    "STD" to "Sao Tomeko eta Principeko dobra (1977–2017)",
    "STN" to "dobra saotometarra",
    "SUR" to "errublo sovietarra",
    "SVC" to "kolon salvadortarra",
    "SYP" to "libera siriarra",
    "SZL" to "lilangeni swazilandiarra",
    "THB" to "baht thailandiarra",
    "TJR" to "errublo tajikistandarra",
    "TJS" to "somoni tajikistandarra",
    "TMM" to "manat turkmenistandarra (1993–2009)",
    "TMT" to "manat turkmenistandarra",
    "TND" to "dinar tunisiarra",
    "TOP" to "paʻanga tongatarra",
    "TPE" to "ezkutu timortarra",
    "TRL" to "lira turkiarra (1922–2005)",
    "TRY" to "lira turkiarra",
    "TTD" to "dolar trinitatearra",
    "TWD" to "dolar taiwandar berria",
    "TZS" to "txelin tanzaniarra",
    "UAH" to "hryvnia ukrainarra",
    "UAK" to "karbovanets ukrainarra",
    "UGS" to "txelin ugandarra (1966–1987)",
    "UGX" to "txelin ugandarra",
    "USD" to "dolar estatubatuarra",
    "USN" to "dolar estatubatuar (Hurrengo eguna)",
    "USS" to "dolar estatubatuar (Egun berean)",
    "UYI" to "peso uruguaitarra (unitate indexatuak)",
    "UYP" to "peso uruguaitarra (1975–1993)",
    "UYU" to "peso uruguaitarra",
    "UYW" to "soldata nominalaren indize-unitate uruguaitarra",
    "UZS" to "sum uzbekistandarra",
    "VEB" to "Venezuelako bolivarra (1871–2008)",
    "VED" to "bolivar subiraua",
    "VEF" to "Venezuelako bolivarra (2008–2018)",
    "VES" to "bolivar venezuelarra",
    "VND" to "dong vietnamdarra",
    "VNN" to "dong vietnamdar (1978–1985)",
    "VUV" to "vatu vanuatuarra",
    "WST" to "tala samoarra",
    "XAF" to "Afrika erdialdeko CFA frankoa",
    "XAG" to "zilarra",
    "XAU" to "urrea",
    "XBA" to "Europako unitate konposatua",
    "XBB" to "Europako moneta-unitatea",
    "XBC" to "Europako kontu-unitatea (XBC)",
    "XBD" to "Europako kontu-unitatea (XBD)",
    "XCD" to "dolar ekikaribearra",
    "XDR" to "igorpen-eskubide berezia",
    "XEU" to "Europako dibisa-unitatea",
    "XFO" to "urrezko libera frantsesa",
    "XFU" to "UIC libera frantsesa",
    "XOF" to "Afrika mendebaldeko CFA frankoa",
    "XPD" to "paladioa",
    "XPF" to "CFP frankoa",
    "XPT" to "platinozko troy ontza",
    "XRE" to "RINET funtsak",
    "XSU" to "sucrea",
    "XTS" to "aztertzeko dibisa-unitatea",
    "XUA" to "ADB kontu-unitatea",
    "XXX" to "moneta ezezaguna",
    "YDD" to "dinar yemendarra",
    "YER" to "rial yemendarra",
    "YUD" to "dinar yugoslaviar indartsua (1966–1990)",
    "YUM" to "dinar yugoslaviar berria (1994–2002)",
    "YUN" to "dinar yugoslaviar bihurgarria (1990–1992)",
    "YUR" to "dinar yugoslaviar erreformatua (1992–1993)",
    "ZAL" to "rand hegoafrikarra (finantzarioa)",
    "ZAR" to "rand hegoafrikarra",
    "ZMK" to "Zambiako kwacha (1968–2012)",
    "ZMW" to "kwacha zambiarra",
    "ZRN" to "zaire berri zairetarra (1993–1998)",
    "ZRZ" to "zaire zairetarra (1971–1993)",
    "ZWD" to "dolar zimbabwetarra (1980–2008)",
    "ZWL" to "dolar zimbabwetarra (2009)",
    "ZWR" to "dolar zimbabwetarra (2008)",
  ) }

  val ewo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirám yá Emirá Aráb Uní",
    "AOA" to "Kwánəza yá Angolá",
    "AUD" to "Dolár yá Osətəralí",
    "BHD" to "Dinár yá Bahərɛ́n",
    "BIF" to "Fəláŋ yá Burundí",
    "BWP" to "Púlá yá Botswána",
    "CAD" to "Dolár yá Kanáda",
    "CDF" to "Fəláŋ yá Kongo",
    "CHF" to "Fəláŋ yá Suís",
    "CNY" to "Yuán Renəminəbí yá Tsainís",
    "CVE" to "Esəkúdo yá Kápə́vɛ́rə",
    "DJF" to "Fəláŋ yá dzibutí",
    "DZD" to "Dinár yá Alehérí",
    "EGP" to "Lívə́lə yá Ehíbətía",
    "ERN" to "Náfəka yá Eritelé",
    "ETB" to "Bír yá Etsiópia",
    "EUR" to "əró",
    "GBP" to "Lívə́lə Sətərəlíŋ",
    "GHC" to "Tzedí yá Ganá",
    "GMD" to "Dalasí yá Gámbía",
    "GNS" to "Síli yá Giné",
    "INR" to "Rupí yá ɛ́ndía",
    "JPY" to "Yɛ́n yá Hapɔ́n",
    "KES" to "Silíŋ yá Keniá",
    "KMF" to "Fəláŋ yá Komória",
    "LRD" to "Dolár yá Libéria",
    "LSL" to "Lotí yá Lesotó",
    "LYD" to "Dinár yá Libí",
    "MAD" to "Dirám yá Maróg",
    "MGA" to "Ariari yá Maləgás",
    "MRO" to "Ugiya yá Moritaní (1973–2017)",
    "MRU" to "Ugiya yá Moritaní",
    "MUR" to "Rupí yá Morís",
    "MWK" to "Kwatsa yá Malawí",
    "MZM" to "Metikal yá Mozambíg",
    "NAD" to "Dolár yá Namibí",
    "NGN" to "Náíra yá Nihéria",
    "RWF" to "Fəláŋ yá Ruwandá",
    "SAR" to "Riál yá Arabí Saudí",
    "SCR" to "Rupí yá Sɛsɛ́l",
    "SDG" to "Lívələ yá Sudán",
    "SDP" to "Lívələ yá Sudán (1956–2007)",
    "SHP" to "Lívələ yá Ǹfúfúb Elɛ́n",
    "SLE" to "Leóne yá Sierá-leónə",
    "SLL" to "Leóne yá Sierá-leónə (1964—2022)",
    "SOS" to "Silíŋ yá Somalí",
    "STD" to "Dóbə́ra yá Saó Tomé ai Pəlinəsípe (1977–2017)",
    "STN" to "Dóbə́ra yá Saó Tomé ai Pəlinəsípe",
    "SZL" to "Lilangeni yá Swazí",
    "TND" to "Dinár yá Tunisí",
    "TZS" to "Silíŋ yá Tanazaní",
    "UGX" to "Silíŋ yá Ugandá (1966–1987)",
    "USD" to "Dolár yá amɛ́rəkə",
    "XAF" to "Fəláŋ CFA (BEAC)",
    "XOF" to "Fəláŋ CFA (BCEAO)",
    "ZAR" to "Ránədə yá Afiríka",
    "ZMK" to "Kwatsa yá Zambí (1968–2012)",
    "ZMW" to "Kwatsa yá Zambí",
    "ZWD" to "Dolár yá Zimbabwé",
  ) }

  val fa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "پزتای آندورا",
    "AED" to "درهم امارات متحدهٔ عربی",
    "AFA" to "افغانی افغانستان (۱۹۲۷ تا ۲۰۰۲)",
    "AFN" to "افغانی افغانستان",
    "ALK" to "لک آلبانی (۱۹۴۶ تا ۱۹۶۵)",
    "ALL" to "لک آلبانی",
    "AMD" to "درام ارمنستان",
    "ANG" to "گیلدر آنتیل هلند",
    "AOA" to "کوانزای آنگولا",
    "ARM" to "پزوی آرژانتین (۱۸۸۱ تا ۱۹۷۰)",
    "ARP" to "پزوی آرژانتین (۱۹۸۳ تا ۱۹۸۵)‏",
    "ARS" to "پزوی آرژانتین",
    "ATS" to "شیلینگ اتریش",
    "AUD" to "دلار استرالیا",
    "AWG" to "فلورین آروبا",
    "AZM" to "منات جمهوری آذربایجان (۱۹۹۳ تا ۲۰۰۶)",
    "AZN" to "منات جمهوری آذربایجان",
    "BAD" to "دینار بوسنی و هرزگوین (۱۹۹۲ تا ۱۹۹۴)",
    "BAM" to "مارک تبدیل‌پذیر بوسنی و هرزگوین",
    "BBD" to "دلار باربادوس",
    "BDT" to "تاکای بنگلادش",
    "BEF" to "فرانک بلژیک",
    "BEL" to "فرانک بلژیک (مالی)",
    "BGN" to "لو بلغارستان",
    "BHD" to "دینار بحرین",
    "BIF" to "فرانک بوروندی",
    "BMD" to "دلار برمودا",
    "BND" to "دلار برونئی",
    "BOB" to "بولیویانوی بولیوی",
    "BOP" to "پزوی بولیوی",
    "BRL" to "رئال برزیل",
    "BSD" to "دلار باهاما",
    "BTN" to "انگولتروم بوتان",
    "BWP" to "پولای بوتسوانا",
    "BYB" to "روبل جدید بلاروس (۱۹۹۴ تا ۱۹۹۹)",
    "BYN" to "روبل بلاروس",
    "BYR" to "روبل بلاروسی (۲۰۱۶–۲۰۰۰)",
    "BZD" to "دلار بلیز",
    "CAD" to "دلار کانادا",
    "CDF" to "فرانک کنگو",
    "CHF" to "فرانک سوئیس",
    "CLP" to "پزوی شیلی",
    "CNH" to "یوآن چین (برون‌مرزی)",
    "CNY" to "یوآن چین",
    "COP" to "پزوی کلمبیا",
    "CRC" to "کولون کاستاریکا",
    "CSD" to "دینار صربستان (۲۰۰۲ تا ۲۰۰۶)",
    "CUC" to "پزوی تبدیل‌پذیر کوبا",
    "CUP" to "پزوی کوبا",
    "CVE" to "اسکودوی کیپ‌ورد",
    "CYP" to "پوند قبرس",
    "CZK" to "کورونای جمهوری چک",
    "DDM" to "مارک آلمان شرقی",
    "DEM" to "مارک آلمان",
    "DJF" to "فرانک جیبوتی",
    "DKK" to "کرون دانمارک",
    "DOP" to "پزوی جمهوری دومینیکن",
    "DZD" to "دینار الجزایر",
    "EEK" to "کرون استونی",
    "EGP" to "پوند مصر",
    "ERN" to "ناکفای اریتره",
    "ESP" to "پزتای اسپانیا",
    "ETB" to "بیر اتیوپی",
    "EUR" to "یورو",
    "FJD" to "دلار فیجی",
    "FKP" to "پوند جزایر فالکلند",
    "FRF" to "فرانک فرانسه",
    "GBP" to "پوند بریتانیا",
    "GEL" to "لاری گرجستان",
    "GHS" to "سدی غنا",
    "GIP" to "پوند جبل‌الطارق",
    "GMD" to "دالاسی گامبیا",
    "GNF" to "فرانک گینه",
    "GRD" to "دراخمای یونان",
    "GTQ" to "کتزال گواتمالا",
    "GWP" to "پزوی گینهٔ بیسائو",
    "GYD" to "دلار گویانا",
    "HKD" to "دلار هنگ‌کنگ",
    "HNL" to "لمپیرای هندوراس",
    "HRD" to "دینار کرواسی",
    "HRK" to "کونای کرواسی",
    "HTG" to "گورد هائیتی",
    "HUF" to "فورینت مجارستان",
    "IDR" to "روپیهٔ اندونزی",
    "IEP" to "پوند ایرلند",
    "ILP" to "پوند اسرائیل",
    "ILR" to "شقل اسرائیل (۱۹۸۰ تا ۱۹۸۵)",
    "ILS" to "شِکِل جدید اسرائیل",
    "INR" to "روپیهٔ هند",
    "IQD" to "دینار عراق",
    "IRR" to "ریال ایران",
    "ISJ" to "کرونای ایسلند (۱۹۱۸ تا ۱۹۸۱)",
    "ISK" to "کرونای ایسلند",
    "ITL" to "لیرهٔ ایتالیا",
    "JMD" to "دلار جامائیکا",
    "JOD" to "دینار اردن",
    "JPY" to "ین ژاپن",
    "KES" to "شیلینگ کنیا",
    "KGS" to "سوم قرقیزستان",
    "KHR" to "ری‌یل کامبوج",
    "KMF" to "فرانک کومورو",
    "KPW" to "وون کرهٔ شمالی",
    "KRO" to "وون کرهٔ جنوبی (۱۹۴۵ تا ۱۹۵۳)",
    "KRW" to "وون کرهٔ جنوبی",
    "KWD" to "دینار کویت",
    "KYD" to "دلار جزایر کِیمن",
    "KZT" to "تنگهٔ قزاقستان",
    "LAK" to "کیپ لائوس",
    "LBP" to "لیرهٔ لبنان",
    "LKR" to "روپیهٔ سری‌لانکا",
    "LRD" to "دلار لیبریا",
    "LSL" to "لوتی لسوتو",
    "LTL" to "لیتاس لیتوانی",
    "LTT" to "تالوناس لیتوانی",
    "LUF" to "فرانک لوکزامبورگ",
    "LUL" to "فرانک مالی لوگزامبورگ",
    "LVL" to "لاتس لتونی",
    "LVR" to "روبل لتونی",
    "LYD" to "دینار لیبی",
    "MAD" to "درهم مراکش",
    "MAF" to "فرانک مراکش",
    "MCF" to "فرانک موناکو",
    "MDL" to "لئوی مولداوی",
    "MGA" to "آریاری مالاگاسی",
    "MGF" to "فرانک ماداگاسکار",
    "MKD" to "دینار مقدونیه",
    "MKN" to "دینار مقدونیه (۱۹۹۲ تا ۱۹۹۳)",
    "MLF" to "فرانک مالی",
    "MMK" to "کیات میانمار",
    "MNT" to "توگریک مغولستان",
    "MOP" to "پاتاکای ماکائو",
    "MRO" to "اوگوئیای موریتانی (۱۹۷۳ تا ۲۰۱۷)",
    "MRU" to "اوگوئیای موریتانی",
    "MTL" to "لیرهٔ مالت",
    "MTP" to "پوند مالت",
    "MUR" to "روپیهٔ موریس",
    "MVP" to "روپیهٔ مالدیو (۱۹۴۷ تا ۱۹۸۱)",
    "MVR" to "روپیهٔ مالدیو",
    "MWK" to "کواچای مالاوی",
    "MXN" to "پزوی مکزیک",
    "MXP" to "پزوی نقرهٔ مکزیک (۱۸۶۱ تا ۱۹۹۲)",
    "MYR" to "رینگیت مالزی",
    "MZE" to "اسکودوی موزامبیک",
    "MZN" to "متیکال موزامبیک",
    "NAD" to "دلار نامیبیا",
    "NGN" to "نایرای نیجریه",
    "NIO" to "کوردوبای نیکاراگوئه",
    "NLG" to "گیلدر هلند",
    "NOK" to "کرون نروژ",
    "NPR" to "روپیهٔ نپال",
    "NZD" to "دلار زلاند نو",
    "OMR" to "ریال عمان",
    "PAB" to "بالبوای پاناما",
    "PEI" to "اینتی پرو",
    "PEN" to "سول پرو",
    "PES" to "سول پرو (۱۸۶۳ تا ۱۹۶۵)",
    "PGK" to "کینای پاپوا گینهٔ نو",
    "PHP" to "پزوی فیلیپین",
    "PKR" to "روپیهٔ پاکستان",
    "PLN" to "زلوتی لهستان",
    "PTE" to "اسکودوی پرتغال",
    "PYG" to "گوارانی پاراگوئه",
    "QAR" to "ریال قطر",
    "RHD" to "دلار رودزیا",
    "RON" to "لئوی رومانی",
    "RSD" to "دینار صربستان",
    "RUB" to "روبل روسیه",
    "RUR" to "روبل روسیه (۱۹۹۱ تا ۱۹۹۸)",
    "RWF" to "فرانک رواندا",
    "SAR" to "ریال سعودی",
    "SBD" to "دلار جزایر سلیمان",
    "SCR" to "روپیهٔ سیشل",
    "SDD" to "دینار سودان (۱۹۹۲ تا ۲۰۰۷)",
    "SDG" to "پوند سودان",
    "SEK" to "کرون سوئد",
    "SGD" to "دلار سنگاپور",
    "SHP" to "پوند سنت هلن",
    "SLE" to "لئون سیرالئون",
    "SLL" to "لئون سیرالئون - 1964-2022",
    "SOS" to "شیلینگ سومالی",
    "SRD" to "دلار سورینام",
    "SRG" to "گیلدر سورینام",
    "SSP" to "پوند سودان جنوبی",
    "STD" to "دوبرای سائوتومه و پرنسیپ (۱۹۷۷ تا ۲۰۱۷)",
    "STN" to "دوبرای سائوتومه و پرنسیپ",
    "SUR" to "روبل شوروی",
    "SYP" to "لیرهٔ سوریه",
    "SZL" to "لیلانگنی سوازیلند",
    "THB" to "بات تایلند",
    "TJR" to "روبل تاجیکستان",
    "TJS" to "سامانی تاجیکستان",
    "TMM" to "منات ترکمنستان (۱۹۹۳ تا ۲۰۰۹)",
    "TMT" to "منات ترکمنستان",
    "TND" to "دینار تونس",
    "TOP" to "پاآنگای تونگا",
    "TPE" to "اسکودوی تیمور",
    "TRL" to "لیرهٔ ترکیه (۱۹۲۲ تا ۲۰۰۵)",
    "TRY" to "لیرهٔ ترکیه",
    "TTD" to "دلار ترینیداد و توباگو",
    "TWD" to "دلار جدید تایوان",
    "TZS" to "شیلینگ تانزانیا",
    "UAH" to "هریونیای اوکراین",
    "UGS" to "شیلینگ اوگاندا (۱۹۶۶ تا ۱۹۸۷)",
    "UGX" to "شیلینگ اوگاندا",
    "USD" to "دلار آمریکا",
    "USN" to "دلار امریکا (روز بعد)",
    "USS" to "دلار امریکا (همان روز)",
    "UYP" to "پزوی اوروگوئه (۱۹۷۵ تا ۱۹۹۳)",
    "UYU" to "پزوی اوروگوئه",
    "UZS" to "سوم ازبکستان",
    "VEB" to "بولیوار ونزوئلا (۱۸۷۱ تا ۲۰۰۸)",
    "VEF" to "بولیوار ونزوئلا (۲۰۰۸ تا ۲۰۱۸)",
    "VES" to "بولیوار ونزوئلا",
    "VND" to "دانگ ویتنام",
    "VUV" to "واتوی وانوواتو",
    "WST" to "تالای ساموا",
    "XAF" to "فرانک CFA مرکز افریقا",
    "XAG" to "نقره",
    "XAU" to "طلا",
    "XCD" to "دلار شرق کارائیب",
    "XFO" to "فرانک طلای فرانسه",
    "XOF" to "فرانک CFA غرب افریقا",
    "XPD" to "پالادیم",
    "XPF" to "فرانک اقیانوسیه",
    "XPT" to "پلاتین",
    "XTS" to "ارز آزمایشی",
    "XXX" to "ارز نامشخص",
    "YDD" to "دینار یمن",
    "YER" to "ریال یمن",
    "ZAR" to "راند افریقای جنوبی",
    "ZMK" to "کواچای زامبیا (۱۹۶۸ تا ۲۰۱۲)",
    "ZMW" to "کواچای زامبیا",
    "ZWD" to "دلار زیمبابوه (۱۹۸۰ تا ۲۰۰۸)",
    "ZWL" to "دلار زیمبابوه (۲۰۰۹)",
    "ZWR" to "دلار زیمبابوه (۲۰۰۸)",
  ) }

  val fa_AF: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AUD" to "دالر آسترالیا",
    "BND" to "دالر برونی",
    "BYN" to "روبل روسیهٔ سفید",
    "BYR" to "روبل روسیهٔ سفید (۲۰۰۰–۲۰۱۶)",
    "CAD" to "دالر کانادا",
    "CHF" to "فرانک سویس",
    "DKK" to "کرون دنمارک",
    "JPY" to "ین جاپان",
    "MXN" to "پزوی مکسیکو",
    "NLG" to "گیلدر هالند",
    "NOK" to "کرون ناروی",
    "SEK" to "کرون سویدن",
    "SGD" to "دالر سینگاپور",
    "TJS" to "سامانی تاجکستان",
    "USD" to "دالر امریکا",
  ) }

  val ff: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham Emiraati Araab Dentuɗi",
    "AOA" to "Kwansaa Anngolaa",
    "AUD" to "Dolaar Ostaraalii",
    "BHD" to "Dinaar Bahrayn",
    "BIF" to "Mbuuɗu Burunndi",
    "BWP" to "Pulaa Botwanaa",
    "CAD" to "Dolaar Kandaaa",
    "CDF" to "Faraa Konngo",
    "CHF" to "Faraa Suwiis",
    "CNY" to "Yuam Siin",
    "CVE" to "Eskudoo Kap Weer",
    "DJF" to "Faraa Jibutii",
    "DZD" to "Dinaar Alaseri",
    "EGP" to "Liibar Ejipt",
    "ERN" to "Nafka Eriteree",
    "ETB" to "Biir Ecoppi",
    "EUR" to "Oroo",
    "GBP" to "Liibar Sterling",
    "GHC" to "Sedi Ganaa",
    "GMD" to "Dalasi Gammbi",
    "GNS" to "Faraa Gine",
    "INR" to "Rupii Enndo",
    "JPY" to "Yen Sapoo",
    "KES" to "Siling Keñaa",
    "KMF" to "Faraa Komoor",
    "LRD" to "Dolaar Liberiyaa",
    "LSL" to "Loti Lesotoo",
    "LYD" to "Dinaar Libi",
    "MAD" to "Diraham Maruk",
    "MGA" to "Ariyari Madagaskaar",
    "MRO" to "Ugiyya Muritani (1973–2017)",
    "MRU" to "Ugiyya Muritani",
    "MUR" to "Rupii Moriis",
    "MWK" to "Kuwacca Malaawi",
    "MZM" to "Metikal Mosammbik",
    "NAD" to "Dolaar Namibii",
    "NGN" to "Nayraa Nijeriyaa",
    "RWF" to "Faraa Ruwanndaa",
    "SAR" to "Riyaal Arabi Sawdit",
    "SCR" to "Rupii Seysel",
    "SDG" to "Liibar Sudaan",
    "SHP" to "Liibar Sent Helen",
    "SLE" to "Lewoon Seraa Liyon",
    "SLL" to "Lewoon Seraa Liyon (1964—2022)",
    "SOS" to "Siling Soomali",
    "STD" to "Dobra Sawo Tome e Prensipe (1977–2017)",
    "STN" to "Dobra Sawo Tome e Prensipe",
    "SZL" to "Lilangeni Swaasilannda",
    "TND" to "Dinaar Tunisii",
    "TZS" to "Siling Tansanii",
    "UGX" to "Siling Uganndaa",
    "USD" to "Dolaar Dowlaaji Dentuɗi",
    "XAF" to "Mbuuɗi Seefaa BEAC",
    "XOF" to "Mbuuɗu Seefaa BCEAO",
    "ZAR" to "Rannda Afrik Bŋ Worgo",
    "ZMK" to "Kuwacca Sammbi (1968–2012)",
    "ZMW" to "Kuwacca Sammbi",
    "ZWD" to "Dolaar Simbaabuwe",
  ) }

  val ff_Adlm: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "𞤁𞤭𞤪𞤸𞤢𞤥𞤵 𞤋𞤥𞤢𞥄𞤪𞤢𞤼𞤭𞤲𞤳𞤮",
    "AFA" to "𞤀𞤬𞤺𞤢𞥄𞤲 𞤀𞤬𞤺𞤢𞥄𞤲𞤭 (𞥑𞥙𞥒𞥗-𞥒𞥐𞥐𞥒)",
    "AFN" to "𞤀𞤬𞤿𞤢𞤲𞤭 𞤀𞤬𞤿𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "ALL" to "𞤂𞤫𞤳 𞤀𞤤𞤦𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "AMD" to "𞤁𞤢𞤪𞤢𞤥𞤵 𞤀𞤪𞤥𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "ANG" to "𞤊𞤵𞤤𞤮𞤪𞤭𞤲 𞤀𞤲𞤼𞤭𞤴𞤢𞤲𞤳𞤮",
    "AOA" to "𞤑𞤵𞤱𞤢𞤲𞥁𞤢 𞤀𞤲𞤺𞤮𞤤𞤢𞤲𞤳𞤮",
    "ARA" to "𞤌𞤧𞤼𞤪𞤢𞤤 𞤀𞤪𞤶𞤢𞤲𞤼𞤭𞤲𞤢𞤲𞤳𞤮",
    "ARL" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤂𞤫𞤴 𞤀𞤪𞤶𞤢𞤲𞤼𞤭𞤲𞤢𞤲𞤳𞤮 (𞥑𞥙𞥗𞥐-𞥑𞥙𞥘𞥓)",
    "ARM" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤀𞤪𞤶𞤢𞤲𞤼𞤭𞤲𞤢𞤲𞤳𞤮 (𞥑𞥘𞥘𞥑-𞥑𞥙𞥗𞥐)",
    "ARP" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤀𞤪𞤶𞤢𞤲𞤼𞤭𞤲𞤢𞤲𞤳𞤮 (𞥑𞥙𞥘𞥓-𞥑𞥙𞥘𞥕)",
    "ARS" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤀𞤪𞤶𞤢𞤲𞤼𞤭𞤲𞤢𞤲𞤳𞤮",
    "AUD" to "𞤁𞤢𞤤𞤢 𞤌𞤧𞤼𞤢𞤪𞤤𞤭𞤴𞤢𞤲𞤳𞤮",
    "AWG" to "𞤊𞤵𞤤𞤮𞤪𞤭𞤲 𞤀𞤪𞤵𞤦𞤢𞤲𞤳𞤮",
    "AZN" to "𞤃𞤢𞤲𞤢𞥄𞤼𞤵 𞤀𞥁𞤫𞤪𞤦𞤢𞤴𞤶𞤢𞤲𞤳𞤮",
    "BAM" to "𞤃𞤢𞤪𞤳 𞤄𞤮𞤧𞤲𞤭𞤴𞤢-𞤖𞤫𞤪𞤶𞤫𞤺𞤮𞤾𞤭𞤲𞤳𞤮 𞤱𞤢𞤴𞤤𞤮𞤼𞤮𞥅𞤯𞤭",
    "BBD" to "𞤁𞤢𞤤𞤢 𞤄𞤢𞤪𞤦𞤢𞤣𞤭𞤴𞤢𞤲𞤳𞤮",
    "BDT" to "𞤚𞤢𞤪𞤢 𞤄𞤢𞤲𞤺𞤭𞤤𞤢𞤣𞤫𞥅𞤧𞤭𞤲𞤳𞤮",
    "BGN" to "𞤂𞤫𞥅𞤾 𞤄𞤭𞤤𞤺𞤢𞤪𞤭𞤲𞤳𞤮",
    "BHD" to "𞤁𞤭𞤲𞤢𞥄𞤪 𞤄𞤢𞤸𞤢𞤪𞤢𞥄𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "BIF" to "𞤊𞤢𞤪𞤢𞤲 𞤄𞤵𞤪𞤵𞤲𞤣𞤭𞤲𞤳𞤮",
    "BMD" to "𞤁𞤢𞤤𞤢 𞤄𞤵𞤪𞤥𞤵𞤣𞤢𞤲𞤳𞤮",
    "BND" to "𞤁𞤢𞤤𞤢 𞤄𞤵𞤪𞤲𞤫𞤴𞤢𞤲𞤳𞤮",
    "BOB" to "𞤄𞤮𞤤𞤭𞤾𞤭𞤴𞤢𞤲𞤮 𞤄𞤮𞤤𞤭𞤾𞤭𞤴𞤢𞤲𞤳𞤮",
    "BOL" to "𞤄𞤮𞤤𞤭𞤾𞤭𞤴𞤢𞤲𞤮 𞤄𞤮𞤤𞤭𞤾𞤭𞤴𞤢𞤲𞤳𞤮 (𞥑𞥘𞥖𞥓-𞥑𞥙𞥖𞥓)",
    "BOP" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤄𞤮𞤤𞤭𞤾𞤭𞤴𞤢𞤲𞤳𞤮",
    "BOV" to "𞤃𞤾𞤣𞤮𞤤 𞤄𞤮𞤤𞤭𞤾𞤭𞤴𞤢𞤲𞤳𞤮",
    "BRB" to "𞤑𞤫𞤪𞤮𞤧𞤫𞤪𞤮 𞤄𞤪𞤢𞤧𞤭𞤤𞤴𞤢𞤲𞤳𞤮 𞤑𞤫𞤧𞤮 (𞥑𞥙𞥖𞥗-𞥑𞥙𞥘𞥖)",
    "BRC" to "𞤑𞤵𞤪𞥁𞤢𞤣𞤮𞥅 𞤄𞤪𞤢𞤧𞤭𞤤𞤴𞤢𞤲𞤳𞤮 (𞥑𞥙𞥘𞥖-𞥑𞥙𞥘𞥙)",
    "BRE" to "𞤑𞤵𞤪𞥁𞤫𞤴𞤪𞤮 𞤄𞤪𞤢𞤧𞤭𞤤𞤴𞤢𞤲𞤳𞤮 (𞥑𞥙𞥙𞥐-𞥑𞥙𞥙𞥓)",
    "BRL" to "𞤈𞤭𞤴𞤢𞤤 𞤄𞤪𞤢𞤧𞤭𞤤𞤴𞤢𞤲𞤳𞤮",
    "BRN" to "𞤑𞤵𞤪𞥁𞤢𞤣𞤮𞥅 𞤄𞤪𞤢𞤧𞤭𞤤𞤴𞤢𞤲𞤳𞤮 (𞥑𞥙𞥘𞥙-𞥑𞥙𞥙𞥐)",
    "BRR" to "𞤑𞤵𞤪𞥁𞤫𞤴𞤪𞤮 𞤄𞤪𞤢𞤧𞤭𞤤𞤴𞤢𞤲𞤳𞤮 (𞥑𞥙𞥙𞥓-𞥑𞥙𞥙𞥔)",
    "BRZ" to "𞤑𞤵𞤪𞥁𞤫𞤴𞤪𞤮 𞤄𞤪𞤢𞤧𞤭𞤤𞤴𞤢𞤲𞤳𞤮 (𞥑𞥙𞥔𞥒-𞥑𞥙𞥖𞥗)",
    "BSD" to "𞤁𞤢𞤤𞤢 𞤄𞤢𞤸𞤢𞤥𞤭𞤴𞤢𞤲𞤳𞤮",
    "BTN" to "𞤐𞤘𞤵𞤤𞤼𞤵𞤪𞤵𞤥𞤵 𞤄𞤵𞤼𞤢𞤲𞤭𞤲𞤳𞤮",
    "BWP" to "𞤆𞤵𞤤𞤢 𞤄𞤮𞤼𞤵𞤧𞤱𞤢𞤲𞤢𞤲𞤳𞤮",
    "BYN" to "𞤈𞤵𞥅𞤦𞤮𞤤 𞤄𞤫𞤤𞤢𞤪𞤭𞥅𞤧𞤭𞤴𞤢𞤲𞤳𞤮",
    "BZD" to "𞤁𞤢𞤤𞤢 𞤄𞤫𞤤𞤭𞥅𞤧𞤴𞤢𞤲𞤳𞤮",
    "CAD" to "𞤁𞤢𞤤𞤢 𞤑𞤢𞤲𞤢𞤣𞤭𞤴𞤢𞤲𞤳𞤮",
    "CDF" to "𞤊𞤢𞤪𞤢𞤲 𞤑𞤮𞤲𞤺𞤮𞤲𞤳𞤮",
    "CHF" to "𞤊𞤢𞤪𞤢𞤲 𞤅𞤵𞤱𞤭𞥅𞤧",
    "CLE" to "𞤉𞤧𞤳𞤵𞤣𞤮𞥅 𞤕𞤭𞤤𞤫𞥊𞤴𞤢𞤲𞤳𞤮",
    "CLF" to "𞤅𞤢𞤤𞤲𞤣𞤵 𞤂𞤭𞤥𞤮𞥅𞤪𞤫 𞤕𞤭𞤤𞤫𞥊𞤴𞤢𞤲𞤳𞤮",
    "CLP" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤕𞤭𞤤𞤫𞥊𞤴𞤢𞤲𞤳𞤮",
    "CNH" to "𞤒𞤵𞤱𞤢𞤲 𞤕𞤢𞤴𞤲𞤭𞤲𞤳𞤮 (𞤺𞤢𞥄𞤲𞤭𞤲𞤳𞤮)",
    "CNY" to "𞤒𞤵𞤱𞤢𞥄𞤲 𞤕𞤢𞤴𞤲𞤭𞤲𞤳𞤮",
    "COP" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤑𞤮𞤤𞤮𞤥𞤦𞤭𞤴𞤢𞤲𞤳𞤮",
    "COU" to "𞤅𞤢𞤤𞤲𞤣𞤵 𞤔𞤢𞤪𞤮 𞤳𞤮𞤤𞤮𞤥𞤦𞤭𞤴𞤢𞤲𞤳𞤮",
    "CRC" to "𞤑𞤮𞤤𞤮𞥅𞤲 𞤑𞤮𞤧𞤼𞤢𞤪𞤭𞤴𞤢𞤲𞤳𞤮",
    "CUC" to "𞤆𞤫𞤧𞤮 𞤑𞤵𞤦𞤢𞤲𞤳𞤮 𞤏𞤢𞤴𞤤𞤮𞤼𞤮𞥅𞤲𞥋𞤺𞤮",
    "CUP" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤑𞤵𞤦𞤢𞤲𞤳𞤮",
    "CVE" to "𞤉𞤧𞤳𞤵𞤣𞤮 𞤑𞤢𞤨-𞤜𞤫𞥅𞤪𞤣𞤢𞤲𞤳𞤮",
    "CZK" to "𞤑𞤮𞤪𞤵𞤲𞤢 𞤕𞤫𞥅𞤳𞤭𞤲𞤳𞤮",
    "DJF" to "𞤊𞤢𞤪𞤢𞤲 𞤔𞤭𞤦𞤵𞤼𞤭𞤲𞤳𞤮",
    "DKK" to "𞤑𞤮𞤪𞤲𞤫 𞤁𞤢𞤲𞤭𞥅𞤧𞤭𞤲𞤳𞤮",
    "DOP" to "𞤆𞤫𞤧𞤮 𞤁𞤮𞤥𞤭𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "DZD" to "𞤁𞤭𞤲𞤢𞥄𞤪 𞤀𞤤𞤶𞤢𞤪𞤭𞤲𞤳𞤮",
    "ECS" to "𞤅𞤵𞥅𞤳𞤵𞤪𞤫𞥊𞥅 𞤉𞤳𞤵𞤱𞤢𞤣𞤮𞥅𞤪𞤴𞤢𞤲𞤳𞤮",
    "ECV" to "𞤅𞤢𞤤𞤲𞤣𞤵 𞤔𞤮𞤪𞤮 𞤉𞤳𞤵𞤱𞤢𞤣𞤮𞥅𞤪𞤴𞤢𞤲𞤳𞤮 𞤚𞤢𞤦𞤭𞤼𞤵𞤲𞥋𞤺𞤮",
    "EGP" to "𞤆𞤢𞤱𞤲𞤣𞤵 𞤃𞤭𞤧𞤭𞤪𞤢𞤲𞤳𞤮",
    "ERN" to "𞤐𞤢𞤳𞤬𞤢 𞤉𞤪𞤭𞤼𞤫𞤪𞤭𞤲𞤳𞤮",
    "ETB" to "𞤄𞤭𞤪 𞤖𞤢𞤦𞤢𞤧𞤭𞤲𞤳𞤮",
    "EUR" to "𞤒𞤵𞤪𞤮𞥅",
    "FJD" to "𞤁𞤢𞤤𞤢 𞤊𞤭𞤶𞤭𞤴𞤢𞤲𞤳𞤮",
    "FKP" to "𞤆𞤢𞤱𞤲𞤣𞤵 𞤅𞤵𞤪𞤭𞥅𞤶𞤫 𞤊𞤢𞤤𞤳𞤵𞤤𞤢𞤲𞤣𞤭𞤳𞤮",
    "GBP" to "𞤆𞤢𞤱𞤲𞤣𞤵 𞤄𞤪𞤭𞤼𞤭𞥅𞤧𞤭𞤲𞤳𞤮",
    "GEL" to "𞤂𞤢𞥄𞤪𞤭 𞤔𞤮𞤪𞤶𞤭𞤴𞤢𞤲𞤳𞤮",
    "GHS" to "𞤅𞤭𞤣𞤭 𞤘𞤢𞤲𞤢𞤲𞤳𞤮",
    "GIP" to "𞤆𞤢𞤱𞤲𞥋𞤣𞤵 𞤔𞤭𞤤𞤦𞤪𞤢𞤤𞤼𞤢𞤪",
    "GMD" to "𞤁𞤢𞤤𞤢𞤧𞤭 𞤘𞤢𞤥𞤦𞤭𞤲𞤳𞤮",
    "GNF" to "𞤊𞤢𞤪𞤢𞤲 𞤘𞤭𞤲𞤫𞤲𞤳𞤮",
    "GTQ" to "𞤑𞤫𞤼𞤵𞥁𞤢𞤤 𞤘𞤵𞤱𞤢𞤼𞤫𞤥𞤢𞤤𞤢𞤲𞤳𞤮",
    "GYD" to "𞤁𞤢𞤤𞤢 𞤘𞤵𞤴𞤢𞤲𞤫𞥅𞤧𞤭𞤲𞤳𞤮",
    "HKD" to "𞤁𞤢𞤤𞤢 𞤖𞤮𞤲𞤳𞤮𞤲",
    "HNL" to "𞤂𞤫𞤥𞤨𞤭𞤪𞤢 𞤖𞤮𞤲𞤣𞤵𞤪𞤢𞤲𞤳𞤮",
    "HRK" to "𞤑𞤵𞤲𞤢 𞤑𞤵𞤪𞤢𞥄𞤧𞤭𞤴𞤢𞤲𞤳𞤮",
    "HTG" to "𞤘𞤵𞥅𞤪𞤣𞤫 𞤖𞤢𞤴𞤼𞤭𞤴𞤢𞤲𞤳𞤮",
    "HUF" to "𞤊𞤮𞤪𞤭𞤲𞤼𞤵 𞤖𞤵𞤲𞤺𞤢𞤪𞤭𞤴𞤢𞤲𞤳𞤮",
    "IDR" to "𞤈𞤵𞤨𞤭𞤴𞤢 𞤋𞤲𞤣𞤮𞤲𞤫𞤧𞤭𞤴𞤢𞤲𞤳𞤮",
    "ILS" to "𞤡𞤫𞤳𞤫𞤤 𞤋𞤧𞤪𞤢𞥄𞤤𞤭𞤴𞤢𞤲𞤳𞤮",
    "INR" to "𞤈𞤵𞥅𞤨𞤭𞥅 𞤖𞤭𞤲𞤣𞤭𞤧𞤼𞤢𞤲𞤳𞤮",
    "IQD" to "𞤁𞤭𞤲𞤢𞥄𞤪 𞤋𞤪𞤢𞥄𞤳𞤭𞤴𞤢𞤲𞤳𞤮",
    "IRR" to "𞤈𞤭𞤴𞤢𞥄𞤤 𞤋𞤪𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "ISK" to "𞤑𞤮𞤪𞤮𞤲𞤢 𞤀𞤴𞤧𞤭𞤤𞤢𞤲𞤣𞤭𞤲𞤳𞤮",
    "JMD" to "𞤁𞤢𞤤𞤢 𞤔𞤢𞤥𞤢𞤴𞤭𞤲𞤳𞤮",
    "JOD" to "𞤁𞤭𞤲𞤢𞥄𞤪 𞤔𞤮𞤪𞤣𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "JPY" to "𞤒𞤫𞤲 𞤔𞤢𞤨𞤢𞤲𞤳𞤮",
    "KES" to "𞤅𞤭𞤤𞤭𞤲 𞤑𞤫𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "KGS" to "𞤅𞤮𞤥𞤵 𞤑𞤭𞤪𞤺𞤭𞤧𞤼𞤢𞤲𞤭𞤲𞤳𞤮",
    "KHR" to "𞤈𞤭𞤴𞤢𞤤 𞤑𞤢𞤥𞤦𞤮𞤣𞤭𞤴𞤢𞤲𞤳𞤮",
    "KMF" to "𞤊𞤢𞤪𞤢𞤲 𞤑𞤮𞤥𞤮𞤪𞤭𞤲𞤳𞤮",
    "KPW" to "𞤏𞤮𞤲 𞤁𞤮𞤱𞤣𞤮𞤱𞤪𞤭 𞤑𞤮𞥅𞤪𞤫𞤴𞤢𞤲𞤳𞤮",
    "KRW" to "𞤱𞤮𞤲 𞤂𞤫𞤴𞤤𞤫𞤴𞤪𞤭 𞤑𞤮𞥅𞤪𞤫𞤴𞤢𞤲𞤳𞤮",
    "KWD" to "𞤁𞤋𞤲𞤢𞥄𞤪 𞤑𞤵𞤱𞤢𞤴𞤼𞤭𞤴𞤢𞤲𞤳𞤮",
    "KYD" to "𞤁𞤢𞤤𞤢 𞤅𞤵𞤪𞤭𞥅𞤶𞤫 𞤑𞤢𞤴𞤥𞤢𞥄𞤲",
    "KZT" to "𞤚𞤫𞤲𞤺𞤫 𞤑𞤢𞥁𞤢𞤳𞤭𞤧𞤼𞤢𞤲𞤭𞤲𞤳𞤮",
    "LAK" to "𞤑𞤭𞤨𞤵 𞤂𞤢𞤱𞤮𞥅𞤧𞤭𞤴𞤢𞤲𞤳𞤮",
    "LBP" to "𞤆𞤢𞤱𞤲𞥋𞤣𞤵 𞤂𞤭𞤦𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "LKR" to "𞤈𞤵𞥅𞤨𞤭𞥅 𞤅𞤭𞤪𞤭-𞤂𞤢𞤲𞤳𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "LRD" to "𞤁𞤢𞤤𞤢 𞤂𞤭𞤦𞤫𞤪𞤭𞤴𞤢𞤲𞤳𞤮",
    "LYD" to "𞤁𞤭𞤲𞤢𞥄𞤪 𞤂𞤭𞤦𞤭𞤴𞤢𞤲𞤳𞤮",
    "MAD" to "𞤁𞤭𞤪𞤸𞤢𞤥𞤵 𞤃𞤮𞤪𞤮𞤳𞤢𞤲𞤳𞤮",
    "MDL" to "𞤂𞤭𞥅𞤱𞤮 𞤃𞤮𞤤𞤣𞤮𞤾𞤢𞤲𞤳𞤮",
    "MGA" to "𞤀𞤪𞤭𞤴𞤢𞤪𞤭 𞤃𞤢𞤤𞤺𞤢𞤲𞤭𞤲𞤳𞤮",
    "MKD" to "𞤁𞤭𞤲𞤢𞥄𞤪 𞤃𞤢𞤧𞤫𞤣𞤮𞤲𞤭𞤲𞤳𞤮",
    "MMK" to "𞤑𞤭𞤴𞤢𞤼𞤵 𞤃𞤭𞤴𞤢𞤥𞤢𞤪𞤭𞤲𞤳𞤮",
    "MNT" to "𞤚𞤵𞤺𞤵𞤪𞤭𞤳𞤵 𞤃𞤮𞤲𞤺𞤮𞤤𞤭𞤴𞤢𞤲𞤳𞤮",
    "MOP" to "𞤆𞤢𞤼𞤢𞤳𞤢 𞤃𞤢𞤳𞤢𞤱𞤮𞤴𞤢𞤲𞤳𞤮",
    "MRO" to "𞤓𞤺𞤭𞤴𞤢 𞤃𞤮𞤪𞤭𞤼𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮 (𞥑𞥙𞥗𞥓 - 𞥒𞥐𞥑𞥗)",
    "MRU" to "𞤓𞤺𞤭𞤴𞤢 𞤃𞤮𞤪𞤭𞤼𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "MUR" to "𞤈𞤵𞤨𞤭𞥅 𞤃𞤮𞤪𞤭𞤧𞤭𞤴𞤢𞤲𞤳𞤮",
    "MVP" to "𞤈𞤵𞥅𞤨𞤭𞥅 𞤃𞤢𞤤𞤣𞤭𞥅𞤬 (𞥑𞥙𞥔𞥗-𞥑𞥙𞥘𞥑)",
    "MVR" to "𞤈𞤵𞤬𞤭𞤴𞤢𞥄 𞤃𞤢𞤤𞤣𞤭𞤾𞤭𞤴𞤢𞤲𞤳𞤮",
    "MWK" to "𞤑𞤢𞤱𞤢𞤷𞤢 𞤃𞤢𞤤𞤢𞤱𞤭𞤲𞤳𞤮",
    "MXN" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤃𞤫𞤳𞤧𞤭𞤳𞤮𞤴𞤢𞤲𞤳𞤮",
    "MXP" to "𞤑𞤢𞥄𞤤𞤭𞤧𞤫 𞤆𞤫𞥅𞤧𞤮𞥅 𞤃𞤫𞤳𞤧𞤭𞤳𞤮𞤴𞤢𞤲𞤳𞤮 (𞥑𞥘𞥖𞥑-𞥑𞥙𞥙𞥒)",
    "MXV" to "𞤅𞤢𞤤𞤲𞤣𞤵 𞤊𞤭𞤤𞤮 𞤃𞤫𞤳𞤧𞤭𞤳𞤮𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤵",
    "MYR" to "𞤈𞤭𞤲𞤺𞤵𞤼𞤵 𞤃𞤢𞤤𞤫𞥅𞤧𞤭𞤴𞤢𞤲𞤳𞤮",
    "MZN" to "𞤃𞤫𞤼𞤭𞤳𞤮𞤤 𞤃𞤮𞥁𞤢𞤥𞤦𞤭𞤲𞤳𞤮",
    "NAD" to "𞤁𞤢𞤤𞤢 𞤐𞤢𞤥𞤭𞤥𞤦𞤭𞤲𞤳𞤮",
    "NGN" to "𞤐𞤢𞤴𞤪𞤢 𞤐𞤢𞤶𞤭𞤪𞤢𞤴𞤢𞤲𞤳𞤮",
    "NIC" to "𞤑𞤮𞥅𞤪𞤣𞤮𞤦𞤢 𞤐𞤭𞤳𞤢𞤪𞤢𞤺𞤵𞤱𞤢𞤲𞤳𞤮 (𞥑𞥙𞥘𞥘-𞥑𞥙𞥙𞥑)",
    "NIO" to "𞤑𞤮𞥅𞤪𞤣𞤮𞤦𞤢 𞤐𞤭𞤳𞤢𞤪𞤢𞤺𞤵𞤱𞤢𞤲𞤳𞤮",
    "NOK" to "𞤑𞤪𞤮𞤲𞤫 𞤐𞤮𞤪𞤱𞤫𞤶𞤭𞤲𞤳𞤮",
    "NPR" to "𞤈𞤵𞥅𞤨𞤭𞥅 𞤐𞤫𞤨𞤢𞤤𞤭𞤴𞤢𞤲𞤳𞤮",
    "NZD" to "𞤁𞤢𞤤𞤢 𞤐𞤫𞤱 𞤟𞤫𞤤𞤢𞤲𞤣",
    "OMR" to "𞤈𞤭𞤴𞤢𞥄𞤤 𞤌𞤥𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "PAB" to "𞤄𞤢𞤤𞤦𞤮𞤱𞤢 𞤆𞤢𞤲𞤢𞤥𞤢𞤴𞤢𞤲𞤳𞤮",
    "PEI" to "𞤋𞤲𞤼𞤭 𞤨𞤫𞤪𞤵𞤴𞤢𞤲𞤳𞤮",
    "PEN" to "𞤅𞤮𞤤 𞤆𞤫𞤪𞤵𞤲𞤳𞤮",
    "PES" to "𞤅𞤮𞤤 𞤆𞤫𞤪𞤵𞤴𞤢𞤲𞤳𞤮 (𞥑𞥘𞥖𞥓-𞥑𞥙𞥖𞥕)",
    "PGK" to "𞤑𞤭𞤲𞤢 𞤆𞤢𞤨𞤵𞤱𞤢 𞤐𞤫𞤱-𞤘𞤭𞤲𞤫𞤲𞤳𞤮",
    "PHP" to "𞤆𞤭𞤧𞤮 𞤊𞤭𞤤𞤭𞤨𞥆𞤭𞤲𞤳𞤮",
    "PKR" to "𞤈𞤵𞥅𞤨𞤭𞥅 𞤆𞤢𞤳𞤭𞤧𞤼𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮",
    "PLN" to "𞤔𞤢𞤤𞤮𞤼𞤵 𞤆𞤮𞤤𞤭𞥅𞤧𞤭𞤲𞤳𞤮",
    "PYG" to "𞤘𞤵𞤱𞤢𞤪𞤢𞤲𞤭 𞤆𞤢𞥄𞤪𞤢𞤺𞤵𞤴𞤫𞤲𞤳𞤮",
    "QAR" to "𞤈𞤭𞤴𞤢𞥄𞤤 𞤗𞤢𞤼𞤢𞤪𞤭𞤴𞤢𞤲𞤳𞤮",
    "RON" to "𞤂𞤫𞤱𞤵 𞤈𞤮𞤥𞤢𞤲𞤭𞤲𞤳𞤮",
    "RSD" to "𞤁𞤭𞤲𞤢𞥄𞤪 𞤅𞤫𞤪𞤦𞤭𞤲𞤳𞤮",
    "RUB" to "𞤈𞤵𞥅𞤦𞤮𞤤 𞤈𞤭𞥅𞤧𞤭𞤲𞤳𞤮",
    "RWF" to "𞤊𞤢𞤪𞤢𞤲 𞤈𞤵𞤱𞤢𞤲𞤣𞤢𞤲𞤳𞤮",
    "SAR" to "𞤈𞤭𞤴𞤢𞤤 𞤅𞤢𞤵𞥅𞤣𞤭𞤴𞤢𞤲𞤳𞤮",
    "SBD" to "𞤁𞤢𞤤𞤢 𞤕𞤵𞤪𞤭𞥅𞤶𞤫 𞤅𞤵𞤤𞤢𞤴𞤥𞤢𞥄𞤲",
    "SCR" to "𞤈𞤵𞤨𞤭𞥅 𞤅𞤫𞤴𞤧𞤭𞤤𞤭𞤲𞤳𞤮",
    "SDG" to "𞤆𞤢𞤱𞤲𞤣𞤵 𞤅𞤵𞤣𞤢𞤲𞤳𞤮",
    "SEK" to "𞤑𞤪𞤮𞤲𞤢 𞤅𞤵𞤱𞤫𞤣𞤭𞤲𞤳𞤮",
    "SGD" to "𞤁𞤢𞤤𞤢 𞤅𞤭𞤲𞤺𞤢𞤨𞤮𞤪𞤫𞤲𞤳𞤮",
    "SHP" to "𞤆𞤢𞤱𞤲𞤣𞤵 𞤅𞤫𞤲-𞤖𞤫𞤤𞤫𞤲𞤢",
    "SLE" to "𞤂𞤫𞤴𞤮𞤲 𞤅𞤫𞤪𞤢𞤤𞤭𞤴𞤢𞤲𞤳𞤮",
    "SLL" to "𞤂𞤫𞤴𞤮𞤲 𞤅𞤫𞤪𞤢𞤤𞤭𞤴𞤢𞤲𞤳𞤮 - 1964-2022",
    "SOS" to "𞤅𞤭𞤤𞤭𞤲 𞤅𞤮𞤥𞤢𞤤𞤭𞤲𞤳𞤮",
    "SRD" to "𞤁𞤢𞤤𞤢 𞤅𞤵𞤪𞤵𞤲𞤢𞤥𞤭𞤲𞤳𞤮",
    "SRG" to "𞤘𞤭𞤤𞤣𞤮𞥅 𞤅𞤵𞤪𞤵𞤲𞤢𞤥𞤭𞤲𞤳𞤮",
    "SSP" to "𞤆𞤢𞤱𞤲𞤣𞤵 𞤂𞤫𞤴𞤤𞤫𞤴𞤪𞤭 𞤅𞤵𞤣𞤢𞤲𞤭𞤲𞤳𞤮",
    "STN" to "𞤁𞤮𞤦𞤢𞤪𞤢 𞤅𞤢𞤱𞤮-𞤚𞤮𞤥𞤫 & 𞤆𞤫𞤪𞤫𞤲𞤧𞤭𞤨",
    "SVC" to "𞤑𞤮𞤤𞤮𞥅𞤲 𞤅𞤢𞤤𞤾𞤢𞤣𞤮𞤪𞤢𞤲𞤳𞤮",
    "SYP" to "𞤆𞤢𞤱𞤲𞥋𞤣𞤵 𞤅𞤭𞤪𞤢𞤴𞤢𞤲𞤳𞤮",
    "SZL" to "𞤂𞤭𞤤𞤢𞤲𞤺𞤫𞤲𞤭 𞤅𞤵𞤱𞤢𞤶𞤭",
    "THB" to "𞤄𞤢𞤸𞤼𞤵 𞤚𞤢𞤴𞤤𞤢𞤲𞤣𞤭𞤲𞤳𞤮",
    "TJS" to "𞤅𞤢𞤥𞤮𞥅𞤲𞤭 𞤚𞤢𞤶𞤭𞤳𞤭𞤧𞤼𞤢𞤲𞤳𞤮",
    "TMT" to "𞤃𞤢𞤲𞤢𞤼𞤵 𞤚𞤵𞤪𞤳𞤵𞤥𞤫𞤲𞤭𞤧𞤼𞤢𞤲𞤳𞤮",
    "TND" to "𞤁𞤭𞤲𞤢𞥄𞤪 𞤚𞤵𞥅𞤲𞤭𞤧𞤭𞤲𞤳𞤮",
    "TOP" to "𞤆𞤢𞤢𞤲𞤺𞤢 𞤚𞤮𞤲𞤺𞤢𞤲𞤳𞤮",
    "TRY" to "𞤂𞤭𞤪𞤢 𞤚𞤵𞤪𞤳𞤭𞤴𞤢𞤲𞤳𞤮",
    "TTD" to "𞤁𞤢𞤤𞤢 𞤚𞤭𞤪𞤲𞤭𞤣𞤢𞥄𞤣 & 𞤚𞤮𞤦𞤢𞤺𞤮",
    "TWD" to "𞤁𞤢𞤤𞤢 𞤚𞤢𞤴𞤱𞤢𞥄𞤲𞤳𞤮",
    "TZS" to "𞤅𞤭𞤤𞤭𞤲 𞤚𞤢𞤲𞥁𞤢𞤲𞤭𞤲𞤳𞤮",
    "UAH" to "𞤖𞤵𞤪𞤢𞤾𞤫𞤲𞤭𞤴𞤢 𞤒𞤵𞤳𞤫𞤪𞤫𞥅𞤲𞤭𞤲𞤳𞤮",
    "UGX" to "𞤅𞤭𞤤𞤭𞤲 𞤓𞤺𞤢𞤲𞤣𞤢𞤲𞤳𞤮",
    "USD" to "𞤁𞤢𞤤𞤢 𞤁𞤫𞤲𞤼𞤢𞤤 𞤂𞤢𞤪𞤫 𞤀𞤥𞤫𞤪𞤭𞤳",
    "USN" to "𞤣𞤢𞤤𞤢 𞤁𞤂𞤀 (𞤶𞤢𞤲𞤺𞤮 𞤥𞤵𞥅𞤯𞤵𞤲)",
    "USS" to "𞤣𞤢𞤤𞤢 𞤁𞤂𞤀 (𞤸𞤢𞤲𞤣𞤫 𞤥𞤵𞥅𞤯𞤵𞤲)",
    "UYI" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤒𞤵𞤪𞤺𞤮𞤴𞤢𞤲𞤳𞤮 (𞤕𞤢𞤤𞤯𞤭 𞤔𞤮𞥅𞤨𞤢𞥄𞤯𞤭)",
    "UYP" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤒𞤵𞤪𞤺𞤮𞤴𞤢𞤲𞤳𞤮 (𞥑𞥙𞥗𞥕-𞥑𞥙𞥙𞥓)",
    "UYU" to "𞤆𞤫𞥅𞤧𞤮𞥅 𞤒𞤵𞤪𞤺𞤮𞤴𞤢𞤲𞤳𞤮",
    "UYW" to "𞤅𞤢𞤤𞤲𞤣𞤵 𞤐𞤶𞤮𞤩𞤣𞤭 𞤒𞤵𞤪𞤺𞤮𞤴𞤢𞤲𞤳𞤮 𞤔𞤮𞥅𞤨𞤢𞥄𞤲𞤣𞤭",
    "UZS" to "𞤅𞤮𞤥𞤵 𞤓𞥁𞤦𞤫𞤳𞤭𞤧𞤼𞤢𞤲𞤳𞤮",
    "VEB" to "𞤄𞤮𞤤𞤭𞤾𞤢𞥄𞤪 𞤜𞤫𞤲𞤭𞥅𞤧𞤫𞤤𞤢𞤲𞤳𞤮 (𞥑𞥘𞥗𞥑-𞥒𞥐𞥐𞥘)",
    "VED" to "𞤄𞤮𞤤𞤭𞤾𞤢𞥄𞤪 𞤅𞤮𞤦𞤫𞥊𞤪𞤢𞤲𞤮",
    "VEF" to "𞤄𞤮𞤤𞤭𞤾𞤢𞥄𞤪 𞤜𞤫𞤲𞤭𞥅𞤧𞤫𞤤𞤢𞤲𞤳𞤮 (𞥒𞥐𞥐𞥘 - 𞥒𞥐𞥑𞥘)",
    "VES" to "𞤄𞤮𞤤𞤭𞤾𞤢𞥄𞤪 𞤜𞤫𞤲𞤭𞥅𞤧𞤫𞤤𞤢𞤲𞤳𞤮",
    "VND" to "𞤁𞤮𞤲𞤺𞤵 𞤜𞤭𞤴𞤫𞤼𞤭𞤲𞤢𞤴𞤢𞤲𞤳𞤮",
    "VUV" to "𞤜𞤢𞤼𞤵 𞤜𞤢𞤲𞤵𞤴𞤢𞤲𞤳𞤮",
    "WST" to "𞤚𞤢𞤤𞤢 𞤅𞤢𞤥𞤮𞤱𞤢𞤴𞤢𞤲𞤳𞤮",
    "XAF" to "𞤊𞤢𞤪𞤢𞤲 𞤚𞤵𞤦𞤮𞥅𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤭𞤲𞤳𞤮",
    "XCD" to "𞤁𞤢𞤤𞤢 𞤊𞤵𞤯𞤲𞤢𞥄𞤲𞥋𞤺𞤫 𞤑𞤢𞤪𞤭𞤦𞤭𞤴𞤢",
    "XOF" to "𞤊𞤢𞤪𞤢𞤲 𞤅𞤊𞤀 𞤖𞤭𞥅𞤪𞤲𞤢𞥄𞤲𞤺𞤫 𞤀𞤬𞤪𞤭𞤳𞤢",
    "XPF" to "𞤊𞤢𞤪𞤢𞤲 𞤅𞤊𞤆",
    "XXX" to "𞤐𞤄𞤵𞥅𞤯𞤭 𞤢𞤧-𞤢𞤲𞤣𞤢𞥄𞤯𞤭",
    "YER" to "𞤈𞤭𞤴𞤢𞥄𞤤 𞤒𞤫𞤥𞤫𞤲𞤭𞤲𞤳𞤮",
    "ZAR" to "𞤈𞤢𞤲𞤣𞤭 𞤂𞤫𞤴𞤤𞤫𞤴𞤪𞤭 𞤀𞤬𞤪𞤭𞤳𞤢𞤲𞤳𞤮",
    "ZMW" to "𞤑𞤢𞤱𞤢𞤧𞤢 𞤟𞤢𞤥𞤦𞤭𞤲𞤳𞤮",
  ) }

  val ff_Adlm_BF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_GM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_GW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_LR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_NG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_SL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_SN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham Emiraati Araab Dentuɗi",
    "AOA" to "Kwansaa Anngolaa",
    "AUD" to "Dolaar Ostaraalii",
    "BHD" to "Dinaar Bahrayn",
    "BIF" to "Mbuuɗu Burunndi",
    "BWP" to "Pulaa Botwanaa",
    "CAD" to "Dolaar Kandaaa",
    "CDF" to "Faraa Konngo",
    "CHF" to "Faraa Suwiis",
    "CNY" to "Yuam Siin",
    "CVE" to "Eskudoo Kap Weer",
    "DJF" to "Faraa Jibutii",
    "DZD" to "Dinaar Alaseri",
    "EGP" to "Liibar Ejipt",
    "ERN" to "Nafka Eriteree",
    "ETB" to "Biir Ecoppi",
    "EUR" to "Oroo",
    "GBP" to "Liibar Sterling",
    "GHC" to "Sedi Ganaa",
    "GMD" to "Dalasi Gammbi",
    "GNS" to "Faraa Gine",
    "INR" to "Rupii Enndo",
    "JPY" to "Yen Sapoo",
    "KES" to "Siling Keñaa",
    "KMF" to "Faraa Komoor",
    "LRD" to "Dolaar Liberiyaa",
    "LSL" to "Loti Lesotoo",
    "LYD" to "Dinaar Libi",
    "MAD" to "Diraham Maruk",
    "MGA" to "Ariyari Madagaskaar",
    "MRO" to "Ugiyya Muritani (1973–2017)",
    "MRU" to "Ugiyya Muritani",
    "MUR" to "Rupii Moriis",
    "MWK" to "Kuwacca Malaawi",
    "MZM" to "Metikal Mosammbik",
    "NAD" to "Dolaar Namibii",
    "NGN" to "Nayraa Nijeriyaa",
    "RWF" to "Faraa Ruwanndaa",
    "SAR" to "Riyaal Arabi Sawdit",
    "SCR" to "Rupii Seysel",
    "SDG" to "Liibar Sudaan",
    "SHP" to "Liibar Sent Helen",
    "SLE" to "Lewoon Seraa Liyon",
    "SLL" to "Lewoon Seraa Liyon (1964—2022)",
    "SOS" to "Siling Soomali",
    "STD" to "Dobra Sawo Tome e Prensipe (1977–2017)",
    "STN" to "Dobra Sawo Tome e Prensipe",
    "SZL" to "Lilangeni Swaasilannda",
    "TND" to "Dinaar Tunisii",
    "TZS" to "Siling Tansanii",
    "UGX" to "Siling Uganndaa",
    "USD" to "Dolaar Dowlaaji Dentuɗi",
    "XAF" to "Mbuuɗi Seefaa BEAC",
    "XOF" to "Mbuuɗu Seefaa BCEAO",
    "ZAR" to "Rannda Afrik Bŋ Worgo",
    "ZMK" to "Kuwacca Sammbi (1968–2012)",
    "ZMW" to "Kuwacca Sammbi",
    "ZWD" to "Dolaar Simbaabuwe",
  ) }

  val ff_Latn_BF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_LR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_NG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_SL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fi: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorran peseta",
    "AED" to "Arabiemiirikuntien dirhami",
    "AFA" to "Afganistanin afgaani (1927–2002)",
    "AFN" to "Afganistanin afgaani",
    "ALK" to "Albanian lek (1946–1965)",
    "ALL" to "Albanian lek",
    "AMD" to "Armenian dram",
    "ANG" to "Alankomaiden Antillien guldeni",
    "AOA" to "Angolan kwanza",
    "AOK" to "Angolan kwanza (1977–1991)",
    "AON" to "Angolan uusi kwanza (1990–2000)",
    "AOR" to "Angolan kwanza reajustado (1995–1999)",
    "ARA" to "Argentiinan austral",
    "ARL" to "Argentiinan ley-peso (1970–1983)",
    "ARM" to "Argentiinan peso (1881–1970)",
    "ARP" to "Argentiinan peso (1983–1985)",
    "ARS" to "Argentiinan peso",
    "ATS" to "Itävallan šillinki",
    "AUD" to "Australian dollari",
    "AWG" to "Aruban floriini",
    "AZM" to "Azerbaidžanin manat (1993–2006)",
    "AZN" to "Azerbaidžanin manat",
    "BAD" to "Bosnia-Hertsegovinan dinaari (1992–1994)",
    "BAM" to "Bosnia-Hertsegovinan vaihdettava markka",
    "BAN" to "Bosnia-Hertsegovinan uusi dinaari (1994–1997)",
    "BBD" to "Barbadosin dollari",
    "BDT" to "Bangladeshin taka",
    "BEC" to "Belgian vaihdettava frangi",
    "BEF" to "Belgian frangi",
    "BEL" to "Belgian rahoitusfrangi",
    "BGL" to "Bulgarian kova lev",
    "BGM" to "Bulgarian sosialistinen lev",
    "BGN" to "Bulgarian lev",
    "BGO" to "Bulgarian lev (1879–1952)",
    "BHD" to "Bahrainin dinaari",
    "BIF" to "Burundin frangi",
    "BMD" to "Bermudan dollari",
    "BND" to "Brunein dollari",
    "BOB" to "Bolivian boliviano",
    "BOL" to "Bolivian boliviano (1863–1963)",
    "BOP" to "Bolivian peso",
    "BOV" to "Bolivian mvdol",
    "BRB" to "Brasilian uusi cruzeiro (1967–1986)",
    "BRC" to "Brasilian cruzado (1986–1989)",
    "BRE" to "Brasilian cruzeiro (1990–1993)",
    "BRL" to "Brasilian real",
    "BRN" to "Brasilian uusi cruzado (1989–1990)",
    "BRR" to "Brasilian cruzeiro (1993–1994)",
    "BRZ" to "Brasilian cruzeiro (1942–1967)",
    "BSD" to "Bahaman dollari",
    "BTN" to "Bhutanin ngultrum",
    "BUK" to "Burman kyat",
    "BWP" to "Botswanan pula",
    "BYB" to "Valko-Venäjän uusi rupla (1994–1999)",
    "BYN" to "Valko-Venäjän rupla",
    "BYR" to "Valko-Venäjän rupla (2000–2016)",
    "BZD" to "Belizen dollari",
    "CAD" to "Kanadan dollari",
    "CDF" to "Kongon frangi",
    "CHE" to "Sveitsin WIR-euro",
    "CHF" to "Sveitsin frangi",
    "CHW" to "Sveitsin WIR-frangi",
    "CLE" to "Chilen escudo",
    "CLF" to "Chilen unidades de fomento",
    "CLP" to "Chilen peso",
    "CNH" to "Kiinan juan (offshore)",
    "CNX" to "Kiinan kansanpankin dollari",
    "CNY" to "Kiinan juan",
    "COP" to "Kolumbian peso",
    "COU" to "Kolumbian unidad de valor real",
    "CRC" to "Costa Rican colón",
    "CSD" to "Serbian dinaari (2002–2006)",
    "CSK" to "Tšekkoslovakian kova koruna",
    "CUC" to "Kuuban vaihdettava peso",
    "CUP" to "Kuuban peso",
    "CVE" to "Kap Verden escudo",
    "CYP" to "Kyproksen punta",
    "CZK" to "Tšekin koruna",
    "DDM" to "Itä-Saksan markka",
    "DEM" to "Saksan markka",
    "DJF" to "Djiboutin frangi",
    "DKK" to "Tanskan kruunu",
    "DOP" to "Dominikaanisen tasavallan peso",
    "DZD" to "Algerian dinaari",
    "ECS" to "Ecuadorin sucre",
    "ECV" to "Ecuadorin UVC",
    "EEK" to "Viron kruunu",
    "EGP" to "Egyptin punta",
    "ERN" to "Eritrean nakfa",
    "ESA" to "Espanjan peseta (A-tili)",
    "ESB" to "Espanjan peseta (vaihdettava tili)",
    "ESP" to "Espanjan peseta",
    "ETB" to "Etiopian birr",
    "EUR" to "euro",
    "FIM" to "Suomen markka",
    "FJD" to "Fidžin dollari",
    "FKP" to "Falklandinsaarten punta",
    "FRF" to "Ranskan frangi",
    "GBP" to "Englannin punta",
    "GEK" to "Georgian kuponkilari",
    "GEL" to "Georgian lari",
    "GHC" to "Ghanan cedi (1979–2007)",
    "GHS" to "Ghanan cedi",
    "GIP" to "Gibraltarin punta",
    "GMD" to "Gambian dalasi",
    "GNF" to "Guinean frangi",
    "GNS" to "Guinean syli",
    "GQE" to "Päiväntasaajan Guinean ekwele",
    "GRD" to "Kreikan drakma",
    "GTQ" to "Guatemalan quetzal",
    "GWE" to "Portugalin Guinean escudo",
    "GWP" to "Guinea-Bissaun peso",
    "GYD" to "Guyanan dollari",
    "HKD" to "Hongkongin dollari",
    "HNL" to "Hondurasin lempira",
    "HRD" to "Kroatian dinaari",
    "HRK" to "Kroatian kuna",
    "HTG" to "Haitin gourde",
    "HUF" to "Unkarin forintti",
    "IDR" to "Indonesian rupia",
    "IEP" to "Irlannin punta",
    "ILP" to "Israelin punta",
    "ILR" to "Israelin sekeli (1980–1985)",
    "ILS" to "Israelin uusi sekeli",
    "INR" to "Intian rupia",
    "IQD" to "Irakin dinaari",
    "IRR" to "Iranin rial",
    "ISJ" to "Islannin kruunu (1918–1981)",
    "ISK" to "Islannin kruunu",
    "ITL" to "Italian liira",
    "JMD" to "Jamaikan dollari",
    "JOD" to "Jordanian dinaari",
    "JPY" to "Japanin jeni",
    "KES" to "Kenian šillinki",
    "KGS" to "Kirgisian som",
    "KHR" to "Kambodžan riel",
    "KMF" to "Komorien frangi",
    "KPW" to "Pohjois-Korean won",
    "KRH" to "Etelä-Korean hwan (1953–1962)",
    "KRO" to "Etelä-Korean won (1945–1953)",
    "KRW" to "Etelä-Korean won",
    "KWD" to "Kuwaitin dinaari",
    "KYD" to "Caymansaarten dollari",
    "KZT" to "Kazakstanin tenge",
    "LAK" to "Laosin kip",
    "LBP" to "Libanonin punta",
    "LKR" to "Sri Lankan rupia",
    "LRD" to "Liberian dollari",
    "LSL" to "Lesothon loti",
    "LTL" to "Liettuan liti",
    "LTT" to "Liettuan talonas",
    "LUC" to "Luxemburgin vaihdettava frangi",
    "LUF" to "Luxemburgin frangi",
    "LUL" to "Luxemburgin rahoitusfrangi",
    "LVL" to "Latvian lati",
    "LVR" to "Latvian rupla",
    "LYD" to "Libyan dinaari",
    "MAD" to "Marokon dirhami",
    "MAF" to "Marokon frangi",
    "MCF" to "Monacon frangi",
    "MDC" to "Moldovan kuponkileu",
    "MDL" to "Moldovan leu",
    "MGA" to "Madagaskarin ariary",
    "MGF" to "Madagaskarin frangi",
    "MKD" to "Makedonian denaari",
    "MKN" to "Makedonian dinaari (1992–1993)",
    "MLF" to "Malin frangi",
    "MMK" to "Myanmarin kyat",
    "MNT" to "Mongolian tugrik",
    "MOP" to "Macaon pataca",
    "MRO" to "Mauritanian ouguiya (1973–2017)",
    "MRU" to "Mauritanian ouguiya",
    "MTL" to "Maltan liira",
    "MTP" to "Maltan punta",
    "MUR" to "Mauritiuksen rupia",
    "MVP" to "Malediivien rupia (1947–1981)",
    "MVR" to "Malediivien rufiyaa",
    "MWK" to "Malawin kwacha",
    "MXN" to "Meksikon peso",
    "MXP" to "Meksikon hopeapeso (1861–1992)",
    "MXV" to "Meksikon UDI",
    "MYR" to "Malesian ringgit",
    "MZE" to "Mosambikin escudo",
    "MZM" to "Mosambikin metical (1980–2006)",
    "MZN" to "Mosambikin metical",
    "NAD" to "Namibian dollari",
    "NGN" to "Nigerian naira",
    "NIC" to "Nicaraguan córdoba (1988–1991)",
    "NIO" to "Nicaraguan córdoba",
    "NLG" to "Alankomaiden guldeni",
    "NOK" to "Norjan kruunu",
    "NPR" to "Nepalin rupia",
    "NZD" to "Uuden-Seelannin dollari",
    "OMR" to "Omanin rial",
    "PAB" to "Panaman balboa",
    "PEI" to "Perun inti",
    "PEN" to "Perun sol",
    "PES" to "Perun sol (1863–1965)",
    "PGK" to "Papua-Uuden-Guinean kina",
    "PHP" to "Filippiinien peso",
    "PKR" to "Pakistanin rupia",
    "PLN" to "Puolan złoty",
    "PLZ" to "Puolan złoty (1950–1995)",
    "PTE" to "Portugalin escudo",
    "PYG" to "Paraguayn guarani",
    "QAR" to "Qatarin rial",
    "RHD" to "Rhodesian dollari",
    "ROL" to "Romanian leu (1952–2006)",
    "RON" to "Romanian leu",
    "RSD" to "Serbian dinaari",
    "RUB" to "Venäjän rupla",
    "RUR" to "Venäjän rupla (1991–1998)",
    "RWF" to "Ruandan frangi",
    "SAR" to "Saudi-Arabian rial",
    "SBD" to "Salomonsaarten dollari",
    "SCR" to "Seychellien rupia",
    "SDD" to "Sudanin dinaari (1992–2007)",
    "SDG" to "Sudanin punta",
    "SDP" to "Sudanin punta (1957–1998)",
    "SEK" to "Ruotsin kruunu",
    "SGD" to "Singaporen dollari",
    "SHP" to "Saint Helenan punta",
    "SIT" to "Slovenian tolar",
    "SKK" to "Slovakian koruna",
    "SLE" to "Sierra Leonen leone",
    "SLL" to "Sierra Leonen leone (1964–2022)",
    "SOS" to "Somalian šillinki",
    "SRD" to "Surinamen dollari",
    "SRG" to "Surinamen guldeni",
    "SSP" to "Etelä-Sudanin punta",
    "STD" to "São Tomén ja Príncipen dobra (1977–2017)",
    "STN" to "São Tomén ja Príncipen dobra",
    "SUR" to "Neuvostoliiton rupla",
    "SVC" to "El Salvadorin colón",
    "SYP" to "Syyrian punta",
    "SZL" to "Swazimaan lilangeni",
    "THB" to "Thaimaan baht",
    "TJR" to "Tadžikistanin rupla",
    "TJS" to "Tadžikistanin somoni",
    "TMM" to "Turkmenistanin manat (1993–2009)",
    "TMT" to "Turkmenistanin manat",
    "TND" to "Tunisian dinaari",
    "TOP" to "Tongan pa’anga",
    "TPE" to "Timorin escudo",
    "TRL" to "Turkin liira (1922–2005)",
    "TRY" to "Turkin liira",
    "TTD" to "Trinidadin ja Tobagon dollari",
    "TWD" to "Taiwanin uusi dollari",
    "TZS" to "Tansanian šillinki",
    "UAH" to "Ukrainan hryvnia",
    "UAK" to "Ukrainan karbovanetz",
    "UGS" to "Ugandan šillinki (1966–1987)",
    "UGX" to "Ugandan šillinki",
    "USD" to "Yhdysvaltain dollari",
    "USN" to "Yhdysvaltain dollari (seuraava päivä)",
    "USS" to "Yhdysvaltain dollari (sama päivä)",
    "UYI" to "Uruguayn peso en unidades indexadas",
    "UYP" to "Uruguayn peso (1975–1993)",
    "UYU" to "Uruguayn peso",
    "UYW" to "Uruguayn nimellinen palkkaindeksiyksikkö",
    "UZS" to "Uzbekistanin som",
    "VEB" to "Venezuelan bolívar (1871–2008)",
    "VEF" to "Venezuelan bolívar (2008–2018)",
    "VES" to "Venezuelan suvereeni bolívar",
    "VND" to "Vietnamin dong",
    "VNN" to "Vietnamin dong (1978–1985)",
    "VUV" to "Vanuatun vatu",
    "WST" to "Samoan tala",
    "XAF" to "CFA-frangi BEAC",
    "XAG" to "hopea",
    "XAU" to "kulta",
    "XBA" to "EURCO",
    "XBB" to "Euroopan rahayksikkö (EMU)",
    "XBC" to "EUA (XBC)",
    "XBD" to "EUA (XBD)",
    "XCD" to "Itä-Karibian dollari",
    "XDR" to "erityisnosto-oikeus (SDR)",
    "XEU" to "Euroopan valuuttayksikkö (ECU)",
    "XFO" to "Ranskan kultafrangi",
    "XFU" to "Ranskan UIC-frangi",
    "XOF" to "CFA-frangi BCEAO",
    "XPD" to "palladium",
    "XPF" to "CFP-frangi",
    "XPT" to "platina",
    "XRE" to "RINET-rahastot",
    "XSU" to "etelä-amerikkalaisen ALBA:n laskentayksikkö sucre",
    "XTS" to "testaustarkoitukseen varattu valuuttakoodi",
    "XUA" to "afrikkalainen AfDB-laskentayksikkö",
    "XXX" to "tuntematon rahayksikkö",
    "YDD" to "Jemenin dinaari",
    "YER" to "Jemenin rial",
    "YUD" to "Jugoslavian kova dinaari (1966–1990)",
    "YUM" to "Jugoslavian uusi dinaari (1994–2002)",
    "YUN" to "Jugoslavian vaihdettava dinaari (1990–1992)",
    "YUR" to "Jugoslavian uudistettu dinaari (1992–1993)",
    "ZAL" to "Etelä-Afrikan rahoitusrandi",
    "ZAR" to "Etelä-Afrikan randi",
    "ZMK" to "Sambian kwacha (1968–2012)",
    "ZMW" to "Sambian kwacha",
    "ZRN" to "Zairen uusi zaire (1993–1998)",
    "ZRZ" to "Zairen zaire (1971–1993)",
    "ZWD" to "Zimbabwen dollari (1980–2008)",
    "ZWL" to "Zimbabwen dollari (2009)",
    "ZWR" to "Zimbabwen dollari (2008)",
  ) }

  val fil: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "United Arab Emirates Dirham",
    "AFN" to "Afghan Afghani",
    "ALL" to "Lek ng Albania",
    "AMD" to "Armenian Dram",
    "ANG" to "Antillean Guilder ng Netherlands",
    "AOA" to "Angolan Kwanza",
    "ARS" to "Piso ng Argentina",
    "AUD" to "Dolyar ng Australya",
    "AWG" to "Florin ng Aruba",
    "AZN" to "Azerbaijani Manat",
    "BAM" to "Bosnia-Herzegovina Convertible Mark",
    "BBD" to "Dolyar ng Barbados",
    "BDT" to "Bangladeshi Taka",
    "BGN" to "Bulgarian Lev",
    "BHD" to "Bahraini Dinar",
    "BIF" to "Burundian Franc",
    "BMD" to "Dolyar ng Bermuda",
    "BND" to "Dolyar ng Brunei",
    "BOB" to "Boliviano ng Bolivia",
    "BRL" to "Real ng Barzil",
    "BSD" to "Dolyar ng Bahamas",
    "BTN" to "Bhutanese Ngultrum",
    "BWP" to "Botswanan Pula",
    "BYN" to "Ruble ng Belarus",
    "BYR" to "Belarusian Ruble (2000–2016)",
    "BZD" to "Dolyar ng Belize",
    "CAD" to "Dolyar ng Canada",
    "CDF" to "Congolese Franc",
    "CHF" to "Swiss Franc",
    "CLP" to "Piso ng Chile",
    "CNH" to "Chinese Yuan (offshore)",
    "CNY" to "Chinese Yuan",
    "COP" to "Piso ng Colombia",
    "CRC" to "Colón ng Costa Rica",
    "CUC" to "Convertible na Piso ng Cuba",
    "CUP" to "Piso ng Cuba",
    "CVE" to "Cape Verdean Escudo",
    "CZK" to "Koruna ng Czech Republic",
    "DEM" to "Deutsche Marks",
    "DJF" to "Djiboutian Franc",
    "DKK" to "Danish Krone",
    "DOP" to "Piso ng Dominican",
    "DZD" to "Algerian Dinar",
    "EEK" to "Estonian Kroon",
    "EGP" to "Pound ng Egypt",
    "ERN" to "Eritrean Nakfa",
    "ETB" to "Ethiopian Birr",
    "EUR" to "Euro",
    "FJD" to "Dolyar ng Fiji",
    "FKP" to "Pound ng Falkland Islands",
    "FRF" to "French Franc",
    "GBP" to "British Pound",
    "GEL" to "Georgian Lari",
    "GHS" to "Ghanaian Cedi",
    "GIP" to "Pound ng Gibraltar",
    "GMD" to "Gambian Dalasi",
    "GNF" to "Guinean Franc",
    "GTQ" to "Quetzal ng Guatemala",
    "GYD" to "Dolyar ng Guyanese",
    "HKD" to "Dolyar ng Hong Kong",
    "HNL" to "Lempira ng Honduras",
    "HRK" to "Kuna ng Croatia",
    "HTG" to "Gourde ng Haiti",
    "HUF" to "Forint ng Hungary",
    "IDR" to "Indonesian Rupiah",
    "ILS" to "New Shekel ng Israel",
    "INR" to "Indian Rupee",
    "IQD" to "Iraqi Dinar",
    "IRR" to "Iranian Rial",
    "ISK" to "Icelandic Króna",
    "JMD" to "Dolyar ng Jamaica",
    "JOD" to "Jordanian Dinar",
    "JPY" to "Japanese Yen",
    "KES" to "Kenyan Shilling",
    "KGS" to "Kyrgystani Som",
    "KHR" to "Cambodian Riel",
    "KMF" to "Comorian Franc",
    "KPW" to "Won ng Hilagang Korea",
    "KRW" to "Won ng Timog Korea",
    "KWD" to "Kuwaiti Dinar",
    "KYD" to "Dolyar ng Cayman Islands",
    "KZT" to "Kazakhstani Tenge",
    "LAK" to "Laotian Kip",
    "LBP" to "Pound ng Lebanon",
    "LKR" to "Sri Lankan Rupee",
    "LRD" to "Dolyar ng Liberia",
    "LSL" to "Lesotho Loti",
    "LTL" to "Lithuanian Litas",
    "LVL" to "Latvian Lats",
    "LYD" to "Dinar ng Libya",
    "MAD" to "Moroccan Dirham",
    "MDL" to "Leu ng Moldova",
    "MGA" to "Malagasy Ariary",
    "MKD" to "Denar ng Macedonia",
    "MMK" to "Myanmar Kyat",
    "MNT" to "Mongolian Tugrik",
    "MOP" to "Macanese Pataca",
    "MRO" to "Mauritanian Ouguiya (1973–2017)",
    "MRU" to "Ouguiya ng Mauritania",
    "MUR" to "Mauritian Rupee",
    "MVR" to "Maldivian Rufiyaa",
    "MWK" to "Malawian Kwacha",
    "MXN" to "Piso ng Mexico",
    "MYR" to "Malaysian Ringgit",
    "MZN" to "Mozambican Metical",
    "NAD" to "Dolyar ng Namibia",
    "NGN" to "Nigerian Naira",
    "NIO" to "Córdoba ng Nicaragua",
    "NOK" to "Norwegian Krone",
    "NPR" to "Nepalese Rupee",
    "NZD" to "Dolyar ng New Zealand",
    "OMR" to "Omani Rial",
    "PAB" to "Balboa ng Panama",
    "PEN" to "Peruvian Sol",
    "PGK" to "Papua New Guinean Kina",
    "PHP" to "Piso ng Pilipinas",
    "PKR" to "Pakistani Rupee",
    "PLN" to "Zloty ng Poland",
    "PYG" to "Paraguayan Guarani",
    "QAR" to "Qatari Rial",
    "RON" to "Leu ng Romania",
    "RSD" to "Dinar ng Serbia",
    "RUB" to "Ruble ng Russia",
    "RWF" to "Rwandan Franc",
    "SAR" to "Saudi Riyal",
    "SBD" to "Dolyar ng Solomon Islands",
    "SCR" to "Seychellois Rupee",
    "SDG" to "Pound ng Sudan",
    "SEK" to "Swedish Krona",
    "SGD" to "Dolyar ng Singapore",
    "SHP" to "Saint Helena Pound",
    "SIT" to "Slovenian Tolar",
    "SKK" to "Slovak Koruna",
    "SLE" to "Sierra Leonean Leone",
    "SLL" to "Sierra Leonean Leone (1964—2022)",
    "SOS" to "Somali Shilling",
    "SRD" to "Dolyar ng Suriname",
    "SSP" to "Pound ng Timog Sudan",
    "STD" to "São Tomé & Príncipe Dobra (1977–2017)",
    "STN" to "São Tomé & Príncipe Dobra",
    "SYP" to "Syrian Pound",
    "SZL" to "Swazi Lilangeni",
    "THB" to "Thai Baht",
    "TJS" to "Tajikistani Somoni",
    "TMT" to "Turkmenistani Manat",
    "TND" to "Tunisian Dinar",
    "TOP" to "Tongan Paʻanga",
    "TRY" to "Turkish Lira",
    "TTD" to "Dolyar ng Trinidad and Tobago",
    "TWD" to "Dolyar ng New Taiwan",
    "TZS" to "Tanzanian Shilling",
    "UAH" to "Hryvnia ng Ukraine",
    "UGX" to "Ugandan Shilling",
    "USD" to "Dolyar ng US",
    "UYU" to "Piso ng Uruguay",
    "UZS" to "Uzbekistan Som",
    "VEB" to "Venezuelan Bolívar (1871–2008)",
    "VEF" to "Bolívar ng Venezuela (2008–2018)",
    "VES" to "Bolívar ng Venezuela",
    "VND" to "Vietnamese Dong",
    "VUV" to "Vanuatu Vatu",
    "WST" to "Samoan Tala",
    "XAF" to "CFA Franc BEAC",
    "XCD" to "Dolyar ng Silangang Caribbean",
    "XOF" to "CFA Franc ng Kanlurang Africa",
    "XPF" to "CFP Franc",
    "XXX" to "Hindi Kilalang Pera",
    "YER" to "Yemeni Rial",
    "ZAR" to "Rand ng Timog Africa",
    "ZMK" to "Zambian Kwacha (1968–2012)",
    "ZMW" to "Zambian Kwacha",
  ) }

  val fo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Sameindu Emirríkini dirham",
    "AFN" to "Afganistan afghani",
    "ALL" to "Albania lek",
    "AMD" to "Armenia dram",
    "ANG" to "Niðurlonds Karibia gyllin",
    "AOA" to "Angola kwanza",
    "ARS" to "Argentina peso",
    "AUD" to "Avstralskur dollari",
    "AWG" to "Aruba florin",
    "AZN" to "Aserbadjan manat",
    "BAM" to "Bosnia-Hersegovina mark (kann vekslast)",
    "BBD" to "Barbados dollari",
    "BDT" to "Bangladesj taka",
    "BGN" to "Bulgarskur lev",
    "BHD" to "Barein dinar",
    "BIF" to "Burundi frankur",
    "BMD" to "Bermuda dollari",
    "BND" to "Brunei dollari",
    "BOB" to "Bolivia boliviano",
    "BRL" to "Brasilianskur real",
    "BSD" to "Bahamaoyggjar dollari",
    "BTN" to "Butan ngultrum",
    "BWP" to "Botsvana pula",
    "BYN" to "Hvítarussiskur ruble",
    "BYR" to "Hvítarussland ruble (2000–2016)",
    "BZD" to "Belis dollari",
    "CAD" to "Kanadiskur dollari",
    "CDF" to "Kongo frankur",
    "CHF" to "sveisiskur frankur",
    "CLP" to "Kili peso",
    "CNH" to "kinesiskur yuan (úr landi)",
    "CNY" to "kinesiskur yuan",
    "COP" to "Kolombia peso",
    "CRC" to "Kosta Rika colón",
    "CUC" to "Kuba peso (sum kann vekslast)",
    "CUP" to "Kuba peso",
    "CVE" to "Grønhøvdaoyggjar escudo",
    "CZK" to "Kekkiskt koruna",
    "DJF" to "Djibuti frankur",
    "DKK" to "donsk króna",
    "DOP" to "Dominika peso",
    "DZD" to "Algeria dinar",
    "EGP" to "Egyptaland pund",
    "ERN" to "Eritrea nakfa",
    "ETB" to "Etiopia birr",
    "EUR" to "Evra",
    "FJD" to "Fiji dollari",
    "FKP" to "Falklandsoyggjar pund",
    "GBP" to "bretsk pund",
    "GEL" to "Georgia lari",
    "GHS" to "Gana cedi",
    "GIP" to "Gibraltar pund",
    "GMD" to "Gambia dalasi",
    "GNF" to "Guinea frankur",
    "GTQ" to "Guatemala quetzal",
    "GYD" to "Gujana dollari",
    "HKD" to "Hong Kong dollari",
    "HNL" to "Honduras lempira",
    "HRK" to "Kroatia kuna",
    "HTG" to "Haiti gourde",
    "HUF" to "Ungarskur forintur",
    "IDR" to "Indonesia rupiah",
    "ILS" to "Ísrael new shekel",
    "INR" to "indiskir rupis",
    "IQD" to "Irak dinar",
    "IRR" to "iranskir rials",
    "ISK" to "íslendsk króna",
    "JMD" to "Jamaika dollari",
    "JOD" to "Jordan dinar",
    "JPY" to "japanskur yen",
    "KES" to "kenjanskur skillingur",
    "KGS" to "Kirgisia som",
    "KHR" to "Kambodja riel",
    "KMF" to "Komoroyggjar frankur",
    "KPW" to "Norðurkorea won",
    "KRW" to "Suðurkorea won",
    "KWD" to "Kuvait dinar",
    "KYD" to "Caymanoyggjar dollari",
    "KZT" to "Kasakstan tenge",
    "LAK" to "Laos kip",
    "LBP" to "Libanon pund",
    "LKR" to "Sri Lanka rupi",
    "LRD" to "Liberia dollari",
    "LSL" to "Lesoto loti",
    "LYD" to "Libya dinar",
    "MAD" to "Marokko dirham",
    "MDL" to "Moldovanskur leu",
    "MGA" to "Madagaskar ariary",
    "MKD" to "Makedónia denar",
    "MMK" to "Myanmar (Burma) kyat",
    "MNT" to "Mongolia tugrik",
    "MOP" to "Makao pataca",
    "MRO" to "Móritania ouguiya (1973–2017)",
    "MRU" to "Móritania ouguiya",
    "MUR" to "Móritius rupi",
    "MVR" to "Maldivoyggjar rufiyaa",
    "MWK" to "Malavi kwacha",
    "MXN" to "Meksiko peso",
    "MYR" to "Malaisia ringgit",
    "MZN" to "Mosambik metical",
    "NAD" to "Namibia dollari",
    "NGN" to "Nigeria naira",
    "NIO" to "Nikaragua córdoba",
    "NOK" to "norsk króna",
    "NPR" to "Nepal rupi",
    "NZD" to "Nýsæland dollari",
    "OMR" to "Oman rial",
    "PAB" to "Panama balboa",
    "PEN" to "Peru sol",
    "PGK" to "Papua Nýguinea kina",
    "PHP" to "Filipsoyggjar peso",
    "PKR" to "Pakistan rupi",
    "PLN" to "Pólskur zloty",
    "PYG" to "Paraguai guarani",
    "QAR" to "Katar rial",
    "RON" to "Rumenia leu",
    "RSD" to "Serbia dinar",
    "RUB" to "Russland ruble",
    "RWF" to "Ruanda frankur",
    "SAR" to "Saudiarabia riyal",
    "SBD" to "Salomonoyggjar dollari",
    "SCR" to "Seyskelloyggjar rupi",
    "SDG" to "Sudan pund",
    "SEK" to "svensk króna",
    "SGD" to "Singapor dollari",
    "SHP" to "St. Helena pund",
    "SLE" to "Sierra Leona leone",
    "SLL" to "Sierra Leona leone (1964—2022)",
    "SOS" to "Somalia skillingur",
    "SRD" to "Surinam dollari",
    "SSP" to "Suðursudan pund",
    "STD" to "Sao Tome & Prinsipi dobra (1977–2017)",
    "STN" to "Sao Tome & Prinsipi dobra",
    "SYP" to "Sýria pund",
    "SZL" to "Svasiland lilangeni",
    "THB" to "Tailand baht",
    "TJS" to "Tadsjikistan somoni",
    "TMT" to "Turkmenistan manat",
    "TND" to "Tunesia dinar",
    "TOP" to "Tonga paʻanga",
    "TRY" to "Turkaland liri",
    "TTD" to "Trinidad & Tobago dollari",
    "TWD" to "Taivan new dollari",
    "TZS" to "Tansania skillingur",
    "UAH" to "Ukraina hryvnia",
    "UGX" to "Uganda skillingur",
    "USD" to "US dollari",
    "UYU" to "Uruguai peso",
    "UZS" to "Usbekistan som",
    "VEF" to "Venesuela bolívar (2008–2018)",
    "VES" to "Venesuela bolívar",
    "VND" to "Vjetnam dong",
    "VUV" to "Vanuatu vatu",
    "WST" to "Samoa tala",
    "XAF" to "Miðafrika CFA frankur",
    "XAG" to "unse sølv",
    "XAU" to "unse guld",
    "XCD" to "Eystur Karibia dollari",
    "XOF" to "Vesturafrika CFA frankur",
    "XPD" to "unse palladium",
    "XPF" to "CFP frankur",
    "XPT" to "unse platin",
    "XXX" to "Ókent gjaldoyra",
    "YER" to "Jemen rial",
    "ZAR" to "Suðurafrika rand",
    "ZMW" to "Sambia kwacha",
  ) }

  val fo_DK: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "peseta andorrane",
    "AED" to "dirham des Émirats arabes unis",
    "AFA" to "afghani (1927–2002)",
    "AFN" to "afghani afghan",
    "ALK" to "lek albanais (1947–1961)",
    "ALL" to "lek albanais",
    "AMD" to "dram arménien",
    "ANG" to "florin antillais",
    "AOA" to "kwanza angolais",
    "AOK" to "kwanza angolais (1977–1990)",
    "AON" to "nouveau kwanza angolais (1990–2000)",
    "AOR" to "kwanza angolais réajusté (1995–1999)",
    "ARA" to "austral argentin",
    "ARP" to "peso argentin (1983–1985)",
    "ARS" to "peso argentin",
    "ATS" to "schilling autrichien",
    "AUD" to "dollar australien",
    "AWG" to "florin arubais",
    "AZM" to "manat azéri (1993–2006)",
    "AZN" to "manat azéri",
    "BAD" to "dinar bosniaque",
    "BAM" to "mark convertible bosniaque",
    "BBD" to "dollar barbadien",
    "BDT" to "taka bangladeshi",
    "BEC" to "franc belge (convertible)",
    "BEF" to "franc belge",
    "BEL" to "franc belge (financier)",
    "BGL" to "lev bulgare (1962–1999)",
    "BGN" to "lev bulgare",
    "BHD" to "dinar bahreïni",
    "BIF" to "franc burundais",
    "BMD" to "dollar bermudien",
    "BND" to "dollar brunéien",
    "BOB" to "boliviano bolivien",
    "BOP" to "peso bolivien",
    "BOV" to "mvdol bolivien",
    "BRB" to "nouveau cruzeiro brésilien (1967–1986)",
    "BRC" to "cruzado brésilien (1986–1989)",
    "BRE" to "cruzeiro brésilien (1990–1993)",
    "BRL" to "réal brésilien",
    "BRN" to "nouveau cruzado",
    "BRR" to "cruzeiro",
    "BSD" to "dollar bahaméen",
    "BTN" to "ngultrum bouthanais",
    "BUK" to "kyat birman",
    "BWP" to "pula botswanais",
    "BYB" to "nouveau rouble biélorusse (1994–1999)",
    "BYN" to "rouble biélorusse",
    "BYR" to "rouble biélorusse (2000–2016)",
    "BZD" to "dollar bélizéen",
    "CAD" to "dollar canadien",
    "CDF" to "franc congolais",
    "CHE" to "euro WIR",
    "CHF" to "franc suisse",
    "CHW" to "franc WIR",
    "CLF" to "unité d’investissement chilienne",
    "CLP" to "peso chilien",
    "CNH" to "yuan chinois (zone extracôtière)",
    "CNY" to "yuan renminbi chinois",
    "COP" to "peso colombien",
    "COU" to "unité de valeur réelle colombienne",
    "CRC" to "colón costaricain",
    "CSD" to "dinar serbo-monténégrin",
    "CSK" to "couronne forte tchécoslovaque",
    "CUC" to "peso cubain convertible",
    "CUP" to "peso cubain",
    "CVE" to "escudo capverdien",
    "CYP" to "livre chypriote",
    "CZK" to "couronne tchèque",
    "DDM" to "mark est-allemand",
    "DEM" to "mark allemand",
    "DJF" to "franc djiboutien",
    "DKK" to "couronne danoise",
    "DOP" to "peso dominicain",
    "DZD" to "dinar algérien",
    "ECS" to "sucre équatorien",
    "ECV" to "unité de valeur constante équatoriale (UVC)",
    "EEK" to "couronne estonienne",
    "EGP" to "livre égyptienne",
    "ERN" to "nafka érythréen",
    "ESA" to "peseta espagnole (compte A)",
    "ESB" to "peseta espagnole (compte convertible)",
    "ESP" to "peseta espagnole",
    "ETB" to "birr éthiopien",
    "EUR" to "euro",
    "FIM" to "mark finlandais",
    "FJD" to "dollar fidjien",
    "FKP" to "livre des îles Malouines",
    "FRF" to "franc français",
    "GBP" to "livre sterling",
    "GEK" to "coupon de lari géorgien",
    "GEL" to "lari géorgien",
    "GHC" to "cédi",
    "GHS" to "cédi ghanéen",
    "GIP" to "livre de Gibraltar",
    "GMD" to "dalasi gambien",
    "GNF" to "franc guinéen",
    "GNS" to "syli guinéen",
    "GQE" to "ekwélé équatoguinéen",
    "GRD" to "drachme grecque",
    "GTQ" to "quetzal guatémaltèque",
    "GWE" to "escudo de Guinée portugaise",
    "GWP" to "peso bissau-guinéen",
    "GYD" to "dollar du Guyana",
    "HKD" to "dollar de Hong Kong",
    "HNL" to "lempira hondurien",
    "HRD" to "dinar croate",
    "HRK" to "kuna croate",
    "HTG" to "gourde haïtienne",
    "HUF" to "forint hongrois",
    "IDR" to "roupie indonésienne",
    "IEP" to "livre irlandaise",
    "ILP" to "livre israélienne",
    "ILS" to "nouveau shekel israélien",
    "INR" to "roupie indienne",
    "IQD" to "dinar irakien",
    "IRR" to "riyal iranien",
    "ISK" to "couronne islandaise",
    "ITL" to "lire italienne",
    "JMD" to "dollar jamaïcain",
    "JOD" to "dinar jordanien",
    "JPY" to "yen japonais",
    "KES" to "shilling kényan",
    "KGS" to "som kirghize",
    "KHR" to "riel cambodgien",
    "KMF" to "franc comorien",
    "KPW" to "won nord-coréen",
    "KRW" to "won sud-coréen",
    "KWD" to "dinar koweïtien",
    "KYD" to "dollar des îles Caïmans",
    "KZT" to "tenge kazakh",
    "LAK" to "kip laotien",
    "LBP" to "livre libanaise",
    "LKR" to "roupie srilankaise",
    "LRD" to "dollar libérien",
    "LSL" to "loti lesothan",
    "LTL" to "litas lituanien",
    "LTT" to "talonas lituanien",
    "LUC" to "franc convertible luxembourgeois",
    "LUF" to "franc luxembourgeois",
    "LUL" to "franc financier luxembourgeois",
    "LVL" to "lats letton",
    "LVR" to "rouble letton",
    "LYD" to "dinar libyen",
    "MAD" to "dirham marocain",
    "MAF" to "franc marocain",
    "MDL" to "leu moldave",
    "MGA" to "ariary malgache",
    "MGF" to "franc malgache",
    "MKD" to "denar macédonien",
    "MLF" to "franc malien",
    "MMK" to "kyat myanmarais",
    "MNT" to "tugrik mongol",
    "MOP" to "pataca macanaise",
    "MRO" to "ouguiya mauritanien (1973–2017)",
    "MRU" to "ouguiya mauritanien",
    "MTL" to "lire maltaise",
    "MTP" to "livre maltaise",
    "MUR" to "roupie mauricienne",
    "MVR" to "rufiyaa maldivienne",
    "MWK" to "kwacha malawite",
    "MXN" to "peso mexicain",
    "MXP" to "peso d’argent mexicain (1861–1992)",
    "MXV" to "unité de conversion mexicaine (UDI)",
    "MYR" to "ringgit malais",
    "MZE" to "escudo mozambicain",
    "MZM" to "métical",
    "MZN" to "metical mozambicain",
    "NAD" to "dollar namibien",
    "NGN" to "naira nigérian",
    "NIC" to "cordoba",
    "NIO" to "córdoba oro nicaraguayen",
    "NLG" to "florin néerlandais",
    "NOK" to "couronne norvégienne",
    "NPR" to "roupie népalaise",
    "NZD" to "dollar néo-zélandais",
    "OMR" to "riyal omanais",
    "PAB" to "balboa panaméen",
    "PEI" to "inti péruvien",
    "PEN" to "sol péruvien",
    "PES" to "sol péruvien (1863–1985)",
    "PGK" to "kina papouan-néo-guinéen",
    "PHP" to "peso philippin",
    "PKR" to "roupie pakistanaise",
    "PLN" to "zloty polonais",
    "PLZ" to "zloty (1950–1995)",
    "PTE" to "escudo portugais",
    "PYG" to "guaraní paraguayen",
    "QAR" to "riyal qatari",
    "RHD" to "dollar rhodésien",
    "ROL" to "ancien leu roumain",
    "RON" to "leu roumain",
    "RSD" to "dinar serbe",
    "RUB" to "rouble russe",
    "RUR" to "rouble russe (1991–1998)",
    "RWF" to "franc rwandais",
    "SAR" to "riyal saoudien",
    "SBD" to "dollar des îles Salomon",
    "SCR" to "roupie des Seychelles",
    "SDD" to "dinar soudanais",
    "SDG" to "livre soudanaise",
    "SDP" to "livre soudanaise (1956–2007)",
    "SEK" to "couronne suédoise",
    "SGD" to "dollar de Singapour",
    "SHP" to "livre de Sainte-Hélène",
    "SIT" to "tolar slovène",
    "SKK" to "couronne slovaque",
    "SLE" to "leone sierra-léonais",
    "SLL" to "leone sierra-léonais (1964—2022)",
    "SOS" to "shilling somalien",
    "SRD" to "dollar surinamais",
    "SRG" to "florin surinamais",
    "SSP" to "livre sud-soudanaise",
    "STD" to "dobra santoméen (1977–2017)",
    "STN" to "dobra santoméen",
    "SUR" to "rouble soviétique",
    "SVC" to "colón salvadorien",
    "SYP" to "livre syrienne",
    "SZL" to "lilangeni swazi",
    "THB" to "baht thaïlandais",
    "TJR" to "rouble tadjik",
    "TJS" to "somoni tadjik",
    "TMM" to "manat turkmène",
    "TMT" to "nouveau manat turkmène",
    "TND" to "dinar tunisien",
    "TOP" to "pa’anga tongan",
    "TPE" to "escudo timorais",
    "TRL" to "livre turque (1844–2005)",
    "TRY" to "livre turque",
    "TTD" to "dollar de Trinité-et-Tobago",
    "TWD" to "nouveau dollar taïwanais",
    "TZS" to "shilling tanzanien",
    "UAH" to "hryvnia ukrainienne",
    "UAK" to "karbovanetz",
    "UGS" to "shilling ougandais (1966–1987)",
    "UGX" to "shilling ougandais",
    "USD" to "dollar des États-Unis",
    "USN" to "dollar des Etats-Unis (jour suivant)",
    "USS" to "dollar des Etats-Unis (jour même)",
    "UYI" to "peso uruguayen (unités indexées)",
    "UYP" to "peso uruguayen (1975–1993)",
    "UYU" to "peso uruguayen",
    "UZS" to "sum ouzbek",
    "VEB" to "bolivar vénézuélien (1871–2008)",
    "VEF" to "bolivar vénézuélien (2008–2018)",
    "VES" to "bolivar vénézuélien",
    "VND" to "dông vietnamien",
    "VUV" to "vatu vanuatuan",
    "WST" to "tala samoan",
    "XAF" to "franc CFA (BEAC)",
    "XAG" to "argent",
    "XAU" to "or",
    "XBA" to "unité européenne composée",
    "XBB" to "unité monétaire européenne",
    "XBC" to "unité de compte européenne (XBC)",
    "XBD" to "unité de compte européenne (XBD)",
    "XCD" to "dollar des Caraïbes orientales",
    "XCG" to "florin caribéen",
    "XDR" to "droit de tirage spécial",
    "XEU" to "unité de compte européenne (ECU)",
    "XFO" to "franc or",
    "XFU" to "franc UIC",
    "XOF" to "franc CFA (BCEAO)",
    "XPD" to "palladium",
    "XPF" to "franc CFP",
    "XPT" to "platine",
    "XRE" to "type de fonds RINET",
    "XTS" to "(devise de test)",
    "XXX" to "devise inconnue ou non valide",
    "YDD" to "dinar du Yémen",
    "YER" to "riyal yéménite",
    "YUD" to "nouveau dinar yougoslave",
    "YUM" to "dinar yougoslave Noviy",
    "YUN" to "dinar yougoslave convertible",
    "ZAL" to "rand sud-africain (financier)",
    "ZAR" to "rand sud-africain",
    "ZMK" to "kwacha zambien (1968–2012)",
    "ZMW" to "kwacha zambien",
    "ZRN" to "nouveau zaïre zaïrien",
    "ZRZ" to "zaïre zaïrois",
    "ZWD" to "dollar zimbabwéen",
    "ZWL" to "dollar zimbabwéen (2009)",
    "ZWR" to "dollar zimbabwéen (2008)",
  ) }

  val fr_BE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_BF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_BI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_BJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_BL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AZN" to "manat azerbaïdjanais",
    "CVE" to "escudo cap-verdien",
    "IRR" to "rial iranien",
    "OMR" to "rial omanais",
    "PEN" to "nouveau sol péruvien",
    "PGK" to "kina papou-néo-guinéen",
    "QAR" to "riyal du Qatar",
    "SAR" to "rial saoudien",
    "SRD" to "dollar du Suriname",
    "TOP" to "pa’anga",
    "VUV" to "vatu",
    "WST" to "tala",
    "XXX" to "Devise inconnue",
    "YER" to "rial yéménite",
  ) }

  val fr_CD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_DJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_DZ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GP: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_HT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_KM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_LU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_ML: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_NC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_PF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_PM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_RE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_RW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_SC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_SN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_SY: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_TD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_TG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_TN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_VU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_WF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_YT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val frr: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fur: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AMD" to "Dram armen",
    "ARS" to "Peso argjentin",
    "ATS" to "Selin austriac",
    "AUD" to "dolar australian",
    "BEF" to "Franc de Belgjiche",
    "BIF" to "Franc burundês",
    "BND" to "Dolar dal Brunei",
    "BRL" to "real brasilian",
    "BYN" to "Rubli bielorùs",
    "BYR" to "Rubli bielorùs (2000–2016)",
    "CAD" to "dolar canadês",
    "CHF" to "franc svuizar",
    "CNY" to "yuan cinês",
    "CSD" to "Vieri dinar serp",
    "CUP" to "Peso cuban",
    "CZK" to "Corone de Republiche Ceche",
    "DEM" to "Marc todesc",
    "DKK" to "corone danese",
    "DZD" to "Dinar algerin",
    "EUR" to "euro",
    "FRF" to "Franc francês",
    "GBP" to "sterline britaniche",
    "HKD" to "dolar di Hong Kong",
    "HRD" to "Dinar cravuat",
    "HRK" to "Kuna cravuate",
    "IDR" to "rupiah indonesiane",
    "INR" to "rupie indiane",
    "IRR" to "Rial iranian",
    "ITL" to "Lire taliane",
    "JPY" to "yen gjaponês",
    "KRW" to "won de Coree dal Sud",
    "LVL" to "Lats leton",
    "MXN" to "peso messican",
    "NAD" to "Dolar namibian",
    "NIO" to "Córdoba oro nicaraguan",
    "NOK" to "corone norvegjese",
    "NZD" to "Dollar neozelandês",
    "PKR" to "Rupie pachistane",
    "PLN" to "zloty polac",
    "RSD" to "Dinar serp",
    "RUB" to "rubli rus",
    "SAR" to "riyal de Arabie Saudite",
    "SEK" to "corone svedese",
    "SIT" to "Talar sloven",
    "SKK" to "Corone slovache",
    "THB" to "baht tailandês",
    "TRL" to "Viere Lire turche",
    "TRY" to "lire turche",
    "TWD" to "gnûf dolar taiwanês",
    "USD" to "dolar american",
    "USN" to "Dolar american (prossime zornade)",
    "USS" to "Dolar american (stesse zornade)",
    "XAG" to "Arint",
    "XAU" to "Aur",
    "XBA" to "Unitât composite europeane",
    "XBB" to "Unitât monetarie europeane",
    "XBC" to "Unitât di acont europeane (XBC)",
    "XBD" to "Unitât di acont europeane (XBD)",
    "XDR" to "Dirits speciâi di incas",
    "XFO" to "Franc aur francês",
    "XFU" to "Franc UIC francês",
    "XPD" to "Paladi",
    "XPT" to "Platin",
    "XRE" to "fonts RINET",
    "XTS" to "codiç di verifiche de monede",
    "XXX" to "Monede no valide o no cognossude",
    "ZAR" to "rand sudafrican",
  ) }

  val fy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorrese peseta",
    "AED" to "Verenigde Arabyske Emiraten-dirham",
    "AFA" to "Afghani (1927–2002)",
    "AFN" to "Afghaanske afghani",
    "ALL" to "Albanese lek",
    "AMD" to "Armeense dram",
    "ANG" to "Nederlânsk-Antilliaanske gûne",
    "AOA" to "Angolese kwanza",
    "AOK" to "Angolese kwanza (1977–1990)",
    "AON" to "Angolese nieuwe kwanza (1990–2000)",
    "AOR" to "Angolese kwanza reajustado (1995–1999)",
    "ARA" to "Argentynske austral",
    "ARL" to "Argentynske peso ley (1970–1983)",
    "ARM" to "Argentynske peso (1881–1970)",
    "ARP" to "Argentynske peso (1983–1985)",
    "ARS" to "Argentynske peso",
    "ATS" to "Eastenrykse schilling",
    "AUD" to "Australyske dollar",
    "AWG" to "Arubaanske gulden",
    "AZM" to "Azerbeidzjaanske manat (1993–2006)",
    "AZN" to "Azerbeidzjaanske manat",
    "BAD" to "Bosnyske dinar",
    "BAM" to "Bosnyske convertibele mark",
    "BAN" to "Nije Bosnyske dinar (1994–1997)",
    "BBD" to "Barbadaanske dollar",
    "BDT" to "Bengalese taka",
    "BEC" to "Belgyske frank (convertibel)",
    "BEF" to "Belgyske frank",
    "BEL" to "Belgyske frank (finansjeel)",
    "BGL" to "Bulgaarse harde lev",
    "BGM" to "Bulgaarse socialistyske lev",
    "BGN" to "Bulgaarse lev",
    "BGO" to "Bulgaarse lev (1879–1952)",
    "BHD" to "Bahreinse dinar",
    "BIF" to "Burundese frank",
    "BMD" to "Bermuda-dollar",
    "BND" to "Bruneise dollar",
    "BOB" to "Boliviaanske boliviano",
    "BOL" to "Boliviaanske boliviano (1863–1963)",
    "BOP" to "Boliviaanske peso",
    "BOV" to "Boliviaanske mvdol",
    "BRB" to "Braziliaanske cruzeiro novo (1967–1986)",
    "BRC" to "Braziliaanske cruzado",
    "BRE" to "Braziliaanske cruzeiro (1990–1993)",
    "BRL" to "Braziliaanske real",
    "BRN" to "Braziliaanske cruzado novo",
    "BRR" to "Braziliaanske cruzeiro",
    "BRZ" to "Braziliaanske cruzeiro (1942–1967)",
    "BSD" to "Bahamaanske dollar",
    "BTN" to "Bhutaanske ngultrum",
    "BUK" to "Birmese kyat",
    "BWP" to "Botswaanske pula",
    "BYB" to "Wit-Russyske nieuwe roebel (1994–1999)",
    "BYN" to "Wit-Russyske roebel",
    "BYR" to "Wit-Russyske roebel (2000–2016)",
    "BZD" to "Belizaanske dollar",
    "CAD" to "Canadese dollar",
    "CDF" to "Congolese frank",
    "CHE" to "WIR euro",
    "CHF" to "Zwitserse frank",
    "CHW" to "WIR franc",
    "CLE" to "Sileenske escudo",
    "CLF" to "Sileenske unidades de fomento",
    "CLP" to "Sileenske peso",
    "CNY" to "Sineeske yuan renminbi",
    "COP" to "Kolombiaanske peso",
    "COU" to "Unidad de Valor Real",
    "CRC" to "Costaricaanske colón",
    "CSD" to "Alde Servyske dinar",
    "CSK" to "Tsjechoslowaakse harde koruna",
    "CUC" to "Kubaanske convertibele peso",
    "CUP" to "Kubaanske peso",
    "CVE" to "Kaapverdyske escudo",
    "CYP" to "Cyprysk pûn",
    "CZK" to "Tsjechyske kroon",
    "DDM" to "East-Dútske ostmark",
    "DEM" to "Dútske mark",
    "DJF" to "Djiboutiaanske frank",
    "DKK" to "Deenske kroon",
    "DOP" to "Dominikaanske peso",
    "DZD" to "Algerynske dinar",
    "ECS" to "Ecuadoraanske sucre",
    "ECV" to "Ecuadoraanske unidad de valor constante (UVC)",
    "EEK" to "Estlânske kroon",
    "EGP" to "Egyptysk pûn",
    "ERN" to "Eritrese nakfa",
    "ESA" to "Spaanske peseta (account A)",
    "ESB" to "Spaanske peseta (convertibele account)",
    "ESP" to "Spaanske peseta",
    "ETB" to "Ethiopyske birr",
    "EUR" to "Euro",
    "FIM" to "Finse markka",
    "FJD" to "Fiji-dollar",
    "FKP" to "Falklâneilânske pûn",
    "FRF" to "Franske franc",
    "GBP" to "Brits pûn",
    "GEK" to "Georgyske kupon larit",
    "GEL" to "Georgyske lari",
    "GHC" to "Ghanese cedi (1979–2007)",
    "GHS" to "Ghanese cedi",
    "GIP" to "Gibraltarees pûn",
    "GMD" to "Gambiaanske dalasi",
    "GNF" to "Guinese franc",
    "GNS" to "Guinese syli",
    "GQE" to "Equatoriaal-Guinese ekwele guineana",
    "GRD" to "Grykse drachme",
    "GTQ" to "Guatemalteekse quetzal",
    "GWE" to "Portugees-Guinese escudo",
    "GWP" to "Guinee-Bissause peso",
    "GYD" to "Guyaanske dollar",
    "HKD" to "Hongkongske dollar",
    "HNL" to "Hondurese lempira",
    "HRD" to "Kroatyske dinar",
    "HRK" to "Kroatyske kuna",
    "HTG" to "Haïtiaanske gourde",
    "HUF" to "Hongaarse forint",
    "IDR" to "Indonesyske roepia",
    "IEP" to "Ierske pûn",
    "ILP" to "Israëlysk pûn",
    "ILS" to "Israëlyske nieuwe shekel",
    "INR" to "Indiase roepie",
    "IQD" to "Iraakse dinar",
    "IRR" to "Iraanske rial",
    "ISK" to "Yslânske kroon",
    "ITL" to "Italiaanske lire",
    "JMD" to "Jamaikaanske dollar",
    "JOD" to "Jordaanske dinar",
    "JPY" to "Japanse yen",
    "KES" to "Keniaanske shilling",
    "KGS" to "Kirgizyske som",
    "KHR" to "Kambodjaanske riel",
    "KMF" to "Komorese frank",
    "KPW" to "Noard-Koreaanske won",
    "KRH" to "Sûd-Koreaanske hwan (1953–1962)",
    "KRO" to "Alde Sûd-Koreaanske won (1945–1953)",
    "KRW" to "Sûd-Koreaanske won",
    "KWD" to "Koeweitse dinar",
    "KYD" to "Caymaneilânske dollar",
    "KZT" to "Kazachstaanske tenge",
    "LAK" to "Laotiaanske kip",
    "LBP" to "Libaneeske pûn",
    "LKR" to "Sri Lankaanske roepie",
    "LRD" to "Liberiaanske dollar",
    "LSL" to "Lesothaanske loti",
    "LTL" to "Litouwse litas",
    "LTT" to "Litouwse talonas",
    "LUC" to "Lúksemboargske convertibele franc",
    "LUF" to "Lúksemboargske frank",
    "LUL" to "Lúksemboargske finansjele franc",
    "LVL" to "Letse lats",
    "LVR" to "Letse roebel",
    "LYD" to "Libyske dinar",
    "MAD" to "Marokkaanske dirham",
    "MAF" to "Marokkaanske franc",
    "MCF" to "Monegaskyske frank",
    "MDC" to "Moldavyske cupon",
    "MDL" to "Moldavyske leu",
    "MGA" to "Malagassyske ariary",
    "MGF" to "Malagassyske franc",
    "MKD" to "Macedonyske denar",
    "MKN" to "Macedonyske denar (1992–1993)",
    "MLF" to "Malinese franc",
    "MMK" to "Myanmarese kyat",
    "MNT" to "Mongoalske tugrik",
    "MOP" to "Macause pataca",
    "MRO" to "Mauritaanske ouguiya (1973–2017)",
    "MRU" to "Mauritaanske ouguiya",
    "MTL" to "Maltese lire",
    "MTP" to "Maltees pûn",
    "MUR" to "Mauritiaanske roepie",
    "MVR" to "Maldivyske rufiyaa",
    "MWK" to "Malawyske kwacha",
    "MXN" to "Meksikaanske peso",
    "MXP" to "Meksikaanske sulveren peso (1861–1992)",
    "MXV" to "Meksikaanske unidad de inversion (UDI)",
    "MYR" to "Maleisyske ringgit",
    "MZE" to "Mozambikaanske escudo",
    "MZM" to "Alde Mozambikaanske metical",
    "MZN" to "Mozambikaanske metical",
    "NAD" to "Namibyske dollar",
    "NGN" to "Nigeriaanske naira",
    "NIC" to "Nicaraguaanske córdoba (1988–1991)",
    "NIO" to "Nicaraguaanske córdoba",
    "NLG" to "Nederlânske gûne",
    "NOK" to "Noarske kroon",
    "NPR" to "Nepalese roepie",
    "NZD" to "Nij-Seelânske dollar",
    "OMR" to "Omaanske rial",
    "PAB" to "Panamese balboa",
    "PEI" to "Peruaanske inti",
    "PEN" to "Peruaanske sol",
    "PES" to "Peruaanske sol (1863–1985)",
    "PGK" to "Papuaanske kina",
    "PHP" to "Filipynske peso",
    "PKR" to "Pakistaanske roepie",
    "PLN" to "Poalske zloty",
    "PLZ" to "Poalske zloty (1950–1995)",
    "PTE" to "Portugeeske escudo",
    "PYG" to "Paraguayaanske guarani",
    "QAR" to "Katarese rial",
    "RHD" to "Rhodesyske dollar",
    "ROL" to "Alde Roemeenske leu",
    "RON" to "Roemeenske leu",
    "RSD" to "Servyske dinar",
    "RUB" to "Russyske roebel",
    "RUR" to "Russyske roebel (1991–1998)",
    "RWF" to "Rwandese frank",
    "SAR" to "Saoedi-Arabyske riyal",
    "SBD" to "Salomon-dollar",
    "SCR" to "Seychelse roepie",
    "SDD" to "Soedaneeske dinar",
    "SDG" to "Soedaneeske pûn",
    "SDP" to "Soedaneeske pûn (1957–1998)",
    "SEK" to "Sweedske kroon",
    "SGD" to "Singaporese dollar",
    "SHP" to "Sint-Heleenske pûn",
    "SIT" to "Sloveenske tolar",
    "SKK" to "Slowaakse koruna",
    "SLE" to "Sierraleoonse leone",
    "SLL" to "Sierraleoonse leone (1964—2022)",
    "SOS" to "Somalyske shilling",
    "SRD" to "Surinaamske dollar",
    "SRG" to "Surinaamske gulden",
    "SSP" to "Sûd-Soedaneeske pûn",
    "STD" to "Santomese dobra (1977–2017)",
    "STN" to "Santomese dobra",
    "SUR" to "Sovjet-roebel",
    "SVC" to "Salvadoraanske colón",
    "SYP" to "Syrysk pûn",
    "SZL" to "Swazyske lilangeni",
    "THB" to "Thaise baht",
    "TJR" to "Tadzjikistaanske roebel",
    "TJS" to "Tadzjikistaanske somoni",
    "TMM" to "Turkmeense manat (1993–2009)",
    "TMT" to "Turkmeense manat",
    "TND" to "Tunesyske dinar",
    "TOP" to "Tongaanske paʻanga",
    "TPE" to "Timorese escudo",
    "TRL" to "Turkse lire",
    "TRY" to "Turkse lira",
    "TTD" to "Trinidad en Tobago-dollar",
    "TWD" to "Nije Taiwanese dollar",
    "TZS" to "Tanzaniaanske shilling",
    "UAH" to "Oekraïense hryvnia",
    "UAK" to "Oekraïense karbovanetz",
    "UGS" to "Oegandese shilling (1966–1987)",
    "UGX" to "Oegandese shilling",
    "USD" to "Amerikaanske dollar",
    "USN" to "Amerikaanske dollar (folgjende dei)",
    "USS" to "Amerikaanske dollar (zelfde dei)",
    "UYI" to "Uruguayaanske peso en geïndexeerde eenheden",
    "UYP" to "Uruguayaanske peso (1975–1993)",
    "UYU" to "Uruguayaanske peso",
    "UZS" to "Oezbekistaanske sum",
    "VEB" to "Fenezolaanske bolivar (1871–2008)",
    "VEF" to "Fenezolaanske bolivar (2008–2018)",
    "VES" to "Fenezolaanske bolivar",
    "VND" to "Fietnameeske dong",
    "VNN" to "Alde Fietnameeske dong (1978–1985)",
    "VUV" to "Vanuatuaanske vatu",
    "WST" to "Samoaanske tala",
    "XAF" to "CFA-frank",
    "XAG" to "Sulver",
    "XAU" to "Goud",
    "XBA" to "Europeeske gearfoege ienheid",
    "XBB" to "Europeeske monetaire ienheid",
    "XBC" to "Europeeske rekkenienheid (XBC)",
    "XBD" to "Europeeske rekkenienheid (XBD)",
    "XCD" to "East-Karibyske dollar",
    "XDR" to "Special Drawing Rights",
    "XEU" to "European Currency Unit",
    "XFO" to "Franse gouden franc",
    "XFU" to "Franse UIC-franc",
    "XOF" to "CFA-franc BCEAO",
    "XPD" to "Palladium",
    "XPF" to "CFP-franc",
    "XPT" to "Platina",
    "XRE" to "RINET-fondsen",
    "XSU" to "Sucre",
    "XTS" to "Valutacode voor testdoeleinden",
    "XUA" to "ADB-rekkenienheid",
    "XXX" to "Unbekende muntienheid",
    "YDD" to "Jemenityske dinar",
    "YER" to "Jemenityske rial",
    "YUD" to "Joegoslavyske harde dinar",
    "YUM" to "Joegoslavyske noviy-dinar",
    "YUN" to "Joegoslavyske convertibele dinar",
    "YUR" to "Joegoslavyske herfoarme dinar (1992–1993)",
    "ZAL" to "Sûd-Afrikaanske rand (finansjeel)",
    "ZAR" to "Sûd-Afrikaanske rand",
    "ZMK" to "Sambiaanske kwacha (1968–2012)",
    "ZMW" to "Sambiaanske kwacha",
    "ZRN" to "Saïreeske nije Saïre",
    "ZRZ" to "Saïreeske Saïre",
    "ZWD" to "Simbabwaanske dollar",
    "ZWL" to "Simbabwaanske dollar (2009)",
    "ZWR" to "Simbabwaanske dollar (2008)",
  ) }

  val ga: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Peseta Andóra",
    "AED" to "Dirham Aontas na nÉimíríochtaí Arabacha",
    "AFA" to "Afgainí (1927–2002)",
    "AFN" to "Afghani na hAfganastáine",
    "ALK" to "Lek na hAlbáine (1946–1965)",
    "ALL" to "Lek na hAlbáine",
    "AMD" to "Dram na hAirméine",
    "ANG" to "Gildear Aintillí na hÍsiltíre",
    "AOA" to "Kwanza Angóla",
    "AOK" to "Kwanza Angólach (1977–1990)",
    "AON" to "Kwanza Nua Angólach (1990–2000)",
    "AOR" to "Kwanza Reajustado Angólach (1995–1999)",
    "ARA" to "Austral Airgintíneach",
    "ARL" to "Peso Ley na hAirgintíne (1970–1983)",
    "ARM" to "Peso na hAirgintíne (1881–1970)",
    "ARP" to "Peso na hAirgintíne (1983–1985)",
    "ARS" to "Peso na hAirgintíne",
    "ATS" to "Scilling na hOstaire",
    "AUD" to "Dollar na hAstráile",
    "AWG" to "Flóirín Arúba",
    "AZM" to "Manat na hAsarbaiseáine (1993–2006)",
    "AZN" to "Manat na hAsarbaiseáine",
    "BAD" to "Dínear Bhoisnia-Heirseagaivéin (1992–1994)",
    "BAM" to "Marg Inmhalartaithe na Boisnia-Heirseagaivéine",
    "BBD" to "Dollar Bharbadós",
    "BDT" to "Taka na Banglaidéise",
    "BEC" to "Franc na Beilge (inmhalartaithe)",
    "BEF" to "Franc Beilgeach",
    "BEL" to "Franc na Beilge (airgeadais)",
    "BGL" to "Lev Crua na Bulgáire",
    "BGM" to "lev sóisialach na Bulgáire",
    "BGN" to "Lev na Bulgáire",
    "BGO" to "Lev na Bulgáire (1879–1952)",
    "BHD" to "Dinar Bhairéin",
    "BIF" to "Franc na Burúine",
    "BMD" to "Dollar Bheirmiúda",
    "BND" to "Dollar Bhrúiné",
    "BOB" to "Boliviano",
    "BOP" to "Peso na Bolaive",
    "BOV" to "Mvdol na Bolaive",
    "BRB" to "Cruzeiro Nua na Brasaíle (1967–1986)",
    "BRC" to "Cruzado na Brasaíle (1986–1989)",
    "BRE" to "Cruzeiro na Brasaíle (1990–1993)",
    "BRL" to "Real na Brasaíle",
    "BRN" to "Cruzado Nua na Brasaíle (1989–1990)",
    "BRR" to "Cruzeiro na Brasaíle (1993–1994)",
    "BRZ" to "Cruzeiro na Brasaíle (1942–1967)",
    "BSD" to "Dollar na mBahámaí",
    "BTN" to "Ngultrum na Bútáine",
    "BUK" to "Kyat Bhurma",
    "BWP" to "Pula na Botsuáine",
    "BYB" to "Rúbal Nua na Bealarúise (1994–1999)",
    "BYN" to "Rúbal na Bealarúise",
    "BYR" to "Rúbal na Bealarúise (2000–2016)",
    "BZD" to "Dollar na Beilíse",
    "CAD" to "Dollar Cheanada",
    "CDF" to "Franc an Chongó",
    "CHE" to "Euro WIR",
    "CHF" to "Franc na hEilvéise",
    "CHW" to "Franc WIR",
    "CLE" to "Escudo na Sile",
    "CLF" to "Unidades de Fomento na Sile",
    "CLP" to "Peso na Sile",
    "CNH" to "Yuan na Síne (seachairgeadra)",
    "CNY" to "Yuan na Síne",
    "COP" to "Peso na Colóime",
    "CRC" to "Colón Chósta Ríce",
    "CSD" to "Dinar na Seirbia (2002–2006)",
    "CSK" to "Koruna Crua na Seicslóvaice",
    "CUC" to "Peso Inmhalartaithe Chúba",
    "CUP" to "Peso Chúba",
    "CVE" to "Escudo Rinn Verde",
    "CYP" to "Punt na Cipire",
    "CZK" to "Koruna Phoblacht na Seice",
    "DDM" to "Marc Ghearmáin an Oirthir",
    "DEM" to "Deutsche Mark",
    "DJF" to "Franc Djibouti",
    "DKK" to "Coróin na Danmhairge",
    "DOP" to "Peso na Poblachta Doiminicí",
    "DZD" to "Dinar na hAilgéire",
    "ECS" to "Sucre Eacuadóir",
    "ECV" to "Unidad de Valor Constante (UVC) Eacuadóir",
    "EEK" to "Kroon na hEastóine",
    "EGP" to "Punt na hÉigipte",
    "ERN" to "Nakfa na hEiritré",
    "ESP" to "Peseta na Spáinne",
    "ETB" to "Birr na hAetóipe",
    "EUR" to "Euro",
    "FIM" to "Markka Fionnlannach",
    "FJD" to "Dollar Fhidsí",
    "FKP" to "Punt Oileáin Fháclainne",
    "FRF" to "Franc na Fraince",
    "GBP" to "Punt Steirling",
    "GEK" to "Kupon Larit na Grúise",
    "GEL" to "Lari na Seoirsia",
    "GHC" to "Cedi Ghána (1979–2007)",
    "GHS" to "Cedi Ghána",
    "GIP" to "Punt Ghiobráltar",
    "GMD" to "Dalasi na Gaimbia",
    "GNF" to "Franc na Guine",
    "GNS" to "Syli Guine",
    "GQE" to "Ekwele Guineana na Guine Meánchiorclaí",
    "GRD" to "Drachma Gréagach",
    "GTQ" to "Quetzal Ghuatamala",
    "GWE" to "Escudo na Guine Portaingéalaí",
    "GWP" to "Peso Guine-Bhissau",
    "GYD" to "Dollar na Guáine",
    "HKD" to "Dollar Hong Cong",
    "HNL" to "Lempira Hondúras",
    "HRD" to "Dínear na Cróite",
    "HRK" to "Kuna na Cróite",
    "HTG" to "Gourde Háítí",
    "HUF" to "Forint na hUngáire",
    "IDR" to "Rupiah na hIndinéise",
    "IEP" to "Punt Éireannach",
    "ILP" to "Punt Iosraelach",
    "ILS" to "Seiceal Nua Iosrael",
    "INR" to "Rúipí na hIndia",
    "IQD" to "Dinar na hIaráice",
    "IRR" to "Rial na hIaráine",
    "ISK" to "Króna na hÍoslainne",
    "ITL" to "Lira na hIodáile",
    "JMD" to "Dollar na hIamáice",
    "JOD" to "Dinar na hIordáine",
    "JPY" to "Yen na Seapáine",
    "KES" to "Scilling na Céinia",
    "KGS" to "Som na Cirgeastáine",
    "KHR" to "Riel na Cambóide",
    "KMF" to "Franc Oileáin Chomóra",
    "KPW" to "Won na Cóiré Thuaidh",
    "KRW" to "Won na Cóiré Theas",
    "KWD" to "Dinar Chuáit",
    "KYD" to "Dollar Oileáin Cayman",
    "KZT" to "Tenge na Casacstáine",
    "LAK" to "Kip Laos",
    "LBP" to "Punt na Liobáine",
    "LKR" to "Rúipí Shrí Lanca",
    "LRD" to "Dollar na Libéire",
    "LSL" to "Loti Leosóta",
    "LTL" to "Litas na Liotuáine",
    "LTT" to "Talonas Liotuánach",
    "LUC" to "Franc Inmhalartach Lucsamburgach",
    "LUF" to "Franc Lucsamburg",
    "LVL" to "Lats na Laitvia",
    "LVR" to "Rúbal na Laitvia",
    "LYD" to "Dinar na Libia",
    "MAD" to "Dirham Mharacó",
    "MAF" to "Franc Mharacó",
    "MDL" to "Leu na Moldóive",
    "MGA" to "Ariary Mhadagascar",
    "MGF" to "Franc Madagascar",
    "MKD" to "Denar na Macadóine",
    "MLF" to "Franc Mhailí",
    "MMK" to "Kyat Mhaenmar",
    "MNT" to "Tugrik na Mongóile",
    "MOP" to "Pataca Mhacao",
    "MRO" to "Ouguiya na Máratáine (1973–2017)",
    "MRU" to "Ouguiya na Máratáine",
    "MTL" to "Lira Mhálta",
    "MTP" to "Punt Mhálta",
    "MUR" to "Rúipí Oileán Mhuirís",
    "MVP" to "Rúipí Oileáin Mhaildíve",
    "MVR" to "Rufiyaa Oileáin Mhaildíve",
    "MWK" to "Kwacha na Maláive",
    "MXN" to "Peso Mheicsiceo",
    "MXP" to "Peso Airgid Mheicsiceo (1861–1992)",
    "MXV" to "Aonad Infheistíochta Meicsiceach",
    "MYR" to "Ringgit na Malaeisia",
    "MZE" to "Escudo Mósaimbíce",
    "MZM" to "Metical Mósaimbíce",
    "MZN" to "Metical Mhósaimbíc",
    "NAD" to "Dollar na Namaibe",
    "NGN" to "Naira na Nigéire",
    "NIC" to "Córdoba Nicearagua (1988–1991)",
    "NIO" to "Córdoba Nicearagua",
    "NLG" to "Guilder Ísiltíreach",
    "NOK" to "Coróin na hIorua",
    "NPR" to "Rúipí Neipeal",
    "NZD" to "Dollar na Nua-Shéalainne",
    "OMR" to "Rial Óman",
    "PAB" to "Balboa Phanama",
    "PEI" to "Inti Pheiriú",
    "PEN" to "Sol Pheiriú",
    "PES" to "Sol Pheiriú (1863–1965)",
    "PGK" to "Kina Nua-Ghuine Phapua",
    "PHP" to "Peso na nOileán Filipíneach",
    "PKR" to "Rúipí na Pacastáine",
    "PLN" to "Zloty na Polainne",
    "PLZ" to "Zloty Polannach (1950–1995)",
    "PTE" to "Escudo na Portaingéile",
    "PYG" to "Guaraní Pharagua",
    "QAR" to "Riyal Chatar",
    "ROL" to "Leu na Rómáine (1952–2006)",
    "RON" to "Leu na Rómáine",
    "RSD" to "Dinar na Seirbia",
    "RUB" to "Rúbal na Rúise",
    "RUR" to "Rúbal na Rúise (1991–1998)",
    "RWF" to "Franc Ruanda",
    "SAR" to "Riyal na hAraibe Sádaí",
    "SBD" to "Dollar Oileáin Sholomón",
    "SCR" to "Rúipí na Séiséal",
    "SDD" to "Dinar na Súdáine (1992–2007)",
    "SDG" to "Punt na Súdáine",
    "SDP" to "Punt na Súdáine (1957–1998)",
    "SEK" to "Coróin na Sualainne",
    "SGD" to "Dollar Shingeapór",
    "SHP" to "Punt San Héilin",
    "SIT" to "Tolar na Slóivéine",
    "SKK" to "Koruna na Slóvaice",
    "SLE" to "Leone Shiarra Leon",
    "SLL" to "Leone Shiarra Leon (1964—2022)",
    "SOS" to "Scilling na Somáile",
    "SRD" to "Dollar Shuranam",
    "SRG" to "Gildear Shuranam",
    "SSP" to "Punt na Súdáine Theas",
    "STD" to "Dobra São Tomé agus Príncipe (1977–2017)",
    "STN" to "Dobra São Tomé agus Príncipe",
    "SUR" to "Rúbal an Aontais Shóivéadaigh",
    "SVC" to "Colón na Salvadóire",
    "SYP" to "Punt na Siria",
    "SZL" to "Lilangeni na Suasalainne",
    "THB" to "Baht na Téalainne",
    "TJR" to "Rúbal na Táidsíceastáine",
    "TJS" to "Somoni na Táidsíceastáine",
    "TMM" to "Manat na Tuircméanastáine (1993–2009)",
    "TMT" to "Manat na Tuircméanastáine",
    "TND" to "Dinar na Túinéise",
    "TOP" to "Paʻanga Thonga",
    "TPE" to "Escudo Tíomóir",
    "TRL" to "Lira na Tuirce (1922–2005)",
    "TRY" to "Lira na Tuirce",
    "TTD" to "Dollar Oileán na Tríonóide agus Tobága",
    "TWD" to "Dollar Nua na Téaváine",
    "TZS" to "Scilling na Tansáine",
    "UAH" to "Hryvnia na hÚcráine",
    "UAK" to "Karbovanets Úcránach",
    "UGS" to "Scilling Uganda (1966–1987)",
    "UGX" to "Scilling Uganda",
    "USD" to "Dollar S.A.M.",
    "USN" to "Dollar S.A.M. (an chéad lá eile)",
    "USS" to "Dollar S.A.M. (an lá céanna)",
    "UYP" to "Peso Uragua (1975–1993)",
    "UYU" to "Peso Uragua",
    "UZS" to "Sum na hÚisbéiceastáine",
    "VEB" to "Bolívar Veiniséala (1871–2008)",
    "VEF" to "Bolívar Veiniséala (2008–2018)",
    "VES" to "Bolívar Veiniséala",
    "VND" to "Dong Vítneam",
    "VNN" to "Dong Vítneam (1978–1985)",
    "VUV" to "Vatu Vanuatú",
    "WST" to "Tala Shamó",
    "XAF" to "Franc CFA na hAfraice Láir",
    "XAG" to "Airgead",
    "XAU" to "Ór",
    "XBA" to "Aonad Ilchodach Eorpach",
    "XBB" to "Aonad Airgeadaíochta Eorpach",
    "XBC" to "Aonad Cuntais Eorpach (XBC)",
    "XBD" to "Aonad Cuntais Eorpach (XBD)",
    "XCD" to "Dollar na Cairibe Thoir",
    "XDR" to "Cearta Speisialta Tarraingthe",
    "XEU" to "Aonad Airgeadra Eorpach",
    "XFO" to "Franc Ór Francach",
    "XFU" to "UIC-Franc Francach",
    "XOF" to "Franc CFA Iarthar na hAfraice",
    "XPD" to "Pallaidiam",
    "XPF" to "Franc CFP",
    "XPT" to "Platanam",
    "XXX" to "Airgeadra Anaithnid",
    "YDD" to "Dínear Éimin",
    "YER" to "Rial Éimin",
    "YUD" to "Dínear Crua Iúgslavach (1966–1990)",
    "YUM" to "Dínear Nua Iúgslavach (1994–2002)",
    "YUN" to "Dinar Inmhalartaithe Iúgslavach (1990–1992)",
    "YUR" to "Dinar Leasaithe na hIúgsláive (1992–1993)",
    "ZAL" to "Rand na hAfraice Theas (airgeadúil)",
    "ZAR" to "Rand na hAfraice Theas",
    "ZMK" to "Kwacha Saimbiach (1968–2012)",
    "ZMW" to "Kwacha na Saimbia",
    "ZRN" to "Zaire Nua Sáíreach",
    "ZRZ" to "Zaire Sáíreach",
    "ZWD" to "Dollar Siombábach (1980–2008)",
    "ZWL" to "Dollar na Siombáibe (2009)",
  ) }

  val ga_GB: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gaa: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gd: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Peseta Andorrach",
    "AED" to "Dirham nan Iomaratan Arabach Aonaichte",
    "AFA" to "Afghani Afghanach (1927–2002)",
    "AFN" to "Afghani Afghanach",
    "ALK" to "Lek Albàineach (1946–1965)",
    "ALL" to "Lek Albàineach",
    "AMD" to "Dram Airmeineach",
    "ANG" to "Gulden Eileanan Aintilia nan Tìrean Ìsle",
    "AOA" to "Kwanza Angòlach",
    "AOK" to "Kwanza Angòlach (1977–1991)",
    "AON" to "Kwanza ùr Angòlach (1990–2000)",
    "AOR" to "Kwanza ath-ghleusaichte Angòlach (1995–1999)",
    "ARA" to "Austral Argantaineach",
    "ARL" to "Peso ley Argantaineach (1970–1983)",
    "ARM" to "Peso Argantaineach (1881–1970)",
    "ARP" to "Peso Argantaineach (1983–1985)",
    "ARS" to "Peso Argantaineach",
    "ATS" to "Schilling Ostaireach",
    "AUD" to "Dolar Astràilianach",
    "AWG" to "Florin Arùbach",
    "AZM" to "Manat Asarbaideànach (1993–2006)",
    "AZN" to "Manat Asarbaideànach",
    "BAD" to "Dinar Bhosna agus Hearsagobhana (1992–1994)",
    "BAM" to "Mark iompachail Bhosna agus Hearsagobhana",
    "BAN" to "Dinar ùr Bhosna agus Hearsagobhana (1994–1997)",
    "BBD" to "Dolar Barbadach",
    "BDT" to "Taka Bangladaiseach",
    "BEC" to "Franc Beilgeach (iompachail)",
    "BEF" to "Franc Beilgeach",
    "BEL" to "Franc Beilgeach (ionmhasail)",
    "BGL" to "Lev cruaidh Bulgarach",
    "BGM" to "Lev sòisealach Bulgarach",
    "BGN" to "Lev Bulgarach",
    "BGO" to "Lev Bulgarach (1879–1952)",
    "BHD" to "Dinar Bachraineach",
    "BIF" to "Franc Burundaidheach",
    "BMD" to "Dolar Bearmùdach",
    "BND" to "Dolar Brùnaigheach",
    "BOB" to "Boliviano Boilibhiach",
    "BOL" to "Boliviano Boilibhiach (1863–1963)",
    "BOP" to "Peso Boilibhiach",
    "BOV" to "Mvdol Boilibhiach",
    "BRB" to "Cruzeiro ùr Braisileach (1967–1986)",
    "BRC" to "Cruzado Braisileach (1986–1989)",
    "BRE" to "Cruzeiro Braisileach (1990–1993)",
    "BRL" to "Real Braisileach",
    "BRN" to "Cruzado ùr Braisileach (1989–1990)",
    "BRR" to "Cruzeiro Braisileach (1993–1994)",
    "BRZ" to "Cruzeiro Braisileach (1942–1967)",
    "BSD" to "Dolar Bathamach",
    "BTN" to "Ngultrum Butànach",
    "BUK" to "Kyat Burmach",
    "BWP" to "Pula Botsuanach",
    "BYB" to "Rùbal ùr Bealaruiseach (1994–1999)",
    "BYN" to "Rùbal Bealaruiseach",
    "BYR" to "Rùbal Bealaruiseach (2000–2016)",
    "BZD" to "Dolar Beilìseach",
    "CAD" to "Dolar Canadach",
    "CDF" to "Franc Congothach",
    "CHE" to "Eòro WIR",
    "CHF" to "Franc Eilbheiseach",
    "CHW" to "Franc WIR",
    "CLE" to "Escudo Sileach",
    "CLF" to "Aonad cunntasachd Sileach (UF)",
    "CLP" to "Peso Sileach",
    "CNH" to "Yuan Sìneach (far-thìreach)",
    "CNX" to "Dolar an t-sluagh-bhanca Shìnich",
    "CNY" to "Yuan Sìneach",
    "COP" to "Peso Coloimbeach",
    "COU" to "Aonad fìor-luach Coloimbeach",
    "CRC" to "Colón Costa Rìceach",
    "CSD" to "Dinar Sèirbeach (2002–2006)",
    "CSK" to "Koruna cruaidh Seic-Slòbhacach",
    "CUC" to "Peso iompachail Cùbach",
    "CUP" to "Peso Cùbach",
    "CVE" to "Escudo a’ Chip Uaine",
    "CYP" to "Punnd Cìoprasach",
    "CZK" to "Koruna Seiceach",
    "DDM" to "Mark na Gearmailte an Ear",
    "DEM" to "Mark Gearmailteach",
    "DJF" to "Franc Diobùtaidheach",
    "DKK" to "Krone Danmhairgeach",
    "DOP" to "Peso Doiminiceach",
    "DZD" to "Dinar Aildireach",
    "ECS" to "Sucre Eacuadorach",
    "ECV" to "Aonad luach chunbhalaich Eacuadorach",
    "EEK" to "Kroon Eastoineach",
    "EGP" to "Punnd Èipheiteach",
    "ERN" to "Nakfa Eartrach",
    "ESA" to "Peseta Spàinnteach (cunntas A)",
    "ESB" to "Peseta Spàinnteach (cunntas iompachail)",
    "ESP" to "Peseta Spàinnteach",
    "ETB" to "Birr Itiopach",
    "EUR" to "Eòro",
    "FIM" to "Markka Fionnlannach",
    "FJD" to "Dolar Fìditheach",
    "FKP" to "Punnd Fàclannach",
    "FRF" to "Franc Frangach",
    "GBP" to "Punnd Sasannach",
    "GEK" to "Kupon larit Cairtbheileach",
    "GEL" to "Lari Cairtbheileach",
    "GHC" to "Cedi Gànach (1979–2007)",
    "GHS" to "Cedi Gànach",
    "GIP" to "Punnd Diobraltarach",
    "GMD" to "Dalasi Gaimbitheach",
    "GNF" to "Franc Ginitheach",
    "GNS" to "Syli Ginitheach",
    "GQE" to "Ekwele Gini Meadhan-Chriosaich",
    "GRD" to "Drachma Greugach",
    "GTQ" to "Quetzal Guatamalach",
    "GWE" to "Escudo Gini na Portagaile",
    "GWP" to "Peso Gini-Biosothach",
    "GYD" to "Dolar Guidheànach",
    "HKD" to "Dolar Hong Kong",
    "HNL" to "Lempira Hondùrach",
    "HRD" to "Dinar Cròthaiseach",
    "HRK" to "Kuna Cròthaiseach",
    "HTG" to "Gourde Haidhteach",
    "HUF" to "Forint Ungaireach",
    "IDR" to "Rupiah Innd-Innseach",
    "IEP" to "Punnd Èireannach",
    "ILP" to "Punnd Iosraeleach",
    "ILR" to "Secel Iosraeleach (1980–1985)",
    "ILS" to "Secel ùr Iosraeleach",
    "INR" to "Rupee Innseanach",
    "IQD" to "Dinar Ioràcach",
    "IRR" to "Rial Iorànach",
    "ISJ" to "Króna Innis Tìleach (1918–1981)",
    "ISK" to "Króna Innis Tìleach",
    "ITL" to "Lira Eadailteach",
    "JMD" to "Dolar Diameugach",
    "JOD" to "Dinar Iòrdanach",
    "JPY" to "Yen Seapanach",
    "KES" to "Shilling Ceineach",
    "KGS" to "Som Cìorgasach",
    "KHR" to "Riel Cambuideach",
    "KMF" to "Franc Comorosach",
    "KPW" to "Won Choirèa a Tuath",
    "KRH" to "Hwan Choirèa a Deas (1953–1962)",
    "KRO" to "Won Choirèa a Deas (1945–1953)",
    "KRW" to "Won Choirèa a Deas",
    "KWD" to "Dinar Cuibhèiteach",
    "KYD" to "Dolar Caimeanach",
    "KZT" to "Tenge Casachach",
    "LAK" to "Kip Làthosach",
    "LBP" to "Punnd Leabanach",
    "LKR" to "Rupee Sri Lancach",
    "LRD" to "Dolar Libèireach",
    "LSL" to "Loti Leasotach",
    "LTL" to "Litas Liotuaineach",
    "LTT" to "Talonas Liotuaineach",
    "LUC" to "Franc iompachail Lugsamburgach",
    "LUF" to "Franc Lugsamburgach",
    "LUL" to "Franc ionmhasail Lugsamburgach",
    "LVL" to "Lats Laitbheach",
    "LVR" to "Rùbal Laitbheach",
    "LYD" to "Dinar Libitheach",
    "MAD" to "Dirham Morocach",
    "MAF" to "Franc Morocach",
    "MCF" to "Franc Monacach",
    "MDC" to "Cupon Moldobhach",
    "MDL" to "Leu Moldobhach",
    "MGA" to "Ariary Madagasgarach",
    "MGF" to "Franc Madagasgarach",
    "MKD" to "Denar Masadonach",
    "MKN" to "Denar Masadonach (1992–1993)",
    "MLF" to "Franc Màilitheach",
    "MMK" to "Kyat Miànmarach",
    "MNT" to "Tugrik Mongolach",
    "MOP" to "Pataca Macàthuach",
    "MRO" to "Ouguiya Moratàineach (1973–2017)",
    "MRU" to "Ouguiya Moratàineach",
    "MTL" to "Lira Maltach",
    "MTP" to "Punnd Maltach",
    "MUR" to "Rupee Moiriseasach",
    "MVP" to "Rupee Maladaibheach",
    "MVR" to "Rufiyaa Maladaibheach",
    "MWK" to "Kwacha Malabhaidheach",
    "MXN" to "Peso Meagsagach",
    "MXP" to "Peso airgid Meagsagach (1861–1992)",
    "MXV" to "Aonad inbheistidh Meagsagach",
    "MYR" to "Ringgit Malaidheach",
    "MZE" to "Escudo Mòsaimbiceach",
    "MZM" to "Metical Mòsaimbiceach (1980–2006)",
    "MZN" to "Metical Mòsaimbiceach",
    "NAD" to "Dolar Naimibitheach",
    "NGN" to "Naira Nigèiriach",
    "NIC" to "Córdoba Niocaragach (1988–1991)",
    "NIO" to "Córdoba Niocaragach",
    "NLG" to "Gulden Duitseach",
    "NOK" to "Krone Nirribheach",
    "NPR" to "Rupee Neapàlach",
    "NZD" to "Dolar Shealainn Nuaidh",
    "OMR" to "Rial Omànach",
    "PAB" to "Balboa Panamach",
    "PEI" to "Inti Pearùthach",
    "PEN" to "Sol Pearùthach",
    "PES" to "Sol Pearùthach (1863–1965)",
    "PGK" to "Kina Ghini Nuaidh Paputhaiche",
    "PHP" to "Peso Filipineach",
    "PKR" to "Rupee Pagastànach",
    "PLN" to "Złoty Pòlainneach",
    "PLZ" to "Złoty Pòlainneach (1950–1995)",
    "PTE" to "Escudo Portagaileach",
    "PYG" to "Guaraní Paraguaidheach",
    "QAR" to "Rial Catarach",
    "RHD" to "Dolar Rhodesiach",
    "ROL" to "Leu Romàineach (1952–2006)",
    "RON" to "Leu Romàineach",
    "RSD" to "Dinar Sèirbeach",
    "RUB" to "Rùbal Ruiseach",
    "RUR" to "Rùbal Ruiseach (1991–1998)",
    "RWF" to "Franc Rubhandach",
    "SAR" to "Riyal Sabhdach",
    "SBD" to "Dolar Eileanan Sholaimh",
    "SCR" to "Rupee Seiseallach",
    "SDD" to "Dinar Sudànach (1992–2007)",
    "SDG" to "Punnd Sudànach",
    "SDP" to "Punnd Sudànach (1957–1998)",
    "SEK" to "Krona Suaineach",
    "SGD" to "Dolar Singeapòrach",
    "SHP" to "Punnd Eilean Naomh Eilidh",
    "SIT" to "Tolar Slòbhaineach",
    "SKK" to "Koruna Slòbhacach",
    "SLE" to "Leone Siarra Leòmhannach ùr",
    "SLL" to "Leone Siarra Leòmhannach",
    "SOS" to "Shilling Somàilitheach",
    "SRD" to "Dolar Suranamach",
    "SRG" to "Gulden Suranamach",
    "SSP" to "Punnd Sudàin a Deas",
    "STD" to "Dobra São Tomé agus Príncipe (1977–2017)",
    "STN" to "Dobra São Tomé agus Príncipe",
    "SUR" to "Rùbal Sovietach",
    "SVC" to "Colón Salbhadorach",
    "SYP" to "Punnd Siridheach",
    "SZL" to "Lilangeni Suasaidheach",
    "THB" to "Baht Tàidheach",
    "TJR" to "Rùbal Taidigeach",
    "TJS" to "Somoni Taidigeach",
    "TMM" to "Manat Turcmanach (1993–2009)",
    "TMT" to "Manat Turcmanach",
    "TND" to "Dinar Tuiniseach",
    "TOP" to "Paʻanga Tongach",
    "TPE" to "Escudo Tìomorach",
    "TRL" to "Lira Turcach (1922–2005)",
    "TRY" to "Lira Turcach",
    "TTD" to "Dolar Thrianaid agus Thobago",
    "TWD" to "Dolar ùr Taidh-Bhànach",
    "TZS" to "Shilling Tansanaidheach",
    "UAH" to "Hryvnia Ucràineach",
    "UAK" to "Karbovanets Ucràineach",
    "UGS" to "Shilling Ugandach (1966–1987)",
    "UGX" to "Shilling Ugandach",
    "USD" to "Dolar nan Stàitean Aonaichte",
    "USN" to "Dolar nan SA (an ath–latha)",
    "USS" to "Dolar nan SA (an aon latha)",
    "UYI" to "Peso Uruguaidheach (aonadan inneacsaichte)",
    "UYP" to "Peso Uruguaidheach (1975–1993)",
    "UYU" to "Peso Uruguaidheach",
    "UYW" to "Aonad inneacs tuarastail ainmeach Uruguaidh",
    "UZS" to "Som Usbagach",
    "VEB" to "Bolívar Bheinisealach (1871–2008)",
    "VED" to "Bolívar Soberano",
    "VEF" to "Bolívar Bheinisealach (2008–2018)",
    "VES" to "Bolívar Bheinisealach",
    "VND" to "Dong Bhiet-Namach",
    "VNN" to "Dong Bhiet-Namach (1978–1985)",
    "VUV" to "Vatu Vanuatuthach",
    "WST" to "Tala Samothach",
    "XAF" to "Franc CFA Meadhan-Afragach",
    "XAG" to "Airgead",
    "XAU" to "Òr",
    "XBA" to "Aonad co-dhèanta Eòrpach",
    "XBB" to "Aonad airgid Eòrpach",
    "XBC" to "Aonad cunntasachd Eòrpach (XBC)",
    "XBD" to "Aonad cunntasachd Eòrpach (XBD)",
    "XCD" to "Dolar Caraibeach earach",
    "XCG" to "Gulden Caraibeach",
    "XDR" to "Còir tarraing shònraichte",
    "XEU" to "Aonad airgeadra Eòrpach",
    "XFO" to "Franc òir Frangach",
    "XFU" to "Franc UIC Frangach",
    "XOF" to "Franc CFA Afraga an Iar",
    "XPD" to "Pallaideam",
    "XPF" to "Franc CFP",
    "XPT" to "Platanam",
    "XRE" to "Aonad maoine RINET",
    "XSU" to "Sucre",
    "XTS" to "Còd airgeadra fo dheuchainn",
    "XUA" to "Aonad cunntasachd ADB",
    "XXX" to "Airgeadra neo-aithnichte",
    "YDD" to "Dinar Eamanach",
    "YER" to "Rial Eamanach",
    "YUD" to "Dinar cruaidh Iùgoslabhach (1966–1990)",
    "YUM" to "Dinar ùr Iùgoslabhach (1994–2002)",
    "YUN" to "Dinar iompachail Iùgoslabhach (1990–1992)",
    "YUR" to "Dinar ath-leasaichte Iùgoslabhach (1992–1993)",
    "ZAL" to "Rand Afraga a Deas (ionmhasail)",
    "ZAR" to "Rand Afraga a Deas",
    "ZMK" to "Kwacha Sàimbitheach (1968–2012)",
    "ZMW" to "Kwacha Sàimbitheach",
    "ZRN" to "Zaïre ùr Zaïreach (1993–1998)",
    "ZRZ" to "Zaïre Zaïreach (1971–1993)",
    "ZWD" to "Dolar Sìombabuthach (1980–2008)",
    "ZWL" to "Dolar Sìombabuthach (2009)",
    "ZWR" to "Dolar Sìombabuthach (2008)",
  ) }

  val gez: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gez_ER: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "peseta andorrana",
    "AED" to "dirham dos Emiratos Árabes Unidos",
    "AFN" to "afgani afgán",
    "ALL" to "lek albanés",
    "AMD" to "dram armenio",
    "ANG" to "florín das Antillas Neerlandesas",
    "AOA" to "kwanza angolano",
    "ARP" to "Peso arxentino (1983–1985)",
    "ARS" to "peso arxentino",
    "AUD" to "dólar australiano",
    "AWG" to "florín de Aruba",
    "AZN" to "manat acerbaixano",
    "BAM" to "marco convertible de Bosnia e Hercegovina",
    "BBD" to "dólar de Barbados",
    "BDT" to "taka de Bangladesh",
    "BEC" to "Franco belga (convertible)",
    "BEF" to "Franco belga",
    "BEL" to "Franco belga (financeiro)",
    "BGN" to "lev búlgaro",
    "BHD" to "dinar de Bahrain",
    "BIF" to "franco burundiano",
    "BMD" to "dólar bermudano",
    "BND" to "dólar de Brunei",
    "BOB" to "boliviano",
    "BOP" to "Peso boliviano",
    "BOV" to "MVDOL boliviano",
    "BRB" to "Cruzeiro novo brasileiro (1967–1986)",
    "BRC" to "Cruzado brasileiro",
    "BRE" to "Cruzeiro brasileiro (1990–1993)",
    "BRL" to "real brasileiro",
    "BRN" to "Cruzado novo brasileiro",
    "BRR" to "Cruzeiro brasileiro",
    "BSD" to "dólar bahamés",
    "BTN" to "ngultrum butanés",
    "BWP" to "pula botswaniano",
    "BYN" to "rublo belaruso",
    "BYR" to "Rublo bielorruso (2000–2016)",
    "BZD" to "dólar belizense",
    "CAD" to "dólar canadense",
    "CDF" to "franco congolés",
    "CHF" to "franco suízo",
    "CLF" to "Unidades de fomento chilenas",
    "CLP" to "peso chileno",
    "CNH" to "iuán chinés (extracontinental)",
    "CNY" to "iuán chinés",
    "COP" to "peso colombiano",
    "CRC" to "colón costarriqueño",
    "CUC" to "peso cubano convertible",
    "CUP" to "peso cubano",
    "CVE" to "escudo caboverdiano",
    "CZK" to "coroa checa",
    "DEM" to "Marco alemán",
    "DJF" to "franco djibutiano",
    "DKK" to "coroa dinamarquesa",
    "DOP" to "peso dominicano",
    "DZD" to "dinar alxeriano",
    "ECS" to "Sucre ecuatoriano",
    "ECV" to "Unidade de valor constante ecuatoriana",
    "EGP" to "libra exipcia",
    "ERN" to "nakfa eritreo",
    "ESA" to "Peseta española (conta A)",
    "ESB" to "Peseta española (conta convertible)",
    "ESP" to "Peseta española",
    "ETB" to "birr etíope",
    "EUR" to "euro",
    "FJD" to "dólar fixiano",
    "FKP" to "libra das Illas Malvinas",
    "FRF" to "Franco francés",
    "GBP" to "libra esterlina",
    "GEL" to "lari xeorxiano",
    "GHS" to "cedi ghanés",
    "GIP" to "libra xibraltareña",
    "GMD" to "dalasi gambiano",
    "GNF" to "franco guineano",
    "GNS" to "Syli guineano",
    "GQE" to "Ekwele guineana",
    "GRD" to "Dracma grego",
    "GTQ" to "quetzal guatemalteco",
    "GYD" to "dólar güianés",
    "HKD" to "dólar de Hong Kong",
    "HNL" to "lempira hondureño",
    "HRK" to "kuna croata",
    "HTG" to "gourde haitiana",
    "HUF" to "florín húngaro",
    "IDR" to "rupia indonesia",
    "IEP" to "Libra irlandesa",
    "ILS" to "novo shequel israelí",
    "INR" to "rupia india",
    "IQD" to "dinar iraquí",
    "IRR" to "rial iraniano",
    "ISK" to "coroa islandesa",
    "ITL" to "Lira italiana",
    "JMD" to "dólar xamaicano",
    "JOD" to "dinar xordano",
    "JPY" to "ien xaponés",
    "KES" to "xilin kenyano",
    "KGS" to "som kirguiz",
    "KHR" to "riel camboxano",
    "KMF" to "franco comoriano",
    "KPW" to "won norcoreano",
    "KRW" to "won surcoreano",
    "KWD" to "dinar kuwaití",
    "KYD" to "dólar das Illas Caimán",
    "KZT" to "tenge kazako",
    "LAK" to "kip laosiano",
    "LBP" to "libra libanesa",
    "LKR" to "rupia srilankesa",
    "LRD" to "dólar liberiano",
    "LSL" to "loti de Lesoto",
    "LTL" to "Litas lituana",
    "LUC" to "Franco convertible luxemburgués",
    "LUF" to "Franco luxemburgués",
    "LUL" to "Franco financeiro luxemburgués",
    "LVL" to "Lats letón",
    "LYD" to "dinar libio",
    "MAD" to "dirham marroquí",
    "MAF" to "Franco marroquí",
    "MDL" to "leu moldovo",
    "MGA" to "ariary malgaxe",
    "MKD" to "dinar macedonio",
    "MMK" to "kyat birmano",
    "MNT" to "tugrik mongol",
    "MOP" to "pataca macaense",
    "MRO" to "Ouguiya mauritano (1973–2017)",
    "MRU" to "ouguiya mauritano",
    "MUR" to "rupia mauriciana",
    "MVR" to "rupia maldivana",
    "MWK" to "kwacha de Malawi",
    "MXN" to "peso mexicano",
    "MXP" to "Peso de prata mexicano (1861–1992)",
    "MXV" to "Unidade de inversión mexicana",
    "MYR" to "ringgit malaio",
    "MZN" to "metical mozambicano",
    "NAD" to "dólar namibio",
    "NGN" to "naira nixeriano",
    "NIC" to "Córdoba nicaragüense",
    "NIO" to "córdoba nicaraguano",
    "NLG" to "Florín holandés",
    "NOK" to "coroa norueguesa",
    "NPR" to "rupia nepalesa",
    "NZD" to "dólar neozelandés",
    "OMR" to "rial omaní",
    "PAB" to "balboa panameño",
    "PEI" to "Inti peruano",
    "PEN" to "sol peruano",
    "PES" to "Sol peruano (1863–1965)",
    "PGK" to "kina de Papúa-Nova Guinea",
    "PHP" to "peso filipino",
    "PKR" to "rupia paquistaní",
    "PLN" to "zloty polaco",
    "PTE" to "Escudo portugués",
    "PYG" to "guaraní paraguaio",
    "QAR" to "rial qatarí",
    "RON" to "leu romanés",
    "RSD" to "dinar serbio",
    "RUB" to "rublo ruso",
    "RUR" to "Rublo ruso (1991–1998)",
    "RWF" to "franco ruandés",
    "SAR" to "rial saudita",
    "SBD" to "dólar das Illas Salomón",
    "SCR" to "rupia de Seychelles",
    "SDG" to "libra sudanesa",
    "SEK" to "coroa sueca",
    "SGD" to "dólar de Singapur",
    "SHP" to "libra de Santa Helena",
    "SLE" to "leone de Serra Leoa",
    "SLL" to "leone de Serra Leoa (1964–2022)",
    "SOS" to "xilin somalí",
    "SRD" to "dólar surinamés",
    "SSP" to "libra sursudanesa",
    "STD" to "Dobra de São Tomé e Príncipe (1977–2017)",
    "STN" to "dobra de San Tomé e Príncipe",
    "SUR" to "Rublo soviético",
    "SVC" to "Colón salvadoreño",
    "SYP" to "libra siria",
    "SZL" to "lilangeni de Swazilandia",
    "THB" to "baht tailandés",
    "TJS" to "somoni taxiquistano",
    "TMT" to "manat turkmeno",
    "TND" to "dinar tunisiano",
    "TOP" to "paʻanga tongano",
    "TRY" to "lira turca",
    "TTD" to "dólar trinitense",
    "TWD" to "novo dólar taiwanés",
    "TZS" to "xilin tanzano",
    "UAH" to "hrivna ucraína",
    "UGX" to "xilin ugandés",
    "USD" to "dólar estadounidense",
    "UYI" to "Peso en unidades indexadas uruguaio",
    "UYP" to "Peso uruguaio (1975–1993)",
    "UYU" to "peso uruguaio",
    "UZS" to "som uzbeko",
    "VEB" to "Bolívar venezolano (1871–2008)",
    "VEF" to "Bolívar venezolano (2008–2018)",
    "VES" to "bolívar venezolano",
    "VND" to "dong vietnamita",
    "VUV" to "vatu vanuatiano",
    "WST" to "tala samoano",
    "XAF" to "franco CFA (BEAC)",
    "XAG" to "Prata",
    "XAU" to "Ouro",
    "XCD" to "dólar do Caribe Oriental",
    "XOF" to "franco CFA (BCEAO)",
    "XPD" to "Paladio",
    "XPF" to "franco CFP",
    "XPT" to "Platino",
    "XXX" to "moeda descoñecida",
    "YER" to "rial iemení",
    "ZAR" to "rand surafricano",
    "ZMK" to "Kwacha zambiano (1968–2012)",
    "ZMW" to "kwacha zambiano",
  ) }

  val gn: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gsw: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorranischi Peseete",
    "AED" to "UAE Dirham",
    "AFA" to "Afghani (1927–2002)",
    "AFN" to "Afghani",
    "ALL" to "Lek",
    "AMD" to "Dram",
    "ANG" to "Niderländischi-Antille-Gulde",
    "AOA" to "Kwanza",
    "AOK" to "Angolanische Kwanza (1977–1990)",
    "AON" to "Nöie Kwanza",
    "AOR" to "Kwanza Reajustado",
    "ARA" to "Argentinische Auschtral",
    "ARP" to "Argentinische Peso (1983–1985)",
    "ARS" to "Argentinische Peso",
    "ATS" to "Öschtriichische Schilling",
    "AUD" to "Auschtralische Dollar",
    "AWG" to "Aruba Florin",
    "AZM" to "Aserbeidschanische Manat (1993–2006)",
    "AZN" to "Aserbeidschanische Manat",
    "BAD" to "Bosnie-und-Herzegowina-Dinar",
    "BAM" to "Konvertierbari Mark vo Bosnie und Herzegowina",
    "BBD" to "Barbados-Dollar",
    "BDT" to "Taka",
    "BEC" to "Belgische Franc (konvertibel)",
    "BEF" to "Belgische Franc",
    "BEL" to "Belgische Finanz-Franc",
    "BGL" to "Lew (1962–1999)",
    "BGN" to "Bulgarische Lew",
    "BHD" to "Bahrain-Dinar",
    "BIF" to "Burundi-Franc",
    "BMD" to "Bermuda-Dollar",
    "BND" to "Brunei-Dollar",
    "BOB" to "Boliviano",
    "BOP" to "Bolivianische Peso",
    "BOV" to "Bolivianische Mvdol",
    "BRB" to "Brasilianische Cruzeiro Novo (1967–1986)",
    "BRC" to "Brasilianische Cruzado",
    "BRE" to "Brasilianische Cruzeiro (1990–1993)",
    "BRL" to "Brasilianische Real",
    "BRN" to "Brasilianische Cruzado Novo",
    "BRR" to "Brasilianische Cruzeiro",
    "BSD" to "Bahama-Dollar",
    "BTN" to "Bhutanische Ngultrum",
    "BUK" to "Birmanische Kyat",
    "BWP" to "Botswanische Pula",
    "BYB" to "Belarus-Rubel (1994–1999)",
    "BYN" to "Belarus Rubel",
    "BYR" to "Belarus Rubel (2000–2016)",
    "BZD" to "Belize-Dollar",
    "CAD" to "Kanadische Dollar",
    "CDF" to "Kongolesische Franc",
    "CHE" to "WIR-Euro",
    "CHF" to "Schwiizer Franke",
    "CHW" to "WIR-Franke",
    "CLF" to "Tschileenische Unidad de Fomento",
    "CLP" to "Tschileenische Peso",
    "CNY" to "Renminbi Yuan",
    "COP" to "Kolumbianische Peso",
    "COU" to "Unidad de Valor Real",
    "CRC" to "Costa Rica Colon",
    "CSD" to "Alte Serbische Dinar",
    "CSK" to "Tschechoslowakischi Chroone",
    "CUP" to "Kubanische Peso",
    "CVE" to "Kap Verde Escudo",
    "CYP" to "Zypere-Pfund",
    "CZK" to "Tschechischi Chroone",
    "DDM" to "DDR-Mark",
    "DEM" to "Tüütschi Mark",
    "DJF" to "Dschibuti-Franc",
    "DKK" to "Tänischi Chroone",
    "DOP" to "Tominikanische Peso",
    "DZD" to "Algeerischi Dinar",
    "ECS" to "Ecuadorianische Sucre",
    "ECV" to "Verrächnigsäiheit für EC",
    "EEK" to "Eestnischi Chroone",
    "EGP" to "Ägüptischs Pfund",
    "ERN" to "Eritreische Nakfa",
    "ESA" to "Schpanischi Peseeta (A–Kontene)",
    "ESB" to "Schpanischi Peseeta (konvertibel)",
    "ESP" to "Schpanischi Peseeta",
    "ETB" to "Äthiopische Birr",
    "EUR" to "Euro",
    "FIM" to "Finnischi Mark",
    "FJD" to "Fidschi Dollar",
    "FKP" to "Falkland-Pfund",
    "FRF" to "Französische Franc",
    "GBP" to "Pfund Schtörling",
    "GEK" to "Georgische Kupon Larit",
    "GEL" to "Georgische Lari",
    "GHC" to "Ghanaische Cedi (GHC)",
    "GHS" to "Ghanaische Cedi (GHS)",
    "GIP" to "Gibraltar-Pfund",
    "GMD" to "Gambische Dalasi",
    "GNF" to "Guinea-Franc",
    "GNS" to "Guineische Syli",
    "GQE" to "Äquatorialguinea-Ekwele",
    "GRD" to "Griechische Trachme",
    "GTQ" to "Quetzal",
    "GWE" to "Portugiisische Guinea Escudo",
    "GWP" to "Guinea-Bissau-Peso",
    "GYD" to "Guyana-Dollar",
    "HKD" to "Hongkong-Dollar",
    "HNL" to "Lempira",
    "HRD" to "Kroazische Dinar",
    "HRK" to "Kuna",
    "HTG" to "Gourde",
    "HUF" to "Forint",
    "IDR" to "Indonesischi Rupie",
    "IEP" to "Iirischs Pfund",
    "ILP" to "Israelischs Pfund",
    "ILS" to "Schekel",
    "INR" to "Indischi Rupie",
    "IQD" to "Irak-Dinar",
    "IRR" to "Rial",
    "ISK" to "Iisländischi Chroone",
    "ITL" to "Italiänischi Lira",
    "JMD" to "Jamaika-Dollar",
    "JOD" to "Jordaanische Dinar",
    "JPY" to "Yen",
    "KES" to "Kenia-Schilling",
    "KGS" to "Som",
    "KHR" to "Riel",
    "KMF" to "Komore-Franc",
    "KPW" to "Nordkoreanische Won",
    "KRW" to "Süüdkoreanische Won",
    "KWD" to "Kuwait-Dinar",
    "KYD" to "Kaiman-Dollar",
    "KZT" to "Tenge",
    "LAK" to "Kip",
    "LBP" to "Libaneesischs Pfund",
    "LKR" to "Sri-Lanka-Rupie",
    "LRD" to "Liberiaanische Dollar",
    "LSL" to "Loti",
    "LTL" to "Litauische Litas",
    "LTT" to "Litauische Talonas",
    "LUC" to "Luxemburgische Franc (konvertibel)",
    "LUF" to "Luxemburgische Franc",
    "LUL" to "Luxemburgischer Finanz-Franc",
    "LVL" to "Lettische Lats",
    "LVR" to "Lettische Rubel",
    "LYD" to "Lüübische Dinar",
    "MAD" to "Marokkanische Dirham",
    "MAF" to "Marokkanischer Franc",
    "MDL" to "Moldau-Löi",
    "MGA" to "Madagaschkar-Ariary",
    "MGF" to "Madagaschkar-Franc",
    "MKD" to "Denar",
    "MLF" to "Malische Franc",
    "MMK" to "Kyat",
    "MNT" to "Tugrik",
    "MOP" to "Pataca",
    "MRO" to "Ouguiya (1973–2017)",
    "MRU" to "Ouguiya",
    "MTL" to "Malteesischi Lira",
    "MTP" to "Malteesischs Pfund",
    "MUR" to "Maurizius-Rupie",
    "MVR" to "Malediven-Rufiyaa",
    "MWK" to "Malawi-Kwacha",
    "MXN" to "Mexikanische Peso",
    "MXP" to "Mexikanische Silber-Peso (1861–1992)",
    "MXV" to "Mexikanische Unidad de Inversion (UDI)",
    "MYR" to "Malaysische Ringgit",
    "MZE" to "Mosambikanische Escudo",
    "MZM" to "Alte Metical",
    "MZN" to "Metical",
    "NAD" to "Namibia-Dollar",
    "NGN" to "Naira",
    "NIC" to "Cordoba",
    "NIO" to "Nicaragua-Córdoba",
    "NLG" to "Holländische Gulde",
    "NOK" to "Norweegischi Chroone",
    "NPR" to "Nepaleesischi Rupie",
    "NZD" to "Neuseeland-Dollar",
    "OMR" to "Rial Omani",
    "PAB" to "Balboa",
    "PEI" to "Peruanische Inti",
    "PEN" to "Sol",
    "PES" to "Sol (1863–1965)",
    "PGK" to "Kina",
    "PHP" to "Philippiinische Peso",
    "PKR" to "Pakischtanischi Rupie",
    "PLN" to "Zloty",
    "PLZ" to "Zloty (1950–1995)",
    "PTE" to "Portugiisische Escudo",
    "PYG" to "Guarani",
    "QAR" to "Katar-Riyal",
    "RHD" to "Rhodesische Dollar",
    "ROL" to "Löi",
    "RON" to "Rumäänische Löi",
    "RSD" to "Serbische Dinar",
    "RUB" to "Russische Rubel",
    "RUR" to "Russische Rubel (alt)",
    "RWF" to "Ruanda-Franc",
    "SAR" to "Saudi-Riyal",
    "SBD" to "Salomone-Dollar",
    "SCR" to "Seyschelle-Rupie",
    "SDD" to "Sudaneesische Dinar",
    "SDG" to "Sudaneesischs Pfund",
    "SDP" to "Sudaneesischs Pfund (alt)",
    "SEK" to "Schweedischi Chroone",
    "SGD" to "Singapur-Dollar",
    "SHP" to "St.-Helena-Pfund",
    "SIT" to "Tolar",
    "SKK" to "Slowakischi Chroone",
    "SLE" to "Leone",
    "SLL" to "Leone (1964—2022)",
    "SOS" to "Somalia-Schilling",
    "SRD" to "Surinamische Dollar",
    "SRG" to "Surinamische Gulde",
    "SSP" to "Süüdsudaneesischs Pfund",
    "STD" to "Dobra (1977–2017)",
    "STN" to "Dobra",
    "SUR" to "Sowjetische Rubel",
    "SVC" to "El-Salvador-Colon",
    "SYP" to "Süürischs Pfund",
    "SZL" to "Lilangeni",
    "THB" to "Baht",
    "TJR" to "Tadschikischtan-Rubel",
    "TJS" to "Tadschikischtan-Somoni",
    "TMM" to "Turkmeenischtan-Manat",
    "TND" to "Tuneesische Dinar",
    "TOP" to "Paʻanga",
    "TPE" to "Timor-Escudo",
    "TRL" to "Türkischi Liire",
    "TRY" to "Nöii Türkischi Liire",
    "TTD" to "Trinidad-und-Tobago-Dollar",
    "TWD" to "Nöii Taiwan-Dollar",
    "TZS" to "Tansania-Schilling",
    "UAH" to "Hryvnia",
    "UAK" to "Ukraiinische Karbovanetz",
    "UGS" to "Uganda-Schilling (1966–1987)",
    "UGX" to "Uganda-Schilling",
    "USD" to "US-Dollar",
    "USN" to "US Dollar (Nöchschte Taag)",
    "USS" to "US Dollar (Gliiche Taag)",
    "UYP" to "Uruguayische Nöie Peso (1975–1993)",
    "UYU" to "Uruguayische Peso",
    "UZS" to "Usbeekischtan-Sum",
    "VEB" to "Bolivar (1871–2008)",
    "VEF" to "Bolivar (2008–2018)",
    "VES" to "Bolivar",
    "VND" to "Dong",
    "VUV" to "Vatu",
    "WST" to "Tala",
    "XAF" to "CFA-Franc (Äquatoriaal)",
    "XAG" to "Silber",
    "XAU" to "Gold",
    "XBA" to "Europääischi Rächnigseinheit",
    "XBB" to "Europääischi Währigseinheit (XBB)",
    "XBC" to "Europääischi Rächnigseinheit (XBC)",
    "XBD" to "Europääischi Rächnigseinheit (XBD)",
    "XCD" to "Oschtkaribische Dollar",
    "XDR" to "Sunderziäigsrächt",
    "XEU" to "Europääischi Währigseinheit (XEU)",
    "XFO" to "Französische Gold-Franc",
    "XFU" to "Französische UIC-Franc",
    "XOF" to "CFA-Franc (Wescht)",
    "XPD" to "Palladium",
    "XPF" to "CFP-Franc",
    "XPT" to "Platin",
    "XRE" to "RINET-Funds",
    "XTS" to "Teschtwährig",
    "XXX" to "Unbekannti Währig",
    "YDD" to "Jeme-Dinar",
    "YER" to "Jeme-Rial",
    "YUD" to "Jugoslawische Dinar (1966–1990)",
    "YUM" to "Nöii Dinar",
    "YUN" to "Jugoslawische Dinar (konvertibel)",
    "ZAR" to "Rand",
    "ZMK" to "Kwacha (1968–2012)",
    "ZMW" to "Kwacha",
    "ZRN" to "Nöie Zaire",
    "ZRZ" to "Zaire",
    "ZWD" to "Simbabwe-Dollar",
  ) }

  val gsw_FR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gsw_LI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "યુનાઈટેડ આરબ અમિરાત દિરહામ",
    "AFN" to "અફ્ગાન અફ્ગાની",
    "ALL" to "અલ્બેનિયન લેક",
    "AMD" to "અર્મેનિયન ડ્રેમ",
    "ANG" to "નેધરલેંડ એંટિલિન ગિલ્ડર",
    "AOA" to "અંગોલિયન ક્વાન્ઝા",
    "ARS" to "અર્જેન્ટીના પેસો",
    "AUD" to "ઑસ્ટ્રેલિયન ડૉલર",
    "AWG" to "અરુબન ફ્લોરિન",
    "AZN" to "અઝરબૈજાની મનાત",
    "BAM" to "બોસ્નિયા અને હર્ઝેગોવિના રૂપાંતર યોગ્ય માર્ક",
    "BBD" to "બાર્બાડિયન ડોલર",
    "BDT" to "બાંગ્લાદેશી ટાકા",
    "BGN" to "બલ્ગેરીયન લેવ",
    "BHD" to "બેહરિની દિનાર",
    "BIF" to "બુરુન્ડિયન ફ્રેંક",
    "BMD" to "બર્મુડન ડોલર",
    "BND" to "બ્રુનેઇ ડોલર",
    "BOB" to "બોલિવિયન બોલિવિયાનો",
    "BRL" to "બ્રાઝિલીયન રિઆલ",
    "BSD" to "બહામિયન ડોલર",
    "BTN" to "ભુતાનિઝ એંગુલ્ત્રમ",
    "BWP" to "બોત્સવાનન પુલા",
    "BYN" to "બેલારુશિયન રૂબલ",
    "BYR" to "બેલારુશિયન રૂબલ (2000–2016)",
    "BZD" to "બેલિઝ ડોલર",
    "CAD" to "કેનેડિયન ડૉલર",
    "CDF" to "કોંગોલિઝ ફ્રેંક",
    "CHF" to "સ્વિસ ફ્રેંક",
    "CLP" to "ચિલિઅન પેસો",
    "CNH" to "ચાઇનીઝ યુઆન (ઑફશોર)",
    "CNY" to "ચાઇનિઝ યુઆન",
    "COP" to "કોલમ્બિયન પેસો",
    "CRC" to "કોસ્ટા રિકન કોલોન",
    "CUC" to "ક્યુબન રૂપાંતર યોગ્ય પેસો",
    "CUP" to "ક્યુબન પેસો",
    "CVE" to "કેપ વર્દિયન એસ્કુડો",
    "CZK" to "ચેક રીપબ્લિક કોરુના",
    "DJF" to "જિબુટિયન ફ્રેંક",
    "DKK" to "ડેનિશ ક્રોન",
    "DOP" to "ડોમિનિકન પેસો",
    "DZD" to "અલ્જિરિયન દિનાર",
    "EGP" to "ઇજિપ્તિયન પાઉન્ડ",
    "ERN" to "એરિટ્રેયન નક્ફા",
    "ETB" to "ઇથિયોપીયન બિર",
    "EUR" to "યુરો",
    "FJD" to "ફિજિઅન ડોલર",
    "FKP" to "ફૉકલેન્ડ આઇલેંડ્સ પાઉન્ડ",
    "GBP" to "બ્રિટિશ પાઉન્ડ",
    "GEL" to "જ્યોર્જિઅન લારી",
    "GHS" to "ઘાનાઇયન સેડી",
    "GIP" to "જીબ્રાલ્ટર પાઉન્ડ",
    "GMD" to "ગેમ્બિયન દલાસી",
    "GNF" to "ગિનીયન ફ્રેંક",
    "GTQ" to "ગ્વાટેમાલા કુઇટ્ઝલ",
    "GYD" to "ગયાનિઝ ડોલર",
    "HKD" to "હોંગ કોંગ ડૉલર",
    "HNL" to "હોન્ડ્યુરન લેમ્પિરા",
    "HRK" to "ક્રોએશિયન ક્યુના",
    "HTG" to "હાઇટિઇન ગોર્ડ",
    "HUF" to "હંગેરીયન ફોરિન્ત",
    "IDR" to "ઇન્ડોનેશિયન રૂપિયા",
    "ILS" to "ઇઝરાયેલી ન્યુ શેકલ",
    "INR" to "ભારતીય રૂપિયા",
    "IQD" to "ઇરાકી દિનાર",
    "IRR" to "ઇરાનિયન રિયાલ",
    "ISK" to "આઇસલેન્ડિક ક્રોના",
    "JMD" to "જમૈકિયન ડોલર",
    "JOD" to "જોર્ડનિયન દિનાર",
    "JPY" to "જાપાનીઝ યેન",
    "KES" to "કેન્યેન શિલિંગ",
    "KGS" to "કિર્ગિસ્તાની સોમ",
    "KHR" to "કેમ્બોડિયન રીઅલ",
    "KMF" to "કોમોરિઅન ફ્રેંક",
    "KPW" to "ઉત્તર કોરિયન વન",
    "KRW" to "દક્ષિણ કોરિયન વન",
    "KWD" to "કુવૈતી દિનાર",
    "KYD" to "કેયમેન આઇલેંડ્સ ડોલર",
    "KZT" to "કઝાકિસ્તાની ટેંગ",
    "LAK" to "લાઓશિયન કિપ",
    "LBP" to "લેબેનિઝ પાઉન્ડ",
    "LKR" to "શ્રી લંકન રૂપી",
    "LRD" to "લિબેરિયન ડોલર",
    "LSL" to "લેસોથો લોતી",
    "LTL" to "લિથુએનિયન લિતાસ",
    "LVL" to "લાતવિયન લેત્સ",
    "LYD" to "લિબ્યન દિનાર",
    "MAD" to "મોરોક્કન દિરહામ",
    "MDL" to "મોલડોવેન લિયુ",
    "MGA" to "માલાગેસી અરીઆરી",
    "MKD" to "મેસેડોનિયન દિનાર",
    "MMK" to "મ્યાંમાર ક્યાત",
    "MNT" to "મોંગોલિયન ટગરિક",
    "MOP" to "માકાનિઝ પતાકા",
    "MRO" to "મોરીશેનિયન ઓગુયા (1973–2017)",
    "MRU" to "મોરીશેનિયન ઓગુયા",
    "MUR" to "મોરેશીઅન રૂપી",
    "MVR" to "માલ્દિવિયન રુફિયા",
    "MWK" to "માલાવિયન ક્વાચા",
    "MXN" to "મેક્સિકન પેસો",
    "MYR" to "મલેશિયન રિંગ્ગેટ",
    "MZN" to "મોઝામ્બિકન મેટિકલ",
    "NAD" to "નામિબિયન ડોલર",
    "NGN" to "નાઇજીરિયન નૈરા",
    "NIO" to "નિકારાગુઅન કોર્ડોબા",
    "NOK" to "નૉર્વેજિયન ક્રોન",
    "NPR" to "નેપાલિઝ રૂપી",
    "NZD" to "ન્યૂઝિલેંડ ડૉલર",
    "OMR" to "ઓમાની રિયાલ",
    "PAB" to "પનામેનિયન બાલ્બોઆ",
    "PEN" to "પેરુવિયન સોલ",
    "PGK" to "પાપુઆ ન્યૂ ગિનીયન કિના",
    "PHP" to "ફિલીપાઇન પેસો",
    "PKR" to "પાકિસ્તાની રૂપી",
    "PLN" to "પોલિસ ઝ્લોટી",
    "PYG" to "પરાગ્વેયન ગુઆરાની",
    "QAR" to "કતારી રિયાલ",
    "RON" to "રોમાનિયન લેઉ",
    "RSD" to "સર્બિયન દિનાર",
    "RUB" to "રશિયન રૂબલ",
    "RWF" to "રવાંડન ફ્રેંક",
    "SAR" to "સાઉદી રિયાલ",
    "SBD" to "સોલોમન આઇલેંડ્સ ડોલર",
    "SCR" to "સેશેલોઈ રૂપી",
    "SDG" to "સુદાનિઝ પાઉન્ડ",
    "SEK" to "સ્વીડિશ ક્રોના",
    "SGD" to "સિંગાપુર ડૉલર",
    "SHP" to "સેંટ હેલેના પાઉન્ડ",
    "SLE" to "સિએરા લિઓનિઅન લિઓન",
    "SLL" to "સિએરા લિઓનિઅન લિઓન (1964—2022)",
    "SOS" to "સોમાલી શિલિંગ",
    "SRD" to "સૂરીનામિઝ ડોલર",
    "SSP" to "દક્ષિણ સુદાનિઝ પાઉન્ડ",
    "STD" to "સાઓ ટૉમ એન્ડ પ્રિંસાઇપ ડોબ્રા (1977–2017)",
    "STN" to "સાઓ ટૉમ એન્ડ પ્રિંસાઇપ ડોબ્રા",
    "SYP" to "સાઇરિયન પાઉન્ડ",
    "SZL" to "સ્વાઝી લિલાન્ગેની",
    "THB" to "થાઇ બાહ્ત",
    "TJS" to "તાજિકિસ્તાની સોમોની",
    "TMT" to "તુર્કમેનિસ્તાની મનત",
    "TND" to "ટ્યુનિશિયન દિનાર",
    "TOP" to "ટોંગન પ’અંગા",
    "TRY" to "તુર્કિશ લિરા",
    "TTD" to "ત્રિનિદાદ અને ટોબેગો ડોલર",
    "TWD" to "ન્યુ તાઇવાન ડૉલર",
    "TZS" to "તાન્ઝાનિયન શિલિંગ",
    "UAH" to "યુક્રેનિયન હ્રિવિનિયા",
    "UGX" to "યુગાંડન શિલિંગ",
    "USD" to "યુઍસ ડોલર",
    "UYU" to "ઉરુગ્વેયન પેસો",
    "UZS" to "ઉઝ્બેકિસ્તાન સોમ",
    "VEF" to "વેનેઝુએલન બોલિવર (2008–2018)",
    "VES" to "વેનેઝુએલન બોલિવર",
    "VND" to "વિયેતનામીસ ડોંગ",
    "VUV" to "વનૌતુ વાતુ",
    "WST" to "સમોઅન તાલા",
    "XAF" to "મધ્ય આફ્રિકન [CFA] ફ્રેંક",
    "XCD" to "ઇસ્ટ કેરિબિયન ડોલર",
    "XOF" to "પશ્ચિમી આફ્રિકન [CFA] ફ્રેંક",
    "XPF" to "[CFP] ફ્રેંક",
    "XXX" to "અજ્ઞાત ચલણ",
    "YER" to "યેમેની રિઆલ",
    "ZAR" to "દક્ષિણ આફ્રિકી રેંડ",
    "ZMK" to "ઝામ્બિયન ક્વાચા (1968–2012)",
    "ZMW" to "ઝામ્બિયન ક્વાચા",
  ) }

  val guz: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham ya Falme za Kiarabu",
    "AOA" to "Kwanza ya Angola",
    "AUD" to "Dola ya Australia",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pula ya Botswana",
    "CAD" to "Dola ya Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Uswisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Jibuti",
    "DZD" to "Dinari ya Aljeria",
    "EGP" to "Pauni ya Misri",
    "ERN" to "Nakfa ya Eritrea",
    "ETB" to "Bir ya Uhabeshi",
    "EUR" to "Yuro",
    "GBP" to "Pauni ya Uingereza",
    "GHC" to "Sedi ya Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Gine",
    "INR" to "Rupia ya India",
    "JPY" to "Sarafu ya Kijapani",
    "KES" to "Shilingi ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Dola ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirham ya Moroko",
    "MGA" to "Ariary ya Bukini",
    "MRO" to "Ugwiya ya Moritania (1973–2017)",
    "MRU" to "Ugwiya ya Moritania",
    "MUR" to "Rupia ya Morisi",
    "MWK" to "Kwacha ya Malawi",
    "MZM" to "Metikali ya Msumbiji",
    "NAD" to "Dola ya Namibia",
    "NGN" to "Naira ya Nijeria",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riyal ya Saudia",
    "SCR" to "Rupia ya Shelisheli",
    "SDG" to "Pauni ya Sudani",
    "SHP" to "Pauni ya Santahelena",
    "SLE" to "Leoni",
    "SLL" to "Leoni (1964—2022)",
    "SOS" to "Shilingi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Principe (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Principe",
    "SZL" to "Lilangeni",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "Shilingi ya Tanzania",
    "UGX" to "Shilingi ya Uganda",
    "USD" to "Dola ya Marekani",
    "XAF" to "Faranga CFA BEAC",
    "XOF" to "Faranga CFA BCEAO",
    "ZAR" to "Randi ya Afrika Kusini",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Dola ya Zimbabwe",
  ) }

  val gv: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ha: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Kuɗin Haɗaɗɗiyar Daular Larabawa",
    "AFN" to "Afghani na ƙasar Afghanistan",
    "ALL" to "Kuɗin Albania",
    "AMD" to "Kuɗin Armenia",
    "ANG" to "Antillean Guilder na ƙasar Netherlands",
    "AOA" to "Kuɗin Angola",
    "ARS" to "Peso na ƙasar Argentina",
    "AUD" to "Dalar Ostareliya",
    "AWG" to "Florin na yankin Aruba",
    "AZN" to "Kuɗin Azerbaijani",
    "BAM" to "Kuɗaɗen Bosnia da Herzegovina",
    "BBD" to "Dalar ƙasar Barbados",
    "BDT" to "Taka na ƙasar Bangladesh",
    "BGN" to "Kuɗin Bulgeria",
    "BHD" to "Kuɗin Baharan",
    "BIF" to "Kuɗin Burundi",
    "BMD" to "Dalar ƙasar Bermuda",
    "BND" to "Dalar Brunei",
    "BOB" to "Boloviano na ƙasar Bolivia",
    "BRL" to "Ril Kudin Birazil",
    "BSD" to "Dalar ƙasar Bahamas",
    "BTN" to "Ngultrum na ƙasar Bhutan",
    "BWP" to "Kuɗin Baswana",
    "BYN" to "Kuɗin Belarus",
    "BZD" to "Dalar ƙasar Belize",
    "CAD" to "Dalar Kanada",
    "CDF" to "Kuɗin Kongo",
    "CHF" to "Kuɗin Suwizalan",
    "CLP" to "Peso na ƙasar Chile",
    "CNH" to "Yuwan na ƙasar Sin (na wajen ƙasa)",
    "CNY" to "Yuwan na ƙasar Sin",
    "COP" to "Peso na ƙasar Columbia",
    "CRC" to "Colón na ƙasar Costa Rica",
    "CUC" to "Peso mai fuska biyu na ƙasar Kuba",
    "CUP" to "Peso na ƙasar Kuba",
    "CVE" to "Kuɗin Tsibiran Kap Barde",
    "CZK" to "Kuɗin Czech",
    "DJF" to "Kuɗin Jibuti",
    "DKK" to "Krone na ƙasar Denmark",
    "DOP" to "Peso na jamhuriyar Dominica",
    "DZD" to "Kuɗin Aljeriya",
    "EGP" to "Fam kin Masar",
    "ERN" to "Kuɗin Eritireya",
    "ETB" to "Kuɗin Habasha",
    "EUR" to "Yuro",
    "FJD" to "Dalar Fiji",
    "FKP" to "Fam na ƙasar Tsibirai na Falkland",
    "GBP" to "Fam na Ingila",
    "GEL" to "Kuɗin Georgia",
    "GHC" to "Cedi",
    "GHS" to "Sidi na Ghana",
    "GIP" to "Kuɗin Gibraltal",
    "GMD" to "Kuɗin Gambiya",
    "GNF" to "Kuɗin Guinea",
    "GNS" to "Kuɗin Gini",
    "GTQ" to "Quetzal na ƙasar Guatemala",
    "GYD" to "Dalar Guyana",
    "HKD" to "Dalar Hong Kong",
    "HNL" to "Lempira na ƙasar Honduras",
    "HRK" to "Kuɗin Croatia",
    "HTG" to "Gourde na ƙasar Haiti",
    "HUF" to "Kuɗin Hungary",
    "IDR" to "Rupiah na ƙasar Indonesia",
    "ILS" to "Sabbin Kuɗin Israʼila",
    "INR" to "Kuɗin Indiya",
    "IQD" to "Dinarin Iraqi",
    "IRR" to "Riyal na ƙasar Iran",
    "ISK" to "Króna na ƙasar Iceland",
    "JMD" to "Dalar Jamaica",
    "JOD" to "Dinarin Jordan",
    "JPY" to "Yen na ƙasar Japan",
    "KES" to "Sulen Kenya",
    "KGS" to "Som na ƙasar Kyrgystani",
    "KHR" to "Riel na ƙasar Cambodia",
    "KMF" to "Kuɗin Kwamoras",
    "KPW" to "Won na ƙasar Koriya ta Arewa",
    "KRW" to "Won na Koriya ta Kudu",
    "KWD" to "Dinarin Kuwaiti",
    "KYD" to "Dalar ƙasar Tsibirai na Cayman",
    "KZT" to "Tenge na ƙasar Kazkhstan",
    "LAK" to "Kuɗin Laos",
    "LBP" to "Kuɗin Lebanon",
    "LKR" to "Rupee na ƙasar Sri Lanka",
    "LRD" to "Dalar Laberiya",
    "LSL" to "Kuɗin Lesoto",
    "LYD" to "Kuɗin Libiya",
    "MAD" to "Kuɗin Maroko",
    "MDL" to "Kuɗaɗen Moldova",
    "MGA" to "Kuɗin Madagaskar",
    "MKD" to "Dinarin Macedonia",
    "MMK" to "Kuɗin Myanmar",
    "MNT" to "Tugrik na Mongolia",
    "MOP" to "Pataca na ƙasar Macao",
    "MRO" to "Kuɗin Moritaniya (1973–2017)",
    "MRU" to "Kuɗin Moritaniya",
    "MUR" to "Kuɗin Moritus",
    "MVR" to "Rufiyaa na ɓasar Maldives",
    "MWK" to "Kuɗin Malawi",
    "MXN" to "Peso na ƙasar Mekziko",
    "MYR" to "Kuɗin Malaysia",
    "MZM" to "Kuɗin Mozambik",
    "MZN" to "Metical na ƙasar Mozambique",
    "NAD" to "Dalar Namibiya",
    "NGN" to "Nairar Najeriya",
    "NIO" to "Córdoba na ƙasar Nicaragua",
    "NOK" to "Krone na ƙasar Norway",
    "NPR" to "Rupee na Nepal",
    "NZD" to "Dalar New Zealand",
    "OMR" to "Riyal ɗin Oman",
    "PAB" to "Balboa na ƙasar Panama",
    "PEN" to "Sol na ƙasar Peru",
    "PGK" to "Kina na ƙasar Papua Sabon Guinea",
    "PHP" to "Kuɗin Philippine",
    "PKR" to "Rupee na ƙasar Pakistan",
    "PLN" to "Kuɗin Polan",
    "PYG" to "Guarani na ƙasar Paraguay",
    "QAR" to "Riyal ɗin Qatar",
    "RON" to "Kuɗin Romania",
    "RSD" to "Dinarin Serbia",
    "RUB" to "Ruble na ƙasar Rasha",
    "RWF" to "Kuɗin Ruwanda",
    "SAR" to "Riyal",
    "SBD" to "Dalar Tsibirai na Solomon",
    "SCR" to "Kuɗin Saishal",
    "SDG" to "Fam na Sudan",
    "SEK" to "Krona na ƙasar Sweden",
    "SGD" to "Dalar Singapore",
    "SHP" to "Fam kin San Helena",
    "SLE" to "Kuɗin Salewo",
    "SLL" to "Kuɗin Salewo (1964—2022)",
    "SOS" to "Sulen Somaliya",
    "SRD" to "Dalar ƙasar Suriname",
    "SSP" to "Fam na Kudancin Sudan",
    "STD" to "Kuɗin Sawo Tome da Paransip (1977–2017)",
    "STN" to "Kuɗin Sawo Tome da Paransip",
    "SYP" to "Kuɗin Siriya",
    "SZL" to "Kuɗin Lilangeni",
    "THB" to "Baht na ƙasar Thailand",
    "TJS" to "Somoni na ƙasar Tajikistan",
    "TMT" to "Manat na ƙasar Turkmenistan",
    "TND" to "Kuɗin Tunisiya",
    "TOP" to "Paʻanga na ƙasar Tonga",
    "TRY" to "Kuɗin Turkiyya",
    "TTD" to "Dalar ƙasar Trinidad da Tobago",
    "TWD" to "Sabuwar Dalar Taiwan",
    "TZS" to "Sulen Tanzaniya",
    "UAH" to "Kudin Ukrainian",
    "UGX" to "Sule Yuganda",
    "USD" to "Dalar Amurka",
    "UYU" to "Peso na ƙasar Uruguay",
    "UZS" to "Som na ƙasar Uzbekistan",
    "VES" to "Bolívar na ƙasar Venezuela",
    "VND" to "Kuɗin Vietnam",
    "VUV" to "Vatu da ƙasar Vanuatu",
    "WST" to "Tala na ƙasar Samoa",
    "XAF" to "Kuɗin Sefa na Afirka Ta Tsakiya",
    "XCD" to "Dalar Gabashin Karebiyan",
    "XOF" to "Kuɗin Sefa na Afirka Ta Yamma",
    "XPF" to "Kuɗin CFP franc",
    "XXX" to "Kudin da ba a sani ba",
    "YER" to "Riyal ɗin Yemen",
    "ZAR" to "Kuɗin Afirka Ta Kudu",
    "ZMK" to "Kuɗin Zambiya (1968–2012)",
    "ZMW" to "Kuɗin Zambiya",
    "ZWD" to "Dalar zimbabuwe",
  ) }

  val ha_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ha_Arab_SD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ha_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ha_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val haw: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val he: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "פזטה אנדורית",
    "AED" to "דירהם של איחוד הנסיכויות הערביות",
    "AFN" to "אפגני אפגני",
    "ALL" to "לק אלבני",
    "AMD" to "דראם ארמני",
    "ANG" to "גילדר של האנטילים ההולנדיים",
    "AOA" to "קואנזה אנגולי",
    "AON" to "קואנזה חדש אנגולי (1990–2000)",
    "AOR" to "קואנזה רג׳וסטדו אנגולי (1995–1999)",
    "ARP" to "פזו ארגנטינאי (1983–1985)",
    "ARS" to "פסו ארגנטינאי",
    "ATS" to "שילינג אוסטרי",
    "AUD" to "דולר אוסטרלי",
    "AWG" to "פלורין של ארובה",
    "AZM" to "מנאט אזרביג׳אני (1993–2006)",
    "AZN" to "מאנאט אזרבייג׳ני",
    "BAD" to "דינר של בוסניה־הרצגובינה",
    "BAM" to "מארק סחיר של בוסניה והרצגובינה",
    "BBD" to "דולר ברבדיאני",
    "BDT" to "טאקה בנגלדשי",
    "BEC" to "פרנק בלגי (בר המרה)",
    "BEF" to "פרנק בלגי",
    "BGL" to "לב בולגרי ישן",
    "BGN" to "לב בולגרי",
    "BHD" to "דינר בחרייני",
    "BIF" to "פרנק בורונדי",
    "BMD" to "דולר ברמודה",
    "BND" to "דולר ברוניי",
    "BOB" to "בוליביאנו",
    "BOP" to "פזו בוליבי",
    "BRB" to "קרוזיארו חדש ברזילאי (1967–1986)",
    "BRC" to "קרוזדו ברזילאי",
    "BRL" to "ריאל ברזילאי",
    "BSD" to "דולר בהאמי",
    "BTN" to "נגולטרום בהוטני",
    "BWP" to "פולה בוטסואני",
    "BYN" to "רובל בלרוסי",
    "BYR" to "רובל בלרוסי (2000–2016)",
    "BZD" to "דולר בליזי",
    "CAD" to "דולר קנדי",
    "CDF" to "פרנק קונגולזי",
    "CHF" to "פרנק שוויצרי",
    "CLP" to "פסו צ׳ילאני",
    "CNH" to "יואן סיני (CNH)",
    "CNY" to "יואן סיני",
    "COP" to "פסו קולומביאני",
    "CRC" to "קולון קוסטה־ריקני",
    "CSD" to "דינר סרבי ישן",
    "CUC" to "פסו קובני להמרה",
    "CUP" to "פסו קובני",
    "CVE" to "אסקודו כף ורדה",
    "CYP" to "לירה קפריסאית",
    "CZK" to "קורונה צ׳כית",
    "DDM" to "מרק מזרח גרמני",
    "DEM" to "מרק גרמני",
    "DJF" to "פרנק ג׳יבוטי",
    "DKK" to "כתר דני",
    "DOP" to "פסו דומיניקני",
    "DZD" to "דינר אלג׳ירי",
    "ECS" to "סוקר אקואדורי",
    "EEK" to "קרון אסטוני",
    "EGP" to "לירה מצרית",
    "ERN" to "נאקפה אריתראי",
    "ESP" to "פסטה ספרדי",
    "ETB" to "ביר אתיופי",
    "EUR" to "אירו",
    "FIM" to "מרק פיני",
    "FJD" to "דולר פיג׳י",
    "FKP" to "לירה של איי פוקלנד",
    "FRF" to "פרנק צרפתי",
    "GBP" to "לירה שטרלינג",
    "GEL" to "לארי גאורגי",
    "GHS" to "סדי גאני",
    "GIP" to "פאונד גיברלטר",
    "GMD" to "דלסי גמבי",
    "GNF" to "פרנק גינאי",
    "GRD" to "דרכמה",
    "GTQ" to "קצאל גואטמלי",
    "GWP" to "פזו גינאי",
    "GYD" to "דולר גיאני",
    "HKD" to "דולר הונג קונגי",
    "HNL" to "למפירה הונדורי",
    "HRK" to "קונה קרואטי",
    "HTG" to "גורד האיטי",
    "HUF" to "פורינט הונגרי",
    "IDR" to "רופיה אינדונזית",
    "IEP" to "לירה אירית",
    "ILP" to "לירה ישראלית",
    "ILS" to "שקל חדש",
    "INR" to "רופי הודי",
    "IQD" to "דינר עיראקי",
    "IRR" to "ריאל איראני",
    "ISK" to "כתר איסלנדי",
    "ITL" to "לירה איטלקית",
    "JMD" to "דולר ג׳מייקני",
    "JOD" to "דינר ירדני",
    "JPY" to "ין יפני",
    "KES" to "שילינג קנייתי",
    "KGS" to "סום קירגיזי",
    "KHR" to "ריל קמבודי",
    "KMF" to "פרנק קומורואי",
    "KPW" to "וון צפון קוריאני",
    "KRW" to "וון דרום קוריאני",
    "KWD" to "דינר כוויתי",
    "KYD" to "דולר קיימני",
    "KZT" to "טנגה קזחסטני",
    "LAK" to "קיפ לאי",
    "LBP" to "לירה לבנונית",
    "LKR" to "רופי סרי לנקי",
    "LRD" to "דולר ליברי",
    "LSL" to "לוטי לסותי",
    "LTL" to "ליטא ליטאי",
    "LUF" to "פרנק לוקסמבורגי",
    "LVL" to "לט לטבי",
    "LYD" to "דינר לובי",
    "MAD" to "דירהם מרוקאי",
    "MAF" to "פרנק מרוקאי",
    "MDL" to "לאו מולדובני",
    "MGA" to "אריארי מלגשי",
    "MGF" to "פרנק מדגסקארי",
    "MKD" to "דינר מקדוני",
    "MMK" to "קיאט מיאנמרי",
    "MNT" to "טוגרוג מונגולי",
    "MOP" to "פטקה של מקאו",
    "MRO" to "אואוגויה מאוריטני (1973–2017)",
    "MRU" to "אואוגויה מאוריטני",
    "MTL" to "לירה מלטית",
    "MUR" to "רופי מאוריציני",
    "MVR" to "רופיה מלדיבית",
    "MWK" to "קואצ׳ה מלאווי",
    "MXN" to "פסו מקסיקני",
    "MXP" to "פזו מקסיקני (1861 – 1992)",
    "MXV" to "יחידת השקעות מקסיקנית",
    "MYR" to "רינגיט מלזי",
    "MZE" to "אסקודו מוזמביקי",
    "MZM" to "מטיקל",
    "MZN" to "מטיקל מוזמביני",
    "NAD" to "דולר נמיבי",
    "NGN" to "נאירה ניגרי",
    "NIC" to "קורדובה (1988–1991)",
    "NIO" to "קורדובה ניקרגואה",
    "NLG" to "גילדן הולנדי",
    "NOK" to "כתר נורווגי",
    "NPR" to "רופי נפאלי",
    "NZD" to "דולר ניו זילנדי",
    "OMR" to "ריאל עומאני",
    "PAB" to "בלבואה פנמי",
    "PEN" to "סול פרואני",
    "PGK" to "קינה של פפואה גינאה החדשה",
    "PHP" to "פסו פיליפיני",
    "PKR" to "רופי פקיסטני",
    "PLN" to "זלוטי פולני",
    "PTE" to "אסקודו פורטוגלי",
    "PYG" to "גוארני פרגוואי",
    "QAR" to "ריאל קטארי",
    "ROL" to "לאו רומני ישן",
    "RON" to "לאו רומני",
    "RSD" to "דינר סרבי",
    "RUB" to "רובל רוסי",
    "RUR" to "רובל רוסי (1991 – 1998)",
    "RWF" to "פרנק רואנדי",
    "SAR" to "ריאל סעודי",
    "SBD" to "דולר איי שלמה",
    "SCR" to "רופי סיישלי",
    "SDD" to "דינר סודני",
    "SDG" to "לירה סודנית",
    "SDP" to "לירה סודנית (1957–1998)",
    "SEK" to "כתר שוודי",
    "SGD" to "דולר סינגפורי",
    "SHP" to "פאונד סנט הלני",
    "SIT" to "טולאר סלובני",
    "SKK" to "קורונה סלובקי",
    "SLE" to "ליאון סיירה לאוני",
    "SLL" to "ליאון סיירה לאוני - 1964-2022",
    "SOS" to "שילינג סומלי",
    "SRD" to "דולר סורינאמי",
    "SRG" to "גילדר סורינאמי",
    "SSP" to "לירה דרום-סודנית",
    "STD" to "דוברה של סן טומה ופרינסיפה (1977–2017)",
    "STN" to "דוברה של סאו טומה ופרינסיפה",
    "SUR" to "רובל סובייטי",
    "SVC" to "קולון סלבדורי",
    "SYP" to "לירה סורית",
    "SZL" to "לילנגני סווזילנדי",
    "THB" to "בהט תאילנדי",
    "TJS" to "סומוני טג׳קיסטני",
    "TMM" to "מנאט טורקמאני",
    "TMT" to "מאנאט טורקמני",
    "TND" to "דינר טוניסאי",
    "TOP" to "פאנגה טונגי",
    "TPE" to "אסקודו טימוראי",
    "TRL" to "לירה טורקית",
    "TRY" to "לירה טורקית חדשה",
    "TTD" to "דולר טרינידדי",
    "TWD" to "דולר טייוואני חדש",
    "TZS" to "שילינג טנזני",
    "UAH" to "הריבנה אוקראיני",
    "UGS" to "שילינג אוגנדי (1966 – 1987)",
    "UGX" to "שילינג אוגנדי",
    "USD" to "דולר אמריקאי",
    "USN" to "דולר אמריקאי (היום הבא)",
    "USS" to "דולר אמריקאי (היום הזה)",
    "UYU" to "פסו אורוגוואי",
    "UZS" to "סום אוזבקי",
    "VEB" to "בוליבר ונצואלי (1871–2008)",
    "VEF" to "בוליבר ונצואלי (2008–2018)",
    "VES" to "בוליבר ונצואלי",
    "VND" to "דונג וייטנאמי",
    "VUV" to "ואטו של ונואטו",
    "WST" to "טאלה סמואי",
    "XAF" to "פרנק CFA מרכז אפריקני",
    "XAG" to "כסף",
    "XAU" to "זהב",
    "XCD" to "דולר מזרח קריבי",
    "XDR" to "זכויות משיכה מיוחדות",
    "XFO" to "פרנק זהב",
    "XOF" to "פרנק CFA מערב אפריקני",
    "XPD" to "פלדיום",
    "XPF" to "פרנק פולינזיה הצרפתית",
    "XPT" to "פלטינה",
    "XTS" to "סימון למטרות בדיקה",
    "XXX" to "מטבע שאינו ידוע",
    "YDD" to "דינר תימני",
    "YER" to "ריאל תימני",
    "ZAL" to "ראנד דרום אפריקאי (כספי)",
    "ZAR" to "ראנד דרום אפריקאי",
    "ZMK" to "קוואצ׳ה זמבית (1968–2012)",
    "ZMW" to "קוואצ׳ה זמבי",
    "ZRN" to "זאיר חדש",
    "ZWD" to "דולר זימבבואי",
  ) }

  val hi: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "संयुक्त अरब अमीरात दिरहाम",
    "AFA" to "अफगानी (1927–2002)",
    "AFN" to "अफ़गान अफ़गानी",
    "ALL" to "अल्बानियाई लेक",
    "AMD" to "आर्मेनियाई द्राम",
    "ANG" to "नीदरलैंड एंटीलियन गिल्डर",
    "AOA" to "अंगोला क्वांज़ा",
    "ARS" to "अर्जेंटीनी पेसो",
    "AUD" to "ऑस्ट्रेलियाई डॉलर",
    "AWG" to "अरूबाई फ़्लोरिन",
    "AZN" to "अज़रबैजानी मैनेट",
    "BAM" to "बोस्निया हर्ज़ेगोविना परिवर्तनीय मार्क",
    "BBD" to "बार्बेडियन डॉलर",
    "BDT" to "बांग्लादेशी टका",
    "BGN" to "बुल्गारियाई लेव",
    "BHD" to "बहरीनी दिनार",
    "BIF" to "बुरूंडी फ़्रैंक",
    "BMD" to "बरमूडा डॉलर",
    "BND" to "ब्रूनेई डॉलर",
    "BOB" to "बोलिवियाई बोलिवियानो",
    "BRL" to "ब्राज़ीली रियाल",
    "BSD" to "बहामाई डॉलर",
    "BTN" to "भूटानी नंगलट्रम",
    "BUK" to "बर्मी क्यात",
    "BWP" to "बोत्सवानियाई पुला",
    "BYN" to "बेलारूसी रूबल",
    "BYR" to "बेलारूसी रूबल (2000–2016)",
    "BZD" to "बेलीज़ डॉलर",
    "CAD" to "कनाडाई डॉलर",
    "CDF" to "कोंगोली फ़्रैंक",
    "CHF" to "स्विस फ़्रैंक",
    "CLP" to "चिली पेसो",
    "CNH" to "चीनी युआन (ऑफ़शोर)",
    "CNY" to "चीनी युआन",
    "COP" to "कोलंबियाई पेसो",
    "CRC" to "कोस्टा रिका कोलोन",
    "CSD" to "सर्बिय का ढीनार",
    "CUC" to "क्यूबाई परिवर्तनीय पेसो",
    "CUP" to "क्यूबाई पेसो",
    "CVE" to "केप वर्ड एस्कूडो",
    "CYP" to "साईप्रस पाऊंड",
    "CZK" to "चेक गणराज्य कोरुना",
    "DEM" to "डच मार्क",
    "DJF" to "जिबूती फ़्रैंक",
    "DKK" to "डैनिश क्रोन",
    "DOP" to "डोमिनिकन पेसो",
    "DZD" to "अल्जीरियाई दिनार",
    "EEK" to "एस्टोनियाई क्रून्",
    "EGP" to "मिस्र पाउंड",
    "ERN" to "इरीट्रियन नाक्फ़ा",
    "ETB" to "इथियोपियन बिर",
    "EUR" to "यूरो",
    "FJD" to "फ़िजी डॉलर",
    "FKP" to "फ़ॉकलैंड द्वीपसमूह पाउंड",
    "FRF" to "फ़्रांसीसी फ़्रैंक",
    "GBP" to "ब्रिटिश पाउंड स्टर्लिंग",
    "GEL" to "जॉर्जियन लारी",
    "GHS" to "घानियन सेडी",
    "GIP" to "जिब्राल्टर पाउंड",
    "GMD" to "गैंबियन डलासी",
    "GNF" to "गिनीयन फ़्रैंक",
    "GTQ" to "ग्वाटेमाला क्वेटज़ल",
    "GYD" to "गयानीज़ डॉलर",
    "HKD" to "हाँगकाँग डॉलर",
    "HNL" to "होंडुरन लेम्पिरा",
    "HRD" to "क्रोएशियन दिनार",
    "HRK" to "क्रोएशियाई कुना",
    "HTG" to "हैतियाई गर्ड",
    "HUF" to "हंगेरियन फ़ोरिंट",
    "IDR" to "इंडोनेशियाई रुपिया",
    "ILS" to "इज़राइली न्यू शेकेल",
    "INR" to "भारतीय रुपया",
    "IQD" to "इराकी दिनार",
    "IRR" to "ईरानी रियाल",
    "ISK" to "आइसलैंडिक क्रोना",
    "ITL" to "इतली का लीरा",
    "JMD" to "जमैकन डॉलर",
    "JOD" to "जॉर्डनियन दिनार",
    "JPY" to "जापानी येन",
    "KES" to "केन्याई शिलिंग",
    "KGS" to "किर्गिस्तानी सोम",
    "KHR" to "कंबोडियाई रियाल",
    "KMF" to "कोमोरियन फ़्रैंक",
    "KPW" to "उत्तर कोरियाई वॉन",
    "KRW" to "दक्षिण कोरियाई वॉन",
    "KWD" to "कुवैती दिनार",
    "KYD" to "कैमेन द्वीपसमूह डॉलर",
    "KZT" to "कज़ाखिस्तानी टेंज़",
    "LAK" to "लाओशियन किप",
    "LBP" to "लेबनानी पाउंड",
    "LKR" to "श्रीलंकाई रुपया",
    "LRD" to "लाइबेरियाई डॉलर",
    "LSL" to "लेसोथो लोटी",
    "LTL" to "लिथुआनियाई लितास",
    "LVL" to "लात्वियन लैत्स",
    "LYD" to "लीबियाई दिनार",
    "MAD" to "मोरक्को दिरहम",
    "MAF" to "मोरक्को फ्रैंक",
    "MDL" to "मोल्डोवन लियू",
    "MGA" to "मालागासी आरियरी",
    "MKD" to "मैसीडोनियन दिनार",
    "MMK" to "म्यांमार क्याट",
    "MNT" to "मंगोलियाई टगरिक",
    "MOP" to "मेकानीज़ पाटाका",
    "MRO" to "मॉरीटेनियन ओगुइया (1973–2017)",
    "MRU" to "मॉरीटेनियन ओगुइया",
    "MUR" to "मॉरिशियन रुपया",
    "MVR" to "मालदीवी रुफ़िया",
    "MWK" to "मालावियन क्वाचा",
    "MXN" to "मैक्सिकन पेसो",
    "MYR" to "मलेशियाई रिंगित",
    "MZN" to "मोज़ाम्बिकन मेटिकल",
    "NAD" to "नामीबियाई डॉलर",
    "NGN" to "नाइजीरियाई नाइरा",
    "NIO" to "निकारागुअन कोरडोबा",
    "NOK" to "नॉर्वेजियन क्रोन",
    "NPR" to "नेपाली रुपया",
    "NZD" to "न्यूज़ीलैंड डॉलर",
    "OMR" to "ओमानी रियाल",
    "PAB" to "पनामेनियन बैल्बोआ",
    "PEN" to "पेरूवियन सोल",
    "PGK" to "पापुआ न्यू गिनीयन किना",
    "PHP" to "फ़िलिपीनी पेसो",
    "PKR" to "पाकिस्तानी रुपया",
    "PLN" to "पोलिश ज़्लॉटी",
    "PYG" to "पैराग्वियन गुआरानी",
    "QAR" to "क़तरी रियाल",
    "RHD" to "रोडेशियाई डालर",
    "RON" to "रोमानियाई ल्यू",
    "RSD" to "सर्बियन दिनार",
    "RUB" to "रूसी रूबल",
    "RWF" to "रवांडाई फ़्रैंक",
    "SAR" to "सउदी रियाल",
    "SBD" to "सोलोमन द्वीपसमूह डॉलर",
    "SCR" to "सेशेल्सियाई रुपया",
    "SDD" to "पुरानी सूडानी दिनार",
    "SDG" to "सूडानी पाउंड",
    "SDP" to "पुराना सूडानी पाउंड",
    "SEK" to "स्वीडीश क्रोना",
    "SGD" to "सिंगापुर डॉलर",
    "SHP" to "सेंट हेलेना पाउंड",
    "SIT" to "स्लोवेनियाई तोलार",
    "SKK" to "स्लोवाक कोरुना",
    "SLE" to "सिएरा लियोनियन लियोन",
    "SLL" to "सिएरा लियोनियन लियोन (1964—2022)",
    "SOS" to "सोमाली शिलिंग",
    "SRD" to "सूरीनामी डॉलर",
    "SRG" to "सूरीनामी गिल्डर",
    "SSP" to "दक्षिण सूडानी पाउंड",
    "STD" to "साओ तोम और प्रिंसिपे डोबरा (1977–2017)",
    "STN" to "साओ टोम और प्रिंसिपे डोबरा",
    "SUR" to "सोवियत रूबल",
    "SYP" to "सीरियाई पाउंड",
    "SZL" to "स्वाज़ी लिलांजेनी",
    "THB" to "थाई बहत",
    "TJR" to "तजाखी रूबल",
    "TJS" to "ताजिकिस्तानी सोमोनी",
    "TMT" to "तुर्कमेनिस्तानी मैनत",
    "TND" to "ट्यूनीशियाई दिनार",
    "TOP" to "टोंगन पांगा",
    "TPE" to "तिमोरी एस्कूडो",
    "TRL" to "पुरानी तुर्की लीरा",
    "TRY" to "तुर्की लीरा",
    "TTD" to "त्रिनिदाद और टोबैगो डॉलर",
    "TWD" to "नया ताईवानी डॉलर",
    "TZS" to "तंज़ानियाई शिलिंग",
    "UAH" to "यूक्रेनियन रिव्निया",
    "UGX" to "युगांडाई शिलिंग",
    "USD" to "यूएस डॉलर",
    "USN" to "अमेरीकी डालर (कल)",
    "USS" to "अमेरीकी डालर (आज)",
    "UYU" to "उरुग्वियन पेसो",
    "UZS" to "उज़्बेकिस्तानी सोम",
    "VEB" to "वेनेज़ुएला बोलिवर (1871–2008)",
    "VEF" to "वेनेज़ुएला बोलिवर (2008–2018)",
    "VES" to "वेनेज़ुएला बोलिवर",
    "VND" to "वियतनामी डोंग",
    "VNN" to "वियतनामी डोंग (1978–1985)",
    "VUV" to "वनुआतू वातू",
    "WST" to "समोआई ताला",
    "XAF" to "केंद्रीय अफ़्रीकी CFA फ़्रैंक",
    "XCD" to "पूर्वी कैरिबियाई डॉलर",
    "XEU" to "यूरोपीय मुद्रा इकाई",
    "XOF" to "पश्चिमी अफ़्रीकी CFA फ़्रैंक",
    "XPF" to "[CFP] फ़्रैंक",
    "XXX" to "अज्ञात मुद्रा",
    "YER" to "यमनी रियाल",
    "ZAR" to "दक्षिण अफ़्रीकी रैंड",
    "ZMK" to "ज़ाम्बियन क्वाचा (1968–2012)",
    "ZMW" to "ज़ाम्बियन क्वाचा",
  ) }

  val hi_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorran Peseta",
    "AED" to "United Arab Emirates Dirham",
    "AFA" to "Afghan Afghani (1927–2002)",
    "AFN" to "Afghan Afghani",
    "ALK" to "Albanian Lek (1946–1965)",
    "ALL" to "Albanian Lek",
    "AMD" to "Armenian Dram",
    "ANG" to "Netherlands Antillean Guilder",
    "AOA" to "Angolan Kwanza",
    "AOK" to "Angolan Kwanza (1977–1991)",
    "AON" to "Angolan New Kwanza (1990–2000)",
    "AOR" to "Angolan Readjusted Kwanza (1995–1999)",
    "ARA" to "Argentine Austral",
    "ARL" to "Argentine Peso Ley (1970–1983)",
    "ARM" to "Argentine Peso (1881–1970)",
    "ARP" to "Argentine Peso (1983–1985)",
    "ARS" to "Argentine Peso",
    "ATS" to "Austrian Schilling",
    "AUD" to "Australian Dollar",
    "AWG" to "Aruban Florin",
    "AZM" to "Azerbaijani Manat (1993–2006)",
    "AZN" to "Azerbaijani Manat",
    "BAD" to "Bosnia-Herzegovina Dinar (1992–1994)",
    "BAM" to "Bosnia-Herzegovina Convertible Mark",
    "BAN" to "Bosnia-Herzegovina New Dinar (1994–1997)",
    "BBD" to "Barbadian Dollar",
    "BDT" to "Bangladeshi Taka",
    "BEC" to "Belgian Franc (convertible)",
    "BEF" to "Belgian Franc",
    "BEL" to "Belgian Franc (financial)",
    "BGL" to "Bulgarian Hard Lev",
    "BGM" to "Bulgarian Socialist Lev",
    "BGN" to "Bulgarian Lev",
    "BGO" to "Bulgarian Lev (1879–1952)",
    "BHD" to "Bahraini Dinar",
    "BIF" to "Burundian Franc",
    "BMD" to "Bermudian Dollar",
    "BND" to "Brunei Dollar",
    "BOB" to "Bolivian Boliviano",
    "BOL" to "Bolivian Boliviano (1863–1963)",
    "BOP" to "Bolivian Peso",
    "BOV" to "Bolivian Mvdol",
    "BRB" to "Brazilian New Cruzeiro (1967–1986)",
    "BRC" to "Brazilian Cruzado (1986–1989)",
    "BRE" to "Brazilian Cruzeiro (1990–1993)",
    "BRL" to "Brazilian Real",
    "BRN" to "Brazilian New Cruzado (1989–1990)",
    "BRR" to "Brazilian Cruzeiro (1993–1994)",
    "BRZ" to "Brazilian Cruzeiro (1942–1967)",
    "BSD" to "Bahamian Dollar",
    "BTN" to "Bhutanese Ngultrum",
    "BUK" to "Burmese Kyat",
    "BWP" to "Botswanan Pula",
    "BYB" to "Belarusian New Rouble (1994–1999)",
    "BYN" to "Belarusian Rouble",
    "BYR" to "Belarusian Rouble (2000–2016)",
    "BZD" to "Belize Dollar",
    "CAD" to "Canadian Dollar",
    "CDF" to "Congolese Franc",
    "CHE" to "WIR Euro",
    "CHF" to "Swiss Franc",
    "CHW" to "WIR Franc",
    "CLE" to "Chilean Escudo",
    "CLF" to "Chilean Unit of Account (UF)",
    "CLP" to "Chilean Peso",
    "CNH" to "Chinese Yuan (offshore)",
    "CNX" to "Chinese People’s Bank Dollar",
    "CNY" to "Chinese Yuan",
    "COP" to "Colombian Peso",
    "COU" to "Colombian Real Value Unit",
    "CRC" to "Costa Rican colon",
    "CSD" to "Serbian Dinar (2002–2006)",
    "CSK" to "Czechoslovak Hard Koruna",
    "CUC" to "Cuban Convertible Peso",
    "CUP" to "Cuban Peso",
    "CVE" to "Cape Verdean Escudo",
    "CYP" to "Cypriot Pound",
    "CZK" to "Czech Koruna",
    "DDM" to "East German Mark",
    "DEM" to "German Mark",
    "DJF" to "Djiboutian Franc",
    "DKK" to "Danish Krone",
    "DOP" to "Dominican Peso",
    "DZD" to "Algerian Dinar",
    "ECS" to "Ecuadorian Sucre",
    "ECV" to "Ecuadorian Unit of Constant Value",
    "EEK" to "Estonian Kroon",
    "EGP" to "Egyptian Pound",
    "ERN" to "Eritrean Nakfa",
    "ESA" to "Spanish Peseta (A account)",
    "ESB" to "Spanish Peseta (convertible account)",
    "ESP" to "Spanish Peseta",
    "ETB" to "Ethiopian Birr",
    "EUR" to "Euro",
    "FIM" to "Finnish Markka",
    "FJD" to "Fijian Dollar",
    "FKP" to "Falkland Islands Pound",
    "FRF" to "French Franc",
    "GBP" to "British Pound",
    "GEK" to "Georgian Kupon Larit",
    "GEL" to "Georgian Lari",
    "GHC" to "Ghanaian Cedi (1979–2007)",
    "GHS" to "Ghanaian Cedi",
    "GIP" to "Gibraltar Pound",
    "GMD" to "Gambian Dalasi",
    "GNF" to "Guinean Franc",
    "GNS" to "Guinean Syli",
    "GQE" to "Equatorial Guinean Ekwele",
    "GRD" to "Greek Drachma",
    "GTQ" to "Guatemalan Quetzal",
    "GWE" to "Portuguese Guinea Escudo",
    "GWP" to "Guinea-Bissau Peso",
    "GYD" to "Guyanaese Dollar",
    "HKD" to "Hong Kong Dollar",
    "HNL" to "Honduran Lempira",
    "HRD" to "Croatian Dinar",
    "HRK" to "Croatian Kuna",
    "HTG" to "Haitian Gourde",
    "HUF" to "Hungarian Forint",
    "IDR" to "Indonesian Rupiah",
    "IEP" to "Irish Pound",
    "ILP" to "Israeli Pound",
    "ILR" to "Israeli Shekel (1980–1985)",
    "ILS" to "Israeli New Shekel",
    "INR" to "Indian Rupee",
    "IQD" to "Iraqi Dinar",
    "IRR" to "Iranian Rial",
    "ISJ" to "Icelandic Króna (1918–1981)",
    "ISK" to "Icelandic krona",
    "ITL" to "Italian Lira",
    "JMD" to "Jamaican Dollar",
    "JOD" to "Jordanian Dinar",
    "JPY" to "Japanese Yen",
    "KES" to "Kenyan Shilling",
    "KGS" to "Kyrgyzstani Som",
    "KHR" to "Cambodian Riel",
    "KMF" to "Comorian Franc",
    "KPW" to "North Korean Won",
    "KRH" to "South Korean Hwan (1953–1962)",
    "KRO" to "South Korean Won (1945–1953)",
    "KRW" to "South Korean Won",
    "KWD" to "Kuwaiti Dinar",
    "KYD" to "Cayman Islands Dollar",
    "KZT" to "Kazakhstani Tenge",
    "LAK" to "Laotian Kip",
    "LBP" to "Lebanese Pound",
    "LKR" to "Sri Lankan Rupee",
    "LRD" to "Liberian Dollar",
    "LSL" to "Lesotho Loti",
    "LTL" to "Lithuanian Litas",
    "LTT" to "Lithuanian Talonas",
    "LUC" to "Luxembourgian Convertible Franc",
    "LUF" to "Luxembourgian Franc",
    "LUL" to "Luxembourg Financial Franc",
    "LVL" to "Latvian Lats",
    "LVR" to "Latvian Rouble",
    "LYD" to "Libyan Dinar",
    "MAD" to "Moroccan Dirham",
    "MAF" to "Moroccan Franc",
    "MCF" to "Monegasque Franc",
    "MDC" to "Moldovan Cupon",
    "MDL" to "Moldovan Leu",
    "MGA" to "Malagasy Ariary",
    "MGF" to "Malagasy Franc",
    "MKD" to "Macedonian Denar",
    "MKN" to "Macedonian Denar (1992–1993)",
    "MLF" to "Malian Franc",
    "MMK" to "Myanmar Kyat",
    "MNT" to "Mongolian Tugrik",
    "MOP" to "Macanese Pataca",
    "MRO" to "Mauritanian Ouguiya (1973–2017)",
    "MRU" to "Mauritanian Ouguiya",
    "MTL" to "Maltese Lira",
    "MTP" to "Maltese Pound",
    "MUR" to "Mauritian Rupee",
    "MVP" to "Maldivian Rupee (1947–1981)",
    "MVR" to "Maldivian Rufiyaa",
    "MWK" to "Malawian Kwacha",
    "MXN" to "Mexican Peso",
    "MXP" to "Mexican Silver Peso (1861–1992)",
    "MXV" to "Mexican Investment Unit",
    "MYR" to "Malaysian Ringgit",
    "MZE" to "Mozambican Escudo",
    "MZM" to "Mozambican Metical (1980–2006)",
    "MZN" to "Mozambican Metical",
    "NAD" to "Namibian Dollar",
    "NGN" to "Nigerian Naira",
    "NIC" to "Nicaraguan Córdoba (1988–1991)",
    "NIO" to "Nicaraguan cordoba",
    "NLG" to "Dutch Guilder",
    "NOK" to "Norwegian Krone",
    "NPR" to "Nepalese Rupee",
    "NZD" to "New Zealand Dollar",
    "OMR" to "Omani Rial",
    "PAB" to "Panamanian Balboa",
    "PEI" to "Peruvian Inti",
    "PEN" to "Peruvian Sol",
    "PES" to "Peruvian Sol (1863–1965)",
    "PGK" to "Papua New Guinean Kina",
    "PHP" to "Philippine Peso",
    "PKR" to "Pakistani Rupee",
    "PLN" to "Polish Zloty",
    "PLZ" to "Polish Zloty (1950–1995)",
    "PTE" to "Portuguese Escudo",
    "PYG" to "Paraguayan Guarani",
    "QAR" to "Qatari Riyal",
    "RHD" to "Rhodesian Dollar",
    "ROL" to "Romanian Leu (1952–2006)",
    "RON" to "Romanian Leu",
    "RSD" to "Serbian Dinar",
    "RUB" to "Russian ruble",
    "RUR" to "Russian Rouble (1991–1998)",
    "RWF" to "Rwandan Franc",
    "SAR" to "Saudi Riyal",
    "SBD" to "Solomon Islands Dollar",
    "SCR" to "Seychellois Rupee",
    "SDD" to "Sudanese Dinar (1992–2007)",
    "SDG" to "Sudanese Pound",
    "SDP" to "Sudanese Pound (1957–1998)",
    "SEK" to "Swedish Krona",
    "SGD" to "Singapore Dollar",
    "SHP" to "St Helena Pound",
    "SIT" to "Slovenian Tolar",
    "SKK" to "Slovak Koruna",
    "SLE" to "Sierra Leonean Leone",
    "SLL" to "Sierra Leonean Leone (1964—2022)",
    "SOS" to "Somali Shilling",
    "SRD" to "Surinamese Dollar",
    "SRG" to "Surinamese Guilder",
    "SSP" to "South Sudanese Pound",
    "STD" to "São Tomé & Príncipe Dobra (1977–2017)",
    "STN" to "Sao Tome & Principe Dobra",
    "SUR" to "Soviet Rouble",
    "SVC" to "Salvadoran Colón",
    "SYP" to "Syrian Pound",
    "SZL" to "Swazi Lilangeni",
    "THB" to "Thai Baht",
    "TJR" to "Tajikistani Rouble",
    "TJS" to "Tajikistani Somoni",
    "TMM" to "Turkmenistani Manat (1993–2009)",
    "TMT" to "Turkmenistani Manat",
    "TND" to "Tunisian Dinar",
    "TOP" to "Tongan Paʻanga",
    "TPE" to "Timorese Escudo",
    "TRL" to "Turkish Lira (1922–2005)",
    "TRY" to "Turkish Lira",
    "TTD" to "Trinidad & Tobago Dollar",
    "TWD" to "New Taiwan Dollar",
    "TZS" to "Tanzanian Shilling",
    "UAH" to "Ukrainian Hryvnia",
    "UAK" to "Ukrainian Karbovanets",
    "UGS" to "Ugandan Shilling (1966–1987)",
    "UGX" to "Ugandan Shilling",
    "USD" to "US Dollar",
    "USN" to "US Dollar (Next day)",
    "USS" to "US Dollar (Same day)",
    "UYI" to "Uruguayan Peso (Indexed Units)",
    "UYP" to "Uruguayan Peso (1975–1993)",
    "UYU" to "Uruguayan Peso",
    "UYW" to "Uruguayan Nominal Wage Index Unit",
    "UZS" to "Uzbekistani Som",
    "VEB" to "Venezuelan Bolívar (1871–2008)",
    "VED" to "Bolívar Soberano",
    "VEF" to "Venezuelan Bolívar",
    "VES" to "Venezuelan bolivar",
    "VND" to "Vietnamese Dong",
    "VNN" to "Vietnamese Dong (1978–1985)",
    "VUV" to "Vanuatu Vatu",
    "WST" to "Samoan Tala",
    "XAF" to "Central African CFA Franc",
    "XAG" to "Silver",
    "XAU" to "Gold",
    "XBA" to "European Composite Unit",
    "XBB" to "European Monetary Unit",
    "XBC" to "European Unit of Account (XBC)",
    "XBD" to "European Unit of Account (XBD)",
    "XCD" to "East Caribbean Dollar",
    "XCG" to "Caribbean guilder",
    "XDR" to "Special Drawing Rights",
    "XEU" to "European Currency Unit",
    "XFO" to "French Gold Franc",
    "XFU" to "French UIC-Franc",
    "XOF" to "West African CFA Franc",
    "XPD" to "Palladium",
    "XPF" to "CFP Franc",
    "XPT" to "Platinum",
    "XRE" to "RINET Funds",
    "XSU" to "Sucre",
    "XTS" to "Testing Currency Code",
    "XUA" to "ADB Unit of Account",
    "XXX" to "Unknown Currency",
    "YDD" to "Yemeni Dinar",
    "YER" to "Yemeni Rial",
    "YUD" to "Yugoslavian Hard Dinar (1966–1990)",
    "YUM" to "Yugoslavian New Dinar (1994–2002)",
    "YUN" to "Yugoslavian Convertible Dinar (1990–1992)",
    "YUR" to "Yugoslavian Reformed Dinar (1992–1993)",
    "ZAL" to "South African Rand (financial)",
    "ZAR" to "South African Rand",
    "ZMK" to "Zambian Kwacha (1968–2012)",
    "ZMW" to "Zambian Kwacha",
    "ZRN" to "Zairean New Zaire (1993–1998)",
    "ZRZ" to "Zairean Zaire (1971–1993)",
    "ZWD" to "Zimbabwean Dollar (1980–2008)",
    "ZWG" to "Zimbabwean Gold",
    "ZWL" to "Zimbabwean Dollar (2009–2024)",
    "ZWR" to "Zimbabwean Dollar (2008)",
  ) }

  val hnj: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val hnj_Hmnp: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val hr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "andorska pezeta",
    "AED" to "UAE dirham",
    "AFA" to "afganistanski afgani (1927.–2002.)",
    "AFN" to "afganistanski afgani",
    "ALK" to "stari albanski lek",
    "ALL" to "albanski lek",
    "AMD" to "armenski dram",
    "ANG" to "nizozemskoantilski gulden",
    "AOA" to "angolska kvanza",
    "AOK" to "angolska kvanza (1977.–1990.)",
    "AON" to "angolska nova kvanza (1990.–2000.)",
    "AOR" to "angolska kvanza (1995.–1999.)",
    "ARA" to "argentinski austral",
    "ARL" to "argentinski pezo lej (1970.–1983.)",
    "ARM" to "argentinski pezo (1881.–1970.)",
    "ARP" to "argentinski pezo (1983.–1985.)",
    "ARS" to "argentinski pezo",
    "ATS" to "austrijski šiling",
    "AUD" to "australski dolar",
    "AWG" to "arupski florin",
    "AZM" to "azerbajdžanski manat (1993.–2006.)",
    "AZN" to "azerbajdžanski manat",
    "BAD" to "bosansko-hercegovački dinar",
    "BAM" to "konvertibilna marka",
    "BAN" to "bosansko-hercegovački novi dinar",
    "BBD" to "barbadoski dolar",
    "BDT" to "bangladeška taka",
    "BEC" to "belgijski franak (konvertibilan)",
    "BEF" to "belgijski franak",
    "BEL" to "belgijski franak (financijski)",
    "BGL" to "bugarski čvrsti lev",
    "BGM" to "bugarski socijalistički lev",
    "BGN" to "bugarski lev",
    "BGO" to "stari bugarski lev",
    "BHD" to "bahreinski dinar",
    "BIF" to "burundski franak",
    "BMD" to "bermudski dolar",
    "BND" to "brunejski dolar",
    "BOB" to "bolivijski bolivijano",
    "BOL" to "stari bolivijski bolivijano",
    "BOP" to "bolivijski pezo",
    "BOV" to "bolivijski mvdol",
    "BRB" to "brazilski novi cruzeiro (1967.–1986.)",
    "BRC" to "brazilski cruzado",
    "BRE" to "brazilski cruzeiro (1990.–1993.)",
    "BRL" to "brazilski real",
    "BRN" to "brazilski novi cruzado",
    "BRR" to "brazilski cruzeiro",
    "BSD" to "bahamski dolar",
    "BTN" to "butanski ngultrum",
    "BUK" to "burmanski kyat",
    "BWP" to "bocvanska pula",
    "BYB" to "bjeloruska nova rublja (1994–1999)",
    "BYN" to "bjeloruski rubalj",
    "BYR" to "bjeloruska rublja (2000–2016)",
    "BZD" to "belizeanski dolar",
    "CAD" to "kanadski dolar",
    "CDF" to "kongoanski franak",
    "CHE" to "WIR euro",
    "CHF" to "švicarski franak",
    "CHW" to "WIR franak",
    "CLE" to "čileanski eskudo",
    "CLF" to "čileanski unidades de fomentos",
    "CLP" to "čileanski pezo",
    "CNH" to "kineski juan (offshore)",
    "CNX" to "kineski narodni dolar",
    "CNY" to "kineski yuan",
    "COP" to "kolumbijski pezo",
    "COU" to "unidad de valor real",
    "CRC" to "kostarikanski kolon",
    "CSD" to "stari srpski dinar",
    "CSK" to "čehoslovačka kruna",
    "CUC" to "kubanski konvertibilni pezo",
    "CUP" to "kubanski pezo",
    "CVE" to "zelenortski eskudo",
    "CYP" to "ciparska funta",
    "CZK" to "češka kruna",
    "DDM" to "istočnonjemačka marka",
    "DEM" to "njemačka marka",
    "DJF" to "džibutski franak",
    "DKK" to "danska kruna",
    "DOP" to "dominikanski pezo",
    "DZD" to "alžirski dinar",
    "ECS" to "ekvatorska sukra",
    "ECV" to "ekvatorski unidad de valor constante (UVC)",
    "EEK" to "estonska kruna",
    "EGP" to "egipatska funta",
    "ERN" to "eritrejska nakfa",
    "ESA" to "španjolska pezeta (A račun)",
    "ESB" to "španjolska pezeta (konvertibilni račun)",
    "ESP" to "španjolska pezeta",
    "ETB" to "etiopski bir",
    "EUR" to "euro",
    "FIM" to "finska marka",
    "FJD" to "fidžijski dolar",
    "FKP" to "falklandska funta",
    "FRF" to "francuski franak",
    "GBP" to "britanska funta",
    "GEK" to "gruzijski kupon larit",
    "GEL" to "gruzijski lari",
    "GHC" to "ganski cedi (1979.–2007.)",
    "GHS" to "ganski cedi",
    "GIP" to "gibraltarska funta",
    "GMD" to "gambijski dalas",
    "GNF" to "gvinejski franak",
    "GNS" to "gvinejski syli",
    "GQE" to "ekvatorski gvinejski ekwele",
    "GRD" to "grčka drahma",
    "GTQ" to "gvatemalski kvecal",
    "GWE" to "portugalski gvinejski eskudo",
    "GWP" to "gvinejskobisauski pezo",
    "GYD" to "gvajanski dolar",
    "HKD" to "hongkonški dolar",
    "HNL" to "honduraška lempira",
    "HRD" to "hrvatski dinar",
    "HRK" to "hrvatska kuna",
    "HTG" to "haićanski gourd",
    "HUF" to "mađarska forinta",
    "IDR" to "indonezijska rupija",
    "IEP" to "irska funta",
    "ILP" to "izraelska funta",
    "ILR" to "stari izraelski šekel",
    "ILS" to "novi izraelski šekel",
    "INR" to "indijska rupija",
    "IQD" to "irački dinar",
    "IRR" to "iranski rijal",
    "ISJ" to "stara islandska kruna",
    "ISK" to "islandska kruna",
    "ITL" to "talijanska lira",
    "JMD" to "jamajčanski dolar",
    "JOD" to "jordanski dinar",
    "JPY" to "japanski jen",
    "KES" to "kenijski šiling",
    "KGS" to "kirgiski som",
    "KHR" to "kambodžanski rijal",
    "KMF" to "komorski franak",
    "KPW" to "sjevernokorejski won",
    "KRH" to "južnokorejski hvan",
    "KRO" to "stari južnokorejski von",
    "KRW" to "južnokorejski won",
    "KWD" to "kuvajtski dinar",
    "KYD" to "kajmanski dolar",
    "KZT" to "kazahstanski tenge",
    "LAK" to "laoski kip",
    "LBP" to "libanonska funta",
    "LKR" to "šrilankanska rupija",
    "LRD" to "liberijski dolar",
    "LSL" to "lesotski loti",
    "LTL" to "litavski litas",
    "LTT" to "litavski talonas",
    "LUC" to "luksemburški konvertibilni franak",
    "LUF" to "luksemburški franak",
    "LUL" to "luksemburški financijski franak",
    "LVL" to "letonski lats",
    "LVR" to "letonska rublja",
    "LYD" to "libijski dinar",
    "MAD" to "marokanski dirham",
    "MAF" to "marokanski franak",
    "MDC" to "moldavski kupon",
    "MDL" to "moldavski lej",
    "MGA" to "malgaški arijari",
    "MGF" to "madagaskarski franak",
    "MKD" to "makedonski denar",
    "MKN" to "stari makedonski denar",
    "MLF" to "malijski franak",
    "MMK" to "mjanmarski kjat",
    "MNT" to "mongolski tugrik",
    "MOP" to "makaoška pataka",
    "MRO" to "mauritanijska ouguja (1973. – 2017.)",
    "MRU" to "mauretanska ouguja",
    "MTL" to "malteška lira",
    "MTP" to "malteška funta",
    "MUR" to "mauricijska rupija",
    "MVP" to "maldivijska rupija",
    "MVR" to "maldivijska rufija",
    "MWK" to "malavijska kvača",
    "MXN" to "meksički pezo",
    "MXP" to "meksički srebrni pezo (1861–1992)",
    "MXV" to "meksički unidad de inversion (UDI)",
    "MYR" to "malezijski ringit",
    "MZE" to "mozambijski eskudo",
    "MZM" to "stari mozambijski metikal",
    "MZN" to "mozambički metikal",
    "NAD" to "namibijski dolar",
    "NGN" to "nigerijska naira",
    "NIC" to "nikaragvanska kordoba",
    "NIO" to "nikaragvanska zlatna kordoba",
    "NLG" to "nizozemski gulden",
    "NOK" to "norveška kruna",
    "NPR" to "nepalska rupija",
    "NZD" to "novozelandski dolar",
    "OMR" to "omanski rijal",
    "PAB" to "panamska balboa",
    "PEI" to "peruanski inti",
    "PEN" to "peruanski sol",
    "PES" to "peruanski sol (1863–1965)",
    "PGK" to "kina Papue Nove Gvineje",
    "PHP" to "filipinski pezo",
    "PKR" to "pakistanska rupija",
    "PLN" to "poljska zlota",
    "PLZ" to "poljska zlota (1950.–1995.)",
    "PTE" to "portugalski eskudo",
    "PYG" to "paragvajski gvarani",
    "QAR" to "katarski rial",
    "RHD" to "rodezijski dolar",
    "ROL" to "starorumunjski lek",
    "RON" to "rumunjski lej",
    "RSD" to "srpski dinar",
    "RUB" to "ruski rubalj",
    "RUR" to "ruska rublja (1991.–1998.)",
    "RWF" to "ruandski franak",
    "SAR" to "saudijski rijal",
    "SBD" to "solmonskootočni dolar",
    "SCR" to "sejšelska rupija",
    "SDD" to "sudanski dinar",
    "SDG" to "sudanska funta",
    "SDP" to "stara sudanska funta",
    "SEK" to "švedska kruna",
    "SGD" to "singapurski dolar",
    "SHP" to "svetohelenska funta",
    "SIT" to "slovenski tolar",
    "SKK" to "slovačka kruna",
    "SLE" to "sijeraleonski leone",
    "SLL" to "sijeraleonski leone (1964—2022)",
    "SOS" to "somalijski šiling",
    "SRD" to "surinamski dolar",
    "SRG" to "surinamski gulden",
    "SSP" to "južnosudanska funta",
    "STD" to "dobra Svetog Tome i Principa (1977–2017)",
    "STN" to "dobra Svetog Tome i Principa",
    "SUR" to "sovjetska rublja",
    "SVC" to "salvadorski kolon",
    "SYP" to "sirijska funta",
    "SZL" to "svazi lilangeni",
    "THB" to "tajlandski baht",
    "TJR" to "tajikistanska rublja",
    "TJS" to "tadžikistanski somoni",
    "TMM" to "turkmenistanski manat (1993.–2009.)",
    "TMT" to "turkmenistanski manat",
    "TND" to "tuniski dinar",
    "TOP" to "tongaška pa’anga",
    "TPE" to "timorski eskudo",
    "TRL" to "turska lira (1922.–2005.)",
    "TRY" to "turska lira",
    "TTD" to "trininadtobaški dolar",
    "TWD" to "novotajvanski dolar",
    "TZS" to "tanzanijski šiling",
    "UAH" to "ukrajinska hrivnja",
    "UAK" to "ukrajinski karbovanet",
    "UGS" to "ugandski šiling (1966.–1987.)",
    "UGX" to "ugandski šiling",
    "USD" to "američki dolar",
    "USN" to "američki dolar (sljedeći dan)",
    "USS" to "američki dolar (isti dan)",
    "UYI" to "urugvajski pezo en unidades indexadas",
    "UYP" to "urugvajski pezo (1975.–1993.)",
    "UYU" to "urugvajski pezo",
    "UZS" to "uzbekistanski som",
    "VEB" to "venezuelanski bolivar (1871.–2008.)",
    "VEF" to "venezuelanski bolivar (2008. – 2018.)",
    "VES" to "venezuelanski bolivar",
    "VND" to "vijetnamski dong",
    "VNN" to "vijetnamski dong (1978.–1985.)",
    "VUV" to "vanuatski vatu",
    "WST" to "samoanska tala",
    "XAF" to "CFA franak BEAC",
    "XAG" to "srebro",
    "XAU" to "zlato",
    "XBA" to "Europska složena jedinica",
    "XBB" to "Europska monetarna jedinica",
    "XBC" to "europska obračunska jedinica (XBC)",
    "XBD" to "europska obračunska jedinica (XBD)",
    "XCD" to "istočnokaripski dolar",
    "XDR" to "posebna crtaća prava",
    "XEU" to "europska monetarna jedinica (ECU)",
    "XFO" to "francuski zlatni franak",
    "XFU" to "francuski UIC-franak",
    "XOF" to "CFA franak BCEAO",
    "XPD" to "paladij",
    "XPF" to "CFP franak",
    "XPT" to "platina",
    "XRE" to "RINET fondovi",
    "XSU" to "sukre",
    "XTS" to "ispitni kod valute",
    "XUA" to "obračunska jedinica ADB",
    "XXX" to "nepoznata valuta",
    "YDD" to "jemenski dinar",
    "YER" to "jemenski rijal",
    "YUD" to "jugoslavenski čvrsti dinar",
    "YUM" to "jugoslavenski novi dinar",
    "YUN" to "jugoslavenski konvertibilni dinar",
    "YUR" to "jugoslavenski reformirani dinar",
    "ZAL" to "južnoafrički rand (financijski)",
    "ZAR" to "južnoafrički rand",
    "ZMK" to "zambijska kvača (1968–2012)",
    "ZMW" to "zambijska kvača",
    "ZRN" to "zairski novi zair",
    "ZRZ" to "zairski zair",
    "ZWD" to "zimbabveanski dolar (1980.–2008.)",
    "ZWL" to "zimbabveanski dolar (2009)",
    "ZWR" to "zimbabveanski dolar (2008)",
  ) }

  val hr_BA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val hsb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "andorraska peseta",
    "AED" to "ZAE dirham",
    "AFN" to "afghaniski afghani",
    "ALL" to "albanski lek",
    "AMD" to "armenski dram",
    "ANG" to "nižozemsko-antilski gulden",
    "AOA" to "angolska kwanza",
    "AOK" to "angolska kwanza (1977–1990)",
    "AON" to "angolska nowa kwanza (1990–2000)",
    "AOR" to "angolska kwanza reajustado (1995–1999)",
    "ARA" to "argentinski austral",
    "ARP" to "argentinski peso (1983–1985)",
    "ARS" to "argentinski peso",
    "ATS" to "awstriski šiling",
    "AUD" to "awstralski dolar",
    "AWG" to "aruba-florin",
    "AZM" to "azerbajdźanski manat (1993–2006)",
    "AZN" to "azerbajdźanski manat",
    "BAD" to "bosniski dinar",
    "BAM" to "bosniska konwertibelna hriwna",
    "BBD" to "barbadoski dolar",
    "BDT" to "bangladešska taka",
    "BEC" to "belgiski frank (konwertibelny)",
    "BEF" to "belgiski frank",
    "BEL" to "belgiski finančny frank",
    "BGL" to "bołharski lew (1962–1999)",
    "BGN" to "bołharski lew",
    "BHD" to "bahrainski dinar",
    "BIF" to "burundiski frank",
    "BMD" to "bermudaski dolar",
    "BND" to "bruneiski dolar",
    "BOB" to "boliwiski boliviano",
    "BOP" to "boliwiski peso",
    "BOV" to "boliwiski mvdol",
    "BRB" to "brazilski nowy cruzeiro (1967–1986)",
    "BRC" to "brazilski cruzado (1986–1989)",
    "BRE" to "brazilski cruzeiro (1990–1993)",
    "BRL" to "brazilski real",
    "BRN" to "brazilski nowy cruzado (1989–1990)",
    "BRR" to "brazilski cruzeiro (1993–1994)",
    "BSD" to "bahamaski dolar",
    "BTN" to "bhutanski ngultrum",
    "BUK" to "burmaski kyat",
    "BWP" to "botswanska pula",
    "BYB" to "běłoruski rubl (1994–1999)",
    "BYN" to "běłoruski rubl",
    "BYR" to "běłoruski rubl (2000–2016)",
    "BZD" to "belizeski dolar",
    "CAD" to "kanadiski dolar",
    "CDF" to "kongoski frank",
    "CHF" to "šwicarski frank",
    "CLP" to "chilski peso",
    "CNH" to "chinski yuan (offshore)",
    "CNY" to "chinski yuan",
    "COP" to "kolumbiski peso",
    "CRC" to "kosta-rikaski colón",
    "CUC" to "kubaski konwertibelny peso",
    "CUP" to "kubaski peso",
    "CVE" to "kapverdski escudo",
    "CZK" to "čěska króna",
    "DJF" to "dźibutiski frank",
    "DKK" to "danska króna",
    "DOP" to "dominikanski peso",
    "DZD" to "algeriski dinar",
    "EGP" to "egyptowski punt",
    "ERN" to "eritrejska nakfa",
    "ETB" to "etiopiski birr",
    "EUR" to "euro",
    "FJD" to "fidźiski dolar",
    "FKP" to "falklandski punt",
    "GBP" to "britiski punt",
    "GEL" to "georgiski lari",
    "GHS" to "ghanaski cedi",
    "GIP" to "gibraltarski punt",
    "GMD" to "gambiski dalasi",
    "GNF" to "ginejski frank",
    "GTQ" to "guatemalski quetzal",
    "GWP" to "ginejsko-bissauski peso",
    "GYD" to "guyanski dolar",
    "HKD" to "hongkongski dolar",
    "HNL" to "honduraska lempira",
    "HRK" to "chorwatska kuna",
    "HTG" to "haitiska gourda",
    "HUF" to "madźarski forint",
    "IDR" to "indoneska rupija",
    "ILS" to "israelski nowy šekel",
    "INR" to "indiska rupija",
    "IQD" to "irakski dinar",
    "IRR" to "iranski rial",
    "ISK" to "islandska króna",
    "JMD" to "jamaiski dolar",
    "JOD" to "jordaniski dinar",
    "JPY" to "japanski yen",
    "KES" to "keniaski šiling",
    "KGS" to "kirgiski som",
    "KHR" to "kambodźaski riel",
    "KMF" to "komorski frank",
    "KPW" to "sewjernokorejski won",
    "KRW" to "južnokorejski won",
    "KWD" to "kuwaitski dinar",
    "KYD" to "kajmanski dolar",
    "KZT" to "kazachski tenge",
    "LAK" to "laoski kip",
    "LBP" to "libanonski punt",
    "LKR" to "sri-lankaska rupija",
    "LRD" to "liberiski dolar",
    "LSL" to "lesothiski loti",
    "LTL" to "litawski litas",
    "LVL" to "letiski lat",
    "LYD" to "libyski dinar",
    "MAD" to "marokkoski dirham",
    "MDL" to "moldawski leu",
    "MGA" to "madagaskarski ariary",
    "MKD" to "makedonski denar",
    "MMK" to "myanmarski kyat",
    "MNT" to "mongolski tugrik",
    "MOP" to "macaoska pataka",
    "MRO" to "mawretanska ouguiya (1973–2017)",
    "MRU" to "mawretanska ouguiya",
    "MUR" to "mauritiuska rupija",
    "MVR" to "malediwiska rupija",
    "MWK" to "malawiski kwacha",
    "MXN" to "mexiski peso",
    "MYR" to "malajziski ringgit",
    "MZE" to "mosambikski escudo",
    "MZM" to "mosambikski metical (1980–2006)",
    "MZN" to "mosambikski metical",
    "NAD" to "namibiski dolar",
    "NGN" to "nigeriski naira",
    "NIO" to "nikaraguaski cordoba",
    "NOK" to "norwegska króna",
    "NPR" to "nepalska rupija",
    "NZD" to "nowoseelandski dolar",
    "OMR" to "omanski rial",
    "PAB" to "panamaski balboa",
    "PEN" to "peruski sol",
    "PGK" to "papua-nowoginejski kina",
    "PHP" to "filipinski peso",
    "PKR" to "pakistanska rupija",
    "PLN" to "pólski złoty",
    "PYG" to "paraguayski guarani",
    "QAR" to "katarski rial",
    "RON" to "rumunski leu",
    "RSD" to "serbiski dinar",
    "RUB" to "ruski rubl",
    "RWF" to "ruandiski frank",
    "SAR" to "saudi-arabski rial",
    "SBD" to "salomonski dolar",
    "SCR" to "seychellska rupija",
    "SDG" to "sudanski punt",
    "SEK" to "šwedska króna",
    "SGD" to "singapurski dolar",
    "SHP" to "St. Helenski punt",
    "SLE" to "sierra-leoneski leone",
    "SLL" to "sierra-leoneski leone (1964—2022)",
    "SOS" to "somaliski šiling",
    "SRD" to "surinamski dolar",
    "SSP" to "južnosudanski punt",
    "STD" to "são tomeski dobra (1977–2017)",
    "STN" to "são tomeski dobra",
    "SVC" to "el salvadorski colón",
    "SYP" to "syriski punt",
    "SZL" to "swasiski lilangeni",
    "THB" to "thaiski baht",
    "TJS" to "tadźikski somoni",
    "TMT" to "turkmenski manat",
    "TND" to "tuneziski dinar",
    "TOP" to "tongaski paʻanga",
    "TRY" to "turkowska lira",
    "TTD" to "trinidad-tobagoski dolar",
    "TWD" to "nowy taiwanski dolar",
    "TZS" to "tansaniski šiling",
    "UAH" to "ukrainska hriwna",
    "UGX" to "ugandaski šiling",
    "USD" to "ameriski dolar",
    "UYU" to "uruguayski peso",
    "UZS" to "uzbekski sum",
    "VEF" to "venezuelski bolívar (2008–2018)",
    "VES" to "venezuelski bolívar",
    "VND" to "vietnamski dong",
    "VUV" to "vanuatuski vatu",
    "WST" to "samoaski tala",
    "XAF" to "CFA-frank (BEAC)",
    "XCD" to "wuchodnokaribiski dolar",
    "XOF" to "CFA-frank (BCEAO)",
    "XPF" to "CFP-frank",
    "XXX" to "njeznata měna",
    "YER" to "jemenski rial",
    "ZAR" to "južnoafriski rand",
    "ZMW" to "sambiski kwacha",
  ) }

  val hu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorrai peseta",
    "AED" to "EAE-dirham",
    "AFA" to "afgán afghani (1927–2002)",
    "AFN" to "afgán afghani",
    "ALK" to "albán lek (1946–1965)",
    "ALL" to "albán lek",
    "AMD" to "örmény dram",
    "ANG" to "holland antilláki forint",
    "AOA" to "angolai kwanza",
    "AOK" to "Angolai kwanza (1977–1990)",
    "AON" to "Angolai új kwanza (1990–2000)",
    "AOR" to "Angolai kwanza reajustado (1995–1999)",
    "ARA" to "Argentín austral",
    "ARP" to "Argentín peso (1983–1985)",
    "ARS" to "argentin peso",
    "ATS" to "Osztrák schilling",
    "AUD" to "ausztrál dollár",
    "AWG" to "arubai florin",
    "AZM" to "azerbajdzsáni manat (1993–2006)",
    "AZN" to "azerbajdzsáni manat",
    "BAD" to "Bosznia-hercegovinai dínár (1992–1994)",
    "BAM" to "bosznia-hercegovinai konvertibilis márka",
    "BAN" to "bosznia-hercegovinai új dínár (1994–1997)",
    "BBD" to "barbadosi dollár",
    "BDT" to "bangladesi taka",
    "BEC" to "Belga frank (konvertibilis)",
    "BEF" to "Belga frank",
    "BEL" to "Belga frank (pénzügyi)",
    "BGL" to "Bolgár kemény leva",
    "BGM" to "bolgár szocialista leva",
    "BGN" to "bolgár új leva",
    "BGO" to "bolgár leva (1879–1952)",
    "BHD" to "bahreini dinár",
    "BIF" to "burundi frank",
    "BMD" to "bermudai dollár",
    "BND" to "brunei dollár",
    "BOB" to "bolíviai boliviano",
    "BOP" to "Bolíviai peso",
    "BOV" to "Bolíviai mvdol",
    "BRB" to "Brazi cruzeiro novo (1967–1986)",
    "BRC" to "Brazi cruzado (1986–1989)",
    "BRE" to "Brazil cruzeiro (1990–1993)",
    "BRL" to "brazil real",
    "BRN" to "Brazil cruzado novo (1989–1990)",
    "BRR" to "Brazil cruzeiro (1993–1994)",
    "BSD" to "bahamai dollár",
    "BTN" to "bhutáni ngultrum",
    "BUK" to "Burmai kyat",
    "BWP" to "botswanai pula",
    "BYB" to "Fehérorosz új rubel (1994–1999)",
    "BYN" to "belarusz rubel",
    "BYR" to "fehérorosz rubel (2000–2016)",
    "BZD" to "belize-i dollár",
    "CAD" to "kanadai dollár",
    "CDF" to "kongói frank",
    "CHE" to "WIR euro",
    "CHF" to "svájci frank",
    "CHW" to "WIR frank",
    "CLF" to "Chilei unidades de fomento",
    "CLP" to "chilei peso",
    "CNH" to "kínai jüan (offshore)",
    "CNY" to "kínai jüan",
    "COP" to "kolumbiai peso",
    "COU" to "Unidad de Valor Real",
    "CRC" to "Costa Rica-i colon",
    "CSD" to "szerb dinár (2002–2006)",
    "CSK" to "Csehszlovák kemény korona",
    "CUC" to "kubai konvertibilis peso",
    "CUP" to "kubai peso",
    "CVE" to "Zöld-foki escudo",
    "CYP" to "Ciprusi font",
    "CZK" to "cseh korona",
    "DDM" to "Kelet-Német márka",
    "DEM" to "Német márka",
    "DJF" to "dzsibuti frank",
    "DKK" to "dán korona",
    "DOP" to "dominikai peso",
    "DZD" to "algériai dínár",
    "ECS" to "Ecuadori sucre",
    "ECV" to "Ecuadori Unidad de Valor Constante (UVC)",
    "EEK" to "Észt korona",
    "EGP" to "egyiptomi font",
    "ERN" to "eritreai nakfa",
    "ESA" to "spanyol peseta (A–kontó)",
    "ESB" to "spanyol peseta (konvertibilis kontó)",
    "ESP" to "Spanyol peseta",
    "ETB" to "etiópiai birr",
    "EUR" to "euró",
    "FIM" to "Finn markka",
    "FJD" to "fidzsi dollár",
    "FKP" to "falkland-szigeteki font",
    "FRF" to "Francia frank",
    "GBP" to "angol font",
    "GEK" to "Grúz kupon larit",
    "GEL" to "grúz lari",
    "GHC" to "Ghánai cedi (1979–2007)",
    "GHS" to "ghánai cedi",
    "GIP" to "gibraltári font",
    "GMD" to "gambiai dalasi",
    "GNF" to "guineai frank",
    "GNS" to "Guineai syli",
    "GQE" to "Egyenlítői-guineai ekwele guineana",
    "GRD" to "Görög drachma",
    "GTQ" to "guatemalai quetzal",
    "GWE" to "Portugál guinea escudo",
    "GWP" to "Guinea-Bissaui peso",
    "GYD" to "guyanai dollár",
    "HKD" to "hongkongi dollár",
    "HNL" to "hondurasi lempira",
    "HRD" to "Horvát dínár",
    "HRK" to "horvát kuna",
    "HTG" to "haiti gourde",
    "HUF" to "magyar forint",
    "IDR" to "indonéz rúpia",
    "IEP" to "Ír font",
    "ILP" to "Izraeli font",
    "ILS" to "izraeli új sékel",
    "INR" to "indiai rúpia",
    "IQD" to "iraki dínár",
    "IRR" to "iráni riál",
    "ISK" to "izlandi korona",
    "ITL" to "Olasz líra",
    "JMD" to "jamaicai dollár",
    "JOD" to "jordániai dínár",
    "JPY" to "japán jen",
    "KES" to "kenyai shilling",
    "KGS" to "kirgizisztáni szom",
    "KHR" to "kambodzsai riel",
    "KMF" to "comorei frank",
    "KPW" to "észak-koreai won",
    "KRW" to "dél-koreai won",
    "KWD" to "kuvaiti dínár",
    "KYD" to "kajmán-szigeteki dollár",
    "KZT" to "kazahsztáni tenge",
    "LAK" to "laoszi kip",
    "LBP" to "libanoni font",
    "LKR" to "Srí Lanka-i rúpia",
    "LRD" to "libériai dollár",
    "LSL" to "lesothoi loti",
    "LTL" to "litvániai litas",
    "LTT" to "Litvániai talonas",
    "LUC" to "luxemburgi konvertibilis frank",
    "LUF" to "Luxemburgi frank",
    "LUL" to "luxemburgi pénzügyi frank",
    "LVL" to "lett lats",
    "LVR" to "Lett rubel",
    "LYD" to "líbiai dínár",
    "MAD" to "marokkói dirham",
    "MAF" to "Marokkói frank",
    "MDC" to "moldáv kupon",
    "MDL" to "moldován lei",
    "MGA" to "madagaszkári ariary",
    "MGF" to "Madagaszkári frank",
    "MKD" to "macedón dénár",
    "MKN" to "macedón dénár (1992–1993)",
    "MLF" to "Mali frank",
    "MMK" to "mianmari kyat",
    "MNT" to "mongóliai tugrik",
    "MOP" to "makaói pataca",
    "MRO" to "mauritániai ouguiya (1973–2017)",
    "MRU" to "mauritániai ouguiya",
    "MTL" to "Máltai líra",
    "MTP" to "Máltai font",
    "MUR" to "mauritiusi rúpia",
    "MVR" to "maldív-szigeteki rufiyaa",
    "MWK" to "malawi kwacha",
    "MXN" to "mexikói peso",
    "MXP" to "Mexikói ezüst peso (1861–1992)",
    "MXV" to "Mexikói Unidad de Inversion (UDI)",
    "MYR" to "malajziai ringgit",
    "MZE" to "Mozambik escudo",
    "MZM" to "Mozambik metical",
    "MZN" to "mozambiki metikális",
    "NAD" to "namíbiai dollár",
    "NGN" to "nigériai naira",
    "NIC" to "Nikaraguai cordoba",
    "NIO" to "nicaraguai córdoba",
    "NLG" to "Holland forint",
    "NOK" to "norvég korona",
    "NPR" to "nepáli rúpia",
    "NZD" to "új-zélandi dollár",
    "OMR" to "ománi riál",
    "PAB" to "panamai balboa",
    "PEI" to "perui inti",
    "PEN" to "perui sol",
    "PES" to "perui sol (1863–1965)",
    "PGK" to "pápua új-guineai kina",
    "PHP" to "fülöp-szigeteki peso",
    "PKR" to "pakisztáni rúpia",
    "PLN" to "lengyel zloty",
    "PLZ" to "Lengyel zloty (1950–1995)",
    "PTE" to "Portugál escudo",
    "PYG" to "paraguayi guarani",
    "QAR" to "katari riál",
    "RHD" to "rhodéziai dollár",
    "ROL" to "román lej (1952–2006)",
    "RON" to "román lej",
    "RSD" to "szerb dinár",
    "RUB" to "orosz rubel",
    "RUR" to "orosz rubel (1991–1998)",
    "RWF" to "ruandai frank",
    "SAR" to "szaúdi riál",
    "SBD" to "salamon-szigeteki dollár",
    "SCR" to "seychelle-szigeteki rúpia",
    "SDD" to "Szudáni dínár (1992–2007)",
    "SDG" to "szudáni font",
    "SDP" to "Szudáni font (1957–1998)",
    "SEK" to "svéd korona",
    "SGD" to "szingapúri dollár",
    "SHP" to "Szent Ilona-i font",
    "SIT" to "Szlovén tolar",
    "SKK" to "Szlovák korona",
    "SLE" to "Sierra Leone-i leone",
    "SLL" to "Sierra Leone-i leone (1964–2022)",
    "SOS" to "szomáli shilling",
    "SRD" to "suriname-i dollár",
    "SRG" to "Suriname-i gulden",
    "SSP" to "dél-szudáni font",
    "STD" to "São Tomé és Príncipe-i dobra (1977–2017)",
    "STN" to "São Tomé és Príncipe-i dobra",
    "SUR" to "Szovjet rubel",
    "SVC" to "Salvadori colón",
    "SYP" to "szíriai font",
    "SZL" to "szvázi lilangeni",
    "THB" to "thai baht",
    "TJR" to "Tádzsikisztáni rubel",
    "TJS" to "tádzsikisztáni somoni",
    "TMM" to "türkmenisztáni manat (1993–2009)",
    "TMT" to "türkmenisztáni manat",
    "TND" to "tunéziai dínár",
    "TOP" to "tongai paanga",
    "TPE" to "Timori escudo",
    "TRL" to "török líra (1922–2005)",
    "TRY" to "török líra",
    "TTD" to "Trinidad és Tobago-i dollár",
    "TWD" to "tajvani új dollár",
    "TZS" to "tanzániai shilling",
    "UAH" to "ukrán hrivnya",
    "UAK" to "Ukrán karbovanec",
    "UGS" to "Ugandai shilling (1966–1987)",
    "UGX" to "ugandai shilling",
    "USD" to "USA-dollár",
    "USN" to "USA dollár (következő napi)",
    "USS" to "USA dollár (aznapi)",
    "UYI" to "Uruguayi peso en unidades indexadas",
    "UYP" to "Uruguay-i peso (1975–1993)",
    "UYU" to "uruguayi peso",
    "UZS" to "üzbegisztáni szom",
    "VEB" to "Venezuelai bolivar (1871–2008)",
    "VEF" to "venezuelai bolivar (2008–2018)",
    "VES" to "venezuelai bolivar",
    "VND" to "vietnámi dong",
    "VNN" to "vietnámi dong (1978–1985)",
    "VUV" to "vanuatui vatu",
    "WST" to "nyugat-szamoai tala",
    "XAF" to "CFA frank BEAC",
    "XAG" to "Ezüst",
    "XAU" to "Arany",
    "XBA" to "Európai kompozit egység",
    "XBB" to "Európai monetáris egység",
    "XBC" to "Európai kontó egység (XBC)",
    "XBD" to "Európai kontó egység (XBD)",
    "XCD" to "kelet-karibi dollár",
    "XDR" to "Special Drawing Rights",
    "XEU" to "európai pénznemegység",
    "XFO" to "Francia arany frank",
    "XFU" to "Francia UIC-frank",
    "XOF" to "CFA frank BCEAO",
    "XPD" to "palládium",
    "XPF" to "csendes-óceáni valutaközösségi frank",
    "XPT" to "platina",
    "XRE" to "RINET tőke",
    "XTS" to "Tesztelési pénznemkód",
    "XXX" to "ismeretlen pénznem",
    "YDD" to "Jemeni dínár",
    "YER" to "jemeni riál",
    "YUD" to "Jugoszláv kemény dínár",
    "YUM" to "Jugoszláv új dínár",
    "YUN" to "Jugoszláv konvertibilis dínár",
    "YUR" to "jugoszláv reformált dinár (1992–1993)",
    "ZAL" to "Dél-afrikai rand (pénzügyi)",
    "ZAR" to "dél-afrikai rand",
    "ZMK" to "Zambiai kwacha (1968–2012)",
    "ZMW" to "zambiai kwacha",
    "ZRN" to "Zairei új zaire",
    "ZRZ" to "Zairei zaire",
    "ZWD" to "Zimbabwei dollár (1980–2008)",
    "ZWL" to "Zimbabwei dollár (2009)",
    "ZWR" to "Zimbabwei dollár (2008)",
  ) }

  val hy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Արաբական Միացյալ Էմիրությունների դիրհամ",
    "AFN" to "աֆղանական աֆղանի",
    "ALL" to "ալբանական լեկ",
    "AMD" to "հայկական դրամ",
    "ANG" to "նիդեռլանդական անտիլյան գուլդեն",
    "AOA" to "անգոլական կվանզա",
    "ARS" to "արգենտինական պեսո",
    "AUD" to "ավստրալիական դոլար",
    "AWG" to "արուբական ֆլորին",
    "AZN" to "ադրբեջանական մանաթ",
    "BAM" to "Բոսնիա և Հերցեգովինայի փոխարկվող մարկ",
    "BBD" to "բարբադոսյան դոլար",
    "BDT" to "Բանգլադեշի տակա",
    "BGN" to "բուլղարական լև",
    "BHD" to "Բահրեյնի դինար",
    "BIF" to "բուրունդիական ֆրանկ",
    "BMD" to "բերմուդյան դոլար",
    "BND" to "Բրունեյի դոլար",
    "BOB" to "բոլիվիական բոլիվիանո",
    "BRL" to "բրազիլական ռեալ",
    "BSD" to "բահամյան դոլար",
    "BTN" to "բութանական նգուլտրում",
    "BWP" to "բոտսվանական պուլա",
    "BYN" to "բելառուսական ռուբլի",
    "BYR" to "Բելառուսական ռուբլի (2000–2016)",
    "BZD" to "Բելիզի դոլար",
    "CAD" to "կանադական դոլար",
    "CDF" to "Կոնգոյի ֆրանկ",
    "CHF" to "շվեյցարական ֆրանկ",
    "CLP" to "չիլիական պեսո",
    "CNH" to "չինական օֆշորային յուան",
    "CNY" to "չինական յուան",
    "COP" to "կոլումբիական պեսո",
    "CRC" to "Կոստա Ռիկայի կոլոն",
    "CUC" to "կուբայական փոխարկվող պեսո",
    "CUP" to "կուբայական պեսո",
    "CVE" to "Կաբո Վերդեի էսկուդո",
    "CZK" to "չեխական կրոնա",
    "DJF" to "Ջիբութիի ֆրանկ",
    "DKK" to "դանիական կրոն",
    "DOP" to "դոմինիկյան պեսո",
    "DZD" to "ալժիրական դինար",
    "EGP" to "եգիպտական ֆունտ",
    "ERN" to "էրիթրեական նակվա",
    "ETB" to "եթովպիական բիր",
    "EUR" to "եվրո",
    "FJD" to "ֆիջիական դոլար",
    "FKP" to "Ֆոլքլենդյան կղզիների ֆունտ",
    "GBP" to "բրիտանական ֆունտ ստերլինգ",
    "GEL" to "վրացական լարի",
    "GHS" to "գայանական սեդի",
    "GIP" to "Ջիբրալթարի ֆունտ",
    "GMD" to "գամբիական դալասի",
    "GNF" to "գվինեական ֆրանկ",
    "GTQ" to "գվատեմալական կետսալ",
    "GYD" to "գայանական դոլար",
    "HKD" to "Հոնկոնգի դոլար",
    "HNL" to "հոնդուրասական լեմպիրա",
    "HRK" to "խորվաթական կունա",
    "HTG" to "հայիթյան գուրդ",
    "HUF" to "հունգարական ֆորինտ",
    "IDR" to "ինդոնեզիական ռուփի",
    "ILS" to "Իսրայելի նոր շեկել",
    "INR" to "հնդկական ռուփի",
    "IQD" to "իրաքյան դինար",
    "IRR" to "իրանական ռիալ",
    "ISK" to "իսլանդական կրոն",
    "JMD" to "Ճամայկայի դոլար",
    "JOD" to "հորդանանյան դինար",
    "JPY" to "ճապոնական իեն",
    "KES" to "քենիական շիլինգ",
    "KGS" to "ղրղզական սոմ",
    "KHR" to "կամբոջական ռիել",
    "KMF" to "կոմորյան ֆրանկ",
    "KPW" to "հյուսիսկորեական վոն",
    "KRW" to "հարավկորեական վոն",
    "KWD" to "Քուվեյթի դինար",
    "KYD" to "Կայմանյան կղզիների դոլար",
    "KZT" to "ղազախական տենգե",
    "LAK" to "լաոսական կիպ",
    "LBP" to "լիբանանյան ֆունտ",
    "LKR" to "Շրի Լանկայի ռուփի",
    "LRD" to "լիբերիական դոլար",
    "LSL" to "լեսոթոյական լոտի",
    "LTL" to "Լիտվական լիտ",
    "LVL" to "Լատվիական լատ",
    "LYD" to "լիբիական դինար",
    "MAD" to "Մարոկկոյի դիրհամ",
    "MDL" to "մոլդովական լեյ",
    "MGA" to "Մադագասկարի արիարի",
    "MKD" to "մակեդոնական դենար",
    "MMK" to "Մյանմայի կյատ",
    "MNT" to "մոնղոլական տուգրիկ",
    "MOP" to "Մակաոյի պատակա",
    "MRO" to "մավրիտանական ուգիյա (1973–2017)",
    "MRU" to "մավրիտանական ուգիյա",
    "MUR" to "մավրիկյան ռուփի",
    "MVR" to "մալդիվյան ռուֆիյա",
    "MWK" to "մալավիական կվաչա",
    "MXN" to "մեքսիկական պեսո",
    "MYR" to "մալայզիական ռինգիտ",
    "MZN" to "մոզամբիկյան մետիկալ",
    "NAD" to "նամիբիական դոլար",
    "NGN" to "նիգերիական նայրա",
    "NIO" to "նիկարագուական կորդոբա",
    "NOK" to "նորվեգական կրոն",
    "NPR" to "Նեպալի ռուփի",
    "NZD" to "նորզելանդական դոլար",
    "OMR" to "Օմանի ռիալ",
    "PAB" to "պանամական բալբոա",
    "PEN" to "Պերուի սոլ",
    "PGK" to "Պապուա Նոր Գվինեայի կինա",
    "PHP" to "ֆիլիպինյան պեսո",
    "PKR" to "պակիստանյան ռուփի",
    "PLN" to "լեհական զլոտի",
    "PYG" to "պարագվայական գուարանի",
    "QAR" to "Կատարի ռիալ",
    "RON" to "ռումինական լեյ",
    "RSD" to "սերբական դինար",
    "RUB" to "ռուսական ռուբլի",
    "RWF" to "ռուանդական ֆրանկ",
    "SAR" to "Սաուդյան Արաբիայի ռիալ",
    "SBD" to "Սողոմոնյան կղզիների դոլար",
    "SCR" to "սեյշելյան ռուփի",
    "SDG" to "սուդանական ֆունտ",
    "SEK" to "շվեդական կրոն",
    "SGD" to "Սինգապուրի դոլար",
    "SHP" to "Սուրբ Հեղինեի ֆունտ",
    "SLE" to "Սիեռա Լեոնեի լեոնե",
    "SLL" to "Սիեռա Լեոնեի լեոնե (1964—2022)",
    "SOS" to "սոմալիական շիլինգ",
    "SRD" to "սուրինամական դոլար",
    "SSP" to "հարավսուդանական ֆունտ",
    "STD" to "Սան Տոմե և Փրինսիպիի դոբրա (1977–2017)",
    "STN" to "Սան Տոմե և Փրինսիպիի դոբրա",
    "SYP" to "սիրիական ֆունտ",
    "SZL" to "սվազիլենդական լիլանգենի",
    "THB" to "թաիլանդական բահտ",
    "TJS" to "տաջիկական սոմոնի",
    "TMT" to "թուրքմենական մանաթ",
    "TND" to "թունիսյան դինար",
    "TOP" to "Տոնգայի պաանգա",
    "TRY" to "թուրքական լիրա",
    "TTD" to "Տրինիդադ և Տոբագոյի դոլար",
    "TWD" to "թայվանական նոր դոլար",
    "TZS" to "տանզանիական շիլինգ",
    "UAH" to "ուկրաինական գրիվնա",
    "UGX" to "ուգանդական շիլինգ",
    "USD" to "ԱՄՆ դոլար",
    "UYU" to "ուրուգվայական պեսո",
    "UZS" to "ուզբեկական սոմ",
    "VEF" to "վենեսուելական բոլիվար (2008–2018)",
    "VES" to "վենեսուելական բոլիվար",
    "VND" to "վիետնամական դոնգ",
    "VUV" to "Վանուատուի վատու",
    "WST" to "սամոական տալա",
    "XAF" to "Կենտրոնական Աֆրիկայի ԿՖԱ ֆրանկ",
    "XCD" to "արևելակարիբյան դոլար",
    "XOF" to "Արևմտյան Աֆրիկայի ԿՖԱ ֆրանկ",
    "XPF" to "ԿՊՖ ֆրանկ",
    "XXX" to "անհայտ արժույթ",
    "YER" to "եմենական ռիալ",
    "ZAR" to "հարավաֆրիկյան ռանդ",
    "ZMK" to "Զամբիական կվաչա (1968–2012)",
    "ZMW" to "զամբիական կվաչա",
  ) }

  val ia: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "dirham del Emiratos Arabe Unite",
    "AFN" to "afghani",
    "ALL" to "lek albanese",
    "AMD" to "dram armenie",
    "ANG" to "florino antillan",
    "AOA" to "kwanza angolan",
    "ARS" to "peso argentin",
    "AUD" to "dollar australian",
    "AWG" to "florino aruban",
    "AZN" to "manat azeri",
    "BAM" to "marco convertibile de Bosnia-Herzegovina",
    "BBD" to "dollar barbadian",
    "BDT" to "taka bengalese",
    "BGN" to "lev bulgare",
    "BHD" to "dinar bahreini",
    "BIF" to "franco burundese",
    "BMD" to "dollar bermudan",
    "BND" to "dollar de Brunei",
    "BOB" to "boliviano bolivian",
    "BRL" to "real brasilian",
    "BSD" to "dollar bahamian",
    "BTN" to "ngultrum bhutanese",
    "BWP" to "pula botswanese",
    "BYN" to "rublo bielorusse",
    "BZD" to "dollar belizan",
    "CAD" to "dollar canadian",
    "CDF" to "franco congolese",
    "CHF" to "franco suisse",
    "CLP" to "peso chilen",
    "CNH" to "yuan chinese (extracontinental)",
    "CNY" to "yuan chinese",
    "COP" to "peso colombian",
    "CRC" to "colon costarican",
    "CUC" to "peso cuban convertibile",
    "CUP" to "peso cuban",
    "CVE" to "escudo capoverdian",
    "CZK" to "corona chec",
    "DEM" to "Marco geman",
    "DJF" to "franco djibutian",
    "DKK" to "corona danese",
    "DOP" to "peso dominican",
    "DZD" to "dinar algerin",
    "EEK" to "Corona estonian",
    "EGP" to "libra egyptie",
    "ERN" to "nakfa eritree",
    "ETB" to "birr ethiope",
    "EUR" to "euro",
    "FIM" to "Marco finnese",
    "FJD" to "dollar fijian",
    "FKP" to "libra falklandese",
    "FRF" to "Franco francese",
    "GBP" to "libra sterling",
    "GEL" to "lari georgian",
    "GHS" to "cedi ghanese",
    "GIP" to "libra de Gibraltar",
    "GMD" to "dalasi gambian",
    "GNF" to "franco guinean",
    "GTQ" to "quetzal guatemaltec",
    "GYD" to "dollar guyanese",
    "HKD" to "dollar hongkongese",
    "HNL" to "lempira hondurese",
    "HRK" to "kuna croate",
    "HTG" to "gourde haitian",
    "HUF" to "forint hungare",
    "IDR" to "rupia indonesian",
    "IEP" to "Libra irlandese",
    "ILS" to "nove shekel israeli",
    "INR" to "rupia indian",
    "IQD" to "dinar iraqi",
    "IRR" to "rial iranian",
    "ISK" to "corona islandese",
    "JMD" to "dollar jamaican",
    "JOD" to "dinar jordan",
    "JPY" to "yen japonese",
    "KES" to "shilling kenyan",
    "KGS" to "som kirghiz",
    "KHR" to "riel cambodgian",
    "KMF" to "franco comorian",
    "KPW" to "won nordkorean",
    "KRW" to "won sudkorean",
    "KWD" to "dinar kuwaiti",
    "KYD" to "dollar del Insulas Caiman",
    "KZT" to "tenge kazakh",
    "LAK" to "kip laotian",
    "LBP" to "libra libanese",
    "LKR" to "rupia de Sri Lanka",
    "LRD" to "dollar liberian",
    "LSL" to "loti de Lesotho",
    "LYD" to "dinar libyc",
    "MAD" to "dirham marocchin",
    "MDL" to "leu moldave",
    "MGA" to "ariary malgache",
    "MKD" to "denar macedonie",
    "MMK" to "kyat de Myanmar",
    "MNT" to "tugrik mongol",
    "MOP" to "pataca de Macao",
    "MRO" to "ouguiya mauritan (1973–2017)",
    "MRU" to "ouguiya mauritan",
    "MUR" to "rupia mauritian",
    "MVR" to "rufiyaa del Maldivas",
    "MWK" to "kwacha malawian",
    "MXN" to "peso mexican",
    "MYR" to "ringgit malay",
    "MZN" to "metical mozambican",
    "NAD" to "dollar namibian",
    "NGN" to "naira nigerian",
    "NIO" to "cordoba nicaraguan",
    "NLG" to "Florino nederlandese",
    "NOK" to "corona norvegian",
    "NPR" to "rupia nepalese",
    "NZD" to "dollar neozelandese",
    "OMR" to "rial omani",
    "PAB" to "balboa panamen",
    "PEN" to "sol peruvian",
    "PGK" to "kina papuan",
    "PHP" to "peso philippin",
    "PKR" to "rupia pakistani",
    "PLN" to "zloty polonese",
    "PYG" to "guarani paraguayan",
    "QAR" to "rial qatari",
    "RON" to "leu romanian",
    "RSD" to "dinar serbe",
    "RUB" to "rublo russe",
    "RWF" to "franco ruandese",
    "SAR" to "rial saudi",
    "SBD" to "dollar del insulas Salomon",
    "SCR" to "rupia seychellese",
    "SDG" to "libra sudanese",
    "SEK" to "corona svedese",
    "SGD" to "dollar singaporese",
    "SHP" to "libra de St. Helena",
    "SLE" to "leone sierraleonese",
    "SLL" to "leone sierraleonese (1964—2022)",
    "SOS" to "shilling somali",
    "SRD" to "dollar surinamese",
    "SSP" to "libra sud-sudanese",
    "STN" to "dobra de São Tomé e Príncipe",
    "SYP" to "libra syriac",
    "SZL" to "lilangeni swazilandese",
    "THB" to "baht thailandese",
    "TJS" to "somoni tajik",
    "TMT" to "manat turkmen",
    "TND" to "dinar tunisian",
    "TOP" to "paʻanga tongan",
    "TRY" to "lira turc",
    "TTD" to "dollar de Trinidad e Tobago",
    "TWD" to "nove dollar taiwanese",
    "TZS" to "shilling tanzanian",
    "UAH" to "hryvnia ukrainian",
    "UGX" to "shilling ugandese",
    "USD" to "dollar statounitese",
    "UYU" to "peso uruguayan",
    "UZS" to "som uzbek",
    "VEF" to "bolivar venezuelan (2008–2018)",
    "VES" to "bolivar venezuelan",
    "VND" to "dong vietnamese",
    "VUV" to "vatu vanuatuan",
    "WST" to "tala samoan",
    "XAF" to "franco CFA de Africa Central",
    "XCD" to "dollar del Caribes Oriental",
    "XOF" to "franco CFA de Africa Occidental",
    "XPF" to "franco CFP",
    "XXX" to "moneta incognite",
    "YER" to "rial yemeni",
    "ZAR" to "rand sudafrican",
    "ZMW" to "kwacha zambian",
  ) }

  val id: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Peseta Andorra",
    "AED" to "Dirham Uni Emirat Arab",
    "AFA" to "Afgani Afganistan (1927–2002)",
    "AFN" to "Afgani Afganistan",
    "ALL" to "Lek Albania",
    "AMD" to "Dram Armenia",
    "ANG" to "Guilder Antilla Belanda",
    "AOA" to "Kwanza Angola",
    "AOK" to "Kwanza Angola (1977–1991)",
    "AON" to "Kwanza Baru Angola (1990–2000)",
    "AOR" to "Kwanza Angola yang Disesuaikan Lagi (1995–1999)",
    "ARA" to "Austral Argentina",
    "ARL" to "Peso Ley Argentina (1970–1983)",
    "ARM" to "Peso Argentina (1881–1970)",
    "ARP" to "Peso Argentina (1983–1985)",
    "ARS" to "Peso Argentina",
    "ATS" to "Schilling Austria",
    "AUD" to "Dolar Australia",
    "AWG" to "Florin Aruba",
    "AZM" to "Manat Azerbaijan (1993–2006)",
    "AZN" to "Manat Azerbaijan",
    "BAD" to "Dinar Bosnia-Herzegovina (1992–1994)",
    "BAM" to "Mark Konvertibel Bosnia-Herzegovina",
    "BAN" to "Dinar Baru Bosnia-Herzegovina (1994–1997)",
    "BBD" to "Dolar Barbados",
    "BDT" to "Taka Bangladesh",
    "BEC" to "Franc Belgia (konvertibel)",
    "BEF" to "Franc Belgia",
    "BEL" to "Franc Belgia (keuangan)",
    "BGL" to "Hard Lev Bulgaria",
    "BGM" to "Socialist Lev Bulgaria",
    "BGN" to "Lev Bulgaria",
    "BGO" to "Lev Bulgaria (1879–1952)",
    "BHD" to "Dinar Bahrain",
    "BIF" to "Franc Burundi",
    "BMD" to "Dolar Bermuda",
    "BND" to "Dolar Brunei",
    "BOB" to "Boliviano",
    "BOL" to "Boliviano Bolivia (1863–1963)",
    "BOP" to "Peso Bolivia",
    "BOV" to "Mvdol Bolivia",
    "BRB" to "Cruzeiro Baru Brasil (1967–1986)",
    "BRC" to "Cruzado Brasil (1986–1989)",
    "BRE" to "Cruzeiro Brasil (1990–1993)",
    "BRL" to "Real Brasil",
    "BRN" to "Cruzado Baru Brasil (1989–1990)",
    "BRR" to "Cruzeiro Brasil (1993–1994)",
    "BRZ" to "Cruzeiro Brasil (1942–1967)",
    "BSD" to "Dolar Bahama",
    "BTN" to "Ngultrum Bhutan",
    "BUK" to "Kyat Burma",
    "BWP" to "Pula Botswana",
    "BYB" to "Rubel Baru Belarus (1994–1999)",
    "BYN" to "Rubel Belarusia",
    "BYR" to "Rubel Belarusia (2000–2016)",
    "BZD" to "Dolar Belize",
    "CAD" to "Dolar Kanada",
    "CDF" to "Franc Kongo",
    "CHE" to "Euro WIR",
    "CHF" to "Franc Swiss",
    "CHW" to "Franc WIR",
    "CLE" to "Escudo Cile",
    "CLF" to "Satuan Hitung (UF) Cile",
    "CLP" to "Peso Cile",
    "CNH" to "Yuan Tiongkok (luar negeri)",
    "CNY" to "Yuan Tiongkok",
    "COP" to "Peso Kolombia",
    "COU" to "Unit Nilai Nyata Kolombia",
    "CRC" to "Colon Kosta Rika",
    "CSD" to "Dinar Serbia (2002–2006)",
    "CSK" to "Hard Koruna Cheska",
    "CUC" to "Peso Konvertibel Kuba",
    "CUP" to "Peso Kuba",
    "CVE" to "Escudo Tanjung Verde",
    "CYP" to "Pound Siprus",
    "CZK" to "Koruna Ceko",
    "DDM" to "Mark Jerman Timur",
    "DEM" to "Mark Jerman",
    "DJF" to "Franc Jibuti",
    "DKK" to "Krone Denmark",
    "DOP" to "Peso Dominika",
    "DZD" to "Dinar Aljazair",
    "ECS" to "Sucre Ekuador",
    "ECV" to "Satuan Nilai Tetap Ekuador",
    "EEK" to "Kroon Estonia",
    "EGP" to "Pound Mesir",
    "ERN" to "Nakfa Eritrea",
    "ESA" to "Peseta Spanyol (akun)",
    "ESB" to "Peseta Spanyol (konvertibel)",
    "ESP" to "Peseta Spanyol",
    "ETB" to "Birr Etiopia",
    "EUR" to "Euro",
    "FIM" to "Markka Finlandia",
    "FJD" to "Dolar Fiji",
    "FKP" to "Pound Kepulauan Falkland",
    "FRF" to "Franc Prancis",
    "GBP" to "Pound Inggris",
    "GEK" to "Kupon Larit Georgia",
    "GEL" to "Lari Georgia",
    "GHC" to "Cedi Ghana (1979–2007)",
    "GHS" to "Cedi Ghana",
    "GIP" to "Pound Gibraltar",
    "GMD" to "Dalasi Gambia",
    "GNF" to "Franc Guinea",
    "GNS" to "Syli Guinea",
    "GQE" to "Ekuele Guinea Ekuatorial",
    "GRD" to "Drachma Yunani",
    "GTQ" to "Quetzal Guatemala",
    "GWE" to "Escudo Guinea Portugal",
    "GWP" to "Peso Guinea-Bissau",
    "GYD" to "Dolar Guyana",
    "HKD" to "Dolar Hong Kong",
    "HNL" to "Lempira Honduras",
    "HRD" to "Dinar Kroasia",
    "HRK" to "Kuna Kroasia",
    "HTG" to "Gourde Haiti",
    "HUF" to "Forint Hungaria",
    "IDR" to "Rupiah Indonesia",
    "IEP" to "Pound Irlandia",
    "ILP" to "Pound Israel",
    "ILR" to "Shekel Israel",
    "ILS" to "Shekel Baru Israel",
    "INR" to "Rupee India",
    "IQD" to "Dinar Irak",
    "IRR" to "Rial Iran",
    "ISJ" to "Krona Islandia (1918–1981)",
    "ISK" to "Krona Islandia",
    "ITL" to "Lira Italia",
    "JMD" to "Dolar Jamaika",
    "JOD" to "Dinar Yordania",
    "JPY" to "Yen Jepang",
    "KES" to "Shilling Kenya",
    "KGS" to "Som Kirgizstan",
    "KHR" to "Riel Kamboja",
    "KMF" to "Franc Komoro",
    "KPW" to "Won Korea Utara",
    "KRH" to "Hwan Korea Selatan (1953–1962)",
    "KRO" to "Won Korea Selatan (1945–1953)",
    "KRW" to "Won Korea Selatan",
    "KWD" to "Dinar Kuwait",
    "KYD" to "Dolar Kepulauan Cayman",
    "KZT" to "Tenge Kazakhstan",
    "LAK" to "Kip Laos",
    "LBP" to "Pound Lebanon",
    "LKR" to "Rupee Sri Lanka",
    "LRD" to "Dolar Liberia",
    "LSL" to "Loti Lesotho",
    "LTL" to "Litas Lituania",
    "LTT" to "Talonas Lituania",
    "LUC" to "Franc Konvertibel Luksemburg",
    "LUF" to "Franc Luksemburg",
    "LUL" to "Financial Franc Luksemburg",
    "LVL" to "Lats Latvia",
    "LVR" to "Rubel Latvia",
    "LYD" to "Dinar Libya",
    "MAD" to "Dirham Maroko",
    "MAF" to "Franc Maroko",
    "MCF" to "Franc Monegasque",
    "MDC" to "Cupon Moldova",
    "MDL" to "Leu Moldova",
    "MGA" to "Ariary Madagaskar",
    "MGF" to "Franc Malagasi",
    "MKD" to "Denar Makedonia",
    "MKN" to "Denar Makedonia (1992–1993)",
    "MLF" to "Franc Mali",
    "MMK" to "Kyat Myanmar",
    "MNT" to "Tugrik Mongolia",
    "MOP" to "Pataca Makau",
    "MRO" to "Ouguiya Mauritania (1973–2017)",
    "MRU" to "Ouguiya Mauritania",
    "MTL" to "Lira Malta",
    "MTP" to "Pound Malta",
    "MUR" to "Rupee Mauritius",
    "MVP" to "Rufiyaa Maladewa (1947–1981)",
    "MVR" to "Rufiyaa Maladewa",
    "MWK" to "Kwacha Malawi",
    "MXN" to "Peso Meksiko",
    "MXP" to "Peso Silver Meksiko (1861–1992)",
    "MXV" to "Unit Investasi Meksiko",
    "MYR" to "Ringgit Malaysia",
    "MZE" to "Escudo Mozambik",
    "MZM" to "Metical Mozambik (1980–2006)",
    "MZN" to "Metical Mozambik",
    "NAD" to "Dolar Namibia",
    "NGN" to "Naira Nigeria",
    "NIC" to "Cordoba Nikaragua (1988–1991)",
    "NIO" to "Cordoba Nikaragua",
    "NLG" to "Guilder Belanda",
    "NOK" to "Krone Norwegia",
    "NPR" to "Rupee Nepal",
    "NZD" to "Dolar Selandia Baru",
    "OMR" to "Rial Oman",
    "PAB" to "Balboa Panama",
    "PEI" to "Inti Peru",
    "PEN" to "Sol Peru",
    "PES" to "Sol Peru (1863–1965)",
    "PGK" to "Kina Papua Nugini",
    "PHP" to "Peso Filipina",
    "PKR" to "Rupee Pakistan",
    "PLN" to "Zloty Polandia",
    "PLZ" to "Zloty Polandia (1950–1995)",
    "PTE" to "Escudo Portugal",
    "PYG" to "Guarani Paraguay",
    "QAR" to "Rial Qatar",
    "RHD" to "Dolar Rhodesia",
    "ROL" to "Leu Rumania (1952–2006)",
    "RON" to "Leu Rumania",
    "RSD" to "Dinar Serbia",
    "RUB" to "Rubel Rusia",
    "RUR" to "Rubel Rusia (1991–1998)",
    "RWF" to "Franc Rwanda",
    "SAR" to "Riyal Arab Saudi",
    "SBD" to "Dolar Kepulauan Solomon",
    "SCR" to "Rupee Seychelles",
    "SDD" to "Dinar Sudan (1992–2007)",
    "SDG" to "Pound Sudan",
    "SDP" to "Pound Sudan (1957–1998)",
    "SEK" to "Krona Swedia",
    "SGD" to "Dolar Singapura",
    "SHP" to "Pound Saint Helena",
    "SIT" to "Tolar Slovenia",
    "SKK" to "Koruna Slovakia",
    "SLE" to "Leone Sierra Leone",
    "SLL" to "Leone Sierra Leone (1964—2022)",
    "SOS" to "Shilling Somalia",
    "SRD" to "Dolar Suriname",
    "SRG" to "Guilder Suriname",
    "SSP" to "Pound Sudan Selatan",
    "STD" to "Dobra Sao Tome dan Principe (1977–2017)",
    "STN" to "Dobra Sao Tome dan Principe",
    "SUR" to "Rubel Soviet",
    "SVC" to "Colon El Savador",
    "SYP" to "Pound Suriah",
    "SZL" to "Lilangeni Swaziland",
    "THB" to "Baht Thailand",
    "TJR" to "Rubel Tajikistan",
    "TJS" to "Somoni Tajikistan",
    "TMM" to "Manat Turkmenistan (1993–2009)",
    "TMT" to "Manat Turkmenistan",
    "TND" to "Dinar Tunisia",
    "TOP" to "Paʻanga Tonga",
    "TPE" to "Escudo Timor",
    "TRL" to "Lira Turki (1922–2005)",
    "TRY" to "Lira Turki",
    "TTD" to "Dolar Trinidad dan Tobago",
    "TWD" to "Dolar Baru Taiwan",
    "TZS" to "Shilling Tanzania",
    "UAH" to "Hryvnia Ukraina",
    "UAK" to "Karbovanet Ukraina",
    "UGS" to "Shilling Uganda (1966–1987)",
    "UGX" to "Shilling Uganda",
    "USD" to "Dolar Amerika Serikat",
    "USN" to "Dolar AS (Hari berikutnya)",
    "USS" to "Dolar AS (Hari yang sama)",
    "UYI" to "Peso Uruguay (Unit Diindeks)",
    "UYP" to "Peso Uruguay (1975–1993)",
    "UYU" to "Peso Uruguay",
    "UZS" to "Som Uzbekistan",
    "VEB" to "Bolivar Venezuela (1871–2008)",
    "VEF" to "Bolivar Venezuela (2008–2018)",
    "VES" to "Bolivar Venezuela",
    "VND" to "Dong Vietnam",
    "VNN" to "Dong Vietnam (1978–1985)",
    "VUV" to "Vatu Vanuatu",
    "WST" to "Tala Samoa",
    "XAF" to "Franc CFA Afrika Tengah",
    "XAG" to "Silver",
    "XAU" to "Emas",
    "XBA" to "Unit Gabungan Eropa",
    "XBB" to "Unit Keuangan Eropa",
    "XBC" to "Satuan Hitung Eropa (XBC)",
    "XBD" to "Satuan Hitung Eropa (XBD)",
    "XCD" to "Dolar Karibia Timur",
    "XDR" to "Hak Khusus Menggambar",
    "XEU" to "Satuan Mata Uang Eropa",
    "XFO" to "Franc Gold Perancis",
    "XFU" to "Franc UIC Perancis",
    "XOF" to "Franc CFA Afrika Barat",
    "XPD" to "Palladium",
    "XPF" to "Franc CFP",
    "XPT" to "Platinum",
    "XRE" to "Dana RINET",
    "XTS" to "Kode Mata Uang Pengujian",
    "XXX" to "Mata Uang Tidak Dikenal",
    "YDD" to "Dinar Yaman",
    "YER" to "Rial Yaman",
    "YUD" to "Hard Dinar Yugoslavia (1966–1990)",
    "YUM" to "Dinar Baru Yugoslavia (1994–2002)",
    "YUN" to "Dinar Konvertibel Yugoslavia (1990–1992)",
    "YUR" to "Dinar Reformasi Yugoslavia (1992–1993)",
    "ZAL" to "Rand Afrika Selatan (Keuangan)",
    "ZAR" to "Rand Afrika Selatan",
    "ZMK" to "Kwacha Zambia (1968–2012)",
    "ZMW" to "Kwacha Zambia",
    "ZRN" to "Zaire Baru Zaire (1993–1998)",
    "ZRZ" to "Zaire Zaire (1971–1993)",
    "ZWD" to "Dolar Zimbabwe (1980–2008)",
    "ZWL" to "Dolar Zimbabwe (2009)",
    "ZWR" to "Dolar Zimbabwe (2008)",
  ) }

  val ie: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ig: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Ego Dirham obodo United Arab Emirates",
    "AFN" to "Ego Afghani Obodo Afghanistan",
    "ALL" to "Ego Lek Obodo Albania",
    "AMD" to "Ego Dram obodo Armenia",
    "ANG" to "Ego Antillean Guilder obodo Netherlands",
    "AOA" to "Ego Kwanza obodo Angola",
    "ARS" to "Ego Peso obodo Argentina",
    "AUD" to "Ego Dollar obodo Australia",
    "AWG" to "Ego Florin obodo Aruba",
    "AZN" to "Ego Manat obodo Azerbaijan",
    "BAM" to "Akara mgbanwe ego obodo Bosnia-Herzegovina",
    "BBD" to "Ego Dollar obodo Barbados",
    "BDT" to "Ego Taka obodo Bangladesh",
    "BGN" to "Ego Lev mba Bulgaria",
    "BHD" to "Ego Dinar Obodo Bahrain",
    "BIF" to "Ego Franc obodo Burundi",
    "BMD" to "Dollar Bermuda",
    "BND" to "Ego Dollar obodo Brunei",
    "BOB" to "Ego Boliviano obodo Bolivia",
    "BRL" to "Real Brazil",
    "BSD" to "Ego Dollar Obodo Bahamas",
    "BTN" to "Ego Ngultrum obodo Bhutan",
    "BWP" to "Ego Pula obodo Bostwana",
    "BYN" to "Ego Ruble mba Belarus",
    "BZD" to "Dollar Belize",
    "CAD" to "Dollar Canada",
    "CDF" to "Ego Franc obodo Congo",
    "CHF" to "Ego Franc mba Switzerland",
    "CLP" to "Ego Peso obodo Chile",
    "CNH" to "Ego Yuan Obodo China (ndị bi na mmiri)",
    "CNY" to "Yuan China",
    "COP" to "Ego Peso obodo Columbia",
    "CRC" to "Ego Colón obodo Costa Rica",
    "CUC" to "Ego Peso e nwere ike ịgbanwe nke obodo Cuba",
    "CUP" to "Ego Peso obodo Cuba",
    "CVE" to "Escudo Caboverdiano",
    "CZK" to "Ego Koruna obodo Czech",
    "DJF" to "Ego Franc obodo Djibouti",
    "DKK" to "Ego Krone Obodo Denmark",
    "DOP" to "Ego Peso Obodo Dominica",
    "DZD" to "Ego Dinar Obodo Algeria",
    "EGP" to "Ego Pound obodo Egypt",
    "ERN" to "Ego Nakfa obodo Eritrea",
    "ETB" to "Ego Birr obodo Ethiopia",
    "EUR" to "Euro",
    "FJD" to "Ego Dollar obodo Fiji",
    "FKP" to "Ego Pound obodo Falkland Islands",
    "GBP" to "Pound British",
    "GEL" to "Ego Lari Obodo Georgia",
    "GHS" to "Ego Cedi obodo Ghana",
    "GIP" to "Ego Pound obodo Gibraltar",
    "GMD" to "Ego Dalasi obodo Gambia",
    "GNF" to "Ego Franc obodo Guinea",
    "GTQ" to "Ego Quetzal obodo Guatemala",
    "GYD" to "Ego Dollar obodo Guyana",
    "HKD" to "Ego Dollar Obodo Honk Kong",
    "HNL" to "Ego Lempira obodo Honduras",
    "HRK" to "Ego Kuna obodo Croatia",
    "HTG" to "Ego Gourde obodo Haiti",
    "HUF" to "Ego Forint obodo Hungary",
    "IDR" to "Ego Rupiah Obodo Indonesia",
    "ILS" to "Ego Shekel ọhụrụ obodo Israel",
    "INR" to "Rupee India",
    "IQD" to "Ego Dinar obodo Iraq",
    "IRR" to "Ego Rial obodo Iran",
    "ISK" to "Ego Króna obodo Iceland",
    "JMD" to "Ego Dollar obodo Jamaica",
    "JOD" to "Ego Dinar Obodo Jordan",
    "JPY" to "Yen Japan",
    "KES" to "Ego Shilling obodo Kenya",
    "KGS" to "Ego Som Obodo Kyrgyzstan",
    "KHR" to "Ego Riel obodo Cambodia",
    "KMF" to "Ego Franc obodo Comoros",
    "KPW" to "Ego Won Obodo North Korea",
    "KRW" to "Ego Won Obodo South Korea",
    "KWD" to "Ego Dinar Obodo Kuwait",
    "KYD" to "Ego Dollar obodo Cayman Islands",
    "KZT" to "Ego Tenge obodo Kazakhstani",
    "LAK" to "Ego Kip Obodo Laos",
    "LBP" to "Ego Pound obodo Lebanon",
    "LKR" to "Ego Rupee obodo Sri Lanka",
    "LRD" to "Ego Dollar obodo Liberia",
    "LSL" to "Ego loti obodo Lesotho",
    "LYD" to "Ego Dinar obodo Libya",
    "MAD" to "Ego Dirham obodo Morocco",
    "MDL" to "Ego Leu obodo Moldova",
    "MGA" to "Ego Ariary obodo Madagascar",
    "MKD" to "Ego Denar Obodo Macedonia",
    "MMK" to "Ego Kyat obodo Myanmar",
    "MNT" to "Ego Turgik Obodo Mongolia",
    "MOP" to "Ego Pataca ndị Obodo Macanese",
    "MRU" to "Ego Ouguiya Obodo Mauritania",
    "MUR" to "Ego Rupee obodo Mauritania",
    "MVR" to "Ego Rufiyaa obodo Moldova",
    "MWK" to "Ego Kwacha obodo Malawi",
    "MXN" to "Ego Peso obodo Mexico",
    "MYR" to "Ego Ringgit obodo Malaysia",
    "MZN" to "Ego Metical obodo Mozambique",
    "NAD" to "Ego Dollar obodo Namibia",
    "NGN" to "Naịra",
    "NIO" to "Ego Córodoba obodo Nicaragua",
    "NOK" to "Ego Krone Obodo Norway",
    "NPR" to "Ego Rupee obodo Nepal",
    "NZD" to "Ego Dollar obodo New Zealand",
    "OMR" to "Ego Rial obodo Oman",
    "PAB" to "Ego Balboa obodo Panama",
    "PEN" to "Ego Sol obodo Peru",
    "PGK" to "Ego Kina obodo Papua New Guinea",
    "PHP" to "Ego Piso obodo Philippine",
    "PKR" to "Ego Rupee obodo Pakistan",
    "PLN" to "Ego Zloty mba Poland",
    "PYG" to "Ego Guarani obodo Paraguay",
    "QAR" to "Ego Rial obodo Qatar",
    "RON" to "Ego Leu obodo Romania",
    "RSD" to "Ego Dinar obodo Serbia",
    "RUB" to "Ruble Russia",
    "RWF" to "Ego Franc obodo Rwanda",
    "SAR" to "Ego Riyal obodo Saudi",
    "SBD" to "Ego Dollar obodo Solomon Islands",
    "SCR" to "Ego Rupee obodo Seychelles",
    "SDG" to "Ego Pound obodo Sudan",
    "SEK" to "Ego Krona Obodo Sweden",
    "SGD" to "Ego Dollar obodo Singapore",
    "SHP" to "Ego Pound obodo St Helena",
    "SLE" to "Ego Leone obodo Sierra Leone",
    "SLL" to "Ego Leone obodo Sierra Leone (1964—2022)",
    "SOS" to "Ego shilling obodo Somali",
    "SRD" to "Dollar Surinamese",
    "SSP" to "Ego Pound obodo South Sudan",
    "STN" to "Ego Dobra nke obodo Sāo Tomé na Principe",
    "SYP" to "Ego Pound obodo Syria",
    "SZL" to "Ego Lilangeni obodo Swaziland",
    "THB" to "Ego Baht obodo Thai",
    "TJS" to "Who Somoni obodo Tajikistan",
    "TMT" to "Ego Manat Obodo Turkmenistan",
    "TND" to "Ego Dinar Obodo Tunisia",
    "TOP" to "Ego paʻanga obodo Tonga",
    "TRY" to "Ego Lira obodo Turkey",
    "TTD" to "Dollar Trinidad & Tobago",
    "TWD" to "Dollar obodo New Taiwan",
    "TZS" to "Ego Shilling Obodo Tanzania",
    "UAH" to "Ego Hryvnia obodo Ukraine",
    "UGX" to "Ego Shilling obodo Uganda",
    "USD" to "Dollar US",
    "UYU" to "Ego Peso obodo Uruguay",
    "UZS" to "Ego Som obodo Uzbekistan",
    "VES" to "Ego Bolivar obodo Venezuela",
    "VND" to "Ego Dong obodo Vietnam",
    "VUV" to "Ego Vatu obodo Vanuatu",
    "WST" to "Ego Tala obodo Samoa",
    "XAF" to "Ego Franc mba etiti Africa",
    "XCD" to "Ego Dollar obodo East Carribbean",
    "XOF" to "Ego CFA Franc obodo West Africa",
    "XPF" to "Ego Franc obodo CFP",
    "XXX" to "Ego Amaghị",
    "YER" to "Ego Rial obodo Yemeni",
    "ZAR" to "Ego Rand obodo South Africa",
    "ZMW" to "Ego Kwacha Obodo Zambia",
  ) }

  val ii: ImmutableMap<String, String> by lazy { immutableMapOf(
    "XXX" to "ꅉꀋꐚꌠꌋꆀꎆꃀꀋꈁꀐꌠ",
  ) }

  val io: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val `is`: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorrskur peseti",
    "AED" to "arabískt dírham",
    "AFN" to "afgani",
    "ALL" to "albanskt lek",
    "AMD" to "armenskt dramm",
    "ANG" to "hollenskt Antillugyllini",
    "AOA" to "angólsk kvansa",
    "ARA" to "Argentine Austral",
    "ARP" to "Argentískur pesi (1983–1985)",
    "ARS" to "argentínskur pesi",
    "ATS" to "Austurrískur skildingur",
    "AUD" to "ástralskur dalur",
    "AWG" to "arúbönsk flórína",
    "AZN" to "aserskt manat",
    "BAM" to "skiptanlegt Bosníu og Hersegóvínu-mark",
    "BBD" to "barbadoskur dalur",
    "BDT" to "bangladessk taka",
    "BEF" to "Belgískur franki",
    "BGL" to "Lef",
    "BGN" to "búlgarskt lef",
    "BHD" to "bareinskur denari",
    "BIF" to "búrúndískur franki",
    "BMD" to "Bermúdadalur",
    "BND" to "brúneiskur dalur",
    "BOB" to "bólivíani",
    "BOP" to "Bólivískur pesi",
    "BOV" to "Bolivian Mvdol",
    "BRL" to "brasilískt ríal",
    "BSD" to "Bahamadalur",
    "BTN" to "bútanskt núltrum",
    "BUK" to "Búrmverskt kjat",
    "BWP" to "botsvönsk púla",
    "BYN" to "hvítrússnesk rúbla",
    "BYR" to "hvítrússnesk rúbla (2000–2016)",
    "BZD" to "belískur dalur",
    "CAD" to "Kanadadalur",
    "CDF" to "kongóskur franki",
    "CHF" to "svissneskur franki",
    "CLF" to "Chilean Unidades de Fomento",
    "CLP" to "síleskur pesi",
    "CNH" to "kínverskt júan (utan heimalands)",
    "CNY" to "kínverskt júan",
    "COP" to "kólumbískur pesi",
    "CRC" to "kostarískt kólon",
    "CSK" to "Tékknesk króna, eldri",
    "CUC" to "kúbverskur skiptanlegur pesi",
    "CUP" to "kúbverskur pesi",
    "CVE" to "grænhöfðeyskur skúti",
    "CYP" to "Kýpverskt pund",
    "CZK" to "tékknesk króna",
    "DDM" to "Austurþýskt mark",
    "DEM" to "Þýskt mark",
    "DJF" to "djíbútískur franki",
    "DKK" to "dönsk króna",
    "DOP" to "dóminískur pesi",
    "DZD" to "alsírskur denari",
    "ECS" to "Ecuador Sucre",
    "EEK" to "Eistnesk króna",
    "EGP" to "egypskt pund",
    "ERN" to "erítresk nakfa",
    "ESP" to "Spænskur peseti",
    "ETB" to "eþíópískt birr",
    "EUR" to "evra",
    "FIM" to "Finnskt mark",
    "FJD" to "fídjískur dalur",
    "FKP" to "falklenskt pund",
    "FRF" to "Franskur franki",
    "GBP" to "sterlingspund",
    "GEL" to "georgískur lari",
    "GHS" to "ganverskur sedi",
    "GIP" to "Gíbraltarspund",
    "GMD" to "gambískur dalasi",
    "GNF" to "Gíneufranki",
    "GRD" to "Drakma",
    "GTQ" to "gvatemalskt kvesal",
    "GWE" to "Portúgalskur, gíneskur skúti",
    "GYD" to "gvæjanskur dalur",
    "HKD" to "Hong Kong-dalur",
    "HNL" to "hondúrsk lempíra",
    "HRK" to "króatísk kúna",
    "HTG" to "haítískur gúrdi",
    "HUF" to "ungversk fórinta",
    "IDR" to "indónesísk rúpía",
    "IEP" to "Írskt pund",
    "ILP" to "Ísraelskt pund",
    "ILS" to "nýr ísraelskur sikill",
    "INR" to "indversk rúpía",
    "IQD" to "írakskur denari",
    "IRR" to "íranskt ríal",
    "ISK" to "íslensk króna",
    "ITL" to "Ítölsk líra",
    "JMD" to "jamaískur dalur",
    "JOD" to "jórdanskur denari",
    "JPY" to "japanskt jen",
    "KES" to "kenískur skildingur",
    "KGS" to "kirgiskt som",
    "KHR" to "kambódískt ríal",
    "KMF" to "kómoreyskur franki",
    "KPW" to "norðurkóreskt vonn",
    "KRW" to "suðurkóreskt vonn",
    "KWD" to "kúveiskur denari",
    "KYD" to "caymaneyskur dalur",
    "KZT" to "kasakst tengi",
    "LAK" to "laoskt kip",
    "LBP" to "líbanskt pund",
    "LKR" to "srílönsk rúpía",
    "LRD" to "líberískur dalur",
    "LSL" to "lesótóskur lóti",
    "LTL" to "Litháískt lít",
    "LTT" to "Lithuanian Talonas",
    "LUF" to "Lúxemborgarfranki",
    "LVL" to "Lettneskt lat",
    "LVR" to "Lettnesk rúbla",
    "LYD" to "líbískur denari",
    "MAD" to "marokkóskt dírham",
    "MAF" to "Marokkóskur franki",
    "MDL" to "moldavískt lei",
    "MGA" to "Madagaskararjari",
    "MGF" to "Madagaskur franki",
    "MKD" to "makedónskur denari",
    "MLF" to "Malískur franki",
    "MMK" to "mjanmarskt kjat",
    "MNT" to "mongólskur túríkur",
    "MOP" to "makaósk pataka",
    "MRO" to "márítönsk úgía (1973–2017)",
    "MRU" to "márítönsk úgía",
    "MTL" to "Meltnesk líra",
    "MTP" to "Maltneskt pund",
    "MUR" to "máritísk rúpía",
    "MVR" to "maldíveysk rúpía",
    "MWK" to "malavísk kvaka",
    "MXN" to "mexíkóskur pesi",
    "MXP" to "Mexíkóskur silfurpesi (1861–1992)",
    "MXV" to "Mexíkóskur pesi, UDI",
    "MYR" to "malasískt ringit",
    "MZE" to "Mósambískur skúti",
    "MZN" to "mósambískt metikal",
    "NAD" to "namibískur dalur",
    "NGN" to "nígerísk næra",
    "NIC" to "Níkarögsk kordóva (1988–1991)",
    "NIO" to "níkarögsk kordóva",
    "NLG" to "Hollenskt gyllini",
    "NOK" to "norsk króna",
    "NPR" to "nepölsk rúpía",
    "NZD" to "nýsjálenskur dalur",
    "OMR" to "ómanskt ríal",
    "PAB" to "balbói",
    "PEN" to "perúskt sól",
    "PGK" to "papúsk kína",
    "PHP" to "filippseyskur pesi",
    "PKR" to "pakistönsk rúpía",
    "PLN" to "pólskt slot",
    "PLZ" to "Slot",
    "PTE" to "Portúgalskur skúti",
    "PYG" to "paragvæskt gvaraní",
    "QAR" to "katarskt ríal",
    "ROL" to "Rúmenskt lei (1952–2006)",
    "RON" to "rúmenskt lei",
    "RSD" to "serbneskur denari",
    "RUB" to "rússnesk rúbla",
    "RUR" to "Rússnesk rúbla (1991–1998)",
    "RWF" to "rúandskur franki",
    "SAR" to "sádíarabískt ríal",
    "SBD" to "salómonseyskur dalur",
    "SCR" to "Seychellesrúpía",
    "SDD" to "Súdanskur denari",
    "SDG" to "súdanskt pund",
    "SDP" to "Súdanskt pund (1957–1998)",
    "SEK" to "sænsk króna",
    "SGD" to "singapúrskur dalur",
    "SHP" to "helenskt pund",
    "SIT" to "Slóvenskur dalur",
    "SKK" to "Slóvakísk króna",
    "SLE" to "síerraleónsk ljóna",
    "SLL" to "síerraleónsk ljóna (1964—2022)",
    "SOS" to "sómalískur skildingur",
    "SRD" to "Súrínamdalur",
    "SRG" to "Suriname Guilder",
    "SSP" to "suðursúdanskt pund",
    "STD" to "Saó Tóme og Prinsípe-dóbra (1977–2017)",
    "STN" to "Saó Tóme og Prinsípe-dóbra",
    "SUR" to "Soviet Rouble",
    "SVC" to "El Salvador Colon",
    "SYP" to "sýrlenskt pund",
    "SZL" to "svasílenskur lílangeni",
    "THB" to "taílenskt bat",
    "TJR" to "Tadsjiksk rúbla",
    "TJS" to "tadsjikskur sómóni",
    "TMM" to "Túrkmenskt manat (1993–2009)",
    "TMT" to "túrkmenskt manat",
    "TND" to "túniskur denari",
    "TOP" to "Tongapanga",
    "TPE" to "Tímorskur skúti",
    "TRL" to "Tyrknesk líra (1922–2005)",
    "TRY" to "tyrknesk líra",
    "TTD" to "Trínidad og Tóbagó-dalur",
    "TWD" to "taívanskur dalur",
    "TZS" to "tansanískur skildingur",
    "UAH" to "úkraínsk hrinja",
    "UAK" to "Ukrainian Karbovanetz",
    "UGX" to "úgandskur skildingur",
    "USD" to "Bandaríkjadalur",
    "USN" to "Bandaríkjadalur (næsta dag)",
    "USS" to "Bandaríkjadalur (sama dag)",
    "UYU" to "úrúgvæskur pesi",
    "UZS" to "úsbekskt súm",
    "VEB" to "Bolívar í Venesúela (1871–2008)",
    "VEF" to "venesúelskur bólívari (2008–2018)",
    "VES" to "venesúelskur bólívari",
    "VND" to "víetnamskt dong",
    "VUV" to "vanúatúskt vatú",
    "WST" to "Samóatala",
    "XAF" to "miðafrískur franki",
    "XCD" to "austurkarabískur dalur",
    "XDR" to "Sérstök dráttarréttindi",
    "XFO" to "Franskur gullfranki",
    "XFU" to "Franskur franki, UIC",
    "XOF" to "vesturafrískur franki",
    "XPF" to "pólinesískur franki",
    "XXX" to "óþekktur gjaldmiðill",
    "YDD" to "Jemenskur denari",
    "YER" to "jemenskt ríal",
    "YUM" to "Júgóslavneskur denari",
    "ZAL" to "Rand (viðskipta)",
    "ZAR" to "suðurafrískt rand",
    "ZMK" to "Zambian Kwacha (1968–2012)",
    "ZMW" to "sambísk kvaka",
    "ZWD" to "Simbabveskur dalur",
  ) }

  val it: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "peseta andorrana",
    "AED" to "dirham degli Emirati Arabi Uniti",
    "AFA" to "afgani (1927–2002)",
    "AFN" to "afghani",
    "ALL" to "lek albanese",
    "AMD" to "dram armeno",
    "ANG" to "fiorino delle Antille olandesi",
    "AOA" to "kwanza angolano",
    "AOK" to "kwanza angolano (1977–1990)",
    "AON" to "nuovo kwanza angolano (1990–2000)",
    "AOR" to "kwanza reajustado angolano (1995–1999)",
    "ARA" to "austral argentino",
    "ARP" to "peso argentino (vecchio Cod.)",
    "ARS" to "peso argentino",
    "ATS" to "scellino austriaco",
    "AUD" to "dollaro australiano",
    "AWG" to "fiorino di Aruba",
    "AZM" to "manat azero (1993–2006)",
    "AZN" to "manat azero",
    "BAD" to "dinar Bosnia-Herzegovina",
    "BAM" to "marco convertibile della Bosnia-Herzegovina",
    "BBD" to "dollaro di Barbados",
    "BDT" to "taka bangladese",
    "BEC" to "franco belga (convertibile)",
    "BEF" to "franco belga",
    "BEL" to "franco belga (finanziario)",
    "BGL" to "lev bulgaro (1962–1999)",
    "BGN" to "lev bulgaro",
    "BHD" to "dinaro del Bahrein",
    "BIF" to "franco del Burundi",
    "BMD" to "dollaro delle Bermuda",
    "BND" to "dollaro del Brunei",
    "BOB" to "boliviano",
    "BOP" to "peso boliviano",
    "BOV" to "mvdol boliviano",
    "BRB" to "cruzeiro novo brasiliano (1967–1986)",
    "BRC" to "cruzado brasiliano",
    "BRE" to "cruzeiro brasiliano (1990–1993)",
    "BRL" to "real brasiliano",
    "BRN" to "cruzado novo brasiliano",
    "BRR" to "cruzeiro brasiliano",
    "BSD" to "dollaro delle Bahamas",
    "BTN" to "ngultrum bhutanese",
    "BUK" to "kyat birmano",
    "BWP" to "pula del Botswana",
    "BYB" to "nuovo rublo bielorusso (1994–1999)",
    "BYN" to "rublo bielorusso",
    "BYR" to "rublo bielorusso (2000–2016)",
    "BZD" to "dollaro del Belize",
    "CAD" to "dollaro canadese",
    "CDF" to "franco congolese",
    "CHF" to "franco svizzero",
    "CLF" to "unidades de fomento chilene",
    "CLP" to "peso cileno",
    "CNH" to "renmimbi cinese offshore",
    "CNY" to "yuan cinese",
    "COP" to "peso colombiano",
    "CRC" to "colón costaricano",
    "CSD" to "antico dinaro serbo",
    "CSK" to "corona forte cecoslovacca",
    "CUC" to "peso cubano convertibile",
    "CUP" to "peso cubano",
    "CVE" to "escudo capoverdiano",
    "CYP" to "sterlina cipriota",
    "CZK" to "corona ceca",
    "DDM" to "ostmark della Germania Orientale",
    "DEM" to "marco tedesco",
    "DJF" to "franco di Gibuti",
    "DKK" to "corona danese",
    "DOP" to "peso dominicano",
    "DZD" to "dinaro algerino",
    "ECS" to "sucre dell’Ecuador",
    "ECV" to "unidad de valor constante (UVC) dell’Ecuador",
    "EEK" to "corona dell’Estonia",
    "EGP" to "sterlina egiziana",
    "ERN" to "nakfa eritreo",
    "ESA" to "peseta spagnola account",
    "ESB" to "peseta spagnola account convertibile",
    "ESP" to "peseta spagnola",
    "ETB" to "birr etiope",
    "EUR" to "euro",
    "FIM" to "markka finlandese",
    "FJD" to "dollaro delle Figi",
    "FKP" to "sterlina delle Falkland",
    "FRF" to "franco francese",
    "GBP" to "sterlina britannica",
    "GEK" to "kupon larit georgiano",
    "GEL" to "lari georgiano",
    "GHC" to "cedi del Ghana",
    "GHS" to "cedi ghanese",
    "GIP" to "sterlina di Gibilterra",
    "GMD" to "dalasi gambiano",
    "GNF" to "franco della Guinea",
    "GNS" to "syli della Guinea",
    "GQE" to "ekwele della Guinea Equatoriale",
    "GRD" to "dracma greca",
    "GTQ" to "quetzal guatemalteco",
    "GWE" to "escudo della Guinea portoghese",
    "GWP" to "peso della Guinea-Bissau",
    "GYD" to "dollaro della Guyana",
    "HKD" to "dollaro di Hong Kong",
    "HNL" to "lempira honduregna",
    "HRD" to "dinaro croato",
    "HRK" to "kuna croata",
    "HTG" to "gourde haitiano",
    "HUF" to "fiorino ungherese",
    "IDR" to "rupia indonesiana",
    "IEP" to "sterlina irlandese",
    "ILP" to "sterlina israeliana",
    "ILS" to "nuovo siclo israeliano",
    "INR" to "rupia indiana",
    "IQD" to "dinaro iracheno",
    "IRR" to "rial iraniano",
    "ISK" to "corona islandese",
    "ITL" to "lira italiana",
    "JMD" to "dollaro giamaicano",
    "JOD" to "dinaro giordano",
    "JPY" to "yen giapponese",
    "KES" to "scellino keniota",
    "KGS" to "som kirghiso",
    "KHR" to "riel cambogiano",
    "KMF" to "franco comoriano",
    "KPW" to "won nordcoreano",
    "KRW" to "won sudcoreano",
    "KWD" to "dinaro kuwaitiano",
    "KYD" to "dollaro delle Isole Cayman",
    "KZT" to "tenge kazako",
    "LAK" to "kip laotiano",
    "LBP" to "lira libanese",
    "LKR" to "rupia di Sri Lanka",
    "LRD" to "dollaro liberiano",
    "LSL" to "loti del Lesotho",
    "LTL" to "litas lituano",
    "LTT" to "talonas lituani",
    "LUC" to "franco convertibile del Lussemburgo",
    "LUF" to "franco del Lussemburgo",
    "LUL" to "franco finanziario del Lussemburgo",
    "LVL" to "lats lettone",
    "LVR" to "rublo lettone",
    "LYD" to "dinaro libico",
    "MAD" to "dirham marocchino",
    "MAF" to "franco marocchino",
    "MDL" to "leu moldavo",
    "MGA" to "ariary malgascio",
    "MGF" to "franco malgascio",
    "MKD" to "dinaro macedone",
    "MKN" to "dinaro macedone (1992–1993)",
    "MLF" to "franco di Mali",
    "MMK" to "kyat di Myanmar",
    "MNT" to "tugrik mongolo",
    "MOP" to "pataca di Macao",
    "MRO" to "ouguiya della Mauritania (1973–2017)",
    "MRU" to "ouguiya della Mauritania",
    "MTL" to "lira maltese",
    "MTP" to "sterlina maltese",
    "MUR" to "rupia mauriziana",
    "MVR" to "rufiyaa delle Maldive",
    "MWK" to "kwacha malawiano",
    "MXN" to "peso messicano",
    "MXP" to "peso messicano d’argento (1861–1992)",
    "MXV" to "unidad de inversion (UDI) messicana",
    "MYR" to "ringgit malese",
    "MZE" to "escudo del Mozambico",
    "MZN" to "metical mozambicano",
    "NAD" to "dollaro namibiano",
    "NGN" to "naira nigeriana",
    "NIC" to "cordoba nicaraguense",
    "NIO" to "córdoba nicaraguense",
    "NLG" to "fiorino olandese",
    "NOK" to "corona norvegese",
    "NPR" to "rupia nepalese",
    "NZD" to "dollaro neozelandese",
    "OMR" to "rial omanita",
    "PAB" to "balboa panamense",
    "PEI" to "inti peruviano",
    "PEN" to "sol peruviano",
    "PES" to "sol peruviano (1863–1965)",
    "PGK" to "kina papuana",
    "PHP" to "peso filippino",
    "PKR" to "rupia pakistana",
    "PLN" to "zloty polacco",
    "PLZ" to "złoty Polacco (1950–1995)",
    "PTE" to "escudo portoghese",
    "PYG" to "guaraní paraguayano",
    "QAR" to "rial qatariano",
    "RHD" to "dollaro della Rhodesia",
    "ROL" to "leu della Romania",
    "RON" to "leu rumeno",
    "RSD" to "dinaro serbo",
    "RUB" to "rublo russo",
    "RUR" to "rublo della CSI",
    "RWF" to "franco ruandese",
    "SAR" to "riyal saudita",
    "SBD" to "dollaro delle Isole Salomone",
    "SCR" to "rupia delle Seychelles",
    "SDD" to "dinaro sudanese",
    "SDG" to "sterlina sudanese",
    "SEK" to "corona svedese",
    "SGD" to "dollaro di Singapore",
    "SHP" to "sterlina di Sant’Elena",
    "SIT" to "tallero sloveno",
    "SKK" to "corona slovacca",
    "SLE" to "leone della Sierra Leone",
    "SLL" to "leone della Sierra Leone (1964–2022)",
    "SOS" to "scellino somalo",
    "SRD" to "dollaro del Suriname",
    "SRG" to "fiorino del Suriname",
    "SSP" to "sterlina sud-sudanese",
    "STD" to "dobra di Sao Tomé e Principe (1977–2017)",
    "STN" to "dobra di Sao Tomé e Príncipe",
    "SUR" to "rublo sovietico",
    "SVC" to "colón salvadoregno",
    "SYP" to "lira siriana",
    "SZL" to "lilangeni",
    "THB" to "baht thailandese",
    "TJR" to "rublo del Tajikistan",
    "TJS" to "somoni tagiko",
    "TMM" to "manat turkmeno (1993–2009)",
    "TMT" to "manat turkmeno",
    "TND" to "dinaro tunisino",
    "TOP" to "paʻanga tongano",
    "TPE" to "escudo di Timor",
    "TRL" to "lira turca (1922–2005)",
    "TRY" to "lira turca",
    "TTD" to "dollaro di Trinidad e Tobago",
    "TWD" to "nuovo dollaro taiwanese",
    "TZS" to "scellino della Tanzania",
    "UAH" to "grivnia ucraina",
    "UAK" to "karbovanetz ucraino",
    "UGS" to "scellino ugandese (1966–1987)",
    "UGX" to "scellino ugandese",
    "USD" to "dollaro statunitense",
    "USN" to "dollaro statunitense (next day)",
    "USS" to "dollaro statunitense (same day)",
    "UYI" to "peso uruguaiano in unità indicizzate",
    "UYP" to "peso uruguaiano (1975–1993)",
    "UYU" to "peso uruguayano",
    "UZS" to "sum uzbeco",
    "VEB" to "bolivar venezuelano (1871–2008)",
    "VEF" to "bolívar venezuelano (2008–2018)",
    "VES" to "bolívar venezuelano",
    "VND" to "dong vietnamita",
    "VUV" to "vatu di Vanuatu",
    "WST" to "tala samoano",
    "XAF" to "franco CFA BEAC",
    "XAG" to "argento",
    "XAU" to "oro",
    "XBA" to "unità composita europea",
    "XBB" to "unità monetaria europea",
    "XBC" to "unità di acconto europea (XBC)",
    "XBD" to "unità di acconto europea (XBD)",
    "XCD" to "dollaro dei Caraibi orientali",
    "XDR" to "diritti speciali di incasso",
    "XFO" to "franco oro francese",
    "XFU" to "franco UIC francese",
    "XOF" to "franco CFA BCEAO",
    "XPD" to "palladio",
    "XPF" to "franco CFP",
    "XPT" to "platino",
    "XRE" to "fondi RINET",
    "XTS" to "codice di verifica della valuta",
    "XXX" to "valuta sconosciuta",
    "YDD" to "dinaro dello Yemen",
    "YER" to "riyal yemenita",
    "YUD" to "dinaro forte yugoslavo",
    "YUM" to "dinaro noviy yugoslavo",
    "YUN" to "dinaro convertibile yugoslavo",
    "ZAL" to "rand sudafricano (finanziario)",
    "ZAR" to "rand sudafricano",
    "ZMK" to "kwacha dello Zambia (1968–2012)",
    "ZMW" to "kwacha zambiano",
    "ZRN" to "nuovo zaire dello Zaire",
    "ZRZ" to "zaire dello Zaire",
    "ZWD" to "dollaro dello Zimbabwe",
    "ZWL" to "dollaro zimbabwiano (2009)",
  ) }

  val it_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val it_SM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val it_VA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val iu: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val iu_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ja: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "アンドラ ペセタ",
    "AED" to "アラブ首長国連邦ディルハム",
    "AFA" to "アフガニスタン アフガニー (1927–2002)",
    "AFN" to "アフガニスタン アフガニー",
    "ALK" to "アルバニア レク (1946–1965)",
    "ALL" to "アルバニア レク",
    "AMD" to "アルメニア ドラム",
    "ANG" to "オランダ領アンティル ギルダー",
    "AOA" to "アンゴラ クワンザ",
    "AOK" to "アンゴラ クワンザ (1977–1991)",
    "AON" to "アンゴラ 新クワンザ (1990–2000)",
    "AOR" to "アンゴラ 旧クワンザ (1995–1999)",
    "ARA" to "アルゼンチン アゥストラール",
    "ARL" to "アルゼンチン・ペソ・レイ（1970–1983）",
    "ARM" to "アルゼンチン・ペソ（1881–1970）",
    "ARP" to "アルゼンチン ペソ (1983–1985)",
    "ARS" to "アルゼンチン ペソ",
    "ATS" to "オーストリア シリング",
    "AUD" to "オーストラリア ドル",
    "AWG" to "アルバ フロリン",
    "AZM" to "アゼルバイジャン マナト (1993–2006)",
    "AZN" to "アゼルバイジャン マナト",
    "BAD" to "ボスニア・ヘルツェゴビナ ディナール (1992–1994)",
    "BAM" to "ボスニア・ヘルツェゴビナ 兌換マルク (BAM)",
    "BAN" to "ボスニア・ヘルツェゴビナ 新ディナール（1994–1997）",
    "BBD" to "バルバドス ドル",
    "BDT" to "バングラデシュ タカ",
    "BEC" to "ベルギー フラン (BEC)",
    "BEF" to "ベルギー フラン",
    "BEL" to "ベルギー フラン (BEL)",
    "BGL" to "ブルガリア レフ",
    "BGM" to "ブルガリア社会主義 レフ",
    "BGN" to "ブルガリア 新レフ",
    "BGO" to "ブルガリア レフ（1879–1952）",
    "BHD" to "バーレーン ディナール",
    "BIF" to "ブルンジ フラン",
    "BMD" to "バミューダ ドル",
    "BND" to "ブルネイ ドル",
    "BOB" to "ボリビア ボリビアーノ",
    "BOL" to "ボリビア ボリビアーノ (1863–1963)",
    "BOP" to "ボリビア ペソ",
    "BOV" to "ボリビア (Mvdol)",
    "BRB" to "ブラジル 新クルゼイロ (1967–1986)",
    "BRC" to "ブラジル クルザード (1986–1989)",
    "BRE" to "ブラジル クルゼイロ (1990–1993)",
    "BRL" to "ブラジル レアル",
    "BRN" to "ブラジル 新クルザード (1989–1990)",
    "BRR" to "ブラジル クルゼイロ (1993–1994)",
    "BRZ" to "ブラジル クルゼイロ（1942–1967）",
    "BSD" to "バハマ ドル",
    "BTN" to "ブータン ニュルタム",
    "BUK" to "ビルマ チャット",
    "BWP" to "ボツワナ プラ",
    "BYB" to "ベラルーシ 新ルーブル (1994–1999)",
    "BYN" to "ベラルーシ ルーブル",
    "BYR" to "ベラルーシ ルーブル (2000–2016)",
    "BZD" to "ベリーズ ドル",
    "CAD" to "カナダ ドル",
    "CDF" to "コンゴ フラン",
    "CHE" to "ユーロ (WIR)",
    "CHF" to "スイス フラン",
    "CHW" to "フラン (WIR)",
    "CLE" to "チリ エスクード",
    "CLF" to "チリ ウニダ・デ・フォメント (UF)",
    "CLP" to "チリ ペソ",
    "CNH" to "中国人民元(オフショア)",
    "CNX" to "中国人民銀行ドル",
    "CNY" to "中国人民元",
    "COP" to "コロンビア ペソ",
    "COU" to "コロンビア レアル （UVR)",
    "CRC" to "コスタリカ コロン",
    "CSD" to "セルビア ディナール (2002–2006)",
    "CSK" to "チェコスロバキア コルナ",
    "CUC" to "キューバ 兌換ペソ",
    "CUP" to "キューバ ペソ",
    "CVE" to "カーボベルデ エスクード",
    "CYP" to "キプロス ポンド",
    "CZK" to "チェコ コルナ",
    "DDM" to "東ドイツ マルク",
    "DEM" to "ドイツ マルク",
    "DJF" to "ジブチ フラン",
    "DKK" to "デンマーク クローネ",
    "DOP" to "ドミニカ ペソ",
    "DZD" to "アルジェリア ディナール",
    "ECS" to "エクアドル スクレ",
    "ECV" to "エクアドル (UVC)",
    "EEK" to "エストニア クルーン",
    "EGP" to "エジプト ポンド",
    "ERN" to "エリトリア ナクファ",
    "ESA" to "スペインペセタ（勘定A）",
    "ESB" to "スペイン 兌換ペセタ",
    "ESP" to "スペイン ペセタ",
    "ETB" to "エチオピア ブル",
    "EUR" to "ユーロ",
    "FIM" to "フィンランド マルカ",
    "FJD" to "フィジー ドル",
    "FKP" to "フォークランド（マルビナス）諸島 ポンド",
    "FRF" to "フランス フラン",
    "GBP" to "英国ポンド",
    "GEK" to "ジョージア クーポン ラリ",
    "GEL" to "ジョージア ラリ",
    "GHC" to "ガーナ セディ (1979–2007)",
    "GHS" to "ガーナ セディ",
    "GIP" to "ジブラルタル ポンド",
    "GMD" to "ガンビア ダラシ",
    "GNF" to "ギニア フラン",
    "GNS" to "ギニア シリー",
    "GQE" to "赤道ギニア エクウェレ",
    "GRD" to "ギリシャ ドラクマ",
    "GTQ" to "グアテマラ ケツァル",
    "GWE" to "ポルトガル領ギニア エスクード",
    "GWP" to "ギニアビサウ ペソ",
    "GYD" to "ガイアナ ドル",
    "HKD" to "香港ドル",
    "HNL" to "ホンジュラス レンピラ",
    "HRD" to "クロアチア ディナール",
    "HRK" to "クロアチア クーナ",
    "HTG" to "ハイチ グールド",
    "HUF" to "ハンガリー フォリント",
    "IDR" to "インドネシア ルピア",
    "IEP" to "アイリッシュ ポンド",
    "ILP" to "イスラエル ポンド",
    "ILR" to "イスラエル シェケル (1980–1985)",
    "ILS" to "イスラエル新シェケル",
    "INR" to "インド ルピー",
    "IQD" to "イラク ディナール",
    "IRR" to "イラン リアル",
    "ISJ" to "アイスランド クローナ (1918–1981)",
    "ISK" to "アイスランド クローナ",
    "ITL" to "イタリア リラ",
    "JMD" to "ジャマイカ ドル",
    "JOD" to "ヨルダン ディナール",
    "JPY" to "日本円",
    "KES" to "ケニア シリング",
    "KGS" to "キルギス ソム",
    "KHR" to "カンボジア リエル",
    "KMF" to "コモロ フラン",
    "KPW" to "北朝鮮ウォン",
    "KRH" to "韓国 ファン（1953–1962）",
    "KRO" to "韓国 ウォン（1945–1953）",
    "KRW" to "韓国ウォン",
    "KWD" to "クウェート ディナール",
    "KYD" to "ケイマン諸島 ドル",
    "KZT" to "カザフスタン テンゲ",
    "LAK" to "ラオス キープ",
    "LBP" to "レバノン ポンド",
    "LKR" to "スリランカ ルピー",
    "LRD" to "リベリア ドル",
    "LSL" to "レソト ロティ",
    "LTL" to "リトアニア リタス",
    "LTT" to "リトアニア タロナ",
    "LUC" to "ルクセンブルク 兌換フラン",
    "LUF" to "ルクセンブルグ フラン",
    "LUL" to "ルクセンブルク 金融フラン",
    "LVL" to "ラトビア ラッツ",
    "LVR" to "ラトビア ルーブル",
    "LYD" to "リビア ディナール",
    "MAD" to "モロッコ ディルハム",
    "MAF" to "モロッコ フラン",
    "MCF" to "モネガスク フラン",
    "MDC" to "モルドバ クーポン",
    "MDL" to "モルドバ レイ",
    "MGA" to "マダガスカル アリアリ",
    "MGF" to "マラガシ フラン",
    "MKD" to "マケドニア デナル",
    "MKN" to "マケドニア ディナール（1992–1993）",
    "MLF" to "マリ フラン",
    "MMK" to "ミャンマー チャット",
    "MNT" to "モンゴル トグログ",
    "MOP" to "マカオ パタカ",
    "MRO" to "モーリタニア ウギア (1973–2017)",
    "MRU" to "モーリタニア ウギア",
    "MTL" to "マルタ リラ",
    "MTP" to "マルタ ポンド",
    "MUR" to "モーリシャス ルピー",
    "MVP" to "モルディブ諸島 ルピー",
    "MVR" to "モルディブ ルフィア",
    "MWK" to "マラウィ クワチャ",
    "MXN" to "メキシコ ペソ",
    "MXP" to "メキシコ ペソ (1861–1992)",
    "MXV" to "メキシコ (UDI)",
    "MYR" to "マレーシア リンギット",
    "MZE" to "モザンピーク エスクード",
    "MZM" to "モザンビーク メティカル (1980–2006)",
    "MZN" to "モザンビーク メティカル",
    "NAD" to "ナミビア ドル",
    "NGN" to "ナイジェリア ナイラ",
    "NIC" to "ニカラグア コルドバ (1988–1991)",
    "NIO" to "ニカラグア コルドバ オロ",
    "NLG" to "オランダ ギルダー",
    "NOK" to "ノルウェー クローネ",
    "NPR" to "ネパール ルピー",
    "NZD" to "ニュージーランド ドル",
    "OMR" to "オマーン リアル",
    "PAB" to "パナマ バルボア",
    "PEI" to "ペルー インティ",
    "PEN" to "ペルー ソル",
    "PES" to "ペルー ソル (1863–1965)",
    "PGK" to "パプアニューギニア キナ",
    "PHP" to "フィリピン ペソ",
    "PKR" to "パキスタン ルピー",
    "PLN" to "ポーランド ズウォティ",
    "PLZ" to "ポーランド ズウォティ (1950–1995)",
    "PTE" to "ポルトガル エスクード",
    "PYG" to "パラグアイ グアラニ",
    "QAR" to "カタール リアル",
    "RHD" to "ローデシア ドル",
    "ROL" to "ルーマニア レイ (1952–2006)",
    "RON" to "ルーマニア レイ",
    "RSD" to "セルビア ディナール",
    "RUB" to "ロシア ルーブル",
    "RUR" to "ロシア ルーブル (1991–1998)",
    "RWF" to "ルワンダ フラン",
    "SAR" to "サウジ リヤル",
    "SBD" to "ソロモン諸島 ドル",
    "SCR" to "セーシェル ルピー",
    "SDD" to "スーダン ディナール (1992–2007)",
    "SDG" to "スーダン ポンド",
    "SDP" to "スーダン ポンド (1957–1998)",
    "SEK" to "スウェーデン クローナ",
    "SGD" to "シンガポール ドル",
    "SHP" to "セントヘレナ ポンド",
    "SIT" to "スロベニア トラール",
    "SKK" to "スロバキア コルナ",
    "SLE" to "シエラレオネ レオン",
    "SLL" to "シエラレオネ レオン (1964—2022)",
    "SOS" to "ソマリア シリング",
    "SRD" to "スリナム ドル",
    "SRG" to "スリナム ギルダー",
    "SSP" to "南スーダン ポンド",
    "STD" to "サントメ・プリンシペ ドブラ (1977–2017)",
    "STN" to "サントメ・プリンシペ ドブラ",
    "SUR" to "ソ連 ルーブル",
    "SVC" to "エルサルバドル コロン",
    "SYP" to "シリア ポンド",
    "SZL" to "スワジランド リランゲニ",
    "THB" to "タイ バーツ",
    "TJR" to "タジキスタン ルーブル",
    "TJS" to "タジキスタン ソモニ",
    "TMM" to "トルクメニスタン マナト (1993–2009)",
    "TMT" to "トルクメニスタン マナト",
    "TND" to "チュニジア ディナール",
    "TOP" to "トンガ パ・アンガ",
    "TPE" to "ティモール エスクード",
    "TRL" to "トルコ リラ (1922–2005)",
    "TRY" to "トルコ リラ",
    "TTD" to "トリニダード・トバゴ ドル",
    "TWD" to "新台湾ドル",
    "TZS" to "タンザニア シリング",
    "UAH" to "ウクライナ フリヴニャ",
    "UAK" to "ウクライナ カルボバネツ",
    "UGS" to "ウガンダ シリング (1966–1987)",
    "UGX" to "ウガンダ シリング",
    "USD" to "米ドル",
    "USN" to "米ドル (翌日)",
    "USS" to "米ドル (当日)",
    "UYI" to "ウルグアイ ペソエン",
    "UYP" to "ウルグアイ ペソ (1975–1993)",
    "UYU" to "ウルグアイ ペソ",
    "UZS" to "ウズベキスタン スム",
    "VEB" to "ベネズエラ ボリバル (1871–2008)",
    "VEF" to "ベネズエラ ボリバル (2008–2018)",
    "VES" to "ベネズエラ ボリバル",
    "VND" to "ベトナム ドン",
    "VNN" to "ベトナム ドン（1978–1985）",
    "VUV" to "バヌアツ バツ",
    "WST" to "サモア タラ",
    "XAF" to "中央アフリカ CFA フラン",
    "XAG" to "銀",
    "XAU" to "金",
    "XBA" to "ヨーロッパ混合単位 (EURCO)",
    "XBB" to "ヨーロッパ通貨単位 (EMU–6)",
    "XBC" to "ヨーロッパ勘定単位 (EUA–9)",
    "XBD" to "ヨーロッパ勘定単位 (EUA–17)",
    "XCD" to "東カリブ ドル",
    "XDR" to "特別引き出し権",
    "XEU" to "ヨーロッパ通貨単位",
    "XFO" to "フランス金フラン",
    "XFU" to "フランス フラン (UIC)",
    "XOF" to "西アフリカ CFA フラン",
    "XPD" to "パラジウム",
    "XPF" to "CFP フラン",
    "XPT" to "プラチナ",
    "XRE" to "RINET基金",
    "XSU" to "スクレ",
    "XTS" to "テスト用通貨コード",
    "XUA" to "UA (アフリカ開発銀行)",
    "XXX" to "不明または無効な通貨",
    "YDD" to "イエメン ディナール",
    "YER" to "イエメン リアル",
    "YUD" to "ユーゴスラビア ハード・ディナール (1966–1990)",
    "YUM" to "ユーゴスラビア ノビ・ディナール (1994–2002)",
    "YUN" to "ユーゴスラビア 兌換ディナール (1990–1992)",
    "YUR" to "ユーゴスラビア 改革ディナール（1992–1993）",
    "ZAL" to "南アフリカ ランド (ZAL)",
    "ZAR" to "南アフリカ ランド",
    "ZMK" to "ザンビア クワチャ (1968–2012)",
    "ZMW" to "ザンビア クワチャ",
    "ZRN" to "ザイール 新ザイール (1993–1998)",
    "ZRZ" to "ザイール ザイール (1971–1993)",
    "ZWD" to "ジンバブエ ドル (1980–2008)",
    "ZWL" to "ジンバブエ ドル (2009)",
    "ZWR" to "シンバブエ ドル（2008）",
  ) }

  val jbo: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val jgo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "CAD" to "Ndɔ́la-Kanandâ",
    "EUR" to "Ʉ́lɔ",
    "USD" to "Ndɔ́la-Amɛlîk",
    "XAF" to "Fɛlâŋ",
    "XXX" to "ntɛ-ŋkáp yi pɛ́ ká kɛ́ jínɛ",
  ) }

  val jmc: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham ya Falme za Kiarabu",
    "AOA" to "Kwanza ya Angola",
    "AUD" to "Dola ya Australia",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pula ya Botswana",
    "CAD" to "Dola ya Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Uswisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Jibuti",
    "DZD" to "Dinari ya Aljeria",
    "EGP" to "Pauni ya Misri",
    "ERN" to "Nakfa ya Eritrea",
    "ETB" to "Bir ya Uhabeshi",
    "EUR" to "Yuro",
    "GBP" to "Pauni ya Uingereza",
    "GHC" to "Sedi ya Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Gine",
    "INR" to "Rupia ya India",
    "JPY" to "Sarafu ya Kijapani",
    "KES" to "Shilingi ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Dola ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirham ya Moroko",
    "MGA" to "Faranga ya Bukini",
    "MRO" to "Ugwiya ya Moritania (1973–2017)",
    "MRU" to "Ugwiya ya Moritania",
    "MUR" to "Rupia ya Morisi",
    "MWK" to "Kwacha ya Malawi",
    "MZM" to "Metikali ya Msumbiji",
    "NAD" to "Dola ya Namibia",
    "NGN" to "Naira ya Nijeria",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riyal ya Saudia",
    "SCR" to "Rupia ya Shelisheli",
    "SDG" to "Dinari ya Sudani",
    "SDP" to "Pauni ya Sudani",
    "SHP" to "Pauni ya Santahelena",
    "SLE" to "Leoni",
    "SLL" to "Leoni (1964—2022)",
    "SOS" to "Shilingi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Principe (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Principe",
    "SZL" to "Lilangeni",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "Shilingi ya Tanzania",
    "UGX" to "Shilingi ya Uganda",
    "USD" to "Dola ya Marekani",
    "XAF" to "Faranga CFA BEAC",
    "XOF" to "Faranga CFA BCEAO",
    "ZAR" to "Randi ya Afrika Kusini",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Dola ya Zimbabwe",
  ) }

  val jv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham Uni Emirat Arab",
    "AFN" to "Afghani Afganistan",
    "ALL" to "Lek Albania",
    "AMD" to "Dram Armenia",
    "ANG" to "Guilder Antilla Walanda",
    "AOA" to "Kwanza Angola",
    "ARS" to "Peso Argentina",
    "AUD" to "Dolar Australia",
    "AWG" to "Florin Aruban",
    "AZN" to "Manat Azerbaijan",
    "BAM" to "Mark Konvertibel Bosnia-Herzegovina",
    "BBD" to "Dolar Barbadian",
    "BDT" to "Taka Bangladesh",
    "BGN" to "Lev Bulgaria",
    "BHD" to "Bahrain Dinar",
    "BIF" to "Franc Burundi",
    "BMD" to "Dolar Bermuda",
    "BND" to "Dolar Brunai",
    "BOB" to "Boliviano Bolivia",
    "BRL" to "Real Brasil",
    "BSD" to "Dolar Bahamian",
    "BTN" to "Ngultrum Bhutan",
    "BWP" to "Pula Botswana",
    "BYN" to "Ruble Belarusia",
    "BZD" to "Dolar Belise",
    "CAD" to "Dolar Kanada",
    "CDF" to "Franc Kongo",
    "CHF" to "Franc Swiss",
    "CLP" to "Peso Chili",
    "CNH" to "Yuan Tyongkok (Jaban Rangkah)",
    "CNY" to "Yuan Tyongkok",
    "COP" to "Peso Kolumbia",
    "CRC" to "Colon Kosta Rika",
    "CUC" to "Peso Konvertibel Kuba",
    "CUP" to "Peso Kuba",
    "CVE" to "Escudo Tanjung Verde",
    "CZK" to "Koruna Czech",
    "DJF" to "Franc Djibouti",
    "DKK" to "Krone Denmark",
    "DOP" to "Peso Dominika",
    "DZD" to "Dinar Algeria",
    "EGP" to "Pound Mesir",
    "ERN" to "Nakfa Eritrea",
    "ETB" to "Birr Ethiopia",
    "EUR" to "Euro",
    "FJD" to "Dolar Fiji",
    "FKP" to "Pound Kepuloan Falkland",
    "GBP" to "Pound Inggris",
    "GEL" to "Lari Georgia",
    "GHS" to "Cedi Ghana",
    "GIP" to "Pound Gibraltar",
    "GMD" to "Dalasi Gambia",
    "GNF" to "Franc Guinea",
    "GTQ" to "Quetzal Guatemala",
    "GYD" to "Dolar Guyana",
    "HKD" to "Dolar Hong Kong",
    "HNL" to "Lempira Honduras",
    "HRK" to "Kuna Kroasia",
    "HTG" to "Gourde Haiti",
    "HUF" to "Forint Hungaria",
    "IDR" to "Rupiah Indonesia",
    "ILS" to "Shekel Anyar Israel",
    "INR" to "Rupee India",
    "IQD" to "Dinar Irak",
    "IRR" to "Rial Iran",
    "ISK" to "Krona Islandia",
    "JMD" to "Dolar Jamaika",
    "JOD" to "Dinar Yordania",
    "JPY" to "Yen Jepang",
    "KES" to "Shilling Kenya",
    "KGS" to "Som Kirgistan",
    "KHR" to "Riel Kamboja",
    "KMF" to "Franc Komoro",
    "KPW" to "Won Korea Lor",
    "KRW" to "Won Korea Kidul",
    "KWD" to "Dinar Kuwait",
    "KYD" to "Dolar Kepuloan Caiman",
    "KZT" to "Tenge Kasakhstan",
    "LAK" to "Kip Laos",
    "LBP" to "Pound Libanon",
    "LKR" to "Rupee Sri Lanka",
    "LRD" to "Dolar Liberia",
    "LSL" to "Loti Lesotho",
    "LYD" to "Dinar Libya",
    "MAD" to "Dirham Maroko",
    "MDL" to "Leu Moldova",
    "MGA" to "Ariary Malagasi",
    "MKD" to "Denar Masedonia",
    "MMK" to "Kyat Myanmar",
    "MNT" to "Tugrik Mongol",
    "MOP" to "Pataca Macau",
    "MRO" to "Ouguiya Mauritania (1973 - 2017)",
    "MRU" to "Ouguiya Mauritania",
    "MUR" to "Rupee Mauritius",
    "MVR" to "Rufiyaa Maladewa",
    "MWK" to "Kwacha Malawi",
    "MXN" to "Peso Meksiko",
    "MYR" to "Ringgit Malaysia",
    "MZN" to "Metical Mosambik",
    "NAD" to "Dolar Namibia",
    "NGN" to "Naira Nigeria",
    "NIO" to "Cordoba Nikaragua",
    "NOK" to "Krone Norwegia",
    "NPR" to "Rupee Nepal",
    "NZD" to "Dolar Selandia Anyar",
    "OMR" to "Rial Oman",
    "PAB" to "Balboa Panama",
    "PEN" to "Sol Peru",
    "PGK" to "Kina Papua Nugini",
    "PHP" to "Peso Filipina",
    "PKR" to "Rupee Pakistan",
    "PLN" to "Zloty Polandia",
    "PYG" to "Guarani Paraguay",
    "QAR" to "Rial Qatar",
    "RON" to "Leu Rumania",
    "RSD" to "Dinar Serbia",
    "RUB" to "Rubel Rusia",
    "RWF" to "Franc Rwanda",
    "SAR" to "Riyal Saudi",
    "SBD" to "Dolar Kepuloan Solomon",
    "SCR" to "Rupee Seichelles",
    "SDG" to "Pound Sudan",
    "SEK" to "Krona Swedia",
    "SGD" to "Dolar Singapura",
    "SHP" to "Pound Santa Helena",
    "SLE" to "Leone Sierra Leone",
    "SLL" to "Leone Sierra Leone (1964—2022)",
    "SOS" to "Shilling Somalia",
    "SRD" to "Dolar Suriname",
    "SSP" to "Pound Sudan Kidul",
    "STN" to "Dobra Sao Tome lan Principe",
    "SYP" to "Pound Siria",
    "SZL" to "Lilangeni Swasi",
    "THB" to "Baht Thai",
    "TJS" to "Somoni Tajikistan",
    "TMT" to "Manat Turmenistan",
    "TND" to "Dinar Tunisia",
    "TOP" to "Paʻanga Tonga",
    "TRY" to "Lira Turki",
    "TTD" to "Dolar Trinidad lan Tobago",
    "TWD" to "Dolar Anyar Taiwan",
    "TZS" to "Shilling Tansania",
    "UAH" to "Hryvnia Ukrania",
    "UGX" to "Shilling Uganda",
    "USD" to "Dolar Amerika Serikat",
    "UYU" to "Peso Uruguay",
    "UZS" to "Som Usbekistan",
    "VEF" to "Bolivar Venezuela (2008 - 2018)",
    "VES" to "Bolivar Venezuela",
    "VND" to "Dong Vietnam",
    "VUV" to "Vatu Vanuatu",
    "WST" to "Tala Samoa",
    "XAF" to "CFA Franc Afrika Tengah",
    "XCD" to "Dolar Karibia Wetan",
    "XOF" to "CFA Franc Afrika Kulon",
    "XPF" to "Franc CFP",
    "XXX" to "Dhuwit Ora Dikenali",
    "YER" to "Rial Yaman",
    "ZAR" to "Rand Afrika Kidul",
    "ZMW" to "Kwacha Sambia",
  ) }

  val ka: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "ანდორული პესეტა",
    "AED" to "არაბთა გაერთიანებული საამიროების დირჰამი",
    "AFA" to "ავღანი (1927–2002)",
    "AFN" to "ავღანური ავღანი",
    "ALL" to "ალბანური ლეკი",
    "AMD" to "სომხური დრამი",
    "ANG" to "ნიდერლანდების ანტილების გულდენი",
    "AOA" to "ანგოლური კვანზა",
    "AOK" to "ანგოლური კვანზა (1977–1990)",
    "AON" to "ანგოლური ახალი კვანზა (1990–2000)",
    "AOR" to "ანგოლური მიტოლებული კვანზა (1995–1999)",
    "ARA" to "არგენტინული აუსტრალი",
    "ARP" to "არგენტინული პესო (1983–1985)",
    "ARS" to "არგენტინული პესო",
    "ATS" to "ავსტრიული შილინგი",
    "AUD" to "ავსტრალიური დოლარი",
    "AWG" to "არუბანული გულდენი",
    "AZM" to "აზერბაიჯანული მანათი (1993–2006)",
    "AZN" to "აზერბაიჯანული მანათი",
    "BAD" to "ბოსნია-ჰერცოგოვინას დინარი",
    "BAM" to "ბოსნია და ჰერცოგოვინას კონვერტირებადი მარკა",
    "BBD" to "ბარბადოსული დოლარი",
    "BDT" to "ბანგლადეშური ტაკა",
    "BEC" to "ბელგიური ფრანკი (კოვერტირებადი)",
    "BEF" to "ბელგიური ფრანკი",
    "BEL" to "ბელგიური ფრანკი (ფინანსური)",
    "BGL" to "ბულგარული მყარი ლევი",
    "BGN" to "ბულგარული ლევი",
    "BHD" to "ბაჰრეინული დინარი",
    "BIF" to "ბურუნდიული ფრანკი",
    "BMD" to "ბერმუდული დოლარი",
    "BND" to "ბრუნეული დოლარი",
    "BOB" to "ბოლივიური ბოლივიანო",
    "BOP" to "ბოლივიური პესო",
    "BRB" to "ბრაზილიური კრუზეირო ნოვო (1967–1986)",
    "BRC" to "ბრაზილიური კრუზადო",
    "BRE" to "ბრაზილიური კრუზეირო (1990–1993)",
    "BRL" to "ბრაზილიური რეალი",
    "BRN" to "ბრაზილიური კრუზადო ნოვო",
    "BRR" to "ბრაზილიური კრუზეირო",
    "BSD" to "ბაჰამური დოლარი",
    "BTN" to "ბუტანური ნგულტრუმი",
    "BWP" to "ბოცვანური პულა",
    "BYB" to "ახალი ბელარუსიული რუბლი (1994–1999)",
    "BYN" to "ბელორუსული რუბლი",
    "BYR" to "ბელორუსული რუბლი (2000–2016)",
    "BZD" to "ბელიზის დოლარი",
    "CAD" to "კანადური დოლარი",
    "CDF" to "კონგოს ფრანკი",
    "CHF" to "შვეიცარიული ფრანკი",
    "CLP" to "ჩილეს პესო",
    "CNH" to "ჩინური იუანი (ოფშორი)",
    "CNY" to "ჩინური იუანი",
    "COP" to "კოლუმბიური პესო",
    "CRC" to "კოსტა-რიკული კოლონი",
    "CSD" to "ძველი სერბიული დინარი",
    "CSK" to "ჩეხოსლოვაკიის მყარი კრონა",
    "CUC" to "კუბური კონვერტირებადი პესო",
    "CUP" to "კუბური პესო",
    "CVE" to "კაბო-ვერდეს ესკუდო",
    "CYP" to "კვიპროსის გირვანქა",
    "CZK" to "ჩეხური კრონა",
    "DDM" to "აღმოსავლეთ გერმანული მარკა",
    "DEM" to "გერმანული მარკა",
    "DJF" to "ჯიბუტის ფრანკი",
    "DKK" to "დანიური კრონა",
    "DOP" to "დომინიკური პესო",
    "DZD" to "ალჟირული დინარი",
    "EEK" to "ესტონური კრუნა",
    "EGP" to "ეგვიპტური გირვანქა",
    "ERN" to "ერიტრეის ნაკფა",
    "ESP" to "ესპანური პესეტა",
    "ETB" to "ეთიოპიური ბირი",
    "EUR" to "ევრო",
    "FIM" to "ფინური მარკა",
    "FJD" to "ფიჯის დოლარი",
    "FKP" to "ფოლკლენდის კუნძულების ფუნტი",
    "FRF" to "ფრანგული ფრანკი",
    "GBP" to "ბრიტანული გირვანქა სტერლინგი",
    "GEK" to "ქართული კუპონი ლარით",
    "GEL" to "ქართული ლარი",
    "GHS" to "განური სედი",
    "GIP" to "გიბრალტარული ფუნტი",
    "GMD" to "გამბიური დალასი",
    "GNF" to "გვინეური ფრანკი",
    "GRD" to "ბერძნული დრაჰმა",
    "GTQ" to "გვატემალური კეტსალი",
    "GWE" to "პორტუგალიური გინეა ესკუდო",
    "GYD" to "გაიანური დოლარი",
    "HKD" to "ჰონკონგის დოლარი",
    "HNL" to "ჰონდურასული ლემპირა",
    "HRD" to "ხორვატიული დინარი",
    "HRK" to "ხორვატული კუნა",
    "HTG" to "ჰაიტური გურდი",
    "HUF" to "უნგრული ფორინტი",
    "IDR" to "ინდონეზიური რუპია",
    "IEP" to "ირლანდიური გირვანქა",
    "ILS" to "ისრაელის ახალი შეკელი",
    "INR" to "ინდური რუპია",
    "IQD" to "ერაყული დინარი",
    "IRR" to "ირანული რიალი",
    "ISK" to "ისლანდიური კრონა",
    "ITL" to "იტალიური ლირა",
    "JMD" to "იამაიკური დოლარი",
    "JOD" to "იორდანიული დოლარი",
    "JPY" to "იაპონური იენი",
    "KES" to "კენიური შილინგი",
    "KGS" to "ყირგიზული სომი",
    "KHR" to "კამბოჯური რიელი",
    "KMF" to "კომორული ფრანკი",
    "KPW" to "ჩრდილოეთ კორეული ვონი",
    "KRW" to "სამხრეთ კორეული ვონი",
    "KWD" to "ქუვეითური დინარი",
    "KYD" to "კაიმანის კუნძულების დოლარი",
    "KZT" to "ყაზახური ტენგე",
    "LAK" to "ლაოსური კიპი",
    "LBP" to "ლიბანური ფუნტი",
    "LKR" to "შრი-ლანკური რუპია",
    "LRD" to "ლიბერიული დოლარი",
    "LSL" to "ლესოთოს ლოტი",
    "LTL" to "ლიტვური ლიტა",
    "LTT" to "ლიტვური ტალონი",
    "LUC" to "ლუქსემბურგის კონვერტირებადი ფრანკი",
    "LUF" to "ლუქსემბურგის ფრანკი",
    "LUL" to "ლუქსემბურგის ფინანსური ფრანკი",
    "LVL" to "ლატვიური ლატი",
    "LVR" to "ლატვიური რუბლი",
    "LYD" to "ლიბიური დინარი",
    "MAD" to "მაროკოს დირჰამი",
    "MAF" to "მაროკოს ფრანკი",
    "MDL" to "მოლდოვური ლეუ",
    "MGA" to "მადაგასკარის არიარი",
    "MGF" to "მადაგასკარის ფრანკი",
    "MKD" to "მაკედონიური დინარი",
    "MLF" to "მალის ფრანკი",
    "MMK" to "მიანმარის კიატი",
    "MNT" to "მონღოლური ტუგრიკი",
    "MOP" to "მაკაუს პატაკა",
    "MRO" to "მავრიტანული უგია (1973–2017)",
    "MRU" to "მავრიტანული უგია",
    "MTL" to "მალტის ლირა",
    "MTP" to "მალტის გირვანქა",
    "MUR" to "მავრიტანული რუპია",
    "MVR" to "მალდივური რუფია",
    "MWK" to "მალავიური კვაჩა",
    "MXN" to "მექსიკური პესო",
    "MXP" to "მექსიკური ვერცხლის პესო (1861–1992)",
    "MYR" to "მალაიზიური რინგიტი",
    "MZE" to "მოზამბიკური ესკუდო",
    "MZM" to "ძველი მოზამბიკური მეტიკალი",
    "MZN" to "მოზამბიკური მეტიკალი",
    "NAD" to "ნამიბიური დოლარი",
    "NGN" to "ნიგერიული ნაირა",
    "NIC" to "ნიკარაგუას კორდობა",
    "NIO" to "ნიკარაგუას ოქროს კორდობა",
    "NLG" to "ჰოლანდიური გულდენი",
    "NOK" to "ნორვეგიული კრონა",
    "NPR" to "ნეპალური რუპია",
    "NZD" to "ახალი ზელანდიის დოლარი",
    "OMR" to "ომანის რიალი",
    "PAB" to "პანამური ბალბოა",
    "PEI" to "პერუს ინტი",
    "PEN" to "პერუს სოლი",
    "PES" to "პერუს სოლი (1863–1965)",
    "PGK" to "პაპუა-ახალი გვინეის კინა",
    "PHP" to "ფილიპინური პესო",
    "PKR" to "პაკისტანური რუპია",
    "PLN" to "პოლონური ზლოტი",
    "PLZ" to "პოლონური ზლოტი (1950–1995)",
    "PTE" to "პორტუგალიური ესკუდო",
    "PYG" to "პარაგვაული გუარანი",
    "QAR" to "კატარის რიალი",
    "RHD" to "როდეზიული დოლარი",
    "ROL" to "ძველი რუმინული ლეუ",
    "RON" to "რუმინული ლეუ",
    "RSD" to "სერბული დინარი",
    "RUB" to "რუსული რუბლი",
    "RUR" to "რუსული რუბლი (1991–1998)",
    "RWF" to "რუანდული ფრანკი",
    "SAR" to "საუდის არაბეთის რიალი",
    "SBD" to "სოლომონის კუნძულების დოლარი",
    "SCR" to "სეიშელური რუპია",
    "SDD" to "სუდანის დინარი",
    "SDG" to "სუდანური ფუნტი",
    "SDP" to "სუდანის გირვანქა",
    "SEK" to "შვედური კრონა",
    "SGD" to "სინგაპურის დოლარი",
    "SHP" to "წმ. ელენეს კუნძულის ფუნტი",
    "SLE" to "სიერა-ლეონეს ლეონე",
    "SLL" to "სიერა-ლეონეს ლეონე (1964—2022)",
    "SOS" to "სომალური შილინგი",
    "SRD" to "სურინამული დოლარი",
    "SRG" to "სურინამის გულდენი",
    "SSP" to "სამხრეთ სუდანური ფუნტი",
    "STD" to "სან-ტომე და პრინსიპის დობრა (1977–2017)",
    "STN" to "სან-ტომე და პრინსიპის დობრა",
    "SUR" to "საბჭოთა რუბლი",
    "SYP" to "სირიული ფუნტი",
    "SZL" to "სვაზილენდის ლილანგენი",
    "THB" to "ტაილანდური ბატი",
    "TJR" to "ტაჯიკური რუბლი",
    "TJS" to "ტაჯიკური სომონი",
    "TMM" to "თურქმენული მანათი",
    "TMT" to "თურქმენეთის მანათი",
    "TND" to "ტუნისური დინარი",
    "TOP" to "ტონგანური პაანგა",
    "TRL" to "თურქული ლირა",
    "TRY" to "ახალი თურქული ლირა",
    "TTD" to "ტრინიდად და ტობაგოს დოლარი",
    "TWD" to "ტაივანური ახალი დოლარი",
    "TZS" to "ტანზანიური შილინგი",
    "UAH" to "უკრაინული გრივნა",
    "UAK" to "უკრაინული კარბოვანეცი",
    "UGS" to "უგანდური შილინგი (1966–1987)",
    "UGX" to "უგანდური შილინგი",
    "USD" to "აშშ დოლარი",
    "USN" to "აშშ დოლარი (შემდეგი დღე)",
    "USS" to "აშშ დოლარი (იგივე დღე)",
    "UYP" to "ურუგვაის პესო (1975–1993)",
    "UYU" to "ურუგვაის პესო",
    "UZS" to "უზბეკური სუმი",
    "VEB" to "ვენესუელის ბოლივარი (1871–2008)",
    "VEF" to "ვენესუელის ბოლივარი (2008–2018)",
    "VES" to "ვენესუელის ბოლივარი",
    "VND" to "ვიეტნამური დონგი",
    "VUV" to "ვანუატუს ვატუ",
    "WST" to "სამოური ტალა",
    "XAF" to "ცენტრალურ აფრიკული CFA ფრანკი",
    "XAG" to "ვერცხლი",
    "XBA" to "ევროპული კომპპოზიტური ერთეული",
    "XBB" to "ევროპული ფულადი ერთეული",
    "XCD" to "აღმოსავლეთ კარიბიული დოლარი",
    "XEU" to "ევროპული სავალუტო ერთეული",
    "XFO" to "ფრანგული ოქროს ფრანკი",
    "XOF" to "დასავლეთ აფრიკული CFA ფრანკი",
    "XPF" to "CFP ფრანკი",
    "XXX" to "უცნობი ვალუტა",
    "YDD" to "იემენის დინარი",
    "YER" to "იემენის რეალი",
    "YUD" to "იუგოსლავიური მყარი დინარი",
    "YUM" to "იუგოსლავიური ახალი დინარი",
    "YUN" to "იუგოსლავიური კონვერტირებადი დინარი",
    "ZAR" to "სამხრეთ აფრიკული რანდი",
    "ZMK" to "ზამბიური კვაჭა (1968–2012)",
    "ZMW" to "ზამბიური კვაჭა",
    "ZRN" to "ზაირის ახალი ზაირი",
    "ZRZ" to "ზაირის ზაირი",
    "ZWD" to "ზიმბაბვეს დოლარი",
  ) }

  val kaa: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kaa_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kaa_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kab: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Adirham n Tgeldunin Taɛrabin Yedduklen",
    "AOA" to "Akwanza n Ungula",
    "AUD" to "Adular n Lusṭrali",
    "BHD" to "Adinar Abaḥrini",
    "BIF" to "Afrank Aburandi",
    "BWP" to "Apula Abusṭwanan",
    "CAD" to "Adular Akanadi",
    "CDF" to "Afrank Akunguli",
    "CHF" to "Afrank Aswis",
    "CNY" to "Ayuwan Renminbi Acinwa",
    "CVE" to "Akabuviradinu Askudi",
    "DJF" to "Afrank Ajibuti",
    "DZD" to "Adinar Azzayri",
    "EGP" to "Apund Amaṣri",
    "ERN" to "Anakfa Iritiri",
    "ETB" to "Abir Utyupi",
    "EUR" to "Uru",
    "GBP" to "Apund Aglizi",
    "GHC" to "Asidi Aɣani",
    "GMD" to "Adalasi Agambi",
    "GNS" to "Afrank Aɣini",
    "INR" to "Arupi Ahendi",
    "JPY" to "Ayen Ajappuni",
    "KES" to "Aciling Akini",
    "KMF" to "Afrank Akamiruni",
    "LRD" to "Adular Alibiri",
    "LSL" to "Aluṭi Alizuṭi",
    "LYD" to "Adinar Alibi",
    "MAD" to "Adirham Amerruki",
    "MGA" to "Aryari Amalgac",
    "MRO" to "Agiya Amuriṭani (1973–2017)",
    "MRU" to "Agiya Amuriṭani",
    "MUR" to "Arupi Amurisi",
    "MWK" to "Akwaca Amalawi",
    "MZM" to "Amitikal Amuzembiqi",
    "NAD" to "Adular Anamibi",
    "NGN" to "Anayra Anijiri",
    "RWF" to "Afrank Aruwandi",
    "SAR" to "Aryal Asuɛudi",
    "SCR" to "Arupi Aseycili",
    "SDG" to "Apund Asudani",
    "SHP" to "Apund Asant Ilini",
    "SLE" to "Alyun",
    "SLL" to "Alyun (1964—2022)",
    "SOS" to "Aciling Aṣumali",
    "STD" to "Asw Ṭum d Udubra Amenzay (1977–2017)",
    "STN" to "Asw Ṭum d Udubra Amenzay",
    "SZL" to "Alilangini",
    "TND" to "Adinar Atunsi",
    "TZS" to "Aciling Aṭanẓani",
    "UGX" to "Aciling Awgandi",
    "USD" to "Adular WD",
    "XAF" to "Afrank BCEA CFA",
    "XOF" to "Afrank BCEAO CFA",
    "ZAR" to "Arand Afriqi n Wadda",
    "ZMK" to "Akwaca Azambi (1968–2012)",
    "ZMW" to "Akwaca Azambi",
    "ZWD" to "Adular Azimbabwi",
  ) }

  val kaj: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kam: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham ya Falme za Kiarabu",
    "AOA" to "Kwanza ya Angola",
    "AUD" to "Ndola ya Australia",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pula ya Botswana",
    "CAD" to "Ndola ya Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Uswisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Jibuti",
    "DZD" to "Dinari ya Aljeria",
    "EGP" to "Vaundi ya Misili",
    "ERN" to "Nakfa ya Eritrea",
    "ETB" to "Bir ya Uhabeshi",
    "EUR" to "Yuro",
    "GBP" to "Pauni ya Uingereza",
    "GHC" to "Sedi ya Ghana",
    "GMD" to "Ndalasi ya Gambia",
    "GNS" to "Faranga ya Gine",
    "INR" to "Rupia ya India",
    "JPY" to "Sarafu ya Kijapani",
    "KES" to "Silingi ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Dola ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirham ya Moroko",
    "MGA" to "Ariary ya Bukini",
    "MRO" to "Ugwiya ya Moritania (1973–2017)",
    "MRU" to "Ugwiya ya Moritania",
    "MUR" to "Rupia ya Morisi",
    "MWK" to "Kwacha ya Malawi",
    "MZM" to "Metikali ya Msumbiji",
    "NAD" to "Ndola ya Namibia",
    "NGN" to "Naira ya Nijeria",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riyal ya Saudia",
    "SCR" to "Rupia ya Shelisheli",
    "SDG" to "Vaũndi ya Sudani",
    "SHP" to "Vaũndi ya Santahelena",
    "SLE" to "Leoni",
    "SLL" to "Leoni (1964—2022)",
    "SOS" to "Silingi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Principe (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Principe",
    "SZL" to "Lilangeni",
    "TND" to "Ndinari ya Tunisia",
    "TZS" to "Silingi ya Tanzania",
    "UGX" to "Silingi ya Uganda",
    "USD" to "Ndola ya Marekani",
    "XAF" to "Faranga CFA BEAC",
    "XOF" to "Faranga CFA BCEAO",
    "ZAR" to "Randi ya Afrika Kusini",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Ndola ya Zimbabwe",
  ) }

  val kcg: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kde: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham ya Falme za Chiarabu",
    "AOA" to "Kwanza ya Angola",
    "AUD" to "Dola ya Australia",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pula ya Botswana",
    "CAD" to "Dola ya Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Uswisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Jibuti",
    "DZD" to "Dinari ya Aljeria",
    "EGP" to "Pauni ya Misri",
    "ERN" to "Nakfa ya Eritrea",
    "ETB" to "Bir ya Uhabeshi",
    "EUR" to "Yuro",
    "GBP" to "Pauni ya Uingereza",
    "GHC" to "Sedi ya Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Gine",
    "INR" to "Rupia ya India",
    "JPY" to "Sarafu ya Chijapani",
    "KES" to "Shilingi ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Dola ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirham ya Moroko",
    "MGA" to "Faranga ya Bukini",
    "MRO" to "Ugwiya ya Moritania (1973–2017)",
    "MRU" to "Ugwiya ya Moritania",
    "MUR" to "Rupia ya Morisi",
    "MWK" to "Kwacha ya Malawi",
    "MZM" to "Metikali ya Msumbiji",
    "NAD" to "Dola ya Namibia",
    "NGN" to "Naira ya Nijeria",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riyal ya Saudia",
    "SCR" to "Rupia ya Shelisheli",
    "SDG" to "Dinari ya Sudani",
    "SDP" to "Pauni ya Sudani",
    "SHP" to "Pauni ya Santahelena",
    "SLE" to "Leoni",
    "SLL" to "Leoni (1964—2022)",
    "SOS" to "Shilingi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Principe (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Principe",
    "SZL" to "Lilangeni",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "Shilingi ya Tanzania",
    "UGX" to "Shilingi ya Uganda",
    "USD" to "Dola ya Marekani",
    "XAF" to "Faranga CFA BEAC",
    "XOF" to "Faranga CFA BCEAO",
    "ZAR" to "Randi ya Afrika Kusini",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Dola ya Zimbabwe",
  ) }

  val kea: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Diren di Emiradus Arabi Unidu",
    "AOA" to "Kuanza",
    "AUD" to "Dola australianu",
    "BHD" to "Dinar di Barain",
    "BIF" to "Franku borundes",
    "BRL" to "Rial brazileru",
    "BWP" to "Pula di Botsuana",
    "CAD" to "Dola kanadianu",
    "CDF" to "Franku kongoles",
    "CHF" to "Franku suisu",
    "CNY" to "Iuan xines",
    "CVE" to "Skudu Kabuverdianu",
    "DJF" to "Franku di Djibuti",
    "DKK" to "Kuroa dinamarkeza",
    "DZD" to "Dinar arjelinu",
    "EGP" to "Libra ejípsiu",
    "ERN" to "Nafka di Eritreia",
    "ETB" to "Bir etiópiku",
    "EUR" to "euro",
    "GBP" to "Libra britániku",
    "GHC" to "Sedi di Gana (1979–2007)",
    "GMD" to "Dalasi",
    "GNS" to "Sili",
    "HKD" to "Dola di Ong Kong",
    "IDR" to "Rupia indoneziu",
    "INR" to "Rupia indianu",
    "JPY" to "Ieni japones",
    "KES" to "Xelin kenianu",
    "KMF" to "Franku di Komoris",
    "KRW" to "Won sul-koreanu",
    "LRD" to "Dola liberianu",
    "LSL" to "Loti di Lezotu",
    "LYD" to "Dinar líbiu",
    "MAD" to "Diren marokinu",
    "MGA" to "Ariari di Madagaskar",
    "MRO" to "Ougia (1973–2017)",
    "MRU" to "Ougia",
    "MUR" to "Rupia di Maurisias",
    "MWK" to "Kuaxa di Malaui",
    "MXN" to "Pezu mexikanu",
    "MZM" to "Metikal",
    "NAD" to "Dola namibianu",
    "NGN" to "Naira",
    "NOK" to "Kuroa norueges",
    "PLN" to "Zloty polaku",
    "RUB" to "Rublu rusu",
    "RWF" to "Franku ruandes",
    "SAR" to "Rial saudita",
    "SCR" to "Rupia di Seixelis",
    "SDG" to "Libra sudanes",
    "SDP" to "Libra sudanes antigu (1957–1998)",
    "SEK" to "Kuroa sueku",
    "SHP" to "Libra di Santa Ilena",
    "SLE" to "Leone di Sera Leoa",
    "SLL" to "Leone di Sera Leoa (1964—2022)",
    "SOS" to "Xelin somalianu",
    "STD" to "Dobra di San Tume i Prínsipi (1977–2017)",
    "STN" to "Dobra di San Tume i Prínsipi",
    "SZL" to "Lilanjeni",
    "THB" to "Baht tailandes",
    "TND" to "Dinar tunizianu",
    "TRY" to "Lira turku",
    "TWD" to "Dola Novu di Taiwan",
    "TZS" to "Xelin di Tanzánia",
    "UGX" to "Xelin ugandensi",
    "USD" to "Dola merkanu",
    "XAF" to "Franku CFA (BEAC)",
    "XOF" to "Franku CFA (BCEAO)",
    "XXX" to "Mueda diskonxedu",
    "ZAR" to "Rand sulafrikanu",
    "ZMK" to "Kuaxa zambianu (1968–2012)",
    "ZMW" to "Kuaxa zambianu",
    "ZWD" to "Dola di Zimbabue (1980–2008)",
  ) }

  val ken: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kgp: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Ỹnoha Kufy-sĩ",
    "AED" to "Ẽmĩrano Arame Jãnkamu",
    "AFA" to "Afeganĩ (1927–2002)",
    "AFN" to "Afeganĩ afegỹv",
    "ALK" to "Arámánja Rég (1946–1965)",
    "ALL" to "Arámánja Rég",
    "AMD" to "Arámẽnja Daram",
    "ANG" to "Ỹtiria Orỹnesa Kafejsĩ",
    "AOA" to "Ỹgora Kwanza",
    "AOK" to "Ỹgora Cuanza (1977–1990)",
    "AON" to "Ỹgora cuanza tãg (1990–2000)",
    "AOR" to "Ỹgora cuanza ki hynhan ka nĩ (1990–2000)",
    "ARA" to "Arjẽtinỹ Asufraw",
    "ARL" to "Arjẽtinỹ Kufy Rej (1970–1983)",
    "ARM" to "Arjẽtinỹ Kufy (1881–1970)",
    "ARP" to "Arjẽtinỹ Kufy (1983–1985)",
    "ARS" to "Arjẽtinỹ Kufy // Arjẽntĩnỹ Kufy",
    "ATS" to "Agtirija Serĩm",
    "AUD" to "Awotyraria Nórar Si",
    "AWG" to "Aruma Kafejsĩ",
    "AZM" to "Ajermajjáv Manati (1993–2006)",
    "AZN" to "Manati aseri",
    "BAD" to "Mósinĩja-Hersegovĩna Ninỹ (1992–1994)",
    "BAM" to "Mósinĩja Hersegovĩna-mré Mỹrko ta ũn há",
    "BAN" to "Mósinĩja-Hersegovĩna Ninỹ Tãg (1994–1997)",
    "BBD" to "Juvã-mág Nórar",
    "BDT" to "Mágranési Taka",
    "BEC" to "Mérjika Vĩpir (conv)",
    "BEF" to "Mérjika Vĩpir",
    "BEL" to "Mérjika Vĩpir (financ)",
    "BGL" to "Mugarja Rev Tar",
    "BGM" to "Mugarja Ver kynkar",
    "BGN" to "Mugarja Rev",
    "BGO" to "Mugarja Rev (1879–1952)",
    "BHD" to "Marẽnh Ninỹ",
    "BIF" to "Murũni Vĩpir",
    "BMD" to "Karsa-ror-ag Nórar",
    "BND" to "Mrunẽj Nórar",
    "BOB" to "Morivija Jãnkamu",
    "BOL" to "Morivijanũ (1863–1963)",
    "BOP" to "Morivija Kufy",
    "BOV" to "Morivija Munór",
    "BRB" to "Mrasir Krujeru Tãg (1967–1986)",
    "BRC" to "Mrasir Krusanu (1986–1989)",
    "BRE" to "Mrasir Krujeru (1990–1993)",
    "BRL" to "Mrasir Rejar",
    "BRN" to "Mrasir Krusanu Tãg (1989–1990)",
    "BRR" to "Mrasir Krujeru (1993–1994)",
    "BRZ" to "Mrasir Krujeru (1942–1967)",
    "BSD" to "Mahamỹ Nórar",
    "BTN" to "Butỹ Guturũm",
    "BUK" to "Mirmỹnja Kyate",
    "BWP" to "Monsuvỹnỹ Pura",
    "BYB" to "Miero-Husija Humro Tãg (1994–1999)",
    "BYN" to "Miero-Husija Humro",
    "BYR" to "Miero-Husija Humro (2000–2016)",
    "BZD" to "Merise Nórar",
    "CAD" to "Kanỹna Nórar",
    "CDF" to "Kãgu Vĩpir",
    "CHE" to "WIR Evoro",
    "CHF" to "Suvisa Vĩpir",
    "CHW" to "WIR Vĩpir",
    "CLE" to "Sire Vẽjuven",
    "CLF" to "Sirenũ ag vẽnhkãmur ũ",
    "CLP" to "Sire Kufy",
    "CNH" to "Sĩnỹ Yvỹn (offshore)",
    "CNX" to "Nórar vẽnhkar mỹ máko mĩ Sĩnỹ tá",
    "CNY" to "Sĩnỹ Yvỹn",
    "COP" to "Kolãmja Kufy",
    "COU" to "Vẽnhkãmun ũ kaja uri",
    "CRC" to "Kotahika Korãn",
    "CSD" to "Sérvija Ninỹ (2002–2006)",
    "CSK" to "Sékorovaka Rãgre Tar",
    "CUC" to "Kuma Kufy conv",
    "CUP" to "Kuma Kufy",
    "CVE" to "Pu-Tánh Vẽjuven",
    "CYP" to "Sipre Rimra",
    "CZK" to "Séka Rãgre",
    "DDM" to "Aremỹja Rãjur tá Jãnkamu",
    "DEM" to "Aremỹnhỹ Mỹrko",
    "DJF" to "Nhimuti Vĩpir",
    "DKK" to "Ninỹmỹrka Rãgre",
    "DOP" to "Nomĩnĩka Kufy",
    "DZD" to "Argerija Ninỹ",
    "ECS" to "Ekuvanor Sukri",
    "ECV" to "Ekuvanor UVC",
    "EEK" to "Enhtonĩja Rãgre",
    "EGP" to "Ejimto Rimra",
    "ERN" to "Eriteréja Nagfa",
    "ESA" to "Esipỹnja Kufy-sĩ (kãtá A)",
    "ESB" to "Esipỹnja Kufy-sĩ (kãtá conv)",
    "ESP" to "Esipỹnja Kufy-sĩ",
    "ETB" to "Etiópija Mir",
    "EUR" to "Evoro",
    "FIM" to "Fĩrỹnija Mỹrka",
    "FJD" to "Fiji Nórar",
    "FKP" to "Mỹrvinỹ Rimra",
    "FRF" to "Frỹsa Vĩpir",
    "GBP" to "Rimra Eterĩnỹ",
    "GEK" to "Jiórja Kupãni Rari",
    "GEL" to "Jiórja Rari",
    "GHC" to "Gỹnỹ Senhi (1979–2007)",
    "GHS" to "Gỹnỹ Senhi",
    "GIP" to "Nhimratar Rimra",
    "GMD" to "Gỹmija Narasi",
    "GNF" to "Ginẽ Vĩpir",
    "GNS" to "Ginẽ Syri",
    "GQE" to "Ginẽ Ekuvanor Ekuvele",
    "GRD" to "Grésija Narakymỹ",
    "GTQ" to "Guvỹtemỹra Kensav",
    "GWE" to "Fóg tỹ Ginẽ Vẽjuven",
    "GWP" to "Ginẽ-Misav Kufy",
    "GYD" to "Gijỹnỹ Nórar",
    "HKD" to "Hãg-Kãg Nórar",
    "HNL" to "Ãnura Rẽpirá",
    "HRD" to "Krovasija Ninỹ",
    "HRK" to "Krovasija Kuna",
    "HTG" to "Ajti Runja",
    "HUF" to "Ũgrija Kafejsĩ",
    "IDR" to "Ĩnonẽsija Rupija",
    "IEP" to "Irỹna Rimra",
    "ILP" to "Isihaé Rimra",
    "ILR" to "Isihaé Sekév Si",
    "ILS" to "Isihaé Sekév Tãg",
    "INR" to "Ĩnija Rupija",
    "IQD" to "Iraki Ninỹ",
    "IRR" to "Irỹ Hi’av",
    "ISJ" to "Kukryr-ga Rãgre Si",
    "ISK" to "Kukryr-ga Rãgre",
    "ITL" to "Itarija Rira",
    "JMD" to "Jamỹjka Nórar",
    "JOD" to "Jornánĩja Ninỹ",
    "JPY" to "Japã Jenẽ",
    "KES" to "Kẽnja Serĩm",
    "KGS" to "Kirgi-Ga Kyr",
    "KHR" to "Kỹmósa Hijév",
    "KMF" to "Komor Vĩpir",
    "KPW" to "Nãrti-Koréja Vãn",
    "KRH" to "Koréja Sur Huvỹ (1953–1962)",
    "KRO" to "Koréja Sur Vãn (1945–1953)",
    "KRW" to "Koréja Sur Vãn",
    "KWD" to "Kuvajti Ninỹ",
    "KYD" to "Kanhmỹ Vãsogso Nórar",
    "KZT" to "Kajakinhtỹv Tẽge",
    "LAK" to "Ravusi Kim",
    "LBP" to "Rimanũ Rimra",
    "LKR" to "Sirijỹká Rupija",
    "LRD" to "Rimérijỹ Nórar",
    "LSL" to "Resotu Roti",
    "LTL" to "Rituvỹnja Ritasi",
    "LTT" to "Rituvỹnja Taronỹ",
    "LUC" to "Rusẽmurgo Vĩpir conv.",
    "LUF" to "Rusẽmurgo Vĩpir",
    "LUL" to "Rusẽmurgo Vĩpir Jãnkamu",
    "LVL" to "Rativija Rati",
    "LVR" to "Rativija Humro",
    "LYD" to "Rimija Ninỹ",
    "MAD" to "Ar-Magrim Nirham",
    "MAF" to "Ar-Magrim Vĩpir",
    "MCF" to "Mõnỹku Vĩpir",
    "MDC" to "Mãrnova Kopã",
    "MDL" to "Mãrnova Revu",
    "MGA" to "Mỹna-Gasikar Ari-ary",
    "MGF" to "Mỹna-Gasikar Vĩpir",
    "MKD" to "Mỹsenonĩja Ninỹ",
    "MKN" to "Mỹsenonĩja Ninỹ (1992–1993)",
    "MLF" to "Mỹri Vĩpir",
    "MMK" to "Mijẽn-Mỹ Kijate",
    "MNT" to "Mãgórija Tugrig",
    "MOP" to "Mỹkav Pataka",
    "MRO" to "Mũritỹni Ov-Gija (1973–2017)",
    "MRU" to "Mũritỹni Ov-Gija",
    "MTL" to "Mỹrta Rirá",
    "MTP" to "Mỹrta Rimra",
    "MUR" to "Mãriso Rupija",
    "MVR" to "Mỹrniva Rupija",
    "MWK" to "Mỹravi Kuvasa",
    "MXN" to "Mẽsiku Kufy",
    "MXP" to "Mẽsiku Kufy Kupri (1861–1992)",
    "MXV" to "Mẽsiku Pir Rãg (UDI)",
    "MYR" to "Mỹraja Rĩggin",
    "MZE" to "Mãsỹmiki Vẽjuven",
    "MZM" to "Mãsỹmiki Mẽtikar (1980–2006)",
    "MZN" to "Mãsỹmiki Mẽtikar",
    "NAD" to "Nỹmĩmija Nórar",
    "NGN" to "Nĩjérija Nỹjra",
    "NIC" to "Nĩkaraguva Kórnoma (1988–1991)",
    "NIO" to "Nĩkaraguva Kórnoma",
    "NLG" to "Orỹna Kafejsĩ",
    "NOK" to "Nãrovéga Rãgre",
    "NPR" to "Nẽpar Rupija",
    "NZD" to "Zirỹnija Tãg Nórar",
    "OMR" to "Omỹ Hijar",
    "PAB" to "Panỹmỹ Mavo-Mova",
    "PEI" to "Peru Ĩnti",
    "PEN" to "Peru Rã Tãg",
    "PES" to "Peru Rã (1863–1965)",
    "PGK" to "Papuva Kinỹ",
    "PHP" to "Firipinỹ Kufy",
    "PKR" to "Pakinhtỹv Rupiya",
    "PLN" to "Poronĩja Rẽrĩr",
    "PLZ" to "Poronĩja Rẽrĩr (1950–1995)",
    "PTE" to "Purutuga Vẽjuven",
    "PYG" to "Paraguvaj Garnĩ",
    "QAR" to "Katar Hijar",
    "RHD" to "Ronésija Nórar",
    "ROL" to "Romẽnija Rev (1952–2006)",
    "RON" to "Romẽnija Rev",
    "RSD" to "Séruvija Ninỹ",
    "RUB" to "Husija Humro",
    "RUR" to "Husija Humro (1991–1998)",
    "RWF" to "Huvỹna Vĩpir",
    "SAR" to "Aramija Savnita Hijar",
    "SBD" to "Saromỹ Vẽsogso Nórar",
    "SCR" to "Sejséri Rupija",
    "SDD" to "Suná Ninỹ (1992–2007)",
    "SDG" to "Suná Rimbra",
    "SDP" to "Suná Rimbra (1957–1998)",
    "SEK" to "Suvésija Rãgre",
    "SGD" to "Sĩgapur Nórar",
    "SHP" to "Sỹta Herenỹ Rimra",
    "SIT" to "Enhrovenĩja Torar Há",
    "SKK" to "Enhrovakija Rãgre",
    "SLE" to "Krĩ Mĩgkusũg-fi Re’onĩ",
    "SLL" to "Krĩ Mĩgkusũg-fi Re’onĩ (1964—2022)",
    "SOS" to "Somỹrija Serĩm",
    "SRD" to "Surinỹm Nórar",
    "SRG" to "Surinỹm Kafejsĩ",
    "SSP" to "Suná-Sur Rimra",
    "STD" to "Sỹtomẽ Prĩsipi-mré Nómra (1977–2017)",
    "STN" to "Sỹtomẽ Prĩsipi-mré Nómra",
    "SUR" to "Sovijéti Humro",
    "SVC" to "Er Sarvanor Korãn",
    "SYP" to "Sirija Rimra",
    "SZL" to "Suvasi-Ga Rirỹgenĩ",
    "THB" to "Taj-Ga Mati",
    "TJR" to "Tanijikinhtỹv Humro",
    "TJS" to "Tanijikinhtỹv Somãnĩ",
    "TMM" to "Turkomẽnisitỹ Manati (1993–2009)",
    "TMT" to "Tukomẽnũ Manati",
    "TND" to "Tunĩsija Ninỹ",
    "TOP" to "Tãga Pa’ỹga",
    "TPE" to "Timor Vẽjuven",
    "TRL" to "Turkija Rira (1922–2005)",
    "TRY" to "Turkija Rira",
    "TTD" to "Tirinĩna Tomago-mré Nórar",
    "TWD" to "Tajvỹ Nórar Tãg",
    "TZS" to "Tỹnjỹnĩja Serĩm",
    "UAH" to "Ukrỹnĩja Hyryvinja",
    "UAK" to "Ukrỹnĩja Karbovanẽ",
    "UGS" to "Ugỹna Serĩm (1966–1987)",
    "UGX" to "Ugỹna Serĩm",
    "USD" to "Nãrti-Amẽrikỹ Nórar",
    "USN" to "Nãrti-Amẽrikỹ Nórar (kurã ũ kã)",
    "USS" to "Nãrti-Amẽrikỹ Nórar (kurã hã)",
    "UYI" to "Uruguvaj Kufy vẽkãmur ũ",
    "UYP" to "Uruguvaj Kufy (1975–1993)",
    "UYU" to "Uruguvaj Kufy",
    "UZS" to "Unhmekinhtỹv Kyr",
    "VEB" to "Venẽjuvéra Morivar (1871–2008)",
    "VEF" to "Venẽjuvéra Morivar (2008–2018)",
    "VES" to "Venẽjuvéra Morivar",
    "VND" to "Vijétinỹm Nãg",
    "VNN" to "Vijétinỹm Nãg (1978–1985)",
    "VUV" to "Vanũvatu Vatu",
    "WST" to "Samãva Tara",
    "XAF" to "Vĩpir CFA tỹ BEAC",
    "XAG" to "Kyfé Kupri",
    "XAU" to "Kyfé Mỹrér",
    "XBA" to "Orópa Vẽnhkãmur ũ ‘e",
    "XBB" to "Orópa Jãnkamu ũ-pir (XBB)",
    "XBC" to "Orópa Nĩkrén-ja ũ-pir (XBC)",
    "XBD" to "Orópa Nĩkrén-ja ũ-pir",
    "XCD" to "Karime Rãjur Nórar",
    "XDR" to "Kuryj há ty Jiro",
    "XEU" to "Orópa Nĩkri ũ-pir",
    "XFO" to "Frỹsa Vĩpir-Oro",
    "XFU" to "Frỹsa UIC Vĩpir",
    "XOF" to "Vĩpir CFA tỹ BCEAO",
    "XPD" to "Paranho",
    "XPF" to "Vĩpir CFP",
    "XPT" to "Pratinỹ",
    "XRE" to "RINET Kãryjgy",
    "XTS" to "Rá tỹ Nĩkri Vẽnh-kãgran-ja",
    "XXX" to "Nĩkri veja tũ",
    "YDD" to "Jemẽn Ninỹ",
    "YER" to "Jemẽn Hijar",
    "YUD" to "Jugusiravija Ninỹ Tar (1966–1990)",
    "YUM" to "Jugusiravija Ninỹ Tãg (1994–2002)",
    "YUN" to "Jugusiravija Ninỹ ta ũn há (1990–1992)",
    "YUR" to "Jugusiravija Ninỹ han mãn tãg (1992–1993)",
    "ZAL" to "Ran surafrikỹnũ (virhár)",
    "ZAR" to "Ran surafrikỹnũ",
    "ZMK" to "Kuvasa Jỹmijanũ (1968–2012)",
    "ZMW" to "Kuvasa jỹmijanũ",
    "ZRN" to "Jajre Tãg Sajrẽse",
    "ZRZ" to "Jajre Sajrẽse (1971–1993)",
    "ZWD" to "Jimamuvé Nórar (1980– 2008)",
    "ZWL" to "Jimamuvé Nórar (2009)",
    "ZWR" to "Jimamuvé Nórar (2008)",
  ) }

  val khq: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Laaraw Immaara Margantey Dirham",
    "AOA" to "Angoola Kwanza",
    "AUD" to "Ostraali Dollar",
    "BHD" to "Bahareen Dinar",
    "BIF" to "Burundi Fraŋ",
    "BWP" to "Botswaana Pund",
    "CAD" to "Kanaada Dollar",
    "CDF" to "Kongo Fraŋ",
    "CHF" to "Swisu Fraŋ",
    "CNY" to "Sinwa Yuan Renminbi",
    "CVE" to "Kapuver Escudo",
    "DJF" to "Jibuuti Fraŋ",
    "DZD" to "Alžeeri Dinar",
    "EGP" to "Misra Pund",
    "ERN" to "Eritree Nafka",
    "ETB" to "Ecioopi Birr",
    "EUR" to "Eero",
    "GBP" to "Britin Pund",
    "GHC" to "Gaana Šiidi",
    "GMD" to "Gambi Dalasi",
    "GNS" to "Ginee Fraŋ",
    "INR" to "Indu Rupii",
    "JPY" to "Jaapoŋ Yen",
    "KES" to "Keeniya Šiiliŋ",
    "KMF" to "Komoor Fraŋ",
    "LRD" to "Liberia Dollar",
    "LSL" to "Leezoto Loti",
    "LYD" to "Liibi Dinar",
    "MAD" to "Maarok Dirham",
    "MGA" to "Malgaaši Fraŋ",
    "MRO" to "Mooritaani Ugiya (1973–2017)",
    "MRU" to "Mooritaani Ugiya",
    "MUR" to "Mooris Rupii",
    "MWK" to "Malaawi Kwaca",
    "MZM" to "Mozambik Metikal",
    "NAD" to "Naamibi Dollar",
    "NGN" to "Naajiriya Neera",
    "RWF" to "Rwanda Fraŋ",
    "SAR" to "Saudiya Riyal",
    "SCR" to "Seešel Rupii",
    "SDG" to "Suudaŋ Dinar",
    "SDP" to "Suudaŋ Pund",
    "SHP" to "Seŋ Helena Fraŋ",
    "SLE" to "Leeon",
    "SLL" to "Leeon (1964—2022)",
    "SOS" to "Somaali Šiiliŋ",
    "STD" to "Sao Tome nda Prinsipe Dobra (1977–2017)",
    "STN" to "Sao Tome nda Prinsipe Dobra",
    "SZL" to "Lilangeni",
    "TND" to "Tunizi Dinar",
    "TZS" to "Tanzaani Šiiliŋ",
    "UGX" to "Uganda Šiiliŋ",
    "USD" to "Ameriki Dollar",
    "XAF" to "CFA Fraŋ (BEAC)",
    "XOF" to "CFA Fraŋ (BCEAO)",
    "ZAR" to "Hawasa Afriki Rand",
    "ZMK" to "Zambi Kwaca (1968–2012)",
    "ZMW" to "Zambi Kwaca",
    "ZWD" to "Zimbabwe Dollar",
  ) }

  val ki: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham ya Falme za Kiarabu",
    "AOA" to "Kwanza ya Angola",
    "AUD" to "Dola ya Australia",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pula ya Botswana",
    "CAD" to "Ndora ya Kananda",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Uswisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Jibuti",
    "DZD" to "Dinari ya Aljeria",
    "EGP" to "Pauni ya Misri",
    "ERN" to "Nakfa ya Eritrea",
    "ETB" to "Bir ya Uhabeshi",
    "EUR" to "Yuro",
    "GBP" to "Mbauini cia Ngeretha",
    "GHC" to "Sedi ya Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Gine",
    "INR" to "Rubia rwa India",
    "JPY" to "Sarafu ya Kijapani",
    "KES" to "Ciringi ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Dola ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirham ya Moroko",
    "MGA" to "Ariary ya Bukini",
    "MRO" to "Ugwiya ya Moritania (1973–2017)",
    "MRU" to "Ugwiya ya Moritania",
    "MUR" to "Rupia ya Morisi",
    "MWK" to "Kwacha ya Malawi",
    "MZM" to "Metikali ya Msumbiji",
    "NAD" to "Dola ya Namibia",
    "NGN" to "Naira ya Nijeria",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riyal ya Saudia",
    "SCR" to "Rupia ya Shelisheli",
    "SDG" to "Pauni ya Sudani",
    "SHP" to "Pauni ya Santahelena",
    "SLE" to "Leoni",
    "SLL" to "Leoni (1964—2022)",
    "SOS" to "ciringi cia cumarĩ",
    "STD" to "Dobra ya Sao Tome na Principe (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Principe",
    "SZL" to "Lilangeni",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "ciringi cia Tanizania",
    "UGX" to "ciringi cia Ũganda",
    "USD" to "Ndora cia Amerika",
    "XAF" to "Faranga CFA BEAC",
    "XOF" to "Faranga CFA BCEAO",
    "ZAR" to "Randi ya Afrika Kusini",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Dola ya Zimbabwe",
  ) }

  val kk: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Біріккен Араб Әмірліктерінің дирхамы",
    "AFN" to "Ауғанстан афганиі",
    "ALL" to "Албания легі",
    "AMD" to "Армения драмы",
    "ANG" to "Нидерланд антиль гульдені",
    "AOA" to "Ангола кванзасы",
    "ARS" to "Аргентина песосы",
    "AUD" to "Аустралия доллары",
    "AWG" to "Аруба флорині",
    "AZN" to "Әзірбайжан манаты",
    "BAM" to "Босния және Герцеговина айырбасталмалы маркасы",
    "BBD" to "Барбадос доллары",
    "BDT" to "Бангладеш такасы",
    "BGN" to "Болгария леві",
    "BHD" to "Бахрейн динары",
    "BIF" to "Бурунди франкі",
    "BMD" to "Бермуд доллары",
    "BND" to "Бруней доллары",
    "BOB" to "Боливия боливианосы",
    "BRL" to "Бразилия реалы",
    "BSD" to "Багам доллары",
    "BTN" to "Бутан нгултрумы",
    "BWP" to "Ботсвана пуласы",
    "BYN" to "Беларусь рублі",
    "BYR" to "Беларусь рублі (2000–2016)",
    "BZD" to "Белиз доллары",
    "CAD" to "Канада доллары",
    "CDF" to "Конго франкі",
    "CHF" to "Швейцария франкі",
    "CLP" to "Чили песосы",
    "CNH" to "Қытай юані (офшор)",
    "CNY" to "Қытай юані",
    "COP" to "Колумбия песосы",
    "CRC" to "Коста-Рика колоны",
    "CUC" to "Куба айырбасталмалы песосы",
    "CUP" to "Куба песосы",
    "CVE" to "Кабо-Верде эскудосы",
    "CZK" to "Чехия кронасы",
    "DJF" to "Джибути франкі",
    "DKK" to "Дат кроны",
    "DOP" to "Доминикан песосы",
    "DZD" to "Алжир динары",
    "EGP" to "Мысыр фунты",
    "ERN" to "Эритрея накфасы",
    "ETB" to "Эфиопия быры",
    "EUR" to "Еуро",
    "FJD" to "Фиджи доллары",
    "FKP" to "Фолкленд аралдарының фунты",
    "GBP" to "Британдық фунт",
    "GEL" to "Грузия лариі",
    "GHS" to "Гана седиі",
    "GIP" to "Гибралтар фунты",
    "GMD" to "Гамбия даласиі",
    "GNF" to "Гвинея франкі",
    "GTQ" to "Гватемала кетсалі",
    "GYD" to "Гайана доллары",
    "HKD" to "Гонконг доллары",
    "HNL" to "Гондурас лемпирасы",
    "HRK" to "Хорватия кунасы",
    "HTG" to "Гаити гурды",
    "HUF" to "Венгрия форинті",
    "IDR" to "Индонезия рупиясы",
    "ILS" to "Израиль жаңа шекелі",
    "INR" to "Үндістан рупиясы",
    "IQD" to "Ирак динары",
    "IRR" to "Иран риалы",
    "ISK" to "Исландия кронасы",
    "JMD" to "Ямайка доллары",
    "JOD" to "Иордания динары",
    "JPY" to "Жапония иенасы",
    "KES" to "Кения шиллингі",
    "KGS" to "Қырғызстан сомы",
    "KHR" to "Камбоджа риелі",
    "KMF" to "Комор аралдары франкі",
    "KPW" to "Солтүстік Корея воны",
    "KRW" to "Оңтүстік Корея воны",
    "KWD" to "Кувейт динары",
    "KYD" to "Кайман аралдары доллары",
    "KZT" to "Қазақстан теңгесі",
    "LAK" to "Лаос кипі",
    "LBP" to "Ливан фунты",
    "LKR" to "Шри-Ланка рупиясы",
    "LRD" to "Либерия доллары",
    "LSL" to "Лесото лотиі",
    "LTL" to "Литва литы",
    "LVL" to "Латвия латы",
    "LYD" to "Ливия динары",
    "MAD" to "Марокко дирхамы",
    "MDL" to "Молдова лейі",
    "MGA" to "Малагаси ариариі",
    "MKD" to "Македония динары",
    "MMK" to "Мьянма кьяты",
    "MNT" to "Моңғолия тугригі",
    "MOP" to "Макао патакасы",
    "MRO" to "Мавритания угиясы (1973–2017)",
    "MRU" to "Мавритания угиясы",
    "MUR" to "Маврикий рупиясы",
    "MVR" to "Мальдив руфиясы",
    "MWK" to "Малави квачасы",
    "MXN" to "Мексика песосы",
    "MYR" to "Малайзия ринггиті",
    "MZN" to "Мозамбик метикалы",
    "NAD" to "Намибия доллары",
    "NGN" to "Нигерия найрасы",
    "NIO" to "Никарагуа кордобасы",
    "NOK" to "Норвегия кроны",
    "NPR" to "Непал рупиясы",
    "NZD" to "Жаңа Зеландия доллары",
    "OMR" to "Оман риалы",
    "PAB" to "Панама бальбоасы",
    "PEN" to "Перу солі",
    "PGK" to "Папуа - Жаңа Гвинея кинасы",
    "PHP" to "Филиппин песосы",
    "PKR" to "Пәкістан рупиясы",
    "PLN" to "Польша злотасы",
    "PYG" to "Парагвай гуараниі",
    "QAR" to "Катар риалы",
    "RON" to "Румыния лейі",
    "RSD" to "Сербия динары",
    "RUB" to "Ресей рублі",
    "RWF" to "Руанда франкі",
    "SAR" to "Сауд Арабиясының риалы",
    "SBD" to "Соломон аралдары доллары",
    "SCR" to "Сейшель рупиясы",
    "SDG" to "Судан фунты",
    "SEK" to "Швеция кроны",
    "SGD" to "Сингапур доллары",
    "SHP" to "Әулие Елена аралы фунты",
    "SLE" to "Сьерра-Леоне леонесі",
    "SLL" to "Сьерра-Леоне леонесі (1964—2022)",
    "SOS" to "Сомали шиллингі",
    "SRD" to "Суринам доллары",
    "SSP" to "Оңтүстік Судан фунты",
    "STD" to "Сант-Томе мен Принсипи добрасы (1977–2017)",
    "STN" to "Сант-Томе мен Принсипи добрасы",
    "SYP" to "Сирия фунты",
    "SZL" to "Свазиленд лилангениі",
    "THB" to "Тай баты",
    "TJS" to "Тәжікстан сомониі",
    "TMT" to "Түрікменстан манаты",
    "TND" to "Тунис динары",
    "TOP" to "Тонга паангасы",
    "TRY" to "Түрік лирасы",
    "TTD" to "Тринидад және Тобаго доллары",
    "TWD" to "Жаңа Тайвань доллары",
    "TZS" to "Танзания шиллингі",
    "UAH" to "Украина гривнасы",
    "UGX" to "Уганда шиллингі",
    "USD" to "АҚШ доллары",
    "UYU" to "Уругвай песосы",
    "UZS" to "Өзбекстан сомы",
    "VEF" to "Венесуэла боливары (2008–2018)",
    "VES" to "Венесуэла боливары",
    "VND" to "Вьетнам донгі",
    "VUV" to "Вануату ватуы",
    "WST" to "Самоа таласы",
    "XAF" to "Орталық Африканың КФА франкі",
    "XCD" to "Шығыс Кариб доллары",
    "XOF" to "Батыс Африканың КФА франкі",
    "XPF" to "КФП франкі",
    "XXX" to "Белгісіз валюта",
    "YER" to "Йемен риалы",
    "ZAR" to "Оңтүстік Африка рэнді",
    "ZMW" to "Замбия квачасы",
  ) }

  val kk_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kk_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Біріккен Араб Әмірліктерінің дирхамы",
    "AFN" to "Ауғанстан афганиі",
    "ALL" to "Албания легі",
    "AMD" to "Армения драмы",
    "ANG" to "Нидерланд антиль гульдені",
    "AOA" to "Ангола кванзасы",
    "ARS" to "Аргентина песосы",
    "AUD" to "Аустралия доллары",
    "AWG" to "Аруба флорині",
    "AZN" to "Әзірбайжан манаты",
    "BAM" to "Босния және Герцеговина айырбасталмалы маркасы",
    "BBD" to "Барбадос доллары",
    "BDT" to "Бангладеш такасы",
    "BGN" to "Болгария леві",
    "BHD" to "Бахрейн динары",
    "BIF" to "Бурунди франкі",
    "BMD" to "Бермуд доллары",
    "BND" to "Бруней доллары",
    "BOB" to "Боливия боливианосы",
    "BRL" to "Бразилия реалы",
    "BSD" to "Багам доллары",
    "BTN" to "Бутан нгултрумы",
    "BWP" to "Ботсвана пуласы",
    "BYN" to "Беларусь рублі",
    "BYR" to "Беларусь рублі (2000–2016)",
    "BZD" to "Белиз доллары",
    "CAD" to "Канада доллары",
    "CDF" to "Конго франкі",
    "CHF" to "Швейцария франкі",
    "CLP" to "Чили песосы",
    "CNH" to "Қытай юані (офшор)",
    "CNY" to "Қытай юані",
    "COP" to "Колумбия песосы",
    "CRC" to "Коста-Рика колоны",
    "CUC" to "Куба айырбасталмалы песосы",
    "CUP" to "Куба песосы",
    "CVE" to "Кабо-Верде эскудосы",
    "CZK" to "Чехия кронасы",
    "DJF" to "Джибути франкі",
    "DKK" to "Дат кроны",
    "DOP" to "Доминикан песосы",
    "DZD" to "Алжир динары",
    "EGP" to "Мысыр фунты",
    "ERN" to "Эритрея накфасы",
    "ETB" to "Эфиопия быры",
    "EUR" to "Еуро",
    "FJD" to "Фиджи доллары",
    "FKP" to "Фолкленд аралдарының фунты",
    "GBP" to "Британдық фунт",
    "GEL" to "Грузия лариі",
    "GHS" to "Гана седиі",
    "GIP" to "Гибралтар фунты",
    "GMD" to "Гамбия даласиі",
    "GNF" to "Гвинея франкі",
    "GTQ" to "Гватемала кетсалі",
    "GYD" to "Гайана доллары",
    "HKD" to "Гонконг доллары",
    "HNL" to "Гондурас лемпирасы",
    "HRK" to "Хорватия кунасы",
    "HTG" to "Гаити гурды",
    "HUF" to "Венгрия форинті",
    "IDR" to "Индонезия рупиясы",
    "ILS" to "Израиль жаңа шекелі",
    "INR" to "Үндістан рупиясы",
    "IQD" to "Ирак динары",
    "IRR" to "Иран риалы",
    "ISK" to "Исландия кронасы",
    "JMD" to "Ямайка доллары",
    "JOD" to "Иордания динары",
    "JPY" to "Жапония иенасы",
    "KES" to "Кения шиллингі",
    "KGS" to "Қырғызстан сомы",
    "KHR" to "Камбоджа риелі",
    "KMF" to "Комор аралдары франкі",
    "KPW" to "Солтүстік Корея воны",
    "KRW" to "Оңтүстік Корея воны",
    "KWD" to "Кувейт динары",
    "KYD" to "Кайман аралдары доллары",
    "KZT" to "Қазақстан теңгесі",
    "LAK" to "Лаос кипі",
    "LBP" to "Ливан фунты",
    "LKR" to "Шри-Ланка рупиясы",
    "LRD" to "Либерия доллары",
    "LSL" to "Лесото лотиі",
    "LTL" to "Литва литы",
    "LVL" to "Латвия латы",
    "LYD" to "Ливия динары",
    "MAD" to "Марокко дирхамы",
    "MDL" to "Молдова лейі",
    "MGA" to "Малагаси ариариі",
    "MKD" to "Македония динары",
    "MMK" to "Мьянма кьяты",
    "MNT" to "Моңғолия тугригі",
    "MOP" to "Макао патакасы",
    "MRO" to "Мавритания угиясы (1973–2017)",
    "MRU" to "Мавритания угиясы",
    "MUR" to "Маврикий рупиясы",
    "MVR" to "Мальдив руфиясы",
    "MWK" to "Малави квачасы",
    "MXN" to "Мексика песосы",
    "MYR" to "Малайзия ринггиті",
    "MZN" to "Мозамбик метикалы",
    "NAD" to "Намибия доллары",
    "NGN" to "Нигерия найрасы",
    "NIO" to "Никарагуа кордобасы",
    "NOK" to "Норвегия кроны",
    "NPR" to "Непал рупиясы",
    "NZD" to "Жаңа Зеландия доллары",
    "OMR" to "Оман риалы",
    "PAB" to "Панама бальбоасы",
    "PEN" to "Перу солі",
    "PGK" to "Папуа - Жаңа Гвинея кинасы",
    "PHP" to "Филиппин песосы",
    "PKR" to "Пәкістан рупиясы",
    "PLN" to "Польша злотасы",
    "PYG" to "Парагвай гуараниі",
    "QAR" to "Катар риалы",
    "RON" to "Румыния лейі",
    "RSD" to "Сербия динары",
    "RUB" to "Ресей рублі",
    "RWF" to "Руанда франкі",
    "SAR" to "Сауд Арабиясының риалы",
    "SBD" to "Соломон аралдары доллары",
    "SCR" to "Сейшель рупиясы",
    "SDG" to "Судан фунты",
    "SEK" to "Швеция кроны",
    "SGD" to "Сингапур доллары",
    "SHP" to "Әулие Елена аралы фунты",
    "SLE" to "Сьерра-Леоне леонесі",
    "SLL" to "Сьерра-Леоне леонесі (1964—2022)",
    "SOS" to "Сомали шиллингі",
    "SRD" to "Суринам доллары",
    "SSP" to "Оңтүстік Судан фунты",
    "STD" to "Сант-Томе мен Принсипи добрасы (1977–2017)",
    "STN" to "Сант-Томе мен Принсипи добрасы",
    "SYP" to "Сирия фунты",
    "SZL" to "Свазиленд лилангениі",
    "THB" to "Тай баты",
    "TJS" to "Тәжікстан сомониі",
    "TMT" to "Түрікменстан манаты",
    "TND" to "Тунис динары",
    "TOP" to "Тонга паангасы",
    "TRY" to "Түрік лирасы",
    "TTD" to "Тринидад және Тобаго доллары",
    "TWD" to "Жаңа Тайвань доллары",
    "TZS" to "Танзания шиллингі",
    "UAH" to "Украина гривнасы",
    "UGX" to "Уганда шиллингі",
    "USD" to "АҚШ доллары",
    "UYU" to "Уругвай песосы",
    "UZS" to "Өзбекстан сомы",
    "VEF" to "Венесуэла боливары (2008–2018)",
    "VES" to "Венесуэла боливары",
    "VND" to "Вьетнам донгі",
    "VUV" to "Вануату ватуы",
    "WST" to "Самоа таласы",
    "XAF" to "Орталық Африканың КФА франкі",
    "XCD" to "Шығыс Кариб доллары",
    "XOF" to "Батыс Африканың КФА франкі",
    "XPF" to "КФП франкі",
    "XXX" to "Белгісіз валюта",
    "YER" to "Йемен риалы",
    "ZAR" to "Оңтүстік Африка рэнді",
    "ZMW" to "Замбия квачасы",
  ) }

  val kk_KZ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kkj: ImmutableMap<String, String> by lazy { immutableMapOf(
    "XAF" to "Franc CFA",
  ) }

  val kl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "EUR" to "euro",
  ) }

  val kln: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Rabisiekab Kibagegeitab arabuk",
    "AOA" to "Rabisiekab Angolan",
    "AUD" to "Dolaitab Australian",
    "BHD" to "Rabisiekab Bahrain",
    "BIF" to "Rabisiekab Burundi",
    "BWP" to "Rabisiekab Botswana",
    "CAD" to "Dolaitab Kanada",
    "CDF" to "Rabisiekab Congo",
    "CHF" to "Rabisiekab Swiss",
    "CNY" to "Rabisiekab China",
    "CVE" to "Rabisiekab Kepuvede",
    "DJF" to "Rabisiekab Jibuti",
    "DZD" to "Rabisiekab Algerian",
    "EGP" to "Pauditab Misri",
    "ERN" to "Rabisiekab Eritrea",
    "ETB" to "Rabisiekab Ethiopia",
    "EUR" to "Yuroit",
    "GBP" to "pounditab Uingereza",
    "GHC" to "Rabisiekab Ghana",
    "GMD" to "Rabisiekab Gambia",
    "GNS" to "Rabisiekab Guinea",
    "INR" to "Rabisiekab India",
    "JPY" to "Rabisiekab Japan",
    "KES" to "Silingitab ya Kenya",
    "KMF" to "Rabisiekab Komoro",
    "LRD" to "Dolaitab Liberia",
    "LSL" to "Rabisiekab Lesoto",
    "LYD" to "Rabisiekab Libya",
    "MAD" to "Rabisiekab Moroccan",
    "MGA" to "Rabisiekab Malagasy",
    "MRO" to "Rabisiekab Mauritania (1973–2017)",
    "MRU" to "Rabisiekab Mauritania",
    "MUR" to "Rabisiekab Mauritius",
    "MWK" to "Rabisiekaby Malawi",
    "MZM" to "Rabisiekab Msumbiji",
    "NAD" to "Dolaitab Namibia",
    "NGN" to "Rabisiekab Nigeria",
    "RWF" to "Rabisiekab Rwanda",
    "SAR" to "Rabisiekab Saudia",
    "SCR" to "Rabisiekab Shelisheli",
    "SDG" to "Pouditab Sudan",
    "SHP" to "Pouditab helena ne tilil",
    "SLE" to "Leonit",
    "SLL" to "Leonit (1964—2022)",
    "SOS" to "siligitab Somalia",
    "STD" to "Rabisiekab Sao Tome ak Principe (1977–2017)",
    "STN" to "Rabisiekab Sao Tome ak Principe",
    "SZL" to "Lilangenit",
    "TND" to "RabisiekabTunisia",
    "TZS" to "silingitab Tanzania",
    "UGX" to "Silingitab Uganda",
    "USD" to "Dolaitab ya Amareka",
    "XAF" to "Rabisiekab CFA BEAC",
    "XOF" to "Rabisiekab CFA BCEAO",
    "ZAR" to "Randitab Afrika nebo murot tai",
    "ZMK" to "Kwachaitab Zambia (1968–2012)",
    "ZMW" to "Kwachaitab Zambia",
    "ZWD" to "Dolaitab ya Zimbabwe",
  ) }

  val km: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "ឌៀរហាំ​អារ៉ាប់រួម",
    "AFN" to "អាហ្វហ្គានី​អាហ្វហ្គានីស្ថាន",
    "ALL" to "លិក​អាល់បានី",
    "AMD" to "ដ្រាំ​អាមេនី",
    "ANG" to "ហ្គីឌិន​ហុល្លង់​អង់ទីលៀន",
    "AOA" to "ក្វាន់ហ្សា​អង់ហ្គោឡា",
    "ARS" to "ប៉េសួអាហ្សង់ទីន",
    "AUD" to "ដុល្លារ​អូស្ត្រាលី",
    "AWG" to "ហ្វ្រ័ររិញ​អារ៉ូបា",
    "AZN" to "ម៉ាណាត​អាស៊ែបៃហ្សង់",
    "BAM" to "ម៉ាក​អាច​បម្លែង​បាន​បូស្នី",
    "BBD" to "ដុល្លារ​បាបាដុស",
    "BDT" to "តាកា​បង់ក្លាដែស",
    "BGN" to "លីវ​ប៊ុលហ្គារី",
    "BHD" to "ឌីណា​បារ៉ែន",
    "BIF" to "ហ្វ្រង់​ប៊ូរុនឌី",
    "BMD" to "ដុល្លារ​ប៊ឺមុយដា",
    "BND" to "ដុល្លារព្រុយណេ",
    "BOB" to "បូលីវីណូ​បូលីវី",
    "BRL" to "រៀល​ប្រេស៊ីល",
    "BSD" to "ដុល្លារ​បាហាម៉ា",
    "BTN" to "ញូលត្រឹម​ប៊ូតាន",
    "BWP" to "ពូឡា​បុតស្វាណា",
    "BYN" to "រ៉ូបល​បេឡារុស",
    "BYR" to "រ៉ូបល​បេឡារុស (2000–2016)",
    "BZD" to "ដុល្លារ​បេលី",
    "CAD" to "ដុល្លារ​កាណាដា",
    "CDF" to "ហ្វ្រង់​កុងហ្គោ",
    "CHF" to "ហ្វ្រង់ស្វីស",
    "CLP" to "ប៉េសូឈីលី",
    "CNH" to "យ័នចិន (ក្រៅប្រទេស)",
    "CNY" to "យ័នចិន",
    "COP" to "ប៉េសូកូឡុំប៊ី",
    "CRC" to "កូឡុង​កូស្តារីកា",
    "CUC" to "ប៉េសូ​គុយបាអាច​បម្លែង​បាន",
    "CUP" to "ប៉េសូគុយបា",
    "CVE" to "អ៊ីស្កូឌូ​កាប់វែរ",
    "CZK" to "កូរុណា​សាធារណៈ​ឆេក",
    "DJF" to "ហ្វ្រង់​ជីប៊ូទី",
    "DKK" to "ក្រូណេ​ដាណាម៉ាក់",
    "DOP" to "ប៉េសូដូមីនីក",
    "DZD" to "ឌីណា​អាល់ស៊េរី",
    "EGP" to "ផោនអេហ្ស៊ីប",
    "ERN" to "ណាក់ហ្វាអេរីទ្រា",
    "ETB" to "ប៊័រ​អេត្យូពី",
    "EUR" to "អឺរ៉ូ",
    "FJD" to "ដុល្លារ​ហ្វីជី",
    "FKP" to "ផោន​កោះ​ហ្វក់ឡែន",
    "GBP" to "ផោនចក្រភពអង់គ្លេស",
    "GEL" to "ឡារី​​ហ្សកហ្ស៊ី",
    "GHS" to "ស៊ីឌី​ហ្គាណា",
    "GIP" to "ផោន​ហ្ស៊ីប្រាល់តា",
    "GMD" to "ដាឡាស៊ី​ហ្គាំប៊ី",
    "GNF" to "ហ្វ្រង់​ហ្គីណេ",
    "GTQ" to "ហ្គីស្សាល​ក្វាតេម៉ាឡា",
    "GYD" to "ដុល្លារ​ហ្គីយ៉ាន",
    "HKD" to "ដុល្លារ​ហុងកុង",
    "HNL" to "លិមពីរ៉ា​ហុងឌូរ៉ាស",
    "HRK" to "គូណា​ក្រូអាត",
    "HTG" to "គោឌី​ហៃទី",
    "HUF" to "ហ្វូរីន​ហុងគ្រី",
    "IDR" to "រូពីឥណ្ឌូណេស៊ី",
    "ILS" to "ស៊ីគែលថ្មីអ៊ីស្រាអែល",
    "INR" to "រូពីឥណ្ឌា",
    "IQD" to "ឌីណា​អ៊ីរ៉ាក់",
    "IRR" to "រៀល​អ៊ីរ៉ង់",
    "ISK" to "ក្រូណា​អ៊ីស្លង់",
    "JMD" to "ដុល្លារ​ហ្សាម៉ាអ៊ីក",
    "JOD" to "ឌីណា​ហ្ស៊កដានី",
    "JPY" to "យេន​ជប៉ុន",
    "KES" to "ស៊ីលិញ​កេនយ៉ា",
    "KGS" to "សុម​កៀហ្ស៊ីស៊ីស្ថាន",
    "KHR" to "រៀល​កម្ពុជា",
    "KMF" to "ហ្វ្រង់​កូម័រ",
    "KPW" to "វ៉ុនកូរ៉េខាងជើង",
    "KRW" to "វ៉ុនកូរ៉េខាងត្បូង",
    "KWD" to "ឌីណា​គុយវ៉ែត",
    "KYD" to "ដុល្លារ​កោះ​កៃម៉ែន",
    "KZT" to "តង់ហ្គី​កាហ្សាក់ស្ថាន",
    "LAK" to "គីប​ឡាវ",
    "LBP" to "ផោន​លីបង់",
    "LKR" to "រូពីស្រីលង្កា",
    "LRD" to "ដុល្លារ​លីប៊ី",
    "LSL" to "ឡូទីឡេសូតូ",
    "LTL" to "លីតា​លីទុយអានី",
    "LVL" to "ឡាត់​ឡេតូនី",
    "LYD" to "ឌីណា​លីប៊ី",
    "MAD" to "ឌៀរហាំ​ម៉ារ៉ុក",
    "MDL" to "លូ​ម៉ុលដាវី",
    "MGA" to "អារៀរី​ម៉ាឡាហ្គាស៊ី",
    "MKD" to "ឌីណាម៉ាសេដូនី",
    "MMK" to "គីយ៉ាត​ភូមា",
    "MNT" to "ទូរីក​ម៉ុងហ្គោលី",
    "MOP" to "ប៉ាតាកា​ម៉ាកាវ",
    "MRO" to "អ៊ូហ្គីយ៉ា​ម៉ូរីតានី (1973–2017)",
    "MRU" to "អ៊ូហ្គីយ៉ា​ម៉ូរីតានី",
    "MUR" to "រូពីម៉ូរីតានី",
    "MVR" to "រ៉ូហ្វីយ៉ា​ម៉ាល់ឌីវ",
    "MWK" to "ក្វាចា​ម៉ាឡាវី",
    "MXN" to "ប៉េសូម៉ិកសិក",
    "MYR" to "រីងហ្គីត​ម៉ាឡេស៊ី",
    "MZN" to "មីទីខល​ម៉ូសំប៊ិក",
    "NAD" to "ដុល្លារ​ណាមីប៊ី",
    "NGN" to "ណៃរ៉ា​នីហ្សេរីយ៉ា",
    "NIO" to "ខឌូបា​នីការ៉ាហ្កា",
    "NOK" to "ក្រូណេ​ន័រវ៉េ",
    "NPR" to "រូពីនេប៉ាល់",
    "NZD" to "ដុល្លារ​នូវែលសេឡង់",
    "OMR" to "រៀល​រូម៉ានី",
    "PAB" to "បាល់ប៉ៅ​ប៉ាណាម៉ា",
    "PEN" to "ញូវ៉ូសូល​ប៉េរូ",
    "PGK" to "គីណាប៉ាពួញូហ្គីណេ",
    "PHP" to "ប៉េសូហ្វីលីពីន",
    "PKR" to "រូពីប៉ាគីស្ថាន",
    "PLN" to "ហ្សូទី​ប៉ូឡូញ",
    "PYG" to "ហ្គូរីនី​ប៉ារ៉ាហ្គាយ",
    "QAR" to "រីយ៉ាលកាតា",
    "RON" to "លូ​រូម៉ានី",
    "RSD" to "ឌីណាស៊ែប",
    "RUB" to "រ៉ូបល​រុស្ស៊ី",
    "RWF" to "ហ្វ្រង់​រវ៉ាន់ដា",
    "SAR" to "រីយ៉ាល​អារ៉ាប៊ីសាអូឌីត",
    "SBD" to "ដុល្លារ​កោះ​សូឡូម៉ុង",
    "SCR" to "រូពី​សីស្ហែល",
    "SDG" to "ផោន​ស៊ូដង់",
    "SEK" to "ក្រូណា​ស៊ុយអែត",
    "SGD" to "ដុល្លារ​​សិង្ហបូរី",
    "SHP" to "ផោន​សាំងហេឡេណា",
    "SLE" to "លីអ៊ុន​សៀរ៉ាឡេអូន",
    "SLL" to "លីអ៊ុន​សៀរ៉ាឡេអូន (1964—2022)",
    "SOS" to "ស៊ីលិញ​សូម៉ាលី",
    "SRD" to "ដុល្លារ​សូរីណាម",
    "SSP" to "ផោន​ស៊ូដង់​ខាង​ត្បូង",
    "STD" to "ឌូប្រា​សៅតូម៉េ និងប្រាំងស៊ីប (1977–2017)",
    "STN" to "ឌូប្រា​សៅតូម៉េ និងប្រាំងស៊ីប",
    "SYP" to "ផោន​ស៊ីរី",
    "SZL" to "លីឡាងហ្គីនី​ស្វាស៊ីឡង់",
    "THB" to "បាត​ថៃ",
    "TJS" to "សូមុនី​តាហ្ស៊ីគីស្ថាន",
    "TMT" to "ម៉ាណាត​តួកម៉េនីស្ថាន",
    "TND" to "ឌីណាទុយនេស៊ី",
    "TOP" to "ប៉ាអង់កា​តុងហ្គា",
    "TRY" to "លីរ៉ាទួរគី",
    "TTD" to "ដុល្លារ​ទ្រីនីដាដ និងតូបាហ្គោ",
    "TWD" to "ដុល្លារ​តៃវ៉ាន់",
    "TZS" to "ស៊ីលិញ​តង់សានី",
    "UAH" to "ហ៊ូនីយ៉ា​អ៊ុយក្រែន",
    "UGX" to "ស៊ីលិញ​អ៊ូហ្គង់ដា",
    "USD" to "ដុល្លារ​អាមេរិក",
    "UYU" to "ប៉េសូអ៊ុយរូហ្គាយ",
    "UZS" to "សុមអ៊ូបេគីស្ថាន",
    "VEF" to "ប៊ូលីវ៉ា​វ៉េណេស៊ុយអេឡា (2008–2018)",
    "VES" to "ប៊ូលីវ៉ា​វ៉េណេស៊ុយអេឡា",
    "VND" to "ដុង​វៀតណាម",
    "VUV" to "វ៉ាទូវ៉ានូអាទូ",
    "WST" to "តាឡា​សាម័រ",
    "XAF" to "ហ្វ្រង់ CFA អាហ្វ្រិកកណ្តាល",
    "XCD" to "ដុល្លារ​ការ៉ាប៊ីន​ខាង​កើត",
    "XOF" to "ហ្វ្រង់ CFA អាហ្វ្រិកខាងលិច",
    "XPF" to "ហ្វ្រង់ CFP",
    "XXX" to "រូបិយប័ណ្ណ​មិនស្គាល់",
    "YER" to "រៀល​យេម៉ែន",
    "ZAR" to "រ៉ង់អាហ្វ្រិកខាងត្បូង",
    "ZMK" to "ក្វាចា សំប៊ី (1968–2012)",
    "ZMW" to "ក្វាចាហ្សំប៊ី",
  ) }

  val kn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "ಸಂಯುಕ್ತ ಅರಬ್‌ ಎಮಿರೇಟ್‌‌ಗಳ ದಿರಾಮ್‌‌",
    "AFN" to "ಅಫ್‌ಘನ್ ಅಫಘಾನಿ",
    "ALL" to "ಅಲ್‌ಬೇನಿಯನ್ ಲೆಕ್",
    "AMD" to "ಅರ್ಮೆನಿಯನ್ ಡ್ರಾಮ್",
    "ANG" to "ನೆದರ್ಲೆಂಡ್ಸ್ ಆಂಟಿಲಿಯನ್ ಗಿಲ್ಡರ್",
    "AOA" to "ಅಂಗೋಲಾದ ಕ್ವಾನ್ಝಾ",
    "ARS" to "ಅರ್ಜೆಂಟಿನಾ ಪೆಸೊ",
    "AUD" to "ಆಸ್ಟ್ರೇಲಿಯನ್ ಡಾಲರ್‌",
    "AWG" to "ಅರುಬನ್ ಫ್ಲೊರೀನ್‌‌",
    "AZN" to "ಅಝರ್‌ಬೈಜಾನಿ ಮನಾತ್",
    "BAM" to "ಬೋಸ್ನಿಯಾ-ಹರ್ಜ್‌ಗೋವಿನ ಪರಿವರ್ತನೀಯ ಗುರುತು",
    "BBD" to "ಬರ್ಬಾಡಿಯನ್ ಡಾಲರ್",
    "BDT" to "ಬಾಂಗ್ಲಾದೇಶದ ಟಾಕಾ",
    "BGN" to "ಬಲ್ಗೇರಿಯನ್ ಲೆವ್",
    "BHD" to "ಬಹ್‌‌ರೈನಿ ದಿನಾರ್",
    "BIF" to "ಬುರುಂದಿಯನ್ ಫ್ರಾಂಕ್",
    "BMD" to "ಬರ್ಮುಡನ್ ಡಾಲರ್",
    "BND" to "ಬ್ರೂನಿ ಡಾಲರ್",
    "BOB" to "ಬೊಲಿವಿಯಾದ ಬೊಲಿವಿಯಾನೊ",
    "BRL" to "ಬ್ರೆಜಿಲಿಯನ್‌ ರಿಯಲ್",
    "BSD" to "ಬಹಾಮಿಯನ್ ಡಾಲರ್",
    "BTN" to "ಭೂತಾನೀಸ್ ನುಲ್ತರಮ್",
    "BWP" to "ಬೋಟ್ಸ್‌ವಾನನ್ ಪುಲಾ",
    "BYN" to "ಬೆಲಾರುಸಿಯನ್ ರೂಬಲ್",
    "BYR" to "ಬೆಲಾರುಸಿಯನ್ ರೂಬಲ್ (2000–2016)",
    "BZD" to "ಬೆಲೀಜ್ ಡಾಲರ್",
    "CAD" to "ಕೆನಡಾದ ಡಾಲರ್",
    "CDF" to "ಕಾಂಗೋಲೀಸ್ ಫ್ರಾಂಕ್",
    "CHF" to "ಸ್ವಿಸ್ ಫ್ರಾಂಕ್",
    "CLP" to "ಚಿಲಿಯ ಪೆಸೊ",
    "CNH" to "ಚೈನೀಸ್ ಯುವಾನ್ (ಆಫ್‌ಶೋರ್)",
    "CNY" to "ಚೈನೀಸ್ ಯುವಾನ್",
    "COP" to "ಕೊಲೊಂಬಿಯೋದ ಪೆಸೊ",
    "CRC" to "ಕೋಸ್ಟ ರಿಕನ್ ಕೊಲನ್",
    "CUC" to "ಕ್ಯುಬಾದ ಪರಿವರ್ತನೀಯ ಪೆಸೊ",
    "CUP" to "ಕ್ಯೂಬಾದ ಪೆಸೊ",
    "CVE" to "ಕೇಪ್ ವರ್ಡಿನ್ ಎಸ್‌ಕೂಡೊ",
    "CZK" to "ಝೆಕ್ ಗಣರಾಜ್ಯ ಕೊರೂನ",
    "DJF" to "ಜಿಬೊಟಿಯನ್ ಫ್ರಾಂಕ್",
    "DKK" to "ಡ್ಯಾನಿಶ್ ಕ್ರೋನ್",
    "DOP" to "ಡೊಮಿನಿಕನ್ ಪೆಸೊ",
    "DZD" to "ಅಲ್ಜೀರಿಯನ್ ದಿನಾರ್",
    "EGP" to "ಈಜಿಪ್ಷಿಯನ್ ಪೌಂಡ್‍",
    "ERN" to "ಎರಿತ್ರಿಯನ್ ನಕ್ಫಾ",
    "ETB" to "ಇಥಿಯೋಪಿಯನ್ ಬಿರ್",
    "EUR" to "ಯೂರೊ",
    "FJD" to "ಫಿಜಿಯನ್ ಡಾಲರ್",
    "FKP" to "ಫಾಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳ ಪೌಂಡ್",
    "GBP" to "ಬ್ರಿಟಿಷ್ ಪೌಂಡ್",
    "GEL" to "ಜಾರ್ಜಿಯಾದ ಲಾರಿ",
    "GHS" to "ಘಾನಾದ ಸೆದಿ",
    "GIP" to "ಗಿಬ್ರಾಲ್ಟರ್ ಪೌಂಡ್",
    "GMD" to "ಗ್ಯಾಂಬಿಯಾದ ದಲಾಸಿ",
    "GNF" to "ಗಿನಿಯನ್ ಫ್ರಾಂಕ್",
    "GTQ" to "ಗ್ವಾಟೆಮಾಲಾದ ಕುಯಿಟ್ಸಲ್‌‌",
    "GYD" to "ಗುಯಾನೀಸ್‌ ಡಾಲರ್‌",
    "HKD" to "ಹಾಂಗ್ ಕಾಂಗ್ ಡಾಲರ್",
    "HNL" to "ಹೊಂಡುರಾನ್‌ ಲೆಂಪಿರಾ",
    "HRK" to "ಕ್ರೊಯೆಷ್ಯಾದ ಕೂನಾ",
    "HTG" to "ಹೈಟಿಯ ಗೋರ್ದೆ",
    "HUF" to "ಹಂಗೇರಿಯನ್ ಫೋರಿಂಟ್",
    "IDR" to "ಇಂಡೊನೇಷ್ಯಾ ರುಪೈ",
    "ILS" to "ಇಸ್ರೇಲಿ ನ್ಯೂ ಶೇಖಲ್",
    "INR" to "ಭಾರತೀಯ ರೂಪಾಯಿ",
    "IQD" to "ಇರಾಕಿ ದಿನಾರ್",
    "IRR" to "ಇರಾನಿಯನ್ ರಿಯಲ್",
    "ISK" to "ಐಸ್‌ಲ್ಯಾಂಡಿಕ್ ಕ್ರೋನಾ",
    "JMD" to "ಜಮೈಕನ್ ಡಾಲರ್",
    "JOD" to "ಜೋರ್ಡಾನಿಯನ್ ದಿನಾರ್",
    "JPY" to "ಜಪಾನೀಸ್ ಯೆನ್",
    "KES" to "ಕೀನ್ಯಾದ ಶಿಲ್ಲಿಂಗ್‌",
    "KGS" to "ಕಿರ್ಗಿಸ್ತಾನಿ ಸೋಮ್",
    "KHR" to "ಕಾಂಬೋಡಿಯನ್ ರಿಯಲ್",
    "KMF" to "ಕೊಮೊರಿಯನ್ ಫ್ರಾಂಕ್",
    "KPW" to "ಉತ್ತರ ಕೊರಿಯನ್ ವೋನ್",
    "KRW" to "ದಕ್ಷಿಣ ಕೊರಿಯನ್ ವೊನ್",
    "KWD" to "ಕುವೈತೀ ದಿನಾರ್",
    "KYD" to "ಕೆಮ್ಯಾನ್‌ ಐಲ್ಯಾಂಡ್‌ನ ಡಾಲರ್‌",
    "KZT" to "ಕಜಾಕಿಸ್ತಾನಿ ತೆಂಗೆ",
    "LAK" to "ಲೋಟಿಯನ್ ಕಿಪ್",
    "LBP" to "ಲೆಬೆನೀಸ್ ಪೌಂಡ್",
    "LKR" to "ಶ್ರೀಲಂಕಾದ ರುಪೀ",
    "LRD" to "ಲಿಬೇರಿಯನ್ ಡಾಲರ್",
    "LSL" to "ಲೆಸೊತೊ ಲೊತಿ",
    "LTL" to "ಲಿಥುನಿಯನ್‌ ಲಿತಾಸ್‌",
    "LVL" to "ಲ್ಯಾಟ್ವಿಯನ್ ಲ್ಯಾಟ್ಸ್",
    "LYD" to "ಲಿಬಿಯಾದ ದಿನಾರ್‌",
    "MAD" to "ಮೊರೊಕನ್ ದಿರ್‌ಹಮ್",
    "MDL" to "ಮಲ್ದೋವಾದ ಲೆವೂ",
    "MGA" to "ಮಲಗಾಸಿ ಅರಿಯಾರಿ",
    "MKD" to "ಮೆಸಡೋನಿಯನ್ ದಿನಾರ್",
    "MMK" to "ಮ್ಯಾನ್ಮಾರ್ ಕ್ಯಾಟ್",
    "MNT" to "ಮಂಗೋಲಿಯಾದ ತುಗ್ರಿಕ್‌‌",
    "MOP" to "ಮಕಾನಿಸ್ ಪಟಾಕಾ",
    "MRO" to "ಮೌರೀಶಿಯನಿಯನ್ ಒಗಿಯ (1973–2017)",
    "MRU" to "ಮೌರೀಶಿಯನಿಯನ್ ಒಗಿಯ",
    "MUR" to "ಮಾರಿಷಿಯನ್ ರುಪಿ",
    "MVR" to "ಮಾಲ್ಡೀವಿಯನ್ ರುಫಿಯಾ",
    "MWK" to "ಮಲಾವಿಯ ಕ್ವಾಚ",
    "MXN" to "ಮೆಕ್ಸಿಕೊದ ಪೆಸೊ",
    "MYR" to "ಮಲೇಶಿಯನ್ ರಿಂಗಿಟ್",
    "MZN" to "ಮೊಝಾಂಬಿಕನ್ ಮೆಟಿಕಲ್",
    "NAD" to "ನಮೀಬಿಯನ್ ಡಾಲರ್",
    "NGN" to "ನೈಜೀರಿಯಾದ ನೇರಾ",
    "NIO" to "ನಿಕಾರಗ್ವಾದ ಕರ್ದೊಬಾ",
    "NOK" to "ನಾರ್ವೇಯ ಕ್ರೋನ್",
    "NPR" to "ನೇಪಾಳದ ರುಪೀ",
    "NZD" to "ನ್ಯೂಜಿಲ್ಯಾಂಡ್ ಡಾಲರ್",
    "OMR" to "ಒಮಾನಿ ರಿಯಲ್",
    "PAB" to "ಪನಾಮಾನಿಯನ್ ಬಲ್ಬೋವಾ",
    "PEN" to "ಪೆರುವಿಯನ್ ಸೊಲ್",
    "PGK" to "ಪಪುವಾ ನ್ಯೂ ಗಿನಿಯನ್ ಕಿನಾ",
    "PHP" to "ಫಿಲಿಪ್ಪೈನ್ ಪಿಸೊ",
    "PKR" to "ಪಾಕಿಸ್ತಾನದ ರುಪೀ",
    "PLN" to "ಪೊಲಿಶ್ ಝ್ಲೋಟಿ",
    "PYG" to "ಪೆರುಗ್ವೇಯ ಗ್ವಾರನೀ",
    "QAR" to "ಖತಾರಿ ರಿಯಲ್",
    "RON" to "ರೊಮೇನಿಯನ್ ಲೆವು",
    "RSD" to "ಸೆರ್ಬಿಯನ್ ದಿನಾರ್",
    "RUB" to "ರಶಿಯನ್ ರೂಬಲ್",
    "RWF" to "ರುವಾಂಡನ್ ಫ್ರಾಂಕ್",
    "SAR" to "ಸೌದಿ ರಿಯಾಲ್",
    "SBD" to "ಸೊಲೊಮನ್ ದ್ವೀಪಗಳ ಡಾಲರ್",
    "SCR" to "ಸೆಚೊಲಿಯೊಸ್ ರುಪಿ",
    "SDG" to "ಸುಡಾನೀಸ್ ಪೌಂಡ್",
    "SEK" to "ಸ್ವೀಡಿಷ್ ಕ್ರೋನಾ",
    "SGD" to "ಸಿಂಗಾಪುರ್ ಡಾಲರ್‌",
    "SHP" to "ಸೇಂಟ್ ಹೆಲೇನಾ ಪೌಂಡ್",
    "SLE" to "ಸಿಯೆರಾ ಲಿಯೋನಿಯನ್ ಲಿಯೋನ್",
    "SLL" to "ಸಿಯೆರಾ ಲಿಯೋನಿಯನ್ ಲಿಯೋನ್ (1964—2022)",
    "SOS" to "ಸೊಮಾಲಿ ಶಿಲ್ಲಿಂಗ್",
    "SRD" to "ಸುರಿನಾಮೀಸ್ ಡಾಲರ್",
    "SSP" to "ದಕ್ಷಿಣ ಸೂಡಾನೀಸ್ ಪೌಂಡ್‍",
    "STD" to "ಸಾವೊ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪ್ ದೊಬ್ರಾ (1977–2017)",
    "STN" to "ಸಾವೊ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪ್ ದೊಬ್ರಾ",
    "SYP" to "ಸಿರಿಯನ್ ಪೌಂಡ್",
    "SZL" to "ಸ್ವಾಜಿ ಲಿಲಂಗೆನಿ",
    "THB" to "ಥಾಯ್ ಬಹ್ತ್",
    "TJS" to "ತಜಕಿಸ್ತಾನಿ ಸೊಮೋನಿ",
    "TMT" to "ಟರ್ಕ್‍ಮೆನಿಸ್ತಾನ್ ಮನಾತ್",
    "TND" to "ಟ್ಯುನೀಷಿಯನ್‌ ದಿನಾರ್",
    "TOP" to "ಟೊಂಗಾ ಪಾಂಗ",
    "TRY" to "ಟರ್ಕಿಶ್ ಲಿರಾ",
    "TTD" to "ಟ್ರಿನಿಡಾಡ್ ಮತ್ತು ಟೊಬಾಗೊ ಡಾಲರ್",
    "TWD" to "ನ್ಯೂ ತೈವಾನ್ ಡಾಲರ್",
    "TZS" to "ತಾನ್‌ಜೇನಿಯನ್ ಶಿಲ್ಲಿಂಗ್",
    "UAH" to "ಉಕ್ರೇನಿಯನ್ ಹ್ರಿವ್ನೀಯ",
    "UGX" to "ಉಗಾಂಡನ್ ಶಿಲ್ಲಿಂಗ್",
    "USD" to "ಅಮೆರಿಕದ ಡಾಲರ್‌",
    "UYU" to "ಉರುಗ್ವೆಯ ಪೆಸೊ",
    "UZS" to "ಉಜ್ಬೇಕಿಸ್ತಾನ್ ಸೊಮ್",
    "VEF" to "ವೆನಿಜುಲಿಯನ್ ಬೊಲಿವರ್ (2008–2018)",
    "VES" to "ವೆನಿಜುಲಿಯನ್ ಬೊಲಿವರ್",
    "VND" to "ವಿಯೆಟ್ನಾಮೀಸ್ ಡಾಂಗ್",
    "VUV" to "ವನೂತು ವತು",
    "WST" to "ಸಮೋನ್ ತಲಾ",
    "XAF" to "ಮಧ್ಯ ಆಫ್ರಿಕನ್ CFA ಫ್ರಾಂಕ್",
    "XCD" to "ಪೂರ್ವ ಕೆರೀಬಿಯನ್ ಡಾಲರ್",
    "XOF" to "ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾದ CFA ಫ್ರಾಂಕ್",
    "XPF" to "[CFP] ಫ್ರಾಂಕ್",
    "XXX" to "ಅಪರಿಚಿತ ಕರೆನ್ಸಿ",
    "YER" to "ಯೆಮೆನಿ ರಿಯಲ್",
    "ZAR" to "ದಕ್ಷಿಣ ಆಫ್ರಿಕನ್ ರಾಂಡ್",
    "ZMK" to "ಜಾಂಬಿಯಾ ಕ್ವಾಚ (1968–2012)",
    "ZMW" to "ಜಾಂಬಿಯಾ ಕ್ವಾಚ",
  ) }

  val ko: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "안도라 페세타",
    "AED" to "아랍에미리트 디르함",
    "AFA" to "아프가니 (1927–2002)",
    "AFN" to "아프가니스탄 아프가니",
    "ALL" to "알바니아 레크",
    "AMD" to "아르메니아 드람",
    "ANG" to "네덜란드령 안틸레스 길더",
    "AOA" to "앙골라 콴자",
    "AOK" to "앙골라 콴자 (1977–1990)",
    "AON" to "앙골라 신콴자 (1990–2000)",
    "AOR" to "앙골라 재조정 콴자 (1995–1999)",
    "ARA" to "아르헨티나 오스트랄",
    "ARL" to "아르헨티나 페소 레이 (1970–1983)",
    "ARM" to "아르헨티나 페소 (18810–1970)",
    "ARP" to "아르헨티나 페소 (1983–1985)",
    "ARS" to "아르헨티나 페소",
    "ATS" to "호주 실링",
    "AUD" to "호주 달러",
    "AWG" to "아루바 플로린",
    "AZM" to "아제르바이젠 마나트(1993–2006)",
    "AZN" to "아제르바이잔 마나트",
    "BAD" to "보스니아-헤르체고비나 디나르",
    "BAM" to "보스니아-헤르체고비나 태환 마르크",
    "BAN" to "보스니아-헤르체고비나 신디나르 (1994–1997)",
    "BBD" to "바베이도스 달러",
    "BDT" to "방글라데시 타카",
    "BEC" to "벨기에 프랑 (태환)",
    "BEF" to "벨기에 프랑",
    "BEL" to "벨기에 프랑 (금융)",
    "BGL" to "불가리아 동전 렛",
    "BGM" to "불가리아 사회주의자 렛",
    "BGN" to "불가리아 레프",
    "BGO" to "불가리아 렛 (1879–1952)",
    "BHD" to "바레인 디나르",
    "BIF" to "부룬디 프랑",
    "BMD" to "버뮤다 달러",
    "BND" to "부루나이 달러",
    "BOB" to "볼리비아 볼리비아노",
    "BOL" to "볼리비아 볼리비아노 (1863–1963)",
    "BOP" to "볼리비아노 페소",
    "BOV" to "볼리비아노 Mvdol(기금)",
    "BRB" to "볼리비아노 크루제이루 노보 (1967–1986)",
    "BRC" to "브라질 크루자두",
    "BRE" to "브라질 크루제이루 (1990–1993)",
    "BRL" to "브라질 레알",
    "BRN" to "브라질 크루자두 노보",
    "BRR" to "브라질 크루제이루",
    "BRZ" to "브라질 크루제이루 (1942–1967)",
    "BSD" to "바하마 달러",
    "BTN" to "부탄 눌투눔",
    "BUK" to "버마 차트",
    "BWP" to "보츠와나 풀라",
    "BYB" to "벨라루스 신권 루블 (1994–1999)",
    "BYN" to "벨라루스 루블",
    "BYR" to "벨라루스 루블 (2000–2016)",
    "BZD" to "벨리즈 달러",
    "CAD" to "캐나다 달러",
    "CDF" to "콩고 프랑",
    "CHE" to "유로 (WIR)",
    "CHF" to "스위스 프랑",
    "CHW" to "프랑 (WIR)",
    "CLE" to "칠레 에스쿠도",
    "CLF" to "칠레 (UF)",
    "CLP" to "칠레 페소",
    "CNH" to "중국 위안화(역외)",
    "CNY" to "중국 위안화",
    "COP" to "콜롬비아 페소",
    "COU" to "콜롬비아 실가 단위",
    "CRC" to "코스타리카 콜론",
    "CSD" to "고 세르비아 디나르",
    "CSK" to "체코슬로바키아 동전 코루나",
    "CUC" to "쿠바 태환 페소",
    "CUP" to "쿠바 페소",
    "CVE" to "카보베르데 에스쿠도",
    "CYP" to "싸이프러스 파운드",
    "CZK" to "체코 코루나",
    "DDM" to "동독 오스트마르크",
    "DEM" to "독일 마르크",
    "DJF" to "지부티 프랑",
    "DKK" to "덴마크 크로네",
    "DOP" to "도미니카 페소",
    "DZD" to "알제리 디나르",
    "ECS" to "에쿠아도르 수크레",
    "ECV" to "에콰도르 (UVC)",
    "EEK" to "에스토니아 크룬",
    "EGP" to "이집트 파운드",
    "ERN" to "에리트리아 나크파",
    "ESA" to "스페인 페세타(예금)",
    "ESB" to "스페인 페세타(변환 예금)",
    "ESP" to "스페인 페세타",
    "ETB" to "에티오피아 비르",
    "EUR" to "유로",
    "FIM" to "핀란드 마르카",
    "FJD" to "피지 달러",
    "FKP" to "포클랜드제도 파운드",
    "FRF" to "프랑스 프랑",
    "GBP" to "영국 파운드",
    "GEK" to "그루지야 지폐 라리트",
    "GEL" to "조지아 라리",
    "GHC" to "가나 시디 (1979–2007)",
    "GHS" to "가나 세디",
    "GIP" to "지브롤터 파운드",
    "GMD" to "감비아 달라시",
    "GNF" to "기니 프랑",
    "GNS" to "기니 시리",
    "GQE" to "적도 기니 에쿨 (Ekwele)",
    "GRD" to "그리스 드라크마",
    "GTQ" to "과테말라 케트살",
    "GWE" to "포르투갈령 기니 에스쿠도",
    "GWP" to "기네비쏘 페소",
    "GYD" to "가이아나 달러",
    "HKD" to "홍콩 달러",
    "HNL" to "온두라스 렘피라",
    "HRD" to "크로아티아 디나르",
    "HRK" to "크로아티아 쿠나",
    "HTG" to "아이티 구르드",
    "HUF" to "헝가리 포린트",
    "IDR" to "인도네시아 루피아",
    "IEP" to "아일랜드 파운드",
    "ILP" to "이스라엘 파운드",
    "ILS" to "이스라엘 신권 세켈",
    "INR" to "인도 루피",
    "IQD" to "이라크 디나르",
    "IRR" to "이란 리얄",
    "ISK" to "아이슬란드 크로나",
    "ITL" to "이탈리아 리라",
    "JMD" to "자메이카 달러",
    "JOD" to "요르단 디나르",
    "JPY" to "일본 엔화",
    "KES" to "케냐 실링",
    "KGS" to "키르기스스탄 솜",
    "KHR" to "캄보디아 리엘",
    "KMF" to "코모르 프랑",
    "KPW" to "조선 민주주의 인민 공화국 원",
    "KRH" to "대한민국 환 (1953–1962)",
    "KRW" to "대한민국 원",
    "KWD" to "쿠웨이트 디나르",
    "KYD" to "케이맨 제도 달러",
    "KZT" to "카자흐스탄 텡게",
    "LAK" to "라오스 키프",
    "LBP" to "레바논 파운드",
    "LKR" to "스리랑카 루피",
    "LRD" to "라이베리아 달러",
    "LSL" to "레소토 로티",
    "LTL" to "리투아니아 리타",
    "LTT" to "룩셈부르크 타로나",
    "LUC" to "룩셈부르크 변환 프랑",
    "LUF" to "룩셈부르크 프랑",
    "LUL" to "룩셈부르크 재정 프랑",
    "LVL" to "라트비아 라트",
    "LVR" to "라트비아 루블",
    "LYD" to "리비아 디나르",
    "MAD" to "모로코 디르함",
    "MAF" to "모로코 프랑",
    "MCF" to "모나코 프랑",
    "MDC" to "몰도바 쿠폰",
    "MDL" to "몰도바 레이",
    "MGA" to "마다가스카르 아리아리",
    "MGF" to "마다가스카르 프랑",
    "MKD" to "마케도니아 디나르",
    "MLF" to "말리 프랑",
    "MMK" to "미얀마 키얏",
    "MNT" to "몽골 투그릭",
    "MOP" to "마카오 파타카",
    "MRO" to "모리타니 우기야 (1973–2017)",
    "MRU" to "모리타니 우기야",
    "MTL" to "몰타 리라",
    "MTP" to "몰타 파운드",
    "MUR" to "모리셔스 루피",
    "MVR" to "몰디브 제도 루피아",
    "MWK" to "말라위 콰차",
    "MXN" to "멕시코 페소",
    "MXP" to "멕시코 실버 페소 (1861–1992)",
    "MXV" to "멕시코 (UDI)",
    "MYR" to "말레이시아 링깃",
    "MZE" to "모잠비크 에스쿠도",
    "MZM" to "고 모잠비크 메티칼",
    "MZN" to "모잠비크 메티칼",
    "NAD" to "나미비아 달러",
    "NGN" to "나이지리아 나이라",
    "NIC" to "니카라과 코르도바(1988~1991)",
    "NIO" to "니카라과 코르도바",
    "NLG" to "네델란드 길더",
    "NOK" to "노르웨이 크로네",
    "NPR" to "네팔 루피",
    "NZD" to "뉴질랜드 달러",
    "OMR" to "오만 리알",
    "PAB" to "파나마 발보아",
    "PEI" to "페루 인티",
    "PEN" to "페루 솔",
    "PES" to "페루 솔 (1863–1965)",
    "PGK" to "파푸아뉴기니 키나",
    "PHP" to "필리핀 페소",
    "PKR" to "파키스탄 루피",
    "PLN" to "폴란드 즈워티",
    "PLZ" to "폴란드 즐로티 (1950–1995)",
    "PTE" to "포르투갈 에스쿠도",
    "PYG" to "파라과이 과라니",
    "QAR" to "카타르 리얄",
    "RHD" to "로디지아 달러",
    "ROL" to "루마니아 레이",
    "RON" to "루마니아 레우",
    "RSD" to "세르비아 디나르",
    "RUB" to "러시아 루블",
    "RUR" to "러시아 루블 (1991–1998)",
    "RWF" to "르완다 프랑",
    "SAR" to "사우디아라비아 리얄",
    "SBD" to "솔로몬 제도 달러",
    "SCR" to "세이셸 루피",
    "SDD" to "수단 디나르",
    "SDG" to "수단 파운드",
    "SDP" to "고 수단 파운드",
    "SEK" to "스웨덴 크로나",
    "SGD" to "싱가포르 달러",
    "SHP" to "세인트헬레나 파운드",
    "SIT" to "슬로베니아 톨라르",
    "SKK" to "슬로바키아 코루나",
    "SLE" to "시에라리온 리온",
    "SLL" to "시에라리온 리온(1964~2022)",
    "SOS" to "소말리아 실링",
    "SRD" to "수리남 달러",
    "SRG" to "수리남 길더",
    "SSP" to "남수단 파운드",
    "STD" to "상투메 프린시페 도브라 (1977–2017)",
    "STN" to "상투메 프린시페 도브라",
    "SUR" to "소련 루블",
    "SVC" to "엘살바도르 콜론",
    "SYP" to "시리아 파운드",
    "SZL" to "스와질란드 릴랑게니",
    "THB" to "태국 바트",
    "TJR" to "타지키스탄 루블",
    "TJS" to "타지키스탄 소모니",
    "TMM" to "투르크메니스탄 마나트 (1993–2009)",
    "TMT" to "투르크메니스탄 마나트",
    "TND" to "튀니지 디나르",
    "TOP" to "통가 파앙가",
    "TPE" to "티모르 에스쿠도",
    "TRL" to "터키 리라(1922~2005)",
    "TRY" to "튀르키예 리라",
    "TTD" to "트리니다드 토바고 달러",
    "TWD" to "신 타이완 달러",
    "TZS" to "탄자니아 실링",
    "UAH" to "우크라이나 그리브나",
    "UAK" to "우크라이나 카보바네츠",
    "UGS" to "우간다 실링 (1966–1987)",
    "UGX" to "우간다 실링",
    "USD" to "미국 달러",
    "USN" to "미국 달러(다음날)",
    "USS" to "미국 달러(당일)",
    "UYI" to "우루과이 페소 (UI)",
    "UYP" to "우루과이 페소 (1975–1993)",
    "UYU" to "우루과이 페소",
    "UZS" to "우즈베키스탄 숨",
    "VEB" to "베네주엘라 볼리바르 (1871–2008)",
    "VEF" to "베네수엘라 볼리바르 (2008–2018)",
    "VES" to "베네수엘라 볼리바르",
    "VND" to "베트남 동",
    "VNN" to "베트남 동 (1978–1985)",
    "VUV" to "바누아투 바투",
    "WST" to "서 사모아 탈라",
    "XAF" to "중앙아프리카 CFA 프랑",
    "XAG" to "은화",
    "XAU" to "금",
    "XBA" to "유르코 (유럽 회계 단위)",
    "XBB" to "유럽 통화 동맹",
    "XBC" to "유럽 계산 단위 (XBC)",
    "XBD" to "유럽 계산 단위 (XBD)",
    "XCD" to "동카리브 달러",
    "XDR" to "특별인출권",
    "XEU" to "유럽 환율 단위",
    "XFO" to "프랑스 프랑 (Gold)",
    "XFU" to "프랑스 프랑 (UIC)",
    "XOF" to "서아프리카 CFA 프랑",
    "XPD" to "팔라듐",
    "XPF" to "CFP 프랑",
    "XPT" to "백금",
    "XRE" to "RINET 기금",
    "XTS" to "테스트 통화 코드",
    "XXX" to "알 수 없는 통화 단위",
    "YDD" to "예멘 디나르",
    "YER" to "예멘 리알",
    "YUD" to "유고슬라비아 동전 디나르",
    "YUM" to "유고슬라비아 노비 디나르",
    "YUN" to "유고슬라비아 전환 디나르",
    "ZAL" to "남아프리카 랜드 (금융)",
    "ZAR" to "남아프리카 랜드",
    "ZMK" to "쟘비아 콰쳐 (1968–2012)",
    "ZMW" to "잠비아 콰차",
    "ZRN" to "자이르 신권 자이르",
    "ZRZ" to "자이르 자이르",
    "ZWD" to "짐바브웨 달러",
    "ZWL" to "짐바브웨 달러 (2009)",
    "ZWR" to "짐바브웨 달러 (2008)",
  ) }

  val ko_CN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ko_KP: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kok: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "युनाइटेड अरब इमीरॅट्स दिरहम",
    "AFN" to "अफगाण अफगाणी",
    "ALL" to "अल्बेनियन लेक",
    "AMD" to "अर्मेनियन ड्राम",
    "ANG" to "नॅदरलँड अँटिलियन गिल्डर",
    "AOA" to "अंगोलन क्वॉन्ज",
    "ARS" to "अर्जेंटिना पेसो",
    "AUD" to "ऑस्ट्रेलियाई डॉलर",
    "AWG" to "अरुबान फ्लोरिन",
    "AZN" to "अज़रबैजानी मनात",
    "BAM" to "बोस्निया-हेर्जेगोविना रुपांतरीत मार्क",
    "BBD" to "बार्बाडियान डॉलर",
    "BDT" to "बांगलादेशी टाका",
    "BGN" to "बल्गेरियन लेव",
    "BHD" to "बहरिनी डिनार",
    "BIF" to "बुरुंडी फ्रँक",
    "BMD" to "बरमुदान डॉलर",
    "BND" to "ब्रूनेई डॉलर",
    "BOB" to "बोलिव्हियन बोलिवियानो",
    "BRL" to "ब्राझिलियन रियाल",
    "BSD" to "बहामियन डॉलर",
    "BTN" to "भुतानीज नागल्ट्रम",
    "BWP" to "बोत्सवाना पुला",
    "BYN" to "बैलोरुसियन् रूबल",
    "BZD" to "बेलिझ डॉलर",
    "CAD" to "कॅनाडियन डॉलर",
    "CDF" to "काँगोलिसी फ्रँक",
    "CHF" to "स्विस फ्रँक",
    "CLP" to "चिली पेसो",
    "CNH" to "चिनी युआन (ऑफशोर)",
    "CNY" to "चिनी युआन",
    "COP" to "कोलंबियन पेसो",
    "CRC" to "कोस्ता रिका कॉलॉन",
    "CUC" to "क्युबान रुपांतरीत पेसो",
    "CUP" to "क्युबान पेसो",
    "CVE" to "केप वर्दे एस्कुडो",
    "CZK" to "चेक कोरुना",
    "DJF" to "जिबूती फ्रँक",
    "DKK" to "डॅनिश क्रोन",
    "DOP" to "डोमिनिकन पेसो",
    "DZD" to "अल्जेरियाई डिनार",
    "EGP" to "ईजिप्ती पावंड",
    "ERN" to "इरिट्रियन नाक्फा",
    "ETB" to "इथियोपियाई बिरर",
    "EUR" to "युरो",
    "FJD" to "फिजी डॉलर",
    "FKP" to "फ़ॉकलैंड आइलैंड्स पावंड",
    "GBP" to "ब्रिटिश पावंड",
    "GEL" to "जॉर्जियन लारी",
    "GHS" to "घानाई सेडी",
    "GIP" to "जिब्राल्टर पावंड",
    "GMD" to "गॅम्बियन दलासी",
    "GNF" to "गिनीन फ्रँक",
    "GTQ" to "ग्वाटेमाला कुएट्झल",
    "GYD" to "गयाना डॉलर",
    "HKD" to "हाँग काँग डॉलर",
    "HNL" to "होंडुरान लेम्पिरा",
    "HRK" to "क्रोयेषियन् कुना",
    "HTG" to "हैतीयन गौर्डे",
    "HUF" to "हंगेरियन फोरिंट",
    "IDR" to "इंडोनेशियन रुपिया",
    "ILS" to "इस्त्रायली न्यु शेकेल",
    "INR" to "भारतीय रुपया",
    "IQD" to "इराकी डिनार",
    "IRR" to "ईरानी रियाल",
    "ISK" to "आईस्लान्डिक क्रोना",
    "JMD" to "जमैकन डॉलर",
    "JOD" to "जॉर्डनियन डिनार",
    "JPY" to "जपानी येन",
    "KES" to "केनयाई शिलिंग",
    "KGS" to "किरगिझस्तान सोम",
    "KHR" to "कंबोडियन रियाल",
    "KMF" to "कोमोरियन फ्रँक",
    "KPW" to "उत्तर कोरियन वॉन",
    "KRW" to "दक्षिण कोरियन वॉन",
    "KWD" to "कुवेती डिनार",
    "KYD" to "कैमेन आइलैंड्स डॉलर",
    "KZT" to "कझाकस्तानी टेंग",
    "LAK" to "लाओ किप",
    "LBP" to "लिबानेस पावंड",
    "LKR" to "श्री लंका रुपया",
    "LRD" to "लायबेरियन डॉलर",
    "LSL" to "लिसोथो लोटि",
    "LYD" to "लीबियान डिनार",
    "MAD" to "मोरक्कन दिरहम",
    "MDL" to "मोल्दोवान लियू",
    "MGA" to "मलागासी एरियारी",
    "MKD" to "मसीडोनियन् डिनर",
    "MMK" to "म्यानमार क्यात",
    "MNT" to "मंगोलियन तुगरिक",
    "MOP" to "मकानेसे पटका",
    "MRU" to "मॉरिटानिया उगिया",
    "MUR" to "मॉरिशस रुपी",
    "MVR" to "मालदिवी रुफिया",
    "MWK" to "मलावियन क्वाचा",
    "MXN" to "मेक्सिकन पेसो",
    "MYR" to "मलेशियाई रिंग्गित",
    "MZN" to "मोझांबिकन मेटिकल",
    "NAD" to "नामीबिया डॉलर",
    "NGN" to "नायजेरियन नायरा",
    "NIO" to "निकारागुआन कॉर्डोबा",
    "NOK" to "नॉर्वेगन क्रोन",
    "NPR" to "नेपाळी रुपया",
    "NZD" to "न्युझीलॅन्ड डॉलर",
    "OMR" to "ओमानी रियाल",
    "PAB" to "पानामानियन बाल्बोआ",
    "PEN" to "पेरिवियन सोल",
    "PGK" to "पापुआ न्यु गिनी किना",
    "PHP" to "फिलिपिनी पेसो",
    "PKR" to "पाकिस्तानी रुपया",
    "PLN" to "पोलिष झ्लोटी",
    "PYG" to "पराग्वेन गौरानी",
    "QAR" to "कतारी रियाल",
    "RON" to "रोमानियन् लियू",
    "RSD" to "सर्बियन डिनार",
    "RUB" to "रुसी रुबल",
    "RWF" to "रवांडा फ्रँक",
    "SAR" to "सौदी रियाल",
    "SBD" to "सोलोमन आयलँड्स डॉलर",
    "SCR" to "सेशेल्लोइस रुपी",
    "SDG" to "सुदानी पावंड",
    "SEK" to "स्वीदीष क्रोन",
    "SGD" to "सिंगापूरी डॉलर",
    "SHP" to "सेंट हेलिना पावंड",
    "SLE" to "सिएरा लियॉनी लियॉन",
    "SLL" to "सिएरा लियॉनी लियॉन (1964—2022)",
    "SOS" to "सोमाली शिलिंग",
    "SRD" to "सुरीनामी डॉलर",
    "SSP" to "दक्षिण सुडानी पावंड",
    "STN" to "साओ टोम आनी प्रिन्सिप डोब्रा",
    "SYP" to "सिरियन पावंड",
    "SZL" to "स्वाजी लिलांगेनी",
    "THB" to "थाई बाट",
    "TJS" to "ताजिकिस्तानी सोमोनी",
    "TMT" to "तुर्कमेनिस्तानी मनत",
    "TND" to "ट्यूनीशियन डिनार",
    "TOP" to "टोंगन पांगा",
    "TRY" to "तुर्किश लायरा",
    "TTD" to "ट्रिनीडाड आनी टोबॅगो डॉलर",
    "TWD" to "न्यू तायवान डॉलर",
    "TZS" to "तंजानिया शिलिंग",
    "UAH" to "युक्रेनियन् रिव्निया",
    "UGX" to "युगांडा शिलिंग",
    "USD" to "युएस डॉलर",
    "UYU" to "उरुग्वेन पेसो",
    "UZS" to "उज़्बेकिस्तानी सोम",
    "VES" to "विनेझुएला बोलिव्हर",
    "VND" to "वियतनामी डोंग",
    "VUV" to "वानूआतू वातू",
    "WST" to "समोआई टाला",
    "XAF" to "मध्य अफ्रीकी सीएफए फ्रँक",
    "XCD" to "उदेंत कॅरिबियन डॉलर",
    "XOF" to "अस्तंत आफ्रिकी सीएफए फ्रँक",
    "XPF" to "सीएफपी फ्रँक",
    "XXX" to "अज्ञात चलन",
    "YER" to "येमेनी रियाल",
    "ZAR" to "दक्षिण आफ्रिकन रँड",
    "ZMW" to "झांबियन क्वाचा",
  ) }

  val kok_Deva: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "युनाइटेड अरब इमीरॅट्स दिरहम",
    "AFN" to "अफगाण अफगाणी",
    "ALL" to "अल्बेनियन लेक",
    "AMD" to "अर्मेनियन ड्राम",
    "ANG" to "नॅदरलँड अँटिलियन गिल्डर",
    "AOA" to "अंगोलन क्वॉन्ज",
    "ARS" to "अर्जेंटिना पेसो",
    "AUD" to "ऑस्ट्रेलियाई डॉलर",
    "AWG" to "अरुबान फ्लोरिन",
    "AZN" to "अज़रबैजानी मनात",
    "BAM" to "बोस्निया-हेर्जेगोविना रुपांतरीत मार्क",
    "BBD" to "बार्बाडियान डॉलर",
    "BDT" to "बांगलादेशी टाका",
    "BGN" to "बल्गेरियन लेव",
    "BHD" to "बहरिनी डिनार",
    "BIF" to "बुरुंडी फ्रँक",
    "BMD" to "बरमुदान डॉलर",
    "BND" to "ब्रूनेई डॉलर",
    "BOB" to "बोलिव्हियन बोलिवियानो",
    "BRL" to "ब्राझिलियन रियाल",
    "BSD" to "बहामियन डॉलर",
    "BTN" to "भुतानीज नागल्ट्रम",
    "BWP" to "बोत्सवाना पुला",
    "BYN" to "बैलोरुसियन् रूबल",
    "BZD" to "बेलिझ डॉलर",
    "CAD" to "कॅनाडियन डॉलर",
    "CDF" to "काँगोलिसी फ्रँक",
    "CHF" to "स्विस फ्रँक",
    "CLP" to "चिली पेसो",
    "CNH" to "चिनी युआन (ऑफशोर)",
    "CNY" to "चिनी युआन",
    "COP" to "कोलंबियन पेसो",
    "CRC" to "कोस्ता रिका कॉलॉन",
    "CUC" to "क्युबान रुपांतरीत पेसो",
    "CUP" to "क्युबान पेसो",
    "CVE" to "केप वर्दे एस्कुडो",
    "CZK" to "चेक कोरुना",
    "DJF" to "जिबूती फ्रँक",
    "DKK" to "डॅनिश क्रोन",
    "DOP" to "डोमिनिकन पेसो",
    "DZD" to "अल्जेरियाई डिनार",
    "EGP" to "ईजिप्ती पावंड",
    "ERN" to "इरिट्रियन नाक्फा",
    "ETB" to "इथियोपियाई बिरर",
    "EUR" to "युरो",
    "FJD" to "फिजी डॉलर",
    "FKP" to "फ़ॉकलैंड आइलैंड्स पावंड",
    "GBP" to "ब्रिटिश पावंड",
    "GEL" to "जॉर्जियन लारी",
    "GHS" to "घानाई सेडी",
    "GIP" to "जिब्राल्टर पावंड",
    "GMD" to "गॅम्बियन दलासी",
    "GNF" to "गिनीन फ्रँक",
    "GTQ" to "ग्वाटेमाला कुएट्झल",
    "GYD" to "गयाना डॉलर",
    "HKD" to "हाँग काँग डॉलर",
    "HNL" to "होंडुरान लेम्पिरा",
    "HRK" to "क्रोयेषियन् कुना",
    "HTG" to "हैतीयन गौर्डे",
    "HUF" to "हंगेरियन फोरिंट",
    "IDR" to "इंडोनेशियन रुपिया",
    "ILS" to "इस्त्रायली न्यु शेकेल",
    "INR" to "भारतीय रुपया",
    "IQD" to "इराकी डिनार",
    "IRR" to "ईरानी रियाल",
    "ISK" to "आईस्लान्डिक क्रोना",
    "JMD" to "जमैकन डॉलर",
    "JOD" to "जॉर्डनियन डिनार",
    "JPY" to "जपानी येन",
    "KES" to "केनयाई शिलिंग",
    "KGS" to "किरगिझस्तान सोम",
    "KHR" to "कंबोडियन रियाल",
    "KMF" to "कोमोरियन फ्रँक",
    "KPW" to "उत्तर कोरियन वॉन",
    "KRW" to "दक्षिण कोरियन वॉन",
    "KWD" to "कुवेती डिनार",
    "KYD" to "कैमेन आइलैंड्स डॉलर",
    "KZT" to "कझाकस्तानी टेंग",
    "LAK" to "लाओ किप",
    "LBP" to "लिबानेस पावंड",
    "LKR" to "श्री लंका रुपया",
    "LRD" to "लायबेरियन डॉलर",
    "LSL" to "लिसोथो लोटि",
    "LYD" to "लीबियान डिनार",
    "MAD" to "मोरक्कन दिरहम",
    "MDL" to "मोल्दोवान लियू",
    "MGA" to "मलागासी एरियारी",
    "MKD" to "मसीडोनियन् डिनर",
    "MMK" to "म्यानमार क्यात",
    "MNT" to "मंगोलियन तुगरिक",
    "MOP" to "मकानेसे पटका",
    "MRU" to "मॉरिटानिया उगिया",
    "MUR" to "मॉरिशस रुपी",
    "MVR" to "मालदिवी रुफिया",
    "MWK" to "मलावियन क्वाचा",
    "MXN" to "मेक्सिकन पेसो",
    "MYR" to "मलेशियाई रिंग्गित",
    "MZN" to "मोझांबिकन मेटिकल",
    "NAD" to "नामीबिया डॉलर",
    "NGN" to "नायजेरियन नायरा",
    "NIO" to "निकारागुआन कॉर्डोबा",
    "NOK" to "नॉर्वेगन क्रोन",
    "NPR" to "नेपाळी रुपया",
    "NZD" to "न्युझीलॅन्ड डॉलर",
    "OMR" to "ओमानी रियाल",
    "PAB" to "पानामानियन बाल्बोआ",
    "PEN" to "पेरिवियन सोल",
    "PGK" to "पापुआ न्यु गिनी किना",
    "PHP" to "फिलिपिनी पेसो",
    "PKR" to "पाकिस्तानी रुपया",
    "PLN" to "पोलिष झ्लोटी",
    "PYG" to "पराग्वेन गौरानी",
    "QAR" to "कतारी रियाल",
    "RON" to "रोमानियन् लियू",
    "RSD" to "सर्बियन डिनार",
    "RUB" to "रुसी रुबल",
    "RWF" to "रवांडा फ्रँक",
    "SAR" to "सौदी रियाल",
    "SBD" to "सोलोमन आयलँड्स डॉलर",
    "SCR" to "सेशेल्लोइस रुपी",
    "SDG" to "सुदानी पावंड",
    "SEK" to "स्वीदीष क्रोन",
    "SGD" to "सिंगापूरी डॉलर",
    "SHP" to "सेंट हेलिना पावंड",
    "SLE" to "सिएरा लियॉनी लियॉन",
    "SLL" to "सिएरा लियॉनी लियॉन (1964—2022)",
    "SOS" to "सोमाली शिलिंग",
    "SRD" to "सुरीनामी डॉलर",
    "SSP" to "दक्षिण सुडानी पावंड",
    "STN" to "साओ टोम आनी प्रिन्सिप डोब्रा",
    "SYP" to "सिरियन पावंड",
    "SZL" to "स्वाजी लिलांगेनी",
    "THB" to "थाई बाट",
    "TJS" to "ताजिकिस्तानी सोमोनी",
    "TMT" to "तुर्कमेनिस्तानी मनत",
    "TND" to "ट्यूनीशियन डिनार",
    "TOP" to "टोंगन पांगा",
    "TRY" to "तुर्किश लायरा",
    "TTD" to "ट्रिनीडाड आनी टोबॅगो डॉलर",
    "TWD" to "न्यू तायवान डॉलर",
    "TZS" to "तंजानिया शिलिंग",
    "UAH" to "युक्रेनियन् रिव्निया",
    "UGX" to "युगांडा शिलिंग",
    "USD" to "युएस डॉलर",
    "UYU" to "उरुग्वेन पेसो",
    "UZS" to "उज़्बेकिस्तानी सोम",
    "VES" to "विनेझुएला बोलिव्हर",
    "VND" to "वियतनामी डोंग",
    "VUV" to "वानूआतू वातू",
    "WST" to "समोआई टाला",
    "XAF" to "मध्य अफ्रीकी सीएफए फ्रँक",
    "XCD" to "उदेंत कॅरिबियन डॉलर",
    "XOF" to "अस्तंत आफ्रिकी सीएफए फ्रँक",
    "XPF" to "सीएफपी फ्रँक",
    "XXX" to "अज्ञात चलन",
    "YER" to "येमेनी रियाल",
    "ZAR" to "दक्षिण आफ्रिकन रँड",
    "ZMW" to "झांबियन क्वाचा",
  ) }

  val kok_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kpe: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kpe_GN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ks: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "اؠڑورَن پیسِٹا",
    "AED" to "مُتحدہ عرب اِمارات دِرہم",
    "AFN" to "افغان افغٲنی",
    "ALL" to "اؠلبینِیَن لِک",
    "AMD" to "اَرمانؠن ڈرؠم",
    "ANG" to "نایدَرلینڑ اؠنٹٕلیٖیَن گِلڑَر",
    "AOA" to "اؠنگولَن کوانزا",
    "AOR" to "اؠنگولَن کوانزا رؠجِسٹاڑو",
    "ARA" to "أرجَنٹیٖن اَسٹرل",
    "ARS" to "أرجَنٹیٖن پِسو",
    "ATS" to "آسٹریَن شِلِنگ",
    "AUD" to "آسٹریلِیَن ڈالَر",
    "AWG" to "اَروبَن فِلورِن",
    "AZN" to "آزَرباجانی مَنَٹ",
    "BAD" to "بوزنِیاہَرزِگووِنا دیٖنار",
    "BAM" to "بوزنِیاہَرزِگووِنا کَنوٲٹیبٕل مارٕک",
    "BBD" to "بابیڑِیَن ڈالَر",
    "BDT" to "بَنگلادیٖشی ٹَکا",
    "BEF" to "بَلجِیَن فرینک",
    "BGN" to "بیلگیرِیَن ہاڑ لِو",
    "BHD" to "بحریٖنی دیٖنار",
    "BIF" to "بُرُنڑِین فرینک",
    "BMD" to "بٔرمیوٗڑَن ڈالَر",
    "BND" to "برونی ڈالَر",
    "BOB" to "بولِوِیَن بولوینو",
    "BOP" to "بولویَن پِسو",
    "BOV" to "بولوِیَن مَوڈال",
    "BRB" to "برازیٖلین کروزِرو نووو",
    "BRC" to "برازیٖلین کروزیڑو",
    "BRE" to "برازیٖلین کروزِرو",
    "BRL" to "برازیٖلی رِیَل",
    "BRN" to "برازیٖلین کروزیڑو نووو",
    "BRR" to "برازیٖلین کروزیرو",
    "BSD" to "بہامِیَن ڈالر",
    "BTN" to "بوٗٹینیٖز نگُلٹرم",
    "BUK" to "بٔرمیٖز کیٹ",
    "BWP" to "بوٹٕسوانَن پُلا",
    "BYB" to "بِلیروشِیَن نِو رِبٕل",
    "BYN" to "بِلیروشِیَن رِبٕل",
    "BYR" to "بِلیروشِیَن رِبٕل (۲۰۰۰–۲۰۱۶)",
    "BZD" to "بِلِزی ڈالر",
    "CAD" to "کینَڑِیَن ڈالر",
    "CDF" to "کونگولیٖز فریک",
    "CHE" to "وِر یوٗرو",
    "CHF" to "سُوِز فریک",
    "CHW" to "وِر فریک",
    "CLF" to "چِلِن یوٗنِڑیدیٖز ڑِ فومیٹو",
    "CLP" to "چِلِن پِسو",
    "CNY" to "چیٖنی یُوان",
    "COP" to "کولَمبِین پِسو",
    "COU" to "ِٖیوٗنِڑیڑ ڑِ ویلور رِیل",
    "CRC" to "کوسٹا رِکَن کولَن",
    "CSD" to "پرون سٔربِین ڈالر",
    "CSK" to "چِکوسولوواک ہاڑ کوروٗنا",
    "CUP" to "کیوٗبَن پِسو",
    "CYP" to "کیپروٹ پَوُڑ",
    "CZK" to "چیک کوریٖنا",
    "DDM" to "مٔشرِقی جٔرمَن مارٕک",
    "DEM" to "جٔرمَن مارٕک",
    "DKK" to "ڈٔنِش کرون",
    "DOP" to "ڈومِنِکَن پِسو",
    "DZD" to "اؠلجیرِیَن ڈیٖنار",
    "EEK" to "اؠسٹونِیَن کرون",
    "EGP" to "اِجِپٹِیَن پَوُنڑ",
    "ERN" to "رِٹریٖن نَفکا",
    "ESP" to "سِپینِش پیسِٹا",
    "ETB" to "اِتھوپِیَن بِر",
    "EUR" to "یوٗرو",
    "FIM" to "فِنِش مارکا",
    "FJD" to "فِجین ڈالر",
    "FKP" to "فیکلینڑِس آیلینڑ پونڑ",
    "FRF" to "فرانسِسی فریک",
    "GBP" to "برطٲنوی پوٗنڈ",
    "GEK" to "جارجِیَن کیوٗپَن لَرِٹ",
    "GEL" to "جارجِیَن لاری",
    "GHC" to "گَنییَن سؠڑی(۱۹۷۹–۲٠٠۷)",
    "GHS" to "گَنییَن سؠڑی",
    "GIP" to "گِبریلٹَر پَاونڑ",
    "GMD" to "گیمبِیاہُک دلاسی",
    "GNF" to "گِنِیَن فرینک",
    "GNS" to "گِنِیَن سِلی",
    "GQE" to "اِکویٹورِیَل گِنِیَن اؠکویٖل",
    "GRD" to "گریٖسُک ڑرؠکما",
    "GTQ" to "گواٹَمالَن قیوٗٹزَل",
    "GWE" to "پورتگیٖزُک گِنی اؠسکیوٗڑو",
    "GWP" to "گِنی بِساوُک پؠسو",
    "GYD" to "گَیَنیٖزُک ڑالَر",
    "HKD" to "حانگ کانگُک ڑالَر",
    "HNL" to "حونڑورنُک لؠمپیٖرا",
    "HRD" to "کروایشنُک دیٖنار",
    "HRK" to "کروایشنُک کوٗنا",
    "HTG" to "حیشَنُک گوڑ",
    "HUF" to "حَنگیرِیَن فورِنٹ",
    "IDR" to "اِنڑونیشیاہُک رُپِیاہ",
    "IEP" to "اَیرلینڑُک پاونڑ",
    "ILP" to "اِزرٲیِلی پاونڑ",
    "ILS" to "اِزرٲیِلی نٔوؠ شؠقٕل",
    "INR" to "ہِندُستٲنؠ رۄپَے",
    "IQD" to "ایٖراقُک دیٖنار",
    "IRR" to "ایٖرانُک رِیال",
    "ISK" to "اَیسلینڑُک کرونا",
    "ITL" to "اِٹلیٖ یُک لیٖرا",
    "JMD" to "جَمَیکاہُک ڑالَر",
    "JOD" to "جَرڑینیاہُک دیٖنار",
    "JPY" to "جاپانُک یَن",
    "KES" to "کؠنیَن شِلِنگ",
    "KGS" to "کِرگِستانُک سوم",
    "KHR" to "کَمبوڑِیاہُک رِیال",
    "KMF" to "کومورِیَن فرینک",
    "KPW" to "جنوٗبی کورِیَن وَن",
    "KRW" to "ساوتھ کورِیَن وَن",
    "KWD" to "قُویتُک دیٖنار",
    "KYD" to "کیمین ججیٖرُک ڑالَر",
    "KZT" to "کزاکِستان ٹینج",
    "LAK" to "لَوٹِیَن کِپ",
    "LBP" to "لیبنیٖزُک پاونڑ",
    "LKR" to "سری لَنکاہٕچ رۄپَے",
    "LRD" to "لَیبیرِیَن ڑالَر",
    "LSL" to "لِسوتھو لوٹی",
    "LTL" to "لِتھوینِیَن لِٹاس",
    "LTT" to "لِتھوینِیَن ٹؠلوناس",
    "LUC" to "لَکزٕمبورگِیَن کَنؤرٹِبٕل فرینک",
    "LUF" to "لَکزٕمبورگِیَن فرینک",
    "LUL" to "لَکزٕمبوگ فَینانشَل فرینک",
    "LVL" to "لَتوِیَن لیٹس",
    "LVR" to "لَتوِیَن رَبٕل",
    "LYD" to "لِبیَن دیٖنار",
    "MAD" to "موروکَن دِرہَم",
    "MAF" to "موروکَن فرینک",
    "MDL" to "مولڑووین لیوٗ",
    "MGA" to "مؠلؠگیسی اؠریَری",
    "MGF" to "مؠلؠگیسی فرینک",
    "MKD" to "مؠکَڑونِیَن دیٖنار",
    "MLF" to "میلِیَن فرینک",
    "MMK" to "مِیانما کیاٹ",
    "MNT" to "مۄنگولِیَن ٹُگرِک",
    "MOP" to "مؠکانیٖز پَٹاکا",
    "MRO" to "مورِٹینِیَن عوگیوٗیا (1973–2017)",
    "MRU" to "مورِٹینِیَن عوگیوٗیا",
    "MTL" to "مالٹیٖزُک لیٖرا",
    "MTP" to "مالٹیٖزُک پاونڑ",
    "MUR" to "مورؠشِیاہٕچ رۄپَے",
    "MVR" to "مالدِیٖوِیَن رُفِیا",
    "MWK" to "مؠلیوِیَن کواچا",
    "MXN" to "مؠکسِکَن پؠسو",
    "MXP" to "مؠکسِکَن سِلوَر پؠسو (۱۸۶۱–۱۹۹۲)",
    "MYR" to "مَلیشِیَن رِنگِٹ",
    "MZE" to "موزیمبِکَن سکیوٗڑو",
    "MZM" to "پرون موزیمبِکَن مؠٹِکَل",
    "MZN" to "موزیمبِکَن مؠٹِکَل",
    "NAD" to "نامِبِیَن ڑالَر",
    "NGN" to "نَیجیرِیَن ڑالَر",
    "NIC" to "نِکؠراگُوؠن کورڑوبا",
    "NIO" to "نِکؠراگُوؠن کورڑوبا اورو",
    "NLG" to "ڈَچ گِلڑَر",
    "NOK" to "نوروییِنُک کرون",
    "NPR" to "نیپالٕچ رۄپَے",
    "NZD" to "نِوزیٖلینڑُک ڑالَر",
    "OMR" to "اومِنی رِیال",
    "PAB" to "پانامانِیَن بالبوز",
    "PEI" to "پٔریوٗوِیَن اِنٹی",
    "PEN" to "پٔریوٗوِیَن سولٕز",
    "PES" to "پٔریوٗوِیَن سول (۱۸۶۳–۱۹۶۵)",
    "PGK" to "نیوٗ پیپُعا گِنِیَن کیٖنا",
    "PHP" to "پھِلِپایِٔن پؠسو",
    "PKR" to "پاکِستٲنؠ رۄپَے",
    "PLN" to "پولِش زلوٹی",
    "PLZ" to "پولِش زلوٹی(۱۹۵٠–۱۹۹۵)",
    "PTE" to "پورتُگیٖز اؠسکیوٗڑو",
    "PYG" to "پؠرؠگیوٗوَیَن گُعارانی",
    "QAR" to "قطاری رِیال",
    "RHD" to "رھوڑیشِیَن ڑالَر",
    "ROL" to "اولڑ رومانِیَن لؠیوٗ",
    "RON" to "رومانِیَن لؠیوٗ",
    "RSD" to "سٔربِیَن دیٖنار",
    "RUB" to "روٗسی رَبٕل",
    "RUR" to "رٔشیَن رَبٕل(۱۹۹۱–۱۹۹۸)",
    "RWF" to "روانڑَن فرانک",
    "SAR" to "سودیٖیُک رِیال",
    "SBD" to "سولَمَن جٔزیٖرُک ڈالَر",
    "SDD" to "پرون سوٗڈانُک دیٖنار",
    "SDG" to "سوٗڈانُک پونڈ",
    "SDP" to "پرون سوٗڈانُک پونڈ",
    "SEK" to "سویٖڈِش کَرونا",
    "SGD" to "سِنگاپورُک ڈالَر",
    "SHP" to "سینٹ ہیلِنا پونڈ",
    "SIT" to "سلووینُک ٹولَر",
    "SKK" to "سلووَک کَرونا",
    "SOS" to "سومالی شِلِنگ",
    "SRD" to "سُریٖنامُک ڈالَر",
    "SRG" to "سُریٖنام گِلدَر",
    "SUR" to "سوویت روبٕل",
    "SVC" to "سَلویدَرُک کولَن",
    "SYP" to "سیٖریاہُک پونڈ",
    "SZL" to "سوازی لِلَنگینی",
    "THB" to "تھایھک بات",
    "TJR" to "تاجکِستانُک رَبٕل",
    "TJS" to "تاجِکتانُک سَمونی",
    "TMM" to "تُکَمَنِستانُک مَنَت",
    "TND" to "ٹُنیشیاہُک دیٖنار",
    "TOP" to "ٹونگَن پانگا",
    "TPE" to "ٹیموریسو ایکیٖڈو",
    "TRL" to "پرون تُرکِش لیرا",
    "TRY" to "تُرکیہُک لیرا",
    "TTD" to "ٹرِنہِ ڈیڈ تہٕ ٹوبیگو ڈالَر",
    "TWD" to "نۆو تیوانُک ڈالَر",
    "TZS" to "تَنزانیاہُک شِلِنگ",
    "UAH" to "یوٗکرینیاہُک ہرِوِنیا",
    "UAK" to "یوٗکرینیاہُک کاربووَنیٹس",
    "UGS" to "اُگاداہُک شِلِنگ(۱۹۶۶–۱۹۸۷)",
    "UGX" to "اُگاداہُک شِلِنگ",
    "USD" to "US ڈالر",
    "USN" to "یوٗ ایس ڈالَر(پَگاہ)",
    "USS" to "یوٗ ایس ڈالَر(تَمی دًۄہ)",
    "UYI" to "اُرگایَن پیسو یوٗنِڈیڈَس اِنڈیکسَس",
    "UYP" to "اُرگایَن پیسو(۱۹۷۵–۱۹۹۳)",
    "UYU" to "اُروٗگایَن پیسو",
    "UZS" to "اُبیکِستان سوم",
    "VEB" to "وینٕزوٗلیُک بولِوَر (۱۸۷۱–۲۰۰۸)",
    "VEF" to "وینٕزوٗلیُک بولِوَر (2008–2018)",
    "VES" to "وینٕزوٗلیُک بولِوَر",
    "VND" to "وِیَنَمُک ڈانگ",
    "VUV" to "وَنوٗاَتوٗ وَتوٗ",
    "WST" to "سَمون تَلا",
    "XAF" to "سی ایف اے فرینک بی ایٖ اے سی",
    "XAG" to "رۄپھ",
    "XAU" to "سۄن",
    "XBA" to "یوٗرپی کَمپوسِٹ یوٗنِٹ",
    "XBB" to "یوٗرپی مونِٹَری یوٗنِٹ",
    "XBC" to "یوٗرپی یوٗنِٹ آف ایکاوُنٹ (ایکس بی سی)",
    "XBD" to "یوٗرپی یوٗنِٹ آف ایکاوُنٹ (ایکس بی ڈی)",
    "XCD" to "مَشرِقی کیرِبِیَن ڈالَر",
    "XDR" to "خاص ڈرایِنگ رایٹس",
    "XEU" to "یوٗرپی کَرَنسی یوٗنِٹ",
    "XFO" to "فرینچ گولڈ فرینک",
    "XFU" to "فرینچ یوٗ اے سی فرینک",
    "XOF" to "سی ایف اے فرینک بی سی ایٖ اے او",
    "XPD" to "پُلیڈیَم",
    "XPF" to "سی ایف پی فرینک",
    "XPT" to "پلیٹِنَم",
    "XRE" to "آر آے این ایٖ ٹی فَنڈ",
    "XTS" to "ٹیسٹِنگ کَرَنسی کوڈ",
    "XXX" to "نامولوٗم کرنسی",
    "YDD" to "یَمنُک دیٖنار",
    "YER" to "یَمنُک رِیال",
    "YUD" to "یوگوسلاوِیَن ہاڑ دیٖنار",
    "YUM" to "یوگوسلاوِیَن نووِے دیٖنار",
    "YUN" to "یوگوسلاوِیَن کَنؤٹِبٕل دیٖنار",
    "ZAR" to "ساوُتھ افریٖکاہُک رینڈ",
    "ZMK" to "زِمبابیُک کواچا (1968–2012)",
    "ZMW" to "زِمبابیُک کواچا",
    "ZRN" to "زایرِیَن نِو زایِر",
    "ZRZ" to "زَیرُک ڈالَر",
    "ZWD" to "زِمبابِیُک ڈالَر",
  ) }

  val ks_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "اؠڑورَن پیسِٹا",
    "AED" to "مُتحدہ عرب اِمارات دِرہم",
    "AFN" to "افغان افغٲنی",
    "ALL" to "اؠلبینِیَن لِک",
    "AMD" to "اَرمانؠن ڈرؠم",
    "ANG" to "نایدَرلینڑ اؠنٹٕلیٖیَن گِلڑَر",
    "AOA" to "اؠنگولَن کوانزا",
    "AOR" to "اؠنگولَن کوانزا رؠجِسٹاڑو",
    "ARA" to "أرجَنٹیٖن اَسٹرل",
    "ARS" to "أرجَنٹیٖن پِسو",
    "ATS" to "آسٹریَن شِلِنگ",
    "AUD" to "آسٹریلِیَن ڈالَر",
    "AWG" to "اَروبَن فِلورِن",
    "AZN" to "آزَرباجانی مَنَٹ",
    "BAD" to "بوزنِیاہَرزِگووِنا دیٖنار",
    "BAM" to "بوزنِیاہَرزِگووِنا کَنوٲٹیبٕل مارٕک",
    "BBD" to "بابیڑِیَن ڈالَر",
    "BDT" to "بَنگلادیٖشی ٹَکا",
    "BEF" to "بَلجِیَن فرینک",
    "BGN" to "بیلگیرِیَن ہاڑ لِو",
    "BHD" to "بحریٖنی دیٖنار",
    "BIF" to "بُرُنڑِین فرینک",
    "BMD" to "بٔرمیوٗڑَن ڈالَر",
    "BND" to "برونی ڈالَر",
    "BOB" to "بولِوِیَن بولوینو",
    "BOP" to "بولویَن پِسو",
    "BOV" to "بولوِیَن مَوڈال",
    "BRB" to "برازیٖلین کروزِرو نووو",
    "BRC" to "برازیٖلین کروزیڑو",
    "BRE" to "برازیٖلین کروزِرو",
    "BRL" to "برازیٖلی رِیَل",
    "BRN" to "برازیٖلین کروزیڑو نووو",
    "BRR" to "برازیٖلین کروزیرو",
    "BSD" to "بہامِیَن ڈالر",
    "BTN" to "بوٗٹینیٖز نگُلٹرم",
    "BUK" to "بٔرمیٖز کیٹ",
    "BWP" to "بوٹٕسوانَن پُلا",
    "BYB" to "بِلیروشِیَن نِو رِبٕل",
    "BYN" to "بِلیروشِیَن رِبٕل",
    "BYR" to "بِلیروشِیَن رِبٕل (۲۰۰۰–۲۰۱۶)",
    "BZD" to "بِلِزی ڈالر",
    "CAD" to "کینَڑِیَن ڈالر",
    "CDF" to "کونگولیٖز فریک",
    "CHE" to "وِر یوٗرو",
    "CHF" to "سُوِز فریک",
    "CHW" to "وِر فریک",
    "CLF" to "چِلِن یوٗنِڑیدیٖز ڑِ فومیٹو",
    "CLP" to "چِلِن پِسو",
    "CNY" to "چیٖنی یُوان",
    "COP" to "کولَمبِین پِسو",
    "COU" to "ِٖیوٗنِڑیڑ ڑِ ویلور رِیل",
    "CRC" to "کوسٹا رِکَن کولَن",
    "CSD" to "پرون سٔربِین ڈالر",
    "CSK" to "چِکوسولوواک ہاڑ کوروٗنا",
    "CUP" to "کیوٗبَن پِسو",
    "CYP" to "کیپروٹ پَوُڑ",
    "CZK" to "چیک کوریٖنا",
    "DDM" to "مٔشرِقی جٔرمَن مارٕک",
    "DEM" to "جٔرمَن مارٕک",
    "DKK" to "ڈٔنِش کرون",
    "DOP" to "ڈومِنِکَن پِسو",
    "DZD" to "اؠلجیرِیَن ڈیٖنار",
    "EEK" to "اؠسٹونِیَن کرون",
    "EGP" to "اِجِپٹِیَن پَوُنڑ",
    "ERN" to "رِٹریٖن نَفکا",
    "ESP" to "سِپینِش پیسِٹا",
    "ETB" to "اِتھوپِیَن بِر",
    "EUR" to "یوٗرو",
    "FIM" to "فِنِش مارکا",
    "FJD" to "فِجین ڈالر",
    "FKP" to "فیکلینڑِس آیلینڑ پونڑ",
    "FRF" to "فرانسِسی فریک",
    "GBP" to "برطٲنوی پوٗنڈ",
    "GEK" to "جارجِیَن کیوٗپَن لَرِٹ",
    "GEL" to "جارجِیَن لاری",
    "GHC" to "گَنییَن سؠڑی(۱۹۷۹–۲٠٠۷)",
    "GHS" to "گَنییَن سؠڑی",
    "GIP" to "گِبریلٹَر پَاونڑ",
    "GMD" to "گیمبِیاہُک دلاسی",
    "GNF" to "گِنِیَن فرینک",
    "GNS" to "گِنِیَن سِلی",
    "GQE" to "اِکویٹورِیَل گِنِیَن اؠکویٖل",
    "GRD" to "گریٖسُک ڑرؠکما",
    "GTQ" to "گواٹَمالَن قیوٗٹزَل",
    "GWE" to "پورتگیٖزُک گِنی اؠسکیوٗڑو",
    "GWP" to "گِنی بِساوُک پؠسو",
    "GYD" to "گَیَنیٖزُک ڑالَر",
    "HKD" to "حانگ کانگُک ڑالَر",
    "HNL" to "حونڑورنُک لؠمپیٖرا",
    "HRD" to "کروایشنُک دیٖنار",
    "HRK" to "کروایشنُک کوٗنا",
    "HTG" to "حیشَنُک گوڑ",
    "HUF" to "حَنگیرِیَن فورِنٹ",
    "IDR" to "اِنڑونیشیاہُک رُپِیاہ",
    "IEP" to "اَیرلینڑُک پاونڑ",
    "ILP" to "اِزرٲیِلی پاونڑ",
    "ILS" to "اِزرٲیِلی نٔوؠ شؠقٕل",
    "INR" to "ہِندُستٲنؠ رۄپَے",
    "IQD" to "ایٖراقُک دیٖنار",
    "IRR" to "ایٖرانُک رِیال",
    "ISK" to "اَیسلینڑُک کرونا",
    "ITL" to "اِٹلیٖ یُک لیٖرا",
    "JMD" to "جَمَیکاہُک ڑالَر",
    "JOD" to "جَرڑینیاہُک دیٖنار",
    "JPY" to "جاپانُک یَن",
    "KES" to "کؠنیَن شِلِنگ",
    "KGS" to "کِرگِستانُک سوم",
    "KHR" to "کَمبوڑِیاہُک رِیال",
    "KMF" to "کومورِیَن فرینک",
    "KPW" to "جنوٗبی کورِیَن وَن",
    "KRW" to "ساوتھ کورِیَن وَن",
    "KWD" to "قُویتُک دیٖنار",
    "KYD" to "کیمین ججیٖرُک ڑالَر",
    "KZT" to "کزاکِستان ٹینج",
    "LAK" to "لَوٹِیَن کِپ",
    "LBP" to "لیبنیٖزُک پاونڑ",
    "LKR" to "سری لَنکاہٕچ رۄپَے",
    "LRD" to "لَیبیرِیَن ڑالَر",
    "LSL" to "لِسوتھو لوٹی",
    "LTL" to "لِتھوینِیَن لِٹاس",
    "LTT" to "لِتھوینِیَن ٹؠلوناس",
    "LUC" to "لَکزٕمبورگِیَن کَنؤرٹِبٕل فرینک",
    "LUF" to "لَکزٕمبورگِیَن فرینک",
    "LUL" to "لَکزٕمبوگ فَینانشَل فرینک",
    "LVL" to "لَتوِیَن لیٹس",
    "LVR" to "لَتوِیَن رَبٕل",
    "LYD" to "لِبیَن دیٖنار",
    "MAD" to "موروکَن دِرہَم",
    "MAF" to "موروکَن فرینک",
    "MDL" to "مولڑووین لیوٗ",
    "MGA" to "مؠلؠگیسی اؠریَری",
    "MGF" to "مؠلؠگیسی فرینک",
    "MKD" to "مؠکَڑونِیَن دیٖنار",
    "MLF" to "میلِیَن فرینک",
    "MMK" to "مِیانما کیاٹ",
    "MNT" to "مۄنگولِیَن ٹُگرِک",
    "MOP" to "مؠکانیٖز پَٹاکا",
    "MRO" to "مورِٹینِیَن عوگیوٗیا (1973–2017)",
    "MRU" to "مورِٹینِیَن عوگیوٗیا",
    "MTL" to "مالٹیٖزُک لیٖرا",
    "MTP" to "مالٹیٖزُک پاونڑ",
    "MUR" to "مورؠشِیاہٕچ رۄپَے",
    "MVR" to "مالدِیٖوِیَن رُفِیا",
    "MWK" to "مؠلیوِیَن کواچا",
    "MXN" to "مؠکسِکَن پؠسو",
    "MXP" to "مؠکسِکَن سِلوَر پؠسو (۱۸۶۱–۱۹۹۲)",
    "MYR" to "مَلیشِیَن رِنگِٹ",
    "MZE" to "موزیمبِکَن سکیوٗڑو",
    "MZM" to "پرون موزیمبِکَن مؠٹِکَل",
    "MZN" to "موزیمبِکَن مؠٹِکَل",
    "NAD" to "نامِبِیَن ڑالَر",
    "NGN" to "نَیجیرِیَن ڑالَر",
    "NIC" to "نِکؠراگُوؠن کورڑوبا",
    "NIO" to "نِکؠراگُوؠن کورڑوبا اورو",
    "NLG" to "ڈَچ گِلڑَر",
    "NOK" to "نوروییِنُک کرون",
    "NPR" to "نیپالٕچ رۄپَے",
    "NZD" to "نِوزیٖلینڑُک ڑالَر",
    "OMR" to "اومِنی رِیال",
    "PAB" to "پانامانِیَن بالبوز",
    "PEI" to "پٔریوٗوِیَن اِنٹی",
    "PEN" to "پٔریوٗوِیَن سولٕز",
    "PES" to "پٔریوٗوِیَن سول (۱۸۶۳–۱۹۶۵)",
    "PGK" to "نیوٗ پیپُعا گِنِیَن کیٖنا",
    "PHP" to "پھِلِپایِٔن پؠسو",
    "PKR" to "پاکِستٲنؠ رۄپَے",
    "PLN" to "پولِش زلوٹی",
    "PLZ" to "پولِش زلوٹی(۱۹۵٠–۱۹۹۵)",
    "PTE" to "پورتُگیٖز اؠسکیوٗڑو",
    "PYG" to "پؠرؠگیوٗوَیَن گُعارانی",
    "QAR" to "قطاری رِیال",
    "RHD" to "رھوڑیشِیَن ڑالَر",
    "ROL" to "اولڑ رومانِیَن لؠیوٗ",
    "RON" to "رومانِیَن لؠیوٗ",
    "RSD" to "سٔربِیَن دیٖنار",
    "RUB" to "روٗسی رَبٕل",
    "RUR" to "رٔشیَن رَبٕل(۱۹۹۱–۱۹۹۸)",
    "RWF" to "روانڑَن فرانک",
    "SAR" to "سودیٖیُک رِیال",
    "SBD" to "سولَمَن جٔزیٖرُک ڈالَر",
    "SDD" to "پرون سوٗڈانُک دیٖنار",
    "SDG" to "سوٗڈانُک پونڈ",
    "SDP" to "پرون سوٗڈانُک پونڈ",
    "SEK" to "سویٖڈِش کَرونا",
    "SGD" to "سِنگاپورُک ڈالَر",
    "SHP" to "سینٹ ہیلِنا پونڈ",
    "SIT" to "سلووینُک ٹولَر",
    "SKK" to "سلووَک کَرونا",
    "SOS" to "سومالی شِلِنگ",
    "SRD" to "سُریٖنامُک ڈالَر",
    "SRG" to "سُریٖنام گِلدَر",
    "SUR" to "سوویت روبٕل",
    "SVC" to "سَلویدَرُک کولَن",
    "SYP" to "سیٖریاہُک پونڈ",
    "SZL" to "سوازی لِلَنگینی",
    "THB" to "تھایھک بات",
    "TJR" to "تاجکِستانُک رَبٕل",
    "TJS" to "تاجِکتانُک سَمونی",
    "TMM" to "تُکَمَنِستانُک مَنَت",
    "TND" to "ٹُنیشیاہُک دیٖنار",
    "TOP" to "ٹونگَن پانگا",
    "TPE" to "ٹیموریسو ایکیٖڈو",
    "TRL" to "پرون تُرکِش لیرا",
    "TRY" to "تُرکیہُک لیرا",
    "TTD" to "ٹرِنہِ ڈیڈ تہٕ ٹوبیگو ڈالَر",
    "TWD" to "نۆو تیوانُک ڈالَر",
    "TZS" to "تَنزانیاہُک شِلِنگ",
    "UAH" to "یوٗکرینیاہُک ہرِوِنیا",
    "UAK" to "یوٗکرینیاہُک کاربووَنیٹس",
    "UGS" to "اُگاداہُک شِلِنگ(۱۹۶۶–۱۹۸۷)",
    "UGX" to "اُگاداہُک شِلِنگ",
    "USD" to "US ڈالر",
    "USN" to "یوٗ ایس ڈالَر(پَگاہ)",
    "USS" to "یوٗ ایس ڈالَر(تَمی دًۄہ)",
    "UYI" to "اُرگایَن پیسو یوٗنِڈیڈَس اِنڈیکسَس",
    "UYP" to "اُرگایَن پیسو(۱۹۷۵–۱۹۹۳)",
    "UYU" to "اُروٗگایَن پیسو",
    "UZS" to "اُبیکِستان سوم",
    "VEB" to "وینٕزوٗلیُک بولِوَر (۱۸۷۱–۲۰۰۸)",
    "VEF" to "وینٕزوٗلیُک بولِوَر (2008–2018)",
    "VES" to "وینٕزوٗلیُک بولِوَر",
    "VND" to "وِیَنَمُک ڈانگ",
    "VUV" to "وَنوٗاَتوٗ وَتوٗ",
    "WST" to "سَمون تَلا",
    "XAF" to "سی ایف اے فرینک بی ایٖ اے سی",
    "XAG" to "رۄپھ",
    "XAU" to "سۄن",
    "XBA" to "یوٗرپی کَمپوسِٹ یوٗنِٹ",
    "XBB" to "یوٗرپی مونِٹَری یوٗنِٹ",
    "XBC" to "یوٗرپی یوٗنِٹ آف ایکاوُنٹ (ایکس بی سی)",
    "XBD" to "یوٗرپی یوٗنِٹ آف ایکاوُنٹ (ایکس بی ڈی)",
    "XCD" to "مَشرِقی کیرِبِیَن ڈالَر",
    "XDR" to "خاص ڈرایِنگ رایٹس",
    "XEU" to "یوٗرپی کَرَنسی یوٗنِٹ",
    "XFO" to "فرینچ گولڈ فرینک",
    "XFU" to "فرینچ یوٗ اے سی فرینک",
    "XOF" to "سی ایف اے فرینک بی سی ایٖ اے او",
    "XPD" to "پُلیڈیَم",
    "XPF" to "سی ایف پی فرینک",
    "XPT" to "پلیٹِنَم",
    "XRE" to "آر آے این ایٖ ٹی فَنڈ",
    "XTS" to "ٹیسٹِنگ کَرَنسی کوڈ",
    "XXX" to "نامولوٗم کرنسی",
    "YDD" to "یَمنُک دیٖنار",
    "YER" to "یَمنُک رِیال",
    "YUD" to "یوگوسلاوِیَن ہاڑ دیٖنار",
    "YUM" to "یوگوسلاوِیَن نووِے دیٖنار",
    "YUN" to "یوگوسلاوِیَن کَنؤٹِبٕل دیٖنار",
    "ZAR" to "ساوُتھ افریٖکاہُک رینڈ",
    "ZMK" to "زِمبابیُک کواچا (1968–2012)",
    "ZMW" to "زِمبابیُک کواچا",
    "ZRN" to "زایرِیَن نِو زایِر",
    "ZRZ" to "زَیرُک ڈالَر",
    "ZWD" to "زِمبابِیُک ڈالَر",
  ) }

  val ks_Deva: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "ब्राज़िली रील",
    "CNY" to "चीनी युवान",
    "EUR" to "यूरो",
    "GBP" to "बरतानवी पूनड",
    "INR" to "इंडियन रूपी",
    "JPY" to "जापानी येन",
    "RUB" to "रूसी रूबल",
    "USD" to "US डॉलर",
    "XXX" to "नामोलुम करन्सी",
  ) }

  val ksb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "dilham ya Falme za Kialabu",
    "AOA" to "kwanza ya Angola",
    "AUD" to "dola ya Austlalia",
    "BHD" to "dinali ya Bahaleni",
    "BIF" to "falanga ya Bulundi",
    "BWP" to "pula ya Botswana",
    "CAD" to "dola ya Kanada",
    "CDF" to "falanga ya Kongo",
    "CHF" to "falanga ya Uswisi",
    "CNY" to "yaun lenminbi ya China",
    "CVE" to "eskudo ya Kepuvede",
    "DJF" to "falanga ya Jibuti",
    "DZD" to "dinali ya Aljelia",
    "EGP" to "pauni ya Misli",
    "ERN" to "nakfa ya Elitlea",
    "ETB" to "bil ya Uhabeshi",
    "EUR" to "yulo",
    "GBP" to "pauni ya Uingeeza",
    "GHC" to "sedi ya Ghana",
    "GMD" to "dalasi ya Gambia",
    "GNS" to "falanga ya Gine",
    "INR" to "lupia ya India",
    "JPY" to "salafu ya Kijapani",
    "KES" to "shilingi ya Kenya",
    "KMF" to "falanga ya Komolo",
    "LRD" to "dola ya Libelia",
    "LSL" to "loti ya Lesoto",
    "LYD" to "dinali ya Libya",
    "MAD" to "dilham ya Moloko",
    "MGA" to "falanga ya Bukini",
    "MRO" to "ugwiya ya Molitania (1973–2017)",
    "MRU" to "ugwiya ya Molitania",
    "MUR" to "lupia ya Molisi",
    "MWK" to "kwacha ya Malawi",
    "MZM" to "metikali ya Msumbiji",
    "NAD" to "dola ya Namibia",
    "NGN" to "naila ya Naijelia",
    "RWF" to "falanga ya Lwanda",
    "SAR" to "liyal ya Saudia",
    "SCR" to "lupia ya Shelisheli",
    "SDG" to "dinali ya Sudani",
    "SDP" to "pauni ya Sudani",
    "SHP" to "pauni ya Santahelena",
    "SLE" to "leoni",
    "SLL" to "leoni (1964—2022)",
    "SOS" to "shilingi ya Somalia",
    "STD" to "dobla ya Sao Tome na Plincipe (1977–2017)",
    "STN" to "dobla ya Sao Tome na Plincipe",
    "SZL" to "lilangeni",
    "TND" to "dinali ya Tunisia",
    "TZS" to "shilingi ya Tanzania",
    "UGX" to "shilingi ya Uganda",
    "USD" to "dola ya Malekani",
    "XAF" to "falanga CFA BEAC",
    "XOF" to "falanga CFA BCEAO",
    "ZAR" to "landi ya Aflika Kusini",
    "ZMK" to "kwacha ya Zambia (1968–2012)",
    "ZMW" to "kwacha ya Zambia",
    "ZWD" to "dola ya Zimbabwe",
  ) }

  val ksf: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "mɔni mǝ á bǝlɔŋ bǝ kaksa bɛ táatáaŋzǝn",
    "AOA" to "mɔni mǝ á angóla",
    "AUD" to "mɔni mǝ á ɔstralí",
    "BHD" to "mɔni mǝ á barǝ́n",
    "BIF" to "mɔni mǝ á burundí",
    "BWP" to "mɔni mǝ á botswana",
    "CAD" to "mɔni mǝ á kanada",
    "CDF" to "mɔni mǝ á kɔngó",
    "CHF" to "mɔni mǝ á swís",
    "CNY" to "mɔni mǝ á cín",
    "CVE" to "mɔni mǝ á kapvɛr",
    "DJF" to "mɔni mǝ á dyibutí",
    "DZD" to "mɔni mǝ á aljɛrí",
    "EGP" to "mɔni mǝ á ɛjípt",
    "ERN" to "mɔni mǝ á ɛritrɛ́",
    "ETB" to "mɔni mǝ á ɛtyɔpí",
    "EUR" to "mɔni mǝ á pɛrɛsǝ́",
    "GBP" to "mɔni mǝ á ingɛrís",
    "GHC" to "mɔni mǝ á gána",
    "GMD" to "mɔni mǝ á gambí",
    "GNS" to "mɔni mǝ á ginɛ́",
    "INR" to "mɔni mǝ á indí",
    "JPY" to "mɔni mǝ á japɔ́ŋ",
    "KES" to "mɔni mǝ á kɛnya",
    "KMF" to "mɔni mǝ á komɔr",
    "LRD" to "mɔni mǝ á libɛrya",
    "LSL" to "mɔni mǝ á lǝsóto",
    "LYD" to "mɔni mǝ á libí",
    "MAD" to "mɔni mǝ á marɔk",
    "MGA" to "mɔni mǝ á madagaska",
    "MRO" to "mɔni mǝ á mwaritaní (1973–2017)",
    "MRU" to "mɔni mǝ á mwaritaní",
    "MUR" to "mɔni mǝ á mwarís",
    "MWK" to "mɔni mǝ á malawi",
    "MZM" to "mɔni mǝ á mosambík",
    "NAD" to "mɔni mǝ á namibí",
    "NGN" to "mɔni mǝ á nijɛ́rya",
    "RWF" to "mɔni mǝ á rwanda",
    "SAR" to "mɔni mǝ á arabí saodí",
    "SCR" to "mɔni mǝ á sɛcɛl",
    "SDG" to "mɔni mǝ á sudan",
    "SHP" to "mɔni mǝ á sɛntɛ́len",
    "SLE" to "mɔni mǝ á syɛraleon",
    "SLL" to "mɔni mǝ á syɛraleon (1964—2022)",
    "SOS" to "mɔni mǝ á somalí",
    "STD" to "mɔni mǝ á saotomɛ́ ri priŋsib (1977–2017)",
    "STN" to "mɔni mǝ á saotomɛ́ ri priŋsib",
    "SZL" to "mɔni mǝ á swazilan",
    "TND" to "mɔni mǝ á tunɛsí",
    "TZS" to "mɔni mǝ á tanzaní",
    "UGX" to "mɔni mǝ á uganda",
    "USD" to "mɔni mǝ á amɛrika",
    "XAF" to "fráŋ",
    "XOF" to "mɔni mǝ á afríka aná wɛs",
    "ZAR" to "mɔni mǝ á afrik anǝ a sud",
    "ZMK" to "mɔni mǝ á zambí (1968–2012)",
    "ZMW" to "mɔni mǝ á zambí",
    "ZWD" to "mɔni mǝ á zimbabwɛ́",
  ) }

  val ksh: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "de vereineschte arraabesche Emiraate ier Dirham",
    "AFN" to "Afjahni",
    "ALL" to "albaanesche Lek",
    "AMD" to "armeenesche Dram",
    "ANG" to "neederlängsch antillesche Jullde",
    "AOA" to "angjolaanesche Kwansa",
    "ARS" to "ajentiinesche Peeso",
    "AUD" to "austraalesche Dollaa",
    "AWG" to "arubesche Florin",
    "AZM" to "Asserbaidschaani Manat (1993–2006)",
    "AZN" to "Asserbaidschaani Manat",
    "BAM" to "ömtuuschbaa Mark us Boßnije un dä Hächejovvina",
    "BBD" to "Barbados-Dollaa",
    "BDT" to "Taka us Bangladäsch",
    "BGN" to "buljaaresche Lev",
    "BHD" to "Bachrainesche Denaa",
    "BIF" to "burundesche Frang",
    "BMD" to "Bermuuda-Dollaa",
    "BND" to "Brunei-Dollaa",
    "BOB" to "Bollivijano",
    "BRL" to "brasilljaanesche Real",
    "BSD" to "bahama’sche Dollaa",
    "BTN" to "bhutanesesche Ngultrum",
    "BWP" to "Pula us Bozwaana",
    "BYN" to "wiißrußesche Rubel",
    "BYR" to "wiißrußesche Rubel (2000–2016)",
    "BZD" to "belizjaanesche Dollaa",
    "CAD" to "kannaadesche Dollaa",
    "CDF" to "kongjoleesesche Frang",
    "CHF" to "schweijzer Fränkli",
    "CLP" to "schileenesche Peeso",
    "CNY" to "schineesesche Yuan Renminbi",
    "COP" to "kolumbesche Peso",
    "CRC" to "koßtarikaanesche Colón",
    "CUC" to "ömtuuschbaa kubaanesche Pesos",
    "CUP" to "kubaanesche Peesos",
    "CVE" to "kapverdesche Eskuudos",
    "CZK" to "tschäschesche Kruhne",
    "DJF" to "Frang uß Dschibuti",
    "DKK" to "dänesche Kruhne",
    "DOP" to "dommenikaanesche Peesos",
    "DZD" to "aljeresche Denaa",
    "EEK" to "Äßnesche Kruhne",
    "EGP" to "äjiptesche Pongk",
    "ERN" to "Nafka uß Erritreja",
    "ETB" to "ätejoopesche Birr",
    "EUR" to "Euro",
    "FJD" to "Fidschi-Dollaa",
    "FKP" to "Pongk vun de Falkland-Enselle",
    "GBP" to "brittesche £",
    "GEL" to "jeorjesche Lari",
    "GHS" to "janaaesche Cedi",
    "GIP" to "jibraltaa’sche Pongk",
    "GMD" to "jambesche Dalasi",
    "GNF" to "Jineea-Frang",
    "GTQ" to "juatemalesche Quetzal",
    "GYD" to "Juaana-Dollaa",
    "HKD" to "Hongkong-Dollaa",
    "HNL" to "hondureanesche Lempira",
    "HRK" to "krowaatesche Kuna",
    "HTG" to "haiitesche Gourde",
    "HUF" to "unjarresche Forint",
    "IDR" to "indoneesesche Ruupije",
    "ILS" to "ißraeelesche Schekel",
    "INR" to "indesche Ruupije",
    "IQD" to "iraakesche Denaa",
    "IRR" to "persesche Rial",
    "ISK" to "ißländesche Kruhne",
    "JMD" to "jamaikaanesche Dollaa",
    "JOD" to "Jordaanesche Dollaa",
    "JPY" to "japaanesche Jen",
    "KES" to "Kenjaanesche Schillinge",
    "KGS" to "kirjiisesche Som",
    "KHR" to "kambodschaanesche Riel",
    "KMF" to "kommooresche Frang",
    "KPW" to "noodkorejaansche Won",
    "KRW" to "söödkorejaansche Won",
    "KWD" to "kuwaitesche Denaa",
    "KYD" to "Kaimann-Dollaa",
    "KZT" to "kasakesche Tenge",
    "LAK" to "loaatesche Kip",
    "LBP" to "libaneesesche Pongk",
    "LKR" to "schrilankesche Ruupije",
    "LRD" to "liberijaanesche Dollaa",
    "LSL" to "lesoothesche Loti",
    "LTL" to "littouesche Litas",
    "LVL" to "lättesche Lats",
    "LYD" to "libesche Denaa",
    "MAD" to "marrokaanesche Dirhamm",
    "MDL" to "moldaavesche Leu",
    "MGA" to "madajaskesche Ariary",
    "MKD" to "mazedoonesche Denaa",
    "MMK" to "burmeesesche Kyat",
    "MNT" to "mongjoolesche Tugrik",
    "MOP" to "makaneesesche Pataca",
    "MRO" to "mauretanesche Ouguiya (1973–2017)",
    "MRU" to "mauretanesche Ouguiya",
    "MUR" to "maurizjahnesche Ruupije",
    "MVR" to "mallediivesche Rufiyaa",
    "MWK" to "malaawesche Kwache",
    "MXN" to "mexekaanesche Peeso",
    "MYR" to "malaisesche Ringgit",
    "MZM" to "mosambikaanesche Metical (1980–2006)",
    "MZN" to "mossambikaanesche Metical",
    "NAD" to "namiibesche Dollaa",
    "NGN" to "nijerijaanesche Naira",
    "NIO" to "nikarajaanesche Córdoba",
    "NOK" to "norrweejesche Kruhne",
    "NPR" to "nepaleesesche Ruupije",
    "NZD" to "neuseeländesche Dollaa",
    "OMR" to "ommaanesche Rijal",
    "PAB" to "pannameesesche Balboa",
    "PEN" to "perruaanesche Sol",
    "PGK" to "papua neujinejaanesche Kina",
    "PHP" to "fillipiinesche Pesos",
    "PKR" to "pakestaanesche Ruupije",
    "PLN" to "polnesche Złoty",
    "PYG" to "parajuaanesche Juarani",
    "QAR" to "kataaresche Rijal",
    "ROL" to "romäänesche Leu (1952–2006)",
    "RON" to "romäänesche Leu",
    "RSD" to "särbesche Denaare",
    "RUB" to "russesche Ruubel",
    "RWF" to "ruandesche Frang",
    "SAR" to "saudesche Rijal",
    "SBD" to "solomonesche Dollaa",
    "SCR" to "seischellesche Ruupije",
    "SDG" to "sudaneesesche Pongk",
    "SEK" to "schweedesche Kruhne",
    "SGD" to "singjapurejaanesche Dollaa",
    "SHP" to "Zint-Hellena-Pongk",
    "SKK" to "ßlovaakesche Kruhne",
    "SLE" to "ẞjärra-lejoneesesche Leone",
    "SLL" to "ẞjärra-lejoneesesche Leone (1964—2022)",
    "SOS" to "somaalesche Schillenge",
    "SRD" to "sürinameesesche Dollaa",
    "SSP" to "södsudaneesesche Pongk",
    "STD" to "Dobra vun São Tomé un Príncipe (1977–2017)",
    "STN" to "Dobra vun São Tomé un Príncipe",
    "SVC" to "asalvadorejaanesche Cosan",
    "SYP" to "süüresche Pund",
    "SZL" to "swasiländesche Lilangeni",
    "THB" to "tailändesche Baht",
    "TJS" to "tadschikißtaanesche Somoni",
    "TMM" to "turkmeneßtaanesche Manat (1993–2009)",
    "TMT" to "turkmeneßtaanesche Manat",
    "TND" to "tuneesesche Denaa",
    "TOP" to "tongjanes Paʻangache",
    "TRY" to "törkesche Liire",
    "TTD" to "Dollaa uß Trinidad un Tobääjo",
    "TWD" to "neu taiwaneesesche Dollaa",
    "TZS" to "tansaanesche Schillenge",
    "UAH" to "ukraijnesche Hryvnia",
    "UGX" to "ujandesche Schillenge",
    "USD" to "ammärrikaanesche Dollaa",
    "UYU" to "urrujuwaische Peeso",
    "UZS" to "ußbeekesche Som",
    "VEF" to "venezuelaanesche Bolívar (2008–2018)",
    "VES" to "venezuelaanesche Bolívar",
    "VND" to "vijätnammeesesche Dong",
    "VUV" to "vanuatesche Vatu",
    "WST" to "samowaanesche Tala",
    "XAF" to "Kmmeruhner Frang",
    "XAG" to "Sellver",
    "XAU" to "Jold",
    "XCD" to "oß-karribbesche Dollaa",
    "XFO" to "franzüüsesche Joldfranke",
    "XOF" to "Frang uß de Älfebeinköß",
    "XPD" to "Palladijum",
    "XPF" to "polineesesche Frang",
    "XPT" to "Plaatin",
    "XTS" to "Währong zum Prööfe",
    "XXX" to "onbikannte Währong",
    "YER" to "jemenitesche Rijal",
    "ZAR" to "södaffrekaanesche Rand",
    "ZMK" to "sambesche Kwacha (1968–2012)",
    "ZMW" to "sambesche Kwacha",
    "ZWD" to "simbabwesche Dollaa (1980–2008)",
    "ZWL" to "simbabwesche Dollaa (2009)",
  ) }

  val ku: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "dîrhemê mîrgehên erebî yên yekbûyî",
    "AFN" to "efxanîyê efxanistanî",
    "ALL" to "lekê arnawidî",
    "AMD" to "dramê ermenî",
    "ANG" to "guldenê antîlê yê holandî",
    "AOA" to "kwanzayê angolayî",
    "ARS" to "pesoyê arjantînî",
    "AUD" to "dolarê awistralyayî",
    "AWG" to "florînê arubayî",
    "AZN" to "manatê azerbeycanî",
    "BAM" to "markê konvertibl ê bosna hersekî",
    "BBD" to "dolarê barbadosî",
    "BDT" to "takayê bengladeşî",
    "BGN" to "levê bulgarî",
    "BHD" to "dînarê behreynê",
    "BIF" to "frankê birûndîyî",
    "BMD" to "dolarê bermûdayî",
    "BND" to "dolarê brûneyî",
    "BOB" to "bolîvyanoyê bolîvyayî",
    "BRL" to "realê brezîlyayî",
    "BSD" to "dolarê bahamayî",
    "BTN" to "ngultrumê bûtanî",
    "BWP" to "pulayê botswanayî",
    "BYN" to "rûbleyê belarûsî",
    "BZD" to "dolarê belîzeyî",
    "CAD" to "dolarê kanadayî",
    "CDF" to "frankê kongoyî",
    "CHF" to "frankê swîsrî",
    "CLP" to "pesoyê şîlîyê",
    "CNH" to "yûanê çînî (offshore)",
    "CNY" to "yûanê çînî",
    "COP" to "pesoyê kolombîyayî",
    "CRC" to "kolonê kosta rîkayî",
    "CUC" to "pesoyên konvertibl ê kubayî",
    "CUP" to "pesoyê kubayî",
    "CVE" to "eskudoyê kape verdeyî",
    "CZK" to "kronê çekî",
    "DJF" to "frankê cîbûtîyî",
    "DKK" to "kronê danîmarkî",
    "DOP" to "pesoyê domînîkî",
    "DZD" to "dînarê cezayîrî",
    "EGP" to "lîreyê misirî",
    "ERN" to "nakfayê erîtreyî",
    "ETB" to "bîrê etyopyayî",
    "EUR" to "ewro",
    "FJD" to "dolarê fîjîyî",
    "FKP" to "paundê giravên falklandê",
    "GBP" to "sterlînê brîtanî",
    "GEL" to "larîyê gurcistanî",
    "GHS" to "cedîyê ganayî",
    "GIP" to "poundê gîbraltarê",
    "GMD" to "dalasîyê gambîyayî",
    "GNF" to "frankê gîneyî",
    "GTQ" to "quertzalê guatemalayî",
    "GYD" to "dolarê guayanayî",
    "HKD" to "dolarê hong kongî",
    "HNL" to "lempîrayê hondurasî",
    "HRK" to "kûnayê xirwatî",
    "HTG" to "gûrdeyê haîtîyî",
    "HUF" to "forîntê macarî",
    "IDR" to "rûpîyê endonezî",
    "ILS" to "şekelê nû yê îsraîlî",
    "INR" to "rûpîyê hindistanî",
    "IQD" to "dînarê îraqî",
    "IRR" to "rîyalê îranî",
    "ISK" to "kronê îslandayî",
    "JMD" to "dolarê jamaîkayî",
    "JOD" to "dînarê urdunî",
    "JPY" to "yenê japonî",
    "KES" to "şîlîngê kenyayî",
    "KGS" to "somê qirxizistanî",
    "KHR" to "rîelê kamboçyayî",
    "KMF" to "frankê komoranî",
    "KPW" to "wonê koreya bakurî",
    "KRW" to "wonê koreya başûrî",
    "KWD" to "dînarê kuweytî",
    "KYD" to "dolarê giravên keymanî",
    "KZT" to "tengeyê qazaxistanî",
    "LAK" to "kîpê laosî",
    "LBP" to "lîreyê libnanî",
    "LKR" to "rûpîyê srî lankayî",
    "LRD" to "dolarê lîberyayî",
    "LSL" to "lotîyê lesothoyî",
    "LYD" to "dînarê lîbyayî",
    "MAD" to "dîrhemê fasî",
    "MDL" to "leyê moldovayî",
    "MGA" to "frankê madagaskarî",
    "MKD" to "dînarê makedonî",
    "MMK" to "kyatê myanmarî",
    "MNT" to "togrokê moxolî",
    "MOP" to "patakayê makaoyî",
    "MRU" to "ouguîayê morîtanyayî",
    "MUR" to "rûpîyê maûrîtîûsê",
    "MVR" to "rûfîyaayê maldîvayî",
    "MWK" to "kwaçayê malawîyê",
    "MXN" to "pesoyê meksîkayî",
    "MYR" to "ringgitê malezyayî",
    "MZN" to "meticalê mozambîkî",
    "NAD" to "dolarê namîbyayî",
    "NGN" to "naîrayê nîjeryayî",
    "NIO" to "kordobayê nîkaraguayî",
    "NOK" to "kronê norweçî",
    "NPR" to "rûpîyê nepalî",
    "NZD" to "dolarê zelandayî",
    "OMR" to "rîyalê umanî",
    "PAB" to "balboayê panamayî",
    "PEN" to "solê perûyî",
    "PGK" to "kînayê gîneya nû ya papûayî",
    "PHP" to "pesoyê fîlîpînî",
    "PKR" to "rûpîyê pakistanî",
    "PLN" to "zlotîyê polonyayî",
    "PYG" to "gûaranîyê paragûayî",
    "QAR" to "rîyalê qeterî",
    "RON" to "leyê romanyayî",
    "RSD" to "dînarê sirbî",
    "RUB" to "rubleyê rûsî",
    "RWF" to "frankê rwandayî",
    "SAR" to "rîyalê siûdî",
    "SBD" to "dolarê giravên solomonî",
    "SCR" to "rûpîyê seyşelerî",
    "SDG" to "lîreyê sûdanî",
    "SEK" to "kronê swêdî",
    "SGD" to "dolarê sîngapurî",
    "SHP" to "lîreyê saînt helenayî",
    "SLE" to "leoneyê sîera leoneyî",
    "SLL" to "leoneyê sîera leoneyî (1964—2022)",
    "SOS" to "şîlîngê somalî",
    "SRD" to "dolarê surînamî",
    "SSP" to "lîreyê sûdana başûrî",
    "STN" to "dobrayê sao tome û principeyî",
    "SYP" to "lîreyê sûrî",
    "SZL" to "lîlangenîyê swazîlî",
    "THB" to "bahtê taylandî",
    "TJS" to "somonê tacikistanî",
    "TMT" to "manatê tirkmenî",
    "TND" to "dînarê tûnisî",
    "TOP" to "paʻangayê tonganî",
    "TRY" to "lîreyê tirkî",
    "TTD" to "dolarê trinidad û tobagoyî",
    "TWD" to "dolarê taywanî",
    "TZS" to "şîlîngê tanzanî",
    "UAH" to "grîvnayê ûkraynî",
    "UGX" to "şîlîngê ûgandayî",
    "USD" to "dolarê amerîkî",
    "UYU" to "pesoyê ûrûgûayî",
    "UZS" to "somê ozbekî",
    "VES" to "bolîvarê venezuelayî",
    "VND" to "dongê vîetnamî",
    "VUV" to "vatûyê vanûatûyî",
    "WST" to "talayê somonî",
    "XAF" to "frenkê CFA yê afrîkaya navîn",
    "XCD" to "dolarê karayîba rojhilatî",
    "XOF" to "frankê CFA yê afrîkaya başûrî",
    "XPF" to "frankê CFPî",
    "XXX" to "(yekeya pereyî ya nenas)",
    "YER" to "rîyalê yemenî",
    "ZAR" to "randê afrîkaya başûrî",
    "ZMW" to "kwaçayê zambîyayî",
  ) }

  val kw: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val kxv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "brājil ti riel",
    "CNY" to "cin ti yuān",
    "EUR" to "yuro",
    "GBP" to "briṭis pāunḍ",
    "INR" to "bārat ti ṭnkā",
    "JPY" to "jāpān ti yēn",
    "RUB" to "rūs ti rūbel",
    "USD" to "iūes ḍalār",
    "XXX" to "puṇātī lēmbū",
  ) }

  val kxv_Deva: ImmutableMap<String, String> by lazy { immutableMapOf(
    "CNY" to "चीन ति युआन",
    "EUR" to "यूरो",
    "GBP" to "ब्रिटिस पाउंड स्टर्लिंग",
    "INR" to "बारत ति टाकाँ",
    "JPY" to "जापान ति येन",
    "RUB" to "रूस ति रूबल",
    "USD" to "यूएस डॉलर",
    "XXX" to "पुण्-आँऽति लेबुँ",
  ) }

  val kxv_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "brājil ti riel",
    "CNY" to "cin ti yuān",
    "EUR" to "yuro",
    "GBP" to "briṭis pāunḍ",
    "INR" to "bārat ti ṭnkā",
    "JPY" to "jāpān ti yēn",
    "RUB" to "rūs ti rūbel",
    "USD" to "iūes ḍalār",
    "XXX" to "puṇātī lēmbū",
  ) }

  val kxv_Orya: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "ବ୍ରାଜିଲ୍ ତି ରିଏଲ୍",
    "CNY" to "ଚିନି ତି ୟୁଆନ",
    "EUR" to "ୟୁର",
    "GBP" to "ବ୍ରିଟିସ୍ ପାଉଣ୍ଡ୍",
    "INR" to "ବାରତ ତି ଟାକାଁ",
    "JPY" to "ଜାପାନ ତି ୟେନ",
    "RUB" to "ରୁସିଆ ତି ରୁବଲ୍",
    "USD" to "ୟୁ ଏସ ଡଲାର",
    "XXX" to "ପୁଣ୍‍ଆତି ଲେବୁଁ",
  ) }

  val kxv_Telu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "బ్రెజిలియన్ రియల్",
    "CNY" to "చైనా దేశ యువాన్",
    "EUR" to "యురొ",
    "GBP" to "బ్రిటిష్ పౌండ్",
    "INR" to "భారతదేశ రూపాయి",
    "JPY" to "జపాను దేశ యెన్",
    "RUB" to "రష్యన్ రూబల్",
    "USD" to "అమెరికా డాలర్",
    "XXX" to "తెలియని కరెన్సీ",
  ) }

  val ky: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Бириккен Араб Эмираттарынын дирхамы",
    "AFN" to "Афганстан афганиси",
    "ALL" to "албан леги",
    "AMD" to "Армения драмы",
    "ANG" to "нидерланд-антил гулдени",
    "AOA" to "Ангола кванзасы",
    "ARS" to "аргентина песосу",
    "AUD" to "Австралия доллары",
    "AWG" to "аруба флорини",
    "AZN" to "Азербайжан манаты",
    "BAM" to "босния-герцоговина конвертациялануучу маркасы",
    "BBD" to "барбадос доллары",
    "BDT" to "Бангладеш такасы",
    "BGN" to "болгар левиси",
    "BHD" to "Бахрейн динары",
    "BIF" to "Бурунди франкы",
    "BMD" to "бермуд доллары",
    "BND" to "Бруней доллары",
    "BOB" to "боливия боливианосу",
    "BRL" to "бразилия реалы",
    "BSD" to "багама доллары",
    "BTN" to "Бутан нгултруму",
    "BWP" to "Ботсвана пуласы",
    "BYN" to "беларусь рублу",
    "BYR" to "беларусь рублу (2000–2016)",
    "BZD" to "белиз доллары",
    "CAD" to "канада доллары",
    "CDF" to "Конго франкы",
    "CHF" to "швейцария франкы",
    "CLP" to "чили песосу",
    "CNH" to "Кытай юаны (оффшор)",
    "CNY" to "Кытай юаны",
    "COP" to "колумбия песосу",
    "CRC" to "коста-рика колону",
    "CUC" to "кубанын конвертациялануучу песосу",
    "CUP" to "куба песосу",
    "CVE" to "Кабо-Верде эскудосу",
    "CZK" to "чех кронасы",
    "DJF" to "Жибути франкы",
    "DKK" to "дания крону",
    "DOP" to "доминикан песосу",
    "DZD" to "алжир динары",
    "EGP" to "египет фунту",
    "ERN" to "Эритреа накфасы",
    "ETB" to "Эфиопия бирри",
    "EUR" to "Евро",
    "FJD" to "Фижи доллары",
    "FKP" to "фолкленд аралдарынын фунту",
    "GBP" to "британия фунт стерлинги",
    "GEL" to "Грузия лариси",
    "GHS" to "Гана седиси",
    "GIP" to "гибралтар фунту",
    "GMD" to "Гамбия даласиси",
    "GNF" to "Гине франкы",
    "GTQ" to "гватемала кетсалы",
    "GYD" to "гуйана доллары",
    "HKD" to "Гонконг доллары",
    "HNL" to "гондурас лемпирасы",
    "HRK" to "хорват кунасы",
    "HTG" to "гаити гурдусу",
    "HUF" to "венгр форинти",
    "IDR" to "Индонезия рупийасы",
    "ILS" to "Израилдин жаңы шекели",
    "INR" to "Индия руписи",
    "IQD" to "Ирак динары",
    "IRR" to "Иран риалы",
    "ISK" to "исландия крону",
    "JMD" to "ямайка доллары",
    "JOD" to "Йордания динары",
    "JPY" to "Жапан йени",
    "KES" to "Кения шиллинги",
    "KGS" to "Кыргызстан сому",
    "KHR" to "Камбожа риели",
    "KMF" to "Коморос франкы",
    "KPW" to "Түндүк Корея вону",
    "KRW" to "Түштүк Корея вону",
    "KWD" to "Кувейт динары",
    "KYD" to "кайман доллары",
    "KZT" to "Казакстан теңгеси",
    "LAK" to "Лаос киби",
    "LBP" to "Ливан фунту",
    "LKR" to "Шри Ланка руписи",
    "LRD" to "Либерия доллары",
    "LSL" to "Лесото лотиси",
    "LTL" to "литва литасы",
    "LVL" to "латвия латы",
    "LYD" to "ливия динары",
    "MAD" to "марокко дирхамы",
    "MDL" to "молдован лейи",
    "MGA" to "Мадагаскар ариариси",
    "MKD" to "македон денары",
    "MMK" to "Мйанмар кйаты",
    "MNT" to "Монгол тугриги",
    "MOP" to "Макау патакасы",
    "MRO" to "Мавритания угиясы (1973–2017)",
    "MRU" to "Мавритания угиясы",
    "MUR" to "Мавританий руписи",
    "MVR" to "Малдив руфийасы",
    "MWK" to "Малави квачасы",
    "MXN" to "мексика песосу",
    "MYR" to "Малайзия ринггити",
    "MZN" to "Мозамбик метикалы",
    "NAD" to "Намибия доллары",
    "NGN" to "Нигерия найрасы",
    "NIO" to "никарагуа кордобасы",
    "NOK" to "норвегия крону",
    "NPR" to "Непал руписи",
    "NZD" to "Жаңы Зеландия доллары",
    "OMR" to "Оман риалы",
    "PAB" to "панама балбоасы",
    "PEN" to "перу солу",
    "PGK" to "Папуа Жаңы Гвинея кинасы",
    "PHP" to "Филиппин песосу",
    "PKR" to "Пакистан руписи",
    "PLN" to "польша злотыйы",
    "PYG" to "парагвай гуараниси",
    "QAR" to "Катар риалы",
    "RON" to "румын лейи",
    "RSD" to "серб динары",
    "RUB" to "орус рублу",
    "RWF" to "Руанда франкы",
    "SAR" to "Сауд риалы",
    "SBD" to "Соломон аралдарынын доллары",
    "SCR" to "Сейшел руписи",
    "SDG" to "судан фунту",
    "SEK" to "швеция крону",
    "SGD" to "Сингапур доллары",
    "SHP" to "Ыйык Елена аралынын фунту",
    "SLE" to "Сиерра-Леоне леонеси",
    "SLL" to "Сиерра-Леоне леонеси (1964—2022)",
    "SOS" to "Сомали шиллинги",
    "SRD" to "суринам доллары",
    "SSP" to "Түштүк Судан фунту",
    "STD" to "Сао Томе жана Принсипе добрасы (1977–2017)",
    "STN" to "Сао Томе жана Принсипе добрасы",
    "SYP" to "Сирия фунту",
    "SZL" to "Свази лилангени",
    "THB" to "Тай баты",
    "TJS" to "Тажикстан сомониси",
    "TMT" to "Түркмөнстан манаты",
    "TND" to "тунис динары",
    "TOP" to "Тонга паангасы",
    "TRY" to "Түркия лирасы",
    "TTD" to "тринидад жана тобаго доллары",
    "TWD" to "Тайвань жаңы доллары",
    "TZS" to "Танзания шиллинги",
    "UAH" to "украин гривени",
    "UGX" to "Уганда шиллинги",
    "USD" to "АКШ доллары",
    "UYU" to "уругвай песосу",
    "UZS" to "Өзбекстан суму",
    "VEF" to "венесуэла боливары (2008–2018)",
    "VES" to "Венесуэла боливары",
    "VND" to "Вьетнам доңу",
    "VUV" to "Вануату ватусу",
    "WST" to "Самоа таласы",
    "XAF" to "Борбордук Африка КФА франкы",
    "XCD" to "чыгыш кариб доллары",
    "XOF" to "КФА франкы",
    "XPF" to "КФП франкы",
    "XXX" to "Белгисиз акча",
    "YER" to "Йемен риалы",
    "ZAR" to "Түштүк Африка ранды",
    "ZMW" to "Замбия квачасы",
  ) }

  val la: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val lag: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Diriháamu ya Ʉtemi wa Kɨaráabu",
    "AOA" to "Kwáanza ya Angóola",
    "AUD" to "Dóola ya Ausitereelía",
    "BHD" to "Dináari ya Baharéeni",
    "BIF" to "Faráanga ya Burúundi",
    "BWP" to "Púula ya Botiswáana",
    "CAD" to "Dóola ya Kánada",
    "CDF" to "Faráanga ya Kóongo",
    "CHF" to "Faráaka ya Uswíisi",
    "CNY" to "Yúani Renimínibi ya Chíina",
    "CVE" to "Esikúudo ya Kepuvéede",
    "DJF" to "Faráanga ya Jibóuti",
    "DZD" to "Dináairi ya Alijéria",
    "EGP" to "Páundi ya Mísiri",
    "ERN" to "Nákɨfa ya Eriterea",
    "ETB" to "Bíiri ya Ʉhabéeshi",
    "EUR" to "Yúuro",
    "GBP" to "Páundi ya Ʉɨngɨréesa",
    "GHC" to "Séedi ya Gáana",
    "GMD" to "Daláasi ya Gámbia",
    "GNS" to "Faráanga ya Gíine",
    "INR" to "Rupía ya Índia",
    "JPY" to "Yéeni ya Japáani",
    "KES" to "Shilíingi ya Kéenya",
    "KMF" to "Faráanga ya Komóoro",
    "LRD" to "Dóola ya Libéria",
    "LSL" to "Lóoti ya Lesóoto",
    "LYD" to "Dináari ya Líbia",
    "MAD" to "Diriháamu ya Moróoko",
    "MGA" to "Mpía ya bukini",
    "MRO" to "Ungwíiya ya Moritánia (1973–2017)",
    "MRU" to "Ungwíiya ya Moritánia",
    "MUR" to "Rupía ya Moríisi",
    "MWK" to "Kwáacha ya Maláawi",
    "MZM" to "Metikáali ya Musumbíiji",
    "NAD" to "Dóola ya Namíbia",
    "NGN" to "Naíira ya Niijéria",
    "RWF" to "Faráanga ya Rwáanda",
    "SAR" to "Riyáali ya Saudía",
    "SCR" to "Rupía ya Shelishéeli",
    "SDG" to "Páundi ya Sudáani",
    "SHP" to "Páundi ya Mʉtakatíifu Heléena",
    "SLE" to "Leóoni",
    "SLL" to "Leóoni (1964—2022)",
    "SOS" to "Shilíingi ya Somália",
    "STD" to "Dóbura ya SaoTóome na Pirínsipe (1977–2017)",
    "STN" to "Dóbura ya SaoTóome na Pirínsipe",
    "SZL" to "Lilengéeni",
    "TND" to "Dináari ya Tunísia",
    "TZS" to "Shilíingi ya Taansanía",
    "UGX" to "Shilíingi ya Ugáanda",
    "USD" to "Dóola ya Amerɨ́ka",
    "XAF" to "Faráanga ya CFA BEAC",
    "XOF" to "Faráanga ya CFA BCEAO",
    "ZAR" to "Ráandi ya Afɨrɨka ya Saame",
    "ZMK" to "Kwácha ya Sámbia (1968–2012)",
    "ZMW" to "Kwácha ya Sámbia",
    "ZWD" to "Dóola ya Simbáabwe",
  ) }

  val lb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorranesch Peseta",
    "AED" to "VAE-Dirham",
    "AFA" to "Afghanesch Afghani (1927–2002)",
    "AFN" to "Afghanesch Afghani",
    "ALL" to "Albanesche Lek",
    "AMD" to "Armeneschen Dram",
    "ANG" to "Antillen-Gulden",
    "AOA" to "Angolanesche Kwanza",
    "AOK" to "Angolanesche Kwanza (1977–1990)",
    "AON" to "Angolaneschen Neie Kwanza (1990–2000)",
    "AOR" to "Angolanesche Kwanza Reajustado (1995–1999)",
    "ARA" to "Argentineschen Austral",
    "ARP" to "Argentinesche Peso (1983–1985)",
    "ARS" to "Argentinesche Peso",
    "ATS" to "Éisträichesche Schilling",
    "AUD" to "Australeschen Dollar",
    "AWG" to "Aruba-Florin",
    "AZM" to "Aserbaidschan-Manat (1993–2006)",
    "AZN" to "Aserbaidschan-Manat",
    "BAD" to "Bosnien an Herzegowina Dinar (1992–1994)",
    "BAM" to "Bosnien an Herzegowina Konvertéierbar Mark",
    "BBD" to "Barbados-Dollar",
    "BDT" to "Bangladesch-Taka",
    "BEC" to "Belsche Frang (konvertibel)",
    "BEF" to "Belsche Frang",
    "BEL" to "Belsche Finanz-Frang",
    "BGL" to "Bulgaresch Lew (1962–1999)",
    "BGN" to "Bulgaresch Lew",
    "BHD" to "Bahrain-Dinar",
    "BIF" to "Burundi-Frang",
    "BMD" to "Bermuda-Dollar",
    "BND" to "Brunei-Dollar",
    "BOB" to "Bolivianesche Boliviano",
    "BOP" to "Bolivianesche Peso",
    "BOV" to "Bolivianseche Mvdol",
    "BRB" to "Brasilianesche Cruzeiro Novo (1967–1986)",
    "BRC" to "Brasilianesche Cruzado (1986–1989)",
    "BRE" to "Brasilianesche Cruzeiro (1990–1993)",
    "BRL" to "Brasilianesche Real",
    "BRN" to "Brasilianesche Cruzado Novo (1989–1990)",
    "BRR" to "Brasilianesche Cruzeiro (1993–1994)",
    "BRZ" to "Brasilianesche Cruzeiro (1942–1967)",
    "BSD" to "Bahama-Dollar",
    "BTN" to "Bhutan-Ngultrum",
    "BUK" to "Birmanesche Kyat",
    "BWP" to "Botswanesch Pula",
    "BYB" to "Wäissrussesche Rubel (1994–1999)",
    "BYN" to "Wäissrussesche Rubel",
    "BYR" to "Wäissrussesche Rubel (2000–2016)",
    "BZD" to "Belize-Dollar",
    "CAD" to "Kanadeschen Dollar",
    "CDF" to "Kongo-Frang",
    "CHE" to "WIR-Euro",
    "CHF" to "Schwäizer Frang",
    "CHW" to "WIR-Frang",
    "CLF" to "Chileneschen Unidad de Fomento",
    "CLP" to "Chilenesche Peso",
    "CNY" to "Renminbi Yuan",
    "COP" to "Kolumbianesche Peso",
    "CRC" to "Costa-Rica-Colón",
    "CSD" to "Serbeschen Dinar (2002–2006)",
    "CSK" to "Tschechoslowakesch Kroun",
    "CUC" to "Kubanesche Peso (konvertibel)",
    "CUP" to "Kubanesche Peso",
    "CVE" to "Kap-Verde-Escudo",
    "CYP" to "Zypern-Pond",
    "CZK" to "Tschechesch Kroun",
    "DDM" to "DDR-Mark",
    "DEM" to "Däitsch Mark",
    "DJF" to "Dschibuti-Frang",
    "DKK" to "Dänesch Kroun",
    "DOP" to "Dominikanesche Peso",
    "DZD" to "Algereschen Dinar",
    "ECS" to "Ecuadorianesche Sucre",
    "ECV" to "Verrechnungseenheete fir Ecuador",
    "EEK" to "Estnesch Kroun",
    "EGP" to "Egyptescht Pond",
    "ERN" to "Eritréieschen Nakfa",
    "ESA" to "Spuenesch Peseta (A–Konten)",
    "ESB" to "Spuenesch Peseta (konvertibel)",
    "ESP" to "Spuenesch Peseta",
    "ETB" to "Ethiopescht Birr",
    "EUR" to "Euro",
    "FIM" to "Finnesch Mark",
    "FJD" to "Fidschi-Dollar",
    "FKP" to "Falkland-Pond",
    "FRF" to "Franséische Frang",
    "GBP" to "Britescht Pond",
    "GEK" to "Georgesche Kupon Larit",
    "GEL" to "Georgesche Lari",
    "GHC" to "Ghanaeschen Cedi (1979–2007)",
    "GHS" to "Ghanaeschen Cedi",
    "GIP" to "Gibraltar-Pond",
    "GMD" to "Gambia-Dalasi",
    "GNF" to "Guinea-Frang",
    "GNS" to "Guinéiesche Syli",
    "GQE" to "Equatorialguinea-Ekwele",
    "GRD" to "Griichesch Drachme",
    "GTQ" to "Guatemaltekesche Quetzal",
    "GWE" to "Portugisesch-Guinea Escudo",
    "GWP" to "Guinea-Bissau Peso",
    "GYD" to "Guyana-Dollar",
    "HKD" to "Hong-Kong-Dollar",
    "HNL" to "Honduras-Lempira",
    "HRD" to "Kroateschen Dinar",
    "HRK" to "Kroatesche Kuna",
    "HTG" to "Haitianesch Gourde",
    "HUF" to "Ungaresche Forint",
    "IDR" to "Indonesesch Rupiah",
    "IEP" to "Irescht Pond",
    "ILP" to "Israelescht Pond",
    "ILS" to "Israeleschen Neie Schekel",
    "INR" to "Indesch Rupie",
    "IQD" to "Irakeschen Dinar",
    "IRR" to "Iranesch Rial",
    "ISK" to "Islännesch Kroun",
    "ITL" to "Italienesch Lira",
    "JMD" to "Jamaika-Dollar",
    "JOD" to "Jordaneschen Dinar",
    "JPY" to "Japanesche Yen",
    "KES" to "Kenia-Schilling",
    "KGS" to "Kirgisesche Som",
    "KHR" to "Kambodschanesche Riel",
    "KMF" to "Komore-Frang",
    "KPW" to "Nordkoreanesche Won",
    "KRW" to "Südkoreanesche Won",
    "KWD" to "Kuwait-Dinar",
    "KYD" to "Kaiman-Dollar",
    "KZT" to "Kasacheschen Tenge",
    "LAK" to "Laoteschen Kip",
    "LBP" to "Libanesescht Pond",
    "LKR" to "Sri-Lanka-Rupie",
    "LRD" to "Liberianeschen Dollar",
    "LSL" to "Loti",
    "LTL" to "Litauesche Litas",
    "LTT" to "Litaueschen Talonas",
    "LUC" to "Lëtzebuerger Frang (konvertibel)",
    "LUF" to "Lëtzebuerger Frang",
    "LUL" to "Lëtzebuerger Finanz-Frang",
    "LVL" to "Lettesche Lats",
    "LVR" to "Lettesche Rubel",
    "LYD" to "Libeschen Dinar",
    "MAD" to "Marokkaneschen Dirham",
    "MAF" to "Marokkanesche Frang",
    "MDL" to "Moldawesche Leu",
    "MGA" to "Madagaskar-Ariary",
    "MGF" to "Madagaskar-Frang",
    "MKD" to "Mazedoneschen Denar",
    "MLF" to "Malesche Frang",
    "MMK" to "Myanmaresche Kyat",
    "MNT" to "Mongoleschen Tögrög",
    "MOP" to "Macau-Pataca",
    "MRO" to "Mauretaneschen Ouguiya (1973–2017)",
    "MRU" to "Mauretaneschen Ouguiya",
    "MTL" to "Maltesesch Lira",
    "MTP" to "Maltesescht Pond",
    "MUR" to "Mauritius-Rupie",
    "MVR" to "Maldiven-Rupie",
    "MWK" to "Malawi-Kwacha",
    "MXN" to "Mexikanesche Peso",
    "MXP" to "Mexikanesche Sëlwer-Peso (1861–1992)",
    "MXV" to "Mexikaneschen Unidad de Inversion (UDI)",
    "MYR" to "Malayseschen Ringgit",
    "MZE" to "Mosambikaneschen Escudo",
    "MZM" to "Mosambikanesche Metical (1980–2006)",
    "MZN" to "Mosambikanesche Metical",
    "NAD" to "Namibia-Dollar",
    "NGN" to "Nigerianeschen Naira",
    "NIC" to "Nicaraguanesche Córdoba (1988–1991)",
    "NIO" to "Nicaraguanesche Córdoba",
    "NLG" to "Hollännesche Gulden",
    "NOK" to "Norwegesch Kroun",
    "NPR" to "Nepalesesch Rupie",
    "NZD" to "Neiséiland-Dollar",
    "OMR" to "Omanesche Rial",
    "PAB" to "Panamaesche Balboa",
    "PEI" to "Peruaneschen Inti",
    "PEN" to "Peruaneschen Sol",
    "PES" to "Peruaneschen Sol (1863–1965)",
    "PGK" to "Papua-Neiguinéiesche Kina",
    "PHP" to "Philippinnesche Peso",
    "PKR" to "Pakistanesch Rupie",
    "PLN" to "Polneschen Zloty",
    "PLZ" to "Polneschen Zloty (1950–1995)",
    "PTE" to "Portugiseschen Escudo",
    "PYG" to "Paraguayeschen Guaraní",
    "QAR" to "Katar-Riyal",
    "RHD" to "Rhodeseschen Dollar",
    "ROL" to "Rumänesche Leu (1952–2006)",
    "RON" to "Rumänesche Leu",
    "RSD" to "Serbeschen Dinar",
    "RUB" to "Russesche Rubel",
    "RUR" to "Russesche Rubel (1991–1998)",
    "RWF" to "Ruanda-Frang",
    "SAR" to "Saudi-Rial",
    "SBD" to "Salomonen-Dollar",
    "SCR" to "Seychellen-Rupie",
    "SDD" to "Sudaneseschen Dinar (1992–2007)",
    "SDG" to "Sudanesescht Pond",
    "SDP" to "Sudanesescht Pond (1957–1998)",
    "SEK" to "Schwedesch Kroun",
    "SGD" to "Singapur-Dollar",
    "SHP" to "St. Helena-Pond",
    "SIT" to "Sloweneschen Tolar",
    "SKK" to "Slowakesch Kroun",
    "SLE" to "Sierra-leonesche Leone",
    "SLL" to "Sierra-leonesche Leone (1964—2022)",
    "SOS" to "Somalia-Schilling",
    "SRD" to "Surinameschen Dollar",
    "SRG" to "Surinamesche Gulden",
    "SSP" to "Südsudanesescht Pond",
    "STD" to "São-toméeschen Dobra (1977–2017)",
    "STN" to "São-toméeschen Dobra",
    "SUR" to "Sowjetesche Rubel",
    "SVC" to "El-Salvador-Colón",
    "SYP" to "Syrescht Pond",
    "SZL" to "Swasilännesche Lilangeni",
    "THB" to "Thailännesche Baht",
    "TJR" to "Tadschikistan-Rubel",
    "TJS" to "Tadschikistan-Somoni",
    "TMM" to "Turkmenistan-Manat (1993–2009)",
    "TMT" to "Turkmenistan-Manat",
    "TND" to "Tuneseschen Dinar",
    "TOP" to "Tongaeschen Paʻanga",
    "TPE" to "Timor-Escudo",
    "TRL" to "Tierkesch Lira (1922–2005)",
    "TRY" to "Tierkesch Lira",
    "TTD" to "Trinidad-an-Tobago-Dollar",
    "TWD" to "Neien Taiwan-Dollar",
    "TZS" to "Tansania-Schilling",
    "UAH" to "Ukraineschen Hrywnja",
    "UAK" to "Ukrainesche Karbovanetz",
    "UGS" to "Uganda-Schilling (1966–1987)",
    "UGX" to "Uganda-Schilling",
    "USD" to "US-Dollar",
    "USN" to "US Dollar (Nächsten Dag)",
    "USS" to "US Dollar (Selwechten Dag)",
    "UYP" to "Uruguayesche Peso (1975–1993)",
    "UYU" to "Uruguayesche Peso",
    "UZS" to "Usbekistan-Sum",
    "VEB" to "Venezolanesche Bolívar (1871–2008)",
    "VEF" to "Venezolanesche Bolívar (2008–2018)",
    "VES" to "Venezolanesche Bolívar",
    "VND" to "Vietnameseschen Dong",
    "VUV" to "Vanuatu-Vatu",
    "WST" to "Samoaneschen Tala",
    "XAF" to "CFA-Frang (BEAC)",
    "XAG" to "Onze Sëlwer",
    "XAU" to "Onze Gold",
    "XBA" to "Europäesch Rechnungseenheet",
    "XBB" to "Europäesch Währungseenheet (XBB)",
    "XBC" to "Europäesch Rechnungseenheet (XBC)",
    "XBD" to "Europäesch Rechnungseenheet (XBD)",
    "XCD" to "Ostkaribeschen Dollar",
    "XDR" to "Sonnerzéiungsrecht",
    "XEU" to "Europäesch Währungseenheet (XEU)",
    "XFO" to "Franséische Gold-Frang",
    "XFU" to "Franséischen UIC-Frang",
    "XOF" to "CFA-Frang (BCEAO)",
    "XPD" to "Onz Palladium",
    "XPF" to "CFP-Frang",
    "XPT" to "Onz Platin",
    "XRE" to "RINET Funds",
    "XTS" to "Testwährung",
    "XXX" to "Onbekannt Währung",
    "YDD" to "Jemen-Dinar",
    "YER" to "Jemen-Rial",
    "YUD" to "Jugoslaweschen Dinar (1966–1990)",
    "YUM" to "Jugoslaweschen Neien Dinar (1994–2002)",
    "YUN" to "Jugoslaweschen Dinar (konvertibel)",
    "ZAL" to "Südafrikanesche Rand (Finanz)",
    "ZAR" to "Südafrikanesche Rand",
    "ZMK" to "Kwacha (1968–2012)",
    "ZMW" to "Kwacha",
    "ZRN" to "Zaire-Neien Zaïre (1993–1998)",
    "ZRZ" to "Zaire-Zaïre (1971–1993)",
    "ZWD" to "Simbabwe-Dollar (1980–2008)",
    "ZWL" to "Simbabwe-Dollar (2009)",
    "ZWR" to "Simbabwe-Dollar (2008)",
  ) }

  val lg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Diraamu eya Emireeti",
    "AOA" to "Kwanza ey’Angola",
    "AUD" to "Doola ey’Awusiturelya",
    "BHD" to "Dinaali ey’eBaareeni",
    "BIF" to "Faranga ey’eburundi",
    "BWP" to "Pula ey’eBotiswana",
    "CAD" to "Doola ey’eKanada",
    "CDF" to "Faranga ey’eKongo",
    "CHF" to "Faranga ey’eSwitizirandi",
    "CNY" to "Yuwani Reniminibi ey’eCayina",
    "CVE" to "Esikudo ey’Keepu Veredi",
    "DJF" to "Faranga ey’eJjibuti",
    "DZD" to "Dinaali ey’Aligerya",
    "EGP" to "Pawundi ey’eMisiri",
    "ERN" to "Nakifa ey’Eritureya",
    "ETB" to "Biiru ey’Esyopya",
    "EUR" to "Yuro",
    "GBP" to "Pawundi ey’eBungereza",
    "GHC" to "Sedi ey’eGana",
    "GMD" to "Dalasi ey’eGambya",
    "GNS" to "Faranga ey’eGini",
    "INR" to "Rupiya ey’eBuyindi",
    "JPY" to "Yeni ey’eJapani",
    "KES" to "Silingi ey’eKenya",
    "KMF" to "Faranga ey’eKomoro",
    "LRD" to "Doola ey’eLiberya",
    "LSL" to "Loti ey’eLesoso",
    "LYD" to "Dinaali ey’eLibya",
    "MAD" to "Diraamu ey’eMoroko",
    "MGA" to "Faranga ey’eMalagase",
    "MRO" to "Wugwiya ey’eMawritenya (1973–2017)",
    "MRU" to "Wugwiya ey’eMawritenya",
    "MUR" to "Rupiya ey’eMawurisyasi",
    "MWK" to "Kwaca ey’eMalawi",
    "MZM" to "Metikaali ey’eMozambiiki",
    "NAD" to "Doola ey’eNamibiya",
    "NGN" to "Nayira ey’eNayijerya",
    "RWF" to "Faranga ey’eRwanda",
    "SAR" to "Riyaali ey’eBuwarabu",
    "SCR" to "Rupiya ey’eSesere",
    "SDG" to "Dinaali ey’eSudaani",
    "SDP" to "Pawundi ey’eSudaani",
    "SHP" to "Pawundi ey’eSenti Herena",
    "SLE" to "Lewone",
    "SLL" to "Lewone (1964—2022)",
    "SOS" to "Silingi ey’eSomaliya",
    "STD" to "Dobura ey’eSantome ne Purincipe (1977–2017)",
    "STN" to "Dobura ey’eSantome ne Purincipe",
    "SZL" to "Lilangeni",
    "TND" to "Dinaali ey’eTunizya",
    "TZS" to "Silingi ey’eTanzaniya",
    "UGX" to "Silingi eya Yuganda",
    "USD" to "Doola ey’Amerika",
    "XAF" to "Faranga ey’omu Afirika eya wakati",
    "XOF" to "Faranga ey’omu Afirika ey’ebugwanjuba",
    "ZAR" to "Randi ey’eSawusafirika",
    "ZMK" to "Kwaca ey’eZambya (1968–2012)",
    "ZMW" to "Kwaca ey’eZambya",
    "ZWD" to "Doola ey’eZimbabwe",
  ) }

  val lij: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val lkt: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val lld: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham di Emirac Arabics Unis",
    "AFN" to "Afghani dl Afghanistan",
    "ALL" to "Lek dl’Albania",
    "AMD" to "Dram dl’Armenia",
    "ANG" to "Rainesc dles Antiles neerlandejes",
    "AOA" to "Kwanza dl Angola",
    "ARS" to "Peso dl’Argentina",
    "AUD" to "Dolar dl’Australia",
    "AWG" to "Florin d’Aruba",
    "AZN" to "Manat dl Azerbaijan",
    "BAM" to "March convertibl dla Bosnia y Herzegovina",
    "BBD" to "Dolar de Barbados",
    "BDT" to "Taka dl Bangladesc",
    "BGN" to "Lev dla Bulgaria",
    "BHD" to "Dinar dl Bahrain",
    "BIF" to "Franch dl Burundi",
    "BMD" to "Bermudan Dollar",
    "BND" to "Dolar dl Brunei",
    "BOB" to "Boliviano dla Bolivia",
    "BRL" to "Real dl Brasil",
    "BSD" to "Dolar dles Bahamas",
    "BTN" to "Ngultrum dl Bhutan",
    "BWP" to "Pula dl Botswana",
    "BYN" to "Rubl dla Belaruscia",
    "BZD" to "Dolar dl Belize",
    "CAD" to "Dolar dl Canada",
    "CDF" to "Franch dl Congo",
    "CHF" to "Franch dla Svizera",
    "CLP" to "Peso dl Cile",
    "CNH" to "Yuan dla Cina (offshore)",
    "CNY" to "Yuan dla Cina",
    "COP" to "Peso dla Colombia",
    "CRC" to "Colón dl Costa Rica",
    "CUC" to "Peso convertibl de Cuba",
    "CUP" to "Peso de Cuba",
    "CVE" to "Escudo de Capo Verde",
    "CZK" to "Corona dla Cechia",
    "DJF" to "Franch dl Djibouti",
    "DKK" to "Corona dla Danimarca",
    "DOP" to "Peso dla Republica Dominicana",
    "DZD" to "Dinar dl’Algeria",
    "EGP" to "Sterlina dl Egit",
    "ERN" to "Nakfa dl’Eritrea",
    "ETB" to "Birr dl’Etiopia",
    "EUR" to "Euro",
    "FJD" to "Dolar dles Fiji",
    "FKP" to "Sterlina dles Isoles Falkland",
    "GBP" to "Sterlina Britanica",
    "GEL" to "Lari dla Georgia",
    "GHS" to "Cedi dl Ghana",
    "GIP" to "Sterlina de Gibiltera",
    "GMD" to "Dalasi dl Gambia",
    "GNF" to "Franch dla Guinea",
    "GTQ" to "Quetzal dl Guatemala",
    "GYD" to "Dolar dla Guyana",
    "HKD" to "Dolar de Hong Kong",
    "HNL" to "Lempira dl Honduras",
    "HRK" to "Kuna dla Croazia",
    "HTG" to "Gourde de Haiti",
    "HUF" to "Forint dl’Ungaria",
    "IDR" to "Rupia dla Indonesia",
    "ILS" to "Shekel Nü d’Israel",
    "INR" to "Rupia dl’India",
    "IQD" to "Dinar dl Irak",
    "IRR" to "Rial dl Iran",
    "ISK" to "Corona dl’Islanda",
    "JMD" to "Dolar dla Giamaica",
    "JOD" to "Dinar dla Iordania",
    "JPY" to "Yen dl Iapan",
    "KES" to "Shilling dl Kenia",
    "KGS" to "Som dl Kyrgystan",
    "KHR" to "Riel dla Cambogia",
    "KMF" to "Franch dles Comores",
    "KPW" to "Won dla Corea dl Nord",
    "KRW" to "Won dla Corea dl Süd",
    "KWD" to "Dinar dl Kuwait",
    "KYD" to "Dolar dles Isoles Cayman",
    "KZT" to "Tenge dl Kazakhstan",
    "LAK" to "Kip dl Laos",
    "LBP" to "Lira dl Libanon",
    "LKR" to "Rupia dl Sri Lanka",
    "LRD" to "Dolar dla Liberia",
    "LSL" to "Loti dl Lesotho",
    "LYD" to "Dinar dla Libia",
    "MAD" to "Dirham dl Maroco",
    "MDL" to "Leu dla Moldavia",
    "MGA" to "Ariary dl Madagascar",
    "MKD" to "Denar dla Macedonia",
    "MMK" to "Kyat dl Myanmar",
    "MNT" to "Tugrik dla Mongolia",
    "MOP" to "Pataca de Macao",
    "MRU" to "Ouguiya dla Mauritania",
    "MUR" to "Rupia de Mauritius",
    "MVR" to "Rufiyaa dles Maldives",
    "MWK" to "Kwacha dl Malawi",
    "MXN" to "Peso dl Messich",
    "MYR" to "Ringgit dla Malesia",
    "MZN" to "Metical dl Mozambich",
    "NAD" to "Dolar dla Namibia",
    "NGN" to "Naira dl Nigeria",
    "NIO" to "Cordoba dl Nicaragua",
    "NOK" to "Corona dla Norvegia",
    "NPR" to "Rupia dl Nepal",
    "NZD" to "Dolar dla Nöia Zelanda",
    "OMR" to "Rial dl Oman",
    "PAB" to "Balboa de Panama",
    "PEN" to "Sol dl Perú",
    "PGK" to "Kina dla Papua Nöia Guinea",
    "PHP" to "Peso dles Filipines",
    "PKR" to "Rupia dl Pakistan",
    "PLN" to "Zloty dla Polonia",
    "PYG" to "Guaraní dl Paraguay",
    "QAR" to "Rial dl Qatar",
    "RON" to "Leu dla Romania",
    "RSD" to "Dinar dla Serbia",
    "RUB" to "Rubl dla Ruscia",
    "RWF" to "Franch dla Ruanda",
    "SAR" to "Rial dl’Arabia Saudita",
    "SBD" to "Dolar dles Isoles Salomon",
    "SCR" to "Rupia dles Seychelles",
    "SDG" to "Sterlina dl Sudan",
    "SEK" to "Corona dla Svezia",
    "SGD" to "Dolar de Singapur",
    "SHP" to "Sterlina de St. Helena",
    "SLE" to "Leone dla Sierra Leone",
    "SLL" to "Leone dla Sierra Leone (1964–2022)",
    "SOS" to "Shilling dla Somalia",
    "SRD" to "Dolar dl Surinam",
    "SSP" to "Sterlina dl Sudan dl Süd",
    "STN" to "Dobra de São Tomé y Príncipe",
    "SYP" to "Lira dla Siria",
    "SZL" to "Lilangeni dl Eswatini",
    "THB" to "Bath dla Thailandia",
    "TJS" to "Somoni dl Tajikistan",
    "TMT" to "Manat dl Turkmenistan",
    "TND" to "Dinar dla Tunisia",
    "TOP" to "Paʻanga dl Tonga",
    "TRY" to "Lira türca",
    "TTD" to "Dolar de Trinidad y Tobago",
    "TWD" to "Dolar Nü dl Taiwan",
    "TZS" to "Shilling dla Tanzania",
    "UAH" to "Grivnia dl’Ucraina",
    "UGX" to "Shilling dl’Uganda",
    "USD" to "Dolar di USA",
    "UYU" to "Peso dl Uruguay",
    "UZS" to "Sum dl Uzbekistan",
    "VES" to "bolívar dl Venezuela",
    "VND" to "Dong dl Vietnam",
    "VUV" to "Vatu de Vanuatu",
    "WST" to "Tala de Samoa",
    "XAF" to "Franch CFA dl’Africa zentrala",
    "XCD" to "Dolar di Caraibi orientai",
    "XOF" to "Franch CFA dl’Africa ozidentala",
    "XPF" to "Franch CFP",
    "XXX" to "Valüta nia conesciüda",
    "YER" to "Rial dl Yemen",
    "ZAR" to "Rand dl Südafrica",
    "ZMW" to "Kwacha dl Zambia",
  ) }

  val lmo: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ln: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirihamɛ ya Lémila alabo",
    "AOA" to "Kwanza ya Angóla",
    "AUD" to "Dolarɛ ya Ositali",
    "BHD" to "Dinarɛ ya Bahrɛnɛ",
    "BIF" to "Falánga ya Burundi",
    "BWP" to "Pula ya Botswana",
    "CAD" to "Dolarɛ ya Kanadá",
    "CDF" to "Falánga ya Kongó",
    "CHF" to "Falánga ya Swisɛ",
    "CNY" to "Yuanɛ Renminbi ya Sinɛ",
    "CVE" to "Esikudo ya Kapevɛrɛ",
    "DJF" to "Falánga ya Dzibuti",
    "DZD" to "Dinarɛ ya Alizeri",
    "EGP" to "Paunɛ ya Ezípitɛ",
    "ERN" to "Nakfa ya Elitlɛ",
    "ETB" to "Birɛ ya Etsiópi",
    "EUR" to "Ɛlɔ́",
    "GBP" to "Paunɛ ya Angɛlɛtɛ́lɛ",
    "GHC" to "Sedi ya Gana",
    "GMD" to "Dalasi ya Gambi",
    "GNS" to "Falánga ya Ginɛ",
    "INR" to "Rupi ya Índɛ",
    "JPY" to "Yeni ya Zapɔ",
    "KES" to "Shilingɛ ya Kenya",
    "KMF" to "Falánga ya Komoro",
    "LRD" to "Dolarɛ ya Liberya",
    "LSL" to "Loti ya Lesóto",
    "LYD" to "Dinarɛ ya Libí",
    "MAD" to "Dirihame ya Marokɛ",
    "MGA" to "Falánga ya Madagasikarɛ",
    "MRO" to "Ugwiya ya Moritani (1973–2017)",
    "MRU" to "Ugwiya ya Moritani",
    "MUR" to "Rupi ya Morisi",
    "MWK" to "Kwasha ya Malawi",
    "MZM" to "Metikali ya Mozambiki",
    "NAD" to "Dolarɛ ya Namibi",
    "NGN" to "Naira ya Nizerya",
    "RWF" to "Falánga ya Rwanda",
    "SAR" to "Riyalɛ ya Alabi Sawuditɛ",
    "SCR" to "Rupi ya Sɛshɛlɛ",
    "SDG" to "Dinarɛ ya Sudá",
    "SDP" to "Paunɛ ya Sudá",
    "SHP" to "Paunɛ ya Sántu elena",
    "SLE" to "Leonɛ",
    "SLL" to "Leonɛ (1964—2022)",
    "SOS" to "Shilingɛ ya Somali",
    "STD" to "Dobra ya Sao Tomé mpé Presipe (1977–2017)",
    "STN" to "Dobra ya Sao Tomé mpé Presipe",
    "SZL" to "Lilangeni",
    "TND" to "Dinarɛ ya Tinizi",
    "TZS" to "Shilingɛ ya Tanzani",
    "UGX" to "Shilingɛ ya Uganda",
    "USD" to "Dolarɛ ya Ameriki",
    "XAF" to "Falánga CFA BEAC",
    "XOF" to "Falánga CFA BCEAO",
    "ZAR" to "Randɛ ya Afríka Súdi",
    "ZMK" to "Kwasha ya Zambi (1968–2012)",
    "ZMW" to "Kwasha ya Zambi",
    "ZWD" to "Dolarɛ ya Zimbabwɛ",
  ) }

  val ln_AO: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ln_CF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ln_CG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val lo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "ເປເຊຕາ ອັນໂດລາ",
    "AED" to "ສະ​ຫະ​ລັດ​ອາ​ຣັບ​ອາ​ມິ​ເຣດ ເດີ​ແຮມ",
    "AFA" to "ອັບການິ ອັບການິສະຖານ (1927–2002)",
    "AFN" to "ອັຟ​ກັນ ອັຟ​ກາ​ນິ",
    "ALL" to "ອັລ​ບາ​ນຽນ ເລກ",
    "AMD" to "ອາ​ເມ​ນຽນ ແດຣມ",
    "ANG" to "ເນ​ເທີ​ແລນ ແອນ​ຕິ​ລຽນ ກິວ​ເດີ",
    "AOA" to "ແອງ​ໂກ​ລັນ ຄວນ​ຊາ",
    "AOK" to "ກວານຊາ ແອງໂກລາ (1977–1991)",
    "AON" to "ກວານຊາ ແອງໂກລາ ໃໝ່ (1995–1999)",
    "AOR" to "ກວານຊາກທີ່ແກ້ໄຂໃໝ່ ແອງກູລາ (1995–1999)",
    "ARA" to "ອອສຕຣານ ອາກຊັງຕິນ",
    "ARL" to "ເປໂຊເລ ອາກຊັງຕິນ (1970–1983)",
    "ARM" to "ເປໂຊ ອາກຊັງຕິນ (1881–1970)",
    "ARP" to "ເປໂຊ ອາກຊັງຕິນ (1983–1985)",
    "ARS" to "ອາ​ເຈນ​ທິ​ນາ ເປ​ໂຊ",
    "ATS" to "ຊິລລິງ ອົດສະຕາລີ",
    "AUD" to "ອອສ​ເຕຣ​ລຽນ ໂດ​ລ່າ",
    "AWG" to "ອະຣູແບນ ຟລໍຣິນ",
    "AZM" to "ມານັດ ອາແຊກບາຍຊານ (1993–2006)",
    "AZN" to "ອາ​ເຊີ​ໄບ​ຈາ​ນິ ມາ​ນັດ",
    "BAD" to "ດີນາ ບອສເນຍ ເຮີເຊໂບວາເນຍ (1992–1994)",
    "BAM" to "ບອ​ສ​ເນຍ-ເຮີ​ເຊ​ໂກວິ​ນາ ຄອນ​ເວີດ​ຕິ​ໂບ ມາກ",
    "BAN" to "ດີນາໃໝ່ ບອສເນຍ ເຮີເຊໂບວີນາ(1994–1997)",
    "BBD" to "ໂດລ່າ ບາບາດຽນ",
    "BDT" to "ບັງ​ຄລາ​ເທດ ຕາ​ກາ",
    "BEC" to "ຟຣັງ ບູນກາລີ (ປ່ຽນແປງໄດ້)",
    "BEF" to "ຟຣັງ ບູນກາລີ",
    "BEL" to "ຟຣັງ ບູນກາລີ (ການເງິນ)",
    "BGL" to "ຮາດເລບ ບູນກາລີ",
    "BGM" to "ເລບ ສັງຄົມບູນກາລີ",
    "BGN" to "ບັງ​ກາ​ຣຽນ ເລບ",
    "BGO" to "ເລບ ບູນກາລີ (1879–1952)",
    "BHD" to "ບາ​ໄຣ​ນິ ດິ​ນາ",
    "BIF" to "ບຸ​ຣັນ​ດຽນ ຟຣັງ",
    "BMD" to "ໂດ​ລ່າ​ເບີ​ມິວ​ດາ",
    "BND" to "ບຣູ​ໄນ ໂດ​ລ່າ",
    "BOB" to "ໂບ​ລິ​ວຽນ ໂບ​ລິ​ເວຍ​ໂນ",
    "BOL" to "ໂລລິເວຍໂນ ໂລລິເວຍ (1863–1963)",
    "BOP" to "ເປໂຊໂລລິເວຍ",
    "BOV" to "ມະດອນ ໂລລິເວຍ",
    "BRB" to "ກຣູເຊໂດບາຊິ ໃໝ່ (1967–1986)",
    "BRC" to "ກຣູຊາໂດບາຊິວ (1986–1989)",
    "BRE" to "ກຣູເຊໂຣ ບາຊິ ກຣູໂຊ ບາຊິວ (1993–1994)",
    "BRL" to "ບຣາ​ຊິ​ລຽນ ຣຽວ",
    "BRN" to "ກຣູຊາໂດ ບາຊິວ ໃໝ່ (1989–1990)",
    "BRR" to "ກຣູເຊໂຣ ບາຊິວ (1993–1994)",
    "BRZ" to "ກຣູເຊໂຣ ບາຊິວ (1942–1967)",
    "BSD" to "ໂດລ່າ ບາຮາມຽນ",
    "BTN" to "ພູ​ຖານ ງຸນດຣັມ",
    "BUK" to "ຈາດ ພະມ້າ",
    "BWP" to "ບອດ​ສະ​ວາ​ນານ ພູ​ລາ",
    "BYB" to "ຣູໂບ ເບຣາຣຸສ ໃໝ່(1994–1999)",
    "BYN" to "ເບ​ລາ​ຣຸ​ສ​ຊຽນ ຣູ​ເບິນ",
    "BYR" to "ເບ​ລາ​ຣຸ​ສ​ຊຽນ ຣູ​ເບິນ (2000–2016)",
    "BZD" to "ໂດ​ລ່າ​ເບ​ລີຊ",
    "CAD" to "ໂດລ່າແຄນາດາ",
    "CDF" to "ຄອງ​ໂກ​ລີສ ຟຣັງ",
    "CHE" to "ເອີໂຣ WIR",
    "CHF" to "ສະ​ວິ​ສ ຟ​ຣັງ",
    "CHW" to "ຟຣັງ WIR",
    "CLE" to "ເອສກູໂດ ຊິລີ",
    "CLF" to "ຫົວໜ່ວຍບັນຊີ (UF) ຊິລີ",
    "CLP" to "ຊິ​ລຽນ ເປ​ໂຊ",
    "CNH" to "ຢວນຈີນ (ນອກປະເທດ)",
    "CNY" to "ຈີນ ຢວນ",
    "COP" to "ໂຄ​ລົມ​ບຽນ ເປ​ໂຊ",
    "COU" to "ຫົວໜ່ວຍຄ່າຈິງ ໂຄລັມເບຍ",
    "CRC" to "ໂຄສຕາ ຣິກັນ ໂຄລອນ",
    "CSD" to "ດີນາ ເຊີເບຍ (2002–2006)",
    "CSK" to "ຮາດໂກຣູນາ ເຊັກໂກສະໂລວັກ",
    "CUC" to "ຄິວແບນ ຄອນເວີດຕິໂບ ເປໂຊ",
    "CUP" to "ຄິວແບນ ເປໂຊ",
    "CVE" to "ເຄບ ເວີດ​ດີນ ເອ​ສ​ຄູ​ໂດ",
    "CYP" to "ປອນ ໄຊປຣັດ",
    "CZK" to "ເຊກ ໂຄ​ຣູ​ນາ",
    "DDM" to "ມາກ ເຢຍລະມັນ ຕາເວັນອອກ",
    "DEM" to "ມາກ ເຢຍລະມັນ",
    "DJF" to "​ດິ​ບູ​ຈຽນ ຟຣັງ",
    "DKK" to "ແດນ​ນິ​ຊ ໂຄຣນ",
    "DOP" to "ໂດ​ມິ​ນິ​ກັນ ເປ​ໂຊ",
    "DZD" to "ອັລ​ເຈີ​ຣຽນ ດິ​ນາ",
    "ECS" to "ຊູເກ ເອກາວາດໍ",
    "ECV" to "ຫົວໜ່ວຍຄ່າຄົງທີ່ຂອງເອກາວາດໍ",
    "EEK" to "ຄຣູນເອສ ໂຕເນຍ",
    "EGP" to "ອີ​ຢິບ​ທຽນ ພາວດ໌",
    "ERN" to "ອິ​ຣິ​ທຣຽນ ແນກ​ຟ​າ",
    "ESA" to "ເປເຊຕາສະເປັນ (ບັນຊີ)",
    "ESB" to "ເປເຊຕາສະເປນ (ປ່ຽນແປງໄດ້)",
    "ESP" to "ເປເຊຕາ ສະເປນ",
    "ETB" to "ເອ​ທິ​ໂອ​ປຽນ ເບີ​ຣ໌",
    "EUR" to "ຢູ​ໂຣ",
    "FIM" to "ມາກກາ ຟິນແລນ",
    "FJD" to "ຟິ​ຈຽນ ໂດ​ລ່າ",
    "FKP" to "ຟອ​ລ໌ກ​ແລນ ໄອ​ແລນ​ສ໌ ພາວ​ດ໌",
    "FRF" to "ຟຣັງ ຝຣັ່ງ",
    "GBP" to "ອັງກິດ ປອນ",
    "GEK" to "ກູປອນ ລາຣິທ ຈໍເຈຍ",
    "GEL" to "ຈໍ​ຈຽນ ລາ​ຣິ",
    "GHC" to "ເຊດີ ການາ (1979–2007)",
    "GHS" to "ກາ​ນາ​ອຽນ ເຊ​ດິ",
    "GIP" to "ກິບ​ຣາ​ທາ ພາ​ວດ໌",
    "GMD" to "​ແກມ​ບຽນ ດາ​ລາ​ຊິ",
    "GNF" to "ກິ​ນຽນ ຟຣັງ",
    "GNS" to "ໄຊລິ ກີນີ",
    "GQE" to "ເອັກເວເລ ອີຄວາຕິຣຽວ ກິນີ",
    "GRD" to "ດາກຊະມາ ເກຣັກ",
    "GTQ" to "ກົວເຕມາລານ ເຄັດຊອນ",
    "GWE" to "ເອສກູໂດ ກີນີໂປຕູເກດ",
    "GWP" to "ເປໂຊກິນີ-ບິສເຊົາ",
    "GYD" to "ກາຍ​ຢາ​ນີ​ສ ໂດ​ລ່າ",
    "HKD" to "ຮອງ​ກົງ ໂດ​ລ່າ",
    "HNL" to "ຮອນດູແຣນ ເລມພິຣາ",
    "HRD" to "ດີນາ ໂຄຣເອເຊຍ",
    "HRK" to "ໂຄຣ​ເອ​ທຽນ ຄູ​ນາ",
    "HTG" to "ໄຮ​ຕຽນ ກົວ​ເດ",
    "HUF" to "ຮັງ​ກາ​ຣຽນ ຟໍ​ຣິນ",
    "IDR" to "ອິນ​ໂດ​ເນ​ຊຽນ ໂດ​ລ່າ",
    "IEP" to "ປອນ ໄອຣິຊ",
    "ILP" to "ປອນ ອີສະລາເອວ",
    "ILS" to "ອິສ​ຣາ​ເອວ​ລິ ນິວ ເຊ​ເກວ",
    "INR" to "ອິນ​ເດຍ ຣູ​ປີ",
    "IQD" to "ອິ​ຣັກ​ກິ ດິ​ນາ",
    "IRR" to "ອິ​ຣາ​ນິ ຣຽວ",
    "ISK" to "ໄອ​ສ໌​ແລນ​ດິກ ໂຄຣ​ນາ",
    "ITL" to "ລິຣາ ອີຕາລີ",
    "JMD" to "​ຈາ​ໄມ​ກັນ ໂດ​ລ່າ",
    "JOD" to "ຈໍ​ແດ​ນຽນ ດິ​ນາ",
    "JPY" to "ຍີ່​ປຸ່ນ ເຢນ",
    "KES" to "ເຄນ​ຢັນ ຊິວ​ລິງ",
    "KGS" to "ຄ​ຣີ​ກິສ​​ຖາ​ນິ ໂຊມ",
    "KHR" to "ກຳ​ປູ​ເຈຍ ຣຽວ",
    "KMF" to "ໂຄ​ໂມ​ຣຽນ ຟຣັງ",
    "KPW" to "ເກົາ​ຫລີ​ເໜືອ ວອນ",
    "KRH" to "ຮາວານ ເກົາຫຼີເນື້",
    "KRO" to "ວອນ ເກົາຫຼີໃຕ້ (1945–1953)",
    "KRW" to "ເກົາ​ຫລີໃຕ້ ວອນ",
    "KWD" to "ຄູ​ເວ​ຕິ ດິ​ນາ",
    "KYD" to "ເຄ​ແມນ ໄອ​ແລນ ໂດ​ລ່າ",
    "KZT" to "ຄາ​ຊັກ​ສະ​ຖາ​ນິ ເຕັງ​ເຈ",
    "LAK" to "ລາວ ກີບ",
    "LBP" to "ເລ​ບາ​ນີ​ສ ພາວດ໌",
    "LKR" to "ສີ​ລັງ​ກາ ຣູ​ປີ",
    "LRD" to "ລິ​ເບີ​ຣຽນ ໂດ​ລ່າ",
    "LSL" to "ໂລຕິ ເລໂຊໂຕ",
    "LTL" to "ລິ​ທົວ​ນຽນ ລິ​ທັ​ສ",
    "LTT" to "ທາໂລນັສ ລິທົວເນຍ",
    "LUC" to "ຟຣັງ ລຸກຊຳບວກ ທີ່ປ່ຽນແປງ",
    "LUF" to "ຟຣັງ ລຸກຊຳບວກ",
    "LUL" to "ຟຣັງ ລຸກຊຳບວກ ການເງິນ",
    "LVL" to "ລັດ​ວຽນ ລັດ​ສ໌",
    "LVR" to "ຣູໂບ ລາວຽນ",
    "LYD" to "ລິບ​ບຽນ ດິ​ນາ",
    "MAD" to "ມໍ​ຣັອກ​ແຄນ​ ເດີ​ແຮມ",
    "MAF" to "ຟຣັງ ໂມຣອກໂກ",
    "MCF" to "ຟຣັງ ໂມດາໂກ",
    "MDC" to "ບັດປັນສ່ວນ ມອງໂດວາ",
    "MDL" to "ມອນ​ໂດ​ແວນ ເລ​ອູ",
    "MGA" to "ມາ​ລາ​ກາ​ຊີ ອາ​ເຣຍ​ຣີ",
    "MGF" to "ຟຣັງ ມາດາກັດສະກາ",
    "MKD" to "ແມັກ​ເຊ​ໂດ​ນຽນ ເດ​ນາ",
    "MKN" to "ດີນາ ມາຊີໂດເນຍ (1992–1993)",
    "MLF" to "ຟຣັງ ມາລີ",
    "MMK" to "ມຽນ​ມາ ຈ໊າດ",
    "MNT" to "ມອງ​ໂກ​ລຽນ ຕູກຣິກ",
    "MOP" to "ມາ​ເກົ້າ ປາ​​ຕາ​ກາ",
    "MRO" to "ມົວ​ຣິ​ທາ​ນຽນ ອູ​ກິວ​ຢາ (1973–2017)",
    "MRU" to "ມົວ​ຣິ​ທາ​ນຽນ ອູ​ກິວ​ຢາ",
    "MTL" to "ລິຣາ ມອນຕາ",
    "MTP" to "ປອນ ມອນຕາ",
    "MUR" to "ເມົາ​ຣິ​ທຽນ ຣູ​ປີ",
    "MVR" to "ມັ​ລ​ດິ​ວຽນ ຣູ​ຟິ​ຢາ",
    "MWK" to "ມາ​ລາ​ວຽນ ຄວາ​ຊາ",
    "MXN" to "ເມັກຊິກັນ ເປໂຊ",
    "MXP" to "ຫົວໜ່ວຍເງິນ ເປໂຊ ແມັກຊິໂກ(1861–1992)",
    "MXV" to "ຫົວໜ່ວຍການລົງທຶນ ແມັກຊິໂກ",
    "MYR" to "ມາ​ເລ​ເຊຍ ຣິງ​ກິດ",
    "MZE" to "ເອສກູໂດ ໂມຊຳບິກ",
    "MZM" to "ເມຕິຄໍ ໂມຊຳບິກ (1980–2006)",
    "MZN" to "ໂມ​ແຊມ​ບິ​ກັນ ເມ​ທິ​ຄອນ",
    "NAD" to "ນາ​ມິ​ບຽນ ໂດ​ລ່າ",
    "NGN" to "ໄນ​ຣາ ​ໄນເຈີ​ຣຽນ",
    "NIC" to "ຄໍໂດບາ ນິກາຣາກົວ (1988–1991)",
    "NIO" to "ນິກາຣາກວນ ໂຄໂດບາ",
    "NLG" to "ກິລເດີ ເນເທີແລນ",
    "NOK" to "ນໍ​ເວ​ຈຽນ ​ໂຄຣນ",
    "NPR" to "ເນ​ປານ ຣູ​ປີ",
    "NZD" to "ນິວ​ຊີ​ແລນ ໂດ​ລ່າ",
    "OMR" to "ໂອ​ມາ​ນິ ຣຽວ",
    "PAB" to "ພານາມານຽນ ບອນບົວ",
    "PEI" to "ອິນຕິ ເປຣູ",
    "PEN" to "ເປ​ຣູ​ວຽນ ໂຊ​ລ໌",
    "PES" to "ໂຊນ ເປຣູ (1863–1965)",
    "PGK" to "ປາ​ປົວ ນິວ ກິ​ນຽນ ກິ​ນາ",
    "PHP" to "ຟິ​ລິບ​ປິນ ເປ​ໂຊ",
    "PKR" to "ປາ​ກິ​ສຖານ ຣູ​ປີ",
    "PLN" to "ໂປ​ລິ​ຊ ຊະ​ລໍ​ຕີ",
    "PLZ" to "ຊະລອສຕີ ໂປແລນ (1950–1995)",
    "PTE" to "ເອສກູໂດ ໂປຕູເກສ",
    "PYG" to "ກວາຣານີ ປາຣາກວາຍ",
    "QAR" to "ຄາ​ຕາ​ຣິ ຣຽວ",
    "RHD" to "ດອນລາ ໂຣດີເຊຍ",
    "ROL" to "ລິວ ໂຣມາເນຍເກົ່າ",
    "RON" to "ໂຣ​ມາ​ນຽນ ເລ​ອູ",
    "RSD" to "ເຊີ​ບຽນ ດິ​ນາ",
    "RUB" to "ຣັສ​ຊຽນ ຣູ​ເບິນ",
    "RUR" to "ຣູໂບ ຣັດເຊຍ (1991–1998)",
    "RWF" to "ຣະ​ວັນ​ດັນ ຟຣັງ",
    "SAR" to "ຊາ​ອູ​ດິ ຣິ​ຢອນ",
    "SBD" to "ໂຊ​ໂລມອນ ໄອ​ແລນ ໂດ​ລ່າ",
    "SCR" to "ເຊ​ເຊວ​ລອຍ​ສ໌ ຣູ​ປີ",
    "SDD" to "ດີນາ ຊູດານເກົ່າ",
    "SDG" to "ຊູ​ດານ​ນີ​ສ ພາວດ໌",
    "SDP" to "ປອນ ຊູດານເກົ່າ",
    "SEK" to "ສະ​ວີ​ດິ​ຊ ໂຄຣ​ນາ",
    "SGD" to "ສິງ​ກະ​ໂປ ໂດ​ລ່າ",
    "SHP" to "ເຊນ ເຮ​ເລ​ນາ ພາວດ໌",
    "SIT" to "ໂຕລາ ສະໂລວິເນຍ",
    "SKK" to "ຄູໂຣນາ ສະໂລວັກ",
    "SLE" to "ເຊຍ​ນາ ​ເລໂອ​ນຽນ ເລ​ໂອນ",
    "SLL" to "ເຊຍ​ນາ ​ເລໂອ​ນຽນ ເລ​ໂອນ (1964—2022)",
    "SOS" to "ໂຊ​ມາ​ລິ ຊິວ​ລິງ",
    "SRD" to "ຊູ​ຣິ​ນາ​ມີ​ສ ໂດ​ລ່າ",
    "SRG" to "ກິລເດີ ຊູຣິນາເມ",
    "SSP" to "ເຊົາ​ທ໌ ຊູ​ດານ​ນີ​ສ ພາວດ໌",
    "STD" to "ເຊົາ ໂທ​ເມ ແອນ ພ​ຣິນ​ຊິ​ປີ ໂດບຣາ (1977–2017)",
    "STN" to "ເຊົາ ໂທ​ເມ ແອນ ພ​ຣິນ​ຊິ​ປີ ໂດບຣາ",
    "SUR" to "ຣູໂບ ໂຊວຽດ",
    "SVC" to "ໂກລອງ ເອກາວາດໍ",
    "SYP" to "ຊີ​ຣຽນ ພາວດ໌",
    "SZL" to "ສະ​ວາ​ຊິ ລິ​ລັນ​ກິ​ນີ",
    "THB" to "ໄທ ບາດ",
    "TJR" to "ຣູໂບ ຕັຈີກິສຖານ",
    "TJS" to "ທາ​ຈິ​ກິ​​ຖາ​ນິ ໂຊ​ໂມ​ນິ",
    "TMM" to "ມານັດ ຕວກເມນິສຖານ (1966–1987)",
    "TMT" to "ເຕີກ​ເມ​ນິ​ສ​ຖາ​ນິ ມາ​ນັດ",
    "TND" to "ຕູ​ນິ​ຊຽນ ດິ​ນາ",
    "TOP" to "ຕອງ​ກັນ ປາ​ອັງ​ກາ",
    "TPE" to "ເອສກູໂດ ຕີມໍ",
    "TRL" to "ລີຕາ ຕູຣາກີເກົ່າ",
    "TRY" to "ເຕີ​ກິ​ຊ ລິ​ຣາ",
    "TTD" to "ທ​ຣິ​ນິ​ແດດ & ໂທ​ບາ​ໂກ ໂດ​ລ່າ",
    "TWD" to "ນິວ ໄຕ້​ຫວັນ ໂດ​ລ່າ",
    "TZS" to "ທານ​ຊາ​ນຽນ ຊິວ​ລິງ",
    "UAH" to "ຢູ​ເຄຣ​ນຽນ ຮະ​ຣີບ​ເນຍ",
    "UAK" to "ຄາໂບວາເນດ ອູແກຣນ",
    "UGS" to "ຊິນລິງ ອູກັນດາ (1966–1987)",
    "UGX" to "ອູ​ກັນ​ດັນ ຊິວ​ລິງ",
    "USD" to "​ໂດ​ລ່າ​ສະ​ຫະ​ລັດຯ",
    "USN" to "ດອນລາສະຫະລັດ (ມື້ຖັດໄປ)",
    "USS" to "ດອນລາສະຫະລັດ (ມື້ດຽວກັນ)",
    "UYI" to "ເປໂຊອູຣຸກວຍ (ຫົວໜ່ວຍອິນເດັກ)",
    "UYP" to "ເປໂຊ ອູຣຸກວຍ (1975–1993)",
    "UYU" to "ອູ​ຣຸ​ກົວ​ຢານ ເປ​ໂຊ",
    "UZS" to "ອຸສເບກິສຖານິ ໂຊມ",
    "VEB" to "ໂບລີວາ ເວເນຊູເອລາ (1871–2008)",
    "VEF" to "ເວ​ເນ​ຊູ​ເອ​ລັນ ໂບ​ລິ​ວາ (2008–2018)",
    "VES" to "ເວ​ເນ​ຊູ​ເອ​ລັນ ໂບ​ລິ​ວາ",
    "VND" to "ຫວຽດ​ນາມ ດົງ",
    "VNN" to "ດົງ ຫວຽດນາມ (1978–1985)",
    "VUV" to "​ວາ​ນົວ​ຕູ ວາ​ຕູ",
    "WST" to "ຊາ​ໂມນ ທາ​ລາ",
    "XAF" to "ສາທາລະນະລັດອາຟຣິກາກາງ",
    "XAG" to "ເງິນ",
    "XAU" to "ຄຳ",
    "XBA" to "ຫົວໜ່ວຍຄອມໂປຊິດ ເອີຣົບ",
    "XBB" to "ຫົວໜ່ວຍໂມນີແທຣີ ເອີຣົບ",
    "XBC" to "ຫົວໜ່ວຍບັນຊີເອີຣົບ (XBC)",
    "XBD" to "ຫົວໜ່ວຍບັນຊີເອີຣົບ (XBD)",
    "XCD" to "ອີ​ສ ຄາ​ຣິ​ບຽນ ໂດ​ລ່າ",
    "XDR" to "ສິດທິຖອນເງິນພິເສດ",
    "XEU" to "ຫົວໜ່ວຍສະກຸນເງິນ ເອີຣົບ",
    "XFO" to "ຟຣັງ ຄຳຝຣັ່ງ",
    "XFU" to "ຟຣັງ ຢູໄອຊີ ຝຣັ່ງ",
    "XOF" to "ຟັງເຊຟານ ອາຟຣິກາຕາເວັນຕົກ",
    "XPD" to "ແພເລດຽມ",
    "XPF" to "ຊີ​ເອັບ​ພີ ຟຣັງ",
    "XPT" to "ແພລັດຕິນຳ",
    "XRE" to "ກອງທຶນໄຣເນັດ",
    "XTS" to "ລະຫັດທົດສອບສະກຸນເງິນ",
    "XXX" to "ສະກຸນເງິນທີ່ບໍ່ຮູ້ຈັກ",
    "YDD" to "ດີນາ ເຢເມນ",
    "YER" to "ເຢ​ເມ​ນິ ຣຽວ",
    "YUD" to "ຮາດດີນາ ຢູໂກສະລາວີ",
    "YUM" to "ດີນາໃໝ່ ຢູໂກສະລາວີ (1994–2002)",
    "YUN" to "ດີນາ ທີ່ປ່ຽນສະພາບ ຢູໂກສະລາວີ (1990–1992)",
    "YUR" to "ດີນາ ປະຕິຮູບ ຢູໂກສະລາວີ (1992–1993)",
    "ZAL" to "ແຣນ ອາຟຣິກາໃຕ້ (ການເງິນ)",
    "ZAR" to "ເຊົາທ໌ ອາ​ຟຣິ​ກັນ ແຣນດ໌",
    "ZMK" to "ຄວາຊາ ຊັມເບຍ (1968–2012)",
    "ZMW" to "ແຊມ​ບຽນ ຄວາ​ຊາ",
    "ZRN" to "ແຊ ຄອງໂກໃໝ່",
    "ZRZ" to "ແຊຄອງໂກ",
    "ZWD" to "ດອນລາ ຊິມບັບເວ (1980–2008)",
    "ZWL" to "ດອນລາ ຊິມບັບເວ (2009)",
    "ZWR" to "ດອນລາ ຊິມບັບເວ (2008)",
  ) }

  val lrc: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "رئال بئرئزیل",
    "CNY" to "یوان چین",
    "EUR" to "یورو",
    "GBP" to "پوند بئریتانیا",
    "INR" to "روٙپیه هئن",
    "JPY" to "یئن جاپوٙن",
    "RUB" to "روٙبل روٙسیه",
    "XXX" to "پیل نادیار",
  ) }

  val lrc_IQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val lt: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andoros peseta",
    "AED" to "Jungtinių Arabų Emyratų dirhamas",
    "AFA" to "Afganistano afganis (1927–2002)",
    "AFN" to "Afganistano afganis",
    "ALK" to "Albanijos lekas (1946–1965)",
    "ALL" to "Albanijos lekas",
    "AMD" to "Armėnijos dramas",
    "ANG" to "Olandijos Antilų guldenas",
    "AOA" to "Angolos kvanza",
    "AOK" to "Angolos kvanza (1977–1990)",
    "AON" to "Angolos naujoji kvanza (1990–2000)",
    "AOR" to "Angolos patikslinta kvanza (1995–1999)",
    "ARA" to "Argentinos australs",
    "ARL" to "Argentinos pesos ley (1970–1983)",
    "ARM" to "Argentinos pesai (1881–1970)",
    "ARP" to "Argentinos pesas (1983–1985)",
    "ARS" to "Argentinos pesas",
    "ATS" to "Austrijos šilingas",
    "AUD" to "Australijos doleris",
    "AWG" to "Arubos guldenas",
    "AZM" to "Azerbaidžano manatas (1993–2006)",
    "AZN" to "Azerbaidžano manatas",
    "BAD" to "Bosnijos ir Hercegovinos dinaras (1992–1994)",
    "BAM" to "Bosnijos ir Hercegovinos konvertuojamoji markė",
    "BAN" to "Bosnijos ir Hercegovinos naujasis dinaras (1994–1997)",
    "BBD" to "Barbadoso doleris",
    "BDT" to "Bangladešo taka",
    "BEC" to "Belgijos frankas (konvertuojamas)",
    "BEF" to "Belgijos frankas",
    "BEL" to "Belgijos frankas (finansinis)",
    "BGL" to "Bulgarijos levas (1962–1999)",
    "BGM" to "Bulgarų socialistų leva",
    "BGN" to "Bulgarijos levas",
    "BGO" to "Bulgarijos levas (1879–1952)",
    "BHD" to "Bahreino dinaras",
    "BIF" to "Burundžio frankas",
    "BMD" to "Bermudos doleris",
    "BND" to "Brunėjaus doleris",
    "BOB" to "Bolivijos bolivijanas",
    "BOL" to "Bolivijos bolivijanas (1863–1963)",
    "BOP" to "Bolivijos pesas",
    "BOV" to "Bolivijos mvdol",
    "BRB" to "Brazilijos naujieji kruzeirai (1967–1986)",
    "BRC" to "Brazilijos kruzadai (1986–1989)",
    "BRE" to "Brazilijos kruzeiras (1990–1993)",
    "BRL" to "Brazilijos realas",
    "BRN" to "Brazilijos naujiejis kruzadai (1989–1990)",
    "BRR" to "Brazilijos kruzeiras (1993–1994)",
    "BRZ" to "Brazilijos kruzeirai (1942–1967)",
    "BSD" to "Bahamų doleris",
    "BTN" to "Butano ngultrumas",
    "BUK" to "Birmos kijatas",
    "BWP" to "Botsvanos pula",
    "BYB" to "Baltarusijos naujasis rublis (1994–1999)",
    "BYN" to "Baltarusijos rublis",
    "BYR" to "Baltarusijos rublis (2000–2016)",
    "BZD" to "Belizo doleris",
    "CAD" to "Kanados doleris",
    "CDF" to "Kongo frankas",
    "CHE" to "WIR eurai",
    "CHF" to "Šveicarijos frankas",
    "CHW" to "WIR frankas",
    "CLE" to "Čilės eskudai",
    "CLF" to "Čiliečių unidades de fomentos",
    "CLP" to "Čilės pesas",
    "CNH" to "Kinijos Užsienio juanis",
    "CNX" to "Kinijos \"People\" banko doleris",
    "CNY" to "Kinijos ženminbi juanis",
    "COP" to "Kolumbijos pesas",
    "COU" to "unidad de valor realai",
    "CRC" to "Kosta Rikos kolonas",
    "CSD" to "Serbijos dinaras (2002–2006)",
    "CSK" to "Čekoslovakų sunkusis korunas",
    "CUC" to "Kubos konvertuojamasis pesas",
    "CUP" to "Kubos pesas",
    "CVE" to "Žaliojo Kyšulio eskudas",
    "CYP" to "Kipro svaras",
    "CZK" to "Čekijos krona",
    "DDM" to "Rytų Vokietijos markė",
    "DEM" to "Vokietijos markė",
    "DJF" to "Džibučio frankas",
    "DKK" to "Danijos krona",
    "DOP" to "Dominikos pesas",
    "DZD" to "Alžyro dinaras",
    "ECS" to "Ekvadoro sukrė",
    "ECV" to "Ekvadoro constante (UVC)",
    "EEK" to "Estijos krona",
    "EGP" to "Egipto svaras",
    "ERN" to "Eritrėjos nakfa",
    "ESA" to "Ispanų pesetai (A sąskaita)",
    "ESB" to "Ispanų pesetai (konvertuojama sąskaita)",
    "ESP" to "Ispanijos peseta",
    "ETB" to "Etiopijos biras",
    "EUR" to "Euras",
    "FIM" to "Suomijos markė",
    "FJD" to "Fidžio doleris",
    "FKP" to "Falklando salų svaras",
    "FRF" to "Prancūzijos frankas",
    "GBP" to "Didžiosios Britanijos svaras",
    "GEK" to "Gruzinų kupon larits",
    "GEL" to "Gruzijos laris",
    "GHC" to "Ganos sedis (1979–2007)",
    "GHS" to "Ganos sedis",
    "GIP" to "Gibraltaro svaras",
    "GMD" to "Gambijos dalasis",
    "GNF" to "Gvinėjos frankas",
    "GNS" to "Guinean sylis",
    "GQE" to "Pusiaujo Guinean ekwele",
    "GRD" to "Graikijos drachma",
    "GTQ" to "Gvatemalos ketcalis",
    "GWE" to "Portugalų Gvinėjos eskudas",
    "GWP" to "Gvinėjos-Bisau pesas",
    "GYD" to "Gajanos doleris",
    "HKD" to "Honkongo doleris",
    "HNL" to "Hondūro lempira",
    "HRD" to "Kroatijos dinaras",
    "HRK" to "Kroatijos kuna",
    "HTG" to "Haičio gurdas",
    "HUF" to "Vengrijos forintas",
    "IDR" to "Indonezijos rupija",
    "IEP" to "Airijos svaras",
    "ILP" to "Izraelio svaras",
    "ILR" to "Izraelio šekelis (1980–1985)",
    "ILS" to "Izraelio naujasis šekelis",
    "INR" to "Indijos rupija",
    "IQD" to "Irako dinaras",
    "IRR" to "Irano rialas",
    "ISJ" to "Islandijos krona (1918–1981)",
    "ISK" to "Islandijos krona",
    "ITL" to "Italijos lira",
    "JMD" to "Jamaikos doleris",
    "JOD" to "Jordanijos dinaras",
    "JPY" to "Japonijos jena",
    "KES" to "Kenijos šilingas",
    "KGS" to "Kirgizijos somas",
    "KHR" to "Kambodžos rielis",
    "KMF" to "Komoro frankas",
    "KPW" to "Šiaurės Korėjos vonas",
    "KRH" to "Pietų Korėjos hwanas (1953–1962)",
    "KRO" to "Pietų Korėjos vonas (1945–1953)",
    "KRW" to "Pietų Korėjos vonas",
    "KWD" to "Kuveito dinaras",
    "KYD" to "Kaimanų salų doleris",
    "KZT" to "Kazachstano tengė",
    "LAK" to "Laoso kipas",
    "LBP" to "Libano svaras",
    "LKR" to "Šri Lankos rupija",
    "LRD" to "Liberijos doleris",
    "LSL" to "Lesoto lotis",
    "LTL" to "Lietuvos litas",
    "LTT" to "Lietuvos talonas",
    "LUC" to "Liuksemburgo konvertuojamas frankas",
    "LUF" to "Liuksemburgo frankas",
    "LUL" to "Liuksemburgo finansinis frankas",
    "LVL" to "Latvijos latas",
    "LVR" to "Latvijos rublis",
    "LYD" to "Libijos dinaras",
    "MAD" to "Maroko dirhamas",
    "MAF" to "Maroko frankas",
    "MCF" to "Monegasque frankas",
    "MDC" to "Moldovų cupon",
    "MDL" to "Moldovos lėja",
    "MGA" to "Madagaskaro ariaris",
    "MGF" to "Madagaskaro frankas",
    "MKD" to "Makedonijos denaras",
    "MKN" to "Makedonijos denaras (1992–1993)",
    "MLF" to "Malio frankas",
    "MMK" to "Mianmaro kijatas",
    "MNT" to "Mongolijos tugrikas",
    "MOP" to "Makao pataka",
    "MRO" to "Mauritanijos ugija (1973–2017)",
    "MRU" to "Mauritanijos ugija",
    "MTL" to "Maltos lira",
    "MTP" to "Maltos svaras",
    "MUR" to "Mauricijaus rupija",
    "MVP" to "Maldyvų rupija",
    "MVR" to "Maldyvų rufija",
    "MWK" to "Malavio kvača",
    "MXN" to "Meksikos pesas",
    "MXP" to "Meksikos sidabrinis pesas (1861–1992)",
    "MXV" to "Meksikos United de Inversion (UDI)",
    "MYR" to "Malaizijos ringitas",
    "MZE" to "Mozambiko eskudas",
    "MZM" to "Mozambiko metikalis (1980–2006)",
    "MZN" to "Mozambiko metikalis",
    "NAD" to "Namibijos doleris",
    "NGN" to "Nigerijos naira",
    "NIC" to "Nikaragvos kardoba (1988–1991)",
    "NIO" to "Nikaragvos kordoba",
    "NLG" to "Nyderlandų guldenas",
    "NOK" to "Norvegijos krona",
    "NPR" to "Nepalo rupija",
    "NZD" to "Naujosios Zelandijos doleris",
    "OMR" to "Omano rialas",
    "PAB" to "Panamos balboja",
    "PEI" to "Peru intis",
    "PEN" to "Peru solis",
    "PES" to "Peru solis (1863–1965)",
    "PGK" to "Papua Naujosios Gvinėjos kina",
    "PHP" to "Filipinų pesas",
    "PKR" to "Pakistano rupija",
    "PLN" to "Lenkijos zlotas",
    "PLZ" to "Lenkijos zlotas (1950–1995)",
    "PTE" to "Portugalijos eskudas",
    "PYG" to "Paragvajaus guaranis",
    "QAR" to "Kataro rialas",
    "RHD" to "Rodezijos doleris",
    "ROL" to "Rumunijos lėja (1952–2006)",
    "RON" to "Rumunijos lėja",
    "RSD" to "Serbijos dinaras",
    "RUB" to "Rusijos rublis",
    "RUR" to "Rusijos rublis (1991–1998)",
    "RWF" to "Ruandos frankas",
    "SAR" to "Saudo Arabijos rijalas",
    "SBD" to "Saliamono salų doleris",
    "SCR" to "Seišelių rupija",
    "SDD" to "Sudano dinaras (1992–2007)",
    "SDG" to "Sudano svaras",
    "SDP" to "Sudano svaras (1957–1998)",
    "SEK" to "Švedijos krona",
    "SGD" to "Singapūro doleris",
    "SHP" to "Šv. Elenos salų svaras",
    "SIT" to "Slovėnijos tolaras",
    "SKK" to "Slovakijos krona",
    "SLE" to "Siera Leonės leonė",
    "SLL" to "Siera Leonės leonė (1964—2022)",
    "SOS" to "Somalio šilingas",
    "SRD" to "Surimano doleris",
    "SRG" to "Surimano guldenas",
    "SSP" to "Pietų Sudano svaras",
    "STD" to "San Tomės ir Principės dobra (1977–2017)",
    "STN" to "San Tomės ir Principės dobra",
    "SUR" to "Sovietų rublis",
    "SVC" to "Salvadoro kolonas",
    "SYP" to "Sirijos svaras",
    "SZL" to "Svazilando lilangenis",
    "THB" to "Tailando batas",
    "TJR" to "Tadžikistano rublis",
    "TJS" to "Tadžikistano somonis",
    "TMM" to "Turkmėnistano manatas (1993–2009)",
    "TMT" to "Turkmėnistano manatas",
    "TND" to "Tuniso dinaras",
    "TOP" to "Tongo paanga",
    "TPE" to "Timoro eskudas",
    "TRL" to "Turkijos lira (1922–2005)",
    "TRY" to "Turkijos lira",
    "TTD" to "Trinidado ir Tobago doleris",
    "TWD" to "Taivano naujasis doleris",
    "TZS" to "Tanzanijos šilingas",
    "UAH" to "Ukrainos grivina",
    "UAK" to "Ukrainos karbovanecas",
    "UGS" to "Ugandos šilingas (1966–1987)",
    "UGX" to "Ugandos šilingas",
    "USD" to "JAV doleris",
    "USN" to "JAV doleris (kitos dienos)",
    "USS" to "JAV doleris (šios dienos)",
    "UYI" to "Urugvajaus pesai en unidades indexadas",
    "UYP" to "Urugvajaus pesas (1975–1993)",
    "UYU" to "Urugvajaus pesas",
    "UZS" to "Uzbekistano sumas",
    "VEB" to "Venesuelos bolivaras (1871–2008)",
    "VEF" to "Venesuelos bolivaras (2008–2018)",
    "VES" to "Venesuelos bolivaras",
    "VND" to "Vietnamo dongas",
    "VNN" to "Vietnamo dongas (1978–1985)",
    "VUV" to "Vanuatu vatas",
    "WST" to "Samoa tala",
    "XAF" to "CFA BEAC frankas",
    "XAG" to "Sidabras",
    "XAU" to "Auksas",
    "XBA" to "Europos suvestinės vienetas",
    "XBB" to "Europos piniginis vienetas",
    "XBC" to "Europos valiutos / apskaitos vienetas (XBC)",
    "XBD" to "Europos valiutos / apskaitos vienetas (XBD)",
    "XCD" to "Rytų Karibų doleris",
    "XDR" to "SDR tarptautinis valiutos fondas",
    "XEU" to "Europos piniginis vienetas (1993–1999)",
    "XFO" to "Aukso frankas",
    "XFU" to "Prancūzijos UIC - frankas",
    "XOF" to "CFA BCEAO frankas",
    "XPD" to "Paladis",
    "XPF" to "CFP frankas",
    "XPT" to "Platina",
    "XRE" to "RINET fondai",
    "XSU" to "Sukrė",
    "XTS" to "Tikrinamas valiutos kodas",
    "XUA" to "Azijos plėtros banko apskaitos vienetas",
    "XXX" to "nežinoma valiuta",
    "YDD" to "Jemeno dinaras",
    "YER" to "Jemeno rialas",
    "YUD" to "Jugoslavijos kietasis dinaras (1966–1990)",
    "YUM" to "Jugoslavijos naujasis dinaras (1994–2002)",
    "YUN" to "Jugoslavijos konvertuojamas dinaras (1990–1992)",
    "YUR" to "Jugoslavijos reformuotas dinaras (1992–1993)",
    "ZAL" to "Pietų Afrikos finansinis randas",
    "ZAR" to "Pietų Afrikos Respublikos randas",
    "ZMK" to "Zambijos kvača (1968–2012)",
    "ZMW" to "Zambijos kvača",
    "ZRN" to "Zairo naujasis zairas (1993–1998)",
    "ZRZ" to "Zairo zairas (1971–1993)",
    "ZWD" to "Zimbabvės doleris (1980–2008)",
    "ZWL" to "Zimbabvės doleris (2009)",
    "ZWR" to "Zimbabvės doleris (2008)",
  ) }

  val ltg: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val lu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Ndiriha wa Lemila alabu",
    "AOA" to "Kwanza wa Angola",
    "AUD" to "Ndola wa Ositali",
    "BHD" to "Ndina wa Bahrene",
    "BIF" to "Nfalanga wa Bulundi",
    "BWP" to "Pula wa Botswana",
    "CAD" to "Ndola wa Kanada",
    "CDF" to "Nfalanga wa Kongu",
    "CHF" to "Nfalanga wa Swise",
    "CNY" to "Yuani Renminbi wa Shine",
    "CVE" to "Esikuludo wa Kapevere",
    "DJF" to "Nfalanga wa Dzibuti",
    "DZD" to "Ndina wa Alijeri",
    "EGP" to "Pauni wa Mushidi",
    "ERN" to "Nakfa wa Elitle",
    "ETB" to "Bira wa Etshiopi",
    "EUR" to "Iro",
    "GBP" to "Pauni wa Angeletele",
    "GHC" to "Sedi wa Ngana",
    "GMD" to "Ndalasi wa Ngambi",
    "GNS" to "Nfalanga wa Ngina",
    "INR" to "Rupi wa Inde",
    "JPY" to "Yeni wa Zapɔ",
    "KES" to "Nshili wa Kenya",
    "KMF" to "Nfalanga wa Komoru",
    "LRD" to "Ndola wa Liberya",
    "LSL" to "Loti wa Lesoto",
    "LYD" to "Ndina wa Libi",
    "MAD" to "Ndiriha wa Maroke",
    "MGA" to "Nfalanga wa Madagasikare",
    "MRO" to "Ugwiya wa Moritani (1973–2017)",
    "MRU" to "Ugwiya wa Moritani",
    "MUR" to "Rupia wa Morisi",
    "MWK" to "Kwasha wa Malawi",
    "MZM" to "Metikali wa Mozambiki",
    "NAD" to "Ndola wa Namibi",
    "NGN" to "Naira wa Nizerya",
    "RWF" to "Nfalanga wa Rwanda",
    "SAR" to "Riyale wa Alabu Nsawu",
    "SCR" to "Rupya wa Seshele",
    "SDG" to "Ndina wa Suda",
    "SDP" to "Pauni wa Suda",
    "SHP" to "Pauni wa Santu Elena",
    "SLE" to "Leone",
    "SLL" to "Leone (1964—2022)",
    "SOS" to "Nshili wa Somali",
    "STD" to "Dobra wa Sao Tome ne Presipe (1977–2017)",
    "STN" to "Dobra wa Sao Tome ne Presipe",
    "SZL" to "Lilangeni",
    "TND" to "Ndina wa Tinizi",
    "TZS" to "Nshili wa Tanzani",
    "UGX" to "Nshili wa Uganda",
    "USD" to "Ndola wa Ameriki",
    "XAF" to "Nfalanga CFA BEAC",
    "XOF" to "Nfalanga CFA BCEAO",
    "ZAR" to "Rande wa Afrika wa Mwinshi",
    "ZMK" to "Kwasha wa Zambi (1968–2012)",
    "ZMW" to "Kwasha wa Zambi",
    "ZWD" to "Ndola wa Zimbabwe",
  ) }

  val luo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham ya Falme za Kiarabu",
    "AOA" to "Kwanza ya Angola",
    "AUD" to "Dola ya Australia",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pula mar Botswana",
    "CAD" to "Dola mar Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Uswisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Jibuti",
    "DZD" to "Dinari ya Aljeria",
    "EGP" to "Paund mar Misri",
    "ERN" to "Nakfa ya Eritrea",
    "ETB" to "Birr mar Ethiopia",
    "EUR" to "Yuro",
    "GBP" to "Pauni mar Uingereza",
    "GHC" to "Sedi mar Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Gine",
    "INR" to "Rupia ya India",
    "JPY" to "Yen mar Japan",
    "KES" to "Siling mar Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Dola mar Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirham ya Moroko",
    "MGA" to "Ariary ya Bukini",
    "MRO" to "Ugwiya ya Moritania (1973–2017)",
    "MRU" to "Ugwiya ya Moritania",
    "MUR" to "Rupia ya Morisi",
    "MWK" to "Kwacha ya Malawi",
    "MZM" to "Metikali ya Msumbiji",
    "NAD" to "Dola ya Namibia",
    "NGN" to "Naira ya Nijeria",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riyal ya Saudia",
    "SCR" to "Rupia ya Shelisheli",
    "SDG" to "Pauni ya Sudani",
    "SHP" to "Pauni ya Santahelena",
    "SLE" to "Leoni",
    "SLL" to "Leoni (1964—2022)",
    "SOS" to "Shilingi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Principe (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Principe",
    "SZL" to "Lilangeni",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "Shilingi ya Tanzania",
    "UGX" to "Shilingi ya Uganda",
    "USD" to "Dola",
    "XAF" to "Faranga CFA BEAC",
    "XOF" to "Faranga CFA BCEAO",
    "ZAR" to "Randi ya Afrika Kusini",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Dola ya Zimbabwe",
  ) }

  val luy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham ya Falme za Kiarabu",
    "AOA" to "Kwanza ya Angola",
    "AUD" to "Dola ya Australia",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pula ya Botswana",
    "CAD" to "Dola ya Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Uswisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Jibuti",
    "DZD" to "Dinari ya Aljeria",
    "EGP" to "Pauni ya Misri",
    "ERN" to "Nakfa ya Eritrea",
    "ETB" to "Bir ya Uhabeshi",
    "EUR" to "Yuro",
    "GBP" to "Pauni ya Uingereza",
    "GHC" to "Sedi ya Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Gine",
    "INR" to "Rupia ya India",
    "JPY" to "Sarafu ya Kijapani",
    "KES" to "Sirinji ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Dola ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirham ya Moroko",
    "MGA" to "Ariary ya Bukini",
    "MRO" to "Ugwiya ya Moritania (1973–2017)",
    "MRU" to "Ugwiya ya Moritania",
    "MUR" to "Rupia ya Morisi",
    "MWK" to "Kwacha ya Malawi",
    "MZM" to "Metikali ya Msumbiji",
    "NAD" to "Dola ya Namibia",
    "NGN" to "Naira ya Nijeria",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riyal ya Saudia",
    "SCR" to "Rupia ya Shelisheli",
    "SDG" to "Pauni ya Sudani",
    "SHP" to "Pauni ya Santahelena",
    "SLE" to "Leoni",
    "SLL" to "Leoni (1964—2022)",
    "SOS" to "Shilingi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Principe (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Principe",
    "SZL" to "Lilangeni",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "Sirinji ya Tanzania",
    "UGX" to "Sirinji ya Uganda",
    "USD" to "Dola ya Marekani",
    "XAF" to "Faranga CFA BEAC",
    "XOF" to "Faranga CFA BCEAO",
    "ZAR" to "Randi ya Afrika Kusini",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Dola ya Zimbabwe",
  ) }

  val lv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Apvienoto Arābu Emirātu dirhēms",
    "AFN" to "Afganistānas afgāns",
    "ALL" to "Albānijas leks",
    "AMD" to "Armēnijas drams",
    "ANG" to "Nīderlandes Antiļu guldenis",
    "AOA" to "Angolas kvanza",
    "ARS" to "Argentīnas peso",
    "ATS" to "Austrijas šiliņš",
    "AUD" to "Austrālijas dolārs",
    "AWG" to "Arubas guldenis",
    "AZM" to "Azerbaidžānas manats (1993–2006)",
    "AZN" to "Azerbaidžānas manats",
    "BAM" to "Bosnijas un Hercogovinas konvertējamā marka",
    "BBD" to "Barbadosas dolārs",
    "BDT" to "Bangladešas taka",
    "BEF" to "Beļģijas franks",
    "BGN" to "Bulgārijas leva",
    "BHD" to "Bahreinas dinārs",
    "BIF" to "Burundi franks",
    "BMD" to "Bermudu dolārs",
    "BND" to "Brunejas dolārs",
    "BOB" to "Bolīvijas boliviano",
    "BRL" to "Brazīlijas reāls",
    "BSD" to "Bahamu dolārs",
    "BTN" to "Butānas ngultrums",
    "BWP" to "Botsvanas pula",
    "BYN" to "Baltkrievijas rubelis",
    "BYR" to "Baltkrievijas rubelis (2000–2016)",
    "BZD" to "Belizas dolārs",
    "CAD" to "Kanādas dolārs",
    "CDF" to "KDR franks",
    "CHF" to "Šveices franks",
    "CLP" to "Čīles peso",
    "CNH" to "Ķīnas juaņa (ofšors)",
    "CNY" to "Ķīnas juaņs",
    "COP" to "Kolumbijas peso",
    "COU" to "Kolumbijas reāls",
    "CRC" to "Kostarikas kolons",
    "CUC" to "Kubas konvertējamais peso",
    "CUP" to "Kubas peso",
    "CVE" to "Kaboverdes eskudo",
    "CYP" to "Kipras mārciņa",
    "CZK" to "Čehijas krona",
    "DEM" to "Vācijas marka",
    "DJF" to "Džibutijas franks",
    "DKK" to "Dānijas krona",
    "DOP" to "Dominikānas peso",
    "DZD" to "Alžīrijas dinārs",
    "EEK" to "Igaunijas krona",
    "EGP" to "Ēģiptes mārciņa",
    "ERN" to "Eritrejas nakfa",
    "ESP" to "Spānijas peseta",
    "ETB" to "Etiopijas birs",
    "EUR" to "eiro",
    "FIM" to "Somijas marka",
    "FJD" to "Fidži dolārs",
    "FKP" to "Folklenda Salu mārciņa",
    "FRF" to "Francijas franks",
    "GBP" to "Lielbritānijas mārciņa",
    "GEL" to "Gruzijas lari",
    "GHS" to "Ganas sedi",
    "GIP" to "Gibraltāra mārciņa",
    "GMD" to "Gambijas dalasi",
    "GNF" to "Gvinejas franks",
    "GRD" to "Grieķijas drahma",
    "GTQ" to "Gvatemalas ketsals",
    "GYD" to "Gajānas dolārs",
    "HKD" to "Honkongas dolārs",
    "HNL" to "Hondurasas lempīra",
    "HRK" to "Horvātijas kuna",
    "HTG" to "Haiti gurds",
    "HUF" to "Ungārijas forints",
    "IDR" to "Indonēzijas rūpija",
    "IEP" to "Īrijas mārciņa",
    "ILS" to "Izraēlas šekelis",
    "INR" to "Indijas rūpija",
    "IQD" to "Irākas dinārs",
    "IRR" to "Irānas riāls",
    "ISK" to "Islandes krona",
    "ITL" to "Itālijas lira",
    "JMD" to "Jamaikas dolārs",
    "JOD" to "Jordānas dinārs",
    "JPY" to "Japānas jena",
    "KES" to "Kenijas šiliņš",
    "KGS" to "Kirgizstānas soms",
    "KHR" to "Kambodžas riels",
    "KMF" to "Komoru franks",
    "KPW" to "Ziemeļkorejas vona",
    "KRW" to "Dienvidkorejas vona",
    "KWD" to "Kuveitas dinārs",
    "KYD" to "Kaimanu salu dolārs",
    "KZT" to "Kazahstānas tenge",
    "LAK" to "Laosas kips",
    "LBP" to "Libānas mārciņa",
    "LKR" to "Šrilankas rūpija",
    "LRD" to "Libērijas dolārs",
    "LSL" to "Lesoto loti",
    "LTL" to "Lietuvas lits",
    "LUF" to "Luksemburgas franks",
    "LVL" to "Latvijas lats",
    "LVR" to "Latvijas rublis",
    "LYD" to "Lībijas dinārs",
    "MAD" to "Marokas dirhēms",
    "MDL" to "Moldovas leja",
    "MGA" to "Madagaskaras ariari",
    "MKD" to "Maķedonijas denārs",
    "MLF" to "CFA (Āfrikas) franks",
    "MMK" to "Mjanmas kjats",
    "MNT" to "Mongolijas tugriks",
    "MOP" to "Makao pataka",
    "MRO" to "Mauritānijas ugija (1973–2017)",
    "MRU" to "Mauritānijas ugija",
    "MTL" to "Maltas lira",
    "MTP" to "Maltas mārciņa",
    "MUR" to "Maurīcijas rūpija",
    "MVR" to "Maldīvijas rūfija",
    "MWK" to "Malāvijas kvača",
    "MXN" to "Meksikas peso",
    "MYR" to "Malaizijas ringits",
    "MZE" to "Mozambikas eskudo",
    "MZM" to "Mozambikas vecais metikals",
    "MZN" to "Mozambikas metikals",
    "NAD" to "Namībijas dolārs",
    "NGN" to "Nigērijas naira",
    "NIO" to "Nikaragvas kordoba",
    "NLG" to "Nīderlandes guldenis",
    "NOK" to "Norvēģijas krona",
    "NPR" to "Nepālas rūpija",
    "NZD" to "Jaunzēlandes dolārs",
    "OMR" to "Omānas riāls",
    "PAB" to "Panamas balboa",
    "PEN" to "Peru sols",
    "PGK" to "Papua-Jaungvinejas kina",
    "PHP" to "Filipīnu peso",
    "PKR" to "Pakistānas rūpija",
    "PLN" to "Polijas zlots",
    "PTE" to "Portugāles eskudo",
    "PYG" to "Paragvajas guarani",
    "QAR" to "Kataras riāls",
    "ROL" to "Rumānijas vecā leja",
    "RON" to "Rumānijas leja",
    "RSD" to "Serbijas dinārs",
    "RUB" to "Krievijas rublis",
    "RWF" to "Ruandas franks",
    "SAR" to "Saūda Arābijas riāls",
    "SBD" to "Zālamana Salu dolārs",
    "SCR" to "Seišelu salu rūpija",
    "SDG" to "Sudānas mārciņa",
    "SEK" to "Zviedrijas krona",
    "SGD" to "Singapūras dolārs",
    "SHP" to "Sv.Helēnas salas mārciņa",
    "SIT" to "Slovēnijas tolars",
    "SKK" to "Slovakijas krona",
    "SLE" to "Sjerraleones leone",
    "SLL" to "Sjerraleones leone (1964—2022)",
    "SOS" to "Somālijas šiliņš",
    "SRD" to "Surinamas dolārs",
    "SRG" to "Surinamas guldenis",
    "SSP" to "Dienvidsudānas mārciņa",
    "STD" to "Santome un Prinsipi dobra (1977–2017)",
    "STN" to "Santome un Prinsipi dobra",
    "SVC" to "Salvadoras kolons",
    "SYP" to "Sīrijas mārciņa",
    "SZL" to "Svazilendas lilangeni",
    "THB" to "Taizemes bāts",
    "TJS" to "Tadžikistānas somons",
    "TMM" to "Turkmenistānas manats (1993–2009)",
    "TMT" to "Turkmenistānas manats",
    "TND" to "Tunisijas dinārs",
    "TOP" to "Tongas paanga",
    "TRL" to "Turcijas lira (1922–2005)",
    "TRY" to "Turcijas lira",
    "TTD" to "Trinidādas un Tobāgo dolārs",
    "TWD" to "Taivānas jaunais dolārs",
    "TZS" to "Tanzānijas šiliņš",
    "UAH" to "Ukrainas grivna",
    "UGX" to "Ugandas šiliņš",
    "USD" to "ASV dolārs",
    "UYU" to "Urugvajas peso",
    "UZS" to "Uzbekistānas sums",
    "VEB" to "Venecuēlas bolivārs (1871–2008)",
    "VEF" to "Venecuēlas bolivārs (2008–2018)",
    "VES" to "Venecuēlas bolivārs",
    "VND" to "Vjetnamas dongi",
    "VUV" to "Vanuatu vatu",
    "WST" to "Samoa tala",
    "XAF" to "Centrālāfrikas CFA franks",
    "XAG" to "sudrabs",
    "XAU" to "zelts",
    "XBA" to "Eiropas norēķinu vienība EURCO",
    "XBB" to "Eiropas naudas vienība",
    "XBC" to "Eiropas norēķinu vienība (XBC)",
    "XBD" to "Eiropas norēķinu vienība (XBD)",
    "XCD" to "Austrumkarību dolārs",
    "XDR" to "Speciālās aizņēmuma tiesības",
    "XEU" to "Eiropas norēķinu vienība",
    "XFO" to "Francijas zelta franks",
    "XFU" to "Francijas UIC franks",
    "XOF" to "Rietumāfrikas CFA franks",
    "XPD" to "pallādijs",
    "XPF" to "CFP franks",
    "XPT" to "platīns",
    "XTS" to "Testa valūtas kods",
    "XXX" to "Nezināma valūta",
    "YER" to "Jemenas riāls",
    "ZAR" to "Dienvidāfrikas rends",
    "ZMK" to "Zambijas kvača (1968–2012)",
    "ZMW" to "Zambijas kvača",
    "ZWD" to "Zimbabves dolārs",
    "ZWL" to "Zimbabves dolārs (2009)",
  ) }

  val mai: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "ब्राज़ीली रियाल",
    "CNY" to "चीनी युआन",
    "EUR" to "यूरो",
    "GBP" to "ब्रिटिश पाउंड स्टर्लिंग",
    "INR" to "भारतीय रुपया",
    "JPY" to "जापानी येन",
    "RUB" to "रूसी रूबल",
    "USD" to "यूएस डॉलर",
    "XXX" to "अज्ञात मुद्रा",
  ) }

  val mas: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Iropiyianí ɔ́ɔ̄ lmarabu",
    "AOA" to "Iropiyianí e Angola",
    "AUD" to "Iropiyianí e Austria",
    "BHD" to "Iropiyianí e Bahareini",
    "BIF" to "Iropiyianí e Burundi",
    "BWP" to "Iropiyianí e Botswana",
    "CAD" to "Iropiyianí e Kanada",
    "CDF" to "Iropiyianí e Kongo",
    "CHF" to "Iropiyianí e Uswisi",
    "CNY" to "Iropiyianí e China",
    "CVE" to "Iropiyianí e Kepuvede",
    "DJF" to "Iropiyianí e Jibuti",
    "DZD" to "Iropiyianí e Algeria",
    "EGP" to "Iropiyianí e Misri",
    "ERN" to "Iropiyianí e Eritrea",
    "ETB" to "Iropiyianí e Uhabeshi",
    "EUR" to "Iropiyianí e yuro",
    "GBP" to "Iropiyianí e Nkɨ́resa",
    "GHC" to "Iropiyianí e Ghana",
    "GMD" to "Iropiyianí e Gambia",
    "GNS" to "Iropiyianí e Gine",
    "INR" to "Iropiyianí e India",
    "JPY" to "Iropiyianí e Japani",
    "KES" to "Iropiyianí e Kenya",
    "KMF" to "Iropiyianí e Komoro",
    "LRD" to "Iropiyianí e Liberia",
    "LSL" to "Iropiyianí e Lesoto",
    "LYD" to "Iropiyianí e Libya",
    "MAD" to "Iropiyianí e Moroko",
    "MGA" to "Iropiyianí e Bukini",
    "MRO" to "Iropiyianí e Moritania (1973–2017)",
    "MRU" to "Iropiyianí e Moritania",
    "MUR" to "Iropiyianí e Morisi",
    "MWK" to "Iropiyianí e Malawi",
    "MZM" to "Iropiyianí e Msumbiji",
    "NAD" to "Iropiyianí e Namibia",
    "NGN" to "Iropiyianí e Nijeria",
    "RWF" to "Iropiyianí e Rwanda",
    "SAR" to "Iropiyianí e Saudi",
    "SCR" to "Iropiyianí e Shelisheli",
    "SDG" to "Iropiyianí e Sudani",
    "SHP" to "Iropiyianí e Santahelena",
    "SLE" to "Iropiyianí e leoni",
    "SLL" to "Iropiyianí e leoni (1964—2022)",
    "SOS" to "Iropiyianí e Somalia",
    "STD" to "Iropiyianí e Saotome (1977–2017)",
    "STN" to "Iropiyianí e Saotome",
    "SZL" to "Iropiyianí e lilangeni",
    "TND" to "Iropiyianí e Tunisia",
    "TZS" to "Iropiyianí e Tanzania",
    "UGX" to "Iropiyianí e Uganda",
    "USD" to "Iropiyianí ɔ́ɔ̄ lamarekani",
    "XAF" to "Iropiyianí e CFA BEAC",
    "XOF" to "Iropiyianí e CFA BCEAO",
    "ZAR" to "Iropiyianí e Afrika Kusini",
    "ZMK" to "Iropiyianí e Sambia (1968–2012)",
    "ZMW" to "Iropiyianí e Sambia",
    "ZWD" to "Iropiyianí e Simbabwe",
  ) }

  val mas_TZ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val mdf: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val mer: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham ya Falme cia Kiarabu",
    "AOA" to "Kwanza ya Angola",
    "AUD" to "Dola ya Austrĩlia",
    "BHD" to "Dinari ya Baharini",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pula ya Botswana",
    "CAD" to "Dola ya Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Swisilandi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Jibuti",
    "DZD" to "Dinari ya Anjĩria",
    "EGP" to "Paũndi ya Misri",
    "ERN" to "Nakfa ya Eritrea",
    "ETB" to "Bĩrũ ya Ithiopia",
    "EUR" to "Yuro",
    "GBP" to "Paũndi ya Ngeretha",
    "GHC" to "Sedi ya Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Gine",
    "INR" to "Rupia ya India",
    "JPY" to "Sarafu ya japani",
    "KES" to "Shilingi ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Dola ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirham ya Moroko",
    "MGA" to "Ariarĩ ya Bukini",
    "MRO" to "Ugwiya ya Mauritania (1973–2017)",
    "MRU" to "Ugwiya ya Mauritania",
    "MUR" to "Rupia ya Maurĩtiasi",
    "MWK" to "Kwacha ya Malawi",
    "MZM" to "Metikali ya Mozambĩkĩ",
    "NAD" to "Dola ya Namibia",
    "NGN" to "Naira ya Nijeria",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riyal ya Saudi Arĩbia",
    "SCR" to "Rupia ya Shelisheli",
    "SDG" to "Paũndi ya Sudani",
    "SHP" to "Paũndi ya Santahelena",
    "SLE" to "Leoni",
    "SLL" to "Leoni (1964—2022)",
    "SOS" to "Shilingi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Principe (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Principe",
    "SZL" to "Lilangeni",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "Shilingi ya Tanzania",
    "UGX" to "Shilingi ya Uganda",
    "USD" to "Dola ya Amerika",
    "XAF" to "Faranga CFA BEAC",
    "XOF" to "Faranga CFA BCEAO",
    "ZAR" to "Randi ya Afrika ya Sauthi",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Dola ya Zimbabwe",
  ) }

  val mfe: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "dirham Emira arab ini",
    "AOA" to "kwanza angole",
    "AUD" to "dolar ostralien",
    "BHD" to "dinar bahreïn",
    "BIF" to "fran burunde",
    "BWP" to "pula ya botswane",
    "CAD" to "dolar kanadien",
    "CDF" to "fran kongole",
    "CHF" to "fran swis",
    "CNY" to "yuan renminbi sinwa",
    "CVE" to "eskudo kapverdien",
    "DJF" to "fran djiboutien",
    "DZD" to "dinar alzerien",
    "EGP" to "liv ezipsien",
    "ERN" to "nafka erythreen",
    "ETB" to "birr etiopien",
    "EUR" to "euro",
    "GBP" to "liv sterlin",
    "GHC" to "sedi ganeen",
    "GMD" to "dalasi gambien",
    "GNS" to "fran gineen",
    "INR" to "roupi",
    "JPY" to "yen zapone",
    "KES" to "shiling kenyan",
    "KMF" to "fran komorien",
    "LRD" to "dolar liberien",
    "LSL" to "loti lezoto",
    "LYD" to "dinar libien",
    "MAD" to "dirham marokin",
    "MGA" to "fran malgas",
    "MRO" to "ouguiya moritanien (1973–2017)",
    "MRU" to "ouguiya moritanien",
    "MUR" to "roupi morisien",
    "MWK" to "kwacha malawit",
    "MZM" to "metikal mozanbikin",
    "NAD" to "dolar namibien",
    "NGN" to "naira nizerian",
    "RWF" to "fran rwande",
    "SAR" to "rial saoudien",
    "SCR" to "roupi seselwa",
    "SDG" to "dinar soudane",
    "SDP" to "liv soudane",
    "SHP" to "liv Sainte-Hélène",
    "SLE" to "leonn Sierra-Leone",
    "SLL" to "leonn Sierra-Leone (1964—2022)",
    "SOS" to "shilingi somalien",
    "STD" to "dobra santomeen (1977–2017)",
    "STN" to "dobra santomeen",
    "SZL" to "lilangeni swazi",
    "TND" to "dinar tinizien",
    "TZS" to "shiling tanzanien",
    "UGX" to "shiling ougande",
    "USD" to "dolar amerikin",
    "XAF" to "fran CFA (BEAC)",
    "XOF" to "fran CFA (BCEAO)",
    "ZAR" to "rand sid-afrikin",
    "ZMK" to "kwacha zanbien (1968–2012)",
    "ZMW" to "kwacha zanbien",
    "ZWD" to "dolar zimbawe",
  ) }

  val mg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham",
    "AOA" to "kwanza angoley",
    "AUD" to "Dolara aostralianina",
    "BHD" to "dinar bahreïni",
    "BIF" to "Farantsa Borondi",
    "BWP" to "Pola botsoaney",
    "CAD" to "Dôlara Kanadianina",
    "CDF" to "Farantsa kôngôley",
    "CHF" to "Farantsa soisa",
    "CNY" to "Yoan sinoa Renminbi",
    "CVE" to "Escudo",
    "DJF" to "Farantsa Djibotianina",
    "DZD" to "Dinara alzerianina",
    "EGP" to "vola venty ejipsiana",
    "ERN" to "Nakfà Eritreanina",
    "ETB" to "Bir etiopianina",
    "EUR" to "Eoro",
    "GBP" to "livre sterling",
    "GHC" to "cédi",
    "GMD" to "Dalasi gambianina",
    "GNS" to "Farantsa Gineanina",
    "INR" to "Ropia Indianina",
    "JPY" to "Yen Japoney",
    "KES" to "Shilling kenianina",
    "KMF" to "Farantsa Komorianina",
    "LRD" to "Dôlara Liberianina",
    "LSL" to "Loti",
    "LYD" to "Dinara Libyanina",
    "MAD" to "Dirham marokianina",
    "MGA" to "Ariary",
    "MRO" to "Ouguiya moritanianina (1973–2017)",
    "MRU" to "Ouguiya moritanianina",
    "MUR" to "Ropia maorisianina",
    "MWK" to "kwacha malawite",
    "MZM" to "Metikaly",
    "NAD" to "Dolara namibianina",
    "NGN" to "Naira nigerianina",
    "RWF" to "Farantsa Roande",
    "SAR" to "Rial saodianina",
    "SCR" to "Ropia Seysheloà",
    "SDG" to "Dinara Sodaney",
    "SDP" to "livre soudanaise (1956–2007)",
    "SHP" to "livre de Sainte-Hélène",
    "SLE" to "Leone",
    "SLL" to "Leone (1964—2022)",
    "SOS" to "Shilling somalianina",
    "STD" to "Dobra (1977–2017)",
    "STN" to "Dobra",
    "SZL" to "Lilangeni",
    "TND" to "Dinar tonizianina",
    "TZS" to "Shilling tanzanianina",
    "UGX" to "Shilling ogandianina",
    "USD" to "Dolara amerikanina",
    "XAF" to "Farantsa CFA (BEAC)",
    "XOF" to "Farantsa CFA (BCEAO)",
    "ZAR" to "Rand afrikanina tatsimo",
    "ZMK" to "Kwacha zambianina (1968–2012)",
    "ZMW" to "Kwacha zambianina",
    "ZWD" to "Dôlara Zimbaboeanina",
  ) }

  val mgh: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val mgo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "XAF" to "shirè",
    "XXX" to "iku ikap mɔʼɔ",
  ) }

  val mhn: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val mi: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham UAE",
    "AFN" to "Afghani Awhekenetāna",
    "ALL" to "Lek Arapeinia",
    "AMD" to "Dram Āmenia",
    "ANG" to "Guilder Anatiri Hōrana",
    "AOA" to "Kwanza Anakora",
    "ARS" to "Peso Āketina",
    "AUD" to "Tāra Ahitereiria",
    "AWG" to "Florin Arūpa",
    "AZN" to "Manat Atepaihānia",
    "BAM" to "Mark Pōngia-Herekōwini takahuri",
    "BBD" to "Tāra Papatohe",
    "BDT" to "Taka Pākaratēhi",
    "BGN" to "Leva Purukāria",
    "BHD" to "Dinar Pāreina",
    "BIF" to "Franc Puruniti",
    "BMD" to "Tāra Pāmura",
    "BND" to "Tāra Poronai",
    "BOB" to "Boliviano Poriwia",
    "BRL" to "Real Parahi",
    "BSD" to "Tāra Pahama",
    "BTN" to "Ngultrum Pūtana",
    "BWP" to "Pula Poriwana",
    "BYN" to "Ruble Pērara",
    "BZD" to "Tāra Pērihi",
    "CAD" to "Tāra Kānata",
    "CDF" to "Franc Kōngo",
    "CHF" to "Franc Huiterangi",
    "CLP" to "Peso Hiri",
    "CNH" to "Yuan Haina (ki waho)",
    "CNY" to "Yuan Haina",
    "COP" to "Peso Koromōpia",
    "CRC" to "Colon Koto Rika",
    "CUC" to "Peso Kiupa takahuri",
    "CUP" to "Peso Kiupa",
    "CVE" to "Escudo Kūrae Matomato",
    "CZK" to "Koruna Tieke",
    "DJF" to "Franc Tepūti",
    "DKK" to "Kroner Tenemāka",
    "DOP" to "Peso Tominika",
    "DZD" to "Dinar Aratiria",
    "EGP" to "Pāuna Īhipa",
    "ERN" to "Nakfa Eriterea",
    "ETB" to "birr Etiopia",
    "EUR" to "Euro",
    "FJD" to "Tāra Whītī",
    "FKP" to "Pāuna Whākana",
    "GBP" to "Pāuna Piritene",
    "GEL" to "Lari Hōria",
    "GHS" to "Cedi Kāna",
    "GIP" to "Pāuna Kāmaka",
    "GMD" to "Dalasi Kamopia",
    "GNF" to "Franc Kini",
    "GTQ" to "Quetzal Kuatamāra",
    "GYD" to "Tāra Kaiana",
    "HKD" to "Tāra Hongipua",
    "HNL" to "Lempira Honotura",
    "HRK" to "Kuna Koroātia",
    "HTG" to "Gourde Haiti",
    "HUF" to "Forint Hanekari",
    "IDR" to "Rupiah Initonīhia",
    "ILS" to "Shekel Hou Iharaira",
    "INR" to "Rupī Iniana",
    "IQD" to "Dinar Irāka",
    "IRR" to "Rial Irāna",
    "ISK" to "Kronur Tiorangi",
    "JMD" to "Tāra Hemeika",
    "JOD" to "Dinar Hōrano",
    "JPY" to "Yen Hapanihi",
    "KES" to "Hereni Kenia",
    "KGS" to "Som Kikitānga",
    "KHR" to "Riel Kamapōtia",
    "KMF" to "Franc Komoro",
    "KPW" to "Won Kōrea ki te Raki",
    "KRW" to "Won Kōrea ki te Tonga",
    "KWD" to "Dinar Kūweiti",
    "KYD" to "Tāra Kāmana",
    "KZT" to "Tenge Katatānga",
    "LAK" to "kip Rāoho",
    "LBP" to "Pāuna Repanona",
    "LKR" to "Rupee Hiri Ranaka",
    "LRD" to "Tāra Raipiria",
    "LSL" to "Loti Teroto",
    "LYD" to "Dinar Ripia",
    "MAD" to "Dirham Moroko",
    "MDL" to "Leu Morotawa",
    "MGA" to "Ariary Matakāhika",
    "MKD" to "Denar Makerōnia",
    "MMK" to "Kyat Pēma",
    "MNT" to "tugrik Mongōria",
    "MOP" to "Pataca Makau",
    "MRU" to "Ouguiya Mauritania",
    "MUR" to "Rupee Marihi",
    "MVR" to "Rufiyaa Māratiri",
    "MWK" to "Kwacha Marāwi",
    "MXN" to "Peso Mēhiko",
    "MYR" to "Ringgit Mareia",
    "MZN" to "Metical Mohapiki",
    "NAD" to "Tāra Namipia",
    "NGN" to "Naira Ngāitīria",
    "NIO" to "Cordoba Nikarāhua",
    "NOK" to "Kroner Nōwei",
    "NPR" to "Rupee Nepōra",
    "NZD" to "Tāra o Aotearoa",
    "OMR" to "Rial Ōmana",
    "PAB" to "Balboa Panama",
    "PEN" to "Sole Peru",
    "PGK" to "Kina Papua Nūkini",
    "PHP" to "Peso Piripīni",
    "PKR" to "Rupee Pakitāne",
    "PLN" to "Zloty Pōrana",
    "PYG" to "Guarani Parakai",
    "QAR" to "Riyal Katā",
    "RON" to "Leu Romeinia",
    "RSD" to "Dinar Hirupia",
    "RUB" to "Rūpera Ruhiana",
    "RWF" to "Franc Rāwana",
    "SAR" to "Riyal Hauri",
    "SBD" to "Tāra Moutere Horomona",
    "SCR" to "Rupee Heikere",
    "SDG" to "Pāuna Hūtāne",
    "SEK" to "Kronor Huitene",
    "SGD" to "Tāra Hingapoa",
    "SHP" to "Pāuna Hato Herena",
    "SLE" to "Leone Araone",
    "SLL" to "Leone Araon (1964—2022)e",
    "SOS" to "Hereni Hūmārie",
    "SRD" to "Tāra Huriname",
    "SSP" to "Pāuna Hūtāne Tonga",
    "STN" to "Dobra Hao Tome me Pirinihipi",
    "SYP" to "Pāuna Hiria",
    "SZL" to "Lilangeni Warerangi",
    "THB" to "Baht Tairanga",
    "TJS" to "Somoni Takiritānga",
    "TMT" to "Manat Tukumanatānga",
    "TND" to "Dinar Tūnihia",
    "TOP" to "Pa’anga Tonga",
    "TRY" to "Lira Tākei",
    "TTD" to "Tāra Tirinaki Tōpako",
    "TWD" to "Tāra Taiwana Hou",
    "TZS" to "Hereni Tānahia",
    "UAH" to "Hryvnia Ukareinga",
    "UGX" to "hereni Ukānga",
    "USD" to "Tāra US",
    "UYU" to "Peso Urukoi",
    "UZS" to "Som Uhipeketāne",
    "VES" to "Bolivar Penehūera",
    "VND" to "Dong Whitināmu",
    "VUV" to "Vatu Whenuatū",
    "WST" to "Tala Hāmoa",
    "XAF" to "Franc CFA Āwherika Waenga",
    "XCD" to "Tāra Karapīana Rāwhiti",
    "XOF" to "Franc CFA Āwherika ki te Uru",
    "XPF" to "Franc CFP",
    "XXX" to "Moni Tē Mōhiotia",
    "YER" to "Rial Īmene",
    "ZAR" to "Rand Āwherika ki te Tonga",
    "ZMW" to "Kwacha Tāmipia",
  ) }

  val mic: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val mk: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Андорска Пезета",
    "AED" to "Дирхам на Обединети Арапски Емирати",
    "AFA" to "Авгани (1927–2002)",
    "AFN" to "Авганистански авгани",
    "ALL" to "Албански лек",
    "AMD" to "Ерменски драм",
    "ANG" to "Холандски антилски гилдер",
    "AOA" to "Анголска кванза",
    "AOK" to "Анголска Кванза (1977–1990)",
    "AON" to "Анголска нова Кванза (1990–2000)",
    "ARP" to "Аргентински Пезос (1983–1985)",
    "ARS" to "Аргентински пезос",
    "ATS" to "Австралиски Шилинг",
    "AUD" to "Австралиски долар",
    "AWG" to "Арубиски флорин",
    "AZN" to "Азербејџански манат",
    "BAD" to "Босанско-Херцеговски Динар",
    "BAM" to "Босанско-херцеговска конвертибилна марка",
    "BBD" to "Барбадоски долар",
    "BDT" to "Бангладешка така",
    "BEC" to "Белгиски Франк (конвертибилен)",
    "BEF" to "Белгиски Франк",
    "BEL" to "Белгиски Франк (финансиски)",
    "BGL" to "Бугарски цврст лев",
    "BGN" to "Бугарски лев",
    "BHD" to "Бахреински динар",
    "BIF" to "Бурундиски франк",
    "BMD" to "Бермудски долар",
    "BND" to "Брунејски долар",
    "BOB" to "Боливиски боливиано",
    "BRL" to "Бразилски реал",
    "BSD" to "Бахамски долар",
    "BTN" to "Бутански нгултрум",
    "BWP" to "Боцванска пула",
    "BYB" to "Белоруска нова рубља (1994–1999)",
    "BYN" to "Белоруска рубља",
    "BYR" to "Белоруска рубља (2000–2016)",
    "BZD" to "Белизиски долар",
    "CAD" to "Канадски долар",
    "CDF" to "Конголски франк",
    "CHF" to "Швајцарски франк",
    "CLP" to "Чилеански пезос",
    "CNH" to "Кинески јуан (офшор)",
    "CNY" to "Кинески јуан",
    "COP" to "Колумбиски пезос",
    "CRC" to "Костарикански колон",
    "CSK" to "Чехословачка цврста корона",
    "CUC" to "Кубански конвертибилен пезос",
    "CUP" to "Кубански пезос",
    "CVE" to "Зелено’ртски ескудо",
    "CYP" to "Кипарска фунта",
    "CZK" to "Чешка круна",
    "DEM" to "Германска Марка",
    "DJF" to "Џибутски франк",
    "DKK" to "Данска круна",
    "DOP" to "Доминикански пезос",
    "DZD" to "Алжирски динар",
    "EGP" to "Египетска фунта",
    "ERN" to "Еритрејска накфа",
    "ESP" to "Шпанска Пезета",
    "ETB" to "Етиописки бир",
    "EUR" to "Евро",
    "FIM" to "Финска марка",
    "FJD" to "Фиџиски долар",
    "FKP" to "Фолкландска фунта",
    "FRF" to "Француски франк",
    "GBP" to "Британска фунта",
    "GEL" to "Грузиски лари",
    "GHC" to "Ганајски Седи",
    "GHS" to "Гански седи",
    "GIP" to "Гибралтарска фунта",
    "GMD" to "Гамбиски даласи",
    "GNF" to "Гвинејски франк",
    "GRD" to "Грчка драхма",
    "GTQ" to "Гватемалски кветцал",
    "GWP" to "Гвинејски Бисау пезос",
    "GYD" to "Гвајански долар",
    "HKD" to "Хонгконшки долар",
    "HNL" to "Хондурска лемпира",
    "HRD" to "Хрватски динар",
    "HRK" to "Хрватска куна",
    "HTG" to "Хаитски гурд",
    "HUF" to "Унгарска форинта",
    "IDR" to "Индонезиска рупија",
    "IEP" to "Ирска фунта",
    "ILP" to "Изрелска фунта",
    "ILS" to "Израелски нов шекел",
    "INR" to "Индиска рупија",
    "IQD" to "Ирачки динар",
    "IRR" to "Ирански риал",
    "ISK" to "Исландска крона",
    "ITL" to "Италијанска лира",
    "JMD" to "Јамајкански долар",
    "JOD" to "Јордански динар",
    "JPY" to "Јапонски јен",
    "KES" to "Кениски шилинг",
    "KGS" to "Киргистански сом",
    "KHR" to "Камбоџиски рел",
    "KMF" to "Коморски франк",
    "KPW" to "Северно корејски вон",
    "KRW" to "Јужно корејски вон",
    "KWD" to "Кувајтски динар",
    "KYD" to "Кајмански долар",
    "KZT" to "Казахстанска тенга",
    "LAK" to "Лаоски кип",
    "LBP" to "Либанска фунта",
    "LKR" to "Шриланканска рупија",
    "LRD" to "Либериски долар",
    "LSL" to "Лесотско лоти",
    "LTL" to "Литваниска лита",
    "LTT" to "Литваниски литаз",
    "LUF" to "Луксембуршки франк",
    "LVL" to "Латвијски лат",
    "LVR" to "Латвијска рубља",
    "LYD" to "Либијски динар",
    "MAD" to "Марокански дирхам",
    "MAF" to "Марокански франк",
    "MDL" to "Молдавски леу",
    "MGA" to "Малагасиски ариари",
    "MKD" to "Македонски денар",
    "MLF" to "Малски франк",
    "MMK" to "Мјанмарски киат",
    "MNT" to "Монголиски тугрик",
    "MOP" to "Макао патака",
    "MRO" to "Мавританска угија (1973–2017)",
    "MRU" to "Мавританска угија",
    "MTL" to "Малтешка лира",
    "MTP" to "Малтешка фунта",
    "MUR" to "Мавританска рупија",
    "MVR" to "Малдивска руфија",
    "MWK" to "Малависка квача",
    "MXN" to "Мексикански пезос",
    "MXP" to "Мексикански сребрен пезос (1861–1992)",
    "MYR" to "Малезиски рингит",
    "MZE" to "Мозамбиско ескудо",
    "MZM" to "Стар мозамбиски метикал",
    "MZN" to "Мозамбиски метикал",
    "NAD" to "Намибиски долар",
    "NGN" to "Нигериска наира",
    "NIC" to "Никарагванска кордоба (1988–1991)",
    "NIO" to "Никарагванска кордоба",
    "NLG" to "Холандски гилдер",
    "NOK" to "Норвешка круна",
    "NPR" to "Непалска рупија",
    "NZD" to "Новозеландски долар",
    "OMR" to "Омански риал",
    "PAB" to "Панамска балбоа",
    "PEN" to "Перуански сол",
    "PES" to "Перуански сол (1863–1965)",
    "PGK" to "Папуа новогвинејска кина",
    "PHP" to "Филипински пезос",
    "PKR" to "Пакистанска рупија",
    "PLN" to "Полска злота",
    "PLZ" to "Полска злота (1950–1995)",
    "PTE" to "Португалско ескудо",
    "PYG" to "Парагвајска гуарана",
    "QAR" to "Катарски риал",
    "ROL" to "Романска леи (1952–2006)",
    "RON" to "Романски леу",
    "RSD" to "Српски динар",
    "RUB" to "Руска рубља",
    "RUR" to "Руска рубља (1991–1998)",
    "RWF" to "Руандски франк",
    "SAR" to "Саудиски ријал",
    "SBD" to "Соломонски долар",
    "SCR" to "Сејшелска рупија",
    "SDD" to "Стар судански динар",
    "SDG" to "Суданска фунта",
    "SDP" to "Стара суданска фунта",
    "SEK" to "Шведска круна",
    "SGD" to "Сингапурски долар",
    "SHP" to "Фунта на Света Елена",
    "SIT" to "Словенечки толар",
    "SKK" to "Словачка круна",
    "SLE" to "Сиералеонско леоне",
    "SLL" to "Сиералеонско леоне (1964 – 2022)",
    "SOS" to "Сомалијски шилинг",
    "SRD" to "Суринамски долар",
    "SRG" to "Суринамски гилдер",
    "SSP" to "Јужносуданска фунта",
    "STD" to "Добра на Саун Томе и Принсип (1977–2017)",
    "STN" to "Добра на Сао Томе и Принсипе",
    "SUR" to "Советска рубља",
    "SVC" to "Салвадорски колон",
    "SYP" to "Сиријска фунта",
    "SZL" to "Свазилендски лиланген",
    "THB" to "Таи бат",
    "TJR" to "Таџикистанска рубља",
    "TJS" to "Таџикистански сомони",
    "TMM" to "Туркменистански манат",
    "TMT" to "Туркменист. манат",
    "TND" to "Тунизиски динар",
    "TOP" to "Тонганска панга",
    "TPE" to "Тиморски ескудо",
    "TRL" to "Турска лира (1922–2005)",
    "TRY" to "Турска лира",
    "TTD" to "Долар на Тринидад и Тобаго",
    "TWD" to "Тајвански нов долар",
    "TZS" to "Танзаниски шилинг",
    "UAH" to "Украинска хривнија",
    "UGS" to "Угандиски шилинг (1966–1987)",
    "UGX" to "Угандиски шилинг",
    "USD" to "Американски долар",
    "USN" to "САД долар (Next day)",
    "USS" to "САД долар (Same day)",
    "UYP" to "Уругвајски пезос (1975–1993)",
    "UYU" to "Уругвајски пезос",
    "UZS" to "Узбекистански сом",
    "VEB" to "Венецуелски боливар (1871–2008)",
    "VEF" to "Венецуелски боливар (2008–2018)",
    "VES" to "Венецуелски боливар",
    "VND" to "Виетнамски донг",
    "VUV" to "Ванатски вату",
    "WST" to "Самоанска тала",
    "XAF" to "Централноафрикански франк",
    "XCD" to "Источнокарипски долар",
    "XOF" to "Западноафрикански франк",
    "XPF" to "ЦФП франк",
    "XXX" to "Непозната валута",
    "YDD" to "Јеменски динар",
    "YER" to "Јеменски риал",
    "YUD" to "Југословенски динар",
    "YUN" to "Југословенски конвертибилен динар",
    "ZAL" to "Јужно афрички ранд(финансиски)",
    "ZAR" to "Јужноафрикански ранд",
    "ZMK" to "Замбијска квача (1968–2012)",
    "ZMW" to "Замбијска квача",
    "ZRN" to "Заирско новозаире",
    "ZRZ" to "Заирско заире",
    "ZWD" to "Зимбабвиски долар",
  ) }

  val ml: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "അൻഡോറൻ പെസെയ്റ്റ",
    "AED" to "യുണൈറ്റഡ് അറബ് എമിറേറ്റ്സ് ദിർഹം",
    "AFA" to "അഫ്ഘാനി (1927–2002)",
    "AFN" to "അഫ്‌ഗാൻ അഫ്‌‌ഗാനി",
    "ALL" to "അൽബേനിയൻ ലെക്",
    "AMD" to "അർമേനിയൻ ഡ്രാം",
    "ANG" to "നെതർലാൻഡ്‌സ് ആന്റിലൻ ഗിൽഡർ",
    "AOA" to "അംഗോളൻ ‍ക്വാൻസ",
    "AOK" to "അംഗോളൻ ‍ക്വാൻസ (1977–1990)",
    "AON" to "അംഗോളൻ ‍ന്യൂ ക്വാൻസ (1990–2000)",
    "AOR" to "അംഗോളൻ ‍ക്വാൻസ റിയാജസ്റ്റാഡോ (1995–1999)",
    "ARA" to "അർജൻറീൻ ഓസ്ട്രൽ",
    "ARP" to "അർജൻറീൻ പെയ്സോ (1983–1985)",
    "ARS" to "അർജൻറീൻ പെസോ",
    "ATS" to "ഓസ്ട്രേലിയൻ ഷില്ലിംഗ്",
    "AUD" to "ഓസ്ട്രേലിയൻ ഡോളർ",
    "AWG" to "അറൂബൻ ഫ്ലോറിൻ",
    "AZM" to "അസർബയ്ജാനിയൻ മനത് (1993–2006)",
    "AZN" to "അസർബൈജാനി മനത്",
    "BAD" to "ബോസ്നിയ-ഹെർസഗോവിന ദിനാർ",
    "BAM" to "ബോസ്‌നിയ-ഹെർസഗോവിന കൺവേർട്ടബിൾ മാർക്ക്",
    "BBD" to "ബാർബേഡിയൻ ഡോളർ",
    "BDT" to "ബംഗ്ലാദേശി ടാക്ക",
    "BEC" to "ബെൽജിയൻ ഫ്രാങ്ക് (കൈമാറ്റം ചെയ്യാവുന്നത്)",
    "BEF" to "ബെൽജിയൻ ഫ്രാങ്ക്",
    "BEL" to "ബൽജിയൻ ഫ്രാങ്ക്",
    "BGL" to "ബൾഗേറിയൻ ഹാർഡ് ലെവ്",
    "BGN" to "ബൾഗേറിയൻ ലെവ്",
    "BHD" to "ബഹ്റൈനി ദിനാർ",
    "BIF" to "ബറുണ്ടിയൻ ഫ്രാങ്ക്",
    "BMD" to "ബെർമുഡൻ ഡോളർ",
    "BND" to "ബ്രൂണൈ ഡോളർ",
    "BOB" to "ബൊളീവിയൻ ബൊളിവിയാനോ",
    "BOP" to "ബൊളീവിയൻ പെയ്സോ",
    "BOV" to "ബൊളീവിയൻ എംവിഡോൾ",
    "BRB" to "ബ്രസീലിയൻ ക്രുസെയ്റോ നോവോ (1967–1986)",
    "BRC" to "ബ്രസീലിയൻ ക്രുസാഡോ",
    "BRE" to "ബ്രസീലിയൻ ക്രുസെയ്റോ (1990–1993)",
    "BRL" to "ബ്രസീലിയൻ റിയാൽ",
    "BRN" to "ബ്രസീലിയൻ ക്രുസാഡോ നോവോ",
    "BRR" to "ബ്രസീലിയൻ ക്രുസെയ്റോ",
    "BSD" to "ബഹാമിയൻ ഡോളർ",
    "BTN" to "ഭൂട്ടാനീസ് ഗൾട്രം",
    "BUK" to "ബർമീസ് ചാറ്റ്",
    "BWP" to "ബോട്‌സ്വാനൻ പ്യുല",
    "BYB" to "ബെലാറഷ്യൻ ന്യൂ റൂബിൾ (1994–1999)",
    "BYN" to "ബെലാറുഷ്യൻ റൂബിൾ",
    "BYR" to "ബെലാറുഷ്യൻ റൂബിൾ (2000–2016)",
    "BZD" to "ബെലീസ് ഡോളർ",
    "CAD" to "കനേഡിയൻ ഡോളർ",
    "CDF" to "കോങ്കളീസ് ഫ്രാങ്ക്",
    "CHE" to "WIR യൂറോ",
    "CHF" to "സ്വിസ് ഫ്രാങ്ക്",
    "CHW" to "WIR ഫ്രാങ്ക്",
    "CLF" to "ചിലിയൻ യൂണിഡാഡ്സ് ഡി ഫോമെൻറോ",
    "CLP" to "ചിലിയൻ പെസോ",
    "CNH" to "ചൈനീസ് യുവാൻ (ഓഫ്‌ഷോർ)",
    "CNY" to "ചൈനീസ് യുവാൻ",
    "COP" to "കൊളംബിയൻ പെസോ",
    "COU" to "യൂണിഡാഡ് ഡി വാലർ റിയൽ",
    "CRC" to "കോസ്റ്റാ റിക്കൻ കോളൻ",
    "CSD" to "പ്രാചീന സെർബിയൻ ദിനാർ",
    "CSK" to "ചെക്കോസ്ലൊവാക്ക് ഹാർഡ് കൊരൂന",
    "CUC" to "ക്യൂബൻ കൺവേർട്ടബിൾ പെസോ",
    "CUP" to "ക്യൂബൻ പെസോ",
    "CVE" to "കേപ് വെർദിയൻ എസ്‌ക്യുഡോ",
    "CYP" to "സൈപ്രസ് പൌണ്ട്",
    "CZK" to "ചെക്ക് റിപ്പബ്ലിക് കൊരുണ",
    "DDM" to "കിഴക്കൻ ജർമൻ ഓസ്റ്റ്മാർക്ക്",
    "DEM" to "ജർമൻ മാർക്ക്",
    "DJF" to "ദിജിബൗട്ടിയൻ ഫ്രാങ്ക്",
    "DKK" to "ഡാനിഷ് ക്രോണെ",
    "DOP" to "ഡൊമിനിക്കൻ പെസോ",
    "DZD" to "അൾജീരിയൻ ദിനാർ",
    "ECS" to "ഇക്വഡോർ സൂക്രേ",
    "ECV" to "ഇക്വഡോർ യൂണിഡാഡ് വാലർ കോൺസ്റ്റൻറെ (UVC)",
    "EEK" to "എസ്റ്റൌനിയൻ ക്രൂൺ",
    "EGP" to "ഈജിപ്‌ഷ്യൻ പൗണ്ട്",
    "ERN" to "എറിത്രിയൻ നക്ഫ",
    "ESA" to "സ്പാനിഷ് പസെയ്റ്റ (A അക്കൌണ്ട്)",
    "ESB" to "സ്പാനിഷ് പസെയ്റ്റ (കൈമാറ്റം ചെയ്യാവുന്ന അക്കൌണ്ട്)",
    "ESP" to "സ്പാനിഷ് പസെയ്റ്റ",
    "ETB" to "എത്യോപ്യൻ ബിർ",
    "EUR" to "യൂറോ",
    "FIM" to "ഫിന്നിഷ് മാർക്ക",
    "FJD" to "ഫിജിയൻ ഡോളർ",
    "FKP" to "ഫാക്ക്‌ലാന്റ് ദ്വീപുകളുടെ പൗണ്ട്",
    "FRF" to "ഫ്രാങ്ക്",
    "GBP" to "ബ്രിട്ടീഷ് പൗണ്ട്",
    "GEK" to "ജോർ‍ജ്ജിയൻ ക്യൂപോൺ ലാരിറ്റ്",
    "GEL" to "ജോർജ്ജിയൻ ലാറി",
    "GHC" to "ഘാന കെഡി (1979–2007)",
    "GHS" to "ഘാനയൻ കെഡി",
    "GIP" to "ജിബ്രാൾട്ടർ പൗണ്ട്",
    "GMD" to "ഗാംബിയൻ ദലാസി",
    "GNF" to "ഗിനിയൻ ഫ്രാങ്ക്",
    "GNS" to "ഗിനിയ സൈലി",
    "GQE" to "ഇക്വിറ്റോറിയൽ ഗിനിയ എക്വീലെ ഗിനിയാന",
    "GRD" to "ഗ്രീക്ക് ഡ്രാക്ക്മ",
    "GTQ" to "ഗ്വാട്ടിമാലൻ ക്വെറ്റ്‌സൽ",
    "GWE" to "പോർച്ചുഗീസ് ഗിനി എസ്ക്യൂഡോ",
    "GWP" to "ഗിനിയ-ബിസാവു പെയ്സോ",
    "GYD" to "ഗയാനീസ് ഡോളർ",
    "HKD" to "ഹോങ്കോങ്ങ് ഡോളർ",
    "HNL" to "ഹോണ്ടുറൻ ലെംപിറ",
    "HRD" to "ക്രൊയേഷ്യൻ ദിനാർ",
    "HRK" to "ക്രൊയേഷൻ ക്യുന",
    "HTG" to "ഹെയ്‌തിയൻ ഗൂർഡ്",
    "HUF" to "ഹംഗേറിയൻ ഫോറിന്റ്",
    "IDR" to "ഇന്തോനേഷ്യൻ റുപിയ",
    "IEP" to "ഐറിഷ് പൌണ്ട്",
    "ILP" to "ഇസ്രയേലി പൌണ്ട്",
    "ILS" to "ഇസ്രായേലി ന്യൂ ഷെക്കെൽ",
    "INR" to "ഇന്ത്യൻ രൂപ",
    "IQD" to "ഇറാഖി ദിനാർ",
    "IRR" to "ഇറാനിയൻ റിയാൽ",
    "ISK" to "ഐസ്‌ലാൻഡിക് ക്രോണ",
    "ITL" to "ഇറ്റാലിയൻ ലിറ",
    "JMD" to "ജമൈക്കൻ ഡോളർ",
    "JOD" to "ജോർദ്ദാനിയൻ ദിനാർ",
    "JPY" to "ജാപ്പനീസ് യെൻ",
    "KES" to "കെനിയൻ ഷില്ലിംഗ്",
    "KGS" to "കിർഗിസ്ഥാനി സോം",
    "KHR" to "കംബോഡിയൻ റീൽ",
    "KMF" to "കൊമോറിയൻ ഫ്രാങ്ക്",
    "KPW" to "ഉത്തര കൊറിയൻ വോൺ",
    "KRW" to "ദക്ഷിണ കൊറിയൻ വോൺ",
    "KWD" to "കുവൈറ്റി ദിനാർ",
    "KYD" to "കേമാൻ ഐലൻഡ്‌സ് ഡോളർ",
    "KZT" to "കസാക്കിസ്ഥാനി ടെംഗെ",
    "LAK" to "ലാവോഷിയൻ കിപ്",
    "LBP" to "ലെബനീസ് പൗണ്ട്",
    "LKR" to "ശ്രീലങ്കൻ റുപ്പീ",
    "LRD" to "ലൈബീരിയൻ ഡോളർ",
    "LSL" to "ലെസോതോ ലോത്തി",
    "LTL" to "ലിത്വാനിയൻ ലിറ്റാസ്",
    "LTT" to "ലിത്വാനിയൻ തലോനാസ്",
    "LUC" to "ലക്സംബർഗ് കൺവേർട്ടിബിൾ ഫ്രാങ്ക്",
    "LUF" to "ലക്സംബർഗ് ഫ്രാങ്ക്",
    "LUL" to "ലക്സംബർഗ് ഫിനാൻഷ്യൽ ഫ്രാങ്ക്",
    "LVL" to "ലാറ്റ്വിയൻ ലാറ്റ്സ്",
    "LVR" to "ലാറ്റ്വിയൻ റൂബിൾ",
    "LYD" to "ലിബിയൻ ദിനാർ",
    "MAD" to "മൊറോക്കൻ ദിർഹം",
    "MAF" to "മൊറോക്കൻ ഫ്രാങ്ക്",
    "MDL" to "മൊൾഡോവൻ ലിയു",
    "MGA" to "മഡഗാസി ഏരിയറി",
    "MGF" to "മഡഗാസ്കർ ഫ്രാങ്ക്",
    "MKD" to "മാസിഡോണിയൻ ദിനാർ",
    "MLF" to "മാലി ഫ്രാങ്ക്",
    "MMK" to "മ്യാൻമാർ ക്യാട്",
    "MNT" to "മംഗോളിയൻ തുഗ്രിക്",
    "MOP" to "മകാനീസ് പതാക്ക",
    "MRO" to "മൗറിറ്റേനിയൻ ഔഗിയ (1973–2017)",
    "MRU" to "മൗറിറ്റേനിയൻ ഔഗിയ",
    "MTL" to "മൽത്തീസ് ലിറ",
    "MTP" to "മൽത്തീസ് പൌണ്ട്",
    "MUR" to "മൗറീഷ്യൻ റുപ്പീ",
    "MVR" to "മാൽദീവിയൻ റുഫിയ",
    "MWK" to "മലാവിയൻ ക്വച്ചാ",
    "MXN" to "മെക്സിക്കൻ പെസോ",
    "MXP" to "മെക്സിക്കൻ സിൽവർ പെയ്സോ (1861–1992)",
    "MXV" to "മെക്സിക്കൻ യൂണിഡാഡ് ഡി ഇൻവെർഷൻ (UDI)",
    "MYR" to "മലേഷ്യൻ റിംഗിറ്റ്",
    "MZE" to "മൊസാന്പിക്ക് എസ്ക്യുഡോ",
    "MZM" to "ഓൾഡ് മൊസാന്പിക്ക് മെറ്റിക്കൽ",
    "MZN" to "മൊസാംബിക്കൻ മെറ്റിക്കൽ",
    "NAD" to "നമീബിയൻ ഡോളർ",
    "NGN" to "നൈജീരിയൻ നൈറ",
    "NIC" to "നികരാഗ്വൻ കൊർഡോബ",
    "NIO" to "നിക്കരാഗ്വൻ കോർഡോബ",
    "NLG" to "നെതർലൻഡ്സ് ഗിൽഡർ",
    "NOK" to "നോർവീജിയൻ ക്രോണെ",
    "NPR" to "നേപ്പാളീസ് റുപ്പീ",
    "NZD" to "ന്യൂസിലാന്റ് ഡോളർ",
    "OMR" to "ഒമാനി റിയാൽ",
    "PAB" to "പനാമനിയൻ ബാൽബോവ",
    "PEI" to "പെറൂവിയൻ ഇൻറി",
    "PEN" to "പെറുവിയൻ സോൾ",
    "PES" to "പെറൂവിയൻ സോൾ (1863–1965)",
    "PGK" to "പാപ്പുവ ന്യൂ ഗിനിയൻ കിന",
    "PHP" to "ഫിലിപ്പീനി പെസോ",
    "PKR" to "പാക്കിസ്ഥാനി റുപ്പീ",
    "PLN" to "പോളിഷ് സ്ലോട്ടി",
    "PLZ" to "പോളിഷ് സ്ലോട്ടി (1950–1995)",
    "PTE" to "പോർച്ചുഗീസ് എസ്ക്യുഡോ",
    "PYG" to "പരാഗ്വേയൻ ഗ്വരനീ",
    "QAR" to "ഖത്തർ റിയാൽ",
    "RHD" to "റൊഡേഷ്യൻ ഡോളർ",
    "ROL" to "പ്രാചീന റൊമേനിയൻ ലിയു",
    "RON" to "റൊമാനിയൻ ലെയു",
    "RSD" to "സെർബിയൻ ദിനാർ",
    "RUB" to "റഷ്യൻ റൂബിൾ",
    "RUR" to "റഷ്യൻ റൂബിൾ (1991–1998)",
    "RWF" to "റുവാണ്ടൻ ഫ്രാങ്ക്",
    "SAR" to "സൗദി റിയാൽ",
    "SBD" to "സോളമൻ ദ്വീപ് ഡോളർ",
    "SCR" to "സീഷെലോയിസ് റുപ്പീ",
    "SDD" to "പ്രാചീന സുഡാനീസ് ദിനാർ",
    "SDG" to "സുഡാനീസ് പൗണ്ട്",
    "SDP" to "പ്രാചീന സുഡാനീസ് പൌണ്ട്",
    "SEK" to "സ്വീഡിഷ് ക്രോണ",
    "SGD" to "സിംഗപ്പൂർ ഡോളർ",
    "SHP" to "സെന്റ് ഹെലീന പൗണ്ട്",
    "SIT" to "സ്ലൊവേനിയ റ്റോളർ",
    "SKK" to "സ്ലോവാക് കൊരൂന",
    "SLE" to "സിയെറ ലിയോണിയൻ ലിയോൺ",
    "SLL" to "സിയെറ ലിയോണിയൻ ലിയോൺ (1964—2022)",
    "SOS" to "സോമാലി ഷില്ലിംഗ്",
    "SRD" to "സുരിനെയിമിസ് ഡോളർ",
    "SRG" to "സൂരിനാം ഗിൽഡർ",
    "SSP" to "ദക്ഷിണ സുഡാനീസ് പൗണ്ട്",
    "STD" to "സാവോ ടോമി ആൻഡ് പ്രിൻസിപെ ഡോബ്ര (1977–2017)",
    "STN" to "സാവോ ടോമി ആൻഡ് പ്രിൻസിപെ ഡോബ്ര",
    "SUR" to "സോവിയറ്റ് റൂബിൾ",
    "SVC" to "എൽ സാൽവഡോർ കോളൻ",
    "SYP" to "സിറിയൻ പൗണ്ട്",
    "SZL" to "സ്വാസി ലിലാംഗനി",
    "THB" to "തായ് ബട്ട്",
    "TJR" to "താജിക്കിസ്ഥാൻ റൂബിൾ",
    "TJS" to "താജിക്കിസ്ഥാനി സോംനി",
    "TMM" to "തുർക്മെനിസ്ഥാൻ മനത്",
    "TMT" to "തുർക്ക്‌മെനിസ്ഥാനി മനത്",
    "TND" to "ടുണീഷ്യൻ ദിനാർ",
    "TOP" to "ടോംഗൻ പാംഗ",
    "TPE" to "തിമോർ എസ്ക്യൂഡോ",
    "TRL" to "പ്രാചീന തുർക്കിഷ് ലിറ",
    "TRY" to "ടർക്കിഷ് ലിറ",
    "TTD" to "ട്രിനിഡാഡ് അന്റ് ടുബാഗോ ഡോളർ",
    "TWD" to "ന്യൂ തായ്‌വാൻ ഡോളർ",
    "TZS" to "ടാൻസാനിയൻ ഷില്ലിംഗ്",
    "UAH" to "ഉക്രേനിയൻ ഹ്രിവ്‌നിയ",
    "UAK" to "യുക്രേനിയൻ കാർബോവാനെസ്",
    "UGS" to "ഉഗാണ്ടൻ ഷില്ലിംഗ് (1966–1987)",
    "UGX" to "ഉഗാണ്ടൻ ഷില്ലിംഗ്",
    "USD" to "യു.എസ്. ഡോളർ",
    "USN" to "യുഎസ് ഡോളർ (അടുത്ത ദിവസം)",
    "USS" to "യുഎസ് ഡോളർ (അതേ ദിവസം)",
    "UYI" to "ഉറുഗ്വേ പെയ്സോ എൻ യൂണിഡാഡ്സ്",
    "UYP" to "ഉറുഗ്വേ പെയ്സോ (1975–1993)",
    "UYU" to "ഉറുഗ്വേയൻ പെസോ",
    "UZS" to "ഉസ്‌ബെക്കിസ്ഥാനി സോം",
    "VEB" to "വെനസ്വേലൻ ബോലിവർ (1871–2008)",
    "VEF" to "വെനിസ്വേലൻ ബൊളീവർ (2008–2018)",
    "VES" to "വെനിസ്വേലൻ ബൊളീവർ",
    "VND" to "വിയറ്റ്നാമീസ് ഡോങ്",
    "VUV" to "വന്വാതു വാതു",
    "WST" to "സമോവൻ താല",
    "XAF" to "മദ്ധ്യ ആഫ്രിക്കൻ [CFA] ഫ്രാങ്ക്",
    "XAG" to "വെള്ളി",
    "XAU" to "സ്വർണ്ണം",
    "XBA" to "യൂറോപ്യൻ കോന്പസിറ്റ് യൂണിറ്റ്",
    "XBB" to "യൂറോപ്യൻ മോണിറ്ററി യൂണിറ്റ്",
    "XBC" to "യൂറോപ്യൻ യൂണിറ്റ് ഓഫ് അക്കൌണ്ട് (XBC)",
    "XBD" to "യൂറോപ്യൻ യൂണിറ്റ് ഓഫ് അക്കൌണ്ട് (XBD)",
    "XCD" to "കിഴക്കൻ കരീബിയൻ ഡോളർ",
    "XDR" to "സ്പെഷ്യൽ ഡ്രോയിംഗ് റൈറ്റ്സ്",
    "XEU" to "യൂറോപ്യൻ നാണയ യൂണിറ്റ്",
    "XFO" to "ഫ്രെഞ്ച് ഗോൾഡ് ഫ്രാങ്ക്",
    "XFU" to "ഫ്രെഞ്ച് UIC-ഫ്രാങ്ക്",
    "XOF" to "പശ്ചിമ ആഫ്രിക്കൻ [CFA] ഫ്രാങ്ക്",
    "XPD" to "പലാഡിയം",
    "XPF" to "CFP ഫ്രാങ്ക്",
    "XPT" to "പ്ലാറ്റിനം",
    "XRE" to "RINET ഫണ്ട്സ്",
    "XTS" to "ടെസ്റ്റിംഗിനുള്ള കറൻസി കോഡ്",
    "XXX" to "അജ്ഞാത നാണയം",
    "YDD" to "യമനി ദിനാർ",
    "YER" to "യെമനി റിയാൽ",
    "YUD" to "യൂഗോസ്ലേവിയൻ ഹാർഡ് ദിനാർ",
    "YUM" to "യൂഗോസ്ലേവിയൻ നോവി ദിനാർ",
    "YUN" to "യൂഗോസ്ലേവിയൻ കൺവേർട്ടിബിൾ ദിനാർ",
    "ZAL" to "ദക്ഷിണാഫ്രിക്കൻ റാൻഡ് (ഫിനാൻഷ്യൽ)",
    "ZAR" to "ദക്ഷിണാഫ്രിക്കൻ റാൻഡ്",
    "ZMK" to "സാംബിയൻ ക്വാച (1968–2012)",
    "ZMW" to "സാംബിയൻ ക്വാച്ച",
    "ZRN" to "സൈറിയൻ ന്യൂ സൈർ",
    "ZRZ" to "സൈറിയൻ സൈർ",
    "ZWD" to "സിംബാബ്‌വെ ഡോളർ",
  ) }

  val mn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "арабын нэгдсэн эмиратын дирхам",
    "AFN" to "Афганистаны афгани",
    "ALL" to "Албанийн лек",
    "AMD" to "Арменийн драм",
    "ANG" to "Нидерландын Антиллийн гулдер",
    "AOA" to "Анголын кванза",
    "ARS" to "Аргентины песо",
    "AUD" to "Австралийн доллар",
    "AWG" to "Арубын флорин",
    "AZN" to "Азербайжаны манат",
    "BAM" to "Босни-Герцеговины хөрвөгч марк",
    "BBD" to "барбадос доллар",
    "BDT" to "Бангладешийн така",
    "BGN" to "Болгарын лев",
    "BHD" to "Бахрейн динар",
    "BIF" to "Бурундийн франк",
    "BMD" to "Бермудын доллар",
    "BND" to "Брунейн доллар",
    "BOB" to "Боливийн боливиано",
    "BRL" to "Бразилийн реал",
    "BSD" to "Багамын доллар",
    "BTN" to "Бутаны нгултрум",
    "BWP" to "Ботсванийн пула",
    "BYN" to "Беларусийн рубль",
    "BYR" to "беларусь рубль (2000–2016)",
    "BZD" to "Белизийн доллар",
    "CAD" to "канад доллар",
    "CDF" to "Конгогийн франк",
    "CHF" to "Швейцарийн франк",
    "CLP" to "Чилийн песо",
    "CNH" to "Хятадын юань (офшор)",
    "CNY" to "Хятадын юань",
    "COP" to "Колумбын песо",
    "CRC" to "Коста-Рикагийн колон",
    "CUC" to "Кубын хөрвөгч песо",
    "CUP" to "Кубын песо",
    "CVE" to "Кабо-Вердийн эскудо",
    "CZK" to "Чехийн крон",
    "DJF" to "Жибутийн франк",
    "DKK" to "Данийн крон",
    "DOP" to "Доминиканы песо",
    "DZD" to "Алжирийн доллар",
    "EGP" to "Египетийн фунт",
    "ERN" to "Эритрейн накфа",
    "ETB" to "Этиопын бирр",
    "EUR" to "евро",
    "FJD" to "Фижигийн доллар",
    "FKP" to "Фолклендийн арлуудын паунд",
    "GBP" to "Британийн фунт",
    "GEL" to "Гүржийн лари",
    "GHS" to "Ганагийн седи",
    "GIP" to "Гибралтарын фунт",
    "GMD" to "Гамбийн даласи",
    "GNF" to "Гвинейн франк",
    "GTQ" to "Гватемалын кецал",
    "GYD" to "Гайанын доллар",
    "HKD" to "Хонг Конгийн доллар",
    "HNL" to "Гондурасын лемпира",
    "HRK" to "Хорватын куна",
    "HTG" to "Гаитийн гурд",
    "HUF" to "Унгарын форинт",
    "IDR" to "Индонезийн рупи",
    "ILS" to "Израилийн шинэ шекел",
    "INR" to "Энэтхэгийн рупи",
    "IQD" to "Иракийн динар",
    "IRR" to "Ираны риял",
    "ISK" to "Исландын крон",
    "JMD" to "Ямайкийн доллар",
    "JOD" to "Йорданы динар",
    "JPY" to "Японы иен",
    "KES" to "Кенийн шиллинг",
    "KGS" to "Кыргызын сом",
    "KHR" to "Камбожийн риел",
    "KMF" to "Коморын франк",
    "KPW" to "Хойд Солонгосын вон",
    "KRW" to "Өмнөд Солонгосын вон",
    "KWD" to "Кувейтийн динар",
    "KYD" to "Кайманы арлуудын доллар",
    "KZT" to "Казахстаны тэнгэ",
    "LAK" to "Лаосын кип",
    "LBP" to "Ливаны фунт",
    "LKR" to "Шри-Ланкийн рупи",
    "LRD" to "Либерийн доллар",
    "LSL" to "Лесото лоти",
    "LTL" to "литвийн литас",
    "LVL" to "латвийн лац",
    "LYD" to "Ливийн доллар",
    "MAD" to "Мороккогийн дирхэм",
    "MDL" to "Молдовын лей",
    "MGA" to "Малагасийн ариари",
    "MKD" to "Македонийн динар",
    "MMK" to "Мьянмарын киат",
    "MNT" to "Монгол төгрөг",
    "MOP" to "Макаогийн патака",
    "MRO" to "мавритан угия (1973–2017)",
    "MRU" to "Мавританийн угия",
    "MUR" to "Маврикийн рупи",
    "MVR" to "Мальдивийн руфия",
    "MWK" to "Малавийн квача",
    "MXN" to "Мексикийн песо",
    "MYR" to "Малайзын рингит",
    "MZN" to "Мозамбикийн метикал",
    "NAD" to "Намибийн доллар",
    "NGN" to "Нигерийн найра",
    "NIO" to "Никарагуагийн кордоба",
    "NOK" to "Норвегийн крон",
    "NPR" to "Балбын рупи",
    "NZD" to "Шинэ Зеландын доллар",
    "OMR" to "Оманийн риал",
    "PAB" to "Панамын бальбоа",
    "PEN" to "Перугийн соль",
    "PGK" to "Папуа-Шинэ Гвинейн кина",
    "PHP" to "Филиппиний песо",
    "PKR" to "Пакистаны рупи",
    "PLN" to "Польшийн злот",
    "PYG" to "Парагвайн гуарани",
    "QAR" to "Катарын риал",
    "RON" to "Румыны лей",
    "RSD" to "Сербийн динар",
    "RUB" to "Оросын рубль",
    "RWF" to "Руандагийн франк",
    "SAR" to "Саудын риял",
    "SBD" to "Соломоны арлуудын доллар",
    "SCR" to "Сейшелийн рупи",
    "SDG" to "Суданы фунт",
    "SEK" to "Шведийн крон",
    "SGD" to "Сингапурын доллар",
    "SHP" to "Сент Хеленагийн фунт",
    "SLE" to "Сьерра-Леоны леон",
    "SLL" to "Сьерра-Леоны леон (1964—2022)",
    "SOS" to "Сомалийн шиллинг",
    "SRD" to "Суринамын доллар",
    "SSP" to "Өмнөд Суданы фунт",
    "STD" to "сан-томе ба принсипи добра (1977–2017)",
    "STN" to "Сан-Томе ба Принсипигийн добра",
    "SYP" to "Сирийн фунт",
    "SZL" to "Свазиландын лилангени",
    "THB" to "Тайландын бат",
    "TJS" to "Тажикийн сомон",
    "TMT" to "Туркмены манат",
    "TND" to "Тунисын доллар",
    "TOP" to "Тонгагийн панга",
    "TRY" to "Туркийн лира",
    "TTD" to "Тринидад ба Тобагогийн доллар",
    "TWD" to "Шинэ Тайванийн доллар",
    "TZS" to "Танзанийн шиллинг",
    "UAH" to "Украины гривна",
    "UGX" to "Угандагийн шиллинг",
    "USD" to "америк доллар",
    "UYU" to "Уругвайн песо",
    "UZS" to "Узбекийн сом",
    "VEF" to "венесуэлийн боливар (2008–2018)",
    "VES" to "Венесуэлийн боливар",
    "VND" to "Вьетнамын донг",
    "VUV" to "Вануатугийн вату",
    "WST" to "Самоагийн тала",
    "XAF" to "Төв Африкийн франк",
    "XCD" to "Зүүн Карибийн доллар",
    "XOF" to "Баруун Африкийн франк",
    "XPF" to "Францын колонийн франк",
    "XXX" to "тодорхойгүй мөнгөн тэмдэгт",
    "YER" to "Йемений риял",
    "ZAR" to "Өмнөд Африкийн ранд",
    "ZMK" to "Замби квача (1968–2012)",
    "ZMW" to "Замбийн квача",
  ) }

  val mn_Mong: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "бразил реал",
    "CNY" to "юань",
    "EUR" to "евро",
    "GBP" to "фунт стерлинг",
    "INR" to "рупи",
    "JPY" to "иен",
    "MNT" to "төгрөг",
    "RUB" to "рубль",
    "USD" to "ам. доллар",
  ) }

  val mn_Mong_MN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "ᠪᠷᠠᠽᠢᠯ ᠤᠨ ᠷᠧᠠᠯ",
    "CNY" to "ᠬᠢᠲᠠᠳ ᠶᠤᠸᠠᠨ",
    "EUR" to "ᠶᠧᠸᠷᠣ",
    "GBP" to "ᠪᠷᠢᠲ᠋ᠠᠨᠢ ᠢᠢᠨ ᠫᠤᠢᠨᠳ᠋",
    "INR" to "ᠡᠨᠡᠳᠬᠡᠭ᠌ ᠷᠦᠫᠢ",
    "JPY" to "ᠶᠠᠫᠣᠨ ᠧᠨ",
    "MNT" to "ᠳᠥᠬᠥᠷᠢᠭ᠌",
    "RUB" to "ᠣᠷᠥᠰ ᠷᠥᠪᠯᠢ",
    "USD" to "ᠠᠮᠸᠷᠢᠻᠠ ᠳ᠋ᠣᠯᠯᠠᠷ",
    "XXX" to "ᠲᠣᠳᠣᠷᠬᠠᠢ ᠥᠭᠡᠢ ᠮᠥᠩᠭᠥᠨ ᠲᠡᠮᠳᠡᠭᠳᠥ",
  ) }

  val mni: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "ব্রাজিলিয়ান রেয়াল",
    "CNY" to "চাইনিজ য়ুআন",
    "EUR" to "য়ুরো",
    "GBP" to "ব্রিটিশ পাউন্দ",
    "INR" to "ইন্দিয়ান রুপী",
    "JPY" to "জাপানিজ য়েন",
    "RUB" to "রুসিয়ান রুবল",
    "USD" to "য়ু এস দি",
    "XXX" to "মশকখংদবা করেন্সি",
  ) }

  val mni_Beng: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "ব্রাজিলিয়ান রেয়াল",
    "CNY" to "চাইনিজ য়ুআন",
    "EUR" to "য়ুরো",
    "GBP" to "ব্রিটিশ পাউন্দ",
    "INR" to "ইন্দিয়ান রুপী",
    "JPY" to "জাপানিজ য়েন",
    "RUB" to "রুসিয়ান রুবল",
    "USD" to "য়ু এস দি",
    "XXX" to "মশকখংদবা করেন্সি",
  ) }

  val mni_Mtei: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val moh: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val mr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "संयुक्त अरब अमीरात दिरहॅम",
    "AFN" to "अफगाण अफगाणी",
    "ALL" to "अल्बानियन लेक",
    "AMD" to "आर्मेनियन द्रॅम",
    "ANG" to "नेदरलँडचा अँटिलीन गिल्डर",
    "AOA" to "अँगोलन क्वॅन्झा",
    "ARS" to "अर्जेंटाइन पेसो",
    "AUD" to "ऑस्ट्रेलियन डॉलर",
    "AWG" to "अरुबा फ्लोरिन",
    "AZN" to "अझरबैझानी मानाट",
    "BAM" to "बोस्निया-हर्जेगोविना विनिमय मार्क",
    "BBD" to "बार्बाडियन डॉलर",
    "BDT" to "बांगलादेशी टका",
    "BGN" to "बल्गेरियन लेव",
    "BHD" to "बाहरिनी दिनार",
    "BIF" to "बुरुंडियन फ्रँक",
    "BMD" to "बर्मुडा डॉलर",
    "BND" to "ब्रुनेई डॉलर",
    "BOB" to "बोलिव्हियन बोलिव्हियानो",
    "BRL" to "ब्राझिलियन रियाल",
    "BSD" to "बहामी डॉलर",
    "BTN" to "भूतानी एंगल्ट्रम",
    "BWP" to "बोट्सवानन पुला",
    "BYN" to "बेलारुशियन रुबल",
    "BYR" to "बेलारुशियन रुबल (2000–2016)",
    "BZD" to "बेलीझ डॉलर",
    "CAD" to "कॅनडियन डॉलर",
    "CDF" to "काँगोलीज फ्रँक",
    "CHF" to "स्विस फ्रँक",
    "CLP" to "चिली पेसो",
    "CNH" to "चिनी युआन (ऑफशोर)",
    "CNY" to "चीनी युआन",
    "COP" to "कोलंबियन पेसो",
    "CRC" to "कोस्टारिकन कोलोन",
    "CUC" to "क्यूबन विनिमय पेसो",
    "CUP" to "क्यूबन पेसो",
    "CVE" to "केप व्हर्डेयन एस्कुडो",
    "CZK" to "झेक प्रजासत्ताक कोरुना",
    "DJF" to "जिबौटियन फ्रँक",
    "DKK" to "डॅनिश क्रोन",
    "DOP" to "डोमिनिकन पेसो",
    "DZD" to "अल्जेरियन दिनार",
    "EGP" to "इजिप्शियन पाउंड",
    "ERN" to "इरिट्रियन नाक्फा",
    "ETB" to "इथिओपियन बिर",
    "EUR" to "युरो",
    "FJD" to "फिजियन डॉलर",
    "FKP" to "फॉकलंड आयलंड पाउंड",
    "GBP" to "ब्रिटिश पाऊंड",
    "GEL" to "जॉर्जियन लारी",
    "GHS" to "घानीयन सेडी",
    "GIP" to "जिब्राल्टर पाउंड",
    "GMD" to "गाम्बियन डालासी",
    "GNF" to "गिनी फ्रँक",
    "GTQ" to "ग्वाटेमालाचे क्वेत्झाल",
    "GYD" to "गयाना डॉलर",
    "HKD" to "हाँगकाँग डॉलर",
    "HNL" to "होन्डुरन लेंपिरा",
    "HRK" to "क्रोएशियन कूना",
    "HTG" to "हैती गोअर्ड",
    "HUF" to "हंगेरियन फॉरिन्ट",
    "IDR" to "इंडोनेशियन रुपिया",
    "ILS" to "ईस्त्रायली न्यू शेकेल",
    "INR" to "भारतीय रुपया",
    "IQD" to "इराकी दिनार",
    "IRR" to "इराणी रियाल",
    "ISK" to "आइसलँडिक क्रोना",
    "JMD" to "जमैकन डॉलर",
    "JOD" to "जॉर्डनियन दिनार",
    "JPY" to "जपानी येन",
    "KES" to "केनियन शिलिंग",
    "KGS" to "किरगिस्तानी सॉम",
    "KHR" to "कंबोडियन रियेल",
    "KMF" to "कोमोरियन फ्रँक",
    "KPW" to "उत्तर कोरियन वॉन",
    "KRW" to "दक्षिण कोरियन वॉन",
    "KWD" to "कुवैती दिनार",
    "KYD" to "केमेन आयलॅंड डॉलर",
    "KZT" to "कझाकिस्तानी तेंगे",
    "LAK" to "लाओशियन किप",
    "LBP" to "लेबनीज पाउंड",
    "LKR" to "श्रीलंकन रुपया",
    "LRD" to "लाइबेरियन डॉलर",
    "LSL" to "लेसोटो लोटी",
    "LTL" to "लिथुआनियन लिटास",
    "LVL" to "लाट्व्हियन लाट्झ",
    "LYD" to "लिबियाचा दिनार",
    "MAD" to "मोरोक्को दिरहॅम",
    "MDL" to "मोल्डोवन लेउ",
    "MGA" to "मालागासी एरियारी",
    "MKD" to "मॅसेडोनियन देनार",
    "MMK" to "म्यानमार क्याट",
    "MNT" to "मंगोलियन टुग्रिक",
    "MOP" to "मॅकॅनीज् पटाका",
    "MRO" to "मॉरिटानियन ओगिया (1973–2017)",
    "MRU" to "मॉरिटानियन ओगिया",
    "MUR" to "मॉरिशियन रुपी",
    "MVR" to "मालदीवियन रुफिया",
    "MWK" to "मालावियन क्वाचा",
    "MXN" to "मेक्सिको पेसो",
    "MYR" to "मलेशियन रिंगिट",
    "MZN" to "मोझांबिकन मेटिकल",
    "NAD" to "नमिबियन डॉलर",
    "NGN" to "नायजेरियन नायरा",
    "NIO" to "निकाराग्वन कोर्डोबा",
    "NOK" to "नॉर्वेजियन क्रोन",
    "NPR" to "नेपाळी रुपया",
    "NZD" to "न्यूझीलँड डॉलर",
    "OMR" to "ओमानी रियाल",
    "PAB" to "पनामा बाल्बोआ",
    "PEN" to "पेरुवियन सोल",
    "PGK" to "पापुआ न्यू गिनीयन किना",
    "PHP" to "फिलिपिनी पेसो",
    "PKR" to "पाकिस्तानी रुपया",
    "PLN" to "पोलिश झ्लॉटी",
    "PYG" to "पराग्वे ग्वारानी",
    "QAR" to "कतारी रियाल",
    "RON" to "रोमानियन लेऊ",
    "RSD" to "सर्बियन दिनार",
    "RUB" to "रशियन रुबल",
    "RWF" to "रवांडा फ्रँक",
    "SAR" to "सौदी रियाल",
    "SBD" to "सोलोमन आयलँड्स डॉलर",
    "SCR" to "सेशेलोईस रुपी",
    "SDG" to "सुदानी पाउंड",
    "SEK" to "स्वीडिश क्रोना",
    "SGD" to "सिंगापूर डॉलर",
    "SHP" to "सेंट हेलेना पाउंड",
    "SLE" to "सिएरा लिऑनचा लिऑन",
    "SLL" to "सिएरा लिऑनचा लिऑन (1964—2022)",
    "SOS" to "सोमाली शिलिंग",
    "SRD" to "सुरिनामी डॉलर",
    "SSP" to "दक्षिण सुदानी पाउंड",
    "STD" to "साओ टोम आणि प्रिन्सिपे डोबरा (1977–2017)",
    "STN" to "साओ टोम आणि प्रिन्सिपे डोबरा",
    "SYP" to "सीरियन पाउंड",
    "SZL" to "स्वाझी लीलांगेनी",
    "THB" to "थाई बाहत",
    "TJS" to "ताजकीस्तानी सोमोनी",
    "TMT" to "तुर्कमेनिस्तानी मानाट",
    "TND" to "ट्यूनिशियन दिनार",
    "TOP" to "टोंगन पाआंगा",
    "TRY" to "तुर्की लिरा",
    "TTD" to "त्रिनिदाद आणि टोबॅगो डॉलर",
    "TWD" to "न्यू तैवान डॉलर",
    "TZS" to "टांझानियन शिलिंग",
    "UAH" to "युक्रेनियन रिवनिया",
    "UGX" to "युगांडा शिलिंग",
    "USD" to "यूएस डॉलर",
    "UYU" to "उरुग्वेचा पेसो",
    "UZS" to "उझबेकिस्तानी सोम",
    "VEF" to "व्हेनेझुएला बोलिव्हार (2008–2018)",
    "VES" to "व्हेनेझुएला बोलिव्हार",
    "VND" to "व्हिएतनामी डोंग",
    "VUV" to "वानुआतु वाटु",
    "WST" to "सामोअन टाला",
    "XAF" to "मध्य आफ्रिकन [CFA] फ्रँक",
    "XCD" to "पूर्व कॅरीबियन डॉलर",
    "XOF" to "पश्चिम आफ्रिकन [CFA] फ्रँक",
    "XPF" to "[CFP] फ्रँक",
    "XXX" to "अज्ञात चलन",
    "YER" to "येमेनी रियाल",
    "ZAR" to "दक्षिण आफ्रिकी रँड",
    "ZMK" to "झांबियन क्वाचा (1968–2012)",
    "ZMW" to "झांबियन क्वाचा",
  ) }

  val ms: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham Emiriah Arab Bersatu",
    "AFN" to "Afghani Afghanistan",
    "ALL" to "Lek Albania",
    "AMD" to "Dram Armenia",
    "ANG" to "Guilder Antillen Belanda",
    "AOA" to "Kwanza Angola",
    "ARS" to "Peso Argentina",
    "AUD" to "Dolar Australia",
    "AWG" to "Florin Aruba",
    "AZN" to "Manat Azerbaijan",
    "BAM" to "Mark Boleh Tukar Bosnia-Herzegovina",
    "BBD" to "Dolar Barbados",
    "BDT" to "Taka Bangladesh",
    "BGN" to "Lev Bulgaria",
    "BHD" to "Dinar Bahrain",
    "BIF" to "Franc Burundi",
    "BMD" to "Dolar Bermuda",
    "BND" to "Dolar Brunei",
    "BOB" to "Boliviano Bolivia",
    "BRL" to "Real Brazil",
    "BSD" to "Dolar Bahamas",
    "BTN" to "Ngultrum Bhutan",
    "BWP" to "Pula Botswana",
    "BYN" to "Rubel Belarus baharu",
    "BYR" to "Rubel Belarus (2000–2016)",
    "BZD" to "Dolar Belize",
    "CAD" to "Dolar Kanada",
    "CDF" to "Franc Congo",
    "CHF" to "Franc Switzerland",
    "CLP" to "Peso Chile",
    "CNH" to "Yuan China (luar pesisir)",
    "CNY" to "Yuan Cina",
    "COP" to "Peso Colombia",
    "CRC" to "Colon Costa Rica",
    "CUC" to "Peso Boleh Tukar Cuba",
    "CUP" to "Peso Cuba",
    "CVE" to "Escudo Tanjung Verde",
    "CZK" to "Koruna Republik Czech",
    "DJF" to "Franc Djibouti",
    "DKK" to "Krone Denmark",
    "DOP" to "Peso Dominican",
    "DZD" to "Dinar Algeria",
    "EGP" to "Paun Mesir",
    "ERN" to "Nakfa Eritrea",
    "ETB" to "Birr Ethiopia",
    "EUR" to "Euro",
    "FJD" to "Dolar Fiji",
    "FKP" to "Paun Kepulauan Falkland",
    "GBP" to "Paun British",
    "GEL" to "Lari Georgia",
    "GHS" to "Cedi Ghana",
    "GIP" to "Paun Gibraltar",
    "GMD" to "Dalasi Gambia",
    "GNF" to "Franc Guinea",
    "GTQ" to "Quetzal Guatemala",
    "GYD" to "Dolar Guyana",
    "HKD" to "Dolar Hong Kong",
    "HNL" to "Lempira Honduras",
    "HRK" to "Kuna Croatia",
    "HTG" to "Gourde Haiti",
    "HUF" to "Forint Hungary",
    "IDR" to "Rupiah Indonesia",
    "ILS" to "Syekel Baharu Israel",
    "INR" to "Rupee India",
    "IQD" to "Dinar Iraq",
    "IRR" to "Rial Iran",
    "ISK" to "Krona Iceland",
    "JMD" to "Dolar Jamaica",
    "JOD" to "Dinar Jordan",
    "JPY" to "Yen Jepun",
    "KES" to "Syiling Kenya",
    "KGS" to "Som Kyrgystani",
    "KHR" to "Riel Kemboja",
    "KMF" to "Franc Comoria",
    "KPW" to "Won Korea Utara",
    "KRW" to "Won Korea Selatan",
    "KWD" to "Dinar Kuwait",
    "KYD" to "Dolar Kepulauan Cayman",
    "KZT" to "Tenge Kazakhstan",
    "LAK" to "Kip Laos",
    "LBP" to "Paun Lubnan",
    "LKR" to "Rupee Sri Lanka",
    "LRD" to "Dolar Liberia",
    "LSL" to "Loti Lesotho",
    "LTL" to "Litas Lithuania",
    "LVL" to "Lats Latvia",
    "LYD" to "Dinar Libya",
    "MAD" to "Dirham Maghribi",
    "MDL" to "Leu Moldova",
    "MGA" to "Ariary Malagasy",
    "MGF" to "Franc Malagasy",
    "MKD" to "Denar Macedonia",
    "MMK" to "Kyat Myanma",
    "MNT" to "Tugrik Mongolia",
    "MOP" to "Pataca Macau",
    "MRO" to "Ouguiya Mauritania (1973–2017)",
    "MRU" to "Ouguiya Mauritania",
    "MUR" to "Rupee Mauritius",
    "MVR" to "Rufiyaa Maldives",
    "MWK" to "Kwacha Malawi",
    "MXN" to "Peso Mexico",
    "MYR" to "Ringgit Malaysia",
    "MZE" to "Escudo Mozambique",
    "MZM" to "Metical Mozambique (1980–2006)",
    "MZN" to "Metikal Mozambique",
    "NAD" to "Dolar Namibia",
    "NGN" to "Naira Nigeria",
    "NIO" to "Cordoba Nicaragua",
    "NOK" to "Krone Norway",
    "NPR" to "Rupee Nepal",
    "NZD" to "Dolar New Zealand",
    "OMR" to "Rial Oman",
    "PAB" to "Balboa Panama",
    "PEN" to "Sol Peru",
    "PGK" to "Kina Papua New Guinea",
    "PHP" to "Peso Filipina",
    "PKR" to "Rupee Pakistan",
    "PLN" to "Zloty Poland",
    "PYG" to "Guarani Paraguay",
    "QAR" to "Rial Qatar",
    "RHD" to "Dolar Rhodesia",
    "RON" to "Leu Romania",
    "RSD" to "Dinar Serbia",
    "RUB" to "Rubel Rusia",
    "RWF" to "Franc Rwanda",
    "SAR" to "Riyal Saudi",
    "SBD" to "Dolar Kepulauan Solomon",
    "SCR" to "Rupee Seychelles",
    "SDG" to "Paun Sudan",
    "SEK" to "Krona Sweden",
    "SGD" to "Dolar Singapura",
    "SHP" to "Paun Saint Helena",
    "SLE" to "Leone Sierra Leone",
    "SLL" to "Leone Sierra Leone (1964—2022)",
    "SOS" to "Syiling Somali",
    "SRD" to "Dolar Surinam",
    "SSP" to "Paun Sudan selatan",
    "STD" to "Dobra Sao Tome dan Principe (1977–2017)",
    "STN" to "Dobra Sao Tome dan Principe",
    "SYP" to "Paun Syria",
    "SZL" to "Lilangeni Swazi",
    "THB" to "Baht Thai",
    "TJS" to "Somoni Tajikistan",
    "TMT" to "Manat Turkmenistan",
    "TND" to "Dinar Tunisia",
    "TOP" to "Pa’anga Tonga",
    "TRY" to "Lira Turki",
    "TTD" to "Dolar Trinidad dan Tobago",
    "TWD" to "Dolar Taiwan Baru",
    "TZS" to "Syiling Tanzania",
    "UAH" to "Hryvnia Ukraine",
    "UGS" to "Shilling Uganda (1966–1987)",
    "UGX" to "Syiling Uganda",
    "USD" to "Dolar AS",
    "UYU" to "Peso Uruguay",
    "UZS" to "Som Uzbekistan",
    "VEF" to "Bolivar Venezuela (2008–2018)",
    "VES" to "Bolivar Venezuela",
    "VND" to "Dong Vietnam",
    "VUV" to "Vatu Vanuatu",
    "WST" to "Tala Samoa",
    "XAF" to "Franc CFA BEAC",
    "XCD" to "Dolar Caribbean Timur",
    "XOF" to "Franc CFA BCEAO",
    "XPF" to "Franc CFP",
    "XXX" to "Mata Wang Tidak Diketahui",
    "YER" to "Rial Yaman",
    "ZAR" to "Rand Afrika Selatan",
    "ZMK" to "Kwacha Zambia (1968–2012)",
    "ZMW" to "Kwacha Zambia",
    "ZWD" to "Dolar Zimbabwe (1980–2008)",
    "ZWL" to "Dolar Zimbabwe (2009)",
    "ZWR" to "Dolar Zimbabwe (2008)",
  ) }

  val ms_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ms_Arab_BN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ms_BN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ms_ID: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ms_SG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val mt: ImmutableMap<String, String> by lazy { immutableMapOf(
    "EUR" to "ewro",
    "MTL" to "Lira Maltija",
    "XXX" to "Munita Mhix Magħrufa jew Mhix Valida",
  ) }

  val mua: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Solai Arabiya",
    "AOA" to "solai Angola",
    "AUD" to "solai Australya",
    "BHD" to "solai Barenya",
    "BIF" to "solai Burundi",
    "BWP" to "solai Botswana",
    "CAD" to "solai Kanada",
    "CDF" to "solai Kongo",
    "CHF" to "Solai Swiss",
    "CNY" to "solai Syiŋ",
    "CVE" to "solai Kapverdiya",
    "DJF" to "solai Djibouti",
    "DZD" to "solai Algerya",
    "EGP" to "solai Egypt",
    "ERN" to "solai Eritre",
    "ETB" to "solai Etiopia",
    "EUR" to "solai Euro",
    "GBP" to "solai Britaniya",
    "GHC" to "solai Gana",
    "GMD" to "solai Gambiya",
    "GNS" to "solai Guine",
    "INR" to "solai India",
    "JPY" to "solai Japoŋ",
    "KES" to "solai Kenia",
    "KMF" to "solai Komorya",
    "LRD" to "solai Liberiya",
    "LSL" to "solai Lesotho",
    "LYD" to "solai Libya",
    "MAD" to "Solai Marok",
    "MGA" to "Solai Malagasya",
    "MRO" to "Solai Mauritaniya (1973–2017)",
    "MRU" to "Solai Mauritaniya",
    "MUR" to "Solai Mauricǝ",
    "MWK" to "Solai Malawi",
    "MZM" to "Solai Mozambika",
    "NAD" to "Solai Namibiya",
    "NGN" to "Solai Nigeriya",
    "RWF" to "Solai Rwanda",
    "SAR" to "Solai Saudiya",
    "SCR" to "Solai Saichel",
    "SDG" to "Solai Sudaŋ ma dii ne dinar",
    "SDP" to "Solai Sudaŋ ma dii ne livre",
    "SHP" to "Solai Helena",
    "SLE" to "solai Sierra leonǝ",
    "SLL" to "solai Sierra leonǝ (1964—2022)",
    "SOS" to "Solai Somaliya",
    "STD" to "Solai Sao Tome (1977–2017)",
    "STN" to "Solai Sao Tome",
    "SZL" to "solai Swaziland",
    "TND" to "Solai Tunisiya",
    "TZS" to "Solai Tanzaniya",
    "UGX" to "Solai Uganda",
    "USD" to "Solai Amerika",
    "XAF" to "solai BEAC",
    "XOF" to "solai BCEAO",
    "ZAR" to "Solai Africa nekǝsǝŋ",
    "ZMK" to "Solai Zambiya (1968–2012)",
    "ZMW" to "Solai Zambiya",
    "ZWD" to "Solai Zimbabwe",
  ) }

  val mus: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val my: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "အာရပ်စော်ဘွားများ ပြည်ထောင်စု ဒါဟမ်း",
    "AFN" to "အာဖဂန် အာဖဂါနီ",
    "ALL" to "အယ်ဘေးနီးယား လီခ်",
    "AMD" to "အာမေးနီးယား ဒရမ်",
    "ANG" to "နယ်သာလန် အန်တီလန် ဂင်းဒါး",
    "AOA" to "အန်ဂိုလာ ကွမ်ဇာ",
    "ARP" to "အာဂျင်တီးနား ပီဆို (၁၉၈၃–၁၉၈၅)",
    "ARS" to "အာဂျင်တီးနား ပီဆို",
    "AUD" to "ဩစတြေးလျ ဒေါ်လာ",
    "AWG" to "အရူးဗာ ဖလိုရင်း",
    "AZN" to "အဇာဘိုင်ဂျန် မာနတ်",
    "BAM" to "ဘော့စနီးယားနှင့် ဟာဇီဂိုဘီးနား ငွေလဲနိုင်သော မတ်က်",
    "BBD" to "ဘာဘေးဒိုးစ် ဒေါ်လာ",
    "BDT" to "ဘင်္ဂလားဒေ့ရှ် တာကာ",
    "BEF" to "ဘယ်လ်ဂျီယမ် ဖရန့်",
    "BGN" to "ဘူလ်ဂေးရီးယား လက်ဖ်",
    "BHD" to "ဘာရိန်း ဒီနား",
    "BIF" to "ဘူရွန်ဒီ ဖရန့်",
    "BMD" to "ဘာမြူဒါ ဒေါ်လာ",
    "BND" to "ဘရူနိုင်း ဒေါ်လာ",
    "BOB" to "ဘိုလီးဗီးယား ဘိုလီးဗီယားနို",
    "BOP" to "ဘိုလီးဘီးယား ပီဆို",
    "BRL" to "ဘရာဇီး ရီးယဲ",
    "BSD" to "ဘဟားမား ဒေါ်လာ",
    "BTN" to "ဘူတန် အံဂါလ်ထရန်",
    "BUK" to "ဗမာ ကျပ်",
    "BWP" to "ဘော့ဆွာနာ ပုလ",
    "BYB" to "ဘီလာရုစ် ရူဘယ်အသစ် (၁၉၉၄–၁၉၉၉)",
    "BYN" to "ဘီလာရုစ် ရူဘယ်",
    "BYR" to "ဘီလာရုဇ် ရူဘယ် (၂၀၀၀–၂၀၁၆)",
    "BZD" to "ဘလိဇ် ဒေါ်လာ",
    "CAD" to "ကနေဒါ ဒေါ်လာ",
    "CDF" to "ကွန်ဂို ဖရန့်",
    "CHF" to "ဆွစ် ဖရန့်",
    "CLP" to "ချီလီ ပီဆို",
    "CNH" to "တရုတ် ယွမ် (ဟောင်ကောင်)",
    "CNY" to "တရုတ် ယွမ်",
    "COP" to "ကိုလံဘီယာ ပီဆို",
    "CRC" to "ကို့စတာရီကာ ကိုလွန်",
    "CUC" to "နိုင်ငံခြားငွေလဲလှယ်နိုင်သော ကျူးဘားပီဆို",
    "CUP" to "ကျူးဘား ပီဆို",
    "CVE" to "ကိတ်ပ်ဗာဒီ အက်စ်ခူဒို",
    "CYP" to "ဆိုက်ပရက်စ် ပေါင်",
    "CZK" to "ချက် ခိုရိုနာ",
    "DEM" to "ဂျာမဏီ မတ်",
    "DJF" to "ဂျီဘူတီ ဖရန့်",
    "DKK" to "ဒိန်းမတ် ခရိုဏာ",
    "DOP" to "ဒိုမီနီကန် ပီဆို",
    "DZD" to "အယ်လ်ဂျီးရီးယား ဒီနာ",
    "EGP" to "အီဂျစ် ပေါင်",
    "ERN" to "အီရီထရီးယား နာ့ခ်ဖာ",
    "ESP" to "စပိန် ပယ်စေးတာ",
    "ETB" to "အီသီယိုးပီးယား ဘီးယာ",
    "EUR" to "ယူရို",
    "FJD" to "ဖီဂျီ ဒေါ်လာ",
    "FKP" to "ဖော့ကလန်ကျွန်းစု ပေါင်",
    "FRF" to "ပြင်သစ် ဖရန့်",
    "GBP" to "ဗြိတိသျှ ပေါင်",
    "GEL" to "ဂျော်ဂျီယာ လားရီ",
    "GHS" to "ဂါနာ ဆဲဒီ",
    "GIP" to "ဂျီဘရော်လ်တာ ပေါင်",
    "GMD" to "ဂမ်ဘီယာ ဒါလာစီ",
    "GNF" to "ဂီနီရာ ဖရန့်",
    "GTQ" to "ဂွါတီမာလာ ခက်ဇော်လ်",
    "GYD" to "ဂိုင်ယာနာ ဒေါ်လာ",
    "HKD" to "ဟောင်ကောင် ဒေါ်လာ",
    "HNL" to "ဟွန်ဒူးရပ်စ် လမ်းပီရာ",
    "HRK" to "ခရိုအေးရှား ခူးနာ",
    "HTG" to "ဟေတီဂူးအော်ဒ်",
    "HUF" to "ဟန်ဂေရီယံ ဖော်ရင့်တ်",
    "IDR" to "အင်ဒိုနီးရှား ရူပီးယား",
    "ILP" to "အစ္စရေး ပေါင်",
    "ILS" to "အစ္စရေး ရှဲကလ်အသစ်",
    "INR" to "အိန္ဒိယ ရူပီး",
    "IQD" to "အီရတ် ဒီနာ",
    "IRR" to "အီရန် ရီအော်လ်",
    "ISK" to "အိုက်စလန် ခရိုဏာ",
    "JMD" to "ဂျမေကာ ဒေါ်လာ",
    "JOD" to "ဂျော်ဒန် ဒီနာ",
    "JPY" to "ဂျပန် ယန်း",
    "KES" to "ကင်ညာ သျှီလင်",
    "KGS" to "ကာဂျစ္စတန် ဆော်မ်",
    "KHR" to "ကမ္ဘောဒီးယား ရီးယဲ",
    "KMF" to "ကိုမိုရိုစ် ဖရန့်",
    "KPW" to "မြောက်ကိုရီးယား ဝမ်",
    "KRW" to "တောင်ကိုရီးယား ဝမ်",
    "KWD" to "ကူဝိတ် ဒီနာ",
    "KYD" to "ကေမန် ကျွန်းစု ဒေါ်လာ",
    "KZT" to "ကာဇက်စတန် ထိန်ဂျီ",
    "LAK" to "လာအို ကစ်",
    "LBP" to "လက်ဘနွန် ပေါင်",
    "LKR" to "သီရိလင်္ကာ ရူပီး",
    "LRD" to "လိုက်ဘေးရီးယား ဒေါ်လာ",
    "LSL" to "လီဆိုသို လိုတီ",
    "LTL" to "လစ်သူယေးနီးယားလီတားစ်",
    "LVL" to "လတ်ဗီးယားလတ်",
    "LYD" to "လစ်ဗျား ဒိုင်နာ",
    "MAD" to "မိုရိုကို ဒရမ်",
    "MDL" to "မောလ်ဒိုဗာ လယ်အို",
    "MGA" to "မာလာဂါစီ အရီရရီ",
    "MKD" to "မက်ဆီဒိုးနီးယား ဒီနာ",
    "MMK" to "မြန်မာ ကျပ်",
    "MNT" to "မွန်ဂိုးလီးယား ထူးဂရခ်",
    "MOP" to "မကာအို ပါတားကား",
    "MRO" to "မော်ရီတေးနီးယား အူဂီးယာ (၁၉၇၃–၂၀၁၇)",
    "MRU" to "မော်ရီတေးနီးယန်း အူဂီးယာ",
    "MUR" to "မောရစ်ရှ ရူပီး",
    "MVR" to "မော်လ်ဒိုက် ရူးဖီရာ",
    "MWK" to "မာလာဝီ ခွါးချာ",
    "MXN" to "မက်ကဆီကို ပီဆို",
    "MYR" to "မလေးရှား ရင်းဂစ်",
    "MZN" to "မိုဇမ်ဘစ် မက်တီခယ်လ်",
    "NAD" to "နမီးဘီးယား ဒေါ်လာ",
    "NGN" to "နိုင်ဂျီးရီးယား နိုင်းရာ",
    "NIO" to "နီကာရာဂွါ ခိုးဒိုဘာ",
    "NOK" to "နော်ဝေ ခရိုဏာ",
    "NPR" to "နီပေါ ရူပီး",
    "NZD" to "နယူးဇီလန် ဒေါ်လာ",
    "OMR" to "အိုမန်နီ ရီရယ်",
    "PAB" to "ပနားမား ဘလျဘိုးအာ",
    "PEN" to "ပီရူး ဆိုးလ်",
    "PGK" to "ပါပူအာ နယူးဂီနီ ခီးနာ",
    "PHP" to "ဖိလစ်ပိုင် ပီဆို",
    "PKR" to "ပါကစ္စတန် ရူပီး",
    "PLN" to "ပိုလန် ဇလော့တီ",
    "PYG" to "ပါရာဂွေး ဂွါးအ်နီး",
    "QAR" to "ကာတာရီ ရီရယ်",
    "RON" to "ရိုမေးနီးယား လယ်အို",
    "RSD" to "ဆားဘီးယား ဒယ်နား",
    "RUB" to "ရုရှ ရူဘယ်",
    "RUR" to "ရုရှ ရူဘယ် (၁၉၉၁–၁၉၉၈)",
    "RWF" to "ရဝန်ဒါ ဖရန့်",
    "SAR" to "ဆော်ဒီအာရေးဗီးယား ရီယော်လ်",
    "SBD" to "ဆော်လမွန်ကျွန်းစု ဒေါ်လာ",
    "SCR" to "ဆေးရှဲ ရူပီး",
    "SDG" to "ဆူဒန် ပေါင်",
    "SDP" to "ဆူဒန် ပေါင်အဟောင်း",
    "SEK" to "ဆွီဒင် ခရိုဏာ",
    "SGD" to "စင်္ကာပူ ဒေါ်လာ",
    "SHP" to "စိန့်ဟယ်လယ်နာ ပေါင်",
    "SLE" to "ဆီယာရာလီယွန်း လီအိုနီ",
    "SLL" to "ဆီယာရာလီယွန်း လီအိုနီ (၁၉၆၄—၂၀၂၂)",
    "SOS" to "ဆိုမာလီ သျှီလင်",
    "SRD" to "ဆူရီနမ်း ဒေါ်လာ",
    "SSP" to "တောင်ဆူဒန် ပေါင်",
    "STD" to "ဆောင်တူမေးနှင့် ပရင်စီပီ ဒိုဘရာ",
    "STN" to "ဆောင်တူမေးနှင့် ပရင်စီပီ ဒိုဘရာ (၂၀၁၈)",
    "SUR" to "ဆိုဗီယက် ရူဗယ်",
    "SYP" to "ဆီးရီးယား ပေါင်",
    "SZL" to "ဆွာဇီလန် လီလန်းဂီနီ",
    "THB" to "ထိုင်း ဘတ်",
    "TJS" to "တာဂျစ်ကစ္စတန် ဆိုမိုနီ",
    "TMT" to "တာ့ခ်မင်နစ္စတန် မာနတ်",
    "TND" to "တူနီးရှား ဒိုင်နာ",
    "TOP" to "တွန်ဂါ ဗန်ဂါ",
    "TRL" to "ရှေးဟောင်းတူရကီ လိုင်ရာ",
    "TRY" to "တူရကီ လိုင်ရာ",
    "TTD" to "ထရီနီဒတ်နှင့် တိုဘက်ဂို ဒေါ်လာ",
    "TWD" to "ထိုင်ဝမ် ဒေါ်လာအသစ်",
    "TZS" to "တန်ဇန်းနီးယား သျှီလင်",
    "UAH" to "ယူကရိန်း ဟီရီဗင်းညား",
    "UGX" to "ယူဂန္ဒာ သျှီလင်",
    "USD" to "အမေရိကန် ဒေါ်လာ",
    "USN" to "အမေရိကန် ဒေါ်လာ (နောက်နေ့)",
    "USS" to "အမေရိကန် ဒေါ်လာ (တနေ့တည်း)",
    "UYU" to "ဥရုဂွေး ပီဆို",
    "UZS" to "ဥဇဘက်ကစ္စတန် ဆော်မ်",
    "VEF" to "ဗင်နီဇွဲလား ဘိုလီဗာ (၂၀၀၈–၂၀၁၈)",
    "VES" to "ဗင်နီဇွဲလန်း ဘိုလီဗာ",
    "VND" to "ဗီယက်နမ် ဒေါင်",
    "VUV" to "ဗနွားတူ ဗားထူ",
    "WST" to "ဆမိုအား ထားလာ",
    "XAF" to "ကင်မရွန်း ဖရန့်",
    "XAG" to "ငွေ",
    "XAU" to "ရွှေ",
    "XBB" to "ဥရောပငွေကြေးစံနစ်",
    "XCD" to "အရှေ့ကာရစ်ဘီယံ ဒေါ်လာ",
    "XDR" to "အထူးထုတ်ယူခွင့်",
    "XOF" to "အနောက် အာဖရိက [CFA ]ဖရန့်",
    "XPF" to "[CFP] ဖရန့်",
    "XPT" to "ပလက်တီနမ်",
    "XTS" to "စမ်းသပ် ငွေကြေး ကုဒ်",
    "XXX" to "မသိသို့မဟုတ်မရှိသောငွေကြေး",
    "YER" to "ယီမင်နီ ရီရယ်",
    "ZAR" to "တောင်အာဖရိက ရန်း",
    "ZMW" to "ဇင်ဘာဘွေ ခွါးချာ",
    "ZWD" to "ဇင်ဘာဘွေ ဒေါ်လာ",
  ) }

  val myv: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val mzn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "متحده عربی امارات ِدرهم",
    "AFN" to "افغانستون ِافغانی",
    "ALL" to "آلبانی ِلک",
    "AMD" to "ارمنستون درهم",
    "ANG" to "هلند ِآنتیل ِجزایر ِگویلدر",
    "AOA" to "آنگولای ِکوانزا",
    "ARS" to "آرژانتین ِپزو",
    "AWG" to "آروبای ِفلورن",
    "AZN" to "آذربایجون ِمنات",
    "BAM" to "بوسنی و هرزگوین ِتبدیل‌بَیی مارک",
    "BBD" to "باربادوس ِدولار",
    "BDT" to "بنگلادش ِتاکا",
    "BGN" to "بلغارستون ِلیوا",
    "BHD" to "بحرین ِدینار",
    "BIF" to "بوروندی ِفرانک",
    "BMD" to "برمودای ِدولار",
    "BND" to "برونئی ِدولار",
    "BOB" to "بولیوی ِبولیویانو",
    "BRL" to "برزیل ِرئال",
    "BSD" to "باهامای ِدولار",
    "BTN" to "بوتان ِنگولتروم",
    "BWP" to "بوتساوانای ِپولا",
    "BYN" to "بلاروس ِروبل",
    "BYR" to "بلاروس ِروبل (۲۰۰۰–۲۰۱۶)",
    "BZD" to "بلیز ِدولار",
    "CAD" to "کانادای ِدولار",
    "CDF" to "کنگوی ِفرانک",
    "CHF" to "سوییس ِفرانک",
    "CLP" to "شیلی ِپزو",
    "CNY" to "چین ِیوآن",
    "COP" to "کلمبیای ِپزو",
    "CRC" to "کاستاریکای ِکولون",
    "CUC" to "کوبای ِتبدیل‌بَیی پزو",
    "CUP" to "کوبای ِپزو",
    "CVE" to "عاج ِساحل ِایسکودو",
    "CZK" to "چک ِکرون",
    "DJF" to "جیبوتی ِفرانک",
    "DKK" to "دانمارک ِکورن",
    "DOP" to "دومینیکن ِپزو",
    "DZD" to "الجزیره‌ی ِدینار",
    "EGP" to "مصر ِپوند",
    "ERN" to "اریتره‌ی ِناکفا",
    "ETB" to "اتیوپی ِبیر",
    "EUR" to "یورو",
    "FKP" to "فالکلند ِجزایر ِپوند",
    "GBP" to "بریتانیای ِپوند",
    "GEL" to "گرجستون ِلاری",
    "GHS" to "غنای ِسدی",
    "GIP" to "جبل‌طارق ِپوند",
    "GMD" to "گامبیای ِدالاسی",
    "GNF" to "گینه‌ی ِفرانک",
    "GTQ" to "گواتمالا کتزال",
    "GYD" to "گویان ِدولار",
    "HKD" to "هونگ کونگ ِدولار",
    "HNL" to "هندوراس ِلمپیرا",
    "HRK" to "کرواسی ِکونا",
    "HTG" to "هائیتی ِگورد",
    "HUF" to "مجارستون ِفروینت",
    "IDR" to "اندونزی ِروپیه",
    "ILS" to "اسراییل ِنو شِکِل",
    "INR" to "هند ِروپیه",
    "IQD" to "عراق ِدینار",
    "IRR" to "ایران ریال",
    "ISK" to "ایسلند کرونا",
    "JMD" to "جاماییکای ِدولار",
    "JOD" to "اردن ِدینار",
    "JPY" to "جاپون ِین",
    "KES" to "کنیای ِشیلینگ",
    "KGS" to "قرقیزستون ِسام",
    "KHR" to "کامبوج ِریل",
    "KMF" to "کامرون ِفرانک",
    "KPW" to "شمالی کره‌ی ِوون",
    "KRW" to "جنوبی کُره‌ی ِوون",
    "KWD" to "کویت ِدینار",
    "KYD" to "کایمن جزیره‌ی ِدولار",
    "KZT" to "قراقستون ِتنگ",
    "LAK" to "لائوس ِکیپ",
    "LBP" to "لبنان ِپوند",
    "LKR" to "سریلانکا روپیه",
    "LRD" to "لیبریای ِدولار",
    "LYD" to "لیبی ِدینار",
    "MAD" to "مراکش ِدرهم",
    "MDL" to "مولداوی ِلئو",
    "MGA" to "ماداگاسکار ِآریاری",
    "MKD" to "مقدونیه‌ی ِدینار",
    "MMK" to "میانمار ِکیات",
    "MNT" to "مغلستون ِتوگریک",
    "MOP" to "ماکائو ِپاتاجا",
    "MRO" to "موریتانی ِاوگوئیا (1973–2017)",
    "MRU" to "موریتانی ِاوگوئیا",
    "MUR" to "موریتیان ِروپیه",
    "MVR" to "مالدیو ِروفیا",
    "MWK" to "مالاوی ِکواچا",
    "MXN" to "مکزیک ِپزو",
    "MYR" to "مالزی ِرینگیت",
    "MZN" to "موزامبیک متیکال",
    "NAD" to "نامبیای ِدولار",
    "NGN" to "نیجریه‌ی ِنیارا",
    "NIO" to "نیکاراگوئه‌ی ِکوردوبا",
    "NOK" to "نروژ ِکرون",
    "NPR" to "نپال ِروپیه",
    "OMR" to "عمان ِریال",
    "PAB" to "پانامای ِبالبوا",
    "PEN" to "پروی ِسول",
    "PHP" to "فیلیپین ِپزو",
    "PKR" to "پاکستون روپیه",
    "PLN" to "لهستون ِزلوتی",
    "PYG" to "پاراگوئه‌ی ِگوارانی",
    "QAR" to "قطر ِریال",
    "RON" to "رومانی ِلئو",
    "RSD" to "صربستون ِدینار",
    "RUB" to "روسیه‌ی ِروبل",
    "RWF" to "روآندای ِفرانک",
    "SAR" to "عربستون ِریال",
    "SCR" to "سیشل ِروپیه",
    "SDG" to "سودان ِپوند",
    "SEK" to "سوئد ِکرون",
    "SGD" to "سنگاپور ِدلار",
    "SHP" to "سنت هلنای ِپوند",
    "SLE" to "سیرالئون ِلئون",
    "SLL" to "سیرالئون ِلئون - 1964-2022",
    "SOS" to "سومالی ِشیلینگ",
    "SRD" to "سورینام ِدولار",
    "SSP" to "جنوبی سودان ِپوند",
    "STD" to "سائوتومه و پرینسیپ ِدوبرا (1977–2017)",
    "STN" to "سائوتومه و پرینسیپ ِدوبرا",
    "SYP" to "سوریه‌ی ِپوند",
    "SZL" to "سوازیلند ِلیلانجنی",
    "THB" to "تایلند ِبات",
    "TJS" to "تاجیکستون ِسامانی",
    "TMT" to "ترکمنستون ِمنات",
    "TND" to "تونس ِدینار",
    "TRY" to "ترکیه‌ی ِلیره",
    "TTD" to "ترینیداد و توباگوی ِدولار",
    "TWD" to "جدید ِتایوان ِدولار",
    "TZS" to "تانزانیای ِشیلینگ",
    "UAH" to "اکراین ِگریونا",
    "UGX" to "اوگاندای ِشیلینگ",
    "USD" to "آمریکای ِدولار",
    "UYU" to "اروگوئه‌ی ِپزو",
    "UZS" to "ازبکستون ِسام",
    "VEF" to "ونزوئلایِ بولیوار (2008–2018)",
    "VES" to "ونزوئلایِ بولیوار",
    "VND" to "ویتنام ِدنگ",
    "XAF" to "میونی آفریقای ِسی‌اف‌ای فرانک",
    "XCD" to "شرقی کاراییب ِدولار",
    "XOF" to "غربی آفریقای ِسی‌اف‌ای فرانک",
    "YER" to "یمن ِریال",
    "ZAR" to "جنوبی آفریقای ِراند",
    "ZMW" to "زامبیای ِکواچا",
  ) }

  val naq: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "United Arab Emirates Dirham",
    "AOA" to "Angolan Kwanzab",
    "AUD" to "Australian Dollari",
    "BHD" to "Bahrain Dinar",
    "BIF" to "Burundi Franc",
    "BWP" to "Botswanan Pulab",
    "CAD" to "Canadian Dollari",
    "CDF" to "Congolese Franc",
    "CHF" to "Swiss Franci",
    "CNY" to "Chinese Yuan Renminbi",
    "CVE" to "Escudo Caboverdiano",
    "DJF" to "Djibouti Franc",
    "DZD" to "Algerian Dinar",
    "EGP" to "Egytian Ponds",
    "ERN" to "Eritreian Nakfa",
    "ETB" to "Ethiopian Birr",
    "EUR" to "Eurob",
    "GBP" to "British Ponds",
    "GHC" to "Ghana Cedi",
    "GMD" to "Gambia Dalasi",
    "GNS" to "Guinea Franc",
    "INR" to "Indian Rupee",
    "JPY" to "Japanese Yenni",
    "KES" to "Kenyan Shilling",
    "KMF" to "Comorian Franc",
    "LRD" to "Liberian Dollar",
    "LSL" to "Lesotho Loti",
    "LYD" to "Libyan Dinar",
    "MAD" to "Moroccan Dirham",
    "MGA" to "Malagasy Franc",
    "MRO" to "Mauritania Ouguiya (1973–2017)",
    "MRU" to "Mauritania Ouguiya",
    "MUR" to "Mauritius Rupeeb",
    "MWK" to "Malawian Kwachab",
    "MZM" to "Mozambique Metical",
    "NAD" to "Namibia Dollari",
    "NGN" to "Nigerian Naira",
    "RWF" to "Rwanda Franci",
    "SAR" to "Saudi Riyal",
    "SCR" to "Seychelles Rupee",
    "SDG" to "Sudanese Dinar",
    "SDP" to "Sudanese Ponds",
    "SHP" to "St Helena Ponds",
    "SLE" to "Leone",
    "SLL" to "Leone (1964—2022)",
    "SOS" to "Somali Shillings",
    "STD" to "Sao Tome and Principe Dobra (1977–2017)",
    "STN" to "Sao Tome and Principe Dobra",
    "SZL" to "Lilangeni",
    "TND" to "Tunisian Dinar",
    "TZS" to "Tanzanian Shillings",
    "UGX" to "Ugandan Shillings",
    "USD" to "US Dollari",
    "XAF" to "CFA Franc BEAC",
    "XOF" to "CFA Franc BCEAO",
    "ZAR" to "South African Randi",
    "ZMK" to "Zambian Kwachab (1968–2012)",
    "ZMW" to "Zambian Kwachab",
    "ZWD" to "Zimbabwe Dollari",
  ) }

  val nb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "andorranske pesetas",
    "AED" to "emiratarabiske dirham",
    "AFA" to "afgansk afghani (1927–2002)",
    "AFN" to "afghanske afghani",
    "ALK" to "albanske lek (1946–1965)",
    "ALL" to "albanske lek",
    "AMD" to "armenske dram",
    "ANG" to "nederlandske antillegylden",
    "AOA" to "angolanske kwanza",
    "AOK" to "angolanske kwanza (1977–1990)",
    "AON" to "angolanske nye kwanza (1990–2000)",
    "AOR" to "angolanske omjusterte kwanza (1995–1999)",
    "ARA" to "argentinske australer",
    "ARL" to "argentinske peso ley",
    "ARM" to "argentinsk pesos (1881–1970)",
    "ARP" to "argentinske pesos (1983–1985)",
    "ARS" to "argentinske pesos",
    "ATS" to "østerrikske shilling",
    "AUD" to "australske dollar",
    "AWG" to "arubiske floriner",
    "AZM" to "aserbajdsjanske manat (1993–2006)",
    "AZN" to "aserbajdsjanske manat",
    "BAD" to "bosnisk-hercegovinske dinarer (1992–1994)",
    "BAM" to "bosnisk-hercegovinske konvertible mark",
    "BAN" to "nye bosnisk-hercegovinske dinarer (1994–1997)",
    "BBD" to "barbadiske dollar",
    "BDT" to "bangladeshiske taka",
    "BEC" to "belgiske franc (konvertible)",
    "BEF" to "belgiske franc",
    "BEL" to "belgiske franc (finansielle)",
    "BGL" to "bulgarske lev (hard)",
    "BGM" to "bulgarske lev (sosialist)",
    "BGN" to "bulgarske lev",
    "BGO" to "bulgarske lev (1879–1952)",
    "BHD" to "bahrainske dinarer",
    "BIF" to "burundiske franc",
    "BMD" to "bermudiske dollar",
    "BND" to "bruneiske dollar",
    "BOB" to "bolivianske boliviano",
    "BOL" to "bolivianske boliviano (1863–1963)",
    "BOP" to "bolivianske pesos",
    "BOV" to "bolivianske mvdol",
    "BRB" to "brasilianske cruzeiro novo (1967–1986)",
    "BRC" to "brasilianske cruzados (1986–1989)",
    "BRE" to "brasilianske cruzeiro (1990–1993)",
    "BRL" to "brasilianske real",
    "BRN" to "brasilianske cruzado novo (1989–1990)",
    "BRR" to "brasilianske cruzeiro (1993–1994)",
    "BRZ" to "brasilianske cruzeiro (1942–1967)",
    "BSD" to "bahamanske dollar",
    "BTN" to "bhutanske ngultrum",
    "BUK" to "burmesiske kyat",
    "BWP" to "botswanske pula",
    "BYB" to "hviterussiske nye rubler (1994–1999)",
    "BYN" to "nye belarusiske rubler",
    "BYR" to "hviterussiske rubler (2000–2016)",
    "BZD" to "beliziske dollar",
    "CAD" to "kanadiske dollar",
    "CDF" to "kongolesiske franc",
    "CHE" to "WIR euro",
    "CHF" to "sveitsiske franc",
    "CHW" to "WIR franc",
    "CLE" to "chilenske escudo",
    "CLF" to "chilenske unidades de fomento",
    "CLP" to "chilenske pesos",
    "CNH" to "kinesiske yuan (offshore)",
    "CNX" to "Kinas folkebank dollar",
    "CNY" to "kinesiske yuan",
    "COP" to "colombianske pesos",
    "COU" to "colombianske unidad de valor real",
    "CRC" to "costaricanske colón",
    "CSD" to "serbiske dinarer (2002–2006)",
    "CSK" to "tsjekkoslovakiske koruna (hard)",
    "CUC" to "kubanske konvertible pesos",
    "CUP" to "kubanske pesos",
    "CVE" to "kappverdiske escudos",
    "CYP" to "kypriotiske pund",
    "CZK" to "tsjekkiske koruna",
    "DDM" to "østtyske mark",
    "DEM" to "tyske mark",
    "DJF" to "djiboutiske franc",
    "DKK" to "danske kroner",
    "DOP" to "dominikanske pesos",
    "DZD" to "algeriske dinarer",
    "ECS" to "ecuadorianske sucre",
    "ECV" to "ecuadorianske unidad de valor constante (UVC)",
    "EEK" to "estiske kroon",
    "EGP" to "egyptiske pund",
    "ERN" to "eritreiske nakfa",
    "ESA" to "spanske peseta (A–konto)",
    "ESB" to "spanske peseta (konvertibel konto)",
    "ESP" to "spanske peseta",
    "ETB" to "etiopiske birr",
    "EUR" to "euro",
    "FIM" to "finske mark",
    "FJD" to "fijianske dollar",
    "FKP" to "falklandspund",
    "FRF" to "franske franc",
    "GBP" to "britiske pund",
    "GEK" to "georgiske kupon larit",
    "GEL" to "georgiske lari",
    "GHC" to "ghanesisk cedi (1979–2007)",
    "GHS" to "ghanesiske cedi",
    "GIP" to "gibraltarske pund",
    "GMD" to "gambiske dalasi",
    "GNF" to "guineanske franc",
    "GNS" to "guineanske syli",
    "GQE" to "ekvatorialguineanske ekwele guineana",
    "GRD" to "greske drakmer",
    "GTQ" to "guatemalanske quetzal",
    "GWE" to "portugisiske guinea escudo",
    "GWP" to "Guinea-Bissau-pesos",
    "GYD" to "guyanske dollar",
    "HKD" to "Hongkong-dollar",
    "HNL" to "honduranske lempira",
    "HRD" to "kroatiske dinarer",
    "HRK" to "kroatiske kuna",
    "HTG" to "haitiske gourde",
    "HUF" to "ungarske forinter",
    "IDR" to "indonesiske rupier",
    "IEP" to "irske pund",
    "ILP" to "israelske pund",
    "ILR" to "israelske shekler (1980–1985)",
    "ILS" to "nye israelske shekler",
    "INR" to "indiske rupier",
    "IQD" to "irakske dinarer",
    "IRR" to "iranske rialer",
    "ISJ" to "islandske kroner (1918–1981)",
    "ISK" to "islandske kroner",
    "ITL" to "italienske lire",
    "JMD" to "jamaikanske dollar",
    "JOD" to "jordanske dinarer",
    "JPY" to "japanske yen",
    "KES" to "kenyanske shilling",
    "KGS" to "kirgisiske som",
    "KHR" to "kambodsjanske riel",
    "KMF" to "komoriske franc",
    "KPW" to "nordkoreanske won",
    "KRH" to "sørkoreanske hwan (1953–1962)",
    "KRO" to "sørkoreanske won (1945–1953)",
    "KRW" to "sørkoreanske won",
    "KWD" to "kuwaitiske dinarer",
    "KYD" to "caymanske dollar",
    "KZT" to "kasakhstanske tenge",
    "LAK" to "laotiske kip",
    "LBP" to "libanesiske pund",
    "LKR" to "srilankiske rupier",
    "LRD" to "liberiske dollar",
    "LSL" to "lesothiske loti",
    "LTL" to "litauiske litas",
    "LTT" to "litauiske talonas",
    "LUC" to "luxemburgske konvertible franc",
    "LUF" to "luxemburgske franc",
    "LUL" to "luxemburgske finansielle franc",
    "LVL" to "latviske lats",
    "LVR" to "latviske rubler",
    "LYD" to "libyske dinarer",
    "MAD" to "marokkanske dirham",
    "MAF" to "marokkanske franc",
    "MCF" to "monegaskiske franc",
    "MDC" to "moldovske cupon",
    "MDL" to "moldovske leu",
    "MGA" to "madagassiske ariary",
    "MGF" to "madagassiske franc",
    "MKD" to "makedonske denarer",
    "MKN" to "makedonske denarer (1992–1993)",
    "MLF" to "maliske franc",
    "MMK" to "myanmarske kyat",
    "MNT" to "mongolske tugrik",
    "MOP" to "makaoiske pataca",
    "MRO" to "mauritanske ouguiya (1973–2017)",
    "MRU" to "mauritanske ouguiya",
    "MTL" to "maltesiske lira",
    "MTP" to "maltesiske pund",
    "MUR" to "mauritiske rupier",
    "MVP" to "maldiviske rupier",
    "MVR" to "maldiviske rufiyaa",
    "MWK" to "malawiske kwacha",
    "MXN" to "meksikanske pesos",
    "MXP" to "meksikanske sølvpesos (1861–1992)",
    "MXV" to "meksikanske unidad de inversion (UDI)",
    "MYR" to "malaysiske ringgit",
    "MZE" to "mosambikiske escudo",
    "MZM" to "gamle mosambikiske metical",
    "MZN" to "mosambikiske metical",
    "NAD" to "namibiske dollar",
    "NGN" to "nigerianske naira",
    "NIC" to "nicaraguanske cordoba (1988–1991)",
    "NIO" to "nicaraguanske córdoba",
    "NLG" to "nederlandske gylden",
    "NOK" to "norske kroner",
    "NPR" to "nepalske rupier",
    "NZD" to "newzealandske dollar",
    "OMR" to "omanske rialer",
    "PAB" to "panamanske balboa",
    "PEI" to "peruanske inti",
    "PEN" to "peruanske sol",
    "PES" to "peruanske sol (1863–1965)",
    "PGK" to "papuanske kina",
    "PHP" to "filippinske pesos",
    "PKR" to "pakistanske rupier",
    "PLN" to "polske zloty",
    "PLZ" to "polske zloty (1950–1995)",
    "PTE" to "portugisiske escudo",
    "PYG" to "paraguayanske guarani",
    "QAR" to "qatarske rialer",
    "RHD" to "rhodesiske dollar",
    "ROL" to "rumenske leu (1952–2006)",
    "RON" to "rumenske leu",
    "RSD" to "serbiske dinarer",
    "RUB" to "russiske rubler",
    "RUR" to "russiske rubler (1991–1998)",
    "RWF" to "rwandiske franc",
    "SAR" to "saudiarabiske riyaler",
    "SBD" to "salomonske dollar",
    "SCR" to "seychelliske rupier",
    "SDD" to "sudanesiske dinarer (1992–2007)",
    "SDG" to "sudanske pund",
    "SDP" to "sudanesiske pund",
    "SEK" to "svenske kroner",
    "SGD" to "singaporske dollar",
    "SHP" to "sankthelenske pund",
    "SIT" to "slovenske tolar",
    "SKK" to "slovakiske koruna",
    "SLE" to "sierraleonsk leone",
    "SLL" to "sierraleonsk leone (1964–2022)",
    "SOS" to "somaliske shilling",
    "SRD" to "surinamske dollar",
    "SRG" to "surinamske gylden",
    "SSP" to "sørsudanske pund",
    "STD" to "saotomesiske dobra (1977–2017)",
    "STN" to "saotomesiske dobra",
    "SUR" to "sovjetiske rubler",
    "SVC" to "salvadoranske colon",
    "SYP" to "syriske pund",
    "SZL" to "swazilandske lilangeni",
    "THB" to "thailandske baht",
    "TJR" to "tadsjikiske rubler",
    "TJS" to "tadsjikiske somoni",
    "TMM" to "turkmenske manat (1993–2009)",
    "TMT" to "turkmenske manat",
    "TND" to "tunisiske dinarer",
    "TOP" to "tonganske paʻanga",
    "TPE" to "timoresiske escudo",
    "TRL" to "tyrkiske lire (1922–2005)",
    "TRY" to "tyrkiske lire",
    "TTD" to "trinidadiske dollar",
    "TWD" to "nye taiwanske dollar",
    "TZS" to "tanzanianske shilling",
    "UAH" to "ukrainske hryvnia",
    "UAK" to "ukrainske karbovanetz",
    "UGS" to "ugandiske shilling (1966–1987)",
    "UGX" to "ugandiske shilling",
    "USD" to "amerikanske dollar",
    "USN" to "amerikanske dollar (neste dag)",
    "USS" to "amerikanske dollar (samme dag)",
    "UYI" to "uruguyanske pesos (indekserte enheter)",
    "UYP" to "uruguayanske pesos (1975–1993)",
    "UYU" to "uruguayanske pesos",
    "UZS" to "usbekiske som",
    "VEB" to "venezuelanske bolivar (1871–2008)",
    "VEF" to "venezuelanske bolivar (2008–2018)",
    "VES" to "venezuelanske bolivar",
    "VND" to "vietnamesiske dong",
    "VNN" to "vietnamesiske dong (1978–1985)",
    "VUV" to "vanuatiske vatu",
    "WST" to "samoanske tala",
    "XAF" to "sentralafrikanske CFA-franc",
    "XAG" to "sølv",
    "XAU" to "gull",
    "XBA" to "europeisk sammensatt enhet",
    "XBB" to "europeisk monetær enhet",
    "XBC" to "europeisk kontoenhet (XBC)",
    "XBD" to "europeisk kontoenhet (XBD)",
    "XCD" to "østkaribiske dollar",
    "XDR" to "spesielle trekkrettigheter",
    "XEU" to "europeisk valutaenhet",
    "XFO" to "franske gullfranc",
    "XFU" to "franske UIC-franc",
    "XOF" to "vestafrikanske CFA-franc",
    "XPD" to "palladium",
    "XPF" to "CFP-franc",
    "XPT" to "platina",
    "XRE" to "RINET-fond",
    "XSU" to "sucre",
    "XTS" to "testvalutakode",
    "XUA" to "ADB-kontoenhet",
    "XXX" to "ukjent valuta",
    "YDD" to "jemenittiske dinarer",
    "YER" to "jemenittiske rialer",
    "YUD" to "jugoslaviske dinarer (hard)",
    "YUM" to "jugoslaviske noviy-dinarer",
    "YUN" to "jugoslaviske konvertible dinarer",
    "YUR" to "jugoslaviske reformerte dinarer (1992–1993)",
    "ZAL" to "sørafrikanske rand (finansielle)",
    "ZAR" to "sørafrikanske rand",
    "ZMK" to "zambiske kwacha (1968–2012)",
    "ZMW" to "zambiske kwacha",
    "ZRN" to "zairiske nye zaire",
    "ZRZ" to "zairiske zaire",
    "ZWD" to "zimbabwiske dollar (1980–2008)",
    "ZWL" to "zimbabwisk dollar (2009)",
    "ZWR" to "zimbabwisk dollar (2008)",
  ) }

  val nb_SJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nd: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dola laseArab",
    "AOA" to "Kwanza yase Angola",
    "AUD" to "Dola yase Australia",
    "BHD" to "Dinari yase Bhahareni",
    "BIF" to "Fulenki yase Bhurundi",
    "BWP" to "Phula yase Botswana",
    "CAD" to "Dola yase Khanada",
    "CDF" to "Fulenki yase Khongo",
    "CHF" to "Fulenki yase Swisi",
    "CNY" to "Yuan Renminbi yase China",
    "CVE" to "Escudo Caboverdiano",
    "DJF" to "Fulenki yase Jibhuthi",
    "DZD" to "Dinali yase Aljeriya",
    "EGP" to "Phawundi laseGibhide",
    "ERN" to "Nakfa yase Eritrea",
    "ETB" to "Dola laseEthiopia",
    "EUR" to "Yuro",
    "GBP" to "Phawundi yase Ngilandi",
    "GHC" to "Sedi yase Ghana",
    "GMD" to "Dalasi yase Gambia",
    "GNS" to "Fulenki yase Gine",
    "INR" to "Rupi yase Indiya",
    "JPY" to "Yeni yase Japhani",
    "KES" to "Shilingi yase Kenya",
    "KMF" to "Fulenki yase Khomoro",
    "LRD" to "Dola yase Libheriya",
    "LSL" to "Lothi yase Lesotho",
    "LYD" to "Dinari yase Libya",
    "MAD" to "Dirham yase Morokho",
    "MGA" to "Fulenki yase Malagasi",
    "MRO" to "Ugwiya yase Moritaniya (1973–2017)",
    "MRU" to "Ugwiya yase Moritaniya",
    "MUR" to "Rupi yase Morishasi",
    "MWK" to "Kwacha yase Malawi",
    "MZM" to "Metikali yase Mozambiki",
    "NAD" to "Dola yase Namibiya",
    "NGN" to "Nayira yase Nijeriya",
    "RWF" to "Fulenki yase Ruwanda",
    "SAR" to "Riyal yase Saudi",
    "SCR" to "Rupi yase Seyisheli",
    "SDG" to "Dinari yase Sudani",
    "SDP" to "Phawundi yase Sudani",
    "SHP" to "Phawundindi laseSt Helena",
    "SLE" to "Leyoni",
    "SLL" to "Leyoni (1964—2022)",
    "SOS" to "Shilingi yase Somaliya",
    "STD" to "Dobra yase Sao Tome lo Principe (1977–2017)",
    "STN" to "Dobra yase Sao Tome lo Principe",
    "SZL" to "Lilangeni",
    "TND" to "Dinari yase Tunisiya",
    "TZS" to "Shilingi yase Tanzaniya",
    "UGX" to "Shilingi yase Uganda",
    "USD" to "Dola yase Amelika",
    "XAF" to "Fulenki CFA BEAC",
    "XOF" to "Fulenki CFA BCEAO",
    "ZAR" to "Randi yase Afrika ye Zanzi",
    "ZMK" to "Kwacha yase Zambiya (1968–2012)",
    "ZMW" to "Kwacha yase Zambiya",
    "ZWD" to "Dola yase Zimbabwe",
  ) }

  val nds: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nds_NL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ne: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "संयुक्त अरब एमिराट्स डिर्हाम",
    "AFA" to "अफ्गानी(१९२७–२००२)",
    "AFN" to "अफ्गान अफ्गानी",
    "ALL" to "अल्बानियन लेक",
    "AMD" to "आर्मेनियाली ड्राम",
    "ANG" to "नेदरल्याण्ड्स एन्टिलियन गिल्डर",
    "AOA" to "एङ्गोलान क्वान्जा",
    "ARS" to "अर्जेन्टिनी पेसो",
    "AUD" to "अष्ट्रेलियन डलर",
    "AWG" to "आरूबन फ्लोरिन",
    "AZN" to "अजरबैजानी मानात",
    "BAM" to "बोस्निया-हर्जगोभिनिया रूपान्तरयोग्य मार्क",
    "BBD" to "बर्बाडियन डलर",
    "BDT" to "बङ्गलादेशी टाका",
    "BGN" to "बुल्गारियाली लेभ",
    "BHD" to "बाहारैनी डिनार",
    "BIF" to "बुरूण्डियाली फ्रान्क",
    "BMD" to "बर्मुडन डलर",
    "BND" to "ब्रुनाई डलर",
    "BOB" to "बोलिभियन बोलिभियानो",
    "BRL" to "ब्राजिलियन रियल",
    "BSD" to "बहामियाली डलर",
    "BTN" to "भुटानी एन्‌गुल्ट्रुम",
    "BWP" to "बोट्सवानान पुला",
    "BYN" to "बेलारूसी रूबल",
    "BYR" to "बेलारूसी रूबल (2000–2016)",
    "BZD" to "वेलिज डलर",
    "CAD" to "क्यानाडियाली डलर",
    "CDF" to "कङ्गोली फ्रान्क",
    "CHF" to "स्विस् फ्रैङ्क",
    "CLP" to "चिलियन पेसो",
    "CNH" to "चिनियाँ युआन(तटवर्ती)",
    "CNY" to "चिनिँया युआन",
    "COP" to "कोलम्वियन पेसो",
    "CRC" to "कोष्टारिकन कोलोन",
    "CUC" to "क्यूवाली रूपान्तरणयोग्य पेसो",
    "CUP" to "क्यूवाली पेसो",
    "CVE" to "केप भर्डियन एस्कुडो",
    "CZK" to "चेख गणतञ्त्र कोरूना",
    "DJF" to "जिबौंटियाली फ्रान्क",
    "DKK" to "ड्यानिश क्रोन",
    "DOP" to "डोमिनिकन पेसो",
    "DZD" to "अल्जेरियाली डिनार",
    "EGP" to "इजिप्सियन पाउन्ड",
    "ERN" to "एरिट्रियन नाक्फा",
    "ETB" to "इथियोपियाली बिर",
    "EUR" to "युरो",
    "FJD" to "फिजीयाली डलर",
    "FKP" to "फक्‌ल्याण्ड टापुहरूका पाउन्ड",
    "GBP" to "बेलायती पाउण्ड स्टर्लिङ",
    "GEL" to "जर्जियाली लारी",
    "GHS" to "घानाली सेडी",
    "GIP" to "जिब्राल्टर पाउण्ड",
    "GMD" to "गाम्वियाली डालासी",
    "GNF" to "गिनियाली फ्रान्क",
    "GTQ" to "ग्वाटेमाला क्वेट्जाल",
    "GYD" to "गाइनिज डलर",
    "HKD" to "हङकङ डलर",
    "HNL" to "होन्डुरान लेम्पिरा",
    "HRK" to "क्रोएशियाली कुना",
    "HTG" to "हैटियाली गुर्ड",
    "HUF" to "हङ्गेरियन फोरिन्ट",
    "IDR" to "इण्डोनेशियाली रूपियाँ",
    "ILS" to "इजरायली नयाँ शेकेल",
    "INR" to "भारतीय रूपिँया",
    "IQD" to "इराकी डिनार",
    "IRR" to "इरानियाली रियाल",
    "ISK" to "आइसल्याण्डिक क्रोना",
    "JMD" to "जमाइकाली डलर",
    "JOD" to "जोर्डानियाली डलर",
    "JPY" to "जापानी येन",
    "KES" to "केन्याली शिलिङ",
    "KGS" to "किर्गिस्तानी सोम",
    "KHR" to "कम्बोडिनेयाली रियल",
    "KMF" to "कोमोरियन फ्रान्क",
    "KPW" to "उत्तर कोरियाली वन",
    "KRW" to "दक्षिण कोरियाली वन",
    "KWD" to "कुवेती डिनार",
    "KYD" to "केम्यान टापुहरूका डलर",
    "KZT" to "काजाखस्तानी टेन्ज",
    "LAK" to "लाओशियन किप",
    "LBP" to "लेबनाली पाउन्ड",
    "LKR" to "श्रीलङ्काली रूपिया",
    "LRD" to "लिबेरियाली डलर",
    "LSL" to "लेसोथो लोटी",
    "LTL" to "लिथुनियाली लिटास",
    "LVL" to "लाट्भियाली लाट्स",
    "LYD" to "लिवियाली डिनार",
    "MAD" to "मोरोक्काली डिर्‌हाम",
    "MDL" to "माल्डोभन लेउ",
    "MGA" to "मालागासी एरिआरी",
    "MKD" to "म्यासेडोनियाली डेनार",
    "MMK" to "म्यान्मार क्याट",
    "MNT" to "मङ्गोलियाली टुग्रिक",
    "MOP" to "माकानिज पटाका",
    "MRO" to "माउरिटानियानली औगुइया (१९७३–२०१७)",
    "MRU" to "माउरिटानियानली औगुइया",
    "MUR" to "माउरिटियन रूपी",
    "MVR" to "मालडिभियाली रूफियाँ",
    "MWK" to "मलाविअन क्वाचा",
    "MXN" to "मेक्सिकन पेसो",
    "MYR" to "मलेशियाली रिङ्गेट",
    "MZN" to "मोजाम्विकन मेटिकल",
    "NAD" to "नामिबियन डलर",
    "NGN" to "नाइजेरियन नाइरा",
    "NIO" to "निकारागुवान कोर्डोवा",
    "NOK" to "नर्वेजियाली क्रोन",
    "NPR" to "नेपाली रूपैयाँ",
    "NZD" to "न्यूजिल्याण्ड डलर",
    "OMR" to "ओमनी रियल",
    "PAB" to "पानामानियाली बाल्बोआ",
    "PEN" to "पेरूभियाली सोल",
    "PGK" to "पपुआ न्यू गिनियाली किना",
    "PHP" to "फिलिपिनी पेसो",
    "PKR" to "पाकिस्तानी रूपियाँ",
    "PLN" to "पोलिश ज्लोटाई",
    "PYG" to "पारागुयाली गुरानी",
    "QAR" to "कतारी रियल",
    "RON" to "रोमानियाली लेऊ",
    "RSD" to "सर्बियाली डिनार",
    "RUB" to "रूसी रूबल",
    "RWF" to "र्‌वाण्डाली फ्रान्क",
    "SAR" to "साउदी रियालहरू",
    "SBD" to "सोलोमन टापुहरूका डलर",
    "SCR" to "सेचेलोइस रूपी",
    "SDG" to "सुडानी पाउन्ड",
    "SEK" to "स्विडिश क्रोना",
    "SGD" to "सिङ्गापुर डलर",
    "SHP" to "सेन्ट हेलेना पाउन्ड",
    "SLE" to "सियरा लियोनेन लियोन",
    "SLL" to "सियरा लियोनेन लियोन (१९६४—२०२२)",
    "SOS" to "सोमाली शिलिङ",
    "SRD" to "सुरिनामिज डलर",
    "SSP" to "दक्षिण सुडानी पाउन्ड",
    "STD" to "साओ टोम र प्रिन्सिप डोब्रा (१९७७–२०१७)",
    "STN" to "साओ टोम र प्रिन्सिप डोब्रा",
    "SYP" to "सिरियाली पाउन्ड",
    "SZL" to "स्वाजी लिलान्गेनी",
    "THB" to "थाई भाट",
    "TJS" to "ताजिक्स्तानी सोमोनी",
    "TMT" to "टुर्क्मेनिस्तानी मानात",
    "TND" to "टुनिसियाली डिनार",
    "TOP" to "टङ्गन पाङ्गा",
    "TRY" to "टर्किश लिरा",
    "TTD" to "त्रिनिडाड र टोबागो डलर",
    "TWD" to "नयाँ ताइवान डलर",
    "TZS" to "ताञ्जानियाली शिलिङ",
    "UAH" to "युक्रेनी हिर्भिनिया",
    "UGX" to "युगाण्डाली शिलिङ",
    "USD" to "अमेरिकी डलर",
    "UYU" to "उरूगुवायाली पेसो",
    "UZS" to "उज्बेकिस्तान सोम",
    "VEF" to "भेनेजुएलन बोलिभर (२००८–२०१८)",
    "VES" to "भेनेजुएलन बोलिभर-2",
    "VND" to "भियतनामी डङ्",
    "VUV" to "भानुआतू भातु",
    "WST" to "सामोआन ताला",
    "XAF" to "सीएफ्‌ए फ्रान्क बीइएसी",
    "XCD" to "पूर्वी क्यारिबियन डलर",
    "XOF" to "सीएफ्‌ए फ्रान्क बीसीइएओ",
    "XPF" to "सीएफ्‌पी फ्रान्क",
    "XXX" to "अज्ञात मुद्रा",
    "YER" to "येमेनी रियाल",
    "ZAR" to "दक्षिण अफ्रिकी र्‍यान्ड",
    "ZMK" to "जाम्बियाली क्वाचा (१९६८–२०१२)",
    "ZMW" to "जाम्बियाली क्वाचा",
  ) }

  val ne_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Andorrese peseta",
    "AED" to "Verenigde Arabische Emiraten-dirham",
    "AFA" to "Afghani (1927–2002)",
    "AFN" to "Afghaanse afghani",
    "ALK" to "Albanese lek (1946–1965)",
    "ALL" to "Albanese lek",
    "AMD" to "Armeense dram",
    "ANG" to "Nederlands-Antilliaanse gulden",
    "AOA" to "Angolese kwanza",
    "AOK" to "Angolese kwanza (1977–1990)",
    "AON" to "Angolese nieuwe kwanza (1990–2000)",
    "AOR" to "Angolese kwanza reajustado (1995–1999)",
    "ARA" to "Argentijnse austral",
    "ARL" to "Argentijnse peso ley (1970–1983)",
    "ARM" to "Argentijnse peso (1881–1970)",
    "ARP" to "Argentijnse peso (1983–1985)",
    "ARS" to "Argentijnse peso",
    "ATS" to "Oostenrijkse schilling",
    "AUD" to "Australische dollar",
    "AWG" to "Arubaanse gulden",
    "AZM" to "Azerbeidzjaanse manat (1993–2006)",
    "AZN" to "Azerbeidzjaanse manat",
    "BAD" to "Bosnische dinar",
    "BAM" to "Bosnische convertibele mark",
    "BAN" to "Nieuwe Bosnische dinar (1994–1997)",
    "BBD" to "Barbadaanse dollar",
    "BDT" to "Bengalese taka",
    "BEC" to "Belgische frank (convertibel)",
    "BEF" to "Belgische frank",
    "BEL" to "Belgische frank (financieel)",
    "BGL" to "Bulgaarse harde lev",
    "BGM" to "Bulgaarse socialistische lev",
    "BGN" to "Bulgaarse lev",
    "BGO" to "Bulgaarse lev (1879–1952)",
    "BHD" to "Bahreinse dinar",
    "BIF" to "Burundese frank",
    "BMD" to "Bermuda-dollar",
    "BND" to "Bruneise dollar",
    "BOB" to "Boliviaanse boliviano",
    "BOL" to "Boliviaanse boliviano (1863–1963)",
    "BOP" to "Boliviaanse peso",
    "BOV" to "Boliviaanse mvdol",
    "BRB" to "Braziliaanse cruzeiro novo (1967–1986)",
    "BRC" to "Braziliaanse cruzado",
    "BRE" to "Braziliaanse cruzeiro (1990–1993)",
    "BRL" to "Braziliaanse real",
    "BRN" to "Braziliaanse nieuwe cruzado (1989–1990)",
    "BRR" to "Braziliaanse cruzeiro",
    "BRZ" to "Braziliaanse cruzeiro (1942–1967)",
    "BSD" to "Bahamaanse dollar",
    "BTN" to "Bhutaanse ngultrum",
    "BUK" to "Birmese kyat",
    "BWP" to "Botswaanse pula",
    "BYB" to "Wit-Russische nieuwe roebel (1994–1999)",
    "BYN" to "Belarussische roebel",
    "BYR" to "Wit-Russische roebel (2000–2016)",
    "BZD" to "Belizaanse dollar",
    "CAD" to "Canadese dollar",
    "CDF" to "Congolese frank",
    "CHE" to "WIR euro",
    "CHF" to "Zwitserse frank",
    "CHW" to "WIR franc",
    "CLE" to "Chileense escudo",
    "CLF" to "Chileense unidades de fomento",
    "CLP" to "Chileense peso",
    "CNH" to "Chinese yuan (offshore)",
    "CNX" to "dollar van de Chinese Volksbank",
    "CNY" to "Chinese yuan",
    "COP" to "Colombiaanse peso",
    "COU" to "Unidad de Valor Real",
    "CRC" to "Costa Ricaanse colon",
    "CSD" to "Oude Servische dinar",
    "CSK" to "Tsjechoslowaakse harde koruna",
    "CUC" to "Cubaanse convertibele peso",
    "CUP" to "Cubaanse peso",
    "CVE" to "Kaapverdische escudo",
    "CYP" to "Cyprisch pond",
    "CZK" to "Tsjechische kroon",
    "DDM" to "Oost-Duitse ostmark",
    "DEM" to "Duitse mark",
    "DJF" to "Djiboutiaanse frank",
    "DKK" to "Deense kroon",
    "DOP" to "Dominicaanse peso",
    "DZD" to "Algerijnse dinar",
    "ECS" to "Ecuadoraanse sucre",
    "ECV" to "Ecuadoraanse unidad de valor constante (UVC)",
    "EEK" to "Estlandse kroon",
    "EGP" to "Egyptisch pond",
    "ERN" to "Eritrese nakfa",
    "ESA" to "Spaanse peseta (account A)",
    "ESB" to "Spaanse peseta (convertibele account)",
    "ESP" to "Spaanse peseta",
    "ETB" to "Ethiopische birr",
    "EUR" to "Euro",
    "FIM" to "Finse markka",
    "FJD" to "Fiji-dollar",
    "FKP" to "Falklandeilands pond",
    "FRF" to "Franse franc",
    "GBP" to "Britse pond",
    "GEK" to "Georgische kupon larit",
    "GEL" to "Georgische lari",
    "GHC" to "Ghanese cedi (1979–2007)",
    "GHS" to "Ghanese cedi",
    "GIP" to "Gibraltarees pond",
    "GMD" to "Gambiaanse dalasi",
    "GNF" to "Guinese frank",
    "GNS" to "Guinese syli",
    "GQE" to "Equatoriaal-Guinese ekwele guineana",
    "GRD" to "Griekse drachme",
    "GTQ" to "Guatemalteekse quetzal",
    "GWE" to "Portugees-Guinese escudo",
    "GWP" to "Guinee-Bissause peso",
    "GYD" to "Guyaanse dollar",
    "HKD" to "Hongkongse dollar",
    "HNL" to "Hondurese lempira",
    "HRD" to "Kroatische dinar",
    "HRK" to "Kroatische kuna",
    "HTG" to "Haïtiaanse gourde",
    "HUF" to "Hongaarse forint",
    "IDR" to "Indonesische roepia",
    "IEP" to "Iers pond",
    "ILP" to "Israëlisch pond",
    "ILR" to "Israëlische sjekel (1980–1985)",
    "ILS" to "Israëlische nieuwe shekel",
    "INR" to "Indiase roepie",
    "IQD" to "Iraakse dinar",
    "IRR" to "Iraanse rial",
    "ISJ" to "IJslandse kroon (1918–1981)",
    "ISK" to "IJslandse kroon",
    "ITL" to "Italiaanse lire",
    "JMD" to "Jamaicaanse dollar",
    "JOD" to "Jordaanse dinar",
    "JPY" to "Japanse yen",
    "KES" to "Keniaanse shilling",
    "KGS" to "Kirgizische som",
    "KHR" to "Cambodjaanse riel",
    "KMF" to "Comorese frank",
    "KPW" to "Noord-Koreaanse won",
    "KRH" to "Zuid-Koreaanse hwan (1953–1962)",
    "KRO" to "Oude Zuid-Koreaanse won (1945–1953)",
    "KRW" to "Zuid-Koreaanse won",
    "KWD" to "Koeweitse dinar",
    "KYD" to "Kaaimaneilandse dollar",
    "KZT" to "Kazachse tenge",
    "LAK" to "Laotiaanse kip",
    "LBP" to "Libanees pond",
    "LKR" to "Sri Lankaanse roepie",
    "LRD" to "Liberiaanse dollar",
    "LSL" to "Lesothaanse loti",
    "LTL" to "Litouwse litas",
    "LTT" to "Litouwse talonas",
    "LUC" to "Luxemburgse convertibele franc",
    "LUF" to "Luxemburgse frank",
    "LUL" to "Luxemburgse financiële franc",
    "LVL" to "Letse lats",
    "LVR" to "Letse roebel",
    "LYD" to "Libische dinar",
    "MAD" to "Marokkaanse dirham",
    "MAF" to "Marokkaanse franc",
    "MCF" to "Monegaskische frank",
    "MDC" to "Moldavische cupon",
    "MDL" to "Moldavische leu",
    "MGA" to "Malagassische ariary",
    "MGF" to "Malagassische franc",
    "MKD" to "Macedonische denar",
    "MKN" to "Macedonische denar (1992–1993)",
    "MLF" to "Malinese franc",
    "MMK" to "Myanmarese kyat",
    "MNT" to "Mongoolse tugrik",
    "MOP" to "Macause pataca",
    "MRO" to "Mauritaanse ouguiya (1973–2017)",
    "MRU" to "Mauritaanse ouguiya",
    "MTL" to "Maltese lire",
    "MTP" to "Maltees pond",
    "MUR" to "Mauritiaanse roepie",
    "MVP" to "Maldivische roepie",
    "MVR" to "Maldivische rufiyaa",
    "MWK" to "Malawische kwacha",
    "MXN" to "Mexicaanse peso",
    "MXP" to "Mexicaanse zilveren peso (1861–1992)",
    "MXV" to "Mexicaanse unidad de inversion (UDI)",
    "MYR" to "Maleisische ringgit",
    "MZE" to "Mozambikaanse escudo",
    "MZM" to "Oude Mozambikaanse metical",
    "MZN" to "Mozambikaanse metical",
    "NAD" to "Namibische dollar",
    "NGN" to "Nigeriaanse naira",
    "NIC" to "Nicaraguaanse córdoba (1988–1991)",
    "NIO" to "Nicaraguaanse córdoba",
    "NLG" to "Nederlandse gulden",
    "NOK" to "Noorse kroon",
    "NPR" to "Nepalese roepie",
    "NZD" to "Nieuw-Zeelandse dollar",
    "OMR" to "Omaanse rial",
    "PAB" to "Panamese balboa",
    "PEI" to "Peruaanse inti",
    "PEN" to "Peruaanse sol",
    "PES" to "Peruaanse sol (1863–1965)",
    "PGK" to "Papoea-Nieuw-Guinese kina",
    "PHP" to "Filipijnse peso",
    "PKR" to "Pakistaanse roepie",
    "PLN" to "Poolse zloty",
    "PLZ" to "Poolse zloty (1950–1995)",
    "PTE" to "Portugese escudo",
    "PYG" to "Paraguayaanse guarani",
    "QAR" to "Qatarese rial",
    "RHD" to "Rhodesische dollar",
    "ROL" to "Oude Roemeense leu",
    "RON" to "Roemeense leu",
    "RSD" to "Servische dinar",
    "RUB" to "Russische roebel",
    "RUR" to "Russische roebel (1991–1998)",
    "RWF" to "Rwandese frank",
    "SAR" to "Saoedi-Arabische riyal",
    "SBD" to "Salomon-dollar",
    "SCR" to "Seychelse roepie",
    "SDD" to "Soedanese dinar",
    "SDG" to "Soedanees pond",
    "SDP" to "Soedanees pond (1957–1998)",
    "SEK" to "Zweedse kroon",
    "SGD" to "Singaporese dollar",
    "SHP" to "Sint-Heleens pond",
    "SIT" to "Sloveense tolar",
    "SKK" to "Slowaakse koruna",
    "SLE" to "Sierra Leoonse leone",
    "SLL" to "Sierra Leoonse leone (1964–2022)",
    "SOS" to "Somalische shilling",
    "SRD" to "Surinaamse dollar",
    "SRG" to "Surinaamse gulden",
    "SSP" to "Zuid-Soedanees pond",
    "STD" to "Santomese dobra (1977–2017)",
    "STN" to "Santomese dobra",
    "SUR" to "Sovjet-roebel",
    "SVC" to "Salvadoraanse colón",
    "SYP" to "Syrisch pond",
    "SZL" to "Swazische lilangeni",
    "THB" to "Thaise baht",
    "TJR" to "Tadzjikistaanse roebel",
    "TJS" to "Tadzjiekse somoni",
    "TMM" to "Turkmeense manat (1993–2009)",
    "TMT" to "Turkmeense manat",
    "TND" to "Tunesische dinar",
    "TOP" to "Tongaanse paʻanga",
    "TPE" to "Timorese escudo",
    "TRL" to "Turkse lire",
    "TRY" to "Turkse lira",
    "TTD" to "Trinidad en Tobago-dollar",
    "TWD" to "Nieuwe Taiwanese dollar",
    "TZS" to "Tanzaniaanse shilling",
    "UAH" to "Oekraïense hryvnia",
    "UAK" to "Oekraïense karbovanetz",
    "UGS" to "Oegandese shilling (1966–1987)",
    "UGX" to "Oegandese shilling",
    "USD" to "Amerikaanse dollar",
    "USN" to "Amerikaanse dollar (volgende dag)",
    "USS" to "Amerikaanse dollar (zelfde dag)",
    "UYI" to "Uruguayaanse peso en geïndexeerde eenheden",
    "UYP" to "Uruguayaanse peso (1975–1993)",
    "UYU" to "Uruguayaanse peso",
    "UYW" to "Uruguayaanse nominale salarisindexeenheid",
    "UZS" to "Oezbeekse sum",
    "VEB" to "Venezolaanse bolivar (1871–2008)",
    "VED" to "Bolívar Soberano",
    "VEF" to "Venezolaanse bolivar (2008–2018)",
    "VES" to "Venezolaanse bolivar",
    "VND" to "Vietnamese dong",
    "VNN" to "Vietnamese dong (1978–1985)",
    "VUV" to "Vanuatuaanse vatu",
    "WST" to "Samoaanse tala",
    "XAF" to "CFA-frank",
    "XAG" to "Zilver",
    "XAU" to "Goud",
    "XBA" to "Europese samengestelde eenheid",
    "XBB" to "Europese monetaire eenheid",
    "XBC" to "Europese rekeneenheid (XBC)",
    "XBD" to "Europese rekeneenheid (XBD)",
    "XCD" to "Oost-Caribische dollar",
    "XCG" to "Caribische gulden",
    "XDR" to "Special Drawing Rights",
    "XEU" to "European Currency Unit",
    "XFO" to "Franse gouden franc",
    "XFU" to "Franse UIC-franc",
    "XOF" to "CFA-franc BCEAO",
    "XPD" to "Palladium",
    "XPF" to "CFP-frank",
    "XPT" to "Platina",
    "XRE" to "RINET-fondsen",
    "XSU" to "Sucre",
    "XTS" to "Valutacode voor testdoeleinden",
    "XUA" to "ADB-rekeneenheid",
    "XXX" to "onbekende munteenheid",
    "YDD" to "Jemenitische dinar",
    "YER" to "Jemenitische rial",
    "YUD" to "Joegoslavische harde dinar",
    "YUM" to "Joegoslavische noviy-dinar",
    "YUN" to "Joegoslavische convertibele dinar",
    "YUR" to "Joegoslavische hervormde dinar (1992–1993)",
    "ZAL" to "Zuid-Afrikaanse rand (financieel)",
    "ZAR" to "Zuid-Afrikaanse rand",
    "ZMK" to "Zambiaanse kwacha (1968–2012)",
    "ZMW" to "Zambiaanse kwacha",
    "ZRN" to "Zaïrese nieuwe zaïre",
    "ZRZ" to "Zaïrese zaïre",
    "ZWD" to "Zimbabwaanse dollar",
    "ZWL" to "Zimbabwaanse dollar (2009)",
    "ZWR" to "Zimbabwaanse dollar (2008)",
  ) }

  val nl_AW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nl_BE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nl_BQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nl_CW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nl_SR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nl_SX: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nmg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Mɔn B ´Arabe",
    "AOA" to "Mɔn Angola",
    "AUD" to "Dɔ́llɔ Ɔstralia",
    "BHD" to "Mɔn Bahrein",
    "BIF" to "Fraŋ Burundi",
    "BWP" to "Mɔn Botswana",
    "CAD" to "Dɔ́llɔ Kanada",
    "CDF" to "Fraŋ bó Kongolɛ̌",
    "CHF" to "Fraŋ Suisse",
    "CNY" to "Mɔn bó Chinois",
    "CVE" to "Mɔn Kapvɛrt",
    "DJF" to "Fraŋ Jibuti",
    "DZD" to "Mɔn Algeria",
    "EGP" to "Mɔn Ägyptɛn",
    "ERN" to "Mɔn Erytré",
    "ETB" to "Mɔn Ethiopia",
    "EUR" to "Euro",
    "GBP" to "Mɔn Ngɛ̄lɛ̄n",
    "GHC" to "Mɔn Gana",
    "GMD" to "Mɔn Gambia",
    "GNS" to "Fraŋ Guiné",
    "INR" to "Mɔn India",
    "JPY" to "Mɔn Japɔn",
    "KES" to "Mɔn Kɛnya",
    "KMF" to "Fraŋ bó Kɔmɔr",
    "LRD" to "Dɔ́llɔ Liberia",
    "LSL" to "Mɔn Lesoto",
    "LYD" to "Mɔn Libya",
    "MAD" to "Mɔn Marɔk",
    "MGA" to "Mɔn Madagaskar",
    "MRO" to "Mɔn Moritania (1973–2017)",
    "MRU" to "Mɔn Moritania",
    "MUR" to "Mɔn Moriss",
    "MWK" to "Mɔn Malawi",
    "MZM" to "Mɔn Mozambik",
    "NAD" to "Dɔ́llɔ Namibia",
    "NGN" to "Naïra Nigeria",
    "RWF" to "Fraŋ Rwanda",
    "SAR" to "Mɔn Saudi Arabia",
    "SCR" to "Mɔn Seychɛlle",
    "SDG" to "Mɔn Sudan",
    "SDP" to "Mɔn Sudan (1957–1998)",
    "SHP" to "Mɔn má Saint Lina",
    "SLE" to "Mɔn Leɔne",
    "SLL" to "Mɔn Leɔn (1964—2022)¨",
    "SOS" to "Mɔn Somalía",
    "STD" to "Mɔn Sao tomé na prinship (1977–2017)",
    "STN" to "Mɔn Sao tomé na prinship",
    "SZL" to "Mɔn Ligangeni",
    "TND" to "Mɔn Tunisia",
    "TZS" to "Mɔn Tanzania",
    "UGX" to "Mɔn Uganda",
    "USD" to "Dɔ́llɔ Amɛŕka",
    "XAF" to "Fraŋ CFA BEAC",
    "XOF" to "Fraŋ CFA BCEAO",
    "ZAR" to "Mɔn Afrik yí sí",
    "ZMK" to "Mɔn Zambia (1968–2012)",
    "ZMW" to "Mɔn Zambia",
    "ZWD" to "Dɔ́llɔ Zimbabwǝ (1980–2008)",
  ) }

  val nn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "andorranske peseta",
    "AED" to "emiratarabiske dirham",
    "AFA" to "afghanske afghani (1927–2002)",
    "AFN" to "afghanske afghani",
    "ALK" to "albanske lek (1946–1965)",
    "ALL" to "albanske lek",
    "AMD" to "armenske dram",
    "ANG" to "nederlandske antillegylden",
    "AOA" to "angolanske kwanza",
    "AOK" to "angolske kwanza (1977–1990)",
    "AON" to "angolske nye kwanza (1990–2000)",
    "AOR" to "angolske kwanza reajustado (1995–1999)",
    "ARA" to "argentiske austral",
    "ARL" to "argentinske peso ley",
    "ARM" to "argentinsk pesos (1881–1970)",
    "ARP" to "argentinske peso (1983–1985)",
    "ARS" to "argentinske pesos",
    "ATS" to "austerrikske schilling",
    "AUD" to "australske dollar",
    "AWG" to "arubiske florinar",
    "AZM" to "aserbajdsjanske manat (1993–2006)",
    "AZN" to "aserbajdsjanske manat",
    "BAD" to "bosnisk-hercegovinske dinarar (1992–1994)",
    "BAM" to "bosnisk-hercegovinske konvertible mark",
    "BAN" to "nye bosnisk-hercegovinske dinarar (1994–1997)",
    "BBD" to "barbadiske dollar",
    "BDT" to "bangladeshiske taka",
    "BEC" to "belgiske franc (konvertibel)",
    "BEF" to "belgiske franc",
    "BEL" to "belgiske franc (finansiell)",
    "BGL" to "bulgarsk hard lev",
    "BGM" to "bulgarske lev (sosialist)",
    "BGN" to "bulgarske lev",
    "BGO" to "bulgarske lev (1879–1952)",
    "BHD" to "bahrainske dinarar",
    "BIF" to "burundiske franc",
    "BMD" to "bermudiske dollar",
    "BND" to "bruneiske dollar",
    "BOB" to "bolivianske boliviano",
    "BOL" to "bolivianske boliviano (1863–1963)",
    "BOP" to "boliviske peso",
    "BOV" to "boliviske mvdol",
    "BRB" to "brasiliansk cruzeiro novo (1967–1986)",
    "BRC" to "brasilianske cruzado",
    "BRE" to "brasilianske cruzeiro (1990–1993)",
    "BRL" to "brasilianske real",
    "BRN" to "brasilianske cruzado novo",
    "BRR" to "brasilianske cruzeiro",
    "BRZ" to "brasilianske cruzeiro (1942–1967)",
    "BSD" to "bahamanske dollar",
    "BTN" to "bhutanske ngultrum",
    "BUK" to "burmesisk kyat",
    "BWP" to "botswanske pula",
    "BYB" to "belarusiske nye rublar (1994–1999)",
    "BYN" to "nye belarusiske rublar",
    "BYR" to "belarusiske rublar (2000–2016)",
    "BZD" to "beliziske dollar",
    "CAD" to "kanadiske dollar",
    "CDF" to "kongolesiske franc",
    "CHE" to "WIR-euro",
    "CHF" to "sveitsiske franc",
    "CHW" to "WIR-franc",
    "CLE" to "chilenske escudo",
    "CLF" to "chilenske unidades de fomento",
    "CLP" to "chilenske pesos",
    "CNH" to "kinesiske yuan (offshore)",
    "CNX" to "Kinas folkebank dollar",
    "CNY" to "kinesiske yuan",
    "COP" to "kolombianske pesos",
    "COU" to "unidad de valor real",
    "CRC" to "kostarikanske colón",
    "CSD" to "gamle serbiske dinarer",
    "CSK" to "tsjekkoslovakiske koruna (hard)",
    "CUC" to "kubanske konvertible pesos",
    "CUP" to "kubanske pesos",
    "CVE" to "kappverdiske escudo",
    "CYP" to "kypriotiske pund",
    "CZK" to "tsjekkiske koruna",
    "DDM" to "austtyske mark",
    "DEM" to "tyske mark",
    "DJF" to "djiboutiske franc",
    "DKK" to "danske kroner",
    "DOP" to "dominikanske pesos",
    "DZD" to "algeriske dinarar",
    "ECS" to "ecuadorianske sucre",
    "ECV" to "ecuadorianske unidad de valor constante (UVC)",
    "EEK" to "estiske kroon",
    "EGP" to "egyptiske pund",
    "ERN" to "eritreiske nakfa",
    "ESA" to "spanske peseta (A–konto)",
    "ESB" to "spanske peseta (konvertibel konto)",
    "ESP" to "spanske peseta",
    "ETB" to "etiopiske birr",
    "EUR" to "euro",
    "FIM" to "finske mark",
    "FJD" to "fijianske dollar",
    "FKP" to "falklandspund",
    "FRF" to "franske franc",
    "GBP" to "britiske pund",
    "GEK" to "georgiske kupon larit",
    "GEL" to "georgiske lari",
    "GHC" to "ghanesiske cedi (1979–2007)",
    "GHS" to "ghanesiske cedi",
    "GIP" to "gibraltarske pund",
    "GMD" to "gambiske dalasi",
    "GNF" to "guineanske franc",
    "GNS" to "guineanske syli",
    "GQE" to "ekvatorialguineanske ekwele guineana",
    "GRD" to "greske drakme",
    "GTQ" to "guatemalanske quetzal",
    "GWE" to "portugisiske guinea escudo",
    "GWP" to "Guinea-Bissau-peso",
    "GYD" to "guyanske dollar",
    "HKD" to "Hongkong-dollar",
    "HNL" to "honduranske lempira",
    "HRD" to "kroatiske dinar",
    "HRK" to "kroatiske kuna",
    "HTG" to "haitiske gourde",
    "HUF" to "ungarske forintar",
    "IDR" to "indonesiske rupiahar",
    "IEP" to "irske pund",
    "ILP" to "israelske pund",
    "ILR" to "israelske shekler (1980–1985)",
    "ILS" to "nye israelske sheklar",
    "INR" to "indiske rupiar",
    "IQD" to "irakiske dinarar",
    "IRR" to "iranske rial",
    "ISJ" to "islandske kroner (1918–1981)",
    "ISK" to "islandske kroner",
    "ITL" to "italienske lire",
    "JMD" to "jamaikanske dollar",
    "JOD" to "jordanske dinarar",
    "JPY" to "japanske yen",
    "KES" to "kenyanske shilling",
    "KGS" to "kirgisiske som",
    "KHR" to "kambodsjanske riel",
    "KMF" to "komoriske franc",
    "KPW" to "nordkoreanske won",
    "KRH" to "sørkoreanske hwan (1953–1962)",
    "KRO" to "sørkoreanske won (1945–1953)",
    "KRW" to "sørkoreanske won",
    "KWD" to "kuwaitiske dinarar",
    "KYD" to "caymanske dollar",
    "KZT" to "kasakhstanske tenge",
    "LAK" to "laotiske kip",
    "LBP" to "libanesiske pund",
    "LKR" to "srilankiske rupiar",
    "LRD" to "liberiske dollar",
    "LSL" to "lesothiske loti",
    "LTL" to "litauiske lita",
    "LTT" to "litauiske talona",
    "LUC" to "luxemburgske konvertibel franc",
    "LUF" to "luxemburgske franc",
    "LUL" to "luxemburgske finansielle franc",
    "LVL" to "latviske lat",
    "LVR" to "latviske rublar",
    "LYD" to "libyske dinarar",
    "MAD" to "marokkanske dirham",
    "MAF" to "marokkanske franc",
    "MCF" to "monegaskiske franc",
    "MDC" to "moldovske cupon",
    "MDL" to "moldovske leuar",
    "MGA" to "madagassiske ariary",
    "MGF" to "madagassiske franc",
    "MKD" to "makedonske denarar",
    "MKN" to "makedonske denarar (1992–1993)",
    "MLF" to "maliske franc",
    "MMK" to "myanmarske kyat",
    "MNT" to "mongolske tugrik",
    "MOP" to "makaoiske pataca",
    "MRO" to "mauritanske ouguiya (1973–2017)",
    "MRU" to "mauritanske ouguiya",
    "MTL" to "maltesiske lira",
    "MTP" to "maltesiske pund",
    "MUR" to "mauritiske rupiar",
    "MVP" to "maldiviske rupiar",
    "MVR" to "maldiviske rufiyaa",
    "MWK" to "malawiske kwacha",
    "MXN" to "meksikanske pesos",
    "MXP" to "meksikanske sølvpeso (1861–1992)",
    "MXV" to "meksikanske unidad de inversion (UDI)",
    "MYR" to "malaysiske ringgit",
    "MZE" to "mosambikiske escudo",
    "MZM" to "gamle mosambikiske metical",
    "MZN" to "mosambikiske metical",
    "NAD" to "namibiske dollar",
    "NGN" to "nigerianske naira",
    "NIC" to "nicaraguanske cordoba",
    "NIO" to "nicaraguanske córdoba",
    "NLG" to "nederlandske gylden",
    "NOK" to "norske kroner",
    "NPR" to "nepalske rupiar",
    "NZD" to "nyzealandske dollar",
    "OMR" to "omanske rial",
    "PAB" to "panamanske balboa",
    "PEI" to "peruanske inti",
    "PEN" to "peruanske sol",
    "PES" to "peruanske sol (1863–1965)",
    "PGK" to "papuanske kina",
    "PHP" to "filippinske pesos",
    "PKR" to "pakistanske rupiar",
    "PLN" to "polske zloty",
    "PLZ" to "polske zloty (1950–1995)",
    "PTE" to "portugisiske escudo",
    "PYG" to "paraguayanske guaraní",
    "QAR" to "qatarske rial",
    "RHD" to "rhodesiske dollar",
    "ROL" to "gamle rumenske leu",
    "RON" to "rumenske leuar",
    "RSD" to "serbiske dinarar",
    "RUB" to "russiske rublar",
    "RUR" to "russiske rublar (1991–1998)",
    "RWF" to "rwandiske franc",
    "SAR" to "saudiarabiske rial",
    "SBD" to "salomonske dollar",
    "SCR" to "seychelliske rupiar",
    "SDD" to "gamle sudanske dinarer",
    "SDG" to "sudanske pund",
    "SDP" to "gamle sudanske pund",
    "SEK" to "svenske kroner",
    "SGD" to "singaporske dollar",
    "SHP" to "sankthelenske pund",
    "SIT" to "slovenske tolar",
    "SKK" to "slovakiske koruna",
    "SLE" to "sierraleonsk leone",
    "SLL" to "sierraleonsk leone (1964—2022)",
    "SOS" to "somaliske shilling",
    "SRD" to "surinamske dollar",
    "SRG" to "surinamske gylden",
    "SSP" to "sørsudanske pund",
    "STD" to "saotomesiske dobra (1977–2017)",
    "STN" to "saotomesiske dobra",
    "SUR" to "sovjetiske rublar",
    "SVC" to "salvadoranske colon",
    "SYP" to "syriske pund",
    "SZL" to "eswatinisk lilangeni",
    "THB" to "thailandske baht",
    "TJR" to "tadsjikiske rublar",
    "TJS" to "tadsjikiske somoni",
    "TMM" to "turkmenske manat (1993–2009)",
    "TMT" to "turkmenske manat",
    "TND" to "tunisiske dinarar",
    "TOP" to "tonganske paʻanga",
    "TPE" to "timoresiske escudo",
    "TRL" to "gamle tyrkiske lire",
    "TRY" to "tyrkiske lira",
    "TTD" to "trinidadiske dollar",
    "TWD" to "nye taiwanske dollar",
    "TZS" to "tanzanianske shilling",
    "UAH" to "ukrainske hryvnia",
    "UAK" to "ukrainske karbovanetz",
    "UGS" to "ugandiske shilling (1966–1987)",
    "UGX" to "ugandiske shilling",
    "USD" to "amerikanske dollar",
    "USN" to "amerikanske dollar (neste dag)",
    "USS" to "amerikanske dollar (same dag)",
    "UYI" to "uruguayanske peso en unidades indexadas",
    "UYP" to "uruguayanske peso (1975–1993)",
    "UYU" to "uruguayanske pesos",
    "UZS" to "usbekiske sum",
    "VEB" to "venezuelanske bolivar (1871–2008)",
    "VEF" to "venezuelanske bolivar (2008–2018)",
    "VES" to "venezuelanske bolivar",
    "VND" to "vietnamesiske dong",
    "VNN" to "vietnamesiske dong (1978–1985)",
    "VUV" to "vanuatuiske vatu",
    "WST" to "samoanske tala",
    "XAF" to "sentralafrikanske CFA-franc",
    "XAG" to "sølv",
    "XAU" to "gull",
    "XBA" to "europeiske samansette einingar",
    "XBB" to "europeiske monetære einingar",
    "XBC" to "europeiske kontoeiningar (XBC)",
    "XBD" to "europeiske kontoeiningar (XBD)",
    "XCD" to "austkaribiske dollar",
    "XDR" to "spesielle trekkrettar",
    "XEU" to "europeiske valutaeiningar",
    "XFO" to "franske gullfranc",
    "XFU" to "franske UIC-franc",
    "XOF" to "vestafrikanske CFA-franc",
    "XPD" to "palladium",
    "XPF" to "CFP-franc",
    "XPT" to "platina",
    "XRE" to "RINET-fond",
    "XSU" to "sucre",
    "XTS" to "testvalutakode",
    "XUA" to "ADB-kontoenhet",
    "XXX" to "ukjend valuta",
    "YDD" to "jemenittiske dinarar",
    "YER" to "jemenittiske rial",
    "YUD" to "jugoslaviske dinarar (hard)",
    "YUM" to "jugoslaviske noviy-dinarar",
    "YUN" to "jugoslaviske konvertibel dinarar",
    "YUR" to "jugoslaviske reformerte dinarer (1992–1993)",
    "ZAL" to "sørafrikanske rand (finansiell)",
    "ZAR" to "sørafrikanske rand",
    "ZMK" to "zambiske kwacha (1968–2012)",
    "ZMW" to "zambiske kwacha",
    "ZRN" to "zairisk ny zaire",
    "ZRZ" to "zairisk zaire",
    "ZWD" to "zimbabwisk dollar",
    "ZWL" to "zimbabwisk dollar (2009)",
    "ZWR" to "zimbabwisk dollar (2008)",
  ) }

  val nnh: ImmutableMap<String, String> by lazy { immutableMapOf(
    "XAF" to "feláŋ CFA",
  ) }

  val no: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "andorranske pesetas",
    "AED" to "emiratarabiske dirham",
    "AFA" to "afgansk afghani (1927–2002)",
    "AFN" to "afghanske afghani",
    "ALK" to "albanske lek (1946–1965)",
    "ALL" to "albanske lek",
    "AMD" to "armenske dram",
    "ANG" to "nederlandske antillegylden",
    "AOA" to "angolanske kwanza",
    "AOK" to "angolanske kwanza (1977–1990)",
    "AON" to "angolanske nye kwanza (1990–2000)",
    "AOR" to "angolanske omjusterte kwanza (1995–1999)",
    "ARA" to "argentinske australer",
    "ARL" to "argentinske peso ley",
    "ARM" to "argentinsk pesos (1881–1970)",
    "ARP" to "argentinske pesos (1983–1985)",
    "ARS" to "argentinske pesos",
    "ATS" to "østerrikske shilling",
    "AUD" to "australske dollar",
    "AWG" to "arubiske floriner",
    "AZM" to "aserbajdsjanske manat (1993–2006)",
    "AZN" to "aserbajdsjanske manat",
    "BAD" to "bosnisk-hercegovinske dinarer (1992–1994)",
    "BAM" to "bosnisk-hercegovinske konvertible mark",
    "BAN" to "nye bosnisk-hercegovinske dinarer (1994–1997)",
    "BBD" to "barbadiske dollar",
    "BDT" to "bangladeshiske taka",
    "BEC" to "belgiske franc (konvertible)",
    "BEF" to "belgiske franc",
    "BEL" to "belgiske franc (finansielle)",
    "BGL" to "bulgarske lev (hard)",
    "BGM" to "bulgarske lev (sosialist)",
    "BGN" to "bulgarske lev",
    "BGO" to "bulgarske lev (1879–1952)",
    "BHD" to "bahrainske dinarer",
    "BIF" to "burundiske franc",
    "BMD" to "bermudiske dollar",
    "BND" to "bruneiske dollar",
    "BOB" to "bolivianske boliviano",
    "BOL" to "bolivianske boliviano (1863–1963)",
    "BOP" to "bolivianske pesos",
    "BOV" to "bolivianske mvdol",
    "BRB" to "brasilianske cruzeiro novo (1967–1986)",
    "BRC" to "brasilianske cruzados (1986–1989)",
    "BRE" to "brasilianske cruzeiro (1990–1993)",
    "BRL" to "brasilianske real",
    "BRN" to "brasilianske cruzado novo (1989–1990)",
    "BRR" to "brasilianske cruzeiro (1993–1994)",
    "BRZ" to "brasilianske cruzeiro (1942–1967)",
    "BSD" to "bahamanske dollar",
    "BTN" to "bhutanske ngultrum",
    "BUK" to "burmesiske kyat",
    "BWP" to "botswanske pula",
    "BYB" to "hviterussiske nye rubler (1994–1999)",
    "BYN" to "nye belarusiske rubler",
    "BYR" to "hviterussiske rubler (2000–2016)",
    "BZD" to "beliziske dollar",
    "CAD" to "kanadiske dollar",
    "CDF" to "kongolesiske franc",
    "CHE" to "WIR euro",
    "CHF" to "sveitsiske franc",
    "CHW" to "WIR franc",
    "CLE" to "chilenske escudo",
    "CLF" to "chilenske unidades de fomento",
    "CLP" to "chilenske pesos",
    "CNH" to "kinesiske yuan (offshore)",
    "CNX" to "Kinas folkebank dollar",
    "CNY" to "kinesiske yuan",
    "COP" to "colombianske pesos",
    "COU" to "colombianske unidad de valor real",
    "CRC" to "costaricanske colón",
    "CSD" to "serbiske dinarer (2002–2006)",
    "CSK" to "tsjekkoslovakiske koruna (hard)",
    "CUC" to "kubanske konvertible pesos",
    "CUP" to "kubanske pesos",
    "CVE" to "kappverdiske escudos",
    "CYP" to "kypriotiske pund",
    "CZK" to "tsjekkiske koruna",
    "DDM" to "østtyske mark",
    "DEM" to "tyske mark",
    "DJF" to "djiboutiske franc",
    "DKK" to "danske kroner",
    "DOP" to "dominikanske pesos",
    "DZD" to "algeriske dinarer",
    "ECS" to "ecuadorianske sucre",
    "ECV" to "ecuadorianske unidad de valor constante (UVC)",
    "EEK" to "estiske kroon",
    "EGP" to "egyptiske pund",
    "ERN" to "eritreiske nakfa",
    "ESA" to "spanske peseta (A–konto)",
    "ESB" to "spanske peseta (konvertibel konto)",
    "ESP" to "spanske peseta",
    "ETB" to "etiopiske birr",
    "EUR" to "euro",
    "FIM" to "finske mark",
    "FJD" to "fijianske dollar",
    "FKP" to "falklandspund",
    "FRF" to "franske franc",
    "GBP" to "britiske pund",
    "GEK" to "georgiske kupon larit",
    "GEL" to "georgiske lari",
    "GHC" to "ghanesisk cedi (1979–2007)",
    "GHS" to "ghanesiske cedi",
    "GIP" to "gibraltarske pund",
    "GMD" to "gambiske dalasi",
    "GNF" to "guineanske franc",
    "GNS" to "guineanske syli",
    "GQE" to "ekvatorialguineanske ekwele guineana",
    "GRD" to "greske drakmer",
    "GTQ" to "guatemalanske quetzal",
    "GWE" to "portugisiske guinea escudo",
    "GWP" to "Guinea-Bissau-pesos",
    "GYD" to "guyanske dollar",
    "HKD" to "Hongkong-dollar",
    "HNL" to "honduranske lempira",
    "HRD" to "kroatiske dinarer",
    "HRK" to "kroatiske kuna",
    "HTG" to "haitiske gourde",
    "HUF" to "ungarske forinter",
    "IDR" to "indonesiske rupier",
    "IEP" to "irske pund",
    "ILP" to "israelske pund",
    "ILR" to "israelske shekler (1980–1985)",
    "ILS" to "nye israelske shekler",
    "INR" to "indiske rupier",
    "IQD" to "irakske dinarer",
    "IRR" to "iranske rialer",
    "ISJ" to "islandske kroner (1918–1981)",
    "ISK" to "islandske kroner",
    "ITL" to "italienske lire",
    "JMD" to "jamaikanske dollar",
    "JOD" to "jordanske dinarer",
    "JPY" to "japanske yen",
    "KES" to "kenyanske shilling",
    "KGS" to "kirgisiske som",
    "KHR" to "kambodsjanske riel",
    "KMF" to "komoriske franc",
    "KPW" to "nordkoreanske won",
    "KRH" to "sørkoreanske hwan (1953–1962)",
    "KRO" to "sørkoreanske won (1945–1953)",
    "KRW" to "sørkoreanske won",
    "KWD" to "kuwaitiske dinarer",
    "KYD" to "caymanske dollar",
    "KZT" to "kasakhstanske tenge",
    "LAK" to "laotiske kip",
    "LBP" to "libanesiske pund",
    "LKR" to "srilankiske rupier",
    "LRD" to "liberiske dollar",
    "LSL" to "lesothiske loti",
    "LTL" to "litauiske litas",
    "LTT" to "litauiske talonas",
    "LUC" to "luxemburgske konvertible franc",
    "LUF" to "luxemburgske franc",
    "LUL" to "luxemburgske finansielle franc",
    "LVL" to "latviske lats",
    "LVR" to "latviske rubler",
    "LYD" to "libyske dinarer",
    "MAD" to "marokkanske dirham",
    "MAF" to "marokkanske franc",
    "MCF" to "monegaskiske franc",
    "MDC" to "moldovske cupon",
    "MDL" to "moldovske leu",
    "MGA" to "madagassiske ariary",
    "MGF" to "madagassiske franc",
    "MKD" to "makedonske denarer",
    "MKN" to "makedonske denarer (1992–1993)",
    "MLF" to "maliske franc",
    "MMK" to "myanmarske kyat",
    "MNT" to "mongolske tugrik",
    "MOP" to "makaoiske pataca",
    "MRO" to "mauritanske ouguiya (1973–2017)",
    "MRU" to "mauritanske ouguiya",
    "MTL" to "maltesiske lira",
    "MTP" to "maltesiske pund",
    "MUR" to "mauritiske rupier",
    "MVP" to "maldiviske rupier",
    "MVR" to "maldiviske rufiyaa",
    "MWK" to "malawiske kwacha",
    "MXN" to "meksikanske pesos",
    "MXP" to "meksikanske sølvpesos (1861–1992)",
    "MXV" to "meksikanske unidad de inversion (UDI)",
    "MYR" to "malaysiske ringgit",
    "MZE" to "mosambikiske escudo",
    "MZM" to "gamle mosambikiske metical",
    "MZN" to "mosambikiske metical",
    "NAD" to "namibiske dollar",
    "NGN" to "nigerianske naira",
    "NIC" to "nicaraguanske cordoba (1988–1991)",
    "NIO" to "nicaraguanske córdoba",
    "NLG" to "nederlandske gylden",
    "NOK" to "norske kroner",
    "NPR" to "nepalske rupier",
    "NZD" to "newzealandske dollar",
    "OMR" to "omanske rialer",
    "PAB" to "panamanske balboa",
    "PEI" to "peruanske inti",
    "PEN" to "peruanske sol",
    "PES" to "peruanske sol (1863–1965)",
    "PGK" to "papuanske kina",
    "PHP" to "filippinske pesos",
    "PKR" to "pakistanske rupier",
    "PLN" to "polske zloty",
    "PLZ" to "polske zloty (1950–1995)",
    "PTE" to "portugisiske escudo",
    "PYG" to "paraguayanske guarani",
    "QAR" to "qatarske rialer",
    "RHD" to "rhodesiske dollar",
    "ROL" to "rumenske leu (1952–2006)",
    "RON" to "rumenske leu",
    "RSD" to "serbiske dinarer",
    "RUB" to "russiske rubler",
    "RUR" to "russiske rubler (1991–1998)",
    "RWF" to "rwandiske franc",
    "SAR" to "saudiarabiske riyaler",
    "SBD" to "salomonske dollar",
    "SCR" to "seychelliske rupier",
    "SDD" to "sudanesiske dinarer (1992–2007)",
    "SDG" to "sudanske pund",
    "SDP" to "sudanesiske pund",
    "SEK" to "svenske kroner",
    "SGD" to "singaporske dollar",
    "SHP" to "sankthelenske pund",
    "SIT" to "slovenske tolar",
    "SKK" to "slovakiske koruna",
    "SLE" to "sierraleonsk leone",
    "SLL" to "sierraleonsk leone (1964–2022)",
    "SOS" to "somaliske shilling",
    "SRD" to "surinamske dollar",
    "SRG" to "surinamske gylden",
    "SSP" to "sørsudanske pund",
    "STD" to "saotomesiske dobra (1977–2017)",
    "STN" to "saotomesiske dobra",
    "SUR" to "sovjetiske rubler",
    "SVC" to "salvadoranske colon",
    "SYP" to "syriske pund",
    "SZL" to "swazilandske lilangeni",
    "THB" to "thailandske baht",
    "TJR" to "tadsjikiske rubler",
    "TJS" to "tadsjikiske somoni",
    "TMM" to "turkmenske manat (1993–2009)",
    "TMT" to "turkmenske manat",
    "TND" to "tunisiske dinarer",
    "TOP" to "tonganske paʻanga",
    "TPE" to "timoresiske escudo",
    "TRL" to "tyrkiske lire (1922–2005)",
    "TRY" to "tyrkiske lire",
    "TTD" to "trinidadiske dollar",
    "TWD" to "nye taiwanske dollar",
    "TZS" to "tanzanianske shilling",
    "UAH" to "ukrainske hryvnia",
    "UAK" to "ukrainske karbovanetz",
    "UGS" to "ugandiske shilling (1966–1987)",
    "UGX" to "ugandiske shilling",
    "USD" to "amerikanske dollar",
    "USN" to "amerikanske dollar (neste dag)",
    "USS" to "amerikanske dollar (samme dag)",
    "UYI" to "uruguyanske pesos (indekserte enheter)",
    "UYP" to "uruguayanske pesos (1975–1993)",
    "UYU" to "uruguayanske pesos",
    "UZS" to "usbekiske som",
    "VEB" to "venezuelanske bolivar (1871–2008)",
    "VEF" to "venezuelanske bolivar (2008–2018)",
    "VES" to "venezuelanske bolivar",
    "VND" to "vietnamesiske dong",
    "VNN" to "vietnamesiske dong (1978–1985)",
    "VUV" to "vanuatiske vatu",
    "WST" to "samoanske tala",
    "XAF" to "sentralafrikanske CFA-franc",
    "XAG" to "sølv",
    "XAU" to "gull",
    "XBA" to "europeisk sammensatt enhet",
    "XBB" to "europeisk monetær enhet",
    "XBC" to "europeisk kontoenhet (XBC)",
    "XBD" to "europeisk kontoenhet (XBD)",
    "XCD" to "østkaribiske dollar",
    "XDR" to "spesielle trekkrettigheter",
    "XEU" to "europeisk valutaenhet",
    "XFO" to "franske gullfranc",
    "XFU" to "franske UIC-franc",
    "XOF" to "vestafrikanske CFA-franc",
    "XPD" to "palladium",
    "XPF" to "CFP-franc",
    "XPT" to "platina",
    "XRE" to "RINET-fond",
    "XSU" to "sucre",
    "XTS" to "testvalutakode",
    "XUA" to "ADB-kontoenhet",
    "XXX" to "ukjent valuta",
    "YDD" to "jemenittiske dinarer",
    "YER" to "jemenittiske rialer",
    "YUD" to "jugoslaviske dinarer (hard)",
    "YUM" to "jugoslaviske noviy-dinarer",
    "YUN" to "jugoslaviske konvertible dinarer",
    "YUR" to "jugoslaviske reformerte dinarer (1992–1993)",
    "ZAL" to "sørafrikanske rand (finansielle)",
    "ZAR" to "sørafrikanske rand",
    "ZMK" to "zambiske kwacha (1968–2012)",
    "ZMW" to "zambiske kwacha",
    "ZRN" to "zairiske nye zaire",
    "ZRZ" to "zairiske zaire",
    "ZWD" to "zimbabwiske dollar (1980–2008)",
    "ZWL" to "zimbabwisk dollar (2009)",
    "ZWR" to "zimbabwisk dollar (2008)",
  ) }

  val nqo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "ߊߙߊߓߎߟߊ߫ ߡߊ߲߬ߛߊ߬ߙߋ߬ߠߊ ߟߊߘߍ߬ߣߍ߲ ߘߌ߬ߙߑߤߊߡ",
    "AFN" to "ߊߝߎߜ߭ߊߣߌߛߑߕߊ߲߫ ߊߝߑߜ߭ߊߣߌߛ",
    "ALL" to "ߊߟߑߓߊߣߌ߫ ߟߍߞ",
    "AMD" to "ߊߙߑߡߋߣߌ߫ ߘߌ߬ߙߑߤߊߡ",
    "ANG" to "ߞߎߙߊߛߊߥߏ߫ ߊ߲ߕߌ߫ ߝߑߟߏߙߌ߲ߛ",
    "AOA" to "ߊ߲ߜ߭ߏߟߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߊ߲ߖ߭ߊ",
    "AOK" to "ߊ߲ߜ߭ߏߟߊ߫ ߞߎߥߊ߲ߖ߭ߊ ( ߁߉߇߇–߁߉߉߀ )",
    "AON" to "ߊ߲ߜ߭ߏߟߊ߫ ߞߎߥߊߖ߭ߊ߫ ߞߎߘߊ ( ߁߉߉߀–߂߀߀߀ )",
    "AOR" to "ߊ߲ߜ߭ߏߟߊ߫ ߞߎߥߊߖ߭ߊ ߝߊ߲߬ߞߊߘߏ߲߬ߣߍ߲ ( ߁߉߉߅–߁߉߉߉ )",
    "ARS" to "ߊߙߑߖ߭ߊ߲ߕߌ߲߫ ߔߋߛߏ",
    "AUD" to "ߐߛߑߕߙߊߟߌ߫ ߘߟߊ",
    "AWG" to "ߊߙߎߓߊ߫ ߝߑߟߏߙߌ߲ߛ",
    "AZN" to "ߊߖߍߙߑߓߊߦߌߖߊ߲߫ ߊߗ߭ߋߙߌ",
    "BAM" to "ߓߐߛߑߣߌ߫ ߍߙߑߗ߭ߋߜ߭ߏߝ߭ߌߣ ߡߊߙߞ ߝߊ߬ߟߋ߲߬ߕߊ",
    "BBD" to "ߓߊߙߑߓߊߘߐߛ ߘߟߊ",
    "BDT" to "ߓߊ߲ߜ߭ߑߟߊߘߍߛ ߕߞߊ",
    "BGN" to "ߓߎ߳ߟߑߜ߭ߊߙߌ߫ ߟߍߝ߭",
    "BHD" to "ߓߤߊ߬ߙߊߦߌߣ ߘߌ߬ߣߊߙ",
    "BIF" to "ߓߎߙߎ߲ߘߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲",
    "BMD" to "ߓߍߙߑߡߎߘߊ߫ ߘߟߊ",
    "BND" to "ߓߙߎߣߌ߫ ߘߟߊ",
    "BOB" to "ߓߏߟߝ߭ߌ߫ ߓߏߟߝ߭ߌߦߊߣߏ߬",
    "BRL" to "ߓߙߋߖ߭ߌߟ ߙߋߦߊߟ",
    "BSD" to "ߓߤߊߡߊߛ ߘߟߊ",
    "BTN" to "ߓߎߕߊ߲߫ ߒߜ߭ߎߟߑߕߙߎߡ",
    "BWP" to "ߓߐߛߎߥߣߊߞߊ ߟߎ߬ ߟߊ߫ ߔߎߟߊ",
    "BYN" to "ߓߌߟߏߙߌߛ ߙߓߎߟ",
    "BZD" to "ߓߙߋߖ߭ߌߟ ߘߟߊ",
    "CDF" to "ߞߏ߲߬ߜ߭ߏ߬ߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲",
    "CHF" to "ߛߎߥߌߛ ߝߊߙߊ߲",
    "CLP" to "ߛ߭ߟߌ߫ ߔߋߛߏ",
    "CNH" to "ߛߌߣ ߦߎߥߊߣ (ߝߊ߲߬ߕߙߊ ߖߌߘߊ)",
    "CNY" to "ߦߎߥߊߣ ߙߊ߲ߡߌ߲ߓߌ߫",
    "COP" to "ߞߐߟߐ߲ߓߌ߫ ߔߋߛߏ",
    "CRC" to "ߞߐߛߑߕߊߙߌߞߊ߫ ߞߐߟߐߣ",
    "CUC" to "ߞߎ߳ߓߊ߫ ߔߋߛߏ߫ ߝߊ߬ߟߋ߲߬ߕߊ",
    "CUP" to "ߞߎ߳ߓߊ߫ ߔߋߛߏ߫߫",
    "CVE" to "ߜߙߋߞߎ߲߫ ߝߙߌߛߌߞߊ ߟߎ߬ ߍߛߑߞߎߘߐߛ",
    "CZK" to "ߗߋߞߏߛߟߏߝ߭ߊߞߌ߫ ߞߎߙߐߣ",
    "DJF" to "ߖߌߓߎߕߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲",
    "DKK" to "ߘߊߣߌߡߊߙߞ ߞߎߙߐߣ",
    "DOP" to "ߘߏߡߣߌߞ ߞߊ߲ߓߍ߲ ߔߋߛߏ",
    "DZD" to "ߊߟߌߖ߭ߋߙߌߞߊ ߟߎ߬ ߟߊ߫ ߘߌ߬ߣߊ߯ߙߌ",
    "EGP" to "ߡߌߛߌߙߊ߲ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬",
    "ERN" to "ߋߙߌߕߙߋߞߊ ߟߎ߬ ߟߊ߫ ߣߊߝߑߞߊ",
    "ETB" to "ߋߗߏߔߌߞߊ ߟߎ߬ ߟߊ߫ ߓߌߙߑߛ",
    "EUR" to "ߋߙߏ",
    "FJD" to "ߝߖߌ߫ ߘߟߊ",
    "FKP" to "ߝߊߟߞߑߟߊ߲ߘ ߌߛߑߟߊ߲ߘ ߔߐߣߌ߬",
    "GBP" to "ߡߊ߬ߛߊ߬ߟߊ߫-ߘߍ߬ߣߍ߲ ߔߐߣߌ߬",
    "GEL" to "ߖ߭ߐߙߑߖߌ߫ ߟߊߙߌ",
    "GHC" to "ߛߘߌ",
    "GHS" to "ߜ߭ߊ߯ߣߊ߫ ߛߘߌ",
    "GIP" to "ߖ߭ߌߓߑߙߊߟߑߕߊ߫ ߔߐߣߌ߬",
    "GMD" to "ߜ߭ߊ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߘߟߊߛߌ߫",
    "GNF" to "ߖߌ߬ߣߍ߬ߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲",
    "GNS" to "ߖߌ߬ߣߍ߬ߞߊ ߟߎ߬ ߟߊ߫ ߛߟߌ",
    "GQE" to "ߕߍߡߊߓߊ߲߮ ߖߌ߬ߣߍ߬ߞߊ ߟߎ߬ ߟߊ߫ ߋߞߥߋߟߋ",
    "GTQ" to "ߜ߭ߎߥߊߕߋߡߟߊ߫ ߞߋߕߑߗ߭ߊߟ",
    "GWE" to "ߖߌߣߍ߫ ߓߌߛߊߥߏߞߊ ߟߎ߬ ߟߊ߫ ߍߛߑߞߎߘߐߛ",
    "GWP" to "ߖߌߣߍ߫ ߓߌߛߊߥߏߞߊ ߟߎ߬ ߟߊ߫ ߔߋߖ߭ߏ",
    "GYD" to "ߜ߭ߎ߳ߦߊߣ ߘߟߊ",
    "HKD" to "ߤߐ߲ߞߐ߲߫ ߘߟߊ",
    "HNL" to "ߤߐ߲ߘߎߙߊ߫ ߟߋ߲ߔߌߙߊ",
    "HRK" to "ߞߙߏߥߊߛߌ߫ ߞߎߣߊ߬",
    "HTG" to "ߤߊߦߕߌ߫ ߜ߭ߎߙߑߘ",
    "HUF" to "ߢߐ߲ߜ߭ߙߌ߫ ߝߏߙߍ߲ߕ",
    "IDR" to "ߍ߲ߘߣߏߛߌ߫ ߙߎߔߌ",
    "ILS" to "ߌߛߑߙߊߍߟ ߛߌߞߍߟ ߞߎߘߊ",
    "INR" to "ߤߌ߲ߘߎ߬ ߙߎߔߌ",
    "IQD" to "ߌߙߊߞߌ߬ ߘߌ߬ߣߊߙ",
    "IRR" to "ߌߙߊ߲߫ ߙߌ߬ߦߊߟ",
    "ISK" to "ߌߛߑߟߊ߲ߘ ߞߎߙߐߣ",
    "JMD" to "ߖߡߊߦߌߞ ߘߟߊ",
    "JOD" to "ߖߐߙߑߘߊߣߌ߫ ߘߌ߬ߣߊߙ",
    "JPY" to "ߣߌߔߐ߲߫ ߦߍߣ",
    "KES" to "ߝߋߣߌߦߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭",
    "KGS" to "ߞߌߙߜ߭ߌߛߑߕߊ߲߫ ߛߐߡ",
    "KHR" to "ߞߊ߲ߓߐߘߑߖ ߙߌߦߍߟ",
    "KMF" to "ߞߐߡ߲߯ߙߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲",
    "KPW" to "ߞߐ߬ߘߎ߮-ߞߏߙߋ߫ ߥߐߣ",
    "KRW" to "ߥߙߏ߬ߘߎ߮-ߞߏߙߋ߫ ߥߐߣ",
    "KWD" to "ߞߎ߬ߥߍߕ ߘߌ߬ߣߊߙ",
    "KYD" to "ߞߊߦߌߡߊ߲߫ ߌߛߑߟߊ߲ߘ ߘߟߊ",
    "KZT" to "ߞߗ߭ߊߞߌߛߑߕߊ߲߫ ߕߊ߲ߖ߭",
    "LAK" to "ߟߊߏߕߌ߫ ߞߌߔ",
    "LBP" to "ߟߌߓߊ߲߫ ߔߐߣߌ߬",
    "LKR" to "ߛߙߌ߫ ߟߊ߲ߞߊ߫ ߙߎߔߌ",
    "LRD" to "ߟߌߓߋߙߌߦߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊߙ",
    "LSL" to "ߟߋߛߕߏߞߊ ߟߎ߬ ߟߊ߫ ߟߏߕߌ",
    "LYD" to "ߟߓߌ߫ ߘߌ߬ߣߊ߯ߙ",
    "MAD" to "ߡߊ߬ߙߐߞߎ߬ ߘߌ߬ߙߑߤߊߡ",
    "MAF" to "ߡߊ߬ߙߐ߬ߞߎߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲",
    "MDL" to "ߝߐߟߑߘߊߝ߭ߌ߫ ߟߋ߳",
    "MGA" to "ߡߘߊߜ߭ߊߛߑߞߊ߯ߙߌߞߊ ߟߎ߬ ߟߊ߫ ߊߙߌߦߊߙߌ",
    "MGF" to "ߡߘߊߜ߭ߊߑߞߊ߯ߙߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲",
    "MKD" to "ߡߊߛߋߘߏߣߌ߫ ߘߋߣߊߙ",
    "MLF" to "ߡߊߟߌߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲",
    "MMK" to "ߡߌߦߊ߲ߡߊߙ ߞߌߦߊߕ",
    "MNT" to "ߡߐ߲ߜ߭ߐߟߌ߫ ߕߎߜ߭ߙߌߞ",
    "MOP" to "ߡߞߊߥߏ߫ ߔߕߊߞߊ߫",
    "MRO" to "ߡߏߙߌߕߊߣߌߞߊ ߟߎ߬ ߟߊ߫ ߎ߬ߜ߭ߌߦߊ ( ߁߉߇߃–߂߀߁߇ )",
    "MRU" to "ߡߏߙߌߕߊߣߌߞߊ ߟߎ߬ ߟߊ߫ ߎ߬ߜ߭ߌߦߊ",
    "MUR" to "ߡߏߙߛߌߞߊ ߟߎ߬ ߟߊ߫ ߙߔߎ",
    "MVR" to "ߡߊߟߑߘߝ߭ߌ߫ ߙߎߝߌߦߊ",
    "MWK" to "ߡߟߊߥߌߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߛߊ",
    "MXN" to "ߡߍߞߑߛߌߞ ߔߋߛߏ",
    "MYR" to "ߡߊߟߍߘߎ߯ ߙߌ߲ߖ߭ߌ",
    "MZE" to "ߡߏߖ߭ߊ߲ߓߞߌߞߊ ߟߎ߬ ߟߊ߫ ߍߛߑߞߎߘߏߛ",
    "MZM" to "ߡߏߖ߭ߊ߲ߓߞߌߞߊ ߟߎ߬ ߟߊ߫ ߡߋߕߌߞ ( ߁߉߈߀–߂߀߀߆ )",
    "MZN" to "ߡߏߖ߭ߊ߲ߓߞߌߞߊ ߟߎ߬ ߟߊ߫ ߡߋߕߌߞߊߟ",
    "NAD" to "ߣߊߡߌ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ",
    "NGN" to "ߖߋ߬ߟߌ߬ߓߊ߬ߞߊ ߟߎ߬ ߟߊ߫ ߣߍߙߊ",
    "NIO" to "ߣߌߞߙߊߜ߭ߎߥߊ߫ ߞߐߙߑߘߏߓߊ߫ ߏߙߏ߫",
    "NOK" to "ߣߐߙߑߝ߭ߍߛ ߞߎߙߐߣ",
    "NPR" to "ߣߋߔߊߟ ߙߎߔߌ",
    "NZD" to "ߣߌߦߎߖ߭ߌߟߊ߲ߘߌ߫ ߘߟߊ",
    "OMR" to "ߏߡߊߣ ߙߌ߬ߦߊߟ",
    "PAB" to "ߔߣߊߡߊ߫ ߓߊߟߑߓߏߥߊ߫",
    "PEN" to "ߔߋߙߎ߫ ߛߐߟ",
    "PGK" to "ߔߊߔߎߥߊ߫ ߖߌ߬ߣߍ߬ ߞߎߘߊ߫ ߞߌߣߊ",
    "PHP" to "ߝߟߌߔߌߣ ߔߋߛߏ",
    "PKR" to "ߔߊߞߌߛߑߕߊ߲߫ ߙߎߔߌ",
    "PLN" to "ߔߏߟߐߢ ߗ߭ߑߟߏߕߌ߫",
    "PYG" to "ߔߙߊߜ߭ߏߦߋ߫ ߜ߭ߎߙߊߣߊߛ",
    "QAR" to "ߞߕߊߙ ߙߌ߬ߦߊߟ",
    "RHD" to "ߖ߭ߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ",
    "RON" to "ߙߎߡߊߣߌ߫ ߟߋ߳",
    "RSD" to "ߛߍߙߑߓߌ߫ ߘߋߣߊߙ",
    "RUB" to "ߌ߬ߙߌ߬ߛߌ߫ ߙߎߓߎߟ",
    "RWF" to "ߙߎߥߊ߲ߘߞߊ ߟߎ߬ ߟߊ߫ ߝߊߙߊ߲",
    "SAR" to "ߛߎ߰ߘߎ߬ߟߊ߫ ߙߌ߬ߦߊߟ",
    "SBD" to "ߛߟߏ߬ߡߣߊ߬ ߕߌ߲ ߠߎ߬ ߘߟߊ",
    "SCR" to "ߛߋߦߌߛߍߟߌߞߊ ߟߎ߬ ߟߊ߫ ߙߎߔߌ",
    "SDD" to "ߛߎ߬ߘߊ߲߬ߞߊ ߟߎ߬ ߘߌ߬ߣߊ߯ߙ ( ߁߉߉߂–߂߀߀߇ )",
    "SDG" to "ߛߎߘߊ߲ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬",
    "SDP" to "ߛߎ߬ߘ߲ߊ߬ߞߊ ߟߊ߫ ߔߐߣߌ߬ ( ߁߉߅߆–߂߀߀߇ )",
    "SEK" to "ߛߎߥߍߘ ߞߎߙߐߣ",
    "SGD" to "ߛߍ߲ߜ߭ߊߔߎߙ ߘߟߊ",
    "SHP" to "ߛߍ߲ߕ ߤߌߟߋߣߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬",
    "SLE" to "ߛߙߊ߬ߟߏ߲߬ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬",
    "SLL" to "ߛߙߊ߬ߟߏ߲߬ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬ - 1964-2022",
    "SOS" to "ߛߏߡߊߟߌߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭",
    "SRD" to "ߛߎߙߌߣߊߡߍߛ ߘߟߊ",
    "SSP" to "ߛߎ߬ߘߊ߲߬ߞߊ ߟߎ߬ ߟߊ߫ ߔߐߣߌ߬",
    "STD" to "ߛߊߏߕߏߡߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߓߙߊߛ ( ߁߉߇߇– ߂߀߁߇ )",
    "STN" to "ߛߊߏߕߏߡߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߓߙߊߛ",
    "SYP" to "ߛߌ߯ߙߌ߫ ߔߐߣߌ߬",
    "SZL" to "ߛߑߥߊߕߣߞߊ ߟߎ߬ ߟߌߟߊ߲ߖ߭ߋߣߌߛ",
    "THB" to "ߕߊߦߌߘߎ߯ ߓߊߘ",
    "TJS" to "ߕߊߖߞߌߛߑߕߊ߲߫ ߛߡߏߣߌ",
    "TMT" to "ߕߎߙߑߞߌߡߋߣߌߛߑߕߊ߲߫ ߡߣߊ߫ ߞߎߘߊ",
    "TND" to "ߕߎߣߛߌߞߊ ߟߎ߬ ߟߊ߫ ߘߌ߬ߣߊ߯ߙ",
    "TOP" to "ߕߏ߲ߜ߭ߊ߲߫ ߓߊ߲ߜ߭ߊ߫",
    "TRY" to "ߕߎߙߑߞߌ߫ ߟߌߙߊ߬",
    "TTD" to "ߕߙߌߘߊߘ ߣߌ߫ ߕߏߓߊߜ߭ߏ߫ ߘߟߊ",
    "TWD" to "ߕߊߦߌߥߊ߲߫ ߘߟߊ߫ ߞߎߘߊ",
    "TZS" to "ߕߊ߲ߖ߭ߊ߯ߣߌߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭",
    "UAH" to "ߌߞߑߙߍߣ ߤߙߌߝ߭ߣߌߦߊߛ",
    "UGS" to "ߎߜ߭ߊ߲ߘߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭ ( ߁߉߆߆–߁߉߈߇ )",
    "UGX" to "ߎߜ߭ߊ߲ߘߞߊ ߟߎ߬ ߟߊ߫ ߛߌߟߌ߲ߜ߭",
    "USD" to "ߊߡߋߙߌߞߌ߬߬ ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲ ߘߟߊ",
    "UYU" to "ߎ߳ߜ߭ߋߦߌ߫ ߔߋߛߏ",
    "UZS" to "ߎߗ߭ߑߓߋߞߌߛߑߕߊ߲߫ ߛߎߡ",
    "VES" to "ߝ߭ߣߋߗ߭ߎߦߋߟߊ߫ ߓߏߟߌߝ߭ߊߙ",
    "VND" to "ߝ߭ߌߦߍߕߑߣߊߡ ߘߐ߲ߜ߭",
    "VUV" to "ߝ߭ߊߣߎߦߊߕߎ߫ ߝ߭ߊߕߎ",
    "WST" to "ߛߊߡߏߥߊ߲߫ ߕߟߊ",
    "XAF" to "ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߊ߲ߓߊ߲ ߠߎ߬ ߝߊߙߊ߲߫ ߛߍߝߊ",
    "XCD" to "ߛߍߕ ߟߎߛߌߦߊ߫",
    "XOF" to "ߝߊߙߊ߲߫ ߛߍߝߊ",
    "XPF" to "ߝߑߙߊ߲߫ ߛߍߝߊ",
    "XXX" to "ߝߊ߬ߘߊ߲߬ߞߊ߫ ߟߐ߲ߓߊߟߌ",
    "YER" to "ߦߡߊߣߌ߲߫ ߙߌ߬ߦߊߟ",
    "ZAR" to "ߥߙߏ߬ߘߎ߮ ߝߘߊ߬ߝߌ߲߬ߠߞߊ ߟߎ߬ ߟߊ߫ ߙߊ߲ߘ",
    "ZMK" to "ߖ߭ߊ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߛߊ ( ߁߉߆߈–߂߀߁߂ )",
    "ZMW" to "ߖ߭ߊ߲ߓߌߞߊ ߟߎ߬ ߟߊ߫ ߞߎߥߛߊ",
    "ZRN" to "ߖ߭ߊ߬ߦߌ߬ߞߊ ߟߎ߬ ߟߊ߫ ߖ߭ߊ߬ߦߌߙ ( ߁߉߉߃–߁߉߉߈ )",
    "ZRZ" to "ߖ߭ߊߦߙߌߞߊ ߟߎ߫ ߟߊ߫ ߖ߭ߊ߬ߦߌߙ ( ߁߉߇߁–߁߉߉߃ )",
    "ZWD" to "ߖߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ (߁߉߈߀–߂߀߀߈ )",
    "ZWL" to "ߖ߭ߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ ( ߂߀߀߉ )",
    "ZWR" to "ߖ߭ߌ߲ߓߊߓߏߦߋߞߊ ߟߎ߬ ߟߊ߫ ߘߏߟߊ߯ߙ ( ߂߀߀߈ )",
  ) }

  val nr: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nso: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nus: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nv: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ny: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val nyn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Dirham za Buharabu",
    "AOA" to "Kwanza ya Angora",
    "AUD" to "Doora ya Austureeriya",
    "BHD" to "Dinari ya Bahareni",
    "BIF" to "Faranga ya Burundi",
    "BWP" to "Pura ya Botswana",
    "CAD" to "Doora ya Kanada",
    "CDF" to "Faranga ya Kongo",
    "CHF" to "Faranga ya Swisi",
    "CNY" to "Yuan Renminbi ya China",
    "CVE" to "Eskudo ya Kepuvede",
    "DJF" to "Faranga ya Gyibuti",
    "DZD" to "Dinari ya Arigyeriya",
    "EGP" to "Paundi ya Misiri",
    "ERN" to "Nakfa ya Eritireya",
    "ETB" to "Birr ya Ethiopiya",
    "EUR" to "Yuro",
    "GBP" to "Paundi ya Bungyereza",
    "GHC" to "Cedi ya Ghana",
    "GMD" to "Dalasi ya Gambia",
    "GNS" to "Faranga ya Guinea",
    "INR" to "Rupiya ya India",
    "JPY" to "Yeni ya Japaani",
    "KES" to "Shiringi ya Kenya",
    "KMF" to "Faranga ya Komoro",
    "LRD" to "Doora ya Liberia",
    "LSL" to "Loti ya Lesoto",
    "LYD" to "Dinari ya Libya",
    "MAD" to "Dirram ya Moroko",
    "MGA" to "Ariari ya Maragariita",
    "MRO" to "Ougwiya ya Mouriteeniya (1973–2017)",
    "MRU" to "Ougwiya ya Mouriteeniya",
    "MUR" to "Rupiiha ya Mauritiasi",
    "MWK" to "Kwaca ya Malawi",
    "MZM" to "Metikari ya Mozambikwi",
    "NAD" to "Doora ya Namibiya",
    "NGN" to "Naira ya Naigyeriya",
    "RWF" to "Faranga ya Rwanda",
    "SAR" to "Riya ya Saudi",
    "SCR" to "Rupiiha ya Sherisheri",
    "SDG" to "Dinari ya Sudani",
    "SDP" to "Paundi ya Sudan",
    "SHP" to "Paundi ya Senti Herena",
    "SLE" to "Leone",
    "SLL" to "Leone (1964—2022)",
    "SOS" to "Eshiringi ya Somalia",
    "STD" to "Dobra ya Sao Tome na Purinsipo (1977–2017)",
    "STN" to "Dobra ya Sao Tome na Purinsipo",
    "SZL" to "Lilangeni",
    "TND" to "Dinari ya Tunisia",
    "TZS" to "Eshiringi ya Tanzania",
    "UGX" to "Eshiringi ya Uganda",
    "USD" to "Doora ya America",
    "XAF" to "Faranga ya CFA BEAC",
    "XOF" to "Faranga ya CFA BCEAO",
    "ZAR" to "Randi ya Sausi Afirika",
    "ZMK" to "Kwacha ya Zambia (1968–2012)",
    "ZMW" to "Kwacha ya Zambia",
    "ZWD" to "Doora ya Zimbabwe",
  ) }

  val oc: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val oc_ES: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val om: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BMD" to "Doolaara Beermudaa",
    "BRL" to "Brazilian Real",
    "BZD" to "Doolaara Beliizee",
    "CAD" to "Doolaara Kanaadaa",
    "CNY" to "Chinese Yuan Renminbi",
    "CRC" to "Koloonii Kostaa Rikaa",
    "ETB" to "Itoophiyaa Birrii",
    "EUR" to "Euro",
    "GBP" to "British Pound",
    "INR" to "Indian Rupee",
    "JPY" to "Japanese Yen",
    "RUB" to "Russian Ruble",
    "USD" to "Doolaara Ameerikaa",
  ) }

  val om_KE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val or: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "ଯୁକ୍ତ ଆରବ ଏମିରେଟସ୍ ଦିରହାମ୍",
    "AFN" to "ଆଫଗାନ ଆଫଗାନି",
    "ALL" to "ଆଲବାନିୟ ଲେକ୍",
    "AMD" to "ଅର୍ମେନୀୟ ଡ୍ରାମ୍",
    "ANG" to "ନେଦରଲ୍ୟାଣ୍ଡ୍ ଆଣ୍ଟିଲିୟ ଗିଲଡର୍",
    "AOA" to "ଅଙ୍ଗୋଲୀୟ କୱାନଜା",
    "ARS" to "ଆର୍ଜେଣ୍ଟାଇନ୍‍ ପେସୋ",
    "AUD" to "ଅଷ୍ଟ୍ରେଲିୟ ଡଲାର୍",
    "AWG" to "ଆରୁବୀୟ ଫ୍ଲୋରିନ୍",
    "AZN" to "ଆଜେରବାଇଜାନି ମନତ୍",
    "BAM" to "ବୋସନିଆ-ହର୍ଜଗୋଭିନା କନଭର୍ଟିବଲ୍ ମାର୍କ୍",
    "BBD" to "ବାର୍ବାଡୀୟ ଡଲାର୍",
    "BDT" to "ବଙ୍ଗଳାଦେଶୀ ଟାକା",
    "BGN" to "ବୁଲଗେରୀୟ ଲେଭ୍",
    "BHD" to "ବାଃରେନି ଦିନାର୍",
    "BIF" to "ବୁରୁଣ୍ଡିୟ ଫ୍ରାଙ୍କ୍",
    "BMD" to "ବର୍ମ୍ୟୁଡା ଡଲାର୍",
    "BND" to "ବ୍ରୁନେଇ ଡଲାର୍",
    "BOB" to "ବୋଲିଭୀୟ ବୋଲିଭିଆନୋ",
    "BRL" to "ବ୍ରାଜିଲୀୟ ରିଏଲ୍",
    "BSD" to "ବାହାମୀୟ ଡଲାର୍",
    "BTN" to "ଭୁଟାନୀ ଗଲଟ୍ରୁମ୍",
    "BWP" to "ବୋତ୍ସୱାନା ପୁଲା",
    "BYN" to "ବେଲାରୁସି ରୁବଲ୍",
    "BZD" to "ବେଲିଜ୍ ଡଲାର୍",
    "CAD" to "କାନେଡିୟ ଡଲାର୍",
    "CDF" to "କଙ୍ଗୋଲିଜ୍ ଫ୍ରାଙ୍କ୍",
    "CHF" to "ସୁଇସ୍ ଫ୍ରାଙ୍କ୍",
    "CLP" to "ଚିଲି ପେସୋ",
    "CNH" to "ଚିନୀ ୟୁଆନ୍ (ଅଫସୋର୍)",
    "CNY" to "ଚିନୀ ୟୁଆନ୍",
    "COP" to "କଲୋମ୍ବୀୟ ପେସୋ",
    "CRC" to "କୋଷ୍ଟା ରିକୀୟ କୋଲୋନ୍",
    "CUC" to "କ୍ୟୁବାନ୍ କନଭର୍ଟିବଲ୍ ପେସୋ",
    "CUP" to "କ୍ୟୁବାନ୍ ପେସୋ",
    "CVE" to "କେପ୍ ଭେର୍ଦେୟ ଏସ୍କୁଡୋ",
    "CZK" to "ଚେକ୍ କୋରୁନା",
    "DJF" to "ଜିବୌଟିୟ ଫ୍ରାଙ୍କ୍",
    "DKK" to "ଡାନିସ୍ କ୍ରୋନ୍",
    "DOP" to "ଡୋମିନିକୀୟ ପେସୋ",
    "DZD" to "ଆଲଜେରୀୟ ଦିନାର୍",
    "EGP" to "ଇଜିପ୍ଟିୟ ପାଉଣ୍ଡ୍",
    "ERN" to "ଏରିଟ୍ରେୟ ନାକଫା",
    "ETB" to "ଇଥିଓପିୟ ବିର୍",
    "EUR" to "ୟୁରୋ",
    "FJD" to "ଫିଜି ଡଲାର୍",
    "FKP" to "ଫକଲ୍ୟାଣ୍ଡ୍ ଦ୍ଵୀପପୁଞ୍ଜ ପାଉଣ୍ଡ୍",
    "GBP" to "ବ୍ରିଟିଶ୍ ପାଉଣ୍ଡ୍",
    "GEL" to "ଜର୍ଜିୟ ଲାରି",
    "GHS" to "ଘାନିୟ ସେଡି",
    "GIP" to "ଗିବ୍ରାଲଟର୍ ପାଉଣ୍ଡ୍",
    "GMD" to "ଗାମ୍ବିୟ ଡାଲାସି",
    "GNF" to "ଗୁଇନେୟ ଫ୍ରାଙ୍କ୍",
    "GTQ" to "ଗୁଏଟମାଲୀୟ କ୍ଵେତଜାଲ୍",
    "GYD" to "ଗାୟାନିସ୍ ଡଲାର୍",
    "HKD" to "ହଂ କଂ ଡଲାର୍",
    "HNL" to "ହୋଣ୍ଡୁରୀୟ ଲେମପିରା",
    "HRK" to "କ୍ରୋଏସୀୟ କୁନା",
    "HTG" to "ହାଇତୀୟ ଗୋରଡ୍",
    "HUF" to "ହଙ୍ଗେରିୟ ଫୋରିଣ୍ଟ୍",
    "IDR" to "ଇଣ୍ଡୋନେସିୟ ରୁପିଆ",
    "ILS" to "ଇସ୍ରାଇଲି ନ୍ୟୁ ଶେକେଲ୍",
    "INR" to "ଭାରତୀୟ ଟଙ୍କା",
    "IQD" to "ଇରାକି ଦିନାର୍",
    "IRR" to "ଇରାନୀ ରିଆଲ୍",
    "ISK" to "ଆଇସଲ୍ୟାଣ୍ଡିକ୍‍ କ୍ରୋନା",
    "JMD" to "ଜାମାଇକୀୟ ଡଲାର୍",
    "JOD" to "ଜର୍ଡାନିୟ ଦିନାର୍",
    "JPY" to "ଜାପାନୀ ୟେନ୍",
    "KES" to "କେନିୟ ଶିଲିଂ",
    "KGS" to "କିର୍ଗିସ୍ତାନୀ ସୋମ୍",
    "KHR" to "କାମ୍ଵୋଡିୟ ରିଏଲ୍",
    "KMF" to "କୋମୋରୀୟ ଫ୍ରାଙ୍କ୍",
    "KPW" to "ଉତ୍ତର କୋରିଆଇ ୱୋନ୍",
    "KRW" to "ଦକ୍ଷିଣ କୋରିଆଇ ୱୋନ୍",
    "KWD" to "କୁୱେତି ଦିନାର୍",
    "KYD" to "କେମେନ୍ ଦ୍ଵୀପପୁଞ୍ଜ ଡଲାର୍",
    "KZT" to "କାଜାକସ୍ତାନୀ ତେଙ୍ଗେ",
    "LAK" to "ଲାଓଟିୟ କିପ୍",
    "LBP" to "ଲେବାନିଜ୍ ପାଉଣ୍ଡ୍",
    "LKR" to "ଶ୍ରୀଲଙ୍କିୟ ରୁପି",
    "LRD" to "ଲିବେରୀୟ ଡଲାର୍",
    "LSL" to "ଲେସୋଥୋ ଲୋଟି",
    "LYD" to "ଲିବ୍ୟ ଦିନାର୍",
    "MAD" to "ମୋରୋକୀୟ ଦିର୍ହାମ୍",
    "MDL" to "ମୋଲଡୋଭାନ୍ ଲେୟୁ",
    "MGA" to "ମାଲାଗାସି ଏରିଆରୀ",
    "MKD" to "ମାସେଡୋନୀୟ ଡିନର୍",
    "MMK" to "ମ୍ୟାନମାର୍ କ୍ୟାତ୍‌",
    "MNT" to "ମଙ୍ଗୋଲିୟ ତୁଗ୍ରିକ୍",
    "MOP" to "ମାକାନେଜ୍ ପାଟାକା",
    "MRO" to "ମର୍ଟିନିୟ ଆଗୁଇଅ (1973–2017)",
    "MRU" to "ମର୍ଟିନିୟ ଆଗୁଇଅ",
    "MUR" to "ମୌରିସୀୟ ରୁପି",
    "MVR" to "ମାଲଡିଭିୟ ରୁଫିୟା",
    "MWK" to "ମଲାୱି କ୍ୱାଚା",
    "MXN" to "ମେକ୍ସିକୀୟ ପେସୋ",
    "MYR" to "ମାଲେସିୟ ରିଙ୍ଗିଟ୍",
    "MZN" to "ମୋଜାମ୍ବିକୀୟ ମେଟିକାଲ୍",
    "NAD" to "ନାମିବିୟ ଡଲାର୍",
    "NGN" to "ନାଇଜେରିଆଇ ନାଇରା",
    "NIO" to "ନିକାରାଗୁଆ କୋର୍ଡୋବା",
    "NOK" to "ନରୱେୟୀୟ କ୍ରୋନ୍",
    "NPR" to "ନେପାଳି ରୁପି",
    "NZD" to "ନ୍ୟୁଜିଲ୍ୟାଣ୍ଡ୍ ଡଲାର୍",
    "OMR" to "ଓମାନି ରିଆଲ୍",
    "PAB" to "ପାନାମାନିୟ ବାଲବୋଆ",
    "PEN" to "ପେରୁଭୀୟ ସୋଲ୍",
    "PGK" to "ପପୁଆ ନ୍ୟୁ ଗୁଇନିୟ କିନା",
    "PHP" to "ଫିଲିପିନି ପେସୋ",
    "PKR" to "ପାକିସ୍ତାନୀ ରୁପି",
    "PLN" to "ପୋଲିଶ୍ ଜ୍ଲଟୀ",
    "PYG" to "ପାରାଗୁଆୟାନ୍ ଗୁଆରାନି",
    "QAR" to "କ୍ଵାତାରି ରିଆଲ୍",
    "RON" to "ରୋମାନିୟ ଲେଉ",
    "RSD" to "ସର୍ବିଆଇ ଦିନାର",
    "RUB" to "ରୁଷି ରୁବଲ୍",
    "RWF" to "ରୁୱାଣ୍ଡା ଫ୍ରାଙ୍କ୍",
    "SAR" to "ସୌଦି ରିୟାଲ୍",
    "SBD" to "ସୋଲୋମୋନ୍ ଦ୍ଵୀପପୁଞ୍ଜ ଡଲାର୍",
    "SCR" to "ସେୟଚେଲୋଇସ୍ ରୁପି",
    "SDG" to "ସୁଦାନୀଜ ପାଉଣ୍ଡ୍",
    "SEK" to "ସ୍ୱେଡିଶ୍ କ୍ରୋନା",
    "SGD" to "ସିଙ୍ଗାପୁର୍ ଡଲାର୍",
    "SHP" to "ସେଣ୍ଟ୍. ହେଲେନା ପାଉଣ୍ଡ୍",
    "SLE" to "ସିଏରା ଲିଓନୀୟ ଲେଓନ୍",
    "SLL" to "ସିଏରା ଲିଓନୀୟ ଲେଓନ୍ (1964—2022)",
    "SOS" to "ସୋମାଲି ସିଲିଂ",
    "SRD" to "ସୁରିନାମିଜ୍ ଡଲାର୍",
    "SSP" to "ଦକ୍ଷିଣ ସୁଡାନିଜ୍‍ ପାଉଣ୍ଡ୍",
    "STD" to "ସାଓ ତୋମେ & ପ୍ରିସିପ୍ ଡୋବ୍ରା (1977–2017)",
    "STN" to "ସାଓ ତୋମେ & ପ୍ରିସିପ୍ ଡୋବ୍ରା",
    "SYP" to "ସିରିୟ ପାଉଣ୍ଡ୍",
    "SZL" to "ସ୍ଵାଜି ଲିଲାଞ୍ଜେନି",
    "THB" to "ଥାଇ ଭାଟ୍",
    "TJS" to "ତାଜିକିସ୍ତାନୀ ସୋମୋନି",
    "TMT" to "ତୁର୍କମେନିସ୍ତାନୀ ମନତ୍‌",
    "TND" to "ଟୁନେସିଆଇ ଦିନାର୍",
    "TOP" to "ତୋଙ୍ଗିୟ ପାଙ୍ଗା",
    "TRY" to "ତୁର୍କିୟ ଲିରା",
    "TTD" to "ତ୍ରିନିଦାଦ୍ ଏବଂ ଟୋବାଗୋ ଡଲାର୍",
    "TWD" to "ନ୍ୟୁ ତାଇୱାନ୍ ଡଲାର୍",
    "TZS" to "ତାନଜାନୀୟ ଶିଲିଂ",
    "UAH" to "ୟୁକ୍ରେନୀୟ ହ୍ରାଇଭନିଆ",
    "UGX" to "ଉଗାଣ୍ଡିୟ ଶିଲିଂ",
    "USD" to "ଯୁକ୍ତରାଷ୍ଟ୍ର ଡଲାର୍",
    "UYU" to "ଉରୁଗୁଇୟାନ୍ ପେସୋ",
    "UZS" to "ଉଜବେକିସ୍ତାନୀ ସୋମ୍",
    "VEF" to "ଭେନେଜୁଏଲାନ୍ ବୋଲିଭାର୍ (2008–2018)",
    "VES" to "ଭେନେଜୁଏଲାନ୍ ବୋଲିଭାର୍",
    "VND" to "ଭୀଏତନାମୀୟ ଡଙ୍ଗ",
    "VUV" to "ଭାନୁଆଟୁ ଭାଟୁ",
    "WST" to "ସାମୋୟିୟ ତାଲା",
    "XAF" to "ମଧ୍ୟ ଆଫ୍ରିକୀ CFA ଫ୍ରାଙ୍କ୍",
    "XCD" to "ପୂର୍ବ କାରିବୀୟ ଡଲାର୍",
    "XOF" to "ପଶ୍ଚିମ ଆଫ୍ରିକିୟ CFA ଫ୍ରାଙ୍କ୍",
    "XPF" to "CFP ଫ୍ରାଙ୍କ୍",
    "XXX" to "ଅଜଣା ମୁଦ୍ରା",
    "YER" to "ୟେମେନି ରିଆଲ୍",
    "ZAR" to "ଦକ୍ଷିଣ ଆଫ୍ରିକିୟ ରାଣ୍ଡ୍",
    "ZMW" to "ଜାମ୍ବୀୟ କ୍ୱାଚା",
  ) }

  val os: ImmutableMap<String, String> by lazy { immutableMapOf(
    "BRL" to "Бразилиаг реал",
    "EUR" to "Евро",
    "GBP" to "Бритайнаг Фунт",
    "GEL" to "Лар",
    "RUB" to "Сом",
    "USD" to "АИШ-ы Доллар",
    "XXX" to "Нӕзонгӕ валютӕ",
  ) }

  val os_RU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val osa: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val pa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ",
    "AFN" to "ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ",
    "ALL" to "ਅਲਬਾਨੀਆਈ ਲੇਕ",
    "AMD" to "ਅਰਮੀਨੀਆਈ ਦਰਾਮ",
    "ANG" to "ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ",
    "AOA" to "ਅੰਗੋਲਾ ਕਵਾਂਜਾ",
    "ARA" to "ਅਰਜਨਟੀਨੀ ਅਸਟਰਾਲ",
    "ARL" to "ਅਰਜਨਟੀਨੀ ਪੇਸੋ ਲੇ (1970–1983)",
    "ARM" to "ਅਰਜਨਟੀਨੀ ਪੇਸੋ (1881–1970)",
    "ARP" to "ਅਰਜਨਟੀਨੀ ਪੇਸੋ (1983–1985)",
    "ARS" to "ਅਰਜਨਟੀਨੀ ਪੇਸੋ",
    "AUD" to "ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ",
    "AWG" to "ਅਰੂਬਨ ਫਲੋਰਿਨ",
    "AZN" to "ਅਜ਼ਰਬਾਈਜਾਨ ਮਾਨਤ",
    "BAM" to "ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣਯੋਗ ਮਾਰਕ",
    "BBD" to "ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ",
    "BDT" to "ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ",
    "BGN" to "ਬੁਲਗਾਰੀਆਈ ਲੇਵ",
    "BHD" to "ਬਹਿਰੀਨੀ ਦਿਨਾਰ",
    "BIF" to "ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ",
    "BMD" to "ਬਰਮੂਡਾ ਡਾਲਰ",
    "BND" to "ਬਰੂਨੇਈ ਡਾਲਰ",
    "BOB" to "ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ",
    "BOL" to "ਬੋਲੀਵੀਆਈ ਬੋਲੀਵੀਅਨੋ (1863–1963)",
    "BOP" to "ਬੋਲੀਵੀਆਈ ਪੇਸੋ",
    "BOV" to "ਬੋਲੀਵੀਆਈ ਮਵਡੋਲ",
    "BRB" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਿਰੋਸ (1967–1986)",
    "BRC" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਾਡੂ (1986–1989)",
    "BRE" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ (1990–1993)",
    "BRL" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਰੀਅਲ",
    "BRN" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਾਡੂ (1989–1990)",
    "BRR" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ (1993–1994)",
    "BRZ" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ (1942–1967)",
    "BSD" to "ਬਾਹਾਮੀਅਨ ਡਾਲਰ",
    "BTN" to "ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ",
    "BWP" to "ਬੋਟਸਵਾਨਾ ਪੁਲਾ",
    "BYN" to "ਬੇਲਾਰੂਸੀ ਰੂਬਲ",
    "BYR" to "ਬੇਲਾਰੂਸੀ ਰੂਬਲ (2000–2016)",
    "BZD" to "ਬੇਲੀਜ਼ ਡਾਲਰ",
    "CAD" to "ਕੇਨੇਡਿਆਈ ਡਾਲਰ",
    "CDF" to "ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ",
    "CHF" to "ਸਵਿਸ ਫ੍ਰੈਂਕ",
    "CLP" to "ਚਿਲੀ ਪੇਸੋ",
    "CNH" to "ਚੀਨੀ ਯੁਆਨ (ਔਫ਼ਸ਼ੋਰ)",
    "CNY" to "ਚੀਨੀ ਯੁਆਨ",
    "COP" to "ਕੋਲੰਬਿਆਈ ਪੇਸੋ",
    "CRC" to "ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ",
    "CUC" to "ਕਿਊਬਨ ਬਦਲਣਯੋਗ ਪੇਸੋ",
    "CUP" to "ਕਿਊਬਨ ਪੇਸੋ",
    "CVE" to "ਕੇਪ ਵਰਡੀਅਨ ਸਕੂਡੋ",
    "CZK" to "ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ",
    "DEM" to "ਜਰਮਨ ਮਾਰਕ",
    "DJF" to "ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ",
    "DKK" to "ਡੈਨਿਸ਼ ਕਰੌਨ",
    "DOP" to "ਡੌਮਿਨਿਕਨ ਪੇਸੋ",
    "DZD" to "ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ",
    "EGP" to "ਮਿਸਰੀ ਪੌਂਡ",
    "ERN" to "ਇਰੀਟ੍ਰਿਆਈ ਨਾਫ਼ਾ",
    "ETB" to "ਇਥੋਪੀਆਈ ਬਿਰ",
    "EUR" to "ਯੂਰੋ",
    "FJD" to "ਫ਼ਿਜ਼ੀ ਡਾਲਰ",
    "FKP" to "ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪੌਂਡ",
    "GBP" to "ਬ੍ਰਿਟਿਸ਼ ਪੌਂਡ",
    "GEL" to "ਜਾਰਜੀਆਈ ਲਾਰੀ",
    "GHS" to "ਘਾਨਾਈ ਸੇਡੀ",
    "GIP" to "ਜਿਬਰਾਲਟਰ ਪੌਂਡ",
    "GMD" to "ਗੈਂਬੀਆਈ ਦਲਾਸੀ",
    "GNF" to "ਗਿਨੀ ਫ੍ਰੈਂਕ",
    "GTQ" to "ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ",
    "GYD" to "ਗੁਆਨਾਆਈ ਡਾਲਰ",
    "HKD" to "ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ",
    "HNL" to "ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ",
    "HRK" to "ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ",
    "HTG" to "ਹੈਤੀ ਗੌਰਡੇ",
    "HUF" to "ਹੰਗਰੀ ਫੋਰਿੰਟ",
    "IDR" to "ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ",
    "IEP" to "ਆਇਰਿਸ਼ ਪੌਂਡ",
    "ILP" to "ਇਜ਼ਰਾਈਲੀ ਪੌਂਡ",
    "ILS" to "ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ",
    "INR" to "ਭਾਰਤੀ ਰੁਪਇਆ",
    "IQD" to "ਇਰਾਕੀ ਦਿਨਾਰ",
    "IRR" to "ਈਰਾਨੀ ਰਿਆਲ",
    "ISK" to "ਆਈਸਲੈਂਡੀ ਕਰੋਨਾ",
    "JMD" to "ਜਮਾਇਕਨ ਡਾਲਰ",
    "JOD" to "ਜਾਰਡਨ ਦਿਨਾਰ",
    "JPY" to "ਜਪਾਨੀ ਯੇਨ",
    "KES" to "ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ",
    "KGS" to "ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ",
    "KHR" to "ਕੰਬੋਡੀਆਈ ਰੀਅਲ",
    "KMF" to "ਕੋਮੋਰੀਅਨ ਫ੍ਰੈਂਕ",
    "KPW" to "ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ",
    "KRW" to "ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ",
    "KWD" to "ਕੁਵੈਤੀ ਦਿਨਾਰ",
    "KYD" to "ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ",
    "KZT" to "ਕਜ਼ਾਖਸਤਾਨੀ ਤੇਂਗੇ",
    "LAK" to "ਲਾਓਟਿਆਈ ਕਿਪ",
    "LBP" to "ਲੈਬਨਾਨੀ ਪੌਂਡ",
    "LKR" to "ਸ੍ਰੀਲੰਕਾਈ ਰੁਪਇਆ",
    "LRD" to "ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ",
    "LSL" to "ਲੇਸੋਥੋ ਲੋਟੀ",
    "LTL" to "ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ",
    "LVL" to "ਲਾਟਵਿਆਈ ਲਾਟਸ",
    "LYD" to "ਲੀਬੀਆਈ ਦਿਨਾਰ",
    "MAD" to "ਮੋਰੱਕਨ ਦਿਰਹਾਮ",
    "MDL" to "ਮੋਲਡੋਵਨ ਲੇਉ",
    "MGA" to "ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ",
    "MKD" to "ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ",
    "MMK" to "ਮਿਆਂਮਾਰ ਕਿਆਤ",
    "MNT" to "ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ",
    "MOP" to "ਮੇਕਾਨੀ ਪਟਾਕਾ",
    "MRO" to "ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ (1973–2017)",
    "MRU" to "ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ",
    "MUR" to "ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਇਆ",
    "MVR" to "ਮਾਲਦੀਵੀ ਰੁਫੀਆ",
    "MWK" to "ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ",
    "MXN" to "ਮੈਕਸੀਕਨ ਪੇਸੋ",
    "MYR" to "ਮਲੇਸ਼ੀਆਈ ਰਿੰਗਿਟ",
    "MZN" to "ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ",
    "NAD" to "ਨਾਮੀਬੀਆਈ ਡਾਲਰ",
    "NGN" to "ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ",
    "NIO" to "ਨਿਕਾਰਾਗੁਆਈ ਕੋਰਡੋਬਾ",
    "NOK" to "ਨਾਰਵੇਜੀਆਈ ਕਰੌਨ",
    "NPR" to "ਨੇਪਾਲੀ ਰੁਪਇਆ",
    "NZD" to "ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ",
    "OMR" to "ਓਮਾਨੀ ਰਿਆਲ",
    "PAB" to "ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ",
    "PEN" to "ਪੇਰੂਵੀਅਨ ਸੋਲ",
    "PGK" to "ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕੀਨਾ",
    "PHP" to "ਫਿਲਿਪੀਨੀ ਪੇਸੋ",
    "PKR" to "ਪਾਕਿਸਤਾਨੀ ਰੁਪਇਆ",
    "PLN" to "ਪੋਲੈਂਡੀ ਜ਼ਲੌਟੀ",
    "PYG" to "ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ",
    "QAR" to "ਕਤਰੀ ਰਿਆਲ",
    "RON" to "ਰੋਮਾਨੀਆਈ ਲੇਉ",
    "RSD" to "ਸਰਬੀਆਈ ਦਿਨਾਰ",
    "RUB" to "ਰੂਸੀ ਰੂਬਲ",
    "RWF" to "ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ",
    "SAR" to "ਸਾਊਦੀ ਰਿਆਲ",
    "SBD" to "ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ",
    "SCR" to "ਸੇਸ਼ਲਸ ਰੁਪਇਆ",
    "SDG" to "ਸੂਡਾਨੀ ਪੌਂਡ",
    "SEK" to "ਸਵੀਡਿਸ਼ ਕਰੋਨਾ",
    "SGD" to "ਸਿੰਗਾਪੁਰ ਡਾਲਰ",
    "SHP" to "ਸੇਂਟ ਹੇਲੇਨਾ ਪੌਂਡ",
    "SLE" to "ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ",
    "SLL" to "ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ (1964—2022)",
    "SOS" to "ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ",
    "SRD" to "ਸੂਰੀਨਾਮੀ ਡਾਲਰ",
    "SSP" to "ਦੱਖਣੀ ਸੂਡਾਨੀ ਪੌਂਡ",
    "STD" to "ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ (1977–2017)",
    "STN" to "ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ",
    "SUR" to "ਸੋਵੀਅਤ ਰੂਬਲ",
    "SYP" to "ਸੀਰੀਆਈ ਪੌਂਡ",
    "SZL" to "ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ",
    "THB" to "ਥਾਈ ਬਾਹਤ",
    "TJS" to "ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ",
    "TMT" to "ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ",
    "TND" to "ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ",
    "TOP" to "ਟੌਂਗਨ ਪੈਂਗਾ",
    "TRY" to "ਤੁਰਕੀ ਲੀਰਾ",
    "TTD" to "ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ",
    "TWD" to "ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ",
    "TZS" to "ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ",
    "UAH" to "ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ",
    "UGX" to "ਯੂਗਾਂਡੀਆਈ ਸ਼ਿਲਿੰਗ",
    "USD" to "ਯੂ.ਐਸ. ਡਾਲਰ",
    "UYP" to "ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ (1975–1993)",
    "UYU" to "ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ",
    "UZS" to "ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ",
    "VEB" to "ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ (1871–2008)",
    "VEF" to "ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ (2008–2018)",
    "VES" to "ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ",
    "VND" to "ਵੀਅਤਨਾਮੀ ਡੋਂਗ",
    "VNN" to "ਵੀਅਤਨਾਮੀ ਡੋਂਗ (1978–1985)",
    "VUV" to "ਵਾਨੂਆਟੂ ਵਾਟੂ",
    "WST" to "ਸਾਮੋਆਈ ਤਾਲਾ",
    "XAF" to "ਕੇਂਦਰੀ ਅਫ਼ਰੀਕੀ [CFA] ਫ੍ਰੈਂਕ",
    "XAG" to "ਚਾਂਦੀ",
    "XAU" to "ਸੋਨਾ",
    "XBB" to "ਯੂਰਪੀ ਵਿੱਤੀ ਇਕਾਈ",
    "XCD" to "ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ",
    "XEU" to "ਯੂਰਪੀ ਮੁਦਰਾ ਇਕਾਈ",
    "XOF" to "ਪੱਛਮੀ ਅਫ਼ਰੀਕੀ (CFA) ਫ੍ਰੈਂਕ",
    "XPF" to "ਫ੍ਰੈਂਕ (CFP)",
    "XXX" to "ਅਗਿਆਤ ਮੁਦਰਾ",
    "YER" to "ਯਮਨੀ ਰਿਆਲ",
    "ZAR" to "ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ",
    "ZMW" to "ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ",
  ) }

  val pa_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
    "EUR" to "يورو",
    "INR" to "روپئیہ [INR]",
    "PKR" to "روپئیہ",
  ) }

  val pa_Guru: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ",
    "AFN" to "ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ",
    "ALL" to "ਅਲਬਾਨੀਆਈ ਲੇਕ",
    "AMD" to "ਅਰਮੀਨੀਆਈ ਦਰਾਮ",
    "ANG" to "ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ",
    "AOA" to "ਅੰਗੋਲਾ ਕਵਾਂਜਾ",
    "ARA" to "ਅਰਜਨਟੀਨੀ ਅਸਟਰਾਲ",
    "ARL" to "ਅਰਜਨਟੀਨੀ ਪੇਸੋ ਲੇ (1970–1983)",
    "ARM" to "ਅਰਜਨਟੀਨੀ ਪੇਸੋ (1881–1970)",
    "ARP" to "ਅਰਜਨਟੀਨੀ ਪੇਸੋ (1983–1985)",
    "ARS" to "ਅਰਜਨਟੀਨੀ ਪੇਸੋ",
    "AUD" to "ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ",
    "AWG" to "ਅਰੂਬਨ ਫਲੋਰਿਨ",
    "AZN" to "ਅਜ਼ਰਬਾਈਜਾਨ ਮਾਨਤ",
    "BAM" to "ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣਯੋਗ ਮਾਰਕ",
    "BBD" to "ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ",
    "BDT" to "ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ",
    "BGN" to "ਬੁਲਗਾਰੀਆਈ ਲੇਵ",
    "BHD" to "ਬਹਿਰੀਨੀ ਦਿਨਾਰ",
    "BIF" to "ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ",
    "BMD" to "ਬਰਮੂਡਾ ਡਾਲਰ",
    "BND" to "ਬਰੂਨੇਈ ਡਾਲਰ",
    "BOB" to "ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ",
    "BOL" to "ਬੋਲੀਵੀਆਈ ਬੋਲੀਵੀਅਨੋ (1863–1963)",
    "BOP" to "ਬੋਲੀਵੀਆਈ ਪੇਸੋ",
    "BOV" to "ਬੋਲੀਵੀਆਈ ਮਵਡੋਲ",
    "BRB" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਿਰੋਸ (1967–1986)",
    "BRC" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਾਡੂ (1986–1989)",
    "BRE" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ (1990–1993)",
    "BRL" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਰੀਅਲ",
    "BRN" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਾਡੂ (1989–1990)",
    "BRR" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ (1993–1994)",
    "BRZ" to "ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ (1942–1967)",
    "BSD" to "ਬਾਹਾਮੀਅਨ ਡਾਲਰ",
    "BTN" to "ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ",
    "BWP" to "ਬੋਟਸਵਾਨਾ ਪੁਲਾ",
    "BYN" to "ਬੇਲਾਰੂਸੀ ਰੂਬਲ",
    "BYR" to "ਬੇਲਾਰੂਸੀ ਰੂਬਲ (2000–2016)",
    "BZD" to "ਬੇਲੀਜ਼ ਡਾਲਰ",
    "CAD" to "ਕੇਨੇਡਿਆਈ ਡਾਲਰ",
    "CDF" to "ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ",
    "CHF" to "ਸਵਿਸ ਫ੍ਰੈਂਕ",
    "CLP" to "ਚਿਲੀ ਪੇਸੋ",
    "CNH" to "ਚੀਨੀ ਯੁਆਨ (ਔਫ਼ਸ਼ੋਰ)",
    "CNY" to "ਚੀਨੀ ਯੁਆਨ",
    "COP" to "ਕੋਲੰਬਿਆਈ ਪੇਸੋ",
    "CRC" to "ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ",
    "CUC" to "ਕਿਊਬਨ ਬਦਲਣਯੋਗ ਪੇਸੋ",
    "CUP" to "ਕਿਊਬਨ ਪੇਸੋ",
    "CVE" to "ਕੇਪ ਵਰਡੀਅਨ ਸਕੂਡੋ",
    "CZK" to "ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ",
    "DEM" to "ਜਰਮਨ ਮਾਰਕ",
    "DJF" to "ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ",
    "DKK" to "ਡੈਨਿਸ਼ ਕਰੌਨ",
    "DOP" to "ਡੌਮਿਨਿਕਨ ਪੇਸੋ",
    "DZD" to "ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ",
    "EGP" to "ਮਿਸਰੀ ਪੌਂਡ",
    "ERN" to "ਇਰੀਟ੍ਰਿਆਈ ਨਾਫ਼ਾ",
    "ETB" to "ਇਥੋਪੀਆਈ ਬਿਰ",
    "EUR" to "ਯੂਰੋ",
    "FJD" to "ਫ਼ਿਜ਼ੀ ਡਾਲਰ",
    "FKP" to "ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪੌਂਡ",
    "GBP" to "ਬ੍ਰਿਟਿਸ਼ ਪੌਂਡ",
    "GEL" to "ਜਾਰਜੀਆਈ ਲਾਰੀ",
    "GHS" to "ਘਾਨਾਈ ਸੇਡੀ",
    "GIP" to "ਜਿਬਰਾਲਟਰ ਪੌਂਡ",
    "GMD" to "ਗੈਂਬੀਆਈ ਦਲਾਸੀ",
    "GNF" to "ਗਿਨੀ ਫ੍ਰੈਂਕ",
    "GTQ" to "ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ",
    "GYD" to "ਗੁਆਨਾਆਈ ਡਾਲਰ",
    "HKD" to "ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ",
    "HNL" to "ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ",
    "HRK" to "ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ",
    "HTG" to "ਹੈਤੀ ਗੌਰਡੇ",
    "HUF" to "ਹੰਗਰੀ ਫੋਰਿੰਟ",
    "IDR" to "ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ",
    "IEP" to "ਆਇਰਿਸ਼ ਪੌਂਡ",
    "ILP" to "ਇਜ਼ਰਾਈਲੀ ਪੌਂਡ",
    "ILS" to "ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ",
    "INR" to "ਭਾਰਤੀ ਰੁਪਇਆ",
    "IQD" to "ਇਰਾਕੀ ਦਿਨਾਰ",
    "IRR" to "ਈਰਾਨੀ ਰਿਆਲ",
    "ISK" to "ਆਈਸਲੈਂਡੀ ਕਰੋਨਾ",
    "JMD" to "ਜਮਾਇਕਨ ਡਾਲਰ",
    "JOD" to "ਜਾਰਡਨ ਦਿਨਾਰ",
    "JPY" to "ਜਪਾਨੀ ਯੇਨ",
    "KES" to "ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ",
    "KGS" to "ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ",
    "KHR" to "ਕੰਬੋਡੀਆਈ ਰੀਅਲ",
    "KMF" to "ਕੋਮੋਰੀਅਨ ਫ੍ਰੈਂਕ",
    "KPW" to "ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ",
    "KRW" to "ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ",
    "KWD" to "ਕੁਵੈਤੀ ਦਿਨਾਰ",
    "KYD" to "ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ",
    "KZT" to "ਕਜ਼ਾਖਸਤਾਨੀ ਤੇਂਗੇ",
    "LAK" to "ਲਾਓਟਿਆਈ ਕਿਪ",
    "LBP" to "ਲੈਬਨਾਨੀ ਪੌਂਡ",
    "LKR" to "ਸ੍ਰੀਲੰਕਾਈ ਰੁਪਇਆ",
    "LRD" to "ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ",
    "LSL" to "ਲੇਸੋਥੋ ਲੋਟੀ",
    "LTL" to "ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ",
    "LVL" to "ਲਾਟਵਿਆਈ ਲਾਟਸ",
    "LYD" to "ਲੀਬੀਆਈ ਦਿਨਾਰ",
    "MAD" to "ਮੋਰੱਕਨ ਦਿਰਹਾਮ",
    "MDL" to "ਮੋਲਡੋਵਨ ਲੇਉ",
    "MGA" to "ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ",
    "MKD" to "ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ",
    "MMK" to "ਮਿਆਂਮਾਰ ਕਿਆਤ",
    "MNT" to "ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ",
    "MOP" to "ਮੇਕਾਨੀ ਪਟਾਕਾ",
    "MRO" to "ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ (1973–2017)",
    "MRU" to "ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ",
    "MUR" to "ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਇਆ",
    "MVR" to "ਮਾਲਦੀਵੀ ਰੁਫੀਆ",
    "MWK" to "ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ",
    "MXN" to "ਮੈਕਸੀਕਨ ਪੇਸੋ",
    "MYR" to "ਮਲੇਸ਼ੀਆਈ ਰਿੰਗਿਟ",
    "MZN" to "ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ",
    "NAD" to "ਨਾਮੀਬੀਆਈ ਡਾਲਰ",
    "NGN" to "ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ",
    "NIO" to "ਨਿਕਾਰਾਗੁਆਈ ਕੋਰਡੋਬਾ",
    "NOK" to "ਨਾਰਵੇਜੀਆਈ ਕਰੌਨ",
    "NPR" to "ਨੇਪਾਲੀ ਰੁਪਇਆ",
    "NZD" to "ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ",
    "OMR" to "ਓਮਾਨੀ ਰਿਆਲ",
    "PAB" to "ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ",
    "PEN" to "ਪੇਰੂਵੀਅਨ ਸੋਲ",
    "PGK" to "ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕੀਨਾ",
    "PHP" to "ਫਿਲਿਪੀਨੀ ਪੇਸੋ",
    "PKR" to "ਪਾਕਿਸਤਾਨੀ ਰੁਪਇਆ",
    "PLN" to "ਪੋਲੈਂਡੀ ਜ਼ਲੌਟੀ",
    "PYG" to "ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ",
    "QAR" to "ਕਤਰੀ ਰਿਆਲ",
    "RON" to "ਰੋਮਾਨੀਆਈ ਲੇਉ",
    "RSD" to "ਸਰਬੀਆਈ ਦਿਨਾਰ",
    "RUB" to "ਰੂਸੀ ਰੂਬਲ",
    "RWF" to "ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ",
    "SAR" to "ਸਾਊਦੀ ਰਿਆਲ",
    "SBD" to "ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ",
    "SCR" to "ਸੇਸ਼ਲਸ ਰੁਪਇਆ",
    "SDG" to "ਸੂਡਾਨੀ ਪੌਂਡ",
    "SEK" to "ਸਵੀਡਿਸ਼ ਕਰੋਨਾ",
    "SGD" to "ਸਿੰਗਾਪੁਰ ਡਾਲਰ",
    "SHP" to "ਸੇਂਟ ਹੇਲੇਨਾ ਪੌਂਡ",
    "SLE" to "ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ",
    "SLL" to "ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ (1964—2022)",
    "SOS" to "ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ",
    "SRD" to "ਸੂਰੀਨਾਮੀ ਡਾਲਰ",
    "SSP" to "ਦੱਖਣੀ ਸੂਡਾਨੀ ਪੌਂਡ",
    "STD" to "ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ (1977–2017)",
    "STN" to "ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ",
    "SUR" to "ਸੋਵੀਅਤ ਰੂਬਲ",
    "SYP" to "ਸੀਰੀਆਈ ਪੌਂਡ",
    "SZL" to "ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ",
    "THB" to "ਥਾਈ ਬਾਹਤ",
    "TJS" to "ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ",
    "TMT" to "ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ",
    "TND" to "ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ",
    "TOP" to "ਟੌਂਗਨ ਪੈਂਗਾ",
    "TRY" to "ਤੁਰਕੀ ਲੀਰਾ",
    "TTD" to "ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ",
    "TWD" to "ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ",
    "TZS" to "ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ",
    "UAH" to "ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ",
    "UGX" to "ਯੂਗਾਂਡੀਆਈ ਸ਼ਿਲਿੰਗ",
    "USD" to "ਯੂ.ਐਸ. ਡਾਲਰ",
    "UYP" to "ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ (1975–1993)",
    "UYU" to "ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ",
    "UZS" to "ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ",
    "VEB" to "ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ (1871–2008)",
    "VEF" to "ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ (2008–2018)",
    "VES" to "ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ",
    "VND" to "ਵੀਅਤਨਾਮੀ ਡੋਂਗ",
    "VNN" to "ਵੀਅਤਨਾਮੀ ਡੋਂਗ (1978–1985)",
    "VUV" to "ਵਾਨੂਆਟੂ ਵਾਟੂ",
    "WST" to "ਸਾਮੋਆਈ ਤਾਲਾ",
    "XAF" to "ਕੇਂਦਰੀ ਅਫ਼ਰੀਕੀ [CFA] ਫ੍ਰੈਂਕ",
    "XAG" to "ਚਾਂਦੀ",
    "XAU" to "ਸੋਨਾ",
    "XBB" to "ਯੂਰਪੀ ਵਿੱਤੀ ਇਕਾਈ",
    "XCD" to "ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ",
    "XEU" to "ਯੂਰਪੀ ਮੁਦਰਾ ਇਕਾਈ",
    "XOF" to "ਪੱਛਮੀ ਅਫ਼ਰੀਕੀ (CFA) ਫ੍ਰੈਂਕ",
    "XPF" to "ਫ੍ਰੈਂਕ (CFP)",
    "XXX" to "ਅਗਿਆਤ ਮੁਦਰਾ",
    "YER" to "ਯਮਨੀ ਰਿਆਲ",
    "ZAR" to "ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ",
    "ZMW" to "ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ",
  ) }

  val pap: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val pap_AW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val pcm: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "Yunaítẹ́d Áráb Ẹ́míréts Dírham",
    "AFN" to "Afgán Afgáni",
    "ALL" to "Albéniá Lẹk",
    "AMD" to "Armẹ́niá Dram",
    "ANG" to "Nẹ́dalánds Antílián Gílda",
    "AOA" to "Angólá Kwánza",
    "ARS" to "Ajẹntína Pẹ́so",
    "AUD" to "Ọstréliá Dọ́la",
    "AWG" to "Arúba Flọ́rin",
    "AZN" to "Azẹrbaiján Mánat",
    "BAM" to "Bọ́sniá an Hẹzẹgovína Mak Wé Pẹ́sin Fít Chenj",
    "BBD" to "Barbédọs Dọ́la",
    "BDT" to "Bangladẹ́sh Táka",
    "BGN" to "Bọlgériá Lẹv",
    "BHD" to "Baréin Dínar",
    "BIF" to "Burúndí Frank",
    "BMD" to "Bẹmiúda Dọ́la",
    "BND" to "Brunẹí Dọ́la",
    "BOB" to "Bolíviá Boliviáno",
    "BRL" to "Brazíl Rẹal",
    "BSD" to "Bahámas Dọ́la",
    "BTN" to "Bután Ngúltrum",
    "BWP" to "Botswáná Púla",
    "BYN" to "Bẹlarús Rúbul",
    "BZD" to "Bẹliz Dọ́la",
    "CAD" to "Kánádá Dọ́la",
    "CDF" to "Kóngó Frank",
    "CHF" to "Swís Frank",
    "CLP" to "Chílí Pẹ́so",
    "CNH" to "Chaíná Yuan (ples-dẹm aúsaíd chaína)",
    "CNY" to "Chaíná Yuan",
    "COP" to "Kolómbiá Pẹ́so",
    "CRC" to "Kósta Ríka Kólọn",
    "CUC" to "Kiúbá Pẹ́so Wé Pẹ́sin Fít Chenj",
    "CUP" to "Kiúbá Pẹ́so",
    "CVE" to "Kép Vẹ́d Ẹskúdo",
    "CZK" to "Chẹ́k Kórúna",
    "DJF" to "Jibútí Frank",
    "DKK" to "Dẹ́nmák Króna",
    "DOP" to "Dọmíníkan Pẹ́so",
    "DZD" to "Aljíria Dínar",
    "EGP" to "Íjípt Paund",
    "ERN" to "Ẹritrẹá Nákfa",
    "ETB" to "Ẹtiópiá Berr",
    "EUR" to "Yúro",
    "FJD" to "Fíjí Dọ́la",
    "FKP" to "Fọlkland Aílands Paund",
    "GBP" to "Brítísh Páund",
    "GEL" to "Jọ́jiá Lári",
    "GHS" to "Ganá Sídi",
    "GIP" to "Jibrọ́lta Páund",
    "GMD" to "Gámbiá Dalási",
    "GNF" to "Gíní Frank",
    "GTQ" to "Guátẹmála Kwuẹ́tzal",
    "GYD" to "Giyána Dọ́la",
    "HKD" to "Họng Kọ́ng Dọ́la",
    "HNL" to "Họndúrán Lẹmpíra",
    "HRK" to "Kroéshia Kúna",
    "HTG" to "Haíti Gourd",
    "HUF" to "Họngériá Fọ́rint",
    "IDR" to "Indoníshiá Rupia",
    "ILS" to "Ízrẹ́l Niú Shẹ́kẹl",
    "INR" to "Índiá Rúpi",
    "IQD" to "Irák Dínar",
    "IRR" to "Irán Rial",
    "ISK" to "Aíslánd Króna",
    "JMD" to "Jamaíka Dọla",
    "JOD" to "Jọ́dán Dínar",
    "JPY" to "Japán Yẹn",
    "KES" to "Kẹ́nyá Shílin",
    "KGS" to "Kẹjístan Som",
    "KHR" to "Kambódiá Riẹl",
    "KMF" to "Kọ́mọ́ros Frank",
    "KPW" to "Nọ́t Koriá Wọn",
    "KRW" to "Saút Koriá Wọn",
    "KWD" to "Kuwét Dínar",
    "KYD" to "Kéman Aílands Dọla",
    "KZT" to "Kazakstan Tẹ́nj",
    "LAK" to "Laós Kip",
    "LBP" to "Lẹ́bánọ́n Paund",
    "LKR" to "Sri Lánká Rúpi",
    "LRD" to "Laibẹ́riá Dọ́la",
    "LSL" to "Lẹsóto Lọ́ti",
    "LYD" to "Líbia Dínar",
    "MAD" to "Morọko Dírham",
    "MDL" to "Mọldóva Lu",
    "MGA" to "Malagásí Ariári",
    "MKD" to "Masẹdónia Dínar",
    "MMK" to "Miánmá Kiat",
    "MNT" to "Mọngóliá Túgrik",
    "MOP" to "Makáo Pátáka",
    "MRU" to "Mọriténiá Uguíya",
    "MUR" to "Mọríshọ́s Rúpi",
    "MVR" to "Mọ́ldívs Rúfíya",
    "MWK" to "Maláwi ́Kwácha",
    "MXN" to "Mẹ́ksíko Pẹ́so",
    "MYR" to "Maléshiá Ríngit",
    "MZN" to "Mozámbík Métíkal",
    "NAD" to "Namíbiá Dọ́la",
    "NGN" to "Naijíriá Naíra",
    "NIO" to "Nikarágwua Kordóba",
    "NOK" to "Nọ́wé Króna",
    "NPR" to "Nẹ́pál Rúpi",
    "NZD" to "Niú Zílánd Dọ́las",
    "OMR" to "Omán Rial",
    "PAB" to "Pánáma Balbóa",
    "PEN" to "Pẹrúvián Sol",
    "PGK" to "Pápuá Niú Gíni Kína",
    "PHP" to "Fílípíns Píso",
    "PKR" to "Pakístán Rúpi",
    "PLN" to "Pólánd Zílọ́ti",
    "PYG" to "Páragwuá Guaráni",
    "QAR" to "Kata Ríal",
    "RON" to "Roméniá Lu",
    "RSD" to "Sẹrbia Dínar",
    "RUB" to "Rọ́shiá Rúbul",
    "RWF" to "Ruwándá Frank",
    "SAR" to "Saúdí Arébiá Riyal",
    "SBD" to "Sólómọ́n Aílands Dọ́la",
    "SCR" to "Sẹ́chẹ́ls Rúpi",
    "SDG" to "Sudan Paund",
    "SEK" to "Swídẹ́n Króna",
    "SGD" to "Singapọ́ Dọ́la",
    "SHP" to "Sent Hẹlẹ́ná Paund",
    "SLE" to "Siẹ́ra Líoniá Liọn",
    "SLL" to "Siẹ́ra Líoniá Liọn (1964—2022)",
    "SOS" to "Sọmáliá Shílin",
    "SRD" to "Súrínám Dọla",
    "SSP" to "Saút Sudán Paund",
    "STN" to "Sao Tómẹ & Prínsípẹ Dóbra",
    "SYP" to "Síriá Paund",
    "SZL" to "Swází Lilánjẹ́ni",
    "THB" to "Taílánd Baht",
    "TJS" to "Tajíkstan Sómóni",
    "TMT" to "Tọkmẹ́nístán Mánat",
    "TND" to "Tuníshia Dínar",
    "TOP" to "Tónga Pánga",
    "TRY" to "Tọ́kí Líra",
    "TTD" to "Trínídad & Tobágo Dọ́la",
    "TWD" to "Niú Taiwán Dọ́la",
    "TZS" to "Tanzániá Shílin",
    "UAH" to "Yukrẹín Rívnia",
    "UGX" to "Yugándá Shílin",
    "USD" to "US Dọ́la",
    "UYU" to "Yurugwaí Pẹ́so",
    "UZS" to "Uzbẹ́kistan Som",
    "VES" to "Vẹnẹzuẹlá Bolívar",
    "VND" to "Viẹ́tnám Dọng",
    "VUV" to "Vanuátú Vátu",
    "WST" to "Samóa Tála",
    "XAF" to "Sẹ́ntrál Áfríká Frank",
    "XCD" to "Íst Karíbián Dọla",
    "XOF" to "Wẹ́st Afríká Sẹ́fa Frank",
    "XPF" to "Frẹ́nch Poliníshiá Frank",
    "XXX" to "Mọní Wé Pípul Nọ́ No",
    "YER" to "Yẹ́mẹ́n Rial",
    "ZAR" to "Saút Áfríká Rand",
    "ZMW" to "Zámbiá Kwácha",
  ) }

  val pis: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val pl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "peseta andorska",
    "AED" to "dirham ZEA",
    "AFA" to "afgani (1927–2002)",
    "AFN" to "afgani afgańskie",
    "ALL" to "lek albański",
    "AMD" to "dram armeński",
    "ANG" to "gulden antylski",
    "AOA" to "kwanza angolska",
    "AOK" to "kwanza angolańska (1977–1990)",
    "AON" to "nowa kwanza angolańska (1990–2000)",
    "AOR" to "kwanza angolańska Reajustado (1995–1999)",
    "ARA" to "austral argentyński",
    "ARP" to "peso argentyńskie (1983–1985)",
    "ARS" to "peso argentyńskie",
    "ATS" to "szyling austriacki",
    "AUD" to "dolar australijski",
    "AWG" to "florin arubański",
    "AZM" to "manat azerbejdżański",
    "AZN" to "manat azerski",
    "BAD" to "dinar Bośni i Hercegowiny",
    "BAM" to "marka zamienna Bośni i Hercegowiny",
    "BBD" to "dolar barbadoski",
    "BDT" to "taka bengalska",
    "BEC" to "frank belgijski (zamienny)",
    "BEF" to "frank belgijski",
    "BEL" to "frank belgijski (finansowy)",
    "BGL" to "lew bułgarski wymienny",
    "BGM" to "lew bułgarski socjalistyczny",
    "BGN" to "lew bułgarski",
    "BGO" to "lew bułgarski (1879–1952)",
    "BHD" to "dinar bahrański",
    "BIF" to "frank burundyjski",
    "BMD" to "dolar bermudzki",
    "BND" to "dolar brunejski",
    "BOB" to "boliviano boliwijskie",
    "BOP" to "peso boliwijskie",
    "BOV" to "mvdol boliwijski",
    "BRB" to "cruzeiro novo brazylijskie (1967–1986)",
    "BRC" to "cruzado brazylijskie",
    "BRE" to "cruzeiro brazylijskie (1990–1993)",
    "BRL" to "real brazylijski",
    "BRN" to "nowe cruzado brazylijskie",
    "BRR" to "cruzeiro brazylijskie",
    "BSD" to "dolar bahamski",
    "BTN" to "ngultrum bhutański",
    "BUK" to "kyat birmański",
    "BWP" to "pula botswańska",
    "BYB" to "rubel białoruski (1994–1999)",
    "BYN" to "rubel białoruski",
    "BYR" to "rubel białoruski (2000–2016)",
    "BZD" to "dolar belizeński",
    "CAD" to "dolar kanadyjski",
    "CDF" to "frank kongijski",
    "CHF" to "frank szwajcarski",
    "CLP" to "peso chilijskie",
    "CNH" to "juan chiński (rynek zewnętrzny)",
    "CNY" to "juan chiński",
    "COP" to "peso kolumbijskie",
    "CRC" to "colon kostarykański",
    "CSD" to "stary dinar serbski",
    "CSK" to "korona czechosłowacka",
    "CUC" to "peso kubańskie wymienialne",
    "CUP" to "peso kubańskie",
    "CVE" to "escudo zielonoprzylądkowe",
    "CYP" to "funt cypryjski",
    "CZK" to "korona czeska",
    "DDM" to "wschodnia marka wschodnioniemiecka",
    "DEM" to "marka niemiecka",
    "DJF" to "frank dżibutyjski",
    "DKK" to "korona duńska",
    "DOP" to "peso dominikańskie",
    "DZD" to "dinar algierski",
    "ECS" to "sucre ekwadorski",
    "EEK" to "korona estońska",
    "EGP" to "funt egipski",
    "ERN" to "nakfa erytrejska",
    "ESA" to "peseta hiszpańska (Konto A)",
    "ESB" to "peseta hiszpańska (konto wymienne)",
    "ESP" to "peseta hiszpańska",
    "ETB" to "birr etiopski",
    "EUR" to "euro",
    "FIM" to "marka fińska",
    "FJD" to "dolar fidżyjski",
    "FKP" to "funt falklandzki",
    "FRF" to "frank francuski",
    "GBP" to "funt szterling",
    "GEK" to "kupon gruziński larit",
    "GEL" to "lari gruzińskie",
    "GHC" to "cedi ghańskie (1979–2007)",
    "GHS" to "cedi ghańskie",
    "GIP" to "funt gibraltarski",
    "GMD" to "dalasi gambijskie",
    "GNF" to "frank gwinejski",
    "GNS" to "syli gwinejskie",
    "GQE" to "ekwele gwinejskie Gwinei Równikowej",
    "GRD" to "drachma grecka",
    "GTQ" to "quetzal gwatemalski",
    "GWE" to "escudo Gwinea Portugalska",
    "GWP" to "peso Guinea-Bissau",
    "GYD" to "dolar gujański",
    "HKD" to "dolar hongkoński",
    "HNL" to "lempira honduraska",
    "HRD" to "dinar chorwacki",
    "HRK" to "kuna chorwacka",
    "HTG" to "gourde haitański",
    "HUF" to "forint węgierski",
    "IDR" to "rupia indonezyjska",
    "IEP" to "funt irlandzki",
    "ILP" to "funt izraelski",
    "ILS" to "nowy szekel izraelski",
    "INR" to "rupia indyjska",
    "IQD" to "dinar iracki",
    "IRR" to "rial irański",
    "ISK" to "korona islandzka",
    "ITL" to "lir włoski",
    "JMD" to "dolar jamajski",
    "JOD" to "dinar jordański",
    "JPY" to "jen japoński",
    "KES" to "szyling kenijski",
    "KGS" to "som kirgiski",
    "KHR" to "riel kambodżański",
    "KMF" to "frank komoryjski",
    "KPW" to "won północnokoreański",
    "KRW" to "won południowokoreański",
    "KWD" to "dinar kuwejcki",
    "KYD" to "dolar kajmański",
    "KZT" to "tenge kazachskie",
    "LAK" to "kip laotański",
    "LBP" to "funt libański",
    "LKR" to "rupia lankijska",
    "LRD" to "dolar liberyjski",
    "LSL" to "loti sotyjskie",
    "LTL" to "lit litewski",
    "LTT" to "talon litewski",
    "LUF" to "frank luksemburski",
    "LVL" to "łat łotewski",
    "LVR" to "rubel łotewski",
    "LYD" to "dinar libijski",
    "MAD" to "dirham marokański",
    "MAF" to "frank marokański",
    "MDL" to "lej mołdawski",
    "MGA" to "ariary malgaski",
    "MGF" to "frank malgaski",
    "MKD" to "denar macedoński",
    "MLF" to "frank malijski",
    "MMK" to "kiat birmański",
    "MNT" to "tugrik mongolski",
    "MOP" to "pataca Makau",
    "MRO" to "ouguiya mauretańska (1973–2017)",
    "MRU" to "ugija mauretańska",
    "MTL" to "lira maltańska",
    "MTP" to "funt maltański",
    "MUR" to "rupia maurytyjska",
    "MVR" to "rupia malediwska",
    "MWK" to "kwacha malawijska",
    "MXN" to "peso meksykańskie",
    "MXP" to "peso srebrne meksykańskie (1861–1992)",
    "MYR" to "ringgit malezyjski",
    "MZE" to "escudo mozambickie",
    "MZM" to "metical Mozambik",
    "MZN" to "metical mozambicki",
    "NAD" to "dolar namibijski",
    "NGN" to "naira nigeryjska",
    "NIC" to "cordoba nikaraguańska (1988–1991)",
    "NIO" to "cordoba nikaraguańska",
    "NLG" to "gulden holenderski",
    "NOK" to "korona norweska",
    "NPR" to "rupia nepalska",
    "NZD" to "dolar nowozelandzki",
    "OMR" to "rial omański",
    "PAB" to "balboa panamski",
    "PEI" to "inti peruwiański",
    "PEN" to "sol peruwiański",
    "PES" to "sol peruwiański (1863–1965)",
    "PGK" to "kina papuańska",
    "PHP" to "peso filipińskie",
    "PKR" to "rupia pakistańska",
    "PLN" to "złoty polski",
    "PLZ" to "złoty polski (1950–1995)",
    "PTE" to "escudo portugalskie",
    "PYG" to "guarani paragwajskie",
    "QAR" to "rial katarski",
    "RHD" to "dolar rodezyjski",
    "ROL" to "lej rumuński (1952–2006)",
    "RON" to "lej rumuński",
    "RSD" to "dinar serbski",
    "RUB" to "rubel rosyjski",
    "RUR" to "rubel rosyjski (1991–1998)",
    "RWF" to "frank ruandyjski",
    "SAR" to "rial saudyjski",
    "SBD" to "dolar Wysp Salomona",
    "SCR" to "rupia seszelska",
    "SDD" to "dinar sudański",
    "SDG" to "funt sudański",
    "SDP" to "funt sudański (1957–1998)",
    "SEK" to "korona szwedzka",
    "SGD" to "dolar singapurski",
    "SHP" to "funt Świętej Heleny",
    "SIT" to "tolar słoweński",
    "SKK" to "korona słowacka",
    "SLE" to "leone sierraleoński",
    "SLL" to "leone sierraleoński (1964—2022)",
    "SOS" to "szyling somalijski",
    "SRD" to "dolar surinamski",
    "SRG" to "gulden surinamski",
    "SSP" to "funt południowosudański",
    "STD" to "dobra Wysp Świętego Tomasza i Książęcej (1977–2017)",
    "STN" to "dobra Wysp Świętego Tomasza i Książęcej",
    "SUR" to "rubel radziecki",
    "SVC" to "colon salwadorski",
    "SYP" to "funt syryjski",
    "SZL" to "lilangeni Suazi",
    "THB" to "baht tajski",
    "TJR" to "rubel tadżycki",
    "TJS" to "somoni tadżyckie",
    "TMM" to "manat turkmeński (1993–2009)",
    "TMT" to "manat turkmeński",
    "TND" to "dinar tunezyjski",
    "TOP" to "pa’anga tongijska",
    "TPE" to "escudo timorskie",
    "TRL" to "lira turecka (1922–2005)",
    "TRY" to "lira turecka",
    "TTD" to "dolar trynidadzki",
    "TWD" to "nowy dolar tajwański",
    "TZS" to "szyling tanzański",
    "UAH" to "hrywna ukraińska",
    "UAK" to "karbowaniec ukraiński",
    "UGS" to "szyling ugandyjski (1966–1987)",
    "UGX" to "szyling ugandyjski",
    "USD" to "dolar amerykański",
    "UYP" to "peso urugwajskie (1975–1993)",
    "UYU" to "peso urugwajskie",
    "UZS" to "som uzbecki",
    "VEB" to "boliwar wenezuelski (1871–2008)",
    "VEF" to "boliwar wenezuelski (2008–2018)",
    "VES" to "boliwar wenezuelski",
    "VND" to "dong wietnamski",
    "VUV" to "vatu wanuackie",
    "WST" to "tala samoańskie",
    "XAF" to "frank CFA BEAC",
    "XAG" to "srebro",
    "XAU" to "złoto",
    "XBC" to "europejska jednostka rozrachunkowa (XBC)",
    "XBD" to "europejska jednostka rozrachunkowa (XBD)",
    "XCD" to "dolar wschodniokaraibski",
    "XDR" to "specjalne prawa ciągnienia",
    "XEU" to "ECU",
    "XFO" to "frank złoty francuski",
    "XFU" to "UIC-frank francuski",
    "XOF" to "frank CFA",
    "XPD" to "pallad",
    "XPF" to "frank CFP",
    "XPT" to "platyna",
    "XTS" to "testowy kod waluty",
    "XXX" to "nieznana waluta",
    "YDD" to "dinar jemeński",
    "YER" to "rial jemeński",
    "YUM" to "nowy dinar jugosławiański",
    "YUN" to "dinar jugosławiański wymienny",
    "ZAL" to "rand południowoafrykański (finansowy)",
    "ZAR" to "rand południowoafrykański",
    "ZMK" to "kwacha zambijska (1968–2012)",
    "ZMW" to "kwacha zambijska",
    "ZRN" to "nowy zair zairski",
    "ZRZ" to "zair zairski",
    "ZWD" to "dolar Zimbabwe (1980–2008)",
    "ZWL" to "dolar Zimbabwe (2009)",
    "ZWR" to "dolar Zimbabwe (2008)",
  ) }

  val prg: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ps: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "متحده عرب امارات درهم",
    "AFA" to "افغانۍ (1927–2002)",
    "AFN" to "افغانۍ",
    "ALL" to "البانوي لک",
    "AMD" to "ارمينيايي ډرام",
    "ANG" to "هالېنډي انټيليايي ګيلډر",
    "AOA" to "انګولي کوانزا",
    "ARS" to "ارجنټاين پسو",
    "AUD" to "آسترالوي ډالر",
    "AWG" to "اروبايي فلورن",
    "AZN" to "آزربايجاني منت",
    "BAM" to "بوسنيا هرزګوينيايي بدلېدونکې مارک",
    "BBD" to "باربيډين ډالر",
    "BDT" to "بنګالۍ ټاکه",
    "BGN" to "بلغاري ليو",
    "BHD" to "بحريني دينار",
    "BIF" to "برونډي فرانک",
    "BMD" to "برمودا ډالر",
    "BND" to "برونايي ډالر",
    "BOB" to "بوليوي بوليويانو",
    "BRL" to "برازيلي ريل",
    "BSD" to "بهاماسي ډالر",
    "BTN" to "بهوټانۍ انګولټرم",
    "BWP" to "بوټسواني پولا",
    "BYN" to "بلاروسي روبل",
    "BZD" to "بليز ډالر",
    "CAD" to "کاناډايي ډالر",
    "CDF" to "کانګولي فرانک",
    "CHF" to "سويسي فرانک",
    "CLP" to "چلي پسو",
    "CNH" to "چيني يوان (آف شور)",
    "CNY" to "چيني يوان",
    "COP" to "کولمبين پسو",
    "CRC" to "کوسټا ريکن کولون",
    "CUC" to "کيوبايي بدلېدونکي پسو",
    "CUP" to "کيوبايي پسو",
    "CVE" to "کيپ وردين اسکوډو",
    "CZK" to "چيک کرونا",
    "DJF" to "جبوتي فرانک",
    "DKK" to "ډنمارکي کرون",
    "DOP" to "دومينيکا پسو",
    "DZD" to "الجيرين دينار",
    "EGP" to "مصري پونډ",
    "ERN" to "ايريټرين نکفا",
    "ETB" to "ايتهوپيايي بر",
    "EUR" to "يورو",
    "FJD" to "فجي ډالر",
    "FKP" to "پاکلېنډ ټاپوګانو پونډ",
    "GBP" to "برتانوې پونډ",
    "GEL" to "جارجیاېي لارې",
    "GHS" to "ګانين سيډي",
    "GIP" to "جبل الطارقي پونډ",
    "GMD" to "ګيمبين دلاسې",
    "GNF" to "ګنې فرانک",
    "GTQ" to "ګويټيمالن کوټزل",
    "GYD" to "ګايانيز ډالر",
    "HKD" to "هانګ کانګ ډالر",
    "HNL" to "هونډوران ليمپيرا",
    "HRK" to "کروشيايي کونا",
    "HTG" to "هيټي ګورډ",
    "HUF" to "هنګري فورنټ",
    "IDR" to "انډونيشي روپيا",
    "ILS" to "اسرايلي نيو شيکل",
    "INR" to "هندي روپۍ",
    "IQD" to "عراقي دينار",
    "IRR" to "ايراني ريال",
    "ISK" to "آيسلېنډي کرونا",
    "JMD" to "جمايکايي ډالر",
    "JOD" to "اردني دينار",
    "JPY" to "جاپاني ين",
    "KES" to "کينيايي شيلنګ",
    "KGS" to "کرغزستاني سوم",
    "KHR" to "کمبوډي ريل",
    "KMF" to "کوموري فرانک",
    "KPW" to "شمالي کوريايي وان",
    "KRW" to "جنوبي کوريايي وان",
    "KWD" to "کويتي دينار",
    "KYD" to "کيمن ټاپوګانو ډالر",
    "KZT" to "قازقستاني ټينج",
    "LAK" to "لاشې کپ",
    "LBP" to "لبناني پونډ",
    "LKR" to "سري لنکن روپۍ",
    "LRD" to "لايبيرين ډالر",
    "LSL" to "Lesotho Loti",
    "LYD" to "ليبياېي دينار",
    "MAD" to "مراکشي درهم",
    "MDL" to "مالډوي ليو",
    "MGA" to "ملاګاسي ارياري",
    "MKD" to "مسيډونايي دينار",
    "MMK" to "ميانماري کيات",
    "MNT" to "منګوليايي توګريک",
    "MOP" to "مکانيس پټاکا",
    "MRU" to "موريشيسي ډالر",
    "MUR" to "موريشيسي روپۍ",
    "MVR" to "مالديپي روپيا",
    "MWK" to "ملاوي کواچا",
    "MXN" to "ميکسيکن پيسو",
    "MYR" to "ملايشي رنګټ",
    "MZN" to "موزمبيقي ميټيکل",
    "NAD" to "نيميبيايي ډالر",
    "NGN" to "نايجيري نايرا",
    "NIO" to "نيکاراګون کورډوبا",
    "NOK" to "نارويجين کرون",
    "NPR" to "نيپالي روپۍ",
    "NZD" to "نيوزي لينډي ډالر",
    "OMR" to "عماني ريال",
    "PAB" to "پانامۍ بالبوا",
    "PEN" to "پيروين سول",
    "PGK" to "پاپوا نيوګاني کينا",
    "PHP" to "فلپاينۍ پیسو",
    "PKR" to "پاکستانۍ کلداره",
    "PLN" to "پولينډي زلوټي",
    "PYG" to "پيراګوين ګوراني",
    "QAR" to "قطري ريال",
    "RON" to "روماني ليو",
    "RSD" to "سربيايي دينار",
    "RUB" to "روسي روبل",
    "RWF" to "روانډي فرانک",
    "SAR" to "سعودي ريال",
    "SBD" to "سولومن ټاپوګانو ډالر",
    "SCR" to "سيچيليسي روپۍ",
    "SDG" to "سوډاني پونډ",
    "SEK" to "سويډني کرونا",
    "SGD" to "سنګاپور ډالر",
    "SHP" to "سينټ هيلينا پونډ",
    "SLE" to "سيرا ليوني ليون",
    "SLL" to "سيرا ليوني ليون - 1964-2022",
    "SOS" to "سومالي شيلنګ",
    "SRD" to "سورينيمي ډالر",
    "SSP" to "جنوب سوډاني پونډ",
    "STN" to "ساو ټوم او پرينسپي ډوبرا",
    "SYP" to "سوريايي پونډ",
    "SZL" to "سوازي ليلانګيني",
    "THB" to "تهايي بات",
    "TJS" to "تاجکستاني سوموني",
    "TMT" to "ترکمانستاني منت",
    "TND" to "تيونسې دينار",
    "TOP" to "ټونګن پانګا",
    "TRY" to "ترکي ليرا",
    "TTD" to "ټرينيډاډ او ټوباګو ډالر",
    "TWD" to "نيو تائيواني ډالر",
    "TZS" to "تنزاني شيلنګ",
    "UAH" to "اوکرايني هريونيا",
    "UGX" to "يوګانډي شيلنګ",
    "USD" to "امريکايي ډالر",
    "UYU" to "يوراګوي پسو",
    "UZS" to "ازبکستاني سوم",
    "VES" to "وينزويلي بوليوار",
    "VND" to "ويتنامي ډونګ",
    "VUV" to "ونواتو واتو",
    "WST" to "سموون تالا",
    "XAF" to "مرکزي افريقايي CFA فرانک",
    "XCD" to "ختيځ کربين ډالر",
    "XOF" to "ختيځ افريقايي CFA فرانک",
    "XPF" to "CFP فرانک",
    "XXX" to "نامعلومه مروجه پېسې",
    "YER" to "يمني ريال",
    "ZAR" to "جنوبي افريقاېي رنډ",
    "ZMW" to "زيمبي کواچا",
  ) }

  val ps_PK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "XXX" to "نامعلومه مروجه پېسے",
  ) }

  val pt: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ADP" to "Peseta de Andorra",
    "AED" to "Dirham dos Emirados Árabes Unidos",
    "AFA" to "Afegane (1927–2002)",
    "AFN" to "Afegane afegão",
    "ALK" to "Lek Albanês (1946–1965)",
    "ALL" to "Lek albanês",
    "AMD" to "Dram armênio",
    "ANG" to "Florim das Antilhas Holandesas",
    "AOA" to "Kwanza angolano",
    "AOK" to "Cuanza angolano (1977–1990)",
    "AON" to "Novo cuanza angolano (1990–2000)",
    "AOR" to "Cuanza angolano reajustado (1995–1999)",
    "ARA" to "Austral argentino",
    "ARL" to "Peso lei argentino (1970–1983)",
    "ARM" to "Peso argentino (1881–1970)",
    "ARP" to "Peso argentino (1983–1985)",
    "ARS" to "Peso argentino",
    "ATS" to "Xelim austríaco",
    "AUD" to "Dólar australiano",
    "AWG" to "Florim arubano",
    "AZM" to "Manat azerbaijano (1993–2006)",
    "AZN" to "Manat azeri",
    "BAD" to "Dinar da Bósnia-Herzegovina (1992–1994)",
    "BAM" to "Marco conversível da Bósnia e Herzegovina",
    "BAN" to "Novo dinar da Bósnia-Herzegovina (1994–1997)",
    "BBD" to "Dólar barbadense",
    "BDT" to "Taka bengali",
    "BEC" to "Franco belga (conversível)",
    "BEF" to "Franco belga",
    "BEL" to "Franco belga (financeiro)",
    "BGL" to "Lev forte búlgaro",
    "BGM" to "Lev socialista búlgaro",
    "BGN" to "Lev búlgaro",
    "BGO" to "Lev búlgaro (1879–1952)",
    "BHD" to "Dinar bareinita",
    "BIF" to "Franco burundiano",
    "BMD" to "Dólar bermudense",
    "BND" to "Dólar bruneano",
    "BOB" to "Boliviano da Bolívia",
    "BOL" to "Boliviano (1863–1963)",
    "BOP" to "Peso boliviano",
    "BOV" to "Mvdol boliviano",
    "BRB" to "Cruzeiro novo brasileiro (1967–1986)",
    "BRC" to "Cruzado brasileiro (1986–1989)",
    "BRE" to "Cruzeiro brasileiro (1990–1993)",
    "BRL" to "Real brasileiro",
    "BRN" to "Cruzado novo brasileiro (1989–1990)",
    "BRR" to "Cruzeiro brasileiro (1993–1994)",
    "BRZ" to "Cruzeiro brasileiro (1942–1967)",
    "BSD" to "Dólar bahamense",
    "BTN" to "Ngultrum butanês",
    "BUK" to "Kyat birmanês",
    "BWP" to "Pula botsuanesa",
    "BYB" to "Rublo novo bielo-russo (1994–1999)",
    "BYN" to "Rublo bielorrusso",
    "BYR" to "Rublo bielorrusso (2000–2016)",
    "BZD" to "Dólar belizenho",
    "CAD" to "Dólar canadense",
    "CDF" to "Franco congolês",
    "CHE" to "Euro WIR",
    "CHF" to "Franco suíço",
    "CHW" to "Franco WIR",
    "CLE" to "Escudo chileno",
    "CLF" to "Unidades de Fomento chilenas",
    "CLP" to "Peso chileno",
    "CNH" to "Yuan chinês (offshore)",
    "CNX" to "Dólar do Banco Popular da China",
    "CNY" to "Yuan chinês",
    "COP" to "Peso colombiano",
    "COU" to "Unidade de Valor Real",
    "CRC" to "Colón costarriquenho",
    "CSD" to "Dinar sérvio (2002–2006)",
    "CSK" to "Coroa Forte checoslovaca",
    "CUC" to "Peso cubano conversível",
    "CUP" to "Peso cubano",
    "CVE" to "Escudo cabo-verdiano",
    "CYP" to "Libra cipriota",
    "CZK" to "Coroa tcheca",
    "DDM" to "Ostmark da Alemanha Oriental",
    "DEM" to "Marco alemão",
    "DJF" to "Franco djiboutiano",
    "DKK" to "Coroa dinamarquesa",
    "DOP" to "Peso dominicano",
    "DZD" to "Dinar argelino",
    "ECS" to "Sucre equatoriano",
    "ECV" to "Unidade de Valor Constante (UVC) do Equador",
    "EEK" to "Coroa estoniana",
    "EGP" to "Libra egípcia",
    "ERN" to "Nakfa da Eritreia",
    "ESA" to "Peseta espanhola (conta A)",
    "ESB" to "Peseta espanhola (conta conversível)",
    "ESP" to "Peseta espanhola",
    "ETB" to "Birr etíope",
    "EUR" to "Euro",
    "FIM" to "Marca finlandesa",
    "FJD" to "Dólar fijiano",
    "FKP" to "Libra malvinense",
    "FRF" to "Franco francês",
    "GBP" to "Libra esterlina",
    "GEK" to "Cupom Lari georgiano",
    "GEL" to "Lari georgiano",
    "GHC" to "Cedi de Gana (1979–2007)",
    "GHS" to "Cedi ganês",
    "GIP" to "Libra de Gibraltar",
    "GMD" to "Dalasi gambiano",
    "GNF" to "Franco guineano",
    "GNS" to "Syli da Guiné",
    "GQE" to "Ekwele da Guiné Equatorial",
    "GRD" to "Dracma grego",
    "GTQ" to "Quetzal guatemalteco",
    "GWE" to "Escudo da Guiné Portuguesa",
    "GWP" to "Peso da Guiné-Bissau",
    "GYD" to "Dólar guianense",
    "HKD" to "Dólar de Hong Kong",
    "HNL" to "Lempira hondurenha",
    "HRD" to "Dinar croata",
    "HRK" to "Kuna croata",
    "HTG" to "Gourde haitiano",
    "HUF" to "Florim húngaro",
    "IDR" to "Rupia indonésia",
    "IEP" to "Libra irlandesa",
    "ILP" to "Libra israelita",
    "ILR" to "Sheqel antigo israelita",
    "ILS" to "Novo shekel israelense",
    "INR" to "Rupia indiana",
    "IQD" to "Dinar iraquiano",
    "IRR" to "Rial iraniano",
    "ISJ" to "Coroa antiga islandesa",
    "ISK" to "Coroa islandesa",
    "ITL" to "Lira italiana",
    "JMD" to "Dólar jamaicano",
    "JOD" to "Dinar jordaniano",
    "JPY" to "Iene japonês",
    "KES" to "Xelim queniano",
    "KGS" to "Som quirguiz",
    "KHR" to "Riel cambojano",
    "KMF" to "Franco comoriano",
    "KPW" to "Won norte-coreano",
    "KRH" to "Hwan da Coreia do Sul (1953–1962)",
    "KRO" to "Won da Coreia do Sul (1945–1953)",
    "KRW" to "Won sul-coreano",
    "KWD" to "Dinar kuwaitiano",
    "KYD" to "Dólar das Ilhas Cayman",
    "KZT" to "Tenge cazaque",
    "LAK" to "Kip laosiano",
    "LBP" to "Libra libanesa",
    "LKR" to "Rupia cingalesa",
    "LRD" to "Dólar liberiano",
    "LSL" to "Loti lesotiano",
    "LTL" to "Litas lituano",
    "LTT" to "Talonas lituano",
    "LUC" to "Franco conversível de Luxemburgo",
    "LUF" to "Franco luxemburguês",
    "LUL" to "Franco financeiro de Luxemburgo",
    "LVL" to "Lats letão",
    "LVR" to "Rublo letão",
    "LYD" to "Dinar líbio",
    "MAD" to "Dirham marroquino",
    "MAF" to "Franco marroquino",
    "MCF" to "Franco monegasco",
    "MDC" to "Cupon moldávio",
    "MDL" to "Leu moldávio",
    "MGA" to "Ariary malgaxe",
    "MGF" to "Franco de Madagascar",
    "MKD" to "Dinar macedônio",
    "MKN" to "Dinar macedônio (1992–1993)",
    "MLF" to "Franco de Mali",
    "MMK" to "Quiate mianmarense",
    "MNT" to "Tugrik mongol",
    "MOP" to "Pataca macaense",
    "MRO" to "Ouguiya mauritana (1973–2017)",
    "MRU" to "Ouguiya mauritana",
    "MTL" to "Lira maltesa",
    "MTP" to "Libra maltesa",
    "MUR" to "Rupia mauriciana",
    "MVR" to "Rupia maldivana",
    "MWK" to "Kwacha malauiana",
    "MXN" to "Peso mexicano",
    "MXP" to "Peso Prata mexicano (1861–1992)",
    "MXV" to "Unidade Mexicana de Investimento (UDI)",
    "MYR" to "Ringgit malaio",
    "MZE" to "Escudo de Moçambique",
    "MZM" to "Metical de Moçambique (1980–2006)",
    "MZN" to "Metical moçambicano",
    "NAD" to "Dólar namibiano",
    "NGN" to "Naira nigeriana",
    "NIC" to "Córdoba nicaraguense (1988–1991)",
    "NIO" to "Córdoba nicaraguense",
    "NLG" to "Florim holandês",
    "NOK" to "Coroa norueguesa",
    "NPR" to "Rupia nepalesa",
    "NZD" to "Dólar neozelandês",
    "OMR" to "Rial omanense",
    "PAB" to "Balboa panamenho",
    "PEI" to "Inti peruano",
    "PEN" to "Novo sol peruano",
    "PES" to "Sol peruano (1863–1965)",
    "PGK" to "Kina papuásia",
    "PHP" to "Peso filipino",
    "PKR" to "Rupia paquistanesa",
    "PLN" to "Zloty polonês",
    "PLZ" to "Zloti polonês (1950–1995)",
    "PTE" to "Escudo português",
    "PYG" to "Guarani paraguaio",
    "QAR" to "Rial catariano",
    "RHD" to "Dólar rodesiano",
    "ROL" to "Leu romeno (1952–2006)",
    "RON" to "Leu romeno",
    "RSD" to "Dinar sérvio",
    "RUB" to "Rublo russo",
    "RUR" to "Rublo russo (1991–1998)",
    "RWF" to "Franco ruandês",
    "SAR" to "Riyal saudita",
    "SBD" to "Dólar das Ilhas Salomão",
    "SCR" to "Rupia seichelense",
    "SDD" to "Dinar sudanês (1992–2007)",
    "SDG" to "Libra sudanesa",
    "SDP" to "Libra sudanesa (1957–1998)",
    "SEK" to "Coroa sueca",
    "SGD" to "Dólar singapuriano",
    "SHP" to "Libra de Santa Helena",
    "SIT" to "Tolar Bons esloveno",
    "SKK" to "Coroa eslovaca",
    "SLE" to "Leone de Serra Leoa",
    "SLL" to "Leone de Serra Leoa (1964—2022)",
    "SOS" to "Xelim somali",
    "SRD" to "Dólar surinamês",
    "SRG" to "Florim do Suriname",
    "SSP" to "Libra sul-sudanesa",
    "STD" to "Dobra de São Tomé e Príncipe (1977–2017)",
    "STN" to "Dobra de São Tomé e Príncipe",
    "SUR" to "Rublo soviético",
    "SVC" to "Colom salvadorenho",
    "SYP" to "Libra síria",
    "SZL" to "Lilangeni suazi",
    "THB" to "Baht tailandês",
    "TJR" to "Rublo do Tadjiquistão",
    "TJS" to "Somoni tadjique",
    "TMM" to "Manat do Turcomenistão (1993–2009)",
    "TMT" to "Manat turcomeno",
    "TND" to "Dinar tunisiano",
    "TOP" to "Paʻanga tonganesa",
    "TPE" to "Escudo timorense",
    "TRL" to "Lira turca (1922–2005)",
    "TRY" to "Lira turca",
    "TTD" to "Dólar de Trinidad e Tobago",
    "TWD" to "Novo dólar taiwanês",
    "TZS" to "Xelim tanzaniano",
    "UAH" to "Hryvnia ucraniano",
    "UAK" to "Karbovanetz ucraniano",
    "UGS" to "Xelim ugandense (1966–1987)",
    "UGX" to "Xelim ugandense",
    "USD" to "Dólar americano",
    "USN" to "Dólar norte-americano (Dia seguinte)",
    "USS" to "Dólar norte-americano (Mesmo dia)",
    "UYI" to "Peso uruguaio en unidades indexadas",
    "UYP" to "Peso uruguaio (1975–1993)",
    "UYU" to "Peso uruguaio",
    "UZS" to "Som uzbeque",
    "VEB" to "Bolívar venezuelano (1871–2008)",
    "VEF" to "Bolívar venezuelano (2008–2018)",
    "VES" to "Bolívar venezuelano",
    "VND" to "Dong vietnamita",
    "VNN" to "Dong vietnamita (1978–1985)",
    "VUV" to "Vatu de Vanuatu",
    "WST" to "Tala samoano",
    "XAF" to "Franco CFA de BEAC",
    "XAG" to "Prata",
    "XAU" to "Ouro",
    "XBA" to "Unidade Composta Europeia",
    "XBB" to "Unidade Monetária Europeia",
    "XBC" to "Unidade de Conta Europeia (XBC)",
    "XBD" to "Unidade de Conta Europeia (XBD)",
    "XCD" to "Dólar do Caribe Oriental",
    "XDR" to "Direitos Especiais de Giro",
    "XEU" to "Unidade de Moeda Europeia",
    "XFO" to "Franco-ouro francês",
    "XFU" to "Franco UIC francês",
    "XOF" to "Franco CFA de BCEAO",
    "XPD" to "Paládio",
    "XPF" to "Franco CFP",
    "XPT" to "Platina",
    "XRE" to "Fundos RINET",
    "XTS" to "Código de Moeda de Teste",
    "XXX" to "Moeda desconhecida",
    "YDD" to "Dinar iemenita",
    "YER" to "Rial iemenita",
    "YUD" to "Dinar forte iugoslavo (1966–1990)",
    "YUM" to "Dinar noviy iugoslavo (1994–2002)",
    "YUN" to "Dinar conversível iugoslavo (1990–1992)",
    "YUR" to "Dinar reformado iugoslavo (1992–1993)",
    "ZAL" to "Rand sul-africano (financeiro)",
    "ZAR" to "Rand sul-africano",
    "ZMK" to "Cuacha zambiano (1968–2012)",
    "ZMW" to "Kwacha zambiano",
    "ZRN" to "Zaire Novo zairense (1993–1998)",
    "ZRZ" to "Zaire zairense (1971–1993)",
    "ZWD" to "Dólar do Zimbábue (1980–2008)",
    "ZWL" to "Dólar do Zimbábue (2009)",
    "ZWR" to "Dólar do Zimbábue (2008)",
  ) }

  val pt_AO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "dirham dos Emirados Árabes Unidos",
    "AFA" to "Afeghani (1927–2002)",
    "AFN" to "afegâni afegão",
    "ALL" to "lek albanês",
    "AMD" to "dram arménio",
    "ANG" to "florim das Antilhas Holandesas",
    "AOA" to "kwanza angolano",
    "ARS" to "peso argentino",
    "AUD" to "dólar australiano",
    "AWG" to "florim de Aruba",
    "AZN" to "manat azeri",
    "BAD" to "Dinar da Bósnia-Herzegóvina",
    "BAM" to "marco bósnio-herzegóvino conversível",
    "BBD" to "dólar barbadense",
    "BDT" to "taka bengali",
    "BEC" to "Franco belga (convertível)",
    "BGN" to "lev búlgaro",
    "BHD" to "dinar baremita",
    "BIF" to "franco burundiano",
    "BMD" to "dólar bermudense",
    "BND" to "dólar bruneano",
    "BOB" to "boliviano",
    "BRL" to "real brasileiro",
    "BSD" to "dólar das Bahamas",
    "BTN" to "ngultrum butanês",
    "BWP" to "pula de Botswana",
    "BYB" to "Rublo novo bielorusso (1994–1999)",
    "BYN" to "rublo bielorrusso",
    "BZD" to "dólar belizense",
    "CAD" to "dólar canadiano",
    "CDF" to "franco congolês",
    "CHF" to "franco suíço",
    "CLP" to "peso chileno",
    "CNH" to "yuan offshore",
    "CNY" to "yuan",
    "COP" to "peso colombiano",
    "CRC" to "colon costa-riquenho",
    "CUC" to "peso cubano conversível",
    "CUP" to "peso cubano",
    "CVE" to "escudo cabo-verdiano",
    "CYP" to "Libra de Chipre",
    "CZK" to "coroa checa",
    "DJF" to "franco jibutiano",
    "DKK" to "coroa dinamarquesa",
    "DOP" to "peso dominicano",
    "DZD" to "dinar argelino",
    "ECV" to "Unidad de Valor Constante (UVC) do Equador",
    "EGP" to "libra egípcia",
    "ERN" to "nakfa eritreia",
    "ETB" to "birr etíope",
    "EUR" to "euro",
    "FJD" to "dólar fijiano",
    "FKP" to "libra das Ilhas Falkland",
    "GBP" to "libra esterlina britânica",
    "GEL" to "lari georgiano",
    "GHS" to "cedi ganês",
    "GIP" to "libra de Gibraltar",
    "GMD" to "dalasi gambiano",
    "GNF" to "franco guineense",
    "GTQ" to "quetzal da Guatemala",
    "GYD" to "dólar da Guiana",
    "HKD" to "dólar de Hong Kong",
    "HNL" to "lempira das Honduras",
    "HRK" to "kuna croata",
    "HTG" to "gourde haitiano",
    "HUF" to "forint húngaro",
    "IDR" to "rupia indonésia",
    "ILS" to "sheqel novo israelita",
    "INR" to "rupia indiana",
    "IQD" to "dinar iraquiano",
    "IRR" to "rial iraniano",
    "ISK" to "coroa islandesa",
    "JMD" to "dólar jamaicano",
    "JOD" to "dinar jordaniano",
    "JPY" to "iene japonês",
    "KES" to "xelim queniano",
    "KGS" to "som quirguiz",
    "KHR" to "riel cambojano",
    "KMF" to "franco comoriano",
    "KPW" to "won norte-coreano",
    "KRW" to "won sul-coreano",
    "KWD" to "dinar kuwaitiano",
    "KYD" to "dólar das Ilhas Caimão",
    "KZT" to "tenge cazaque",
    "LAK" to "kip laosiano",
    "LBP" to "libra libanesa",
    "LKR" to "rupia do Sri Lanka",
    "LRD" to "dólar liberiano",
    "LSL" to "loti lesotiano",
    "LTL" to "Litas da Lituânia",
    "LVL" to "Lats da Letónia",
    "LYD" to "dinar líbio",
    "MAD" to "dirham marroquino",
    "MDL" to "leu moldavo",
    "MGA" to "ariari malgaxe",
    "MKD" to "dinar macedónio",
    "MMK" to "kyat de Mianmar",
    "MNT" to "tugrik mongol",
    "MOP" to "pataca macaense",
    "MRO" to "ouguiya mauritana (1973–2017)",
    "MRU" to "ouguiya mauritana",
    "MUR" to "rupia mauriciana",
    "MVR" to "rupia maldivana",
    "MWK" to "kwacha malauiano",
    "MXN" to "peso mexicano",
    "MXP" to "Peso Plata mexicano (1861–1992)",
    "MXV" to "Unidad de Inversion (UDI) mexicana",
    "MYR" to "ringgit malaio",
    "MZN" to "metical moçambicano",
    "NAD" to "dólar namibiano",
    "NGN" to "naira nigeriana",
    "NIC" to "Córdoba nicaraguano (1988–1991)",
    "NIO" to "córdoba nicaraguano",
    "NOK" to "coroa norueguesa",
    "NPR" to "rupia nepalesa",
    "NZD" to "dólar neozelandês",
    "OMR" to "rial omanense",
    "PAB" to "balboa do Panamá",
    "PEN" to "sol peruano",
    "PGK" to "kina papuásia",
    "PHP" to "peso filipino",
    "PKR" to "rupia paquistanesa",
    "PLN" to "zloti polaco",
    "PTE" to "escudo português",
    "PYG" to "guarani paraguaio",
    "QAR" to "rial catarense",
    "RON" to "leu romeno",
    "RSD" to "dinar sérvio",
    "RUB" to "rublo russo",
    "RWF" to "franco ruandês",
    "SAR" to "rial saudita",
    "SBD" to "dólar das Ilhas Salomão",
    "SCR" to "rupia seichelense",
    "SDG" to "libra sudanesa",
    "SEK" to "coroa sueca",
    "SGD" to "dólar singapuriano",
    "SHP" to "libra santa-helenense",
    "SLE" to "leone de Serra Leoa",
    "SLL" to "leone de Serra Leoa (1964—2022)",
    "SOS" to "xelim somali",
    "SRD" to "dólar do Suriname",
    "SSP" to "libra sul-sudanesa",
    "STN" to "dobra de São Tomé e Príncipe",
    "SYP" to "libra síria",
    "SZL" to "lilangeni suázi",
    "THB" to "baht tailandês",
    "TJS" to "somoni tajique",
    "TMT" to "manat turcomeno",
    "TND" to "dinar tunisino",
    "TOP" to "paʻanga tonganesa",
    "TRY" to "lira turca",
    "TTD" to "dólar de Trindade e Tobago",
    "TWD" to "novo dólar taiwanês",
    "TZS" to "xelim tanzaniano",
    "UAH" to "hryvnia ucraniano",
    "UGX" to "xelim ugandense",
    "USD" to "dólar dos Estados Unidos",
    "UYU" to "peso uruguaio",
    "UZS" to "som uzbeque",
    "VEF" to "bolívar (2008–2018)",
    "VES" to "bolívar",
    "VND" to "dong vietnamita",
    "VUV" to "vatu de Vanuatu",
    "WST" to "tala samoano",
    "XAF" to "franco CFA (BEAC)",
    "XCD" to "dólar das Caraíbas Orientais",
    "XOF" to "franco CFA (BCEAO)",
    "XPF" to "franco CFP",
    "XXX" to "moeda desconhecida",
    "YER" to "rial iemenita",
    "ZAR" to "rand sul-africano",
    "ZMK" to "Kwacha zambiano (1968–2012)",
    "ZMW" to "kwacha zambiano",
  ) }

  val pt_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "dirham dos Emirados Árabes Unidos",
    "AFA" to "Afeghani (1927–2002)",
    "AFN" to "afegâni afegão",
    "ALL" to "lek albanês",
    "AMD" to "dram arménio",
    "ANG" to "florim das Antilhas Holandesas",
    "AOA" to "kwanza angolano",
    "ARS" to "peso argentino",
    "AUD" to "dólar australiano",
    "AWG" to "florim de Aruba",
    "AZN" to "manat azeri",
    "BAD" to "Dinar da Bósnia-Herzegóvina",
    "BAM" to "marco bósnio-herzegóvino conversível",
    "BBD" to "dólar barbadense",
    "BDT" to "taka bengali",
    "BEC" to "Franco belga (convertível)",
    "BGN" to "lev búlgaro",
    "BHD" to "dinar baremita",
    "BIF" to "franco burundiano",
    "BMD" to "dólar bermudense",
    "BND" to "dólar bruneano",
    "BOB" to "boliviano",
    "BRL" to "real brasileiro",
    "BSD" to "dólar das Bahamas",
    "BTN" to "ngultrum butanês",
    "BWP" to "pula de Botswana",
    "BYB" to "Rublo novo bielorusso (1994–1999)",
    "BYN" to "rublo bielorrusso",
    "BZD" to "dólar belizense",
    "CAD" to "dólar canadiano",
    "CDF" to "franco congolês",
    "CHF" to "franco suíço",
    "CLP" to "peso chileno",
    "CNH" to "yuan offshore",
    "CNY" to "yuan",
    "COP" to "peso colombiano",
    "CRC" to "colon costa-riquenho",
    "CUC" to "peso cubano conversível",
    "CUP" to "peso cubano",
    "CVE" to "escudo cabo-verdiano",
    "CYP" to "Libra de Chipre",
    "CZK" to "coroa checa",
    "DJF" to "franco jibutiano",
    "DKK" to "coroa dinamarquesa",
    "DOP" to "peso dominicano",
    "DZD" to "dinar argelino",
    "ECV" to "Unidad de Valor Constante (UVC) do Equador",
    "EGP" to "libra egípcia",
    "ERN" to "nakfa eritreia",
    "ETB" to "birr etíope",
    "EUR" to "euro",
    "FJD" to "dólar fijiano",
    "FKP" to "libra das Ilhas Falkland",
    "GBP" to "libra esterlina britânica",
    "GEL" to "lari georgiano",
    "GHS" to "cedi ganês",
    "GIP" to "libra de Gibraltar",
    "GMD" to "dalasi gambiano",
    "GNF" to "franco guineense",
    "GTQ" to "quetzal da Guatemala",
    "GYD" to "dólar da Guiana",
    "HKD" to "dólar de Hong Kong",
    "HNL" to "lempira das Honduras",
    "HRK" to "kuna croata",
    "HTG" to "gourde haitiano",
    "HUF" to "forint húngaro",
    "IDR" to "rupia indonésia",
    "ILS" to "sheqel novo israelita",
    "INR" to "rupia indiana",
    "IQD" to "dinar iraquiano",
    "IRR" to "rial iraniano",
    "ISK" to "coroa islandesa",
    "JMD" to "dólar jamaicano",
    "JOD" to "dinar jordaniano",
    "JPY" to "iene japonês",
    "KES" to "xelim queniano",
    "KGS" to "som quirguiz",
    "KHR" to "riel cambojano",
    "KMF" to "franco comoriano",
    "KPW" to "won norte-coreano",
    "KRW" to "won sul-coreano",
    "KWD" to "dinar kuwaitiano",
    "KYD" to "dólar das Ilhas Caimão",
    "KZT" to "tenge cazaque",
    "LAK" to "kip laosiano",
    "LBP" to "libra libanesa",
    "LKR" to "rupia do Sri Lanka",
    "LRD" to "dólar liberiano",
    "LSL" to "loti lesotiano",
    "LTL" to "Litas da Lituânia",
    "LVL" to "Lats da Letónia",
    "LYD" to "dinar líbio",
    "MAD" to "dirham marroquino",
    "MDL" to "leu moldavo",
    "MGA" to "ariari malgaxe",
    "MKD" to "dinar macedónio",
    "MMK" to "kyat de Mianmar",
    "MNT" to "tugrik mongol",
    "MOP" to "pataca macaense",
    "MRO" to "ouguiya mauritana (1973–2017)",
    "MRU" to "ouguiya mauritana",
    "MUR" to "rupia mauriciana",
    "MVR" to "rupia maldivana",
    "MWK" to "kwacha malauiano",
    "MXN" to "peso mexicano",
    "MXP" to "Peso Plata mexicano (1861–1992)",
    "MXV" to "Unidad de Inversion (UDI) mexicana",
    "MYR" to "ringgit malaio",
    "MZN" to "metical moçambicano",
    "NAD" to "dólar namibiano",
    "NGN" to "naira nigeriana",
    "NIC" to "Córdoba nicaraguano (1988–1991)",
    "NIO" to "córdoba nicaraguano",
    "NOK" to "coroa norueguesa",
    "NPR" to "rupia nepalesa",
    "NZD" to "dólar neozelandês",
    "OMR" to "rial omanense",
    "PAB" to "balboa do Panamá",
    "PEN" to "sol peruano",
    "PGK" to "kina papuásia",
    "PHP" to "peso filipino",
    "PKR" to "rupia paquistanesa",
    "PLN" to "zloti polaco",
    "PTE" to "escudo português",
    "PYG" to "guarani paraguaio",
    "QAR" to "rial catarense",
    "RON" to "leu romeno",
    "RSD" to "dinar sérvio",
    "RUB" to "rublo russo",
    "RWF" to "franco ruandês",
    "SAR" to "rial saudita",
    "SBD" to "dólar das Ilhas Salomão",
    "SCR" to "rupia seichelense",
    "SDG" to "libra sudanesa",
    "SEK" to "coroa sueca",
    "SGD" to "dólar singapuriano",
    "SHP" to "libra santa-helenense",
    "SLE" to "leone de Serra Leoa",
    "SLL" to "leone de Serra Leoa (1964—2022)",
    "SOS" to "xelim somali",
    "SRD" to "dólar do Suriname",
    "SSP" to "libra sul-sudanesa",
    "STN" to "dobra de São Tomé e Príncipe",
    "SYP" to "libra síria",
    "SZL" to "lilangeni suázi",
    "THB" to "baht tailandês",
    "TJS" to "somoni tajique",
    "TMT" to "manat turcomeno",
    "TND" to "dinar tunisino",
    "TOP" to "paʻanga tonganesa",
    "TRY" to "lira turca",
    "TTD" to "dólar de Trindade e Tobago",
    "TWD" to "novo dólar taiwanês",
    "TZS" to "xelim tanzaniano",
    "UAH" to "hryvnia ucraniano",
    "UGX" to "xelim ugandense",
    "USD" to "dólar dos Estados Unidos",
    "UYU" to "peso uruguaio",
    "UZS" to "som uzbeque",
    "VEF" to "bolívar (2008–2018)",
    "VES" to "bolívar",
    "VND" to "dong vietnamita",
    "VUV" to "vatu de Vanuatu",
    "WST" to "tala samoano",
    "XAF" to "franco CFA (BEAC)",
    "XCD" to "dólar das Caraíbas Orientais",
    "XOF" to "franco CFA (BCEAO)",
    "XPF" to "franco CFP",
    "XXX" to "moeda desconhecida",
    "YER" to "rial iemenita",
    "ZAR" to "rand sul-africano",
    "ZMK" to "Kwacha zambiano (1968–2012)",
    "ZMW" to "kwacha zambiano",
  ) }

  val pt_CV: ImmutableMap<String, String> by lazy { immutableMapOf(
    "AED" to "dirham dos Emirados Árabes Unidos",
    "AFA" to "Afeghani (1927–2002)",
    "AFN" to "afegâni afegão",
    "ALL" to "lek albanês",
    "AMD" to "dram arménio",
    "ANG" to "florim das Antilhas Holandesas",
    "AOA" to "kwanza angolano",
    "ARS" to "peso argentino",
    "AUD" to "dólar australiano",
    "AWG" to "florim de Aruba",
    "AZN" to "manat azeri",
    "BAD" to "Dinar da Bósnia-Herzegóvina",
    "BAM" to "marco bósnio-herzegóvino conversível",
    "BBD" to "dólar barbadense",
    "BDT" to "taka bengali",
    "BEC" to "Franco belga (convertível)",
    "BGN" to "lev búlgaro",
    "BHD" to "dinar