package net.codinux.i18n

import kotlin.String
import net.codinux.collections.ImmutableMap
import net.codinux.collections.immutableMapOf

object LanguageDisplayNames {
  val ab: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ab" to "Аԥсшәа",
  ) }

  val af: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afar",
    "ab" to "Abkasies",
    "ace" to "Atsjenees",
    "ach" to "Akoli",
    "ada" to "Adangme",
    "ady" to "Adyghe",
    "af" to "Afrikaans",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "ale" to "Aleut",
    "alt" to "Suid-Altai",
    "am" to "Amharies",
    "an" to "Aragonees",
    "ann" to "Obolo",
    "anp" to "Angika",
    "ar" to "Arabies",
    "ar-001" to "Moderne Standaardarabies",
    "arc" to "Aramees",
    "arn" to "Mapuche",
    "arp" to "Arapaho",
    "ars" to "Najdi-Arabies",
    "as" to "Assamees",
    "asa" to "Asu",
    "ast" to "Asturies",
    "atj" to "Atikamekw",
    "av" to "Avaries",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Azerbeidjans",
    "az-alt-short" to "Azeri",
    "ba" to "Baskir",
    "ban" to "Balinees",
    "bas" to "Basaa",
    "be" to "Belarussies",
    "bem" to "Bemba",
    "bez" to "Bena",
    "bg" to "Bulgaars",
    "bgc" to "Haryanvi",
    "bgn" to "Wes-Balochi",
    "bho" to "Bhojpuri",
    "bi" to "Bislama",
    "bin" to "Bini",
    "bla" to "Siksika",
    "blo" to "Anii",
    "bm" to "Bambara",
    "bn" to "Bengaals",
    "bo" to "Tibettaans",
    "br" to "Bretons",
    "brx" to "Bodo",
    "bs" to "Bosnies",
    "bug" to "Buginees",
    "byn" to "Blin",
    "ca" to "Katalaans",
    "cay" to "Cayuga",
    "ccp" to "Tsjaakma",
    "ce" to "Tsjetsjeens",
    "ceb" to "Cebuano",
    "cgg" to "Kiga",
    "ch" to "Chamorro",
    "chk" to "Chuukees",
    "chm" to "Mari",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokees",
    "chy" to "Cheyennees",
    "ckb" to "Sorani",
    "ckb-alt-menu" to "Sorani",
    "ckb-alt-variant" to "Koerdies Sorani",
    "clc" to "Tzilkotin",
    "co" to "Korsikaans",
    "cop" to "Kopties",
    "crg" to "Michif",
    "crj" to "Suidoos-Cree",
    "crk" to "Laagvlakte-Cree",
    "crl" to "Noordoos-Cree",
    "crm" to "Moose Cree",
    "crr" to "Carolina-Algonkin",
    "crs" to "Seselwa Franskreools",
    "cs" to "Tsjeggies",
    "csw" to "Swampy Cree",
    "cu" to "Kerkslawies",
    "cv" to "Chuvash",
    "cy" to "Wallies",
    "da" to "Deens",
    "dak" to "Dakotaans",
    "dar" to "Dakota",
    "dav" to "Taita",
    "de" to "Duits",
    "dgr" to "Dogrib",
    "dje" to "Zarma",
    "doi" to "Dogri",
    "dsb" to "Nedersorbies",
    "dua" to "Duala",
    "dv" to "Divehi",
    "dyo" to "Jola-Fonyi",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "egy" to "Antieke Egipties",
    "eka" to "Ekajuk",
    "el" to "Grieks",
    "en" to "Engels",
    "en-GB" to "Engels (VK)",
    "en-GB-alt-short" to "Engels (VK)",
    "en-US" to "Engels (VSA)",
    "en-US-alt-short" to "Engels (VSA)",
    "eo" to "Esperanto",
    "es" to "Spaans",
    "et" to "Estnies",
    "eu" to "Baskies",
    "ewo" to "Ewondo",
    "fa" to "Persies",
    "fa-AF" to "Dari",
    "ff" to "Fulah",
    "fi" to "Fins",
    "fil" to "Filippyns",
    "fj" to "Fidjiaans",
    "fo" to "Faroëes",
    "fon" to "Fon",
    "fr" to "Frans",
    "frc" to "Cajun",
    "frr" to "Noord-Fries",
    "fur" to "Friuliaans",
    "fy" to "Fries",
    "ga" to "Iers",
    "gaa" to "Gaa",
    "gag" to "Gagauz",
    "gan" to "Gan-Sjinees",
    "gd" to "Skotse Gallies",
    "gez" to "Geez",
    "gil" to "Gilbertees",
    "gl" to "Galisies",
    "gn" to "Guarani",
    "gor" to "Gorontalo",
    "got" to "Goties",
    "grc" to "Antieke Grieks",
    "gsw" to "Switserse Duits",
    "gu" to "Goedjarati",
    "guz" to "Gusii",
    "gv" to "Manx",
    "gwi" to "Gwichʼin",
    "ha" to "Hausa",
    "hai" to "Haida",
    "hak" to "Hakka-Sjinees",
    "haw" to "Hawais",
    "hax" to "Suid-Haida",
    "he" to "Hebreeus",
    "hi" to "Hindi",
    "hi-Latn-alt-variant" to "Hingels",
    "hil" to "Hiligaynon",
    "hit" to "Hetities",
    "hmn" to "Hmong",
    "hr" to "Kroaties",
    "hsb" to "Oppersorbies",
    "hsn" to "Xiang-Sjinees",
    "ht" to "Haïtiaans",
    "hu" to "Hongaars",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Armeens",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Ibanees",
    "ibb" to "Ibibio",
    "id" to "Indonesies",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Sichuan Yi",
    "ikt" to "Wes-Kanadese Inoektitoet",
    "ilo" to "Iloko",
    "inh" to "Ingush",
    "io" to "Ido",
    "is" to "Yslands",
    "it" to "Italiaans",
    "iu" to "Inoektitoet",
    "ja" to "Japannees",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jv" to "Javaans",
    "ka" to "Georgies",
    "kab" to "Kabyle",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kbd" to "Kabardiaans",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kabuverdianu",
    "kfo" to "Koro",
    "kg" to "Kongolees",
    "kgp" to "Kaingang",
    "kha" to "Khasi",
    "khq" to "Koyra Chiini",
    "ki" to "Kikuyu",
    "kj" to "Kuanyama",
    "kk" to "Kazaks",
    "kkj" to "Kako",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Khmer",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Koreaans",
    "koi" to "Komi-Permyaks",
    "kok" to "Konkani",
    "kpe" to "Kpellees",
    "kr" to "Kanuri",
    "krc" to "Karachay-Balkar",
    "krl" to "Karelies",
    "kru" to "Kurukh",
    "ks" to "Kasjmiri",
    "ksb" to "Shambala",
    "ksf" to "Bafia",
    "ksh" to "Keuls",
    "ku" to "Koerdies",
    "kum" to "Kumyk",
    "kv" to "Komi",
    "kw" to "Kornies",
    "kwk" to "Kwak’wala",
    "kxv" to "Kuvi",
    "ky" to "Kirgisies",
    "la" to "Latyn",
    "lad" to "Ladino",
    "lag" to "Langi",
    "lb" to "Luxemburgs",
    "lez" to "Lezghies",
    "lg" to "Ganda",
    "li" to "Limburgs",
    "lij" to "Liguries",
    "lil" to "Lillooet",
    "lkt" to "Lakota",
    "lmo" to "Lombardies",
    "ln" to "Lingaals",
    "lo" to "Lao",
    "lou" to "Louisiana Kreool",
    "loz" to "Lozi",
    "lrc" to "Noord-Luri",
    "lsm" to "Saamia",
    "lt" to "Litaus",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lun" to "Lunda",
    "luo" to "Luo",
    "lus" to "Mizo",
    "luy" to "Luyia",
    "lv" to "Letties",
    "mad" to "Madurees",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Makasar",
    "mas" to "Masai",
    "mdf" to "Moksha",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisjen",
    "mg" to "Malgassies",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Meta’",
    "mh" to "Marshallees",
    "mi" to "Maori",
    "mic" to "Micmac",
    "min" to "Minangkabaus",
    "mk" to "Masedonies",
    "ml" to "Malabaars",
    "mn" to "Mongools",
    "mni" to "Manipuri",
    "moe" to "Innu-aimun",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Marathi",
    "ms" to "Maleis",
    "mt" to "Maltees",
    "mua" to "Mundang",
    "mul" to "Verskeie tale",
    "mus" to "Kreek",
    "mwl" to "Mirandees",
    "my" to "Birmaans",
    "myv" to "Erzya",
    "mzn" to "Masanderani",
    "na" to "Nauru",
    "nan" to "Min Nan-Sjinees",
    "nap" to "Neapolitaans",
    "naq" to "Nama",
    "nb" to "Boeknoors",
    "nd" to "Noord-Ndebele",
    "nds" to "Nederduits",
    "nds-NL" to "Nedersaksies",
    "ne" to "Nepalees",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niueaans",
    "nl" to "Nederlands",
    "nl-BE" to "Vlaams",
    "nmg" to "Kwasio",
    "nn" to "Nuwe Noors",
    "nnh" to "Ngiemboon",
    "no" to "Noors",
    "nog" to "Nogai",
    "nqo" to "N’Ko",
    "nr" to "Suid-Ndebele",
    "nso" to "Noord-Sotho",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "ny" to "Nyanja",
    "nyn" to "Nyankole",
    "oc" to "Oksitaans",
    "ojb" to "Noordwes-Ojibwa",
    "ojc" to "Sentraal-Ojibwa",
    "ojs" to "Oji-Cree",
    "ojw" to "Wes-Ojibwa",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Oriya",
    "os" to "Osseties",
    "pa" to "Pandjabi",
    "pag" to "Pangasinan",
    "pam" to "Pampanga",
    "pap" to "Papiamento",
    "pau" to "Palauaans",
    "pcm" to "Nigeriese Pidgin",
    "phn" to "Fenisies",
    "pis" to "Pijin",
    "pl" to "Pools",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Pruisies",
    "ps" to "Pasjtoe",
    "pt" to "Portugees",
    "qu" to "Quechua",
    "quc" to "K’iche’",
    "raj" to "Rajasthani",
    "rap" to "Rapanui",
    "rar" to "Rarotongaans",
    "rhg" to "Rohingya",
    "rm" to "Reto-Romaans",
    "rn" to "Rundi",
    "ro" to "Roemeens",
    "rof" to "Rombo",
    "ru" to "Russies",
    "rup" to "Aromanies",
    "rw" to "Rwandees",
    "rwk" to "Rwa",
    "sa" to "Sanskrit",
    "sad" to "Sandawees",
    "sah" to "Jakoeties",
    "saq" to "Samburu",
    "sat" to "Santalies",
    "sba" to "Ngambay",
    "sbp" to "Sangu",
    "sc" to "Sardinies",
    "scn" to "Sisiliaans",
    "sco" to "Skots",
    "sd" to "Sindhi",
    "sdh" to "Suid-Koerdies",
    "se" to "Noord-Sami",
    "seh" to "Sena",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "sh" to "Serwo-Kroaties",
    "shi" to "Tachelhit",
    "shn" to "Shan",
    "si" to "Sinhala",
    "sk" to "Slowaaks",
    "sl" to "Sloweens",
    "slh" to "Suid-Lushootseed",
    "sm" to "Samoaans",
    "sma" to "Suid-Sami",
    "smj" to "Lule Sami",
    "smn" to "Inari Sami",
    "sms" to "Skolt Sami",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somalies",
    "sq" to "Albanees",
    "sr" to "Serwies",
    "srn" to "Sranan Tongo",
    "ss" to "Swazi",
    "ssy" to "Saho",
    "st" to "Suid-Sotho",
    "str" to "Straits Salish",
    "su" to "Sundanees",
    "suk" to "Sukuma",
    "sv" to "Sweeds",
    "sw" to "Swahili",
    "swb" to "Comoraans",
    "syr" to "Siries",
    "szl" to "Silesies",
    "ta" to "Tamil",
    "tce" to "Suid-Tutchone",
    "te" to "Teloegoe",
    "tem" to "Timne",
    "teo" to "Teso",
    "tet" to "Tetoem",
    "tg" to "Tadjiks",
    "tgx" to "Tagish",
    "th" to "Thai",
    "tht" to "Tahltan",
    "ti" to "Tigrinja",
    "tig" to "Tigre",
    "tk" to "Turkmeens",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tn" to "Tswana",
    "to" to "Tongaans",
    "tok" to "Toki Pona",
    "tpi" to "Tok Pisin",
    "tr" to "Turks",
    "trv" to "Taroko",
    "ts" to "Tsonga",
    "tt" to "Tataars",
    "ttm" to "Noord-Tutchone",
    "tum" to "Toemboeka",
    "tvl" to "Tuvalu",
    "tw" to "Twi",
    "twq" to "Tasawaq",
    "ty" to "Tahities",
    "tyv" to "Tuvinees",
    "tzm" to "Sentraal-Atlas-Tamazight",
    "udm" to "Udmurt",
    "ug" to "Uighur",
    "uk" to "Oekraïens",
    "umb" to "Umbundu",
    "und" to "Onbekende taal",
    "ur" to "Oerdoe",
    "uz" to "Oesbekies",
    "vai" to "Vai",
    "ve" to "Venda",
    "vec" to "Venesiaans",
    "vi" to "Viëtnamees",
    "vmw" to "Makhuwa",
    "vo" to "Volapük",
    "vun" to "Vunjo",
    "wa" to "Walloon",
    "wae" to "Walser",
    "wal" to "Wolaytta",
    "war" to "Waray",
    "wbp" to "Warlpiri",
    "wo" to "Wolof",
    "wuu" to "Wu-Sjinees",
    "xal" to "Kalmyk",
    "xh" to "Xhosa",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Jiddisj",
    "yo" to "Joroeba",
    "yrl" to "Nheengatu",
    "yue" to "Kantonees",
    "yue-alt-menu" to "Kantonese Chinees",
    "za" to "Zhuang",
    "zgh" to "Standaard Marokkaanse Tamazight",
    "zh" to "Chinees",
    "zh-alt-menu" to "Mandarynse Chinees",
    "zh-Hans-alt-long" to "Mandarynse Chinees (Vereenvoudig)",
    "zh-Hant-alt-long" to "Mandarynse Chinees (Tradisioneel)",
    "zu" to "Zoeloe",
    "zun" to "Zuni",
    "zxx" to "Geen taalinhoud nie",
    "zza" to "Zaza",
  ) }

  val af_NA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val agq: ImmutableMap<String, String> by lazy { immutableMapOf(
    "agq" to "Aghem",
    "ak" to "Akan",
    "am" to "Àmalì",
    "ar" to "Àlabì",
    "be" to "Bɛ̀làlusàn",
    "bg" to "Bùugɨlìa",
    "bn" to "Bɨ̀ŋgalì",
    "cs" to "Chɛ̂",
    "de" to "Dzamɛ̀",
    "el" to "Gɨ̀lêʔ",
    "en" to "Kɨŋgele",
    "es" to "Sɨ̀kpanìs",
    "fa" to "Kpɛɛshìa",
    "fr" to "Kɨ̀fàlàŋsi",
    "ha" to "Kɨtsɔŋkaŋ",
    "hi" to "Endì",
    "hu" to "Hɔŋgalìa",
    "id" to "Èndònɛshìa",
    "ig" to "Egbò",
    "it" to "Ètalìa",
    "ja" to "Dzàkpànê",
    "jv" to "Dzàbvànê",
    "km" to "Kɨmɛ̀",
    "ko" to "kùulîa",
    "ms" to "Màlae",
    "my" to "Bùumɛsɛ̀",
    "ne" to "Nɛ̀kpalì",
    "nl" to "Dɔ̂s",
    "pa" to "Kpuwndzabì",
    "pl" to "Kpɔlìs",
    "pt" to "Kpotùwgîi",
    "ro" to "Lùmanyìa",
    "ru" to "Lushìa",
    "rw" to "Lùwandà",
    "so" to "Sòmalì",
    "sv" to "Suedìs",
    "ta" to "Tamì",
    "th" to "Tàe",
    "tr" to "Tʉʉkìs",
    "uk" to "Ùkɛlɛnìa",
    "ur" to "Uudùw",
    "vi" to "Vìyɛtnàmê",
    "yo" to "Yulùba",
    "zh" to "Chàenê",
    "zh-alt-menu" to "Chàenê",
    "zu" to "Zulù",
  ) }

  val ak: ImmutableMap<String, String> by lazy { immutableMapOf(
    "af" to "Afrikaans",
    "ak" to "Akan",
    "am" to "Amarik",
    "ar" to "Arabeke",
    "ar-001" to "Arabeke Kasa Nhyehyɛeɛ Foforɔ",
    "as" to "Asamese",
    "ast" to "Asturiani",
    "az" to "Asabegyanni",
    "az-alt-short" to "Asabegyanni",
    "be" to "Belarus kasa",
    "bg" to "Bɔlgeria kasa",
    "bgc" to "Harianvi",
    "bho" to "Bopuri",
    "blo" to "Anii",
    "bn" to "Bengali kasa",
    "br" to "Britenni",
    "brx" to "Bodo",
    "bs" to "Bosniani",
    "ca" to "Katalan",
    "ceb" to "Kebuano",
    "chr" to "Kiroki",
    "cs" to "Kyɛk kasa",
    "csw" to "Tadeɛm Kreefoɔ Kasa",
    "cv" to "Kyuvahyi",
    "cy" to "Wɛɛhye Kasa",
    "da" to "Dane kasa",
    "de" to "Gyaaman",
    "de-AT" to "Ɔstria Gyaaman",
    "de-CH" to "Swisalande Gyaaman",
    "doi" to "Dɔgri",
    "dsb" to "Sɔɔbia a ɛwɔ fam",
    "el" to "Greek kasa",
    "en" to "Borɔfo",
    "en-GB" to "Ngresi Borɔfo",
    "en-GB-alt-short" to "Ngresi Borɔfo",
    "en-US" to "Amɛrika Borɔfo",
    "en-US-alt-short" to "Amɛrika Borɔfo",
    "eo" to "Esperanto",
    "es" to "Spain kasa",
    "es-419" to "Spain kasa (Laaten Amɛrika)",
    "et" to "Estonia kasa",
    "eu" to "Baske",
    "fa" to "Pɛɛhyia kasa",
    "ff" to "Fula kasa",
    "fi" to "Finlande kasa",
    "fil" to "Filipin kasa",
    "fo" to "Farosi",
    "fr" to "Frɛnkye",
    "fr-CA" to "Kanada Frɛnkye",
    "fr-CH" to "Swisalande Frɛnkye",
    "fy" to "Atɔeɛ Fam Frihyia Kasa",
    "ga" to "Aerelande kasa",
    "gd" to "Skotlandfoɔ Galek Kasa",
    "gl" to "Galisia kasa",
    "gu" to "Gugyarata",
    "ha" to "Hausa",
    "he" to "Hibri kasa",
    "hi" to "Hindi",
    "hi-Latn" to "Laatenfoɔ Hindi",
    "hi-Latn-alt-variant" to "Hindibrɔfo",
    "hr" to "Kurowehyia kasa",
    "hsb" to "Atifi fam Sɔɔbia Kasa",
    "hu" to "Hangri kasa",
    "hy" to "Aameniani",
    "ia" to "Kasa ntam",
    "id" to "Indonihyia kasa",
    "ie" to "Kasa afrafra",
    "ig" to "Igbo kasa",
    "is" to "Aeslande kasa",
    "it" to "Italy kasa",
    "ja" to "Gyapan kasa",
    "jv" to "Gyabanis kasa",
    "ka" to "Gyɔɔgyia kasa",
    "kea" to "Kabuvadianu",
    "kgp" to "Kaingang",
    "kk" to "kasaki kasa",
    "km" to "Kambodia kasa",
    "kn" to "Kanada",
    "ko" to "Korea kasa",
    "kok" to "Konkani kasa",
    "ks" to "Kahyimiɛ",
    "ku" to "Kɛɛde kasa",
    "kxv" to "Kuvi kasa",
    "ky" to "Kɛgyese kasa",
    "lb" to "Lɔsimbɔge kasa",
    "lij" to "Liguria kasa",
    "lmo" to "Lombad kasa",
    "lo" to "Lawo kasa",
    "lt" to "Lituania kasa",
    "lv" to "Latvia kasa",
    "mai" to "Maetili",
    "mi" to "Mawori",
    "mk" to "Mɛsidonia kasa",
    "ml" to "Malayalam kasa",
    "mn" to "Mongoliafoɔ kasa",
    "mni" to "Manipuri",
    "mr" to "Marati",
    "ms" to "Malay kasa",
    "mt" to "Malta kasa",
    "mul" to "Kasa ahodoɔ",
    "my" to "Bɛɛmis kasa",
    "nds" to "Gyaaman kasa a ɛwɔ fam",
    "ne" to "Nɛpal kasa",
    "nl" to "Dɛɛkye",
    "nl-BE" to "Dɛɛkye (Bɛɛgyiɔm",
    "nn" to "Nɔwefoɔ Ninɔso",
    "no" to "Nɔwefoɔ kasa",
    "nqo" to "Nko",
    "oc" to "Osita kasa",
    "or" to "Odia",
    "pa" to "Pungyabi kasa",
    "pcm" to "Nigeriafoɔ Pigyin",
    "pl" to "Pɔland kasa",
    "prg" to "Prusia kasa",
    "ps" to "Pahyito",
    "pt" to "Pɔɔtugal kasa",
    "qu" to "Kwɛkya",
    "raj" to "Ragyasitan kasa",
    "rm" to "Romanhye kasa",
    "ro" to "Romenia kasa",
    "ru" to "Rahyia kasa",
    "rw" to "Rewanda kasa",
    "sa" to "Sanskrit kasa",
    "sah" to "Yakut Kasa",
    "sat" to "Santal kasa",
    "sc" to "Saadinia kasa",
    "sd" to "Sindi",
    "si" to "Sinhala",
    "sk" to "Slovak Kasa",
    "sl" to "Slovɛniafoɔ Kasa",
    "so" to "Somalia kasa",
    "sq" to "Aabeniani",
    "sr" to "Sɛbia Kasa",
    "su" to "Sunda Kasa",
    "sv" to "Sweden kasa",
    "sw" to "Swahili",
    "syr" to "Siiria Kasa",
    "szl" to "Silesiafoɔ Kasa",
    "ta" to "Tamil kasa",
    "te" to "Telugu",
    "tg" to "Tɛgyeke kasa",
    "th" to "Taeland kasa",
    "ti" to "Tigrinya kasa",
    "tk" to "Tɛkmɛnistan Kasa",
    "to" to "Tonga kasa",
    "tr" to "Tɛɛki kasa",
    "tt" to "Tata kasa",
    "ug" to "Yugaa Kasa",
    "uk" to "Ukren kasa",
    "und" to "kasa a yɛnnim",
    "ur" to "Urdu kasa",
    "uz" to "Usbɛkistan Kasa",
    "vec" to "Vɛnihyia Kasa",
    "vi" to "Viɛtnam kasa",
    "vmw" to "Makuwa",
    "wo" to "Wolɔfo Kasa",
    "xh" to "Hosa Kasa",
    "xnr" to "Kangri",
    "yo" to "Yoruba",
    "yrl" to "Ningatu",
    "yue" to "Kantonese",
    "yue-alt-menu" to "Kyaena Kantonese",
    "za" to "Zuang",
    "zh" to "Kyaena kasa",
    "zh-alt-menu" to "Madarin, Kyaena kasa",
    "zh-Hans" to "Kyaena kasa a emu yɛ mmrɛ",
    "zh-Hans-alt-long" to "Mandarin Kyaena kasa a emu yɛ mmrɛ",
    "zh-Hant" to "Tete Kyaena kasa",
    "zh-Hant-alt-long" to "Tete Mandarin Kyaena kasa",
    "zu" to "Zulu",
    "zxx" to "Lengwestese biara nnim",
  ) }

  val am: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "አፋርኛ",
    "ab" to "አብሐዚኛ",
    "ace" to "አቻይንኛ",
    "ach" to "አኮሊኛ",
    "ada" to "አዳንግሜ",
    "ady" to "አድይግሄ",
    "ae" to "አቬስታን",
    "af" to "አፍሪካንኛ",
    "afh" to "አፍሪሂሊ",
    "agq" to "አገም",
    "ain" to "አይኑ",
    "ak" to "አካንኛ",
    "akk" to "አካዲያን",
    "akz" to "አላባማ",
    "ale" to "አልዩት",
    "alt" to "ደቡባዊ አልታይ",
    "am" to "አማርኛ",
    "an" to "አራጎንስ",
    "ann" to "ኦቦሎ",
    "anp" to "አንጊካ",
    "ar" to "ዓረብኛ",
    "ar-001" to "ዘመናዊ መደበኛ ዓረብኛ",
    "arc" to "አራማይክ",
    "arn" to "ማፑቼ",
    "aro" to "አራኦና",
    "arp" to "አራፓሆ",
    "arq" to "የአልጄሪያ ዓረብኛ",
    "ars" to "ናጅዲ አረብኛ",
    "arw" to "አራዋክ",
    "as" to "አሳሜዝ",
    "asa" to "አሱ",
    "ase" to "የአሜሪካ የምልክት ቋንቋ",
    "ast" to "አስቱሪያንኛ",
    "atj" to "አቲካምከው",
    "av" to "አቫሪክ",
    "awa" to "አዋድሂ",
    "ay" to "አያማርኛ",
    "az" to "አዘርባጃንኛ",
    "az-alt-short" to "አዜሪ",
    "ba" to "ባስኪርኛ",
    "bal" to "ባሉቺ",
    "ban" to "ባሊኔስ",
    "bar" to "ባቫሪያን",
    "bas" to "ባሳ",
    "bax" to "ባሙን",
    "bbc" to "ባታካ ቶባ",
    "be" to "ቤላራሻኛ",
    "bej" to "ቤጃ",
    "bem" to "ቤምባ",
    "bew" to "ቤታዊ",
    "bez" to "ቤና",
    "bfd" to "ባፉት",
    "bfq" to "ባዳጋ",
    "bg" to "ቡልጋሪኛ",
    "bgc" to "ሃርያንቪኛ",
    "bgn" to "የምዕራብ ባሎቺ",
    "bho" to "ቦጅፑሪ",
    "bi" to "ቢስላምኛ",
    "bik" to "ቢኮል",
    "bin" to "ቢኒ",
    "bjn" to "ባንጃር",
    "bla" to "ሲክሲካ",
    "blo" to "አኒኛ",
    "bm" to "ባምባርኛ",
    "bn" to "ቤንጋሊኛ",
    "bo" to "ቲቤታንኛ",
    "bpy" to "ቢሹንፑሪያ",
    "bqi" to "ባክህቲያሪ",
    "br" to "ብሬቶንኛ",
    "bra" to "ብራጅ",
    "brh" to "ብራሁዪ",
    "brx" to "ቦዶ",
    "bs" to "ቦስኒያንኛ",
    "bss" to "አኮስ",
    "bua" to "ቡሪያት",
    "bug" to "ቡጊኔዝ",
    "bum" to "ቡሉ",
    "byn" to "ብሊን",
    "ca" to "ካታላንኛ",
    "cad" to "ካዶ",
    "car" to "ካሪብ",
    "cay" to "ካዩጋ",
    "cch" to "አትሳም",
    "ccp" to "ቻክማ",
    "ce" to "ችችን",
    "ceb" to "ሴብዋኖ",
    "cgg" to "ቺጋኛ",
    "ch" to "ቻሞሮ",
    "chb" to "ቺብቻ",
    "chg" to "ቻጋታይ",
    "chk" to "ቹክስ",
    "chm" to "ማሪ",
    "chn" to "ቺኑክ ጃርጎን",
    "cho" to "ቾክታዋ",
    "chp" to "ቺፔውያን",
    "chr" to "ቼሮኬኛ",
    "chy" to "ችዬኔ",
    "ckb" to "የሶራኒ ኩርድኛ",
    "ckb-alt-menu" to "የሶራኒ ኩርድኛ",
    "ckb-alt-variant" to "የሶራኒ ኩርድኛ",
    "clc" to "ቺልኮቲን",
    "co" to "ኮርሲካኛ",
    "cop" to "ኮፕቲክ",
    "cps" to "ካፒዝኖን",
    "cr" to "ክሪ",
    "crg" to "ሚቺፍ",
    "crh" to "ክሪሚያን ተርኪሽ",
    "crj" to "ደቡብ ምዕራባዊ ክሪ",
    "crk" to "ፕላይንስ ክሪ",
    "crl" to "ሰሜን ምስራቃዊ ክሪ",
    "crm" to "ሙዝ ክሪ",
    "crr" to "ካሮሊና አልጎንክዊያን",
    "crs" to "ሰሰላዊ ክሬኦሊ ፈረንሳይኛ",
    "cs" to "ቼክኛ",
    "csw" to "ስዋምፒ ክሪ",
    "cu" to "ቸርች ስላቪክ",
    "cv" to "ቹቫሽኛ",
    "cy" to "ዌልሽ",
    "da" to "ዴኒሽ",
    "dak" to "ዳኮታ",
    "dar" to "ዳርግዋ",
    "dav" to "ታይታ",
    "de" to "ጀርመንኛ",
    "de-AT" to "የኦስትሪያ ጀርመንኛ",
    "de-CH" to "የስዊዝ ከፍተኛ ጀርመንኛ",
    "del" to "ዳላዌር",
    "dgr" to "ዶግሪብ",
    "din" to "ዲንካ",
    "dje" to "ዛርማኛ",
    "doi" to "ዶግሪ",
    "dsb" to "የታችኛው ሶርቢያኛ",
    "dtp" to "ሴንተራል ዱሰን",
    "dua" to "ዱዋላኛ",
    "dv" to "ዲቬሂ",
    "dyo" to "ጆላ-ፎንዪ",
    "dyu" to "ድዩላ",
    "dz" to "ድዞንግኻኛ",
    "dzg" to "ዳዛጋ",
    "ebu" to "ኢምቡ",
    "ee" to "ኢዊ",
    "efi" to "ኤፊክ",
    "egy" to "የጥንታዊ ግብጽኛ",
    "eka" to "ኤካጁክ",
    "el" to "ግሪክኛ",
    "en" to "እንግሊዝኛ",
    "en-AU" to "የአውስትራሊያ እንግሊዝኛ",
    "en-CA" to "የካናዳ እንግሊዝኛ",
    "en-GB" to "የብሪቲሽ እንግሊዝኛ",
    "en-GB-alt-short" to "የዩናይትድ ኪንግደም እንግሊዝኛ",
    "en-US" to "የአሜሪካ እንግሊዝኛ",
    "en-US-alt-short" to "የዩ ኤስ እንግሊዝኛ",
    "eo" to "ኤስፐራንቶ",
    "es" to "ስፓኒሽ",
    "es-419" to "የላቲን አሜሪካ ስፓኒሽ",
    "es-ES" to "የአውሮፓ ስፓኒሽ",
    "es-MX" to "የሜክሲኮ ስፓኒሽ",
    "esu" to "ሴንተራል ዩፒክ",
    "et" to "ኢስቶኒያንኛ",
    "eu" to "ባስክኛ",
    "ewo" to "ኤዎንዶ",
    "fa" to "ፐርሺያኛ",
    "fa-AF" to "ዳሪ",
    "ff" to "ፉላኒኛ",
    "fi" to "ፊንላንድኛ",
    "fil" to "ፊሊፒንኛ",
    "fj" to "ፊጂኛ",
    "fo" to "ፋሮኛ",
    "fon" to "ፎን",
    "fr" to "ፈረንሳይኛ",
    "fr-CA" to "የካናዳ ፈረንሳይኛ",
    "fr-CH" to "የስዊዝ ፈረንሳይኛ",
    "frc" to "ካጁን ፍሬንች",
    "frp" to "አርፒታን",
    "frr" to "ሰሜናዊ ፍሪስያን",
    "fur" to "ፍሩሊያን",
    "fy" to "ምዕራባዊ ፍሪሲኛ",
    "ga" to "አየርላንድኛ",
    "gaa" to "ጋ",
    "gag" to "ጋጉዝኛ",
    "gan" to "ጋን ቻይንኛ",
    "gd" to "የስኮትላንድ ጌይሊክ",
    "gez" to "ግዕዝኛ",
    "gil" to "ጅልበርትስ",
    "gl" to "ጋሊሺያንኛ",
    "gn" to "ጓራኒኛ",
    "gor" to "ጎሮንታሎ",
    "grc" to "የጥንታዊ ግሪክ",
    "gsw" to "ስዊዝ ጀርመንኛ",
    "gu" to "ጉጃርቲኛ",
    "guz" to "ጉስሊኛ",
    "gv" to "ማንክስ",
    "gwi" to "ግዊቺን",
    "ha" to "ሃውሳኛ",
    "hai" to "ሃይዳ",
    "hak" to "ሃካ ቻይንኛ",
    "haw" to "ሃዊያኛ",
    "hax" to "ደቡባዊ ሃይዳ",
    "he" to "ዕብራይስጥ",
    "hi" to "ሕንድኛ",
    "hi-Latn" to "ሕንድኛ (ላቲን)",
    "hi-Latn-alt-variant" to "ሕንድኛ (ላቲን)",
    "hil" to "ሂሊጋይኖን",
    "hmn" to "ህሞንግ",
    "hr" to "ክሮሽያንኛ",
    "hsb" to "የላይኛው ሶርቢያንኛ",
    "hsn" to "ዢያንግ ቻይንኛ",
    "ht" to "ሃይትኛ ክሮሌ",
    "hu" to "ሀንጋሪኛ",
    "hup" to "ሁፓ",
    "hur" to "ሃልኮመልም",
    "hy" to "አርሜንኛ",
    "hz" to "ሄሬሮ",
    "ia" to "ኢንቴርሊንጓ",
    "iba" to "ኢባን",
    "ibb" to "ኢቢብዮ",
    "id" to "ኢንዶኔዥያኛ",
    "ie" to "እንተርሊንግወ",
    "ig" to "ኢግቦኛ",
    "ii" to "ሲቹዋን ዪ",
    "ik" to "እኑፒያቅኛ",
    "ikt" to "የምዕራባዊ ካናዳ ኢኑክቲቱት",
    "ilo" to "ኢሎኮ",
    "inh" to "ኢንጉሽ",
    "io" to "ኢዶ",
    "is" to "አይስላንድኛ",
    "it" to "ጣሊያንኛ",
    "iu" to "እኑክቲቱትኛ",
    "ja" to "ጃፓንኛ",
    "jbo" to "ሎጅባን",
    "jgo" to "ንጎምባ",
    "jmc" to "ማቻሜኛ",
    "jv" to "ጃቫኛ",
    "ka" to "ጆርጂያንኛ",
    "kab" to "ካብይል",
    "kac" to "ካቺን",
    "kaj" to "ጅጁ",
    "kam" to "ካምባ",
    "kbd" to "ካባርዲያን",
    "kcg" to "ታያፕ",
    "kde" to "ማኮንዴ",
    "kea" to "ካቡቨርዲያኑ",
    "kfo" to "ኮሮ",
    "kg" to "ኮንጎኛ",
    "kgp" to "ካይንጋንግ",
    "kha" to "ካሲ",
    "khq" to "ኮይራ ቺኒ",
    "ki" to "ኪኩዩ",
    "kj" to "ኩዋንያማ",
    "kk" to "ካዛክኛ",
    "kkj" to "ካኮ",
    "kl" to "ካላሊሱት",
    "kln" to "ካለንጂን",
    "km" to "ክመር",
    "kmb" to "ኪምቡንዱ",
    "kn" to "ካናዳ",
    "ko" to "ኮሪያኛ",
    "koi" to "ኮሚ ፔርምያክ",
    "kok" to "ኮንካኒ",
    "kpe" to "ክፔሌ",
    "kr" to "ካኑሪ",
    "krc" to "ካራቻይ-ባልካር",
    "krl" to "ካረሊያን",
    "kru" to "ኩሩክ",
    "ks" to "ካሽሚርኛ",
    "ksb" to "ሻምባላ",
    "ksf" to "ባፊያ",
    "ksh" to "ኮሎኝኛ",
    "ku" to "ኩርድሽ",
    "kum" to "ኩማይክ",
    "kv" to "ኮሚ",
    "kw" to "ኮርኒሽ",
    "kwk" to "ክዋክዋላ",
    "kxv" to "ኩቪኛ",
    "ky" to "ክይርግይዝ",
    "la" to "ላቲንኛ",
    "lad" to "ላዲኖ",
    "lag" to "ላንጊ",
    "lb" to "ሉክሰምበርግኛ",
    "lez" to "ሌዝጊያን",
    "lg" to "ጋንዳኛ",
    "li" to "ሊምቡርጊሽ",
    "lij" to "ሊጓሪያኛ",
    "lil" to "ሊሎኤት",
    "lkt" to "ላኮታ",
    "lmo" to "ሎምባርድኛ",
    "ln" to "ሊንጋላ",
    "lo" to "ላኦኛ",
    "lou" to "ሉዊዚያና ክሬኦል",
    "loz" to "ሎዚ",
    "lrc" to "ሰሜናዊ ሉሪ",
    "lsm" to "ሳሚያ",
    "lt" to "ሊቱዌንያኛ",
    "lu" to "ሉባ-ካታንጋ",
    "lua" to "ሉባ-ሉሏ",
    "lun" to "ሉንዳ",
    "luo" to "ሉኦ",
    "lus" to "ሚዞ",
    "luy" to "ሉያ",
    "lv" to "ላትቪያኛ",
    "mad" to "ማዱረስ",
    "mag" to "ማጋሂ",
    "mai" to "ማይቲሊ",
    "mak" to "ማካሳር",
    "mas" to "ማሳይ",
    "mdf" to "ሞክሻ",
    "men" to "ሜንዴ",
    "mer" to "ሜሩ",
    "mfe" to "ሞሪስየን",
    "mg" to "ማላጋስይ",
    "mgh" to "ማኩዋ-ሜቶ",
    "mgo" to "ሜታ",
    "mh" to "ማርሻሊዝ",
    "mi" to "ማኦሪ",
    "mic" to "ሚክማው",
    "min" to "ሚናንግካባኡ",
    "mk" to "ሜቄዶንኛ",
    "ml" to "ማላያላም",
    "mn" to "ሞንጎሊያኛ",
    "mni" to "ማኒፑሪ",
    "moe" to "ኢኑ-አይመን",
    "moh" to "ሞሃውክ",
    "mos" to "ሞሲ",
    "mr" to "ማራቲ",
    "ms" to "ማላይ",
    "mt" to "ማልቲዝኛ",
    "mua" to "ሙንዳንግ",
    "mul" to "ባለብዙ ቋንቋዎች",
    "mus" to "ሙስኮኪ",
    "mwl" to "ሚራንዴዝ",
    "my" to "ቡርማኛ",
    "myv" to "ኤርዝያ",
    "mzn" to "ማዛንደራኒ",
    "na" to "ናኡሩ",
    "nan" to "ሚን ኛን ቻይንኛ",
    "nap" to "ኒአፖሊታን",
    "naq" to "ናማ",
    "nb" to "የኖርዌይ ቦክማል",
    "nd" to "ሰሜን ንዴብሌ",
    "nds" to "የታችኛው ጀርመንኛ",
    "nds-NL" to "የታችኛው ሳክሰን",
    "ne" to "ኔፓሊኛ",
    "new" to "ኒዋሪ(ኔፓል)",
    "ng" to "ንዶንጋ",
    "nia" to "ኒአስ",
    "niu" to "ኒዩአንኛ",
    "njo" to "ኦ ናጋ",
    "nl" to "ደች",
    "nl-BE" to "ፍሌሚሽ",
    "nmg" to "ክዋሲዮ",
    "nn" to "የኖርዌይ ናይኖርስክ",
    "nnh" to "ኒጊምቡን",
    "no" to "ኖርዌይኛ",
    "nog" to "ኖጋይ",
    "nqo" to "ንኮ",
    "nr" to "ደቡብ ንደቤሌ",
    "nso" to "ሰሜናዊ ሶቶ",
    "nus" to "ኑዌር",
    "nv" to "ናቫጆ",
    "nwc" to "ክላሲክ ኔዋሪ",
    "ny" to "ንያንጃ",
    "nyn" to "ኒያንኮል",
    "oc" to "ኦሲታን",
    "ojb" to "ሰሜን ምዕራባዊ ኦጂብዋ",
    "ojc" to "ማዕከላዊ ኦጂብዋ",
    "ojs" to "ኦጂ-ክሪ",
    "ojw" to "ምዕራባዊ ኦጂቡዋ",
    "oka" to "ኦካናጋን",
    "om" to "ኦሮሚኛ",
    "or" to "ኦዲያ",
    "os" to "ኦሴቲክ",
    "pa" to "ፑንጃብኛ",
    "pag" to "ፓንጋሲናን",
    "pam" to "ፓምፓንጋ",
    "pap" to "ፓፒያሜንቶ",
    "pau" to "ፓሉዋን",
    "pcm" to "የናይጄሪያ ፒጂን",
    "pis" to "ፒጂን",
    "pl" to "ፖሊሽ",
    "pqm" to "ማሊሴት-ፓሳማኩዎድይ",
    "prg" to "ፐሩሳንኛ",
    "ps" to "ፓሽቶ",
    "ps-alt-variant" to "ፑሽቶ",
    "pt" to "ፖርቹጋልኛ",
    "pt-BR" to "የብራዚል ፖርቹጋልኛ",
    "pt-PT" to "የአውሮፓ ፖርቹጋልኛ",
    "qu" to "ኩዌቹዋ",
    "quc" to "ኪቼ",
    "qug" to "ቺምቦራዞ ሃይላንድ ኩቹዋ",
    "raj" to "ራጃስታኒ",
    "rap" to "ራፓኑኢ",
    "rar" to "ራሮቶንጋን",
    "rhg" to "ሮሂንግያ",
    "rm" to "ሮማንሽ",
    "rn" to "ሩንዲ",
    "ro" to "ሮማኒያኛ",
    "ro-MD" to "ሞልዳቪያንኛ",
    "rof" to "ሮምቦ",
    "ru" to "ራሽያኛ",
    "rup" to "አሮማንያን",
    "rw" to "ኪንያርዋንዳ",
    "rwk" to "ርዋ",
    "sa" to "ሳንስክሪት",
    "sad" to "ሳንዳዌ",
    "sah" to "ያኩት",
    "saq" to "ሳምቡሩ",
    "sat" to "ሳንታሊ",
    "sba" to "ንጋምባይ",
    "sbp" to "ሳንጉ",
    "sc" to "ሳርዲንያን",
    "scn" to "ሲሲሊያንኛ",
    "sco" to "ስኮትስ",
    "sd" to "ሲንዲ",
    "sdh" to "ደቡባዊ ኩርዲሽ",
    "se" to "ሰሜናዊ ሳሚ",
    "seh" to "ሴና",
    "ses" to "ኮይራቦሮ ሴኒ",
    "sg" to "ሳንጎ",
    "sh" to "ሰርቦ-ክሮኤሽያኛ",
    "shi" to "ታቼልሂት",
    "shn" to "ሻን",
    "shu" to "ቻዲያን ዓረብኛ",
    "si" to "ሲንሃላ",
    "sid" to "ሲዳምኛ",
    "sk" to "ስሎቫክኛ",
    "sl" to "ስሎቬንኛ",
    "slh" to "ደቡባዊ ሉሹትሲድ",
    "sm" to "ሳሞኣን",
    "sma" to "ደቡባዊ ሳሚ",
    "smj" to "ሉሌ ሳሚ",
    "smn" to "ኢናሪ ሳሚ",
    "sms" to "ስኮልት ሳሚ",
    "sn" to "ሾና",
    "snk" to "ሶኒንኬ",
    "so" to "ሱማልኛ",
    "sq" to "አልባንያንኛ",
    "sr" to "ሰርብያኛ",
    "srn" to "ስራናን ቶንጎ",
    "ss" to "ስዋቲ",
    "ssy" to "ሳሆኛ",
    "st" to "ደቡባዊ ሶቶ",
    "str" to "ስትሬይትስ ስታሊሽ",
    "su" to "ሱዳንኛ",
    "suk" to "ሱኩማ",
    "sv" to "ስዊድንኛ",
    "sw" to "ስዋሂሊኛ",
    "sw-CD" to "ኮንጎ ስዋሂሊ",
    "swb" to "ኮሞሪያን",
    "syc" to "ክላሲክ ኔይራ",
    "syr" to "ሲሪያክ",
    "szl" to "ሲሌሲያኛ",
    "ta" to "ታሚል",
    "tce" to "ደቡባዊ ቱትቾን",
    "te" to "ተሉጉ",
    "tem" to "ቲምኔ",
    "teo" to "ቴሶ",
    "tet" to "ቴተም",
    "tg" to "ታጂክ",
    "tgx" to "ታጊሽ",
    "th" to "ታይ",
    "tht" to "ታህልታን",
    "ti" to "ትግርኛ",
    "tig" to "ትግረ",
    "tk" to "ቱርክሜን",
    "tl" to "ታጋሎገኛ",
    "tlh" to "ክሊንጎን",
    "tli" to "ትሊንጊት",
    "tn" to "ጽዋና",
    "to" to "ቶንጋን",
    "tok" to "ቶኪ ፖና",
    "tpi" to "ቶክ ፒሲን",
    "tr" to "ቱርክኛ",
    "trv" to "ታሮኮ",
    "ts" to "ጾንጋ",
    "tt" to "ታታር",
    "ttm" to "ሰሜናዊ ቱትቾን",
    "tum" to "ቱምቡካ",
    "tvl" to "ቱቫሉ",
    "tw" to "ትዊኛ",
    "twq" to "ታሳዋክ",
    "ty" to "ታሂታንኛ",
    "tyv" to "ቱቪንያንኛ",
    "tzm" to "መካከለኛው አትላስ ታማዚኛ",
    "udm" to "ኡድሙርት",
    "ug" to "ኡይግሁር",
    "uk" to "ዩክሬንኛ",
    "umb" to "ኡምቡንዱ",
    "und" to "ያልታወቀ ቋንቋ",
    "ur" to "ኡርዱኛ",
    "uz" to "ኡዝቤክኛ",
    "vai" to "ቫይ",
    "ve" to "ቬንዳ",
    "vec" to "ቬነቲያንኛ",
    "vi" to "ቪየትናምኛ",
    "vmw" to "ማክሁዋኛ",
    "vo" to "ቮላፑክኛ",
    "vun" to "ቩንጆ",
    "wa" to "ዋሎን",
    "wae" to "ዋልሰር",
    "wal" to "ወላይትኛ",
    "war" to "ዋራይ",
    "wbp" to "ዋርልፒሪ",
    "wo" to "ዎሎፍኛ",
    "wuu" to "ዉ ቻይንኛ",
    "xal" to "ካልማይክ",
    "xh" to "ዞሳኛ",
    "xnr" to "ካንጋሪ",
    "xog" to "ሶጋ",
    "yav" to "ያንግቤንኛ",
    "ybb" to "የምባ",
    "yi" to "ይዲሽኛ",
    "yo" to "ዮሩባዊኛ",
    "yrl" to "ንሄንጋቱ",
    "yue" to "ካንቶኒዝ",
    "yue-alt-menu" to "ካንቶኒዝ ቻይንኛ",
    "za" to "ዡዋንግኛ",
    "zbl" to "ብሊስይምቦልስ",
    "zgh" to "መደበኛ የሞሮኮ ታማዚግት",
    "zh" to "ቻይንኛ",
    "zh-alt-menu" to "ማንድሪን ቻይንኛ",
    "zh-Hans" to "ቀለል ያለ ቻይንኛ",
    "zh-Hans-alt-long" to "ቀለል ያለ ማንድሪን ቻይንኛ",
    "zh-Hant" to "ባህላዊ ቻይንኛ",
    "zh-Hant-alt-long" to "ባህላዊ ማንድሪን ቻይንኛ",
    "zu" to "ዙሉኛ",
    "zun" to "ዙኒ",
    "zxx" to "ቋንቋዊ ይዘት የለውም",
    "zza" to "ዛዛ",
  ) }

  val an: ImmutableMap<String, String> by lazy { immutableMapOf(
    "an" to "aragonés",
  ) }

  val ann: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ann" to "Obolo",
  ) }

  val apc: ImmutableMap<String, String> by lazy { immutableMapOf(
    "apc" to "العامية",
  ) }

  val ar: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "الأفارية",
    "ab" to "الأبخازية",
    "ace" to "الأتشينيزية",
    "ach" to "الأكولية",
    "ada" to "الأدانجمية",
    "ady" to "الأديغة",
    "ae" to "الأفستية",
    "af" to "الأفريقانية",
    "afh" to "الأفريهيلية",
    "agq" to "الأغم",
    "ain" to "الآينوية",
    "ak" to "الأكانية",
    "akk" to "الأكادية",
    "ale" to "الأليوتية",
    "alt" to "الألطائية الجنوبية",
    "am" to "الأمهرية",
    "an" to "الأراغونية",
    "ang" to "الإنجليزية القديمة",
    "ann" to "أوبلو",
    "anp" to "الأنجيكا",
    "ar" to "العربية",
    "ar-001" to "العربية الفصحى الحديثة",
    "arc" to "الآرامية",
    "arn" to "المابودونغونية",
    "arp" to "الأراباهو",
    "ars" to "اللهجة النجدية",
    "ars-alt-menu" to "العربية، النجدية",
    "arw" to "الأراواكية",
    "as" to "الأسامية",
    "asa" to "الآسو",
    "ast" to "الأسترية",
    "atj" to "الأتيكاميكو",
    "av" to "الأوارية",
    "awa" to "الأوادية",
    "ay" to "الأيمارا",
    "az" to "الأذربيجانية",
    "az-alt-short" to "الأذرية",
    "ba" to "الباشكيرية",
    "bal" to "البلوشية",
    "ban" to "البالينية",
    "bas" to "الباسا",
    "bax" to "بامن",
    "bbj" to "لغة الغومالا",
    "be" to "البيلاروسية",
    "bej" to "البيجا",
    "bem" to "البيمبا",
    "bez" to "بينا",
    "bfd" to "لغة البافوت",
    "bg" to "البلغارية",
    "bgc" to "الهارينفية",
    "bgn" to "البلوشية الغربية",
    "bho" to "البهوجبورية",
    "bi" to "البيسلامية",
    "bik" to "البيكولية",
    "bin" to "البينية",
    "bkm" to "لغة الكوم",
    "bla" to "السيكسيكية",
    "blo" to "الآنية",
    "bm" to "البامبارا",
    "bn" to "البنغالية",
    "bo" to "التبتية",
    "br" to "البريتونية",
    "bra" to "البراجية",
    "brx" to "البودو",
    "bs" to "البوسنية",
    "bss" to "أكوس",
    "bua" to "البرياتية",
    "bug" to "البجينيزية",
    "bum" to "لغة البولو",
    "byn" to "البلينية",
    "byv" to "لغة الميدومبا",
    "ca" to "الكتالانية",
    "cad" to "الكادو",
    "car" to "الكاريبية",
    "cay" to "الكايوجية",
    "cch" to "الأتسام",
    "ccp" to "تشاكما",
    "ce" to "الشيشانية",
    "ceb" to "السيبيوانية",
    "cgg" to "تشيغا",
    "ch" to "التشامورو",
    "chb" to "التشيبشا",
    "chg" to "التشاجاتاي",
    "chk" to "التشكيزية",
    "chm" to "الماري",
    "chn" to "الشينوك جارجون",
    "cho" to "الشوكتو",
    "chp" to "الشيباوايان",
    "chr" to "الشيروكي",
    "chy" to "الشايان",
    "ckb" to "السورانية الكردية",
    "ckb-alt-menu" to "الكردية، السورانية",
    "ckb-alt-variant" to "السورانية الكردية",
    "clc" to "تسيلكوتين",
    "co" to "الكورسيكية",
    "cop" to "القبطية",
    "cr" to "الكرى",
    "crg" to "الميتشيف",
    "crh" to "لغة تتار القرم",
    "crj" to "الكري الجنوب شرقية",
    "crk" to "البلينز-كري",
    "crl" to "الكري شمال الشرقية",
    "crm" to "الموس-كري",
    "crr" to "الألغونكوية كارولينا",
    "crs" to "الفرنسية الكريولية السيشيلية",
    "cs" to "التشيكية",
    "csb" to "الكاشبايان",
    "csw" to "السوامبي-كري",
    "cu" to "سلافية كنسية",
    "cv" to "التشوفاشي",
    "cy" to "الويلزية",
    "da" to "الدانمركية",
    "dak" to "الداكوتا",
    "dar" to "الدارجوا",
    "dav" to "تيتا",
    "de" to "الألمانية",
    "de-AT" to "الألمانية النمساوية",
    "del" to "الديلوير",
    "den" to "السلافية",
    "dgr" to "الدوجريب",
    "din" to "الدنكا",
    "dje" to "الزارمية",
    "doi" to "الدوجرية",
    "dsb" to "صوربيا السفلى",
    "dua" to "الديولا",
    "dum" to "الهولندية الوسطى",
    "dv" to "المالديفية",
    "dyo" to "جولا فونيا",
    "dyu" to "الدايلا",
    "dz" to "دزونكا",
    "dzg" to "القرعانية",
    "ebu" to "إمبو",
    "ee" to "الإيوي",
    "efi" to "الإفيك",
    "egy" to "المصرية القديمة",
    "eka" to "الإكاجك",
    "el" to "اليونانية",
    "elx" to "الإمايت",
    "en" to "الإنجليزية",
    "en-GB-alt-short" to "الإنجليزية المملكة المتحدة",
    "en-US-alt-short" to "الإنجليزية الولايات المتحدة",
    "enm" to "الإنجليزية الوسطى",
    "eo" to "الإسبرانتو",
    "es" to "الإسبانية",
    "es-419" to "الإسبانية أمريكا اللاتينية",
    "es-ES" to "الإسبانية الأوروبية",
    "es-MX" to "الإسبانية المكسيكية",
    "et" to "الإستونية",
    "eu" to "الباسكية",
    "ewo" to "الإيوندو",
    "fa" to "الفارسية",
    "fa-AF" to "الدارية",
    "fan" to "الفانج",
    "fat" to "الفانتي",
    "ff" to "الفولانية",
    "fi" to "الفنلندية",
    "fil" to "الفلبينية",
    "fj" to "الفيجية",
    "fo" to "الفاروية",
    "fon" to "الفون",
    "fr" to "الفرنسية",
    "frc" to "الفرنسية الكاجونية",
    "frm" to "الفرنسية الوسطى",
    "fro" to "الفرنسية القديمة",
    "frr" to "الفريزينية الشمالية",
    "frs" to "الفريزينية الشرقية",
    "fur" to "الفريلايان",
    "fy" to "الفريزيان",
    "ga" to "الأيرلندية",
    "gaa" to "الجا",
    "gag" to "الغاغوز",
    "gan" to "الغان الصينية",
    "gay" to "الجايو",
    "gba" to "الجبيا",
    "gd" to "الغيلية الأسكتلندية",
    "gez" to "الجعزية",
    "gil" to "لغة أهل جبل طارق",
    "gl" to "الجاليكية",
    "gmh" to "الألمانية العليا الوسطى",
    "gn" to "الغوارانية",
    "goh" to "الألمانية العليا القديمة",
    "gon" to "الجندي",
    "gor" to "الجورونتالو",
    "got" to "القوطية",
    "grb" to "الجريبو",
    "grc" to "اليونانية القديمة",
    "gsw" to "الألمانية السويسرية",
    "gu" to "الغوجاراتية",
    "guz" to "الغيزية",
    "gv" to "المنكية",
    "gwi" to "غوتشن",
    "ha" to "الهوسا",
    "hai" to "الهيدا",
    "hak" to "الهاكا الصينية",
    "haw" to "لغة هاواي",
    "hax" to "هايدا الجنوبية",
    "he" to "العبرية",
    "hi" to "الهندية",
    "hi-Latn-alt-variant" to "الهنجليزية",
    "hil" to "الهيليجينون",
    "hit" to "الحثية",
    "hmn" to "الهمونجية",
    "ho" to "الهيري موتو",
    "hr" to "الكرواتية",
    "hsb" to "الصوربية العليا",
    "hsn" to "شيانغ الصينية",
    "ht" to "الكريولية الهايتية",
    "hu" to "الهنغارية",
    "hup" to "الهبا",
    "hur" to "الهالكوميليم",
    "hy" to "الأرمنية",
    "hz" to "الهيريرو",
    "ia" to "اللّغة الوسيطة",
    "iba" to "الإيبان",
    "ibb" to "الإيبيبيو",
    "id" to "الإندونيسية",
    "ie" to "الإنترلينج",
    "ig" to "الإيجبو",
    "ii" to "السيتشيون يي",
    "ik" to "الإينبياك",
    "ikt" to "الإنكتيتوتية الكندية الغربية",
    "ilo" to "الإيلوكو",
    "inh" to "الإنجوشية",
    "io" to "الإيدو",
    "is" to "الأيسلندية",
    "it" to "الإيطالية",
    "iu" to "الإينكتيتت",
    "ja" to "اليابانية",
    "jbo" to "اللوجبان",
    "jgo" to "نغومبا",
    "jmc" to "الماتشامية",
    "jpr" to "الفارسية اليهودية",
    "jrb" to "العربية اليهودية",
    "jv" to "الجاوية",
    "ka" to "الجورجية",
    "kaa" to "الكارا-كالباك",
    "kab" to "القبيلية",
    "kac" to "الكاتشين",
    "kaj" to "الجو",
    "kam" to "الكامبا",
    "kaw" to "الكوي",
    "kbd" to "الكاباردايان",
    "kbl" to "كانمبو",
    "kcg" to "التايابية",
    "kde" to "ماكونده",
    "kea" to "كابوفيرديانو",
    "kfo" to "الكورو",
    "kg" to "الكونغو",
    "kgp" to "الكاينغانغ",
    "kha" to "الكازية",
    "kho" to "الخوتانيز",
    "khq" to "كويرا تشيني",
    "ki" to "الكيكيو",
    "kj" to "كوانياما",
    "kk" to "الكازاخستانية",
    "kkj" to "لغة الكاكو",
    "kl" to "الكالاليست",
    "kln" to "كالينجين",
    "km" to "الخميرية",
    "kmb" to "الكيمبندو",
    "kn" to "الكانادا",
    "ko" to "الكورية",
    "koi" to "كومي-بيرماياك",
    "kok" to "الكونكانية",
    "kos" to "الكوسراين",
    "kpe" to "الكبيل",
    "kr" to "الكانوري",
    "krc" to "الكاراتشاي-بالكار",
    "krl" to "الكاريلية",
    "kru" to "الكوروخ",
    "ks" to "الكشميرية",
    "ksb" to "شامبالا",
    "ksf" to "لغة البافيا",
    "ksh" to "لغة الكولونيان",
    "ku" to "الكردية",
    "kum" to "القموقية",
    "kut" to "الكتيناي",
    "kv" to "الكومي",
    "kw" to "الكورنية",
    "kwk" to "الكواكوالا",
    "kxv" to "الكوفية",
    "ky" to "القيرغيزية",
    "la" to "اللاتينية",
    "lad" to "اللادينو",
    "lag" to "لانجي",
    "lah" to "اللاهندا",
    "lam" to "اللامبا",
    "lb" to "اللكسمبورغية",
    "lez" to "الليزجية",
    "lg" to "الغاندا",
    "li" to "الليمبورغية",
    "lij" to "الليغورية",
    "lil" to "الليلويتية",
    "lkt" to "لاكوتا",
    "lmo" to "اللومبردية",
    "ln" to "اللينجالا",
    "lo" to "اللاوية",
    "lol" to "منغولى",
    "lou" to "الكريولية اللويزيانية",
    "loz" to "اللوزي",
    "lrc" to "اللرية الشمالية",
    "lsm" to "الساميا",
    "lt" to "الليتوانية",
    "lu" to "اللوبا كاتانغا",
    "lua" to "اللبا-لؤلؤ",
    "lui" to "اللوسينو",
    "lun" to "اللوندا",
    "luo" to "اللو",
    "lus" to "الميزو",
    "luy" to "لغة اللويا",
    "lv" to "اللاتفية",
    "mad" to "المادريز",
    "mag" to "الماجا",
    "mai" to "المايثيلي",
    "mak" to "الماكاسار",
    "man" to "الماندينغ",
    "mas" to "الماساي",
    "mde" to "مابا",
    "mdf" to "الموكشا",
    "mdr" to "الماندار",
    "men" to "الميند",
    "mer" to "الميرو",
    "mfe" to "المورسيانية",
    "mg" to "الملغاشي",
    "mga" to "الأيرلندية الوسطى",
    "mgh" to "ماخاوا-ميتو",
    "mgo" to "ميتا",
    "mh" to "المارشالية",
    "mi" to "الماورية",
    "mic" to "الميكماكيونية",
    "min" to "المينانجكاباو",
    "mk" to "المقدونية",
    "ml" to "المالايالامية",
    "mn" to "المنغولية",
    "mnc" to "المانشو",
    "mni" to "المانيبورية",
    "moe" to "إينو-ايمون",
    "moh" to "الموهوك",
    "mos" to "الموسي",
    "mr" to "الماراثية",
    "ms" to "الماليزية",
    "mt" to "المالطية",
    "mua" to "مندنج",
    "mul" to "لغات متعددة",
    "mus" to "الكريك",
    "mwl" to "الميرانديز",
    "mwr" to "الماروارية",
    "my" to "البورمية",
    "myv" to "الأرزية",
    "mzn" to "المازندرانية",
    "na" to "النورو",
    "nan" to "مين-نان الصينية",
    "nap" to "النابولية",
    "naq" to "لغة الناما",
    "nb" to "النرويجية بوكمال",
    "nd" to "النديبيل الشمالية",
    "nds" to "الألمانية السفلى",
    "nds-NL" to "السكسونية السفلى",
    "ne" to "النيبالية",
    "new" to "النوارية",
    "ng" to "الندونجا",
    "nia" to "النياس",
    "niu" to "النيوي",
    "nl" to "الهولندية",
    "nmg" to "كواسيو",
    "nn" to "النرويجية نينورسك",
    "nnh" to "لغة النجيمبون",
    "no" to "النرويجية",
    "nog" to "النوجاي",
    "non" to "النورس القديم",
    "nqo" to "أنكو",
    "nr" to "النديبيل الجنوبي",
    "nso" to "السوتو الشمالية",
    "nus" to "النوير",
    "nv" to "النافاجو",
    "nwc" to "النوارية التقليدية",
    "ny" to "النيانجا",
    "nym" to "النيامويزي",
    "nyn" to "النيانكول",
    "nyo" to "النيورو",
    "nzi" to "النزيما",
    "oc" to "الأوكسيتانية",
    "oj" to "الأوجيبوا",
    "ojb" to "أوجيبوا الشمالية الغربية",
    "ojc" to "أوجيبوا الوسطى",
    "ojs" to "الأوجي-كري",
    "ojw" to "الأوجيبوا الغربية",
    "oka" to "الأوكاناغانية",
    "om" to "الأورومية",
    "or" to "الأورية",
    "os" to "الأوسيتيك",
    "osa" to "الأوساج",
    "ota" to "التركية العثمانية",
    "pa" to "البنجابية",
    "pag" to "البانجاسينان",
    "pal" to "البهلوية",
    "pam" to "البامبانجا",
    "pap" to "البابيامينتو",
    "pau" to "البالوان",
    "pcm" to "البدجنية النيجيرية",
    "peo" to "الفارسية القديمة",
    "phn" to "الفينيقية",
    "pi" to "البالية",
    "pis" to "بيجين",
    "pl" to "البولندية",
    "pon" to "البوهنبيايان",
    "pqm" to "الماليزيت-باساماكودي",
    "prg" to "البروسياوية",
    "pro" to "البروفانسية القديمة",
    "ps" to "البشتو",
    "ps-alt-variant" to "بشتو",
    "pt" to "البرتغالية",
    "pt-BR" to "البرتغالية البرازيلية",
    "pt-PT" to "البرتغالية الأوروبية",
    "qu" to "كيشوا",
    "quc" to "الكيشية",
    "raj" to "الراجاسثانية",
    "rap" to "الراباني",
    "rar" to "الراروتونجاني",
    "rhg" to "الروهينغية",
    "rm" to "الرومانشية",
    "rn" to "الرندي",
    "ro" to "الرومانية",
    "ro-MD" to "المولدوفية",
    "rof" to "الرومبو",
    "rom" to "الغجرية",
    "ru" to "الروسية",
    "rup" to "الأرومانيان",
    "rw" to "الكينيارواندا",
    "rwk" to "الروا",
    "sa" to "السنسكريتية",
    "sad" to "السانداوي",
    "sah" to "الساخيّة",
    "sam" to "الآرامية السامرية",
    "saq" to "سامبورو",
    "sas" to "الساساك",
    "sat" to "السانتالية",
    "sba" to "نامبي",
    "sbp" to "سانغو",
    "sc" to "السردينية",
    "scn" to "الصقلية",
    "sco" to "الأسكتلندية",
    "sd" to "السندية",
    "sdh" to "الكردية الجنوبية",
    "se" to "سامي الشمالية",
    "see" to "السنيكا",
    "seh" to "سينا",
    "sel" to "السيلكب",
    "ses" to "كويرابورو سيني",
    "sg" to "السانجو",
    "sga" to "الأيرلندية القديمة",
    "sh" to "صربية-كرواتية",
    "shi" to "تشلحيت",
    "shn" to "الشان",
    "shu" to "العربية التشادية",
    "si" to "السنهالية",
    "sid" to "السيدامو",
    "sk" to "السلوفاكية",
    "sl" to "السلوفانية",
    "slh" to "لوشوتسيد الجنوبية",
    "sm" to "الساموائية",
    "sma" to "السامي الجنوبي",
    "smj" to "اللول سامي",
    "smn" to "الإيناري سامي",
    "sms" to "السكولت سامي",
    "sn" to "الشونا",
    "snk" to "السونينك",
    "so" to "الصومالية",
    "sog" to "السوجدين",
    "sq" to "الألبانية",
    "sr" to "الصربية",
    "srn" to "السرانان تونجو",
    "srr" to "السرر",
    "ss" to "السواتي",
    "ssy" to "لغة الساهو",
    "st" to "السوتو الجنوبية",
    "str" to "سترايتس ساليش",
    "su" to "السوندانية",
    "suk" to "السوكوما",
    "sus" to "السوسو",
    "sux" to "السومارية",
    "sv" to "السويدية",
    "sw" to "السواحلية",
    "sw-CD" to "الكونغو السواحلية",
    "swb" to "القمرية",
    "syc" to "سريانية تقليدية",
    "syr" to "السريانية",
    "szl" to "السيليزية",
    "ta" to "التاميلية",
    "tce" to "التوتشون الجنوبية",
    "te" to "التيلوغوية",
    "tem" to "التيمن",
    "teo" to "تيسو",
    "ter" to "التيرينو",
    "tet" to "التيتم",
    "tg" to "الطاجيكية",
    "tgx" to "التاغيش",
    "th" to "التايلاندية",
    "tht" to "التالتان",
    "ti" to "التغرينية",
    "tig" to "التيغرية",
    "tiv" to "التيف",
    "tk" to "التركمانية",
    "tkl" to "التوكيلاو",
    "tl" to "التاغالوغية",
    "tlh" to "الكلينجون",
    "tli" to "التلينغيتية",
    "tmh" to "التاماشيك",
    "tn" to "التسوانية",
    "to" to "التونغية",
    "tog" to "تونجا - نياسا",
    "tok" to "التوكي-بونا",
    "tpi" to "التوك بيسين",
    "tr" to "التركية",
    "trv" to "لغة التاروكو",
    "ts" to "السونجا",
    "tsi" to "التسيمشيان",
    "tt" to "التترية",
    "ttm" to "التوتشون الشمالية",
    "tum" to "التامبوكا",
    "tvl" to "التوفالو",
    "tw" to "التوي",
    "twq" to "تاساواق",
    "ty" to "التاهيتية",
    "tyv" to "التوفية",
    "tzm" to "الأمازيغية وسط الأطلس",
    "udm" to "الأدمرت",
    "ug" to "الأويغورية",
    "ug-alt-variant" to "الأيغورية",
    "uga" to "اليجاريتيك",
    "uk" to "الأوكرانية",
    "umb" to "الأمبندو",
    "und" to "لغة غير معروفة",
    "ur" to "الأوردية",
    "uz" to "الأوزبكية",
    "vai" to "الفاي",
    "ve" to "الفيندا",
    "vec" to "البندقية",
    "vi" to "الفيتنامية",
    "vmw" to "الماكوا",
    "vo" to "لغة الفولابوك",
    "vot" to "الفوتيك",
    "vun" to "الفونجو",
    "wa" to "الولونية",
    "wae" to "الوالسر",
    "wal" to "الولاياتا",
    "war" to "الواراي",
    "was" to "الواشو",
    "wbp" to "وارلبيري",
    "wo" to "الولوفية",
    "wuu" to "الوو الصينية",
    "xal" to "الكالميك",
    "xh" to "الخوسا",
    "xnr" to "كانغري",
    "xog" to "السوغا",
    "yao" to "الياو",
    "yap" to "اليابيز",
    "yav" to "يانجبن",
    "ybb" to "يمبا",
    "yi" to "اليديشية",
    "yo" to "اليوروبا",
    "yrl" to "النيينجاتو",
    "yue" to "الكَنْتُونية",
    "yue-alt-menu" to "الكَنْتُونية",
    "za" to "الزهيونج",
    "zap" to "الزابوتيك",
    "zbl" to "رموز المعايير الأساسية",
    "zen" to "الزيناجا",
    "zgh" to "التمازيغية المغربية القياسية",
    "zh" to "الصينية",
    "zh-alt-menu" to "الصينية",
    "zh-Hans" to "الصينية المبسطة",
    "zh-Hans-alt-long" to "الصينية المبسطة",
    "zh-Hant" to "الصينية التقليدية",
    "zh-Hant-alt-long" to "الصينية التقليدية",
    "zu" to "الزولو",
    "zun" to "الزونية",
    "zxx" to "بدون محتوى لغوي",
    "zza" to "زازا",
  ) }

  val ar_AE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_BH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_DJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_DZ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_EG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "da" to "الدنماركية",
  ) }

  val ar_EH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_ER: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_IL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_IQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_JO: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_KM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_KW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_LB: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_LY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "arn" to "المابودونجونية",
    "gn" to "الغورانية",
    "hsb" to "صوربيا العليا",
    "lo" to "اللاوو",
    "sh" to "الكرواتية الصربية",
    "sma" to "سامي الجنوبية",
    "sw" to "السواحيلية",
    "sw-CD" to "السواحيلية الكونغولية",
    "ti" to "التيغرينية",
  ) }

  val ar_MA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_OM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_PS: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_QA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar-001" to "العربية الرسمية الحديثة",
    "arn" to "المابودونجونية",
    "gn" to "الغورانية",
    "hsb" to "صوربيا العليا",
    "lo" to "اللاوو",
    "sh" to "الكرواتية الصربية",
    "sma" to "سامي الجنوبية",
    "sw" to "السواحيلية",
    "sw-CD" to "السواحيلية الكونغولية",
    "te" to "التيلوجو",
    "ti" to "التيغرينية",
  ) }

  val ar_SD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SO: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SS: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_SY: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_TD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_TN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ar_YE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val arn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "arn" to "Mapudungun",
  ) }

  val `as`: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "আফাৰ",
    "ab" to "আবখাজিয়ান",
    "ace" to "আচিনিজ",
    "ada" to "আদাংমে",
    "ady" to "আদিগে",
    "af" to "আফ্ৰিকানছ্",
    "agq" to "আঘেম",
    "ain" to "আইনু",
    "ak" to "আকান",
    "ale" to "আলেউট",
    "alt" to "দাক্ষিণাত্য আল্টাই",
    "am" to "আমহাৰিক",
    "an" to "আৰ্গোনিজ",
    "ann" to "অ’ব’ল’",
    "anp" to "আঙ্গিকা",
    "ar" to "আৰবী",
    "ar-001" to "আধুনিক মানক আৰবী",
    "arn" to "মাপুচে",
    "arp" to "আৰাপাহো",
    "ars" to "নাজডি আৰবী",
    "as" to "অসমীয়া",
    "asa" to "আছু",
    "ast" to "এষ্টুৰীয়",
    "atj" to "আতিকামেক",
    "av" to "আভেৰিক",
    "awa" to "অৱধী",
    "ay" to "আয়মাৰা",
    "az" to "আজেৰবাইজানী",
    "az-alt-short" to "আজেৰি",
    "ba" to "বাছখিৰ",
    "ban" to "বালিনীজ",
    "bas" to "বাছা",
    "be" to "বেলাৰুছীয়",
    "bem" to "বেম্বা",
    "bez" to "বেনা",
    "bg" to "বুলগেৰীয়",
    "bgc" to "হাৰয়ানভি",
    "bho" to "ভোজপুৰী",
    "bi" to "বিছলামা",
    "bin" to "বিনি",
    "bla" to "ছিক্সিকা",
    "blo" to "আনি",
    "bm" to "বামবাৰা",
    "bn" to "বাংলা",
    "bo" to "তিব্বতী",
    "br" to "ব্ৰেটন",
    "brx" to "বড়ো",
    "bs" to "বছনীয়",
    "bug" to "বগিনীজ",
    "byn" to "ব্লিন",
    "ca" to "কাতালান",
    "cay" to "কায়ুগা",
    "ccp" to "চাক্‌মা",
    "ce" to "চেচেন",
    "ceb" to "চিবুৱানো",
    "cgg" to "চিগা",
    "ch" to "চামোৰো",
    "chk" to "চুকিজ",
    "chm" to "মাৰি",
    "cho" to "চোক্টাউ",
    "chp" to "চিপেউয়ান",
    "chr" to "চেৰোকি",
    "chy" to "চাইয়েন",
    "ckb" to "চেণ্ট্ৰেল কুৰ্ডিচ",
    "ckb-alt-menu" to "চেণ্ট্ৰেল কুৰ্ডিচ",
    "ckb-alt-variant" to "চেণ্ট্ৰেল কুৰ্ডিচ",
    "clc" to "চিলক’টিন",
    "co" to "কোৰ্ছিকান",
    "crg" to "মিচিফ",
    "crj" to "দাক্ষিণাত্য ইষ্ট ক্ৰী",
    "crk" to "প্লেইনছ ক্ৰী",
    "crl" to "নৰ্দাৰ্ন ইষ্ট ক্ৰী",
    "crm" to "মুজ ক্ৰী",
    "crr" to "কেৰ’লিনা আলগংকিয়ান",
    "crs" to "ছেছেলৱা ক্ৰিওল ফ্ৰেন্স",
    "cs" to "চেক",
    "csw" to "স্বাম্পী ক্ৰী",
    "cu" to "চাৰ্চ শ্লেভিক",
    "cv" to "চুভাচ",
    "cy" to "ৱেলচ",
    "da" to "ডেনিচ",
    "dak" to "ডাকোটা",
    "dar" to "দাৰ্গৱা",
    "dav" to "তেইতা",
    "de" to "জাৰ্মান",
    "de-AT" to "অষ্ট্ৰেলিয়ান জাৰ্মান",
    "de-CH" to "ছুইচ হাই জাৰ্মান",
    "dgr" to "ডোগ্ৰিব",
    "dje" to "ঝাৰ্মা",
    "doi" to "ডোগ্ৰী",
    "dsb" to "ল’ৱাৰ ছোৰ্বিয়ান",
    "dua" to "ডুৱালা",
    "dv" to "দিবেহি",
    "dyo" to "জোলা-ফ’নি",
    "dz" to "জোংখা",
    "dzg" to "দাজাগা",
    "ebu" to "এম্বু",
    "ee" to "ইৱে",
    "efi" to "এফিক",
    "eka" to "একাজুক",
    "el" to "গ্ৰীক",
    "en" to "ইংৰাজী",
    "en-AU" to "অষ্ট্ৰেলিয়ান ইংৰাজী",
    "en-CA" to "কানাডিয়ান ইংৰাজী",
    "en-GB" to "ব্ৰিটিছ ইংৰাজী",
    "en-GB-alt-short" to "ইউ. কে. ইংৰাজী",
    "en-US" to "আমেৰিকান ইংৰাজী",
    "en-US-alt-short" to "ইউ. এছ. ইংৰাজী",
    "eo" to "এস্পেৰান্তো",
    "es" to "স্পেনিচ",
    "es-419" to "লেটিন আমেৰিকান স্পেনিচ",
    "es-ES" to "ইউৰোপীয়ান স্পেনিচ",
    "es-MX" to "মেক্সিকান স্পেনিচ",
    "et" to "এষ্টোনিয়",
    "eu" to "বাস্ক",
    "ewo" to "ইওন্দো",
    "fa" to "ফাৰ্ছী",
    "fa-AF" to "দাৰি",
    "ff" to "ফুলাহ",
    "fi" to "ফিনিচ",
    "fil" to "ফিলিপিনো",
    "fj" to "ফিজিয়ান",
    "fo" to "ফাৰোইজ",
    "fon" to "ফ’ন",
    "fr" to "ফ্ৰেন্স",
    "fr-CA" to "কানাডিয়ান ফ্ৰেন্স",
    "fr-CH" to "ছুইচ ফ্ৰেন্স",
    "frc" to "কেজ’ন ফৰাছী",
    "frr" to "নৰ্দাৰ্ন ফ্ৰিছিয়ান",
    "fur" to "ফ্ৰিউলিয়ান",
    "fy" to "ৱেষ্টাৰ্ণ ফ্ৰিছিয়ান",
    "ga" to "আইৰিচ",
    "gaa" to "গা",
    "gd" to "স্কটিচ গেইলিক",
    "gez" to "গীজ",
    "gil" to "গিলবাৰ্টিছ",
    "gl" to "গেলিচিয়ান",
    "gn" to "গুৱাৰাণী",
    "gor" to "গোৰোন্তালো",
    "gsw" to "ছুইচ জাৰ্মান",
    "gu" to "গুজৰাটী",
    "guz" to "গুছি",
    "gv" to "মেংক্স",
    "gwi" to "জিউইচিন",
    "ha" to "হাউছা",
    "hai" to "হেইডা",
    "haw" to "হাৱাই",
    "hax" to "দাক্ষিণাত্যৰ হাইডা",
    "he" to "হিব্ৰু",
    "hi" to "হিন্দী",
    "hi-Latn-alt-variant" to "হিংলিছ",
    "hil" to "হিলিগায়নোন",
    "hmn" to "হমং",
    "hr" to "ক্ৰোৱেচিয়ান",
    "hsb" to "আপাৰ ছোৰ্বিয়ান",
    "ht" to "হেইটিয়ান ক্ৰিয়ল",
    "hu" to "হাঙ্গেৰিয়ান",
    "hup" to "হুপা",
    "hur" to "হেলকোমেলেম",
    "hy" to "আৰ্মেনীয়",
    "hz" to "হেৰেৰো",
    "ia" to "ইণ্টাৰলিংগুৱা",
    "iba" to "ইবান",
    "ibb" to "ইবিবিও",
    "id" to "ইণ্ডোনেচিয়",
    "ie" to "ইণ্টাৰলিংগুৱে",
    "ig" to "ইগ্বো",
    "ii" to "ছিচুৱান ই",
    "ikt" to "ৱেষ্টাৰ্ণ কানাডিয়ান ইনক্টিটুট",
    "ilo" to "ইলোকো",
    "inh" to "ইংগুচ",
    "io" to "ইডো",
    "is" to "আইচলেণ্ডিক",
    "it" to "ইটালিয়ান",
    "iu" to "ইনুক্টিটুট",
    "ja" to "জাপানী",
    "jbo" to "লোজ্বান",
    "jgo" to "নগোম্বা",
    "jmc" to "মেকহেম",
    "jv" to "জাভানী",
    "ka" to "জৰ্জিয়ান",
    "kab" to "কাবাইল",
    "kac" to "কাচিন",
    "kaj" to "জজু",
    "kam" to "কাম্বা",
    "kbd" to "কাবাৰ্ডিয়ান",
    "kcg" to "ত্যাপ",
    "kde" to "মাকোণ্ড",
    "kea" to "কাবুভেৰ্ডিয়ানু",
    "kfo" to "কোৰো",
    "kgp" to "কেইংগাং",
    "kha" to "খাচি",
    "khq" to "কোয়াৰ চিনি",
    "ki" to "কিকুয়ু",
    "kj" to "কুয়ানিয়ামা",
    "kk" to "কাজাখ",
    "kkj" to "কাকো",
    "kl" to "কালালিছুট",
    "kln" to "কালেনজিন",
    "km" to "খমেৰ",
    "kmb" to "কিম্বুন্দু",
    "kn" to "কানাড়া",
    "ko" to "কোৰিয়ান",
    "kok" to "কোংকণী",
    "kpe" to "কেপেল",
    "kr" to "কানুৰি",
    "krc" to "কাৰাচে-বাল্কাৰ",
    "krl" to "কেৰেলিয়ান",
    "kru" to "কুৰুখ",
    "ks" to "কাশ্মিৰী",
    "ksb" to "চাম্বালা",
    "ksf" to "বাফিয়া",
    "ksh" to "কোলোগনিয়ান",
    "ku" to "কুৰ্ডিচ",
    "kum" to "কুমিক",
    "kv" to "কোমি",
    "kw" to "কোৰ্নিচ",
    "kwk" to "ক্বাকৱালা",
    "kxv" to "কুভি",
    "ky" to "কিৰ্গিজ",
    "la" to "লেটিন",
    "lad" to "লাডিনো",
    "lag" to "লাংগি",
    "lb" to "লাক্সেমবাৰ্গিচ",
    "lez" to "লেজঘিয়ান",
    "lg" to "গান্দা",
    "li" to "লিম্বুৰ্গিচ",
    "lij" to "লিংগুৰিয়ান",
    "lil" to "লিল্লোৱেট",
    "lkt" to "লাকোটা",
    "lmo" to "ল’ম্বাৰ্ড",
    "ln" to "লিংগালা",
    "lo" to "লাও",
    "lou" to "লুইজিয়ানা কেৰ’ল",
    "loz" to "লোজি",
    "lrc" to "উদীচ্য লুৰি",
    "lsm" to "চামিয়া",
    "lt" to "লিথুৱানিয়ান",
    "lu" to "লুবা-কাটাংগা",
    "lua" to "লুবা-লুলুৱা",
    "lun" to "লুণ্ডা",
    "luo" to "লুও",
    "lus" to "মিজো",
    "luy" to "লুইয়া",
    "lv" to "লাটভিয়ান",
    "mad" to "মাদুৰেছে",
    "mag" to "মাগাহি",
    "mai" to "মৈথিলী",
    "mak" to "মাকাছাৰ",
    "mas" to "মাছাই",
    "mdf" to "মোক্সা",
    "men" to "মেণ্ডে",
    "mer" to "মেৰু",
    "mfe" to "মৰিছিয়ান",
    "mg" to "মালাগাছী",
    "mgh" to "মাখুৱা-মিট্টো",
    "mgo" to "মেটা",
    "mh" to "মাৰ্চলিজ",
    "mi" to "মাওৰি",
    "mic" to "মিকমেক",
    "min" to "মিনাংকাবাউ",
    "mk" to "মেচিডোনীয়",
    "ml" to "মালায়ালম",
    "mn" to "মংগোলীয়",
    "mni" to "মণিপুৰী",
    "moe" to "ইন্নু-আইমুন",
    "moh" to "মোহোক",
    "mos" to "মোছি",
    "mr" to "মাৰাঠী",
    "ms" to "মালয়",
    "mt" to "মাল্টিজ",
    "mua" to "মুণ্ডাং",
    "mul" to "একাধিক ভাষা",
    "mus" to "ক্ৰীক",
    "mwl" to "মিৰাণ্ডিজ",
    "my" to "বাৰ্মীজ",
    "myv" to "এৰজিয়া",
    "mzn" to "মাজেন্দাৰানি",
    "na" to "নাউৰু",
    "nap" to "নিয়াপোলিটেন",
    "naq" to "নামা",
    "nb" to "নৰৱেজিয়ান বোকমাল",
    "nd" to "উত্তৰ নিবেবেলে",
    "nds" to "ল’ জাৰ্মান",
    "ne" to "নেপালী",
    "new" to "নেৱাৰি",
    "ng" to "এন্দোঙ্গা",
    "nia" to "নিয়াছ",
    "niu" to "নিয়ুৱান",
    "nl" to "ডাচ",
    "nl-BE" to "ফ্লেমিচ",
    "nmg" to "কোৱাছিঅ’",
    "nn" to "নৰৱেজিয়ান নায়নোৰ্স্ক",
    "nnh" to "নিয়েম্বোন",
    "no" to "নৰৱেজিয়ান",
    "nog" to "নোগাই",
    "nqo" to "এন্কো",
    "nr" to "দক্ষিণ দেবেল",
    "nso" to "উদীচ্য ছোথো",
    "nus" to "নুয়েৰ",
    "nv" to "নাভাজো",
    "ny" to "ন্যাঞ্জা",
    "nyn" to "ন্যানকোল",
    "oc" to "অ’চিটান",
    "ojb" to "নৰ্থ-ৱেষ্টাৰ্ণ অজিবৱা",
    "ojc" to "চেন্ট্ৰেক অজিবৱা",
    "ojs" to "অ’জি-ক্ৰী",
    "ojw" to "ৱেষ্টাৰ্ণ অজিবৱা",
    "oka" to "অ’কানাগান",
    "om" to "ওৰোমো",
    "or" to "ওড়িয়া",
    "os" to "ওছেটিক",
    "pa" to "পাঞ্জাবী",
    "pag" to "পংগাছিনান",
    "pam" to "পাম্পান্গা",
    "pap" to "পাপিয়ামেণ্টো",
    "pau" to "পালাউৱান",
    "pcm" to "নাইজেৰিয়ান পিজিন",
    "pis" to "পিজিন",
    "pl" to "প’লিচ",
    "pqm" to "মালিছীট-পাছামাকু’ডী",
    "prg" to "প্ৰুছিয়ান",
    "ps" to "পুস্ত",
    "pt" to "পৰ্তুগীজ",
    "pt-BR" to "ব্ৰাজিলিয়ান পৰ্তুগীজ",
    "pt-PT" to "ইউৰোপীয়ান পৰ্তুগীজ",
    "qu" to "কুৱেচুৱা",
    "quc" to "কিচিয়ে",
    "raj" to "ৰাজস্থানী",
    "rap" to "ৰাপানুই",
    "rar" to "ৰাৰোতোঙ্গন",
    "rhg" to "ৰোহিঙ্গিয়া",
    "rm" to "ৰোমানচ",
    "rn" to "ৰুন্দি",
    "ro" to "ৰোমানীয়",
    "ro-MD" to "মোল্ডাভিয়ান",
    "rof" to "ৰোম্বো",
    "ru" to "ৰাছিয়ান",
    "rup" to "আৰোমানীয়",
    "rw" to "কিনয়াৰোৱাণ্ডা",
    "rwk" to "ৰৱা",
    "sa" to "সংস্কৃত",
    "sad" to "ছান্দাৱে",
    "sah" to "ছাখা",
    "saq" to "ছাম্বুৰু",
    "sat" to "চাওতালি",
    "sba" to "নাংম্বে",
    "sbp" to "ছাঙ্গু",
    "sc" to "ছাৰ্ডিনিয়ান",
    "scn" to "ছিচিলিয়ান",
    "sco" to "স্কটছ",
    "sd" to "সিন্ধী",
    "se" to "উদীচ্য ছামি",
    "seh" to "ছেনা",
    "ses" to "কোইৰাবোৰো চেন্নি",
    "sg" to "ছাঙ্গো",
    "shi" to "তাচেলহিট",
    "shn" to "চান",
    "si" to "সিংহলা",
    "sk" to "শ্লোভাক",
    "sl" to "শ্লোভেনিয়ান",
    "slh" to "দাক্ষিণাত্যৰ লুছুটচীড",
    "sm" to "ছামোন",
    "sma" to "দাক্ষিণাত্য ছামি",
    "smj" to "লুলে ছামি",
    "smn" to "ইনাৰি ছামি",
    "sms" to "স্কোল্ট ছামি",
    "sn" to "চোনা",
    "snk" to "ছোনিনকে",
    "so" to "ছোমালি",
    "sq" to "আলবেনীয়",
    "sr" to "ছাৰ্বিয়ান",
    "srn" to "স্ৰানান টোঙ্গো",
    "ss" to "স্বাতি",
    "ssy" to "ছাহো",
    "st" to "দাক্ষিণাত্য ছোথো",
    "str" to "ষ্ট্ৰেইটছ ছেলিশ্ব",
    "su" to "ছুণ্ডানীজ",
    "suk" to "ছুকুমা",
    "sv" to "ছুইডিচ",
    "sw" to "স্বাহিলি",
    "sw-CD" to "কঙ্গো স্বাহিলি",
    "swb" to "কোমোৰিয়ান",
    "syr" to "চিৰিয়াক",
    "szl" to "ছাইলেছিয়ান",
    "ta" to "তামিল",
    "tce" to "দাক্ষিণাত্যৰ টুটচ’ন",
    "te" to "তেলুগু",
    "tem" to "টিম্নে",
    "teo" to "তেছো",
    "tet" to "তেতুম",
    "tg" to "তাজিক",
    "tgx" to "টেগিশ্ব",
    "th" to "থাই",
    "tht" to "টাহলটান",
    "ti" to "টিগৰিনিয়া",
    "tig" to "তাইগ্ৰে",
    "tk" to "তুৰ্কমেন",
    "tlh" to "ক্লিংগন",
    "tli" to "লিংগিট",
    "tn" to "ছোৱানা",
    "to" to "টোঙ্গান",
    "tok" to "ট’কি প’না",
    "tpi" to "টোক পিছিন",
    "tr" to "তুৰ্কী",
    "trv" to "তাৰোকো",
    "ts" to "ছোঙ্গা",
    "tt" to "তাতাৰ",
    "ttm" to "নৰ্দাৰ্ন টুটচ’ন",
    "tum" to "তুম্বুকা",
    "tvl" to "টুভালু",
    "twq" to "টাছাৱাক",
    "ty" to "তাহিতিয়ান",
    "tyv" to "তুভিনিয়ান",
    "tzm" to "চেণ্ট্ৰেল এটলাছ টামাজাইট",
    "udm" to "উদমুৰ্ত",
    "ug" to "উইঘুৰ",
    "uk" to "ইউক্ৰেইনীয়",
    "umb" to "উম্বুন্দু",
    "und" to "অজ্ঞাত ভাষা",
    "ur" to "উৰ্দু",
    "uz" to "উজবেক",
    "vai" to "ভাই",
    "ve" to "ভেণ্ডা",
    "vec" to "ভেনেছিয়ান",
    "vi" to "ভিয়েটনামী",
    "vmw" to "মাখুৱা",
    "vo" to "ভোলাপুক",
    "vun" to "ভুঞ্জু",
    "wa" to "ৱালুন",
    "wae" to "ৱালছেৰ",
    "wal" to "ওলেইটা",
    "war" to "ৱাৰে",
    "wo" to "ৱোলাফ",
    "wuu" to "ৱু চাইনিজ",
    "xal" to "কাল্মিক",
    "xh" to "হোছা",
    "xnr" to "কাংগৰি",
    "xog" to "ছোগা",
    "yav" to "য়াংবেন",
    "ybb" to "য়েম্বা",
    "yi" to "ইদ্দিছ",
    "yo" to "ইউৰুবা",
    "yrl" to "হিংগাটো",
    "yue" to "কেণ্টোনীজ",
    "yue-alt-menu" to "চাইনিজ, কেণ্টোনীজ",
    "za" to "ঝুৱাং",
    "zgh" to "ষ্টেণ্ডাৰ্ড মোৰোক্কান তামাজাইট",
    "zh" to "চীনা",
    "zh-alt-menu" to "চীনা, মেণ্ডাৰিন",
    "zh-Hans" to "সৰলীকৃত চীনা",
    "zh-Hans-alt-long" to "সৰলীকৃত মেণ্ডাৰিন চীনা",
    "zh-Hant" to "পৰম্পৰাগত চীনা",
    "zh-Hant-alt-long" to "পৰম্পৰাগত মেণ্ডাৰিন চীনা",
    "zu" to "ঝুলু",
    "zun" to "ঝুনি",
    "zxx" to "কোনো ভাষা সমল নাই",
    "zza" to "ঝাঝা",
  ) }

  val asa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Kiakan",
    "am" to "Kiamhari",
    "ar" to "Kiarabu",
    "asa" to "Kipare",
    "be" to "Kibelarusi",
    "bg" to "Kibulgaria",
    "bn" to "Kibangla",
    "cs" to "Kicheki",
    "de" to "Kijerumani",
    "el" to "Kigiriki",
    "en" to "Kiingeredha",
    "es" to "Kihithpania",
    "fa" to "Kiajemi",
    "fr" to "Kifarantha",
    "ha" to "Kihautha",
    "hi" to "Kihindi",
    "hu" to "Kihungari",
    "id" to "Kiindonethia",
    "ig" to "Kiigbo",
    "it" to "Kiitaliaano",
    "ja" to "Kijapani",
    "jv" to "Kijava",
    "km" to "Kikambodia",
    "ko" to "Kikorea",
    "ms" to "Kimalesia",
    "my" to "Kiburma",
    "ne" to "Kinepali",
    "nl" to "Kiholandhi",
    "pa" to "Kipunjabi",
    "pl" to "Kipolandi",
    "pt" to "Kireno",
    "ro" to "Kiromania",
    "ru" to "Kiruthi",
    "rw" to "Kinyarandwa",
    "so" to "Kithomali",
    "sv" to "Kithwidi",
    "ta" to "Kitamil",
    "th" to "Kitailandi",
    "tr" to "Kituruki",
    "uk" to "Kiukrania",
    "ur" to "Kiurdu",
    "vi" to "Kivietinamu",
    "yo" to "Kiyoruba",
    "zh" to "Kichina",
    "zh-alt-menu" to "Kichina",
    "zu" to "Kidhulu",
  ) }

  val ast: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abkhazianu",
    "ace" to "achinés",
    "ach" to "acoli",
    "ada" to "adangme",
    "ady" to "adyghe",
    "ae" to "avestanín",
    "aeb" to "árabe de Túnez",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "akan",
    "akk" to "acadianu",
    "akz" to "alabama",
    "ale" to "aleut",
    "aln" to "gheg d’Albania",
    "alt" to "altai del sur",
    "am" to "amháricu",
    "an" to "aragonés",
    "ang" to "inglés antiguu",
    "anp" to "angika",
    "ar" to "árabe",
    "ar-001" to "árabe estándar modernu",
    "arc" to "araméu",
    "arn" to "mapuche",
    "aro" to "araona",
    "arp" to "arapaho",
    "arq" to "árabe d’Arxelia",
    "arw" to "arawak",
    "ary" to "árabe de Marruecos",
    "arz" to "árabe d’Exiptu",
    "as" to "asamés",
    "asa" to "asu",
    "ase" to "llingua de signos americana",
    "ast" to "asturianu",
    "av" to "aváricu",
    "avk" to "kotava",
    "awa" to "awadhi",
    "ay" to "aymara",
    "az" to "azerbaixanu",
    "az-alt-short" to "azerí",
    "ba" to "bashkir",
    "bal" to "baluchi",
    "ban" to "balinés",
    "bar" to "bávaru",
    "bas" to "basaa",
    "bax" to "bamun",
    "bbc" to "batak toba",
    "bbj" to "ghomala",
    "be" to "bielorrusu",
    "bej" to "beja",
    "bem" to "bemba",
    "bew" to "betawi",
    "bez" to "bena",
    "bfd" to "bafut",
    "bfq" to "badaga",
    "bg" to "búlgaru",
    "bgn" to "balochi occidental",
    "bho" to "bhojpuri",
    "bi" to "bislama",
    "bik" to "bikol",
    "bin" to "bini",
    "bjn" to "banjar",
    "bkm" to "kom",
    "bla" to "siksika",
    "bm" to "bambara",
    "bn" to "bengalín",
    "bo" to "tibetanu",
    "bpy" to "bishnupriya",
    "bqi" to "bakhtiari",
    "br" to "bretón",
    "bra" to "braj",
    "brh" to "brahui",
    "brx" to "bodo",
    "bs" to "bosniu",
    "bss" to "akoose",
    "bua" to "buriat",
    "bug" to "buginés",
    "bum" to "bulu",
    "byn" to "blin",
    "byv" to "medumba",
    "ca" to "catalán",
    "cad" to "caddo",
    "car" to "caribe",
    "cay" to "cayuga",
    "cch" to "atsam",
    "ce" to "chechenu",
    "ceb" to "cebuanu",
    "cgg" to "chiga",
    "ch" to "chamorro",
    "chb" to "chibcha",
    "chg" to "chagatai",
    "chk" to "chuukés",
    "chm" to "mari",
    "chn" to "xíriga chinook",
    "cho" to "choctaw",
    "chp" to "chipewyanu",
    "chr" to "cheroqui",
    "chy" to "cheyenne",
    "ckb" to "kurdu central",
    "ckb-alt-menu" to "kurdu central",
    "ckb-alt-variant" to "kurdu central",
    "co" to "corsu",
    "cop" to "cópticu",
    "cps" to "capiznon",
    "cr" to "cree",
    "crh" to "turcu de Crimea",
    "crs" to "francés criollu seselwa",
    "cs" to "checu",
    "csb" to "kashubianu",
    "cu" to "eslávicu eclesiásticu",
    "cv" to "chuvash",
    "cy" to "galés",
    "da" to "danés",
    "dak" to "dakota",
    "dar" to "dargwa",
    "dav" to "taita",
    "de" to "alemán",
    "de-AT" to "alemán d’Austria",
    "de-CH" to "altualemán de Suiza",
    "del" to "delaware",
    "den" to "slave",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "baxu sorbiu",
    "dtp" to "dusun central",
    "dua" to "duala",
    "dum" to "neerlandés mediu",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dyu" to "dyula",
    "dz" to "dzongkha",
    "dzg" to "dazaga",
    "ebu" to "embú",
    "ee" to "ewe",
    "efi" to "efik",
    "egl" to "emilianu",
    "egy" to "exipciu antiguu",
    "eka" to "ekajuk",
    "el" to "griegu",
    "elx" to "elamita",
    "en" to "inglés",
    "en-AU" to "inglés d’Australia",
    "en-CA" to "inglés de Canadá",
    "en-GB" to "inglés de Gran Bretaña",
    "en-GB-alt-short" to "inglés del R.X.",
    "en-US" to "inglés d’Estaos Xuníos",
    "en-US-alt-short" to "inglés d’EE.XX.",
    "enm" to "inglés mediu",
    "eo" to "esperanto",
    "es" to "español",
    "es-419" to "español d’América Llatina",
    "es-ES" to "español européu",
    "es-MX" to "español de Méxicu",
    "esu" to "yupik central",
    "et" to "estoniu",
    "eu" to "vascu",
    "ewo" to "ewondo",
    "ext" to "estremeñu",
    "fa" to "persa",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fulah",
    "fi" to "finlandés",
    "fil" to "filipín",
    "fit" to "finlandés de Tornedalen",
    "fj" to "fixanu",
    "fo" to "feroés",
    "fon" to "fon",
    "fr" to "francés",
    "fr-CA" to "francés de Canadá",
    "fr-CH" to "francés de Suiza",
    "frc" to "francés cajun",
    "frm" to "francés mediu",
    "fro" to "francés antiguu",
    "frp" to "arpitanu",
    "frr" to "frisón del norte",
    "frs" to "frisón oriental",
    "fur" to "friulianu",
    "fy" to "frisón occidental",
    "ga" to "irlandés",
    "gaa" to "ga",
    "gag" to "gagauz",
    "gan" to "chinu gan",
    "gay" to "gayo",
    "gba" to "gbaya",
    "gbz" to "dari zoroastrianu",
    "gd" to "gaélicu escocés",
    "gez" to "geez",
    "gil" to "gilbertés",
    "gl" to "gallegu",
    "glk" to "gilaki",
    "gmh" to "altualemán mediu",
    "gn" to "guaraní",
    "goh" to "altualemán antiguu",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "góticu",
    "grb" to "grebo",
    "grc" to "griegu antiguu",
    "gsw" to "alemán de Suiza",
    "gu" to "guyaratí",
    "guc" to "wayuu",
    "gur" to "frafra",
    "guz" to "gusii",
    "gv" to "manés",
    "gwi" to "gwichʼin",
    "ha" to "ḥausa",
    "hai" to "haida",
    "hak" to "chinu hakka",
    "haw" to "hawaianu",
    "he" to "hebréu",
    "hi" to "hindi",
    "hif" to "hindi de Fiji",
    "hil" to "hiligaynon",
    "hit" to "hitita",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "croata",
    "hsb" to "altu sorbiu",
    "hsn" to "chinu xiang",
    "ht" to "haitianu",
    "hu" to "húngaru",
    "hup" to "hupa",
    "hy" to "armeniu",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonesiu",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "yi de Sichuán",
    "ik" to "inupiaq",
    "ilo" to "iloko",
    "inh" to "ingush",
    "io" to "ido",
    "is" to "islandés",
    "it" to "italianu",
    "iu" to "inuktitut",
    "izh" to "ingrianu",
    "ja" to "xaponés",
    "jam" to "inglés criollu xamaicanu",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jpr" to "xudeo-persa",
    "jrb" to "xudeo-árabe",
    "jut" to "jutlandés",
    "jv" to "xavanés",
    "ka" to "xeorxanu",
    "kaa" to "kara-kalpak",
    "kab" to "kabileñu",
    "kac" to "kachin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kawi",
    "kbd" to "kabardianu",
    "kbl" to "kanembu",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "cabuverdianu",
    "ken" to "kenyang",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "kaingang",
    "kha" to "khasi",
    "kho" to "khotanés",
    "khq" to "koyra chiini",
    "khw" to "khowar",
    "ki" to "kikuyu",
    "kiu" to "kirmanjki",
    "kj" to "kuanyama",
    "kk" to "kazaquistanín",
    "kkj" to "kako",
    "kl" to "kalaallisut",
    "kln" to "kalenjin",
    "km" to "ḥemer",
    "kmb" to "kimbundu",
    "kn" to "canarés",
    "ko" to "coreanu",
    "koi" to "komi-permyak",
    "kok" to "konkani",
    "kos" to "kosraeanu",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karachay-balkar",
    "kri" to "krio",
    "krj" to "kinaray-a",
    "krl" to "karelianu",
    "kru" to "kurukh",
    "ks" to "cachemirés",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "colonianu",
    "ku" to "curdu",
    "kum" to "kumyk",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "córnicu",
    "ky" to "kirguistanín",
    "la" to "llatín",
    "lad" to "ladino",
    "lag" to "langi",
    "lah" to "lahnda",
    "lam" to "lamba",
    "lb" to "luxemburgués",
    "lez" to "lezghianu",
    "lfn" to "lingua franca nova",
    "lg" to "ganda",
    "li" to "limburgués",
    "lij" to "ligurianu",
    "liv" to "livonianu",
    "lkt" to "lakota",
    "lmo" to "lombardu",
    "ln" to "lingala",
    "lo" to "laosianu",
    "lol" to "mongo",
    "loz" to "lozi",
    "lrc" to "luri del norte",
    "lt" to "lituanu",
    "ltg" to "latgalianu",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lui" to "luiseno",
    "lun" to "lunda",
    "luo" to "luo",
    "lus" to "mizo",
    "luy" to "luyia",
    "lv" to "letón",
    "lzh" to "chinu lliterariu",
    "lzz" to "laz",
    "mad" to "madurés",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makasar",
    "man" to "mandingo",
    "mas" to "masái",
    "mde" to "maba",
    "mdf" to "moksha",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "morisyen",
    "mg" to "malgaxe",
    "mga" to "írlandés mediu",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta’",
    "mh" to "marshallés",
    "mi" to "maorí",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "macedoniu",
    "ml" to "malayalam",
    "mn" to "mongol",
    "mnc" to "manchú",
    "mni" to "manipuri",
    "moh" to "mohawk",
    "mos" to "mossi",
    "mr" to "marathi",
    "mrj" to "mari occidental",
    "ms" to "malayu",
    "mt" to "maltés",
    "mua" to "mundang",
    "mul" to "múltiples llingües",
    "mus" to "creek",
    "mwl" to "mirandés",
    "mwr" to "marwari",
    "mwv" to "mentawai",
    "my" to "birmanu",
    "mye" to "myene",
    "myv" to "erzya",
    "mzn" to "mazanderani",
    "na" to "nauru",
    "nan" to "chinu min nan",
    "nap" to "napolitanu",
    "naq" to "nama",
    "nb" to "noruegu Bokmål",
    "nd" to "ndebele del norte",
    "nds" to "baxu alemán",
    "nds-NL" to "baxu saxón",
    "ne" to "nepalés",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niueanu",
    "njo" to "ao naga",
    "nl" to "neerlandés",
    "nl-BE" to "flamencu",
    "nmg" to "kwasio",
    "nn" to "noruegu Nynorsk",
    "nnh" to "ngiemboon",
    "no" to "noruegu",
    "nog" to "nogai",
    "non" to "noruegu antiguu",
    "nov" to "novial",
    "nqo" to "n’ko",
    "nr" to "ndebele del sur",
    "nso" to "sotho del norte",
    "nus" to "nuer",
    "nv" to "navajo",
    "nwc" to "newari clásicu",
    "ny" to "nyanja",
    "nym" to "nyamwezi",
    "nyn" to "nyankole",
    "nyo" to "nyoro",
    "nzi" to "nzima",
    "oc" to "occitanu",
    "oj" to "ojibwa",
    "om" to "oromo",
    "or" to "oriya",
    "os" to "oséticu",
    "osa" to "osage",
    "ota" to "turcu otomanu",
    "pa" to "punyabí",
    "pag" to "pangasinan",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palauanu",
    "pcd" to "pícaru",
    "pcm" to "nixerianu simplificáu",
    "pdc" to "alemán de Pennsylvania",
    "pdt" to "plautdietsch",
    "peo" to "persa antiguu",
    "pfl" to "alemán palatinu",
    "phn" to "feniciu",
    "pi" to "pali",
    "pl" to "polacu",
    "pms" to "piamontés",
    "pnt" to "pónticu",
    "pon" to "pohnpeianu",
    "prg" to "prusianu",
    "pro" to "provenzal antiguu",
    "ps" to "pashtu",
    "pt" to "portugués",
    "pt-BR" to "portugués del Brasil",
    "pt-PT" to "portugués européu",
    "qu" to "quechua",
    "quc" to "kʼicheʼ",
    "qug" to "quichua del altiplanu de Chimborazo",
    "raj" to "rajasthanín",
    "rap" to "rapanui",
    "rar" to "rarotonganu",
    "rgn" to "romañol",
    "rif" to "rifianu",
    "rm" to "romanche",
    "rn" to "rundi",
    "ro" to "rumanu",
    "ro-MD" to "moldavu",
    "rof" to "rombo",
    "rom" to "romaní",
    "rtm" to "rotumanu",
    "ru" to "rusu",
    "rue" to "rusyn",
    "rug" to "roviana",
    "rup" to "aromanianu",
    "rw" to "kinyarwanda",
    "rwk" to "rwa",
    "sa" to "sánscritu",
    "sad" to "sandavés",
    "sah" to "sakha",
    "sam" to "araméu samaritanu",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "saz" to "saurashtra",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sardu",
    "scn" to "sicilianu",
    "sco" to "scots",
    "sd" to "sindhi",
    "sdc" to "sardu sassarés",
    "sdh" to "kurdu del sur",
    "se" to "sami del norte",
    "see" to "séneca",
    "seh" to "sena",
    "sei" to "seri",
    "sel" to "selkup",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sga" to "irlandés antiguu",
    "sgs" to "samogitianu",
    "sh" to "serbo-croata",
    "shi" to "tachelhit",
    "shn" to "shan",
    "shu" to "árabe chadianu",
    "si" to "cingalés",
    "sid" to "sidamo",
    "sk" to "eslovacu",
    "sl" to "eslovenu",
    "sli" to "baxu silesianu",
    "sly" to "selayarés",
    "sm" to "samoanu",
    "sma" to "sami del sur",
    "smj" to "lule sami",
    "smn" to "inari sami",
    "sms" to "skolt sami",
    "sn" to "shona",
    "snk" to "soninke",
    "so" to "somalín",
    "sog" to "sogdianu",
    "sq" to "albanu",
    "sr" to "serbiu",
    "srn" to "sranan tongo",
    "srr" to "serer",
    "ss" to "swati",
    "ssy" to "saho",
    "st" to "sotho del sur",
    "stq" to "frisón de Saterland",
    "su" to "sondanés",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumeriu",
    "sv" to "suecu",
    "sw" to "suaḥili",
    "sw-CD" to "suaḥili del Congu",
    "swb" to "comorianu",
    "syc" to "siriacu clásicu",
    "syr" to "siriacu",
    "szl" to "silesianu",
    "ta" to "tamil",
    "tcy" to "tulu",
    "te" to "telugu",
    "tem" to "timne",
    "teo" to "teso",
    "ter" to "terena",
    "tet" to "tetum",
    "tg" to "taxiquistanín",
    "th" to "tailandés",
    "ti" to "tigrinya",
    "tig" to "tigre",
    "tiv" to "tiv",
    "tk" to "turcomanu",
    "tkl" to "tokelau",
    "tkr" to "tsakhur",
    "tl" to "tagalog",
    "tlh" to "klingon",
    "tli" to "tlingit",
    "tly" to "talixín",
    "tmh" to "tamashek",
    "tn" to "tswana",
    "to" to "tonganu",
    "tog" to "tonga nyasa",
    "tpi" to "tok pisin",
    "tr" to "turcu",
    "tru" to "turoyo",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsd" to "tsakoniu",
    "tsi" to "tsimshian",
    "tt" to "tártaru",
    "ttt" to "tati musulmán",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitianu",
    "tyv" to "tuvinianu",
    "tzm" to "tamazight del Atles central",
    "udm" to "udmurt",
    "ug" to "uigur",
    "uga" to "ugaríticu",
    "uk" to "ucraín",
    "umb" to "umbundu",
    "und" to "llingua desconocida",
    "ur" to "urdu",
    "uz" to "uzbequistanín",
    "vai" to "vai",
    "ve" to "venda",
    "vec" to "venecianu",
    "vep" to "vepsiu",
    "vi" to "vietnamín",
    "vls" to "flamencu occidental",
    "vmf" to "franconianu del Main",
    "vo" to "volapük",
    "vot" to "vóticu",
    "vro" to "voro",
    "vun" to "vunjo",
    "wa" to "valón",
    "wae" to "walser",
    "wal" to "wolaytta",
    "war" to "waray",
    "was" to "washo",
    "wbp" to "warlpiri",
    "wo" to "wolof",
    "wuu" to "chinu wu",
    "xal" to "calmuco",
    "xh" to "xhosa",
    "xmf" to "mingrelianu",
    "xog" to "soga",
    "yao" to "yao",
    "yap" to "yapés",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "yiddish",
    "yo" to "yoruba",
    "yrl" to "nheengatu",
    "yue" to "cantonés",
    "yue-alt-menu" to "cantonés",
    "za" to "zhuang",
    "zap" to "zapoteca",
    "zbl" to "simbólicu Bliss",
    "zea" to "zeelandés",
    "zen" to "zenaga",
    "zgh" to "tamazight estándar de Marruecos",
    "zh" to "chinu",
    "zh-alt-menu" to "chinu",
    "zh-Hans" to "chinu simplificáu",
    "zh-Hans-alt-long" to "chinu simplificáu",
    "zh-Hant" to "chinu tradicional",
    "zh-Hant-alt-long" to "chinu tradicional",
    "zu" to "zulú",
    "zun" to "zuni",
    "zxx" to "ensin conteníu llingüísticu",
    "zza" to "zaza",
  ) }

  val az: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abxaz",
    "ace" to "akin",
    "ach" to "akoli",
    "ada" to "adanqme",
    "ady" to "adıgey",
    "ae" to "avestan",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aqhem",
    "ain" to "aynu",
    "ak" to "akan",
    "akk" to "akkad",
    "ale" to "aleut",
    "alt" to "cənubi altay",
    "am" to "amhar",
    "an" to "araqon",
    "ang" to "qədim ingilis",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "ərəb",
    "ar-001" to "müasir standart ərəb",
    "arc" to "aramik",
    "arn" to "mapuçe",
    "arp" to "arapaho",
    "ars" to "Nəcd ərəbcəsi",
    "arw" to "aravak",
    "as" to "assam",
    "asa" to "asu",
    "ast" to "asturiya",
    "atj" to "Atikamek",
    "av" to "avar",
    "awa" to "avadhi",
    "ay" to "aymara",
    "az" to "azərbaycan",
    "az-alt-short" to "azəri",
    "az-Arab" to "cənubi azərbaycan",
    "ba" to "başqırd",
    "bal" to "baluc",
    "ban" to "bali",
    "bas" to "basa",
    "be" to "belarus",
    "bej" to "beja",
    "bem" to "bemba",
    "bez" to "bena",
    "bg" to "bolqar",
    "bgc" to "Haryanvi",
    "bgn" to "qərbi bəluc",
    "bho" to "bxoçpuri",
    "bi" to "bislama",
    "bik" to "bikol",
    "bin" to "bini",
    "bla" to "siksikə",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "benqal",
    "bo" to "tibet",
    "br" to "breton",
    "bra" to "braj",
    "brx" to "bodo",
    "bs" to "bosniya",
    "bua" to "buryat",
    "bug" to "bugin",
    "byn" to "blin",
    "ca" to "katalan",
    "cad" to "keddo",
    "car" to "karib",
    "cay" to "Kayuqa",
    "cch" to "atsam",
    "ccp" to "Çakma",
    "ce" to "çeçen",
    "ceb" to "sebuan",
    "cgg" to "çiqa",
    "ch" to "çamoro",
    "chb" to "çibça",
    "chg" to "çağatay",
    "chk" to "çukiz",
    "chm" to "mari",
    "chn" to "çinuk ləhçəsi",
    "cho" to "çoktau",
    "chp" to "çipevyan",
    "chr" to "çeroki",
    "chy" to "çeyen",
    "ckb" to "Mərkəzi kürdcə",
    "ckb-alt-menu" to "Kürdcə, mərkəzi",
    "ckb-alt-variant" to "Kürdcə, sorani",
    "clc" to "Çilotin",
    "co" to "korsika",
    "cop" to "kopt",
    "cr" to "kri",
    "crg" to "miçif",
    "crh" to "krım türkcəsi",
    "crj" to "cənub-şərqi kri",
    "crk" to "ova kricəsi",
    "crl" to "şimal-şəqri kri",
    "crm" to "muz kri",
    "crr" to "Karolina alonkincəsi",
    "crs" to "Seyşel kreol fransızcası",
    "cs" to "çex",
    "csb" to "kaşubyan",
    "csw" to "bataqlıq kricəsi",
    "cu" to "slavyan",
    "cv" to "çuvaş",
    "cy" to "uels",
    "da" to "danimarka",
    "dak" to "dakota",
    "dar" to "darqva",
    "dav" to "taita",
    "de" to "alman",
    "de-AT" to "Avstriya almancası",
    "de-CH" to "İsveçrə yüksək almancası",
    "del" to "delaver",
    "den" to "slavey",
    "dgr" to "doqrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "doqri",
    "dsb" to "aşağı sorb",
    "dua" to "duala",
    "dum" to "orta holland",
    "dv" to "maldiv",
    "dyo" to "diola",
    "dyu" to "dyula",
    "dz" to "dzonqxa",
    "dzg" to "dazaqa",
    "ebu" to "embu",
    "ee" to "eve",
    "efi" to "efik",
    "egy" to "qədim misir",
    "eka" to "ekacuk",
    "el" to "yunan",
    "elx" to "elamit",
    "en" to "ingilis",
    "en-AU" to "Avstraliya ingiliscəsi",
    "en-CA" to "Kanada ingiliscəsi",
    "en-GB" to "Britaniya ingiliscəsi",
    "en-GB-alt-short" to "ingilis (BK)",
    "en-US" to "Amerika ingiliscəsi",
    "en-US-alt-short" to "ingilis (ABŞ)",
    "enm" to "orta ingilis",
    "eo" to "esperanto",
    "es" to "ispan",
    "es-419" to "Latın Amerikası ispancası",
    "es-ES" to "Kastiliya ispancası",
    "es-MX" to "Meksika ispancası",
    "et" to "eston",
    "eu" to "bask",
    "ewo" to "evondo",
    "fa" to "fars",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fula",
    "fi" to "fin",
    "fil" to "filippin",
    "fj" to "fici",
    "fo" to "farer",
    "fon" to "fon",
    "fr" to "fransız",
    "fr-CA" to "Kanada fransızcası",
    "fr-CH" to "İsveçrə fransızcası",
    "frc" to "Kacun fransızcası",
    "frm" to "orta fransız",
    "fro" to "qədim fransız",
    "frr" to "şimali fris",
    "fur" to "friul",
    "fy" to "qərbi friz",
    "ga" to "irland",
    "gaa" to "qa",
    "gag" to "qaqauz",
    "gan" to "qan",
    "gay" to "qayo",
    "gba" to "qabaya",
    "gd" to "Şotlandiya keltcəsi",
    "gez" to "qez",
    "gil" to "qilbert",
    "gl" to "qalisiya",
    "gmh" to "orta yüksək alman",
    "gn" to "quarani",
    "goh" to "qədim alman",
    "gon" to "qondi",
    "gor" to "qorontalo",
    "got" to "qotika",
    "grb" to "qrebo",
    "grc" to "qədim yunan",
    "gsw" to "İsveçrə almancası",
    "gu" to "qucarat",
    "guz" to "qusi",
    "gv" to "manks",
    "gwi" to "qviçin",
    "ha" to "hausa",
    "hai" to "hayda",
    "hak" to "hakka",
    "haw" to "havay",
    "hax" to "cənubi haida",
    "he" to "ivrit",
    "hi" to "hind",
    "hi-Latn" to "Hindi (latın)",
    "hi-Latn-alt-variant" to "Hindi (latın)",
    "hil" to "hiliqaynon",
    "hit" to "hittit",
    "hmn" to "monq",
    "ho" to "hiri motu",
    "hr" to "xorvat",
    "hsb" to "yuxarı sorb",
    "hsn" to "syan",
    "ht" to "haiti kreol",
    "hu" to "macar",
    "hup" to "hupa",
    "hur" to "Halkomelem",
    "hy" to "erməni",
    "hz" to "herero",
    "ia" to "interlinqua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indoneziya",
    "ie" to "interlinqve",
    "ig" to "iqbo",
    "ii" to "siçuan yi",
    "ik" to "inupiaq",
    "ikt" to "qərbi Kanada inuktitutu",
    "ilo" to "iloko",
    "inh" to "inquş",
    "io" to "ido",
    "is" to "island",
    "it" to "italyan",
    "iu" to "inuktitut",
    "ja" to "yapon",
    "jbo" to "loğban",
    "jgo" to "nqomba",
    "jmc" to "maçam",
    "jpr" to "ivrit-fars",
    "jrb" to "ivrit-ərəb",
    "jv" to "yava",
    "ka" to "gürcü",
    "kaa" to "qaraqalpaq",
    "kab" to "kabile",
    "kac" to "kaçin",
    "kaj" to "ju",
    "kam" to "kamba",
    "kaw" to "kavi",
    "kbd" to "kabarda-çərkəz",
    "kcg" to "tiyap",
    "kde" to "makond",
    "kea" to "kabuverdian",
    "kfo" to "koro",
    "kg" to "konqo",
    "kgp" to "kaiqanq",
    "kha" to "xazi",
    "kho" to "xotan",
    "khq" to "koyra çiini",
    "ki" to "kikuyu",
    "kj" to "kuanyama",
    "kk" to "qazax",
    "kkj" to "kako",
    "kl" to "kalaallisut",
    "kln" to "kalencin",
    "km" to "kxmer",
    "kmb" to "kimbundu",
    "kn" to "kannada",
    "ko" to "koreya",
    "koi" to "komi-permyak",
    "kok" to "konkani",
    "kos" to "kosreyan",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "qaraçay-balkar",
    "krl" to "karel",
    "kru" to "kurux",
    "ks" to "kəşmir",
    "ksb" to "şambala",
    "ksf" to "bafia",
    "ksh" to "köln",
    "ku" to "kürd",
    "kum" to "kumık",
    "kut" to "kutenay",
    "kv" to "komi",
    "kw" to "korn",
    "kwk" to "Kvakvala",
    "kxv" to "kuvi",
    "ky" to "qırğız",
    "la" to "latın",
    "lad" to "sefard",
    "lag" to "langi",
    "lah" to "qərbi pəncab",
    "lam" to "lamba",
    "lb" to "lüksemburq",
    "lez" to "ləzgi",
    "lg" to "qanda",
    "li" to "limburq",
    "lij" to "liquriya dili",
    "lil" to "Liluet",
    "lkt" to "lakota",
    "lmo" to "lombard dili",
    "ln" to "linqala",
    "lo" to "laos",
    "lol" to "monqo",
    "lou" to "Luiziana kreolu",
    "loz" to "lozi",
    "lrc" to "şimali luri",
    "lsm" to "saamia",
    "lt" to "litva",
    "lu" to "luba-katanqa",
    "lua" to "luba-lulua",
    "lui" to "luyseno",
    "lun" to "lunda",
    "lus" to "mizo",
    "luy" to "luyia",
    "lv" to "latış",
    "mad" to "maduriz",
    "mag" to "maqahi",
    "mai" to "maitili",
    "mak" to "makasar",
    "man" to "məndinqo",
    "mas" to "masay",
    "mdf" to "mokşa",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "morisien",
    "mg" to "malaqas",
    "mga" to "orta irland",
    "mgh" to "maxuva-meetto",
    "mgo" to "meta’",
    "mh" to "marşal",
    "mi" to "māori",
    "mic" to "mikmak",
    "min" to "minanqkaban",
    "mk" to "makedon",
    "ml" to "malayalam",
    "mn" to "monqol",
    "mnc" to "mançu",
    "mni" to "manipüri",
    "moe" to "İnnu-aimun",
    "moh" to "mohavk",
    "mos" to "mosi",
    "mr" to "marathi",
    "ms" to "malay",
    "mt" to "malta",
    "mua" to "mundanq",
    "mul" to "çoxsaylı dillər",
    "mus" to "krik",
    "mwl" to "mirand",
    "mwr" to "maruari",
    "my" to "birman",
    "myv" to "erzya",
    "mzn" to "mazandaran",
    "na" to "nauru",
    "nan" to "Min Nan",
    "nap" to "neapolitan",
    "naq" to "nama",
    "nb" to "bokmal norveç",
    "nd" to "şimali ndebele",
    "nds" to "aşağı alman",
    "nds-NL" to "aşağı sakson",
    "ne" to "nepal",
    "new" to "nevari",
    "ng" to "ndonqa",
    "nia" to "nias",
    "niu" to "niyuan",
    "nl" to "holland",
    "nl-BE" to "flamand",
    "nmg" to "kvasio",
    "nn" to "nünorsk norveç",
    "nnh" to "ngiemboon",
    "no" to "norveç",
    "nog" to "noqay",
    "non" to "qədim nors",
    "nqo" to "nko",
    "nr" to "cənubi ndebele",
    "nso" to "şimal soto",
    "nus" to "nuer",
    "nv" to "navayo",
    "ny" to "nyanca",
    "nym" to "nyamvezi",
    "nyn" to "nyankol",
    "nyo" to "nyoro",
    "nzi" to "nzima",
    "oc" to "oksitan",
    "oj" to "ocibva",
    "ojb" to "şimal-qərbi ocibva",
    "ojc" to "Mərkəzi ocibva",
    "ojs" to "ocikri",
    "ojw" to "qərbi ocibva",
    "oka" to "okanaqan",
    "om" to "oromo",
    "or" to "odiya",
    "os" to "osetin",
    "osa" to "osage",
    "ota" to "osman",
    "pa" to "pəncab",
    "pag" to "panqasinan",
    "pal" to "pəhləvi",
    "pam" to "pampanqa",
    "pap" to "papyamento",
    "pau" to "palayan",
    "pcm" to "niger kreol",
    "peo" to "qədim fars",
    "phn" to "foyenik",
    "pi" to "pali",
    "pis" to "picin",
    "pl" to "polyak",
    "pon" to "ponpey",
    "pqm" to "malesit-passamakvodi",
    "prg" to "pruss",
    "pro" to "qədim provansal",
    "ps" to "puştu",
    "pt" to "portuqal",
    "pt-BR" to "Braziliya portuqalcası",
    "pt-PT" to "Portuqaliya portuqalcası",
    "qu" to "keçua",
    "quc" to "kiçe",
    "raj" to "racastani",
    "rap" to "rapanui",
    "rar" to "rarotonqan",
    "rhg" to "Rohinca",
    "rm" to "romanş",
    "rn" to "rundi",
    "ro" to "rumın",
    "ro-MD" to "moldav",
    "rof" to "rombo",
    "rom" to "roman",
    "ru" to "rus",
    "rup" to "aroman",
    "rw" to "kinyarvanda",
    "rwk" to "rua",
    "sa" to "sanskrit",
    "sad" to "sandave",
    "sah" to "saxa",
    "sam" to "samaritan",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santal",
    "sba" to "nqambay",
    "sbp" to "sanqu",
    "sc" to "sardin",
    "scn" to "siciliya",
    "sco" to "skots",
    "sd" to "sindhi",
    "sdh" to "cənubi kürd",
    "se" to "şimali sami",
    "seh" to "sena",
    "sel" to "selkup",
    "ses" to "koyraboro senni",
    "sg" to "sanqo",
    "sga" to "qədim irland",
    "sh" to "serb-xorvat",
    "shi" to "taçelit",
    "shn" to "şan",
    "si" to "sinhala",
    "sid" to "sidamo",
    "sk" to "slovak",
    "sl" to "sloven",
    "slh" to "cənubi luşusid",
    "sm" to "samoa",
    "sma" to "cənubi sami",
    "smj" to "lule sami",
    "smn" to "inari sami",
    "sms" to "skolt sami",
    "sn" to "şona",
    "snk" to "soninke",
    "so" to "somali",
    "sog" to "soqdiyen",
    "sq" to "alban",
    "sr" to "serb",
    "srn" to "sranan tonqo",
    "srr" to "serer",
    "ss" to "svati",
    "ssy" to "saho",
    "st" to "sesoto",
    "str" to "streyts saliş",
    "su" to "sundan",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumeryan",
    "sv" to "isveç",
    "sw" to "suahili",
    "sw-CD" to "Konqo suahilicəsi",
    "swb" to "komor",
    "syr" to "suriya",
    "szl" to "silez dili",
    "ta" to "tamil",
    "tce" to "cənubi tuçon",
    "te" to "teluqu",
    "tem" to "timne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetum",
    "tg" to "tacik",
    "tgx" to "taq",
    "th" to "tay",
    "tht" to "taltan",
    "ti" to "tiqrin",
    "tig" to "tiqre",
    "tiv" to "tiv",
    "tk" to "türkmən",
    "tkl" to "tokelay",
    "tl" to "taqaloq",
    "tlh" to "klinqon",
    "tli" to "tlinqit",
    "tmh" to "tamaşek",
    "tn" to "svana",
    "to" to "tonqa",
    "tog" to "nyasa tonqa",
    "tok" to "tokipona",
    "tpi" to "tok pisin",
    "tr" to "türk",
    "trv" to "taroko",
    "ts" to "sonqa",
    "tsi" to "simşyan",
    "tt" to "tatar",
    "ttm" to "şimali tuçon",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "tvi",
    "twq" to "tasavaq",
    "ty" to "taxiti",
    "tyv" to "tuvinyan",
    "tzm" to "Mərkəzi Atlas tamazicəsi",
    "udm" to "udmurt",
    "ug" to "uyğur",
    "uga" to "uqarit",
    "uk" to "ukrayna",
    "umb" to "umbundu",
    "und" to "naməlum dil",
    "ur" to "urdu",
    "uz" to "özbək",
    "ve" to "venda",
    "vec" to "venet dili",
    "vi" to "vyetnam",
    "vmw" to "makua dili",
    "vo" to "volapük",
    "vot" to "votik",
    "vun" to "vunyo",
    "wa" to "valun",
    "wae" to "valles",
    "wal" to "valamo",
    "war" to "varay",
    "was" to "vaşo",
    "wbp" to "valpiri",
    "wo" to "volof",
    "wuu" to "vu",
    "xal" to "kalmık",
    "xh" to "xosa",
    "xnr" to "kanqri",
    "xog" to "soqa",
    "yao" to "yao",
    "yap" to "yapiz",
    "yav" to "yanqben",
    "ybb" to "yemba",
    "yi" to "idiş",
    "yo" to "yoruba",
    "yrl" to "nyenqatu",
    "yue" to "kanton",
    "yue-alt-menu" to "Çin, kanton",
    "za" to "çjuan",
    "zap" to "zapotek",
    "zbl" to "blisimbols",
    "zen" to "zenaqa",
    "zgh" to "tamazi",
    "zh" to "çin",
    "zh-alt-menu" to "Çin, mandarin",
    "zh-Hans" to "sadələşmiş çin",
    "zh-Hans-alt-long" to "sadələşmiş mandarin çincəsi",
    "zh-Hant" to "ənənəvi çin",
    "zh-Hant-alt-long" to "ənənəvi mandarin çincəsi",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "dil məzmunu yoxdur",
    "zza" to "zaza",
  ) }

  val az_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ab" to "آبخازجا",
    "af" to "آفریکانس",
    "agq" to "آقمجه",
    "ak" to "آکانجا",
    "am" to "آمهارجا",
    "ar" to "عربجه",
    "ar-001" to "استاندارد عربجه",
    "as" to "آسامجا",
    "asa" to "آسوجا",
    "az" to "آذربایجان تۆرکجه‌سی",
    "az-alt-short" to "آذریجه",
    "az-Arab" to "تۆرکجه",
    "ba" to "باشقیرجا",
    "be" to "بئلاروسجا",
    "bem" to "بئمباجا",
    "bez" to "بئناجا",
    "bg" to "بۇلقارجا",
    "bgn" to "دوْغو بلوچجا",
    "bm" to "بامباراجا",
    "bn" to "بنگالجا",
    "br" to "برئتونجا",
    "brx" to "بوْدوجا",
    "bs" to "بوْسنیاجا",
    "ca" to "کاتالانجا",
    "ce" to "چئچئنجه",
    "cgg" to "چیقاجا",
    "chr" to "چئروکیجه",
    "ckb" to "اوْرتا کۆردجه",
    "ckb-alt-menu" to "اوْرتا کۆردجه",
    "ckb-alt-variant" to "اوْرتا کۆردجه",
    "co" to "کوْرسیکاجا",
    "cs" to "چئکجه",
    "cv" to "چۇواشجا",
    "da" to "دانجا",
    "de" to "آلمانجا",
    "dua" to "دۇالاجا",
    "dz" to "دزونگخا",
    "ebu" to "ائمبوجا",
    "ee" to "اِوه‌جه",
    "el" to "یونانجا",
    "en" to "اینگیلیزجه",
    "eo" to "اِسپرانتو",
    "es" to "اسپانیاجا",
    "es-419" to "لاتین آمریکا اسپانیاجاسی",
    "es-ES" to "اۇروپا اسپانیاجاسی",
    "es-MX" to "مکزیک اسپانیاجاسی",
    "et" to "اِستونجا",
    "eu" to "باسکجا",
    "fa" to "فارسجا",
    "fi" to "فینجه",
    "fil" to "فیلیپینجه",
    "fj" to "فیجیجه",
    "fo" to "فاروئه‌جه",
    "fr" to "فرانساجا",
    "gag" to "قاقائوزجا",
    "gl" to "قالیسیاجا",
    "gsw" to "سویس آلمانجاسی",
    "he" to "عبریجه",
    "hi" to "هیندجه",
    "hr" to "کروواسجا",
    "hy" to "ائرمنیجه",
    "it" to "ایتالیاجا",
    "ja" to "ژاپونجا",
    "ka" to "گۆرجوجه",
    "kk" to "قازاقجا",
    "km" to "خمئرجه",
    "ko" to "کوْره‌جه",
    "ks" to "کشمیرجه",
    "ksf" to "بافیاجا",
    "ku" to "کۆردجه",
    "kw" to "کوْرنجا",
    "ky" to "قیرقیزجا",
    "la" to "لاتینجه",
    "lg" to "قانداجا",
    "lrc" to "قۇزئی لوْرجه",
    "mk" to "مقدونیجه",
    "mn" to "موْغولجا",
    "my" to "بۇرماجا",
    "mzn" to "مازنیجه",
    "nl" to "هوْلندجه",
    "pa" to "پنجابجا",
    "ps" to "پشتوجه",
    "pt" to "پوْرتغالجه",
    "ro" to "رومانیاجا",
    "ru" to "روسجا",
    "sd" to "سیندیجه",
    "sdh" to "گۆنئی کۆردجه",
    "sk" to "اسلواکجا",
    "sq" to "آلبانیاجا",
    "sr" to "صربجه",
    "sv" to "سوئدجه",
    "sw" to "سواحیلیجه",
    "sw-CD" to "کوْنقو سواحیلیسی",
    "ta" to "تامیلجه",
    "tg" to "تاجیکجه",
    "tk" to "تۆرکمنجه",
    "tr" to "آنادولو تۆرکجه‌سی",
    "tt" to "تاتارجا",
    "ug" to "اۇیغورجا",
    "uk" to "اۇکراینجا",
    "und" to "تانینمایان دیل",
    "ur" to "اوْردوجا",
    "uz" to "اؤزبکجه",
    "vi" to "ویتنامجا",
    "zh" to "چینجه",
    "zh-alt-menu" to "چینجه",
    "zh-Hans" to "ساده‌لنمیش چینجه",
    "zh-Hans-alt-long" to "ساده‌لنمیش چینجه",
    "zh-Hant" to "سنتی چینجه",
    "zh-Hant-alt-long" to "سنتی چینجه",
    "zu" to "زۇلوجا",
  ) }

  val az_Arab_IQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val az_Arab_TR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val az_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "афар",
    "ab" to "абхаз",
    "ace" to "акин",
    "ada" to "адангме",
    "ady" to "адуҝе",
    "af" to "африкаанс",
    "agq" to "агһем",
    "ain" to "ајну",
    "ak" to "акан",
    "ale" to "алеут",
    "alt" to "ҹәнуби алтај",
    "am" to "амһар",
    "an" to "арагон",
    "anp" to "анҝика",
    "ar" to "әрәб",
    "ar-001" to "мүасир стандарт әрәб",
    "arn" to "арауканҹа",
    "arp" to "арапаһо",
    "as" to "ассам",
    "asa" to "асу",
    "ast" to "астурија",
    "av" to "авар",
    "awa" to "авадһи",
    "ay" to "ајмара",
    "az" to "азәрбајҹан",
    "az-alt-short" to "азәрбајҹан",
    "ba" to "башгырд",
    "ban" to "балли",
    "bas" to "баса",
    "be" to "беларус",
    "bem" to "бемба",
    "bez" to "бена",
    "bg" to "булгар",
    "bho" to "бхочпури",
    "bi" to "бислама",
    "bin" to "бини",
    "bla" to "сиксикә",
    "bm" to "бамбара",
    "bn" to "бенгал",
    "bo" to "тибет",
    "br" to "бретон",
    "brx" to "бодо",
    "bs" to "босниак",
    "bug" to "буҝин",
    "byn" to "блин",
    "ca" to "каталан",
    "ce" to "чечен",
    "ceb" to "себуан",
    "cgg" to "чига",
    "ch" to "чаморо",
    "chk" to "чукиз",
    "chm" to "мари",
    "cho" to "чоктау",
    "chr" to "чероки",
    "chy" to "чејен",
    "ckb" to "соран",
    "ckb-alt-menu" to "соран",
    "ckb-alt-variant" to "соран",
    "co" to "корсика",
    "crs" to "сејшел креолу",
    "cs" to "чех",
    "cu" to "славјан",
    "cv" to "чуваш",
    "cy" to "уелс",
    "da" to "данимарка",
    "dak" to "дакота",
    "dar" to "даргва",
    "dav" to "таита",
    "de" to "алман",
    "de-AT" to "Австрија алманҹасы",
    "de-CH" to "Исвечрә јүксәк алманҹасы",
    "dgr" to "догриб",
    "dje" to "зарма",
    "dsb" to "ашағы сорб",
    "dua" to "дуала",
    "dv" to "малдив",
    "dyo" to "диола",
    "dz" to "дзонга",
    "dzg" to "дазага",
    "ebu" to "ембу",
    "ee" to "еве",
    "efi" to "ефик",
    "eka" to "екаҹук",
    "el" to "јунан",
    "en" to "инҝилис",
    "en-AU" to "Австралија инҝилисҹәси",
    "en-CA" to "Канада инҝилисҹәси",
    "en-GB" to "Британија инҝилисҹәси",
    "en-GB-alt-short" to "инҝилис (Б.К.)",
    "en-US" to "Америка инҝилисҹәси",
    "en-US-alt-short" to "инҝилис (АБШ)",
    "eo" to "есперанто",
    "es" to "испан",
    "es-419" to "Латын Америкасы испанҹасы",
    "es-ES" to "Кастилија испанҹасы",
    "es-MX" to "Мексика испанҹасы",
    "et" to "естон",
    "eu" to "баск",
    "ewo" to "евондо",
    "fa" to "фарс",
    "ff" to "фула",
    "fi" to "фин",
    "fil" to "филиппин",
    "fj" to "фиҹи",
    "fo" to "фарер",
    "fon" to "фон",
    "fr" to "франсыз",
    "fr-CA" to "Канада франсызҹасы",
    "fr-CH" to "Исвечрә франсызҹасы",
    "fur" to "фриул",
    "fy" to "гәрби фриз",
    "ga" to "ирланд",
    "gaa" to "га",
    "gd" to "шотланд келт",
    "gez" to "гез",
    "gil" to "гилберт",
    "gl" to "галисија",
    "gn" to "гуарани",
    "gor" to "горонтало",
    "gsw" to "Исвечрә алманҹасы",
    "gu" to "гуҹарат",
    "guz" to "гуси",
    "gv" to "манкс",
    "gwi" to "гвичин",
    "ha" to "һауса",
    "haw" to "һавај",
    "he" to "иврит",
    "hi" to "һинд",
    "hil" to "һилигајнон",
    "hmn" to "монг",
    "hr" to "хорват",
    "hsb" to "јухары сорб",
    "ht" to "һаити креол",
    "hu" to "маҹар",
    "hup" to "һупа",
    "hy" to "ермәни",
    "hz" to "һереро",
    "ia" to "интерлингве",
    "iba" to "ибан",
    "ibb" to "ибибио",
    "id" to "индонезија",
    "ig" to "игбо",
    "ilo" to "илоко",
    "inh" to "ингуш",
    "io" to "идо",
    "is" to "исланд",
    "it" to "италјан",
    "iu" to "инуктитут",
    "ja" to "јапон",
    "jbo" to "лоғбан",
    "jgo" to "нгомба",
    "jmc" to "мачам",
    "jv" to "јава",
    "ka" to "ҝүрҹү",
    "kab" to "кабиле",
    "kac" to "качин",
    "kaj" to "жу",
    "kam" to "камба",
    "kbd" to "кабарда-чәркәз",
    "kcg" to "тви",
    "kde" to "маконде",
    "kea" to "кабувердиан",
    "kfo" to "коро",
    "kha" to "хази",
    "khq" to "којра чиини",
    "ki" to "кикују",
    "kj" to "куанјама",
    "kk" to "газах",
    "kkj" to "како",
    "kl" to "калааллисут",
    "kln" to "каленҹин",
    "km" to "кхмер",
    "kmb" to "кимбунду",
    "kn" to "каннада",
    "ko" to "кореја",
    "kok" to "конкани",
    "kpe" to "кпелле",
    "kr" to "канури",
    "krc" to "гарачај-балкар",
    "krl" to "карел",
    "kru" to "курух",
    "ks" to "кәшмир",
    "ksb" to "шамбала",
    "ksf" to "бафиа",
    "ksh" to "көлн",
    "ku" to "күрд",
    "kum" to "кумык",
    "kv" to "коми",
    "kw" to "корн",
    "ky" to "гырғыз",
    "la" to "латын",
    "lad" to "сефард",
    "lag" to "ланҝи",
    "lb" to "лүксембург",
    "lez" to "ләзҝи",
    "lg" to "ганда",
    "li" to "лимбург",
    "lkt" to "лакота",
    "ln" to "лингала",
    "lo" to "лаос",
    "loz" to "лози",
    "lrc" to "шимали лури",
    "lt" to "литва",
    "lu" to "луба-катанга",
    "lua" to "луба-лулуа",
    "lun" to "лунда",
    "luo" to "луо",
    "lus" to "мизо",
    "luy" to "лујиа",
    "lv" to "латыш",
    "mad" to "мадуриз",
    "mag" to "магаһи",
    "mai" to "маитили",
    "mak" to "макасар",
    "mas" to "масај",
    "mdf" to "мокша",
    "men" to "менде",
    "mer" to "меру",
    "mfe" to "морисиен",
    "mg" to "малагас",
    "mgh" to "махува-меетто",
    "mgo" to "метаʼ",
    "mh" to "маршал",
    "mi" to "маори",
    "mic" to "микмак",
    "min" to "минангкабан",
    "mk" to "македон",
    "ml" to "малајалам",
    "mn" to "монгол",
    "mni" to "манипүри",
    "moh" to "моһавк",
    "mos" to "моси",
    "mr" to "маратһи",
    "ms" to "малај",
    "mt" to "малта",
    "mua" to "мунданг",
    "mul" to "чохсајлы дилләр",
    "mus" to "крик",
    "mwl" to "миранд",
    "my" to "бирман",
    "myv" to "ерзја",
    "mzn" to "мазандаран",
    "na" to "науру",
    "nap" to "неаполитан",
    "naq" to "нама",
    "nb" to "бокмал норвеч",
    "nd" to "шимали ндебеле",
    "nds-NL" to "ашағы саксон",
    "ne" to "непал",
    "new" to "невари",
    "ng" to "ндонга",
    "nia" to "ниас",
    "niu" to "нијуан",
    "nl" to "һолланд",
    "nl-BE" to "фламанд",
    "nmg" to "квасио",
    "nn" to "нүнорск норвеч",
    "nnh" to "нҝиембоон",
    "nog" to "ногај",
    "nqo" to "нго",
    "nr" to "ҹәнуби ндебеле",
    "nso" to "шимали сото",
    "nus" to "нуер",
    "nv" to "навајо",
    "ny" to "нјанҹа",
    "nyn" to "нјанкол",
    "oc" to "окситан",
    "om" to "оромо",
    "or" to "одија",
    "os" to "осетин",
    "pa" to "пәнҹаб",
    "pag" to "пангасинан",
    "pam" to "пампанга",
    "pap" to "папјаменто",
    "pau" to "палајан",
    "pcm" to "ниҝер креол",
    "pl" to "полјак",
    "prg" to "прусс",
    "ps" to "пушту",
    "pt" to "португал",
    "pt-BR" to "Бразилија португалҹасы",
    "pt-PT" to "Португалија португалҹасы",
    "qu" to "кечуа",
    "quc" to "киче",
    "rap" to "рапануи",
    "rar" to "раротонган",
    "rm" to "романш",
    "rn" to "рунди",
    "ro" to "румын",
    "rof" to "ромбо",
    "ru" to "рус",
    "rup" to "ароман",
    "rw" to "кинјарванда",
    "rwk" to "руа",
    "sa" to "санскрит",
    "sad" to "сандаве",
    "sah" to "саха",
    "saq" to "самбуру",
    "sat" to "сантал",
    "sba" to "нгамбај",
    "sbp" to "сангу",
    "sc" to "сардин",
    "scn" to "сиҹилија",
    "sco" to "скотс",
    "sd" to "синдһи",
    "se" to "шимали сами",
    "seh" to "сена",
    "ses" to "којраборо сенни",
    "sg" to "санго",
    "shi" to "тачелит",
    "shn" to "шан",
    "si" to "синһала",
    "sk" to "словак",
    "sl" to "словен",
    "sm" to "самоа",
    "sma" to "ҹәнуби сами",
    "smj" to "луле сами",
    "smn" to "инари сами",
    "sms" to "сколт сами",
    "sn" to "шона",
    "snk" to "сонинке",
    "so" to "сомали",
    "sq" to "албан",
    "sr" to "серб",
    "srn" to "сранан тонго",
    "ss" to "свати",
    "ssy" to "саһо",
    "st" to "сесото",
    "su" to "сундан",
    "suk" to "сукума",
    "sv" to "исвеч",
    "sw" to "суаһили",
    "sw-CD" to "Конго суаһилиҹәси",
    "swb" to "комор",
    "syr" to "сурија",
    "ta" to "тамил",
    "te" to "телугу",
    "tem" to "тимне",
    "teo" to "тесо",
    "tet" to "тетум",
    "tg" to "таҹик",
    "th" to "тај",
    "ti" to "тигрин",
    "tig" to "тигре",
    "tk" to "түркмән",
    "tlh" to "клингон",
    "tn" to "свана",
    "to" to "тонган",
    "tpi" to "ток писин",
    "tr" to "түрк",
    "trv" to "тароко",
    "ts" to "сонга",
    "tt" to "татар",
    "tum" to "тумбука",
    "tvl" to "тувалу",
    "twq" to "тасаваг",
    "ty" to "тахити",
    "tyv" to "тувинјан",
    "tzm" to "Мәркәзи Атлас тамазиҹәси",
    "udm" to "удмурт",
    "ug" to "ујғур",
    "uk" to "украјна",
    "umb" to "умбунду",
    "und" to "намәлум дил",
    "ur" to "урду",
    "uz" to "өзбәк",
    "vai" to "ваи",
    "ve" to "венда",
    "vi" to "вјетнам",
    "vo" to "волапүк",
    "vun" to "вунјо",
    "wa" to "валун",
    "wae" to "валлес",
    "wal" to "валамо",
    "war" to "варај",
    "wo" to "волоф",
    "xal" to "калмык",
    "xh" to "хоса",
    "xog" to "сога",
    "yav" to "јангбен",
    "ybb" to "јемба",
    "yi" to "идиш",
    "yo" to "јоруба",
    "yue" to "кантон",
    "yue-alt-menu" to "кантон",
    "zgh" to "тамази",
    "zh" to "чин",
    "zh-alt-menu" to "чин",
    "zh-Hans" to "садәләшмиш чин",
    "zh-Hans-alt-long" to "садәләшмиш чин",
    "zh-Hant" to "әнәнәви чин",
    "zh-Hant-alt-long" to "әнәнәви чин",
    "zu" to "зулу",
    "zun" to "зуни",
    "zxx" to "дил мәзмуну јохдур",
    "zza" to "заза",
  ) }

  val az_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abxaz",
    "ace" to "akin",
    "ach" to "akoli",
    "ada" to "adanqme",
    "ady" to "adıgey",
    "ae" to "avestan",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aqhem",
    "ain" to "aynu",
    "ak" to "akan",
    "akk" to "akkad",
    "ale" to "aleut",
    "alt" to "cənubi altay",
    "am" to "amhar",
    "an" to "araqon",
    "ang" to "qədim ingilis",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "ərəb",
    "ar-001" to "müasir standart ərəb",
    "arc" to "aramik",
    "arn" to "mapuçe",
    "arp" to "arapaho",
    "ars" to "Nəcd ərəbcəsi",
    "arw" to "aravak",
    "as" to "assam",
    "asa" to "asu",
    "ast" to "asturiya",
    "atj" to "Atikamek",
    "av" to "avar",
    "awa" to "avadhi",
    "ay" to "aymara",
    "az" to "azərbaycan",
    "az-alt-short" to "azəri",
    "az-Arab" to "cənubi azərbaycan",
    "ba" to "başqırd",
    "bal" to "baluc",
    "ban" to "bali",
    "bas" to "basa",
    "be" to "belarus",
    "bej" to "beja",
    "bem" to "bemba",
    "bez" to "bena",
    "bg" to "bolqar",
    "bgc" to "Haryanvi",
    "bgn" to "qərbi bəluc",
    "bho" to "bxoçpuri",
    "bi" to "bislama",
    "bik" to "bikol",
    "bin" to "bini",
    "bla" to "siksikə",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "benqal",
    "bo" to "tibet",
    "br" to "breton",
    "bra" to "braj",
    "brx" to "bodo",
    "bs" to "bosniya",
    "bua" to "buryat",
    "bug" to "bugin",
    "byn" to "blin",
    "ca" to "katalan",
    "cad" to "keddo",
    "car" to "karib",
    "cay" to "Kayuqa",
    "cch" to "atsam",
    "ccp" to "Çakma",
    "ce" to "çeçen",
    "ceb" to "sebuan",
    "cgg" to "çiqa",
    "ch" to "çamoro",
    "chb" to "çibça",
    "chg" to "çağatay",
    "chk" to "çukiz",
    "chm" to "mari",
    "chn" to "çinuk ləhçəsi",
    "cho" to "çoktau",
    "chp" to "çipevyan",
    "chr" to "çeroki",
    "chy" to "çeyen",
    "ckb" to "Mərkəzi kürdcə",
    "ckb-alt-menu" to "Kürdcə, mərkəzi",
    "ckb-alt-variant" to "Kürdcə, sorani",
    "clc" to "Çilotin",
    "co" to "korsika",
    "cop" to "kopt",
    "cr" to "kri",
    "crg" to "miçif",
    "crh" to "krım türkcəsi",
    "crj" to "cənub-şərqi kri",
    "crk" to "ova kricəsi",
    "crl" to "şimal-şəqri kri",
    "crm" to "muz kri",
    "crr" to "Karolina alonkincəsi",
    "crs" to "Seyşel kreol fransızcası",
    "cs" to "çex",
    "csb" to "kaşubyan",
    "csw" to "bataqlıq kricəsi",
    "cu" to "slavyan",
    "cv" to "çuvaş",
    "cy" to "uels",
    "da" to "danimarka",
    "dak" to "dakota",
    "dar" to "darqva",
    "dav" to "taita",
    "de" to "alman",
    "de-AT" to "Avstriya almancası",
    "de-CH" to "İsveçrə yüksək almancası",
    "del" to "delaver",
    "den" to "slavey",
    "dgr" to "doqrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "doqri",
    "dsb" to "aşağı sorb",
    "dua" to "duala",
    "dum" to "orta holland",
    "dv" to "maldiv",
    "dyo" to "diola",
    "dyu" to "dyula",
    "dz" to "dzonqxa",
    "dzg" to "dazaqa",
    "ebu" to "embu",
    "ee" to "eve",
    "efi" to "efik",
    "egy" to "qədim misir",
    "eka" to "ekacuk",
    "el" to "yunan",
    "elx" to "elamit",
    "en" to "ingilis",
    "en-AU" to "Avstraliya ingiliscəsi",
    "en-CA" to "Kanada ingiliscəsi",
    "en-GB" to "Britaniya ingiliscəsi",
    "en-GB-alt-short" to "ingilis (BK)",
    "en-US" to "Amerika ingiliscəsi",
    "en-US-alt-short" to "ingilis (ABŞ)",
    "enm" to "orta ingilis",
    "eo" to "esperanto",
    "es" to "ispan",
    "es-419" to "Latın Amerikası ispancası",
    "es-ES" to "Kastiliya ispancası",
    "es-MX" to "Meksika ispancası",
    "et" to "eston",
    "eu" to "bask",
    "ewo" to "evondo",
    "fa" to "fars",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fula",
    "fi" to "fin",
    "fil" to "filippin",
    "fj" to "fici",
    "fo" to "farer",
    "fon" to "fon",
    "fr" to "fransız",
    "fr-CA" to "Kanada fransızcası",
    "fr-CH" to "İsveçrə fransızcası",
    "frc" to "Kacun fransızcası",
    "frm" to "orta fransız",
    "fro" to "qədim fransız",
    "frr" to "şimali fris",
    "fur" to "friul",
    "fy" to "qərbi friz",
    "ga" to "irland",
    "gaa" to "qa",
    "gag" to "qaqauz",
    "gan" to "qan",
    "gay" to "qayo",
    "gba" to "qabaya",
    "gd" to "Şotlandiya keltcəsi",
    "gez" to "qez",
    "gil" to "qilbert",
    "gl" to "qalisiya",
    "gmh" to "orta yüksək alman",
    "gn" to "quarani",
    "goh" to "qədim alman",
    "gon" to "qondi",
    "gor" to "qorontalo",
    "got" to "qotika",
    "grb" to "qrebo",
    "grc" to "qədim yunan",
    "gsw" to "İsveçrə almancası",
    "gu" to "qucarat",
    "guz" to "qusi",
    "gv" to "manks",
    "gwi" to "qviçin",
    "ha" to "hausa",
    "hai" to "hayda",
    "hak" to "hakka",
    "haw" to "havay",
    "hax" to "cənubi haida",
    "he" to "ivrit",
    "hi" to "hind",
    "hi-Latn" to "Hindi (latın)",
    "hi-Latn-alt-variant" to "Hindi (latın)",
    "hil" to "hiliqaynon",
    "hit" to "hittit",
    "hmn" to "monq",
    "ho" to "hiri motu",
    "hr" to "xorvat",
    "hsb" to "yuxarı sorb",
    "hsn" to "syan",
    "ht" to "haiti kreol",
    "hu" to "macar",
    "hup" to "hupa",
    "hur" to "Halkomelem",
    "hy" to "erməni",
    "hz" to "herero",
    "ia" to "interlinqua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indoneziya",
    "ie" to "interlinqve",
    "ig" to "iqbo",
    "ii" to "siçuan yi",
    "ik" to "inupiaq",
    "ikt" to "qərbi Kanada inuktitutu",
    "ilo" to "iloko",
    "inh" to "inquş",
    "io" to "ido",
    "is" to "island",
    "it" to "italyan",
    "iu" to "inuktitut",
    "ja" to "yapon",
    "jbo" to "loğban",
    "jgo" to "nqomba",
    "jmc" to "maçam",
    "jpr" to "ivrit-fars",
    "jrb" to "ivrit-ərəb",
    "jv" to "yava",
    "ka" to "gürcü",
    "kaa" to "qaraqalpaq",
    "kab" to "kabile",
    "kac" to "kaçin",
    "kaj" to "ju",
    "kam" to "kamba",
    "kaw" to "kavi",
    "kbd" to "kabarda-çərkəz",
    "kcg" to "tiyap",
    "kde" to "makond",
    "kea" to "kabuverdian",
    "kfo" to "koro",
    "kg" to "konqo",
    "kgp" to "kaiqanq",
    "kha" to "xazi",
    "kho" to "xotan",
    "khq" to "koyra çiini",
    "ki" to "kikuyu",
    "kj" to "kuanyama",
    "kk" to "qazax",
    "kkj" to "kako",
    "kl" to "kalaallisut",
    "kln" to "kalencin",
    "km" to "kxmer",
    "kmb" to "kimbundu",
    "kn" to "kannada",
    "ko" to "koreya",
    "koi" to "komi-permyak",
    "kok" to "konkani",
    "kos" to "kosreyan",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "qaraçay-balkar",
    "krl" to "karel",
    "kru" to "kurux",
    "ks" to "kəşmir",
    "ksb" to "şambala",
    "ksf" to "bafia",
    "ksh" to "köln",
    "ku" to "kürd",
    "kum" to "kumık",
    "kut" to "kutenay",
    "kv" to "komi",
    "kw" to "korn",
    "kwk" to "Kvakvala",
    "kxv" to "kuvi",
    "ky" to "qırğız",
    "la" to "latın",
    "lad" to "sefard",
    "lag" to "langi",
    "lah" to "qərbi pəncab",
    "lam" to "lamba",
    "lb" to "lüksemburq",
    "lez" to "ləzgi",
    "lg" to "qanda",
    "li" to "limburq",
    "lij" to "liquriya dili",
    "lil" to "Liluet",
    "lkt" to "lakota",
    "lmo" to "lombard dili",
    "ln" to "linqala",
    "lo" to "laos",
    "lol" to "monqo",
    "lou" to "Luiziana kreolu",
    "loz" to "lozi",
    "lrc" to "şimali luri",
    "lsm" to "saamia",
    "lt" to "litva",
    "lu" to "luba-katanqa",
    "lua" to "luba-lulua",
    "lui" to "luyseno",
    "lun" to "lunda",
    "lus" to "mizo",
    "luy" to "luyia",
    "lv" to "latış",
    "mad" to "maduriz",
    "mag" to "maqahi",
    "mai" to "maitili",
    "mak" to "makasar",
    "man" to "məndinqo",
    "mas" to "masay",
    "mdf" to "mokşa",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "morisien",
    "mg" to "malaqas",
    "mga" to "orta irland",
    "mgh" to "maxuva-meetto",
    "mgo" to "meta’",
    "mh" to "marşal",
    "mi" to "māori",
    "mic" to "mikmak",
    "min" to "minanqkaban",
    "mk" to "makedon",
    "ml" to "malayalam",
    "mn" to "monqol",
    "mnc" to "mançu",
    "mni" to "manipüri",
    "moe" to "İnnu-aimun",
    "moh" to "mohavk",
    "mos" to "mosi",
    "mr" to "marathi",
    "ms" to "malay",
    "mt" to "malta",
    "mua" to "mundanq",
    "mul" to "çoxsaylı dillər",
    "mus" to "krik",
    "mwl" to "mirand",
    "mwr" to "maruari",
    "my" to "birman",
    "myv" to "erzya",
    "mzn" to "mazandaran",
    "na" to "nauru",
    "nan" to "Min Nan",
    "nap" to "neapolitan",
    "naq" to "nama",
    "nb" to "bokmal norveç",
    "nd" to "şimali ndebele",
    "nds" to "aşağı alman",
    "nds-NL" to "aşağı sakson",
    "ne" to "nepal",
    "new" to "nevari",
    "ng" to "ndonqa",
    "nia" to "nias",
    "niu" to "niyuan",
    "nl" to "holland",
    "nl-BE" to "flamand",
    "nmg" to "kvasio",
    "nn" to "nünorsk norveç",
    "nnh" to "ngiemboon",
    "no" to "norveç",
    "nog" to "noqay",
    "non" to "qədim nors",
    "nqo" to "nko",
    "nr" to "cənubi ndebele",
    "nso" to "şimal soto",
    "nus" to "nuer",
    "nv" to "navayo",
    "ny" to "nyanca",
    "nym" to "nyamvezi",
    "nyn" to "nyankol",
    "nyo" to "nyoro",
    "nzi" to "nzima",
    "oc" to "oksitan",
    "oj" to "ocibva",
    "ojb" to "şimal-qərbi ocibva",
    "ojc" to "Mərkəzi ocibva",
    "ojs" to "ocikri",
    "ojw" to "qərbi ocibva",
    "oka" to "okanaqan",
    "om" to "oromo",
    "or" to "odiya",
    "os" to "osetin",
    "osa" to "osage",
    "ota" to "osman",
    "pa" to "pəncab",
    "pag" to "panqasinan",
    "pal" to "pəhləvi",
    "pam" to "pampanqa",
    "pap" to "papyamento",
    "pau" to "palayan",
    "pcm" to "niger kreol",
    "peo" to "qədim fars",
    "phn" to "foyenik",
    "pi" to "pali",
    "pis" to "picin",
    "pl" to "polyak",
    "pon" to "ponpey",
    "pqm" to "malesit-passamakvodi",
    "prg" to "pruss",
    "pro" to "qədim provansal",
    "ps" to "puştu",
    "pt" to "portuqal",
    "pt-BR" to "Braziliya portuqalcası",
    "pt-PT" to "Portuqaliya portuqalcası",
    "qu" to "keçua",
    "quc" to "kiçe",
    "raj" to "racastani",
    "rap" to "rapanui",
    "rar" to "rarotonqan",
    "rhg" to "Rohinca",
    "rm" to "romanş",
    "rn" to "rundi",
    "ro" to "rumın",
    "ro-MD" to "moldav",
    "rof" to "rombo",
    "rom" to "roman",
    "ru" to "rus",
    "rup" to "aroman",
    "rw" to "kinyarvanda",
    "rwk" to "rua",
    "sa" to "sanskrit",
    "sad" to "sandave",
    "sah" to "saxa",
    "sam" to "samaritan",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santal",
    "sba" to "nqambay",
    "sbp" to "sanqu",
    "sc" to "sardin",
    "scn" to "siciliya",
    "sco" to "skots",
    "sd" to "sindhi",
    "sdh" to "cənubi kürd",
    "se" to "şimali sami",
    "seh" to "sena",
    "sel" to "selkup",
    "ses" to "koyraboro senni",
    "sg" to "sanqo",
    "sga" to "qədim irland",
    "sh" to "serb-xorvat",
    "shi" to "taçelit",
    "shn" to "şan",
    "si" to "sinhala",
    "sid" to "sidamo",
    "sk" to "slovak",
    "sl" to "sloven",
    "slh" to "cənubi luşusid",
    "sm" to "samoa",
    "sma" to "cənubi sami",
    "smj" to "lule sami",
    "smn" to "inari sami",
    "sms" to "skolt sami",
    "sn" to "şona",
    "snk" to "soninke",
    "so" to "somali",
    "sog" to "soqdiyen",
    "sq" to "alban",
    "sr" to "serb",
    "srn" to "sranan tonqo",
    "srr" to "serer",
    "ss" to "svati",
    "ssy" to "saho",
    "st" to "sesoto",
    "str" to "streyts saliş",
    "su" to "sundan",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumeryan",
    "sv" to "isveç",
    "sw" to "suahili",
    "sw-CD" to "Konqo suahilicəsi",
    "swb" to "komor",
    "syr" to "suriya",
    "szl" to "silez dili",
    "ta" to "tamil",
    "tce" to "cənubi tuçon",
    "te" to "teluqu",
    "tem" to "timne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetum",
    "tg" to "tacik",
    "tgx" to "taq",
    "th" to "tay",
    "tht" to "taltan",
    "ti" to "tiqrin",
    "tig" to "tiqre",
    "tiv" to "tiv",
    "tk" to "türkmən",
    "tkl" to "tokelay",
    "tl" to "taqaloq",
    "tlh" to "klinqon",
    "tli" to "tlinqit",
    "tmh" to "tamaşek",
    "tn" to "svana",
    "to" to "tonqa",
    "tog" to "nyasa tonqa",
    "tok" to "tokipona",
    "tpi" to "tok pisin",
    "tr" to "türk",
    "trv" to "taroko",
    "ts" to "sonqa",
    "tsi" to "simşyan",
    "tt" to "tatar",
    "ttm" to "şimali tuçon",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "tvi",
    "twq" to "tasavaq",
    "ty" to "taxiti",
    "tyv" to "tuvinyan",
    "tzm" to "Mərkəzi Atlas tamazicəsi",
    "udm" to "udmurt",
    "ug" to "uyğur",
    "uga" to "uqarit",
    "uk" to "ukrayna",
    "umb" to "umbundu",
    "und" to "naməlum dil",
    "ur" to "urdu",
    "uz" to "özbək",
    "ve" to "venda",
    "vec" to "venet dili",
    "vi" to "vyetnam",
    "vmw" to "makua dili",
    "vo" to "volapük",
    "vot" to "votik",
    "vun" to "vunyo",
    "wa" to "valun",
    "wae" to "valles",
    "wal" to "valamo",
    "war" to "varay",
    "was" to "vaşo",
    "wbp" to "valpiri",
    "wo" to "volof",
    "wuu" to "vu",
    "xal" to "kalmık",
    "xh" to "xosa",
    "xnr" to "kanqri",
    "xog" to "soqa",
    "yao" to "yao",
    "yap" to "yapiz",
    "yav" to "yanqben",
    "ybb" to "yemba",
    "yi" to "idiş",
    "yo" to "yoruba",
    "yrl" to "nyenqatu",
    "yue" to "kanton",
    "yue-alt-menu" to "Çin, kanton",
    "za" to "çjuan",
    "zap" to "zapotek",
    "zbl" to "blisimbols",
    "zen" to "zenaqa",
    "zgh" to "tamazi",
    "zh" to "çin",
    "zh-alt-menu" to "Çin, mandarin",
    "zh-Hans" to "sadələşmiş çin",
    "zh-Hans-alt-long" to "sadələşmiş mandarin çincəsi",
    "zh-Hant" to "ənənəvi çin",
    "zh-Hant-alt-long" to "ənənəvi mandarin çincəsi",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "dil məzmunu yoxdur",
    "zza" to "zaza",
  ) }

  val ba: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ba" to "башҡорт теле",
  ) }

  val bal: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bal" to "بلۆچی",
    "zh" to "چینی",
    "zh-alt-menu" to "چینی",
    "zh-Hans" to "ساده کرتگێن چینی",
    "zh-Hans-alt-long" to "ساده کرتگێن چینی",
  ) }

  val bal_Arab: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bal" to "بلۆچی",
    "zh" to "چینی",
    "zh-alt-menu" to "چینی",
    "zh-Hans" to "ساده کرتگێن چینی",
    "zh-Hans-alt-long" to "ساده کرتگێن چینی",
  ) }

  val bal_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Apar",
    "ab" to "Abkházi",
    "af" to "Aprikái",
    "agq" to "Agem",
    "ak" to "Akan",
    "am" to "Amhari",
    "an" to "Aragóni",
    "ann" to "Obóló",
    "apc" to "Latwiái Arabi",
    "ar" to "Arabi",
    "ar-001" to "Arabi (Donyá)",
    "arn" to "Mapuche",
    "as" to "Asámi",
    "asa" to "Asu",
    "ast" to "Asturiái",
    "az" to "Ázerbáijáni",
    "az-alt-short" to "Ázerbáijáni",
    "ba" to "Bashkar",
    "bal" to "Balóchi",
    "bal-Latn" to "Balóchi (Látin)",
    "bas" to "Basá",
    "be" to "Bélárusi",
    "bem" to "Bembá",
    "bew" to "Betawi",
    "bez" to "Bená",
    "bg" to "Bolgáriái",
    "bgc" to "Haryánui",
    "bgn" to "Balóchi (Róbarkati)",
    "bho" to "Bójpuri",
    "blo" to "Ani",
    "blt" to "Tái Dam",
    "bm" to "Bambará",
    "bn" to "Bangáli",
    "bo" to "Tebbati",
    "br" to "Brétón",
    "brx" to "Bodó",
    "bs" to "Busniái",
    "bss" to "Akuse",
    "byn" to "Blin",
    "ca" to "Katálan",
    "cad" to "Kaddó-kad",
    "cch" to "Atsam",
    "ccp" to "Chakmá",
    "ce" to "Chechen",
    "ceb" to "Chebuánó",
    "cgg" to "Chigá",
    "cho" to "Choktaw",
    "chr" to "Cheruki",
    "cic" to "Chekkásaw",
    "ckb" to "Myáni Kordi",
    "ckb-alt-menu" to "Myáni Kordi- ckb",
    "ckb-alt-variant" to "Myáni Kordi-men",
    "co" to "Korsiki",
    "cs" to "Chek",
    "csw" to "Swampi Kri",
    "cu" to "Charch Sláwi",
    "cv" to "Chuwash",
    "cy" to "Wéli",
    "da" to "Denmárki",
    "dav" to "Táitá",
    "de" to "Jarman",
    "dje" to "Zarmah",
    "doi" to "Dogri",
    "dsb" to "Láwar Sorbi",
    "dua" to "Duálá",
    "dv" to "Diwéhi",
    "dyo" to "Jólá-Póni",
    "dz" to "Dzongká",
    "ebu" to "Embó",
    "ee" to "Ewe",
    "el" to "Yunáni",
    "en" to "Engrézi",
    "en-CA" to "Engrézi (Kaynadhá)",
    "eo" to "Esperántu",
    "es" to "Espini",
    "es-419" to "Espini (Látini Amriká)",
    "es-MX" to "Espini (Meksikó)",
    "et" to "Estóniái",
    "eu" to "Bask",
    "ewo" to "Ewondó",
    "fa" to "Pársi",
    "fa-AF" to "Pársi (AF)",
    "ff" to "Pulá",
    "fi" to "Fenlándi",
    "fil" to "Pelpini",
    "fo" to "Paróese",
    "fr" to "Paránsi",
    "fr-CA" to "Paránsi (Kaynadhá)",
    "frc" to "Kájon Pránsi",
    "frr" to "Shemáli Prési",
    "fur" to "Priuli",
    "fy" to "Ferisi (Róbarkati)",
    "ga" to "Áeri",
    "gaa" to "Gaa",
    "gd" to "Eskáti Géli",
    "gez" to "Géz",
    "gl" to "Galéki",
    "gn" to "Guárián",
    "gsw" to "Swiz Jarman",
    "gu" to "Gojráti",
    "guz" to "Gusi",
    "gv" to "Manks",
    "ha" to "Hausá",
    "haw" to "Hawái",
    "he" to "Ebráni",
    "hi" to "Hendi",
    "hi-Latn" to "Hendi (Látin Engrézi (Látin) Engrézi (Látin, Amrikáay Tepákén Están) syáhag: Látini)",
    "hi-Latn-alt-variant" to "Hendi (Látin Engrézi (Látin) Engrézi (Látin, Amrikáay Tepákén Están) syáhag: Látini)",
    "hnj" to "Hmang Njuá",
    "hr" to "Króshiái",
    "hsb" to "Borzi Sorbiái",
    "hu" to "Hangári",
    "hy" to "Arminiái",
    "ia" to "Myánzobáni",
    "id" to "Endónési",
    "ie" to "Myánzobán",
    "ig" to "Igbó",
    "ii" to "Sichuái Yi",
    "io" to "Idó",
    "is" to "Islándi",
    "it" to "Itáliái",
    "iu" to "Inuktitut",
    "ja" to "Jápáni",
    "jbo" to "Lojban",
    "jgo" to "Ngombá",
    "jmc" to "Makami",
    "jv" to "Jáwáni",
    "ka" to "Járjiái",
    "kaa" to "Kara-Kalpak",
    "kab" to "Kabáile",
    "kaj" to "Jju",
    "kam" to "Kambá",
    "kcg" to "Tyáp",
    "kde" to "Makonde",
    "kea" to "Kubuwerdiánó",
    "ken" to "Kinyang",
    "kgp" to "Káingáng",
    "khq" to "Koirá Chini",
    "ki" to "Kikuyu",
    "kk" to "Kázák",
    "kkj" to "Kákó",
    "kl" to "Kalállisut",
    "kln" to "Kalenjin",
    "km" to "Khmér",
    "kn" to "Kannadá",
    "ko" to "Kuriái",
    "kok" to "Konkani",
    "kpe" to "Kpelle",
    "ks" to "Kashmiri",
    "ksb" to "Shambalá",
    "ksf" to "Bapiá",
    "ksh" to "Kologni",
    "ku" to "Kordi",
    "kw" to "Kornesh",
    "kxv" to "Kuwi",
    "ky" to "Kirgez",
    "la" to "Látini",
    "lag" to "Langi",
    "lb" to "Logzemborgi",
    "lg" to "Gandá",
    "lij" to "Liguri",
    "lkt" to "Lakótá",
    "lld" to "Ladin",
    "lmo" to "Lombard",
    "ln" to "Lingálá",
    "lo" to "Láó",
    "lou" to "Luisiáná Krióle",
    "lrc" to "Shemáli Lori",
    "lt" to "Litwániái",
    "ltg" to "Latgali",
    "lu" to "Lubá-Katangá",
    "luo" to "Luó",
    "luy" to "Luiá",
    "lv" to "Latwiái",
    "mai" to "Maitéli",
    "mas" to "Masai",
    "mdf" to "Moksha",
    "mer" to "Méru",
    "mfe" to "Murisén",
    "mg" to "Malagase",
    "mgh" to "Makuá-Mitó",
    "mgo" to "Métá",
    "mhn" to "Móchénó",
    "mi" to "Muri",
    "mic" to "Mikmaw",
    "mk" to "Makduni",
    "ml" to "Malyálam",
    "mn" to "Mangóli",
    "mni" to "Manipuri",
    "moh" to "Mohawk",
    "mr" to "Maráthi",
    "ms" to "Malai",
    "mt" to "Maltiz",
    "mua" to "Mundang",
    "mul" to "Báz zobán",
    "mus" to "Muskógi",
    "my" to "Barmái",
    "myv" to "Erziá",
    "mzn" to "Mázendaráni",
    "naq" to "Nama",
    "nb" to "Nárwiji Bokmál",
    "nd" to "Shemáli Nedébéle",
    "nds" to "Láw Jarman",
    "nds-NL" to "Láw Jarman (NL)",
    "ne" to "Népáli",
    "nl" to "Dacch",
    "nl-BE" to "Dacch (Béljiam)",
    "nmg" to "Kwásiu",
    "nn" to "Nárwiji Nókén",
    "nnh" to "Ngembun",
    "no" to "Nárwiji",
    "nqo" to "Nko",
    "nr" to "Zerbári Nedebéli",
    "nso" to "Shemáli Sotó",
    "nus" to "Nuér",
    "nv" to "Nawájó",
    "ny" to "Nyanjá",
    "nyn" to "Nyankóle",
    "oc" to "Ositi",
    "om" to "Oromó",
    "or" to "Odi",
    "os" to "Oséti",
    "osa" to "Oságá",
    "pa" to "Panjábi",
    "pap" to "Pápiámentó",
    "pcm" to "Náijiri Pidgin",
    "pis" to "Pijen",
    "pl" to "Pólayndi",
    "prg" to "Prushiái",
    "ps" to "Pashtó",
    "pt" to "Portagáli",
    "qu" to "Kwichu",
    "quc" to "Kichi",
    "raj" to "Rájestáni",
    "rhg" to "Róhengiá",
    "rif" to "Ripi",
    "rm" to "Rumansh",
    "rn" to "Róndi",
    "ro" to "Rumániái",
    "ro-MD" to "Rumániái (MD)",
    "rof" to "Rombó",
    "ru" to "Rusi",
    "rw" to "Kenyarwandá",
    "rwk" to "Rwa",
    "sa" to "Sanskeret",
    "sah" to "Yakut",
    "saq" to "Samboró",
    "sat" to "Santali",
    "sbp" to "Sangu",
    "sc" to "Sardéniái",
    "scn" to "Sesiliái",
    "sd" to "Sendi",
    "sdh" to "Zerbári Kordi",
    "se" to "Shemáli Sámi",
    "seh" to "Sená",
    "ses" to "Koryáburó Senni",
    "sg" to "Sangó",
    "shi" to "Tachelhit",
    "shn" to "Shan",
    "si" to "Senhálá",
    "sid" to "Sidámó",
    "sk" to "Solwák",
    "skr" to "Saráeki",
    "sl" to "Solwiniái",
    "sma" to "Zerbári Sámi",
    "smj" to "Lule Sámi",
    "smn" to "Inári Sámi",
    "sms" to "Eskált Sámi",
    "sn" to "Shoná",
    "so" to "Sómáli",
    "sq" to "Albániái",
    "sr" to "Sarbiái",
    "ss" to "Swáti",
    "ssy" to "Sahó",
    "st" to "Zerbári Sutó",
    "su" to "Sudáni",
    "sv" to "Swidi",
    "sw" to "Swáhéli",
    "sw-CD" to "Swáhéli (CD)",
    "syr" to "Siriek",
    "szl" to "Selisi",
    "ta" to "Támel",
    "te" to "Telgó",
    "teo" to "Tésó",
    "tg" to "Tájek",
    "th" to "Tái",
    "ti" to "Tigriniá",
    "tig" to "Tigré",
    "tk" to "Trkm",
    "tn" to "Tuswáná",
    "to" to "Tongan",
    "tok" to "Tóki Póná",
    "tpi" to "Tok Pisin",
    "tr" to "Tork",
    "trv" to "Torokó",
    "trw" to "Torwáli",
    "ts" to "Tesungá",
    "tt" to "Tátar",
    "twq" to "Tasawak",
    "tyv" to "Tuwini",
    "tzm" to "Tzm",
    "ug" to "Yughor",
    "uk" to "Yukrini",
    "und" to "Nagisshetagén zobán",
    "ur" to "Urdu",
    "uz" to "Ozbek",
    "vai" to "Wái",
    "ve" to "Wendá",
    "vec" to "Weneti",
    "vi" to "Wietnámi",
    "vmw" to "Makuwá",
    "vo" to "Wolápuk",
    "vun" to "Wunjó",
    "wa" to "Wallun",
    "wae" to "Welser",
    "wal" to "Wolettá",
    "wbp" to "Warlpiri",
    "wo" to "Wolop",
    "xh" to "Khushá",
    "xnr" to "Kangri",
    "xog" to "Sugá",
    "yav" to "Yangben",
    "yi" to "Yeddi",
    "yo" to "Yorobá",
    "yrl" to "Ningátu",
    "yue" to "Kantóni",
    "yue-alt-menu" to "Kantóni-yue",
    "za" to "Zhuáng",
    "zgh" to "Gisshetqagén Moróki Tamázi",
    "zh" to "Chini",
    "zh-alt-menu" to "Chini",
    "zu" to "Zulu",
    "zxx" to "Hecch zobán",
  ) }

  val bas: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Hɔp u akan",
    "am" to "Hɔp u amhārìk",
    "ar" to "Hɔp u arâb",
    "bas" to "Ɓàsàa",
    "be" to "Hɔp u bièlòrûs",
    "bg" to "Hɔp u bûlgâr",
    "bn" to "Hɔp u bɛŋgàli",
    "cs" to "Hɔp u cɛ̂k",
    "de" to "Hɔp u jamân",
    "el" to "Hɔp u gri ᷇kyà",
    "en" to "Hɔp u ŋgisì",
    "es" to "Hɔp u panyā",
    "fa" to "Hɔp u pɛrsìà",
    "fr" to "Hɔp u pulàsi",
    "ha" to "Hɔp u ɓausa",
    "hi" to "Hɔp u hindì",
    "hu" to "Hɔp u hɔŋgrìi",
    "id" to "Hɔp u indònesìà",
    "ig" to "Hɔp u iɓò",
    "it" to "Hɔp u italìà",
    "ja" to "Hɔp u yapàn",
    "jv" to "Hɔp u yavà",
    "km" to "Hɔp u kmɛ̂r",
    "ko" to "Hɔp u kɔrēà",
    "ms" to "Hɔp u makɛ᷆",
    "my" to "Hɔp u birmàn",
    "ne" to "Hɔp u nepa᷆l",
    "nl" to "Hɔp u nlɛ̀ndi",
    "pa" to "Hɔp u pɛnjàbi",
    "pl" to "Hɔp u pɔlɔ̄nà",
    "pt" to "Hɔp u pɔtɔ̄kì",
    "ro" to "Hɔp u rùmanìà",
    "ru" to "Hɔp u ruslànd",
    "rw" to "Hɔp u ruāndà",
    "so" to "Hɔp u somàlî",
    "sv" to "Hɔp u suɛ᷆d",
    "ta" to "Hɔp u tamu᷆l",
    "th" to "Hɔp u tây",
    "tr" to "Hɔp u tûrk",
    "uk" to "Hɔp u ukrǎnìà",
    "ur" to "Hɔp u urdù",
    "vi" to "Hɔp u vyɛ̄dnàm",
    "yo" to "Hɔp u yorūbà",
    "zh" to "Hɔp u kinà",
    "zh-alt-menu" to "Hɔp u kinà",
    "zu" to "Hɔp u zulù",
  ) }

  val be: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "афарская",
    "ab" to "абхазская",
    "ace" to "ачэх",
    "ada" to "адангмэ",
    "ady" to "адыгейская",
    "af" to "афрыкаанс",
    "agq" to "агем",
    "ain" to "айнская",
    "ak" to "акан",
    "akk" to "акадская",
    "ale" to "алеуцкая",
    "alt" to "паўднёваалтайская",
    "am" to "амхарская",
    "an" to "арагонская",
    "ang" to "стараанглійская",
    "ann" to "абола",
    "anp" to "ангіка",
    "ar" to "арабская",
    "ar-001" to "сучасная стандартная арабская",
    "arc" to "арамейская",
    "arn" to "мапудунгун",
    "arp" to "арапаха",
    "ars" to "недждыйская арабская",
    "as" to "асамская",
    "asa" to "асу",
    "ast" to "астурыйская",
    "atj" to "атыкамек",
    "av" to "аварская",
    "awa" to "авадхі",
    "ay" to "аймара",
    "az" to "азербайджанская",
    "az-alt-short" to "азербайджанская",
    "ba" to "башкірская",
    "ban" to "балійская",
    "bas" to "басаа",
    "be" to "беларуская",
    "bem" to "бемба",
    "bez" to "бена",
    "bg" to "балгарская",
    "bgc" to "харыанві",
    "bgn" to "заходняя белуджская",
    "bho" to "бхаджпуры",
    "bi" to "біслама",
    "bin" to "эда",
    "bla" to "блэкфут",
    "blo" to "аніі",
    "bm" to "бамбара",
    "bn" to "бенгальская",
    "bo" to "тыбецкая",
    "br" to "брэтонская",
    "brx" to "бода",
    "bs" to "баснійская",
    "bua" to "бурацкая",
    "bug" to "бугіс",
    "byn" to "білен",
    "ca" to "каталанская",
    "cay" to "каюга",
    "ccp" to "чакма",
    "ce" to "чачэнская",
    "ceb" to "себуана",
    "cgg" to "чыга",
    "ch" to "чамора",
    "chb" to "чыбча",
    "chk" to "чуук",
    "chm" to "мары",
    "cho" to "чокта",
    "chp" to "чыпеваян",
    "chr" to "чэрокі",
    "chy" to "шэйен",
    "ckb" to "цэнтральнакурдская",
    "ckb-alt-menu" to "курдская, сарані",
    "ckb-alt-variant" to "сарані",
    "clc" to "чылькатын",
    "co" to "карсіканская",
    "cop" to "копцкая",
    "crg" to "мічыф",
    "crj" to "паўднёва-ўсходняя кры",
    "crk" to "раўнінны кры",
    "crl" to "паўночна-ўсходняя кры",
    "crm" to "муская кры",
    "crr" to "каралінская алганкійская",
    "crs" to "сэсэльва",
    "cs" to "чэшская",
    "csw" to "балотная кры",
    "cu" to "царкоўнаславянская",
    "cv" to "чувашская",
    "cy" to "валійская",
    "da" to "дацкая",
    "dak" to "дакота",
    "dar" to "даргінская",
    "dav" to "таіта",
    "de" to "нямецкая",
    "de-AT" to "аўстрыйская нямецкая",
    "de-CH" to "швейцарская літаратурная нямецкая",
    "dgr" to "догрыб",
    "dje" to "зарма",
    "doi" to "догры",
    "dsb" to "ніжнялужыцкая",
    "dua" to "дуала",
    "dv" to "мальдыўская",
    "dyo" to "джола-фоньі",
    "dz" to "дзонг-кэ",
    "dzg" to "дазага",
    "ebu" to "эмбу",
    "ee" to "эве",
    "efi" to "эфік",
    "egy" to "старажытнаегіпецкая",
    "eka" to "экаджук",
    "el" to "грэчаская",
    "en" to "англійская",
    "en-AU" to "аўстралійская англійская",
    "en-CA" to "канадская англійская",
    "en-GB" to "брытанская англійская",
    "en-GB-alt-short" to "вялікабрытанская англійская",
    "en-US" to "амерыканская англійская",
    "en-US-alt-short" to "англійская (ЗША)",
    "eo" to "эсперанта",
    "es" to "іспанская",
    "es-419" to "лацінаамерыканская іспанская",
    "es-ES" to "еўрапейская іспанская",
    "es-MX" to "мексіканская іспанская",
    "et" to "эстонская",
    "eu" to "баскская",
    "ewo" to "эвонда",
    "fa" to "фарсі",
    "fa-AF" to "дары",
    "ff" to "фула",
    "fi" to "фінская",
    "fil" to "філіпінская",
    "fj" to "фіджыйская",
    "fo" to "фарэрская",
    "fon" to "фон",
    "fr" to "французская",
    "fr-CA" to "канадская французская",
    "fr-CH" to "швейцарская французская",
    "frc" to "каджунская французская",
    "fro" to "старафранцузская",
    "frr" to "паўночнафрызская",
    "fur" to "фрыульская",
    "fy" to "заходняя фрызская",
    "ga" to "ірландская",
    "gaa" to "га",
    "gag" to "гагаузская",
    "gd" to "шатландская гэльская",
    "gez" to "геэз",
    "gil" to "кірыбаці",
    "gl" to "галісійская",
    "gn" to "гуарані",
    "gor" to "гарантала",
    "grc" to "старажытнагрэчаская",
    "gsw" to "швейцарская нямецкая",
    "gu" to "гуджараці",
    "guz" to "гусіі",
    "gv" to "мэнская",
    "gwi" to "гуіч’ін",
    "ha" to "хауса",
    "hai" to "хайда",
    "haw" to "гавайская",
    "hax" to "паўднёвая хайда",
    "he" to "іўрыт",
    "hi" to "хіндзі",
    "hi-Latn-alt-variant" to "хінгліш",
    "hil" to "хілігайнон",
    "hmn" to "хмонг",
    "hr" to "харвацкая",
    "hsb" to "верхнялужыцкая",
    "ht" to "гаіцянская крэольская",
    "hu" to "венгерская",
    "hup" to "хупа",
    "hur" to "халкамелем",
    "hy" to "армянская",
    "hz" to "герэра",
    "ia" to "інтэрлінгва",
    "iba" to "ібан",
    "ibb" to "ібібія",
    "id" to "інданезійская",
    "ie" to "інтэрлінгвэ",
    "ig" to "ігба",
    "ii" to "сычуаньская йі",
    "ikt" to "заходнеканадская інуктытут",
    "ilo" to "ілакана",
    "inh" to "інгушская",
    "io" to "іда",
    "is" to "ісландская",
    "it" to "італьянская",
    "iu" to "інуктытут",
    "ja" to "японская",
    "jbo" to "ложбан",
    "jgo" to "нгомба",
    "jmc" to "мачамбэ",
    "jv" to "яванская",
    "ka" to "грузінская",
    "kab" to "кабільская",
    "kac" to "качынская",
    "kaj" to "дджу",
    "kam" to "камба",
    "kbd" to "кабардзінская",
    "kcg" to "т’яп",
    "kde" to "макондэ",
    "kea" to "кабувердыяну",
    "kfo" to "кора",
    "kgp" to "каінганг",
    "kha" to "кхасі",
    "khq" to "койра чыіні",
    "ki" to "кікуйю",
    "kj" to "куаньяма",
    "kk" to "казахская",
    "kkj" to "како",
    "kl" to "грэнландская",
    "kln" to "календжын",
    "km" to "кхмерская",
    "kmb" to "кімбунду",
    "kn" to "канада",
    "ko" to "карэйская",
    "koi" to "комі-пярмяцкая",
    "kok" to "канкані",
    "kpe" to "кпеле",
    "kr" to "кануры",
    "krc" to "карачай-балкарская",
    "krl" to "карэльская",
    "kru" to "курух",
    "ks" to "кашмірская",
    "ksb" to "шамбала",
    "ksf" to "бафія",
    "ksh" to "кёльнская",
    "ku" to "курдская",
    "kum" to "кумыцкая",
    "kv" to "комі",
    "kw" to "корнская",
    "kwk" to "квакіутль",
    "kxv" to "куві",
    "ky" to "кіргізская",
    "la" to "лацінская",
    "lad" to "ладына",
    "lag" to "лангі",
    "lb" to "люксембургская",
    "lez" to "лезгінская",
    "lg" to "ганда",
    "li" to "лімбургская",
    "lij" to "лігурская",
    "lil" to "лілуэт",
    "lkt" to "лакота",
    "lmo" to "ламбардская",
    "ln" to "лінгала",
    "lo" to "лаоская",
    "lol" to "монга",
    "lou" to "луізіянская крэольская",
    "loz" to "лозі",
    "lrc" to "паўночная луры",
    "lsm" to "саамія",
    "lt" to "літоўская",
    "lu" to "луба-катанга",
    "lua" to "луба-касаі",
    "lun" to "лунда",
    "luo" to "луо",
    "lus" to "мізо",
    "luy" to "луйя",
    "lv" to "латышская",
    "mad" to "мадурская",
    "mag" to "магахі",
    "mai" to "майтхілі",
    "mak" to "макасар",
    "man" to "мандынг",
    "mas" to "маасай",
    "mdf" to "макшанская",
    "men" to "мендэ",
    "mer" to "меру",
    "mfe" to "марысьен",
    "mg" to "малагасійская",
    "mgh" to "макуўа-меета",
    "mgo" to "мета",
    "mh" to "маршальская",
    "mi" to "маары",
    "mic" to "мікмак",
    "min" to "мінангкабау",
    "mk" to "македонская",
    "ml" to "малаялам",
    "mn" to "мангольская",
    "mni" to "мейтэй",
    "moe" to "іну-аймун",
    "moh" to "мохак",
    "mos" to "мосі",
    "mr" to "маратхі",
    "ms" to "малайская",
    "mt" to "мальтыйская",
    "mua" to "мунданг",
    "mul" to "некалькі моў",
    "mus" to "мускогі",
    "mwl" to "мірандыйская",
    "my" to "бірманская",
    "myv" to "эрзянская",
    "mzn" to "мазандэранская",
    "na" to "науру",
    "nap" to "неапалітанская",
    "naq" to "нама",
    "nb" to "нарвежская (букмол)",
    "nd" to "паўночная ндэбеле",
    "nds" to "ніжненямецкая",
    "nds-NL" to "ніжнесаксонская",
    "ne" to "непальская",
    "new" to "неўары",
    "ng" to "ндонга",
    "nia" to "ніас",
    "niu" to "ніўэ",
    "nl" to "нідэрландская",
    "nl-BE" to "фламандская",
    "nmg" to "нгумба",
    "nn" to "нарвежская (нюношк)",
    "nnh" to "нг’ембон",
    "no" to "нарвежская",
    "nog" to "нагайская",
    "non" to "старанарвежская",
    "nqo" to "нко",
    "nr" to "паўднёвая ндэбеле",
    "nso" to "паўночная сота",
    "nus" to "нуэр",
    "nv" to "наваха",
    "ny" to "ньянджа",
    "nyn" to "ньянколе",
    "oc" to "аксітанская",
    "oj" to "аджыбвэ",
    "ojb" to "паўночна-заходняя аджыбвэ",
    "ojc" to "цэнтральная аджыбвэ",
    "ojs" to "оджы-кры",
    "ojw" to "заходняя аджыбвэ",
    "oka" to "аканаган",
    "om" to "арома",
    "or" to "орыя",
    "os" to "асецінская",
    "pa" to "панджабі",
    "pag" to "пангасінан",
    "pam" to "пампанга",
    "pap" to "пап’яменту",
    "pau" to "палау",
    "pcm" to "нігерыйскі піджын",
    "peo" to "стараперсідская",
    "phn" to "фінікійская",
    "pis" to "саламонскі піджын",
    "pl" to "польская",
    "pqm" to "малесіт-пасамакуоды",
    "prg" to "пруская",
    "pro" to "стараправансальская",
    "ps" to "пушту",
    "pt" to "партугальская",
    "pt-BR" to "бразільская партугальская",
    "pt-PT" to "еўрапейская партугальская",
    "qu" to "кечуа",
    "quc" to "кічэ",
    "raj" to "раджастханская",
    "rap" to "рапануі",
    "rar" to "раратонг",
    "rhg" to "рахінджа",
    "rm" to "рэтараманская",
    "rn" to "рундзі",
    "ro" to "румынская",
    "ro-MD" to "малдаўская",
    "rof" to "ромба",
    "ru" to "руская",
    "rup" to "арумунская",
    "rw" to "руанда",
    "rwk" to "руа",
    "sa" to "санскрыт",
    "sad" to "сандаўэ",
    "sah" to "якуцкая",
    "saq" to "самбуру",
    "sat" to "санталі",
    "sba" to "нгамбай",
    "sbp" to "сангу",
    "sc" to "сардзінская",
    "scn" to "сіцылійская",
    "sco" to "шатландская",
    "sd" to "сіндхі",
    "sdh" to "паўднёвакурдская",
    "se" to "паўночнасаамская",
    "seh" to "сена",
    "ses" to "кайрабора сэні",
    "sg" to "санга",
    "sga" to "стараірландская",
    "sh" to "сербскахарвацкая",
    "shi" to "ташэльхіт",
    "shn" to "шан",
    "si" to "сінгальская",
    "sk" to "славацкая",
    "sl" to "славенская",
    "slh" to "паўднёвая лушуцыд",
    "sm" to "самоа",
    "sma" to "паўднёвасаамская",
    "smj" to "луле-саамская",
    "smn" to "інары-саамская",
    "sms" to "колта-саамская",
    "sn" to "шона",
    "snk" to "санінке",
    "so" to "самалі",
    "sq" to "албанская",
    "sr" to "сербская",
    "srn" to "сранан-тонга",
    "ss" to "суаці",
    "ssy" to "саха",
    "st" to "сесута",
    "str" to "стрэйтс саліш",
    "su" to "сунда",
    "suk" to "сукума",
    "sux" to "шумерская",
    "sv" to "шведская",
    "sw" to "суахілі",
    "sw-CD" to "кангалезская суахілі",
    "swb" to "каморская",
    "syr" to "сірыйская",
    "szl" to "сілезская",
    "ta" to "тамільская",
    "tce" to "паўднёвая тутчонэ",
    "te" to "тэлугу",
    "tem" to "тэмнэ",
    "teo" to "тэсо",
    "tet" to "тэтум",
    "tg" to "таджыкская",
    "tgx" to "тагіш",
    "th" to "тайская",
    "tht" to "тальтан",
    "ti" to "тыгрынья",
    "tig" to "тыгрэ",
    "tk" to "туркменская",
    "tlh" to "клінган",
    "tli" to "тлінгіт",
    "tn" to "тсвана",
    "to" to "танганская",
    "tok" to "такіпона",
    "tpi" to "ток-пісін",
    "tr" to "турэцкая",
    "trv" to "тарока",
    "ts" to "тсонга",
    "tt" to "татарская",
    "ttm" to "паўночная тутчонэ",
    "tum" to "тумбука",
    "tvl" to "тувалу",
    "twq" to "тасаўак",
    "ty" to "таіці",
    "tyv" to "тувінская",
    "tzm" to "сярэднеатлаская тамазігхт",
    "udm" to "удмурцкая",
    "ug" to "уйгурская",
    "uk" to "украінская",
    "umb" to "умбунду",
    "und" to "невядомая мова",
    "ur" to "урду",
    "uz" to "узбекская",
    "vai" to "ваі",
    "ve" to "венда",
    "vec" to "венецыянская",
    "vi" to "в’етнамская",
    "vmw" to "макуа",
    "vo" to "валапюк",
    "vun" to "вунджо",
    "wa" to "валонская",
    "wae" to "вальшская",
    "wal" to "волайта",
    "war" to "варай",
    "wbp" to "варлпіры",
    "wo" to "валоф",
    "wuu" to "ву",
    "xal" to "калмыцкая",
    "xh" to "коса",
    "xnr" to "кангры",
    "xog" to "сога",
    "yav" to "янгбэн",
    "ybb" to "йемба",
    "yi" to "ідыш",
    "yo" to "ёруба",
    "yrl" to "ньенгату",
    "yue" to "кантонскі дыялект кітайскай",
    "yue-alt-menu" to "кітайская, кантонскі дыялект",
    "za" to "чжуанская",
    "zap" to "сапатэк",
    "zgh" to "стандартная мараканская тамазіхт",
    "zh" to "кітайская",
    "zh-alt-menu" to "кітайская, паўночныя дыялекты",
    "zh-Hans" to "кітайская (спрошчаныя іерогліфы)",
    "zh-Hans-alt-long" to "паўночнакітайская (спрошчаныя іерогліфы)",
    "zh-Hant" to "кітайская (традыцыйныя іерогліфы)",
    "zh-Hant-alt-long" to "паўночнакітайская (традыцыйныя іерогліфы)",
    "zu" to "зулу",
    "zun" to "зуні",
    "zxx" to "няма моўнага матэрыялу",
    "zza" to "зазакі",
  ) }

  val be_tarask: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bem: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Ichi Akan",
    "am" to "Ichi Amhari",
    "ar" to "Ichi Arab",
    "be" to "Ichi Belarus",
    "bem" to "Ichibemba",
    "bg" to "Ichi Bulgariani",
    "bn" to "Ichi Bengali",
    "cs" to "Ichi Cheki",
    "de" to "Ichi Jemani",
    "el" to "Ichi Griki",
    "en" to "Ichi Sungu",
    "es" to "Ichi Spanishi",
    "fa" to "Ichi Pesia",
    "fr" to "Ichi Frenchi",
    "ha" to "Ichi Hausa",
    "hi" to "Ichi Hindu",
    "hu" to "Ichi Hangarian",
    "id" to "Ichi Indonesiani",
    "ig" to "Ichi Ibo",
    "it" to "Ichi Italiani",
    "ja" to "Ichi Japanisi",
    "jv" to "Ichi Javanisi",
    "km" to "Ichi Khmer",
    "ko" to "Ichi Koriani",
    "ms" to "Ichi Maleshani",
    "my" to "Ichi Burma",
    "ne" to "Ichi Nepali",
    "nl" to "Ichi Dachi",
    "pa" to "Ichi Punjabi",
    "pl" to "Ichi Polishi",
    "pt" to "Ichi Potogisi",
    "ro" to "Ichi Romaniani",
    "ru" to "Ichi Rusiani",
    "rw" to "Ichi Rwanda",
    "so" to "Ichi Somalia",
    "sv" to "Ichi Swideni",
    "ta" to "Ichi Tamil",
    "th" to "Ichi Thai",
    "tr" to "Ichi Takishi",
    "uk" to "Ichi Ukraniani",
    "ur" to "Ichi Urudu",
    "vi" to "Ichi Vietinamu",
    "yo" to "Ichi Yoruba",
    "zh" to "Ichi Chainisi",
    "zh-alt-menu" to "Ichi Chainisi",
    "zu" to "Ichi Zulu",
  ) }

  val bez: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Hiakan",
    "am" to "Hiamhari",
    "ar" to "Hiharabu",
    "be" to "Hibelarusi",
    "bez" to "Hibena",
    "bg" to "Hibulgaria",
    "bn" to "Hibangla",
    "cs" to "Hicheki",
    "de" to "Hijerumani",
    "el" to "Higiriki",
    "en" to "Hiingereza",
    "es" to "Hihispania",
    "fa" to "Hiajemi",
    "fr" to "Hifaransa",
    "ha" to "Hihausa",
    "hi" to "Hihindi",
    "hu" to "Hihungari",
    "id" to "Hiindonesia",
    "ig" to "Hiibo",
    "it" to "Hiitaliano",
    "ja" to "Hijapani",
    "jv" to "Hijava",
    "km" to "Hikambodia",
    "ko" to "Hikorea",
    "ms" to "Himalesia",
    "my" to "Hiburma",
    "ne" to "Hinepali",
    "nl" to "Hiholanzi",
    "pa" to "Hipunjabi",
    "pl" to "Hipolandi",
    "pt" to "Hileno",
    "ro" to "Hilomania",
    "ru" to "Hilusi",
    "rw" to "Hinyarwanda",
    "so" to "Hisomali",
    "sv" to "Hiswidi",
    "ta" to "Hitamil",
    "th" to "Hitailand",
    "tr" to "Hituluki",
    "uk" to "Hiukrania",
    "ur" to "Hiurdu",
    "vi" to "Hivietinamu",
    "yo" to "Hiyoruba",
    "zh" to "Hichina",
    "zh-alt-menu" to "Hichina",
    "zu" to "Hizulu",
  ) }

  val bg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "афарски",
    "ab" to "абхазки",
    "ace" to "ачешки",
    "ach" to "аколи",
    "ada" to "адангме",
    "ady" to "адигейски",
    "ae" to "авестски",
    "af" to "африканс",
    "afh" to "африхили",
    "agq" to "агем",
    "ain" to "айну",
    "ak" to "акан",
    "akk" to "акадски",
    "ale" to "алеутски",
    "alt" to "южноалтайски",
    "am" to "амхарски",
    "an" to "арагонски",
    "ang" to "староанглийски",
    "ann" to "оболо",
    "anp" to "ангика",
    "ar" to "арабски",
    "ar-001" to "съвременен стандартен арабски",
    "arc" to "арамейски",
    "arn" to "мапуче",
    "arp" to "арапахо",
    "ars" to "найди арабски",
    "arw" to "аравак",
    "as" to "асамски",
    "asa" to "асу",
    "ast" to "астурски",
    "atj" to "атикамеку",
    "av" to "аварски",
    "awa" to "авади",
    "ay" to "аймара",
    "az" to "азербайджански",
    "az-alt-short" to "азерски",
    "ba" to "башкирски",
    "bal" to "балучи",
    "ban" to "балийски",
    "bas" to "баса",
    "be" to "беларуски",
    "bej" to "бея",
    "bem" to "бемба",
    "bez" to "бена",
    "bg" to "български",
    "bgc" to "харианви",
    "bgn" to "западен балочи",
    "bho" to "боджпури",
    "bi" to "бислама",
    "bik" to "биколски",
    "bin" to "бини",
    "bla" to "сиксика",
    "blo" to "ании",
    "bm" to "бамбара",
    "bn" to "бенгалски",
    "bo" to "тибетски",
    "br" to "бретонски",
    "bra" to "брадж",
    "brx" to "бодо",
    "bs" to "босненски",
    "bua" to "бурятски",
    "bug" to "бугински",
    "byn" to "биленски",
    "ca" to "каталонски",
    "cad" to "каддо",
    "car" to "карибски",
    "cay" to "каюга",
    "cch" to "атсам",
    "ccp" to "чакма",
    "ce" to "чеченски",
    "ceb" to "себуански",
    "cgg" to "чига",
    "ch" to "чаморо",
    "chb" to "чибча",
    "chg" to "чагатай",
    "chk" to "чуук",
    "chm" to "марийски",
    "chn" to "жаргон чинуук",
    "cho" to "чокто",
    "chp" to "чипеуански",
    "chr" to "черокски",
    "chy" to "шайенски",
    "ckb" to "кюрдски (централен)",
    "ckb-alt-menu" to "кюрдски (централен)",
    "ckb-alt-variant" to "кюрдски (Сорани)",
    "clc" to "чилкотин",
    "co" to "корсикански",
    "cop" to "коптски",
    "cr" to "крии",
    "crg" to "мичиф",
    "crh" to "кримскотатарски",
    "crj" to "югоизточен крий",
    "crk" to "плейнс крий",
    "crl" to "североизточен крий",
    "crm" to "муус крее",
    "crr" to "каролински алгонкин",
    "crs" to "сеселва, креолски френски",
    "cs" to "чешки",
    "csb" to "кашубски",
    "csw" to "суампи крий",
    "cu" to "църковнославянски",
    "cv" to "чувашки",
    "cy" to "уелски",
    "da" to "датски",
    "dak" to "дакотски",
    "dar" to "даргински",
    "dav" to "таита",
    "de" to "немски",
    "del" to "делауер",
    "den" to "слейви",
    "dgr" to "догриб",
    "din" to "динка",
    "dje" to "зарма",
    "doi" to "догри",
    "dsb" to "долнолужишки",
    "dua" to "дуала",
    "dum" to "средновековен холандски",
    "dv" to "дивехи",
    "dyo" to "диола-фони",
    "dyu" to "диула",
    "dz" to "дзонгкха",
    "dzg" to "дазага",
    "ebu" to "ембу",
    "ee" to "еве",
    "efi" to "ефик",
    "egy" to "древноегипетски",
    "eka" to "екажук",
    "el" to "гръцки",
    "elx" to "еламитски",
    "en" to "английски",
    "en-AU" to "австралийски английски",
    "en-CA" to "канадски английски",
    "en-GB" to "британски английски",
    "en-GB-alt-short" to "английски (UK)",
    "en-US" to "американски английски",
    "en-US-alt-short" to "английски (US)",
    "enm" to "средновековен английски",
    "eo" to "есперанто",
    "es" to "испански",
    "et" to "естонски",
    "eu" to "баски",
    "ewo" to "евондо",
    "fa" to "персийски",
    "fa-AF" to "дари",
    "fan" to "фанг",
    "fat" to "фанти",
    "ff" to "фула",
    "fi" to "фински",
    "fil" to "филипински",
    "fj" to "фиджийски",
    "fo" to "фарьорски",
    "fon" to "фон",
    "fr" to "френски",
    "frc" to "каджунски френски",
    "frm" to "средновековен френски",
    "fro" to "старофренски",
    "frr" to "северен фризийски",
    "frs" to "източнофризийски",
    "fur" to "фриулски",
    "fy" to "западнофризийски",
    "ga" to "ирландски",
    "gaa" to "га",
    "gag" to "гагаузки",
    "gay" to "гайо",
    "gba" to "гбая",
    "gd" to "шотландски келтски",
    "gez" to "гииз",
    "gil" to "гилбертски",
    "gl" to "галисийски",
    "gmh" to "средновисоконемски",
    "gn" to "гуарани",
    "goh" to "старовисоконемски",
    "gon" to "гонди",
    "gor" to "горонтало",
    "got" to "готически",
    "grb" to "гребо",
    "grc" to "древногръцки",
    "gsw" to "швейцарски немски",
    "gu" to "гуджарати",
    "guz" to "гусии",
    "gv" to "манкски",
    "gwi" to "гвичин",
    "ha" to "хауса",
    "hai" to "хайда",
    "haw" to "хавайски",
    "hax" to "южен хайда",
    "he" to "иврит",
    "hi" to "хинди",
    "hi-Latn-alt-variant" to "хинглиш",
    "hil" to "хилигайнон",
    "hit" to "хитски",
    "hmn" to "хмонг",
    "ho" to "хири моту",
    "hr" to "хърватски",
    "hsb" to "горнолужишки",
    "ht" to "хаитянски креолски",
    "hu" to "унгарски",
    "hup" to "хупа",
    "hur" to "халкомелем",
    "hy" to "арменски",
    "hz" to "хереро",
    "ia" to "интерлингва",
    "iba" to "ибан",
    "ibb" to "ибибио",
    "id" to "индонезийски",
    "ie" to "интерлингве",
    "ig" to "игбо",
    "ii" to "съчуански йи",
    "ik" to "инупиак",
    "ikt" to "западноканадски инуктитут",
    "ilo" to "илоко",
    "inh" to "ингушетски",
    "io" to "идо",
    "is" to "исландски",
    "it" to "италиански",
    "iu" to "инуктитут",
    "ja" to "японски",
    "jbo" to "ложбан",
    "jgo" to "нгомба",
    "jmc" to "мачаме",
    "jpr" to "юдео-персийски",
    "jrb" to "юдео-арабски",
    "jv" to "явански",
    "ka" to "грузински",
    "kaa" to "каракалпашки",
    "kab" to "кабилски",
    "kac" to "качински",
    "kaj" to "жжу",
    "kam" to "камба",
    "kaw" to "кави",
    "kbd" to "кабардски",
    "kcg" to "туап",
    "kde" to "маконде",
    "kea" to "кабовердиански",
    "kfo" to "коро",
    "kg" to "конгоански",
    "kgp" to "кайнганг",
    "kha" to "кхаси",
    "kho" to "котски",
    "khq" to "койра чиини",
    "ki" to "кикую",
    "kj" to "кваняма",
    "kk" to "казахски",
    "kkj" to "како",
    "kl" to "гренландски",
    "kln" to "календжин",
    "km" to "кхмерски",
    "kmb" to "кимбунду",
    "kn" to "каннада",
    "ko" to "корейски",
    "koi" to "коми-пермякски",
    "kok" to "конкани",
    "kos" to "косраен",
    "kpe" to "кпеле",
    "kr" to "канури",
    "krc" to "карачай-балкарски",
    "krl" to "карелски",
    "kru" to "курук",
    "ks" to "кашмирски",
    "ksb" to "шамбала",
    "ksf" to "бафия",
    "ksh" to "кьолнски",
    "ku" to "кюрдски",
    "kum" to "кумикски",
    "kut" to "кутенай",
    "kv" to "коми",
    "kw" to "корнуолски",
    "kwk" to "куак’уала",
    "kxv" to "кови",
    "ky" to "киргизки",
    "la" to "латински",
    "lad" to "ладино",
    "lag" to "ланги",
    "lah" to "лахнда",
    "lam" to "ламба",
    "lb" to "люксембургски",
    "lez" to "лезгински",
    "lg" to "ганда",
    "li" to "лимбургски",
    "lij" to "лигурски",
    "lil" to "лилоует",
    "lkt" to "лакота",
    "lmo" to "ломбардски",
    "ln" to "лингала",
    "lo" to "лаоски",
    "lol" to "монго",
    "lou" to "луизиански креолски",
    "loz" to "лози",
    "lrc" to "северен лури",
    "lsm" to "саамски",
    "lt" to "литовски",
    "lu" to "луба-катанга",
    "lua" to "луба-лулуа",
    "lui" to "луисеньо",
    "lun" to "лунда",
    "luo" to "луо",
    "lus" to "мизо",
    "luy" to "лухя",
    "lv" to "латвийски",
    "mad" to "мадурски",
    "mag" to "магахи",
    "mai" to "майтхили",
    "mak" to "макасар",
    "man" to "мандинго",
    "mas" to "масайски",
    "mdf" to "мокша",
    "mdr" to "мандар",
    "men" to "менде",
    "mer" to "меру",
    "mfe" to "морисиен",
    "mg" to "малгашки",
    "mga" to "средновековен ирландски",
    "mgh" to "макуа мето",
    "mgo" to "мета",
    "mh" to "маршалезе",
    "mi" to "маорски",
    "mic" to "микмак",
    "min" to "минангкабау",
    "mk" to "македонски",
    "ml" to "малаялам",
    "mn" to "монголски",
    "mnc" to "манджурски",
    "mni" to "манипурски",
    "moe" to "инну-аймун",
    "moh" to "мохоук",
    "mos" to "моси",
    "mr" to "марати",
    "ms" to "малайски",
    "mt" to "малтийски",
    "mua" to "мунданг",
    "mul" to "многоезични",
    "mus" to "мускогски",
    "mwl" to "мирандийски",
    "mwr" to "марвари",
    "my" to "бирмански",
    "myv" to "ерзиа",
    "mzn" to "мазандерански",
    "na" to "науру",
    "nap" to "неаполитански",
    "naq" to "нама",
    "nb" to "норвежки (букмол)",
    "nd" to "северен ндебеле",
    "nds" to "долнонемски",
    "nds-NL" to "долносаксонски",
    "ne" to "непалски",
    "new" to "неварски",
    "ng" to "ндонга",
    "nia" to "ниас",
    "niu" to "ниуеан",
    "nl" to "нидерландски",
    "nl-BE" to "фламандски",
    "nmg" to "квасио",
    "nn" to "норвежки (нюношк)",
    "nnh" to "нгиембун",
    "no" to "норвежки",
    "nog" to "ногаи",
    "non" to "старонорвежки",
    "nqo" to "нко",
    "nr" to "южен ндебеле",
    "nso" to "северен сото",
    "nus" to "нуер",
    "nv" to "навахо",
    "nwc" to "класически невари",
    "ny" to "нянджа",
    "nym" to "ниамвези",
    "nyn" to "нянколе",
    "nyo" to "нуоро",
    "nzi" to "нзима",
    "oc" to "окситански",
    "oj" to "оджибва",
    "ojb" to "северозападен оджибве",
    "ojc" to "централен оджибва",
    "ojs" to "оджи крий",
    "ojw" to "западен оджибва",
    "oka" to "оканаган",
    "om" to "оромо",
    "or" to "ория",
    "os" to "осетински",
    "osa" to "осейджи",
    "ota" to "отомански турски",
    "pa" to "пенджабски",
    "pag" to "пангасинан",
    "pal" to "пахлави",
    "pam" to "пампанга",
    "pap" to "папиаменто",
    "pau" to "палауан",
    "pcm" to "нигерийски пиджин",
    "peo" to "староперсийски",
    "phn" to "финикийски",
    "pi" to "пали",
    "pis" to "пиджин",
    "pl" to "полски",
    "pon" to "понапеан",
    "pqm" to "малисеет-пасамакуоди",
    "prg" to "пруски",
    "pro" to "старопровансалски",
    "ps" to "пущу",
    "ps-alt-variant" to "пущунски",
    "pt" to "португалски",
    "qu" to "кечуа",
    "quc" to "киче",
    "raj" to "раджастански",
    "rap" to "рапа нуи",
    "rar" to "раротонга",
    "rhg" to "рохинга",
    "rm" to "реторомански",
    "rn" to "рунди",
    "ro" to "румънски",
    "ro-MD" to "молдовски",
    "rof" to "ромбо",
    "rom" to "ромски",
    "ru" to "руски",
    "rup" to "арумънски",
    "rw" to "киняруанда",
    "rwk" to "рва",
    "sa" to "санскрит",
    "sad" to "сандаве",
    "sah" to "саха",
    "sam" to "самаритански арамейски",
    "saq" to "самбуру",
    "sas" to "сасак",
    "sat" to "сантали",
    "sba" to "нгамбай",
    "sbp" to "сангу",
    "sc" to "сардински",
    "scn" to "сицилиански",
    "sco" to "шотландски",
    "sd" to "синдхи",
    "sdh" to "южнокюрдски",
    "se" to "северносаамски",
    "seh" to "сена",
    "sel" to "селкуп",
    "ses" to "койраборо сени",
    "sg" to "санго",
    "sga" to "староирландски",
    "sh" to "сърбохърватски",
    "shi" to "ташелхит",
    "shn" to "шан",
    "si" to "синхалски",
    "sid" to "сидамо",
    "sk" to "словашки",
    "sl" to "словенски",
    "slh" to "южен лашутсийд",
    "sm" to "самоански",
    "sma" to "южносаамски",
    "smj" to "луле-саамски",
    "smn" to "инари-саамски",
    "sms" to "сколт-саамски",
    "sn" to "шона",
    "snk" to "сонинке",
    "so" to "сомалийски",
    "sog" to "согдийски",
    "sq" to "албански",
    "sr" to "сръбски",
    "srn" to "сранан тонго",
    "srr" to "серер",
    "ss" to "свати",
    "ssy" to "сахо",
    "st" to "сото",
    "str" to "стрейтс салиш",
    "su" to "сундански",
    "suk" to "сукума",
    "sus" to "сусу",
    "sux" to "шумерски",
    "sv" to "шведски",
    "sw" to "суахили",
    "sw-CD" to "конгоански суахили",
    "swb" to "коморски",
    "syc" to "класически сирийски",
    "syr" to "сирийски",
    "szl" to "силезийски",
    "ta" to "тамилски",
    "tce" to "южен тучоне",
    "te" to "телугу",
    "tem" to "темне",
    "teo" to "тесо",
    "ter" to "терено",
    "tet" to "тетум",
    "tg" to "таджикски",
    "tgx" to "тагиш",
    "th" to "тайски",
    "tht" to "талтан",
    "ti" to "тигриня",
    "tig" to "тигре",
    "tiv" to "тив",
    "tk" to "туркменски",
    "tkl" to "токелайски",
    "tl" to "тагалог",
    "tlh" to "клингонски",
    "tli" to "тлингит",
    "tmh" to "тамашек",
    "tn" to "тсвана",
    "to" to "тонгански",
    "tog" to "нианса тонга",
    "tok" to "токи пона",
    "tpi" to "ток писин",
    "tr" to "турски",
    "trv" to "тароко",
    "ts" to "цонга",
    "tsi" to "цимшиански",
    "tt" to "татарски",
    "ttm" to "северен тучоне",
    "tum" to "тумбука",
    "tvl" to "тувалуански",
    "tw" to "туи",
    "twq" to "тасавак",
    "ty" to "таитянски",
    "tyv" to "тувински",
    "tzm" to "централноатласки тамазигт",
    "udm" to "удмуртски",
    "ug" to "уйгурски",
    "uga" to "угаритски",
    "uk" to "украински",
    "umb" to "умбунду",
    "und" to "непознат език",
    "ur" to "урду",
    "uz" to "узбекски",
    "vai" to "ваи",
    "ve" to "венда",
    "vec" to "венециански",
    "vi" to "виетнамски",
    "vmw" to "макува",
    "vo" to "волапюк",
    "vot" to "вотик",
    "vun" to "вунджо",
    "wa" to "валонски",
    "wae" to "валзерски немски",
    "wal" to "валамо",
    "war" to "варай",
    "was" to "уашо",
    "wbp" to "валпири",
    "wo" to "волоф",
    "wuu" to "ву китайски",
    "xal" to "калмик",
    "xh" to "кхоса",
    "xnr" to "кангри",
    "xog" to "сога",
    "yao" to "яо",
    "yap" to "япезе",
    "yav" to "янгбен",
    "ybb" to "йемба",
    "yi" to "идиш",
    "yo" to "йоруба",
    "yrl" to "ненгату",
    "yue" to "кантонски",
    "yue-alt-menu" to "китайски, кантонски",
    "za" to "зуанг",
    "zap" to "запотек",
    "zbl" to "блис символи",
    "zen" to "зенага",
    "zgh" to "стандартен марокански тамазигт",
    "zh" to "китайски",
    "zh-alt-menu" to "китайски, мандарин",
    "zh-Hans" to "китайски (опростен)",
    "zh-Hans-alt-long" to "китайски, мандарин (опростен)",
    "zh-Hant" to "китайски (традиционен)",
    "zh-Hant-alt-long" to "китайски, мандарин (традиционен)",
    "zu" to "зулуски",
    "zun" to "зуни",
    "zxx" to "без лингвистично съдържание",
    "zza" to "заза",
  ) }

  val bgc: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bgc" to "हरियाणवी",
    "en" to "अंग्रेजी",
  ) }

  val bgn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "افار",
    "ab" to "آبخازی",
    "ace" to "آچه‌ای",
    "ada" to "ادانگمی",
    "ady" to "ادیغی",
    "af" to "افریکانس",
    "agq" to "اغیمی",
    "ain" to "آینو",
    "ak" to "اکانی",
    "ale" to "الیوتی",
    "alt" to "جهلسرین آلتایی",
    "am" to "امهاری",
    "an" to "آراگونی",
    "anp" to "انگیکای",
    "ar" to "عربی",
    "ar-001" to "پیشرفته‌این عربی",
    "arn" to "ماپوچه‌ای",
    "arp" to "اراپاهو",
    "as" to "آسامی",
    "asa" to "آسو",
    "ast" to "آستوری",
    "av" to "آواری",
    "awa" to "آوادی",
    "ay" to "ایمارای",
    "az" to "آذربایجانی",
    "az-alt-short" to "آذری",
    "ba" to "باشقیری",
    "ban" to "بالینسی",
    "bas" to "باسا",
    "be" to "بیلاروسی",
    "bem" to "بیمبا",
    "bez" to "بینای",
    "bg" to "بلغاری",
    "bgn" to "بلوچی (رخشانی)",
    "bho" to "بهوجپوری",
    "bi" to "بیسلامه",
    "bin" to "بینی",
    "bla" to "سیکسیکا",
    "bm" to "بمبارای",
    "bn" to "بنگالی",
    "bo" to "تبتی",
    "br" to "بریتون",
    "brx" to "بۆدو",
    "bs" to "بوسنی",
    "bug" to "بوگینسی",
    "byn" to "بلین",
    "ca" to "کاتالانی",
    "ce" to "چیچینی",
    "ceb" to "سینوگبانونی",
    "cgg" to "شیگی",
    "ch" to "چه‌مروری",
    "chk" to "تروسکی",
    "chm" to "ماری",
    "cho" to "چاکتاوی",
    "chr" to "چیروکی",
    "chy" to "شاینی زبان",
    "ckb" to "مرکزین کوردی",
    "ckb-alt-menu" to "مرکزین کوردی",
    "ckb-alt-variant" to "مرکزین کوردی",
    "co" to "کرسی",
    "crs" to "سیشلی کریولین فرانسوی",
    "cs" to "چیکی",
    "cu" to "سلاواکی کلیسایی",
    "cv" to "چواشی",
    "cy" to "ولزی",
    "da" to "ڈینمارکی",
    "dak" to "داکوتی",
    "dar" to "دارگوایی",
    "dav" to "تایتایی",
    "de" to "جرمنی",
    "de-AT" to "استرالیاین جرمنی",
    "de-CH" to "سویسین جرمنی",
    "dgr" to "داگریبی",
    "dje" to "زرمی",
    "dsb" to "صُربی سفلی",
    "dua" to "دوالی",
    "dv" to "دیوهی",
    "dyo" to "جولا فونی",
    "dz" to "دزونگخا",
    "dzg" to "دزازا",
    "ebu" to "ایمبو",
    "ee" to "اوه‌ای",
    "efi" to "ایفیکی",
    "eka" to "ایکاجوکی",
    "el" to "یونانی",
    "en" to "انگریزی",
    "en-AU" to "استرالیاین انگریزی",
    "en-CA" to "کاناڈاین انگریزی",
    "en-GB" to "بریتانیاین انگریزی",
    "en-GB-alt-short" to "بریتن انگریزی",
    "en-US" to "امریکاین انگریزی",
    "en-US-alt-short" to "یو اس انگریزی",
    "eo" to "اسپرانتوی",
    "es" to "هسپانوی",
    "es-419" to "لاتین امریکایی هسپانوی",
    "es-ES" to "اوروپایین هسپانوی",
    "es-MX" to "مکسیکوین هسپانوی",
    "et" to "استونیایی",
    "eu" to "باسکی",
    "ewo" to "اواندویی",
    "fa" to "پارسی",
    "ff" to "فولایی",
    "fi" to "فنلاندی",
    "fil" to "فلیپینی",
    "fj" to "فیجی",
    "fo" to "فاروئی",
    "fon" to "فون",
    "fr" to "فرانسوی",
    "fr-CA" to "کاناڈاین فرانسوی",
    "fr-CH" to "اشاره‌این فرانسوی",
    "fur" to "فریولی",
    "fy" to "روچ‌کپتین فریزی",
    "ga" to "ایرلندی",
    "gaa" to "گا",
    "gd" to "اسکاتلندی گیلی",
    "gez" to "گعزی",
    "gil" to "گیلبیرتی",
    "gl" to "گالیسی",
    "gn" to "گوارانی",
    "gor" to "گورونتالو",
    "gsw" to "جرمنین سوئیسی",
    "gu" to "گوجراتی",
    "guz" to "گوسی",
    "gv" to "مانی",
    "gwi" to "گویچنی",
    "ha" to "هوسه‌ای",
    "haw" to "هاوایی",
    "he" to "عبرانی",
    "hi" to "هندی",
    "hil" to "هیلیگایونی",
    "hmn" to "همونگی",
    "hr" to "کراوتی",
    "hsb" to "علیای سیربی",
    "ht" to "کریول آییسینی",
    "hu" to "مجارستانی",
    "hup" to "هوپی",
    "hy" to "ارمنی",
    "hz" to "هرویی",
    "ia" to "اینترلینگوایی",
    "iba" to "ایبانگه",
    "ibb" to "ایبیبیو",
    "id" to "ایندونیزیایی",
    "ig" to "ایگبویی",
    "ii" to "یی سیچوان",
    "ilo" to "ایلوکانوی",
    "inh" to "اینگوشی",
    "io" to "ایدوی",
    "is" to "ایسلندی",
    "it" to "ایتالیایی",
    "iu" to "اینوکتیتوتی",
    "ja" to "جاپانی",
    "jbo" to "لوجبانی",
    "jgo" to "نگومبی",
    "jmc" to "ماچامه‌ای",
    "jv" to "جاوه‌ای",
    "ka" to "گرجی",
    "kab" to "قبایلی",
    "kac" to "کاچینی",
    "kaj" to "جیجو",
    "kam" to "کامبایی",
    "kbd" to "کاباردینی",
    "kcg" to "تیاپی",
    "kde" to "ماکوندی",
    "kea" to "کابووردیانو",
    "kfo" to "کورو",
    "kha" to "خاسی",
    "khq" to "کوجراچینی",
    "ki" to "کیکویویی",
    "kj" to "کوانیامایی",
    "kk" to "قزاقی",
    "kkj" to "کاکویی",
    "kl" to "گرینلندی",
    "kln" to "کالنجین",
    "km" to "خمری",
    "kmb" to "کیمبوندویی",
    "kn" to "کانارا",
    "ko" to "کوریایی",
    "kok" to "کونکانی",
    "kpe" to "کپله‌ای",
    "kr" to "کانوری",
    "krc" to "قره‌چایی‐بالکاری",
    "krl" to "کاریلینی",
    "kru" to "کوروخی",
    "ks" to "کشمیری",
    "ksb" to "شامبالای",
    "ksf" to "بافیا",
    "ksh" to "کولوگنی",
    "ku" to "کوردی",
    "kum" to "کومیکی",
    "kv" to "کومی",
    "kw" to "کورنی",
    "ky" to "قیرغیزی",
    "la" to "لاتین",
    "lad" to "لادینو",
    "lag" to "لانگی",
    "lb" to "لوگزامبورگی",
    "lez" to "لزگی",
    "lg" to "گاندایی",
    "li" to "لیمبورگی",
    "lkt" to "لاکوتا",
    "ln" to "لینگالایی",
    "lo" to "لائوسی",
    "loz" to "لوزی",
    "lrc" to "بُرزسرین لوری",
    "lt" to "لیتوانی",
    "lu" to "لوبایی‐کاتانگا",
    "lua" to "لوبایی‐لولوا",
    "lun" to "لوندایی",
    "luo" to "لوئویی",
    "lus" to "لوشه‌ای",
    "luy" to "لویایی",
    "lv" to "لاتوینی",
    "mad" to "مادورایی",
    "mag" to "ماگاهی",
    "mai" to "مایدیلی",
    "mak" to "ماکاساری",
    "mas" to "ماسایی",
    "mdf" to "موکشی",
    "men" to "منده‌ای",
    "mer" to "مرویی",
    "mfe" to "موریسینی",
    "mg" to "مالاگاسی",
    "mgh" to "ماکوا متوی",
    "mgo" to "میٹایی",
    "mh" to "مارشالی",
    "mi" to "مائوری",
    "mic" to "میکماکی",
    "min" to "مینانگ‌کابویی",
    "mk" to "مقدونی",
    "ml" to "مالایالامی",
    "mn" to "منگولی",
    "mni" to "مانیپوری",
    "moh" to "موهاکی",
    "mos" to "موسیی",
    "mr" to "مراٹی",
    "ms" to "مالایی",
    "mt" to "مالته‌ای",
    "mua" to "ماندانگی",
    "mul" to "چینکه زبان",
    "mus" to "کریکی",
    "mwl" to "میراندیسی",
    "my" to "بورمي",
    "myv" to "ارزیای",
    "mzn" to "مازندرانی",
    "na" to "نائورویی",
    "nap" to "ناپلی",
    "naq" to "نامایی",
    "nb" to "نارویی بوک‌مولی",
    "nd" to "بُرزسرین انده‌بله‌ای",
    "nds-NL" to "ساکسونی سفلی",
    "ne" to "نیپالی",
    "new" to "نیواری",
    "ng" to "اندونگی",
    "nia" to "نیاسی",
    "niu" to "نیویی",
    "nl" to "هالنڈی",
    "nl-BE" to "فلامانی",
    "nmg" to "کوازیو",
    "nn" to "نارویی نی‌نوشکی",
    "nnh" to "انگی‌ایمبونی",
    "nog" to "نغایی",
    "nqo" to "نکوی",
    "nr" to "جهلسرین انده‌بله‌ای",
    "nso" to "بُرزسرین سوتویی",
    "nus" to "نویری",
    "nv" to "ناواهویی",
    "ny" to "نیانجی",
    "nyn" to "نیانکوله‌ای",
    "oc" to "اوکیتایی",
    "om" to "اورومویی",
    "or" to "اودیه‌ای",
    "os" to "آسیتینی",
    "pa" to "پنجاپی",
    "pag" to "پانگاسینانی",
    "pam" to "پامپانگی",
    "pap" to "پاپیامنتوی",
    "pau" to "پالائویی",
    "pcm" to "نایجیریای پیڈگین",
    "pl" to "پولنڈی",
    "prg" to "پروسی",
    "ps" to "پشتو",
    "pt" to "پورتگالی",
    "pt-BR" to "برازیلین پورتگالی",
    "pt-PT" to "اوروپایین پورتگالی",
    "qu" to "کچوایی",
    "quc" to "کیچه‌",
    "rap" to "راپانویی",
    "rar" to "راروتونگی",
    "rm" to "رومانش",
    "rn" to "رونڈی",
    "ro" to "رومانی",
    "ro-MD" to "مالداوی",
    "rof" to "رومبویی",
    "ru" to "اوروسی",
    "rup" to "آرومانی",
    "rw" to "کینیارواندی",
    "rwk" to "روایی",
    "sa" to "سانسکریٹ",
    "sad" to "سانڈاوه‌ای",
    "sah" to "یاقوتی",
    "saq" to "سامبوروی",
    "sat" to "سانٹالی",
    "sba" to "انگامبی",
    "sbp" to "سانگویی",
    "sc" to "ساردینی",
    "scn" to "سیسیلی",
    "sco" to "اسکاتلندی",
    "sd" to "سیندی",
    "se" to "بُرزسرین سامی",
    "seh" to "سینایی",
    "ses" to "کویرابورا سنی",
    "sg" to "سانگۆیی",
    "shi" to "تاچل‌هیتی",
    "shn" to "شانی",
    "si" to "سینهالی",
    "sk" to "اسلواکی",
    "sl" to "اسلوانی",
    "sm" to "ساموآیی",
    "sma" to "جهلسرین سامی",
    "smj" to "لوله سامی",
    "smn" to "اناری سمی",
    "sms" to "اسکولت سامی",
    "sn" to "شونی",
    "snk" to "سونینکه‌ای",
    "so" to "سومالی",
    "sq" to "البانی",
    "sr" to "سیربی",
    "srn" to "تاکی‌تاکی",
    "ss" to "سواتی",
    "ssy" to "ساهویی",
    "st" to "جهلسرین سوتویی",
    "su" to "سونڈی",
    "suk" to "سوکومایی",
    "sv" to "سویڈنی",
    "sw" to "سواحلی",
    "sw-CD" to "کانگویی سواحلی",
    "swb" to "قمرین",
    "syr" to "سریانی",
    "ta" to "تامیلی",
    "te" to "تلوگویی",
    "tem" to "تیمنه‌ای",
    "teo" to "تیسویی",
    "tet" to "ٹیٹومی",
    "tg" to "تاجیکی",
    "th" to "تایلندی",
    "ti" to "ٹیگرینیایی",
    "tig" to "ٹایگری",
    "tk" to "تورکمنی",
    "tlh" to "کلینگونی",
    "tn" to "تسوانی",
    "to" to "تونگی",
    "tpi" to "توک‌پیسینی",
    "tr" to "تورکی",
    "trv" to "تاروکویی",
    "ts" to "تسونگی",
    "tt" to "تاتاری",
    "tum" to "تومبوکی",
    "tvl" to "ٹووالی",
    "twq" to "تسواکی",
    "ty" to "تاهیتی",
    "tyv" to "ٹووینی",
    "tzm" to "مرکزین اتلسین تامازیگتی",
    "udm" to "اوڈمورتی",
    "ug" to "اویغوری",
    "uk" to "اوکراینی",
    "umb" to "امبونڈویی",
    "und" to "نازانتین زبان",
    "ur" to "اوردو",
    "uz" to "اوزبکی",
    "vai" to "وایی",
    "ve" to "وینڈایی",
    "vi" to "ویتنامی",
    "vo" to "ولاپوکی",
    "vun" to "ونجو",
    "wa" to "والونی",
    "wae" to "والسیری",
    "wal" to "وولایٹی",
    "war" to "واری",
    "wo" to "ولوفی",
    "xal" to "کالمیکی",
    "xh" to "خوسی",
    "xog" to "سوگایی",
    "yav" to "یانگبینی",
    "ybb" to "یمبی",
    "yi" to "یدی",
    "yo" to "یوروبایی",
    "yue" to "کانتونیونی",
    "yue-alt-menu" to "کانتونیونی",
    "zgh" to "آمازیغی مراکشی معیار",
    "zh" to "چینایی",
    "zh-alt-menu" to "چینایی",
    "zh-Hans" to "ساده‌گین چینایی",
    "zh-Hans-alt-long" to "ساده‌گین چینایی",
    "zh-Hant" to "غدیمین چینایی",
    "zh-Hant-alt-long" to "غدیمین چینایی",
    "zu" to "زولویی",
    "zun" to "زونی",
    "zxx" to "بغیر شه زبانین لڑا",
    "zza" to "زازایی",
  ) }

  val bgn_AE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bgn_AF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bgn_IR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bgn_OM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val bho: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bho" to "भोजपुरी",
    "en" to "अंगरेजी",
  ) }

  val blo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar" to "gɩlaaribuja",
    "ar-001" to "gɩlaaribuja ŋgɩɖee kǝ ba na fʊba na",
    "blo" to "anii kagɩja",
    "bn" to "baŋglaa kagɩja",
    "de" to "gɩjaamaja",
    "en" to "gɛɛshɩ",
    "en-US" to "gɛɛshɩ (Ganɔ gaɖɔŋkɔnɔ kabʊtǝna Amalɩka nɩ)",
    "en-US-alt-short" to "gɛɛshɩ (GKA)",
    "es" to "gɩspaŋja",
    "es-419" to "gɩspaŋja (latɛŋ kaAmalɩkatǝna)",
    "fr" to "gɩfɔnɔ",
    "hi-Latn" to "hinɖii kagɩja (latɛŋ kʊja)",
    "hi-Latn-alt-variant" to "hiŋgliishɩ kagɩja",
    "id" to "Ɛnɖonosii kagɩja",
    "it" to "gɩtaliija",
    "ja" to "gɩjapaŋja",
    "ko" to "Koree kagɩja",
    "nl" to "Holanɖ kagɩja",
    "pl" to "Polanɖ kagɩja",
    "pt" to "gɩpɔrtigalja",
    "ru" to "gɩrɔɔshɩyaja",
    "th" to "taɩ kagɩja",
    "tr" to "gɩturkiija",
    "und" to "gɩkrǝ ŋgɩɖee kʊyɔʊ ʊ mana ma",
    "zh" to "gɩcaɩnaja manɖarɛŋ",
    "zh-alt-menu" to "gɩcaɩnaja, manɖarɛŋ",
    "zh-Hans" to "gɩcaɩnaja gɩburoka",
    "zh-Hans-alt-long" to "gɩcaɩnaja manɖarɛŋ gɩburoka",
    "zh-Hant" to "gɩcaɩnaja tututu",
    "zh-Hant-alt-long" to "gɩcaɩnaja manɖarɛŋ tututu",
  ) }

  val blt: ImmutableMap<String, String> by lazy { immutableMapOf(
    "blt" to "ꪼꪕꪒꪾ",
  ) }

  val bm: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "akankan",
    "am" to "amarikikan",
    "ar" to "larabukan",
    "be" to "biyelorisikan",
    "bg" to "buligarikan",
    "bm" to "bamanakan",
    "bn" to "bɛngalikan",
    "cs" to "cɛkikan",
    "de" to "alimaɲikan",
    "el" to "gɛrɛsikan",
    "en" to "angilɛkan",
    "es" to "esipaɲolkan",
    "fa" to "perisanikan",
    "fr" to "tubabukan",
    "ha" to "awusakan",
    "hi" to "inidikan",
    "hu" to "oŋirikan",
    "id" to "Ɛndonezikan",
    "ig" to "igibokan",
    "it" to "italikan",
    "ja" to "zapɔnekan",
    "jv" to "javanekan",
    "km" to "kambojikan",
    "ko" to "korekan",
    "ms" to "malɛzikan",
    "my" to "birimanikan",
    "ne" to "nepalekan",
    "nl" to "olandekan",
    "pa" to "pɛnijabikan",
    "pl" to "polonekan",
    "pt" to "pɔritigalikan",
    "ro" to "rumanikan",
    "ru" to "irisikan",
    "rw" to "ruwandakan",
    "so" to "somalikan",
    "sv" to "suwɛdikan",
    "ta" to "tamulikan",
    "th" to "tayikan",
    "tr" to "turikikan",
    "uk" to "ukɛrɛnikan",
    "ur" to "urudukan",
    "vi" to "wiyɛtinamukan",
    "yo" to "yorubakan",
    "zh" to "siniwakan",
    "zh-alt-menu" to "siniwakan",
    "zu" to "zulukan",
  ) }

  val bn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "আফার",
    "ab" to "আবখাজিয়ান",
    "ace" to "অ্যাচাইনিজ",
    "ach" to "আকোলি",
    "ada" to "অদাগ্মে",
    "ady" to "আদেগে",
    "ae" to "আবেস্তীয়",
    "af" to "আফ্রিকান",
    "afh" to "আফ্রিহিলি",
    "agq" to "এঘেম",
    "ain" to "আইনু",
    "ak" to "আকান",
    "akk" to "আক্কাদিয়ান",
    "ale" to "আলেউত",
    "alt" to "দক্ষিন আলতাই",
    "am" to "আমহারিক",
    "an" to "আর্গোনিজ",
    "ang" to "প্রাচীন ইংরেজী",
    "ann" to "ওবোলো",
    "anp" to "আঙ্গিকা",
    "ar" to "আরবি",
    "ar-001" to "আধুনিক আদর্শ আরবি",
    "arc" to "আরামাইক",
    "arn" to "মাপুচে",
    "arp" to "আরাপাহো",
    "ars" to "নজদি আরবি",
    "arw" to "আরাওয়াক",
    "as" to "অসমীয়া",
    "asa" to "আসু",
    "ast" to "আস্তুরিয়",
    "atj" to "আটিকামেকিউ",
    "av" to "আভেরিক",
    "awa" to "আওয়াধি",
    "ay" to "আয়মারা",
    "az" to "আজারবাইজানী",
    "az-alt-short" to "আজেরি",
    "ba" to "বাশকির",
    "bal" to "বেলুচী",
    "ban" to "বালিনীয়",
    "bas" to "বাসা",
    "be" to "বেলারুশিয়",
    "bej" to "বেজা",
    "bem" to "বেম্বা",
    "bez" to "বেনা",
    "bg" to "বুলগেরিয়",
    "bgc" to "হরিয়ানভি",
    "bgn" to "পশ্চিম বালোচি",
    "bho" to "ভোজপুরি",
    "bi" to "বিসলামা",
    "bik" to "বিকোল",
    "bin" to "বিনি",
    "bla" to "সিকসিকা",
    "blo" to "অ্যানি",
    "bm" to "বামবারা",
    "bn" to "বাংলা",
    "bo" to "তিব্বতি",
    "br" to "ব্রেটন",
    "bra" to "ব্রাজ",
    "brx" to "বোড়ো",
    "bs" to "বসনীয়",
    "bua" to "বুরিয়াত",
    "bug" to "বুগিনিজ",
    "byn" to "ব্লিন",
    "ca" to "কাতালান",
    "cad" to "ক্যাডো",
    "car" to "ক্যারিব",
    "cay" to "কায়ুগা",
    "cch" to "আত্সাম",
    "ccp" to "চাকমা",
    "ce" to "চেচেন",
    "ceb" to "চেবুয়ানো",
    "cgg" to "চিগা",
    "ch" to "চামোরো",
    "chb" to "চিবচা",
    "chg" to "চাগাতাই",
    "chk" to "চুকিজ",
    "chm" to "মারি",
    "chn" to "চিনুক জার্গন",
    "cho" to "চকটাও",
    "chp" to "চিপেওয়ান",
    "chr" to "চেরোকী",
    "chy" to "চেইয়েন",
    "ckb" to "মধ্য কুর্দিশ",
    "ckb-alt-menu" to "কুর্দিশ, মধ্য",
    "ckb-alt-variant" to "কুর্দিশ, সোরানি",
    "clc" to "চিলকোটিন",
    "co" to "কর্সিকান",
    "cop" to "কপটিক",
    "cr" to "ক্রি",
    "crg" to "মিচিফ",
    "crh" to "ক্রিমিয়ান তুর্কি",
    "crj" to "দক্ষিণ পূর্ব ক্রী",
    "crk" to "প্লেনস ক্রী",
    "crl" to "উত্তর পূর্ব ক্রী",
    "crm" to "মুস ক্রী",
    "crr" to "ক্যারোলিনা অ্যাল্গঙ্কুইয়ান",
    "crs" to "সেসেলওয়া ক্রেওল ফ্রেঞ্চ",
    "cs" to "চেক",
    "csb" to "কাশুবিয়ান",
    "csw" to "সোয়াম্পি ক্রী",
    "cu" to "চার্চ স্লাভিক",
    "cv" to "চুবাস",
    "cy" to "ওয়েলশ",
    "da" to "ডেনিশ",
    "dak" to "ডাকোটা",
    "dar" to "দার্গওয়া",
    "dav" to "তাইতা",
    "de" to "জার্মান",
    "del" to "ডেলাওয়ের",
    "den" to "স্ল্যাভ",
    "dgr" to "দোগ্রীব",
    "din" to "ডিংকা",
    "dje" to "জার্মা",
    "doi" to "ডোগরি",
    "dsb" to "নিম্নতর সোর্বিয়ান",
    "dua" to "দুয়ালা",
    "dum" to "মধ্য ডাচ",
    "dv" to "দিবেহি",
    "dyo" to "জোলা-ফনী",
    "dyu" to "ডিউলা",
    "dz" to "জোংখা",
    "dzg" to "দাজাগা",
    "ebu" to "এম্বু",
    "ee" to "ইউয়ি",
    "efi" to "এফিক",
    "egy" to "প্রাচীন মিশরীয়",
    "eka" to "ইকাজুক",
    "el" to "গ্রিক",
    "elx" to "এলামাইট",
    "en" to "ইংরেজি",
    "en-GB-alt-short" to "ইংরেজি (যুক্তরাজ্য)",
    "en-US" to "ইংরেজি (আমেরিকা)",
    "en-US-alt-short" to "ইংরেজি (যুক্তরাষ্ট্র)",
    "enm" to "মধ্য ইংরেজি",
    "eo" to "এস্পেরান্তো",
    "es" to "স্প্যানিশ",
    "es-ES" to "স্প্যানিশ (ইউরোপ)",
    "et" to "এস্তোনীয়",
    "eu" to "বাস্ক",
    "ewo" to "ইওন্ডো",
    "fa" to "ফার্সি",
    "fa-AF" to "দারি",
    "fan" to "ফ্যাঙ্গ",
    "fat" to "ফান্তি",
    "ff" to "ফুলাহ্",
    "fi" to "ফিনিশ",
    "fil" to "ফিলিপিনো",
    "fj" to "ফিজিয়ান",
    "fo" to "ফেরোইস",
    "fon" to "ফন",
    "fr" to "ফরাসি",
    "frc" to "কাজুন ফরাসি",
    "frm" to "মধ্য ফরাসি",
    "fro" to "প্রাচীন ফরাসি",
    "frr" to "উত্তরাঞ্চলীয় ফ্রিসিয়ান",
    "frs" to "পূর্ব ফ্রিসিয়",
    "fur" to "ফ্রিউলিও",
    "fy" to "পশ্চিম ফ্রিসিয়ান",
    "ga" to "আইরিশ",
    "gaa" to "গা",
    "gag" to "গাগাউজ",
    "gan" to "gan",
    "gay" to "গায়ো",
    "gba" to "বায়া",
    "gd" to "স্কটিশ-গ্যেলিক",
    "gez" to "গীজ",
    "gil" to "গিলবার্টিজ",
    "gl" to "গ্যালিশিয়",
    "gmh" to "মধ্য-উচ্চ জার্মানি",
    "gn" to "গুয়ারানি",
    "goh" to "প্রাচীন উচ্চ জার্মানি",
    "gon" to "গোন্ডি",
    "gor" to "গোরোন্তালো",
    "got" to "গথিক",
    "grb" to "গ্রেবো",
    "grc" to "প্রাচীন গ্রীক",
    "gsw" to "সুইস জার্মান",
    "gu" to "গুজরাটি",
    "guz" to "গুসী",
    "gv" to "ম্যাঙ্কস",
    "gwi" to "গওইচ্’ইন",
    "ha" to "হাউসা",
    "hai" to "হাইডা",
    "haw" to "হাওয়াইয়ান",
    "hax" to "দক্ষিণী হায়দা",
    "he" to "হিব্রু",
    "hi" to "হিন্দি",
    "hi-Latn-alt-variant" to "হিংলিশ",
    "hil" to "হিলিগ্যায়নোন",
    "hit" to "হিট্টিট",
    "hmn" to "হ্‌মোঙ",
    "ho" to "হিরি মোতু",
    "hr" to "ক্রোয়েশীয়",
    "hsb" to "উচ্চ সোর্বিয়ান",
    "hsn" to "Xiang চীনা",
    "ht" to "হাইতিয়ান ক্রেওল",
    "hu" to "হাঙ্গেরীয়",
    "hup" to "হুপা",
    "hur" to "হাল্কোমেলেম",
    "hy" to "আর্মেনিয়",
    "hz" to "হেরেরো",
    "ia" to "ইন্টারলিঙ্গুয়া",
    "iba" to "ইবান",
    "ibb" to "ইবিবিও",
    "id" to "ইন্দোনেশীয়",
    "ie" to "ইন্টারলিঙ্গ",
    "ig" to "ইগ্‌বো",
    "ii" to "সিচুয়ান য়ি",
    "ik" to "ইনুপিয়াক",
    "ikt" to "পশ্চিম কানাডিয় ইনুক্টিটুট",
    "ilo" to "ইলোকো",
    "inh" to "ইঙ্গুশ",
    "io" to "ইডো",
    "is" to "আইসল্যান্ডীয়",
    "it" to "ইতালিয়",
    "iu" to "ইনুক্টিটুট",
    "ja" to "জাপানি",
    "jbo" to "লোজবান",
    "jgo" to "গোম্বা",
    "jmc" to "মাকামে",
    "jpr" to "জুদেও ফার্সি",
    "jrb" to "জুদেও আরবি",
    "jv" to "জাভানিজ",
    "ka" to "জর্জিয়ান",
    "kaa" to "কারা-কাল্পাক",
    "kab" to "কাবাইলে",
    "kac" to "কাচিন",
    "kaj" to "জজু",
    "kam" to "কাম্বা",
    "kaw" to "কাউই",
    "kbd" to "কাবার্ডিয়ান",
    "kcg" to "টিয়াপ",
    "kde" to "মাকোন্দে",
    "kea" to "কাবুভারদিয়ানু",
    "kfo" to "কোরো",
    "kg" to "কঙ্গো",
    "kgp" to "কেইনগ্যাং",
    "kha" to "খাশি",
    "kho" to "খোটানিজ",
    "khq" to "কোয়রা চীনি",
    "ki" to "কিকুয়ু",
    "kj" to "কোয়ানিয়ামা",
    "kk" to "কাজাখ",
    "kkj" to "কাকো",
    "kl" to "কালাল্লিসুট",
    "kln" to "কালেনজিন",
    "km" to "খমের",
    "kmb" to "কিম্বুন্দু",
    "kn" to "কন্নড়",
    "ko" to "কোরিয়ান",
    "koi" to "কমি-পারমিআক",
    "kok" to "কোঙ্কানি",
    "kos" to "কোস্রাইন",
    "kpe" to "ক্‌পেল্লে",
    "kr" to "কানুরি",
    "krc" to "কারচে-বাল্কার",
    "krl" to "কারেলিয়ান",
    "kru" to "কুরুখ",
    "ks" to "কাশ্মীরি",
    "ksb" to "শাম্বালা",
    "ksf" to "বাফিয়া",
    "ksh" to "কলোগনিয়ান",
    "ku" to "কুর্দিশ",
    "kum" to "কুমিয়াক",
    "kut" to "কুটেনাই",
    "kv" to "কোমি",
    "kw" to "কর্ণিশ",
    "kwk" to "কোয়াক’ওয়ালা",
    "kxv" to "কুভি",
    "ky" to "কির্গিজ",
    "la" to "লাতিন",
    "lad" to "লাদিনো",
    "lag" to "লাঙ্গি",
    "lah" to "লান্ডা",
    "lam" to "লাম্বা",
    "lb" to "লুক্সেমবার্গীয়",
    "lez" to "লেজঘিয়ান",
    "lg" to "গান্ডা",
    "li" to "লিম্বুর্গিশ",
    "lij" to "লিগুরিয়ান",
    "lil" to "লিল্লুয়েট",
    "lkt" to "লাকোটা",
    "lmo" to "লম্বার্ড",
    "ln" to "লিঙ্গালা",
    "lo" to "লাও",
    "lol" to "মোঙ্গো",
    "lou" to "লুইসিয়ানা ক্রেওল",
    "loz" to "লোজি",
    "lrc" to "উত্তরাঞ্চলীয় লুরি",
    "lsm" to "সামিয়া",
    "lt" to "লিথুয়েনীয়",
    "lu" to "লুবা-কাটাঙ্গা",
    "lua" to "লুবা-লুলুয়া",
    "lui" to "লুইসেনো",
    "lun" to "লুন্ডা",
    "luo" to "লুয়ো",
    "lus" to "মিজো",
    "luy" to "লুইয়া",
    "lv" to "লাত্‌ভীয়",
    "mad" to "মাদুরেজ",
    "mag" to "মাগাহি",
    "mai" to "মৈথিলি",
    "mak" to "ম্যাকাসার",
    "man" to "ম্যান্ডিঙ্গো",
    "mas" to "মাসাই",
    "mdf" to "মোকশা",
    "mdr" to "ম্যাণ্ডার",
    "men" to "মেন্ডে",
    "mer" to "মেরু",
    "mfe" to "মরিসিয়েন",
    "mg" to "মালাগাসি",
    "mga" to "মধ্য আইরিশ",
    "mgh" to "মাখুয়া-মেত্তো",
    "mgo" to "মেটা",
    "mh" to "মার্শালিজ",
    "mi" to "মাওরি",
    "mic" to "মিকম্যাক",
    "min" to "মিনাংকাবাউ",
    "mk" to "ম্যাসিডোনীয়",
    "ml" to "মালায়ালাম",
    "mn" to "মঙ্গোলিয়",
    "mnc" to "মাঞ্চু",
    "mni" to "মণিপুরী",
    "moe" to "ইন্নু-এমুন",
    "moh" to "মোহাওক",
    "mos" to "মসি",
    "mr" to "মারাঠি",
    "ms" to "মালয়",
    "mt" to "মল্টিয়",
    "mua" to "মুদাঙ্গ",
    "mul" to "একাধিক ভাষা",
    "mus" to "মুস্কোগী",
    "mwl" to "মিরান্ডিজ",
    "mwr" to "মারোয়ারি",
    "my" to "বর্মি",
    "myv" to "এরজিয়া",
    "mzn" to "মাজানদেরানি",
    "na" to "নাউরু",
    "nap" to "নেয়াপোলিটান",
    "naq" to "নামা",
    "nb" to "নরওয়েজিয়ান বোকমাল",
    "nd" to "উত্তর এন্দেবেলে",
    "nds" to "নিম্ন জার্মানি",
    "nds-NL" to "লো স্যাক্সন",
    "ne" to "নেপালী",
    "new" to "নেওয়ারি",
    "ng" to "এন্দোঙ্গা",
    "nia" to "নিয়াস",
    "niu" to "নিউয়ান",
    "nl" to "ওলন্দাজ",
    "nl-BE" to "ফ্লেমিশ",
    "nmg" to "কোয়াসিও",
    "nn" to "নরওয়েজিয়ান নিনর্স্ক",
    "nnh" to "নগিয়েম্বুন",
    "no" to "নরওয়েজীয়",
    "nog" to "নোগাই",
    "non" to "প্রাচীন নর্স",
    "nqo" to "এন’কো",
    "nr" to "দক্ষিণ এনডেবেলে",
    "nso" to "উত্তরাঞ্চলীয় সোথো",
    "nus" to "নুয়ার",
    "nv" to "নাভাজো",
    "nwc" to "প্রাচীন নেওয়ারী",
    "ny" to "নায়াঞ্জা",
    "nym" to "ন্যায়ামওয়েজি",
    "nyn" to "ন্যায়াঙ্কোলে",
    "nyo" to "ন্যোরো",
    "nzi" to "এনজিমা",
    "oc" to "অক্সিটান",
    "oj" to "ওজিবওয়া",
    "ojb" to "উত্তর পশ্চিম ওজিবোয়া",
    "ojc" to "মধ্য ওজিবুয়া",
    "ojs" to "ওজি-ক্রী",
    "ojw" to "পশ্চিম ওজিবোয়া",
    "oka" to "ওকানাগান",
    "om" to "অরোমো",
    "or" to "ওড়িয়া",
    "os" to "ওসেটিক",
    "osa" to "ওসেজ",
    "ota" to "অটোমান তুর্কি",
    "pa" to "পাঞ্জাবী",
    "pag" to "পাঙ্গাসিনান",
    "pal" to "পাহ্লাভি",
    "pam" to "পাম্পাঙ্গা",
    "pap" to "পাপিয়ামেন্টো",
    "pau" to "পালায়ুয়ান",
    "pcm" to "নাইজেরিয় পিজিন",
    "peo" to "প্রাচীন ফার্সি",
    "phn" to "ফোনিশীয়ান",
    "pi" to "পালি",
    "pis" to "পিজিন",
    "pl" to "পোলিশ",
    "pon" to "পোহ্নপেইয়ান",
    "pqm" to "মালিসেট-পাসামাকুয়োড্ডি",
    "prg" to "প্রুশিয়ান",
    "pro" to "প্রাচীন প্রোভেনসাল",
    "ps" to "পাশতু",
    "ps-alt-variant" to "পুশতো",
    "pt" to "পর্তুগীজ",
    "pt-PT" to "পর্তুগীজ (ইউরোপ)",
    "qu" to "কেচুয়া",
    "quc" to "কি‘চে",
    "raj" to "রাজস্থানী",
    "rap" to "রাপানুই",
    "rar" to "রারোটোংগান",
    "rhg" to "রোহিঙ্গা",
    "rm" to "রোমান্স",
    "rn" to "রুন্দি",
    "ro" to "রোমানীয়",
    "ro-MD" to "মলদাভিয়",
    "rof" to "রম্বো",
    "rom" to "রোমানি",
    "ru" to "রুশ",
    "rup" to "আরোমেনিয়",
    "rw" to "কিনয়ারোয়ান্ডা",
    "rwk" to "রাওয়া",
    "sa" to "সংস্কৃত",
    "sad" to "সান্দাওয়ে",
    "sah" to "শাখা",
    "sam" to "সামারিটান আরামিক",
    "saq" to "সামবুরু",
    "sas" to "সাসাক",
    "sat" to "সাঁওতালি",
    "sba" to "গাম্বে",
    "sbp" to "সাঙ্গু",
    "sc" to "সার্ডিনিয়ান",
    "scn" to "সিসিলিয়ান",
    "sco" to "স্কটস",
    "sd" to "সিন্ধি",
    "sdh" to "দক্ষিণ কুর্দিশ",
    "se" to "উত্তরাঞ্চলীয় সামি",
    "seh" to "সেনা",
    "sel" to "সেল্কুপ",
    "ses" to "কোয়রাবোরো সেন্নি",
    "sg" to "সাঙ্গো",
    "sga" to "প্রাচীন আইরিশ",
    "sh" to "সার্বো-ক্রোয়েশিয়",
    "shi" to "তাচেলহিত",
    "shn" to "শান",
    "si" to "সিংহলী",
    "sid" to "সিডামো",
    "sk" to "স্লোভাক",
    "sl" to "স্লোভেনীয়",
    "slh" to "দক্ষিণী লুশুটসীড",
    "sm" to "সামোয়ান",
    "sma" to "দক্ষিণাঞ্চলীয় সামি",
    "smj" to "লুলে সামি",
    "smn" to "ইনারি সামি",
    "sms" to "স্কোল্ট সামি",
    "sn" to "শোনা",
    "snk" to "সোনিঙ্কে",
    "so" to "সোমালি",
    "sog" to "সোগডিয়ান",
    "sq" to "আলবেনীয়",
    "sr" to "সার্বীয়",
    "srn" to "স্রানান টোঙ্গো",
    "srr" to "সেরের",
    "ss" to "সোয়াতি",
    "ssy" to "সাহো",
    "st" to "দক্ষিন সোথো",
    "str" to "স্ট্রেটস সালিস",
    "su" to "সুদানী",
    "suk" to "সুকুমা",
    "sus" to "সুসু",
    "sux" to "সুমেরীয়",
    "sv" to "সুইডিশ",
    "sw" to "সোয়াহিলি",
    "sw-CD" to "কঙ্গো সোয়াহিলি",
    "swb" to "কমোরিয়ান",
    "syc" to "প্রাচীন সিরিও",
    "syr" to "সিরিয়াক",
    "szl" to "সিলেশিয়ান",
    "ta" to "তামিল",
    "tce" to "দক্ষিণী টুচোন",
    "te" to "তেলুগু",
    "tem" to "টাইম্নে",
    "teo" to "তেসো",
    "ter" to "তেরেনো",
    "tet" to "তেতুম",
    "tg" to "তাজিক",
    "tgx" to "তাগিশ",
    "th" to "থাই",
    "tht" to "তাহ্লতান",
    "ti" to "তিগরিনিয়া",
    "tig" to "টাইগ্রে",
    "tiv" to "টিভ",
    "tk" to "তুর্কমেনী",
    "tkl" to "টোকেলাউ",
    "tl" to "তাগালগ",
    "tlh" to "ক্লিঙ্গন",
    "tli" to "ত্লিঙ্গিট",
    "tmh" to "তামাশেক",
    "tn" to "সোয়ানা",
    "to" to "টোঙ্গান",
    "tog" to "নায়াসা টোঙ্গা",
    "tok" to "টোকি পোনা",
    "tpi" to "টোক পিসিন",
    "tr" to "তুর্কী",
    "trv" to "তারোকো",
    "ts" to "সঙ্গা",
    "tsi" to "সিমশিয়ান",
    "tt" to "তাতার",
    "ttm" to "উত্তরাঞ্চলীয় টুচোন",
    "tum" to "তুম্বুকা",
    "tvl" to "টুভালু",
    "tw" to "টোয়াই",
    "twq" to "তাসাওয়াক",
    "ty" to "তাহিতিয়ান",
    "tyv" to "টুভিনিয়ান",
    "tzm" to "সেন্ট্রাল আটলাস তামাজিগাত",
    "udm" to "উডমুর্ট",
    "ug" to "উইঘুর",
    "uga" to "উগারিটিক",
    "uk" to "ইউক্রেনীয়",
    "umb" to "উম্বুন্দু",
    "und" to "অজানা ভাষা",
    "ur" to "উর্দু",
    "uz" to "উজবেক",
    "vai" to "ভাই",
    "ve" to "ভেন্ডা",
    "vec" to "ভেনেশিয়ান",
    "vi" to "ভিয়েতনামী",
    "vmw" to "মাখুওয়া",
    "vo" to "ভোলাপুক",
    "vot" to "ভোটিক",
    "vun" to "ভুঞ্জো",
    "wa" to "ওয়ালুন",
    "wae" to "ওয়ালসার",
    "wal" to "ওলায়ট্টা",
    "war" to "ওয়ারে",
    "was" to "ওয়াশো",
    "wbp" to "ওয়ার্লপিরি",
    "wo" to "ওলোফ",
    "wuu" to "উ চীনা",
    "xal" to "কাল্মাইক",
    "xh" to "জোসা",
    "xnr" to "কাংরি",
    "xog" to "সোগা",
    "yao" to "ইয়াও",
    "yap" to "ইয়াপেসে",
    "yav" to "ইয়াঙ্গবেন",
    "ybb" to "ইয়েম্বা",
    "yi" to "ইদ্দিশ",
    "yo" to "ইওরুবা",
    "yrl" to "নহিংগাটু",
    "yue" to "ক্যান্টোনিজ",
    "yue-alt-menu" to "চীনা, ক্যানটোনীজ",
    "za" to "ঝু্য়াঙ",
    "zap" to "জাপোটেক",
    "zbl" to "চিত্র ভাষা",
    "zen" to "জেনাগা",
    "zgh" to "আদর্শ মরক্কোন তামাজিগাত",
    "zh" to "চীনা",
    "zh-alt-menu" to "চীনা, ম্যান্ডারিন",
    "zh-Hans-alt-long" to "চীনা ম্যান্ডারিন সরলীকৃত",
    "zh-Hant-alt-long" to "ম্যান্ডারিন চীনা (ঐতিহ্যবাহী)",
    "zu" to "জুলু",
    "zun" to "জুনি",
    "zxx" to "ভাষাভিত্তিক বিষয়বস্তু নেই",
    "zza" to "জাজা",
  ) }

  val bn_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ksh" to "কোলোনিয়ান",
  ) }

  val bo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bo" to "བོད་སྐད་",
    "dz" to "རྫོང་ཁ",
    "en" to "དབྱིན་ཇིའི་སྐད།",
    "en-CA" to "དབྱིན་ཇིའི་སྐད། (ཁེ་ན་ཌ་)",
    "en-GB" to "དབྱིན་ཇིའི་སྐད། (དབྱིན་ལན་)",
    "en-GB-alt-short" to "དབྱིན་ཇིའི་སྐད། (དབྱིན་ལན་)",
    "en-US" to "དབྱིན་ཇིའི་སྐད། (ཨ་རི་)",
    "en-US-alt-short" to "དབྱིན་ཇིའི་སྐད། (ཨ་རི་)",
    "hi" to "ཧིན་དི",
    "ja" to "ཉི་ཧོང་སྐད་",
    "ne" to "ནེ་པ་ལི",
    "ru" to "ཨུ་རུ་སུ་སྐད་",
    "zh" to "རྒྱ་སྐད་",
    "zh-alt-menu" to "རྒྱ་སྐད་",
    "zza" to "ཟ་ཟའ་སྐད།",
  ) }

  val bo_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val br: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abkhazeg",
    "ace" to "achineg",
    "ach" to "acoli",
    "ada" to "adangme",
    "ady" to "adygeieg",
    "ae" to "avesteg",
    "aeb" to "arabeg Tunizia",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainoueg",
    "ak" to "akan",
    "akk" to "akadeg",
    "akz" to "alabamaeg",
    "ale" to "aleouteg",
    "aln" to "gegeg",
    "alt" to "altaieg ar Su",
    "am" to "amhareg",
    "an" to "aragoneg",
    "ang" to "hensaozneg",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "arabeg",
    "ar-001" to "arabeg modern",
    "arc" to "arameeg",
    "arn" to "araoukaneg",
    "aro" to "araona",
    "arp" to "arapaho",
    "arq" to "arabeg Aljeria",
    "ars" to "arabeg nadjiek",
    "arw" to "arawakeg",
    "ary" to "arabeg Maroko",
    "arz" to "arabeg Egipt",
    "as" to "asameg",
    "asa" to "asu",
    "ase" to "yezh sinoù Amerika",
    "ast" to "asturianeg",
    "atj" to "atikamekweg",
    "av" to "avar",
    "awa" to "awadhi",
    "ay" to "aymara",
    "az" to "azerbaidjaneg",
    "az-alt-short" to "azeri",
    "ba" to "bachkir",
    "bal" to "baloutchi",
    "ban" to "balineg",
    "bar" to "bavarieg",
    "bas" to "basaa",
    "be" to "belaruseg",
    "bej" to "bedawieg",
    "bem" to "bemba",
    "bez" to "bena",
    "bg" to "bulgareg",
    "bgn" to "baloutchi ar Cʼhornôg",
    "bho" to "bhojpuri",
    "bi" to "bislama",
    "bik" to "bikol",
    "bin" to "bini",
    "bla" to "siksika",
    "bm" to "bambara",
    "bn" to "bengali",
    "bo" to "tibetaneg",
    "br" to "brezhoneg",
    "bra" to "braj",
    "brh" to "brahweg",
    "brx" to "bodo",
    "bs" to "bosneg",
    "bss" to "akoose",
    "bua" to "bouriat",
    "bug" to "bugi",
    "byn" to "blin",
    "ca" to "katalaneg",
    "cad" to "caddo",
    "car" to "karibeg",
    "cay" to "kayougeg",
    "cch" to "atsam",
    "ccp" to "chakmaeg",
    "ce" to "tchetcheneg",
    "ceb" to "cebuano",
    "cgg" to "chigaeg",
    "ch" to "chamorru",
    "chb" to "chibcha",
    "chk" to "chuuk",
    "chm" to "marieg",
    "cho" to "choktaw",
    "chp" to "chipewyan",
    "chr" to "cherokee",
    "chy" to "cheyenne",
    "ckb" to "kurdeg sorani",
    "ckb-alt-menu" to "kurdeg kreiz",
    "ckb-alt-variant" to "kurdeg sorani",
    "clc" to "chilkotineg",
    "co" to "korseg",
    "cop" to "kopteg",
    "cr" to "kri",
    "crg" to "michifeg",
    "crh" to "turkeg Krimea",
    "crj" to "krieg ar Gevred",
    "crk" to "krieg ar cʼhompezennoù",
    "crl" to "krieg ar Biz",
    "crm" to "krieg ar cʼhornôg",
    "crr" to "algonkeg Carolina",
    "crs" to "kreoleg Sechelez",
    "cs" to "tchekeg",
    "csb" to "kachoubeg",
    "csw" to "krieg ar gwernioù",
    "cu" to "slavoneg iliz",
    "cv" to "tchouvatch",
    "cy" to "kembraeg",
    "da" to "daneg",
    "dak" to "dakota",
    "dar" to "dargwa",
    "dav" to "taita",
    "de" to "alamaneg",
    "de-AT" to "alamaneg Aostria",
    "de-CH" to "alamaneg uhel Suis",
    "del" to "delaware",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "izelsorabeg",
    "dua" to "douala",
    "dum" to "nederlandeg krenn",
    "dv" to "divehi",
    "dyo" to "diola",
    "dyu" to "dyula",
    "dz" to "dzongkha",
    "dzg" to "dazagaeg",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efik",
    "egy" to "henegipteg",
    "eka" to "ekajuk",
    "el" to "gresianeg",
    "elx" to "elameg",
    "en" to "saozneg",
    "en-AU" to "saozneg Aostralia",
    "en-CA" to "saozneg Kanada",
    "en-GB" to "saozneg Breizh-Veur",
    "en-GB-alt-short" to "saozneg RU",
    "en-US" to "saozneg Amerika",
    "en-US-alt-short" to "saozneg SU",
    "enm" to "krennsaozneg",
    "eo" to "esperanteg",
    "es" to "spagnoleg",
    "es-419" to "spagnoleg Amerika latin",
    "es-ES" to "spagnoleg Europa",
    "es-MX" to "spagnoleg Mecʼhiko",
    "et" to "estoneg",
    "eu" to "euskareg",
    "ewo" to "ewondo",
    "fa" to "perseg",
    "fa-AF" to "dareg",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fula",
    "fi" to "finneg",
    "fil" to "filipineg",
    "fit" to "finneg traoñienn an Torne",
    "fj" to "fidjieg",
    "fo" to "faeroeg",
    "fon" to "fon",
    "fr" to "galleg",
    "fr-CA" to "galleg Kanada",
    "fr-CH" to "galleg Suis",
    "frc" to "galleg cajun",
    "frm" to "krenncʼhalleg",
    "fro" to "hencʼhalleg",
    "frp" to "arpitaneg",
    "frr" to "frizeg an Norzh",
    "frs" to "frizeg ar Reter",
    "fur" to "frioulaneg",
    "fy" to "frizeg ar Cʼhornôg",
    "ga" to "iwerzhoneg",
    "gaa" to "ga",
    "gag" to "gagaouzeg",
    "gan" to "sinaeg Gan",
    "gay" to "gayo",
    "gba" to "gbaya",
    "gd" to "skoseg",
    "gez" to "gezeg",
    "gil" to "gilberteg",
    "gl" to "galizeg",
    "gmh" to "krennalamaneg uhel",
    "gn" to "guarani",
    "goh" to "henalamaneg uhel",
    "gor" to "gorontalo",
    "got" to "goteg",
    "grb" to "grebo",
    "grc" to "hencʼhresianeg",
    "gsw" to "alamaneg Suis",
    "gu" to "gujarati",
    "guz" to "gusiieg",
    "gv" to "manaveg",
    "gwi" to "gwich’in",
    "ha" to "haousa",
    "hai" to "haideg",
    "hak" to "sinaeg Hakka",
    "haw" to "hawaieg",
    "hax" to "haideg ar Su",
    "he" to "hebraeg",
    "hi" to "hindi",
    "hil" to "hiligaynon",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "kroateg",
    "hsb" to "uhelsorabeg",
    "hsn" to "sinaeg Xian",
    "ht" to "haitieg",
    "hu" to "hungareg",
    "hup" to "hupa",
    "hur" to "halkomelemeg",
    "hy" to "armenianeg",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonezeg",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "yieg Sichuan",
    "ik" to "inupiaq",
    "ikt" to "inuktitut Kanada ar Cʼhornôg",
    "ilo" to "ilokanoeg",
    "inh" to "ingoucheg",
    "io" to "ido",
    "is" to "islandeg",
    "it" to "italianeg",
    "iu" to "inuktitut",
    "ja" to "japaneg",
    "jam" to "kreoleg Jamaika",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jpr" to "yuzev-perseg",
    "jrb" to "yuzev-arabeg",
    "jv" to "javaneg",
    "ka" to "jorjianeg",
    "kaa" to "karakalpak",
    "kab" to "kabileg",
    "kac" to "kachin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kbd" to "kabardeg",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "kabuverdianu",
    "kfo" to "koroeg",
    "kg" to "kongo",
    "kgp" to "kaingangeg",
    "kha" to "khasi",
    "kho" to "khotaneg",
    "khq" to "koyra chiini",
    "ki" to "kikuyu",
    "kj" to "kwanyama",
    "kk" to "kazak",
    "kkj" to "kakoeg",
    "kl" to "greunlandeg",
    "kln" to "kalendjineg",
    "km" to "khmer",
    "kmb" to "kimbundu",
    "kn" to "kanareg",
    "ko" to "koreaneg",
    "kok" to "konkani",
    "kos" to "kosrae",
    "kpe" to "kpelle",
    "kr" to "kanouri",
    "krc" to "karatchay-balkar",
    "kri" to "krio",
    "krl" to "karelieg",
    "kru" to "kurukh",
    "ks" to "kashmiri",
    "ksb" to "shambala",
    "ksf" to "bafiaeg",
    "ksh" to "koluneg",
    "ku" to "kurdeg",
    "kum" to "koumikeg",
    "kut" to "kutenai",
    "kv" to "komieg",
    "kw" to "kerneveureg",
    "kwk" to "kwakwaleg",
    "ky" to "kirgiz",
    "la" to "latin",
    "lad" to "ladino",
    "lag" to "langi",
    "lah" to "lahnda",
    "lam" to "lamba",
    "lb" to "luksembourgeg",
    "lez" to "lezgi",
    "lfn" to "lingua franca nova",
    "lg" to "ganda",
    "li" to "limbourgeg",
    "lij" to "ligurieg",
    "lil" to "lillooet",
    "lkt" to "lakota",
    "ln" to "lingala",
    "lo" to "laoseg",
    "lol" to "mongo",
    "lou" to "kreoleg Louiziana",
    "loz" to "lozi",
    "lrc" to "loureg an Norzh",
    "lt" to "lituaneg",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lui" to "luiseno",
    "lun" to "lunda",
    "luo" to "luo",
    "lus" to "lushai",
    "luy" to "luyia",
    "lv" to "latvieg",
    "lzh" to "sinaeg lennegel",
    "mad" to "madoureg",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makasar",
    "mas" to "masai",
    "mdf" to "moksha",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "moriseg",
    "mg" to "malgacheg",
    "mga" to "krenniwerzhoneg",
    "mgh" to "makhuwa-meetto",
    "mgo" to "metaʼ",
    "mh" to "marshall",
    "mi" to "maori",
    "mic" to "mikmakeg",
    "min" to "minangkabau",
    "mk" to "makedoneg",
    "ml" to "malayalam",
    "mn" to "mongoleg",
    "mnc" to "manchou",
    "mni" to "manipuri",
    "moe" to "montagneg",
    "moh" to "mohawk",
    "mos" to "more",
    "mr" to "marathi",
    "mrj" to "marieg ar Cʼhornôg",
    "ms" to "malayseg",
    "mt" to "malteg",
    "mua" to "moundangeg",
    "mul" to "yezhoù lies",
    "mus" to "muskogi",
    "mwl" to "mirandeg",
    "my" to "birmaneg",
    "myv" to "erza",
    "mzn" to "mazanderaneg",
    "na" to "naurueg",
    "nan" to "sinaeg Min Nan",
    "nap" to "napolitaneg",
    "naq" to "nama",
    "nb" to "norvegeg bokmål",
    "nd" to "ndebele an Norzh",
    "nds" to "alamaneg izel",
    "nds-NL" to "saksoneg izel",
    "ne" to "nepaleg",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niue",
    "njo" to "aoeg",
    "nl" to "nederlandeg",
    "nl-BE" to "flandrezeg",
    "nmg" to "ngoumbeg",
    "nn" to "norvegeg nynorsk",
    "nnh" to "ngiemboon",
    "no" to "norvegeg",
    "nog" to "nogay",
    "non" to "hennorseg",
    "nov" to "novial",
    "nqo" to "nkoeg",
    "nr" to "ndebele ar Su",
    "nso" to "sotho an Norzh",
    "nus" to "nouereg",
    "nv" to "navacʼho",
    "nwc" to "newari klasel",
    "ny" to "nyanja",
    "nym" to "nyamwezi",
    "nyn" to "nyankole",
    "nyo" to "nyoro",
    "oc" to "okitaneg",
    "oj" to "ojibweg",
    "ojb" to "ojibweg ar Gwalarn",
    "ojc" to "ojibweg ar cʼhreiz",
    "ojs" to "ojibweg Severn",
    "ojw" to "ojibweg ar Cʼhornôg",
    "oka" to "okanaganeg",
    "om" to "oromoeg",
    "or" to "oriya",
    "os" to "oseteg",
    "osa" to "osage",
    "ota" to "turkeg otoman",
    "pa" to "punjabi",
    "pag" to "pangasinan",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palau",
    "pcd" to "pikardeg",
    "pcm" to "pidjin Nigeria",
    "pdc" to "alamaneg Pennsylvania",
    "peo" to "henberseg",
    "phn" to "fenikianeg",
    "pi" to "pali",
    "pis" to "pidjin",
    "pl" to "poloneg",
    "pms" to "piemonteg",
    "pnt" to "ponteg",
    "pon" to "pohnpei",
    "pqm" to "malisiteg-pasamawkodieg",
    "prg" to "henbruseg",
    "pro" to "henbrovañseg",
    "ps" to "pachto",
    "pt" to "portugaleg",
    "pt-BR" to "portugaleg Brazil",
    "pt-PT" to "portugaleg Europa",
    "qu" to "kechuaeg",
    "quc" to "kʼicheʼ",
    "qug" to "kichuaeg Chimborazo",
    "raj" to "rajasthani",
    "rap" to "rapanui",
    "rar" to "rarotonga",
    "rgn" to "romagnoleg",
    "rhg" to "rohingya",
    "rm" to "romañcheg",
    "rn" to "rundi",
    "ro" to "roumaneg",
    "ro-MD" to "moldoveg",
    "rof" to "rombo",
    "rom" to "romanieg",
    "ru" to "rusianeg",
    "rup" to "aroumaneg",
    "rw" to "kinyarwanda",
    "rwk" to "rwa",
    "sa" to "sanskriteg",
    "sad" to "sandawe",
    "sah" to "yakouteg",
    "sam" to "arameeg ar Samaritaned",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "sba" to "ngambayeg",
    "sbp" to "sangu",
    "sc" to "sardeg",
    "scn" to "sikilieg",
    "sco" to "skoteg",
    "sd" to "sindhi",
    "sdc" to "sasareseg",
    "se" to "sámi an Norzh",
    "seh" to "sena",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sga" to "heniwerzhoneg",
    "sh" to "serb-kroateg",
    "shi" to "tacheliteg",
    "shn" to "shan",
    "shu" to "arabeg Tchad",
    "si" to "singhaleg",
    "sid" to "sidamo",
    "sk" to "slovakeg",
    "sl" to "sloveneg",
    "slh" to "luchoutsideg ar Su",
    "sm" to "samoan",
    "sma" to "sámi ar Su",
    "smj" to "sámi Luleå",
    "smn" to "sámi Inari",
    "sms" to "sámi Skolt",
    "sn" to "shona",
    "snk" to "soninke",
    "so" to "somali",
    "sog" to "sogdieg",
    "sq" to "albaneg",
    "sr" to "serbeg",
    "srn" to "sranan tongo",
    "srr" to "serer",
    "ss" to "swati",
    "ssy" to "sahoeg",
    "st" to "sotho ar Su",
    "su" to "sundaneg",
    "suk" to "sukuma",
    "sux" to "sumereg",
    "sv" to "svedeg",
    "sw" to "swahili",
    "sw-CD" to "swahili Kongo",
    "swb" to "komoreg",
    "syc" to "sirieg klasel",
    "syr" to "sirieg",
    "szl" to "silezieg",
    "ta" to "tamileg",
    "tce" to "tutchoneg ar Su",
    "tcy" to "touloueg",
    "te" to "telougou",
    "tem" to "temne",
    "teo" to "tesoeg",
    "ter" to "tereno",
    "tet" to "tetum",
    "tg" to "tadjik",
    "th" to "thai",
    "ti" to "tigrigna",
    "tig" to "tigreaneg",
    "tiv" to "tiv",
    "tk" to "turkmeneg",
    "tkl" to "tokelau",
    "tl" to "tagalog",
    "tlh" to "klingon",
    "tli" to "tinglit",
    "tmh" to "tamacheg",
    "tn" to "tswana",
    "to" to "tonga",
    "tog" to "nyasa tonga",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turkeg",
    "tru" to "turoyoeg",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsi" to "tsimshian",
    "tt" to "tatar",
    "ttm" to "tutchoneg an Norzh",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "twi",
    "twq" to "tasawakeg",
    "ty" to "tahitianeg",
    "tyv" to "touva",
    "tzm" to "tamazigteg Kreizatlas",
    "udm" to "oudmourteg",
    "ug" to "ouigoureg",
    "uga" to "ougariteg",
    "uk" to "ukraineg",
    "umb" to "umbundu",
    "und" to "yezh dianav",
    "ur" to "ourdou",
    "uz" to "ouzbekeg",
    "vai" to "vai",
    "ve" to "venda",
    "vec" to "venezieg",
    "vep" to "vepseg",
    "vi" to "vietnameg",
    "vls" to "flandrezeg ar c’hornôg",
    "vo" to "volapük",
    "vot" to "votyakeg",
    "vro" to "voroeg",
    "vun" to "vunjo",
    "wa" to "walloneg",
    "wae" to "walser",
    "wal" to "walamo",
    "war" to "waray",
    "was" to "washo",
    "wo" to "wolof",
    "wuu" to "sinaeg Wu",
    "xal" to "kalmouk",
    "xh" to "xhosa",
    "xmf" to "megreleg",
    "xog" to "sogaeg",
    "yao" to "yao",
    "yap" to "yapeg",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "yiddish",
    "yo" to "yorouba",
    "yrl" to "nengatoueg",
    "yue" to "kantoneg",
    "yue-alt-menu" to "sinaeg, kantoneg",
    "za" to "zhuang",
    "zap" to "zapoteg",
    "zbl" to "arouezioù Bliss",
    "zea" to "zelandeg",
    "zen" to "zenaga",
    "zgh" to "tamacheg Maroko standart",
    "zh" to "sinaeg",
    "zh-alt-menu" to "sinaeg, mandarineg",
    "zh-Hans" to "sinaeg eeunaet",
    "zh-Hans-alt-long" to "sinaeg mandarinek eeunaet",
    "zh-Hant" to "sinaeg hengounel",
    "zh-Hant-alt-long" to "sinaeg mandarinek hengounel",
    "zu" to "zouloueg",
    "zun" to "zuni",
    "zxx" to "diyezh",
    "zza" to "zazakeg",
  ) }

  val brx: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ab" to "आब्खाजियान",
    "ace" to "एचेनिज",
    "ach" to "अकोली",
    "ada" to "एडांगमे",
    "ady" to "अदिघे",
    "ae" to "अवस्तन्",
    "af" to "आफ्रिकान्स",
    "afh" to "अफ्रीहीली",
    "agq" to "आघेम",
    "ain" to "ऐनू",
    "ak" to "आकान",
    "akk" to "अकाडिनी",
    "ale" to "आलेउट",
    "alt" to "खोलायारि आल्टाई",
    "am" to "आम्हारिक",
    "an" to "आरागनिस",
    "ang" to "पुरानी अंग्रेज़ी",
    "ann" to "अबल’",
    "anp" to "आङिका",
    "ar" to "आराबिक",
    "ar-001" to "गोदान मानथाखोआरि आराबिक",
    "arc" to "अरामाईक",
    "arn" to "मापुचे",
    "arp" to "आरापाह’",
    "ars" to "नाजडी आराबिक",
    "arw" to "अरावाक",
    "as" to "असमिया",
    "asa" to "आसु",
    "ast" to "आस्तुरियान",
    "atj" to "आतिकामेको",
    "av" to "आभारिक",
    "awa" to "अवधी",
    "ay" to "आयमारा",
    "az" to "आजारबायजानि",
    "az-alt-short" to "आजेरि",
    "ba" to "बाशकिर",
    "bal" to "बलूची",
    "ban" to "बालिनिस",
    "bas" to "बासा",
    "be" to "बेलारुसियान",
    "bej" to "बेजा",
    "bem" to "बेम्बा",
    "bez" to "बेना",
    "bg" to "बुल्गारियान",
    "bho" to "भजपुरी",
    "bi" to "बिस्लामा",
    "bik" to "बिकोल्",
    "bin" to "बिनी",
    "bla" to "सीकसीका",
    "bm" to "बाम्बारा",
    "bn" to "बांला",
    "bo" to "तिब्बती",
    "br" to "ब्रेट’न",
    "bra" to "ब्रज",
    "brx" to "बर’",
    "bs" to "बस्नियान",
    "bua" to "बुरियात",
    "bug" to "बुगिनीज",
    "byn" to "ब्लीन",
    "ca" to "कातालान",
    "cad" to "काद्दौ",
    "car" to "कारीब्",
    "cay" to "कायुगा",
    "cch" to "आत्सम",
    "ccp" to "चाकमा",
    "ce" to "चेचेन",
    "ceb" to "चेबुआनो",
    "cgg" to "चीगा",
    "ch" to "चामोर्रो",
    "chb" to "चीबचा",
    "chg" to "चगताई",
    "chk" to "चुकेसे",
    "chm" to "मारि",
    "chn" to "चीनूक् जार्गन्",
    "cho" to "चक्टाऊ",
    "chp" to "चिपेव्यान",
    "chr" to "चेरकी",
    "chy" to "चेयेण",
    "ckb" to "मिरु कुर्दिस",
    "ckb-alt-menu" to "कुर्दिस, मिरु",
    "ckb-alt-variant" to "कुर्दिस, सरानि",
    "clc" to "चिल्कटिन",
    "co" to "कर्सिकान",
    "cop" to "कॉप्टीक्",
    "cr" to "क्री",
    "crg" to "मिचिफ",
    "crh" to "तुर्की क्रिमिया",
    "crj" to "खोलायारि सानजा क्री",
    "crk" to "हायेनारि क्री",
    "crl" to "साहायारि सानजा क्री",
    "crm" to "मूज क्री",
    "crr" to "केर’लिना एल्गंक्यान",
    "cs" to "चैक",
    "csb" to "काशुबियान्",
    "csw" to "स्वाम्पी क्री",
    "cu" to "चर्च स्लाविक्",
    "cv" to "चुभास",
    "cy" to "वैल्श",
    "da" to "डानिश",
    "dak" to "डाक’टा",
    "dar" to "दर्गवा",
    "dav" to "टाइटा",
    "de" to "जार्मान",
    "de-AT" to "अस्ट्रेयाआरि जार्मान",
    "de-CH" to "सुइस गोजौ जार्मान",
    "del" to "दलावार्",
    "den" to "स्लेव्",
    "dgr" to "डोगरीब",
    "din" to "डींगका",
    "dje" to "जार्मा",
    "doi" to "डोगरी",
    "dsb" to "गाहायसिन सर्बियान",
    "dua" to "डुआला",
    "dum" to "मध्य डच",
    "dv" to "दीवेही",
    "dyo" to "जला- फन्यी",
    "dyu" to "द्युआला",
    "dz" to "झंखा",
    "dzg" to "डाजागा",
    "ebu" to "इम्बु",
    "ee" to "एवे",
    "efi" to "एफिक",
    "egy" to "प्राचीन मिस्री",
    "eka" to "एकाजुक",
    "el" to "ग्रीक",
    "elx" to "एलामी",
    "en" to "इंराजी",
    "en-AU" to "अस्ट्रेलियानि इंराजी",
    "en-CA" to "कानाडानि इंराजी",
    "en-GB" to "ब्रिटिश इंराजी",
    "en-GB-alt-short" to "इउ.के इंराजी",
    "en-US" to "आमेरिकानि इंराजी",
    "en-US-alt-short" to "इउ.एस इंराजी",
    "enm" to "मध्य अंग्रेज़ी",
    "eo" to "एस्पेरान्त’",
    "es" to "स्पेनिश",
    "es-419" to "लेटीन आमेरिकानि स्पेनिश",
    "es-ES" to "युरोपनि स्पेनिश",
    "es-MX" to "मेक्सिक’नि स्पेनिश",
    "et" to "एस्ट’नियान",
    "eu" to "बास्क",
    "ewo" to "एव’न्द’",
    "fa" to "फार्सी",
    "fa-AF" to "डारी",
    "fan" to "फाँग्",
    "fat" to "फाँटी",
    "ff" to "फुलाह",
    "fi" to "फिन्निस",
    "fil" to "फिलिपिन’",
    "fj" to "फिजियान",
    "fo" to "फेर’वीज",
    "fon" to "फ’न",
    "fr" to "फ्रेन्च",
    "fr-CA" to "कानाडानि फ्रेन्च",
    "fr-CH" to "सुइस फ्रेन्च",
    "frc" to "काजुन फ्रेन्च",
    "frm" to "मध्य फ्रांसीसी",
    "fro" to "पुरानी फ्रांसीसी",
    "frr" to "उत्तरी फ्रीज़ियन्",
    "frs" to "पूर्वी फ्रीज़ियन्",
    "fur" to "फ्रिउलियान",
    "fy" to "सोनाबारि फ्रिजियान",
    "ga" to "आईरिश",
    "gaa" to "गा",
    "gay" to "गायो",
    "gba" to "ग्बाया",
    "gd" to "स्कटिस गैलिक",
    "gez" to "गीज",
    "gil" to "गील्बर्टिस",
    "gl" to "गेलिसियान",
    "gmh" to "मध्य उच्चस्तरी जर्मन",
    "gn" to "गुआरानी",
    "goh" to "पुरानी उच्चस्तरी जर्मन",
    "gon" to "गाँडी",
    "gor" to "गर’न्टाल’",
    "got" to "गॉथिक",
    "grb" to "ग्रेबो",
    "grc" to "प्राचीन यूनानी",
    "gsw" to "स्वीस जार्मान",
    "gu" to "गुजराती",
    "guz" to "गुशि",
    "gv" to "मेनक्स",
    "gwi" to "ग्वीचलीन",
    "ha" to "हाउसा",
    "hai" to "हाईडा",
    "haw" to "हावाईयान",
    "hax" to "खोलायारि हाईडा",
    "he" to "हिब्रिउ",
    "hi" to "हिन्दी",
    "hil" to "हिलीगैन’न",
    "hit" to "हीत्ती",
    "hmn" to "ह्मंग",
    "ho" to "हीरी मोटु",
    "hr" to "क्रवेशियान",
    "hsb" to "गोजौआरि सर्बियान",
    "ht" to "हाईटियान क्रिअल",
    "hu" to "हांगारियान",
    "hup" to "हूपा",
    "hur" to "हाल्क’मेलेम",
    "hy" to "आर्मेनियान",
    "hz" to "हेरेर’",
    "ia" to "ईन्टरलिंग्वा",
    "iba" to "ईबान",
    "ibb" to "ईबिबिय’",
    "id" to "ईण्डनेसियान",
    "ie" to "ईन्टरलिंग्वे",
    "ig" to "ईग्ब’",
    "ii" to "शीचुआन यी",
    "ik" to "इनुपियाक़्",
    "ikt" to "सोनाबारि कानाडियान इनुक्तितुत",
    "ilo" to "इल’क’",
    "inh" to "ईंगुष",
    "io" to "ईड’",
    "is" to "आइस्लेन्डिक",
    "it" to "इटालियान",
    "iu" to "इनुक्टीटुत",
    "ja" to "जापानीज",
    "jbo" to "ल’जबान",
    "jgo" to "न्गम्बा",
    "jmc" to "मेचामे",
    "jpr" to "यहुदी फ़ारसी",
    "jrb" to "यहुदी अरबी",
    "jv" to "जाभानीस",
    "ka" to "जर्जियान",
    "kaa" to "कारा कलपक",
    "kab" to "काबील",
    "kac" to "काचीन",
    "kaj" to "झु",
    "kam" to "काम्बा",
    "kaw" to "कावी",
    "kbd" to "काबार्डीयानि",
    "kcg" to "त्याप",
    "kde" to "माक’ण्डे",
    "kea" to "काबुभेर्डीयानु",
    "kfo" to "कर’",
    "kg" to "कॉंगो",
    "kgp" to "काईङां",
    "kha" to "खासि",
    "kho" to "ख़ोतानी",
    "khq" to "कईरा चीनि",
    "ki" to "किकुयु",
    "kj" to "कुआनयामा",
    "kk" to "काजाख",
    "kkj" to "काक’",
    "kl" to "कलालीसुत",
    "kln" to "कालेनजिन",
    "km" to "ख्मेर",
    "kmb" to "किम्बुन्डु",
    "kn" to "कन्नड",
    "ko" to "करियान",
    "kok" to "कोंकणी",
    "kos" to "कोस्राईयन्",
    "kpe" to "क्पेले",
    "kr" to "कनुरी",
    "krc" to "कराचय-बलकार",
    "krl" to "करेलियान",
    "kru" to "कुरुख",
    "ks" to "काश्मिरी",
    "ksb" to "शामबाला",
    "ksf" to "बाफिया",
    "ksh" to "कलगन्यान",
    "ku" to "कुर्दीश",
    "kum" to "कुमीक",
    "kut" to "कुतेनाई",
    "kv" to "क’मी",
    "kw" to "कर्निस",
    "kwk" to "क्वाकवाला",
    "ky" to "किरगीज",
    "la" to "लेटीन",
    "lad" to "लाडीन’",
    "lag" to "लाङि",
    "lah" to "लाह्डां",
    "lam" to "लांबा",
    "lb" to "लाक्जेमबुर्गीश",
    "lez" to "लेजघीयान",
    "lg" to "गान्डा",
    "li" to "लीम्बुर्गिस",
    "lil" to "लिल्लुवेत",
    "lkt" to "लाक’ता",
    "ln" to "लिंगाला",
    "lo" to "लाऊ",
    "lol" to "मोंगो",
    "lou" to "लुईसियाना क्रेवल",
    "loz" to "ल’जी",
    "lrc" to "साहायारि लुरी",
    "lsm" to "सामीया",
    "lt" to "लिथुवानियान",
    "lu" to "लुबा-काटाङा",
    "lua" to "लुबा लुलुआ",
    "lui" to "लुईसेनो",
    "lun" to "लुण्डा",
    "luo" to "लुअ’",
    "lus" to "लुशाई",
    "luy" to "लुईया",
    "lv" to "लाटभियान",
    "mad" to "मादुरीज",
    "mag" to "मगाही",
    "mai" to "मैथीली",
    "mak" to "माकासार",
    "man" to "मांडींगो",
    "mas" to "मासाई",
    "mdf" to "मोक्षा",
    "mdr" to "मंदार",
    "men" to "मेन्दे",
    "mer" to "मेरु",
    "mfe" to "मरिछ्येन",
    "mg" to "मालागासी",
    "mga" to "मध्य आईरीश भाषा",
    "mgh" to "माखुवा- मीट्ट’",
    "mgo" to "मेता",
    "mh" to "मार्शेलिस",
    "mi" to "माऔरि",
    "mic" to "मिईकमाक",
    "min" to "मिनांकाबाऊ",
    "mk" to "मेसेड’नियान",
    "ml" to "मालायालम",
    "mn" to "मंगलियान",
    "mnc" to "मांचु",
    "mni" to "मनिपुरी",
    "moe" to "इन्नु-आइमुन",
    "moh" to "महाउक",
    "mos" to "मस्सी",
    "mr" to "माराथी",
    "ms" to "मलै",
    "mt" to "माल्टीज",
    "mua" to "मुन्दां",
    "mul" to "गोबां रावफोर",
    "mus" to "मुस्क’गी",
    "mwl" to "मिराण्डीज",
    "mwr" to "मारवाड़ी",
    "my" to "बार्मिस",
    "myv" to "एर्जीया",
    "mzn" to "माजान्देरानि",
    "na" to "नाऊरू",
    "nap" to "नियापलिटान",
    "naq" to "नामा",
    "nb" to "नरवैजियान बकमाल",
    "nd" to "साहा न्देबेले",
    "nds" to "गाहाय जार्मान",
    "ne" to "नेपाली",
    "new" to "नेवारी",
    "ng" to "न्डोंगा",
    "nia" to "नियास",
    "niu" to "नियुइआन",
    "nl" to "डात्च",
    "nl-BE" to "फ्लेमिस",
    "nmg" to "क्वासिअ’",
    "nn" to "नरवैजियान निनर्स्क",
    "nnh" to "न्गीएम्बून",
    "no" to "नरवैजियान",
    "nog" to "न’गाई",
    "non" to "पुरानी नॉर्स्",
    "nqo" to "नंक’",
    "nr" to "खोला न्देबेले",
    "nso" to "साहायारि सथ’",
    "nus" to "नूवेर",
    "nv" to "नावाहो",
    "nwc" to "पुरानी नेवारी",
    "ny" to "न्यान्जा",
    "nym" to "न्यामवेज़ी",
    "nyn" to "न्यानकोले",
    "nyo" to "न्यौरो",
    "nzi" to "न्ज़ीमा",
    "oc" to "अक्सितान",
    "oj" to "ओहीबवा",
    "ojb" to "साहा-सोनाबारि अजिब्वा",
    "ojc" to "मिरु अजिब्वा",
    "ojs" to "अजि क्री",
    "ojw" to "सोनाबारि अजिब्वा",
    "oka" to "अकानागान",
    "om" to "अरम’",
    "or" to "उरीया",
    "os" to "अस्सेटीक",
    "osa" to "ओसेज",
    "ota" to "तुर्की ओटोमान",
    "pa" to "पान्जाबी",
    "pag" to "पाङासिनान",
    "pal" to "पहलवी",
    "pam" to "पाम्पाङा",
    "pap" to "पापीआमेन्तो",
    "pau" to "पालाऊवान",
    "pcm" to "नाइजेरियान पिदजीन",
    "peo" to "पुरानी फ़ारसी",
    "phn" to "फीनीसी",
    "pi" to "पाली",
    "pis" to "पिजिन",
    "pl" to "पलिश",
    "pon" to "पोहनपी",
    "pqm" to "मालिसीत- पास्सामक्वद्दी",
    "pro" to "पुरानी प्रोवाँसाल",
    "ps" to "पाश्त’",
    "pt" to "पर्टुगिज",
    "pt-BR" to "ब्राजिलनि पर्टुगिज",
    "pt-PT" to "युरोपनि पर्टुगिज",
    "qu" to "क्वेचुआ",
    "raj" to "राजस्थानी",
    "rap" to "रापानुई",
    "rar" to "रार’टंगान",
    "rhg" to "रहिंगीया",
    "rm" to "रमान्श",
    "rn" to "रुन्दी",
    "ro" to "रमानीयान",
    "ro-MD" to "मोल्डेवियन्",
    "rof" to "रम्ब’",
    "rom" to "रुमानी",
    "ru" to "रासियान",
    "rup" to "आरोमानियान",
    "rw" to "किन्यार्वान्दा",
    "rwk" to "र्वा",
    "sa" to "संस्कृत",
    "sad" to "साण्डावे",
    "sah" to "साखा",
    "sam" to "समारीती आरामाईक़",
    "saq" to "साम्बुरू",
    "sas" to "सासक",
    "sat" to "सान्थाली",
    "sba" to "न्गाम्बै",
    "sbp" to "साङु",
    "sc" to "सार्दीनीयान",
    "scn" to "सिसिलियान",
    "sco" to "स्क’टस",
    "sd" to "सिन्धी",
    "se" to "साहायारि सामी",
    "seh" to "सेना",
    "sel" to "सेलकुप",
    "ses" to "कईराबर’ सेन्नि",
    "sg" to "साङ’",
    "sga" to "पुरानी आईरीश",
    "sh" to "सर्बो-क्रोएशन्",
    "shi" to "ताचेल्हीट",
    "shn" to "शान",
    "si" to "सींहाला",
    "sid" to "सीदामो",
    "sk" to "स्ल’भाक",
    "sl" to "स्लोभेनियान",
    "slh" to "खोलायारि लाशुतसीद",
    "sm" to "साम’वान",
    "sma" to "पश्चीमी सामी",
    "smj" to "लुले सामी",
    "smn" to "ईनारी सामी",
    "sms" to "स्कल्ट सामी",
    "sn" to "शना",
    "snk" to "स’निन्के",
    "so" to "स’माली",
    "sog" to "सोगडीयन",
    "sq" to "आल्बानियान",
    "sr" to "सार्बियान",
    "srn" to "स्रानान टंग’",
    "srr" to "सेरेर",
    "ss" to "स्वाटि",
    "st" to "खोलायारि सथ’",
    "str" to "स्ट्रैत्स सालिश",
    "su" to "सुन्दानी",
    "suk" to "सुकुमा",
    "sus" to "सुसु",
    "sux" to "सुमेरिअन",
    "sv" to "स्वीडिश",
    "sw" to "स्वाहिली",
    "swb" to "कमरियान",
    "syc" to "पारंपरीक सिरिआक",
    "syr" to "सिरिआक",
    "ta" to "तामिल",
    "tce" to "खोलायारि तात्चने",
    "te" to "तेलुगु",
    "tem" to "तीमने",
    "teo" to "तेस’",
    "ter" to "तेरेनो",
    "tet" to "तेतुम",
    "tg" to "ताजिक",
    "tgx" to "तागीश",
    "th" to "थाई",
    "tht" to "टाहल्टान",
    "ti" to "तिग्रीन्या",
    "tig" to "टीग्रे",
    "tiv" to "टीव्",
    "tk" to "तुर्कमेन",
    "tkl" to "टोकेलौ",
    "tl" to "तागालोग",
    "tlh" to "क्लिङ’न",
    "tli" to "त्लिङीत",
    "tmh" to "तमाशेक",
    "tn" to "त्स्वाना",
    "to" to "टंगान",
    "tog" to "न्यासा टॉंगा",
    "tok" to "टकि पना",
    "tpi" to "ट’क पिसीन",
    "tr" to "तुर्कीस",
    "trv" to "तार’क’",
    "ts" to "त्संगा",
    "tsi" to "त्सीमशीआन्",
    "tt" to "टाटार",
    "ttm" to "साहायारि तात्च’ने",
    "tum" to "तुम्बुका",
    "tvl" to "टुभालु",
    "tw" to "ट्वी",
    "twq" to "तेसावाक",
    "ty" to "टाहीटियान",
    "tyv" to "तुभिनियान",
    "tzm" to "सेन्ट्रेल आटलास तामाजाईट",
    "udm" to "उडमुर्त",
    "ug" to "उईघुर",
    "uga" to "उगारिती",
    "uk" to "युक्रेनियान",
    "umb" to "उम्बुन्डु",
    "und" to "मिथियै राव",
    "ur" to "ऊर्दु",
    "uz" to "उजबेक",
    "vai" to "भाई",
    "ve" to "भेन्डा",
    "vi" to "भियेतनामिस",
    "vo" to "वोलापोक",
    "vot" to "वोटीक",
    "vun" to "भुन्ज’",
    "wa" to "वाल्लुन",
    "wae" to "वाल्सार",
    "wal" to "वलाईत्ता",
    "war" to "वारै",
    "was" to "वाशो",
    "wo" to "वल’फ",
    "wuu" to "वु चाइनीज",
    "xal" to "कालमीक",
    "xh" to "ख’सा",
    "xog" to "स’गा",
    "yao" to "याओ",
    "yap" to "यापीज़",
    "yav" to "यांबेन",
    "ybb" to "येम्बा",
    "yi" to "यीद्दीश",
    "yo" to "यरूबा",
    "yrl" to "न्हीगातू",
    "yue" to "केन्टनिज",
    "yue-alt-menu" to "चाईनिज, केन्टनिज",
    "za" to "ज़ुआंग",
    "zap" to "ज़ापोतेक",
    "zbl" to "ब्लीस चिन्ह",
    "zen" to "ज़ेनागा",
    "zgh" to "स्टेन्दार्द मरक्कान तामाजाईट",
    "zh" to "चाइनीज",
    "zh-alt-menu" to "चाइनीज, मेण्डारिन",
    "zh-Hans" to "गोरलै खालामनाय चाइनीज",
    "zh-Hans-alt-long" to "गोरलै खालामनाय मेण्डारिन चाइनीज",
    "zh-Hant" to "आसार-खान्थियारि चाइनीज",
    "zh-Hant-alt-long" to "आसार-खान्थियारि चाइनीज",
    "zu" to "जुलू",
    "zun" to "जुनी",
    "zxx" to "रावआरि आयदाफोर जेबो गैया",
    "zza" to "जाजा",
  ) }

  val bs: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afarski",
    "ab" to "abhaski",
    "ace" to "ačinski",
    "ach" to "akoli",
    "ada" to "adangmejski",
    "ady" to "adigejski",
    "ae" to "avestanski",
    "af" to "afrikans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "akan",
    "akk" to "akadijski",
    "ale" to "aleutski",
    "alt" to "južni altai",
    "am" to "amharski",
    "an" to "aragonski",
    "ang" to "staroengleski",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "arapski",
    "ar-001" to "moderni standardni arapski",
    "arc" to "aramejski",
    "arn" to "mapuški",
    "arp" to "arapaho",
    "ars" to "najdski arapski",
    "arw" to "aravak",
    "as" to "asamski",
    "asa" to "asu",
    "ast" to "asturijski",
    "atj" to "atikamekw",
    "av" to "avarski",
    "awa" to "avadhi",
    "ay" to "ajmara",
    "az" to "azerbejdžanski",
    "az-alt-short" to "azerski",
    "ba" to "baškirski",
    "bal" to "baluči",
    "ban" to "balinezijski",
    "bas" to "basa",
    "bax" to "bamunski",
    "bbj" to "gomala",
    "be" to "bjeloruski",
    "bej" to "beja",
    "bem" to "bemba",
    "bez" to "bena",
    "bfd" to "bafut",
    "bg" to "bugarski",
    "bgc" to "harianvi",
    "bgn" to "zapadni belučki",
    "bho" to "bojpuri",
    "bi" to "bislama",
    "bik" to "bikol",
    "bin" to "bini",
    "bkm" to "kom",
    "bla" to "siksika",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bengalski",
    "bo" to "tibetanski",
    "br" to "bretonski",
    "bra" to "braj",
    "brx" to "bodo",
    "bs" to "bosanski",
    "bss" to "akoski",
    "bua" to "buriat",
    "bug" to "bugiški",
    "bum" to "bulu",
    "byn" to "blin",
    "byv" to "medumba",
    "ca" to "katalonski",
    "cad" to "kado",
    "car" to "karipski",
    "cay" to "kajuga",
    "cch" to "atsam",
    "ccp" to "čakma",
    "ce" to "čečenski",
    "ceb" to "cebuano",
    "cgg" to "čiga",
    "ch" to "čamoro",
    "chb" to "čibča",
    "chg" to "čagatai",
    "chk" to "čukeski",
    "chm" to "mari",
    "chn" to "činukski žargon",
    "cho" to "čoktav",
    "chp" to "čipvijanski",
    "chr" to "čeroki",
    "chy" to "čejenski",
    "ckb" to "centralnokurdski",
    "ckb-alt-menu" to "centralnokurdski",
    "ckb-alt-variant" to "centralnokurdski",
    "clc" to "chilcotin",
    "co" to "korzikanski",
    "cop" to "koptski",
    "cr" to "kri",
    "crg" to "mičif",
    "crh" to "krimski turski",
    "crj" to "jugoistočni kri",
    "crk" to "ravničarski kri",
    "crl" to "sjeveroistočni kri",
    "crm" to "mus kri",
    "crr" to "sjevernokarolinški algonkvijski",
    "crs" to "seselva kreolski francuski",
    "cs" to "češki",
    "csb" to "kašubijanski",
    "csw" to "močvarni kri",
    "cu" to "staroslavenski",
    "cv" to "čuvaški",
    "cy" to "velški",
    "da" to "danski",
    "dak" to "dakota",
    "dar" to "dargva",
    "dav" to "taita",
    "de" to "njemački",
    "de-CH" to "visoki njemački (Švicarska)",
    "del" to "delaver",
    "den" to "slave",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "donjolužičkosrpski",
    "dua" to "duala",
    "dum" to "srednjovjekovni holandski",
    "dv" to "divehi",
    "dyo" to "jola-foni",
    "dyu" to "diula",
    "dz" to "džonga",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "eve",
    "efi" to "efik",
    "egy" to "staroegipatski",
    "eka" to "ekajuk",
    "el" to "grčki",
    "elx" to "elamitski",
    "en" to "engleski",
    "enm" to "srednjovjekovni engleski",
    "eo" to "esperanto",
    "es" to "španski",
    "et" to "estonski",
    "eu" to "baskijski",
    "ewo" to "evondo",
    "fa" to "perzijski",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fulah",
    "fi" to "finski",
    "fil" to "filipino",
    "fj" to "fidžijski",
    "fo" to "farski",
    "fon" to "fon",
    "fr" to "francuski",
    "frc" to "kajunski francuski",
    "frm" to "srednjovjekovni francuski",
    "fro" to "starofrancuski",
    "frr" to "sjeverni frizijski",
    "frs" to "istočnofrizijski",
    "fur" to "friulijski",
    "fy" to "zapadni frizijski",
    "ga" to "irski",
    "gaa" to "ga",
    "gag" to "gagauški",
    "gay" to "gajo",
    "gba" to "gbaja",
    "gd" to "škotski galski",
    "gez" to "staroetiopski",
    "gil" to "gilbertski",
    "gl" to "galicijski",
    "gmh" to "srednjovjekovni gornjonjemački",
    "gn" to "gvarani",
    "goh" to "staronjemački",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gotski",
    "grb" to "grebo",
    "grc" to "starogrčki",
    "gsw" to "njemački (Švicarska)",
    "gu" to "gudžarati",
    "guz" to "gusi",
    "gv" to "manks",
    "gwi" to "gvičin",
    "ha" to "hausa",
    "hai" to "haida",
    "haw" to "havajski",
    "hax" to "južni haida",
    "he" to "hebrejski",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hingleski",
    "hil" to "hiligajnon",
    "hit" to "hitite",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "hrvatski",
    "hsb" to "gornjolužičkosrpski",
    "ht" to "haićanski kreolski",
    "hu" to "mađarski",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armenski",
    "hz" to "herero",
    "ia" to "interlingva",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonezijski",
    "ie" to "interlingve",
    "ig" to "igbo",
    "ii" to "sičuan ji",
    "ik" to "inupiak",
    "ikt" to "zapadnokanadski inuktitut",
    "ilo" to "iloko",
    "inh" to "ingušetski",
    "io" to "ido",
    "is" to "islandski",
    "it" to "italijanski",
    "iu" to "inuktitut",
    "ja" to "japanski",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "makame",
    "jpr" to "judeo-perzijski",
    "jrb" to "judeo-arapski",
    "jv" to "javanski",
    "ka" to "gruzijski",
    "kaa" to "kara-kalpak",
    "kab" to "kabile",
    "kac" to "kačin",
    "kaj" to "kaju",
    "kam" to "kamba",
    "kaw" to "kavi",
    "kbd" to "kabardijski",
    "kbl" to "kanembu",
    "kcg" to "tjap",
    "kde" to "makonde",
    "kea" to "zelenortski",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "kaingang",
    "kha" to "kasi",
    "kho" to "kotanizijski",
    "khq" to "kojra čini",
    "ki" to "kikuju",
    "kj" to "kuanjama",
    "kk" to "kazaški",
    "kkj" to "kako",
    "kl" to "kalalisutski",
    "kln" to "kalenjin",
    "km" to "kmerski",
    "kmb" to "kimbundu",
    "kn" to "kanada",
    "ko" to "korejski",
    "koi" to "komi-permski",
    "kok" to "konkani",
    "kos" to "kosrejski",
    "kpe" to "kpele",
    "kr" to "kanuri",
    "krc" to "karačaj-balkar",
    "kri" to "krio",
    "krl" to "karelijski",
    "kru" to "kuruški",
    "ks" to "kašmirski",
    "ksb" to "šambala",
    "ksf" to "bafia",
    "ksh" to "kelnski",
    "ku" to "kurdski",
    "kum" to "kumik",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "kornski",
    "kwk" to "kvakvala",
    "kxv" to "kuvi",
    "ky" to "kirgiški",
    "la" to "latinski",
    "lad" to "ladino",
    "lag" to "langi",
    "lah" to "landa",
    "lam" to "lamba",
    "lb" to "luksemburški",
    "lez" to "lezgijski",
    "lg" to "ganda",
    "li" to "limburški",
    "lij" to "ligurski",
    "lil" to "liluet",
    "lkt" to "lakota",
    "lmo" to "lombardski",
    "ln" to "lingala",
    "lo" to "laoski",
    "lol" to "mongo",
    "lou" to "luizijanski kreolski",
    "loz" to "lozi",
    "lrc" to "sjeverni luri",
    "lsm" to "samia",
    "lt" to "litvanski",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lui" to "luiseno",
    "lun" to "lunda",
    "lus" to "mizo",
    "luy" to "luhija",
    "lv" to "latvijski",
    "mad" to "madureški",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maitili",
    "mak" to "makasar",
    "man" to "mandingo",
    "mas" to "masai",
    "mde" to "maba",
    "mdf" to "mokša",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "mauricijski kreolski",
    "mg" to "malgaški",
    "mga" to "srednjovjekovni irski",
    "mgh" to "makuva-meto",
    "mgo" to "meta",
    "mh" to "maršalski",
    "mi" to "maorski",
    "mic" to "mikmak",
    "min" to "minangkabau",
    "mk" to "makedonski",
    "ml" to "malajalam",
    "mn" to "mongolski",
    "mnc" to "manču",
    "mni" to "manipuri",
    "moe" to "innu-aimun",
    "moh" to "mohavk",
    "mos" to "mosi",
    "mr" to "marati",
    "ms" to "malajski",
    "mt" to "malteški",
    "mua" to "mundang",
    "mul" to "više jezika",
    "mus" to "kriški",
    "mwl" to "mirandeški",
    "mwr" to "marvari",
    "my" to "burmanski",
    "mye" to "mjene",
    "myv" to "erzija",
    "mzn" to "mazanderanski",
    "na" to "nauru",
    "nap" to "napolitanski",
    "naq" to "nama",
    "nb" to "norveški (Bokmal)",
    "nd" to "sjeverni ndebele",
    "nds" to "donjonjemački",
    "nds-NL" to "donjosaksonski",
    "ne" to "nepalski",
    "new" to "nevari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niue",
    "nl" to "nizozemski",
    "nl-BE" to "flamanski",
    "nmg" to "kvasio",
    "nn" to "norveški (Nynorsk)",
    "nnh" to "ngiembon",
    "no" to "norveški",
    "nog" to "nogai",
    "non" to "staronordijski",
    "nqo" to "nko",
    "nr" to "južni ndebele",
    "nso" to "sjeverni soto",
    "nus" to "nuer",
    "nv" to "navaho",
    "nwc" to "klasični nevari",
    "ny" to "njanja",
    "nym" to "njamvezi",
    "nyn" to "njankole",
    "nyo" to "njoro",
    "nzi" to "nzima",
    "oc" to "oksitanski",
    "oj" to "ojibva",
    "ojb" to "sjeverozapadni ojibva",
    "ojc" to "centralni ojibva",
    "ojs" to "odži kri",
    "ojw" to "zapadni ojibva",
    "oka" to "okanagan",
    "om" to "oromo",
    "or" to "odija",
    "os" to "osetski",
    "osa" to "osage",
    "ota" to "osmanski turski",
    "pa" to "pandžapski",
    "pag" to "pangasinski",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palauanski",
    "pcm" to "nigerijski pidžin",
    "peo" to "staroperzijski",
    "phn" to "feničanski",
    "pi" to "pali",
    "pis" to "pidžin",
    "pl" to "poljski",
    "pon" to "ponpejski",
    "pqm" to "malisit-pasamakvodi",
    "prg" to "pruski",
    "pro" to "staroprovansalski",
    "ps" to "paštu",
    "ps-alt-variant" to "pušto",
    "pt" to "portugalski",
    "qu" to "kečua",
    "quc" to "kiče",
    "raj" to "rajastani",
    "rap" to "rapanui",
    "rar" to "rarotongan",
    "rhg" to "rohindža",
    "rm" to "retoromanski",
    "rn" to "rundi",
    "ro" to "rumunski",
    "ro-MD" to "moldavski",
    "rof" to "rombo",
    "rom" to "romani",
    "ru" to "ruski",
    "rup" to "arumunski",
    "rw" to "kinjaruanda",
    "rwk" to "rua",
    "sa" to "sanskrit",
    "sad" to "sandave",
    "sah" to "jakutski",
    "sam" to "samaritanski aramejski",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "sba" to "ngambaj",
    "sbp" to "sangu",
    "sc" to "sardinijski",
    "scn" to "sicilijanski",
    "sco" to "škotski",
    "sd" to "sindi",
    "sdh" to "južni kurdski",
    "se" to "sjeverni sami",
    "see" to "seneka",
    "seh" to "sena",
    "sel" to "selkup",
    "ses" to "kojraboro seni",
    "sg" to "sango",
    "sga" to "staroirski",
    "sh" to "srpskohrvatski",
    "shi" to "tahelhit",
    "shn" to "šan",
    "shu" to "čadski arapski",
    "si" to "sinhaleški",
    "sid" to "sidamo",
    "sk" to "slovački",
    "sl" to "slovenski",
    "slh" to "južni lašutsid",
    "sm" to "samoanski",
    "sma" to "južni sami",
    "smj" to "lule sami",
    "smn" to "inari sami",
    "sms" to "skolt sami",
    "sn" to "šona",
    "snk" to "soninke",
    "so" to "somalski",
    "sog" to "sogdien",
    "sq" to "albanski",
    "sr" to "srpski",
    "srn" to "srananski tongo",
    "srr" to "serer",
    "ss" to "svati",
    "ssy" to "saho",
    "st" to "južni soto",
    "str" to "ravničarski sališki",
    "su" to "sundanski",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumerski",
    "sv" to "švedski",
    "sw" to "svahili",
    "swb" to "komorski",
    "syc" to "klasični sirijski",
    "syr" to "sirijski",
    "szl" to "šleski",
    "ta" to "tamilski",
    "tce" to "južni tučoni",
    "te" to "telugu",
    "tem" to "timne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetum",
    "tg" to "tadžički",
    "tgx" to "tagiš",
    "th" to "tajlandski",
    "tht" to "tahltanski",
    "ti" to "tigrinja",
    "tig" to "tigre",
    "tiv" to "tiv",
    "tk" to "turkmenski",
    "tkl" to "tokelau",
    "tl" to "tagalog",
    "tlh" to "klingonski",
    "tli" to "tlingit",
    "tmh" to "tamašek",
    "tn" to "tsvana",
    "to" to "tonganski",
    "tog" to "njasa tonga",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turski",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsi" to "tsimšian",
    "tt" to "tatarski",
    "ttm" to "sjeverni tučoni",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "tvi",
    "twq" to "tasavak",
    "ty" to "tahićanski",
    "tyv" to "tuvinijski",
    "tzm" to "centralnoatlaski tamazigt",
    "udm" to "udmurt",
    "ug" to "ujgurski",
    "uga" to "ugaritski",
    "uk" to "ukrajinski",
    "umb" to "umbundu",
    "und" to "nepoznati jezik",
    "ur" to "urdu",
    "uz" to "uzbečki",
    "ve" to "venda",
    "vec" to "venecijanski",
    "vi" to "vijetnamski",
    "vmw" to "makua",
    "vo" to "volapuk",
    "vot" to "votski",
    "vun" to "vunjo",
    "wa" to "valun",
    "wae" to "valser",
    "wal" to "valamo",
    "war" to "varej",
    "was" to "vašo",
    "wbp" to "varlpiri",
    "wo" to "volof",
    "wuu" to "Wu kineski",
    "xal" to "kalmik",
    "xh" to "hosa",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "jao",
    "yap" to "japeški",
    "yav" to "jangben",
    "ybb" to "jemba",
    "yi" to "jidiš",
    "yo" to "jorubanski",
    "yrl" to "ningatu",
    "yue" to "kantonski",
    "yue-alt-menu" to "kineski, kantonski",
    "za" to "zuang",
    "zap" to "zapotečki",
    "zbl" to "blis simboli",
    "zen" to "zenaga",
    "zgh" to "standardni marokanski tamazigt",
    "zh" to "kineski",
    "zh-alt-menu" to "kineski (standardni)",
    "zh-Hans" to "kineski (pojednostavljeni)",
    "zh-Hans-alt-long" to "kineski (pojednostavljeni standardni)",
    "zh-Hant" to "kineski (tradicionalni)",
    "zh-Hant-alt-long" to "kineski (tradicionalni standardni)",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "bez lingvističkog sadržaja",
    "zza" to "zaza",
  ) }

  val bs_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "афарски",
    "ab" to "абказијски",
    "ace" to "ачинески",
    "ach" to "аколи",
    "ada" to "адангмејски",
    "ady" to "адигејски",
    "ae" to "авестански",
    "af" to "африканс",
    "afh" to "африхили",
    "agq" to "ахемски",
    "ain" to "аину",
    "ak" to "акан",
    "akk" to "акадијски",
    "ale" to "аљут",
    "alt" to "јужни алтаи",
    "am" to "амхарски",
    "an" to "арагонежански",
    "ang" to "староенглески",
    "ann" to "оболо",
    "anp" to "ангика",
    "ar" to "арапски",
    "ar-001" to "арапски (стандардни)",
    "arc" to "армајски",
    "arn" to "ароканијски",
    "arp" to "арапахо",
    "ars" to "најди арапски",
    "arw" to "аравак",
    "as" to "асемијски",
    "asa" to "асу",
    "ast" to "астуријски",
    "atj" to "атикамекв",
    "av" to "аварски",
    "awa" to "авадхи",
    "ay" to "ајмара",
    "az" to "азербејџански",
    "az-alt-short" to "азерски",
    "ba" to "башкир",
    "bal" to "балучи",
    "ban" to "балинезијски",
    "bas" to "баса",
    "be" to "бјелоруски",
    "bej" to "беја",
    "bem" to "бемба",
    "bez" to "бена",
    "bg" to "бугарски",
    "bho" to "бојпури",
    "bi" to "бислама",
    "bik" to "бикол",
    "bin" to "бини",
    "bla" to "сисика",
    "bm" to "бамбара",
    "bn" to "бенгалски",
    "bo" to "тибетански",
    "br" to "бретонски",
    "bra" to "брај",
    "brx" to "бодо",
    "bs" to "босански",
    "bua" to "буриат",
    "bug" to "бугинежански",
    "byn" to "блин",
    "ca" to "каталонски",
    "cad" to "кадо",
    "car" to "карипски",
    "cay" to "Кајуга",
    "cch" to "атсамски",
    "ccp" to "чакма",
    "ce" to "чеченски",
    "ceb" to "цебуано",
    "cgg" to "чига",
    "ch" to "чаморо",
    "chb" to "чибча",
    "chg" to "чагатаи",
    "chk" to "чукески",
    "chm" to "мари",
    "chn" to "чинукски",
    "cho" to "чоктавски",
    "chp" to "чипвијански",
    "chr" to "чероки",
    "chy" to "чејенски",
    "ckb" to "централнокурдски",
    "ckb-alt-menu" to "централнокурдски",
    "ckb-alt-variant" to "централнокурдски",
    "clc" to "Чилкотин",
    "co" to "корзикански",
    "cop" to "коптски",
    "cr" to "кри",
    "crg" to "мичиф",
    "crh" to "кримеански турски",
    "crj" to "јужноисточни кре",
    "crk" to "равничарски кре",
    "crl" to "сјеверно источни кре",
    "crm" to "мосе кре",
    "crr" to "алгонкуански за Каролину",
    "cs" to "чешки",
    "csb" to "кашубијански",
    "csw" to "свампи кре",
    "cu" to "старославенски",
    "cv" to "чувашки",
    "cy" to "велшки",
    "da" to "дански",
    "dak" to "дакота",
    "dar" to "даргва",
    "dav" to "таита",
    "de" to "њемачки",
    "de-CH" to "високи њемачки (Швицарска)",
    "del" to "делавер",
    "den" to "славски",
    "dgr" to "догриб",
    "din" to "динка",
    "dje" to "зарма",
    "doi" to "догри",
    "dsb" to "доњолужичкосрпски",
    "dua" to "дуала",
    "dum" to "средњи холандски",
    "dv" to "дивехијски",
    "dyo" to "јола-фоњи",
    "dyu" to "ђула",
    "dz" to "џонга",
    "dzg" to "дазага",
    "ebu" to "ембу",
    "ee" to "еве",
    "efi" to "ефикски",
    "egy" to "староегипатски",
    "eka" to "екајук",
    "el" to "грчки",
    "elx" to "еламитски",
    "en" to "енглески",
    "enm" to "средњи енглески",
    "eo" to "есперанто",
    "es" to "шпански",
    "et" to "естонски",
    "eu" to "баскијски",
    "ewo" to "евондо",
    "fa" to "персијски",
    "fan" to "фанг",
    "fat" to "фанти",
    "ff" to "фулах",
    "fi" to "фински",
    "fil" to "филипински",
    "fj" to "фиджијски",
    "fo" to "фарски",
    "fon" to "фон",
    "fr" to "француски",
    "frc" to "кајунски француски",
    "frm" to "средњи француски",
    "fro" to "старофранцуски",
    "frr" to "северно-фризијски",
    "frs" to "источни фризијски",
    "fur" to "фриулијски",
    "fy" to "западни фризијски",
    "ga" to "ирски",
    "gaa" to "га",
    "gay" to "гајо",
    "gba" to "гбаја",
    "gd" to "шкотски галски",
    "gez" to "џиз",
    "gil" to "гилбертшки",
    "gl" to "галски",
    "gmh" to "средњи високи немачки",
    "gn" to "гварани",
    "goh" to "старонемачки",
    "gon" to "гонди",
    "gor" to "горонтало",
    "got" to "готски",
    "grb" to "гребо",
    "grc" to "старогрчки",
    "gsw" to "њемачки (Швицарска)",
    "gu" to "гуџарати",
    "guz" to "гуси",
    "gv" to "манкс",
    "gwi" to "гвич’ин",
    "ha" to "хауса",
    "hai" to "хаида",
    "haw" to "хавајски",
    "hax" to "јужни хаида",
    "he" to "хебрејски",
    "hi" to "хинди",
    "hil" to "хилигајнон",
    "hit" to "хитите",
    "hmn" to "хмонг",
    "ho" to "хири моту",
    "hr" to "хрватски",
    "hsb" to "горњолужичкосрпски",
    "ht" to "хаићански креолски",
    "hu" to "мађарски",
    "hup" to "хупа",
    "hur" to "халкомелем",
    "hy" to "јерменски",
    "hz" to "хереро",
    "ia" to "интерлингва",
    "iba" to "ибан",
    "ibb" to "ибибио",
    "id" to "индонежански",
    "ie" to "међујезички",
    "ig" to "игбо",
    "ii" to "сечуан ји",
    "ik" to "унупиак",
    "ikt" to "западно канадски инуктитут",
    "ilo" to "илоко",
    "inh" to "ингвишки",
    "io" to "идо",
    "is" to "исландски",
    "it" to "италијански",
    "iu" to "инуктитут",
    "ja" to "јапански",
    "jbo" to "лојбан",
    "jgo" to "нгомба",
    "jmc" to "мачаме",
    "jpr" to "јудео-персијски",
    "jrb" to "јудео-арапски",
    "jv" to "јавански",
    "ka" to "грузијски",
    "kaa" to "кара-калпашки",
    "kab" to "кабиле",
    "kac" to "качин",
    "kaj" to "ђу",
    "kam" to "камба",
    "kaw" to "кави",
    "kbd" to "кабардијски",
    "kcg" to "тјап",
    "kde" to "маконде",
    "kea" to "кабовердијански креолски",
    "kfo" to "коро",
    "kg" to "конго",
    "kgp" to "каинганг",
    "kha" to "каси",
    "kho" to "котанешки",
    "khq" to "којра чини",
    "ki" to "кикују",
    "kj" to "куањама",
    "kk" to "казашки",
    "kkj" to "како",
    "kl" to "калалисут",
    "kln" to "калењин",
    "km" to "кмерски",
    "kmb" to "кимбунду",
    "kn" to "канада",
    "ko" to "корејски",
    "kok" to "конкани",
    "kos" to "косреански",
    "kpe" to "кпеле",
    "kr" to "канури",
    "krc" to "карачај-балкар",
    "krl" to "карелијски",
    "kru" to "курукх",
    "ks" to "кашмирски",
    "ksb" to "шамбала",
    "ksf" to "бафија",
    "ksh" to "келнски",
    "ku" to "курдски",
    "kum" to "кумик",
    "kut" to "кутенаи",
    "kv" to "коми",
    "kw" to "корнишки",
    "kwk" to "кваквала",
    "ky" to "киргиски",
    "la" to "латински",
    "lad" to "ладино",
    "lag" to "ланги",
    "lah" to "ланда",
    "lam" to "ламба",
    "lb" to "луксембуршки",
    "lez" to "лезгиан",
    "lg" to "ганда",
    "li" to "лимбургиш",
    "lij" to "линуриан",
    "lil" to "лилоет",
    "lkt" to "лакота",
    "ln" to "лингала",
    "lo" to "лаоски",
    "lol" to "монго",
    "lou" to "луизиански креолски",
    "loz" to "лози",
    "lrc" to "сјеверни лури",
    "lsm" to "самиа",
    "lt" to "литвански",
    "lu" to "луба-катанга",
    "lua" to "луба-лулуа",
    "lui" to "луисено",
    "lun" to "лунда",
    "luo" to "луо",
    "lus" to "лушаи",
    "luy" to "луја",
    "lv" to "латвијски",
    "mad" to "мадурешки",
    "mag" to "магахи",
    "mai" to "маитили",
    "mak" to "макасар",
    "man" to "мандинго",
    "mas" to "масаи",
    "mdf" to "мокша",
    "mdr" to "мандар",
    "men" to "менде",
    "mer" to "меру",
    "mfe" to "мауритански",
    "mg" to "малагасијски",
    "mga" to "средњи ирски",
    "mgh" to "макуа-мето",
    "mgo" to "мета",
    "mh" to "маршалски",
    "mi" to "маорски",
    "mic" to "микмак",
    "min" to "минангкабау",
    "mk" to "македонски",
    "ml" to "малајалам",
    "mn" to "монголски",
    "mnc" to "манчу",
    "mni" to "манипури",
    "moe" to "иму-аимун",
    "moh" to "махавски",
    "mos" to "моси",
    "mr" to "марати",
    "ms" to "малајски",
    "mt" to "малтешки",
    "mua" to "мунданг",
    "mul" to "више језика",
    "mus" to "кришки",
    "mwl" to "мирандешки",
    "mwr" to "марвари",
    "my" to "бурмански",
    "myv" to "ерзија",
    "mzn" to "мазандерани",
    "na" to "науру",
    "nap" to "неаполитански",
    "naq" to "нама",
    "nb" to "норвешки бокмал",
    "nd" to "сјеверни ндебеле",
    "nds" to "ниски њемачки",
    "ne" to "непалски",
    "new" to "невари",
    "ng" to "ндонга",
    "nia" to "ниас",
    "niu" to "ниуеан",
    "nl" to "холандски",
    "nl-BE" to "фламански",
    "nmg" to "квасио",
    "nn" to "норвешки нинорск",
    "nnh" to "нгиембун",
    "no" to "норвешки",
    "nog" to "ногаи",
    "non" to "стари норски",
    "nqo" to "н’ко",
    "nr" to "јужни ндебеле",
    "nso" to "сјеверни сото",
    "nus" to "нуер",
    "nv" to "навахо",
    "nwc" to "класични невари",
    "ny" to "њања",
    "nym" to "њамвези",
    "nyn" to "њанколе",
    "nyo" to "њоро",
    "nzi" to "нзима",
    "oc" to "провансалски",
    "oj" to "ојибва",
    "ojb" to "сјеверозападни ојибва",
    "ojc" to "Централни обијва",
    "ojs" to "оји-кре",
    "ojw" to "западни ојибва",
    "oka" to "оканаган",
    "om" to "оромо",
    "or" to "одија",
    "os" to "осетски",
    "osa" to "осаге",
    "ota" to "отомански турски",
    "pa" to "пенџапски",
    "pag" to "пангасински",
    "pal" to "пахлави",
    "pam" to "пампанга",
    "pap" to "папиаменто",
    "pau" to "палауански",
    "pcm" to "нигеријски пидгин",
    "peo" to "староперсијски",
    "phn" to "феничански",
    "pi" to "пали",
    "pis" to "пијин",
    "pl" to "пољски",
    "pon" to "понпејски",
    "pqm" to "малисет-шасамкуоди",
    "prg" to "пруски",
    "pro" to "старопровансалски",
    "ps" to "паштунски",
    "ps-alt-variant" to "пашто",
    "pt" to "португалски",
    "qu" to "квенча",
    "raj" to "рађастани",
    "rap" to "рапануи",
    "rar" to "раротонган",
    "rhg" to "рохимгја",
    "rm" to "рето-романски",
    "rn" to "рунди",
    "ro" to "румунски",
    "ro-MD" to "молдавски",
    "rof" to "ромбо",
    "rom" to "романи",
    "ru" to "руски",
    "rup" to "ароманијски",
    "rw" to "кинјаруанда",
    "rwk" to "рва",
    "sa" to "санскрит",
    "sad" to "сандаве",
    "sah" to "јакутски",
    "sam" to "самаритански арамејски",
    "saq" to "самбуру",
    "sas" to "сасак",
    "sat" to "сантали",
    "sba" to "нгамбеј",
    "sbp" to "сангу",
    "sc" to "сардињаски",
    "scn" to "сицилијански",
    "sco" to "шкотски",
    "sd" to "синди",
    "se" to "сјеверни сами",
    "seh" to "сена",
    "sel" to "селкап",
    "ses" to "којраборо сени",
    "sg" to "санго",
    "sga" to "староирски",
    "sh" to "српскохрватски",
    "shi" to "ташелхит",
    "shn" to "шан",
    "si" to "синхалски",
    "sid" to "сидамо",
    "sk" to "словачки",
    "sl" to "словенски",
    "slh" to "јужни лушотсед",
    "sm" to "самоански",
    "sma" to "јужни сами",
    "smj" to "луле сами",
    "smn" to "инари сами",
    "sms" to "сколтски језик",
    "sn" to "шона",
    "snk" to "сонинке",
    "so" to "сомалски",
    "sog" to "соџијенски",
    "sq" to "албански",
    "sr" to "српски",
    "srn" to "сранански тонго",
    "srr" to "серер",
    "ss" to "свати",
    "st" to "сесото",
    "str" to "страитс салиш",
    "su" to "сундански",
    "suk" to "сукума",
    "sus" to "сусу",
    "sux" to "сумерски",
    "sv" to "шведски",
    "sw" to "свахили",
    "swb" to "коморски",
    "syc" to "класични сиријски",
    "syr" to "сиријски",
    "ta" to "тамилски",
    "tce" to "јужни тутчоне",
    "te" to "телугу",
    "tem" to "тимне",
    "teo" to "тесо",
    "ter" to "терено",
    "tet" to "тетум",
    "tg" to "таџички",
    "tgx" to "тагиш",
    "th" to "тајландски",
    "tht" to "талтан",
    "ti" to "тигриња",
    "tig" to "тигре",
    "tiv" to "тив",
    "tk" to "туркменски",
    "tkl" to "токелау",
    "tl" to "тагалски",
    "tlh" to "клингонски",
    "tli" to "тлингит",
    "tmh" to "тамашек",
    "tn" to "тсвана",
    "to" to "тонга",
    "tog" to "њаса тонга",
    "tok" to "токи пона",
    "tpi" to "ток писин",
    "tr" to "турски",
    "trv" to "тароко",
    "ts" to "тсонга",
    "tsi" to "тсимшиан",
    "tt" to "татарски",
    "ttm" to "сјеверни тутчоне",
    "tum" to "тумбука",
    "tvl" to "тувалу",
    "tw" to "тви",
    "twq" to "тасавак",
    "ty" to "тахићански",
    "tyv" to "тувинијски",
    "tzm" to "централноатласки тамазихт",
    "udm" to "удмурт",
    "ug" to "ујгурски",
    "uga" to "угаритски",
    "uk" to "украјински",
    "umb" to "умбунду",
    "und" to "непознати језик",
    "ur" to "урду",
    "uz" to "узбечки",
    "vai" to "ваи",
    "ve" to "венда",
    "vec" to "венецијански",
    "vi" to "вијетнамски",
    "vo" to "волапук",
    "vot" to "вотски",
    "vun" to "вунјо",
    "wa" to "валун",
    "wae" to "валсерски",
    "wal" to "валамо",
    "war" to "варај",
    "was" to "вашо",
    "wo" to "волоф",
    "wuu" to "ву кинески",
    "xal" to "калмик",
    "xh" to "коса",
    "xog" to "сога",
    "yao" to "јао",
    "yap" to "јапешки",
    "yav" to "јангбен",
    "ybb" to "јемба",
    "yi" to "јидиш",
    "yo" to "јоруба",
    "yrl" to "ненгату",
    "yue" to "кантонски",
    "yue-alt-menu" to "кинески (кантонски)",
    "za" to "жуанг",
    "zap" to "запотечки",
    "zbl" to "блисимболи",
    "zen" to "зенага",
    "zgh" to "стандардни марокански тамазихт",
    "zh" to "кинески",
    "zh-alt-menu" to "кинески (мандарински)",
    "zh-Hans" to "кинески (поједностављен)",
    "zh-Hans-alt-long" to "кинески мандариснки поједностављен",
    "zh-Hant-alt-long" to "кинески мандарински (традиционални)",
    "zu" to "зулу",
    "zun" to "зуни",
    "zxx" to "без лингвистичког садржаја",
    "zza" to "заза",
  ) }

  val bs_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afarski",
    "ab" to "abhaski",
    "ace" to "ačinski",
    "ach" to "akoli",
    "ada" to "adangmejski",
    "ady" to "adigejski",
    "ae" to "avestanski",
    "af" to "afrikans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "akan",
    "akk" to "akadijski",
    "ale" to "aleutski",
    "alt" to "južni altai",
    "am" to "amharski",
    "an" to "aragonski",
    "ang" to "staroengleski",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "arapski",
    "ar-001" to "moderni standardni arapski",
    "arc" to "aramejski",
    "arn" to "mapuški",
    "arp" to "arapaho",
    "ars" to "najdski arapski",
    "arw" to "aravak",
    "as" to "asamski",
    "asa" to "asu",
    "ast" to "asturijski",
    "atj" to "atikamekw",
    "av" to "avarski",
    "awa" to "avadhi",
    "ay" to "ajmara",
    "az" to "azerbejdžanski",
    "az-alt-short" to "azerski",
    "ba" to "baškirski",
    "bal" to "baluči",
    "ban" to "balinezijski",
    "bas" to "basa",
    "bax" to "bamunski",
    "bbj" to "gomala",
    "be" to "bjeloruski",
    "bej" to "beja",
    "bem" to "bemba",
    "bez" to "bena",
    "bfd" to "bafut",
    "bg" to "bugarski",
    "bgc" to "harianvi",
    "bgn" to "zapadni belučki",
    "bho" to "bojpuri",
    "bi" to "bislama",
    "bik" to "bikol",
    "bin" to "bini",
    "bkm" to "kom",
    "bla" to "siksika",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bengalski",
    "bo" to "tibetanski",
    "br" to "bretonski",
    "bra" to "braj",
    "brx" to "bodo",
    "bs" to "bosanski",
    "bss" to "akoski",
    "bua" to "buriat",
    "bug" to "bugiški",
    "bum" to "bulu",
    "byn" to "blin",
    "byv" to "medumba",
    "ca" to "katalonski",
    "cad" to "kado",
    "car" to "karipski",
    "cay" to "kajuga",
    "cch" to "atsam",
    "ccp" to "čakma",
    "ce" to "čečenski",
    "ceb" to "cebuano",
    "cgg" to "čiga",
    "ch" to "čamoro",
    "chb" to "čibča",
    "chg" to "čagatai",
    "chk" to "čukeski",
    "chm" to "mari",
    "chn" to "činukski žargon",
    "cho" to "čoktav",
    "chp" to "čipvijanski",
    "chr" to "čeroki",
    "chy" to "čejenski",
    "ckb" to "centralnokurdski",
    "ckb-alt-menu" to "centralnokurdski",
    "ckb-alt-variant" to "centralnokurdski",
    "clc" to "chilcotin",
    "co" to "korzikanski",
    "cop" to "koptski",
    "cr" to "kri",
    "crg" to "mičif",
    "crh" to "krimski turski",
    "crj" to "jugoistočni kri",
    "crk" to "ravničarski kri",
    "crl" to "sjeveroistočni kri",
    "crm" to "mus kri",
    "crr" to "sjevernokarolinški algonkvijski",
    "crs" to "seselva kreolski francuski",
    "cs" to "češki",
    "csb" to "kašubijanski",
    "csw" to "močvarni kri",
    "cu" to "staroslavenski",
    "cv" to "čuvaški",
    "cy" to "velški",
    "da" to "danski",
    "dak" to "dakota",
    "dar" to "dargva",
    "dav" to "taita",
    "de" to "njemački",
    "de-CH" to "visoki njemački (Švicarska)",
    "del" to "delaver",
    "den" to "slave",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "donjolužičkosrpski",
    "dua" to "duala",
    "dum" to "srednjovjekovni holandski",
    "dv" to "divehi",
    "dyo" to "jola-foni",
    "dyu" to "diula",
    "dz" to "džonga",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "eve",
    "efi" to "efik",
    "egy" to "staroegipatski",
    "eka" to "ekajuk",
    "el" to "grčki",
    "elx" to "elamitski",
    "en" to "engleski",
    "enm" to "srednjovjekovni engleski",
    "eo" to "esperanto",
    "es" to "španski",
    "et" to "estonski",
    "eu" to "baskijski",
    "ewo" to "evondo",
    "fa" to "perzijski",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fulah",
    "fi" to "finski",
    "fil" to "filipino",
    "fj" to "fidžijski",
    "fo" to "farski",
    "fon" to "fon",
    "fr" to "francuski",
    "frc" to "kajunski francuski",
    "frm" to "srednjovjekovni francuski",
    "fro" to "starofrancuski",
    "frr" to "sjeverni frizijski",
    "frs" to "istočnofrizijski",
    "fur" to "friulijski",
    "fy" to "zapadni frizijski",
    "ga" to "irski",
    "gaa" to "ga",
    "gag" to "gagauški",
    "gay" to "gajo",
    "gba" to "gbaja",
    "gd" to "škotski galski",
    "gez" to "staroetiopski",
    "gil" to "gilbertski",
    "gl" to "galicijski",
    "gmh" to "srednjovjekovni gornjonjemački",
    "gn" to "gvarani",
    "goh" to "staronjemački",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gotski",
    "grb" to "grebo",
    "grc" to "starogrčki",
    "gsw" to "njemački (Švicarska)",
    "gu" to "gudžarati",
    "guz" to "gusi",
    "gv" to "manks",
    "gwi" to "gvičin",
    "ha" to "hausa",
    "hai" to "haida",
    "haw" to "havajski",
    "hax" to "južni haida",
    "he" to "hebrejski",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hingleski",
    "hil" to "hiligajnon",
    "hit" to "hitite",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "hrvatski",
    "hsb" to "gornjolužičkosrpski",
    "ht" to "haićanski kreolski",
    "hu" to "mađarski",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armenski",
    "hz" to "herero",
    "ia" to "interlingva",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonezijski",
    "ie" to "interlingve",
    "ig" to "igbo",
    "ii" to "sičuan ji",
    "ik" to "inupiak",
    "ikt" to "zapadnokanadski inuktitut",
    "ilo" to "iloko",
    "inh" to "ingušetski",
    "io" to "ido",
    "is" to "islandski",
    "it" to "italijanski",
    "iu" to "inuktitut",
    "ja" to "japanski",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "makame",
    "jpr" to "judeo-perzijski",
    "jrb" to "judeo-arapski",
    "jv" to "javanski",
    "ka" to "gruzijski",
    "kaa" to "kara-kalpak",
    "kab" to "kabile",
    "kac" to "kačin",
    "kaj" to "kaju",
    "kam" to "kamba",
    "kaw" to "kavi",
    "kbd" to "kabardijski",
    "kbl" to "kanembu",
    "kcg" to "tjap",
    "kde" to "makonde",
    "kea" to "zelenortski",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "kaingang",
    "kha" to "kasi",
    "kho" to "kotanizijski",
    "khq" to "kojra čini",
    "ki" to "kikuju",
    "kj" to "kuanjama",
    "kk" to "kazaški",
    "kkj" to "kako",
    "kl" to "kalalisutski",
    "kln" to "kalenjin",
    "km" to "kmerski",
    "kmb" to "kimbundu",
    "kn" to "kanada",
    "ko" to "korejski",
    "koi" to "komi-permski",
    "kok" to "konkani",
    "kos" to "kosrejski",
    "kpe" to "kpele",
    "kr" to "kanuri",
    "krc" to "karačaj-balkar",
    "kri" to "krio",
    "krl" to "karelijski",
    "kru" to "kuruški",
    "ks" to "kašmirski",
    "ksb" to "šambala",
    "ksf" to "bafia",
    "ksh" to "kelnski",
    "ku" to "kurdski",
    "kum" to "kumik",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "kornski",
    "kwk" to "kvakvala",
    "kxv" to "kuvi",
    "ky" to "kirgiški",
    "la" to "latinski",
    "lad" to "ladino",
    "lag" to "langi",
    "lah" to "landa",
    "lam" to "lamba",
    "lb" to "luksemburški",
    "lez" to "lezgijski",
    "lg" to "ganda",
    "li" to "limburški",
    "lij" to "ligurski",
    "lil" to "liluet",
    "lkt" to "lakota",
    "lmo" to "lombardski",
    "ln" to "lingala",
    "lo" to "laoski",
    "lol" to "mongo",
    "lou" to "luizijanski kreolski",
    "loz" to "lozi",
    "lrc" to "sjeverni luri",
    "lsm" to "samia",
    "lt" to "litvanski",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lui" to "luiseno",
    "lun" to "lunda",
    "lus" to "mizo",
    "luy" to "luhija",
    "lv" to "latvijski",
    "mad" to "madureški",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maitili",
    "mak" to "makasar",
    "man" to "mandingo",
    "mas" to "masai",
    "mde" to "maba",
    "mdf" to "mokša",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "mauricijski kreolski",
    "mg" to "malgaški",
    "mga" to "srednjovjekovni irski",
    "mgh" to "makuva-meto",
    "mgo" to "meta",
    "mh" to "maršalski",
    "mi" to "maorski",
    "mic" to "mikmak",
    "min" to "minangkabau",
    "mk" to "makedonski",
    "ml" to "malajalam",
    "mn" to "mongolski",
    "mnc" to "manču",
    "mni" to "manipuri",
    "moe" to "innu-aimun",
    "moh" to "mohavk",
    "mos" to "mosi",
    "mr" to "marati",
    "ms" to "malajski",
    "mt" to "malteški",
    "mua" to "mundang",
    "mul" to "više jezika",
    "mus" to "kriški",
    "mwl" to "mirandeški",
    "mwr" to "marvari",
    "my" to "burmanski",
    "mye" to "mjene",
    "myv" to "erzija",
    "mzn" to "mazanderanski",
    "na" to "nauru",
    "nap" to "napolitanski",
    "naq" to "nama",
    "nb" to "norveški (Bokmal)",
    "nd" to "sjeverni ndebele",
    "nds" to "donjonjemački",
    "nds-NL" to "donjosaksonski",
    "ne" to "nepalski",
    "new" to "nevari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niue",
    "nl" to "nizozemski",
    "nl-BE" to "flamanski",
    "nmg" to "kvasio",
    "nn" to "norveški (Nynorsk)",
    "nnh" to "ngiembon",
    "no" to "norveški",
    "nog" to "nogai",
    "non" to "staronordijski",
    "nqo" to "nko",
    "nr" to "južni ndebele",
    "nso" to "sjeverni soto",
    "nus" to "nuer",
    "nv" to "navaho",
    "nwc" to "klasični nevari",
    "ny" to "njanja",
    "nym" to "njamvezi",
    "nyn" to "njankole",
    "nyo" to "njoro",
    "nzi" to "nzima",
    "oc" to "oksitanski",
    "oj" to "ojibva",
    "ojb" to "sjeverozapadni ojibva",
    "ojc" to "centralni ojibva",
    "ojs" to "odži kri",
    "ojw" to "zapadni ojibva",
    "oka" to "okanagan",
    "om" to "oromo",
    "or" to "odija",
    "os" to "osetski",
    "osa" to "osage",
    "ota" to "osmanski turski",
    "pa" to "pandžapski",
    "pag" to "pangasinski",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palauanski",
    "pcm" to "nigerijski pidžin",
    "peo" to "staroperzijski",
    "phn" to "feničanski",
    "pi" to "pali",
    "pis" to "pidžin",
    "pl" to "poljski",
    "pon" to "ponpejski",
    "pqm" to "malisit-pasamakvodi",
    "prg" to "pruski",
    "pro" to "staroprovansalski",
    "ps" to "paštu",
    "ps-alt-variant" to "pušto",
    "pt" to "portugalski",
    "qu" to "kečua",
    "quc" to "kiče",
    "raj" to "rajastani",
    "rap" to "rapanui",
    "rar" to "rarotongan",
    "rhg" to "rohindža",
    "rm" to "retoromanski",
    "rn" to "rundi",
    "ro" to "rumunski",
    "ro-MD" to "moldavski",
    "rof" to "rombo",
    "rom" to "romani",
    "ru" to "ruski",
    "rup" to "arumunski",
    "rw" to "kinjaruanda",
    "rwk" to "rua",
    "sa" to "sanskrit",
    "sad" to "sandave",
    "sah" to "jakutski",
    "sam" to "samaritanski aramejski",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "sba" to "ngambaj",
    "sbp" to "sangu",
    "sc" to "sardinijski",
    "scn" to "sicilijanski",
    "sco" to "škotski",
    "sd" to "sindi",
    "sdh" to "južni kurdski",
    "se" to "sjeverni sami",
    "see" to "seneka",
    "seh" to "sena",
    "sel" to "selkup",
    "ses" to "kojraboro seni",
    "sg" to "sango",
    "sga" to "staroirski",
    "sh" to "srpskohrvatski",
    "shi" to "tahelhit",
    "shn" to "šan",
    "shu" to "čadski arapski",
    "si" to "sinhaleški",
    "sid" to "sidamo",
    "sk" to "slovački",
    "sl" to "slovenski",
    "slh" to "južni lašutsid",
    "sm" to "samoanski",
    "sma" to "južni sami",
    "smj" to "lule sami",
    "smn" to "inari sami",
    "sms" to "skolt sami",
    "sn" to "šona",
    "snk" to "soninke",
    "so" to "somalski",
    "sog" to "sogdien",
    "sq" to "albanski",
    "sr" to "srpski",
    "srn" to "srananski tongo",
    "srr" to "serer",
    "ss" to "svati",
    "ssy" to "saho",
    "st" to "južni soto",
    "str" to "ravničarski sališki",
    "su" to "sundanski",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumerski",
    "sv" to "švedski",
    "sw" to "svahili",
    "swb" to "komorski",
    "syc" to "klasični sirijski",
    "syr" to "sirijski",
    "szl" to "šleski",
    "ta" to "tamilski",
    "tce" to "južni tučoni",
    "te" to "telugu",
    "tem" to "timne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetum",
    "tg" to "tadžički",
    "tgx" to "tagiš",
    "th" to "tajlandski",
    "tht" to "tahltanski",
    "ti" to "tigrinja",
    "tig" to "tigre",
    "tiv" to "tiv",
    "tk" to "turkmenski",
    "tkl" to "tokelau",
    "tl" to "tagalog",
    "tlh" to "klingonski",
    "tli" to "tlingit",
    "tmh" to "tamašek",
    "tn" to "tsvana",
    "to" to "tonganski",
    "tog" to "njasa tonga",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turski",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsi" to "tsimšian",
    "tt" to "tatarski",
    "ttm" to "sjeverni tučoni",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "tvi",
    "twq" to "tasavak",
    "ty" to "tahićanski",
    "tyv" to "tuvinijski",
    "tzm" to "centralnoatlaski tamazigt",
    "udm" to "udmurt",
    "ug" to "ujgurski",
    "uga" to "ugaritski",
    "uk" to "ukrajinski",
    "umb" to "umbundu",
    "und" to "nepoznati jezik",
    "ur" to "urdu",
    "uz" to "uzbečki",
    "ve" to "venda",
    "vec" to "venecijanski",
    "vi" to "vijetnamski",
    "vmw" to "makua",
    "vo" to "volapuk",
    "vot" to "votski",
    "vun" to "vunjo",
    "wa" to "valun",
    "wae" to "valser",
    "wal" to "valamo",
    "war" to "varej",
    "was" to "vašo",
    "wbp" to "varlpiri",
    "wo" to "volof",
    "wuu" to "Wu kineski",
    "xal" to "kalmik",
    "xh" to "hosa",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "jao",
    "yap" to "japeški",
    "yav" to "jangben",
    "ybb" to "jemba",
    "yi" to "jidiš",
    "yo" to "jorubanski",
    "yrl" to "ningatu",
    "yue" to "kantonski",
    "yue-alt-menu" to "kineski, kantonski",
    "za" to "zuang",
    "zap" to "zapotečki",
    "zbl" to "blis simboli",
    "zen" to "zenaga",
    "zgh" to "standardni marokanski tamazigt",
    "zh" to "kineski",
    "zh-alt-menu" to "kineski (standardni)",
    "zh-Hans" to "kineski (pojednostavljeni)",
    "zh-Hans-alt-long" to "kineski (pojednostavljeni standardni)",
    "zh-Hant" to "kineski (tradicionalni)",
    "zh-Hant-alt-long" to "kineski (tradicionalni standardni)",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "bez lingvističkog sadržaja",
    "zza" to "zaza",
  ) }

  val bss: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bss" to "Akoose",
    "en" to "Akáálé",
    "fr" to "Frɛnsé",
  ) }

  val byn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ro-MD" to "ሞልዳቫዊና",
  ) }

  val ca: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "àfar",
    "ab" to "abkhaz",
    "ace" to "atjeh",
    "ach" to "acoli",
    "ada" to "adangme",
    "ady" to "adigué",
    "ae" to "avèstic",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "àkan",
    "akk" to "accadi",
    "akz" to "alabama",
    "ale" to "aleuta",
    "aln" to "albanès geg",
    "alt" to "altaic meridional",
    "am" to "amhàric",
    "an" to "aragonès",
    "ang" to "anglès antic",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "àrab",
    "ar-001" to "àrab estàndard modern",
    "arc" to "arameu",
    "arn" to "mapudungu",
    "aro" to "araona",
    "arp" to "arapaho",
    "ars" to "àrab najdi",
    "arw" to "arauac",
    "arz" to "àrab egipci",
    "as" to "assamès",
    "asa" to "pare",
    "ase" to "llengua de signes americana",
    "ast" to "asturià",
    "atj" to "atacama",
    "av" to "àvar",
    "awa" to "awadhi",
    "ay" to "aimara",
    "az" to "azerbaidjanès",
    "az-alt-short" to "àzeri",
    "ba" to "baixkir",
    "bal" to "balutxi",
    "ban" to "balinès",
    "bar" to "bavarès",
    "bas" to "basa",
    "bax" to "bamum",
    "bbj" to "ghomala",
    "be" to "belarús",
    "bej" to "beja",
    "bem" to "bemba",
    "bez" to "bena",
    "bfd" to "bafut",
    "bfq" to "badaga",
    "bg" to "búlgar",
    "bgc" to "haryanvi",
    "bgn" to "balutxi occidental",
    "bho" to "bhojpuri",
    "bi" to "bislama",
    "bik" to "bicol",
    "bin" to "edo",
    "bkm" to "kom",
    "bla" to "blackfoot",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bengalí",
    "bo" to "tibetà",
    "br" to "bretó",
    "bra" to "braj",
    "brh" to "brahui",
    "brx" to "bodo",
    "bs" to "bosnià",
    "bss" to "akoose",
    "bua" to "buriat",
    "bug" to "bugui",
    "bum" to "bulu",
    "byn" to "bilin",
    "byv" to "medumba",
    "ca" to "català",
    "cad" to "caddo",
    "car" to "carib",
    "cay" to "cayuga",
    "cch" to "atsam",
    "ccp" to "chakma",
    "ce" to "txetxè",
    "ceb" to "cebuà",
    "cgg" to "chiga",
    "ch" to "chamorro",
    "chb" to "txibtxa",
    "chg" to "txagatai",
    "chk" to "chuuk",
    "chm" to "mari",
    "chn" to "pidgin chinook",
    "cho" to "choctaw",
    "chp" to "chipewyan",
    "chr" to "cherokee",
    "chy" to "xeiene",
    "ckb" to "kurd central",
    "ckb-alt-menu" to "sorani",
    "ckb-alt-variant" to "kurd sorani",
    "clc" to "chilcotin",
    "co" to "cors",
    "cop" to "copte",
    "cr" to "cree",
    "crg" to "michif",
    "crh" to "tàtar de Crimea",
    "crj" to "cree sud-oriental",
    "crk" to "cree de la plana",
    "crl" to "cree nord-oriental",
    "crm" to "moose cree",
    "crr" to "algonquí de Carolina",
    "crs" to "francès crioll de les Seychelles",
    "cs" to "txec",
    "csb" to "caixubi",
    "csw" to "swampy cree",
    "cu" to "eslau eclesiàstic",
    "cv" to "txuvaix",
    "cy" to "gal·lès",
    "da" to "danès",
    "dak" to "dakota",
    "dar" to "darguà",
    "dav" to "taita",
    "de" to "alemany",
    "de-AT" to "alemany austríac",
    "de-CH" to "alemany estàndard suís",
    "del" to "delaware",
    "den" to "slavi",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "baix sòrab",
    "dua" to "douala",
    "dum" to "neerlandès mitjà",
    "dv" to "divehi",
    "dyo" to "diola",
    "dyu" to "jula",
    "dz" to "dzongka",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efik",
    "egl" to "emilià",
    "egy" to "egipci antic",
    "eka" to "ekajuk",
    "el" to "grec",
    "elx" to "elamita",
    "en" to "anglès",
    "en-AU" to "anglès australià",
    "en-CA" to "anglès canadenc",
    "en-GB" to "anglès britànic",
    "en-GB-alt-short" to "anglès (GB)",
    "en-US" to "anglès americà",
    "en-US-alt-short" to "anglès (EUA)",
    "enm" to "anglès mitjà",
    "eo" to "esperanto",
    "es" to "espanyol",
    "es-419" to "espanyol llatinoamericà",
    "es-ES" to "espanyol europeu",
    "es-MX" to "espanyol de Mèxic",
    "et" to "estonià",
    "eu" to "basc",
    "ewo" to "ewondo",
    "ext" to "extremeny",
    "fa" to "persa",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "ful",
    "fi" to "finès",
    "fil" to "filipí",
    "fj" to "fijià",
    "fo" to "feroès",
    "fon" to "fon",
    "fr" to "francès",
    "fr-CA" to "francès canadenc",
    "fr-CH" to "francès suís",
    "frc" to "francès cajun",
    "frm" to "francès mitjà",
    "fro" to "francès antic",
    "frr" to "frisó septentrional",
    "frs" to "frisó oriental",
    "fur" to "friülà",
    "fy" to "frisó occidental",
    "ga" to "irlandès",
    "gaa" to "ga",
    "gag" to "gagaús",
    "gan" to "xinès gan",
    "gay" to "gayo",
    "gba" to "gbaya",
    "gd" to "gaèlic escocès",
    "gez" to "gueez",
    "gil" to "gilbertès",
    "gl" to "gallec",
    "glk" to "gilaki",
    "gmh" to "alt alemany mitjà",
    "gn" to "guaraní",
    "goh" to "alt alemany antic",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gòtic",
    "grb" to "grebo",
    "grc" to "grec antic",
    "gsw" to "alemany suís",
    "gu" to "gujarati",
    "guc" to "wayú",
    "guz" to "gusí",
    "gv" to "manx",
    "gwi" to "gwich’in",
    "ha" to "haussa",
    "hai" to "haida",
    "hak" to "xinès hakka",
    "haw" to "hawaià",
    "hax" to "haida meridional",
    "he" to "hebreu",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hinglish",
    "hif" to "hindi de Fiji",
    "hil" to "híligaynon",
    "hit" to "hitita",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "croat",
    "hsb" to "alt sòrab",
    "hsn" to "xinès xiang",
    "ht" to "crioll d’Haití",
    "hu" to "hongarès",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armeni",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonesi",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "yi sichuan",
    "ik" to "inupiak",
    "ikt" to "inuktitut occidental canadenc",
    "ilo" to "ilocano",
    "inh" to "ingúix",
    "io" to "ido",
    "is" to "islandès",
    "it" to "italià",
    "iu" to "inuktitut",
    "ja" to "japonès",
    "jam" to "crioll anglès de Jamaica",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jpr" to "judeopersa",
    "jrb" to "judeoàrab",
    "jv" to "javanès",
    "ka" to "georgià",
    "kaa" to "karakalpak",
    "kab" to "cabilenc",
    "kac" to "katxin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kawi",
    "kbd" to "kabardí",
    "kbl" to "kanembu",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "crioll capverdià",
    "ken" to "kenyang",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "kaingà",
    "kha" to "khasi",
    "kho" to "khotanès",
    "khq" to "koyra chiini",
    "ki" to "kikuiu",
    "kj" to "kuanyama",
    "kk" to "kazakh",
    "kkj" to "kako",
    "kl" to "groenlandès",
    "kln" to "kalenjin",
    "km" to "khmer",
    "kmb" to "kimbundu",
    "kn" to "kannada",
    "ko" to "coreà",
    "koi" to "komi-permiac",
    "kok" to "concani",
    "kos" to "kosraeà",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karatxai-balkar",
    "kri" to "krio",
    "krl" to "carelià",
    "kru" to "kurukh",
    "ks" to "caixmiri",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "kölsch",
    "ku" to "kurd",
    "kum" to "kúmik",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "còrnic",
    "kwk" to "kwak’wala",
    "kxv" to "kuvi",
    "ky" to "kirguís",
    "la" to "llatí",
    "lad" to "judeocastellà",
    "lag" to "langi",
    "lah" to "panjabi occidental",
    "lam" to "lamba",
    "lb" to "luxemburguès",
    "lez" to "lesguià",
    "lg" to "ganda",
    "li" to "limburguès",
    "lij" to "lígur",
    "lil" to "lillooet",
    "lkt" to "lakota",
    "lmo" to "llombard",
    "ln" to "lingala",
    "lo" to "laosià",
    "lol" to "mongo",
    "lou" to "crioll francès de Louisiana",
    "loz" to "lozi",
    "lrc" to "luri septentrional",
    "lsm" to "saamia",
    "lt" to "lituà",
    "lu" to "luba katanga",
    "lua" to "luba-lulua",
    "lui" to "luisenyo",
    "lun" to "lunda",
    "lus" to "mizo",
    "luy" to "luyia",
    "lv" to "letó",
    "lzh" to "xinès clàssic",
    "lzz" to "laz",
    "mad" to "madurès",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makassar",
    "man" to "mandinga",
    "mas" to "massai",
    "mde" to "maba",
    "mdf" to "mordovià moksa",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "mauricià",
    "mg" to "malgaix",
    "mga" to "gaèlic irlandès mitjà",
    "mgh" to "makhuwa-metto",
    "mgo" to "meta’",
    "mh" to "marshallès",
    "mi" to "maori",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "macedoni",
    "ml" to "malaiàlam",
    "mn" to "mongol",
    "mnc" to "manxú",
    "mni" to "manipurí",
    "moe" to "innu-aimun",
    "moh" to "mohawk",
    "mos" to "moore",
    "mr" to "marathi",
    "mrj" to "mari occidental",
    "ms" to "malai",
    "mt" to "maltès",
    "mua" to "mundang",
    "mul" to "llengües vàries",
    "mus" to "creek",
    "mwl" to "mirandès",
    "mwr" to "marwari",
    "my" to "birmà",
    "mye" to "myene",
    "myv" to "mordovià erza",
    "mzn" to "mazanderani",
    "na" to "nauruà",
    "nan" to "xinès min del sud",
    "nap" to "napolità",
    "naq" to "nama",
    "nb" to "noruec bokmål",
    "nd" to "ndebele septentrional",
    "nds" to "baix alemany",
    "nds-NL" to "baix saxó",
    "ne" to "nepalès",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niueà",
    "nl" to "neerlandès",
    "nl-BE" to "flamenc",
    "nmg" to "bissio",
    "nn" to "noruec nynorsk",
    "nnh" to "ngiemboon",
    "no" to "noruec",
    "nog" to "nogai",
    "non" to "nòrdic antic",
    "nov" to "novial",
    "nqo" to "n’Ko",
    "nr" to "ndebele meridional",
    "nso" to "sotho septentrional",
    "nus" to "nuer",
    "nv" to "navaho",
    "nwc" to "newari clàssic",
    "ny" to "nyanja",
    "nym" to "nyamwesi",
    "nyn" to "nyankole",
    "nyo" to "nyoro",
    "nzi" to "nzema",
    "oc" to "occità",
    "oj" to "ojibwa",
    "ojb" to "ojibwa septentrional",
    "ojc" to "ojibwa central",
    "ojs" to "oji-cree",
    "ojw" to "ojibwa occidental",
    "oka" to "okanagà",
    "om" to "oromo",
    "or" to "oriya",
    "os" to "osseta",
    "osa" to "osage",
    "ota" to "turc otomà",
    "pa" to "panjabi",
    "pag" to "pangasinan",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiament",
    "pau" to "palauà",
    "pcd" to "picard",
    "pcm" to "pidgin de Nigèria",
    "pdc" to "alemany pennsilvanià",
    "peo" to "persa antic",
    "pfl" to "alemany palatí",
    "phn" to "fenici",
    "pi" to "pali",
    "pis" to "pidgin",
    "pl" to "polonès",
    "pms" to "piemontès",
    "pnt" to "pòntic",
    "pon" to "ponapeà",
    "pqm" to "maliseet-passamaquoddy",
    "prg" to "prussià",
    "pro" to "provençal antic",
    "ps" to "paixtu",
    "ps-alt-variant" to "pushtu",
    "pt" to "portuguès",
    "pt-BR" to "portuguès del Brasil",
    "pt-PT" to "portuguès de Portugal",
    "qu" to "quítxua",
    "quc" to "k’iche’",
    "raj" to "rajasthani",
    "rap" to "rapanui",
    "rar" to "rarotongà",
    "rgn" to "romanyès",
    "rhg" to "rohingya",
    "rm" to "retoromànic",
    "rn" to "rundi",
    "ro" to "romanès",
    "ro-MD" to "moldau",
    "rof" to "rombo",
    "rom" to "romaní",
    "ru" to "rus",
    "rup" to "aromanès",
    "rw" to "ruandès",
    "rwk" to "rwo",
    "sa" to "sànscrit",
    "sad" to "sandawe",
    "sah" to "iacut",
    "sam" to "arameu samarità",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sard",
    "scn" to "sicilià",
    "sco" to "escocès",
    "sd" to "sindi",
    "sdc" to "sasserès",
    "sdh" to "kurd meridional",
    "se" to "sami septentrional",
    "see" to "seneca",
    "seh" to "sena",
    "sel" to "selkup",
    "ses" to "songhai oriental",
    "sg" to "sango",
    "sga" to "irlandès antic",
    "sh" to "serbocroat",
    "shi" to "taixelhit",
    "shn" to "xan",
    "shu" to "àrab txadià",
    "si" to "singalès",
    "sid" to "sidamo",
    "sk" to "eslovac",
    "sl" to "eslovè",
    "slh" to "lushootseed meridional",
    "sm" to "samoà",
    "sma" to "sami meridional",
    "smj" to "sami lule",
    "smn" to "sami d’Inari",
    "sms" to "sami skolt",
    "sn" to "shona",
    "snk" to "soninke",
    "so" to "somali",
    "sog" to "sogdià",
    "sq" to "albanès",
    "sr" to "serbi",
    "srn" to "sranan",
    "srr" to "serer",
    "ss" to "swazi",
    "ssy" to "saho",
    "st" to "sotho meridional",
    "str" to "straits salish",
    "su" to "sondanès",
    "suk" to "sukuma",
    "sus" to "susú",
    "sux" to "sumeri",
    "sv" to "suec",
    "sw" to "suahili",
    "sw-CD" to "suahili del Congo",
    "swb" to "comorià",
    "syc" to "siríac clàssic",
    "syr" to "siríac",
    "szl" to "silesià",
    "ta" to "tàmil",
    "tce" to "tutxone meridional",
    "te" to "telugu",
    "tem" to "temne",
    "teo" to "teso",
    "ter" to "terena",
    "tet" to "tètum",
    "tg" to "tadjik",
    "tgx" to "tagish",
    "th" to "tai",
    "tht" to "tahltà",
    "ti" to "tigrinya",
    "tig" to "tigre",
    "tiv" to "tiv",
    "tk" to "turcman",
    "tkl" to "tokelauès",
    "tkr" to "tsakhur",
    "tl" to "tagal",
    "tlh" to "klingonià",
    "tli" to "tlingit",
    "tly" to "talix",
    "tmh" to "amazic",
    "tn" to "setswana",
    "to" to "tongalès",
    "tog" to "tonga",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turc",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsi" to "tsimshià",
    "tt" to "tàtar",
    "ttm" to "tutxone septentrional",
    "ttt" to "tat meridional",
    "tum" to "tumbuka",
    "tvl" to "tuvaluà",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitià",
    "tyv" to "tuvinià",
    "tzm" to "amazic del Marroc central",
    "udm" to "udmurt",
    "ug" to "uigur",
    "uga" to "ugarític",
    "uk" to "ucraïnès",
    "umb" to "umbundu",
    "und" to "idioma desconegut",
    "ur" to "urdú",
    "uz" to "uzbek",
    "ve" to "venda",
    "vec" to "vènet",
    "vep" to "vepse",
    "vi" to "vietnamita",
    "vls" to "flamenc occidental",
    "vmw" to "makua",
    "vo" to "volapük",
    "vot" to "vòtic",
    "vun" to "vunjo",
    "wa" to "való",
    "wae" to "walser",
    "wal" to "wolaita",
    "war" to "waray",
    "was" to "washo",
    "wbp" to "warlpiri",
    "wo" to "wòlof",
    "wuu" to "xinès wu",
    "xal" to "calmuc",
    "xh" to "xosa",
    "xmf" to "mingrelià",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "yao",
    "yap" to "yapeà",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "ídix",
    "yo" to "ioruba",
    "yrl" to "nheengatú",
    "yue" to "cantonès",
    "yue-alt-menu" to "xinès, cantonès",
    "za" to "zhuang",
    "zap" to "zapoteca",
    "zbl" to "símbols Bliss",
    "zea" to "zelandès",
    "zen" to "zenaga",
    "zgh" to "amazic estàndard marroquí",
    "zh" to "xinès",
    "zh-alt-menu" to "xinès, mandarí",
    "zh-Hans" to "xinès simplificat",
    "zh-Hans-alt-long" to "xinès mandarí (simplificat)",
    "zh-Hant" to "xinès tradicional",
    "zh-Hant-alt-long" to "xinès mandarí (tradicional)",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "sense contingut lingüístic",
    "zza" to "zaza",
  ) }

  val ca_AD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ca_ES_valencia: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "àfar",
    "ab" to "abkhaz",
    "ace" to "atjeh",
    "ach" to "acoli",
    "ada" to "adangme",
    "ady" to "adigué",
    "ae" to "avèstic",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "àkan",
    "akk" to "accadi",
    "akz" to "alabama",
    "ale" to "aleuta",
    "aln" to "albanès geg",
    "alt" to "altaic meridional",
    "am" to "amhàric",
    "an" to "aragonès",
    "ang" to "anglès antic",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "àrab",
    "ar-001" to "àrab estàndard modern",
    "arc" to "arameu",
    "arn" to "mapudungu",
    "aro" to "araona",
    "arp" to "arapaho",
    "ars" to "àrab najdi",
    "arw" to "arauac",
    "arz" to "àrab egipci",
    "as" to "assamès",
    "asa" to "pare",
    "ase" to "llengua de signes americana",
    "ast" to "asturià",
    "atj" to "atacama",
    "av" to "àvar",
    "awa" to "awadhi",
    "ay" to "aimara",
    "az" to "azerbaidjanès",
    "az-alt-short" to "àzeri",
    "ba" to "baixkir",
    "bal" to "balutxi",
    "ban" to "balinès",
    "bar" to "bavarès",
    "bas" to "basa",
    "bax" to "bamum",
    "bbj" to "ghomala",
    "be" to "belarús",
    "bej" to "beja",
    "bem" to "bemba",
    "bez" to "bena",
    "bfd" to "bafut",
    "bfq" to "badaga",
    "bg" to "búlgar",
    "bgc" to "haryanvi",
    "bgn" to "balutxi occidental",
    "bho" to "bhojpuri",
    "bi" to "bislama",
    "bik" to "bicol",
    "bin" to "edo",
    "bkm" to "kom",
    "bla" to "blackfoot",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bengalí",
    "bo" to "tibetà",
    "br" to "bretó",
    "bra" to "braj",
    "brh" to "brahui",
    "brx" to "bodo",
    "bs" to "bosnià",
    "bss" to "akoose",
    "bua" to "buriat",
    "bug" to "bugui",
    "bum" to "bulu",
    "byn" to "bilin",
    "byv" to "medumba",
    "ca" to "català",
    "cad" to "caddo",
    "car" to "carib",
    "cay" to "cayuga",
    "cch" to "atsam",
    "ccp" to "chakma",
    "ce" to "txetxè",
    "ceb" to "cebuà",
    "cgg" to "chiga",
    "ch" to "chamorro",
    "chb" to "txibtxa",
    "chg" to "txagatai",
    "chk" to "chuuk",
    "chm" to "mari",
    "chn" to "pidgin chinook",
    "cho" to "choctaw",
    "chp" to "chipewyan",
    "chr" to "cherokee",
    "chy" to "xeiene",
    "ckb" to "kurd central",
    "ckb-alt-menu" to "sorani",
    "ckb-alt-variant" to "kurd sorani",
    "clc" to "chilcotin",
    "co" to "cors",
    "cop" to "copte",
    "cr" to "cree",
    "crg" to "michif",
    "crh" to "tàtar de Crimea",
    "crj" to "cree sud-oriental",
    "crk" to "cree de la plana",
    "crl" to "cree nord-oriental",
    "crm" to "moose cree",
    "crr" to "algonquí de Carolina",
    "crs" to "francès crioll de les Seychelles",
    "cs" to "txec",
    "csb" to "caixubi",
    "csw" to "swampy cree",
    "cu" to "eslau eclesiàstic",
    "cv" to "txuvaix",
    "cy" to "gal·lès",
    "da" to "danès",
    "dak" to "dakota",
    "dar" to "darguà",
    "dav" to "taita",
    "de" to "alemany",
    "de-AT" to "alemany austríac",
    "de-CH" to "alemany estàndard suís",
    "del" to "delaware",
    "den" to "slavi",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "baix sòrab",
    "dua" to "douala",
    "dum" to "neerlandès mitjà",
    "dv" to "divehi",
    "dyo" to "diola",
    "dyu" to "jula",
    "dz" to "dzongka",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efik",
    "egl" to "emilià",
    "egy" to "egipci antic",
    "eka" to "ekajuk",
    "el" to "grec",
    "elx" to "elamita",
    "en" to "anglès",
    "en-AU" to "anglès australià",
    "en-CA" to "anglès canadenc",
    "en-GB" to "anglès britànic",
    "en-GB-alt-short" to "anglès (GB)",
    "en-US" to "anglès americà",
    "en-US-alt-short" to "anglès (EUA)",
    "enm" to "anglès mitjà",
    "eo" to "esperanto",
    "es" to "espanyol",
    "es-419" to "espanyol llatinoamericà",
    "es-ES" to "espanyol europeu",
    "es-MX" to "espanyol de Mèxic",
    "et" to "estonià",
    "eu" to "basc",
    "ewo" to "ewondo",
    "ext" to "extremeny",
    "fa" to "persa",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "ful",
    "fi" to "finès",
    "fil" to "filipí",
    "fj" to "fijià",
    "fo" to "feroès",
    "fon" to "fon",
    "fr" to "francès",
    "fr-CA" to "francès canadenc",
    "fr-CH" to "francès suís",
    "frc" to "francès cajun",
    "frm" to "francès mitjà",
    "fro" to "francès antic",
    "frr" to "frisó septentrional",
    "frs" to "frisó oriental",
    "fur" to "friülà",
    "fy" to "frisó occidental",
    "ga" to "irlandès",
    "gaa" to "ga",
    "gag" to "gagaús",
    "gan" to "xinès gan",
    "gay" to "gayo",
    "gba" to "gbaya",
    "gd" to "gaèlic escocès",
    "gez" to "gueez",
    "gil" to "gilbertès",
    "gl" to "gallec",
    "glk" to "gilaki",
    "gmh" to "alt alemany mitjà",
    "gn" to "guaraní",
    "goh" to "alt alemany antic",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gòtic",
    "grb" to "grebo",
    "grc" to "grec antic",
    "gsw" to "alemany suís",
    "gu" to "gujarati",
    "guc" to "wayú",
    "guz" to "gusí",
    "gv" to "manx",
    "gwi" to "gwich’in",
    "ha" to "haussa",
    "hai" to "haida",
    "hak" to "xinès hakka",
    "haw" to "hawaià",
    "hax" to "haida meridional",
    "he" to "hebreu",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hinglish",
    "hif" to "hindi de Fiji",
    "hil" to "híligaynon",
    "hit" to "hitita",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "croat",
    "hsb" to "alt sòrab",
    "hsn" to "xinès xiang",
    "ht" to "crioll d’Haití",
    "hu" to "hongarès",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armeni",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonesi",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "yi sichuan",
    "ik" to "inupiak",
    "ikt" to "inuktitut occidental canadenc",
    "ilo" to "ilocano",
    "inh" to "ingúix",
    "io" to "ido",
    "is" to "islandès",
    "it" to "italià",
    "iu" to "inuktitut",
    "ja" to "japonès",
    "jam" to "crioll anglès de Jamaica",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jpr" to "judeopersa",
    "jrb" to "judeoàrab",
    "jv" to "javanès",
    "ka" to "georgià",
    "kaa" to "karakalpak",
    "kab" to "cabilenc",
    "kac" to "katxin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kawi",
    "kbd" to "kabardí",
    "kbl" to "kanembu",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "crioll capverdià",
    "ken" to "kenyang",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "kaingà",
    "kha" to "khasi",
    "kho" to "khotanès",
    "khq" to "koyra chiini",
    "ki" to "kikuiu",
    "kj" to "kuanyama",
    "kk" to "kazakh",
    "kkj" to "kako",
    "kl" to "groenlandès",
    "kln" to "kalenjin",
    "km" to "khmer",
    "kmb" to "kimbundu",
    "kn" to "kannada",
    "ko" to "coreà",
    "koi" to "komi-permiac",
    "kok" to "concani",
    "kos" to "kosraeà",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karatxai-balkar",
    "kri" to "krio",
    "krl" to "carelià",
    "kru" to "kurukh",
    "ks" to "caixmiri",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "kölsch",
    "ku" to "kurd",
    "kum" to "kúmik",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "còrnic",
    "kwk" to "kwak’wala",
    "kxv" to "kuvi",
    "ky" to "kirguís",
    "la" to "llatí",
    "lad" to "judeocastellà",
    "lag" to "langi",
    "lah" to "panjabi occidental",
    "lam" to "lamba",
    "lb" to "luxemburguès",
    "lez" to "lesguià",
    "lg" to "ganda",
    "li" to "limburguès",
    "lij" to "lígur",
    "lil" to "lillooet",
    "lkt" to "lakota",
    "lmo" to "llombard",
    "ln" to "lingala",
    "lo" to "laosià",
    "lol" to "mongo",
    "lou" to "crioll francès de Louisiana",
    "loz" to "lozi",
    "lrc" to "luri septentrional",
    "lsm" to "saamia",
    "lt" to "lituà",
    "lu" to "luba katanga",
    "lua" to "luba-lulua",
    "lui" to "luisenyo",
    "lun" to "lunda",
    "lus" to "mizo",
    "luy" to "luyia",
    "lv" to "letó",
    "lzh" to "xinès clàssic",
    "lzz" to "laz",
    "mad" to "madurès",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makassar",
    "man" to "mandinga",
    "mas" to "massai",
    "mde" to "maba",
    "mdf" to "mordovià moksa",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "mauricià",
    "mg" to "malgaix",
    "mga" to "gaèlic irlandès mitjà",
    "mgh" to "makhuwa-metto",
    "mgo" to "meta’",
    "mh" to "marshallès",
    "mi" to "maori",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "macedoni",
    "ml" to "malaiàlam",
    "mn" to "mongol",
    "mnc" to "manxú",
    "mni" to "manipurí",
    "moe" to "innu-aimun",
    "moh" to "mohawk",
    "mos" to "moore",
    "mr" to "marathi",
    "mrj" to "mari occidental",
    "ms" to "malai",
    "mt" to "maltès",
    "mua" to "mundang",
    "mul" to "llengües vàries",
    "mus" to "creek",
    "mwl" to "mirandès",
    "mwr" to "marwari",
    "my" to "birmà",
    "mye" to "myene",
    "myv" to "mordovià erza",
    "mzn" to "mazanderani",
    "na" to "nauruà",
    "nan" to "xinès min del sud",
    "nap" to "napolità",
    "naq" to "nama",
    "nb" to "noruec bokmål",
    "nd" to "ndebele septentrional",
    "nds" to "baix alemany",
    "nds-NL" to "baix saxó",
    "ne" to "nepalès",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niueà",
    "nl" to "neerlandès",
    "nl-BE" to "flamenc",
    "nmg" to "bissio",
    "nn" to "noruec nynorsk",
    "nnh" to "ngiemboon",
    "no" to "noruec",
    "nog" to "nogai",
    "non" to "nòrdic antic",
    "nov" to "novial",
    "nqo" to "n’Ko",
    "nr" to "ndebele meridional",
    "nso" to "sotho septentrional",
    "nus" to "nuer",
    "nv" to "navaho",
    "nwc" to "newari clàssic",
    "ny" to "nyanja",
    "nym" to "nyamwesi",
    "nyn" to "nyankole",
    "nyo" to "nyoro",
    "nzi" to "nzema",
    "oc" to "occità",
    "oj" to "ojibwa",
    "ojb" to "ojibwa septentrional",
    "ojc" to "ojibwa central",
    "ojs" to "oji-cree",
    "ojw" to "ojibwa occidental",
    "oka" to "okanagà",
    "om" to "oromo",
    "or" to "oriya",
    "os" to "osseta",
    "osa" to "osage",
    "ota" to "turc otomà",
    "pa" to "panjabi",
    "pag" to "pangasinan",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiament",
    "pau" to "palauà",
    "pcd" to "picard",
    "pcm" to "pidgin de Nigèria",
    "pdc" to "alemany pennsilvanià",
    "peo" to "persa antic",
    "pfl" to "alemany palatí",
    "phn" to "fenici",
    "pi" to "pali",
    "pis" to "pidgin",
    "pl" to "polonès",
    "pms" to "piemontès",
    "pnt" to "pòntic",
    "pon" to "ponapeà",
    "pqm" to "maliseet-passamaquoddy",
    "prg" to "prussià",
    "pro" to "provençal antic",
    "ps" to "paixtu",
    "ps-alt-variant" to "pushtu",
    "pt" to "portuguès",
    "pt-BR" to "portuguès del Brasil",
    "pt-PT" to "portuguès de Portugal",
    "qu" to "quítxua",
    "quc" to "k’iche’",
    "raj" to "rajasthani",
    "rap" to "rapanui",
    "rar" to "rarotongà",
    "rgn" to "romanyès",
    "rhg" to "rohingya",
    "rm" to "retoromànic",
    "rn" to "rundi",
    "ro" to "romanès",
    "ro-MD" to "moldau",
    "rof" to "rombo",
    "rom" to "romaní",
    "ru" to "rus",
    "rup" to "aromanès",
    "rw" to "ruandès",
    "rwk" to "rwo",
    "sa" to "sànscrit",
    "sad" to "sandawe",
    "sah" to "iacut",
    "sam" to "arameu samarità",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sard",
    "scn" to "sicilià",
    "sco" to "escocès",
    "sd" to "sindi",
    "sdc" to "sasserès",
    "sdh" to "kurd meridional",
    "se" to "sami septentrional",
    "see" to "seneca",
    "seh" to "sena",
    "sel" to "selkup",
    "ses" to "songhai oriental",
    "sg" to "sango",
    "sga" to "irlandès antic",
    "sh" to "serbocroat",
    "shi" to "taixelhit",
    "shn" to "xan",
    "shu" to "àrab txadià",
    "si" to "singalès",
    "sid" to "sidamo",
    "sk" to "eslovac",
    "sl" to "eslovè",
    "slh" to "lushootseed meridional",
    "sm" to "samoà",
    "sma" to "sami meridional",
    "smj" to "sami lule",
    "smn" to "sami d’Inari",
    "sms" to "sami skolt",
    "sn" to "shona",
    "snk" to "soninke",
    "so" to "somali",
    "sog" to "sogdià",
    "sq" to "albanès",
    "sr" to "serbi",
    "srn" to "sranan",
    "srr" to "serer",
    "ss" to "swazi",
    "ssy" to "saho",
    "st" to "sotho meridional",
    "str" to "straits salish",
    "su" to "sondanès",
    "suk" to "sukuma",
    "sus" to "susú",
    "sux" to "sumeri",
    "sv" to "suec",
    "sw" to "suahili",
    "sw-CD" to "suahili del Congo",
    "swb" to "comorià",
    "syc" to "siríac clàssic",
    "syr" to "siríac",
    "szl" to "silesià",
    "ta" to "tàmil",
    "tce" to "tutxone meridional",
    "te" to "telugu",
    "tem" to "temne",
    "teo" to "teso",
    "ter" to "terena",
    "tet" to "tètum",
    "tg" to "tadjik",
    "tgx" to "tagish",
    "th" to "tai",
    "tht" to "tahltà",
    "ti" to "tigrinya",
    "tig" to "tigre",
    "tiv" to "tiv",
    "tk" to "turcman",
    "tkl" to "tokelauès",
    "tkr" to "tsakhur",
    "tl" to "tagal",
    "tlh" to "klingonià",
    "tli" to "tlingit",
    "tly" to "talix",
    "tmh" to "amazic",
    "tn" to "setswana",
    "to" to "tongalès",
    "tog" to "tonga",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turc",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsi" to "tsimshià",
    "tt" to "tàtar",
    "ttm" to "tutxone septentrional",
    "ttt" to "tat meridional",
    "tum" to "tumbuka",
    "tvl" to "tuvaluà",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitià",
    "tyv" to "tuvinià",
    "tzm" to "amazic del Marroc central",
    "udm" to "udmurt",
    "ug" to "uigur",
    "uga" to "ugarític",
    "uk" to "ucraïnès",
    "umb" to "umbundu",
    "und" to "idioma desconegut",
    "ur" to "urdú",
    "uz" to "uzbek",
    "ve" to "venda",
    "vec" to "vènet",
    "vep" to "vepse",
    "vi" to "vietnamita",
    "vls" to "flamenc occidental",
    "vmw" to "makua",
    "vo" to "volapük",
    "vot" to "vòtic",
    "vun" to "vunjo",
    "wa" to "való",
    "wae" to "walser",
    "wal" to "wolaita",
    "war" to "waray",
    "was" to "washo",
    "wbp" to "warlpiri",
    "wo" to "wòlof",
    "wuu" to "xinès wu",
    "xal" to "calmuc",
    "xh" to "xosa",
    "xmf" to "mingrelià",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "yao",
    "yap" to "yapeà",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "ídix",
    "yo" to "ioruba",
    "yrl" to "nheengatú",
    "yue" to "cantonès",
    "yue-alt-menu" to "xinès, cantonès",
    "za" to "zhuang",
    "zap" to "zapoteca",
    "zbl" to "símbols Bliss",
    "zea" to "zelandès",
    "zen" to "zenaga",
    "zgh" to "amazic estàndard marroquí",
    "zh" to "xinès",
    "zh-alt-menu" to "xinès, mandarí",
    "zh-Hans" to "xinès simplificat",
    "zh-Hans-alt-long" to "xinès mandarí (simplificat)",
    "zh-Hant" to "xinès tradicional",
    "zh-Hant-alt-long" to "xinès mandarí (tradicional)",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "sense contingut lingüístic",
    "zza" to "zaza",
  ) }

  val ca_FR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ca_IT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val cch: ImmutableMap<String, String> by lazy { immutableMapOf(
    "cch" to "Atsam",
  ) }

  val ccp: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "𑄃𑄜𑄢𑄴",
    "ab" to "𑄃𑄝𑄴𑄈𑄎𑄨𑄠𑄚𑄴",
    "ace" to "𑄃𑄳𑄃𑄌𑄳𑄆𑄚𑄨𑄎𑄴",
    "ach" to "𑄃𑄇𑄮𑄣𑄨",
    "ada" to "𑄃𑄧𑄘𑄟𑄳𑄉𑄬",
    "ady" to "𑄃𑄘𑄬𑄉𑄬",
    "ae" to "𑄃𑄝𑄬𑄌𑄴𑄖𑄩𑄠𑄧",
    "af" to "𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴",
    "afh" to "𑄃𑄜𑄳𑄢𑄨𑄦𑄨𑄣𑄨",
    "agq" to "𑄃𑄬𑄊𑄟𑄴",
    "ain" to "𑄃𑄳𑄆𑄚𑄪",
    "ak" to "𑄃𑄇𑄚𑄴",
    "akk" to "𑄃𑄇𑄳𑄦𑄴𑄘𑄨𑄠𑄚𑄴",
    "ale" to "𑄃𑄣𑄬𑄅𑄖𑄴",
    "alt" to "𑄓𑄧𑄉𑄨𑄚𑄴 𑄃𑄣𑄴𑄖𑄭",
    "am" to "𑄃𑄟𑄴𑄦𑄢𑄨𑄇𑄴",
    "an" to "𑄃𑄢𑄴𑄉𑄮𑄚𑄨𑄎𑄴",
    "ang" to "𑄛𑄪𑄢𑄧𑄚𑄨 𑄃𑄟𑄧𑄣𑄧𑄢𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄩",
    "anp" to "𑄃𑄋𑄳𑄉𑄨𑄇",
    "ar" to "𑄃𑄢𑄧𑄝𑄩",
    "ar-001" to "𑄚𑄱 𑄉𑄧𑄟𑄴 𑄃𑄢𑄧𑄝𑄩",
    "arc" to "𑄃𑄢𑄟𑄳𑄆𑄇𑄴",
    "arn" to "𑄟𑄛𑄪𑄌𑄨",
    "arp" to "𑄃𑄢𑄛𑄦𑄮",
    "arw" to "𑄃𑄢𑄤𑄇𑄴",
    "as" to "𑄃𑄥𑄟𑄨",
    "asa" to "𑄃𑄥𑄪",
    "ast" to "𑄃𑄌𑄴𑄖𑄪𑄢𑄨𑄠𑄧",
    "av" to "𑄃𑄞𑄬𑄢𑄨𑄇𑄴",
    "awa" to "𑄃𑄤𑄙𑄨",
    "ay" to "𑄃𑄠𑄧𑄟𑄢",
    "az" to "𑄃𑄎𑄢𑄴𑄝𑄳𑄆𑄎𑄚𑄩",
    "az-alt-short" to "𑄃𑄎𑄬𑄢𑄨",
    "ba" to "𑄝𑄌𑄴𑄇𑄨𑄢𑄴",
    "bal" to "𑄝𑄬𑄣𑄪𑄌𑄩",
    "ban" to "𑄝𑄣𑄨𑄚𑄩𑄠𑄧",
    "bas" to "𑄝𑄥",
    "be" to "𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄧",
    "bej" to "𑄝𑄬𑄎",
    "bem" to "𑄝𑄬𑄟𑄴𑄝",
    "bez" to "𑄝𑄬𑄚",
    "bg" to "𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄨𑄠𑄧",
    "bgn" to "𑄛𑄧𑄏𑄨𑄟𑄴 𑄝𑄣𑄮𑄌𑄨",
    "bho" to "𑄞𑄮𑄎𑄴𑄛𑄪𑄢𑄨",
    "bi" to "𑄝𑄨𑄥𑄴𑄣𑄟",
    "bik" to "𑄝𑄨𑄇𑄮𑄣𑄴",
    "bin" to "𑄝𑄨𑄚𑄨",
    "bla" to "𑄥𑄨𑄇𑄴𑄥𑄨𑄇",
    "bm" to "𑄝𑄟𑄴𑄝𑄢",
    "bn" to "𑄝𑄁𑄣",
    "bo" to "𑄖𑄨𑄛𑄴𑄝𑄧𑄖𑄨",
    "br" to "𑄝𑄳𑄢𑄬𑄑𑄧𑄚𑄴",
    "bra" to "𑄝𑄳𑄢𑄎𑄴",
    "brx" to "𑄝𑄮𑄢𑄮",
    "bs" to "𑄝𑄧𑄥𑄴𑄚𑄩𑄠𑄚𑄴",
    "bua" to "𑄝𑄪𑄢𑄨𑄠𑄖𑄴",
    "bug" to "𑄝𑄪𑄉𑄨𑄚𑄨",
    "byn" to "𑄝𑄳𑄣𑄨𑄚𑄴",
    "ca" to "𑄇𑄖𑄣𑄚𑄴",
    "cad" to "𑄇𑄳𑄠𑄓𑄮",
    "car" to "𑄝𑄳𑄠𑄢𑄨𑄛𑄴",
    "cch" to "𑄃𑄖𑄴𑄥𑄟𑄴",
    "ccp" to "𑄌𑄋𑄴𑄟𑄳𑄦",
    "ce" to "𑄌𑄬𑄌𑄬𑄚𑄴",
    "ceb" to "𑄌𑄬𑄝𑄪𑄠𑄚𑄮",
    "cgg" to "𑄌𑄨𑄉",
    "ch" to "𑄌𑄟𑄮𑄢𑄮",
    "chb" to "𑄌𑄨𑄛𑄴𑄌",
    "chg" to "𑄌𑄉𑄖𑄳𑄆",
    "chk" to "𑄌𑄪𑄇𑄨",
    "chm" to "𑄟𑄢𑄨",
    "chn" to "𑄌𑄨𑄚𑄪𑄇𑄴 𑄎𑄢𑄴𑄉𑄧𑄚𑄴",
    "cho" to "𑄌𑄧𑄇𑄴𑄑𑄳𑄅𑄧𑄠𑄧",
    "chp" to "𑄌𑄨𑄛𑄮𑄤𑄚𑄴",
    "chr" to "𑄌𑄬𑄢𑄮𑄇𑄩",
    "chy" to "𑄥𑄳𑄆𑄠𑄬𑄚𑄴",
    "ckb" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴",
    "ckb-alt-menu" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴",
    "ckb-alt-variant" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴",
    "co" to "𑄇𑄧𑄢𑄴𑄥𑄨𑄇𑄚𑄴",
    "cop" to "𑄇𑄧𑄛𑄴𑄑𑄨𑄇𑄴",
    "cr" to "𑄇𑄳𑄢𑄨",
    "crh" to "𑄇𑄳𑄢𑄨𑄟𑄨𑄠𑄚𑄴 𑄖𑄪𑄢𑄴𑄇𑄨",
    "crs" to "𑄥𑄬𑄥𑄬𑄣𑄧𑄤 𑄇𑄳𑄢𑄬𑄃𑄮𑄣𑄴 𑄜𑄳𑄢𑄬𑄐𑄴𑄌𑄧",
    "cs" to "𑄌𑄬𑄇𑄴",
    "csb" to "𑄇𑄥𑄪𑄝𑄨𑄠𑄚𑄴",
    "cu" to "𑄌𑄢𑄴𑄌𑄴 𑄥𑄳𑄣𑄞𑄨𑄇𑄴",
    "cv" to "𑄌𑄪𑄝𑄥𑄴",
    "cy" to "𑄃𑄮𑄠𑄬𑄣𑄧𑄌𑄴",
    "da" to "𑄓𑄬𑄚𑄨𑄌𑄴",
    "dak" to "𑄓𑄇𑄮𑄑",
    "dar" to "𑄘𑄢𑄴𑄉𑄧𑄤",
    "dav" to "𑄖𑄳𑄆𑄖",
    "de" to "𑄎𑄢𑄴𑄟𑄚𑄴",
    "de-AT" to "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠𑄚𑄴 𑄎𑄢𑄴𑄟𑄚𑄴",
    "de-CH" to "𑄥𑄪𑄃𑄨𑄌𑄴 𑄦𑄭 𑄎𑄢𑄴𑄟𑄚𑄴",
    "del" to "𑄓𑄬𑄣𑄤𑄬𑄢𑄴",
    "den" to "𑄥𑄳𑄣𑄳𑄠𑄞𑄴",
    "dgr" to "𑄘𑄮𑄉𑄳𑄢𑄨𑄝𑄴",
    "din" to "𑄓𑄨𑄁𑄇",
    "dje" to "𑄎𑄢𑄴𑄟",
    "doi" to "𑄓𑄮𑄉𑄧𑄢𑄨",
    "dsb" to "𑄙𑄮𑄣𑄴𑄚𑄬𑄭𑄙𑄳𑄠𑄬 𑄥𑄮𑄢𑄴𑄝𑄨𑄠𑄚𑄴",
    "dua" to "𑄘𑄱𑄣",
    "dum" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄓𑄌𑄴",
    "dv" to "𑄘𑄨𑄝𑄬𑄦𑄨",
    "dyo" to "𑄎𑄧𑄣-𑄜𑄧𑄚𑄩",
    "dyu" to "𑄓𑄨𑄃𑄪𑄣",
    "dz" to "𑄎𑄮𑄋𑄴𑄉",
    "dzg" to "𑄘𑄉𑄎",
    "ebu" to "𑄃𑄬𑄟𑄳𑄝𑄪𑄪",
    "ee" to "𑄃𑄨𑄅𑄠𑄨",
    "efi" to "𑄆𑄜𑄨𑄇𑄴",
    "egy" to "𑄛𑄪𑄢𑄨𑄚𑄩 𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄧",
    "eka" to "𑄃𑄨𑄇𑄎𑄪𑄇𑄴",
    "el" to "𑄉𑄳𑄢𑄨𑄇𑄴",
    "elx" to "𑄆𑄣𑄟𑄭𑄖𑄴",
    "en" to "𑄃𑄨𑄁𑄢𑄨𑄎𑄨",
    "en-AU" to "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨",
    "en-CA" to "𑄇𑄚𑄓𑄩𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨",
    "en-GB" to "𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄨",
    "en-GB-alt-short" to "𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄨",
    "en-US" to "𑄃𑄟𑄬𑄢𑄨𑄇𑄢𑄴 𑄃𑄨𑄁𑄢𑄎𑄨",
    "en-US-alt-short" to "𑄃𑄨𑄅𑄪𑄃𑄬𑄌𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄨",
    "enm" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨",
    "eo" to "𑄆𑄥𑄴𑄛𑄬𑄢𑄚𑄴𑄖𑄮",
    "es" to "𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴",
    "es-419" to "𑄣𑄳𑄠𑄑𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇𑄚𑄴 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴",
    "es-ES" to "𑄄𑄅𑄢𑄮𑄛𑄩𑄠𑄧 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴",
    "es-MX" to "𑄟𑄳𑄠𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴",
    "et" to "𑄆𑄌𑄴𑄖𑄨𑄚𑄩𑄠𑄧",
    "eu" to "𑄝𑄌𑄴𑄇𑄧",
    "ewo" to "𑄄𑄃𑄮𑄚𑄴𑄓𑄮",
    "fa" to "𑄜𑄢𑄴𑄥𑄨",
    "fan" to "𑄜𑄳𑄠𑄋𑄴𑄉𑄧",
    "fat" to "𑄜𑄚𑄴𑄖𑄨",
    "ff" to "𑄜𑄪𑄣𑄳𑄦",
    "fi" to "𑄜𑄨𑄚𑄨𑄌𑄴",
    "fil" to "𑄜𑄨𑄣𑄨𑄛𑄨𑄚𑄮",
    "fj" to "𑄜𑄨𑄎𑄨𑄠𑄚𑄴",
    "fo" to "𑄜𑄢𑄮𑄌𑄴",
    "fon" to "𑄜𑄧𑄚𑄴",
    "fr" to "𑄜𑄧𑄢𑄥𑄨",
    "fr-CA" to "𑄇𑄚𑄓𑄩𑄠𑄧 𑄜𑄧𑄢𑄥𑄨",
    "fr-CH" to "𑄥𑄪𑄃𑄨𑄌𑄴 𑄜𑄧𑄢𑄥𑄨",
    "frm" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄜𑄧𑄢𑄥𑄨",
    "fro" to "𑄛𑄪𑄢𑄮𑄚𑄨 𑄜𑄧𑄢𑄥𑄨",
    "frr" to "𑄅𑄖𑄴𑄗𑄧𑄢𑄴 𑄎𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄚𑄴",
    "frs" to "𑄛𑄪𑄉𑄮 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄧",
    "fur" to "𑄜𑄳𑄢𑄨𑄃𑄪𑄣𑄨𑄠𑄚𑄴",
    "fy" to "𑄛𑄧𑄎𑄨𑄟𑄴 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄚𑄴",
    "ga" to "𑄃𑄭𑄢𑄨𑄌𑄴",
    "gaa" to "𑄉𑄳𑄃",
    "gag" to "𑄉𑄉𑄃𑄪𑄌𑄴",
    "gan" to "𑄉𑄧𑄚𑄴",
    "gay" to "𑄉𑄧𑄠𑄮",
    "gba" to "𑄝𑄠",
    "gd" to "𑄃𑄨𑄌𑄴𑄇𑄧𑄖𑄴𑄥𑄧-𑄉𑄳𑄠𑄬𑄣𑄨𑄇𑄴",
    "gez" to "𑄉𑄩𑄎𑄴",
    "gil" to "𑄉𑄨𑄣𑄴𑄝𑄢𑄴𑄑𑄨𑄎𑄴",
    "gl" to "𑄉𑄳𑄠𑄣𑄨𑄥𑄨𑄠𑄧",
    "gmh" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧-𑄅𑄪𑄉𑄪𑄢𑄬 𑄎𑄢𑄴𑄟𑄚𑄩",
    "gn" to "𑄉𑄪𑄠𑄢𑄚𑄨",
    "goh" to "𑄛𑄪𑄢𑄮𑄚𑄴 𑄅𑄪𑄉𑄪𑄢𑄬 𑄎𑄢𑄴𑄟𑄚𑄩",
    "gon" to "𑄉𑄮𑄚𑄴𑄓𑄨",
    "gor" to "𑄉𑄢𑄮𑄚𑄴𑄖𑄣𑄮",
    "got" to "𑄉𑄧𑄗𑄨𑄇𑄴",
    "grb" to "𑄉𑄳𑄢𑄬𑄝𑄮",
    "grc" to "𑄛𑄪𑄢𑄮𑄚𑄴 𑄉𑄳𑄢𑄩𑄇𑄴",
    "gsw" to "𑄥𑄪𑄃𑄨𑄌𑄴 𑄥𑄢𑄴𑄟𑄚𑄴",
    "gu" to "𑄉𑄪𑄎𑄴𑄢𑄖𑄨",
    "guz" to "𑄉𑄪𑄥𑄩",
    "gv" to "𑄟𑄳𑄠𑄇𑄴𑄥𑄧",
    "gwi" to "𑄉𑄧𑄃𑄮𑄃𑄨𑄌𑄴𑄃𑄨𑄚𑄴",
    "ha" to "𑄦𑄃𑄪𑄥",
    "hai" to "𑄦𑄭𑄓",
    "hak" to "𑄦𑄧𑄇𑄴",
    "haw" to "𑄦𑄤𑄃𑄨𑄠𑄚𑄴",
    "he" to "𑄦𑄨𑄛𑄴𑄝𑄳𑄢𑄪",
    "hi" to "𑄦𑄨𑄚𑄴𑄓𑄨",
    "hil" to "𑄦𑄨𑄣𑄨𑄉𑄳𑄠𑄠𑄧𑄚𑄮𑄚𑄴",
    "hit" to "𑄦𑄨𑄖𑄨𑄨𑄖𑄴",
    "hmn" to "𑄦𑄳𑄦𑄟𑄮𑄋𑄴",
    "ho" to "𑄦𑄪𑄢𑄨 𑄟𑄮𑄖𑄪",
    "hr" to "𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄩𑄠𑄧",
    "hsb" to "𑄅𑄪𑄉𑄪𑄢𑄬 𑄥𑄮𑄢𑄴𑄥𑄨𑄠𑄚𑄴",
    "hsn" to "Xiang 𑄌𑄨𑄚",
    "ht" to "𑄦𑄭𑄖𑄨𑄠𑄚𑄴",
    "hu" to "𑄦𑄁𑄉𑄬𑄢𑄩𑄠𑄧",
    "hup" to "𑄦𑄪𑄛",
    "hy" to "𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄧",
    "hz" to "𑄦𑄬𑄢𑄬𑄢𑄮",
    "ia" to "𑄃𑄨𑄚𑄴𑄑𑄢𑄴𑄣𑄨𑄁𑄉𑄪𑄠",
    "iba" to "𑄃𑄨𑄝𑄚𑄴",
    "ibb" to "𑄃𑄨𑄝𑄨𑄝𑄨𑄠𑄧",
    "id" to "𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠𑄧",
    "ie" to "𑄃𑄨𑄚𑄴𑄑𑄢𑄴𑄣𑄨𑄁𑄉𑄧",
    "ig" to "𑄃𑄨𑄉𑄴𑄝𑄮",
    "ii" to "𑄥𑄨𑄥𑄪𑄠𑄚𑄴𑄠𑄨",
    "ik" to "𑄃𑄨𑄚𑄪𑄛𑄨𑄠𑄇𑄴",
    "ilo" to "𑄃𑄨𑄣𑄮𑄇𑄮",
    "inh" to "𑄃𑄨𑄁𑄉𑄪𑄌𑄴",
    "io" to "𑄃𑄨𑄓𑄮",
    "is" to "𑄃𑄭𑄌𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄨𑄠𑄧",
    "it" to "𑄃𑄨𑄖𑄣𑄩𑄠𑄧",
    "iu" to "𑄃𑄨𑄚𑄪𑄇𑄴𑄑𑄨𑄑𑄪𑄖𑄴",
    "ja" to "𑄎𑄛𑄚𑄨",
    "jbo" to "𑄣𑄮𑄌𑄴𑄝𑄚𑄴",
    "jgo" to "𑄉𑄮𑄟𑄴𑄝",
    "jmc" to "𑄟𑄇𑄟𑄬",
    "jpr" to "𑄎𑄪𑄘𑄬𑄃𑄮 𑄜𑄢𑄴𑄥𑄨",
    "jrb" to "𑄎𑄪𑄘𑄬𑄃𑄮 𑄃𑄢𑄧𑄝𑄨",
    "jv" to "𑄎𑄞𑄚𑄨𑄎𑄴",
    "ka" to "𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴",
    "kaa" to "𑄇𑄢-𑄇𑄣𑄴𑄛𑄇𑄴",
    "kab" to "𑄇𑄝𑄭𑄣𑄬",
    "kac" to "𑄇𑄌𑄨𑄚𑄴",
    "kaj" to "𑄃𑄧𑄌𑄴𑄎𑄪",
    "kam" to "𑄇𑄟𑄴𑄝",
    "kaw" to "𑄇𑄃𑄪𑄃𑄨",
    "kbd" to "𑄇𑄝𑄢𑄴𑄓𑄨𑄠𑄚𑄴",
    "kcg" to "𑄑𑄃𑄨𑄠𑄛𑄴",
    "kde" to "𑄟𑄇𑄮𑄚𑄴𑄘𑄬",
    "kea" to "𑄇𑄝𑄪𑄞𑄢𑄴𑄘𑄨𑄠𑄚𑄪",
    "kfo" to "𑄇𑄮𑄢𑄮",
    "kg" to "𑄇𑄧𑄁𑄉𑄮",
    "kha" to "𑄈𑄥𑄨",
    "kho" to "𑄈𑄮𑄑𑄚𑄨𑄎𑄴",
    "khq" to "𑄇𑄮𑄠𑄧𑄢 𑄌𑄩𑄚𑄨",
    "ki" to "𑄇𑄨𑄇𑄪𑄠𑄪",
    "kj" to "𑄇𑄮𑄠𑄚𑄨𑄠𑄟",
    "kk" to "𑄇𑄎𑄇𑄴",
    "kkj" to "𑄇𑄇𑄮",
    "kl" to "𑄇𑄳𑄠𑄣𑄣𑄴𑄣𑄨𑄥𑄪𑄖𑄴",
    "kln" to "𑄇𑄣𑄬𑄚𑄴𑄎𑄨𑄚𑄴",
    "km" to "𑄈𑄧𑄟𑄬𑄢𑄴",
    "kmb" to "𑄇𑄨𑄟𑄴𑄝𑄪𑄚𑄴𑄘𑄪",
    "kn" to "𑄇𑄧𑄚𑄴𑄚𑄧𑄢𑄴",
    "ko" to "𑄇𑄮𑄢𑄨𑄠𑄚𑄴",
    "koi" to "𑄇𑄧𑄟𑄨-𑄛𑄢𑄧𑄟𑄨𑄃𑄇𑄴",
    "kok" to "𑄇𑄮𑄋𑄴𑄇𑄚𑄨",
    "kos" to "𑄇𑄮𑄥𑄳𑄢𑄭𑄚𑄴",
    "kpe" to "𑄇𑄴𑄛𑄬𑄣𑄳𑄣𑄬",
    "kr" to "𑄇𑄚𑄪𑄢𑄨",
    "krc" to "𑄇𑄢𑄴𑄌𑄮-𑄝𑄣𑄴𑄇𑄢𑄴",
    "krl" to "𑄇𑄢𑄬𑄣𑄨𑄠𑄚𑄴",
    "kru" to "𑄇𑄪𑄢𑄪𑄇𑄴",
    "ks" to "𑄇𑄌𑄴𑄟𑄨𑄢𑄨",
    "ksb" to "𑄥𑄟𑄴𑄝𑄣",
    "ksf" to "𑄝𑄜𑄨𑄠",
    "ksh" to "𑄇𑄣𑄴𑄥𑄧",
    "ku" to "𑄇𑄪𑄢𑄴𑄘𑄨𑄥𑄴",
    "kum" to "𑄇𑄪𑄟𑄨𑄇𑄴",
    "kut" to "𑄇𑄪𑄑𑄬𑄚𑄭",
    "kv" to "𑄇𑄮𑄟𑄨",
    "kw" to "𑄇𑄧𑄢𑄴𑄚𑄨𑄌𑄴",
    "ky" to "𑄇𑄨𑄢𑄴𑄉𑄨𑄌𑄴",
    "la" to "𑄣𑄑𑄨𑄚𑄴",
    "lad" to "𑄣𑄓𑄨𑄚𑄮",
    "lag" to "𑄣𑄋𑄴𑄉𑄨",
    "lah" to "𑄣𑄚𑄴𑄓",
    "lam" to "𑄣𑄟𑄴𑄝",
    "lb" to "𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄩𑄠𑄧",
    "lez" to "𑄣𑄬𑄎𑄴𑄊𑄨𑄠𑄚𑄴",
    "lg" to "𑄉𑄚𑄴𑄓",
    "li" to "𑄣𑄨𑄟𑄴𑄝𑄪𑄢𑄴𑄉𑄨𑄌𑄴",
    "lkt" to "𑄣𑄇𑄮𑄑",
    "ln" to "𑄣𑄨𑄋𑄴𑄉𑄣",
    "lo" to "𑄣𑄃𑄮",
    "lol" to "𑄟𑄮𑄋𑄴𑄉𑄮",
    "loz" to "𑄣𑄮𑄎𑄨",
    "lrc" to "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄣𑄪𑄢𑄨",
    "lt" to "𑄣𑄨𑄗𑄪𑄠𑄬𑄚𑄩𑄠𑄧",
    "lu" to "𑄣𑄪𑄝-𑄇𑄑𑄋𑄴𑄉",
    "lua" to "𑄣𑄪𑄝-𑄣𑄪𑄣𑄪𑄠",
    "lui" to "𑄣𑄭𑄪𑄥𑄬𑄚𑄮",
    "lun" to "𑄣𑄪𑄚𑄴𑄓",
    "luo" to "𑄣𑄪𑄠𑄮",
    "lus" to "𑄟𑄨𑄎𑄮",
    "luy" to "𑄣𑄭𑄪𑄠",
    "lv" to "𑄣𑄖𑄴𑄞𑄩𑄠𑄧",
    "mad" to "𑄟𑄘𑄪𑄢𑄬𑄥𑄬",
    "mag" to "𑄟𑄉𑄦𑄨",
    "mai" to "𑄟𑄳𑄆𑄧𑄗𑄨𑄣𑄨",
    "mak" to "𑄟𑄳𑄠𑄇𑄥𑄢𑄴",
    "man" to "𑄟𑄳𑄠𑄚𑄴𑄓𑄨𑄁𑄉𑄮",
    "mas" to "𑄟𑄥𑄭",
    "mdf" to "𑄟𑄮𑄇𑄴𑄥",
    "mdr" to "𑄟𑄳𑄠𑄚𑄴𑄓𑄢𑄴",
    "men" to "𑄟𑄬𑄚𑄴𑄓𑄬",
    "mer" to "𑄟𑄬𑄢𑄪",
    "mfe" to "𑄟𑄢𑄨𑄥𑄨𑄠𑄚𑄴",
    "mg" to "𑄟𑄣𑄉𑄥𑄨",
    "mga" to "𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄭𑄢𑄨𑄌𑄴",
    "mgh" to "𑄟𑄈𑄪𑄠-𑄟𑄬𑄖𑄴𑄖𑄮",
    "mgo" to "𑄟𑄬𑄑",
    "mh" to "𑄟𑄢𑄴𑄥𑄣𑄨𑄎𑄴",
    "mi" to "𑄟𑄃𑄮𑄢𑄨",
    "mic" to "𑄟𑄨𑄇𑄟𑄳𑄠𑄇𑄴",
    "min" to "𑄟𑄨𑄚𑄋𑄴𑄇𑄝𑄃𑄪",
    "mk" to "𑄟𑄳𑄠𑄥𑄨𑄓𑄮𑄚𑄩𑄠𑄧",
    "ml" to "𑄟𑄣𑄠𑄣𑄟𑄴",
    "mn" to "𑄟𑄧𑄁𑄉𑄮𑄣𑄨𑄠𑄧",
    "mnc" to "𑄟𑄚𑄴𑄌𑄪",
    "mni" to "𑄟𑄚𑄨𑄛𑄪𑄢𑄩",
    "moh" to "𑄟𑄮𑄦𑄃𑄮𑄇𑄴",
    "mos" to "𑄟𑄧𑄥𑄨",
    "mr" to "𑄟𑄢𑄒𑄨",
    "ms" to "𑄟𑄣𑄧𑄠𑄴",
    "mt" to "𑄟𑄧𑄣𑄴𑄑𑄨𑄠𑄧",
    "mua" to "𑄟𑄪𑄘𑄋𑄴𑄉𑄧",
    "mul" to "𑄝𑄣𑄧𑄇𑄴𑄇𑄚𑄨 𑄞𑄌𑄴",
    "mus" to "𑄇𑄳𑄢𑄨𑄇𑄴",
    "mwl" to "𑄟𑄨𑄢𑄚𑄴𑄓𑄨𑄎𑄴",
    "mwr" to "𑄟𑄢𑄮𑄠𑄢𑄨",
    "my" to "𑄝𑄧𑄢𑄴𑄟𑄨",
    "myv" to "𑄆𑄢𑄧𑄎𑄨𑄠",
    "mzn" to "𑄟𑄎𑄚𑄴𑄘𑄬𑄢𑄚𑄨",
    "na" to "𑄚𑄃𑄪𑄢𑄪",
    "nan" to "𑄚𑄚𑄴",
    "nap" to "𑄚𑄬𑄠𑄛𑄮𑄣𑄨𑄑𑄚𑄴",
    "naq" to "𑄚𑄟",
    "nb" to "𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄨𑄠𑄚𑄴 𑄝𑄮𑄇𑄴𑄟𑄣𑄴",
    "nd" to "𑄅𑄖𑄴𑄖𑄧𑄢𑄴 𑄆𑄚𑄴𑄘𑄬𑄝𑄨𑄣𑄨",
    "nds" to "𑄖𑄧𑄣𑄬 𑄎𑄢𑄴𑄟𑄚𑄨",
    "nds-NL" to "𑄣𑄮𑄥𑄳𑄠𑄇𑄴𑄥𑄧𑄚𑄴",
    "ne" to "𑄚𑄬𑄛𑄣𑄨",
    "new" to "𑄚𑄬𑄃𑄮𑄠𑄢𑄨",
    "ng" to "𑄆𑄚𑄴𑄘𑄮𑄋𑄴𑄉",
    "nia" to "𑄚𑄨𑄠𑄌𑄴",
    "niu" to "𑄚𑄨𑄃𑄪𑄠𑄚𑄴",
    "nl" to "𑄓𑄌𑄴",
    "nl-BE" to "𑄜𑄳𑄣𑄬𑄟𑄨𑄌𑄴",
    "nmg" to "𑄇𑄱𑄥𑄨𑄃𑄮",
    "nn" to "𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄩𑄠𑄚𑄴 𑄚𑄨𑄚𑄧𑄢𑄴𑄥𑄳𑄇𑄴",
    "nnh" to "𑄚𑄨𑄋𑄴𑄉𑄬𑄟𑄴𑄝𑄪𑄚𑄴",
    "no" to "𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄩𑄠𑄧",
    "nog" to "𑄚𑄮𑄉𑄭",
    "non" to "𑄛𑄪𑄢𑄮𑄚𑄴 𑄚𑄧𑄢𑄴𑄥𑄧",
    "nqo" to "𑄆𑄚𑄴𑄇𑄮",
    "nr" to "𑄓𑄧𑄉𑄨𑄚𑄴 𑄆𑄚𑄴𑄓𑄬𑄝𑄬𑄣𑄬",
    "nso" to "𑄃𑄪𑄖𑄴𑄗𑄧𑄢𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄮𑄗𑄮",
    "nus" to "𑄚𑄪𑄠𑄢𑄴",
    "nv" to "𑄚𑄞𑄎𑄮",
    "nwc" to "𑄛𑄪𑄢𑄮𑄚𑄴 𑄚𑄬𑄃𑄮𑄠𑄢𑄩",
    "ny" to "𑄚𑄠𑄚𑄴𑄎",
    "nym" to "𑄚𑄳𑄠𑄠𑄟𑄴𑄃𑄮𑄠𑄬𑄎𑄨",
    "nyn" to "𑄚𑄳𑄠𑄠𑄋𑄴𑄇𑄮𑄣𑄬",
    "nyo" to "𑄚𑄧𑄱𑄢𑄮",
    "nzi" to "𑄆𑄚𑄴𑄎𑄨𑄟",
    "oc" to "𑄃𑄧𑄇𑄴𑄥𑄨𑄑𑄚𑄴",
    "oj" to "𑄃𑄮𑄎𑄨𑄝𑄧𑄤",
    "om" to "𑄃𑄧𑄢𑄮𑄟𑄮",
    "or" to "𑄃𑄮𑄢𑄨𑄠",
    "os" to "𑄃𑄮𑄥𑄬𑄑𑄨𑄇𑄴",
    "osa" to "𑄃𑄮𑄥𑄬𑄌𑄴",
    "ota" to "𑄃𑄧𑄑𑄮𑄟𑄚𑄴 𑄖𑄪𑄢𑄴𑄇𑄨",
    "pa" to "𑄛𑄚𑄴𑄎𑄝𑄩",
    "pag" to "𑄛𑄁𑄉𑄥𑄨𑄚𑄚𑄴",
    "pal" to "𑄛𑄦𑄳𑄣𑄞𑄨",
    "pam" to "𑄛𑄟𑄴𑄛𑄋𑄴𑄉",
    "pap" to "𑄛𑄛𑄨𑄠𑄟𑄬𑄚𑄴𑄖𑄮",
    "pau" to "𑄛𑄣𑄠𑄪𑄠𑄚𑄴",
    "pcm" to "𑄚𑄎𑄬𑄢𑄨𑄠𑄧 𑄛𑄨𑄎𑄨𑄚𑄴",
    "peo" to "𑄛𑄪𑄢𑄮𑄚𑄴 𑄜𑄢𑄴𑄥𑄨",
    "phn" to "𑄜𑄮𑄚𑄨𑄥𑄨𑄠𑄚𑄴",
    "pi" to "𑄛𑄣𑄨",
    "pl" to "𑄛𑄮𑄣𑄨𑄌𑄴",
    "pon" to "𑄛𑄮𑄚𑄴𑄦𑄧𑄛𑄳𑄆𑄬𑄠𑄚𑄴",
    "prg" to "𑄛𑄴𑄢𑄪𑄥𑄨𑄠𑄚𑄴",
    "pro" to "𑄛𑄪𑄢𑄮𑄚𑄴 𑄛𑄳𑄢𑄮𑄞𑄬𑄚𑄴𑄥𑄣𑄴",
    "ps" to "𑄛𑄌𑄴𑄑𑄪",
    "ps-alt-variant" to "𑄛𑄪𑄌𑄴𑄖𑄮",
    "pt" to "𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴",
    "pt-BR" to "𑄝𑄳𑄢𑄎𑄨𑄣𑄬𑄢𑄴 𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴",
    "pt-PT" to "𑄃𑄨𑄃𑄪𑄢𑄮𑄛𑄬𑄢𑄴 𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴",
    "qu" to "𑄇𑄬𑄌𑄪𑄠",
    "quc" to "𑄇𑄳𑄦𑄨𑄌𑄬",
    "raj" to "𑄢𑄎𑄴𑄥𑄳𑄦𑄚𑄨",
    "rap" to "𑄢𑄛𑄚𑄳𑄆𑄪",
    "rar" to "𑄢𑄢𑄮𑄑𑄮𑄁𑄉𑄚𑄴",
    "rm" to "𑄢𑄮𑄟𑄚𑄴𑄥𑄴",
    "rn" to "𑄢𑄪𑄚𑄴𑄘𑄨",
    "ro" to "𑄢𑄮𑄟𑄚𑄩𑄠𑄧",
    "ro-MD" to "𑄟𑄧𑄣𑄴𑄘𑄞𑄨𑄠𑄧",
    "rof" to "𑄢𑄧𑄟𑄴𑄝𑄮",
    "rom" to "𑄢𑄮𑄟𑄚𑄨",
    "ru" to "𑄢𑄪𑄌𑄴",
    "rup" to "𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄚𑄴",
    "rw" to "𑄇𑄨𑄚𑄴𑄠𑄢𑄮𑄠𑄚𑄴𑄓",
    "rwk" to "𑄢𑄤",
    "sa" to "𑄥𑄧𑄁𑄥𑄴𑄇𑄳𑄢𑄨𑄖𑄴",
    "sad" to "𑄥𑄳𑄠𑄚𑄴𑄓𑄃𑄮𑄠𑄬",
    "sah" to "𑄥𑄈",
    "sam" to "𑄥𑄟𑄢𑄨𑄑𑄚𑄴 𑄃𑄢𑄟𑄨𑄇𑄴",
    "saq" to "𑄥𑄟𑄴𑄝𑄪𑄢𑄪",
    "sas" to "𑄥𑄥𑄇𑄴",
    "sat" to "𑄥𑄀𑄃𑄮𑄖𑄣𑄨",
    "sba" to "𑄚𑄳𑄠𑄉𑄟𑄴𑄝𑄬",
    "sbp" to "𑄥𑄁𑄚𑄴𑄉𑄪",
    "sc" to "𑄥𑄢𑄴𑄓𑄨𑄚𑄨𑄠𑄚𑄴",
    "scn" to "𑄥𑄨𑄥𑄨𑄣𑄨𑄠𑄚𑄴",
    "sco" to "𑄆𑄌𑄴𑄇𑄧𑄖𑄴𑄥𑄴",
    "sd" to "𑄥𑄨𑄚𑄴𑄙𑄨",
    "sdh" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴",
    "se" to "𑄅𑄖𑄴𑄖𑄧𑄢𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄟𑄨",
    "seh" to "𑄥𑄬𑄚",
    "sel" to "𑄥𑄬𑄣𑄴𑄇𑄪𑄛𑄴",
    "ses" to "𑄇𑄱𑄢𑄝𑄬𑄚𑄮 𑄥𑄬𑄚𑄳𑄚𑄨",
    "sg" to "𑄥𑄋𑄴𑄉𑄮",
    "sga" to "𑄛𑄪𑄢𑄮𑄚𑄴 𑄃𑄭𑄢𑄨𑄌𑄴",
    "sh" to "𑄥𑄢𑄴𑄝𑄮-𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠𑄧",
    "shi" to "𑄖𑄌𑄬𑄣𑄴𑄦𑄨𑄖𑄴",
    "shn" to "𑄥𑄚𑄴",
    "si" to "𑄥𑄨𑄁𑄦𑄧𑄣𑄩",
    "sid" to "𑄥𑄨𑄓𑄟𑄮",
    "sk" to "𑄥𑄳𑄣𑄮𑄞𑄇𑄴",
    "sl" to "𑄥𑄳𑄣𑄮𑄞𑄬𑄚𑄩𑄠𑄧",
    "sm" to "𑄥𑄟𑄮𑄠𑄚𑄴",
    "sma" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄟𑄨",
    "smj" to "𑄣𑄪𑄣𑄬 𑄥𑄟𑄨",
    "smn" to "𑄃𑄨𑄚𑄢𑄨 𑄥𑄟𑄨",
    "sms" to "𑄥𑄳𑄇𑄧𑄣𑄳𑄑𑄧 𑄥𑄟𑄨",
    "sn" to "𑄥𑄮𑄚",
    "snk" to "𑄥𑄮𑄚𑄨𑄋𑄴𑄇𑄬",
    "so" to "𑄥𑄮𑄟𑄣𑄨",
    "sog" to "𑄥𑄮𑄇𑄴𑄓𑄠𑄚𑄴",
    "sq" to "𑄃𑄣𑄴𑄝𑄬𑄚𑄩𑄠𑄧",
    "sr" to "𑄥𑄢𑄴𑄝𑄩𑄠𑄧",
    "srn" to "𑄥𑄳𑄢𑄚𑄚𑄴 𑄑𑄮𑄋𑄴𑄉𑄮",
    "srr" to "𑄥𑄬𑄢𑄬𑄢𑄴",
    "ss" to "𑄥𑄮𑄠𑄖𑄨",
    "ssy" to "𑄥𑄦𑄮",
    "st" to "𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄮𑄗𑄮",
    "su" to "𑄥𑄪𑄘𑄚𑄩",
    "suk" to "𑄥𑄪𑄇𑄪𑄟",
    "sus" to "𑄥𑄪𑄥𑄪",
    "sux" to "𑄥𑄪𑄟𑄬𑄢𑄩𑄠𑄧",
    "sv" to "𑄥𑄭𑄪𑄓𑄨𑄥𑄴",
    "sw" to "𑄥𑄱𑄦𑄨𑄣𑄨",
    "sw-CD" to "𑄇𑄧𑄋𑄴𑄉𑄮 𑄥𑄱𑄦𑄨𑄣𑄨",
    "swb" to "𑄇𑄧𑄟𑄮𑄢𑄨𑄠𑄚𑄴",
    "syc" to "𑄛𑄪𑄢𑄮𑄚𑄴 𑄥𑄨𑄢𑄨𑄃𑄮",
    "syr" to "𑄥𑄨𑄢𑄨𑄠𑄇𑄴",
    "ta" to "𑄖𑄟𑄨𑄣𑄴",
    "te" to "𑄖𑄬𑄣𑄬𑄉𑄪",
    "tem" to "𑄑𑄭𑄟𑄴𑄚𑄬",
    "teo" to "𑄖𑄬𑄥𑄮",
    "ter" to "𑄖𑄬𑄢𑄬𑄚𑄮",
    "tet" to "𑄖𑄬𑄖𑄪𑄟𑄴",
    "tg" to "𑄖𑄎𑄨𑄇𑄴",
    "th" to "𑄗𑄭",
    "ti" to "𑄖𑄨𑄉𑄧𑄢𑄨𑄚𑄨𑄠",
    "tig" to "𑄑𑄭𑄉𑄳𑄢𑄬",
    "tiv" to "𑄑𑄨𑄞𑄴",
    "tk" to "𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨",
    "tkl" to "𑄑𑄮𑄇𑄬𑄣𑄃𑄪",
    "tl" to "𑄖𑄉𑄣𑄧𑄇𑄴",
    "tlh" to "𑄇𑄳𑄣𑄨𑄋𑄴𑄉𑄧𑄚𑄴",
    "tli" to "𑄖𑄴𑄣𑄨𑄋𑄴𑄉𑄨𑄖𑄴",
    "tmh" to "𑄖𑄟𑄥𑄬𑄇𑄴",
    "tn" to "𑄥𑄱𑄚",
    "to" to "𑄑𑄮𑄋𑄴𑄉𑄚𑄴",
    "tog" to "𑄚𑄠𑄥𑄑𑄮𑄋𑄴𑄉",
    "tpi" to "𑄑𑄮𑄇𑄴 𑄛𑄨𑄥𑄨𑄚𑄴",
    "tr" to "𑄖𑄪𑄢𑄴𑄇𑄩",
    "trv" to "𑄖𑄢𑄮𑄇𑄮",
    "ts" to "𑄥𑄧𑄋𑄴𑄉",
    "tsi" to "𑄥𑄨𑄟𑄴𑄥𑄨𑄠𑄚𑄴",
    "tt" to "𑄖𑄖𑄢𑄴",
    "tum" to "𑄖𑄪𑄟𑄴𑄝𑄪𑄇",
    "tvl" to "𑄑𑄪𑄞𑄣𑄪",
    "tw" to "𑄑𑄮𑄠𑄭",
    "twq" to "𑄖𑄥𑄤𑄇𑄴",
    "ty" to "𑄖𑄦𑄨𑄖𑄨𑄠𑄚𑄴",
    "tyv" to "𑄑𑄪𑄞𑄨𑄚𑄨𑄠𑄚𑄴",
    "tzm" to "𑄥𑄬𑄚𑄴𑄑𑄳𑄢𑄣𑄴 𑄃𑄣𑄴𑄖𑄌𑄴 𑄖𑄟𑄎𑄨𑄉𑄖𑄴",
    "udm" to "𑄃𑄪𑄓𑄴𑄟𑄪𑄢𑄴𑄑𑄧",
    "ug" to "𑄃𑄪𑄃𑄨𑄊𑄪𑄢𑄴",
    "uga" to "𑄃𑄪𑄉𑄢𑄨𑄑𑄨𑄇𑄴",
    "uk" to "𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄬𑄚𑄩𑄠𑄧",
    "umb" to "𑄃𑄪𑄟𑄴𑄝𑄪𑄚𑄴𑄘𑄪",
    "und" to "𑄦𑄧𑄝𑄧𑄢𑄴 𑄚𑄧𑄛𑄬𑄠𑄬 𑄞𑄌𑄴",
    "ur" to "𑄃𑄪𑄢𑄴𑄘𑄪",
    "uz" to "𑄃𑄪𑄎𑄴𑄝𑄬𑄇𑄩𑄠𑄧",
    "vai" to "𑄞𑄭",
    "ve" to "𑄞𑄬𑄚𑄴𑄓",
    "vi" to "𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄩",
    "vo" to "𑄞𑄮𑄣𑄛𑄪𑄇𑄴",
    "vot" to "𑄞𑄮𑄑𑄨𑄇𑄴",
    "vun" to "𑄞𑄪𑄚𑄴𑄏𑄮",
    "wa" to "𑄤𑄣𑄪𑄚𑄴",
    "wae" to "𑄤𑄣𑄧𑄥𑄬𑄢𑄴",
    "wal" to "𑄤𑄣𑄟𑄮",
    "war" to "𑄤𑄢𑄬",
    "was" to "𑄤𑄥𑄮",
    "wbp" to "𑄤𑄢𑄴𑄣𑄴𑄛𑄨𑄢𑄨",
    "wo" to "𑄤𑄃𑄮𑄣𑄮𑄜𑄴",
    "wuu" to "𑄤𑄌𑄨𑄚",
    "xal" to "𑄇𑄣𑄴𑄟𑄳𑄆𑄧𑄇𑄴",
    "xh" to "𑄎𑄮𑄥",
    "xog" to "𑄥𑄮𑄉",
    "yao" to "𑄃𑄨𑄠𑄃𑄮",
    "yap" to "𑄃𑄨𑄠𑄛𑄬𑄥𑄬",
    "yav" to "𑄠𑄋𑄴𑄉𑄧𑄝𑄬𑄚𑄴",
    "ybb" to "𑄠𑄮𑄟𑄴𑄝",
    "yi" to "𑄠𑄨𑄖𑄴𑄘𑄨𑄥𑄴",
    "yo" to "𑄃𑄨𑄃𑄮𑄢𑄪𑄝",
    "yue" to "𑄇𑄳𑄠𑄚𑄴𑄑𑄮𑄚𑄩𑄎𑄴",
    "yue-alt-menu" to "𑄇𑄳𑄠𑄚𑄴𑄑𑄮𑄚𑄩𑄎𑄴",
    "za" to "𑄏𑄪𑄠𑄋𑄴",
    "zap" to "𑄎𑄛𑄮𑄑𑄬𑄇𑄴",
    "zbl" to "𑄃𑄉𑄬𑄠 𑄞𑄌𑄴",
    "zen" to "𑄎𑄬𑄚𑄉",
    "zgh" to "𑄉𑄧𑄟𑄴𑄘𑄮𑄣𑄴 𑄟𑄧𑄢𑄧𑄇𑄧𑄧𑄱𑄚𑄴𑄖𑄟𑄎𑄨𑄉𑄖𑄴",
    "zh" to "𑄌𑄩𑄚",
    "zh-alt-menu" to "𑄌𑄩𑄚",
    "zh-Hans" to "𑄅𑄪𑄎𑄪𑄅𑄪𑄏𑄫 𑄌𑄩𑄚",
    "zh-Hans-alt-long" to "𑄅𑄪𑄎𑄪𑄅𑄪𑄏𑄫 𑄌𑄩𑄚",
    "zh-Hant" to "𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄌𑄩𑄚",
    "zh-Hant-alt-long" to "𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄌𑄩𑄚",
    "zu" to "𑄎𑄪𑄣𑄪",
    "zun" to "𑄎𑄪𑄚𑄨",
    "zxx" to "𑄞𑄏𑄧𑄢𑄴𑄘𑄮𑄇𑄳𑄠𑄬 𑄝𑄨𑄥𑄧𑄠𑄴 𑄚𑄳𑄄𑄬",
    "zza" to "𑄎𑄎",
  ) }

  val ccp_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ce: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "афарийн",
    "ab" to "абхазхойн",
    "ace" to "ачехийн",
    "ada" to "адангме",
    "ady" to "адигейн",
    "af" to "африкаанс",
    "agq" to "агхӀем",
    "ain" to "айнийн",
    "ak" to "акан",
    "ale" to "алеутийн",
    "alt" to "къилба алтайн",
    "am" to "амхаройн",
    "an" to "арагонойн",
    "anp" to "ангика",
    "ar" to "Ӏаьрбийн",
    "ar-001" to "ХӀинца болу стандартан Ӏаьрбийн",
    "arn" to "арауканхойн",
    "arp" to "арапахо",
    "as" to "ассамийн",
    "asa" to "асу",
    "ast" to "астурийн",
    "av" to "суьйлийн",
    "awa" to "авадхи",
    "ay" to "аймара",
    "az" to "азербайджанийн",
    "az-alt-short" to "азербайджанийн",
    "ba" to "башкирийн",
    "ban" to "балийн",
    "bas" to "баса",
    "be" to "белорусийн",
    "bem" to "бемба",
    "bez" to "бена",
    "bg" to "болгарийн",
    "bgn" to "малхбузен-белуджийн",
    "bho" to "бходжпури",
    "bi" to "бислама",
    "bin" to "бини",
    "bla" to "сиксика",
    "bm" to "бамбара",
    "bn" to "бенгалийн",
    "bo" to "тибетхойн",
    "br" to "бретонийн",
    "brx" to "бодо",
    "bs" to "боснийн",
    "bug" to "бугийн",
    "byn" to "билийн",
    "ca" to "каталонийн",
    "ce" to "нохчийн",
    "ceb" to "себуано",
    "cgg" to "чига",
    "ch" to "чаморро",
    "chk" to "чукчийн",
    "chm" to "марийн",
    "cho" to "чоктавийн",
    "chr" to "чероки",
    "chy" to "шайенийн",
    "ckb" to "юккъерчу курдийн",
    "ckb-alt-menu" to "юккъерчу курдийн",
    "ckb-alt-variant" to "юккъерчу курдийн",
    "co" to "корсиканийн",
    "crs" to "сейшелийн креолийн",
    "cs" to "чехийн",
    "cu" to "килсславянийн",
    "cv" to "чувашийн",
    "cy" to "валлийн",
    "da" to "датхойн",
    "dak" to "дакота",
    "dar" to "даьргӀойн",
    "dav" to "таита",
    "de" to "немцойн",
    "de-AT" to "австрин немцойн",
    "de-CH" to "швейцарин литературин немцойн",
    "dgr" to "догриб",
    "dje" to "зарма",
    "dsb" to "сорбийн",
    "dua" to "дуала",
    "dv" to "мальдивийн",
    "dyo" to "дьола-фоньи",
    "dz" to "дзонг-кэ",
    "dzg" to "даза",
    "ebu" to "эмбу",
    "ee" to "эве",
    "efi" to "эфик",
    "eka" to "экаджук",
    "el" to "грекийн",
    "en" to "ингалсан",
    "en-AU" to "Австралин ингалсан",
    "en-CA" to "канадан ингалсан",
    "en-GB" to "британин ингалсан",
    "en-GB-alt-short" to "ингалсан (Британи)",
    "en-US" to "американ ингалсан",
    "en-US-alt-short" to "ингалсан (АЦШ)",
    "eo" to "эсперанто",
    "es" to "испанхойн",
    "es-419" to "латинан американ испанхойн",
    "es-ES" to "европан испанхойн",
    "es-MX" to "мексикан испанхойн",
    "et" to "эстонийн",
    "eu" to "баскийн",
    "ewo" to "эвондо",
    "fa" to "гӀажарийн",
    "ff" to "фулах",
    "fi" to "финнийн",
    "fil" to "филиппинийн",
    "fj" to "фиджи",
    "fo" to "фарерийн",
    "fon" to "фон",
    "fr" to "французийн",
    "fr-CA" to "канадан французийн",
    "fr-CH" to "швейцарин французийн",
    "fur" to "фриулийн",
    "fy" to "малхбузен-фризийн",
    "ga" to "ирландхойн",
    "gaa" to "га",
    "gag" to "гагаузийн",
    "gd" to "гэлийн",
    "gez" to "геэз",
    "gil" to "гильбертийн",
    "gl" to "галисийн",
    "gn" to "гуарани",
    "gor" to "горонтало",
    "gsw" to "швейцарин немцойн",
    "gu" to "гуджарати",
    "guz" to "гусии",
    "gv" to "мэнийн",
    "gwi" to "гвичин",
    "ha" to "хауса",
    "haw" to "гавайн",
    "he" to "жугтийн",
    "hi" to "хӀинди",
    "hil" to "хилигайнон",
    "hmn" to "хмонг",
    "hr" to "хорватийн",
    "hsb" to "лакхара сербийн",
    "ht" to "гаитийн",
    "hu" to "венгрийн",
    "hup" to "хупа",
    "hy" to "эрмалойн",
    "hz" to "гереро",
    "ia" to "интерлингва",
    "iba" to "ибанийн",
    "ibb" to "ибибио",
    "id" to "индонезихойн",
    "ig" to "игбо",
    "ii" to "сычуань",
    "ilo" to "илоко",
    "inh" to "гӀалгӀайн",
    "io" to "идо",
    "is" to "исландхойн",
    "it" to "итальянийн",
    "iu" to "инуктитут",
    "ja" to "японийн",
    "jbo" to "ложбан",
    "jgo" to "нгомба",
    "jmc" to "мачаме",
    "jv" to "яванийн",
    "ka" to "гуьржийн",
    "kab" to "кабилийн",
    "kac" to "качинийн",
    "kaj" to "каджи",
    "kam" to "камба",
    "kbd" to "гӀебартойн",
    "kcg" to "тьяп",
    "kde" to "маконде",
    "kea" to "кабувердьяну",
    "kfo" to "коро",
    "kha" to "кхаси",
    "khq" to "койра чиини",
    "ki" to "кикуйю",
    "kj" to "кунама",
    "kk" to "кхазакхийн",
    "kkj" to "како",
    "kl" to "гренландхойн",
    "kln" to "календжин",
    "km" to "кхмерийн",
    "kmb" to "кимбунду",
    "kn" to "каннада",
    "ko" to "корейн",
    "koi" to "коми-пермякийн",
    "kok" to "конкани",
    "kpe" to "кпелле",
    "kr" to "канури",
    "krc" to "кхарачойн-балкхаройн",
    "krl" to "карелийн",
    "kru" to "курух",
    "ks" to "кашмири",
    "ksb" to "шамбала",
    "ksf" to "бафиа",
    "ksh" to "коьлнийн",
    "ku" to "курдийн",
    "kum" to "гӀумкийн",
    "kv" to "комийн",
    "kw" to "корнуоллийн",
    "ky" to "гӀиргӀизойн",
    "la" to "латинан",
    "lad" to "ладино",
    "lag" to "ланги",
    "lb" to "люксембургхойн",
    "lez" to "лаьзгийн",
    "lg" to "ганда",
    "li" to "лимбургийн",
    "lkt" to "лакота",
    "ln" to "лингала",
    "lo" to "лаоссийн",
    "loz" to "лози",
    "lrc" to "къилбаседа лури",
    "lt" to "литвахойн",
    "lu" to "луба-катанга",
    "lua" to "луба-лулуа",
    "lun" to "лунда",
    "luo" to "луо (Кени а, Танзани а)",
    "lus" to "лушей",
    "luy" to "лухья",
    "lv" to "латышийн",
    "mad" to "мадурийн",
    "mag" to "магахи",
    "mai" to "майтхили",
    "mak" to "макасарийн",
    "mas" to "масаи",
    "mdf" to "мокшанойн",
    "men" to "менде",
    "mer" to "меру",
    "mfe" to "маврикин креолийн",
    "mg" to "малагасийн",
    "mgh" to "макуа-меетто",
    "mgo" to "мета",
    "mh" to "маршаллийн",
    "mi" to "маори",
    "mic" to "микмак",
    "min" to "минангкабау",
    "mk" to "македонхойн",
    "ml" to "малаялам",
    "mn" to "монголийн",
    "mni" to "манипурийн",
    "moh" to "мохаук",
    "mos" to "моси",
    "mr" to "маратхи",
    "ms" to "малайн",
    "mt" to "мальтойн",
    "mua" to "мунданг",
    "mul" to "тайп-тайпа доьзалан меттанаш",
    "mus" to "крик",
    "mwl" to "мирандойн",
    "my" to "бирманийн",
    "myv" to "эрзянийн",
    "mzn" to "мазандеранхойн",
    "na" to "науру",
    "nap" to "неаполитанойн",
    "naq" to "нама",
    "nb" to "норвегийн букмол",
    "nd" to "къилбаседа ндебели",
    "nds" to "лахара германхойн",
    "nds-NL" to "лахара саксонийн",
    "ne" to "непалхойн",
    "new" to "неваройн",
    "ng" to "ндонга",
    "nia" to "ниас",
    "niu" to "ниуэ",
    "nl" to "голландхойн",
    "nl-BE" to "фламандийн",
    "nmg" to "квасио",
    "nn" to "норвегийн нюнорск",
    "nnh" to "нгиембунд",
    "nog" to "ногӀийн",
    "nqo" to "нко",
    "nr" to "къилба ндебеле",
    "nso" to "къилбаседа сото",
    "nus" to "нуэр",
    "nv" to "навахо",
    "ny" to "ньянджа",
    "nyn" to "ньянколе",
    "oc" to "окситанойн",
    "om" to "оромо",
    "or" to "ори",
    "os" to "хӀирийн",
    "pa" to "панджаби",
    "pag" to "пангасинан",
    "pam" to "пампанга",
    "pap" to "папьяменто",
    "pau" to "палау",
    "pcm" to "нигерийн-креолийн",
    "pl" to "полякийн",
    "prg" to "пруссийн",
    "ps" to "пушту",
    "pt" to "португалихойн",
    "pt-BR" to "бразилин португалихойн",
    "pt-PT" to "европан португалихойн",
    "qu" to "кечуа",
    "quc" to "киче",
    "rap" to "рапануйн",
    "rar" to "раротонга",
    "rm" to "романшийн",
    "rn" to "рунди",
    "ro" to "румынийн",
    "ro-MD" to "молдавийн",
    "rof" to "ромбо",
    "ru" to "оьрсийн",
    "rup" to "аруминийн",
    "rw" to "киньяруанда",
    "rwk" to "руанда",
    "sa" to "санскрит",
    "sad" to "сандаве",
    "sah" to "якутийн",
    "saq" to "самбуру",
    "sat" to "сантали",
    "sba" to "нгамбайн",
    "sbp" to "сангу",
    "sc" to "сардинийн",
    "scn" to "сицилийн",
    "sco" to "шотландхойн",
    "sd" to "синдхи",
    "se" to "къилбаседа саамийн",
    "seh" to "сена",
    "ses" to "койраборо сенни",
    "sg" to "санго",
    "shi" to "тахелхит",
    "shn" to "шанойн",
    "si" to "сингалхойн",
    "sk" to "словакийн",
    "sl" to "словенийн",
    "sm" to "самоанойн",
    "sma" to "саамийн (къилба)",
    "smj" to "луле-саамийн",
    "smn" to "инари-саамийн",
    "sms" to "скольт-саамийн",
    "sn" to "шона",
    "snk" to "сонинке",
    "so" to "сомали",
    "sq" to "албанойн",
    "sr" to "сербийн",
    "srn" to "сранан-тонго",
    "ss" to "свази",
    "ssy" to "сахо",
    "st" to "къилба сото",
    "su" to "сунданхойн",
    "suk" to "сукума",
    "sv" to "шведийн",
    "sw" to "суахили",
    "sw-CD" to "суахили (Конго)",
    "swb" to "коморийн",
    "syr" to "шемахойн",
    "ta" to "тамилхойн",
    "te" to "телугу",
    "tem" to "темне",
    "teo" to "тесо",
    "tet" to "тетум",
    "tg" to "таджикийн",
    "th" to "тайн",
    "ti" to "тигринья",
    "tig" to "тигре",
    "tk" to "туркменийн",
    "tlh" to "клингонин",
    "tn" to "тсвана",
    "to" to "тонганийн",
    "tpi" to "ток-писин",
    "tr" to "туркойн",
    "trv" to "седекойн",
    "ts" to "тсонга",
    "tt" to "гӀезалойн",
    "tum" to "тумбука",
    "tvl" to "тувалу",
    "twq" to "тасавак",
    "ty" to "таитянойн",
    "tyv" to "тувинийн",
    "tzm" to "тамазигхтийн",
    "udm" to "удмуртийн",
    "ug" to "уйгурийн",
    "uk" to "украинийн",
    "umb" to "умбунду",
    "und" to "боьвзуш боцу мотт",
    "ur" to "урду",
    "uz" to "узбекийн",
    "vai" to "ваи",
    "ve" to "венда",
    "vi" to "вьетнамхойн",
    "vo" to "волапюк",
    "vun" to "вунджо",
    "wa" to "валлонойн",
    "wae" to "валлисийн",
    "wal" to "воламо",
    "war" to "варай",
    "wbp" to "варлпири",
    "wo" to "волоф",
    "xal" to "гӀалмакхойн",
    "xh" to "коса",
    "xog" to "сога",
    "yav" to "янгбен",
    "ybb" to "йемба",
    "yi" to "идиш",
    "yo" to "йоруба",
    "yue" to "кантонийн",
    "yue-alt-menu" to "кантонийн",
    "zgh" to "мороккон стандартан тамазигхтийн",
    "zh" to "цийн",
    "zh-alt-menu" to "цийн",
    "zh-Hans" to "атта цийн",
    "zh-Hans-alt-long" to "атта цийн",
    "zh-Hant" to "ламастан цийн",
    "zh-Hant-alt-long" to "ламастан цийн",
    "zu" to "зулу",
    "zun" to "зуньи",
    "zxx" to "меттан чулацам боцуш",
    "zza" to "заза",
  ) }

  val ceb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar" to "Arabic",
    "ar-001" to "Modernong Standard nga Arabic",
    "bn" to "Bangla",
    "ceb" to "Cebuano",
    "de" to "German",
    "de-CH" to "Swiss High German",
    "en" to "English",
    "en-GB" to "Britanikong English",
    "en-GB-alt-short" to "English (UK)",
    "en-US" to "English (America)",
    "en-US-alt-short" to "English (US)",
    "es" to "Espanyol",
    "es-ES" to "Espanyol (Europa)",
    "fr" to "Pranses",
    "hi" to "Hindi",
    "hi-Latn-alt-variant" to "Hinglish",
    "id" to "Indonesian",
    "it" to "Italyano",
    "ja" to "Hinapon",
    "ko" to "Korean",
    "nl" to "Dutch",
    "nl-BE" to "Flemish",
    "pl" to "Polish",
    "pt" to "Portuguese",
    "ru" to "Russian",
    "th" to "Thai",
    "tr" to "Turkish",
    "und" to "Wala Mailhing Pinulongan",
    "zh" to "Inintsik",
    "zh-alt-menu" to "Chinese, Mandarin",
    "zh-Hans" to "Pinasimple nga Chinese",
    "zh-Hans-alt-long" to "Pinasimple nga Mandarin Chinese",
    "zh-Hant" to "Tradisyonal nga Chinese",
    "zh-Hant-alt-long" to "Tradisyonal nga Mandarin Chinese",
  ) }

  val cgg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Orukani",
    "am" to "Orumariki",
    "ar" to "Oruharabu",
    "be" to "Oruberarusi",
    "bg" to "Oruburugariya",
    "bn" to "Orubengari",
    "cgg" to "Rukiga",
    "cs" to "Oruceeki",
    "de" to "Orugirimaani",
    "el" to "Oruguriiki",
    "en" to "Orungyereza",
    "es" to "Orusupaani",
    "fa" to "Orupaasiya",
    "fr" to "Orufaransa",
    "ha" to "Oruhausa",
    "hi" to "Oruhindi",
    "hu" to "Oruhangare",
    "id" to "Oruindonezia",
    "ig" to "Oruibo",
    "it" to "Oruyitare",
    "ja" to "Orujapaani",
    "jv" to "Orujava",
    "km" to "Orukambodiya",
    "ko" to "Orukoreya",
    "ms" to "Orumalesiya",
    "my" to "Oruburuma",
    "ne" to "Orunepali",
    "nl" to "Orudaaki",
    "pa" to "Orupungyabi",
    "pl" to "Orupoori",
    "pt" to "Orupocugo",
    "ro" to "Oruromania",
    "ru" to "Orurrasha",
    "rw" to "Orunyarwanda",
    "so" to "Orusomaari",
    "sv" to "Oruswidi",
    "ta" to "Orutamiri",
    "th" to "Orutailandi",
    "tr" to "Orukuruki",
    "uk" to "Orukuraini",
    "ur" to "Oru-Urudu",
    "vi" to "Oruviyetinaamu",
    "yo" to "Oruyoruba",
    "zh" to "Oruchaina",
    "zh-alt-menu" to "Oruchaina",
    "zu" to "Oruzuru",
  ) }

  val cho: ImmutableMap<String, String> by lazy { immutableMapOf(
    "cho" to "Chahta",
    "en" to "English",
  ) }

  val chr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "ᎠᏩᎳ",
    "ab" to "ᎠᏆᏏᎠᏂ",
    "ace" to "ᎠᏥᏂᏏ",
    "ada" to "ᎠᏓᎾᎦᎺ",
    "ady" to "ᎠᏗᎨ",
    "af" to "ᎠᎬᎿᎨᏍᏛ",
    "agq" to "ᎠᎨᎹ",
    "ain" to "ᎠᏱᏄ",
    "ak" to "ᎠᎧᎾ",
    "ale" to "ᎠᎵᎤᏘ",
    "alt" to "ᏧᎦᎾᏮ ᏗᏜ ᎠᎵᏔᎢ",
    "am" to "ᎠᎹᎭᎵᎩ",
    "an" to "ᎠᏩᎪᏂᏏ",
    "ann" to "ᎣᏉᎶ",
    "anp" to "ᎠᎾᎩᎧ",
    "ar" to "ᎡᎳᏈ",
    "ar-001" to "ᎪᎯᏊ ᎢᎬᏥᎩ ᎠᏟᎶᏍᏗ ᎡᎳᏈ",
    "arn" to "ᎹᏊᏤ",
    "arp" to "ᎠᏩᏈᎰ",
    "ars" to "ᎾᏣᏗ ᎠᎳᏈ",
    "as" to "ᎠᏌᎻᏏ",
    "asa" to "ᎠᏑ",
    "ast" to "ᎠᏍᏚᎵᎠᏂ",
    "atj" to "ᎠᏂᏘᎧᎺᏆ",
    "av" to "ᎠᏩᎵᎧ",
    "awa" to "ᎠᏩᏗ",
    "ay" to "ᎠᏱᎹᎳ",
    "az" to "ᎠᏎᏆᏣᏂ",
    "az-alt-short" to "ᎠᏎᎵ",
    "ba" to "ᏆᏍᎯᎩᎠ",
    "ban" to "ᏆᎵᏁᏏ",
    "bas" to "ᏆᏌᎠ",
    "be" to "ᏇᎳᎷᏏ",
    "bem" to "ᏇᎹᏆ",
    "bez" to "ᏇᎾ",
    "bg" to "ᏊᎵᎨᎵᎠᏂ",
    "bgc" to "ᎭᏯᏅᎢ",
    "bho" to "ᏉᏣᏊᎵ",
    "bi" to "ᏈᏍᎳᎹ",
    "bin" to "ᏈᏂ",
    "bla" to "ᏏᎩᏏᎧ",
    "blo" to "ᎠᏂᎵ",
    "bm" to "ᏆᎻᏆᎳ",
    "bn" to "ᏇᏂᎦᎳ",
    "bo" to "ᏘᏇᏔᏂ",
    "br" to "ᏇᏙᏂ",
    "brx" to "ᏉᏙ",
    "bs" to "ᏆᏍᏂᎠᏂ",
    "bug" to "ᏈᎥᎩᏂᏍ",
    "byn" to "ᏟᏂ",
    "ca" to "ᎨᏔᎳᏂ",
    "cay" to "ᎧᏳᎦ",
    "ccp" to "ᏣᎧᎹ",
    "ce" to "ᏤᏤᏂ",
    "ceb" to "ᏎᏆᏃ",
    "cgg" to "ᏥᎦ",
    "ch" to "ᏣᎼᎶ",
    "chk" to "ᏧᎨᏎ",
    "chm" to "ᎹᎵ",
    "cho" to "ᎠᏣᏓ",
    "chp" to "ᎠᏥᏇᏯᏂ",
    "chr" to "ᏣᎳᎩ",
    "chy" to "ᏣᏰᏂ",
    "ckb" to "ᎠᏰᏟ ᎫᏗᏏ",
    "ckb-alt-menu" to "ᎠᏰᏟ ᎫᏗᏏ",
    "ckb-alt-variant" to "ᎠᏰᏟ ᎫᏗᏏ",
    "clc" to "ᏥᎸᎪᏘᎾ",
    "co" to "ᎪᎵᏍᎢᎧᏂ",
    "crg" to "ᎻᏥᏩ",
    "crj" to "ᏧᎦᏃᏮ ᏗᎧᎸᎬ Ꮯ",
    "crk" to "ᏠᎨᏏ Ꮯ",
    "crl" to "ᏧᏴᏢ ᏗᎧᎸᎬ Ꮯ",
    "crm" to "ᎠᏫ ᎡᏆ Ꮯ",
    "crr" to "ᎠᎵᎦᏂᏈᎠᎾ",
    "crs" to "ᏎᏎᎵᏩ ᏟᏲᎵ ᎠᏂᎦᎸ",
    "cs" to "ᏤᎩ",
    "csw" to "ᏌᎷᏱ Ꮯ",
    "cu" to "ᏧᏂᎳᏫᏍᏗ ᏍᎳᏫᎪ",
    "cv" to "ᏧᏩᏏ",
    "cy" to "ᏪᎵᏏ",
    "da" to "ᏕᏂᏍ",
    "dak" to "ᏓᎪᏔ",
    "dar" to "ᏓᎳᏆ",
    "dav" to "ᏔᎢᏔ",
    "de" to "ᏙᎢᏥ",
    "de-AT" to "ᎠᏟᏯᏂ ᎠᏂᏓᏥ",
    "de-CH" to "ᏍᏫᏏ ᎦᎸᎳᏗ ᎠᏂᏓᏥ",
    "dgr" to "ᎩᏟ ᎤᏄᎳᏥ",
    "dje" to "ᏌᎹ",
    "doi" to "ᏙᎦᎵ",
    "dsb" to "ᎡᎳᏗ ᏐᏈᎠᏂ",
    "dua" to "ᏚᎠᎳ",
    "dv" to "ᏗᏪᎯ",
    "dyo" to "ᏦᎳ-ᏬᏱ",
    "dz" to "ᏓᏐᏅᎧ",
    "dzg" to "ᏓᏌᎦ",
    "ebu" to "ᎡᎻᏊ",
    "ee" to "ᎡᏪ",
    "efi" to "ᎡᏫᎩ",
    "eka" to "ᎨᎧᏧᎧ",
    "el" to "ᎠᏂᎪᎢ",
    "en" to "ᎩᎵᏏ",
    "en-AU" to "ᎡᎳᏗᏜ ᎩᎵᏏ",
    "en-CA" to "ᎨᎾᏓ ᎩᎵᏏ",
    "en-GB" to "ᎩᎵᏏᏲ ᎩᎵᏏ",
    "en-GB-alt-short" to "UK ᎩᎵᏏ",
    "en-US" to "ᎠᎹᏰᏟ ᎩᎵᏏ",
    "en-US-alt-short" to "US ᎩᎵᏏ",
    "eo" to "ᎡᏍᏇᎳᏂᏙ",
    "es" to "ᏍᏆᏂ",
    "es-419" to "ᏔᏘᏂ ᎠᎹᏰᏟ ᏍᏆᏂ",
    "es-ES" to "ᎠᏂᏍᏆᏂᏱ ᏍᏆᏂ",
    "es-MX" to "ᏍᏆᏂᏱ ᏍᏆᏂ",
    "et" to "ᎡᏍᏙᏂᎠᏂ",
    "eu" to "ᏆᏍᎨ",
    "ewo" to "ᎡᏬᏂᏙ",
    "fa" to "ᏇᏏᎠᏂ",
    "fa-AF" to "ᏓᎵ",
    "ff" to "ᏊᎳᏂ",
    "fi" to "ᏈᏂᏍ",
    "fil" to "ᎠᏈᎵᎩ",
    "fj" to "ᏫᏥᎠᏂ",
    "fo" to "ᏇᎶᎡᏍ",
    "fon" to "ᏠᏂ",
    "fr" to "ᎦᎸᏥ",
    "fr-CA" to "ᎨᎾᏓ ᎦᎸᏥ",
    "fr-CH" to "ᏍᏫᏏ ᎦᎸᏥ",
    "frc" to "ᎨᏨᏂ ᎦᎸᏥ",
    "frr" to "ᏧᏴᏢ ᎷᏈ",
    "fur" to "ᏞᎤᎵᎠᏂ",
    "fy" to "ᏭᏕᎵᎬ ᏗᏜ ᏟᏏᎠᏂ",
    "ga" to "ᎨᎵᎩ",
    "gaa" to "Ꭶ",
    "gd" to "ᏍᎦᏗ ᎨᎵᎩ",
    "gez" to "ᎩᏏ",
    "gil" to "ᎩᏇᏘᏏ",
    "gl" to "ᎦᎵᏏᎠᏂ",
    "gn" to "ᏆᎳᏂ",
    "gor" to "ᎪᎶᏂᏔᏃ",
    "gsw" to "ᏍᏫᏏ ᎠᏂᏓᏥ",
    "gu" to "ᎫᏣᎳᏘ",
    "guz" to "ᎫᏏ",
    "gv" to "ᎹᎾᎧᏏ",
    "gwi" to "ᏈᏥᏂ",
    "ha" to "ᎭᎤᏌ",
    "hai" to "ᎭᏱᏓ",
    "haw" to "ᎭᏩᎼ",
    "hax" to "ᏧᎦᏃᏮ ᏗᏜ ᎭᏱᏓ",
    "he" to "ᎠᏂᏈᎷ",
    "hi" to "ᎯᏂᏗ",
    "hi-Latn-alt-variant" to "ᎯᏂᏲᏁᎦ",
    "hil" to "ᎯᎵᎨᎾᏂ",
    "hmn" to "ᎭᎼᏂᎩ",
    "hr" to "ᎧᎶᎡᏏᏂ",
    "hsb" to "ᎦᎸᎳᏗᎨ ᏐᏈᎠᏂ",
    "ht" to "ᎮᏏᎠᏂ ᏟᏲᎵ",
    "hu" to "ᎲᏂᎦᎵᎠᏂ",
    "hup" to "ᎠᏂᎱᏆ",
    "hur" to "ᎭᎵᎪᎺᎴᎻ",
    "hy" to "ᎠᎳᎻᎠᏂ",
    "hz" to "ᎮᎴᎶ",
    "ia" to "ᎠᏰᏟ ᎦᏬᏂᎯᏍᏗ",
    "iba" to "ᎢᏆᏂ",
    "ibb" to "ᎢᏈᏈᎣ",
    "id" to "ᎢᏂᏙᏂᏏᎠ",
    "ie" to "ᏈᏖᎵᏆ",
    "ig" to "ᎢᎦᎪ",
    "ii" to "ᏏᏧᏩᏂ Ᏹ",
    "ikt" to "ᏭᏕᎵᎬ ᎨᎾᏓ ᎢᏄᎩᏘᏚᏘ",
    "ilo" to "ᎢᎶᎪ",
    "inh" to "ᎢᏂᎫᏏ",
    "io" to "ᎢᏙ",
    "is" to "ᏧᏁᏍᏓᎸᎯᎢᎩ",
    "it" to "ᎬᏩᎵᏲᏥᎢ",
    "iu" to "ᎢᏄᎦᏘᏚ",
    "ja" to "ᏣᏩᏂᏏ",
    "jbo" to "ᎶᏣᏆᏂ",
    "jgo" to "ᎾᎪᏆ",
    "jmc" to "ᎹᏣᎺ",
    "jv" to "ᏆᏌ ᏣᏩ",
    "ka" to "ᏦᏥᎠᏂ",
    "kab" to "ᎧᏈᎴ",
    "kac" to "ᎧᏥᏂ",
    "kaj" to "ᏥᏧ",
    "kam" to "ᎧᎻᏆ",
    "kbd" to "ᎧᏆᏗᎠᏂ",
    "kcg" to "ᏔᏯᏆ",
    "kde" to "ᎹᎪᏕ",
    "kea" to "ᎧᏊᏪᏗᎠᏄ",
    "kfo" to "ᎪᎶ",
    "kgp" to "ᎨᏂᎨᏂ",
    "kha" to "ᎧᏏ",
    "khq" to "ᎪᏱᎳ ᏥᏂ",
    "ki" to "ᎩᎫᏳ",
    "kj" to "ᎫᏩᏂᎠᎹ",
    "kk" to "ᎧᏌᎧ",
    "kkj" to "ᎧᎪ",
    "kl" to "ᎧᎳᎵᏑᏘ",
    "kln" to "ᎧᎴᏂᏥᏂ",
    "km" to "ᎩᎻᎷ",
    "kmb" to "ᎩᎻᏊᏚ",
    "kn" to "ᎧᎾᏓ",
    "ko" to "ᎪᎵᎠᏂ",
    "kok" to "ᎧᏂᎧᏂ",
    "kpe" to "ᏇᎴ",
    "kr" to "ᎧᏄᎵ",
    "krc" to "ᎧᎳᏣᏱ-ᏆᎵᎧᎵ",
    "krl" to "ᎧᎴᎵᎠᏂ",
    "kru" to "ᎫᎷᎩ",
    "ks" to "ᎧᏏᎻᎵ",
    "ksb" to "ᏝᎻᏆᎸ",
    "ksf" to "ᏆᏫᎠ",
    "ksh" to "ᎪᎶᏂᎠᏂ",
    "ku" to "ᎫᏗᏏ",
    "kum" to "ᎫᎻᎧ",
    "kv" to "ᎪᎻ",
    "kw" to "ᏎᎷᎭ",
    "kwk" to "ᏆᏆᎳ",
    "kxv" to "ᎫᏈ",
    "ky" to "ᎩᎵᏣᎢᏍ",
    "la" to "ᎳᏘᏂ",
    "lad" to "ᎳᏗᏃ",
    "lag" to "ᎳᏂᎩ",
    "lb" to "ᎸᎦᏏᎻᏋᎢᏍ",
    "lez" to "ᎴᏏᎦᏂ",
    "lg" to "ᎦᏂᏓ",
    "li" to "ᎴᎹᏊᎵᏏ",
    "lij" to "ᎵᏇᎢᎠ",
    "lil" to "ᎵᎶᎡᏘ",
    "lkt" to "ᎳᎪᏓ",
    "lmo" to "ᎶᏆᏗ",
    "ln" to "ᎵᏂᎦᎳ",
    "lo" to "ᎳᎣ",
    "lou" to "ᎷᏫᏏᎡᎾ ᎦᏬᏂᎯᏍᏗ",
    "loz" to "ᎶᏏ",
    "lrc" to "ᏧᏴᏢ ᏗᏜ ᎷᎵ",
    "lsm" to "ᏌᎠᎻᎠ",
    "lt" to "ᎵᏚᏩᏂᎠᏂ",
    "lu" to "ᎷᏆ-ᎧᏔᎦ",
    "lua" to "ᎷᏆ-ᎷᎷᎠ",
    "lun" to "ᎷᎾᏓ",
    "luo" to "ᎷᎣ",
    "lus" to "ᎻᏐ",
    "luy" to "ᎷᏱᎠ",
    "lv" to "ᎳᏘᏫᎠᏂ",
    "mad" to "ᎹᏚᎴᏏ",
    "mag" to "ᎹᎦᎯ",
    "mai" to "ᎹᏟᎵ",
    "mak" to "ᎹᎧᏌ",
    "mas" to "ᎹᏌᏱ",
    "mdf" to "ᎼᎧᏌ",
    "men" to "ᎺᎾᏕ",
    "mer" to "ᎺᎷ",
    "mfe" to "ᎼᎵᏏᎡᏂ",
    "mg" to "ᎹᎳᎦᏏ",
    "mgh" to "ᎹᎫᏩ-ᎻᏙ",
    "mgo" to "ᎺᎳ’",
    "mh" to "ᎹᏌᎵᏏ",
    "mi" to "ᎹᏫ",
    "mic" to "ᎻᎧᎹᎩ",
    "min" to "ᎻᎾᎧᏆᎤ",
    "mk" to "ᎹᏎᏙᏂᎠᏂ",
    "ml" to "ᎹᎳᏯᎳᎻ",
    "mn" to "ᎹᏂᎪᎵᎠᏂ",
    "mni" to "ᎺᏂᏉᎵ",
    "moe" to "ᎢᏄ-ᎠᏱᏵᏂ",
    "moh" to "ᎼᎭᎩ",
    "mos" to "ᎼᏍᏏ",
    "mr" to "ᎹᎳᏘ",
    "ms" to "ᎹᎴ",
    "mt" to "ᎹᎵᏘᏍ",
    "mua" to "ᎽᏂᏓᎩ",
    "mul" to "ᏧᏈᏍᏗ ᏗᎦᏬᏂᎯᏍᏗ",
    "mus" to "ᎠᎫᏌ",
    "mwl" to "ᎻᎳᏕᏏ",
    "my" to "ᏋᎻᏍ",
    "myv" to "ᎡᏏᏯ",
    "mzn" to "ᎹᏌᏕᎳᏂ",
    "na" to "ᏃᎤᎷ",
    "nap" to "ᏂᏯᏆᎵᏔᏂ",
    "naq" to "ᎾᎹ",
    "nb" to "ᏃᎵᏪᏥᏂ ᏉᎧᎹᎵ",
    "nd" to "ᏧᏴᏢ ᏂᏕᏇᎴ",
    "nds" to "ᎡᎳᏗ ᎠᏂᏓᏥ",
    "nds-NL" to "ᎡᎳᏗ ᏁᏛᎳᏂ",
    "ne" to "ᏁᏆᎵ",
    "new" to "ᏁᏩᎵ",
    "ng" to "ᎾᏙᎦ",
    "nia" to "ᏂᎠᏏ",
    "niu" to "ᏂᏳᏫᏯᏂ",
    "nl" to "ᏛᏥ",
    "nl-BE" to "ᏊᎵᏥᎥᎻ ᏛᏥ",
    "nmg" to "ᏆᏏᏲ",
    "nn" to "ᏃᎵᏪᏥᏂ ᎾᎵᏍᎩ",
    "nnh" to "ᎾᏥᏰᎹᏊᏂ",
    "no" to "ᏃᎵᏪᏥᏂ",
    "nog" to "ᏃᎦᏱ",
    "nqo" to "ᎾᎪ",
    "nr" to "ᏧᎦᎾᏮ ᏂᏕᏇᎴ",
    "nso" to "ᏧᏴᏢ ᏗᏜ ᏐᏠ",
    "nus" to "ᏄᏪᎵ",
    "nv" to "ᎾᏩᎰ",
    "ny" to "ᏂᏯᏂᏣ",
    "nyn" to "ᏂᏯᎾᎪᎴ",
    "oc" to "ᎠᏏᏔᏂ",
    "ojb" to "ᏧᏴᏢ ᏭᏕᎵᎬ ᎣᏥᏆ",
    "ojc" to "ᎠᏰᏟ ᎣᏥᏆ",
    "ojs" to "ᎣᏥ-Ꮯ",
    "ojw" to "ᏭᏕᎵᎬ ᏗᏜ ᎣᏥᏆ",
    "oka" to "ᎣᎧᎾᎦᏂ",
    "om" to "ᎣᎶᎼ",
    "or" to "ᎣᏗᎠ",
    "os" to "ᎣᏎᏘᎧ",
    "pa" to "ᏡᏂᏣᏈ",
    "pag" to "ᏇᎦᏏᎠᏂ",
    "pam" to "ᏆᎹᏆᎾᎦ",
    "pap" to "ᏆᏈᏯᎺᎾᏙ",
    "pau" to "ᏆᎳᎤᏩᏂ",
    "pcm" to "ᎾᎩᎵᎠᏂ ᏈᏥᏂ",
    "pis" to "ᏈᏥᎾ",
    "pl" to "ᏉᎵᏍ",
    "pqm" to "ᎹᎵᏏᏘ-ᏇᏌᎹᏉᏗ",
    "prg" to "ᏡᏏᎠᏂ",
    "ps" to "ᏆᏍᏙ",
    "pt" to "ᏉᏧᎩᏍ",
    "pt-BR" to "ᏆᏏᎵᎢ ᏉᏧᎩᏍ",
    "pt-PT" to "ᏳᎳᏈ ᏉᏧᎩᏍ",
    "qu" to "ᎨᏧᏩ",
    "quc" to "ᎩᏤ",
    "raj" to "ᎳᏣᏍᎭᏂ",
    "rap" to "ᎳᏆᏄᏫ",
    "rar" to "ᎳᎶᏙᎾᎦᏂ",
    "rhg" to "ᎶᎯᏂᏯ",
    "rm" to "ᎠᏂᎶᎺᏂ",
    "rn" to "ᎷᏂᏗ",
    "ro" to "ᎶᎹᏂᎠᏂ",
    "ro-MD" to "ᎹᎵᏙᏫᎠ ᏣᎹᏂᎠᏂ",
    "rof" to "ᎶᎹᏉ",
    "ru" to "ᏲᏅᎯ",
    "rup" to "ᎠᏬᎹᏂᎠᏂ",
    "rw" to "ᎩᏂᏯᏩᏂᏓ",
    "rwk" to "Ꮖ",
    "sa" to "ᏍᏂᏍᎩᏗ",
    "sad" to "ᏌᏅᏓᏫ",
    "sah" to "ᏌᎧᎾ",
    "saq" to "ᏌᎹᏊᎷ",
    "sat" to "ᏌᏂᏔᎵ",
    "sba" to "ᎾᎦᎹᏇ",
    "sbp" to "ᏌᏁᎫ",
    "sc" to "ᏌᏗᏂᎠᏂ",
    "scn" to "ᏏᏏᎵᎠᏂ",
    "sco" to "ᏍᎦᏗ",
    "sd" to "ᏏᏂᏗ",
    "se" to "ᏧᏴᏢ ᏗᏜ ᏌᎻ",
    "see" to "ᏏᏂᎦ",
    "seh" to "ᏎᎾ",
    "ses" to "ᎪᏱᎳᏈᎶ ᏎᏂ",
    "sg" to "ᏌᏂᎪ",
    "shi" to "ᏔᏤᎵᎯᏘ",
    "shn" to "ᏝᏂ",
    "si" to "ᏏᎾᎭᎳ",
    "sk" to "ᏍᎶᏩᎩ",
    "sl" to "ᏍᎶᏫᏂᎠᏂ",
    "slh" to "ᏧᎦᏃᏮ ᏗᏜ ᎷᏑᏘᏏᏗ",
    "sm" to "ᏌᎼᏯᏂ",
    "sma" to "ᏧᎦᎾᏮ ᏗᏜ ᏌᎻ",
    "smj" to "ᎷᎴ ᏌᎻ",
    "smn" to "ᎢᎾᎵ ᏌᎻ",
    "sms" to "ᏍᎪᎵᏘ ᏌᎻ",
    "sn" to "ᏠᎾ",
    "snk" to "ᏐᏂᏂᎨ",
    "so" to "ᏐᎹᎵ",
    "sq" to "ᎠᎵᏇᏂ",
    "sr" to "ᏒᏈᎠᏂ",
    "srn" to "ᏏᎳᎾᏂ ᏙᏃᎪ",
    "ss" to "ᏍᏩᏘ",
    "ssy" to "ᏌᎰ",
    "st" to "ᏧᎦᎾᏮ ᏗᏜ ᏐᏠ",
    "str" to "ᏌᎵᏏ",
    "su" to "ᏑᏂᏓᏂᏏ",
    "suk" to "ᏑᎫᎹ",
    "sv" to "ᏍᏫᏗᏏ",
    "sw" to "ᏍᏩᎯᎵ",
    "sw-CD" to "ᎧᏂᎪ ᏍᏩᎯᎵ",
    "swb" to "ᎪᎼᎵᎠᏂ",
    "syr" to "ᏏᎵᎠᎩ",
    "szl" to "ᏏᎴᏏᏂ",
    "ta" to "ᏔᎻᎵ",
    "tce" to "ᏧᎦᏃᏮ ᏚᏦᏁ",
    "te" to "ᏖᎷᎦ",
    "tem" to "ᏘᎹᏁ",
    "teo" to "ᏖᏐ",
    "tet" to "ᏖᏚᎼ",
    "tg" to "ᏔᏥᎩ",
    "tgx" to "ᏔᎩᏏ",
    "th" to "ᏔᏱ",
    "tht" to "ᏔᏝᎾ",
    "ti" to "ᏘᎩᎵᏂᎠ",
    "tig" to "ᏢᏓᏥ",
    "tk" to "ᎠᏂᎬᎾ",
    "tlh" to "ᏟᎦᎾ",
    "tli" to "ᏟᎩᏘ",
    "tn" to "ᏧᏩᎾ",
    "to" to "ᏙᎾᎦᏂ",
    "tok" to "ᏙᎩ ᏉᎾ",
    "tpi" to "ᏙᎩ ᏈᏏᏂ",
    "tr" to "ᎠᎬᎾ",
    "trv" to "ᏔᎶᎪ",
    "ts" to "ᏦᎾᎦ",
    "tt" to "ᏔᏔ",
    "ttm" to "ᏧᏴᏢ ᏗᏜ ᏚᏦᏁ",
    "tum" to "ᏛᎹᏊᎧ",
    "tvl" to "ᏚᏩᎷ",
    "twq" to "ᏔᏌᏩᎩ",
    "ty" to "ᏔᎯᏘᎠᏂ",
    "tyv" to "ᏚᏫᏂᎠᏂ",
    "tzm" to "ᎠᏰᏟ ᎡᎶᎯ ᏓᏟᎶᏍᏗᏓᏅᎢ ᏔᎹᏏᏘ",
    "udm" to "ᎤᏚᎷᏘ",
    "ug" to "ᏫᎦ",
    "uk" to "ᏳᎧᎴᏂᎠᏂ",
    "umb" to "ᎤᎹᏊᏅᏚ",
    "und" to "ᏄᏬᎵᏍᏛᎾ ᎦᏬᏂᎯᏍᏗ",
    "ur" to "ᎤᎵᏚ",
    "uz" to "ᎤᏍᏇᎩ",
    "vai" to "ᏩᏱ",
    "ve" to "ᏫᏂᏓ",
    "vec" to "ᏈᏂᏒᏂ",
    "vi" to "ᏫᎡᏘᎾᎻᏍ",
    "vmw" to "ᎹᎱᏩ",
    "vo" to "ᏬᎳᏊᎩ",
    "vun" to "ᏭᎾᏦ",
    "wa" to "ᏩᎷᎾ",
    "wae" to "ᏩᎵᏎᎵ",
    "wal" to "ᏬᎳᏱᏔ",
    "war" to "ᏩᎴ",
    "wo" to "ᏬᎶᏫ",
    "wuu" to "Ꮽ ᏓᎶᏂᎨᏍᏛ",
    "xal" to "ᎧᎳᎻᎧ",
    "xh" to "ᏠᏌ",
    "xnr" to "ᎧᏈᎢ",
    "xog" to "ᏐᎦ",
    "yav" to "ᏰᎾᎦᏇᏂ",
    "ybb" to "ᏰᎹᏋ",
    "yi" to "ᏱᏗᏍ",
    "yo" to "ᏲᏄᏆ",
    "yrl" to "ᏂᎾᎦᏚ",
    "yue" to "ᎨᎾᏙᏂᏏ",
    "yue-alt-menu" to "ᏓᎶᏂᎨ, ᎨᎾᏙᏂᏏ",
    "za" to "ᎱᎠᏂ",
    "zgh" to "ᎠᏟᎶᏍᏗ ᎼᎶᎪ ᏔᎹᏏᏘ",
    "zh" to "ᏓᎶᏂᎨ",
    "zh-alt-menu" to "ᏓᎶᏂᎨ, ᎹᏓᏈᏂ",
    "zh-Hans" to "ᎠᎯᏗᎨ ᏓᎶᏂᎨ",
    "zh-Hans-alt-long" to "ᎠᎯᏗᎨ ᎹᏓᏈᏂ ᏓᎶᏂᎨ",
    "zh-Hant" to "ᎤᏦᏍᏗ ᏓᎶᏂᎨ",
    "zh-Hant-alt-long" to "ᎤᏦᏍᏗ ᎹᏓᏈᏂ ᏓᎶᏂᎨ",
    "zu" to "ᏑᎷ",
    "zun" to "ᏑᏂ",
    "zxx" to "Ꮭ ᎦᏬᏂᎯᏍᏗ ᎦᎸᏛᎢ ᏱᎩ",
    "zza" to "ᏌᏌ",
  ) }

  val cic: ImmutableMap<String, String> by lazy { immutableMapOf(
    "cic" to "Chikashshanompaʼ",
  ) }

  val ckb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "ئەفار",
    "ab" to "ئەبخازی",
    "ace" to "ئاچەیی",
    "ada" to "دانگمێ",
    "ady" to "ئادیگی",
    "af" to "ئەفریکانس",
    "agq" to "ئاگێم",
    "ain" to "ئاینوو",
    "ak" to "ئاکان",
    "ale" to "ئالیوت",
    "alt" to "ئاڵتایی باشوور",
    "am" to "ئەمھەری",
    "an" to "ئاراگۆنی",
    "anp" to "ئەنگیکا",
    "ar" to "عەرەبی",
    "ar-001" to "عەرەبیی ستاندارد",
    "arn" to "ماپووچە",
    "arp" to "ئاراپاهۆ",
    "as" to "ئاسامی",
    "asa" to "ئاسوو",
    "ast" to "ئاستۆری",
    "av" to "ئەڤاری",
    "awa" to "ئاوادهی",
    "ay" to "ئایمارا",
    "az" to "ئازەربایجانی",
    "az-alt-short" to "ئازەربایجانی",
    "az-Arab" to "ئازەربایجانی باشووری",
    "ba" to "باشکیەر",
    "ban" to "بالی",
    "bas" to "باسا",
    "be" to "بیلاڕووسی",
    "bem" to "بێمبا",
    "bez" to "بێنا",
    "bg" to "بۆلگاری",
    "bho" to "بوجپووری",
    "bi" to "بیسلاما",
    "bin" to "بینی",
    "bla" to "سیکسیکا",
    "bm" to "بامبارا",
    "bn" to "بەنگلادێشی",
    "bo" to "تەبەتی",
    "br" to "برێتونی",
    "brx" to "بۆدۆ",
    "bs" to "بۆسنی",
    "bug" to "بووگی",
    "byn" to "بلین",
    "ca" to "كاتالۆنی",
    "ce" to "چیچانی",
    "ceb" to "سێبوانۆ",
    "cgg" to "کیگا",
    "ch" to "چامۆرۆ",
    "chk" to "چووکی",
    "chm" to "ماری",
    "cho" to "چۆکتاو",
    "chr" to "چێرۆکی",
    "chy" to "شایان",
    "ckb" to "کوردیی ناوەندی",
    "ckb-alt-menu" to "کوردیی ناوەندی",
    "ckb-alt-variant" to "کوردیی ناوەندی",
    "co" to "کۆرسیکی",
    "crs" to "فەرەنسیی سیشێلی",
    "cs" to "چێکی",
    "cu" to "سلاویی کلیسەیی",
    "cv" to "چووڤاشی",
    "cy" to "وێلزی",
    "da" to "دانماركی",
    "dak" to "داکۆتایی",
    "dar" to "دارگینی",
    "dav" to "تایتا",
    "de" to "ئەڵمانی",
    "dgr" to "دۆگریب",
    "dje" to "زارما",
    "dsb" to "سربیی خوارین",
    "dua" to "دووالا",
    "dv" to "دیڤێهی",
    "dyo" to "جۆلافۆنی",
    "dz" to "دزوونگخا",
    "dzg" to "دازا",
    "ebu" to "ئێمبوو",
    "ee" to "ئێوێیی",
    "efi" to "ئێفیک",
    "eka" to "ئێکاجووک",
    "el" to "یۆنانی",
    "en" to "ئینگلیزی",
    "en-AU" to "ئینگلیزیی ئۆسترالیایی",
    "en-CA" to "ئینگلیزیی کەنەدایی",
    "en-GB" to "ئینگلیزیی بریتانیایی",
    "en-GB-alt-short" to "ئینگلیزی (GB)",
    "en-US" to "ئینگلیزیی ئەمەریکایی",
    "en-US-alt-short" to "ئینگلیزیی ئەمەریکایی",
    "eo" to "ئێسپیرانتۆ",
    "es" to "ئیسپانی",
    "et" to "ئیستۆنی",
    "eu" to "باسکی",
    "ewo" to "ئێوۆندۆ",
    "fa" to "فارسی",
    "ff" to "فوولایی",
    "fi" to "فینلەندی",
    "fil" to "فیلیپینی",
    "fj" to "فیجی",
    "fo" to "فەرۆیی",
    "fon" to "فۆنی",
    "fr" to "فەرەنسی",
    "fur" to "فریئوولی",
    "fy" to "فریسیی ڕۆژاوا",
    "ga" to "ئیرلەندی",
    "gaa" to "گایی",
    "gd" to "گه‌لیكی سكۆتله‌ندی",
    "gez" to "گیزی",
    "gil" to "گیلبێرتی",
    "gl" to "گالیسی",
    "gn" to "گووارانی",
    "gor" to "گۆرۆنتالی",
    "gsw" to "ئەڵمانیی سویسڕا",
    "gu" to "گوجاراتی",
    "guz" to "گووسی",
    "gv" to "مانکی",
    "gwi" to "گویچین",
    "ha" to "هائووسا",
    "haw" to "هاوایی",
    "he" to "عیبری",
    "hi" to "هیندی",
    "hil" to "هیلیگاینۆن",
    "hmn" to "همۆنگ",
    "hr" to "كرواتی",
    "hsb" to "سربیی سەروو",
    "ht" to "کریولی هائیتی",
    "hu" to "هەنگاری",
    "hup" to "هووپا",
    "hy" to "ئەرمەنی",
    "hz" to "هێرێرۆ",
    "ia" to "ئینترلینگووا",
    "iba" to "ئیبان",
    "ibb" to "ئیبیبۆ",
    "id" to "ئیندۆنیزی",
    "ig" to "ئیگبۆ",
    "ii" to "سیچوان یی",
    "ilo" to "ئیلۆکۆ",
    "inh" to "ئینگووش",
    "io" to "ئیدۆ",
    "is" to "ئیسلەندی",
    "it" to "ئیتالی",
    "iu" to "ئینوکتیتوت",
    "ja" to "ژاپۆنی",
    "jbo" to "لۆژبان",
    "jgo" to "نگۆمبا",
    "jmc" to "ماچامێ",
    "jv" to "جاڤایی",
    "ka" to "گۆرجستانی",
    "kab" to "کبائیلی",
    "kac" to "کاچین",
    "kaj" to "کیجوو",
    "kam" to "کامبا",
    "kbd" to "کاباردی",
    "kcg" to "تیاپ",
    "kde" to "ماکۆندە",
    "kea" to "کابووڤێردیانۆ",
    "kfo" to "کۆرۆ",
    "kha" to "کهاسی",
    "khq" to "کۆیرا چینی",
    "ki" to "کیکوویوو",
    "kj" to "کوانیاما",
    "kk" to "کازاخی",
    "kkj" to "کاکۆ",
    "kl" to "کالالیسووت",
    "kln" to "کالێنجین",
    "km" to "خمێر",
    "kmb" to "کیمبووندوو",
    "kn" to "کاننادا",
    "ko" to "كۆری",
    "kok" to "کۆنکانی",
    "kpe" to "کپێلێ",
    "kr" to "کانووری",
    "krc" to "کاراچای بالکار",
    "krl" to "کارێلی",
    "kru" to "کوورووخ",
    "ks" to "کەشمیری",
    "ksb" to "شامابالا",
    "ksf" to "بافیا",
    "ksh" to "کۆلۆنی",
    "ku" to "کوردی",
    "kum" to "کوومیک",
    "kv" to "کۆمی",
    "kw" to "کۆڕنی",
    "ky" to "كرگیزی",
    "la" to "لاتینی",
    "lad" to "لادینۆ",
    "lag" to "لانگی",
    "lb" to "لوکسەمبورگی",
    "lez" to "لەزگی",
    "lg" to "گاندا",
    "li" to "لیمبورگی",
    "lkt" to "لاکۆتا",
    "ln" to "لينگالا",
    "lo" to "لائۆیی",
    "loz" to "لۆزی",
    "lrc" to "لوڕیی باکوور",
    "lt" to "لیتوانی",
    "lu" to "لووبا کاتانگا",
    "lua" to "لووبا لوولووا",
    "lun" to "لووندا",
    "luo" to "لووئۆ",
    "lus" to "میزۆ",
    "luy" to "لوویا",
    "lv" to "لێتۆنی",
    "mad" to "مادووری",
    "mag" to "ماگاهی",
    "mai" to "مائیتیلی",
    "mak" to "ماکاسار",
    "mas" to "ماسایی",
    "mdf" to "مۆکشا",
    "men" to "مێندێ",
    "mer" to "مێروو",
    "mfe" to "مۆریسی",
    "mg" to "مالاگاسی",
    "mgh" to "ماخوامیتۆ",
    "mgo" to "مێتە",
    "mh" to "مارشاڵی",
    "mi" to "مائۆری",
    "mic" to "میکماک",
    "min" to "مینانکاباو",
    "mk" to "ماكێدۆنی",
    "ml" to "مالایالام",
    "mn" to "مەنگۆلی",
    "mni" to "مانیپووری",
    "moh" to "مۆهاوک",
    "mos" to "مۆسی",
    "mr" to "ماراتی",
    "ms" to "مالیزی",
    "mt" to "ماڵتی",
    "mua" to "موندانگ",
    "mul" to "چەند زمان",
    "mus" to "کریک",
    "mwl" to "میراندی",
    "my" to "میانماری",
    "myv" to "ئێرزیا",
    "mzn" to "مازەندەرانی",
    "na" to "نائوروو",
    "nap" to "ناپۆلی",
    "naq" to "ناما",
    "nb" to "نەرویژیی بۆکمال",
    "nd" to "ئندێبێلێی باکوور",
    "ne" to "نیپالی",
    "new" to "نێواری",
    "ng" to "ندۆنگا",
    "nia" to "نیاس",
    "niu" to "نیئوویی",
    "nl" to "هۆڵەندی",
    "nl-BE" to "فلێمی",
    "nmg" to "کواسیۆ",
    "nn" to "نەرویژیی نینۆرسک",
    "nnh" to "نگیمبوون",
    "no" to "نۆروێژی",
    "nog" to "نۆگای",
    "nqo" to "نکۆ",
    "nr" to "ئندێبێلێی باشوور",
    "nso" to "سۆتۆی باکوور",
    "nus" to "نوێر",
    "nv" to "ناڤاجۆ",
    "ny" to "نیانجا",
    "nyn" to "نیانکۆلێ",
    "oc" to "ئۆکسیتانی",
    "om" to "ئۆرۆمۆ",
    "or" to "ئۆدیا",
    "os" to "ئۆسێتی",
    "pa" to "پەنجابی",
    "pag" to "پانگاسینان",
    "pam" to "پامپانگا",
    "pap" to "پاپیامێنتۆ",
    "pau" to "پالائوویی",
    "pcm" to "پیجینی نیجریا",
    "pl" to "پۆڵەندی",
    "prg" to "پڕووسی",
    "ps" to "پەشتوو",
    "pt" to "پورتوگالی",
    "qu" to "کێچوا",
    "quc" to "کیچەیی",
    "rap" to "ڕاپانوویی",
    "rar" to "ڕاڕۆتۆنگان",
    "rm" to "ڕۆمانش",
    "rn" to "ڕووندی",
    "ro" to "ڕۆمانی",
    "ro-MD" to "مۆڵداڤی",
    "rof" to "ڕۆمبۆ",
    "ru" to "ڕووسی",
    "rup" to "ئارمۆمانی",
    "rw" to "کینیارواندا",
    "rwk" to "ڕوا",
    "sa" to "سانسکريت",
    "sad" to "سانداوێ",
    "sah" to "ساخا",
    "saq" to "سامبووروو",
    "sat" to "سانتالی",
    "sba" to "نگامبای",
    "sbp" to "سانگوو",
    "sc" to "ساردینی",
    "scn" to "سیسیلی",
    "sco" to "سکۆتس",
    "sd" to "سيندی",
    "sdh" to "کوردیی باشووری",
    "se" to "سامیی باکوور",
    "seh" to "سێنا",
    "ses" to "کۆیرابۆرۆ سێنی",
    "sg" to "سانگۆ",
    "shi" to "شیلها",
    "shn" to "شان",
    "si" to "سینهالی",
    "sk" to "سلۆڤاكی",
    "sl" to "سلۆڤێنی",
    "sm" to "سامۆیی",
    "sma" to "سامیی باشوور",
    "smj" to "لوولێ سامی",
    "smn" to "ئیناری سامی",
    "sms" to "سامیی سکۆڵت",
    "sn" to "شۆنا",
    "snk" to "سۆنینکێ",
    "so" to "سۆمالی",
    "sq" to "ئەڵبانی",
    "sr" to "سربی",
    "srn" to "سرانان تۆنگۆ",
    "ss" to "سواتی",
    "ssy" to "ساهۆ",
    "st" to "سۆتۆی باشوور",
    "su" to "سوندانی",
    "suk" to "سووکووما",
    "sv" to "سویدی",
    "sw" to "سواهیلی",
    "sw-CD" to "سواهیلیی کۆنگۆ",
    "swb" to "کۆمۆری",
    "syr" to "سریانی",
    "ta" to "تامیلی",
    "te" to "تێلووگوو",
    "tem" to "تیمنێ",
    "teo" to "تێسوو",
    "tet" to "تێتووم",
    "tg" to "تاجیکی",
    "th" to "تایلەندی",
    "ti" to "تیگرینیا",
    "tig" to "تیگرێ",
    "tk" to "تورکمانی",
    "tlh" to "كلینگۆن",
    "tn" to "تسوانا",
    "to" to "تۆنگان",
    "tpi" to "تۆکپیسین",
    "tr" to "تورکی",
    "trv" to "تارۆکۆ",
    "ts" to "تسۆنگا",
    "tt" to "تاتاری",
    "tum" to "تومبووکا",
    "tvl" to "تووڤالوو",
    "twq" to "تاساواک",
    "ty" to "تاهیتی",
    "tyv" to "تووڤینی",
    "tzm" to "ئەمازیغی ناوەڕاست",
    "udm" to "ئوودموورت",
    "ug" to "ئۆیخۆری",
    "uk" to "ئۆكراینی",
    "umb" to "ئومبووندوو",
    "und" to "زمانی نەناسراو",
    "ur" to "ئۆردوو",
    "uz" to "ئوزبەکی",
    "vai" to "ڤایی",
    "ve" to "ڤێندا",
    "vi" to "ڤیەتنامی",
    "vo" to "ڤۆلاپووک",
    "vun" to "ڤوونجوو",
    "wa" to "والوون",
    "wae" to "والسێر",
    "wal" to "وۆلایتا",
    "war" to "وارای",
    "wo" to "وۆلۆف",
    "xal" to "کالمیک",
    "xh" to "سسوسا",
    "xog" to "سۆگا",
    "yav" to "یانگبێن",
    "ybb" to "یێمبا",
    "yi" to "ییدیش",
    "yo" to "یۆرووبا",
    "yue" to "کانتۆنی",
    "yue-alt-menu" to "کانتۆنی",
    "zgh" to "ئەمازیغیی مەغریب",
    "zh" to "چینی",
    "zh-alt-menu" to "چینی",
    "zh-Hans" to "چینی (چینیی ئاسانکراو)",
    "zh-Hans-alt-long" to "چینی (چینیی ئاسانکراو)",
    "zh-Hant" to "چینی (چینیی دێرین)",
    "zh-Hant-alt-long" to "چینی (چینیی دێرین)",
    "zu" to "زوولوو",
    "zun" to "زوونی",
    "zxx" to "هیچ ناوەرۆکی زمانی نیە",
    "zza" to "زازا",
  ) }

  val ckb_IR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val co: ImmutableMap<String, String> by lazy { immutableMapOf(
    "co" to "corsu",
  ) }

  val cs: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afarština",
    "ab" to "abcházština",
    "ace" to "acehština",
    "ach" to "akolština",
    "ada" to "adangme",
    "ady" to "adygejština",
    "ae" to "avestánština",
    "aeb" to "arabština (tuniská)",
    "af" to "afrikánština",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainština",
    "ak" to "akanština",
    "akk" to "akkadština",
    "akz" to "alabamština",
    "ale" to "aleutština",
    "aln" to "albánština (Gheg)",
    "alt" to "altajština (jižní)",
    "am" to "amharština",
    "an" to "aragonština",
    "ang" to "staroangličtina",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "arabština",
    "ar-001" to "arabština (moderní standardní)",
    "arc" to "aramejština",
    "arn" to "mapudungun",
    "aro" to "araonština",
    "arp" to "arapažština",
    "arq" to "arabština (alžírská)",
    "ars" to "arabština (Nadžd)",
    "arw" to "arawacké jazyky",
    "ary" to "arabština (marocká)",
    "arz" to "arabština (egyptská)",
    "as" to "ásámština",
    "asa" to "asu",
    "ase" to "znaková řeč (americká)",
    "ast" to "asturština",
    "atj" to "atikamekština",
    "av" to "avarština",
    "avk" to "kotava",
    "awa" to "awadhština",
    "ay" to "ajmarština",
    "az" to "ázerbájdžánština",
    "az-alt-short" to "azerština",
    "ba" to "baškirština",
    "bal" to "balúčština",
    "ban" to "balijština",
    "bar" to "bavorština",
    "bas" to "basa",
    "bax" to "bamun",
    "bbc" to "batak toba",
    "bbj" to "ghomala",
    "be" to "běloruština",
    "bej" to "bedža",
    "bem" to "bembština",
    "bew" to "batavština",
    "bez" to "bena",
    "bfd" to "bafut",
    "bfq" to "badagština",
    "bg" to "bulharština",
    "bgc" to "harijánština",
    "bgn" to "balúčština (západní)",
    "bho" to "bhódžpurština",
    "bi" to "bislamština",
    "bik" to "bikolština",
    "bin" to "bini",
    "bjn" to "bandžarština",
    "bkm" to "kom",
    "bla" to "siksika",
    "blo" to "aniiština",
    "bm" to "bambarština",
    "bn" to "bengálština",
    "bo" to "tibetština",
    "bpy" to "bišnuprijskomanipurština",
    "bqi" to "bachtijárština",
    "br" to "bretonština",
    "bra" to "bradžština",
    "brh" to "brahujština",
    "brx" to "bodoština",
    "bs" to "bosenština",
    "bss" to "akoose",
    "bua" to "burjatština",
    "bug" to "bugiština",
    "bum" to "bulu",
    "byn" to "blinština",
    "byv" to "medumba",
    "ca" to "katalánština",
    "cad" to "caddo",
    "car" to "karibština",
    "cay" to "kajugština",
    "cch" to "atsam",
    "ccp" to "čakma",
    "ce" to "čečenština",
    "ceb" to "cebuánština",
    "cgg" to "kiga",
    "ch" to "čamoro",
    "chb" to "čibča",
    "chg" to "čagatajština",
    "chk" to "čukština",
    "chm" to "marijština",
    "chn" to "činuk pidžin",
    "cho" to "čoktština",
    "chp" to "čipevajština",
    "chr" to "čerokézština",
    "chy" to "čejenština",
    "ckb" to "kurdština (sorání)",
    "ckb-alt-menu" to "kurdština (centrální)",
    "ckb-alt-variant" to "kurdština (sorání)",
    "clc" to "čilkotinština",
    "co" to "korsičtina",
    "cop" to "koptština",
    "cps" to "kapiznonština",
    "cr" to "kríjština",
    "crg" to "mičif",
    "crh" to "tatarština (krymská)",
    "crj" to "kríjština (jihovýchodní)",
    "crk" to "kríjština (z plání)",
    "crl" to "kríjština (severovýchodní)",
    "crm" to "kríjština (Moose)",
    "crr" to "algonkinština (Karolína)",
    "crs" to "kreolština (seychelská)",
    "cs" to "čeština",
    "csb" to "kašubština",
    "csw" to "kríjština (z bažin)",
    "cu" to "staroslověnština",
    "cv" to "čuvaština",
    "cy" to "velština",
    "da" to "dánština",
    "dak" to "dakotština",
    "dar" to "dargština",
    "dav" to "taita",
    "de" to "němčina",
    "de-CH" to "němčina standardní (Švýcarsko)",
    "del" to "delawarština",
    "den" to "slejvština (athabaský jazyk)",
    "dgr" to "dogrib",
    "din" to "dinkština",
    "dje" to "zarmština",
    "doi" to "dogarština",
    "dsb" to "dolnolužická srbština",
    "dtp" to "kadazandusunština",
    "dua" to "dualština",
    "dum" to "holandština (středověká)",
    "dv" to "maledivština",
    "dyo" to "jola-fonyi",
    "dyu" to "djula",
    "dz" to "dzongkä",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "eweština",
    "efi" to "efikština",
    "egl" to "emilijština",
    "egy" to "egyptština stará",
    "eka" to "ekajuk",
    "el" to "řečtina",
    "elx" to "elamitština",
    "en" to "angličtina",
    "en-GB" to "angličtina (Velká Británie)",
    "en-GB-alt-short" to "angličtina (VB)",
    "en-US" to "angličtina (USA)",
    "en-US-alt-short" to "angličtina (USA)",
    "enm" to "angličtina (středověká)",
    "eo" to "esperanto",
    "es" to "španělština",
    "es-ES" to "španělština (Evropa)",
    "esu" to "jupikština (středoaljašská)",
    "et" to "estonština",
    "eu" to "baskičtina",
    "ewo" to "ewondo",
    "ext" to "extremadurština",
    "fa" to "perština",
    "fa-AF" to "darí",
    "fan" to "fang",
    "fat" to "fantština",
    "ff" to "fulbština",
    "fi" to "finština",
    "fil" to "filipínština",
    "fit" to "finština (tornedalská)",
    "fj" to "fidžijština",
    "fo" to "faerština",
    "fon" to "fonština",
    "fr" to "francouzština",
    "frc" to "francouzština (cajunská)",
    "frm" to "francouzština (středověká)",
    "fro" to "francouzština (stará)",
    "frp" to "franko-provensálština",
    "frr" to "fríština (severní)",
    "frs" to "fríština (východní)",
    "fur" to "furlanština",
    "fy" to "fríština (západní)",
    "ga" to "irština",
    "gaa" to "gaština",
    "gag" to "gagauzština",
    "gan" to "čínština (dialekty Gan)",
    "gay" to "gayo",
    "gba" to "gbaja",
    "gbz" to "daríjština (zoroastrijská)",
    "gd" to "skotská gaelština",
    "gez" to "geez",
    "gil" to "kiribatština",
    "gl" to "galicijština",
    "glk" to "gilačtina",
    "gmh" to "hornoněmčina (středověká)",
    "gn" to "guaranština",
    "goh" to "hornoněmčina (stará)",
    "gon" to "góndština",
    "gor" to "gorontalo",
    "got" to "gótština",
    "grb" to "grebo",
    "grc" to "starořečtina",
    "gsw" to "němčina (Švýcarsko)",
    "gu" to "gudžarátština",
    "guc" to "wayúuština",
    "gur" to "frafra",
    "guz" to "gusii",
    "gv" to "manština",
    "gwi" to "gwichʼin",
    "ha" to "hauština",
    "hai" to "haidština",
    "hak" to "čínština (dialekty Hakka)",
    "haw" to "havajština",
    "hax" to "haidština (jižní)",
    "he" to "hebrejština",
    "hi" to "hindština",
    "hi-Latn-alt-variant" to "hingliš",
    "hif" to "hindština (Fidži)",
    "hil" to "hiligajnonština",
    "hit" to "chetitština",
    "hmn" to "hmongština",
    "ho" to "hiri motu",
    "hr" to "chorvatština",
    "hsb" to "hornolužická srbština",
    "hsn" to "čínština (dialekty Xiang)",
    "ht" to "haitština",
    "hu" to "maďarština",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "arménština",
    "hz" to "hererština",
    "ia" to "interlingua",
    "iba" to "ibanština",
    "ibb" to "ibibio",
    "id" to "indonéština",
    "ie" to "interlingue",
    "ig" to "igboština",
    "ii" to "iština (sečuánská)",
    "ik" to "inupiakština",
    "ikt" to "inuktitutština (západokanadská)",
    "ilo" to "ilokánština",
    "inh" to "inguština",
    "io" to "ido",
    "is" to "islandština",
    "it" to "italština",
    "iu" to "inuktitutština",
    "izh" to "ingrijština",
    "ja" to "japonština",
    "jam" to "jamajská kreolština",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "mašame",
    "jpr" to "judeoperština",
    "jrb" to "judeoarabština",
    "jut" to "jutština",
    "jv" to "javánština",
    "ka" to "gruzínština",
    "kaa" to "karakalpačtina",
    "kab" to "kabylština",
    "kac" to "kačijština",
    "kaj" to "jju",
    "kam" to "kambština",
    "kaw" to "kawi",
    "kbd" to "kabardinština",
    "kbl" to "kanembu",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "kapverdština",
    "ken" to "kenyang",
    "kfo" to "koro",
    "kg" to "konžština",
    "kgp" to "kaingang",
    "kha" to "khásí",
    "kho" to "chotánština",
    "khq" to "koyra chiini",
    "khw" to "chovarština",
    "ki" to "kikujština",
    "kiu" to "zazakština",
    "kj" to "kuaňamština",
    "kk" to "kazaština",
    "kkj" to "kako",
    "kl" to "grónština",
    "kln" to "kalendžin",
    "km" to "khmérština",
    "kmb" to "kimbundština",
    "kn" to "kannadština",
    "ko" to "korejština",
    "koi" to "komi-permjačtina",
    "kok" to "konkánština",
    "kos" to "kosrajština",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karačajevo-balkarština",
    "kri" to "krio",
    "krj" to "kinaraj-a",
    "krl" to "karelština",
    "kru" to "kuruchština",
    "ks" to "kašmírština",
    "ksb" to "šambala",
    "ksf" to "bafia",
    "ksh" to "kolínština",
    "ku" to "kurdština",
    "kum" to "kumyčtina",
    "kut" to "kutenajština",
    "kv" to "komijština",
    "kw" to "kornština",
    "kwk" to "kvakiutština",
    "kxv" to "kúvi",
    "ky" to "kyrgyzština",
    "la" to "latina",
    "lad" to "ladinština",
    "lag" to "langi",
    "lah" to "lahndština",
    "lam" to "lambština",
    "lb" to "lucemburština",
    "lez" to "lezginština",
    "lfn" to "lingua franca nova",
    "lg" to "gandština",
    "li" to "limburština",
    "lij" to "ligurština",
    "lil" to "lillooetština",
    "liv" to "livonština",
    "lkt" to "lakotština",
    "lmo" to "lombardština",
    "ln" to "lingalština",
    "lo" to "laoština",
    "lol" to "mongština",
    "lou" to "kreolština (Louisiana)",
    "loz" to "lozština",
    "lrc" to "lúrština (severní)",
    "lsm" to "samia",
    "lt" to "litevština",
    "ltg" to "latgalština",
    "lu" to "lubu-katanžština",
    "lua" to "luba-luluaština",
    "lui" to "luiseňo",
    "lun" to "lundština",
    "luo" to "luoština",
    "lus" to "mizoština",
    "luy" to "luhja",
    "lv" to "lotyština",
    "lzh" to "čínština (klasická)",
    "lzz" to "lazština",
    "mad" to "madurština",
    "maf" to "mafa",
    "mag" to "magahijština",
    "mai" to "maithiliština",
    "mak" to "makasarština",
    "man" to "mandingština",
    "mas" to "masajština",
    "mde" to "maba",
    "mdf" to "mokšanština",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "mauricijská kreolština",
    "mg" to "malgaština",
    "mga" to "irština (středověká)",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta’",
    "mh" to "maršálština",
    "mi" to "maorština",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "makedonština",
    "ml" to "malajálamština",
    "mn" to "mongolština",
    "mnc" to "mandžuština",
    "mni" to "manipurština",
    "moe" to "innu-aimun",
    "moh" to "mohawkština",
    "mos" to "mosi",
    "mr" to "maráthština",
    "mrj" to "marijština (západní)",
    "ms" to "malajština",
    "mt" to "maltština",
    "mua" to "mundang",
    "mul" to "více jazyků",
    "mus" to "kríkština",
    "mwl" to "mirandština",
    "mwr" to "márvárština",
    "mwv" to "mentavajština",
    "my" to "barmština",
    "mye" to "myene",
    "myv" to "erzjanština",
    "mzn" to "mázandaránština",
    "na" to "naurština",
    "nan" to "čínština (dialekty Minnan)",
    "nap" to "neapolština",
    "naq" to "namaština",
    "nb" to "norština (bokmål)",
    "nd" to "ndebele (Zimbabwe)",
    "nds" to "dolnoněmčina",
    "nds-NL" to "dolnosaština",
    "ne" to "nepálština",
    "new" to "névárština",
    "ng" to "ndondština",
    "nia" to "nias",
    "niu" to "niueština",
    "njo" to "ao (jazyky Nágálandu)",
    "nl" to "nizozemština",
    "nl-BE" to "vlámština",
    "nmg" to "kwasio",
    "nn" to "norština (nynorsk)",
    "nnh" to "ngiemboon",
    "no" to "norština",
    "nog" to "nogajština",
    "non" to "norština historická",
    "nov" to "novial",
    "nqo" to "n’ko",
    "nr" to "ndebele (Jižní Afrika)",
    "nso" to "sotština (severní)",
    "nus" to "nuerština",
    "nv" to "navažština",
    "nwc" to "newarština (klasická)",
    "ny" to "ňandžština",
    "nym" to "ňamwežština",
    "nyn" to "ňankolština",
    "nyo" to "ňorština",
    "nzi" to "nzima",
    "oc" to "okcitánština",
    "oj" to "odžibvejština",
    "ojb" to "odžibvejština (severozápadní)",
    "ojc" to "odžibvejština (střední)",
    "ojs" to "odžibvejština (severní)",
    "ojw" to "odžibvejština (západní)",
    "oka" to "okanaganština",
    "om" to "oromština",
    "or" to "urijština",
    "os" to "osetština",
    "osa" to "osage",
    "ota" to "turečtina (osmanská)",
    "pa" to "paňdžábština",
    "pag" to "pangasinanština",
    "pal" to "pahlavština",
    "pam" to "papangau",
    "pap" to "papiamento",
    "pau" to "palauština",
    "pcd" to "picardština",
    "pcm" to "nigerijský pidžin",
    "pdc" to "němčina (pensylvánská)",
    "pdt" to "němčina (plautdietsch)",
    "peo" to "staroperština",
    "pfl" to "falčtina",
    "phn" to "féničtina",
    "pi" to "pálí",
    "pis" to "pidžin (Šalomounovy ostrovy)",
    "pl" to "polština",
    "pms" to "piemonština",
    "pnt" to "pontština",
    "pon" to "pohnpeiština",
    "pqm" to "malesitština-passamaquoddština",
    "prg" to "pruština",
    "pro" to "provensálština",
    "ps" to "paštština",
    "pt" to "portugalština",
    "pt-PT" to "portugalština (Evropa)",
    "qu" to "kečuánština",
    "quc" to "kičé",
    "qug" to "kečuánština (chimborazo)",
    "raj" to "rádžastánština",
    "rap" to "rapanujština",
    "rar" to "rarotongánština",
    "rgn" to "romaňolština",
    "rhg" to "rohingština",
    "rif" to "rífština",
    "rm" to "rétorománština",
    "rn" to "kirundština",
    "ro" to "rumunština",
    "ro-MD" to "moldavština",
    "rof" to "rombo",
    "rom" to "romština",
    "rtm" to "rotumanština",
    "ru" to "ruština",
    "rue" to "rusínština",
    "rug" to "rovianština",
    "rup" to "arumunština",
    "rw" to "kiňarwandština",
    "rwk" to "rwa",
    "sa" to "sanskrt",
    "sad" to "sandawština",
    "sah" to "jakutština",
    "sam" to "samarština",
    "saq" to "samburu",
    "sas" to "sasakština",
    "sat" to "santálština",
    "saz" to "saurášterština",
    "sba" to "ngambay",
    "sbp" to "sangoština",
    "sc" to "sardština",
    "scn" to "sicilština",
    "sco" to "skotština",
    "sd" to "sindhština",
    "sdc" to "sassarština",
    "sdh" to "kurdština (jižní)",
    "se" to "sámština (severní)",
    "see" to "seneca",
    "seh" to "sena",
    "sei" to "seriština",
    "sel" to "selkupština",
    "ses" to "koyraboro senni",
    "sg" to "sangština",
    "sga" to "irština (stará)",
    "sgs" to "žemaitština",
    "sh" to "srbochorvatština",
    "shi" to "tašelhit",
    "shn" to "šanština",
    "shu" to "arabština (čadská)",
    "si" to "sinhálština",
    "sid" to "sidamo",
    "sk" to "slovenština",
    "sl" to "slovinština",
    "slh" to "lushootseed (jižní)",
    "sli" to "němčina (slezská)",
    "sly" to "selajarština",
    "sm" to "samojština",
    "sma" to "sámština (jižní)",
    "smj" to "sámština (lulejská)",
    "smn" to "sámština (inarijská)",
    "sms" to "sámština (skoltská)",
    "sn" to "šonština",
    "snk" to "sonikština",
    "so" to "somálština",
    "sog" to "sogdština",
    "sq" to "albánština",
    "sr" to "srbština",
    "srn" to "sranan tongo",
    "srr" to "sererština",
    "ss" to "siswatština",
    "ssy" to "saho",
    "st" to "sotština (jižní)",
    "stq" to "fríština (saterlandská)",
    "str" to "saliština (z úžin)",
    "su" to "sundština",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumerština",
    "sv" to "švédština",
    "sw" to "svahilština",
    "sw-CD" to "svahilština (Kongo)",
    "swb" to "komorština",
    "syc" to "syrština (klasická)",
    "syr" to "syrština",
    "szl" to "slezština",
    "ta" to "tamilština",
    "tce" to "tutčonština (jižní)",
    "tcy" to "tuluština",
    "te" to "telugština",
    "tem" to "temne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetumština",
    "tg" to "tádžičtina",
    "tgx" to "tagiš",
    "th" to "thajština",
    "tht" to "tahltan",
    "ti" to "tigrinijština",
    "tig" to "tigrejština",
    "tiv" to "tivština",
    "tk" to "turkmenština",
    "tkl" to "tokelauština",
    "tkr" to "cachurština",
    "tl" to "tagalog",
    "tlh" to "klingonština",
    "tli" to "tlingit",
    "tly" to "talyština",
    "tmh" to "tamašek",
    "tn" to "setswanština",
    "to" to "tongánština",
    "tog" to "tonžština (nyasa)",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turečtina",
    "tru" to "turojština",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsd" to "tsakonština",
    "tsi" to "tsimšijské jazyky",
    "tt" to "tatarština",
    "ttm" to "tutčonština (severní)",
    "ttt" to "tatština",
    "tum" to "tumbukština",
    "tvl" to "tuvalština",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitština",
    "tyv" to "tuvinština",
    "tzm" to "tamazight (střední Maroko)",
    "udm" to "udmurtština",
    "ug" to "ujgurština",
    "uga" to "ugaritština",
    "uk" to "ukrajinština",
    "umb" to "umbundu",
    "und" to "neznámý jazyk",
    "ur" to "urdština",
    "uz" to "uzbečtina",
    "ve" to "venda",
    "vec" to "benátština",
    "vep" to "vepština",
    "vi" to "vietnamština",
    "vls" to "vlámština (západní)",
    "vmf" to "němčina (mohansko-franské dialekty)",
    "vmw" to "makhuwština",
    "vo" to "volapük",
    "vot" to "votština",
    "vro" to "võruština",
    "vun" to "vunjo",
    "wa" to "valonština",
    "wae" to "němčina (walser)",
    "wal" to "wolajtština",
    "war" to "warajština",
    "was" to "waština",
    "wbp" to "warlpiri",
    "wo" to "wolofština",
    "wuu" to "čínština (dialekty Wu)",
    "xal" to "kalmyčtina",
    "xh" to "xhoština",
    "xmf" to "mingrelština",
    "xnr" to "kángrí",
    "xog" to "sogština",
    "yao" to "jaoština",
    "yap" to "japština",
    "yav" to "jangbenština",
    "ybb" to "yemba",
    "yi" to "jidiš",
    "yo" to "jorubština",
    "yrl" to "nheengatu",
    "yue" to "kantonština",
    "yue-alt-menu" to "čínština (kantonština)",
    "za" to "čuangština",
    "zap" to "zapotéčtina",
    "zbl" to "bliss systém",
    "zea" to "zélandština",
    "zen" to "zenaga",
    "zgh" to "tamazight (standardní marocký)",
    "zh" to "čínština",
    "zh-alt-menu" to "standardní čínština",
    "zh-Hans" to "čínština (zjednodušená)",
    "zh-Hans-alt-long" to "standardní čínština (zjednodušená)",
    "zh-Hant-alt-long" to "standardní čínština (tradiční)",
    "zu" to "zuluština",
    "zun" to "zunijština",
    "zxx" to "žádný jazykový obsah",
    "zza" to "zaza",
  ) }

  val csw: ImmutableMap<String, String> by lazy { immutableMapOf(
    "chr" to "ᒉᕑᐅᑫᕀ",
    "csw" to "ᓀᐦᐃᓇᐍᐏᐣ",
    "en" to "ᐊᑲᓈᓰᒧᐏᐣ",
    "en-AU" to "ᐊᑲᓈᓰᒧᐏᐣ (AU)",
    "en-CA" to "ᐊᑲᓈᓰᒧᐏᐣ (ᑳᓇᑕ)",
    "en-GB" to "ᐊᑲᓈᓰᒧᐏᐣ (GB)",
    "en-GB-alt-short" to "ᐊᑲᓈᓰᒧᐏᐣ (GB)",
    "en-US" to "ᐊᑲᓈᓰᒧᐏᐣ (US)",
    "en-US-alt-short" to "ᐊᑲᓈᓰᒧᐏᐣ (US)",
    "fr" to "ᐹᕽᐘᔦᓰᒧᐏᐣ",
    "fr-CA" to "ᐹᕽᐘᔦᓰᒧᐏᐣ (ᑳᓇᑕ)",
    "fr-CH" to "ᐹᕽᐘᔦᓰᒧᐏᐣ (CH)",
    "he" to "ᐦᐄᑊᕑᐅᐤ",
    "mul" to "ᒥᐦᒉᐟ ᐊᔭᒧᐏᓇ",
    "und" to "ᓇᒨᓇ ᐃᐦᑕᐟᐘᐣ ᐊᔭᒧᐏᐣ",
  ) }

  val cv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar" to "арап",
    "ar-001" to "арап литератури",
    "bn" to "бенгал",
    "cv" to "чӑваш",
    "de" to "нимӗҫ",
    "de-AT" to "австрин нимӗҫ",
    "de-CH" to "швейцарин нимӗҫ",
    "en" to "акӑлчан",
    "en-AU" to "австралин акӑлчан",
    "en-CA" to "канадӑн акӑлчан",
    "en-GB" to "британин акӑлчан",
    "en-GB-alt-short" to "британин акӑлчан",
    "en-US" to "америкӑн акӑлчан",
    "en-US-alt-short" to "америкӑн акӑлчан",
    "es" to "испани",
    "es-419" to "латинла америкӑн испани",
    "es-ES" to "европӑн испани",
    "es-MX" to "мексикӑн испани",
    "fr" to "франци",
    "fr-CA" to "канадӑн франци",
    "fr-CH" to "швейцарӗн франци",
    "hi" to "хинди",
    "id" to "индонези",
    "it" to "итали",
    "ja" to "япони",
    "ko" to "корей",
    "nl" to "голланди",
    "nl-BE" to "фламанди",
    "pl" to "поляк",
    "pt" to "португали",
    "pt-BR" to "бразилин португали",
    "pt-PT" to "европӑн португали",
    "ru" to "вырӑс",
    "th" to "тай",
    "tr" to "турккӑ",
    "und" to "паллӑ мар чӗлхе",
    "zh" to "китай",
    "zh-alt-menu" to "ҫурҫӗр китай",
    "zh-Hans" to "китай, ҫӑмӑллатнӑ ҫыру",
    "zh-Hans-alt-long" to "ҫурҫӗр китай, ҫӑмӑллатнӑ ҫыру",
    "zh-Hant" to "китай, традициллӗ ҫыру",
    "zh-Hant-alt-long" to "ҫурҫӗр китай, традициллӗ ҫыру",
  ) }

  val cy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Affareg",
    "ab" to "Abchaseg",
    "ace" to "Acehneg",
    "ach" to "Acoli",
    "ada" to "Adangmeg",
    "ady" to "Circaseg Gorllewinol",
    "ae" to "Afestaneg",
    "aeb" to "Arabeg Tunisia",
    "af" to "Affricaneg",
    "afh" to "Affrihili",
    "agq" to "Aghemeg",
    "ain" to "Ainŵeg",
    "ak" to "Acaneg",
    "akk" to "Acadeg",
    "akz" to "Alabamäeg",
    "ale" to "Alewteg",
    "aln" to "Ghegeg Albania",
    "alt" to "Altäeg Deheuol",
    "am" to "Amhareg",
    "an" to "Aragoneg",
    "ang" to "Hen Saesneg",
    "ann" to "Obolo",
    "anp" to "Angika",
    "ar" to "Arabeg",
    "ar-001" to "Arabeg Modern Safonol",
    "arc" to "Aramaeg",
    "arn" to "Arawcaneg",
    "aro" to "Araonaeg",
    "arp" to "Arapaho",
    "arq" to "Arabeg Algeria",
    "ars" to "Arabeg Najdi",
    "arw" to "Arawaceg",
    "ary" to "Arabeg Moroco",
    "arz" to "Arabeg yr Aifft",
    "as" to "Asameg",
    "asa" to "Asw",
    "ase" to "Iaith Arwyddion America",
    "ast" to "Astwrianeg",
    "atj" to "Atikamekw",
    "av" to "Afareg",
    "awa" to "Awadhi",
    "ay" to "Aymareg",
    "az" to "Aserbaijaneg",
    "az-alt-short" to "Aserbaijaneg",
    "az-Arab" to "Aserbaijaneg Deheuol",
    "ba" to "Bashcorteg",
    "bal" to "Balwtsi",
    "ban" to "Balïeg",
    "bas" to "Basâeg",
    "bax" to "Bamwmeg",
    "be" to "Belarwseg",
    "bej" to "Bejäeg",
    "bem" to "Bembeg",
    "bez" to "Bena",
    "bfd" to "Baffwteg",
    "bfq" to "Badaga",
    "bg" to "Bwlgareg",
    "bgc" to "Haryanvi",
    "bgn" to "Balochi Gorllewinol",
    "bho" to "Bhojpuri",
    "bi" to "Bislama",
    "bin" to "Bini",
    "bkm" to "Comeg",
    "bla" to "Siksika",
    "blo" to "Anii",
    "bm" to "Bambareg",
    "bn" to "Bengaleg",
    "bo" to "Tibeteg",
    "br" to "Llydaweg",
    "brh" to "Brahui",
    "brx" to "Bodo",
    "bs" to "Bosnieg",
    "bss" to "Acwseg",
    "bua" to "Bwriateg",
    "bug" to "Bwginaeg",
    "bum" to "Bwlw",
    "byn" to "Blin",
    "ca" to "Catalaneg",
    "cad" to "Cado",
    "car" to "Caribeg",
    "cay" to "Cayuga",
    "cch" to "Atsameg",
    "ccp" to "Tsiacma",
    "ce" to "Tsietsieneg",
    "ceb" to "Cebuano",
    "cgg" to "Tsiga",
    "ch" to "Tsiamorro",
    "chk" to "Chuukaeg",
    "chm" to "Marieg",
    "cho" to "Siocto",
    "chp" to "Chipewyan",
    "chr" to "Tsierocî",
    "chy" to "Cheyenne",
    "ckb" to "Cwrdeg Sorani",
    "ckb-alt-menu" to "Cwrdeg Sorani",
    "ckb-alt-variant" to "Cwrdeg Sorani",
    "clc" to "Chilcotin",
    "co" to "Corseg",
    "cop" to "Copteg",
    "cr" to "Cri",
    "crg" to "Michif",
    "crh" to "Tyrceg y Crimea",
    "crj" to "Cree De Ddwyrain",
    "crk" to "Plains Cree",
    "crl" to "Gogledd Dwyrain Cree",
    "crm" to "Moose Cree",
    "crr" to "Carolina Algonquian",
    "crs" to "Ffrangeg Seselwa Creole",
    "cs" to "Tsieceg",
    "csw" to "Swampy Cree",
    "cu" to "Hen Slafoneg",
    "cv" to "Tshwfasheg",
    "cy" to "Cymraeg",
    "da" to "Daneg",
    "dak" to "Dacotaeg",
    "dar" to "Dargwa",
    "dav" to "Taita",
    "de" to "Almaeneg",
    "de-AT" to "Almaeneg Awstria",
    "de-CH" to "Almaeneg Safonol y Swistir",
    "dgr" to "Dogrib",
    "din" to "Dinca",
    "dje" to "Sarmaeg",
    "doi" to "Dogri",
    "dsb" to "Sorbeg Isaf",
    "dua" to "Diwaleg",
    "dum" to "Iseldireg Canol",
    "dv" to "Difehi",
    "dyo" to "Jola-Fonyi",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embw",
    "ee" to "Ewe",
    "efi" to "Efik",
    "egy" to "Hen Eiffteg",
    "eka" to "Ekajuk",
    "el" to "Groeg",
    "elx" to "Elameg",
    "en" to "Saesneg",
    "en-AU" to "Saesneg Awstralia",
    "en-CA" to "Saesneg Canada",
    "en-GB" to "Saesneg Prydain",
    "en-GB-alt-short" to "Saesneg (DU)",
    "en-US" to "Saesneg America",
    "en-US-alt-short" to "Saesneg (UDA)",
    "enm" to "Saesneg Canol",
    "eo" to "Esperanto",
    "es" to "Sbaeneg",
    "es-419" to "Sbaeneg America Ladin",
    "es-ES" to "Sbaeneg Ewrop",
    "es-MX" to "Sbaeneg Mecsico",
    "et" to "Estoneg",
    "eu" to "Basgeg",
    "ewo" to "Ewondo",
    "ext" to "Extremadureg",
    "fa" to "Perseg",
    "fa-AF" to "Dari",
    "fat" to "Ffanti",
    "ff" to "Ffwla",
    "fi" to "Ffinneg",
    "fil" to "Ffilipineg",
    "fit" to "Ffinneg Tornedal",
    "fj" to "Ffijïeg",
    "fo" to "Ffaröeg",
    "fon" to "Fon",
    "fr" to "Ffrangeg",
    "fr-CA" to "Ffrangeg Canada",
    "fr-CH" to "Ffrangeg y Swistir",
    "frc" to "Ffrangeg Cajwn",
    "frm" to "Ffrangeg Canol",
    "fro" to "Hen Ffrangeg",
    "frp" to "Arpitaneg",
    "frr" to "Ffriseg Gogleddol",
    "frs" to "Ffriseg y Dwyrain",
    "fur" to "Ffriwleg",
    "fy" to "Ffriseg y Gorllewin",
    "ga" to "Gwyddeleg",
    "gaa" to "Ga",
    "gag" to "Gagauz",
    "gay" to "Gaio",
    "gba" to "Gbaia",
    "gbz" to "Dareg y Zoroastriaid",
    "gd" to "Gaeleg yr Alban",
    "gez" to "Geez",
    "gil" to "Gilberteg",
    "gl" to "Galisieg",
    "gmh" to "Almaeneg Uchel Canol",
    "gn" to "Guaraní",
    "goh" to "Hen Almaeneg Uchel",
    "gor" to "Gorontalo",
    "got" to "Gotheg",
    "grc" to "Hen Roeg",
    "gsw" to "Almaeneg y Swistir",
    "gu" to "Gwjarati",
    "guz" to "Gusii",
    "gv" to "Manaweg",
    "gwi" to "Gwichʼin",
    "ha" to "Hawsa",
    "hai" to "Haida",
    "haw" to "Hawäieg",
    "hax" to "Haida Deheuol",
    "he" to "Hebraeg",
    "hi" to "Hindi",
    "hi-Latn-alt-variant" to "Hinglish",
    "hil" to "Hiligaynon",
    "hit" to "Hetheg",
    "hmn" to "Hmongeg",
    "hr" to "Croateg",
    "hsb" to "Sorbeg Uchaf",
    "ht" to "Creol Haiti",
    "hu" to "Hwngareg",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Armeneg",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Ibaneg",
    "ibb" to "Ibibio",
    "id" to "Indoneseg",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Nwosw",
    "ik" to "Inwpiaceg",
    "ikt" to "Inuktitut Canadaidd Gorllewinol",
    "ilo" to "Ilocaneg",
    "inh" to "Ingwsieg",
    "io" to "Ido",
    "is" to "Islandeg",
    "it" to "Eidaleg",
    "iu" to "Inwctitwt",
    "ja" to "Japaneeg",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Matsiame",
    "jpr" to "Iddew-Bersieg",
    "jrb" to "Iddew-Arabeg",
    "jv" to "Jafanaeg",
    "ka" to "Georgeg",
    "kaa" to "Cara-Calpaceg",
    "kab" to "Cabileg",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Camba",
    "kbd" to "Cabardieg",
    "kcg" to "Tyapeg",
    "kde" to "Macondeg",
    "kea" to "Caboferdianeg",
    "kfo" to "Koro",
    "kg" to "Congo",
    "kgp" to "Kaingang",
    "kha" to "Càseg",
    "khq" to "Koyra Chiini",
    "khw" to "Chowareg",
    "ki" to "Kikuyu",
    "kj" to "Kuanyama",
    "kk" to "Casacheg",
    "kkj" to "Kako",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Chmereg",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Coreeg",
    "koi" to "Komi-Permyak",
    "kok" to "Concani",
    "kpe" to "Kpelle",
    "kr" to "Canwri",
    "krc" to "Karachay-Balkar",
    "krl" to "Careleg",
    "kru" to "Kurukh",
    "ks" to "Cashmireg",
    "ksb" to "Shambala",
    "ksf" to "Baffia",
    "ksh" to "Cwleneg",
    "ku" to "Cwrdeg",
    "kum" to "Cwmiceg",
    "kv" to "Comi",
    "kw" to "Cernyweg",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kuvi",
    "ky" to "Cirgiseg",
    "la" to "Lladin",
    "lad" to "Iddew-Sbaeneg",
    "lag" to "Langi",
    "lah" to "Lahnda",
    "lam" to "Lamba",
    "lb" to "Lwcsembwrgeg",
    "lez" to "Lezgheg",
    "lg" to "Ganda",
    "li" to "Limbwrgeg",
    "lij" to "Ligwreg",
    "lil" to "Lillooet",
    "lkt" to "Lakota",
    "lmo" to "Lombardeg",
    "ln" to "Lingala",
    "lo" to "Laoeg",
    "lol" to "Mongo",
    "lou" to "Louisiana Creole",
    "loz" to "Lozi",
    "lrc" to "Luri Gogleddol",
    "lsm" to "Saamia",
    "lt" to "Lithwaneg",
    "ltg" to "Latgaleg",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lun" to "Lwnda",
    "luo" to "Lŵo",
    "lus" to "Lwshaieg",
    "luy" to "Lwyia",
    "lv" to "Latfieg",
    "mad" to "Madwreg",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Macasareg",
    "man" to "Mandingo",
    "mas" to "Masai",
    "mdf" to "Mocsia",
    "mdr" to "Mandareg",
    "men" to "Mendeg",
    "mer" to "Mêrw",
    "mfe" to "Morisyen",
    "mg" to "Malagaseg",
    "mga" to "Gwyddeleg Canol",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Meta",
    "mh" to "Marsialeg",
    "mi" to "Māori",
    "mic" to "Micmaceg",
    "min" to "Minangkabau",
    "mk" to "Macedoneg",
    "ml" to "Malayalam",
    "mn" to "Mongoleg",
    "mnc" to "Manshw",
    "mni" to "Manipwri",
    "moe" to "Innu-aimun",
    "moh" to "Mohoceg",
    "mos" to "Mosi",
    "mr" to "Marathi",
    "mrj" to "Mari Gorllewinol",
    "ms" to "Maleieg",
    "mt" to "Malteg",
    "mua" to "Mundang",
    "mul" to "Mwy nag un iaith",
    "mus" to "Creek",
    "mwl" to "Mirandeg",
    "mwr" to "Marwari",
    "my" to "Byrmaneg",
    "myv" to "Erzya",
    "mzn" to "Masanderani",
    "na" to "Nawrŵeg",
    "nap" to "Naplieg",
    "naq" to "Nama",
    "nb" to "Norwyeg Bokmål",
    "nd" to "Ndebele Gogleddol",
    "nds" to "Almaeneg Isel",
    "nds-NL" to "Sacsoneg Isel",
    "ne" to "Nepaleg",
    "new" to "Newaeg",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niuean",
    "njo" to "Ao Naga",
    "nl" to "Iseldireg",
    "nl-BE" to "Fflemeg",
    "nmg" to "Kwasio",
    "nn" to "Norwyeg Nynorsk",
    "nnh" to "Ngiemboon",
    "no" to "Norwyeg",
    "nog" to "Nogai",
    "non" to "Hen Norseg",
    "nqo" to "N’Ko",
    "nr" to "Ndebele Deheuol",
    "nso" to "Sotho Gogleddol",
    "nus" to "Nŵereg",
    "nv" to "Nafaho",
    "nwc" to "Hen Newari",
    "ny" to "Nianja",
    "nym" to "Niamwezi",
    "nyn" to "Niancole",
    "nyo" to "Nioro",
    "nzi" to "Nzimeg",
    "oc" to "Ocsitaneg",
    "oj" to "Ojibwa",
    "ojb" to "Ojibwa gogledd-orllewin",
    "ojc" to "Ojibwa Canolog",
    "ojs" to "Oji-Cree",
    "ojw" to "Ojibwa Gorllewinol",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Odia",
    "os" to "Oseteg",
    "osa" to "Osageg",
    "ota" to "Tyrceg Otoman",
    "pa" to "Pwnjabeg",
    "pag" to "Pangasineg",
    "pal" to "Pahlafi",
    "pam" to "Pampanga",
    "pap" to "Papiamento",
    "pau" to "Palawan",
    "pcd" to "Picardeg",
    "pcm" to "Pidgin Nigeria",
    "pdc" to "Almaeneg Pensylfania",
    "peo" to "Hen Bersieg",
    "pfl" to "Almaeneg Palatin",
    "phn" to "Phoeniceg",
    "pi" to "Pali",
    "pis" to "Pijin",
    "pl" to "Pwyleg",
    "pms" to "Piedmonteg",
    "pnt" to "Ponteg",
    "pon" to "Pohnpeianeg",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Prwseg",
    "pro" to "Hen Brofensaleg",
    "ps" to "Pashto",
    "pt" to "Portiwgaleg",
    "pt-BR" to "Portiwgaleg Brasil",
    "pt-PT" to "Portiwgaleg Ewrop",
    "qu" to "Quechua",
    "quc" to "K’iche’",
    "raj" to "Rajasthaneg",
    "rap" to "Rapanŵi",
    "rar" to "Raratongeg",
    "rhg" to "Rohingya",
    "rm" to "Románsh",
    "rn" to "Rwndi",
    "ro" to "Rwmaneg",
    "ro-MD" to "Moldofeg",
    "rof" to "Rombo",
    "rom" to "Romani",
    "rtm" to "Rotumaneg",
    "ru" to "Rwseg",
    "rup" to "Aromaneg",
    "rw" to "Ciniarŵandeg",
    "rwk" to "Rwa",
    "sa" to "Sansgrit",
    "sad" to "Sandäweg",
    "sah" to "Sakha",
    "sam" to "Aramaeg Samaria",
    "saq" to "Sambŵrw",
    "sas" to "Sasaceg",
    "sat" to "Santali",
    "sba" to "Ngambeieg",
    "sbp" to "Sangw",
    "sc" to "Sardeg",
    "scn" to "Sisileg",
    "sco" to "Sgoteg",
    "sd" to "Sindhi",
    "sdc" to "Sasareseg Sardinia",
    "sdh" to "Cwrdeg Deheuol",
    "se" to "Sami Gogleddol",
    "see" to "Seneca",
    "seh" to "Sena",
    "sei" to "Seri",
    "sel" to "Selcypeg",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "sga" to "Hen Wyddeleg",
    "sgs" to "Samogiteg",
    "sh" to "Serbo-Croateg",
    "shi" to "Tachelhit",
    "shn" to "Shan",
    "shu" to "Arabeg Chad",
    "si" to "Sinhaleg",
    "sid" to "Sidamo",
    "sk" to "Slofaceg",
    "sl" to "Slofeneg",
    "slh" to "Lushootseed Deheuol",
    "sli" to "Is-silesieg",
    "sm" to "Samöeg",
    "sma" to "Sami Deheuol",
    "smj" to "Sami Lwle",
    "smn" to "Inari Sami",
    "sms" to "Sami Scolt",
    "sn" to "Shona",
    "snk" to "Soninceg",
    "so" to "Somaleg",
    "sog" to "Sogdeg",
    "sq" to "Albaneg",
    "sr" to "Serbeg",
    "srn" to "Sranan Tongo",
    "srr" to "Serereg",
    "ss" to "Swati",
    "ssy" to "Saho",
    "st" to "Sesotheg Deheuol",
    "stq" to "Ffriseg Saterland",
    "str" to "Straits Salish",
    "su" to "Swndaneg",
    "suk" to "Swcwma",
    "sus" to "Swsŵeg",
    "sux" to "Swmereg",
    "sv" to "Swedeg",
    "sw" to "Swahili",
    "sw-CD" to "Swahili’r Congo",
    "swb" to "Comoreg",
    "syc" to "Hen Syrieg",
    "syr" to "Syrieg",
    "szl" to "Silesieg",
    "ta" to "Tamileg",
    "tce" to "Tutchone Deheuol",
    "tcy" to "Tulu",
    "te" to "Telugu",
    "tem" to "Timneg",
    "teo" to "Teso",
    "ter" to "Terena",
    "tet" to "Tetumeg",
    "tg" to "Tajiceg",
    "tgx" to "Tagish",
    "th" to "Thai",
    "tht" to "Tahltan",
    "ti" to "Tigrinya",
    "tig" to "Tigreg",
    "tiv" to "Tifeg",
    "tk" to "Tyrcmeneg",
    "tkl" to "Tocelaweg",
    "tkr" to "Tsakhureg",
    "tl" to "Tagalog",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tly" to "Talysheg",
    "tmh" to "Tamasheceg",
    "tn" to "Tswana",
    "to" to "Tongeg",
    "tok" to "Toki Pona",
    "tpi" to "Tok Pisin",
    "tr" to "Tyrceg",
    "trv" to "Taroko",
    "ts" to "Tsongaeg",
    "tsd" to "Tsaconeg",
    "tt" to "Tatareg",
    "ttm" to "Tutchone gogleddol",
    "tum" to "Twmbwca",
    "tvl" to "Twfalweg",
    "tw" to "Twi",
    "twq" to "Tasawaq",
    "ty" to "Tahitïeg",
    "tyv" to "Twfwnieg",
    "tzm" to "Tamazight Canol yr Atlas",
    "udm" to "Fotiaceg",
    "ug" to "Uighur",
    "uga" to "Wgariteg",
    "uk" to "Wcreineg",
    "umb" to "Umbundu",
    "und" to "Iaith anhysbys",
    "ur" to "Wrdw",
    "uz" to "Wsbeceg",
    "vai" to "Faieg",
    "ve" to "Fendeg",
    "vec" to "Feniseg",
    "vep" to "Feps",
    "vi" to "Fietnameg",
    "vls" to "Fflemeg Gorllewinol",
    "vmw" to "Macua",
    "vo" to "Folapük",
    "vot" to "Foteg",
    "vun" to "Funjo",
    "wa" to "Walwneg",
    "wae" to "Walsereg",
    "wal" to "Walamo",
    "war" to "Winarayeg",
    "was" to "Washo",
    "wbp" to "Warlpiri",
    "wo" to "Woloff",
    "wuu" to "Wu Tsieineaidd",
    "xal" to "Calmyceg",
    "xh" to "Xhosa",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yav" to "Iangben",
    "ybb" to "Iembaeg",
    "yi" to "Iddew-Almaeneg",
    "yo" to "Iorwba",
    "yrl" to "Nheengatu",
    "yue" to "Cantoneeg",
    "yue-alt-menu" to "Tsieinëeg, Cantoneg",
    "za" to "Zhuang",
    "zap" to "Zapoteceg",
    "zbl" to "Blisssymbols",
    "zea" to "Zêlandeg",
    "zgh" to "Tamaseit Moroco Safonol",
    "zh" to "Tsieinëeg",
    "zh-alt-menu" to "Tsieinëeg, Mandarin",
    "zh-Hans" to "Tsieinëeg Symledig",
    "zh-Hans-alt-long" to "Tsieinëeg Mandarin Symledig",
    "zh-Hant" to "Tsieinëeg Traddodiadol",
    "zh-Hant-alt-long" to "Tsieinëeg Mandarin Traddodiadol",
    "zu" to "Swlw",
    "zun" to "Swni",
    "zxx" to "Dim cynnwys ieithyddol",
    "zza" to "Sasäeg",
  ) }

  val da: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abkhasisk",
    "ace" to "achinesisk",
    "ach" to "acoli",
    "ada" to "adangme",
    "ady" to "adyghe",
    "ae" to "avestan",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "akan",
    "akk" to "akkadisk",
    "ale" to "aleutisk",
    "alt" to "sydaltaisk",
    "am" to "amharisk",
    "an" to "aragonsk",
    "ang" to "oldengelsk",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "arabisk",
    "ar-001" to "moderne standardarabisk",
    "arc" to "aramæisk",
    "arn" to "mapudungun",
    "arp" to "arapaho",
    "ars" to "Najd-arabisk",
    "ars-alt-menu" to "arabisk, najdi",
    "arw" to "arawak",
    "as" to "assamesisk",
    "asa" to "asu",
    "ast" to "asturisk",
    "atj" to "atikamekw",
    "av" to "avarisk",
    "awa" to "awadhi",
    "ay" to "aymara",
    "az" to "aserbajdsjansk",
    "az-alt-short" to "azeri",
    "ba" to "bashkir",
    "bal" to "baluchi",
    "ban" to "balinesisk",
    "bas" to "basaa",
    "bax" to "bamun",
    "bbj" to "ghomala",
    "be" to "belarusisk",
    "bej" to "beja",
    "bem" to "bemba",
    "bez" to "bena",
    "bfd" to "bafut",
    "bg" to "bulgarsk",
    "bgc" to "harianvi",
    "bgn" to "vestbaluchi",
    "bho" to "bhojpuri",
    "bi" to "bislama",
    "bik" to "bikol",
    "bin" to "bini",
    "bkm" to "kom",
    "bla" to "siksika",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bengali",
    "bo" to "tibetansk",
    "br" to "bretonsk",
    "bra" to "braj",
    "brx" to "bodo",
    "bs" to "bosnisk",
    "bss" to "bakossi",
    "bua" to "buriatisk",
    "bug" to "buginesisk",
    "bum" to "bulu",
    "byn" to "blin",
    "byv" to "medumba",
    "ca" to "catalansk",
    "cad" to "caddo",
    "car" to "caribisk",
    "cay" to "cayuga",
    "cch" to "atsam",
    "ccp" to "chakma",
    "ce" to "tjetjensk",
    "ceb" to "cebuano",
    "cgg" to "chiga",
    "ch" to "chamorro",
    "chb" to "chibcha",
    "chg" to "chagatai",
    "chk" to "chuukese",
    "chm" to "mari",
    "chn" to "chinook",
    "cho" to "choctaw",
    "chp" to "chipewyan",
    "chr" to "cherokee",
    "chy" to "cheyenne",
    "ckb" to "sorani",
    "ckb-alt-menu" to "kurdisk, sorani",
    "ckb-alt-variant" to "centralkurdisk",
    "clc" to "chilcotin",
    "co" to "korsikansk",
    "cop" to "koptisk",
    "cr" to "cree",
    "crg" to "michif",
    "crh" to "krimtatarisk",
    "crj" to "sydøstcree",
    "crk" to "plains cree",
    "crl" to "nordøstcree",
    "crm" to "Moose-cree",
    "crr" to "carolina algonquisk",
    "crs" to "seselwa (kreol-fransk)",
    "cs" to "tjekkisk",
    "csb" to "kasjubisk",
    "csw" to "swampy cree",
    "cu" to "kirkeslavisk",
    "cv" to "tjuvasjisk",
    "cy" to "walisisk",
    "da" to "dansk",
    "dak" to "dakota",
    "dar" to "dargwa",
    "dav" to "taita",
    "de" to "tysk",
    "de-AT" to "østrigsk tysk",
    "de-CH" to "schweizerhøjtysk",
    "del" to "delaware",
    "den" to "athapaskisk",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "nedersorbisk",
    "dua" to "duala",
    "dum" to "middelhollandsk",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dyu" to "dyula",
    "dz" to "dzongkha",
    "dzg" to "dazaga",
    "ebu" to "kiembu",
    "ee" to "ewe",
    "efi" to "efik",
    "egy" to "oldegyptisk",
    "eka" to "ekajuk",
    "el" to "græsk",
    "elx" to "elamitisk",
    "en" to "engelsk",
    "en-AU" to "australsk engelsk",
    "en-CA" to "canadisk engelsk",
    "en-GB" to "britisk engelsk",
    "en-GB-alt-short" to "britisk engelsk",
    "en-US" to "amerikansk engelsk",
    "en-US-alt-short" to "amerikansk engelsk",
    "enm" to "middelengelsk",
    "eo" to "esperanto",
    "es" to "spansk",
    "es-419" to "latinamerikansk spansk",
    "es-ES" to "europæisk spansk",
    "es-MX" to "mexicansk spansk",
    "et" to "estisk",
    "eu" to "baskisk",
    "ewo" to "ewondo",
    "fa" to "persisk",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fulah",
    "fi" to "finsk",
    "fil" to "filippinsk",
    "fj" to "fijiansk",
    "fo" to "færøsk",
    "fon" to "fon",
    "fr" to "fransk",
    "fr-CA" to "canadisk fransk",
    "fr-CH" to "schweizisk fransk",
    "frc" to "cajunfransk",
    "frm" to "middelfransk",
    "fro" to "oldfransk",
    "frr" to "nordfrisisk",
    "frs" to "østfrisisk",
    "fur" to "friulisk",
    "fy" to "vestfrisisk",
    "ga" to "irsk",
    "gaa" to "ga",
    "gag" to "gagauzisk",
    "gan" to "gan-kinesisk",
    "gay" to "gayo",
    "gba" to "gbaya",
    "gd" to "skotsk gælisk",
    "gez" to "geez",
    "gil" to "gilbertesisk",
    "gl" to "galicisk",
    "gmh" to "middelhøjtysk",
    "gn" to "guarani",
    "goh" to "oldhøjtysk",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gotisk",
    "grb" to "grebo",
    "grc" to "oldgræsk",
    "gsw" to "schweizertysk",
    "gu" to "gujarati",
    "guz" to "gusii",
    "gv" to "manx",
    "gwi" to "gwichin",
    "ha" to "hausa",
    "hai" to "haida",
    "hak" to "hakka-kinesisk",
    "haw" to "hawaiiansk",
    "hax" to "sydhaida",
    "he" to "hebraisk",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hinglish",
    "hil" to "hiligaynon",
    "hit" to "hittitisk",
    "hmn" to "hmong",
    "ho" to "hirimotu",
    "hr" to "kroatisk",
    "hsb" to "øvresorbisk",
    "hsn" to "xiang-kinesisk",
    "ht" to "haitisk",
    "hu" to "ungarsk",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armensk",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonesisk",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "sichuan yi",
    "ik" to "inupiaq",
    "ikt" to "vestcanadisk inuktitut",
    "ilo" to "iloko",
    "inh" to "ingush",
    "io" to "ido",
    "is" to "islandsk",
    "it" to "italiensk",
    "iu" to "inuktitut",
    "ja" to "japansk",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jpr" to "jødisk-persisk",
    "jrb" to "jødisk-arabisk",
    "jv" to "javanesisk",
    "ka" to "georgisk",
    "kaa" to "karakalpakisk",
    "kab" to "kabylsk",
    "kac" to "kachin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kawi",
    "kbd" to "kabardian",
    "kbl" to "kanembu",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "kapverdisk",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "kaingang",
    "kha" to "khasi",
    "kho" to "khotanesisk",
    "khq" to "koyra-chiini",
    "ki" to "kikuyu",
    "kj" to "kuanyama",
    "kk" to "kasakhisk",
    "kkj" to "kako",
    "kl" to "grønlandsk",
    "kln" to "kalenjin",
    "km" to "khmer",
    "kmb" to "kimbundu",
    "kn" to "kannada",
    "ko" to "koreansk",
    "koi" to "komi-permjakisk",
    "kok" to "konkani",
    "kos" to "kosraean",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karatjai-balkar",
    "krl" to "karelsk",
    "kru" to "kurukh",
    "ks" to "kashmiri",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "kölsch",
    "ku" to "kurdisk",
    "kum" to "kymyk",
    "kut" to "kutenaj",
    "kv" to "komi",
    "kw" to "cornisk",
    "kwk" to "kwakʼwala",
    "kxv" to "kuvi",
    "ky" to "kirgisisk",
    "la" to "latin",
    "lad" to "ladino",
    "lag" to "langi",
    "lah" to "lahnda",
    "lam" to "lamba",
    "lb" to "luxembourgsk",
    "lez" to "lezghian",
    "lg" to "ganda",
    "li" to "limburgsk",
    "lij" to "ligurisk",
    "lil" to "lillooet",
    "lkt" to "lakota",
    "lmo" to "lombardisk",
    "ln" to "lingala",
    "lo" to "lao",
    "lol" to "mongo",
    "lou" to "Louisiana-kreolsk",
    "loz" to "lozi",
    "lrc" to "nordluri",
    "lsm" to "saamia",
    "lt" to "litauisk",
    "lu" to "luba-Katanga",
    "lua" to "luba-Lulua",
    "lui" to "luiseno",
    "lun" to "lunda",
    "lus" to "lushai",
    "luy" to "luyana",
    "lv" to "lettisk",
    "mad" to "madurese",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makasar",
    "man" to "mandingo",
    "mas" to "masai",
    "mde" to "maba",
    "mdf" to "moksha",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "morisyen",
    "mg" to "malagassisk",
    "mga" to "middelirsk",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta",
    "mh" to "marshallese",
    "mi" to "maori",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "makedonsk",
    "ml" to "malayalam",
    "mn" to "mongolsk",
    "mnc" to "manchu",
    "mni" to "manipuri",
    "moe" to "innu-aimun",
    "moh" to "mohawk",
    "mos" to "mossi",
    "mr" to "marathi",
    "ms" to "malajisk",
    "mt" to "maltesisk",
    "mua" to "mundang",
    "mul" to "flere sprog",
    "mus" to "creek",
    "mwl" to "mirandesisk",
    "mwr" to "marwari",
    "my" to "burmesisk",
    "mye" to "myene",
    "myv" to "erzya",
    "mzn" to "mazenisk",
    "na" to "nauru",
    "nan" to "min-kinesisk",
    "nap" to "napolitansk",
    "naq" to "nama",
    "nb" to "bokmål",
    "nd" to "nordndebele",
    "nds" to "nedertysk",
    "ne" to "nepalesisk",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niueansk",
    "nl" to "nederlandsk",
    "nl-BE" to "flamsk",
    "nmg" to "kwasio",
    "nn" to "nynorsk",
    "nnh" to "ngiemboon",
    "no" to "norsk",
    "nog" to "nogai",
    "non" to "oldislandsk",
    "nqo" to "n’ko",
    "nr" to "sydndebele",
    "nso" to "nordsotho",
    "nus" to "nuer",
    "nv" to "navajo",
    "nwc" to "klassisk newarisk",
    "ny" to "nyanja",
    "nym" to "nyamwezi",
    "nyn" to "nyankole",
    "nyo" to "nyoro-sprog",
    "nzi" to "nzima",
    "oc" to "occitansk",
    "oj" to "ojibwa",
    "ojb" to "nordvestojibwa",
    "ojc" to "centralojibwa",
    "ojs" to "oji-cree",
    "ojw" to "vestojibwa",
    "oka" to "okanagan",
    "om" to "oromo",
    "or" to "oriya",
    "os" to "ossetisk",
    "osa" to "osage",
    "ota" to "osmannisk tyrkisk",
    "pa" to "punjabi",
    "pag" to "pangasinan",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palauansk",
    "pcm" to "nigeriansk pidgin",
    "peo" to "oldpersisk",
    "phn" to "fønikisk",
    "pi" to "pali",
    "pis" to "pijin",
    "pl" to "polsk",
    "pon" to "ponape",
    "pqm" to "maliseet-passamaquoddy",
    "prg" to "preussisk",
    "pro" to "oldprovencalsk",
    "ps" to "pashto",
    "ps-alt-variant" to "pushto",
    "pt" to "portugisisk",
    "pt-BR" to "brasiliansk portugisisk",
    "pt-PT" to "europæisk portugisisk",
    "qu" to "quechua",
    "quc" to "quiché",
    "raj" to "rajasthani",
    "rap" to "rapanui",
    "rar" to "rarotonga",
    "rhg" to "rohingya",
    "rm" to "rætoromansk",
    "rn" to "rundi",
    "ro" to "rumænsk",
    "ro-MD" to "moldovisk",
    "rof" to "rombo",
    "rom" to "romani",
    "ru" to "russisk",
    "rup" to "arumænsk",
    "rw" to "kinyarwanda",
    "rwk" to "rwa",
    "sa" to "sanskrit",
    "sad" to "sandawe",
    "sah" to "jakutisk",
    "sam" to "samaritansk aramæisk",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sardinsk",
    "scn" to "siciliansk",
    "sco" to "skotsk",
    "sd" to "sindhi",
    "sdh" to "sydkurdisk",
    "se" to "nordsamisk",
    "see" to "seneca",
    "seh" to "sena",
    "sel" to "selkupisk",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sga" to "oldirsk",
    "sh" to "serbokroatisk",
    "shi" to "tachelhit",
    "shn" to "shan",
    "shu" to "tchadisk arabisk",
    "si" to "singalesisk",
    "sid" to "sidamo",
    "sk" to "slovakisk",
    "sl" to "slovensk",
    "slh" to "sydlushootseed",
    "sm" to "samoansk",
    "sma" to "sydsamisk",
    "smj" to "lulesamisk",
    "smn" to "enaresamisk",
    "sms" to "skoltesamisk",
    "sn" to "shona",
    "snk" to "soninke",
    "so" to "somali",
    "sog" to "sogdiansk",
    "sq" to "albansk",
    "sr" to "serbisk",
    "srn" to "sranan tongo",
    "srr" to "serer",
    "ss" to "swati",
    "ssy" to "saho",
    "st" to "sydsotho",
    "str" to "straits salish",
    "su" to "sundanesisk",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumerisk",
    "sv" to "svensk",
    "sw" to "swahili",
    "sw-CD" to "congolesisk swahili",
    "swb" to "comorisk",
    "syc" to "klassisk syrisk",
    "syr" to "syrisk",
    "szl" to "schlesisk",
    "ta" to "tamil",
    "tce" to "sydtutchone",
    "te" to "telugu",
    "tem" to "temne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetum",
    "tg" to "tadsjikisk",
    "tgx" to "tagish",
    "th" to "thai",
    "tht" to "tahltan",
    "ti" to "tigrinya",
    "tig" to "tigre",
    "tiv" to "tivi",
    "tk" to "turkmensk",
    "tkl" to "tokelau",
    "tl" to "tagalog",
    "tlh" to "klingon",
    "tli" to "tlingit",
    "tmh" to "tamashek",
    "tn" to "tswana",
    "to" to "tongansk",
    "tog" to "nyasa tongansk",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "tyrkisk",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsi" to "tsimshisk",
    "tt" to "tatarisk",
    "ttm" to "nordtutchone",
    "tum" to "tumbuka",
    "tvl" to "tuvaluansk",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitiansk",
    "tyv" to "tuvinian",
    "tzm" to "centralmarokkansk tamazight",
    "udm" to "udmurt",
    "ug" to "uygurisk",
    "ug-alt-variant" to "uighurisk",
    "uga" to "ugaristisk",
    "uk" to "ukrainsk",
    "umb" to "umbundu",
    "und" to "ukendt sprog",
    "ur" to "urdu",
    "uz" to "usbekisk",
    "ve" to "venda",
    "vec" to "venetiansk",
    "vi" to "vietnamesisk",
    "vmw" to "makhuwa",
    "vo" to "volapyk",
    "vot" to "votisk",
    "vun" to "vunjo",
    "wa" to "vallonsk",
    "wae" to "walsertysk",
    "wal" to "walamo",
    "war" to "waray",
    "was" to "washo",
    "wbp" to "walbiri",
    "wo" to "wolof",
    "wuu" to "wu-kinesisk",
    "xal" to "kalmyk",
    "xh" to "xhosa",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "yao",
    "yap" to "yapese",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "jiddisch",
    "yo" to "yoruba",
    "yrl" to "nheengatu",
    "yue" to "kantonesisk",
    "yue-alt-menu" to "kantonesisk (Kina)",
    "za" to "zhuang",
    "zap" to "zapotec",
    "zbl" to "blissymboler",
    "zen" to "zenaga",
    "zgh" to "tamazight",
    "zh" to "kinesisk",
    "zh-alt-menu" to "mandarin (Kina)",
    "zh-Hans" to "forenklet kinesisk",
    "zh-Hans-alt-long" to "forenklet kinesisk",
    "zh-Hant" to "traditionelt kinesisk",
    "zh-Hant-alt-long" to "traditionelt kinesisk",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "intet sprogligt indhold",
    "zza" to "zaza",
  ) }

  val da_GL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val dav: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Kiakan",
    "am" to "Kiamhari",
    "ar" to "Kiarabu",
    "be" to "Kibelarusi",
    "bg" to "Kibulgaria",
    "bn" to "Kibangla",
    "cs" to "Kichecki",
    "dav" to "Kitaita",
    "de" to "Kijerumani",
    "el" to "Kigiriki",
    "en" to "Kingereza",
    "es" to "Kihispania",
    "fa" to "Kiajemi",
    "fr" to "Kifaransa",
    "ha" to "Kihausa",
    "hi" to "Kihindi",
    "hu" to "Kihungari",
    "id" to "Kiindonesia",
    "ig" to "Kiigbo",
    "it" to "Kiitaliano",
    "ja" to "Kijapani",
    "jv" to "Kijava",
    "km" to "Kikambodia",
    "ko" to "Kikorea",
    "ms" to "Kimalesia",
    "my" to "Kiburma",
    "ne" to "Kinepali",
    "nl" to "Kiholanzi",
    "pa" to "Kipunjabi",
    "pl" to "Kipolandi",
    "pt" to "Kireno",
    "ro" to "Kiromania",
    "ru" to "Kirusi",
    "rw" to "Kinyarwanda",
    "so" to "Kisomali",
    "sv" to "Kiswidi",
    "ta" to "Kitamil",
    "th" to "Kitailandi",
    "tr" to "Kituruki",
    "uk" to "Kiukrania",
    "ur" to "Kiurdu",
    "vi" to "Kivietinamu",
    "yo" to "Kiyoruba",
    "zh" to "Kichina",
    "zh-alt-menu" to "Kichina",
    "zu" to "Kizulu",
  ) }

  val de: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afar",
    "ab" to "Abchasisch",
    "ace" to "Aceh",
    "ach" to "Acholi",
    "ada" to "Adangme",
    "ady" to "Adygeisch",
    "ae" to "Avestisch",
    "aeb" to "Tunesisches Arabisch",
    "af" to "Afrikaans",
    "afh" to "Afrihili",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "akk" to "Akkadisch",
    "akz" to "Alabama",
    "ale" to "Aleutisch",
    "aln" to "Gegisch",
    "alt" to "Süd-Altaisch",
    "am" to "Amharisch",
    "an" to "Aragonesisch",
    "ang" to "Altenglisch",
    "ann" to "Obolo",
    "anp" to "Angika",
    "ar" to "Arabisch",
    "ar-001" to "Modernes Hocharabisch",
    "arc" to "Aramäisch",
    "arn" to "Mapudungun",
    "aro" to "Araona",
    "arp" to "Arapaho",
    "arq" to "Algerisches Arabisch",
    "ars" to "Arabisch (Nadschd)",
    "arw" to "Arawak",
    "ary" to "Marokkanisches Arabisch",
    "arz" to "Ägyptisches Arabisch",
    "as" to "Assamesisch",
    "asa" to "Asu",
    "ase" to "Amerikanische Gebärdensprache",
    "ast" to "Asturisch",
    "atj" to "Atikamekw",
    "av" to "Awarisch",
    "avk" to "Kotava",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Aserbaidschanisch",
    "az-alt-short" to "Aserbaidschanisch",
    "ba" to "Baschkirisch",
    "bal" to "Belutschisch",
    "ban" to "Balinesisch",
    "bar" to "Bairisch",
    "bas" to "Bassa",
    "bax" to "Bamun",
    "bbc" to "Batak Toba",
    "bbj" to "Ghomala",
    "be" to "Belarussisch",
    "bej" to "Bedauye",
    "bem" to "Bemba",
    "bew" to "Betawi",
    "bez" to "Bena",
    "bfd" to "Bafut",
    "bfq" to "Badaga",
    "bg" to "Bulgarisch",
    "bgc" to "Haryanvi",
    "bgn" to "Westliches Belutschi",
    "bho" to "Bhodschpuri",
    "bi" to "Bislama",
    "bik" to "Bikol",
    "bin" to "Bini",
    "bjn" to "Banjaresisch",
    "bkm" to "Kom",
    "bla" to "Blackfoot",
    "blo" to "Anii",
    "bm" to "Bambara",
    "bn" to "Bengalisch",
    "bo" to "Tibetisch",
    "bpy" to "Bishnupriya",
    "bqi" to "Bachtiarisch",
    "br" to "Bretonisch",
    "bra" to "Braj-Bhakha",
    "brh" to "Brahui",
    "brx" to "Bodo",
    "bs" to "Bosnisch",
    "bss" to "Akoose",
    "bua" to "Burjatisch",
    "bug" to "Buginesisch",
    "bum" to "Bulu",
    "byn" to "Blin",
    "byv" to "Medumba",
    "ca" to "Katalanisch",
    "cad" to "Caddo",
    "car" to "Karibisch",
    "cay" to "Cayuga",
    "cch" to "Atsam",
    "ccp" to "Chakma",
    "ce" to "Tschetschenisch",
    "ceb" to "Cebuano",
    "cgg" to "Rukiga",
    "ch" to "Chamorro",
    "chb" to "Chibcha",
    "chg" to "Tschagataisch",
    "chk" to "Chuukesisch",
    "chm" to "Mari",
    "chn" to "Chinook",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyenne",
    "ckb" to "Zentralkurdisch",
    "ckb-alt-menu" to "Kurdisch (Sorani)",
    "ckb-alt-variant" to "Zentralkurdisch",
    "clc" to "Chilcotin",
    "co" to "Korsisch",
    "cop" to "Koptisch",
    "cps" to "Capiznon",
    "cr" to "Cree",
    "crg" to "Michif",
    "crh" to "Krimtatarisch",
    "crj" to "Südost-Cree",
    "crk" to "Plains-Cree",
    "crl" to "Northern East Cree",
    "crm" to "Moose Cree",
    "crr" to "Carolina-Algonkin",
    "crs" to "Seychellenkreol",
    "cs" to "Tschechisch",
    "csb" to "Kaschubisch",
    "csw" to "Swampy Cree",
    "cu" to "Kirchenslawisch",
    "cv" to "Tschuwaschisch",
    "cy" to "Walisisch",
    "da" to "Dänisch",
    "dak" to "Dakota",
    "dar" to "Darginisch",
    "dav" to "Taita",
    "de" to "Deutsch",
    "de-AT" to "Österreichisches Deutsch",
    "de-CH" to "Schweizer Hochdeutsch",
    "del" to "Delaware",
    "den" to "Slave",
    "dgr" to "Dogrib",
    "din" to "Dinka",
    "dje" to "Zarma",
    "doi" to "Dogri",
    "dsb" to "Niedersorbisch",
    "dtp" to "Zentral-Dusun",
    "dua" to "Duala",
    "dum" to "Mittelniederländisch",
    "dv" to "Dhivehi",
    "dyo" to "Diola",
    "dyu" to "Dyula",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "egl" to "Emilianisch",
    "egy" to "Ägyptisch",
    "eka" to "Ekajuk",
    "el" to "Griechisch",
    "elx" to "Elamisch",
    "en" to "Englisch",
    "en-GB-alt-short" to "Englisch (GB)",
    "enm" to "Mittelenglisch",
    "eo" to "Esperanto",
    "es" to "Spanisch",
    "esu" to "Zentral-Alaska-Yupik",
    "et" to "Estnisch",
    "eu" to "Baskisch",
    "ewo" to "Ewondo",
    "ext" to "Extremadurisch",
    "fa" to "Persisch",
    "fa-AF" to "Dari",
    "fan" to "Pangwe",
    "fat" to "Fanti",
    "ff" to "Ful",
    "fi" to "Finnisch",
    "fil" to "Filipino",
    "fit" to "Meänkieli",
    "fj" to "Fidschi",
    "fo" to "Färöisch",
    "fon" to "Fon",
    "fr" to "Französisch",
    "frc" to "Cajun",
    "frm" to "Mittelfranzösisch",
    "fro" to "Altfranzösisch",
    "frp" to "Frankoprovenzalisch",
    "frr" to "Nordfriesisch",
    "frs" to "Ostfriesisch",
    "fur" to "Friaulisch",
    "fy" to "Westfriesisch",
    "ga" to "Irisch",
    "gaa" to "Ga",
    "gag" to "Gagausisch",
    "gan" to "Gan",
    "gay" to "Gayo",
    "gba" to "Gbaya",
    "gbz" to "Gabri",
    "gd" to "Gälisch (Schottland)",
    "gez" to "Geez",
    "gil" to "Kiribatisch",
    "gl" to "Galicisch",
    "glk" to "Gilaki",
    "gmh" to "Mittelhochdeutsch",
    "gn" to "Guaraní",
    "goh" to "Althochdeutsch",
    "gon" to "Gondi",
    "gor" to "Mongondou",
    "got" to "Gotisch",
    "grb" to "Grebo",
    "grc" to "Altgriechisch",
    "gsw" to "Schweizerdeutsch",
    "gu" to "Gujarati",
    "guc" to "Wayúu",
    "gur" to "Farefare",
    "guz" to "Gusii",
    "gv" to "Manx",
    "gwi" to "Kutchin",
    "ha" to "Haussa",
    "hai" to "Haida",
    "hak" to "Hakka",
    "haw" to "Hawaiisch",
    "hax" to "Süd-Haida",
    "he" to "Hebräisch",
    "hi" to "Hindi",
    "hi-Latn" to "Hindi (lateinisch)",
    "hi-Latn-alt-variant" to "Hinglish",
    "hif" to "Fidschi-Hindi",
    "hil" to "Hiligaynon",
    "hit" to "Hethitisch",
    "hmn" to "Miao",
    "ho" to "Hiri-Motu",
    "hr" to "Kroatisch",
    "hsb" to "Obersorbisch",
    "hsn" to "Xiang",
    "ht" to "Haiti-Kreolisch",
    "hu" to "Ungarisch",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Armenisch",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Iban",
    "ibb" to "Ibibio",
    "id" to "Indonesisch",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Yi",
    "ik" to "Inupiak",
    "ikt" to "Westkanadisches Inuktitut",
    "ilo" to "Ilokano",
    "inh" to "Inguschisch",
    "io" to "Ido",
    "is" to "Isländisch",
    "it" to "Italienisch",
    "iu" to "Inuktitut",
    "izh" to "Ischorisch",
    "ja" to "Japanisch",
    "jam" to "Jamaikanisch-Kreolisch",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jpr" to "Jüdisch-Persisch",
    "jrb" to "Jüdisch-Arabisch",
    "jut" to "Jütisch",
    "jv" to "Javanisch",
    "ka" to "Georgisch",
    "kaa" to "Karakalpakisch",
    "kab" to "Kabylisch",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kaw" to "Kawi",
    "kbd" to "Kabardinisch",
    "kbl" to "Kanembu",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kabuverdianu",
    "ken" to "Kenyang",
    "kfo" to "Koro",
    "kg" to "Kongolesisch",
    "kgp" to "Kaingang",
    "kha" to "Khasi",
    "kho" to "Sakisch",
    "khq" to "Koyra Chiini",
    "khw" to "Khowar",
    "ki" to "Kikuyu",
    "kiu" to "Kirmanjki",
    "kj" to "Kwanyama",
    "kk" to "Kasachisch",
    "kkj" to "Kako",
    "kl" to "Grönländisch",
    "kln" to "Kalenjin",
    "km" to "Khmer",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Koreanisch",
    "koi" to "Komi-Permjakisch",
    "kok" to "Konkani",
    "kos" to "Kosraeanisch",
    "kpe" to "Kpelle",
    "kr" to "Kanuri",
    "krc" to "Karatschaiisch-Balkarisch",
    "kri" to "Krio",
    "krj" to "Kinaray-a",
    "krl" to "Karelisch",
    "kru" to "Oraon",
    "ks" to "Kaschmiri",
    "ksb" to "Shambala",
    "ksf" to "Bafia",
    "ksh" to "Kölsch",
    "ku" to "Kurdisch",
    "kum" to "Kumükisch",
    "kut" to "Kutenai",
    "kv" to "Komi",
    "kw" to "Kornisch",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kuvi",
    "ky" to "Kirgisisch",
    "la" to "Latein",
    "lad" to "Ladino",
    "lag" to "Langi",
    "lah" to "Lahnda",
    "lam" to "Lamba",
    "lb" to "Luxemburgisch",
    "lez" to "Lesgisch",
    "lfn" to "Lingua Franca Nova",
    "lg" to "Ganda",
    "li" to "Limburgisch",
    "lij" to "Ligurisch",
    "lil" to "Lillooet",
    "liv" to "Livisch",
    "lkt" to "Lakota",
    "lmo" to "Lombardisch",
    "ln" to "Lingala",
    "lo" to "Laotisch",
    "lol" to "Mongo",
    "lou" to "Kreol (Louisiana)",
    "loz" to "Lozi",
    "lrc" to "Nördliches Luri",
    "lsm" to "Saamia",
    "lt" to "Litauisch",
    "ltg" to "Lettgallisch",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lui" to "Luiseno",
    "lun" to "Lunda",
    "luo" to "Luo",
    "lus" to "Lushai",
    "luy" to "Luhya",
    "lv" to "Lettisch",
    "lzh" to "Klassisches Chinesisch",
    "lzz" to "Lasisch",
    "mad" to "Maduresisch",
    "maf" to "Mafa",
    "mag" to "Khotta",
    "mai" to "Maithili",
    "mak" to "Makassarisch",
    "man" to "Malinke",
    "mas" to "Massai",
    "mde" to "Maba",
    "mdf" to "Mokschanisch",
    "mdr" to "Mandaresisch",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisyen",
    "mg" to "Malagasy",
    "mga" to "Mittelirisch",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Meta’",
    "mh" to "Marschallesisch",
    "mi" to "Māori",
    "mic" to "Micmac",
    "min" to "Minangkabau",
    "mk" to "Mazedonisch",
    "ml" to "Malayalam",
    "mn" to "Mongolisch",
    "mnc" to "Mandschurisch",
    "mni" to "Meithei",
    "moe" to "Innu-Aimun",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Marathi",
    "mrj" to "Bergmari",
    "ms" to "Malaiisch",
    "mt" to "Maltesisch",
    "mua" to "Mundang",
    "mul" to "Mehrsprachig",
    "mus" to "Muskogee",
    "mwl" to "Mirandesisch",
    "mwr" to "Marwari",
    "mwv" to "Mentawai",
    "my" to "Birmanisch",
    "mye" to "Myene",
    "myv" to "Ersja-Mordwinisch",
    "mzn" to "Masanderanisch",
    "na" to "Nauruisch",
    "nan" to "Min Nan",
    "nap" to "Neapolitanisch",
    "naq" to "Nama",
    "nb" to "Norwegisch (Bokmål)",
    "nd" to "Nord-Ndebele",
    "nds" to "Niederdeutsch",
    "nds-NL" to "Niedersächsisch",
    "ne" to "Nepalesisch",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niue",
    "njo" to "Ao-Naga",
    "nl" to "Niederländisch",
    "nl-BE" to "Flämisch",
    "nmg" to "Kwasio",
    "nn" to "Norwegisch (Nynorsk)",
    "nnh" to "Ngiemboon",
    "no" to "Norwegisch",
    "nog" to "Nogai",
    "non" to "Altnordisch",
    "nov" to "Novial",
    "nqo" to "N’Ko",
    "nr" to "Süd-Ndebele",
    "nso" to "Nord-Sotho",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "nwc" to "Alt-Newari",
    "ny" to "Nyanja",
    "nym" to "Nyamwezi",
    "nyn" to "Nyankole",
    "nyo" to "Nyoro",
    "nzi" to "Nzima",
    "oc" to "Okzitanisch",
    "oj" to "Ojibwa",
    "ojb" to "Nordwest-Ojibwe",
    "ojc" to "Zentral-Ojibwe",
    "ojs" to "Oji-Cree",
    "ojw" to "West-Ojibwe",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Oriya",
    "os" to "Ossetisch",
    "osa" to "Osage",
    "ota" to "Osmanisch",
    "pa" to "Punjabi",
    "pag" to "Pangasinan",
    "pal" to "Mittelpersisch",
    "pam" to "Pampanggan",
    "pap" to "Papiamento",
    "pau" to "Palau",
    "pcd" to "Picardisch",
    "pcm" to "Nigerianisches Pidgin",
    "pdc" to "Pennsylvaniadeutsch",
    "pdt" to "Plautdietsch",
    "peo" to "Altpersisch",
    "pfl" to "Pfälzisch",
    "phn" to "Phönizisch",
    "pi" to "Pali",
    "pis" to "Pijin",
    "pl" to "Polnisch",
    "pms" to "Piemontesisch",
    "pnt" to "Pontisch",
    "pon" to "Ponapeanisch",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Altpreußisch",
    "pro" to "Altprovenzalisch",
    "ps" to "Paschtu",
    "pt" to "Portugiesisch",
    "qu" to "Quechua",
    "quc" to "K’iche’",
    "qug" to "Chimborazo Hochland-Quechua",
    "raj" to "Rajasthani",
    "rap" to "Rapanui",
    "rar" to "Rarotonganisch",
    "rgn" to "Romagnol",
    "rhg" to "Rohingyalisch",
    "rif" to "Tarifit",
    "rm" to "Rätoromanisch",
    "rn" to "Rundi",
    "ro" to "Rumänisch",
    "ro-MD" to "Moldauisch",
    "rof" to "Rombo",
    "rom" to "Romani",
    "rtm" to "Rotumanisch",
    "ru" to "Russisch",
    "rue" to "Russinisch",
    "rug" to "Roviana",
    "rup" to "Aromunisch",
    "rw" to "Kinyarwanda",
    "rwk" to "Rwa",
    "sa" to "Sanskrit",
    "sad" to "Sandawe",
    "sah" to "Jakutisch",
    "sam" to "Samaritanisch",
    "saq" to "Samburu",
    "sas" to "Sasak",
    "sat" to "Santali",
    "saz" to "Saurashtra",
    "sba" to "Ngambay",
    "sbp" to "Sangu",
    "sc" to "Sardisch",
    "scn" to "Sizilianisch",
    "sco" to "Schottisch",
    "sd" to "Sindhi",
    "sdc" to "Sassarisch",
    "sdh" to "Südkurdisch",
    "se" to "Nordsamisch",
    "see" to "Seneca",
    "seh" to "Sena",
    "sei" to "Seri",
    "sel" to "Selkupisch",
    "ses" to "Koyra Senni",
    "sg" to "Sango",
    "sga" to "Altirisch",
    "sgs" to "Samogitisch",
    "sh" to "Serbo-Kroatisch",
    "shi" to "Taschelhit",
    "shn" to "Schan",
    "shu" to "Tschadisch-Arabisch",
    "si" to "Singhalesisch",
    "sid" to "Sidamo",
    "sk" to "Slowakisch",
    "sl" to "Slowenisch",
    "slh" to "Süd-Lushootseed",
    "sli" to "Schlesisch (Niederschlesisch)",
    "sly" to "Selayar",
    "sm" to "Samoanisch",
    "sma" to "Südsamisch",
    "smj" to "Lule-Samisch",
    "smn" to "Inari-Samisch",
    "sms" to "Skolt-Samisch",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somali",
    "sog" to "Sogdisch",
    "sq" to "Albanisch",
    "sr" to "Serbisch",
    "srn" to "Srananisch",
    "srr" to "Serer",
    "ss" to "Swazi",
    "ssy" to "Saho",
    "st" to "Süd-Sotho",
    "stq" to "Saterfriesisch",
    "str" to "Straits Salish",
    "su" to "Sundanesisch",
    "suk" to "Sukuma",
    "sus" to "Susu",
    "sux" to "Sumerisch",
    "sv" to "Schwedisch",
    "sw" to "Suaheli",
    "sw-CD" to "Kongo-Swahili",
    "swb" to "Komorisch",
    "syc" to "Altsyrisch",
    "syr" to "Syrisch",
    "szl" to "Schlesisch (Wasserpolnisch)",
    "ta" to "Tamil",
    "tce" to "Südliches Tutchone",
    "tcy" to "Tulu",
    "te" to "Telugu",
    "tem" to "Temne",
    "teo" to "Teso",
    "ter" to "Tereno",
    "tet" to "Tetum",
    "tg" to "Tadschikisch",
    "tgx" to "Tagish",
    "th" to "Thailändisch",
    "tht" to "Tahltan",
    "ti" to "Tigrinya",
    "tig" to "Tigre",
    "tiv" to "Tiv",
    "tk" to "Turkmenisch",
    "tkl" to "Tokelauanisch",
    "tkr" to "Tsachurisch",
    "tl" to "Tagalog",
    "tlh" to "Klingonisch",
    "tli" to "Tlingit",
    "tly" to "Talisch",
    "tmh" to "Tamaseq",
    "tn" to "Tswana",
    "to" to "Tongaisch",
    "tog" to "Nyasa Tonga",
    "tok" to "Toki Pona",
    "tpi" to "Neumelanesisch",
    "tr" to "Türkisch",
    "tru" to "Turoyo",
    "trv" to "Taroko",
    "ts" to "Tsonga",
    "tsd" to "Tsakonisch",
    "tsi" to "Tsimshian",
    "tt" to "Tatarisch",
    "ttm" to "Nördliches Tutchone",
    "ttt" to "Tatisch",
    "tum" to "Tumbuka",
    "tvl" to "Tuvaluisch",
    "tw" to "Twi",
    "twq" to "Tasawaq",
    "ty" to "Tahitisch",
    "tyv" to "Tuwinisch",
    "tzm" to "Zentralatlas-Tamazight",
    "udm" to "Udmurtisch",
    "ug" to "Uigurisch",
    "uga" to "Ugaritisch",
    "uk" to "Ukrainisch",
    "umb" to "Umbundu",
    "und" to "Unbekannte Sprache",
    "ur" to "Urdu",
    "uz" to "Usbekisch",
    "vai" to "Vai",
    "ve" to "Venda",
    "vec" to "Venetisch",
    "vep" to "Wepsisch",
    "vi" to "Vietnamesisch",
    "vls" to "Westflämisch",
    "vmf" to "Mainfränkisch",
    "vmw" to "Makua",
    "vo" to "Volapük",
    "vot" to "Wotisch",
    "vro" to "Võro",
    "vun" to "Vunjo",
    "wa" to "Wallonisch",
    "wae" to "Walliserdeutsch",
    "wal" to "Walamo",
    "war" to "Waray",
    "was" to "Washo",
    "wbp" to "Warlpiri",
    "wo" to "Wolof",
    "wuu" to "Wu",
    "xal" to "Kalmückisch",
    "xh" to "Xhosa",
    "xmf" to "Mingrelisch",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yao" to "Yao",
    "yap" to "Yapesisch",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Jiddisch",
    "yo" to "Yoruba",
    "yrl" to "Nheengatu",
    "yue" to "Kantonesisch",
    "yue-alt-menu" to "Chinesisch (Kantonesisch)",
    "za" to "Zhuang",
    "zap" to "Zapotekisch",
    "zbl" to "Bliss-Symbole",
    "zea" to "Seeländisch",
    "zen" to "Zenaga",
    "zgh" to "Tamazight",
    "zh" to "Chinesisch",
    "zh-alt-menu" to "Chinesisch (Mandarin)",
    "zh-Hans" to "Chinesisch (vereinfacht)",
    "zh-Hans-alt-long" to "Mandarin (Vereinfacht)",
    "zh-Hant" to "Chinesisch (traditionell)",
    "zh-Hant-alt-long" to "Mandarin (traditionell)",
    "zu" to "Zulu",
    "zun" to "Zuni",
    "zxx" to "Keine Sprachinhalte",
    "zza" to "Zaza",
  ) }

  val de_AT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar-001" to "modernes Hocharabisch",
    "car" to "karibische Sprache",
    "chb" to "Chibcha-Sprache",
    "del" to "Delawarisch",
    "fur" to "Friulanisch",
    "ha" to "Hausa",
    "haw" to "Hawaiianisch",
    "hmn" to "Miao-Sprache",
    "mus" to "Muskogee-Sprache",
    "niu" to "Niueanisch",
    "pag" to "Pangasinensisch",
    "sh" to "Serbokroatisch",
    "szl" to "Schlesisch",
  ) }

  val de_BE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val de_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ach" to "Acholi-Sprache",
    "bik" to "Bikol-Sprache",
    "chb" to "Chibcha-Sprache",
    "din" to "Dinka-Sprache",
    "fan" to "Pangwe-Sprache",
    "gba" to "Gbaya-Sprache",
    "prg" to "Altpreussisch",
    "rhg" to "Rohingya",
    "tgx" to "Tagisch",
    "zh-Hans-alt-long" to "Hochchinesisch (vereinfacht)",
    "zh-Hant-alt-long" to "Hochchinesisch (traditionell)",
  ) }

  val de_IT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val de_LI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val de_LU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val dje: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Akan senni",
    "am" to "Amhaarik senni",
    "ar" to "Laaraw senni",
    "be" to "Belaruus senni",
    "bg" to "Bulagaari senni",
    "bn" to "Bengali senni",
    "cs" to "Cek senni",
    "de" to "Almaŋ senni",
    "dje" to "Zarmaciine",
    "el" to "Grek senni",
    "en" to "Inglisi senni",
    "es" to "Espaaɲe senni",
    "fa" to "Farsi senni",
    "fr" to "Fransee senni",
    "ha" to "Hawsance senni",
    "hi" to "Induu senni",
    "hu" to "Hungaari senni",
    "id" to "Indoneesi senni",
    "ig" to "Iboo senni",
    "it" to "Itaali senni",
    "ja" to "Japonee senni",
    "jv" to "Javanee senni",
    "km" to "Kmeer senni",
    "ko" to "Koree senni",
    "ms" to "Maleezi senni",
    "my" to "Burme senni",
    "ne" to "Neepal senni",
    "nl" to "Holandee senni",
    "pa" to "Punjaabi sennii",
    "pl" to "Polonee senni",
    "pt" to "Portugee senni",
    "ro" to "Rumaani senni",
    "ru" to "Ruusi senni",
    "rw" to "Rwanda senni",
    "so" to "Somaali senni",
    "sv" to "Suweede senni",
    "ta" to "Tamil senni",
    "th" to "Taailandu senni",
    "tr" to "Turku senni",
    "uk" to "Ukreen senni",
    "ur" to "Urdu senni",
    "vi" to "Vietnaam senni",
    "yo" to "Yorbance senni",
    "zh" to "Sinuwa senni",
    "zh-alt-menu" to "Sinuwa senni",
    "zu" to "Zulu senni",
  ) }

  val doi: ImmutableMap<String, String> by lazy { immutableMapOf(
    "de" to "जर्मन",
    "de-AT" to "आस्ट्रियाई जर्मन",
    "de-CH" to "स्विस हाई जर्मन",
    "doi" to "डोगरी",
    "en" to "अंगरेजी",
    "en-CA" to "कैनेडियन अंगरेजी",
    "en-GB" to "ब्रिटिश अंगरेजी",
    "en-GB-alt-short" to "यूके अंगरेजी",
    "en-US" to "अमरीकी अंगरेजी",
    "en-US-alt-short" to "यूएस अंगरेजी",
    "es" to "स्पैनिश",
    "es-419" to "लैटिन अमरीकी स्पैनिश",
    "es-ES" to "यूरोपी स्पैनिश",
    "es-MX" to "मैक्सिन स्पैनिश",
    "fr" to "फ्रेंच",
    "fr-CA" to "कैनेडियन फ्रेंच",
    "fr-CH" to "स्विस फ्रेंच",
    "it" to "इटालियन",
    "ja" to "जापानी",
    "pt" to "पुर्तगाली",
    "pt-BR" to "ब्राजीली पुर्तगाली",
    "pt-PT" to "यूरोपी पुर्तगाली",
    "ru" to "रूसी",
    "und" to "अनजांती भाशा",
    "zh" to "चीनी",
    "zh-alt-menu" to "चीनी, मंदारिन",
    "zh-Hans" to "सरलीकृत चीनी",
    "zh-Hans-alt-long" to "सरलीकृत मंदारिन चीनी",
    "zh-Hant" to "रवायती चीनी",
    "zh-Hant-alt-long" to "रवायती मंदारिन चीनी",
  ) }

  val dsb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afaršćina",
    "ab" to "abchazšćina",
    "ace" to "achinezišćina",
    "ada" to "adangmešćina",
    "ady" to "adyghešćina",
    "af" to "afrikans",
    "agq" to "aghem",
    "ain" to "ainušćina",
    "ak" to "akanšćina",
    "ale" to "aleutišćina",
    "alt" to "pódpołdnjowa altaišćina",
    "am" to "amharšćina",
    "an" to "aragonšćina",
    "ang" to "anglosaksojšćina",
    "ann" to "obološćina",
    "anp" to "angikašćina",
    "ar" to "arabšćina",
    "ar-001" to "moderna wusokoarabšćina",
    "arn" to "arawkašćina",
    "arp" to "arapahošćina",
    "ars" to "najdi arabšćina",
    "as" to "asamšćina",
    "asa" to "pare",
    "ast" to "asturšćina",
    "atj" to "atikamekwišćina",
    "av" to "awaršćina",
    "awa" to "awandhišćina",
    "ay" to "aymaršćina",
    "az" to "azerbajdžanšćina",
    "az-alt-short" to "azerbajdžanšćina",
    "ba" to "baškiršćina",
    "ban" to "balinezišćina",
    "bas" to "basaa",
    "be" to "běłorušćina",
    "bem" to "bemba",
    "bez" to "bena",
    "bg" to "bulgaršćina",
    "bgc" to "haryanvišćina",
    "bho" to "bhojpurišćina",
    "bi" to "bislamšćina",
    "bin" to "binišćina",
    "bla" to "siksikášćina",
    "blo" to "aniišćina",
    "bm" to "bambara",
    "bn" to "bengalšćina",
    "bo" to "tibetšćina",
    "br" to "bretonšćina",
    "brx" to "bodo",
    "bs" to "bosnišćina",
    "bug" to "bugišćina",
    "byn" to "blinšćina",
    "ca" to "katanlanšćina",
    "cay" to "cayugašćina",
    "ccp" to "čakma",
    "ce" to "čečenšćina",
    "ceb" to "cebuanšćina",
    "cgg" to "chiga",
    "ch" to "čamoršćina",
    "chk" to "chuukezišćina",
    "chm" to "marišćina",
    "cho" to "choctawšćina",
    "chp" to "chipewyanšćina",
    "chr" to "cherokee",
    "chy" to "cheyennešćina",
    "ckb" to "sorani",
    "ckb-alt-menu" to "sorani",
    "ckb-alt-variant" to "centralna kurdišćina",
    "clc" to "chilcotinšćina",
    "co" to "korsišćina",
    "cr" to "kri",
    "crg" to "michifšćina",
    "crj" to "krotkozajtšna creešćina",
    "crk" to "plains creešćina",
    "crl" to "dłujkozajtšna creešćina",
    "crm" to "moode creešćina",
    "crr" to "carolina algonquianšćina",
    "cs" to "češćina",
    "csw" to "swampy creešćina",
    "cu" to "cerkwinosłowjańšćina",
    "cv" to "chuvashišćina",
    "cy" to "walizišćina",
    "da" to "danšćina",
    "dak" to "dakotašćina",
    "dar" to "dargwašćina",
    "dav" to "taita",
    "de" to "nimšćina",
    "de-AT" to "awstriska nimšćina",
    "de-CH" to "šwicarska wusokonimšćina",
    "dgr" to "dogribšćina",
    "dje" to "zarma",
    "doi" to "dogrišćina",
    "dsb" to "dolnoserbšćina",
    "dua" to "duala",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dz" to "dzongkha",
    "dzg" to "dazagašćina",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efikšćina",
    "eka" to "ekajukšćina",
    "el" to "grichišćina",
    "en" to "engelšćina",
    "en-AU" to "awstralska engelšćina",
    "en-CA" to "kanadiska engelšćina",
    "en-GB" to "britiska engelšćina",
    "en-GB-alt-short" to "UK-engelšćina",
    "en-US" to "ameriska engelšćina",
    "en-US-alt-short" to "US-engelšćina",
    "eo" to "esperanto",
    "es" to "špańšćina",
    "es-419" to "łatyńskoamerikańska špańšćina",
    "es-ES" to "europejska špańšćina",
    "es-MX" to "mexikańska špańšćina",
    "et" to "estišćina",
    "eu" to "baskišćina",
    "ewo" to "ewondo",
    "fa" to "persišćina",
    "fa-AF" to "dari",
    "ff" to "fulbšćina",
    "fi" to "finšćina",
    "fil" to "filipinšćina",
    "fj" to "fidžišćina",
    "fo" to "ferejšćina",
    "fon" to "fonšćina",
    "fr" to "francojšćina",
    "fr-CA" to "kanadiska francojšćina",
    "fr-CH" to "šwicarska francojšćina",
    "frc" to "cajun francojšćina",
    "frr" to "pódpołnocna frizišćina",
    "fur" to "friulšćina",
    "fy" to "frizišćina",
    "ga" to "iršćina",
    "gaa" to "gašćina",
    "gag" to "gagauzšćina",
    "gd" to "šotišćina",
    "gez" to "geezišćina",
    "gil" to "gilbertezišćina",
    "gl" to "galicišćina",
    "gn" to "guarani",
    "gor" to "gorontalošćina",
    "got" to "gotišćina",
    "gsw" to "šwicarska nimšćina",
    "gu" to "gudžaratšćina",
    "guz" to "gusii",
    "gv" to "manšćina",
    "gwi" to "gwichʼinšćina",
    "ha" to "hausa",
    "hai" to "haidašćina",
    "haw" to "hawaiišćina",
    "hax" to "pódpołdnjowa haidašćina",
    "he" to "hebrejšćina",
    "hi" to "hindišćina",
    "hil" to "hiligaynonšćina",
    "hmn" to "hmongšćina",
    "hr" to "chorwatšćina",
    "hsb" to "górnoserbšćina",
    "ht" to "haitišćina",
    "hu" to "hungoršćina",
    "hup" to "hupašćina",
    "hur" to "halkomelemšćina",
    "hy" to "armeńšćina",
    "hz" to "hererošćina",
    "ia" to "interlingua",
    "iba" to "ibanšćina",
    "ibb" to "ibibiošćina",
    "id" to "indonešćina",
    "ie" to "interlinguešćina",
    "ig" to "igbo",
    "ii" to "sichuan yi",
    "ik" to "inupiak",
    "ikt" to "pódwjacornokanadiska inuktitutšćina",
    "ilo" to "ilokošćina",
    "inh" to "ingushišćina",
    "io" to "ido",
    "is" to "islandšćina",
    "it" to "italšćina",
    "iu" to "inuitšćina",
    "ja" to "japańšćina",
    "jbo" to "lojbanšćina",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jv" to "javašćina",
    "ka" to "georgišćina",
    "kab" to "kabylšćina",
    "kac" to "kachinšćina",
    "kaj" to "jjušćina",
    "kam" to "kamba",
    "kbd" to "kabardianšćina",
    "kcg" to "tyapšćina",
    "kde" to "makonde",
    "kea" to "kapverdšćina",
    "kfo" to "korošćina",
    "kgp" to "kaingangšćina",
    "kha" to "khasišćina",
    "khq" to "koyra chiini",
    "ki" to "kikuyu",
    "kj" to "kuanyamašćina",
    "kk" to "kazachšćina",
    "kkj" to "kako",
    "kl" to "grönlandšćina",
    "kln" to "kalenjin",
    "km" to "kambodžanšćina",
    "kmb" to "kimbundušćina",
    "kn" to "kannadšćina",
    "ko" to "korejańšćina",
    "koi" to "komi-permyak",
    "kok" to "konkani",
    "kpe" to "kpellešćina",
    "kr" to "kanurišćina",
    "krc" to "karachay-balkaršćina",
    "krl" to "karelianšćina",
    "kru" to "kurukhšćina",
    "ks" to "kašmiršćina",
    "ksb" to "šambala",
    "ksf" to "bafia",
    "ksh" to "kelnšćina",
    "ku" to "kurdišćina",
    "kum" to "kumykšćina",
    "kv" to "komišćina",
    "kw" to "kornišćina",
    "kwk" to "kwakʼwalašćina",
    "kxv" to "kuvišćina",
    "ky" to "kirgišćina",
    "la" to "łatyńšćina",
    "lad" to "ladinšćina",
    "lag" to "langi",
    "lb" to "luxemburgšćina",
    "lez" to "lezgianšćina",
    "lg" to "gandšćina",
    "li" to "limburšćina",
    "lij" to "liguriańšćina",
    "lil" to "lillooetšćina",
    "lkt" to "lakotšćina",
    "lmo" to "lombardišćina",
    "ln" to "lingala",
    "lo" to "laošćina",
    "lou" to "Louisiana kreolšćina",
    "loz" to "lozišćina",
    "lrc" to "pódpołnocna lurišćina",
    "lsm" to "saamiašćina",
    "lt" to "litawšćina",
    "lu" to "luba-katanga",
    "lua" to "luba-luluašćina",
    "lun" to "lundašćina",
    "lus" to "mizošćina",
    "luy" to "luhya",
    "lv" to "letišćina",
    "mad" to "madurezišćina",
    "mag" to "magahišćina",
    "mai" to "maithilšćina",
    "mak" to "makasaršćina",
    "mas" to "masaišćina",
    "mdf" to "mokshašćina",
    "men" to "mendišćina",
    "mer" to "meru",
    "mfe" to "mauriciska kreolšćina",
    "mg" to "malgašćina",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta’",
    "mh" to "marshallezišćina",
    "mi" to "maorišćina",
    "mic" to "mi'kmaqšćina",
    "min" to "minangkabaušćina",
    "mk" to "makedońšćina",
    "ml" to "malajamšćina",
    "mn" to "mongolšćina",
    "mni" to "manipuršćina",
    "moe" to "innu-aimunšćina",
    "moh" to "mohawkšćina",
    "mos" to "mossišćina",
    "mr" to "maratišćina",
    "ms" to "malajšćina",
    "mt" to "maltašćina",
    "mua" to "mundang",
    "mul" to "wěcejrěcne",
    "mus" to "krik",
    "mwl" to "mirandezišćina",
    "my" to "burmašćina",
    "myv" to "erzyašćina",
    "mzn" to "mazanderanšćina",
    "na" to "naurušćina",
    "nap" to "neapolitanšćina",
    "naq" to "nama",
    "nb" to "norwegske bokmål",
    "nd" to "pódpołnocne ndebele",
    "nds" to "dolnonimšćina",
    "ne" to "nepalšćina",
    "new" to "newarišćina",
    "ng" to "ndongašćina",
    "nia" to "niazišćina",
    "niu" to "niueanšćina",
    "nl" to "nižozemšćina",
    "nl-BE" to "flamšćina",
    "nmg" to "kwasio",
    "nn" to "norwegske nynorsk",
    "nnh" to "ngiemboon",
    "no" to "norwegšćina",
    "nog" to "nogaišćina",
    "nqo" to "n’ko",
    "nr" to "pódpołdnjowa ndebelšćina",
    "nso" to "połnocna sothošćina",
    "nus" to "nuer",
    "nv" to "navaho",
    "ny" to "nyanja",
    "nyn" to "nyankole",
    "oc" to "okcitanšćina",
    "ojb" to "dłujkowjacorna ojibwašćina",
    "ojc" to "centralna ojibwašćina",
    "ojs" to "oji-creešćina",
    "ojw" to "pódwjacorna ojibwašćina",
    "oka" to "okanaganšćina",
    "om" to "oromo",
    "or" to "orojišćina",
    "os" to "osetšćina",
    "pa" to "pandžabšćina",
    "pag" to "pangasinanšćina",
    "pam" to "pampangašćina",
    "pap" to "papiamentošćina",
    "pau" to "palauanšćina",
    "pcm" to "nigerijanski pidgin",
    "pis" to "pijinšćina",
    "pl" to "pólšćina",
    "pqm" to "maliseet-passamaquoddyšćina",
    "prg" to "prusčina",
    "ps" to "paštunšćina",
    "pt" to "portugalšćina",
    "pt-BR" to "brazilska portugalšćina",
    "pt-PT" to "europejska portugalšćina",
    "qu" to "kečua",
    "quc" to "kʼicheʼ",
    "raj" to "rajasthanišćina",
    "rap" to "rapanuišćina",
    "rar" to "rarotonganšćina",
    "rhg" to "rohingyašćina",
    "rm" to "retoromańšćina",
    "rn" to "kirundišćina",
    "ro" to "rumunšćina",
    "ro-MD" to "moldawišćina",
    "rof" to "rombo",
    "ru" to "rušćina",
    "rup" to "armanianšćina",
    "rw" to "kinjarwanda",
    "rwk" to "rwa",
    "sa" to "sanskrit",
    "sad" to "sandawešćina",
    "sah" to "jakutšćina",
    "saq" to "samburu",
    "sat" to "santalšćina",
    "sba" to "ngambayšćina",
    "sbp" to "sangu",
    "sc" to "sardinšćina",
    "scn" to "sicilianišćina",
    "sco" to "scotšćina",
    "sd" to "sindšćina",
    "se" to "lapšćina",
    "seh" to "sena",
    "ses" to "koyra senni",
    "sg" to "sango",
    "sh" to "serbochorwatšćina",
    "shi" to "tašelhit",
    "shn" to "shanšćina",
    "si" to "singalšćina",
    "sk" to "słowakšćina",
    "sl" to "słowjeńšćina",
    "slh" to "pódpołdnjowa lushootseedšćina",
    "sm" to "samošćina",
    "sma" to "pódpołdnjowa samišćina",
    "smj" to "lule-samišćina",
    "smn" to "inari-samišćina",
    "sms" to "skolt-samišćina",
    "sn" to "šonšćina",
    "snk" to "soninkešćina",
    "so" to "somališćina",
    "sq" to "albanšćina",
    "sr" to "serbišćina",
    "srn" to "sranan tongošćina",
    "ss" to "siswati",
    "st" to "pódpołdnjowa sotšćina (Sesotho)",
    "stq" to "saterfrizišćina",
    "str" to "straits salishšćina",
    "su" to "sundanšćina",
    "suk" to "sukumašćina",
    "sv" to "šwedšćina",
    "sw" to "swahilišćina",
    "sw-CD" to "kongojska swahilišćina",
    "swb" to "comorianšćina",
    "syr" to "syriacšćina",
    "szl" to "šlazyńšćina",
    "ta" to "tamilšćina",
    "tce" to "pódpołdnjowa tutchonšćina",
    "te" to "telugšćina",
    "tem" to "timnešćina",
    "teo" to "teso",
    "tet" to "tetumšćina",
    "tg" to "tadžikišćina",
    "tgx" to "tagishšćina",
    "th" to "thailandšćina",
    "tht" to "tahltanšćina",
    "ti" to "tigrinja",
    "tig" to "tigrešćina",
    "tk" to "turkmeńšćina",
    "tl" to "tagalog",
    "tlh" to "klingonšćina",
    "tli" to "tlingitšćina",
    "tn" to "tswana",
    "to" to "tonganšćina",
    "tok" to "toki ponašćina",
    "tpi" to "tok pisinšćina",
    "tr" to "turkojšćina",
    "trv" to "tarokošćina",
    "ts" to "tsonga",
    "tt" to "tataršćina",
    "ttm" to "połnocna tutchonšćina",
    "tum" to "tumbukašćina",
    "tvl" to "tuvalušćina",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitišćina",
    "tyv" to "tuvinianšćina",
    "tzm" to "centralnoatlaski tamazight",
    "udm" to "udmurtšćina",
    "ug" to "ujguršćina",
    "uk" to "ukrainšćina",
    "umb" to "umbundušćina",
    "und" to "njeznata rěc",
    "ur" to "urdušćina",
    "uz" to "usbekšćina",
    "ve" to "vendašćina",
    "vec" to "venetišćina",
    "vi" to "vietnamšćina",
    "vmw" to "makhuwašćina",
    "vo" to "volapük",
    "vun" to "vunjo",
    "wa" to "walonšćina",
    "wae" to "walzeršćina",
    "wal" to "wolayttašćina",
    "war" to "warayšćina",
    "wo" to "wolof",
    "wuu" to "wu chinšćina",
    "xal" to "kalmykšćina",
    "xh" to "xhosa",
    "xnr" to "kangrišćina",
    "xog" to "soga",
    "yav" to "yangben",
    "ybb" to "yembašćina",
    "yi" to "jidišćina",
    "yo" to "jorubšćina",
    "yrl" to "nheengatušćina",
    "yue" to "kantonšćina",
    "yue-alt-menu" to "chinšćina (kantonšćina)",
    "za" to "zhuang",
    "zgh" to "standardny marokkański tamazight",
    "zh" to "chinšćina",
    "zh-alt-menu" to "chinšćina (mandarin)",
    "zh-Hans" to "chinšćina (zjadnorjona)",
    "zh-Hans-alt-long" to "chinšćina (zjadnorjona)",
    "zh-Hant" to "chinšćina (tradicionalna)",
    "zh-Hant-alt-long" to "chinšćina (tradicionalna)",
    "zu" to "zulu",
    "zun" to "zunišćina",
    "zxx" to "žedno rěcne wopśimjeśe",
    "zza" to "zazašćina",
  ) }

  val dua: ImmutableMap<String, String> by lazy { immutableMapOf(
    "dua" to "duálá",
  ) }

  val dyo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "akan",
    "am" to "amharik",
    "ar" to "arab",
    "be" to "belarus",
    "bg" to "bulgaari",
    "bn" to "bengali",
    "cs" to "sek",
    "de" to "alman",
    "dyo" to "joola",
    "el" to "greek",
    "en" to "angle",
    "es" to "español",
    "fa" to "persan",
    "fr" to "franse",
    "ha" to "hausa",
    "hi" to "endu",
    "hu" to "ongrua",
    "id" to "indoneesi",
    "ig" to "igbo",
    "it" to "italien",
    "ja" to "saponee",
    "jv" to "savanee",
    "km" to "kmeer",
    "ko" to "koree",
    "ms" to "maleesi",
    "my" to "birmani",
    "ne" to "nepalees",
    "nl" to "neerlande",
    "pa" to "penjabi",
    "pl" to "polonees",
    "pt" to "portugees",
    "ro" to "rumeen",
    "ru" to "rus",
    "rw" to "ruanda",
    "so" to "somali",
    "sv" to "suedi",
    "ta" to "tamil",
    "th" to "tay",
    "tr" to "turki",
    "uk" to "ukrain",
    "ur" to "urdu",
    "vi" to "vietnam",
    "yo" to "yoruba",
    "zh" to "sinua",
    "zh-alt-menu" to "sinua",
    "zu" to "sulu",
  ) }

  val dz: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "ཨ་ཕར་ཁ",
    "ab" to "ཨཱབ་ཁ་ཟི་ཡ་ཁ",
    "af" to "ཨཕ་རི་ཀཱནས་ཁ",
    "am" to "ཨམ་ཧ་རིཀ་ཁ",
    "ar" to "ཨེ་ར་བིཀ་ཁ",
    "as" to "ཨ་ས་མིས་ཁ",
    "az" to "ཨ་ཛར་བྷའི་ཇཱན་ཁ",
    "az-alt-short" to "ཨ་ཛར་བྷའི་ཇཱན་ཁ",
    "be" to "བེལ་ཨ་རུས་ཁ",
    "bg" to "བཱལ་གེ་རི་ཡཱན་ཁ",
    "bn" to "བངྒ་ལ་ཁ",
    "bo" to "བོད་ཁ",
    "bs" to "བྷོས་ནི་ཡཱན་ཁ",
    "ca" to "ཀེ་ཊ་ལཱན་ཁ",
    "cs" to "ཅེཀ་ཁ",
    "cy" to "ཝེལཤ་ཁ",
    "da" to "ཌེ་ནིཤ་ཁ",
    "dak" to "ད་ཀོ་ཏ་ཁ",
    "de" to "ཇཱར་མཱན་ཁ",
    "de-AT" to "ཨཱོས་ཊྲི་ཡཱན་ཇཱར་མཱན་ཁ",
    "de-CH" to "སུ་ཡིས་གི་མཐོ་སའི་ཇཱར་མཱན་ཁ",
    "dv" to "དི་བེ་ཧི་ཁ",
    "dz" to "རྫོང་ཁ",
    "el" to "གྲིཀ་ཁ",
    "en" to "ཨིང་ལིཤ་ཁ",
    "en-AU" to "ཨཱོས་ཊྲེ་ལི་ཡཱན་ཨིང་ལིཤ་ཁ",
    "en-CA" to "ཀེ་ན་ཌི་ཡཱན་ཨིང་ལིཤ་ཁ",
    "en-GB" to "བྲི་ཊིཤ་ཨིང་ལིཤ་ཁ",
    "en-GB-alt-short" to "བྲི་ཊིཤ་ཨིང་ལིཤ་ཁ",
    "en-US" to "ཡུ་ཨེས་ཨིང་ལིཤ་ཁ",
    "en-US-alt-short" to "ཡུ་ཨེས་ཨིང་ལིཤ་ཁ",
    "eo" to "ཨེས་པ་རཱན་ཏོ་ཁ",
    "es" to "ཨིས་པེ་ནིཤ་ཁ",
    "es-419" to "ལེ་ཊིན་ཨ་མེ་རི་ཀཱན་གི་ཨིས་པེ་ནིཤ་ཁ",
    "es-ES" to "ཡུ་རོབ་ཀྱི་ཨིས་པེ་ནིཤ་ཁ",
    "et" to "ཨེས་ཊོ་ནི་ཡཱན་ཁ",
    "eu" to "བཱསཀ་ཁ",
    "fa" to "པར་ཤི་ཡཱན་ཁ",
    "fi" to "ཕི་ནིཤ་ཁ",
    "fil" to "ཕི་ལི་པི་ནོ་ཁ",
    "fj" to "ཕི་ཇི་ཡཱན་ཁ",
    "fo" to "ཕཱ་རོ་ཨིས་ཁ",
    "fr" to "ཕྲནཅ་ཁ",
    "fr-CA" to "ཀེ་ན་ཌི་ཡཱན་ཕྲནཅ་ཁ",
    "fr-CH" to "སུ་ཡིས་ཕྲནཅ་ཁ",
    "fy" to "ནུབ་ཕྼི་སི་ཡན་ཁ",
    "ga" to "ཨཱའི་རིཤ་ཁ",
    "gl" to "གལ་ཨིས་ཨི་ཡན་ཁ",
    "gn" to "གུ་ཝ་ར་ནི་ཁ",
    "gsw" to "སུ་ཡིས་ཇཱར་མཱན་ཁ",
    "gu" to "གུ་ཇ་ར་ཏི་ཁ",
    "ha" to "ཧཝ་ས་ཁ",
    "haw" to "ཧ་ཝ་ཡིའི་ཁ",
    "he" to "ཧེ་བྲུ་ཁ",
    "hi" to "ཧིན་དི་ཁ",
    "hr" to "ཀྲོ་ཨེ་ཤི་ཡཱན་ཁ",
    "ht" to "ཧེ་ཏི་ཡཱན་ཁ",
    "hu" to "ཧཱང་གྷ་རི་ཡཱན་ཁ",
    "hy" to "ཨར་མི་ནི་ཡཱན་ཁ",
    "id" to "ཨིན་ཌོ་ནེ་ཤི་ཡཱན་ཁ",
    "ig" to "ཨིག་བོ་ཁ",
    "is" to "ཨ་ཡིས་ལེན་ཌིཀ་ཁ",
    "it" to "ཨི་ཊ་ལི་ཡཱན་ཁ",
    "ja" to "ཇཱ་པཱ་ནིས་ཁ",
    "jv" to "ཇཱ་བ་ནིས་ཁ",
    "ka" to "ཇཽ་ཇི་ཡཱན་ཁ",
    "kac" to "ཀ་ཆིན་ཁ",
    "kfo" to "ཀོ་རོ་ཁ",
    "kk" to "ཀ་ཛགས་ཁ",
    "km" to "ཁེ་མེར་ཁ",
    "kn" to "ཀ་ན་ཌ་ཁ",
    "ko" to "ཀོ་རི་ཡཱན་ཁ",
    "ks" to "ཀཱཤ་མི་རི་ཁ",
    "ku" to "ཀར་ཌིཤ་ཁ",
    "ky" to "ཀིར་གིས་ཁ",
    "la" to "ལེ་ཊིན་ཁ",
    "lb" to "ལག་ཛམ་བོརྒ་ཁ",
    "lo" to "ལཱ་ཝོས་ཁ",
    "lt" to "ལི་ཐུ་ཝེ་ནི་ཡཱན་ཁ",
    "lv" to "ལཊ་བི་ཡཱན་ཁ",
    "mg" to "མ་ལ་ག་སི་ཁ",
    "mi" to "མ་ཨོ་རི་ཁ",
    "mk" to "མ་སེ་ཌོ་ནི་ཡཱན་ཁ",
    "ml" to "མ་ལ་ཡ་ལམ་ཁ",
    "mnc" to "མན་ཇུ་ཁ",
    "mr" to "མ་ར་ཐི་ཁ",
    "ms" to "མ་ལེ་ཁ",
    "mt" to "མཱལ་ཊ་ཁ",
    "my" to "བར་མིས་ཁ",
    "nb" to "ནོར་ཝེ་ཇི་ཡཱན་བོཀ་མཱལ་ཁ",
    "ne" to "ནེ་པཱལི་ཁ",
    "nl" to "ཌཆ་ཁ",
    "nl-BE" to "ཕྷེལེ་མིཤ་ཁ",
    "nn" to "ནོར་ཝེ་ཇི་ཡཱན་ནོརསཀ་ཁ",
    "no" to "ནོར་ཝི་ཇི་ཡན་ཁ",
    "or" to "ཨོ་རི་ཡ་ཁ",
    "pa" to "པཱན་ཇ་བི་ཁ",
    "pl" to "པོ་ལིཤ་ཁ",
    "ps" to "པཱཤ་ཏོ་ཁ",
    "pt" to "པོར་ཅུ་གིས་ཁ",
    "pt-BR" to "བྲ་ཛི་ལི་ཡཱན་པོར་ཅུ་གིས་ཁ",
    "pt-PT" to "ཨི་བེ་རི་ཡཱན་པོར་ཅུ་གིས་ཁ",
    "qu" to "ཀྭེ་ཆུ་ཨ་ཁ",
    "rm" to "རོ་མེ་ནིཤ་ཁ",
    "ro" to "རོ་མེ་ནི་ཡཱན་ཁ",
    "ru" to "ཨུ་རུ་སུའི་ཁ",
    "sa" to "སཾསྐྲྀཏ་ཁ",
    "sd" to "སིན་དཱི་ཁ",
    "shn" to "ཤཱན་ཁ",
    "si" to "སིང་ཧ་ལ་ཁ",
    "sk" to "སུ་ལོ་བཱཀ་ཁ",
    "sl" to "སུ་ལོ་བི་ནི་ཡཱན་ཁ",
    "so" to "སོ་མ་ལི་ཁ",
    "sq" to "ཨཱལ་བེ་ནི་ཡཱན་ཁ",
    "sr" to "སཱར་བྷི་ཡཱན་ཁ",
    "su" to "སཱུན་ད་ནིས་ཁ",
    "sv" to "སུའི་ཌིཤ་ཁ",
    "sw" to "སྭཱ་ཧི་ལི་ཁ",
    "ta" to "ཏ་མིལ་ཁ",
    "te" to "ཏེ་ལུ་གུ་ཁ",
    "tg" to "ཏ་ཇིཀ་ཁ",
    "th" to "ཐཱའི་ཁ",
    "ti" to "ཏིག་རི་ཉ་ཁ",
    "tk" to "ཊཱརཀ་མེན་ཁ",
    "to" to "ཊོང་གྷན་ཁ",
    "tr" to "ཊཱར་ཀིཤ་ཁ",
    "tt" to "ཊ་ཊར་ཁ",
    "ug" to "ཝི་གུར་ཁ",
    "uk" to "ཡུ་ཀེ་རེ་ནི་ཡཱན་ཁ",
    "und" to "ཁ་ངོ་མ་ཤེསཔ",
    "ur" to "ཨུར་དུ་ཁ",
    "uz" to "ཨུས་བེཀ་ཁ",
    "vi" to "བེཊ་ནཱ་མིས་ཁ",
    "wo" to "ཝོ་ལོཕ་ཁ",
    "xh" to "ཞོ་ས་ཁ",
    "yo" to "ཡོ་རུ་བ་ཁ",
    "zh" to "རྒྱ་མི་ཁ",
    "zh-alt-menu" to "རྒྱ་མི་ཁ",
    "zh-Hans" to "རྒྱ་མི་ཁ་འཇམ་སངམ",
    "zh-Hans-alt-long" to "རྒྱ་མི་ཁ་འཇམ་སངམ",
    "zh-Hant" to "སྔ་དུས་ཀྱི་རྒྱ་མི་ཁ",
    "zh-Hant-alt-long" to "སྔ་དུས་ཀྱི་རྒྱ་མི་ཁ",
    "zu" to "ཟུ་ལུ་ཁ",
    "zxx" to "སྐད་རིག་ནང་དོན་མེདཔ",
  ) }

  val ebu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Kĩakan",
    "am" to "Kĩamhari",
    "ar" to "Kĩarabu",
    "be" to "Kĩmbelarusi",
    "bg" to "Kĩbulgaria",
    "bn" to "Kĩbangla",
    "cs" to "Kĩcheki",
    "de" to "Kĩnjeremani",
    "ebu" to "Kĩembu",
    "el" to "Kĩngriki",
    "en" to "Kĩthungu",
    "es" to "Kĩhispania",
    "fa" to "Kĩanjemi",
    "fr" to "Kĩfaransa",
    "ha" to "Kĩhausa",
    "hi" to "Kĩhindĩ",
    "hu" to "Kĩhungari",
    "id" to "Kĩindonesia",
    "ig" to "Kĩigbo",
    "it" to "Kĩitaliano",
    "ja" to "Kĩnjapani",
    "jv" to "Kĩjava",
    "km" to "Kĩkambodia",
    "ko" to "Kĩkorea",
    "ms" to "Kĩmalesia",
    "my" to "Kĩburma",
    "ne" to "Kĩnepali",
    "nl" to "Kĩholanzi",
    "pa" to "Kĩpunjabi",
    "pl" to "Kĩpolandi",
    "pt" to "Kĩreno",
    "ro" to "Kĩromania",
    "ru" to "Kĩrusi",
    "rw" to "Kĩnyarwanda",
    "so" to "Kĩsomali",
    "sv" to "Kĩswidi",
    "ta" to "Kĩtamil",
    "th" to "Kĩtailandi",
    "tr" to "Kĩturuki",
    "uk" to "Kĩukrania",
    "ur" to "Kĩurdu",
    "vi" to "Kĩvietinamu",
    "yo" to "Kĩyoruba",
    "zh" to "Kĩchina",
    "zh-alt-menu" to "Kĩchina",
    "zu" to "Kĩzulu",
  ) }

  val ee: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ab" to "abkhaziagbe",
    "af" to "afrikaangbe",
    "agq" to "aghemgbe",
    "ak" to "blugbe",
    "am" to "amhariagbe",
    "ar" to "Arabiagbe",
    "as" to "assamegbe",
    "asa" to "asagbe",
    "ay" to "aymargbe",
    "az" to "azerbaijangbe",
    "az-alt-short" to "azerbaijangbe",
    "be" to "belarusiagbe",
    "bem" to "bembagbe",
    "bez" to "benagbe",
    "bg" to "bulgariagbe",
    "bm" to "bambaragbe",
    "bn" to "Bengaligbe",
    "bo" to "tibetagbe",
    "br" to "bretongbe",
    "brx" to "bodogbe",
    "bs" to "bosniagbe",
    "ca" to "katalagbe",
    "cs" to "tsɛkgbe",
    "cy" to "walesgbe",
    "da" to "denmarkgbe",
    "de" to "Germaniagbe",
    "de-AT" to "Germaniagbe (Austria)",
    "de-CH" to "Germaniagbe (Switzerland)",
    "dv" to "divehgbe",
    "dz" to "dzongkhagbe",
    "ebu" to "embugbe",
    "ee" to "eʋegbe",
    "efi" to "efigbe",
    "el" to "grisigbe",
    "en" to "iŋlisigbe",
    "en-AU" to "Yevugbe (Australia)",
    "en-CA" to "Yevugbe (Canada)",
    "en-GB" to "Yevugbe (Britain)",
    "en-GB-alt-short" to "Yevugbe (GB)",
    "en-US" to "Yevugbe (America)",
    "en-US-alt-short" to "Yevugbe (US)",
    "eo" to "esperantogbe",
    "es" to "Spanishgbe",
    "es-419" to "Spanishgbe (Latin America)",
    "es-ES" to "Spanishgbe (Europe)",
    "es-MX" to "Spanishgbe (Mexico)",
    "et" to "estoniagbe",
    "eu" to "basqugbe",
    "fa" to "persiagbe",
    "fi" to "finlanɖgbe",
    "fil" to "filipingbe",
    "fj" to "fidzigbe",
    "fr" to "Fransegbe",
    "fr-CA" to "Fransegbe (Canada)",
    "fr-CH" to "Fransegbe (Switzerland)",
    "ga" to "irelanɖgbe",
    "gl" to "galatagbe",
    "gn" to "guarangbe",
    "gsw" to "swizerlanɖtɔwo ƒe germaniagbe",
    "gu" to "gujarati",
    "ha" to "hausagbe",
    "haw" to "hawaigbe",
    "he" to "hebrigbe",
    "hi" to "Hindigbe",
    "hr" to "kroatiagbe",
    "ht" to "haitigbe",
    "hu" to "hungarigbe",
    "hy" to "armeniagbe",
    "id" to "Indonesiagbe",
    "ig" to "igbogbe",
    "is" to "icelanɖgbe",
    "it" to "Italiagbe",
    "ja" to "Japangbe",
    "jv" to "dzavangbe",
    "ka" to "gɔgiagbe",
    "kea" to "cape verdegbe",
    "kk" to "kazakhstangbe",
    "km" to "khmergbe",
    "kn" to "kannadagbe",
    "ko" to "Koreagbe",
    "ks" to "kashmirgbe",
    "ku" to "kurdiagbe",
    "ky" to "kirghistangbe",
    "la" to "latin",
    "lah" to "lahndagbe",
    "lb" to "laksembɔggbe",
    "ln" to "lingala",
    "lo" to "laogbe",
    "lt" to "lithuaniagbe",
    "luy" to "luyiagbe",
    "lv" to "latviagbe",
    "mg" to "malagasegbe",
    "mi" to "maorgbe",
    "mk" to "makedoniagbe",
    "ml" to "malayagbe",
    "mn" to "mongoliagbe",
    "mr" to "marathiagbe",
    "ms" to "malaygbe",
    "mt" to "maltagbe",
    "mul" to "gbegbɔgblɔ sɔgbɔwo",
    "my" to "burmagbe",
    "nb" to "nɔweigbe bokmål",
    "nd" to "dziehe ndebelegbe",
    "ne" to "nepalgbe",
    "nl" to "Hollandgbe",
    "nl-BE" to "Flemishgbe",
    "nn" to "nɔweigbe ninɔsk",
    "no" to "nɔweigbe",
    "nso" to "dziehe sothogbe",
    "ny" to "nyanjagbe",
    "or" to "oriyagbe",
    "os" to "ossetiagbe",
    "pa" to "pundzabgbe",
    "pl" to "Polishgbe",
    "ps" to "pashtogbe",
    "pt" to "Portuguesegbe",
    "pt-BR" to "Portuguesegbe (Brazil)",
    "pt-PT" to "Portuguesegbe (Europe)",
    "qu" to "kwetsuagbe",
    "rm" to "romanshgbe",
    "rn" to "rundigbe",
    "ro" to "romaniagbe",
    "rof" to "rombogbe",
    "ru" to "Russiagbe",
    "rw" to "ruwandagbe",
    "rwk" to "rwagbe",
    "sa" to "sanskrigbe",
    "sah" to "sakagbe",
    "sd" to "sindhgbe",
    "se" to "dziehe samigbe",
    "sg" to "sangogbe",
    "sh" to "serbo-croatiagbe",
    "si" to "sinhalgbe",
    "sk" to "slovakiagbe",
    "sl" to "sloveniagbe",
    "sm" to "samoagbe",
    "sn" to "shonagbe",
    "so" to "somaliagbe",
    "sq" to "albaniagbe",
    "sr" to "serbiagbe",
    "ss" to "swatgbe",
    "st" to "anyiehe sothogbe",
    "sv" to "swedengbe",
    "sw" to "swahili",
    "swb" to "komorogbe",
    "ta" to "tamilgbe",
    "te" to "telegugbe",
    "tet" to "tetumgbe",
    "tg" to "tadzikistangbe",
    "th" to "Thailandgbe",
    "ti" to "tigrinyagbe",
    "tk" to "tɛkmengbe",
    "tl" to "tagalogbe",
    "tn" to "tswanagbe",
    "to" to "tongagbe",
    "tpi" to "tok pisigbe",
    "tr" to "Turkishgbe",
    "ts" to "tsongagbe",
    "ty" to "tahitigbe",
    "ug" to "uighurgbe",
    "uk" to "ukraingbe",
    "und" to "gbegbɔgblɔ manya",
    "ur" to "urdugbe",
    "uz" to "uzbekistangbe",
    "ve" to "vendagbe",
    "vi" to "vietnamgbe",
    "wae" to "walsegbe",
    "wo" to "wolofgbe",
    "xh" to "xhosagbe",
    "yo" to "yorubagbe",
    "yue" to "cantongbe",
    "yue-alt-menu" to "cantongbe",
    "zh" to "Chinagbe",
    "zh-alt-menu" to "Chinagbe",
    "zh-Hans" to "tsainagbe",
    "zh-Hans-alt-long" to "tsainagbe",
    "zh-Hant" to "blema tsainagbe",
    "zh-Hant-alt-long" to "blema tsainagbe",
    "zu" to "zulugbe",
    "zxx" to "gbegbɔgblɔ manɔmee",
  ) }

  val ee_TG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val el: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Αφάρ",
    "ab" to "Αμπχαζικά",
    "ace" to "Ατσινιζικά",
    "ach" to "Ακολί",
    "ada" to "Αντάνγκμε",
    "ady" to "Αντιγκέα",
    "ae" to "Αβεστάν",
    "af" to "Αφρικάανς",
    "afh" to "Αφριχίλι",
    "agq" to "Αγκέμ",
    "ain" to "Αϊνού",
    "ak" to "Ακάν",
    "akk" to "Ακάντιαν",
    "ale" to "Αλεούτ",
    "alt" to "Νότια Αλτάι",
    "am" to "Αμχαρικά",
    "an" to "Αραγονικά",
    "ang" to "Παλαιά Αγγλικά",
    "ann" to "Ομπόλο",
    "anp" to "Ανγκικά",
    "ar" to "Αραβικά",
    "ar-001" to "Σύγχρονα Τυπικά Αραβικά",
    "arc" to "Αραμαϊκά",
    "arn" to "Αραουκανικά",
    "arp" to "Αραπάχο",
    "ars" to "Αραβικά Νάτζντι",
    "arw" to "Αραγουάκ",
    "as" to "Ασαμικά",
    "asa" to "Άσου",
    "ast" to "Αστουριανά",
    "atj" to "Ατικαμέκ",
    "av" to "Αβαρικά",
    "awa" to "Αγουαντί",
    "ay" to "Αϊμάρα",
    "az" to "Αζερμπαϊτζανικά",
    "az-alt-short" to "Αζερικά",
    "ba" to "Μπασκίρ",
    "bal" to "Μπαλούτσι",
    "ban" to "Μπαλινίζ",
    "bas" to "Μπάσα",
    "bax" to "Μπαμούν",
    "bbj" to "Γκομάλα",
    "be" to "Λευκορωσικά",
    "bej" to "Μπέζα",
    "bem" to "Μπέμπα",
    "bez" to "Μπένα",
    "bfd" to "Μπαφούτ",
    "bg" to "Βουλγαρικά",
    "bgc" to "Χαργιάνβι",
    "bgn" to "Δυτικά Μπαλοχικά",
    "bho" to "Μπότζπουρι",
    "bi" to "Μπισλάμα",
    "bik" to "Μπικόλ",
    "bin" to "Μπίνι",
    "bkm" to "Κομ",
    "bla" to "Σικσίκα",
    "blo" to "Ανίι",
    "bm" to "Μπαμπάρα",
    "bn" to "Βεγγαλικά",
    "bo" to "Θιβετιανά",
    "br" to "Βρετονικά",
    "bra" to "Μπρατζ",
    "brx" to "Μπόντο",
    "bs" to "Βοσνιακά",
    "bss" to "Ακόσι",
    "bua" to "Μπουριάτ",
    "bug" to "Μπουγκίζ",
    "bum" to "Μπουλού",
    "byn" to "Μπλιν",
    "byv" to "Μεντούμπα",
    "ca" to "Καταλανικά",
    "cad" to "Κάντο",
    "car" to "Καρίμπ",
    "cay" to "Καγιούγκα",
    "cch" to "Ατσάμ",
    "ccp" to "Τσάκμα",
    "ce" to "Τσετσενικά",
    "ceb" to "Σεμπουάνο",
    "cgg" to "Τσίγκα",
    "ch" to "Τσαμόρο",
    "chb" to "Τσίμπτσα",
    "chg" to "Τσαγκατάι",
    "chk" to "Τσουκίζι",
    "chm" to "Μάρι",
    "chn" to "Ιδιωματικά Σινούκ",
    "cho" to "Τσόκτο",
    "chp" to "Τσίπιουαν",
    "chr" to "Τσερόκι",
    "chy" to "Τσεγιέν",
    "ckb" to "Κεντρικά Κουρδικά",
    "ckb-alt-menu" to "Κουρδικά, Κεντρικά",
    "ckb-alt-variant" to "Κουρδικά, Σοράνι",
    "clc" to "Τσιλκότιν",
    "co" to "Κορσικανικά",
    "cop" to "Κοπτικά",
    "cr" to "Κρι",
    "crg" to "Μίτσιφ",
    "crh" to "Τουρκικά Κριμαίας",
    "crj" to "Νοτιοανατολικά Κρι",
    "crk" to "Κρι πεδιάδας",
    "crl" to "Βορειοανατολικά Κρι",
    "crm" to "Μους Κρι",
    "crr" to "Καρολίνα Αλγκονκιάν",
    "crs" to "Κρεολικά Γαλλικά Σεϋχελλών",
    "cs" to "Τσεχικά",
    "csb" to "Κασούμπιαν",
    "csw" to "Κρι Βάλτου",
    "cu" to "Εκκλησιαστικά Σλαβικά",
    "cv" to "Τσουβασικά",
    "cy" to "Ουαλικά",
    "da" to "Δανικά",
    "dak" to "Ντακότα",
    "dar" to "Ντάργκουα",
    "dav" to "Τάιτα",
    "de" to "Γερμανικά",
    "de-AT" to "Γερμανικά Αυστρίας",
    "de-CH" to "Υψηλά Γερμανικά Ελβετίας",
    "del" to "Ντέλαγουερ",
    "den" to "Σλαβικά",
    "dgr" to "Ντόγκριμπ",
    "din" to "Ντίνκα",
    "dje" to "Ζάρμα",
    "doi" to "Ντόγκρι",
    "dsb" to "Κάτω Σορβικά",
    "dua" to "Ντουάλα",
    "dum" to "Μέσα Ολλανδικά",
    "dv" to "Ντιβέχι",
    "dyo" to "Τζόλα-Φόνι",
    "dyu" to "Ντογιούλα",
    "dz" to "Ντζόνγκχα",
    "dzg" to "Νταζάγκα",
    "ebu" to "Έμπου",
    "ee" to "Έουε",
    "efi" to "Εφίκ",
    "egy" to "Αρχαία Αιγυπτιακά",
    "eka" to "Εκατζούκ",
    "el" to "Ελληνικά",
    "elx" to "Ελαμάιτ",
    "en" to "Αγγλικά",
    "en-AU" to "Αγγλικά Αυστραλίας",
    "en-CA" to "Αγγλικά Καναδά",
    "en-GB" to "Αγγλικά Βρετανίας",
    "en-GB-alt-short" to "Αγγλικά ΗΒ",
    "en-US" to "Αγγλικά Αμερικής",
    "en-US-alt-short" to "Αγγλικά ΗΠΑ",
    "enm" to "Μέσα Αγγλικά",
    "eo" to "Εσπεράντο",
    "es" to "Ισπανικά",
    "es-419" to "Ισπανικά Λατινικής Αμερικής",
    "es-ES" to "Ισπανικά Ευρώπης",
    "es-MX" to "Ισπανικά Μεξικού",
    "et" to "Εσθονικά",
    "eu" to "Βασκικά",
    "ewo" to "Εγουόντο",
    "fa" to "Περσικά",
    "fa-AF" to "Νταρί",
    "fan" to "Φανγκ",
    "fat" to "Φάντι",
    "ff" to "Φουλά",
    "fi" to "Φινλανδικά",
    "fil" to "Φιλιππινικά",
    "fj" to "Φίτζι",
    "fo" to "Φεροϊκά",
    "fon" to "Φον",
    "fr" to "Γαλλικά",
    "fr-CA" to "Γαλλικά Καναδά",
    "fr-CH" to "Γαλλικά Ελβετίας",
    "frc" to "Γαλλικά (Λουιζιάνα)",
    "frm" to "Μέσα Γαλλικά",
    "fro" to "Παλαιά Γαλλικά",
    "frr" to "Βόρεια Φριζιανά",
    "frs" to "Ανατολικά Φριζιανά",
    "fur" to "Φριουλανικά",
    "fy" to "Δυτικά Φριζικά",
    "ga" to "Ιρλανδικά",
    "gaa" to "Γκα",
    "gag" to "Γκαγκάουζ",
    "gay" to "Γκάγιο",
    "gba" to "Γκμπάγια",
    "gd" to "Σκωτικά Κελτικά",
    "gez" to "Γκιζ",
    "gil" to "Γκιλμπερτίζ",
    "gl" to "Γαλικιανά",
    "gmh" to "Μέσα Άνω Γερμανικά",
    "gn" to "Γκουαρανί",
    "goh" to "Παλαιά Άνω Γερμανικά",
    "gon" to "Γκόντι",
    "gor" to "Γκοροντάλο",
    "got" to "Γοτθικά",
    "grb" to "Γκρίμπο",
    "grc" to "Αρχαία Ελληνικά",
    "gsw" to "Γερμανικά Ελβετίας",
    "gu" to "Γκουτζαρατικά",
    "guz" to "Γκούσι",
    "gv" to "Μανξ",
    "gwi" to "Γκουίτσιν",
    "ha" to "Χάουσα",
    "hai" to "Χάιντα",
    "haw" to "Χαβαϊκά",
    "hax" to "Βόρεια Χάιντα",
    "he" to "Εβραϊκά",
    "hi" to "Χίντι",
    "hi-Latn-alt-variant" to "Hinglish",
    "hil" to "Χιλιγκαϊνόν",
    "hit" to "Χιτίτε",
    "hmn" to "Χμονγκ",
    "ho" to "Χίρι Μότου",
    "hr" to "Κροατικά",
    "hsb" to "Άνω Σορβικά",
    "ht" to "Αϊτιανά",
    "hu" to "Ουγγρικά",
    "hup" to "Χούπα",
    "hur" to "Χαλκομελέμ",
    "hy" to "Αρμενικά",
    "hz" to "Χερέρο",
    "ia" to "Ιντερλίνγκουα",
    "iba" to "Ιμπάν",
    "ibb" to "Ιμπίμπιο",
    "id" to "Ινδονησιακά",
    "ie" to "Ιντερλίνγκουε",
    "ig" to "Ίγκμπο",
    "ii" to "Σίτσουαν Γι",
    "ik" to "Ινουπιάκ",
    "ikt" to "Ινουκτιτούτ Δυτικού Καναδά",
    "ilo" to "Ιλόκο",
    "inh" to "Ινγκούς",
    "io" to "Ίντο",
    "is" to "Ισλανδικά",
    "it" to "Ιταλικά",
    "iu" to "Ινούκτιτουτ",
    "ja" to "Ιαπωνικά",
    "jbo" to "Λόζμπαν",
    "jgo" to "Νγκόμπα",
    "jmc" to "Ματσάμε",
    "jpr" to "Ιουδαϊκά-Περσικά",
    "jrb" to "Ιουδαϊκά-Αραβικά",
    "jv" to "Ιαβανικά",
    "ka" to "Γεωργιανά",
    "kaa" to "Κάρα-Καλπάκ",
    "kab" to "Καμπίλε",
    "kac" to "Κατσίν",
    "kaj" to "Τζου",
    "kam" to "Κάμπα",
    "kaw" to "Κάουι",
    "kbd" to "Καμπαρντιανά",
    "kbl" to "Κανέμπου",
    "kcg" to "Τιάπ",
    "kde" to "Μακόντε",
    "kea" to "Γλώσσα του Πράσινου Ακρωτηρίου",
    "kfo" to "Κόρο",
    "kg" to "Κονγκό",
    "kgp" to "Κάινγκανγκ",
    "kha" to "Κάσι",
    "kho" to "Κοτανικά",
    "khq" to "Κόιρα Τσίνι",
    "ki" to "Κικούγιου",
    "kj" to "Κουανιάμα",
    "kk" to "Καζακικά",
    "kkj" to "Κάκο",
    "kl" to "Καλαάλισουτ",
    "kln" to "Καλεντζίν",
    "km" to "Χμερ",
    "kmb" to "Κιμπούντου",
    "kn" to "Κανάντα",
    "ko" to "Κορεατικά",
    "koi" to "Κόμι-Περμιάκ",
    "kok" to "Κονκανικά",
    "kos" to "Κοσραενικά",
    "kpe" to "Κπέλε",
    "kr" to "Κανούρι",
    "krc" to "Καρατσάι-Μπαλκάρ",
    "krl" to "Καρελικά",
    "kru" to "Κουρούχ",
    "ks" to "Κασμιρικά",
    "ksb" to "Σαμπάλα",
    "ksf" to "Μπάφια",
    "ksh" to "Κολωνικά",
    "ku" to "Κουρδικά",
    "kum" to "Κουμγιούκ",
    "kut" to "Κουτενάι",
    "kv" to "Κόμι",
    "kw" to "Κορνουαλικά",
    "kwk" to "Κουακουάλα",
    "kxv" to "Κούβι",
    "ky" to "Κιργιζικά",
    "la" to "Λατινικά",
    "lad" to "Λαδίνο",
    "lag" to "Λάνγκι",
    "lah" to "Λάχδα",
    "lam" to "Λάμπα",
    "lb" to "Λουξεμβουργιανά",
    "lez" to "Λεζγκικά",
    "lg" to "Γκάντα",
    "li" to "Λιμβουργιανά",
    "lij" to "Λιγουριανά",
    "lil" to "Λιλουέτ",
    "lkt" to "Λακότα",
    "lmo" to "Λομβαρδικά",
    "ln" to "Λινγκάλα",
    "lo" to "Λαοτινά",
    "lol" to "Μόνγκο",
    "lou" to "Κρεολικά (Λουιζιάνα)",
    "loz" to "Λόζι",
    "lrc" to "Βόρεια Λούρι",
    "lsm" to "Σαάμια",
    "lt" to "Λιθουανικά",
    "lu" to "Λούμπα-Κατάνγκα",
    "lua" to "Λούμπα-Λουλούα",
    "lui" to "Λουισένο",
    "lun" to "Λούντα",
    "luo" to "Λούο",
    "lus" to "Μίζο",
    "luy" to "Λούχια",
    "lv" to "Λετονικά",
    "mad" to "Μαντουρίζ",
    "maf" to "Μάφα",
    "mag" to "Μαγκάχι",
    "mai" to "Μαϊτχίλι",
    "mak" to "Μακασάρ",
    "man" to "Μαντίνγκο",
    "mas" to "Μασάι",
    "mde" to "Μάμπα",
    "mdf" to "Μόκσα",
    "mdr" to "Μανδάρ",
    "men" to "Μέντε",
    "mer" to "Μέρου",
    "mfe" to "Μορισιέν",
    "mg" to "Μαλγασικά",
    "mga" to "Μέσα Ιρλανδικά",
    "mgh" to "Μακούβα-Μέτο",
    "mgo" to "Μέτα",
    "mh" to "Μαρσαλέζικα",
    "mi" to "Μαορί",
    "mic" to "Μικμάκ",
    "min" to "Μινανγκαμπάου",
    "mk" to "Σλαβομακεδονικά",
    "ml" to "Μαλαγιαλαμικά",
    "mn" to "Μογγολικά",
    "mnc" to "Μαντσού",
    "mni" to "Μανιπούρι",
    "moe" to "Ινου-αϊμούν",
    "moh" to "Μοχόκ",
    "mos" to "Μόσι",
    "mr" to "Μαραθικά",
    "ms" to "Μαλαισιανά",
    "mt" to "Μαλτεζικά",
    "mua" to "Μουντάνγκ",
    "mul" to "Πολλαπλές γλώσσες",
    "mus" to "Κρικ",
    "mwl" to "Μιραντεζικά",
    "mwr" to "Μαργουάρι",
    "my" to "Βιρμανικά",
    "mye" to "Μιένε",
    "myv" to "Έρζια",
    "mzn" to "Μαζαντεράνι",
    "na" to "Ναούρου",
    "nap" to "Ναπολιτανικά",
    "naq" to "Νάμα",
    "nb" to "Νορβηγικά Μποκμάλ",
    "nd" to "Βόρεια Ντεμπέλε",
    "nds" to "Κάτω Γερμανικά",
    "nds-NL" to "Κάτω Γερμανικά Ολλανδίας",
    "ne" to "Νεπαλικά",
    "new" to "Νεγουάρι",
    "ng" to "Ντόνγκα",
    "nia" to "Νίας",
    "niu" to "Νιούε",
    "nl" to "Ολλανδικά",
    "nl-BE" to "Φλαμανδικά",
    "nmg" to "Κβάσιο",
    "nn" to "Νορβηγικά Νινόρσκ",
    "nnh" to "Νγκιεμπούν",
    "no" to "Νορβηγικά",
    "nog" to "Νογκάι",
    "non" to "Παλαιά Νορβηγικά",
    "nqo" to "Ν’Κο",
    "nr" to "Νότια Ντεμπέλε",
    "nso" to "Βόρεια Σόθο",
    "nus" to "Νούερ",
    "nv" to "Νάβαχο",
    "nwc" to "Κλασικά Νεουάρι",
    "ny" to "Νιάντζα",
    "nym" to "Νιαμγουέζι",
    "nyn" to "Νιανκόλε",
    "nyo" to "Νιόρο",
    "nzi" to "Νζίμα",
    "oc" to "Οξιτανικά",
    "oj" to "Οζιβίγουα",
    "ojb" to "Βορειοδυτικά Οζιβίγουα",
    "ojc" to "Κεντρικά Οτζίμπουα",
    "ojs" to "Ότζι-Κρι",
    "ojw" to "Δυτικά Οζιβίγουα",
    "oka" to "Οκανάγκαν",
    "om" to "Ορόμο",
    "or" to "Όντια",
    "os" to "Οσετικά",
    "osa" to "Οσάζ",
    "ota" to "Οθωμανικά Τουρκικά",
    "pa" to "Παντζαπικά",
    "pag" to "Πανγκασινάν",
    "pal" to "Παχλάβι",
    "pam" to "Παμπάνγκα",
    "pap" to "Παπιαμέντο",
    "pau" to "Παλάουαν",
    "pcm" to "Πίτζιν Νιγηρίας",
    "peo" to "Αρχαία Περσικά",
    "phn" to "Φοινικικά",
    "pi" to "Πάλι",
    "pis" to "Πιτζίν",
    "pl" to "Πολωνικά",
    "pon" to "Πομπηικά",
    "pqm" to "Μαλισιτ-Πασσαμακουόντ",
    "prg" to "Πρωσικά",
    "pro" to "Παλαιά Προβανσάλ",
    "ps" to "Πάστο",
    "pt" to "Πορτογαλικά",
    "pt-BR" to "Πορτογαλικά Βραζιλίας",
    "pt-PT" to "Πορτογαλικά Ευρώπης",
    "qu" to "Κέτσουα",
    "quc" to "Κιτσέ",
    "raj" to "Ραζασθάνι",
    "rap" to "Ραπανούι",
    "rar" to "Ραροτονγκάν",
    "rhg" to "Ροχίνγκια",
    "rm" to "Ρομανικά",
    "rn" to "Ρούντι",
    "ro" to "Ρουμανικά",
    "ro-MD" to "Μολδαβικά",
    "rof" to "Ρόμπο",
    "rom" to "Ρομανί",
    "ru" to "Ρωσικά",
    "rup" to "Αρομανικά",
    "rw" to "Κινιαρουάντα",
    "rwk" to "Ρουά",
    "sa" to "Σανσκριτικά",
    "sad" to "Σαντάγουε",
    "sah" to "Σαχά",
    "sam" to "Σαμαρίτικα Αραμαϊκά",
    "saq" to "Σαμπούρου",
    "sas" to "Σασάκ",
    "sat" to "Σαντάλι",
    "sba" to "Νγκαμπέι",
    "sbp" to "Σάνγκου",
    "sc" to "Σαρδηνιακά",
    "scn" to "Σικελικά",
    "sco" to "Σκωτικά",
    "sd" to "Σίντι",
    "sdh" to "Νότια Κουρδικά",
    "se" to "Βόρεια Σάμι",
    "see" to "Σένεκα",
    "seh" to "Σένα",
    "sel" to "Σελκούπ",
    "ses" to "Κοϊραμπόρο Σένι",
    "sg" to "Σάνγκο",
    "sga" to "Παλαιά Ιρλανδικά",
    "sh" to "Σερβοκροατικά",
    "shi" to "Τασελχίτ",
    "shn" to "Σαν",
    "shu" to "Αραβικά του Τσαντ",
    "si" to "Σινχαλεζικά",
    "sid" to "Σιντάμο",
    "sk" to "Σλοβακικά",
    "sl" to "Σλοβενικά",
    "slh" to "Νότια Λάσουτσιντ",
    "sm" to "Σαμοανά",
    "sma" to "Νότια Σάμι",
    "smj" to "Λούλε Σάμι",
    "smn" to "Ινάρι Σάμι",
    "sms" to "Σκολτ Σάμι",
    "sn" to "Σόνα",
    "snk" to "Σονίνκε",
    "so" to "Σομαλικά",
    "sog" to "Σογκντιέν",
    "sq" to "Αλβανικά",
    "sr" to "Σερβικά",
    "srn" to "Σρανάν Τόνγκο",
    "srr" to "Σερέρ",
    "ss" to "Σουάτι",
    "ssy" to "Σάχο",
    "st" to "Νότια Σόθο",
    "str" to "Στρέιτς Σαλίς",
    "su" to "Σουνδανικά",
    "suk" to "Σουκούμα",
    "sus" to "Σούσου",
    "sux" to "Σουμερικά",
    "sv" to "Σουηδικά",
    "sw" to "Σουαχίλι",
    "sw-CD" to "Κονγκό Σουαχίλι",
    "swb" to "Κομοριανά",
    "syc" to "Κλασικά Συριακά",
    "syr" to "Συριακά",
    "szl" to "Σιλεσικά",
    "ta" to "Ταμιλικά",
    "tce" to "Νότια Τουτσόνε",
    "te" to "Τελούγκου",
    "tem" to "Τίμνε",
    "teo" to "Τέσο",
    "ter" to "Τερένο",
    "tet" to "Τέτουμ",
    "tg" to "Τατζικικά",
    "tgx" to "Τατζίς",
    "th" to "Ταϊλανδικά",
    "tht" to "Ταλτάν",
    "ti" to "Τιγκρινικά",
    "tig" to "Τίγκρε",
    "tiv" to "Τιβ",
    "tk" to "Τουρκμενικά",
    "tkl" to "Τοκελάου",
    "tl" to "Τάγκαλογκ",
    "tlh" to "Κλίνγκον",
    "tli" to "Τλίνγκιτ",
    "tmh" to "Ταμασέκ",
    "tn" to "Τσουάνα",
    "to" to "Τονγκανικά",
    "tog" to "Νιάσα Τόνγκα",
    "tok" to "Τόκι Πόνα",
    "tpi" to "Τοκ Πισίν",
    "tr" to "Τουρκικά",
    "trv" to "Ταρόκο",
    "ts" to "Τσόνγκα",
    "tsi" to "Τσίμσιαν",
    "tt" to "Ταταρικά",
    "ttm" to "Βόρεια Τουτσόνε",
    "tum" to "Τουμπούκα",
    "tvl" to "Τουβαλού",
    "tw" to "Τούι",
    "twq" to "Τασαβάκ",
    "ty" to "Ταϊτιανά",
    "tyv" to "Τουβινικά",
    "tzm" to "Ταμαζίτ Κεντρικού Μαρόκο",
    "udm" to "Ουντμούρτ",
    "ug" to "Ουιγουρικά",
    "ug-alt-variant" to "Ουιγούρ",
    "uga" to "Ουγκαριτικά",
    "uk" to "Ουκρανικά",
    "umb" to "Ουμπούντου",
    "und" to "Άγνωστη γλώσσα",
    "ur" to "Ούρντου",
    "uz" to "Ουζμπεκικά",
    "vai" to "Βάι",
    "ve" to "Βέντα",
    "vec" to "Βενετικά",
    "vi" to "Βιετναμικά",
    "vmw" to "Μακούα",
    "vo" to "Βολαπιούκ",
    "vot" to "Βότικ",
    "vun" to "Βούντζο",
    "wa" to "Βαλλωνικά",
    "wae" to "Βάλσερ",
    "wal" to "Γουολάιτα",
    "war" to "Γουάραϊ",
    "was" to "Γουασό",
    "wbp" to "Γουαρλπίρι",
    "wo" to "Γουόλοφ",
    "wuu" to "Κινεζικά Γου",
    "xal" to "Καλμίκ",
    "xh" to "Κόσα",
    "xnr" to "Κάνγκρι",
    "xog" to "Σόγκα",
    "yao" to "Γιάο",
    "yap" to "Γιαπίζ",
    "yav" to "Γιανγκμπέν",
    "ybb" to "Γιέμπα",
    "yi" to "Γίντις",
    "yo" to "Γιορούμπα",
    "yrl" to "Νινγκατού",
    "yue" to "Καντονέζικα",
    "yue-alt-menu" to "Κινεζικά, Καντονέζικα",
    "za" to "Ζουάνγκ",
    "zap" to "Ζάποτεκ",
    "zbl" to "Σύμβολα Bliss",
    "zen" to "Ζενάγκα",
    "zgh" to "Τυπικά Ταμαζίτ Μαρόκου",
    "zh" to "Κινεζικά",
    "zh-alt-menu" to "Κινεζικά, Μανδαρινικά",
    "zh-Hans" to "Απλοποιημένα Κινεζικά",
    "zh-Hans-alt-long" to "Απλοποιημένα Μανδαρινικά Κινεζικά",
    "zh-Hant" to "Παραδοσιακά Κινεζικά",
    "zh-Hant-alt-long" to "Παραδοσιακά Μανδαρινικά Κινεζικά",
    "zu" to "Ζουλού",
    "zun" to "Ζούνι",
    "zxx" to "Χωρίς γλωσσολογικό περιεχόμενο",
    "zza" to "Ζάζα",
  ) }

  val el_CY: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val el_polyton: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar" to "Ἀραβικά",
    "arc" to "Ἀραμαϊκά",
    "cy" to "Οὐαλικά",
    "egy" to "Αἰγυπτιακὰ (ἀρχαῖα)",
    "el" to "Ἑλληνικά",
    "en" to "Ἀγγλικά",
    "es" to "Ἱσπανικά",
    "et" to "Ἐσθονικά",
    "ga" to "Ἰρλανδικά",
    "gd" to "Σκωτικὰ κελτικά",
    "grc" to "Ἀρχαῖα Ἑλληνικά",
    "he" to "Ἑβραϊκά",
    "hu" to "Οὑγγρικά",
    "hy" to "Ἀρμενικά",
    "id" to "Ἰνδονησιακά",
    "is" to "Ἰσλανδικά",
    "it" to "Ἰταλικά",
    "ja" to "Ἰαπωνικά",
    "mul" to "Πολλαπλές γλῶσσες",
    "nl" to "Ὁλλανδικά",
    "ota" to "Τουρκικά, ὀθωμανικὰ",
    "peo" to "Ἀρχαῖα περσικὰ",
    "sq" to "Ἀλβανικά",
    "uk" to "Οὐκρανικά",
    "yi" to "Ἰουδαϊκά",
  ) }

  val en: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afar",
    "ab" to "Abkhazian",
    "ace" to "Acehnese",
    "ach" to "Acoli",
    "ada" to "Adangme",
    "ady" to "Adyghe",
    "ae" to "Avestan",
    "aeb" to "Tunisian Arabic",
    "af" to "Afrikaans",
    "afh" to "Afrihili",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "akk" to "Akkadian",
    "akz" to "Alabama",
    "ale" to "Aleut",
    "aln" to "Gheg Albanian",
    "alt" to "Southern Altai",
    "am" to "Amharic",
    "an" to "Aragonese",
    "ang" to "Old English",
    "ann" to "Obolo",
    "anp" to "Angika",
    "ar" to "Arabic",
    "ar-001" to "Modern Standard Arabic",
    "arc" to "Aramaic",
    "arn" to "Mapuche",
    "aro" to "Araona",
    "arp" to "Arapaho",
    "arq" to "Algerian Arabic",
    "ars" to "Najdi Arabic",
    "ars-alt-menu" to "Arabic, Najdi",
    "arw" to "Arawak",
    "ary" to "Moroccan Arabic",
    "arz" to "Egyptian Arabic",
    "as" to "Assamese",
    "asa" to "Asu",
    "ase" to "American Sign Language",
    "ast" to "Asturian",
    "atj" to "Atikamekw",
    "av" to "Avaric",
    "avk" to "Kotava",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Azerbaijani",
    "az-alt-short" to "Azeri",
    "ba" to "Bashkir",
    "bal" to "Baluchi",
    "ban" to "Balinese",
    "bar" to "Bavarian",
    "bas" to "Basaa",
    "bax" to "Bamun",
    "bbc" to "Batak Toba",
    "bbj" to "Ghomala",
    "be" to "Belarusian",
    "bej" to "Beja",
    "bem" to "Bemba",
    "bew" to "Betawi",
    "bez" to "Bena",
    "bfd" to "Bafut",
    "bfq" to "Badaga",
    "bg" to "Bulgarian",
    "bgc" to "Haryanvi",
    "bgn" to "Western Balochi",
    "bho" to "Bhojpuri",
    "bi" to "Bislama",
    "bik" to "Bikol",
    "bin" to "Bini",
    "bjn" to "Banjar",
    "bkm" to "Kom",
    "bla" to "Siksiká",
    "blo" to "Anii",
    "blt" to "Tai Dam",
    "bm" to "Bambara",
    "bn" to "Bangla",
    "bo" to "Tibetan",
    "bpy" to "Bishnupriya",
    "bqi" to "Bakhtiari",
    "br" to "Breton",
    "bra" to "Braj",
    "brh" to "Brahui",
    "brx" to "Bodo",
    "bs" to "Bosnian",
    "bss" to "Akoose",
    "bua" to "Buriat",
    "bug" to "Buginese",
    "bum" to "Bulu",
    "byn" to "Blin",
    "byv" to "Medumba",
    "ca" to "Catalan",
    "cad" to "Caddo",
    "car" to "Carib",
    "cay" to "Cayuga",
    "cch" to "Atsam",
    "ccp" to "Chakma",
    "ce" to "Chechen",
    "ceb" to "Cebuano",
    "cgg" to "Chiga",
    "ch" to "Chamorro",
    "chb" to "Chibcha",
    "chg" to "Chagatai",
    "chk" to "Chuukese",
    "chm" to "Mari",
    "chn" to "Chinook Jargon",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyenne",
    "cic" to "Chickasaw",
    "ckb" to "Central Kurdish",
    "ckb-alt-menu" to "Kurdish, Central",
    "ckb-alt-variant" to "Kurdish, Sorani",
    "clc" to "Chilcotin",
    "co" to "Corsican",
    "cop" to "Coptic",
    "cps" to "Capiznon",
    "cr" to "Cree",
    "crg" to "Michif",
    "crh" to "Crimean Tatar",
    "crj" to "Southern East Cree",
    "crk" to "Plains Cree",
    "crl" to "Northern East Cree",
    "crm" to "Moose Cree",
    "crr" to "Carolina Algonquian",
    "crs" to "Seselwa Creole French",
    "cs" to "Czech",
    "csb" to "Kashubian",
    "csw" to "Swampy Cree",
    "cu" to "Church Slavic",
    "cv" to "Chuvash",
    "cwd" to "Woods Cree",
    "cy" to "Welsh",
    "da" to "Danish",
    "dak" to "Dakota",
    "dar" to "Dargwa",
    "dav" to "Taita",
    "de" to "German",
    "de-AT" to "Austrian German",
    "de-CH" to "Swiss High German",
    "del" to "Delaware",
    "den" to "Slave",
    "dgr" to "Dogrib",
    "din" to "Dinka",
    "dje" to "Zarma",
    "doi" to "Dogri",
    "dsb" to "Lower Sorbian",
    "dtp" to "Central Dusun",
    "dua" to "Duala",
    "dum" to "Middle Dutch",
    "dv" to "Divehi",
    "dyo" to "Jola-Fonyi",
    "dyu" to "Dyula",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "egl" to "Emilian",
    "egy" to "Ancient Egyptian",
    "eka" to "Ekajuk",
    "el" to "Greek",
    "elx" to "Elamite",
    "en" to "English",
    "en-AU" to "Australian English",
    "en-CA" to "Canadian English",
    "en-GB" to "British English",
    "en-GB-alt-short" to "UK English",
    "en-US" to "American English",
    "en-US-alt-short" to "US English",
    "enm" to "Middle English",
    "eo" to "Esperanto",
    "es" to "Spanish",
    "es-419" to "Latin American Spanish",
    "es-ES" to "European Spanish",
    "es-MX" to "Mexican Spanish",
    "esu" to "Central Yupik",
    "et" to "Estonian",
    "eu" to "Basque",
    "ewo" to "Ewondo",
    "ext" to "Extremaduran",
    "fa" to "Persian",
    "fa-AF" to "Dari",
    "fan" to "Fang",
    "fat" to "Fanti",
    "ff" to "Fula",
    "fi" to "Finnish",
    "fil" to "Filipino",
    "fit" to "Tornedalen Finnish",
    "fj" to "Fijian",
    "fo" to "Faroese",
    "fon" to "Fon",
    "fr" to "French",
    "fr-CA" to "Canadian French",
    "fr-CH" to "Swiss French",
    "frc" to "Cajun French",
    "frm" to "Middle French",
    "fro" to "Old French",
    "frp" to "Arpitan",
    "frr" to "Northern Frisian",
    "frs" to "Eastern Frisian",
    "fur" to "Friulian",
    "fy" to "Western Frisian",
    "ga" to "Irish",
    "gaa" to "Ga",
    "gag" to "Gagauz",
    "gan" to "Gan Chinese",
    "gay" to "Gayo",
    "gba" to "Gbaya",
    "gbz" to "Zoroastrian Dari",
    "gd" to "Scottish Gaelic",
    "gez" to "Geez",
    "gil" to "Gilbertese",
    "gl" to "Galician",
    "glk" to "Gilaki",
    "gmh" to "Middle High German",
    "gn" to "Guarani",
    "goh" to "Old High German",
    "gon" to "Gondi",
    "gor" to "Gorontalo",
    "got" to "Gothic",
    "grb" to "Grebo",
    "grc" to "Ancient Greek",
    "gsw" to "Swiss German",
    "gu" to "Gujarati",
    "guc" to "Wayuu",
    "gur" to "Frafra",
    "guz" to "Gusii",
    "gv" to "Manx",
    "gwi" to "Gwichʼin",
    "ha" to "Hausa",
    "hai" to "Haida",
    "hak" to "Hakka Chinese",
    "haw" to "Hawaiian",
    "hax" to "Southern Haida",
    "hdn" to "Northern Haida",
    "he" to "Hebrew",
    "hi" to "Hindi",
    "hi-Latn" to "Hindi (Latin)",
    "hi-Latn-alt-variant" to "Hinglish",
    "hif" to "Fiji Hindi",
    "hil" to "Hiligaynon",
    "hit" to "Hittite",
    "hmn" to "Hmong",
    "hnj" to "Hmong Njua",
    "ho" to "Hiri Motu",
    "hr" to "Croatian",
    "hsb" to "Upper Sorbian",
    "hsn" to "Xiang Chinese",
    "ht" to "Haitian Creole",
    "hu" to "Hungarian",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Armenian",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Iban",
    "ibb" to "Ibibio",
    "id" to "Indonesian",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Sichuan Yi",
    "ik" to "Inupiaq",
    "ike" to "Eastern Canadian Inuktitut",
    "ikt" to "Western Canadian Inuktitut",
    "ilo" to "Iloko",
    "inh" to "Ingush",
    "io" to "Ido",
    "is" to "Icelandic",
    "it" to "Italian",
    "iu" to "Inuktitut",
    "izh" to "Ingrian",
    "ja" to "Japanese",
    "jam" to "Jamaican Creole English",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jpr" to "Judeo-Persian",
    "jrb" to "Judeo-Arabic",
    "jut" to "Jutish",
    "jv" to "Javanese",
    "ka" to "Georgian",
    "kaa" to "Kara-Kalpak",
    "kab" to "Kabyle",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kaw" to "Kawi",
    "kbd" to "Kabardian",
    "kbl" to "Kanembu",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kabuverdianu",
    "ken" to "Kenyang",
    "kfo" to "Koro",
    "kg" to "Kongo",
    "kgp" to "Kaingang",
    "kha" to "Khasi",
    "kho" to "Khotanese",
    "khq" to "Koyra Chiini",
    "khw" to "Khowar",
    "ki" to "Kikuyu",
    "kiu" to "Kirmanjki",
    "kj" to "Kuanyama",
    "kk" to "Kazakh",
    "kkj" to "Kako",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Khmer",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Korean",
    "koi" to "Komi-Permyak",
    "kok" to "Konkani",
    "kos" to "Kosraean",
    "kpe" to "Kpelle",
    "kr" to "Kanuri",
    "krc" to "Karachay-Balkar",
    "kri" to "Krio",
    "krj" to "Kinaray-a",
    "krl" to "Karelian",
    "kru" to "Kurukh",
    "ks" to "Kashmiri",
    "ksb" to "Shambala",
    "ksf" to "Bafia",
    "ksh" to "Colognian",
    "ku" to "Kurdish",
    "kum" to "Kumyk",
    "kut" to "Kutenai",
    "kv" to "Komi",
    "kw" to "Cornish",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kuvi",
    "ky" to "Kyrgyz",
    "ky-alt-variant" to "Kirghiz",
    "la" to "Latin",
    "lad" to "Ladino",
    "lag" to "Langi",
    "lah" to "Western Panjabi",
    "lam" to "Lamba",
    "lb" to "Luxembourgish",
    "lez" to "Lezghian",
    "lfn" to "Lingua Franca Nova",
    "lg" to "Ganda",
    "li" to "Limburgish",
    "lij" to "Ligurian",
    "lil" to "Lillooet",
    "liv" to "Livonian",
    "lkt" to "Lakota",
    "lmo" to "Lombard",
    "ln" to "Lingala",
    "lo" to "Lao",
    "lol" to "Mongo",
    "lou" to "Louisiana Creole",
    "loz" to "Lozi",
    "lrc" to "Northern Luri",
    "lsm" to "Saamia",
    "lt" to "Lithuanian",
    "ltg" to "Latgalian",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lui" to "Luiseno",
    "lun" to "Lunda",
    "luo" to "Luo",
    "lus" to "Mizo",
    "luy" to "Luyia",
    "lv" to "Latvian",
    "lzh" to "Literary Chinese",
    "lzz" to "Laz",
    "mad" to "Madurese",
    "maf" to "Mafa",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Makasar",
    "man" to "Mandingo",
    "mas" to "Masai",
    "mde" to "Maba",
    "mdf" to "Moksha",
    "mdr" to "Mandar",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisyen",
    "mg" to "Malagasy",
    "mga" to "Middle Irish",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Metaʼ",
    "mh" to "Marshallese",
    "mi" to "Māori",
    "mic" to "Mi'kmaw",
    "min" to "Minangkabau",
    "mk" to "Macedonian",
    "ml" to "Malayalam",
    "mn" to "Mongolian",
    "mnc" to "Manchu",
    "mni" to "Manipuri",
    "moe" to "Innu-aimun",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Marathi",
    "mrj" to "Western Mari",
    "ms" to "Malay",
    "mt" to "Maltese",
    "mua" to "Mundang",
    "mul" to "Multiple languages",
    "mus" to "Muscogee",
    "mus-alt-official" to "Mvskoke",
    "mwl" to "Mirandese",
    "mwr" to "Marwari",
    "mwv" to "Mentawai",
    "my" to "Burmese",
    "my-alt-variant" to "Myanmar Language",
    "mye" to "Myene",
    "myv" to "Erzya",
    "mzn" to "Mazanderani",
    "na" to "Nauru",
    "nan" to "Min Nan Chinese",
    "nap" to "Neapolitan",
    "naq" to "Nama",
    "nb" to "Norwegian Bokmål",
    "nd" to "North Ndebele",
    "nds" to "Low German",
    "nds-NL" to "Low Saxon",
    "ne" to "Nepali",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niuean",
    "njo" to "Ao Naga",
    "nl" to "Dutch",
    "nl-BE" to "Flemish",
    "nmg" to "Kwasio",
    "nn" to "Norwegian Nynorsk",
    "nnh" to "Ngiemboon",
    "no" to "Norwegian",
    "nog" to "Nogai",
    "non" to "Old Norse",
    "nov" to "Novial",
    "nqo" to "N’Ko",
    "nr" to "South Ndebele",
    "nso" to "Northern Sotho",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "nwc" to "Classical Newari",
    "ny" to "Nyanja",
    "nym" to "Nyamwezi",
    "nyn" to "Nyankole",
    "nyo" to "Nyoro",
    "nzi" to "Nzima",
    "oc" to "Occitan",
    "oj" to "Ojibwa",
    "ojb" to "Northwestern Ojibwa",
    "ojc" to "Central Ojibwa",
    "ojg" to "Eastern Ojibwa",
    "ojs" to "Oji-Cree",
    "ojw" to "Western Ojibwa",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Odia",
    "os" to "Ossetic",
    "osa" to "Osage",
    "ota" to "Ottoman Turkish",
    "pa" to "Punjabi",
    "pag" to "Pangasinan",
    "pal" to "Pahlavi",
    "pam" to "Pampanga",
    "pap" to "Papiamento",
    "pau" to "Palauan",
    "pcd" to "Picard",
    "pcm" to "Nigerian Pidgin",
    "pdc" to "Pennsylvania German",
    "pdt" to "Plautdietsch",
    "peo" to "Old Persian",
    "pfl" to "Palatine German",
    "phn" to "Phoenician",
    "pi" to "Pali",
    "pis" to "Pijin",
    "pl" to "Polish",
    "pms" to "Piedmontese",
    "pnt" to "Pontic",
    "pon" to "Pohnpeian",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Prussian",
    "pro" to "Old Provençal",
    "ps" to "Pashto",
    "ps-alt-variant" to "Pushto",
    "pt" to "Portuguese",
    "pt-BR" to "Brazilian Portuguese",
    "pt-PT" to "European Portuguese",
    "qu" to "Quechua",
    "quc" to "Kʼicheʼ",
    "qug" to "Chimborazo Highland Quichua",
    "raj" to "Rajasthani",
    "rap" to "Rapanui",
    "rar" to "Rarotongan",
    "rgn" to "Romagnol",
    "rhg" to "Rohingya",
    "rif" to "Riffian",
    "rm" to "Romansh",
    "rn" to "Rundi",
    "ro" to "Romanian",
    "ro-MD" to "Moldavian",
    "rof" to "Rombo",
    "rom" to "Romany",
    "rtm" to "Rotuman",
    "ru" to "Russian",
    "rue" to "Rusyn",
    "rug" to "Roviana",
    "rup" to "Aromanian",
    "rw" to "Kinyarwanda",
    "rwk" to "Rwa",
    "sa" to "Sanskrit",
    "sad" to "Sandawe",
    "sah" to "Yakut",
    "sam" to "Samaritan Aramaic",
    "saq" to "Samburu",
    "sas" to "Sasak",
    "sat" to "Santali",
    "saz" to "Saurashtra",
    "sba" to "Ngambay",
    "sbp" to "Sangu",
    "sc" to "Sardinian",
    "scn" to "Sicilian",
    "sco" to "Scots",
    "sd" to "Sindhi",
    "sdc" to "Sassarese Sardinian",
    "sdh" to "Southern Kurdish",
    "se" to "Northern Sami",
    "se-alt-menu" to "Sami, Northern",
    "see" to "Seneca",
    "seh" to "Sena",
    "sei" to "Seri",
    "sel" to "Selkup",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "sga" to "Old Irish",
    "sgs" to "Samogitian",
    "sh" to "Serbo-Croatian",
    "shi" to "Tachelhit",
    "shn" to "Shan",
    "shu" to "Chadian Arabic",
    "si" to "Sinhala",
    "sid" to "Sidamo",
    "sk" to "Slovak",
    "sl" to "Slovenian",
    "slh" to "Southern Lushootseed",
    "sli" to "Lower Silesian",
    "sly" to "Selayar",
    "sm" to "Samoan",
    "sma" to "Southern Sami",
    "sma-alt-menu" to "Sami, Southern",
    "smj" to "Lule Sami",
    "smj-alt-menu" to "Sami, Lule",
    "smn" to "Inari Sami",
    "smn-alt-menu" to "Sami, Inari",
    "sms" to "Skolt Sami",
    "sms-alt-menu" to "Sami, Skolt",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somali",
    "sog" to "Sogdien",
    "sq" to "Albanian",
    "sr" to "Serbian",
    "sr-ME" to "Montenegrin",
    "srn" to "Sranan Tongo",
    "srr" to "Serer",
    "ss" to "Swati",
    "ssy" to "Saho",
    "st" to "Southern Sotho",
    "stq" to "Saterland Frisian",
    "str" to "Straits Salish",
    "su" to "Sundanese",
    "suk" to "Sukuma",
    "sus" to "Susu",
    "sux" to "Sumerian",
    "sv" to "Swedish",
    "sw" to "Swahili",
    "sw-CD" to "Congo Swahili",
    "swb" to "Comorian",
    "syc" to "Classical Syriac",
    "syr" to "Syriac",
    "szl" to "Silesian",
    "ta" to "Tamil",
    "tce" to "Southern Tutchone",
    "tcy" to "Tulu",
    "te" to "Telugu",
    "tem" to "Timne",
    "teo" to "Teso",
    "ter" to "Tereno",
    "tet" to "Tetum",
    "tg" to "Tajik",
    "tgx" to "Tagish",
    "th" to "Thai",
    "tht" to "Tahltan",
    "ti" to "Tigrinya",
    "tig" to "Tigre",
    "tiv" to "Tiv",
    "tk" to "Turkmen",
    "tkl" to "Tokelau",
    "tkr" to "Tsakhur",
    "tl" to "Tagalog",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tly" to "Talysh",
    "tmh" to "Tamashek",
    "tn" to "Tswana",
    "to" to "Tongan",
    "tog" to "Nyasa Tonga",
    "tok" to "Toki Pona",
    "tpi" to "Tok Pisin",
    "tr" to "Turkish",
    "tru" to "Turoyo",
    "trv" to "Taroko",
    "trw" to "Torwali",
    "ts" to "Tsonga",
    "tsd" to "Tsakonian",
    "tsi" to "Tsimshian",
    "tt" to "Tatar",
    "ttm" to "Northern Tutchone",
    "ttt" to "Muslim Tat",
    "tum" to "Tumbuka",
    "tvl" to "Tuvalu",
    "tw" to "Twi",
    "twq" to "Tasawaq",
    "ty" to "Tahitian",
    "tyv" to "Tuvinian",
    "tzm" to "Central Atlas Tamazight",
    "udm" to "Udmurt",
    "ug" to "Uyghur",
    "ug-alt-variant" to "Uighur",
    "uga" to "Ugaritic",
    "uk" to "Ukrainian",
    "umb" to "Umbundu",
    "und" to "Unknown language",
    "ur" to "Urdu",
    "uz" to "Uzbek",
    "vai" to "Vai",
    "ve" to "Venda",
    "vec" to "Venetian",
    "vep" to "Veps",
    "vi" to "Vietnamese",
    "vls" to "West Flemish",
    "vmf" to "Main-Franconian",
    "vmw" to "Makhuwa",
    "vo" to "Volapük",
    "vot" to "Votic",
    "vro" to "Võro",
    "vun" to "Vunjo",
    "wa" to "Walloon",
    "wae" to "Walser",
    "wal" to "Wolaytta",
    "war" to "Waray",
    "was" to "Washo",
    "wbp" to "Warlpiri",
    "wo" to "Wolof",
    "wuu" to "Wu Chinese",
    "xal" to "Kalmyk",
    "xh" to "Xhosa",
    "xmf" to "Mingrelian",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yao" to "Yao",
    "yap" to "Yapese",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Yiddish",
    "yo" to "Yoruba",
    "yrl" to "Nheengatu",
    "yue" to "Cantonese",
    "yue-alt-menu" to "Chinese, Cantonese",
    "za" to "Zhuang",
    "zap" to "Zapotec",
    "zbl" to "Blissymbols",
    "zea" to "Zeelandic",
    "zen" to "Zenaga",
    "zgh" to "Standard Moroccan Tamazight",
    "zh" to "Chinese",
    "zh-alt-long" to "Mandarin Chinese",
    "zh-alt-menu" to "Chinese, Mandarin",
    "zh-Hans" to "Simplified Chinese",
    "zh-Hans-alt-long" to "Simplified Mandarin Chinese",
    "zh-Hant" to "Traditional Chinese",
    "zh-Hant-alt-long" to "Traditional Mandarin Chinese",
    "zu" to "Zulu",
    "zun" to "Zuni",
    "zxx" to "No linguistic content",
    "zza" to "Zaza",
  ) }

  val en_001: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_150: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_AE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_AG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_AI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_AS: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_AT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_AU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "bn" to "Bengali",
    "ckb-alt-menu" to "Kurdish (Central)",
    "ckb-alt-variant" to "Kurdish (Sorani)",
    "en-US" to "United States English",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
    "ro-MD" to "Moldovan",
  ) }

  val en_BB: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_BE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_BI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_BM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_BS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_BW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_BZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_CA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar-001" to "Arabic (Modern Standard)",
    "bn" to "Bengali",
    "mfe" to "Mauritian Creole",
    "my-alt-variant" to "Myanmar language",
    "nds-NL" to "West Low German",
    "ro-MD" to "Moldovan",
  ) }

  val en_CC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_CK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_CX: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_CY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_DE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_DG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_DK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_DM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_Dsrt: ImmutableMap<String, String> by lazy { immutableMapOf(
    "an" to "𐐈𐑉𐐲𐑀𐐱𐑌𐐨𐑆",
    "ar" to "𐐇𐑉𐐲𐐺𐐮𐐿",
    "br" to "𐐒𐑉𐐯𐐻𐐲𐑌",
    "byn" to "𐐒𐑊𐐮𐑌",
    "ca" to "𐐗𐐪𐐻𐐲𐑊𐐪𐑌",
    "chr" to "𐐕𐐯𐑉𐐬𐐿𐐨",
    "chy" to "𐐟𐐴𐐰𐑌",
    "co" to "𐐗𐐬𐑉𐑅𐐮𐐿𐐲𐑌",
    "cop" to "𐐗𐐬𐐹𐐻𐐮𐐿",
    "cr" to "𐐗𐑉𐐨",
    "cs" to "𐐕𐐯𐐿",
    "cy" to "𐐎𐐯𐑊𐑇",
    "da" to "𐐔𐐩𐑌𐐮𐑇",
    "dak" to "𐐔𐐲𐐿𐐬𐐻𐐲",
    "de" to "𐐖𐐲𐑉𐑋𐑌𐐲",
    "dsb" to "𐐢𐐬𐐲𐑉 𐐝𐐬𐑉𐐺𐐨𐐲𐑌",
    "dum" to "𐐣𐐮𐐼𐐲𐑊 𐐔𐐲𐐽",
    "egy" to "𐐁𐑌𐐽𐐲𐑌𐐻 𐐀𐐾𐐮𐐹𐐽𐐲𐑌",
    "el" to "𐐘𐑉𐐨𐐿",
    "en" to "𐐀𐑍𐑊𐐮𐑇",
    "enm" to "𐐣𐐮𐐼𐐲𐑊 𐐀𐑍𐑊𐐮𐑇",
    "eo" to "𐐇𐑅𐐹𐐯𐑉𐐪𐑌𐐻𐐬",
    "es" to "𐐝𐐹𐐰𐑌𐐮𐑇",
    "et" to "𐐀𐑅𐐻𐐬𐑌𐐨𐐲𐑌",
    "eu" to "𐐒𐐰𐑅𐐿",
    "fr" to "𐐙𐑉𐐯𐑌𐐽",
    "frm" to "𐐣𐐮𐐼𐐲𐑊 𐐙𐑉𐐯𐑌𐐽",
    "ga" to "𐐌𐑉𐐮𐑇",
    "gil" to "𐐘𐐮𐑊𐐺𐐯𐑉𐐻𐐨𐑆",
    "gmh" to "𐐣𐐮𐐼𐐲𐑊 𐐐𐐴 𐐖𐐲𐑉𐑋𐐲𐑌",
    "got" to "𐐘𐐱𐑃𐐮𐐿",
    "grc" to "𐐁𐑌𐐽𐐲𐑌𐐻 𐐘𐑉𐐨𐐿",
    "gv" to "𐐣𐐰𐑌𐐿𐑅",
    "haw" to "𐐐𐐲𐐶𐐴𐐲𐑌",
    "hi" to "𐐐𐐮𐑌𐐼𐐨",
    "hit" to "𐐐𐐮𐐻𐐴𐐻",
    "hr" to "𐐗𐑉𐐬𐐩𐑇𐐲𐑌",
    "ht" to "𐐐𐐩𐑇𐐲𐑌",
    "hy" to "𐐂𐑉𐑋𐐨𐑌𐐨𐐲𐑌",
    "ia" to "𐐆𐑌𐐻𐐲𐑉𐑊𐐮𐑍𐐶𐐲",
    "id" to "𐐆𐑌𐐼𐐬𐑌𐐨𐑈𐐲𐑌",
    "is" to "𐐌𐑅𐑊𐐰𐑌𐐼𐐮𐐿",
    "it" to "𐐆𐐻𐐰𐑊𐐷𐐲𐑌",
    "ja" to "𐐖𐐰𐐹𐐲𐑌𐐨𐑆",
    "jpr" to "𐐖𐐭𐐼𐐨𐐬-𐐑𐐯𐑉𐑈𐐲𐑌",
    "jrb" to "𐐖𐐭𐐼𐐨𐐬-𐐈𐑉𐐲𐐺𐐮𐐿",
    "jv" to "𐐖𐐪𐑂𐐲𐑌𐐨𐑆",
    "ka" to "𐐖𐐬𐑉𐐾𐐲𐑌",
    "km" to "𐐗𐐲𐑋𐐯𐑉",
    "ko" to "𐐗𐐬𐑉𐐨𐐲𐑌",
    "ku" to "𐐗𐐲𐑉𐐼𐐮𐑇",
    "kut" to "𐐢𐐰𐐼𐐨𐑌𐐬",
    "kw" to "𐐗𐐬𐑉𐑌𐐮𐑇",
    "la" to "𐐢𐐰𐐻𐐮𐑌",
    "lb" to "𐐢𐐲𐐿𐑅𐐯𐑋𐐺𐐲𐑉𐑀𐐮𐑇",
    "lo" to "𐐢𐐵",
    "lv" to "𐐢𐐰𐐻𐑂𐐨𐐲𐑌",
    "mga" to "𐐣𐐮𐐼𐐲𐑊 𐐌𐑉𐐮𐑇",
    "mi" to "𐐣𐐵𐑉𐐨",
    "mk" to "𐐣𐐰𐑅𐐯𐐼𐐬𐑌𐐨𐐲𐑌",
    "mn" to "𐐣𐐱𐑍𐐬𐑊𐐨𐐲𐑌",
    "mnc" to "𐐣𐐰𐑌𐐽𐐭",
    "moh" to "𐐐𐐬𐐸𐐪𐐿",
    "mul" to "𐐣𐐲𐑊𐐻𐐮𐐹𐐲𐑊 𐐢𐐩𐑍𐐶𐐮𐐾𐐲𐑆",
    "mus" to "𐐗𐑉𐐨𐐿",
    "my" to "𐐒𐐲𐑉𐑋𐐨𐑆",
    "nap" to "𐐤𐐨𐐲𐐹𐐱𐑊𐐮𐐻𐐲𐑌",
    "nds" to "𐐢𐐬 𐐖𐐯𐑉𐑋𐐲𐑌",
    "nl" to "𐐔𐐲𐐽",
    "nv" to "𐐤𐐪𐑂𐐲𐐸𐐬",
    "ro-MD" to "𐐣𐐬𐑊𐐼𐐩𐑂𐐨𐐲𐑌",
    "tlh" to "𐐗𐑊𐐮𐑍𐐱𐑌",
    "zbl" to "𐐒𐑊𐐮𐑅-𐑅𐐮𐑋𐐺𐐲𐑊𐑆",
    "zh" to "𐐕𐐴𐑌𐐨𐑆",
    "zh-alt-menu" to "𐐕𐐴𐑌𐐨𐑆",
    "zxx" to "𐐤𐐬 𐑊𐐨𐑍𐐶𐐮𐑅𐐻𐐮𐐿 𐐿𐐱𐑌𐐻𐐯𐑌𐐻",
  ) }

  val en_ER: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_FI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_FJ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_FK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_FM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_GB: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "ff" to "Fulah",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_GD: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_GG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_GI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_GM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_GU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_GY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_HK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_ID: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_IE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_IL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_IM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_IN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "bn" to "Bengali",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_IO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_JE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_JM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_KE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_KI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_KN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_KY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_LC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_LR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_LS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_MG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_MH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_MO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_MP: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_MS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_MT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_MU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_MV: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_MW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_MY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_NA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_NF: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_NG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_NL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_NR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_NU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_NZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_PG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_PH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_PK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_PN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_PR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_PW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_RW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SB: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SD: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SX: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_SZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_TC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_TK: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_TO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_TT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_TV: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_TZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_UG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_UM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_VC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_VG: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_VI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val en_VU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_WS: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_ZA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_ZM: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val en_ZW: ImmutableMap<String, String> by lazy { immutableMapOf(
    "bla" to "Siksika",
    "mus" to "Creek",
    "nds-NL" to "West Low German",
  ) }

  val eo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afara",
    "ab" to "abĥaza",
    "af" to "afrikansa",
    "am" to "amhara",
    "ar" to "araba",
    "as" to "asama",
    "ay" to "ajmara",
    "az" to "azerbajĝana",
    "az-alt-short" to "azerbajĝana",
    "ba" to "baŝkira",
    "be" to "belorusa",
    "bg" to "bulgara",
    "bi" to "bislamo",
    "bn" to "bengala",
    "bo" to "tibeta",
    "br" to "bretona",
    "bs" to "bosna",
    "ca" to "kataluna",
    "co" to "korsika",
    "cs" to "ĉeĥa",
    "cy" to "kimra",
    "da" to "dana",
    "de" to "germana",
    "dv" to "maldiva",
    "dz" to "dzonko",
    "efi" to "ibibioefika",
    "el" to "greka",
    "en" to "angla",
    "eo" to "Esperanto",
    "es" to "hispana",
    "et" to "estona",
    "eu" to "eŭska",
    "fa" to "persa",
    "fi" to "finna",
    "fil" to "filipina",
    "fj" to "fiĝia",
    "fo" to "feroa",
    "fr" to "franca",
    "fy" to "okcident-frisa",
    "ga" to "irlanda",
    "gaa" to "gaa",
    "gd" to "skot-gaela",
    "gl" to "galega",
    "gn" to "gvarania",
    "gu" to "guĝarata",
    "ha" to "haŭsa",
    "haw" to "havaja",
    "he" to "hebrea",
    "hi" to "hinda",
    "hr" to "kroata",
    "ht" to "haitia kreola",
    "hu" to "hungara",
    "hy" to "armena",
    "ia" to "Interlingvao",
    "id" to "indonezia",
    "ie" to "Interlingveo",
    "ik" to "eskima",
    "is" to "islanda",
    "it" to "itala",
    "iu" to "inuita",
    "ja" to "japana",
    "jv" to "java",
    "ka" to "kartvela",
    "kk" to "kazaĥa",
    "kl" to "gronlanda",
    "km" to "kmera",
    "kn" to "kanara",
    "ko" to "korea",
    "ks" to "kaŝmira",
    "ku" to "kurda",
    "ky" to "kirgiza",
    "la" to "latino",
    "lb" to "luksemburga",
    "ln" to "lingala",
    "lo" to "laŭa",
    "lt" to "litova",
    "lv" to "latva",
    "mg" to "malagasa",
    "mi" to "maoria",
    "mk" to "makedona",
    "ml" to "malajalama",
    "mn" to "mongola",
    "mr" to "marata",
    "ms" to "malaja",
    "mt" to "malta",
    "my" to "birma",
    "na" to "naura",
    "nb" to "dannorvega",
    "ne" to "nepala",
    "nl" to "nederlanda",
    "nn" to "novnorvega",
    "no" to "norvega",
    "oc" to "okcitana",
    "om" to "oroma",
    "or" to "orijo",
    "pa" to "panĝaba",
    "pl" to "pola",
    "ps" to "paŝtua",
    "pt" to "portugala",
    "pt-BR" to "portugala brazila",
    "pt-PT" to "portugala eŭropa",
    "qu" to "keĉua",
    "rm" to "romanĉa",
    "rn" to "burunda",
    "ro" to "rumana",
    "ru" to "rusa",
    "rw" to "ruanda",
    "sa" to "sanskrito",
    "sd" to "sinda",
    "sg" to "sangoa",
    "sh" to "serbo-Kroata",
    "si" to "sinhala",
    "sk" to "slovaka",
    "sl" to "slovena",
    "sm" to "samoa",
    "sn" to "ŝona",
    "so" to "somala",
    "sq" to "albana",
    "sr" to "serba",
    "ss" to "svazia",
    "st" to "sota",
    "su" to "sunda",
    "sv" to "sveda",
    "sw" to "svahila",
    "ta" to "tamila",
    "te" to "telugua",
    "tg" to "taĝika",
    "th" to "taja",
    "ti" to "tigraja",
    "tk" to "turkmena",
    "tl" to "tagaloga",
    "tlh" to "klingona",
    "tn" to "cvana",
    "to" to "tongana",
    "tr" to "turka",
    "ts" to "conga",
    "tt" to "tatara",
    "ug" to "ujgura",
    "uk" to "ukraina",
    "und" to "nekonata lingvo",
    "ur" to "urduo",
    "uz" to "uzbeka",
    "vi" to "vjetnama",
    "vo" to "Volapuko",
    "wo" to "volofa",
    "xh" to "ksosa",
    "yi" to "jida",
    "yo" to "joruba",
    "za" to "ĝuanga",
    "zh" to "ĉina",
    "zh-alt-menu" to "ĉina",
    "zh-Hans" to "ĉina simpligita",
    "zh-Hans-alt-long" to "ĉina simpligita",
    "zh-Hant" to "ĉina tradicia",
    "zh-Hant-alt-long" to "ĉina tradicia",
    "zu" to "zulua",
    "zxx" to "nelingvaĵo",
  ) }

  val es: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abjasio",
    "ace" to "achenés",
    "ach" to "acoli",
    "ada" to "adangme",
    "ady" to "adigué",
    "ae" to "avéstico",
    "af" to "afrikáans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "akan",
    "akk" to "acadio",
    "ale" to "aleutiano",
    "alt" to "altái meridional",
    "am" to "amárico",
    "an" to "aragonés",
    "ang" to "inglés antiguo",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "árabe",
    "ar-001" to "árabe estándar moderno",
    "arc" to "arameo",
    "arn" to "mapuche",
    "arp" to "arapaho",
    "ars" to "árabe najdí",
    "arw" to "arahuaco",
    "as" to "asamés",
    "asa" to "asu",
    "ast" to "asturiano",
    "atj" to "atikamekw",
    "av" to "avar",
    "awa" to "avadhi",
    "ay" to "aimara",
    "az" to "azerbaiyano",
    "az-alt-short" to "azerí",
    "ba" to "baskir",
    "bal" to "baluchi",
    "ban" to "balinés",
    "bas" to "basaa",
    "bax" to "bamún",
    "bbj" to "ghomala",
    "be" to "bielorruso",
    "bej" to "beja",
    "bem" to "bemba",
    "bez" to "bena",
    "bfd" to "bafut",
    "bg" to "búlgaro",
    "bgc" to "haryanvi",
    "bgn" to "baluchi occidental",
    "bho" to "bhoyapurí",
    "bi" to "bislama",
    "bik" to "bicol",
    "bin" to "bini",
    "bkm" to "kom",
    "bla" to "siksika",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bengalí",
    "bo" to "tibetano",
    "br" to "bretón",
    "bra" to "braj",
    "brx" to "bodo",
    "bs" to "bosnio",
    "bss" to "akoose",
    "bua" to "buriato",
    "bug" to "buginés",
    "bum" to "bulu",
    "byn" to "blin",
    "byv" to "medumba",
    "ca" to "catalán",
    "cad" to "caddo",
    "car" to "caribe",
    "cay" to "cayuga",
    "cch" to "atsam",
    "ccp" to "chakma",
    "ce" to "checheno",
    "ceb" to "cebuano",
    "cgg" to "chiga",
    "ch" to "chamorro",
    "chb" to "chibcha",
    "chg" to "chagatái",
    "chk" to "trukés",
    "chm" to "marí",
    "chn" to "jerga chinuk",
    "cho" to "choctaw",
    "chp" to "chipewyan",
    "chr" to "cheroqui",
    "chy" to "cheyene",
    "ckb" to "kurdo sorani",
    "ckb-alt-menu" to "kurdo sorani",
    "ckb-alt-variant" to "kurdo central",
    "clc" to "chilcotin",
    "co" to "corso",
    "cop" to "copto",
    "cr" to "cree",
    "crg" to "michif",
    "crh" to "tártaro de Crimea",
    "crj" to "cree suroriental",
    "crk" to "cree de las llanuras",
    "crl" to "cree nororiental",
    "crm" to "cree moose",
    "crr" to "algonquino de Carolina",
    "crs" to "criollo seychelense",
    "cs" to "checo",
    "csb" to "casubio",
    "csw" to "cree de los pantanos",
    "cu" to "eslavo eclesiástico",
    "cv" to "chuvasio",
    "cy" to "galés",
    "da" to "danés",
    "dak" to "dakota",
    "dar" to "dargva",
    "dav" to "taita",
    "de" to "alemán",
    "de-AT" to "alemán austríaco",
    "de-CH" to "alto alemán suizo",
    "del" to "delaware",
    "den" to "slave",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "bajo sorbio",
    "dua" to "duala",
    "dum" to "neerlandés medio",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dyu" to "diula",
    "dz" to "dzongkha",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "ewé",
    "efi" to "efik",
    "egy" to "egipcio antiguo",
    "eka" to "ekajuk",
    "el" to "griego",
    "elx" to "elamita",
    "en" to "inglés",
    "en-AU" to "inglés australiano",
    "en-CA" to "inglés canadiense",
    "en-GB" to "inglés británico",
    "en-GB-alt-short" to "inglés (RU)",
    "en-US" to "inglés estadounidense",
    "en-US-alt-short" to "inglés (EE. UU.)",
    "enm" to "inglés medio",
    "eo" to "esperanto",
    "es" to "español",
    "es-419" to "español latinoamericano",
    "es-ES" to "español de España",
    "es-MX" to "español de México",
    "et" to "estonio",
    "eu" to "euskera",
    "ewo" to "ewondo",
    "fa" to "persa",
    "fa-AF" to "darí",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fula",
    "fi" to "finés",
    "fil" to "filipino",
    "fj" to "fiyiano",
    "fo" to "feroés",
    "fon" to "fon",
    "fr" to "francés",
    "fr-CA" to "francés canadiense",
    "fr-CH" to "francés suizo",
    "frc" to "francés cajún",
    "frm" to "francés medio",
    "fro" to "francés antiguo",
    "frr" to "frisón septentrional",
    "frs" to "frisón oriental",
    "fur" to "friulano",
    "fy" to "frisón occidental",
    "ga" to "irlandés",
    "gaa" to "ga",
    "gag" to "gagauzo",
    "gan" to "chino gan",
    "gay" to "gayo",
    "gba" to "gbaya",
    "gd" to "gaélico escocés",
    "gez" to "geez",
    "gil" to "gilbertés",
    "gl" to "gallego",
    "gmh" to "alto alemán medio",
    "gn" to "guaraní",
    "goh" to "alto alemán antiguo",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gótico",
    "grb" to "grebo",
    "grc" to "griego antiguo",
    "gsw" to "alemán suizo",
    "gu" to "guyaratí",
    "guz" to "gusii",
    "gv" to "manés",
    "gwi" to "kutchin",
    "ha" to "hausa",
    "hai" to "haida",
    "hak" to "chino hakka",
    "haw" to "hawaiano",
    "hax" to "haida meridional",
    "he" to "hebreo",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hinglish",
    "hil" to "hiligaynon",
    "hit" to "hitita",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "croata",
    "hsb" to "alto sorbio",
    "hsn" to "chino xiang",
    "ht" to "criollo haitiano",
    "hu" to "húngaro",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armenio",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonesio",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "yi de Sichuán",
    "ik" to "inupiaq",
    "ikt" to "inuit del oeste de Canadá",
    "ilo" to "ilocano",
    "inh" to "ingush",
    "io" to "ido",
    "is" to "islandés",
    "it" to "italiano",
    "iu" to "inuktitut",
    "ja" to "japonés",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jpr" to "judeo-persa",
    "jrb" to "judeo-árabe",
    "jv" to "javanés",
    "ka" to "georgiano",
    "kaa" to "karakalpako",
    "kab" to "cabileño",
    "kac" to "kachin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kawi",
    "kbd" to "kabardiano",
    "kbl" to "kanembu",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "criollo caboverdiano",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "káingang",
    "kha" to "khasi",
    "kho" to "kotanés",
    "khq" to "koyra chiini",
    "ki" to "kikuyu",
    "kj" to "kuanyama",
    "kk" to "kazajo",
    "kkj" to "kako",
    "kl" to "groenlandés",
    "kln" to "kalenjin",
    "km" to "jemer",
    "kmb" to "kimbundu",
    "kn" to "canarés",
    "ko" to "coreano",
    "koi" to "komi permio",
    "kok" to "konkaní",
    "kos" to "kosraeano",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karachay-balkar",
    "krl" to "carelio",
    "kru" to "kurukh",
    "ks" to "cachemir",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "kölsch",
    "ku" to "kurdo",
    "kum" to "kumyk",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "córnico",
    "kwk" to "kwakʼwala",
    "kxv" to "kuvi",
    "ky" to "kirguís",
    "la" to "latín",
    "lad" to "ladino",
    "lag" to "langi",
    "lah" to "lahnda",
    "lam" to "lamba",
    "lb" to "luxemburgués",
    "lez" to "lezgiano",
    "lg" to "ganda",
    "li" to "limburgués",
    "lij" to "ligur",
    "lil" to "lillooet",
    "lkt" to "lakota",
    "lmo" to "lombardo",
    "ln" to "lingala",
    "lo" to "lao",
    "lol" to "mongo",
    "lou" to "criollo de Luisiana",
    "loz" to "lozi",
    "lrc" to "lorí septentrional",
    "lsm" to "samia",
    "lt" to "lituano",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lui" to "luiseño",
    "lun" to "lunda",
    "lus" to "mizo",
    "luy" to "luyia",
    "lv" to "letón",
    "mad" to "madurés",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "macasar",
    "man" to "mandingo",
    "mas" to "masái",
    "mde" to "maba",
    "mdf" to "moksha",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "criollo mauriciano",
    "mg" to "malgache",
    "mga" to "irlandés medio",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta’",
    "mh" to "marshalés",
    "mi" to "maorí",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "macedonio",
    "ml" to "malayálam",
    "mn" to "mongol",
    "mnc" to "manchú",
    "mni" to "manipurí",
    "moe" to "innu-aimun",
    "moh" to "mohawk",
    "mos" to "mossi",
    "mr" to "maratí",
    "ms" to "malayo",
    "mt" to "maltés",
    "mua" to "mundang",
    "mul" to "varios idiomas",
    "mus" to "creek",
    "mwl" to "mirandés",
    "mwr" to "marwari",
    "my" to "birmano",
    "mye" to "myene",
    "myv" to "erzya",
    "mzn" to "mazandaraní",
    "na" to "nauruano",
    "nan" to "chino min nan",
    "nap" to "napolitano",
    "naq" to "nama",
    "nb" to "noruego bokmal",
    "nd" to "ndebele septentrional",
    "nds" to "bajo alemán",
    "nds-NL" to "bajo sajón",
    "ne" to "nepalí",
    "new" to "nevarí",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niueano",
    "nl" to "neerlandés",
    "nl-BE" to "flamenco",
    "nmg" to "kwasio",
    "nn" to "noruego nynorsk",
    "nnh" to "ngiemboon",
    "no" to "noruego",
    "nog" to "nogai",
    "non" to "nórdico antiguo",
    "nqo" to "n’ko",
    "nr" to "ndebele meridional",
    "nso" to "sotho septentrional",
    "nus" to "nuer",
    "nv" to "navajo",
    "nwc" to "newari clásico",
    "ny" to "nyanja",
    "nym" to "nyamwezi",
    "nyn" to "nyankole",
    "nyo" to "nyoro",
    "nzi" to "nzima",
    "oc" to "occitano",
    "oj" to "ojibwa",
    "ojb" to "ojibwa noroccidental",
    "ojc" to "ojibwa central",
    "ojs" to "oji-cree",
    "ojw" to "ojibwa occidental",
    "oka" to "okanagan",
    "om" to "oromo",
    "or" to "oriya",
    "os" to "osético",
    "osa" to "osage",
    "ota" to "turco otomano",
    "pa" to "punyabí",
    "pag" to "pangasinán",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palauano",
    "pcm" to "pidgin de Nigeria",
    "peo" to "persa antiguo",
    "phn" to "fenicio",
    "pi" to "pali",
    "pis" to "pidgin salomonense",
    "pl" to "polaco",
    "pon" to "pohnpeiano",
    "pqm" to "maliseet-passamaquoddy",
    "prg" to "prusiano",
    "pro" to "provenzal antiguo",
    "ps" to "pastún",
    "ps-alt-variant" to "pastú",
    "pt" to "portugués",
    "pt-BR" to "portugués de Brasil",
    "pt-PT" to "portugués de Portugal",
    "qu" to "quechua",
    "quc" to "quiché",
    "raj" to "rajasthani",
    "rap" to "rapanui",
    "rar" to "rarotongano",
    "rhg" to "rohinyá",
    "rm" to "romanche",
    "rn" to "kirundi",
    "ro" to "rumano",
    "ro-MD" to "moldavo",
    "rof" to "rombo",
    "rom" to "romaní",
    "ru" to "ruso",
    "rup" to "arrumano",
    "rw" to "kinyarwanda",
    "rwk" to "rwa",
    "sa" to "sánscrito",
    "sad" to "sandawe",
    "sah" to "sakha",
    "sam" to "arameo samaritano",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sardo",
    "scn" to "siciliano",
    "sco" to "escocés",
    "sd" to "sindi",
    "sdh" to "kurdo meridional",
    "se" to "sami septentrional",
    "see" to "seneca",
    "seh" to "sena",
    "sel" to "selkup",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sga" to "irlandés antiguo",
    "sh" to "serbocroata",
    "shi" to "tashelhit",
    "shn" to "shan",
    "shu" to "árabe chadiano",
    "si" to "cingalés",
    "sid" to "sidamo",
    "sk" to "eslovaco",
    "sl" to "esloveno",
    "slh" to "lushootseed meridional",
    "sm" to "samoano",
    "sma" to "sami meridional",
    "smj" to "sami lule",
    "smn" to "sami inari",
    "sms" to "sami skolt",
    "sn" to "shona",
    "snk" to "soninké",
    "so" to "somalí",
    "sog" to "sogdiano",
    "sq" to "albanés",
    "sr" to "serbio",
    "srn" to "sranan tongo",
    "srr" to "serer",
    "ss" to "suazi",
    "ssy" to "saho",
    "st" to "sotho meridional",
    "str" to "salish de los estrechos",
    "su" to "sundanés",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumerio",
    "sv" to "sueco",
    "sw" to "suajili",
    "sw-CD" to "suajili del Congo",
    "swb" to "comorense",
    "syc" to "siríaco clásico",
    "syr" to "siriaco",
    "szl" to "silesio",
    "ta" to "tamil",
    "tce" to "tutchone meridional",
    "te" to "telugu",
    "tem" to "temne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetún",
    "tg" to "tayiko",
    "tgx" to "tagish",
    "th" to "tailandés",
    "tht" to "tahltan",
    "ti" to "tigriña",
    "tig" to "tigré",
    "tiv" to "tiv",
    "tk" to "turcomano",
    "tkl" to "tokelauano",
    "tl" to "tagalo",
    "tlh" to "klingon",
    "tli" to "tlingit",
    "tmh" to "tamashek",
    "tn" to "setsuana",
    "to" to "tongano",
    "tog" to "tonga del Nyasa",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turco",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsi" to "tsimshiano",
    "tt" to "tártaro",
    "ttm" to "tutchone septentrional",
    "tum" to "tumbuka",
    "tvl" to "tuvaluano",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitiano",
    "tyv" to "tuviniano",
    "tzm" to "tamazight del Atlas Central",
    "udm" to "udmurt",
    "ug" to "uigur",
    "ug-alt-variant" to "uygur",
    "uga" to "ugarítico",
    "uk" to "ucraniano",
    "umb" to "umbundu",
    "und" to "lengua desconocida",
    "ur" to "urdu",
    "uz" to "uzbeko",
    "ve" to "venda",
    "vec" to "veneciano",
    "vi" to "vietnamita",
    "vmw" to "makua",
    "vo" to "volapük",
    "vot" to "vótico",
    "vun" to "vunjo",
    "wa" to "valón",
    "wae" to "walser",
    "wal" to "wolayta",
    "war" to "waray",
    "was" to "washo",
    "wbp" to "warlpiri",
    "wo" to "wólof",
    "wuu" to "chino wu",
    "xal" to "kalmyk",
    "xh" to "xhosa",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "yao",
    "yap" to "yapés",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "yidis",
    "yo" to "yoruba",
    "yrl" to "ñe’engatú",
    "yue" to "cantonés",
    "yue-alt-menu" to "chino cantonés",
    "za" to "zhuang",
    "zap" to "zapoteco",
    "zbl" to "símbolos Bliss",
    "zen" to "zenaga",
    "zgh" to "tamazight estándar marroquí",
    "zh" to "chino",
    "zh-alt-menu" to "chino mandarín",
    "zh-Hans" to "chino simplificado",
    "zh-Hans-alt-long" to "chino mandarín simplificado",
    "zh-Hant" to "chino tradicional",
    "zh-Hant-alt-long" to "chino mandarín tradicional",
    "zu" to "zulú",
    "zun" to "zuñi",
    "zxx" to "sin contenido lingüístico",
    "zza" to "zazaki",
  ) }

  val es_419: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "arp" to "arapajó",
    "ars" to "árabe de Néyed",
    "bla" to "siksiká",
    "eu" to "vasco",
    "goh" to "alemán de la alta edad antigua",
    "grc" to "griego clásico",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "nso" to "sesotho del norte",
    "pa" to "panyabí",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "st" to "sesotho del sur",
    "sw" to "swahili",
    "sw-CD" to "swahili (Congo)",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zun" to "zuni",
  ) }

  val es_AR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_BO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_BR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "arp" to "arapajó",
    "ars" to "árabe de Néyed",
    "bla" to "siksiká",
    "eu" to "vasco",
    "goh" to "alemán de la alta edad antigua",
    "grc" to "griego clásico",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "nso" to "sesotho del norte",
    "pa" to "panyabí",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "st" to "sesotho del sur",
    "sw" to "swahili",
    "sw-CD" to "swahili (Congo)",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zun" to "zuni",
  ) }

  val es_BZ: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "arp" to "arapajó",
    "ars" to "árabe de Néyed",
    "bla" to "siksiká",
    "eu" to "vasco",
    "goh" to "alemán de la alta edad antigua",
    "grc" to "griego clásico",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "nso" to "sesotho del norte",
    "pa" to "panyabí",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "st" to "sesotho del sur",
    "sw" to "swahili",
    "sw-CD" to "swahili (Congo)",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zun" to "zuni",
  ) }

  val es_CL: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_CO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_CR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_CU: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "arp" to "arapajó",
    "ars" to "árabe de Néyed",
    "bla" to "siksiká",
    "eu" to "vasco",
    "goh" to "alemán de la alta edad antigua",
    "grc" to "griego clásico",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "nso" to "sesotho del norte",
    "pa" to "panyabí",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "st" to "sesotho del sur",
    "sw" to "swahili",
    "sw-CD" to "swahili (Congo)",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zun" to "zuni",
  ) }

  val es_DO: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_EA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_EC: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_GQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_GT: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_HN: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_IC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_MX: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "alt" to "altái del sur",
    "ars" to "árabe neyedí",
    "bas" to "basa",
    "bax" to "bamun",
    "bho" to "bhoshpuri",
    "bua" to "buriat",
    "ckb-alt-menu" to "kurdo del centro",
    "crj" to "cree del sureste",
    "crl" to "cree del noreste",
    "crr" to "carolina algonquian",
    "dar" to "darguin",
    "dum" to "neerlandés medieval",
    "en-GB-alt-short" to "inglés (R. U.)",
    "enm" to "inglés medieval",
    "frm" to "francés medieval",
    "gan" to "gan (China)",
    "gmh" to "alemán de la alta edad media",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "hak" to "kejia (China)",
    "hax" to "haida del sur",
    "hil" to "hiligainón",
    "hsn" to "xiang (China)",
    "ht" to "haitiano",
    "ikt" to "inuktitut del oeste de Canadá",
    "inh" to "ingusetio",
    "kgp" to "kaingang",
    "krc" to "karachái bálkaro",
    "ks" to "cachemiro",
    "kum" to "cumuco",
    "lij" to "genovés",
    "mga" to "irlandés medieval",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nan" to "min nan (Chino)",
    "ojb" to "ojibwa del noroeste",
    "ojw" to "ojibwa del oeste",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "slh" to "lushootseed del sur",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "tce" to "tutchone del sur",
    "tet" to "tetun",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uyghur",
    "vec" to "véneto",
    "wal" to "walamo",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_NI: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_PA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_PE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_PH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val es_PR: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "eu" to "vasco",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "pa" to "panyabí",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "sw" to "swahili",
    "sw-CD" to "swahili (Congo)",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zun" to "zuni",
  ) }

  val es_PY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val es_SV: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "eu" to "vasco",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "pa" to "panyabí",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "sw" to "swahili",
    "sw-CD" to "swahili (Congo)",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zun" to "zuni",
  ) }

  val es_US: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "ars" to "árabe najdi",
    "bax" to "bamun",
    "bgc" to "hariana",
    "bho" to "bhojpuri",
    "blo" to "ani",
    "bua" to "buriat",
    "clc" to "chilcotín",
    "crj" to "cree del sureste",
    "crl" to "cree del noreste",
    "crm" to "moose cree",
    "crr" to "algonquian",
    "dum" to "neerlandés medieval",
    "enm" to "inglés medieval",
    "frm" to "francés medieval",
    "gan" to "gan (China)",
    "gmh" to "alemán de la alta edad media",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gurayatí",
    "hax" to "haida del sur",
    "hil" to "hiligainón",
    "hsn" to "xiang (China)",
    "ikt" to "inuktitut del oeste de Canadá",
    "inh" to "ingusetio",
    "kab" to "cabilio",
    "kbd" to "cabardiano",
    "ks" to "cachemiro",
    "lou" to "creole de Luisiana",
    "lrc" to "lorí del norte",
    "lsm" to "saamia",
    "mga" to "irlandés medieval",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nd" to "ndebele del norte",
    "nso" to "sesotho del norte",
    "ojb" to "ojibwa del noroeste",
    "ojw" to "ojibwa del oeste",
    "pa" to "panyabí",
    "pis" to "pijín",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "sd" to "sindhi",
    "se" to "sami del norte",
    "slh" to "lushootseed del sur",
    "smn" to "sami de Inari",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "str" to "straits salish",
    "sw" to "swahili",
    "sw-CD" to "swahili del Congo",
    "tce" to "tutchone del sur",
    "ttm" to "tutchone del norte",
    "ug-alt-variant" to "uigur variante",
    "vec" to "véneto",
    "wuu" to "wu",
    "xal" to "calmuco",
    "xnr" to "dogrí",
    "zun" to "zuni",
  ) }

  val es_UY: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "arp" to "arapajó",
    "ars" to "árabe de Néyed",
    "bla" to "siksiká",
    "eu" to "vasco",
    "goh" to "alemán de la alta edad antigua",
    "grc" to "griego clásico",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "nso" to "sesotho del norte",
    "pa" to "panyabí",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "st" to "sesotho del sur",
    "sw" to "swahili",
    "sw-CD" to "swahili (Congo)",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zun" to "zuni",
  ) }

  val es_VE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ace" to "acehnés",
    "ady" to "adigeo",
    "alt" to "altái del sur",
    "ars" to "árabe de Néyed",
    "bho" to "bhojpuri",
    "bla" to "siksiká",
    "goh" to "alemán de la alta edad antigua",
    "gu" to "gujarati",
    "ht" to "haitiano",
    "kbd" to "cabardiano",
    "krc" to "karachái-bálkaro",
    "ks" to "cachemiro",
    "lij" to "genovés",
    "ml" to "malabar",
    "mni" to "manipuri",
    "nr" to "ndebele del sur",
    "prg" to "prusiano antiguo",
    "ps-alt-variant" to "pashtún",
    "rm" to "retorrománico",
    "sd" to "sindhi",
    "shu" to "árabe (Chad)",
    "sma" to "sami del sur",
    "ss" to "siswati",
    "st" to "sesotho del sur",
    "syr" to "siríaco",
    "tet" to "tetun",
    "tn" to "setswana",
    "tyv" to "tuvano",
    "ug-alt-variant" to "uighur",
    "vec" to "véneto",
    "wal" to "walamo",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "zgh" to "tamazight marroquí estándar",
    "zun" to "zuni",
  ) }

  val et: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afari",
    "ab" to "abhaasi",
    "ace" to "atšehi",
    "ach" to "atšoli",
    "ada" to "adangme",
    "ady" to "adõgee",
    "ae" to "avesta",
    "aeb" to "Tuneesia araabia",
    "af" to "afrikaani",
    "afh" to "afrihili",
    "agq" to "aghemi",
    "ain" to "ainu",
    "ak" to "akani",
    "akk" to "akadi",
    "akz" to "alabama",
    "ale" to "aleuudi",
    "aln" to "geegi",
    "alt" to "altai",
    "am" to "amhara",
    "an" to "aragoni",
    "ang" to "vanainglise",
    "ann" to "obolo",
    "anp" to "angika",
    "apc" to "Levandi araabia",
    "ar" to "araabia",
    "ar-001" to "tänapäeva araabia kirjakeel",
    "arc" to "aramea",
    "arn" to "mapudunguni",
    "aro" to "araona",
    "arp" to "arapaho",
    "arq" to "Alžeeria araabia",
    "ars" to "Najdi araabia",
    "arw" to "aravaki",
    "ary" to "Maroko araabia",
    "arz" to "Egiptuse araabia",
    "as" to "assami",
    "asa" to "asu",
    "ase" to "Ameerika viipekeel",
    "ast" to "astuuria",
    "atj" to "atikameki",
    "av" to "avaari",
    "awa" to "avadhi",
    "ay" to "aimara",
    "az" to "aserbaidžaani",
    "az-alt-short" to "aseri",
    "ba" to "baškiiri",
    "bal" to "belutši",
    "ban" to "bali",
    "bar" to "baieri",
    "bas" to "basaa",
    "bax" to "bamuni",
    "bbc" to "bataki",
    "bbj" to "ghomala",
    "be" to "valgevene",
    "bej" to "bedža",
    "bem" to "bemba",
    "bew" to "betavi",
    "bez" to "bena",
    "bfd" to "bafuti",
    "bfq" to "badaga",
    "bg" to "bulgaaria",
    "bgc" to "harjaanvi",
    "bgn" to "läänebelutši",
    "bho" to "bhodžpuri",
    "bi" to "bislama",
    "bik" to "bikoli",
    "bin" to "edo",
    "bjn" to "bandžari",
    "bkm" to "komi (Aafrika)",
    "bla" to "mustjalaindiaani",
    "blo" to "anii",
    "blt" to "tai-dami",
    "bm" to "bambara",
    "bn" to "bengali",
    "bo" to "tiibeti",
    "bpy" to "bišnuprija",
    "bqi" to "bahtiari",
    "br" to "bretooni",
    "bra" to "bradži",
    "brh" to "brahui",
    "brx" to "bodo",
    "bs" to "bosnia",
    "bss" to "akoose",
    "bua" to "burjaadi",
    "bug" to "bugi",
    "bum" to "bulu",
    "byn" to "bilini",
    "byv" to "medumba",
    "ca" to "katalaani",
    "cad" to "kado",
    "car" to "kariibi",
    "cay" to "kajuka",
    "cch" to "aitšami",
    "ccp" to "tšaakma",
    "ce" to "tšetšeeni",
    "ceb" to "sebu",
    "cgg" to "tšiga",
    "ch" to "tšamorro",
    "chb" to "tšibtša",
    "chg" to "tšagatai",
    "chk" to "tšuugi",
    "chm" to "mari",
    "chn" to "tšinuki žargoon",
    "cho" to "tšokto",
    "chp" to "tšipevai",
    "chr" to "tšerokii",
    "chy" to "šaieeni",
    "cic" to "tšikasoo",
    "ckb" to "sorani",
    "ckb-alt-menu" to "kurdi (keskkurdi)",
    "ckb-alt-variant" to "keskkurdi",
    "clc" to "tšilkotini",
    "co" to "korsika",
    "cop" to "kopti",
    "cps" to "kapisnoni",
    "cr" to "krii",
    "crg" to "michifi",
    "crh" to "krimmitatari",
    "crj" to "lõuna-idakrii",
    "crk" to "tasandikukrii",
    "crl" to "põhja-idakrii",
    "crm" to "põdrakrii",
    "crr" to "Carolina algonkini",
    "crs" to "seišelli",
    "cs" to "tšehhi",
    "csb" to "kašuubi",
    "csw" to "sookrii",
    "cu" to "kirikuslaavi",
    "cv" to "tšuvaši",
    "cy" to "kõmri",
    "da" to "taani",
    "dak" to "siuu",
    "dar" to "dargi",
    "dav" to "davida",
    "de" to "saksa",
    "de-AT" to "Austria saksa",
    "de-CH" to "Šveitsi ülemsaksa",
    "del" to "delavari",
    "den" to "sleivi",
    "dgr" to "dogribi",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "alamsorbi",
    "dtp" to "keskdusuni",
    "dua" to "duala",
    "dum" to "keskhollandi",
    "dv" to "maldiivi",
    "dyo" to "fonji",
    "dyu" to "djula",
    "dz" to "dzongkha",
    "dzg" to "daza",
    "ebu" to "embu",
    "ee" to "eve",
    "efi" to "efiki",
    "egl" to "emiilia",
    "egy" to "egiptuse",
    "eka" to "ekadžuki",
    "el" to "kreeka",
    "elx" to "eelami",
    "en" to "inglise",
    "en-AU" to "Austraalia inglise",
    "en-CA" to "Kanada inglise",
    "en-GB" to "Briti inglise",
    "en-GB-alt-short" to "Briti inglise",
    "en-US" to "Ameerika inglise",
    "en-US-alt-short" to "USA inglise",
    "enm" to "keskinglise",
    "eo" to "esperanto",
    "es" to "hispaania",
    "es-419" to "Ladina-Ameerika hispaania",
    "es-ES" to "Euroopa hispaania",
    "es-MX" to "Mehhiko hispaania",
    "esu" to "keskjupiki",
    "et" to "eesti",
    "eu" to "baski",
    "ewo" to "evondo",
    "ext" to "estremenju",
    "fa" to "pärsia",
    "fa-AF" to "dari",
    "fan" to "fangi",
    "fat" to "fanti",
    "ff" to "fula",
    "fi" to "soome",
    "fil" to "filipiini",
    "fit" to "meä",
    "fj" to "fidži",
    "fo" to "fääri",
    "fon" to "foni",
    "fr" to "prantsuse",
    "fr-CA" to "Kanada prantsuse",
    "fr-CH" to "Šveitsi prantsuse",
    "frc" to "cajun’i",
    "frm" to "keskprantsuse",
    "fro" to "vanaprantsuse",
    "frp" to "frankoprovansi",
    "frr" to "põhjafriisi",
    "frs" to "idafriisi",
    "fur" to "friuuli",
    "fy" to "läänefriisi",
    "ga" to "iiri",
    "gag" to "gagauusi",
    "gan" to "kani",
    "gay" to "gajo",
    "gba" to "gbaja",
    "gd" to "gaeli",
    "gez" to "etioopia",
    "gil" to "kiribati",
    "gl" to "galeegi",
    "glk" to "gilaki",
    "gmh" to "keskülemsaksa",
    "gn" to "guaranii",
    "goh" to "vanaülemsaksa",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gooti",
    "grb" to "grebo",
    "grc" to "vanakreeka",
    "gsw" to "šveitsisaksa",
    "gu" to "gudžarati",
    "guc" to "vajuu",
    "gur" to "farefare",
    "guz" to "gusii",
    "gv" to "mänksi",
    "gwi" to "gvitšini",
    "ha" to "hausa",
    "hai" to "haida",
    "hak" to "hakka",
    "haw" to "havai",
    "hax" to "lõunahaida",
    "he" to "heebrea",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hinglishi",
    "hif" to "Fidži hindi",
    "hil" to "hiligainoni",
    "hit" to "heti",
    "hmn" to "hmongi",
    "ho" to "hirimotu",
    "hr" to "horvaadi",
    "hsb" to "ülemsorbi",
    "hsn" to "sjangi",
    "ht" to "haiti",
    "hu" to "ungari",
    "hup" to "hupa",
    "hur" to "halkomelemi",
    "hy" to "armeenia",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "ibani",
    "ibb" to "ibibio",
    "id" to "indoneesia",
    "ie" to "interlingue",
    "ig" to "ibo",
    "ii" to "nuosu",
    "ik" to "injupiaki",
    "ikt" to "Lääne-Kanada inuktituti",
    "ilo" to "iloko",
    "inh" to "inguši",
    "io" to "ido",
    "is" to "islandi",
    "it" to "itaalia",
    "iu" to "inuktituti",
    "izh" to "isuri",
    "ja" to "jaapani",
    "jam" to "Jamaica kreoolkeel",
    "jbo" to "ložban",
    "jgo" to "ngomba",
    "jmc" to "matšame",
    "jpr" to "juudipärsia",
    "jrb" to "juudiaraabia",
    "jut" to "jüüti",
    "jv" to "jaava",
    "ka" to "gruusia",
    "kaa" to "karakalpaki",
    "kab" to "kabiili",
    "kac" to "katšini",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kaavi",
    "kbd" to "kabardi-tšerkessi",
    "kbl" to "kanembu",
    "kcg" to "tjapi",
    "kde" to "makonde",
    "kea" to "kabuverdianu",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "kaingangi",
    "kha" to "khasi",
    "kho" to "saka",
    "khq" to "koyra chiini",
    "khw" to "khovari",
    "ki" to "kikuju",
    "kiu" to "kõrmandžki",
    "kj" to "kvanjama",
    "kk" to "kasahhi",
    "kkj" to "kako",
    "kl" to "grööni",
    "kln" to "kalendžini",
    "km" to "khmeeri",
    "kmb" to "mbundu",
    "kn" to "kannada",
    "ko" to "korea",
    "koi" to "permikomi",
    "kok" to "konkani",
    "kos" to "kosrae",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karatšai-balkaari",
    "kri" to "krio",
    "krj" to "kinaraia",
    "krl" to "karjala",
    "kru" to "kuruhhi",
    "ks" to "kašmiiri",
    "ksb" to "šambala",
    "ksf" to "bafia",
    "ksh" to "kölni",
    "ku" to "kurdi",
    "kum" to "kumõki",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "korni",
    "kwk" to "kvakvala",
    "kxv" to "kuvi",
    "ky" to "kirgiisi",
    "la" to "ladina",
    "lad" to "ladiino",
    "lag" to "langi",
    "lah" to "lahnda",
    "lam" to "lamba",
    "lb" to "letseburgi",
    "lez" to "lesgi",
    "lg" to "ganda",
    "li" to "limburgi",
    "lij" to "liguuri",
    "lil" to "lillueti",
    "liv" to "liivi",
    "lkt" to "lakota",
    "lld" to "ladiini",
    "lmo" to "lombardi",
    "ln" to "lingala",
    "lo" to "lao",
    "lol" to "mongo",
    "lou" to "Louisiana kreoolkeel",
    "loz" to "lozi",
    "lrc" to "põhjaluri",
    "lsm" to "samia",
    "lt" to "leedu",
    "ltg" to "latgali",
    "lu" to "Katanga luba",
    "lua" to "lulua",
    "lui" to "luisenjo",
    "lun" to "lunda",
    "lus" to "lušei",
    "luy" to "luhja",
    "lv" to "läti",
    "lzh" to "klassikaline hiina",
    "lzz" to "lazi",
    "mad" to "madura",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makassari",
    "man" to "malinke",
    "mas" to "masai",
    "mde" to "maba",
    "mdf" to "mokša",
    "mdr" to "mandari",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "Mauritiuse kreoolkeel",
    "mg" to "malagassi",
    "mga" to "keskiiri",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta",
    "mh" to "maršalli",
    "mhn" to "mohheni",
    "mi" to "maoori",
    "mic" to "mikmaki",
    "min" to "minangkabau",
    "mk" to "makedoonia",
    "ml" to "malajalami",
    "mn" to "mongoli",
    "mnc" to "mandžu",
    "mni" to "manipuri",
    "moe" to "innu",
    "moh" to "mohoogi",
    "mos" to "more",
    "mr" to "marathi",
    "mrj" to "mäemari",
    "ms" to "malai",
    "mt" to "malta",
    "mua" to "mundangi",
    "mul" to "mitu keelt",
    "mus" to "maskogi",
    "mwl" to "miranda",
    "mwr" to "marvari",
    "mwv" to "mentavei",
    "my" to "birma",
    "mye" to "mjene",
    "myv" to "ersa",
    "mzn" to "mazandaraani",
    "na" to "nauru",
    "nan" to "lõunamini",
    "nap" to "napoli",
    "naq" to "nama",
    "nb" to "norra bokmål",
    "nd" to "põhjandebele",
    "nds" to "alamsaksa",
    "nds-NL" to "Hollandi alamsaksa",
    "ne" to "nepali",
    "new" to "nevari",
    "ng" to "ndonga",
    "nia" to "niasi",
    "niu" to "niue",
    "njo" to "ao",
    "nl" to "hollandi",
    "nl-BE" to "flaami",
    "nmg" to "kwasio",
    "nn" to "uusnorra",
    "nnh" to "ngiembooni",
    "no" to "norra",
    "nog" to "nogai",
    "non" to "vanapõhja",
    "nov" to "noviaal",
    "nqo" to "nkoo",
    "nr" to "lõunandebele",
    "nso" to "põhjasotho",
    "nus" to "nueri",
    "nv" to "navaho",
    "nwc" to "vananevari",
    "ny" to "njandža",
    "nym" to "njamvesi",
    "nyn" to "njankole",
    "nyo" to "njoro",
    "nzi" to "nzima",
    "oc" to "oksitaani",
    "oj" to "odžibvei",
    "ojb" to "loodeodžibvei",
    "ojc" to "keskodžibvei",
    "ojs" to "Severni odžibvei",
    "ojw" to "lääneodžibvei",
    "oka" to "okanagani",
    "om" to "oromo",
    "or" to "oria",
    "os" to "osseedi",
    "osa" to "oseidži",
    "ota" to "osmanitürgi",
    "pa" to "pandžabi",
    "pag" to "pangasinani",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "belau",
    "pcd" to "pikardi",
    "pcm" to "Nigeeria pidžinkeel",
    "pdc" to "Pennsylvania saksa",
    "pdt" to "mennoniidisaksa",
    "peo" to "vanapärsia",
    "pfl" to "Pfalzi",
    "phn" to "foiniikia",
    "pi" to "paali",
    "pis" to "pijini",
    "pl" to "poola",
    "pms" to "piemonte",
    "pnt" to "pontose",
    "pon" to "poonpei",
    "pqm" to "passamakodi",
    "prg" to "preisi",
    "pro" to "vanaprovansi",
    "ps" to "puštu",
    "pt" to "portugali",
    "pt-BR" to "Brasiilia portugali",
    "pt-PT" to "Euroopa portugali",
    "qu" to "ketšua",
    "quc" to "kitše",
    "raj" to "radžastani",
    "rap" to "rapanui",
    "rar" to "rarotonga",
    "rgn" to "romanja",
    "rhg" to "rohingja",
    "rif" to "riifi",
    "rm" to "romanši",
    "rn" to "rundi",
    "ro" to "rumeenia",
    "ro-MD" to "moldova",
    "rof" to "rombo",
    "rom" to "mustlaskeel",
    "rtm" to "rotuma",
    "ru" to "vene",
    "rue" to "russiini",
    "rug" to "roviana",
    "rup" to "aromuuni",
    "rw" to "ruanda",
    "rwk" to "rvaa",
    "sa" to "sanskriti",
    "sad" to "sandave",
    "sah" to "jakuudi",
    "sam" to "Samaaria aramea",
    "saq" to "samburu",
    "sas" to "sasaki",
    "sat" to "santali",
    "saz" to "sauraštra",
    "sba" to "ngambai",
    "sbp" to "sangu",
    "sc" to "sardi",
    "scn" to "sitsiilia",
    "sco" to "šoti",
    "sd" to "sindhi",
    "sdh" to "lõunakurdi",
    "se" to "põhjasaami",
    "see" to "seneka",
    "seh" to "sena",
    "sei" to "seri",
    "sel" to "sölkupi",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sga" to "vanaiiri",
    "sgs" to "žemaidi",
    "sh" to "serbia-horvaadi",
    "shi" to "šilha",
    "shn" to "šani",
    "shu" to "Tšaadi araabia",
    "si" to "singali",
    "sid" to "sidamo",
    "sk" to "slovaki",
    "skr" to "seraiki",
    "sl" to "sloveeni",
    "slh" to "Lõuna-Puget-Soundi sališi",
    "sli" to "alamsileesia",
    "sly" to "selajari",
    "sm" to "samoa",
    "sma" to "lõunasaami",
    "smj" to "Lule saami",
    "smn" to "Inari saami",
    "sms" to "koltasaami",
    "sn" to "šona",
    "snk" to "soninke",
    "so" to "somaali",
    "sog" to "sogdi",
    "sq" to "albaania",
    "sr" to "serbia",
    "srn" to "sranani",
    "srr" to "sereri",
    "ss" to "svaasi",
    "ssy" to "saho",
    "st" to "lõunasotho",
    "stq" to "saterfriisi",
    "str" to "väinasališi",
    "su" to "sunda",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumeri",
    "sv" to "rootsi",
    "sw" to "suahiili",
    "sw-CD" to "Kongo suahiili",
    "swb" to "komoori",
    "syc" to "vanasüüria",
    "syr" to "süüria",
    "szl" to "sileesia",
    "ta" to "tamili",
    "tce" to "lõunatutšoni",
    "tcy" to "tulu",
    "te" to "telugu",
    "tem" to "temne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetumi",
    "tg" to "tadžiki",
    "tgx" to "tagishi",
    "th" to "tai",
    "tht" to "tahltani",
    "ti" to "tigrinja",
    "tig" to "tigree",
    "tiv" to "tivi",
    "tk" to "türkmeeni",
    "tkl" to "tokelau",
    "tkr" to "tsahhi",
    "tl" to "tagalogi",
    "tlh" to "klingoni",
    "tli" to "tlingiti",
    "tly" to "talõši",
    "tmh" to "tamašeki",
    "tn" to "tsvana",
    "to" to "tonga",
    "tog" to "tšitonga",
    "tok" to "toki pona",
    "tpi" to "uusmelaneesia",
    "tr" to "türgi",
    "tru" to "turojo",
    "trv" to "taroko",
    "trw" to "torvali",
    "ts" to "tsonga",
    "tsd" to "tsakoonia",
    "tsi" to "tsimši",
    "tt" to "tatari",
    "ttm" to "põhjatutšoni",
    "ttt" to "lõunataadi",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "tvii",
    "twq" to "taswaqi",
    "ty" to "tahiti",
    "tyv" to "tõva",
    "tzm" to "tamasikti",
    "udm" to "udmurdi",
    "ug" to "uiguuri",
    "uga" to "ugariti",
    "uk" to "ukraina",
    "umb" to "umbundu",
    "und" to "määramata keel",
    "ur" to "urdu",
    "uz" to "usbeki",
    "ve" to "venda",
    "vec" to "veneti",
    "vep" to "vepsa",
    "vi" to "vietnami",
    "vls" to "lääneflaami",
    "vmf" to "Maini frangi",
    "vmw" to "makua",
    "vo" to "volapüki",
    "vot" to "vadja",
    "vro" to "võru",
    "vun" to "vundžo",
    "wa" to "vallooni",
    "wae" to "valsi",
    "wal" to "volaita",
    "war" to "varai",
    "was" to "vašo",
    "wbp" to "varlpiri",
    "wo" to "volofi",
    "wuu" to "uu",
    "xal" to "kalmõki",
    "xh" to "koosa",
    "xmf" to "megreli",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "jao",
    "yap" to "japi",
    "yav" to "yangbeni",
    "ybb" to "jemba",
    "yi" to "jidiši",
    "yo" to "joruba",
    "yrl" to "njengatu",
    "yue" to "kantoni",
    "yue-alt-menu" to "hiina (kantoni)",
    "za" to "tšuangi",
    "zap" to "sapoteegi",
    "zbl" to "Blissi sümbolid",
    "zea" to "zeelandi",
    "zen" to "zenaga",
    "zgh" to "tamasikti (Maroko)",
    "zh" to "hiina",
    "zh-alt-menu" to "hiina (mandariinihiina)",
    "zh-Hans" to "lihtsustatud hiina",
    "zh-Hans-alt-long" to "lihtsustatud mandariinihiina",
    "zh-Hant" to "traditsiooniline hiina",
    "zh-Hant-alt-long" to "traditsiooniline mandariinihiina",
    "zu" to "suulu",
    "zun" to "sunji",
    "zxx" to "mittekeeleline",
    "zza" to "zaza",
  ) }

  val eu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afarera",
    "ab" to "abkhaziera",
    "ace" to "acehnera",
    "ach" to "acholiera",
    "ada" to "adangmera",
    "ady" to "adigera",
    "af" to "afrikaansa",
    "agq" to "aghemera",
    "ain" to "ainuera",
    "ak" to "akanera",
    "ale" to "aleutera",
    "alt" to "hegoaldeko altaiera",
    "am" to "amharera",
    "an" to "aragoiera",
    "ann" to "oboloera",
    "anp" to "angikera",
    "ar" to "arabiera",
    "ar-001" to "arabiera moderno estandarra",
    "arn" to "mapudunguna",
    "arp" to "arapahoera",
    "ars" to "Najdeko arabiera",
    "as" to "assamera",
    "asa" to "asua",
    "ast" to "asturiera",
    "atj" to "atikamekwera",
    "av" to "avarera",
    "awa" to "awadhiera",
    "ay" to "aimara",
    "az" to "azerbaijanera",
    "az-alt-short" to "azerbaijanera",
    "ba" to "baxkirera",
    "ban" to "baliera",
    "bas" to "basaa",
    "be" to "bielorrusiera",
    "bem" to "bembera",
    "bez" to "benera",
    "bg" to "bulgariera",
    "bgc" to "haryanera",
    "bho" to "bhojpurera",
    "bi" to "bislama",
    "bin" to "edoera",
    "bla" to "siksikera",
    "blo" to "aniiera",
    "bm" to "bambarera",
    "bn" to "bengalera",
    "bo" to "tibetera",
    "br" to "bretoiera",
    "brx" to "bodoera",
    "bs" to "bosniera",
    "bug" to "buginera",
    "byn" to "bilenera",
    "ca" to "katalana",
    "cay" to "cayugera",
    "ccp" to "chakmera",
    "ce" to "txetxenera",
    "ceb" to "cebuanoera",
    "cgg" to "chiga",
    "ch" to "txamorroera",
    "chk" to "chuukera",
    "chm" to "mariera",
    "cho" to "txoktawera",
    "chp" to "chipewyera",
    "chr" to "txerokiera",
    "chy" to "txeieneera",
    "ckb" to "erdialdeko kurduera",
    "ckb-alt-menu" to "erdialdeko kurduera",
    "ckb-alt-variant" to "erdialdeko kurduera",
    "clc" to "chilcotinera",
    "co" to "korsikera",
    "crg" to "metisera",
    "crj" to "hego-ekialdeko creera",
    "crk" to "lautadetako creera",
    "crl" to "ipar-ekialdeko creera",
    "crm" to "Mooseko creera",
    "crr" to "Carolinako algonkinera",
    "crs" to "Seychelleetako kreolera",
    "cs" to "txekiera",
    "csw" to "zingiretako creera",
    "cu" to "elizako eslaviera",
    "cv" to "txuvaxera",
    "cy" to "galesa",
    "da" to "daniera",
    "dak" to "dakotera",
    "dar" to "darginera",
    "dav" to "taitera",
    "de" to "alemana",
    "de-AT" to "Austriako alemana",
    "de-CH" to "Suitzako aleman garaia",
    "dgr" to "dogribera",
    "dje" to "zarma",
    "doi" to "dogria",
    "dsb" to "behe-sorabiera",
    "dua" to "dualera",
    "dv" to "dhivehia",
    "dyo" to "fonyi jolera",
    "dz" to "dzongkha",
    "dzg" to "dazaera",
    "ebu" to "embuera",
    "ee" to "eweera",
    "efi" to "efikera",
    "eka" to "ekajuka",
    "el" to "greziera",
    "en" to "ingelesa",
    "en-AU" to "Australiako ingelesa",
    "en-CA" to "Kanadako ingelesa",
    "en-GB" to "Britainia Handiko ingelesa",
    "en-GB-alt-short" to "Erresuma Batuko ingelesa",
    "en-US" to "ingeles amerikarra",
    "en-US-alt-short" to "AEBko ingelesa",
    "eo" to "esperantoa",
    "es" to "gaztelania",
    "es-419" to "Latinoamerikako gaztelania",
    "es-ES" to "Europako gaztelania",
    "es-MX" to "Mexikoko gaztelania",
    "et" to "estoniera",
    "eu" to "euskara",
    "ewo" to "ewondoa",
    "fa" to "persiera",
    "fa-AF" to "daria",
    "ff" to "fula",
    "fi" to "finlandiera",
    "fil" to "filipinera",
    "fj" to "fijiera",
    "fo" to "faroera",
    "fon" to "fonera",
    "fr" to "frantsesa",
    "fr-CA" to "Kanadako frantsesa",
    "fr-CH" to "Suitzako frantsesa",
    "frc" to "cajun frantsesa",
    "frr" to "iparraldeko frisiera",
    "fur" to "friulera",
    "fy" to "mendebaldeko frisiera",
    "ga" to "irlandera",
    "gaa" to "gaera",
    "gag" to "gagauzera",
    "gd" to "Eskoziako gaelikoa",
    "gez" to "ge’eza",
    "gil" to "kiribatiera",
    "gl" to "galiziera",
    "gn" to "guaraniera",
    "gor" to "gorontaloera",
    "gsw" to "Suitzako alemana",
    "gu" to "gujaratera",
    "guz" to "gusiiera",
    "gv" to "manxera",
    "gwi" to "gwich’inera",
    "ha" to "hausa",
    "hai" to "haidera",
    "haw" to "hawaiiera",
    "hax" to "hegoaldeko haidera",
    "he" to "hebreera",
    "hi" to "hindia",
    "hi-Latn" to "hindia (latindarra)",
    "hi-Latn-alt-variant" to "hinglisha",
    "hil" to "hiligaynonera",
    "hmn" to "hmonga",
    "hr" to "kroaziera",
    "hsb" to "goi-sorabiera",
    "ht" to "Haitiko kreolera",
    "hu" to "hungariera",
    "hup" to "hupera",
    "hur" to "halkomelema",
    "hy" to "armeniera",
    "hz" to "hereroera",
    "ia" to "interlingua",
    "iba" to "ibanera",
    "ibb" to "ibibioera",
    "id" to "indonesiera",
    "ie" to "interlinguea",
    "ig" to "igboera",
    "ii" to "Sichuango yiera",
    "ikt" to "Kanada mendebaldeko inuitera",
    "ilo" to "ilocanoera",
    "inh" to "ingushera",
    "io" to "idoa",
    "is" to "islandiera",
    "it" to "italiera",
    "iu" to "inuitera",
    "ja" to "japoniera",
    "jbo" to "lojbana",
    "jgo" to "ngomba",
    "jmc" to "machamea",
    "jv" to "javera",
    "ka" to "georgiera",
    "kab" to "kabiliera",
    "kac" to "jingphoera",
    "kaj" to "jjua",
    "kam" to "kambera",
    "kbd" to "kabardiera",
    "kcg" to "tyapa",
    "kde" to "makondeera",
    "kea" to "Cabo Verdeko kreolera",
    "kfo" to "koroa",
    "kg" to "kikongoa",
    "kgp" to "kaingangera",
    "kha" to "khasiera",
    "khq" to "koyra chiinia",
    "ki" to "kikuyuera",
    "kj" to "kuanyama",
    "kk" to "kazakhera",
    "kkj" to "kakoa",
    "kl" to "groenlandiera",
    "kln" to "kalenjinera",
    "km" to "khemerera",
    "kmb" to "kimbundua",
    "kn" to "kannada",
    "ko" to "koreera",
    "koi" to "komi-permyakera",
    "kok" to "konkanera",
    "kpe" to "kpelleera",
    "kr" to "kanuriera",
    "krc" to "karachayera-balkarera",
    "krl" to "kareliera",
    "kru" to "kurukhera",
    "ks" to "kaxmirera",
    "ksb" to "shambalera",
    "ksf" to "bafiera",
    "ksh" to "koloniera",
    "ku" to "kurduera",
    "kum" to "kumykera",
    "kv" to "komiera",
    "kw" to "kornubiera",
    "kwk" to "kwakwala",
    "kxv" to "kuvia",
    "ky" to "kirgizera",
    "la" to "latina",
    "lad" to "ladinoa",
    "lag" to "langiera",
    "lb" to "luxenburgera",
    "lez" to "lezginera",
    "lg" to "luganda",
    "li" to "limburgera",
    "lij" to "liguriera",
    "lil" to "lillooetera",
    "lkt" to "lakotera",
    "lmo" to "lombardiera",
    "ln" to "lingala",
    "lo" to "laosera",
    "lou" to "Louisianako kreolera",
    "loz" to "loziera",
    "lrc" to "iparraldeko lurera",
    "lsm" to "saamia",
    "lt" to "lituaniera",
    "lu" to "Katangako lubera",
    "lua" to "Kasai mendebaldeko lubera",
    "lun" to "lundera",
    "luo" to "luoera",
    "lus" to "mizoera",
    "luy" to "luhyera",
    "lv" to "letoniera",
    "mad" to "madurera",
    "mag" to "magadhera",
    "mai" to "maithilia",
    "mak" to "makassarera",
    "mas" to "masaiera",
    "mdf" to "mokxera",
    "men" to "mendeera",
    "mer" to "meruera",
    "mfe" to "Mauritaniako kreolera",
    "mg" to "malgaxea",
    "mgh" to "makhuwa-meettoera",
    "mgo" to "metaʼera",
    "mh" to "marshallera",
    "mi" to "maoriera",
    "mic" to "mikmakera",
    "min" to "minangkabauera",
    "mk" to "mazedoniera",
    "ml" to "malabarera",
    "mn" to "mongoliera",
    "mni" to "manipurera",
    "moe" to "innuera",
    "moh" to "mohawkera",
    "mos" to "mossiera",
    "mr" to "marathera",
    "ms" to "malaysiera",
    "mt" to "maltera",
    "mua" to "mudangera",
    "mul" to "zenbait hizkuntza",
    "mus" to "muscogeera",
    "mwl" to "mirandesa",
    "my" to "birmaniera",
    "myv" to "erziera",
    "mzn" to "mazandarandera",
    "na" to "nauruera",
    "nap" to "napoliera",
    "naq" to "namera",
    "nb" to "bokmål (norvegiera)",
    "nd" to "iparraldeko ndebeleera",
    "nds" to "behe-alemana",
    "nds-NL" to "behe-saxoiera",
    "ne" to "nepalera",
    "new" to "newarera",
    "ng" to "ndonga",
    "nia" to "niasera",
    "niu" to "niueera",
    "nl" to "nederlandera",
    "nl-BE" to "flandriera",
    "nmg" to "kwasiera",
    "nn" to "nynorsk (norvegiera)",
    "nnh" to "ngiemboonera",
    "no" to "norvegiera",
    "nog" to "nogaiera",
    "nqo" to "n’koera",
    "nr" to "hegoaldeko ndebeleera",
    "nso" to "pediera",
    "nus" to "nuerera",
    "nv" to "navajoera",
    "ny" to "chewera",
    "nyn" to "nkoreera",
    "oc" to "okzitaniera",
    "ojb" to "ipar-mendebaldeko ojibwa",
    "ojc" to "erdialdeko ojibwa",
    "ojs" to "oji-creera",
    "ojw" to "mendebaldeko ojibwa",
    "oka" to "okanaganera",
    "om" to "oromoera",
    "or" to "oriya",
    "os" to "osetiera",
    "pa" to "punjabera",
    "pag" to "pangasinanera",
    "pam" to "pampangera",
    "pap" to "papiamentoa",
    "pau" to "palauera",
    "pcm" to "Nigeriako pidgina",
    "pis" to "pijina",
    "pl" to "poloniera",
    "pqm" to "maliseet-passamaquoddyera",
    "prg" to "prusiera",
    "ps" to "paxtunera",
    "pt" to "portugesa",
    "pt-BR" to "Brasilgo portugesa",
    "pt-PT" to "Europako portugesa",
    "qu" to "kitxua",
    "quc" to "quicheera",
    "raj" to "rajastanera",
    "rap" to "rapanuia",
    "rar" to "rarotongera",
    "rhg" to "rohingyera",
    "rm" to "erretorromaniera",
    "rn" to "rundiera",
    "ro" to "errumaniera",
    "ro-MD" to "moldaviera",
    "rof" to "romboa",
    "ru" to "errusiera",
    "rup" to "aromaniera",
    "rw" to "kinyaruanda",
    "rwk" to "rwera",
    "sa" to "sanskritoa",
    "sad" to "sandaweera",
    "sah" to "sakhera",
    "saq" to "samburuera",
    "sat" to "santalera",
    "sba" to "ngambayera",
    "sbp" to "sanguera",
    "sc" to "sardiniera",
    "scn" to "siziliera",
    "sco" to "eskoziera",
    "sd" to "sindhia",
    "se" to "iparraldeko samiera",
    "seh" to "senera",
    "ses" to "koyraboro sennia",
    "sg" to "sangoa",
    "sh" to "serbokroaziera",
    "shi" to "tachelhita",
    "shn" to "shanera",
    "si" to "sinhala",
    "sk" to "eslovakiera",
    "sl" to "esloveniera",
    "slh" to "lushootseeda",
    "sm" to "samoera",
    "sma" to "hegoaldeko samiera",
    "smj" to "Luleko samiera",
    "smn" to "Inariko samiera",
    "sms" to "skolten samiera",
    "sn" to "shonera",
    "snk" to "soninkeera",
    "so" to "somaliera",
    "sq" to "albaniera",
    "sr" to "serbiera",
    "srn" to "sranan tongoa",
    "ss" to "swatiera",
    "ssy" to "sahoa",
    "st" to "hegoaldeko sothoera",
    "str" to "itsasarteetako salishera",
    "su" to "sundanera",
    "suk" to "sukumera",
    "sv" to "suediera",
    "sw" to "swahilia",
    "sw-CD" to "Kongoko swahilia",
    "swb" to "komoreera",
    "syr" to "asiriera",
    "szl" to "silesiera",
    "ta" to "tamilera",
    "tce" to "hegoaldeko tutchoneera",
    "te" to "telugua",
    "tem" to "temneera",
    "teo" to "tesoera",
    "tet" to "tetuma",
    "tg" to "tajikera",
    "tgx" to "tagishera",
    "th" to "thailandiera",
    "tht" to "tahltanera",
    "ti" to "tigrinyera",
    "tig" to "tigreera",
    "tk" to "turkmenera",
    "tl" to "tagaloa",
    "tlh" to "klingonera",
    "tli" to "tlingitera",
    "tn" to "tswanera",
    "to" to "tongera",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turkiera",
    "trv" to "tarokoera",
    "ts" to "tsongera",
    "tt" to "tatarera",
    "ttm" to "iparraldeko tutchoneera",
    "tum" to "tumbukera",
    "tvl" to "tuvaluera",
    "tw" to "twia",
    "twq" to "tasawaqa",
    "ty" to "tahitiera",
    "tyv" to "tuvera",
    "tzm" to "Erdialdeko Atlaseko amazigera",
    "udm" to "udmurtera",
    "ug" to "uigurrera",
    "uk" to "ukrainera",
    "umb" to "umbundua",
    "und" to "hizkuntza ezezaguna",
    "ur" to "urdua",
    "uz" to "uzbekera",
    "vai" to "vaiera",
    "ve" to "vendera",
    "vec" to "veneziera",
    "vi" to "vietnamera",
    "vmw" to "makhuwera",
    "vo" to "volapük",
    "vun" to "vunjoa",
    "wa" to "valoniera",
    "wae" to "walserera",
    "wal" to "wolayttera",
    "war" to "warayera",
    "wo" to "wolofera",
    "wuu" to "wu txinera",
    "xal" to "kalmykera",
    "xh" to "xhosera",
    "xnr" to "kangrera",
    "xog" to "sogera",
    "yav" to "yangbenera",
    "ybb" to "yemba",
    "yi" to "yiddisha",
    "yo" to "jorubera",
    "yrl" to "nheengatua",
    "yue" to "kantonera",
    "yue-alt-menu" to "Kantongo txinera",
    "za" to "zhuangera",
    "zgh" to "amazigera estandarra",
    "zh" to "txinera",
    "zh-alt-menu" to "mandarina",
    "zh-Hans" to "txinera sinplifikatua",
    "zh-Hans-alt-long" to "mandarin sinplifikatua",
    "zh-Hant" to "txinera tradizionala",
    "zh-Hant-alt-long" to "mandarin tradizionala",
    "zu" to "zuluera",
    "zun" to "zuñiera",
    "zxx" to "ez dago eduki linguistikorik",
    "zza" to "zazera",
  ) }

  val ewo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Ǹkɔ́bɔ akán",
    "am" to "Ǹkɔ́bɔ amária",
    "ar" to "Ǹkɔ́bɔ arábia",
    "be" to "Ǹkɔ́bɔ belarúsian",
    "bg" to "Ǹkɔ́bɔ buləgárian",
    "bn" to "Ǹkɔ́bɔ bɛngalí",
    "cs" to "Ǹkɔ́bɔ tsɛ́g",
    "de" to "Ǹkɔ́bɔ ndzáman",
    "el" to "Ǹkɔ́bɔ gəlɛ́g",
    "en" to "Ǹkɔ́bɔ éngəlís",
    "es" to "ǹkɔ́bɔ kpənyá",
    "ewo" to "ewondo",
    "fa" to "ǹkɔ́bɔ fɛ́rəsian",
    "fr" to "Ǹkɔ́bɔ fulɛnsí",
    "ha" to "Ǹkɔ́bɔ aúsá",
    "hi" to "Ǹkɔ́bɔ hindí",
    "hu" to "Ǹkɔ́bɔ ungárían",
    "id" to "Ǹkɔ́bɔ ɛndonésian",
    "ig" to "Ǹkɔ́bɔ ibó",
    "it" to "Ǹkɔ́bɔ etáliɛn",
    "ja" to "Ǹkɔ́bɔ hapɔ́n",
    "jv" to "Ǹkɔ́bɔ havanís",
    "km" to "Ǹkɔ́bɔ kəmɛ́r",
    "ko" to "Ǹkɔ́bɔ koréan",
    "ms" to "Ǹkɔ́bɔ malɛ́sian",
    "my" to "Ǹkɔ́bɔ birəmán",
    "ne" to "ǹkɔ́bɔ nefálian",
    "nl" to "Ǹkɔ́bɔ nɛrəlándía",
    "pa" to "ǹkɔ́bɔ funəhábia",
    "pl" to "ǹkɔ́bɔ fólis",
    "pt" to "ǹkɔ́bɔ fɔtugɛ́s",
    "ro" to "ńkɔ́bɔ románía",
    "ru" to "ǹkɔ́bɔ rúsian",
    "rw" to "ǹkɔ́bɔ ruwandá",
    "so" to "ǹkɔ́bɔ somália",
    "sv" to "ǹkɔ́bɔ suwɛ́d",
    "ta" to "ǹkɔ́bɔ tamíl",
    "th" to "ǹkɔ́bɔ táilan",
    "tr" to "ǹkɔ́bɔ túrəki",
    "uk" to "ǹkɔ́bɔ ukelénia",
    "ur" to "ǹkɔ́bɔ urudú",
    "vi" to "ǹkɔ́bɔ hiɛdənám",
    "yo" to "ǹkɔ́bɔ yorúba",
    "zh" to "Ǹkɔ́bɔ tsainís",
    "zh-alt-menu" to "Ǹkɔ́bɔ tsainís",
    "zu" to "ǹkɔ́bɔ zulú",
  ) }

  val fa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "آفاری",
    "ab" to "آبخازی",
    "ace" to "آچئی",
    "ach" to "آچولیایی",
    "ada" to "آدانگمه‌ای",
    "ady" to "آدیجیایی",
    "ae" to "اوستایی",
    "aeb" to "عربی تونسی",
    "af" to "آفریکانس",
    "afh" to "آفریهیلی",
    "agq" to "آگیم",
    "ain" to "آینویی",
    "ak" to "آکان",
    "akk" to "اکدی",
    "akz" to "آلابامایی",
    "ale" to "آلئوتی",
    "alt" to "آلتایی جنوبی",
    "am" to "امهری",
    "an" to "آراگونی",
    "ang" to "انگلیسی باستان",
    "ann" to "اوبولو",
    "anp" to "آنگیکا",
    "ar" to "عربی",
    "ar-001" to "عربی رسمی",
    "arc" to "آرامی",
    "arn" to "ماپوچه‌ای",
    "arp" to "آراپاهویی",
    "arq" to "عربی الجزایری",
    "ars" to "عربی نجدی",
    "arw" to "آراواکی",
    "ary" to "عربی مراکشی",
    "arz" to "عربی مصری",
    "as" to "آسامی",
    "asa" to "آسو",
    "ast" to "آستوری",
    "atj" to "آتیکامکو",
    "av" to "آواری",
    "awa" to "اودهی",
    "ay" to "آیمارایی",
    "az" to "ترکی آذربایجانی",
    "az-alt-short" to "آذری",
    "az-alt-variant" to "آذربایجانی",
    "az-Arab" to "ترکی آذری جنوبی",
    "ba" to "باشقیری",
    "bal" to "بلوچی",
    "ban" to "بالیایی",
    "bar" to "باواریایی",
    "bas" to "باسایی",
    "bax" to "بمونی",
    "be" to "بلاروسی",
    "bej" to "بجایی",
    "bem" to "بمبایی",
    "bez" to "بنایی",
    "bg" to "بلغاری",
    "bgc" to "هارایاناوی",
    "bgn" to "بلوچی غربی",
    "bho" to "بوجپوری",
    "bi" to "بیسلاما",
    "bik" to "بیکولی",
    "bin" to "بینی",
    "bla" to "سیکسیکا",
    "blo" to "باسیلا",
    "bm" to "بامبارایی",
    "bn" to "بنگالی",
    "bo" to "تبتی",
    "bqi" to "لری بختیاری",
    "br" to "برتون",
    "bra" to "براج",
    "brh" to "براهویی",
    "brx" to "بودویی",
    "bs" to "بوسنیایی",
    "bua" to "بوریاتی",
    "bug" to "بوگینس",
    "byn" to "بلین",
    "ca" to "کاتالان",
    "cad" to "کادویی",
    "car" to "کاریبی",
    "cay" to "کایوگا",
    "ccp" to "چاکما",
    "ce" to "چچنی",
    "ceb" to "سبویی",
    "cgg" to "چیگا",
    "ch" to "چامورویی",
    "chb" to "چیبچا",
    "chg" to "جغتایی",
    "chk" to "چوکی",
    "chm" to "ماریایی",
    "cho" to "چوکتویی",
    "chp" to "چیپه‌ویه‌ای",
    "chr" to "چروکی",
    "chy" to "شایانی",
    "ckb" to "کردی مرکزی",
    "ckb-alt-menu" to "کردی، مرکزی",
    "ckb-alt-variant" to "کردی سورانی",
    "clc" to "چیلکوتن",
    "co" to "کورسی",
    "cop" to "قبطی",
    "cr" to "کریایی",
    "crg" to "میچیف",
    "crh" to "ترکی کریمه",
    "crj" to "کری جنوب شرقی",
    "crk" to "کری صحرایی",
    "crl" to "کری شمال شرقی",
    "crm" to "موس کری",
    "crr" to "آلگانکوین کارولینا",
    "crs" to "سیشل آمیختهٔ فرانسوی",
    "cs" to "چکی",
    "csb" to "کاشوبی",
    "csw" to "کری سوامپی",
    "cu" to "اسلاوی کلیسایی",
    "cv" to "چوواشی",
    "cy" to "ولزی",
    "da" to "دانمارکی",
    "dak" to "داکوتایی",
    "dar" to "دارگوا",
    "dav" to "تایتا",
    "de" to "آلمانی",
    "de-AT" to "آلمانی اتریش",
    "de-CH" to "آلمانی معیار سوئیس",
    "del" to "دلاواری",
    "dgr" to "دوگریب",
    "din" to "دینکایی",
    "dje" to "زرما",
    "doi" to "دوگری",
    "dsb" to "صُربی سفلی",
    "dua" to "دوآلایی",
    "dum" to "هلندی میانه",
    "dv" to "دیوهی",
    "dyo" to "دیولا فونی",
    "dyu" to "دایولایی",
    "dz" to "دزونگخا",
    "dzg" to "دازاگا",
    "ebu" to "امبو",
    "ee" to "اوه‌ای",
    "efi" to "افیکی",
    "egy" to "مصری کهن",
    "eka" to "اکاجوک",
    "el" to "یونانی",
    "elx" to "عیلامی",
    "en" to "انگلیسی",
    "en-AU" to "انگلیسی استرالیا",
    "en-CA" to "انگلیسی کانادا",
    "en-GB" to "انگلیسی بریتانیا",
    "en-GB-alt-short" to "انگلیسی بریتانیا",
    "en-US" to "انگلیسی آمریکا",
    "en-US-alt-short" to "انگلیسی آمریکا",
    "enm" to "انگلیسی میانه",
    "eo" to "اسپرانتو",
    "es" to "اسپانیایی",
    "es-419" to "اسپانیایی امریکای لاتین",
    "es-ES" to "اسپانیایی اروپا",
    "es-MX" to "اسپانیایی مکزیک",
    "et" to "استونیایی",
    "eu" to "باسکی",
    "ewo" to "اواندو",
    "fa" to "فارسی",
    "fa-AF" to "دری",
    "fan" to "فانگی",
    "fat" to "فانتیایی",
    "ff" to "فولانی",
    "fi" to "فنلاندی",
    "fil" to "فیلیپینی",
    "fj" to "فیجیایی",
    "fo" to "فارویی",
    "fon" to "فونی",
    "fr" to "فرانسوی",
    "fr-CA" to "فرانسوی کانادا",
    "fr-CH" to "فرانسوی سوئیس",
    "frc" to "فرانسوی کاجون",
    "frm" to "فرانسوی میانه",
    "fro" to "فرانسوی باستان",
    "frr" to "فریزی شمالی",
    "frs" to "فریزی شرقی",
    "fur" to "فریولیایی",
    "fy" to "فریسی غربی",
    "ga" to "ایرلندی",
    "gaa" to "گایی",
    "gag" to "گاگائوزیایی",
    "gay" to "گایویی",
    "gba" to "گبایایی",
    "gbz" to "دری زرتشتی",
    "gd" to "گیلی اسکاتلندی",
    "gez" to "گی‌ئزی",
    "gil" to "گیلبرتی",
    "gl" to "گالیسیایی",
    "glk" to "گیلکی",
    "gmh" to "آلمانی معیار میانه",
    "gn" to "گوارانی",
    "goh" to "آلمانی علیای باستان",
    "gon" to "گوندی",
    "gor" to "گورونتالو",
    "got" to "گوتی",
    "grb" to "گریبویی",
    "grc" to "یونانی کهن",
    "gsw" to "آلمانی سوئیسی",
    "gu" to "گجراتی",
    "guz" to "گوسی",
    "gv" to "مانی",
    "gwi" to "گویچ این",
    "ha" to "هوسایی",
    "hai" to "هایدایی",
    "haw" to "هاوایی",
    "hax" to "هایدا جنوبی",
    "he" to "عبری",
    "hi" to "هندی",
    "hi-Latn-alt-variant" to "هندی (انگلیسی)",
    "hif" to "هندی فیجیایی",
    "hil" to "هیلی‌گاینونی",
    "hit" to "هیتی",
    "hmn" to "همونگ",
    "ho" to "موتویی هیری",
    "hr" to "کروات",
    "hsb" to "صُربی علیا",
    "ht" to "هائیتیایی",
    "hu" to "مجاری",
    "hup" to "هوپا",
    "hur" to "هالکوملم",
    "hy" to "ارمنی",
    "hz" to "هریرویی",
    "ia" to "اینترلینگوا",
    "iba" to "ایبانی",
    "ibb" to "ایبیبیو",
    "id" to "اندونزیایی",
    "ie" to "اکسیدنتال",
    "ig" to "ایگبویی",
    "ii" to "یی سیچوان",
    "ik" to "اینوپیک",
    "ikt" to "اینوکتیتوت غرب کانادا",
    "ilo" to "ایلوکویی",
    "inh" to "اینگوشی",
    "io" to "ایدو",
    "is" to "ایسلندی",
    "it" to "ایتالیایی",
    "iu" to "اینوکتیتوت",
    "ja" to "ژاپنی",
    "jbo" to "لوجبان",
    "jgo" to "نگومبا",
    "jmc" to "ماچامه‌ای",
    "jpr" to "فارسی یهودی",
    "jrb" to "عربی یهودی",
    "jv" to "جاوه‌ای",
    "ka" to "گرجی",
    "kaa" to "قره‌قالپاقی",
    "kab" to "قبایلی",
    "kac" to "کاچینی",
    "kaj" to "جو",
    "kam" to "کامبایی",
    "kaw" to "کاویایی",
    "kbd" to "کاباردینی",
    "kcg" to "تیاپی",
    "kde" to "ماکونده",
    "kea" to "کابووردیانو",
    "kfo" to "کورو",
    "kg" to "کنگویی",
    "kgp" to "کاین گنگ",
    "kha" to "خاسیایی",
    "kho" to "ختنی",
    "khq" to "کوجراچینی",
    "khw" to "کهوار",
    "ki" to "کیکویویی",
    "kiu" to "کرمانجی",
    "kj" to "کوانیاما",
    "kk" to "قزاقی",
    "kkj" to "کاکایی",
    "kl" to "گرینلندی",
    "kln" to "کالنجین",
    "km" to "خمری",
    "kmb" to "کیمبوندویی",
    "kn" to "کانارا",
    "ko" to "کره‌ای",
    "koi" to "کومی پرمیاک",
    "kok" to "کنکانی",
    "kpe" to "کپله‌ای",
    "kr" to "کانوریایی",
    "krc" to "قره‌چایی‐بالکاری",
    "krl" to "کاریلیانی",
    "kru" to "کوروخی",
    "ks" to "کشمیری",
    "ksb" to "شامبالا",
    "ksf" to "بافیایی",
    "ksh" to "کولش",
    "ku" to "کردی",
    "kum" to "کومیکی",
    "kut" to "کوتنی",
    "kv" to "کومیایی",
    "kw" to "کورنی",
    "kwk" to "کواک والا",
    "kxv" to "کووی",
    "ky" to "قرقیزی",
    "la" to "لاتین",
    "lad" to "لادینو",
    "lag" to "لانگی",
    "lah" to "لاهندا",
    "lam" to "لامبا",
    "lb" to "لوگزامبورگی",
    "lez" to "لزگی",
    "lg" to "گاندایی",
    "li" to "لیمبورگی",
    "lij" to "لیگوری",
    "lil" to "لیلوئت",
    "lkt" to "لاکوتا",
    "lmo" to "لومبارد",
    "ln" to "لینگالا",
    "lo" to "لائوسی",
    "lol" to "مونگویی",
    "lou" to "کرئول لوئیزیانا",
    "loz" to "لوزیایی",
    "lrc" to "لری شمالی",
    "lsm" to "سامیا",
    "lt" to "لیتوانیایی",
    "lu" to "لوبایی‐کاتانگا",
    "lua" to "لوبایی‐لولوا",
    "lui" to "لویسنو",
    "lun" to "لوندایی",
    "luo" to "لوئویی",
    "lus" to "میزو",
    "luy" to "لویا",
    "lv" to "لتونیایی",
    "lzh" to "چینی ادبی",
    "mad" to "مادورایی",
    "mag" to "ماگاهیایی",
    "mai" to "مایدیلی",
    "mak" to "ماکاسار",
    "man" to "ماندینگویی",
    "mas" to "ماسایی",
    "mdf" to "مکشایی",
    "mdr" to "ماندار",
    "men" to "منده‌ای",
    "mer" to "مرویی",
    "mfe" to "موریسین",
    "mg" to "مالاگاسی",
    "mga" to "ایرلندی میانه",
    "mgh" to "ماکوا متو",
    "mgo" to "متایی",
    "mh" to "مارشالی",
    "mi" to "مائوری",
    "mic" to "میکماکی",
    "min" to "مینانگ‌کابویی",
    "mk" to "مقدونی",
    "ml" to "مالایالامی",
    "mn" to "مغولی",
    "mnc" to "مانچویی",
    "mni" to "مانیپوری",
    "moe" to "اینوآیموم",
    "moh" to "موهاکی",
    "mos" to "ماسیایی",
    "mr" to "مراتی",
    "ms" to "مالایی",
    "mt" to "مالتی",
    "mua" to "ماندانگی",
    "mul" to "چندین زبان",
    "mus" to "کریکی",
    "mwl" to "میراندی",
    "mwr" to "مارواری",
    "my" to "برمه‌ای",
    "myv" to "ارزیایی",
    "mzn" to "مازندرانی",
    "na" to "نائورویی",
    "nap" to "ناپلی",
    "naq" to "نامایی",
    "nb" to "نروژی بوک‌مُل",
    "nd" to "انده‌بله‌ای شمالی",
    "nds" to "آلمانی سفلی",
    "nds-NL" to "ساکسونی سفلی",
    "ne" to "نپالی",
    "new" to "نواریایی",
    "ng" to "اندونگایی",
    "nia" to "نیاسی",
    "niu" to "نیویی",
    "nl" to "هلندی",
    "nl-BE" to "فلمنگی",
    "nmg" to "کوازیو",
    "nn" to "نروژی نی‌نُشک",
    "nnh" to "نیامبون",
    "no" to "نروژی",
    "nog" to "نغایی",
    "non" to "نرس باستان",
    "nqo" to "نکو",
    "nr" to "انده‌بله‌ای جنوبی",
    "nso" to "سوتویی شمالی",
    "nus" to "نویر",
    "nv" to "ناواهویی",
    "nwc" to "نواریایی کلاسیک",
    "ny" to "نیانجایی",
    "nym" to "نیام‌وزیایی",
    "nyn" to "نیانکوله‌ای",
    "nyo" to "نیورویی",
    "nzi" to "نزیمایی",
    "oc" to "اکسیتان",
    "oj" to "اوجیبوایی",
    "ojb" to "اوجیبوای شمالی",
    "ojc" to "اوجیبوای مرکزی",
    "ojs" to "اوجی-کری",
    "ojw" to "اوجیبوای غربی",
    "oka" to "اوکاناگان",
    "om" to "اورومویی",
    "or" to "اوریه‌ای",
    "os" to "آسی",
    "osa" to "اوسیجی",
    "ota" to "ترکی عثمانی",
    "pa" to "پنجابی",
    "pag" to "پانگاسینانی",
    "pal" to "پهلوی",
    "pam" to "پامپانگایی",
    "pap" to "پاپیامنتو",
    "pau" to "پالائویی",
    "pcm" to "نیم‌زبان نیجریه‌ای",
    "pdc" to "آلمانی پنسیلوانیایی",
    "peo" to "فارسی باستان",
    "phn" to "فنیقی",
    "pi" to "پالی",
    "pis" to "پی‌جین",
    "pl" to "لهستانی",
    "pon" to "پانپیی",
    "pqm" to "ملیسیت - پاسماکودی",
    "prg" to "پروسی",
    "pro" to "پرووانسی باستان",
    "ps" to "پشتو",
    "ps-alt-variant" to "پختو",
    "pt" to "پرتغالی",
    "pt-BR" to "پرتغالی برزیل",
    "pt-PT" to "پرتغالی اروپا",
    "qu" to "کچوایی",
    "quc" to "کیچه‌",
    "raj" to "راجستانی",
    "rap" to "راپانویی",
    "rar" to "راروتونگایی",
    "rhg" to "روهینگیا",
    "rm" to "رومانش",
    "rn" to "روندیایی",
    "ro" to "رومانیایی",
    "ro-MD" to "مولداویایی",
    "rof" to "رومبویی",
    "rom" to "رومانویی",
    "ru" to "روسی",
    "rup" to "آرومانی",
    "rw" to "کینیارواندایی",
    "rwk" to "روایی",
    "sa" to "سانسکریت",
    "sad" to "سانداوه‌ای",
    "sah" to "یاقوتی",
    "sam" to "آرامی سامری",
    "saq" to "سامبورو",
    "sas" to "ساساکی",
    "sat" to "سانتالی",
    "sba" to "انگامبایی",
    "sbp" to "سانگویی",
    "sc" to "ساردینیایی",
    "scn" to "سیسیلی",
    "sco" to "اسکاتلندی",
    "sd" to "سندی",
    "sdh" to "کردی جنوبی",
    "se" to "سامی شمالی",
    "seh" to "سنا",
    "sel" to "سلکوپی",
    "ses" to "کویرابورا سنی",
    "sg" to "سانگو",
    "sga" to "ایرلندی باستان",
    "sh" to "صرب و کرواتی",
    "shi" to "تاچل‌هیت",
    "shn" to "شانی",
    "shu" to "عربی چادی",
    "si" to "سینهالی",
    "sid" to "سیدامویی",
    "sk" to "اسلواکی",
    "sl" to "اسلوونیایی",
    "slh" to "لاشوتسید جنوبی",
    "sli" to "سیلزیایی سفلی",
    "sm" to "ساموآیی",
    "sma" to "سامی جنوبی",
    "smj" to "لوله سامی",
    "smn" to "ایناری سامی",
    "sms" to "اسکولت سامی",
    "sn" to "شونایی",
    "snk" to "سونینکه‌ای",
    "so" to "سومالیایی",
    "sog" to "سغدی",
    "sq" to "آلبانیایی",
    "sr" to "صربی",
    "srn" to "زبان اسرانان",
    "srr" to "سریری",
    "ss" to "سوازیایی",
    "ssy" to "ساهو",
    "st" to "سوتوی جنوبی",
    "str" to "سالیش استریتز",
    "su" to "سوندایی",
    "suk" to "سوکومایی",
    "sus" to "سوسویی",
    "sux" to "سومری",
    "sv" to "سوئدی",
    "sw" to "سواحیلی",
    "sw-CD" to "سواحیلی کنگو",
    "swb" to "کوموری",
    "syc" to "سریانی کلاسیک",
    "syr" to "سریانی",
    "szl" to "سیلزیایی",
    "ta" to "تامیلی",
    "tce" to "توچون جنوبی",
    "te" to "تلوگویی",
    "tem" to "تمنه‌ای",
    "teo" to "تسویی",
    "ter" to "ترنو",
    "tet" to "تتومی",
    "tg" to "تاجیکی",
    "tgx" to "تاگیش",
    "th" to "تایلندی",
    "tht" to "تالتان",
    "ti" to "تیگرینیایی",
    "tig" to "تیگره‌ای",
    "tiv" to "تیوی",
    "tk" to "ترکمنی",
    "tl" to "تاگالوگی",
    "tlh" to "کلینگون",
    "tli" to "تلین‌گیتی",
    "tmh" to "تاماشقی",
    "tn" to "تسوانایی",
    "to" to "تونگایی",
    "tog" to "تونگایی نیاسا",
    "tok" to "توکی پونا",
    "tpi" to "توک‌پیسینی",
    "tr" to "ترکی استانبولی",
    "tr-alt-secondary" to "ترکی",
    "trv" to "تاروکویی",
    "ts" to "تسونگایی",
    "tsi" to "تسیم‌شیانی",
    "tt" to "تاتاری",
    "ttm" to "تاچونی شمالی",
    "tum" to "تومبوکایی",
    "tvl" to "تووالویی",
    "tw" to "توی‌یایی",
    "twq" to "تسواکی",
    "ty" to "تاهیتیایی",
    "tyv" to "تووایی",
    "tzm" to "آمازیغی اطلس مرکزی",
    "udm" to "اودمورتی",
    "ug" to "اویغوری",
    "uga" to "اوگاریتی",
    "uk" to "اوکراینی",
    "umb" to "امبوندویی",
    "und" to "زبان نامشخص",
    "ur" to "اردو",
    "uz" to "ازبکی",
    "vai" to "ویایی",
    "ve" to "وندایی",
    "vec" to "ونیزی",
    "vi" to "ویتنامی",
    "vmw" to "ماکوا",
    "vo" to "ولاپوک",
    "vot" to "وتی",
    "vun" to "ونجو",
    "wa" to "والونی",
    "wae" to "والسر",
    "wal" to "والامو",
    "war" to "وارایی",
    "was" to "واشویی",
    "wbp" to "وارلپیری",
    "wo" to "ولوفی",
    "wuu" to "وو چینی",
    "xal" to "قلموقی",
    "xh" to "خوسایی",
    "xnr" to "کانگری",
    "xog" to "سوگایی",
    "yao" to "یائویی",
    "yap" to "یاپی",
    "yav" to "یانگبنی",
    "ybb" to "یمبایی",
    "yi" to "یدی",
    "yo" to "یوروبایی",
    "yrl" to "نهین گاتو",
    "yue" to "کانتونی",
    "yue-alt-menu" to "چینی کانتونی",
    "za" to "ژوانگی",
    "zap" to "زاپوتکی",
    "zen" to "زناگا",
    "zgh" to "آمازیغی معیار مراکش",
    "zh" to "چینی",
    "zh-alt-menu" to "چینی، ماندارین",
    "zh-Hans" to "چینی ساده‌شده",
    "zh-Hans-alt-long" to "چینی ماندارین ساده‌شده",
    "zh-Hant" to "چینی سنتی",
    "zh-Hant-alt-long" to "چینی ماندارین سنتی",
    "zu" to "زولویی",
    "zun" to "زونیایی",
    "zxx" to "بدون محتوای زبانی",
    "zza" to "زازایی",
  ) }

  val fa_AF: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ab" to "افریکانس",
    "ar-001" to "عربی فصیح",
    "as" to "اسامی",
    "ast" to "اتریشی",
    "az" to "آذربایجانی",
    "ckb" to "کردی سورانی",
    "dv" to "مالدیوی",
    "es" to "هسپانوی",
    "fi" to "فنلندی",
    "ga" to "آیرلندی",
    "hr" to "کروشیایی",
    "id" to "اندونیزیایی",
    "is" to "آیسلندی",
    "it" to "ایتالوی",
    "ja" to "جاپانی",
    "ko" to "کوریایی",
    "ksh" to "کلنی",
    "ky" to "قرغزی",
    "lus" to "میزویی",
    "mai" to "مایتیلی",
    "mn" to "مغلی",
    "nb" to "نروژی کتابی",
    "ne" to "نیپالی",
    "nl" to "هالندی",
    "nl-BE" to "فلمیش",
    "nn" to "نروژی نو",
    "no" to "نارویژی",
    "pl" to "پولندی",
    "ps-alt-variant" to "پشتو",
    "pt" to "پرتگالی",
    "sq" to "البانیایی",
    "srn" to "زبان سرانان",
    "sv" to "سویدنی",
    "sw" to "سواحلی",
    "tg" to "تاجکی",
    "zh-Hans" to "چینی ساده شده",
    "zza" to "زازاکی",
  ) }

  val ff: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Akaan",
    "am" to "Amarik",
    "ar" to "Aarabeere",
    "be" to "Belaruuse",
    "bg" to "Bulgariire",
    "bn" to "Bengali",
    "cs" to "Cekkere",
    "de" to "Docceere",
    "el" to "Gerke",
    "en" to "Engeleere",
    "es" to "Español",
    "fa" to "Perseere",
    "ff" to "Pulaar",
    "fr" to "Farayseere",
    "ha" to "Hawsaŋkoore",
    "hi" to "Hinndi",
    "hu" to "Hongariire",
    "id" to "Endonesiire",
    "ig" to "Igiboore",
    "it" to "Italiyeere",
    "ja" to "Saponeere",
    "jv" to "Sawaneere",
    "km" to "Kemeere",
    "ko" to "Koreere",
    "ms" to "Malayeere",
    "my" to "Burmeese",
    "ne" to "Nepaaleere",
    "nl" to "Dacceere",
    "pa" to "Punjabeere",
    "pl" to "Poloneere",
    "pt" to "Purtugeere",
    "ro" to "Romaneere",
    "ru" to "Riis",
    "rw" to "Ruwaanndeere",
    "so" to "Somalii",
    "sv" to "Sweedeere",
    "ta" to "Tamil",
    "th" to "Taay",
    "tr" to "Turkeere",
    "uk" to "Ukereneere",
    "ur" to "Urdu",
    "vi" to "Wiyetnameere",
    "yo" to "Yorrubaa",
    "zh" to "Sinuwaare",
    "zh-alt-menu" to "Sinuwaare",
    "zu" to "Suluŋkoore",
  ) }

  val ff_Adlm: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "𞤀𞤬𞤢𞥄𞤪𞤫",
    "ab" to "𞤀𞤦𞤳𞤢𞥄𞤧𞤭𞤴𞤢𞤲𞤪𞤫",
    "ace" to "𞤀𞥄𞤧𞤭𞤴𞤢𞤲𞤪𞤫",
    "ada" to "𞤀𞤣𞤢𞤲𞤺𞤥𞤫𞥅𞤪𞤫",
    "ady" to "𞤀𞤣𞤭𞤿𞤭𞥅𞤪𞤫",
    "af" to "𞤀𞤬𞤪𞤭𞤳𞤢𞤲𞤪𞤫",
    "agq" to "𞤀𞤺𞤸𞤫𞤥𞤪𞤫",
    "ain" to "𞤀𞤴𞤲𞤵𞥅𞤪𞤫",
    "ak" to "𞤀𞤳𞤢𞤲𞤪𞤫",
    "ale" to "𞤀𞤤𞤫𞤵𞤼𞤵𞥅𞤪𞤫",
    "alt" to "𞤀𞤤𞤼𞤢𞤴𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞤲𞤳𞤮𞥅𞤪𞤫",
    "am" to "𞤀𞤥𞤸𞤢𞤪𞤭𞥅𞤪𞤫",
    "an" to "𞤀𞤪𞤢𞤺𞤮𞤲𞤪𞤫",
    "ann" to "𞤌𞤦𞤮𞤤𞤮𞥅𞤪𞤫",
    "anp" to "𞤀𞤲𞤺𞤭𞤳𞤢𞥄𞤪𞤫",
    "ar" to "𞤀𞥄𞤪𞤢𞤦𞤫𞥅𞤪𞤫",
    "ar-001" to "𞤀𞥄𞤪𞤢𞤦𞤫𞥅𞤪𞤫 𞤊𞤵𞤧𞤸𞤢 𞤒𞤫𞤲𞤯𞤵𞤳𞤢",
    "arn" to "𞤃𞤢𞤨𞤵𞤷𞤭𞥅𞤪𞤫",
    "arp" to "𞤀𞤪𞤢𞤨𞤢𞤸𞤮𞥅𞤪𞤫",
    "ars" to "𞤀𞥄𞤪𞤢𞤦𞤫𞥅𞤪𞤫 𞤐𞤢𞤶𞤣𞤭",
    "as" to "𞤀𞤧𞤢𞤥𞤫𞥅𞤪𞤫",
    "asa" to "𞤀𞤧𞤵𞥅𞤪𞤫",
    "ast" to "𞤀𞤧𞤼𞤵𞤪𞤭𞥅𞤪𞤫",
    "atj" to "𞤀𞤼𞤭𞤥𞤫𞤳𞤵𞤱𞤪𞤫",
    "av" to "𞤀𞤬𞤱𞤢𞤪𞤭𞥅𞤪𞤫",
    "awa" to "𞤀𞤱𞤢𞤣𞤭𞥅𞤪𞤫",
    "ay" to "𞤀𞤴𞤥𞤢𞤪𞤢𞥄𞤪𞤫",
    "az" to "𞤀𞤶𞤢𞤪𞤦𞤢𞤴𞤭𞤶𞤢𞤲𞤭𞥅𞤪𞤫",
    "az-alt-short" to "𞤀𞤶𞤢𞤪𞤭𞥅𞤪𞤫",
    "ba" to "𞤄𞤢𞤧𞤳𞤭𞥅𞤪𞤫",
    "ban" to "𞤄𞤢𞥄𞤤𞤭𞥅𞤪𞤫",
    "bas" to "𞤄𞤢𞤧𞤢𞥄𞤪𞤫",
    "be" to "𞤄𞤫𞤤𞤢𞤪𞤭𞥅𞤧𞤭𞥅𞤪𞤫",
    "bem" to "𞤄𞤫𞤥𞤦𞤢𞥄𞤪𞤫",
    "bez" to "𞤄𞤫𞤲𞤢𞥄𞤪𞤫",
    "bg" to "𞤄𞤭𞤤𞤺𞤢𞥄𞤪𞤫",
    "bgc" to "𞤖𞤢𞤪𞤴𞤢𞤲𞤾𞤭𞥅𞤪𞤫",
    "bho" to "𞤄𞤮𞤧𞤨𞤵𞤪𞤭𞥅𞤪𞤫",
    "bi" to "𞤄𞤭𞤧𞤤𞤢𞤥𞤢𞥄𞤪𞤫",
    "bin" to "𞤄𞤭𞤲𞤭𞥅𞤪𞤫",
    "bla" to "𞤅𞤭𞤳𞤧𞤭𞤳𞤢𞥄𞤪𞤫",
    "bm" to "𞤄𞤢𞤥𞤦𞤢𞤪𞤢𞥄𞤪𞤫",
    "bn" to "𞤄𞤫𞤲𞤺𞤢𞤤𞤭𞥅𞤪𞤫",
    "bo" to "𞤚𞤭𞤦𞤫𞤼𞤫𞤲𞤪𞤫",
    "br" to "𞤄𞤫𞤪𞤫𞤼𞤮𞤲𞤪𞤫",
    "brx" to "𞤄𞤮𞤣𞤮𞥅𞤪𞤫",
    "bs" to "𞤄𞤮𞤧𞤲𞤭𞤴𞤢𞥄𞤪𞤫",
    "bug" to "𞤄𞤵𞤺𞤭𞤧𞤢𞥄𞤪𞤫",
    "byn" to "𞤄𞤭𞤤𞤭𞤲𞤪𞤫",
    "ca" to "𞤑𞤢𞤼𞤢𞤤𞤢𞤲𞤪𞤫",
    "cay" to "𞤑𞤢𞤴𞤺𞤢𞥄𞤪𞤫",
    "ccp" to "𞤅𞤢𞤳𞤥𞤢𞥄𞤪𞤫",
    "ce" to "𞤕𞤫𞤷𞤫𞤲𞤪𞤫",
    "ceb" to "𞤅𞤫𞤦𞤱𞤢𞤲𞤮𞥅𞤪𞤫",
    "cgg" to "𞤕𞤭𞤺𞤢𞥄𞤪𞤫",
    "ch" to "𞤕𞤢𞤥𞤮𞤪𞤮𞥅𞤪𞤫",
    "chk" to "𞤕𞤵𞥅𞤳𞤵𞥅𞤪𞤫",
    "chm" to "𞤃𞤢𞤪𞤭𞥅𞤪𞤫",
    "cho" to "𞤕𞤢𞤸𞤼𞤢𞥄𞤪𞤫",
    "chp" to "𞤕𞤭𞤨𞤴𞤢𞤲𞤪𞤫",
    "chr" to "𞤕𞤫𞥅𞤪𞤮𞤳𞤭𞥅𞤪𞤫",
    "chy" to "𞤅𞤢𞥄𞤴𞤢𞤲𞤪𞤫",
    "ckb" to "𞤑𞤵𞤪𞤣𞤵𞥅𞤪𞤫",
    "ckb-alt-menu" to "𞤑𞤵𞤪𞤣𞤵𞥅𞤪𞤫",
    "ckb-alt-variant" to "𞤑𞤵𞤪𞤣𞤵𞥅𞤪𞤫 𞤅𞤮𞤪𞤢𞤲𞤭",
    "clc" to "𞤕𞤭𞤤𞤳𞤮𞤼𞤭𞤲𞤪𞤫",
    "co" to "𞤑𞤮𞤪𞤧𞤭𞤳𞤢𞥄𞤪𞤫",
    "crg" to "𞤃𞤭𞤷𞤭𞤬𞤪𞤫",
    "crj" to "𞤑𞤪𞤭𞥅𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞤲𞤳𞤮",
    "crk" to "𞤆𞤤𞤫𞤭𞤲𞤧 𞤑𞤪𞤭𞥅𞤪𞤫",
    "crl" to "Vote 𞤑𞤪𞤭𞥅𞤪𞤫 𞤐𞤢𞤲𞤬𞤵𞤯𞤲𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫",
    "crm" to "𞤃𞤮𞥅𞤧𞤫 𞤑𞤪𞤭𞥅𞤪𞤫",
    "crr" to "𞤀𞤤𞤺𞤮𞤲𞤳𞤭𞤲𞤪𞤫 𞤑𞤢𞥄𞤪𞤤𞤭𞤲𞤢",
    "cs" to "𞤕𞤫𞤳𞤧𞤭𞤲𞤢𞥄𞤪𞤫",
    "csw" to "𞤑𞤪𞤭𞥅𞤪𞤫 𞤅𞤢𞤱𞤨𞤭𞥅",
    "cu" to "𞤅𞤭𞤤𞤾𞤭𞤳𞤪𞤫 𞤕𞤮𞥅𞤷𞤭",
    "cv" to "𞤕𞤵𞥅𞤾𞤢𞤧𞤪𞤫",
    "cy" to "𞤘𞤢𞤤𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "da" to "𞤁𞤢𞥄𞤲𞤭𞤧𞤳𞤮𞥅𞤪𞤫",
    "dak" to "𞤁𞤢𞤳𞤮𞤼𞤢𞥄𞤪𞤫",
    "dar" to "𞤁𞤢𞤪𞤺𞤭𞤲𞤢𞥄𞤪𞤫",
    "dav" to "𞤚𞤢𞤭𞤼𞤢𞥄𞤪𞤫",
    "de" to "𞤔𞤫𞤪𞤥𞤢𞤲𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "de-AT" to "𞤔𞤫𞤪𞤥𞤢𞤲𞤭𞤲𞤳𞤮𞥅𞤪𞤫 𞤌𞤼𞤭𞤪𞤧𞤢",
    "de-CH" to "𞤔𞤫𞤪𞤥𞤢𞤲𞤭𞤲𞤳𞤮𞥅𞤪𞤫 𞤅𞤵𞤱𞤭𞥅𞤧",
    "dgr" to "𞤁𞤮𞤺𞤪𞤭𞤦𞤪𞤫",
    "dje" to "𞤔𞤢𞤪𞤥𞤢𞥄𞤪𞤫",
    "doi" to "𞤁𞤮𞤺𞤪𞤭𞥅𞤪𞤫",
    "dsb" to "𞤂𞤫𞤧 𞤅𞤮𞤪𞤦𞤭𞤴𞤢𞤲𞤪𞤫",
    "dua" to "𞤁𞤵𞤱𞤢𞤤𞤢𞥄𞤪𞤫",
    "dv" to "𞤁𞤭𞥅𞤬𞤫𞤸𞤭𞥅𞤪𞤫",
    "dyo" to "𞤔𞤮𞥅𞤤𞤢𞥄𞤪𞤫",
    "dz" to "𞤄𞤵𞥅𞤼𞤢𞤲𞤪𞤫",
    "dzg" to "𞤁𞤢𞤶𞤢𞤺𞤢𞥄𞤪𞤫",
    "ebu" to "𞤉𞤥𞤦𞤵𞥅𞤪𞤫",
    "ee" to "𞤉𞤱𞤫𞥅𞤪𞤫",
    "efi" to "𞤉𞤬𞤭𞤳𞤪𞤫",
    "eka" to "𞤉𞤳𞤢𞤶𞤵𞤳𞤪𞤫",
    "el" to "𞤘𞤭𞥅𞤪𞤧𞤢𞥄𞤪𞤫",
    "en" to "𞤉𞤲𞤺𞤭𞤤𞤫𞥅𞤪𞤫",
    "en-GB-alt-short" to "𞤉𞤲𞤺𞤭𞤤𞤫𞥅𞤪𞤫 𞤁𞤘",
    "en-US" to "𞤉𞤲𞤺𞤭𞤤𞤫𞥅𞤪𞤫 𞤀𞤥𞤫𞤪𞤭𞤳𞤢𞤲𞤳𞤮𞤪𞤫",
    "en-US-alt-short" to "𞤉𞤲𞤺𞤭𞤤𞤫𞥅𞤪𞤫 𞤁𞤂𞤀",
    "eo" to "𞤉𞤧𞤨𞤫𞤪𞤢𞤲𞤼𞤮𞥅𞤪𞤫",
    "es" to "𞤅𞤭𞤨𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫",
    "es-419" to "𞤅𞤭𞤨𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤀𞤥𞤭𞤪𞤭𞤳 𞤂𞤢𞤼𞤭𞤲𞤭𞤴𞤢",
    "es-ES" to "𞤅𞤭𞤨𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤀𞤪𞤮𞤦𞤢",
    "es-MX" to "𞤅𞤭𞤨𞤢𞤲𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤃𞤫𞤳𞤧𞤭𞤳",
    "et" to "𞤉𞤧𞤼𞤮𞤲𞤭𞤴𞤢𞤲𞤪𞤫",
    "eu" to "𞤄𞤢𞤧𞤳𞤢𞤪𞤢𞥄𞤪𞤫",
    "ewo" to "𞤉𞤱𞤮𞤲𞤣𞤮𞥅𞤪𞤫",
    "fa" to "𞤊𞤢𞥄𞤪𞤧𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫",
    "fa-AF" to "𞤁𞤢𞤪𞤭𞥅𞤪𞤫",
    "ff" to "𞤆𞤵𞤤𞤢𞤪",
    "fi" to "𞤊𞤫𞤲𞤭𞤧𞤪𞤫",
    "fil" to "𞤊𞤭𞤤𞤭𞤨𞤭𞤲𞤮𞥅𞤪𞤫",
    "fj" to "𞤊𞤭𞥅𞤶𞤭𞤴𞤢𞤲𞤪𞤫",
    "fo" to "𞤊𞤫𞤪𞤮𞤱𞤫𞤧𞤪𞤫",
    "fon" to "𞤊𞤮𞤲𞤪𞤫",
    "fr" to "𞤊𞤢𞤪𞤢𞤲𞤧𞤭𞥅𞤪𞤫",
    "fr-CA" to "𞤊𞤢𞤪𞤢𞤲𞤧𞤭𞥅𞤪𞤫 𞤑𞤢𞤲𞤢𞤣𞤢𞤲𞤳𞤮𞥅𞤪𞤫",
    "fr-CH" to "𞤊𞤢𞤪𞤢𞤲𞤧𞤭𞥅𞤪𞤫 𞤅𞤵𞤱𞤭𞥅𞤧",
    "frc" to "𞤊𞤢𞤪𞤢𞤲𞤧𞤭𞥅𞤪𞤫 𞤑𞤢𞤣𞤭𞤴𞤫𞤲𞤪𞤫",
    "frr" to "𞤊𞤭𞤪𞤧𞤭𞤴𞤢𞤲𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫",
    "fur" to "𞤊𞤭𞤪𞥇𞤵𞤤𞤭𞤴𞤢𞤲𞤪𞤫",
    "fy" to "𞤊𞤭𞤪𞤭𞥅𞤧𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤖𞤭𞤪𞤲𞤢",
    "ga" to "𞤋𞤪𞤤𞤢𞤲𞤣𞤫𞥅𞤪𞤫",
    "gaa" to "𞤘𞤢𞥄𞤪𞤫",
    "gd" to "𞤅𞤭𞤳𞤮𞤼𞤭𞤧𞤪𞤫 𞤘𞤢𞤫𞤭𞤳",
    "gez" to "𞤘𞤫𞥅𞤶𞤪𞤫",
    "gil" to "𞤘𞤭𞤤𞤦𞤫𞤪𞤼𞤫𞥅𞤧𞤪𞤫",
    "gl" to "𞤘𞤢𞤤𞤭𞥅𞤧𞤭𞤴𞤢𞤲𞤪𞤫",
    "gn" to "𞤘𞤵𞤢𞤪𞤢𞤲𞤭𞥅𞤪𞤫",
    "gor" to "𞤘𞤮𞤪𞤮𞤲𞤼𞤢𞤤𞤮𞥅𞤪𞤫",
    "gsw" to "𞤔𞤫𞤪𞤥𞤢𞤲𞤪𞤫 𞤅𞤵𞤱𞤭𞤧",
    "gu" to "𞤘𞤵𞤶𞤢𞤪𞤢𞤼𞤭𞥅𞤪𞤫",
    "guz" to "𞤘𞤵𞤧𞤭𞥅𞤪𞤫",
    "gv" to "𞤃𞤢𞤲𞤳𞤭𞤧𞤪𞤫",
    "gwi" to "𞤘𞤭𞤱𞤧𞤭𞤲𞤪𞤫",
    "ha" to "𞤖𞤢𞤱𞤧𞤢𞥄𞤪𞤫",
    "hai" to "𞤖𞤢𞤴𞤣𞤢𞥄𞤪𞤫",
    "haw" to "𞤖𞤢𞤱𞤢𞥄𞤭𞤴𞤫𞤲𞤪𞤫",
    "hax" to "𞤖𞤢𞤭𞤣𞤢𞥄𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞤲𞤳𞤮",
    "he" to "𞤖𞤭𞤦𞤵𞤪𞤵𞥅𞤪𞤫",
    "hi" to "𞤖𞤭𞤲𞤣𞤭𞥅𞤪𞤫",
    "hi-Latn-alt-variant" to "𞤖𞤭𞤲𞤺𞤭𞤤𞤭𞤧𞤭𞥅𞤪𞤫",
    "hil" to "𞤖𞤭𞤤𞤭𞤺𞤢𞤴𞤲𞤮𞤲𞤪𞤫",
    "hmn" to "𞤖𞤵𞤥𞤺𞤵𞤲𞤪𞤫",
    "hr" to "𞤑𞤮𞤪𞤮𞤱𞤢𞤧𞤭𞥅𞤪𞤫",
    "hsb" to "𞤅𞤮𞤪𞤦𞤭𞤴𞤢𞤲𞤪𞤫 𞤁𞤮𞤱𞤪𞤭",
    "ht" to "𞤀𞤳𞤵𞥅𞤪𞤫 𞤖𞤢𞤴𞤼𞤭𞥅",
    "hu" to "𞤖𞤵𞤲𞤺𞤢𞤪𞤭𞤴𞤢𞤲𞤪𞤫",
    "hup" to "𞤖𞤵𞤨𞤢𞥄𞤪𞤫",
    "hur" to "𞤖𞤢𞤤𞤳𞤮𞤥𞤫𞤤𞤫𞤥𞤪𞤫",
    "hy" to "𞤀𞤪𞤥𞤫𞤲𞤭𞥅𞤪𞤫",
    "hz" to "𞤖𞤫𞤪𞤫𞤪𞤮𞥅𞤪𞤫",
    "ia" to "𞤉𞤲𞤼𞤫𞤪𞤤𞤭𞤺𞤢𞥄𞤪𞤫",
    "iba" to "𞤋𞤦𞤢𞤲𞤪𞤫",
    "ibb" to "𞤋𞤦𞤭𞥅𞤦𞤭𞤴𞤮𞥅𞤪𞤫",
    "id" to "𞤋𞤲𞤣𞤮𞤲𞤭𞥅𞤧𞤭𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫",
    "ig" to "𞤋𞤦𞤮𞥅𞤪𞤫",
    "ii" to "𞤅𞤭𞤧𞤵𞤢𞤲𞤪𞤫 𞤒𞤭𞥅",
    "ikt" to "𞤋𞤲𞤵𞤳𞤼𞤵𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫 𞤑𞤢𞤲𞤢𞤣𞤢𞥄",
    "ilo" to "𞤋𞤤𞤮𞤳𞤮𞥅𞤪𞤫",
    "inh" to "𞤋𞤲𞤺𞤮𞤧𞤫𞥅𞤪𞤫",
    "io" to "𞤋𞤣𞤮𞥅𞤪𞤫",
    "is" to "𞤀𞤴𞤧𞤭𞤤𞤢𞤲𞤣𞤫𞥅𞤪𞤫",
    "it" to "𞤋𞤼𞤢𞤤𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "iu" to "𞤋𞤲𞤵𞤳𞤼𞤫𞥅𞤪𞤫",
    "ja" to "𞤐𞤭𞤨𞤮𞤲𞤪𞤫",
    "jbo" to "𞤂𞤮𞤶𞤦𞤢𞤲𞤪𞤫",
    "jgo" to "𞤐𞤺𞤮𞤥𞤦𞤢𞥄𞤪𞤫",
    "jmc" to "𞤃𞤢𞤳𞤢𞤥𞤫𞥅𞤪𞤫",
    "jv" to "𞤔𞤢𞥄𞤱𞤢𞤫𞥅𞤪𞤫",
    "ka" to "𞤔𞤮𞥅𞤪𞥁𞤭𞤴𞤢𞤲𞤪𞤫",
    "kab" to "𞤑𞤢𞤦𞤭𞤤𞤭𞥅𞤪𞤫",
    "kac" to "𞤑𞤢𞤧𞤭𞤲𞤪𞤫",
    "kaj" to "𞤑𞤢𞤶𞤫𞥅𞤪𞤫",
    "kam" to "𞤑𞤢𞤥𞤦𞤢𞥄𞤪𞤫",
    "kbd" to "𞤑𞤢𞤦𞤢𞤪𞤣𞤭𞤴𞤢𞤲𞤪𞤫",
    "kcg" to "𞤚𞤵𞤴𞤢𞤨𞤵𞥅𞤪𞤫",
    "kde" to "𞤃𞤢𞤳𞤮𞤲𞤣𞤫𞥅𞤪𞤫",
    "kea" to "𞤑𞤢𞤦𞤵𞤾𞤫𞤪𞤣𞤭𞤴𞤢𞤲𞤪𞤫",
    "kfo" to "𞤑𞤮𞤪𞤮𞥅𞤪𞤫",
    "kgp" to "𞤑𞤢𞤭𞤲𞤺𞤢𞤲𞤺𞤪𞤫",
    "kha" to "𞤝𞤢𞤧𞤭𞥅𞤪𞤫",
    "khq" to "𞤑𞤮𞤴𞤪𞤢𞤷𞤭𞤲𞤪𞤫",
    "ki" to "𞤑𞤭𞤳𞤵𞤴𞤵𞥅𞤪𞤫",
    "kj" to "𞤑𞤵𞤢𞤻𞤢𞤥𞤢𞥄𞤪𞤫",
    "kk" to "𞤑𞤢𞥁𞤢𞤳𞤪𞤫",
    "kkj" to "𞤑𞤢𞤳𞤮𞥅𞤪𞤫",
    "kl" to "𞤑𞤢𞤤𞤢𞥄𞤤𞤧𞤵𞤼𞤪𞤫",
    "kln" to "𞤑𞤢𞤤𞤫𞤲𞤶𞤭𞤲𞤪𞤫",
    "km" to "𞤑𞤵𞤥𞤢𞤴𞤪𞤫",
    "kmb" to "𞤑𞤭𞤥𞤦𞤵𞤲𞤣𞤵𞥅𞤪𞤫",
    "kn" to "𞤑𞤢𞤲𞥆𞤢𞤣𞤢𞥄𞤪𞤫",
    "ko" to "𞤑𞤮𞥅𞤪𞤫𞤴𞤢𞤲𞤪𞤫",
    "kok" to "𞤑𞤮𞤲𞤳𞤢𞤲𞤭𞥅𞤪𞤫",
    "kpe" to "𞤘𞤫𞤪𞤧𞤫𞥅𞤪𞤫",
    "kr" to "𞤑𞤮𞥅𞤤𞤫𞥅𞤪𞤫",
    "krc" to "𞤑𞤢𞤪𞤢𞤧𞤢𞤴-𞤄𞤢𞤤𞤳𞤢𞥄𞤪𞤫",
    "krl" to "𞤑𞤢𞤪𞤫𞤤𞤭𞤢𞤲𞤪𞤫",
    "kru" to "𞤑𞤵𞤪𞤵𞤿𞤵𞥅𞤪𞤫",
    "ks" to "𞤑𞤢𞥃𞤥𞤭𞥅𞤪𞤫",
    "ksb" to "𞤅𞤢𞤥𞤦𞤢𞤤𞤢𞥄𞤪𞤫",
    "ksf" to "𞤄𞤢𞤬𞤭𞤴𞤢𞥄𞤪𞤫",
    "ksh" to "𞤑𞤮𞤤𞤮𞤺𞤲𞤭𞤴𞤢𞤲𞤪𞤫",
    "ku" to "𞤑𞤵𞤪𞤣𞤭𞤧𞤭𞥅𞤪𞤫",
    "kum" to "𞤑𞤵𞤥𞤴𞤢𞤳𞤪𞤫",
    "kv" to "𞤑𞤮𞤥𞤭𞥅𞤪𞤫",
    "kw" to "𞤑𞤮𞤪𞤲𞤭𞥅𞤪𞤫",
    "kwk" to "𞤑𞤢𞤱𞤳𞥇𞤱𞤢𞤤𞤢𞥄𞤪𞤫",
    "ky" to "𞤑𞤭𞤪𞤺𞤵𞥅𞤪𞤫",
    "la" to "𞤂𞤢𞤼𞤫𞤲𞤪𞤫",
    "lad" to "𞤂𞤢𞤣𞤭𞤲𞤮𞥅𞤪𞤫",
    "lag" to "𞤂𞤢𞤲𞤺𞤭𞥅𞤪𞤫",
    "lb" to "𞤂𞤵𞥁𞤫𞤲𞤦𞤵𞥅𞤪𞤺𞤭𞤧𞤪𞤫",
    "lez" to "𞤂𞤫𞥁𞤺𞤭𞤴𞤢𞤲𞤪𞤫",
    "lg" to "𞤘𞤢𞤲𞤣𞤢𞥄𞤪𞤫",
    "li" to "𞤂𞤭𞤥𞤦𞤵𞤪𞤺𞤵𞤧𞤪𞤫",
    "lij" to "𞤂𞤳𞤭𞤺𞤵𞥅𞤪𞤫",
    "lil" to "𞤂𞤭𞤤𞥆𞤮𞥅𞤫𞤼𞤪𞤫",
    "lkt" to "𞤂𞤢𞤳𞤮𞤼𞤢𞥄𞤪𞤫",
    "lmo" to "𞤂𞤮𞤥𞤦𞤢𞤪𞤣𞤫",
    "ln" to "𞤂𞤭𞤲𞤺𞤢𞤤𞤢𞥄𞤪𞤫",
    "lo" to "𞤂𞤢𞤮𞥅𞤪𞤫",
    "lou" to "𞤀𞤳𞤵𞥅𞤪𞤫 𞤂𞤵𞥅𞥁𞤭𞤴𞤢𞥄𞤲𞤢",
    "loz" to "𞤂𞤮𞥁𞤭𞥅𞤪𞤫",
    "lrc" to "𞤂𞤵𞤪𞤭𞥅𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫",
    "lsm" to "𞤅𞤢𞥄𞤥𞤭𞤢𞥄𞤪𞤫",
    "lt" to "𞤂𞤭𞤼𞤮𞤲𞤭𞤴𞤢𞤲𞤪𞤫",
    "lu" to "𞤂𞤵𞤦𞤢-𞤑𞤢𞤼𞤢𞤲𞤺𞤢𞥄𞤪𞤫",
    "lua" to "𞤂𞤵𞤦𞤢 𞤑𞤢𞤧𞤢𞤭𞤪𞤫",
    "lun" to "𞤂𞤵𞤲𞤣𞤢𞥄𞤪𞤫",
    "luo" to "𞤂𞤵𞤮𞥅𞤪𞤫",
    "lus" to "𞤃𞤭𞤧𞤮𞥅𞤪𞤫",
    "luy" to "𞤂𞤵𞤴𞤭𞤢𞥄𞤪𞤫",
    "lv" to "𞤂𞤢𞤼𞤾𞤭𞤴𞤢𞤲𞤪𞤫",
    "mad" to "𞤃𞤢𞤣𞤵𞤪𞤫𞥅𞤪𞤫",
    "mag" to "𞤃𞤢𞤺𞤢𞤸𞤭𞥅𞤪𞤫",
    "mai" to "𞤃𞤢𞤴𞤭𞤼𞤭𞤤𞤭𞥅𞤪𞤫",
    "mak" to "𞤃𞤢𞤳𞤢𞤧𞤢𞤪𞤢𞥄𞤪𞤫",
    "mas" to "𞤃𞤢𞤧𞤢𞤴𞤭𞥅𞤪𞤫",
    "mdf" to "𞤃𞤮𞤳𞤧𞤢𞤲𞤳𞤮𞥅𞤪𞤫",
    "men" to "𞤃𞤫𞤲𞤣𞤫𞥅𞤪𞤫",
    "mer" to "𞤃𞤫𞤪𞤵𞥅𞤪𞤫",
    "mfe" to "𞤃𞤮𞤪𞤭𞥅𞤧𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "mg" to "𞤃𞤢𞤤𞤢𞤺𞤢𞤧𞤭𞥅𞤪𞤫",
    "mgh" to "𞤃𞤢𞤳𞤵𞤱𞤢𞥄𞤪𞤫",
    "mgo" to "𞤃𞤫𞤼𞤢𞥄𞤪𞤫",
    "mh" to "𞤃𞤢𞤪𞤧𞤢𞤤𞤫𞥅𞤪𞤫",
    "mi" to "𞤃𞤢𞥄𞤮𞤪𞤭𞥅𞤪𞤫",
    "mic" to "𞤃𞤭𞤳𞤥𞤢𞤹𞤵𞥅𞤪𞤫",
    "min" to "𞤃𞤭𞤲𞤢𞤲𞤺𞤳𞤢𞤦𞤢𞤵𞥅𞤪𞤫",
    "mk" to "𞤃𞤢𞤧𞤫𞤣𞤮𞤲𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "ml" to "𞤃𞤢𞤤𞤢𞤴𞤢𞤤𞤢𞤥𞤪𞤫",
    "mn" to "𞤃𞤮𞤲𞤺𞤮𞤤𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "mni" to "𞤃𞤢𞤲𞤭𞤨𞤵𞥅𞤪𞤫",
    "moe" to "𞤋𞤲𞥆𞤵-𞤢𞤴𞤥𞤵𞤲𞤪𞤫",
    "moh" to "𞤃𞤮𞥅𞤸𞤢𞤲𞤳𞤮𞥅𞤪𞤫",
    "mos" to "𞤃𞤮𞥅𞤧𞤭𞥅𞤪𞤫",
    "mr" to "𞤃𞤢𞤪𞤢𞤼𞤭𞥅𞤪𞤫",
    "ms" to "𞤃𞤢𞤤𞤫𞥅𞤪𞤫",
    "mt" to "𞤃𞤢𞤤𞤼𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "mua" to "𞤃𞤵𞤲𞤣𞤢𞤲𞤪𞤫",
    "mul" to "𞤍𞤫𞤲𞤯𞤫 𞤅𞤫𞤪𞤼𞤵𞤯𞤫",
    "mus" to "𞤃𞤵𞤧𞤳𞤮𞤳𞤭𞥅𞤪𞤫",
    "mwl" to "𞤃𞤭𞤪𞤢𞤲𞤣𞤫𞥅𞤪𞤫",
    "my" to "𞤄𞤵𞤪𞤥𞤢𞥄𞤪𞤫",
    "myv" to "𞤉𞤪𞤶𞤭𞤴𞤢𞤲𞤪𞤫",
    "mzn" to "𞤃𞤢𞥁𞤢𞤲𞤣𞤫𞤪𞤢𞤲𞤭𞥅𞤪𞤫",
    "na" to "𞤐𞤢𞤱𞤵𞤪𞤵𞤲𞤳𞤮𞥅𞤪𞤫",
    "nap" to "𞤐𞤢𞥄𞤨𞤮𞤤𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "naq" to "𞤐𞤢𞤥𞤢𞥄𞤪𞤫",
    "nb" to "𞤐𞤮𞤪𞤱𞤫𞤶𞤭𞤴𞤢𞤲𞤪𞤫 𞤄𞤮𞤳𞤥𞤢𞤤",
    "nd" to "𞤐𞤣𞤫𞤦𞤫𞤤𞤫𞥅𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤺𞤫",
    "nds" to "𞤂𞤫𞤧-𞤀𞤤𞤵𞤥𞤢𞤲𞤪𞤫",
    "nds-NL" to "𞤂𞤫𞤧 𞤅𞤢𞤳𞤧𞤮𞤲𞤪𞤫",
    "ne" to "𞤐𞤫𞤨𞤢𞤤𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "new" to "𞤐𞤫𞤱𞤢𞤪𞤭𞥅𞤪𞤫",
    "ng" to "𞤐𞤣𞤮𞤲𞤺𞤢𞥄𞤪𞤫",
    "nia" to "𞤙𞤢𞤧𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "niu" to "𞤐𞤭𞤵𞤫𞤴𞤢𞤲𞤪𞤫",
    "nl" to "𞤁𞤮𞥅𞤷𞤵𞤪𞤫",
    "nl-BE" to "𞤊𞤭𞤤𞤢𞤥𞤢𞤲𞤪𞤫",
    "nmg" to "𞤐𞤺𞤵𞤥𞤦𞤢𞥄𞤪𞤫",
    "nn" to "𞤐𞤮𞤪𞤱𞤫𞤶𞤭𞤴𞤢𞤲𞤪𞤫 𞤙𞤮𞤪𞤧𞤳",
    "nnh" to "𞤐𞤶𞤢𞤥𞤦𞤵𞥅𞤪𞤫",
    "no" to "𞤐𞤮𞤪𞤱𞤫𞤶𞤭𞤴𞤢𞤲𞤪𞤫",
    "nog" to "𞤐𞤮𞤺𞤢𞤭𞥅𞤪𞤫",
    "nqo" to "𞤐𞤳𞤮𞥅𞤪𞤫",
    "nr" to "𞤐𞤣𞤫𞤦𞤫𞤤𞤫𞥅𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫",
    "nso" to "𞤅𞤮𞤼𞤮𞥅𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫",
    "nus" to "𞤐𞤵𞤫𞤪𞤭𞥅𞤪𞤫",
    "nv" to "𞤐𞤢𞤬𞤱𞤢𞤸𞤮𞥅𞤪𞤫",
    "ny" to "𞤙𞤢𞤲𞤶𞤢𞥄𞤪𞤫",
    "nyn" to "𞤙𞤢𞤲𞤳𞤮𞤤𞤫𞥅𞤪𞤫",
    "oc" to "𞤌𞤷𞥆𞤭𞤼𞤢𞤲𞤪𞤫",
    "ojb" to "𞤌𞤶𞤭𞤦𞤵𞤱𞤢𞥄𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫",
    "ojc" to "𞤌𞤶𞤭𞤦𞤵𞤱𞤪𞤫 𞤕𞤢𞤳𞤢",
    "ojs" to "𞤌𞤶𞤭-𞤑𞤪𞤭𞥅𞤪𞤫",
    "ojw" to "𞤌𞤶𞤭𞤦𞤱𞤢𞥄𞤪𞤫 𞤖𞤭𞥅𞤪𞤲𞤢𞥄𞤲𞤺𞤫",
    "oka" to "𞤌𞤳𞤢𞤲𞤢𞤺𞤢𞤲𞤪𞤫",
    "om" to "𞤌𞤪𞤮𞤥𞤮𞥅𞤪𞤫",
    "or" to "𞤌𞤣𞤭𞤢𞥄𞤪𞤫",
    "os" to "𞤌𞤧𞥆𞤫𞤼𞤭𞤳𞤪𞤫",
    "pa" to "𞤆𞤵𞤲𞤶𞤢𞥄𞤦𞤭𞥅𞤪𞤫",
    "pag" to "𞤆𞤢𞤲𞤺𞤢𞤧𞤭𞤲𞤢𞤲𞤪𞤫",
    "pam" to "𞤆𞤢𞤥𞤨𞤢𞤲𞤺𞤢𞥄𞤪𞤫",
    "pap" to "𞤆𞤢𞤨𞤭𞤢𞤥𞤫𞤲𞤼𞤮𞥅𞤪𞤫",
    "pau" to "𞤆𞤢𞤤𞤢𞤵𞤴𞤢𞤲𞤪𞤫",
    "pcm" to "𞤆𞤭𞤶𞤫𞤲𞤪𞤫 𞤐𞤢𞤶𞤭𞤪𞤭𞤴𞤢𞥄",
    "pis" to "𞤆𞤭𞤶𞤭𞤲𞤪𞤫",
    "pl" to "𞤆𞤮𞤤𞤢𞤲𞤣𞤭𞥅𞤪𞤫",
    "pqm" to "𞤃𞤢𞤤𞤭𞤧𞤫𞥅𞤼-𞤆𞤢𞤧𞤢𞤥𞤢𞤹𞤵𞤮𞤣𞥆𞤭",
    "prg" to "𞤆𞤵𞤪𞤧𞤭𞤴𞤢𞤲𞤪𞤫",
    "ps" to "𞤆𞤢𞤧𞤼𞤵𞤲𞤪𞤫",
    "pt" to "𞤆𞤮𞤪𞤼𞤮𞤳𞤫𞥅𞤧𞤭𞥅𞤪𞤫",
    "pt-BR" to "𞤆𞤮𞤪𞤼𞤮𞤳𞤫𞥅𞤧𞤭𞥅𞤪𞤫 𞤄𞤪𞤫𞥁𞤭𞤤",
    "pt-PT" to "𞤆𞤮𞤪𞤼𞤮𞤳𞤫𞥅𞤧𞤭𞥅𞤪𞤫 𞤆𞤮𞤪𞤼𞤭𞤺𞤢𞥄𞤤",
    "qu" to "𞤗𞤵𞤷𞤵𞤢𞤲𞤪𞤫",
    "raj" to "𞤈𞤢𞤶𞤢𞤧𞤼𞤢𞤲𞤭𞥅𞤪𞤫",
    "rap" to "𞤈𞤢𞤨𞤢𞤲𞤵𞤭𞥅𞤪𞤫",
    "rar" to "𞤈𞤢𞤪𞤮𞤼𞤮𞤲𞤺𞤢𞤲𞤪𞤫",
    "rhg" to "𞤈𞤮𞤸𞤭𞤲𞤺𞤢𞥄𞤪𞤫",
    "rif" to "𞤈𞤭𞤬𞤭𞤴𞤢𞤲𞤪𞤫",
    "rm" to "𞤈𞤮𞤥𞤢𞤲𞤧𞤪𞤫",
    "rn" to "𞤈𞤵𞤲𞤣𞤭𞥅𞤪𞤫",
    "ro" to "𞤈𞤮𞤥𞤢𞤲𞤭𞤴𞤢𞤲𞤪𞤫",
    "ro-MD" to "𞤃𞤮𞤤𞤣𞤢𞤾𞤭𞤴𞤢𞤲𞤪𞤫",
    "rof" to "𞤈𞤮𞤥𞤦𞤮𞥅𞤪𞤫",
    "ru" to "𞤈𞤮𞥅𞤧𞤭𞤴𞤢𞤲𞤪𞤫",
    "rup" to "𞤀𞤪𞤮𞤥𞤢𞤲𞤭𞥅𞤪𞤫",
    "rw" to "𞤑𞤭𞤻𞤭𞤪𞤵𞤱𞤢𞤲𞤣𞤫𞥅𞤪𞤫",
    "rwk" to "𞤈𞤵𞤱𞤢𞥄𞤪𞤫",
    "sa" to "𞤅𞤢𞤲𞤧𞤳𞤪𞤭𞤼𞤪𞤫",
    "sad" to "𞤅𞤢𞤲𞤣𞤢𞤱𞤫𞥅𞤪𞤫",
    "sah" to "𞤅𞤢𞤿𞤢𞥄𞤪𞤫",
    "saq" to "𞤅𞤢𞤥𞤦𞤵𞤪𞤵𞥅𞤪𞤫",
    "sat" to "𞤅𞤢𞤲𞤼𞤢𞤤𞤭𞥅𞤪𞤫",
    "sba" to "𞤐𞤺𞤢𞤥𞤦𞤢𞤴𞤪𞤫",
    "sbp" to "𞤅𞤢𞤲𞤺𞤵𞥅𞤪𞤫",
    "sc" to "𞤅𞤢𞤪𞤣𞤭𞤲𞤭𞤴𞤢𞤲𞤪𞤫",
    "scn" to "𞤅𞤭𞤧𞤭𞤤𞤭𞤴𞤢𞤲𞤪𞤫",
    "sco" to "𞤅𞤭𞤳𞤮𞤼𞤧𞤪𞤫",
    "sd" to "𞤅𞤭𞤲𞤣𞤢𞥄𞤪𞤫",
    "se" to "𞤅𞤢𞤥𞤭𞥅𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫",
    "seh" to "𞤅𞤫𞤲𞤢𞥄𞤪𞤫",
    "ses" to "𞤑𞤮𞤪𞤮𞤦𞤮𞤪𞤮𞥅𞤪𞤫 𞤅𞤫𞤲𞥆𞤭",
    "sg" to "𞤅𞤢𞤲𞤺𞤮𞥅𞤪𞤫",
    "shi" to "𞤚𞤢𞤧𞤭𞤤𞤸𞤭𞤼𞤪𞤫",
    "shn" to "𞤅𞤢𞤲𞤪𞤫",
    "si" to "𞤅𞤭𞤲𞤸𞤢𞤤𞤢𞥄𞤪𞤫",
    "sk" to "𞤅𞤤𞤮𞤾𞤢𞥄𞤳𞤪𞤫",
    "sl" to "𞤅𞤤𞤮𞤾𞤫𞤲𞤭𞤴𞤢𞤲𞤪𞤫",
    "slh" to "𞤂𞤵𞥃𞤵𞤼𞤧𞤭𞤣𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞤲𞤳𞤮",
    "sm" to "𞤅𞤢𞤥𞤮𞤢𞤲𞤪𞤫",
    "smn" to "𞤋𞤲𞤢𞤪𞤭𞤧𞤳𞤢𞤤𞤭𞥅𞤪𞤫",
    "sms" to "𞤅𞤭𞤳𞤮𞤤𞤼 𞤅𞤢𞤥𞤭𞥅𞤪𞤫",
    "sn" to "𞤅𞤮𞤲𞤢𞥄𞤪𞤫",
    "snk" to "𞤅𞤢𞤪𞤢𞤲𞤳𞤵𞤤𞥆𞤪𞤫",
    "so" to "𞤅𞤮𞤥𞤢𞤤𞤭𞥅𞤪𞤫",
    "sq" to "𞤀𞤤𞤦𞤢𞤲𞤭𞥅𞤪𞤫",
    "sr" to "𞤅𞤫𞤪𞤦𞤭𞤴𞤢𞤲𞤪𞤫",
    "srn" to "𞤅𞤢𞤪𞤲𞤢𞤲-𞤚𞤮𞤲𞤺𞤮𞥅𞤪𞤫",
    "ss" to "𞤅𞤵𞤱𞤢𞤼𞤭𞥅𞤪𞤫",
    "st" to "𞤅𞤮𞤼𞤮𞥅𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫𞤲𞤳𞤮",
    "str" to "𞤅𞤭𞤼𞤪𞤭𞤼 𞤅𞤢𞤤𞤭𞤧𞤪𞤫",
    "su" to "𞤅𞤵𞤲𞤣𞤢𞤲𞤭𞥅𞤪𞤫",
    "suk" to "𞤅𞤵𞤳𞤵𞤥𞤢𞥄𞤪𞤫",
    "sv" to "𞤅𞤱𞤫𞤣𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "sw" to "𞤅𞤵𞤱𞤢𞤸𞤭𞤤𞤭𞥅𞤪𞤫",
    "sw-CD" to "𞤅𞤵𞤱𞤢𞤸𞤭𞤤𞤭𞥅𞤪𞤫 𞤑𞤮𞤲𞤺𞤮 𞤑𞤭𞤲𞤧𞤢𞤧𞤢",
    "swb" to "𞤑𞤮𞤥𞤮𞤪𞤭𞥅𞤪𞤫",
    "syr" to "𞤅𞤭𞥅𞤪𞤭𞤴𞤢𞤳𞤪𞤫",
    "ta" to "𞤚𞤢𞤥𞤵𞤤𞤪𞤫",
    "tce" to "𞤚𞤵𞤼𞤳𞤮𞤲𞤭𞥅𞤪𞤫 𞤙𞤢𞥄𞤥𞤲𞤢𞥄𞤲𞤺𞤫",
    "te" to "𞤚𞤫𞤤𞤫𞤺𞤵𞥅𞤪𞤫",
    "tem" to "𞤚𞤫𞤥𞤫𞤲𞤫𞥅𞤪𞤫",
    "teo" to "𞤚𞤫𞤧𞤮𞥅𞤪𞤫",
    "tet" to "𞤚𞤫𞤼𞤵𞤥𞤪𞤫",
    "tg" to "𞤚𞤢𞤶𞤭𞤳𞤪𞤫",
    "tgx" to "𞤚𞤢𞤺𞤭𞥃𞤪𞤫",
    "th" to "𞤚𞤢𞤴𞤤𞤢𞤲𞤣𞤫𞥅𞤪𞤫",
    "tht" to "𞤚𞤢𞤸𞤢𞤤𞤼𞤢𞤲𞤪𞤫",
    "ti" to "𞤚𞤭𞤺𞤭𞤪𞤻𞤢𞥄𞤪𞤫",
    "tig" to "𞤚𞤭𞤺𞤭𞤪𞤴𞤢𞤲𞤪𞤫",
    "tk" to "𞤼𞤵𞤪𞤳𞤥𞤢𞤲𞤪𞤫",
    "tlh" to "𞤑𞤭𞤤𞤭𞤲𞤺𞤮𞤲𞤪𞤫",
    "tli" to "𞤚𞤤𞤭𞤲𞤺𞤭𞤼𞤪𞤫",
    "tn" to "𞤚𞤭𞤧𞤱𞤢𞤲𞤢𞥄𞤪𞤫",
    "to" to "𞤚𞤮𞤲𞤺𞤢𞤲𞤪𞤫",
    "tok" to "𞤚𞤮𞤳𞤭 𞤆𞤮𞤲𞤢𞥄𞤪𞤫",
    "tpi" to "𞤚𞤮𞤳 𞤆𞤭𞤧𞤭𞤲𞤪𞤫",
    "tr" to "𞤚𞤵𞥅𞤪𞤢𞤲𞤳𞤮𞥅𞤪𞤫",
    "trv" to "𞤚𞤢𞤪𞤮𞤳𞤮𞥅𞤪𞤫",
    "ts" to "𞤚𞤭𞤧𞤮𞤲𞤺𞤢𞥄𞤪𞤫",
    "tt" to "𞤚𞤢𞤼𞤢𞤪𞥇𞤪𞤫",
    "ttm" to "𞤚𞤵𞤼𞤷𞤮𞤲𞤫𞤲𞤪𞤫 𞤐𞤢𞤲𞥆𞤢𞥄𞤲𞤺𞤫𞥅𞤪𞤫",
    "tum" to "𞤚𞤵𞤥𞤦𞤵𞤳𞤢𞥄𞤪𞤫",
    "tvl" to "𞤚𞤵𞤾𞤢𞤤𞤵𞥅𞤪𞤫",
    "twq" to "𞤚𞤢𞤧𞤢𞥄𞤹𞤪𞤫",
    "ty" to "𞤚𞤢𞤸𞤭𞤼𞤭𞤴𞤢𞤲𞤪𞤫",
    "tyv" to "𞤚𞤵𞤾𞤭𞤲𞤭𞤴𞤢𞤲𞤪𞤫",
    "tzm" to "𞤚𞤢𞤥𞤢𞤶𞤭𞤼𞤪𞤫 𞤅𞤢𞤲𞤼𞤪𞤢𞤤 𞤀𞤼𞤤𞤢𞤧",
    "udm" to "𞤓𞤣𞤥𞤵𞤪𞤼𞤪𞤫",
    "ug" to "𞤓𞥅𞤴𞤺𞤵𞥅𞤪𞤫",
    "uk" to "𞤒𞤵𞤳𞤪𞤫𞤲𞤭𞤴𞤢𞤲𞤪𞤫",
    "umb" to "𞤓𞤥𞤦𞤵𞤲𞤣𞤵𞥅𞤪𞤫",
    "und" to "𞤍𞤫𞤲𞤺𞤢𞤤 𞤢𞤧-𞤢𞤲𞤣𞤢𞥄𞤲𞤺𞤢𞤤",
    "ur" to "𞤓𞤪𞤣𞤵𞥅𞤪𞤫",
    "uz" to "𞤓𞥅𞤧𞤦𞤫𞤳𞤪𞤫",
    "vai" to "𞤾𞤢𞥄𞤴𞤪𞤫",
    "ve" to "𞤏𞤫𞤲𞤣𞤢𞥄𞤪𞤫",
    "vec" to "𞤏𞤫𞤲𞤭𞥅𞤧𞤴𞤢𞤲𞤳𞤮𞥅𞤪𞤫",
    "vi" to "𞤏𞤭𞤴𞤫𞤼𞤲𞤢𞤥𞤭𞤲𞤳𞤮𞥅𞤪𞤫",
    "vo" to "𞤏𞤮𞤤𞤢𞤨𞤵𞤳𞤪𞤫",
    "vun" to "𞤏𞤵𞤲𞤶𞤮𞥅𞤪𞤫",
    "wa" to "𞤏𞤢𞥄𞤤𞤮𞤲𞤳𞤮𞥅𞤪𞤫",
    "wae" to "𞤏𞤢𞤤𞤧𞤫𞥅𞤪𞤫",
    "wal" to "𞤏𞤮𞥅𞤤𞤢𞤴𞤼𞤢𞥄𞤪𞤫",
    "war" to "𞤏𞤢𞤪𞤢𞤴𞤫𞥅𞤪𞤫",
    "wo" to "𞤏𞤮𞤤𞤮𞤬𞤪𞤫",
    "wuu" to "𞤏𞤵𞥅𞤪𞤫 𞤅𞤭𞥅𞤲",
    "xal" to "𞤑𞤢𞤤𞤥𞤵𞤳𞤪𞤫",
    "xh" to "𞤑𞤮𞥅𞤧𞤢𞥄𞤪𞤫",
    "xog" to "𞤅𞤮𞤺𞤢𞥄𞤪𞤫",
    "yav" to "𞤒𞤢𞤲𞤺𞤦𞤫𞥅𞤪𞤫",
    "ybb" to "𞤒𞤫𞤥𞤦𞤢𞥄𞤪𞤫",
    "yi" to "𞤒𞤭𞤣𞤭𞤧𞤢𞤲𞤳𞤮𞥅𞤪𞤫",
    "yo" to "𞤒𞤮𞥅𞤪𞤵𞤦𞤢𞥄𞤪𞤫",
    "yrl" to "𞤛𞤫𞥅𞤲𞤺𞤢𞤼𞤵𞥅𞤪𞤫",
    "yue" to "𞤑𞤢𞤲𞤼𞤮𞤲𞤫𞥅𞤪𞤫",
    "yue-alt-menu" to "𞤑𞤢𞤲𞤼𞤮𞤲𞤫𞥅𞤪𞤫 𞤅𞤭𞥅𞤲",
    "zgh" to "𞤚𞤢𞤥𞤢𞥁𞤭𞤼𞤪𞤫 𞤖𞤢𞤲𞤼𞤵𞤲𞥋𞤣𞤫 𞤃𞤢𞤪𞤮𞥅𞤳",
    "zh" to "𞤕𞤢𞤴𞤲𞤢𞤲𞤳𞤮𞥅𞤪𞤫",
    "zh-alt-menu" to "𞤕𞤢𞤴𞤲𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤃𞤢𞤲𞤣𞤢𞤪𞤫𞤲𞤪𞤫",
    "zh-Hans" to "𞤕𞤢𞤴𞤲𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤖𞤮𞤴𞤬𞤭𞤲𞤢𞥄𞤲𞤣𞤫",
    "zh-Hans-alt-long" to "𞤃𞤢𞤲𞤣𞤢𞤪𞤫𞤲𞤪𞤫 𞤖𞤮𞤴𞤬𞤭𞤲𞤢𞥄𞤲𞤣𞤫",
    "zh-Hant" to "𞤕𞤢𞤴𞤲𞤢𞤲𞤳𞤮𞥅𞤪𞤫 𞤒𞤫𞤷𞥆𞤵𞤲𞥋𞤣𞤫",
    "zh-Hant-alt-long" to "𞤃𞤢𞤲𞤣𞤢𞤪𞤫𞤲𞤪𞤫 𞤀𞤪𞤣𞤭𞥅𞤲𞤣𞤫",
    "zu" to "𞥁𞤵𞤤𞤵𞥅𞤪𞤫",
    "zun" to "𞤟𞤵𞤲𞤭𞥅𞤪𞤫",
    "zxx" to "𞤀𞤤𞤢𞥄 𞤦𞤢𞤯𞤮𞤪𞤢𞤤 𞤯𞤫𞤲𞤯𞤢𞤲𞤳𞤮",
    "zza" to "𞤟𞤢𞥁𞤢𞥄𞤪𞤫",
  ) }

  val ff_Adlm_BF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_GM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_GW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_LR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_NG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_SL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Adlm_SN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Akaan",
    "am" to "Amarik",
    "ar" to "Aarabeere",
    "be" to "Belaruuse",
    "bg" to "Bulgariire",
    "bn" to "Bengali",
    "cs" to "Cekkere",
    "de" to "Docceere",
    "el" to "Gerke",
    "en" to "Engeleere",
    "es" to "Español",
    "fa" to "Perseere",
    "ff" to "Pulaar",
    "fr" to "Farayseere",
    "ha" to "Hawsaŋkoore",
    "hi" to "Hinndi",
    "hu" to "Hongariire",
    "id" to "Endonesiire",
    "ig" to "Igiboore",
    "it" to "Italiyeere",
    "ja" to "Saponeere",
    "jv" to "Sawaneere",
    "km" to "Kemeere",
    "ko" to "Koreere",
    "ms" to "Malayeere",
    "my" to "Burmeese",
    "ne" to "Nepaaleere",
    "nl" to "Dacceere",
    "pa" to "Punjabeere",
    "pl" to "Poloneere",
    "pt" to "Purtugeere",
    "ro" to "Romaneere",
    "ru" to "Riis",
    "rw" to "Ruwaanndeere",
    "so" to "Somalii",
    "sv" to "Sweedeere",
    "ta" to "Tamil",
    "th" to "Taay",
    "tr" to "Turkeere",
    "uk" to "Ukereneere",
    "ur" to "Urdu",
    "vi" to "Wiyetnameere",
    "yo" to "Yorrubaa",
    "zh" to "Sinuwaare",
    "zh-alt-menu" to "Sinuwaare",
    "zu" to "Suluŋkoore",
  ) }

  val ff_Latn_BF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_GW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_LR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_NG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ff_Latn_SL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fi: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abhaasi",
    "ace" to "atšeh",
    "ach" to "atšoli",
    "ada" to "adangme",
    "ady" to "adyge",
    "ae" to "avesta",
    "aeb" to "tunisianarabia",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainu",
    "ajp" to "urduni",
    "ak" to "akan",
    "akk" to "akkadi",
    "akz" to "alabama",
    "ale" to "aleutti",
    "aln" to "gegi",
    "alt" to "altai",
    "am" to "amhara",
    "an" to "aragonia",
    "ang" to "muinaisenglanti",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "arabia",
    "ar-001" to "yleisarabia",
    "arc" to "valtakunnanaramea",
    "arn" to "mapudungun",
    "aro" to "araona",
    "arp" to "arapaho",
    "arq" to "algerianarabia",
    "ars" to "arabia – najd",
    "arw" to "arawak",
    "ary" to "marokonarabia",
    "arz" to "egyptinarabia",
    "as" to "assami",
    "asa" to "asu",
    "ase" to "amerikkalainen viittomakieli",
    "ast" to "asturia",
    "atj" to "atikamekw",
    "av" to "avaari",
    "avk" to "kotava",
    "awa" to "awadhi",
    "ay" to "aimara",
    "az" to "azeri",
    "az-alt-short" to "azeri",
    "ba" to "baškiiri",
    "bal" to "belutši",
    "ban" to "bali",
    "bar" to "baijeri",
    "bas" to "basaa",
    "bax" to "bamum",
    "bbc" to "batak-toba",
    "bbj" to "ghomala",
    "be" to "valkovenäjä",
    "bej" to "bedža",
    "bem" to "bemba",
    "bew" to "betawi",
    "bez" to "bena",
    "bfd" to "fut",
    "bfq" to "badaga",
    "bg" to "bulgaria",
    "bgc" to "haryanvi",
    "bgn" to "länsibelutši",
    "bho" to "bhodžpuri",
    "bi" to "bislama",
    "bik" to "bikol",
    "bin" to "bini",
    "bjn" to "banjar",
    "bkm" to "kom",
    "bla" to "siksika",
    "blo" to "anii",
    "blt" to "tai dam",
    "bm" to "bambara",
    "bn" to "bengali",
    "bo" to "tiibet",
    "bpy" to "bišnupria",
    "bqi" to "bahtiari",
    "br" to "bretoni",
    "bra" to "bradž",
    "brh" to "brahui",
    "brx" to "bodo",
    "bs" to "bosnia",
    "bss" to "koose",
    "bua" to "burjaatti",
    "bug" to "bugi",
    "bum" to "bulu",
    "byn" to "bilin",
    "byv" to "medumba",
    "ca" to "katalaani",
    "cad" to "caddo",
    "car" to "karibi",
    "cay" to "cayuga",
    "cch" to "atsam",
    "ccp" to "chakma",
    "ce" to "tšetšeeni",
    "ceb" to "cebuano",
    "cgg" to "kiga",
    "ch" to "tšamorro",
    "chb" to "tšibtša",
    "chg" to "tšagatai",
    "chk" to "chuuk",
    "chm" to "mari",
    "chn" to "chinook-jargon",
    "cho" to "choctaw",
    "chp" to "chipewyan",
    "chr" to "cherokee",
    "chy" to "cheyenne",
    "cic" to "chickasaw",
    "ckb" to "soranî",
    "ckb-alt-menu" to "kurdi – soranî",
    "ckb-alt-variant" to "soranî",
    "clc" to "chilcotin",
    "co" to "korsika",
    "cop" to "kopti",
    "cps" to "capiznon",
    "cr" to "cree",
    "crg" to "michif",
    "crh" to "krimintataari",
    "crh-alt-secondary" to "kriminturkki",
    "crj" to "east cree (eteläinen)",
    "crk" to "plains cree",
    "crl" to "east cree (pohjoinen)",
    "crm" to "moose cree",
    "crr" to "pamlico",
    "crs" to "seychellienkreoli",
    "cs" to "tšekki",
    "csb" to "kašubi",
    "csw" to "swampy cree",
    "cu" to "kirkkoslaavi",
    "cv" to "tšuvassi",
    "cy" to "kymri",
    "da" to "tanska",
    "dak" to "dakota",
    "dar" to "dargi",
    "dav" to "taita",
    "de" to "saksa",
    "de-AT" to "itävallansaksa",
    "de-CH" to "sveitsinyläsaksa",
    "del" to "delaware",
    "den" to "slevi",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "djerma",
    "doi" to "dogri",
    "dsb" to "alasorbi",
    "dtp" to "dusun",
    "dua" to "duala",
    "dum" to "keskihollanti",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dyu" to "djula",
    "dz" to "dzongkha",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efik",
    "egl" to "emilia",
    "egy" to "muinaisegypti",
    "eka" to "ekajuk",
    "el" to "kreikka",
    "elx" to "elami",
    "en" to "englanti",
    "en-AU" to "australianenglanti",
    "en-CA" to "kanadanenglanti",
    "en-GB" to "britannianenglanti",
    "en-GB-alt-short" to "englanti (Britannia)",
    "en-US" to "amerikanenglanti",
    "en-US-alt-short" to "englanti (USA)",
    "enm" to "keskienglanti",
    "eo" to "esperanto",
    "es" to "espanja",
    "es-419" to "amerikanespanja",
    "es-ES" to "euroopanespanja",
    "es-MX" to "meksikonespanja",
    "esu" to "alaskanjupik",
    "et" to "viro",
    "eu" to "baski",
    "ewo" to "ewondo",
    "ext" to "extremadura",
    "fa" to "persia",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fulani",
    "fi" to "suomi",
    "fil" to "filipino",
    "fit" to "meänkieli",
    "fj" to "fidži",
    "fo" to "fääri",
    "fon" to "fon",
    "fr" to "ranska",
    "fr-CA" to "kanadanranska",
    "fr-CH" to "sveitsinranska",
    "frc" to "cajunranska",
    "frm" to "keskiranska",
    "fro" to "muinaisranska",
    "frp" to "arpitaani",
    "frr" to "pohjoisfriisi",
    "frs" to "itäfriisi",
    "fur" to "friuli",
    "fy" to "länsifriisi",
    "ga" to "iiri",
    "gaa" to "ga",
    "gag" to "gagauzi",
    "gan" to "gan-kiina",
    "gay" to "gajo",
    "gba" to "gbaja",
    "gbz" to "zoroastrialaisdari",
    "gd" to "gaeli",
    "gez" to "ge’ez",
    "gil" to "kiribati",
    "gl" to "galicia",
    "glk" to "gilaki",
    "gmh" to "keskiyläsaksa",
    "gn" to "guarani",
    "goh" to "muinaisyläsaksa",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gootti",
    "grb" to "grebo",
    "grc" to "muinaiskreikka",
    "gsw" to "sveitsinsaksa",
    "gu" to "gudžarati",
    "guc" to "wayuu",
    "gur" to "frafra",
    "guz" to "gusii",
    "gv" to "manksi",
    "gwi" to "gwitšin",
    "ha" to "hausa",
    "hai" to "haida",
    "hak" to "hakka-kiina",
    "haw" to "havaiji",
    "hax" to "haida (eteläinen)",
    "he" to "heprea",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hinglish",
    "hif" to "fidžinhindi",
    "hil" to "hiligaino",
    "hit" to "heetti",
    "hmn" to "hmong",
    "hnj" to "hmong njua",
    "ho" to "hiri-motu",
    "hr" to "kroatia",
    "hsb" to "yläsorbi",
    "hsn" to "xiang-kiina",
    "ht" to "haiti",
    "hu" to "unkari",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armenia",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonesia",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "sichuanin-yi",
    "ik" to "inupiaq",
    "ikt" to "Länsi-Kanadan inuktitut",
    "ilo" to "iloko",
    "inh" to "inguuši",
    "io" to "ido",
    "is" to "islanti",
    "it" to "italia",
    "iu" to "inuktitut",
    "izh" to "inkeroinen",
    "ja" to "japani",
    "jam" to "jamaikankreolienglanti",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jpr" to "juutalaispersia",
    "jrb" to "juutalaisarabia",
    "jut" to "juutti",
    "jv" to "jaava",
    "ka" to "georgia",
    "kaa" to "karakalpakki",
    "kab" to "kabyyli",
    "kac" to "katšin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kavi",
    "kbd" to "kabardi",
    "kbl" to "kanembu",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "kapverdenkreoli",
    "ken" to "kenyang",
    "kfo" to "norsunluurannikonkoro",
    "kg" to "kongo",
    "kgp" to "kaingang",
    "kha" to "khasi",
    "kho" to "khotani",
    "khq" to "koyra chiini",
    "khw" to "khowar",
    "ki" to "kikuju",
    "kiu" to "kirmanjki",
    "kj" to "kuanjama",
    "kk" to "kazakki",
    "kkj" to "kako",
    "kl" to "kalaallisut",
    "kl-alt-secondary" to "grönlanti",
    "kln" to "kalenjin",
    "km" to "khmer",
    "kmb" to "kimbundu",
    "kn" to "kannada",
    "ko" to "korea",
    "koi" to "komipermjakki",
    "kok" to "konkani",
    "kos" to "kosrae",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karatšai-balkaari",
    "kri" to "krio",
    "krj" to "kinaray-a",
    "krl" to "karjala",
    "kru" to "kurukh",
    "ks" to "kašmiri",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "kölsch",
    "ku" to "kurdi",
    "kum" to "kumykki",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "korni",
    "kwk" to "kwakʼwala",
    "kxv" to "kuvi",
    "ky" to "kirgiisi",
    "la" to "latina",
    "lad" to "ladino",
    "lad-alt-secondary" to "juutalaisespanja",
    "lag" to "lango",
    "lah" to "lahnda",
    "lam" to "lamba",
    "lb" to "luxemburg",
    "lez" to "lezgi",
    "lfn" to "lingua franca nova",
    "lg" to "ganda",
    "li" to "limburg",
    "lij" to "liguuri",
    "lil" to "lillooet",
    "liv" to "liivi",
    "lkt" to "lakota",
    "lld" to "ladin",
    "lmo" to "lombardi",
    "ln" to "lingala",
    "lo" to "lao",
    "lol" to "mongo",
    "lou" to "louisianankreoli",
    "loz" to "lozi",
    "lrc" to "pohjoisluri",
    "lsm" to "samia",
    "lt" to "liettua",
    "ltg" to "latgalli",
    "lu" to "katanganluba",
    "lua" to "luluanluba",
    "lui" to "luiseño",
    "lun" to "lunda",
    "lus" to "lusai",
    "luy" to "luhya",
    "lv" to "latvia",
    "lzh" to "klassinen kiina",
    "lzz" to "lazi",
    "mad" to "madura",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makassar",
    "man" to "mandingo",
    "mas" to "maasai",
    "mde" to "maba",
    "mdf" to "mokša",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "morisyen",
    "mg" to "malagassi",
    "mga" to "keski-iiri",
    "mgh" to "makua-meetto",
    "mgo" to "meta’",
    "mh" to "marshall",
    "mi" to "maori",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "makedonia",
    "ml" to "malajalam",
    "mn" to "mongoli",
    "mnc" to "mantšu",
    "mni" to "manipuri",
    "moe" to "innu-aimun",
    "moh" to "mohawk",
    "mos" to "mossi",
    "mr" to "marathi",
    "mrj" to "vuorimari",
    "ms" to "malaiji",
    "mt" to "malta",
    "mua" to "mundang",
    "mul" to "useita kieliä",
    "mus" to "creek",
    "mwl" to "mirandeesi",
    "mwr" to "marwari",
    "mwv" to "mentawai",
    "my" to "burma",
    "mye" to "myene",
    "myv" to "ersä",
    "mzn" to "mazandarani",
    "na" to "nauru",
    "nan" to "min nan -kiina",
    "nap" to "napoli",
    "naq" to "nama",
    "nb" to "norjan bokmål",
    "nd" to "pohjois-ndebele",
    "nds" to "alasaksa",
    "nds-NL" to "alankomaidenalasaksa",
    "ne" to "nepali",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niue",
    "njo" to "ao naga",
    "nl" to "hollanti",
    "nl-BE" to "flaami",
    "nmg" to "kwasio",
    "nn" to "norjan nynorsk",
    "nnh" to "ngiemboon",
    "no" to "norja",
    "nog" to "nogai",
    "non" to "muinaisnorja",
    "nov" to "novial",
    "nqo" to "n’ko",
    "nr" to "etelä-ndebele",
    "nso" to "pohjoissotho",
    "nus" to "nuer",
    "nv" to "navajo",
    "nwc" to "klassinen newari",
    "ny" to "njandža",
    "nym" to "nyamwezi",
    "nyn" to "nyankole",
    "nyo" to "nyoro",
    "nzi" to "nzima",
    "oc" to "oksitaani",
    "oj" to "odžibwa",
    "ojb" to "luoteis-odžibwa",
    "ojc" to "keskiojibwa",
    "ojs" to "oji-cree",
    "ojw" to "länsi-odžibwa",
    "oka" to "okanagan",
    "om" to "oromo",
    "or" to "orija",
    "os" to "osseetti",
    "osa" to "osage",
    "ota" to "osmani",
    "pa" to "pandžabi",
    "pag" to "pangasinan",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiamentu",
    "pau" to "palau",
    "pcd" to "picardi",
    "pcm" to "nigerianpidgin",
    "pdc" to "pennsylvaniansaksa",
    "pdt" to "plautdietsch",
    "peo" to "muinaispersia",
    "pfl" to "pfaltsi",
    "phn" to "foinikia",
    "pi" to "paali",
    "pis" to "pijin",
    "pl" to "puola",
    "pms" to "piemonte",
    "pnt" to "pontoksenkreikka",
    "pon" to "pohnpei",
    "pqm" to "maliseet-passamaquoddy",
    "prg" to "muinaispreussi",
    "pro" to "muinaisprovensaali",
    "ps" to "paštu",
    "pt" to "portugali",
    "pt-BR" to "brasilianportugali",
    "pt-PT" to "euroopanportugali",
    "qu" to "ketšua",
    "quc" to "kʼicheʼ",
    "qug" to "chimborazonylänköketšua",
    "raj" to "radžastani",
    "rap" to "rapanui",
    "rar" to "rarotonga",
    "rgn" to "romagnoli",
    "rhg" to "rohinga",
    "rif" to "tarifit",
    "rm" to "retoromaani",
    "rn" to "rundi",
    "ro" to "romania",
    "ro-MD" to "moldova",
    "rof" to "rombo",
    "rom" to "romani",
    "rtm" to "rotuma",
    "ru" to "venäjä",
    "rue" to "ruteeni",
    "rug" to "roviana",
    "rup" to "aromania",
    "rw" to "ruanda",
    "rwk" to "rwa",
    "sa" to "sanskrit",
    "sad" to "sandawe",
    "sah" to "jakuutti",
    "sam" to "samarianaramea",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "saz" to "sauraštri",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sardi",
    "scn" to "sisilia",
    "sco" to "skotti",
    "sd" to "sindhi",
    "sdc" to "sassarinsardi",
    "sdh" to "eteläkurdi",
    "se" to "pohjoissaame",
    "see" to "seneca",
    "seh" to "sena",
    "sei" to "seri",
    "sel" to "selkuppi",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sga" to "muinaisiiri",
    "sgs" to "samogiitti",
    "sh" to "serbokroaatti",
    "shi" to "tašelhit",
    "shn" to "shan",
    "shu" to "tšadinarabia",
    "si" to "sinhala",
    "sid" to "sidamo",
    "sk" to "slovakki",
    "skr" to "saraiki",
    "sl" to "sloveeni",
    "slh" to "lushootseed (eteläinen)",
    "sli" to "sleesiansaksa",
    "sly" to "selayar",
    "sm" to "samoa",
    "sma" to "eteläsaame",
    "smj" to "luulajansaame",
    "smn" to "inarinsaame",
    "sms" to "koltansaame",
    "sn" to "šona",
    "snk" to "soninke",
    "so" to "somali",
    "sog" to "sogdi",
    "sq" to "albania",
    "sr" to "serbia",
    "srn" to "sranan",
    "srr" to "serer",
    "ss" to "swazi",
    "ssy" to "saho",
    "st" to "eteläsotho",
    "stq" to "saterlandinfriisi",
    "str" to "straits-salish",
    "su" to "sunda",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumeri",
    "sv" to "ruotsi",
    "sw" to "swahili",
    "sw-CD" to "kongonswahili",
    "swb" to "komori",
    "syc" to "muinaissyyria",
    "syr" to "syyria",
    "szl" to "sleesia",
    "ta" to "tamili",
    "tce" to "etelätutchone",
    "tcy" to "tulu",
    "te" to "telugu",
    "tem" to "temne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetum",
    "tg" to "tadžikki",
    "tgx" to "tagish",
    "th" to "thai",
    "tht" to "tahlta",
    "ti" to "tigrinja",
    "tig" to "tigre",
    "tiv" to "tiv",
    "tk" to "turkmeeni",
    "tkl" to "tokelau",
    "tkr" to "tsahuri",
    "tl" to "tagalog",
    "tlh" to "klingon",
    "tli" to "tlingit",
    "tly" to "tališi",
    "tmh" to "tamašek",
    "tn" to "tswana",
    "to" to "tonga",
    "tog" to "malawintonga",
    "tok" to "toki pona",
    "tpi" to "tok-pisin",
    "tr" to "turkki",
    "tru" to "turojo",
    "trv" to "taroko",
    "trw" to "torwali",
    "ts" to "tsonga",
    "tsd" to "tsakonia",
    "tsi" to "tsimši",
    "tt" to "tataari",
    "ttm" to "pohjoinen tutchone",
    "ttt" to "tati",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahiti",
    "tyv" to "tuva",
    "tzm" to "keskiatlaksentamazight",
    "udm" to "udmurtti",
    "ug" to "uiguuri",
    "uga" to "ugarit",
    "uk" to "ukraina",
    "umb" to "mbundu",
    "und" to "tuntematon kieli",
    "ur" to "urdu",
    "uz" to "uzbekki",
    "ve" to "venda",
    "vec" to "venetsia",
    "vep" to "vepsä",
    "vi" to "vietnam",
    "vls" to "länsiflaami",
    "vmf" to "maininfrankki",
    "vmw" to "makhuwa",
    "vo" to "volapük",
    "vot" to "vatja",
    "vro" to "võro",
    "vun" to "vunjo",
    "wa" to "valloni",
    "wae" to "walser",
    "wal" to "wolaitta",
    "war" to "waray",
    "was" to "washo",
    "wbp" to "warlpiri",
    "wo" to "wolof",
    "wuu" to "wu-kiina",
    "xal" to "kalmukki",
    "xh" to "xhosa",
    "xmf" to "mingreli",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "jao",
    "yap" to "japi",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "jiddiš",
    "yo" to "joruba",
    "yrl" to "ñeengatú",
    "yue" to "kantoninkiina",
    "yue-alt-menu" to "kiina (kantonin)",
    "za" to "zhuang",
    "zap" to "zapoteekki",
    "zbl" to "blisskieli",
    "zea" to "seelanti",
    "zen" to "zenaga",
    "zgh" to "vakioitu tamazight",
    "zh" to "kiina",
    "zh-alt-menu" to "kiina (mandariini)",
    "zh-Hans-alt-long" to "mandariinikiina (yksinkertaistettu)",
    "zh-Hant-alt-long" to "mandariinikiina (perinteinen)",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "ei kielellistä sisältöä",
    "zza" to "zaza",
  ) }

  val fil: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afar",
    "ab" to "Abkhazian",
    "ace" to "Achinese",
    "ach" to "Acoli",
    "ada" to "Adangme",
    "ady" to "Adyghe",
    "af" to "Afrikaans",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "ale" to "Aleut",
    "alt" to "Southern Altai",
    "am" to "Amharic",
    "an" to "Aragonese",
    "ann" to "Obolo",
    "anp" to "Angika",
    "ar" to "Arabic",
    "ar-001" to "Modernong Karaniwang Arabic",
    "arn" to "Mapuche",
    "arp" to "Arapaho",
    "ars" to "Najdi Arabic",
    "as" to "Assamese",
    "asa" to "Asu",
    "ast" to "Asturian",
    "atj" to "Atikamekw",
    "av" to "Avaric",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Azerbaijani",
    "az-alt-short" to "Azeri",
    "ba" to "Bashkir",
    "ban" to "Balinese",
    "bas" to "Basaa",
    "be" to "Belarusian",
    "bem" to "Bemba",
    "bez" to "Bena",
    "bg" to "Bulgarian",
    "bgc" to "Haryanvi",
    "bgn" to "Kanlurang Balochi",
    "bho" to "Bhojpuri",
    "bi" to "Bislama",
    "bin" to "Bini",
    "bla" to "Siksika",
    "blo" to "Anii",
    "bm" to "Bambara",
    "bn" to "Bangla",
    "bo" to "Tibetan",
    "br" to "Breton",
    "brx" to "Bodo",
    "bs" to "Bosnian",
    "bug" to "Buginese",
    "byn" to "Blin",
    "ca" to "Catalan",
    "cay" to "Cayuga",
    "ccp" to "Chakma",
    "ce" to "Chechen",
    "ceb" to "Cebuano",
    "cgg" to "Chiga",
    "ch" to "Chamorro",
    "chk" to "Chuukese",
    "chm" to "Mari",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyenne",
    "ckb" to "Central Kurdish",
    "ckb-alt-menu" to "Kurdish, Central",
    "ckb-alt-variant" to "Kurdish, Sorani",
    "clc" to "Chilcotin",
    "co" to "Corsican",
    "crg" to "Michif",
    "crj" to "Southern East Cree",
    "crk" to "Plains Cree",
    "crl" to "Northern East Cree",
    "crm" to "Moose Cree",
    "crr" to "Carolina Algonquian",
    "crs" to "Seselwa Creole French",
    "cs" to "Czech",
    "csw" to "Latian na Cree",
    "cu" to "Church Slavic",
    "cv" to "Chuvash",
    "cy" to "Welsh",
    "da" to "Danish",
    "dak" to "Dakota",
    "dar" to "Dargwa",
    "dav" to "Taita",
    "de" to "German",
    "de-AT" to "Austrian German",
    "de-CH" to "Swiss High German",
    "dgr" to "Dogrib",
    "dje" to "Zarma",
    "doi" to "Dogri",
    "dsb" to "Lower Sorbian",
    "dua" to "Duala",
    "dv" to "Divehi",
    "dyo" to "Jola-Fonyi",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "eka" to "Ekajuk",
    "el" to "Greek",
    "en" to "Ingles",
    "en-GB-alt-short" to "Ingles sa UK",
    "en-US" to "Ingles (American)",
    "en-US-alt-short" to "Ingles sa US",
    "eo" to "Esperanto",
    "es" to "Spanish",
    "es-419" to "Latin American na Espanyol",
    "es-ES" to "European Spanish",
    "es-MX" to "Mexican na Espanyol",
    "et" to "Estonian",
    "eu" to "Basque",
    "ewo" to "Ewondo",
    "fa" to "Persian",
    "fa-AF" to "Dari",
    "ff" to "Fulah",
    "fi" to "Finnish",
    "fil" to "Filipino",
    "fj" to "Fijian",
    "fo" to "Faroese",
    "fon" to "Fon",
    "fr" to "French",
    "fr-CH" to "Swiss na French",
    "frc" to "Cajun French",
    "frr" to "Hilagang Frisian",
    "fur" to "Friulian",
    "fy" to "Western Frisian",
    "ga" to "Irish",
    "gaa" to "Ga",
    "gag" to "Gagauz",
    "gd" to "Scottish Gaelic",
    "gez" to "Geez",
    "gil" to "Gilbertese",
    "gl" to "Galician",
    "gn" to "Guarani",
    "gor" to "Gorontalo",
    "gsw" to "Swiss German",
    "gu" to "Gujarati",
    "guz" to "Gusii",
    "gv" to "Manx",
    "gwi" to "Gwichʼin",
    "ha" to "Hausa",
    "hai" to "Haida",
    "haw" to "Hawaiian",
    "hax" to "Katimugang Haida",
    "he" to "Hebrew",
    "hi" to "Hindi",
    "hi-Latn-alt-variant" to "Hinglish",
    "hil" to "Hiligaynon",
    "hmn" to "Hmong",
    "hr" to "Croatian",
    "hsb" to "Upper Sorbian",
    "ht" to "Haitian",
    "hu" to "Hungarian",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Armenian",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Iban",
    "ibb" to "Ibibio",
    "id" to "Indonesian",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Sichuan Yi",
    "ikt" to "Kanlurang Canadian Inuktitut",
    "ilo" to "Iloko",
    "inh" to "Ingush",
    "io" to "Ido",
    "is" to "Icelandic",
    "it" to "Italian",
    "iu" to "Inuktitut",
    "ja" to "Japanese",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jv" to "Javanese",
    "ka" to "Georgian",
    "kab" to "Kabyle",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kbd" to "Kabardian",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kabuverdianu",
    "kfo" to "Koro",
    "kg" to "Kongo",
    "kgp" to "Kaingang",
    "kha" to "Khasi",
    "khq" to "Koyra Chiini",
    "ki" to "Kikuyu",
    "kj" to "Kuanyama",
    "kk" to "Kazakh",
    "kkj" to "Kako",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Khmer",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Korean",
    "koi" to "Komi-Permyak",
    "kok" to "Konkani",
    "kpe" to "Kpelle",
    "kr" to "Kanuri",
    "krc" to "Karachay-Balkar",
    "krl" to "Karelian",
    "kru" to "Kurukh",
    "ks" to "Kashmiri",
    "ksb" to "Shambala",
    "ksf" to "Bafia",
    "ksh" to "Colognian",
    "ku" to "Kurdish",
    "kum" to "Kumyk",
    "kv" to "Komi",
    "kw" to "Cornish",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kuvi",
    "ky" to "Kirghiz",
    "la" to "Latin",
    "lad" to "Ladino",
    "lag" to "Langi",
    "lb" to "Luxembourgish",
    "lez" to "Lezghian",
    "lg" to "Ganda",
    "li" to "Limburgish",
    "lij" to "Ligurian",
    "lil" to "Lillooet",
    "lkt" to "Lakota",
    "lmo" to "Lombard",
    "ln" to "Lingala",
    "lo" to "Lao",
    "lou" to "Louisiana Creole",
    "loz" to "Lozi",
    "lrc" to "Hilagang Luri",
    "lsm" to "Saamia",
    "lt" to "Lithuanian",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lun" to "Lunda",
    "luo" to "Luo",
    "lus" to "Mizo",
    "luy" to "Luyia",
    "lv" to "Latvian",
    "mad" to "Madurese",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Makasar",
    "mas" to "Masai",
    "mdf" to "Moksha",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisyen",
    "mg" to "Malagasy",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Meta’",
    "mh" to "Marshallese",
    "mi" to "Māori",
    "mic" to "Micmac",
    "min" to "Minangkabau",
    "mk" to "Macedonian",
    "ml" to "Malayalam",
    "mn" to "Mongolian",
    "mni" to "Manipuri",
    "moe" to "Innu-aimun",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Marathi",
    "ms" to "Malay",
    "mt" to "Maltese",
    "mua" to "Mundang",
    "mul" to "Maramihang Wika",
    "mus" to "Creek",
    "mwl" to "Mirandese",
    "my" to "Burmese",
    "myv" to "Erzya",
    "mzn" to "Mazanderani",
    "na" to "Nauru",
    "nap" to "Neapolitan",
    "naq" to "Nama",
    "nb" to "Norwegian Bokmål",
    "nd" to "Hilagang Ndebele",
    "nds" to "Low German",
    "nds-NL" to "Low Saxon",
    "ne" to "Nepali",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niuean",
    "nl" to "Dutch",
    "nl-BE" to "Flemish",
    "nmg" to "Kwasio",
    "nn" to "Norwegian Nynorsk",
    "nnh" to "Ngiemboon",
    "no" to "Norwegian",
    "nog" to "Nogai",
    "nqo" to "N’Ko",
    "nr" to "South Ndebele",
    "nso" to "Hilagang Sotho",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "ny" to "Nyanja",
    "nyn" to "Nyankole",
    "oc" to "Occitan",
    "ojb" to "Hilagang-Kanluran ng Ojibwa",
    "ojc" to "Central Ojibwa",
    "ojs" to "Oji-Cree",
    "ojw" to "Kanlurang Ojibwa",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Odia",
    "os" to "Ossetic",
    "pa" to "Punjabi",
    "pag" to "Pangasinan",
    "pam" to "Pampanga",
    "pap" to "Papiamento",
    "pau" to "Palauan",
    "pcm" to "Nigerian Pidgin",
    "pis" to "Pijin",
    "pl" to "Polish",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Prussian",
    "ps" to "Pashto",
    "ps-alt-variant" to "Pushto",
    "pt" to "Portuguese",
    "pt-BR" to "Portuges ng Brasil",
    "pt-PT" to "European Portuguese",
    "qu" to "Quechua",
    "quc" to "Kʼicheʼ",
    "raj" to "Rajasthani",
    "rap" to "Rapanui",
    "rar" to "Rarotongan",
    "rhg" to "Rohingya",
    "rm" to "Romansh",
    "rn" to "Rundi",
    "ro" to "Romanian",
    "ro-MD" to "Moldavian",
    "rof" to "Rombo",
    "ru" to "Russian",
    "rup" to "Aromanian",
    "rw" to "Kinyarwanda",
    "rwk" to "Rwa",
    "sa" to "Sanskrit",
    "sad" to "Sandawe",
    "sah" to "Yakut",
    "saq" to "Samburu",
    "sat" to "Santali",
    "sba" to "Ngambay",
    "sbp" to "Sangu",
    "sc" to "Sardinian",
    "scn" to "Sicilian",
    "sco" to "Scots",
    "sd" to "Sindhi",
    "sdh" to "Katimugang Kurdish",
    "se" to "Hilagang Sami",
    "seh" to "Sena",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "sh" to "Serbo-Croatian",
    "shi" to "Tachelhit",
    "shn" to "Shan",
    "si" to "Sinhala",
    "sk" to "Slovak",
    "sl" to "Slovenian",
    "slh" to "Katimugang Lushootseed",
    "sm" to "Samoan",
    "sma" to "Katimugang Sami",
    "smj" to "Lule Sami",
    "smn" to "Inari Sami",
    "sms" to "Skolt Sami",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somali",
    "sq" to "Albanian",
    "sr" to "Serbian",
    "srn" to "Sranan Tongo",
    "ss" to "Swati",
    "ssy" to "Saho",
    "st" to "Katimugang Sotho",
    "str" to "Straits Salish",
    "su" to "Sundanese",
    "suk" to "Sukuma",
    "sv" to "Swedish",
    "sw" to "Swahili",
    "sw-CD" to "Congo Swahili",
    "swb" to "Comorian",
    "syr" to "Syriac",
    "szl" to "Silesian",
    "ta" to "Tamil",
    "tce" to "Katimugang Tutchone",
    "te" to "Telugu",
    "tem" to "Timne",
    "teo" to "Teso",
    "tet" to "Tetum",
    "tg" to "Tajik",
    "tgx" to "Tagish",
    "th" to "Thai",
    "tht" to "Tahltan",
    "ti" to "Tigrinya",
    "tig" to "Tigre",
    "tk" to "Turkmen",
    "tl" to "Tagalog",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tn" to "Tswana",
    "to" to "Tongan",
    "tok" to "Toki Pona",
    "tpi" to "Tok Pisin",
    "tr" to "Turkish",
    "trv" to "Taroko",
    "ts" to "Tsonga",
    "tt" to "Tatar",
    "ttm" to "Northern Tutchone",
    "tum" to "Tumbuka",
    "tvl" to "Tuvalu",
    "tw" to "Twi",
    "twq" to "Tasawaq",
    "ty" to "Tahitian",
    "tyv" to "Tuvinian",
    "tzm" to "Central Atlas Tamazight",
    "udm" to "Udmurt",
    "ug" to "Uyghur",
    "ug-alt-variant" to "Uighur",
    "uk" to "Ukranian",
    "umb" to "Umbundu",
    "und" to "Hindi Kilalang Wika",
    "ur" to "Urdu",
    "uz" to "Uzbek",
    "vai" to "Vai",
    "ve" to "Venda",
    "vec" to "Venetian",
    "vi" to "Vietnamese",
    "vmw" to "Makhuwa",
    "vo" to "Volapük",
    "vun" to "Vunjo",
    "wa" to "Walloon",
    "wae" to "Walser",
    "wal" to "Wolaytta",
    "war" to "Waray",
    "wbp" to "Warlpiri",
    "wo" to "Wolof",
    "wuu" to "Wu Chinese",
    "xal" to "Kalmyk",
    "xh" to "Xhosa",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Yiddish",
    "yo" to "Yoruba",
    "yrl" to "Nheengatu",
    "yue" to "Cantonese",
    "yue-alt-menu" to "Chinese, Cantonese",
    "za" to "Zhuang",
    "zgh" to "Standard Moroccan Tamazight",
    "zh" to "Chinese",
    "zh-alt-menu" to "Chinese, Mandarin",
    "zh-Hans" to "Pinasimpleng Chinese",
    "zh-Hans-alt-long" to "Pinasimpleng Mandarin Chinese",
    "zh-Hant" to "Tradisyonal na Chinese",
    "zh-Hant-alt-long" to "Tradisyonal na Mandarin Chinese",
    "zu" to "Zulu",
    "zun" to "Zuni",
    "zxx" to "Walang nilalaman na ukol sa wika",
    "zza" to "Zaza",
  ) }

  val fo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abkhasiskt",
    "ace" to "achinese",
    "ada" to "adangme",
    "ady" to "adyghe",
    "af" to "afrikaans",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "akan",
    "ale" to "aleut",
    "alt" to "suður altai",
    "am" to "amhariskt",
    "an" to "aragoniskt",
    "anp" to "angika",
    "ar" to "arabiskt",
    "ar-001" to "nútíðar vanligt arabiskt",
    "arn" to "mapuche",
    "arp" to "arapaho",
    "as" to "assamesiskt",
    "asa" to "asu",
    "ast" to "asturianskt",
    "av" to "avariskt",
    "awa" to "awadhi",
    "ay" to "aymara",
    "az" to "aserbajdsjanskt",
    "az-alt-short" to "azeri",
    "ba" to "bashkir",
    "ban" to "balinesiskt",
    "bas" to "basaa",
    "be" to "hvitarussiskt",
    "bem" to "bemba",
    "bez" to "bena",
    "bg" to "bulgarskt",
    "bgc" to "haryanvi",
    "bgn" to "vestur balochi",
    "bho" to "bhojpuri",
    "bi" to "bislama",
    "bin" to "bini",
    "bla" to "siksika",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bangla",
    "bo" to "tibetskt",
    "br" to "bretonskt",
    "brx" to "bodo",
    "bs" to "bosniskt",
    "bss" to "bakossi",
    "bug" to "buginesiskt",
    "byn" to "blin",
    "ca" to "katalani",
    "ccp" to "khakma",
    "ce" to "tjetjenskt",
    "ceb" to "cebuano",
    "cgg" to "chiga",
    "ch" to "chamorro",
    "chk" to "chuukese",
    "chm" to "mari",
    "cho" to "choctaw",
    "chr" to "cherokee",
    "chy" to "cheyenne",
    "ckb" to "miðkurdiskt",
    "ckb-alt-menu" to "kurdiskt, mið",
    "ckb-alt-variant" to "kurdiskt, sorani",
    "co" to "korsikanskt",
    "crs" to "seselwa creole franskt",
    "cs" to "kekkiskt",
    "csw" to "swampy cree",
    "cu" to "kirkju sláviskt",
    "cv" to "chuvash",
    "cy" to "walisiskt",
    "da" to "danskt",
    "dak" to "dakota",
    "dar" to "dargwa",
    "dav" to "taita",
    "de" to "týskt",
    "de-CH" to "høgt týskt (Sveis)",
    "dgr" to "dogrib",
    "dje" to "sarma",
    "doi" to "dogri",
    "dsb" to "lágt sorbian",
    "dua" to "duala",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dz" to "dzongkha",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efik",
    "eka" to "ekajuk",
    "el" to "grikskt",
    "en" to "enskt",
    "eo" to "esperanto",
    "es" to "spanskt",
    "et" to "estiskt",
    "eu" to "baskiskt",
    "ewo" to "ewondo",
    "fa" to "persiskt",
    "fa-AF" to "dari",
    "ff" to "fulah",
    "fi" to "finskt",
    "fil" to "filipiniskt",
    "fj" to "fijimál",
    "fo" to "føroyskt",
    "fon" to "fon",
    "fr" to "franskt",
    "fur" to "friuliskt",
    "fy" to "vestur frísiskt",
    "ga" to "írskt",
    "gaa" to "ga",
    "gag" to "gagauz",
    "gan" to "gan kinesiskt",
    "gd" to "skotskt gæliskt",
    "gez" to "geez",
    "gil" to "kiribatiskt",
    "gl" to "galisiskt",
    "gn" to "guarani",
    "gor" to "gorontalo",
    "gsw" to "týskt (Sveis)",
    "gu" to "gujarati",
    "guz" to "gusii",
    "gv" to "manx",
    "gwi" to "gwich’in",
    "ha" to "hausa",
    "hak" to "hakka kinesiskt",
    "haw" to "hawaiianskt",
    "he" to "hebraiskt",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hinglish",
    "hil" to "hiligaynon",
    "hmn" to "hmong",
    "hr" to "kroatiskt",
    "hsb" to "ovara sorbian",
    "hsn" to "xiang kinesiskt",
    "ht" to "haitiskt creole",
    "hu" to "ungarskt",
    "hup" to "hupa",
    "hy" to "armenskt",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonesiskt",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "sichuan yi",
    "ilo" to "iloko",
    "inh" to "inguish",
    "io" to "ido",
    "is" to "íslendskt",
    "it" to "italskt",
    "iu" to "inuktitut",
    "ja" to "japanskt",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jv" to "javanskt",
    "ka" to "georgiskt",
    "kab" to "kabyle",
    "kac" to "kachin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kbd" to "kabardinskt",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "grønhøvdaoyggjarskt",
    "kfo" to "koro",
    "kgp" to "kaingang",
    "kha" to "khasi",
    "khq" to "koyra chiini",
    "ki" to "kikuyu",
    "kj" to "kuanyama",
    "kk" to "kazakh",
    "kkj" to "kako",
    "kl" to "kalaallisut",
    "kln" to "kalenjin",
    "km" to "khmer",
    "kmb" to "kimbundu",
    "kn" to "kannada",
    "ko" to "koreanskt",
    "koi" to "komi-permyak",
    "kok" to "konkani",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karachay-balkar",
    "krl" to "karelskt",
    "kru" to "kurukh",
    "ks" to "kashmiri",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "kølnskt",
    "ku" to "kurdiskt",
    "kum" to "kumyk",
    "kv" to "komi",
    "kw" to "corniskt",
    "kxv" to "kuvi",
    "ky" to "kyrgyz",
    "la" to "latín",
    "lad" to "ladino",
    "lag" to "langi",
    "lah" to "lahnda",
    "lb" to "luksemborgskt",
    "lez" to "lezghian",
    "lg" to "ganda",
    "li" to "limburgiskt",
    "lij" to "liguriskt",
    "lkt" to "lakota",
    "lmo" to "lombard",
    "ln" to "lingala",
    "lo" to "laoskt",
    "loz" to "lozi",
    "lrc" to "norður luri",
    "lt" to "litaviskt",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lun" to "lunda",
    "lus" to "mizo",
    "luy" to "luyia",
    "lv" to "lettiskt",
    "mad" to "maduresiskt",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makasar",
    "mas" to "masai",
    "mdf" to "moksha",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "morisyen",
    "mg" to "malagassiskt",
    "mgh" to "makhuwa-meetto",
    "mgo" to "metaʼ",
    "mh" to "marshallesiskt",
    "mi" to "maori",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "makedónskt",
    "ml" to "malayalam",
    "mn" to "mongolskt",
    "mni" to "manupuri",
    "moh" to "mohawk",
    "mos" to "mossi",
    "mr" to "marathi",
    "ms" to "malaiiskt",
    "mt" to "maltiskt",
    "mua" to "mundang",
    "mul" to "ymisk mál",
    "mus" to "creek",
    "mwl" to "mirandesiskt",
    "my" to "burmesiskt",
    "myv" to "erzya",
    "mzn" to "mazanderani",
    "na" to "nauru",
    "nan" to "min nan kinesiskt",
    "nap" to "napolitanskt",
    "naq" to "nama",
    "nb" to "norskt bókmál",
    "nd" to "norður ndebele",
    "nds" to "lágt týskt",
    "nds-NL" to "lágt saksiskt",
    "ne" to "nepalskt",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niuean",
    "nl" to "hálendskt",
    "nl-BE" to "flamskt",
    "nmg" to "kwasio",
    "nn" to "nýnorskt",
    "nnh" to "ngiemboon",
    "no" to "norskt",
    "nog" to "nogai",
    "nqo" to "nʼko",
    "nr" to "suður ndebele",
    "nso" to "norður sotho",
    "nus" to "nuer",
    "nv" to "navajo",
    "ny" to "nyanja",
    "nyn" to "nyankole",
    "oc" to "occitanskt",
    "om" to "oromo",
    "or" to "odia",
    "os" to "ossetiskt",
    "pa" to "punjabi",
    "pag" to "pangasinan",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palauan",
    "pcm" to "nigeriskt pidgin",
    "pl" to "pólskt",
    "prg" to "prusslanskt",
    "ps" to "pashto",
    "pt" to "portugiskiskt",
    "pt-BR" to "portugiskiskt (Brasilia)",
    "pt-PT" to "portugiskiskt (Evropa)",
    "qu" to "quechua",
    "quc" to "kʼicheʼ",
    "raj" to "rajasthani",
    "rap" to "rapanui",
    "rar" to "rarotongiskt",
    "rm" to "retoromanskt",
    "rn" to "rundi",
    "ro" to "rumenskt",
    "ro-MD" to "moldaviskt",
    "rof" to "rombo",
    "ru" to "russiskt",
    "rup" to "aromenskt",
    "rw" to "kinyarwanda",
    "rwk" to "rwa",
    "sa" to "sanskrit",
    "sad" to "sandawe",
    "sah" to "sakha",
    "saq" to "samburu",
    "sat" to "santali",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sardiskt",
    "scn" to "sisilanskt",
    "sco" to "skotskt",
    "sd" to "sindhi",
    "sdh" to "suður kurdiskt",
    "se" to "norður sámiskt",
    "seh" to "sena",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sh" to "serbokroatiskt",
    "shi" to "tachelhit",
    "shn" to "shan",
    "si" to "singalesiskt",
    "sk" to "slovakiskt",
    "sl" to "slovenskt",
    "sm" to "sámoiskt",
    "sma" to "suður sámiskt",
    "smj" to "lule sámiskt",
    "smn" to "inari sami",
    "sms" to "skolt sámiskt",
    "sn" to "shona",
    "snk" to "soninke",
    "so" to "somaliskt",
    "sq" to "albanskt",
    "sr" to "serbiskt",
    "srn" to "sranan tongo",
    "ss" to "swatiskt",
    "ssy" to "saho",
    "st" to "sesotho",
    "su" to "sundanesiskt",
    "suk" to "sukuma",
    "sv" to "svenskt",
    "sw" to "swahili",
    "sw-CD" to "kongo svahili",
    "swb" to "komoriskt",
    "syr" to "syriac",
    "szl" to "silesiskt",
    "ta" to "tamilskt",
    "te" to "telugu",
    "tem" to "timne",
    "teo" to "teso",
    "tet" to "tetum",
    "tg" to "tajik",
    "th" to "tailendskt",
    "ti" to "tigrinya",
    "tig" to "tigre",
    "tk" to "turkmenskt",
    "tl" to "tagalog",
    "tlh" to "klingonskt",
    "tn" to "tswana",
    "to" to "tonganskt",
    "tpi" to "tok pisin",
    "tr" to "turkiskt",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tt" to "tatar",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitiskt",
    "tyv" to "tuvinian",
    "tzm" to "miðatlasfjøll tamazight",
    "udm" to "udmurt",
    "ug" to "uyghur",
    "uk" to "ukrainskt",
    "umb" to "umbundu",
    "und" to "ókent mál",
    "ur" to "urdu",
    "uz" to "usbekiskt",
    "ve" to "venda",
    "vec" to "venetiskt",
    "vi" to "vjetnamesiskt",
    "vmw" to "makhuwa",
    "vo" to "volapykk",
    "vun" to "vunjo",
    "wa" to "walloon",
    "wae" to "walser",
    "wal" to "wolaytta",
    "war" to "waray",
    "wbp" to "warlpiri",
    "wo" to "wolof",
    "wuu" to "wu kinesiskt",
    "xal" to "kalmyk",
    "xh" to "xhosa",
    "xnr" to "kangri",
    "xog" to "soga",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "jiddiskt",
    "yo" to "yoruba",
    "yrl" to "nheengatu",
    "yue" to "kantonesiskt",
    "yue-alt-menu" to "kinesiskt, kantonesiskt",
    "za" to "zhuang",
    "zgh" to "vanligt marokanskt tamazight",
    "zh" to "kinesiskt",
    "zh-alt-menu" to "kinesiskt, mandarin",
    "zh-Hans" to "einkult kinesiskt",
    "zh-Hans-alt-long" to "mandarin kinesiskt (einkult)",
    "zh-Hant" to "vanligt kinesiskt",
    "zh-Hant-alt-long" to "mandarin kinesiskt (vanligt)",
    "zu" to "sulu",
    "zun" to "zuni",
    "zxx" to "einki málsligt innihald",
    "zza" to "zaza",
  ) }

  val fo_DK: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abkhaze",
    "ace" to "aceh",
    "ach" to "acoli",
    "ada" to "adangme",
    "ady" to "adyguéen",
    "ae" to "avestique",
    "aeb" to "arabe tunisien",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "aïnou",
    "ak" to "akan",
    "akk" to "akkadien",
    "akz" to "alabama",
    "ale" to "aléoute",
    "aln" to "guègue",
    "alt" to "altaï du Sud",
    "am" to "amharique",
    "an" to "aragonais",
    "ang" to "ancien anglais",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "arabe",
    "ar-001" to "arabe standard moderne",
    "arc" to "araméen",
    "arn" to "mapuche",
    "aro" to "araona",
    "arp" to "arapaho",
    "arq" to "arabe algérien",
    "ars" to "arabe najdi",
    "arw" to "arawak",
    "ary" to "arabe marocain",
    "arz" to "arabe égyptien",
    "as" to "assamais",
    "asa" to "asu",
    "ase" to "langue des signes américaine",
    "ast" to "asturien",
    "atj" to "atikamekw",
    "av" to "avar",
    "avk" to "kotava",
    "awa" to "awadhi",
    "ay" to "aymara",
    "az" to "azerbaïdjanais",
    "az-alt-short" to "azéri",
    "ba" to "bachkir",
    "bal" to "baloutchi",
    "ban" to "balinais",
    "bar" to "bavarois",
    "bas" to "bassa",
    "bax" to "bamoun",
    "bbc" to "batak toba",
    "bbj" to "ghomalaʼ",
    "be" to "biélorusse",
    "bej" to "bedja",
    "bem" to "bemba",
    "bew" to "betawi",
    "bez" to "bena",
    "bfd" to "bafut",
    "bfq" to "badaga",
    "bg" to "bulgare",
    "bgc" to "haryanvi",
    "bgn" to "baloutchi occidental",
    "bho" to "bhodjpouri",
    "bi" to "bichelamar",
    "bik" to "bikol",
    "bin" to "bini",
    "bjn" to "banjar",
    "bkm" to "kom",
    "bla" to "siksika",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bengali",
    "bo" to "tibétain",
    "bpy" to "bishnupriya",
    "bqi" to "bakhtiari",
    "br" to "breton",
    "bra" to "braj",
    "brh" to "brahoui",
    "brx" to "bodo",
    "bs" to "bosniaque",
    "bss" to "akoose",
    "bua" to "bouriate",
    "bug" to "bugi",
    "bum" to "boulou",
    "byn" to "blin",
    "byv" to "médumba",
    "ca" to "catalan",
    "cad" to "caddo",
    "car" to "caribe",
    "cay" to "cayuga",
    "cch" to "atsam",
    "ccp" to "changma kodha",
    "ce" to "tchétchène",
    "ceb" to "cebuano",
    "cgg" to "kiga",
    "ch" to "chamorro",
    "chb" to "chibcha",
    "chg" to "tchaghataï",
    "chk" to "chuuk",
    "chm" to "mari",
    "chn" to "jargon chinook",
    "cho" to "choctaw",
    "chp" to "chipewyan",
    "chr" to "cherokee",
    "chy" to "cheyenne",
    "ckb" to "sorani",
    "ckb-alt-menu" to "kurde sorani",
    "ckb-alt-variant" to "sorani",
    "clc" to "chilcotin",
    "co" to "corse",
    "cop" to "copte",
    "cps" to "capiznon",
    "cr" to "cree",
    "crg" to "mitchif",
    "crh" to "tatar de Crimée",
    "crj" to "cri de l’Est (dialecte du Sud)",
    "crk" to "cri des plaines",
    "crl" to "cri de l’Est (dialecte du Nord)",
    "crm" to "cri de Moose",
    "crr" to "algonquin de Caroline",
    "crs" to "créole seychellois",
    "cs" to "tchèque",
    "csb" to "kachoube",
    "csw" to "cri des marais",
    "cu" to "slavon d’église",
    "cv" to "tchouvache",
    "cy" to "gallois",
    "da" to "danois",
    "dak" to "dakota",
    "dar" to "dargwa",
    "dav" to "taita",
    "de" to "allemand",
    "de-AT" to "allemand autrichien",
    "de-CH" to "allemand suisse",
    "del" to "delaware",
    "den" to "esclave",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "bas-sorabe",
    "dtp" to "dusun central",
    "dua" to "douala",
    "dum" to "moyen néerlandais",
    "dv" to "maldivien",
    "dyo" to "diola-fogny",
    "dyu" to "dioula",
    "dz" to "dzongkha",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "éwé",
    "efi" to "éfik",
    "egl" to "émilien",
    "egy" to "égyptien ancien",
    "eka" to "ékadjouk",
    "el" to "grec",
    "elx" to "élamite",
    "en" to "anglais",
    "en-AU" to "anglais australien",
    "en-CA" to "anglais canadien",
    "en-GB" to "anglais britannique",
    "en-GB-alt-short" to "anglais britannique",
    "en-US" to "anglais américain",
    "en-US-alt-short" to "anglais américain",
    "enm" to "moyen anglais",
    "eo" to "espéranto",
    "es" to "espagnol",
    "es-419" to "espagnol d’Amérique latine",
    "es-ES" to "espagnol d’Espagne",
    "es-MX" to "espagnol du Mexique",
    "esu" to "youpik central",
    "et" to "estonien",
    "eu" to "basque",
    "ewo" to "éwondo",
    "ext" to "estrémègne",
    "fa" to "persan",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "peul",
    "fi" to "finnois",
    "fil" to "filipino",
    "fit" to "finnois tornédalien",
    "fj" to "fidjien",
    "fo" to "féroïen",
    "fon" to "fon",
    "fr" to "français",
    "fr-CA" to "français canadien",
    "fr-CH" to "français suisse",
    "frc" to "français cadien",
    "frm" to "moyen français",
    "fro" to "ancien français",
    "frp" to "francoprovençal",
    "frr" to "frison septentrional",
    "frs" to "frison oriental",
    "fur" to "frioulan",
    "fy" to "frison occidental",
    "ga" to "irlandais",
    "gaa" to "ga",
    "gag" to "gagaouze",
    "gan" to "gan",
    "gay" to "gayo",
    "gba" to "gbaya",
    "gbz" to "dari zoroastrien",
    "gd" to "gaélique écossais",
    "gez" to "guèze",
    "gil" to "gilbertin",
    "gl" to "galicien",
    "glk" to "gilaki",
    "gmh" to "moyen haut-allemand",
    "gn" to "guarani",
    "goh" to "ancien haut allemand",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gotique",
    "grb" to "grebo",
    "grc" to "grec ancien",
    "gsw" to "suisse allemand",
    "gu" to "goudjarati",
    "guc" to "wayuu",
    "gur" to "gurenne",
    "guz" to "gusii",
    "gv" to "mannois",
    "gwi" to "gwichʼin",
    "ha" to "haoussa",
    "hai" to "haïda",
    "hak" to "hakka",
    "haw" to "hawaïen",
    "hax" to "haïda du Sud",
    "he" to "hébreu",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hinglish",
    "hif" to "hindi fidjien",
    "hil" to "hiligaynon",
    "hit" to "hittite",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "croate",
    "hsb" to "haut-sorabe",
    "hsn" to "xiang",
    "ht" to "créole haïtien",
    "hu" to "hongrois",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "arménien",
    "hz" to "héréro",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonésien",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "yi du Sichuan",
    "ik" to "inupiaq",
    "ikt" to "inuktitut de l’Ouest canadien",
    "ilo" to "ilocano",
    "inh" to "ingouche",
    "io" to "ido",
    "is" to "islandais",
    "it" to "italien",
    "iu" to "inuktitut",
    "izh" to "ingrien",
    "ja" to "japonais",
    "jam" to "créole jamaïcain",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "matchamé",
    "jpr" to "judéo-persan",
    "jrb" to "judéo-arabe",
    "jut" to "jute",
    "jv" to "javanais",
    "ka" to "géorgien",
    "kaa" to "karakalpak",
    "kab" to "kabyle",
    "kac" to "kachin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kawi",
    "kbd" to "kabarde",
    "kbl" to "kanembou",
    "kcg" to "tyap",
    "kde" to "makondé",
    "kea" to "capverdien",
    "ken" to "kényang",
    "kfo" to "koro",
    "kg" to "kikongo",
    "kgp" to "caingangue",
    "kha" to "khasi",
    "kho" to "khotanais",
    "khq" to "koyra chiini",
    "khw" to "khowar",
    "ki" to "kikuyu",
    "kiu" to "kirmanjki",
    "kj" to "kuanyama",
    "kk" to "kazakh",
    "kkj" to "kako",
    "kl" to "groenlandais",
    "kln" to "kalendjin",
    "km" to "khmer",
    "kmb" to "kimboundou",
    "kn" to "kannada",
    "ko" to "coréen",
    "koi" to "komi-permiak",
    "kok" to "konkani",
    "kos" to "kosraéen",
    "kpe" to "kpellé",
    "kr" to "kanouri",
    "krc" to "karatchaï balkar",
    "kri" to "krio",
    "krj" to "kinaray-a",
    "krl" to "carélien",
    "kru" to "kouroukh",
    "ks" to "cachemiri",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "kölsch",
    "ku" to "kurde",
    "kum" to "koumyk",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "cornique",
    "kwk" to "kwak’wala",
    "kxv" to "kuvi",
    "ky" to "kirghize",
    "la" to "latin",
    "lad" to "ladino",
    "lag" to "langi",
    "lah" to "lahnda",
    "lam" to "lamba",
    "lb" to "luxembourgeois",
    "lez" to "lezghien",
    "lfn" to "lingua franca nova",
    "lg" to "ganda",
    "li" to "limbourgeois",
    "lij" to "ligure",
    "lil" to "lillooet",
    "liv" to "livonien",
    "lkt" to "lakota",
    "lmo" to "lombard",
    "ln" to "lingala",
    "lo" to "lao",
    "lol" to "mongo",
    "lou" to "créole louisianais",
    "loz" to "lozi",
    "lrc" to "lori du Nord",
    "lsm" to "samia",
    "lt" to "lituanien",
    "ltg" to "latgalien",
    "lu" to "luba-katanga (kiluba)",
    "lua" to "luba-kasaï (ciluba)",
    "lui" to "luiseño",
    "lun" to "lunda",
    "lus" to "lushaï",
    "luy" to "luyia",
    "lv" to "letton",
    "lzh" to "chinois littéraire",
    "lzz" to "laze",
    "mad" to "madurais",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maïthili",
    "mak" to "makassar",
    "man" to "mandingue",
    "mas" to "maasaï",
    "mde" to "maba",
    "mdf" to "mokcha",
    "mdr" to "mandar",
    "men" to "mendé",
    "mer" to "meru",
    "mfe" to "créole mauricien",
    "mg" to "malgache",
    "mga" to "moyen irlandais",
    "mgh" to "makua",
    "mgo" to "metaʼ",
    "mh" to "marshallais",
    "mi" to "maori",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "macédonien",
    "ml" to "malayalam",
    "mn" to "mongol",
    "mnc" to "mandchou",
    "mni" to "manipuri",
    "moe" to "innu-aimun",
    "moh" to "mohawk",
    "mos" to "moré",
    "mr" to "marathi",
    "mrj" to "mari occidental",
    "ms" to "malais",
    "mt" to "maltais",
    "mua" to "moundang",
    "mul" to "multilingue",
    "mus" to "creek",
    "mwl" to "mirandais",
    "mwr" to "marwarî",
    "mwv" to "mentawaï",
    "my" to "birman",
    "mye" to "myènè",
    "myv" to "erzya",
    "mzn" to "mazandérani",
    "na" to "nauruan",
    "nan" to "minnan",
    "nap" to "napolitain",
    "naq" to "nama",
    "nb" to "norvégien bokmål",
    "nd" to "ndébélé du Nord",
    "nds" to "bas-allemand",
    "nds-NL" to "bas-saxon néerlandais",
    "ne" to "népalais",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "niha",
    "niu" to "niuéen",
    "njo" to "ao",
    "nl" to "néerlandais",
    "nl-BE" to "flamand",
    "nmg" to "ngoumba",
    "nn" to "norvégien nynorsk",
    "nnh" to "ngiemboon",
    "no" to "norvégien",
    "nog" to "nogaï",
    "non" to "vieux norrois",
    "nov" to "novial",
    "nqo" to "n’ko",
    "nr" to "ndébélé du Sud",
    "nso" to "sotho du Nord",
    "nus" to "nuer",
    "nv" to "navajo",
    "nwc" to "newarî classique",
    "ny" to "chewa",
    "nym" to "nyamwezi",
    "nyn" to "nyankolé",
    "nyo" to "nyoro",
    "nzi" to "nzema",
    "oc" to "occitan",
    "oj" to "ojibwa",
    "ojb" to "ojibwé du Nord-Ouest",
    "ojc" to "ojibwé central",
    "ojs" to "oji-cri",
    "ojw" to "ojibwé occidental",
    "oka" to "colville-okanagan",
    "om" to "oromo",
    "or" to "odia",
    "os" to "ossète",
    "osa" to "osage",
    "ota" to "turc ottoman",
    "pa" to "pendjabi",
    "pag" to "pangasinan",
    "pal" to "pahlavi",
    "pam" to "pampangan",
    "pap" to "papiamento",
    "pau" to "palau",
    "pcd" to "picard",
    "pcm" to "pidgin nigérian",
    "pdc" to "pennsilfaanisch",
    "pdt" to "bas-prussien",
    "peo" to "persan ancien",
    "pfl" to "allemand palatin",
    "phn" to "phénicien",
    "pi" to "pali",
    "pis" to "pijin",
    "pl" to "polonais",
    "pms" to "piémontais",
    "pnt" to "pontique",
    "pon" to "pohnpei",
    "pqm" to "malécite-passamaquoddy",
    "prg" to "prussien",
    "pro" to "provençal ancien",
    "ps" to "pachto",
    "ps-alt-variant" to "pashto",
    "pt" to "portugais",
    "pt-BR" to "portugais brésilien",
    "pt-PT" to "portugais européen",
    "qu" to "quechua",
    "quc" to "quiché",
    "qug" to "quichua du Haut-Chimborazo",
    "raj" to "rajasthani",
    "rap" to "rapanui",
    "rar" to "rarotongien",
    "rgn" to "romagnol",
    "rhg" to "rohingya",
    "rif" to "rifain",
    "rm" to "romanche",
    "rn" to "roundi",
    "ro" to "roumain",
    "ro-MD" to "moldave",
    "rof" to "rombo",
    "rom" to "romani",
    "rtm" to "rotuman",
    "ru" to "russe",
    "rue" to "ruthène",
    "rug" to "roviana",
    "rup" to "aroumain",
    "rw" to "kinyarwanda",
    "rwk" to "rwa",
    "sa" to "sanskrit",
    "sad" to "sandawe",
    "sah" to "iakoute",
    "sam" to "araméen samaritain",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "saz" to "saurashtra",
    "sba" to "ngambay",
    "sbp" to "isangu",
    "sc" to "sarde",
    "scn" to "sicilien",
    "sco" to "écossais",
    "sd" to "sindhi",
    "sdc" to "sarde sassarais",
    "sdh" to "kurde du Sud",
    "se" to "same du Nord",
    "see" to "seneca",
    "seh" to "cisena",
    "sei" to "séri",
    "sel" to "selkoupe",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sga" to "ancien irlandais",
    "sgs" to "samogitien",
    "sh" to "serbo-croate",
    "shi" to "chleuh",
    "shn" to "shan",
    "shu" to "arabe tchadien",
    "si" to "cingalais",
    "sid" to "sidamo",
    "sk" to "slovaque",
    "sl" to "slovène",
    "slh" to "lushootseed du Sud",
    "sli" to "bas-silésien",
    "sly" to "sélayar",
    "sm" to "samoan",
    "sma" to "same du Sud",
    "smj" to "same de Lule",
    "smn" to "same d’Inari",
    "sms" to "same skolt",
    "sn" to "shona",
    "snk" to "soninké",
    "so" to "somali",
    "sog" to "sogdien",
    "sq" to "albanais",
    "sr" to "serbe",
    "srn" to "sranan tongo",
    "srr" to "sérère",
    "ss" to "swati",
    "ssy" to "saho",
    "st" to "sotho du Sud",
    "stq" to "saterlandais",
    "str" to "salish des détroits",
    "su" to "soundanais",
    "suk" to "soukouma",
    "sus" to "soussou",
    "sux" to "sumérien",
    "sv" to "suédois",
    "sw" to "swahili",
    "sw-CD" to "swahili du Congo",
    "swb" to "comorien",
    "syc" to "syriaque classique",
    "syr" to "syriaque",
    "szl" to "silésien",
    "ta" to "tamoul",
    "tce" to "tutchone du Sud",
    "tcy" to "toulou",
    "te" to "télougou",
    "tem" to "timné",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tétoum",
    "tg" to "tadjik",
    "tgx" to "tagish",
    "th" to "thaï",
    "tht" to "tahltan",
    "ti" to "tigrigna",
    "tig" to "tigré",
    "tiv" to "tiv",
    "tk" to "turkmène",
    "tkl" to "tokelau",
    "tkr" to "tsakhour",
    "tl" to "tagalog",
    "tlh" to "klingon",
    "tli" to "tlingit",
    "tly" to "talysh",
    "tmh" to "tamacheq",
    "tn" to "tswana",
    "to" to "tongien",
    "tog" to "tonga nyasa",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turc",
    "tru" to "touroyo",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsd" to "tsakonien",
    "tsi" to "tsimshian",
    "tt" to "tatar",
    "ttm" to "tutchone du Nord",
    "ttt" to "tati caucasien",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitien",
    "tyv" to "touvain",
    "tzm" to "amazighe de l’Atlas central",
    "udm" to "oudmourte",
    "ug" to "ouïghour",
    "ug-alt-variant" to "ouïgour",
    "uga" to "ougaritique",
    "uk" to "ukrainien",
    "umb" to "umbundu",
    "und" to "langue indéterminée",
    "ur" to "ourdou",
    "uz" to "ouzbek",
    "vai" to "vaï",
    "ve" to "venda",
    "vec" to "vénitien",
    "vep" to "vepse",
    "vi" to "vietnamien",
    "vls" to "flamand occidental",
    "vmf" to "franconien du Main",
    "vmw" to "macua",
    "vo" to "volapük",
    "vot" to "vote",
    "vro" to "võro",
    "vun" to "vunjo",
    "wa" to "wallon",
    "wae" to "walser",
    "wal" to "walamo",
    "war" to "waray",
    "was" to "washo",
    "wbp" to "warlpiri",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "kalmouk",
    "xh" to "xhosa",
    "xmf" to "mingrélien",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "yao",
    "yap" to "yapois",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "yiddish",
    "yo" to "yoruba",
    "yrl" to "nheengatou",
    "yue" to "cantonais",
    "yue-alt-menu" to "chinois cantonais",
    "za" to "zhuang",
    "zap" to "zapotèque",
    "zbl" to "symboles Bliss",
    "zea" to "zélandais",
    "zen" to "zenaga",
    "zgh" to "amazighe standard marocain",
    "zh" to "chinois",
    "zh-alt-menu" to "chinois mandarin",
    "zh-Hans" to "chinois simplifié",
    "zh-Hans-alt-long" to "mandarin simplifié",
    "zh-Hant" to "chinois traditionnel",
    "zh-Hant-alt-long" to "mandarin traditionnel",
    "zu" to "zoulou",
    "zun" to "zuñi",
    "zxx" to "sans contenu linguistique",
    "zza" to "zazaki",
  ) }

  val fr_BE: ImmutableMap<String, String> by lazy { immutableMapOf(
    "frp" to "franco-provençal",
    "goh" to "ancien haut-allemand",
    "gu" to "gujarati",
  ) }

  val fr_BF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_BI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_BJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_BL: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CA: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ady" to "adygué",
    "ang" to "vieil anglais",
    "asa" to "asou",
    "bbj" to "ghomala",
    "bik" to "bicol",
    "byn" to "bilen",
    "byv" to "medumba",
    "chg" to "tchagatay",
    "chn" to "chinook",
    "ckb" to "kurde central",
    "ckb-alt-menu" to "kurde central",
    "cr" to "cri",
    "crg" to "michif",
    "crl" to "cri du Nord-Est",
    "crr" to "algonquin de la Caroline",
    "den" to "slave",
    "dgr" to "tlicho",
    "ebu" to "embou",
    "en-GB-alt-short" to "anglais (R.-U.)",
    "en-US-alt-short" to "anglais (É.-U.)",
    "esu" to "yupik central",
    "ewo" to "ewondo",
    "frc" to "cajun",
    "frp" to "franco-provençal",
    "goh" to "vieux haut-allemand",
    "gu" to "gujarati",
    "ii" to "yi de Sichuan",
    "ken" to "kenyang",
    "kl" to "kalaallisut",
    "ks" to "kashmiri",
    "ksb" to "chambala",
    "liv" to "live",
    "lu" to "luba-katanga",
    "lzh" to "chinois classique",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta’",
    "mwr" to "marwari",
    "mwv" to "mentawai",
    "nds-NL" to "bas saxon",
    "njo" to "ao naga",
    "nmg" to "kwasio",
    "nwc" to "newari classique",
    "nyn" to "nkole",
    "oka" to "okanagan",
    "pau" to "palauan",
    "pdc" to "allemand de Pennsylvanie",
    "pdt" to "bas allemand mennonite",
    "peo" to "vieux perse",
    "pfl" to "palatin",
    "pis" to "pidgin",
    "pro" to "ancien occitan",
    "quc" to "k’iche’",
    "rar" to "rarotonga",
    "sbp" to "sangu",
    "sdh" to "kurde méridional",
    "sei" to "seri",
    "sga" to "vieil irlandais",
    "sly" to "selayar",
    "smn" to "sami d’Inari",
    "stq" to "frison de Saterland",
    "sus" to "sosso",
    "sw-CD" to "swahili congolais",
    "tru" to "turoyo",
    "tzm" to "tamazight",
    "ug-alt-variant" to "ouïghour",
    "yue-alt-menu" to "chinois, cantonais",
    "zh-alt-menu" to "chinois, mandarin",
    "zh-Hans-alt-long" to "chinois, mandarin simplifié",
    "zh-Hant-alt-long" to "chinois, mandarin traditionnel",
  ) }

  val fr_CD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
    "gu" to "goudjrati",
    "pdc" to "allemand de Pennsylvanie",
    "sdh" to "kurde méridional",
  ) }

  val fr_CI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_CM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_DJ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_DZ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GP: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_GQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_HT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_KM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_LU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_ML: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MQ: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_MU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_NC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_PF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_PM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_RE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_RW: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_SC: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_SN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_SY: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_TD: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_TG: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_TN: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_VU: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_WF: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val fr_YT: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val frr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "frr" to "Nordfriisk",
  ) }

  val fur: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abcazian",
    "ae" to "avestan",
    "af" to "afrikaans",
    "am" to "amaric",
    "an" to "aragonês",
    "ang" to "vieri inglês",
    "ar" to "arap",
    "arc" to "aramaic",
    "as" to "assamês",
    "ast" to "asturian",
    "av" to "avar",
    "ay" to "aymarà",
    "az" to "azerbaijani",
    "az-alt-short" to "azerbaijani",
    "be" to "bielorùs",
    "bg" to "bulgar",
    "bn" to "bengalês",
    "bo" to "tibetan",
    "br" to "breton",
    "bs" to "bosniac",
    "ca" to "catalan",
    "ce" to "cecen",
    "ch" to "chamorro",
    "co" to "cors",
    "cop" to "coptic",
    "cr" to "cree",
    "cs" to "cec",
    "cu" to "sclâf de glesie",
    "cy" to "galês",
    "da" to "danês",
    "de" to "todesc",
    "de-AT" to "todesc de Austrie",
    "de-CH" to "alt todesc de Svuizare",
    "den" to "sclâf",
    "egy" to "vieri egjizian",
    "el" to "grêc",
    "en" to "inglês",
    "en-AU" to "inglês australian",
    "en-CA" to "inglês canadês",
    "en-GB" to "inglês britanic",
    "en-GB-alt-short" to "inglês britanic",
    "en-US" to "ingles merecan",
    "en-US-alt-short" to "ingles merecan",
    "eo" to "esperanto",
    "es" to "spagnûl",
    "es-419" to "spagnûl de Americhe Latine",
    "es-ES" to "spagnûl iberic",
    "et" to "eston",
    "eu" to "basc",
    "fa" to "persian",
    "ff" to "fulah",
    "fi" to "finlandês",
    "fil" to "filipin",
    "fj" to "fizian",
    "fo" to "faroês",
    "fr" to "francês",
    "fr-CA" to "francês dal Canade",
    "fr-CH" to "francês de Svuizare",
    "fro" to "vieri francês",
    "fur" to "furlan",
    "fy" to "frisian",
    "ga" to "gaelic irlandês",
    "gd" to "gaelic scozês",
    "gl" to "galizian",
    "gn" to "guaranì",
    "got" to "gotic",
    "grc" to "vieri grêc",
    "gu" to "gujarati",
    "gv" to "manx",
    "he" to "ebraic",
    "hi" to "hindi",
    "hr" to "cravuat",
    "ht" to "haitian",
    "hu" to "ongjarês",
    "hy" to "armen",
    "id" to "indonesian",
    "ig" to "igbo",
    "ik" to "inupiaq",
    "io" to "ido",
    "is" to "islandês",
    "it" to "talian",
    "iu" to "inuktitut",
    "ja" to "gjaponês",
    "ka" to "gjeorgjian",
    "kk" to "kazac",
    "kl" to "kalaallisut",
    "km" to "khmer",
    "kn" to "kannada",
    "ko" to "corean",
    "ku" to "curd",
    "kw" to "cornualiês",
    "la" to "latin",
    "lad" to "ladin",
    "lb" to "lussemburghês",
    "li" to "limburghês",
    "ln" to "lingala",
    "lo" to "lao",
    "lt" to "lituan",
    "lv" to "leton",
    "mg" to "malagasy",
    "mi" to "maori",
    "mk" to "macedon",
    "ml" to "malayalam",
    "mn" to "mongul",
    "mr" to "marathi",
    "ms" to "malês",
    "mt" to "maltês",
    "mul" to "lenghis multiplis",
    "mwl" to "mirandês",
    "nap" to "napoletan",
    "nb" to "norvegjês bokmål",
    "nd" to "ndebele setentrionâl",
    "nds" to "bas todesc",
    "ne" to "nepalês",
    "nl" to "olandês",
    "nl-BE" to "flamant",
    "nn" to "norvegjês nynorsk",
    "no" to "norvegjês",
    "non" to "vieri norvegjês",
    "nso" to "sotho setentrionâl",
    "nv" to "navajo",
    "oc" to "ocitan",
    "or" to "oriya",
    "os" to "osetic",
    "ota" to "turc otoman",
    "pa" to "punjabi",
    "pap" to "papiamento",
    "peo" to "vieri persian",
    "pl" to "polac",
    "pro" to "vieri provenzâl",
    "ps" to "pashto",
    "pt" to "portughês",
    "pt-BR" to "portughês brasilian",
    "pt-PT" to "portughês iberic",
    "qu" to "quechua",
    "rm" to "rumanç",
    "ro" to "romen",
    "ro-MD" to "moldâf",
    "ru" to "rus",
    "sa" to "sanscrit",
    "sc" to "sardegnûl",
    "scn" to "sicilian",
    "sco" to "scozês",
    "sd" to "sindhi",
    "se" to "sami setentrionâl",
    "sg" to "sango",
    "sga" to "vieri irlandês",
    "si" to "sinalês",
    "sk" to "slovac",
    "sl" to "sloven",
    "sm" to "samoan",
    "so" to "somal",
    "sq" to "albanês",
    "sr" to "serp",
    "ss" to "swati",
    "st" to "sotho meridionâl",
    "su" to "sundanês",
    "sux" to "sumeric",
    "sv" to "svedês",
    "sw" to "swahili",
    "ta" to "tamil",
    "te" to "telegu",
    "tet" to "tetum",
    "tg" to "tagic",
    "th" to "thai",
    "tk" to "turcmen",
    "tl" to "tagalog",
    "tr" to "turc",
    "tt" to "tartar",
    "ty" to "tahitian",
    "ug" to "uigur",
    "uk" to "ucrain",
    "und" to "indeterminade",
    "ur" to "urdu",
    "uz" to "uzbec",
    "ve" to "venda",
    "vi" to "vietnamite",
    "wa" to "valon",
    "wo" to "wolof",
    "xh" to "xhosa",
    "yi" to "yiddish",
    "yo" to "yoruba",
    "zh" to "cinês",
    "zh-alt-menu" to "cinês",
    "zh-Hans" to "cinês semplificât",
    "zh-Hans-alt-long" to "cinês semplificât",
    "zh-Hant" to "cinês tradizionâl",
    "zh-Hant-alt-long" to "cinês tradizionâl",
    "zu" to "zulu",
  ) }

  val fy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afar",
    "ab" to "Abchazysk",
    "ace" to "Atjeesk",
    "ach" to "Akoli",
    "ada" to "Adangme",
    "ady" to "Adyghe",
    "ae" to "Avestysk",
    "af" to "Afrikaansk",
    "afh" to "Afrihili",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "akk" to "Akkadysk",
    "ale" to "Aleut",
    "alt" to "Sûd-Altaïsk",
    "am" to "Amhaarsk",
    "an" to "Aragoneesk",
    "ang" to "âldingelsk",
    "anp" to "Angika",
    "ar" to "Arabysk",
    "ar-001" to "Modern standert Arabysk",
    "arc" to "Arameesk",
    "arn" to "Araukaansk",
    "arp" to "Arapaho",
    "arw" to "Arawak",
    "as" to "Assameesk",
    "asa" to "Asu",
    "ast" to "Asturysk",
    "av" to "Avarysk",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Azerbeidzjaansk",
    "az-alt-short" to "Azeri",
    "ba" to "Basjkiersk",
    "bal" to "Baloetsjysk",
    "ban" to "Balineesk",
    "bas" to "Basa",
    "bax" to "Bamoun",
    "bbj" to "Ghomala’",
    "be" to "Wyt-Russysk",
    "bej" to "Beja",
    "bem" to "Bemba",
    "bez" to "Bena",
    "bfd" to "Bafut",
    "bg" to "Bulgaarsk",
    "bho" to "Bhojpuri",
    "bi" to "Bislama",
    "bik" to "Bikol",
    "bin" to "Bini",
    "bkm" to "Kom",
    "bla" to "Siksika",
    "bm" to "Bambara",
    "bn" to "Bengaalsk",
    "bo" to "Tibetaansk",
    "br" to "Bretonsk",
    "bra" to "Braj",
    "brx" to "Bodo",
    "bs" to "Bosnysk",
    "bss" to "Akoose",
    "bua" to "Buriat",
    "bug" to "Bugineesk",
    "bum" to "Bulu",
    "byn" to "Blin",
    "byv" to "Medumba",
    "ca" to "Katalaansk",
    "cad" to "Kaddo",
    "car" to "Karibysk",
    "cay" to "Cayuga",
    "cch" to "Atsam",
    "ce" to "Tsjetsjeensk",
    "ceb" to "Cebuano",
    "cgg" to "Chiga",
    "ch" to "Chamorro",
    "chb" to "Chibcha",
    "chg" to "Chagatai",
    "chk" to "Chuukeesk",
    "chm" to "Mari",
    "chn" to "Chinook-jargon",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyenne",
    "ckb" to "Soranî",
    "ckb-alt-menu" to "Soranî",
    "ckb-alt-variant" to "Soranî",
    "co" to "Korsikaansk",
    "cop" to "Koptysk",
    "cr" to "Cree",
    "crh" to "Krim-Tataarsk",
    "cs" to "Tsjechysk",
    "csb" to "Kasjoebysk",
    "cu" to "Kerkslavysk",
    "cv" to "Tsjoevasjysk",
    "cy" to "Welsk",
    "da" to "Deensk",
    "dak" to "Dakota",
    "dar" to "Dargwa",
    "dav" to "Taita",
    "de" to "Dútsk",
    "de-AT" to "Eastenryks Dútsk",
    "de-CH" to "Switsersk Heechdútsk",
    "del" to "Delaware",
    "den" to "Slave",
    "dgr" to "Dogrib",
    "din" to "Dinka",
    "dje" to "Zarma",
    "doi" to "Dogri",
    "dsb" to "Nedersorbysk",
    "dua" to "Duala",
    "dum" to "Middelnederlânsk",
    "dv" to "Divehi",
    "dyo" to "Jola-Fonyi",
    "dyu" to "Dyula",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "egy" to "Aldegyptysk",
    "eka" to "Ekajuk",
    "el" to "Gryks",
    "elx" to "Elamitysk",
    "en" to "Ingelsk",
    "en-AU" to "Australysk Ingelsk",
    "en-CA" to "Kanadeesk Ingelsk",
    "en-GB" to "Britsk Ingelsk",
    "en-GB-alt-short" to "Britsk Ingelsk",
    "en-US" to "Amerikaansk Ingelsk",
    "en-US-alt-short" to "Amerikaansk Ingelsk",
    "enm" to "Middelingelsk",
    "eo" to "Esperanto",
    "es" to "Spaansk",
    "es-419" to "Latynsk-Amerikaansk Spaansk",
    "es-ES" to "Europeesk Spaansk",
    "es-MX" to "Meksikaansk Spaansk",
    "et" to "Estlânsk",
    "eu" to "Baskysk",
    "ewo" to "Ewondo",
    "fa" to "Perzysk",
    "fan" to "Fang",
    "fat" to "Fanti",
    "ff" to "Fulah",
    "fi" to "Finsk",
    "fil" to "Filipynsk",
    "fj" to "Fijysk",
    "fo" to "Faeröersk",
    "fon" to "Fon",
    "fr" to "Frânsk",
    "fr-CA" to "Kanadeesk Frânsk",
    "fr-CH" to "Switserse Frânsk",
    "frm" to "Middelfrânsk",
    "fro" to "Aldfrânsk",
    "frr" to "Noard-Frysk",
    "frs" to "East-Frysk",
    "fur" to "Friulysk",
    "fy" to "Frysk",
    "ga" to "Iersk",
    "gaa" to "Ga",
    "gay" to "Gayo",
    "gba" to "Gbaya",
    "gd" to "Schotsk Gaelic",
    "gez" to "Geez",
    "gil" to "Gilberteesk",
    "gl" to "Galisysk",
    "gmh" to "Middelheechdútsk",
    "gn" to "Guaraní",
    "goh" to "Alsheechdútsk",
    "gon" to "Gondi",
    "gor" to "Gorontalo",
    "got" to "Gothysk",
    "grb" to "Grebo",
    "grc" to "Aldgryks",
    "gsw" to "Switsers Dútsk",
    "gu" to "Gujarati",
    "guz" to "Gusii",
    "gv" to "Manks",
    "gwi" to "Gwichʼin",
    "ha" to "Hausa",
    "hai" to "Haida",
    "haw" to "Hawaïaansk",
    "he" to "Hebreeuwsk",
    "hi" to "Hindi",
    "hil" to "Hiligaynon",
    "hit" to "Hettitysk",
    "hmn" to "Hmong",
    "ho" to "Hiri Motu",
    "hr" to "Kroatysk",
    "hsb" to "Oppersorbysk",
    "ht" to "Haïtiaansk",
    "hu" to "Hongaarsk",
    "hup" to "Hupa",
    "hy" to "Armeensk",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Iban",
    "ibb" to "Ibibio",
    "id" to "Yndonezysk",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Sichuan Yi",
    "ik" to "Inupiaq",
    "ilo" to "Iloko",
    "inh" to "Ingoesj",
    "io" to "Ido",
    "is" to "Yslâns",
    "it" to "Italiaansk",
    "iu" to "Inuktitut",
    "ja" to "Japans",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jpr" to "Judeo-Perzysk",
    "jrb" to "Judeo-Arabysk",
    "jv" to "Javaansk",
    "ka" to "Georgysk",
    "kaa" to "Karakalpaks",
    "kab" to "Kabyle",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kaw" to "Kawi",
    "kbd" to "Kabardysk",
    "kbl" to "Kanembu",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kaapverdysk Creools",
    "kfo" to "Koro",
    "kg" to "Kongo",
    "kha" to "Khasi",
    "kho" to "Khotaneesk",
    "khq" to "Koyra Chiini",
    "ki" to "Kikuyu",
    "kj" to "Kuanyama",
    "kk" to "Kazachs",
    "kkj" to "Kako",
    "kl" to "Grienlâns",
    "kln" to "Kalenjin",
    "km" to "Khmer",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Koreaansk",
    "kok" to "Konkani",
    "kos" to "Kosraeaansk",
    "kpe" to "Kpelle",
    "kr" to "Kanuri",
    "krc" to "Karachay-Balkar",
    "krl" to "Karelysk",
    "kru" to "Kurukh",
    "ks" to "Kasjmiri",
    "ksb" to "Shambala",
    "ksf" to "Bafia",
    "ksh" to "Kölsch",
    "ku" to "Koerdysk",
    "kum" to "Koemuks",
    "kut" to "Kutenai",
    "kv" to "Komi",
    "kw" to "Cornish",
    "ky" to "Kirgizysk",
    "la" to "Latyn",
    "lad" to "Ladino",
    "lag" to "Langi",
    "lah" to "Lahnda",
    "lam" to "Lamba",
    "lb" to "Luxemburgs",
    "lez" to "Lezgysk",
    "lg" to "Ganda",
    "li" to "Limburgs",
    "lkt" to "Lakota",
    "ln" to "Lingala",
    "lo" to "Laotiaansk",
    "lol" to "Mongo",
    "loz" to "Lozi",
    "lt" to "Litouws",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lui" to "Luiseno",
    "lun" to "Lunda",
    "luo" to "Luo",
    "lus" to "Lushai",
    "luy" to "Luyia",
    "lv" to "Letlâns",
    "mad" to "Madurees",
    "maf" to "Mafa",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Makassaars",
    "man" to "Mandingo",
    "mas" to "Masai",
    "mde" to "Maba",
    "mdf" to "Moksha",
    "mdr" to "Mandar",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisyen",
    "mg" to "Malagasysk",
    "mga" to "Middeliers",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Meta’",
    "mh" to "Marshallees",
    "mi" to "Maori",
    "mic" to "Mi’kmaq",
    "min" to "Minangkabau",
    "mk" to "Macedonysk",
    "ml" to "Malayalam",
    "mn" to "Mongools",
    "mnc" to "Mantsjoe",
    "mni" to "Manipoeri",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Marathi",
    "ms" to "Maleis",
    "mt" to "Maltees",
    "mua" to "Mundang",
    "mul" to "Meardere talen",
    "mus" to "Creek",
    "mwl" to "Mirandees",
    "mwr" to "Marwari",
    "my" to "Birmees",
    "mye" to "Myene",
    "myv" to "Erzja",
    "na" to "Nauruaansk",
    "nap" to "Napolitaansk",
    "naq" to "Nama",
    "nb" to "Noors - Bokmål",
    "nd" to "Noard-Ndbele",
    "nds" to "Laagduits",
    "ne" to "Nepalees",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niueaansk",
    "nl" to "Nederlânsk",
    "nl-BE" to "Vlaams",
    "nmg" to "Ngumba",
    "nn" to "Noors - Nynorsk",
    "nnh" to "Ngiemboon",
    "no" to "Noors",
    "nog" to "Nogai",
    "non" to "Aldnoarsk",
    "nqo" to "N’ko",
    "nr" to "Sûd-Ndbele",
    "nso" to "Noard-Sotho",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "nwc" to "Klassiek Newari",
    "ny" to "Nyanja",
    "nym" to "Nyamwezi",
    "nyn" to "Nyankole",
    "nyo" to "Nyoro",
    "nzi" to "Nzima",
    "oc" to "Occitaansk",
    "oj" to "Ojibwa",
    "om" to "Oromo",
    "or" to "Odia",
    "os" to "Ossetysk",
    "osa" to "Osage",
    "ota" to "Ottomaansk-Turks",
    "pa" to "Punjabi",
    "pag" to "Pangasinan",
    "pal" to "Pahlavi",
    "pam" to "Pampanga",
    "pap" to "Papiaments",
    "pau" to "Palauaansk",
    "peo" to "Aldperzysk",
    "phn" to "Foenisysk",
    "pi" to "Pali",
    "pl" to "Poalsk",
    "pon" to "Pohnpeiaansk",
    "pro" to "Aldprovençaals",
    "ps" to "Pasjtoe",
    "ps-alt-variant" to "Pashto",
    "pt" to "Portugeesk",
    "pt-BR" to "Brazyljaansk Portugees",
    "pt-PT" to "Europees Portugees",
    "qu" to "Quechua",
    "raj" to "Rajasthani",
    "rap" to "Rapanui",
    "rar" to "Rarotongan",
    "rm" to "Reto-Romaansk",
    "rn" to "Kirundi",
    "ro" to "Roemeensk",
    "ro-MD" to "Moldavysk",
    "rof" to "Rombo",
    "rom" to "Romani",
    "ru" to "Russysk",
    "rup" to "Aromaniaansk",
    "rw" to "Kinyarwanda",
    "rwk" to "Rwa",
    "sa" to "Sanskriet",
    "sad" to "Sandawe",
    "sah" to "Jakoets",
    "sam" to "Samaritaansk-Arameesk",
    "saq" to "Samburu",
    "sas" to "Sasak",
    "sat" to "Santali",
    "sba" to "Ngambay",
    "sbp" to "Sangu",
    "sc" to "Sardinysk",
    "scn" to "Siciliaansk",
    "sco" to "Schots",
    "sd" to "Sindhi",
    "se" to "Noard-Samysk",
    "see" to "Seneca",
    "seh" to "Sena",
    "sel" to "Selkup",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "sga" to "Aldyrsk",
    "sh" to "Servokroatysk",
    "shi" to "Tashelhiyt",
    "shn" to "Shan",
    "shu" to "Tsjadysk Arabysk",
    "si" to "Singalees",
    "sid" to "Sidamo",
    "sk" to "Slowaaks",
    "sl" to "Sloveensk",
    "sm" to "Samoaansk",
    "sma" to "Sûd-Samysk",
    "smj" to "Lule Sami",
    "smn" to "Inari Sami",
    "sms" to "Skolt Sami",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somalysk",
    "sog" to "Sogdysk",
    "sq" to "Albaneesk",
    "sr" to "Servysk",
    "srn" to "Sranantongo",
    "srr" to "Serer",
    "ss" to "Swazi",
    "ssy" to "Saho",
    "st" to "Sûd-Sotho",
    "su" to "Soendaneesk",
    "suk" to "Sukuma",
    "sus" to "Soesoe",
    "sux" to "Soemerysk",
    "sv" to "Zweeds",
    "sw" to "Swahili",
    "sw-CD" to "Congo Swahili",
    "swb" to "Shimaore",
    "syc" to "Klassiek Syrysk",
    "syr" to "Syrysk",
    "ta" to "Tamil",
    "te" to "Telugu",
    "tem" to "Timne",
    "teo" to "Teso",
    "ter" to "Tereno",
    "tet" to "Tetun",
    "tg" to "Tadzjieks",
    "th" to "Thais",
    "ti" to "Tigrinya",
    "tig" to "Tigre",
    "tiv" to "Tiv",
    "tk" to "Turkmeens",
    "tkl" to "Tokelaus",
    "tl" to "Tagalog",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tmh" to "Tamashek",
    "tn" to "Tswana",
    "to" to "Tongaansk",
    "tog" to "Nyasa Tonga",
    "tpi" to "Tok Pisin",
    "tr" to "Turks",
    "trv" to "Taroko",
    "ts" to "Tsonga",
    "tsi" to "Tsimshian",
    "tt" to "Tataars",
    "tum" to "Toemboeka",
    "tvl" to "Tuvaluaansk",
    "tw" to "Twi",
    "twq" to "Tasawaq",
    "ty" to "Tahitysk",
    "tyv" to "Tuvinysk",
    "tzm" to "Tamazight (Sintraal-Marokko)",
    "udm" to "Oedmoerts",
    "ug" to "Oeigoers",
    "uga" to "Oegaritysk",
    "uk" to "Oekraïens",
    "umb" to "Umbundu",
    "und" to "Onbekende taal",
    "ur" to "Urdu",
    "uz" to "Oezbeeks",
    "vai" to "Vai",
    "ve" to "Venda",
    "vi" to "Vietnamees",
    "vo" to "Volapük",
    "vot" to "Votysk",
    "vun" to "Vunjo",
    "wa" to "Waals",
    "wae" to "Walser",
    "wal" to "Walamo",
    "war" to "Waray",
    "was" to "Washo",
    "wo" to "Wolof",
    "xal" to "Kalmyk",
    "xh" to "Xhosa",
    "xog" to "Soga",
    "yao" to "Yao",
    "yap" to "Yapees",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Jiddysk",
    "yo" to "Yoruba",
    "yue" to "Kantoneesk",
    "yue-alt-menu" to "Kantoneesk",
    "za" to "Zhuang",
    "zap" to "Zapotec",
    "zbl" to "Blissymbolen",
    "zen" to "Zenaga",
    "zgh" to "Standert Marokkaanske Tamazight",
    "zh" to "Sineesk",
    "zh-alt-menu" to "Sineesk",
    "zh-Hans" to "Ferienfâldich Sineesk",
    "zh-Hans-alt-long" to "Ferienfâldich Sineesk",
    "zh-Hant" to "Tradisjoneel Sineesk",
    "zh-Hant-alt-long" to "Tradisjoneel Sineesk",
    "zu" to "Zulu",
    "zun" to "Zuni",
    "zxx" to "Gjin linguïstyske ynhâld",
    "zza" to "Zaza",
  ) }

  val ga: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afáiris",
    "ab" to "Abcáisis",
    "ace" to "Aicinéis",
    "ada" to "Daingmis",
    "ady" to "Adaigéis",
    "ae" to "Aivéistis",
    "af" to "Afracáinis",
    "agq" to "Aigeimis",
    "ain" to "Aidhniúis",
    "ak" to "Acáinis",
    "akk" to "Acáidis",
    "ale" to "Ailiúitis",
    "alt" to "Altaeis an Deiscirt",
    "am" to "Amáiris",
    "an" to "Aragóinis",
    "ang" to "Sean-Bhéarla",
    "ann" to "Obolo",
    "anp" to "Aingícis",
    "ar" to "Araibis",
    "ar-001" to "Araibis Chaighdeánach",
    "arc" to "Aramais",
    "arn" to "Mapúitsis",
    "arp" to "Arapachóis",
    "ars" to "Araibis Najdi",
    "as" to "Asaimis",
    "asa" to "Asúis",
    "ast" to "Astúiris",
    "atj" to "Atikamekw",
    "av" to "Aváiris",
    "awa" to "Avaidis",
    "ay" to "Aidhmiris",
    "az" to "Asarbaiseáinis",
    "az-alt-short" to "Asairis",
    "ba" to "Baiscíris",
    "ban" to "Bailís",
    "bar" to "Baváiris",
    "bas" to "Basáis",
    "be" to "Bealarúisis",
    "bem" to "Beimbis",
    "bez" to "Beinis",
    "bg" to "Bulgáiris",
    "bgc" to "Haryanvi",
    "bho" to "Vóispiris",
    "bi" to "Bioslaimis",
    "bin" to "Binis",
    "bla" to "Sicsicis",
    "blo" to "Anii",
    "bm" to "Bambairis",
    "bn" to "Beangáilis",
    "bo" to "Tibéidis",
    "br" to "Briotáinis",
    "brx" to "Bódóis",
    "bs" to "Boisnis",
    "bua" to "Buiriáitis",
    "bug" to "Buiginis",
    "byn" to "Blinis",
    "ca" to "Catalóinis",
    "cay" to "teanga Cayuga",
    "ccp" to "Seácmais",
    "ce" to "Seisnis",
    "ceb" to "Seabúáinis",
    "cgg" to "Cígis",
    "ch" to "Seamóiris",
    "chk" to "Siúicísis",
    "chm" to "Mairis",
    "cho" to "Seactáis",
    "chp" to "Siopúáinis",
    "chr" to "Seiricis",
    "chy" to "Siáinis",
    "ckb" to "Coirdis Lárnach",
    "ckb-alt-menu" to "Coirdis Lárnach",
    "ckb-alt-variant" to "Coirdis, Sóráinis",
    "clc" to "Chilcotin",
    "co" to "Corsaicis",
    "cop" to "Coptais",
    "cr" to "Craís",
    "crg" to "Michif",
    "crj" to "Craís an Deiscirt Thoir",
    "crk" to "Plains Cree",
    "crl" to "Craís Thoir Thuaidh",
    "crm" to "Moose Cree",
    "crr" to "teanga Algancach Carolina",
    "crs" to "Criól Fraincise Seselwa",
    "cs" to "Seicis",
    "csb" to "Caisiúibis",
    "csw" to "Swampy Cree",
    "cu" to "Slavais na hEaglaise",
    "cv" to "Suvaisis",
    "cy" to "Breatnais",
    "da" to "Danmhairgis",
    "dak" to "Dacótais",
    "dar" to "Dargais",
    "dav" to "Taita",
    "de" to "Gearmáinis",
    "de-AT" to "Gearmáinis na hOstaire",
    "de-CH" to "Ard-Ghearmáinis Eilvéiseach",
    "dgr" to "Dograibis",
    "dje" to "Zarmais",
    "doi" to "Dóigris",
    "dsb" to "Sorbais Íochtarach",
    "dua" to "Duailis",
    "dum" to "Meán-Ollainnis",
    "dv" to "Divéihis",
    "dyo" to "Jóla-Fainis",
    "dz" to "Seoinicis",
    "dzg" to "Dazaga",
    "ebu" to "Ciambúis",
    "ee" to "Éabhais",
    "efi" to "Eificis",
    "egy" to "Sean-Éigiptis",
    "eka" to "Acaidiúcais",
    "el" to "Gréigis",
    "en" to "Béarla",
    "en-AU" to "Béarla na hAstráile",
    "en-CA" to "Béarla Cheanada",
    "en-GB" to "Béarla na Breataine",
    "en-GB-alt-short" to "Béarla na R.A.",
    "en-US" to "Béarla Mheiriceá",
    "en-US-alt-short" to "Béarla S.A.M.",
    "enm" to "Meán-Bhéarla",
    "eo" to "Esperanto",
    "es" to "Spáinnis",
    "es-419" to "Spáinnis Mheiriceá Laidinigh",
    "es-ES" to "Spáinnis Eorpach",
    "es-MX" to "Spáinnis Mheicsiceach",
    "et" to "Eastóinis",
    "eu" to "Bascais",
    "ewo" to "Éabhandóis",
    "fa" to "Peirsis",
    "fa-AF" to "Dairis",
    "ff" to "Fuláinis",
    "fi" to "Fionlainnis",
    "fil" to "Filipínis",
    "fj" to "Fidsis",
    "fo" to "Faróis",
    "fon" to "Fonais",
    "fr" to "Fraincis",
    "fr-CA" to "Fraincis Cheanada",
    "fr-CH" to "Fraincis na hEilvéise",
    "frc" to "Fraincis Cajun",
    "frm" to "Meán-Fhraincis",
    "fro" to "Sean-Fhraincis",
    "frr" to "Freaslainnis an Tuaiscirt",
    "fur" to "Friúilis",
    "fy" to "Freaslainnis Iartharach",
    "ga" to "Gaeilge",
    "gaa" to "Geáis",
    "gan" to "Sínis Gan",
    "gd" to "Gaeilge na hAlban",
    "gez" to "Aetóipis",
    "gil" to "Gilbeartais",
    "gl" to "Gailísis",
    "gmh" to "Meán-Ard-Ghearmáinis",
    "gn" to "Guaráinis",
    "goh" to "Sean-Ard-Ghearmáinis",
    "gor" to "Gorantalais",
    "grc" to "Sean-Ghréigis",
    "gsw" to "Gearmáinis Eilvéiseach",
    "gu" to "Gúisearáitis",
    "guc" to "Uaúis",
    "guz" to "Gúsaís",
    "gv" to "Manainnis",
    "gwi" to "Goitsinis",
    "ha" to "Hásais",
    "hai" to "Haídis",
    "hak" to "Haicéis",
    "haw" to "Haváis",
    "hax" to "Haídis an Deiscirt",
    "he" to "Eabhrais",
    "hi" to "Hiondúis",
    "hif" to "Hiondúis Fhidsí",
    "hil" to "Hilgeanóinis",
    "hit" to "Hitis",
    "hmn" to "Hmongais",
    "ho" to "Motúis Hírí",
    "hr" to "Cróitis",
    "hsb" to "Sorbais Uachtarach",
    "hsn" to "Sínis Xiang",
    "ht" to "Críol Háítí",
    "hu" to "Ungáiris",
    "hup" to "Húipis",
    "hur" to "Halkomelem",
    "hy" to "Airméinis",
    "hz" to "Heiréiris",
    "ia" to "Interlingua",
    "iba" to "Ibeainis",
    "ibb" to "Ibibis",
    "id" to "Indinéisis",
    "ie" to "Interlingue",
    "ig" to "Íogbóis",
    "ii" to "Ís Shichuan",
    "ik" to "Iniúipiaicis",
    "ikt" to "Ionúitis Iarthar Cheanada",
    "ilo" to "Ileacáinis",
    "inh" to "Iongúis",
    "io" to "Ídis",
    "is" to "Íoslainnis",
    "it" to "Iodáilis",
    "iu" to "Ionúitis",
    "ja" to "Seapáinis",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jut" to "Iútlainnis",
    "jv" to "Iáivis",
    "ka" to "Seoirsis",
    "kaa" to "Cara-Chalpáis",
    "kab" to "Caibílis",
    "kac" to "Caitsinis",
    "kaj" to "Jju",
    "kam" to "Cambais",
    "kbd" to "Cabairdis",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Criól Cabo Verde",
    "kfo" to "Koro",
    "kg" to "Congóis",
    "kgp" to "Kaingang",
    "kha" to "Caisis",
    "khq" to "Songais Iartharach",
    "ki" to "Ciocúis",
    "kj" to "Cuainiáimis",
    "kk" to "Casaicis",
    "kkj" to "Cacóis",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Ciméiris",
    "kmb" to "Ciombundais",
    "kn" to "Cannadais",
    "ko" to "Cóiréis",
    "kok" to "Concáinis",
    "kpe" to "Caipeilis",
    "kr" to "Canúiris",
    "krc" to "Caraicí-Balcáiris",
    "krl" to "Cairéilis",
    "kru" to "Curúicis",
    "ks" to "Caismíris",
    "ksb" to "Shambala",
    "ksf" to "Baifiais",
    "ksh" to "Coilsis",
    "ku" to "Coirdis",
    "kum" to "Cúimicis",
    "kv" to "Coimis",
    "kw" to "Coirnis",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kuvi",
    "ky" to "Cirgisis",
    "la" to "Laidin",
    "lad" to "Laidínis",
    "lag" to "Ciolaingis",
    "lah" to "Puinseáibis Iartharach",
    "lb" to "Lucsambuirgis",
    "lez" to "Leisgis",
    "lg" to "Lugandais",
    "li" to "Liombuirgis",
    "lij" to "Liogúiris",
    "lil" to "Lillooet",
    "liv" to "Liovóinis",
    "lkt" to "Lacótais",
    "lmo" to "Lombairdis",
    "ln" to "Liongáilis",
    "lo" to "Laoisis",
    "lou" to "Criól Louisiana",
    "loz" to "Lóisis",
    "lrc" to "Lúiris an Tuaiscirt",
    "lsm" to "Saamia",
    "lt" to "Liotuáinis",
    "lu" to "Lúba-Cataingis",
    "lua" to "Luba-Lulua",
    "lun" to "Lundais",
    "luo" to "Lúóis",
    "lus" to "Míosóis",
    "luy" to "Luyia",
    "lv" to "Laitvis",
    "mad" to "Maidiúiris",
    "mag" to "Magaidis",
    "mai" to "Maitilis",
    "mak" to "Macasairis",
    "mas" to "Másais",
    "mdf" to "Mocsais",
    "men" to "Meindis",
    "mer" to "Meru",
    "mfe" to "Morisyen",
    "mg" to "Malagáisis",
    "mga" to "Meán-Ghaeilge",
    "mgh" to "Meiteo-Macuais",
    "mgo" to "Metaʼ",
    "mh" to "Mairsillis",
    "mi" to "Maorais",
    "mic" to "Micmeaicis",
    "min" to "Míneangcababhais",
    "mk" to "Macadóinis",
    "ml" to "Mailéalaimis",
    "mn" to "Mongóilis",
    "mni" to "Manapúiris",
    "moe" to "Innu-aimun",
    "moh" to "Móháicis",
    "mos" to "Mosais",
    "mr" to "Maraitis",
    "mrj" to "Mairis Iartharach",
    "ms" to "Malaeis",
    "mt" to "Máltais",
    "mua" to "Mundang",
    "mul" to "Ilteangacha",
    "mus" to "Muscogee",
    "mwl" to "Mioraindéis",
    "mwr" to "Marmhairis",
    "my" to "Burmais",
    "myv" to "Éirsis",
    "mzn" to "Mázandaráinis",
    "na" to "Nárúis",
    "nan" to "Sínis Min Nan",
    "nap" to "Napóilis",
    "naq" to "Nama",
    "nb" to "Bocmál",
    "nd" to "N-deibéilis an Tuaiscirt",
    "nds" to "Gearmáinis Íochtarach",
    "nds-NL" to "Sacsainis Íochtarach",
    "ne" to "Neipeailis",
    "new" to "Néamharais",
    "ng" to "Ndongais",
    "nia" to "Niaisis",
    "niu" to "Níobhais",
    "nl" to "Ollainnis",
    "nl-BE" to "Pléimeannais",
    "nmg" to "Cuaiseois",
    "nn" to "Nua-Ioruais",
    "nnh" to "Ngiemboon",
    "no" to "Ioruais",
    "nog" to "Nógaeis",
    "non" to "Sean-Lochlainnis",
    "nqo" to "N-cóis",
    "nr" to "Ndeibéilis an Deiscirt",
    "nso" to "Sútúis an Tuaiscirt",
    "nus" to "Nuairis",
    "nv" to "Navachóis",
    "ny" to "Siséivis",
    "nyn" to "Niancóilis",
    "oc" to "Ocsatáinis",
    "oj" to "Óisibis",
    "ojb" to "Óisibis Iarthuiscirt",
    "ojc" to "Óisibis Lárnach",
    "ojs" to "Oji-Cree",
    "ojw" to "Óisibis an Iarthar",
    "oka" to "Okanagan",
    "om" to "Oraimis",
    "or" to "Odia",
    "os" to "Oiséitis",
    "pa" to "Puinseáibis",
    "pag" to "Pangasaíneánais",
    "pam" to "Pampaingis",
    "pap" to "Paipeamaintis",
    "pau" to "Palabhais",
    "pcm" to "pidsean na Nigéire",
    "peo" to "Sean-Pheirsis",
    "pi" to "Páilis",
    "pis" to "Pijin",
    "pl" to "Polainnis",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Prúisis",
    "ps" to "Paistis",
    "pt" to "Portaingéilis",
    "pt-BR" to "Portaingéilis Bhrasaíleach",
    "pt-PT" to "Portaingéilis Ibéarach",
    "qu" to "Ceatsuais",
    "quc" to "Cuitséis",
    "raj" to "Rajasthani",
    "rap" to "Rapanúis",
    "rar" to "Raratongais",
    "rhg" to "Róihinis",
    "rm" to "Rómainis",
    "rn" to "Rúindis",
    "ro" to "Rómáinis",
    "ro-MD" to "Moldáivis",
    "rof" to "Rombo",
    "rom" to "Romainis",
    "ru" to "Rúisis",
    "rup" to "Arómáinis",
    "rw" to "Ciniaruaindis",
    "rwk" to "Rwa",
    "sa" to "Sanscrait",
    "sad" to "Sandabhais",
    "sah" to "Sachais",
    "sam" to "Aramais Shamárach",
    "saq" to "Samburu",
    "sat" to "Santáilis",
    "sba" to "Ngambay",
    "sbp" to "Sangu",
    "sc" to "Sairdínis",
    "scn" to "Sicilis",
    "sco" to "Albainis",
    "sd" to "Sindis",
    "se" to "Sáimis an Tuaiscirt",
    "seh" to "Sena",
    "ses" to "Songais Oirthearach",
    "sg" to "Sangóis",
    "sga" to "Sean-Ghaeilge",
    "sh" to "Seirbea-Chróitis",
    "shi" to "Tachelhit",
    "shn" to "Seánais",
    "si" to "Siolóinis",
    "sk" to "Slóvaicis",
    "sl" to "Slóivéinis",
    "slh" to "Lushootseed an Deiscirt",
    "sm" to "Samóis",
    "sma" to "Sáimis Theas",
    "smj" to "Sáimis Lule",
    "smn" to "Sáimis Inari",
    "sms" to "Sáimis Skolt",
    "sn" to "Seoinis",
    "snk" to "Soinincéis",
    "so" to "Somáilis",
    "sog" to "Sogdánais",
    "sq" to "Albáinis",
    "sr" to "Seirbis",
    "srn" to "Suranaimis",
    "ss" to "Suaisis",
    "st" to "Sútúis an Deiscirt",
    "str" to "Straits Salish",
    "su" to "Sundais",
    "suk" to "Sucúimis",
    "sux" to "Suiméiris",
    "sv" to "Sualainnis",
    "sw" to "Svahaílis",
    "sw-CD" to "Svahaílis an Chongó",
    "swb" to "teanga na gComórach",
    "syr" to "Siricis",
    "szl" to "Siléisis",
    "ta" to "Tamailis",
    "tce" to "Tutchone an Deiscirt",
    "te" to "Teileagúis",
    "tem" to "Teimnis",
    "teo" to "Teso",
    "tet" to "Teitimis",
    "tg" to "Taidsícis",
    "tgx" to "Tagish",
    "th" to "Téalainnis",
    "tht" to "Tahltan",
    "ti" to "Tigrinis",
    "tig" to "Tigréis",
    "tk" to "Tuircméinis",
    "tl" to "Tagálaigis",
    "tlh" to "Klingon",
    "tli" to "Clincitis",
    "tn" to "Suáinis",
    "to" to "Tongais",
    "tok" to "Toki Pona",
    "tpi" to "Tok Pisin",
    "tr" to "Tuircis",
    "trv" to "Taroko",
    "ts" to "Songais",
    "tt" to "Tatairis",
    "ttm" to "Northern Tutchone",
    "tum" to "Tumbúicis",
    "tvl" to "Tuvalu",
    "tw" to "Tíbhis",
    "twq" to "Tasawaq",
    "ty" to "Taihítis",
    "tyv" to "Túvainis",
    "tzm" to "Tamaisis Atlais Láir",
    "udm" to "Udmairtis",
    "ug" to "Uigiúiris",
    "uk" to "Úcráinis",
    "umb" to "Umbundais",
    "und" to "Teanga anaithnid",
    "ur" to "Urdúis",
    "uz" to "Úisbéiceastáinis",
    "vai" to "Vadhais",
    "ve" to "Veindis",
    "vec" to "Veinéisis",
    "vi" to "Vítneaimis",
    "vls" to "Pléimeannais Iartharach",
    "vmw" to "Macuais",
    "vo" to "Volapük",
    "vun" to "Vunjo",
    "wa" to "Vallúnais",
    "wae" to "Walser",
    "wal" to "Uailéitis",
    "war" to "Uairéis",
    "wo" to "Volaifis",
    "wuu" to "Sínis Wu",
    "xal" to "Cailmícis",
    "xh" to "Cóisis",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Giúdais",
    "yo" to "Iarúibis",
    "yrl" to "Nheengatu",
    "yue" to "Cantainis",
    "yue-alt-menu" to "Sínis, Cantainis",
    "za" to "Siuáingis",
    "zea" to "Séalainnis",
    "zgh" to "Tamaisis Chaighdeánach Mharacó",
    "zh" to "Sínis",
    "zh-alt-menu" to "Sínis, Mandairínis",
    "zh-Hans" to "Sínis Shimplithe",
    "zh-Hans-alt-long" to "Mandairínis Shimplithe",
    "zh-Hant" to "Sínis Thraidisiúnta",
    "zh-Hant-alt-long" to "Mandairínis Thraidisiúnta",
    "zu" to "Súlúis",
    "zun" to "Zúinis",
    "zxx" to "Gan ábhar teangeolaíoch",
    "zza" to "Zázá",
  ) }

  val ga_GB: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gaa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "en" to "Blɔfo",
    "gaa" to "Gã",
  ) }

  val gd: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afar",
    "ab" to "Abchasais",
    "ace" to "Basa Acèh",
    "ach" to "Acoli",
    "ada" to "Adangme",
    "ady" to "Adyghe",
    "ae" to "Avestanais",
    "aeb" to "Arabais Thuiniseach",
    "af" to "Afraganais",
    "afh" to "Afrihili",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "akk" to "Acadais",
    "akz" to "Alabama",
    "ale" to "Aleutais",
    "aln" to "Albàinis Ghegeach",
    "alt" to "Altais Dheasach",
    "am" to "Amtharais",
    "an" to "Aragonais",
    "ang" to "Seann-Bheurla",
    "ann" to "Obolo",
    "anp" to "Angika",
    "apc" to "Arabais Levantach",
    "ar" to "Arabais",
    "ar-001" to "Nuadh-Arabais Stannardach",
    "arc" to "Aramais",
    "arn" to "Mapudungun",
    "aro" to "Araona",
    "arp" to "Arapaho",
    "arq" to "Arabais Aildireach",
    "ars" to "Arabais Najdi",
    "arw" to "Arawak",
    "ary" to "Arabais Mhorocach",
    "arz" to "Arabais Èipheiteach",
    "as" to "Asamais",
    "asa" to "Asu",
    "ase" to "Cainnt-shanais na h-Aimeireaga",
    "ast" to "Astùrais",
    "atj" to "Atikamekw",
    "av" to "Avarais",
    "avk" to "Kotava",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Asarbaideànais",
    "az-alt-short" to "Azeri",
    "ba" to "Bashkir",
    "bal" to "Baluchì",
    "ban" to "Cànan Bali",
    "bas" to "Basaa",
    "bax" to "Bamun",
    "bbc" to "Batak Toba",
    "bbj" to "Ghomala",
    "be" to "Bealaruisis",
    "bej" to "Beja",
    "bem" to "Bemba",
    "bew" to "Betawi",
    "bez" to "Bena",
    "bfd" to "Bafut",
    "bfq" to "Badaga",
    "bg" to "Bulgarais",
    "bgc" to "Haryanvi",
    "bgn" to "Balochi Shiarach",
    "bho" to "Bhojpuri",
    "bi" to "Bislama",
    "bik" to "Bikol",
    "bin" to "Edo",
    "bjn" to "Banjar",
    "bkm" to "Kom",
    "bla" to "Siksika",
    "blo" to "Anii",
    "blt" to "Tai Dam",
    "bm" to "Bambara",
    "bn" to "Bangla",
    "bo" to "Tibeitis",
    "bpy" to "Bishnupriya",
    "bqi" to "Bakhtiari",
    "br" to "Breatnais",
    "bra" to "Braj",
    "brh" to "Brahui",
    "brx" to "Bodo",
    "bs" to "Bosnais",
    "bss" to "Akoose",
    "bua" to "Buriat",
    "bug" to "Cànan nam Bugis",
    "bum" to "Bulu",
    "byn" to "Blin",
    "byv" to "Medumba",
    "ca" to "Catalanais",
    "cad" to "Caddo",
    "car" to "Carib",
    "cay" to "Cayuga",
    "cch" to "Atsam",
    "ccp" to "Chakma",
    "ce" to "Deideanais",
    "ceb" to "Cebuano",
    "cgg" to "Chiga",
    "ch" to "Chamorro",
    "chb" to "Chibcha",
    "chg" to "Chagatai",
    "chk" to "Cànan Chuuk",
    "chm" to "Mari",
    "chn" to "Chinuk Wawa",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyenne",
    "cic" to "Chickasaw",
    "ckb" to "Cùrdais Mheadhanach",
    "ckb-alt-menu" to "Cùrdais Mheadhanach",
    "ckb-alt-variant" to "Cùrdais Sorani",
    "clc" to "Chilcotin",
    "co" to "Corsais",
    "cop" to "Coptais",
    "cps" to "Capiznon",
    "cr" to "Cree",
    "crg" to "Michif",
    "crh" to "Turcais Chriomach",
    "crj" to "Cree Ear-dheasach",
    "crk" to "Cree nam Machair",
    "crl" to "Cree Ear-thuathach",
    "crm" to "Moose Cree",
    "crr" to "Algonquianais Charolina",
    "crs" to "Seiseallais",
    "cs" to "Seicis",
    "csb" to "Caisiubais",
    "csw" to "Omushkego",
    "cu" to "Slàbhais na h-Eaglaise",
    "cv" to "Chuvash",
    "cy" to "Cuimris",
    "da" to "Danmhairgis",
    "dak" to "Dakota",
    "dar" to "Dargwa",
    "dav" to "Taita",
    "de" to "Gearmailtis",
    "de-AT" to "Gearmailtis na h-Ostaire",
    "de-CH" to "Àrd-Ghearmailtis na h-Eilbheise",
    "del" to "Delaware",
    "den" to "Slavey",
    "dgr" to "Dogrib",
    "din" to "Dinka",
    "dje" to "Zarma",
    "doi" to "Dogri",
    "dsb" to "Sòrbais Ìochdarach",
    "dtp" to "Dusun Mheadhanach",
    "dua" to "Duala",
    "dum" to "Meadhan-Dhuitsis",
    "dv" to "Divehi",
    "dyo" to "Jola-Fonyi",
    "dyu" to "Dyula",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "egy" to "Èipheitis Àrsaidh",
    "eka" to "Ekajuk",
    "el" to "Greugais",
    "elx" to "Elamais",
    "en" to "Beurla",
    "en-AU" to "Beurla Astràilia",
    "en-CA" to "Beurla Chanada",
    "en-GB" to "Beurla Bhreatainn",
    "en-GB-alt-short" to "Beurla na RA",
    "en-US" to "Beurla na h-Aimeireaga",
    "en-US-alt-short" to "Beurla nan SA",
    "enm" to "Meadhan-Bheurla",
    "eo" to "Esperanto",
    "es" to "Spàinntis",
    "es-419" to "Spàinntis na h-Aimeireaga Laidinneach",
    "es-ES" to "Spàinntis Eòrpach",
    "es-MX" to "Spàinntis Mheagsagach",
    "esu" to "Yupik Mheadhanach",
    "et" to "Eastoinis",
    "eu" to "Basgais",
    "ewo" to "Ewondo",
    "ext" to "Cànan na h-Extremadura",
    "fa" to "Peirsis",
    "fa-AF" to "Dari",
    "fan" to "Fang",
    "fat" to "Fanti",
    "ff" to "Fulah",
    "fi" to "Fionnlannais",
    "fil" to "Filipinis",
    "fit" to "Meänkieli",
    "fj" to "Fìdis",
    "fo" to "Fàrothais",
    "fon" to "Fon",
    "fr" to "Fraingis",
    "fr-CA" to "Fraingis Chanada",
    "fr-CH" to "Fraingis Eilbheiseach",
    "frc" to "Fraingis nan Cajun",
    "frm" to "Meadhan-Fhraingis",
    "fro" to "Seann-Fhraingis",
    "frp" to "Arpitan",
    "frr" to "Frìoslannais Thuathach",
    "frs" to "Frìoslannais Earach",
    "fur" to "Friùilis",
    "fy" to "Frìoslannais Shiarach",
    "ga" to "Gaeilge",
    "gaa" to "Ga",
    "gag" to "Gagauz",
    "gan" to "Gan",
    "gay" to "Gayo",
    "gba" to "Gbaya",
    "gbz" to "Dari Zoroastrach",
    "gd" to "Gàidhlig",
    "gez" to "Ge’ez",
    "gil" to "Ciribeasais",
    "gl" to "Gailìsis",
    "glk" to "Gilaki",
    "gmh" to "Meadhan-Àrd-Gearmailtis",
    "gn" to "Guaraní",
    "goh" to "Seann-Àrd-Gearmailtis",
    "gon" to "Gondi",
    "gor" to "Gorontalo",
    "got" to "Gotais",
    "grb" to "Grebo",
    "grc" to "Greugais Àrsaidh",
    "gsw" to "Gearmailtis Eilbheiseach",
    "gu" to "Gujarati",
    "guc" to "Wayuu",
    "gur" to "Frafra",
    "guz" to "Gusii",
    "gv" to "Gaelg",
    "gwi" to "Gwichʼin",
    "ha" to "Hausa",
    "hai" to "Haida",
    "hak" to "Hakka",
    "haw" to "Cànan Hawai’i",
    "hax" to "Haida Dheasach",
    "he" to "Eabhra",
    "hi" to "Hindis",
    "hi-Latn-alt-variant" to "Hinglish",
    "hif" to "Hindis Fhìditheach",
    "hil" to "Hiligaynon",
    "hit" to "Cànan Het",
    "hmn" to "Hmong",
    "hnj" to "Hmong Njua",
    "ho" to "Hiri Motu",
    "hr" to "Cròthaisis",
    "hsb" to "Sòrbais Uachdarach",
    "hsn" to "Xiang",
    "ht" to "Crìtheol Haidhti",
    "hu" to "Ungairis",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Airmeinis",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Iban",
    "ibb" to "Ibibio",
    "id" to "Innd-Innsis",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Yi Sichuan",
    "ik" to "Inupiaq",
    "ikt" to "Inuktitut Shiarach Chanada",
    "ilo" to "Iloko",
    "inh" to "Ingush",
    "io" to "Ido",
    "is" to "Innis Tìlis",
    "it" to "Eadailtis",
    "iu" to "Inuktitut",
    "ja" to "Seapanais",
    "jam" to "Beurla Crìtheolach Diameuga",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jpr" to "Peirsis Iùdhach",
    "jrb" to "Arabais Iùdhach",
    "jv" to "Deàbhanais",
    "ka" to "Cairtbheilis",
    "kaa" to "Kara-Kalpak",
    "kab" to "Kabyle",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kaw" to "Kawi",
    "kbd" to "Cabardais",
    "kbl" to "Kanembu",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kabuverdianu",
    "ken" to "Kenyang",
    "kfo" to "Koro",
    "kg" to "Kongo",
    "kgp" to "Kaingang",
    "kha" to "Khasi",
    "kho" to "Cànan Khotan",
    "khq" to "Koyra Chiini",
    "khw" to "Khowar",
    "ki" to "Kikuyu",
    "kiu" to "Kirmanjki",
    "kj" to "Kuanyama",
    "kk" to "Casachais",
    "kkj" to "Kako",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Cmèar",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Coirèanais",
    "koi" to "Komi-Permyak",
    "kok" to "Konkani",
    "kpe" to "Kpelle",
    "kr" to "Kanuri",
    "krc" to "Karachay-Balkar",
    "kri" to "Krio",
    "krj" to "Kinaray-a",
    "krl" to "Cairealais",
    "kru" to "Kurukh",
    "ks" to "Caismiris",
    "ksb" to "Shambala",
    "ksf" to "Bafia",
    "ksh" to "Gearmailtis Chologne",
    "ku" to "Cùrdais",
    "kum" to "Kumyk",
    "kut" to "Kutenai",
    "kv" to "Komi",
    "kw" to "Còrnais",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kuvi",
    "ky" to "Cìorgasais",
    "la" to "Laideann",
    "lad" to "Ladino",
    "lag" to "Langi",
    "lah" to "Lahnda",
    "lam" to "Lamba",
    "lb" to "Lugsamburgais",
    "lez" to "Leasgais",
    "lfn" to "Lingua Franca Nova",
    "lg" to "Ganda",
    "li" to "Cànan Limburg",
    "lij" to "Liogùrais",
    "lil" to "Lillooet",
    "lkt" to "Lakhóta",
    "lld" to "Ladainis",
    "lmo" to "Lombardais",
    "ln" to "Lingala",
    "lo" to "Làtho",
    "lol" to "Mongo",
    "lou" to "Crìtheol Louisiana",
    "loz" to "Lozi",
    "lrc" to "Luri Thuathach",
    "lsm" to "Saamia",
    "lt" to "Liotuainis",
    "ltg" to "Latgailis",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lui" to "Luiseño",
    "lun" to "Lunda",
    "luo" to "Luo",
    "lus" to "Mizo",
    "luy" to "Luyia",
    "lv" to "Laitbheis",
    "lzh" to "Sìnis an Litreachais",
    "lzz" to "Laz",
    "mad" to "Cànan Madhura",
    "maf" to "Mafa",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Makasar",
    "man" to "Mandingo",
    "mas" to "Maasai",
    "mde" to "Maba",
    "mdf" to "Moksha",
    "mdr" to "Mandar",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisyen",
    "mg" to "Malagasais",
    "mga" to "Meadhan-Ghaeilge",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Meta’",
    "mh" to "Marshallais",
    "mhn" to "Mócheno",
    "mi" to "Māori",
    "mic" to "Mi’kmaq",
    "min" to "Minangkabau",
    "mk" to "Masadonais",
    "ml" to "Malayalam",
    "mn" to "Mongolais",
    "mnc" to "Manchu",
    "mni" to "Manipuri",
    "moe" to "Innu-aimun",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Marathi",
    "mrj" to "Mari Shiarach",
    "ms" to "Malaidhis",
    "mt" to "Maltais",
    "mua" to "Mundang",
    "mul" to "Iomadh cànan",
    "mus" to "Creek",
    "mwl" to "Miorandais",
    "mwr" to "Marwari",
    "mwv" to "Mentawai",
    "my" to "Burmais",
    "mye" to "Myene",
    "myv" to "Erzya",
    "mzn" to "Mazanderani",
    "na" to "Nabhru",
    "nan" to "Min Nan",
    "nap" to "Eadailtis Napoli",
    "naq" to "Nama",
    "nb" to "Bokmål na Nirribhidh",
    "nd" to "Ndebele Thuathach",
    "nds" to "Gearmailtis Ìochdarach",
    "nds-NL" to "Sagsannais Ìochdarach",
    "ne" to "Neapàlais",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Cànan Niue",
    "njo" to "Ao Naga",
    "nl" to "Duitsis",
    "nl-BE" to "Flànrais",
    "nmg" to "Kwasio",
    "nn" to "Nynorsk na Nirribhidh",
    "nnh" to "Ngiemboon",
    "no" to "Nirribhis",
    "nog" to "Nogai",
    "non" to "Seann-Lochlannais",
    "nov" to "Novial",
    "nqo" to "N’Ko",
    "nr" to "Ndebele Dheasach",
    "nso" to "Sesotho sa Leboa",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "nwc" to "Newari Chlasaigeach",
    "ny" to "Nyanja",
    "nym" to "Nyamwezi",
    "nyn" to "Nyankole",
    "nyo" to "Nyoro",
    "nzi" to "Nzima",
    "oc" to "Ogsatanais",
    "oj" to "Ojibwa",
    "ojb" to "Ojibwa Iar-thuathach",
    "ojc" to "Ojibwa Mheadhanach",
    "ojs" to "Oji-Cree",
    "ojw" to "Ojibwa Shiarach",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Odia",
    "os" to "Ossetic",
    "osa" to "Osage",
    "ota" to "Turcais Otomanach",
    "pa" to "Panjabi",
    "pag" to "Pangasinan",
    "pal" to "Pahlavi",
    "pam" to "Pampanga",
    "pap" to "Papiamentu",
    "pau" to "Palabhais",
    "pcd" to "Picard",
    "pcm" to "Beurla Nigèiriach",
    "pdc" to "Gearmailtis Phennsylvania",
    "pdt" to "Plautdietsch",
    "peo" to "Seann-Pheirsis",
    "phn" to "Phenicis",
    "pi" to "Pali",
    "pis" to "Pijin",
    "pl" to "Pòlainnis",
    "pms" to "Piedmontese",
    "pon" to "Cànan Pohnpei",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Pruisis",
    "pro" to "Seann-Phrovençal",
    "ps" to "Pashto",
    "pt" to "Portagailis",
    "pt-BR" to "Portagailis Bhraisileach",
    "pt-PT" to "Portagailis Eòrpach",
    "qu" to "Quechua",
    "quc" to "K’iche’",
    "qug" to "Quichua Àrd-tìr Chimborazo",
    "raj" to "Rajasthani",
    "rap" to "Rapa Nui",
    "rar" to "Cànan Rarotonga",
    "rgn" to "Romagnol",
    "rhg" to "Rohingya",
    "rif" to "Tamaisich an Rif",
    "rm" to "Rumains",
    "rn" to "Kirundi",
    "ro" to "Romàinis",
    "ro-MD" to "Moldobhais",
    "rof" to "Rombo",
    "rom" to "Romanais",
    "ru" to "Ruisis",
    "rue" to "Rusyn",
    "rug" to "Roviana",
    "rup" to "Aromanais",
    "rw" to "Kinyarwanda",
    "rwk" to "Rwa",
    "sa" to "Sanskrit",
    "sad" to "Sandawe",
    "sah" to "Sakha",
    "sam" to "Aramais Shamaritanach",
    "saq" to "Samburu",
    "sas" to "Sasak",
    "sat" to "Santali",
    "saz" to "Saurashtra",
    "sba" to "Ngambay",
    "sbp" to "Sangu",
    "sc" to "Sàrdais",
    "scn" to "Sisilis",
    "sco" to "Albais",
    "sd" to "Sindhi",
    "sdc" to "Sassarese",
    "sdh" to "Cùrdais Dheasach",
    "se" to "Sàmais Thuathach",
    "see" to "Seneca",
    "seh" to "Sena",
    "sei" to "Seri",
    "sel" to "Selkup",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "sga" to "Seann-Ghaeilge",
    "sh" to "Sèirb-Chròthaisis",
    "shi" to "Tachelhit",
    "shn" to "Shan",
    "shu" to "Arabais Seàdach",
    "si" to "Sinhala",
    "sid" to "Sidamo",
    "sk" to "Slòbhacais",
    "skr" to "Saraiki",
    "sl" to "Slòbhainis",
    "slh" to "Lushootseed Dheasach",
    "sly" to "Selayar",
    "sm" to "Samothais",
    "sma" to "Sàmais Dheasach",
    "smj" to "Sàmais Lule",
    "smn" to "Sàmais Inari",
    "sms" to "Sàmais Skolt",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somàilis",
    "sq" to "Albàinis",
    "sr" to "Sèirbis",
    "srn" to "Sranan Tongo",
    "srr" to "Serer",
    "ss" to "Swati",
    "ssy" to "Saho",
    "st" to "Sesotho",
    "str" to "Salish a’ Chaolais",
    "su" to "Cànan Sunda",
    "suk" to "Sukuma",
    "sus" to "Susu",
    "sux" to "Cànan Sumer",
    "sv" to "Suainis",
    "sw" to "Kiswahili",
    "sw-CD" to "Kiswahili na Congo",
    "swb" to "Comorais",
    "syc" to "Suraidheac Chlasaigeach",
    "syr" to "Suraidheac",
    "szl" to "Sileisis",
    "ta" to "Taimilis",
    "tce" to "Tutchone Dheasach",
    "tcy" to "Tulu",
    "te" to "Telugu",
    "tem" to "Timne",
    "teo" to "Teso",
    "ter" to "Terêna",
    "tet" to "Tetum",
    "tg" to "Taidigis",
    "tgx" to "Tagish",
    "th" to "Cànan nan Tàidh",
    "tht" to "Tahltan",
    "ti" to "Tigrinya",
    "tig" to "Tigre",
    "tiv" to "Tiv",
    "tk" to "Turcmanais",
    "tkl" to "Tokelau",
    "tkr" to "Tsakhur",
    "tl" to "Tagalog",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tly" to "Talysh",
    "tmh" to "Tamashek",
    "tn" to "Tswana",
    "to" to "Tonga",
    "tog" to "Nyasa Tonga",
    "tok" to "Toki Pona",
    "tpi" to "Tok Pisin",
    "tr" to "Turcais",
    "tru" to "Turoyo",
    "trv" to "Taroko",
    "trw" to "Torwali",
    "ts" to "Tsonga",
    "tsi" to "Tsimshian",
    "tt" to "Tatarais",
    "ttm" to "Tutchone Thuathach",
    "ttt" to "Tati",
    "tum" to "Tumbuka",
    "tvl" to "Tubhalu",
    "tw" to "Twi",
    "twq" to "Tasawaq",
    "ty" to "Cànan Tahiti",
    "tyv" to "Cànan Tuva",
    "tzm" to "Tamaisich an Atlais Mheadhanaich",
    "udm" to "Udmurt",
    "ug" to "Ùigiurais",
    "uk" to "Ucràinis",
    "umb" to "Umbundu",
    "und" to "Cànan neo-aithnichte",
    "ur" to "Ùrdu",
    "uz" to "Usbagais",
    "vai" to "Vai",
    "ve" to "Venda",
    "vec" to "Bheinisis",
    "vep" to "Veps",
    "vi" to "Bhiet-Namais",
    "vls" to "Flànrais Shiarach",
    "vmw" to "Makhuwa",
    "vo" to "Volapük",
    "vro" to "Võro",
    "vun" to "Vunjo",
    "wa" to "Walloon",
    "wae" to "Gearmailtis Wallis",
    "wal" to "Wolaytta",
    "war" to "Waray",
    "was" to "Washo",
    "wbp" to "Warlpiri",
    "wo" to "Wolof",
    "wuu" to "Wu",
    "xal" to "Kalmyk",
    "xh" to "Xhosa",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yao" to "Yao",
    "yap" to "Cànan Yap",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Iùdhais",
    "yo" to "Yoruba",
    "yrl" to "Nheengatu",
    "yue" to "Cantonais",
    "yue-alt-menu" to "Sìnis, Cantonais",
    "za" to "Zhuang",
    "zap" to "Zapotec",
    "zbl" to "Comharran Bliss",
    "zea" to "Cànan Zeeland",
    "zen" to "Zenaga",
    "zgh" to "Tamaisich Stannardach Moroco",
    "zh" to "Sìnis",
    "zh-alt-menu" to "Sìnis, Mandairinis",
    "zh-Hans" to "Sìnis Shimplichte",
    "zh-Hans-alt-long" to "Mandairinis Shimplichte",
    "zh-Hant" to "Sìnis Thradaiseanta",
    "zh-Hant-alt-long" to "Mandairinis Thradaiseanta",
    "zu" to "Zulu",
    "zun" to "Zuñi",
    "zxx" to "Susbaint nach eil ’na chànan",
    "zza" to "Zazaki",
  ) }

  val gl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abkhazo",
    "ace" to "achinés",
    "ach" to "acholí",
    "ada" to "adangme",
    "ady" to "adigueo",
    "af" to "afrikaans",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "akan",
    "ale" to "aleutiano",
    "alt" to "altai meridional",
    "am" to "amhárico",
    "an" to "aragonés",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "árabe",
    "ar-001" to "árabe estándar moderno",
    "arc" to "arameo",
    "arn" to "mapuche",
    "arp" to "arapaho",
    "ars" to "árabe najdi",
    "as" to "assamés",
    "asa" to "asu",
    "ast" to "asturiano",
    "atj" to "atikamekw",
    "av" to "avar",
    "awa" to "awadhi",
    "ay" to "aimará",
    "az" to "acerbaixano",
    "az-alt-short" to "azerí",
    "ba" to "baxkir",
    "ban" to "balinés",
    "bas" to "basaa",
    "be" to "belaruso",
    "bem" to "bemba",
    "bez" to "bena",
    "bg" to "búlgaro",
    "bgc" to "hariani",
    "bgn" to "baluchi occidental",
    "bho" to "bhojpuri",
    "bi" to "bislama",
    "bin" to "bini",
    "bla" to "siksiká",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bengalí",
    "bo" to "tibetano",
    "br" to "bretón",
    "brx" to "bodo",
    "bs" to "bosníaco",
    "bug" to "buginés",
    "byn" to "blin",
    "ca" to "catalán",
    "cay" to "cayuga",
    "ccp" to "chakma",
    "ce" to "checheno",
    "ceb" to "cebuano",
    "cgg" to "kiga",
    "ch" to "chamorro",
    "chk" to "chuuk",
    "chm" to "mari",
    "cho" to "choctaw",
    "chp" to "chipewyan",
    "chr" to "cherokee",
    "chy" to "cheyenne",
    "ckb" to "kurdo central",
    "ckb-alt-menu" to "kurdo central",
    "ckb-alt-variant" to "sorani",
    "clc" to "chilcotin",
    "co" to "corso",
    "crg" to "michif",
    "crj" to "cree do sueste",
    "crk" to "cree das chairas",
    "crl" to "cree do nordeste",
    "crm" to "cree de Moose",
    "crr" to "algonquino de Carolina",
    "crs" to "seselwa (crioulo das Seychelles)",
    "cs" to "checo",
    "csw" to "cree dos pantanos",
    "cu" to "eslavo eclesiástico",
    "cv" to "chuvaxo",
    "cy" to "galés",
    "da" to "dinamarqués",
    "dak" to "dakota",
    "dar" to "dargwa",
    "dav" to "taita",
    "de" to "alemán",
    "de-AT" to "alemán austríaco",
    "de-CH" to "alto alemán suízo",
    "dgr" to "dogrib",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "baixo sorbio",
    "dua" to "duala",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dz" to "dzongkha",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efik",
    "egy" to "exipcio antigo",
    "eka" to "ekajuk",
    "el" to "grego",
    "en" to "inglés",
    "en-AU" to "inglés australiano",
    "en-CA" to "inglés canadense",
    "en-GB" to "inglés británico",
    "en-GB-alt-short" to "inglés (RU)",
    "en-US" to "inglés estadounidense",
    "en-US-alt-short" to "inglés (EUA)",
    "eo" to "esperanto",
    "es" to "español",
    "es-419" to "español de América",
    "es-ES" to "español de España",
    "es-MX" to "español de México",
    "et" to "estoniano",
    "eu" to "éuscaro",
    "ewo" to "ewondo",
    "fa" to "persa",
    "fa-AF" to "dari",
    "ff" to "fula",
    "fi" to "finés",
    "fil" to "filipino",
    "fj" to "fixiano",
    "fo" to "feroés",
    "fon" to "fon",
    "fr" to "francés",
    "fr-CA" to "francés canadense",
    "fr-CH" to "francés suízo",
    "frc" to "francés cajun",
    "frr" to "frisón setentrional",
    "fur" to "friulano",
    "fy" to "frisón occidental",
    "ga" to "irlandés",
    "gaa" to "ga",
    "gag" to "gagauz",
    "gd" to "gaélico escocés",
    "gez" to "ge’ez",
    "gil" to "kiribatiano",
    "gl" to "galego",
    "gn" to "guaraní",
    "gor" to "gorontalo",
    "grc" to "grego antigo",
    "gsw" to "alemán suízo",
    "gu" to "guxarati",
    "guz" to "gusii",
    "gv" to "manx",
    "gwi" to "gwichʼin",
    "ha" to "hausa",
    "hai" to "haida",
    "haw" to "hawaiano",
    "hax" to "haida do sur",
    "he" to "hebreo",
    "hi" to "hindi",
    "hi-Latn" to "hindi (alfabeto latino)",
    "hi-Latn-alt-variant" to "hinglish (alfabeto latino)",
    "hil" to "hiligaynon",
    "hmn" to "hmong",
    "hr" to "croata",
    "hsb" to "alto sorbio",
    "ht" to "crioulo haitiano",
    "hu" to "húngaro",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armenio",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonesio",
    "ie" to "occidental",
    "ig" to "igbo",
    "ii" to "yi sichuanés",
    "ikt" to "inuktitut canadense occidental",
    "ilo" to "ilocano",
    "inh" to "inguxo",
    "io" to "ido",
    "is" to "islandés",
    "it" to "italiano",
    "iu" to "inuktitut",
    "ja" to "xaponés",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jv" to "xavanés",
    "ka" to "xeorxiano",
    "kab" to "cabila",
    "kac" to "kachin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kbd" to "cabardiano",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "caboverdiano",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "caingangue",
    "kha" to "khasi",
    "khq" to "koyra chiini",
    "ki" to "kikuyu",
    "kj" to "kuanyama",
    "kk" to "kazako",
    "kkj" to "kako",
    "kl" to "kalaallisut",
    "kln" to "kalenjin",
    "km" to "khmer",
    "kmb" to "kimbundu",
    "kn" to "kannará",
    "ko" to "coreano",
    "koi" to "komi permio",
    "kok" to "konkani",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "carachaio-bálcara",
    "krl" to "carelio",
    "kru" to "kurukh",
    "ks" to "caxemirés",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "kölsch",
    "ku" to "kurdo",
    "kum" to "kumyk",
    "kv" to "komi",
    "kw" to "córnico",
    "kwk" to "kwakiutl",
    "kxv" to "kuvi",
    "ky" to "kirguiz",
    "la" to "latín",
    "lad" to "ladino",
    "lag" to "langi",
    "lb" to "luxemburgués",
    "lez" to "lezguio",
    "lg" to "ganda",
    "li" to "limburgués",
    "lij" to "lígur",
    "lil" to "lillooet",
    "lkt" to "lakota",
    "lmo" to "lombardo",
    "ln" to "lingala",
    "lo" to "laosiano",
    "lou" to "crioulo de Luisiana",
    "loz" to "lozi",
    "lrc" to "luri setentrional",
    "lsm" to "saamia",
    "lt" to "lituano",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lun" to "lunda",
    "lus" to "mizo",
    "luy" to "luyia",
    "lv" to "letón",
    "mad" to "madurés",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makasar",
    "mas" to "masai",
    "mdf" to "moksha",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "crioulo mauriciano",
    "mg" to "malgaxe",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta’",
    "mh" to "marshalés",
    "mi" to "maorí",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "macedonio",
    "ml" to "malabar",
    "mn" to "mongol",
    "mni" to "manipuri",
    "moe" to "innu-aimun",
    "moh" to "mohawk",
    "mos" to "mossi",
    "mr" to "marathi",
    "ms" to "malaio",
    "mt" to "maltés",
    "mua" to "mundang",
    "mul" to "varias linguas",
    "mus" to "creek",
    "mwl" to "mirandés",
    "my" to "birmano",
    "myv" to "erzya",
    "mzn" to "mazandaraní",
    "na" to "nauruano",
    "nap" to "napolitano",
    "naq" to "nama",
    "nb" to "noruegués bokmål",
    "nd" to "ndebele setentrional",
    "nds" to "baixo alemán",
    "nds-NL" to "baixo saxón",
    "ne" to "nepalí",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niueano",
    "nl" to "neerlandés",
    "nl-BE" to "flamengo",
    "nmg" to "kwasio",
    "nn" to "noruegués nynorsk",
    "nnh" to "ngiemboon",
    "no" to "noruegués",
    "nog" to "nogai",
    "nqo" to "n’ko",
    "nr" to "ndebele meridional",
    "nso" to "sesotho do norte",
    "nus" to "nuer",
    "nv" to "navajo",
    "ny" to "chewa",
    "nyn" to "nyankole",
    "oc" to "occitano",
    "ojb" to "ojibwa do noroeste",
    "ojc" to "ojibwa",
    "ojs" to "oji-cree",
    "ojw" to "ojibwa do oeste",
    "oka" to "okanagan",
    "om" to "oromo",
    "or" to "odiá",
    "os" to "ossetio",
    "pa" to "panxabí",
    "pag" to "pangasinan",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palauano",
    "pcm" to "pidgin nixeriano",
    "pis" to "pijin",
    "pl" to "polaco",
    "pqm" to "malecite-passamaquoddy",
    "prg" to "prusiano",
    "ps" to "paxto",
    "pt" to "portugués",
    "pt-BR" to "portugués do Brasil",
    "pt-PT" to "portugués de Portugal",
    "qu" to "quechua",
    "quc" to "quiché",
    "raj" to "rajasthani",
    "rap" to "rapanui",
    "rar" to "rarotongano",
    "rhg" to "rohingya",
    "rm" to "romanche",
    "rn" to "rundi",
    "ro" to "romanés",
    "ro-MD" to "moldavo",
    "rof" to "rombo",
    "ru" to "ruso",
    "rup" to "aromanés",
    "rw" to "kiñaruanda",
    "rwk" to "rwa",
    "sa" to "sánscrito",
    "sad" to "sandawe",
    "sah" to "iacuto",
    "saq" to "samburu",
    "sat" to "santali",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sardo",
    "scn" to "siciliano",
    "sco" to "escocés",
    "sd" to "sindhi",
    "sdh" to "kurdo meridional",
    "se" to "saami setentrional",
    "seh" to "sena",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sh" to "serbocroata",
    "shi" to "tachelhit",
    "shn" to "shan",
    "si" to "cingalés",
    "sk" to "eslovaco",
    "sl" to "esloveno",
    "slh" to "lushootseed do sur",
    "sm" to "samoano",
    "sma" to "saami meridional",
    "smj" to "saami de Lule",
    "smn" to "saami de Inari",
    "sms" to "saami skolt",
    "sn" to "shona",
    "snk" to "soninke",
    "so" to "somalí",
    "sq" to "albanés",
    "sr" to "serbio",
    "srn" to "sranan tongo",
    "ss" to "suazi",
    "ssy" to "saho",
    "st" to "sesotho",
    "str" to "salish dos estreitos",
    "su" to "sundanés",
    "suk" to "sukuma",
    "sv" to "sueco",
    "sw" to "suahili",
    "sw-CD" to "suahili congolés",
    "swb" to "comoriano",
    "syr" to "siríaco",
    "szl" to "silesiano",
    "ta" to "támil",
    "tce" to "tutchone do sur",
    "te" to "telugu",
    "tem" to "temne",
    "teo" to "teso",
    "tet" to "tetun",
    "tg" to "taxico",
    "tgx" to "tagish",
    "th" to "tailandés",
    "tht" to "tahltan",
    "ti" to "tigriña",
    "tig" to "tigré",
    "tk" to "turkmeno",
    "tl" to "tagalo",
    "tlh" to "klingon",
    "tli" to "tlingit",
    "tn" to "tswana",
    "to" to "tongano",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turco",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tt" to "tártaro",
    "ttm" to "tutchone do norte",
    "tum" to "tumbuka",
    "tvl" to "tuvalés",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitiano",
    "tyv" to "tuvaniano",
    "tzm" to "tamazight de Marrocos central",
    "udm" to "udmurto",
    "ug" to "uigur",
    "uk" to "ucraíno",
    "umb" to "umbundu",
    "und" to "lingua descoñecida",
    "ur" to "urdú",
    "uz" to "uzbeko",
    "ve" to "venda",
    "vec" to "véneto",
    "vi" to "vietnamita",
    "vmw" to "makua",
    "vo" to "volapuk",
    "vun" to "vunjo",
    "wa" to "valón",
    "wae" to "walser",
    "wal" to "wolaytta",
    "war" to "waray-waray",
    "wbp" to "walrpiri",
    "wo" to "wólof",
    "wuu" to "chinés wu",
    "xal" to "calmuco",
    "xh" to "xhosa",
    "xnr" to "kangri",
    "xog" to "soga",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "yiddish",
    "yo" to "ioruba",
    "yrl" to "nheengatu",
    "yue" to "cantonés",
    "yue-alt-menu" to "chinés cantonés",
    "za" to "zhuang",
    "zgh" to "tamazight marroquí estándar",
    "zh" to "chinés",
    "zh-alt-menu" to "chinés mandarín",
    "zh-Hans" to "chinés simplificado",
    "zh-Hans-alt-long" to "chinés mandarín simplificado",
    "zh-Hant" to "chinés tradicional",
    "zh-Hant-alt-long" to "chinés mandarín tradicional",
    "zu" to "zulú",
    "zun" to "zuni",
    "zxx" to "sen contido lingüístico",
    "zza" to "zazaki",
  ) }

  val gn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "gn" to "avañe’ẽ",
  ) }

  val gsw: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afar",
    "ab" to "Abchasisch",
    "ace" to "Aceh",
    "ach" to "Acholi",
    "ada" to "Adangme",
    "ady" to "Adygai",
    "ae" to "Avestisch",
    "af" to "Afrikaans",
    "afh" to "Afrihili",
    "ain" to "Ainu",
    "ak" to "Akan",
    "akk" to "Akkadisch",
    "ale" to "Aleutisch",
    "alt" to "Süüd-Altaisch",
    "am" to "Amharisch",
    "an" to "Aragonesisch",
    "ang" to "Altänglisch",
    "anp" to "Angika",
    "ar" to "Arabisch",
    "arc" to "Aramääisch",
    "arn" to "Araukanisch",
    "arp" to "Arapaho",
    "arw" to "Arawak",
    "as" to "Assamesisch",
    "ast" to "Aschturianisch",
    "av" to "Awarisch",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Aserbaidschanisch",
    "az-alt-short" to "Aserbaidschanisch",
    "ba" to "Baschkirisch",
    "bal" to "Belutschisch",
    "ban" to "Balinesisch",
    "bas" to "Basaa",
    "be" to "Wiissrussisch",
    "bej" to "Bedauye",
    "bem" to "Bemba",
    "bg" to "Bulgaarisch",
    "bho" to "Bhodschpuri",
    "bi" to "Bislama",
    "bik" to "Bikolisch",
    "bin" to "Bini",
    "bla" to "Blackfoot-Schpraach",
    "bm" to "Bambara",
    "bn" to "Bengalisch",
    "bo" to "Tibeetisch",
    "br" to "Brötoonisch",
    "bra" to "Braj-Bhakha",
    "bs" to "Bosnisch",
    "bua" to "Burjatisch",
    "bug" to "Bugineesisch",
    "byn" to "Blin",
    "ca" to "Katalaanisch",
    "cad" to "Caddo",
    "car" to "Kariibisch",
    "cch" to "Atsam",
    "ce" to "Tschetscheenisch",
    "ceb" to "Cebuano",
    "ch" to "Chamorro",
    "chb" to "Tschibtscha",
    "chg" to "Tschagataisch",
    "chk" to "Trukesisch",
    "chm" to "Tscheremissisch",
    "chn" to "Chinook",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyenne",
    "co" to "Korsisch",
    "cop" to "Koptisch",
    "cr" to "Cree",
    "crh" to "Krimtatarisch",
    "cs" to "Tschechisch",
    "csb" to "Kaschubisch",
    "cu" to "Chileslawisch",
    "cv" to "Tschuwaschisch",
    "cy" to "Walisisch",
    "da" to "Tänisch",
    "dak" to "Takota",
    "dar" to "Targiinisch",
    "de" to "Tüütsch",
    "de-AT" to "Öschtriichischs Tüütsch",
    "de-CH" to "Schwiizer Hochtüütsch",
    "del" to "Delaware-Schpraach",
    "den" to "Slavey",
    "dgr" to "Togrib",
    "din" to "Tinka",
    "doi" to "Togri",
    "dsb" to "Nidersorbisch",
    "dua" to "Tuala",
    "dum" to "Mittelniderländisch",
    "dv" to "Malediivisch",
    "dyu" to "Tiula",
    "dz" to "Dschongkha",
    "ee" to "Ewe",
    "efi" to "Efikisch",
    "egy" to "Altägyptisch",
    "eka" to "Ekajuk",
    "el" to "Griechisch",
    "elx" to "Elamisch",
    "en" to "Änglisch",
    "en-AU" to "Auschtralischs Änglisch",
    "en-CA" to "Kanadischs Änglisch",
    "en-GB" to "Britischs Änglisch",
    "en-GB-alt-short" to "Britischs Änglisch",
    "en-US" to "Amerikanischs Änglisch",
    "en-US-alt-short" to "Amerikanischs Änglisch",
    "enm" to "Mittelänglisch",
    "eo" to "Eschperanto",
    "es" to "Schpanisch",
    "es-419" to "Latiinamerikanischs Schpanisch",
    "es-ES" to "Ibeerischs Schpanisch",
    "et" to "Eestnisch",
    "eu" to "Baskisch",
    "ewo" to "Ewondo",
    "fa" to "Persisch",
    "fan" to "Pangwe-Schpraach",
    "fat" to "Fanti-Schpraach",
    "ff" to "Ful",
    "fi" to "Finnisch",
    "fil" to "Filipino",
    "fj" to "Fidschianisch",
    "fo" to "Färöisch",
    "fon" to "Fon",
    "fr" to "Französisch",
    "fr-CA" to "Kanadischs Französisch",
    "fr-CH" to "Schwiizer Französisch",
    "frm" to "Mittelfranzösisch",
    "fro" to "Altfranzösisch",
    "frr" to "Nordfriesisch",
    "frs" to "Oschtfriesisch",
    "fur" to "Friulisch",
    "fy" to "Friesisch",
    "ga" to "Iirisch",
    "gaa" to "Ga",
    "gay" to "Gayo",
    "gba" to "Gbaya",
    "gd" to "Schottisch-Gäälisch",
    "gez" to "Geez",
    "gil" to "Gilbertesisch",
    "gl" to "Galizisch",
    "gmh" to "Mittelhochtüütsch",
    "gn" to "Guarani",
    "goh" to "Althochtüütsch",
    "gon" to "Gondi",
    "gor" to "Mongondou",
    "got" to "Gotisch",
    "grb" to "Grebo",
    "grc" to "Altgriechisch",
    "gsw" to "Schwiizertüütsch",
    "gu" to "Gujarati",
    "gv" to "Manx-Gäälisch",
    "gwi" to "Kutchinisch",
    "ha" to "Haussa",
    "hai" to "Haida",
    "haw" to "Hawaiianisch",
    "he" to "Hebräisch",
    "hi" to "Hindi",
    "hil" to "Hiligaynonisch",
    "hit" to "Hethitisch",
    "hmn" to "Miao",
    "ho" to "Hiri-Motu",
    "hr" to "Kroazisch",
    "hsb" to "Obersorbisch",
    "ht" to "Haitisch",
    "hu" to "Ungarisch",
    "hup" to "Hupa",
    "hy" to "Armenisch",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Ibanisch",
    "id" to "Indonesisch",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Sezuanischs Yi",
    "ik" to "Inupiak",
    "ilo" to "Ilokano",
    "inh" to "Inguschisch",
    "io" to "Ido",
    "is" to "Iisländisch",
    "it" to "Italiänisch",
    "iu" to "Inukitut",
    "ja" to "Japanisch",
    "jbo" to "Lojbanisch",
    "jpr" to "Jüüdisch-Persisch",
    "jrb" to "Jüüdisch-Arabisch",
    "jv" to "Javanisch",
    "ka" to "Georgisch",
    "kaa" to "Karakalpakisch",
    "kab" to "Kabylisch",
    "kac" to "Kachin-Schpraach",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kaw" to "Kawi",
    "kbd" to "Kabardinisch",
    "kcg" to "Tyap",
    "kfo" to "Koro",
    "kg" to "Kongolesisch",
    "kha" to "Khasisch",
    "kho" to "Sakisch",
    "ki" to "Kikuyu-Schpraach",
    "kj" to "Kwanyama",
    "kk" to "Kasachisch",
    "kl" to "Gröönländisch",
    "km" to "Kambodschanisch",
    "kmb" to "Kimbundu-Schpraach",
    "kn" to "Kannada",
    "ko" to "Koreaanisch",
    "kok" to "Konkani",
    "kos" to "Kosraeanisch",
    "kpe" to "Kpelle-Schpraach",
    "kr" to "Kanuri-Schpraach",
    "krc" to "Karatschaiisch-Balkarisch",
    "krl" to "Karelisch",
    "kru" to "Oraon-Schpraach",
    "ks" to "Kaschmirisch",
    "ku" to "Kurdisch",
    "kum" to "Kumükisch",
    "kut" to "Kutenai-Schpraach",
    "kv" to "Komi-Schpraach",
    "kw" to "Kornisch",
    "ky" to "Kirgiisisch",
    "la" to "Latiin",
    "lad" to "Ladino",
    "lah" to "Lahndanisch",
    "lam" to "Lambanisch",
    "lb" to "Luxemburgisch",
    "lez" to "Lesgisch",
    "lg" to "Ganda-Schpraach",
    "li" to "Limburgisch",
    "ln" to "Lingala",
    "lo" to "Laozisch",
    "lol" to "Mongo",
    "loz" to "Rotse-Schpraach",
    "lt" to "Litauisch",
    "lu" to "Luba",
    "lua" to "Luba-Lulua",
    "lui" to "Luiseno-Schpraach",
    "lun" to "Lunda-Schpraach",
    "luo" to "Luo-Schpraach",
    "lus" to "Lushai-Schpraach",
    "lv" to "Lettisch",
    "mad" to "Maduresisch",
    "mag" to "Khotta",
    "mai" to "Maithili",
    "mak" to "Makassarisch",
    "man" to "Manding-Schpraach",
    "mas" to "Massai-Schpraach",
    "mdf" to "Mokschamordwinisch",
    "mdr" to "Mandaresisch",
    "men" to "Mende-Schpraach",
    "mg" to "Madagassisch",
    "mga" to "Mittelirisch",
    "mh" to "Marschallesisch",
    "mi" to "Maori",
    "mic" to "Micmac-Schpraach",
    "min" to "Minangkabau-Schpraach",
    "mk" to "Mazedonisch",
    "ml" to "Malayalam",
    "mn" to "Mongolisch",
    "mnc" to "Mandschurisch",
    "mni" to "Meithei-Schpraach",
    "moh" to "Mohawk-Schpraach",
    "mos" to "Mossi-Schpraach",
    "mr" to "Marathi",
    "ms" to "Malaiisch",
    "mt" to "Maltesisch",
    "mul" to "Mehrschpraachig",
    "mus" to "Muskogee-Schpraach",
    "mwl" to "Mirandesisch",
    "mwr" to "Marwarisch",
    "my" to "Birmanisch",
    "myv" to "Erzya",
    "na" to "Nauruisch",
    "nap" to "Neapolitanisch",
    "nb" to "Norwegisch Bokmål",
    "nd" to "Nord-Ndebele-Schpraach",
    "nds" to "Nidertüütsch",
    "ne" to "Nepalesisch",
    "new" to "Newarisch",
    "ng" to "Ndonga",
    "nia" to "Nias-Schpraach",
    "niu" to "Niue-Schpraach",
    "nl" to "Niderländisch",
    "nl-BE" to "Fläämisch",
    "nn" to "Norwegisch Nynorsk",
    "no" to "Norwegisch",
    "nog" to "Nogaisch",
    "non" to "Altnordisch",
    "nqo" to "N’Ko",
    "nr" to "Süüd-Ndebele-Schpraach",
    "nso" to "Nord-Sotho-Schpraach",
    "nv" to "Navajo-Schpraach",
    "nwc" to "Alt-Newari",
    "ny" to "Chewa-Schpraach",
    "nym" to "Nyamwezi-Schpraach",
    "nyn" to "Nyankole",
    "nyo" to "Nyoro",
    "nzi" to "Nzima",
    "oc" to "Okzitanisch",
    "oj" to "Ojibwa-Schpraach",
    "om" to "Oromo",
    "or" to "Orija",
    "os" to "Ossezisch",
    "osa" to "Osage-Schpraach",
    "ota" to "Osmanisch",
    "pa" to "Pandschabisch",
    "pag" to "Pangasinanisch",
    "pal" to "Mittelpersisch",
    "pam" to "Pampanggan-Schpraach",
    "pap" to "Papiamento",
    "pau" to "Palau",
    "peo" to "Altpersisch",
    "phn" to "Phönikisch",
    "pi" to "Pali",
    "pl" to "Polnisch",
    "pon" to "Ponapeanisch",
    "pro" to "Altprovenzalisch",
    "ps" to "Paschtu",
    "pt" to "Portugiisisch",
    "pt-BR" to "Brasilianischs Portugiisisch",
    "pt-PT" to "Iberischs Portugiisisch",
    "qu" to "Quechua",
    "raj" to "Rajasthani",
    "rap" to "Oschterinsel-Schpraach",
    "rar" to "Rarotonganisch",
    "rm" to "Rätoromanisch",
    "rn" to "Rundi-Schpraach",
    "ro" to "Rumänisch",
    "ro-MD" to "Moldawisch",
    "rom" to "Zigüünerschpraach",
    "ru" to "Russisch",
    "rup" to "Aromunisch",
    "rw" to "Ruandisch",
    "sa" to "Sanschkrit",
    "sad" to "Sandawe-Schpraach",
    "sah" to "Jakutisch",
    "sam" to "Samaritanisch",
    "sas" to "Sasak",
    "sat" to "Santali",
    "sc" to "Sardisch",
    "scn" to "Sizilianisch",
    "sco" to "Schottisch",
    "sd" to "Sindhi",
    "se" to "Nord-Samisch",
    "sel" to "Selkupisch",
    "sg" to "Sango",
    "sga" to "Altirisch",
    "sh" to "Serbo-Kroatisch",
    "shn" to "Schan-Schpraach",
    "si" to "Singhalesisch",
    "sid" to "Sidamo",
    "sk" to "Slowakisch",
    "sl" to "Slowenisch",
    "sm" to "Samoanisch",
    "sma" to "Süüd-Samisch",
    "smj" to "Lule-Samisch",
    "smn" to "Inari-Samisch",
    "sms" to "Skolt-Samisch",
    "sn" to "Schhona",
    "snk" to "Soninke-Schpraach",
    "so" to "Somali",
    "sog" to "Sogdisch",
    "sq" to "Albanisch",
    "sr" to "Serbisch",
    "srn" to "Srananisch",
    "srr" to "Serer-Schpraach",
    "ss" to "Swazi",
    "st" to "Süüd-Sotho-Schpraach",
    "su" to "Sundanesisch",
    "suk" to "Sukuma-Schpraach",
    "sus" to "Susu",
    "sux" to "Sumerisch",
    "sv" to "Schwedisch",
    "sw" to "Suaheli",
    "syc" to "Altsyrisch",
    "syr" to "Syrisch",
    "ta" to "Tamilisch",
    "te" to "Telugu",
    "tem" to "Temne",
    "ter" to "Tereno-Schpraach",
    "tet" to "Tetum-Schpraach",
    "tg" to "Tadschikisch",
    "th" to "Thailändisch",
    "ti" to "Tigrinja",
    "tig" to "Tigre",
    "tiv" to "Tiv-Schpraach",
    "tk" to "Turkmenisch",
    "tkl" to "Tokelauanisch",
    "tl" to "Tagalog",
    "tlh" to "Klingonisch",
    "tli" to "Tlingit-Schpraach",
    "tmh" to "Tamaseq",
    "tn" to "Tswana-Schpraach",
    "to" to "Tongaisch",
    "tog" to "Tsonga-Schpraach",
    "tpi" to "Neumelanesisch",
    "tr" to "Türkisch",
    "ts" to "Tsonga",
    "tsi" to "Tsimshian-Schpraach",
    "tt" to "Tatarisch",
    "tum" to "Tumbuka-Schpraach",
    "tvl" to "Elliceanisch",
    "tw" to "Twi",
    "ty" to "Tahitisch",
    "tyv" to "Tuwinisch",
    "udm" to "Udmurtisch",
    "ug" to "Uigurisch",
    "uga" to "Ugaritisch",
    "uk" to "Ukrainisch",
    "umb" to "Mbundu-Schpraach",
    "und" to "Unbeschtimmti Schpraach",
    "ur" to "Urdu",
    "uz" to "Usbekisch",
    "vai" to "Vai-Schpraach",
    "ve" to "Venda-Schpraach",
    "vi" to "Vietnamesisch",
    "vo" to "Volapük",
    "vot" to "Wotisch",
    "wa" to "Wallonisch",
    "wal" to "Walamo-Schpraach",
    "war" to "Waray",
    "was" to "Washo-Schpraach",
    "wo" to "Wolof",
    "xal" to "Kalmückisch",
    "xh" to "Xhosa",
    "yao" to "Yao-Schpraach",
    "yap" to "Yapesisch",
    "yi" to "Jiddisch",
    "yo" to "Yoruba",
    "za" to "Zhuang",
    "zap" to "Zapotekisch",
    "zbl" to "Bliss-Symbool",
    "zen" to "Zenaga",
    "zh" to "Chineesisch",
    "zh-alt-menu" to "Chineesisch",
    "zh-Hans" to "Veräifachts Chineesisch",
    "zh-Hans-alt-long" to "Veräifachts Chineesisch",
    "zh-Hant" to "Tradizionells Chineesisch",
    "zh-Hant-alt-long" to "Tradizionells Chineesisch",
    "zu" to "Zulu",
    "zun" to "Zuni-Schpraach",
    "zxx" to "Kän schpraachliche Inhalt",
    "zza" to "Zaza",
  ) }

  val gsw_FR: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gsw_LI: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val gu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "અફાર",
    "ab" to "અબખાજિયન",
    "ace" to "અચીની",
    "ach" to "એકોલી",
    "ada" to "અદાંગ્મી",
    "ady" to "અદિઘે",
    "ae" to "અવેસ્તન",
    "af" to "આફ્રિકન્સ",
    "afh" to "અફ્રિહિલી",
    "agq" to "અઘેમ",
    "ain" to "ઐનુ",
    "ak" to "અકાન",
    "akk" to "અક્કાદીયાન",
    "ale" to "અલેઉત",
    "alt" to "દક્ષિણ અલ્તાઇ",
    "am" to "એમ્હારિક",
    "an" to "અર્ગોનીઝ",
    "ang" to "જુની અંગ્રેજી",
    "ann" to "ઓબોલો",
    "anp" to "અંગીકા",
    "ar" to "અરબી",
    "ar-001" to "મોડર્ન સ્ટાન્ડર્ડ અરબી",
    "arc" to "એરમૈક",
    "arn" to "મેપુચે",
    "arp" to "અરાપાહો",
    "arq" to "આલ્જેરિયન અરબી",
    "ars" to "નજદી અરેબિક",
    "arw" to "અરાવક",
    "ary" to "મોરોક્કન અરબી",
    "arz" to "ઈજિપ્શિયન અરબી",
    "as" to "આસામી",
    "asa" to "અસુ",
    "ast" to "અસ્તુરિયન",
    "atj" to "એટીકામેકવ",
    "av" to "અવેરિક",
    "awa" to "અવધી",
    "ay" to "આયમારા",
    "az" to "અઝરબૈજાની",
    "az-alt-short" to "અઝેરી",
    "ba" to "બશ્કીર",
    "bal" to "બલૂચી",
    "ban" to "બાલિનીસ",
    "bas" to "બસા",
    "bax" to "બામન",
    "be" to "બેલારુશિયન",
    "bej" to "બેજા",
    "bem" to "બેમ્બા",
    "bez" to "બેના",
    "bg" to "બલ્ગેરિયન",
    "bgc" to "હરિયાણવી",
    "bgn" to "પશ્ચિમી બાલોચી",
    "bho" to "ભોજપુરી",
    "bi" to "બિસ્લામા",
    "bik" to "બિકોલ",
    "bin" to "બિની",
    "bla" to "સિક્સિકા",
    "blo" to "અની",
    "bm" to "બામ્બારા",
    "bn" to "બાંગ્લા",
    "bo" to "તિબેટીયન",
    "bpy" to "બિષ્નુપ્રિયા",
    "br" to "બ્રેટોન",
    "bra" to "વ્રજ",
    "brh" to "બ્રાહુઈ",
    "brx" to "બોડો",
    "bs" to "બોસ્નિયન",
    "bua" to "બુરિયાત",
    "bug" to "બુગિનીસ",
    "byn" to "બ્લિન",
    "ca" to "કતલાન",
    "cad" to "કડ્ડો",
    "car" to "કરિબ",
    "cay" to "કેયુગા",
    "cch" to "અત્સમ",
    "ccp" to "ચકમા",
    "ce" to "ચેચન",
    "ceb" to "સિબુઆનો",
    "cgg" to "ચિગા",
    "ch" to "કેમોરો",
    "chb" to "ચિબ્ચા",
    "chg" to "છગાતાઇ",
    "chk" to "ચૂકીસ",
    "chm" to "મારી",
    "chn" to "ચિનૂક જાર્ગન",
    "cho" to "ચોક્તૌ",
    "chp" to "શિપેવ્યાન",
    "chr" to "શેરોકી",
    "chy" to "શેયેન્ન",
    "ckb" to "સેન્ટ્રલ કુર્દિશ",
    "ckb-alt-menu" to "કુર્દિશ, સેન્ટ્રલ",
    "ckb-alt-variant" to "કુર્દિશ, સોરાની",
    "clc" to "ચિલકોટિન",
    "co" to "કોર્સિકન",
    "cop" to "કોપ્ટિક",
    "cr" to "ક્રી",
    "crg" to "મિચિફ",
    "crh" to "ક્રિમિયન તુર્કી",
    "crj" to "દક્ષિણ પૂર્વ ક્રી",
    "crk" to "પ્લેઇન્સ ક્રી",
    "crl" to "ઉત્તરી પૂર્વ ક્રી",
    "crm" to "મૂઝ ક્રી",
    "crr" to "કેરોલિના એલ્ગોનક્વિઅન",
    "crs" to "સેસેલ્વા ક્રેઓલે ફ્રેન્ચ",
    "cs" to "ચેક",
    "csb" to "કાશુબિયન",
    "csw" to "સ્વેમ્પી ક્રી",
    "cu" to "ચર્ચ સ્લાવિક",
    "cv" to "ચૂવાશ",
    "cy" to "વેલ્શ",
    "da" to "ડેનિશ",
    "dak" to "દાકોતા",
    "dar" to "દાર્ગવા",
    "dav" to "તૈતા",
    "de" to "જર્મન",
    "de-AT" to "ઓસ્ટ્રિઅન જર્મન",
    "de-CH" to "સ્વિસ હાય જર્મન",
    "del" to "દેલવેર",
    "den" to "સ્લેવ",
    "dgr" to "ડોગ્રિબ",
    "din" to "દિન્કા",
    "dje" to "ઝર્મા",
    "doi" to "ડોગ્રી",
    "dsb" to "લોઅર સોર્બિયન",
    "dua" to "દુઆલા",
    "dum" to "મધ્ય ડચ",
    "dv" to "દિવેહી",
    "dyo" to "જોલા-ફોન્યી",
    "dyu" to "ડ્યુલા",
    "dz" to "ડ્ઝોંગ્ખા",
    "dzg" to "દાઝાગા",
    "ebu" to "ઍમ્બુ",
    "ee" to "ઈવ",
    "efi" to "એફિક",
    "egy" to "પ્રાચીન ઇજીપ્શિયન",
    "eka" to "એકાજુક",
    "el" to "ગ્રીક",
    "elx" to "એલામાઇટ",
    "en" to "અંગ્રેજી",
    "en-AU" to "ઓસ્ટ્રેલિયન અંગ્રેજી",
    "en-CA" to "કેનેડિયન અંગ્રેજી",
    "en-GB" to "બ્રિટિશ અંગ્રેજી",
    "en-GB-alt-short" to "યુ.કે. અંગ્રેજી",
    "en-US" to "અમેરિકન અંગ્રેજી",
    "en-US-alt-short" to "અમેરિકન અંગ્રેજી",
    "enm" to "મિડિલ અંગ્રેજી",
    "eo" to "એસ્પેરાન્ટો",
    "es" to "સ્પેનિશ",
    "es-419" to "લેટિન અમેરિકન સ્પેનિશ",
    "es-ES" to "યુરોપિયન સ્પેનિશ",
    "es-MX" to "મેક્સિકન સ્પેનિશ",
    "et" to "એસ્ટોનિયન",
    "eu" to "બાસ્ક",
    "ewo" to "ઇવોન્ડો",
    "fa" to "ફારસી",
    "fa-AF" to "ડારી",
    "fan" to "ફેંગ",
    "fat" to "ફન્ટી",
    "ff" to "ફુલા",
    "fi" to "ફિનિશ",
    "fil" to "ફિલિપિનો",
    "fj" to "ફીજીયન",
    "fo" to "ફોરિસ્ત",
    "fon" to "ફોન",
    "fr" to "ફ્રેન્ચ",
    "fr-CH" to "સ્વિસ ફ્રેંચ",
    "frc" to "કાજૂન ફ્રેન્ચ",
    "frm" to "મિડિલ ફ્રેંચ",
    "fro" to "જૂની ફ્રેંચ",
    "frr" to "ઉત્તરી ફ્રિશિયન",
    "frs" to "પૂર્વ ફ્રિશિયન",
    "fur" to "ફ્રિયુલિયાન",
    "fy" to "પશ્ચિમિ ફ્રિશિયન",
    "ga" to "આઇરિશ",
    "gaa" to "ગા",
    "gag" to "ગાગાઝ",
    "gan" to "gan",
    "gay" to "ગાયો",
    "gba" to "બાયા",
    "gbz" to "ઝોરોસ્ટ્રિઅન દારી",
    "gd" to "સ્કોટીસ ગેલિક",
    "gez" to "ગીઝ",
    "gil" to "જિલ્બરટીઝ",
    "gl" to "ગેલિશિયન",
    "gmh" to "મધ્ય હાઇ જર્મન",
    "gn" to "ગુઆરાની",
    "goh" to "જૂની હાઇ જર્મન",
    "gon" to "ગોંડી",
    "gor" to "ગોરોન્તાલો",
    "got" to "ગોથિક",
    "grb" to "ગ્રેબો",
    "grc" to "પ્રાચીન ગ્રીક",
    "gsw" to "સ્વિસ જર્મન",
    "gu" to "ગુજરાતી",
    "guz" to "ગુસી",
    "gv" to "માંક્સ",
    "gwi" to "ગ્વિચ’ઇન",
    "ha" to "હૌસા",
    "hai" to "હૈડા",
    "haw" to "હવાઇયન",
    "hax" to "દક્ષિણ હૈડા",
    "he" to "હીબ્રુ",
    "hi" to "હિન્દી",
    "hi-Latn-alt-variant" to "હિંગ્લિશ",
    "hif" to "ફીજી હિંદી",
    "hil" to "હિલિગેનોન",
    "hit" to "હિટ્ટિતે",
    "hmn" to "હમોંગ",
    "ho" to "હિરી મોટૂ",
    "hr" to "ક્રોએશિયન",
    "hsb" to "અપર સોર્બિયન",
    "ht" to "હૈતિઅન ક્રેઓલે",
    "hu" to "હંગેરિયન",
    "hup" to "હૂપા",
    "hur" to "હેલ્કોમેલેમ",
    "hy" to "આર્મેનિયન",
    "hz" to "હેરેરો",
    "ia" to "ઇંટરલિંગુઆ",
    "iba" to "ઇબાન",
    "ibb" to "ઇબિબિઓ",
    "id" to "ઇન્ડોનેશિયન",
    "ie" to "ઇંટરલિંગ",
    "ig" to "ઇગ્બો",
    "ii" to "સિચુઆન યી",
    "ik" to "ઇનુપિયાક",
    "ikt" to "પશ્ચિમ કેનેડિયન ઇનુકિટ્યુટ",
    "ilo" to "ઇલોકો",
    "inh" to "ઇંગુશ",
    "io" to "ઈડો",
    "is" to "આઇસલેન્ડિક",
    "it" to "ઇટાલિયન",
    "iu" to "ઇનુકિટૂટ",
    "ja" to "જાપાનીઝ",
    "jbo" to "લોજ્બાન",
    "jgo" to "નગોમ્બા",
    "jmc" to "મકામે",
    "jpr" to "જુદેઓ-પર્શિયન",
    "jrb" to "જુદેઓ-અરબી",
    "jv" to "જાવાનીસ",
    "ka" to "જ્યોર્જિયન",
    "kaa" to "કારા-કલ્પક",
    "kab" to "કબાઇલ",
    "kac" to "કાચિન",
    "kaj" to "જ્જુ",
    "kam" to "કમ્બા",
    "kaw" to "કાવી",
    "kbd" to "કબાર્ડિયન",
    "kcg" to "ત્યાપ",
    "kde" to "મકોન્ડે",
    "kea" to "કાબુવર્ડિઆનુ",
    "kfo" to "કોરો",
    "kg" to "કોંગો",
    "kgp" to "કૈંગાંગ",
    "kha" to "ખાસી",
    "kho" to "ખોતાનીસ",
    "khq" to "કોયરા ચિનિ",
    "ki" to "કિકુયૂ",
    "kj" to "ક્વાન્યામા",
    "kk" to "કઝાખ",
    "kkj" to "કાકો",
    "kl" to "કલાલ્લિસુત",
    "kln" to "કલેજિન",
    "km" to "ખ્મેર",
    "kmb" to "કિમ્બન્દુ",
    "kn" to "કન્નડ",
    "ko" to "કોરિયન",
    "koi" to "કોમી-પર્મ્યાક",
    "kok" to "કોંકણી",
    "kos" to "કોસરિયન",
    "kpe" to "ક્પેલ્લે",
    "kr" to "કનુરી",
    "krc" to "કરાચય-બલ્કાર",
    "krl" to "કરેલિયન",
    "kru" to "કુરૂખ",
    "ks" to "કાશ્મીરી",
    "ksb" to "શમ્બાલા",
    "ksf" to "બફિયા",
    "ksh" to "કોલોગ્નિયન",
    "ku" to "કુર્દિશ",
    "kum" to "કુમીક",
    "kut" to "કુતેનાઇ",
    "kv" to "કોમી",
    "kw" to "કોર્નિશ",
    "kwk" to "ક્વેકવાલા",
    "kxv" to "કૂવી",
    "ky" to "કિર્ગીઝ",
    "la" to "લેટિન",
    "lad" to "લાદીનો",
    "lag" to "લંગી",
    "lah" to "લાહન્ડા",
    "lam" to "લામ્બા",
    "lb" to "લક્ઝેમબર્ગિશ",
    "lez" to "લેઝધીયન",
    "lfn" to "લિંગ્વા ફેન્કા નોવા",
    "lg" to "ગાંડા",
    "li" to "લિંબૂર્ગિશ",
    "lij" to "લિગુરીઅન",
    "lil" to "લિલુએટ",
    "lkt" to "લાકોટા",
    "lmo" to "લોંબાર્ડ",
    "ln" to "લિંગાલા",
    "lo" to "લાઓ",
    "lol" to "મોંગો",
    "lou" to "લ્યુઇસિયાના ક્રેઓલ",
    "loz" to "લોઝી",
    "lrc" to "ઉત્તરી લુરી",
    "lsm" to "સામિયા",
    "lt" to "લિથુઆનિયન",
    "lu" to "લૂબા-કટાંગા",
    "lua" to "લૂબા-લુલુઆ",
    "lui" to "લુઇસેનો",
    "lun" to "લુન્ડા",
    "luo" to "લ્યુઓ",
    "lus" to "મિઝો",
    "luy" to "લુઈયા",
    "lv" to "લાતવિયન",
    "mad" to "માદુરીસ",
    "mag" to "મગહી",
    "mai" to "મૈથિલી",
    "mak" to "મકાસર",
    "man" to "મન્ડિન્ગો",
    "mas" to "મસાઇ",
    "mdf" to "મોક્ષ",
    "mdr" to "મંદાર",
    "men" to "મેન્ડે",
    "mer" to "મેરુ",
    "mfe" to "મોરીસ્યેન",
    "mg" to "મલાગસી",
    "mga" to "મધ્ય આઈરિશ",
    "mgh" to "માખુવા-મીટ્ટુ",
    "mgo" to "મેતા",
    "mh" to "માર્શલીઝ",
    "mi" to "માઓરી",
    "mic" to "મિકમેક",
    "min" to "મિનાંગ્કાબાઉ",
    "mk" to "મેસેડોનિયન",
    "ml" to "મલયાલમ",
    "mn" to "મોંગોલિયન",
    "mnc" to "માન્ચુ",
    "mni" to "મણિપુરી",
    "moe" to "ઇન્નુ-આયમુન",
    "moh" to "મોહૌક",
    "mos" to "મોસ્સી",
    "mr" to "મરાઠી",
    "mrj" to "પશ્ચિમી મારી",
    "ms" to "મલય",
    "mt" to "માલ્ટિઝ",
    "mua" to "મુનડાન્ગ",
    "mul" to "બહુવિધ ભાષાઓ",
    "mus" to "ક્રિક",
    "mwl" to "મિરાંડી",
    "mwr" to "મારવાડી",
    "my" to "બર્મીઝ",
    "myv" to "એર્ઝયા",
    "mzn" to "મઝાન્દેરાની",
    "na" to "નાઉરૂ",
    "nap" to "નેપોલિટાન",
    "naq" to "નમા",
    "nb" to "નોર્વેજિયન બોકમાલ",
    "nd" to "ઉત્તર દેબેલ",
    "nds" to "લો જર્મન",
    "nds-NL" to "લો સેક્સોન",
    "ne" to "નેપાળી",
    "new" to "નેવારી",
    "ng" to "ડોન્ગા",
    "nia" to "નિયાસ",
    "niu" to "નિયુઆન",
    "nl" to "ડચ",
    "nl-BE" to "ફ્લેમિશ",
    "nmg" to "ક્વાસિઓ",
    "nn" to "નોર્વેજિયન નાયનૉર્સ્ક",
    "nnh" to "નીએમબુન",
    "no" to "નૉર્વેજીયન",
    "nog" to "નોગાઇ",
    "non" to "જૂની નોર્સ",
    "nqo" to "એન’કો",
    "nr" to "દક્ષિણ દેબેલ",
    "nso" to "ઉત્તરી સોથો",
    "nus" to "નુએર",
    "nv" to "નાવાજો",
    "nwc" to "પરંપરાગત નેવારી",
    "ny" to "ન્યાન્જા",
    "nym" to "ન્યામવેઝી",
    "nyn" to "ન્યાનકોલ",
    "nyo" to "ન્યોરો",
    "nzi" to "ન્ઝિમા",
    "oc" to "ઓક્સિટન",
    "oj" to "ઓજિબ્વા",
    "ojb" to "ઉત્તરપશ્ચિમી ઓઝિબવે",
    "ojc" to "સેન્ટ્રલ ઓઝિબ્વા",
    "ojs" to "ઓજી-ક્રી",
    "ojw" to "પશ્ચિમી ઓઝિબ્વા",
    "oka" to "ઓકાનાગન",
    "om" to "ઓરોમો",
    "or" to "ઉડિયા",
    "os" to "ઓસ્સેટિક",
    "osa" to "ઓસેજ",
    "ota" to "ઓટોમાન તુર્કિશ",
    "pa" to "પંજાબી",
    "pag" to "પંગાસીનાન",
    "pal" to "પહલવી",
    "pam" to "પમ્પાન્ગા",
    "pap" to "પાપિયામેન્ટો",
    "pau" to "પલાઉઆન",
    "pcm" to "નાઇજેરિયન પીજીન",
    "peo" to "જૂની ફારસી",
    "phn" to "ફોનિશિયન",
    "pi" to "પાલી",
    "pis" to "પિજિન",
    "pl" to "પોલીશ",
    "pon" to "પોહપિએન",
    "pqm" to "મલિસીટ-પાસમાક્વોડ્ડી",
    "prg" to "પ્રુસ્સીયન",
    "pro" to "જુની પ્રોવેન્સલ",
    "ps" to "પશ્તો",
    "ps-alt-variant" to "પુશ્તો",
    "pt" to "પોર્ટુગીઝ",
    "pt-BR" to "બ્રાઝિલીયન પોર્ટુગીઝ",
    "pt-PT" to "યુરોપિયન પોર્ટુગીઝ",
    "qu" to "ક્વેચુઆ",
    "quc" to "કિચે",
    "raj" to "રાજસ્થાની",
    "rap" to "રાપાનુઇ",
    "rar" to "રારોટોંગન",
    "rhg" to "રોહિંગ્યા",
    "rm" to "રોમાન્શ",
    "rn" to "રૂન્દી",
    "ro" to "રોમાનિયન",
    "ro-MD" to "મોલડાવિયન",
    "rof" to "રોમ્બો",
    "rom" to "રોમાની",
    "ru" to "રશિયન",
    "rup" to "અરોમેનિયન",
    "rw" to "કિન્યારવાન્ડા",
    "rwk" to "રવા",
    "sa" to "સંસ્કૃત",
    "sad" to "સોંડવે",
    "sah" to "સખા",
    "sam" to "સામરિટાન અરેમિક",
    "saq" to "સમ્બુરુ",
    "sas" to "સાસાક",
    "sat" to "સંતાલી",
    "sba" to "ન્ગામ્બેય",
    "sbp" to "સાંગુ",
    "sc" to "સાર્દિનિયન",
    "scn" to "સિસિલિયાન",
    "sco" to "સ્કોટ્સ",
    "sd" to "સિંધી",
    "sdh" to "સર્ઘન કુર્દીશ",
    "se" to "ઉત્તરી સામી",
    "seh" to "સેના",
    "sel" to "સેલ્કપ",
    "ses" to "કોયરાબોરો સેન્ની",
    "sg" to "સાંગો",
    "sga" to "જૂની આયરિશ",
    "sh" to "સર્બો-ક્રોએશિયન",
    "shi" to "તેશીલહિટ",
    "shn" to "શેન",
    "si" to "સિંહાલી",
    "sid" to "સિદામો",
    "sk" to "સ્લોવૅક",
    "sl" to "સ્લોવેનિયન",
    "slh" to "દક્ષિણ લુશુટસીડ",
    "sm" to "સામોન",
    "sma" to "દક્ષિણી સામી",
    "smj" to "લુલે સામી",
    "smn" to "ઇનારી સામી",
    "sms" to "સ્કોલ્ટ સામી",
    "sn" to "શોના",
    "snk" to "સોનિન્કે",
    "so" to "સોમાલી",
    "sog" to "સોગ્ડિએન",
    "sq" to "અલ્બેનિયન",
    "sr" to "સર્બિયન",
    "srn" to "સ્રાનન ટોન્ગો",
    "srr" to "સેરેર",
    "ss" to "સ્વાતી",
    "ssy" to "સાહો",
    "st" to "દક્ષિણ સોથો",
    "str" to "સ્ટ્રેટ્સ સેલિશ",
    "su" to "સંડેનીઝ",
    "suk" to "સુકુમા",
    "sus" to "સુસુ",
    "sux" to "સુમેરિયન",
    "sv" to "સ્વીડિશ",
    "sw" to "સ્વાહિલી",
    "sw-CD" to "કોંગો સ્વાહિલી",
    "swb" to "કોમોરિયન",
    "syc" to "પરંપરાગત સિરિએક",
    "syr" to "સિરિએક",
    "szl" to "સિલેસ્યિન",
    "ta" to "તમિલ",
    "tce" to "દક્ષિણ ટુચૉન",
    "tcy" to "તુલુ",
    "te" to "તેલુગુ",
    "tem" to "ટિમ્ને",
    "teo" to "તેસો",
    "ter" to "તેરેનો",
    "tet" to "તેતુમ",
    "tg" to "તાજીક",
    "tgx" to "ટાગિશ",
    "th" to "થાઈ",
    "tht" to "તહલતાન",
    "ti" to "ટાઇગ્રિનિયા",
    "tig" to "ટાઇગ્રે",
    "tiv" to "તિવ",
    "tk" to "તુર્કમેન",
    "tkl" to "તોકેલાઉ",
    "tl" to "ટાગાલોગ",
    "tlh" to "ક્લિન્ગોન",
    "tli" to "ટ્લિંગિટ",
    "tmh" to "તામાશેખ",
    "tn" to "ત્સ્વાના",
    "to" to "ટોંગાન",
    "tog" to "ન્યાસા ટોન્ગા",
    "tok" to "ટોકી પોના",
    "tpi" to "ટોક પિસિન",
    "tr" to "ટર્કિશ",
    "trv" to "ટારોકો",
    "ts" to "સોંગા",
    "tsi" to "સિમ્શિયન",
    "tt" to "તતાર",
    "ttm" to "ઉત્તરી ટુચૉન",
    "ttt" to "મુસ્લિમ તાટ",
    "tum" to "તુમ્બુકા",
    "tvl" to "તુવાલુ",
    "tw" to "ટ્વાઇ",
    "twq" to "તસાવાક",
    "ty" to "તાહિતિયન",
    "tyv" to "ટુવીનિયન",
    "tzm" to "સેન્ટ્રલ એટલાસ તામાઝિટ",
    "udm" to "ઉદમુર્ત",
    "ug" to "ઉઇગુર",
    "uga" to "યુગેરિટિક",
    "uk" to "યુક્રેનિયન",
    "umb" to "ઉમ્બુન્ડૂ",
    "und" to "અજ્ઞાત ભાષા",
    "ur" to "ઉર્દૂ",
    "uz" to "ઉઝ્બેક",
    "vai" to "વાઇ",
    "ve" to "વેન્દા",
    "vec" to "વેનેશ્યિન",
    "vi" to "વિયેતનામીસ",
    "vmw" to "મખુવા",
    "vo" to "વોલાપુક",
    "vot" to "વોટિક",
    "vun" to "વુન્જો",
    "wa" to "વાલૂન",
    "wae" to "વેલ્સેર",
    "wal" to "વોલાયટ્ટા",
    "war" to "વારેય",
    "was" to "વાશો",
    "wbp" to "વાર્લ્પીરી",
    "wo" to "વોલોફ",
    "wuu" to "વુ ચાઈનીઝ",
    "xal" to "કાલ્મિક",
    "xh" to "ખોસા",
    "xnr" to "કંગરી",
    "xog" to "સોગા",
    "yao" to "યાઓ",
    "yap" to "યાપીસ",
    "yav" to "યાન્ગબેન",
    "ybb" to "યેમ્બા",
    "yi" to "યિદ્દિશ",
    "yo" to "યોરૂબા",
    "yrl" to "નહેનગાતુ",
    "yue" to "કેંટોનીઝ",
    "yue-alt-menu" to "ચાઇનીઝ, કેન્ટોનીઝ",
    "za" to "ઝુઆગ",
    "zap" to "ઝેપોટેક",
    "zbl" to "બ્લિસિમ્બોલ્સ",
    "zen" to "ઝેનાગા",
    "zgh" to "માનક મોરોક્કન તામાઝિટ",
    "zh" to "ચાઇનીઝ",
    "zh-alt-menu" to "ચાઇનીઝ, મેન્ડેરિન",
    "zh-Hans" to "સરળીકૃત ચાઇનીઝ",
    "zh-Hans-alt-long" to "સરળીકૃત મેન્ડેરિન ચાઇનીઝ",
    "zh-Hant" to "પારંપરિક ચાઇનીઝ",
    "zh-Hant-alt-long" to "પરંપરાગત મેન્ડેરિન ચાઇનીઝ",
    "zu" to "ઝુલુ",
    "zun" to "ઝૂની",
    "zxx" to "કોઇ ભાષાશાસ્ત્રીય સામગ્રી નથી",
    "zza" to "ઝાઝા",
  ) }

  val guz: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Kiakan",
    "am" to "Kiamhari",
    "ar" to "Kiarabu",
    "be" to "Kibelarusi",
    "bg" to "Kibulgaria",
    "bn" to "Kibangla",
    "cs" to "Kichecki",
    "de" to "Kijerumani",
    "el" to "Kigiriki",
    "en" to "Kingereza",
    "es" to "Kihispania",
    "fa" to "Kiajemi",
    "fr" to "Kifaransa",
    "guz" to "Ekegusii",
    "ha" to "Kihausa",
    "hi" to "Kihindi",
    "hu" to "Kihungari",
    "id" to "Kiindonesia",
    "ig" to "Kiigbo",
    "it" to "Kiitaliano",
    "ja" to "Kijapani",
    "jv" to "Kijava",
    "km" to "Kikambodia",
    "ko" to "Kikorea",
    "ms" to "Kimalesia",
    "my" to "Kiburma",
    "ne" to "Kinepali",
    "nl" to "Kiholanzi",
    "pa" to "Kipunjabi",
    "pl" to "Kipolandi",
    "pt" to "Kireno",
    "ro" to "Kiromania",
    "ru" to "Kirusi",
    "rw" to "Kinyarwanda",
    "so" to "Kisomali",
    "sv" to "Kiswidi",
    "ta" to "Kitamil",
    "th" to "Kitailandi",
    "tr" to "Kituruki",
    "uk" to "Kiukrania",
    "ur" to "Kiurdu",
    "vi" to "Kivietinamu",
    "yo" to "Kiyoruba",
    "zh" to "Kichina",
    "zh-alt-menu" to "Kichina",
    "zu" to "Kizulu",
  ) }

  val gv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "gv" to "Gaelg",
  ) }

  val ha: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ab" to "Abkhazian",
    "ace" to "Achinese",
    "ada" to "Adangme",
    "ady" to "Adyghe",
    "af" to "Afirkanci",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "ale" to "Aleut",
    "alt" to "Altai na Kudanci",
    "am" to "Amharik",
    "an" to "Aragonesanci",
    "ann" to "Obolo",
    "anp" to "Angika",
    "ar" to "Larabci",
    "ar-001" to "Larabci Asali Na Zamani",
    "arn" to "Mapuche",
    "arp" to "Arapaho",
    "ars" to "Larabcin Najdi",
    "as" to "Asamisanci",
    "asa" to "Asu",
    "ast" to "Asturia",
    "atj" to "Atikamekw",
    "av" to "Avaric",
    "awa" to "Awadhi",
    "ay" to "Aymaranci",
    "az" to "Azerbaijanci",
    "az-alt-short" to "Azeri",
    "ba" to "Bashkir",
    "ban" to "Balenesanci",
    "bas" to "Basaa",
    "be" to "Belarusanci",
    "bem" to "Bemba",
    "bez" to "Bena",
    "bg" to "Bulgariyanci",
    "bgc" to "Haryanvi",
    "bho" to "Bhojpuri",
    "bi" to "Bislama",
    "bin" to "Bini",
    "bla" to "Siksiká",
    "blo" to "Anii",
    "bm" to "Bambara",
    "bn" to "Bengali",
    "bo" to "Tibetan",
    "br" to "Buretananci",
    "brx" to "Bodo",
    "bs" to "Bosniyanci",
    "bug" to "Buginesanci",
    "byn" to "Blin",
    "ca" to "Kataloniyanci",
    "cay" to "Cayuga",
    "ccp" to "Chakma",
    "ce" to "Chechen",
    "ceb" to "Cebuano",
    "cgg" to "Chiga",
    "ch" to "Chamorro",
    "chk" to "Chuukese",
    "chm" to "Mari",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyenne",
    "ckb" to "Kurdawa ta Tsakiya",
    "ckb-alt-menu" to "Kurdawa ta Tsakiya",
    "ckb-alt-variant" to "Kurdawa ta Tsakiya",
    "clc" to "Chilcotin",
    "co" to "Corsican",
    "crg" to "Michif",
    "crj" to "Cree na Kusu-Maso-Gabas",
    "crk" to "Plains Cree",
    "crl" to "Cree na Arewacin-Gabas",
    "crm" to "Moose Cree",
    "crr" to "Carolina Algonquian",
    "cs" to "Cek",
    "csw" to "Swampy Cree",
    "cu" to "Church Slavic",
    "cv" to "Chuvash",
    "cy" to "Welsh",
    "da" to "Danish",
    "dak" to "Dakota",
    "dar" to "Dargwa",
    "dav" to "Taita",
    "de" to "Jamusanci",
    "de-AT" to "Jamusanci Ostiriya",
    "de-CH" to "Jamusanci Suwizalan",
    "dgr" to "Dogrib",
    "dje" to "Zarma",
    "doi" to "Harshen Dogri",
    "dsb" to "Sorbianci ta kasa",
    "dua" to "Duala",
    "dv" to "Divehi",
    "dyo" to "Jola-Fonyi",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "eka" to "Ekajuk",
    "el" to "Girkanci",
    "en" to "Turanci",
    "en-AU" to "Turanci Ostareliya",
    "en-GB-alt-short" to "Turanci (Biritaniya)",
    "en-US-alt-short" to "Turanci (Amurka)",
    "eo" to "Esperanto",
    "es" to "Sifaniyanci",
    "es-419" to "Sifaniyancin Latin Amirka",
    "es-ES" to "Sifaniyanci Turai",
    "es-MX" to "Sifaniyanci Mesiko",
    "et" to "Istoniyanci",
    "eu" to "Basque",
    "ewo" to "Ewondo",
    "fa" to "Farisanci",
    "fa-AF" to "Farisanci na Afaganistan",
    "ff" to "Fula",
    "fi" to "Yaren mutanen Finland",
    "fil" to "Dan Filifin",
    "fj" to "Fijiyanci",
    "fo" to "Faroese",
    "fon" to "Fon",
    "fr" to "Faransanci",
    "fr-CA" to "Farasanci Kanada",
    "fr-CH" to "Farasanci Suwizalan",
    "frc" to "Faransancin Cajun",
    "frr" to "Firisiyanci na Arewaci",
    "fur" to "Friulian",
    "fy" to "Frisian ta Yamma",
    "ga" to "Dan Irish",
    "gaa" to "Ga",
    "gd" to "Kʼabilan Scots Gaelic",
    "gez" to "Geez",
    "gil" to "Gilbertese",
    "gl" to "Bagalike",
    "gn" to "Guwaraniyanci",
    "gor" to "Gorontalo",
    "gsw" to "Jamusanci Swiss",
    "gu" to "Gujarati",
    "guz" to "Gusii",
    "gv" to "Manx",
    "gwi" to "Gwichʼin",
    "ha" to "Hausa",
    "hai" to "Haida",
    "haw" to "Hawaiianci",
    "hax" to "Haida na Kudanci",
    "he" to "Ibrananci",
    "hi" to "Harshen Hindi",
    "hi-Latn-alt-variant" to "Harshen Hindi (Latin)",
    "hil" to "Hiligaynon",
    "hmn" to "Hmong",
    "hr" to "Kuroshiyan",
    "hsb" to "Sorbianci ta Sama",
    "ht" to "Haitian Creole",
    "hu" to "Harshen Hungari",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Armeniyanci",
    "hz" to "Herero",
    "ia" to "Yare Tsakanin Kasashe",
    "iba" to "Iban",
    "ibb" to "Ibibio",
    "id" to "Harshen Indunusiya",
    "ie" to "Intagulanci",
    "ig" to "Igbo",
    "ii" to "Sichuan Yi",
    "ikt" to "Inuktitut na Yammacin Kanada",
    "ilo" to "Ikolo",
    "inh" to "Ingush",
    "io" to "Ido",
    "is" to "Yaren mutanen Iceland",
    "it" to "Italiyanci",
    "iu" to "Inuktitut",
    "ja" to "Japananci",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jv" to "Javananci",
    "ka" to "Jojiyanci",
    "kab" to "Kabyle",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kbd" to "Karbadiyanci",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kabuverdianu",
    "kfo" to "Koro",
    "kgp" to "Kaingang",
    "kha" to "Khasi",
    "khq" to "Koyra Chiini",
    "ki" to "Kikuyu",
    "kj" to "Kuanyama",
    "kk" to "Kazakh",
    "kkj" to "Kako",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Harshen Kimar",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Harshen Koriya",
    "kok" to "Konkananci",
    "kpe" to "Kpelle",
    "kr" to "Kanuri",
    "krc" to "Karachay-Balkar",
    "krl" to "Kareliyanci",
    "kru" to "Kurukh",
    "ks" to "Kashmiri",
    "ksb" to "Shambala",
    "ksf" to "Bafia",
    "ksh" to "Colognian",
    "ku" to "Kurdanci",
    "kum" to "Kumyk",
    "kv" to "Komi",
    "kw" to "Cornish",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kavi",
    "ky" to "Kirgizanci",
    "la" to "Dan Kabilar Latin",
    "lad" to "Ladino",
    "lag" to "Langi",
    "lb" to "Luxembourgish",
    "lez" to "Lezghiniyanci",
    "lg" to "Ganda",
    "li" to "Limburgish",
    "lij" to "Liguriyanci",
    "lil" to "Lillooet",
    "lkt" to "Lakota",
    "lmo" to "Lombard",
    "ln" to "Lingala",
    "lo" to "Lao",
    "lou" to "Creole na Louisiana",
    "loz" to "Lozi",
    "lrc" to "Arewacin Luri",
    "lsm" to "Saamiyanci",
    "lt" to "Lituweniyanci",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lun" to "Lunda",
    "luo" to "Luo",
    "lus" to "Mizo",
    "luy" to "Luyia",
    "lv" to "Latbiyanci",
    "mad" to "Madurese",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Makasar",
    "mas" to "Harshen Masai",
    "mdf" to "Moksha",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisyen",
    "mg" to "Malagasi",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Metaʼ",
    "mh" to "Marshallese",
    "mi" to "Maori",
    "mic" to "Mi'kmaq",
    "min" to "Minangkabau",
    "mk" to "Dan Masedoniya",
    "ml" to "Malayalamci",
    "mn" to "Mongoliyanci",
    "mni" to "Manipuri",
    "moe" to "Innu-aimun",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Maratinci",
    "ms" to "Harshen Malay",
    "mt" to "Harshen Maltis",
    "mua" to "Mundang",
    "mul" to "Harsuna masu yawa",
    "mus" to "Muscogee",
    "mwl" to "Mirandese",
    "my" to "Burmanci",
    "myv" to "Erzya",
    "mzn" to "Mazanderani",
    "na" to "Nauru",
    "nap" to "Neapolitan",
    "naq" to "Nama",
    "nb" to "Norwegian Bokmål",
    "nd" to "North Ndebele",
    "nds" to "Low German",
    "ne" to "Nepali",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niuean",
    "nl" to "Holanci",
    "nmg" to "Kwasio",
    "nn" to "Norwegian Nynorsk",
    "nnh" to "Ngiemboon",
    "no" to "Harhsen Norway",
    "nog" to "Harshen Nogai",
    "nqo" to "N’Ko",
    "nr" to "Ndebele na Kudu",
    "nso" to "Sotho na Arewaci",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "ny" to "Nyanja",
    "nyn" to "Nyankole",
    "oc" to "Ositanci",
    "ojb" to "Ojibwa na Arewa-Maso-Yamma",
    "ojc" to "Ojibwa na Tsakiya",
    "ojs" to "Oji-Cree",
    "ojw" to "Ojibwa na Yammaci",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Odiya",
    "os" to "Ossetic",
    "pa" to "Punjabi",
    "pag" to "Pangasinanci",
    "pam" to "Pampanga",
    "pap" to "Papiamento",
    "pau" to "Palauan",
    "pcm" to "Pidgin na Najeriya",
    "pis" to "Pijin",
    "pl" to "Harshen Polan",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Ferusawa",
    "ps" to "Pashtanci",
    "pt" to "Harshen Potugis",
    "pt-BR" to "Harshen Potugis na Birazil",
    "pt-PT" to "Potugis Ƙasashen Turai",
    "qu" to "Quechua",
    "raj" to "Rajasthani",
    "rap" to "Rapanui",
    "rar" to "Rarotongan",
    "rhg" to "Harshen Rohingya",
    "rm" to "Romansh",
    "rn" to "Rundi",
    "ro" to "Romaniyanci",
    "rof" to "Rombo",
    "ru" to "Rashanci",
    "rup" to "Aromaniyanci",
    "rw" to "Kinyarwanda",
    "rwk" to "Rwa",
    "sa" to "Sanskrit",
    "sad" to "Sandawe",
    "sah" to "Yakut",
    "saq" to "Samburu",
    "sat" to "Santali",
    "sba" to "Ngambay",
    "sbp" to "Sangu",
    "sc" to "Sardiniyanci",
    "scn" to "Sisiliyanci",
    "sco" to "Scots",
    "sd" to "Sindiyanci",
    "se" to "Sami ta Arewa",
    "seh" to "Sena",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "sh" to "Kuroweshiyancin-Sabiya",
    "shi" to "Tachelhit",
    "shn" to "Shan",
    "si" to "Sinhalanci",
    "sk" to "Basulke",
    "sl" to "Basulabe",
    "slh" to "Lushbootseed na Kudanci",
    "sm" to "Samoan",
    "smn" to "Inari Sami",
    "sms" to "Skolt Sami",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somalianci",
    "sq" to "Albaniyanci",
    "sr" to "Sabiyan",
    "srn" to "Sranan Tongo",
    "ss" to "Swati",
    "st" to "Sesotanci",
    "str" to "Straits Salish",
    "su" to "Harshen Sundanese",
    "suk" to "Sukuma",
    "sv" to "Harshen Suwedan",
    "sw" to "Harshen Suwahili",
    "swb" to "Komoriyanci",
    "syr" to "Syriac",
    "szl" to "Silessiyanci",
    "ta" to "Tamil",
    "tce" to "Tutchone na Kudanci",
    "te" to "Telugu",
    "tem" to "Timne",
    "teo" to "Teso",
    "tet" to "Tatum",
    "tg" to "Tajik",
    "tgx" to "Tagish",
    "th" to "Thai",
    "tht" to "Tahltan",
    "ti" to "Tigrinyanci",
    "tig" to "Tigre",
    "tk" to "Tukmenistanci",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tn" to "Tswana",
    "to" to "Tonganci",
    "tok" to "Toki Pona",
    "tpi" to "Tok Pisin",
    "tr" to "Harshen Turkiyya",
    "trv" to "Taroko",
    "ts" to "Tsonga",
    "tt" to "Tatar",
    "ttm" to "Tutchone na Arewaci",
    "tum" to "Tumbuka",
    "tvl" to "Tuvalu",
    "tw" to "Tiwiniyanci",
    "twq" to "Tasawak",
    "ty" to "Tahitiyanci",
    "tyv" to "Tuviniyanci",
    "tzm" to "Tamazight na Atlas Tsaka",
    "udm" to "Udmurt",
    "ug" to "Ugiranci",
    "uk" to "Harshen Yukuren",
    "umb" to "Umbundu",
    "und" to "Harshen da ba a sani ba",
    "ur" to "Urdanci",
    "uz" to "Uzbek",
    "vai" to "Vai",
    "ve" to "Venda",
    "vec" to "Veneshiyanci",
    "vi" to "Harshen Biyetinam",
    "vmw" to "Makhuwa",
    "vo" to "Volapük",
    "vun" to "Vunjo",
    "wa" to "Walloon",
    "wae" to "Walser",
    "wal" to "Wolaytta",
    "war" to "Waray",
    "wo" to "Wolof",
    "wuu" to "Sinancin Wu",
    "xal" to "Kalmyk",
    "xh" to "Xhosa",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Yaren Yiddish",
    "yo" to "Yarbanci",
    "yrl" to "Nheengatu",
    "yue" to "Harshen Cantonese",
    "yue-alt-menu" to "Sinanci, Cantonese",
    "za" to "Zhuang",
    "zgh" to "Daidaitaccen Moroccan Tamazight",
    "zh" to "Harshen Sinanci",
    "zh-alt-menu" to "Harshen, Sinanci",
    "zh-Hans" to "Sauƙaƙaƙƙen Sinanci",
    "zh-Hans-alt-long" to "Sauƙaƙaƙƙen Sinanci",
    "zh-Hant" to "Sinanci na gargajiya",
    "zh-Hant-alt-long" to "Sinanci na gargajiya",
    "zu" to "Harshen Zulu",
    "zun" to "Zuni",
    "zxx" to "Babu abun cikin yare",
    "zza" to "Zaza",
  ) }

  val ha_GH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ha_NE: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val haw: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar" to "ʻAlapia",
    "cy" to "Wale",
    "da" to "Kenemaka",
    "de" to "Kelemānia",
    "el" to "Helene",
    "en" to "Pelekānia",
    "en-AU" to "Pelekāne Nū Hōlani",
    "en-CA" to "Pelekāne Kanakā",
    "en-GB" to "Pelekānia Pekekāne",
    "en-GB-alt-short" to "Pelekānia Pekekāne",
    "en-US" to "Pelekānia ʻAmelika",
    "en-US-alt-short" to "Pelekānia ʻAmelika",
    "es" to "Paniolo",
    "fj" to "Pīkī",
    "fr" to "Palani",
    "fr-CA" to "Palani Kanakā",
    "fr-CH" to "Kuikilani",
    "ga" to "ʻAiliki",
    "gsw" to "Kuikilani Kelemānia",
    "haw" to "ʻŌlelo Hawaiʻi",
    "he" to "Hebera",
    "it" to "ʻĪkālia",
    "ja" to "Kepanī",
    "ko" to "Kōlea",
    "la" to "Lākina",
    "mi" to "Māori",
    "nl" to "Hōlani",
    "pt" to "Pukikī",
    "pt-BR" to "Pukikī Palakila",
    "ru" to "Lūkia",
    "sm" to "Kāmoa",
    "sv" to "Kuekene",
    "to" to "Tonga",
    "ty" to "Polapola",
    "und" to "ʻIke ʻole ‘ia a kūpono ʻole paha ka ʻōlelo",
    "vi" to "Wiekanama",
    "zh" to "Pākē",
    "zh-alt-menu" to "Pākē",
    "zh-Hans" to "Pākē Hoʻomaʻalahi ʻia",
    "zh-Hans-alt-long" to "Pākē Hoʻomaʻalahi ʻia",
    "zh-Hant" to "Pākē Kuʻuna",
    "zh-Hant-alt-long" to "Pākē Kuʻuna",
  ) }

  val he: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "אפארית",
    "ab" to "אבחזית",
    "ace" to "אכינזית",
    "ach" to "אקצ׳ולי",
    "ada" to "אדנמה",
    "ady" to "אדיגית",
    "ae" to "אבסטן",
    "af" to "אפריקאנס",
    "afh" to "אפריהילי",
    "agq" to "אע׳ם",
    "ain" to "אינו",
    "ak" to "אקאן",
    "akk" to "אכדית",
    "ale" to "אלאוט",
    "alt" to "אלטאי דרומית",
    "am" to "אמהרית",
    "an" to "אראגונית",
    "ang" to "אנגלית עתיקה",
    "ann" to "אובולו",
    "anp" to "אנג׳יקה",
    "ar" to "ערבית",
    "ar-001" to "ערבית ספרותית",
    "arc" to "ארמית",
    "arn" to "אראוקנית",
    "arp" to "אראפהו",
    "ars" to "ערבית - נג׳ד",
    "arw" to "ארוואק",
    "as" to "אסאמית",
    "asa" to "אסו",
    "ast" to "אסטורית",
    "atj" to "אטיקמק",
    "av" to "אווארית",
    "awa" to "אוואדית",
    "ay" to "איימארית",
    "az" to "אזרית",
    "az-alt-short" to "אזרית",
    "ba" to "בשקירית",
    "bal" to "באלוצ׳י",
    "ban" to "באלינזית",
    "bar" to "בווארית",
    "bas" to "בסאא",
    "bax" to "במום",
    "bbj" to "גומאלה",
    "be" to "בלארוסית",
    "bej" to "בז׳ה",
    "bem" to "במבה",
    "bez" to "בנה",
    "bfd" to "באפוט",
    "bg" to "בולגרית",
    "bgc" to "הריאנבי",
    "bgn" to "באלוצ׳י מערבית",
    "bho" to "בוג׳פורי",
    "bi" to "ביסלמה",
    "bik" to "ביקול",
    "bin" to "ביני",
    "bkm" to "קום",
    "bla" to "סיקסיקה",
    "blo" to "אני",
    "bm" to "במבארה",
    "bn" to "בנגלית",
    "bo" to "טיבטית",
    "br" to "ברטונית",
    "bra" to "בראג׳",
    "brx" to "בודו",
    "bs" to "בוסנית",
    "bss" to "אקוסה",
    "bua" to "בוריאט",
    "bug" to "בוגינזית",
    "bum" to "בולו",
    "byn" to "בלין",
    "byv" to "מדומבה",
    "ca" to "קטלאנית",
    "cad" to "קאדו",
    "car" to "קאריב",
    "cay" to "קאיוגה",
    "cch" to "אטסם",
    "ccp" to "צ׳אקמה",
    "ce" to "צ׳צ׳נית",
    "ceb" to "סבואנו",
    "cgg" to "צ׳יגה",
    "ch" to "צ׳מורו",
    "chb" to "צ׳יבצ׳ה",
    "chg" to "צ׳אגאטאי",
    "chk" to "צ׳וקסה",
    "chm" to "מארי",
    "chn" to "ניב צ׳ינוק",
    "cho" to "צ׳וקטאו",
    "chp" to "צ׳יפוויאן",
    "chr" to "צ׳רוקי",
    "chy" to "שאיין",
    "ckb" to "כורדית סוראנית",
    "ckb-alt-menu" to "כורדית סוראנית",
    "ckb-alt-variant" to "כורדית סוראנית",
    "clc" to "צ׳ילקוטין",
    "co" to "קורסיקנית",
    "cop" to "קופטית",
    "cr" to "קרי",
    "crg" to "מצ׳יף",
    "crh" to "טטרית של קרים",
    "crj" to "קרי דרום מזרחי",
    "crk" to "קרי מישורים",
    "crl" to "קרי צפון מזרחי",
    "crm" to "מוס קרי",
    "crr" to "אלגונקוויאן בקרוליינה",
    "crs" to "קריאולית (סיישל)",
    "cs" to "צ׳כית",
    "csb" to "קשובית",
    "csw" to "קרי של אזור הביצות",
    "cu" to "סלאבית כנסייתית עתיקה",
    "cv" to "צ׳ובאש",
    "cy" to "וולשית",
    "da" to "דנית",
    "dak" to "דקוטה",
    "dar" to "דרגווה",
    "dav" to "טאיטה",
    "de" to "גרמנית",
    "del" to "דלאוור",
    "den" to "סלאבית",
    "dgr" to "דוגריב",
    "din" to "דינקה",
    "dje" to "זארמה",
    "doi" to "דוגרי",
    "dsb" to "סורבית תחתית",
    "dua" to "דואלה",
    "dum" to "הולנדית תיכונה",
    "dv" to "דיבהי",
    "dyo" to "ג׳ולה פונית",
    "dyu" to "דיולה",
    "dz" to "דזונקה",
    "dzg" to "דזאנגה",
    "ebu" to "אמבו",
    "ee" to "אווה",
    "efi" to "אפיק",
    "egy" to "מצרית עתיקה",
    "eka" to "אקיוק",
    "el" to "יוונית",
    "elx" to "עילמית",
    "en" to "אנגלית",
    "enm" to "אנגלית תיכונה",
    "eo" to "אספרנטו",
    "es" to "ספרדית",
    "et" to "אסטונית",
    "eu" to "בסקית",
    "ewo" to "אוונדו",
    "fa" to "פרסית",
    "fa-AF" to "דארי",
    "fan" to "פנג",
    "fat" to "פאנטי",
    "ff" to "פולה",
    "fi" to "פינית",
    "fil" to "פיליפינית",
    "fj" to "פיג׳ית",
    "fo" to "פארואזית",
    "fon" to "פון",
    "fr" to "צרפתית",
    "frc" to "צרפתית קייג׳ונית",
    "frm" to "צרפתית תיכונה",
    "fro" to "צרפתית עתיקה",
    "frr" to "פריזית צפונית",
    "frs" to "פריזית מזרחית",
    "fur" to "פריולית",
    "fy" to "פריזית מערבית",
    "ga" to "אירית",
    "gaa" to "גא",
    "gag" to "גגאוזית",
    "gan" to "סינית גאן",
    "gay" to "גאיו",
    "gba" to "גבאיה",
    "gd" to "גאלית סקוטית",
    "gez" to "געז",
    "gil" to "קיריבטית",
    "gl" to "גליציאנית",
    "gmh" to "גרמנית בינונית-גבוהה",
    "gn" to "גוארני",
    "goh" to "גרמנית עתיקה גבוהה",
    "gon" to "גונדי",
    "gor" to "גורונטאלו",
    "got" to "גותית",
    "grb" to "גרבו",
    "grc" to "יוונית עתיקה",
    "gsw" to "גרמנית שוויצרית",
    "gu" to "גוג׳ארטי",
    "guz" to "גוסי",
    "gv" to "מאנית",
    "gwi" to "גוויצ׳ן",
    "ha" to "האוסה",
    "hai" to "האידה",
    "hak" to "סינית האקה",
    "haw" to "הוואית",
    "hax" to "האידה דרומית",
    "he" to "עברית",
    "hi" to "הינדי",
    "hi-Latn-alt-variant" to "הינגליש",
    "hil" to "היליגאינון",
    "hit" to "חתית",
    "hmn" to "המונג",
    "ho" to "הירי מוטו",
    "hr" to "קרואטית",
    "hsb" to "סורבית עילית",
    "hsn" to "סינית שיאנג",
    "ht" to "קריאולית (האיטי)",
    "hu" to "הונגרית",
    "hup" to "הופה",
    "hur" to "הלקומלם",
    "hy" to "ארמנית",
    "hz" to "הררו",
    "ia" to "‏אינטרלינגואה",
    "iba" to "איבאן",
    "ibb" to "איביביו",
    "id" to "אינדונזית",
    "ie" to "אינטרלינגה",
    "ig" to "איגבו",
    "ii" to "סצ׳ואן יי",
    "ik" to "אינופיאק",
    "ikt" to "אינוקטיטוט במערב קנדה",
    "ilo" to "אילוקו",
    "inh" to "אינגושית",
    "io" to "אידו",
    "is" to "איסלנדית",
    "it" to "איטלקית",
    "iu" to "אינוקטיטוט",
    "ja" to "יפנית",
    "jbo" to "לוז׳באן",
    "jgo" to "נגומבה",
    "jmc" to "מאקאמה",
    "jpr" to "פרסית יהודית",
    "jrb" to "ערבית יהודית",
    "jv" to "יאוואית",
    "ka" to "גאורגית",
    "kaa" to "קארא-קלפאק",
    "kab" to "קבילה",
    "kac" to "קצ׳ין",
    "kaj" to "ג׳ו",
    "kam" to "קמבה",
    "kaw" to "קאווי",
    "kbd" to "קברדית",
    "kbl" to "קנמבו",
    "kcg" to "טיאפ",
    "kde" to "מקונדה",
    "kea" to "קאבוורדיאנו",
    "kfo" to "קורו",
    "kg" to "קונגו",
    "kgp" to "קיינגאנג",
    "kha" to "קהאסי",
    "kho" to "קוטאנזית",
    "khq" to "קוירה צ׳יני",
    "ki" to "קיקויו",
    "kj" to "קואניאמה",
    "kk" to "קזחית",
    "kkj" to "קאקו",
    "kl" to "גרינלנדית",
    "kln" to "קלנג׳ין",
    "km" to "חמרית",
    "kmb" to "קימבונדו",
    "kn" to "קנאדה",
    "ko" to "קוריאנית",
    "koi" to "קומי-פרמיאקית",
    "kok" to "קונקאני",
    "kos" to "קוסראיאן",
    "kpe" to "קפלה",
    "kr" to "קאנורי",
    "krc" to "קראצ׳י-בלקר",
    "krl" to "קארלית",
    "kru" to "קורוק",
    "ks" to "קשמירית",
    "ksb" to "שמבאלה",
    "ksf" to "באפיה",
    "ksh" to "קולוניאן",
    "ku" to "כורדית",
    "kum" to "קומיקית",
    "kut" to "קוטנאי",
    "kv" to "קומי",
    "kw" to "קורנית",
    "kwk" to "קוואקוואלה",
    "kxv" to "קווי",
    "ky" to "קירגיזית",
    "la" to "לטינית",
    "lad" to "לדינו",
    "lag" to "לאנגי",
    "lah" to "לנדה",
    "lam" to "למבה",
    "lb" to "לוקסמבורגית",
    "lez" to "לזגית",
    "lg" to "גאנדה",
    "li" to "לימבורגית",
    "lij" to "ליגורית",
    "lil" to "לילואט",
    "lkt" to "לקוטה",
    "lmo" to "לומברדית",
    "ln" to "לינגלה",
    "lo" to "לאו",
    "lol" to "מונגו",
    "lou" to "קריאולית לואיזיאנית",
    "loz" to "לוזית",
    "lrc" to "לורית צפונית",
    "lsm" to "סמיה",
    "lt" to "ליטאית",
    "lu" to "לובה-קטנגה",
    "lua" to "לובה-לולואה",
    "lui" to "לויסנו",
    "lun" to "לונדה",
    "luo" to "לואו",
    "lus" to "מיזו",
    "luy" to "לויה",
    "lv" to "לטבית",
    "mad" to "מדורזית",
    "maf" to "מאפאה",
    "mag" to "מאגאהית",
    "mai" to "מאיטילית",
    "mak" to "מקסאר",
    "man" to "מנדינגו",
    "mas" to "מסאית",
    "mde" to "מאבא",
    "mdf" to "מוקשה",
    "mdr" to "מנדאר",
    "men" to "מנדה",
    "mer" to "מרו",
    "mfe" to "קריאולית מאוריציאנית",
    "mg" to "מלגשית",
    "mga" to "אירית תיכונה",
    "mgh" to "מאקוואה מטו",
    "mgo" to "מטא",
    "mh" to "מרשלית",
    "mi" to "מאורית",
    "mic" to "מיקמק",
    "min" to "מיננגקבאו",
    "mk" to "מקדונית",
    "ml" to "מליאלאם",
    "mn" to "מונגולית",
    "mnc" to "מנצ׳ו",
    "mni" to "מניפורית",
    "moe" to "אינו-אמון",
    "moh" to "מוהוק",
    "mos" to "מוסי",
    "mr" to "מראטהית",
    "ms" to "מלאית",
    "mt" to "מלטית",
    "mua" to "מונדאנג",
    "mul" to "מספר שפות",
    "mus" to "קריק",
    "mwl" to "מירנדזית",
    "mwr" to "מרווארי",
    "my" to "בורמזית",
    "mye" to "מאיין",
    "myv" to "ארזיה",
    "mzn" to "מאזאנדראני",
    "na" to "נאורית",
    "nan" to "סינית מין נאן",
    "nap" to "נפוליטנית",
    "naq" to "נאמה",
    "nb" to "נורווגית ספרותית",
    "nd" to "נדבלה צפונית",
    "nds" to "גרמנית תחתית",
    "nds-NL" to "סקסונית תחתית",
    "ne" to "נפאלית",
    "new" to "נווארי",
    "ng" to "נדונגה",
    "nia" to "ניאס",
    "niu" to "ניואן",
    "nl" to "הולנדית",
    "nl-BE" to "הולנדית (פלמית)",
    "nmg" to "קוואסיו",
    "nn" to "נורווגית חדשה",
    "nnh" to "נגיאמבון",
    "no" to "נורווגית",
    "nog" to "נוגאי",
    "non" to "‏נורדית עתיקה",
    "nqo" to "נ׳קו",
    "nr" to "נדבלה דרומית",
    "nso" to "סותו צפונית",
    "nus" to "נואר",
    "nv" to "נאוואחו",
    "nwc" to "נווארית קלאסית",
    "ny" to "ניאנג׳ה",
    "nym" to "ניאמווזי",
    "nyn" to "ניאנקולה",
    "nyo" to "ניורו",
    "nzi" to "נזימה",
    "oc" to "אוקסיטנית",
    "oj" to "אוג׳יבווה",
    "ojb" to "אוג׳יבווה צפון מערבית",
    "ojc" to "אוג׳יבווה (מרכז)",
    "ojs" to "אוג׳י-קרי",
    "ojw" to "אוביג׳ווה מערבית",
    "oka" to "אוקאנגן",
    "om" to "אורומו",
    "or" to "אורייה",
    "os" to "אוסטית",
    "osa" to "אוסג׳",
    "ota" to "טורקית עות׳מנית",
    "pa" to "פנג׳אבי",
    "pag" to "פנגסינאן",
    "pal" to "פלאבי",
    "pam" to "פמפאניה",
    "pap" to "פפיאמנטו",
    "pau" to "פלוואן",
    "pcm" to "פידגין ניגרי",
    "peo" to "פרסית עתיקה",
    "phn" to "פיניקית",
    "pi" to "פאלי",
    "pis" to "פייג׳ין",
    "pl" to "פולנית",
    "pon" to "פונפיאן",
    "pqm" to "מליסיט-פאסמקוודי",
    "prg" to "פרוסית",
    "pro" to "פרובנסאל עתיקה",
    "ps" to "פאשטו",
    "ps-alt-variant" to "פושטו",
    "pt" to "פורטוגזית",
    "qu" to "קצ׳ואה",
    "quc" to "קיצ׳ה",
    "raj" to "ראג׳סטאני",
    "rap" to "רפאנוי",
    "rar" to "ררוטונגאן",
    "rhg" to "רוהינגיה",
    "rm" to "רומאנש",
    "rn" to "קירונדי",
    "ro" to "רומנית",
    "ro-MD" to "מולדבית",
    "rof" to "רומבו",
    "rom" to "רומאני",
    "ru" to "רוסית",
    "rup" to "ארומנית",
    "rw" to "קנירואנדית",
    "rwk" to "ראווה",
    "sa" to "סנסקריט",
    "sad" to "סנדאווה",
    "sah" to "סאחה",
    "sam" to "ארמית שומרונית",
    "saq" to "סמבורו",
    "sas" to "סאסק",
    "sat" to "סאנטאלי",
    "sba" to "נגמבאי",
    "sbp" to "סאנגו",
    "sc" to "סרדינית",
    "scn" to "סיציליאנית",
    "sco" to "סקוטית",
    "sd" to "סינדהית",
    "sdh" to "כורדית דרומית",
    "se" to "סמי צפונית",
    "see" to "סנקה",
    "seh" to "סנה",
    "sel" to "סלקופ",
    "ses" to "קויראבורו סני",
    "sg" to "סנגו",
    "sga" to "אירית עתיקה",
    "sh" to "סרבו-קרואטית",
    "shi" to "שילה",
    "shn" to "שאן",
    "shu" to "ערבית צ׳אדית",
    "si" to "סינהלה",
    "sid" to "סידאמו",
    "sk" to "סלובקית",
    "sl" to "סלובנית",
    "slh" to "לשוטסיד",
    "sm" to "סמואית",
    "sma" to "סאמי דרומית",
    "smj" to "לולה סאמי",
    "smn" to "אינארי סאמי",
    "sms" to "סקולט סאמי",
    "sn" to "שונה",
    "snk" to "סונינקה",
    "so" to "סומלית",
    "sog" to "סוגדיאן",
    "sq" to "אלבנית",
    "sr" to "סרבית",
    "srn" to "סרנאן טונגו",
    "srr" to "סרר",
    "ss" to "סאווזי",
    "ssy" to "סאהו",
    "st" to "סותו דרומית",
    "str" to "סאליש מיצרי חואן דה פוקה",
    "su" to "סונדנזית",
    "suk" to "סוקומה",
    "sus" to "סוסו",
    "sux" to "שומרית",
    "sv" to "שוודית",
    "sw" to "סווהילי",
    "sw-CD" to "סווהילי קונגו",
    "swb" to "קומורית",
    "syc" to "סירית קלאסית",
    "syr" to "סורית",
    "szl" to "שלזית",
    "ta" to "טמילית",
    "tce" to "טצ׳ון דרומית",
    "te" to "טלוגו",
    "tem" to "טימנה",
    "teo" to "טסו",
    "ter" to "טרנו",
    "tet" to "טטום",
    "tg" to "טג׳יקית",
    "tgx" to "טגישית",
    "th" to "תאית",
    "tht" to "טלתנית",
    "ti" to "תיגרינית",
    "tig" to "טיגרית",
    "tiv" to "טיב",
    "tk" to "טורקמנית",
    "tkl" to "טוקלאו",
    "tl" to "טאגאלוג",
    "tlh" to "קלינגונית",
    "tli" to "טלינגיט",
    "tmh" to "טמאשק",
    "tn" to "סוואנה",
    "to" to "טונגאית",
    "tog" to "ניאסה טונגה",
    "tok" to "טוקי פונה",
    "tpi" to "טוק פיסין",
    "tr" to "טורקית",
    "trv" to "טרוקו",
    "ts" to "טסונגה",
    "tsi" to "טסימשיאן",
    "tt" to "טטרית",
    "ttm" to "טצ׳ון צפונית",
    "tum" to "טומבוקה",
    "tvl" to "טובאלו",
    "tw" to "טווי",
    "twq" to "טסוואק",
    "ty" to "טהיטית",
    "tyv" to "טובינית",
    "tzm" to "תמאזיגת של מרכז מרוקו",
    "udm" to "אודמורט",
    "ug" to "אויגורית",
    "uga" to "אוגריתית",
    "uk" to "אוקראינית",
    "umb" to "אומבונדו",
    "und" to "שפה לא ידועה",
    "ur" to "אורדו",
    "uz" to "אוזבקית",
    "vai" to "וואי",
    "ve" to "וונדה",
    "vec" to "ונציאנית",
    "vi" to "וייטנאמית",
    "vmw" to "מאקואה",
    "vo" to "‏וולאפיק",
    "vot" to "ווטיק",
    "vun" to "וונג׳ו",
    "wa" to "ולונית",
    "wae" to "וואלסר",
    "wal" to "ווליאטה",
    "war" to "ווראי",
    "was" to "וואשו",
    "wbp" to "וורלפירי",
    "wo" to "וולוף",
    "wuu" to "סינית וו",
    "xal" to "קלמיקית",
    "xh" to "קוסה",
    "xnr" to "קאנגרי",
    "xog" to "סוגה",
    "yao" to "יאו",
    "yap" to "יאפזית",
    "yav" to "יאנגבן",
    "ybb" to "ימבה",
    "yi" to "יידיש",
    "yo" to "יורובה",
    "yrl" to "נינגטו",
    "yue" to "קנטונזית",
    "yue-alt-menu" to "סינית, קנטונזית",
    "za" to "זואנג",
    "zap" to "זאפוטק",
    "zbl" to "בליסימבולס",
    "zen" to "זנאגה",
    "zgh" to "תמזיע׳ת מרוקאית תקנית",
    "zh" to "סינית",
    "zh-alt-menu" to "סינית, מנדרינית",
    "zh-Hans" to "סינית פשוטה",
    "zh-Hans-alt-long" to "סינית מנדרינית פשוטה",
    "zh-Hant" to "סינית מסורתית",
    "zh-Hant-alt-long" to "סינית מנדרינית מסורתית",
    "zu" to "זולו",
    "zun" to "זוני",
    "zxx" to "ללא תוכן לשוני",
    "zza" to "זאזא",
  ) }

  val hi: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "अफ़ार",
    "ab" to "अब्ख़ाज़ियन",
    "ace" to "अचाइनीस",
    "ach" to "अकोली",
    "ada" to "अदान्गमे",
    "ady" to "अदिघे",
    "ae" to "अवस्ताई",
    "af" to "अफ़्रीकी",
    "afh" to "अफ्रिहिली",
    "agq" to "अग्हेम",
    "ain" to "ऐनू",
    "ak" to "अकन",
    "akk" to "अक्कादी",
    "ale" to "अलेउत",
    "alt" to "दक्षिणी अल्ताई",
    "am" to "अम्हेरी",
    "an" to "अरागोनी",
    "ang" to "पुरानी अंग्रेज़ी",
    "ann" to "ओबोलो",
    "anp" to "अंगिका",
    "ar" to "अरबी",
    "ar-001" to "आधुनिक मानक अरबी",
    "arc" to "ऐरेमेक",
    "arn" to "मापूचे",
    "arp" to "अरापाहो",
    "ars" to "नज्दी अरबी",
    "ars-alt-menu" to "अरबी, नज्दी",
    "arw" to "अरावक",
    "as" to "असमिया",
    "asa" to "असु",
    "ast" to "अस्तुरियन",
    "atj" to "अतिकामेक्व",
    "av" to "अवेरिक",
    "awa" to "अवधी",
    "ay" to "आयमारा",
    "az" to "अज़रबैजानी",
    "az-alt-short" to "अज़ेरी",
    "ba" to "बशख़िर",
    "bal" to "बलूची",
    "ban" to "बालिनीस",
    "bas" to "बसा",
    "be" to "बेलारूसी",
    "bej" to "बेजा",
    "bem" to "बेम्बा",
    "bew" to "बेतावी",
    "bez" to "बेना",
    "bg" to "बुल्गारियाई",
    "bgc" to "हरियाणवी",
    "bgn" to "पश्चिमी बलोची",
    "bho" to "भोजपुरी",
    "bi" to "बिस्लामा",
    "bik" to "बिकोल",
    "bin" to "बिनी",
    "bla" to "सिक्सिका",
    "blo" to "अनी",
    "bm" to "बाम्बारा",
    "bn" to "बंगाली",
    "bo" to "तिब्बती",
    "br" to "ब्रेटन",
    "bra" to "ब्रज",
    "brx" to "बोडो",
    "bs" to "बोस्नियाई",
    "bss" to "अकूसे",
    "bua" to "बुरियात",
    "bug" to "बगिनीस",
    "byn" to "ब्लिन",
    "ca" to "कातालान",
    "cad" to "कैड्डो",
    "car" to "कैरिब",
    "cay" to "कायुगा",
    "cch" to "अत्सम",
    "ccp" to "चकमा",
    "ce" to "चेचन",
    "ceb" to "सिबुआनो",
    "cgg" to "शिगा",
    "ch" to "कमोरो",
    "chb" to "चिब्चा",
    "chg" to "छगाताई",
    "chk" to "चूकीस",
    "chm" to "मारी",
    "chn" to "चिनूक जारगॉन",
    "cho" to "चोक्तौ",
    "chp" to "शिपेव्यान",
    "chr" to "चेरोकी",
    "chy" to "शेयेन्न",
    "cic" to "चिकसॉ",
    "ckb" to "सोरानी कुर्दिश",
    "ckb-alt-menu" to "कुर्दी, सोरानी",
    "ckb-alt-variant" to "सोरानी कुर्दिश",
    "clc" to "चिलकोटिन",
    "co" to "कोर्सीकन",
    "cop" to "कॉप्टिक",
    "cr" to "क्री",
    "crg" to "मिचिफ़",
    "crh" to "क्रीमीन तुर्की",
    "crj" to "दक्षिण पूर्वी क्री",
    "crk" to "प्लेन्स क्री",
    "crl" to "नॉर्दन ईस्ट क्री",
    "crm" to "मूस क्री",
    "crr" to "कैरोलाइना एल्गोंक्वीयन",
    "crs" to "सेसेल्वा क्रिओल फ्रेंच",
    "cs" to "चेक",
    "csb" to "काशुबियन",
    "csw" to "स्वॉम्पी क्री",
    "cu" to "चर्च साल्विक",
    "cv" to "चूवाश",
    "cy" to "वेल्श",
    "da" to "डेनिश",
    "dak" to "दाकोता",
    "dar" to "दार्गवा",
    "dav" to "तैता",
    "de" to "जर्मन",
    "de-AT" to "ऑस्ट्रियाई जर्मन",
    "de-CH" to "स्विस उच्च जर्मन",
    "del" to "डिलैवेयर",
    "den" to "स्लेव",
    "dgr" to "डोग्रिब",
    "din" to "दिन्का",
    "dje" to "झार्मा",
    "doi" to "डोगरी",
    "dsb" to "निचला सॉर्बियन",
    "dua" to "दुआला",
    "dum" to "मध्यकालीन पुर्तगाली",
    "dv" to "दिवेही",
    "dyo" to "जोला-फोंई",
    "dyu" to "ड्युला",
    "dz" to "ज़ोन्गखा",
    "dzg" to "दज़ागा",
    "ebu" to "एम्बु",
    "ee" to "ईवे",
    "efi" to "एफिक",
    "egy" to "प्राचीन मिस्री",
    "eka" to "एकाजुक",
    "el" to "यूनानी",
    "elx" to "एलामाइट",
    "en" to "अंग्रेज़ी",
    "en-AU" to "ऑस्ट्रेलियाई अंग्रेज़ी",
    "en-CA" to "कनाडाई अंग्रेज़ी",
    "en-GB" to "ब्रिटिश अंग्रेज़ी",
    "en-GB-alt-short" to "यू॰के॰ अंग्रेज़ी",
    "en-US" to "अमेरिकी अंग्रेज़ी",
    "en-US-alt-short" to "अमेरिकी अंग्रेज़ी",
    "enm" to "मध्यकालीन अंग्रेज़ी",
    "eo" to "एस्पेरेंतो",
    "es" to "स्पेनिश",
    "es-419" to "लैटिन अमेरिकी स्पेनिश",
    "es-ES" to "यूरोपीय स्पेनिश",
    "es-MX" to "मैक्सिकन स्पेनिश",
    "et" to "एस्टोनियाई",
    "eu" to "बास्क",
    "ewo" to "इवोन्डो",
    "fa" to "फ़ारसी",
    "fa-AF" to "दारी",
    "fan" to "फैन्ग",
    "fat" to "फन्टी",
    "ff" to "फुलाह",
    "fi" to "फ़िनिश",
    "fil" to "फ़िलिपीनो",
    "fj" to "फिजियन",
    "fo" to "फ़ैरोइज़",
    "fon" to "फॉन",
    "fr" to "फ़्रेंच",
    "fr-CA" to "कनाडाई फ़्रेंच",
    "fr-CH" to "स्विस फ़्रेंच",
    "frc" to "केजन फ़्रेंच",
    "frm" to "मध्यकालीन फ़्रांसीसी",
    "fro" to "पुरातन फ़्रांसीसी",
    "frr" to "उत्तरी फ़्रीसियाई",
    "frs" to "पूर्वी फ़्रीसियाई",
    "fur" to "फ्रीयुलीयान",
    "fy" to "पश्चिमी फ़्रिसियाई",
    "ga" to "आयरिश",
    "gaa" to "गा",
    "gag" to "गागौज़",
    "gay" to "गायो",
    "gba" to "ग्बाया",
    "gd" to "स्कॉटिश गाएलिक",
    "gez" to "गीज़",
    "gil" to "गिल्बरतीस",
    "gl" to "गैलिशियन",
    "gmh" to "मध्यकालीन हाइ जर्मन",
    "gn" to "गुआरानी",
    "goh" to "पुरातन हाइ जर्मन",
    "gon" to "गाँडी",
    "gor" to "गोरोन्तालो",
    "got" to "गॉथिक",
    "grb" to "ग्रेबो",
    "grc" to "प्राचीन यूनानी",
    "gsw" to "स्विस जर्मन",
    "gu" to "गुजराती",
    "guz" to "गुसी",
    "gv" to "मैंक्स",
    "gwi" to "ग्विचइन",
    "ha" to "हौसा",
    "hai" to "हैडा",
    "haw" to "हवाई",
    "hax" to "दक्षिणी हाइदा",
    "he" to "हिब्रू",
    "hi" to "हिन्दी",
    "hi-Latn-alt-variant" to "हिंग्लिश",
    "hil" to "हिलिगेनन",
    "hit" to "हिताइत",
    "hmn" to "ह्मॉंग",
    "hnj" to "हमोंग नजुआ",
    "ho" to "हिरी मोटू",
    "hr" to "क्रोएशियाई",
    "hsb" to "ऊपरी सॉर्बियन",
    "ht" to "हैतियाई",
    "hu" to "हंगेरियाई",
    "hup" to "हूपा",
    "hur" to "हल्कोमेलम",
    "hy" to "आर्मेनियाई",
    "hz" to "हरैरो",
    "ia" to "इंटरलिंगुआ",
    "iba" to "इबान",
    "ibb" to "इबिबियो",
    "id" to "इंडोनेशियाई",
    "ie" to "ईन्टरलिंगुइ",
    "ig" to "ईग्बो",
    "ii" to "सिचुआन यी",
    "ik" to "इनुपियाक्",
    "ikt" to "पश्चिमी कनाडाई इनुक्टिटुट",
    "ilo" to "इलोको",
    "inh" to "इंगुश",
    "io" to "इडौ",
    "is" to "आइसलैंडिक",
    "it" to "इतालवी",
    "iu" to "इनुक्टिटुट",
    "ja" to "जापानी",
    "jbo" to "लोज्बान",
    "jgo" to "नगोंबा",
    "jmc" to "मैकहैमे",
    "jpr" to "जुदेओ-पर्शियन",
    "jrb" to "जुदेओ-अरेबिक",
    "jv" to "जावानीज़",
    "ka" to "जॉर्जियाई",
    "kaa" to "कारा-कल्पक",
    "kab" to "कबाइल",
    "kac" to "काचिन",
    "kaj" to "ज्जु",
    "kam" to "कम्बा",
    "kaw" to "कावी",
    "kbd" to "कबार्डियन",
    "kcg" to "त्याप",
    "kde" to "मैकोंड",
    "kea" to "काबुवेर्दियानु",
    "kfo" to "कोरो",
    "kg" to "कोंगो",
    "kgp" to "काइंगांग",
    "kha" to "खासी",
    "kho" to "खोतानीस",
    "khq" to "कोयरा चीनी",
    "ki" to "किकुयू",
    "kj" to "क्वान्यामा",
    "kk" to "कज़ाख़",
    "kkj" to "काको",
    "kl" to "कलालीसुत",
    "kln" to "कलेंजिन",
    "km" to "खमेर",
    "kmb" to "किम्बन्दु",
    "kn" to "कन्नड़",
    "ko" to "कोरियाई",
    "koi" to "कोमी-पर्मयाक",
    "kok" to "कोंकणी",
    "kos" to "कोसरैन",
    "kpe" to "क्पेल",
    "kr" to "कनुरी",
    "krc" to "कराचय-बल्कार",
    "krl" to "करेलियन",
    "kru" to "कुरूख",
    "ks" to "कश्मीरी",
    "ksb" to "शम्बाला",
    "ksf" to "बफिआ",
    "ksh" to "कोलोनियाई",
    "ku" to "कुर्दिश",
    "kum" to "कुमीक",
    "kut" to "क्यूतनाई",
    "kv" to "कोमी",
    "kw" to "कोर्निश",
    "kwk" to "क्वॉकवाला",
    "kxv" to "कुवी",
    "ky" to "किर्गीज़",
    "la" to "लैटिन",
    "lad" to "लादीनो",
    "lag" to "लांगि",
    "lah" to "लाह्न्डा",
    "lam" to "लाम्बा",
    "lb" to "लग्ज़मबर्गी",
    "lez" to "लेज़्घीयन",
    "lg" to "गांडा",
    "li" to "लिंबर्गिश",
    "lij" to "लिगुरियन",
    "lil" to "लिलोएट",
    "lkt" to "लैकोटा",
    "lmo" to "लॉमबर्ड",
    "ln" to "लिंगाला",
    "lo" to "लाओ",
    "lol" to "मोंगो",
    "lou" to "लुईज़ियाना क्रियोल",
    "loz" to "लोज़ी",
    "lrc" to "उत्तरी लूरी",
    "lsm" to "सामिया",
    "lt" to "लिथुआनियाई",
    "lu" to "ल्यूबा-कटांगा",
    "lua" to "ल्यूबा-लुलुआ",
    "lui" to "लुइसेनो",
    "lun" to "लुन्डा",
    "luo" to "ल्युओ",
    "lus" to "मिज़ो",
    "luy" to "ल्युईआ",
    "lv" to "लातवियाई",
    "mad" to "मादुरीस",
    "mag" to "मगही",
    "mai" to "मैथिली",
    "mak" to "मकासर",
    "man" to "मन्डिन्गो",
    "mas" to "मसाई",
    "mdf" to "मोक्ष",
    "mdr" to "मंदार",
    "men" to "मेन्डे",
    "mer" to "मेरु",
    "mfe" to "मोरीस्येन",
    "mg" to "मालागासी",
    "mga" to "मध्यकालीन आइरिश",
    "mgh" to "मैखुवा-मीट्टो",
    "mgo" to "मेटा",
    "mh" to "मार्शलीज़",
    "mi" to "माओरी",
    "mic" to "मिकमैक",
    "min" to "मिनांग्काबाउ",
    "mk" to "मकदूनियाई",
    "ml" to "मलयालम",
    "mn" to "मंगोलियाई",
    "mnc" to "मन्चु",
    "mni" to "मणिपुरी",
    "moe" to "इन्नु-एईमन",
    "moh" to "मोहौक",
    "mos" to "मोस्सी",
    "mr" to "मराठी",
    "ms" to "मलय",
    "mt" to "माल्टीज़",
    "mua" to "मुंडैंग",
    "mul" to "एकाधिक भाषाएँ",
    "mus" to "क्रीक",
    "mwl" to "मिरांडी",
    "mwr" to "मारवाड़ी",
    "my" to "बर्मीज़",
    "myv" to "एर्ज़या",
    "mzn" to "माज़न्देरानी",
    "na" to "नाउरू",
    "nan" to "मिन नान",
    "nap" to "नीपोलिटन",
    "naq" to "नामा",
    "nb" to "नॉर्वेजियाई बोकमाल",
    "nd" to "उत्तरी देबेल",
    "nds" to "निचला जर्मन",
    "nds-NL" to "निचली सैक्सन",
    "ne" to "नेपाली",
    "new" to "नेवाड़ी",
    "ng" to "डोन्गा",
    "nia" to "नियास",
    "niu" to "नियुआन",
    "nl" to "डच",
    "nl-BE" to "फ़्लेमिश",
    "nmg" to "क्वासिओ",
    "nn" to "नॉर्वेजियाई नॉयनॉर्स्क",
    "nnh" to "गैम्बू",
    "no" to "नॉर्वेजियाई",
    "nog" to "नोगाई",
    "non" to "पुराना नॉर्स",
    "nqo" to "एन्को",
    "nr" to "दक्षिण देबेल",
    "nso" to "उत्तरी सोथो",
    "nus" to "नुएर",
    "nv" to "नवाहो",
    "nwc" to "पारम्परिक नेवारी",
    "ny" to "न्यानजा",
    "nym" to "न्यामवेज़ी",
    "nyn" to "न्यानकोल",
    "nyo" to "न्योरो",
    "nzi" to "न्ज़ीमा",
    "oc" to "ओसीटान",
    "oj" to "ओजिब्वा",
    "ojb" to "उत्तरपश्चिमी ओजिब्वे",
    "ojc" to "सेंट्रल ओजीब्वे",
    "ojs" to "ओजी-क्री",
    "ojw" to "पश्चिमी ओजिब्वा",
    "oka" to "ओकनागन",
    "om" to "ओरोमो",
    "or" to "ओड़िया",
    "os" to "ओस्सेटिक",
    "osa" to "ओसेज",
    "ota" to "ओटोमान तुर्किश",
    "pa" to "पंजाबी",
    "pag" to "पंगासीनान",
    "pal" to "पाह्लावी",
    "pam" to "पाम्पान्गा",
    "pap" to "पापियामेन्टो",
    "pau" to "पलोउआन",
    "pcm" to "नाइजीरियाई पिडगिन",
    "peo" to "पुरानी फारसी",
    "phn" to "फोएनिशियन",
    "pi" to "पाली",
    "pis" to "पाईजिन",
    "pl" to "पोलिश",
    "pon" to "पोह्नपिएन",
    "pqm" to "मलेसीट-पासेमेक्वोडी",
    "prg" to "प्रुशियाई",
    "pro" to "पुरानी प्रोवेन्सल",
    "ps" to "पश्तो",
    "ps-alt-variant" to "पुश्तो",
    "pt" to "पुर्तगाली",
    "pt-BR" to "ब्राज़ीली पुर्तगाली",
    "pt-PT" to "यूरोपीय पुर्तगाली",
    "qu" to "क्वेचुआ",
    "quc" to "किश",
    "raj" to "राजस्थानी",
    "rap" to "रापानुई",
    "rar" to "रारोतोंगन",
    "rhg" to "रोहिंग्या",
    "rm" to "रोमान्श",
    "rn" to "रुन्दी",
    "ro" to "रोमानियाई",
    "ro-MD" to "मोलडावियन",
    "rof" to "रोम्बो",
    "rom" to "रोमानी",
    "ru" to "रूसी",
    "rup" to "अरोमानियन",
    "rw" to "किन्यारवांडा",
    "rwk" to "रवा",
    "sa" to "संस्कृत",
    "sad" to "सन्डावे",
    "sah" to "याकूत",
    "sam" to "सामैरिटन अरैमिक",
    "saq" to "सैम्बुरु",
    "sas" to "सासाक",
    "sat" to "संथाली",
    "sba" to "न्गाम्बे",
    "sbp" to "सैंगु",
    "sc" to "सार्दिनियन",
    "scn" to "सिसिलियन",
    "sco" to "स्कॉट्स",
    "sd" to "सिंधी",
    "sdh" to "दक्षिणी कार्डिश",
    "se" to "नॉर्दन सामी",
    "seh" to "सेना",
    "sel" to "सेल्कप",
    "ses" to "कोयराबोरो सेन्नी",
    "sg" to "सांगो",
    "sga" to "पुरानी आइरिश",
    "sh" to "सेर्बो-क्रोएशियाई",
    "shi" to "तैचेल्हित",
    "shn" to "शैन",
    "si" to "सिंहली",
    "sid" to "सिदामो",
    "sk" to "स्लोवाक",
    "sl" to "स्लोवेनियाई",
    "slh" to "दक्षिणी लशूटसीड",
    "sm" to "सामोन",
    "sma" to "दक्षिणी सामी",
    "smj" to "ल्युल सामी",
    "smn" to "इनारी सामी",
    "sms" to "स्कोल्ट सामी",
    "sn" to "शोणा",
    "snk" to "सोनिन्के",
    "so" to "सोमाली",
    "sog" to "सोग्डिएन",
    "sq" to "अल्बानियाई",
    "sr" to "सर्बियाई",
    "srn" to "स्रानान टॉन्गो",
    "srr" to "सेरेर",
    "ss" to "स्वाती",
    "ssy" to "साहो",
    "st" to "दक्षिणी सेसेथो",
    "str" to "स्ट्रेट्स सैलिश",
    "su" to "सुंडानी",
    "suk" to "सुकुमा",
    "sus" to "सुसु",
    "sux" to "सुमेरियन",
    "sv" to "स्वीडिश",
    "sw" to "स्वाहिली",
    "sw-CD" to "कांगो स्वाहिली",
    "swb" to "कोमोरियन",
    "syc" to "क्लासिकल सिरिएक",
    "syr" to "सिरिएक",
    "szl" to "सायलिज़ियन",
    "ta" to "तमिल",
    "tce" to "दक्षिणी टशोनी",
    "te" to "तेलुगू",
    "tem" to "टिम्ने",
    "teo" to "टेसो",
    "ter" to "तेरेनो",
    "tet" to "तेतुम",
    "tg" to "ताजिक",
    "tgx" to "टैगिश",
    "th" to "थाई",
    "tht" to "टैल्हटन",
    "ti" to "तिग्रीन्या",
    "tig" to "टाइग्रे",
    "tiv" to "तिव",
    "tk" to "तुर्कमेन",
    "tkl" to "तोकेलाऊ",
    "tl" to "टैगलॉग",
    "tlh" to "क्लिंगन",
    "tli" to "त्लिंगित",
    "tmh" to "तामाशेक",
    "tn" to "सेत्स्वाना",
    "to" to "टोंगन",
    "tog" to "न्यासा टोन्गा",
    "tok" to "टोकी पोना",
    "tpi" to "टोक पिसिन",
    "tr" to "तुर्की",
    "trv" to "तारोको",
    "ts" to "सोंगा",
    "tsi" to "त्सिमीशियन",
    "tt" to "तातार",
    "ttm" to "उत्तरी टुशोनी",
    "tum" to "तम्बूका",
    "tvl" to "तुवालु",
    "tw" to "ट्वी",
    "twq" to "टासवाक",
    "ty" to "ताहितियन",
    "tyv" to "तुवीनियन",
    "tzm" to "मध्य एटलस तमाज़ित",
    "udm" to "उदमुर्त",
    "ug" to "उइगर",
    "uga" to "युगैरिटिक",
    "uk" to "यूक्रेनियाई",
    "umb" to "उम्बुन्डु",
    "und" to "अज्ञात भाषा",
    "ur" to "उर्दू",
    "uz" to "उज़्बेक",
    "vai" to "वाई",
    "ve" to "वेन्दा",
    "vec" to "वनीशन",
    "vi" to "वियतनामी",
    "vmw" to "मखुवा",
    "vo" to "वोलापुक",
    "vot" to "वॉटिक",
    "vun" to "वुंजो",
    "wa" to "वाल्लून",
    "wae" to "वाल्सर",
    "wal" to "वलामो",
    "war" to "वारै",
    "was" to "वाशो",
    "wbp" to "वॉल्पेरी",
    "wo" to "वोलोफ़",
    "wuu" to "वू चीनी",
    "xal" to "काल्मिक",
    "xh" to "ख़ोसा",
    "xnr" to "कांगड़ी",
    "xog" to "सोगा",
    "yao" to "याओ",
    "yap" to "यापीस",
    "yav" to "यांगबेन",
    "ybb" to "येंबा",
    "yi" to "यहूदी",
    "yo" to "योरूबा",
    "yrl" to "नेइंगातू",
    "yue" to "कैंटोनीज़",
    "yue-alt-menu" to "चीनी, कैंटोनीज़",
    "za" to "ज़ुआंग",
    "zap" to "ज़ेपोटेक",
    "zbl" to "ब्लिसिम्बॉल्स",
    "zen" to "ज़ेनान्गा",
    "zgh" to "मानक मोरक्कन तामाज़ाइट",
    "zh" to "चीनी",
    "zh-alt-menu" to "चीनी, मैंडेरिन",
    "zh-Hans" to "सरलीकृत चीनी",
    "zh-Hans-alt-long" to "सरलीकृत मैंडेरिन चीनी",
    "zh-Hant" to "पारंपरिक चीनी",
    "zh-Hant-alt-long" to "पारंपरिक मैंडेरिन चीनी",
    "zu" to "ज़ुलू",
    "zun" to "ज़ूनी",
    "zxx" to "कोई भाषा सामग्री नहीं",
    "zza" to "ज़ाज़ा",
  ) }

  val hi_Latn: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afar",
    "ab" to "Abkhazian",
    "ace" to "Acehnese",
    "ach" to "Acoli",
    "ada" to "Adangme",
    "ady" to "Adyghe",
    "ae" to "Avestan",
    "aeb" to "Tunisian Arabic",
    "af" to "Afreeki",
    "afh" to "Afrihili",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "akk" to "Akkadian",
    "akz" to "Alabama",
    "ale" to "Aleut",
    "aln" to "Gheg Albanian",
    "alt" to "Southern Altai",
    "am" to "Amharic",
    "an" to "Aragonese",
    "ang" to "Old English",
    "ann" to "Obolo",
    "anp" to "Angika",
    "ar" to "Arabic",
    "ar-001" to "Modern Standard Arabic",
    "arc" to "Aramaic",
    "arn" to "Mapuche",
    "aro" to "Araona",
    "arp" to "Arapaho",
    "arq" to "Algerian Arabic",
    "ars" to "Najdi Arabic",
    "ars-alt-menu" to "Arabic, Najdi",
    "arw" to "Arawak",
    "ary" to "Moroccan Arabic",
    "arz" to "Egyptian Arabic",
    "as" to "Assamese",
    "asa" to "Asu",
    "ase" to "American Sign Language",
    "ast" to "Asturian",
    "atj" to "Atikamekw",
    "av" to "Avaric",
    "avk" to "Kotava",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Azerbaijani",
    "az-alt-short" to "Azeri",
    "ba" to "Bashkir",
    "bal" to "Baluchi",
    "ban" to "Balinese",
    "bar" to "Bavarian",
    "bas" to "Basaa",
    "bax" to "Bamun",
    "bbc" to "Batak Toba",
    "bbj" to "Ghomala",
    "be" to "Belarusian",
    "bej" to "Beja",
    "bem" to "Bemba",
    "bew" to "Betawi",
    "bez" to "Bena",
    "bfd" to "Bafut",
    "bfq" to "Badaga",
    "bg" to "Bulgarian",
    "bgc" to "Hariyaanvi",
    "bgn" to "Western Balochi",
    "bho" to "Bhojpuri",
    "bi" to "Bislama",
    "bik" to "Bikol",
    "bin" to "Bini",
    "bjn" to "Banjar",
    "bkm" to "Kom",
    "bla" to "Siksika",
    "blo" to "Anii",
    "blt" to "Tai Dam",
    "bm" to "Bambara",
    "bn" to "Bangla",
    "bo" to "Tibbati",
    "bpy" to "Bishnupriya",
    "bqi" to "Bakhtiari",
    "br" to "Breton",
    "bra" to "Braj",
    "brh" to "Brahui",
    "brx" to "Bodo",
    "bs" to "Bosnian",
    "bss" to "Akoose",
    "bua" to "Buriat",
    "bug" to "Buginese",
    "bum" to "Bulu",
    "byn" to "Blin",
    "byv" to "Medumba",
    "ca" to "Catalan",
    "cad" to "Caddo",
    "car" to "Carib",
    "cay" to "Cayuga",
    "cch" to "Atsam",
    "ccp" to "Chakma",
    "ce" to "Chechen",
    "ceb" to "Cebuano",
    "cgg" to "Chiga",
    "ch" to "Chamorro",
    "chb" to "Chibcha",
    "chg" to "Chagatai",
    "chk" to "Chuukese",
    "chm" to "Mari",
    "chn" to "Chinook Jargon",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyenne",
    "cic" to "Chickasaw",
    "ckb" to "Kurdish, Sorani",
    "ckb-alt-menu" to "Kurdish, Central",
    "ckb-alt-variant" to "Kurdish, Sorani",
    "clc" to "Chilcotin",
    "co" to "Corsican",
    "cop" to "Coptic",
    "cps" to "Capiznon",
    "cr" to "Cree",
    "crg" to "Michif",
    "crh" to "Crimean Turkish",
    "crj" to "Southern East Cree",
    "crk" to "Plains Cree",
    "crl" to "Northern East Cree",
    "crm" to "Moose Cree",
    "crr" to "Carolina Algonquian",
    "crs" to "Seselwa Creole French",
    "cs" to "Czech",
    "csb" to "Kashubian",
    "csw" to "Swampy Cree",
    "cu" to "Church Slavic",
    "cv" to "Chuvash",
    "cwd" to "Woods Cree",
    "cy" to "Welsh",
    "da" to "Danish",
    "dak" to "Dakota",
    "dar" to "Dargwa",
    "dav" to "Taita",
    "de" to "German",
    "de-AT" to "Austrian German",
    "de-CH" to "Swiss High German",
    "del" to "Delaware",
    "den" to "Slave",
    "dgr" to "Dogrib",
    "din" to "Dinka",
    "dje" to "Zarma",
    "doi" to "Dogri",
    "dsb" to "Lower Sorbian",
    "dtp" to "Central Dusun",
    "dua" to "Duala",
    "dum" to "Middle Dutch",
    "dv" to "Divehi",
    "dyo" to "Jola-Fonyi",
    "dyu" to "Dyula",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "egl" to "Emilian",
    "egy" to "Ancient Egyptian",
    "eka" to "Ekajuk",
    "el" to "Greek",
    "elx" to "Elamite",
    "en" to "English",
    "en-AU" to "Australian English",
    "en-CA" to "Canadian English",
    "en-GB" to "British English",
    "en-GB-alt-short" to "UK English",
    "en-US" to "American English",
    "en-US-alt-short" to "US English",
    "enm" to "Middle English",
    "eo" to "Esperanto",
    "es" to "Spanish",
    "es-419" to "Latin American Spanish",
    "es-ES" to "European Spanish",
    "es-MX" to "Mexican Spanish",
    "esu" to "Central Yupik",
    "et" to "Estonian",
    "eu" to "Basque",
    "ewo" to "Ewondo",
    "ext" to "Extremaduran",
    "fa" to "Faarsi",
    "fa-AF" to "Dari",
    "fan" to "Fang",
    "fat" to "Fanti",
    "ff" to "Fulah",
    "fi" to "Finnish",
    "fil" to "Filipino",
    "fit" to "Tornedalen Finnish",
    "fj" to "Fijian",
    "fo" to "Faroese",
    "fon" to "Fon",
    "fr" to "French",
    "fr-CA" to "Canadian French",
    "fr-CH" to "Swiss French",
    "frc" to "Cajun French",
    "frm" to "Middle French",
    "fro" to "Old French",
    "frp" to "Arpitan",
    "frr" to "Northern Frisian",
    "frs" to "Eastern Frisian",
    "fur" to "Friulian",
    "fy" to "Western Frisian",
    "ga" to "Irish",
    "gaa" to "Ga",
    "gag" to "Gagauz",
    "gan" to "Gan Chinese",
    "gay" to "Gayo",
    "gba" to "Gbaya",
    "gbz" to "Zoroastrian Dari",
    "gd" to "Scottish Gaelic",
    "gez" to "Geez",
    "gil" to "Gilbertese",
    "gl" to "Galician",
    "glk" to "Gilaki",
    "gmh" to "Middle High German",
    "gn" to "Guarani",
    "goh" to "Old High German",
    "gon" to "Gondi",
    "gor" to "Gorontalo",
    "got" to "Gothic",
    "grb" to "Grebo",
    "grc" to "Ancient Greek",
    "gsw" to "Swiss German",
    "gu" to "Gujarati",
    "guc" to "Wayuu",
    "gur" to "Frafra",
    "guz" to "Gusii",
    "gv" to "Manx",
    "gwi" to "Gwichʼin",
    "ha" to "Hausa",
    "hai" to "Haida",
    "hak" to "Hakka Chinese",
    "haw" to "Hawaiian",
    "hax" to "Southern Haida",
    "hdn" to "Northern Haida",
    "he" to "Hebrew",
    "hi" to "Hindi",
    "hi-Latn" to "Hindi (Latin)",
    "hi-Latn-alt-variant" to "Hinglish",
    "hif" to "Fiji Hindi",
    "hil" to "Hiligaynon",
    "hit" to "Hittite",
    "hmn" to "Hmong",
    "hnj" to "Hmong Njua",
    "ho" to "Hiri Motu",
    "hr" to "Croatian",
    "hsb" to "Upper Sorbian",
    "hsn" to "Xiang Chinese",
    "ht" to "Haitian Creole",
    "hu" to "Hungarian",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Armenian",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Iban",
    "ibb" to "Ibibio",
    "id" to "Indonesian",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Sichuan Yi",
    "ik" to "Inupiaq",
    "ike" to "Eastern Canadian Inuktitut",
    "ikt" to "Western Canadian Inuktitut",
    "ilo" to "Iloko",
    "inh" to "Ingush",
    "io" to "Ido",
    "is" to "Icelandic",
    "it" to "Italian",
    "iu" to "Inuktitut",
    "izh" to "Ingrian",
    "ja" to "Japanese",
    "jam" to "Jamaican Creole English",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jpr" to "Judeo-Persian",
    "jrb" to "Judeo-Arabic",
    "jut" to "Jutish",
    "jv" to "Javanese",
    "ka" to "Georgian",
    "kaa" to "Kara-Kalpak",
    "kab" to "Kabyle",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kaw" to "Kawi",
    "kbd" to "Kabardian",
    "kbl" to "Kanembu",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kabuverdianu",
    "ken" to "Kenyang",
    "kfo" to "Koro",
    "kg" to "Kongo",
    "kgp" to "Kaingang",
    "kha" to "Khasi",
    "kho" to "Khotanese",
    "khq" to "Koyra Chiini",
    "khw" to "Khowar",
    "ki" to "Kikuyu",
    "kiu" to "Kirmanjki",
    "kj" to "Kuanyama",
    "kk" to "Kazakh",
    "kkj" to "Kako",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Khmer",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Korean",
    "koi" to "Komi-Permyak",
    "kok" to "Konkani",
    "kos" to "Kosraean",
    "kpe" to "Kpelle",
    "kr" to "Kanuri",
    "krc" to "Karachay-Balkar",
    "kri" to "Krio",
    "krj" to "Kinaray-a",
    "krl" to "Karelian",
    "kru" to "Kurukh",
    "ks" to "Kashmiri",
    "ksb" to "Shambala",
    "ksf" to "Bafia",
    "ksh" to "Colognian",
    "ku" to "Kurdish",
    "kum" to "Kumyk",
    "kut" to "Kutenai",
    "kv" to "Komi",
    "kw" to "Cornish",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kuvi",
    "ky" to "Kyrgyz",
    "ky-alt-variant" to "Kirghiz",
    "la" to "Latin",
    "lad" to "Ladino",
    "lag" to "Langi",
    "lah" to "Lahnda",
    "lam" to "Lamba",
    "lb" to "Luxembourgish",
    "lez" to "Lezghian",
    "lfn" to "Lingua Franca Nova",
    "lg" to "Ganda",
    "li" to "Limburgish",
    "lij" to "Ligurian",
    "lil" to "Lillooet",
    "liv" to "Livonian",
    "lkt" to "Lakota",
    "lmo" to "Lombard",
    "ln" to "Lingala",
    "lo" to "Lao",
    "lol" to "Mongo",
    "lou" to "Louisiana Creole",
    "loz" to "Lozi",
    "lrc" to "Northern Luri",
    "lsm" to "Saamia",
    "lt" to "Lithuanian",
    "ltg" to "Latgalian",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lui" to "Luiseno",
    "lun" to "Lunda",
    "luo" to "Luo",
    "lus" to "Mizo",
    "luy" to "Luyia",
    "lv" to "Latvian",
    "lzh" to "Literary Chinese",
    "lzz" to "Laz",
    "mad" to "Madurese",
    "maf" to "Mafa",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Makasar",
    "man" to "Mandingo",
    "mas" to "Masai",
    "mde" to "Maba",
    "mdf" to "Moksha",
    "mdr" to "Mandar",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisyen",
    "mg" to "Malagasy",
    "mga" to "Middle Irish",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Metaʼ",
    "mh" to "Marshallese",
    "mi" to "Māori",
    "mic" to "Mi'kmaq",
    "min" to "Minangkabau",
    "mk" to "Macedonian",
    "ml" to "Malayalam",
    "mn" to "Mongolian",
    "mnc" to "Manchu",
    "mni" to "Manipuri",
    "moe" to "Innu-aimun",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Marathi",
    "mrj" to "Western Mari",
    "ms" to "Malay",
    "mt" to "Maltese",
    "mua" to "Mundang",
    "mul" to "Multiple languages",
    "mus" to "Muscogee",
    "mus-alt-official" to "Mvskoke",
    "mwl" to "Mirandese",
    "mwr" to "Marwari",
    "mwv" to "Mentawai",
    "my" to "Burmese",
    "my-alt-variant" to "Myanmar Language",
    "mye" to "Myene",
    "myv" to "Erzya",
    "mzn" to "Mazanderani",
    "na" to "Nauru",
    "nan" to "Min Nan",
    "nap" to "Neapolitan",
    "naq" to "Nama",
    "nb" to "Norwegian Bokmal",
    "nd" to "North Ndebele",
    "nds" to "Low German",
    "nds-NL" to "Low Saxon",
    "ne" to "Nepali",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niuean",
    "njo" to "Ao Naga",
    "nl" to "Dutch",
    "nl-BE" to "Flemish",
    "nmg" to "Kwasio",
    "nn" to "Norwegian Nynorsk",
    "nnh" to "Ngiemboon",
    "no" to "Norwegian",
    "nog" to "Nogai",
    "non" to "Old Norse",
    "nov" to "Novial",
    "nqo" to "N’Ko",
    "nr" to "South Ndebele",
    "nso" to "Northern Sotho",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "nwc" to "Classical Newari",
    "ny" to "Nyanja",
    "nym" to "Nyamwezi",
    "nyn" to "Nyankole",
    "nyo" to "Nyoro",
    "nzi" to "Nzima",
    "oc" to "Occitan",
    "oj" to "Ojibwa",
    "ojb" to "Northwestern Ojibwa",
    "ojc" to "Central Ojibwa",
    "ojg" to "Eastern Ojibwa",
    "ojs" to "Oji-Cree",
    "ojw" to "Western Ojibwa",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Odia",
    "os" to "Ossetic",
    "osa" to "Osage",
    "ota" to "Ottoman Turkish",
    "pa" to "Punjabi",
    "pag" to "Pangasinan",
    "pal" to "Pahlavi",
    "pam" to "Pampanga",
    "pap" to "Papiamento",
    "pau" to "Palauan",
    "pcd" to "Picard",
    "pcm" to "Nigerian Pidgin",
    "pdc" to "Pennsylvania German",
    "pdt" to "Plautdietsch",
    "peo" to "Old Persian",
    "pfl" to "Palatine German",
    "phn" to "Phoenician",
    "pi" to "Pali",
    "pis" to "Pijin",
    "pl" to "Polish",
    "pms" to "Piedmontese",
    "pnt" to "Pontic",
    "pon" to "Pohnpeian",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Prussian",
    "pro" to "Old Provençal",
    "ps" to "Pashto",
    "ps-alt-variant" to "Pushto",
    "pt" to "Portuguese",
    "pt-BR" to "Brazilian Portuguese",
    "pt-PT" to "European Portuguese",
    "qu" to "Quechua",
    "quc" to "Kʼicheʼ",
    "qug" to "Chimborazo Highland Quichua",
    "raj" to "Rajasthani",
    "rap" to "Rapanui",
    "rar" to "Rarotongan",
    "rgn" to "Romagnol",
    "rhg" to "Rohingya",
    "rif" to "Riffian",
    "rm" to "Romansh",
    "rn" to "Rundi",
    "ro" to "Romanian",
    "ro-MD" to "Moldavian",
    "rof" to "Rombo",
    "rom" to "Romany",
    "rtm" to "Rotuman",
    "ru" to "Russian",
    "rue" to "Rusyn",
    "rug" to "Roviana",
    "rup" to "Aromanian",
    "rw" to "Kinyarwanda",
    "rwk" to "Rwa",
    "sa" to "Sanskrit",
    "sad" to "Sandawe",
    "sah" to "Yakut",
    "sam" to "Samaritan Aramaic",
    "saq" to "Samburu",
    "sas" to "Sasak",
    "sat" to "Santali",
    "saz" to "Saurashtra",
    "sba" to "Ngambay",
    "sbp" to "Sangu",
    "sc" to "Sardinian",
    "scn" to "Sicilian",
    "sco" to "Scots",
    "sd" to "Sindhi",
    "sdc" to "Sassarese Sardinian",
    "sdh" to "Southern Kurdish",
    "se" to "Northern Sami",
    "se-alt-menu" to "Sami, Northern",
    "see" to "Seneca",
    "seh" to "Sena",
    "sei" to "Seri",
    "sel" to "Selkup",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "sga" to "Old Irish",
    "sgs" to "Samogitian",
    "sh" to "Serbo-Croatian",
    "shi" to "Tachelhit",
    "shn" to "Shan",
    "shu" to "Chadian Arabic",
    "si" to "Sinhala",
    "sid" to "Sidamo",
    "sk" to "Slovak",
    "sl" to "Slovenian",
    "slh" to "Southern Lushootseed",
    "sli" to "Lower Silesian",
    "sly" to "Selayar",
    "sm" to "Samoan",
    "sma" to "Southern Sami",
    "sma-alt-menu" to "Sami, Southern",
    "smj" to "Lule Sami",
    "smj-alt-menu" to "Sami, Lule",
    "smn" to "Inari Sami",
    "smn-alt-menu" to "Sami, Inari",
    "sms" to "Skolt Sami",
    "sms-alt-menu" to "Sami, Skolt",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somali",
    "sog" to "Sogdien",
    "sq" to "Albanian",
    "sr" to "Serbian",
    "sr-ME" to "Montenegrin",
    "srn" to "Sranan Tongo",
    "srr" to "Serer",
    "ss" to "Swati",
    "ssy" to "Saho",
    "st" to "Southern Sotho",
    "stq" to "Saterland Frisian",
    "str" to "Straits Salish",
    "su" to "Sundanese",
    "suk" to "Sukuma",
    "sus" to "Susu",
    "sux" to "Sumerian",
    "sv" to "Swedish",
    "sw" to "Swahili",
    "sw-CD" to "Congo Swahili",
    "swb" to "Comorian",
    "syc" to "Classical Syriac",
    "syr" to "Syriac",
    "szl" to "Silesian",
    "ta" to "Tamil",
    "tce" to "Southern Tutchone",
    "tcy" to "Tulu",
    "te" to "Telugu",
    "tem" to "Timne",
    "teo" to "Teso",
    "ter" to "Tereno",
    "tet" to "Tetum",
    "tg" to "Tajik",
    "tgx" to "Tagish",
    "th" to "Thai",
    "tht" to "Tahltan",
    "ti" to "Tigrinya",
    "tig" to "Tigre",
    "tiv" to "Tiv",
    "tk" to "Turkmen",
    "tkl" to "Tokelau",
    "tkr" to "Tsakhur",
    "tl" to "Tagalog",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tly" to "Talysh",
    "tmh" to "Tamashek",
    "tn" to "Tswana",
    "to" to "Tongan",
    "tog" to "Nyasa Tonga",
    "tok" to "Toki Pona",
    "tpi" to "Tok Pisin",
    "tr" to "Turkish",
    "tru" to "Turoyo",
    "trv" to "Taroko",
    "trw" to "Torwali",
    "ts" to "Tsonga",
    "tsd" to "Tsakonian",
    "tsi" to "Tsimshian",
    "tt" to "Tatar",
    "ttm" to "Northern Tutchone",
    "ttt" to "Muslim Tat",
    "tum" to "Tumbuka",
    "tvl" to "Tuvalu",
    "tw" to "Twi",
    "twq" to "Tasawaq",
    "ty" to "Tahitian",
    "tyv" to "Tuvinian",
    "tzm" to "Central Atlas Tamazight",
    "udm" to "Udmurt",
    "ug" to "Uighur",
    "ug-alt-variant" to "Uighur",
    "uga" to "Ugaritic",
    "uk" to "Ukrainian",
    "umb" to "Umbundu",
    "und" to "Unknown language",
    "ur" to "Urdu",
    "uz" to "Uzbek",
    "vai" to "Vai",
    "ve" to "Venda",
    "vec" to "Venetian",
    "vep" to "Veps",
    "vi" to "Vietnamese",
    "vls" to "West Flemish",
    "vmf" to "Main-Franconian",
    "vmw" to "Makhuwa",
    "vo" to "Volapük",
    "vot" to "Votic",
    "vro" to "Võro",
    "vun" to "Vunjo",
    "wa" to "Walloon",
    "wae" to "Walser",
    "wal" to "walamo",
    "war" to "Waray",
    "was" to "Washo",
    "wbp" to "Warlpiri",
    "wo" to "Wolof",
    "wuu" to "Wu Chinese",
    "xal" to "Kalmyk",
    "xh" to "Xhosa",
    "xmf" to "Mingrelian",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yao" to "Yao",
    "yap" to "Yapese",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Yiddish",
    "yo" to "Yoruba",
    "yrl" to "Nheengatu",
    "yue" to "Cantonese",
    "yue-alt-menu" to "Chinese, Cantonese",
    "za" to "Zhuang",
    "zap" to "Zapotec",
    "zbl" to "Blissymbols",
    "zea" to "Zeelandic",
    "zen" to "Zenaga",
    "zgh" to "Standard Moroccan Tamazight",
    "zh" to "Chinese",
    "zh-alt-long" to "Mandarin Chinese",
    "zh-alt-menu" to "Chinese, Mandarin",
    "zh-Hans" to "Simplified Chinese",
    "zh-Hans-alt-long" to "Simplified Mandarin Chinese",
    "zh-Hant" to "Traditional Chinese",
    "zh-Hant-alt-long" to "Traditional Mandarin Chinese",
    "zu" to "Zulu",
    "zun" to "Zuni",
    "zxx" to "No linguistic content",
    "zza" to "Zaza",
  ) }

  val hnj: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar" to "𞄤𞄣",
    "bn" to "𞄜𞄤",
    "en" to "𞄥𞄴𞄅𞄇𞄉𞄦𞄱𞄊",
    "fr" to "𞄕𞄤𞄰𞄎𞄦𞄴",
    "hmn" to "𞄀𞄄𞄰𞄩",
    "hnj" to "𞄀𞄄𞄰𞄩𞄍𞄜𞄰",
    "zh" to "𞄋𞄄",
    "zh-alt-menu" to "𞄋𞄄",
  ) }

  val hnj_Hmnp: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar" to "𞄤𞄣",
    "bn" to "𞄜𞄤",
    "en" to "𞄥𞄴𞄅𞄇𞄉𞄦𞄱𞄊",
    "fr" to "𞄕𞄤𞄰𞄎𞄦𞄴",
    "hmn" to "𞄀𞄄𞄰𞄩",
    "hnj" to "𞄀𞄄𞄰𞄩𞄍𞄜𞄰",
    "zh" to "𞄋𞄄",
    "zh-alt-menu" to "𞄋𞄄",
  ) }

  val hr: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afarski",
    "ab" to "abhaski",
    "ace" to "ačinski",
    "ach" to "ačoli",
    "ada" to "adangme",
    "ady" to "adigejski",
    "ae" to "avestički",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainuski",
    "ak" to "akanski",
    "akk" to "akadski",
    "ale" to "aleutski",
    "alt" to "južni altai",
    "am" to "amharski",
    "an" to "aragonski",
    "ang" to "staroengleski",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "arapski",
    "ar-001" to "moderni standardni arapski",
    "arc" to "aramejski",
    "arn" to "mapuche",
    "arp" to "arapaho",
    "ars" to "najdi arapski",
    "ars-alt-menu" to "arapski, najdi",
    "arw" to "aravački",
    "as" to "asamski",
    "asa" to "asu",
    "ast" to "asturijski",
    "atj" to "atikamekw",
    "av" to "avarski",
    "awa" to "awadhi",
    "ay" to "ajmarski",
    "az" to "azerbajdžanski",
    "az-alt-short" to "azerski",
    "az-Arab" to "južnoazerbajdžanski",
    "ba" to "baškirski",
    "bal" to "belučki",
    "ban" to "balijski",
    "bas" to "basa",
    "bax" to "bamunski",
    "bbj" to "ghomala",
    "be" to "bjeloruski",
    "bej" to "beja",
    "bem" to "bemba",
    "bez" to "bena",
    "bfd" to "bafut",
    "bg" to "bugarski",
    "bgc" to "haryanvi",
    "bgn" to "zapadnobaludžijski",
    "bho" to "bhojpuri",
    "bi" to "bislama",
    "bik" to "bikolski",
    "bin" to "bini",
    "bkm" to "kom",
    "bla" to "siksika",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bangla",
    "bo" to "tibetski",
    "br" to "bretonski",
    "bra" to "braj",
    "brx" to "bodo",
    "bs" to "bosanski",
    "bss" to "akoose",
    "bua" to "burjatski",
    "bug" to "buginski",
    "bum" to "bulu",
    "byn" to "blin",
    "byv" to "medumba",
    "ca" to "katalonski",
    "cad" to "caddo",
    "car" to "karipski",
    "cay" to "cayuga",
    "cch" to "atsam",
    "ccp" to "chakma",
    "ce" to "čečenski",
    "ceb" to "cebuano",
    "cgg" to "chiga",
    "ch" to "chamorro",
    "chb" to "čibča",
    "chg" to "čagatajski",
    "chk" to "chuukese",
    "chm" to "marijski",
    "chn" to "chinook žargon",
    "cho" to "choctaw",
    "chp" to "chipewyan",
    "chr" to "čerokijski",
    "chy" to "čejenski",
    "ckb" to "soranski kurdski",
    "ckb-alt-menu" to "kurdski, sorani",
    "ckb-alt-variant" to "kurdski, soranski",
    "clc" to "chilcotin",
    "co" to "korzički",
    "cop" to "koptski",
    "cr" to "cree",
    "crg" to "michif",
    "crh" to "krimski turski",
    "crj" to "jugoistični cree",
    "crk" to "plains cree",
    "crl" to "sjevernoistočni cree",
    "crm" to "moose cree",
    "crr" to "karolinski algonkijski",
    "crs" to "sejšelski kreolski",
    "cs" to "češki",
    "csb" to "kašupski",
    "csw" to "močvarni cree",
    "cu" to "crkvenoslavenski",
    "cv" to "čuvaški",
    "cy" to "velški",
    "da" to "danski",
    "dak" to "dakota jezik",
    "dar" to "dargwa",
    "dav" to "taita",
    "de" to "njemački",
    "de-AT" to "austrijski njemački",
    "de-CH" to "gornjonjemački (švicarski)",
    "del" to "delavarski",
    "den" to "slave",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "donjolužički",
    "dua" to "duala",
    "dum" to "srednjonizozemski",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dyu" to "dyula",
    "dz" to "dzongkha",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efik",
    "egy" to "staroegipatski",
    "eka" to "ekajuk",
    "el" to "grčki",
    "elx" to "elamitski",
    "en" to "engleski",
    "en-AU" to "australski engleski",
    "en-CA" to "kanadski engleski",
    "en-GB" to "britanski engleski",
    "en-GB-alt-short" to "engleski (UK)",
    "en-US" to "američki engleski",
    "en-US-alt-short" to "engleski (SAD)",
    "enm" to "srednjoengleski",
    "eo" to "esperanto",
    "es" to "španjolski",
    "es-419" to "latinoamerički španjolski",
    "es-ES" to "europski španjolski",
    "es-MX" to "meksički španjolski",
    "et" to "estonski",
    "eu" to "baskijski",
    "ewo" to "ewondo",
    "fa" to "perzijski",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fula",
    "fi" to "finski",
    "fil" to "filipinski",
    "fj" to "fidžijski",
    "fo" to "ferojski",
    "fon" to "fon",
    "fr" to "francuski",
    "fr-CA" to "kanadski francuski",
    "fr-CH" to "švicarski francuski",
    "frc" to "kajunski francuski",
    "frm" to "srednjofrancuski",
    "fro" to "starofrancuski",
    "frr" to "sjevernofrizijski",
    "frs" to "istočnofrizijski",
    "fur" to "furlanski",
    "fy" to "zapadnofrizijski",
    "ga" to "irski",
    "gaa" to "ga",
    "gag" to "gagauski",
    "gan" to "gan kineski",
    "gay" to "gayo",
    "gba" to "gbaya",
    "gd" to "škotski gaelski",
    "gez" to "geez",
    "gil" to "gilbertski",
    "gl" to "galicijski",
    "gmh" to "srednjogornjonjemački",
    "gn" to "gvaranski",
    "goh" to "starovisokonjemački",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gotski",
    "grb" to "grebo",
    "grc" to "starogrčki",
    "gsw" to "švicarski njemački",
    "gu" to "gudžaratski",
    "guz" to "gusii",
    "gv" to "manski",
    "gwi" to "gwich’in",
    "ha" to "hausa",
    "hai" to "haidi",
    "hak" to "hakka kineski",
    "haw" to "havajski",
    "hax" to "južni haida",
    "he" to "hebrejski",
    "hi" to "hindski",
    "hi-Latn-alt-variant" to "hinglish",
    "hil" to "hiligaynonski",
    "hit" to "hetitski",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "hrvatski",
    "hsb" to "gornjolužički",
    "hsn" to "xiang kineski",
    "ht" to "haićanski kreolski",
    "hu" to "mađarski",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armenski",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonezijski",
    "ie" to "interligua",
    "ig" to "igbo",
    "ii" to "sichuan ji",
    "ik" to "inupiaq",
    "ikt" to "zapadnokanadski inuktitut",
    "ilo" to "iloko",
    "inh" to "ingušetski",
    "io" to "ido",
    "is" to "islandski",
    "it" to "talijanski",
    "iu" to "inuktitut",
    "ja" to "japanski",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jpr" to "judejsko-perzijski",
    "jrb" to "judejsko-arapski",
    "jv" to "javanski",
    "ka" to "gruzijski",
    "kaa" to "kara-kalpak",
    "kab" to "kabilski",
    "kac" to "kačinski",
    "kaj" to "kaje",
    "kam" to "kamba",
    "kaw" to "kawi",
    "kbd" to "kabardinski",
    "kbl" to "kanembu",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "zelenortski",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "kaingang",
    "kha" to "khasi",
    "kho" to "khotanese",
    "khq" to "koyra chiini",
    "ki" to "kikuyu",
    "kj" to "kuanyama",
    "kk" to "kazaški",
    "kkj" to "kako",
    "kl" to "kalaallisut",
    "kln" to "kalenjin",
    "km" to "kmerski",
    "kmb" to "kimbundu",
    "kn" to "karnatački",
    "ko" to "korejski",
    "koi" to "komi-permski",
    "kok" to "konkani",
    "kos" to "naurski",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karachay-balkar",
    "krl" to "karelijski",
    "kru" to "kuruški",
    "ks" to "kašmirski",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "kelnski",
    "ku" to "kurdski",
    "kum" to "kumyk",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "kornski",
    "kwk" to "kwakʼwala",
    "kxv" to "kuvi",
    "ky" to "kirgiski",
    "la" to "latinski",
    "lad" to "ladino",
    "lag" to "langi",
    "lah" to "lahnda",
    "lam" to "lamba",
    "lb" to "luksemburški",
    "lez" to "lezgiški",
    "lg" to "ganda",
    "li" to "limburški",
    "lij" to "ligurski",
    "lil" to "lillooet",
    "lkt" to "lakota",
    "lmo" to "lombardski",
    "ln" to "lingala",
    "lo" to "laoski",
    "lol" to "mongo",
    "lou" to "lujzijanski kreolski",
    "loz" to "lozi",
    "lrc" to "sjevernolurski",
    "lsm" to "saamia",
    "lt" to "litavski",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lui" to "luiseno",
    "lun" to "lunda",
    "lus" to "lushai",
    "luy" to "luyia",
    "lv" to "latvijski",
    "mad" to "madurski",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makasar",
    "man" to "mandingo",
    "mas" to "masajski",
    "mde" to "maba",
    "mdf" to "moksha",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "mauricijski kreolski",
    "mg" to "malgaški",
    "mga" to "srednjoirski",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta’",
    "mh" to "maršalski",
    "mi" to "maorski",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "makedonski",
    "ml" to "malajalamski",
    "mn" to "mongolski",
    "mnc" to "mandžurski",
    "mni" to "manipurski",
    "moe" to "innu-aimun",
    "moh" to "mohok",
    "mos" to "mossi",
    "mr" to "marathski",
    "ms" to "malajski",
    "mt" to "malteški",
    "mua" to "mundang",
    "mul" to "više jezika",
    "mus" to "creek",
    "mwl" to "mirandski",
    "mwr" to "marwari",
    "my" to "burmanski",
    "mye" to "myene",
    "myv" to "mordvinski",
    "mzn" to "mazanderanski",
    "na" to "nauru",
    "nan" to "min nan kineski",
    "nap" to "napolitanski",
    "naq" to "nama",
    "nb" to "norveški bokmål",
    "nd" to "sjeverni ndebele",
    "nds" to "donjonjemački",
    "nds-NL" to "donjosaksonski",
    "ne" to "nepalski",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niujski",
    "nl" to "nizozemski",
    "nl-BE" to "flamanski",
    "nmg" to "kwasio",
    "nn" to "norveški nynorsk",
    "nnh" to "ngiemboon",
    "no" to "norveški",
    "nog" to "nogajski",
    "non" to "staronorveški",
    "nqo" to "n’ko",
    "nr" to "južni ndebele",
    "nso" to "sjeverni sotski",
    "nus" to "nuerski",
    "nv" to "navajo",
    "nwc" to "klasični newari",
    "ny" to "njandža",
    "nym" to "nyamwezi",
    "nyn" to "nyankole",
    "nyo" to "nyoro",
    "nzi" to "nzima",
    "oc" to "okcitanski",
    "oj" to "ojibwa",
    "ojb" to "sjeverozapadni ojibwa",
    "ojc" to "centralni ojibwa",
    "ojs" to "oji-cree",
    "ojw" to "zapadni ojibwa",
    "oka" to "okanagan",
    "om" to "oromski",
    "or" to "orijski",
    "os" to "osetski",
    "osa" to "osage",
    "ota" to "turski - otomanski",
    "pa" to "pandžapski",
    "pag" to "pangasinan",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palauanski",
    "pcm" to "nigerijski pidžin",
    "peo" to "staroperzijski",
    "phn" to "fenički",
    "pi" to "pali",
    "pis" to "pijin",
    "pl" to "poljski",
    "pon" to "pohnpeian",
    "pqm" to "maliseet-Passamaquoddy",
    "prg" to "pruski",
    "pro" to "staroprovansalski",
    "ps" to "paštunski",
    "ps-alt-variant" to "puštu",
    "pt" to "portugalski",
    "pt-BR" to "brazilski portugalski",
    "pt-PT" to "europski portugalski",
    "qu" to "kečuanski",
    "quc" to "kiče",
    "raj" to "rajasthani",
    "rap" to "rapa nui",
    "rar" to "rarotonški",
    "rhg" to "rohindža",
    "rm" to "retoromanski",
    "rn" to "rundi",
    "ro" to "rumunjski",
    "ro-MD" to "moldavski",
    "rof" to "rombo",
    "rom" to "romski",
    "ru" to "ruski",
    "rup" to "aromunski",
    "rw" to "kinyarwanda",
    "rwk" to "rwa",
    "sa" to "sanskrtski",
    "sad" to "sandawe",
    "sah" to "jakutski",
    "sam" to "samarijanski aramejski",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santalski",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sardski",
    "scn" to "sicilijski",
    "sco" to "škotski",
    "sd" to "sindski",
    "sdh" to "južnokurdski",
    "se" to "sjeverni sami",
    "see" to "seneca",
    "seh" to "sena",
    "sel" to "selkupski",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sga" to "staroirski",
    "sh" to "srpsko-hrvatski",
    "shi" to "tachelhit",
    "shn" to "shan",
    "shu" to "čadski arapski",
    "si" to "sinhaleški",
    "sid" to "sidamo",
    "sk" to "slovački",
    "sl" to "slovenski",
    "slh" to "južni lushootseed",
    "sm" to "samoanski",
    "sma" to "južni sami",
    "smj" to "lule sami",
    "smn" to "inari sami",
    "sms" to "skolt sami",
    "sn" to "shona",
    "snk" to "soninke",
    "so" to "somalski",
    "sog" to "sogdien",
    "sq" to "albanski",
    "sr" to "srpski",
    "srn" to "sranan tongo",
    "srr" to "serer",
    "ss" to "svati",
    "ssy" to "saho",
    "st" to "sesotski",
    "str" to "sjeverni sališki",
    "su" to "sundanski",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumerski",
    "sv" to "švedski",
    "sw" to "svahili",
    "sw-CD" to "kongoanski svahili",
    "swb" to "komorski",
    "syc" to "klasični sirski",
    "syr" to "sirijski",
    "szl" to "šleski",
    "ta" to "tamilski",
    "tce" to "južni tutchone",
    "te" to "teluški",
    "tem" to "temne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetum",
    "tg" to "tadžički",
    "tgx" to "tagish",
    "th" to "tajlandski",
    "tht" to "tahltan",
    "ti" to "tigrinja",
    "tig" to "tigriški",
    "tiv" to "tiv",
    "tk" to "turkmenski",
    "tkl" to "tokelaunski",
    "tl" to "tagalog",
    "tlh" to "klingonski",
    "tli" to "tlingit",
    "tmh" to "tamašečki",
    "tn" to "cvana",
    "to" to "tonganski",
    "tog" to "nyasa tonga",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turski",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsi" to "tsimshian",
    "tt" to "tatarski",
    "ttm" to "sjeverni tutchone",
    "tum" to "tumbuka",
    "tvl" to "tuvaluanski",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahićanski",
    "tyv" to "tuvinski",
    "tzm" to "tamašek (Srednji Atlas)",
    "udm" to "udmurtski",
    "ug" to "ujgurski",
    "uga" to "ugaritski",
    "uk" to "ukrajinski",
    "umb" to "umbundu",
    "und" to "nepoznati jezik",
    "ur" to "urdski",
    "uz" to "uzbečki",
    "ve" to "venda",
    "vec" to "venecijanski",
    "vi" to "vijetnamski",
    "vmw" to "makhuwa",
    "vo" to "volapük",
    "vot" to "votski",
    "vun" to "vunjo",
    "wa" to "valonski",
    "wae" to "walserski",
    "wal" to "walamo",
    "war" to "waray",
    "was" to "washo",
    "wbp" to "warlpiri",
    "wo" to "volof",
    "wuu" to "wu kineski",
    "xal" to "kalmyk",
    "xh" to "xhosa",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "yao",
    "yap" to "japski",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "jidiš",
    "yo" to "jorupski",
    "yrl" to "nheengatu",
    "yue" to "kantonski",
    "yue-alt-menu" to "kineski, kantonski",
    "za" to "zhuang",
    "zap" to "zapotečki",
    "zbl" to "Blissovi simboli",
    "zen" to "zenaga",
    "zgh" to "standardni marokanski tamašek",
    "zh" to "kineski",
    "zh-alt-menu" to "kineski, mandarinski",
    "zh-Hans" to "kineski (pojednostavljeni)",
    "zh-Hans-alt-long" to "mandarinski kineski (pojednostavljeni)",
    "zh-Hant" to "kineski (tradicionalni)",
    "zh-Hant-alt-long" to "mandarinski kineski (tradicionalni)",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "bez jezičnog sadržaja",
    "zza" to "zazaki",
  ) }

  val hr_BA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val hsb: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afaršćina",
    "ab" to "abchazišćina",
    "ace" to "achinezišćina",
    "ada" to "adangmešćina",
    "ady" to "adyghešćina",
    "af" to "afrikaanšćina",
    "agq" to "aghemšćina",
    "ain" to "ainušćina",
    "ak" to "akanšćina",
    "ale" to "aleutišćina",
    "alt" to "južna altaišćina",
    "am" to "amharšćina",
    "an" to "aragonšćina",
    "ang" to "anglosakšćina",
    "ann" to "obološćina",
    "anp" to "angikašćina",
    "ar" to "arabšćina",
    "ar-001" to "moderna wysokoarabšćina",
    "arn" to "arawkanšćina",
    "arp" to "arapahošćina",
    "ars" to "najdi arabšćina",
    "as" to "asamšćina",
    "asa" to "pare",
    "ast" to "asturšćina",
    "atj" to "atikamekwišćina",
    "av" to "awaršćina",
    "awa" to "awandhišćina",
    "ay" to "aymaršćina",
    "az" to "azerbajdźanšćina",
    "az-alt-short" to "azerbajdźanšćina",
    "ba" to "baškiršćina",
    "ban" to "balinezišćina",
    "bas" to "basaa",
    "be" to "běłorušćina",
    "bem" to "bemba",
    "bez" to "bena",
    "bg" to "bołharšćina",
    "bgc" to "haryanvi",
    "bho" to "bhojpurišćina",
    "bi" to "bislamšćina",
    "bin" to "binišćina",
    "bla" to "siksikášćina",
    "blo" to "aniišćina",
    "bm" to "bambara",
    "bn" to "bengalšćina",
    "bo" to "tibetšćina",
    "br" to "bretonšćina",
    "brx" to "bodo",
    "bs" to "bosnišćina",
    "bug" to "buginezišćina",
    "byn" to "blinšćina",
    "ca" to "katalanšćina",
    "cay" to "cayugašćina",
    "ccp" to "čakma",
    "ce" to "čečenšćina",
    "ceb" to "cebuanšćina",
    "cgg" to "chiga",
    "ch" to "čamoršćina",
    "chk" to "chuukezišćina",
    "chm" to "marišćina",
    "cho" to "choctawšćina",
    "chp" to "chipewyanšćina",
    "chr" to "cherokee",
    "chy" to "cheyennešćina",
    "ckb" to "sorani",
    "ckb-alt-menu" to "sorani",
    "ckb-alt-variant" to "centralna kurdišćina",
    "clc" to "chilcotinšćina",
    "co" to "korsišćina",
    "cr" to "kri",
    "crg" to "michifšćina",
    "crj" to "južnowuchodna creešćina",
    "crk" to "plains creešćina",
    "crl" to "sewjernowuchodna creešćina",
    "crm" to "moode creešćina",
    "crr" to "carolina algonquianšćina",
    "cs" to "čěšćina",
    "csw" to "swampy creešćina",
    "cu" to "cyrkwinosłowjanšćina",
    "cv" to "chuvashišćina",
    "cy" to "walizišćina",
    "da" to "danšćina",
    "dak" to "dakotašćina",
    "dar" to "dargwašćina",
    "dav" to "taita",
    "de" to "němčina",
    "de-AT" to "awstriska němčina",
    "de-CH" to "šwicarska wysokoněmčina",
    "dgr" to "dogribšćina",
    "dje" to "zarma",
    "doi" to "dogrišćina",
    "dsb" to "delnjoserbšćina",
    "dua" to "duala",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dz" to "dzongkha",
    "dzg" to "dazagašćina",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efikšćina",
    "eka" to "ekajukšćina",
    "el" to "grjekšćina",
    "en" to "jendźelšćina",
    "en-AU" to "awstralska jendźelšćina",
    "en-CA" to "kanadiska jendźelšćina",
    "en-GB" to "britiska jendźelšćina",
    "en-GB-alt-short" to "jendźelšćina (UK)",
    "en-US" to "ameriska jendźelšćina",
    "en-US-alt-short" to "jendźelšćina (USA)",
    "eo" to "esperanto",
    "es" to "španišćina",
    "es-419" to "łaćonskoameriska španišćina",
    "es-ES" to "europska španišćina",
    "es-MX" to "mexiska španišćina",
    "et" to "estišćina",
    "eu" to "baskišćina",
    "ewo" to "ewondo",
    "fa" to "persišćina",
    "fa-AF" to "dari",
    "ff" to "fulbšćina",
    "fi" to "finšćina",
    "fil" to "filipinšćina",
    "fj" to "fidźišćina",
    "fo" to "färöšćina",
    "fon" to "fonšćina",
    "fr" to "francošćina",
    "fr-CA" to "kanadiska francošćina",
    "fr-CH" to "šwicarska francošćina",
    "frc" to "cajun francošćina",
    "frr" to "sewjernofrizišćina",
    "fur" to "friulšćina",
    "fy" to "frizišćina",
    "ga" to "iršćina",
    "gaa" to "gašćina",
    "gag" to "gagauzišćina",
    "gd" to "šotiska gelšćina",
    "gez" to "geezišćina",
    "gil" to "gilbertezišćina",
    "gl" to "galicišćina",
    "gn" to "guarani",
    "gor" to "gorontalošćina",
    "got" to "gotšćina",
    "gsw" to "šwicarska němčina",
    "gu" to "gujarati",
    "guz" to "gusii",
    "gv" to "manšćina",
    "gwi" to "gwichʼinšćina",
    "ha" to "hausa",
    "hai" to "haidašćina",
    "haw" to "hawaiišćina",
    "hax" to "južna haidašćina",
    "he" to "hebrejšćina",
    "hi" to "hindišćina",
    "hil" to "hiligaynonšćina",
    "hmn" to "hmongšćina",
    "hr" to "chorwatšćina",
    "hsb" to "hornjoserbšćina",
    "ht" to "haitišćina",
    "hu" to "madźaršćina",
    "hup" to "hupašćina",
    "hur" to "halkomelemšćina",
    "hy" to "armenšćina",
    "hz" to "hererošćina",
    "ia" to "interlingua",
    "iba" to "ibanšćina",
    "ibb" to "ibibiošćina",
    "id" to "indonešćina",
    "ie" to "interlinguešćina",
    "ig" to "igbo",
    "ii" to "sichuan yi",
    "ik" to "inupiak",
    "ikt" to "zapadnokanadska inuktitutšćina",
    "ilo" to "ilokošćina",
    "inh" to "ingushišćina",
    "io" to "ido",
    "is" to "islandšćina",
    "it" to "italšćina",
    "iu" to "inuitšćina",
    "ja" to "japanšćina",
    "jbo" to "lojbanšćina",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jv" to "javašćina",
    "ka" to "georgišćina",
    "kab" to "kabylšćina",
    "kac" to "kachinšćina",
    "kaj" to "jjušćina",
    "kam" to "kamba",
    "kbd" to "kabardianšćina",
    "kcg" to "tyapšćina",
    "kde" to "makonde",
    "kea" to "kapverdšćina",
    "kfo" to "korošćina",
    "kgp" to "kaingangšćina",
    "kha" to "khasišćina",
    "khq" to "koyra chiini",
    "ki" to "kikuyu",
    "kj" to "kuanyamašćina",
    "kk" to "kazachšćina",
    "kkj" to "kako",
    "kl" to "gröndlandšćina",
    "kln" to "kalenjin",
    "km" to "khmeršćina",
    "kmb" to "kimbundušćina",
    "kn" to "kannadšćina",
    "ko" to "korejšćina",
    "koi" to "permska komišćina",
    "kok" to "konkani",
    "kpe" to "kpellešćina",
    "kr" to "kanurišćina",
    "krc" to "karachay-balkaršćina",
    "krl" to "karelianšćina",
    "kru" to "kurukhšćina",
    "ks" to "kašmiršćina",
    "ksb" to "šambala",
    "ksf" to "bafia",
    "ksh" to "kelnšćina",
    "ku" to "kurdišćina",
    "kum" to "kumykšćina",
    "kv" to "komišćina",
    "kw" to "kornišćina",
    "kwk" to "kwakʼwalašćina",
    "kxv" to "kuvišćina",
    "ky" to "kirgišćina",
    "la" to "łaćonšćina",
    "lad" to "ladinšćina",
    "lag" to "langi",
    "lb" to "luxemburgšćina",
    "lez" to "lezgianšćina",
    "lg" to "gandšćina",
    "li" to "limburšćina",
    "lij" to "ligurianšćina",
    "lil" to "lillooetšćina",
    "lkt" to "lakota",
    "lmo" to "lombardšćina",
    "ln" to "lingala",
    "lo" to "laošćina",
    "lou" to "Louisiana kreolšćina",
    "loz" to "lozišćina",
    "lrc" to "sewjerna lurišćina",
    "lsm" to "saamiašćina",
    "lt" to "litawšćina",
    "lu" to "luba-katanga",
    "lua" to "luba-luluašćina",
    "lun" to "lundašćina",
    "lus" to "mizošćina",
    "luy" to "luhya",
    "lv" to "letišćina",
    "mad" to "madurezišćina",
    "mag" to "magahišćina",
    "mai" to "maithilšćina",
    "mak" to "makasaršćina",
    "mas" to "masaišćina",
    "mdf" to "mokshašćina",
    "men" to "mendišćina",
    "mer" to "meru",
    "mfe" to "mauriciska kreolšćina",
    "mg" to "malagassišćina",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta’",
    "mh" to "marshallezišćina",
    "mi" to "maoršćina",
    "mic" to "mi'kmaqšćina",
    "min" to "minangkabaušćina",
    "mk" to "makedonšćina",
    "ml" to "malajamšćina",
    "mn" to "mongolšćina",
    "mni" to "manipuršćina",
    "moe" to "innu-aimunšćina",
    "moh" to "mohawkšćina",
    "mos" to "mossišćina",
    "mr" to "maratišćina",
    "ms" to "malajšćina",
    "mt" to "maltašćina",
    "mua" to "mundang",
    "mul" to "wjacerěčne",
    "mus" to "krik",
    "mwl" to "mirandezišćina",
    "my" to "burmašćina",
    "myv" to "erzyašćina",
    "mzn" to "mazanderanšćina",
    "na" to "naurušćina",
    "nap" to "neapolitanšćina",
    "naq" to "nama",
    "nb" to "norwegšćina (bokmål)",
    "nd" to "sewjero-ndebele",
    "nds" to "delnjoněmčina",
    "ne" to "nepalšćina",
    "new" to "newarišćina",
    "ng" to "ndongašćina",
    "nia" to "niazišćina",
    "niu" to "niueanšćina",
    "nl" to "nižozemšćina",
    "nl-BE" to "flamšćina",
    "nmg" to "kwasio",
    "nn" to "norwegšćina (nynorsk)",
    "nnh" to "ngiemboon",
    "no" to "norwegšćina",
    "nog" to "nogaišćina",
    "nqo" to "n’ko",
    "nr" to "južna ndebelšćina",
    "nso" to "sewjerna sothošćina",
    "nus" to "nuer",
    "nv" to "navaho",
    "ny" to "nyanja",
    "nyn" to "nyankole",
    "oc" to "okcitanšćina",
    "ojb" to "sewjernozapadna ojibwašćina",
    "ojc" to "centralna ojibwašćina",
    "ojs" to "oji-creešćina",
    "ojw" to "zapadna ojibwašćina",
    "oka" to "okanaganšćina",
    "om" to "oromo",
    "or" to "orijšćina",
    "os" to "osetšćina",
    "pa" to "pandźabšćina",
    "pag" to "pangasinanšćina",
    "pam" to "pampangašćina",
    "pap" to "papiamentošćina",
    "pau" to "palauanšćina",
    "pcm" to "nigerijanski pidgin",
    "pis" to "pijinšćina",
    "pl" to "pólšćina",
    "pqm" to "maliseet-passamaquoddyšćina",
    "prg" to "prušćina",
    "ps" to "paštunšćina",
    "pt" to "portugalšćina",
    "pt-BR" to "brazilska portugalšćina",
    "pt-PT" to "europska portugalšćina",
    "qu" to "kečua",
    "quc" to "kʼicheʼ",
    "raj" to "rajasthani",
    "rap" to "rapanuišćina",
    "rar" to "rarotonganšćina",
    "rhg" to "rohingyašćina",
    "rm" to "retoromanšćina",
    "rn" to "kirundišćina",
    "ro" to "rumunšćina",
    "ro-MD" to "moldawšćina",
    "rof" to "rombo",
    "ru" to "rušćina",
    "rup" to "armanianšćina",
    "rw" to "kinjarwanda",
    "rwk" to "rwa",
    "sa" to "sanskrit",
    "sad" to "sandawešćina",
    "sah" to "jakutšćina",
    "saq" to "samburu",
    "sat" to "santalšćina",
    "sba" to "ngambayšćina",
    "sbp" to "sangu",
    "sc" to "sardinšćina",
    "scn" to "sicilšćina",
    "sco" to "scotšćina",
    "sd" to "sindhišćina",
    "se" to "sewjerosamišćina",
    "seh" to "sena",
    "ses" to "koyra senni",
    "sg" to "sango",
    "sh" to "serbochorwatšćina",
    "shi" to "tašelhit",
    "shn" to "shanšćina",
    "si" to "singhalšćina",
    "sk" to "słowakšćina",
    "sl" to "słowjenšćina",
    "slh" to "južna lushootseedšćina",
    "sm" to "samoašćina",
    "sma" to "južnosamišćina",
    "smj" to "lule-samišćina",
    "smn" to "inari-samišćina",
    "sms" to "skolt-samišćina",
    "sn" to "šonašćina",
    "snk" to "soninkešćina",
    "so" to "somališćina",
    "sq" to "albanšćina",
    "sr" to "serbišćina",
    "srn" to "sranan tongošćina",
    "ss" to "siswati",
    "st" to "južnosotšćina (Sesotho)",
    "stq" to "saterfrizišćina",
    "str" to "straits salishšćina",
    "su" to "sundanezišćina",
    "suk" to "sukumašćina",
    "sv" to "šwedšćina",
    "sw" to "suahelšćina",
    "sw-CD" to "kongoska suahelšćina",
    "swb" to "comorianšćina",
    "syr" to "syriacšćina",
    "szl" to "šlezišćina",
    "ta" to "tamilšćina",
    "tce" to "južna tutchonšćina",
    "te" to "telugu",
    "tem" to "timnešćina",
    "teo" to "teso",
    "tet" to "tetumšćina",
    "tg" to "tadźikšćina",
    "tgx" to "tagishšćina",
    "th" to "thailandšćina",
    "tht" to "tahltanšćina",
    "ti" to "tigrinšćina",
    "tig" to "tigrešćina",
    "tk" to "turkmenšćina",
    "tl" to "tagalog",
    "tlh" to "klingonšćina",
    "tli" to "tlingitšćina",
    "tn" to "tswana",
    "to" to "tongašćina",
    "tok" to "toki ponašćina",
    "tpi" to "tok pisinšćina",
    "tr" to "turkowšćina",
    "trv" to "tarokošćina",
    "ts" to "tsonga",
    "tt" to "tataršćina",
    "ttm" to "sewjerna tutchonšćina",
    "tum" to "tumbukašćina",
    "tvl" to "tuvalušćina",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitišćina",
    "tyv" to "tuvinianšćina",
    "tzm" to "tamazight (srjedźny Marokko)",
    "udm" to "udmurtšćina",
    "ug" to "ujguršćina",
    "uk" to "ukrainšćina",
    "umb" to "umbundušćina",
    "und" to "njeznata rěč",
    "ur" to "urdušćina",
    "uz" to "uzbekšćina",
    "ve" to "vendašćina",
    "vec" to "venetišćina",
    "vi" to "vietnamšćina",
    "vmw" to "makhuwašćina",
    "vo" to "volapük",
    "vun" to "vunjo",
    "wa" to "walonšćina",
    "wae" to "walzeršćina",
    "wal" to "wolayttašćina",
    "war" to "warayšćina",
    "wo" to "wolof",
    "wuu" to "wu chinšćina",
    "xal" to "kalmykšćina",
    "xh" to "xhosa",
    "xnr" to "kangrišćina",
    "xog" to "soga",
    "yav" to "yangben",
    "ybb" to "yembašćina",
    "yi" to "jidišćina",
    "yo" to "jorubašćina",
    "yrl" to "nheengatušćina",
    "yue" to "kantonšćina",
    "yue-alt-menu" to "chinšćina (kantonšćina)",
    "za" to "zhuang",
    "zgh" to "tamazight",
    "zh" to "chinšćina",
    "zh-alt-menu" to "chinšćina (mandarin)",
    "zh-Hans" to "chinšćina (zjednorjena)",
    "zh-Hans-alt-long" to "chinšćina (zjednorjena)",
    "zh-Hant" to "chinšćina (tradicionalna)",
    "zh-Hant-alt-long" to "chinšćina (tradicionalna)",
    "zu" to "zulušćina",
    "zun" to "zunišćina",
    "zxx" to "žadyn rěčny wobsah",
    "zza" to "zazašćina",
  ) }

  val hu: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abház",
    "ace" to "achinéz",
    "ach" to "akoli",
    "ada" to "adangme",
    "ady" to "adyghe",
    "ae" to "avesztán",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "agem",
    "ain" to "ainu",
    "ak" to "akan",
    "akk" to "akkád",
    "ale" to "aleut",
    "alt" to "dél-altaji",
    "am" to "amhara",
    "an" to "aragonéz",
    "ang" to "óangol",
    "ann" to "obolo",
    "anp" to "angika",
    "apc" to "levantei arab",
    "ar" to "arab",
    "ar-001" to "modern szabványos arab",
    "arc" to "arámi",
    "arn" to "mapucse",
    "arp" to "arapaho",
    "ars" to "nedzsdi arab",
    "ars-alt-menu" to "arab, nedzsdi",
    "arw" to "aravak",
    "as" to "asszámi",
    "asa" to "asu",
    "ast" to "asztúr",
    "atj" to "attikamek",
    "av" to "avar",
    "awa" to "awádi",
    "ay" to "ajmara",
    "az" to "azerbajdzsáni",
    "az-alt-short" to "azeri",
    "ba" to "baskír",
    "bal" to "balucsi",
    "ban" to "balinéz",
    "bas" to "basza",
    "bax" to "bamun",
    "bbj" to "gomala",
    "be" to "belarusz",
    "bej" to "bedzsa",
    "bem" to "bemba",
    "bez" to "bena",
    "bfd" to "bafut",
    "bg" to "bolgár",
    "bgc" to "haryanvi",
    "bgn" to "nyugati beludzs",
    "bho" to "bodzspuri",
    "bi" to "bislama",
    "bik" to "bikol",
    "bin" to "bini",
    "bkm" to "kom",
    "bla" to "siksika",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bangla",
    "bo" to "tibeti",
    "br" to "breton",
    "bra" to "braj",
    "brx" to "bodo",
    "bs" to "bosnyák",
    "bss" to "koszi",
    "bua" to "burját",
    "bug" to "buginéz",
    "bum" to "bulu",
    "byn" to "blin",
    "byv" to "medumba",
    "ca" to "katalán",
    "cad" to "caddo",
    "car" to "karib",
    "cay" to "kajuga",
    "cch" to "atszam",
    "ccp" to "csakma",
    "ce" to "csecsen",
    "ceb" to "szebuano",
    "cgg" to "kiga",
    "ch" to "csamoró",
    "chb" to "csibcsa",
    "chg" to "csagatáj",
    "chk" to "csukéz",
    "chm" to "mari",
    "chn" to "csinuk zsargon",
    "cho" to "csoktó",
    "chp" to "csipevé",
    "chr" to "cseroki",
    "chy" to "csejen",
    "ckb" to "közép-ázsiai kurd",
    "ckb-alt-menu" to "közép-ázsiai kurd",
    "ckb-alt-variant" to "kurd, szoráni",
    "clc" to "csilkotin",
    "co" to "korzikai",
    "cop" to "kopt",
    "cr" to "krí",
    "crg" to "micsif",
    "crh" to "krími tatár",
    "crj" to "délkeleti krí",
    "crk" to "síksági krí",
    "crl" to "északkeleti krí",
    "crm" to "moose krí",
    "crr" to "karolinai algonkin",
    "crs" to "szeszelva kreol francia",
    "cs" to "cseh",
    "csb" to "kasub",
    "csw" to "mocsári krí",
    "cu" to "egyházi szláv",
    "cv" to "csuvas",
    "cy" to "walesi",
    "da" to "dán",
    "dak" to "dakota",
    "dar" to "dargva",
    "dav" to "taita",
    "de" to "német",
    "de-AT" to "osztrák német",
    "de-CH" to "svájci felnémet",
    "del" to "delavár",
    "den" to "szlevi",
    "dgr" to "dogrib",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "alsó-szorb",
    "dua" to "duala",
    "dum" to "közép holland",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dyu" to "diula",
    "dz" to "dzsonga",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "eve",
    "efi" to "efik",
    "egy" to "óegyiptomi",
    "eka" to "ekadzsuk",
    "el" to "görög",
    "elx" to "elamit",
    "en" to "angol",
    "en-AU" to "ausztrál angol",
    "en-CA" to "kanadai angol",
    "en-GB" to "brit angol",
    "en-GB-alt-short" to "angol (UK)",
    "en-US" to "amerikai angol",
    "en-US-alt-short" to "angol (USA)",
    "enm" to "közép angol",
    "eo" to "eszperantó",
    "es" to "spanyol",
    "es-419" to "latin-amerikai spanyol",
    "es-ES" to "európai spanyol",
    "es-MX" to "spanyol (mexikói)",
    "et" to "észt",
    "eu" to "baszk",
    "ewo" to "evondo",
    "fa" to "perzsa",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fulani",
    "fi" to "finn",
    "fil" to "filippínó",
    "fj" to "fidzsi",
    "fo" to "feröeri",
    "fon" to "fon",
    "fr" to "francia",
    "fr-CA" to "kanadai francia",
    "fr-CH" to "svájci francia",
    "frc" to "cajun francia",
    "frm" to "közép francia",
    "fro" to "ófrancia",
    "frr" to "északi fríz",
    "frs" to "keleti fríz",
    "fur" to "friuli",
    "fy" to "nyugati fríz",
    "ga" to "ír",
    "gaa" to "ga",
    "gag" to "gagauz",
    "gan" to "gan kínai",
    "gay" to "gajo",
    "gba" to "gbaja",
    "gd" to "skóciai kelta",
    "gez" to "geez",
    "gil" to "ikiribati",
    "gl" to "gallego",
    "gmh" to "közép felső német",
    "gn" to "guarani",
    "goh" to "ófelső német",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gót",
    "grb" to "grebó",
    "grc" to "ógörög",
    "gsw" to "svájci német",
    "gu" to "gudzsaráti",
    "guz" to "guszii",
    "gv" to "man-szigeti",
    "gwi" to "gvicsin",
    "ha" to "hausza",
    "hai" to "haida",
    "hak" to "hakka kínai",
    "haw" to "hawaii",
    "hax" to "déli haida",
    "he" to "héber",
    "hi" to "hindi",
    "hi-Latn" to "hindi (latin)",
    "hi-Latn-alt-variant" to "hinglish",
    "hil" to "ilokano",
    "hit" to "hettita",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "horvát",
    "hsb" to "felső-szorb",
    "hsn" to "xiang kínai",
    "ht" to "haiti kreol",
    "hu" to "magyar",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "örmény",
    "hz" to "herero",
    "ia" to "interlingva",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonéz",
    "ie" to "interlingue",
    "ig" to "igbó",
    "ii" to "szecsuán ji",
    "ik" to "inupiak",
    "ikt" to "nyugat-kanadai inuit",
    "ilo" to "ilokó",
    "inh" to "ingus",
    "io" to "idó",
    "is" to "izlandi",
    "it" to "olasz",
    "iu" to "inuktitut",
    "ja" to "japán",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jpr" to "zsidó-perzsa",
    "jrb" to "zsidó-arab",
    "jv" to "jávai",
    "ka" to "grúz",
    "kaa" to "kara-kalpak",
    "kab" to "kabije",
    "kac" to "kacsin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kawi",
    "kbd" to "kabardi",
    "kbl" to "kanembu",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "kabuverdianu",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "kaingang",
    "kha" to "kaszi",
    "kho" to "kotanéz",
    "khq" to "kojra-csíni",
    "ki" to "kikuju",
    "kj" to "kuanyama",
    "kk" to "kazah",
    "kkj" to "kakó",
    "kl" to "grönlandi",
    "kln" to "kalendzsin",
    "km" to "khmer",
    "kmb" to "kimbundu",
    "kn" to "kannada",
    "ko" to "koreai",
    "koi" to "komi-permják",
    "kok" to "konkani",
    "kos" to "kosrei",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karacsáj-balkár",
    "krl" to "karelai",
    "kru" to "kuruh",
    "ks" to "kasmíri",
    "ksb" to "sambala",
    "ksf" to "bafia",
    "ksh" to "kölsch",
    "ku" to "kurd",
    "kum" to "kumük",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "korni",
    "kwk" to "kwakʼwala",
    "kxv" to "kuvi",
    "ky" to "kirgiz",
    "la" to "latin",
    "lad" to "ladino",
    "lag" to "langi",
    "lah" to "lahnda",
    "lam" to "lamba",
    "lb" to "luxemburgi",
    "lez" to "lezg",
    "lg" to "ganda",
    "li" to "limburgi",
    "lij" to "ligur",
    "lil" to "lillooet",
    "lkt" to "lakota",
    "lmo" to "lombard",
    "ln" to "lingala",
    "lo" to "lao",
    "lol" to "mongó",
    "lou" to "louisianai kreol",
    "loz" to "lozi",
    "lrc" to "északi luri",
    "lsm" to "samia",
    "lt" to "litván",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lui" to "luiseno",
    "lun" to "lunda",
    "lus" to "lushai",
    "luy" to "lujia",
    "lv" to "lett",
    "mad" to "madurai",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makaszar",
    "man" to "mandingó",
    "mas" to "masai",
    "mde" to "maba",
    "mdf" to "moksán",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "mauritiusi kreol",
    "mg" to "malgas",
    "mga" to "közép ír",
    "mgh" to "makua-metó",
    "mgo" to "meta’",
    "mh" to "marshalli",
    "mi" to "maori",
    "mic" to "mikmak",
    "min" to "minangkabau",
    "mk" to "macedón",
    "ml" to "malajálam",
    "mn" to "mongol",
    "mnc" to "mandzsu",
    "mni" to "manipuri",
    "moe" to "innu-aimun",
    "moh" to "mohawk",
    "mos" to "moszi",
    "mr" to "maráthi",
    "ms" to "maláj",
    "mt" to "máltai",
    "mua" to "mundang",
    "mul" to "többszörös nyelvek",
    "mus" to "krík",
    "mwl" to "mirandéz",
    "mwr" to "márvári",
    "my" to "burmai",
    "mye" to "myene",
    "myv" to "erzjány",
    "mzn" to "mázanderáni",
    "na" to "naurui",
    "nan" to "min nan kínai",
    "nap" to "nápolyi",
    "naq" to "nama",
    "nb" to "norvég (bokmål)",
    "nd" to "északi ndebele",
    "nds" to "alsónémet",
    "nds-NL" to "alsószász",
    "ne" to "nepáli",
    "new" to "nevari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niuei",
    "nl" to "holland",
    "nl-BE" to "flamand",
    "nmg" to "ngumba",
    "nn" to "norvég (nynorsk)",
    "nnh" to "ngiemboon",
    "no" to "norvég",
    "nog" to "nogaj",
    "non" to "óskandináv",
    "nqo" to "n’kó",
    "nr" to "déli ndebele",
    "nso" to "északi szeszotó",
    "nus" to "nuer",
    "nv" to "navahó",
    "nwc" to "klasszikus newari",
    "ny" to "nyandzsa",
    "nym" to "nyamvézi",
    "nyn" to "nyankole",
    "nyo" to "nyoró",
    "nzi" to "nzima",
    "oc" to "okszitán",
    "oj" to "ojibva",
    "ojb" to "északnyugati odzsibva",
    "ojc" to "középvidéki odzsibva",
    "ojs" to "odzsi-krí",
    "ojw" to "nyugati odzsibva",
    "oka" to "okanagan",
    "om" to "oromo",
    "or" to "odia",
    "os" to "oszét",
    "osa" to "osage",
    "ota" to "oszmán-török",
    "pa" to "pandzsábi",
    "pag" to "pangaszinan",
    "pal" to "pahlavi",
    "pam" to "pampangan",
    "pap" to "papiamento",
    "pau" to "palaui",
    "pcm" to "nigériai pidgin",
    "peo" to "óperzsa",
    "phn" to "főniciai",
    "pi" to "pali",
    "pis" to "pidzsin",
    "pl" to "lengyel",
    "pon" to "pohnpei",
    "pqm" to "maliseet-passamaquoddy",
    "prg" to "porosz",
    "pro" to "óprovánszi",
    "ps" to "pastu",
    "pt" to "portugál",
    "pt-BR" to "brazíliai portugál",
    "pt-PT" to "európai portugál",
    "qu" to "kecsua",
    "quc" to "kicse",
    "raj" to "radzsasztáni",
    "rap" to "rapanui",
    "rar" to "rarotongai",
    "rhg" to "rohingja",
    "rm" to "rétoromán",
    "rn" to "kirundi",
    "ro" to "román",
    "ro-MD" to "moldvai",
    "rof" to "rombo",
    "rom" to "roma",
    "ru" to "orosz",
    "rup" to "aromán",
    "rw" to "kinyarvanda",
    "rwk" to "rwo",
    "sa" to "szanszkrit",
    "sad" to "szandave",
    "sah" to "szaha",
    "sam" to "szamaritánus arámi",
    "saq" to "szamburu",
    "sas" to "sasak",
    "sat" to "szantáli",
    "sba" to "ngambay",
    "sbp" to "szangu",
    "sc" to "szardíniai",
    "scn" to "szicíliai",
    "sco" to "skót",
    "sd" to "szindhi",
    "sdh" to "dél-kurd",
    "se" to "északi számi",
    "see" to "szeneka",
    "seh" to "szena",
    "sel" to "szölkup",
    "ses" to "kojra-szenni",
    "sg" to "szangó",
    "sga" to "óír",
    "sh" to "szerbhorvát",
    "shi" to "tachelhit",
    "shn" to "san",
    "shu" to "csádi arab",
    "si" to "szingaléz",
    "sid" to "szidamó",
    "sk" to "szlovák",
    "sl" to "szlovén",
    "slh" to "déli lushootseed",
    "sm" to "szamoai",
    "sma" to "déli számi",
    "smj" to "lulei számi",
    "smn" to "inari számi",
    "sms" to "kolta számi",
    "sn" to "sona",
    "snk" to "szoninke",
    "so" to "szomáli",
    "sog" to "sogdien",
    "sq" to "albán",
    "sr" to "szerb",
    "srn" to "szranai tongó",
    "srr" to "szerer",
    "ss" to "sziszuati",
    "ssy" to "szahó",
    "st" to "déli szeszotó",
    "str" to "szorosmenti salish",
    "su" to "szundanéz",
    "suk" to "szukuma",
    "sus" to "szuszu",
    "sux" to "sumér",
    "sv" to "svéd",
    "sw" to "szuahéli",
    "sw-CD" to "kongói szuahéli",
    "swb" to "comorei",
    "syc" to "klasszikus szír",
    "syr" to "szír",
    "szl" to "sziléziai",
    "ta" to "tamil",
    "tce" to "déli tutchone",
    "te" to "telugu",
    "tem" to "temne",
    "teo" to "teszó",
    "ter" to "terenó",
    "tet" to "tetum",
    "tg" to "tadzsik",
    "tgx" to "tagish",
    "th" to "thai",
    "tht" to "tahltan",
    "ti" to "tigrinya",
    "tig" to "tigré",
    "tiv" to "tiv",
    "tk" to "türkmén",
    "tkl" to "tokelaui",
    "tl" to "tagalog",
    "tlh" to "klingon",
    "tli" to "tlingit",
    "tmh" to "tamasek",
    "tn" to "szecsuáni",
    "to" to "tongai",
    "tog" to "nyugati nyasza",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "török",
    "trv" to "tarokó",
    "ts" to "conga",
    "tsi" to "csimsiáni",
    "tt" to "tatár",
    "ttm" to "északi tutchone",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "twi",
    "twq" to "szavák",
    "ty" to "tahiti",
    "tyv" to "tuvai",
    "tzm" to "közép-atlaszi tamazigt",
    "udm" to "udmurt",
    "ug" to "ujgur",
    "uga" to "ugariti",
    "uk" to "ukrán",
    "umb" to "umbundu",
    "und" to "ismeretlen nyelv",
    "ur" to "urdu",
    "uz" to "üzbég",
    "ve" to "venda",
    "vec" to "velencei",
    "vi" to "vietnámi",
    "vmw" to "makua",
    "vo" to "volapük",
    "vot" to "votják",
    "vun" to "vunjo",
    "wa" to "vallon",
    "wae" to "walser",
    "wal" to "valamo",
    "war" to "varaó",
    "was" to "vasó",
    "wbp" to "warlpiri",
    "wo" to "volof",
    "wuu" to "wu kínai",
    "xal" to "kalmük",
    "xh" to "xhosza",
    "xnr" to "kangri",
    "xog" to "szoga",
    "yao" to "jaó",
    "yap" to "japi",
    "yav" to "jangben",
    "ybb" to "jemba",
    "yi" to "jiddis",
    "yo" to "joruba",
    "yrl" to "nheengatu",
    "yue" to "kantoni",
    "yue-alt-menu" to "kantoni kínai",
    "za" to "zsuang",
    "zap" to "zapoték",
    "zbl" to "Bliss jelképrendszer",
    "zen" to "zenaga",
    "zgh" to "marokkói tamazight",
    "zh" to "kínai",
    "zh-alt-menu" to "mandarin",
    "zh-Hans" to "egyszerűsített kínai",
    "zh-Hans-alt-long" to "kínai (egyszerűsített)",
    "zh-Hant" to "hagyományos kínai",
    "zh-Hant-alt-long" to "kínai (hagyományos)",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "nincs nyelvészeti tartalom",
    "zza" to "zaza",
  ) }

  val hy: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "աֆարերեն",
    "ab" to "աբխազերեն",
    "ace" to "աչեհերեն",
    "ach" to "աչոլի",
    "ada" to "ադանգմերեն",
    "ady" to "ադիղերեն",
    "aeb" to "թունիսական արաբերեն",
    "af" to "աֆրիկաանս",
    "agq" to "աղեմ",
    "ain" to "այներեն",
    "ak" to "աքան",
    "akk" to "աքքադերեն",
    "ale" to "ալեութերեն",
    "alt" to "հարավային ալթայերեն",
    "am" to "ամհարերեն",
    "an" to "արագոներեն",
    "ang" to "հին անգլերեն",
    "ann" to "օբոլո",
    "anp" to "անգիկա",
    "ar" to "արաբերեն",
    "ar-001" to "արդի ընդհանուր արաբերեն",
    "arc" to "արամեերեն",
    "arn" to "մապուչի",
    "arp" to "արապահո",
    "arq" to "ալժիրական արաբերեն",
    "ars" to "նեջդի արաբերեն",
    "arz" to "եգիպտական արաբերեն",
    "as" to "ասամերեն",
    "asa" to "ասու",
    "ase" to "ամերիկյան ժեստերի լեզու",
    "ast" to "աստուրերեն",
    "atj" to "աթիկամեկ",
    "av" to "ավարերեն",
    "awa" to "ավադհի",
    "ay" to "այմարա",
    "az" to "ադրբեջաներեն",
    "az-alt-short" to "ադրբեջաներեն",
    "ba" to "բաշկիրերեն",
    "ban" to "բալիերեն",
    "bas" to "բասաա",
    "be" to "բելառուսերեն",
    "bem" to "բեմբա",
    "bez" to "բենա",
    "bg" to "բուլղարերեն",
    "bgc" to "հարյանվի",
    "bgn" to "արևմտաբելուջիերեն",
    "bho" to "բհոպուրի",
    "bi" to "բիսլամա",
    "bin" to "բինի",
    "bla" to "սիկսիկա",
    "blo" to "անիի",
    "bm" to "բամբարա",
    "bn" to "բենգալերեն",
    "bo" to "տիբեթերեն",
    "br" to "բրետոներեն",
    "brx" to "բոդո",
    "bs" to "բոսնիերեն",
    "bss" to "աքուզ",
    "bug" to "բուգիերեն",
    "byn" to "բիլին",
    "ca" to "կատալաներեն",
    "cay" to "կայուգա",
    "ccp" to "չակմա",
    "ce" to "չեչեներեն",
    "ceb" to "սեբուերեն",
    "cgg" to "չիգա",
    "ch" to "չամոռո",
    "chk" to "տրուկերեն",
    "chm" to "մարի",
    "cho" to "չոկտո",
    "chp" to "չիպևայան",
    "chr" to "չերոկի",
    "chy" to "շայեն",
    "ckb" to "սորանի քրդերեն",
    "ckb-alt-menu" to "քրդերեն (սորանի)",
    "ckb-alt-variant" to "սորանի",
    "clc" to "չիլկոտիներեն",
    "co" to "կորսիկերեն",
    "cop" to "ղպտերեն",
    "crg" to "միչիֆ",
    "crh" to "ղրիմյան թուրքերեն",
    "crj" to "հարավ-արևելյան քրի",
    "crk" to "հարթավայրերի քրի",
    "crl" to "հյուսիս-արևելյան քրի",
    "crm" to "մուզ քրի",
    "crr" to "կարոլինական ալգոնկիներեն",
    "crs" to "սեյշելյան խառնակերտ ֆրանսերեն",
    "cs" to "չեխերեն",
    "csw" to "ճահճի քրի",
    "cu" to "սլավոներեն, եկեղեցական",
    "cv" to "չուվաշերեն",
    "cy" to "ուելսերեն",
    "da" to "դանիերեն",
    "dak" to "դակոտա",
    "dar" to "դարգիներեն",
    "dav" to "թաիթա",
    "de" to "գերմաներեն",
    "de-AT" to "ավստրիական գերմաներեն",
    "de-CH" to "շվեյցարական վերին գերմաներեն",
    "dgr" to "դոգրիբ",
    "dje" to "զարմա",
    "doi" to "դոգրի",
    "dsb" to "ստորին սորբերեն",
    "dua" to "դուալա",
    "dv" to "դիվեհի",
    "dyo" to "ջոլա-ֆոնյի",
    "dz" to "ջոնգքհա",
    "dzg" to "դազագա",
    "ebu" to "էմբու",
    "ee" to "էվե",
    "efi" to "էֆիկ",
    "egy" to "հին եգիպտերեն",
    "eka" to "էկաջուկ",
    "el" to "հունարեն",
    "en" to "անգլերեն",
    "en-AU" to "ավստրալիական անգլերեն",
    "en-CA" to "կանադական անգլերեն",
    "en-GB" to "բրիտանական անգլերեն",
    "en-GB-alt-short" to "բրիտանական անգլերեն",
    "en-US" to "ամերիկյան անգլերեն",
    "en-US-alt-short" to "ամերիկյան անգլերեն",
    "eo" to "էսպերանտո",
    "es" to "իսպաներեն",
    "es-419" to "լատինամերիկյան իսպաներեն",
    "es-ES" to "եվրոպական իսպաներեն",
    "es-MX" to "մեքսիկական իսպաներեն",
    "et" to "էստոներեն",
    "eu" to "բասկերեն",
    "ewo" to "էվոնդո",
    "fa" to "պարսկերեն",
    "fa-AF" to "դարի",
    "ff" to "ֆուլահ",
    "fi" to "ֆիններեն",
    "fil" to "ֆիլիպիներեն",
    "fit" to "տորնադելեն ֆիններեն",
    "fj" to "ֆիջիերեն",
    "fo" to "ֆարյորերեն",
    "fon" to "ֆոն",
    "fr" to "ֆրանսերեն",
    "fr-CA" to "կանադական ֆրանսերեն",
    "fr-CH" to "շվեյցարական ֆրանսերեն",
    "frc" to "քաջունական ֆրանսերեն",
    "fro" to "հին ֆրանսերեն",
    "frr" to "հյուսիսային ֆրիզերեն",
    "frs" to "արևելաֆրիզերեն",
    "fur" to "ֆրիուլիերեն",
    "fy" to "արևմտաֆրիզերեն",
    "ga" to "իռլանդերեն",
    "gaa" to "գայերեն",
    "gag" to "գագաուզերեն",
    "gbz" to "զրադաշտական դարի",
    "gd" to "շոտլանդական գաելերեն",
    "gez" to "գեեզ",
    "gil" to "կիրիբատի",
    "gl" to "գալիսերեն",
    "gn" to "գուարանի",
    "goh" to "հին վերին գերմաներեն",
    "gor" to "գորոնտալո",
    "got" to "գոթերեն",
    "grc" to "հին հունարեն",
    "gsw" to "շվեյցարական գերմաներեն",
    "gu" to "գուջարաթի",
    "guc" to "վայուու",
    "guz" to "գուսի",
    "gv" to "մեներեն",
    "gwi" to "գվիչին",
    "ha" to "հաուսա",
    "hai" to "հայդա",
    "haw" to "հավայիերեն",
    "hax" to "հարավային հայդա",
    "he" to "եբրայերեն",
    "hi" to "հինդի",
    "hi-Latn" to "հինդի (լատինատառ)",
    "hi-Latn-alt-variant" to "հինգլիշ",
    "hil" to "հիլիգայնոն",
    "hmn" to "հմոնգ",
    "hr" to "խորվաթերեն",
    "hsb" to "վերին սորբերեն",
    "hsn" to "սյան չինարեն",
    "ht" to "խառնակերտ հայիթերեն",
    "hu" to "հունգարերեն",
    "hup" to "հուպա",
    "hur" to "հալքոմելեմ",
    "hy" to "հայերեն",
    "hz" to "հերերո",
    "ia" to "ինտերլինգուա",
    "iba" to "իբաներեն",
    "ibb" to "իբիբիո",
    "id" to "ինդոնեզերեն",
    "ie" to "ինտերլինգուե",
    "ig" to "իգբո",
    "ii" to "սիչուան",
    "ikt" to "արևմտականադական ինուկտիտուտ",
    "ilo" to "իլոկերեն",
    "inh" to "ինգուշերեն",
    "io" to "իդո",
    "is" to "իսլանդերեն",
    "it" to "իտալերեն",
    "iu" to "ինուկտիտուտ",
    "ja" to "ճապոներեն",
    "jbo" to "լոժբան",
    "jgo" to "նգոմբա",
    "jmc" to "մաշամե",
    "jv" to "ճավայերեն",
    "ka" to "վրացերեն",
    "kab" to "կաբիլերեն",
    "kac" to "կաչիներեն",
    "kaj" to "ջյու",
    "kam" to "կամբա",
    "kbd" to "կաբարդերեն",
    "kcg" to "տիապ",
    "kde" to "մակոնդե",
    "kea" to "կաբուվերդերեն",
    "kfo" to "կորո",
    "kgp" to "կաինգան",
    "kha" to "քասիերեն",
    "khq" to "կոյրա չինի",
    "ki" to "կիկույու",
    "kj" to "կուանյամա",
    "kk" to "ղազախերեն",
    "kkj" to "կակո",
    "kl" to "կալաալիսուտ",
    "kln" to "կալենջին",
    "km" to "քմերերեն",
    "kmb" to "կիմբունդու",
    "kn" to "կաննադա",
    "ko" to "կորեերեն",
    "koi" to "պերմյակ կոմիերեն",
    "kok" to "կոնկանի",
    "kpe" to "կպելլեերեն",
    "kr" to "կանուրի",
    "krc" to "կարաչայ-բալկարերեն",
    "krl" to "կարելերեն",
    "kru" to "կուրուխ",
    "ks" to "քաշմիրերեն",
    "ksb" to "շամբալա",
    "ksf" to "բաֆիա",
    "ksh" to "քյոլներեն",
    "ku" to "քրդերեն",
    "kum" to "կումիկերեն",
    "kv" to "կոմիերեն",
    "kw" to "կոռներեն",
    "kwk" to "կվակվալա",
    "kxv" to "կուվի",
    "ky" to "ղրղզերեն",
    "la" to "լատիներեն",
    "lad" to "լադինո",
    "lag" to "լանգի",
    "lb" to "լյուքսեմբուրգերեն",
    "lez" to "լեզգիերեն",
    "lg" to "գանդա",
    "li" to "լիմբուրգերեն",
    "lij" to "լիգուրերեն",
    "lil" to "լիլուետ",
    "lkt" to "լակոտա",
    "lmo" to "լոմբարդերեն",
    "ln" to "լինգալա",
    "lo" to "լաոսերեն",
    "lou" to "լուիզիանական կրեոլերեն",
    "loz" to "լոզի",
    "lrc" to "հյուսիսային լուրիերեն",
    "lsm" to "սաամերեն",
    "lt" to "լիտվերեն",
    "lu" to "լուբա-կատանգա",
    "lua" to "լուբա-լուլուա",
    "lun" to "լունդա",
    "luo" to "լուո",
    "lus" to "միզո",
    "luy" to "լույա",
    "lv" to "լատվիերեն",
    "mad" to "մադուրերեն",
    "mag" to "մագահի",
    "mai" to "մայթիլի",
    "mak" to "մակասարերեն",
    "mas" to "մասաի",
    "mdf" to "մոկշայերեն",
    "men" to "մենդե",
    "mer" to "մերու",
    "mfe" to "մորիսյեն",
    "mg" to "մալգաշերեն",
    "mgh" to "մաքուա-մետտո",
    "mgo" to "մետա",
    "mh" to "մարշալերեն",
    "mi" to "մաորի",
    "mic" to "միկմակ",
    "min" to "մինանգկաբաու",
    "mk" to "մակեդոներեն",
    "ml" to "մալայալամ",
    "mn" to "մոնղոլերեն",
    "mni" to "մանիպուրի",
    "moe" to "իննու-այմուն",
    "moh" to "մոհավք",
    "mos" to "մոսսի",
    "mr" to "մարաթի",
    "mrj" to "արևմտամարիերեն",
    "ms" to "մալայերեն",
    "mt" to "մալթայերեն",
    "mua" to "մունդանգ",
    "mul" to "բազմալեզու",
    "mus" to "մասքոջի",
    "mwl" to "միրանդերեն",
    "my" to "բիրմայերեն",
    "myv" to "էրզյա",
    "mzn" to "մազանդարաներեն",
    "na" to "նաուրու",
    "nap" to "նեապոլերեն",
    "naq" to "նամա",
    "nb" to "գրքային նորվեգերեն",
    "nd" to "հյուսիսային նդեբելե",
    "nds" to "ստորին գերմաներեն",
    "nds-NL" to "ստորին սաքսոներեն",
    "ne" to "նեպալերեն",
    "new" to "նեվարերեն",
    "ng" to "նդոնգա",
    "nia" to "նիասերեն",
    "niu" to "նիուերեն",
    "nl" to "հոլանդերեն",
    "nl-BE" to "ֆլամանդերեն",
    "nmg" to "կվասիո",
    "nn" to "նոր նորվեգերեն",
    "nnh" to "նգիեմբուն",
    "no" to "նորվեգերեն",
    "nog" to "նոգայերեն",
    "non" to "հին նորվեգերեն",
    "nqo" to "նկո",
    "nr" to "հարավային նդեբելե",
    "nso" to "հյուսիսային սոթո",
    "nus" to "նուեր",
    "nv" to "նավախո",
    "ny" to "նյանջա",
    "nyn" to "նյանկոլե",
    "oc" to "օքսիտաներեն",
    "oj" to "օջիբվա",
    "ojb" to "հյուսիս-արևմտյան օջիբվե",
    "ojc" to "կենտրոնական օջիբվե",
    "ojs" to "օջի քրի",
    "ojw" to "արևմտյան օջիբվե",
    "oka" to "օկանագան",
    "om" to "օրոմո",
    "or" to "օրիյա",
    "os" to "օսերեն",
    "osa" to "օսեյջ",
    "ota" to "օսմաներեն",
    "pa" to "փենջաբերեն",
    "pag" to "պանգասինաներեն",
    "pal" to "պահլավերեն",
    "pam" to "պամպանգաերեն",
    "pap" to "պապյամենտո",
    "pau" to "պալաուերեն",
    "pcd" to "պիկարդերեն",
    "pcm" to "նիգերիական փիջին",
    "pdc" to "փենսիլվանական գերմաներեն",
    "pdt" to "պլատագերմաներեն",
    "peo" to "հին պարսկերեն",
    "pfl" to "պալատինյան գերմաներեն",
    "phn" to "փյունիկերեն",
    "pi" to "պալի",
    "pis" to "փիջին",
    "pl" to "լեհերեն",
    "pms" to "պիեմոնտերեն",
    "pnt" to "պոնտերեն",
    "pon" to "պոնպեերեն",
    "pqm" to "մալեսիտ-պասամակվոդի",
    "prg" to "պրուսերեն",
    "pro" to "հին պրովանսերեն",
    "ps" to "փուշթու",
    "pt" to "պորտուգալերեն",
    "pt-BR" to "բրազիլական պորտուգալերեն",
    "pt-PT" to "եվրոպական պորտուգալերեն",
    "qu" to "կեչուա",
    "quc" to "քիչե",
    "raj" to "ռաջաստաներեն",
    "rap" to "ռապանուի",
    "rar" to "ռարոտոնգաներեն",
    "rgn" to "ռոմանիոլերեն",
    "rhg" to "ռոհինջա",
    "rif" to "ռիֆերեն",
    "rm" to "ռոմանշերեն",
    "rn" to "ռունդի",
    "ro" to "ռումիներեն",
    "ro-MD" to "մոլդովերեն",
    "rof" to "ռոմբո",
    "rom" to "ռոմաներեն",
    "rtm" to "ռոտուման",
    "ru" to "ռուսերեն",
    "rue" to "ռուսիներեն",
    "rug" to "ռովիանա",
    "rup" to "արոմաներեն",
    "rw" to "կինյառուանդա",
    "rwk" to "ռվա",
    "sa" to "սանսկրիտ",
    "sad" to "սանդավե",
    "sah" to "յակուտերեն",
    "saq" to "սամբուրու",
    "sat" to "սանտալի",
    "sba" to "նգամբայ",
    "sbp" to "սանգու",
    "sc" to "սարդիներեն",
    "scn" to "սիցիլիերեն",
    "sco" to "շոտլանդերեն",
    "sd" to "սինդհի",
    "sdh" to "հարավային քրդերեն",
    "se" to "հյուսիսային սաամի",
    "seh" to "սենա",
    "ses" to "կոյրաբորո սեննի",
    "sg" to "սանգո",
    "sga" to "հին իռլանդերեն",
    "sh" to "սերբա-խորվաթերեն",
    "shi" to "տաշելհիթ",
    "shn" to "շաներեն",
    "si" to "սինհալերեն",
    "sk" to "սլովակերեն",
    "sl" to "սլովեներեն",
    "slh" to "հարավային լուշուցիդ",
    "sm" to "սամոաերեն",
    "sma" to "հարավային սաամի",
    "smj" to "լուլե սաամի",
    "smn" to "ինարի սաամի",
    "sms" to "սկոլտ սաամի",
    "sn" to "շոնա",
    "snk" to "սոնինկե",
    "so" to "սոմալիերեն",
    "sq" to "ալբաներեն",
    "sr" to "սերբերեն",
    "srn" to "սրանան տոնգո",
    "ss" to "սվազերեն",
    "ssy" to "սահոերեն",
    "st" to "հարավային սոթո",
    "str" to "սթրեյթս սալիշերեն",
    "su" to "սունդաներեն",
    "suk" to "սուկումա",
    "sv" to "շվեդերեն",
    "sw" to "սուահիլի",
    "sw-CD" to "կոնգոյի սուահիլի",
    "swb" to "կոմորերեն",
    "syr" to "ասորերեն",
    "szl" to "սիլեզերեն",
    "ta" to "թամիլերեն",
    "tce" to "հարավային թուտչոնե",
    "tcy" to "տուլու",
    "te" to "թելուգու",
    "tem" to "տեմնե",
    "teo" to "տեսո",
    "ter" to "տերենո",
    "tet" to "տետում",
    "tg" to "տաջիկերեն",
    "tgx" to "թագիշ",
    "th" to "թայերեն",
    "tht" to "թալթան",
    "ti" to "տիգրինյա",
    "tig" to "տիգրե",
    "tiv" to "տիվերեն",
    "tk" to "թուրքմեներեն",
    "tkl" to "տոկելաու",
    "tkr" to "ցախուր",
    "tl" to "տագալերեն",
    "tlh" to "կլինգոն",
    "tli" to "տլինգիտ",
    "tly" to "թալիշերեն",
    "tmh" to "տամաշեկ",
    "tn" to "ցվանա",
    "to" to "տոնգերեն",
    "tok" to "տոկիպոնա",
    "tpi" to "տոկ փիսին",
    "tr" to "թուրքերեն",
    "tru" to "տուրոյո",
    "trv" to "տարոկո",
    "ts" to "ցոնգա",
    "tsd" to "ցակոներեն",
    "tsi" to "ցիմշյան",
    "tt" to "թաթարերեն",
    "ttm" to "հյուսիսային թուտչոնե",
    "tum" to "տումբուկա",
    "tvl" to "թուվալուերեն",
    "tw" to "տուի",
    "twq" to "տասավաք",
    "ty" to "թաիտերեն",
    "tyv" to "տուվերեն",
    "tzm" to "կենտրոնատլասյան թամազիղտ",
    "udm" to "ուդմուրտերեն",
    "ug" to "ույղուրերեն",
    "uga" to "ուգարիտերեն",
    "uk" to "ուկրաիներեն",
    "umb" to "ումբունդու",
    "und" to "անհայտ լեզու",
    "ur" to "ուրդու",
    "uz" to "ուզբեկերեն",
    "vai" to "վաի",
    "ve" to "վենդա",
    "vec" to "վենետերեն",
    "vep" to "վեպսերեն",
    "vi" to "վիետնամերեն",
    "vls" to "արևմտաֆլամանդերեն",
    "vmw" to "մաքուա",
    "vo" to "վոլապյուկ",
    "vot" to "վոդերեն",
    "vro" to "վորո",
    "vun" to "վունջո",
    "wa" to "վալոներեն",
    "wae" to "վալսերեն",
    "wal" to "վոլայտա",
    "war" to "վարայերեն",
    "was" to "վաշո",
    "wbp" to "վարլպիրի",
    "wo" to "վոլոֆ",
    "wuu" to "վու չինարեն",
    "xal" to "կալմիկերեն",
    "xh" to "քոսա",
    "xnr" to "կանգրի",
    "xog" to "սոգա",
    "yao" to "յաո",
    "yap" to "յափերեն",
    "yav" to "յանգբեն",
    "ybb" to "եմբա",
    "yi" to "իդիշ",
    "yo" to "յորուբա",
    "yrl" to "նինգաթու",
    "yue" to "կանտոներեն",
    "yue-alt-menu" to "չինարեն, կանտոներեն",
    "za" to "ժուանգ",
    "zap" to "սապոտեկերեն",
    "zea" to "զեյլանդերեն",
    "zen" to "զենագա",
    "zgh" to "ընդհանուր մարոկյան թամազիղտ",
    "zh" to "չինարեն",
    "zh-alt-menu" to "չինարեն, մանդարին",
    "zh-Hans" to "պարզեցված չինարեն",
    "zh-Hans-alt-long" to "պարզեցված մանդարին չինարեն",
    "zh-Hant" to "ավանդական չինարեն",
    "zh-Hant-alt-long" to "ավանդական մանդարին չինարեն",
    "zu" to "զուլուերեն",
    "zun" to "զունիերեն",
    "zxx" to "առանց լեզվային բովանդակության",
    "zza" to "զազաերեն",
  ) }

  val ia: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abkhazo",
    "ace" to "acehnese",
    "ada" to "adangme",
    "ady" to "adygeano",
    "af" to "afrikaans",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "akan",
    "ale" to "aleuto",
    "alt" to "altai del sud",
    "am" to "amharico",
    "an" to "aragonese",
    "ann" to "obolo",
    "anp" to "angika",
    "apc" to "arabe levantin",
    "ar" to "arabe",
    "ar-001" to "arabe standard moderne",
    "arn" to "mapuche",
    "arp" to "arapaho",
    "ars" to "arabe najdi",
    "as" to "assamese",
    "asa" to "asu",
    "ast" to "asturiano",
    "atj" to "atikamekw",
    "av" to "avaro",
    "awa" to "awadhi",
    "ay" to "aymara",
    "az" to "azerbaidzhano",
    "az-alt-short" to "azeri",
    "ba" to "bashkir",
    "bal" to "baluchi",
    "ban" to "balinese",
    "bas" to "basaa",
    "be" to "bielorusso",
    "bem" to "bemba",
    "bew" to "betawi",
    "bez" to "bena",
    "bg" to "bulgaro",
    "bgc" to "haryanvi",
    "bgn" to "baluchi occidental",
    "bho" to "bhojpuri",
    "bi" to "bislama",
    "bin" to "bini",
    "bla" to "siksika",
    "blo" to "anii",
    "blt" to "tai dam",
    "bm" to "bambara",
    "bn" to "bengalese",
    "bo" to "tibetano",
    "br" to "breton",
    "brx" to "bodo",
    "bs" to "bosniaco",
    "bss" to "akoose",
    "bug" to "buginese",
    "byn" to "blin",
    "ca" to "catalano",
    "cad" to "caddo",
    "cay" to "cayuga",
    "cch" to "atsam",
    "ccp" to "chakma",
    "ce" to "checheno",
    "ceb" to "cebuano",
    "cgg" to "chiga",
    "ch" to "chamorro",
    "chk" to "chuukese",
    "chm" to "mari",
    "cho" to "choctaw",
    "chp" to "chipewyan",
    "chr" to "cherokee",
    "chy" to "cheyenne",
    "cic" to "chickasaw",
    "ckb" to "kurdo central",
    "ckb-alt-menu" to "kurdo central",
    "ckb-alt-variant" to "kurdo sorani",
    "clc" to "chilcotin",
    "co" to "corso",
    "crg" to "mitchif",
    "crj" to "cree del sud-est",
    "crk" to "cree del planas",
    "crl" to "cree del nord-est",
    "crm" to "cree moose",
    "crr" to "algonquino de Carolina",
    "crs" to "creolo seychellese",
    "cs" to "checo",
    "csw" to "cree del paludes",
    "cu" to "slavo ecclesiastic",
    "cv" to "chuvash",
    "cy" to "gallese",
    "da" to "danese",
    "dak" to "dakota",
    "dar" to "dargwa",
    "dav" to "taita",
    "de" to "germano",
    "de-AT" to "germano austriac",
    "de-CH" to "alte germano suisse",
    "dgr" to "dogrib",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "basse sorabo",
    "dua" to "duala",
    "dv" to "divehi",
    "dyo" to "jola-fonyi",
    "dz" to "dzongkha",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efik",
    "eka" to "ekajuk",
    "el" to "greco",
    "en" to "anglese",
    "en-AU" to "anglese australian",
    "en-CA" to "anglese canadian",
    "en-GB" to "anglese britannic",
    "en-GB-alt-short" to "anglese (GB)",
    "en-US" to "anglese american",
    "en-US-alt-short" to "anglese (SUA)",
    "eo" to "esperanto",
    "es" to "espaniol",
    "es-419" to "espaniol latinoamerican",
    "es-ES" to "espaniol europee",
    "es-MX" to "espaniol mexican",
    "et" to "estoniano",
    "eu" to "basco",
    "ewo" to "ewondo",
    "fa" to "persa",
    "fa-AF" to "dari",
    "ff" to "fula",
    "fi" to "finnese",
    "fil" to "filipino",
    "fj" to "fijiano",
    "fo" to "feroese",
    "fon" to "fon",
    "fr" to "francese",
    "fr-CA" to "francese canadian",
    "fr-CH" to "francese suisse",
    "frc" to "francese cajun",
    "frr" to "frison septentrional",
    "fur" to "friulano",
    "fy" to "frison occidental",
    "ga" to "irlandese",
    "gaa" to "ga",
    "gd" to "gaelico scotese",
    "gez" to "ge’ez",
    "gil" to "gilbertese",
    "gl" to "galleco",
    "gn" to "guarani",
    "gor" to "gorontalo",
    "gsw" to "germano suisse",
    "gu" to "gujarati",
    "guz" to "gusii",
    "gv" to "mannese",
    "gwi" to "gwich’in",
    "ha" to "hausa",
    "hai" to "haida",
    "haw" to "hawaiano",
    "hax" to "haida del sud",
    "he" to "hebreo",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hinglish",
    "hil" to "hiligaynon",
    "hmn" to "hmong",
    "hr" to "croato",
    "hsb" to "alte sorabo",
    "ht" to "creolo haitian",
    "hu" to "hungaro",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armenio",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonesiano",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "yi de Sichuan",
    "ikt" to "inuktitut del west canadian",
    "ilo" to "ilocano",
    "inh" to "ingush",
    "io" to "ido",
    "is" to "islandese",
    "it" to "italiano",
    "iu" to "inuktitut",
    "ja" to "japonese",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "machame",
    "jv" to "javanese",
    "ka" to "georgiano",
    "kaa" to "kara-kalpak",
    "kab" to "kabylo",
    "kac" to "kachin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kbd" to "cabardiano",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "capoverdiano",
    "ken" to "kenyang",
    "kfo" to "koro",
    "kgp" to "kaingang",
    "kha" to "khasi",
    "khq" to "koyra chiini",
    "ki" to "kikuyu",
    "kj" to "kuanyama",
    "kk" to "kazakh",
    "kkj" to "kako",
    "kl" to "groenlandese",
    "kln" to "kalenjin",
    "km" to "khmer",
    "kmb" to "kimbundu",
    "kn" to "kannada",
    "ko" to "coreano",
    "kok" to "konkani",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karachay-balkaro",
    "krl" to "careliano",
    "kru" to "kurukh",
    "ks" to "kashmiri",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "coloniese",
    "ku" to "kurdo",
    "kum" to "kumyko",
    "kv" to "komi",
    "kw" to "cornico",
    "kwk" to "kwakwala",
    "kxv" to "kuvi",
    "ky" to "kirghizo",
    "la" to "latino",
    "lad" to "judeo-espaniol",
    "lag" to "langi",
    "lb" to "luxemburgese",
    "lez" to "lezghiano",
    "lg" to "luganda",
    "li" to "limburgese",
    "lij" to "ligure",
    "lil" to "lillooet",
    "lkt" to "lakota",
    "lld" to "ladino",
    "lmo" to "lombardo",
    "ln" to "lingala",
    "lo" to "laotiano",
    "lou" to "creolo louisianese",
    "loz" to "lozi",
    "lrc" to "luri del nord",
    "lsm" to "samia",
    "lt" to "lithuano",
    "ltg" to "latgaliano",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lun" to "lunda",
    "lus" to "mizo",
    "luy" to "luyia",
    "lv" to "letton",
    "mad" to "madurese",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "macassarese",
    "mas" to "masai",
    "mdf" to "moksha",
    "men" to "mende",
    "mer" to "meri",
    "mfe" to "creolo mauritian",
    "mg" to "malgache",
    "mgh" to "macua de Metto",
    "mgo" to "metaʼ",
    "mh" to "marshallese",
    "mhn" to "mocheno",
    "mi" to "maori",
    "mic" to "micmac",
    "min" to "minangkabau",
    "mk" to "macedone",
    "ml" to "malayalam",
    "mn" to "mongol",
    "mni" to "manipuri",
    "moe" to "innu-aimun",
    "moh" to "mohawk",
    "mos" to "mossi",
    "mr" to "marathi",
    "ms" to "malay",
    "mt" to "maltese",
    "mua" to "mundang",
    "mul" to "plure linguas",
    "mus" to "creek",
    "mwl" to "mirandese",
    "my" to "birmano",
    "myv" to "erzya",
    "mzn" to "mazanderani",
    "na" to "nauru",
    "nap" to "napolitano",
    "naq" to "nama",
    "nb" to "norvegiano bokmål",
    "nd" to "ndebele del nord",
    "nds" to "basse germano",
    "nds-NL" to "basse saxone",
    "ne" to "nepalese",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "nieuano",
    "nl" to "nederlandese",
    "nl-BE" to "flamingo",
    "nmg" to "kwasio",
    "nn" to "norvegiano nynorsk",
    "nnh" to "ngiemboon",
    "no" to "norvegiano",
    "nog" to "nogai",
    "nqo" to "n’ko",
    "nr" to "ndebele del sud",
    "nso" to "sotho del nord",
    "nus" to "nuer",
    "nv" to "navajo",
    "ny" to "nyanja",
    "nyn" to "nyankole",
    "oc" to "occitano",
    "ojb" to "ojibwa del nord-west",
    "ojc" to "ojibwa central",
    "ojs" to "oji-cree",
    "ojw" to "ojibwa del west",
    "oka" to "okanagan",
    "om" to "oromo",
    "or" to "oriya",
    "os" to "osseto",
    "osa" to "osage",
    "pa" to "punjabi",
    "pag" to "pangasinan",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palauano",
    "pcm" to "pidgin nigerian",
    "pis" to "pijin",
    "pl" to "polonese",
    "pqm" to "malecite-passamaquoddy",
    "prg" to "prussiano",
    "ps" to "pashto",
    "pt" to "portugese",
    "pt-BR" to "portugese de Brasil",
    "pt-PT" to "portugese de Portugal",
    "qu" to "quechua",
    "quc" to "kʼicheʼ",
    "raj" to "rajasthani",
    "rap" to "rapanui",
    "rar" to "rarotongano",
    "rhg" to "rohingya",
    "rif" to "rifeno",
    "rm" to "romanche",
    "rn" to "rundi",
    "ro" to "romaniano",
    "ro-MD" to "moldavo",
    "rof" to "rombo",
    "ru" to "russo",
    "rup" to "aromaniano",
    "rw" to "kinyarwanda",
    "rwk" to "rwa",
    "sa" to "sanscrito",
    "sad" to "sandawe",
    "sah" to "yakuto",
    "saq" to "samburu",
    "sat" to "santali",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sardo",
    "scn" to "siciliano",
    "sco" to "scotese",
    "sd" to "sindhi",
    "sdh" to "kurdo del sud",
    "se" to "sami del nord",
    "seh" to "sena",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sh" to "serbocroato",
    "shi" to "tachelhit",
    "shn" to "shan",
    "si" to "cingalese",
    "sid" to "sidamo",
    "sk" to "slovaco",
    "skr" to "saraiki",
    "sl" to "sloveno",
    "slh" to "lushootseed del sud",
    "sm" to "samoano",
    "sma" to "sami del sud",
    "smj" to "sami de Lule",
    "smn" to "sami de Inari",
    "sms" to "sami skolt",
    "sn" to "shona",
    "snk" to "soninke",
    "so" to "somali",
    "sq" to "albanese",
    "sr" to "serbo",
    "srn" to "sranan tongo",
    "ss" to "swati",
    "ssy" to "saho",
    "st" to "sotho del sud",
    "str" to "salish del strictos",
    "su" to "sundanese",
    "suk" to "sukuma",
    "sv" to "svedese",
    "sw" to "swahili",
    "sw-CD" to "swahili del Congo",
    "swb" to "comoriano",
    "syr" to "syriaco",
    "szl" to "silesiano",
    "ta" to "tamil",
    "tce" to "tutchone del sud",
    "te" to "telugu",
    "tem" to "temne",
    "teo" to "teso",
    "tet" to "tetum",
    "tg" to "tajiko",
    "tgx" to "tagish",
    "th" to "thai",
    "tht" to "tahltan",
    "ti" to "tigrinya",
    "tig" to "tigre",
    "tk" to "turkmeno",
    "tlh" to "klingon",
    "tli" to "tlingit",
    "tn" to "tswana",
    "to" to "tongano",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turco",
    "trv" to "taroko",
    "trw" to "torwali",
    "ts" to "tsonga",
    "tt" to "tataro",
    "ttm" to "tutchone del nord",
    "tum" to "tumbuka",
    "tvl" to "tuvaluano",
    "tw" to "twi",
    "twq" to "tasawaq",
    "ty" to "tahitiano",
    "tyv" to "tuvano",
    "tzm" to "tamazight del Atlas Central",
    "udm" to "udmurto",
    "ug" to "uighur",
    "uk" to "ukrainiano",
    "umb" to "umbundu",
    "und" to "lingua incognite",
    "ur" to "urdu",
    "uz" to "uzbeko",
    "ve" to "venda",
    "vec" to "venetiano",
    "vi" to "vietnamese",
    "vmw" to "macua",
    "vo" to "volapük",
    "vun" to "vunjo",
    "wa" to "wallon",
    "wae" to "walser",
    "wal" to "wolaytta",
    "war" to "waray",
    "wbp" to "warlpiri",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "calmuco",
    "xh" to "xhosa",
    "xnr" to "kangri",
    "xog" to "soga",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "yiddish",
    "yo" to "yoruba",
    "yrl" to "nheengatu",
    "yue" to "cantonese",
    "yue-alt-menu" to "chinese cantonese",
    "za" to "zhuang",
    "zgh" to "tamazight marocchin standard",
    "zh" to "chinese",
    "zh-alt-menu" to "chinese mandarin",
    "zh-Hans" to "chinese simplificate",
    "zh-Hans-alt-long" to "chinese mandarin simplificate",
    "zh-Hant" to "chinese traditional",
    "zh-Hant-alt-long" to "chinese mandarin traditional",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "sin contento linguistic",
    "zza" to "zaza",
  ) }

  val id: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afar",
    "ab" to "Abkhaz",
    "ace" to "Aceh",
    "ach" to "Acoli",
    "ada" to "Adangme",
    "ady" to "Adygei",
    "ae" to "Avesta",
    "aeb" to "Arab Tunisia",
    "af" to "Afrikaans",
    "afh" to "Afrihili",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "akk" to "Akkadia",
    "akz" to "Alabama",
    "ale" to "Aleut",
    "alt" to "Altai Selatan",
    "am" to "Amharik",
    "an" to "Aragon",
    "ang" to "Inggris Kuno",
    "ann" to "Obolo",
    "anp" to "Angika",
    "ar" to "Arab",
    "ar-001" to "Arab Standar Modern",
    "arc" to "Aram",
    "arn" to "Mapuche",
    "arp" to "Arapaho",
    "arq" to "Arab Aljazair",
    "ars" to "Arab Najdi",
    "arw" to "Arawak",
    "ary" to "Arab Maroko",
    "arz" to "Arab Mesir",
    "as" to "Assam",
    "asa" to "Asu",
    "ase" to "Bahasa Isyarat Amerika",
    "ast" to "Asturia",
    "atj" to "Atikamekw",
    "av" to "Avar",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Azerbaijani",
    "az-alt-short" to "Azeri",
    "ba" to "Bashkir",
    "bal" to "Baluchi",
    "ban" to "Bali",
    "bar" to "Bavaria",
    "bas" to "Basa",
    "bax" to "Bamun",
    "bbc" to "Batak Toba",
    "bbj" to "Ghomala",
    "be" to "Belarusia",
    "bej" to "Beja",
    "bem" to "Bemba",
    "bew" to "Betawi",
    "bez" to "Bena",
    "bfd" to "Bafut",
    "bg" to "Bulgaria",
    "bgc" to "Haryanvi",
    "bgn" to "Balochi Barat",
    "bho" to "Bhojpuri",
    "bi" to "Bislama",
    "bik" to "Bikol",
    "bin" to "Bini",
    "bjn" to "Banjar",
    "bkm" to "Kom",
    "bla" to "Siksika",
    "blo" to "Anii",
    "bm" to "Bambara",
    "bn" to "Bengali",
    "bo" to "Tibet",
    "br" to "Breton",
    "bra" to "Braj",
    "brx" to "Bodo",
    "bs" to "Bosnia",
    "bss" to "Akoose",
    "bua" to "Buriat",
    "bug" to "Bugis",
    "bum" to "Bulu",
    "byn" to "Blin",
    "byv" to "Medumba",
    "ca" to "Katalan",
    "cad" to "Kado",
    "car" to "Karibia",
    "cay" to "Cayuga",
    "cch" to "Atsam",
    "ccp" to "Chakma",
    "ce" to "Chechen",
    "ceb" to "Cebuano",
    "cgg" to "Kiga",
    "ch" to "Chamorro",
    "chb" to "Chibcha",
    "chg" to "Chagatai",
    "chk" to "Chuuke",
    "chm" to "Mari",
    "chn" to "Jargon Chinook",
    "cho" to "Koktaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyenne",
    "ckb" to "Kurdi Sorani",
    "ckb-alt-menu" to "Kurdi Sorani",
    "ckb-alt-variant" to "Kurdi, Sorani",
    "clc" to "Chilcotin",
    "co" to "Korsika",
    "cop" to "Koptik",
    "cr" to "Kree",
    "crg" to "Michif",
    "crh" to "Tatar Krimea",
    "crj" to "East Cree Selatan",
    "crk" to "Cree Dataran",
    "crl" to "East Cree Utara",
    "crm" to "Moose Cree",
    "crr" to "Carolina Algonquian",
    "crs" to "Seselwa Kreol Prancis",
    "cs" to "Ceko",
    "csb" to "Kashubia",
    "csw" to "Cree Rawa",
    "cu" to "Bahasa Gereja Slavonia",
    "cv" to "Chuvash",
    "cy" to "Welsh",
    "da" to "Dansk",
    "dak" to "Dakota",
    "dar" to "Dargwa",
    "dav" to "Taita",
    "de" to "Jerman",
    "de-CH" to "Jerman Tinggi (Swiss)",
    "del" to "Delaware",
    "den" to "Slave",
    "dgr" to "Dogrib",
    "din" to "Dinka",
    "dje" to "Zarma",
    "doi" to "Dogri",
    "dsb" to "Sorbia Hilir",
    "dua" to "Duala",
    "dum" to "Belanda Abad Pertengahan",
    "dv" to "Divehi",
    "dyo" to "Jola-Fonyi",
    "dyu" to "Dyula",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "egy" to "Mesir Kuno",
    "eka" to "Ekajuk",
    "el" to "Yunani",
    "elx" to "Elam",
    "en" to "Inggris",
    "en-GB" to "Inggris (Britania)",
    "en-GB-alt-short" to "Inggris (UK)",
    "enm" to "Inggris Abad Pertengahan",
    "eo" to "Esperanto",
    "es" to "Spanyol",
    "es-ES" to "Spanyol (Eropa)",
    "et" to "Estonia",
    "eu" to "Basque",
    "ewo" to "Ewondo",
    "fa" to "Persia",
    "fa-AF" to "Persia Dari",
    "fan" to "Fang",
    "fat" to "Fanti",
    "ff" to "Fula",
    "fi" to "Suomi",
    "fil" to "Filipino",
    "fj" to "Fiji",
    "fo" to "Faroe",
    "fon" to "Fon",
    "fr" to "Prancis",
    "frc" to "Prancis Cajun",
    "frm" to "Prancis Abad Pertengahan",
    "fro" to "Prancis Kuno",
    "frp" to "Arpitan",
    "frr" to "Frisia Utara",
    "frs" to "Frisia Timur",
    "fur" to "Friuli",
    "fy" to "Frisia Barat",
    "ga" to "Irlandia",
    "gaa" to "Ga",
    "gag" to "Gagauz",
    "gay" to "Gayo",
    "gba" to "Gbaya",
    "gd" to "Gaelik Skotlandia",
    "gez" to "Geez",
    "gil" to "Gilbert",
    "gl" to "Galisia",
    "glk" to "Gilaki",
    "gmh" to "Jerman Abad Pertengahan",
    "gn" to "Guarani",
    "goh" to "Jerman Kuno",
    "gon" to "Gondi",
    "gor" to "Gorontalo",
    "got" to "Gotik",
    "grb" to "Grebo",
    "grc" to "Yunani Kuno",
    "gsw" to "Jerman (Swiss)",
    "gu" to "Gujarat",
    "guz" to "Gusii",
    "gv" to "Manx",
    "gwi" to "Gwich’in",
    "ha" to "Hausa",
    "hai" to "Haida",
    "haw" to "Hawaii",
    "hax" to "Haida Selatan",
    "he" to "Ibrani",
    "hi" to "Hindi",
    "hi-Latn-alt-variant" to "Hinglish",
    "hif" to "Hindi Fiji",
    "hil" to "Hiligaynon",
    "hit" to "Hitit",
    "hmn" to "Hmong",
    "ho" to "Hiri Motu",
    "hr" to "Kroasia",
    "hsb" to "Sorbia Hulu",
    "ht" to "Kreol Haiti",
    "hu" to "Hungaria",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Armenia",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Iban",
    "ibb" to "Ibibio",
    "id" to "Indonesia",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Sichuan Yi",
    "ik" to "Inupiak",
    "ikt" to "Inuktitut Kanada Barat",
    "ilo" to "Iloko",
    "inh" to "Ingushetia",
    "io" to "Ido",
    "is" to "Islandia",
    "it" to "Italia",
    "iu" to "Inuktitut",
    "ja" to "Jepang",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jpr" to "Ibrani-Persia",
    "jrb" to "Ibrani-Arab",
    "jv" to "Jawa",
    "ka" to "Georgia",
    "kaa" to "Kara-Kalpak",
    "kab" to "Kabyle",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kaw" to "Kawi",
    "kbd" to "Kabardi",
    "kbl" to "Kanembu",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kabuverdianu",
    "ken" to "Kenyang",
    "kfo" to "Koro",
    "kg" to "Kongo",
    "kgp" to "Kaingang",
    "kha" to "Khasi",
    "kho" to "Khotan",
    "khq" to "Koyra Chiini",
    "ki" to "Kikuyu",
    "kj" to "Kuanyama",
    "kk" to "Kazakh",
    "kkj" to "Kako",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Khmer",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Korea",
    "koi" to "Komi-Permyak",
    "kok" to "Konkani",
    "kos" to "Kosre",
    "kpe" to "Kpelle",
    "kr" to "Kanuri",
    "krc" to "Karachai Balkar",
    "kri" to "Krio",
    "krl" to "Karelia",
    "kru" to "Kuruk",
    "ks" to "Kashmir",
    "ksb" to "Shambala",
    "ksf" to "Bafia",
    "ksh" to "Dialek Kolsch",
    "ku" to "Kurdi",
    "kum" to "Kumyk",
    "kut" to "Kutenai",
    "kv" to "Komi",
    "kw" to "Kornish",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kuvi",
    "ky" to "Kirgiz",
    "la" to "Latin",
    "lad" to "Ladino",
    "lag" to "Langi",
    "lah" to "Lahnda",
    "lam" to "Lamba",
    "lb" to "Luksemburg",
    "lez" to "Lezghia",
    "lg" to "Ganda",
    "li" to "Limburgia",
    "lij" to "Liguria",
    "lil" to "Lillooet",
    "lkt" to "Lakota",
    "lmo" to "Lombard",
    "ln" to "Lingala",
    "lo" to "Lao",
    "lol" to "Mongo",
    "lou" to "Kreol Louisiana",
    "loz" to "Lozi",
    "lrc" to "Luri Utara",
    "lsm" to "Saamia",
    "lt" to "Lituania",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lui" to "Luiseno",
    "lun" to "Lunda",
    "luo" to "Luo",
    "lus" to "Mizo",
    "luy" to "Luyia",
    "lv" to "Latvia",
    "lzz" to "Laz",
    "mad" to "Madura",
    "maf" to "Mafa",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Makasar",
    "man" to "Mandingo",
    "mas" to "Masai",
    "mde" to "Maba",
    "mdf" to "Moksha",
    "mdr" to "Mandar",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisien",
    "mg" to "Malagasi",
    "mga" to "Irlandia Abad Pertengahan",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Meta’",
    "mh" to "Marshall",
    "mi" to "Maori",
    "mic" to "Mikmak",
    "min" to "Minangkabau",
    "mk" to "Makedonia",
    "ml" to "Malayalam",
    "mn" to "Mongolia",
    "mnc" to "Manchuria",
    "mni" to "Manipuri",
    "moe" to "Innu-aimun",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Marathi",
    "ms" to "Melayu",
    "mt" to "Malta",
    "mua" to "Mundang",
    "mul" to "Beberapa Bahasa",
    "mus" to "Bahasa Muskogee",
    "mwl" to "Miranda",
    "mwr" to "Marwari",
    "mwv" to "Mentawai",
    "my" to "Burma",
    "mye" to "Myene",
    "myv" to "Eryza",
    "mzn" to "Mazanderani",
    "na" to "Nauru",
    "nap" to "Neapolitan",
    "naq" to "Nama",
    "nb" to "Bokmål Norwegia",
    "nd" to "Ndebele Utara",
    "nds" to "Jerman Rendah",
    "ne" to "Nepali",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niuea",
    "nl" to "Belanda",
    "nmg" to "Kwasio",
    "nn" to "Nynorsk Norwegia",
    "nnh" to "Ngiemboon",
    "no" to "Norwegia",
    "nog" to "Nogai",
    "non" to "Norse Kuno",
    "nqo" to "N’Ko",
    "nr" to "Ndebele Selatan",
    "nso" to "Sotho Utara",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "nwc" to "Newari Klasik",
    "ny" to "Nyanja",
    "nym" to "Nyamwezi",
    "nyn" to "Nyankole",
    "nyo" to "Nyoro",
    "nzi" to "Nzima",
    "oc" to "Ositania",
    "oj" to "Ojibwa",
    "ojb" to "Ojibwe Barat Laut",
    "ojc" to "Ojibwe Tengah",
    "ojs" to "Oji-Cree",
    "ojw" to "Ojibwe Barat",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Oriya",
    "os" to "Ossetia",
    "osa" to "Osage",
    "ota" to "Turki Osmani",
    "pa" to "Punjabi",
    "pag" to "Pangasina",
    "pal" to "Pahlevi",
    "pam" to "Pampanga",
    "pap" to "Papiamento",
    "pau" to "Palau",
    "pcm" to "Pidgin Nigeria",
    "pdc" to "Jerman Pennsylvania",
    "peo" to "Persia Kuno",
    "phn" to "Funisia",
    "pi" to "Pali",
    "pis" to "Pijin",
    "pl" to "Polski",
    "pon" to "Pohnpeia",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Prusia",
    "pro" to "Provencal Lama",
    "ps" to "Pashto",
    "ps-alt-variant" to "Pushto",
    "pt" to "Portugis",
    "pt-PT" to "Portugis (Eropa)",
    "qu" to "Quechua",
    "quc" to "Kʼicheʼ",
    "raj" to "Rajasthani",
    "rap" to "Rapanui",
    "rar" to "Rarotonga",
    "rhg" to "Rohingya",
    "rm" to "Reto-Roman",
    "rn" to "Rundi",
    "ro" to "Rumania",
    "ro-MD" to "Moldavia",
    "rof" to "Rombo",
    "rom" to "Romani",
    "rtm" to "Rotuma",
    "ru" to "Rusia",
    "rup" to "Aromania",
    "rw" to "Kinyarwanda",
    "rwk" to "Rwa",
    "sa" to "Sanskerta",
    "sad" to "Sandawe",
    "sah" to "Sakha",
    "sam" to "Aram Samaria",
    "saq" to "Samburu",
    "sas" to "Sasak",
    "sat" to "Santali",
    "sba" to "Ngambai",
    "sbp" to "Sangu",
    "sc" to "Sardinia",
    "scn" to "Sisilia",
    "sco" to "Skotlandia",
    "sd" to "Sindhi",
    "sdh" to "Kurdi Selatan",
    "se" to "Sami Utara",
    "see" to "Seneca",
    "seh" to "Sena",
    "sei" to "Seri",
    "sel" to "Selkup",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "sga" to "Irlandia Kuno",
    "sh" to "Serbo-Kroasia",
    "shi" to "Tachelhit",
    "shn" to "Shan",
    "shu" to "Arab Suwa",
    "si" to "Sinhala",
    "sid" to "Sidamo",
    "sk" to "Slovak",
    "sl" to "Slovenia",
    "slh" to "Lushootseed Selatan",
    "sli" to "Silesia Rendah",
    "sly" to "Selayar",
    "sm" to "Samoa",
    "sma" to "Sami Selatan",
    "smj" to "Lule Sami",
    "smn" to "Inari Sami",
    "sms" to "Skolt Sami",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somalia",
    "sog" to "Sogdien",
    "sq" to "Albania",
    "sr" to "Serbia",
    "srn" to "Sranan Tongo",
    "srr" to "Serer",
    "ss" to "Swati",
    "ssy" to "Saho",
    "st" to "Sotho Selatan",
    "str" to "Salish Selat",
    "su" to "Sunda",
    "suk" to "Sukuma",
    "sus" to "Susu",
    "sux" to "Sumeria",
    "sv" to "Swedia",
    "sw" to "Swahili",
    "sw-CD" to "Swahili (Kongo)",
    "swb" to "Komoria",
    "syc" to "Suriah Klasik",
    "syr" to "Suriah",
    "szl" to "Silesia",
    "ta" to "Tamil",
    "tce" to "Tutchone Selatan",
    "tcy" to "Tulu",
    "te" to "Telugu",
    "tem" to "Timne",
    "teo" to "Teso",
    "ter" to "Tereno",
    "tet" to "Tetun",
    "tg" to "Tajik",
    "tgx" to "Tagish",
    "th" to "Thai",
    "tht" to "Tahltan",
    "ti" to "Tigrinya",
    "tig" to "Tigre",
    "tiv" to "Tiv",
    "tk" to "Turkmen",
    "tkl" to "Tokelau",
    "tl" to "Tagalog",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tmh" to "Tamashek",
    "tn" to "Tswana",
    "to" to "Tonga",
    "tog" to "Nyasa Tonga",
    "tok" to "Toki Pona",
    "tpi" to "Tok Pisin",
    "tr" to "Turki",
    "tru" to "Turoyo",
    "trv" to "Taroko",
    "ts" to "Tsonga",
    "tsi" to "Tsimshia",
    "tt" to "Tatar",
    "ttm" to "Tutchone Utara",
    "ttt" to "Tat Muslim",
    "tum" to "Tumbuka",
    "tvl" to "Tuvalu",
    "tw" to "Twi",
    "twq" to "Tasawaq",
    "ty" to "Tahiti",
    "tyv" to "Tuvinia",
    "tzm" to "Tamazight Maroko Tengah",
    "udm" to "Udmurt",
    "ug" to "Uyghur",
    "ug-alt-variant" to "Uighur",
    "uga" to "Ugarit",
    "uk" to "Ukraina",
    "umb" to "Umbundu",
    "und" to "Bahasa Tidak Dikenal",
    "ur" to "Urdu",
    "uz" to "Uzbek",
    "vai" to "Vai",
    "ve" to "Venda",
    "vec" to "Venesia",
    "vi" to "Vietnam",
    "vmw" to "Makhuwa",
    "vo" to "Volapuk",
    "vot" to "Votia",
    "vun" to "Vunjo",
    "wa" to "Walloon",
    "wae" to "Walser",
    "wal" to "Walamo",
    "war" to "Warai",
    "was" to "Washo",
    "wbp" to "Warlpiri",
    "wo" to "Wolof",
    "wuu" to "Wu Tionghoa",
    "xal" to "Kalmuk",
    "xh" to "Xhosa",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yao" to "Yao",
    "yap" to "Yapois",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Yiddish",
    "yo" to "Yoruba",
    "yrl" to "Nheengatu",
    "yue" to "Kanton",
    "yue-alt-menu" to "Tionghoa, Kanton",
    "za" to "Zhuang",
    "zap" to "Zapotek",
    "zbl" to "Blissymbol",
    "zen" to "Zenaga",
    "zgh" to "Tamazight Maroko Standar",
    "zh" to "Tionghoa",
    "zh-alt-menu" to "Tionghoa, Mandarin",
    "zh-Hans-alt-long" to "Tionghoa Mandarin (Sederhana)",
    "zh-Hant-alt-long" to "Tionghoa Mandarin (Tradisional)",
    "zu" to "Zulu",
    "zun" to "Zuni",
    "zxx" to "Tidak ada konten linguistik",
    "zza" to "Zaza",
  ) }

  val ie: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar" to "arabic",
    "cs" to "tchec",
    "da" to "danesi",
    "de" to "german",
    "de-AT" to "austrian german",
    "de-CH" to "sviss alt-german",
    "el" to "grec",
    "en" to "anglesi",
    "es" to "hispan",
    "es-419" to "hispan del latin America",
    "es-ES" to "europan hispan",
    "es-MX" to "mexican hispan",
    "et" to "estonian",
    "fa" to "persian",
    "fr" to "francesi",
    "fr-CH" to "sviss francesi",
    "hu" to "hungarian",
    "id" to "indonesian",
    "ie" to "Interlingue",
    "it" to "italian",
    "ja" to "japanesi",
    "ko" to "korean",
    "lij" to "ligurian",
    "lv" to "lettonian",
    "mt" to "maltesi",
    "nl" to "hollandesi",
    "nl-BE" to "flandrian",
    "pl" to "polonesi",
    "prg" to "prussian",
    "pt" to "portugalesi",
    "pt-BR" to "brasilian portugalesi",
    "pt-PT" to "europan portugalesi",
    "ru" to "russ",
    "sk" to "slovac",
    "sl" to "slovenian",
    "sv" to "sved",
    "sw" to "swahili",
    "tr" to "turc",
    "und" to "ínconosset lingue",
    "zh" to "chinesi",
    "zh-alt-menu" to "chinesi, mandarin",
  ) }

  val ig: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "Afar",
    "ab" to "Abkaziani",
    "ace" to "Achinisi",
    "ada" to "Adangme",
    "ady" to "Adigi",
    "af" to "Afrikaans",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "ale" to "Aleut",
    "alt" to "Southern Altai",
    "am" to "Amariikị",
    "an" to "Aragonisị",
    "ann" to "Obolo",
    "anp" to "Angika",
    "apc" to "apcc",
    "ar" to "Arabiikị",
    "ar-001" to "Ụdị Arabiikị nke oge a",
    "arn" to "Mapuche",
    "arp" to "Arapaho",
    "ars" to "Najdi Arabikị",
    "as" to "Asamisị",
    "asa" to "Asụ",
    "ast" to "Asturianị",
    "atj" to "Atikamekw",
    "av" to "Avarịk",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Azerbaijani",
    "az-alt-short" to "Azeri",
    "ba" to "Bashkir",
    "bal" to "Baluchi",
    "ban" to "Balinese",
    "bas" to "Basaà",
    "be" to "Belarusian",
    "bem" to "Bembà",
    "bew" to "Betawi",
    "bez" to "Bena",
    "bg" to "Bulgarian",
    "bgc" to "Haryanvi",
    "bgn" to "Western Balochi",
    "bho" to "Bojpuri",
    "bi" to "Bislama",
    "bin" to "Bini",
    "bla" to "Siksikà",
    "blo" to "Anii",
    "blt" to "Tai Dam",
    "bm" to "Bambara",
    "bn" to "Bangla",
    "bo" to "Tibetan",
    "br" to "Breton",
    "brx" to "Bodo",
    "bs" to "Bosnian",
    "bss" to "Akoose",
    "bug" to "Buginese",
    "byn" to "Blin",
    "ca" to "Catalan",
    "cad" to "Caddo",
    "cay" to "Cayuga",
    "cch" to "Atsam",
    "ccp" to "Chakma",
    "ce" to "Chechen",
    "ceb" to "Cebuano",
    "cgg" to "Chiga",
    "ch" to "Chamorro",
    "chk" to "Chuukese",
    "chm" to "Mari",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyene",
    "cic" to "Chickasaw",
    "ckb" to "Central Kurdish",
    "ckb-alt-menu" to "Kurdish, Central",
    "ckb-alt-variant" to "Kurdish, Sorani",
    "clc" to "Chilcotin",
    "co" to "Corsican",
    "crg" to "Michif",
    "crj" to "Southern East Cree",
    "crk" to "Plains Cree",
    "crl" to "Northern East Cree",
    "crm" to "Moose Cree",
    "crr" to "Carolina Algonquian",
    "cs" to "Czech",
    "csw" to "Asụsụ Swampy Kree",
    "cu" to "Church slavic",
    "cv" to "Chuvash",
    "cy" to "Welsh",
    "da" to "Danish",
    "dak" to "Dakota",
    "dar" to "Dargwa",
    "dav" to "Taita",
    "de" to "German",
    "de-AT" to "Austrian German",
    "de-CH" to "Swiss High German",
    "dgr" to "Dogrib",
    "dje" to "Zarma",
    "doi" to "Dogri",
    "dsb" to "Lower Sorbian",
    "dua" to "Duala",
    "dv" to "Divehi",
    "dyo" to "Jola-Fonyi",
    "dz" to "Dọzngọka",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "eka" to "Ekajuk",
    "el" to "Grik",
    "en" to "Bekee",
    "en-AU" to "Bekee ndị Australia",
    "en-CA" to "Bekee ndị Canada",
    "en-GB" to "Bekee ndị United Kingdom",
    "en-GB-alt-short" to "Bekee ndị UK",
    "en-US" to "Bekee ndị America",
    "en-US-alt-short" to "Bekee ndị US",
    "eo" to "Esperanto",
    "es" to "Spanish",
    "es-419" to "Spanish ndị Latin America",
    "es-ES" to "Spanish ndị Europe",
    "es-MX" to "Spanish ndị Mexico",
    "et" to "Estonian",
    "eu" to "Basque",
    "ewo" to "Ewondo",
    "fa" to "Asụsụ Persia",
    "fa-AF" to "Dari",
    "ff" to "Fula",
    "fi" to "Finnish",
    "fil" to "Filipino",
    "fj" to "Fijanị",
    "fo" to "Faroese",
    "fon" to "Fon",
    "fr" to "French",
    "fr-CA" to "Canadian French",
    "fr-CH" to "Swiss French",
    "frc" to "Cajun French",
    "frr" to "Northern Frisian",
    "fur" to "Friulian",
    "fy" to "Ọdịda anyanwụ Frisian",
    "ga" to "Irish",
    "gaa" to "Ga",
    "gd" to "Asụsụ Scottish Gaelic",
    "gez" to "Geez",
    "gil" to "Gilbertese",
    "gl" to "Galician",
    "gn" to "Guarani",
    "gor" to "Gorontalo",
    "gsw" to "German Swiss",
    "gu" to "Gujarati",
    "guz" to "Gusii",
    "gv" to "Mansị",
    "gwi" to "Gwichʼin",
    "ha" to "Hausa",
    "hai" to "Haida",
    "haw" to "Hawaịlịan",
    "hax" to "Southern Haida",
    "he" to "Hebrew",
    "hi" to "Hindi",
    "hi-Latn-alt-variant" to "Hinglish",
    "hil" to "Hiligayanon",
    "hmn" to "Hmong",
    "hnj" to "Hmong Njua",
    "hr" to "Croatian",
    "hsb" to "Upper Sorbian",
    "ht" to "Haịtịan ndị Cerọle",
    "hu" to "Hungarian",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Armenianị",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Iban",
    "ibb" to "Ibibio",
    "id" to "Indonesian",
    "ie" to "Interlingue",
    "ig" to "Igbo",
    "ii" to "Sichuan Yi",
    "ikt" to "Westarn Canadian Inuktitut",
    "ilo" to "Iloko",
    "inh" to "Ingush",
    "io" to "Ido",
    "is" to "Icelandic",
    "it" to "Italian",
    "iu" to "Inuktitut",
    "ja" to "Japanese",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jv" to "Javanese",
    "ka" to "Georgian",
    "kaa" to "Kara-Kalpak",
    "kab" to "Kabyle",
    "kac" to "Kachin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kbd" to "Kabadian",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kabụverdịanụ",
    "ken" to "Kenyang",
    "kfo" to "Koro",
    "kgp" to "Kaingang",
    "kha" to "Khasi",
    "khq" to "Koyra Chiini",
    "ki" to "Kikuyu",
    "kj" to "Kuanyama",
    "kk" to "Kazakh",
    "kkj" to "Kako",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Khmer",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Korean",
    "kok" to "Konkani",
    "kpe" to "Kpelle",
    "kr" to "Kanuri",
    "krc" to "Karachay-Balkar",
    "krl" to "Karelian",
    "kru" to "Kurukh",
    "ks" to "Kashmiri",
    "ksb" to "Shambala",
    "ksf" to "Bafịa",
    "ksh" to "Colognian",
    "ku" to "Kurdish",
    "kum" to "Kumik",
    "kv" to "Komi",
    "kw" to "Cornish",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kuvi",
    "ky" to "Kyrgyz",
    "la" to "Latin",
    "lad" to "Ladino",
    "lag" to "Langị",
    "lb" to "Luxembourgish",
    "lez" to "Lezghian",
    "lg" to "Ganda",
    "li" to "Limburgish",
    "lij" to "Ligurian",
    "lil" to "Liloetị",
    "lkt" to "Lakota",
    "lld" to "ID",
    "lmo" to "Lombard",
    "ln" to "Lingala",
    "lo" to "Lao",
    "lou" to "Louisiana Creole",
    "loz" to "Lozi",
    "lrc" to "Northern Luri",
    "lsm" to "Saamia",
    "lt" to "Lithuanian",
    "ltg" to "Latgalian",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lun" to "Lunda",
    "lus" to "Mizo",
    "luy" to "Luyia",
    "lv" to "Latvian",
    "mad" to "Madurese",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Makasar",
    "mas" to "Masai",
    "mdf" to "Moksha",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisyen",
    "mg" to "Malagasy",
    "mgh" to "Makhuwa-Meetto",
    "mgo" to "Meta",
    "mh" to "Marshallese",
    "mhn" to "mhnn",
    "mi" to "Māori",
    "mic" to "Mi'kmaw",
    "min" to "Minangkabau",
    "mk" to "Macedonian",
    "ml" to "Malayalam",
    "mn" to "Mọngolịan",
    "mni" to "Asụsụ Manipuri",
    "moe" to "Innu-aimun",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Asụsụ Marathi",
    "ms" to "Malay",
    "mt" to "Asụsụ Malta",
    "mua" to "Mundang",
    "mul" to "Ọtụtụ asụsụ",
    "mus" to "Muscogee",
    "mwl" to "Mirandese",
    "my" to "Burmese",
    "myv" to "Erzya",
    "mzn" to "Mazanderani",
    "na" to "Nauru",
    "nap" to "Neapolitan",
    "naq" to "Nama",
    "nb" to "Norwegian Bokmål",
    "nd" to "North Ndebele",
    "nds" to "Low German",
    "nds-NL" to "Low Saxon",
    "ne" to "Nepali",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niuean",
    "nl" to "Dutch",
    "nl-BE" to "Flemish",
    "nmg" to "Kwasio",
    "nn" to "Norwegian Nynorsk",
    "nnh" to "Ngiemboon",
    "no" to "Norwegian",
    "nog" to "Nogai",
    "nqo" to "N’Ko",
    "nr" to "South Ndebele",
    "nso" to "Northern Sotho",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "ny" to "Nyanja",
    "nyn" to "Nyankole",
    "oc" to "Asụsụ Osịtan",
    "ojb" to "Northwestern Ojibwa",
    "ojc" to "Central Ojibwa",
    "ojs" to "Oji-Cree",
    "ojw" to "Westarn Ojibwa",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Ọdịa",
    "os" to "Ossetic",
    "osa" to "Osage",
    "pa" to "Punjabi",
    "pag" to "Pangasinan",
    "pam" to "Pampanga",
    "pap" to "Papiamento",
    "pau" to "Palauan",
    "pcm" to "Pidgin ndị Naijirịa",
    "pis" to "Pijin",
    "pl" to "Asụsụ Polish",
    "pqm" to "Maliseet-Passamaquoddy",
    "prg" to "Prụssịan",
    "ps" to "Pashọ",
    "pt" to "Pọrtụgụese",
    "pt-BR" to "Asụsụ Portugese ndị Brazil",
    "pt-PT" to "Asụsụ Portuguese ndị Europe",
    "qu" to "Asụsụ Quechua",
    "quc" to "Kʼicheʼ",
    "raj" to "Rajastani",
    "rap" to "Rapanui",
    "rar" to "Rarotongan",
    "rhg" to "Rohingya",
    "rif" to "Riffian",
    "rm" to "Asụsụ Romansh",
    "rn" to "Rundi",
    "ro" to "Asụsụ Romanian",
    "ro-MD" to "Moldavian",
    "rof" to "Rombo",
    "ru" to "Asụsụ Russia",
    "rup" to "Aromanian",
    "rw" to "Kinyarwanda",
    "rwk" to "Rwa",
    "sa" to "Asụsụ Sanskrit",
    "sad" to "Sandawe",
    "sah" to "Yakut",
    "saq" to "Samburu",
    "sat" to "Asụsụ Santali",
    "sba" to "Ngambay",
    "sbp" to "Sangu",
    "sc" to "Asụsụ Sardini",
    "scn" to "Sicilian",
    "sco" to "Scots",
    "sd" to "Asụsụ Sindhi",
    "sdh" to "Southern Kurdish",
    "se" to "Northern Sami",
    "seh" to "Sena",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "shi" to "Tachịkịt",
    "shn" to "Shan",
    "si" to "Sinhala",
    "sid" to "Sidamo",
    "sk" to "Asụsụ Slovak",
    "skr" to "skrr",
    "sl" to "Asụsụ Slovenia",
    "slh" to "Southern Lushootseed",
    "sm" to "Samoan",
    "sma" to "Southern Sami",
    "smj" to "Lule Sami",
    "smn" to "Inari Sami",
    "sms" to "Skolt sami",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somali",
    "sq" to "Asụsụ Albania",
    "sr" to "Asụsụ Serbia",
    "srn" to "Sranan Tongo",
    "ss" to "Swati",
    "ssy" to "Saho",
    "st" to "Southern Sotho",
    "str" to "Straits Salish",
    "su" to "Asụsụ Sundan",
    "suk" to "Sukuma",
    "sv" to "Sụwidiishi",
    "sw" to "Asụsụ Swahili",
    "swb" to "Comorian",
    "syr" to "Sirịak",
    "szl" to "Asụsụ Sileshia",
    "ta" to "Tamil",
    "tce" to "Southern Tutchone",
    "te" to "Telugu",
    "tem" to "Timne",
    "teo" to "Teso",
    "tet" to "Tetum",
    "tg" to "Tajik",
    "tgx" to "Tagish",
    "th" to "Thai",
    "tht" to "Tahitan",
    "ti" to "Tigrinya",
    "tig" to "Tigre",
    "tk" to "Turkmen",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tn" to "Tswana",
    "to" to "Tongan",
    "tok" to "Toki Pona",
    "tpi" to "Tok pisin",
    "tr" to "Turkish",
    "trv" to "Taroko",
    "trw" to "Torwali",
    "ts" to "Tsonga",
    "tt" to "Asụsụ Tatar",
    "ttm" to "Northern Tutchone",
    "tum" to "Tumbuka",
    "tvl" to "Tuvalu",
    "twq" to "Tasawaq",
    "ty" to "Tahitian",
    "tyv" to "Tuvinian",
    "tzm" to "Central Atlas Tamazight",
    "udm" to "Udmurt",
    "ug" to "Uyghur",
    "uk" to "Asụsụ Ukrain",
    "umb" to "Umbundu",
    "und" to "Asụsụ a na-amaghị",
    "ur" to "Urdu",
    "uz" to "Uzbek",
    "ve" to "Venda",
    "vec" to "Asụsụ Veneshia",
    "vi" to "Vietnamese",
    "vmw" to "Makhuwa",
    "vo" to "Volapük",
    "vun" to "Vunjo",
    "wa" to "Walloon",
    "wae" to "Walser",
    "wal" to "Wolaytta",
    "war" to "Waray",
    "wbp" to "Warlpiri",
    "wo" to "Wolof",
    "wuu" to "Wu Chinese",
    "xal" to "Kalmyk",
    "xh" to "Xhosa",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Yiddish",
    "yo" to "Yoruba",
    "yrl" to "Asụsụ Nheengatu",
    "yue" to "Cantonese",
    "yue-alt-menu" to "Chaịniiz,Cantonese",
    "za" to "Zhuang",
    "zgh" to "Standard Moroccan Tamazight",
    "zh" to "Chaịniiz",
    "zh-alt-menu" to "Chaịniiz, Mandarin",
    "zh-Hans" to "Asụsụ Chaịniiz dị mfe",
    "zh-Hans-alt-long" to "Asụsụ Mandarin Chaịniiz dị mfe",
    "zh-Hant" to "Asụsụ ọdịnala Chaịniiz",
    "zh-Hant-alt-long" to "Asụsụ ọdịnala Mandarin Chaịniiz",
    "zu" to "Zulu",
    "zun" to "Zuni",
    "zxx" to "Enweghị asụsụ dịnaya",
    "zza" to "Zaza",
  ) }

  val ii: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar" to "ꀊꇁꀨꉙ",
    "ar-001" to "ꀊꇁꀨꉙ（ꋧꃅ）",
    "de" to "ꄓꇩꉙ",
    "en" to "ꑱꇩꉙ",
    "es" to "ꑭꀠꑸꉙ",
    "fr" to "ꃔꇩꉙ",
    "hi" to "ꑴꄃꉙ",
    "hi-Latn-alt-variant" to "ꑴꐛꑱꉙ",
    "ii" to "ꆈꌠꉙ",
    "it" to "ꑴꄊꆺꉙ",
    "ja" to "ꏝꀪꉙ",
    "nds" to "ꃅꄷꀁꂥꄓꉙ",
    "nl" to "ꉿꇂꉙ",
    "pt" to "ꁍꄨꑸꉙ",
    "ro" to "ꇆꂷꆀꑸꉙ",
    "ru" to "ꊉꇩꉙ",
    "sw" to "ꌖꑟꆺꉙ",
    "und" to "ꅉꀋꌠꅇꂷ",
    "zh" to "ꍏꇩꉙ",
    "zh-alt-menu" to "ꍏꇩꉙ",
  ) }

  val io: ImmutableMap<String, String> by lazy { immutableMapOf(
    "io" to "Ido",
  ) }

  val `is`: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afár",
    "ab" to "abkasíska",
    "ace" to "akkíska",
    "ach" to "acoli",
    "ada" to "adangme",
    "ady" to "adýge",
    "ae" to "avestíska",
    "af" to "afríkanska",
    "afh" to "afríhílí",
    "agq" to "aghem",
    "ain" to "aínu (Japan)",
    "ak" to "akan",
    "akk" to "akkadíska",
    "ale" to "aleúska",
    "alt" to "suðuraltaíska",
    "am" to "amharíska",
    "an" to "aragonska",
    "ang" to "fornenska",
    "ann" to "obolo",
    "anp" to "angíka",
    "ar" to "arabíska",
    "ar-001" to "stöðluð nútímaarabíska",
    "arc" to "arameíska",
    "arn" to "mapuche",
    "arp" to "arapahó",
    "ars" to "najdi-arabíska",
    "arw" to "aravakska",
    "as" to "assamska",
    "asa" to "asu",
    "ast" to "astúríska",
    "atj" to "atikamekw",
    "av" to "avaríska",
    "awa" to "avadí",
    "ay" to "aímara",
    "az" to "aserska",
    "az-alt-short" to "aserska",
    "ba" to "baskír",
    "bal" to "balúkí",
    "ban" to "balíska",
    "bas" to "basa",
    "bax" to "bamun",
    "be" to "hvítrússneska",
    "bej" to "beja",
    "bem" to "bemba",
    "bez" to "bena",
    "bg" to "búlgarska",
    "bgc" to "haryanví",
    "bgn" to "vesturbalotsí",
    "bho" to "bojpúrí",
    "bi" to "bíslama",
    "bik" to "bíkol",
    "bin" to "bíní",
    "bla" to "siksika",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bengalska",
    "bo" to "tíbeska",
    "br" to "bretónska",
    "bra" to "braí",
    "brx" to "bódó",
    "bs" to "bosníska",
    "bss" to "bakossi",
    "bua" to "búríat",
    "bug" to "búgíska",
    "byn" to "blín",
    "ca" to "katalónska",
    "cad" to "kaddó",
    "car" to "karíbamál",
    "cay" to "kajúga",
    "cch" to "atsam",
    "ccp" to "tsjakma",
    "ce" to "tsjetsjenska",
    "ceb" to "kebúanó",
    "cgg" to "kíga",
    "ch" to "kamorró",
    "chb" to "síbsja",
    "chg" to "sjagataí",
    "chk" to "sjúkíska",
    "chm" to "marí",
    "chn" to "sínúk",
    "cho" to "sjoktá",
    "chp" to "sípevíska",
    "chr" to "Cherokee-mál",
    "chy" to "sjeyen",
    "ckb" to "miðkúrdíska",
    "ckb-alt-menu" to "miðkúrdíska",
    "ckb-alt-variant" to "miðkúrdíska",
    "clc" to "chilcotin",
    "co" to "korsíska",
    "cop" to "koptíska",
    "cr" to "krí",
    "crg" to "michif",
    "crh" to "krímtyrkneska",
    "crj" to "suðaustur-cree",
    "crk" to "nehiyawak",
    "crl" to "norðaustur-cree",
    "crm" to "moose cree",
    "crr" to "Karólínu-algonkvínska",
    "crs" to "seychelles-kreólska",
    "cs" to "tékkneska",
    "csb" to "kasúbíska",
    "csw" to "maskekon",
    "cu" to "kirkjuslavneska",
    "cv" to "sjúvas",
    "cy" to "velska",
    "da" to "danska",
    "dak" to "dakóta",
    "dar" to "dargva",
    "dav" to "taíta",
    "de" to "þýska",
    "de-AT" to "austurrísk þýska",
    "de-CH" to "svissnesk háþýska",
    "del" to "delaver",
    "den" to "slavneska",
    "dgr" to "dogríb",
    "din" to "dinka",
    "dje" to "zarma",
    "doi" to "dogrí",
    "dsb" to "lágsorbneska",
    "dua" to "dúala",
    "dum" to "miðhollenska",
    "dv" to "dívehí",
    "dyo" to "jola-fonyi",
    "dyu" to "djúla",
    "dz" to "dsongka",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efík",
    "egy" to "fornegypska",
    "eka" to "ekajúk",
    "el" to "gríska",
    "elx" to "elamít",
    "en" to "enska",
    "en-AU" to "áströlsk enska",
    "en-CA" to "kanadísk enska",
    "en-GB" to "bresk enska",
    "en-GB-alt-short" to "enska (bresk)",
    "en-US" to "bandarísk enska",
    "en-US-alt-short" to "enska (BNA)",
    "enm" to "miðenska",
    "eo" to "esperantó",
    "es" to "spænska",
    "es-419" to "rómönsk-amerísk spænska",
    "es-ES" to "evrópsk spænska",
    "es-MX" to "mexíkósk spænska",
    "et" to "eistneska",
    "eu" to "baskneska",
    "ewo" to "evondó",
    "fa" to "persneska",
    "fa-AF" to "darí",
    "fan" to "fang",
    "fat" to "fantí",
    "ff" to "fúla",
    "fi" to "finnska",
    "fil" to "filippseyska",
    "fj" to "fídjeyska",
    "fo" to "færeyska",
    "fon" to "fón",
    "fr" to "franska",
    "fr-CA" to "kanadísk franska",
    "fr-CH" to "svissnesk franska",
    "frc" to "cajun-franska",
    "frm" to "miðfranska",
    "fro" to "fornfranska",
    "frr" to "norðurfrísneska",
    "frs" to "austurfrísneska",
    "fur" to "fríúlska",
    "fy" to "vesturfrísneska",
    "ga" to "írska",
    "gaa" to "ga",
    "gag" to "gagás",
    "gan" to "gan",
    "gay" to "gajó",
    "gba" to "gbaja",
    "gd" to "skosk gelíska",
    "gez" to "gís",
    "gil" to "gilberska",
    "gl" to "galisíska",
    "gmh" to "miðháþýska",
    "gn" to "gvaraní",
    "goh" to "fornháþýska",
    "gon" to "gondí",
    "gor" to "gorontaló",
    "got" to "gotneska",
    "grb" to "gerbó",
    "grc" to "forngríska",
    "gsw" to "svissnesk þýska",
    "gu" to "gújaratí",
    "guz" to "gusii",
    "gv" to "manska",
    "gwi" to "gvísín",
    "ha" to "hása",
    "hai" to "haída",
    "haw" to "havaíska",
    "hax" to "suður-haída",
    "he" to "hebreska",
    "hi" to "hindí",
    "hi-Latn-alt-variant" to "hinglish",
    "hil" to "híligaínon",
    "hit" to "hettitíska",
    "hmn" to "hmong",
    "ho" to "hírímótú",
    "hr" to "króatíska",
    "hsb" to "hásorbneska",
    "ht" to "haítíska",
    "hu" to "ungverska",
    "hup" to "húpa",
    "hur" to "halkomelem",
    "hy" to "armenska",
    "hz" to "hereró",
    "ia" to "interlingua",
    "iba" to "íban",
    "ibb" to "ibibio",
    "id" to "indónesíska",
    "ie" to "interlingve",
    "ig" to "ígbó",
    "ii" to "sísúanjí",
    "ik" to "ínúpíak",
    "ikt" to "vestur-kanadískt inúktitút",
    "ilo" to "ílokó",
    "inh" to "ingús",
    "io" to "ídó",
    "is" to "íslenska",
    "it" to "ítalska",
    "iu" to "inúktitút",
    "ja" to "japanska",
    "jbo" to "lojban",
    "jgo" to "ngomba",
    "jmc" to "masjáme",
    "jpr" to "gyðingapersneska",
    "jrb" to "gyðingaarabíska",
    "jv" to "javanska",
    "ka" to "georgíska",
    "kaa" to "karakalpak",
    "kab" to "kabíle",
    "kac" to "kasín",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kaví",
    "kbd" to "kabardíska",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "grænhöfðeyska",
    "kfo" to "koro",
    "kg" to "kongóska",
    "kgp" to "kaingang",
    "kha" to "kasí",
    "kho" to "kotaska",
    "khq" to "koyra chiini",
    "ki" to "kíkújú",
    "kj" to "kúanjama",
    "kk" to "kasakska",
    "kkj" to "kako",
    "kl" to "grænlenska",
    "kln" to "kalenjin",
    "km" to "kmer",
    "kmb" to "kimbúndú",
    "kn" to "kannada",
    "ko" to "kóreska",
    "koi" to "kómí-permyak",
    "kok" to "konkaní",
    "kos" to "kosraska",
    "kpe" to "kpelle",
    "kr" to "kanúrí",
    "krc" to "karasaíbalkar",
    "krl" to "karélska",
    "kru" to "kúrúk",
    "ks" to "kasmírska",
    "ksb" to "sjambala",
    "ksf" to "bafía",
    "ksh" to "kölníska",
    "ku" to "kúrdíska",
    "kum" to "kúmík",
    "kut" to "kútenaí",
    "kv" to "komíska",
    "kw" to "kornbreska",
    "kwk" to "kwakʼwala",
    "kxv" to "kúví",
    "ky" to "kirgiska",
    "la" to "latína",
    "lad" to "ladínska",
    "lag" to "langí",
    "lah" to "landa",
    "lam" to "lamba",
    "lb" to "lúxemborgíska",
    "lez" to "lesgíska",
    "lg" to "ganda",
    "li" to "limbúrgíska",
    "lij" to "lígúríska",
    "lil" to "lillooet",
    "lkt" to "lakóta",
    "lmo" to "lombardíska",
    "ln" to "lingala",
    "lo" to "laó",
    "lol" to "mongó",
    "lou" to "kreólska (Louisiana)",
    "loz" to "lozi",
    "lrc" to "norðurlúrí",
    "lsm" to "saamia",
    "lt" to "litháíska",
    "lu" to "lúbakatanga",
    "lua" to "luba-lulua",
    "lui" to "lúisenó",
    "lun" to "lúnda",
    "luo" to "lúó",
    "lus" to "lúsaí",
    "luy" to "luyia",
    "lv" to "lettneska",
    "mad" to "madúrska",
    "mag" to "magahí",
    "mai" to "maítílí",
    "mak" to "makasar",
    "man" to "mandingó",
    "mas" to "masaí",
    "mdf" to "moksa",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "merú",
    "mfe" to "máritíska",
    "mg" to "malagasíska",
    "mga" to "miðírska",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta’",
    "mh" to "marshallska",
    "mi" to "maorí",
    "mic" to "mikmak",
    "min" to "mínangkabá",
    "mk" to "makedónska",
    "ml" to "malajalam",
    "mn" to "mongólska",
    "mnc" to "mansjú",
    "mni" to "manípúrí",
    "moe" to "innu-aimun",
    "moh" to "móhíska",
    "mos" to "mossí",
    "mr" to "maratí",
    "ms" to "malaíska",
    "mt" to "maltneska",
    "mua" to "mundang",
    "mul" to "mörg tungumál",
    "mus" to "krík",
    "mwl" to "mirandesíska",
    "mwr" to "marvarí",
    "my" to "búrmneska",
    "myv" to "ersja",
    "mzn" to "masanderaní",
    "na" to "nárúska",
    "nap" to "napólíska",
    "naq" to "nama",
    "nb" to "norskt bókmál",
    "nd" to "norður-ndebele",
    "nds" to "lágþýska; lágsaxneska",
    "nds-NL" to "lágsaxneska",
    "ne" to "nepalska",
    "new" to "nevarí",
    "ng" to "ndonga",
    "nia" to "nías",
    "niu" to "níveska",
    "nl" to "hollenska",
    "nl-BE" to "flæmska",
    "nmg" to "kwasio",
    "nn" to "nýnorska",
    "nnh" to "ngiemboon",
    "no" to "norska",
    "nog" to "nógaí",
    "non" to "norræna",
    "nqo" to "n’ko",
    "nr" to "suðurndebele",
    "nso" to "norðursótó",
    "nus" to "núer",
    "nv" to "navahó",
    "nwc" to "klassísk nevaríska",
    "ny" to "nýanja",
    "nym" to "njamvesí",
    "nyn" to "nyankole",
    "nyo" to "njóró",
    "nzi" to "nsíma",
    "oc" to "oksítaníska",
    "oj" to "ojibva",
    "ojb" to "norðvestur-ojibwa",
    "ojc" to "ojibwa",
    "ojs" to "oji-cree",
    "ojw" to "vestur-ojibwa",
    "oka" to "okanagan",
    "om" to "oromo",
    "or" to "óría",
    "os" to "ossetíska",
    "osa" to "ósage",
    "ota" to "tyrkneska, ottóman",
    "pa" to "púnjabí",
    "pag" to "pangasínmál",
    "pal" to "palaví",
    "pam" to "pampanga",
    "pap" to "papíamentó",
    "pau" to "paláska",
    "pcm" to "nígerískt pidgin",
    "peo" to "fornpersneska",
    "phn" to "fönikíska",
    "pi" to "palí",
    "pis" to "pijin",
    "pl" to "pólska",
    "pon" to "ponpeiska",
    "pqm" to "maliseet-passamaquoddy",
    "prg" to "prússneska",
    "pro" to "fornpróvensalska",
    "ps" to "pastú",
    "pt" to "portúgalska",
    "pt-BR" to "brasílísk portúgalska",
    "pt-PT" to "evrópsk portúgalska",
    "qu" to "kvesjúa",
    "quc" to "kiche",
    "raj" to "rajastaní",
    "rap" to "rapanúí",
    "rar" to "rarótongska",
    "rhg" to "rohingja",
    "rm" to "rómanska",
    "rn" to "rúndí",
    "ro" to "rúmenska",
    "ro-MD" to "moldóvska",
    "rof" to "rombó",
    "rom" to "romaní",
    "ru" to "rússneska",
    "rup" to "arúmenska",
    "rw" to "kínjarvanda",
    "rwk" to "rúa",
    "sa" to "sanskrít",
    "sad" to "sandave",
    "sah" to "jakút",
    "sam" to "samversk arameíska",
    "saq" to "sambúrú",
    "sas" to "sasak",
    "sat" to "santalí",
    "sba" to "ngambay",
    "sbp" to "sangú",
    "sc" to "sardínska",
    "scn" to "sikileyska",
    "sco" to "skoska",
    "sd" to "sindí",
    "sdh" to "suðurkúrdíska",
    "se" to "norðursamíska",
    "seh" to "sena",
    "sel" to "selkúp",
    "ses" to "koíraboró-senní",
    "sg" to "sangó",
    "sga" to "fornírska",
    "sh" to "serbókróatíska",
    "shi" to "tachelhit",
    "shn" to "sjan",
    "si" to "singalíska",
    "sid" to "sídamó",
    "sk" to "slóvakíska",
    "sl" to "slóvenska",
    "slh" to "suður-lushootseed",
    "sm" to "samóska",
    "sma" to "suðursamíska",
    "smj" to "lúlesamíska",
    "smn" to "enaresamíska",
    "sms" to "skoltesamíska",
    "sn" to "shona",
    "snk" to "sóninke",
    "so" to "sómalska",
    "sog" to "sogdíen",
    "sq" to "albanska",
    "sr" to "serbneska",
    "srn" to "sranan tongo",
    "srr" to "serer",
    "ss" to "svatí",
    "ssy" to "saho",
    "st" to "suðursótó",
    "str" to "Straits-salisíanska",
    "su" to "súndanska",
    "suk" to "súkúma",
    "sus" to "súsú",
    "sux" to "súmerska",
    "sv" to "sænska",
    "sw" to "svahílí",
    "sw-CD" to "kongósvahílí",
    "swb" to "shimaoríska",
    "syc" to "klassísk sýrlenska",
    "syr" to "sýrlenska",
    "szl" to "slesíska",
    "ta" to "tamílska",
    "tce" to "suður-tutchone",
    "te" to "telúgú",
    "tem" to "tímne",
    "teo" to "tesó",
    "ter" to "terenó",
    "tet" to "tetúm",
    "tg" to "tadsjikska",
    "tgx" to "tagíska",
    "th" to "taílenska",
    "tht" to "tahltan",
    "ti" to "tígrinja",
    "tig" to "tígre",
    "tiv" to "tív",
    "tk" to "túrkmenska",
    "tkl" to "tókeláska",
    "tl" to "tagalog",
    "tlh" to "klingonska",
    "tli" to "tlingit",
    "tmh" to "tamasjek",
    "tn" to "tsúana",
    "to" to "tongverska",
    "tog" to "tongverska (nyasa)",
    "tok" to "toki pona",
    "tpi" to "tokpisin",
    "tr" to "tyrkneska",
    "trv" to "tarókó",
    "ts" to "tsonga",
    "tsi" to "tsimsíska",
    "tt" to "tatarska",
    "ttm" to "norður-tutchone",
    "tum" to "túmbúka",
    "tvl" to "túvalúska",
    "tw" to "tví",
    "twq" to "tasawaq",
    "ty" to "tahítíska",
    "tyv" to "túvínska",
    "tzm" to "tamazight",
    "udm" to "údmúrt",
    "ug" to "úígúr",
    "uga" to "úgarítíska",
    "uk" to "úkraínska",
    "umb" to "úmbúndú",
    "und" to "óþekkt tungumál",
    "ur" to "úrdú",
    "uz" to "úsbekska",
    "vai" to "vaí",
    "ve" to "venda",
    "vec" to "feneyska",
    "vi" to "víetnamska",
    "vmw" to "makúva",
    "vo" to "volapyk",
    "vot" to "votíska",
    "vun" to "vunjó",
    "wa" to "vallónska",
    "wae" to "valser",
    "wal" to "volayatta",
    "war" to "varaí",
    "was" to "vasjó",
    "wbp" to "varlpiri",
    "wo" to "volof",
    "wuu" to "wu-kínverska",
    "xal" to "kalmúkska",
    "xh" to "sósa",
    "xnr" to "kangrí",
    "xog" to "sóga",
    "yao" to "jaó",
    "yap" to "japíska",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "jiddíska",
    "yo" to "jórúba",
    "yrl" to "nheengatu",
    "yue" to "kantónska",
    "yue-alt-menu" to "kínverska, kantónska",
    "za" to "súang",
    "zap" to "sapótek",
    "zbl" to "blisstákn",
    "zen" to "senaga",
    "zgh" to "staðlað marokkóskt tamazight",
    "zh" to "kínverska",
    "zh-alt-menu" to "kínverska, mandarín",
    "zh-Hans" to "kínverska (einfölduð)",
    "zh-Hans-alt-long" to "mandarín (einfölduð)",
    "zh-Hant" to "kínverska (hefðbundin)",
    "zh-Hant-alt-long" to "mandarín (hefðbundin)",
    "zu" to "súlú",
    "zun" to "súní",
    "zxx" to "ekkert tungumálaefni",
    "zza" to "zázáíska",
  ) }

  val it: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "abcaso",
    "ace" to "accinese",
    "ach" to "acioli",
    "ada" to "adangme",
    "ady" to "adyghe",
    "ae" to "avestan",
    "aeb" to "arabo tunisino",
    "af" to "afrikaans",
    "afh" to "afrihili",
    "agq" to "aghem",
    "ain" to "ainu",
    "ak" to "akan",
    "akk" to "accado",
    "akz" to "alabama",
    "ale" to "aleuto",
    "aln" to "albanese ghego",
    "alt" to "altai meridionale",
    "am" to "amarico",
    "an" to "aragonese",
    "ang" to "inglese antico",
    "ann" to "obolo",
    "anp" to "angika",
    "ar" to "arabo",
    "ar-001" to "arabo moderno standard",
    "arc" to "aramaico",
    "arn" to "mapudungun",
    "aro" to "araona",
    "arp" to "arapaho",
    "arq" to "arabo algerino",
    "ars" to "arabo najd",
    "arw" to "aruaco",
    "ary" to "arabo marocchino",
    "arz" to "arabo egiziano",
    "as" to "assamese",
    "asa" to "asu",
    "ase" to "lingua dei segni americana",
    "ast" to "asturiano",
    "atj" to "atikamekw",
    "av" to "avaro",
    "avk" to "kotava",
    "awa" to "awadhi",
    "ay" to "aymara",
    "az" to "azerbaigiano",
    "az-alt-short" to "azero",
    "ba" to "baschiro",
    "bal" to "beluci",
    "ban" to "balinese",
    "bar" to "bavarese",
    "bas" to "basa",
    "bax" to "bamun",
    "bbc" to "batak toba",
    "bbj" to "ghomala",
    "be" to "bielorusso",
    "bej" to "begia",
    "bem" to "wemba",
    "bew" to "betawi",
    "bez" to "bena",
    "bfd" to "bafut",
    "bfq" to "badaga",
    "bg" to "bulgaro",
    "bgc" to "haryanvi",
    "bgn" to "beluci occidentale",
    "bho" to "bhojpuri",
    "bi" to "bislama",
    "bik" to "bicol",
    "bin" to "bini",
    "bjn" to "banjar",
    "bkm" to "kom",
    "bla" to "siksika",
    "blo" to "anii",
    "bm" to "bambara",
    "bn" to "bengalese",
    "bo" to "tibetano",
    "bpy" to "bishnupriya",
    "bqi" to "bakhtiari",
    "br" to "bretone",
    "bra" to "braj",
    "brh" to "brahui",
    "brx" to "bodo",
    "bs" to "bosniaco",
    "bss" to "akoose",
    "bua" to "buriat",
    "bug" to "bugi",
    "bum" to "bulu",
    "byn" to "blin",
    "byv" to "medumba",
    "ca" to "catalano",
    "cad" to "caddo",
    "car" to "caribico",
    "cay" to "cayuga",
    "cch" to "atsam",
    "ccp" to "chakma",
    "ce" to "ceceno",
    "ceb" to "cebuano",
    "cgg" to "chiga",
    "ch" to "chamorro",
    "chb" to "chibcha",
    "chg" to "ciagataico",
    "chk" to "chuukese",
    "chm" to "mari",
    "chn" to "gergo chinook",
    "cho" to "choctaw",
    "chp" to "chipewyan",
    "chr" to "cherokee",
    "chy" to "cheyenne",
    "ckb" to "curdo centrale",
    "ckb-alt-menu" to "curdo (centrale)",
    "ckb-alt-variant" to "curdo (sorani)",
    "clc" to "chilcotin",
    "co" to "corso",
    "cop" to "copto",
    "cps" to "capiznon",
    "cr" to "cree",
    "crg" to "métchif",
    "crh" to "turco crimeo",
    "crj" to "cree sud-orientale",
    "crk" to "cree delle pianure",
    "crl" to "cree nord-orientale",
    "crm" to "cree moose",
    "crr" to "algonchino della Carolina",
    "crs" to "creolo delle Seychelles",
    "cs" to "ceco",
    "csb" to "kashubian",
    "csw" to "cree delle paludi",
    "cu" to "slavo ecclesiastico",
    "cv" to "ciuvascio",
    "cy" to "gallese",
    "da" to "danese",
    "dak" to "dakota",
    "dar" to "dargwa",
    "dav" to "taita",
    "de" to "tedesco",
    "de-AT" to "tedesco austriaco",
    "de-CH" to "alto tedesco svizzero",
    "del" to "delaware",
    "den" to "slave",
    "dgr" to "dogrib",
    "din" to "dinca",
    "dje" to "zarma",
    "doi" to "dogri",
    "dsb" to "basso sorabo",
    "dtp" to "dusun centrale",
    "dua" to "duala",
    "dum" to "olandese medio",
    "dv" to "divehi",
    "dyo" to "jola-fony",
    "dyu" to "diula",
    "dz" to "dzongkha",
    "dzg" to "dazaga",
    "ebu" to "embu",
    "ee" to "ewe",
    "efi" to "efik",
    "egl" to "emiliano",
    "egy" to "egiziano antico",
    "eka" to "ekajuka",
    "el" to "greco",
    "elx" to "elamitico",
    "en" to "inglese",
    "en-AU" to "inglese australiano",
    "en-CA" to "inglese canadese",
    "en-GB" to "inglese britannico",
    "en-GB-alt-short" to "inglese (GB)",
    "en-US" to "inglese americano",
    "en-US-alt-short" to "inglese (USA)",
    "enm" to "inglese medio",
    "eo" to "esperanto",
    "es" to "spagnolo",
    "es-419" to "spagnolo latinoamericano",
    "es-ES" to "spagnolo europeo",
    "es-MX" to "spagnolo messicano",
    "esu" to "yupik centrale",
    "et" to "estone",
    "eu" to "basco",
    "ewo" to "ewondo",
    "ext" to "estremegno",
    "fa" to "persiano",
    "fa-AF" to "dari",
    "fan" to "fang",
    "fat" to "fanti",
    "ff" to "fulah",
    "fi" to "finlandese",
    "fil" to "filippino",
    "fit" to "finlandese del Tornedalen",
    "fj" to "figiano",
    "fo" to "faroese",
    "fon" to "fon",
    "fr" to "francese",
    "fr-CA" to "francese canadese",
    "fr-CH" to "francese svizzero",
    "frc" to "francese cajun",
    "frm" to "francese medio",
    "fro" to "francese antico",
    "frp" to "francoprovenzale",
    "frr" to "frisone settentrionale",
    "frs" to "frisone orientale",
    "fur" to "friulano",
    "fy" to "frisone occidentale",
    "ga" to "irlandese",
    "gaa" to "ga",
    "gag" to "gagauzo",
    "gan" to "gan",
    "gay" to "gayo",
    "gba" to "gbaya",
    "gbz" to "dari zoroastriano",
    "gd" to "gaelico scozzese",
    "gez" to "geez",
    "gil" to "gilbertese",
    "gl" to "galiziano",
    "glk" to "gilaki",
    "gmh" to "tedesco medio alto",
    "gn" to "guaraní",
    "goh" to "tedesco antico alto",
    "gon" to "gondi",
    "gor" to "gorontalo",
    "got" to "gotico",
    "grb" to "grebo",
    "grc" to "greco antico",
    "gsw" to "tedesco svizzero",
    "gu" to "gujarati",
    "guc" to "wayuu",
    "guz" to "gusii",
    "gv" to "mannese",
    "gwi" to "gwichʼin",
    "ha" to "hausa",
    "hai" to "haida",
    "hak" to "hakka",
    "haw" to "hawaiano",
    "hax" to "haida meridionale",
    "he" to "ebraico",
    "hi" to "hindi",
    "hi-Latn-alt-variant" to "hinglish",
    "hif" to "hindi figiano",
    "hil" to "ilongo",
    "hit" to "hittite",
    "hmn" to "hmong",
    "ho" to "hiri motu",
    "hr" to "croato",
    "hsb" to "alto sorabo",
    "hsn" to "xiang",
    "ht" to "creolo haitiano",
    "hu" to "ungherese",
    "hup" to "hupa",
    "hur" to "halkomelem",
    "hy" to "armeno",
    "hz" to "herero",
    "ia" to "interlingua",
    "iba" to "iban",
    "ibb" to "ibibio",
    "id" to "indonesiano",
    "ie" to "interlingue",
    "ig" to "igbo",
    "ii" to "sichuan yi",
    "ik" to "inupiak",
    "ikt" to "inuktitut canadese occidentale",
    "ilo" to "ilocano",
    "inh" to "ingush",
    "io" to "ido",
    "is" to "islandese",
    "it" to "italiano",
    "iu" to "inuktitut",
    "izh" to "ingrico",
    "ja" to "giapponese",
    "jam" to "creolo giamaicano",
    "jbo" to "lojban",
    "jgo" to "ngamambo",
    "jmc" to "machame",
    "jpr" to "giudeo persiano",
    "jrb" to "giudeo arabo",
    "jut" to "jutlandico",
    "jv" to "giavanese",
    "ka" to "georgiano",
    "kaa" to "kara-kalpak",
    "kab" to "cabilo",
    "kac" to "kachin",
    "kaj" to "jju",
    "kam" to "kamba",
    "kaw" to "kawi",
    "kbd" to "cabardino",
    "kbl" to "kanembu",
    "kcg" to "tyap",
    "kde" to "makonde",
    "kea" to "capoverdiano",
    "kfo" to "koro",
    "kg" to "kongo",
    "kgp" to "kaingang",
    "kha" to "khasi",
    "kho" to "khotanese",
    "khq" to "koyra chiini",
    "khw" to "khowar",
    "ki" to "kikuyu",
    "kiu" to "kirmanjki",
    "kj" to "kuanyama",
    "kk" to "kazako",
    "kkj" to "kako",
    "kl" to "groenlandese",
    "kln" to "kalenjin",
    "km" to "khmer",
    "kmb" to "kimbundu",
    "kn" to "kannada",
    "ko" to "coreano",
    "koi" to "permiaco",
    "kok" to "konkani",
    "kos" to "kosraean",
    "kpe" to "kpelle",
    "kr" to "kanuri",
    "krc" to "karachay-Balkar",
    "krl" to "careliano",
    "kru" to "kurukh",
    "ks" to "kashmiri",
    "ksb" to "shambala",
    "ksf" to "bafia",
    "ksh" to "coloniese",
    "ku" to "curdo",
    "kum" to "kumyk",
    "kut" to "kutenai",
    "kv" to "komi",
    "kw" to "cornico",
    "kwk" to "kwakʼwala",
    "kxv" to "kuvi",
    "ky" to "kirghiso",
    "la" to "latino",
    "lad" to "giudeo-spagnolo",
    "lag" to "langi",
    "lah" to "lahnda",
    "lam" to "lamba",
    "lb" to "lussemburghese",
    "lez" to "lesgo",
    "lfn" to "Lingua Franca Nova",
    "lg" to "ganda",
    "li" to "limburghese",
    "lij" to "ligure",
    "lil" to "lillooet",
    "liv" to "livone",
    "lkt" to "lakota",
    "lld" to "ladino",
    "lmo" to "lombardo",
    "ln" to "lingala",
    "lo" to "lao",
    "lol" to "lolo bantu",
    "lou" to "creolo della Louisiana",
    "loz" to "lozi",
    "lrc" to "luri settentrionale",
    "lsm" to "samia",
    "lt" to "lituano",
    "ltg" to "letgallo",
    "lu" to "luba-katanga",
    "lua" to "luba-lulua",
    "lui" to "luiseno",
    "lun" to "lunda",
    "lus" to "lushai",
    "luy" to "luyia",
    "lv" to "lettone",
    "lzh" to "cinese classico",
    "lzz" to "laz",
    "mad" to "madurese",
    "maf" to "mafa",
    "mag" to "magahi",
    "mai" to "maithili",
    "mak" to "makasar",
    "man" to "mandingo",
    "mas" to "masai",
    "mde" to "maba",
    "mdf" to "moksha",
    "mdr" to "mandar",
    "men" to "mende",
    "mer" to "meru",
    "mfe" to "creolo mauriziano",
    "mg" to "malgascio",
    "mga" to "irlandese medio",
    "mgh" to "makhuwa-meetto",
    "mgo" to "meta’",
    "mh" to "marshallese",
    "mi" to "maori",
    "mic" to "micmac",
    "min" to "menangkabau",
    "mk" to "macedone",
    "ml" to "malayalam",
    "mn" to "mongolo",
    "mnc" to "manchu",
    "mni" to "manipuri",
    "moe" to "innu-aimun",
    "moh" to "mohawk",
    "mos" to "mossi",
    "mr" to "marathi",
    "mrj" to "mari occidentale",
    "ms" to "malese",
    "mt" to "maltese",
    "mua" to "mundang",
    "mul" to "multilingua",
    "mus" to "creek",
    "mwl" to "mirandese",
    "mwr" to "marwari",
    "mwv" to "mentawai",
    "my" to "birmano",
    "mye" to "myene",
    "myv" to "erzya",
    "mzn" to "mazandarani",
    "na" to "nauru",
    "nan" to "min nan",
    "nap" to "napoletano",
    "naq" to "nama",
    "nb" to "norvegese bokmål",
    "nd" to "ndebele del nord",
    "nds" to "basso tedesco",
    "nds-NL" to "basso tedesco olandese",
    "ne" to "nepalese",
    "new" to "newari",
    "ng" to "ndonga",
    "nia" to "nias",
    "niu" to "niue",
    "njo" to "ao",
    "nl" to "olandese",
    "nl-BE" to "fiammingo",
    "nmg" to "kwasio",
    "nn" to "norvegese nynorsk",
    "nnh" to "ngiemboon",
    "no" to "norvegese",
    "nog" to "nogai",
    "non" to "norse antico",
    "nov" to "novial",
    "nqo" to "n’ko",
    "nr" to "ndebele del sud",
    "nso" to "sotho del nord",
    "nus" to "nuer",
    "nv" to "navajo",
    "nwc" to "newari classico",
    "ny" to "nyanja",
    "nym" to "nyamwezi",
    "nyn" to "nyankole",
    "nyo" to "nyoro",
    "nzi" to "nzima",
    "oc" to "occitano",
    "oj" to "ojibwa",
    "ojb" to "ojibwe nord-occidentale",
    "ojc" to "ojibwe centrale",
    "ojs" to "oji-cree",
    "ojw" to "ojibwe occidentale",
    "oka" to "okanagan",
    "om" to "oromo",
    "or" to "odia",
    "os" to "ossetico",
    "osa" to "osage",
    "ota" to "turco ottomano",
    "pa" to "punjabi",
    "pag" to "pangasinan",
    "pal" to "pahlavi",
    "pam" to "pampanga",
    "pap" to "papiamento",
    "pau" to "palau",
    "pcd" to "piccardo",
    "pcm" to "pidgin nigeriano",
    "pdc" to "tedesco della Pennsylvania",
    "peo" to "persiano antico",
    "pfl" to "tedesco palatino",
    "phn" to "fenicio",
    "pi" to "pali",
    "pis" to "pijin",
    "pl" to "polacco",
    "pms" to "piemontese",
    "pnt" to "pontico",
    "pon" to "ponape",
    "pqm" to "malecite-passamaquoddy",
    "prg" to "prussiano",
    "pro" to "provenzale antico",
    "ps" to "pashto",
    "pt" to "portoghese",
    "pt-BR" to "portoghese brasiliano",
    "pt-PT" to "portoghese europeo",
    "qu" to "quechua",
    "quc" to "k’iche’",
    "qug" to "quechua dell’altopiano del Chimborazo",
    "raj" to "rajasthani",
    "rap" to "rapanui",
    "rar" to "rarotonga",
    "rgn" to "romagnolo",
    "rhg" to "rohingya",
    "rif" to "tarifit",
    "rm" to "romancio",
    "rn" to "rundi",
    "ro" to "rumeno",
    "ro-MD" to "moldavo",
    "rof" to "rombo",
    "rom" to "romani",
    "rtm" to "rotumano",
    "ru" to "russo",
    "rue" to "ruteno",
    "rug" to "roviana",
    "rup" to "arumeno",
    "rw" to "kinyarwanda",
    "rwk" to "rwa",
    "sa" to "sanscrito",
    "sad" to "sandawe",
    "sah" to "sacha",
    "sam" to "aramaico samaritano",
    "saq" to "samburu",
    "sas" to "sasak",
    "sat" to "santali",
    "saz" to "saurashtra",
    "sba" to "ngambay",
    "sbp" to "sangu",
    "sc" to "sardo",
    "scn" to "siciliano",
    "sco" to "scozzese",
    "sd" to "sindhi",
    "sdc" to "sassarese",
    "sdh" to "curdo meridionale",
    "se" to "sami del nord",
    "see" to "seneca",
    "seh" to "sena",
    "sei" to "seri",
    "sel" to "selkup",
    "ses" to "koyraboro senni",
    "sg" to "sango",
    "sga" to "irlandese antico",
    "sgs" to "samogitico",
    "sh" to "serbo-croato",
    "shi" to "tashelhit",
    "shn" to "shan",
    "shu" to "arabo ciadiano",
    "si" to "singalese",
    "sid" to "sidamo",
    "sk" to "slovacco",
    "sl" to "sloveno",
    "slh" to "lushootseed meridionale",
    "sli" to "tedesco slesiano",
    "sly" to "selayar",
    "sm" to "samoano",
    "sma" to "sami del sud",
    "smj" to "sami di Lule",
    "smn" to "sami di Inari",
    "sms" to "sami skolt",
    "sn" to "shona",
    "snk" to "soninke",
    "so" to "somalo",
    "sog" to "sogdiano",
    "sq" to "albanese",
    "sr" to "serbo",
    "srn" to "sranan tongo",
    "srr" to "serer",
    "ss" to "swati",
    "ssy" to "saho",
    "st" to "sotho del sud",
    "stq" to "saterfriesisch",
    "str" to "salish straits",
    "su" to "sundanese",
    "suk" to "sukuma",
    "sus" to "susu",
    "sux" to "sumero",
    "sv" to "svedese",
    "sw" to "swahili",
    "sw-CD" to "swahili del Congo",
    "swb" to "comoriano",
    "syc" to "siriaco classico",
    "syr" to "siriaco",
    "szl" to "slesiano",
    "ta" to "tamil",
    "tce" to "tutchone meridionale",
    "tcy" to "tulu",
    "te" to "telugu",
    "tem" to "temne",
    "teo" to "teso",
    "ter" to "tereno",
    "tet" to "tetum",
    "tg" to "tagico",
    "tgx" to "tagish",
    "th" to "thailandese",
    "tht" to "tahltan",
    "ti" to "tigrino",
    "tig" to "tigre",
    "tiv" to "tiv",
    "tk" to "turcomanno",
    "tkl" to "tokelau",
    "tkr" to "tsakhur",
    "tl" to "tagalog",
    "tlh" to "klingon",
    "tli" to "tlingit",
    "tly" to "taliscio",
    "tmh" to "tamashek",
    "tn" to "tswana",
    "to" to "tongano",
    "tog" to "nyasa del Tonga",
    "tok" to "toki pona",
    "tpi" to "tok pisin",
    "tr" to "turco",
    "tru" to "turoyo",
    "trv" to "taroko",
    "ts" to "tsonga",
    "tsd" to "zaconico",
    "tsi" to "tsimshian",
    "tt" to "tataro",
    "ttm" to "tutchone settentrionale",
    "ttt" to "tat islamico",
    "tum" to "tumbuka",
    "tvl" to "tuvalu",
    "tw" to "ci",
    "twq" to "tasawaq",
    "ty" to "taitiano",
    "tyv" to "tuvinian",
    "tzm" to "tamazight",
    "udm" to "udmurt",
    "ug" to "uiguro",
    "uga" to "ugaritico",
    "uk" to "ucraino",
    "umb" to "mbundu",
    "und" to "lingua imprecisata",
    "ur" to "urdu",
    "uz" to "uzbeco",
    "ve" to "venda",
    "vec" to "veneto",
    "vep" to "vepso",
    "vi" to "vietnamita",
    "vls" to "fiammingo occidentale",
    "vmw" to "macua",
    "vo" to "volapük",
    "vot" to "voto",
    "vro" to "võro",
    "vun" to "vunjo",
    "wa" to "vallone",
    "wae" to "walser",
    "wal" to "walamo",
    "war" to "waray",
    "was" to "washo",
    "wbp" to "warlpiri",
    "wo" to "wolof",
    "wuu" to "wu",
    "xal" to "kalmyk",
    "xh" to "xhosa",
    "xmf" to "mengrelio",
    "xnr" to "kangri",
    "xog" to "soga",
    "yao" to "yao (bantu)",
    "yap" to "yapese",
    "yav" to "yangben",
    "ybb" to "yemba",
    "yi" to "yiddish",
    "yo" to "yoruba",
    "yrl" to "nheengatu",
    "yue" to "cantonese",
    "yue-alt-menu" to "cinese (cantonese)",
    "za" to "zhuang",
    "zap" to "zapotec",
    "zbl" to "blissymbol",
    "zea" to "zelandese",
    "zen" to "zenaga",
    "zgh" to "tamazight del Marocco standard",
    "zh" to "cinese",
    "zh-alt-menu" to "cinese (mandarino)",
    "zh-Hans" to "cinese semplificato",
    "zh-Hans-alt-long" to "cinese mandarino semplificato",
    "zh-Hant" to "cinese tradizionale",
    "zh-Hant-alt-long" to "cinese mandarino tradizionale",
    "zu" to "zulu",
    "zun" to "zuni",
    "zxx" to "nessun contenuto linguistico",
    "zza" to "zaza",
  ) }

  val it_CH: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val it_SM: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val it_VA: ImmutableMap<String, String> by lazy { immutableMapOf(
  ) }

  val ja: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "アファル語",
    "ab" to "アブハズ語",
    "ace" to "アチェ語",
    "ach" to "アチョリ語",
    "ada" to "アダングメ語",
    "ady" to "アディゲ語",
    "ae" to "アヴェスタ語",
    "aeb" to "チュニジア・アラビア語",
    "af" to "アフリカーンス語",
    "afh" to "アフリヒリ語",
    "agq" to "アゲム語",
    "ain" to "アイヌ語",
    "ak" to "アカン語",
    "akk" to "アッカド語",
    "akz" to "アラバマ語",
    "ale" to "アレウト語",
    "aln" to "ゲグ・アルバニア語",
    "alt" to "南アルタイ語",
    "am" to "アムハラ語",
    "an" to "アラゴン語",
    "ang" to "古英語",
    "ann" to "オボロ語",
    "anp" to "アンギカ語",
    "ar" to "アラビア語",
    "ar-001" to "現代標準アラビア語",
    "arc" to "アラム語",
    "arn" to "マプチェ語",
    "aro" to "アラオナ語",
    "arp" to "アラパホー語",
    "arq" to "アルジェリア・アラビア語",
    "ars" to "ナジュド地方・アラビア語",
    "ars-alt-menu" to "アラビア語（ナジュド地方）",
    "arw" to "アラワク語",
    "ary" to "モロッコ・アラビア語",
    "arz" to "エジプト・アラビア語",
    "as" to "アッサム語",
    "asa" to "アス語",
    "ase" to "アメリカ手話",
    "ast" to "アストゥリアス語",
    "atj" to "アティカメク語",
    "av" to "アヴァル語",
    "avk" to "コタヴァ",
    "awa" to "アワディー語",
    "ay" to "アイマラ語",
    "az" to "アゼルバイジャン語",
    "az-alt-short" to "アゼリー語",
    "ba" to "バシキール語",
    "bal" to "バルーチー語",
    "ban" to "バリ語",
    "bar" to "バイエルン・オーストリア語",
    "bas" to "バサ語",
    "bax" to "バムン語",
    "bbc" to "トバ・バタク語",
    "bbj" to "ゴーマラ語",
    "be" to "ベラルーシ語",
    "bej" to "ベジャ語",
    "bem" to "ベンバ語",
    "bew" to "ベタウィ語",
    "bez" to "ベナ語",
    "bfd" to "バフット語",
    "bfq" to "バダガ語",
    "bg" to "ブルガリア語",
    "bgc" to "ハリヤーンウィー語",
    "bgn" to "西バローチー語",
    "bho" to "ボージュプリー語",
    "bi" to "ビスラマ語",
    "bik" to "ビコル語",
    "bin" to "ビニ語",
    "bjn" to "バンジャル語",
    "bkm" to "コム語",
    "bla" to "シクシカ語",
    "blo" to "アニ語 (blo)",
    "bm" to "バンバラ語",
    "bn" to "ベンガル語",
    "bo" to "チベット語",
    "bpy" to "ビシュヌプリヤ・マニプリ語",
    "bqi" to "バフティヤーリー語",
    "br" to "ブルトン語",
    "bra" to "ブラジ語",
    "brh" to "ブラフイ語",
    "brx" to "ボド語",
    "bs" to "ボスニア語",
    "bss" to "アコース語",
    "bua" to "ブリヤート語",
    "bug" to "ブギ語",
    "bum" to "ブル語",
    "byn" to "ビリン語",
    "byv" to "メドゥンバ語",
    "ca" to "カタロニア語",
    "cad" to "カドー語",
    "car" to "カリブ語",
    "cay" to "カユーガ語",
    "cch" to "チャワイ語",
    "ccp" to "チャクマ語",
    "ce" to "チェチェン語",
    "ceb" to "セブアノ語",
    "cgg" to "チガ語",
    "ch" to "チャモロ語",
    "chb" to "チブチャ語",
    "chg" to "チャガタイ語",
    "chk" to "チューク語",
    "chm" to "マリ語",
    "chn" to "チヌーク混成語",
    "cho" to "チョクトー語",
    "chp" to "チペワイアン語",
    "chr" to "チェロキー語",
    "chy" to "シャイアン語",
    "ckb" to "中央クルド語",
    "ckb-alt-menu" to "クルド語（中央）",
    "ckb-alt-variant" to "クルド語（ソラニー）",
    "clc" to "チルコーティン語",
    "co" to "コルシカ語",
    "cop" to "コプト語",
    "cps" to "カピス語",
    "cr" to "クリー語",
    "crg" to "ミチフ語",
    "crh" to "クリミア・タタール語",
    "crj" to "東部クリー語(南部)",
    "crk" to "平原クリー語",
    "crl" to "東部クリー語(北部)",
    "crm" to "ムースクリー語",
    "crr" to "カロライナ・アルゴンキン語",
    "crs" to "セーシェル・クレオール語",
    "cs" to "チェコ語",
    "csb" to "カシューブ語",
    "csw" to "湿原クリー語",
    "cu" to "教会スラブ語",
    "cv" to "チュヴァシ語",
    "cy" to "ウェールズ語",
    "da" to "デンマーク語",
    "dak" to "ダコタ語",
    "dar" to "ダルグワ語",
    "dav" to "タイタ語",
    "de" to "ドイツ語",
    "de-CH" to "標準ドイツ語 (スイス)",
    "del" to "デラウェア語",
    "den" to "スレイビー語",
    "dgr" to "ドグリブ語",
    "din" to "ディンカ語",
    "dje" to "ザルマ語",
    "doi" to "ドーグリー語",
    "dsb" to "低地ソルブ語",
    "dtp" to "中央ドゥスン語",
    "dua" to "ドゥアラ語",
    "dum" to "中世オランダ語",
    "dv" to "ディベヒ語",
    "dyo" to "ジョラ＝フォニィ語",
    "dyu" to "ジュラ語",
    "dz" to "ゾンカ語",
    "dzg" to "ダザガ語",
    "ebu" to "エンブ語",
    "ee" to "エウェ語",
    "efi" to "エフィク語",
    "egl" to "エミリア語",
    "egy" to "古代エジプト語",
    "eka" to "エカジュク語",
    "el" to "ギリシャ語",
    "elx" to "エラム語",
    "en" to "英語",
    "en-AU" to "オーストラリア英語",
    "en-CA" to "カナダ英語",
    "en-GB" to "イギリス英語",
    "en-GB-alt-short" to "英語(英国)",
    "en-US" to "アメリカ英語",
    "en-US-alt-short" to "英語(米国)",
    "enm" to "中英語",
    "eo" to "エスペラント語",
    "es" to "スペイン語",
    "es-ES" to "スペイン語 (イベリア半島)",
    "esu" to "中央アラスカ・ユピック語",
    "et" to "エストニア語",
    "eu" to "バスク語",
    "ewo" to "エウォンド語",
    "ext" to "エストレマドゥーラ語",
    "fa" to "ペルシア語",
    "fa-AF" to "ダリー語",
    "fan" to "ファング語",
    "fat" to "ファンティー語",
    "ff" to "フラ語",
    "fi" to "フィンランド語",
    "fil" to "フィリピノ語",
    "fit" to "トルネダール・フィンランド語",
    "fj" to "フィジー語",
    "fo" to "フェロー語",
    "fon" to "フォン語",
    "fr" to "フランス語",
    "frc" to "ケイジャン・フランス語",
    "frm" to "中期フランス語",
    "fro" to "古フランス語",
    "frp" to "アルピタン語",
    "frr" to "北フリジア語",
    "frs" to "東フリジア語",
    "fur" to "フリウリ語",
    "fy" to "西フリジア語",
    "ga" to "アイルランド語",
    "gaa" to "ガ語",
    "gag" to "ガガウズ語",
    "gan" to "贛語",
    "gay" to "ガヨ語",
    "gba" to "バヤ語",
    "gbz" to "ダリー語(ゾロアスター教)",
    "gd" to "スコットランド・ゲール語",
    "gez" to "ゲエズ語",
    "gil" to "キリバス語",
    "gl" to "ガリシア語",
    "glk" to "ギラキ語",
    "gmh" to "中高ドイツ語",
    "gn" to "グアラニー語",
    "goh" to "古高ドイツ語",
    "gon" to "ゴーンディー語",
    "gor" to "ゴロンタロ語",
    "got" to "ゴート語",
    "grb" to "グレボ語",
    "grc" to "古代ギリシャ語",
    "gsw" to "スイスドイツ語",
    "gu" to "グジャラート語",
    "guc" to "ワユ語",
    "gur" to "フラフラ語",
    "guz" to "グシイ語",
    "gv" to "マン島語",
    "gwi" to "グウィッチン語",
    "ha" to "ハウサ語",
    "hai" to "ハイダ語",
    "hak" to "客家語",
    "haw" to "ハワイ語",
    "hax" to "南部ハイダ語",
    "he" to "ヘブライ語",
    "hi" to "ヒンディー語",
    "hi-Latn-alt-variant" to "インド英語 (ヒングリッシュ)",
    "hif" to "フィジー・ヒンディー語",
    "hil" to "ヒリガイノン語",
    "hit" to "ヒッタイト語",
    "hmn" to "フモン語",
    "ho" to "ヒリモツ語",
    "hr" to "クロアチア語",
    "hsb" to "高地ソルブ語",
    "hsn" to "湘語",
    "ht" to "ハイチ・クレオール語",
    "hu" to "ハンガリー語",
    "hup" to "フパ語",
    "hur" to "ハルコメレム語",
    "hy" to "アルメニア語",
    "hz" to "ヘレロ語",
    "ia" to "インターリングア",
    "iba" to "イバン語",
    "ibb" to "イビビオ語",
    "id" to "インドネシア語",
    "ie" to "インターリング",
    "ig" to "イボ語",
    "ii" to "四川イ語",
    "ik" to "イヌピアック語",
    "ikt" to "イヌイナクトゥン語",
    "ilo" to "イロカノ語",
    "inh" to "イングーシ語",
    "io" to "イド語",
    "is" to "アイスランド語",
    "it" to "イタリア語",
    "iu" to "イヌクティトット語",
    "izh" to "イングリア語",
    "ja" to "日本語",
    "jam" to "ジャマイカ・クレオール語",
    "jbo" to "ロジバン語",
    "jgo" to "ンゴンバ語",
    "jmc" to "マチャメ語",
    "jpr" to "ユダヤ・ペルシア語",
    "jrb" to "ユダヤ・アラビア語",
    "jut" to "ユトランド語",
    "jv" to "ジャワ語",
    "ka" to "ジョージア語",
    "kaa" to "カラカルパク語",
    "kab" to "カビル語",
    "kac" to "カチン語",
    "kaj" to "カジェ語",
    "kam" to "カンバ語",
    "kaw" to "カウィ語",
    "kbd" to "カバルド語",
    "kbl" to "カネンブ語",
    "kcg" to "カタブ語",
    "kde" to "マコンデ語",
    "kea" to "カーボベルデ・クレオール語",
    "ken" to "ニャン語",
    "kfo" to "コロ語",
    "kg" to "コンゴ語",
    "kgp" to "カインガング語",
    "kha" to "カシ語",
    "kho" to "コータン語",
    "khq" to "コイラ・チーニ語",
    "khw" to "コワール語",
    "ki" to "キクユ語",
    "kiu" to "キルマンジュキ語",
    "kj" to "クワニャマ語",
    "kk" to "カザフ語",
    "kkj" to "カコ語",
    "kl" to "グリーンランド語",
    "kln" to "カレンジン語",
    "km" to "クメール語",
    "kmb" to "キンブンド語",
    "kn" to "カンナダ語",
    "ko" to "韓国語",
    "koi" to "コミ・ペルミャク語",
    "kok" to "コンカニ語",
    "kos" to "コスラエ語",
    "kpe" to "クペレ語",
    "kr" to "カヌリ語",
    "krc" to "カラチャイ・バルカル語",
    "kri" to "クリオ語",
    "krj" to "キナライア語",
    "krl" to "カレリア語",
    "kru" to "クルク語",
    "ks" to "カシミール語",
    "ksb" to "サンバー語",
    "ksf" to "バフィア語",
    "ksh" to "ケルン語",
    "ku" to "クルド語",
    "kum" to "クムク語",
    "kut" to "クテナイ語",
    "kv" to "コミ語",
    "kw" to "コーンウォール語",
    "kwk" to "クヮキゥワラ語",
    "kxv" to "クーヴィンガ語",
    "ky" to "キルギス語",
    "la" to "ラテン語",
    "lad" to "ラディノ語",
    "lag" to "ランギ語",
    "lah" to "ラフンダー語",
    "lam" to "ランバ語",
    "lb" to "ルクセンブルク語",
    "lez" to "レズギ語",
    "lfn" to "リングア・フランカ・ノバ",
    "lg" to "ガンダ語",
    "li" to "リンブルフ語",
    "lij" to "リグリア語",
    "lil" to "リルエット語",
    "liv" to "リヴォニア語",
    "lkt" to "ラコタ語",
    "lmo" to "ロンバルド語",
    "ln" to "リンガラ語",
    "lo" to "ラオ語",
    "lol" to "モンゴ語",
    "lou" to "ルイジアナ・クレオール語",
    "loz" to "ロジ語",
    "lrc" to "北ロル語",
    "lsm" to "サーミア語",
    "lt" to "リトアニア語",
    "ltg" to "ラトガリア語",
    "lu" to "ルバ・カタンガ語",
    "lua" to "ルバ・ルルア語",
    "lui" to "ルイセーニョ語",
    "lun" to "ルンダ語",
    "luo" to "ルオ語",
    "lus" to "ミゾ語",
    "luy" to "ルヒヤ語",
    "lv" to "ラトビア語",
    "lzh" to "漢文",
    "lzz" to "ラズ語",
    "mad" to "マドゥラ語",
    "maf" to "マファ語",
    "mag" to "マガヒー語",
    "mai" to "マイティリー語",
    "mak" to "マカッサル語",
    "man" to "マンディンゴ語",
    "mas" to "マサイ語",
    "mde" to "マバ語",
    "mdf" to "モクシャ語",
    "mdr" to "マンダル語",
    "men" to "メンデ語",
    "mer" to "メル語",
    "mfe" to "モーリシャス・クレオール語",
    "mg" to "マダガスカル語",
    "mga" to "中期アイルランド語",
    "mgh" to "マクア・ミート語",
    "mgo" to "メタ語",
    "mh" to "マーシャル語",
    "mi" to "マオリ語",
    "mic" to "ミクマク語",
    "min" to "ミナンカバウ語",
    "mk" to "マケドニア語",
    "ml" to "マラヤーラム語",
    "mn" to "モンゴル語",
    "mnc" to "満州語",
    "mni" to "マニプリ語",
    "moe" to "イヌー＝アイムン語",
    "moh" to "モーホーク語",
    "mos" to "モシ語",
    "mr" to "マラーティー語",
    "mrj" to "山地マリ語",
    "ms" to "マレー語",
    "mt" to "マルタ語",
    "mua" to "ムンダン語",
    "mul" to "複数言語",
    "mus" to "クリーク語",
    "mwl" to "ミランダ語",
    "mwr" to "マールワーリー語",
    "mwv" to "メンタワイ語",
    "my" to "ミャンマー語",
    "mye" to "ミエネ語",
    "myv" to "エルジャ語",
    "mzn" to "マーザンダラーン語",
    "na" to "ナウル語",
    "nan" to "閩南語",
    "nap" to "ナポリ語",
    "naq" to "ナマ語",
    "nb" to "ノルウェー語(ブークモール)",
    "nd" to "北ンデベレ語",
    "nds" to "低地ドイツ語",
    "ne" to "ネパール語",
    "new" to "ネワール語",
    "ng" to "ンドンガ語",
    "nia" to "ニアス語",
    "niu" to "ニウーエイ語",
    "njo" to "アオ・ナガ語",
    "nl" to "オランダ語",
    "nl-BE" to "フラマン語",
    "nmg" to "クワシオ語",
    "nn" to "ノルウェー語(ニーノシュク)",
    "nnh" to "ンジエムブーン語",
    "no" to "ノルウェー語",
    "nog" to "ノガイ語",
    "non" to "古ノルド語",
    "nov" to "ノヴィアル",
    "nqo" to "ンコ語",
    "nr" to "南ンデベレ語",
    "nso" to "北部ソト語",
    "nus" to "ヌエル語",
    "nv" to "ナバホ語",
    "nwc" to "古典ネワール語",
    "ny" to "ニャンジャ語",
    "nym" to "ニャムウェジ語",
    "nyn" to "ニャンコレ語",
    "nyo" to "ニョロ語",
    "nzi" to "ンゼマ語",
    "oc" to "オック語",
    "oj" to "オジブウェー語",
    "ojb" to "北西部オジブワ語",
    "ojc" to "中部オジブワ語",
    "ojs" to "セヴァーン・オジブワ語",
    "ojw" to "西部オジブワ語",
    "oka" to "オカナガン語",
    "om" to "オロモ語",
    "or" to "オディア語",
    "os" to "オセット語",
    "osa" to "オセージ語",
    "ota" to "オスマントルコ語",
    "pa" to "パンジャブ語",
    "pag" to "パンガシナン語",
    "pal" to "パフラヴィー語",
    "pam" to "パンパンガ語",
    "pap" to "パピアメント語",
    "pau" to "パラオ語",
    "pcd" to "ピカルディ語",
    "pcm" to "ナイジェリア・ピジン語",
    "pdc" to "ペンシルベニア・ドイツ語",
    "pdt" to "メノナイト低地ドイツ語",
    "peo" to "古代ペルシア語",
    "pfl" to "プファルツ語",
    "phn" to "フェニキア語",
    "pi" to "パーリ語",
    "pis" to "ピジン語",
    "pl" to "ポーランド語",
    "pms" to "ピエモンテ語",
    "pnt" to "ポントス・ギリシャ語",
    "pon" to "ポンペイ語",
    "pqm" to "マリシート＝パサマコディ語",
    "prg" to "プロシア語",
    "pro" to "古期プロバンス語",
    "ps" to "パシュトゥー語",
    "ps-alt-variant" to "パシュトゥ語",
    "pt" to "ポルトガル語",
    "pt-PT" to "ポルトガル語 (イベリア半島)",
    "qu" to "ケチュア語",
    "quc" to "キチェ語",
    "qug" to "チンボラソ高地ケチュア語",
    "raj" to "ラージャスターン語",
    "rap" to "ラパヌイ語",
    "rar" to "ラロトンガ語",
    "rgn" to "ロマーニャ語",
    "rhg" to "ロヒンギャ語",
    "rif" to "リーフ語",
    "rm" to "ロマンシュ語",
    "rn" to "ルンディ語",
    "ro" to "ルーマニア語",
    "ro-MD" to "モルダビア語",
    "rof" to "ロンボ語",
    "rom" to "ロマーニー語",
    "rtm" to "ロツマ語",
    "ru" to "ロシア語",
    "rue" to "ルシン語",
    "rug" to "ロヴィアナ語",
    "rup" to "アルーマニア語",
    "rw" to "キニアルワンダ語",
    "rwk" to "ルワ語",
    "sa" to "サンスクリット語",
    "sad" to "サンダウェ語",
    "sah" to "サハ語",
    "sam" to "サマリア・アラム語",
    "saq" to "サンブル語",
    "sas" to "ササク語",
    "sat" to "サンターリー語",
    "saz" to "サウラーシュトラ語",
    "sba" to "ンガムバイ語",
    "sbp" to "サング語",
    "sc" to "サルデーニャ語",
    "scn" to "シチリア語",
    "sco" to "スコットランド語",
    "sd" to "シンド語",
    "sdc" to "サッサリ・サルデーニャ語",
    "sdh" to "南部クルド語",
    "se" to "北サーミ語",
    "see" to "セネカ語",
    "seh" to "セナ語",
    "sei" to "セリ語",
    "sel" to "セリクプ語",
    "ses" to "コイラボロ・センニ語",
    "sg" to "サンゴ語",
    "sga" to "古アイルランド語",
    "sgs" to "サモギティア語",
    "sh" to "セルボ・クロアチア語",
    "shi" to "タシルハイト語",
    "shn" to "シャン語",
    "shu" to "チャド・アラビア語",
    "si" to "シンハラ語",
    "sid" to "シダモ語",
    "sk" to "スロバキア語",
    "sl" to "スロベニア語",
    "slh" to "南部ルシュツィード語",
    "sli" to "低シレジア語",
    "sly" to "スラヤール語",
    "sm" to "サモア語",
    "sma" to "南サーミ語",
    "smj" to "ルレ・サーミ語",
    "smn" to "イナリ・サーミ語",
    "sms" to "スコルト・サーミ語",
    "sn" to "ショナ語",
    "snk" to "ソニンケ語",
    "so" to "ソマリ語",
    "sog" to "ソグド語",
    "sq" to "アルバニア語",
    "sr" to "セルビア語",
    "srn" to "スリナム語",
    "srr" to "セレル語",
    "ss" to "スワジ語",
    "ssy" to "サホ語",
    "st" to "南部ソト語",
    "stq" to "ザーターフリジア語",
    "str" to "ストレイツセイリッシュ語",
    "su" to "スンダ語",
    "suk" to "スクマ語",
    "sus" to "スス語",
    "sux" to "シュメール語",
    "sv" to "スウェーデン語",
    "sw" to "スワヒリ語",
    "sw-CD" to "コンゴ・スワヒリ語",
    "swb" to "コモロ語",
    "syc" to "古典シリア語",
    "syr" to "シリア語",
    "szl" to "シレジア語",
    "ta" to "タミル語",
    "tce" to "南部トゥショーニ語",
    "tcy" to "トゥル語",
    "te" to "テルグ語",
    "tem" to "テムネ語",
    "teo" to "テソ語",
    "ter" to "テレーノ語",
    "tet" to "テトゥン語",
    "tg" to "タジク語",
    "tgx" to "タギシュ語",
    "th" to "タイ語",
    "tht" to "タールタン語",
    "ti" to "ティグリニア語",
    "tig" to "ティグレ語",
    "tiv" to "ティブ語",
    "tk" to "トルクメン語",
    "tkl" to "トケラウ語",
    "tkr" to "ツァフル語",
    "tl" to "タガログ語",
    "tlh" to "クリンゴン語",
    "tli" to "トリンギット語",
    "tly" to "タリシュ語",
    "tmh" to "タマシェク語",
    "tn" to "ツワナ語",
    "to" to "トンガ語",
    "tog" to "トンガ語(ニアサ)",
    "tok" to "トキポナ語",
    "tpi" to "トク・ピシン語",
    "tr" to "トルコ語",
    "tru" to "トゥロヨ語",
    "trv" to "タロコ語",
    "ts" to "ツォンガ語",
    "tsd" to "ツァコン語",
    "tsi" to "チムシュ語",
    "tt" to "タタール語",
    "ttm" to "北部トゥショーニ語",
    "ttt" to "ムスリム・タタール語",
    "tum" to "トゥンブカ語",
    "tvl" to "ツバル語",
    "tw" to "トウィ語",
    "twq" to "タサワク語",
    "ty" to "タヒチ語",
    "tyv" to "トゥヴァ語",
    "tzm" to "中央アトラス・タマジクト語",
    "udm" to "ウドムルト語",
    "ug" to "ウイグル語",
    "ug-alt-variant" to "ウィグル語",
    "uga" to "ウガリト語",
    "uk" to "ウクライナ語",
    "umb" to "ムブンドゥ語",
    "und" to "言語不明",
    "ur" to "ウルドゥー語",
    "uz" to "ウズベク語",
    "vai" to "ヴァイ語",
    "ve" to "ベンダ語",
    "vec" to "ヴェネト語",
    "vep" to "ヴェプス語",
    "vi" to "ベトナム語",
    "vls" to "西フラマン語",
    "vmf" to "マインフランク語",
    "vmw" to "マクア語",
    "vo" to "ヴォラピュク語",
    "vot" to "ヴォート語",
    "vro" to "ヴォロ語",
    "vun" to "ヴンジョ語",
    "wa" to "ワロン語",
    "wae" to "ヴァリス語",
    "wal" to "ウォライタ語",
    "war" to "ワライ語",
    "was" to "ワショ語",
    "wbp" to "ワルピリ語",
    "wo" to "ウォロフ語",
    "wuu" to "呉語",
    "xal" to "カルムイク語",
    "xh" to "コサ語",
    "xmf" to "メグレル語",
    "xnr" to "カーングリー語",
    "xog" to "ソガ語",
    "yao" to "ヤオ語",
    "yap" to "ヤップ語",
    "yav" to "ヤンベン語",
    "ybb" to "イエンバ語",
    "yi" to "イディッシュ語",
    "yo" to "ヨルバ語",
    "yrl" to "ニェエンガトゥ語",
    "yue" to "広東語",
    "yue-alt-menu" to "中国語 (広東語)",
    "za" to "チワン語",
    "zap" to "サポテカ語",
    "zbl" to "ブリスシンボル",
    "zea" to "ゼーラント語",
    "zen" to "ゼナガ語",
    "zgh" to "標準モロッコ タマジクト語",
    "zh" to "中国語",
    "zh-alt-menu" to "中国語 (標準語)",
    "zh-Hans" to "簡体中国語",
    "zh-Hans-alt-long" to "標準中国語 (簡体字)",
    "zh-Hant" to "繁体中国語",
    "zh-Hant-alt-long" to "標準中国語 (繁体字)",
    "zu" to "ズールー語",
    "zun" to "ズニ語",
    "zxx" to "言語的内容なし",
    "zza" to "ザザ語",
  ) }

  val jbo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "jbo" to "la .lojban.",
  ) }

  val jgo: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ar" to "Alâbɛ",
    "de" to "Njáman",
    "el" to "Ŋgɛlɛ̂k",
    "en" to "Aŋgɛlúshi",
    "fr" to "Fɛlánci",
    "jgo" to "Ndaꞌa",
    "und" to "cú-pʉɔ yi pɛ́ ká kɛ́ jí",
    "zh" to "Shinwâ",
    "zh-alt-menu" to "Shinwâ",
  ) }

  val jmc: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Kiakanyi",
    "am" to "Kiamharyi",
    "ar" to "Kyiarabu",
    "be" to "Kyibelarusi",
    "bg" to "Kyibulgaryia",
    "bn" to "Kyibangla",
    "cs" to "Kyichecki",
    "de" to "Kyijerumani",
    "el" to "Kyigiriki",
    "en" to "Kyingereza",
    "es" to "Kyihispania",
    "fa" to "Kyiajemi",
    "fr" to "Kyifaransa",
    "ha" to "Kyihausa",
    "hi" to "Kyihindi",
    "hu" to "Kyihungari",
    "id" to "Kyiindonesia",
    "ig" to "Kyiigbo",
    "it" to "Kyiitaliano",
    "ja" to "Kyijapani",
    "jmc" to "Kimachame",
    "jv" to "Kyijava",
    "km" to "Kyikambodia",
    "ko" to "Kyikorea",
    "ms" to "Kyimalesia",
    "my" to "Kyiburma",
    "ne" to "Kyinepali",
    "nl" to "Kyiholanzi",
    "pa" to "Kyipunjabi",
    "pl" to "Kyipolandi",
    "pt" to "Kyireno",
    "ro" to "Kyiromania",
    "ru" to "Kyirusi",
    "rw" to "Kyinyarwanda",
    "so" to "Kyisomalyi",
    "sv" to "Kyiswidi",
    "ta" to "Kyitamil",
    "th" to "Kyitailandi",
    "tr" to "Kyiturukyi",
    "uk" to "Kyiukrania",
    "ur" to "Kyiurdu",
    "vi" to "Kyivietinamu",
    "yo" to "Kyiyoruba",
    "zh" to "Kyichina",
    "zh-alt-menu" to "Kyichina",
    "zu" to "Kyizulu",
  ) }

  val jv: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ab" to "Abkhazian",
    "ace" to "Achinese",
    "ada" to "Adangme",
    "ady" to "Adyghe",
    "af" to "Afrika",
    "agq" to "Aghem",
    "ain" to "Ainu",
    "ak" to "Akan",
    "ale" to "Aleut",
    "alt" to "Altai Sisih Kidul",
    "am" to "Amharik",
    "an" to "Aragonese",
    "ann" to "Obolo",
    "anp" to "Angika",
    "ar" to "Arab",
    "ar-001" to "Arab Standar Anyar",
    "arn" to "Mapushe",
    "arp" to "Arapaho",
    "ars" to "Arab Najdi",
    "as" to "Assam",
    "asa" to "Asu",
    "ast" to "Asturia",
    "atj" to "Atikamekw",
    "av" to "Avaric",
    "awa" to "Awadhi",
    "ay" to "Aymara",
    "az" to "Azerbaijan",
    "az-alt-short" to "Azerbaijan",
    "ba" to "Bashkir",
    "ban" to "Bali",
    "bas" to "Basaa",
    "be" to "Belarus",
    "bem" to "Bemba",
    "bez" to "Bena",
    "bg" to "Bulgaria",
    "bgc" to "Haryanvi",
    "bho" to "Bhojpuri",
    "bi" to "Bislama",
    "bin" to "Bini",
    "bla" to "Siksiká",
    "blo" to "Anii",
    "bm" to "Bambara",
    "bn" to "Bengali",
    "bo" to "Tibet",
    "br" to "Breton",
    "brx" to "Bodo",
    "bs" to "Bosnia lan Hercegovina",
    "bug" to "Bugis",
    "byn" to "Blin",
    "ca" to "Katala",
    "cay" to "Kayuga",
    "ccp" to "Chakma",
    "ce" to "Chechen",
    "ceb" to "Cebuano",
    "cgg" to "Chiga",
    "ch" to "Khamorro",
    "chk" to "Chuukese",
    "chm" to "Mari",
    "cho" to "Choctaw",
    "chp" to "Chipewyan",
    "chr" to "Cherokee",
    "chy" to "Cheyenne",
    "ckb" to "Kurdi Tengah",
    "ckb-alt-menu" to "Kurdi Tengah",
    "ckb-alt-variant" to "Kurdi Tengah",
    "clc" to "Chilcotin",
    "co" to "Korsika",
    "crg" to "Michif",
    "crj" to "Kree Kidul Wetan",
    "crk" to "Kree Polos",
    "crl" to "Kree Lor Segara",
    "crm" to "Moose Cree",
    "crr" to "Karolina Algonquian",
    "cs" to "Ceska",
    "csw" to "Kree Rawa",
    "cu" to "Slavia Gerejani",
    "cv" to "Khuvash",
    "cy" to "Welsh",
    "da" to "Dansk",
    "dak" to "Dakota",
    "dar" to "Dargwa",
    "dav" to "Taita",
    "de" to "Jérman",
    "de-AT" to "Jérman Ostenrik",
    "de-CH" to "Jérman Switserlan",
    "dgr" to "Dogrib",
    "dje" to "Zarma",
    "doi" to "Dogri",
    "dsb" to "Sorbia Non Standar",
    "dua" to "Duala",
    "dv" to "Divehi",
    "dyo" to "Jola-Fonyi",
    "dz" to "Dzongkha",
    "dzg" to "Dazaga",
    "ebu" to "Embu",
    "ee" to "Ewe",
    "efi" to "Efik",
    "eka" to "Ekajuk",
    "el" to "Yunani",
    "en" to "Inggris",
    "en-AU" to "Inggris Ostrali",
    "en-CA" to "Inggris Kanada",
    "en-GB" to "Inggris Karajan Manunggal",
    "en-GB-alt-short" to "Inggris (Britania)",
    "en-US" to "Inggris Amérika Sarékat",
    "en-US-alt-short" to "Inggris (AS)",
    "eo" to "Esperanto",
    "es" to "Spanyol",
    "es-419" to "Spanyol (Amerika Latin)",
    "es-ES" to "Spanyol (Eropah)",
    "es-MX" to "Spanyol (Meksiko)",
    "et" to "Estonia",
    "eu" to "Basque",
    "ewo" to "Ewondo",
    "fa" to "Persia",
    "ff" to "Fula",
    "fi" to "Suomi",
    "fil" to "Tagalog",
    "fj" to "Fijian",
    "fo" to "Faroe",
    "fon" to "Fon",
    "fr" to "Prancis",
    "fr-CA" to "Prancis Kanada",
    "fr-CH" to "Prancis Switserlan",
    "frc" to "Prancis Cajun",
    "frr" to "Frisian Lor Segara",
    "fur" to "Friulian",
    "fy" to "Frisia Sisih Kulon",
    "ga" to "Irlandia",
    "gaa" to "Ga",
    "gd" to "Gaulia",
    "gez" to "Gees",
    "gil" to "Gilbertese",
    "gl" to "Galisia",
    "gn" to "Guarani",
    "gor" to "Gorontalo",
    "gsw" to "Jerman Swiss",
    "gu" to "Gujarat",
    "guz" to "Gusii",
    "gv" to "Manx",
    "gwi" to "Gwichʼin",
    "ha" to "Hausa",
    "hai" to "Haida",
    "haw" to "Hawaii",
    "hax" to "Haida Sisih Kidul",
    "he" to "Ibrani",
    "hi" to "India",
    "hil" to "Hiligainon",
    "hmn" to "Hmong",
    "hr" to "Kroasia",
    "hsb" to "Sorbia Standar",
    "ht" to "Kreol Haiti",
    "hu" to "Hungaria",
    "hup" to "Hupa",
    "hur" to "Halkomelem",
    "hy" to "Armenia",
    "hz" to "Herero",
    "ia" to "Interlingua",
    "iba" to "Iban",
    "ibb" to "Ibibio",
    "id" to "Indonesia",
    "ie" to "Interlingue",
    "ig" to "Iqbo",
    "ii" to "Sichuan Yi",
    "ikt" to "Kanada Inuktitut Sisih Kulon",
    "ilo" to "Iloko",
    "inh" to "Ingus",
    "io" to "Ido",
    "is" to "Islandia",
    "it" to "Italia",
    "iu" to "Inuktitut",
    "ja" to "Jepang",
    "jbo" to "Lojban",
    "jgo" to "Ngomba",
    "jmc" to "Machame",
    "jv" to "Jawa",
    "ka" to "Georgia",
    "kab" to "Kabyle",
    "kac" to "Kakhin",
    "kaj" to "Jju",
    "kam" to "Kamba",
    "kbd" to "Kabardian",
    "kcg" to "Tyap",
    "kde" to "Makonde",
    "kea" to "Kabuverdianu",
    "kfo" to "Koro",
    "kgp" to "Kaingang",
    "kha" to "Khasi",
    "khq" to "Koyra Chiini",
    "ki" to "Kikuyu",
    "kj" to "Kuanyama",
    "kk" to "Kazakh",
    "kkj" to "Kako",
    "kl" to "Kalaallisut",
    "kln" to "Kalenjin",
    "km" to "Khmer",
    "kmb" to "Kimbundu",
    "kn" to "Kannada",
    "ko" to "Korea",
    "kok" to "Konkani",
    "kpe" to "Kpelle",
    "kr" to "Kanuri",
    "krc" to "Karachai-Balkar",
    "krl" to "Karelian",
    "kru" to "Kuruk",
    "ks" to "Kashmiri",
    "ksb" to "Shambala",
    "ksf" to "Bafia",
    "ksh" to "Colonia",
    "ku" to "Kurdis",
    "kum" to "Kumik",
    "kv" to "Komi",
    "kw" to "Kernowek",
    "kwk" to "Kwakʼwala",
    "kxv" to "Kuvi",
    "ky" to "Kirgis",
    "la" to "Latin",
    "lad" to "Ladino",
    "lag" to "Langi",
    "lb" to "Luksemburg",
    "lez" to "Lesghian",
    "lg" to "Ganda",
    "li" to "Limburgish",
    "lij" to "Liguria",
    "lil" to "Lillooet",
    "lkt" to "Lakota",
    "lmo" to "Lombard",
    "ln" to "Lingala",
    "lo" to "Laos",
    "lou" to "Louisiana Creole",
    "loz" to "Losi",
    "lrc" to "Luri Sisih Lor",
    "lsm" to "Saamia",
    "lt" to "Lithuania",
    "lu" to "Luba-Katanga",
    "lua" to "Luba-Lulua",
    "lun" to "Lunda",
    "luo" to "Luo",
    "lus" to "Miso",
    "luy" to "Luyia",
    "lv" to "Latvia",
    "mad" to "Madura",
    "mag" to "Magahi",
    "mai" to "Maithili",
    "mak" to "Makasar",
    "mas" to "Masai",
    "mdf" to "Moksha",
    "men" to "Mende",
    "mer" to "Meru",
    "mfe" to "Morisyen",
    "mg" to "Malagasi",
    "mgh" to "Makhuwa-Meeto",
    "mgo" to "Meta’",
    "mh" to "Marshallese",
    "mi" to "Maori",
    "mic" to "Mi'kmak",
    "min" to "Minangkabau",
    "mk" to "Makedonia",
    "ml" to "Malayalam",
    "mn" to "Mongolia",
    "mni" to "Manipuri",
    "moe" to "Innu-aimun",
    "moh" to "Mohawk",
    "mos" to "Mossi",
    "mr" to "Marathi",
    "ms" to "Melayu",
    "mt" to "Malta",
    "mua" to "Mundang",
    "mul" to "Basa Multilingua",
    "mus" to "Muskogee",
    "mwl" to "Mirandese",
    "my" to "Myanmar",
    "myv" to "Ersia",
    "mzn" to "Mazanderani",
    "na" to "Nauru",
    "nap" to "Neapolitan",
    "naq" to "Nama",
    "nb" to "Bokmål Norwegia",
    "nd" to "Ndebele Lor",
    "nds" to "Jerman Non Standar",
    "ne" to "Nepal",
    "new" to "Newari",
    "ng" to "Ndonga",
    "nia" to "Nias",
    "niu" to "Niuean",
    "nl" to "Walanda",
    "nl-BE" to "Flemis",
    "nmg" to "Kwasio",
    "nn" to "Nynorsk Norwegia",
    "nnh" to "Ngiemboon",
    "no" to "Norwegia",
    "nog" to "Nogai",
    "nqo" to "N’Ko",
    "nr" to "Ndebele Kidul",
    "nso" to "Sotho Sisih Lor",
    "nus" to "Nuer",
    "nv" to "Navajo",
    "ny" to "Nyanja",
    "nyn" to "Nyankole",
    "oc" to "Ossitan",
    "ojb" to "Ojibwa Kulon Segara",
    "ojc" to "Ojibwa Tengah",
    "ojs" to "Oji-Kree",
    "ojw" to "Ojibwa Sisih Kulon",
    "oka" to "Okanagan",
    "om" to "Oromo",
    "or" to "Odia",
    "os" to "Ossetia",
    "pa" to "Punjab",
    "pag" to "Pangasinan",
    "pam" to "Pampanga",
    "pap" to "Papiamento",
    "pau" to "Palauan",
    "pcm" to "Nigeria Pidgin",
    "pis" to "Pijin",
    "pl" to "Polandia",
    "pqm" to "Maliseet-Passamakuoddi",
    "prg" to "Prusia",
    "ps" to "Pashto",
    "pt" to "Portugis",
    "pt-BR" to "Portugis Brasil",
    "pt-PT" to "Portugis Portugal",
    "qu" to "Quechua",
    "raj" to "Rajasthani",
    "rap" to "Rapanui",
    "rar" to "Rarotongan",
    "rhg" to "Rohingya",
    "rm" to "Roman",
    "rn" to "Rundi",
    "ro" to "Rumania",
    "rof" to "Rombo",
    "ru" to "Rusia",
    "rup" to "Aromanian",
    "rw" to "Kinyarwanda",
    "rwk" to "Rwa",
    "sa" to "Sanskerta",
    "sad" to "Sandawe",
    "sah" to "Yakut",
    "saq" to "Samburu",
    "sat" to "Santali",
    "sba" to "Ngambai",
    "sbp" to "Sangu",
    "sc" to "Sardinia",
    "scn" to "Sisilia",
    "sco" to "Skots",
    "sd" to "Sindhi",
    "se" to "Sami Sisih Lor",
    "seh" to "Sena",
    "ses" to "Koyraboro Senni",
    "sg" to "Sango",
    "shi" to "Tachelhit",
    "shn" to "Shan",
    "si" to "Sinhala",
    "sk" to "Slowakia",
    "sl" to "Slovenia",
    "slh" to "Lushootseed Sisih Kidul",
    "sm" to "Samoa",
    "smn" to "Inari Sami",
    "sms" to "Skolt Sami",
    "sn" to "Shona",
    "snk" to "Soninke",
    "so" to "Somalia",
    "sq" to "Albania",
    "sr" to "Serbia",
    "srn" to "Sranan Tongo",
    "ss" to "Swati",
    "st" to "Sotho Sisih Kidul",
    "str" to "Selat Salish",
    "su" to "Sunda",
    "suk" to "Sukuma",
    "sv" to "Swedia",
    "sw" to "Swahili",
    "swb" to "Komorian",
    "syr" to "Siriak",
    "szl" to "Silesia",
    "ta" to "Tamil",
    "tce" to "Tutkhone Sisih Kidul",
    "te" to "Telugu",
    "tem" to "Timne",
    "teo" to "Teso",
    "tet" to "Tetum",
    "tg" to "Tajik",
    "tgx" to "Tagish",
    "th" to "Thailand",
    "tht" to "Tahltan",
    "ti" to "Tigrinya",
    "tig" to "Tigre",
    "tk" to "Turkmen",
    "tlh" to "Klingon",
    "tli" to "Tlingit",
    "tn" to "Tswana",
    "to" to "Tonga",
    "tok" to "Toki Pona",
    "tpi" to "Tok Pisin",
    "tr" to "Turki",
    "trv" to "Taroko",
    "ts" to "Tsonga",
    "tt" to "Tatar",
    "ttm" to "Tutkhone Sisih Lor",
    "tum" to "Tumbuka",
    "tvl" to "Tupalu",
    "twq" to "Tasawaq",
    "ty" to "Tahiti",
    "tyv" to "Tupinian",
    "tzm" to "Tamazight Atlas Tengah",
    "udm" to "Udmurt",
    "ug" to "Uighur",
    "uk" to "Ukraina",
    "umb" to "Umbundu",
    "und" to "Basa Ora Dikenali",
    "ur" to "Urdu",
    "uz" to "Uzbek",
    "vai" to "Vai",
    "ve" to "Venda",
    "vec" to "Venesia",
    "vi" to "Vietnam",
    "vmw" to "Makhuwa",
    "vo" to "Volapuk",
    "vun" to "Vunjo",
    "wa" to "Walloon",
    "wae" to "Walser",
    "wal" to "Wolaitta",
    "war" to "Warai",
    "wo" to "Wolof",
    "wuu" to "Tyonghwa Wu",
    "xal" to "Kalmik",
    "xh" to "Xhosa",
    "xnr" to "Kangri",
    "xog" to "Soga",
    "yav" to "Yangben",
    "ybb" to "Yemba",
    "yi" to "Yiddish",
    "yo" to "Yoruba",
    "yrl" to "Nheengatu",
    "yue" to "Kanton",
    "yue-alt-menu" to "Tyonghwa, Kanton",
    "za" to "Zhuang",
    "zgh" to "Tamazight Moroko Standar",
    "zh" to "Tyonghwa",
    "zh-alt-menu" to "Tyonghwa, Mandarin",
    "zh-Hans" to "Tyonghwa (Ringkes)",
    "zh-Hans-alt-long" to "Tyonghwa Mandarin (Ringkes)",
    "zh-Hant" to "Tyonghwa (Tradisional)",
    "zh-Hant-alt-long" to "Tyonghwa Mandarin (Tradisional)",
    "zu" to "Zulu",
    "zun" to "Zuni",
    "zxx" to "Konten tanpa linguistik",
    "zza" to "Zaza",
  ) }

  val ka: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "აფარი",
    "ab" to "აფხაზური",
    "ace" to "აჩეხური",
    "ach" to "აჩოლი",
    "ada" to "ადანგმე",
    "ady" to "ადიღეური",
    "ae" to "ავესტური",
    "af" to "აფრიკაანსი",
    "agq" to "აღემი",
    "ain" to "აინუური",
    "ak" to "აკანი",
    "akk" to "აქადური",
    "ale" to "ალეუტური",
    "alt" to "სამხრეთ ალთაური",
    "am" to "ამჰარული",
    "an" to "არაგონული",
    "ang" to "ძველი ინგლისური",
    "ann" to "ობოლო",
    "anp" to "ანგიკა",
    "ar" to "არაბული",
    "ar-001" to "თანამედროვე სტანდარტული არაბული",
    "arc" to "არამეული",
    "arn" to "მაპუდუნგუნი",
    "arp" to "არაპაჰო",
    "ars" to "ნაჯის არაბული",
    "arw" to "არავაკი",
    "as" to "ასამური",
    "asa" to "ასუ",
    "ast" to "ასტურიული",
    "atj" to "ატიკამეკი",
    "av" to "ხუნძური",
    "awa" to "ავადი",
    "ay" to "აიმარა",
    "az" to "აზერბაიჯანული",
    "az-alt-short" to "აზერბაიჯანული",
    "ba" to "ბაშკირული",
    "bal" to "ბელუჯი",
    "ban" to "ბალინური",
    "bas" to "ბასა",
    "bax" to "ბამუნი",
    "be" to "ბელარუსული",
    "bej" to "ბეჯა",
    "bem" to "ბემბა",
    "bez" to "ბენა",
    "bg" to "ბულგარული",
    "bgc" to "ჰარიანვი",
    "bgn" to "დასავლეთ ბელუჯი",
    "bho" to "ბოჯპური",
    "bi" to "ბისლამა",
    "bin" to "ბინი",
    "bla" to "სიკსიკა",
    "blo" to "ანიი",
    "bm" to "ბამბარა",
    "bn" to "ბენგალური",
    "bo" to "ტიბეტური",
    "br" to "ბრეტონული",
    "bra" to "ბრაჯი",
    "brx" to "ბოდო",
    "bs" to "ბოსნიური",
    "bua" to "ბურიატული",
    "bug" to "ბუგინური",
    "byn" to "ბილინი",
    "ca" to "კატალანური",
    "cay" to "კაიუგა",
    "ccp" to "ჩაკმა",
    "ce" to "ჩეჩნური",
    "ceb" to "სებუანო",
    "cgg" to "ჩიგა",
    "ch" to "ჩამორო",
    "chb" to "ჩიბჩა",
    "chk" to "ჩუკოტკური",
    "chm" to "მარიული",
    "chn" to "ჩინუკის ჟარგონი",
    "cho" to "ჩოკტო",
    "chp" to "ჩიპევიანი",
    "chr" to "ჩეროკი",
    "chy" to "ჩეიენი",
    "ckb" to "ცენტრალური ქურთული",
    "ckb-alt-menu" to "ცენტრალური ქურთული",
    "ckb-alt-variant" to "ცენტრალური ქურთული",
    "clc" to "ჩილკოტინი",
    "co" to "კორსიკული",
    "cop" to "კოპტური",
    "cr" to "კრი",
    "crg" to "მიჩიფი",
    "crh" to "ყირიმულ-თურქული",
    "crj" to "სამხრეთ-აღმოსავლეთის კრი",
    "crk" to "დაბლობის კრი",
    "crl" to "ჩრდილო-აღმოსავლეთის კრი",
    "crm" to "მუსური კრი",
    "crr" to "კაროლინური ალგონკინი",
    "crs" to "სესელვა-კრეოლური ფრანგული",
    "cs" to "ჩეხური",
    "csb" to "კაშუბური",
    "csw" to "ჭაობის კრი",
    "cu" to "საეკლესიო სლავური",
    "cv" to "ჩუვაშური",
    "cy" to "უელსური",
    "da" to "დანიური",
    "dak" to "დაკოტური",
    "dar" to "დარგუული",
    "dav" to "ტაიტა",
    "de" to "გერმანული",
    "de-AT" to "ავსტრიული გერმანული",
    "de-CH" to "შვეიცარიული ზემოგერმანული",
    "del" to "დელავერული",
    "den" to "სლეივი",
    "dgr" to "დოგრიბი",
    "din" to "დინკა",
    "dje" to "ზარმა",
    "doi" to "დოგრი",
    "dsb" to "ქვემოსორბული",
    "dua" to "დუალა",
    "dum" to "საშუალო ჰოლანდიური",
    "dv" to "დივეჰი",
    "dyo" to "დიოლა",
    "dyu" to "დიულა",
    "dz" to "ძონგკხა",
    "dzg" to "დაზაგა",
    "ebu" to "ემბუ",
    "ee" to "ევე",
    "efi" to "ეფიკი",
    "egy" to "ძველეგვიპტური",
    "eka" to "ეკაჯუკი",
    "el" to "ბერძნული",
    "en" to "ინგლისური",
    "en-AU" to "ავსტრალიური ინგლისური",
    "en-CA" to "კანადური ინგლისური",
    "en-GB" to "ბრიტანული ინგლისური",
    "en-GB-alt-short" to "ინგლისური (გაერთიანებული სამეფო)",
    "en-US" to "ამერიკული ინგლისური",
    "en-US-alt-short" to "აშშ ინგლისური",
    "enm" to "საშუალო ინგლისური",
    "eo" to "ესპერანტო",
    "es" to "ესპანური",
    "es-419" to "ლათინურ ამერიკული ესპანური",
    "es-ES" to "ევროპული ესპანური",
    "es-MX" to "მექსიკური ესპანური",
    "et" to "ესტონური",
    "eu" to "ბასკური",
    "ewo" to "ევონდო",
    "fa" to "სპარსული",
    "fa-AF" to "დარი",
    "ff" to "ფულა",
    "fi" to "ფინური",
    "fil" to "ფილიპინური",
    "fj" to "ფიჯი",
    "fo" to "ფარერული",
    "fon" to "ფონი",
    "fr" to "ფრანგული",
    "fr-CA" to "კანადური ფრანგული",
    "fr-CH" to "შვეიცარიული ფრანგული",
    "frc" to "კაჟუნური ფრანგული",
    "frm" to "საშუალო ფრანგული",
    "fro" to "ძველი ფრანგული",
    "frr" to "ჩრდილოფრიზიული",
    "frs" to "აღმოსავლეთფრიზიული",
    "fur" to "ფრიულური",
    "fy" to "დასავლეთფრიზიული",
    "ga" to "ირლანდიური",
    "gaa" to "გა",
    "gag" to "გაგაუზური",
    "gba" to "გბაია",
    "gd" to "შოტლანდიური გელური",
    "gez" to "გეეზი",
    "gil" to "გილბერტული",
    "gl" to "გალისიური",
    "gmh" to "საშუალო ზემოგერმანული",
    "gn" to "გუარანი",
    "goh" to "ძველი ზემოგერმანული",
    "gon" to "გონდი",
    "gor" to "გორონტალო",
    "got" to "გოთური",
    "grc" to "ძველი ბერძნული",
    "gsw" to "შვეიცარიული გერმანული",
    "gu" to "გუჯარათი",
    "guz" to "გუსიი",
    "gv" to "მენური",
    "gwi" to "გვიჩინი",
    "ha" to "ჰაუსა",
    "hai" to "ჰაიდა",
    "haw" to "ჰავაიური",
    "hax" to "სამხრეთული ჰაიდა",
    "he" to "ებრაული",
    "hi" to "ჰინდი",
    "hi-Latn-alt-variant" to "ჰინგლისური",
    "hil" to "ჰილიგაინონი",
    "hit" to "ხეთური",
    "hmn" to "ჰმონგი",
    "hr" to "ხორვატული",
    "hsb" to "ზემოსორბული",
    "ht" to "ჰაიტიური კრეოლი",
    "hu" to "უნგრული",
    "hup" to "ჰუპა",
    "hur" to "ჰალკომელემი",
    "hy" to "სომხური",
    "hz" to "ჰერერო",
    "ia" to "ინტერლინგუალური",
    "iba" to "იბანი",
    "ibb" to "იბიბიო",
    "id" to "ინდონეზიური",
    "ie" to "ინტერლინგი",
    "ig" to "იგბო",
    "ii" to "სიჩუანის ი",
    "ikt" to "დასავლეთ-კანადური ინუკტიტუტი",
    "ilo" to "ილოკო",
    "inh" to "ინგუშური",
    "io" to "იდო",
    "is" to "ისლანდიური",
    "it" to "იტალიური",
    "iu" to "ინუკტიტუტი",
    "ja" to "იაპონური",
    "jbo" to "ლოჟბანი",
    "jgo" to "ნგომბა",
    "jmc" to "კიმაშამი",
    "jpr" to "იუდეო-სპარსული",
    "jrb" to "იუდეო-არაბული",
    "jv" to "იავური",
    "ka" to "ქართული",
    "kaa" to "ყარაყალფახური",
    "kab" to "კაბილური",
    "kac" to "კაჩინი",
    "kaj" to "კაჯი",
    "kam" to "კამბა",
    "kbd" to "ყაბარდოული",
    "kcg" to "ტიაპი",
    "kde" to "მაკონდე",
    "kea" to "კაბუვერდიანუ",
    "kfo" to "კორო",
    "kg" to "კონგო",
    "kgp" to "კაინგანგი",
    "kha" to "ხასი",
    "khq" to "კოირა-ჩიინი",
    "ki" to "კიკუიუ",
    "kj" to "კუნამა",
    "kk" to "ყაზახური",
    "kkj" to "კაკო",
    "kl" to "დასავლეთ გრენლანდიური",
    "kln" to "კალენჯინი",
    "km" to "ქმერული",
    "kmb" to "კიმბუნდუ",
    "kn" to "კანადა",
    "ko" to "კორეული",
    "koi" to "კომი-პერმიაკული",
    "kok" to "კონკანი",
    "kos" to "კუსაიე",
    "kpe" to "კპელე",
    "kr" to "კანური",
    "krc" to "ყარაჩაულ-ბალყარული",
    "krl" to "კარელიური",
    "kru" to "კურუქი",
    "ks" to "ქაშმირული",
    "ksb" to "შამბალა",
    "ksf" to "ბაფია",
    "ksh" to "კიოლში",
    "ku" to "ქურთული",
    "kum" to "ყუმუხური",
    "kut" to "კუტენაი",
    "kv" to "კომი",
    "kw" to "კორნული",
    "kwk" to "კვაკვალა",
    "kxv" to "კუვი",
    "ky" to "ყირგიზული",
    "la" to "ლათინური",
    "lad" to "ლადინო",
    "lag" to "ლანგი",
    "lah" to "ლანდა",
    "lam" to "ლამბა",
    "lb" to "ლუქსემბურგული",
    "lez" to "ლეზგიური",
    "lg" to "განდა",
    "li" to "ლიმბურგული",
    "lij" to "ლიგურიული",
    "lil" to "ლილიეტი",
    "lkt" to "ლაკოტა",
    "lmo" to "ლომბარდიული",
    "ln" to "ლინგალა",
    "lo" to "ლაოსური",
    "lol" to "მონგო",
    "lou" to "ლუიზიანას კრეოლური",
    "loz" to "ლოზი",
    "lrc" to "ჩრდილოეთ ლური",
    "lsm" to "სამია",
    "lt" to "ლიეტუვური",
    "lu" to "ლუბა-კატანგა",
    "lua" to "ლუბა-ლულუა",
    "lui" to "ლუისენიო",
    "lun" to "ლუნდა",
    "luo" to "ლუო",
    "lus" to "მიზო",
    "luy" to "ლუჰია",
    "lv" to "ლატვიური",
    "mad" to "მადურული",
    "maf" to "მაფა",
    "mag" to "მაგაჰი",
    "mai" to "მაითილი",
    "mak" to "მაკასარი",
    "mas" to "მასაი",
    "mde" to "მაბა",
    "mdf" to "მოქშა",
    "men" to "მენდე",
    "mer" to "მერუ",
    "mfe" to "მორისიენი",
    "mg" to "მალაგასიური",
    "mga" to "საშუალო ირლანდიური",
    "mgh" to "მაქუვა-მეეტო",
    "mgo" to "მეტა-ენა",
    "mh" to "მარშალური",
    "mi" to "მაორი",
    "mic" to "მიკმაკი",
    "min" to "მინანგკაბაუ",
    "mk" to "მაკედონური",
    "ml" to "მალაიალამური",
    "mn" to "მონღოლური",
    "mnc" to "მანჯურიული",
    "mni" to "მანიპური",
    "moe" to "ინუ-აიმუნი",
    "moh" to "მოჰაუკური",
    "mos" to "მოსი",
    "mr" to "მარათჰი",
    "ms" to "მალაიური",
    "mt" to "მალტური",
    "mua" to "მუნდანგი",
    "mul" to "სხვადასხვა ენა",
    "mus" to "კრიკი",
    "mwl" to "მირანდული",
    "mwr" to "მარვარი",
    "my" to "ბირმული",
    "mye" to "მიენე",
    "myv" to "ერზია",
    "mzn" to "მაზანდერანული",
    "na" to "ნაურუ",
    "nap" to "ნეაპოლიტანური",
    "naq" to "ნამა",
    "nb" to "ნორვეგიული ბუკმოლი",
    "nd" to "ჩრდილოეთ ნდებელე",
    "nds" to "ქვემოგერმანული",
    "nds-NL" to "ქვემოსაქსონური",
    "ne" to "ნეპალური",
    "new" to "ნევარი",
    "ng" to "ნდონგა",
    "nia" to "ნიასი",
    "niu" to "ნიუე",
    "nl" to "ნიდერლანდური",
    "nl-BE" to "ფლამანდიური",
    "nmg" to "კვასიო",
    "nn" to "ნორვეგიული ნიუნორსკი",
    "nnh" to "ნგიმბუნი",
    "no" to "ნორვეგიული",
    "nog" to "ნოღაური",
    "non" to "ძველსკანდინავიური",
    "nqo" to "ნკო",
    "nr" to "სამხრეთ ნდებელური",
    "nso" to "ჩრდილოეთ სოთო",
    "nus" to "ნუერი",
    "nv" to "ნავახო",
    "nwc" to "კლასიკური ნევარული",
    "ny" to "ნიანჯა",
    "nym" to "ნიამვეზი",
    "nyn" to "ნიანკოლე",
    "nyo" to "ნიორო",
    "nzi" to "ნზიმა",
    "oc" to "ოქსიტანური",
    "oj" to "ოჯიბვე",
    "ojb" to "ჩრდილო-დასავლეთის ოჯიბვა",
    "ojc" to "ცენტრალური ოჯიბვე",
    "ojs" to "ოჯი-კრი",
    "ojw" to "დასავლეთის ოჯიბვა",
    "oka" to "ოკანაგანი",
    "om" to "ორომო",
    "or" to "ორია",
    "os" to "ოსური",
    "pa" to "პენჯაბური",
    "pag" to "პანგასინანი",
    "pal" to "ფალაური",
    "pam" to "პამპანგა",
    "pap" to "პაპიამენტო",
    "pau" to "ფალაუანი",
    "pcm" to "ნიგერიული კრეოლური",
    "peo" to "ძველი სპარსული",
    "phn" to "ფინიკიური",
    "pi" to "პალი",
    "pis" to "პიჯინი",
    "pl" to "პოლონური",
    "pqm" to "მალისეტ-პასამაკვოდი",
    "prg" to "პრუსიული",
    "pro" to "ძველი პროვანსული",
    "ps" to "პუშტუ",
    "pt" to "პორტუგალიური",
    "pt-BR" to "ბრაზილიური პორტუგალიური",
    "pt-PT" to "ევროპული პორტუგალიური",
    "qu" to "კეჩუა",
    "quc" to "კიჩე",
    "raj" to "რაჯასთანი",
    "rap" to "რაპანუი",
    "rar" to "რაროტონგული",
    "rhg" to "როჰინგა",
    "rm" to "რეტორომანული",
    "rn" to "რუნდი",
    "ro" to "რუმინული",
    "ro-MD" to "მოლდავური",
    "rof" to "რომბო",
    "rom" to "ბოშური",
    "ru" to "რუსული",
    "rup" to "არომანული",
    "rw" to "კინიარუანდა",
    "rwk" to "რუა",
    "sa" to "სანსკრიტი",
    "sad" to "სანდავე",
    "sah" to "იაკუტური",
    "sam" to "სამარიულ-არამეული",
    "saq" to "სამბურუ",
    "sat" to "სანტალი",
    "sba" to "ნგამბაი",
    "sbp" to "სანგუ",
    "sc" to "სარდინიული",
    "scn" to "სიცილიური",
    "sco" to "შოტლანდიური",
    "sd" to "სინდჰური",
    "sdh" to "სამხრეთქურთული",
    "se" to "ჩრდილოეთ საამური",
    "see" to "სენეკა",
    "seh" to "სენა",
    "sel" to "სელკუპური",
    "ses" to "კოირაბორო-სენი",
    "sg" to "სანგო",
    "sga" to "ძველი ირლანდიური",
    "sh" to "სერბულ-ხორვატული",
    "shi" to "შილჰა",
    "shn" to "შანი",
    "shu" to "ჩადური არაბული",
    "si" to "სინჰალური",
    "sk" to "სლოვაკური",
    "sl" to "სლოვენური",
    "slh" to "სამხრეთული ლუშუციდი",
    "sm" to "სამოა",
    "sma" to "სამხრეთსამური",
    "smj" to "ლულე-საამური",
    "smn" to "ინარი-საამური",
    "sms" to "სკოლტ-საამური",
    "sn" to "შონა",
    "snk" to "სონინკე",
    "so" to "სომალიური",
    "sq" to "ალბანური",
    "sr" to "სერბული",
    "srn" to "სრანან ტონგო",
    "ss" to "სუატი",
    "ssy" to "საჰო",
    "st" to "სამხრეთ სოთოს ენა",
    "str" to "სტრეიტს სალიში",
    "su" to "სუნდური",
    "suk" to "სუკუმა",
    "sux" to "შუმერული",
    "sv" to "შვედური",
    "sw" to "სუაჰილი",
    "sw-CD" to "კონგოს სუაჰილი",
    "swb" to "კომორული",
    "syc" to "კლასიკური სირიული",
    "syr" to "სირიული",
    "szl" to "სილესიური",
    "ta" to "ტამილური",
    "tce" to "სამხრეთ ტუჩონი",
    "te" to "ტელუგუ",
    "tem" to "ტინმე",
    "teo" to "ტესო",
    "tet" to "ტეტუმი",
    "tg" to "ტაჯიკური",
    "tgx" to "ტაგიში",
    "th" to "ტაილანდური",
    "tht" to "ტალტანი",
    "ti" to "ტიგრინია",
    "tig" to "თიგრე",
    "tk" to "თურქმენული",
    "tlh" to "კლინგონი",
    "tli" to "ტლინგიტი",
    "tn" to "ტსვანა",
    "to" to "ტონგანური",
    "tok" to "ტოკი-პონა",
    "tpi" to "ტოკ-პისინი",
    "tr" to "თურქული",
    "trv" to "ტაროკო",
    "ts" to "ტსონგა",
    "tt" to "თათრული",
    "ttm" to "ჩრდილოეთ ტუჩონი",
    "tum" to "ტუმბუკა",
    "tvl" to "ტუვალუ",
    "tw" to "თუი",
    "twq" to "ტასავაქი",
    "ty" to "ტაიტური",
    "tyv" to "ტუვა",
    "tzm" to "ცენტრალური მოროკოს ტამაზიგხტი",
    "udm" to "უდმურტული",
    "ug" to "უიღურული",
    "uga" to "უგარითული",
    "uk" to "უკრაინული",
    "umb" to "უმბუნდუ",
    "und" to "უცნობი ენა",
    "ur" to "ურდუ",
    "uz" to "უზბეკური",
    "vai" to "ვაი",
    "ve" to "ვენდა",
    "vec" to "ვენეციური",
    "vi" to "ვიეტნამური",
    "vmw" to "მაკჰუვა",
    "vo" to "ვოლაპუკი",
    "vun" to "ვუნჯო",
    "wa" to "ვალონური",
    "wae" to "ვალსერი",
    "wal" to "ველაითა",
    "war" to "ვარაი",
    "wbp" to "ვალპირი",
    "wo" to "ვოლოფური",
    "wuu" to "ვუ",
    "xal" to "ყალმუხური",
    "xh" to "ქჰოსა",
    "xnr" to "კანგრი",
    "xog" to "სოგა",
    "yav" to "იანგბენი",
    "ybb" to "იემბა",
    "yi" to "იდიში",
    "yo" to "იორუბა",
    "yrl" to "ნენგატუ",
    "yue" to "კანტონური",
    "yue-alt-menu" to "ჩინური, კანტონური",
    "za" to "ზჰუანგი",
    "zbl" to "ბლისსიმბოლოები",
    "zen" to "ზენაგა",
    "zgh" to "სტანდარტული მაროკოული ტამაზიგხტი",
    "zh" to "ჩინური",
    "zh-alt-menu" to "ჩინური, მანდარინი",
    "zh-Hans" to "გამარტივებული ჩინური",
    "zh-Hans-alt-long" to "გამარტივებული ჩინური მანდარინი",
    "zh-Hant" to "ტრადიციული ჩინური",
    "zh-Hant-alt-long" to "ტრადიციული ჩინური მანდარინი",
    "zu" to "ზულუ",
    "zun" to "ზუნი",
    "zxx" to "ლინგვისტური შიგთავსი არ არის",
    "zza" to "ზაზაკი",
  ) }

  val kaa: ImmutableMap<String, String> by lazy { immutableMapOf(
    "de" to "немецше",
    "de-AT" to "немецше (Австрия)",
    "de-CH" to "немецше (Швейцария)",
    "fr" to "французша",
    "fr-CA" to "французша (Канада)",
    "fr-CH" to "французша (Швейцария)",
    "hi-Latn" to "ҳиндше (латын)",
    "hi-Latn-alt-variant" to "ҳинглиш (латын)",
    "it" to "итальянша",
    "ja" to "японша",
    "kaa" to "қарақалпақша",
    "ko" to "корейсше",
    "zh" to "қытайша",
    "zh-alt-menu" to "қытайша",
  ) }

  val kaa_Cyrl: ImmutableMap<String, String> by lazy { immutableMapOf(
    "de" to "немецше",
    "de-AT" to "немецше (Австрия)",
    "de-CH" to "немецше (Швейцария)",
    "fr" to "французша",
    "fr-CA" to "французша (Канада)",
    "fr-CH" to "французша (Швейцария)",
    "hi-Latn" to "ҳиндше (латын)",
    "hi-Latn-alt-variant" to "ҳинглиш (латын)",
    "it" to "итальянша",
    "ja" to "японша",
    "kaa" to "қарақалпақша",
    "ko" to "корейсше",
    "zh" to "қытайша",
    "zh-alt-menu" to "қытайша",
  ) }

  val kab: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Takanit",
    "am" to "Tamahrict",
    "ar" to "Taɛrabt",
    "be" to "Tabilarusit",
    "bg" to "Tabulgarit",
    "bn" to "Tabengalit",
    "cs" to "Tačikit",
    "de" to "Talmant",
    "el" to "Tagrikit",
    "en" to "Taglizit",
    "es" to "Taspenyulit",
    "fa" to "Tafarisit",
    "fr" to "Tafransist",
    "ha" to "Tahwasit",
    "hi" to "Tahendit",
    "hu" to "Tahungarit",
    "id" to "Tandunisit",
    "ig" to "Tigbut",
    "it" to "Taṭalyanit",
    "ja" to "Tajapunit",
    "jv" to "Tajavanit",
    "kab" to "Taqbaylit",
    "km" to "Takemrit",
    "ko" to "Takurit",
    "ms" to "Tamalawit",
    "my" to "Taburmisit",
    "ne" to "Tanipalit",
    "nl" to "Tadučit",
    "pa" to "Tapunjabit",
    "pl" to "Tapulunit",
    "pt" to "Tapurtugalit",
    "ro" to "Tarumanit",
    "ru" to "Tarusit",
    "rw" to "Taruwandit",
    "so" to "Taṣumalit",
    "sv" to "Taswidit",
    "ta" to "Taṭamulit",
    "th" to "Taṭaylundit",
    "tr" to "Taṭurkit",
    "uk" to "Tukranit",
    "ur" to "Turdut",
    "vi" to "Tabyiṭnamit",
    "yo" to "Tayurubit",
    "zh" to "Tacinwat, Tamundarint",
    "zh-alt-menu" to "Tacinwat, Tamundarint",
    "zu" to "Tazulut",
  ) }

  val kaj: ImmutableMap<String, String> by lazy { immutableMapOf(
    "kaj" to "Kaje",
  ) }

  val kam: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Kiakan",
    "am" to "Kiamhari",
    "ar" to "Kiarabu",
    "be" to "Kibelarusi",
    "bg" to "Kibulgaria",
    "bn" to "Kibangla",
    "cs" to "Kichecki",
    "de" to "Kijerumani",
    "el" to "Kigiriki",
    "en" to "Kingereza",
    "es" to "Kihispania",
    "fa" to "Kiajemi",
    "fr" to "Kifaransa",
    "ha" to "Kihausa",
    "hi" to "Kihindi",
    "hu" to "Kihungari",
    "id" to "Kiindonesia",
    "ig" to "Kiigbo",
    "it" to "Kiitaliano",
    "ja" to "Kijapani",
    "jv" to "Kijava",
    "kam" to "Kikamba",
    "km" to "Kikambodia",
    "ko" to "Kikorea",
    "ms" to "Kimalesia",
    "my" to "Kiburma",
    "ne" to "Kinepali",
    "nl" to "Kiholanzi",
    "pa" to "Kipunjabi",
    "pl" to "Kipolandi",
    "pt" to "Kireno",
    "ro" to "Kiromania",
    "ru" to "Kirusi",
    "rw" to "Kinyarwanda",
    "so" to "Kisomali",
    "sv" to "Kiswidi",
    "ta" to "Kitamil",
    "th" to "Kitailandi",
    "tr" to "Kituruki",
    "uk" to "Kiukrania",
    "ur" to "Kiurdu",
    "vi" to "Kivietinamu",
    "yo" to "Kiyoruba",
    "zh" to "Kichina",
    "zh-alt-menu" to "Kichina",
    "zu" to "Kizulu",
  ) }

  val kcg: ImmutableMap<String, String> by lazy { immutableMapOf(
    "kcg" to "Katab",
  ) }

  val kde: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Chakan",
    "am" to "Chamhali",
    "ar" to "Chalabu",
    "be" to "Chibelalusi",
    "bg" to "Chibulgalia",
    "bn" to "Chibangla",
    "cs" to "Chichechi",
    "de" to "Chidyelumani",
    "el" to "Chigilichi",
    "en" to "Chiingeleza",
    "es" to "Chihispania",
    "fa" to "Chiajemi",
    "fr" to "Chifalansa",
    "ha" to "Chihausa",
    "hi" to "Chihindi",
    "hu" to "Chihungali",
    "id" to "Chiiongonesia",
    "ig" to "Chiigbo",
    "it" to "Chiitaliano",
    "ja" to "Chidyapani",
    "jv" to "Chidyava",
    "kde" to "Chimakonde",
    "km" to "Chikambodia",
    "ko" to "Chikolea",
    "ms" to "Chimalesia",
    "my" to "Chibulma",
    "ne" to "Chinepali",
    "nl" to "Chiholanzi",
    "pa" to "Chipunjabi",
    "pl" to "Chipolandi",
    "pt" to "Chileno",
    "ro" to "Chilomania",
    "ru" to "Chilusi",
    "rw" to "Chinyalwanda",
    "so" to "Chisomali",
    "sv" to "Chiswidi",
    "ta" to "Chitamil",
    "th" to "Chitailandi",
    "tr" to "Chituluchi",
    "uk" to "Chiuklania",
    "ur" to "Chiuldu",
    "vi" to "Chivietinamu",
    "yo" to "Chiyoluba",
    "zh" to "Chichina",
    "zh-alt-menu" to "Chichina",
    "zu" to "Chizulu",
  ) }

  val kea: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ab" to "abkáziu",
    "af" to "afrikaner",
    "agq" to "aghem",
    "ak" to "akan",
    "am" to "amáriku",
    "ar" to "árabi",
    "ar-001" to "árabi mudernu",
    "arn" to "araukanu",
    "as" to "asames",
    "asa" to "asu",
    "ast" to "asturianu",
    "ay" to "aimara",
    "az" to "azerbaijanu",
    "az-alt-short" to "azeri",
    "ba" to "baxkir",
    "ban" to "balines",
    "bas" to "basa",
    "be" to "bielorusu",
    "bem" to "bemba",
    "bez" to "bena",
    "bg" to "búlgaru",
    "bm" to "bambara",
    "bn" to "bengali",
    "bo" to "tibetanu",
    "br" to "bretãu",
    "brx" to "bodo",
    "bs" to "bosniu",
    "ca" to "katalãu",
    "ccp" to "xakma",
    "ce" to "txetxenu",
    "ceb" to "sebuanu",
    "cgg" to "xiga",
    "chr" to "xeroki",
    "ckb" to "kurdu sentral",
    "ckb-alt-menu" to "kurdu sentral",
    "ckb-alt-variant" to "kurdu sentral",
    "co" to "kórsiku",
    "cs" to "txeku",
    "cu" to "slavu klériku",
    "cv" to "txuvaxi",
    "cy" to "gales",
    "da" to "dinamarkes",
    "dav" to "taita",
    "de" to "alemon",
    "de-AT" to "alemon austríaku",
    "de-CH" to "alemon altu suisu",
    "dje" to "zarma",
    "dsb" to "sórbiu baxu",
    "dua" to "duala",
    "dyo" to "jola-fonyi",
    "dz" to "dzonka",
    "ebu" to "embu",
    "ee" to "eve",
    "el" to "gregu",
    "en" to "ingles",
    "en-AU" to "ingles australianu",
    "en-CA" to "ingles kanadianu",
    "en-GB" to "ingles britániku",
    "en-GB-alt-short" to "ingles (R.U.)",
    "en-US" to "ingles merkanu",
    "en-US-alt-short" to "ingles (S.U.)",
    "eo" to "sperantu",
    "es" to "spanhol",
    "es-419" to "spanhol latinu-merkanu",
    "es-ES" to "spanhol europeu",
    "es-MX" to "spanhol mexikanu",
    "et" to "stonianu",
    "eu" to "basku",
    "ewo" to "ewondo",
    "fa" to "persa",
    "ff" to "fula",
    "fi" to "finlandes",
    "fil" to "filipinu",
    "fj" to "fijianu",
    "fo" to "faroes",
    "fr" to "franses",
    "fr-CA" to "franses kanadianu",
    "fr-CH" to "franses suisu",
    "fur" to "friulanu",
    "fy" to "fríziu osidental",
    "ga" to "irlandes",
    "gag" to "gagauz",
    "gl" to "galegu",
    "gn" to "guarani",
    "gsw" to "alemon suisu",
    "gu" to "gujarati",
    "guz" to "gusii",
    "gv" to "manks",
    "ha" to "auza",
    "haw" to "avaianu",
    "he" to "ebraiku",
    "hi" to "indi",
    "hmn" to "hmong",
    "hr" to "kroata",
    "hsb" to "sórbiu altu",
    "ht" to "aitianu",
    "hu" to "úngaru",
    "hy" to "arméniu",
    "ia" to "interlingua",
    "id" to "indonéziu",
    "ig" to "ibo",
    "ii" to "nuosu",
    "is" to "islandes",
    "it" to "italianu",
    "iu" to "inuktitut",
    "ja" to "japones",
    "jgo" to "ñomba",
    "jmc" to "matxame",
    "jv" to "javanes",
    "ka" to "jorjianu",
    "kab" to "kabila",
    "kam" to "kamba",
    "kde" to "makonde",
    "kea" to "kabuverdianu",
    "khq" to "koira txiini",
    "ki" to "kikuiu",
    "kk" to "kazak",
    "kkj" to "kako",
    "kl" to "groenlandes",
    "kln" to "kalenjin",
    "km" to "kmer",
    "kn" to "kanares",
    "ko" to "korianu",
    "koi" to "komi-permiak",
    "kok" to "konkani",
    "ks" to "kaxmira",
    "ksf" to "bafia",
    "ksh" to "kolonhanu",
    "ku" to "kurdu",
    "kw" to "kórniku",
    "ky" to "kirgiz",
    "la" to "latin",
    "lag" to "langi",
    "lb" to "luxemburges",
    "lg" to "luganda",
    "lkt" to "lakota",
    "ln" to "lingala",
    "lo" to "lausianu",
    "lt" to "lituanu",
    "lu" to "luba-katanga",
    "luo" to "luo",
    "luy" to "luyia",
    "lv" to "letãu",
    "mg" to "malgaxi",
    "mgh" to "makua",
    "mi" to "maori",
    "mk" to "masedóniu",
    "ml" to "malaialam",
    "mr" to "marati",
    "ms" to "maláiu",
    "mt" to "maltes",
    "my" to "birmanes",
    "nb" to "norueges bokmål",
    "nds" to "alemon baxu",
    "ne" to "nepales",
    "nl" to "olandes",
    "nl-BE" to "flamengu",
    "nmg" to "kuazio",
    "nn" to "norueges nynorsk",
    "om" to "oromo",
    "or" to "odía",
    "os" to "osétiku",
    "pa" to "pandjabi",
    "pl" to "pulaku",
    "prg" to "prusianu",
    "ps" to "paxto",
    "pt" to "purtuges",
    "pt-BR" to "purtuges brazileru",
    "pt-PT" to "purtuges europeu",
    "qu" to "kexua",
    "quc" to "kitxe",
    "rm" to "romanxi",
    "rn" to "rundi",
    "ro" to "rumenu",
    "ro-MD" to "rumenu moldáviku",
    "rof" to "rombu",
    "ru" to "rusu",
    "rw" to "kiniaruanda",
    "rwk" to "rwa",
    "sa" to "sánskritu",
    "sd" to "sindi",
    "ses" to "koiraboro seni",
    "si" to "singales",
    "sk" to "slovaku",
    "sl" to "slovéniu",
    "smn" to "inari sami",
    "so" to "somali",
    "sq" to "albanes",
    "sr" to "sérviu",
    "su" to "sundanes",
    "sv" to "sueku",
    "sw" to "suaíli",
    "sw-CD" to "suaíli kongoles",
    "ta" to "tamil",
    "te" to "telugu",
    "tg" to "tadjiki",
    "th" to "tailandes",
    "ti" to "tigrinia",
    "tk" to "turkmenu",
    "to" to "tonganes",
    "tr" to "turku",
    "tt" to "tatar",
    "tzm" to "tamaziti di Atlas Sentral",
    "ug" to "uigur",
    "uk" to "ukranianu",
    "und" to "língua diskonxedu",
    "ur" to "urdu",
    "uz" to "uzbeki",
    "vi" to "vietnamita",
    "wo" to "uolof",
    "xh" to "koza",
    "yo" to "ioruba",
    "yue" to "kantunes",
    "yue-alt-menu" to "kantunes (tradisional)",
    "zgh" to "tamazait marokinu padron",
    "zh" to "xines",
    "zh-alt-menu" to "xines, mandarin",
    "zh-Hans" to "xines simplifikadu",
    "zh-Hans-alt-long" to "xines mandarin (simplificadu)",
    "zh-Hant" to "xines tradisional",
    "zh-Hant-alt-long" to "xines mandarin (tradisional)",
    "zu" to "zulu",
    "zxx" to "sen kontiudu linguístiku",
  ) }

  val ken: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ken" to "Kɛnyaŋ",
  ) }

  val kgp: ImmutableMap<String, String> by lazy { immutableMapOf(
    "aa" to "afar",
    "ab" to "amekaso",
    "ace" to "agsẽm",
    "ach" to "akori",
    "ada" to "anágme",
    "ady" to "anhige",
    "ae" to "avétiko",
    "af" to "afrikỹnẽ",
    "afh" to "afrihiri",
    "agq" to "aghẽm",
    "ain" to "ajinũ",
    "ak" to "akỹn",
    "akk" to "akajỹnũ",
    "ale" to "arevute",
    "alt" to "artaj sur",
    "am" to "amỹriko",
    "an" to "aragonẽ",
    "ang" to "ĩnhgrej arkajiku",
    "anp" to "ỹgika",
    "ar" to "arame",
    "ar-001" to "arame ta’ũn",
    "arc" to "aramajiko",
    "arn" to "mỹpunugũn",
    "arp" to "arapaho",
    "ars" to "arame nẽgene",
    "arw" to "aruvaki",
    "as" to "ajamẽ",
    "asa" to "asu",
    "ast" to "anhturijỹnũ",
    "av" to "avariko",
    "awa" to "avanhi",
    "ay" to "ajimỹra",
    "az" to "ajermajỹnũ",
    "az-alt-short" to "ajermajỹnũ",
    "az-Arab" to "aseri sur",
    "ba" to "majkir",
    "bal" to "marusi",
    "ban" to "marinẽj",
    "bas" to "masa",
    "bax" to "mamũm",
    "bbj" to "gumỹra",
    "be" to "huso-kupri",
    "bej" to "meja",
    "bem" to "mema",
    "bez" to "menỹ",
    "bfd" to "mafun",
    "bg" to "mugaru",
    "bgn" to "marusi-rãpurja",
    "bho" to "mojpuri",
    "bi" to "miramá",
    "bik" to "mikor",
    "bin" to "minĩ",
    "bkm" to "kãm",
    "bla" to "sigsika",
    "bm" to "mámara",
    "bn" to "megari",
    "bo" to "timetỹnũ",
    "br" to "mretỹ",
    "bra" to "mraj",
    "brx" to "mono",
    "bs" to "mojnia",
    "bss" to "akuse",
    "bua" to "murijato",
    "bug" to "muginẽj",
    "bum" to "muru",
    "byn" to "mrĩn",
    "byv" to "menuma",
    "ca" to "katarũg",
    "cad" to "kano",
    "car" to "karime",
    "cay" to "kajuga",
    "cch" to "ansỹm",
    "ccp" to "sakimỹ",
    "ce" to "sesẽnũ",
    "ceb" to "semujỹnũ",
    "cgg" to "siga",
    "ch" to "samãhu",
    "chb" to "simsa",
    "chg" to "sagataj",
    "chk" to "sukese",
    "chm" to "mỹri",
    "chn" to "jargỹ sinũki",
    "cho" to "sogtavo",
    "chp" to "sipevyjỹ",
    "chr" to "seroki",
    "chy" to "sejẽnẽ",
    "ckb" to "kurno kuju",
    "ckb-alt-menu" to "kurno kuju",
    "ckb-alt-variant" to "kurno kuju",
    "co" to "korso",
    "cop" to "komta",
    "cr" to "kri",
    "crh" to "krimẽja tá turko",
    "crs" to "sejséri krijoro-frỹsej",
    "cs" to "séko",
    "csb" to "kasumijỹ",
    "cu" to "eravu ekresijatiko",
    "cv" to "suvase",
    "cy" to "garej",
    "da" to "nhinỹmỹrkej",
    "dak" to "nakota",
    "dar" to "narguva",
    "dav" to "tajta",
    "de" to "arimỹv",
    "de-CH" to "suvisa arimỹv-téj",
    "del" to "neravare",
    "den" to "sirave",
    "dgr" to "nogrim",
    "din" to "ninka",
    "dje" to "jarma",
    "doi" to "nogri",
    "dsb" to "soramiv rur",
    "dua" to "nuvara",
    "dum" to "orỹnej kuju",
    "dv" to "nivehi",
    "dyo" to "jora-fonyj",
    "dyu" to "nhivura",
    "dz" to "jãnga",
    "dzg" to "najaga",
    "ebu" to "ẽmu",
    "ee" to "eve",
    "efi" to "efike",
    "egy" to "ejimso arkajku",
    "eka" to "ekajuki",
    "el" to "gregu",
    "elx" to "eramĩte",
    "en" to "ĩnhgrej",
    "enm" to "ĩnhgrej kuju",
    "eo" to "enhperỹtu",
    "es" to "enhpỹjór",
    "et" to "enhtonĩjỹnũ",
    "eu" to "manhku",
    "ewo" to "evãnu",
    "fa" to "pérsa",
    "fan" to "fỹnge",
    "fat" to "fỹti",
    "ff" to "fura",
    "fi" to "fĩranẽj",
    "fil" to "firipĩnũ",
    "fj" to "fijỹnũ",
    "fo" to "fervej",
    "fon" to "fãm",
    "fr" to "frỹsej",
    "frc" to "frỹsej kajũn",
    "frm" to "frỹsej kuju",
    "fro" to "frỹsej arkajku",
    "frr" to "friso tỹ nãrti",
    "frs" to "frisỹ rãjur",
    "fur" to "frijurỹnũ",
    "fy" to "friso rãpur",
    "ga" to "irỹnej",
    "gaa" to "ga",
    "gag" to "gagavuj",
    "gan" to "gỹn",
    "gay" to "gajo",
    "gba" to "gemaja",
    "gd" to "gajériko enhkosej",
    "gez" to "gij",
    "gil" to "gimertej",
    "gl" to "garego",
    "gmh" to "arimỹv-téj kuju",
    "gn" to "góranĩ",
    "goh" to "arimỹv-téj arkajku",
    "gon" to "gãnni",
    "gor" to "gorãntar",
    "got" to "gótiko",
    "grb" to "gremo",
    "grc" to "gregu arkajku",
    "gsw" to "arimỹv (Suvisa)",
    "gu" to "gujerati",
    "guz" to "gusij",
    "gv" to "mỹnsi",
    "gwi" to "guvisĩn",
    "ha" to "havusa",
    "hai" to "hajna",
    "hak" to "haka",
    "haw" to "havajỹnũ",
    "he" to "emrajko",
    "hi" to "hĩni",
    "hil" to "hirigajnãn",
    "hit" to "hitita",
    "hmn" to "hymãg",
    "ho" to "hiri motu",
    "hr" to "krovata",
    "hsb" to "soramiv téj",
    "hsn" to "sijỹg",
    "ht" to "hajtijỹnũ",
    "hu" to "ũgaru",
    "hup" to "hupa",
    "hy" to "armẽnĩju",
    "hz" to "herero",
    "ia" to "vĩ-jãgja",
    "iba" to "iman",
    "ibb" to "imimijo",
    "id" to "ĩnonẽsijo",
    "ie" to "vĩ-ag kuju ki",
    "ig" to "igmo",
    "ii" to "sisuvỹ ji",
    "ik" to "ĩnũpijake",
    "ilo" to "irukỹnũ",
    "inh" to "ĩnguse",
    "io" to "ino",
    "is" to "kukryr",
    "it" to "itarijỹnũ",
    "iu" to "inugtituti",
    "ja" to "japonẽj",
    "jbo" to "rojmán",
    "jgo" to "gẽma",
    "jmc" to "mỹsame",
    "jpr" to "junajko-pérsa",
    "jrb" to "junajko-aramiko",
    "jv" to "javanẽj",
    "ka" to "jiórjijỹnũ",
    "kaa" to "kara-karkag",
    "kab" to "kamyre",
    "kac" to "kasĩn",
    "kaj" to "ju",
    "kam" to "kỹma",
    "kaw" to "kavi",
    "kbd" to "kamarnhijỹnũ",
    "kbl" to "kanẽnmu",
    "kcg" to "tyjam",
    "kde" to "mỹkãne",
    "kea" to "pu-tánh-vĩ",
    "kfo" to "koro",
    "kg" to "kãgorej",
    "kgp" to "kanhgág",
    "kha" to "kasi",
    "kho" to "kotanẽj",
    "khq" to "kujra sĩnĩ",
    "ki" to "kikuju",
    "kj" to "kuvanhỹmỹ",
    "kk" to "kajake",
    "kkj" to "kako",
    "kl" to "grohẽrỹnej",
    "kln" to "karẽnjĩn",
    "km" to "kymẽr",
    "kmb" to "kĩmuno",
    "kn" to "kanỹrim",
    "ko" to "korejỹnũ",
    "koi" to "komĩ-permyjag",
    "kok" to "kãkani",
    "kos" to "kosirajỹn",
    "kpe" to "kepere",
    "kr" to "kanũri",
    "krc" to "karasaj-markar",
    "krl" to "karérijo",
    "kru" to "kurug",
    "ks" to "kasemĩra",
    "ksb" to "sỹmara",
    "ksf" to "mafija",
    "ksh" to "kárysi",
    "ku" to "kurno",
    "kum" to "kumyg",
    "kut" to "kutenaj",
    "kv" to "komĩ",
    "kw" to "kórnĩko",
    "ky" to "kirginh",
    "la" to "ratĩnh",
    "lad" to "raninũ",
    "lag" to "rỹngi",
    "lah" to "rahina",
    "lam" to "rỹma",
    "lb" to "rusẽmurgej",
    "lez" to "resgi",
    "lg" to "rugỹna",
    "li" to "rĩmurgej",
    "lkt" to "rakóta",
    "ln" to "rĩgara",
    "lo" to "raosijỹnũ",
    "lol" to "mãgo",
    "lou" to "rovusijỹnỹ tá ke pẽ",
    "loz" to "roji",
    "lrc" to "ruri nãrti",
    "lt" to "rituvỹnũ",
    "lu" to "ruma-katỹga",
    "lua" to "ruma-ruruva",
    "lui" to "rujsẽnũ",
    "lun" to "rũna",
    "luo" to "ruvo",
    "lus" to "rusaj",
    "luy" to "ruja",
    "lv" to "retỹv",
    "mad" to "mỹnurej",
    "maf" to "mafa",
    "mag" to "mỹgahi",
    "mai" to "mỹjtiri",
    "mak" to "mỹkasar",
    "man" to "mỹnhĩga",
    "mas" to "mỹsaj",
    "mde" to "mama",
    "mdf" to "mogsa",
    "mdr" to "mỹnar",
    "men" to "mẽne",
    "mer" to "mẽru",
    "mfe" to "mãrisijẽn",
    "mg" to "mỹrgase",
    "mga" to "irỹnej kuju",
    "mgh" to "mỹkuva",
    "mgo" to "mẽta",
    "mh" to "mỹrsarej",
    "mi" to "mỹvóri",
    "mic" to "mĩkemỹke",
    "min" to "mĩnỹgkamavu",
    "mk" to "mỹsenojũ",
    "ml" to "mỹrajara",
    "mn" to "mãgór",
    "mnc" to "mỹsu",
    "mni" to "mỹnĩpuri",
    "moh" to "mãjkỹnũ",
    "mos" to "mosi",
    "mr" to "marati",
    "ms" to "mỹrajo",
    "mt" to "mỹrtej",
    "mua" to "mũnág",
    "mul" to "vẽnhvĩ’e",
    "mus" to "krig",
    "mwl" to "mĩrỹnej",
    "mwr" to "mỹrvari",
    "my" to "mirmỹnẽj",
    "mye" to "myene",
    "myv" to "érsija",
    "mzn" to "mỹsánarỹni",
    "na" to "nỹvuruvánũ",
    "nan" to "mĩn nỹn",
    "nap" to "nỹporitỹnũ",
    "naq" to "nỹmỹ",
    "nb" to "mógmỹr nãrovegej",
    "nd" to "nemere nãrti",
    "nds" to "arimỹv rur",
    "nds-NL" to "sagsỹv rur",
    "ne" to "nẽparej",
    "new" to "nẽvari",
    "ng" to "nogã",
    "nia" to "nĩja",
    "niu" to "nivuvejỹnũ",
    "nl" to "orỹnej",
    "nl-BE" to "framẽgo",
    "nmg" to "kivasijo",
    "nn" to "nĩnãrsig nãrovegej",
    "nnh" to "gijẽmun",
    "no" to "nãrovegej",
    "nog" to "nãgaj",
    "non" to "nãrniko arkajku",
    "nqo" to "nyko",
    "nr" to "nemere sur",
    "nso" to "soto nãrti",
    "nus" to "nũver",
    "nv" to "nỹvaho",
    "nwc" to "nẽvari há tỹvĩ",
    "ny" to "nĩjỹnja",
    "nym" to "nyjỹm-vesi",
    "nyn" to "nyjỹmkore",
    "nyo" to "nyjor",
    "nzi" to "nĩsimỹ",
    "oc" to "ogsitỹnũ",
    "oj" to "ojimva",
    "om" to "orãmũ",
    "or" to "orija",
    "os" to "oseto",
    "osa" to "osage",
    "ota" to "turko otomỹnũ",
    "pa" to "pỹjami",
    "pag" to "pangasinỹ",
    "pal" to "paravi",
    "pam" to "pampỹga",
    "pap" to "papijamẽto",
    "pau" to "paravỹnũ",
    "pcm" to "pingĩn nĩjerijỹnũ",
    "peo" to "pérsa arkajku",
    "phn" to "fenĩso",
    "pi" to "pari",
    "pl" to "poronẽj",
    "pon" to "pãnhpejỹnũ",
    "prg" to "prusijỹnũ",
    "pro" to "provẽsar arkajku",
    "ps" to "pasito",
    "ps-alt-variant" to "pusito",
    "pt" to "fóg-vĩ",
    "qu" to "kinsuva",
    "quc" to "kisé",
    "raj" to "hajanhtỹnĩ",
    "rap" to "hapanũj",
    "rar" to "harotãganũ",
    "rm" to "homỹse",
    "rn" to "hũni",
    "ro" to "homẽnũ",
    "ro-MD" to "mãrnavijo",
    "rof" to "hãmo",
    "rom" to "homỹnĩ",
    "ru" to "huso",
    "rup" to "aromẽnũ",
    "rw" to "kinĩjarvỹna",
    "rwk" to "hywa",
    "sa" to "sỹnhkrito",
    "sad" to "sỹnave",
    "sah" to "saka",
    "sam" to "aramỹjko samaritỹnũ",
    "saq" to "sỹmuru",
    "sas" to "sasag",
    "sat" to "sỹtari",
    "sba" to "gỹmaji",
    "sbp" to "sỹgu",
    "sc" to "sarno",
    "scn" to "sisirijỹnũ",
    "sco" to "isikoti",
    "sd" to "sĩni",
    "sdh" to "kurno sur",
    "se" to "samĩ nãrti",
    "see" to "senẽka",
    "seh" to "senỹ",
    "sel" to "serkum",
    "ses" to "kojyramoro senĩ",
    "sg" to "sỹgo",
    "sga" to "irỹnej arkajku",
    "sh" to "servo-krovata",
    "shi" to "tasehiti",
    "shn" to "sỹn",
    "shu" to "arame sanijỹnũ",
    "si" to "sĩgarej",
    "sid" to "sinamũ",
    "sk" to "erovako",
    "sl" to "erovenũ",
    "sm" to "samovỹnũ",
    "sma" to "samĩ sur",
    "smj" to "samĩ Rure tá",
    "smn" to "samĩ Inari tá",
    "sms" to "samĩ Isikórti tá",
    "sn" to "sãnỹ",
    "snk" to "sãnĩke",
    "so" to "somỹri",
    "sog" to "sognijỹnũ",
    "sq" to "armánẽj",
    "sr" to "sérvijo",
    "srn" to "surinỹmẽj",
    "srr" to "serere",
    "ss" to "suvaji",
    "ssy" to "saho",
    "st" to "soto sur",
    "su" to "sunanẽj",
    "suk" to "sukumỹ",
    "sus" to "susu",
    "sux" to "sumẽrijo",
    "sv" to "suvéko",
    "sw" to "suvahiri",
    "sw-CD" to "suvahiri Kãgo tá",
    "swb" to "komorijỹnũ",
    "syc" to "sirijako há tỹvĩ",
    "syr" to "sirijako",
    "ta" to "támĩr",
    "te" to "térugo",
    "tem" to "timnẽ",
    "teo" to "teso",
    "ter" to "terẽnũ",
    "tet" to "tétũm",
    "tg" to "tanhike",
    "th" to "tajrỹnej",
    "ti" to "tigrinĩja",
    "tig" to "tigré",
    "tiv" to "tivi",
    "tk" to "turkomẽnũ",
    "tkl" to "tokeravánũ",
    "tl" to "tagaro",
    "tlh" to "krĩngãg",
    "tli" to "tiringite",
    "tmh" to "tamỹséke",
    "tn" to "tisuvanỹ",
    "to" to "tãnganẽj",
    "tog" to "tãnganẽj Nyjasa tá",
    "tpi" to "tóg-pisĩn",
    "tr" to "turko",
    "trv" to "taroko",
    "ts" to "tesãga",
    "tsi" to "simsijỹnũ",
    "tt" to "tartaru",
    "tum" to "tũmuka",
    "tvl" to "tuvaruvỹnũ",
    "tw" to "tuvi",
    "twq" to "tasavag",
    "ty" to "tajtijỹnũ",
    "tyv" to "tuvinijỹnũ",
    "tzm" to "tamỹjirte Atara Kuju tá",
    "udm" to "unmũrte",
    "ug" to "ujgur",
    "uga" to "ugaritiko",
    "uk" to "ukranĩjỹnũ",
    "umb" to "ũmunu",
    "und" to "vẽnhvĩ ki kagtĩg",
    "ur" to "urnu",
    "uz" to "unhmeke",
    "vai" to "vaj",
    "ve" to "vẽna",
    "vi" to "vijétinỹmũ",
    "vo" to "vorapuke",
    "vot" to "vótiko",
    "vun" to "vũjo",
    "wa" to "varỹv",
    "wae" to "varser",
    "wal" to "vorajta",
    "war" to "varaj",
    "was" to "vaso",
    "wbp" to "varpiri",
    "wo" to "vorofe",
    "wuu" to "vu",
    "xal" to "karmĩg",
    "xh" to "sosa",
    "xog" to "rusoga",
    "yao" to "javo",
    "yap" to "japese",
    "yav" to "jỹgmen",
    "ybb" to "jẽma",
    "yi" to "jinhise",
    "yo" to "joruma",
    "yrl" to "nhẽgatu",
    "yue" to "kỹtonẽj",
    "yue-alt-menu" to "kỹtonẽj (pẽ)",
    "za" to "juvỹg",
    "zap" to "japoteko",
    "zbl" to "sĩmoru mrij",
    "zen" to "senỹga",
    "zgh" to "tamỹjirte mỹhókinũ pã",
    "zh" to "sĩnẽj",
    "zh-alt-menu" to "sĩnẽj mỹnarĩj",
    "zh-Hans" to "sĩnẽj mẽ",
    "zh-Hans-alt-long" to "sĩnẽj mỹnarĩj (mẽ)",
    "zh-Hant" to "sĩnẽj pẽ",
    "zh-Hant-alt-long" to "sĩnẽj mỹnarĩj (pẽ)",
    "zu" to "suru",
    "zun" to "sunhi",
    "zxx" to "nén ũ vẽnhvĩ ki tũ",
    "zza" to "sasaki",
  ) }

  val khq: ImmutableMap<String, String> by lazy { immutableMapOf(
    "ak" to "Akan senni",
    "am" to "Amhaarik senni",
    "ar" to "Laaraw senni",
    "be" to "Belaruus senni",
    "bg" to "Bulagaari senni",
    "bn" to "Bengali senni",
    "cs" to "Cek senni",
    "de" to "Almaŋ senni",
    "el" to "Grek senni",
    "en" to "Inglisi senni",
    "es" to "Espaaɲe senni",
    "fa" to "Farsi senni",
    "fr" to "Fransee senni",
    "ha" to "Hawsance senni",
    "hi" to "Induu senni",
    "hu" to "Hungaari senni",
    "id" to "Indoneesi senni",
    "ig" to "Iboo senni",
