/*
 * Decompiled with CFR 0.152.
 */
package com.sea.redis.util;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.sea.core.constant.CommonResultConstant;
import com.sea.core.exception.ServiceException;
import com.sea.core.util.HttpServletRequestUtil;
import com.sea.redis.constant.LoginRedisKeyConstant;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class RequestUtil
extends HttpServletRequestUtil {
    public static final String X_AUTH_TYPE = "X-Auth-Type";
    public static final String X_AUTH_TYPE_MOBILE = "mobile";
    public static final String X_AUTH_TYPE_SELLER = "seller";
    public static final String X_AUTH_TYPE_INTEGRAL = "integral";
    public static final String X_AUTH_TOKEN = "X-Auth-Token";
    public static final String X_AUTH_BELONG = "X-Auth-Belong";
    public static final String X_AUTH_BELONG_TIANQIGOU = "tianqigou";
    public static final String X_AUTH_BELONG_MINIPROGRAM = "miniprogram";
    public static final String OPEN_ID = "openId";

    public static HttpServletRequest init() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
        return request;
    }

    public static String getHeader(String key) {
        String header = RequestUtil.init().getHeader(key);
        if (StrUtil.isNotBlank((CharSequence)header)) {
            try {
                header = URLDecoder.decode(header, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return header;
    }

    public static String getUserId() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.TOKEN_USER_ID.getKey());
    }

    public static String checkUserId() {
        String userId = RequestUtil.getUserId();
        if (StrUtil.isBlank((CharSequence)userId)) {
            throw new ServiceException(CommonResultConstant.LOGIN_TIMEOUT.code(), CommonResultConstant.LOGIN_TIMEOUT.message());
        }
        return userId;
    }

    public static String getUserName() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.TOKEN_USER_NAME.getKey());
    }

    public static String getUserUsername() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.TOKEN_USER_USERNAME.getKey());
    }

    public static String getUserUsername(HttpServletRequest request) {
        return request.getHeader(LoginRedisKeyConstant.TOKEN_USER_USERNAME.getKey());
    }

    public static String getUserMobile() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.TOKEN_USER_MOBILE.getKey());
    }

    public static String getCrmUserId() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.TOKEN_USER_ID.getKey());
    }

    public static String checkCrmUserId() {
        String userId = RequestUtil.getCrmUserId();
        if (StrUtil.isBlank((CharSequence)userId)) {
            throw new ServiceException(CommonResultConstant.LOGIN_TIMEOUT.code(), CommonResultConstant.LOGIN_TIMEOUT.message());
        }
        return userId;
    }

    public static String getCrmUserName() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.TOKEN_USER_NAME.getKey());
    }

    public static String getCrmNickName() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.TOKEN_USER_NICKNAME.getKey());
    }

    public static String getCrmUserMobile() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.TOKEN_USER_MOBILE.getKey());
    }

    public static String getCrmUserCreateTime() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.MOBILE_TOKEN_USER_CREATE_TIME.getKey());
    }

    public static String getSellerUserId() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.TOKEN_USER_ID.getKey());
    }

    public static String getCrmUserHeadImg() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.TOKEN_USER_HEAD.getKey());
    }

    public static String getCrmUserRoleLevel() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.MOBILE_TOKEN_USER_ROLE.getKey());
    }

    public static String getCrmUserIsAuth() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.MOBILE_TOKEN_USER_ISAUTH.getKey());
    }

    public static String getCrmUserEndTime() {
        return RequestUtil.getHeader(LoginRedisKeyConstant.MOBILE_TOKEN_USER_ENDTIME.getKey());
    }

    public static Integer getSignUp() {
        return 2;
    }

    public static <T> void initSysCreate(T t) {
        RequestUtil.initCreate(t, (String)RequestUtil.getUserId());
    }

    public static <T> void initCrmCreate(T t) {
        RequestUtil.initCreate(t, (String)RequestUtil.getCrmUserId());
    }

    public static <T> void initSysUpdate(T t) {
        RequestUtil.initUpdate(t, (String)RequestUtil.getUserId());
    }

    public static <T> void initCrmUpdate(T t) {
        RequestUtil.initUpdate(t, (String)RequestUtil.getCrmUserId());
    }

    public static <T> void initCreate(T t) {
        RequestUtil.initCreate(t, (String)RequestUtil.getUserId());
    }

    public static <T> void initUpdate(T t) {
        RequestUtil.initUpdate(t, (String)RequestUtil.getUserId());
    }

    public static <T> void setFieldValue(T t, String name, Object value) {
        Field field = ReflectUtil.getField(t.getClass(), (String)name);
        if (null != field) {
            ReflectUtil.setFieldValue(t, (Field)field, (Object)value);
        }
    }

    public static void addHeader(HttpServletRequest request, String key, String value) {
        try {
            HttpServletRequestImpl requestImpl = (HttpServletRequestImpl)request;
            Field exchangeField = requestImpl.getClass().getDeclaredField("exchange");
            exchangeField.setAccessible(true);
            HttpServerExchange exchange = (HttpServerExchange)exchangeField.get(requestImpl);
            Field requestHeadersField = exchange.getClass().getDeclaredField("requestHeaders");
            requestHeadersField.setAccessible(true);
            HeaderMap requestHeaders = (HeaderMap)requestHeadersField.get(exchange);
            requestHeaders.add(new HttpString(key), value);
        }
        catch (Exception e) {
            throw new ServiceException(CommonResultConstant.SERRVER_ERROR.code(), CommonResultConstant.SERRVER_ERROR.message(), e);
        }
    }
}

