/*
 * Decompiled with CFR 0.152.
 */
package com.sea.redis.util;

import com.sea.redis.constant.RedissonKeyConstant;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedissonFairUtil {
    @Autowired
    private RedissonClient redissonClient;
    private static RedissonClient redisson;

    @PostConstruct
    private void init() {
        redisson = this.redissonClient;
    }

    public static RLock lock(String lockKey) {
        RLock lock = redisson.getFairLock(RedissonKeyConstant.LOCK_PREFIX.getFullKey(lockKey));
        lock.lock();
        return lock;
    }

    public static RLock lock(String lockKey, int leaseTime, TimeUnit unit) {
        RLock lock = redisson.getFairLock(RedissonKeyConstant.LOCK_PREFIX.getFullKey(lockKey));
        lock.lock((long)leaseTime, unit);
        return lock;
    }

    public static boolean tryLock(String lockKey, long waitTime, long leaseTime, TimeUnit unit) {
        RLock lock = redisson.getFairLock(RedissonKeyConstant.LOCK_PREFIX.getFullKey(lockKey));
        try {
            return lock.tryLock(waitTime, leaseTime, unit);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static void unlock(String lockKey) {
        RLock lock = redisson.getFairLock(RedissonKeyConstant.LOCK_PREFIX.getFullKey(lockKey));
        lock.unlock();
    }

    public static void unlock(RLock lock) {
        lock.unlock();
    }
}

