/*
 * Decompiled with CFR 0.152.
 */
package com.sea.redis.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.sea.core.constant.CommonResultConstant;
import com.sea.core.exception.ServiceException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Resource
    RedisTemplate redisTemplate;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    public static RedisUtil redisUtil;

    @PostConstruct
    public void init() {
        redisUtil = this;
    }

    public static boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                RedisUtil.redisUtil.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean expire(String key, long time, TimeUnit type) {
        try {
            if (time > 0L) {
                RedisUtil.redisUtil.redisTemplate.expire((Object)key, time, type);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long getExpire(String key) {
        return RedisUtil.redisUtil.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public static boolean hasKey(String key) {
        try {
            return RedisUtil.redisUtil.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasKeyException(String key) {
        try {
            return RedisUtil.redisUtil.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            throw new ServiceException(CommonResultConstant.REDIS_ERROR.code(), CommonResultConstant.REDIS_ERROR.message(), e);
        }
    }

    public static void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                RedisUtil.redisUtil.redisTemplate.delete((Object)key[0]);
            } else {
                RedisUtil.redisUtil.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public static Object get(String key) {
        return key == null ? null : RedisUtil.redisUtil.redisTemplate.opsForValue().get((Object)key);
    }

    public static boolean set(String key, Object value) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                RedisUtil.redisUtil.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                RedisUtil.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return RedisUtil.redisUtil.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public static long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return RedisUtil.redisUtil.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public static Object hget(String key, String item) {
        return RedisUtil.redisUtil.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public static Map<Object, Object> hmget(String key) {
        return RedisUtil.redisUtil.redisTemplate.opsForHash().entries((Object)key);
    }

    public static boolean hmset(String key, Map<String, Object> map) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                RedisUtil.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hset(String key, String item, Object value) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hset(String key, String item, Object value, long time) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                RedisUtil.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void hdel(String key, Object ... item) {
        RedisUtil.redisUtil.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public static boolean hHasKey(String key, String item) {
        return RedisUtil.redisUtil.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public static double hincr(String key, String item, double by) {
        return RedisUtil.redisUtil.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public static double hdecr(String key, String item, double by) {
        return RedisUtil.redisUtil.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public static Set<Object> sGet(String key) {
        try {
            return RedisUtil.redisUtil.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean sHasKey(String key, Object value) {
        try {
            return RedisUtil.redisUtil.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long sSet(String key, Object ... values) {
        try {
            return RedisUtil.redisUtil.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = RedisUtil.redisUtil.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                RedisUtil.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long sGetSetSize(String key) {
        try {
            return RedisUtil.redisUtil.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long setRemove(String key, Object ... values) {
        try {
            Long count = RedisUtil.redisUtil.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static List<Object> lGet(String key, long start, long end) {
        try {
            return RedisUtil.redisUtil.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long lGetListSize(String key) {
        try {
            return RedisUtil.redisUtil.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static Object lGetIndex(String key, long index) {
        try {
            return RedisUtil.redisUtil.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean lSet(String key, Object value) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean lSet(String key, Object value, long time) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                RedisUtil.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean lSet(String key, List<Object> value) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean lSet(String key, List<Object> value, long time) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                RedisUtil.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean lUpdateIndex(String key, long index, Object value) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long lRemove(String key, long count, Object value) {
        try {
            Long remove = RedisUtil.redisUtil.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean mSet(Map<String, Object> maps) {
        try {
            RedisUtil.redisUtil.redisTemplate.opsForValue().multiSet(maps);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static List<Object> mGet(List<String> list) {
        try {
            return RedisUtil.redisUtil.redisTemplate.opsForValue().multiGet(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Set<String> getKyes(String pattern) {
        try {
            if (StrUtil.isBlank((CharSequence)pattern)) {
                return null;
            }
            return RedisUtil.redisUtil.stringRedisTemplate.keys((Object)("*" + pattern));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean delPattern(String pattern) {
        try {
            if (StrUtil.isBlank((CharSequence)pattern)) {
                return false;
            }
            Set<String> keys = RedisUtil.getKyes(pattern);
            if (CollUtil.isNotEmpty(keys)) {
                RedisUtil.redisUtil.redisTemplate.delete(keys);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }
}

