/*
 * Decompiled with CFR 0.152.
 */
package com.sea.redis.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.sea.core.constant.CommonErrorEnum;
import com.sea.core.exception.ServiceException;
import com.sea.core.util.SpringActiveUtil;
import com.sea.core.util.TransferUtil;
import com.sea.redis.constant.LoginRedisKeyConstant;
import com.sea.redis.gateway.bean.AdminAuth;
import com.sea.redis.gateway.bean.BaseInfoAuth;
import com.sea.redis.gateway.bean.MobileAuth;
import com.sea.redis.gateway.constant.AdminConstant;
import com.sea.redis.gateway.constant.MobileConstant;
import com.sea.redis.util.RedisUtil;
import com.sea.redis.util.RequestUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class LoginRedisUtil {
    private static final Logger log = LoggerFactory.getLogger(LoginRedisUtil.class);
    private static final String PRIMARY_KEY_ID = "id";
    private static final String PRIMARY_KEY_USER_ID = "userId";

    public static <T> String saveLoginRedis(T t, LoginRedisKeyConstant userType, LoginRedisKeyConstant tokenType) {
        if (!LoginRedisKeyConstant.isUserType(userType.getKey())) {
            throw new ServiceException(CommonErrorEnum.ERROR_LOGIN_USERTYPE.msg());
        }
        if (!LoginRedisKeyConstant.isTokenType(tokenType.getKey())) {
            throw new ServiceException(CommonErrorEnum.ERROR_LOGIN_TOKENTYPE.msg());
        }
        if (t == null) {
            throw new ServiceException(CommonErrorEnum.ERROR_LOGIN_OBJECT.msg());
        }
        String id = null;
        try {
            id = t instanceof AdminAuth || t instanceof MobileAuth ? ReflectUtil.getFieldValue(t, (String)PRIMARY_KEY_USER_ID).toString() : ReflectUtil.getFieldValue(t, (String)PRIMARY_KEY_ID).toString();
        }
        catch (Exception e) {
            throw new ServiceException(CommonErrorEnum.ERROR_PRIMARYKEY.msg());
        }
        if (StrUtil.isBlank((CharSequence)id)) {
            throw new ServiceException(CommonErrorEnum.ERROR_PRIMARYKEY.msg());
        }
        String tokenDataKey = LoginRedisKeyConstant.TOKEN_DATA.getFullKey(userType.getKey(), id, ":", tokenType.getKey());
        if (SpringActiveUtil.isLocal() || SpringActiveUtil.isDev() || SpringActiveUtil.isTest() || SpringActiveUtil.isUat() || SpringActiveUtil.isPre()) {
            String token = LoginRedisUtil.getToken(id, userType, tokenType);
            if (StrUtil.isNotBlank((CharSequence)token) && RedisUtil.hasKey(token)) {
                LoginRedisUtil.editLoginRedis(t, userType, tokenType);
                return token.replace(tokenType.getKey(), "");
            }
        } else {
            LoginRedisUtil.clearLoginRedis(id, userType, tokenType);
        }
        String toToken = IdUtil.simpleUUID() + RandomUtil.randomNumber() + System.currentTimeMillis();
        String token = Base64Utils.encodeToString((byte[])toToken.getBytes());
        if (userType.getKey().equals(LoginRedisKeyConstant.USER_TYPE_MOBILE.getKey())) {
            MobileAuth auth = (MobileAuth)TransferUtil.transfer(t, MobileAuth.class);
            auth.setUserId(id);
            LoginRedisUtil.writeRedis(auth, tokenType, token, 30, MobileConstant.TIME_UNIT);
        } else {
            AdminAuth auth = (AdminAuth)TransferUtil.transfer(t, AdminAuth.class);
            auth.setUserId(id);
            LoginRedisUtil.writeRedis(auth, tokenType, token, 2, AdminConstant.TIME_UNIT);
        }
        RedisUtil.lSet(tokenDataKey, token);
        return token;
    }

    public static <T> String editLoginRedis(T t, LoginRedisKeyConstant userType, LoginRedisKeyConstant tokenType) {
        List<Object> data;
        if (!LoginRedisKeyConstant.isUserType(userType.getKey())) {
            throw new ServiceException(CommonErrorEnum.ERROR_LOGIN_USERTYPE.msg());
        }
        if (!LoginRedisKeyConstant.isTokenType(tokenType.getKey())) {
            throw new ServiceException(CommonErrorEnum.ERROR_LOGIN_TOKENTYPE.msg());
        }
        if (t == null) {
            throw new ServiceException(CommonErrorEnum.ERROR_LOGIN_OBJECT.msg());
        }
        String id = null;
        try {
            id = t instanceof AdminAuth || t instanceof MobileAuth ? ReflectUtil.getFieldValue(t, (String)PRIMARY_KEY_USER_ID).toString() : ReflectUtil.getFieldValue(t, (String)PRIMARY_KEY_ID).toString();
        }
        catch (Exception e) {
            throw new ServiceException(CommonErrorEnum.ERROR_PRIMARYKEY.msg());
        }
        if (StrUtil.isBlank((CharSequence)id)) {
            throw new ServiceException(CommonErrorEnum.ERROR_PRIMARYKEY.msg());
        }
        ArrayList<String> tokens = new ArrayList<String>();
        String tokenDataKey = LoginRedisKeyConstant.TOKEN_DATA.getFullKey(userType.getKey(), id, ":", tokenType.getKey());
        if (RedisUtil.hasKey(tokenDataKey) && CollUtil.isNotEmpty(data = RedisUtil.lGet(tokenDataKey, 0L, -1L))) {
            for (int i = 0; i < data.size(); ++i) {
                BaseInfoAuth auth;
                String token = data.get(i).toString();
                boolean isExist = RedisUtil.hasKey(tokenType.getFullKey(token));
                if (!isExist) continue;
                tokens.add(token);
                if (userType.getKey().equals(LoginRedisKeyConstant.USER_TYPE_MOBILE.getKey())) {
                    auth = (MobileAuth)TransferUtil.transfer(t, MobileAuth.class);
                    auth.setUserId(id);
                    LoginRedisUtil.editRedis(MobileAuth.class, auth, tokenType, token, 30, MobileConstant.TIME_UNIT);
                    continue;
                }
                auth = (AdminAuth)TransferUtil.transfer(t, AdminAuth.class);
                auth.setUserId(id);
                LoginRedisUtil.editRedis(AdminAuth.class, auth, tokenType, token, 2, AdminConstant.TIME_UNIT);
            }
        }
        if (tokens.size() <= 0) {
            throw new ServiceException(CommonErrorEnum.ERROR_LOGIN_TOKEN_NOEXIST.msg());
        }
        return (String)tokens.get(0);
    }

    public static void clearLoginRedis(LoginRedisKeyConstant userType, LoginRedisKeyConstant tokenType) {
        LoginRedisUtil.clearLoginRedis(RequestUtil.checkUserId(), userType, tokenType);
    }

    public static void clearLoginRedis(String id, LoginRedisKeyConstant userType, LoginRedisKeyConstant tokenType) {
        List<Object> data;
        String tokenDataKey = LoginRedisKeyConstant.TOKEN_DATA.getFullKey(userType.getKey(), id, ":", tokenType.getKey());
        if (RedisUtil.hasKey(tokenDataKey) && CollUtil.isNotEmpty(data = RedisUtil.lGet(tokenDataKey, 0L, -1L))) {
            String[] tokens = new String[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                tokens[i] = tokenType.getFullKey(data.get(i).toString());
            }
            RedisUtil.del(tokens);
            RedisUtil.del(tokenDataKey);
        }
    }

    public static <T> void getLoginRedisObject(T t, LoginRedisKeyConstant userType, LoginRedisKeyConstant tokenType) {
        String token = LoginRedisUtil.getToken(RequestUtil.checkUserId(), userType, tokenType);
        LoginRedisUtil.getLoginRedisObject(token, t);
    }

    public static <T> void getLoginRedisObject(String key, T t) {
        Field[] fields = ReflectUtil.getFields(t.getClass());
        for (int i = 0; i < fields.length; ++i) {
            Object value = RedisUtil.hget(key, fields[i].getName());
            ReflectUtil.setFieldValue(t, (Field)fields[i], (Object)value);
        }
    }

    public static boolean isToken(LoginRedisKeyConstant userType, LoginRedisKeyConstant tokenType) {
        return LoginRedisUtil.isToken(RequestUtil.checkUserId(), userType, tokenType);
    }

    public static boolean isToken(String id, LoginRedisKeyConstant userType, LoginRedisKeyConstant tokenType) {
        String token = LoginRedisUtil.getToken(id, userType, tokenType);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return RedisUtil.hasKey(token);
        }
        return false;
    }

    public static String getToken(LoginRedisKeyConstant userType, LoginRedisKeyConstant tokenType) {
        return LoginRedisUtil.getToken(RequestUtil.checkUserId(), userType, tokenType);
    }

    public static String getToken(String id, LoginRedisKeyConstant userType, LoginRedisKeyConstant tokenType) {
        List<String> tokens = LoginRedisUtil.getTokens(id, userType, tokenType);
        return CollUtil.isNotEmpty(tokens) ? tokens.get(0) : null;
    }

    private static List<String> getTokens(String id, LoginRedisKeyConstant userType, LoginRedisKeyConstant tokenType) {
        List<Object> data;
        if (StrUtil.isBlank((CharSequence)id)) {
            throw new ServiceException(CommonErrorEnum.ERROR_PARAM.msg());
        }
        ArrayList<String> tokens = new ArrayList<String>();
        String tokenDataKey = LoginRedisKeyConstant.TOKEN_DATA.getFullKey(userType.getKey(), id, ":", tokenType.getKey());
        if (RedisUtil.hasKey(tokenDataKey) && CollUtil.isNotEmpty(data = RedisUtil.lGet(tokenDataKey, 0L, -1L))) {
            for (int i = 0; i < data.size(); ++i) {
                String token = data.get(i).toString();
                tokens.add(tokenType.getKey().concat(token));
            }
        }
        return tokens;
    }

    private static <R, T> void copyProperties(R r, T t) {
        Field[] fields = ReflectUtil.getFields(r.getClass());
        for (int j = 0; j < fields.length; ++j) {
            Object value = ReflectUtil.getFieldValue(r, (Field)fields[j]);
            if (value == null) continue;
            ReflectUtil.setFieldValue(t, (Field)fields[j], (Object)value);
        }
    }

    private static <T> void writeRedis(T t, LoginRedisKeyConstant tokenType, String token) {
        Field[] fields = ReflectUtil.getFields(t.getClass());
        for (int i = 0; i < fields.length; ++i) {
            Object value = ReflectUtil.getFieldValue(t, (Field)fields[i]);
            RedisUtil.hset(tokenType.getFullKey(token), fields[i].getName(), value);
        }
    }

    private static <T> void writeRedis(T t, LoginRedisKeyConstant tokenType, String token, int expire, TimeUnit timeUnit) {
        LoginRedisUtil.writeRedis(t, tokenType, token);
        RedisUtil.expire(tokenType.getFullKey(token), expire, timeUnit);
        log.info("\u5b58\u50a8\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString(t));
    }

    private static <T, U> void editRedis(Class<U> clazz, T t, LoginRedisKeyConstant tokenType, String token, int expire, TimeUnit timeUnit) {
        Object auth = ReflectUtil.newInstance(clazz, (Object[])new Object[0]);
        LoginRedisUtil.getLoginRedisObject(tokenType.getFullKey(token), auth);
        Object newAuth = TransferUtil.transfer(t, clazz);
        LoginRedisUtil.copyProperties(newAuth, auth);
        LoginRedisUtil.writeRedis(auth, tokenType, token);
        RedisUtil.expire(tokenType.getFullKey(token), expire, timeUnit);
        log.info("\u7f16\u8f91\u5b58\u50a8\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)auth));
    }
}

