/*
 * Decompiled with CFR 0.152.
 */
package com.sea.redis.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.nio.charset.Charset;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class FastjsonSerialize
implements RedisSerializer<Object> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final byte[] EMPTY_ARRAY = new byte[0];

    public static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    public byte[] serialize(Object t) throws SerializationException {
        if (t == null) {
            return EMPTY_ARRAY;
        }
        return JSON.toJSONBytes((Object)t, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.WriteDateUseDateFormat});
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (FastjsonSerialize.isEmpty(bytes)) {
            return null;
        }
        String tmp = new String(bytes, DEFAULT_CHARSET);
        return JSON.parseObject((String)tmp, Object.class, (Feature[])new Feature[]{Feature.AllowUnQuotedFieldNames});
    }
}

