/*
 * Decompiled with CFR 0.152.
 */
package com.sea.redis.constant;

import cn.hutool.core.util.StrUtil;
import java.util.concurrent.ConcurrentHashMap;

public enum LoginRedisKeyConstant {
    TOKEN_DATA("D:", "\u7528\u6237Token\u6570\u636e"),
    TOKEN_USER_ID("userId", "\u7528\u6237ID\u3010\u901a\u7528\u6570\u636e\u3011"),
    TOKEN_USER_USERNAME("username", "\u7528\u6237\u8d26\u53f7\u3010\u901a\u7528\u6570\u636e\u3011"),
    TOKEN_USER_MOBILE("mobile", "\u7528\u6237\u624b\u673a\u53f7\u7801\u3010\u901a\u7528\u6570\u636e\u3011"),
    TOKEN_USER_NAME("name", "\u7528\u6237\u59d3\u540d\u3010\u901a\u7528\u6570\u636e\u3011"),
    TOKEN_USER_NICKNAME("nickname", "\u7528\u6237\u6635\u79f0\u3010\u901a\u7528\u6570\u636e\u3011"),
    TOKEN_USER_HEAD("headimg", "\u7528\u6237\u5934\u50cf\u3010\u901a\u7528\u6570\u636e\u3011"),
    MOBILE_TOKEN_USER_NICKNAME("nickname", "\u5ba2\u6237\u6635\u79f0"),
    MOBILE_TOKEN_USER_HEADIMG("headimg", "\u5ba2\u6237\u5934\u50cf"),
    MOBILE_TOKEN_USER_CREATE_TIME("createTime", "\u5ba2\u6237\u521b\u5efa\u65f6\u95f4"),
    MOBILE_TOKEN_USER_ROLE("rolelevel", "\u5ba2\u6237\u7ea7\u522b"),
    MOBILE_TOKEN_USER_ISAUTH("isauth", "\u5ba2\u6237\u6743\u9650"),
    MOBILE_TOKEN_USER_JFMALLID("jfmallid", "\u79ef\u5206\u5546\u57ceID"),
    MOBILE_TOKEN_USER_ENDTIME("endtime", "\u5ba2\u6237\u7ed3\u675f\u65f6\u95f4"),
    TOKEN("T:", "Admin\u7aef\u767b\u5f55Token\u7c7b\u578b"),
    MOBILE_TOKEN("M:", "APP\u7aef\u767b\u5f55Token\u7c7b\u578b"),
    USER_TYPE_ADMIN("admin", "Admin\u7aef\u7528\u6237"),
    USER_TYPE_MOBILE("mobile", "APP\u7aef\u7528\u6237");

    private String key;
    private String info;
    private static ConcurrentHashMap<String, LoginRedisKeyConstant> map;

    private LoginRedisKeyConstant(String key, String info) {
        this.key = key;
        this.info = info;
    }

    public static LoginRedisKeyConstant getByKey(String key) {
        return map.get(key);
    }

    public String getKey() {
        return this.key;
    }

    public String getInfo() {
        return this.info;
    }

    public String getFullKey(String ... keys) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getKey());
        if (keys != null && keys.length > 0) {
            for (String key : keys) {
                sb.append(key);
            }
        }
        return sb.toString();
    }

    public static boolean isUserType(String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            return false;
        }
        return USER_TYPE_ADMIN.getKey().equals(key) || USER_TYPE_MOBILE.getKey().equals(key);
    }

    public static boolean isTokenType(String key) {
        if (StrUtil.isBlank((CharSequence)key)) {
            return false;
        }
        return TOKEN.getKey().equals(key) || MOBILE_TOKEN.getKey().equals(key);
    }

    static {
        map = new ConcurrentHashMap();
        for (LoginRedisKeyConstant constant : LoginRedisKeyConstant.values()) {
            map.put(constant.getKey(), constant);
        }
    }
}

