package net.coding.chenxiaobo.spring.data.jpa.filter;

import net.coding.chenxiaobo.spring.data.jpa.Specifications;
import net.coding.chenxiaobo.spring.data.jpa.extension.ConditionRestriction;
import net.coding.chenxiaobo.spring.data.jpa.extension.PredicateEntity;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

/**
 * {@link org.springframework.data.jpa.domain.Specification} 的一个实现，该类主要是用来支持
 * {@link net.coding.chenxiaobo.spring.data.jpa.filter.PropertyFilter} 进行动态查询的实现类
 *
 *
 * @author maurice
 */
public class SpecificationSupport<T> implements Specification<T>{

    private List<PropertyFilter> filters = new ArrayList<PropertyFilter>();

    public SpecificationSupport(List<PropertyFilter> filters) {
        this.filters = filters;
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        List<Predicate> list = new ArrayList<Predicate>();

        PredicateEntity entity = new PredicateEntity(root,query,builder);

        for (PropertyFilter filter : filters) {
            ConditionRestriction predicateBuilder = Specifications.getRestriction(filter.getRestrictionName());
            list.add(predicateBuilder.build(filter, entity));
        }

        return list.size() > 0 ? builder.and(list.toArray(new Predicate[list.size()])) : null;
    }
}
