
package net.coding.chenxiaobo.spring.data.jpa.extension.restriction.support;

import net.coding.chenxiaobo.spring.data.jpa.RestrictionNames;
import net.coding.chenxiaobo.spring.data.jpa.extension.restriction.SimpleConditionRestriction;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

/**
 * 右模糊约束 ( from object o where o.value like '?%') RestrictionName:RLIKE
 * <p>
 * 表达式:RLIKE属性类型_属性名称[_OR_属性名称...]
 * </p>
 * 
 * @author maurice
 *
 */
public class RLikeRestriction extends SimpleConditionRestriction {
	
	public String getRestrictionName() {
		return RestrictionNames.RLIKE;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Predicate build(Path expression, Object value,CriteriaBuilder builder) {
		
		return builder.like(expression, value + "%");
	}

}

