
package net.coding.chenxiaobo.spring.data.jpa.extension.restriction.support;

import net.coding.chenxiaobo.spring.data.jpa.RestrictionNames;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;


/**
 * 不等于约束 ( from object o where o.value <> ?) RestrictionName:NE
 * <p>
 * 表达式:NE属性类型_属性名称[_OR_属性名称...]
 * </p>
 * 
 * @author maurice
 *
 */
public class NeRestriction extends EqRestriction{

	public String getRestrictionName() {
		return RestrictionNames.NE;
	}

	public Predicate build(Path<?> expression, Object value,CriteriaBuilder builder) {
		return value == null ? builder.isNotNull(expression) : builder.notEqual(expression, value);
	}
	
}
