
package net.coding.chenxiaobo.spring.data.jpa.extension.restriction.support;

import net.coding.chenxiaobo.spring.data.jpa.RestrictionNames;
import net.coding.chenxiaobo.spring.data.jpa.extension.restriction.MultipleValueConditionRestriction;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

/**
 * 包含约束 (from object o where o.value in (?,?,?,?,?))RestrictionName:IN
 * <p>
 * 表达式:IN属性类型_属性名称[_OR_属性名称...]
 * </p>
 * 
 * @author maurice
 *
 */
public class InRestriction extends MultipleValueConditionRestriction {
	
	public String getRestrictionName() {
		return RestrictionNames.IN;
	}

	public Predicate build(Path<?> expression, Object[] values,CriteriaBuilder builder) {
		return expression.in(values);
	}
}

