
package net.coding.chenxiaobo.spring.data.jpa.extension.restriction.support;

import net.coding.chenxiaobo.spring.data.jpa.RestrictionNames;
import net.coding.chenxiaobo.spring.data.jpa.extension.restriction.SimpleConditionRestriction;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;


/**
 * 大于等于约束 (from object o where o.value >= ?)RestrictionName:GE
 * <p>
 * 表达式:GE属性类型_属性名称[_OR_属性名称...]
 * </p>
 * 
 * @author maurice
 *
 */
public class GeRestriction extends SimpleConditionRestriction {
	
	public String getRestrictionName() {
		return RestrictionNames.GE;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Predicate build(Path expression, Object value,CriteriaBuilder builder) {
		return builder.greaterThanOrEqualTo(expression, (Comparable) value);
	}

}
