
package net.coding.chenxiaobo.spring.data.jpa.extension.restriction;

import net.coding.chenxiaobo.spring.data.jpa.Specifications;
import net.coding.chenxiaobo.spring.data.jpa.extension.ConditionRestriction;
import net.coding.chenxiaobo.spring.data.jpa.extension.PredicateEntity;
import net.coding.chenxiaobo.spring.data.jpa.filter.PropertyFilter;
import net.coding.chenxiaobo.spring.data.jpa.filter.ValueExpression;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;


/**
 * 简单的条件约束实现，该条件约束只能对单个值做查询条件处理，如果是 in 或 not in 的查询扩展查看
 * {@link net.coding.chenxiaobo.spring.data.jpa.extension.restriction.MultipleValueConditionRestriction}
 *
 * @author maurice
 *
 */
public abstract class SimpleConditionRestriction implements ConditionRestriction {
	
	public Predicate build(PropertyFilter filter,PredicateEntity entity) {
		
		Predicate predicate;

        ValueExpression expression = filter.getValueExpression();
		
		if (expression.isOrExpression()) {
			predicate = entity.getCriteriaBuilder().disjunction();
		} else {
			predicate = entity.getCriteriaBuilder().conjunction();
		}
		
		for (Object value : expression.getValues()) {
            if (filter.isMultipleProperties()) {

                List<Predicate> predicates = new ArrayList<Predicate>();

                for (String property : filter.getProperties()) {
                    predicates.add(build(property, value, entity));
                }

                Predicate p = entity.getCriteriaBuilder().or(predicates.toArray(new Predicate[predicates.size()]));
                predicate.getExpressions().add(p);
            } else {
                predicate.getExpressions().add(build(filter.getProperty(), value, entity));
            }
		}
		
		return predicate;
	}
	
	public Predicate build(String propertyName, Object value,PredicateEntity entity) {
		
		return build(Specifications.getPath(propertyName, entity.getRoot()),value,entity.getCriteriaBuilder());
	}
	
	/**
	 * 
	 * 获取Jpa的约束标准
	 * 
	 * @param expression 属性路径表达式
	 * @param value 值
	 * @param builder CriteriaBuilder
	 * 
	 * @return {@link Predicate}
	 */
	public abstract Predicate build(Path<?> expression,Object value,CriteriaBuilder builder);
}
