
package net.coding.chenxiaobo.spring.data.jpa.extension.restriction;

import net.coding.chenxiaobo.spring.data.jpa.extension.PredicateEntity;
import net.coding.chenxiaobo.spring.data.jpa.filter.PropertyFilter;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

/**
 *
 * 多值条件约束，重写了
 * {@link net.coding.chenxiaobo.spring.data.jpa.extension.restriction.SimpleConditionRestriction#build(net.coding.chenxiaobo.spring.data.jpa.filter.PropertyFilter, net.coding.chenxiaobo.spring.data.jpa.extension.PredicateEntity)}
 * 方法，主要是让多值查询（in 或 not in）的情况下起作用
 *
 * @author maurice
 *
 */
public abstract class MultipleValueConditionRestriction extends SimpleConditionRestriction {

	public Predicate build(PropertyFilter filter, PredicateEntity entity) {
        Predicate orDisjunction = entity.getCriteriaBuilder().disjunction();

		Object[] values = filter.getValueExpression().getValues().toArray();

        for (String property:filter.getProperties()) {
            orDisjunction.getExpressions().add(build(property,values,entity));
        }

		return orDisjunction;
	}

    @Override
    public Predicate build(Path<?> expression, Object value, CriteriaBuilder builder) {
        return build(expression, (Object[])value, builder);
    }

    /**
	 * 获取Jpa的约束标准
	 * 
	 * @param expression root路径
	 * @param values 值
	 * @param builder CriteriaBuilder
	 * 
	 * @return {@link Predicate}
	 */
	public abstract Predicate build(Path<?> expression,Object[] values,CriteriaBuilder builder);
}
