
package net.coding.chenxiaobo.spring.data.jpa.extension.restriction.support;

import net.coding.chenxiaobo.spring.data.jpa.RestrictionNames;
import net.coding.chenxiaobo.spring.data.jpa.extension.restriction.SimpleConditionRestriction;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

/**
 * 小于等于约束 ( from object o where o.value <= ?) RestrictionName:LR
 * <p>
 * 表达式:LE属性类型_属性名称[_OR_属性名称...]
 * </p>
 * 
 * @author maurice
 *
 */
public class LeRestriction extends SimpleConditionRestriction {
	
	public String getRestrictionName() {
		return RestrictionNames.LE;
	}
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Predicate build(Path expression, Object value,CriteriaBuilder builder) {
		return builder.lessThanOrEqualTo(expression, (Comparable)value);
	}

}
