
package net.coding.chenxiaobo.spring.data.jpa.extension.restriction.support;

import net.coding.chenxiaobo.spring.data.jpa.RestrictionNames;
import net.coding.chenxiaobo.spring.data.jpa.extension.restriction.SimpleConditionRestriction;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

/**
 * 等于约束 (from object o where o.value = ?) RestrictionName:EQ
 * <p>
 * 表达式:EQ属性类型_属性名称[_OR_属性名称...]
 * </p>
 * 
 * @author maurice
 *
 */
public class EqRestriction extends SimpleConditionRestriction {

	public String getRestrictionName() {
		return RestrictionNames.EQ;
	}

	public Predicate build(Path<?> expression, Object value,CriteriaBuilder builder) {
		return value == null || value.equals("null") ? builder.isNull(expression) : builder.equal(expression, value);
	}

}
