
package net.coding.chenxiaobo.spring.data.jpa.filter;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 值表达式,根据该类的信息，对一个或多个的属性值该如何进行or或者and条件关联做处理
 * 
 * @author maurice
 *
 */
public class ValueExpression implements Serializable{

    /**
     *
     */
    private static final long serialVersionUID = 4554768110993277471L;

    /**
     * 默认值的 OR 字符串
     */
    public static final String DEFAULT_OR_STRING = "|";
    /**
     * 默认值的 AND 字符串
     */
    public static final String DEFAULT_AND_STRING = ",";

    static {
        DateConverter dc = new DateConverter();
        dc.setUseLocaleFormat(true);
        dc.setPatterns(new String[]{"yyyy-MM-dd"});
        ConvertUtils.register(dc, Date.class);
    }

    // 表达式
	private String expression = "";
    // 值
	private List<Object> values = new ArrayList<Object>();

    /**
     * 值表达式,根据该类的信息，对一个或多个的属性值该如何进行or或者and条件关联做处理
     *
     * @param value 值表达式
     * @param type 值类型
     */
    public ValueExpression(String value, Class<?> type) {

        if (value != null && value.contains(DEFAULT_OR_STRING)) {
            expression = DEFAULT_OR_STRING;
        } else if (value != null && value.contains(DEFAULT_AND_STRING)) {
            expression = DEFAULT_AND_STRING;
        }

        if (expression.equals("")) {
            values.add(ConvertUtils.convert(value, type));
        } else {
            String[] split = StringUtils.splitByWholeSeparator(value, expression);
            for (String s : split) {
                values.add(ConvertUtils.convert(s, type));
            }
        }

    }

    /**
     * 获取解析出来的值
     *
     * @return 值集合
     */
    public List<Object> getValues() {
        return values;
    }

    /**
     * 判断是否为 OR 表达式
     *
     * @return true表示是，否则false
     */
    public boolean isOrExpression() {
        return expression.equals(DEFAULT_OR_STRING);
    }

    /**
     * 判断是否为 AND 表达式
     *
     * @return true表示是，否则false
     */
    public boolean isAndExpression() {
        return expression.equals(DEFAULT_AND_STRING);
    }

}
