
package net.coding.chenxiaobo.spring.data.jpa.extension.restriction.support;

import net.coding.chenxiaobo.spring.data.jpa.RestrictionNames;
import net.coding.chenxiaobo.spring.data.jpa.extension.restriction.MultipleValueConditionRestriction;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

/**
 * 不包含约束 (from object o where o.value not in (?,?,?,?,?))RestrictionName:NIN
 * <p>
 * 表达式:NIN属性类型_属性名称[_OR_属性名称...]
 * </p>
 * 
 * @author maurice
 *
 */
public class NinRestriction extends MultipleValueConditionRestriction {
	
	public String getRestrictionName() {
		return RestrictionNames.NIN;
	}

	public Predicate build(Path<?> expression, Object[] values,CriteriaBuilder builder) {
		return builder.not(expression.in(values));
	}

}

