package net.coding.chenxiaobo.spring.data.jpa.extension;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;

/**
 * 持久化实体，该类主要是将有关 jpa 持久化的类包含在一起
 *
 * @author maurice
 */
public class PredicateEntity {

    // criteria root
    private Root<?> root;
    // criteria query
    private CriteriaQuery<?> criteriaQuery;
    // criteria builder
    private CriteriaBuilder criteriaBuilder;

    /**
     * 持久化实体，该类主要是将有关 jpa 持久化的类包含在一起
     *
     * @param root criteria root
     * @param criteriaQuery criteria query
     * @param criteriaBuilder criteria builder
     */
    public PredicateEntity(Root<?> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        super();
        this.root = root;
        this.criteriaQuery = criteriaQuery;
        this.criteriaBuilder = criteriaBuilder;
    }

    /**
     * 获取 criteria root
     *
     * @return {@link javax.persistence.criteria.Root}
     */
    public Root<?> getRoot() {
        return root;
    }

    /**
     * 获取 criteria query
     *
     * @return {@link javax.persistence.criteria.CriteriaQuery}
     */
    public CriteriaQuery<?> getCriteriaQuery() {
        return criteriaQuery;
    }

    /**
     * 获取 criteria builder
     *
     * @return {@link javax.persistence.criteria.CriteriaBuilder}
     */
    public CriteriaBuilder getCriteriaBuilder() {
        return criteriaBuilder;
    }
}
