
package net.coding.chenxiaobo.spring.data.jpa.extension;

import net.coding.chenxiaobo.spring.data.jpa.filter.PropertyFilter;

import javax.persistence.criteria.Predicate;

/**
 * 条件约束接口,该接口主要是在构造 {@link net.coding.chenxiaobo.spring.data.jpa.filter.SpecificationSupport}
 * 时，通过 {@link #build(net.coding.chenxiaobo.spring.data.jpa.filter.PropertyFilter, PredicateEntity)}
 * 方法去构造 {@link javax.persistence.criteria.Predicate}
 * 
 * @author maurice
 *
 */
public interface ConditionRestriction {

	/**
	 * 获取 Jpa 的约束标准
	 * 
	 * @param filter 属性过滤器
	 * @param entity 操作元数据，该类包含 Specification 的的API
	 * 
	 * @return {@link javax.persistence.criteria.Predicate}
	 * 
	 */
	public Predicate build(PropertyFilter filter, PredicateEntity entity);
	
	/**
	 * 获取Predicate标准的约束名称
	 * 
	 * @return String
	 */
	public String getRestrictionName();
}
