
package net.coding.chenxiaobo.spring.data.jpa.extension.restriction.support;

import net.coding.chenxiaobo.spring.data.jpa.RestrictionNames;
import net.coding.chenxiaobo.spring.data.jpa.extension.restriction.SimpleConditionRestriction;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

/**
 * 模糊约束 ( from object o where o.value like '%?%') RestrictionName:LIKE
 * <p>
 * 表达式:LIKE属性类型_属性名称[_OR_属性名称...]
 * </p>
 * 
 * @author maurice
 *
 */
public class LikeRestriction extends SimpleConditionRestriction {
	
	public String getRestrictionName() {
		return RestrictionNames.LIKE;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Predicate build(Path expression, Object value,CriteriaBuilder builder) {
		return builder.like(expression, "%" + value + "%");
	}

}

