package net.coding.chenxiaobo.map.validation.valid;

import net.coding.chenxiaobo.map.validation.Constraint;

import java.util.Map;
import java.util.regex.Pattern;

/**
 * 数字验证器
 *
 * @author maurice
 */
public class NumberValidator extends AllowsNullValueValidator {

    public static final String NAME = "number";

    @Override
    public boolean valid(Object value, Map<String, Object> source, Constraint constraint) {

        return Pattern.compile("[0-9]*").matcher(value.toString()).matches();
    }

    @Override
    public String getName() {
        return NAME;
    }
}
