package net.coding.chenxiaobo.map.validation.valid;

import net.coding.chenxiaobo.map.validation.Constraint;

import java.text.MessageFormat;
import java.util.Map;

/**
 * 字符长度验证器
 *
 * @author maurice
 */
public class LengthValidator extends AllowsNullValueValidator {

    public static final String NAME = "length";

    @Override
    public boolean valid(Object value, Map<String, Object> source, Constraint constraint) {

        Integer max = Integer.parseInt(constraint.getElement().attributeValue("max"));
        Integer min = Integer.parseInt(constraint.getElement().attributeValue("min","0"));
        Integer length = value.toString().length();

        constraint.setDefaultMessage(MessageFormat.format(constraint.getDefaultMessage(), min, max));

        String message = constraint.getMessage();

        if (message != null && message.indexOf("{") > 0 && message.indexOf("}") > 0) {
            constraint.setMessage(MessageFormat.format(message, min, max));
        }

        return length >= min && length <= max;

    }

    @Override
    public String getName() {
        return NAME;
    }
}
