package net.coding.chenxiaobo.map.validation.valid;

import net.coding.chenxiaobo.map.validation.Constraint;
import net.coding.chenxiaobo.map.validation.Validator;

import java.util.Map;

/**
 * 判断 key 是否存在验证器
 *
 * @author maurice
 */
public abstract class ContainsKeyValidator implements Validator {


    @Override
    public boolean valid(String key, Map<String, Object> source, Constraint constraint) {
        if (!source.containsKey(key)) {
            return false;
        }

        return valid(source.get(key), source, constraint);
    }

    public abstract boolean valid(Object value, Map<String, Object> source, Constraint constraint);
}
