package net.coding.chenxiaobo.map.validation.valid;

import net.coding.chenxiaobo.map.validation.Constraint;
import net.coding.chenxiaobo.map.validation.Validator;

import java.util.Map;

/**
 * 允许空值验证器
 *
 * @author maurice
 */
public abstract class AllowsNullValueValidator implements Validator {

    @Override
    public boolean valid(String key, Map<String, Object> source, Constraint constraint) {

        if (!source.containsKey(key) || source.get(key) == null || source.get(key).toString().equals("")) {
            return true;
        }
        return valid(source.get(key), source, constraint);
    }

    /**
     * 验证当前值
     *
     * @param value 当前值
     * @param source map 原始数据
     * @param constraint
     *
     * @return 通过返回 true ，否则返回 false 。
     */
    public abstract boolean valid(Object value, Map<String, Object> source, Constraint constraint);
}
