/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.Member;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.metadata.TypeAlias;
import net.codecrete.windowsapi.winmd.LayoutRequirement;
import net.codecrete.windowsapi.writer.AddressLayout;
import net.codecrete.windowsapi.writer.CommentWriter;
import net.codecrete.windowsapi.writer.GenerationContext;
import net.codecrete.windowsapi.writer.JavaCodeWriter;

class StructCodeWriter
extends JavaCodeWriter<Struct> {
    private static final String STRUCT = "struct";
    private static final String UNION = "union";
    private final CommentWriter commentWriter = new CommentWriter();
    private static final Pattern ANONYMOUS_NAME_PATTERN = Pattern.compile("^Anonymous\\d?$");

    StructCodeWriter(GenerationContext generationContext) {
        super(generationContext);
    }

    void writeStructOrUnion(Struct struct) {
        String className = StructCodeWriter.toJavaClassName(struct.name());
        this.withFile(struct.namespace(), struct, className, this::writeStructOrUnionContent);
    }

    void writeStructOrUnionContent() {
        this.writer.printf("package %s;\n\nimport java.lang.foreign.*;\nimport static java.lang.foreign.ValueLayout.*;\n\n", this.packageName);
        this.writeStructComment();
        this.writer.printf("public class %s {\n", this.className);
        AddressLayout.requiredLayouts((Struct)this.type).forEach(layoutType -> this.writeAddressLayoutInitialization((AddressLayout)layoutType, "private static final "));
        this.writer.println();
        this.writeUnalignedStructLayouts();
        this.writeLayout();
        this.writeFieldAccessors((Struct)this.type, 0L, "", "");
        this.writeAllocationMethods();
        this.writeArrayAccessMethods();
        this.writer.printf("    private %s () {}\n", this.className);
        this.writer.println("}");
    }

    private void writeLayout() {
        this.writer.print("    private static final GroupLayout $LAYOUT = ");
        this.writeStructLayout(((Struct)this.type).packageSize());
        this.writer.println(";");
        this.writer.println();
        String elementType = ((Struct)this.type).isUnion() ? UNION : STRUCT;
        String comment = String.format("Gets the layout of the %s {@code %s}.", elementType, ((Struct)this.type).nativeName());
        Object note = !((Struct)this.type).hasFixedSize() ? String.format("Note: The variable size of this %s cannot be represented. The field {@code %s} is set to a fixed size of %d elements.", elementType, ((Struct)this.type).flexibleArrayMember().name(), ((Array)((Struct)this.type).flexibleArrayMember().type()).arrayLength()) : null;
        this.writeCommentWithNotes(comment, new String[]{note});
        this.writer.print("    public static GroupLayout layout() {\n        return $LAYOUT;\n    }\n\n");
        comment = String.format("Gets the size of the %s {@code %s} (in bytes).", elementType, ((Struct)this.type).nativeName());
        note = !((Struct)this.type).hasFixedSize() ? "Note: Since this " + elementType + " has a variable size, the returned size is a fixed value for the minimal size." : null;
        this.writeCommentWithNotes(comment, new String[]{note});
        this.writer.printf("    public static long sizeof() {\n        return %dL;\n    }\n\n", ((Struct)this.type).structSize());
    }

    private void writeAllocationMethods() {
        String flexibleArrayNote;
        String elementType = ((Struct)this.type).isUnion() ? UNION : STRUCT;
        String allocationComment = String.format("Allocates a new memory segment for the %s {@code %s}.", elementType, ((Struct)this.type).nativeName());
        String cbSizeNote = ((Struct)this.type).structSizeMember() != null ? String.format("The field {@code %s} is set to the size of the allocated %s.", ((Struct)this.type).structSizeMember(), elementType) : null;
        String string = flexibleArrayNote = !((Struct)this.type).hasFixedSize() ? String.format("The allocation is sized such that the flexible array {@code %s} can hold {@code elementCount} elements.", ((Struct)this.type).flexibleArrayMember().name()) : null;
        if (((Struct)this.type).hasFixedSize()) {
            if (((Struct)this.type).structSizeMember() == null) {
                this.writeComment(allocationComment, new Object[0]);
                this.writer.printf("    public static MemorySegment allocate(SegmentAllocator allocator) {\n        return allocator.allocate(%dL, %dL);\n    }\n\n", ((Struct)this.type).structSize(), ((Struct)this.type).packageSize());
            } else {
                this.writeCommentWithNotes(allocationComment, cbSizeNote);
                this.writer.printf("    public static MemorySegment allocate(SegmentAllocator allocator) {\n        var segment = allocator.allocate(%dL, %dL);\n        %s(segment, %s);\n        return segment;\n    }\n\n", ((Struct)this.type).structSize(), ((Struct)this.type).packageSize(), ((Struct)this.type).structSizeMember(), StructCodeWriter.getStructSizeExpression((Struct)this.type));
            }
        } else {
            Array flexibleMemberArray = (Array)((Struct)this.type).flexibleArrayMember().type();
            int elementSize = LayoutRequirement.forType(flexibleMemberArray.itemType()).size();
            int packageSize = ((Struct)this.type).packageSize();
            long offset = StructCodeWriter.flexibleMemberOffset((Struct)this.type, ((Struct)this.type).flexibleArrayMember(), (Struct)this.type);
            long fixedSize = offset + (long)((Struct)this.type).packageSize() - 1L;
            String sizeExpression = StructCodeWriter.getSizeExpression(fixedSize, elementSize, packageSize);
            if (((Struct)this.type).structSizeMember() == null) {
                this.writeCommentWithNotes(allocationComment, flexibleArrayNote);
                this.writer.printf("    public static MemorySegment allocate(SegmentAllocator allocator, int elementCount) {\n        return allocator.allocate(%s, %dL);\n    }\n\n", sizeExpression, ((Struct)this.type).packageSize());
            } else {
                this.writeCommentWithNotes(allocationComment, flexibleArrayNote, cbSizeNote);
                this.writer.printf("    public static MemorySegment allocate(SegmentAllocator allocator, int elementCount) {\n        var segment = allocator.allocate(%s, %dL);\n        %s(segment, %s);\n        return segment;\n    }\n\n", sizeExpression, ((Struct)this.type).packageSize(), ((Struct)this.type).structSizeMember(), StructCodeWriter.getStructSizeExpression((Struct)this.type));
            }
        }
    }

    private void writeArrayAccessMethods() {
        if (((Struct)this.type).hasFixedSize()) {
            String comment = String.format("Gets the element with index {@code index} of the specified {@code %s} array.", ((Struct)this.type).nativeName());
            String note = "The returned memory segment is a slice of {@code array} and shares the backing memory.";
            this.writeCommentWithNotes(comment, note);
            this.writer.printf("    public static MemorySegment elementAsSlice(MemorySegment array, long index) {\n        return array.asSlice(%dL * index, %1$dL);\n    }\n\n", ((Struct)this.type).structSize());
            String elementType = ((Struct)this.type).isUnion() ? UNION : STRUCT;
            this.writeComment("Allocates an array of {@code elementCount} elements of this %s.", elementType);
            this.writer.printf("    public static MemorySegment allocateArray(long elementCount, SegmentAllocator allocator) {\n        return allocator.allocate(%dL * elementCount, %dL);\n    }\n\n", ((Struct)this.type).structSize(), ((Struct)this.type).packageSize());
        }
    }

    private static String getSizeExpression(long fixedSize, int elementSize, int packageSize) {
        String sizeExpression = elementSize != 1 ? (packageSize != 1 ? String.format("(%dL + elementCount * %dL) & -%dL", fixedSize, elementSize, packageSize) : String.format("%dL + elementCount * %dL", fixedSize, elementSize)) : (packageSize != 1 ? String.format("(%dL + elementCount) & -%dL", fixedSize, packageSize) : String.format("%dL + elementCount", fixedSize));
        return sizeExpression;
    }

    private static String getStructSizeExpression(Struct struct) {
        assert (struct.structSizeMember() != null);
        Member structSizeMember = struct.members().stream().filter(it -> it.name().equals(struct.structSizeMember())).findFirst().orElseThrow();
        return StructCodeWriter.getJavaIntegerConstant(StructCodeWriter.getPrimitiveJavaType((Primitive)structSizeMember.type()), struct.structSize());
    }

    private void writeStructLayout(int packageSize) {
        this.writer.println(((Struct)this.type).isUnion() ? "MemoryLayout.unionLayout(" : "MemoryLayout.structLayout(");
        this.writeFieldsLayout(8, ((Struct)this.type).members(), packageSize);
        this.writeIndent(4);
        this.writer.print(")");
    }

    private void writeFieldAccessors(Struct type, long offset, String prefix, String nativePrefix) {
        assert (type.members() != null);
        for (Member field : type.members()) {
            Struct struct;
            long fieldOffset;
            Type fieldType = field.type();
            long l = fieldOffset = type.isUnion() ? offset : offset + (long)field.offset();
            if (fieldType instanceof Struct && (struct = (Struct)fieldType).isNested()) {
                String nestedPrefix = fieldType.isAnonymous() ? prefix : prefix + field.name() + "_";
                String nestedNativePrefix = fieldType.isAnonymous() ? nativePrefix : nativePrefix + field.name() + ".";
                this.writeFieldAccessors(struct, fieldOffset, nestedPrefix, nestedNativePrefix);
                continue;
            }
            this.writeFieldAccessors(field, fieldOffset, prefix, nativePrefix);
        }
    }

    private void writeFieldAccessors(Member field, long offset, String prefix, String nativePrefix) {
        Object fieldName = field.name();
        String nativeFieldName = field.name();
        Type fieldType = field.type();
        if (field.isBitField()) {
            int bitFieldNum = this.consumeBitFieldNumber();
            fieldName = "_bitfield" + bitFieldNum;
        }
        if (((String)fieldName).equals("boolean")) {
            fieldName = "boolean_";
        }
        String dataType = StructCodeWriter.getJavaType(fieldType);
        this.writeComment("Gets the offset of the field {@code %s%s} (in bytes).", nativePrefix, nativeFieldName);
        this.writer.printf("    public static long %s%s$offset() {\n        return %dL;\n    }\n\n", prefix, fieldName, offset);
        if (fieldType instanceof Struct || fieldType instanceof Array) {
            Array array;
            LayoutRequirement requirement = LayoutRequirement.forType(fieldType);
            int alignment = Math.min(requirement.alignment(), ((Struct)this.type).packageSize());
            if (fieldType instanceof Array && (array = (Array)fieldType).isFlexible()) {
                String comment = String.format("Gets the flexible array field {@code %s%s} of {@code segment}.", nativePrefix, nativeFieldName);
                String note1 = "The returned memory segment is a slice of {@code segment} and shares the backing memory.";
                String note2 = "The length of the returned slice is derived from the size of {@code segment}: It extends from the start of the flexible array to the end the segment.";
                this.writeCommentWithNotes(comment, note1, note2);
                this.writer.printf("    public static %s %s%s(MemorySegment segment) {\n        return segment.asSlice(%dL, segment.byteSize() - %dL, %dL);\n    }\n\n", dataType, prefix, fieldName, offset, offset, alignment);
                comment = String.format("Copies {@code value} into the flexible array field {@code %s%s} in {@code segment}.", nativePrefix, nativeFieldName);
                note1 = "The number of bytes copied is the smaller of the size of {@code value} and the available space in {@code segment} (from the flexible array start to the end of the segment).";
                this.writeCommentWithNotes(comment, note1);
                this.writer.printf("    public static void %1$s%2$s(MemorySegment segment, MemorySegment value) {\n        MemorySegment.copy(value, 0L, segment, %3$dL, Math.min(value.byteSize(), segment.byteSize() - %3$dL));\n    }\n\n", prefix, fieldName, offset);
            } else {
                String comment = String.format("Gets the field {@code %s%s} of {@code segment}.", nativePrefix, nativeFieldName);
                String note = "The returned memory segment is a slice of {@code segment} and shares the backing memory.";
                this.writeCommentWithNotes(comment, note);
                this.writer.printf("    public static %s %s%s(MemorySegment segment) {\n        return segment.asSlice(%dL, %dL, %dL);\n    }\n\n", dataType, prefix, fieldName, offset, requirement.size(), alignment);
                this.writeComment("Copies {@code value} into the field {@code %s%s} in {@code segment}.", nativePrefix, nativeFieldName);
                this.writer.printf("    public static void %s%s(MemorySegment segment, MemorySegment value) {\n        MemorySegment.copy(value, 0L, segment, %dL, %dL);\n    }\n\n", prefix, fieldName, offset, requirement.size());
            }
        } else {
            this.writeComment("Gets the value of field {@code %s%s} in {@code segment}.", nativePrefix, nativeFieldName);
            String layoutName = this.getLayoutName(fieldType, ((Struct)this.type).packageSize(), this.namespace);
            this.writer.printf("    public static %s %s%s(MemorySegment segment) {\n        return segment.get(%s, %dL);\n    }\n\n", dataType, prefix, fieldName, layoutName, offset);
            this.writeComment("Sets the field {@code %s%s} in {@code segment} to {@code value}.", nativePrefix, nativeFieldName);
            this.writer.printf("    public static void %s%s(MemorySegment segment, %s value) {\n        segment.set(%s, %dL, value);\n    }\n\n", prefix, fieldName, dataType, layoutName, offset);
        }
    }

    private void writeFieldsLayout(int indenting, List<Member> fields, int packageSize) {
        int numFields = fields.size();
        for (int i = 0; i < numFields; ++i) {
            Member field = fields.get(i);
            this.writeField(indenting, field, packageSize, i == numFields - 1 && field.paddingAfter() == 0);
            this.writePadding(indenting, field, i == numFields - 1);
        }
    }

    private void writeField(int indenting, Member field, int packageSize, boolean isLast) {
        this.writeIndent(indenting);
        this.writeFfmTypeLayout(indenting, field.type(), packageSize);
        if (!StructCodeWriter.isAnonymous(field)) {
            this.writer.print(".withName(\"");
            this.writer.print(field.name());
            this.writer.print("\")");
        }
        if (!isLast) {
            this.writer.print(",");
        }
        this.writer.println();
    }

    private void writeFfmTypeLayout(int indenting, Type type, int packageSize) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Primitive.class, Array.class, EnumType.class, TypeAlias.class, Pointer.class, Struct.class}, (Object)type3, n)) {
            case 0: {
                Primitive primitive = (Primitive)type3;
                this.writer.print(StructCodeWriter.getPrimitiveLayoutName(primitive, packageSize));
                break;
            }
            case 1: {
                Array arrayType = (Array)type3;
                this.writer.printf("MemoryLayout.sequenceLayout(%dL, ", arrayType.arrayLength());
                this.writeFfmTypeLayout(indenting, arrayType.itemType(), packageSize);
                this.writer.print(")");
                break;
            }
            case 2: {
                EnumType enumType = (EnumType)type3;
                this.writeFfmTypeLayout(indenting, enumType.baseType(), packageSize);
                break;
            }
            case 3: {
                TypeAlias typeAlias = (TypeAlias)type3;
                this.writeFfmTypeLayout(indenting, typeAlias.aliasedType(), packageSize);
                break;
            }
            case 4: {
                Pointer pointer = (Pointer)type3;
                this.writer.print(this.getLayoutName(pointer, packageSize, null));
                break;
            }
            case 5: {
                Struct struct = (Struct)type3;
                if (type.namespace() == null) {
                    this.writer.println(struct.isUnion() ? "MemoryLayout.unionLayout(" : "MemoryLayout.structLayout(");
                    this.writeFieldsLayout(indenting + 4, struct.members(), packageSize);
                    this.writeIndent(indenting);
                    this.writer.print(")");
                    break;
                }
                this.writeStructLayoutName(struct, packageSize, this.namespace);
                break;
            }
            default: {
                this.writer.print(packageSize >= 8 ? "ADDRESS" : "ADDRESS_UNALIGNED");
            }
        }
    }

    private void writePadding(int indenting, Member field, boolean isLast) {
        if (field.paddingAfter() == 0) {
            return;
        }
        this.writeIndent(indenting);
        this.writer.printf("MemoryLayout.paddingLayout(%d)", field.paddingAfter());
        if (!isLast) {
            this.writer.print(",");
        }
        this.writer.println();
    }

    private static boolean isAnonymous(Member field) {
        return ANONYMOUS_NAME_PATTERN.matcher(field.name()).find();
    }

    private static long flexibleMemberOffset(Struct struct, Member flexibleMember, Struct rootStruct) {
        Member lastMember = struct.members().getLast();
        if (flexibleMember == lastMember) {
            return flexibleMember.offset();
        }
        Type type = lastMember.type();
        if (type instanceof Struct) {
            Struct lastMemberStruct = (Struct)type;
            return (long)lastMember.offset() + StructCodeWriter.flexibleMemberOffset(lastMemberStruct, flexibleMember, rootStruct);
        }
        throw new AssertionError((Object)("Flexible member " + flexibleMember.name() + " not found in struct " + rootStruct.name()));
    }

    private void writeUnalignedStructLayouts() {
        Set<Struct> unalignedStructs = StructCodeWriter.getUnalignedMemberStructs((Struct)this.type, ((Struct)this.type).packageSize());
        if (!unalignedStructs.isEmpty()) {
            List<Struct> unalignedStructList = unalignedStructs.stream().sorted(Comparator.comparing(Type::name)).toList();
            for (Struct struct : unalignedStructList) {
                this.writer.printf("    private static final MemoryLayout %s$LAYOUT_UNALIGNED = align1(%s);\n\n", struct.name(), this.getLayoutName(struct, this.namespace));
                this.writeComment("Gets a layout for {@code %s} with relaxed alignment constraints", struct.name());
                this.writer.printf("    public static MemoryLayout %1$s$unalignedLayout() {\n        return %1$s$LAYOUT_UNALIGNED;\n    }\n\n", struct.name());
            }
            this.writeUnalignFunction();
        }
    }

    private void writeUnalignFunction() {
        this.writer.printf("    private static MemoryLayout align1(MemoryLayout layout) {\n        return switch (layout) {\n            case PaddingLayout p -> p;\n            case ValueLayout v -> v.withByteAlignment(1);\n            case GroupLayout g -> {\n                var members = g.memberLayouts().stream().map(%s::align1).toArray(MemoryLayout[]::new);\n                yield g instanceof StructLayout ? MemoryLayout.structLayout(members) : MemoryLayout.unionLayout(members);\n            }\n            case SequenceLayout s -> MemoryLayout.sequenceLayout(s.elementCount(), align1(s.elementLayout()));\n        };\n    }\n\n", this.className);
    }

    private void writeStructComment() {
        String dataStructure = ((Struct)this.type).isUnion() ? UNION : STRUCT;
        Object postfix = "";
        if (((Struct)this.type).isUnion()) {
            postfix = " (union)";
        }
        if (!((Struct)this.type).name().equals(((Struct)this.type).nativeName())) {
            if (((Struct)this.type).name().endsWith("_X64")) {
                postfix = (String)postfix + " (X64 only)";
            }
            if (((Struct)this.type).name().endsWith("_ARM64")) {
                postfix = (String)postfix + " (ARM64 only)";
            }
        }
        this.writer.printf("/**\n * {@code %1$s} structure%2$s\n", ((Struct)this.type).nativeName(), postfix);
        this.writer.print(" * <p>\n");
        this.commentWriter.writeStructSnippet(this.writer, (Struct)this.type);
        this.writer.print(" * </p>\n");
        if (!((Struct)this.type).hasFixedSize()) {
            this.writer.printf(" * <p>\n * This struct contains the flexible array {@code %s}. It has a variable number of elements.\n * Thus, the size of this %s is variable.\n * </p>\n", ((Struct)this.type).flexibleArrayMember().name(), dataStructure);
        }
        this.writeDocumentationUrl(this.type);
        this.writer.println(" */");
    }

    private static Set<Struct> getUnalignedMemberStructs(Struct struct, int packageSize) {
        HashSet<Struct> unalignedStructs = new HashSet<Struct>();
        StructCodeWriter.collectUnalignedMemberStructs(struct, packageSize, unalignedStructs);
        return unalignedStructs;
    }

    private static void collectUnalignedMemberStructs(Type type, int packageSize, Set<Struct> unalignedStructs) {
        if (type instanceof Struct) {
            Struct struct = (Struct)type;
            if (struct.packageSize() > packageSize && !struct.isNested()) {
                unalignedStructs.add(struct);
            }
            for (Member member : struct.members()) {
                StructCodeWriter.collectUnalignedMemberStructs(member.type(), packageSize, unalignedStructs);
            }
        } else if (type instanceof Array) {
            Array arrayType = (Array)type;
            StructCodeWriter.collectUnalignedMemberStructs(arrayType.itemType(), packageSize, unalignedStructs);
        }
    }
}

