/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.codecrete.windowsapi.events.Event;
import net.codecrete.windowsapi.events.EventListener;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.ConstantValue;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.Metadata;
import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.metadata.TypeAlias;

public class Scope {
    private static final String NOT_FOUND_TEMPLATE = "%s \"%s\" does not exist.";
    private static final String DID_YOU_MEAN_TEMPLATE = "%s Did you mean \"%s\"?.";
    private static final String ENUMERATION_MEMBER_SINGLE = "%s Enumeration \"%s\" contains a member with that name. Specify the enumeration instead of the constant.";
    private final Set<Type> typeSet = new HashSet<Type>();
    private final Set<Method> methodSet = new HashSet<Method>();
    private final Set<ConstantValue> constantSet = new HashSet<ConstantValue>();
    private final Set<Type> transitiveScope = new HashSet<Type>();
    private final Metadata metadata;
    private final EventListener eventListener;
    private boolean hasInvalidArguments = false;

    public Scope(Metadata metadata, EventListener eventListener) {
        this.metadata = metadata;
        this.eventListener = eventListener;
    }

    Set<Type> types() {
        return this.typeSet;
    }

    Set<ConstantValue> constants() {
        return this.constantSet;
    }

    Set<Method> methods() {
        return this.methodSet;
    }

    public boolean hasInvalidArguments() {
        return this.hasInvalidArguments;
    }

    public void addStructs(Set<String> structs) {
        List<Type> foundStructs = this.metadata.findStructs(structs);
        Set foundStructNames = foundStructs.stream().map(Type::nativeName).collect(Collectors.toSet());
        Set missingStructs = structs.stream().filter(name -> !foundStructNames.contains(name)).collect(Collectors.toSet());
        if (missingStructs.isEmpty()) {
            this.addTypes(foundStructs);
        } else {
            this.hasInvalidArguments = true;
            for (String struct : missingStructs) {
                Optional<String> wideStringType = this.metadata.findStructs(Set.of(struct + "W")).stream().map(Type::name).findFirst();
                this.emitNotFoundError("structs", struct, "Struct/union", wideStringType.orElse(null));
            }
        }
    }

    public void addEnums(Set<String> enumerations) {
        List<Type> foundEnums = this.metadata.findEnums(enumerations);
        Set foundEnumNames = foundEnums.stream().map(Type::name).collect(Collectors.toSet());
        Set missingEnums = enumerations.stream().filter(name -> !foundEnumNames.contains(name)).collect(Collectors.toSet());
        if (missingEnums.isEmpty()) {
            this.addTypes(foundEnums);
        } else {
            this.hasInvalidArguments = true;
            for (String enumName : missingEnums) {
                this.emitNotFoundError("enumerations", enumName, "Enumeration", null);
            }
        }
    }

    public void addCallbackFunctions(Set<String> callbackFunctions) {
        List<Type> foundCallbackFunctions = this.metadata.findDelegates(callbackFunctions);
        Set foundCallbackFunctionNames = foundCallbackFunctions.stream().map(Type::name).collect(Collectors.toSet());
        Set missingCallbackFunctions = callbackFunctions.stream().filter(name -> !foundCallbackFunctionNames.contains(name)).collect(Collectors.toSet());
        if (missingCallbackFunctions.isEmpty()) {
            this.addTypes(foundCallbackFunctions);
        } else {
            this.hasInvalidArguments = true;
            for (String callbackFunction : missingCallbackFunctions) {
                String wideStringCallbackFunction = this.metadata.findDelegates(Set.of(callbackFunction + "W")).stream().map(Type::name).findFirst().orElse(null);
                this.emitNotFoundError("callbackFunctions", callbackFunction, "Callback function", wideStringCallbackFunction);
            }
        }
    }

    public void addComInterfaces(Set<String> comInterfaces) {
        List<Type> foundComInterfaces = this.metadata.findComInterfaces(comInterfaces);
        Set foundComInterfaceNames = foundComInterfaces.stream().map(Type::name).collect(Collectors.toSet());
        Set missingComInterfaces = comInterfaces.stream().filter(name -> !foundComInterfaceNames.contains(name)).collect(Collectors.toSet());
        if (missingComInterfaces.isEmpty()) {
            this.addTypes(foundComInterfaces);
        } else {
            this.hasInvalidArguments = true;
            for (String comInterface : missingComInterfaces) {
                this.emitNotFoundError("comInterfaces", comInterface, "COM interface", null);
            }
        }
    }

    public void addConstants(Set<String> constants) {
        List<ConstantValue> foundConstants = this.metadata.findConstants(constants);
        Set foundConstantNames = foundConstants.stream().map(ConstantValue::name).collect(Collectors.toSet());
        Set missingConstants = constants.stream().filter(name -> !foundConstantNames.contains(name)).collect(Collectors.toSet());
        if (missingConstants.isEmpty()) {
            this.constantSet.addAll(foundConstants);
        } else {
            this.hasInvalidArguments = true;
            for (String constant : missingConstants) {
                List<EnumType> alternatives = this.metadata.findEnumWithMember(constant);
                String alternative = !alternatives.isEmpty() ? alternatives.getFirst().name() : null;
                this.emitNotFoundErrorForConstant(constant, alternative);
            }
        }
    }

    public void addFunctions(Set<String> functions) {
        List<Method> foundFunctions = this.metadata.findFunctions(functions);
        Set foundFunctionNames = foundFunctions.stream().map(Method::nativeName).collect(Collectors.toSet());
        Set missingFunctions = functions.stream().filter(name -> !foundFunctionNames.contains(name)).collect(Collectors.toSet());
        if (missingFunctions.isEmpty()) {
            this.methodSet.addAll(foundFunctions);
        } else {
            this.hasInvalidArguments = true;
            for (String function : missingFunctions) {
                String alternative = this.metadata.findFunctions(Set.of(function + "W")).stream().map(Method::name).findFirst().orElse(null);
                this.emitNotFoundError("functions", function, "Function", alternative);
            }
        }
    }

    void addTypes(Collection<Type> types) {
        List<Type> newTypes = types.stream().filter(t -> !this.typeSet.contains(t)).toList();
        this.typeSet.addAll(newTypes);
    }

    private void emitNotFoundError(String argumentName, String argumentValue, String elementType, String alternative) {
        String reason = String.format(NOT_FOUND_TEMPLATE, elementType, argumentValue);
        if (alternative != null) {
            reason = String.format(DID_YOU_MEAN_TEMPLATE, reason, alternative);
        }
        this.eventListener.onEvent(new Event.InvalidArgument(argumentName, argumentValue, reason));
    }

    private void emitNotFoundErrorForConstant(String argumentValue, String alternative) {
        String reason = String.format(NOT_FOUND_TEMPLATE, "Constant", argumentValue);
        if (alternative != null) {
            reason = String.format(ENUMERATION_MEMBER_SINGLE, reason, alternative);
        }
        this.eventListener.onEvent(new Event.InvalidArgument("constants", argumentValue, reason));
    }

    public void buildTransitiveScope() {
        if (this.hasInvalidArguments) {
            throw new IllegalStateException("The transitive scope cannot be built as invalid arguments were set.");
        }
        this.transitiveScope.addAll(this.typeSet);
        this.typeSet.forEach(type -> this.addDependencies(type.referencedTypes()));
        this.methodSet.forEach(method -> this.addDependencies(method.referencedTypes()));
        this.addDependencies(this.constantSet.stream().map(ConstantValue::type));
        if (this.methodSet.stream().anyMatch(Method::supportsLastError)) {
            this.transitiveScope.add(this.metadata.getType("Windows.Win32.Foundation", "WIN32_ERROR"));
        }
        this.transitiveScope.removeIf(type -> !this.generatesJavaFile((Type)type));
    }

    private void addDependencies(Stream<Type> types) {
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            if (type instanceof Primitive || type instanceof TypeAlias || !this.transitiveScope.add(type)) continue;
            this.addDependencies(type.referencedTypes());
        }
    }

    private boolean generatesJavaFile(Type type) {
        return !(type instanceof Primitive) && !(type instanceof TypeAlias) && !(type instanceof Pointer) && !(type instanceof Array);
    }

    Set<Type> getTransitiveTypeScope() {
        return this.transitiveScope;
    }

    Map<Namespace, List<Method>> getFunctions() {
        return this.methodSet.stream().collect(Collectors.groupingBy(Method::namespace));
    }

    Map<Namespace, List<ConstantValue>> getConstants() {
        return this.constantSet.stream().collect(Collectors.groupingBy(ConstantValue::namespace));
    }
}

