/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.codecrete.windowsapi.events.Event;
import net.codecrete.windowsapi.metadata.ComInterface;
import net.codecrete.windowsapi.metadata.Delegate;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.LazyString;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.PrimitiveKind;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.metadata.TypeAlias;
import net.codecrete.windowsapi.winmd.LayoutRequirement;
import net.codecrete.windowsapi.writer.AddressLayout;
import net.codecrete.windowsapi.writer.GenerationContext;

class JavaCodeWriter<T extends Type> {
    protected final GenerationContext generationContext;
    protected final Primitive voidType;
    protected PrintWriter writer;
    protected Namespace namespace;
    protected T type;
    protected String packageName;
    protected String className;
    private int bitFieldNumber = 0;
    private static final Set<String> JAVA_KEYWORDS = Set.of("abstract", "final", "import", "package", "var");
    private static final String SPACES = "        ".repeat(10);

    JavaCodeWriter(GenerationContext generationContext) {
        this.generationContext = generationContext;
        this.voidType = generationContext.metadata().getPrimitive(PrimitiveKind.VOID);
    }

    protected GenerationContext generationContext() {
        return this.generationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withFile(Namespace namespace, T type, String className, Runnable action) {
        this.packageName = this.toJavaPackageName(namespace.name());
        Path path = this.createJavaClassPath(this.packageName, className);
        try (PrintWriter w = this.generationContext.createWriter(path);){
            this.writeHeader(w);
            this.writer = w;
            this.namespace = namespace;
            this.type = type;
            this.className = className;
            action.run();
            this.generationContext.notify(new Event.JavaSourceGenerated(path));
        }
        finally {
            this.writer = null;
            this.type = null;
            this.packageName = null;
            this.className = null;
            this.bitFieldNumber = 0;
        }
    }

    private void writeHeader(PrintWriter writer) {
        writer.print("// Code generated by Windows API Generator.\n// Do not modify manually.\n\n");
    }

    protected int consumeBitFieldNumber() {
        ++this.bitFieldNumber;
        return this.bitFieldNumber;
    }

    static String toJavaClassName(String typeName) {
        if (typeName.equals("AVISTREAMHEADER")) {
            return "AVISTREAMHEADER_";
        }
        return typeName;
    }

    protected String toJavaPackageName(String namespace) {
        String lowercaseNamespace = namespace.toLowerCase(Locale.ROOT);
        if (this.generationContext.basePackage().isEmpty()) {
            return lowercaseNamespace;
        }
        return this.generationContext.basePackage() + "." + lowercaseNamespace;
    }

    private Path createJavaClassPath(String packageName, String className) {
        String[] pathComponents = packageName.split("\\.");
        String firstComponent = pathComponents[0];
        System.arraycopy(pathComponents, 1, pathComponents, 0, pathComponents.length - 1);
        pathComponents[pathComponents.length - 1] = className + ".java";
        return Path.of(firstComponent, pathComponents);
    }

    static String getPrimitiveJavaType(Primitive type) {
        return switch (type.kind()) {
            case PrimitiveKind.INT64, PrimitiveKind.UINT64, PrimitiveKind.INT_PTR, PrimitiveKind.UINT_PTR -> "long";
            case PrimitiveKind.INT32, PrimitiveKind.UINT32 -> "int";
            case PrimitiveKind.UINT16, PrimitiveKind.INT16, PrimitiveKind.CHAR -> "short";
            case PrimitiveKind.BYTE, PrimitiveKind.SBYTE -> "byte";
            case PrimitiveKind.SINGLE -> "float";
            case PrimitiveKind.DOUBLE -> "double";
            case PrimitiveKind.BOOL -> "boolean";
            default -> throw new AssertionError((Object)("Unexpected primitive type: " + type.name()));
        };
    }

    static String getJavaIntegerConstant(String javaType, Object value) {
        assert (value instanceof Number);
        Number number = (Number)value;
        return switch (javaType) {
            case "long" -> number.longValue() + "L";
            case "int" -> Integer.toString(number.intValue());
            case "short" -> "(short) " + number.shortValue();
            case "byte" -> "(byte) " + number.byteValue();
            default -> throw new AssertionError((Object)("Unexpected value: " + javaType));
        };
    }

    static String getJavaType(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Primitive.class, EnumType.class, TypeAlias.class}, (Object)type3, n)) {
            case 0 -> {
                Primitive primitive = (Primitive)type3;
                yield JavaCodeWriter.getPrimitiveJavaType(primitive);
            }
            case 1 -> {
                EnumType enumType = (EnumType)type3;
                yield JavaCodeWriter.getPrimitiveJavaType(enumType.baseType());
            }
            case 2 -> {
                TypeAlias typeAlias = (TypeAlias)type3;
                yield JavaCodeWriter.getJavaType(typeAlias.aliasedType());
            }
            default -> "MemorySegment";
        };
    }

    static String getJavaSafeName(String name) {
        if (JAVA_KEYWORDS.contains(name)) {
            return name + "_";
        }
        return name;
    }

    void writeAddressLayoutInitialization(AddressLayout addressLayout, String modifiers) {
        this.writer.printf("    %sAddressLayout %s = %s.", modifiers, addressLayout.name(), addressLayout.aligned() ? "ADDRESS" : "ADDRESS_UNALIGNED");
        if (addressLayout.isForStruct()) {
            this.writer.printf("withTargetLayout(MemoryLayout.sequenceLayout(%d, JAVA_BYTE)", addressLayout.structSize());
            if (addressLayout.packageSize() != 1) {
                this.writer.printf(".withByteAlignment(%d)", addressLayout.packageSize());
            }
            this.writer.print(")");
        } else if (addressLayout == AddressLayout.pointerToAddress(true) || addressLayout == AddressLayout.pointerToAddress(false)) {
            this.writer.print("withTargetLayout(ADDRESS)");
        } else if (addressLayout == AddressLayout.pointerToUnknown(true) || addressLayout == AddressLayout.pointerToUnknown(false)) {
            this.writer.print("withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, JAVA_BYTE))");
        } else assert (false) : "Unexpected address layout type: " + addressLayout.name();
        this.writer.println(";");
    }

    String getLayoutName(Type type, int packageSize, Namespace currentNamespace) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Primitive.class, TypeAlias.class, Pointer.class, Delegate.class, ComInterface.class, EnumType.class, Struct.class}, (Object)type3, n)) {
            case 0 -> {
                Primitive primitive = (Primitive)type3;
                yield JavaCodeWriter.getPrimitiveLayoutName(primitive, packageSize);
            }
            case 1 -> {
                TypeAlias typeAlias = (TypeAlias)type3;
                yield this.getLayoutName(typeAlias.aliasedType(), packageSize, currentNamespace);
            }
            case 2 -> {
                Pointer pointer = (Pointer)type3;
                yield AddressLayout.getAddressLayout(pointer.referencedType(), packageSize >= 8).name();
            }
            case 3 -> {
                Delegate ignored = (Delegate)type3;
                yield AddressLayout.pointerToAddress(packageSize >= 8).name();
            }
            case 4 -> {
                ComInterface ignored = (ComInterface)type3;
                yield AddressLayout.pointerToAddress(packageSize >= 8).name();
            }
            case 5 -> {
                EnumType enumType = (EnumType)type3;
                yield JavaCodeWriter.getPrimitiveLayoutName(enumType.baseType(), packageSize);
            }
            case 6 -> {
                Struct struct = (Struct)type3;
                yield this.getStructLayoutName(struct, currentNamespace);
            }
            default -> throw new AssertionError((Object)("Unexpected type: " + type.name()));
        };
    }

    String getLayoutName(Type type, Namespace currentNamespace) {
        return this.getLayoutName(type, 8, currentNamespace);
    }

    private String getStructLayoutName(Struct struct, Namespace currentNamespace) {
        if (currentNamespace != struct.namespace()) {
            return this.toJavaPackageName(struct.namespace().name()) + "." + JavaCodeWriter.toJavaClassName(struct.name()) + ".layout()";
        }
        return JavaCodeWriter.toJavaClassName(struct.name()) + ".layout()";
    }

    void writeStructLayoutName(Struct struct, int alignment, Namespace currentNamespace) {
        if (struct.packageSize() > alignment) {
            this.writer.printf("%s$LAYOUT_UNALIGNED", struct.name());
        } else if (currentNamespace != struct.namespace()) {
            this.writer.printf("%s.%s.layout()", this.toJavaPackageName(struct.namespace().name()), JavaCodeWriter.toJavaClassName(struct.name()));
        } else {
            this.writer.printf("%s.layout()", JavaCodeWriter.toJavaClassName(struct.name()));
        }
    }

    static String getPrimitiveLayoutName(Primitive type, int alignment) {
        boolean isUnaligned = LayoutRequirement.primitiveSize(type) > alignment;
        return switch (type.kind()) {
            case PrimitiveKind.INT64, PrimitiveKind.UINT64, PrimitiveKind.INT_PTR, PrimitiveKind.UINT_PTR -> {
                if (isUnaligned) {
                    yield "JAVA_LONG_UNALIGNED";
                }
                yield "JAVA_LONG";
            }
            case PrimitiveKind.INT32, PrimitiveKind.UINT32 -> {
                if (isUnaligned) {
                    yield "JAVA_INT_UNALIGNED";
                }
                yield "JAVA_INT";
            }
            case PrimitiveKind.UINT16, PrimitiveKind.INT16, PrimitiveKind.CHAR -> {
                if (isUnaligned) {
                    yield "JAVA_SHORT_UNALIGNED";
                }
                yield "JAVA_SHORT";
            }
            case PrimitiveKind.BYTE, PrimitiveKind.SBYTE -> "JAVA_BYTE";
            case PrimitiveKind.SINGLE -> {
                if (isUnaligned) {
                    yield "JAVA_FLOAT_UNALIGNED";
                }
                yield "JAVA_FLOAT";
            }
            case PrimitiveKind.DOUBLE -> {
                if (isUnaligned) {
                    yield "JAVA_DOUBLE_UNALIGNED";
                }
                yield "JAVA_DOUBLE";
            }
            case PrimitiveKind.BOOL -> "JAVA_BOOLEAN";
            default -> throw new AssertionError((Object)("Unexpected primitive type: " + type.name()));
        };
    }

    void writeValue(Type type, Object value) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Primitive.class, TypeAlias.class, Pointer.class}, (Object)type3, n)) {
            case 0: {
                Primitive primitive = (Primitive)type3;
                this.writePrimitiveValue(primitive, value);
                break;
            }
            case 1: {
                TypeAlias typeAlias = (TypeAlias)type3;
                this.writeValue(typeAlias.aliasedType(), value);
                break;
            }
            case 2: {
                Pointer ignored = (Pointer)type3;
                this.writePointerValue(value);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected type: " + type.name()));
            }
        }
    }

    void writePointerValue(Object address) {
        this.writer.printf("MemorySegment.ofAddress(%sL)", address);
    }

    void writePrimitiveValue(Primitive primitive, Object value) {
        switch (primitive.kind()) {
            case INT64: 
            case UINT64: {
                this.writer.printf("%dL", (Long)value);
                break;
            }
            case INT_PTR: 
            case UINT_PTR: {
                this.writer.printf("%dL", ((Number)value).longValue());
                break;
            }
            case INT32: 
            case UINT32: {
                this.writer.print((Integer)value);
                break;
            }
            case UINT16: 
            case INT16: {
                this.writer.print(((Short)value).intValue());
                break;
            }
            case BYTE: {
                this.writer.print(((Byte)value).intValue());
                break;
            }
            case SINGLE: {
                this.writer.printf("%ff", (Float)value);
                break;
            }
            case DOUBLE: {
                this.writer.print((Double)value);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected type: " + primitive.name()));
            }
        }
    }

    static String getIndent(int indenting) {
        return SPACES.substring(0, indenting);
    }

    void writeIndent(int indenting) {
        this.writer.write(SPACES, 0, indenting);
    }

    void writeCreateGuidMethod(int indenting) {
        this.writer.printf("%1$sprivate static MemorySegment createGuid(long v1, long v2) {\n%1$s    var seg = ARENA.allocate(16, 8);\n%1$s    seg.set(ValueLayout.JAVA_LONG, 0, v1);\n%1$s    seg.set(ValueLayout.JAVA_LONG, 8, v2);\n%1$s    return seg;\n%1$s}\n\n", JavaCodeWriter.getIndent(indenting));
    }

    void writeGuidConstantMemorySegment(String name, UUID uuid, int indenting) {
        this.writer.printf("%2$sprivate static final MemorySegment %1$s$SEG = createGuid(%3$dL, %4$dL);\n\n", name, JavaCodeWriter.getIndent(indenting), JavaCodeWriter.reorderMostSignificantBits(uuid.getMostSignificantBits()), Long.reverseBytes(uuid.getLeastSignificantBits()));
    }

    private static long reorderMostSignificantBits(long bits) {
        long data1 = bits >> 32 & 0xFFFFFFFFL;
        long data2 = bits << 16 & 0xFFFF00000000L;
        long data3 = bits << 48 & 0xFFFF000000000000L;
        return data1 | data2 | data3;
    }

    void writeComment(String format, Object ... args) {
        this.writer.println("    /**");
        this.writer.print("     * ");
        this.writer.printf(format, args);
        this.writer.println();
        this.writer.println("     */");
    }

    protected void writeCommentWithNotes(String comment, String ... notes) {
        this.writer.println("    /**");
        this.writer.print("     * ");
        this.writer.println(comment);
        for (String note : notes) {
            if (note == null) continue;
            this.writer.println("     * <p>");
            this.writer.print("     * ");
            this.writer.println(note);
            this.writer.println("     * </p>");
        }
        this.writer.println("     */");
    }

    protected void writeDocumentationUrl(Type type) {
        LazyString documentationUrl = type.documentationUrl();
        if (documentationUrl != null) {
            this.writer.printf(" *\n * @see <a href=\"%1$s\">%2$s (Microsoft)</a>\n", documentationUrl, type.nativeName());
        }
    }
}

