/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import java.util.Collection;
import java.util.Objects;
import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.metadata.TypeAlias;
import net.codecrete.windowsapi.writer.AddressLayout;
import net.codecrete.windowsapi.writer.CommentWriter;
import net.codecrete.windowsapi.writer.FunctionCodeWriterBase;
import net.codecrete.windowsapi.writer.GenerationContext;

class FunctionCodeWriter
extends FunctionCodeWriterBase<Type> {
    private static final String CALL_STATE_NOTE = "The additional first parameter takes a memory segment to capture the call state (replacement for {@code GetLastError()}).";
    private final CommentWriter commentWriter = new CommentWriter();

    FunctionCodeWriter(GenerationContext generationContext) {
        super(generationContext);
    }

    void writeFunctions(Namespace namespace, Collection<Method> functions) {
        this.withFile(namespace, null, "Apis", () -> this.writeFunctionsContent(functions));
    }

    void writeFunctionsContent(Collection<Method> functions) {
        this.writer.printf("package %s;\n\nimport java.lang.foreign.*;\nimport java.lang.invoke.MethodHandle;\nimport static java.lang.foreign.ValueLayout.*;\n\n", this.packageName);
        this.writeApiComment();
        this.writer.print("public class Apis {\n\n");
        this.writer.println("    static {");
        functions.stream().map(Method::dll).filter(Objects::nonNull).distinct().sorted().forEach(dll -> this.writer.printf("        System.loadLibrary(\"%s\");\n", FunctionCodeWriter.dllName(dll)));
        this.writer.print("    }\n\n");
        boolean usesLastError = this.anyFunctionUsesLastError(functions);
        this.writer.print("    private static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.loaderLookup();\n    private static final Linker LINKER = Linker.nativeLinker();\n");
        if (usesLastError) {
            this.writer.print("    private static final Linker.Option LAST_ERROR_STATE = Linker.Option.captureCallState(\"GetLastError\");\n");
        }
        AddressLayout.requiredLayouts(functions).forEach(layoutType -> this.writeAddressLayoutInitialization((AddressLayout)layoutType, "private static final "));
        this.writer.println();
        for (Method method : functions) {
            this.writeFunction(method);
        }
        this.writer.println("}");
    }

    private boolean anyFunctionUsesLastError(Collection<Method> functions) {
        return functions.stream().anyMatch(Method::supportsLastError);
    }

    private void writeFunction(Method method) {
        boolean isInlined;
        boolean bl = isInlined = method.dll() == null;
        if (isInlined) {
            assert (method.constantValue() != null);
        } else {
            this.writeFunctionInnerClass(method);
            this.writeFunctionDescriptorAndHandle(method);
        }
        this.commentWriter.writeFunctionComment(this.writer, method, "function");
        String methodName = method.name();
        this.writer.print("    public static ");
        this.writeFunctionSignature(method, methodName);
        this.writer.println(" {");
        if (isInlined) {
            TypeAlias typeAlias;
            Type type;
            assert (method.constantValue() instanceof String);
            assert ((type = method.returnType()) instanceof TypeAlias && (typeAlias = (TypeAlias)type).aliasedType() instanceof Pointer);
            this.writer.printf("        return MemorySegment.ofAddress(%s);", method.constantValue());
        } else {
            this.writeInvoke(method, methodName + "$IMPL.HANDLE.invokeExact(", 8);
        }
        this.writer.println("    }");
        this.writer.println();
    }

    private void writeFunctionInnerClass(Method method) {
        String methodName = method.name();
        this.writer.printf("    private static class %s$IMPL {%n", methodName);
        this.writer.print("        private static final FunctionDescriptor DESC = ");
        this.writeFunctionDescriptor(method, null);
        this.writer.println(";");
        this.writer.printf("        private static final MethodHandle HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.findOrThrow(\"%s\"), DESC%s);\n    }\n\n", method.nativeName(), method.supportsLastError() ? ", LAST_ERROR_STATE" : "");
    }

    private void writeFunctionDescriptorAndHandle(Method method) {
        String methodName = method.name();
        this.writeCommentWithNotes(String.format("Gets the function descriptor for {@code %s}", method.nativeName()), method.supportsLastError() ? CALL_STATE_NOTE : null);
        this.writer.printf("    public static FunctionDescriptor %1$s$descriptor() {\n        return %1$s$IMPL.DESC;\n    }\n\n", methodName);
        this.writeComment("Gets the method handle for {@code %s}", method.nativeName());
        this.writer.printf("    public static MethodHandle %1$s$handle() {\n        return %1$s$IMPL.HANDLE;\n    }\n\n", methodName);
    }

    private static String dllName(String dll) {
        String suffix;
        if (dll.length() > 4 && ".dll".equalsIgnoreCase(suffix = dll.substring(dll.length() - 4))) {
            return dll.substring(0, dll.length() - 4);
        }
        return dll;
    }

    void writeApiComment() {
        this.writer.printf("/**\n * Functions of namespace {@code %s}\n */\n", this.namespace.name());
    }
}

