/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.codecrete.windowsapi.events.EventListener;
import net.codecrete.windowsapi.metadata.ComInterface;
import net.codecrete.windowsapi.metadata.Delegate;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.Metadata;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.writer.CallbackFunctionCodeWriter;
import net.codecrete.windowsapi.writer.ComInterfaceWriter;
import net.codecrete.windowsapi.writer.ConstantCodeWriter;
import net.codecrete.windowsapi.writer.EnumCodeWriter;
import net.codecrete.windowsapi.writer.FunctionCodeWriter;
import net.codecrete.windowsapi.writer.GenerationContext;
import net.codecrete.windowsapi.writer.GenerationException;
import net.codecrete.windowsapi.writer.JavaCodeWriter;
import net.codecrete.windowsapi.writer.Scope;
import net.codecrete.windowsapi.writer.StructCodeWriter;

public class CodeWriter
extends JavaCodeWriter<Type> {
    private final Path outputDirectory;
    private final StructCodeWriter structCodeWriter;
    private final EnumCodeWriter enumCodeWriter;
    private final FunctionCodeWriter functionCodeWriter;
    private final CallbackFunctionCodeWriter callbackFunctionCodeWriter;
    private final ConstantCodeWriter constantCodeWriter;
    private final ComInterfaceWriter comInterfaceWriter;
    private Set<Path> generatedFiles;
    private boolean isDryRun;

    public CodeWriter(Metadata metadata, Path outputDirectory, EventListener eventListener) {
        super(new GenerationContext(metadata, eventListener));
        this.generationContext().setWriterFactory(this::createFileWriter);
        this.outputDirectory = outputDirectory;
        this.structCodeWriter = new StructCodeWriter(this.generationContext());
        this.enumCodeWriter = new EnumCodeWriter(this.generationContext());
        this.functionCodeWriter = new FunctionCodeWriter(this.generationContext());
        this.callbackFunctionCodeWriter = new CallbackFunctionCodeWriter(this.generationContext());
        this.constantCodeWriter = new ConstantCodeWriter(this.generationContext());
        this.comInterfaceWriter = new ComInterfaceWriter(this.generationContext());
        this.isDryRun = false;
        if (Files.notExists(outputDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Output directory does not exist: " + String.valueOf(outputDirectory));
        }
    }

    private PrintWriter createFileWriter(Path path) {
        Path fullPath = this.outputDirectory.resolve(path);
        if (this.generatedFiles != null) {
            this.generatedFiles.add(path);
        }
        try {
            boolean success;
            File directory = fullPath.getParent().toFile();
            if (!directory.exists() && !(success = directory.mkdirs())) {
                throw new GenerationException("Unable to create directory " + String.valueOf(directory));
            }
            File file = fullPath.toFile();
            return new PrintWriter(new FileWriter(file, StandardCharsets.UTF_8));
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Failed to write Java file " + String.valueOf(path), exception);
        }
    }

    private static PrintWriter createNullWriter(Path path) {
        return new PrintWriter(OutputStream.nullOutputStream());
    }

    public Set<Path> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public void setBasePackage(String basePackage) {
        this.generationContext().setBasePackage(basePackage);
    }

    public void setDryRun(boolean isDryRun) {
        this.isDryRun = isDryRun;
        this.generationContext.setWriterFactory(isDryRun ? CodeWriter::createNullWriter : this::createFileWriter);
    }

    public void write(Scope scope) {
        if (!this.isDryRun) {
            this.generatedFiles = new HashSet<Path>();
        }
        scope.getTransitiveTypeScope().forEach(this::writeType);
        scope.getFunctions().forEach(this.functionCodeWriter::writeFunctions);
        scope.getConstants().forEach(this.constantCodeWriter::writeConstants);
    }

    public void writeAll() {
        Metadata metadata = this.generationContext.metadata();
        metadata.types().forEach(this::writeType);
        metadata.namespaces().values().stream().filter(n -> !n.methods().isEmpty()).forEach(namespace -> this.functionCodeWriter.writeFunctions((Namespace)namespace, namespace.methods().values()));
        metadata.namespaces().values().stream().filter(n -> !n.constants().isEmpty()).forEach(namespace -> this.constantCodeWriter.writeConstants((Namespace)namespace, namespace.constants().values()));
    }

    private void writeType(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Struct.class, EnumType.class, Delegate.class, ComInterface.class}, (Object)type3, n)) {
                case 0: {
                    Struct struct = (Struct)type3;
                    if (struct.namespace() == null) {
                        n = 1;
                        continue block6;
                    }
                    this.structCodeWriter.writeStructOrUnion(struct);
                    break block6;
                }
                case 1: {
                    EnumType enumType = (EnumType)type3;
                    this.enumCodeWriter.writeEnum(enumType);
                    break block6;
                }
                case 2: {
                    Delegate delegate = (Delegate)type3;
                    this.callbackFunctionCodeWriter.writeCallbackFunction(delegate);
                    break block6;
                }
                case 3: {
                    ComInterface comInterface = (ComInterface)type3;
                    this.comInterfaceWriter.writeComInterface(comInterface);
                    break block6;
                }
            }
            break;
        }
    }
}

