/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import net.codecrete.windowsapi.metadata.Delegate;
import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.writer.AddressLayout;
import net.codecrete.windowsapi.writer.CommentWriter;
import net.codecrete.windowsapi.writer.FunctionCodeWriterBase;
import net.codecrete.windowsapi.writer.GenerationContext;

class CallbackFunctionCodeWriter
extends FunctionCodeWriterBase<Delegate> {
    private final CommentWriter commentWriter = new CommentWriter();

    CallbackFunctionCodeWriter(GenerationContext generationContext) {
        super(generationContext);
    }

    void writeCallbackFunction(Delegate delegate) {
        String className = CallbackFunctionCodeWriter.toJavaClassName(delegate.name());
        this.withFile(delegate.namespace(), delegate, className, this::writeCallbackFunctionContent);
    }

    private void writeCallbackFunctionContent() {
        Method signature = ((Delegate)this.type).signature();
        this.writer.printf("package %1$s;\n\nimport java.lang.foreign.*;\nimport java.lang.invoke.*;\nimport static java.lang.foreign.ValueLayout.*;\n\n", this.packageName);
        this.writeCallbackFunctionComment();
        this.writer.printf("public class %1$s {\n", this.className);
        this.writeComment("Callback function signature as a functional Java interface.", new Object[0]);
        this.writer.print("    public interface Function {\n");
        this.writeCallbackFunctionInterfaceInvokeComment(signature);
        this.writer.print("        ");
        this.writeFunctionSignature(signature, "invoke");
        this.writer.println(";");
        this.writer.print("    }\n\n");
        this.writeComment("Gets the function descriptor of the callback function.", new Object[0]);
        this.writer.print("    public static FunctionDescriptor descriptor() {\n        return $DESC;\n    }\n\n");
        this.writeComment("Allocates an upcall stub that will call the given function.", new Object[0]);
        this.writer.printf("    public static MemorySegment allocate(Arena arena, %s.Function function) {\n        return Linker.nativeLinker().upcallStub(UPCALL$MH.bindTo(function), $DESC, arena);\n    }\n", this.className);
        this.writer.println();
        this.writeCallbackFunctionInvokeComment(signature);
        String optionalComma = signature.parameters().length > 0 ? ", " : "";
        this.writer.print("    public static ");
        this.writeFunctionSignatureIntro(signature, "invoke");
        this.writer.print("MemorySegment callbackFunction" + optionalComma);
        this.writeFunctionSignatureParameters(signature);
        this.writer.println(" {");
        this.writeInvoke(signature, "DOWNCALL$MH.invokeExact(callbackFunction" + optionalComma, 8);
        this.writer.println("    }");
        this.writer.println();
        AddressLayout.requiredLayouts(signature).forEach(layoutType -> this.writeAddressLayoutInitialization((AddressLayout)layoutType, "private static final "));
        this.writer.println();
        this.writer.print("    private static final FunctionDescriptor $DESC = ");
        this.writeFunctionDescriptor(signature, null);
        this.writer.println(";");
        this.writer.println();
        this.writer.printf("    private static MethodHandle createUpcallHandle() {\n        try {\n            return MethodHandles.lookup().findVirtual(%1$s.Function.class, \"invoke\", $DESC.toMethodType());\n        } catch (ReflectiveOperationException ex) {\n            throw new RuntimeException(ex);\n        }\n    }\n\n    private static final MethodHandle UPCALL$MH = createUpcallHandle();\n\n", this.className);
        this.writer.println("    private static final MethodHandle DOWNCALL$MH = Linker.nativeLinker().downcallHandle($DESC);");
        this.writer.println();
        this.writer.printf("    private %1$s() {}\n}\n", this.className);
    }

    private void writeCallbackFunctionComment() {
        this.writer.printf("/**\n * {@code %1$s} callback function\n", ((Delegate)this.type).nativeName());
        this.writeDocumentationUrl(this.type);
        this.writer.println(" */");
    }

    void writeCallbackFunctionInterfaceInvokeComment(Method method) {
        this.writer.printf("        /**\n         * Invokes the callback function.\n         * <p>\n         * Implement this method to write the callback function in Java.\n         * </p>\n         * <p>\n         * {@snippet lang=c :\n", new Object[0]);
        this.commentWriter.writeFunctionSignatureIntro(this.writer, method, ((Delegate)this.type).nativeName(), 8);
        this.commentWriter.writeFunctionSignatureParameters(this.writer, method, 8);
        this.writer.print("         * );\n         * }\n         * </p>\n         */\n");
    }

    void writeCallbackFunctionInvokeComment(Method method) {
        this.writer.printf("    /**\n     * Invokes the callback function.\n     * <p>\n     * This method calls the given callback function, implemented in native code.\n     * </p>\n     * <p>\n     * {@snippet lang=c :\n", new Object[0]);
        this.commentWriter.writeFunctionSignatureIntro(this.writer, method, "CallbackFunction", 4);
        this.commentWriter.writeFunctionSignatureParameters(this.writer, method, 4);
        this.writer.print("     * );\n     * }\n     * </p>\n     */\n");
    }
}

