/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd.tables;

import java.util.stream.IntStream;

public class Table {
    private final int numRows;
    private int width;
    private int[] columnWidths;
    private byte[] data;

    public Table(int numRows) {
        this.numRows = numRows;
    }

    public int numRows() {
        return this.numRows;
    }

    public int width() {
        return this.width;
    }

    public int indexWidth() {
        return this.numRows < 65536 ? 2 : 4;
    }

    public void setColumnWidths(int ... widths) {
        this.columnWidths = widths;
        this.width = IntStream.of(widths).sum();
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void getRow(int index, int[] values) {
        assert (index > 0 && index <= this.numRows);
        int offset = (index - 1) * this.width;
        for (int columnWidth : this.columnWidths) {
            values[i] = this.getInt(offset, columnWidth);
            offset += columnWidth;
        }
    }

    public int getValue(int rowIndex, int columnIndex) {
        assert (rowIndex > 0 && rowIndex <= this.numRows);
        assert (columnIndex > 0 && columnIndex <= this.columnWidths.length);
        int columnOffset = 0;
        for (int i = 0; i < columnIndex; ++i) {
            columnOffset += this.columnWidths[i];
        }
        int offset = (rowIndex - 1) * this.width + columnOffset;
        return this.getInt(offset, this.columnWidths[columnIndex]);
    }

    public int indexByPrimaryKey(int key, int keyWidth, int keyOffset) {
        int left = 0;
        int right = this.numRows - 1;
        while (left < right) {
            int mid = left + right >>> 1;
            int midKey = this.getInt(mid * this.width + keyOffset, keyWidth);
            if (midKey < key) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        if (left < this.numRows && this.getInt(left * this.width + keyOffset, keyWidth) == key) {
            return left + 1;
        }
        return 0;
    }

    public boolean hasNext(int index, int key, int keyWidth) {
        return index < this.numRows && this.getInt(index * this.width, keyWidth) == key;
    }

    private int getInt16(int offset) {
        int byte1 = this.data[offset] & 0xFF;
        int byte2 = this.data[offset + 1] & 0xFF;
        return byte1 + (byte2 << 8);
    }

    private int getInt32(int offset) {
        int byte1 = this.data[offset] & 0xFF;
        int byte2 = this.data[offset + 1] & 0xFF;
        int byte3 = this.data[offset + 2] & 0xFF;
        int byte4 = this.data[offset + 3] & 0xFF;
        return byte1 + (byte2 << 8) + (byte3 << 16) + (byte4 << 24);
    }

    private int getInt(int offset, int indexLength) {
        return indexLength == 2 ? this.getInt16(offset) : this.getInt32(offset);
    }
}

