/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.codecrete.windowsapi.metadata.ComInterface;
import net.codecrete.windowsapi.metadata.Delegate;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.Metadata;
import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.metadata.TypeAlias;

class VariantTransformation {
    private static final String X64_SUFFIX = "_X64";
    private static final String ARM64_SUFFIX = "_ARM64";
    private static final int X64_OFFSET = 0;
    private static final int ARM64_OFFSET = 1000000;
    private final Metadata metadata;
    private final HashMap<String, HashMap<Integer, Type>> typeVariants = new HashMap();
    private final Set<Integer> unsupportedVariants = new HashSet<Integer>();

    VariantTransformation(Metadata metadata) {
        this.metadata = metadata;
    }

    boolean preprocessType(Type type, int architecture) {
        if ((architecture &= 6) == 0) {
            this.unsupportedVariants.add(type.typeDefIndex());
            return true;
        }
        if (type.namespace() == null) {
            return false;
        }
        if (architecture == 6) {
            return false;
        }
        assert (type instanceof Struct || type instanceof Delegate);
        HashMap variants = this.typeVariants.computeIfAbsent(type.name(), k -> new HashMap());
        variants.put(architecture, type);
        if (type instanceof Struct) {
            Struct struct = (Struct)type;
            struct.setArchitectureSpecific(true);
        }
        return false;
    }

    boolean isUnsupportedVariant(int typeDefIndex) {
        return this.unsupportedVariants.contains(typeDefIndex);
    }

    boolean preprocessMethod(Method method, int architecture) {
        if ((architecture &= 6) == 0) {
            return true;
        }
        if (architecture == 6) {
            return false;
        }
        method.setName(method.nativeName() + (architecture == 2 ? X64_SUFFIX : ARM64_SUFFIX));
        return false;
    }

    void splitCombinedVariants() {
        HashMap architectureSpecificCache = new HashMap();
        Set indirectlySpecificTypes = this.metadata.types().filter(type -> type.namespace() != null).filter(type -> !this.typeVariants.containsKey(type.name())).filter(type -> this.isArchitectureSpecific((Type)type, architectureSpecificCache)).map(Struct.class::cast).collect(Collectors.toSet());
        HashMap<Struct, Type> x64Replacements = new HashMap<Struct, Type>();
        HashMap<Type, Type> arm64Replacements = new HashMap<Type, Type>();
        for (Type type2 : indirectlySpecificTypes) {
            ((Struct)type2).setArchitectureSpecific(true);
            this.metadata.removeType(type2, true);
            Type x64Type = this.duplicateType(type2, 0);
            x64Type.setName(type2.name() + X64_SUFFIX);
            this.metadata.addType(x64Type, true);
            x64Replacements.put((Struct)type2, x64Type);
            Type arm64Type = this.duplicateType(type2, 1000000);
            arm64Type.setName(type2.name() + ARM64_SUFFIX);
            this.metadata.addType(arm64Type, true);
            arm64Replacements.put(type2, arm64Type);
        }
        this.typeVariants.values().stream().map(it -> (Type)it.get(2)).filter(Objects::nonNull).forEach(it -> this.renameType((Type)it, X64_SUFFIX));
        this.typeVariants.values().stream().map(it -> (Type)it.get(4)).filter(Objects::nonNull).forEach(it -> this.renameType((Type)it, ARM64_SUFFIX));
        for (Type type2 : x64Replacements.values()) {
            type2.replaceTypes(it -> this.replaceType((Type)it, (Map<Type, Type>)x64Replacements));
        }
        for (Type type2 : arm64Replacements.values()) {
            type2.replaceTypes(it -> this.replaceType((Type)it, (Map<Type, Type>)arm64Replacements));
        }
        this.typeVariants.values().stream().map(it -> (Type)it.get(2)).filter(Objects::nonNull).forEach(type -> type.replaceTypes(it -> this.replaceType((Type)it, x64Replacements)));
        this.typeVariants.values().stream().map(it -> (Type)it.get(4)).filter(Objects::nonNull).forEach(type -> type.replaceTypes(it -> this.replaceType((Type)it, arm64Replacements)));
        this.metadata.methods().filter(method -> method.name().endsWith(X64_SUFFIX)).forEach(method -> method.replaceTypes(it -> this.replaceType((Type)it, x64Replacements)));
        this.metadata.methods().filter(method -> method.name().endsWith(ARM64_SUFFIX)).forEach(method -> method.replaceTypes(it -> this.replaceType((Type)it, arm64Replacements)));
    }

    private void renameType(Type type, String suffix) {
        this.metadata.removeType(type, false);
        type.setName(type.name() + suffix);
        this.metadata.addType(type, true);
    }

    private Type duplicateType(Type type, int offset) {
        assert (type instanceof Struct);
        Struct struct = (Struct)type;
        return struct.duplicate(struct.typeDefIndex() + offset);
    }

    private Type replaceType(Type type, Map<Type, Type> replacements) {
        Pointer pointer;
        Type referencedType;
        Type replacedRefType;
        Type replacement = replacements.get(type);
        if (replacement != null) {
            return replacement;
        }
        Type replacedType = type;
        if (type instanceof Pointer && (replacedRefType = this.replaceType(referencedType = (pointer = (Pointer)type).referencedType(), replacements)) != referencedType) {
            replacedType = this.metadata.makePointerFor(replacedRefType);
        }
        return replacedType;
    }

    private boolean isArchitectureSpecific(Type type, Map<Type, Boolean> visited) {
        Boolean isSpecific = visited.get(type);
        if (isSpecific != null) {
            return isSpecific;
        }
        isSpecific = this.isArchitectureSpecificNonRecursive(type);
        if (isSpecific != null) {
            return isSpecific;
        }
        return this.isArchitectureSpecificRecursive(type, visited);
    }

    private Boolean isArchitectureSpecificNonRecursive(Type type) {
        if (type instanceof Primitive || type instanceof EnumType) {
            return Boolean.FALSE;
        }
        if (type instanceof Struct || type instanceof Delegate) {
            return type.namespace() != null && this.typeVariants.containsKey(type.name()) ? Boolean.TRUE : null;
        }
        if (type instanceof Pointer) {
            return Boolean.FALSE;
        }
        if (type instanceof TypeAlias) {
            TypeAlias typeAlias = (TypeAlias)type;
            return this.isArchitectureSpecificNonRecursive(typeAlias.aliasedType());
        }
        return null;
    }

    private boolean isArchitectureSpecificRecursive(Type type, Map<Type, Boolean> visited) {
        assert (!visited.containsKey(type));
        if (type instanceof Struct || type instanceof ComInterface) {
            visited.put(type, null);
        }
        Iterator iterator = type.referencedTypes().iterator();
        while (iterator.hasNext()) {
            Type memberType = (Type)iterator.next();
            Boolean isSpecific = visited.get(memberType);
            if (isSpecific == null && visited.containsKey(memberType)) continue;
            if (isSpecific == null) {
                isSpecific = this.isArchitectureSpecificNonRecursive(memberType);
            }
            if (isSpecific == null) {
                isSpecific = this.isArchitectureSpecificRecursive(memberType, visited);
            }
            if (!isSpecific.booleanValue()) continue;
            if (type instanceof Struct || type instanceof ComInterface) {
                visited.put(type, Boolean.TRUE);
            }
            return true;
        }
        if (type instanceof Struct || type instanceof ComInterface) {
            visited.put(type, Boolean.FALSE);
        }
        return false;
    }
}

