/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.Member;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.winmd.LayoutRequirement;
import net.codecrete.windowsapi.winmd.MetadataFile;
import net.codecrete.windowsapi.winmd.tables.FieldLayout;

class StructLayouter {
    private static final Set<String> VARIABLE_SIZE_EXEMPTIONS = Set.of("IMAGEHLP_SYMBOL64_PACKAGE", "IMAGEHLP_SYMBOLW64_PACKAGE", "SYMBOL_INFO_PACKAGE", "SYMBOL_INFO_PACKAGEW", "KSSTREAMALLOCATOR_STATUS_EX");
    private final MetadataFile metadataFile;

    StructLayouter(MetadataFile metadataFile) {
        this.metadataFile = metadataFile;
    }

    void layout(Struct struct) {
        if (struct.isLayoutDone()) {
            return;
        }
        if (struct.isUnion()) {
            this.layoutUnion(struct);
        } else {
            this.layoutSequential(struct);
        }
        struct.setFlexibleArrayMember(StructLayouter.findFlexibleMember(struct));
        struct.setLayoutDone();
    }

    private void layoutSequential(Struct struct) {
        LayoutState state = new LayoutState(struct.packageSize());
        Member previousMember = null;
        for (Member member : struct.members()) {
            int previousEndOffset = state.endOffset;
            this.ensureLayoutDone(member.type());
            state.advance(member.type());
            if (previousMember != null) {
                previousMember.setPaddingAfter(state.startOffset - previousEndOffset);
            }
            member.setOffset(state.startOffset);
            previousMember = member;
        }
        this.finishStructLayout(struct, state, previousMember);
    }

    private void layoutUnion(Struct struct) {
        LayoutState state = new LayoutState(struct.packageSize());
        Member previousMember = null;
        for (Member member : struct.members()) {
            FieldLayout fieldLayout = this.metadataFile.getFieldLayout(member.fieldIndex());
            assert (fieldLayout.offset() == 0);
            this.ensureLayoutDone(member.type());
            state.overlay(member.type());
            previousMember = member;
        }
        this.finishStructLayout(struct, state, previousMember);
    }

    private void finishStructLayout(Struct struct, LayoutState state, Member lastMember) {
        int previousEndOffset = state.endOffset;
        state.advance(0, state.packageSize);
        assert (struct.structSize() == 0 || struct.structSize() == state.startOffset);
        struct.setStructSize(state.startOffset);
        assert (struct.packageSize() == 0 || struct.packageSize() == state.packageSize);
        struct.setPackageSize(state.packageSize);
        if (lastMember != null) {
            lastMember.setPaddingAfter(state.startOffset - previousEndOffset);
        }
    }

    private void ensureLayoutDone(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Struct.class, Array.class}, (Object)type3, n)) {
            case 0: {
                Struct struct = (Struct)type3;
                this.layout(struct);
                break;
            }
            case 1: {
                Array array = (Array)type3;
                this.ensureLayoutDone(array.itemType());
                break;
            }
        }
    }

    private static Member findFlexibleMember(Struct struct) {
        if (struct.isUnion()) {
            return null;
        }
        if (VARIABLE_SIZE_EXEMPTIONS.contains(struct.name())) {
            return null;
        }
        return struct.members().stream().map(StructLayouter::findFlexible).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static Member findFlexible(Member member) {
        Type type = member.type();
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Array.class, Struct.class}, (Object)type2, n)) {
            case 0 -> {
                Array array = (Array)type2;
                if (array.isFlexible()) {
                    yield member;
                }
                yield null;
            }
            case 1 -> {
                Struct struct = (Struct)type2;
                yield StructLayouter.findFlexibleMember(struct);
            }
            default -> null;
        };
    }

    private static class LayoutState {
        private final boolean forcedPackageSize;
        private int startOffset;
        private int endOffset;
        private int packageSize;

        private LayoutState(int packageSize) {
            this.forcedPackageSize = packageSize != 0;
            this.packageSize = this.forcedPackageSize ? packageSize : 1;
        }

        private void advance(Type type) {
            LayoutRequirement requirement = LayoutRequirement.forType(type);
            this.advance(requirement.size(), requirement.alignment());
        }

        private void advance(int size, int alignment) {
            if (this.forcedPackageSize) {
                alignment = Math.min(alignment, this.packageSize);
                this.startOffset = this.endOffset + alignment - 1 & -alignment;
            } else {
                this.startOffset = this.endOffset + alignment - 1 & -alignment;
                this.packageSize = Math.max(this.packageSize, alignment);
            }
            this.endOffset = this.startOffset + size;
        }

        private void overlay(Type type) {
            LayoutRequirement requirement = LayoutRequirement.forType(type);
            this.endOffset = Math.max(this.endOffset, requirement.size());
            if (!this.forcedPackageSize) {
                this.packageSize = Math.max(this.packageSize, requirement.alignment());
            }
        }
    }
}

