/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd;

import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.ComInterface;
import net.codecrete.windowsapi.metadata.ConstantValue;
import net.codecrete.windowsapi.metadata.Delegate;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.Member;
import net.codecrete.windowsapi.metadata.Metadata;
import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Parameter;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.PrimitiveKind;
import net.codecrete.windowsapi.metadata.QualifiedName;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.metadata.TypeAlias;
import net.codecrete.windowsapi.metadata.TypeKind;
import net.codecrete.windowsapi.winmd.Blob;
import net.codecrete.windowsapi.winmd.CustomAttributeDecoder;
import net.codecrete.windowsapi.winmd.Decoder;
import net.codecrete.windowsapi.winmd.FieldCustomAttributeData;
import net.codecrete.windowsapi.winmd.MetadataFile;
import net.codecrete.windowsapi.winmd.MethodCustomAttributeData;
import net.codecrete.windowsapi.winmd.MethodSignature;
import net.codecrete.windowsapi.winmd.ParamCustomAttributeData;
import net.codecrete.windowsapi.winmd.SignatureDecoder;
import net.codecrete.windowsapi.winmd.StructLayouter;
import net.codecrete.windowsapi.winmd.TypeCustomAttributeData;
import net.codecrete.windowsapi.winmd.TypeLookup;
import net.codecrete.windowsapi.winmd.VariantTransformation;
import net.codecrete.windowsapi.winmd.WinmdException;
import net.codecrete.windowsapi.winmd.tables.ClassLayout;
import net.codecrete.windowsapi.winmd.tables.CodedIndex;
import net.codecrete.windowsapi.winmd.tables.CodedIndexes;
import net.codecrete.windowsapi.winmd.tables.Constant;
import net.codecrete.windowsapi.winmd.tables.Field;
import net.codecrete.windowsapi.winmd.tables.ImplMap;
import net.codecrete.windowsapi.winmd.tables.MethodDef;
import net.codecrete.windowsapi.winmd.tables.NestedClass;
import net.codecrete.windowsapi.winmd.tables.Param;
import net.codecrete.windowsapi.winmd.tables.TypeDef;
import net.codecrete.windowsapi.winmd.tables.TypeRef;

public class MetadataBuilder
implements TypeLookup {
    private static final String APIS = "Apis";
    private final MetadataFile metadataFile;
    private final Metadata metadata;
    private final VariantTransformation variantTransformation;
    private final Primitive[] primitiveTypes = new Primitive[15];
    private final CustomAttributeDecoder customAttributeDecoder;
    private final Map<Integer, Namespace> apiTypes = new HashMap<Integer, Namespace>();
    private final SignatureDecoder signatureDecoder;
    private final Primitive intPtrType;
    private final Primitive uintPtrType;
    private final Pointer voidPointerType;
    private final Struct systemGuidType;
    private static final Set<String> STATIC_INITIALIZER_CONSTANT_TYPES = Set.of("PROPERTYKEY", "DEVPROPKEY", "SID_IDENTIFIER_AUTHORITY", "CONDITION_VARIABLE", "SRWLOCK", "INIT_ONCE");

    public static Metadata load() {
        Metadata metadata;
        block8: {
            InputStream stream = MetadataBuilder.class.getClassLoader().getResourceAsStream("Windows.Win32.winmd");
            try {
                MetadataBuilder builder = new MetadataBuilder(new MetadataFile(stream));
                metadata = builder.build();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new WinmdException("Cannot open resource 'Windows.Win32.winmd'", e);
                }
            }
            stream.close();
        }
        return metadata;
    }

    private MetadataBuilder(MetadataFile metadataFile) {
        this.metadataFile = metadataFile;
        this.metadata = new Metadata();
        this.variantTransformation = new VariantTransformation(this.metadata);
        this.primitiveTypes[1] = this.metadata.getPrimitive(PrimitiveKind.VOID);
        this.primitiveTypes[2] = this.metadata.getPrimitive(PrimitiveKind.BOOL);
        this.primitiveTypes[3] = this.metadata.getPrimitive(PrimitiveKind.CHAR);
        this.primitiveTypes[4] = this.metadata.getPrimitive(PrimitiveKind.SBYTE);
        this.primitiveTypes[5] = this.metadata.getPrimitive(PrimitiveKind.BYTE);
        this.primitiveTypes[6] = this.metadata.getPrimitive(PrimitiveKind.INT16);
        this.primitiveTypes[7] = this.metadata.getPrimitive(PrimitiveKind.UINT16);
        this.primitiveTypes[8] = this.metadata.getPrimitive(PrimitiveKind.INT32);
        this.primitiveTypes[9] = this.metadata.getPrimitive(PrimitiveKind.UINT32);
        this.primitiveTypes[10] = this.metadata.getPrimitive(PrimitiveKind.INT64);
        this.primitiveTypes[11] = this.metadata.getPrimitive(PrimitiveKind.UINT64);
        this.primitiveTypes[12] = this.metadata.getPrimitive(PrimitiveKind.SINGLE);
        this.primitiveTypes[13] = this.metadata.getPrimitive(PrimitiveKind.DOUBLE);
        this.primitiveTypes[14] = this.metadata.getPrimitive(PrimitiveKind.STRING);
        this.intPtrType = this.metadata.getPrimitive(PrimitiveKind.INT_PTR);
        this.uintPtrType = this.metadata.getPrimitive(PrimitiveKind.UINT_PTR);
        this.voidPointerType = this.metadata.makePointerFor(this.primitiveTypes[1]);
        this.signatureDecoder = new SignatureDecoder(this);
        this.customAttributeDecoder = new CustomAttributeDecoder(this, metadataFile);
        this.systemGuidType = (Struct)this.metadata.getType("System", "Guid");
    }

    private Metadata build() {
        this.buildTypes();
        this.buildMethodsAndConstants();
        this.buildTypeFields();
        this.convertGuidConstants();
        this.buildMethodParameters();
        this.buildDelegateSignatures();
        this.variantTransformation.splitCombinedVariants();
        this.calculateTypeLayout();
        return this.metadata;
    }

    private void buildTypes() {
        for (int typeDefIndex = 2; typeDefIndex <= this.metadataFile.getTypeDefinitionCount(); ++typeDefIndex) {
            this.buildType(typeDefIndex);
        }
    }

    private void buildType(int typeDefIndex) {
        assert (this.metadata.getTypeByTypeDefIndex(typeDefIndex) == null);
        TypeDef typeDef = this.metadataFile.getTypeDef(typeDefIndex);
        String typeName = this.metadataFile.getString(typeDef.typeName());
        String namespaceName = this.metadataFile.getString(typeDef.typeNamespace());
        int visibility = typeDef.typeAttributes() & 7;
        assert (visibility == 1 || visibility == 2);
        boolean isNested = visibility == 2;
        Namespace namespace = null;
        if (!isNested) {
            namespace = this.metadata.getOrCreateNamespace(namespaceName);
        }
        if (typeName.equals(APIS)) {
            this.apiTypes.put(typeDefIndex, namespace);
            return;
        }
        TypeKind typeKind = this.getTypeKind(typeDef);
        TypeCustomAttributeData customAttributesData = this.customAttributeDecoder.getTypeDefAttributes(typeDefIndex);
        if (customAttributesData.isTypedef) {
            typeKind = TypeKind.ALIAS;
        }
        ClassLayout classLayout = (typeDef.typeAttributes() & 0x18) != 0 ? this.metadataFile.getClassLayout(typeDefIndex) : null;
        boolean isUnion = (typeDef.typeAttributes() & 0x18) == 16;
        int packageSize = classLayout != null ? classLayout.packingSize() : 0;
        int classSize = classLayout != null ? classLayout.classSize() : 0;
        Struct enclosingType = null;
        if (isNested) {
            NestedClass nestedClass = this.metadataFile.getNestedClass(typeDefIndex);
            assert (nestedClass != null);
            if (this.variantTransformation.isUnsupportedVariant(nestedClass.enclosingClass())) {
                return;
            }
            Type enclosingTypeCandidate = this.metadata.getTypeByTypeDefIndex(nestedClass.enclosingClass());
            assert (enclosingTypeCandidate instanceof Struct);
            enclosingType = (Struct)enclosingTypeCandidate;
        }
        assert (enclosingType == null || typeKind == TypeKind.STRUCT);
        assert (typeKind != null);
        Type type = switch (typeKind) {
            case TypeKind.STRUCT -> new Struct(typeName, namespace, typeDefIndex, isUnion, packageSize, classSize, enclosingType, customAttributesData.structSizeField, customAttributesData.guidConstant);
            case TypeKind.ENUM -> new EnumType(typeName, namespace, typeDefIndex, customAttributesData.isEnumFlags);
            case TypeKind.DELEGATE -> new Delegate(typeName, namespace, typeDefIndex);
            case TypeKind.COM_INTERFACE -> new ComInterface(typeName, namespace, typeDefIndex, customAttributesData.guidConstant);
            case TypeKind.ATTRIBUTE -> null;
            case TypeKind.ALIAS -> this.metadata.makeAliasFor(typeDefIndex, typeName, namespace);
            default -> throw new AssertionError((Object)("Unsupported type: " + String.valueOf((Object)typeKind)));
        };
        if (type == null) {
            return;
        }
        if (this.variantTransformation.preprocessType(type, customAttributesData.supportedArchitecture)) {
            return;
        }
        type.setDocumentationUrl(customAttributesData.documentationUrl);
        this.metadata.addType(type, customAttributesData.supportedArchitecture == 7);
        if (type.namespace() != null && type.name().equals("Architecture") && type.namespace().name().equals("Windows.Win32.Foundation.Metadata")) {
            this.buildFields(type);
        }
    }

    private void buildTypeFields() {
        this.metadata.types().forEach(this::buildFields);
    }

    private void buildFields(Type type) {
        Struct struct;
        EnumType enumType;
        Struct struct2;
        if (type instanceof Struct && (struct2 = (Struct)type).members() != null) {
            return;
        }
        if (type instanceof EnumType && (enumType = (EnumType)type).members() != null) {
            return;
        }
        List<Member> fields = this.getFields(type.typeDefIndex(), type instanceof Struct ? (struct = (Struct)type) : null);
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Struct.class, EnumType.class, TypeAlias.class}, (Object)type3, n)) {
            case 0: {
                Struct struct3 = (Struct)type3;
                struct3.setMembers(fields);
                if (!struct3.hasNestedTypes()) break;
                for (Type nestedType : struct3.nestedTypes()) {
                    this.buildFields(nestedType);
                }
                break;
            }
            case 1: {
                EnumType enumType2 = (EnumType)type3;
                assert (!fields.isEmpty() && fields.getFirst().name().equals("value__"));
                Type enumBaseType = fields.getFirst().type();
                assert (enumBaseType instanceof Primitive);
                enumType2.setBaseType((Primitive)enumBaseType);
                fields.removeFirst();
                enumType2.setMembers(fields);
                break;
            }
            case 2: {
                TypeAlias typeAlias = (TypeAlias)type3;
                assert (!fields.isEmpty() && fields.getFirst().name().equals("Value"));
                Member member = fields.getFirst();
                typeAlias.setAliasedType(member.type());
                break;
            }
            default: {
                assert (fields.isEmpty());
                break;
            }
        }
    }

    private List<Member> getFields(int typeDefIndex, Struct parentType) {
        ArrayList<Member> fields = new ArrayList<Member>();
        for (Field field : this.metadataFile.getFields(typeDefIndex)) {
            String name = this.metadataFile.getString(field.name());
            Type fieldType = this.signatureDecoder.decodeFieldSignature(this.metadataFile.getBlob(field.signature()), parentType);
            Object value = null;
            if (field.flags() == 32854) {
                int parentIndex = CodedIndex.encode(4, field.index(), CodedIndexes.HAS_CONSTANT_TABLES);
                Constant constant = this.metadataFile.getConstant(parentIndex);
                assert (constant.type() != 18);
                Blob valueBlob = this.metadataFile.getBlob(constant.value());
                value = Decoder.readConstantVal(valueBlob, constant.type());
                assert (valueBlob.isAtEnd());
            } else if (fieldType instanceof Array) {
                Array array = (Array)fieldType;
                FieldCustomAttributeData customAttributesData = this.customAttributeDecoder.getFieldAttributes(field.index());
                if (customAttributesData != null && customAttributesData.isFlexibleArray) {
                    array.setFlexible(true);
                    this.adjustArraySizes(array, name, parentType);
                }
            }
            Member member = new Member(name, field.index(), fieldType, value);
            fields.add(member);
        }
        return fields;
    }

    private void adjustArraySizes(Array array, String memberName, Struct parentType) {
        if (memberName.equals("CachePaths") && parentType.enclosingType() != null && parentType.enclosingType().name().startsWith("INTERNET_CACHE_CONFIG_INFO")) {
            array.setFlexible(false);
        }
    }

    private void convertGuidConstants() {
        List<Struct> guidConstants = this.metadata.types().filter(this::isGuidConstant).map(Struct.class::cast).toList();
        for (Struct struct : guidConstants) {
            this.metadata.removeType(struct, true);
            ConstantValue constant = new ConstantValue(struct.name(), struct.namespace(), this.systemGuidType, struct.guid(), false, struct.documentationUrl());
            struct.namespace().addConstant(constant);
        }
    }

    private boolean isGuidConstant(Type type) {
        Struct struct;
        return type instanceof Struct && (struct = (Struct)type).members().isEmpty() && struct.guid() != null;
    }

    private List<ComInterface> getInterfaces(int typeDefIndex) {
        return StreamSupport.stream(this.metadataFile.getInterfaceImpl(typeDefIndex).spliterator(), false).map(interfaceImpl -> {
            CodedIndex typeDefOrRef = interfaceImpl.interfaceTypeDefOrRef();
            assert (typeDefOrRef.table() == 1);
            Type interfaceType = this.getTypeByTypeRef(typeDefOrRef.index(), null, false);
            return (ComInterface)interfaceType;
        }).toList();
    }

    private void calculateTypeLayout() {
        StructLayouter calculator = new StructLayouter(this.metadataFile);
        this.metadata.types().forEach(type -> {
            if (type instanceof Struct) {
                Struct struct = (Struct)type;
                calculator.layout(struct);
            }
        });
    }

    private void buildMethodsAndConstants() {
        for (Map.Entry<Integer, Namespace> entry : this.apiTypes.entrySet()) {
            this.buildMethods(entry.getKey(), entry.getValue());
            this.buildConstants(entry.getKey(), entry.getValue());
        }
    }

    private void buildMethods(int typeDefIndex, Namespace parentNamespace) {
        this.createMethods(typeDefIndex, parentNamespace).forEach(method -> {
            MethodCustomAttributeData customAttributesData = this.customAttributeDecoder.getMethodDefAttributes(method.methodDefIndex());
            method.setConstantValue(customAttributesData.constantValue);
            method.setDocumentationUrl(customAttributesData.documentationUrl);
            if (!this.variantTransformation.preprocessMethod((Method)method, customAttributesData.supportedArchitecture)) {
                this.metadata.addMethod((Method)method);
            }
        });
    }

    private void buildConstants(int typeDefIndex, Namespace namespace) {
        List<Member> fields = this.getFields(typeDefIndex, null);
        for (Member field : fields) {
            ConstantValue constant;
            String name = field.name();
            Object value = field.value();
            Type type = field.type();
            String typeName = type.name();
            FieldCustomAttributeData customData = this.customAttributeDecoder.getFieldAttributes(field.fieldIndex());
            if (value instanceof Number) {
                constant = new ConstantValue(name, namespace, type, value, false, customData.documentationUrl);
            } else if (value instanceof String) {
                constant = new ConstantValue(name, namespace, type, value, customData.isAnsiEncoding, customData.documentationUrl);
            } else if (type == this.systemGuidType) {
                constant = new ConstantValue(name, namespace, type, customData.guidConstant, false, customData.documentationUrl);
            } else if (STATIC_INITIALIZER_CONSTANT_TYPES.contains(typeName)) {
                constant = new ConstantValue(name, namespace, type, customData.constantValue, false, customData.documentationUrl);
            } else {
                throw new AssertionError((Object)("Unsupported constant type: " + typeName + " / " + String.valueOf(customData.constantValue)));
            }
            namespace.addConstant(constant);
        }
    }

    private Stream<Method> createMethods(int typeDefIndex, Namespace parentNamespace) {
        return StreamSupport.stream(this.metadataFile.getMethodDefs(typeDefIndex).spliterator(), false).map(methodDef -> {
            String methodName = this.metadataFile.getString(methodDef.name());
            return new Method(methodName, parentNamespace, methodDef.index());
        });
    }

    private void buildMethodParameters() {
        this.metadata.methods().forEach(this::buildMethodParameters);
    }

    private void buildMethodParameters(Method method) {
        assert (method.methodDefIndex() != 0);
        int memberForwarded = CodedIndex.encode(6, method.methodDefIndex(), CodedIndexes.MEMBER_FORWARDED_TABLES);
        ImplMap implMap = this.metadataFile.getImplMap(memberForwarded);
        if (implMap != null) {
            int nameIndex = this.metadataFile.getModuleRefName(implMap.importScope());
            method.setDll(this.metadataFile.getString(nameIndex));
            if (method.dll().equals("FORCEINLINE")) {
                assert (method.constantValue() != null);
                method.setDll(null);
            }
            method.setSupportsLastError((implMap.flags() & 0x40) != 0);
        }
        MethodDef methodDef = this.metadataFile.getMethodDef(method.methodDefIndex());
        MethodSignature methodSignature = this.signatureDecoder.decodeMethodDefSignature(this.metadataFile.getBlob(methodDef.signature()));
        method.setReturnType(methodSignature.returnType());
        Parameter[] parameters = new Parameter[methodSignature.paramTypes().length];
        int index = 0;
        for (Param param : this.metadataFile.getParameters(method.methodDefIndex())) {
            String paramName = this.metadataFile.getString(param.name());
            if (param.sequence() < 1) {
                assert (paramName == null);
                continue;
            }
            assert (paramName != null);
            ParamCustomAttributeData attributes = this.customAttributeDecoder.getParamAttributes(param.index());
            EnumType associatedEnumType = null;
            if (attributes.associatedEnumType != null) {
                associatedEnumType = this.metadata.getEnumType(attributes.associatedEnumType);
            }
            parameters[index] = new Parameter(paramName, methodSignature.paramTypes()[index], associatedEnumType);
            ++index;
        }
        assert (index == parameters.length);
        method.setParameters(parameters);
    }

    private void buildDelegateSignatures() {
        this.metadata.types().forEach(type -> {
            if (type instanceof Delegate) {
                Delegate delegate = (Delegate)type;
                this.buildDelegateSignature(delegate);
            }
            if (type instanceof ComInterface) {
                ComInterface comInterface = (ComInterface)type;
                this.buildComInterfaceMethods(comInterface);
            }
        });
    }

    private void buildDelegateSignature(Delegate delegate) {
        Optional<Method> invoke = this.createMethods(delegate.typeDefIndex(), delegate.namespace()).filter(method -> method.name().equals("Invoke")).findFirst();
        invoke.ifPresentOrElse(method -> {
            this.buildMethodParameters((Method)method);
            delegate.setSignature((Method)method);
        }, () -> {
            throw new AssertionError((Object)"Delegate has no method called 'Invoke'");
        });
    }

    private void buildComInterfaceMethods(ComInterface comInterface) {
        comInterface.setImplementedInterfaces(this.getInterfaces(comInterface.typeDefIndex()));
        comInterface.setMethods(this.createMethods(comInterface.typeDefIndex(), comInterface.namespace()).toList());
        comInterface.methods().forEach(this::buildMethodParameters);
    }

    private TypeKind getTypeKind(TypeDef typeDef) {
        CodedIndex baseClassTypeDefOrRef = typeDef.extendsTypeIndex();
        if (baseClassTypeDefOrRef.isNull()) {
            if (typeDef.typeAttributes() == 161) {
                return TypeKind.COM_INTERFACE;
            }
            assert (false) : "Unexpected attributes for type definition without base type";
            return null;
        }
        QualifiedName baseClass = this.getTypeName(baseClassTypeDefOrRef);
        if (baseClass.namespace().equals("System")) {
            return switch (baseClass.name()) {
                case "Enum" -> TypeKind.ENUM;
                case "ValueType" -> TypeKind.STRUCT;
                case "Attribute" -> TypeKind.ATTRIBUTE;
                case "MulticastDelegate" -> TypeKind.DELEGATE;
                default -> throw new AssertionError((Object)("Unknown base type " + baseClass.name()));
            };
        }
        assert (false) : "Unexpected base type";
        return null;
    }

    private QualifiedName getTypeName(CodedIndex typeDefOrRefIndex) {
        String namespace = "";
        String name = "";
        if (typeDefOrRefIndex.table() == 1) {
            TypeRef typeRef = this.metadataFile.getTypeRef(typeDefOrRefIndex.index());
            CodedIndex resolutionScopeIndex = typeRef.resolutionScopeIndex();
            if (resolutionScopeIndex.table() == 35 && resolutionScopeIndex.index() == 1) {
                namespace = this.metadataFile.getString(typeRef.typeNamespace());
                name = this.metadataFile.getString(typeRef.typeName());
            } else assert (false) : "Unexpected resolution scope for base type reference";
        } else assert (false) : "Unexpected table for base type";
        return new QualifiedName(namespace, name);
    }

    @Override
    public Primitive getPrimitiveType(int elementType) {
        if (elementType < this.primitiveTypes.length) {
            return this.primitiveTypes[elementType];
        }
        if (elementType == 24) {
            return this.intPtrType;
        }
        if (elementType == 25) {
            return this.uintPtrType;
        }
        return null;
    }

    @Override
    public Type getTypeByTypeDef(int typeDefIndex) {
        return this.metadata.getTypeByTypeDefIndex(typeDefIndex);
    }

    @Override
    public Type getTypeByTypeRef(int typeRefIndex, Struct parentType, boolean externalTypeAllowed) {
        TypeRef typeRef = this.metadataFile.getTypeRef(typeRefIndex);
        String namespace = this.metadataFile.getString(typeRef.typeNamespace());
        String name = this.metadataFile.getString(typeRef.typeName());
        CodedIndex resolutionScopeIndex = typeRef.resolutionScopeIndex();
        return switch (resolutionScopeIndex.table()) {
            case 1 -> parentType.getNestedType(name);
            case 0 -> this.metadata.getType(namespace, name);
            case 35 -> {
                if (name.equals(this.systemGuidType.name()) && namespace.equals(this.systemGuidType.namespace().name())) {
                    yield this.systemGuidType;
                }
                if (!$assertionsDisabled && !externalTypeAllowed) {
                    throw new AssertionError();
                }
                yield this.voidPointerType;
            }
            default -> throw new AssertionError((Object)"Resolution scope MODULE is not supported");
        };
    }

    @Override
    public int getElementType(Primitive primitiveType) {
        assert (primitiveType != null);
        for (int i = 1; i < this.primitiveTypes.length; ++i) {
            if (this.primitiveTypes[i] != primitiveType) continue;
            return i;
        }
        throw new AssertionError((Object)("Unexpected primitive type: " + String.valueOf(primitiveType)));
    }

    @Override
    public Pointer makePointerFor(Type type) {
        return this.metadata.makePointerFor(type);
    }
}

