/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.ComInterface;
import net.codecrete.windowsapi.metadata.Delegate;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.PrimitiveKind;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.metadata.TypeAlias;

public record LayoutRequirement(int size, int alignment) {
    public static LayoutRequirement forType(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Primitive.class, Struct.class, EnumType.class, Pointer.class, Delegate.class, ComInterface.class, Array.class, TypeAlias.class}, (Object)type3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Primitive primitive = (Primitive)type3;
                yield LayoutRequirement.forPrimitive(primitive);
            }
            case 1 -> {
                Struct struct = (Struct)type3;
                yield LayoutRequirement.getStructRequirement(struct);
            }
            case 2 -> {
                EnumType enumType = (EnumType)type3;
                yield LayoutRequirement.forPrimitive(enumType.baseType());
            }
            case 3 -> {
                Pointer ignored = (Pointer)type3;
                yield new LayoutRequirement(8, 8);
            }
            case 4 -> {
                Delegate ignored = (Delegate)type3;
                yield new LayoutRequirement(8, 8);
            }
            case 5 -> {
                ComInterface ignored = (ComInterface)type3;
                yield new LayoutRequirement(8, 8);
            }
            case 6 -> {
                Array arrayType = (Array)type3;
                yield LayoutRequirement.getArrayRequirement(arrayType);
            }
            case 7 -> {
                TypeAlias typeAlias = (TypeAlias)type3;
                yield LayoutRequirement.forType(typeAlias.aliasedType());
            }
        };
    }

    private static LayoutRequirement getStructRequirement(Struct type) {
        assert (type.isLayoutDone());
        return new LayoutRequirement(type.structSize(), type.packageSize());
    }

    private static LayoutRequirement getArrayRequirement(Array type) {
        LayoutRequirement requirement = LayoutRequirement.forType(type.itemType());
        return new LayoutRequirement(type.arrayLength() * requirement.size(), requirement.alignment());
    }

    public static int primitiveSize(Primitive type) {
        return switch (type.kind()) {
            case PrimitiveKind.INT64, PrimitiveKind.UINT64, PrimitiveKind.DOUBLE, PrimitiveKind.INT_PTR, PrimitiveKind.UINT_PTR -> 8;
            case PrimitiveKind.INT32, PrimitiveKind.UINT32, PrimitiveKind.SINGLE -> 4;
            case PrimitiveKind.UINT16, PrimitiveKind.INT16, PrimitiveKind.CHAR -> 2;
            case PrimitiveKind.BYTE, PrimitiveKind.SBYTE, PrimitiveKind.BOOL -> 1;
            default -> throw new AssertionError((Object)("Unexpected type: " + type.name()));
        };
    }

    public static LayoutRequirement forPrimitive(Primitive type) {
        int size = LayoutRequirement.primitiveSize(type);
        return new LayoutRequirement(size, size);
    }
}

