/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.codecrete.windowsapi.metadata.ArgumentValue;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.LazyString;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.QualifiedName;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.winmd.Blob;
import net.codecrete.windowsapi.winmd.CustomAttributeValue;
import net.codecrete.windowsapi.winmd.Decoder;
import net.codecrete.windowsapi.winmd.FieldCustomAttributeData;
import net.codecrete.windowsapi.winmd.MetadataFile;
import net.codecrete.windowsapi.winmd.MethodCustomAttributeData;
import net.codecrete.windowsapi.winmd.MethodSignature;
import net.codecrete.windowsapi.winmd.ParamCustomAttributeData;
import net.codecrete.windowsapi.winmd.TypeCustomAttributeData;
import net.codecrete.windowsapi.winmd.TypeLookup;
import net.codecrete.windowsapi.winmd.tables.CodedIndex;
import net.codecrete.windowsapi.winmd.tables.CodedIndexes;
import net.codecrete.windowsapi.winmd.tables.CustomAttribute;
import net.codecrete.windowsapi.winmd.tables.MemberRef;
import net.codecrete.windowsapi.winmd.tables.TypeRef;

class CustomAttributeDecoder
extends Decoder {
    private static final String SYSTEM = "System";
    private static final String METADATA = "Windows.Win32.Foundation.Metadata";
    private static final QualifiedName FLAGS_ATTRIBUTE = new QualifiedName("System", "FlagsAttribute");
    private static final QualifiedName ASSOCIATED_ENUM_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "AssociatedEnumAttribute");
    private static final QualifiedName CONSTANT_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "ConstantAttribute");
    private static final QualifiedName DOCUMENTATION_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "DocumentationAttribute");
    private static final QualifiedName FLEXIBLE_ARRAY_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "FlexibleArrayAttribute");
    private static final QualifiedName GUID_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "GuidAttribute");
    private static final QualifiedName NATIVE_ENCODING_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "NativeEncodingAttribute");
    private static final QualifiedName NATIVE_TYPEDEF_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "NativeTypedefAttribute");
    private static final QualifiedName STRUCT_SIZE_FIELD_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "StructSizeFieldAttribute");
    private static final QualifiedName SUPPORTED_ARCHITECTURE_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "SupportedArchitectureAttribute");
    private static final Map<QualifiedName, Extractor<TypeCustomAttributeData>> typeAttributeExtractors = Map.of(SUPPORTED_ARCHITECTURE_ATTRIBUTE, (context, data) -> {
        data.supportedArchitecture = ((Number)context.getValue().fixedArguments()[0].value()).intValue();
    }, DOCUMENTATION_ATTRIBUTE, (context, data) -> {
        data.documentationUrl = context.getLazyString();
    }, FLAGS_ATTRIBUTE, (context, data) -> {
        data.isEnumFlags = true;
    }, GUID_ATTRIBUTE, (context, data) -> {
        data.guidConstant = CustomAttributeDecoder.createGuidConstant(context.getValue());
    }, NATIVE_TYPEDEF_ATTRIBUTE, (context, data) -> {
        data.isTypedef = true;
    }, STRUCT_SIZE_FIELD_ATTRIBUTE, (context, data) -> {
        data.structSizeField = (String)context.getValue().fixedArguments()[0].value();
    });
    private static final Set<QualifiedName> ignoredTypesAttributes = Set.of(new QualifiedName("System", "AttributeUsageAttribute"), new QualifiedName("System", "ObsoleteAttribute"), new QualifiedName("System.Runtime.InteropServices", "ComVisibleAttribute"), new QualifiedName("System.Runtime.InteropServices", "UnmanagedFunctionPointerAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "AgileAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "AlsoUsableForAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "AnsiAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "AssociatedConstantAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "InvalidHandleValueAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "MetadataTypedefAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "RAIIFreeAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "ScopedEnumAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "SupportedOSPlatformAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "UnicodeAttribute"));
    private static final Map<QualifiedName, Extractor<MethodCustomAttributeData>> methodAttributeExtractors = Map.of(SUPPORTED_ARCHITECTURE_ATTRIBUTE, (context, data) -> {
        data.supportedArchitecture = ((Number)context.getValue().fixedArguments()[0].value()).intValue();
    }, DOCUMENTATION_ATTRIBUTE, (context, data) -> {
        data.documentationUrl = context.getLazyString();
    }, CONSTANT_ATTRIBUTE, (context, data) -> {
        data.constantValue = context.getValue().fixedArguments()[0].value();
    });
    private static final Set<QualifiedName> ignoredMethodAttributes = Set.of(new QualifiedName("System", "ObsoleteAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "AnsiAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "CanReturnErrorsAsSuccessAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "CanReturnMultipleSuccessValuesAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "SupportedOSPlatformAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "UnicodeAttribute"), new QualifiedName("System.Diagnostics.CodeAnalysis", "DoesNotReturnAttribute"));
    private static final Map<QualifiedName, Extractor<FieldCustomAttributeData>> fieldAttributeExtractors = Map.of(DOCUMENTATION_ATTRIBUTE, (context, data) -> {
        data.documentationUrl = context.getLazyString();
    }, GUID_ATTRIBUTE, (context, data) -> {
        data.guidConstant = CustomAttributeDecoder.createGuidConstant(context.getValue());
    }, NATIVE_ENCODING_ATTRIBUTE, (context, data) -> {
        data.isAnsiEncoding = true;
    }, FLEXIBLE_ARRAY_ATTRIBUTE, (context, data) -> {
        data.isFlexibleArray = true;
    }, CONSTANT_ATTRIBUTE, (context, data) -> {
        data.constantValue = context.getValue().fixedArguments()[0].value();
    });
    private static final Set<QualifiedName> ignoredFieldAttributes = Set.of(new QualifiedName("Windows.Win32.Foundation.Metadata", "ConstAttribute"));
    private static final Map<QualifiedName, Extractor<ParamCustomAttributeData>> paramAttributeExtractors = Map.of(ASSOCIATED_ENUM_ATTRIBUTE, (context, data) -> {
        data.associatedEnumType = (String)context.getValue().fixedArguments()[0].value();
    });
    private static final Set<QualifiedName> ignoredParamAttributes = Set.of(new QualifiedName("Windows.Win32.Foundation.Metadata", "ComOutPtrAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "ConstAttribute"), DOCUMENTATION_ATTRIBUTE, new QualifiedName("Windows.Win32.Foundation.Metadata", "DoNotReleaseAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "FreeWithAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "IgnoreIfReturnAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "MemorySizeAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "NativeArrayInfoAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "NotNullTerminatedAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "NullNullTerminatedAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "RAIIFreeAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "ReservedAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "RetainedAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "RetValAttribute"));
    private final MetadataFile metadataFile;
    private final Primitive stringType;

    CustomAttributeDecoder(TypeLookup typeLookup, MetadataFile metadataFile) {
        super(typeLookup);
        this.metadataFile = metadataFile;
        this.stringType = typeLookup.getPrimitiveType(14);
    }

    TypeCustomAttributeData getTypeDefAttributes(int typeDef) {
        int typeDefIndex = CodedIndex.encode(2, typeDef, CodedIndexes.HAS_CUSTOM_ATTRIBUTE_TABLES);
        TypeCustomAttributeData data = new TypeCustomAttributeData();
        this.extractAttributes(typeDefIndex, typeAttributeExtractors, ignoredTypesAttributes, data);
        return data;
    }

    MethodCustomAttributeData getMethodDefAttributes(int methodDef) {
        int methodDefIndex = CodedIndex.encode(6, methodDef, CodedIndexes.HAS_CUSTOM_ATTRIBUTE_TABLES);
        MethodCustomAttributeData data = new MethodCustomAttributeData();
        this.extractAttributes(methodDefIndex, methodAttributeExtractors, ignoredMethodAttributes, data);
        return data;
    }

    FieldCustomAttributeData getFieldAttributes(int field) {
        int fieldIndex = CodedIndex.encode(4, field, CodedIndexes.HAS_CUSTOM_ATTRIBUTE_TABLES);
        FieldCustomAttributeData data = new FieldCustomAttributeData();
        this.extractAttributes(fieldIndex, fieldAttributeExtractors, ignoredFieldAttributes, data);
        return data;
    }

    ParamCustomAttributeData getParamAttributes(int param) {
        int paramIndex = CodedIndex.encode(8, param, CodedIndexes.HAS_CUSTOM_ATTRIBUTE_TABLES);
        ParamCustomAttributeData data = new ParamCustomAttributeData();
        this.extractAttributes(paramIndex, paramAttributeExtractors, ignoredParamAttributes, data);
        return data;
    }

    private <T> void extractAttributes(int hasCustomAttributeIndex, Map<QualifiedName, Extractor<T>> extractors, Set<QualifiedName> ignoredAttributes, T data) {
        for (CustomAttribute customAttribute : this.metadataFile.getCustomAttributes(hasCustomAttributeIndex)) {
            CodedIndex constructor = customAttribute.constructorIndex();
            assert (constructor.table() == 10);
            assert (constructor.index() != 0);
            MemberRef memberRef = this.metadataFile.getMemberRef(constructor.index());
            CodedIndex parent = memberRef.parentIndex();
            assert (parent.table() == 1);
            assert (parent.index() != 0);
            TypeRef typeRef = this.metadataFile.getTypeRef(parent.index());
            QualifiedName qualifiedName = new QualifiedName(this.metadataFile.getString(typeRef.typeNamespace()), this.metadataFile.getString(typeRef.typeName()));
            if (ignoredAttributes.contains(qualifiedName)) continue;
            Extractor<T> extractor = extractors.get(qualifiedName);
            assert (extractor != null);
            ExtractionContext context = new ExtractionContext(this, customAttribute, memberRef);
            extractor.extract(context, data);
        }
    }

    private CustomAttributeValue getValue(CustomAttribute customAttribute, MemberRef memberRef) {
        MethodSignature methodSignature = this.decodeMethodRefSignature(this.metadataFile.getBlob(memberRef.signature()));
        Blob valueBlob = this.metadataFile.getBlob(customAttribute.value());
        return this.decodeCustomAttributeValue(methodSignature, valueBlob);
    }

    private MethodSignature decodeMethodRefSignature(Blob signature) {
        signature.readByte();
        int paramCount = signature.readCompressedUnsignedInt();
        Type returnType = this.decodeType(signature, null);
        Type[] params = new Type[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            params[i] = this.decodeType(signature, null);
            assert (params[i] != null);
        }
        assert (signature.isAtEnd());
        return new MethodSignature(returnType, params);
    }

    private LazyString getLazyString(CustomAttribute customAttribute, MemberRef memberRef) {
        MethodSignature methodSignature = this.decodeMethodRefSignature(this.metadataFile.getBlob(memberRef.signature()));
        assert (methodSignature.paramTypes().length == 1);
        assert (methodSignature.paramTypes()[0] == this.stringType);
        Blob valueBlob = this.metadataFile.getBlob(customAttribute.value());
        LazyString value = this.decodeSingleStringValue(valueBlob);
        int numNamedArgs = valueBlob.readUInt16();
        assert (numNamedArgs == 0);
        assert (valueBlob.isAtEnd());
        return value;
    }

    CustomAttributeValue decodeCustomAttributeValue(MethodSignature methodSignature, Blob valueBlob) {
        int prolog = valueBlob.readUInt16();
        assert (prolog == 1);
        Type[] fixedParamTypes = methodSignature.paramTypes();
        int numFixedArgs = fixedParamTypes.length;
        ArgumentValue[] fixedArguments = new ArgumentValue[numFixedArgs];
        for (int i = 0; i < numFixedArgs; ++i) {
            assert (!(fixedParamTypes[i] instanceof Array));
            fixedArguments[i] = new ArgumentValue(fixedParamTypes[i], null, this.readElem(valueBlob, fixedParamTypes[i]));
        }
        int numNamedArgs = valueBlob.readUInt16();
        assert (numNamedArgs == 0);
        assert (valueBlob.isAtEnd());
        return new CustomAttributeValue(fixedArguments);
    }

    private LazyString decodeSingleStringValue(Blob valueBlob) {
        int prolog = valueBlob.readUInt16();
        assert (prolog == 1);
        int len = valueBlob.readCompressedUnsignedInt();
        int offset = valueBlob.offset();
        valueBlob.skip(len);
        return new LazyString(valueBlob.data(), offset, len);
    }

    private Object readElem(Blob blob, Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Primitive.class, EnumType.class}, (Object)type3, n)) {
            case 0 -> {
                Primitive primitive = (Primitive)type3;
                yield CustomAttributeDecoder.readPrimitiveVal(blob, this.typeLookup.getElementType(primitive));
            }
            case 1 -> {
                EnumType enumType = (EnumType)type3;
                yield CustomAttributeDecoder.readPrimitiveVal(blob, this.typeLookup.getElementType(enumType.baseType()));
            }
            default -> throw new IllegalArgumentException("Unsupported element type: " + type.getClass().getSimpleName());
        };
    }

    private static UUID createGuidConstant(CustomAttributeValue value) {
        ArgumentValue[] fixedArguments = value.fixedArguments();
        long a = 0xFFFFFFFFL & (long)((Integer)fixedArguments[0].value()).intValue();
        long b = 0xFFFFL & (long)((Short)fixedArguments[1].value()).shortValue();
        long c = 0xFFFFL & (long)((Short)fixedArguments[2].value()).shortValue();
        long mostSigBits = a << 32 | b << 16 | c;
        long leastSigBits = 0L;
        for (int i = 0; i < 8; ++i) {
            long v = 0xFFL & (long)((Byte)fixedArguments[i + 3].value()).byteValue();
            leastSigBits |= v << 56 - i * 8;
        }
        return new UUID(mostSigBits, leastSigBits);
    }

    @FunctionalInterface
    static interface Extractor<T> {
        public void extract(ExtractionContext var1, T var2);
    }

    record ExtractionContext(CustomAttributeDecoder decoder, CustomAttribute attribute, MemberRef memberRef) {
        CustomAttributeValue getValue() {
            return this.decoder.getValue(this.attribute, this.memberRef);
        }

        LazyString getLazyString() {
            return this.decoder.getLazyString(this.attribute, this.memberRef);
        }
    }
}

