/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.metadata;

import java.util.HashMap;
import java.util.Map;
import net.codecrete.windowsapi.metadata.ConstantValue;
import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.metadata.Type;

public class Namespace {
    private final String name;
    private final Map<String, Type> types = new HashMap<String, Type>();
    private final Map<String, Method> methods = new HashMap<String, Method>();
    private final Map<String, ConstantValue> constants = new HashMap<String, ConstantValue>();

    Namespace(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Type> types() {
        return this.types;
    }

    public Map<String, Method> methods() {
        return this.methods;
    }

    public Map<String, ConstantValue> constants() {
        return this.constants;
    }

    void addType(Type type) {
        assert (type.namespace() == this);
        this.types.put(type.name(), type);
    }

    void removeType(Type type) {
        assert (type.namespace() == this);
        Type removed = this.types.remove(type.name());
        assert (removed != null);
    }

    void addMethod(Method method) {
        assert (method.namespace() == this);
        this.methods.put(method.name(), method);
    }

    public void addConstant(ConstantValue constant) {
        assert (!this.constants.containsKey(constant.name()));
        this.constants.put(constant.name(), constant);
    }

    public String toString() {
        return this.name;
    }
}

